﻿USE sofia;
DROP TABLE IF EXISTS sofia.due_vpl;
CREATE TABLE due_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES due_vpl WRITE;
INSERT INTO due_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","I oyo ay listahan ni kaapoapohan ni Hisu Kristo a ginumapo de Debid ta ginumapo eya de Abraham. ");
INSERT INTO due_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Nano ay i Abraham ay ama ni Isak, ta i Isak ay ama ni Hakob, ta i Hakob ay ama ni Huda pati manga wele na a lalaki. ");
INSERT INTO due_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ta nagbebi i Huda a lalaki de Tamar ta napa ni anak na i Pares pati Sara, ta i Pares pan ay ama ni Esron, ta i Esron i ama ni Ram, ");
INSERT INTO due_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ta i Ram i ama ni Aminadeb, ta i Aminadeb i ama ni Nason, ta i Nason i ama ni Salmon. ");
INSERT INTO due_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ta nagbebi i Salmon de Rehab, ta napa ni anak na i Boos. Nagbebi pan i Boos de Rut, ta napa ni anak na i Obid, ta i Obid i ama ni Hesse, ");
INSERT INTO due_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ta i Hesse i ama ni Debid a Hari. Nano ay nagbebi i Debid de bebi ni Urias, ta napa ni anak na i Solomon, ");
INSERT INTO due_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ta i Solomon i ama ni Rehoboam, ta i Rehoboam i ama ni Abias, ta i Abias i ama ni Asa, ");
INSERT INTO due_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ta i Asa i ama ni Dosapat, ta i Dosapat i ama ni Doram, ta i Doram i ama ni Osias, ");
INSERT INTO due_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ta i Osias i ama ni Dotam, ta i Dotam i ama ni Akas, ta i Akas i ama ni Esekias, ");
INSERT INTO due_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ta i Esekias i ama ni Manases, ta i Manases i ama ni Amos, ta i Amos i ama ni Hosias, ");
INSERT INTO due_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ta i Hosias i ama ni Hekonias pati manga wele na a lalaki nun panahon a inikag ni tage Babalonia i manga Hudyo de bensa a Babalonia. ");
INSERT INTO due_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ta nun maikag di ide a Hudyo de bensa a Babalonia ay napa ni ama ni Salatiel i Hekonias ta i Salatiel ay napa ni ama ni Sorobabel, ");
INSERT INTO due_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ta i Sorobabel i ama ni Abiud, ta i Abiud i ama ni Eliakim, ta i Eliakim i ama ni Asor, ");
INSERT INTO due_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ta i Asor i ama ni Sadok, ta i Sadok i ama ni Akim, ta i Akim i ama ni Eliud, ");
INSERT INTO due_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ta i Eliud i ama ni Elieser, ta i Elieser i ama ni Matan, ta i Matan i ama ni Hakob, ");
INSERT INTO due_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ta i Hakob i ama ni Hose a bebi ni Maria. I eya i ina ni Hisus a pengalanan a Kristo. ");
INSERT INTO due_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kanya te duman a sangpuwu pati apat a kaapoapohan gepo de Abraham a sinumunudsunud hanggen de Debid pati sangpuwu pati apat a kaapoapohan gepo de Debid a sinumunudsunud hanggen de pag-ikag dide de bensa a Babilonia pati pan te duman a sangpuwu pati apat a kaapoapohan a sinumunudsunud gepo de pag-ikag dide de bensa a Babilonia hanggen de Kristo. ");
INSERT INTO due_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Magioyo i sinumapit nun pinanganak i Hisu Kristo. I Maria a ina na pati Hose ay magkásungdu di misan ay dingan ngona ide nagpakasal ay katinggesan ni Maria a gelihe di eya dehil de kapangyedihan ni Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nano i Hose a nappa ni bebi na ay piyon i innawa na a agta ta an na buot a maamamos i Maria kanya te belak eya a an di nekipagkasungdu de Maria ni an ketinggesan ni kamakmokan. ");
INSERT INTO due_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Misan nun peuluesip na i maginon ay nagpakita diya de pangnenop i isin a anghel nun Panginoon a Makedepat. Sinabi na diya, “Hose ka a ginumapo de Debid, wet ka kumapoy de Maria a kasungdu ta gelihe eya dehil de Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ta nánganak eya ni isin a lalaki. Ngangalanan mo eya ni Hisus a magliligtas ta pakeeyenan na ni mammalotin i kaagtaan a geabut diya.” Inon i sinabi ni anghel de Hose. ");
INSERT INTO due_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nano ay nangyedi inon a pesan tangani pamatoden i pinangako nun Panginoon a Makedepat de padean ni magsasabi na a Isais. ");
INSERT INTO due_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ta sinabi na a, “Gelihe i isin a maddikit ta nánganak ni isin a lalaki a ngangalanan a Emanuel.” I kabuluhan ninon a ngalan ay “Kakoloytam i Makedepat”. ");
INSERT INTO due_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kanya nun napagiyos di i Hose ay tinumalinga eya de pagdodul diya ni anghel nun Panginoon a Makedepat ta pinakasalan na i Maria. ");
INSERT INTO due_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Misan an pelanean ni Hose i Maria hanggen an pepanganak i anak a lalaki. Nginalanan ni Hose i kilasaan a Hisus. ");
INSERT INTO due_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nano ay nun pinanganak i Hisus de benwaan a Betlehem de sákup ni Hudia ay Herod i hari nun nanon a panahon. Nun ampa náloy a pinanganak i Hisus ay dinumatong de Herusalem i tipide a lalaki a naketingges a inumapo de kadepit a petangaan ni adow. ");
INSERT INTO due_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ta nagtulutanto duman, “Deno pinanganak eya a hari ni manga Hudyo ide ta nakitan mi i butatala de petangaan ni adow a tande de pagdetong na dio de putok i kanya dinumio kami tangani podiin mi eya.” ");
INSERT INTO due_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nun nabereta inon ni Hari a Herod ay nagulo i esip na pati kakmukan de benwaan a Herusalem. ");
INSERT INTO due_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kanya tinipun na i pesan a ponu ni maghahandug ide pati magtutodu ide ni Hudyo ta tinanto na ide, “Ti deno man pánganak i Kristo a Pinangako nun Makedepat?” ");
INSERT INTO due_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ay tinumubeg ide, “De benwaan a Betlehem de sákup ni Hudia ta sinolat ni isin a magsasabi a magioyo, ");
INSERT INTO due_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Dikamo a manga tage Betlehem de sákup ni Hudia ay sasabi ko a namas pa a halage i benwaan yu de pesan a benwaan a Hudia ta dikamo náapo i isin a pinakaponu a nappa ni mag-aalage de manga agta a Hudyo.’” Inon i sinabi ni magtutodu ide de Hari a Herod. ");
INSERT INTO due_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagkatapos ay pinakangan ni Herod a linimok i lalaki ide a naketingges ta tinanto na ide a ti kapide tinumanga un butatala a tande. ");
INSERT INTO due_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ta nun pagkatingges na ay pinakang na ide de Betlehem ta sinabi na, “Kumang kamo ta lawagin yu a masakut un anak ta be kinta yu di ay patinggesin yu deko tangani gepodi ok pala diya.” ");
INSERT INTO due_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nun inikna de i sinabi ni Hari ay tinumotul di ide ta i butatala a tande a kinta de nun duman pa ide de bensa de ay kinta de pan di a liwet. Ay nagkasalig ide a masakut nun kinta de inon a butatala ta inumona inon dide hanggen an tinumipong de petaanan ni anak. ");
INSERT INTO due_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pagkasilong de nunde beloy ay kinta de i anak pati ina na a Maria. Ta linumuhud ide a nagpodi de anak ta dingan kinayesan de un oniden de ta naghandug ide diya ni ginto pati mebengo a mira pati insensu. ");
INSERT INTO due_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pagkatapos ninon ay pinagsabian ide de pangnenop a wet ide nesila de Herod pag-ampulang de bensa de kanya tinumotul ide de bukud a bektas. ");
INSERT INTO due_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nano ay nun pagkatotul de ay te isin a anghel nun Panginoon a Makedepat a nagpakita de Hose de pangnenop ta sinabi na diya, “Gumiyos ka di ta addein mo a tambing i maginak de bensa a Ihipto. Ta wet kamo nototul duman hanggen ang ko pesabi ta lalawag ni Herod i anak i tangani bobuno na.” ");
INSERT INTO due_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kanya ginumiyos di i Hose ta inadde na nun abi pala a inon un maginak de bensa a Ihipto. ");
INSERT INTO due_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ta duman ide tinumaan hanggen an nagkelibun i Herod. Nangyedi yo tangani pamatoden i sinabi ni Panginoon a Makedepat de padean ni magsasabi na a, “Oolangan ko i anak ko gepo de bensa a Ihipto.” ");
INSERT INTO due_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nano ay nun i Herod ay te edup pa ay nagbulas eya a masakut nun kinatinggesan na a dinaya eya ni lalaki ide a naketingges kanya pinabuno na un mangának a lalaki a am pa sobra de aduwa a taon de Betlehem pati de pulupalebut na a pesan. Ta inon ay nappaayun de pinatingges diya ni naketingges ide tungkul de panahon a pagtanga ngona ni butatala de bensa de. ");
INSERT INTO due_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ta de maginon aypinamatoden di i sinabi ni magsasabi a Heremias a, ");
INSERT INTO due_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Te duman a busis a gehagulhol a malagdu de lugel a Rama ta getangos i Rakel a an nagkalibeng dehil de mangának na a nalibunin di.” ");
INSERT INTO due_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nano pagkalibun ni Herod ay i isin a anghel nun Panginoon a Makedepat ay nagpakita de pangnenop de Hose de bensa a Ihipto ta sinabi na diya, ");
INSERT INTO due_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Gumiyos ka ta uliin mo un maginak de sákup ni Hudia ta nalibun di i te belak a nomuno de anak i.” ");
INSERT INTO due_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dingan ginumiyos eya ta inuli na un maginak de sákup ni Hudia. ");
INSERT INTO due_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Misan nun naberetaan na a i Arkilao i gehari de Hudia a kalewes ni ama na a Herod ay natakut eya a nátaan duman a liwet pati pan pinagsabian eya ni Makedepat de pangnenop kanya kinumang ide de porobinsia a Galilea ");
INSERT INTO due_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","a tinumaan de benwaan ni Nasarit. Ta de maginon ay pinamatoden i sinabi ni magsasabi ide a, “Eya ay ngangalanan a tage Nasarit.” ");
INSERT INTO due_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nano ay nun tinumakig di i makmuk a taon ay dinumatong i Huwen a Maglilenod de lugel a ilang de Hudia ta ginumapo a nagbereta a magioyo duman a, ");
INSERT INTO due_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Magipinagsosol kamo ni mammalotin yu ta nádetong di i panahon a te kapangyedihan i Makedepat de innawa ni agta ide.” ");
INSERT INTO due_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","I Huwen un sinabi nun magsasabi a Isais nun sinabi na a magioyo, “Nádetong i geolang de lugel a ilang. Gesabi eya a, ‘Handein yu i bektas para de Panginoon ta tanusin yu i sesilan na.’” Inon i sinolat ni Isais. ");
INSERT INTO due_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nano i bedu ni Huwen ay linala a sapok ni hayup ta i beyakos na pan ay katat ni hayup ta i pepangan na pan ay magi salagubeng pati tagis ni pisokan. ");
INSERT INTO due_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ta kinumang diya i kamakmokan a tage Herusalem pati tage sákup ni Hudia pati ide a getaan de magduludipa ni Orat a Horden. ");
INSERT INTO due_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ta pagkapagpamatud de ni mammalotin de ay lininodlinod ide ni Huwen de Orat a Horden. ");
INSERT INTO due_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Misan nun kinta na i makmuk a Pariseo ide pati Saduseo a linumane diya tangani magpalinod ide diya ay sinabi na dide, “Malot kamo ngani a magi manga bebek kanya wet yu peesipa a ikamo ay nakeelag de padusahan ni Makedepat dehil de pagsosol yu de surut yu la. ");
INSERT INTO due_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ta nagkaddepat pan a i pagsosol yu de surut yu ay gekaanak ngona ni piyon a ugeli. ");
INSERT INTO due_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pati wet kamo gesabi a ikamo ay nalligtas dehil de ikamo ay mangápo a sagu ni Abraham ta pesabi ko dikamo a te kaya i Makedepat a nameedup de beto ide a oyo a nappa ni matud a mangápo ni Abraham. ");
INSERT INTO due_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nano pa ay i paghatol ni Makedepat ay magi palakol a napahaya di de gemut ni kew ta i belang kew a an geanak ni piyon ay popugtus ta wewitik de apoy.” Inon i sinabi na de Pariseo ide pati Saduseo ide. ");
INSERT INTO due_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ta sinabi na pa de pesan a, “Pelinod ko di ikamo de orat a tande de pagsosol yu. Misan ay te nádetong pa a nappaabut deko a namas pa a te kapangyedihan deko ta anok te sukul a kapangyedihan a nángadde ni paragetus na ta eya pan i nanlelinod dikamo de Ispiritu nun Makedepat pati de apoy. ");
INSERT INTO due_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ta pagdetong na ay te pansidi dingan lalayu na i tap de biges ta tetipun na de kamalig i biges misan ay i tap pan ay sosunug na de apoy a an nagkapalong.” Inon i sinabi ni Huwen. ");
INSERT INTO due_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nun nanon a panahon ay dinumatong i Hisus a inumapo de sákup ni Galilea ta linumane eya de Huwen tangani linodin na de Orat a Horden. ");
INSERT INTO due_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Misan i Huwen ay an na buot i maginon ta sinabi na, “Ako i depat a linodin yu. Ano ta ikamo i dinumio a gepalinod deko?” ");
INSERT INTO due_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tinumubeg i Hisus, “Pabiyaan mo di i oyo a nangyeyedi ta depat la a tumalinga kitam de misan ano a kabuotan nun Makedepat.” Kanya tinumalinga di i Huwen. ");
INSERT INTO due_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ay nun lininod di i Hisus ay sinumaka eya a tambing de mamala ta tambing a nakayesán i langot ta kinta ni Huwen a linumusong de Hisus i Ispiritu nun Makedepat a magi kalapati. ");
INSERT INTO due_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ta dingan te nagsurut a inumapo de langot a magioyo, “I oyo i pebuot ko a anak ta dehil diya ay nagkasalig ok a masakut.” ");
INSERT INTO due_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pagkatapos di ninon ay inikag ni Ispiritu i Hisus de lugel a ilang tangani sosubukan ni Satanas a petukso. ");
INSERT INTO due_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nun duman di eya ay an namangan ni misan ano nun apat a puwu a adow ay dingan natigeng di eya a masakut. ");
INSERT INTO due_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ta dinumatong i Satanas a sinabi na diya, “Be ikamo i matud a Anak nun Makedepat ay yediin yu a tinapay i beto ide a oyo.” ");
INSERT INTO due_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Misan tinubeg eya ni Hisus ni magioyo, “Ay te duman de kasulatan a, ‘An la dehil de pápangan nagkeedup i agta ta de belang surut a geapo de Makedepat.’” ");
INSERT INTO due_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ay dingan inikag eya ni Satanas de Herusalem de tibing ni palokoan ni beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ta sinabi pa diya ni Satanas, “Be matud kamo a Anak nun Makedepat ay tumagbong kamo gepo dio ta te duman de kasulatan a, ‘Pinagtutugun ni Makedepat de manga anghel na ide tangani aalagean de ikamo. Ta bobolan kamo ni kumot de tangani wet kamo nassingkog de kabetoan.’” ");
INSERT INTO due_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Misan ay sinabi diya ni Hisus, “Matud ngan non misan ay te duman pala de kasulatan a, ‘Wet mo sosubukan i Panginoon mo a Makedepat.’” ");
INSERT INTO due_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pagkatapos ninon ay inikag ni Satanas i Hisus de maditas a masakut a kalasan ta pinasayed na diya i pesan a nasasakopan dio de putok i pati kayamanan dio. ");
INSERT INTO due_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ta sinabi diya ni Satanas, “Talage a boboy ko i kapangyedihan ni pesan a oyo dikamo be noluhud kamo a gepodi deko.” ");
INSERT INTO due_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dingan tinubeg ni Hisus, “Lumayu ka deko Satanas ta te duman de kasulaton a, ‘Magpodi ka la de Panginoon mo a Makedepat ta diya ka la magtabeng.’” ");
INSERT INTO due_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ta dingan winalat eya ni Satanas ta dinumatong pan di i manga anghel ide a tinumabeng diya. ");
INSERT INTO due_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nano ay nun nabereta ni Hisus a nabbilanggo di i Huwen ay inumampulang eya de Galilea. ");
INSERT INTO due_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Misan an di eya nappataan de Nasarit ta de Kapernam a benwaan de kaginglan ni uluataben a Galilea de lugel ni Sabulan pati Neptali. ");
INSERT INTO due_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ta de maginon ay pinamatoden i sinabi ni magsasabi a Isais a, ");
INSERT INTO due_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Gesurut ok dikamo a getaan de dipa ni Horden de lugel a Galilea a te makmuk a an Hudyo a ikamo a tage lugel a Sabulan pati Neptali a kadepit de uluataben. ");
INSERT INTO due_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Gesurut ok dikamo a an te katinggesan tungkul de Makedepat ta magi madumos i esip yu a nagkatakut a ugnay de kalebunin yu misan ay nekita kamo ni kamatoden a tallang ta pepatallang di i esip yu ni Panginoon.” Inon i sinabi ni Isais. ");
INSERT INTO due_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gepo nun nanon ay nagsabi i Hisus ni piyon a bereta ta sinabi na, “Magipinagsosol kamo de mammalotin yu ta nádetong di i panahon a te kapangyedihan i Makedepat de innawa ni agta ide.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nano ay nun getotul i Hisus de kaginglan ni uluataben a Galilea ay kinta na un aduwa a magwele a i Simon a pengalanan a Pedro pati Andres a weli na ta gesabud ide. Ta ide ay mag-iekan. ");
INSERT INTO due_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sinabi dide ni Hisus, “Sumut kamo deko ta ikamo ay yeyedi ko a mag-aakit ni agta tangani nosut pala ide deko a tuloy.” ");
INSERT INTO due_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ta nun nanon pala ay winalat de un sabud de a sinumut ide de Hisus. ");
INSERT INTO due_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Pagkalayu de ni untik ay kinta na pala i magwele a Santiago pati Huwen a mangának ni Sebedeo. Ta ide pati ama de ay gepakapiya ni pokut de nunde bengka de. Ide ay inikag pala ni Hisus ");
INSERT INTO due_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","kanya tambing de a winalat i bengka de pati ama de ta sinumut ide de Hisus. ");
INSERT INTO due_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nano ay kinumulukang i Hisus de bulubenwaan de sákup ni Galilea a nagtodu eya de pigmitengan ide ni Hudyo ide. Ta nagsabi eya ni piyon a bereta a ti papalano a te kapangyedihan i Makedepat de innawa ni agta pati nagpapiyon pala eya ni agta ide misan ano a orom de. ");
INSERT INTO due_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ta kinumálat i bereta a tungkul diya de pesan a lugel de sákup ni Siria kanya inadde de diya i manga agta a te attanan a kalase a orom pati apdis, i te manga libong ide, i nagkopugtusan ide pati lungpo ide ta pinapiyon na ide a pesan. ");
INSERT INTO due_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ta inumabut diya i makmuk a agta a tage lugel ni Galilea, Dikapolis, Hudia, benwaan a Herusalem pati lugel de dipa a Orat a Horden. ");
INSERT INTO due_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nun kinta ni Hisus i agta a makmuk ay sinumakat eya de kalasan ta pagkalipa na duman ay linumane diya i mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ta ginumapo eya a getodu dide ta sinabi na, ");
INSERT INTO due_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Piyon i kapuoyen ni agta a te pag-asa la de Makedepat ta te kapangyedihan dide i Makedepat a nanleligtas. ");
INSERT INTO due_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Piyon i kapuoyen ni nagkolungkut a getangos ta te duman ide ngani a kasalegen. ");
INSERT INTO due_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Piyon i kapuoyen ni te masidong a innawa ta tatanggep de i pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Piyon i kapuoyen ni te hanga a pagbuot a geyedi ni kabuotan ni Makedepat ta ide ay pakebiyag ni kapiyonan na. ");
INSERT INTO due_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Piyon i kapuoyen ni te piyon a innawa de kapadpade de a agta ta i Makedepat ngani i gekalbi dide pala. ");
INSERT INTO due_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Piyon i kapuoyen ni te buot a gepakikaisin diya ta kekita de ngani i Makedepat. ");
INSERT INTO due_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Piyon i kapuoyen ni gepapiyon de agta a gekipagtalo ta nappa ni anak ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Piyon i kapuoyen ni te kahedepan dehil de pagpamatud de tungkul de Makedepat ta te kapangyedihan di i Makedepat dide a nanleligtas. ");
INSERT INTO due_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Piyon i kapuoyen yu be ikamo ay pelibek, pepahedepan o pesabian ni mammalotin a kabutelan dehil de pagpanulusun yu deko. ");
INSERT INTO due_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Masalig kamo ngani a masakut ta hanga ngani a masakut i bilos yu de kataanan nun Makedepat. Ta maginon pala i yinadi a malot ni kaapoapohan de de magsasabi ide a den. ");
INSERT INTO due_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ikamo i asin dio de putok i ta te halage ngani dio a magi asin i pagpanulusun yu de Makedepat misan be nappa ni mahena i pagpanulusun yu a magi asin a naeyenan i alat na ay talage a an di te kabuluhan. Talage ay an di te kabuluhan a unabis ta bobut la ni agta ide a pesikadsikaden de. ");
INSERT INTO due_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ikamo i salong a getallang de madumos a esip ni kaagtaan dio de putok i ta ikamo ay pekita ni kaagtaan a magi isin a benwaan a nappauddi de disapow ni pagotan. ");
INSERT INTO due_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Talage a be te duman a getutud ni salong ay an na sasakloben ni takálan ta popuoy na pan de talage a pigpuoyen na ta de maginon ay nátallangan i pesan a de disalad ni beloy. ");
INSERT INTO due_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","De maginon pala ay depat a ikamo ay te piyon a ugeli de kaagtaan a magi salong a getallang de pekita de tangani pagkakita de de piyon a ugeli yu ay gepodi ide nunde Ama yu de langot. ");
INSERT INTO due_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nano ay wet yu eesipa a dinumio ok a peeyenan ko ni kabuluhan i pagdodul ide pati pagsabi ni magsasabi ide a den ta an non matud ta dinumio ok tangani pepamatoden ko i kapangyedihan ni kasulatan nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Talage a matud aypesabi ko dikamo a neeyen di i langot pati putok misan ay an neeyenan i misan isin a tolduk o guhit de surut na hanggen an gepangyedi pala i pesan. ");
INSERT INTO due_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kanya i misan ino a an getalinga de misan untik a pagdodul nun Makedepat, a getodu pala de manga agta ay nappa ni an pinakamahalage ide de pekita ni Makedepat. Misan i getalinga pan de misan untik a pagdodul, a getodu pala de manga agta ay nappa ni pinakamahalage de pekita na. ");
INSERT INTO due_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta pesabi ko ngani dikamo be i pagtalinga yu de kabuotan ni Makedepat ay an namas pa de pagtalinga ni Pariseo ide pati magtutodu ide ni Hudyo ay ang kamo ngani nakesilong de kataanan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Katinggesan yu i pagtodu ni kaapoapohan tam ide nun nowon a wet kamo nomuno ta i misan ino a nomuno ay depat a hahatolan ni huwis. ");
INSERT INTO due_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Misan ay nano ay pesabi ko dikamo a i belang nagkagensa de kabinsa na ay te sukul a kasalanan a depat a eikag de huwis. Ta i misan ino a miglibek de kabinsa na ay depat a eikag de pinakamatande ide pati i misan ino a nagpaeyen ni kabuluhan ni kábinsa na ay te kasalanan a sukul a podusahan de impiyerno. ");
INSERT INTO due_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kanya be gehandug ka de Makedepat de pighandogen na dingan naisepan mo pan a te tinanom a gengsa i kabinsa mo dikaw, ");
INSERT INTO due_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ay walatin mo ngona i handug mo duman de pighandogen ta kumang ka de kabinsa mo a makipagkasungdu ka diya. Ta dingan la umampulang ka a maghandug de Makedepat. ");
INSERT INTO due_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nano be te gehabla dikaw de huwis ay depat ngona duman de bektas a makipagkasungdu ka a tambing de gehabla dikaw tangani wet na ikaw eikag de huwis ta boboy ka pan ni huwis de pulis dingan bebilanggo ka pan ni pulis. ");
INSERT INTO due_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Talage ay pesabi ko dikaw a ang ka nakobulwag hanggen am mo nabebeyeden i kauluinapóan mo a otang a pera. ");
INSERT INTO due_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nano ay katinggesan yu pan i pagtodu ni kaapoapohan tam ide nun nowon a, ‘Wet kamo nekialam de bebi ni kakmukan.’ ");
INSERT INTO due_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Misan nano ay pesabi ko dikamo a i misan ino a gepakalawag de bebi ni kakmukan a te malot de innawa na ay de pekita ni Makedepat ay nakialam di eya de bebi ni kakmukan. ");
INSERT INTO due_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kanya be i mata mo i gepapagkasala dikaw ay depat a lugitin mo a butin mo di ta yadi pa dikaw a mabut i isin a panggemit ni lawes mo tangani i lawes mo ay wet nappaduman de impiyerno. ");
INSERT INTO due_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Pati be i kumot mo a awenan i gepapagkasala dikaw ay depat a pugtusin mo a butin mo di ta yadi pa dikaw a mabut i isin a panggemit ni lawes mo tangani i lawes mo ay wet nappaduman de impiyerno. ");
INSERT INTO due_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“I pagtodu ni kaapoapohan tam ide nun nowon ay magioyo a, ‘Be kekiblagen ni lalaki i bebi na ay depat a bebiyen na ni kasulatan i mahuna a ide ay nagkiblag di.’ ");
INSERT INTO due_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Misan nano ay pesabi ko dikamo a be kekiblagen ni lalaki i bebi na a am pan te kasulit a kakmukan a lalaki ay gepapagkasala ngani i lalaki de kiniblagen na. Ta be magbebi a liwet i mahuna ay nappa ni migpakialam eya pati bebi na a bowon. ");
INSERT INTO due_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Pati katinggesan yu pala i pagtodu ni kaapoapohan tam ide nun nowon a, ‘Wet kamo gesumpa ni kabutelan ta matudin yu i pinangako yu de Panginoon a Makedepat.’ ");
INSERT INTO due_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Misan nano ay pesabi ko dikamo a wet kamo gesumpa a magi langot o i putok o i Herusalem i gepamatud de surut yu ta i langot i piglipaan ni Makedepat, ta i putok pan i pigsikaden ni singit na ta i Herusalem ay i benwaan ni Makapangyedihan a Hari. ");
INSERT INTO due_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pati wet kamo gesumpa a magi ulo yu i gepamatud de surut yu ta ang kamo te kaya a geyedi ni sapok de ulo yu a malatom o malapsay. ");
INSERT INTO due_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kanya sukul di i sasabi yu a, ‘Ay-o’ o ‘Eyen’ ta i kadugeng de inon a surut ay inumapo de Satanas. ");
INSERT INTO due_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Katinggesan yu pala i pagtodu a den a, ‘Be sinede yu i mata pati ngipon ni kakmukan ay depat pala a sesede de i mata pati ngipon yu.’ ");
INSERT INTO due_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Misan nano ay pesabi ko dikamo a wet yu bebilosan i geyedi ni malot dikamo ta be petampal na i awenan yu a pasingil ay pakadepit yu un dibelew. ");
INSERT INTO due_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pati be hinabla kamo ni misan ino tangani maamit na i bedu yu ay boyin yu pati kulapyaw yu. ");
INSERT INTO due_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pati pan be pepelit a paadde dikaw ni te kapangyedihan i adde na de isin a kilometro ay adden yu pan ni aduwa. ");
INSERT INTO due_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Biyen yu i belang geaged dikamo ta paidemin yu i belang geidem dikamo. ");
INSERT INTO due_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Katinggesan yu pan i pagtodu a den a, ‘Buotin yu i mangáyun yu ta kagengsaan yu i kapagebuk yu ide.’ ");
INSERT INTO due_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Misan nano pan ay pesabi ko dikamo a buotin yu i kapagebuk yu ide ta magpanalangin kamo pan nunde gepahedep dikamo. ");
INSERT INTO due_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ta de maginon ay pepamatoden yu a ikamo ay matud a anak ni Ama yu de langot. Ta eya pan ay an te pepeta ta pepatipá na un adow na de mammalotin a agta pati de pippiyonin ta eya i gekalbi de pesan, a geboy pala ni tapuk de geyedi ni piyon pati de geyedi ni malot. ");
INSERT INTO due_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nano be ikamo ay gebuot la de belang gebuot dikamo ay talage a ang kamo pagkasalegen ni Makedepat ta misan i makikkakasalanan ide ay gebuot pala de belang gebuot dide. ");
INSERT INTO due_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pati be i pebeti yu la ay i manga kabinsa yu ay ang kamo te pagyedi a namas pa a masampat de kakmukan ta misan i gepodi de makedepat ide a an matud ay peyedi de pala i maginon. ");
INSERT INTO due_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kanya ikamo ay depat a kalbian yu i agta a magi pagkalbi dide ni Ama yu de langot. ");
INSERT INTO due_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nano ay mag-engat kamo a wet te piyon la a ugeli de pekita ni agta tangani podiin de ikamo. Ta be maginon i yeyedi yu ay ang kamo bebilosan ni Ama yu de langot. ");
INSERT INTO due_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kanya be geboy kamo ni tabeng yu a kuwarta de te kaelangan ide ay wet yud beretaa de pesan i yinadi yu a magi ide de pigmitengan ide pati de kulukarsade ide, a geboy la ni tabeng tangani podiin ide ni kaagtaan. Ta talage a tinanggep di ni geboy de pekita ni agta i bilos de a pagpodi ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Misan be ikamo ay geboy ni tabeng a kuwarta de agta ay wet yu patinggesa misan de ayun yu a masakut, ");
INSERT INTO due_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ta taguin yu i pagboy yu ni tabeng. Ta i Ama yu a Makedepat a gekita ni pagyedi yu a nattagu ay bebilosan na ngani ikamo. ");
INSERT INTO due_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pati be ikamo ay gepanalangin ay wet kamo tumolad de agta ide a geyedi la ni piyon tangani podiin ide ta buot de a masakut a nanalangin a nappauddi de pigmitengan ide pati de kulukarsade ide tangani pekita la ide ni kaagtaan. Pesabi ko ngan dikamo a tinanggep de di i bilos de. ");
INSERT INTO due_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Misan ikamo be gepanalangin kamo ay sumilong kamo de disalad ni pig-idean yu ta abetan yu i pintohan ta dingan manalangin kamo de Ama yu a an pekita ni kaagtaan. Ta eya a gekita ni pagyedi yu a nattagu ay bebilosan na ngani ikamo. ");
INSERT INTO due_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pati de pagpanalangin yu ay wet yu gemita i makmuk a surut a magi peyedi ni agta a gepodi de makedepat ide a an matud ta peesip de a pepatalikngan ide ni makedepat de dehil de makmuk a surut de a an te kabuluhan. ");
INSERT INTO due_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wet kamo tumolad dide ta katinggesan di ni Ama yu i kaelangan yu dingan kamo ngona nanalangin diya. ");
INSERT INTO due_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ta magioyo i pagpanalangin yu, ‘Ama de langot a pepodian mi, buot mi tebe a magpodi dikamo i pesan a kaagtaan, ");
INSERT INTO due_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","a gekaduman pala i innawa de ni kapan-yedihan yu, a yeyedi de pan i kabuotan yu dio de putok i a magi peyedi ni katabeng yu de langot. ");
INSERT INTO due_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Biyen yu ikami ni sukul a pápangan mi, adow adow. ");
INSERT INTO due_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pati pakeeyenan yu ikami ni mammalotin mi a magi pagpatáwad mi pala de nagkasala dikami. ");
INSERT INTO due_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ta wet yu ikami pabiyaan de pagsubuk a mahigpetin pati palayuin yu dikami i Satanas. Ta ikamo i te kapangyedihan, tibong pati gepakaingap magpakapide pa man. Iwina i matud.’ ");
INSERT INTO due_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nano be pepatáwad yu i nagkasala dikamo ay patáwad pala ni Ama yu i mammalotin yu. ");
INSERT INTO due_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Misan ay be an yu pepatáwad i nagkasala dikamo ay am pala patáwad ni Ama yu de langot i mammalotin yu. ");
INSERT INTO due_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nano pan be gepanalangin kamo a an gepangan ni untik a panahon ay wet nappa ni malungkut i ropa ni mukha yu a magi ide a geyedi ni maginon tangani podiin la ide ni agta. Ta de patulutotul de ay pepamalot de i mukha de tangani aabuyenan ide a an gepangan ni untik a panahon. Talage ay pesabi ko dikamo a tinanggep de di i bilos de a i pagpodi ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Misan pan ay ikamo be gepanalangin a an gepangan ni untik a panahon ay magsuklay kamo ni sapok yu pati mag-uges kamo ni mukha yu ");
INSERT INTO due_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tangani wet aabuyenan ni manga agta a ikamo ay an gepangan ni untik a panahon. Ta i Ama yu de langot a an pekita ni agta i gepakaabuya ni oyo ta eya a gekita ni pagyedi yu a nattagu ay bebilosan na ngani ikamo. ");
INSERT INTO due_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Wet kamo magtipun ni kayamanan dio de putok i ta te nansesede dio a hayup pati kalawang pati migpannakow a geamit de inon ide. ");
INSERT INTO due_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ta piyon pa a tipunin yu i kayamanan yu de kataanan ni Makedepat a i piyon a pagyedi yu. Ta duman ay an te nansesede a hayup, kalawang, pati migpannakow a geamit de inon ide. ");
INSERT INTO due_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta talage a ti deno i yaman yu misan de putok i o de langot ay duman pala i innawa yu pati esip. ");
INSERT INTO due_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nano i mata yu ay magi salong de lawes yu kanya be an mebu i mata yu ay matallang ni kapiyonan i lawes yu. ");
INSERT INTO due_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Misan be mebu i mata yu ay an matallang i lawes yu ni kapiyonan kanya depat kamo di a magipinag-engat tangani wet nadeog ni malot a naddeinnawa yu i kapiyonan a geapo de Makedepat a magi salong a napalong. ");
INSERT INTO due_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nano ay an nappatud a i isin a katabeng ay nátabeng de aduwa a panginoon a sabey. Ta be maginon ay kagengsaan na i isin ta bobuot na pan i káduwa o gegelang na i isin ta i káduwa pan ay peeyenan na ni kabuluhan. Talage a ang kamo nappatud a getabeng de Makedepat be i peesip yu la ay i kayamanan yu dio de putok i. ");
INSERT INTO due_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kanya ko pesabi di dikamo a wet magulo i esip yu a tungkul de dikamo a edup a ti ano i pápangan yu o misan de dikamo a lawes a ti ano i bedu yu a pantaklop. Ta i edup yu pati lawes yu ay namas pa a mahalage de pápangan pati bedu. ");
INSERT INTO due_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pagelawagin yu ngani i manok na ide ta an ide gepinagpasok, a an ide gepinagguto pati an ide te kamalig misan ay peungut ide ni Ama yu de langot. Kanya oungut na ikamo a talage ta namas kamo pa a mahalage de manga manok ide. ");
INSERT INTO due_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kanya wet magulo i esip yu ta ang kamo te kaya a nakapepaanduwon ni edup yu misan isin la a odes. ");
INSERT INTO due_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Pati an piyon a magulo i esip yu tungkul de bedu yu ta pagelawagin yu i bulaklak ide de kapadengan a ti papalano a gehanga ta am pan ide gepagel, a am pa ide geti. ");
INSERT INTO due_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Misan ay pesabi ko ngan dikamo a misan i Hari a Solomon a migbedu ni masampatin ay angani nakapagbedu ni magi kasampat ni manga bulaklak ide a oyo. ");
INSERT INTO due_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kanya be pepabeduan ni masampat ni Makedepat i kademoan de kapadengan a nagkeedup la nano, a an di diage, a gegetong la de apoy ay namas kamo pangani a bebeduan ni Makedepat. Talage ay untik i pagpanulusun yu diya. ");
INSERT INTO due_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kanya wet magulo i esip yu tungkul de pápangan yu, einom pati bebedu yu. ");
INSERT INTO due_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ta i oyo ngani i pagkogulo ni esip ni pesan a agta dio de putok i misan ay katinggesan ni Ama yu de langot i pesan a kaelangan yu dio. ");
INSERT INTO due_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kanya ikamo pan ay depat a pabiyaan yu ngona i Makedepat a te kapangyedihan de innawa yu, a lalawag yu pala i kabuotan na ta dingan gekaduman kamo ni pesan a kaelangan yu. ");
INSERT INTO due_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kanya wet magulo i esip yu a ti ano i keedup yu de nádetong a adow ta i Makedepat i behala ta sukul di a i pagkagesá yu ay para de nano la a adow. ");
INSERT INTO due_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Wet mo pebintangan i misan ino tangani wet ka hahatolan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ta hahatolan ka ni Makedepat a nappaayun de paghatol mo de kakmukan ta i pansokat a pegemit mo de kakmukan ay eya pala i gegemit na dikaw. ");
INSERT INTO due_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kanya an depat a pelawag mo i kasalanan ni kabinsa mo a magi ulap de mata na ta misan ikaw pan ay am mo pesapot i namas pa a kasalanan mo a magi buwal de mata mo a sadili. ");
INSERT INTO due_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Talage ay an nagkaddepat a sasabi mo de kabinsa mo a, ‘Magsosol ka ni kasalanan mo.’ Ta ikaw pan ay am pala gesosol. ");
INSERT INTO due_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kanya depat ngona a magsosol ka dingan pa nappatud a sasabi mo de kabinsa mo a, ‘Depat ka a magsosol de kasalanan mo ide.’ Ta be maginon ay ang ka ngani i gekapoy ni malot de surut mo la. ");
INSERT INTO due_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nano ay wet kamo gesabi ni kamatoden ni Makedepat pati mahalage a katinggesan yu de agta a an te buot de inon. Ta be maginon ay magi mangásu ide a nákaget dikamo pati magi bebuy ide a sesikaden de la inon a perlas yu. ");
INSERT INTO due_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ay tungkul de pagpanalangin yu ay mag-aged kamo a tuloy tuloy ta ikamo ay bebiyen, maglawag kamo a tuloy tuloy ta ikamo ay nekita, pati tumuktuk kamo a tuloy tuloy ta kakayasan i abetan para dikamo. ");
INSERT INTO due_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ta i belang geaged a tuloy ay pebiyen, i gelawag pala a tuloy ay nekita pati i getuktuk pala a tuloy ay pekayasan i abetan para diya. ");
INSERT INTO due_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nano ikamo pan a manga ama ay an yu ngan bebiyen i anak yu ni beto be eya ay geaged ni tinapay. ");
INSERT INTO due_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pati an yu pala bebiyen i anak yu ni bebek be eya ay geaged ni ikan. ");
INSERT INTO due_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nano be ikamo a makikkakasalanan ay naketingges a geboy de mangának yu ni piyon a paaged ay namas pa a naketingges i Ama yu a Makedepat de langot a geboy ni kapiyonan a paaged de belang geaged diya. ");
INSERT INTO due_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Nano ay misan an yediin dikamo ni kakmukan i piyon ay yediin yu la a tuloy i piyon de pesan a magi buot yu a yeyedi de dikamo. Ta de maginon ay i pagyedi yu ay nappaayun de pagtodu ni Moises pati magsasabi ide a den.” ");
INSERT INTO due_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sinabi ni Hisus a tuloy, “Pumelit kamo a sumilong de pintohan a megot ta malawa i pintohan pati an te abet i bektas a paagow de padusahan ta makmuk i nesila de bektas a inon. ");
INSERT INTO due_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Misan ay megot i pintohan pati te kahedepan i bektas a paagow de edup a an te kalog ta uluisin pan la i nakesilong de inon. ");
INSERT INTO due_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mag-engat kamo de magsasabi ide a butelan a nálane dikamo a gesabi a ide ay matud a katabeng ni Makedepat misan ay pesede de i pagpanulusun ni mangának ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Aabuyenan yu ide dehil de pagyedi de ti piyon ide o malot ta an náanak i katinekin ni anak a napámangan. ");
INSERT INTO due_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Esipin yu a i piyon a kew ay náanak ni te kabuluhan misan pan i malot a kew ay náanak pala ni an te kabuluhan. ");
INSERT INTO due_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ta an nappatud a i piyon a kew ay náanak ni an te kabuluhan, ta am pala nappatud a náanak i malot a kew ni te kabuluhan. ");
INSERT INTO due_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Misan ay katinggesan yu a i pesan a kew a an náanak ni te kabuluhan ay pepugtus a wewitik de apoy. ");
INSERT INTO due_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kanya dehil de pagyedi ni agta ay aabuyenan yu ide ti piyon o malot.” ");
INSERT INTO due_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sinabi ni Hisus a tuloy, “Nano ay an pesan a gesabi deko, ‘Panginoon ko’ ay nakesilong de kataanan nun Makedepat ta i belang getalinga la de kabuotan ni Ama ko de langot. ");
INSERT INTO due_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ta pagdetong ni inapóan a adow ay makmuk i gesabi deko, ‘Panginoon, ay de makapangyedihan a ngalan yu ay nagtodu kami ni surut yu pati dehil de ngalan yu pala ay nagpalayu kami ni libong de lawes ni agta pati nagyedi kami ni gepakataka.’ ");
INSERT INTO due_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Misan ay sasabi ko dide, ‘Ay kapide man ay ang ko ikamo peabuyenan. Lumayu kamo deko a ikamo a migyedi ni mammalotin.’ ");
INSERT INTO due_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kanya i belang agta a gepataliknoy pati getalinga a tuloy de pesan a pagtodu ko ay katolad ni isin a naketingges a agta a nagyedi ni beloy na de kabetoan. ");
INSERT INTO due_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nano ay nun tinumapuk ni marages a masakut, a binumulangay a tuloy, a pinalosán ni maslog ay an nagibe i beloy na ta nappauddi de kabetoan. ");
INSERT INTO due_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Misan i belang agta pan a gepatalikngoy a an getalinga de pagtodu ko ay magi isin a an naketingges a agta a nagyedi ni beloy na de langges. ");
INSERT INTO due_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dingan nun tinumapuk ni marages, a binumulangay a tuloy, a pinolosán ni maslog ay nagibe di un beloy na ta talage ngani a narukat di.” Inon i pagtodu ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nano ay pagkatapos ni Hisus a nagtodu ninon ay nagtaka i kaagtaan de pagtodu na. ");
INSERT INTO due_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ta nagtodu eya a te kapangyedihan a masakut, a an magi magtutodu ide ni Hudyo a an te kapangyedihan de pagtodu de. ");
INSERT INTO due_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nun pagdolug ni Hisus de kalasan ay inumabut diya i makmuk a agta. ");
INSERT INTO due_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nano ay te duman a linumane diya a isin a lalaki a te ketong ta inumobbob de kasagkaden na ta sinabi na, “Panginoon, be buot yu ay papiyonin ok yu di ta ikamo ay te kaya.” ");
INSERT INTO due_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ay inonat ngani ni Hisus i kumot na ta tinapá na i te ketong a sinabi na, “Buot ko a talage. Pumiyon ka di.” Dingan tambing ngani a pinumiyon i ketong de lawes na. ");
INSERT INTO due_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nano ay tinutugun ni Hisus diya a mahigpit a, “Wet mo sasabia misan dino i sinumapit dikaw misan ay kumang ka a palawag mo i lawes mo de isin nunde maghahandug ide nun Makedepat. Ta pagkakita na dikaw ay maghandug ka a nappaayun de pagdodul ide ni Moises ta inon ay gepamatud de kaagtaan a pinapiyon ka di.” Inon i sinabi ni Hisus de pinapiyon na. ");
INSERT INTO due_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nano ay nun matapos di i Hisus de pagsurut na de kaagtaan ay sinumilong eya de benwaan a Kapernam. Ta linumane diya i isin a kapitan ni sundelo ide a tage Roma ta nag-aged eya de Hisus ");
INSERT INTO due_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","a magioyo, “Panginoon, i katabeng ko de beloy ko ay te orom a mahedep ta an di gepakaewes pati nagkahedepan a masakut.” ");
INSERT INTO due_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sinabi ni Hisus diya a, “Nosut ok dikaw ta papepiyon ko eya.” ");
INSERT INTO due_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Misan ay tinubeg eya ni kapitan, “Panginoon an depat a nesilong kamo de beloy ko ta ako ay an te kabuluhan. Ta sabiin yud la dio a piyon di i katabeng ko duman ay talage a nepiyon ngani. ");
INSERT INTO due_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ta misan ako pala ay pesákup ni pinakamaditas a ponu pati ako pan ay te nagkasakopan a manga sundelo ta be sabiin ko de isin a, ‘Tumotul ka,’ ay nototul eya. Be sabiin ko de isin pa a, ‘Dumio ka,’ ay nálane eya deko pati be de katabeng ko ay sabiin ko a, ‘Yediin mo yo i,’ ay yeyedi na ngani.” ");
INSERT INTO due_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nano ay nun inikna inon ni Hisus ay nagtaka eya ta sinabi na de kaagtaan a nappaabut diya a, “Talage ay pesabi ko dikamo a anok pa kinumita ni magioyo kahanga a pagpanulusun misan deno a pulupalebut ni Israel. ");
INSERT INTO due_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pesabi ko pala dikamo a makmuk a an Hudyo i náapo de kadepit ni petangaan pati pelinoden ni adow a nakisaló de kaapoapohan tam a Abraham, Isak pati Hakob duman de kataanan nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Misan pan ay i makmuk de Hudyo ide a hinandean ni Makedepat ni kapiyonan na ay wewitik ide de ditow a madumos ta duman ay nátangos ide a náaratengot i ngipon de dehil de pagtiis de.” ");
INSERT INTO due_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ay dingan sinabi ni Hisus de kapitan, “Umuli kamo di ta dehil de pagpanulusun yu ay nangyedi di i peaged yu.” Nun odes pala a inon ay napiyon di i katabeng nun kapitan. ");
INSERT INTO due_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nano ay nun isin a adow ay sinumilong i Hisus de beloy ni Pedro ta duman ay kinta na a geide i panuwangan ni Pedro a mahuna a pelagnat a masakut. ");
INSERT INTO due_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ta dingan binolan ni Hisus de kumot na i pelagnat ta naeyen dingani i lagnat ni mahuna. Ta pagkagiyos na ay nag-akod eya dide ni pápangan. ");
INSERT INTO due_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nano ay nun pagkalinod di ni adow ay inikag de Hisus ni kaagtaan i makmuk a te libong de lawes de ta de isin la a surut na ay pinalayu na i libong ide pati pinapiyon na i pesan a te orom. ");
INSERT INTO due_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ta de maginon ay pinamatoden i sinabi ni magsasabi a den a Isais a, “Linayu na dikitam i kahedepan tam ta inadde na i manga orom tam.” ");
INSERT INTO due_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nano nun kinta ni Hisus i makmuk a masakut a agta a naddepalebut na ay nagdodul eya de mangáyun na a, “Sumabusabu kitam di de dipa ni uluataben to.” ");
INSERT INTO due_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Misan ay linumane diya i isin a magtutodu ni Hudyo ta sinabi na, “Magtutodu, nosut ok dila dikamo a nappa ni mag-aadel yu misan deno kamo paagow.” ");
INSERT INTO due_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ta tinubeg eya ni Hisus, “Uluespin mo ngona ta te pigtaanan a bulsut i hayup ide pati i manok ide ay te pig-aponan misan ay ako a Pineta nun Makedepat a napa ni agta ay anok te pigtaanan a sadili a pigpaimloyen.” ");
INSERT INTO due_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","I isin pan a sinumut diya ay nagsabi, “Panginoon, pabiyaan ok yu ngona a nouli tangani aalagean ko i ama ko hanggen an nagkelibun.” ");
INSERT INTO due_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Misan ay tinumubeg i Hisus diya, “Sumut ka deko ta pabiyaan mo dila i manga an gepanulusun a nannapor de nalibun dide.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ta dingan nun pagkasakoy ni Hisus nunde bengka ay sinumakoy pala i mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nun gesabusabu pa ide ay dinumatong pan dide i maslog a subesko ta mandeli a nepino un bengka ni orat misan ay napede pa i Hisus. ");
INSERT INTO due_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kanya i mag-aadel na ide ay linumane de Hisus ta binogbog de eya a sinabi de, “Panginoon, ligtasin yu ikami ta noomos kitam di.” ");
INSERT INTO due_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tinumubeg eya dide, “Bekot ta nagkatakut kamo. Talage a untik pa i pagpanulusun yu deko.” Ta dingan ginumiyos eya ta sinablow na un palos pati un desi ta piyon di i panahon. ");
INSERT INTO due_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ay nagtaka ide a pesan ta ide ay natulutantoan, “Ano yo a kalase a agta ta getalinga pan diya i palos pati atab.” Inon i pinatulutantoan de. ");
INSERT INTO due_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pagdetong de de dipa de lugel a Gadareno ay tinumagbu diya i aduwa a lalaki a inumapo de pigtaporan ide a gob. Ide ay te manga libong de lawes de ta matapangin ide a masakut kanya an te gepakasila duman a agta. ");
INSERT INTO due_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nano nun kinta de i Hisus ay inumolang ide ni magioyo, “Ikamo a Anak nun Makedepat, bekot ta peabela yu ikami a libong? Dinumio kamo man a pehedepan yu ikami a am pam pa gedetong i panahon a pagtiis mi?” Inon i sinabi ni libong ide. ");
INSERT INTO due_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Misan ay duman de an masakut a alayu ay te isin a hanga a kalugbuwen ni kabebuyen a gepinagpangan. ");
INSERT INTO due_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ta nag-aged i libong ide a mahigpit de Hisus a, “Be pototul yu ikami ay pakangin yu ikami de kalugbuwen ni kabebuyen a inon i.” ");
INSERT INTO due_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sinabi ni Hisus, “Hale di. Dumuman kamo.” Kanya linumayu ide de manga lalaki ta linumane ide de lawes ni bebuy ide ta dingan loktat a nagiginekan un kabebuyen a padolug de rongtob a masakut a paagow de uluataben ta naomos ide duman. ");
INSERT INTO due_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Misan un mag-aalage nun kabebuyen ay nagiginekan pala ide a paagow de benwaan ta pagdetong de duman ay binareta de i pesan a nangyedi de aduwa a lalaki a te manga libong de lawes de. ");
INSERT INTO due_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kanya pan nagibinulwag i kamakmokan a agta de benwaan a nákang de Hisus ta nun kitain de eya ay inaged de a masakut a tumotul i Hisus nunde putok de. ");
INSERT INTO due_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kanya sinumakoy i Hisus de bengka a sinumabusabu de dipa ta tinumuloy eya de sadile na a benwaan. ");
INSERT INTO due_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nano ay nun duman di eya ay te dinumatong pan a tipide a lalaki a te adde ide ni isin a lungpo a náosong de pig-eden na. Ta nun matinggesan ni Hisus i kahanga ni pagpanulusun de diya ay sinabi na de lungpo, “Ayun, patibongin mo i innawa mo ta pinakaeyenan ka di ni mammalotin mo.” ");
INSERT INTO due_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nano ay nagdeinnawa i tipide a magtutodu ni Hudyo a magioyo, “Malot yo a agta ta pepadepade na i sadile na de Makedepat ta i Makedepat pan la i te kaya a gepakaeyen ni mammalotin ni kaagtaan.” ");
INSERT INTO due_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Misan ay katinggesan ni Hisus i naddeinnawa de kanya sinabi na dide, “Wet kamo magdeinnawa ni maginon a malot. ");
INSERT INTO due_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ta talage a namas pa a mamiyen i sabiin ko de lungpo a, ‘Pinakaeyen ka di ni mammalotin mo,’ a an i ‘Gumiyos ka di ta addein mo i pig-eden mo na.’ ");
INSERT INTO due_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ta depat yu a matinggesan a ako a Pineta nun Makedepat a napa ni agta ay te kapangyedihan a gepakaeyen ni mammalotin dio de putok i kanya yediin ko di i mahedep pa de pekita yu.” Ay dingan sinabi ni Hisus nunde lungpo, “Gumiyos ka di ta addein mo i pig-eden mo na ta umuli ka di.” ");
INSERT INTO due_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ay dingan tambing a ginumiyos eya a inumuli. ");
INSERT INTO due_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ta nun makitan nun agta ide i maginon ay natakut ide ta nagpodi ide de Makedepat a nagboy ni kapangyedihan na de kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nano ay nun tinumotul i Hisus de lugel a inon ay kinta na i magsisengil ni buwis a te ngalan a Mateo a gelipa de pigsingelan ni buwis. Ta sinabi diya ni Hisus, “Sumut ka deko.” Ta dingan inumuddi i Mateo a sinumut de Hisus. ");
INSERT INTO due_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nano ay nun duman di de beloy ni Mateo i Hisus pati mag-aadel na ide a gepangan ay dinumatong i makmuk a magsisengil ni buwis pati agta ide a makikkakasalanan. Ta ide ay nasalósalóan de pamangan. ");
INSERT INTO due_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nun kinta ni Pariseo ide i maginon ay sinabi de de mag-aadel na ide a magioyo, “Bekot pan ta gepakisaló la i magtutodu yu na de magsisengil ide pati makikkakasalanan ide?” ");
INSERT INTO due_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Misan ay nun inikna ni Hisus i oyo a surut ay sinabi na dide, “I an te orom ay an depat a gelawag ni magbubulong ta i te orom la i depat a gelawag. ");
INSERT INTO due_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ta anok dinumio a geolang de geesip ide a an ide te kasalanan ta dinumio ok ngani a geolang de makikkakasalanan ide. Kanya esipin yu a masakut i kabuluhan ni oyo a sinabi ni Makedepat a, ‘Pinakamahalage de pekita ko i migkalbi ide ta am pan i mighandug ide a an getalinga deko.’” ");
INSERT INTO due_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nano ay dinumatong de Hisus i mag-aadel ide ni Huwen a Maglilenod a nagtanto a magioyo, “Ikami pati manga Pariseo ide ay ugnay a an gepangan ni untik a panahon be gepanalangin. Ano pan ta i mag-aadel yu ide ay eyen?” ");
INSERT INTO due_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Misan ay tinubeg ide ni Hisus, “An depat a an námangan i inakit ide a gegewes de kásalan hanggen kakoloy de pa i lalaki a kinasal. Misan be nádetong i panahon a an di i lalaki a kinasal ay dingan de panahon a inon ay malungkut i inakit ide, a an ide námangan ni untik a panahon.” ");
INSERT INTO due_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sinabi pala ni Hisus dide a, “Talage a an te getagpi de loma a demit ni kagisi a bowon ta be maginon ay negisi i loma a demit ni tagpi a bowon ta dingan negisi ni namas pa a hanga i loma a demit. ");
INSERT INTO due_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ta am pala te geunid de loma a oniden a katat ni bowon a tayug a malanis ta be maginon ay sesede ngani ni bowon a tayug i oniden a loma ta ide ay padepade la a nakanugun. Kanya depat pan a unidin i bowon a tayug a malanis de bowon pala a oniden tangani naaloy ide a padepade a an nesede.” ");
INSERT INTO due_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ay nun pesabi pa ni Hisus i pesan a oyo ay dingan te dinumatong pan a isin a pinakamatande a Hudyo ta inumobbob de kasagkaden ni Hisus ta sinabi na, “Sigudu nalibun di i anak ko a mahuna misan ay be nosut kamo deko a tatapá yu i lawes na ay needup eya a liwet.” Inon i sinabi ni te anak. ");
INSERT INTO due_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ta i Hisus ay inumuddi pati mag-aadel na ide ta sinumut ide diya. ");
INSERT INTO due_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nano ay te duman a inumabut diya a isin a mahuna a te orom a gesagu ni sangpuwu di pati aduwa a taon ta linumane de idogen ni Hisus ta tinumapá eya de rimong ni bedu na. ");
INSERT INTO due_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ta sinabi na de sadile na a, “Be matapá ko la i bedu na ay nepiyon ok di.” ");
INSERT INTO due_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ay linumingoy i Hisus ta pagkakita na diya ay sinabi na, “Mahuna, patibongin mo i innawa mo ta pinapiyon ka di ni pagpanulusun mo deko.” Ta gepo nun nanon a odes ay pinumiyon un mahuna. ");
INSERT INTO due_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nano ay nun dinumatong i Hisus nunde beloy nun pinakamatande ay kinta na i gepatinog ide ni bengsi pati makmuk a agta a nagkogulo a masakut dehil de nalibun. ");
INSERT INTO due_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Sinabi na, “Magibinulwag kamo ta an la nalibun i anak ta nappede la.” Ta pinag-ilokan de eya. ");
INSERT INTO due_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Misan nun mapabulwag di un kaagtaan ide ay sinumilong i Hisus ta binolan na un kumot na ta ginumiyos di eya. ");
INSERT INTO due_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kanya kinumálat i bereta tungkul de nangyedi a inon de pulupalebut ninon a lugel. ");
INSERT INTO due_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nun pagtotul ni Hisus de lugel a inon ay inumabut diya i aduwa a lalaki a bulag ta nag-olang ide ni surut a magioyo, “Kalbian yu ikami, ikamo a apo ni Debid a kaapoapohan tam.” ");
INSERT INTO due_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pagkasilong ni Hisus de isin a beloy ay inumabut diya un aduwa a bulag ta tinanto ide ni Hisus, “Gepanulusun kamo man a te kaya ok a gepapiyon ni mata yu.” Tinumubeg ide, “Ay-o, Panginoon.” ");
INSERT INTO due_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ta dingan tinapá na i mata de ta sinabi na, “Mangyedi dikamo a nappaayun de pagpanulusun yu.” ");
INSERT INTO due_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ay nakakita di ide ta sinabi ni Hisus dide a mahigpit, “Wet yu sasabia misan dino i oyo a nangyedi.” ");
INSERT INTO due_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Misan nun makatotul di ide ay binareta de i yinadi ni Hisus dide de pulupalebut ni lugel de. ");
INSERT INTO due_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nano ay nun pagkatotul de ay inadde de Hisus i isin a lalaki a te libong de lawes na a gepabunol diya. ");
INSERT INTO due_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nun pinalayu di ni Hisus un libong de lawes ni lalaki ay nakasurut di un bunol ta nagtaka un pesan a agta a sinabi de, “Ang kami pa kinumita ni magioyo dio de bensa tam a Hudia ti an nano.” ");
INSERT INTO due_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Misan ay sinabi ni Pariseo ide, “I eya ay gepalayu ni kalibongan ide dehil de kapangyedihan ni ponu ni kalibongan ide.” ");
INSERT INTO due_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Dingan linebut ni Hisus de bulubenwaan pati de buluberiyu ide. Ta de belang pigmitengan de ay nagtodu eya a nagsabi ni piyon a bereta a ti papalano a te kapangyedihan i Makedepat de innawa ni agta. Ta nagpapiyon eya ni agta ide misan ano i orom de. ");
INSERT INTO due_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nun kinta na i makmuk a masakut a kaagtaan ay kinalbian na ide ta ide ay nagkehedepan a an te getabeng dide a magi manga topa a an te mag-aalage. ");
INSERT INTO due_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kanya sinabi na nunde mag-aadel na ide, “Talage a hanga i goguto misan ay an sukul i magguguto ide. ");
INSERT INTO due_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kanya magpanalangin kamo de Panginoon a Makedepat a te adi ni goguto tangani pakangin na i sukul a magguguto na de diya a goguto.” ");
INSERT INTO due_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nano ay pinakangan ni Hisus i sangpuwu pati aduwa a mag-aadel na ta biniyen na ide ni kapangyedihan a gepalayu ni malot a libong ide de lawes ni manga agta, a gepapiyon pala ni attanan a kalase a orom. ");
INSERT INTO due_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","I oyo i ngalan ni sangpuwu pati aduwa a mag-aatid na. Tagibu i Simon a nginalanan a Pedro pati Andres a wile na. Ide Santiago pati Huwen a mangának ni Sebedeo. ");
INSERT INTO due_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ide Pilepi pati Bartolome, Tomas pati Mateo a magsisengil ni buwis, i Tadeo pati Santiago a anak ni Alpeo, ");
INSERT INTO due_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon a “Masépag”, pati Hodes Iskariyote a nagpadekop de Hisus de kapagebuk na ide. ");
INSERT INTO due_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nano ay pinakang ni Hisus inon a sangpuwu pati aduwa ta pinagtutugunan na ide a, “Wet kamo nákang de lugel ni an Hudyo ide pati de misan deno a benwaan ni Samaritano ide. ");
INSERT INTO due_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ta piyon pa a kumang kamo de kaagtaan a Hudyo a tage Israel a nalagelag. ");
INSERT INTO due_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pati de pagtotul yu ay magsabi kamo a ti papalano a an naaloy ay te kapangyedihan i Makedepat de innawa ni agta ide. ");
INSERT INTO due_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Papiyonin yu i te manga orom. Pakaedupin yu i nalibunin. Papiyonin yu i te ketong ide ta magpalayu kamo ni libong de lawes ni manga agta ide ta tinumanggep kamo ni kapangyedihan a inon a an yu binayeden kanya magboy kamo ni tabeng a an te beyed. ");
INSERT INTO due_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Wet kamo nángadde ni kuwarta a ginto, pelak o tangso a nassukbit. ");
INSERT INTO due_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wet kamo pala nángadde ni soput ni pápangan yu de pagtotul yu pati paragetus, sugkud o bedu a panlewes ta i magyeyedi ay depat a bebiyen ni keedup. ");
INSERT INTO due_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ta deno kamo man nádetong a benwaan o beriyu ay lawagin yu i agta a getanggep dikamo a piyon ta dingan duman kamo la magpilong hanggen ang kamo getotul de inon a lugel. ");
INSERT INTO due_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pagsilong yu de beloy ay sabiin yu a, ‘Mapadikamo tebe i kabeetan a esip ni Makedepat.’ ");
INSERT INTO due_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta be piyon i innawa ni agta de beloy a inon ay ugnay a nappadide i kabeetan a esip ni Makedepat misan ay be an de ikamo tatanggep a piyon ay an ide gekaduman ni kabeetan a esip. ");
INSERT INTO due_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pati be an de ikamo petanggep pati an de pepatalikngan i surut yu de misan deno a benwaan o beloy ay pagpagin yu i delpong ni singit yu a tande a kinapoyen de i surut nun Makedepat ta dingan tumotul kamo duman. ");
INSERT INTO due_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Talage ay pesabi ko dikamo a de adow a paghatol ay namas pa a mabiyet i padusa a nádetong de tage benwaan inon de padusa a napa de tage lugel a Sodoma pati Gomora nun nowon dehil de mabiyet de a kasalanan. ");
INSERT INTO due_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nano ay mag-engat kamo ta pakang ko ikamo a magi topa de gitna ni kaagtaan a magi mangásu a matapangin. Kanya mapa ni naketingges kamo a magi bebek pati mabeit a magi kalapati. ");
INSERT INTO due_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mag-engat kamo de kaagtaan ta te duman a nomoy dikamo de pighatolan ta lalapdit de ikamo de pigmitengan de ide. ");
INSERT INTO due_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dehil de pagpanulusun yu deko ay pasagkad de ikamo de manga gubernador ide pati de manga hari ide ta ikamo ay gepamatud de kasagkaden de pati de manga an Hudyo ide. ");
INSERT INTO due_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nano ay be binoy de di ikamo de pighatolan ay wet magulo i esip yu a ti ano i sasabi yu ta de odes a inon ay boboy la dikamo i sasabi yu. ");
INSERT INTO due_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ta an ikamo i gesurut ta i Ispiritu nun Ama yu a Makedepat i aapoán ni surut yu. ");
INSERT INTO due_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ay padekop ni isin a agta i kabinsa na a pobuno na. Maginon pala i yeyedi ni ama de anak na ta i anak pan ay gelaben de kamoddenan na a pobuno na ide. ");
INSERT INTO due_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pati kagengsaan kamo ni pesan dehil de pagpanulusun yu deko misan ay i getiyage de pagpanulusun na hanggen de kalog ay nalligtas ngani. ");
INSERT INTO due_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ay be pepahedepan de ikamo de isin a benwaan ay gumikan kamo a paagow de isin di a benwaan. Ta talage a matud i pesabi ko dikamo a an yud nádetong i pesan a benwaan ni sákup ni Israel ay nádetong ok di a Pineta nun Makedepat a napa ni agta. ");
INSERT INTO due_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nano i mag-aadel ay an namas pa a maditas i kapangyedihan na de magtutodu na pati i katabeng ay an namas pa a maditas i kapangyedihan na de ponu na. ");
INSERT INTO due_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ta sukul di be i mag-aadel ide pati katabeng ide ay nappa ni kapadepade de magtutodu pati ponu de kanya be ako a ponu yu ay pengalanan de a i Satanas ay namas kamo pa a mag-aadel ko ay pesabian de ni malot. ");
INSERT INTO due_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Misan ay wet kamo matakut dide ta an te nattaklopan a an kakayesan pati an te nattagu a an kekita. ");
INSERT INTO due_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","I pesabi ko dikamo de peikna yu la ay depat a sabiin yu de kamakmokan ta i peulit dikamo ay sabiin yu a malagdu de kamakmokan. ");
INSERT INTO due_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pati wet kamo matakut de te kaya la a nomuno de lawes yu a putok misan an di ide te kaya a nomuno ni kaleduwa yu. Ta pepapag-engat ko ikamo a matakut kamo de te kapangyedihan a nomuno ni lawes yu a nangadde pala ni kaleduwa yu de impiyerno. ");
INSERT INTO due_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Misan pan ay hanga i pagbuot dikitam ni Makedepat ta misan pepanggetang ni magtitinde ide i aduwa a maye ni isin a pera ay be an nappaayun de kabuotan ni Ama yu a Makedepat ay an nadegdeg de putok i misan isin dide. ");
INSERT INTO due_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ta katinggesan ni Makedepat i pesan tungkul dikamo misan i kamakmuk ni sapok yu. ");
INSERT INTO due_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kanya wet kamo matakut ta namas kamo pa a mahalage de makmuk a maye. ");
INSERT INTO due_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nano ay i misan ino a gepamatud tungkul deko de kaagtaan ay gepamatud ok pala tungkul diya de kasagkaden ni Ama ko de langot. ");
INSERT INTO due_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ta i misan ino a gepangeyen tungkul deko de kaagtaan ay pengeyen ko pala eya de kasagkaden ni Ama ko de langot.” ");
INSERT INTO due_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sinabi ni Hisus a tuloy a, “Wet yu eesipa a dinumatong ok dio de putok i tangani pepag-eisinin ko i innawa ni kaagtaan ta ako i geboy ni pagkiblagen ni innawa ni kaagtaan ide. ");
INSERT INTO due_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nakulukiblagen i maginak a lalaki pati maginak a mahuna pati magpanuwangan a mahuna. ");
INSERT INTO due_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ta i nappa ni katalo ni manga agta ay i mangáyun de la de beloy de. ");
INSERT INTO due_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Talage ay an nagkaddepat a nekikoloy deko i misan ino a an te namas pa a pagbuot deko de pagbuot na de ama, ina pati mangának na a lalaki o mahuna. ");
INSERT INTO due_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pati am pala nagkaddepat a nekikoloy deko i misan ino a an te buot a getagel ni kahedepan a kosa na a innawa, a geabut pala de ugeli ko. ");
INSERT INTO due_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Talage ngani a nakanugun i edup ni misan ino a agta be getalinga eya de kabuotan na a sadili misan ay nalligtas pan eya a geboy ni edup na para deko. ");
INSERT INTO due_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Pati i misan ino a getanggep dikamo ay getanggep pala deko pati pan i getanggep deko ay getanggep pala de nagdodul deko. ");
INSERT INTO due_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pati pan i misan ino a getanggep a te gelang de magsasabi ni Makedepat ay gekaduman pala eya ni bilos a magi de magsasabi. Ta i misan ino pala a getanggep a te gelang pala de agta a te piyon a ugeli de pekita ni Makedepat ay gekaduman pala eya ni bilos a magi de agta a te piyon a ugeli. ");
INSERT INTO due_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pati i misan ino a magboy ni magidnaw la a orat de isin a gepanulusun deko a an te kapangyedihan a masakut dehil de eya ay mag-aadel ko ay pesabi ko dikamo a getanggep ngan eya ni bilos na a nagkaddepat.” ");
INSERT INTO due_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nun matapos di ni Hisus i pagtodu na de sangpuwu pati aduwa a mag-aadel na ay tinumotul eya a getodu de bulubenwaan a alane duman. ");
INSERT INTO due_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nano ay inon a manga yinadi ni Kristo ay nabereta ni Huwen a Maglilenod nun eya ay nabbilanggo di kanya dinodul ni Huwen i mag-aadel na ide a pepatanto na diya. ");
INSERT INTO due_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ta pagdetong de de Hisus ay sinabi de diya a, “Ikamo man di i Pinangako nun Makedepat a nádetong o geilat kami pa ni kakmukan?” ");
INSERT INTO due_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ta tinumubeg i Hisus dide, “Umampulang kamo de Huwen ta sabiin yu i inikna yu pati kinta yu dio. ");
INSERT INTO due_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ta i bulag ide ay nakakita di. I pilay ide ay nakatotul di. I te ketong ide ay pinumiyun di. I bingol ide ay nakaikna di. Ta i nallibunin ide ay nagkeedup. Pati gesabi ok ni piyon a bereta de mahedepin ide. ");
INSERT INTO due_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Talage a piyon i kapuoyen ni misan ino a an te aduwa a esip tungkul deko.” Inon i sinabi ni Hisus dide. ");
INSERT INTO due_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Pagkatotul ni mag-aadel ide ni Huwen ay sinabi ni Hisus de kaagtaan ide i tungkul de Huwen a magioyo, “Talage ay nun kinumang kamo de Huwen de lugel a ilang ay an yu eya kinta a te aduwa a esip a magi tangbu a nagketigyun ni palos. ");
INSERT INTO due_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pati an yu pala eya kinta a gedemit ni masampatin ta talage i gedemit ni maginon ay te piyon a edup a getaan de beloy ide a hanga ni hari ide. ");
INSERT INTO due_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kanya kamo kinumang ta buot yu a nekita ni magsasabi nun Makedepat ta kinta yu pan di eya a te kapanyedihan pa a namas de magsasabi ide a den nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ta te duman tungkul de Huwen de kasulatan a den i sinabi nun Makedepat a magioyo de Pinangako na, ‘Patalikngan mo ta pakang ko i mag-aatid ko a naona dikaw a gehande ni sesilan mo.’” ");
INSERT INTO due_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sinabi ni Hisus a tuloy dide, “Pesabi ko ngan dikamo ay gepo nun nowon hanggen nano ay namas pa de pesan a agta ay nagkaduman ni kapiyonan ni Makedepat i Huwen misan ay gepo de nano ay namas pa de Huwen ay gekaduman ni kapiyonan ni Makedepat i belang gepanulusun deko, misan untik i kapangyedihan na. ");
INSERT INTO due_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Pati gepo nun nagsabi i Huwen ni bereta na hanggen nano ay nagpaabuya a masakut i Makedepat ni kapangyedihan na pati kamakmokan ay te buot a masakut a te kapangyedihan i Makedepat de innawa de. ");
INSERT INTO due_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ta i magsasabi ide a den pati pagdodul ide ay nagpamatud tungkul de kapangyedihan nun Makedepat hanggen am pa gedetong i Huwen. ");
INSERT INTO due_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Misan be buot yu a nonulusun ay i Huwen ngan i Elias a hinola a nádetong a liwet. ");
INSERT INTO due_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","I misan ino a gepatalikngoy ay depat a tumalinga.” ");
INSERT INTO due_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Sinabi ni Hisus a tuloy, “Misan ti deno ko pekipadepade i manga agta de nano a panahon? Talage ay ide ay magi mangának a kalipalipa de piggewesan de ta ide ay gepinag-olang de kagewes de ide ta pesabi de de kakmukan a mangának a, ");
INSERT INTO due_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ikami ay nagtugtug di ni masampat misan ay angkamo pa gesayew pati ikami ay nagkanta dikamo ni malungkut misan ay ang kamo pa tinumangos.’ ");
INSERT INTO due_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ikamo ngani a manga agta de nano a panahon i kapadepade ni mangának ide a inon. Ta nun dinumatong di i Huwen a an namangan ni untik a panahon a an nag-inom ni tayug a malanis ay sinabi yu a eya ay te libong de lawes na. ");
INSERT INTO due_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Misan ay nun dinumio ok a Pineta ni Makedepat a napa ni agta a gepangan pati geinom ay pesabi yu pan a, ‘Pagelawagin yu i agta a oyo a matakaw pati migbugnang ta ayun pa eya ni magsisengil ide ni buwis pati pesan a makikkakasalanan ide.’ Misan ay gepakita i Makedepat a eya ay naketingges de padean ni attanan a piyon a pagyedi ni katabeng na ide.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nano ay sinosol ni Hisus i manga agta a kinumita ni yinadi na a gepakataka de benwaan de dehil de an ide nagipinagsosol ni mammalotin de, ");
INSERT INTO due_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ta sinabi na, “Gapakatakut i násapit dikamo a manga tage Korasin pati Betsaida ta be duman tebe de Tiro pati Sidon a benwaan ni an Hudyo ide yinadi, nun nowon, i gepakataka a peyedi ko dio dikamo ay náloy di tebe ide ay nagsosol, a nagbedu ni kustal, a naglipa de depog a tande ni pagsosol de. ");
INSERT INTO due_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kanya pan pesabi ko dikamo a mabbiyet pa a masakut i pagpadusa a násapit dikamo de adow a paghatol ta mammiyen pa de tage Tiro ide pati Sidon. ");
INSERT INTO due_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pati ikamo pala a manga tage Kapernam ay kasta peesip yu a alane kamo di de Makedepat misan ay an nappatud ta podusahan kamo de impiyerno. Ta be de tage Sodoma tebe yinadi i gepakataka a yinadi ko dio dikamo ay nagsosol ide a an ide napuksa. ");
INSERT INTO due_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kanya pesabi ko dikamo a mabbiyet pa a masakut i pagpadusa a násapit dikamo de adow a paghatol ta mammiyen pa de tage Sodoma ide.” ");
INSERT INTO due_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nun panahon pala a inon ay nanalangin i Hisus, “Ay gepasalamat ok dikamo Ama a Panginoon de langot pati de putok ta pepaabuya yu i kapangyedihan ko de te masidong ide a innawa ta petagu yu pan de mayabengin ide a makikkakatinggesan. ");
INSERT INTO due_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Talage Ama ta maginon i kabuotan yu.” Inon i pagpanalangin na. ");
INSERT INTO due_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dingan sinabi na de manga mag-aadel na ide, “Binoy di deko ni Ama ko i pesan. Ta an te gekaabuya deko a Anak ti an i Ama la ta am pala te gekaabuya de Ama ti an ako la a Anak pati pesan a pepeta ko a nakàabuya pala diya. ");
INSERT INTO due_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Nano ikamo a pesan a nagkapagel pati nagkebiyetan ni mammalotin yu ay lumane kamo deko ta pepapagpaimloy ko ikamo. ");
INSERT INTO due_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Magtalinga kamo de pagtodu ko pati mag-adel kamo pala deko tangani gekaduman kamo ni kasampatan a innawa ta ako ay te makowe a surut pati masidong pa a innawa. ");
INSERT INTO due_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ta talage ay mammiyen i pag-abut yu deko pati pagtodu ko.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nano nun isin a adow a paimloy ay sinumila ide Hisus de kaparayen ta natigeng un mag-aadel na ide a nanggitol ide ni ohay nun paray a pinangan de un butil na. ");
INSERT INTO due_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Misan nun mákitan nun Pariseo ide ay sinabi de diya, “Pagelawagin yu i peyedi ni mag-aadel yu na ide ta an nappaayun de pagdodul tam i peyedi de na be adow ni paimloy.” ");
INSERT INTO due_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Dingan tinumubeg i Hisus dide, “An yu man binasa i yinadi ni Hari a Debid pati kakoloy na ide, nun ide ay natigeng. ");
INSERT INTO due_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ta sinumilong ide de beloy a pighandogen de Makedepat dingan namangan ide nun tinapay a hinandug di de Makedepat. Esipin yu a inon ay an nappaayun de pagdodul ide ta i nappatud a namangan ninon ay i maghahandug la ide. Misan ay an te kasalanan ide Debid. ");
INSERT INTO due_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ay binasa yu pala i kasulatan ni Moises a de belang adow a paimloy ay geyedi i maghahandug ide de beloy a pighandogen de Makedepat. Inon ay an nappaayun de pagdodul ide a tungkul de adow ni paimloy misan ay an ide pala te kasalanan. ");
INSERT INTO due_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ta pesabi ko dikamo ay nappa dio di eya a namas pa a te kabuluhan de beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Talage ay an yu tebe pehatolan i an te kasalanan be katinggesan yu i kabuluhan ni surut ide a oyo a, ‘I buot ko ay an i handug yu deko ta i kalbi yu de kakmukan.’ ");
INSERT INTO due_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pati depat pala a matinggesan yu a ako a Pineta nun Makedepat a napa ni agta ay nagkaddepat a nanabi a ti ano i nappatud de adow ni paimloy.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Dingan tinumotul i Hisus ta sinumilong de isin a pigmitengan ni Hudyo ide. ");
INSERT INTO due_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Te duman a isin a lalaki a nakkimaw i kumot na. Te duman pala i tipide a agta a gebentay de Hisus tangani kitain de ti te nasasabi ide a pagsumbong diya kanya tinanto de i Hisus a magioyo, “Nappaayun man de pagdodul ide a gepapiyon de agta de adow ni paimloy.” ");
INSERT INTO due_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tinubeg ide ni Hisus, “Be i misan ino dikamo i te nadegdeg a topa de bulsut ni putok be adow ni paimloy ay talage ay aamit yu. ");
INSERT INTO due_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pesabi ko ngan dikamo ay namas pa a mahalage i isin a agta de isin a topa kanya nappaayun ngani de pagdodul ide i magyedi kitam ni piyon de adow ni paimloy.” ");
INSERT INTO due_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dingan sinabi na de lalaki, “Onatin mo i kumot mo.” Inonat ngani nun lalaki i kumot na ta pinumiyon dingani a magun isin a kumot na. ");
INSERT INTO due_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Misan ay binumulwag i Pariseo ide a nasurutsurotan a ti papalano a pobuno de i Hisus. ");
INSERT INTO due_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Katinggesan ni Hisus i belak de kanya tinumotul eya duman. Makmuk i inumabut diya ta pinapiyon na i pesan a te orom. ");
INSERT INTO due_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Misan ay mahigpit a pinagtutugunan na ide a wet de sasabia misan dino ti ino eya. ");
INSERT INTO due_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nangyedi yo tangani mamatud i hinola ni magsasabi a Isais a magioyo ta sinabi ni Makedepat, ");
INSERT INTO due_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Pagelawagin yu ta wiyo i katabeng ko a Pineta. Pebuot ko eya a masakut pati nagkasalig ok diya. Boboy ko diya i Ispiritu ko ta bebereta na a ti papalano a pakeeyenan ko i tage manga bensa ni paghatol dide. ");
INSERT INTO due_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","An eya nekipagebuk ta be gesurut ay te masidong a innawa. Ta makowe i surut na. ");
INSERT INTO due_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ta an na pepugtus i tikol a napadepay a ide a te mahena a pagpanulusun. Ta an na pala pepalong i gepalong a salong a ide a te untik a pagpanulusun. Ta an netimok eya ni pagyedi na hanggen an nanalo i kamatoden. ");
INSERT INTO due_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pati i pag-asa ni pesan a an Hudyo ay nappadiya la.” Inon i hinola ni Isais. ");
INSERT INTO due_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nano ay te duman a lalaki a inikag de Hisus. Eya ay bulag pati bunol dehil de libong de lawes na ta dingan pinapiyon pan ni Hisus ta nakakita pati nakasurut. ");
INSERT INTO due_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ay nagtaka un pesan a agta ta sinabi de, “Makati eya di i hinola a apo ni Debid a pinangako ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Misan ay nun inikna nun Pariseo ide inon a sinabi ay sinabi de pala, “I agta a iwina ay gepalayu ni kalibongan ide dehil la de kapangyedihan ni Belsebul a i Satanas a ponu ni kalibongan ide.” ");
INSERT INTO due_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Misan ay kinatinggesan ni Hisus i peesip de kanya sinabi na dide, “Misan deno a bensa be ide ay nagipinagebuk ay nesede ngani i kapangyedihan ni bensa a inon. Pati an notuloy i misan deno a benwaan o mittanak be ide ay natulutaloan. ");
INSERT INTO due_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ta be i Satanas ay pepatotul na i manga katabeng na a libong ay kasta gepakitalo eya de sadile na, a nesede di a tuloy i kapangyedihan na. ");
INSERT INTO due_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Be peesip yu a gepatotul ok ni libong ide ni dehil de kapangyedihan ni Belsebul dingan depat a peesip yu pala a gepatotul ni libong ide i mag-aadel yu ide dehil de kapangyedihan ni Belsebul. An maginon i peesip yu a tungkul de mag-aadel yu ide kanya ide i gepamatud a an matud i peesip yu tungkul deko. ");
INSERT INTO due_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Talage i Ispiritu nun Makedepat i geboy deko ni kapangyedihan a gepatotul ni manga libong ide kanya katinggesan yu nano a dinumatong di dikamo a kaagtaan i kapangyedihan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ta i oyo i halimbewa a nanalo ok di de Satanas ta an te misan ino a nakesilong de beloy ni agta a matibong a nángamit ni kasangkapan be an na ngona gegepus i matibong ta dingan la nakesilong eya a nángamit ni misan ano. ");
INSERT INTO due_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“I misan ino a an gebuot deko ay katalo ko pati i misan ino a an getabeng deko a getipun ni manga agta ay gepakálat ngani. ");
INSERT INTO due_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Talage a matud ay pesabi ko dikamo a nappatud a pakeeyenan i manga agta ni misan ano a mammalotin de pati pagsurut ni malot a tungkul de Makedepat misan ay am pan pakeeyenan i misan ino a gesurut ni malot a tungkul de pagyedi ni Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Pati pakeeyenan i misan ino a gesurut ni malot tungkul deko a Pineta nun Makedepat a napa ni agta misan ay talage ay an pakeeyenan nano pati magpakapide pa man i misan ino a gesurut ni malot a tungkul de pagyedi ni Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Esipin yu a i piyon a kew ay náanak ni te kabuluhan misan pan i malot a kew ay náanak pala ni an te kabuluhan kanya dehil de anak ni kew ay aabuyenan yu i kew ti piyon o malot. ");
INSERT INTO due_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Talage ikamo ay magi bebek a te ugeli a malot kanya i surut yu a malot ay aabuyenan a ikamo ay malot ta ti ano man i naddeinnawa ni agta ay inon ngani i sasabi na. ");
INSERT INTO due_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ta i agta a te piyon a innawa ay geyedi ni kapiyonan a geapo de innawa na pati pan i agta a te malot a innawa ay geyedi pala ni mammalotin a geapo de innawa na. ");
INSERT INTO due_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Pesabi ko ngan dikamo a de adow a paghatol ay násagkad de Makedepat a Huwis a podusahan i agta ide dehil de belang surut de a an te kabuluhan. ");
INSERT INTO due_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ta gepo de surut yu ide ay podusahan kamo o pakeeyenan kamo ni paghatol.” Inon i pagtodu ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dingan sinabi pan diya ni Pariseo ide pati magtutodu ide ni Hudyo a magioyo, “Magtutodu, buot mi a masakut a magpakita kamo ni gepakataka a gepamatud de kapangyedihan yu.” ");
INSERT INTO due_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kanya tinumubeg i Hisus dide, “Malot i ugeli ni agta ide de nano a panahon ta an ide depat a ponulusonan. Gelawag ide ni gepakataka misan ay an ide te kekita ti an i magi gepakataka a nangyedi de magsasabi a den a Honas. ");
INSERT INTO due_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ta ti papalano a i Honas nun nowon ay tiluwon a adow pati tiluwon a abi de tiyen ni hanga a ikan ay maginon pala i ako a Pineta nun Makedepat a napa ni agta ay tiluwon a adow pati tiluwon a abi de disalad ni putok. ");
INSERT INTO due_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Talage a de nádetong a paghatol nun Makedepat ay nouddi i tage benwaan a Ninibe de kasagkaden yu a gepamatud a makikkakasalanan kamo de nano a panahon. Ta ide ay nagipinagsosol dehil de pagpamatud dide ni Honas misan pan ay napadio nano de kasagkaden yu i namas pa a te kapangyedihan de Honas misan ay ang kamo pa gesosol kanya podusahan kamo. ");
INSERT INTO due_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Pati de adow pala a inon ay nouddi i Rena a tage Timogen de kasagkaden yu a gepamatud a makikkakasalanan kamo de nano a panahon. Ta nun nowon ay inumapo eya de alayu a gepatalikngoy de Hari a Solomon a naketingges a masakut misan pan ay napadio nano de kasagkaden yu, i namas pa a naketingges de Solomon misan ay an yu pa petalingaan.” ");
INSERT INTO due_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sinabi ni Hisus a tuloy, “Be pinatotul di i malot a libong de lawes ni agta ay nasulusagid de attanan a lugel a te kahedepan a gelawag ni lawes ni kakmukan a agta a pepaimloyen na. Misan be an eya nekita ");
INSERT INTO due_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ay sasabi na de sadile na a, ‘Yadi pa ay náampulang ok de inapóan ko a beloy.’ Ta de pag-ampulang na ay kekita na a an te unid, a malenis pati pinakapiya di. ");
INSERT INTO due_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kanya gelawag pa eya ni namas pa a malot diya a pito a libong ta dingan ide ay nesilong a te kapangyedihan a liwet de agta a inon. Kanya namas pa a malot i inapóan a kapuoyen ninon a agta de tagibu a kapuoyen na. Maginon pala i násapit de malot a agta de nano a panahon.” ");
INSERT INTO due_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ay nun gesurut pa i Hisus de kaagtaan ay dinumatong un ina na pati manga wele na a lalaki ta geilat ide nunde ditow a katobengan ta buot de a nekisurut de Hisus. ");
INSERT INTO due_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ay te duman pan a nagsabi diya, “Dena de ditow to i ina yu pati manga wele yu ta buot de ikamo a nakkasurut.” ");
INSERT INTO due_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Misan ay sinabi ni Hisus, “Inoino man i ina ko pati manga wele ko?” ");
INSERT INTO due_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ta dingan tinodu na i mag-aadel na ide a sinabi na, “Wiyo i magi ina ko pati manga wele ko. ");
INSERT INTO due_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ta i misan ino a geabut de kabuotan ni Ama ko de langot ay ide i magi ina ko pati manga wele ko.” ");
INSERT INTO due_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nun nanon pala a adow ay binumulwag i Hisus nunde beloy ta linumipa nunde kaginglan ni uluataben a getodu. ");
INSERT INTO due_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ta eya ay kinatipunan ni makmuk a masakut a manga agta kanya pan sinumakoy eya nunde bengka ta duman linumipa. Ta un kaagtaan pan ide ay dio nunde langges a kaginglan nun uluataben. ");
INSERT INTO due_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ta nagtodu eya dide ni makmuk de padean ni halimbewa ide ta sinabi na a magioyo, “Magpatalikngoy kamo. Te duman a isin a agta a kinumang a gesapwar ni binhi na. ");
INSERT INTO due_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta de pagsapwar na ni binhi na ay te nadegdeg de kaginglan ni bektas ta dinumatong i kamanokan ay pinangan de la. ");
INSERT INTO due_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te duman pan a nadegdeg de kabetoan a an mokpal i putok ta tambing a tinumubu dehil de malapis la i putok. ");
INSERT INTO due_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Misan aypagtipá ni adow a masakut ay narango di un tubu ide ta an nagkaramut ni sukul. ");
INSERT INTO due_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Te duman pala a nadegdeg de katinekan ta dingan nun hinumangain di un tinik ide ay natalo de un tinumubu a binhi. ");
INSERT INTO due_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Misan ay te duman pan a nadegdeg de piyon a putok a nagkoóhay ni isin a dian a butil, te anim a puwu a butil pati tiluwon a puwu a butil.” ");
INSERT INTO due_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Dingan sinabi ni Hisus a dugsong, “I misan ino a gepatalikngoy ay depat a tumalinga.” ");
INSERT INTO due_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nano ay linumane un mag-aadel ide ni Hisus ta nagtanto ide diya ni magioyo, “Buot mi a matinggesan ti ano ta pegemit yu i halimbewa ide de pagsurut yu de kaagtaan ide.” ");
INSERT INTO due_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tinumubeg eya dide, “Dikamo a gepanulusun deko ay pepatingges i madisalad a kamatoden a ti papalano a te kapangyedihan i Makedepat de innawa ni manga agta misan ay an non pepatingges de kakmukan. ");
INSERT INTO due_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ta i misan ino a getalinga de pagtodu ko ay nadugengan pa a sukul i katinggesan na misan ay i agta a an getalinga de pagtodu ko ay neeyen i katinggesan na a untik. ");
INSERT INTO due_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kanya dehil de inon ay gesurut ok dide de padean ni halimbewa ta misan pekita de ay an de pesapot pati misan peikna de ay an de pagketinggesan. ");
INSERT INTO due_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nangyedi di dide i hinola ni Isais a magsasabi a den ta sinolat na a magioyo, ‘Umikna kamo man ay an yu ketinggesan kapide man. Pati kumita kamo man ay an yu aabuyenan kapide man. ");
INSERT INTO due_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ta napa ni maksa di i esip ni agta ide a oyo, a nasongsongan di i talinga de a napapilong di i mata de. Ta be eyen ay nappatud tebe a nekita ide a matud, a neikna pala ta dingan nappatud tebe a ketinggesan de i kamatoden, a gepanulusun pala ide deko tangani ide ay pakeeyenan ko ni mammalotin de.’ ");
INSERT INTO due_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nano ay ikamo a gepanulusun deko ay piyon i kapuoyen yu ta pekita yu a peabuyenan pati peikna yu a katinggesan i pepayedi deko ni Ama. ");
INSERT INTO due_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Talage ay pesabi ko dikamo a gepo nun nowon ay makmuk di a magsasabi nun Makedepat pati pippiyonan a agta i te buot a masakut a nekita ni pekita yu misan ay an de kinta pati buot de a neikna ni peikna yu misan ay an de inikna. ");
INSERT INTO due_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nano ay patalikngan yu i kabuluhan ni halimbewa tungkul de agta a nagsapwar ni binhi. ");
INSERT INTO due_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","I bektas a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat misan ay an de pagketinggesan ta nádetong i Satanas a nangagow ni surut a nadeinnawa de. ");
INSERT INTO due_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nano i kabetoan pan a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat a nanulusun a tambing a te salig a masakut. ");
INSERT INTO due_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Misan an matud i pagpanulusun de ta an te ramut kanya an ide notuloy. Ta pagdetong ni kahedepan pati paglibek dehil de pag-abut de de surut nun Makedepat ay tambing ide a nallagelag. ");
INSERT INTO due_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","I katinekan a kinadegdegen ni binhi ay magi agta ide a gepataliknoy de surut nun Makedepat. Misan ay dehil de pag-esip de ni attanan dio pati de pagbuot de de kayamanan ay nadeog a an gekitong i surut a nadeinnawa de. ");
INSERT INTO due_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nano ay i putok a piyon a kinadegdegen ni binhi ay magi agta ide a gepatalingoy de surut nun Makedepat a gekatingges pala a matud. I oyo ide i talage a gepinag-anak ni isin a dian, anim a puwu pati tiluwon a puwu.” ");
INSERT INTO due_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tinodu pala ni Hisus i halimbewa a oyo dide ta sinabi na, “Be te kapangyedihan di i Makedepat de innawa ni agta ay inon ay magi isin a agta a gepasok ni piyon a binhi de kaengin na. ");
INSERT INTO due_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dingan nun isin a abi a napede un kaagtaan ay dinumatong i kapagebuk ni nagpasok ta pinasokan na ni malot a demo i kaengin a pinasokan pala ni piyon a binhi ta dingan tinumotul. ");
INSERT INTO due_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kanya nun tinumubu di un piyon a binhi a nagkaanak di ay tinumubu pala i malot a demo. ");
INSERT INTO due_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dingan linumane un katabeng ide de ponu de ta sinabi de diya, ‘Ay piyon i binhi a pinasok yu nunde kaengin yu kanya ti deno inumapo i demo a malot?’ ");
INSERT INTO due_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tinumubeg eya, ‘I isin a kapagebuk ko i te yedi ninon.’ Kanya tinanto de un ponu de, ‘Buot yu man a burnutin mi i demo na ide?’ ");
INSERT INTO due_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Wet di ta kati napakebúrnut yu pala i piyon a tanom. ");
INSERT INTO due_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pabiyaan yu la ide a humanga a padepade hanggen de tigguto ta de tigguto ay sasabi ko de magguguto a tipunin de ngona i malot a demo na ide a giptan de ta sunugin misan ay i piyon a binhi a ginuto ay tipunin de de kamálig ko.’ ” ");
INSERT INTO due_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Te isin pan di a halimbewa a tinodu dide ni Hisus a magioyo, “Be te kapangyedihan di i Makedepat de innawa ni agta ay inon ay magi isin a binhi a mustasa a tinanom ni isin agta de kaengin na. ");
INSERT INTO due_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ta eya i kauntekan de pesan a binhi misan ay be natanom di a hinumanga di ay nappa ni hanga pa de pesan a gemut ni golay ta iwina ay nappa ni gemut ni kew ta duman di gepoged i kamanokan.” ");
INSERT INTO due_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ay nagsabi i Hisus ni isin pa a halimbewa, “Be te kapangyedihan i Makedepat de innawa ni agta ay inon ay magi pahelab a dinugeng ni isin a mahuna de tiluwon a tákal a harena a te dugeng a orat kanya kinumálat un pahelab de pesan a harena.” ");
INSERT INTO due_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nano ay de pesan a pagtodu ni Hisus de kaagtaan ide ay ginamit na i halimbewa ide ta an eya te pagtodu a an te dugeng a halimbewa ide. ");
INSERT INTO due_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ta de maginon ay nangyedi di i hinola ni magsasabi a sinabi na, “Gesurut ok de kaagtaan de padean ni halimbewa ide ta pepatingges ko dide i tinagu a kamatoden gepo nun yinadi i putok i.” ");
INSERT INTO due_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pagkatapos ninon ay winalat ni Hisus un agta ide ta sinumilong nunde beloy ta linumane diya un mag-aadel na ide ta sinabi de diya, “Patinggesin yu tebe dikami i halimbewa a tungkul de malot a demo de kaengin.” ");
INSERT INTO due_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kanya tinumubeg dide i Hisus, “I gepasok nun piyon a binhi ay ako a Pineta nun Makedepat a napa ni agta. ");
INSERT INTO due_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I kaengin ay i belang lugel de putok i ta i piyon a binhi ay i belang agta a te kapangyedihan ni Makedepat de innawa de. Misan ay i malot pan a binhi a demo ay i manga agta a te kapangyedihan ni Satanas dide. ");
INSERT INTO due_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ta i kapagebuk pan a nagpasok ni malot a demo ay i Satanas. Nano ay i panahon a tigguto ay i inapóan a adow ta i magguguto pan ay i manga anghel ide. ");
INSERT INTO due_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ta ti papalano a tetipun i malot a demo a sosunug ay maginon pala i nangyeyedi de inapóan a adow. ");
INSERT INTO due_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta de inon a adow ay ako a Pineta nun Makedepat a napa ni agta ay dododul ko i manga anghel ko ide tangani tetipun de i manga agta a gepapagkasala de kakmukan, a geyedi pala ni mammalotin. Ta bobukud de i tinipun ide de agta a te kapangyedihan ni Makedepat de innawa de. ");
INSERT INTO due_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ta wewitik de i binukud ide de apoy a padusahan ta duman ay nátangos ide a náaratengot i ngipon de dehil de pagtiis de. ");
INSERT INTO due_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ta dingan i te malenis ide a innawa a an te mammalotin de pekita ni Makedepat ay gepakaingap ide a magi adow, a kakoloy ni Ama de a Makedepat de kataanan na kanya i misan ino a gepatalikngoy ay depat a tumalinga.” ");
INSERT INTO due_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sinabi ni Hisus a tuloy, “Be te kapangyedihan i Makedepat de innawa ni agta ay inon ay magi kayamanan a nattapor de isin a kaengin ta nakutkutan yo ni isin a agta. Ta tinaporan na la a liwet. Ta dehil de hanga a salig na ay inumuli eya ta pinanggetang na i pesan a te duman diya. Ta ginatang na i kaengin a inon. ");
INSERT INTO due_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Magioyo pala be te kapangyedihan i Makedepat de innawa ni agta ta inon ay magi magtitinde a gelawag ni mahalage ide a perlas. ");
INSERT INTO due_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ta nun makakita di ni isin a perlas a pinakamahalage ay inumuli ta pinanggetang na i pesan a te duman diya ta ginatang na inon a perlas. ");
INSERT INTO due_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pati pan magioyo pala be te kapangyedihan i Makedepat de innawa ni agta ta inon ay magi isin a pokut a dinagdeg de atab ta nakámit ni sadisadi a ikan. ");
INSERT INTO due_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nun mapino di un pokut ay sinaka nun mag-iekan ide nunde langges ta nagilinepa ide a pineta de i pippiyonin a ikan a inunid de oniden de ta binut de pan i an ide te kabuluhan. ");
INSERT INTO due_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Maginon pala i nangyeyedi de inapóan a adow ta pagdetong ni manga anghel ide ay kekiblag de i makikkakasalanan ide de te malenis ide a innawa de pekita ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ta wewitik de i makikkakasalanan ide de apoy a padusahan ta duman ay nátangos ide a náaratengot i ngipon de dehil de pagtiis de.” ");
INSERT INTO due_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Dingan tinanto ide ni Hisus, “Katinggesan yu man di i pesan a oyo?” Tinumubeg ide, “Ay-o.” ");
INSERT INTO due_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kanya sinabi na dide, “Be te duman a magtutodu ni Hudyo a te kapangyedihan pala diya i Makedepat ay eya ay magi isin a te adi ni beloy a te den pati bowon a kasangkapan de pigpuoyen na ta getodu eya ni den a pagtodu pati bowon.” ");
INSERT INTO due_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nun sinabi di ni Hisus i halimbewa a inon ide ay tinumotul eya duman. ");
INSERT INTO due_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ta inumuli eya de benwaan na a sadili a nagtodu de pigmitengan ide a Hudyo duman. Ta nagtaka i inumikna ide diya kanya sinabi de, “Deno man nangamit i agta a iwina ni katinggesan na a oyo? Pati ti papalano man eya a gepakayedi ni gepakataka? ");
INSERT INTO due_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Am man iwina i anak nun magyeyedi ni beloy? Am man iwina i anak ni Maria? Ta eya ay kabinsa nide Santiago, Hose, Hodes pati Simon. ");
INSERT INTO due_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ta dio nappataan i manga wele na a kamahunaan. Kanya deno nangamit i agta a iwina ni pesan a katinggesan na a oyo?” Inon i pinasurutsurotan de, ");
INSERT INTO due_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ta kinapoyen de eya kanya sinabi dide ni Hisus, “Talage ngani a i magsasabi ay pegelang misan deno puwide la de sadile na a lugel pati de mittanak na.” ");
INSERT INTO due_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ta an gepakayedi i Hisus ni makmuk a gepakataka de sadile na a lugel dehil de an ide nagpanulusun diya. ");
INSERT INTO due_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nano ay nun panahon a inon ay nakadetong de Gubernador a Herod de Galilea i bereta a tungkul de Hisus. ");
INSERT INTO due_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ta sinabi na nunde katabeng na ide, “Eya ay i Huwen a Maglilenod a pinakaedup a liwet kanya eya ay gepakayedi di ni maginon ide a gepakataka.” ");
INSERT INTO due_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nano ay nun nagbebi i Herod de Herodeas a bebi ni Pilepi a wele na ay sinosol ni Huwen i Herod, “An nappaayun de pagdodul a binabian yu i bebi ni wele yu.” Pagkasabi na ninon ay pinadekop, pinagepus pati pinabilanggo ni Herod i Huwen dehil de Herodeas. ");
INSERT INTO due_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Buot a pobunu eya ni Herod misan ay nagkatakut eya de manga Hudyo ide ta peabuyenan de a i Huwen ay magsasabi a matud ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nano ay nun dinumatong di i kapanganakan ni Herod ay sinumayew i anak ni Herodeas a maddikit de kasagkaden ni biseta ide ta masakut a nasalig i Herod. ");
INSERT INTO due_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kanya sinumumpa i Herod a boboy na de maddikit i misan ano a agedin na. ");
INSERT INTO due_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kanya gepo de buot ni ina na ay sinabi ni maddikit, “Boyin yu deko nano i ulo ni Huwen a Maglilenod a nappuoy de isin a pinggen.” ");
INSERT INTO due_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nalungkut dila i Herod nun iknain na inon. Misan ay dehil de pinangako na a inikna ni biseta ide ay dinodul na a boyin de maddikit i peaged na. ");
INSERT INTO due_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kanya pinaputolan na i Huwen de bilanggoan. ");
INSERT INTO due_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ta pinuoy ni dinodul un ulo de isin a pinggen a binoy na de maddikit ta binoy pan nun maddikit nunde ina na. ");
INSERT INTO due_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Misan i mag-aadel ide ni Huwen ay dinumatong ta inamit de i bengkay ni Huwen a tinapor de ta dingan binareta de de Hisus. ");
INSERT INTO due_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nano ay nun nabereta yo ni Hisus ay sinumakoy ide Hisus de isin a bengka a paagow de lugel a ilang a alayu de kamakmokan. Misan ay nun matinggesan pan ni kamakmokan a tinumotul ide Hisus ay binumulwag ide de benwaan de a inumabut ide diya a getotul de langges. ");
INSERT INTO due_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pagsaka ni Hisus ay kinta na i makmuk a masakut a kaagtaan ta kinalbian na ide a pinapiyon na i te manga orom ide. ");
INSERT INTO due_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nun apun di a masakut ay linumane diya un mag-aadel na ide ta sinabi de, “Ilang yo a lugel a mandeli di a nelinod i adow. Pakangin yu di i kaagtaan de buluberiyu tangani manggetang ide ni pápangan de.” ");
INSERT INTO due_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“An di kaelangan a patotulin pa ide.” Inon i tinubeg ni Hisus, “Ta ikamo ngani i nongungut dide.” ");
INSERT INTO due_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ay tinumubeg pan ide diya, “Lima la i tinapay tam pati aduwa a ikan.” ");
INSERT INTO due_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Sinabi ni Hisus, “Addein yu dio.” ");
INSERT INTO due_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ta pinalipa na i kaagtaan de kademoan ta dingan inamit na i lima a tinapay pati aduwa a ikan. Ta tinumingala eya de langot a nagpasalamat dingan pinisangpisang na un tinapay ide a binoy na de mag-aadel na ide. Ta ide pan i nagbuluboy de kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nakapangan ide a pesan a sukul. Nano nun tinipun ni mag-aadel na ide un an de naubus a kulukapisang ay nakapino ide ni sangpuwu pati aduwa a gelálan. ");
INSERT INTO due_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Te manga lima a lebu a lalaki a namangan puwide pa i mahunain pati mangának. ");
INSERT INTO due_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dingan tambing a pinasakoy ni Hisus i mag-aadel na ide de bengka ta pinaona na ide nunde dipa nun uluataben ta un agta pan ide ay pinauli na di. ");
INSERT INTO due_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagkatotul nun agta ide ay sinumakat i Hisus de pagotan tangani manalangin. Nano ay nun abi di ay lallan i Hisus de pagotan. ");
INSERT INTO due_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Misan ay un bengka pan ay duman di nunde ditow nun uluataben a te panganib dehil de labun ta nappasongsong de palos. ");
INSERT INTO due_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nano ay nun mandeli di a adow ay inumabut dide i Hisus a getotul de disapow ni uluataben. ");
INSERT INTO due_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Misan ay nun kinta ni mag-aadel na ide a eya ay getotul de disapow ni atab ay pinangilabutan ide a te takut ta gepo de inon ay nagiinolang ide a, “Binuswal kitam di.” ");
INSERT INTO due_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Misan ay tambing pan ay nagsurut dide i Hisus ta sinabi na, “Wet kamo matakut ta patibongin yu i innawa yu ta ako yo a i Hisus.” ");
INSERT INTO due_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dingan nagsurut i Pedro ta sinabi na, “Panginoon, be talage a ikamo nay ay padenain ok yu dikamo de disapow ni atab.” ");
INSERT INTO due_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tinubeg na diya, “Dumio ka.” Ta linumusong i Pedro de bengka ta nakatotul de disapow ni atab a palane de Hisus. ");
INSERT INTO due_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Misan ay nun kinta na un hangain a labun dehil de palos ay te gepo eya a natakut pati te gepo pala a gelinod kanya inolang na de Hisus, “Panginoon, ligtasin ok yu.” ");
INSERT INTO due_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tambing a inuma ni Hisus i Pedro a sinabi na diya, “Untik a masakut i pagpanulusun mo. Bekot ta geaduwa i esip mo?” ");
INSERT INTO due_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Dingan pagkasakoy de nunde bengka ay tinumimok di un palos. ");
INSERT INTO due_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ta pinodi eya ni pesan duman nunde bengka ta sinabi de, “Talage a matud a ikamo ngani i Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nun pagkasabusabu de nunde dipa ay dinumatong ide de sákup ni Genesaret. ");
INSERT INTO due_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ay nun inabuyenan i Hisus nun tage duman ide ay tambing de a pinabereta de pulupalebut ninon a lugel kanya inadde de de Hisus i pesan a te orom. ");
INSERT INTO due_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ta inaged de diya i pesan a te orom a patapáin na ide misan de rimong ni bedu na ta i pesan pan a tinumapá de rimong na ay pinumiyon a talage. ");
INSERT INTO due_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nano ay te linumane de Hisus a tipide a Pariseo pati magtutodu ide ni Hudyo a inumapo de Herusalem ta tinanto de eya, ");
INSERT INTO due_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bekot ta an getalinga i mag-aadel yu ide de ugeli a natinggesan tam nun de kaapoapohan tam ide? Ta gepangan ide ni tinapay, a an ide geuges ni kumot de a nappaayun de ugeli tam.” ");
INSERT INTO due_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tinubeg ide ni Hisus, “Bekot pala ta ang kamo getalinga de pagdodul ide ni Makedepat dehil de ugeli yu a inumapo de kaapoapohan yu ide. ");
INSERT INTO due_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ta pinasabi ni Makedepat de Moises a, ‘Gelangin mo i ama mo pati ina mo ta i magsabi ni malot de ama pati ina na ay depat a malibun.’ ");
INSERT INTO due_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Misan pan ay petodu yu a be pesabi ni agta de kamoddenan na a, ‘Anok di te natatabeng dikamo ta i pesan ko a adi ay pinangako ko di de Makedepat.’ ");
INSERT INTO due_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ta de maginon ay an getabeng i manga agta de kamoddenan de ide. Ta peeyenan yu ni kabuluhan i surut nun Makedepat dehil de pag-abut yu de ugeli yu a Hudyo. ");
INSERT INTO due_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pesabi yu kon a an yud peyedi i malot misan ay peyedi yu mangan la. Matud ngani i hinola ni Isais a tungkul dikamo ta sinabi ni Makedepat, ");
INSERT INTO due_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘I oyo ide a kaagtaan ay gegelang deko de nguso de la misan an te paggelang a matud de innawa de. ");
INSERT INTO due_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kanya i pagpodi de deko ay an te kabuluhan ta i pagtodu de ay geapo la de agta, a an geapo deko a magi pesabi de.’ ” ");
INSERT INTO due_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dingan pinalane ni Hisus i kaagtaan ta sinabi na dide, “Patalikngan yu a pesan ta esipin yu i sasabi ko i. ");
INSERT INTO due_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","An i gesilong a pápangan de nguso ni agta i gepakapagpadiplot diya de pekita ni Makedepat ta i gebulwag pan a mammalotin a surut a geapo de nguso na.” ");
INSERT INTO due_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pagkasabi na ninon ay linumane diya un mag-aadel na ide ta sinabi de, “Katinggesan yu man a nagkaapdisan i Pariseo ide de sinabi yu?” ");
INSERT INTO due_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tinumubeg i Hisus, “Boburnut i pesan a halaman a an tinanom ni Ama ko de langot. ");
INSERT INTO due_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabiyaan yu ide ta ide ay magi bulag a magtutodu a an te katinggesan ta be gekabitan i padepade a bulag ay padepade pala ide ay naddegdeg de bulsut.” ");
INSERT INTO due_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ta sinabi ni Pedro diya, “Patinggesin yu tebe dikami i halimbewa a inon.” ");
INSERT INTO due_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kanya sinabi na dide, “Pati ikamo mangani ay ang kamo pa te katinggesan? ");
INSERT INTO due_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","An yu man katinggesan a anoman a gesilong a pápangan de nguso ni agta ay tuloy la de tiyen ta bobut na la. ");
INSERT INTO due_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Misan i gebulwag pan a surut de nguso ni agta a geapo de innawa na ay inon i gepakapagpadiplot diya de pekita ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ta de innawa na pan geapo i mammalotin a esip, panlalaki, pammahuna, pagpakialam de bebi ni kakmukan, pagpannakow, pamuno, pagpamatud de kabutelan pati pagpintas de kakmukan. ");
INSERT INTO due_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Inon ide i gepakapagpadiplot de agta ide. Misan ay i mamangan ni an nag-uges ni kumot a magi pesabi de ay an non gepakapagpadiplot de agta ide.” ");
INSERT INTO due_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nano ay tinumotul i Hisus duman a kinumang de sákup ni benwaan a Tiro pati Sidon. ");
INSERT INTO due_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pagkadetong na ay linumane diya i isin a mahuna a an Hudyo a getaan de lugel a Kanaan ta malagdu a sinabi na, “Panginoon, a apo ni Debid, makalbi kamo deko ta i anak ko a mahuna ay te libong de lawes na ta nagkahedepan a masakut.” ");
INSERT INTO due_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Misan ay an tinubeg ni Hisus ta linumane diya un mag-aadel na ide a sinabi de diya, “Piyon pa a patotulin yu di eya tangani an mangalangala a geabut dikitam.” ");
INSERT INTO due_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tinumubeg i Hisus, “Pinaatid ok la dio de putok i para de topa ide a nalagelag a tage Israel.” ");
INSERT INTO due_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Misan ay linumane diya un mahuna a nagpodi de kasagkaden na ta sinabi na, “Panginoon, tabengan ok yu tebe.” ");
INSERT INTO due_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tinumubeg i Hisus, “An depat a i pápangan ni mangának ay wewitik de manga tito.” ");
INSERT INTO due_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Matud ngan non Panginoon,” tinubeg ni mahuna, “Misan i manga tito pan ay gepangan ni mumu a nagkadegdeg de pigpanganan ni Panginoon de.” ");
INSERT INTO due_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kanya sinabi diya ni Hisus, “Kabinsa a mahuna, talage a hanga i pagpanulusun mo kanya nappaayun de buot mo ay nangyeyedi i peaged mo.” Ta nun nanon pala a odes ay pinumiyon un anak na. ");
INSERT INTO due_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pag-apo duman ni Hisus ay inumampulang a sinumila de kaginglan ni uluataben a Galilea. Ta dingan eya ay sinumakat de pagotan a linumipa duman. ");
INSERT INTO due_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Am pa náloy ay nagidinatong i kaagtaan ide a te manga adde a pilay, kimaw, bulag, bunol pati makmuk pa a kakmukan a te manga orom. Ta pinuoy de ide de kasagkaden ni Hisus ta pinapiyon na ide. ");
INSERT INTO due_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kanya nagtaka un kaagtaan ide nun kinta de a gepakasurut di un bunol ide, a pinumiyon di un kimaw ide, a nakatotul di pala un pilay ide pati nakakita un bulag ide. Ta ide a pesan ay nagpodi de Makedepat a pepodian pala ni manga Hudyo hanggen nun de gepo. ");
INSERT INTO due_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ta pinalane ni Hisus un mag-aadel na ide ta sinabi na, “Nagkakalbi ok de manga agta ide a oyo ta tiluwon di a adow a kakoloy ko ide ta an di ide te pápangan. Ta ang ko pan buot a pouli ide a nagketiggeng ta kati malinog ide de bektas.” ");
INSERT INTO due_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ta tinubeg eya ni mag-aadel na ide, “Deno kitam nángamit ni tinapay a nosukul de magioyo a kamakmuk a agta ta ilang yo a lugel.” ");
INSERT INTO due_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tinanto ni Hisus dide, “Pide man i tinapay yu dena?” “Pito la pati tipide a untekin a ikan,” i tubeg de. ");
INSERT INTO due_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dingan pinalipa ni Hisus i kaagtaan de putok. ");
INSERT INTO due_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta inamit na i pito a tinapay pati ikan ide ta pagkapagpasalamat na de Makedepat ay pinisangpisang na inon ide. Ta binoy na de mag-aadel na ide tangani buluboy de de manga agta ide. ");
INSERT INTO due_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nakapangan i pesan a sukul. Ta nun tinipun de un an de naubus a kulukapisang ay nakapino ide ni pito a gelálan. ");
INSERT INTO due_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Te duman a apat a lebu a lalaki i namangan puwide pa i mahunain pati mangának. ");
INSERT INTO due_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Dingan pinatotul ni Hisus i kaagtaan ide ta sinumakoy eya de bengka a paagow de lugel a Magadan. ");
INSERT INTO due_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nano ay dinumatong dide Hisus i tipide a Pariseo pati Saduseo ide ta nag-aged ide diya a magpakita eya ni gepakataka a gepo de langot, a gepamatud de kapangyedihan na misan ay pedeya de la eya. ");
INSERT INTO due_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kanya tinumubeg dide i Hisus, “De kadepit a apun ay pesabi yu a masampat i panahon diage ta matallang i langot nano. ");
INSERT INTO due_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pati de abiabi ay be te kodipot ay sasabi yu ay nátapok nano ta madumos i langot. Talage ay peabuyenan yu i manga tande a inon de langot misan ay an yu pan peabuyenan i manga tande a gepamatud de pagyedi ni Makedepat de nano a panahon. ");
INSERT INTO due_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Malot i ugeli ni agta de nano a panahon ta an ide depat a ponulusunan. Gelawag ide ni gepakataka misan ay an ide te kekita ti an i magi gepakataka a nangyedi de magsasabi a den a Honas.” Pagkasabi na ninon ay tinumotul ide Hisus de kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nano ay sinumabusabu ide pati mag-aadel na ide de dipa misan ay nakalipat pan ide ni tinapay a pápangan de. ");
INSERT INTO due_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nano ay sinabi ni Hisus dide, “Mag-engat kamo pati umelag de pahelab ni Pariseo pati Saduseo ide.” ");
INSERT INTO due_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kanya nasurutsurotan i mag-aadel na ide ta sinabi de, “Kanya na non sinabi ay ang kitam te adde a tinapay a sukul.” ");
INSERT INTO due_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Misan ay katinggesan pan ni Hisus i pasurutsurotan de kanya sinabi na dide, “Talage a untik i pagpanuluson yu deko. Bekot ta nasurutsurotan kamo a ang kamo te adde a tinapay a sukul? ");
INSERT INTO due_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","An yu pa man peabuyenan i kapangyedihan ko? Wet yu kelipatan a pinisangpisang ko i lima a tinapay a para de lima a lebu a lalaki ta katinggesan yu tipide a gelálan i napino yu nun an naubus ide. ");
INSERT INTO due_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pati wet yu kelipatan a pinisangpisang ko i pito a tinapay a para de apat a lebu a lalaki ta katinggesan yu tipide a gelálan i napino yu nun an naubus ide. ");
INSERT INTO due_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kanya bekot ta an yu katinggesan a anok nagsabi a tungkul de tinapay a pepangan misan ay pepapag-engat ko ikamo de pahelab ni Pariseo pati Saduseo ide.” ");
INSERT INTO due_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dingan kinatinggesan ni mag-aadel na ide a ide ay pepapag-engat na de pagtodu ni Pariseo pati Saduseo ide ta an pahelab a pegemit de tinapay. ");
INSERT INTO due_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nano ay nun dinumatong ide Hisus de sákup ni Sesarea Pilepos ay tinanto na i mag-aadel na ide a magioyo, “Ako a Pineta nun Makedepat a napa ni agta ay ino ok kon pesabi ni kaagtaan?” ");
INSERT INTO due_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dingan tinumubeg ide diya, “I pesabi ni tipide ay i Huwen kamo a Maglilenod. I kakmukan pan ay pesabi de a ikamo ay i Elias pati te duman pa a gesabi a ikamo ay i Heremias o ikamo kon ay isin de magsasabi ide a den.” ");
INSERT INTO due_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Dingan tinanto na ide, “Ikamo pan ay ano i nasasabi yu tungkul deko? Ino ok?” ");
INSERT INTO due_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ta tinumubeg i Simon Pedro, “Ikamo ay i Kristo a Pinangako nun Makedepat a an te kalebunan a i Anak na.” ");
INSERT INTO due_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ta sinabi diya ni Hisus, “Piyon i kapuoyen yu, Simon a anak ni Honas ta i kamatoden a oyo ay an pinakita dikaw ni misan ino a agta ti an i Ama ko la a Makedepat de langot. ");
INSERT INTO due_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta pesabi ko pan dikaw, Simon, a ikaw ay Pedro a te kabuluhan ‘beto’ pati gepo de inon a magi denpa ay pouddi ko i beloy ko a i pesan a gepanulusun a kapolongan. Ta i kapangyedihan ni Satanas ay an nanalo dide. ");
INSERT INTO due_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ta boboy ko dikaw i kapangyedihan ko a magi kapangyedihan ko a geapo de langot. Ti anoman i gegiptan yu dio de putok i ay gegiptan pala de langot. Ta i oukasan yu dio ay oukasan pala de langot.” ");
INSERT INTO due_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dingan sinabi dide ni Hisus a mahigpit a, “Wet yu sasabia misan dino a ako i Kristo a Pinangako nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nano ay gepo nun nanon ay sinabi na a matallang de mag-aadel na ide a depat a kumang eya de Herusalem a magtiis ni makmuk a kahedepan dehil de pinakamatande ide, ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo. Ta eya ay pobuno de a tuloy misan ay de katiluwon a adow ay pakeedup eya a liwet. ");
INSERT INTO due_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Dingan inakit eya ni Pedro de alayu a untik ta sinabi na diya a magioyo, “Panginoon, wet tebe non mangyedi kapide man dikamo.” ");
INSERT INTO due_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Misan ay sinumagkad i Hisus de mag-aadel na ide ta dingan sinosol na i Pedro, “Lumayu ka Satanas, de alane ko i ta peabetan ok mo ta i peesip mo ay an inumapo de Makedepat ta de agta la.” ");
INSERT INTO due_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dingan sinabi ni Hisus de mag-aadel na ide a magioyo, “I misan ino a te buot a nappa ni mag-aadel ko ay depat a kapoyen na ngona i kabuotan na a sadili ta depat a magtiis ni kahedepan a kosa a innawa a magi ako dingan geabut pala de ugeli ko. ");
INSERT INTO due_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ta i te buot a gealáge de edup na dio de putok i ay neeyenan ninon misan ay i geboy ni edup na para deko ay eya ngani i gekaduman ni edup a bowon. ");
INSERT INTO due_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Talage ay an te pakinabeng a matud i misan ino a agta a te adi ni pesan dio de putok i, a am pan te duman a edup a bowon. Ta an te misan ano a nappatud a bebeyed ni agta de inon a edup a bowon. ");
INSERT INTO due_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ta ako a Pineta nun Makedepat a napa ni agta ay nolusong ok a an naaloy a te gepakaingap ni Ama ko a te kakoloy pala ni manga anghel na ide ta de inon a panahon ay bebilosan ko i belang agta a nappaayun de pagyedi de. ");
INSERT INTO due_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Talage ay pesabi ko dikamo a te duman dikamo a an nelibun hanggen an de kekita i ako a Pineta nun Makedepat a napa ni agta ay te kapangyedihan di de innawa ni agta.” ");
INSERT INTO due_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pagkatakig ni anim a adow ay i inikag la ni Hisus ay i Pedro, magwele a Santiago pati Huwen ta sinumakat ide de isin a maditas a kalasan. ");
INSERT INTO due_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nun ide ay duman di ay kinta de a nagkobowon di a masampat i Hisus ta i mukha na ay getallang di a magi adow ta i bedu na pan ay linumapsay di a getallang. ");
INSERT INTO due_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dingan loktat di a kinta ni tiluwon a mag-aadel i Moises pati Elias a magsasabi ide a den a gepakisurut de Hisus. ");
INSERT INTO due_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dingan sinabi ni Pedro de Hisus, “Panginoon, yadi pa ay dio kitam di ta be buot yu ay geyedi kami ni tiluwon a pigpilongan, isin dikamo, isin de Moises pati isin pala de Elias.” ");
INSERT INTO due_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dingan nun gesurut pa eya ay loktat a kinumalinongan dide i kunom a gepakaingap. Ta te inumapo duman a surut a magioyo, “I oyo i Anak ko a pebuot ta eya i kasalegan ko kanya magtalinga kamo diya.” ");
INSERT INTO due_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nun inikna nun mag-aadel na ide un surut a inon ay natakut ide a masakut ta ide ay napaobbob de putok. ");
INSERT INTO due_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Misan ay linanean ide ni Hisus a tinapá na ide ta sinabi na, “Umuddi kamo a wet kamo matakut.” ");
INSERT INTO due_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Dingan nun tinumingala ide ay an di ide te kinta ti an i Hisus dila a lallan. ");
INSERT INTO due_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nano nun ide ay gedolug di nunde kalasan ay dinodul ni Hisus dide a sinabi na, “Wet yu sasabia misan dino i kinta yu hanggen an nagkaedup a liwet i ako a Pineta nun Makedepat a napa ni agta.” ");
INSERT INTO due_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nano ay tinanto eya ni mag-aadel na ide a magioyo, “Buot mi tebe a matinggesan ti ano ta pesabi ni magtutodu ide ni Hudyo a depat ngona a nádetong i Elias a magsasabi a den dingan pa i Kristo a Pinangako na.” ");
INSERT INTO due_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Dingan tinumubeg eya dide, “Talage a pesabi ni kasulatan a nádetong ngani i Elias a tagibu tangani handein na i pesan para de Kristo. ");
INSERT INTO due_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Misan pesabi ko dikamo a nakadetong di i Elias misan pan ay an eya inabuyenan ni manga agta ide ta yinadi de diya i malot a nappaayun de buot de. Maginon pala ako a Pineta nun Makedepat a napa ni agta ay pehedepan de.” ");
INSERT INTO due_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dingan kinatinggesan nun mag-aadel na ide a i Huwen a Maglilenod i buot na a sasabi ay i Elias. ");
INSERT INTO due_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nano ay nun pagdetong de de kamakmokan a agta ay linumane a linumuhud de kasagkaden ni Hisus i isin a lalaki ta sinabi na, ");
INSERT INTO due_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Panginoon, kalbian yu tebe i anak ko a lalaki ta eya ay ugnay a nagkopugtusan a nagkehedepan a masakut pati ugnay eya a nagkaddegmak de apoy o de libtong a orat. ");
INSERT INTO due_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Misan ay nun inadde ko eya de mag-aadel yu ide ay an de napalayu.” ");
INSERT INTO due_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ta tinumubeg i Hisus, “Ikamo a kaagtaan de nano a panahon ay am pa te pagpanulusun ta maksa i innawa yu. Hanggen kapide ok man depat a kakoloy yu a getiyage dikamo?” Dingan sinabi na de lalaki, “Addein yu dio un anak yu.” ");
INSERT INTO due_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dingan dinodul ni Hisus un libong a lumayu de lawes na ta napalayu na di, a pinumiyon di a tambing un anak. ");
INSERT INTO due_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pagkatapos ninon ay linumane i mag-aadel na ide de Hisus ta tinanto de eya de an te geikna a kakmukan a magioyo, “Ano pan ta am mi napalayu un libong?” ");
INSERT INTO due_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tinubeg ide ni Hisus, “Kanya yu an napalayu ay dehil de an sukul i pagpanulusun yu. Pesabi ko ngani dikamo a be i pagpanulusun yu de Makedepat ay gehanga a magi untik a binhi a mustasa a nappa ni hanga a gemut a golay ay nappatud a dododul yu i kalasan a oyo, ‘Umalis ka duman.’ Ay dingan náalis ngani. Ta ti ano i sasabi yu ay inon i nangyeyedi. ");
INSERT INTO due_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Misan ay i oyo a kalase a libong ay an napálayu be an te pagpanalangin pati an pamangan ni untik a panahon.” ");
INSERT INTO due_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nano ay nun pagsila de duman de sákup ni Galilea ay sinabi ni Hisus dide, “I ako a Pineta nun Makedepat a napa ni agta ay padekop nunde manga agta, ");
INSERT INTO due_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","a bobuno a tuloy misan ay de katiluwon a adow ay pakeedup ok a liwet.” Pagkasabi na ninon ay nalungkut a masakut i mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagdetong de de benwaan a Kapernam ay linumane de Pedro i magsisengil ide ni buwis para de beloy a pighandogen de Makedepat de Herusalem ta tinanto de, “Gebeyed man ni buwis para de beloy a pighandogen de Makedepat i magtutodu yu na?” ");
INSERT INTO due_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Ay-o,” i tubeg ni Pedro ta nun dinumatong di eya nunde beloy ay tinanto eya a tagibu ni Hisus, “Simon, anoman i peesip mo? Dino man gepasingil i Hari ide ni buwis, de mangáyun na man o de nasasakopan ide a bensa?” ");
INSERT INTO due_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Dingan tinumubeg i Pedro, “I nasasakopan na a bensa.” Ta sinabi ni Hisus, “Be maginon ay an gebeyed ni buwis i mangáyun na ide. ");
INSERT INTO due_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Misan ay dumuman ka de atab ta magbiwes ka ta amitin mo i tagibu a náamit mo a ikan dingan bukain mo i nguso na ta te kekita ka a isin a kuwarta a pelak. Ay amitin mo ta magbeyed ka para dikita a aduwa tangani i kaagtaan ay an te nasasabi.” ");
INSERT INTO due_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nun nanon ay linumane de Hisus i mag-aadel na ide ta ide ay nagtanto diya, “Ino man i maditas pa be te kapangyedihan di i Makedepat dio de putok i?” ");
INSERT INTO due_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dingan pinalane ni Hisus i isin a anak ta pinauddi na de kasagkaden de. ");
INSERT INTO due_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ta sinabi na, “Talage ay pesabi ko dikamo a be ang kamo gepakasidong ni innawa yu a magi anak a oyo ay talage ay an nappatud a nakesilong kamo de kataanan nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kanya i misan ino a gepakasidong ni innawa na a magi anak a oyo ay eya ngani i nappa ni pinakamaditas be te kapangyedihan i Makedepat dio de putok i. ");
INSERT INTO due_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pati i misan ino a getanggep a piyon dehil deko ni magi anak a oyo a te masidong a innawa ay ako ngani i petanggep na. ");
INSERT INTO due_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nano ay tungkul pan de misan ino a gepapagkasala de am pa náloy a gepanulusun deko ay yadi pa ngona a inon a agta ay gipotan de bong na ni hanga a beto a degdegin eya de ditow a atab. ");
INSERT INTO due_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gepakatakut i násapit de agta dio de putok a gepapagkasala de gepanulusun deko. Talage ay ugnay a gedetong i maginon a tukso misan ay gepakatakut i násapit de gepapagkasala. ");
INSERT INTO due_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Be i kumot mo o singit mo i gepapagkasala dikaw ay depat a pugtusin mo a butin mo di ta yadi pa a isin dila i kumot mo o singit mo a nakesilong ka pan de kataanan nun Makedepat, a an magi aduwa i kumot mo o singit mo a nappaduman ka pan de impiyerno a an nagkapalong. ");
INSERT INTO due_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ta be i mata mo i gepapagkasala dikaw ay lugitin mo a butin mo ta piyon pa a lallan i mata mo a nakesilong ka pan de kataanan nun Makedepat, a an magi aduwa i mata mo a nappaduman ka pan de impiyerno. ");
INSERT INTO due_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Kanya mag-engat kamo a wet yedian ni malot i am pa náloy a gepanulusun deko. Ta pesabi ko dikamo ay i manga anghel de langot a ugnay a gealage dide ay de kasagkaden pala ni Makedepat a Ama ko de lango ");
INSERT INTO due_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ta ako a Pineta nun Makedepat a napa ni agta ay dinumio tangani ligtasin ko i nalagelag ide. ");
INSERT INTO due_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Talage a be te duman a agta a te isin a dian a topa dingan nalagelag i isin ay ano nano i yeyedi na? Ay talage ay wawalat na i siyam a puwu pati siyam ta lalawag na ngani un isin a nalagelag. ");
INSERT INTO due_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Dingan be kinta na di ay namas pa i kasalegen na de isin a kinta na de siyam a puwu pati siyam a an nalagelag. ");
INSERT INTO due_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Maginon pala i Ama ko a Makedepat de langot ay an na buot a nalagelag a podusahan i misan isin a am pa náloy a gepanulusun deko. ");
INSERT INTO due_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nano ay be nagkasala dikamo i kabinsa mo ay kangan mo a lallan dingan pagsabian mo de an te geikna a kakmukan. Ta be eya ay nátalinga dikaw ay dingan tinabengan mo eya tangani an nallagelag. ");
INSERT INTO due_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Misan ay be an nátalinga dikaw ay mangikag ka ni isin o aduwa a kabinsa mo tangani i panosol mo diya ay te gepamatud a aduwa o tiluwon. ");
INSERT INTO due_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ta dingan be am pa eya tinumalinga de gepamatud ide ay sabiin yu di de kapolongan a gepanulusun. Nano ay be am pa eya tinumalinga de kapolongan ay yediin yu di eya a magi an di gepanulusun a makikkakasalanan. ");
INSERT INTO due_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Pesabi ko dikamo pala a manga gepanulusun a ti ano man i gegiptan yu dio de putok i ay gegiptan pala de langot ta i oukasan yu dio ay oukasan pala de langot. ");
INSERT INTO due_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pati pan pesabi ko dikamo ay be i aduwa dikamo dio de putok i ay nagkaeisin a geaged de pagpanalangin yu ay talage ay boboy dikamo ni Makedepat a Ama de langot i misan ano a peaged yu diya. ");
INSERT INTO due_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta be te aduwa o tiluwon a gepolong dehil de pagpanulusun de de makapangyedihan a ngalan ko ay kakoloy ok de duman.” ");
INSERT INTO due_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dingan linumane i Pedro de Hisus ta eya ay nagtanto ni magioyo, “Panginoon, pakapide ko man patáwed i kabinsa ko be eya ay gekasala deko a liwet liwet? Pakapito man o eyen?” ");
INSERT INTO due_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ay tinubeg eya ni Hisus, “Ang ko pesabi a pakapito a sila ta pakapito a puwu pati pito pa a liwet. ");
INSERT INTO due_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Kanya i halimbewa be te kapangyedihan i Makedepat de innawa ni agta ay magioyo. Te isin a ponu a binuot na a pepapagbeyed i pesan a taohan na a te manga otang diya. ");
INSERT INTO due_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nano ay nun ginumapo eya a gelawag a ti ino i te otang diya ay tagibu a pinakang na diya ay i te otang ni sangpuwu a lebu a talento a kuwarta (I isin a talento ay manga apat a lebu a peso.) ");
INSERT INTO due_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Misan ay talage a an eya te bebeyed kanya dinodul ni ponu na a panggegetangin eya, bebi na, mangának na pati pesan a adi na tangani eya ay makabeyed. ");
INSERT INTO due_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ay linumuhud i te otang de kasagkaden ni ponu na ta inumaged ni kalbi a sinabi na, ‘Biyen ok yu pa ni pagkakataon tangani bebeyedin ko i pesan ko a otang dikamo.’ ");
INSERT INTO due_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nano ay nakalbi diya un ponu na kanya pinatáwad na eya de pesan a otang na ta pinatotul na di. ");
INSERT INTO due_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Misan ay pagtotul na pan duman ay kinta na i kapadepade na a katabeng a te otang diya ni isin la a dian a pera. Ta loktat na a binolan a binitkol ta sinabi na, ‘Magbeyed ka ni pesan a otang mo.’ ");
INSERT INTO due_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nano ay linumuhud a inumaged i te otang diya a magioyo, ‘Biyen ok yu pa ni pagkakataon tangani bebeyedin ko i pesan ko a otang dikamo.’ ");
INSERT INTO due_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Misan ay an eya tinumalinga ta eya ay pinabilanggo na hanggen de makabeyed. ");
INSERT INTO due_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nun makitan inon ni kapadepade na ide a katabeng ay nagtampo ide dingan kinumang ide nunde ponu de ta sinumbong de inon a yinadi ni te otang a hanga. ");
INSERT INTO due_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kanya pinakangan nun ponu de un te otang a hanga ta sinabi na diya, ‘Malot a masakut i ugeli mo. Ikaw ay pinatáwed ko de pesan a otang mo ta nag-aged ka a patáwadin ko ikaw. ");
INSERT INTO due_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Talage a nakalbi ok dikaw kanya depat pala a nákalbi ka de kapadepade mo a katabeng.’ ");
INSERT INTO due_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dingan pinabilanggo eya ni ponu na dehil de gengsa na hanggen eya ay makabeyed de pesan a otang na a hanga.” ");
INSERT INTO due_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sinabi pa ni Hisus, “Maginon pala i yeyedi dikamo ni Ama ko de langot be an inumapo de innawa yu i pagpatáwad yu de kabinsa yu.” ");
INSERT INTO due_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pagkatapos ni Hisus a gesurut ni pesan a inon ay tinumotul de sákup ni Galilea ta kinumang de kaginglan a sákup ni Hudia a tinumuloy pala de dipa ni Horden. ");
INSERT INTO due_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Misan ay inumabut diya i makmuk a agta ta pinapiyon na duman i te manga orom. ");
INSERT INTO due_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ay te duman pan a manga Pariseo a linumane diya ta eya ay pedeya de la de padean ni tanto a magioyo, “Nappaayun man de pagdodul ide a kumiblag i lalaki de bebi na de misan ano a dehilan?” ");
INSERT INTO due_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tinumubeg i Hisus, “An yu pa man nagkabesa i naddekasulatan a gepo pa nun yinadi ni Makedepat i pesan ay yinadi na i lalaki pati mahuna a gebebian ide a tuloy. ");
INSERT INTO due_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kanya sinabi ni Makedepat, ‘Dehil de inon ay depat a wawalat ni lalaki i kamoddenan na ide a nekikoloy de bebi na ta ide a aduwa ay napa ni isin a lawes.’ ");
INSERT INTO due_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kanya ide ay an di aduwa ta isin dila. Pati i pinapagkoloy ni Makedepat ay wet pepapagkiblag ni agta la.” ");
INSERT INTO due_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tinanto eya ni Pariseo ide a liwet, “Be maginon ay ano pan ta dinodul ni Moises a depat a biyen ni lalaki i bebi na ni kasulatan a ide ay nagkiblag di dingan ngona eya ay kumiblag di de mahuna?” ");
INSERT INTO due_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tinumubeg i Hisus, “Ay-o, pinabiyaan ni Moises a kiblagen yu i bebi yu dehil de ikamo ay te maksa a innawa misan ay an maginon nun tagibu pa. ");
INSERT INTO due_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kanya pesabi ko dikamo a be kekiblagen ni lalaki i bebi na a am pan te kasulit a kakmukan a lalaki ay te kasalanan a pagpakialam inon a lalaki a gebebi a liwet de kakmukan. Ta be magbebi a liwet i mahuna ay nappa ni migpakialam i bebi na a bowon.” ");
INSERT INTO due_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Dingan sinabi diya ni mag-aadel na ide, “Be maginon i nangyeyedi de lalaki pati mahuna ay yadi pa a wet di gebebi.” ");
INSERT INTO due_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Misan ay tinumubeg i Hisus dide, “An pesan i te kaya a an gebebi ti an i tinab-bengan la ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta te duman a bukud bukud a dehilan a an gebebi i lalaki. Te duman a pinanganak a an te buot a gebebi. I kakmukan pan ay an te buot a gebebi dehil de pagyedi ni kakmukan a agta ta te duman pala i an te buot a gebebi tangani te kaya pa ide a geabut de kabuotan ni Makedepat. Kanya i depat a getanggep ni oyo ay i petabengan la ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dingan te nangadde pan de Hisus ni mangának de, a gepinag-aged diya a tapáin na ide, a manalangin para dide misan ay sinablow pan ni mag-aadel na ide i kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Dingan sinabi ni Hisus, “Pabiyaan yu a lumane deko i mangának ta wet yu ide sablowa ta katinggesan yu a de kapadepade de a te masidong a innawa, te kapangyedihan i Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ta tinapá na ngani ide ni kumot na dingan eya ay tinumotul. ");
INSERT INTO due_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nano ay te isin pan a lalaki a linumane de Hisus a nagtanto a magioyo, “Piyon a Magtutodu, ano man i depat ko a yeyedi tangani magkaduman ok ni edup a an te kalog?” ");
INSERT INTO due_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tinumubeg i Hisus, “Ano man i dehilan ta inolangan ok mo a piyon ta am pan te piyon ti an i Makedepat la? Misan be buot mo a gekaduman ni edup a an te kalog ay tumalinga ka a matud de pagdodul ide.” ");
INSERT INTO due_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tinanto ni lalaki, “Uluano non?” Sinabi ni Hisus a, “‘Wet ka nomuno, wet ka nekialam de bebi ni kakmukan, wet ka nannanakow, wet ka gebutil de pagpamatud mo, ");
INSERT INTO due_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gelangin mo i kamoddenan mo ide pati buotin mo i kapadepade mo a agta a magi pagbuot mo de sadile mo.’” ");
INSERT INTO due_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Misan ay tinubeg nun lalaki, “Tinumalinga ok di de pesan a inon. Ano pa i depat ko a yeyedi nano?” ");
INSERT INTO due_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sinabi diya ni Hisus, “Be buot mo a talage a gekitong pa i pag-abut mo de Makedepat ay tumotul ka a panggetangin mo i pesan mo a adi, a boyin mo de mahedepin i kapanggetangan na ta dingan gekaduman ka ni kayamanan de langot. Pagkatapos ninon ay umabut ka deko.” ");
INSERT INTO due_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nano ay pagkaikna na ninon ay tinumotul di a nalungkut un lalaki ta eya ay mayaman a masakut. ");
INSERT INTO due_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ta sinabi ni Hisus de mag-aadel na ide a, “Talage ngani a mahedep a te kapangyedihan i Makedepat de innawa ni agta a geasa la de yaman na. ");
INSERT INTO due_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ta pesabi ko pala dikamo a be an nappatud a nesilong i hayup a kamelyo de bulsut ni kadeyum ay namas pa a an nappatud a te kapangyedihan i Makedepat de innawa ni agta a geasa la de yaman na.” ");
INSERT INTO due_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nano ay namas di a nagtaka i mag-aadel na ide nun inikna de yo a sinabi ni Hisus kanya tinanto de, “Be maginon ay ino pan i nalligtas?” ");
INSERT INTO due_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dingan pinagelawag ide ni Hisus ta sinabi na dide, “Talage a an nappatud a leligtas ni agta i sadile de misan ay te kaya i Makedepat a nanyeyedi ni misan ano a buot na.” ");
INSERT INTO due_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dingan sinabi ni Pedro, “Pagelawagin yu ta winalat mi i pesan a inumabut kami la dikamo. Ano pan nano i nappa ni bilos mi?” ");
INSERT INTO due_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kanya ide ay tinubeg ni Hisus, “Talage a ako a Pineta nun Makedepat a napa ni agta ay gesabi dikamo ni kamatoden a de inapóan a adow ay gelipa ok de piglipaan ko a te gepakaingap. Ta ikamo pala a gepinag-abut deko ay nelipa pala de sangpuwu pati aduwa a piglipaan a gehuwis de sangpuwu pati aduwa a angkan ni Israel. ");
INSERT INTO due_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ta i misan ino a getiis a walatin na i beloy na, mangának, manga kabinsa, kamoddenan, pati kaengin dehil deko ay tatanggep na ngani de nano a panahon i makmuk pa a masakut a kapiyonan. Ta de nádetong pan a panahon ay te duman eya ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ta te duman a naona a nagkáinapóan ta te nàinapóan pan a nagkapaona. ");
INSERT INTO due_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Be te kapangyedihan i Makedepat de innawa ni agta, inon ay magi halimbewa a oyo. Te binumulwag a maderam de abiabi a te adi ni pigtanoman ni lanut a obes tangani nanlalawag ni magtatarabeho na. ");
INSERT INTO due_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nun ide ay nagkasungdu di de suwildu de a sukul de maghapun ay pinakang na ide de pigtanoman na. ");
INSERT INTO due_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nano ay binumulwag a liwet un te adi ni pigtanoman nun abiabi a kadepit ta kinta na de palingki i kauluuddi la a an te manga peyedi. ");
INSERT INTO due_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sinabi na dide, ‘Dumuman kamo pala de pigtanoman ko a magtarabeho ta bebiyen ko ikamo ni sukul a suwildu.’ Dingan dinumuman ngani ide. ");
INSERT INTO due_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Misan ay binumulwag pan di eya nun udto di pati nun apun di a kadepit ta maginon pala i yinadi na. ");
INSERT INTO due_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ta nun i odes ay mandeli di a natapos i tarabeho ay binumulwag eya a liwet ta kinta na pan di i kakmukan pa a an te manga peyedi ta sinabi na dide, ‘Bekot ta kauluuddi kamo dena maghapun?’ ");
INSERT INTO due_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tinumubeg un kauluuddi ide a magioyo, ‘Ay an te geboy dikami ni tarabeho.’ Misan ay sinabi nun te pigtanoman, ‘Be maginon ay dumuman kamo pala de pigtanoman ta magtarabeho kamo.’ ");
INSERT INTO due_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nano ay nun nodumos di ay sinabi nun te adi nun pigtanoman de katabeng na, ‘Olangan mo un magtatarabeho ide ta boboy mo i suwildu de gepo nunde inapóan hanggen nunde tagibu a tinumarabeho.’ ");
INSERT INTO due_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ta un te gepo ide nun mandeli di a natapos i tarabeho ay biniyen ide ni sukul a suwildu de maghapun. ");
INSERT INTO due_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kanya nun linumane un tagibu ide a nagtarabeho ay geasa ide a nátanggep ide ni mehanga pa de inapóan ide a nagtarabeho misan ay i binoy pala dide ay i sukul a suwildu de maghapun. ");
INSERT INTO due_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ta nun ide ay tinumanggep di ni suwildu de ay minalot de i te adi ni pigtanoman. ");
INSERT INTO due_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ta sinabi de nunde te adi, ‘Isin pan la a odes a nagtarabeho i inapóan a dinumatong misan ay ikami pan ay maghapun a nagpagel a nagtiis ni init ni adow. Bekot ta pulupadepade i suwildu mi?’ ");
INSERT INTO due_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sinabi na de isin dide, ‘Ayun, ang ko ikamo pedeya. Aman la nagkasungdu kitam di de sukul a suwildu de maghapun? ");
INSERT INTO due_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kanya amitin yu i suwildu yu a sukul ta tumotul kamo di ta buot ko pala a bebiyen ni magi binoy ko dikamo i nàinapóan ide a nagtarabeho. ");
INSERT INTO due_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ta te kapangyedihan ok a yediin i misan ano a buot ko de pesan ko a adi. Kati pan ikamo ay nagkesinna la de piyon a pagyedi ko de nàinapóan ide?’” Inon i halimbewa ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ta sinabi na a tuloy, “Kanya te duman a naona a nagkáinapóan ta te nàinapóan pan a nagkapaona.” ");
INSERT INTO due_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nano ay nun ide Hisus ay getotul pa a paagow de Herusalem ay binukud na un sangpuwu pati aduwa ta sinabi na dide, ");
INSERT INTO due_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Patalikngan yu ta násakat kitam di de Herusalem ta ako a Pineta nun Makedepat a napa ni agta ay padekop de manga ponu ni maghahandug ide pati de magtutodu ide ni Hudyo ta ako ay hahatolan de ni kalebunan. ");
INSERT INTO due_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ako ay boboy de de an Hudyo ide a lelibek a paapdisan a papaku de padipa. Misan ay de katiluwon a adow ay pakeedup ok a liwet.” ");
INSERT INTO due_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nano ay linumane diya i bebi ni Sebedeo pati mangának na ta te duman ide a buot a aaged diya kanya linumuhud ide a gegelang de kasagkaden ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Ano i buot yu?” Tinumubeg un mahuna, “Tumalinga kamo deko a i aduwa ko a mangának a lalaki ay makalipa ide de awenan pati awile yu pagdetong ni panahon a ikamo ay te kapangyedihan di de pesan.” ");
INSERT INTO due_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Misan ay tinubeg ide ni Hisus, “An yu ngani katinggesan i peaged yu na. Nakapetiis kamo man de kahedepan a tetiis ko?” “Ay-o, nakapetiis kami ngani.” ");
INSERT INTO due_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Misan ay sinabi dide ni Hisus, “I tetiis ko a mahedep ay tetiis yu ngani misan ay an ako i nakapesabi ni ti ino i nelipa de awenan pati de awile ko ta i piglipaan ide a inon ay para de pinaghandean ide ni Ama ko a Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nun iknain yo nun sangpuwu a mag-aadel ay nagengsa ide de magwele. ");
INSERT INTO due_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanya pinalane ide ni Hisus ta sinabi na dide, “Katinggesan yu di a i an Hudyo ide a hari ay gesákup ide a mahigpit de nasasakopan de ta i te manga kapangyedihan ide ay petalingaan ngani ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Misan ay wet tebe maginon i nappa ni ugeli yu ta depat a i misan ino dikamo a te buot a nappa ni maditas dikamo ay nappa ni katabeng yu nano. ");
INSERT INTO due_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ta i misan ino a te buot a nappa ni te kapangyedihan pa dikamo a pesan ay depat pan a nappa ni alepin yu. ");
INSERT INTO due_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Piyon pa a tumolad kamo deko a Pineta nun Makedepat a napa ni agta ta anok dinumio tangani tabengan ta dinumio ok a getabeng de pesan, a boboy ko a tuloy i edup ko a pantobus de kamakmokan.” ");
INSERT INTO due_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nano ay pagkatotul de de benwaan a Heriko ay inabut i Hisus ni makmuk a kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta te gelipa pan a aduwa a bulag de kaginglan nun bektas. Nun inikna de a gesila i Hisus ay inumolang ide a magioyo, “Panginoon a apo ni Debid, makalbi kamo dikami.” ");
INSERT INTO due_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Misan ay sinablow ide ni kaagtaan ta sinabi de, “Wet kamo mag-olang.” Misan ay namas pa a pinalagdu de i pag-olang de, “Panginoon a apo ni Debid, makalbi kamo dikami.” ");
INSERT INTO due_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nano ay tinumimok i Hisus de pagtotul na ta dingan tinawal na ide, “Ano man i buot yu a yeyedi ko dikamo?” ");
INSERT INTO due_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Panginoon, papiyonin yu tebe ikami tangani ikami ay nakakkita di.” ");
INSERT INTO due_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nakalbi pan i Hisus dide dingan tinapá na i mata de ta tambing dila ide a nakakita dingan inumabut ide de Hisus. ");
INSERT INTO due_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nano ay palane ide Hisus de Herusalem ay dinumatong ide de karipakip ni Kalasan a Olibo a alane ni benwaan a Betpag. Dingan pinapaona ni Hisus i aduwa a mag-aadel na ");
INSERT INTO due_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ta sinabi na dide, “Kumang kamo de nosunud a beriyu ta duman kekita yu a naggipot i asno pati anak na ta ukasan yu a uweyin dio. ");
INSERT INTO due_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ta be te nagtanto dikamo ni misan ano ay sabiin yu a ‘Kaelangan yo ni Panginoon misan ay paampulang na pan la a tambing.’” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ta nangyedi yo tangani i oyo a sinabi ni magsasabi ay mamatud, ");
INSERT INTO due_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sabiin yu de tage Herusalem ide, ‘Pagelawagin yu ta gedetong i hari yu a migpakasidong a innawa a nappasakoy de asno a am pa matande.’” ");
INSERT INTO due_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dingan tinumotul un mag-aadel na ide ta yinadi de ngani i magi tinutugun dide ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ta inuwey de un maginak a asno ta dinasaan de i idog nun asno ide un kulapyaw de ide dingan sinumakoy i Hisus. ");
INSERT INTO due_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ta makmuk ngani i nagdesá ni kulapyaw de de bektas a sesilan na ta i kakmukan pan ay nangamit ide ni sanga ni kew a makiagid ta dinasá de de bektas a paggelang de diya. ");
INSERT INTO due_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Dingan nagiinolang i kaagtaan a naona diya pati nàinapóan ta sinabi de, “Salamat de Pinakamaditas a Apo ni Debid. Podiin eya a gedetong a te kapangyedihan ni Panginoon a Makedepat. Salamat de Pinakamaditas.” ");
INSERT INTO due_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nano ay pagdetong ni Hisus de Herusalem ay nagulo un pesan duman ta tinulutanto ni kakmukan, “Ino man nay?” ");
INSERT INTO due_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tinumubeg i kamakmokan, “Eya ay i Hisus a magsasabi a tage Nasarit de sákup ni Galilea.” ");
INSERT INTO due_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Dingan sinumilong i Hisus de beloy a pighandogen de Makedepat ta pinangalow na duman i pesan a magpapanggetang pati manggegetang de beloy a inon. Ta pinulupaobbob na i manga lamesa ni maglelewes ide ni kuwarta pati piglipaan ni magpapanggetang ide ni kalapati. ");
INSERT INTO due_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta sinabi dide ni Hisus, “Pesabi ni kasulatan a ‘I beloy ko ay talage a pigpanalanginan la misan ay peyedi yu pan a pigtaanan ni tulisan ide.’” ");
INSERT INTO due_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nano ay te linumane de Hisus a bulag pati pilay duman de beloy a pighandogen de Makedepat dingan pinapiyon na ide. ");
INSERT INTO due_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nun kitain yo ni ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo ay nagbulas ide de pesan a yinadi na a gepakataka pati de pag-olang pan ni mangának ide de disalad nun beloy a pighandogen a, “Salamat de Pinakamaditas a Apo ni Debid.” ");
INSERT INTO due_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kanya sinabi de diya, “Peikna mo man i pesabi de?” “Ay-o, peikna ko ngani,” tubeg ni Hisus, “An yu pa man nagkabesa i pesabi ni kasulatan a magioyo, ‘Gepo de mangának ide pati pepasusu pa ide ay náapo i pagpodi a matud diya.’” ");
INSERT INTO due_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ta tinumotul i Hisus duman dide a paagow de Betania ta duman eya pinumilong. ");
INSERT INTO due_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nano ay nun kinábiabian ay inumampulang ide Hisus de Herusalem ta nun ide ay dio pa nunde bektas ay natigeng eya. ");
INSERT INTO due_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nasayed na i isin a gemut a igos de kaginglan ni bektas ta linanean na misan ay angani kinumita ni anak na ta agid na la. Ta sinabi na nunde igos, “Gepo nano ay ang ka di gekaanak magpakapide man.” Ay tambing di a narango un igos. ");
INSERT INTO due_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nano ay nun kinta yo nun mag-aadel na ide ay nagtaka ide ta sinabi de, “Ano i sinumapit ta narango dila a tambing i igos?” ");
INSERT INTO due_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta tinumubeg i Hisus, “Talage ay pesabi ko dikamo a be ikamo ay gepanulusun de Makedepat a an te aduwa a esip ay nayeyedi yu pala i yinadi ko de igos a oyo ta an la iwina ta be sabiin yu de kalasan a oyo a, ‘Umalis ka de atab to i,’ ay talage a nangyeyedi ngani i sinabi yu. ");
INSERT INTO due_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta misan ano i agedin yu de pagpanalangin yu a te pagpanulusun ay talage ngani a tatanggep yu.” ");
INSERT INTO due_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nano ay nun sinumilong a liwet i Hisus de beloy a pighandogen a nagtodu eya ay linumane diya i ponu ide ni maghahandug ide pati pinakamatande ide a nagtanto diya, “Ano man i kapangyedihan mo a nagyedi ni maginon pati ino i nagboy dikaw ni kapangyedihan a inon.” ");
INSERT INTO due_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Misan ay tinumubeg dide i Hisus, “Tatanto ko pala ikamo ni pakosa ta be notubeg yu i tanto ko ay dingan sasabi ko pala dikamo ti ano i kapangyedihan ko a geyedi ni pesan a inon. ");
INSERT INTO due_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dino pala inumapo i kapangyedihan ni Huwen a Maglilenod a gelinod ni agta? De Makedepat man o de agta la?” Dingan ide ay nasurutsurotan, “Be sasabi tam a, ‘De Makedepat,’ ay sasabi na pan a, ‘Bekot ta an yu tinalingaan?’ ");
INSERT INTO due_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Misan ay be sasabi tam a, ‘De agta la,’ ay makati ti ano i yediin dikitam ni manga agta ta peabuyenan de a i Huwen ay magsasabi ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kanya tinumubeg ide de Hisus, “Am mi katinggesan.” Sinabi pala dide ni Hisus, “Be maginon ay ang ko pala sasabi dikamo ti ino i nagboy deko ni kapangyedihan a geyedi ni pesan a inon.” ");
INSERT INTO due_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Dingan sinabi ni Hisus a tuloy a magioyo, “Ano i peesip yu tungkul de oyo a halimbewa ta te duman a lalaki a te anak ni aduwa a lalaki. Nano ay linumane eya de panganay a anak ta sinabi na, ‘Anak ko, kumang ka de pigtanoman ta magtarabeho ka.’ ");
INSERT INTO due_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Anok yo,’ inon i tubeg na misan ay nun an náloy ay binumowon i esip na ta eya ay kinumang de pigtanoman. ");
INSERT INTO due_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pati linumane i ama de káduwa ta maginon pala i sinabi na diya. Ay tinumubeg un káduwa, ‘Hale di Ama,’ misan ay am pan kinumang nunde pigtanoman.” ");
INSERT INTO due_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nano ay tinanto ide ni Hisus, “Ino de aduwa i tinumalinga de ama de?” Tinumubeg ide, “I panganay.” Ta sinabi dide ni Hisus, “Pesabi ko ngani dikamo a i makikkakasalanan ide pati mammalotin a mahunain ay naona pa dikamo a te kapangeydihan ni Makedepat de innawa de. ");
INSERT INTO due_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ta i Huwen a Maglilenod ay nakadio di dikamo, a nagtodu eya ni kamatoden pati eya ay naedup ni malenis misan an yu pinanulusonan. Ay i makikkakasalanan pan ide pati mammalotin a mahunain ay nagpanulusun diya. Talage ay kinta yu ngani inon misan ay ang kamo nagsosol a nagpanulusun diya. ");
INSERT INTO due_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Patalikngan yu pan di i oyo a isin pa a halimbewa. Te duman a isin a agta a nagpatanom ni lanut a obes de pigtanoman na ta dingan pinabekoden na ta pati nagpayedi eya duman ni pigpisaan nun obes ta nagpauddi ni maditas a pigbentayen. Pagkatapos ninon ay winalat na nunde taohan na ide ta eya ay kinumang de kakmukan a bensa. ");
INSERT INTO due_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ta nun dinumatong di i panahon a pagpisa nun obes ay pinakang nun te adi nun pigtanoman un katabeng na ide tangani amitin de i kabinsa na. ");
INSERT INTO due_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Misan ay binolan nun taohan ide un dinodul ide dingan binalbel de un isin ta un isin pan ay binuno de ta binonglag de pan un katiluwon. ");
INSERT INTO due_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nano ay pinakang a liwet nun te adi i kakmukan pa a katabeng a makmuk pa nunde tagibu misan ay maginon pala i yinadi nun taohan ide. ");
INSERT INTO due_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nunde inapóan ay pinakang na di un anak na a lalaki ta sinabi na de sadile na, ‘Gegelang de di i anak ko.’ ");
INSERT INTO due_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Misan ay nun kinta nun taohan ide un anak nun te adi ay nasurutsurotan ide a magioyo, ‘Iwina i gemana ni pigtanoman i. Hale di, bunoin tam tangani mapadikitam di i mamana na.’ ");
INSERT INTO due_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dingan eya ay binolan de a binulwag de pigtanoman a binuno a tuloy. ");
INSERT INTO due_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kanya pan pag-ampulang nun te adi ni pigtanoman ay ano man i yeyedi na de taohan na ide?” ");
INSERT INTO due_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tinumubeg i kasurut ide ni Hisus, “Popuksa na inon ide a mammalot dingan pataanan na de kakmukan un pigtanoman a inon tangani eya ay bebiyen de ni kabinsa na be panahon di a aamit i anak nun tanom ide.” ");
INSERT INTO due_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nano ay tinanto ide ni Hisus, “An yu pa man nagkabesa i pesabi ni Makedepat de kasulatan? ‘I beto a kinapoyin ngona ni magyeyedi ide ni beloy ay eya pan i namas pa a pinakamahalage a beto de iwina a yinadi a beloy. Inon i yinadi ni Panginoon a Makedepat kanya de pekita tam ay masampat a masakut.’” ");
INSERT INTO due_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kanya ngani pesabi ko dikamo a Hudyo a an getalinga de Makedepat ay ang kamo gekaduman ni kapangyedihan ni Makedepat de innawa yu ta i gekaduman la ay i mangának na a getalinga diya a matud. ");
INSERT INTO due_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nano ay i misan ino a nadegdeg de beto a inon ay nebigedbigedin ta i madegdeg pan ni beto a inon ay noropus ngani a magi delpong.” ");
INSERT INTO due_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nun inikna pan ni ponu ide ni maghahandug ide pati Pariseo ide i halimbewa ide a sinabi ni Hisus ay kinatinggesan de a ide i pesabian ni Hisus de halimbewa a inon. ");
INSERT INTO due_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kanya dedekop de tebe eya misan ay nagkatakut pan ide de manga agta ta inabuyenan ni manga agta a i Hisus ay Magsasabi nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nano ay liwet a nagsurut i Hisus ni halimbewa dide ta sinabi na, ");
INSERT INTO due_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“I kapangyedihan ni Makedepat de innawa ni agta ay inon ay magi isin a hari a naghande ni pápangan ta kákasal i anak na a lalaki. ");
INSERT INTO due_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ta dinodul na un katabeng na ide de inakit na ide misan ay an de buot a noduman. ");
INSERT INTO due_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dingan liwet eya a nagdodul ni kakmukan a katabeng ta sinabi na dide, ‘Sabiin yu de manga inakit ide a hinande ko di i pápangan ta binuno ko di i beka pati anak ni beka a pinatabe. Ay nahhande di i pesan kanya dumio kamo di de kásalan i.’ ");
INSERT INTO due_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Misan ay an yo sinapot ni inakit ide ta tinumotul ide de belang buot de a paagowen. I isin ay kinumang de kaengin na. I isin pa ay de pagtinde na. ");
INSERT INTO due_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ta binolan pan nun kakmukan un katabeng ide ta linebek de dingan binuno a tuloy. ");
INSERT INTO due_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kanya nagbulas a masakut un hari ta pinakang na un sundelo na ide ta pinabuno na i migbuno ide a pinasunug na un benwaan de. ");
INSERT INTO due_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Dingan sinabi na de manga katabeng na ide, ‘I pápangan ay nahhande di misan ay an di nagkaddepat a nákang i inakit ko ide de kásalan. ");
INSERT INTO due_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kanya kumang kamo de kulukarsade a makiaagta ta aketin yu i belang kitain yu tangani dumio de kásalan i.’ ");
INSERT INTO due_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ta binumulwag ngani un manga katabeng de kulukarsade ta inikag de i pesan a kinta de, te piyon a ugeli man o malot, ta napino ni agta un beloy a kásalan. ");
INSERT INTO due_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nano ay sinumilong un hari tangani bisetain na i inakit ide ta kinta na duman i isin a agta a an nappabedu ni nappaayun de kásalan. ");
INSERT INTO due_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Sinabi na diya, ‘Ayun, bekot ta sinumilong kamo dio a an te bedu ni nappaayun de kásalan?’ Nano ay an nakayamyam un agta. ");
INSERT INTO due_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kanya sinabi nun hari nunde katabeng na ide, ‘Gepusin yu i kumot pati singit na dingan butin yu de madumos de ditow ta eya ay nátangos a náaratengot i ngipon na dehil de pagtiis na.’ ");
INSERT INTO due_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ta makmuk i inakit misan ay an makmuk i pineta.” Inon i pagtodu ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nano ay tinumotul un Pariseo ide ta pinasurutsurotan de a ti papalano a maamit de i mali de surut na tangani hahabla de eya. ");
INSERT INTO due_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kanya pan pinakang de i tipide dide de Hisus ta kakoloy pala i tipide a mangáyun ni Herod ta sinabi de, “Magtutodu, katinggesan mi a ikamo ay gesurut la ni kamatoden ta getodu kamo a nappaayun de kabuotan ni Makedepat. Pati ang kamo te pepeta a agta ta padepade i pesan a agta de pekita yu. ");
INSERT INTO due_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ano i peesip yu? Nagkaddepat man de pagdodul ide a gebeyed ni buwis o eyen de Hari a Kaditasan de Roma?” ");
INSERT INTO due_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Misan ay katinggesan ni Hisus ide ay gedeya la a te belak a malot kanya sinabi na dide, “Bekot ta pedeya ok yu? Ikamo ngani i pesabi a an yud peyedi i malot misan ay peyedi yu mangan la. ");
INSERT INTO due_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dio yu i kuwarta a pelak a pambuwis.” Ta biniyen eya ni isin a pelak. ");
INSERT INTO due_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Dingan tinanto na ide, “Dino man a leterato pati ngalan a nappadio de pelak i?” ");
INSERT INTO due_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tinumubeg ide, “De Hari a Kaditasan de Roma.” Kanya sinabi na dide, “Be maginon ay boyin yu de Hari a Kaditasan i para diya ta boyin yu pala de Makedepat i para diya.” ");
INSERT INTO due_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nano ay nagtaka ide nun iknain de inon dingan tinumotul ide. ");
INSERT INTO due_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ta nun adow pala a inon ay linumane de Hisus i tipide a Saduseo, a an gepanulusun a pakeedup a liwet i nalibunin. Ta sinabi de de Hisus, ");
INSERT INTO due_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Magtutodu, nagsolat i Moises ni pagdodul a para dikitam ‘Be nalibun i isin a lalaki a an te anak ay depat a gepakasal i wele na a lalaki de belo a mahuna tangani magkaanak ide para de nalibun.’ ");
INSERT INTO due_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ta nano ay te pito a magiwinale a manga lalaki dio dikami. Ay nagbebi un kaka de misan ay nalibun eya a an nagkaanak kanya nabebi nun belo un wele na. ");
INSERT INTO due_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Misan ay maginon pala i nangyedi nunde káduwa pati de katiluwon hanggen nunde kapito di ay nalibun pala. ");
INSERT INTO due_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ay de inapóan ay nalibun pala un mahuna. ");
INSERT INTO due_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nano ay ino dide i nappa ni bebi nun mahuna be te pagkaedup a liwet ta i pito pan ay napa ni bebi na dio?” ");
INSERT INTO due_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tinubeg dide ni Hisus, “Mali kamo a masakut ta an yu ngan katinggesan i kasulatan nun Makedepat pati kapangyedihan na. ");
INSERT INTO due_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ta de pagkaedup a liwet ay i manga agta ay an di gebebi o gepabebi ta ide ay nappa ni magi manga anghel di de langot. ");
INSERT INTO due_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tungkul pan de liwet a pagkaedup ni nalibunin ay an yu paman nagkabbesa de kasulatan ni Moises i sinabi ni Makedepat para dikamo. ");
INSERT INTO due_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ta sinabi na a, ‘Ako i Makedepat a pepodian pa ni Abraham, Isak pati Hakob.’ Pati katinggesan tam ngani a i Makedepat ay an Makedepat ni nalibunin ta ni naedupin la.” ");
INSERT INTO due_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nano ay nun iknain non nun kaagtaan ay nagtaka ide de pagtodu na. ");
INSERT INTO due_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nano ay tinumipun i Pariseo ide nun mabereta de a napatimok ni Hisus i Saduseo ide de pakipagdibete de diya. ");
INSERT INTO due_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kanya un isin dide a naketingges de pagdodul i nagtanto de Hisus misan ay pedeya na la tangani hahabla na. ");
INSERT INTO due_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Magioyo i tinanto na, “Magtutodu, i deno man i talage a pinakamahalage a pagdodul?” ");
INSERT INTO due_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tinumubeg i Hisus, “‘Ay depat a buotin yu i Panginoon a Makedepat a pepodian yu ni pesan a innawa, edup pati esip yu.’ ");
INSERT INTO due_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inon i tagibu a pinakamahalage a dodul. ");
INSERT INTO due_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ta i káduwa pan a mahalage ay i oyo, ‘Ay depat a buotin yu i kapadepade yu a agta ni magi pagbuot yu de sadile yu.’ ");
INSERT INTO due_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Talage a be getalinga i misan ino de aduwa a oyo a pagdodul ay getalinga eya de pesan a pagdodul ni Moises pati ni magsasabi ide nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nano ay nun nattipun pa i Pariseo ide ay tinanto ide ni Hisus a magioyo, ");
INSERT INTO due_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ano i peesip yu a tungkul de Kristo a Pinangako nun Makedepat? Ino i kaapoapohan na?” Tinumubeg ide, “I Debid a Hari tam a den.” ");
INSERT INTO due_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Dingan sinabi ni Hisus dide, “Be maginon ay ano ta nginalanan ni Debid i Kristo a, ‘Panginoon ko’ nun naghola eya nun te kapangyedihan diya i Ispiritu nun Makedepat? Ta sinabi na a, ");
INSERT INTO due_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Sinabi ni Panginoon a Makedepat de Panginoon ko a lumipa ka de awenan ko a te kapangyedihan ta padeog ko dikaw i kapagebuk mo ide.’ Inon i sinabi ni Debid ");
INSERT INTO due_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","kanya be pengalanan ni Debid i Kristo a, ‘Panginoon ko’ ay papalano man a napa ni apo ni Debid i Kristo?” ");
INSERT INTO due_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nano ay an te misan isin dide a te kaya a getubeg diya ta am pala te misan ino a nagtanto diya a liwet gepo nun nanon. ");
INSERT INTO due_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nano ay sinabi ni Hisus nunde agta ide pati de mag-aadel na ide a magioyo, ");
INSERT INTO due_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“I manga magtutodu ni Hudyo pati Pariseo ide ay getodu ide ni pagdodul ide ni Moises ");
INSERT INTO due_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","kanya tumalinga kamo a tuloy de pagdodul de a petodu de misan ay wet kamo tumolad de pagyedi de ta an de ngani peyedi i pesabi de. ");
INSERT INTO due_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ta getodu ide a mahigpit ta nagkapatalinga de i kaagtaan misan ay am pan ide getalinga de pagdodul a petodu de. ");
INSERT INTO due_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ta buot de la a podiin ide ni kaagtaan kanya paanduwon de i rimong ni bedu de pati pesurob de de lawes de i sinolat a surut nun Makedepat de papel. ");
INSERT INTO due_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ta i buot de pala ay i manga hinande a piglipaan de pigmitengan ide pati de hinande ide a pigpanganan. ");
INSERT INTO due_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Talage a buot de a betiin ide ni gekita dide de kulukarade pati buot de ay ngangalanan ide a ‘magtutodu’. ");
INSERT INTO due_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Misan ay para dikamo ay wet kamo magpangalan de agta ide a ‘magtutodu’ ta katinggesan yu pan a i Magtutodu yu ay isin la ta ikamo a pesan ay magiwinale. ");
INSERT INTO due_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pati wet yu ngangalanan a ‘Ama’ i misan ino a agta dio de putok i ta isin la i Ama yu a i Makedepat de langot. ");
INSERT INTO due_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Wet kamo pala magpangalan de agta ide ni ‘ponu’ ta isin la i Ponu yu a i Kristo la. ");
INSERT INTO due_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ta i pinakamaditas dikamo ay depat a nappa ni katabeng yu. ");
INSERT INTO due_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ta i gepodi de sadile na ay pepakasidong eya de pesan ta i gepakasidong pan de sadile na ay nappa ni maditas pa. ");
INSERT INTO due_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Kanya gepakatakut i násapit dikamo a manga magtutodu ni Hudyo pati Pariseo ide ta pesabi yu a an yud peyedi i malot misan ay peyedi yu mangan la. Ta nagkaabetan yu i manga agta tangani wet ide gekaduman ni kapangyedihan ni Makedepat de innawa de. Ta an yu buot a gekaduman kamo ni kapangyedihan na pati nagkaabetan yu pala i kakmukan a te buot. ");
INSERT INTO due_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Gepakatakut i násapit dikamo a manga magtutodu ni Hudyo pati Pariseo ide ta pesabi yu a an yud peyedi i malot misan ay peyedi yu mangan la. Ta peubus yu i keedup ni mahunain a belo misan ay petaklopan yu i malot a pagyedi yu ni anduwon a pagpanalangin yu. Talage a dehil de oyo ay namas pa a mabiyet i padusa a nádetong dikamo. ");
INSERT INTO due_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Gepakatakut i násapit dikamo a manga magtutodu ni Hudyo pati Pariseo ide ta pesabi yu a an yud peyedi i malot misan ay peyedi yu mangan la. Ta nagkadetong yu i pesan a lugel tangani makaikag kamo ni misan isin a an Hudyo de pagpanulusun a Hudyo ta dingan be eya ay kakoloy yu di de pagpanulusun yu ay yeyedi yu eya a namas pa dikamo a depat a podusahan de impiyerno. ");
INSERT INTO due_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Gepakatakut i násapit dikamo a mag-aagkay a bulag de pagtodu yu. Ta pesabi yu a depat a matudin ni misan ino i pangako na be i pagpamatud na ay i ginto de beloy a pighandogen de Makedepat misan ay pesabi yu pan a an te ano man i pangako na be i pagpamatud na ay i beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ikamo ay magi bulag a an te katinggesan. Ti deno man i namas pa a halage, i ginto man o i beloy a pighandogen de Makedepat a gepahalage de ginto? ");
INSERT INTO due_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ta pesabi yu pala a depat a matudin ni misan ino i pangako na be i pagpamatud na ay i hinandug misan ay pesabi yu pan a an te ano man i pangako na be i pagpamatud na ay i pighandogen. ");
INSERT INTO due_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ikamo ngani ay bulagin ta ti deno man i namas pa a mahalage, i handug man o i pighandogen a gepahalage de handug? ");
INSERT INTO due_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kanya be i pagpamatud ni pangako ni agta ay i pighandogen ay kakoloy pala ay i handug. ");
INSERT INTO due_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pati be i pagpamatud ni pangako ni agta ay i beloy a pighandogen de Makedepat ay kakoloy pala ay i Makedepat a nappataan duman. ");
INSERT INTO due_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Pati pan be i pagpamatud ni pangako ni agta ay i langot ay kakoloy pala ay i piglipaan ni Makedepat pati eya a gelipa duman. ");
INSERT INTO due_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Gepakatakut i násapit dikamo a manga magtutodu ni Hudyo pati Pariseo ide ta pesabi yu a an yud peyedi i malot misan ay peyedi yu mangan la. Ta pehandug yu de Makedepat i kasangpuwu a rikadu la misan ay pagkelipatan yu a peyedi i namas pa a mahalage a pagdodul a magi katinggesan, pagkalbi pati ugeli a depat a naponulusonan. Nappatud a yediin yu i tagibu misan ay an depat a pagkelipatan yu i pinakamahalage. ");
INSERT INTO due_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ikamo ay magi mag-aagkay a bulag de pagtodu yu. Ta an yu buot a geyedi ni mammalotin a untik a magi gemogemo misan ay geyedi kamo pan ni mammalotin a hanga a masakut a magi kamelyo. ");
INSERT INTO due_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Gepakatakut i násapit dikamo a manga magtutodu ni Hudyo pati Pariseo ide ta pesabi yu a an yud peyedi i malot misan ay peyedi yu mangan la. Ta pelenis yu i disapow ni mangkok pati pinggen a i ugeli yu de pekita ni manga agta misan ay de disalad ni innawa yu ay pino ni pagkasinna pati mammalotin. ");
INSERT INTO due_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ikamo a Pariseo a bulagin, lenisin yu ngona i disalad ni mangkok pati pinggen ta dingan nappa ni malenis pala i disapow. ");
INSERT INTO due_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Gepakatakut i násapit dikamo a manga magtutodu ni Hudyo pati Pariseo ide ta pesabi yu a an yud peyedi i malot misan ay peyedi yu mangan la. Ikamo ay magi pigtaporan a pinalapsay a masampat de disapow misan ay de disalad ay mabungtut pati te duman a kaksan ni nalibunin. ");
INSERT INTO due_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Talage a maginon kamo ngani ta de pekita ni agta ay pippiyonin kamo misan ay de innawa yu ay te pagbutil pati pino ni mammalotin. ");
INSERT INTO due_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Gepakatakut i násapit dikamo a manga magtutodu ni Hudyo pati Pariseo ide ta pesabi yu a an yud peyedi i malot misan ay peyedi yu mangan la. Ta pepayedi yu i pigtaporan ni manga magsasabi ide a den pati pepasampat yu i pigtaporan ni agta a te piyon a pagyedi. ");
INSERT INTO due_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Dingan pesabi yu, ‘Be ikami tebe ay te edup di nun te edup pa un kaapoapohan mi ide ay an de ikami ayun a namuno de magsasabi ide a den.’ ");
INSERT INTO due_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ay dehil de sinabi yu a inon ay ikamo di pala i gepamatud a ikamo ay i manga apo ni migbuno ide de magsasabi ide a den. ");
INSERT INTO due_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kanya hale di, taposin yu i ginapoan ni kaapoapohan yu ide. ");
INSERT INTO due_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Talage ikamo ay magi malot a bebek a matapangin kanya wet yu peesipa a ikamo ay nakeelag de podusahan dikamo ni Makedepat de impiyerno. ");
INSERT INTO due_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ta pakang ko dikamo i magsasabi ide, agta a naketinggesin pati magtutodu ide misan ay bobuno yu i tipide dide, i kakmukan pan ay papaku yu de padipa ta i kakmukan pala ay pepahedepan yu de pigmitengan yu a pangalow yu de bulubenwaan. ");
INSERT INTO due_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kanya podusahan kamo nano dehil de pagbuno ni kaapoapohan yu ide de manga agta a te piyon a ugeli hanggen nunde gepo nun binuno i Abel a piyon a agta hanggen de Sakarias a anak ni Barakias a binuno de alane ni pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Talage ay pesabi ko dikamo a i padusa dehil de pesan a pagbuno a inon ay nádetong de agta ide de nano a panahon. ");
INSERT INTO due_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ikamo a tage Herusalem ay pebuno yu i magsasabi ide ta pebonglag yu pan i dinodul na ide dio. An la pakosa a ako ay te belak a ikamo ay alágean ko a magi pag-aláge ni manok de mangának na ide misan ay an yu pan buot. ");
INSERT INTO due_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kanya ikamo a tage Herusalem ay pabiyaan kamo di ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Talage ay pesabi ko dikamo a anok yud kekita a liwet hanggen an gedetong i odes a sabiin yu a magioyo, ‘Magpodi kitam di de gedetong a te kapangyedihan ni Panginoon a Makedepat.’” Inon i sinabi ni Hisus dide. ");
INSERT INTO due_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nano ay nun binumulwag a tinumotul ide Hisus de beloy a pighandogen de Makedepat ay linumane diya i mag-aadel na ide a pinakita de diya i kasampatan ni beloy a inon. ");
INSERT INTO due_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Misan ay tinubeg ide ni Hisus, “Pekita yu nay nano misan pesabi ko dikamo a de nádetong a adow ay an te nattide dena a beto a nappulupatongan ta neregen a pesan.” ");
INSERT INTO due_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nun gelipa i Hisus de Kalasan a Olibo ay linanean eya ni mag-aadel na ide ta tinanto de de an te geikna a kakmukan, “Kapide man nangyeyedi i sinabi yu a inon pati ano i nappa ni tande ni pagdetong yu dio a liwet pati kalog ni panahon?” ");
INSERT INTO due_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ay tinubeg ide ni Hisus, “Mag-engat kamo tangani wet kamo nadedeya ni misan ino a agta. ");
INSERT INTO due_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ta makmuk i nádetong a gesabi a ide i Kristo ta makmuk ngani i nadedeya de. ");
INSERT INTO due_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nakaikna kamo ni gelaben pati bereta tungkul de laben de alayu. Ay wet kamo matakut ta depat ngona a mangyedi i oyo ide a pesan misan ay am pa i kalog ni panahon. ");
INSERT INTO due_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ta i bensa a isin ay nekilaben de isin pala a bensa ta nekilaben pala i hari ide de kakmukan a hari. Te duman pala a nádetong a tigtegeng pati noyogyog de misan deno a lugel. ");
INSERT INTO due_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ta inon ide ay gepo la ni kahedepan a nádetong. ");
INSERT INTO due_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ta de inon a panahon ay kagengsaan kamo ni tage pesan a bensa dehil de pagpanulusun yu deko ta dedekop kamo a pehedepan a bobuno a tuloy. ");
INSERT INTO due_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pati makmuk i nákapoy de pagpanulusun de deko pati naggulugengsaan i belang isin ta padekop ni kakmukan i mangáyun de. ");
INSERT INTO due_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ta dingan nádetong i makmuk a gebutil a ide ay magsasabi ni Makedepat ta nadedeya de i kamakmokan. ");
INSERT INTO due_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nano ay dehil de makmuk a násapit a mammalotin dio de putok i ay i pagbuotan ni makmuk ay nappa ni mahena. ");
INSERT INTO due_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Misan i getiyage de pagpanulusun na de kahedepan hanggen de kalog ay nalligtas ngani. ");
INSERT INTO due_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ta i piyon a bereta a tungkul de te kapangyedihan i Makedepat de innawa ni agta ay sasabi de pesan a agta dio de putok i tangani matinggesan ni pesan de belang bensa dingan ngona nádetong di i kalog. ");
INSERT INTO due_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Nano i oyo a sasabi ko di ay depat a esipin a masakut ni gebesa. Esipin yu ta nappaayun de hinola ni magsasabi a den a Daniel ay be kekita yu a geuddi i gepakatakut a Gekapoy de Makedepat de beloy a pighandogen diya ");
INSERT INTO due_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ay depat a nelimok de kalasan i pesan a nappataan de lugel a Hudia. ");
INSERT INTO due_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ta i naddekatobengan ni beloy na ay wet di nesilong a nángamit ni misan ano de beloy na. ");
INSERT INTO due_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Pati i naddekaengin na ay wet di pala nouli a nángamit ni kulapyaw na de beloy na. ");
INSERT INTO due_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kakulukalbi ngani i mabsuin pati gepinagpasusu de manga adow a inon. ");
INSERT INTO due_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ta magpanalangin kamo a i paglimok yu ay wet tebe de panahon a magidnaw o de adow man ni paimloy. ");
INSERT INTO due_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ta de panahon a inon ay i kaagtaan ay te kahedepan a masakut a am pa tiniis ni misan ino gepo nun yinadi i putok i pati be nakatakig di ay an di neliwet i maginon kapide pa man. ");
INSERT INTO due_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nano ay be an paantisik ni Panginoon a Makedepat i panahon a inon ay an di te nakeligtas misan ay dehil pan de manga pineta na ide ay paantisik na inon a panahon. ");
INSERT INTO due_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kanya ngani be te magsabi dikamo a ‘Wiyo di i Kristo,’ o ‘Duman di,’ ay wet kamo manulusun. ");
INSERT INTO due_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ta talage a te giddinatong a Kristo a an matud pati magsasabi ide a an matud. Ta geyedi ide ni tande pati gepakataka a masakut tangani nálalagelag de tebe i pineta ide ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kanya magipinag-engat kamo ta sinabi ko di dikamo a tagibu i pesan a oyo. ");
INSERT INTO due_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pati be sabiin de dikamo a i Kristo ay duman de ilang ay wet kamo noduman ta be sabiin de pala dikamo a eya ay getagu de disalad ni beloy ay wet kamo manulusun. ");
INSERT INTO due_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ta i pagdetong ko a Pineta nun Makedepat a napa ni agta ay kekita ni pesan ta magi kilat a gepakaingap gepo de petangaan ni adow hanggen de pelinoden na. ");
INSERT INTO due_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ta esipin yu i pigsabiin a oyo. Ti deno getipun i manga tewak ay duman pala i bengkay ni podusahan ide. ");
INSERT INTO due_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nano ay be tinumakig di i kahedepan a inon ay tambing a nodumos di i adow pati pan i bulan ay an di nátallang. Pati nadegdeg di i manga butatala a gepo de langot. Ta i te kapangyedihan ide de longaw na ay neeyenan di ide ni kapangyedihan de. ");
INSERT INTO due_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pagkatapos ninon ay pepakita dikamo de langot i tande a gedetong ok di a Pineta nun Makedepat a napa ni agta ta dingan nátangos i pesan a agta de disapow ni putok i. Ta kekita de pan di i ako a Pineta nun Makedepat a napa ni agta a gedetong a nappa de kunom de longaw na a te kapangyedihan pati gepakaingap a masakut. ");
INSERT INTO due_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta de tinog a malagdu ni paoni ay dododul ko i manga anghel ide tangani tipunin de i manga pineta ko de pesan a kadepit ni putok i pati langot. ");
INSERT INTO due_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ay uluesipin yu de pagtodu gepo de kew a igos ta be geagid i manga sanga na ide ay katinggesan yu ngani a alane di i tig-adlas. ");
INSERT INTO due_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Maginon pala be kekita yu di i pesan a sinabi ko ay katinggesan yu di a alane di i panahon a pagdetong ko ta magi naddepintohan ok di. ");
INSERT INTO due_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Talage a matud ay pesabi ko dikamo a te duman a tipide a agta a gekita de gepo a gepakatakut a nangyeyedi a an nelibun hanggen an de kekita i inapóan a gepakatakut. ");
INSERT INTO due_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Talage a nesede di i putok i pati langot misan ay i surut ko pan ay angani neeyenan ni kabuluhan. ");
INSERT INTO due_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Misan i odes o adow ni pagdetong ko ay an te naketingges a misan ino, misan i anghel ide de langot misan i ako a Anak ta i Ama la a Makedepat. ");
INSERT INTO due_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ta i panahon a inon a pagdetong ko a Pineta nun Makedepat a napa ni agta ay magi pagdetong a loktat nun bulangay nun panahon ni Nowe. ");
INSERT INTO due_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ta nun nanon ay i kaagtaan ay gepinagpangan, gepinag-inom, gebebi pati gepabebi hanggen nun adow a sinumilong ide Nowe nunde bengka a hanga. ");
INSERT INTO due_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dingan dinumatong un bulangay a an de katinggesan ta napuksa ide a pesan. Talage a maginon ngani a náloktat i manga agta de pagdetong ko a Pineta nun Makedepat a napa ni agta. ");
INSERT INTO due_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ta de panahon a inon ay te aduwa a lalaki a getarabeho de kaengin, i isin ay aamit ta i isin pan ay wawalat. ");
INSERT INTO due_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Te duman pala a aduwa a mahunain a gegiling, i isin ay aamit ta isin pan ay wawalat. ");
INSERT INTO due_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kanya depat a ugnay kamo a maghande ta an yu katinggesan i adow a pagdetong ni Panginoon yu. ");
INSERT INTO due_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ta esipin yu i oyo a halimbewa a be katinggesan la ni te adi ni beloy i odes a pagdetong ni migpannakow ay gepoyet eya a an na pabiyaan a nesilong de beloy na i migpannakow. ");
INSERT INTO due_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kanya depat kamo pala a maghande a ugnay ta de odes a an yu katinggesan ay nádetong ok a Pineta nun Makedepat a napa ni agta.” ");
INSERT INTO due_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nagtodu pala i Hisus, “Ay i naketingges a katabeng a depat a naponulusonan ay eya i bebiyen ni panginoon na ni pag-aláge de kakmukan pa a katabeng. Ta bebiyen ide ni naketingges ni pápangan de de matud a panahon. ");
INSERT INTO due_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kanya piyon i kapuoyen ni katabeng a inon be eya ay dinatongan ni panginoon na a geyedi ni pesan a kabuotan na. ");
INSERT INTO due_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Talage ay pesabi ko dikamo a inon ngani a katabeng ay papámahala ni panginoon na de pesan a adi na. ");
INSERT INTO due_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Misan ay be inon a katabeng ay malot ay sasabi na de sadile na, ‘Ay náloy pa i pag-ampulang ni panginoon ko.’ ");
INSERT INTO due_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ta dingan eya ay te gepo a gebelbel de kapadepade na a katebeng a namangan pati nekipag-inom de migbugnang ide. ");
INSERT INTO due_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Misan ay náampulang i panginoon ninon a katabeng de adow pati odes a an na katinggesan. ");
INSERT INTO due_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ay talage ngani a podusahan eya ni panginoon na ni mahigpit dingan dodugeng na eya de migdeya ide ta duman ay nátangos eya a náaratengot i ngipon na dehil de pagtiis na. ");
INSERT INTO due_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Nano i adow a pagdetong ko a te kapangyedihan ni Makedepat ay magi halimbewa a oyo. Te duman a sangpuwu a kamaddiketan a binumulwag tangani tatagbu de i lalaki a kákasal ta i belang isin dide ay te manga adde a salong. ");
INSERT INTO due_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nano ay un lima dide ay an naketinggesin ta un lima pan ay naketinggesin. ");
INSERT INTO due_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","I an ide naketingges ay te adde ni salong misan ay an ide te belun a langis. ");
INSERT INTO due_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Misan ay i naketingges pan ide ay te naunid a langis de salong de pati te duman pa ide a belun a langis. ");
INSERT INTO due_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nano ay nulunáloy i pagdetong ni lalaki a kákasal kanya tinongka ide a pesan a napapede. ");
INSERT INTO due_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Misan nun gitna di ni abi ay te inumolang a magioyo, ‘Wiyo di i lalaki a kákasal, tagbuin yu eya.’ ");
INSERT INTO due_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ta tambing a ginumiyos i sangpuwu a maddikit dingan pinakapiya de i salong de. ");
INSERT INTO due_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dingan sinabi nun lima a maddikit a an naketinggesin nunde lima a maddikit a naketinggesin, ‘Ay biyen yu pan ikami ni untik a langis ta nagkapalongpalong di i salong mi ide i.’ ");
INSERT INTO due_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Misan ay sinabi nun lima a kamaddiketan a naketinggesin, ‘Ay makati an nosukul dikitam i langis a oyo. Piyon pa a manggetang kamo de getinde na ni langis yu.’ ");
INSERT INTO due_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kanya tinumotul un lima a maddikit a an naketingges ta nun ide ay nanggetang pa ni langis ay dinumatong di i lalaki a kákasal. Ta un lima a nappahande ay kakoloy na a sinumilong de kásalan dingan inabetan di i pintohan. ");
INSERT INTO due_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nano ay dinumatong pan un lima a maddikit a an naketingges ta inolang de, ‘Panginoon, pasilongin yu ikami.’ ");
INSERT INTO due_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Misan ay tinubeg na dide, ‘Talage a ang ko ikamo peabuyenan.’” Sinabi ni Hisus a tuloy, ");
INSERT INTO due_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Kanya depat a maghande kamo ta an yu katinggesan i adow o i odes a pagdetong ko. ");
INSERT INTO due_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Magioyo pala i kapangyedihan ni Makedepat de innawa ni agta ta halimbewa te duman a agta a kinumang de alayu a bensa kanya inolangan na i katabeng na ide ta pinaalágean na dide i pesan a adi na tangani magkapakinabeng. ");
INSERT INTO due_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nano ay biniyebiyen na ide ni nappaayun de kaya de. Biniyen na i isin ni lima a kuwarta a ginto ta i isin pan ay aduwa pati un isin pa ay isin la dingan tinumotul di de paagowen na. ");
INSERT INTO due_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kanya ay un tinumanggep nun lima ay tinumotul ta pagkapagtinde na ay nagkapakinabeng ni lima pa. ");
INSERT INTO due_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Maginon pala i yinadi nun tinumanggep ni aduwa ta nagkapakinabeng pala ni aduwa. ");
INSERT INTO due_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ta un tinumanggep pan ni isin ay nagkutkut de putok ta tinagu na un kuwarta a winalat diya nun panginoon na. ");
INSERT INTO due_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ay pagkatakig di ni náloy a panahon ay inumampulang un panginoon nun katabeng ide a inon tangani matinggesan na a tipide di i napa ni pakinabeng ni kuwarta na. ");
INSERT INTO due_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nano ay linumane un tinumanggep nun lima a kuwarta ta sinabi na, ‘Panginoon, wiyo i lima a binoy yu deko ta wiyo pala i lima pa a pakinabeng ko.’ ");
INSERT INTO due_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ay sinabi diya ni Panginoon na, ‘Masampat i yinadi mo ta piyon ka a katabeng a depat a naponulusonan. Ta dehil de naponulusonan ka de untik ay papámahala ko ikaw de namas pa a hanga a halage. Kanya makikasalig ka deko a panginoon mo.’ ");
INSERT INTO due_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ta linumane pala un tinumanggep ni aduwa a kuwarta ta sinabi na, ‘Panginoon, wiyo i binoy yu deko a aduwa ta wiyo pala i aduwa pa a pakinabeng ko.’ ");
INSERT INTO due_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kanya sinabi pala diya ni Panginoon na, ‘Masampat i yinadi mo ta piyon ka a katabeng a depat a naponulusonan ta dehil de naponulusonan ka de untik ay papámahala ko ikaw de namas pa a hanga a halage. Kanya makikasalig ka deko a panginoon mo.’ ");
INSERT INTO due_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nano ay linumane pan un tinumanggep nun isin a kuwarta ta sinabi na, ‘Panginoon, katinggesan ko a ikamo ay mahigpit ta gegepas kamo ni an yu tinanom pati geguto kamo ni an yu pinasok. ");
INSERT INTO due_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ta nagkatakut ok dikamo kanya tinagu ko de putok i kuwarta yu ta wiyo nano i isin yu a kuwarta.’ ");
INSERT INTO due_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dingan eya ay tinubeg ni Panginoon na, ‘Malot i yinadi mo ta tamad ka a katabeng ta katinggesan mo mangani a gegepas ok ni ang ko tinanom pati geguto ni ang ko pinasok. ");
INSERT INTO due_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bekot ngani ta am mo pinuoy i kuwarta ko de bangko tangani nagkaduman ok nano ni kuwarta ko pati pakinabeng na?’ ");
INSERT INTO due_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ta sinabi ni panginoon de geuddi duman, ‘Amitin mo diya i isin a kuwarta ta boyin mo de te sangpuwu di. ");
INSERT INTO due_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ta i misan ino a te duman di ay bebiyen pa ni subra misan ay i te duman ni untik la ay aamit pangani i pesan. ");
INSERT INTO due_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kanya i oyo a katabeng a an te kabuluhan ay butin yu di de madumos to a ditow ta duman nátangos eya a náaratengot i ngipon na dehil de pagtiis na.’” ");
INSERT INTO due_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sinabi pala ni Hisus, “Nano de pagdetong ko a Pineta nun Makedepat a napa ni agta ay te kapangyedihan ok a masakut, a kakoloy ko i manga anghel ide nun Makedepat ta dingan nelipa ok de gepakaingap ko a piglipaan. ");
INSERT INTO due_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ta de panahon a inon ay netipun de kasagkaden ko i pesan a agta de belang bensa ta dingan kekiblag ko i an gepanulusun de gepanulusun deko, a magi peyedi ni mag-aalage ni topa be kekiblag na i kambing de topa na ide. ");
INSERT INTO due_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ta i manga gepanulusun a magi topa ko ay pákadepit ko de awenan ko ta i an ide gepanulusun a magi kambing ay pákadepit ko pan de awile ko. ");
INSERT INTO due_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ta dingan i ako a Hari ay sasabi ko de naddeawenan ko a, ‘Dumio kamo a kinalbian ni Ama ko ta tanggepin yu di i hinande a kapiyonan na, a hinande dingan ngona yinadi i putok i. ");
INSERT INTO due_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ta nun matigeng ok ay inungut ok yu ta nun naohaw ok ay pinainom ok yu ta nun ako ay napa ni biseta ay tinanggep ok yu a piyon. ");
INSERT INTO due_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Dingan nun anok te bedu ay pinabeduan ok yu ta nun nagkaorom ok ay inalágean ok yu pati nun ako ay nabilanggo ay kinangan ok yu.’ ");
INSERT INTO due_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nano ay de inon a adow ay i pinakaeyenan ide ni paghatol ay notubeg pan a magioyo, ‘Panginoon, kapide kamo natigeng a inungut mi o naohaw a pinainom mi? ");
INSERT INTO due_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pati kapide kamo man napa ni biseta a tinanggep mi a piyon o an te bedu a pinabeduan mi? ");
INSERT INTO due_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kapide mi ikamo kinta a nagkaorom o nabilanggo a kinangan mi?’ ");
INSERT INTO due_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nano ay ako a Hari ay totubeg ko dide, ‘Talage ay pesabi ko dikamo a nun yinadi yu inon de mahedepin ko a manga kabinsa ay yinadi yu deko.’ ");
INSERT INTO due_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ta dingan sasabi ko pan nunde napadio de awile ko i, ‘Lumayu kamo deko a gekaduman ni padusahan a apoy a an nagkapalong a hinande para de Satanas pati de manga anghel na ide. ");
INSERT INTO due_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ta nun ako ay natigeng ay anok yu inungut ta nun naohaw ok ay anok yu pinainom. ");
INSERT INTO due_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ta nun ako ay napa ni biseta ay anok yu tinanggep a unabis. Nun ako ay an te bedu ay anok yu pinabeduan pati nun ako ay nagkaorom pati nabilanggo ay anok yu kinangan.’ ");
INSERT INTO due_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Dingan notubeg pala ide, ‘Panginoon, kapide kamo natigeng, naohow, napa ni biseta, a an te bedu, nagkaorom pati nabilanggo a am mi tinabengan?’ ");
INSERT INTO due_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Misan ay ako a Hari ay sasabi ko dide, ‘Talage ay pesabi ko dikamo a nun an yu tinabengan i gepanulusun deko a mahenain ay ako pan i an yu tinabengan.’ ");
INSERT INTO due_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kanya ngani i oyo ide ay pakang de padusahan a an te kalog misan pan ay i pinakaeyenan ide ni paghatol ay gekaduman ide ni edup a an te kalog.” ");
INSERT INTO due_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pagkatapos ni Hisus a nagtodu ni pesan a inon ay sinabi na de mag-aadel na ide, ");
INSERT INTO due_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Katinggesan yu a gepo nano ay aduwa dila a adow ay kaadowen di ni Paskuwa ta dingan ako a Pineta nun Makedepat a napa ni agta ay padekop a papaku a tuloy de padipa.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nano ay nun nanon ay i ponu ide ni maghahandug ide pati pinakamatande ide a Hudyo ay nagpolong ide de beloy ni pinakaponu a maghahandug a i Kaipas. ");
INSERT INTO due_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ta nagpolong ide tangani te pagkakataon ide a mapadekop de i Hisus de an katinggesan ni makmuk, a mapabuno a tuloy. ");
INSERT INTO due_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Misan ay sinabi de, “Wet de kaadowen ta makati magulo a masakut i kaagtaan.” ");
INSERT INTO due_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nano ay nun duman ide Hisus de Betania de beloy ni Simon a nagkaketong ");
INSERT INTO due_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ay linumane diya i isin a mahuna a te adde ni onidin a pinu ni langis a mabengo a mahal i halage na dingan pinalisan na i ulo ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Misan ay nagbulas pan i mag-aadel na ide nun kinta de inon ta natulutantoan ide, “Bekot ta pekanugun i mabengo a iwina? ");
INSERT INTO due_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ta nappatud a panggetangin iwina a mabengo ni mahal a halage dingan boboy de mahedepin ide i kapanggetangan na.” ");
INSERT INTO due_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Misan ay katinggesan ni Hisus i pesabi de kanya sinabi na, “Wet yu abelaa i mahuna ta piyon i yinadi na a oyo deko ");
INSERT INTO due_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ta naaloy yu pa a kakoloy i mahedepin ide misan ay ako ay an yu naaloy a kakoloy dio ");
INSERT INTO due_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ta nano pa ay pinalisan na di i lawes ko ni mabengo a paghande de pagtapor deko. ");
INSERT INTO due_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Talage ay pesabi ko dikamo a deno man a te magsabi ni piyon a bereta ay sasabi pala i yinadi deko ni mahuna a oyo a pagkaesip diya.” ");
INSERT INTO due_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Dingan un isin pan de sangpuwu pati aduwa a i ngalan na ay Hodes Iskariyote ay kinumang di de ponu ide ni maghahandug ide. ");
INSERT INTO due_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ta tinanto na ide, “Pide man i naboboy yu deko be tatabengan ko ikamo a madekop yu i Hisus?” Pagkatapos ni pasurutsurotan de ay biniyen de eya ni tiluwon a puwu a kuwarta a pelak. ");
INSERT INTO due_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ta gepo nun nanon ay napapag-esip di i Hodes ni pagkakataon a mapadekop na i Hisus. ");
INSERT INTO due_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nano ay dinumatong di i tagibu a adow ni Tinapay a an Te Pahelab. Ta linumane de Hisus i mag-aadel na ide a nagtanto diya, “Deno i buot yu a gehande kami para dikamo ni pangapun a Paskuwa.” ");
INSERT INTO due_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tinumubeg i Hisus, “Kumang kamo de Herusalem ta lawagin yu i agta a sasabi ko, a sabiin yu diya a magioyo, ‘Pesabi ni magtutodu a alane di i odes na kanya eya pati mag-aadel na ide ay de beloy yu námangan ni pangapun a Paskuwa.’” ");
INSERT INTO due_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nano ay yinadi ni mag-aadel ide i dinodul dide ni Hisus ta naghande ide ni pangapun a Paskuwa. ");
INSERT INTO due_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nun abi di ay duman di i Hisus pati mag-aadel na ide de lamesa a pigpanganan. ");
INSERT INTO due_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dingan nun gepangan di ide ay nagsurut i Hisus, “Talage ay pesabi ko dikamo a padekop ok ni isin dikamo.” ");
INSERT INTO due_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nano ay nalungkut ide a masakut ta i belang isin dide ay getanto diya a magioyo, “Ako man Panginoon?” ");
INSERT INTO due_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Misan ay tinumubeg eya, “I kasabey ko a gedolo ni tinapay de mangkok na ay eya ngani i gepadekop deko. ");
INSERT INTO due_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ta ako a Pineta nun Makedepat a napa ni agta ay nelibun a magi sinabi ni kasulatan misan ay gepakatakut i násapit de agta a gepadekop deko. Ta piyon pa ngan tebe ay an di eya pinanganak.” ");
INSERT INTO due_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dingan i Hodes a gepadekop diya ay nagtanto pala a magioyo, “Magtutodu, ako man non?” Ta tinubeg eya ni Hisus, “Ikaw di i nagsabi.” ");
INSERT INTO due_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ta nun ide ay gepangan di ay nangamit i Hisus ni tinapay a nagpasalamat de Makedepat dingan pinisangpisang na a binuluboy de mag-aadel na ide ta sinabi na, “Amitin yu a panganin ta lawes kod yo.” ");
INSERT INTO due_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dingan inamit na pala i pig-inoman ni tayug a malanis ta pagkapagpasalamat na de Makedepat ay binoy na dide a sinabi na, “Uminom kamo a pesan. ");
INSERT INTO due_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ta i oyo a tayug a malanis ay gepamatud de bowon a pagpakikasungdu ni Makedepat a te katibeyen a i sagu ko a nobusbus para de makmuk tangani pakeeyenan ide ni mammalotin de. ");
INSERT INTO due_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Talage ay pesabi ko dikamo a anok di neinom a liwet ni oyo a tayug a malanis hanggen ang ko kasabey i pesan a gepanulusun a neinom kitam ni bowon a tayug duman de kataanan ni Ama ko a Makedepat de langot.” ");
INSERT INTO due_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ta pagkakanta de ni isin a pagpodi ay kinumang ide de Kalasan a Olibo. ");
INSERT INTO due_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pagdetong de ay sinabi dide ni Hisus, “De abi a oyo ay wawalat ok yu a pesan a magi pesabi ni Makedepat de kasulatan a, ‘Bobuno ko i mag-aaláge ni topa ta nákálat i topa ide.’ ");
INSERT INTO due_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Misan ay pagkatapos a pakeedup ok a liwet ay naona ok dikamo de Galilea.” ");
INSERT INTO due_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dingan sinabi ni Pedro diya, “Misan walatin kamo ni pesan ay ang ko ikamo wawalat.” ");
INSERT INTO due_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ay tinubeg eya ni Hisus, “Talage ay pesabi ko dikaw a ni abi pala a oyo ay dingan ngona nátaráok i manok ay pengeyen ok mo ni tiluwon a sila.” ");
INSERT INTO due_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Misan ay maksa a sinabi ni Pedro, “Misan malibun ok a kakoloy yu ay ang ko ikamo pengeyen.” Maginon pala i sinabi ni pesan a mag-aadel. ");
INSERT INTO due_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Dingan kinumang ide Hisus de isin a lugel a te ngalan a Getsemani ta sinabi na dide, “Magilinepa kamo ngona dio ta nanalangin ok de kadepit pa duman.” ");
INSERT INTO due_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Misan ay inikag na i Pedro pati aduwa a mangának ni Sebedeo ta te gepo a nagkolungkut a masakut a pepamologpologen. ");
INSERT INTO due_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Dingan sinabi na dide, “Nano ay nagkolungkut ok a masakut a magi nelibun ok. Mag-ilat kamo dio a makipagpoyet deko.” ");
INSERT INTO due_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ta pagkalayu na dide ni untik ay linumuhud a nanalangin a magioyo, “Ama ko, be nappatud ay layuin yu tebe deko i tetiis ko a oyo misan ay wet nangyeyedi i kabuotan ko ta i kabuotan yu la.” ");
INSERT INTO due_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ay inumampulang i Hisus de mag-aadel na ide a tiluwon a kapulupede kanya sinabi na de Pedro, “Ang ka mangani nakapepoyet misan isin la a odes a kakoloy ko? ");
INSERT INTO due_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kanya makipagpoyet kamo a magpanalangin tangani wet kamo notukso ta i kaleduwa ni agta ay nappahande a geabut de Makedepat misan ay mahena i lawes dehil de belang buot na.” ");
INSERT INTO due_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dingan liwet eya ay linumayu a nanalangin ta sinabi na, “Ama ko, be an nappatud a lalayu deko i oyo a tetiis ko ay mangyedi i kabuotan yu la.” ");
INSERT INTO due_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nano ay nun inumampulang eya a liwet dide ay dinatongan na ide a kapulupede pa ta ide ay petongka di a masakut. ");
INSERT INTO due_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kanya winalat na ide a liwet a linumayu ni untik ta eya ay pakatiluwon a sila a nanalangin ta i den na a peaged i pesabi na pala. ");
INSERT INTO due_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Dingan eya ay inumampulang pan di a liwet de mag-aadel na ide ta sinabi na, “Napede kamo pa man a gepaimloy? Pagelawagin yu ta dinumatong di i odes a ako a Pineta nun Makedepat a napa ni agta ay padekop di de makikkakasalanan ide. ");
INSERT INTO due_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kanya umuddi kamo di ta magtul di ta wiyo di i agta a gepadekop deko.” ");
INSERT INTO due_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nun gesurut pa i Hisus ay dinumatong di i Hodes a isin de sangpuwu pati aduwa a mag-aadel a te kakoloy ni makmuk a kaagtaan a te manga adde ni utak pati panopras. Ta ide ay inumapo de ponu ide ni maghahandug ide pati de pinakamatande ide a Hudyo. ");
INSERT INTO due_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Misan nun am pa ide gedetong duman ay binoy ni Hodes i magioyo a tande, “I angutan ko ay eya ngani i pelawag tam ta dekopin yu a tambing.” ");
INSERT INTO due_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pagdetong ni Hodes ay linumane dila a tambing de Hisus ta sinabi na, “Mapadikamo tebe i kasampatan a innawa, Magtutodu.” Dingan inangutan na. ");
INSERT INTO due_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sinabi ni Hisus diya “Ayun, bekot ta maginon?” Dingan linanean i Hisus ni manga agta ta dinakop de. ");
INSERT INTO due_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Misan ay i isin de kakoloy ide ni Hisus ay nangugnus ni utak ta tinigbes na i isin a katabeng ni pinakaponu a maghahandug ta nasapsap ngani i talinga na. ");
INSERT INTO due_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ta sinabi diya ni Hisus, “Kalobenin mo i utak mo na ta i gegemit ni utak ay de utak pala nelibun. ");
INSERT INTO due_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Am mo man katinggesan a nappatud ok a náaged de Ama ko ni makmuk a lebu a anghel a nátabeng deko ta paadden ok na pan a tambing ");
INSERT INTO due_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","misan ay papalano a nammatud i hinola de kasulatan a depat a nangyeyedi?” ");
INSERT INTO due_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ta dingan sinabi ni Hisus de kaagtaan ide, “Anok tulisan. Bekot ta nagidinio kamo a te manga utak pati panopras a nanakop deko? Ta adow adow ay nagtodu ok de beloy a pighandogen de Makedepat a anok yu pan dinakop. ");
INSERT INTO due_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Misan ay nangyedi i pesan a oyo tangani mamatud i sinolat ni magsasabi ide.” Pagkasabi na ninon ay nagiginikan i mag-aadel na ide ta winalat de eya a lallan. ");
INSERT INTO due_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nano ay inikag ni nanakop ide i Hisus de beloy ni Kaipas a pinakaponu a maghahandug ta duman natipun i magtutodu ide ni Hudyo pati pinakamatande ide. ");
INSERT INTO due_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","I Pedro pan ay inumabut misan alayu la i pag-etan. Sinumilong pala eya de bekoran ni beloy nun pinakaponu a maghahandug ta linumipa de alane ni magbebentay ide tangani kitain na i nangyeyedi. ");
INSERT INTO due_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nano ay i ponu ide ni maghahandug ide pati pesan a kapolongan a pinakamatande ay naglawag ni agta a gesumbong ni kabutelan tungkul de Hisus tangani mapabuno de eya. ");
INSERT INTO due_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Talage a an ide te pekita a pagsumbong a te kabuluhan para dide misan makmuk di i gesumbong ni kabutelan tungkul de Hisus. Nano ay de inapóan ay te duman a aduwa a agta ");
INSERT INTO due_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a nagsumbong ni magioyo, “Sinabi ni oyo a agta a sesede na kon i oyo a beloy a pighandogen de Makedepat, a yeyedi na pan la de tiluwon a adow.” ");
INSERT INTO due_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dingan inumuddi i pinakaponu a maghahandug ta tinanto na i Hisus, “Ang ka man te natotubeg de pagsumbong a inon dikaw?” ");
INSERT INTO due_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Misan ay an dila geyamyam i Hisus a unabis kanya eya ay tinanto a liwet ni pinakaponu a maghahandug, “Pedodul ko ikaw de makapangyedihan a ngalan ni Makedepat a an te kalebunan, a sabiin mo dikami ti ikaw ngani i Anak nun Makedepat a i Kristo a Pinangako na?” ");
INSERT INTO due_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tinumubeg i Hisus, “Ikamo pala i gesabi ta pesabi ko pan dikamo de an naaloy ay ako a Pineta nun Makedepat a napa ni agta ay kekita yu a nelipa de awenan ni Makedepat a Makapangyedihan ta nádetong ok a nappa de kunom de longaw na.” ");
INSERT INTO due_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nano ay ginisi ni pinakaponu a maghahandug i sadile na a bedu a tande a malot diya i sinabi ni Hisus ta sinabi na, “I oyo ay an te gelang de Makedepat. Ta nano ay an tam di kaelangan i pagsumbong ni kakmukan ta ikamo di a pesan i inumikna a eya ay an te gelang de Makedepat. ");
INSERT INTO due_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kanya nano ay ano i peesip yu tungkul diya?” Ay tinumubeg ide, “Ay depat eya a bunoin.” ");
INSERT INTO due_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dingan pagkataklop de de mata ni Hisus ay binugen de i mukha na a sinulusuntuk pala. Pati tinampal eya ni kakmukan ");
INSERT INTO due_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta sinabi de, “Hale di, holaan mo ti ino i gesuntuk dikaw be ikaw i Kristo a Pinangako nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nano ay i Pedro pan ay gelipa nunde ditow a bekoran dingan linumane diya i isin a mahuna a katabeng ta sinabi na de Pedro, “Kasta kakoloy ka pala ni Hisus a iwina a tage Nasarit a sákup ni Galilea?” ");
INSERT INTO due_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Misan ay nangeyen i Pedro de kasagkaden ni pesan a, “Ang ko katinggesan i pesabi mo.” ");
INSERT INTO due_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dingan kinumang de alane ni pintohan i Pedro misan ay kinta pan eya duman ni isin pa a katabeng a mahuna ta sinabi na de manga lalaki duman, “I oyo a lalaki ay isin de kakoloy ide ni Hisus a tage Nasarit.” ");
INSERT INTO due_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Misan ay liwet a nangeyen i Pedro a sinumpa na a, “Ang ko peabuyenan i agta a iwina.” ");
INSERT INTO due_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nun mulumáloy di ay sinabi pan de Pedro ni kauluuddi ide duman a, “Talage a isin ka ngani de kakoloy na ide ta peabuyenan pan de punto ni surut mo.” ");
INSERT INTO due_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dingan sinumumpa di i Pedro ta sinabi na, “Talage a misan malibun ok ay ang ko peabuyenan i agta a iwina.” Dingan tambing a tinumaráok un manok. ");
INSERT INTO due_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kanya naisepan ni Pedro i sinabi diya ni Hisus a, “Dingan nátaráok i manok ay pengeyen ok mo ni pakatiluwon a sila.” Dingan binumulwag i Pedro a nagtangos a masakut a nagkolungkut. ");
INSERT INTO due_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nun kinábiabian di ay nasurutsurotan i ponu ide ni maghahandug ide pati pinakamatande ide a Hudyo a ti papalano a pobuno de i Hisus ");
INSERT INTO due_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ta i Hisus ay ginapus de a inikag de de Gubernador a Pilato. ");
INSERT INTO due_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","I Hodes pan a nagpadekop diya ay nagsosol eya nun kinatinggesan na a i Hisus ay hinatolan ni kalebunan. Kanya inampulang na un tiluwon a puwu a kuwarta a pelak nunde ponu ide ni maghahandug pati de pinakamatande ide. ");
INSERT INTO due_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ta sinabi na dide, “Ako ay te kasalanan ta pinadekop ko i agta a an te kasalanan.” Misan ay sinabi nun ponu ide ni maghahandug ide pati pinakamatande ide, “Pangano mi ta behala ka.” ");
INSERT INTO due_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dingan sinapwar na un kuwarta de disalad nun beloy a pighandogen de Makedepat ta tinumotul a nagbitkol. ");
INSERT INTO due_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Misan ay pinulut ni ponu ide ni maghahandug ide un kuwarta a pelak ta sinabi de, “Malot de pagdodul a popuoy tam yo de pigpuoyen ni handug de beloy a pighandogen de Makedepat ta i oyo ay beyed ni edup ni isin a agta.” ");
INSERT INTO due_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kanya nagkasungdu ide a i kuwarta a inon ay panggegetang de ni kaengin ni magyeyedi ni benga a putok, a yeyedi de a pigtaporan ni tage kakmukan a lugel. ");
INSERT INTO due_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanya pan i kaengin a inon ay inolangan a pigtaporan a ginatang ni sagu hanggen de panahon a oyo. ");
INSERT INTO due_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ta talage a nangyedi di i hinola ni magsasabi a Heramias a, “Magioyo i kahalage ni pagpadekop ni isin a agta de tage Israel ide ta i kuwarta a tiluwon a puwu a pelak ay inamit de. ");
INSERT INTO due_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Dingan pinanggetang de ni kaengin ni magyeyedi ni benga a putok a nappaayun de dinodul deko ni Panginoon a Makedepat.” Inon i hinola ni Heramias. ");
INSERT INTO due_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nano ay pagdetong de de Gubernador a Pilato ay pinasagkad de i Hisus diya ta eya ay tinanto ni Pilato, “Ikaw man i hari ni Hudyo ide?” Dingan tinumubeg i Hisus, “Ikamo di i gesabi.” ");
INSERT INTO due_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Misan ay nun pesumbong pa eya ni ponu ide ni maghahandug ide pati pinakamatande ide ay an di eya tinumubeg. ");
INSERT INTO due_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kanya sinabi diya ni Pilato, “Am mo man peikna i makmuk a pagsumbong de a tungkul dikaw?” ");
INSERT INTO due_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Misan ay an di tinumubeg i Hisus a unabis kanya nagtaka di a masakut un gubernador. ");
INSERT INTO due_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nano ay belang kaadowan ni Paskuwa ay te ugeli un gubernador a gepabulwag ni isin a nabbilanggo a nappaayun de buot ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nun nanon pan ay te isin a peabuyenan a nabbilanggo a te ngalan a Barabás. ");
INSERT INTO due_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kanya pan nun natipun di un kaagtaan ay tinanto ide ni Pilato, “Ino man i buot yu a pabulwagen ko, i Barabás man o i Hisus a te ngalan a Kristo?” ");
INSERT INTO due_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ta katinggesan pan ni Pilato a nagkasinna la ide dehil de pagbuot ni kaagtaan de Hisus kanya inikag de i Hisus diya. ");
INSERT INTO due_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pati nun linumipa i Pilato nunde pighatolan na ay pinasabi diya ni bebi na a, “Wet ka nekilabot de agta a iwina a an te kasalanan ta nun abi ay nahedepan ok de pangnenop ko a tungkul diya.” ");
INSERT INTO due_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nano ay i kaagtaan pan ay pinagsabian ni ponu ide ni maghahandug ide pati pinakamatande ide a agedin de de Pilato a i pabulwag na ay i Barabás ta pabunoin na pan i Hisus. ");
INSERT INTO due_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ta i kaagtaan ay liwet a tinanto ni gubernador, “Ino de aduwa i buot yu a pobulwag ko?” Tinumubeg ide, “I Barabás.” ");
INSERT INTO due_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kanya tinanto ide ni Pilato, “Be maginon ay ano man i yeyedi ko de Hisus a te ngalan a Kristo?” Misan ay nagiinolang ide a pesan a magioyo, “Pakuin eya de padipa.” ");
INSERT INTO due_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ta tinanto na ide, “Ta ano man i yinadi na a kasalanan?” Misan ay namas pa a nagiinolang ide, “Pakuin eya de padipa.” ");
INSERT INTO due_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nano ay nun katinggesan ni Pilato a an eya te nayeyedi ta namas la a nagkogulo i kaagtaan ay nagpaamit eya ni orat dingan inugesan na i kumot na ta sinabi na, “Talage ay anok te kasalanan de pagkalibun ni agta a oyo ta behala kamo.” ");
INSERT INTO due_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta tinumubeg i kaagtaan, “Talage a behala kami pati mangának mi a gekaduman ni padusa dehil de pagkalibun na.” ");
INSERT INTO due_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dingan pinabulwag ni Pilato i Barabás misan ay pinalapdit na i Hisus dingan binoy na de sundelo ide tangani pakuin de de padipa. ");
INSERT INTO due_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ta i Hisus ay inikag nun sundelo ide nun gubernador de bekoran ni beloy na ta natipun i makmuk a masakut a sundelo de palebut ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dingan eya ay inubeden de nun bedu na a sadile ta kinulapyawen de eya ni malumaderag a magi kulapyaw ni hari a panlibek. ");
INSERT INTO due_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pati nagyedi ide ni suklong a tinik ta sinuklong de diya dingan pinapamol de eya ni tangbu de awenan na a kumot. Ta linuhuden a binate de eya a panlibek a magioyo, “Maedup ka, Hari ni Hudyo ide.” ");
INSERT INTO due_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ta eya ay binugebugen de dingan inamit de i tangbu a linapdit de de ulo na. ");
INSERT INTO due_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nun pagkatapos ni paglibek de diya ay inubeden de ni kulapyaw a mulumaderag ta binaduan de ni sadile na a bedu ta binulwag de tangani pakuin de de padipa. ");
INSERT INTO due_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nano ay nun pabulwag ide ay kinta de i isin a lalaki a te ngalan a Simon a tage Sirene ta pinelit de a pinapassan diya un padipa ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ta pagdetong de de lugel a te ngalan a Golgota a i kabuluhan na ay “Kaksan ni ulo” ");
INSERT INTO due_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ay biniyen de i Hisus ni tayug a te dugeng a apdu misan ay nun kininaman na ay an na ininom. ");
INSERT INTO due_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nun pinakuan de eya de padipa ay nagsugel i sundelo ide a binulubinsa de un demit na. ");
INSERT INTO due_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dingan ide ay nagilinepa ta binantayen de eya duman. ");
INSERT INTO due_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta nassolat de diditas ni ulo ni Hisus i pagsumbong diya a magioyo, “I oyo i Hisus a Hari ni Hudyo ide.” ");
INSERT INTO due_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ay pinakuan de pala i aduwa a tulisan a kasabe na de padipa, isin de awenan na, i isin pala de awile na. ");
INSERT INTO due_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ta i belang gesila ay gelibek diya a gepinagworog i ulo de ta sinabi de, ");
INSERT INTO due_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Aman la ikaw i nansesede ni beloy a pighandogen de Makedepat ta yeyedi mo a liwet de tiluwon la a adow? Kanya nano ay ligtasin mo i sadile mo. Ta be ikaw i matud a Anak nun Makedepat ay lumusong ka di de padipa mo na.” ");
INSERT INTO due_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Maginon pala ay linebek eya ni ponu ide ni maghahandug ide, magtutodu ide ni Hudyo pati pinakamatande ide ta sinabi de, ");
INSERT INTO due_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Te kaya eya a nanligtas ni kakmukan ay am pan te kaya a nanleligtas ni sadile na. Aman la eya i Hari ni Hudyo ide? Talage a be nolusong eya de padipa na ay nonulusun kami diya. ");
INSERT INTO due_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ta eya ay gepanulusun kon de Makedepat pati sinabi na a eya ay Anak nun Makedepat kanya nano ay be pebuot eya ni Makedepat ay leligtas na.” ");
INSERT INTO due_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta linebek pala eya ni kasabey na ide a tulisan a pinaku de padipa. ");
INSERT INTO due_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nano ay gepo nun udto di ay hanggen de apun a kadepit ay dinumumos i pesan a putok. ");
INSERT INTO due_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Dingan nun apun di a kadepit ay inumolang i Hisus ni malagdu a magioyo, “Eli, Eli, lama sabaktani?” a i buot na a sasabi ay, “Makedepat ko, Makedepat ko, ano ta pinabiyaan ok yu?” ");
INSERT INTO due_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ta nun inikna pan non ni tipide a kauluuddi duman ay sinabi de, “Patalikngan yu ta peolangan na i Elias.” ");
INSERT INTO due_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ta tambing dila a ginumikan i isin dide ta nangamit ni lumut ta binasá na ni tayug a maapsut a ginipot na de tangbu dingan pinasopsop na de Hisus. ");
INSERT INTO due_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ta sinabi pan nun kakmukan, “Ilatin tam ngona ti nádetong i Elias tangani eya ay lusongin na de padipa.” ");
INSERT INTO due_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Dingan liwet a inumolang i Hisus ni malagdu ta napugtusan di. ");
INSERT INTO due_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ta dingan nagisi un age a mukpal a sagbong a nasampay de beloy a pighandogen de Makedepat gepo de ditas hanggen de sidong. Ta yinumogyog i putok ta i beto ide ay nasipaksipak. ");
INSERT INTO due_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pati nakayesan i táporan ide ta i kamakmokan a nalibunin a pineta ni Makedepat ay nàedupin. ");
INSERT INTO due_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ta nun pinakaedup di a liwet i Hisus ay binumulwag ide de táporan de ta sinumilong ide de Herusalem a benwaan ni Makedepat ta kinta ide ni kamakmokan duman. ");
INSERT INTO due_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nano ay i sundelo ide pati kapitan de a nagbentay de Hisus ay natakut ide a masakut nun betyagin de i yogyog, a kinta de pala i pesan a nangyeyedi ta sinabi de, “Talage ngani a eya ay Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ta duman pala i makmuk a mahunain a napasayed gepo de alayu ta ide i inumabut de Hisus gepo de Galilea a tinumabeng diya. ");
INSERT INTO due_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","I tiluwon dide ay i Maria Magdalena, Maria a ina ni magwele a Santiago pati Hose ta te duman pala i bebi ni Sebedeo. ");
INSERT INTO due_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nano ay nun mulumadumos di ay dinumatong i isin a agta a mayaman a tage Arimatea a i ngalan na ay Hose a mag-aadel pala ni Hisus. ");
INSERT INTO due_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ta eya ay kinumang de Pilato a inaged na i bengkay ni Hisus ta dinodul pan di ni Pilato a boyin diya. ");
INSERT INTO due_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kanya inamit na i bengkay ta tiningos na de age a bowon. ");
INSERT INTO due_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dingan pinuoy na de sadile na a táporan a pinayedi na a bowon de denpa. Ta pagkatapos ay pinabulidbulid na un beto a hanga a inabet de táporan a gob ta eya ay tinumotul di. ");
INSERT INTO due_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Misan i Maria Magdalena pan pati isin pa a Maria ay gelipa ide nunde tipong nun táporan. ");
INSERT INTO due_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nano ay nun kinábiabian di a pagkatapos ni adow a paghande ay i ponu ide ni maghahandug ide pati Pariseo ide ay nakulukóloyen ide a kinumang de Pilato. ");
INSERT INTO due_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ta sinabi de, “Nagkàisepan mi un sinabi nun migbutil a inon, nun eya ay nàedup pa, a pakeedup kon eya a liwet de katiluwon a adow. ");
INSERT INTO due_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kanya pabentayen yu tebe a mahigpit i táporan na hanggen de katiluwon a adow. Ta kati panakówen nun mag-aadel na ide i bengkay na dingan sabiin de a pinakaedup di a liwet ta dingan namas pa a nappa ni malot i pagdeya de de kaagtaan.” ");
INSERT INTO due_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ta tinubeg ni Pilato, “Te duman dikamo a sundelo ta pabentayen yu a mahigpit hanggen te kaya kamo i táporan.” ");
INSERT INTO due_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kanya dinumuman ide a dinumanan de ni tande un beto a pangabet ta pinabentayen de un táporan. ");
INSERT INTO due_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nano ay pagkatakig di ni adow ni paimloy, nun abiabi pa a masakut ay dinumuman i Maria Magdalena pati isin pa a Maria ta buot de a pelawag i táporan. ");
INSERT INTO due_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dingan loktat a yinumogyog ni malagdu ta linumusong i isin a anghel ni Panginoon a Makedepat a gepo de langot ta pinabulidbulid na un beto a abet nun táporan a linumipa de disapow nun beto. ");
INSERT INTO due_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ta i mukha na ay gepakaingap a magi kilat pati bedu na ay malapsay a masakut a gepakaingap pala. ");
INSERT INTO due_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nano ay i sundelo pan ide ay gepinagkinkin ni takut dehil de kinta de un anghel dingan ide ay nabegsak a magi nalibun di. ");
INSERT INTO due_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Misan ay sinabi nun anghel nunde mahunain ide, “Wet kamo matakut ta katinggesan ko a pelawag yu i Hisus a pinaku de padipa. ");
INSERT INTO due_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Misan ay an di eya kadio ta pinakaedup di a liwet a magi sinabi na kanya dumio kamo ta pagelawagin yu i pinamuoyen diya. ");
INSERT INTO due_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Dingan tumotul kamo a tambing a sabiin yu de mag-aadel na ide a pinakaedup di eya a liwet. Ta naona di eya de Galilea ta kekita yu eya duman. Wet yu kelipatan i sinabi ko dikamo.” ");
INSERT INTO due_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kanya tinumotul ide a tambing de táporan a te takut a te kadugeng pala a salig. Ta gegikan ide a paagow de mag-aadel ide tangani masabi de i kinta de. ");
INSERT INTO due_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Misan ay paggikan de ay tambing a tinagbu ide ni Hisus. Ta binate na ide dingan linumane ide ta kinipotan de i singit na ta ide ay nagpodi diya. ");
INSERT INTO due_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Dingan sinabi dide ni Hisus, “Wet kamo matakut ta tumotul kamo a sabiin yu de mag-aadel ko ide a manga kabinsa a kumang ide de Galilea ta duman ok de kekita.” ");
INSERT INTO due_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pagkatotul nun mahunain ay un sundelo pan ide a gebentay de táporan ay sinumilong i tipide dide de Herusalem ta sinabi de de ponu ide ni maghahandug ide i pesan a nangyedi a kinta de. ");
INSERT INTO due_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kanya nun natipun di un ponu ide nun maghahandug ide pati pinakamatande ide ay nasurutsurotan ide dingan biniyen de ni hanga a kuwarta un sundelo ide. ");
INSERT INTO due_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ta pinasabi de i magioyo, “Dinumuman un mag-aadel ide ni Hisus ta pinannakow de un bengkay na nun ikami a nappede di.” ");
INSERT INTO due_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Dingan sinabi de, “Wet kamo nagkágesa misan matinggesan ni gubernador a ikamo ay nappede ta ikami i behala.” ");
INSERT INTO due_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ta tinanggep ngani nun sundelo ide un kuwarta ta yinadi de i tinutugun dide ta misan hanggen nano ay maginon i pebereta ni Hudyo ide. ");
INSERT INTO due_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nano ay i sangpuwu pati isin a mag-aadel ay kinumang ide de Galilea nunde tinodu dide ni Hisus a kalasan. ");
INSERT INTO due_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ta pagkakita de diya ay nagpodi ide misan ay te duman a tipide a te aduwa a esip ti eya dingani. ");
INSERT INTO due_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dingan linumane i Hisus dide ta sinabi na, “I pesan a kapangyedihan de langot man o de putok ay binoy di deko. ");
INSERT INTO due_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kanya nano ay tumotul kamo ta pamakmukin yu i mag-aadel ko de belang bensa ta linoden yu ide de ngalan ni Ama, Anak pati Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pati toduan yu ide a tumalinga de pesan a pedodul ko dikamo ta esipin yu ngani a ako ay kakoloy yu a ugnay hanggen de kalog ni panahon.” Inon i sinabi ni Hisus.");
INSERT INTO due_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Magioyo i paggepo ni piyon a bereta tungkul de Hisu Kristo a Anak nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Te duman de kasulatan ni Isais a magsasabi a den i pagsabi ni Makedepat de Anak na ta sinabi na a magioyo, “Patalikngan mo ta pakang ko i dinodul ko a naona dikaw ta hahande na i sesilan mo.” ");
INSERT INTO due_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sinabi pa ni Makedepat, “Nádetong i geolang de lugel a ilang ta gesabi eya a, ‘Handein yu i bektas para de Panginoon ta tanusin yu i sesilan na.’” ");
INSERT INTO due_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kanya pan nun maloy di ay dinumatong i Huwen a Maglilenod de ilang ta eya ay nagsabi ni magioyo de kaagtaan a, “Magipinagsosol kamo de mammalotin yu ta lelinod ko ikamo de orat a tande ni pagsosol yu ta pakeeyenan kamo ni Makedepat ni mammalotin yu.” ");
INSERT INTO due_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ta dinumatong diya i kasta pesan a tage sákup ni Hudia pati benwaan a Herusalem tangani magpatalikngoy de Huwen ta sinabi de i mammalotin de dingan lininod na ide de Orat a Horden. ");
INSERT INTO due_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nano i bedu ni Huwen ay linala a sapok ni hayup ta i beyakos na ay katat ni hayup ta i pepangan na pan ay magi salagubeng pati tagis ni pisokan. ");
INSERT INTO due_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Ta ugnay na a pesabi de pagsabi na a, “Pelinod ko di ikamo de orat a tande ni pagsosol yu misan ay te nádetong pa a nappaabut deko i namas pa a te kapangyedihan deko ta anok te sukul a kapangyedihan a nongukas ni gipot ni paragetus na ta eya pan i nanlelinod dikamo de Ispiritu nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nun nanon a panahon ay dinumatong i Hisus a inumapo de benwaan a Nasarit a sákup ni Galilea tangani linodin ni Huwen de Orat a Horden. ");
INSERT INTO due_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ay nun makasaka di i Hisus de mamala ay tambing a nakayesán i langot ta kinta ni Huwen a linumusong de Hisus i Ispiritu nun Makedepat a magi kalapati. ");
INSERT INTO due_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ta dingan te nagsurut a inumapo de langot a magioyo, “Ikaw i pebuot ko a Anak ta dehil dikaw ay nagkasalig ok a masakut.” ");
INSERT INTO due_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nano ay pagkatapos ninon ay tambing a inikag a mahigpit ni Ispiritu nun Makedepat i Hisus de lugel a ilang. ");
INSERT INTO due_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ta eya ay tinumaan de ilang a lugel a te mailapin a hayup a apat a puwu a adow ta sinubukan eya ni Satanas a petukso. Pagkatapos ninon ay petabengan pan i Hisus ni manga anghel ide. ");
INSERT INTO due_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nano ay nun pinadekop di ni Hari a Herod i Huwen a Maglilenod ay i Hisus pan ay inumampulang de Galilea a nagsabi ni piyon a bereta a gepo de Makedepat. ");
INSERT INTO due_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ta sinabi na, “Dinumatong di un panahon a pineta nun Makedepat ta mandeli di a te kapangyedihan eya de innawa ni manga agta. Kanya magipinagsosol kamo ni mammalotin yu ta depat a manulusun kamo de piyon a bereta a oyo.” ");
INSERT INTO due_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nano ay nun getotul i Hisus de kaginglan ni uluataben a Galilea ay kinta na i Simon pati Andres a wele na ta gesabud ide ta ide ay mag-iekan. ");
INSERT INTO due_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sinabi dide ni Hisus, “Sumut kamo deko ta ikamo ay yeyedi ko a mag-aakit ni agta tangani nosut pala ide deko a tuloy.” ");
INSERT INTO due_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ta nun nanon pala ay winalat de i sabud de, a sinumut ide de Hisus. ");
INSERT INTO due_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ta pagkalayu de ni untik ay kinta na pan ide Santiago pati Huwen a magwele a mangának ni Sebedeo. Ta ide pati ama de ay gepakapiya ni pokut de ide nunde bengka de. ");
INSERT INTO due_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ide ay inakit pala ni Hisus kanya tambing de a winalat i bengka de pati ama de a te kakoloy ni katabeng ide a peupahan ta sinumut ide de Hisus. ");
INSERT INTO due_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ta kinumang ide de benwaan a Kapernam. Ta nun kinábiabian a adow di ni paimloy ay sinumilong i Hisus de pigmitengan a Hudyo ta nagtodu eya. ");
INSERT INTO due_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Talage a nagtaka i kaagtaan de pagtodu na ta nagtodu eya a te kapangyedihan a masakut a an magi magtutodu ide ni Hudyo a an te kapangyedihan de pagtodu de. ");
INSERT INTO due_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nano ay te duman pala de pigmitengan i isin a lalaki a te malot a libong de lawes na. ");
INSERT INTO due_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ta inumolang i te libong a malagdu a magioyo, “Hisus kamo a tage Nasarit, bekot ta peabela yu ikami? Dinumio kamo man a nansesede ni kapangyedihan mi a kalibongan? Talage a peabuyenan ko ikamo a An Te Mammalotin a Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Misan ay sinablow ni Hisus i malot a libong ta sinabi na, “Tumimok ka ta lumayu ka de agta a iwina.” ");
INSERT INTO due_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dingan napaolang ni malagdu un te malot a libong, a pinumuluporewos i lawes na nun napalayu di un libong. ");
INSERT INTO due_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ay nagtaka a masakut un pesan a kaagtaan kanya ide ay natulutantoan a magioyo, “Ano man yo a bowon a pagtodu ta te kapangyedihan a masakut a gedodul de mammalotin a libong ta getalinga pan ide diya.” ");
INSERT INTO due_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ta tambing dila a kinumálat i bereta a tungkul de Hisus de pesan a sákup ni Galilea. ");
INSERT INTO due_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nano ay pagkabulwag de de pigmitengan ay sinumilong ide Hisus de beloy ni Simon Pedro pati Andres ta kakoloy de i Santiago pati Huwen. ");
INSERT INTO due_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ta nun nanon ay geide a pelagnat a masakut un panuwangan ni Pedro a mahuna kanya ide ay nakisurut a tambing de Hisus a papiyonin na i gupad. ");
INSERT INTO due_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nano ay linanean ni Hisus un pelagnat ta binolan na de kumot na a pinagiyos na. Nun nanon pala ay naeyen dingani i lagnat ni mahuna ta eya ay nag-akod dide ni pápangan. ");
INSERT INTO due_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nano ay nun pagkalinod di ni adow ay inikag ni kaagtaan de Hisus i pesan a te manga orom pati te manga libong de lawes de. ");
INSERT INTO due_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ta natipun un makmuk a agta a inumapo de benwaan nunde kadepit a pintohan nun beloy. ");
INSERT INTO due_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dingan pinapiyon na i makmuk a te manga orom misan ano i orom de pati pinalayu na i manga libong de lawes ni manga agta pati an na pinabiyaan a gesurut inon ide a libong ta kinatinggesan de a ti ino i Hisus. ");
INSERT INTO due_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nano ay nun mandeli pa a adow ay ginumiyos i Hisus ta kinumang eya de lugel a ilang ta nanalangin. ");
INSERT INTO due_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ta nun an náloy ay linawag eya ni Simon pati mangáyun na ide. ");
INSERT INTO due_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nano ay nun kinta de eya ay sinabi de diya, “Pelawag kamo ni kaagtaan a pesan.” ");
INSERT INTO due_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Misan ay tinubeg dide ni Hisus, “Kaelangan pan a kumang kitam de bulubenwaan tangani makapagsabi ok duman ni piyon a bereta ta dehil de oyo ngani ay dinodul ok dio de putok i.” ");
INSERT INTO due_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ta sinumilong eya de belang pigmitengan de sákup ni Galilea a nagsabi ni piyon a bereta pati nagpalayu ni libong ide de lawes ni agta ide. ");
INSERT INTO due_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nano ay te duman a linumane de Hisus a isin a lalaki a te ketong ta linumuhud a nag-aged a masakut a sinabi na, “Be buot yu ay papepiyon ok yu di ta ikamo ay te kaya.” ");
INSERT INTO due_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ta nakalbi pan i Hisus diya kanya inonat ngani ni Hisus i kumot na ta tinapá na a sinabi na, “Buot ko a talage. Pumiyon ka di.” ");
INSERT INTO due_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dingan tambing ngani a naeyen i ketong de lawes na ta pinumiyon di. ");
INSERT INTO due_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ta dingan ngona pinatotul eya ni Hisus ay tinutugun na a mahigpit a, “Wet mo sasabia misan dino i sinumapit dikaw misan ay kumang ka a palawag mo i lawes mo de isin nunde maghahandug ide nun Makedepat. Ta pagkakita na dikaway maghandug ka a nappaayun de pagdodul ide ni Moises ta inon ay gepamatad de kaagtaan a pinapiyon ka di.” ");
INSERT INTO due_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pagkatotul na ay binareta na i pesan a nangyedi diya. Kanya pan i Hisus ay an di gekasilong de benwaan ide ta duman dila eya de ilang a alayu de benwaan ide. Ta duman dila eya pekangan ni kaagtaan a geapo ti duludedeno a kadepit. ");
INSERT INTO due_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pagkatakig ni tipide a adow ay inumampulang i Hisus de benwaan a Kapernam ta dingan kinumálat di i bereta a eya ay duman di de sadile na a pigtaanan. ");
INSERT INTO due_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kanya kinumang i makmuk a masakut a kaagtaan de beloy a petaanan na ta an di nagkasukud, misan de pintohan. Ta ide ay petoduan ni Hisus ni surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dingan te dinumatong pan a apat a lalaki a te adde ide ni isin a lungpo. ");
INSERT INTO due_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Misan ay dehil de makmuk a masakut a manga agta ay an de nagkalane de Hisus kanya pinolkat de un atop nunde tipong ni Hisus ta pinaaroy de un pig-eden a te lungpo a napaide. ");
INSERT INTO due_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nun matinggesan ni Hisus i kahanga ni pagpanulusun de diya ay sinabi na de lungpo, “Ayun, pinakaeyenan ka di ni mammalotin mo.” ");
INSERT INTO due_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nano ay te gelipa pan duman a tipide a magtutodu ni Hudyo ta ide ay nagdeinnawa ni magioyo, ");
INSERT INTO due_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Bekot pan ta gesabi i agta a oyo ni maginon a an te gelang de Makedepat. Aman la i Makedepat la i te kaya a gepakaeyen ni mammalotin ni kaagtaan kanya malot yo a agta ta pepadepade na i sadile na de Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Misan ay tambing pan a kinatinggesan ni Hisus i naddeinnawa de kanya sinabi na dide, “Wet kamo mag-uluesip ni maginon a malot. ");
INSERT INTO due_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ta talage a namas pa a mamiyen i sabiin ko de lungpo a, ‘Pinakaeyenan ka di ni mammalotin mo,’ a an i ‘Gumiyos ka di ta addein mo i pig-eden mo na.’ ");
INSERT INTO due_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ta depat yu a matinggesan a ako a Pineta nun Makedepat a napa ni agta ay te kapangyedihan a gepakaeyen ni mammalotin dio de putok i kanya yeyedi ko di i mahedep pa de pekita yu.” Ay dingan sinabi ni Hisus nunde lungpo, ");
INSERT INTO due_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Pesabi ko dikaw a gumiyos ka di ta addein mo i pig-eden mo na a umuli ka di.” ");
INSERT INTO due_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dingan ginumiyos un lungpo ta inagkat na a tambing i pig-eden na ta tinumotul de pekita ni pesan a kaagtaan. Ta ide ay nagtaka pati ide ay nagpodi de Makedepat ta sinabi de, “Ang kitam pa gekita ni magioyo ti an nano la.” ");
INSERT INTO due_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nano ay kinumang i Hisus a liwet de kulukaginglan ni uluataben a Galilea ta inumabut diya i makmuk a manga agta ta dingan nagtodu eya dide. ");
INSERT INTO due_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ta tinumuloy la de pagtotul na dingan kinta na i Lebi a anak ni Alpeo a gelipa de pigsingelan ni buwis ta sinabi diya ni Hisus, “Sumut ka deko.” Ta dingan inumuddi ngani i Lebi a sinumut de Hisus. ");
INSERT INTO due_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nano ay nun duman di de beloy ni Lebi i Hisus pati mag-aadel na ide a gepangan ay dinumatong i makmuk a magsisengil ni buwis pati agta ide a makikkakasalanan a nasalósalóan ide. Ta makmuk ide a nagiinábut diya. ");
INSERT INTO due_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nano ay nun kinta ni tipide a magtutodu ni Hudyo pati Pariseo ide a gepakisaló eya de makikkakasalanan ide pati de magsisengil ide ay sinabi de de mag-aadel na ide, “Bekot pan ta gepakisaló la i magtutodu yu na de magsisengil ide pati makikkakasalanan ide?” ");
INSERT INTO due_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Misan ay nun inikna ni Hisus i oyo a surut ay sinabi na dide, “I an te orom ay an depat a gelawag ni magbubulong ta i te orom la i depat a gelawag. Ta anok dinumio a geolang de geesip ide a an ide te kasalanan ta dinumio ok ngani a geolang de makikkakasalanan ide.” ");
INSERT INTO due_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nun nanon ay an gepangan ni untik a panahon be gepanalangin i mag-aadel ide ni Huwen a Maglilenod pati Pariseo ide kanya linumane de Hisus i tipide dide a nagtanto a magioyo, “An gepangan ni untik a panahon be gepanalangin i mag-aadel ide ni Huwen pati manga Pariseo ide. Ano pan ta i mag-aadel yu ide ay eyen?” ");
INSERT INTO due_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Misan ay tinubeg ide ni Hisus, “An depat a an námangan i inakit ide a gegewes de kasalan hanggen kakoloy de pa i lalaki a kinasal. ");
INSERT INTO due_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Misan be nádetong i panahon a an di i lalaki a kinasal ay dingan de panahon a inon ay malungkut i inakit ide a an ide námangan ni untik a panahon. ");
INSERT INTO due_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Talage a an te getagpi de loma a demit ni kagisi a bowon. Ta be maginon ay negisi i loma a demit ni tagpi a bowon ta dingan negisi ni namas pa a hanga i loma a demit. ");
INSERT INTO due_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ta am pala te geunid de loma a oniden a katat ni bowon a tayug a malanis. Ta be maginon ay sesede ngani ni bowon a tayug i oniden a loma ta ide ay padepade la a nakanugun kanya depat pan a oniden i bowon a tayug a malanis de bowon pala a oniden.” ");
INSERT INTO due_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nano nun isin a adow a paimloy ay sinumila ide Hisus de kaparayen ta de pagtotul de ay nanggitol un mag-aadel na ide ni ohay nun paray. ");
INSERT INTO due_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Misan ay sinabi ni Pariseo ide de Hisus, “Pagelawagin yu i peyedi ni mag-aadel yu na ide ta an nappaayun de pagdodul tam i peyedi de na be adow ni paimloy.” ");
INSERT INTO due_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Dingan tinumubeg i Hisus dide, “An yu man binasa i yinadi ni Hari a Debid pati mangáyun na ide nun ide ay natigeng ta naubus di i pápangan de. ");
INSERT INTO due_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ta nun Abiator ay pinakaponu a maghahandug ay sinumilong ide de beloy a pighandogen de Makedepat dingan namangan ide nun tinapay a hinandug di de Makedepat ta biniyen na pala i mangáyun na. Esipin yu a inon ay an nappaayun de pagdodul ide ta i nappatud a namangan ninon ay i maghahandug la ide. Misan an te kasalanan ide Debid.” ");
INSERT INTO due_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sinabi pa ni Hisus dide, “I adow ni paimloy ay yinadi para de kapiyonan ni agta a am pan yinadi i agta para de adow ni paimloy. ");
INSERT INTO due_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kanya nano ay depat a matinggesan yu a ako a Pineta nun Makedepat a napa ni agta ay nagkaddepat a nanabi a ti ano i nappatud de adow ni paimloy.” ");
INSERT INTO due_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nano ay sinumilong a liwet i Hisus de isin a pigmitengan ni Hudyo ide. Te duman a isin a lalaki a nakkimaw i kumot na. ");
INSERT INTO due_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Misan ay pebentayen i Hisus ni tipide a agta duman tangani kitain de ti pepapiyon na un lalaki nunde adow ni paimloy, a te nasasabi ide a pagsumbong diya. ");
INSERT INTO due_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ay sinabi ni Hisus nunde lalaki a nakkimaw, “Umuddi ka de kasagkaden ko i.” ");
INSERT INTO due_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dingan sinabi ni Hisus de kaagtaan a magioyo, “Nappaayun man de pagdodul ide de adow ni paimloy a magyedi ni piyon o magyedi ni malot? Magligtas ni agta o mamuno?” Misan ay an ide nakayamyam. ");
INSERT INTO due_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Gengsa pati lungkut i pekita de mukha ni Hisus nun pinagelawag na i kaagtaan a naddepalebut na dehil de kaksaan ni innawa de ta dingan sinabi na de lalaki, “Onatin mo i kumot mo.” Inonat ngani nun lalaki i kumot na ta pinumiyon dingani. ");
INSERT INTO due_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ta binumulwag un Pariseo ide a nasurutsurotan ide a tambing pati mangáyun ide ni Hari a Herod a ti papalano a pobuno de i Hisus. ");
INSERT INTO due_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Dingan pan dinumolug i Hisus pati mag-aadel na ide a paagow de uluataben ta inabut eya ni makmuk a masakut a kaagtaan a inumapo de sákup ni Galilea pati Hudia, ");
INSERT INTO due_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","de benwaan a Herusalem, de sákup ni Idumea, de dipa ni Orat a Horden pati de pulupalebut a benwaan a Tiro pati Sidon. Ta nun naberetaan de i pesan a yinadi ni Hisus ay nagidinoman ide diya. ");
INSERT INTO due_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nagpahande i Hisus de mag-aadel na ide ni isin a bengka a gegemit na tangani wet eya nasilpit ni kaagtaan a nagidinatong. ");
INSERT INTO due_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ta makmuk di eya a pinapiyon a te manga orom kanya linanean eya ni te manga orom a pesan tangani matapá de la. ");
INSERT INTO due_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta i belang te libong de lawes na a gekita diya ay geluhud ide de kasagkaden na a geolang, “Ikamo ay Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ta mahigpit ide a pinagtutugunan ni Hisus a wet ide gebereta de misan dino ti ino eya. ");
INSERT INTO due_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nun nanon a panahon ay sinumakat i Hisus de pulupagotan ide ta pinakangan na i manga lalaki a buot na kanya kinumang ide diya. ");
INSERT INTO due_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Dingan nagpeta eya ni sangpuwu pati aduwa a nappa ni kulukakoloy na ide a mag-aatid de piyon a bereta. ");
INSERT INTO due_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ta ide ay biniyen na ni kapangyedihan a gepalayu ni kalibongan de lawes ni agta ide. ");
INSERT INTO due_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I oyo i ngalan ni sangpuwu pati aduwa a mag-aatid. I Simon a nginalanan na a Pedro. ");
INSERT INTO due_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ide Santiago pati Huwen a mangának ni Sebedeo. Ide ay nginalanan na a “Bonerges” a te kabuluhan a “Matapangin.” ");
INSERT INTO due_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ide Andres, Pilepi, Bartolome, Mateo, Tomas, Santiago a anak ni Alpeo, Tadeo, Simon a Masépag ");
INSERT INTO due_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","pati Hodes Iskariyote a nagpadekop de Hisus de kapagebuk na ide. ");
INSERT INTO due_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nano nun inumuli di ide Hisus de lugel na a sadili ay natipun a liwet i makmuk a masakut a kaagtaan ta an de di nagkayedi i mamangan ide. ");
INSERT INTO due_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nun nabereta yo nun mangáyun ni Hisus ay kinangan de eya a bobolan de tebe ta sinabi de a mali a, “Nagkesede i esip na.” ");
INSERT INTO due_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pati sinabi pan ni manga magtutodu ni Hudyo ide a inumapo de Herusalem a eya ay te libong de lawes na a i Belsebul a ponu ni kalibongan ide ta eya kon i nagboy de Hisus ni kapangyedihan a gepalayu ni kalibongan ide. ");
INSERT INTO due_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kanya pan pinalane ni Hisus diya i kaagtaan ta sinabi na i tipide a oyo a halimbewa, “Talage a an nappatud a i Satanas ay pepatotul na i manga katabeng na a libong. ");
INSERT INTO due_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ta misan deno a bensa be ide ay gepinagebuk ay nesede i kapangyedihan ni bensa a inon. ");
INSERT INTO due_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pati an notuloy i misan deno a mittanak be ide ay natulutaloan. ");
INSERT INTO due_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Maginon pala be i Satanas ay pepatotul na i manga katabeng na a libong ay kasta gepakitalo eya de sadile na ta an naaloy ay nesede di a tuloy i kapangyedihan na. ");
INSERT INTO due_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ta i oyo i halimbewa a nanalo ok di de Satanas ta an te misan ino a nakesilong de beloy ni agta a matibong, a nangamit ni kasangkapan na be an ngona gegepus ni nesilong i matibong ta dingan la nakesilong eya a nangamit ni misan ano. ");
INSERT INTO due_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Talage a matud ay pesabi ko dikamo a nappatud a pakeeyenan i manga agta ni misan ano a mammalotin de pati pagsurut ni malot a tungkul de Makedepat. ");
INSERT INTO due_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Misan ay talage a an pakeeyenan nano pati magpakapide pa man i misan ino a magsurut ni malot tungkul de pagyedi ni Ispiritu nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sinabi yo ni Hisus ta sinabi ni tipide a eya ay te libong de lawes na. ");
INSERT INTO due_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nun nanon ay dinumatong un ina pati manga wele a lalaki ni Hisus ta ide ay dio la nunde ditow a katobengen ta eya ay pepasabian de. ");
INSERT INTO due_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ta de palebut pan ni Hisus ay makmuk i kalipalipa kanya sinabi ni kalipalipa ide, “Dena de ditow to i ina yu pati manga wele yu ta buot de ikamo a nakkasurut.” ");
INSERT INTO due_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Misan sinabi ni Hisus, “Inoino man i ina ko pati manga wele ko?” ");
INSERT INTO due_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta sinumalepat eya nunde kalipalipa de palebut na ta sinabi na i magioyo, “Wiyo i magi ina ko pati manga wele ko. ");
INSERT INTO due_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ta i misan ino a geabut de kabuotan ni Makedepat ay ide ngani i magi ina ko pati manga wele ko.” ");
INSERT INTO due_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nano ay liwet a nagtodu i Hisus de kaginglan ni uluataben a Galilea. Ta eya ay kinatipunan ni makmuk a masakut a manga agta kanya pan sinumakoy eya nunde bengka de kaginglan nun langges ta duman eya linumipa. Ta un kaagtaan pan ide ay dio nunde langges a kaginglan nun uluataben. ");
INSERT INTO due_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ta nagtodu eya dide ni makmuk de padean ni halimbewa ide. Ta de pagtodu na ay sinabi na a magioyo, ");
INSERT INTO due_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Magpatalikngoy kamo ta te duman a isin a agta a kinumang a gesapwar ni binhi na. ");
INSERT INTO due_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ta de pagsapwar na ni binhi na ay te nadegdeg de kaginglan ni bektas ta dinumatong i kamanokan ay pinangan de la. ");
INSERT INTO due_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Te duman pan a nadegdeg de kabetoan a an mokpal i putok ta tambing a tinumubu dehil de malapis la i putok. ");
INSERT INTO due_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Misan ay pagtipá ni adow a masakut ay narango di un tubu ide ta an nagkaramut a sukul. ");
INSERT INTO due_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Te duman pala a nadegdeg de katinekan ta dingan nun hinumangain un tinik ide ay natalo de un tinumabu a binhi kanya an ide nagkaanak a unabis. ");
INSERT INTO due_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Misan ay te duman pan a nadegdeg de piyon a putok ta nun paghanga na ay nagkaanak ni makmuk a te tiluwon a puwu a butil, te anim a puwu a butil, pati te duman pala a isin a dian a butil.” ");
INSERT INTO due_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dingan sinabi ni Hisus a dugsong, “I misan ino a gepatalikngoy ay depat a tumalinga.” ");
INSERT INTO due_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nano ay nun lallan di i Hisus ay i tipide a nakaikna diya ay linumane a kakoloy ni sangpuwu pati aduwa ta ide ay nagtanto tungkul de halimbewa ide. ");
INSERT INTO due_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tinumubeg eya dide, “Dikamo a gepanulusun deko ay pepatingges i madisalad a kamatoden a ti papalano a te kapangyedihan i Makedepat de innawa ni manga agta misan ay de kakmukan ay getodu ok de padean ni halimbewa ide. ");
INSERT INTO due_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ta misan pekita de ay an de pesapot pati misan peikna de ay an de pagketinggesan ta an de buot a bobowon i esip de tangani pakeeyenan ide ni mammalotin de.” ");
INSERT INTO due_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nano ay tinanto ide ni Hisus a magioyo, “An yu pa man katinggesan i halimbewa a oyo? Be maginon ay ti papalano yu a pagketinggesan i kakmukan a halimbewa? ");
INSERT INTO due_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nano ay i katolad ni binhi a sinapwar ay i surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I kaginglan ni bektas a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat misan ay pagkapatalikngoy de ay nádetong a tambing i Satanas a nangagow ni surut a nadeinnawa de. ");
INSERT INTO due_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nano i kabetoan pan a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat, a nanulusun a tambing, a te salig a masakut. ");
INSERT INTO due_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Misan ay an matud i pagpanulusun de ta an te ramut kanya an ide notuloy. Ta pagdetong ni kahedepan pati paglibek dehil de pag-abut de de surut nun Makedepat ay tambing ide a nallagelag. ");
INSERT INTO due_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","I katinekan a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat ");
INSERT INTO due_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","misan ay dehil de pag-esip de ni attanan dio pati de pagbuot de de kayamanan pati de belang buot de a kasalegen dio de putok i ay nadeog a an gekitong i surut a nadeinnawa de. ");
INSERT INTO due_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nano ay i putok a piyon a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat a gepanulusun pala a matud. I oyo ide i gepinag-anak ni tiluwon a puwu, anim a puwu, pati isin a dian.” ");
INSERT INTO due_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sinabi ni Hisus a tuloy dide, “Talage a be te duman a getutud ni salong ay an na sasakloben ni takalan o popuoy de saruk ni pig-idean na ta popuoy na pan de talage a pigpuoyen na. ");
INSERT INTO due_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Maginon pala be nádetong di i kapangyedihan ni Makedepat ay an te nattagu a an kekita pati an te nattanom de innawa a an ketinggesan a eikna. ");
INSERT INTO due_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","I misan ino a gepatalikngoy ay depat a tumalinga.” ");
INSERT INTO due_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ta sinabi na pa dide, “Kanya pakapiyain yu i pagpatalikngoy yu ta i pansokat a pegemit yu de kakmukan ay eya pala i gegemit dikamo ni Makedepat a namas pa. ");
INSERT INTO due_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ta i misan ino a getalinga de pagtodu ko ay nadugengan i katinggesan na misan ay i an getalinga de pagtodu ko ay neeyen i katinggesan na a untik.” ");
INSERT INTO due_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Dingan sinabi pa ni Hisus a, “Be te kapangyedihan di i Makedepat de innawa ni agta ay inon ay magi isin a agta a gesapwar ni binhi de kaengin na. ");
INSERT INTO due_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ta pagkatapos na ninon ay tinumuloy eya de pagyedi na, adow adow, a an na katinggesan a ti papalano tinumubu i binhi na. ");
INSERT INTO due_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ta un putok pan la i nagpatubu pati nagpaohay ta dingan nagipinag-anak di ni makmuk a masakut. ");
INSERT INTO due_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nano ay nun maktongin di un binhi ay ginapas di ni nagsapwar ta dinumatong di i pagguto.” ");
INSERT INTO due_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sinabi ni Hisus a tuloy, “Nano ay sasabi ko dikamo a ti ano i kapadepade ni kapangyedihan ni Makedepat de innawa ni agta ide ta i oyo i gegemit ko a halimbewa. ");
INSERT INTO due_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I oyo a kapangyedihan ay magi isin a binhi a mustasa ta eya i kauntekan de pesan a binhi a petanom de putok. ");
INSERT INTO due_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Misan ay be natanom di a hinumanga ay nappa ni hanga pa de pesan a gemut ni golay ta duman di gepoged de manga sanga na i kamanokan.” ");
INSERT INTO due_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nano ay nagtodu i Hisus dide de padean ni makmuk a halimbewa ide a maginon a nappaayun de kaya ni esip de. ");
INSERT INTO due_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ta an eya te pagtodu a an te dugeng a halimbewa ide. Misan ay nagpatingges eya ni kamatoden de mag-aadel na la ide. ");
INSERT INTO due_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nun abi di ay sinabi ni Hisus de mag-aadel na ide, “Sumabusabu kitam di de dipa to.” ");
INSERT INTO due_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kanya winalat de un manga agta ta ide Hisus ay sinumakoy de bengka a te gepo ide a gesabusabu. Ta ide ay te kasabey a kakmukan a bengka. ");
INSERT INTO due_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dingan dinumatong pan dide i maslog a subesko ta dehil de hangain a desi ay mandeli a nepino un bengka ni orat. ");
INSERT INTO due_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Misan ay i Hisus pan ay napede a te olunan de kadepit a dipus ni bengka ta dingan eya ay binogbog ni mag-aadel na ide ta sinabi de, “Magtutodu, pabiyaan yu man a noomos kitam?” ");
INSERT INTO due_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ta ginumiyos i Hisus ta sinablow na i palos pati sinabi na pala de atab, “Lumaktab ka di.” Ta tinumimok ngani un palos ta piyon di i panahon. ");
INSERT INTO due_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ta sinabi na de mag-aadel na ide, “Bekot ta nagkatakut kamo? Talage a untik pa i pagpanulusun yu deko.” ");
INSERT INTO due_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dingan ide ay nagkaduman ni takut pati pagtaka a masakut ta ide ay natulutantoan, “Ano yo a kalase a agta ta getalinga pan diya i palos pati atab.” ");
INSERT INTO due_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nano ay dinumatong ide de dipa nun uluataben de lugel a Gadareno. ");
INSERT INTO due_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pagkalusong ni Hisus nunde bengka ay tinagbu eya a tambing ni isin a lalaki a te manga malot a libong de lawes na. Ta inumapo eya de pigtaporan ");
INSERT INTO due_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","a kataanan na. Ta misan tanikala ay an eya nagkagegiptan ni nagkaaloy. ");
INSERT INTO due_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Misan eya ay ugnay de a pegiptan ni tanikala de singit pati kumot na ay pepugtus na. Kanya an te misan ino a gepakadeog diya. ");
INSERT INTO due_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ta eya ay geolang adow pati abi nunde pigtaporan pati de pulupagotan ta pebigedbigeden na i sadile na nun beto ide. ");
INSERT INTO due_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nano ay nun alayu pa i Hisus ay nasayed na di ta eya ay ginumikan a palane de Hisus ta nagpodi diya i lalaki a te manga libong. ");
INSERT INTO due_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ay dingan dinodul ni Hisus diya, “Lumayu ka de lawes ni lalaki, libong ka a malot.” Ta inumolang i libong ni malagdu ta sinabi na, “Hisus kamo a Anak nun Makedepat a Kaditasan, bekot ta peabela yu ikami? Dehil de Makedepat ay geaged kami a masakut dikamo a wet yu ikami pepahedepan.” ");
INSERT INTO due_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dingan tinanto ni Hisus i malot a libong, “Ano man i ngalan mo?” Tinumubeg un libong, “Ikami ay manga lebu ta makmuk kami.” ");
INSERT INTO due_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ay nag-aged ide de Hisus a wet na ide patotulin de lugel a inon. ");
INSERT INTO due_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nano ay nunde karipakip nun pagotan ay te duman pan a hanga a kalugbuwen a kabebuyen a gepinagpangan. ");
INSERT INTO due_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ta nag-aged i libong ide a mahigpit de Hisus a, “Pakangin yu ikami nunde kabebuyen ide tangani nakálane kami de lawes de.” ");
INSERT INTO due_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dingan tinumalinga pan i Hisus dide kanya ide ay linumayu de lalaki ta linumane ide de lawes ni bebuy ide. Dingan loktat a nagiginekan un kabebuyen a padolug de rongtob a paagow de uluataben ta naomos ide duman. I kamakmuk nun kalugbuwen ay manga aduwa a lebu. ");
INSERT INTO due_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Misan ay un mag-aalage ide nun kabebuyen ay nagiginekan pala ide ta binareta de de benwaan pati de buluberiyu ide i pesan a nangyedi. Kanya pan nagibinulwag un kaagtaan tangani kitain de i nangyedi duman. ");
INSERT INTO due_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ta pagdetong de de kaddumanan ni Hisus ay kinta de un lalaki a linayuan ni aduwa a lebu a libong a gelipa, a piyon di i esip na, a nappabedu di kanya natakut a masakut i dinumatong ide. ");
INSERT INTO due_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ta sinabi pan dide nun nakákita ide ni pesan a nangyedi de te libong a lalaki pati nangyedi pala de kabebuyen. ");
INSERT INTO due_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dingan ginumapo ide a nag-aged a mahigpit de Hisus a eya ay tumotul de lugel de a inon. ");
INSERT INTO due_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nano nun sinumakoy di i Hisus de bengka ay nag-aged pan a mahigpit un linayuan ni libong ide a eya ay ikagin na. ");
INSERT INTO due_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Misan ay an tinumalinga i Hisus ta sinabi na diya, “Umuli ka di ta beretain mo de mangáyun mo ide i pesan a kapiyonan a yinadi dikaw ni Panginoon a Makedepat pati ti papalano a kinalbian na ikaw.” ");
INSERT INTO due_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dingan tinumotul ngani un lalaki a inon ta binareta na de sákup ni Dikapolis i pesan a kapiyonan a yinadi diya ni Hisus ta nagtaka a masakut i inumikna ide a pesan. ");
INSERT INTO due_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Misan ay nun liwet a sinumabusabu i Hisus de dipa ni uluataben ay kinatipunan pan di eya ni makmuk a kaagtaan ta eya ay duman pa de kaginglan ni uluataben. ");
INSERT INTO due_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ta dinumatong i isin a lalaki a te ngalan a Hayro a pinakamatande de pigmitengan a Hudyo. Nun kinta na i Hisus ay inumobbob eya de kasagkaden na, ");
INSERT INTO due_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a nag-aged a mahigpit de Hisus ta sinabi na, “Mandeli a nelibun i anak ko a mahuna kanya be nappatud ay sumut kamo deko ta tapáin yu eya tangani pumiyon pati maedup pa a tuloy.” ");
INSERT INTO due_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ta sinumut pan diya i Hisus ta inumabut dide i makmuk a masakut a kaagtaan ta nagkassilpit de i Hisus. ");
INSERT INTO due_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Te duman pan a isin a mahuna a te orom a gesagu ni sangpuwu di pati aduwa a taon. ");
INSERT INTO due_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Eya ay nagkahedepan a masakut dehil de makmuk di a magbubulong i namulong diya ta naubus di i pesan a kaedup na de pagpabulong na. Misan ay an dila napiyon i kabetyag na ta namas pa a malot. ");
INSERT INTO due_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Misan ay inikna na i pesabi ni manga agta a tungkul de Hisus kanya pan eya ay pinumelit a linumane de idogen ni Hisus ta tinumapá eya de bedu na. ");
INSERT INTO due_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ta sinabi na de sadile na a, “Be matapá ko la i bedu na ay nepiyon ok di.” ");
INSERT INTO due_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Dingan tambing a tinumimok i pagsagu na ta binatyag na a piyon dingani. ");
INSERT INTO due_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ta tambing pala a binatyag ni Hisus a eya ay binulwagen ni kapangyedihan a gebulong kanya linumingoy eya a nagtanto, “Inóman i nanapá de bedu ko i?” ");
INSERT INTO due_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Misan ay tinubeg eya ni mag-aadel na ide, “Makmuk a manga agta i nasulusilpetan dikamo. Ano ta petanto yu ti ino i nanapá dikamo?” ");
INSERT INTO due_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Misan ay tuloy la i paglingoylingoy ni Hisus ta pelawag na i nanapá diya. ");
INSERT INTO due_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","I mahuna pan ay katinggesan na i pesan a nangyedi diya kanya eya ay linumane de Hisus a gekinkin ni takut dingan inumbbbob de kasagkaden na ta sinabi na i kamatoden. ");
INSERT INTO due_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ta sinabi pan diya ni Hisus, “Mahuna, pinapiyon ka di ni pagpanulusun mo deko ta piyon ka di a masakut kanya umuli ka di a te kasampatan a innawa.” ");
INSERT INTO due_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Misan ay nun gesurut pa i Hisus ay te dinumatong a inumapo de beloy ni Hayro a nagsabi, “Nalibun di un anak yu. Wet yu abelaa i magtutodu na.” ");
INSERT INTO due_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nano ay an sinapot ni Hisus inon a sinabi ta sinabi na de pinakamatande de pigmitengan, “Wet kamo matakut ta magpanulusun kamo la deko.” ");
INSERT INTO due_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ta an eya te inikag ti an i Pedro magwele a Santiago pati Huwen. ");
INSERT INTO due_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nano ay pagdetong de nunde beloy ni pinakamatande de pigmitengan ay kinta ni Hisus i makmuk a masakut a manga agta ta ide ay nagkogulo, a getangos pati gepinaghagulhol a malagdu. ");
INSERT INTO due_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pagsilong na ay sinabi na dide, “Ano ta nagkogulo kamo a gepinagtangos ta an nalibun i anak ta nappede la.” ");
INSERT INTO due_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ta pinag-ilokan de eya. Misan nun mapabulwag ni Hisus un kaagtaan ide ay inikag na i kamoddenan nun anak a nallibun pati i tiluwon a mag-aadel na ide. Ta sinumilong ide de kadumanan nun anak. ");
INSERT INTO due_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Dingan binolan na i kumot na ta sinabi na, “Talita kumi.” a i buot na a sasabi ay, “Maddikit, pesabi ko dikaw a gumiyos ka di.” ");
INSERT INTO due_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ta tambing ngani a ginumiyos un maddikit a nallibun dingan nakatotul di. I katande na ay sangpuwu di pati aduwa a taon. Ta nagtaka ngani a masakut i kamoddenan na ide. ");
INSERT INTO due_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nano ay pinagsabian ide ni Hisus a mahigpit a wet de sasabia misan dino i nangyedi a inon. Ta dinodul na pala dide a biyen de eya ni pápangan. ");
INSERT INTO due_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nano ay tinumotul i Hisus duman ta inumuli eya de benwaan na a sadili. Ta kakoloy na pala un mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pagdetong ni adow ni paimloy ay ginumapo di eya a getodu de pigmitengan a Hudyo duman. Ta nagtaka i kamakmokan a inumikna diya kanya sinabi de, “Deno man nangamit i agta a iwina ni katinggesan na a oyo? Pati ti papalano man eya a gepakayedi ni gepakataka? ");
INSERT INTO due_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Am man la iwina i magyeyedi ni beloy a i anak ni Maria. Ta eya ay kabinsa ni ide Santiago, Hose, Hodes pati Simon ta dio nappataan i manga wele na a kamahunain.” Ta kinapoyen de eya. ");
INSERT INTO due_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kanya sinabi dide ni Hisus, “Talage ngani a i magsasabi ay pegelang misan deno puwide la de sadile na a lugel, de mangáyun na pati de mittanak na.” ");
INSERT INTO due_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ta an gepakayedi i Hisus ni gepakataka de sadile na a lugel ti an i pagtapá na la de uluesin a te orom tangani papiyonin. ");
INSERT INTO due_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ta eya ay nagtaka dehil de an ide nagpanulusun diya dingan linebut ni Hisus i buluberiyu ide ta eya ay nagtodu. ");
INSERT INTO due_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nano ay tinipun ni Hisus i sangpuwu pati aduwa a mag-aadel na ta dinodul na ide a de pagtotul de ay uluaduwa la. Ta biniyen na ide ni kapangyedihan a gepalayu ni malot a libong ide de lawes ni manga agta. ");
INSERT INTO due_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Ta ide ay pinagtutugunan na a, “Addein yu i paragetus yu pati sugkud de pagtotul yu misan ay wet kamo nangadde ni pápangan, soput pati kuwarta a nassukbit pati bedu a panlewes ta i isin ay sukul.” ");
INSERT INTO due_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Dingan sinabi na pala dide, “Misan deno kamo a beloy nekitaan, duman kamo la magpilong hanggen ang kamo getotul de inon a lugel. ");
INSERT INTO due_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nano be an de ikamo petanggep pati an de pepatalikngan i surut yu de misan deno a lugel ay pagpagin yu i delpong de singit yu a tande a kinapoyen de i surut nun Makedepat ta dingan tumotul kamo duman.” ");
INSERT INTO due_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kanya tinumotul i sangpuwu pati aduwa a nagsabi de manga agta a depat ide a magsosol ni mammalotin de. ");
INSERT INTO due_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nagpalayu ide ni libong de lawes ni manga agta a te libong pati pinunasan de ni langis i te manga orom ide ta pinumiyon ide. ");
INSERT INTO due_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nano ay nakadetong de Hari a Herod de Galilea i bereta a tungkul de Hisus ta i ngalan na ay katinggesan di de pesan a lugel. Ta sinabi ni tipide a, “Eya ay i Huwen a Maglilenod a pinakaedup a liwet kanya eya ay gepakayedi di ni maginon ide a gepakataka.” ");
INSERT INTO due_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Te gesabi pan a, “Eya ay i Elias a magsasabi a den.” Pesabi pala ni tipide a, “Eya ay magi isin de magsasabi ide a den.” ");
INSERT INTO due_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Misan ay i Herod a inumikna de inon ay sinabi na, “Ay talage a pinakaedup a liwet i Huwen a pinaputolan ko ni bong.” ");
INSERT INTO due_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nano ay nun nagbebi i Herod de Herodeas a bebi ni Pilepi a wele na ay sinosol ni Huwen i Herod a magioyo, “An nappaayun de pagdodul a binabian yu i bebi ni wele yu.” Pagkasabi na ninon ay pinadekop, pinagepus pati pinabilanggo ni Herod i Huwen dehil de Herodeas. ");
INSERT INTO due_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ta i Herodeas ay te gengsa de Huwen a binuot na pala a pobunu eya misan ay an na nagkayedi. ");
INSERT INTO due_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ta nagkatakut a te gelang i Herod de Huwen ta katinggesan na a eya ay agta a piyon a te malenis a innawa de pekita ni Makedepat kanya peligtas na eya. Ta nagkasalig i Herod a gepatalikngoy de pesabi ni Huwen misan ay nagkogulo pan i esip na de pesabi na. ");
INSERT INTO due_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nun naloy di ay nagkaduman pala ni pagkakataon i Herodeas a nebilos, nun dinumatong di i kapanganakan ni Herod ta inakit na de hinande na a pápangan i manga katabeng ni gubyerno, ponu ide ni sundelo ide pati te kapangyedihan ide de porobinsia ni Galilea. ");
INSERT INTO due_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nano ay nun sinumilong un anak ni Herodeas a maddikit a sinumayew ay nasalig a masakut i Herod pati kaagtaan a gekita. ");
INSERT INTO due_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kanya sinumumpa i Herod nunde maddikit a, “Boboy ko dikaw i misan ano a agedin mo misan i kalahati pa ni nasasakopan ko.” ");
INSERT INTO due_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nano ay binumulwag un maddikit ta tinanto na de ina na, “Ano man i aaged ko?” Tinumubeg un ina na, “I ulo ni Huwen a Maglilenod.” ");
INSERT INTO due_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kanya sinumilong a tambing un maddikit de Hari ta sinabi na, “I buot ko a boyin yu deko nano ay i ulo ni Huwen a Maglilenod a nappuoy de isin a pinggen.” ");
INSERT INTO due_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nalungkut dila a masakut i Herod nun iknain na inon. Misan ay dehil de pinangako na a inikna ni biseta na ide ay an na pinangeyenan i pinangako na diya. ");
INSERT INTO due_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dingan tambing a dinodul ni Herod un isin a magbebentay a, “Addein mo dio i ulo ni Huwen a Maglilenod.” Kanya pinutolan nun magbebentay i Huwen de bilanggoan. ");
INSERT INTO due_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ta inadde na un ulo na a nappuoy de pinggen dingan binoy na de maddikit ta binoy pan nun maddikit nunde ina na. ");
INSERT INTO due_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nano ay nun mabereta nun mag-aadel ide ni Huwen inon ay inamit de i bengkay na a tinapor de. ");
INSERT INTO due_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ay inumampulang de Hisus un mag-aatid na ide ta sinabi de diya i pesan a nayedi de pati ti papalano ide a nagtodu. ");
INSERT INTO due_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Misan ay makmuk a manga agta i nagidinatong pati nagitinotul kanya an di ide gepakapagpaimloy, a an ide pala gepakapangan kanya sinabi ni Hisus dide, “Ay kumang kitam di de isin a lugel a ilang a alayu de kamakmokan tangani makapagpaimloy kamo ni untik.” ");
INSERT INTO due_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dingan sinumakoy ide de isin a bengka a paagow de lugel a ilang. ");
INSERT INTO due_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Misan ay makmuk i nakakita pati nakatingges ni pagtotul de kanya gepo de bulubenwaan ay nagiinapo i kaagtaan a kinumang a maparipari de kadepit a paagowen nide Hisus a nappaona pa dide. ");
INSERT INTO due_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pagsaka ni Hisus ay kinta na i makmuk a maskaut a kaagtaan ta kinalbian na ide. Ta ide ay magi manga topa a an te mag-aaláge kanya te gepo eya a nagtodu dide ni makmuk. ");
INSERT INTO due_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nun apun di a masakut ay linumane de Hisus un mag-aadel na ide ta sinabi de, “Ilang yo a lugel a mandeli di a nelinod i adow. ");
INSERT INTO due_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pakangin yu di i kaagtaan de buluberiyu pati de binaloybeloy de pulupalebut na tangani manggetang ide ni pápangan de.” ");
INSERT INTO due_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Misan ay tinubeg ni Hisus dide, “Ikamo ngani i nongungut dide.” Ay tinumubeg pan ide diya, “Nanggegetang kami mangani ni tinapay a halage ni isin a lebu pati lima a dian a peso tangani mamangan i agta ide?” ");
INSERT INTO due_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ta tinanto pan ide ni Hisus, “Pide man i adde yu a tinapay? Lawagin yu tebe.” Ta pagkalawag de ngani ay sinabi de diya, “Lima la a tinapay pati aduwa a ikan.” ");
INSERT INTO due_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dingan dinodul na de mag-aadel na ide, “Palipain yu i kaagtaan a nattipuntipun de kademoan na.” ");
INSERT INTO due_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kanya nagilinepa i kaagtaan ide a nattipuntipun a te isin a dian o lima a puwu. ");
INSERT INTO due_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ta dingan inamit ni Hisus un lima a tinapay pati aduwa a ikan. Ta tinumingala eya de langot a nagpasalamat dingan pinisangpisang na un tinapay ide pati aduwa a ikan a binoy na de mag-aadel na ide. Ta ide pan i nagbuluboy de kaagtaan. ");
INSERT INTO due_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nakapangan ide a pesan a sukul. ");
INSERT INTO due_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nano nun tinipun nun mag-aadel ide un an de naubus a kulukapisang ay nakapino ide ni sangpuwu pati aduwa a gelálan. ");
INSERT INTO due_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Te manga lima a lebu a lalaki i namangan. ");
INSERT INTO due_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dingan tambing a pinasakoy ni Hisus i mag-aadel na ide de bengka a paagow de benwaan a Betsaida Hulias ta pinaona na ide nunde dipa nun uluataben ta un agta pan ide ay pinauli na di. ");
INSERT INTO due_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pagkatotul nun agta ide ay sinumakat pan i Hisus de pagotan tangani manalangin. ");
INSERT INTO due_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nano nun abi di ay un bengka ay duman di nunde ditow nun uluataben misan i Hisus pan ay lallan de pagotan. ");
INSERT INTO due_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ta kinta na a nagkehedepan i mag-aadel na ide de pag-awet ta ide ay nappasongsong de palos. Nano ay nun mandeli di a adow ay inumabut dide i Hisus a getotul de disapow ni uluataben dingan tatakigen na tebe ide. ");
INSERT INTO due_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Misan ay nun kinta ni mag-aadel na ide a eya ay getotul de disapow ni atab ay nagiinolang ide ta inesip de a eya ay libong a gebuswal. ");
INSERT INTO due_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ta ide ay pinangilabutan a pesan nun eya ay kinta de misan ay nagsurut a tambing dide i Hisus ta sinabi na, “Wet kamo matakut ta patibongin yu i innawa yu ta ako yo a i Hisus.” ");
INSERT INTO due_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ta eya ay sinumakoy pala nunde bengka ta tinumimok di un palos kanya ide ay nagtaka di a masakut. ");
INSERT INTO due_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ta mahena pa i pagpanulusun de diya ta an de pa katinggesan i kapangyedihan na nun nagpahanga eya ni tinapay. ");
INSERT INTO due_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nun pagkasabusabu de nunde dipa ay dinumatong ide de sákup ni Genesaret ta dinong de un bengka. ");
INSERT INTO due_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nano ay pagkalusong de de bengka ay tambing a inabuyenan eya ni manga agta. ");
INSERT INTO due_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kanya pan tambing de a pinabereta de kaagtaan de pulupalebut. Pati i pesan a te orom ay inadde de diya de pig-eden de ta misan deno i Hisus paagow ay maginon i peyedi de. ");
INSERT INTO due_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta be dinumatong eya de benwaan, de beriyu o de binaloybeloy ay peadde de i te manga orom misan de palingki a kasagkaden na. Ta ide ay geaged diya a patapáin na ide misan de rimong la ni bedu na ta i pesan pan a tinumapá ay pinumiyon a talage. ");
INSERT INTO due_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nano ay nun te linumane de Hisus a tipide a Pariseo pati magtutodu ide ni Hudyo a inumapo de Herusalem ");
INSERT INTO due_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ay kinta de i tipide a mag-aadel ni Hisus a gepinagpangan, a an nag-uges ni kumot de a nappaayun de ugeli de. ");
INSERT INTO due_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ta i Hudyo ide, a namas pa i Pariseo ide ay an ide námangan hanggen an ide nakapeuges ni kumot ta geabut ide de ugeli ni kaapoapohan de ide. ");
INSERT INTO due_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pati am pala ide gepangan ni misan ano a geapo de palingki hanggen an de ougesan. Pati makmuk pa a kaugelian ni Hudyo ide i peabut de a magi pag-uges pala de pig-inoman ide pati oniden a tangso pati pantabu ide. ");
INSERT INTO due_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kanya tinanto i Hisus ni manga Pariseo ide pati magtutodu ide ni Hudyo a magioyo, “Bekot pan ta an geabut i mag-aadel yu ide de ugeli ni kaapoapohan tam ide. Ta gepangan ide ni tinapay a an ide geuges ni kumot de.” ");
INSERT INTO due_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kanya ide ay tinubeg ni Hisus a magioyo, “Matud ngani i hinola ni Isais a tungkul dikamo ta pesabi yu kon a an yud peyedi i malot misan ay peyedi yu mangan la. Ta sinabi ni Makedepat, ‘I oyo ide a kaagtaan ay gegelang deko de nguso de la misan an te paggelang a matud de innawa de. ");
INSERT INTO due_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kanya i pagpodi de deko ay an te kabuluhan ta i pagtodu de ay geapo la de agta, a an geapo deko a magi pesabi de.’ ” ");
INSERT INTO due_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sinabi pala ni Hisus, “I pagdodul ni Makedepat ay pepaeyenan yu ni kabuluhan ta geabut kamo de sadisadi a ugeli ni manga agta ide.” ");
INSERT INTO due_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pati sinabi pa dide ni Hisus, “Makepapadean kamo a gepaeyen ni kabuluhan ni pagdodul ide nun Makedepat tangani geabut kamo la de ugeli ide ni manga agta. ");
INSERT INTO due_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ta pinasabi ni Makedepat de Moises a, ‘Gelangin mo i ama pati ina mo ta i magsurut ni malot de ama pati ina na ay depat a malibun.’ ");
INSERT INTO due_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Misan pan ay petodu yu a be pesabi ni agta de kamoddenan na a, ‘Anok di te natatabeng dikamo ta i pesan ko a adi ay pinangako ko di de Makedepat.’ ");
INSERT INTO due_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ta de maginon ay an yu di pabiyaan a getabeng i manga agta de kamoddenan de ide. ");
INSERT INTO due_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ta peeyenan yu ni kabuluhan i surut nun Makedepat dehil de pag-abut yu de ugeli yu a Hudyo ta makmuk pa a maginon ide i peyedi yu a petodu pala de mangának yu.” ");
INSERT INTO due_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dingan pinalane a liwet ni Hisus i kaagtaan ta sinabi na dide, “Patalikngan yu a pesan ta esipin yu i sasabi ko i. ");
INSERT INTO due_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","An i gesilong de nguso ni agta i gepakapagpadiplot diya de pekita ni Makedepat ta i gebulwag pan de nguso na. ");
INSERT INTO due_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nano i misan ino a gepatalikngoy ay depat a tumalinga.” ");
INSERT INTO due_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Misan ay nun winalat ni Hisus un kaagtaan ta sinumilong eya de beloy ay tinanto eya ni mag-aadel na ide a tungkul de inon a halimbewa. ");
INSERT INTO due_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kanya sinabi na dide a magioyo, “Pati ikamo mangani ay ang kamo pa te katinggesan? An yu man katinggesan a anoman a gesilong a pápangan de agta ay an nakapepadiplot diya? ");
INSERT INTO due_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ta an gesilong de innawa na ta tuloy la de tiyen a bobut na la.” Ta de surut a inon ay sinabi ni Hisus a i pesan pápangan ay malenis. ");
INSERT INTO due_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ta sinabi na a tuloy, “Misan i gebulwag de innawa ni agta ay inon ngani i gepakapagpadiplot diya de pekita ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ta de innawa na pan geapo i mammalotin a esip, panlalaki, pammahuna, pagpakialam de bebi ni kakmukan, pagpannakow, pamuno, ");
INSERT INTO due_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pagkasinna, paglolong, pagdeya, pagyedi a kauluamamos, pagpintas de kakmukan ta ide i mademut pati migmayabeng a an te katinggesan. ");
INSERT INTO due_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","I pesan a inon ay geapo de innawa ni agta ta ide i gepakapagpadiplot de agta ide.” ");
INSERT INTO due_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nano ay tinumotul i Hisus duman a kinumang de sákup ni benwaan a Tiro pati Sidon. Ta eya ay sinumilong de isin a beloy duman ta an na tebe buot a katinggesan ni misan ino a eya ay duman di misan ay kinatinggesan pala eya. ");
INSERT INTO due_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ta pagdetong na ay nabereta pan eya ni isin a mahuna a te anak ni untik a te libong de lawes na. Kanya tambing eya a kinumang de Hisus a linumuhud de kasagkaden na. ");
INSERT INTO due_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","I mahuna pan a oyo ay Griego i surut na ta pinanganak de sákup ni Siropenisia. Ta inaged na a mapelit de Hisus a palayuin na i libong de lawes ni anak na. ");
INSERT INTO due_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Misan ay sinabi diya ni Hisus, “Kaelangan a pakebiyag ngani i manga Hudyo a magi mangának dingan pa i manga an Hudyo a magi manga tito ta an depat a i pápangan ni mangának ay wewitik de manga tito.” ");
INSERT INTO due_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tinumubeg un mahuna, “Matud ngan non, Panginoon, misan ay i manga tito pan ide ay gepangan de selong ni pigpanganan ni mumu a nagkadegdeg.” ");
INSERT INTO due_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kanya sinabi diya ni Hisus, “Dehil de inon a tubeg mo deko ay umuli ka di ta winalat di nun libong un anak mo.” ");
INSERT INTO due_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kanya inumuli un mahuna ta dinatongan na i anak na a nappaide de pig-idean na ay winalat dingani nun libong. ");
INSERT INTO due_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pag-apo ni Hisus de sákup ni benwaan a Tiro ay sinumila eya de benwaan a Sidon pati de sákup ni Dikapolis a paagow nunde uluataben a Galilea. ");
INSERT INTO due_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Misan ay inadde de diya i isin a lalaki a bingol a bunol pa ta inaged de diya a tapáin na ni kumot na i agta a inon. ");
INSERT INTO due_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ta eya ay inikag pan ni Hisus de alayu a untik de kamakmokan ta sinuksuk na i guramut na de talinga na dingan binugen na i gurumut na ta tinapá na i dila ni bunol. ");
INSERT INTO due_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ta dingan tinumingala i Hisus de langot a inuminnawa ni hanga ta sinabi na de agta, “Epata” a te kabuluhan a, “Makaikna ka.” ");
INSERT INTO due_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dingan nakaikna dingani ta eya ay nakapagsurut pa ni malinow. ");
INSERT INTO due_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Misan ay pinagsabian ni Hisus i agta ide a wet de sasabia misan dino a sinumapit a oyo. Misan ay an ide nasablow ta namas de a binareta de kaagtaan. ");
INSERT INTO due_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kanya nagtaka ide a masakut ta sinabi de a magioyo, “Talage i pesan a yinadi na ay piyon a masakut ta te kaya eya a gepapiyon de bingol pati bunol ide.” ");
INSERT INTO due_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nano ay nun makasila i tipide a adow ay liwet a natipun i kaagtaan a makmuk ta naubus di i pápangan de. Kanya pan pinalane ni Hisus un mag-aadel na ide ta sinabi na dide, ");
INSERT INTO due_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nagkakalbi ok de manga agta ide a oyo ta tiluwon di a adow a kakoloy ko ide ta an di ide te pápangan. ");
INSERT INTO due_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Talage a be pouli ko ide a nagketigengin ay makati malinog ide de bektas ta alayu pam pa i beloy ni kakmukan dide.” ");
INSERT INTO due_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta tinubeg eya ni mag-aadel na ide, “Deno kitam pan nangamit ni tinapay a nosukul de magioyo a kamakmuk a agta ta ilang yo a lugel.” ");
INSERT INTO due_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nano ay tinanto ide ni Hisus, “Pide man i tinapay yu dena?” “Pito la.” Inon i tubeg de. ");
INSERT INTO due_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dingan pinalipa ni Hisus i kaagtaan de putok. Ta inamit na i pito a tinapay ta pagkapagpasalamat na de Makedepat ay pinisangpisang na inon ide. Ta binoy na de mag-aadel na ide tangani buluboy de de manga agta ide. ");
INSERT INTO due_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Te duman pala ide a tipide a untekin a ikan ta nun makapagpasalamat de Makedepat ay dinodul na ide a buluboy de pala de manga agta ide. ");
INSERT INTO due_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nakapangan i pesan a sukul. Ta nun tinipun de un an de naubus a kulukapisang ay nakapino ide ni pito a gelálan. ");
INSERT INTO due_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Te duman a manga apat a lebu a agta a namangan. ");
INSERT INTO due_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dingan pinatotul ni Hisus i manga agta ta tambing pan eya pati mag-aadel na ide ay sinumakoy de bengka a paagow de sákup ni Dalmanuta. ");
INSERT INTO due_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nano ay dinumatong i tipide a Pariseo a nakipagtalo de Hisus ta nag-aged ide diya a magpakita eya ni gepakataka a gepo de langot, a gepamatud de kapangyedihan na misan ay pedeya de la eya. ");
INSERT INTO due_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kanya napainnawa eya ni hanga a te gengsa ni untik ta sinabi na, “Bekot ta gelawag i manga agta de nano a panahon ni gepakataka? Talage ay pesabi ko dikamo a an pepakitaan ni misan ano a gepakataka i agta ide de nano a panahon.” ");
INSERT INTO due_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dingan winalat ide ni Hisus ta sinumakoy de bengka a sinumabusabu de dipa. ");
INSERT INTO due_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Misan ay nakalipat pan i mag-aadel ide ni tinapay ta isin la a tinapay i duman nunde bengka. ");
INSERT INTO due_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nano ay pinagsabian ide ni Hisus ta sinabi na, “Mag-engat kamo pati umelag de pahelab ni Pariseo ide pati Herod.” ");
INSERT INTO due_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kanya nasurutsurotan i mag-aadel na ide ta sinabi de, “Kanya na non sinabi ay ang kitam te adde a tinapay a sukul.” ");
INSERT INTO due_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Misan ay katinggesan pan ni Hisus i pasurutsurotan de kanya sinabi na dide, “Bekot ta nasurutsurotan kamo a ang kamo te adde a tinapay a sukul? An yu pa man peabuyenan o katinggesan i kapangyedihan ko? Maksa pa man i innawa yu?” ");
INSERT INTO due_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ta sinabi na a tuloy, “Ang kamo mangan te manga mata pati talinga tangani peabuyenan yu pati katinggesan. Wet yu kelipatan, ");
INSERT INTO due_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","a pinisangpisang ko i lima a tinapay para de lima a lebu a agta. Pide man a gelálan i napino yu nun an naubus ide?” Tinubeg de, “Sangpuwu pati aduwa.” ");
INSERT INTO due_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Pati wet yu kelipatan a pinisangpisang ko i pito a tinapay para de apat a lebu a agta. Pide man a gelálan i napino yu nun an naubus ide.” “Pito a gelálan.” Inon i tubeg de diya. ");
INSERT INTO due_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ta dingan sinabi na dide, “An yu pa katinggesan mangani?” ");
INSERT INTO due_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nano ay dinumatong ide Hisus de Betsaida ta inadde de Hisus ni tipide a agta i isin a bulag ta inaged de a papiyonin na. ");
INSERT INTO due_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kanya binolan ni Hisus de kumot na ta kinabit na a pabulwag de benwaan. Ta nun binugen na i mata na ay tinapá na dingan eya ay tinanto ni Hisus, “Te pekita ka man a misan ano?” ");
INSERT INTO due_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dingan nagelawag un lalaki ta sinabi na, “Te pekita ok a manga agta a gepinagtotul misan ay magi kew la ide.” ");
INSERT INTO due_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Misan ay liwet a tinapá ni Hisus i mata nun bulag ta dingan nun eya ay nagelawag ay kinta na di a malinow. ");
INSERT INTO due_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Dingan eya ay pinauli di ni Hisus ta sinabi na, “Wet ka di sumila pa de benwaan.” ");
INSERT INTO due_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nano ay kinumang ide Hisus pati mag-aadel na ide de bulubenwaan a sákup ni Sesarea Pilepos ta nun ide ay getotul pa ay tinanto ide ni Hisus a magioyo, “Ino ok kon pesabi ni kaagtaan?” ");
INSERT INTO due_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dingan tinumubeg ide diya, “I pesabi ni tipide ay i Huwen kamo a Maglilenod. I kakmukan pan ay pesabi de a ikamo ay i Elias pati te duman pa a gesabi a ikamo kon ay isin de magsasabi ide a den.” ");
INSERT INTO due_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Dingan tinanto na ide, “Ikamo pan ay ano i nasasabi yu tungkul deko? Ino ok?” Ta tinumubeg i Pedro, “Ikamo ay i Kristo a Pinangako nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Dingan sinabi dide ni Hisus a mahigpit a, “Wet yu sasabia misan dinoti ino ok ngani.” ");
INSERT INTO due_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nano ay te gepo di a nagtodu i Hisus de mag-aadel na ide a depat a eya a Pineta nun Makedepat a napa ni agta ay magtiis ni makmuk a kahedepan ta eya ay kakapoyen ni pinakamatande ide, ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo. Ta eya ay pobuno de a tuloy misan ay pakeedup eya a liwet de katiluwon a adow. ");
INSERT INTO due_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sinabi na yo a matallang dide misan ay inakit eya ni Pedro de alayu a untik ta sinabi na a, “Wet tebe non mangyedi dikamo kapide man.” ");
INSERT INTO due_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Misan ay sinumagkad i Hisus de mag-aadel na ide ta dingan sinosol na i Pedro, “Lumayu ka, Satanas, de alane ko i ta i peesip mo ay an inumapo de Makedepat ta de agta la.” ");
INSERT INTO due_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nano ay pinalane ni Hisus diya i manga agta pati mag-aadel na ide ta sinabi na dide, “I misan ino a te buot a nappa ni mag-aadel ko ay depat a kapoyen na ngona i kabuotan na a sadili ta depat a magtiis ni kahedepan a kosa na a innawa a magi ako dingan geabut pala de ugeli ko. ");
INSERT INTO due_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta i te buot a gealage de edup na dio de putok i ay neeyenan ninon misan ay i geboy ni edup na para deko pati de pagsabi pala ni piyon a bereta ay eya ngani i gekaduman ni edup a bowon.” ");
INSERT INTO due_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pati sinabi na pala, “Talage a an te pakinabeng a matud i misan ino a agta a te adi ni pesan dio de putok i, a am pan te duman a edup a bowon. ");
INSERT INTO due_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ta an te misan ano a nappatud a bebeyed ni agta de inon a edup a bowon. ");
INSERT INTO due_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nano ay be te duman a agta a pagkamamos i pagpamatud na a tungkul deko pati de pagtodu ko de kasagkaden ni kaagtaan a makikkakasalanan de nano a panahon ay dingan eya ay kammamos ko pala a Pineta nun Makedepat a napa ni agta paglusong ko a te gepakaingap ni Ama ko, a te kakoloy ok pala ni manga anghel na ide.” ");
INSERT INTO due_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pati sinabi na pa dide, “Talage ay pesabi ko dikamo a te duman dikamo a an nelibun hanggen an de kekita i paggepo ni kapangyedihan a masakut ni Makedepat de innawa ni agta.” ");
INSERT INTO due_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagkatakig ni anim a adow ay i inikag la ni Hisus ay i Pedro, magwele a Santiago pati Huwen ta sinumakat ide de isin a maditas a kalasan. Nun ide ay duman di ay kinta de a nagkobowon di a masampat i Hisus. ");
INSERT INTO due_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ta gepakaingap di i bedu ide ni Hisus ta napa ni malapsay di a masakut ta misan deno de putok i ay an te nakapepalapsay ni maginon. ");
INSERT INTO due_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dingan loktat di a kinta ni tiluwon a mag-aadel i Moises pati Elias a magsasabi ide a den a gepakisurut de Hisus. ");
INSERT INTO due_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dingan sinabi ni Pedro de Hisus, “Panginoon, yadi pa ay dio kitam di ta geyedi kami ni tiluwon a pigpilongan, isin dikamo, isin de Moises pati isin pala de Elias.” ");
INSERT INTO due_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Misan ay dehil de takut de ay an kinatinggesan ni Pedro i sinabi na. ");
INSERT INTO due_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dingan kinumalinongan dide i kunom. Ta te inumapo duman a surut a magioyo, “I oyo i Anak ko a pebuot kanya magtalinga kamo diya.” ");
INSERT INTO due_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Misan ay tambing a nagelawag i mag-aadel ide de pulupalebut de ay an di ide te kinta a kakoloy duman ti an i Hisus dila. ");
INSERT INTO due_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nano nun ide ay gedolug di nunde kalasan ay mahigpit a sinabi dide ni Hisus, “Wet yu sasabia misan dino i kinta yu hanggen an nagkeedup a liwet i ako a Pineta nun Makedepat a napa ni agta.” ");
INSERT INTO due_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kanya an de ngani sinabi misan dino i sinumapit a inon. Misan ay natulutantoan ide a ti ano i buot na a sasabi de liwet na a pagkaedup. ");
INSERT INTO due_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Dingan tinanto de i Hisus a magioyo, “Ti ano ta pesabi ni magtutodu ide ni Hudyo a depat ngona a nádetong i Elias a magsasabi a den dingan pa i Kristo.” ");
INSERT INTO due_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Dingan tinumubeg eya dide, “Talage ay pesabi ni kasulatan a nádetong ngani i Elias a tagibu tangani handein na i pesan para de Kristo. Ta pesabi pala ni kasulatan a tungkul deko a Pineta nun Makedepat a napa ni agta a lelibek ok pati pepahedepan. ");
INSERT INTO due_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Misan ay pesabi ko dikamo a nakadetong di i Elias a i Huwen a Maglilenod. Ta magi pesabi pala ni kasulatan ay yinadi ni manga agta i malot diya a nappaayun de buot de.” ");
INSERT INTO due_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nun pag-ampulang de de nawalat ide a mag-aadel ay kinta de i makmuk a masakut a manga agta a naddepulupalebut ni nawalat ide ta nagpakipagtalo dide i magtutodu ide ni Hudyo. ");
INSERT INTO due_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Naloktat un kaagtaan pagkakita de de Hisus ta ide ay pagikan a linumane diya ta sinabi de, “Dio kamo mangani.” ");
INSERT INTO due_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nano ay tinanto ide ni Hisus a magioyo, “Ano man i petinaloan yu?” ");
INSERT INTO due_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Misan ay tinumubeg i isin de manga agta a magioyo, “Magtutodu, inikag ko dikamo i anak ko a lalaki a te libong de lawes na a gepabunol diya. ");
INSERT INTO due_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ta be te kapangyedihan i libong de lawes na ay nagkaddegmak pati geburak i nguso na dingan gearatengot i ngipon na ta nagkopugtusan pa. Misan ay nun inaged ko de mag-aadel yu ide a palayuin de un libong ay an de napalayu.” ");
INSERT INTO due_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta tinumubeg i Hisus dide, “Ikamo a kaagtaan de nano a panahon ay am pa te pagpanulusun. Hanggen kapide ok man depat a kakoloy yu a getiyage dikamo.” Dingan sinabi na de lalaki, “Addein yu dio un anak yu.” ");
INSERT INTO due_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ta inadde ngani duman un anak. Nano nun nakitan di nun libong i Hisus ay loktat a pinaporewos nun libong un anak a masakut ta eya ay nadegmak de putok pati napabulidbulid, geburak i nguso na. ");
INSERT INTO due_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tinanto ni Hisus i ama ni anak, “Kapide pa man te libong i anak a oyo?” Tinumubeg un ama na, “Hanggen nun untik pa a anak ");
INSERT INTO due_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ta ugnay pan eya a pewitik nun libong de apoy pati de libtong a orat tangani bunoin. Misan ay be te nayeyedi kamo ay kalbian pati tabengan yu ikami.” ");
INSERT INTO due_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Misan ay sinabi ni Hisus, “Wet yu sasabi, ‘Be te nayeyedi,’ ta te nayeyedi be te pagpanulusun la.” ");
INSERT INTO due_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Misan ay tambing dila a tinumubeg ni malagdu i ama nun anak, “Ako ay gepanulusun misan ay tatabengan ok yu tangani wet pahena i pagpanulusun ko.” ");
INSERT INTO due_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nano ay nun kitain ni Hisus i giddinatong a makmuk a masakut a manga agta ay dinodul na i libong, “Ikaw a libong a gepabunol de anak na pati gepabingol ay pedodul ko ikaw a lumayu de lawes na, a wet ka di náampulang a liwet diya.” ");
INSERT INTO due_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ta inumolang ni malagdu un libong ta pinaporewos na pan di un anak dingan linumayu un libong. Ta un anak pan ay magi nalibun di a matud kanya sinabi ni kamakmokan duman a, “Talage a nalibun di.” ");
INSERT INTO due_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Misan ay binolan eya ni Hisus de kumot na a pinagiyos na ta dingan inumuddi a tuloy un anak. ");
INSERT INTO due_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nun sinumilong ide Hisus nunde beloy ay tinanto eya ni mag-aadel na ide de an te geikna a kakmukan a magioyo, “Ano pan ta am mi napalayu un libong?” ");
INSERT INTO due_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tinumubeg i Hisus dide, “I oyo a kalase a libong ay an napalayu be an te pagpanalangin pati an pamangan ni untik a panahon.” ");
INSERT INTO due_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nano ay tinumotul ide duman ta sinumila ide de Galilea misan ay an buot ni Hisus a ketinggesan yo ni manga agta. ");
INSERT INTO due_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ta tinoduan ni Hisus i mag-aadel na ide a sinabi na, “I ako a Pineta nun Makedepat a napa ni agta ay padekop nunde manga agta, a bobuno a tuloy misan ay de katiluwon a adow ay pakeedup ok a liwet.” ");
INSERT INTO due_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Misan ay an de kinatinggesan i buot na a sasabi ta nagkatakut pan ide a getanto diya. ");
INSERT INTO due_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nano ay dinumatong ide de Kapernam ta nun ide ay naddebeloy di ay tinanto ni Hisus i mag-aadel na ide, “Ano i patulutantoan yu de bektas na?” ");
INSERT INTO due_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Misan ay an ide nakayamyam ta i petinaloan de ay ti ino dide i namas pa a nappa ni pinakamaditas. ");
INSERT INTO due_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kanya linumipa i Hisus dingan pinalane na un sangpuwu pati aduwa ta sinabi na dide a magioyo, “I misan ino a te buot a nappa ni tagibu ay depat pan a nappa ni inapóan ni pesan a getabeng pala.” ");
INSERT INTO due_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nano ay pinalane ni Hisus i isin a untik a anak ta pinauddi na de kasagkaden de ta dingan sinapni na a sinabi na dide, ");
INSERT INTO due_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Pesabi ko dikamo a i misan ino a getanggep a piyon dehil deko ni magi anak a oyo a te masidong a innawa ay ako ngani i petanggep na pati pan i getanggep deko ay petanggep na pala i nagdodul deko.” ");
INSERT INTO due_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nano ay sinabi diya ni Huwen a magioyo, “Magtutodu, te duman kami a kinta a isin a agta a nagpalayu ni libong de lawes ni agta gepo de makapangyedihan a ngalan yu misan ay sinablow mi eya a wet magyedi ni maginon ta an tam pan eya kakoloy.” ");
INSERT INTO due_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Misan ay tinubeg ni Hisus, “Wet yu eya sablowa ta an nappatud a i isin a agta a nagyedi de makapangyedihan a ngalan ko ni gepakataka ay gesurut a tambing deko a malot. ");
INSERT INTO due_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ta i misan ino a an tam kapagebuk ay kakoloy tam. ");
INSERT INTO due_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pati i misan ino a magboy dikamo ni isin a beso a orat dehil de ikamo ay gepanulusun deko a Kristo ay pesabi ko dikamo a getanggep ngan eya ni bilos na a nagkaddepat. ");
INSERT INTO due_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Nano ay tungkul pan de misan ino a gepapagkasala de am pa náloy a gepanulusun deko ay yadi pa ngona a inon a agta ay gipotan de bong na ni hanga a beto a degdegin eya de ditow a atab. ");
INSERT INTO due_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nano be i kumot mo i gepapagkasala dikaw ay depat a pugtusin mo a butin mo di. Ta yadi pa a isin dila i kumot mo a nakesilong ka pan de kataanan ni Makedepat, a an magi aduwa i kumot mo a nappaduman ka pan de impiyerno a an nagkapalong. ");
INSERT INTO due_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ta duman ay getiis i manga agta ni an te kalog a kahedepan. ");
INSERT INTO due_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nano be i singit mo pan i gepapagkasala dikaw ay pugtusin mo pala. Ta yadi pa a isin dila i singit mo a nakesilong ka pan de kataanan ni Makedepat, a an magi aduwa i singit mo a nappaduman ka pan de impiyerno. ");
INSERT INTO due_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ta duman ay getiis i manga agta ni an te kalog a kahedepan. ");
INSERT INTO due_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nano pan be i mata mo i gepapagkasala dikaw ay lugitin mo. Ta yadi pa a isin dila i mata mo a nakesilong ka pan de kataanan ni Makedepat, a an magi aduwa i mata mo a nappaduman ka pan de impiyerno. ");
INSERT INTO due_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ta duman ay getiis i manga agta ni an te kalog a kahedepan.” ");
INSERT INTO due_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sinabi ni Hisus a tuloy, “Misan ikamo a gepanulusun de Makedepat ay depat a nabbukud para diya de padean ni kahedepan a magi apoy a nádetong dikamo. ");
INSERT INTO due_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Te halage ngani a magi asin i pagpanulusun yu de Makedepat misan ay be nappa ni mahena i pagpanulusun yu a magi asin a naeyen i alat na ay talage a an di te kabuluhan. Kanya magpanulusun kamo a tuloy, a te piyon a ugeli de sulusadile yu.” ");
INSERT INTO due_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Dingan tinumotul i Hisus duman a paagow de kaginglan a sákup ni Hudia a tinumuloy pala de dipa ni Horden. Ta kinatipunan eya a liwet ni kaagtaan kanya eya ay nagtodu dide a nappaayun de ugeli na. ");
INSERT INTO due_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Te duman pan a manga Pariseo a linumane diya ta eya ay pedeya de la de padean ni tanto a magioyo, “Nappaayun man de pagdodul a kumiblag i lalaki de bebi na?” ");
INSERT INTO due_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tinumubeg i Hisus, “Ano i winalat dikamo ni Moises a pagdodul?” ");
INSERT INTO due_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kanya tinumubeg pala ide, “Pinabiyaan ni Moises a kumiblag i lalaki de bebi na be bebiyen na ni kasulatan a ide ay nagkiblag di dingan ngona eya ay kumiblag di de mahuna.” ");
INSERT INTO due_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Misan ay sinabi ni Hisus dide, “Ay-o ta maksa i innawa yu kanya na yinadi i pagdodul a inon. ");
INSERT INTO due_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Misan ay gepo pa nun yinadi ni Makedepat i pesan ay yinadi na i lalaki pati mahuna a gebebian ide a tuloy. ");
INSERT INTO due_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Dehil de inon ay depat a i lalaki ay wawalat na i kamoddenan na ide a nakikoloy de bebi na. ");
INSERT INTO due_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ta ide a aduwa ay napa ni isin a lawes. Kanya ide ay an di aduwa ta isin di la. ");
INSERT INTO due_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pati i pinapagkoloy ni Makedepat ay wet pepapagkiblag ni agta la.” ");
INSERT INTO due_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nano ay pagdetong de de beloy ay tinanto eya ni mag-aadel na ide ni tungkul de pesan a inon. ");
INSERT INTO due_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kanya sinabi na dide a, “Be kekiblagen ni lalaki i bebi na a gebebi a liwet i lalaki ay te kasalanan a pagpakialam inon a lalaki. ");
INSERT INTO due_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Maginon pala be kekiblagen ni mahuna i bebi na a gebebi a liwet i mahuna ay te kasalanan pala a pagpakialam inon a mahuna.” ");
INSERT INTO due_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nano ay te nangadde pan de Hisus ni mangának de a gepinag-aged diya a tapáin na ide misan ay sinablow pan ni mag-aadel na ide i kaagtaan. ");
INSERT INTO due_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ta nagbulas i Hisus nun matinggesan na ta sinabi na a magioyo, “Pabiyaan yu a lumane deko i mangának ta wet yu ide sablowa ta katinggesan yu a de kapadepade de a te masidong a innawa te kapangyedihan i Makedepat. ");
INSERT INTO due_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Talage ay pesabi ko dikamo a be i misan ino ay an gepakasidong ni innawa na a magi anak ay an nappatud a te kapangyedihan i Makedepat de innawa na, a nakesilong pala de kataanan na.” ");
INSERT INTO due_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dingan sinapni na un mangának pati tinapá na ide ni kumot na ta pinakalbian na ide de Makedepat. ");
INSERT INTO due_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nano ay nun pagtotul di ide Hisus ay te isin a lalaki a maparipari a linumane diya a linumuhud de kasagkaden na ta nagtanto a magioyo, “Piyon a Magtutodu, ano man i depat ko a yeyedi tangani magkaduman ok ni edup a an te kalog?” ");
INSERT INTO due_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tinumubeg i Hisus, “Ano man i dehilan ta inolangan ok mo ni piyon ta am pan te piyon ti an i Makedepat la. ");
INSERT INTO due_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Misan ay katinggesan mo pan di i pagdodul ide a, ‘Wet ka nomuno, wet ka nekialam de bebi ni kakmukan, wet ka nannanakow, wet ka gebutil de pagpamatud mo, wet ka pala nandedeya pati gelangin mo i kamoddenan mo ide.’” ");
INSERT INTO due_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Misan ay tinubeg nun lalaki, “Magtutodu, tinumalinga ok di de pesan a inon gepo nun geulittaw ok pa hanggen nano.” ");
INSERT INTO due_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Dingan pinakalawag eya ni Hisus a te pagbuot ta sinabi na diya, “Te duman ka pa a an nagkayeyedi kanya tumotul ka a panggetangin mo di i pesan mo a adi ta boyin mo de mahedepin i kapanggetangan na ta dingan gekaduman ka ni kayamanan de langot. Pagkatapos ninon ay umabut ka deko.” ");
INSERT INTO due_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nano ay pagkaikna na ninon ay naisin di i mukha na ta tinumotul di a malungkut un lalaki ta eya ay mayaman a masakut. ");
INSERT INTO due_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dingan pinagelawag ni Hisus i nadepalebut na ide ta sinabi na de mag-aadel na ide, “Talage ngani a mahedep a te kapangyedihan i Makedepat de agta a geasa la de yaman na.” ");
INSERT INTO due_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kanya nagtaka ide de sinabi na a inon misan ay sinabi a liwet ni Hisus dide, “Mangának, talage ngani a mahedep a te kapangyedihan i Makedepat de innawa ni agta a geasa la de yaman na. ");
INSERT INTO due_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ta be an nappatud a nesilong i hayup a kamelyo de bulsut ni kadeyum ay namas pa a an nappatud a te kapangyedihan i Makedepat de innawa ni agta a geasa la de yaman na.” ");
INSERT INTO due_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Misan ay namas di a nagtaka i mag-aadel na ide kanya tinanto de eya, “Be maginon ay ino pan i nalligtas?” ");
INSERT INTO due_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dingan pinagelawag ide ni Hisus ta sinabi na dide, “Talage a an nappatud a leligtas ni agta i sadile de misan ay nappatud a nanleligtas i Makedepat ta te kaya eya a nanyeyedi ni misan ano a buot na.” ");
INSERT INTO due_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dingan sinabi diya ni Pedro, “Pagelawagin yu ta winalat mi i pesan, a inumabut kami la dikamo.” ");
INSERT INTO due_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kanya ide ay tinubeg ni Hisus, “Talage ay pesabi ko dikao a i misan ino a getiis a walatin na i beloy na, mangának, manga kabinsa, kamoddenan pati kaengin na dehil deko pati de piyon a bereta ");
INSERT INTO due_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ay tatanggep na ngani de nano a panahon i makmuk a beloy, kabinsa, kamoddenan, mangának, pati kaengin a te kakoloy a pagpahedep ta de nádetong pan a panahon ay te duman eya ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nano ay te duman a naona a nagkáinapóan te náinapóan pan a nagkapáona.” ");
INSERT INTO due_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nano ay ide ay nadebektas pa a paagow de Herusalem. Naona dide i Hisus misan ay i mag-aadel na ide ay nagipinagtaka dehil de paagow ide de kapagebuk na ide. I kaagtaan pan a nappaabut diya ay nagkatakut. Misan ay binukud ni Hisus i sangpuwu pati aduwa ta dingan sinabi na dide i pesan a nangyeyedi diya. ");
INSERT INTO due_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ta sinabi na, “Patalikngan yu ta násakat kitam di de Herusalem ta ako a Pineta nun Makedepat a napa ni agta ay padekop de manga ponu ide ni maghahandug ide pati de magtutodu ide ni Hudyo ta ako ay hahatolan de ni kalebunan. Ta ako ay boboy de de an Hudyo ide ");
INSERT INTO due_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","a lelibek, bobugen, paapdisan pati bobuno a tuloy. Misan ay de katiluwon a adow ay pakeedup ok a liwet.” ");
INSERT INTO due_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nano ay linumane de Hisus ide Santiago pati Huwen a mangának ni Sebedeo ta sinabi de, “Magtutodu, buot mi a masakut a boyin yu dikami i aaged mi dikamo.” ");
INSERT INTO due_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ay tinubeg ide ni Hisus, “Ano man i buot yu a yeyedi ko para dikamo?” ");
INSERT INTO due_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tinumubeg ide, “Tumalinga kamo tebe dikami a ikami ay makalipa de awenan pati awile yupagdetong ni panahon a ikamo ay te kapangyedihan de pesan.” ");
INSERT INTO due_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Misan ay tinubeg ide ni Hisus, “An yu ngani katinggesan i peaged yu na. Nakapetiis kamo man di ni kahedepan a tetiis ko pati ikamo man ay nakapepalinod de paglinod a kalebunan a nádetong deko?” ");
INSERT INTO due_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ay-o nakapetiis kami ngani.” Misan ay sinabi dide ni Hisus, “I tetiis ko a mahedep ay tetiis yu ngani pati i paglinod a nappadeko ay nappadikamo pala ");
INSERT INTO due_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","misan ay an ako i nakapesabi ni ti ino i nelipa de awenan pati de awile ko ta i piglipaan ide a inon ay para de pinaghande ide ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nun iknain yo nun sangpuwu a mag-aadel ay nagengsa ide de Santiago pati Huwen. ");
INSERT INTO due_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanya pinalane ide ni Hisus ta sinabi na dide, “Katinggesan yu di a i an Hudyo ide a hari ay gesákup ide a mahigpit de nasasakopan de ta i te manga kapangyedihan ide ay petalingaan ngani ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Misan ay wet tebe maginon i nappa ni ugeli yu ta depat a i misan ino dikamo a te buot a nappa ni pinakamaditas dikamo a pesan ay nappa ni katabeng yu nano. ");
INSERT INTO due_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ta i misan ino a te buot a nappa ni te kapangyedihan pa dikamo a pesan ay depat pan a nappa ni alepin ni pesan. ");
INSERT INTO due_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ta ako a Pineta nun Makedepat a napa ni agta ay anok dinumio tangani tabengan ok ta dinumio ok a de pesan, a boboy ko a tuloy i edup ko a pantobus de kamakmokan.” ");
INSERT INTO due_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nano ay dinumatong i Hisus pati mag-aadel na ide de benwaan a Heriko. Ta nun ide pati makmuk pa a manga agta ay getotul duman ay te nasilan ide a isin a bulag a gelipa de kaginglan nun bektas a gepalimus eya ta i ngalan na ay Bartimeo a anak ni Timeo. ");
INSERT INTO due_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nano ay nun inikna na a duman i Hisus a tage Nasarit ay inumolang eya a magioyo, “Hisus kamo a apo ni Debid, makalbi kamo deko.” ");
INSERT INTO due_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Misan ay sinablow eya ni kaagtaan tangani tumimok eya misan ay namas na pangani a pinalagdu i pag-olang na a sinabi, “Apo ni Debid, makalbi kamo tebe deko.” ");
INSERT INTO due_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kanya tinumimok i Hisus de pagtotul na ta sinabi na, “Pakangin yu eya dio.” Ta pinakangan de ngani un bulag ta sinabi de diya, “Patibongin mo i innawa mo ta pepakangan na ikaw.” ");
INSERT INTO due_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dingan winarasik na i kulapyaw na a ginumikan a kinumang de Hisus. ");
INSERT INTO due_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Pagdetong na duman ay tinanto eya ni Hisus, “Ano man i buot mo a yeyedi ko dikaw?” Tinumubeg un bulag, “Panginoon, buot ko tebe a nakakkita di.” ");
INSERT INTO due_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Dingan sinabi na de bulag, “Tumotul ka di ta pinapiyon ka di dehil de pagpanulusun mo deko.” Ta nun nanon pala a tambing ay nakakita di un bulag ta eya ay inumabut dila de Hisus. ");
INSERT INTO due_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nano ay palane ide Hisus de Herusalem ay dinumatong ide de karipakip ni Kalasan a Olibo a alane ni benwaan a Betpag pati Betania. Dingan pinapaona ni Hisus i aduwa a mag-aadel na, ");
INSERT INTO due_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ta sinabi na dide, “Kumang kamo de nosunud a beriyu ta de pagsilong yu la duman ay kekita yu a naggipot i am pa matande a asno, a am pa pesakoyen ni misan ino a agta ta ukasan yu a uweyin dio. ");
INSERT INTO due_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ta be te nagtanto dikamo a, ‘Ti ano ta peukasan yu?’ Ay sabiin yu a, ‘Kaelangan yo ni Panginoon misan ay paampulang na pan la a tambing.’” ");
INSERT INTO due_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dingan tinumotul ngani ide ta kinta de i am pa matande a asno a naggipot de kaginglan ni bektas a alane ni pintohan ni isin a beloy. Nano nun peukas de un hayup ay ");
INSERT INTO due_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tinanto ngani ide ni tipide a nappauddi duman, “Ano pan ta peukas yu nay?” ");
INSERT INTO due_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Misan ay tinumubeg ide a magi tinutugun dide ni Panginoon. Kanya pinabiyaan ide a nakatotul. ");
INSERT INTO due_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nano ay inuwey de ngani de Hisus un hayup ta dingan dinasa de i kulapyaw de de idog nun hayup ta sinumakoy i Hisus. ");
INSERT INTO due_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Misan ay makmuk dila i nagdesa ni kulapyaw de de bektas a sesilan na ta i kakmukan pan ay nangamit de bukod ni sanga ni kew a makiagid ta inon pala i dinasa de a paggelang de diya. ");
INSERT INTO due_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dingan nagiinolang i kaagtaan a naona diya pati nàinapóan ta sinabi de, “Salamat de Pinakamaditas. Podiin eya a gedetong a te kapangyedihan ni Panginoon a Makedepat. ");
INSERT INTO due_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Podiin tam i Pineta nun Makedepat a te nádetong a kapangyedihan dio de putok i a magi kapangyedihan ni kaapoapohan tam a Debid. Salamat de Pinakamaditas.” ");
INSERT INTO due_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nano ay sinumilong i Hisus de Herusalem pati de beloy a pighandogen de Makedepat. Pagkatapos a pinagelawag na i pesan duman ay binumulwag ta inumampulang de Betania a kakoloy na un sangpuwu pati aduwa ta abi di nun nanon. ");
INSERT INTO due_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nun kinábiabian ay pag-apo de de Betania ay natigeng i Hisus. ");
INSERT INTO due_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Misan ay nasayed na de an alayu a masakut i isin a gemut a igos a makiagid ta dingan linanean na. Ta pinagelawag na ti te nattide a anak misan ay angani kinumita ni anak na ta agid na la ta am pa panahon a tig-anak. ");
INSERT INTO due_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ta sinabi na de igos, “Gepo nano ay an di te nakapangan pa ni anak mo magpakapide man.” Ta inon ay inikna ni mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pagdetong de de Herusalem ay sinumilong i Hisus de beloy a pighandogen de Makedepat ta pinangalow na i pesan a magpapanggetang pati manggegetang de beloy a inon. Ta pinulupaobbob na i manga lamesa ide ni maglelewes ide ni kuwarta pati piglipaan ni magpapanggetang ide ni manga kalapati. ");
INSERT INTO due_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta sinabi na a an nappatud a nesila de beloy a pighandogen i misan ino a te manga adde. ");
INSERT INTO due_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Pati tinoduan na i manga agta a sinabi na, “Pesabi ni kasulatan a, ‘I beloy ko ay talage a pigpanalanginan la ni pesan a tage bensa misan ay peyedi yu pan a pigtaanan ni tulisan ide.’” ");
INSERT INTO due_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Misan ay inikna pan ni tipide a ponu ni maghahandug ide pati magtutodu ide ni Hudyo i sinabi na a inon. Kanya gepo nun nanon ay linawag de i pagkakataon a mapabuno de i Hisus misan ay nagkatakut ide ta nagpanulusun a nagtaka i manga agta ide de pagtodu na. ");
INSERT INTO due_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ta be abi ay binumulwag pan ide Hisus de benwaan. ");
INSERT INTO due_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nun kinábiabian di a pagsila de ay kinta de ngani a narango di un igos gepo de ramut na hanggen de lawis na. ");
INSERT INTO due_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Misan ay naisepan pan ni Pedro i sinabi ni Hisus de inon a kew kanya sinabi na de Hisus, “Magtutodu, pagelawagin yu ta narango di un igos a sinumpa yu.” ");
INSERT INTO due_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nano ay tinubeg ide ni Hisus, “Depat a magpanulusun kamo de Makedepat. ");
INSERT INTO due_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Talage ay pesabi ko dikamo a be i misan ino ay gepanulusun a nangyeyedi i peaged na de Makedepat a an pala te aduwa a esip ay misan sabiin na de kalasan na i a ‘Umalis ka de atab to,’ ay talage a yeyedi ni Makedepat a nangyeyedi ngani i sinabi na para diya. ");
INSERT INTO due_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kanya pesabi ko dikamo a misan ano i agedin yu de pagpanalangin yu, a te pagpanulusun a gekaduman kamo ninon ay talage ngani a tatanggep yu. ");
INSERT INTO due_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Misan ay be ikamo ay nanalangin ay patáwadin yu ngona i belang nagkasala dikamo tangani patáwadin pala ni Ama a Makedepat de langot i mammalotin yu. ");
INSERT INTO due_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Misan ay be ang kamo gepatáwad de belang nagkasala dikamo ay ang kamo pala patáwad ni Ama yu a Makedepat de langot ni mammalotin yu.” ");
INSERT INTO due_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nano ay dinumatong pan di ide a liwet de Herusalem ta nun getotul i Hisus de beloy a pighandogen de Makedepat ay linumane diya i ponu ide ni maghahandug ide, i magtutodu ide ni Hudyo pati pinakamatande ide, ");
INSERT INTO due_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","a nagtanto diya, “Ano man i kapangyedihan mo a nagyedi ni maginon pati ino i nagboy dikaw ni kapangyedihan a inon?” ");
INSERT INTO due_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Misan ay tinumubeg dide i Hisus, “Tatanto ko pala ikamo ni pakosa ta be notubeg yu i tanto ko ay dingan sasabi ko dikamo ti ano i kapangyedihan ko a geyedi ni pesan a inon. ");
INSERT INTO due_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Deno pala inumapo i kapangyedihan ni Huwen a Maglilenod a gelinod ni agta? De Makedepat man o de agta la? Tubegen ok yu.” ");
INSERT INTO due_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dingan ide ay nasurutsurotan, “Be sasabi tam a ‘De Makedepat,’ ay sasabi na pan a ‘Bekot ta an yu tinalingaan.’ ");
INSERT INTO due_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Misan ay be sasabi tam a ‘De agta la,’ ay makati ti ano i yediin dikitam ni manga agta ta peabuyenan de a i Huwen ay magsasabi ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kanya sinabi de de Hisus, “Am mi katinggesan.” Sinabi pala dide ni Hisus a, “Be maginon ay ang ko sasabi dikamo ti ino i nagboy deko ni kapangyedihan a geyedi ni pesan a inon.” ");
INSERT INTO due_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nano ay ginumapo i Hisus a gesurut de kaagtaan de padean ni halimbewa a oyo ta sinabi na, “Te duman a isin a agta a nagpatanom ni lanut a obes de pigtanoman na ta dingan pinabekoden na ta pati nagpayedi eya duman ni pigpisaan nun obes pati nagpauddi eya ni maditas a pigbentayen. Ta pagkatapos ninon ay winalat na de taohan na ide ta eya ay kinumang de kakmukan a bensa. ");
INSERT INTO due_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ta nun dinumatong di i panahon a pagpisa nun obes ay pinakang nun te adi nun obes i katabeng na de taohan ide tangani amitin na i kabinsa na. ");
INSERT INTO due_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Misan ay binolan nun taohan ide un dinodul ta binalbel de dingan pinatotul a an te adde ni misan ano. ");
INSERT INTO due_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nano ay nagpakang pa a liwet ni isin pa a katabeng na ta tinopras de i ulo na a yinadian ni an te gelang. ");
INSERT INTO due_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ay nagdodul pa a liwet ni isin pa a katabeng na misan ay binuno de ngani. Kanya maginon dila i yinadi de de kakmukan pa a katabeng, te binalbel pati binuno ide. ");
INSERT INTO due_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nano ay isin dila i nagkattide a depat na a dodul a i anak nadla a pebuot. Ta eya i inapóan a pinakang na ta sinabi na de sadile na, ‘Gegelang de di i anak ko.’ ");
INSERT INTO due_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Misan ay pagdetong na duman ay nasurutsurotan i taohan ide a magioyo, ‘Iwina i gemana ni pigtanoman i. Hale di ta bunoin tam tangani mapadikitam di i mamana na.’ ");
INSERT INTO due_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ta binolan de ngani a binuno de a tuloy dingan binut de de ditow ni pigtanoman.” ");
INSERT INTO due_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nano ay tinanto ni Hisus i kaagtaan ide, “Ano man i yeyedi ni te adi ni pigtanoman de taohan na ide? Talage a noduman i te adi ta popuksa na inon ide a taohan dingan pataanan na de kakmukan un pigtanoman a inon. ");
INSERT INTO due_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","An yu pa man nagkabesa i pesabi ni Makedepat de kasulatan? ‘I beto a kinapoyen ngona ni magyeyedi ide ni beloy ay eya pan i namas pa a pinakamahalage a beto de iwina a yinadi a beloy. ");
INSERT INTO due_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Inon i yinadi ni Panginoon a Makedepat kanya de pekita tam ay masampat a masakut.’” ");
INSERT INTO due_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dingan i Hisus ay dedekop tebe ni te kapangyedihan ide a Hudyo ta kinatinggesan de a ide i pesabian na de halimbewa a inon. Misan ay nagkatakut pan ide de manga agta kanya an de eya dinakop ta tinumotul ide. ");
INSERT INTO due_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ta pinakang de de Hisus i tipide a Pariseo pati i kakmukan a mangáyun ni Herod a maamit de i mali de surut na tangani hahabla de eya. ");
INSERT INTO due_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kanya ide ay linumane diya ta sinabi de, “Magtutodu, katinggesan mi a ikamo ay gesurut la ni kamatoden ta getodu kamo a nappaayun de kabuotan ni Makedepat pati ang kamo te pepeta a agta ta padepade i pesan a agta de pekita yu. Kanya nagkaddepat man de pagdodul ide a gebeyed kami ni buwis o eyen de Hari a Kaditasan de Roma?” ");
INSERT INTO due_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Misan ay katinggesan ni Hisus a ide ay gedeya la kanya sinabi na dide, “Bekot ta pedeya ok yu? Dio yu i kuwarta a pelak a pambuwis ta pillawag ko.” ");
INSERT INTO due_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ta biniyen de ngani dingan tinanto na ide, “Dino man a leterato pati ngalan i nappa dio de pelak i?” Tinumubeg ide, “De Hari a Kaditasan de Roma.” ");
INSERT INTO due_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kanya sinabi na dide, “Be maginon ay boyin yu de Hari a Kaditasan i para diya ta boyin yu pala de Makedepat i para diya.” Kanya ide ay nagtaka ngani a masakut diya. ");
INSERT INTO due_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Te duman pala a tipide a Saduseo a linumane de Hisus ta ide ay an gepanulusun a pakeedup a liwet i nalibunin. ");
INSERT INTO due_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ta sinabi de a magioyo, “Magtutodu, nagsolat i Moises ni pagdodul a para dikitam a, ‘Be nalibun i isin a lalaki ta nawalat na a an te anak i bebi na ay depat a gepakasal i wele na a lalaki de belo a mahuna tangani magkaanak ide para de nalibun.’ ");
INSERT INTO due_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ta nano ay te duman a pito a magiwinale a manga lalaki. Ay nagbebi un kaka de misan ay nalibun eya a an nagkaanak. ");
INSERT INTO due_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Misan ay nagpakasal pan un káduwa de belo a mahuna ta nalibun pala a am pa nagkaanak. Maginon pala i nangyedi de katiluwon. ");
INSERT INTO due_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ta ide a pito ay napa ni bebi nun mahuna a an ide nagkaanak. Ay de inapóan ay nalibun pala un mahuna. ");
INSERT INTO due_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nano ay ino dide i nappa ni bebi nun mahuna be te pagkaedup a liwet ta i pito pan ay napa ni bebi na dio?” ");
INSERT INTO due_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tinubeg ide ni Hisus, “Mali kamo a masakut ta an yu katinggesan i kasulatan nun Makedepat pati kapangyedihan na. ");
INSERT INTO due_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ta de pagkaedup a liwet ni nalibunin ay i manga agta ay an gebebi o gepabebi ta ide ay nappa ni magi manga anghel di de langot. ");
INSERT INTO due_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tungkul pan de liwet a pagkaedup ni nalibunin ay an yu pa man nagkabbesa de kasulatan ni Moises a tungkul de masidong a kew a gedilab ta duman ay sinabi ni Makedepat de Moises a, ‘Ako i Makedepat a pepodian pa ni Abraham, Isak pati Hakob.’ ");
INSERT INTO due_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pati katinggesan tam ngani a i Makedepat ay an Makedepat ni nalibunin ta ni nàedupin la. Talage a mali kamo a masakut.” ");
INSERT INTO due_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nano ay inikna pan ni isin a magtutodu ni Hudyo i pagtalo de ta kinatinggesan na a matud a pesan i manga tubeg ni Hisus de manga katalo na ide. Kanya eya ay linumane diya a nagtanto a magioyo, “I deno man i talage a pinakamahalage a pagdodul?” ");
INSERT INTO due_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Dingan tinumubeg i Hisus, “I oyo i pinakamahalage de pesan, ‘Patalikngan yu a manga Hudyo. I Panginoon tam la a Makedepat i Panginoon a isin la. ");
INSERT INTO due_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ta depat a buotin yu i Panginoon a Makedepat a pepodian yu ni pesan a innawa, edup, esip pati tibong yu.’ ");
INSERT INTO due_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ta i káduwa pan a mahalage ay i oyo, ‘Ay depat a buotin yu i kapadepade yu a agta ni magi pagbuot yu de sadile yu.’ Ta an di te mahalage pa de oyo ide a pagdodul.” ");
INSERT INTO due_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kanya sinabi nun magtutodu ni Hudyo, “Talage a matud kamo a masakut, magtutodu, a isin la i Makedepat ta an di te kakmukan pa ta eya dila. ");
INSERT INTO due_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Talage ay i pagbuot diya ni matud de innawa, esip pati tibong tam pati pan i pagbuot de kapadepade tam a agta ni magi pagbuot tam de sadile tam ay mahalage pangani de mangadde kitam ni handug a sosunug pati kakmukan pa a manga handug.” ");
INSERT INTO due_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nano ay nun natinggesan ni Hisus a naketingges i kasurut na ay sinabi na diya, “An naaloy ay te kapangyedihan di i Makedepat de innawa mo.” Ta gepo nun nanon ay an di te nagtanto pa de Hisus. ");
INSERT INTO due_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nano ay nun nagtodu i Hisus de beloy a pighandogen de Makedepat ay sinabi na, “Ano ta pesabi ni magtutodu ide ni Hudyo a i Kristo kon a Pinangako nun Makedepat ay apo ni Debid a Hari tam a den? ");
INSERT INTO due_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Misan pan ay naghola i Debid nun te kapangyedihan diya i Ispiritu nun Makedepat ta sinabi na, ‘Sinabi ni Panginoon a Makedepat de Panginoon ko, Lumipa ka de awenan ko a te kapangyedihan, ta padeog ko dikaw i kapagebuk mo ide.’ ");
INSERT INTO due_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kanya be pengalanan ni Debid i Kristo a ‘Panginoon ko’ ay papalano man a napa ni apo ni Debid i Kristo?” Nano ay nagpatalikngoy a te salig i manga agta ide de Hisus. ");
INSERT INTO due_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","De pagtodu na ay sinabi na, “Mag-engat kamo de ugeli ni magtutodu ide ni Hudyo a gemayabeng a getotul a nappabedu ni anduwonin ta buot de a betiin ide ni gekita ide dide de kulukarsade. ");
INSERT INTO due_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ta i buot de pala ay i manga hinande a piglipaan de pigmitengan ide pati de hinande ide a pigpanganan. ");
INSERT INTO due_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pati gepanalangin pala ide ni anduwon tangani esipin ni agta a ide ay te piyon a ugeli misan ay peubus de pan la i keedup ni mahunain ide a belo. Kanya namas pa a mabiyet i nádetong a podusa dide.” ");
INSERT INTO due_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nano ay linumipa i Hisus de tipong ni pigpuoyen ni handug a kuwarta duman de beloy a pighandogen de Makedepat. Ta pinagelawag na i manga agta a gehandug ni kuwarta ta makmuk a mayamanin i naghandug ni hangain a halage. ");
INSERT INTO due_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Misan ay linumane pan i isin a mahuna a belo a mahedep a naghandug ni aduwa la a pera ta i kapadepade ninon ay isin la a sentimos. ");
INSERT INTO due_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kanya inolangan ni Hisus i mag-aadel na ide ta sinabi na dide, “Pesabi ko dikamo a inon a hinandug ni belo a mahedep ay namas pa a mahalage de makmuk a hinandug ni mayamanin ide. ");
INSERT INTO due_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ta i mayamanin ide ay naghandug ni subra la de kaelangan de misan ay i hinandug ni mahuna a inon a mahedep ay kadu dila ni keedup na.” ");
INSERT INTO due_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nano nun ide Hisus ay binumulwag de beloy a pighandogen de Makedepat ay sinabi diya ni isin a mag-aadel na a, “Magtutodu, pagelawagin yu ta masampatin i beto a ginamit de masampat a oyo a beloy.” ");
INSERT INTO due_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Misan eya ay tinubeg ni Hisus, “Pekita mo ngani nano i hanga a oyo a beloy misan ay de nádetong a adow ay an te nattide dena a beto a nappulupatongan ta neregen a pesan.” ");
INSERT INTO due_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nun gelipa i Hisus de Kalasan a Olibo de tipong ni beloy a pighandogen de Makedepat ay tinanto eya ni Pedro, Santiago, Huwen pati Andres de an te geikna a kakmukan. ");
INSERT INTO due_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kapide man nangyeyedi i sinabi yu a inon pati ano i nappa ni tande be mandeli di a nádetong i pesan a oyo?” ");
INSERT INTO due_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ay tinubeg ide ni Hisus, “Mag-engat kamo tangani wet kamo nadedeya ni misan ino a agta. ");
INSERT INTO due_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ta makmuk i nádetong a gesabi a ide i Kristo ta makmuk ngani i nadedeya de. ");
INSERT INTO due_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nakàikna kamo ni gelaben pati bereta tungkul de laben de alayu. Ay wet kamo matakut ta depat ngona a mangyedi i oyo ide a pesan misan ay am pa i kalog ni panahon. ");
INSERT INTO due_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ta i bensa a isin ay nekilaben de isin pala a bensa ta nekilaben pala i hari ide de kakmukan a hari. Te duman pala a nádetong a tigtegeng pati noyogyog de misan deno a lugel. Ta inon ide ay gepo la ni kahedepan a nádetong. ");
INSERT INTO due_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Misan ay handein yu i innawa yu ta te duman a nomoy dikamo de pighatolan. Ta lalapdit de ikamo de pigmitengan de ide pati dehil de pagpanulusan yu deko ay pasagkad de ikamo de manga gubernador ide pati de manga hari ide ta ikamo ay gepamatud de kasagkaden de. ");
INSERT INTO due_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Misan ay depat ngona a gesabi ni piyon a bereta de pesan a kaagtaan dingan nádetong di i kalog. ");
INSERT INTO due_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nano be ikamo ay dinakop de di, a binoy de pighatolan ay wet kamo magulo i esip yu a ti ano i sasabi yu ta de odes a inon ay boboy dikamo i sasabi yu ta an ikamo i gesurut ta i Ispiritu nun Makedepat i aapoán ni surut yu. ");
INSERT INTO due_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nano ay padekop ni isin a agta i kabinsa na a pobunu na. Maginon pala i yeyedi ni ama de anak na ta i anak pan ay gelaben de kamoddenan na a pobunu na ide. ");
INSERT INTO due_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pati kagengsaan kamo ni pesan dehil de pagpanulusun yu deko misan ay i getiyage de pagpanulusun na hanggen de kalog ay nalligtas ngani. ");
INSERT INTO due_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nano i oyo a sasabi ko di ay depat a esipin a masakut ni gebesa. Esipin yu be kekita yu a geuddi i gepakatakut a Gekapoy de Makedepat de an depat a kadumanan na ay depat a nelimok de kalasan i pesan a nappataan de lugel a Hudia. ");
INSERT INTO due_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kanya i naddekatobengan ni beloy na ay wet di nesilong a nangamit ni misan ano de beloy na. ");
INSERT INTO due_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pati i naddekaengin na ay wet di pala nouli a nangamit ni kulapyaw na. ");
INSERT INTO due_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kakulukalbi ngani i mabsuin pati gepinagpasusu de manga adow a inon. ");
INSERT INTO due_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ta magpanalangin kamo a i paglimok yu ay wet tebe de panahon a magidnaw. ");
INSERT INTO due_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ta de panahon a inon ay i kaagtaan ay te kahedepan a masakut a am pa tiniis ni misan ino gepo nun yinadi ni Makedepat i putok i pati be nakatakig di ay an di neliwet i maginon kapide man. ");
INSERT INTO due_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nano ay be an paantisik ni Panginoon a Makedepat i panahon a inon ay an di te nakeligtas misan ay dehil pan de manga pineta na ide ay paantisik na inon a panahon. ");
INSERT INTO due_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kanya ngani be te magsabi dikamo a, ‘Wiyo di i Kristo,’ o ‘Duman di,’ ay wet kamo manulusun. ");
INSERT INTO due_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ta talage a te giddinatong a Kristo a an matud pati magsasabi ide a an matud. Ta geyedi ide ni tande pati gepakataka a makmuk tangani nálalagelag de tebe i pineta ide ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kanya magipinag-engat kamo ta sinabi ko di dikamo a tagibu i pesan a oyo. ");
INSERT INTO due_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nano pagkatakig ni kahedepan a inon ay nodumos di i adow pati pan i bulan ay an di nátallang. ");
INSERT INTO due_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Pati nádegdeg di i manga butatala a gepo de langot. Ta i te kapangyedihan ide de longaw na ay neeyenan di ni kapangyedihan de. ");
INSERT INTO due_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dingan kekita ok de a Pineta nun Makedepat a napa ni agta a gelusong a nappa de kunom, a te kapangyedihan pati gepakaingap a masakut. ");
INSERT INTO due_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ta dododul ko i manga anghel tangani tipunin de i manga pineta ko de pesan a kadepit ni putok i pati langot. ");
INSERT INTO due_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nano ay uluesipin yu de pagtodu gepo de kew a igos ta i kew be geagid i manga sanga na ide ay katinggesan yu ngani a alane di i tig-adlas. ");
INSERT INTO due_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Maginon pala be kekita yu di i pesan a sinabi ko ay katinggesan yu di a alane di i panahon a pagdetong ko ta magi naddepintohan ok di. ");
INSERT INTO due_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Talage a matud ay pesabi ko dikamo a te duman a agta a gekita de gepo a gepakatakut a nangyeyedi a an nelibun hanggan an de kekita i inapóan a gepakatakut. ");
INSERT INTO due_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Talage a nesede di i putok i pati langot misan i surut ko ay angani neeyenan ni kabuluhan. ");
INSERT INTO due_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Misan i odes o adow ni pagdetong ko ay an te naketingges a misan ino, misan i anghel ide de langot, misan i ako a Anak ta i Ama la a Makedepat. ");
INSERT INTO due_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kanya magipinag-engat kamo a maghande a magpanalangin ta an yu pan katinggesan ti kapide yo nangyeyedi. ");
INSERT INTO due_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ta i oyo ay magi nangyeyedi be isin a agta ay tinumotul de alayu ta pabentayen na i beloy na de manga katabeng na ide a bebiyen na ide ni duludiya a pagyedi. Ta sasabi na de magbebentay de pintohan a depat a maghande a ugnay de pagdetong na. ");
INSERT INTO due_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Maginon pala ay depat a maghande kamo a ugnay ta an yu katinggesan i pagdetong ni te adi ni beloy ta makati de pagdumos na o de gitna ni abi o de mandeli a abiabi o de abiabi di. ");
INSERT INTO due_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ta makati madetongan na ikamo a loktat a kapulupede. ");
INSERT INTO due_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","I pesabi ko dikamo ay para de pesan a depat a magipinaghande a tuloy.” Inon i pagpatingges ni Hisus de mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nano ay aduwa dila a adow ay kaadowen di ni Paskuwa pati Tinapay a An Te Pahelab. I manga ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo ay napapag-esip ide ni pagkakataon a mapadekop de i Hisus de an katinggesan ni makmuk a mapabuno a tuloy. ");
INSERT INTO due_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Misan ay sinabi de, “Wet de kaadowen ta makati magulo a masakut i kaagtaan.” ");
INSERT INTO due_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nano ay nun duman ide Hisus de Betania de beloy ni Simon a nagkaketong a gepangan ay linumane diya i isin a mahuna a te adde ni isin a oniden a langis a mabengo a mahal i halage na. Te ngalan a nardo inon a langis. Dingan binisag na i oniden ta pinalisan na i ulo ni Hisus. ");
INSERT INTO due_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Misan ay nagbulas i tipide duman ta nasurutsurotan ide, “Bekot ta pekanugun i mabengo a iwina? ");
INSERT INTO due_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ta nappatud a panggetangin iwina ni manga aduwa a lebu a peso dingan boboy de mahedepin ide i kapanggetangan na.” Ta sinosol de un mahuna. ");
INSERT INTO due_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Misan ay sinabi ni Hisus dide, “Pabiyaan yu la eya a wet yu eya abelaa ta piyon i yinadi na a oyo deko. ");
INSERT INTO due_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ta naaloy yu pa a kakoloy i mahedepin ide ta misan kapide yu buot a magyedi dide ni piyon ay nappatud misan ay ako ay an yu naaloy a kakoloy dio. ");
INSERT INTO due_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nagyedi i mahuna a oyo hanggen de kaya na ta nano pa ay pinalisan na di i lawes ko ni mabengo a paghande de pagtapor deko. ");
INSERT INTO due_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Talage ay pesabi ko dikamo a deno man a te magsabi ni piyon a bereta ay sasabi pala i yinadi deko ni mahuna a oyo a pagkaesip diya.” ");
INSERT INTO due_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Dingan kinumang i Hodes a isin de sangpuwu pati aduwa de ponu ide ni maghahandug ide tangani mapadekop na i Hisus dide. ");
INSERT INTO due_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kanya nasalig ide nun inikna de inon ta nangako ide a bebiyen de ni kuwarta. Kanya gepo nun nanon ay napapag-esip di i Hodes ni pagkakataon a mapadekop na i Hisus. ");
INSERT INTO due_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nano ay dinumatong di i tagibu a adow ni Tinapay a an Te Pahelab ta inon pala i depat a adow a paghandug ni topa ide a pigpanganin para de Paskuwa. Ay tinanto ni mag-aadel ide i Hisus, “Deno i buot yu a gehande kami para dikamo ni pangapun a Paskuwa?” ");
INSERT INTO due_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dingan dinodul na i aduwa de mag-aadel na ide a tinutugunan na ide a magioyo, “Kumang kamo de Herusalem ta te nattagbu kamo a isin a lalaki a getabu ta diya kamo umabut ");
INSERT INTO due_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","misan deno nesilong a beloy. Ta tantoin yu de te adi ninon a beloy a, ‘Pesabi ni Magtutodu mi a ti deno a kuwarto nappatud a eya pati mag-aadel na ide ay námangan ni pangapun a Paskuwa?’ ");
INSERT INTO due_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ta totudu na dikamo i isin a hanga a kuwarto de ditas a te nappahande a gegemit yu ta duman kamo maghande para dikitam.” ");
INSERT INTO due_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dingan kinumang ngani de Herusalem i aduwa a magaadel na ta kinta de ngani i magi sinabi dide ni Hisus ta naghande ide ni pangapun a Paskuwa. ");
INSERT INTO due_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nun abi di ay dinumatong i Hisus pati sangpuwu pati aduwa. ");
INSERT INTO due_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Dingan nun ide ay gepangan di ay nagsurut i Hisus, “Talage ay pesabi ko dikamo a padekop ok ni isin dikamo a kasaló ko.” ");
INSERT INTO due_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nano ay nalungkut ide ta i belang isin dide ay nagtanto diya, “Ako man Panginoon?” ");
INSERT INTO due_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Misan ay tinumubeg eya, “Isin dikamo a kasabey ko a gedolo ni tinapay de mangkok na ay eya ngani i gepadekop deko. ");
INSERT INTO due_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ta ako a Pineta nun Makedepat a napa ni agta ay nelibun a magi sinabi ni kasulatan misan ay gepakatakut i násapit de agta a gepadekop deko ta piyon pa ngani tebe a an di eya pinanganak.” ");
INSERT INTO due_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ta nun ide ay gepangan di ay nangamit i Hisus ni tinapay ta nagpasalamat de Makedepat dingan pinisangpisang na a binuluboy na de mag-aadel na ide ta sinabi na, “Amitin yu a panganin ta lawes ko yo.” ");
INSERT INTO due_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dingan inamit na pala un pig-inoman ni tayug a malanis ta pagkapagpasalamat na de Makedepat ay binoy na dide ta inuminom ide a pesan. ");
INSERT INTO due_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Dingan sinabi ni Hisus, “I oyo a tayug a malanis ay gepamatud de bowon a pagpakikasungdu ni Makedepat a te katibeyen a i sagu ko a nobusbus para de makmuk. ");
INSERT INTO due_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Talage ay pesabi ko dikamo a anok di neinom a liwet ni tayug a malanis hanggen ang ko kasabey i pesan a gepanulusun, a neinom de kataanan ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ta pagkakanta de ni isin a pagpodi ay kinumang ide de Kalasan a Olibo. ");
INSERT INTO due_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pagdetong de ay sinabi dide ni Hisus, “Ay wawalat ok yu a pesan a magi pesabi ni Makedepat de kasulatan, ‘Bobuno ko i mag-aalage ni topa ide ta nákalat i topa ide.’ ");
INSERT INTO due_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Misan ay pagkatapos a pakeedup ok a liwet ay naona ok dikamo de Galilea.” ");
INSERT INTO due_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dingan sinabi ni Pedro diya, “Misan walatin kamo ni pesan ay ang ko ikamo wawalat.” ");
INSERT INTO due_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ay tinubeg eya ni Hisus, “Talage ay pesabi ko dikaw a ni abi pala a oyo ay dingan ngona nátaráok i manok ni pakáduwa ay pengeyen ok mo ni tiluwon a sila.” ");
INSERT INTO due_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Misan ay maksa a sinabi ni Pedro, “Misan malibun ok a kakoloy yu ay ang ko ikamo pengeyen.” Maginon pala i sinabi ni pesan a mag-aadel. ");
INSERT INTO due_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nano ay kinumang ide Hisus de isin a lugel a te ngalan a Getsemani ta sinabi na dide, “Magilinepa kamo ngona dio ta nanalangin ok de kadepit pa duman.” ");
INSERT INTO due_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Misan ay inikag na ide Pedro, Santiago pati Huwen ta te gepo a gehedep i innawa na a pepamalogpologen. ");
INSERT INTO due_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Dingan sinabi na dide, “Nano ay nagkolungkut ok a masakut a magi nelibun ok. Mag-ilat kamo dio a makipagpoyet deko.” ");
INSERT INTO due_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ta pagkalayu na dide ni untik ay linumuhud a nanalangin a be nappatud ay wet di nádetong diya i odes ni paghedep na. ");
INSERT INTO due_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Sinabi na de pagpanalangin na, “Ama ko, nappatud yu a yeyedi i misan ano kanya layuin yu tebe deko i tetiis ko a oyo misan ay wet nangyeyedi i kabuotan ko ta i kabuotan yu la.” ");
INSERT INTO due_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ay inumampulang i Hisus de mag-aadel na ide a tiluwon a kapulupede kanya sinabi na de Pedro, “Napede ka man Simon? Ang ka mangani nakapepoyet misan isin la a odes?” ");
INSERT INTO due_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kanya makipagpoyet kamo a magpanalangin tangani wet kamo notukso ta i kaleduwa ni agta ay nappahande a geabut de Makedepat misan ay i lawes ay mahena. ");
INSERT INTO due_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Dingan liwet eya ay linumayu a nanalangin ta i den na a peaged i pesabi na pala. ");
INSERT INTO due_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nano ay nun inumampulang eya a liwet dide ay dinatongan na ide a kapulupede pa ta ide ay petungka di a masakut pati an de katinggesan i totubeg de diya. ");
INSERT INTO due_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ta de katiluwon di a pag-ampulang na dide ay sinabi na, “Napede kamo pa man a gepaimloy? Sukul di non ta dinumatong di i odes a ako a Pineta nun Makedepat a napa ni agta ay padekop di de makikkakasalanan ide. ");
INSERT INTO due_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kanya umuddi kamo di ta magtul di ta wiyo di i agta a gepadekop deko.” ");
INSERT INTO due_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nun gesurut pa i Hisus ay dinumatong di i Hodes a isin de sangpuwu pati aduwa a te kakoloy ni makmuk a manga agta a te manga adde ni utak pati panopras. Ta ide ay inumapo de ponu ide ni maghahandug ide, de magtutodu ide ni Hudyo pati de pinakamatande ide. ");
INSERT INTO due_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Misan nun am pa ide gedetong duman ay binoy ni Hodes i magioyo a tande, “I angutan ko ay eya ngani i pelawag tam ta dekopin yu a tambing a ikagin misan ay wet pakabbutan.” ");
INSERT INTO due_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pagdetong ngani ni Hodes ay linumane dila a tambing de Hisus ta sinabi na, “Magtutodu.” Ta inangutan na. ");
INSERT INTO due_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dingan linanean i Hisus ni kaagtaan ide ta dinakop de. ");
INSERT INTO due_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Misan ay i isin a kakoloy ide ni Hisus ay nangugnus ni utak ta tinigbes na i isin a katabeng ni pinakaponu a maghahandug ta nasapsap i talinga na. ");
INSERT INTO due_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dingan sinabi ni Hisus de kaagtaan ide, “Anok tulisan. Bekot ta nagidinio kamo a te manga utak pati panopras a nanakop deko? ");
INSERT INTO due_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ta adow adow ay nagtodu ok de beloy a pighandogen de Makedepat a anok yu pan dinakop. Misan ay nangyedi i pesan a oyo tangani nammatud i pesabi ni kasulatan.” ");
INSERT INTO due_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pagkasabi na ninon ay nagiginikan i mag-aadel na ide ta winalat de eya a lallan. ");
INSERT INTO due_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nano ay te inumabut diya a isin a ulittaw a an te bedu de lawes na ti an natingosan ni demit a malapsay. Ta binolan de eya ");
INSERT INTO due_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","misan ay nawalat na un demit na a ginumikan dila a óbe. ");
INSERT INTO due_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nano ay inikag de i Hisus de beloy ni pinakaponu a maghahandug ta duman natipun i pesan a ponu ni maghahandug ide, pinakamatande ide pati magtutodu ide ni Hudyo. ");
INSERT INTO due_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","I Pedro pan ay inumabut de Hisus misan alayu la i pag-etan. Sinumilong pala eya de bekoran ni beloy nun pinakaponu a maghahandug ta linumipa de alane ni magbebentay ide a nanangdeng. ");
INSERT INTO due_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nano ay i ponu ide ni maghahandug ide pati pesan a kapolongan a pinakamatande ay naglawag ide ni agta a gesumbong tungkul de Hisus tangani mapabuno de eya. Talage a an ide te pekita a pagsumbong a te kabuluhan para dide. ");
INSERT INTO due_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Misan makmuk di i gesumbong ni kabutelan tungkul de Hisus ay an nagkaeisin i pagsumbong de. ");
INSERT INTO due_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nano ay de inapóan ay te duman pala a kakmukan a inumuddi a nagsumbong ni magioyo, ");
INSERT INTO due_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Inikna mi a sinabi ni oyo a agta a sesede na kon i oyo a beloy a pighandogen de Makedepat a yinadi ni agta. Ta yeyedi na pan la de tiluwon a adow i an yedi ni agta.” ");
INSERT INTO due_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Misan ay am pa nagkaeisin inon a pagsumbong de. ");
INSERT INTO due_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dingan inumuddi i pinakaponu a maghahandug de kasagkaden ni kapolongan ta tinanto na i Hisus, “Ang ka man te natotubeg de pagsumbong a inon dikaw?” ");
INSERT INTO due_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Misan ay an dila geyamyam i Hisus a unabis kanya eya ay tinanto a liwet ni pinakaponu a maghahandug a magioyo, “Sabiin mo dikami ti ikaw ngani i Anak nun Makedepat a i Kristo a Pinangako na?” ");
INSERT INTO due_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tinumubeg i Hisus, “Ako ngani ta kekita ok yu a Pineta nun Makedepat a napa ni agta a nelipa de awenan ni Makedepat a Makapangyedihan ta nádetong ok a nappa de kunom de longaw na.” ");
INSERT INTO due_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nano ay ginise ni pinakaponu a maghahandug i sadile na a bedu a tande a malot diya i sinabi ni Hisus ta sinabi na, “An tam di kaelangan i pagsumbong ni kakmukan ");
INSERT INTO due_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ta ikamo di a pesan i inumikna a eya ay an te gelang de Makedepat. Kanya nano ay ano i peesip yu tungkul diya?” Ay tinumubeg ide, “Ay depat eya a bunoin.” ");
INSERT INTO due_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dingan te gepo a pebugen eya ni kakmukan ta tinaklopan de i mata na a pesulusuntuk ta sinabi de diya, “Hale di, holaan mo ti ino i gesuntuk dikaw?” Ta eya ay petulutampal pala ni magbebentay ide. ");
INSERT INTO due_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nano ay i Pedro pan ay duman pangani nunde ditow a bekoran dingan linumane diya i isin a mahuna a katabeng ni pinakaponu a maghahandug. ");
INSERT INTO due_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ta nun kinta eya ni mahuna a gepanangdeng nunde apoy ay pinagelawag na a piyon ta sinabi na de Pedro, “Kasta kakoloy ka pala ni Hisus a iwina a tage Nasarit a sakup ni Galilea?” ");
INSERT INTO due_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Misan ay nangeyen i Pedro ta sinabi na, “Ang ko eya peabuyenan pati ang ko katinggesan i pesabi mo.” Ta dingan eya ay kinumang dingani nunde pintohan ni bekod ta tinumaráok pan i manok. ");
INSERT INTO due_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Misan ay kinta pan di eya ni isin pa a katabeng a mahuna duman ta sinabi na de manga lalaki duman; “I oyo a lalaki ay isin de kakoloy ide ni Hisus.” ");
INSERT INTO due_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Misan ay liwet a nangeyen i Pedro. Nun mulumaloy di ay sinabi pan de Pedro ni kauluuddi ide duman a “Talage a kasta isin ka pala ngani de kakoloy de ta tage Galilea ka pala.” ");
INSERT INTO due_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dingan sinumumpa di i Pedro ta sinabi na, “Talage a misan malibun ok ay ang ko peabuyenan i agta a iwina a pesabi yu.” ");
INSERT INTO due_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Dingan tambing a tinumaráok a liwet i manok kanya naisepan ni Pedro i sinabi diya ni Hisus a, “Dingan pa nátaráok i manok ni pakáduwa ay pengeyen ok mo ni pakatiluwon a sila.” Ta dingan nun naisepan na inon ay nagtangos a masakut. ");
INSERT INTO due_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nun kinábiabian di ay nasurutsurotan i ponu ide ni maghahandug ide, pinakamatande ide, magtutodu ide ni Hudyo pati kakmukan pa a kaagtaan de kapolongan ta pinagepus de i Hisus a inikag de Gubernador a Pilato. ");
INSERT INTO due_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ta eya ay tinanto ni Pilato, “Ikaw man i Hari ni Hudyo ide?” Dingan tinumubeg i Hisus, “Ikamo di i gesabi.” ");
INSERT INTO due_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Misan pan ay i ponu ide ni maghahandug ide ay pesumbong de i Hisus ni tulutiano. ");
INSERT INTO due_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kanya liwet a tinanto ni Pilato i Hisus, “Bekot ta ang ka getubeg dide? Ta peikna mo pan i makmuk a pagsumbong de a malot a tungkul dikaw.” ");
INSERT INTO due_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Misan ay an di tinumubeg i Hisus a unabis kanya nagtaka a masakut i Pilato. ");
INSERT INTO due_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nano ay be kaadowen ni Paskuwa ay te ugeli un gubernador a gepabulwag ni isin a nabbilanggo a nappaayun de buot ni kaagtaan ide. ");
INSERT INTO due_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nun nanon pan ay te isin a nabbilanggo a migbuno a te ngalan a Barabás a kakoloy ni manga linumaben ide de sundelo ide ni gubernador. ");
INSERT INTO due_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kanya nagilinane i kaagtaan de Pilato ta inaged de diya a magpabulwag di ni isin a nabbilanggo a nappaayun de ugeli na. ");
INSERT INTO due_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Dingan tinanto na ide, “Buot yu man a pabulwagen ko dikamo i Hari ni Hudyo ide?” ");
INSERT INTO due_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ta katinggesan pan ni Pilato a nagkasinna la i ponu ide ni maghahandug ide dehil de pagbuot ni kaagtaan de Hisus kanya inikag de i Hisus diya. ");
INSERT INTO due_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Misan ay i kaagtaan ay pinagsabian ni ponu ide ni maghahandug ide a i sabiin de ay i Barabás di i pabulwagen na. ");
INSERT INTO due_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kanya tinanto ide ni Pilato, “Be maginon ay ano man i yeyedi ko de agta a oyo a pengalanan yu a Hari ni Hudyo ide?” ");
INSERT INTO due_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Misan ay nagiinolang i kaagtaan a magioyo, “Pakuin eya de padipa.” ");
INSERT INTO due_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta tinanto na ide, “Bekot ta ano man i yinadi na a kasalanan?” Misan ay namas pa a nagiinolang ide, “Pakuin eya de padipa.” ");
INSERT INTO due_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nano dehil de buot ni Pilato a an magulo i kaagtaan ay pinabulway na i Barabás ta i Hisus pan ay pinalapdit na dingan binoy na dide tangani pakuin de de padipa. ");
INSERT INTO due_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ta i Hisus ay inikag nun sundelo ide de bekoran ni beloy ni gubernador a te ngalan a Pretoryo ta dingan tinipun de i mangáyun de a pesan a sundelo duman. ");
INSERT INTO due_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dingan kinulapyawen de i Hisus ni mulumaderag a magi kulapyaw ni hari a panlibek. Pati nagyedi ide ni suklong a tinik a sinuklong de diya. ");
INSERT INTO due_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ta binate de eya a panlibek a magioyo, “Maedup ka, Hari ni Hudyo ide.” ");
INSERT INTO due_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ta eya ay binugebugen de dingan inamit de i tangbu a linapdit de de ulo na dingan linumuhud ide diya a pelibek de la. ");
INSERT INTO due_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nun pagkatapos ni paglibek de diya ay inubedan de ni kulapyaw a mulumaderag ta binaduan de ni sadile na a bedu ta binulwag de tangani pakuin de de padipa. ");
INSERT INTO due_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","De pagtotul de ay natagbu de i isin a lalaki a napasila duman a inumapo de buluberiyu ta i ngalan na ay i Simon a tage Sirene a ama nide Alehandro pati Ropu. Ta pinelit de a pinapassan diya un padipa ni Hisus. ");
INSERT INTO due_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nano ay inikag de i Hisus de isin a lugel a te ngalan a Golgota a i kabuluhan na ay “Kaksan ni Ulo”. ");
INSERT INTO due_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ta dingan biniyen de i Hisus ni tayug a te kadugeng a bulong ni maapdis na de padipa misan ay an na ininom. ");
INSERT INTO due_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kanya pinaku de eya de padipa dingan nagsugel i sundelo ide a binulubinsa de belang isin dide un demit na. ");
INSERT INTO due_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nano ay nun pakuin de i Hisus ay manga siyam di ni abiabi. ");
INSERT INTO due_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta nassolat de diditas ni ulo ni Hisus i pagsumbong diya a magioyo, “Hari ni Hudyo ide.” ");
INSERT INTO due_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ay pinakuan de pala i aduwa a tulisan a kasabe na de padipa, isin de awenan na, isin pala de awile na. ");
INSERT INTO due_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","De maginon ay matud a talage i sinabi ni kasulatan a eya ay pinakidugeng de matud ide a te kasalanan. ");
INSERT INTO due_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ta i belang gesila ay gelibek diya a gepinagworog i ulo de ta sinabi de, “Aman la ikaw i nansesede ni beloy a pighandogen de Makedepat ta yeyedi mo a liwet de tiluwon la a adow? ");
INSERT INTO due_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kanya nano ay ligtasin mo i sadile mo ta lumusong ka di de padipa mo na.” ");
INSERT INTO due_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Maginon pala ay linibek eya ni manga ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo ta sinabi de de sulusadile de, “Te kaya eya a nanligtas ni kakmukan ay am pan te kaya a nanleligtas ni sadile na. ");
INSERT INTO due_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Aman la eya i Kristo a Pinangako nun Makedepat a Hari ni Hudyo ide? Talage a be nolusung eya de padipa na de pekita mi ay nonulusun kami diya.” Ta linibek pala eya ni kasabe na ide a pinaku de padipa. ");
INSERT INTO due_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nano ay dinumumos de pesan a putok nun manga udto di hanggen de apun a kadepit. ");
INSERT INTO due_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Dingan nun apun a kadepit ay inumolang i Hisus ni malagdu a magioyo, “Eli, Eli, lama sabaktani,” a i buot na a sasabi ay, “Makedepat ko, Makedepat ko, ano ta pinabiyaan ok yu?” ");
INSERT INTO due_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ta nun inikna pan non ni tipide a kauluuddi duman ay sinabi de, “Patalikngan yu ta peolangan na i Elias.” ");
INSERT INTO due_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ta te ginumikan a isin dide ta nangamit ni lumut a binasá na ni tayug a maapsut a ginipot na de tangbu dingan pinasopsop na de Hisus. Ta sinabi na, “Ilatin tam ngona ti nádetong i Elias tangani eya ay lusongin na de padipa.” ");
INSERT INTO due_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dingan inumolang i Hisus ni malagdu ta napugtusan di. ");
INSERT INTO due_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ta dingan nagisi un age a mokpal a sagbong a nasampay de beloy a pighandogen de Makedepat gepo de ditas hanggen de sidong. ");
INSERT INTO due_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kanya i geuddi de alane ni padipa a kapitan ni sundelo ide, nun kinta na i pagkalibun ni Hisus ay sinabi na, “Talage ngani a i agta a oyo ay Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Te duman pala a mahunain a napasayed gepo de alayu. I tipide dide ay i Maria Magdalena, Salome, pati Maria a ina nide Hose pati Santiago a an matande. ");
INSERT INTO due_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ta i mahunain a oyo ay sinumut di ide de Hisus a tinumabeng pala diya nun duman pa i Hisus de Galilea. Te duman pala i kakmukan pa a makmuk a mahunain a kakoloy ni Hisus nun ide ay gesakat de Herusalem. ");
INSERT INTO due_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nano inon a adow ay adow a paghande ta de kinábiabian di ay adow ni paimloy kanya nun mulumadumos di ");
INSERT INTO due_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ay dinumatong i Hose a tage Arimatea de Pilato ta inaged na a te matibong a innawa i bengkay ni Hisus. I Hose a pinakamatande ni Hudyo ay pegelang ni mangáyun na a pinakamatande. Ta geilat pala eya ni panahon a te kapangyedihan i Makedepat de innawa ni agta ide. ");
INSERT INTO due_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Misan pan ay nagtaka i Pilato nun inikna na a nalibun di i Hisus kanya pinaolangan na i kapitan ni sundelo ide ta tinanto na ti matud ngani a nalibun di eya. ");
INSERT INTO due_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nun matinggesan na de sinabi ni kapitan a nalibun dingani i Hisus ay pinabiyaan na a aamit ni Hose i bengkay na. ");
INSERT INTO due_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dingan nanggetang i Hose ni age a matebe ta nun malusong na i bengkay ni Hisus nunde padipa ay tiningos na de age a inon dingan pinuoy na de gob a táporan a yinadi de denpa. Ta pagkatapos ay pinabulidbulid na un beto a hanga a inabet na de gob. ");
INSERT INTO due_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Misan ay kinta ni Maria Magdalena pati Maria a ina ni Hose un gob a pinamuoyen de Hisus. ");
INSERT INTO due_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nano ay pagkatakig di ni adow ni paimloy ay ide Maria Magdalena, Salome, pati Maria a ina ni Santiago ay nanggetang ide ni mabengo a popunas de tebe de bengkay ni Hisus. ");
INSERT INTO due_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ta nun Simbe a abiabi a masakut a getanga di i adow ay dinumuman ide de táporan. ");
INSERT INTO due_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ta nun ide ay getotul pan de bektas ay sinabi de, “Ino man i pepapagbulidbulid tam nun beto a abet nun táporan?” ");
INSERT INTO due_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Misan ay pagkasayed de di nun táporan ay un beto a hanga a abet na ay nabulidbulid di. ");
INSERT INTO due_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ta pagsilong de nunde gob ay kinta de duman i isin a lalaki a an matande a gelipa de awenan a kadepit a nappabedu ni malapsay a anduwon ta nagkatakut i mahunain ide. ");
INSERT INTO due_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Misan ay sinabi ni lalaki dide, “Wet kamo matakut ta katinggesan ko a pelawag yu i Hisus a tage Nasarit a pinaku de padipa. Misan an di eya kadio ta pinakaedup di a liwet ta wina i pinamuoyen dila diya. ");
INSERT INTO due_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kanya tumotul kamo a sabiin yu de mag-aadel na ide a namas de Pedro a ‘I Hisus ay naona di dikamo de Galilea ta kekita yu eya duman a magi sinabi na dikamo.’” ");
INSERT INTO due_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kanya binumulwag ngani i mahunain ide de táporan a gegikan ta nagkelito i esip de a gepinagkinkin pati an ide nakapagsabi ni ano man misan dino de sinlan de ta nagkatakut ide. ");
INSERT INTO due_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nano ay nun pinakaedup di a liwet i Hisus a abiabi a maderam ni simbe ay nagpakita eya a tagibu de Maria Magdalena a pinalayuan na ni pito a libong de lawes na. ");
INSERT INTO due_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ta eya ay kinumang de mag-aadel ide ni Hisus a bebereta na i kinta na ta nun nanon ay nagkolungkut ide a masakut a gepinagtangos. ");
INSERT INTO due_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Misan ay nun binareta dide ni Maria a pinakaedup di i Hisus ta kinta na ay an ide nanulusun. ");
INSERT INTO due_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ta pagkatapos ninon ay nagpakita pala i Hisus de aduwa a mag-aadel na de pagtotul de a paagow de buluberiyu. ");
INSERT INTO due_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ta ide ay inumampulang de mangáyun de ta binareta de i kinta de misan ay am pala ide nanulusun. ");
INSERT INTO due_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ta dingan eya ay nagpakita de sangpuwu pati isin nun ide ay gepinagpangan. Ta sinosol na ide dehil de an ide gepanulusun diya pati dehil de maksa a innawa de ta an ide nagpanulusun de nakákita ide diya a pagkaedup na a liwet. ");
INSERT INTO due_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dingan sinabi na dide, “Kumang kamo de pesan a lugel a magsabi ni piyon a bereta de pesan a kaagtaan. ");
INSERT INTO due_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ta i misan ino a nonulusun pati lelinod ay nalligtas misan ay i an gepanulusun ay podusahan ngani. ");
INSERT INTO due_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ta i misan ino a gepanulusun deko ay te kakoloy a tande dehil de makapangyedihan a ngalan ko. Ta ide ay nakapepalayu ni libong ide pati ide ay gesurut ni surut a an de katinggesan. ");
INSERT INTO due_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Pati misan ide ay makabbol ni bebek o makainom ni lasun ay an ide te kahedepan. Pati nepiyon i te manga orom ide be tatapá de ni kumot de.” ");
INSERT INTO due_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nano ay pagkatapos a nagsabi dide i Panginoon a Hisus ay pinaditas eya de langot ta duman linumipa de awenan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ta i mag-aadel na ide ay kinumang a nagsabi ni piyon a bereta de pesan a lugel. Ta ide ay tinabengan pan ni Panginoon ta pinamatoden na i surut a pesabi de de padean ni manga tande a gepakataka a pinayedi na dide. Iwina i matud.");
INSERT INTO due_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ako a Lukas ay gesolat dikamo, Tiopilo, a pegelang ko ta makmuk di i nagsolat ni sinumapit dio de gitna mi a tungkul de Kristo. ");
INSERT INTO due_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ta i sinolat de ay i sinabi dikami ni manga tagibu ide a gepamatud, a te manga tungkolin a getodu ni surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kanya nano, Tiopilo, ay binuot ko pala a gesolat a tuloy dikamo ni oyo pagkatapos ko a nag-adel ni pesan a oyo hanggen nunde gepo. ");
INSERT INTO due_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ta gesolat ok ni oyo tangani matinggesan yu i kamatoden a petodu dikamo. ");
INSERT INTO due_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nun hari pa de sákup ni Hudia i Herod ay te duman pan nun panahon a inon a maghahandug de Makedepat a te ngalan a Sakarias. I Sakarias ay isin de mangápo ni Abias a maghahandug a den ni Makedepat. I bebi na pan a Elisabet ay apo pan ni Aron a maghahandug a tagibu. ");
INSERT INTO due_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ide ay piyon a masakut de pekita ni Panginon a Makedepat ta nagtalinga ide a matud de pesan a pagdodul na. ");
INSERT INTO due_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Misan ay an ide te anak ta i Elisabet ay an gekaanak pati matande di ide a padepade. ");
INSERT INTO due_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nano ay nun panahon di a getabeng i Sakarias a maghahandug pati mangáyun na a maghahandug pala de beloy a pighandogen de Makedepat ");
INSERT INTO due_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ay napeta i Sakarias a nappaayun de ugeli ni maghahandug ide a nesilong a gehandug ni pesunug a mabengo para de Panginoon de beloy na. ");
INSERT INTO due_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nun odes a pesunug di un mabengo ay duman pan un kaagtaan ide a geilat de katobengan a gepanalangin. ");
INSERT INTO due_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ay dingan loktat a te inumuddi a anghel ni Panginoon de awenan ni pighandogen a pesunugen na ni mabengo. ");
INSERT INTO due_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nano ay nun kitain eya ni Sakarias ay nagulo i esip na ta nagkaduman eya ni takut. ");
INSERT INTO due_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Misan ay sinabi nun anghel diya, “Sakarias, wet ka matakut ta inikna ni Makedepat i pagpanalangin yu kanya nánganak i Elisabet a bebi mo ni isin a lalaki ta ngangalanan mo eya a Huwen. ");
INSERT INTO due_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ta gekaduman kamo ni kasalegen a masakut ta i kamakmokan pala i násalig dehil de panganak de Huwen. ");
INSERT INTO due_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ta eya ay nappa ni te kapangyedihan de pekita ni Panginoon a Makedepat pati an eya neinom ni misan ano a tayug o alak a gepakabugnang. Ta gepo pa nun eya ay de tiyen pa nun ina na ay pino di eya ni Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ta be humanga di i Huwen ay paampulang na i makmuk a Hudyo ide de Panginoon de a Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ta i Huwen ay naona a mag-aatid ni Panginoon a te kapangyedihan ni Ispiritu nun Makedepat a magi Elias a magsasabi a den. Ta pepapagkasungdu na i ama pati anak ta pepakapiya na i esip ni an getalinga tangani nappa ni naketingges ide a geabut de Makedepat. Ta de maginon ay hahande na i kaagtaan a nappa ni mangának ni Panginoon de innawa de.” ");
INSERT INTO due_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dingan tinanto ni Sakarias de anghel, “Papalano man a ketinggesan ko a inon ay matud? Ta ikami pan a magkálaki ay matandein di.” ");
INSERT INTO due_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nano ay tinumubeg un anghel, “Ako ay i Gabriel a getabeng de Makedepat de kasagkaden na. Ay dinodul ok na dio a gesabi dikaw ni oyo a piyon a bereta a tungkul de Huwen a panganak ni bebi mo. ");
INSERT INTO due_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ta talage a i sinabi ko a oyo ay nangyeyedi de nádetong a panahon misan ay dehil de ang ka nanuluson de sinabi ko ay nobunol ka hanggen an gepangyedi i sinabi ko dikaw.” Inon i sinabi nun anghel. ");
INSERT INTO due_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nano ay i manga agta pan ide de katobengan a geilat de Sakarias ay geuluesip ti ano ta náloy eya de disalad ni beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nun pagbulwag na ay an dingani gepakasurut ta hinalimbewa na dide a bunol di kanya kinatinggesan de a pinagpakitáan eya ni anghel de disalad nun beloy a pighandogen. ");
INSERT INTO due_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nano ay pagkatapos ni Sakarias a yinadi i nappaayun de tungkolin na de beloy a pighandogen ay inumuli di eya. ");
INSERT INTO due_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Talage a an náloy ay naglihe ngani i Elisabet a bebi ni Sakarias dingan an eya binumulwag de beloy de ni lima a bulan. Ta dinainnawa na a, ");
INSERT INTO due_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Talage a pekalbian ok di ni Panginoon a Makedepat ta nano ay gelihe ok di kanya anok di nagkammamos de pekita ni manga agta.” Inon i naddeinnawa na. ");
INSERT INTO due_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nun kaanim di a bulan un kabsuan ni Elisabet ay pinakang pan di ni Makedepat i anghel a Gabriel de isin a benwaan a Nasarit a sákup ni Galilea. ");
INSERT INTO due_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ta duman i isin a maddikit a am pa nagkallanean ni lalaki. Misan ay kasungdu na di i isin a lalaki a te ngalan a Hose ta i kaapoapohan ni Hose ay i Debid a hari a den. I ngalan pan ni maddikit ay i Maria. ");
INSERT INTO due_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nano ay pagdetong nun anghel de Maria ay sinabi na, “Masalig ka ta gepakikaisin dikaw i Panginoon ta gekaduman ka ni kosa a tabeng na.” ");
INSERT INTO due_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dingan pagkaikna ni Maria de inon ay nagulo a masakut i esip na ta inuluesip na ti ano i kabuluhan ninon a sinabi. ");
INSERT INTO due_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kanya sinabi pa diya nun anghel, “Wet ka matakut, Maria, ta napadikaw dingani i kosa a tabeng ni Panginoon. ");
INSERT INTO due_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Magpatalikngoy ka ta gelihe ka a nánganak ni isin a lalaki ta eya ay ngangalanan mo a Hisus. ");
INSERT INTO due_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta eya ay nappa ni naketingges a te kapangyedihan de pesan pati pan oolangan eya a Anak nun Makedepat a Kaditasan de pesan. Ta boboy pala diya ni Panginoon a Makedepat i kapangyedihan ni kaapoapohan na a Debid. ");
INSERT INTO due_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Talage ngani a i Hudyo ide ay sasakopan na a an te kalog.” ");
INSERT INTO due_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nano ay tinanto pan ni Maria de anghel, “Papalano man non a nangyeyedi ta anok pam pa nagkallanean ni lalaki?” ");
INSERT INTO due_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Dingan tinubeg eya nun anghel a magioyo, “Nolusong dikaw i Ispiritu nun Makedepat a netipong dikaw i kapangyedihan ni Makedepat a Kaditasan kanya i panganak mo a an te mammalotin ay ngangalanan a Anak nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","“Pati patalikngan mo ta i mangáyun mo a Elisabet ay gelihe pala ni isin a lalaki ta misan katinggesan di ni agta a an di nappatud a gekaanak ay nánganak ta i kabsuan na nano ay te duman di a anim a bulan. ");
INSERT INTO due_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ta talage a i pesan a pangako ni Makedepat ay matud ngani a nangyeyedi.” ");
INSERT INTO due_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nano ay tinumubeg i Maria, “Ako ay talage a pigdodulin ni Panginoon a Makedepat ta mangyedi tebe deko i sinabi yu nano.” Dingan winalat eya nun anghel. ");
INSERT INTO due_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nano ay an náloy ay ginumayak i Maria a kinumang a tambing de isin a benwaan de pulupagotan a sákup ni Hudia. ");
INSERT INTO due_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagdetong na ay sinumilong eya de beloy ni Sakarias ta binate na i Elisabet a bebi na. ");
INSERT INTO due_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nano ay pagkaikna pan ni Elisabet de pagbete ni Maria diya ay inumiwes i kilasaan de tiyen na ta pino eya ni Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Dingan nagsurut ni malagdu i Elisabet ni geapo de Ispiritu ta sinabi na a, “Namas ka pa a pekalbian de pesan a mahunain pati kilasaan na de tiyen mo. ");
INSERT INTO due_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Talage a piyon a masakut i innawa deko ni Makedepat ta pinakang na deko i ina ni Panginoon ko. ");
INSERT INTO due_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Talage a pagelawagin mo ta nun inikna ko i pagbete mo deko ay inumiwes i kilasaan de tiyen ko i dehil de salig na. ");
INSERT INTO due_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ta pekalbian ka pala ni Panginoon a Makedepat dehil de nanulusun ka de pinasabi na dikaw nunde anghel.” Inon i sinabi ni Elisabet. ");
INSERT INTO due_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dingan sinabi ni Maria, “Talage a gepodi ngani i innawa ko de Panginoon ");
INSERT INTO due_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ta nagkasalig i kaleduwa ko dehil de Makedepat a magliligtas ko. ");
INSERT INTO due_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ta misan anok te kabuluhan de pekita ni agta ide ay pineta ok na a pigdodulin na. Ta gepo nano ay oolangan ok ni pesan a nagkaduman ni kalbi nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ta i Makedepat a Makapangyedihan ay yinadi ok na a kapiyonan a masakut ta eya a Makedepat ay an te mammalotin. ");
INSERT INTO due_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Talage ngani a pekalbian na kapide man i manga agta a gegelang diya. ");
INSERT INTO due_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pepakita na i pagyedi na a te kapangyedihan pati pekálat na i geesip ide ni pagmayabeng. ");
INSERT INTO due_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pebut na pala i kapangyedihan ni manga hari ide ta peditas na pan i te manga masidong ide a innawa. ");
INSERT INTO due_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pati i pebiyen na ni kapiyonan ay i te buot a geabut diya ta pepatotul na pan i an te buot a geabut a an te misan ano a adde. ");
INSERT INTO due_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Getabeng i Makedepat dikitam a manga Hudyo a pigdodulin na ide a nappaayun de pinangako na a kalbi de kaapoapohan tam ide. ");
INSERT INTO due_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ta an na ngani kinalipátan i pinangako na de Abraham pati dikitam a mangápo na, magpakapide pa man.” Inon i hinola ni Maria. ");
INSERT INTO due_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nano ay nakitaan i Maria de beloy ni Elisabet ni tiluwon a bulan dingan eya ay inumuli dingani. ");
INSERT INTO due_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nano ay dinumatong di i panahon a panganak di ni Elisabet kanya eya ay nanganak ni isin a lalaki. ");
INSERT INTO due_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nun matinggesan pan ni mangáyun na ide pati kabeloy na ide a eya ay kinalbian di ni Panginoon a Makedepat ay nakisalig pala ide diya. ");
INSERT INTO due_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pagdetong ni kawalo a adow ay nagidinatong i kaagtaan tangani pepelatan de un anak a nappaayun de pagdodul a den nun Makedepat pati i ngangalan de tebe de kilasaan ay Sakarias pala a magi ngalan ni ama na. ");
INSERT INTO due_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Misan ay sinabi ni ina ni kilasaan a, “Wet inon ta Huwen i depat a ngalan na.” ");
INSERT INTO due_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dingan i kaagtaan ay nagtaka ta sinabi de, “Am pa te duman a ngalan a Huwen de mangáyun yu ide.” ");
INSERT INTO due_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nano ay hinalimbewaan de i ama ni kilasaan a ti ano i buot na a ngangalan de anak na a lalaki. ");
INSERT INTO due_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ay inaged na i pesolatan na ta sinolat na i magioyo, “I ngangalan diya ay Huwen.” Nano ay nagtaka i kaagtaan a pesan duman ta inesip de a ti ano ta nagkaeisin di ni esip i magkálaki. ");
INSERT INTO due_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Dingan tambing pan a nakasurut di i Sakarias a nagpodi a tuloy de Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kanya nagkaduman ni takut a hanga i manga kaagtaan duman ta kinumálat inon a sinumapit de pulupagotan ni Hudia. ");
INSERT INTO due_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Talage a i pesan a nakaikna tungkul de anak a oyo ay nag-uluesip ide a masakut ta sinabi de, “Nappa ni anoman i anak a oyo?” Ta kinatinggesan de a nagkaduman eya ni kapangyedihan a geapo de Panginoon a Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nano ay napino a masakut i Sakarias ni Ispiritu nun Makedepat kanya eya ay naghola a magioyo, ");
INSERT INTO due_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Magpodi kitam di de Panginoon a Makedepat a pepodian tam a manga Hudyo a tage bensa a Israel ta eya ay nádetong tangani tobusin na ikitam a mangának na. ");
INSERT INTO due_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta boboy na dikitam i isin a Makapangyedihan a Magliligtas a i apo ni Hari a Debid a katabeng nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ta nun nowon ay pinangako ni Makedepat dikitam de padean ni magsasabi na ide a den ");
INSERT INTO due_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","a leligtas na ikitam a Hudyo de kapagebuk tam ide pati de pesan a nagkagengsa dikitam. ");
INSERT INTO due_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ta mamatud na pala i pinangako na a kalbi de kaapoapohan tam ide. Pati pamatoden na pala i pagpakikasungdu na ");
INSERT INTO due_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","a i pinangako na a sinumpa na de kaapoapohan tam a Abraham. ");
INSERT INTO due_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ta pinangako na dikitam a leligtas na ikitam de kapagebuk tam ide tangani nakapetabeng kitam diya a an te takut. ");
INSERT INTO due_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Pati nakapepodi kitam pala a te piyon a pagyedi pati malenis a innawa de pekita na hanggen nagkeedup kitam.” ");
INSERT INTO due_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Dingan sinabi ni Sakarias tungkul de anak na a magioyo, “Ikaw a anak ko ay ngangalanan ka a magsasabi ni Makedepat a Kaditasan ta naona ka de Panginoon tangani gehande ka ni dedetongan na. ");
INSERT INTO due_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ta boyin mo de kaagtaan a mangának na i katinggesan a tungkul de kaligtasan a geapo de Makedepat tangani pakeeyenan na ide ni mammalotin de ");
INSERT INTO due_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","dehil de hanga a masakut a kalbi na. Ta te gepo a nátallang dikitam a magi adow i Pineta nun Makedepat a náapo de langot. ");
INSERT INTO due_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ta nádetong eya tangani patallangin na i naddedumos, a nangadde de kalebunan de ta totodu na pala dikitam i matud a bektas a paagow de kapiyonan.” Inon i hinola ni Sakarias. ");
INSERT INTO due_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nano ay hinumanga i Huwen a gepakikaisin pala eya de Makedepat. Ta eya ay tinumaan de lugel a ilang hanggen de eya ay magpaabuya de manga Hudyo ide a tage bensa a Israel. ");
INSERT INTO due_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nano ay nun panahon a inon ay dinumatong i pagdodul nun te ngalan a Agusto a Hari a Kaditasan de Roma tangani magpalista i pesan a manga agta nunde lugel a belang sákup na a tage Roma. ");
INSERT INTO due_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","I oyo a pagpalista a tagibu ay yinadi nun i Kirenios i gubernador de bensa ni Siria. ");
INSERT INTO due_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kanya i pesan a manga agta ay kinumang de benwaan ni kaapoapohan de ide tangani ide ay gepalista. ");
INSERT INTO due_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nano ay sinumakat pala i Hose a inumapo de Nasarit a benwaan na a sákup ni Galilea, a paagow de benwaan a Betlehem a sákup pan ni Hudia. Ta de Betlehem pala pinanganak i Debid a kaapoapohan ni Hose. ");
INSERT INTO due_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sinumakat ide pati Maria a kasungdu na misan ay mabsu di ta ide ay gepalista. ");
INSERT INTO due_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nano ay nun duman di ide ay odes di a nánganak di i Maria. ");
INSERT INTO due_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ta eya ay nanganak ngani ni panganay na a lalaki de beloy ni beka ide ta an di te sukul a maluag de pigtuloyen ide a peupahan. Dingan tiningos de i Hisus de lampin ta pinuoy de de pigpanganan ni beka a hinande. ");
INSERT INTO due_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nano ay de sákup a inon ay te duman pan a mag-aalage ni topa ide ta gebentay ide a magdemag ni topa de ide de kapadengan. ");
INSERT INTO due_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dingan loktat a nagpakita dide i isin a anghel ni Panginoon a Makedepat ta tinumoplak i gepakaingap ni Panginoon de palébut de kanya nagkaduman ide ni hanga a takut. ");
INSERT INTO due_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Misan ay sinabi nun anghel dide, “Wet kamo matakut ta patalikngan yu ta sasabi ko dikamo i piyon a bereta a nakásalig de pesan a kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ta nano a odes ay pinanganak di de benwaan ni Debid i magliligtas yu a i Kristo a Panginoon. ");
INSERT INTO due_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nano ay i tande a kekita yu i kilasaan ay nattingos de lampin a nappaide de pigpanganan ni beka.” ");
INSERT INTO due_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Dingan pagkasabi na ninon ay loktat a nagiinuddi de palebut nun anghel i makmuk a masakut a manga anghel a gepinagkanta ni pagpodi de Makedepat. Ta i pagpodi de ay magioyo, ");
INSERT INTO due_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Magpodi kitam di de Makedepat de langot ta dio de putok i ay gekaduman ni kasampatan a innawa i belang te piyon a innawa a pagkasaligen na.” Inon i pagpodi ni manga anghel ide. ");
INSERT INTO due_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nano ay pagkatotul nun anghel ide a paagow de langot ay dingan nasurutsurotan pan un mag-aalage ide ni topa ta sinabi de, “Kumang kitam di de Betlehem tangani kitain tam i pinabereta dikitam ni Panginoon a Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dingan kinumang ide a tambing ta kinta de i Maria pati Hose ta kinta de pala un kilasaan a nappaide de pigpanganan ni beka. ");
INSERT INTO due_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ta pagkakita de nunde kilasaan ay binareta de i pesan a sinabi nun anghel a tungkul de kilasaan. ");
INSERT INTO due_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kanya i pesan a inumikna de sinabi de ay nagtaka a masakut de sinabi nun mag-aalage ide. ");
INSERT INTO due_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Misan ay tinandean pan ni Maria i inikna na a inon ta pinakaesip na a masakut. ");
INSERT INTO due_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nano ay inumampulang un mag-aalage ide a gepinagpodi de Makedepat dehil de kinta de pati inikna de a binareta dide ni manga anghel. ");
INSERT INTO due_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nano ay pagdetong ni kawalo di a adow ay pinapelátan de un kilasaan pati nginalanan de eya a Hisus a magi sinabi ni anghel de Maria nun am pa eya gelihe. ");
INSERT INTO due_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nun dinumatong di i adow a gehandug i magkálaki a nappaayun de pagdodul ide ni Moises dehil de panganak ni mahuna ay inadde de i anak de de benwaan a hanga a Herusalem tangani hahandug de i anak de Panginoon a Makedepat. ");
INSERT INTO due_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ta te duman de kasulatan ni Panginoon a pagdodul a magioyo, “Depat a boyin yu i panganay yu a lalaki de Panginoon a Makedepat ta talage a hinande ide diya.” ");
INSERT INTO due_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Naghandug pala i magkálaki ni aduwa a kalapati a nappaayun pala de pagdodul ni Panginoon. ");
INSERT INTO due_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nano ay te duman de Herusalem a laki a te ngalan a Simeon. Eya ay agta a piyon ta te gelang eya de Makedepat ta ugnay na a peilat i panahon a naligtas di i Hudyo ide a tage Israel. Pati pino eya ni Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nano ay pinatingges diya ni Ispiritu nun Makedepat a an eya nelibun hanggen an na kekita i Kristo a Pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kanya gepo de kapangyedihan ni Ispiritu ay sinumilong i Simeon de beloy a pighandogen de Makedepat. Nun inadde ni kamoddenan na i Hisus tangani yeyedi de i nappaayun de pagdodul ide ni Moises ");
INSERT INTO due_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ay sinakoyong ni laki a Simeon i anak ta nagpasalamat de Makedepat a magioyo, ");
INSERT INTO due_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Panginoon a Makedepat, nano ay pabiyaan ok yu di a katabeng yu a kumang de kataanan yu a nappaayun de pinangako yu deko. ");
INSERT INTO due_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ta kinta ko di i magliligtas a inumapo dikamo ");
INSERT INTO due_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ta eya ay hinande yu para de pesan a kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pati eya i gepatallang de madumos a esip ni an Hudyo ide ta dehil pan diya ay gekaduman ni gepakaingap yu i Hudyo ide a tage bensa ni Israel.” ");
INSERT INTO due_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nano pagkasabi ni Simeon ninon ay nagtaka i magkálaki dehil de inon a sinabi a tungkul de anak de. ");
INSERT INTO due_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nun nanalangin i Simeon para dide ay sinabi na de Maria a ina ni Hisus, “Dehil de anak a oyo a Pineta nun Makedepat ay nalligtas ngani i kamakmokan a tage Israel a nonulusun diya. Misan pan ay podusahan i an nonulusun diya ta eya ay nappa ni tande a inumapo de Makedepat a kakapoyen pan ni makmuk a agta. ");
INSERT INTO due_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ta de maginon ay pepakita i esip de a petagu. Dingan ikaw pan ay náapdis a masakut i innawa mo dehil de násapit diya.” ");
INSERT INTO due_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nano ay te duman pala a magsasabi a gupad a te ngalan a Ana. Ta i ama na ay i Panuel pati kaapoapohan na ay i Aser. Eya ay gupad di a masakut ta i káloy na la a te duman a bebi ay pito la a taon. ");
INSERT INTO due_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ta nano ay belo di a náloy ta i katande na nano ay walo di a puwu pati apat a taon. Pati ugnay eya duman de beloy a pighandogen ta abi pati adow ay nagpodi eya de Makedepat a an gepangan ni untik a panahon tangani gepanalangin. ");
INSERT INTO due_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nun nanon pala a odes ay dinumatong eya ta nagpasalamat de Panginoon a Makedepat dehil de Hisus a anak dingan naghola eya ni tungkul de Hisus de tage Herusalem ide a geilat ni kaligtasan a peboy ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nano ay nun matapos di a yinadi ni magkálaki a nappaayun de pagdodul ide ni Panginoon a Makedepat ay inumampulang ide de benwaan de a Nasarit a sákup ni Galilea. ");
INSERT INTO due_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","I Hisus pan ay hinumanga a pepatibong a ugnay. Ta adow-adow ay nagkapa ni naketingges, a nagkaduman eya ni kosa a tabeng ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nano ay te duman a ugeli i kamoddenan ide ni Hisus a de belang kaadowen ni Paskuwa ay geduman ide de Herusalem. ");
INSERT INTO due_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kanya pan nun i katande di ni Hisus ay sangpuwu di pati aduwa ay dinumuman ide a magi peyedi a den ni kamoddenan na ide. ");
INSERT INTO due_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Misan ay pagkatapos ni kaadowen ni Paskuwa ay nagiinuli ide ta i Hisus pan ay nawalat duman de Herusalem. Misan ay an kinatinggesan ni kamoddenan na ide. ");
INSERT INTO due_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ta inesip de la a nappakoloy eya de mangáyun de a getotul de bektas. Nano ay nun apun di a andi ide getotul ay linawag de eya de mangáyun de ide pati peabuyenan de ide a manga agta. ");
INSERT INTO due_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nun an de kinta ay inumampulang ide a liwet de Herusalem tangani duman de lalawag. ");
INSERT INTO due_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dingan nun kinábiabian di ay kinta de eya duman de beloy a pighandogen a gelipa eya de pagulugitnan ni magtutodu ide ni Hudyo, a gepatalikngoy pati getanto dide. ");
INSERT INTO due_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ta i pesan a nakaikna diya ay nagtaka dehil de pagtubeg na pati katinggesan a masakut. ");
INSERT INTO due_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Pati pan i kamoddenan na ide ay nagtaka pala ide nun kinta de eya duman ta sinabi diya ni ina na, “Anak ko, bekot ta yinadi mo dikami a magioyo ta ikami pati ama mo ay naglawag dikaw a nagkogulo i esip mi.” ");
INSERT INTO due_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Misan ay tinubeg na dide a magioyo, “Ano ta pelawag ok yu ta an yu mangan la katinggesan a depat ok ngani a ugnay dio de beloy ni Ama ko?” ");
INSERT INTO due_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Misan ay i sinabi a inon ni Hisus ay an kinatinggesan ni kamoddenan na ide. ");
INSERT INTO due_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Dingan inumuli ide a kakoloy de i Hisus de Nasarit ta tinumalinga eya a tuloy dide misan ay inesip la ni ina na un sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ta i Hisus ngani ay hinumanga pati nagkapa ni naketingges pa. Pati eya ay kinasaligen a tuloy ni Makedepat pati manga agta ide. ");
INSERT INTO due_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nano ay nun dinumatong i sangpuwu pati lima a taon a gehari i Tiberio a Hari a Kaditasan de Roma ay i Ponsio Pilato i gubernador de sákup ni Hudia. Ta i Herod pan i gubernador de sákup ni Galilea pati Pilepi a wele na ay gubernador de sákup ni Iturea pati Trakonite. Ta i Lisanias pan ay gubernador de sákup ni Abilinia. ");
INSERT INTO due_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ide Anas pan pati Kaipas i pinakaponu ni maghahandug ide nun panahon a inon. Ta nun inon pala a panahon ay duman di de ilang i Huwen a Maglilenod a anak ni laki a Sakarias ta dinumatong diya i surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kanya pan eya ay kinumulukang de magduludipa ni Orat a Horden. Ta nagsabi eya a magioyo, “Magipinagsosol kamo de mammalotin yu ta lelinod ko ikamo de orat a tande ni pagsosol yu ta pakeeyenan kamo ni Makedepat ni mammalotin yu.” Maginon i pagsurut ni Huwen. ");
INSERT INTO due_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","De maginon ay nangyedi di i sinolat ni Isais a magsasabi a den ni Makedepat a magioyo, “Nádetong i geolang de lugel a ilang. Gesabi eya a handein yu i bektas para de Panginoon ta tanusin yu i sesilan na. ");
INSERT INTO due_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Taporan yu i belang lobnak de sesilan na pati topnayin yu i belang bungko de bektas na. Ta i napakiwong a bektas ay depat a tanusin yu ta depat a pantayin yu pala i nallugulobnak. ");
INSERT INTO due_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dingan kekita ngani ni pesan a agta i magliligtas a peboy ni Makedepat.” Inon i sinolat ni Isaias a tungkul de Huwen. ");
INSERT INTO due_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nano ay dinumatong de Huwen i makmuk a agta tangani magpalinod ide diya misan ay sinabi na dide, “Malot kamo ngani a magi manga bebek kanya wet yu peesipa a ikamo ay nakeelag de padusahan ni Makedepat dehil de pagsosol yu de surut yu la. ");
INSERT INTO due_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ta nagkaddepat pan a i pagsosol yu de surut yu ay gekaanak ngona ni piyon a ugeli. Pati wet kamo gesabi a ikamo ay nalligtas dehil de ikamo ay mangápo a sagu ni Abraham. Ta pesabi ko dikamo a te kaya i Makedepat a nameedup de beto ide a oyo a nappa ni matud a mangápo ni Abraham. ");
INSERT INTO due_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nano pa ay i paghatol ni Makedepat ay magi palakol a napahaya di de gemut ni kew. Ta i belang kew a an geanak ni piyon ay popugtus a wewitik de apoy.” ");
INSERT INTO due_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ta pagkasabi ni Huwen ninon ay tinanto eya nun kaagtaan a magioyo, “Be maginon ay anóman i piyon a yeyedi mi?” ");
INSERT INTO due_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Dingan eya ay tinumubeg dide, “Be te duman kamo a bedu a aduwa ay depat a boyin yu i isin de an te duman. Maginon pala de an te pápangan ay depat yu a biyen un an te duman.” Inon i pagtodu ni Huwen. ");
INSERT INTO due_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nano ay dinumatong pala de Huwen i magsisengil ide ni buwis tangani linodin na ide ta sinabi de diya, “Magtutodu, anóman i depat mi a yeyedi?” ");
INSERT INTO due_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Dingan tinubeg na ide a magioyo, “Wet kamo maningil ni an pedodul dikamo.” ");
INSERT INTO due_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ta tinanto pala eya ni tipide a sundelo, “Ay ikami pan, anóman i depat a yeyedi mi?” Ta tinubeg na ide, “Wet kamo nángamit ni misan ano dehil de pagtakut yu de manga agta pati de pesabi yu a kabutelan. Ta depat kamo a masalig la de suwildu yu.” Inon i sinabi ni Huwen dide. ");
INSERT INTO due_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nun nanon ay makmuk a manga agta i geilat de pagdetong ni Kristo a Pinangako nun Makedepat ta i peesip de tungkul de Huwen ay makati eya di i Kristo. ");
INSERT INTO due_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Misan ay tinubeg na dide, “Pelinod ko di ikamo de orat a tande ni pagsosol yu misan ay te nádetong pa a nappabut deko a namas pa a te kapangyedihan deko. Ta anok te sukul a kapangyedihan a nongukas ni gipot ni paragetus na. Ta eya pan i nanlelinod dikamo de Ispiritu nun Makedepat pati de apoy. ");
INSERT INTO due_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Pagdetong na ay te pansidi dingan lalayu na i tap ni biges ta tetipun na de kamalig na i biges misan ay i tap pan ay sosunug na de apoy a an nagkapalong.” Inon i sinabi ni Huwen. ");
INSERT INTO due_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Pati makmuk pa a sinabi i Huwen de kaagtaan de pagsabi na ni piyon a bereta. ");
INSERT INTO due_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Misan ay sinosol ni Huwen i Gubernador a Herod dehil de binabian na i Herodeas a bebi pan ni wele na a Pilepi pati kakmukan pa a malot a yinadi ni Herod. ");
INSERT INTO due_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kanya namas pa ngani a malot i yinadi ni Herod ta pinabilanggo na i Huwen. ");
INSERT INTO due_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nano ay nun am pa nagkabbilanggo i Huwen ay makmuk a manga agta i lininod na de orat ta lininod na pala i Hisus. Dingan nun gepanalangin i Hisus ay nakayesán i langot ");
INSERT INTO due_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ta linumusong diya i Ispiritu nun Makedepat a magi kalapati. Dingan te nagsurut a inumapo de langot a magioyo, “Ikaw i pebuot ko a anak ta dehil dikaw ay nagkasalig ok a masakut.” ");
INSERT INTO due_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nun te gepo i Hisus a gesabi ni piyon a bereta ay i katande na ay manga tiluwon a puwu a taon. Ta peesip ni manga agta a eya ay anak ni Hose a anak ni Eli ");
INSERT INTO due_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","a anak ni Matat a anak ni Lebi a anak ni Melki a anak ni Hano a anak ni Hose ");
INSERT INTO due_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","a anak ni Matatias a anak pan ni Amos. I oyo pan a Amos ay anak ni Nahum a anak pan ni Esli. I Esli pan ay anak ni Nage ");
INSERT INTO due_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","a anak ni Maat a anak ni Matatias. Ta i Matatias pan ay anak ni Semei a anak ni Hose. I Hose pan ay anak ni Huda ");
INSERT INTO due_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a anak ni Hoano. I Hoano pan ay anak ni Reso a anak ni Sorobabel a anak ni Salatiel a anak ni Neri. ");
INSERT INTO due_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ta i Neri pan ay anak ni Melki a anak ni Adi a anak ni Kosam a anak ni Elmodam a anak ni Er. ");
INSERT INTO due_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ta i Er pan ay anak ni Hosue a anak ni Elieser a anak ni Horim a anak ni Matat. I Matat pan ay anak ni Lebi ");
INSERT INTO due_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a anak ni Simeon a anak ni Huda. Ta i Huda pan a oyo ay anak pan ni Hose a anak ni Honan a anak ni Eliakim ");
INSERT INTO due_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a anak ni Meleo a anak ni Mainan. I Mainan ay anak pan ni Matata a anak ni Natan a anak pan ni Debid. ");
INSERT INTO due_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","I Debid pan ay anak ni Hesse a anak ni Obid a anak ni Boos a anak ni Salmon a anak ni Naason ");
INSERT INTO due_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a anak ni Aminadab a anak ni Admin ta i Admin pan ay anak ni Arni a anak ni Esrom a anak ni Pares a anak pan ni Huda. ");
INSERT INTO due_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","I Huda pan ay anak ni Hakob a anak ni Isak a anak ni Abraham a anak ni Tare a anak ni Nakor. ");
INSERT INTO due_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","I Nakor pan ay anak ni Serug a anak ni Ragao a anak pan ni Peleg a anak ni Heber a anak ni Sala. ");
INSERT INTO due_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","I Sala pan ay anak ni Kainan a anak ni Arpasad a anak ni Sem a anak ni Noe a anak ni Lamek ");
INSERT INTO due_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a anak ni Matusalem a anak ni Enok a anak ni Hared a anak ni Mahalaleel a anak ni Kainan. ");
INSERT INTO due_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","I Kainan pan ay anak ni Enos a anak ni Set ta i Set ay anak ni Aden a anak nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nano ay i Hisus ay tinumotul de Orat a Horden a pino eya ni Ispiritu nun Makedepat ta eya ay inikag ni Ispiritu de lugel a ilang. ");
INSERT INTO due_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ta nun eya ay duman di a apat a puwu a adow a an eya gepangan ay natigeng di. Ta eya ay sinubukan ni Satanas a petukso. ");
INSERT INTO due_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dingan sinabi diya ni Satanas, “Be ikamo i matud a Anak nun Makedepat ay yediin yu a tinapay i beto ide a oyo i.” ");
INSERT INTO due_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Misan ay tinubeg eya ni Hisus ni magioyo, “Te duman de kasulatan a, ‘An la dehil de pápangan a nagkeedup i agta.’ ” ");
INSERT INTO due_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Dingan eya ay inikag ni Satanas de maditas a kalasan ta loktat na a pinasayed de Hisus i pesan a nasasakopan dio de putok i. ");
INSERT INTO due_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ta sinabi diya ni Satanas, “Talage a boboy ko dikamo i kapangyedihan pati kayamanan ni pesan a oyo dio de putok i ta i oyo ay binoy di deko kanya nappatud ngani a boboy ko misan dino a buot ko a bebiyen. ");
INSERT INTO due_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kanya be gepodi kamo deko ay talage a boboy ko yo dikamo.” ");
INSERT INTO due_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ta tinumubeg i Hisus diya, “Te duman pala de kasulatan a, ‘Magpodi ka la de Panginoon mo a Makedepat ta diya ka la magtabeng.’” ");
INSERT INTO due_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pagkatapos ninon ay inikag ni Satanas i Hisus de Herusalem de tibing ni palokoan ni beloy a pighandogen de Makedepat ta sinabi pa diya ni Satanas, “Be matud kamo a Anak nun Makedepat ay tumagbong kamo gepo dio tangani mapakita yu i kapangyedihan yu de manga agta ide. ");
INSERT INTO due_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ta te duman de kasulatan a, ‘Pinagtutugun ni Makedepat de manga anghel na ide tangani aalagean de ikamo.’ ");
INSERT INTO due_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pati ‘Bobolan de ikamo ni kumot de tangani wet kamo nassingkug de kabetoan.’” ");
INSERT INTO due_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Misan ay tinumubeg diya i Hisus, “Matud ngan non misan ay te duman pala de kasulatan a, ‘Wet mo sosubukan i Panginoon mo a Makedepat.’” ");
INSERT INTO due_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nano ay pagkatapos ni Satanas a nagtukso de Hisus de pesan a padean ay winalat na i Hisus ta nag-ilat ni pagkakataon na a liwet. ");
INSERT INTO due_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nano pagkatotul ni Satanas ay inumampulang i Hisus de Galilea a te kapangyedihan diya i Ispiritu nun Makedepat. Ta de pesan a kulukaginglan ni sákup ni Galilea ay kinumalat i bereta a tungkul diya. ");
INSERT INTO due_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ta duman ay nagtudo eya de pigmitengan ide ni Hudyo ide ta eya ay pinodi ni pesan. ");
INSERT INTO due_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ay dingan inumuli eya de benwaan na a Nasarit a hinangaan na. Nano ay nun adow di ni paimloy ay sinumilong eya de pigmitengan a nappaayun de ugeli na. Ta inumuddi eya tangani magbesa. ");
INSERT INTO due_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dingan binoy de diya i kasulatan ni magsasabi a den a i Isais. Ta linawag na de kasulatan i buot na a bebesa ");
INSERT INTO due_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ta binasa na a magioyo, “Nagkaduman ok di ni Ispiritu nun Makedepat ta napa deko i kapangyedihan a gesabi ni piyon a bereta de mahedepin ide a an te manga pag-asa a unabis. Pati dinodul ok na a gesabi a nappatud di a nappa ni malaya i pesan a alepin ni mammalotin de. Pepatallang ko pala i esip ni an ide te manga katinggesan pati eeyenan ko ni kahedepan i natalo ide de kalibongan. ");
INSERT INTO due_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta gesabi ok a nano di i panahon a gekaduman ni kosa a tabeng ni Makedepat i belang buot a gepanulusun diya.” ");
INSERT INTO due_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pagkatapos di ni Hisus a nagbesa ay linukut na un kasulatan dingan inuma na de katabeng ni ponu ta linumipa eya a getodu. Ta i pesan a kaagtaan de pigmitengan ay nagpagelawag diya a gesurut. ");
INSERT INTO due_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nano ay te gepo di eya a gesurut dide ta sinabi na, “Nano a adow ay nengyedi di de peikna yu i, inon a bihagi ni kasulatan a binasa ko.” ");
INSERT INTO due_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ta pinamatoden pan ni kaagtaan a eya ay piyon pati nagtaka ide de surut na a te kapangyedihan. Misan ay sinabi ni tipide, “Am man la iwina i anak ni Hose a tage dio?” ");
INSERT INTO due_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kanya pan sinabi ni Hisus dide, “Makati sasabi yu deko i oyo a pigsabiin a, ‘Magbubulong, papiyonin yu i sadile yu a magi pagpapiyon yu de kakmukan.’ Ta be maginon ay kati sasabi yu pala a yeyedi ko i gepakataka dio de Nasarit i a benwaan ko a magi yinadi ko de Kapernam.” ");
INSERT INTO due_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ta sinabi ni Hisus a tuloy, “Talage ngani a an te misan ino a magsasabi a pegelang de sadile na a lugel. ");
INSERT INTO due_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ta kamatoden a pesabi ko dikamo a nun panahon ni Elias ay makmuk i belo a mahunain a tage Israel ta nun nanon ay an tinumapuk ni tiluwon a taon pati kalahati dingan nagkaduman ni hanga a tigtégeng de pesan a putok. ");
INSERT INTO due_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Misan ay an pinakang ni Makedepat i Elias de isin a tage Israel a belo a mahuna ta pinakang na pan la eya a getabeng de isin a belo a mahuna a an Hudyo de benwaan a Sarepta a sákup ni Sidon ta te pagpanulusun eya de Makedepat. ");
INSERT INTO due_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Maginon pala nun panahon ni Eliseo a magsasabi ta makmuk nun nanon i te manga ketong de bensa a Israel misan ay an te pinapiyon de tage Israel ide ta i Naman la a an Hudyo a tage Siria.” ");
INSERT INTO due_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kanya pagkasabi ninon ni Hisus ay nagkaduman ni gengsa i pesan a agta nunde pigmitengan nun matinggesan de a i surut ni Hisus ay tungkul dide. ");
INSERT INTO due_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kanya ide ay nagiinuddi ta pinabulwag de a mapelit i Hisus de benwaan de hanggen nunde tibing nun denpa a hanga a kauddian nun benwaan de. Ta binuot de tebe a buklidin de duman nun de rongtob. ");
INSERT INTO due_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Misan ay sinumila la eya de pagulugitnan ta eya ay tinumotul di. ");
INSERT INTO due_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nano ay pag-apo na duman ay kinumang eya de Kapernam a sákup ni Galilea. Ta nun adow di ni paimloy ay nagtodu eya de kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Talage a nagtaka i kaagtaan dehil de pagtodu na a te kapangyedihan a masakut. ");
INSERT INTO due_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nano ay te duman pala de pigmitengan i isin a lalaki a te libong a malot de lawes na. Ta inumolang i te libong ni malagdu a magioyo, ");
INSERT INTO due_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hisus kamo a tage Nasarit, bekot ta peabela yu ikami nano? Dinumio kamo man a nansesede ni kapangyedihan mi a kalibongan? Talage a peabuyenan mi ikamo a An Te Mammalotin a Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Misan ay sinablow ni Hisus i malot a libong ta sinabi na, “Tumimok ka ta lumayu ka de agta a iwina.” Ta de pagulugitnan ni kaagtaan ay pinadegmak ni libong un lalaki ta dingan eya ay linayuan na ta i lalaki ay an la naapdisan. ");
INSERT INTO due_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ay nagtaka un kaagtaan a masakut kanya ide ay natulutantoan a magioyo, “Ano pan non a surut ta te kapangyedihan a masakut a gedodul de mammalotin a libong ta gelayu pan ide.” ");
INSERT INTO due_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nano ay kinumálat i bereta a tungkul de Hisus de pesan a lugel a inon. ");
INSERT INTO due_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nun pagkabulwag nide Hisus de pigmitengan ay sinumilong ide Hisus de beloy ni Simon Pedro. Nano ay pelagnat mangani a masakut i panuwangan a mahuna ni Simon kanya ide ay nakisurut de Hisus a papiyonin na i gupad. ");
INSERT INTO due_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pagdetong ni Hisus de alane ni te orom ay pinalayu na i lagnat ta naeyen dingani un lagnat na. Ta pagkagiyos na a tambing ay nag-akod eya dide ni pápangan. ");
INSERT INTO due_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nano ay nun pagkalinod di ni adow ay inikag de Hisus ni kaagtaan i te manga orom ide de beloy de. Ta ide a pesan ay tinapá ni Hisus ta i belang isin dide ay pinumiyon di. ");
INSERT INTO due_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pati pan i te manga libong ide de lawes de ay pinalayuan na ide ta ide ay nagiinolang a sinabi de, “Ikamo ay Anak nun Makedepat.” Misan ay sinablow ide a mahigpit ni Hisus a, “Tumimok kamo.” Ta kinatinggesan de a eya ay i Kristo a Pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nun mulumadumos pa nun abiabi ay ginumiyos i Hisus ta kinumang de lugel a ilang misan ay i manga agta ay te gepo a gelawag diya. Pagkakita de diya ay sinabi de a, “Wet kamo ngona tumotul dio.” ");
INSERT INTO due_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Misan ay sinabi na dide, “Nagkaddepat pala a makapagsabi ok ni piyon a bereta de bulubenwaan a ti papalano a te kapangyedihan i Makedepat de innawa ni agta ide ta dehil de oyo ngani ay dinodul ok ni Makedepat dio de putok i.” Inon i sinabi ni Hisus dide. ");
INSERT INTO due_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kanya pan eya ay nagsabi ni piyon a bereta de belang pigmitengan de sákup ni Galilea. ");
INSERT INTO due_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nano ay nun isin a adow a geuddi i Hisus de kaginglan nun uluataben a Genasaret a nagtodu ay kinatipunan eya ni makmuk a kaagtaan a te buot a gepatalikngoy de surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Misan ay kinta pan ni Hisus i aduwa a bengka a nasangrad duman ta i te manga bengka ide ay an di duman ta ide ay geuges di ni pokut de. ");
INSERT INTO due_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dingan eya ay sinumakoy nunde isin a bengka a adi ni Simon ta sinabi na de Simon, “Bungsudin mo ni untik i bengka i.” Dingan eya ay naglipa duman nun nappalitow di un bengka ta i Hisus ay nagtodu de kamakmokan de mamala. ");
INSERT INTO due_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagkatapos na a nagsurut dide ay sinabi na de Simon, “Dumuman kitam di de ditow to ta dingan degdegin yu i pokut yu na ide tangani makámit kamo ni ikan.” ");
INSERT INTO due_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Misan ay tinumubeg i Simon, “Panginoon, magdemag ay nagpokut kami di misan ay ang kami nakámit. Misan ay hale di be pesabi yu a maginon ay dedegdeg ko i pokut ide i.” ");
INSERT INTO due_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nun madegdeg ngani un pokut ide ay talage ngani a nakámit ide ni makmuk a masakut a ikan pati negisi di tebe i pokut de. ");
INSERT INTO due_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kanya pinayapáyen de un kakoloy de de isin pa a bengka tangani tatabengan ide. Pagdetong de ay napinoin di un aduwa a bengka a kasta nelinod di. ");
INSERT INTO due_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Dingan pagkita ni Simon Pedro ni ikan a makmuk a masakut ay makowe eya a linumane de Hisus ta linumuhud a sinabi na, “Panginoon, wet kamo lumane deko ta ako ay agta a makikkakasalanan.” Inon i sinabi ni Pedro a te masidong a innawa ");
INSERT INTO due_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ta eya ay nagtaka pati kakmukan a mangáyun na dehil de nakámit ide ni makmuk a ikan. ");
INSERT INTO due_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pati ide Santiago, Huwen a mangának ni Sebedeo ay nagtaka pala. Ide ay kakoloy ni Simon Pedro de pangikan. Misan ay sinabi ni Hisus de Simon Pedro, “Wet ka matakut ta gepo nano ay yeyedi ko ikaw a mag-aakit ni agta ide tangani nosut pala ide deko a tuloy.” ");
INSERT INTO due_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kanya pagkasaka de ngani nunde mamala ay winalat de i pesan duman ta sinumut ide de Hisus. ");
INSERT INTO due_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nano ay nun duman di i Hisus de isin pa a benwaan ay te duman a linumane diya a isin a lalaki a te ketong i pesan na a lawes. Pagkita na de Hisus ay inumobbob de kasagkaden na ta sinabi na, “Panginoon, be buot yu ay papiyonin ok yu di ta ikamo ay te kaya.” ");
INSERT INTO due_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ay inonat ngani ni Hisus i kumot na ta tinapá na i te ketong a sinabi na, “Buot ko a talage. Pumiyon ka di.” Ta tambing ngani a naeyen i ketong na. ");
INSERT INTO due_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nano ay tinutugun diya ni Hisus a mahigpit a, “Wet mo sasabia misan dino i sinumapit dikaw misan ay kumang ka a palawag mo i lawes mo de isin nunde maghahandug ide nun Makedepat. Ta pagkakita na dikaw ay maghandug ka a nappaayun de pagdodul ide ni Moises ta inon ay gepamatud de kaagtaan a pinapiyon ka di.” Inon i sinabi diya ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Misan ay namas pangani a kinumálat i bereta a tungkul de Hisus kanya pan natipun i kaagtaan a makmuk a masakut a gepatalikngoy diya pati tangani papiyonin na i belang te manga orom. ");
INSERT INTO due_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kanya pan i Hisus ay kinumang de lugel a ilang tangani duman ay gepanalangin. ");
INSERT INTO due_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nun isin a adow ay nagtodu i Hisus de isin a beloy. Ta te duman pala a gelipa a Pariseo ide pati magtutodu ide ni Hudyo. Ta ide ay inumapo de kulukaginglan a sákup ni Galilea, Hudia pati de benwaan a hanga a Herusalem. Nano ay nun nanon a adow ay nagkaduman ngani i Hisus ni kapangyedihan ni Panginoon a Makedepat a gepapiyon de te manga orom ide. ");
INSERT INTO due_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ay te dinumatong pan a tipide a lalaki a te adde ide ni lungpo a náosong de pig-eden na ta pepelit de a pesilong un lungpo a popuoy de tebe de kasagkaden ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Misan ay dehil de makmuk a masakut i manga agta de pintohan ay an ide te nasesilan a nesilong kanya dinumawet ide de atop ta pinolkat de dingan pinaaroy de un pig-eden a te napaide a lungpo de gitna nun kaagtaan de kasagkaden ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nano ay nun matinggesan ni Hisus i kahanga ni pagpanulusun de diya ay sinabi na de lungpo, “Ayun, pinakaeyenan ka di ni mammalotin mo.” ");
INSERT INTO due_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nano ay i tipide a magtutodu ni Hudyo pati Pariseo ide ay nagdeinnawa a magioyo, “Aman la i Makedepat la i te kaya a gepakaeyen ni mammalotin ni kaagtaan kanya malot yo a ata ta pepadepade na i sadile na de Makedepat.” Inon i sinabi de. ");
INSERT INTO due_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Misan ay katinggesan pan ni Hisus i naddeinnawa de kanya sinabi na dide, “Wet kamo mag-uluesip ni maginon a malot. ");
INSERT INTO due_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ta talage a namas pa a mamiyen i sabiin ko de lungpo a ‘Pinakaeyenan ka di ni mammalotin mo,’ a an i ‘Gumiyos ka di ta addein mo i pig-eden mo na.’ ");
INSERT INTO due_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ta depat yu a matinggesan a ako a Pineta nun Makedepat a napa ni agta ay te kapangyedihan a gepakaeyen ni mammalotin dio de putok i kanya yeyedi ko i mahedep pa de pekita yu.” Ay dingan sinabi ni Hisus nunde lungpo, “Pesabi ko dikaw a gumiyos ka di ta addein mo i pig-eden mo na ta umuli ka di.” ");
INSERT INTO due_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dingan tambing a ginumiyos eya de pekita ni pesan ta inagkat na un pig-eden na a inumuli di ta nagpodi eya de Makedepat. ");
INSERT INTO due_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nano ay nagkaduman i pesan ni hanga a pagtaka kanya ide ay nagpodi de Makedepat a te kadugeng a takut ta sinabi de, “Talage ngani a nano kitam la nakakita ni magioyo a gepakataka.” ");
INSERT INTO due_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pagkatapos ninon ay tinumotul i Hisus ta pagtotul na ay kinta na i isin a magsisengil ni buwis a te ngalan a Lebi a gelipa de pigsingelan ni buwis ta sinabi diya ni Hisus, “Sumut ka deko.” ");
INSERT INTO due_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ta dingan inumuddi i Lebi a sinumut de Hisus ta winalat na i pesan a siningil na. ");
INSERT INTO due_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nano ay pinaghande pan ni Lebi i Hisus de beloy na ni hanga a papangan. Ta duman pala i kamakmokan a magsisengil ide pati kakmukan pa a agta a namangan. ");
INSERT INTO due_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Misan ay i tipide a Pariseo pati magtutodu ide ni Hudyo ay linumane de mag-aadel ide ni Hisus ta sinabi de, “Bekot pan ta gepakisaló kamo la de magsisengil ide pati de makikkakasalanan ide?” ");
INSERT INTO due_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Misan ay sinabi ni Hisus dide, “I an te orom ay an depat a gelawag ni magbubulong ta i te orom la i depat a gelawag. ");
INSERT INTO due_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ta anok dinumio a geolang de geesip ide a an ide te kasalanan ta dinumio ok ngani a geolang de makikkakasalanan ide.” Inon i sinabi dide ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nano ay nagtanto pa i tipide a agta de Hisus a magioyo, “Ugnay a an gepangan ni untik a panahon be gepanalangin i mag-aadel ide ni Huwen. Maginon pala i mag-aadel ide ni Pariseo ide ta i mag-aadel yu pan na ide ay getuloy a gepangan pati geinom.” ");
INSERT INTO due_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Misan ay tinubeg ide ni Hisus, “An depat a an námangan i inakit ide a gegewes de kásalan hanggen kakoloy de pa i lalaki a kinasal. ");
INSERT INTO due_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Misan be nádetong i panahon a an di i lalaki a kinasal ay dingan de panahon a inon ay malungkut i inakit ide a an ide namangan ni untik a panahon.” ");
INSERT INTO due_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Pati sinabi pa ni Hisus dide i oyo a halimbewa, “Talage a an te nemitas a misan ino de bowon a demit a getagpi de loma a demit ni kagisi a bowon. Ta be maginon ay negisi i bowon a demit pati an ide magkapadepade. ");
INSERT INTO due_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta am pala te geunid de loma a oniden a katat ni bowon a tayug a malanis. Ta be maginon ay sesede ngani ni bowon a tayug i oniden a loma ta ide ay padepade la a nakanugun. ");
INSERT INTO due_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kanya depat pan a oniden i bowon a tayug a malanis de bowon pala a oniden. ");
INSERT INTO due_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pati an te misan ino a te buot a nameinom ni bowon a tayug a malanis be nakinaman na i den a tayug ta sasabi la ni geinom a, ‘Piyon pa i den a tayug.’” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nano nun isin a adow ni paimloy ay sinumila ide Hisus de kaparayen ta nanggitol un mag-aadel na ide ni ohay nun paray a pinangan nun makokut de. ");
INSERT INTO due_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Misan ay sinabi ni tipide a Pariseo a, “Pagelawagin yu i peyedi ni mag-aadel yu na ide ta an nappaayun de pagdodul tam i peyedi de na be adow nun paimloy.” ");
INSERT INTO due_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Dingan tinumubeg i Hisus dide, “An yu man binasa i yinadi ni Hari a Debid pati mangaayun na ide nun ide ay natigeng? ");
INSERT INTO due_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ta sinumilong eya de beloy a pighandogen de Makedepat dingan namangan eya nun tinapay a hinandug di de Makedepat ta biniyen na pala i manga ayun na ide. Esipin yu a inon ay an nappaayun de pagdodul ide ta i nappatud a námangan ninon ay i maghahandug la ide. Misan an te kasalanan ide Debid.” ");
INSERT INTO due_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ta sinabi pa ni Hisus dide, “Pati depat pala a matinggesan yu a ako a Pineta nun Makedepat a napa ni agta ay nagkaddepat a nanabi a ti ano i nappatud de adow nun paimloy.” ");
INSERT INTO due_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nun isin pa a adow ni paimloy ay sinumilong i Hisus de isin a pigmitengan ni Hudyo ide a getodu eya. Te duman a isin a lalaki a nakkimaw i awenan na a kumot. ");
INSERT INTO due_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Misan ay pebentayen i Hisus ni tipide a Pariseo pati magtutodu ide ni Hudyo tangani kitain de ti pepapiyon na un lalaki nunde adow ni paimloy, a te nasasabi ide a pagsumbong diya. ");
INSERT INTO due_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Misan ay katinggesan pan ni Hisus i peesip de kanya sinabi na nunde lalaki a nakkimaw, “Dumio ka ta umuddi ka de kasagkaden ko i.” Ta inumuddi ngani un nakkimaw de kasagkaden na. ");
INSERT INTO due_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dingan sinabi ni Hisus de kaagtaan a magioyo, “Nappaayun man de pagdodul ide de adow nun paimloy a magyedi ni piyon o magyedi ni malot? Magligtas ni agta o mamuno?” ");
INSERT INTO due_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Dingan pinagelawag ni Hisus i kaagtaan a naddepalebut na ta sinabi na de lalaki, “Onatin mo i kumot mo.” Inonat ngani nun lalaki i kumot na ta pinumiyon dingani. ");
INSERT INTO due_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kanya nagengsa a masakut i Pariseo ide pati magtutodu ide ni Hudyo ta nasurutsurotan ide a ti ano i yeyedi de de Hisus. ");
INSERT INTO due_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nun nanon a panahon ay sinumakat i Hisus de pulupagotan a gepanalangin magdemag. ");
INSERT INTO due_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nano ay nun kinábiabian di ay pinakangan na i mag-aadel na ide dingan nagpeta eya dide ni sangpuwu pati aduwa a nginalanan na a mag-aatid na. ");
INSERT INTO due_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Te duman a Simon a nginalanan na a Pedro pati Andres a wele na. Ide Santiago pati Huwen. Ide Pilepi, Bartolome, ");
INSERT INTO due_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, Santiago a anak ni Alpeo, Simon a Masépag, ");
INSERT INTO due_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Hodes a anak ni Santiago pati Hodes Iskariyote a nagpadekop de Hisus de kapagebuk na ide. ");
INSERT INTO due_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nano ay dinumolug ide Hisus de isin a lugel a patag ta duman ide inumuddi pati makmuk na a mag-aadel. Ta nagidinatong i makmuk a kaagtaan a inumapo de kulukaginglan a sákup ni Hudia, de benwaan a Herusalem pati de pulupalebut a benwaan ide a Tiro pati Sidon a kagidkid ni atab. Nagidinoman ide a gepatalikngoy diya pati pepapiyon na pala i te manga orom ide. ");
INSERT INTO due_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pati i kakmukan a nagkahedepan dehil de manga libong de lawes de ay nagidinatong ta pinapiyon pala ide ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ta buot ni kamakmokan ay tapáin de i Hisus ta te duman a kapangyedihan a geapo diya a gepakapagpapiyon de manga orom a pesan. ");
INSERT INTO due_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dingan sinalepat ni Hisus i mag-aadel na ide ta sinabi na, “Piyon i kapuoyen yu a te pag-asa la de Makedepat ta te kapangyedihan dikamo i Makedepat a nanleligtas. ");
INSERT INTO due_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Piyon i kapuoyen yu a te hanga a pagbuot nano a geyedi ni kabuotan ni Makedepat ta pakebiyag kamo ni kapiyonan na. “Piyon i kapuoyen yu a nagkolungkut a getangos nano ta te duman kamo ngani a kasalegen. ");
INSERT INTO due_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Piyon i kapuoyen yu be ikamo ay pagkagengsaan, pepangalów, pelibek pati pesabian ni mammalotin a kabutelan dehil de pagpanulusun yu deko a Pineta nun Makedepat a napa ni agta. ");
INSERT INTO due_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ta de adow a inon ay depat kamo ngani a masalig a masakut ta hanga ngani i bilos yu de kataanan nun Makedepat. Ta maginon pala i yinadi a malot ni kaapoapohan de de magsasabi ide a den. ");
INSERT INTO due_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Misan ay talage a malot a masakut i násapit dikamo a gepinag-asa la de yaman yu dio de putok i ta tinanggep yu di i kapiyonan yu. ");
INSERT INTO due_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Pati malot pala i násapit dikamo a te manga sukul dio de putok i ta ang kamo pakebiyag ni kapiyonan na. “Talage a malot pala i násapit de nagkasalig ide nano ta ide ay nátangos pati náalaloy. ");
INSERT INTO due_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Malot pala i násapit dikamo be ikamo ay pepodi ni pesan a kaagtaan ta maginon i yinadi de de magsasabi ide a an matud. ");
INSERT INTO due_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pati pesabi ko dikamo a gepatalikngoy a buotin yu i kapagebuk yu ide. Magyedi kamo pala ni piyon de nagkagengsa ide dikamo. ");
INSERT INTO due_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Magpanalangin kamo para de gesumpa pati de gepahedep dikamo. ");
INSERT INTO due_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta be petampal de i pasingil yu ay pakadepit yu un dibelew. Pati be aamit ni misan ino i kulapyaw yu ay boyin yu pala pati bedu yu. ");
INSERT INTO due_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Biyen yu i belang geaged dikamo pati be te nangamit ni kasangkapan yu a misan ano ay wet yu di aamita a liwet. ");
INSERT INTO due_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pati misan an yediin dikamo ni kakmukan i piyon ay yediin yu la a tuloy i piyon de pesan a magi buot yu a yeyedi de dikamo. ");
INSERT INTO due_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nano be ikamo ay gebuot la de belang gebuot dikamo ay talage a ang kamo pagkasaligen ni Makedepat. Ta misan i makikkakasalanan ide ay gebuot pala ide de belang gebuot dide. ");
INSERT INTO due_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ta be ikamo ay geyedi ni piyon de geyedi la dikamo ni piyon ay talage a ang kamo pagkasaligen ni Makedepat. Ta misan i makikkakasalanan ide ay geyedi pala ni maginon. ");
INSERT INTO due_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ta be i belang pepaidem yu la ay i katinggesan yu a nakábeyed pala dikamo ay ang kamo a talage pagkasaligen ni Makedepat. Ta misan i makikkakasalanan ide ay gepaidem pala ide de kapadepade de a makikkakasalanan, a geasa pala a gebeyed i inumidem. ");
INSERT INTO due_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kanya yadi pa ay buotin yu i belang kapagebuk yu ta magyedi kamo dide ni piyon. Pati magpaidem kamo a ang kamo geasa de beyed ninon a pinaidem yu ta dingan hanga i bilos yu de Makedepat a kapiyonan. Pati katinggesan ni pesan a ikamo ay mangának ni Makedepat a Kaditasan ta eya pala ay mabeit de mammalotin a agta a an te pagpasalamat. ");
INSERT INTO due_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kanya mapa ni migkalbi kamo a magi Ama yu a Makedepat. ");
INSERT INTO due_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kanya wet yu pebintangan i misan ino tangani wet kamo hahatolan ni Makedepat. Ta wet yu hahatolan i misan ino tangani wet kamo podusahan ni Makedepat. Pati magpatáwad kamo tangani patawádin kamo pala ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Biyen yu i belang te kaelangan ta dingan bebiyen kamo ni Makedepat ni sukul pa a masakut. Ta i pansokat a pegemit yu de kakmukan ay eya pala i gegemit dikamo ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Dingan sinabi ni Hisus i oyo a halimbewa, “Talage a an nappatud a gekabitan i padepade a bulag ta ide ay padepade pala a nadegdeg de bulsut. ");
INSERT INTO due_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pati i mag-aadel ay an namas pa a maditas i kapangyedihan na de magtutodu na misan ay be natoduan a piyon i mag-aadel ay nattolad pala eya de magtutodu na. ");
INSERT INTO due_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kanya an depat a pelawag mo i kasalanan ni kabinsa mo a magi ulap de mata na ta misan ikaw pan ay am mo pesapot i namas pa a kasalanan mo a magi buwal de mata mo a sadili. ");
INSERT INTO due_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Talage a an nagkaddepat a sasabi mo de kabinsa mo, ‘Kabinsa, magsosol ka ni kasalanan mo.’ Ikaw i gesabi a am mod peyedi i malot misan ay peyedi mo mangan la ta ikaw pan ay am pala gesosol kanya depat ngona a magsosol ka dingan pa nappatud a sasabi mo de kabinsa mo, ‘Depat ka a magsosol de kasalanan mo ide.’ ");
INSERT INTO due_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Talage a an nappatud a i piyon a kew ay náanak ni an te kabuluhan ta am pala nappatud a náanak i malot a kew ni te kabuluhan. ");
INSERT INTO due_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kanya dehil de anak ni kew ay aabuyenan yu i kew ti piyon o malot. Pati ang kamo nappatud a nomulas ni igos de kew a te tinik ta an yu pala populas i obes de lanut a te manga tinik.” ");
INSERT INTO due_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sinabi ni Hisus a tuloy, “Talage a maginon pala i agta ta i agta a te piyon a innawa ay geyedi ni kapiyonan a geapo de innawa na pati pan i agta a te malot a innawa ay geyedi pala ni mammalotin a geapo de innawa na. Ta ti ano man i naddeinnawa ni agta ay inon ngani i sasabi na.” ");
INSERT INTO due_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Dingan sinabi na, “An te kabuluhan i pag-olang yu deko a ‘Panginoon ko’ be ang kamo getalinga de pesan a pagtodu ko dikamo. ");
INSERT INTO due_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Misan i belang agta a gelane deko, a gepatalikngoy a getalinga a tuloy de pagtodu ko ay paabuya ko dikamo i katolad de. ");
INSERT INTO due_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ta ide ngani ay magi naketingges a agta a nagyedi ni beloy ta pinakádisalad na a masakut un kutkut nun arigi a nakadetong de kabetoan. Nano ay nun binumulangay di a linabun un beloy na ni maslog ay an nagibe ta madisalad i pagkatapor nun arigi ide de kabetoan. ");
INSERT INTO due_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Misan ay i belang agta pan a gepatalikngoy deko, a an getalinga de pagtodu ko ay magi isin a an naketingges a agta a nagyedi ni beloy na de langges ta an madisalad i pagtapor ni arigi na. Dingan nun dinumatong i bulangay a hanga ay nagibe di un beloy na ta talage ngani a narukat di.” ");
INSERT INTO due_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nano ay pagkatapos ni Hisus a nagtodu ninon de manga agta ay kinumang eya de benwaan a Kapernam. ");
INSERT INTO due_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Misan ay te duman mangani duman a kapitan ni sundelo ide a tage Roma. I oyo a kapitan ay te katabeng a pebuot na a masakut ta i katabeng na ay te orom a mandeli di a nelibun. ");
INSERT INTO due_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nun mabereta ni kapitan a oyo i Hisus ay nanodul i kapitan ni tipide a pinakamatande a Hudyo a te manga tungkolin tangani magsabi de Hisus a kumang eya tebe duman a papiyonin na i katabeng na. ");
INSERT INTO due_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pagdetong ni pinakamatande ide de Hisus ay inaged de a mapelit diya ta sinabi de, “Depat tebe a kumang kamo duman a papiyonin yu i katabeng ni oyo a piyon a agta. ");
INSERT INTO due_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ta pebuot na ikitam a manga agta a tage Hudia pati pinagyedi na pan ikitam ni masampat a pigmitengan.” ");
INSERT INTO due_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dingan i Hisus pan ay sinumut dide. Nano nun ide ay alane di nunde beloy nun kapitan ay pinatagbu eya nun kapitan de mangaayun na ide ta pinasabi na diya, “Panginoon, wet kamo mag-abela ta an depat a nesilong kamo de beloy ko i ta ako ay an te kabuluhan. ");
INSERT INTO due_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ta isin pa duman ay naisepan ko a ako ay an te sukul a kabuluhan a násagkad dikamo ta sabiin yud la dio a piyon di i katabeng ko duman ay talage a nepiyon ngani. ");
INSERT INTO due_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ta misan ako pala ay pesákup ni pinakamaditas a ponu pati ako pan ay te nagkasakopan a manga sundelo ta be sabiin ko de isin a, ‘Tumotul ka,’ ay nototul eya. Be sabiin ko de isin pa a, ‘Dumio ka,’ ay nálane eya deko pati be de katabeng ko ay sabiin ko a, ‘Yediin mo yo i,’ ay yeyedi na ngani.” ");
INSERT INTO due_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nano ay nun inikna inon ni Hisus ay nagtaka eya diya ta sinumalepat de kaagtaan a nappaabut diya dingan sinabi na, “Pesabi ko dikamo a anok pa kinumita ni magioyo, kahanga a pagpanulusun misan deno a pulupalebut ni Israel.” ");
INSERT INTO due_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nano ay pag-ampulang nun dinodul ide ay dinatongan de de beloy, a piyon di un katabeng ni kapitan. ");
INSERT INTO due_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nano ay nun am pa náloy ay kinumang i Hisus de benwaan a te ngalan a Nain ta sinumut diya i mag-aadel na ide pati makmuk a kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nun ide ay alane di nunde git nun benwaan ay kinta de i nallibun a agta a náosong ni agta ide a i anak a lalaki a kádu ni belo a mahuna. Sinumut pala de belo i makmuk a kaagtaan de benwaan. ");
INSERT INTO due_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ay nun kinta ni Panginoon un belo ay nakalbi eya ta sinabi na diya, “Wet ka magtangos.” ");
INSERT INTO due_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Dingan i Hisus ay linumane ta binolan na i kabeong ta i nongosong pan ide ay tinumimok de pagtotul de ta sinabi ni Hisus, “Ulittaw, pesabi ko dikaw a gumiyos ka di.” ");
INSERT INTO due_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dingan tambing a ginumiyos un nallibun ta nagsurut a tuloy kanya eya ay binoy ni Hisus de ina na. ");
INSERT INTO due_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Talage a natakut i manga agta a kinumita misan ay nagpodi ide de Makedepat ta sinabi de, “Nano ay dinumatong dikitam i makapangyedihan a magsasabi ta talage ay nakalbi di i Makedepat de manganak na a manga agta ta peligtas na ide.” ");
INSERT INTO due_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nano i oyo a bereta a tungkul de Hisus ay kinumálat de kulukaginglan ni sákup ni Hudia pati de pulupalebut a inon. ");
INSERT INTO due_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Inon ide a manga yinadi ni Kristo ay binareta de Huwen a Maglilenod ni mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kanya pinalane ni Huwen diya i aduwa a mag-aadel na tangani pakang na ide de Panginoon a getanto ide a magioyo, “Ikamo man di i Pinangako nun Makedepat a nádetong o geilat kami pa ni kakmukan?” Maginon i pepatanto ni Huwen. ");
INSERT INTO due_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ta pagdetong de de Hisus ay sinabi de, “Ikami ay pinakang dio ni Huwen a Maglilenod tangani ikami ay getanto dikamo a magioyo, ‘Ikamo man di i Pinangako nun Makedepat a nádetong o geilat kami pa ni kakmukan?’” ");
INSERT INTO due_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nun nanon pan a odes ay makmuk i pinapiyon ni Hisus a te manga orom, bulag pati te manga libong de lawes de. ");
INSERT INTO due_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ta tinumubeg i Hisus dide, “Umampulang kamo de Huwen ta sabiin yu i pesan a inikna yu pati kinta yu dio. Ta i bulag ide ay nakakita di. I pilay ide ay nakatotul di. I te ketong ide ay pinumiyon di. I bingol ide ay nakaikna di. Ta i nallibunin ide ay nagkeedup. Pati gesabi ok ni piyon a bereta de mahedepin ide. ");
INSERT INTO due_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Talage a piyon i kapuoyen ni misan ino a an te aduwa esip tungkul deko.” Inon i sinabi ni Hisus dide. ");
INSERT INTO due_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pagkatotul ni mag-aadel ide ni Huwen ay sinabi ni Hisus de kaagtaan ide i tungkul de Huwen a magioyo, “Talage ay nun kinumang kamo de Huwen duman de lugel a ilang ay an yu eya kinta a te aduwa a esip a magi tangbu a nagketigun ni palos. ");
INSERT INTO due_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pati an yu pala eya kinta a gedemit ni masampatin ta talage i gedemit ni maginon ay te piyon a edup a getaan pa de beloy ide a hanga ni hari ide. ");
INSERT INTO due_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kanya kamo kinumang ay buot yu a nekita ni magsasabi nun Makedepat. Ta kinta yu pan di eya a te kapangyedihan pa a namas de magsasabi a den nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ta te duman tungkul de Huwen de kasulatan a den i sinabi nun Makedepat a magioyo de Pinangako na, ‘Patalikngan mo ta pakang ko i mag-aatid ko a náona dikaw a gehande ni sesilan mo.’” ");
INSERT INTO due_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sinabi ni Hisus a tuloy dide, “Pesabi ko ngan dikamo ay gepo nun nowon hanggen nano ay namas pa de pesan a agta ay nagkaduman ni kapiyonan ni Makedepat i Huwen. Misan ay gepo de nano ay namas pa de Huwen ay gekaduman ni kapiyonan ni Makedepat i belang gepanulusun deko misan untik i kapangyedihan de.” ");
INSERT INTO due_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nano ay nun inikna a piyon ni manga agta pati magsisengil ide ni buwis i pagtodu ni Huwen ay nagpamatud ide a ide ay te mammalotin de pekita ni Makedepat kanya lininod ide ni Huwen de orat. ");
INSERT INTO due_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Misan ay i Pariseo pan ide pati magtutodu ide ni Hudyo ay pinakaeyenan de ni kabuluhan i belak a piyon dide ni Makedepat kanya an ide nagpalinod de Huwen. ");
INSERT INTO due_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sinabi ni Hisus a tuloy, “Misan ti deno ko pekipadepade i manga agta de oyo a panahon? ");
INSERT INTO due_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Talage ide ay magi mangának a kalipalipa de piggewesan de a gepinag-olang de kagewes de ide ta sasabi de de kakmukan a mangának a, ‘Ikami ay nagtugtug di ni masampat misan ay ang kamo pa sinumayew pati ikami ay nagkanta dikamo ni malungkut misan ang kamo tinumangos.’ ");
INSERT INTO due_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ikamo ngani a manga agta de nano a panahon i kapadepade ni mangának ide a inon. Ta nun dinumatong di i Huwen a an namangan ni untik a panahon a an nag-inom ni tayug a malanis ay sinabi yu a eya ay te libong de lawes na. ");
INSERT INTO due_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Misan ay nun dinumio ok a Pineta nun Makedepat a napa ni agta a gepangan pati geinom ay pesabi yu pan a, ‘Pagelawagin yu i agta a oyo ta matakaw pati migbugnang ta ayun pa eya ni magsisengil ide ni buwis pati makikkakasalanan ide.’ ");
INSERT INTO due_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Misan ay gepakita i Makedepat a eya ay naketingges de padean ni attanan a piyon a pagyedi ni katabeng na ide.” ");
INSERT INTO due_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nano ay inakit ni isin a Pariseo i Hisus a námangan de beloy na ta kinumang pan i Hisus a sinumagkad de pamangan. ");
INSERT INTO due_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","De benwaan pan a inon ay te duman a isin a mahuna a peabuyenan a makikkakasalanan. Ta nátinggesan na pan a i Hisus ay duman gepangan de beloy ni Pariseo kanya nangadde eya duman ni isin a oniden a mabengo a langis. ");
INSERT INTO due_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pagdetong na duman ay linumane eya de singitan ni Hisus de idogen a kadepit a nagtangos. Ta nabesá di ni luwa na i singit ide ni Hisus ta pinunasan na ni sapok na i singit na. Pati inangutan na dingan pinalisan na nun mabengo a langis. ");
INSERT INTO due_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Misan ay nun kitain yo nun Pariseo a nangakit de Hisus ay dinainnawa na a magioyo, “Be matud yo a magsasabi nun Makedepat ay katinggesan na i oyo a mahuna a getapá diya ay makikkakasalanan.” ");
INSERT INTO due_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Dingan tinumubeg i Hisus de Pariseo, “Simon, ako ay te duman a sasabi dikaw.” Ta tinumubeg pan i Pariseo, “Hale di, sabiin yu di, magtutodu.” ");
INSERT INTO due_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sinabi diya ni Hisus, “Te aduwa a lalaki a te manga otang de isin a gepaotang. Nano ay i isin dide ay te otang ni lima a dian ta i isin pan ay lima la a puwu. ");
INSERT INTO due_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nano ay nun an di ide te kaya a gebeyed ay pinaaged na di nunde aduwa un otang de. Ino nano ay te hanga pa a pagbuot de gepaotang?” ");
INSERT INTO due_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Dingan tinumubeg i Simon, “Ay sigudu i te hanga pa a otang.” “Ay-o, matud ngani i tinubeg mo.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kanya liningoy ni Hisus un mahuna ta sinabi na de Simon, “Pagelawagin mo i mahuna a oyo ta nun sinumilong ok dio de beloy mo ay anok mo biniyen ni orat a ponguges ko de singit ko a te delpong misan ay i mahuna a oyo ay inugesan na ni luwa na i singit ko dingan pinunasan na ni sapok na. ");
INSERT INTO due_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Pati anok mo binate a inangutan misan eya, gepo nun sinumilong ay an getimok a geangut de singit ko. ");
INSERT INTO due_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ta am mo pala pinalisan ni langis, misan mora, i ulo ko ta eya pan ay pinunasan na i singit ko ni langis a mahal. ");
INSERT INTO due_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kanya pesabi ko dikaw a pinakaeyenan di eya ni mammalotin na a makmuk ta hanga pala i pagbuot na deko misan i pinakaeyenan ni untik ay untik pala i pagbuot na deko.” ");
INSERT INTO due_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dingan sinabi ni Hisus de mahuna, “Pinakaeyenan ka di ni mammalotin mo.” ");
INSERT INTO due_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","I kakmukan ide a kasaló na ay nagdeinnawa ide a magioyo, “Inóman yo a agta a te kapangyedihan a gepakaeyen ni mammalotin ni manga agta?” ");
INSERT INTO due_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Misan ay sinabi ni Hisus de mahuna, “Naligtas ka di dehil de pagpanulusun mo deko. Tumotul ka di a te kasampatan a innawa.” ");
INSERT INTO due_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nano ay nun am pa náloy ay dingan linebut ni Hisus de bulubenwaan pati de buluberiyu ide ta eya ay nagtodu ni piyon a bereta a ti papalano a te kapangyedihan i Makedepat de innawa ni agta. Ta kakoloy na i sangpuwu pati aduwa a mag-aadel na. ");
INSERT INTO due_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pati tipide a mahunain a pinalayuan na de mamalot a libong pati pinapiyon na de orom de. Isin dide ay i Maria a te ngalan a Magdalena a pinalayuan na de pito a libong. ");
INSERT INTO due_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ta duman pala i Huwana a bebi ni Kusa. I Kusa i gepamahala ni Hari a Herod. Kakoloy de pala i Susana pati kakmukan pa ta tinabengan de ni keedup de, ide Hisus a magi kabinsa de. ");
INSERT INTO due_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nano ay nagiinapo de bulubenwaan i makmuk a masakut a manga agta ta nun kinatipunan de i Hisus ay nagtodu eya de padean ni halimbewa a oyo, ");
INSERT INTO due_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Te duman a isin a agta a kinumang a gesapwar ni binhi na. Ay te nadegdeg pan de kaginglan ni bektas ta nagkasikaden la pati pinangan pan la ni kamanokan. ");
INSERT INTO due_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Te nadegdeg pan de kabetoan a an mokpal i putok misan ay narango la un tubu ide ta an te sukul a besabesá. ");
INSERT INTO due_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Te duman pala a nadegdeg de katinekan ta dingan nun hinumangain di un tinik ide ay natalo di un tinumubu a binhi. ");
INSERT INTO due_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Misan ay te duman pan a nadegdeg de piyon a putok kanya hinumanga a i napa ni anak na ay te duman isin a dian a butil.” Dingan sinabi ni Hisus a malagdu a dugsong, “I misan ino a gepatalikngoy ay depat a tumalinga.” ");
INSERT INTO due_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nano ay nagtanto de Hisus i mag-aadel na ide a tungkul de halimbewa. ");
INSERT INTO due_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tinumubeg eya dide, “Dikamo a gepanulusun deko ay pepatingges i madisalad a kamatoden a ti papalano a te kapangyedihan i Makedepat de innawa ni manga agta misan ay para de kakmukan ay getodu ok de padean ni halimbewa ide ta misan pekita de ay an de pesapot pati misan peikna de ay an de pagketinggesan. ");
INSERT INTO due_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nano ay wiyo i kabuluhan ni halimbewa a inon. Ta i katolad ni binhi a sinapwar ay i surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","I kaginglan ni bektas a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat misan ay pagkapatalikngoy de ay nádetong i Satanas a nángagow ni surut a naddeinnawa de tangani an ide nonulusun a nalligtas. ");
INSERT INTO due_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nano ay i kabetoan pan a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat a nonulusun a te salig a masakut. Misan an matud i pagpanulusun de ta an te ramut kanya an ide notuloy ta pagdetong ni tukso a kahedepan ay nallagelag ide. ");
INSERT INTO due_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","I katinekan a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat misan ay dehil de pag-esip de ni attanan dio pati de pagbuot de de kayamanan pati de belang buot de a kasalegen dio de putok i ay nadeog, a an gekitong i surut a naddeinnawa de. ");
INSERT INTO due_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nano ay i piyon a putok a kinadegdegen ni binhi ay magi agta ide a gepatalikngoy de surut nun Makedepat. Ta inon ay tinanggep de de innawa de a naponulusonan a malenis. I oyo ide i gepinag-anak a matiyage. ");
INSERT INTO due_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Talage a be te duman a getudtud ni salong ay an na sasakloben ni takalan o popuoy de saruk ni pig-idean na ta popuoy na pan de talage a pigpuoyen na tangani kekita ni nesilong ide i sesikaden de. ");
INSERT INTO due_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pati an te nattagu a an kekita pati an te nattanom de innawa a an ketinggesan a eikna. ");
INSERT INTO due_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kanya pakapiyain yu i pagpatalikngoy yu ta i misan ino a getalinga de pagtodu ko ay naddugenan i katinggesan na misan ay i an getalinga de pagtodu ko ay neeyen i katinggesan na a untik a peesip na a te duman.” ");
INSERT INTO due_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nano ay dinumatong i ina pati manga wele a lalaki ni Hisus misan ay an ide gepakalane diya dehil de makmuk a masakut i kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kanya nagsabi ide diya, “Dena de ditow to i ina yu pati manga wele yu ta buot de ikamo a nakkasurut.” ");
INSERT INTO due_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Misan ay sinabi ni Hisus, “Inóman a gepatalikngoy a getalinga de surut nun Makedepat ay ide ngani i magi ina ko pati manga wele ko.” ");
INSERT INTO due_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nun isin a adow ay sinumakoy i Hisus pati mag-aadel na ide nunde bengka ta sinabi na dide, “Sumabusabu kitam di de dipa to.” Kanya pan ide ay te gepo di a gesabusabu. ");
INSERT INTO due_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nano ay nun gesabusabu pa ide ay napapede i Hisus ni untik dingan dinumatong pan dide i maslog a subesko kanya un bengka de ay mandeli a nepino ni orat a mandeli di a nelinod. ");
INSERT INTO due_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kanya i mag-aadel ide ay linumane de Hisus ta binogbog de eya a sinabi de, “Magtutodu, noomos kitam di.” Ta ginumiyos i Hisus ta sinablow na i palos pati desi dingan tinumimok ngani un palos pati desi ta piyon di i panahon. ");
INSERT INTO due_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Dingan sinabi na dide, “Deno i pagpanulusun yu deko?” Ay nagtaka ide a te takut a natulutantoan ide, “Ano man yo a kalase a agta ta pati i palos, atab ay nagkasablow na a getalinga pan ide diya.” ");
INSERT INTO due_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nano ay dinumatong ide de dipa de lugel ni Gadareno a tipong ni Galilea. ");
INSERT INTO due_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pagkalusong ni Hisus nunde langges ay tinagbu eya ni isin a lalaki a te manga libong de lawes na. Ta naloy di a panahon ay eya ay obe di a an geuli de benwaan na ta eya ay nappataan dila de pigtaporan. ");
INSERT INTO due_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ugnay a te kapangyedihan de lawes nun lalaki un isin a libong kanya misan bentayen ni agta ide a naggiptan pa ni tanikala de kumot pati singit na ay nagkopulupugtus na la ta eya ay peikag nun libong ide de lugel a ilang. Nano ay pagkakita na de Hisus ay inumolang eya ni malagdu a inumobbob de kasagkaden na. Ay dingan nun dinodul ni Hisus i libong a lumayu de lawes ni lalaki ay sinabi nun libong a malagdu, “Hisus kamo a Anak nun Makedepat a Kaditasan, bekot ta peabela yu ikami? Dehil de Makedepat ay geaged kami a masakut dikamo a wet yu ikami pehedepan.” ");
INSERT INTO due_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dingan tinanto eya ni Hisus, “Ano man i ngalan mo?” Tinumubeg un kalibongan, “Ikami ay manga lebu.” Ta makmuk a libong i linumane nunde lalaki. ");
INSERT INTO due_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dingan ide ay nag-aged de Hisus ta sinabi de, “Wet yu ikami patagbonga de madisalad a madumos a an te kalog.” ");
INSERT INTO due_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Nano ay nunde karipakip nun pagotan ay te duman pan a hanga a kalugbuwen ni kabebuyen a gepinagpangan. Ta nag-aged i libong ide a mahigpit de Hisus a pakangin na ide de lawes ni kabebuyen a inon ta tinumalinga pan i Hisus. ");
INSERT INTO due_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kanya linumayu i libong ide de lawes nun lalaki ta linumane ide de lawes nun bebuy ide ta dingan loktat a nagiginekan un kabebuyen a padolug de rongtob a paagow de uluataben ta naomos ide duman. ");
INSERT INTO due_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nun kinta nun mag-aalage ide nun kabebuyen inon a nangyedi ay nagiginekan pala ide ta binareta de de benwaan pati buluberiyu ide i pesan a nangyedi nunde kabebuyen. ");
INSERT INTO due_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kanya pan nagibinulwag i kaagtaan ide tangani kitain de i nangyedi duman. Pagdetong de de kaddumanan ni Hisus ay kinta de i lalaki a linayuan ni libong ide. Ta eya ay gelipa de kasagkaden ni Hisus a piyon di i esip na, a nappabedu di kanya natakut a masakut i dinumatong ide. ");
INSERT INTO due_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ta sinabi pan dide nun nakakita ide a ti papalano a pinumiyon i te libong a lalaki. ");
INSERT INTO due_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dingan inaged ni tage sákup ni Gadareno ide a i Hisus ay tumotul de lugel de ta nagkatakut ide a masakut kanya sinumakoy i Hisus nunde bengka a inumampulang de dipa. ");
INSERT INTO due_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Misan ay dingan ngona tinumotul ide Hisus ay nag-aged pa a mahigpit un linayuan ni libong ide a eya ay ikagin na misan ay pinatotul eya ni Hisus ta sinabi na, ");
INSERT INTO due_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Umuli ka di ta beretain mo de mangáyun mo i pesan a kapiyonan a yinadi dikaw ni Makedepat.” Dingan inumuli ngani un lalaki ta binareta na de benwaan na i kapiyonan a yinadi diya ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nano ay pagkadetong nide Hisus de dipa nun uluataben ay tinanggep eya a piyon ni kaagtaan ta nag-ilat ide a masakut diya. ");
INSERT INTO due_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ay dingan te dinumatong pan a isin a lalaki a te ngalan a Hayro a pinakamatande de pigmitengan a Hudyo ta eya ay inumobbob de kasagkaden ni Hisus, a nag-aged a mahigpit a kumang tebe i Hisus de beloy na. ");
INSERT INTO due_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ta i anak na a kádu a mahuna ay mandeli a nelibun. I katande ni maddikit ay manga sangpuwu pati aduwa a taon. Nano de pagtotul nide Hisus ay nagkassilpit eya ni makmuk a masakut a kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta te duman a mahuna a te orom a gesagu ni sangpuwu di pati aduwa a taon a an nagkapapepiyon ni magbubulong ide misan naubus di i pesan a keedup na dide. ");
INSERT INTO due_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nano ay linumane un mahuna de idogen ni Hisus ta tinumapá eya de rimong ni bedu na dingan tambing di a tinumimok i pagsagu na. ");
INSERT INTO due_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tinanto ni Hisus, “Inóman i nanapá deko?” Nano ay nun i pesan ay gepangeyen ay sinabi ni Pedro pati kakoloy na ide, “Panginoon, i kaagtaan ay nasulusilpetan dikamo de palebut yu.” ");
INSERT INTO due_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Misan ay sinabi ni Hisus, “Talage a te duman ngani a nanapá deko ta binatyeg ko a binulwagen ok ni kapangyedihan a gebulong.” ");
INSERT INTO due_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nano nun matinggesan ni mahuna a an eya nakatagu ay linumane eya de Hisus a gekinkin ta inumobbob de kasagkaden na ta de peikna ni kaagtaan ay sinabi na a ti ano ta tinapá na i Hisus. Pati sinabi na pala ti papalano ta eya ay napiyon a tambing. ");
INSERT INTO due_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ta sinabi pan diya ni Hisus, “Mahuna, pinapiyon ka di ni pagpanulusun mo deko kanya umuli ka di a te kasampatan a innawa.” ");
INSERT INTO due_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Misan ay nun gesurut pa i Hisus ay te dinumatong a inumapo de beloy ni Hayro a nagsabi, “Nalibun di i anak yu. Wet yud abelaa i magtutodu na.” ");
INSERT INTO due_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nano ay nun inikna yo ni Hisus ay sinabi na de Hayro, “Wet ka matakut ta magpanulusun ka la deko ta nepiyon un anak mo.” ");
INSERT INTO due_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pagdetong nide Hisus nunde beloy ay an eya te inikag a sinumilong ti an i Pedro, Huwen, Santiago, pati kamoddenan nun maddikit a nallibun. ");
INSERT INTO due_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nano ay nagtangos a nagipinagkagulhol i pesan duman misan ay sinabi dide ni Hisus, “Wet kamo magtangos ta an la nalibun i anak ta nappede la.” ");
INSERT INTO due_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ta pinag-ilokan de eya ta katinggesan de a nalibun di eya. ");
INSERT INTO due_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Misan ay binolan ni Hisus de kumot na ta sinabi na a malagdu, “Maddikit, gumiyos ka di.” ");
INSERT INTO due_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dingan naedup dingani a liwet un nallibun ta inumuddi a tambing ta dinodul ni Hisus de magkálaki a biyen de eya ni pápangan. ");
INSERT INTO due_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nagtaka i kamoddenan nun maddikit misan ay tinutugun dide ni Hisus a wet de sasabia misan dino i nangyedi a inon. ");
INSERT INTO due_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nano ay tinipun ni Hisus i sangpuwu pati aduwa a mag-aadel na ta biniyen na ide ni tibong pati kapangyedihan a gepalayu ni manga libong ide de lawes ni manga agta, a gepapiyon pala ide ni te manga orom ide. ");
INSERT INTO due_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ta ide ay pinakang na a gesabi a ti papalano a te kapangyedihan i Makedepat de innawa ni agta, a nagpapiyon pala ide ni te manga orom. ");
INSERT INTO due_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Dingan ngona pinakang na ide ay sinabi na, “Wet kamo nángadde ni misan ano de pagtotul yu misan sugkud, soput, pápangan, kuwarta pati bedu a panlewes ta i isin ay sukul la.” ");
INSERT INTO due_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sinabi na a tuloy, “Misan deno kamo a beloy nekitaan ay duman kamo la magpilong hanggen ang kamo getotul de inon a lugel. ");
INSERT INTO due_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nano pan be an de ikamo petanggep de misan deno a lugel ay pagpagin yu i delpong de singit yu a tande a kinapoyen de i surut nun Makedepat ta dingan tumotul kamo duman.” ");
INSERT INTO due_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dingan nun makapagtutugun di dide i Hisus ay nagitinotul ide, a sinumulusagid de buluberiyu ide, a nagsabi ni piyon a bereta pati nagpapiyon ide ni te manga orom ide misan deno a kadepit. ");
INSERT INTO due_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nano ay nakadetong de Gubernador a Herod de Galilea i bereta a tungkul de pesan a peyedi ni Hisus kanya nagkelito i esip na ta te nagsabi kon a pinakaedup di a liwet i Huwen a Maglilenod. ");
INSERT INTO due_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Te gesabi pan a eya ay i Elias a magsasabi a den a nagpakita. Pesabi pala ni tipide a eya ay isin de magsasabi ide a den a pinakaedup di a liwet. ");
INSERT INTO due_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Misan sinabi pan ni Herod a, “I Huwen ay pinaputolan ko ni bong kanya ino i pebereta a iwina?” Ta buot na a masakut a kekita i Hisus. ");
INSERT INTO due_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nano ay nun inumampulang un mag-aatid ide de Hisus ay sinabi de diya i pesan a nayedi de. Dingan inikag na la ide a pelayu de kamakmokan a paagow de sulusákup ni benwaan a Betsaida. ");
INSERT INTO due_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Misan ay nun matinggesan pan ni kamakmokan a tinumotul di ide Hisus ay inumabut ide diya. Ta tinanggep na pan ide a piyon, a nagtodu eya dide a ti papalano a te kapangyedihan i Makedepat de innawa ni agta pati pinapiyon na pala i te manga orom ide a te kaelangan. ");
INSERT INTO due_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nano ay nun apun di a masakut ay linumane de Hisus i sangpuwu pati aduwa a mag-aadel na ta sinabi de, “Pakangin yu di i kaagtaan de buluberiyu pati de binaloybeloy de pulupalebut na tangani manggetang ide ni pápangan de, a nekipilong pala a tuloy ta i kaddumanan tam i ay lugel a ilang.” ");
INSERT INTO due_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Misan ay tinubeg na dide, “Ikamo ngani i nongungut dide.” Ay tinumubeg pan ide diya, “Lima la i tinapay tam pati aduwa a ikan be ang kami nágetang pa ni sukul a pápangan ni agta ide a oyo.” ");
INSERT INTO due_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ta i manga lalaki ay manga lima a lebu. Dingan sinabi na de mag-aadel na ide, “Palipain yu i kaagtaan a nattipuntipun a manga tiglilima a puwu i belang isin a tipun.” ");
INSERT INTO due_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kanya maginon ngani i yinadi ni mag-aadel ide ta pinalipa de i pesan. ");
INSERT INTO due_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ta dingan inamit ni Hisus i lima a tinapay pati aduwa a ikan. Ta tinumingala eya de langot a nagpasalamat dingan pinisangpisang na un tinapay ide a binoy na de mag-aadel na ide. Ta ide pan i nagbuluboy de kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nakapangan ide a pesan a sukul. Nano nun tinipun de un an de naubus a kulukapisang ay nakapinu ide ni sangpuwu pati aduwa a gelálan. ");
INSERT INTO due_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nano ay nun isin a adow ay nanalangin i Hisus a kakoloy na la i mag-aadel na ide. Tinanto na ide a magioyo, “Ino ok kon pesabi ni kaagtaan?” ");
INSERT INTO due_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dingan tinumubeg ide diya, “I pesabi ni tipide ay i Huwen kamo a Maglilenod. I kakmukan pan ay pesabi de a ikamo ay i Elias pati te duman pa a gesabi a ikamo ay isin de magsasabi a den a pinakaedup a liwet.” ");
INSERT INTO due_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Dingan tinanto na ide, “Ikamo pan ay ano i nasasabi yu tungkul deko? Ino ok?” Ta tinumubeg i Pedro, “Ikamo ay i Kristo a Pinangako nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dingan sinabi dide ni Hisus a, “Wet yu sasabia misan dino ti ino ok ngani.” ");
INSERT INTO due_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ta sinabi pa ni Hisus dide, “Ako a Pineta nun Makedepat a napa ni agta ay depat a getiis ni makmuk a kahedepan ta kakapoyen ok ni pinakamatande ide, ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo. Ta pobuno ok de a tuloy misan ay de katiluwon a adow ay pakeedup ok a liwet.” ");
INSERT INTO due_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dingan sinabi na dide a pesan, “I misan ino a te buot a nappa ni mag-aadel ko ay depat a kapoyen na ngona i kabuotan na a sadili ta depat a magtiis adow adow ni kahedepan a kosa na a innawa a magi ako dingan geabut pala de ugeli ko. ");
INSERT INTO due_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta i te buot a gealáge de edup na dio de putok i ay neeyenan ninon misan ay i geboy ni edup na para deko ay eya ngani i gekaduman ni edup a bowon. ");
INSERT INTO due_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Talage a an te pakinabeng a matud i misan ino a agta a te adi ni pesan dio de putok i, a am pan te duman a edup a bowon. ");
INSERT INTO due_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nano ay be te duman a agta a pagkammamos na i pagpamatud na a tungkul deko pati de pagtodu ko ay dingan eya ay kammamos ko pala a Pineta nun Makedepat a napa ni agta paglusong ko a te gepakaingap a sadili pati gepakaingap ni Ama a Makedepat a te kakoloy ok pala ni manga anghel na ide. ");
INSERT INTO due_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Talage ay pesabi ko dikamo a matud a te duman dikamo a an nelibun hanggen an de kekita i paggepo ni kapangyedihan ni Makedepat de innawa ni agta.” ");
INSERT INTO due_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pagkasabi na ninon ay tinumakig i manga walo a adow dingan inikag na i Pedro, magwele a Santiago pati Huwen de isin a kalasan a nagpanalangin ide duman. ");
INSERT INTO due_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nun gepanalangin di i Hisus ay nagkobowon di a masampat i ropa ni mukha na ta i bedu na ay napa ni malapsay di a masakut a gepakaingap. ");
INSERT INTO due_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Dingan loktat a gepakisurut diya i aduwa a lalaki a i Moises pati Elias a magsasabi ide a den. ");
INSERT INTO due_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ta ide pala ay pinakita a te gepakaingap ta nasurutsurotan ide ni tungkul de ti papalano a bobuno i Hisus de Herusalem a nappaayun de kabuotan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nano ay napapede ngani ide Pedro pati mangáyun na misan ay napagiyos la ide nun kinta de i gepakaingap ni aduwa a kauluuddi pati Hisus. ");
INSERT INTO due_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Dingan nun nototul di i aduwa a lalaki ay sinabi ni Pedro de Hisus, “Panginoon, yadi pa ay dio kitam di ta geyedi kami ni tiluwon a pigpilongan, isin dikamo, isin de Moises pati isin pala de Elias.” Misan ay dehil de nagkelito i esip ni Pedro ay an na kinatinggesan i sinabi na. ");
INSERT INTO due_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Dingan nun gesurut pa eya ay kinumalinongan dide i kunom ta ide ay natakut nun nataklopan ide ni kunom. ");
INSERT INTO due_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ta te inumapo duman de kunom a surut a magioyo, “I oyo i Pineta ko a Anak kanya magtalinga kamo diya.” ");
INSERT INTO due_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nano ay nun matimok di un surut ay kinta ni mag-aadel ide a lallan dila i Hisus duman. Misan ay ang ngona te sinabi i mag-aadel ide tungkul de kinta de duman misan dino a agta. ");
INSERT INTO due_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nano ay nun kinábiabian a dinumolug ide Hisus nunde kalasan ay tinagbu eya ni makmuk a kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Te isin pan nunde kamakmokan a lalaki a geolang a magioyo, “Magtutodu, kalbian yu tebe i anak ko i a lalaki a kádu. ");
INSERT INTO due_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ta te kapangyedihan i libong de lawes na a gepaolang diya a loktat, a gepaporewos pati nagkopugtusan. Pati geburak i nguso na ta eya ay pepahedepan a masakut ni oyo a libong a an na pewalat. ");
INSERT INTO due_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Misan ay nun inaged ko de mag-aadel yu ide a palayuin de un libong ay an de napalayu.” ");
INSERT INTO due_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ta tinumubeg i Hisus, “Ikamo a kaagtaan de nano a panahon ay an depat a naponulusonan a migkalagelag. Hanggen kapide ok man depat a kakoloy yu a getiyage dikamo.” Dingan sinabi na de lalaki, “Addein yu dio i anak yu.” ");
INSERT INTO due_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nano ay nun palane pa de Hisus un anak ay pinadegmak eya nun libong a pinaporewos a masakut. Misan ay dinodul ni Hisus un libong a lumayu de lawes na. Ta pinumiyon di un anak dingan inampulang eya ni Hisus nunde ama na. ");
INSERT INTO due_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","I manga agta pan ay nagtaka a masakut dehil de kapangyedihan a masakut ni Makedepat. Ta nun nagtaka pala i kaagtaan dehil de pagyedi ni Hisus a gepakataka ay sinabi na de mag-aadel na ide, ");
INSERT INTO due_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Esipin yu a masakut i sasabi ko a oyo dikamo ta ako a Pineta nun Makedepat a napa ni agta ay padekop nunde manga agta.” ");
INSERT INTO due_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Misan ay an de kinatinggesan i buot na a sasabi ta i oyo ay tinagu dide tangani an de matinggesan. Ta nagkatakut pan ide a getanto diya de sinabi na a inon. ");
INSERT INTO due_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nano ay natulutantoan i mag-aadel na ide a ti ino i nappa ni maditas pa dide. ");
INSERT INTO due_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Misan ay nun katinggesan pan ni Hisus i pedeinnawa de ay pinalane na diya i isin a anak. ");
INSERT INTO due_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ta sinabi na de mag-aadel na ide, “I misan ino a getanggep a piyon dehil deko ni magi anak a oyo a te masidong a innawa ay ako ngani i petanggep na. Pati pan i getanggep deko ay petanggep na pala i nagdodul deko. Ta i te masidong pa a innawa dikamo ay eya ngani i nappa ni maditas pa de pesan.” ");
INSERT INTO due_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Dingan nagsurut diya i Huwen ta sinabi na, “Magtutodu, te duman kami a kinta a isin a agta a nagpalayu ni libong de lawes ni agta gepo de makapangyedihan a ngalan yu misan ay sinablow mi eya ta an tam eya kakoloy.” ");
INSERT INTO due_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Misan ay tinubeg eya ni Hisus, “Wet yu eya sablowa ta i misan ino a an tam kapagebuk ay kakoloy tam.” ");
INSERT INTO due_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nano ay nun nagkallane di i adow a nádelangot di i Hisus ay binuot na a masakut a kumang ngona de Herusalem. ");
INSERT INTO due_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ta pinapaona na pan i mag-aadel na ide de isin a beriyu de sákup ni Samaria. Ta ide ay sinumilong a gelawag ni tataanan na duman. ");
INSERT INTO due_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Misan ay an eya petanggep duman ta katinggesan de a eya ay Hudyo a nákang de Herusalem tangani magpodi. ");
INSERT INTO due_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Dingan sinabi nide Santiago pati Huwen a mag-aadel na nun an ide tinanggep duman, “Panginoon, buot yu man a magpalusong kitam ni apoy gepo de langot tangani mapuksa ide?” ");
INSERT INTO due_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Misan ay linumingoy i Hisus ta ide ay sinosol na ta sinabi na, “An yu katinggesan i esip yu a inon a an inumapo de Makedepat ta ako a Pineta na a napa ni agta ay dinumio tangani leligtas ko i manga agta, a an tangani ide ay popuksa.” ");
INSERT INTO due_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dingan kinumang ide de kakmukan a beriyu. ");
INSERT INTO due_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nunde pagtotul de ay sinabi diya ni isin a magtutodu ni Hudyo, “Ay náabut ok dila dikamo a nappa ni mag-aadel yu misan deno kamo paagow.” ");
INSERT INTO due_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ta tinubeg eya ni Hisus, “Uluesipin yu ngona ta te pigtaanan a bulsut i hayup ide pati i manok ide ay te pig-aponan misan ako a Pineta nun Makedepat a napa ni agta ay anok te pigtaanan a sadili a pigpaimloyen.” ");
INSERT INTO due_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Dingan sinabi ni Hisus de isin pa a lalaki, “Umabut ka deko.” Misan ay sinabi na, “Panginoon, pabiyaan ok yu ngona a nouli tangani aalagean ko i ama ko hanggen an nagkelibun.” ");
INSERT INTO due_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Misan ay tinumubeg i Hisus diya a, “Pabiyaan mod la i manga an gepanulusun a nannapor de nalibun dide. Misan ay ikamo ay depat ngani a tumotul a gesabi de kaagtaan a ti papalano a te kapangyedihan i Makedepat de innawa ni belang gepanulusun diya.” ");
INSERT INTO due_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Dingan sinabi diya ni isin pa, “Panginoon, nosut ok dikamo misan ay pabiyaan ok yu ngona a nábela de kamittanak ko ide.” ");
INSERT INTO due_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Misan ay tinubeg eya ni Hisus a magioyo, “Talage a an depat a i misan ino ay gesabi a ti papalano a te kapangyedihan i Makedepat de innawa ni agta be nagkaabela eya dehil de buot na a sadili a yeyedi.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pagkatapos ninon ay nameta i Panginoon ni pito a puwu pati aduwa a lalaki ta pinapaona na ide a uluaduwa de belang benwaan a kakangan na pala. ");
INSERT INTO due_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ta sinabi na ngona dide, “Talage a hanga i goguto misan ay an sukul i magguguto kanya magpanalangin kamo de Panginoon a Makedepat a te adi ni goguto tangani pakangin na i sukul a magguguto na de diya a goguto. ");
INSERT INTO due_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kanya tumotul kamo di de pagtotul yu ta pakang ko ikamo a magi mangának a topa de gitna ni kaagtaan a magi mangáso a matapangin. ");
INSERT INTO due_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nano ay de pagtotul yu ay wet kamo nángadde ni soput ni pápangan, paragetus pati kuwarta a nassukbit yu pati de pagtotul yu ay wet kamo di magpulupaimloy de pesilan yu a gepakibete misan dino. ");
INSERT INTO due_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ta misan deno a beloy kamo nekitaan ay sabiin yu ngona a magioyo, ‘Mapadikamo tebe i kabeetan a esip ni Makedepat.’ ");
INSERT INTO due_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta be te piyon a innawa i agta de beloy a inon ay nappadiya ngani i kabeetan a esip ni Makedepat misan be eyen ay angan nappadiya i kabeetan a esip ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nano ay magpilong kamo de isin la a beloy hanggen ang kamo getotul ta wet kamo mangalis-alis de belang beloy. Pati i misan ano a akodin de dikamo ay mamangan kamo pati uminom ta i magtatarabeho ay te duman a nagkaddepat a suwildu. ");
INSERT INTO due_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ta deno man a benwaan a dedetongan yu, a tatanggep de ikamo a piyon ay mamangan kamo ni misan ano a boboy de dikamo. ");
INSERT INTO due_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Papiyonin yu i te manga orom ide dingan sabiin yu dide a, ‘Talage ngani a nagkallane di de innawa yu i kapangyedihan ni Makedepat.’ ");
INSERT INTO due_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ta misan deno pan a benwaan a ang kamo petanggep ay bumulwag kamo de karsade ta sabiin yu a malagdu a magioyo, ");
INSERT INTO due_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Dehil de ang kami petanggep dio ay papagpagen mi i singit mi ni delpong de benwaan a oyo tangani te tande a kinapoyen yu di i surut nun Makedepat. Misan ketinggesan yu pala a nagkallane di de innawa yu i kapangyedihan ni Makedepat.’ ");
INSERT INTO due_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ta pesabi ko ngan dikamo a de pineta a adow a paghatol ay namas pa a mabiyet i padusa a nádetong de tage benwaan a inon de padusa a nádetong de tage Sodoma ide a nagkasala nun nowon.” ");
INSERT INTO due_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Dingan sinabi ni Hisus a tungkul de aduwa a benwaan a sinagiden na, “Gepakatakut i násapit dikamo a manga tage Korasin pati tage Betsaida ta be duman tebe de Tiro pati Sidon a benwaan a an Hudyo ide, yinadi i gepakataka a peyedi ko dio dikamo ay náloy di tebe ide ay nagsosol, a nagbedu ni kustal, a naglipa de depog a tande ni pagsosol de. ");
INSERT INTO due_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kanya pan pesabi ko dikamo a mabiyet pa a masakut i padusa a násapit dikamo ta mamiyen pa de tage Tiro pati de Sidon. ");
INSERT INTO due_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pati ikamo a manga tage Kapernam ay kasta peesip yu a alane kamo di de Makedepat misan ay an matud ta podusahan kamo de impiyerno.” ");
INSERT INTO due_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Dingan sinabi ni Hisus a tuloy de mag-aadel na ide, “I belang gepatalikngoy dikamo ay gepatalikngoy pala deko misan ay i gekapoy dikamo ay gekapoy pala deko ta i gekapoy deko ay gekapoy pala de nagdodul deko.” Dingan pinatotul na ide. ");
INSERT INTO due_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nano ay inumampulang di un pito a puwu pati aduwa a mag-aadel a nagkasalig ide ta sinabi de de Hisus, “Panginoon, talage a getalinga dikami i libong ide be pepalayu mi ide dehil de makapangyedihan a ngalan yu.” ");
INSERT INTO due_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Dingan tinubeg ide ni Hisus, “Ay-o ta kinta ko di a nadeog di i Satanas ta naeyen di i kapangyedihan na a loktat a magi kilat. ");
INSERT INTO due_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kanya katinggesan yu di a biniyen ko ikamo ni kapangyedihan a nesikad misan de bebek pati de mannalepit ta nadeog yu di i kapangyedihan ni kapagebuk ko a i Satanas pati an te nangyeyedi dikamo a misan ano a malot. ");
INSERT INTO due_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Misan ay wet kamo masalig a masakut dehil de nadeog yu i kalibongan ide ta masalig kamo la dehil de nappalista di i ngalan yu de langot.” ");
INSERT INTO due_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nano ay nun panahon a inon ay nagkaduman i Hisus ni hanga a kasalegen dehil de te kapangyedihan diya i Ispiritu nun Makedepat dingan eya ay nanalangin a magioyo, “Ay gepasalamat ok dikamo Ama a Panginoon de langot pati de putok ta pepaabuya yu i kapangyedihan ko de te masidong ide a innawa ta petagu yu pan de mayabengin ide a makikkakatinggesan ide. Talage Ama ta maginon i kabuotan yu.” Inon i pagpanalangin na. ");
INSERT INTO due_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dingan sinabi na de manga mag-aadel na, “Binoy di deko ni Ama ko i pesan. Ta an te gekaabuya deko a Anak ti an i Ama la ta am pala te gekaabuya de Ama ti an ako la a Anak pati pesan a pepeta ko a nakáabuya pala diya.” ");
INSERT INTO due_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dingan linumingoy i Hisus de mag-aadel na ide a an te geikna a kakmukan ta sinabi na dide, “Piyon i kapuoyen yu ta pekita yu i pepayedi deko ni Ama. ");
INSERT INTO due_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Talage ay pesabi ko dikamo a gepo nun nowon ay makmuk di a magsasabi ni Makedepat pati manga hari i te buot a masakut a nekita ni pekita yu misan ay an de kinta pati buot de a neikna ni peil na yu misan ay an de inikna.” ");
INSERT INTO due_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nano ay te duman a isin a magtutodu ni Hudyo a linumane de Hisus a pedeya na la tangani hahabla na ta sinabi na, “Magtutodu, ano man i depat ko a yeyedi tangani magkaduman ok ni edup a an te kalog?” ");
INSERT INTO due_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Misan ay tinanto pala eya ni Hisus, “Ano man i nagkabbesa mo de pagdodul ide ni Moises?” ");
INSERT INTO due_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Dingan tinumbeg eya a magioyo, “Ay depat a buotin yu i Panginoon a Makedepat a pepodian yu ni pesan a innawa, edup, esip pati tibong yu. Depat pala a buotin yu i kapadepade yu a agta ni magi pagbuot de sadile yu.” ");
INSERT INTO due_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kanya sinabi diya ni Hisus, “Ay matud ngan non kanya depat mo a yediin inon a pesan tangani magkaduman ka ni edup a an te kalog.” ");
INSERT INTO due_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Misan ay dehil de buot ni magtutodu ni Hudyo a wet eya nagkamamos de pekita ni agta ay tinanto na a liwet i Hisus, “Nano ay ino pan i kapadepade ko a agta a depat a bobuot ko?” ");
INSERT INTO due_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Dingan eya ay tinubeg ni Hisus de padean ni halimbewa a oyo, “Te duman a Hudyo a padolug a paagow de benwaan a Heriko a inumapo de Herusalem. Nano ay de pagdolug na ay tinambengan eya ni manga tulisan. Ta eya ay pinahedepan de dingan inamit de i pesan a adi na ta winalat de eya a kasta nelibun di. ");
INSERT INTO due_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nano ay am pan naloy ay te duman a napasila a isin a maghahandug de Makedepat ta pagkákita na nunde tinambengan ay dinumibelew eya nunde bektas. ");
INSERT INTO due_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Te duman pala a isin a angkan ni Lebi a napasila duman. Ay maginon pala i yinadi na a dinumibelew eya nunde bektas. ");
INSERT INTO due_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Misan ay pagkatotul na ay dinumatong pan i isin a an Hudyo a tage Samaria. Ta pagkákita na de tinambengan ay nakalbi eya. ");
INSERT INTO due_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kanya eya ay linumane de lalaki a tinambengan ta binulong na i biged na ni langis pati tayug ta giniptan na i biged na ide dingan sinakoy na a tuloy de kasakoyen na a hayup. Ta inadde na de beloy a peupahan ta duman na inalagean un tinambengan. ");
INSERT INTO due_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nano ay nun abiabi di ay nangamit i tage Samaria ni kuwarta de soput na ta binoy na de te adi ni beloy dingan sinabi na de te adi ni beloy a, ‘Buot ko tebe a aalagean yu i lalaki a oyo. Ta be tipide i nagestus yu diya ay gebeyed ok dikamo pag-ampulang ko.’ Inon i sinabi ni tage Samaria.” ");
INSERT INTO due_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nano ay tinanto ni Hisus i magtutodu ni Hudyo, “Ino nano de tiluwon a napasila i peesip mo a te pagbuot de kapadepade na a agta?” ");
INSERT INTO due_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dingan tinumubeg i magtutodu ni Hudyo, “Ay talage a i nakalbi diya.” Kanya sinabi diya ni Hisus, “Ay hale di, yediin mo pala i maginon.” ");
INSERT INTO due_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nano ay de pagtotul nide Hisus ay sinumila ide de isin a beriyu ta duman nappataan i isin a mahuna a te ngalan a Marta. Ta tinanggep na pan ide a piyon de beloy na. ");
INSERT INTO due_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","I mahuna pan a oyo ay te duman a wele a i ngalan na ay Maria. Ta linumipa eya de singitan ni Panginoon a gepatalikngoy de pagtodu na. ");
INSERT INTO due_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Misan ay i Marta pan ay nagkaabela a masakut dehil de paghande na ni pápangan ta an eya petabengan ni Maria. Kanya eya ay linumane de Hisus tangani sosumbong na i Maria ta sinabi na, “Panginoon, kasta an te ano man dikamo a pepabiyaan ok ni wele ko a gehande ni pesan. Dodulin yu tebe eya a tumabeng deko.” ");
INSERT INTO due_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Misan ay tinubeg eya ni Panginoon, “Marta, nagkaabela ka a masakut tungkul de makmuk a pehande mo. ");
INSERT INTO due_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Misan ay isin pan la i matud a kaelangan ta inon ngani i pineta ni Maria ta i oyo ay an nabut diya.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nun isin a adow ay nanalangin i Hisus de isin a lugel ta pagkatapos na ay sinabi diya ni isin de mag-aadel na ide, “Panginoon, toduan yu pala ikami a ti papalano i pagpanalangin a magi pagtodu ni Huwen a Maglilenod de mag-aadel na ide.” ");
INSERT INTO due_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Dingan sinabi na dide, “Magioyo i pagpanalangin yu, ‘Ama de langot, buot mi tebe a magpodi dikamo i pesan a kaagtaan, a gekaduman pala i innawa de ni kapangyedihan yu. ");
INSERT INTO due_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Biyen yu ikami ni sukul a pápangan mi adow adow. ");
INSERT INTO due_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pati pakeeyenan yu ikami ni mammalotin mi a magi pagpatáwad mi pala de belang nagkasala dikami. Ta wet yu ikami pabiyaan de pagsubuk a mahigpetin.’” Inon i tinodu ni Hisus dide. ");
INSERT INTO due_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Dingan sinabi na pa dide i oyo a halimbewa, “Be te duman dikamo a nákang de isin a ayun na de gitna ni abi ta sabiin na duman, ‘Ayun, biyen ok yu tebe ni tiluwon a tinapay a hangain. ");
INSERT INTO due_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ta dinumatong pan un isin ko a ayun a inumapo de alayu a lugel ta anok te naoungut diya a unabis.’ ");
INSERT INTO due_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Dingan halimbewa la a i totubeg diya ni te beloy ay magioyo, ‘Wet ok yu abelaa ta nàabetan di i pintohan pati geide kami di pati mittanak ko i. Kanya anok di nakegiyos a nakapomoy dikaw ni buot mo.’ ");
INSERT INTO due_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Misan ay pesabi ko dikamo a am man eya gumiyos dehil de ikamo ay mangáyun na ay dehil pan de mapelit a pag-aged yu diya ay talage ngani a negiyos eya a boboy na dikamo i kaelangan yu. ");
INSERT INTO due_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Kanya pesabi ko pala dikamo a de pagpanalangin yu ay mag-aged kamo a tuloy tuloy ta ikamo ay bebiyen, maglawag kamo a tuloy tuloy ta ikamo ay nekita pati tumuktuk kamo a tuloy tuloy ta kakayesan i abetan para dikamo. ");
INSERT INTO due_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ta i belang geaged a tuloy ay pebiyen, i gelawag pala a tuloy ay nekita pati i getuktuk pala a tuloy ay pekayesan i abetan para diya. ");
INSERT INTO due_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nano ay ikamo pan a manga ama ay an yu bebiyen i anak yu ni beto be eya ay geaged ni tinapay pati an yu pala bebiyen i anak yu ni bebek be eya ay geaged ni ikan. ");
INSERT INTO due_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pati pan an yu eya bebiyen ni mannalepit be eya ay geaged dikamo ni deyag. ");
INSERT INTO due_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nano be ikamo a makikkakasalanan ay naketingges a geboy de mangának yu ni piyon a paaged ay namas pa a naketingges i Ama yu a Makedepat de langot a geboy ni Ispiritu na de belang geaged diya.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nun isin a adow ay pinalayu ni Hisus un libong a gepabunol nunde lalaki. Ta nun pinalayu na di un libong ay nakasurut di un bunol ta nagtaka a masakut i kaagtaan ide. ");
INSERT INTO due_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Misan ay sinabi ni tipide duman a, “I Belsebul a i Satanas a ponu ni kalibongan ide i nagboy diya ni kapangyedihan a gepalayu ni kalibongan ide.” ");
INSERT INTO due_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Te duman pan a kakmukan a nagsubuk de Hisus ta ide ay nag-aged diya a magyedi eya ni gepakataka tangani matinggesan de ti eya ngani ay te kapangyedihan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Misan ay kinatinggesan pan ni Hisus i peesip de kanya sinabi na dide, “Misan deno a bensa be ide ay nagipinagebuk ay nesede ngani i kapangyedihan ni bensa a inon pati an notuloy i misan deno a mittanak be ide ay nattulutaloan. ");
INSERT INTO due_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ta be i Satanas ay gepakitalo de manga katabeng na a libong ay nesede di a tuloy i kapangyedihan na. Pesabi yu a gepalayu ok ni libong dehil de kapangyedihan ni Belsebul a binoy na deko. ");
INSERT INTO due_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Be peesip yu a gepalayu ok ni libong ide ni dehil de kapangyedihan ni Belsebul dingan depat a peesip yu pala a gepalayu ni libong ide i mag-aadel yu ide dehil de kapangyedihan ni Belsebul. An maginon i peesip yu a tungkul dide kanya ide i gepamatud a an matud i peesip yu tungkul deko. ");
INSERT INTO due_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Talage i Ispiritu nun Makedepat i geboy deko ni kapangyedihan a gepalayu ni manga libong ide kanya katinggesan yu nano a dinumatong di dikamo a kaagtaan i kapangyedihan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Be halimbewa ay te duman a matibong a lalaki a gebentay de beloy na ta eya ay te duman a armas ay talage a an náamit ni misan ino i kasangkapan na. ");
INSERT INTO due_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Misan ay be te duman pan a nekilaben diya a namas pa a matibong ay talage ngani a aagow di ni nanalo i armas na a peasaan na dingan bobulubinsa ni nanalo de mangáyun na i pesan a yaman na a inagow. ");
INSERT INTO due_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","I misan ino a an geabut deko ay katalo ko pati i misan ino a an getabeng deko a getipun ni manga agta ay gepakálat ngani.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sinabi ni Hisus a tuloy, “Be pinalayu di i malot a libong de lawes ni agta ay nasulusagid de attanan a lugel a te kahedepan, a gelawag ni lawes ni kakmukan a agta a pepaimloyen na. Misan ay be an eya nekita ay sasabi na de sadile na, ‘Yadi pa ay náampulang ok de inapóan ko a beloy.’ ");
INSERT INTO due_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ta de pag-ampulang na ay kekita na a an te unid, a malenis pati pinakapiya di. ");
INSERT INTO due_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kanya gelawag pa eya ni namas pa a malot diya a pito a libong ta dingan ide ay nesilong a te kapangyedihan a liwet de agta a inon. Kanya namas pa a malot i inapóan a kapuoyen ninon a agta de tagibu a kapuoyen na.” ");
INSERT INTO due_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pagkasabi ni Hisus ninon ay sinabi a malagdu ni isin a mahuna gepo de kamakmokan a magioyo, “Piyon i kapuoyen ni mahuna a nangimasat dikamo pati nagpasusu.” ");
INSERT INTO due_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Misan ay tinumubeg i Hisus, “Namas a piyon i kapuoyen ni gepatalikngoy a getalinga a tuloy de surut nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nano ay nun nagidinatong di i kaagtaan ay sinabi ni Hisus, “Talage a malot i ugeli ni agta ide de nano a panahon. Gelawag ide ni gepakataka misan ay an ide te kekita ti an i tande a nangyedi de magsasabi a den a Honas. ");
INSERT INTO due_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ta ti papalano a i Honas ay napa ni gepakataka de tage benwaan a Ninibe nun nowon ay maginon pala i ako a Pineta nun Makedepat a napa ni agta ay nappa ni gepakataka de kaagtaan de nano a panahon. ");
INSERT INTO due_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Talage a de nádetong a paghatol nun Makedepat ay nouddi i Rena a tage Timogen de kasagkaden yu a gepamatud a makikkakasalanan kamo de nano a panahon. Ta nun nowon ay inumapo eya de alayu a gepatalikngoy de Hari a Solomon a naketingges a masakut misan ay napadio nano de kasagkaden yu i, i namas pa a naketingges misan ay an yu pa petalingaan. ");
INSERT INTO due_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pati de adow pala a inon ay nouddi i tage benwaan a Ninibe de kasagkaden yu a gepamatud a makikkakasalanan kamo de nano a panahon. Ta nun nowon ay nagipinagsosol ide dehil de pagpamatud dide ni Honas misan pan ay napadio nano de kasagkaden yu i, i namas pa a te kapangyedihan de Honas misan ay ang kamo pa gesosol.” ");
INSERT INTO due_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Dingan sinabi pala ni Hisus, “Talage a be te duman a getudtud ni salong ay an na sasakloben de takalan, a popuoy de saruk ni pig-idean na ta popuoy na pan de talage a pigpuoyen na tangani kekita ni nesilong de beloy i sesikaden de. ");
INSERT INTO due_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nano i mata yu ay magi salong de lawes yu kanya be an mebu i mata yu ay matallang ni kapiyonan i lawes yu misan ay be mebu i mata yu ay angani matallang i lawes yu ni kapiyonan. ");
INSERT INTO due_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kanya depat kamo a magipinag-engat tangani wet nadeog ni malot a naddeinnawa yu i kapiyonan a geapo de Makedepat a magi salong a napalong. ");
INSERT INTO due_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ta be kasta matallang i innawa yu a an te buot de malot a magi madumos ay dingan talage ngani a matallang di i innawa yu a magi te salong.” ");
INSERT INTO due_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nano nun pagkasabi ni Hisus ninon ay inakit eya ni isin a Pariseo a námangan de beloy na kanya kinumang i Hisus duman ta namangan ide. ");
INSERT INTO due_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ta nagtaka i Pariseo nun kinta na a an ngona nag-uges i Hisus ni kumot na dingan namangan. ");
INSERT INTO due_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Misan ay sinabi diya ni Panginoon, “Ikamo ngani a manga Pariseo ay pelenis yu i disapow ni mangkok pati pinggen a pekita ni manga agta misan ay de disalad ni innawa ay pino ni pagkasinna pati mammalotin. ");
INSERT INTO due_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ang kamo te katinggesan a unabis ta i Makedepat a nagyedi niwina a pekita yu ay nagyedi pala ni innawa ni manga agta ide. ");
INSERT INTO due_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kanya depat a malenis i innawa yu, a boyin yu i kalbi yu de mahedepin ide dingan piyon i innawa yu de pekita ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Gepakatakut i násapit dikamo a manga Pariseo ta pehandug yu de Makedepat i kasangpuwu a rikadu la misan ay pagkelipatan yu a pebuot i Makedepat, a te piyon pala a pagyedi de kaagtaan. Nappatud ngani a yediin yu i tagibu misan ay an depat a pagkelipatan yu i pinakamahalage. ");
INSERT INTO due_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Gepakatakut i násapit dikamo a manga Pariseo ta i buot yu ay i manga hinande a piglipaan de pigmitengan ide pati buot yu a betiin kamo de kulukarsade. ");
INSERT INTO due_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gepakatakut ngani i násapit dikamo ta i innawa yu ay magi táporan a an te tande a beto kanya nagkasikaden ngani ni manga agta ta an de katinggesan a alane ide de mammalotin.” ");
INSERT INTO due_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dingan sinabi diya ni isin a magtutodu ni Hudyo, “Magtutodu, de pesabi yu a iwina ay kasta pati ikami a magtutodu ay pesosol yu.” ");
INSERT INTO due_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kanya eya ay tinubeg ni Hisus, “Talage a gepakatakut pala i násapit dikamo a manga magtutodu ni Hudyo. Ta ikamo ay getodu a mahigpit ta nagkapatalinga yu i kaagtaan misan ang kamo pan getalinga de pagdodul a petodu yu. ");
INSERT INTO due_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Gepakatakut ngani i násapit dikamo ta pepayedi yu i pigtaporan ni magsasabi ide a den a binuno ni kaapoapohan yu ide. ");
INSERT INTO due_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ay dehil de pagyedi yu a inon ay ikamo di pala i gepamatud a nappaayun pala de kabuotan yu i yinadi a inon ni kaapoapohan yu ide. Ta ide i nagbuno ta ikamo pan i gepayedi ni pigtaporan de ide. ");
INSERT INTO due_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kanya sinabi pan ni Makedepat a naketingges a, ‘Pakang ko de Hudyo ide i magsasabi ko ide pati mag-aatid misan ay bobuno de i tipide dide ta i kakmukan pan ay pehedepan de.’ ” ");
INSERT INTO due_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sinabi ni Hisus a tuloy, “Kanya podusahan kamo a manga agta de nano a panahon dehil de pagbuno ni kaapoapohan yu ide de magsasabi ide hanggen nunde gepo ");
INSERT INTO due_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nun binuno i Abel hanggen de Sakarias a binuno de alane ni pighandogen de Makedepat. Talage ay pesabi ko dikamo a i padusa dehil de pesan a pagbuno a inon ay nádetong de agta ide de nano a panahon. ");
INSERT INTO due_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Talage a gepakatakut i násapit dikamo a manga magtutodu ni Hudyo ta dehil dikamo ay nagkapa ni an te katinggesan i manga agta tungkul de kamatoden a surut nun Makedepat. Ta an yu buot a gekaduman kamo ni kapangyedihan na pati peabetan yu pala i kakmukan a te buot.” ");
INSERT INTO due_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Dingan tinumotul i Hisus de beloy a inon ta gepo nun nanon ay tinulutanto eya a mapelit a tungkul de attanan ni magtutodu ide ni Hudyo pati Pariseo ide ");
INSERT INTO due_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tangani madeya de eya a te dehilan ide a gesumbong dehil de surut na. ");
INSERT INTO due_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nun nanon pala a adow ay nagidinatong de Hisus i makmuk a masakut a manga agta ta ide ay nasilinsilenan di. Dingan sinabi ni Hisus a tagibu de mag-aadel na ide a, “Nano ay mag-engat kamo de pahelab ni manga Pariseo ide a i malot a ugeli de a gesabi a an ded peyedi i malot misan ay peyedi de mangan la. ");
INSERT INTO due_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta an te nattaklopan a an kakayasan pati an te nattagu a an kekita. ");
INSERT INTO due_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ta ti anóman i sinabi yu a nattagu ay eikna pala ni manga agta ide pati inulit yu de manga kuwarto ide ay talage ngani a bebereta a malagdu de kaagtaan.” ");
INSERT INTO due_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sinabi na a tuloy, “Mangáyun ko, pesabi ko dikamo a wet kamo matakut de te kaya la a nomuno de lawes yu a putok misan ay an di ide te kaya a nomuno ni kaleduwa yu. ");
INSERT INTO due_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ta pepapag-engat ko dikamo, a matakut kamo de te kapangyedihan a nomuno ni lawes yu a nangadde pala ni kaleduwa yu de impiyerno. Talage ay pesabi ko dikamo a de Makedepat kamo la matakut. ");
INSERT INTO due_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Misan pan ay hanga i pagbuot na dikitam ta misan pepanggetang ni magtitinde ide i lima a maye ni aduwa a pera ay an na nagkelipatan i misan isin dide. ");
INSERT INTO due_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pati i sapok yu pan ay katinggesan pala ni Makedepat i kamakmuk na. Kanya wet kamo matakut ta namas kamo pa a mahalage de manga maye ide. ");
INSERT INTO due_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Pesabi ko dikamo a i misan ino a gepamatud tungkul deko de kaagtaan ay gepamatud ok pala tungkul diya de kasagkaden ni manga anghel ide ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ta i misan ino a gepinangeyen deko de kaagtaan ay pengeyen ko pala eya de kasagkaden ni manga anghel ide ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pati i misan ino a gesurut ni malot tungkul deko a Pineta nun Makedepat a napa ni agta ay nappatud ngani a pakeeyenan ide ni kasalanan a inon misan ay i gesurut ni malot tungkul de Ispiritu nun Makedepat ay talage ngani a an nappatud a pakeeyenan ide ni kasalanan a inon. ");
INSERT INTO due_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nano be ikamo ay aadde de de pigmitengan ide a Hudyo, de kasagkaden ni manga huwis ide pati de te manga kapangyedihan ide ay wet magulo i esip yu a ti ano i sasabi yu. ");
INSERT INTO due_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ta i Ispiritu nun Makedepat i nomoy dikamo de odes a inon ni sasabi yu.” ");
INSERT INTO due_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dingan sinabi de Hisus ni isin a agta de kamakmokan a, “Magtutodu, sabiin yu di tebe de kaka ko na a depat a boyin na di deko i kabinsa ko de mana mi a putok.” ");
INSERT INTO due_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Misan ay tinumubeg i Hisus diya, “Ayun, ay anok ngani te tungkolin a gepabinsa ni mana yu.” ");
INSERT INTO due_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dingan sinabi na dide a pesan, “Magipinag-engat kamo a wet nagkesinna de adi dio de putok i ta an te halage i edup ngani ni agta dehil de kahanga ni yaman na.” ");
INSERT INTO due_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dingan nagsabi i Hisus ni halimbewa a oyo, “Te duman a lalaki a mayaman a te malawa a putok a inumanak ni makmuk. ");
INSERT INTO due_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kanya sinabi na de sadile na, ‘Ano man nano i yeyedi ko? Ta anok di te pomuoyen ni manga náani ko ide.’ ");
INSERT INTO due_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Dingan sinabi na a, ‘I oyo i yeyedi ko ta rorukat ko i untekin ko ide a manga kamalig ta dingan gepayedi ok ni namas pa a hangain a kamalig ta duman ko ngani popuoy i pesan a náani ko pati kakmukan ko a kasangkapan.’ ");
INSERT INTO due_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ta dingan sasabi ko de sadile ko a, ‘Te duman ok di a sukul misan kapide a taon ta gepaimloy ok dila a námangan a neinom a te kasalegen.’ ");
INSERT INTO due_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Misan ay sinabi ni Makedepat a magioyo diya, ‘Talage ngani a ang ka te katinggesan a unabis ta nano pan a abi ay nelibun ka di kanya ang ka te pakinabeng a unabis de kayamanan a hinande mo.’ ");
INSERT INTO due_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Talage ngani a maginon dila i násapit de gehande ni kayamanan para de sadile na la ta mahedep pan eya de pekita ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dingan sinabi ni Hisus de mag-aadel na ide a, “Wet magulo i esip yu de dikamo a edup a ti ano i pápangan yu o misan de dikamo a lawes a ti ano i bedu yu a pantaklop. ");
INSERT INTO due_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ta i edup pati lawes yu ay namas pa a mahalage de papangan pati bedu. ");
INSERT INTO due_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pagelawagin yu ngani i manga tewak ide ta an ide gepinagpasok, an ide gepinagguto pati an ide te pigpuoyen pati kamalig misan ay peungut ide ni Makedepat kanya oungut na ikamo a talage ta namas kamo pa a mahalage de manga manok ide. ");
INSERT INTO due_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kanya wet magulo i esip yu ta ang kamo te kaya a nakapepaanduwon ni edup yu misan isin la a odes. ");
INSERT INTO due_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Dehil de ang kamo la te kaya a nakapepaanduwon ni misan isin la a odes de edup yu ay bekot ta magulo i esip yu a masakut tungkul de pápangan pati bedu yu. ");
INSERT INTO due_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ta pagelawagin yu pala i manga bulaklak ide a ti papalano a gehanga ta am pan ide getagel, a am pa ide geti misan ay pesabi ko ngan dikamo a misan i Hari a Solomon a migbedu ni masampatin ay angani nakapagbedu ni magi kasampat ni manga bulaklak ide a oyo. ");
INSERT INTO due_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kanya be pebeduan ni masampat ni Makedepat i kademoan de kapadengan a nagkeedup la nano, a an di diage a gegetong la de apoy ay namas kamo pa ngani a bebeduan ni Makedepat. Talage ngani a untik i pagpanulusun yu diya. ");
INSERT INTO due_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kanya wet magulo i esip yu tungkul de pápangan pati einom yu. ");
INSERT INTO due_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ta i oyo ngani i pagkogulo ni esip ni pesan a manga agta dio de putok i misan ay katinggesan pan ni Ama yu de langot i pesan a kaelangan yu dio. ");
INSERT INTO due_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kanya ikamo pan ay depat a pabiyaan yu ngona i Makedepat a te kapangyedihan de innawa yu ta dingan gekaduman kamo ni pesan a kaelangan yu.” ");
INSERT INTO due_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ikamo a an makmuk a gepanulusun ay wet matakut ta te belak i Ama yu a Makedepat a bebinsaan ikamo ni kapangyedihan na. ");
INSERT INTO due_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kanya panggetangin yu di i pesan a adi yu a bobuluboy de mahedepin ide. Ta de maginon ay getipun kamo ni yaman yu de kataanan ni Makedepat a an nabbut ta duman ay angani te migpanakow pati nansesede a hayup. ");
INSERT INTO due_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ta talage a ti deno i yaman yu misan de putok i misan de langot ay duman pala i innawa yu pati esip. ");
INSERT INTO due_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ay depat a magipinaghande kamo a katolad de katabeng ide a piyon a nappabedu a te tutud pala i salong. ");
INSERT INTO due_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ta pagdetong ni panginoon de a inumapo de kásalan ay nappahande ide a gekayes a tambing para diya, pagtuktuk na de abet ni pintohan. ");
INSERT INTO due_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Piyon i kapuoyen ni katabeng ide a dedetongan ni panginoon a ugnay a nappahande. Pesabi ko dikamo ay gehande pala i panginoon de a oolangan na ide a oungut na. ");
INSERT INTO due_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Talage a piyon i kapuoyen ni manga katabeng a nappahande de pagdetong ni panginoon de misan dumatong de gitna ni abi o de mandeli a abiabi. ");
INSERT INTO due_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ta esipin yu i oyo a halimbewa a be katinggesan la ni te adi ni beloy i odes a pagdetong ni migpannakow ay gepoyet eya, a an na pabiyaan a nesilong de beloy na i migpannakow. ");
INSERT INTO due_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kanya depat kamo pala a maghande a ugnay ta de odes a an yu katinggesan ay nádetong ok a Pineta nun Makedepat a napa ni agta.” ");
INSERT INTO due_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dingan sinabi diya ni Pedro, “Panginoon, para dikami man i sinabi yu a iwina a halimbewa o para de pesan.” ");
INSERT INTO due_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ay tinumubeg i Hisus, “Gesabi ok ninon para de pesan ta i naketingges a katabeng a depat a naponulusonan ay eya i bebiyen ni panginoon na ni pag-alage de kakmukan pa a katabeng. Ta bebiyen ide ni naketingges ni sukul a papangan de de matud a panahon. ");
INSERT INTO due_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kanya piyon i kapuoyen ni katabeng a inon be eya ay dinatongan ni panginoon na a geyedi ni pesan a kabuotan na. ");
INSERT INTO due_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Talage ay pesabi ko dikamo a inon ngani a katabeng ay papámahala ni panginoon na de pesan a adi na. ");
INSERT INTO due_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Misan ay be inon a katabeng ay sasabi na de sadile na, ‘Pangano ko ta naaloy pa i pag-ampulang ni panginoon ko.’ Ta dingan eya ay te gepo a gebelbel de kapadepade na a katabeng, lalaki man o mahuna, a námangan pati neinom a gebugnang a tuloy. ");
INSERT INTO due_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Misan ay náampulang i panginoon ninon a katabeng de adow pati odes a an na katinggesan. Ay talage ngani a podusahan eya ni panginoon na a mahigpit dingan dodugeng na eya de manga an naponulusonan. ");
INSERT INTO due_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ta i katabeng a te katinggesan de kabuotan ni panginoon na a an na tinalingaan ay talage ngani a nátanggep eya ni mabiyet a padusa gepo de panginoon na. ");
INSERT INTO due_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Misan ay be te duman a katabeng a nagyedi ni malot a an na katinggesan ay tatanggep na ngani i mamiyen a padusa. Ta i misan ino a biniyen ni makmuk ay aageden pala ni makmuk ta eya a papámahala ni namas pa ay aageden pala ni namas pa.” ");
INSERT INTO due_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sinabi ni Hisus a tuloy, “Ako ay dinumatong dio a gepapagkiblagen ni innawa a magi apoy a winitik de putok kanya buot ko di a masakut a nedilab di. ");
INSERT INTO due_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pati te duman ok pa a paglinod de kahedepan ta buot ko a masakut a mangyedi inon a tambing. ");
INSERT INTO due_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Wet yu eesipa a dinumatong ok dio de putok tangani papag-eisinin ko i innawa ni kaagtaan ta ako i geboy ni pagkiblagen ni innawa ni kaagtaan ide. ");
INSERT INTO due_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Talage a gepo nano dehil de pagpanulusun deko ni tipide ay nakulukiblagen i innawa ni lima a agta de isin a beloy ta an magkapadepade i pagpanulusun ni tiluwon pati aduwa. ");
INSERT INTO due_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nakulukiblagen i maginak a lalaki pati maginak a mahuna pati magpanuwangan a mahuna.” ");
INSERT INTO due_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sinabi na pala de kaagtaan ide a, “Be pekita yu de kadepit a pelinoden i kodipot ay tambing yu a sasabi, ‘Ay talage ngani a nátapuk.’ Ta maginon ngani i gesapit. ");
INSERT INTO due_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pati be gepalos ni salatan ay sasabi yu pan, ‘Ay neinit di ngani.’ Ay talage pan a geinit i adow. ");
INSERT INTO due_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ikamo a gesabi a an yud peyedi i malot misan ay peyedi yu mangan la. Talage a peabuyenan yu i manga tande a inon de putok pati langot misan ay an yu pan peabuyenan i tande a gepamatud de pagyedi ni Makedepat de nano a panahon.” ");
INSERT INTO due_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sinabi ni Hisus a tuloy, “Nappa dikamo i pagpeta ni matud. ");
INSERT INTO due_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ta be te gehabla dikaw de huwis ay depat ngona duman de bektas a makipagkasungdu ka de gehabla dikaw tangani wet na ikaw eikag de huwis ta boboy ka pan ni huwis de pulis dingan bebilanggo ka pan ni pulis. ");
INSERT INTO due_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Talage ay pesabi ko dikaw a ang ka nakobulwag hanggen an mo nabebeyeden i kauluinapóan mo a otang a pera.” ");
INSERT INTO due_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nano ay nun nanon ay te duman a manga agta a nagsabi de Hisus a pinabuno ni Pilato a Gubernador i tipide a tage Galilea nun naghandug ide de Makedepat ni binuno a hayup. ");
INSERT INTO due_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ide ay tinubeg ni Hisus, “Makati peesip yu a kanya ide binuno ay namas pa a makikkakasalanan ide de kakmukan a tage Galilea? ");
INSERT INTO due_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","An non matud ta pesabi ko dikamo a be ang kamo gepinagsosol de mammalotin yu ay talage ngani a nopuksa kamo pala a pesan. ");
INSERT INTO due_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Pati i nalibunin man a sangpuwu pati walo a nadetogen ni maditas a pigbentayen de Siloe ay kati peesip yu a namas pa i mammalotin de de kakmukan a manga agta de Herusalem. ");
INSERT INTO due_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","An non matud ta pesabi ko dikamo a be ang kamo gepinagsosol de mammalotin yu ay nopuksa kamo pala a pesan.” ");
INSERT INTO due_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dingan sinabi dide ni Hisus i halimbewa a oyo, “Te duman a isin a agta a te pigtanoman ta duman de makmuk a tanom na a obes ay te isin a gemut a igos. Ay nun linawag yo ni te adi ay an la te anak. ");
INSERT INTO due_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kanya sinabi na de mag-aalage ni pigtanoman na, ‘Tiluwon ok di a taon a gekang dio misan ay anok pa ngani gekita ni anak ni oyo a kew a igos. Yadi pa ay pugtusin mo di ta an la nay te pakinabeng dena.’ ");
INSERT INTO due_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Misan ay tinubeg eya ni mag-aalage a, ‘Wet ngona, Panginoon, ni taon a oyo ta kokutkutan ko i gemut na dingan dodumanan ko ni pattabe ");
INSERT INTO due_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","tangani be nagkaanak ni taon a nádetong ay piyon misan ay be eyen ay dingan popugtus yu dingani.’” ");
INSERT INTO due_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nano ay isin a adow a paimloy ay nagtodu i Hisus de pigmitengan ni Hudyo ide. ");
INSERT INTO due_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Te isin pan duman a mahuna a te libong de lawes na a gepabuktut diya ni sangpuwu pati walo a taon. Ta an di eya gepakaonat. ");
INSERT INTO due_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Dingan nun kitain yo ni Hisus ay sinabi na diya, “Gupad, naukasan kamo di de pagkabuktut yu na.” ");
INSERT INTO due_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ta tinapá na ni kumot na i gupad kanya tambing dila a nakaonat a nagpodi eya a tuloy de Makedepat. ");
INSERT INTO due_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Misan ay nagbulas i gepamahala de pigmitengan ta i Hisus ay nagpapiyon de adow ni paimloy kanya sinabi ni gepamahala de kaagtaan, “Te anim a adow a depat a pagtarabeho kanya de inon kamo a manga adow magidinio tangani magpapiyon a wet de adow nun paimloy.” ");
INSERT INTO due_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dingan tinumubeg i Hisus, “Ikamo ngani a gesabi a an yud peyedi i malot misan ay peyedi yu mangan la. Amman la pepainom yu la i beka yu ide pati asno ide misan adow nun paimloy? ");
INSERT INTO due_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nano ay wiyo i mahuna a kapadepade tam a apo ni Abraham ta eya ay ginapus ni Satanas ni sangpuwu pati walo a taon kanya namas pa ngani a piyon be eya ay oukasan misan adow nun paimloy.” ");
INSERT INTO due_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Dehil de tubeg na a inon ay námamos i katalo na ide. Ta i kamakmokan pan ay nagkasalig dehil de yinadi na a gepakataka. ");
INSERT INTO due_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sinabi ni Hisus, “Nano ay pesabi ko dikamo a ti ano i kapadepade ni kapangyedihan ni Makedepat de innawa ni agta ide ta i oyo i gegemit ko. ");
INSERT INTO due_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I oyo a kapangyedihan ni Makedepat ay magi binhi a mustasa a tinanom ni isin a agta de kaengin na ta oyo ay hinumanga a nappa ni gemut ni kew ta duman di gepoged de manga sanga na i kamanokan.” ");
INSERT INTO due_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sinabi pala ni Hisus, “Nano ay sasabi ko pa dikamo a ti ano i kapadepade ni kapangyedihan ni Makedepat de innawa ni agta. ");
INSERT INTO due_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I oyo ay magi pahelab a dinugeng ni isin a mahuna de tiluwon a takal a harena a te dugeng a orat kanya kinumálat un pahelab de pesan a harena.” ");
INSERT INTO due_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nano ay tinumotul i Hisus a sinumulusagid de bulubenwaan pati de buluberiyu ide a nagtodu de sinlan na a paagow de Herusalem. ");
INSERT INTO due_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dingan te duman a nagtanto diya, “Panginoon, uluisin man i manga agta a nalligtas?” Tinubeg na eya, ");
INSERT INTO due_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pumelit kamo a sumilong de pintohan a megot ta pesabi ko dikamo ay misan makmuk i te buot a nesilong ay uluisin pan la i nakesilong de inon. ");
INSERT INTO due_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ta be halimbewa nakauddi i te beloy a inabetan na di i pintohan ay talage ngani a geuddi kamod la de katobengan a getuktuk dila, a sasabi yu de te beloy, ‘Panginoon, pasilongin yu ikami.’ Misan ay totubeg na ikamo a magioyo, ‘Ang ko ikamo peabuyenan ti tage deno kamo?’ ");
INSERT INTO due_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dingan sasabi yu pan diya, ‘Ay talage a peabuyenan yu pan ikami ta namangan kami a kakoloy pati inuminom ta nagtodu kamo pa de benwaan mi.’ ");
INSERT INTO due_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Misan ay totubeg na a liwet dikamo, ‘Talage ay pesabi ko dikamo a ang ko ikamo peabuyenan ti tage deno kamo kanya lumayu kamo deko a ikamo a migyedi ni mammalotin.’ Maginon ngani i totubeg ni panginoon. ");
INSERT INTO due_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Talage a pagdetong ni adow a pepakita ni Makedepat i kapangyedihan na ay nálane diya i kaapoapohan tam a Abraham, Isak, Hakob, pati pesan a magsasabi a den ta ikamo pan ay palayu na diya dingan ikamo ay nátangos a náaratengot i ngipon yu dehil de pagtiis yu. ");
INSERT INTO due_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta i manga an Hudyo pan ide a gepo de duludedeno a kadepit ay nádetong a nekisaló de alane ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kanya patalikngan yu ta te duman a nàinapóan a nagkapáona ta te duman a naona pan a nagkáinapóan.” ");
INSERT INTO due_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nun nanon ay te dinumatong a tipide a Pariseo ta sinabi de de Hisus a magioyo, “Ay tumotul kamo dio ta buot kamo a pobuno ni Gubernador a Herod.” ");
INSERT INTO due_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Misan ay tinubeg na ide, “Sabiin yu de migdeya a inon a ako ay gepalayu ni manga libong ide pati gepapiyon ni te manga orom ide nano pati diage ta de kasanagen pan ay tatapos ko i pagyedi ko. ");
INSERT INTO due_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Misan ay depat a ako ay notuloy de pagtotul ko nano, diage pati de kasanagen ta anok nabobuno dio ta i lugel a pinagbunoan de magsasabi ide ay de Herusalem la.” ");
INSERT INTO due_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sinabi na pala, “Ikamo a tage Herusalem ay pepabuno yu i magsasabi ide ni Makedepat ta pepabonglag yu pan i dinodul na ide dio. An la pakosa a ako ay te belak a ikamo ay alágean ko a magi pag-aláge ni manok de mangának na ide misan ay an yu pan buot. ");
INSERT INTO due_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kanya ikamo a tage Herusalem ay pabiyaan kamo di ni Makedepat. Talage ay pesabi ko dikamo a anok yud kekita hanggen an gedetong i odes a sabiin yu a magioyo a, ‘Magpodi kitam di de gedetong a te kapangyedihan ni Panginoon a Makedepat.’” Inon i sinabi ni Hisus dide. ");
INSERT INTO due_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nano ay nun isin a adow a paimloy ay kinumang i Hisus a námangan de beloy ni te kapangyedihan a Pariseo ta duman eya ay pebentayen ni manga katalo na ide tangani kitain de ti te nasasabi ide a pagsumbong diya. ");
INSERT INTO due_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Misan ay te duman pan de alane ni Hisus a isin a lalaki a nappagitok. ");
INSERT INTO due_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Dingan nagsurut i Hisus de Pariseo ide pati magtutodu ide ni Hudyo ta sinabi na, “Nappaayun man de pagdodul ide a gepapiyon de adow nun paimloy o eyen?” ");
INSERT INTO due_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nano ay an ide gepinagyamyam diya kanya pan binolan na i te orom a pinapiyon na dingan pinatotul na. ");
INSERT INTO due_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pagkatapos ay sinabi na dide, “Be te duman kamo a asno o beka a nadegdeg de bubun ay talage ngani a aamit yu misan adow nun paimloy.” Inon i sinabi na. ");
INSERT INTO due_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ta an ide te kaya a getubeg de inon. ");
INSERT INTO due_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nano ay nagpakalawag i Hisus a ti papalano a nagpeta i manga inakit ide ni piglipaan a hinande. Kanya pan nagsurut eya ni halimbewa a oyo ta sinabi na, ");
INSERT INTO due_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Be ikaw ay peakit ni misan ino de kásalan ay wet ka ngona nelipa de manga hinande ide a piglipaan ta makati te duman la a inakit a namas pa a mahalage dikaw. ");
INSERT INTO due_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ta dingan nálane dikamo a aduwa i nangakit dikamo ta sasabi na dikaw a, ‘Boyin mo tebe i lepan a iwina de agta a oyo.’ Ay talage ngani a napaamamos ka be napalipa ka di de masidong di a masakut a piglipaan. ");
INSERT INTO due_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ta yadi pa ay be ikaw ay inakit ay lumipa ka ngona de pinakamalot a piglipaan. Ta de pagkita dikaw ni nangakit dikaw ay makati sasabi na, ‘Lumipa ka, ayun, de alane ko i a piglipaan a hinande.’ Ta de maginon ay ginalang ka de pesan a inakit. ");
INSERT INTO due_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ta i gepodi de sadile na ay pepakásidong eya de pesan ta i gepakásidong pan de sadile na ay nappa ni maditas pa.” ");
INSERT INTO due_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dingan sinabi na pala de nangakit diya a magioyo, “Be nangakit ka de hinande mo a pigpanganin ay wet mo aakita i kakoloy mo ide, mangáyun, manga kabinsa pati mayamanin ide a kabeloy mo ta talage a aakit de pala ikaw a bebilosan. ");
INSERT INTO due_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kanya be ikaw ay gehande ay depat a akitin mo i manga mahedepin, kimaw, bulag pati pilay ide. ");
INSERT INTO due_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ta ide ngani i an nakebilos dikaw ta dingan ikaw ay nasalig pala ta bebilosan ka ni Makedepat de inapóan a adow a pagpakaedup de manga gepanulusun ide diya.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nano ay inikna pan non a sinabi ni Hisus ni isin de manga kasaló na ide ta sinabi na, “Talage ngani a piyon i kapuoyen ni misan ino a námangan de kataanan nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Misan ay tinubeg eya ni Hisus, “Te duman a isin a lalaki a nagbelak a gehande ni hanga a pigpanganin ta sinabi na de makmuk a agta i adow. ");
INSERT INTO due_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nano ay nun dinumatong di i adow a hinande na di i pigpanganin ay dinodul na i katabeng na de inakit na ide. Ta sinabi na, ‘Dumuman kamo di ta nahhande di i pesan.’ ");
INSERT INTO due_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Misan ay ide a pesan ay nagduludehilan. I dehilan ni isin de katabeng, ‘Ay nanggetang ok ni putok a depat di a kakangan ko kanya sabiin mo ay anok di nakakang duman ta patáwad ok nad la.’ ");
INSERT INTO due_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Misan ay i dehilan pan ni isin, ‘Ay nanggetang ok ni sangpuwu a beka kanya depat di nano ay sosubukan ko a peadedu ti matibongin ide ta anok di nakakang duman kanya patáwad ok nad la.’ ");
INSERT INTO due_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sinabi pan nun isin, ‘Anok nakakang ta bowon ok a kinasal.’ ");
INSERT INTO due_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Dingan inumampulang i katabeng ta binareta na de panginoon na kanya nagbulas i panginoon na. Ta sinabi na de katabeng na, ‘Bumulwag ka a tambing de kulukarsade ta ikagin mo dio i manga mahedepin ide, kimaw, pilay pati bulag.’ ");
INSERT INTO due_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nano ay nun nakadetong di i katabeng a dinodul na ay sinabi na de panginoon na a ‘Nakatalinga ok di de pagdodul yu deko misan ay kolang pa i gepangan ide.’ ");
INSERT INTO due_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kanya sinabi ni panginoon na diya, ‘Kumang ka de bektas ide pati de buluberiyu ide a pelitin mo a kumang dio i manga agta tangani napino la i beloy ko i. ");
INSERT INTO due_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta pesabi ko dikaw a misan isin de tagibu ide a inakit ay an ide nakápangan ni hinande ko a pigpanganin.’” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nano ay nagisinut de Hisus i makmuk a masakut a kaagtaan de pagtotul na dingan eya ay sinumagkad dide ta sinabi na, ");
INSERT INTO due_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“I misan ino a te buot a nappa ni mag-aadel ko ay depat a namas pa a hanga i pagbuot na deko de pagbuot na de ina, ama, bebi, mangának, kabinsa pati de sadile na a edup. ");
INSERT INTO due_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Pati an nappatud a nappa ni mag-aadel ko i misan ino a an te buot a getagel ni kahedepan a kosa na a innawa a geabut pala de ugeli ko. ");
INSERT INTO due_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Uluesipin yu i kahedepan a nappa de pesan a geabut deko ta be halimbewa buot ni agta a gebeloy ni maditas ay depat ngona a eya ay geuluesip ni gegestus na tangani matinggesan na ti te sukul a kuwarta a patapos na i beloy na. ");
INSERT INTO due_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ta be an ngona eya geuluesip ay makati be kalahati di i beloy na ay an di te sukul a pantapos. Ta talage ngani a gegepoan eya a lelibek ni manga gekita ide diya. ");
INSERT INTO due_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Dingan sasabi ni manga agta a, ‘Nagpagepo i agta a oyo a nagpayedi ni beloy misan ay an di eya te kaya a gepatapos.’ ");
INSERT INTO due_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pati be halimbewa ay te duman a hari a nekilaben de kapadepade na a hari ta eya ay te duman a sangpuwu a lebu a sundelo ta i kalaben na pan ay te aduwa a puwu a lebu ay talage a geesip ngona eya a ti papalano a natalo na i te namas pa a makmuk a sundelo. ");
INSERT INTO due_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta be an sukul i tibong na ay nonodul eya ni pinakalawes na ide hanggen alayu pa i kalaben na ta eya ay nekipagkasungdu di. ");
INSERT INTO due_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kanya depat ngona a mag-uluesip kamo ta be an ngona lelipat ni misan ino dikamo i belang buot na a sadile ay an nappatud a nappa ni mag-aadel ko. ");
INSERT INTO due_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Te halage ngani a magi asin i pagpanulusun yu de Makedepat misan ay be nappa ni mahena i pagpanulusun yu a magi asin a naeyen i alat na ay talage a an di te kabuluhan. ");
INSERT INTO due_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Talage a an di te kabuluhan a unabis ta bobut la ni agta ide de tapunan. I misan ino a gepatalikngoy ay depat a tumalinga.” ");
INSERT INTO due_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nano ay nagilinane de Hisus i magsisengil ide ni buwis pati kakmukan pa a makikkakasalanan ta ide ay nagpatalikngoy de pagsabi na. ");
INSERT INTO due_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Misan ay i Pariseo ide pati magtutodu ide ni Hudyo ay naulit-uletan ide ta sinabi de a, “Petanggep mangan la ni agta a oyo i makikkakasalanan ide ta eya ay gepakisaló la dide.” ");
INSERT INTO due_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kanya pan sinabi ni Hisus i oyo a halimbewa ta sinabi na, ");
INSERT INTO due_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Be i misan ino dikamo ay te isin a dian a topa dingan nalagelag i isin ay ano nano i yeyedi ni te adi? Ay talage a wawalat na i siyam a puwu pati siyam de ilang ta lalawag na ngani un isin a nalagelag hanggen an na kekita. ");
INSERT INTO due_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Dingan be kinta na di ay papassan na a nagkasalig. ");
INSERT INTO due_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pagdetong na de beloy na ay aakit na i mangáyun na ide pati kabeloy na ide a sasabi na, ‘Makisalig kamo pala deko ta nakitan ko di i topa ko a nalagelag.’ Inon i sasabi ni te adi ni topa. ");
INSERT INTO due_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kanya pesabi ko dikamo a hanga pa i salig ni Makedepat tungkul de isin a nagsosol de mammalotin na de siyam a puwu pati siyam a an nalagelag.” ");
INSERT INTO due_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sinabi pala ni Hisus, “Be halimbewa te duman a isin a mahuna a te sangpuwu a pera a pelak dingan nábut i isin ay ano man i yeyedi na? Ay talage ngani a lalawag na pala ta totutuden na i salong a gewelis tangani lalawag na a mapelit hanggen an na kekita. ");
INSERT INTO due_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nano be kinta na di ay aakit na i mangáyun na ide pati kabeloy na ide ta sasabi na dide, ‘Makisalig kamo deko ta kinta ko di nano un pera ko a nábut.’ ");
INSERT INTO due_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kanya pesabi ko dikamo a hanga i salig i manga anghel ide nun Makedepat be te duman a isin a makikkakasalanan a nagsosol.” ");
INSERT INTO due_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sinabi ni Hisus a tuloy, “Te duman a lalaki a te anak ni aduwa a lalaki. ");
INSERT INTO due_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sinabi ni kalog a anak de ama na, ‘Ama ko, buot ko tebe a boyin yu di deko i kabinsa ko a mana a para deko.’ Kanya nun isin a adow ay pinabinsa ni ama de i putok de magwele a mangának na. ");
INSERT INTO due_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nano ay am pa tinumakig i makmuk a adow ay pinanggetang di ni kalog i kabinsa na a putok dingan eya ay tinumotul a paagow de alayu a bensa ta duman na kinanugun i pesan a kuwarta na de an te kabuluhan a edup. ");
INSERT INTO due_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nun maubus di un kuwarta na ay dingan dinumatong di i hanga a tigtegeng de bensa a inon ta eya ay te gepo a nagketigeng di a masakut. ");
INSERT INTO due_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kanya eya ay dinumuman a tinumaan de isin a agta a tage duman a bensa. Misan ay pinakang pan eya ni kinangan na de putok na tangani mag-alage ni kabebuyen na ide. ");
INSERT INTO due_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta buot na tebe a gepakabiyag ni pigpanganin ni manga bebuy ide a anak ni kew misan ay am pan te geboy diya ni sukul a pápangan. ");
INSERT INTO due_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nano ay nun maginon di i gesapit diya ay nakapag-esip eya ni matud ta sinabi na, ‘I manga katabeng ide ni ama ko a peupahan ay te sukul a pápangan a te gesubra pa misan ay dio ok pan a nagkelibun ni tigeng. ");
INSERT INTO due_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kanya nototul ok di a náampulang de ama ko ta dingan sasabi ko diya, “Ama, ako ay nagkasala de Makedepat pati dikamo. ");
INSERT INTO due_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ta anok di nagkaddepat a olangan yu pa ni anak ta yediin yud la a magi isin de katabeng yu a upahan.”’ ");
INSERT INTO due_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kanya eya ay tinumotul ngani a paagow de ama na. Ta nun eya ay alayu pa ay nasayed eya nun ama na. I ama na pan ay nakalbi diya a masakut a ginumikan a tinumagbu de anak na ta dingan kinipotan na a inangutan a tuloy. ");
INSERT INTO due_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Sinabi pan ni anak de ama na, ‘Ama, ako ay nagkasala de Makedepat pati dikamo. Ta anok di nagkaddepat a olangan yu pa ni anak.’ ");
INSERT INTO due_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Misan ay sinabi ni ama na de manga katabeng na ide, ‘Addein yu dio a tambing i pinakamasampat a bedu dena ta dingan pabedu yu diya pati dumanan pala ni singsing i guramut na pati sapatos de singit na ide. ");
INSERT INTO due_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ta amitin yu pala i anak a beka a pinatabe ta dingan bunoin ta masalig kitam a magipinagpangan. ");
INSERT INTO due_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ta i anak ko a oyo a nalagelag a inesip ko a nalibun di misan ay nano ay dinumatong di a liwet a nàedup pa a magi den.’ Inon i sinabi ni ama na ta ide ay te gepo a násalig. ");
INSERT INTO due_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ta i anak pan a panganay ay duman nunde adeduhan ide nun inon a sinumapit. Dingan nun eya ay inumuli di, a duman di nunde alane ni beloy ay inikna na i pagtugtug pati gekasayahan. ");
INSERT INTO due_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kanya inolangan na i isin a katabeng de dingan tinanto na eya, ‘Ano man i kabuluhan niwina a getinog?’ ");
INSERT INTO due_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ta eya ay tinubeg ni katabeng de a magioyo, ‘Dinumatong di i wele yu pati pinabuno ni ama yu un anak a beka a pinatabe ta eya kon ay dinumatong di a liwet a nàedup pa a magi den.’ ");
INSERT INTO due_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Misan ay un anak a panganay ay nagkaduman ni gengsa kanya an eya gesilong nunde beloy. Nano pan ay nun binareta inon nunde ama na ay binumulwag eya ta inaged na diya a mapelit a sumilong nunde beloy. ");
INSERT INTO due_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Misan ay tinubeg na de ama na, ‘Tinumabeng ok dikamo ni makmuk di a taon pati anok nagkapoy de pesan a kabuotan yu. Ta misan pan pakosa ay anok yu biniyen ni misan isin a anak a kambing tangani gekasalegen kami pati mangáyun ko ide. ");
INSERT INTO due_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Misan ay nun dinumatong i anak yu a iwina a nagkanugun ni keedup yu de mahunain a an te manga kabuluhan ay pinagbuno yu eya ni anak a beka a pinatabe.’ ");
INSERT INTO due_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Dingan tinumubeg pala i ama diya, ‘Anak ko, ikaw ay ugnay ko a kakoloy pati i pesan a deko ay dikaw pala. ");
INSERT INTO due_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Misan ay depat kitam a magipinagpangan a masalig ta i wele mo a nalagelag a inesip ko a nalibun di ay dinumatong di a liwet a nàedup a magi den.’ Inon i sinabi ni ama na.” ");
INSERT INTO due_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Dingan sinabi pala ni Hisus de mag-aadel na ide, “Te duman a isin a agta a mayaman a te duman a isin a gepamahala de adi na. Nano ay nun isin a adow ay te nagsumbong pan de mayaman tungkul de gepamahala a pekanugun na kon i kayamanan na. ");
INSERT INTO due_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kanya eya ay pinalawag ni mayaman ta sinabi na diya, ‘Matud man i sumbong a oyo a tungkul dikaw? Yadi pa nano ay boyin mo i pesan a lista ni pepámahalaán mo ta an di nappatud a ikaw ay notuloy pa a gepamahala.’ ");
INSERT INTO due_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Misan ay nadeinnawa ni gepamahala a magioyo, ‘Talage a pototul ok di ni panginoon ko de tungkolin ko. Ta nano ay ano i yeyedi ko? Anok te kaya a getarabeho ni mabiyet pati nagkamamos ok pan a gepalimus. ");
INSERT INTO due_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ay te duman ok di a naesip a piyon a yeyedi ko tangani be ako ay pinatotul di ni panginoon ko ay noduman ok de mangáyun ko ide ta tatanggep ok de de beloy de.’ Inon i nadeinnawa na. ");
INSERT INTO due_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kanya uluisin na a inolangan i te manga otang ide de panginoon na ta sinabi na de tagibu, ‘Pide man i otang yu de panginoon ko?’ ");
INSERT INTO due_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Dingan sinabi ni te otang, ‘I otang ko de panginoon yu ay isin a dian a tapayen a langgis.’ Sinabi ni gepamahala, ‘Wiyo i listahan ni otang yu a isin a dian. Lumipa kamo di a maparipari ta magsolat kamo la ni lima la a puwu.’ ");
INSERT INTO due_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ta sinabi pan di ni gepamahala nunde isin, ‘Pide man i otang yu de panginoon ko?’ ‘Ay i otang ko de panginoon yu ay isin a dian a sako a tirego.’ Dingan sinabi ni gepamahala, ‘Lumipa kamo ta magsolat kamo la ni walo a puwu.’ Inon i yinadi ni gepamahala.” ");
INSERT INTO due_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Sinabi ni Hisus a tuloy, “Misan ay pinodi ni panginoon na i migdeya na a gepamahala dehil de yinadi na a naketingges. Ta i manga an gepanulusun dio de putok i ay naketingges ide a geyedi ni kapiyonan para de sadile de misan ay i manga gepanulusun pan ay mahena ide a geyedi ni kabuotan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Pesabi ko dikamo a manga gepanulusun ay maggemit kamo ni yaman yu dio de putok i a makiayun kamo de mahedepin ide tangani be an di te kabulunan i yaman yu dio ay dingan tatanggep kamo di ni Makedepat de kataanan na de langot. ");
INSERT INTO due_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ta be nappatud a pepanulusonan i misan ino ni untik ay nappatud pala a pepanulusonan ni hanga a bege. Pati be nandeya eya de untik la ay talage ngani a nandedeya de hanga. ");
INSERT INTO due_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kanya be migdeya kamo dio de putok i ay ang kamo ngani papámahála ni Makedepat de matud a kayamanan na de langot. ");
INSERT INTO due_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pati be talage a ang kamo nakapealage ni kayamanan ni kakmukan ang kamo pala bebiyen ni kayamanan a hinande para dikamo de langot. ");
INSERT INTO due_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nano ay an nappatud a i isin a katabeng ay nátabeng de aduwa a panginoon a sabe. Ta be maginon ay kagengsaan na i isin ta bobuot na pan i káduwa o gegelang na i isin ta i káduwa pan ay peeyenan na ni kabuluhan. Talage a ang kamo nappatud a getabeng de Makedepat be i peesip yu la ay i kayamanan yu dio de putok i.” ");
INSERT INTO due_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nano ay nun inikna yo ni pesan a Pariseo ay linibek de i Hisus ta ide ay migbuot a masakut de kuwarta. ");
INSERT INTO due_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kanya sinabi dide ni Hisus a magioyo, “Ikamo mangani i agta a geyedi ni piyon de kasagkaden la ni manga agta misan ay peabuyenan pan ni Makedepat i innawa yu a malot ta i mahalage de pekita ni agta dio de putok i ay an te kabuluhan a unabis de pekita ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Nano ay te kapangyedihan a masakut i pagdodul ide ni Moises pati kasulatan ide ni magsasabi ide a den ni Makedepat hanggen nun dinumatong i Huwen a Maglilenod. Misan ay gepo diya ay te gesabi a ti papalano a te kapangyedihan i Makedepat de innawa ni agta ta kanya i kamakmokan ay te buot a masakut a te kapangyedihan i Makedepat de innawa ke. ");
INSERT INTO due_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Misan ay an neeyenan ni kabuluhan ni misan isin a tolduk i pagdodul ide ni Moises ta mamiyen pa a neeyen i putok pati langot. ");
INSERT INTO due_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Kanya katinggesan tam ay an nagkeeyenan ni kabuluhan i pagdodul ide ta be kekiblagen ni lalaki i bebi na a gebebi a liwet i lalaki ay te kasalanan a pagpakialam inon a lalaki ta be magbebi a liwet inon a mahuna ay nappa ni migpakialam i bebi na a bowon.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Dingan sinabi pa ni Hisus i halimbewa a oyo, “Te duman a lalaki a mayaman a masakut ta eya ay gebedu a ugnay ni masampatin pati de belang adow ay gepangan eya ni sadisadi a pippiyonin. ");
INSERT INTO due_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Te duman pala a lalaki a mahedep ta i ngalan na ay i Lasaro. Eya ay te manga gerot de lawes na ta nappaide de pintohan nun mayaman. ");
INSERT INTO due_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ta buot na di a námangan ni mumu ide a nagkadegdeg de lamesa nun mayaman. Ta i gerot na pan ide ay petipsan di ni mangáso ide. ");
INSERT INTO due_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nano ay nalibun di i mahedep a inadde ni manga anghel ide de langot a alane ni Abraham. Dingan nalibun pala un mayaman a tinapor ni mangáyun na ide i bengkay na. ");
INSERT INTO due_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Misan ay pagdetong na de impiyerno ay nagtiis eya ni hanga a kahedepan ta nun eya ay tinumingala ay kinta na i Abraham pati kakoloy na i Lasaro nunde alayu. ");
INSERT INTO due_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kanya inumolang eya a magioyo, ‘Kaapoapohan ko a Abraham, makalbi kamo deko ta nagkehedepan ok dio a masakut de dilab i kanya pakangin yu dio i Lasaro tangani linodin na i guramut na de orat dingan doloin na de dila ko tangani umagidnaw di.’ ");
INSERT INTO due_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Misan ay tinubeg eya ni Abraham a, ‘Apo ko, esipin mo pan a nun ikaw ay te edup pa de putok ay tinumanggep ka di ni kapiyonan a nappaayun de kabuotan mo ta i Lasaro pan ay nagtiis ni kahedepan duman. Misan ay nano pan ay nagkasalig eya ta ikaw pan ay nagkehedepan dena. ");
INSERT INTO due_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Isin pa duman ay te rongtob a madisalad de pag-etan tam i tangani i napadena ay an di nakedio ta i napadio pan ay an di nakádena.’ ");
INSERT INTO due_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Misan ay sinabi pan ni mayaman, ‘Be maginon, kaapoapohan ko, ay pakangin yu i Lasaro de beloy ni ama ko de putok to i. ");
INSERT INTO due_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ta te duman ok pa a manga kabinsa a lima a lalaki ta eya ay gepaengat tebe dide duman tangani wet ide nappadio de lugel a oyo a padusahan.’ ");
INSERT INTO due_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Misan ay tinubeg diya ni Abraham, ‘Duman pa nano i kasulatan ide ni Moises pati magsasabi ide ni Makedepat kanya duman dila ide gepatalikngoy.’ ");
INSERT INTO due_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dingan tinumubeg un mayaman, ‘Kaapoapohan ko a Abraham, an non ide sukul misan ay be nákang dide i pinakaedup a liwet ay talage ngani a gesosol ide de mammalotin de.’ ");
INSERT INTO due_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Misan ay tinubeg eya ni Abraham, ‘Be an ide gepatalikngoy de kasulatan ide ni Moises pati magsasabi ide ay am pala ide gepatalikngoy misan dumuman i pinakaedup a liwet.’” Inon i sinabi a halimbewa ni Hisus de Pariseo ide. ");
INSERT INTO due_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Dingan sinabi ni Hisus de mag-aadel na ide a magioyo, “Talage a totukso i pesan a agta dio de putok i misan ay gepakatakut i násapit de agta a gepapagkasala de gepanulusun deko. ");
INSERT INTO due_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ta yadi pa ngona a gipotan eya de bong na ni hanga a beto a degdegen eya de ditow a atab be eya la i gepapagkasala de am pa náloy a gepanulusun deko. ");
INSERT INTO due_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kanya mag-engat kamo pala. Nano be nagkásala i kabinsa mo ay sablowin mo la eya ta be gesosol ay patáwed mo eya. ");
INSERT INTO due_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pati be nagkásala eya dikaw ni pakapito a sila de isin a adow dingan sasabi na dikaw a liwet liwet, ‘Gesosol ok.’ Ay depat ngani a patáwed mo eya.” ");
INSERT INTO due_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nano ay sinabi ni mag-aatid ide de Hisus a magioyo, “Panginoon, patibongin yu tebe i pagpanulusun mi de Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Misan ay tinubeg ide ni Panginoon, “Be i pagpanulusun yu de Makedepat ay gehanga a magi untik a binhi a mustasa a nappa ni hanga a gemut a golay ay nappatud a dododul yu i kew a sikomoro a, ‘Bumurnut ka de sadile mo ta dingan tumanom ka de atab to i.’ Ta talage a nangyeyedi ngani i sinabi yu.” ");
INSERT INTO due_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ta sinabi pala ni Hisus a, “Be te katabeng i misan ino dikamo a mag-aadedu o mag-aalage ni topa dingan eya ay inumapo de kaengin yu ay an yu ngani sasabi diya, ‘Ay dumio ka di a mamangan ka di ngona.’ ");
INSERT INTO due_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","I sasabi pan diya ni panginoon na a, ‘Hale di, mag-uges ka di a magpakaluto ni papangan ko ta mag-akod hanggen gepangan ok ta dingan kadla mamangan.’ ");
INSERT INTO due_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pati an depat a gepasalamat i panginoon de katabeng na misan yediin na i pedodul ni panginoon na. ");
INSERT INTO due_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Maginon kamo pala a gepanulusun ta be nagyedi kamo ni pesan a dinodul dikamo ni Makedepat ay an te otang eya kanya depat la a sasabi yu, ‘Ay pigdodulin kami la a an te kabuluhan ni Makedepat ta yinadi mi la i tungkolin mi.’” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nano ay nun paagow i Hisus de Herusalem ay sinumila eya de pag-etan ni Samaria pati Galilea. ");
INSERT INTO due_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Misan ay nun eya ay nesilong di de isin a beriyu ay natagbu na i sangpuwu a lalaki a te manga ketong a nagiinuddi la nunde alayu tangani wet nakàalis i orom de. ");
INSERT INTO due_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Dingan nagiinolang i te manga ketong ide ta sinabi de, “Hisus a Panginoon, makalbi kamo dikami.” ");
INSERT INTO due_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkákita dide ni Hisus ay sinabi na dide, “Magidinoman kamo de maghahandug ide de Makedepat a pakitain yu dide i lawes yu a pinumiyon di.” Ta nun ide ay getotul di ay pinumiyon ngani ide. ");
INSERT INTO due_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Dingan nun matinggesan ni isin dide a eya ay pinumiyon di ay inumampulang eya a geolang a gepodi de Makedepat. ");
INSERT INTO due_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ta eya ay linumuhud de singitan ni Hisus a nagpasalamat. I oyo a agta ay tage Samaria. ");
INSERT INTO due_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Dingan sinabi diya ni Hisus, “Aman la sangpuwu i pinapiyon ni Makedepat? Deno i siyam? ");
INSERT INTO due_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Misan ay malot a an ide inumampulang a nagpodi de Makedepat ti an i agta a oyo a an Hudyo a tage kakmukan a bensa.” ");
INSERT INTO due_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ta sinabi ni Hisus diya, “Umuddi ka di ta tumotul ka de paagowen mo ta pinapiyon ka dehil de pagpanulusun mo deko.” ");
INSERT INTO due_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nun isin a adow ay nagtanto i tipide a Pariseo de Hisus a ti kapide nádetong i kapangyedihan ni Makedepat de putok i kanya tinubeg na ide, “I pagdetong ni kapangyedihan ni Makedepat de putok i ay an te kakoloy a tande a pekita ni mata la. ");
INSERT INTO due_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pati am pala te nakapesabi a te gepo di duman o dio ta i kapangyedihan ni Makedepat ay nappadeinnawa la ni manga gepanulusun diya.” ");
INSERT INTO due_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dingan sinabi ni Hisus de mag-aadel na ide, “Talage a nádetong i panahon a bobuot yu a kekita i adow a pagdetong ko a Pineta nun Makedepat a napa ni agta misan ay an yu pangani kekita. ");
INSERT INTO due_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nano ay pepapag-engat ko ikamo a de inon a panahon ay giddinátong i migdeya a nanabi dikamo a, ‘Duman di kon i Kristo.’ Pati te nanabi pala a, ‘Wiyo di.’ Misan ay wet kamo kumang duman a lalawag yu. ");
INSERT INTO due_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ta i pagdetong ko a Pineta nun Makedepat a napa ni agta ay magi kilat a gepakaingap de pesan a longaw na. ");
INSERT INTO due_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Misan ay depat ngona a kakapoyen ok ni manga agta ide pati getiis ok ni makmuk a kahedepan de nano a panahon. ");
INSERT INTO due_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Misan i panahon a pagdetong ko a Pineta nun Makedepat a napa ni agta ay magi pagdetong a loktat nun bulangay nun panahon ni Noe. ");
INSERT INTO due_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta nun nanon ay i kaagtaan ay gepinagpangan, gepinag-inom, gebebi pati gepabebi hanggen nun adow a sinumilong ide Noe nunde bengka a hanga. Dingan dinumatong un bulangay ta napuksa ide a pesan. ");
INSERT INTO due_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Maginon pala i sinumapit nun panahon ni laki a Lot. Ta nun nanon pala ay i kaagtaan ay gepinagpangan, gepinag-inom, nanggetang, gepanggetang, getanom pati gebeloy. ");
INSERT INTO due_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dingan nun makatotul di i Lot de Sodoma ay te inumapo de langot a apoy pati asopre kanya napuksa i pesan a tage Sodoma. ");
INSERT INTO due_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Talage maginon ngani a naloktat i manga agta de pagdetong ko a Pineta nun Makedepat a napa ni agta. ");
INSERT INTO due_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ta de pagdetong ko ay i naddekatobengan ni beloy na ay wet di nesilong a nangamit ni misan ano de beloy na. Pati i naddekaengin na ay wet di pala nouli a nangamit ni misan ano de beloy na. ");
INSERT INTO due_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pati wet yu kelipatan i bebi ni Lot a napuksa nun nanon ta binuot na a náampulang de kamalotan. ");
INSERT INTO due_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Talage ngani a nakanugun i edup ni misan ino a agta a getalinga la de kabuotan na a sadili misan ay nalligtas pan i geboy ni edup na para deko. ");
INSERT INTO due_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Matud ngani a pesabi ko a de pagdetong ko ay te aduwa a agta de pig-idean de, i isin ay aamit ta i isin pan ay wawalat. ");
INSERT INTO due_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Te duman pala a aduwa a mahunain a gegiling, i isin ay aamit ta i isin pan ay wawalat. ");
INSERT INTO due_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","I aduwa pala a manga lalaki ay getarabeho de kaengin, i isin ay aamit ta i isin pan ay wawalat.” Inon i sinabi ni Hisus de mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Dingan eya ay tinanto ni mag-aadel na ide, “Panginoon, deno man non nangyeyedi?” Ta ide ay tinubeg na, “Ti deno getipun i manga tewak ay duman pala i bengkay ni podusahan ide.” ");
INSERT INTO due_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nano ay nagsurut i Hisus i halimbewa a oyo, a nagtodu de mag-aadel na ide a depat a ide ay ugnay a magpanalangin, a wet nappa ni mahena i innawa de kapide man. ");
INSERT INTO due_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ta sinabi na dide, “De isin a benwaan ay te huwis a an nagkatakut de Makedepat pati an te kalbi de misan dino a agta. ");
INSERT INTO due_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Misan ay de benwaan pan a inon ay te isin pala a belo a mahuna a ugnay gekang diya. Ta pesabi ni mahuna, ‘Tabengan ok yu a nekisurut de katalo ko.’ ");
INSERT INTO due_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ay angani pekalbian nun huwis i mahuna ni pakapide a sila a pag-aged na. Misan ay nadeinnawa ni huwis de inapóan a magioyo, ‘Talage a anok nagkatakut de Makedepat ta anok te kalbi de misan dino. ");
INSERT INTO due_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Misan ay dehil de pag-abela deko ni mahuna a oyo a belo ay depat di a tabengan ko eya a nekisurut de katalo na. Ta be eyen ay makati ugnay a dumio ta talage a náabela ok di a masakut.’” Inon i sinabi ni Hisus a halimbewa. ");
INSERT INTO due_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ta sinabi na a tuloy, “Pagelawagin yu i pagtabeng ni malot a huwis de mahuna a belo. ");
INSERT INTO due_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kanya katinggesan yu a mandeli pangani a nátabeng i Makedepat de pesan a pineta na be ide ay geaged a tuloy adow pati abi ta an na pakáaloy. ");
INSERT INTO due_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Talage ay pesabi ko dikamo a tambing ngani a tatabengan na i manga gepanulusun ide. Misan pagdetong ko a Pineta nun Makedepat a napa ni agta ay te kekita ok pa man a makmuk a gepanulusun pa deko?” ");
INSERT INTO due_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Dingan sinabi ni Hisus i halimbewa a oyo a tungkul de manga agta a geasa a piyon pa i sadile de de kakmukan. ");
INSERT INTO due_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Sinabi na, “Te duman a aduwa a lalaki a sinumalakat de beloy a pighandogen de Makedepat tangani magpanalangin. Ta un isin ay magsisengil ni buwis para de Roma ta i isin pan ay Pariseo. ");
INSERT INTO due_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ta i Pariseo ay inumuddi a nanalangin a nagpodi de sadili na a magioyo, ‘Gepasalamat ok dikamo Makedepat ta anok magiwina a magsisengil ni buwis a an te kabuluhan. Anok geamit ni an para deko. Anok migyedi ni mammalotin pati anok pala gepammahuna. ");
INSERT INTO due_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pati de isin a simbe ay pakaduwa a sila ay anok gepangan tangani magpanalangin pati gehandug ni kasangpuwu de kuwarta ko de pighandogen yu.’ Inon i pagpodi na de sadile na. ");
INSERT INTO due_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Misan ay i magsisengil pan ni buwis ay inumuddi de alane ni pintohan a nagkamamos a netingala de langot. Dingan tinugtug na i alalang na a tande a eya ay nagsosol di ta sinabi na, ‘Ay Makedepat, makalbi kamo deko a makikkakasalanan.’ Inon i pagsosol na de Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sinabi ni Hisus a tuloy, “Talage ay pesabi ko dikamo a dingan ngona nakauli de beloy na i magsisengil ni buwis ay pinakaeyenan di ni mammalotin na. Misan ay i gepodi de sadile na ay eyen. Ta i gepodi de sadile na ay pepakásidong eya de pesan ta i gepakásidong pan de sadile na ay nappa ni maditas pa.” ");
INSERT INTO due_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nano ay te nangadde pan de Hisus ni mangának de a gepinag-aged diya a tapáin na ide misan ay nun kinta yo ni mag-aadel na ide ay sinablow de pan i kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Misan ay pinalane ni Hisus diya i mangának ta sinabi na, “Pabiyaan yu a lumane deko i mangának, a wet yu ide sablowa ta katinggesan yu a de kapadepade de a te masidong a innawa, te kapangyedihan i Makedepat. ");
INSERT INTO due_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Talage ay pesabi ko dikamo a be i misan ino a agta ay an gepakasidong ni innawa na a magi anak ay an nappatud a te kapangyedihan i Makedepat de innawa na, a nakesilong pala de kataanan na.” ");
INSERT INTO due_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nano ay te duman a te kapangyedihan de Hudyo ide a nagtanto diya a magioyo, “Piyon a magtutodu, anóman i depat ko a yeyedi tangani magkaduman ok ni edup a an te kalog?” ");
INSERT INTO due_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tinumubeg i Hisus, “Ano man i dehilan ta inolangan ok mo ni piyon ta am pan te piyon ti an i Makedepat la? ");
INSERT INTO due_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Misan ay katinggesan mo pan di i pagdodul ide a, ‘Wet ka nomuno, wet nekialam de bebi ni kakmukan, wet ka nannanakow, wet ka gebutil de pagpamatud mo pati gelangin mo i kamoddenan mo ide.’” ");
INSERT INTO due_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Misan ay tinubeg nun lalaki, “Tinumalinga ok di de pesan a inon gepo nun geulittaw ok pa hanggen nano.” ");
INSERT INTO due_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Misan ay pagkaikna ni Hisus de inon ay sinabi na, “Te duman ka pa a an nagkayeyedi kanya panggetangin mo i pesan mo a adi ta boyin mo de mahedepin i kapanggetangan na ta dingan gekaduman ka ni kayamanan de langot. Pagkatapos ninon ay umabut ka deko.” ");
INSERT INTO due_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nano ay pagkaikna na ninon ay malungkut eya a masakut ta eya ay mayaman a masakut. ");
INSERT INTO due_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nun pagkakita ni Hisus a nalungkut eya ay sinabi na, “Talage ngani a mahedep a te kapangyedihan i Makedepat de innawa ni agta a geasa la de yaman na. ");
INSERT INTO due_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ta be an nappatud a nesilong i hayup a kamelyo de bulsut ni kadeyum ay namas pa a an nappatud a te kapangyedihan i Makedepat de innawa ni agta a ge-asa la de yaman na.” ");
INSERT INTO due_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Misan ay nagtanto i manga agta a geikna de inon a sinabi de, “Be maginon ay ino pan i nalligtas?” ");
INSERT INTO due_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ta tinubeg ide ni Hisus, “Talage a an nappatud a leligtas ni agta i sadile de misan ay te kaya i Makedepat a nangyeyedi ni misan ano a buot na.” ");
INSERT INTO due_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Dingan sinabi ni Pedro, “Pagelawagin yu ta winalat mi i pesan, a inumabut kami la dikamo.” ");
INSERT INTO due_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kanya ide ay tinubeg ni Hisus, “Talage ay pesabi ko dikamo a i misan ino a getiis, a walatin na i beloy na, bebi, mangának, manga kabinsa, kamoddenan, a gesabi pala a ti papalano a te kapangyedihan i Makedepat de innawa ni agta ");
INSERT INTO due_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ay tatanggep na ngani de nano a panahon i makmuk pa a masakut a kapiyonan pati de nádetong pan a panahon ay te duman eya ni edup a an te kalog.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nano ay binukud ni Hisus i sangpuwu pati aduwa a mag-aadel na ta sinabi na dide, “Patalikngan yu ta násakat kitam di de Herusalem. Ta duman ay nangyeyedi i pesan a nappaayun de sinolat ni magsasabi ide a den a tungkul deko. ");
INSERT INTO due_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ta ako a Pineta nun Makedepat a napa ni agta ay boboy de an Hudyo ide a lelibek ok de, a bobugen, a yeyedian de pa ni malot a an te gelang. ");
INSERT INTO due_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ta ako ay paapdisan de a bobuno a tuloy misan ay de katiluwon a adow ay pakeedup ok a liwet.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Misan ay an katinggesan ni mag-aadel na ide inon a sinabi na ta nattagu pan dide i kabuluhan ninon. ");
INSERT INTO due_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nano ay nun palane di i Hisus de benwaan a Heriko ay te gelipa de kaginglan nun bektas i lalaki a bulag a geaged duman ni limus na. ");
INSERT INTO due_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nun inikna na i makmuk a agta a gesila duman ay nagtanto eya, “Ino ino kamo man a kaagtaan?” ");
INSERT INTO due_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ay dingan tinubeg de diya, “Gesila di i Hisus a tage Nasarit.” ");
INSERT INTO due_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dingan pagkaikna na ninon ay inumolang eya a magioyo, “Hisus a apo ni Debid, makalbi kamo deko.” ");
INSERT INTO due_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Misan ay sinablow eya ni kaagtaan a naona de Hisus tangani tumimok eya misan ay namas na pa ngani a pinalagdu i pag-ólang na a sinabi, “Apo ni Debid, makalbi kamo deko.” ");
INSERT INTO due_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kanya tinumimok i Hisus de pagtotul na dingan pinakangan na un bulag de alane na a tinanto na eya, ");
INSERT INTO due_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ano man i buot mo a yeyedi ko dikaw?” Tinumubeg un bulag, “Panginoon, buot ko tebe a nakakkita di.” ");
INSERT INTO due_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dingan sinabi diya ni Hisus, “Nakakita ka di ta dehil de pagpanulusun mo deko ay pinapiyon ka.” ");
INSERT INTO due_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ay tambing ngani a nakakita eya ta eya ay inumabut dila de Hisus a gepodi de Makedepat. Pati i pesan a nakakita de sinumapit a inon ay nagpodi pala ide de Makedepat. ");
INSERT INTO due_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nano ay sinumilong ide Hisus de benwaan a Heriko ta sinumila ide de benwaan. ");
INSERT INTO due_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ta te duman pan duman a isin a lalaki a te ngalan a Sakeo a ponu ni magsisengil ide ni buwis. Pati eya ay mayaman. ");
INSERT INTO due_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pinelit na a kitain i Hisus ti magi ino eya misan ay an nappatud ta makmuk a masakut i agta pati eya ay masidong a masakut. ");
INSERT INTO due_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kanya eya ay ginumikan a naona a dinumawet de kew a sikomoro tangani kitain na la i Hisus a nesila de tipong na a bektas. ");
INSERT INTO due_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ta pagkatipong diya ni Hisus ay tinumingala eya a sinabi na, “Sakeo, lumusong ka a tambing ta depat ok a nekipilong de beloy mo nano.” ");
INSERT INTO due_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kanya eya ay linumusong a tambing ta tinanggep na a piyon i Hisus de beloy na a nagkasalig a masakut. ");
INSERT INTO due_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Misan ay nun kinta yo ni manga agta ay naulit-uletan ide ta sinabi de, “Ay bekot pan ta nekipilong i Hisus de beloy ni agta a iwina a makikkakasalanan.” ");
INSERT INTO due_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nun ide ay duman di nunde beloy ay inumuddi i Sakeo ta sinabi na de Panginoon, “Panginoon, nano ay boboy ko di de mahedepin i kalahati ni yaman ko pati be nakadeya ok de pagsingil ko ni buwis ay aampulang ko diya ni subra pa.” ");
INSERT INTO due_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kanya sinabi diya ni Hisus, “Talage ngani a gepo nano ay dinumatong di de beloy a oyo i kaligtasan ta i Sakeo ay te pagpanulusun pala a magi kaapoapohan tam a Abraham. ");
INSERT INTO due_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ta ako a Pineta nun Makedepat a napa ni agta ay dinumio de putok i tangani lawagin a ligtasin pala i manga nalagelag ide a te buot a gesosol.” ");
INSERT INTO due_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ta pagkasabi na ninon ay sinabi na pala i halimbewa a oyo. Alane di ide Hisus de Herusalem ta inesip a mali ni kaagtaan a napa ni hari a mandeli i Hisus dio de putok i. ");
INSERT INTO due_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kanya sinabi na, “Te duman a lalaki a te kapangyedihan ta kinumang de alayu a bensa tangani tatanggep na di i tungkolin na a hari ta be nátanggep na di ay náampulang. ");
INSERT INTO due_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Misan ay dingan ngona eya tinumotul ay pinalane na diya i katabeng na ide a sangpuwu ta biniyen na i belang isin dide ni uluisenan a kuwarta a ginto. Ta sinabi na, ‘Pamuhonan yu yo hanggen de pagdetong ko tangani magkapakinabeng ok ni hanga.’ Inon i sinabi na. ");
INSERT INTO due_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Misan ay pagkagengsaan pan a masakut i agta a oyo ni tage duman pala ide de bensa na kanya nanodul ide ni pinakalawes de a nanabi nunde hari a kaditasan a, ‘I agta a oyo ay am mi buot a nappa ni hari mi.’ ");
INSERT INTO due_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Misan ay pineta pan i te kapangyedihan a napa ni hari dingan inumampulang di de bensa na. Ta pagdetong na ay pinaolangan na i biniyen na ide ni uluisenan a kuwarta a ginto tangani matinggesan na, tipide di i napa ni pakinabeng ni kuwarta na. ");
INSERT INTO due_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nano ay linumane diya i tagibu ta sinabi na, ‘Panginoon, i kuwarta yu ay nagkapakinabeng pan ni sangpuwu pa.’ ");
INSERT INTO due_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Dingan sinabi na de katabeng a inon, ‘Masampat i yinadi mo ta piyon ka a katabeng. Ta dehil de naponulusonan ka de untik ay papámahala ka de sangpuwu a benwaan a hangain.’ ");
INSERT INTO due_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nano ay linumane diya i káduwa ta sinabi na, ‘Panginoon, i kuwarta yu a isin ay nagkapakinabeng ni lima pa.’ ");
INSERT INTO due_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ta sinabi diya ni panginoon na, ‘Papámahala ka de lima a benwaan a hangain.’ ");
INSERT INTO due_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Misan ay linumane pan diya i isin pa a katabeng ta sinabi na, ‘Panginoon, dio la i kuwarta yu a tiningos ko de panyu. ");
INSERT INTO due_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ta nagkatakut ok dikamo ta ikamo ay mahigpit ta mig-amit kamo ni an dikamo pati geguto kamo ni an yu pinasok.’ Inon i sinabi na. ");
INSERT INTO due_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Dingan eya ay tinubeg ni panginoon na, ‘Malot ka ngani a katabeng ta de inon a surut mo ay pamatoden ko ngani a ikaw ay malot a katabeng. Ta katinggesan mo mangani a ako ay mahigpit a gegemit ok pa ni an deko pati geguto ok ni ang ko pinasok. ");
INSERT INTO due_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kanya bekot ta am mo pinuoy i kuwarta ko de bangko tangani nagkaduman ok nano ni kuwarta ko pati pakinabeng na?’ ");
INSERT INTO due_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ta sinabi na de kauluuddi duman, ‘Amitin mo diya i isin a kuwarta ta boyin mo de te sangpuwu di.’ ");
INSERT INTO due_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Misan ay sinabi de diya, ‘Panginoon, ay te duman di eya ni sangpuwu. Ano pan ta dodugengan pa ni isin pa?’ ");
INSERT INTO due_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tinumubeg un hari, ‘Talage ay pesabi ko dikamo a i misan ino a te duman di ay bebiyen pa ni subra misan ay i te duman ni untik la ay aamit pangani i pesan. ");
INSERT INTO due_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nano ay tungkul pan de manga nagkagengsa ide deko a an de buot a ako i nanákup dide ay ikagin yu ide dio ta bunoin yu de kasagkaden ko i.’” ");
INSERT INTO due_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nano ay pagkasabi ni Hisus ninon a halimbewa de manga agta ide ay dingan eya ay tinumotul a naona dide a pasakat de Herusalem. ");
INSERT INTO due_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pagsakat de a palane de Herusalem ay dinumatong ide de karipakip ni Kalasan a Olibo a alane de benwaan ide a Betpag pati Betania. Dingan pinapaona ni Hisus i aduwa a mag-aadel na. ");
INSERT INTO due_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ta sinabi na dide, “Kumang kamo de nosunud a beriyu ta de pagsilong yu la duman ay kekita yu a naggipot i am pa matande a asno a am pa pesakoyen ta ukasan yu a uweyin dio. ");
INSERT INTO due_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta be te nagtanto dikamo a, ‘Ti ano a peukasan yu.’ Ay sabiin yu, ‘Kaelangan yo ni Panginoon.’” Inon i pagdodul ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dingan tinumotul ngani i manga dinodul na ide ta kinta de i magi sinabi na dide. ");
INSERT INTO due_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nano nun peukasan de un hayup ay tinanto ngani dide nun te manga adi, “Ano pan ta peukas yu nay?” ");
INSERT INTO due_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Misan ay tinumubeg ide, “Kaelangan yo ni Panginoon.” ");
INSERT INTO due_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ta dingan inuwey de un hayup de Hisus ta dinasa de de idog nun hayup i kulapyaw de ta dingan pinasakoy de i Hisus. ");
INSERT INTO due_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nano ay nun eya ay nappasakoy a getotul di ay dinasá pan ni kaagtaan i kulapyaw de de bektas a sesilan ni Hisus a paggelang de diya. ");
INSERT INTO due_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nun nagkalane di ide de Herusalem de pagdolug nun karsade de Kalasan a Olibo ay i pesan a geabut diya ay nagpodi a malagdu de Makedepat, a nagkasalig dehil de gepakataka a yinadi ni Hisus a kinta de. ");
INSERT INTO due_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ta sinabi de, “Podiin eya a Hari a gedetong a te kapangyedihan ni Panginoon a Makedepat. Talage a gekaduman ni kasampatan a innawa i manga agta dio ta magpasalamat kitam di de Makedepat.” Inon i pagpodi de. ");
INSERT INTO due_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Misan ay sinabi pan diya ni tipide a Pariseo a kakoloy ni kamakmokan, “Magtutodu, sablowin yu pan i mag-aadel yu na ide a wet ide magpodi dikamo.” ");
INSERT INTO due_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Misan ay tinubeg na pan dide, “Pesabi ko dikamo ngani a be an di gepakasurut i kaagtaan ide a oyo ay i kabetoan di a oyo i nosurut a gepodi deko.” ");
INSERT INTO due_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ay nun alane di i Hisus de Herusalem a pekita na di ay napatangos eya a kinalbian na de manga tage duman ide dehil de padusa a nádetong dide. ");
INSERT INTO due_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ta sinabi na, “Ay ikamo a manga tage Herusalem ay kakulukalbi ta be katinggesan yu tebe i kapiyonan ni Makedepat para dikamo hanggen de adow a oyo misan ay petagu yo dikamo. ");
INSERT INTO due_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta nádetong i adow a te kahedepan kamo a kokolong kamo ni kapagebuk yu ide a sundelo ta aabetan kamo de magduludibelew. ");
INSERT INTO due_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Talage a nopuksa kamo pati mangának yu ide a naddegitna ni benwaan yu ta nesede i pesan a kabeloyen ide dehil de an yu buot a inabuyenan i magliligtas a pinakang dikamo ni Makedepat.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pagdetong na de Herusalem ay sinumilong i Hisus de beloy a pighandogen de Makedepat ta pinangalow na duman i magpapanggetang ide. ");
INSERT INTO due_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ta sinabi na, “Pesabi ni kasulatan a, ‘I beloy ko ay talage a pigpanalanginan la misan ay peyedi yu pan a pigtaanan ni tulisan ide.’” ");
INSERT INTO due_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nano ay adow adow ay nagtodu i Hisus de beloy a pighandogen de Makedepat. Nun inikna i pagtodu na ni ponu ide ni maghahandug ide, magtutodu ide ni Hudyo pati ni pesan a te kapangyedihan de Hudyo ide ay linawag de i pagkakataon a mapabuno de i Hisus. ");
INSERT INTO due_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Misan ay an la ide te kaya a yeyedi diya i malot dehil de manga agta a te buot a masakut a gepatalikngoy de pagtodu na. ");
INSERT INTO due_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nun isin a adow a nagtodu i Hisus de beloy a pighandogen de Makedepat, a nagsabi de kaagtaan ni piyon a bereta ay linumane diya i ponu ide ni maghahandug ide, magtutodu ide ni Hudyo, pati pinakamatande ide. ");
INSERT INTO due_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ta tinanto de eya, “Ano man i kapangyedihan mo a nagyedi ni maginon pati ino i nagboy ni kapangyedihan a inon?” ");
INSERT INTO due_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Misan ay tinumubeg dide i Hisus, “Tatanto ko pala ikamo ni pakosa ta tubegin ok yu. ");
INSERT INTO due_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Dino pala inumapo i kapangyedihan ni Huwen a Maglilenod a gelinod ni agta. De Makedepat man o de agta la?” ");
INSERT INTO due_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ay dingan ide ay nasurutsurotan, “Be sasabi tam a, ‘De Makedepat,’ ay sasabi na pan a, ‘Bekot ta an yu tinalingaan?’ ");
INSERT INTO due_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Misan ay be sasabi tam a ‘De agta la,’ ay makati bonglagin kitam pan ni manga agta ta peabuyenan de a i Huwen ay magsasabi ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kanya sinabi de diya, “Am mi katinggesan.” ");
INSERT INTO due_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sinabi pala dide ni Hisus, “Be maginon ay ang ko pala sasabi dikamo ti ino i nagboy deko ni kapangyedihan a geyedi ni pesan a inon.” ");
INSERT INTO due_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nano ay nagsabi i Hisus de kaagtaan ni oyo a halimbewa, “Te duman a agta a nagpatanom de pigtanoman na ni lanut a obes. Pagkatapos ninon ay winalat na nunde taohan na ide ta eya ay kinumang de kakmukan a bensa a nátaan eya ni naaloy duman. ");
INSERT INTO due_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nano ay nun dinumatong di i panahon a pagpisa nun obes ay pinakang nun te adi i katabeng de taohan na ide tangani boboy de i kabinsa na. Misan ay pagkakita pan nun taohan ide ay binalbel de un dinodul dingan pinatotul de eya a an te adde ni misan ano. ");
INSERT INTO due_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nano ay nagdodul pa a liwet ni isin pa a katabeng na ta binalbel de pala eya a yinadian ni an te gelang ta dingan pinatotul de eya a an te adde ni misan ano. ");
INSERT INTO due_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dinodul na pala i katiluwon a katabeng na ta eya ay binigeden de dingan pinatotul de. ");
INSERT INTO due_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Misan ay naddeinnawa pan ni te adi a, ‘Ano i piyon a yeyedi ko? Yadi pa a i pakang ko ay i anak ko a pebuot ta sigudu ay gegelang de di eya.’ ");
INSERT INTO due_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ta nun kinta nun taohan ide un anak nun te adi ay nasurutsurotan ide a magioyo, ‘Iwina i gemana ni pigtanoman i. Hale di, bunoin tam tangani mapadikitam di i mamana na.’ ");
INSERT INTO due_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Dingan binulwag de de ditow nun pigtanoman a binuno a tuloy.” Nano ay tinanto ni Hisus i kaagtaan ide, “Ano man i yeyedi ni te adi ni pigtanoman de taohan na ide?” ");
INSERT INTO due_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Sinabi na a tuloy, “Talage a noduman i te adi ta popuksa na inon ide a taohan dingan pataanan na de kakmukan un pigtanoman a inon.” Nano ay pagkaikna ni manga agta ide ay sinabi de, “Wet tebe nangyeyedi i maginon.” ");
INSERT INTO due_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Misan ay nun pinakalawag ide ni Hisus ay sinabi na, “An yu pa man nagkabesa i pesabi ni Makedepat de kasulatan, ‘I beto a kinapoyen ngona ni magyeyedi ide ni beloy ay eya pan i namas pa a pinakamahalage a beto de iwina a yinadi a beloy.’” ");
INSERT INTO due_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Sinabi ni Hisus a tuloy, “I misan ino a nadegdeg de beto a inon ay nebigedbigeden ta i madegdegen pan ni beto a inon ay norupus ngani a magi delpong.” ");
INSERT INTO due_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nano ay nun odes pala a inon ay dedekop tebe i Hisus ni magtutodu ide ni Hudyo pati ponu ide ni maghahandug ide dehil de katinggesan de a ide i pesabian na de halimbewa a inon. Misan ay nagkatakut pan ide de manga agta. ");
INSERT INTO due_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kanya nag-ilat ide ni pagkakataon ta nagpakang ide de Hisus ni tipide a magdedeya a geyedi ide a magi ide ay piyon ta buot de a maamit i mali de surut na tangani hahabla de eya de gubernador. ");
INSERT INTO due_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ta sinabi de, “Magtutodu, katinggesan mi a ikamo ay gesurut pati getodu ni kamatoden ta getodu kamo a nappaayun de kabuotan ni Makedepat. Pati ang kamo te pepeta a agta. ");
INSERT INTO due_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kanya nagkaddepat man de pagdodul ide a gebeyed ni buwis o eyen de Hari a Kaditasan de Roma?” ");
INSERT INTO due_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Misan ay katinggesan ni Hisus a ide ay gedeya la kanya sinabi na dide, ");
INSERT INTO due_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Dio yu i kuwarta a pelak a pambuwis.” Dingan tinanto na ide, “Dino man a leterato pati ngalan i napa dio de pelak i?” Tinumubeg ide, “De Hari a Kaditasan de Roma.” ");
INSERT INTO due_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kanya sinabi na dide, “Be maginon ay boyin yu de Hari a Kaditasan i para diya ta boyin yu pala de Makedepat i para diya.” ");
INSERT INTO due_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nano ay an ide te kaya a gedeya diya de kasagkaden ni kaagtaan kanya an dila ide nakayamyam pati nagtaka ide a masakut de tubeg na dide. ");
INSERT INTO due_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Te duman a tipide a Saduseo a linumane de Hisus ta ide ay an gepanulusun a pakeedup a liwet i nalibunin. ");
INSERT INTO due_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ta sinabi de de Hisus. “Magtutodu, nagsolat i Moises ni pagdodul a para dikitam a, ‘Be nalibun i isin a lalaki ta nawalat na a an te anak i bebi na ay depat a gepakasal i wele na a lalaki de belo a mahuna tangani magkaanak ide para de nalibun.’ ");
INSERT INTO due_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ta nano ay te pito a magiwinale a manga lalaki. Ay nagbebi un kaka de misan ay nalibun eya a an nagkaanak. ");
INSERT INTO due_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Misan ay maginon pala i nangyedi de káduwa ");
INSERT INTO due_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","pati de katiluwon hanggen nunde kapito di ay nalibun pala a an nagkaanak. ");
INSERT INTO due_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ay de inapóan ay nalibun pala un mahuna. ");
INSERT INTO due_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nano, ino dide i nappa ni bebi nun mahuna be te pagkaedup a liwet ta i pito pan ay napa ni bebi na dio?” ");
INSERT INTO due_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tinubeg dide ni Hisus, “I manga lalaki pati mahunain ay nappatud la a gebebian o gepabebi hanggen nappataan pa ide de putok i. ");
INSERT INTO due_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Misan i manga lalaki pati mahunain a nagkaddepat a pakeedup a liwet, a nátaan de langot ay an di ngani nappatud a gebebian pa ide o gepabebi. ");
INSERT INTO due_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ta ide ay magi manga anghel ide a an di nelibun pa ta mangának di ide ni Makedepat a pinakaedup na a liwet. ");
INSERT INTO due_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tungkul pan de liwet a pagkaedup ay nagpamatud pala i Moises a pakeedup a liwet ni Makedepat i nalibunin nun solatin na i tungkul de gedilab a kew a masidong. Ta, nunde kasulatan a inon ay sinabi ni Moises a i Panginoon a Makedepat ay pepodian pa ni Abraham, Isak pati Hakob. ");
INSERT INTO due_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pati katinggesan tam ngani a i Makedepat ay an Makedepat ni nalibunin ta i nàedupin la ta nagkeedup i pesan para diya.” ");
INSERT INTO due_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kanya sinabi ni tipide a magtutodu ni Hudyo, “Talage ngani a matud i sinabi yu, magtutodu.” ");
INSERT INTO due_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ta gepo nun nanon ay an di te nagtanto diya a manga Saduseo ta námamos ide. ");
INSERT INTO due_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Dingan sinabi dide ni Hisus, “Ano ta pesabi ni magtutodu ide ni Hudyo a i Kristo kon a Pinangako nun Makedepat ay apo ni Debid a Hari tam a den? ");
INSERT INTO due_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Misan pan ay i Debid i nagsolat de manga kanta a magioyo, ‘Sinabi ni Panginoon a Makedepat de Panginoon ko a lumipa ka de awenan ko a te kapangyedihan ");
INSERT INTO due_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ta padeog ko dikaw i kapagebuk mo ide.’ ");
INSERT INTO due_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kanya be pengalanan ni Debid i Kristo a, ‘Panginoon ko’ ay papalano man a napa ni apo ni Debid i Kristo?” ");
INSERT INTO due_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nano ay de peikna ni kaagtaan ay sinabi ni Hisus de mag-aadel na ide, ");
INSERT INTO due_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mag-engat kamo de ugeli ni magtutodu ide ni Hudyo a gemayabeng, a getotul a nappabedu ni anduwonin ta buot de a betiin ide ni gekita ide dide de kulukarsade. Ta i buot de pala ay i manga hinande a piglipaan de pigmitengan ide pati de hinande ide a pigpanganan. ");
INSERT INTO due_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pati gepanalangin pala ide ni anduwon tangani esipin ni agta a ide ay te piyon a ugeli misan ay peubus de pan la i keedup ni mahunain ide a belo kanya pan namas pa a mabiyet i nádetong a padusa dide.” ");
INSERT INTO due_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nun ide ay duman pa de beloy a pighandogen de Makedepat ay pinagelawag ni Hisus i mayamanin a gehandug ni kuwarta de de pigpuoyen ni handug. ");
INSERT INTO due_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ay kinta na pala i mahedep a mahuna a belo a gehandug pala ni aduwa la a pera. ");
INSERT INTO due_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ta sinabi ni Hisus, “Talage ay pesabi ko dikamo a inon a hinandug ni belo a mahedep ay namas pa a mahalage de makmuk a hinandug ni mayamanin ide. ");
INSERT INTO due_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ta i mayamanin ide ay naghandug ni subra la de kaelangan de misan ay i hinandug ni mahuna a inon a mahedep ay kádu dila ni keedup na.” ");
INSERT INTO due_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ta pinasurutsurotan ni tipide de kakoloy ide ni Hisus i beloy a pighandogen de Makedepat, “Pagelawagin yu ta hangain i beto a ginamit dio pati pasampat a beto a hinandug.” Misan ay tinubeg ide ni Hisus, ");
INSERT INTO due_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tungkul de beloy a oyo a pekita yu a masampat, de nádetong a adow ay an te nattide dena a beto a nappulupatongan ta neregen a pesan.” ");
INSERT INTO due_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kanya eya ay tinanto de, “Magtutodu, kapide man nangyeyedi i sinabi yu a inon pati ano i nappa ni tande be mandeli di a nádetong i pesan a oyo?” ");
INSERT INTO due_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ay tinubeg na ide, “Mag-engat kamo tangani wet kamo nadedeya ni misan ino a agta. Ta makmuk i nádetong a gesabi a ide i Kristo. Ta te gesabi pan a mandeli di i inapóan a panahon misan ay wet kamo manulusun dide. ");
INSERT INTO due_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nakàikna kamo ni gelaben pati gulo. Ay wet kamo matakut ta depat ngona a mangyedi i oyo ide a pesan misan ay am pa i kalog ni panahon. ");
INSERT INTO due_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Ta i bensa a isin ay nekilaben de isin pala a bensa ta nekilaben pala i hari ide de kakmukan a hari. ");
INSERT INTO due_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Te duman pala a nádetong a tigtegeng, manga orom pati noyogyog a malagdu de misan deno a lugel. Pati te gepakatakut pati tande a masakut a gepo de langot. ");
INSERT INTO due_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Misan ay dingan ngona nangyeyedi i pesan a oyo ay dedekop de ikamo a pehedepan ta aadde de de pigmitengan a totulutanto a bebilanggo a tuloy. Ta dehil de pagpanulusun yu deko ay pasagkad de ikamo de manga gubernador ide pati manga hari ide. ");
INSERT INTO due_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ta te pagkakataon kamo ngani a gepamatud tungkul de piyon a bereta. ");
INSERT INTO due_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kanya patibongin yu i innawa yu, a wet nagkogulo i ti ano i totubeg yu dide. ");
INSERT INTO due_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ta de odes ngani a inon ay bebiyen ko ikamo ni surut pati katinggesan tangani an nappatud a nekipagtalo dikamo i kapagebuk yu ide, a am pala nakapengeyen ide de katinggesan yu. ");
INSERT INTO due_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nano ay padekop kamo ni kamoddenan ide, kabinsa, mittanak pati mangáyun yu ide ta i tipide dikamo ay pobuno de. ");
INSERT INTO due_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kagengsaan kamo ni pesan dehil de pagpanulusun yu deko. ");
INSERT INTO due_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Misan ay pealagean kamo ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ta i getiyage de pagpanulusun na deko hanggen de kalog ay nalligtas ngani. ");
INSERT INTO due_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nano be kekita yu di a nallebut di ni hukbo ide i Herusalem ay katinggesan yu ngani a an di naaloy ay nopuksa di i manga tage duman ide. ");
INSERT INTO due_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dingan depat a nelimok de kalasan i pesan a nappataan de lugel ni Hudia ta i nadde Herusalem ide ay depat pala a tumotul duman pati wet di nesilong duman i naddeditow ide. ");
INSERT INTO due_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ta inon ide a manga adow ay nammatud di i pagpadusa ni Makedepat a magi sinabi ni kasulatan ide a den. ");
INSERT INTO due_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kakulukalbi ngani i mabsuin pati gepinagpasusu de manga adow a inon ta gekaduman i kaagtaan ni hanga a kahedepan ta i manga Hudyo ide ay gekaduman ni padusa. ");
INSERT INTO due_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ta i manga Hudyo ay bobuno de padean ni utak. I kakmukan pan ay eikag de pesan a bensa. Ta gepo de inon ay i an Hudyo ide i gesákup de Herusalem hanggen an nádetong i pineta a adow a ide ay pototul di duman. ");
INSERT INTO due_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Te manga tande pala de adow, bulan pati butatala ide ta de putok ay gekaduman ni hanga a takut pati gulo de manga agta de pesan a bensa dehil de agewak ni atab pati loktat a hangain a labun. ");
INSERT INTO due_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Talage ngani a hanggen peesip ni manga agta i kahedepan a nádetong de putok i ay nanghehena i innawa de dehil de takut de. Ta i te kapangyedihan de longaw na ay neeyenan di ide ni kapangyedihan de. ");
INSERT INTO due_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ta dingan kekita ok de a Pineta nun Makedepat a napa ni agta a gelusong a nappa de kunom a te kapangyedihan pati gepakaingap a masakut. ");
INSERT INTO due_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nano be te gepo di a nangyeyedi i pesabi ko a oyo ay depat a te pag-asa i belang gepanulusun deko ta mandeli dingani a leligtas kamo.” Inon i pagtodu ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ta dingan sinabi na i halimbewa a oyo, “Pagelawagin yu i kew a igos pati pesan a kew ");
INSERT INTO due_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ta be kekita yu a geagid di ay katinggesan yu ngani a alane di i tig-adlas. ");
INSERT INTO due_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Maginon pala be kekita yu i pesan a sinabi ko ay katinggesan yu di a alane di i panahon a pagdetong ko a te kapangyedihan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Talage a matud ay pesabi ko dikamo a te duman a tipide a agta a gekita de gepo a gepakatakut a nangyeyedi a an nelibun hanggen an de kekita i inapóan a gepakatakut. ");
INSERT INTO due_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Talage ay nesede di i langot pati putok i misan ay i surut ko pan ay angani neeyenan ni kabuluhan. ");
INSERT INTO due_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mag-engat kamo a wet mag-esip a tuloy ni tungkul de subra a pápangan yu, de pagbugnang yu pati de attanan a buot yu a sadili dio ta makati ang kamo nappahande de pagdetong ko a loktat. ");
INSERT INTO due_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ta nádetong ngani i paghatol ni Makedepat de pesan a manga agta de disapow ni putok i de odes a an de katinggesan. ");
INSERT INTO due_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kanya depat a maghande kamo a ugnay a magpanalangin tangani te tibong kamo a nakeligtas pala de malot a inon a nangyeyedi, a nakouddi kamo de kasagkaden ko a Pineta nun Makedepat a napa ni agta.” ");
INSERT INTO due_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nano ay adow adow ay nagtodu i Hisus de beloy a pighandogen de Makedepat misan ay de belang abi ay getotul ide a paagow de Kalasan a Olibo ta duman ide gepilong. ");
INSERT INTO due_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ta de belang abiabi pala ay gekang de beloy a pighandogen de Makedepat i makmuk a manga agta ta ide ay gepatalikngoy de pagtodu na. ");
INSERT INTO due_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nano ay alane di i kaadowen ni Tinapay a An Te Pahelab a te ngalan pala a kaadowen ni Paskuwa. ");
INSERT INTO due_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ta i ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo ay napapag-esip ide a ti papalano a pobuno de i Hisus de an katinggesan ni makmuk ta nagkatakut ide de kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dingani linumane di i Satanas de Hodes Iskariyote a isin de sangpuwu pati aduwa. ");
INSERT INTO due_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kanya pan kinumang i Hodes de ponu ide ni maghahandug ide pati de ponu ide ni magbebentay ide de beloy a pighandogen de Makedepat tangani mapadekop i Hisus dide. ");
INSERT INTO due_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kanya nasalig ide nun inikna de inon ta nangako ide a bebiyen de ni kuwarta. ");
INSERT INTO due_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ta eya ay tinumalinga di kanya gepo nun nanon ay napapag-esip di i Hodes ni pagkakataon a mapadekop na i Hisus de an katinggesan ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nano ay dinumatong di i tagibu a adow ni Tinapay a An Te Pahelab ta inon pala i depat a adow a paghandug ni topa ide a pigpanganin de Paskuwa. ");
INSERT INTO due_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kanya dinodul ni Hisus i Pedro pati Huwen a tinutugun na ide a magioyo, “Kumang kamo a maghande para dikitam ni pangapun de Paskuwa.” ");
INSERT INTO due_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ta tinanto de eya, “Deno i buot yu a gehande kami?” ");
INSERT INTO due_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ay tinubeg na ide, “Patalikngan yu ta pagdetong yu de Herusalem ay te nattagbu kamo a isin a lalaki a gétabu ta diya kamo umabut misan deno nesilong a beloy. ");
INSERT INTO due_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ta tantoin yu de te adi ninon a beloy a, ‘Pesabi ni magtutodu mi a ti deno a kuwarto nappatud a eya pati mag-aadel na ide ay námangan ni pangapun a Paskuwa?’ ");
INSERT INTO due_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ta totodu na dikamo i isin a hanga a kuwarto de ditas a te nappahande a gegemit yu ta duman kamo maghande para dikitam.” ");
INSERT INTO due_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dingan kinumang ngani de Herusalem i aduwa ta kinta de ngani i magi sinabi dide ni Hisus ta naghande ide ni pangapun a Paskuwa. ");
INSERT INTO due_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nano ay nun odes di ay dinumatong i Hisus pati mag-aatid na ide a námangan. ");
INSERT INTO due_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ta sinabi na dide, “Binuot ko a masakut a gesaló kitam de oyo a pangapun a Paskuwa dingan ok ngona maghedep a nelibun a tuloy. ");
INSERT INTO due_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pesabi ko ngan dikamo a anok di námangan ni oyo a liwet hanggen anok naeisin pati pesan a gepanulusun a gesaló de kataanan nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dingan inamit na i pig-inoman ni tayug a malanis ta nun nagpasalamat de Makedepat ay sinabi na, “Amitin yu i oyo ta uminom kamo a pesan. ");
INSERT INTO due_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta pesabi ko dikamo a gepo nano ay anok di neinom ni oyo a tayug a malanis hanggen an pepakita i kapangyedihan ni Makedepat dio de putok i.” ");
INSERT INTO due_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pagkatapos ninon ay nangamit eya ni tinapay ta nagpasalamat de Makedepat dingan pinisangpisang na a binuluboy de mag-aadel na ide ta sinabi na, “Amitin yu a panganin ta lawes ko yo a ponobus dikamo ta mamangan kamo ni oyo a magdeinnawa de paghedep ko.” ");
INSERT INTO due_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pagkapangan de ay inamit na i pig-inoman ni tayug a malanis ta sinabi na, “I oyo a tayug a malanis ay gepamatud de bowon a pagpakikasungdu ni Makedepat a te katibeyen a i sagu ko a nobusbus para dikamo a makmuk.” ");
INSERT INTO due_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sinabi na a tuloy, “Talage ay pesabi ko dikamo a padekop ok ni isin dio a kasaló ko. ");
INSERT INTO due_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ta ako a Pineta nun Makedepat a napa ni agta ay nelibun a nappaayun de kabuotan ni Makedepat misan ay gepakatakut i násapit de agta a gepadekop deko.” ");
INSERT INTO due_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pagkasabi na ninon ay natulutantoan i mag-aadel na ide a ti ino dide i gepadekop de Hisus. ");
INSERT INTO due_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pagkatapos ninon ay natulutaloan i mag-aadel na ide a ti ino dide i namas pa a pinakamaditas dide a pesan. ");
INSERT INTO due_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kanya sinabi dide ni Hisus, “I manga an Hudyo a hari ide ay gesákup ide a mahigpit ni nasasakopan de pati i te kapangyedihan ide ay buot de a pengalanan ide a, ‘Geboy ni Kapiyonan’. ");
INSERT INTO due_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Misan ay wet tebe maginon i nappa ni ugeli yu ta depat a i pinakamaditas dikamo ay magpakasidong a magi anak ta i te kapangyedihan ay depat a nappa ni katabeng ni pesan. ");
INSERT INTO due_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ta i ugeli dio de putok i ay námangan ngona i te kapangyedihan ide dingan la i katabeng ide misan ay am pan maginon i ugeli ko ta ako ay kinumang dio tangani getabeng de manga agta ide. ");
INSERT INTO due_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ikamo ay i geabut deko a tuloy de pesan a pagsubuk deko. ");
INSERT INTO due_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kanya ti papalano a biniyen ok ni Ama ko ni kapangyedihan a gesákup ay maginon pala bebiyen ko ikamo ni kapangyedihan ");
INSERT INTO due_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tangani nakkasaló ko ikamo a námangan a neinom a kakoloy de nasasakopan ko ta nelipa kamo de manga piglipaan a gehuwis de sangpuwu pati aduwa a angkan ni Israel.” ");
INSERT INTO due_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nano ay sinabi ni Hisus de Pedro a magioyo, “Simon, patalikngan mo ta inaged di ni Satanas a nonukso dikamo tangani ikamo ay mapakiblag deko dehil de kahedepan, a magi biges a tinapan. ");
INSERT INTO due_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Misan ay nagpanalangin ok di para dikaw tangani wet neeyen a tuloy i pagpanulusun mo kanya gepo de odes a matibong pan di i pagpanulusun mo ay patibongin mo pala i pagpanulusun ni manga kabinsa mo na ide.” ");
INSERT INTO due_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dingan sinabi diya ni Pedro, “Panginoon, ako ay nappahande a nabbilanggo pati nelibun a kakoloy yu.” ");
INSERT INTO due_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ay tinubeg eya ni Hisus, “Pedro, pesabi ko dikaw a ni abi pala a oyo ay dingan ngona nátaráok i manok ay pengeyen ok mo ni tiluwon a sila.” ");
INSERT INTO due_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ta tinanto ni Hisus i mag-aadel na ide, “Nun dinodul ko ikamo a geatid ni piyon a bereta a an te soput ni pápangan pati an te panlewes ni paragetus ay kinolang kamo man?” Ta ide ay tinumubeg, “Angani.” ");
INSERT INTO due_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Dingan sinabi na dide, “Misan nano ay depat kamo a nángadde ni kuwarta yu pati soput ni pápangan be ikamo ay geatid ni piyon a bereta. Ta i an te utak ay depat a panggetangin na i kulapyaw na tangani nakáamit eya ni isin a utak. ");
INSERT INTO due_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ta pesabi ko dikamo a nangyeyedi di i naddekasulatan a tungkul deko a, ‘Dodugeng i Pineta nun Makedepat de agta a makikkakasalanan.’” ");
INSERT INTO due_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kanya sinabi diya ni mag-aadel na ide, “Panginoon, wiyo i aduwa a utak a aadde mi.” Dingan tinubeg na ide, “Ay iwina ay sukul.” ");
INSERT INTO due_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pagkatapos ninon ay tinumotul eya a paagow de Kalasan a Olibo a gepanalangin a magi ugeli na ta sinumut diya i mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagdetong de duman ay sinabi na dide, “Magpanalangin kamo tangani wet kamo notukso.” ");
INSERT INTO due_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ta pagkalayu na dide ni untik ay linumuhud a nanalangin. ");
INSERT INTO due_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Sinabi na de pagpanalangin na, “Ama ko, be nappatud dikamo ay layuin yu tebe deko i tetiis ko a oyo misan ay wet nangyeyedi i kabuotan ko ta i kabuotan yu la.” ");
INSERT INTO due_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kanya te duman ngani a nagpakita diya a anghel a gepo de langot a nagpatibong de innawa na. ");
INSERT INTO due_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Nano nun eya ay nagkolungkut a masakut a magi nelibun ay nanalangin eya ni namas pa a matibong ta i aldut na pan a hangain a magi sagu ay binumusbus de putok. ");
INSERT INTO due_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pagkapanalangin na ay inumuddi ta kinangan na i mag-aadel na ide misan ay dinatongan na ide a kapulupede dehil de lungkut de a masakut. ");
INSERT INTO due_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dingan sinabi na dide, “Bekot ta napede kamo la ta gumiyos kamo di a magpanalangin tangani wet kamo notukso.” ");
INSERT INTO due_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nun gesurut pa i Hisus ay dinumatong di i kaagtaan pati Hodes a naona dide a isin de sangpuwu pati aduwa. Ta eya ay linumane de Hisus tangani angutan na. ");
INSERT INTO due_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Misan ay sinabi diya ni Hisus, “Hodes, pepadekop ok mo man a Pineta nun Makedepat a napa ni agta de isin la a angut?” ");
INSERT INTO due_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nano ay nun kinta ni mag-aadel na ide a ti ano i nangyeyedi ay sinabi de, “Panginoon, be buot yu ay nenigbes kami ni manga agta ide i.” ");
INSERT INTO due_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ta tinigbes ngani ni isin dide i isin a katabeng ni pinakaponu a maghahandug ta nasapsap ngani i awenan na a talinga. ");
INSERT INTO due_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Misan ay sinabi ni Hisus dide, “Pabiyaan yu ide.” Dingan tinapá na i talinga na a pinapiyon. ");
INSERT INTO due_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ta sinabi na de ponu ide ni maghahandug ide, de ponu ide ni magbebentay ide pati de pinakamatande ide a Hudyo a kinumang duman a nánakop diya, “Anok tulisan. Bekot ta nagidinio kamo a te manga utak pati panopras? ");
INSERT INTO due_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ta adow adow ay nagtodu ok de beloy a pighandogen de Makedepat a anok yu pan dinakop. Misan hale di ta panahon yu nano pati te kapangyedihan ni Satanas i madumos a esip ni agta ide.” ");
INSERT INTO due_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ay binolan de ngani i Hisus ta inikag de de beloy ni pinakaponu a maghahandug. Ta inumabut pala i Pedro misan ay alayu la i pag-etan. ");
INSERT INTO due_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nano nun makapaggetong di un manga agta nunde gitna nun bekoran ay nagilinepa ide tangani manangdeng ide ta dingan linumipa pala i Pedro de alane de. ");
INSERT INTO due_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nano ay kinta pan eya ni isin a maddikit de tallang nun apoy ta nun pinagelawag na i Pedro ay sinabi na, “I lalaki pan a oyo ay kasta kakoloy pala ni wina a agta.” ");
INSERT INTO due_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Misan ay nangeyen i Pedro ta sinabi na diya, “Maddikit, ang ko eya peabuyenan.” ");
INSERT INTO due_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nun mulumáloy di ay sinabi diya ni isin pa a gekita diya, “Kasta isin ka pala de kakoloy de.” Misan ay tinubeg ide ni Pedro, “Eyen ayun.” ");
INSERT INTO due_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nano ay nun makasila di i manga isin a odes ay sinabi diya a mapelit ni isin pa a agta duman, “Talage ngani a i oyo a lalaki ay kakoloy na ta tage Galilea pala.” ");
INSERT INTO due_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Misan tinubeg ni Pedro, “Ayun, ang ko katinggesan i pesabi yu deko.” Nun gesurut pa i Pedro ay tambing dila a tinumaráok i manok. ");
INSERT INTO due_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ta linumingoy i Panginoon ta pinakalawag na i Pedro kanya pan naisepan na i hinola diya ni Panginoon a, “De abi a oyo dingan ngona nátaráok i manok ay pengeyen ok mo ni pakatiluwon a sila.” ");
INSERT INTO due_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dingan binumulwag i Pedro a nagtangos a masakut a nagkolungkut. ");
INSERT INTO due_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ta i Hisus pan ay linebek ni manga gebentay ide diya a sinulusuntuk. ");
INSERT INTO due_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pati tinaklopan de i mata na a tinanto de eya, “Hale di, holaan mo ti ino i gesuntuk dikaw.” ");
INSERT INTO due_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pati nagsabi pa ide diya ni sadisadi a paglibek diya. ");
INSERT INTO due_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nano ay nun kinábiabian di ay nagpolong i pinakamatande ide ni Hudyo, i ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo. Ta pinasagkad de i Hisus de gitna ni kapolongan de, ");
INSERT INTO due_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","a tinanto de eya, “Sabiin mo dikami i kamatoden ti ikaw ngani i Kristo a Pinangako nun Makedepat?” Misan ay tinubeg na dide, “Be sasabi ko dikamo ay anok yu pan pepanulusonan ");
INSERT INTO due_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ta be tatanto ko ikamo ay ang kamo pan getubeg. ");
INSERT INTO due_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Misan ay pesabi ko ngan dikamo a gepo de panahon a oyo ay nelipa ok a Pineta nun Makedepat a napa ni agta de awenan na a Makapangyedihan de pesan.” ");
INSERT INTO due_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dingan tinanto de a pesan, “Ikaw man i Anak nun Makedepat?” Misan ay tinubeg na ide, “Ikamo pala i gesabi.” ");
INSERT INTO due_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kanya sinabi de, “An tam di kaelangan i pagsumbong ni kakmukan ta ikitam di a pesan i inumikna a eya ay an te gelang de Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ay dingan inumuddi ide a pesan a kapologan ta inikag de i Hisus de Gubernador a Pilato. ");
INSERT INTO due_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ta ginumapo ide a gesumbong ni an matud a tungkul de Hisus ta sinabi de a, “I oyo a agta a nakitán mi a getodu de kaagtaan ni paglagelag ta pesabi na pa a an depat a gebeyed ni buwis de Hari a Kaditasan de Roma. Pati pesabi na a eya kon i Hari a Kristo a Pinangako nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nano ay tinanto eya ni Pilato, “Ikaw man i Hari ni Hudyo ide?” Dingan tinumubeg i Hisus, “Ikamo di i gesabi.” ");
INSERT INTO due_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ay dingan sinabi ni Pilato de ponu ide ni maghahandug ide pati de kaagtaan, “Anok te depat a panhahatolan de agta a oyo.” ");
INSERT INTO due_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Misan ay namas pa a mapelit i te kapangyedihan ide a nagsurut diya a magioyo, “Talage ay pelagelag na a masakut i manga agta de pagtodu na de kulukaginglan ni Hudia ta eya ay ginumapo de Galilea ta nano ay wiyo di de Herusalem i.” ");
INSERT INTO due_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kanya nun inikna inon ni Pilato ay tinanto na ide, “Tage Galilea mangan yo a agta?” ");
INSERT INTO due_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nano ay nun kinatinggesan na a i Hisus ay tage duman de sákup ni Herod ay pinaikag na i Hisus diya. Ta i Herod pan nun adow ide a inon ay nagbiseta de Herusalem. ");
INSERT INTO due_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Talage a pagkakita ni Herod de Hisus ay nasalig eya a masakut ta naloy na di a buot a kekita i Hisus. Ta nagkabbereta na i gepakataka ide a yinadi ni Hisus ta inon ide i buot na a kitain. ");
INSERT INTO due_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kanya pan tinanto na i Hisus ni makmuk a sila misan ay an di la getubeg i Hisus ni misan ano. ");
INSERT INTO due_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Misan ay duman pala i manga ponu ide ni maghahandug ide pati magtutodu ide ni Hudyo a an dila getimok de pagsumbong de a masakut a tungkul de Hisus. ");
INSERT INTO due_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ta i Herod pati manga sundelo na ide ay naglibek pala diya ta yinadian de eya ni an te gelang. Ta binaduan de pa ni masampat a magi bedu ni hari dingan pagkatapos ay pinaampulang na de Pilato. ");
INSERT INTO due_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ta nun adow pala a inon ay napa ni mag-ayun i Herod pati Pilato a nun sakadow ay magkapagebuk ide. ");
INSERT INTO due_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nano ay pinatipun ni Pilato i ponu ide ni maghahandug ide, i te kapangyedihan ide pati kaagtaan. ");
INSERT INTO due_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ta sinabi na dide, “Nun inikag yu deko i oyo a agta ay sinumbong yu eya a getodu ni paglagelag de agta ide misan ay nun tantoin ko eya de kasagkaden yu ay anok pan te kinta a kamatoden de sumbong yu diya. ");
INSERT INTO due_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Maginon pala i Herod ta eya ay pinaampulang na a liwet deko. Ta talage pan a an te kasalanan a depat a panhahatolan diya ni kalebunan. ");
INSERT INTO due_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kanya pan palapdit ko eya dingan pobulwag.” Inon i sinabi ni Pilato, ");
INSERT INTO due_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ta te ugeli eya a de belang kaadowen ni Paskuwa ay gepabulwag ni isin a nabbilanggo. ");
INSERT INTO due_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Misan ay sabey sabey a nagiinolang i kaagtaan a, “Depat a bunoin i agta a iwina ta i Barabás pan i pabulwagen yu.” ");
INSERT INTO due_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nano i Barabás pan a oyo ay nabbilanggo dehil de eya ay migbuno pati migpakilaben de gubyerno de Herusalem. ");
INSERT INTO due_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ta liwet a nagsurut dide i Pilato dehil de buot na a pabulwagen i Hisus. ");
INSERT INTO due_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Misan ay nagiinolang ide a magioyo, “Pakuin eya de padipa. Pakuin yu de padipa.” ");
INSERT INTO due_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ta tinanto pala ide ni Pilato ni tiluwon a sila, “Bekot, ta ano man i yinadi na a kasalanan? Ta anok pan te pekita a dehilan a panhahatolan diya ni kalebunan. Kanya yadi pa ay palapdit ko eya ta dingan pobulwag.” ");
INSERT INTO due_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Misan ay namas pa ide a nagiinolang a geaged a mapelit a pakuin i Hisus de padipa. Ta de inapóan ngani ay nanalo di i kabuotan ni kaagtaan ide. ");
INSERT INTO due_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kanya pinanulusonan ni Pilato a hatolan i Hisus ni nappaayun de kabuotan de. ");
INSERT INTO due_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta pinabulwag na ngani i nabbilanggo a migbuno pati migpakilaben de gubyerno de Herusalem a inaged de. Ta i Hisus pan ay binoy na dide tangani yediin de i nappaayun de kabuotan de. ");
INSERT INTO due_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nano ay nun inikag de i Hisus a pakuin de de padipa ay natagbu de i Simon a tage Sirene a inumapo de buluberiyu. Ta eya ay binolan de tangani papassanin de diya a mapelit un padipa ni Hisus a napaabut diya. ");
INSERT INTO due_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ay napaabut pala de Hisus i kaagtaan a makmuk pati mahunain a gepinagtangos a masakut para diya. ");
INSERT INTO due_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Misan ay liningoy ide ni Hisus ta sinabi na dide, “Ikamo a mahunain a tage Herusalem ay wet ok yu pagtangosan ta depat a i pagtangosan yu ay i sadile yu pati mangának yu ide. ");
INSERT INTO due_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ta talage a nádetong i panahon a sasabi ni kaagtaan ide a tage dio de Herusalem a, ‘Piyon i kapuoyen ni mahunain a an gekaanak, a an nanganak kapide man pati an nagpasusu.’ ");
INSERT INTO due_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ta de panahon a inon ay sasabi ni kaagtaan de kalasan ide a, ‘Maropnay kamo dikami.’ Ta sasabi de pala de manga pagotan, ‘Tumapor kamo dikami.’ ");
INSERT INTO due_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ta be ako a agta a an te kasalanan ay getiis ni mahedep a masakut ay ano ngani i násapit de kaagtaan a te kasalanan a masakut.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta inikag pala ni sundelo ide i aduwa a matud a te kasalanan tangani pakuin de de padipa a kasabey ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagdetong de de lugel a te ugalan a “Kaksan ni Ulo” ay pinaku de i Hisus de padipa pati aduwa a matud a te kasalanan, isin de awenan na pati isin pala de awile na. ");
INSERT INTO due_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dingan sinabi ni Hisus, “Ama, pakeeyenan yu i kaagtaan ni kasalanan a oyo ta an de katinggesan i peyedi de.” Ta i sundelo ide ay nagsugel a binulubinsa de un demit na. ");
INSERT INTO due_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Nano ay i kauluuddi a kaagtaan ay gepakalawag diya misan ay pelibek pan eya ni te kapangyedihan ide a Hudyo ta sinabi de, “Te kaya eya a nanligtas ni kakmukan kanya nano pan ay ligtasin na i sadile na be eya ngani i Kristo a Pinangako nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Pati linibek eya ni manga sundelo a peawa de pa ni tayug a maapsut. ");
INSERT INTO due_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ta pesabi de diya, “Be ikaw ngani i Hari a matud ni Hudyo ide ay ligtasin mo i sadile mo nano.” ");
INSERT INTO due_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta nassolat de ditas ni ulo ni Hisus de surut a Griego, Roma pati Hebreo, “I oyo ay Hari ni Hudyo ide.” ");
INSERT INTO due_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pati isin a pinaku a kasabey na ay nagsurut pala ni libek diya ta sinabi na, “Aman la ikaw i Kristo a Pinangako nun Makedepat? Ligtasin mo ikami pati sadile mo.” ");
INSERT INTO due_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Misan ay sinosol eya ni kapadepade na a te kasalanan ta sinabi na, “Ang ka man la nagkatakut de Makedepat? Ta ikitam a tiluwon ay pepadusahan ");
INSERT INTO due_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","misan ay ikita pan ay pepadusahan a nappaayun de kamatoden ta petanggep ta i nagkaddepat a bilos ni yinadi ta a mammalotin. I agta pan a oyo ay an te yinadi a misan ano a malot.” ");
INSERT INTO due_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dingan sinabi na de Hisus, “Hisus, esipin ok yu pan be ikamo ay nádetong di a liwet de putok i a te kapangyedihan de pesan.” ");
INSERT INTO due_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tinubeg ni Hisus, “Talage a matud ay pesabi ko dikaw a nano pala de adow a oyo ay kakaloy ok mo de pigtaanan nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nano ay nun manga udto di ay dinumumos i putok hanggen de apun a kadepit. ");
INSERT INTO due_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ta i adow pan ay an di te tallang dingan nagisi un age a mokpal a sagbong a nasampay de beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dingan inumolang i Hisus ni malagdu ta sinabi na, “Ama, peboy ko di dikamo i kaleduwa ko.” Ta pagkasabi na ninon ay napugtusan di. ");
INSERT INTO due_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nano ay nun kinta yo a nangyedi ni kapitan ni sundelo ide ay nagpodi eya de Makedepat ta sinabi na, “Talage ngani i agta a oyo ay an te kasalanan.” ");
INSERT INTO due_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","I manga agta pan ide a gepakalawag diya ay nun kinta de i nangyedi a inon ay inumuli ide a petugtug de i alalang de dehil de hanga a lungkut de. ");
INSERT INTO due_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Misan ay i mangáyun pan ide ni Hisus pati mahunain a inumabut diya gepo de Galilea ay napasayed pala nunde alayu ta kinta de pala i pesan a nangyedi. ");
INSERT INTO due_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Te duman a isin a lalaki a te ngalan a Hose a tage Arimatea de sákup ni Hudia. Eya ay piyon a agta a te gelang de Makedepat. Pati isin eya a te tungkolin de kapolongan a pinakamatande a Hudyo. ");
INSERT INTO due_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ta an na buot i belak pati yinadi de de Hisus ta geilat pala eya ni panahon a te kapangyedihan i Makedepat de innawa ni agta. ");
INSERT INTO due_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ta eya ay kinumang de Pilato a inaged na i bengkay ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Dingan nun malusong na di un bengkay ay tiningos na de age a matebe ta inadde na de gob nun denpa a táporan. I oyo a táporan ay bowon a am pa te nakattapor. ");
INSERT INTO due_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nun tinapor de eya ay apun di ni Adow a Paghande ni Paskuwa ta mandeli di ay te gepo i adow ni paimloy. ");
INSERT INTO due_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ta i mahunain pan ide a inumabut de Hisus gepo pa de Galilea ay sinumut pala ide de Hose ta kinta de i táporan a pinamuoyen de Hisus. ");
INSERT INTO due_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ay dingan inumuli ide a gepinaghande ni agid pati langis a mabengo ta inon ay popunas de de bengkay ni Hisus. Nano ay nun adow di ni paimloy ay nagpaimloy ide a nappaayun de pagdodul ide. ");
INSERT INTO due_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nano ay nun Simbe a abiabi a masakut ay dinumuman un mahunain ide de táporan a te manga adde ide ni mabengoin a hinande de. ");
INSERT INTO due_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Misan ay pagdetong de duman ay kinta de a nabulidbulid di un beto a abet ni táporan. ");
INSERT INTO due_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ta pagsilong de nunde gob ay an de kinta i bengkay ni Panginoon a Hisus. ");
INSERT INTO due_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kanya ide ay napauddi la duman a nagkelito i esip de ta dingan loktat a te inumuddi de alane de a aduwa a manga lalaki a te manga bedu ni gepakaingap a masakut. ");
INSERT INTO due_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nano ay dehil de hanga a takut de ay dinumuko ide ta tinanto ide ni manga lalaki, “Ano ta pelawag yu i naedup di a liwet de nalibunin ide?” ");
INSERT INTO due_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Sinabi de pa, “An di eya kadio ta pinakaedup di a liwet. Ta esipin yu i sinabi na dikamo nun eya ay duman pa de Galilea ");
INSERT INTO due_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","a, ‘Depat a Ako a Pineta nun Makedepat a napa ni agta ay boyin de kapangyedihan ni manga agta a makikkakasalanan, a papaku de a tuloy de padipa misan ay de katiluwon a adow ay pakeedup ok la a liwet.’” ");
INSERT INTO due_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ay dingan inesip ngani nun mahunain i sinabi a inon dide ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pag-ampulang ni mahunain a oyo gepo de táporan ay binareta de de sangpuwu pati isin pati de pesan a kakoloy de. ");
INSERT INTO due_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","I mahunain ide a nagbereta de mag-aatid ide ay i Maria Magdalena, Huwana, Maria a ina ni Santiago pati kakmukan pa a mahunain a kakoloy de. ");
INSERT INTO due_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nano ay inesip de a inon a bereta ay an la matud kanya an la ide nanulusun. ");
INSERT INTO due_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Misan ay inumuddi i Pedro a ginumikan a paagow de táporan ta pagduko na a gepakalawag de disalad, i kinta na la ay un age a pinaningosan a napuoy di de isin a kaginglan kanya eya ay inumuli a getaka a masakut de nangyedi a inon. ");
INSERT INTO due_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nun adow pala a inon ay kinumang i aduwa a mag-aadel de beriyu a Emaus a i kalayu na de Herusalem ay manga sangpuwu pati isin a kilometro. ");
INSERT INTO due_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ta de pagtotul de ay passurutsurotan de i pesan a nangyedi. ");
INSERT INTO due_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ay nun ide ay nassurutsurotan pa ay linumane dide i Hisus ta nakisabey dide. ");
INSERT INTO due_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kinta de ngani eya misan ay an de la inabuyenan. ");
INSERT INTO due_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nano ay tinanto ide ni Hisus, “Ano man i passurutsurotan yu a iwina de pagtotul yu?” Ay ide ay tinumimok a te lungkut de mukha de. ");
INSERT INTO due_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Dingan tinubeg de Hisus ni te ngalan a Kleopas, “Makati ikamo la i gebiseta dio a an te katinggesan ni tungkul de nangyedi nun isin la a adow de Herusalem.” ");
INSERT INTO due_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Misan ay nagtanto i Hisus, “Ano man non a nangyedi?” Dingan tinubeg de eya, “Ay i malot a nangyedi de Hisus a tage Nasarit, a isin a magsasabi a makapangyedihan de pagyedi man pati de surut. Ta talage ay an te kapadepade de pekita ni Makedepat pati de manga agta. ");
INSERT INTO due_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Misan ay i ponu ide ni maghahandug ide pati te kapangyedihan ide a Hudyo ay binoy de eya a hinatolan ni kalibunan a pinaku de padipa. ");
INSERT INTO due_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kanugun ta ikami ay geasa pam pa diya a eya i nantotubus dikami a manga tage Israel. Misan ay an di nappatud nano ta eya ay nalibun di nun katiluwon pa a adow. ");
INSERT INTO due_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Isin pa ay naloktat kami de binareta dikami nun mahunain a kakoloy mi. Ta kinumang ide a maderam de táporan ");
INSERT INTO due_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","misan ay an de kinta duman i bengkay ni Hisus kanya inumampulang ide dikami. Ta sinabi de a pinagpakitaan kon ni manga anghel a sinabi de a naedup di a liwet i Hisus. ");
INSERT INTO due_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kanya pan kinumang pala de táporan i kakmukan a mangáyun mi ta kinta de pala i magi sinabi ni mahunain ide misan ay an de kinta duman i bengkay ni Hisus.” Inon i sinabi ni Kleopas. ");
INSERT INTO due_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dingan sinabi ni Hisus dide, “Ikamo mangani ay manga agta a an te katinggesan ta mahena i pagpanulusun yu de pesan a surut nun magsasabi ide a den. ");
INSERT INTO due_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ta sinabi de a i Kristo ay depat ngona a magtiis ni maginon a kahedepan dingan pa eya ay gekaduman ni kapangyedihan de pesan.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dingan nagpatingges eya de aduwa ni pesan a sinolat a tungkul diya de kasulatan a den gepo de kasulatan ni Moises hanggen dila de kasulatan ni pesan a magsasabi ide a den. ");
INSERT INTO due_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nano ay nun ide ay alane di nunde beriyu a kakangan de ay notuloy la tebe i Hisus de pagtotul na. ");
INSERT INTO due_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Misan ay sinabi de diya, “Ay wet kamo di tumotul ta dio kamod pumilong ta nelinod di i adow a mulumadumos di.” Kanya eya ay nakituloy di dide. ");
INSERT INTO due_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nano ay nun ide ay napasagkad di de pamangan ay nangamit i Hisus ni tinapay a nagpasalamat de Makedepat dingan pinisangpisang na a tuloy ta binuluboy na dide. ");
INSERT INTO due_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ay dingan de la inabuyenan eya misan ay loktat eya ay naeyen. ");
INSERT INTO due_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ta sinabi de, “Kanya mangani gehanga i innawa tam kangwoni nun eya ay nagpatingges tungkul de kasulatan ide ni Makedepat nun getotul kitam pa.” ");
INSERT INTO due_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kanya nun odes pala a inon ay inumampulang un aduwa de Herusalem ta dinatongan de duman i sangpuwu pati isin pati kakmukan pa a gepolong. ");
INSERT INTO due_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ta sinabi ni dinatongan ide a, “Pinakaedup dingani i Hisus ta eya ay nagpakita di de Pedro.” ");
INSERT INTO due_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ta nagpatingges pala i aduwa ni tungkul de nangyedi de bektas pati ti papalano a inabuyenan de eya nun pinisangpisang na un tinapay. ");
INSERT INTO due_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nano ay nun ide ay nassurutsurotan pa ay loktat pan a inumuddi i Hisus de gitna de ta sinabi na. “Mapadikamo i kasampatan a innawa.” ");
INSERT INTO due_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Misan ay nákided a te takut i mag-aadel ide ta magi ide ay binuswal. ");
INSERT INTO due_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kanya sinabi dide ni Hisus, “Bekot ta nagkogulo i esip yu a geuluaduwa a tungkul deko? ");
INSERT INTO due_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pagelawagin yu i biged ide de kumot pati singit ko ta akod yo a an buswal. Bolan ok yu pati pagelawagin ta i buswal ay an te kaksan pati unid a magi ako a pekita yu.” ");
INSERT INTO due_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pagkasabi na ninon ay pinakita na i kumot pati singit na. ");
INSERT INTO due_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ta nagkasalig ide a getaka a masakut misan ay an ide kasta gepanulusun ta magi gepangnenop la ide. Kanya dehil de aduwa i esip de ay nagtanto i Hisus dide, “Te duman kamo man a pápangan?” ");
INSERT INTO due_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ay biniyen de eya ni sinube a kapusing a ikan. ");
INSERT INTO due_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ta inamit na inon a namangan de pekita de kanya kinatinggesan de a an eya buswal. ");
INSERT INTO due_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dingan sinabi na, “I oyo i buot ko a sasabi nun kakoloy ok yu pa a depat a mangyedi i sinolat a tungkul deko de kasulatan ni Moises pati magsasabi ide a den pati de manga kanta.” ");
INSERT INTO due_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ta dingan kinayesan na i esip de tangani matinggesan de i kasulatan ide nun Makedepat. ");
INSERT INTO due_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Dingan sinabi na dide, “Te duman de kasulatan a ako a Kristo a Pinangako nun Makedepat ay depat a magtiis ni kahedepan, a nelibun a tuloy misan ay pakeedup ok la a liwet de katiluwon a adow. ");
INSERT INTO due_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ta dingan te duman pala a manga gesabi de pesan a bensa gepo de Herusalem i, tungkul de makapangyedihan a ngalan ko tangani gesosol i pesan, a pakeeyenan pala ide ni mammalotin de. ");
INSERT INTO due_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ikamo ngani i gepamatud de oyo a piyon a bereta. ");
INSERT INTO due_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Patalikngan yu ta pakang ko dikamo i Ispiritu a pinangako ni Ama a Makedepat kanya mag-ilat kamo de Herusalem i hanggen an nolusong dikamo i kapangyedihan a náapo de langot.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nano ay inikag na ide a pabulwag de Herusalem hanggen de tipong ni beriyu a Betania ta pagdetong de duman ay tinaye na i kumot na ta pinakalbian na ide. ");
INSERT INTO due_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta nun pepakalbian na pa ide ay winalat na pan ide a pinaditas di eya de langot. ");
INSERT INTO due_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nano ay pag-ampulang de de Herusalem ay nagpodi ide de Makedepat a te hanga a kasalegen. ");
INSERT INTO due_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ta ugnay ide nunde beloy a pighandogen de Makedepat a gepodi pati gepasalamat a tuloy.");
INSERT INTO due_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nun am pa te putok ay duman di eya a te ngalan a Surut ta eya a Surut ay ayun ni Makedepat ta i Surut ay Makedepat. ");
INSERT INTO due_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nun gepo pa ngani ay ayun di nun Makedepat i Surut. ");
INSERT INTO due_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ta pinayedi diya a Surut nun Makedepat i pesan i, ta an te yinadi be an dehil diya a Surut. ");
INSERT INTO due_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Talage i te ngalan a Surut i peapoan ni edup a kapadepade ni Makedepat kanya eya a geboy ni edup ay magi salong a gepatallang de esip ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ta tinumallang de madumos a esip ni kaagtaan iwina a salong ta an yo nadeog ni dumos. ");
INSERT INTO due_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nano pan ay pinakang ni Makedepat i isin a agta a te ngalan a Huwen a Maglilenod. ");
INSERT INTO due_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dinumatong eya a nagpamatud tungkul de salong tangani dehil de pagpamatud na ay gepanulusun de salong i pesan. ");
INSERT INTO due_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","An i Huwen i salong ta eya ay pinakang la a gepamatud tungkul de salong. ");
INSERT INTO due_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ta i matud a salong a gepatallang de esip ni kaagtaan ay gedetong de putok i. ");
INSERT INTO due_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Talage ay pinayedi diya a Surut nun Makedepat i putok i pati eya ay dinumio gepo de langot misan pan ay an eya inabuyenan ni agta ide dio de putok i. ");
INSERT INTO due_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pati nun eya ay dinumio de bensa na a sadili a Hudia ay an eya tinanggep ni kapadepade na a Hudyo. ");
INSERT INTO due_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Misan i pesan a tinumanggep diya, a nanulusun pala de makapangyedihan a ngalan na ay yinadi na ide a mangának nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ta yinadi na ide a mangának na gepo la de kapangyedihan na a an gepo de esip, buot pati de pagyedi ni agta. ");
INSERT INTO due_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ay eya a te ngalan a Surut ay napa ni agta a nakipagtaan dikitam ta eya ay te kamatoden pati kalbi a masakut de agta. Ta kinta mi i gepakaingap na a i gepakaingap a talage ni kádu a Anak nun Makedepat a Ama. ");
INSERT INTO due_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nagpamatud i Huwen a tungkul diya a te ngalan a Surut nun Makedepat. Sinabi ni Huwen a magioyo, “Nun sakadow ay sinabi ko a te duman a agta a nappaabut deko misan ay eya ay te kapangyedihan pa deko. Ta nun anok pa pinanganak ay eya ay te edup di hanggen nun kapide pa man. I oyo i agta a pinamatoden ko.” Inon i pagpamatud ni Huwen. ");
INSERT INTO due_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nano ay gepo de pagbuot a masakut ni Surut ay petanggep tam a pesan i kapiyonan na a tuloy tuloy. ");
INSERT INTO due_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ta i pagdodul ide ay binoy ni Makedepat de padean ni Moises misan ay de padean ni Hisu Kristo ay gekaduman kitam di ni kosa a tabeng ni Makedepat, a kakoloy ni surut na a kamatoden. ");
INSERT INTO due_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ta kapide man ay an te nakakita de Makedepat misan ay pinaabuya eya ni kádu a Anak na a eya a gepakikaisin de Ama. ");
INSERT INTO due_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nano ay i Hudyo ide de Herusalem a te manga kapangyedihan ay dinodul de i tipide a maghahandug pati tipide a angkan ni Lebi a katabeng ni maghahandug ide tangani tantoin de i Huwen a Maglilenod a ti ino eya. Kanya magioyo i pagpamatud na ");
INSERT INTO due_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ta pinatingges na dide a matud a an eya i Kristo a Pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dingan tinanto de eya, “Be maginon ay ino kamo? Ikamo man i Elias?” Ay tinubeg ni Huwen, “Ay eyen.” Tinanto de a liwet, “Ikamo man i magsasabi a náapo de Makedepat a peilat mi?” Tinumubeg eya, “Eyen.” ");
INSERT INTO due_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pagkatubeg na ay sinabi de a liwet, “Ino kamo man? Sabiin yu dikami tangani te masabi kami de nagdodul dikami. Ano i sasabi yu a tungkul de sadile yu?” ");
INSERT INTO due_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tinumubeg i Huwen, “Ako i geolang de lugel a ilang. ‘Tanusin yu i sesilan ni Panginoon.’ Ta inon i paghola ni Isais a magsasabi a den.” Inon i tinubeg ni Huwen dide. ");
INSERT INTO due_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nano ay inon ide a nagtanto ay dinodul ide ni manga Pariseo ide ");
INSERT INTO due_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kanya liwet de a tinanto i Huwen, “Bekot ta pelinodlinod yu i agta be amangan ikamo i Kristo, i Elias o i magsasabi a peilat mi?” ");
INSERT INTO due_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tinubeg na ide, “Pelinod ko di ikamo de orat misan ay naddegitna yu i isin a an yu peabuyenan. ");
INSERT INTO due_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ta eya i nádetong a nappaabut deko misan ay namas pa a te kapangyedihan deko ta anok te sukul a kapangyedihan a nong-ukas ni gipot la ni paragetus na.” Inon i tinubeg ni Huwen. ");
INSERT INTO due_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nano ay i oyo ay nangyedi de beriyu a Betania a dipa ni Orat a Horden ta duman lininodlinod ni Huwen i manga agta. ");
INSERT INTO due_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nun kinábiabian ay kinta ni Huwen i Hisus a gelane diya ta sinabi ni Huwen, “Wiyo i magi topa a hahandug a inumapo de Makedepat, a nomut ni mammalotin ni kaagtaan dio de putok i. ");
INSERT INTO due_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Eya ngani un pesabi ko nun sabiin ko a te nádetong a nappaabut deko, a namas pa a te kapangyedihan deko ta nun anok pa pinanganak ay eya ay te edup di hanggen nun kapide pa man. ");
INSERT INTO due_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ta ang ko pala inabuyenan eya nun nanon misan ako ay dinumio a gelinod ni kaagtaan de orat tangani paabuya ko eya de manga tage Israel.” ");
INSERT INTO due_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ta dingan nagpamatud i Huwen a tuloy a magioyo, “Kinta ko i Ispiritu a linumusong diya gepo de langot a magi isin a kalapati a tinumaan diya. ");
INSERT INTO due_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ang ko eya inabuyenan a masakut nun nanon misan ay i nagdodul deko tangani maglinod ok de orat i nagsabi deko, ‘I kekita mo a agta a lolusongan ni Ispiritu, a nátaan pala diya ay eya ngani i gelinod ni agta de Ispiritu ko.’ ");
INSERT INTO due_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kinta ko ngani i maginon ta pepamatoden ko di a eya ay Anak nun Makedepat.” Inon i sinabi ni Huwen. ");
INSERT INTO due_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nun kinábiabian ay duman a liwet i Huwen pati aduwa na a mag-aadel. ");
INSERT INTO due_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nun kinta na i Hisus a gesila ay sinabi na, “Wiyo i magi topa a hahandug a inumapo de Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Inikna ni aduwa a mag-aadel na i sinabi na kanya inumabut ide de Hisus. ");
INSERT INTO due_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Dingan linumingoy i Hisus a kinta na i geabut ide ta tinanto na ide, “Ano i pelawag yu?” Ta dingan nananto pala ide diya, “Magtutodu, buot mi a nosut dikamo de pigtaanan yu tangani matinggesan mi i pagtodu yu.” ");
INSERT INTO due_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tinumubeg i Hisus, “Sumut kamo ta pagelawagin yu.” Ta dingan sinumut ide diya ta pagdetong de de kataanan na ay nakitaán ide diya de inon a adow ta kaapat di a odes ni apun. ");
INSERT INTO due_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nano ay de aduwa a inumikna de Huwen a sinumut pala de Hisus ay isin i Andres a wele ni Simon Pedro. ");
INSERT INTO due_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Dingan nun kinábiabian ay linawag ni Andres i kaka na a i Simon Pedro ta sinabi na diya a, “Kinta mi di i Pinangako nun Makedepat a te ngalan a Kristo.” ");
INSERT INTO due_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Eya ay inikag ni Andres de Hisus. Nun pinagelawag ni Hisus i Simon ay sinabi na diya, “Ikaw i Simon a anak ni Huwen misan nano ay pengalanan ko ikaw a Sepas.” (Inon de Griego a surut ay Pedro a te kabuluhan a “beto”.) ");
INSERT INTO due_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nun kinábiabian pala ay binuot ni Hisus a nákang de Galilea. Pagdetong na ay kinta na i Pilepi ta sinabi na diya, “Sumut ka deko.” ");
INSERT INTO due_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nano i Pilepi ay tage Betsaida a magi Andres pati Pedro. ");
INSERT INTO due_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Linawag ni Pilepi i Natanael ta sinabi na diya, “Kinta mi di i Hisus a tage Nasarit a anak ni Hose, a eya a sinólat ni Moises de libro ni pagdodul ide nun Makedepat. Maginon pala i sinólat ni magsasabi ide a den.” ");
INSERT INTO due_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tinubeg ni Natanael de Pilepi, “Ay kasta an nappatud a te nágepo de Nasarit a piyon.” Misan sinabi ni Pilepi diya, “Sumut ka ta pagelawagin mo.” ");
INSERT INTO due_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nun kinta ni Hisus i Natanael a gelane diya ay sinabi ni Hisus de mangáyun na a tungkul de Natanael, “Pagelawagin yu ta dio i Hudyo a te piyon a innawa a an gedeya a unabis.” ");
INSERT INTO due_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tinanto eya ni Natanael, “Papalano ok yu a inabuyenan?” Tinumubeg i Hisus, “Dingan ka pa linawag ni Pilepi ay kinta ko di ikaw nun ikaw ay de saruk pa ni kew a igos.” ");
INSERT INTO due_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ay dingan sinabi ni Natanael, “Magtutodu, ikamo ngani i Anak nun Makedepat. Ikamo i Hari ni bensa a Israel.” ");
INSERT INTO due_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tinubeg diya ni Hisus, “Nanulusun ka man dehil de sinabi ko dikaw a kinta ko di ikaw nun ikaw ay de saruk pa ni kew a igos? Ay talage ay nekita ka ni namas pa a te kapangyedihan de inon.” ");
INSERT INTO due_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ta sinabi ni Hisus a tuloy diya, “Talage a matud ay pesabi ko dikaw a kekita mo a nakayesan i langot ta i manga anghel ide nun Makedepat ay násalakat pati nesidong de tipong ko a Pineta nun Makedepat a napa ni agta.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nano ay pagkatakig ni aduwa a adow ay te kásalan de beriyu a Kana de sákup ni Galilea ta duman i ina ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","I Hisus pati mag-aadel na ide ay inakit pala de kásalan. ");
INSERT INTO due_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nun naubus di i tayug a malanis ay sinabi ni ina ni Hisus diya, “Naubusan ide ni tayug a malanis.” ");
INSERT INTO due_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tinubeg ni Hisus, “Ina ko, be nappatud ay wet ok yu toduan a ti ano i yeyedi ko ta am pa dinumatong i odes a pepakita ko i kapangyedihan ko de kamakmokan.” ");
INSERT INTO due_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Sinabi ni ina na de manga katabeng, “Yediin yu i misan ano a payedi na.” ");
INSERT INTO due_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nano ay dehil de ugeli a pag-uges ni Hudyo ide de lawes de ay te duman a anim a tapayen a i unid ni isin ay aduwa a puwu o tiluwon a puwu a gelon. ");
INSERT INTO due_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sinabi ni Hisus de manga katabeng, “Pinoin yu ni orat i manga tapayen.” Ta dingan pinino de ngani. ");
INSERT INTO due_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ta sinabi na pa, “Tumabu kamo nano ta addein yu de gepamahala ni kásalan.” Ay inadde de ngani de gepamahala ni kásalan. ");
INSERT INTO due_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nun kininaman pan ni oyo i orat a napa ni tayug a malanis ay an katinggesan ni gepamahala ti deno inumapo inon. (Misan ay katinggesan pan ni katabeng ide a tinumabu ni orat.) Kanya tinawal na de lalaki a kinasal. ");
INSERT INTO due_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Sinabi na, “I ugeli tam de kásalan ay i tagibu tam a boboy ay i piyon a tayug a malanis ta be hanga di i ininom ni agta ay dingan la boboy tam i an piyon a masakut a tayug a malanis. Misan ay ikamo pan ay pinainapóan yu i piyon a masakut a tayug a malanis.” Inon i sinabi ni gepamahala. ");
INSERT INTO due_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","I nangyedi a oyo de kásalan de Kana de Galilea ay tagibu a gepakataka a yinadi ni Hisus. Dehil de oyo ay pinakita na i kapangyedihan na pati nagpanulusun diya i mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nano ay pagkatapos ninon ay kinumang i Hisus de benwaan a Kapernam a ayun na i ina na, manga wele pati mag-aadel na ide ta tinumaan ide duman ni tipide a adow. ");
INSERT INTO due_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Alane di i kaadowen ni Paskuwa ni Hudyo ide kanya kinumang i Hisus de benwaan a Herusalem. ");
INSERT INTO due_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nun duman di eya de beloy a pighandogen de Makedepat ay kinta na a kalipalipa i magpapanggetang ide ni beka, topa pati kalapati pati maglelewes ide ni kuwarta a Roma de kuwarta a Hudyo. ");
INSERT INTO due_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ta nagyedi i Hisus ni manga lubid a panlapdit na ta pinangalow na ide a pesan, beka pati topa, de beloy a pighandogen de Makedepat. Ta kinálat na pan i kuwarta ni manga maglelewes ide a pinulupaobbob na i pesan a lamesa de. ");
INSERT INTO due_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sinabi na de magpapanggetang ni kalapati, “Layuin yu nay ide dio ta wet yu yedia a palingki i beloy i ni Ama ko.” ");
INSERT INTO due_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ay naesip ni mag-aadel na ide i hinola de kasulatan a, “Dehil de pagbuot ko de beloy yu ay petiis ko i kahedepan.” ");
INSERT INTO due_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ay dingan tinanto eya ni manga ponu a Hudyo ide, “Ano inayeyedi yu a gepakataka tangani matinggesan mi a ikamo ay te kapangyedihan a geyedi ni oyo?” ");
INSERT INTO due_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tinumubeg i Hisus, “Sedein yu i beloy a oyo ta pouddi ko la de tiluwon a adow.” ");
INSERT INTO due_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Dingan sinabi ni Hudyo ide, “Ay apat a puwu pati anim a taon a yinadi i beloy a oyo ta an nappatud a pouddi yu de tiluwon la a adow.” ");
INSERT INTO due_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Misan ay i beloy a pesabi ni Hisus ay i lawes na. ");
INSERT INTO due_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kanya nun eya ay pinakaedup di a liwet, pagkatakig ni tiluwon a adow ay naesip nun mag-aadel na ide inon a sinabi ni Hisus ta dingan nagpanulusun ide de kasulatan a pinasolat ni Makedepat pati de sinabi a inon ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nano ay nun kaadowen ni Paskuwa ay de Herusalem i Hisus ta makmuk i nanulusun diya dehil de yinadi na a gepakataka a kinta de. ");
INSERT INTO due_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Misan ay an te pagpanulusun dide i Hisus ta inabuyenan na a masakut i innawa ni pesan a agta. ");
INSERT INTO due_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","An te kaelangan eya a te magsabi diya tungkul de kaagtaan ta katinggesan na ngani i innawa ni belang agta. ");
INSERT INTO due_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nano ay te isin a Pariseo a te kapangyedihan de Hudyo ide a i ngalan na ay Nikodemo. ");
INSERT INTO due_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nun isin a abi ay kinumang eya de Hisus a sinabi na, “Magtutodu, katinggesan mi a ikamo ay magtutodu a inumapo de Makedepat ta an te nakáyedi ni gepakataka a peyedi yu be an nappadikamo i Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tinumubeg i Hisus, “Talage a matud ay pesabi ko dikamo a be an panganak a liwet i misan ino a agta ay an nappatud a te kapangyedihan i Makedepat de innawa na.” ");
INSERT INTO due_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tinanto ni Nikodemo eya, “Papalano man a panganak a liwet i agta be eya ay matande di? Ay an nappatud a nakesilong pa a liwet i misan ino de tiyen ni ina na a panganak a liwet.” ");
INSERT INTO due_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sinabi ni Hisus, “Talage a matud ay pesabi ko dikamo a be an panganak gepo de orat pati de Ispiritu i misan ino a agta ay an nakoduman de kataanan nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ta i pinanganak ni agta ay agta la misan ay i pinanganak ni Ispiritu ay kaleduwa ni agta a gepakikaisin de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kanya wet kamo magtaka de pesabi ko a oyo dikamo, a depat a panganak a liwet i belang agta. ");
INSERT INTO due_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Halimbewa ay geiyup i palos ti deno na buot ta peikna yu i tinog na misan ay an yu katinggesan ti deno inumapo o ti deno pa agow. Maginon pala ay an yu katinggesan a ti papalano pinanganak ni Ispiritu i agta.” ");
INSERT INTO due_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sinabi ni Nikodemo, “Ay talage a ang ko katinggesan a ti papalano a nangyeyedi i oyo.” ");
INSERT INTO due_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tinumubeg i Hisus, “Magtutodu kamo pampa de Israel. Ay kanugun a an yu katinggesan i oyo. ");
INSERT INTO due_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Talage a matud ay pesabi ko di dikamo i katinggesan mi a matud pati pepamatoden mi i kinta mi misan ay an yu petanggep i pagpamatud mi. ");
INSERT INTO due_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","“Be an yu pepanulusonan i pagtodu ko tungkul de bowon a edup dio de putok i ay talage ay an yu pala ponulusonan i sasabi ko tungkul de bege de langot. ");
INSERT INTO due_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nano ay an te dinumaditas de langot ti an ako a Pineta nun Makedepat a napa ni agta, a linumusong ngona a inumapo de langot. ");
INSERT INTO due_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pati ti papalano a dinitas ni Moises i bebek a tangso de kew duman de lugel a ilang nun nowon ay maginon pala a depat a deditas de kew i ako a Pineta nun Makedepat a napa ni agta, ");
INSERT INTO due_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tangani i misan ino a nonulusun deko ay magkaduman ni edup a an te kalog.” Inon i sinabi ni Hisus de Nikodemo. ");
INSERT INTO due_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ta dehil de hanga a masakut a pagbuot ni Makedepat de kaagtaan dio de putok i ay binoy na i kádu a Anak na a nagpakalibun tangani i misan ino a nonulusun diya ay gekaduman ni edup a an te kalog, a am pan nakkiblag de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta pinakang ni Makedepat i Anak na dio de putok i tangani nalligtas i kaagtaan dehil diya, a wet na ide hahatolan. ");
INSERT INTO due_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Kanya i misan ino a nonulusun diya ay an hahatolan misan ay i an nanulusun diya ay hinatolan di ta an eya nanulusun de kádu a Anak nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hinatolan di ide ta nakadio di de putok i, i salong a gepatallang de esip ni agta ide misan ay an de tinanggep ta buot de la i madumos a esip dehil de malot a pagyedi de. ");
INSERT INTO due_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Talage ay i nagkeedup de mammalotin ay pekapoyen na i salong, a am pala gelane de salong tangani wet na ketinggesan i pagyedi na a malot. ");
INSERT INTO due_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Misan pan ay i nagkeedup de kamatoden ay gelane de salong. Ta de maginon ay pepakita na a i pagyedi na ay nappaayun de kabuotan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkatapos ni oyo ay i Hisus pati mag-aadel na ide ay kinumulukang de buluberiyu de sákup ni Hudia. Duman ay tinumaan eya a ayun de ta i kaagtaan ay pinalinod ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Misan ay i Huwen pala ay gelinod de lugel a inon a alane de lugel a Salim ta hanga i orat duman pati gekang diya i kaagtaan a gepalinod ide diya. ");
INSERT INTO due_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ta am pa nabbilanggo i Huwen. ");
INSERT INTO due_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nano ay i isin a Hudyo pati tipide a mag-aadel ni Huwen ay nagitinalo ide tungkul de paglinod ni Huwen pati pagpalinod ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ta dingan kinumang ide de Huwen ta sinabi de diya, “Magtutodu, un lalaki a ayun yu de dipa ni Horden a pinamatoden yu ay maglilenod pala ta gekang kon diya i kamakmokan.” ");
INSERT INTO due_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tinumubeg i Huwen, “Be maginon ay petanggep na la i kapangyedihan a peboy diya ni Makedepat. ");
INSERT INTO due_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ta ikamo di pala i gepamatud de sinabi ko a an ako i Kristo a Pinangako nun Makedepat ta dinodul ok la a naona diya a gesabi ni tungkul diya. ");
INSERT INTO due_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Halimbewa i mahuna a kákasal ay para de lalaki la a kákasal. I ayun a geilat de pagdetong ni lalaki a kákasal ay nagkasalig a masakut be iknain na a nasurutsurotan di i kákasal ide. Maginon pala ay nagkasalig ok di a masakut nano. ");
INSERT INTO due_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ta eya ay depat a nappa ni maditas pa ta ako pan ay depat a nappa ni masidong pa.” Inon i sinabi ni Huwen a Maglilenod. ");
INSERT INTO due_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nano ay i gepo de ditas ay te kapangyedihan pa de pesan misan i tage putok ay gesurut ni tungkul de attanan dio de putok i. Talage a i gepo de langot ay maditas pa de pesan. ");
INSERT INTO due_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pati pepamatoden ni gepo de ditas i inikna pati kinta na de langot misan ay i kamakmokan ay an gepanulusun de pagpamatud na. ");
INSERT INTO due_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Misan pan ay i getanggep de pagpamatud na ay gepamatud pala a i Makedepat ay te kamatoden. ");
INSERT INTO due_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ta eya a dinodul dio ni Makedepat ay gesubi ni surut nun Makedepat ta gekaduman eya ni pesan a kapangyedihan ni Ispiritu. ");
INSERT INTO due_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pebuot ni Ama i Anak na ta binoy diya ni Ama i kapangyedihan de pesan. ");
INSERT INTO due_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","I gepanulusun de Anak ay te edup a an te kalog misan i an gepanulusun de Anak ay an eya gekaduman ni edup a an te kalog ta gekaduman eya ni padusa ni Makedepat magpakapide pa man. ");
INSERT INTO due_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Nano ay nabereta nun Pariseo ide a te duman di a namas pa a makmuk a getalinga a gepalinod de Hisus, a an di masakut de Huwen. (Misan ay i kamatoden ay an i Hisus i gelinod ta un mag-aadel na la ide.) Nun matinggesan yo a bereta ni Hisus ");
INSERT INTO due_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ay tinumotul eya de sákup ni Hudia a inumampulang de sákup ni Galilea. ");
INSERT INTO due_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Misan ay depat a de sákup ni Samaria eya nesila. ");
INSERT INTO due_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kanya pagsila de de sákup ni Samaria ay dinumatong ide Hisus de isin a benwaan a Sikar a alane de kaengin a binoy ni Hakob de anak na a Hose nun nowon. ");
INSERT INTO due_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Duman un bubun a madisalad ni Hakob ta linumipa i Hisus de alane ni bubun ta nagkapagel eya de pagtotul na. Nun nanon ay udto di. ");
INSERT INTO due_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Te isin a mahuna a tage Samaria a dinumatong tangani nátabu. Sinabi diya ni Hisus, “Biyen ok mo tebe ni orat.” ");
INSERT INTO due_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(An duman un mag-aadel na ide ta kinumang ide de benwaan a nágetang ni pápangan.) ");
INSERT INTO due_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nagtaka i mahuna ta sinabi na de Hisus, “Ikaw ay Hudyo, ako ay tage Samaria. Ano ta geaged ka deko ni einom?” Sinabi na inon ta an mag-ayun i Hudyo ide pati tage Samaria ide. ");
INSERT INTO due_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tinumubeg i Hisus diya, “Ti katinggesan yu la ti ano i peboy ni Makedepat pati ti ino ok a geaged dikamo ni einom ay ikamo tebe i náaged deko ta bebiyen ko pan ikamo ni orat a geboy ni edup.” ");
INSERT INTO due_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sinabi nun mahuna, “Ang kamo te panabu ay madisalad i bubun i. Deno kamo nangamit ni orat a geboy ni edup? ");
INSERT INTO due_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Inuminom i kaapoapohan mi a Hakob, mangának na pati manga hayup na. Te kapangyedihan kamo pa man de Hakob a nagboy dikami ni bubun a oyo?” ");
INSERT INTO due_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tinumbeg i Hisus, “I neinom ni orat a oyo ay noohaw a liwet, ");
INSERT INTO due_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","misan ay i neinom ni orat a boboy ko diya ay an di noohaw magpakapide pa man. Ta i orat a boboy ko diya ay nappa ni magi bukal de innawa na, a nomoy diya ni edup a an te kalog.” ");
INSERT INTO due_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sinabi nun mahuna, “Biyen ok yu tebe ni orat a pesabi yu tangani wet ok di noohaw pati nedio a nátabu ni orat.” ");
INSERT INTO due_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sinabi ni Hisus, “Umuli kamo ta ikagin yu dio i bebi yu.” ");
INSERT INTO due_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tinubeg nun mahuna, “Anok te bebi.” Sinabi ni Hisus, “Matud i sinabi yu a ang kamo te bebi ");
INSERT INTO due_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ta lima di i napa ni bebi yu ta i ayun yu nano ay an yu bebi kanya matud i sinabi yu.” ");
INSERT INTO due_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Sinabi nun mahuna, “Ay katinggesan ko di a ikamo ay magsasabi nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nano ay dio nagpodi de Makedepat i kaapoapohan mi ide de kalasan a oyo misan ay ikamo a manga Hudyo i gesabi a de Herusalem la pepodi i Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Tinubeg ni Hisus i mahuna, “Mahuna, manulusun kamo deko a nádetong i panahon a popodi yu i Ama a Makedepat a an la de kalasan o de Herusalem man. ");
INSERT INTO due_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ikamo a tage Samaria ay an yu peabuyenan i Makedepat a pepodian yu misan pan ay ikami a manga Hudyo ay peabuyenan mi i pepodian mi ta i magliligtas ay gepo la de Hudyo ide. ");
INSERT INTO due_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Talage a gedetong i panahon, a nano dingani, a i matud a gepodi ide de Ama ay gepodi a nappaayun de kamatoden pati de kaleduwa a gepakikaisin diya. Ta i oyo ide i pelawag ni Ama a pagpodi diya. ");
INSERT INTO due_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Talage a i Makedepat ay Ispiritu kanya depat a podiin eya ni gepodi ide a nappaayun de kamatoden pati de kaleduwa a gepakikaisin diya.” ");
INSERT INTO due_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Sinabi nun mahuna, “Katinggesan ko a nedio i Pinangako nun Makedepat a te ngalan a Kristo. Pagdetong na ay eya i gesabi dikitam ni pesan.” ");
INSERT INTO due_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tinubeg ni Hisus, “Akod yo a gepakisurut dikamo.” ");
INSERT INTO due_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ta dingan dinumatong di un mag-aadel na ide. Naloktat ide nun kinta de a gepakisurut i Hisus de mahuna misan ay an ide nagtanto, misan isin, a ti ano i buot ni mahuna o ano ta gepakisurut i Hisus diya. ");
INSERT INTO due_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pagdetong de ay winalat ni mahuna un pantabu na ta inumampulang de benwaan a sinabi na nunde tage duman ide, ");
INSERT INTO due_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Sumut kamo deko ta pagelawagin yu i agta a gesabi deko ni pesan ko a yinadi. Makati eya di un pesabi a Kristo?” ");
INSERT INTO due_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kanya binumulwag ide de benwaan ta kinumang de Hisus. ");
INSERT INTO due_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nun pakang pa ide de Hisus ay an la pakosa a sila ay sinabi ni mag-aadel na ide de Hisus, “Magtutodu, mamangan kamo di.” ");
INSERT INTO due_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Misan ay tinubeg na dide, “Ako ay te pápangan a an yu katinggesan.” ");
INSERT INTO due_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kanya natulutantoan ide a te nangadde man diya ni pápangan. ");
INSERT INTO due_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Dingan sinabi dide ni Hisus, “I pápangan ko ay i yediin i pepayedi ni Makedepat a nagdodul deko pati tumalinga ok de kabuotan na. ");
INSERT INTO due_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Nano ay pesabi yu a apat pa a bulan ay dingan tigguto di misan ay pesabi ko pan dikamo a pagelawagin yu i agta ide a gedetong ta ide ay nappahande a nonulusun deko a magi kaparayen a inogen di a nappatud a goguto. ");
INSERT INTO due_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Talage a i magguguto a gepaabut deko ni kaagtaan ay nátanggep ni bilos a geapo de Makedepat ta i ginuto a geabut deko ay gekaduman ni edup a an te kalog. Ta de maginon ay nagkasalig di a magkakoloy i magpapasok ni surut nun Makedepat pati magguguto a gepaabut deko ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Matud i pigsabiin a den ni agta a, ‘I tipide i gepasok ta i kakmukan pan i geguto.’ ");
INSERT INTO due_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Pedodul ko ikamo tangani magguto ni an yu pinasok ta buot ko a sasabi a hanggen nunde gepo ay nagsabi i manga katabeng ni Makedepat ni surut na de kaagtaan ta nano ay ikamo i te pagkakataon a gepaabut deko ni kaagtaan.” Inon i pagtodu ni Hisus de mag-aadel na ide a te talinghage. ");
INSERT INTO due_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Kanya nun paglane di de Hisus ni tage Samaria ide de inon a benwaan ay nagpanulusun ide diya dehil de pagpamatud ni mahuna a sinabi ni Hisus i pesan a yinadi na. Ay inaged ni makmuk a tage Samaria a nekitaan i Hisus dide ta maginon i yinadi na ni aduwa a adow. ");
INSERT INTO due_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ta makmuk pa a nagpanulusun de Hisus nun inikna de i surut na ");
INSERT INTO due_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","kanya sinabi de de mahuna, “Gepanulusun kami nano a an dehil de sinabi mo ta dehil la de inikna mi a pagsurut na. Peabuyenan mi a eya ngani i magliligtas ni kaagtaan a pesan dio de putok i.” Inon i sinabi de. ");
INSERT INTO due_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagkatakig ni aduwa a adow ay tinumotul i Hisus de Samaria a paagow de Galilea. ");
INSERT INTO due_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nano ay nagpamatud i Hisus a an te misan ino a magsasabi a pegelang de sadile na a lugel. ");
INSERT INTO due_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Misan ay pagdetong nide Hisus de Galilea ay piyon i pagtanggep diya ni tage lugel na ta kinta de pala i pesan a yinadi na duman de Herusalem nunde kaadowen. Ta ide pala ay dinumuman de kaadowen ni Paskuwa. ");
INSERT INTO due_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kinumang a liwet i Hisus de beriyu a Kana de Galilea a duman na yinadi a tayug a malanis i orat. Nano ay duman pan de benwaan a Kapernam ay te isin a te kapangyedihan ni gubyerno. Ay i anak na a lalaki ay te orom. ");
INSERT INTO due_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nun nabereta na a inumampulang i Hisus de Galilea a inumapo de Hudia ay kinumang eya de Hisus a geaged a sumut diya tangani papiyonin ni Hisus i anak na a gehingalo di. ");
INSERT INTO due_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sinabi diya ni Hisus, “Hanggen ang kamo nekita ni gepakataka o tande ay ang kamo nonulusun.” ");
INSERT INTO due_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sinabi ni te kapangyedihan, “Tam di tebe, Magtutodu, dingan pa malibun un anak ko.” ");
INSERT INTO due_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tinumubeg i Hisus, “Umuli kamo di ta piyon di un anak yu.” Inon i sinabi ni Hisus ta nanulusun un lalaki de surut na ta inumuli eya. ");
INSERT INTO due_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","De bektas pa ay natagbu di eya nun katabeng na ide ta sinabi de a piyon di un anak na. ");
INSERT INTO due_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kanya tinanto na di a, “Ano man a odes a napiyon eya?” Tinubeg de eya a, “Naeyenan ni lagnat na depun, ni kaisin a odes ni udto.” ");
INSERT INTO due_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ay naesip nun ama nun te orom a maginon a odes nun sinabi ni Hisus a, “Piyon di un anak yu.” Kanya eya pati kamittanak na ide ay nagpanulusun de Hisus. ");
INSERT INTO due_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","I oyo i káduwa a gepakataka a yinadi ni Hisus de Galilea pagkadetong na a inumapo de Hudia. ");
INSERT INTO due_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagkatakig ni untik a panahon ay te kaadowen i Hudyo ide ta kinumang pala i Hisus de Herusalem. ");
INSERT INTO due_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nano ay de Herusalem ayte hanga a limbok a i ngalan na de surut a Hebreo ay Betesda. Iwina a orat ay alane de pintohan a pesilongan ni topa ide de Herusalem. De kulukaginglan ni orat ay te lima a beloy a an te sagbong ");
INSERT INTO due_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ta duman kaideide i makmuk a te orom, bulag, pilay pati lungpo a peilat de a umiwes un orat. ");
INSERT INTO due_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ta be magkabuyo ay te panahon a gelusong i anghel ta pebungaybungay na un orat dingan i tagibu a makadeorat, pagkatapos a pagbungaybungay nun orat ay nepiyon eya misan ano i orom na. ");
INSERT INTO due_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nano ay te duman a isin a lalaki a tiluwon a puwu pati walo di a taon a te orom. ");
INSERT INTO due_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nun kinta eya ni Hisus ta katinggesan na a náloy di eya a te orom ay tinanto eya ni Hisus, “Buot mo man a pumiyon ka?” ");
INSERT INTO due_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tinumubeg i te orom, “Magtutodu, an te náng-atid deko de orat be gebungaybungay ta paduman ok pa ay te naona di deko a kakmukan.” ");
INSERT INTO due_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Sinabi diya ni Hisus, “Gumiyos ka di ta addein mo i pig-eden mo na a matulutotul ka di.” ");
INSERT INTO due_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ay tambing a pinumiyon un lalaki ta inadde na un pig-eden na a nakatotul di. Nano ay nun nanon pan ay adow ni paimloy ");
INSERT INTO due_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","kanya sinabi ni manga ponu a Hudyo de lalaki a pinapiyon a, “Adow ni paimloy nano ta an nappaayun de pagdodul tam a addein mo i pig-eden mo na.” ");
INSERT INTO due_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Misan ay tinumubeg eya, “Ay i nagpapiyon deko i nagsabi a addein ko i pig-eden ko a matulutotul ok di.” ");
INSERT INTO due_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dingan eya ay tinanto de, “Ino i nagsabi dikaw a addein mo i pig-eden mo na a nakatotul ka di?” ");
INSERT INTO due_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Misan ay an na inabuyenan ti ino i nagpapiyon diya ta tinumotul di i Hisus ta makmuk i agta duman. ");
INSERT INTO due_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pagkatapos ay kinta eya ni Hisus de beloy a pighandogen de Makedepat ta sinabi na diya, “Nano ay piyon ka di kanya wet ka di magkasala a liwet ta makati namas pa a malot i násapit dikaw.” ");
INSERT INTO due_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dingan tinumotul i lalaki ta sinabi na de manga ponu a Hudyo a i Hisus i nagpapiyon diya. ");
INSERT INTO due_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kanya dehil de inon ay te gengsa ide de Hisus, a te gepo a getulutanto diya ta eya ay nagpapiyon de adow ni paimloy. ");
INSERT INTO due_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Misan ay sinabi dide ni Hisus, “I Ama ko ay geyedi ni kapiyonan misan kapide kanya geyedi ok pala ni maginon.” ");
INSERT INTO due_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gepo de inon a surut na ay namas di a pinelit de a bunoin eya ta an getalinga de ugeli de a tungkul de adow ni paimloy. Ta namas pa ay pesabi na a i Makedepat i Ama na ta de maginon ay pepadepade na i sadile na de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tinumubeg dide i Hisus ta sinabi na a “Talage a matud ay pesabi ko dikamo a ako a Anak ay anok geyedi ni misan ano dehil de sadile ko a kabuotan ta i peyedi ko la ay i pekita ko a peyedi ni Ama ko. I peyedi ni Ama ay inon pala i peyedi ko a Anak. ");
INSERT INTO due_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ta pebuot ni Ama i ako a Anak kanya pepakita na deko a Anak i pesan a peyedi na. Pati pan de panahon a nádetong ay pepakita na deko a Anak i namas pa a gepakataka de oyo ta getaka kamo ngani a pesan. ");
INSERT INTO due_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ta ti papalano a te kapangyedihan i Ama a pepakaedup na i nalibunin, a bebiyen na ide ni edup ay maginon pala pebiyen ko a Anak ni edup i misan ino a buot ko a pakeedup. ");
INSERT INTO due_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pati an gepadusa i Ama de misan ino ta binoy na deko a Anak na i pesan a kapangyedihan a magpadusa, ");
INSERT INTO due_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tangani gelangin ni pesan i ako a Anak a magi paggelang de de Ama. Ta i an gegelang deko a Anak ay am pala gegelang de Ama a nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Talage a matud ay pesabi ko dikamo a i getalinga de surut ko, a nonulusun pala de nagdodul deko ay te edup a an te kalog. An di eya podusahan ta te edup di a bowon, a an di pala nakkiblag de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Talage a matud ay pesabi ko dikamo a nádetong i panahon, a nano dingani, a i nakiblag di ide de Makedepat dehil de mammalotin de ay eikna de i olang ko a Anak nun Makedepat ta dingan te duman dide a nátalinga deko, a nátanggep ni edup a bowon. ");
INSERT INTO due_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ta ti papalano a i Ama ay pegepoan ni edup a an te kalog ay maginon pala i Anak ay biniyen na ni kapangyedihan a napa ni pegepoan ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta biniyen ok na pala ni kapangyedihan a gehatol ta ako i Pineta nun Makedepat a napa ni agta. ");
INSERT INTO due_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wet kamo magtaka de oyo a pesabi ko ta nádetong pala i panahon a eikna ni nalibunin de pigtaporan i olang ko. ");
INSERT INTO due_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ta ide ay liwet a needup, a nobulwag de táporan de. I pesan a nagyedi ni piyon ay pakeedup a bebiyen ni edup a an te kalog ta i pesan a nagyedi ni mammalotin ay pakeedup a nátanggep ni padusa a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Talage a anok geyedi ni misan ano dehil de sadile ko a kapangyedihan ta gehatol ok la a nappaayun de pesabi deko ni Ama a Makedepat. Kanya matud i paghatol ko ta an i kabuotan ko i peyedi ko ta i kabuotan la ni nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nano ay be ako la i gepamatud tungkul de sadile ko ay wet yu tanggepa inon a pagpamatud ko. ");
INSERT INTO due_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Misan ay te duman a isin pa, a i Huwen a Maglilenod, a gepamatud tungkul deko ta katinggesan ko a matud i pagpamatud na tungkul deko. ");
INSERT INTO due_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ta nun dinodul yu i katabeng yu ide de Huwen ay nagpamatud pala eya dikamo ni kamatoden tungkul deko. ");
INSERT INTO due_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nano ay ang ko kaelangan i pagpamatud ni agta misan ay pesabi ko la yo tangani nalligtas kamo. ");
INSERT INTO due_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nun nanon ay i Huwen ay magi matallang a salong a nagpatallang ni esip ni agta ide ta ikamo ay nasalig ni untik a panahon de tallang na a i pagtodu. ");
INSERT INTO due_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Misan nano ay te gepamatud tungkul deko a namas pa de pagpamatud ni Huwen ta i gepakataka a pepayedi deko ni Ama ay inon ide i gepamatud tungkul deko ta pepakita de a ako ay dinodul ni Ama. ");
INSERT INTO due_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Pati pan i Ama a nagdodul deko ay gepamatud pala tungkul deko misan ikamo ay an yu pa inikna eya o kinta man. ");
INSERT INTO due_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Talage a an naddeinnawa yu i surut ni Ama ta anok yu pepanulusonan a dinodul na. ");
INSERT INTO due_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Geadel kamo a masakut de kasulatan ide nun Makedepat ta peesip yu a de pagbesa yu ay gekaduman kamo ni edup a an te kalog. Nano ay inon a kasulatan ay gepamatud tungkul deko. ");
INSERT INTO due_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Misan ay an yu pan buot a nonulusun deko tangani magkaduman kamo tebe ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Talage a ang ko buot a podiin ok ni agta ide ");
INSERT INTO due_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","misan ay peabuyenan ko i buot yu ta katinggesan ko ngani a ang kamo te pagbuot de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Dinumatong ok di dehil de kapangyedihan ni Ama misan anok yu petanggep. Nano ay nádetong i kakmukan dehil de sadile na a kapangyedihan ay petanggep yu ngani. ");
INSERT INTO due_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","I buot yu la ay i paggelang ni belang isin dikamo ta an i paggelang a gepo de Makedepat kanya an nappatud kamo a nonulusun diya. ");
INSERT INTO due_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Wet yu esipa a ako i gesumbong de Ama ko a ikamo ay malot ta i Moises a peasaan yu i gesumbong a malot kamo. ");
INSERT INTO due_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ta be talage a peppanulusonan yu i solat ni Moises ay ako ay peppanulusonan yu pala ta eya ay nagsolat tungkul deko. ");
INSERT INTO due_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Misan ay be dehil de an yu peppanulusonan i solat na ide ay talage a ang kamo gepanulusun de surut ko ide.” Inon i sinabi ni Hisus de tage Herusalem ide nun duman pa ide Hisus. ");
INSERT INTO due_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nun máloy di ay dinumapit ide Hisus de dipa ni uluataben a Galilea a i uluataben a Tiberias. ");
INSERT INTO due_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ay inumabut diya i makmuk a agta ta kinta de i gepakataka a yinadi na de pagpapiyon na de te manga orom. ");
INSERT INTO due_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Sinumakat ngona i Hisus de karipakip ni kalasan a ayun na un mag-aadel na ide ta linumipa duman. ");
INSERT INTO due_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Alane di nun nanon a panahon i kaadowen ni Paskuwa nun Hudyo ide.) ");
INSERT INTO due_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nun sinumayéd i Hisus ay kinta na a gedetong i makmuk a agta. Tinanto na i Pilepi, “Ti deno kitam nanggegetang ni tinapay a pápangan ni agta ide a oyo?” ");
INSERT INTO due_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Sinabi na yo tangani subukan na i Pilepi a ti ano i sasabi na ta katinggesan ni Hisus i yeyedi na.) ");
INSERT INTO due_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tinumubeg i Pilepi, “Misan halage a isin a lebu pati lima a dian a peso a tinapay ay an nosukul ngani a pápangan ni makmuk a masakut a agta a magioyo.” ");
INSERT INTO due_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Dingan i isin de mag-aadel na ide a i Andres a wele ni Simon Pedro ay sinabi na de Hisus a, ");
INSERT INTO due_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Te duman a i isin a anak a lalaki a te adde ni lima a tinapay pati aduwa a ikan misan ay panganó tam yo de magioyo a kamakmuk ni agta.” ");
INSERT INTO due_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tinubeg ni Hisus, “Palipain yu i kaagtaan.” Ta duman de lugel a inon ay te kademóan a malawa kanya nagilinepa ide a pesan ta i manga lalaki ay manga lima a lebu. ");
INSERT INTO due_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ta inamit ni Hisus un tinapay a nagpasalamat de Makedepat dingan pinabuluboy na dide a kalipalipa. Maginon pala i yinadi na nunde aduwa a ikan ta ide a pesan ay biniyen hanggen buot de. ");
INSERT INTO due_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nun nakapangan di ide a pesan a sukul ay sinabi na de mag-aadel na ide, “Tipunin yu i kulukapisang a an naubus tangani an nakanugun.” ");
INSERT INTO due_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Maginon ngani i pagtipun de de an naubus a kulukapisang a inumapo de lima a tinapay a pinangan ni kaagtaan ta nakapino ide ni sangpuwu pati aduwa a gelálan. ");
INSERT INTO due_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nun kinta ni kaagtaan i oyo a gepakataka a yinadi ni Hisus ay sinabi de, “Matud dingani a eya i magsasabi a pinangako a nedio de putok i.” ");
INSERT INTO due_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Inabuyenan ni Hisus a buot ni agta ide a pepelit de eya a yeyedi de a hari kanya sinumakat eya a liwet a lallan a paagow de pagotan. ");
INSERT INTO due_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Misan nun nodumos di ay dinumolug i mag-aadel na ide de kaginglan ni uluataben. ");
INSERT INTO due_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nun abi di a am pa i Hisus ay sinumakoy ide de bengka a dinumapit a paagow de Kapernam. ");
INSERT INTO due_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Misan i palos ay sinumilog a nagpahangain ni desi. ");
INSERT INTO due_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nun makaawet ide ni manga anim a kilometro ay kinta de i Hisus a getotul de disapow ni atab a palane de bengka ta ide ay natakut. ");
INSERT INTO due_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Misan ay sinabi na dide, “Wet kamo matakut ta ako yo.” ");
INSERT INTO due_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ay nagkasalig ide a pinasakoy de i Hisus de bengka ta tambing a sinumangrad un bengka nunde paagowen de. ");
INSERT INTO due_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Nun kinábiabian di ay duman pa nunde dipa nun uluataben i makmuk a agta a alane pa nunde lugel a pinamanganan de ni tinapay, pagkapagsalamat ni Panginoon. Kinatinggesan de a isin la i bengka ni mag-aadel na ide pati kinatinggesan de pala a an sinumut i Hisus dide nun dinumapit i mag-aadel na ide a paagow de Kapernam. Nagtaka i kamakmokan nun an de kinta i Hisus kanya nun dinumatong pan i tipide a bengka a inumapo de benwaan a Tiberias a dinumong de alane de ay dingan dinumapit ide a paagow pala de Kapernam tangani lalawag de i Hisus. ");
INSERT INTO due_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nun kinta de i Hisus pagdetong de nunde dipa ay tinanto de eya, “Magtutodu, kapide kamo pa man dio?” ");
INSERT INTO due_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tinumubeg i Hisus, “Talage a matud ay pesabi ko dikamo a pelawag ok yu la dehil de pápangan a tinapay a nakabiyag dikamo ta an dehil de gepakataka a gepamatud tungkul de kapangyedihan ko. ");
INSERT INTO due_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pesabian ko ikamo a wet magpagel dehil de pápangan a nagkoubus ta magpagel kamo la dehil de inon a magi pápangan a an nagkoubus, a geboy ni edup a an te kalog. Ta ako a Pineta nun Makedepat a napa ni agta ay geboy ni oyo dikamo ta binoy deko ni Makedepat a Ama i kapangyedihan na.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kanya eya ay tinanto de, “Ano i depat mi a yeyedi tangani mayedi mi i kabuotan ni Makedepat?” ");
INSERT INTO due_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","“I oyo i pepayedi dikamo ni Makedepat a manulusun kamo deko a dinodul na.” Inon i tinubeg ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kanya tinanto de eya, “Ano i napekita yu a gepakataka tangani nonulusun kami dikamo? Ano i yeyedi yu? ");
INSERT INTO due_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ta i kaapoapohan tam ide ay namangan ni pápangan gepo de langot a te ngalan a mana nun duman ide de lugel a ilang. Ta te duman de kasulatan a, ‘Biniyen ide ni pápangan gepo de langot.’” Inon i sinabi de. ");
INSERT INTO due_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tinumubeg i Hisus dide, “Talage a matud ay pesabi ko dikamo a an i Moises i nagboy de kaapoapohan yu ide ni pápangan a gepo de langot ti an i Ama ko pati i Ama ko pala i geboy dikamo nano ni matud a pápangan a gepo de langot. ");
INSERT INTO due_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ta i pápangan a peboy ni Makedepat dikamo ay eya a linumusong a gepo de langot, a geboy ni edup a an te kalog de kaagtaan dio de putok i.” ");
INSERT INTO due_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Sinabi de de Hisus, “Biyen yu tebe ikami a ugnay ni pápangan a inon.” ");
INSERT INTO due_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tinubeg na, “Ako i pápangan a geboy ni edup ta i misan ino a gelane a nonulusun deko ay an netigeng o noohaw kapide man. ");
INSERT INTO due_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Nano ay magi sinabi ko ay ang kamo nanulusun deko misan kinta yu di i pagyedi ko a gepakataka. ");
INSERT INTO due_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","I pesan a peboy deko ni Ama ay gelane deko ta i gelane deko ay ang ko pangalow. ");
INSERT INTO due_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ta ako ay linumusong gepo de langot tangani yeyedi ko i kabuotan ni nagdodul deko, a an i kabuotan ko a sadili. ");
INSERT INTO due_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ta i oyo i kabuotan na a wet ko pabiyaan a nallagelag i misan isin de binoy na deko ta pakeedup ko ide a liwet de inapóan a adow. ");
INSERT INTO due_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Talage a oyo i kabuotan ni Ama ko a i pesan a geabuya deko a Anak pati nonulusun ay gekaduman ni edup a an te kalog ta ide ay pakeedup ko a liwet de inapóan a adow.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Misan ay i manga ponu a Hudyo ay nasurutsurotan ni malot tungkul de sinabi na a eya i pápangan gepo de langot. ");
INSERT INTO due_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kanya sinabi de, “Amman la iwina a Hisus i anak ni Hose? Ta peabuyenan tam pan a masakut i ama pati ina na kanya an matud i sinabi na nano a eya ay linumusong gepo de langot.” ");
INSERT INTO due_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kanya tinubeg ide ni Hisus, “Wet kamo masurutsurotan ni malot de sulusadile yu tungkul de sinabi ko. ");
INSERT INTO due_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ta an te nakálane deko be an ngona tatabengan eya ni Ama a Makedepat a nagdodul deko ta i nonulusun deko ay liwet ko a pakeedup de inapóan a adow.” ");
INSERT INTO due_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Sinabi ni Hisus a tuloy, “Te duman de kasulatan ni magsasabi ide a den a magioyo, ‘I pesan a agta ay totoduan ni Makedepat.’ Talage a i belang gepatalikngoy pati gekatingges de Ama ay ide i gelane deko. ");
INSERT INTO due_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Misan ay ang ko buot a sasabi a te nakakita di de Ama ta i ako la a inumapo diya i kinumita a matud de Ama. ");
INSERT INTO due_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Talage a matud ay pesabi ko dikamo a i nonulusun deko ay te edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ta ako i pápangan a geboy ni edup a inon. ");
INSERT INTO due_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Katinggesan ko ngani a i kaapoapohan yu ide ay namangan ni mana a pápangan de lugel a ilang misan ay an ide nagkaduman ni edup a an te kalog dehil de inon a mana. ");
INSERT INTO due_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ta ako pan i matud a pápangan gepo de langot tangani i belang gepangan ay an nakkiblag de Makedepat, a gekaduman pan ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ako i pápangan a pegepoan ni edup a gepo de langot ta needup magpakapide pa man i námangan ni oyo. Ta i pápangan a boboy ko tangani needup i kaagtaan dio de putok i ay i lawes ko i.” Inon i pagtodu ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ay dehil de inon ay natulutaloan i manga ponu a Hudyo ta sinabi de, “Ti papalano man a naboboy dikitam ni oyo a agta i lawes na tangani mapangan tam?” ");
INSERT INTO due_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kanya sinabi ni Hisus dide, “Talage a matud ay pesabi ko dikamo a be an yu pápangan i lawes ko a Pineta nun Makedepat a napa ni agta pati einom yu i sagu ko ay ang kamo gekaduman ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta i gepangan ni lawes ko pati geinom ni sagu ko ay gekaduman ni edup a an te kalog ta eya ay pakeedup ko a liwet de inapóan a adow. ");
INSERT INTO due_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ta i lawes ko i matud a pigpanganin pati sagu ko i matud a pig-inomin. ");
INSERT INTO due_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","I gepangan ni lawes ko pati geinom ni sagu ko ay gepakikaisin deko ta gepakikaisin ok pala diya. ");
INSERT INTO due_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","I Ama a nagdodul deko ay i pegepoan ni edup ta ako ay nagkeedup dehil diya pati maginon pala i misan ino a gepangan deko ay nagkeedup eya dehil deko. ");
INSERT INTO due_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kanya ako i pápangan gepo de langot ta i gepangan ni oyo ay gekaduman ni edup a an te kalog. Misan i kaapoapohan yu ide a nalibunin de lugel a ilang ay an nagkaduman ide ni edup a bowon misan namangan ide ni pápangan a mana.” ");
INSERT INTO due_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Inon ngani i sinabi ni Hisus nun eya ay nagtodu de pigmitengan ni Hudyo ide de Kapernam. ");
INSERT INTO due_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nano ay nun inikna yo ni kamakmokan a nappaabut diya ay sinabi de, “Ay mahedep i oyo a pagtodu ta talage a an nappatud a nakatanggep ni oyo.” Inon i pinasurutsurotan de a an peikna ni Hisus ");
INSERT INTO due_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","misan ay katinggesan na i pinasurutsurotan ni kamakmokan a nappaabut diya kanya sinabi na dide, “Dehil man de inon a pagtodu ko ay wawalat ok yu man di? ");
INSERT INTO due_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ay ano man i eesip yu tungkul deko a Pineta nun Makedepat a napa ni agta be kekita ok yu a násalakat de den ko a kataanan? ");
INSERT INTO due_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","I Ispiritu la nun Makedepat i geboy ni edup a bowon ta an yo nayeyedi ni agta. Kanya i surut ko gepo de Ispiritu ay eya ngani i nomoy ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Misan ay te tipide dikamo a an gepanulusun deko.” Inon i sinabi ni Hisus ta kinatinggesan na a hanggen pa nun de gepo, ti ino ino i an nonulusun diya pati ti ino pala i gepadekop diya. ");
INSERT INTO due_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Dingan sinabi na pala, “Kanya kangwoni ay sinabi ko dikamo a an te nakálane deko be an ngona tatabengan eya ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pagkasabi na ninon ay makmuk de manga nappaabut diya i nagilinayu di diya a an di ide gepinagsut. ");
INSERT INTO due_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kanya tinanto ni Hisus i sangpuwu pati aduwa, “Ay kati ikamo pa man la ay buot yu di a gitinotul?” ");
INSERT INTO due_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tinumubeg i Simon Pedro diya, “Panginoon, dino kami paagow ta nappa dikamo la i surut a geboy ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Pati gepanulusun kami a katinggesan mi di pala a ikamo i Kristo a Anak nun Makedepat a an te kalebunan.” ");
INSERT INTO due_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Sinabi ni Hisus, “Talage a ikamo la a sangpuwu pati aduwa i pineta ko misan isin dikamo ay gepakikaisin de Satanas.” Inon i sinabi ni Hisus, ");
INSERT INTO due_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ta i pesabi na ay i Hodes a anak ni Simon Iskariyote ta i Hodes ay isin de sangpuwu pati aduwa a gepadekop de Hisus. ");
INSERT INTO due_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pagkatapos ninon ay sinilasilán ni Hisus i Galilea ta an na buot a sesilasilán i Hudia ta buot eya a bunoin duman nun manga ponu a Hudyo. ");
INSERT INTO due_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nano ay an di naaloy ay kaadowen di ni Hudyo ide a te ngalan a kaadowen ni Manga Demade. ");
INSERT INTO due_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kanya sinabi de Hisus ni manga wele na, “Bekot ta ang ka tumotul dio a kumang de lugel ni Hudia tangani kitain ni manga geabut dikaw i peyedi mo a gepakataka. ");
INSERT INTO due_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ta be buot ni agta a eya ay gelangin ay an na ngani petagu i peyedi na kanya ikaw pan ay magpaabuya ka di de pekita ni kaagtaan be matud a te kapangyedihan ka.” Inon i sinabi de diya ");
INSERT INTO due_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ta misan un manga wele na pala ay an nanulusun diya. ");
INSERT INTO due_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tinubeg ide ni Hisus, “Am pa i oyo i pagkakataon ko a gepaabuya ni kapangyedihan ko misan para dikamo ay magkapadepade i pesan a panahon. ");
INSERT INTO due_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ta ang kamo kagengsaan ni kaagtaan dio de putok i, misan ako ay kagengsaan ok de ta pepamatoden ko a malot i pagyedi de. ");
INSERT INTO due_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kumang kamo la de kaadowen ta an ok pa nákang ta am pa i oyo i panahon ko.” ");
INSERT INTO due_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pagkasabi na ninon ay nawalat eya de Galilea. ");
INSERT INTO due_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pagkatotul ni manga wele na ay kinumang pala i Hisus de kaadowen misan ay an eya nagpakita. ");
INSERT INTO due_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Misan ay linawag eya duman nun manga ponu a Hudyo ta tinanto de, “Deno i Hisus?” ");
INSERT INTO due_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ta te duman de kamakmokan ni agta a paulit-uletan a tungkul diya. Sinabi de, “Eya ay piyon a agta.” Sinabi pan ni kakmukan, “Eyen ta eya ay gedeya la ni kaagtaan.” ");
INSERT INTO due_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Misan ay an te nagsurut de peikna ni kamakmokan a tungkul diya ta te takut ide de manga ponu a Hudyo. ");
INSERT INTO due_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nano ay nun tinumakig di i manga apat a adow de kaadowen ay sinumilong i Hisus de beloy a pighandogen de Makedepat a nagtodu. ");
INSERT INTO due_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nagtaka un manga ponu a Hudyo ta sinabi de, “Ti papalano man a naketingges i oyo a agta ay am pan nag-adel de kaditasan tam a magtutodu a Hudyo?” ");
INSERT INTO due_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tinumubeg i Hisus, “An gepo deko i pagtodu ko ta gepo la de Makedepat a nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pati i misan ino a te buot a nanyeyedi ni kabuotan ni Makedepat ay dingan pepatingges diya ngani a i pagtodu ko ay gepo de Makedepat a an la de sadile ko. ");
INSERT INTO due_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Talage a i agta a te pagtodu a gepo de sadile na ay te buot la a gelangin i sadile na misan pan ay matud a an migdeya i misan ino a getodu tangani gelangin i nagdodul diya.” ");
INSERT INTO due_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Pagkasabi ni Hisus ninon ay sinosol na i te kapangyedihan ide ta sinabi na a, “Talage a binoy ni Moises dikamo i pagdodul ide nun Makedepat misan ay an te misan isin dikamo a getalinga de inon ide.” Dingan tinanto ide ni Hisus, “Bekot ta buot ok yu a bobono?” ");
INSERT INTO due_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nun an yinumamyam i te kapangyedihan ide ay tinumubeg un kaagtaan, “Te libong ka mangani. Inó man i te buot dikaw a nomuno?” ");
INSERT INTO due_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tinumubeg pala i Hisus, “Nun sakadow ay pinapiyon ko i isin a agta de adow ni paimloy ta dingan nagtaka kamo. ");
INSERT INTO due_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Misan pan ay ikamo be magkabuyo ay de adow ni paimloy ay te pagyedi pala ta papapélatan yu i mangának yu a lalaki de lawes de. Maginon i ugeli a binoy a tagibu ni Makedepat de kaapoapohan tam dingan pa sinolat ni Moises. ");
INSERT INTO due_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kanya be depat a pepapélatan yu i mangának yu a lalaki de adow ni paimloy tangani petalingaan yu i pagdodul ni Moises ay an piyon a gebulas kamo deko dehil de pagpapiyon ko ni agta de adow ni paimloy. ");
INSERT INTO due_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Pesabian ko ikamo a wet kamo maghatol a maparipari dehil de nasalépatan yu la ta kati ang kamo te katinggesan a sukul. Yadi pa a maghatol kamo la dehil de matud a katinggesan yu.” ");
INSERT INTO due_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nun pagkasabi ni Hisus ninon ay tinulutantoan ni tipide a tage Herusalem a, “Kasta i oyo di a agta un buot de kon a bobuno? ");
INSERT INTO due_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Misan ay pagelawagin yu ta getodu eya de kaagtaan, a an te gesablow de surut na. Makati pan inabuyenan di ni te kapangyedihan ide a eya i Kristo a Pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Misan ay an nappatud non ta ang kon te katinggesan i misan ino ti deno náapo i Kristo a Pinangako nun Makedepat pagdio na, misan ay katinggesan tam pan ti deno inumapo i agta a oyo.” Inon i pagtalo ni esip de. ");
INSERT INTO due_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kanya malagdu a sinabi ni Hisus nun eya ay nagtodu de beloy a pighandogen de Makedepat ta sinabi na, “Ay anok yu peabuyenan a sukul pati an yu katinggesan ti deno ok inumapo ta anok dinumio dehil de sadile ko a buot. Talage a i nagdodul deko i pegepoan ni kamatoden ta an yu peabuyenan eya. ");
INSERT INTO due_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Misan peabuyenan ko eya a masakut ta ako ay inumapo diya ta eya i nagdodul deko.” ");
INSERT INTO due_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pagkasabi na ninon ay binuot de eya a dedekop misan ay an te binumol diya ta am pa dinumatong i odes a pagdekop diya. ");
INSERT INTO due_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ay de kamakmokan de Herusalem ay makmuk a agta ay nagpanulusun de Hisus. Sinabi de, “Ay eya dingani i Kristo a pinangako nun Makedepat a peilat tam ta an di te kakmukan pa a nakáyedi ni gepakataka a namas pa de yinadi ni Hisus.” ");
INSERT INTO due_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nun inikna ni Pariseo ide a pasurutsurotan ni kaagtaan ide i tungkul de Hisus ay nagdodul ide pati manga ponu ni maghahandug ide ni magbebentay de ide tangani dedekop de i Hisus. ");
INSERT INTO due_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Misan ay sinabi ni Hisus dide a pesan, “Nakkakoloy ok yu pa ni untik a panahon ta dingan náampulang ok di de nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Lalawag ok yu misan ay anok yu kekita ta ang kamo nakoduman deko.” ");
INSERT INTO due_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pagkasabi na ninon ay nasurutsurotan i manga ponu a Hudyo a, “Deno man di nay paagow a an tam kekita? Paagow man nay de Hudyo ide a kinumálat de manga benwaaan ni an Hudyo, a getodu pala eya de an Hudyo ide? ");
INSERT INTO due_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ano i buot na a sasabi nun sinabi na a lalawag tam eya misan ay an tam kekita ta ang kitam kon nakoduman diya?” Inon i pinasurutsurotan de. ");
INSERT INTO due_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nano ay de inapóan pati mahalage a adow ni kaadowen ay inumuddi i Hisus ta malagdu a sinabi na, “Be te duman a nagkoohaw ay depat a nálane deko a neinom. ");
INSERT INTO due_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta te duman de kasulatan a, ‘I misan ino a nonulusun deko ay gepo de innawa na ay nobukal a nobulus i orat a geboy ni bowon a edup de kakmukan.’” ");
INSERT INTO due_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nano ay i oyo a sinabi ni Hisus ay tungkul de Ispiritu a tatanggep ni belang gepanulusun diya ta nun panahon a inon ay am pa binoy i Ispiritu nun Makedepat ta am pa gepangyedi i panahon a pakaedup di a liwet i Hisus a te kapangyedihan di de pesan. ");
INSERT INTO due_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nun inikna ni kaagtaan inon a sinabi na ay sinabi ni tipide a, “Matud ngani a eya di un magsasabi a peilat tam.” ");
INSERT INTO due_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sinabi ni kakmukan a, “Eya ngani i Kristo a Pinangako nun Makedepat.” Misan ay sinabi ni tipide pa a, “I Hisus a oyo ay tage sákup ni Galilea pati an nappatud a náapo de sákup ni Galilea i Kristo a Pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ta te duman de kasulatan a i Kristo ay isin a apo ni kaapoapohan tam a Debid pati eya ay panganak de Betlehem a benwaan ni Debid.” Inon i sinabi de ");
INSERT INTO due_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","kanya an padepade i esip ni kaagtaan tungkul de Hisus. ");
INSERT INTO due_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Binuot ni tipide a dekopin eya misan ay an te misan ino a binumol diya. ");
INSERT INTO due_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nano ay i magbebentay ide ay inumampulang de ponu ide ni maghahandug ide pati de Pariseo ide dingan tinanto de i magbebentay ide, “Bekot ta an yu inadde i Hisus dio?” ");
INSERT INTO due_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tinumubeg ide, “Nano kami la inumikna ni pagtodu a magi pagtodu na.” ");
INSERT INTO due_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sinabi ni Pariseo ide, “Makati ikamo man ay nadeya na pala? ");
INSERT INTO due_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Esipin yu ta ikami a te manga kapangyedihan ay ang kami gepanulusun diya. ");
INSERT INTO due_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ta i gepanulusun la diya ay i manga agta a an te katinggesan de pagdodul ide kanya nopuksa ide.” Inon i sinabi de. ");
INSERT INTO due_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nano ay i isin dide a Pariseo a i Nikodemo a kinumang de Hisus nun tagibu ay sinabi na dide, ");
INSERT INTO due_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ay kasta ni an nappaayun de pagdodul ide ni Moises, manga ayun, a hahatolan tam i agta be an ngona gepatalikngoy kitam a gekatingges a ti ano i yinadi na a malot.” ");
INSERT INTO due_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tinumubeg ide, “Ikaw pa man la ay tage Galilea a geayu diya? Pagelawagin mo de kasulatan tangani matinggesan mo a an te náapo de Galilea a magsasabi.” ");
INSERT INTO due_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pagkatapos ninon ay inumuli i belang isin. ");
INSERT INTO due_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Misan ay i Hisus ay kinumang de Kalasan a Olibo. ");
INSERT INTO due_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nun kinábiabian ay inumampulang eya de beloy a pighandogen de Makedepat ta linumane diya i kamakmokan kanya eya ay linumipa ta ide ay tinoduan na. ");
INSERT INTO due_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nun nanon ay inadde diya ni Pariseo ide pati magtutodu ide ni Hudyo i isin a mahuna a nakitan de a nakialam de lalaki. Ta pinauddi de i mahuna de pasulusinagkaden de ");
INSERT INTO due_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ta sinabi de de Hisus, “Magtutodu, i mahuna a oyo ay kinta mi a nakialam de lalaki. ");
INSERT INTO due_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nappaayun de pagdodul ni Moises a bonglagen eya hanggen de malibun. Misan ano i sasabi yu?” ");
INSERT INTO due_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nagtanto ide de Hisus a pedeya de eya tangani te masabi ide a gesumbong tungkul diya. Misan ay namalingkata i Hisus ta nagsolat de putok ni guramut na. ");
INSERT INTO due_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nun an de petimokan i Hisus ni pagtanto ay pinagelawag na ide ta sinabi na i magioyo, “Ino man dikamo i an te kasalanan i náona a mamonglag de mahuna.” ");
INSERT INTO due_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ta dingan linumiwet i Hisus a namalingkata ta sinumolat pa a liwet de putok. ");
INSERT INTO due_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Misan nun inikna de inon ay namamos ide de sadile de a mammalotin ta tinumotul ide a pesan a uluisin, a naona i namas pa a matande dide ta duman la i Hisus pati mahuna a inumuddi. ");
INSERT INTO due_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tiningala ni Hisus un mahuna a tinanto na eya, “Mahuna deno ide? Amman la te nagpadusa dikaw misan isin?” ");
INSERT INTO due_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tinubeg na, “An te duman, Panginoon, misan isin.” Sinabi ni Hisus, “Ang ko pala ikaw hahatolan ta tumotul ka di a wet ka magkasala a liwet.” ");
INSERT INTO due_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nano ay liwet a nagsurut i Hisus de kaagtaan ide ta sinabi na, “Ako i salong a gepatallang de esip ni kaagtaan dio de putok i. I geabut deko ay gekaduman ni salong a i edup a bowon ta an notuloy eya de magi madumos a mammalotin na.” ");
INSERT INTO due_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sinabi diya ni Pariseo ide, “Ikaw i gepamatud de sadili mo kanya an te kabuluhan i pagpamatud mo.” ");
INSERT INTO due_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tinumubeg i Hisus, “Misan ako i gepamatud de sadili ko ay matud i pagpamatud ko ta katinggesan ko ti deno ok inumapo pati ti deno ok paagow misan ay ikamo ay angani te katinggesan tungkul deko. ");
INSERT INTO due_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wet kamo gehatol a nappaayun de esip ni agta la ta ako ay anok gehatol misan dino gepo de sadile ko a katinggesan. ");
INSERT INTO due_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Misan be gehatol ok ay matud i paghatol ko ta an la ako i gehatol ta pati Ama ko a nagdodul deko.” ");
INSERT INTO due_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sinabi ni Hisus a tuloy de Pariseo ide a, “Te duman de pagdodul yu a depat a aabut yu a, ‘Matud ngani i pagpamatud ni aduwa a agta be padepade i pesabi de.’ ");
INSERT INTO due_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nano ay gepamatud ok tungkul de sadile ko ta gepamatud pala tungkul deko i Ama ko a nagdodul deko.” ");
INSERT INTO due_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pagkasabi na ninon ay tinanto de eya, “Deno i Ama mo a gepamatud tungkul dikaw?” Tinumubeg i Hisus, “Anok yu peabuyenan pati Ama ko ta be peabuyenan ok yu tebe ay peabuyenan yu pala eya.” ");
INSERT INTO due_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","I oyo ay sinabi ni Hisus nun eya ay nagtodu de beloy a pighandogen de Makedepat de lugel a te pigpuoyen ni handug misan ay an te nanakop diya ta am pa dinumatong i odes a panakop diya. ");
INSERT INTO due_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sinabi ni Hisus a liwet de manga ponu a Hudyo, “Ako ay náampulang de inapoán ko ta lalawag ok yu misan ay nelibun kamo a am pa pinakaeyenan ni mammalotin yu ta ang kamo ngani nakoduman de paagowen ko.” ");
INSERT INTO due_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dingan pinasurutsurotan ni manga ponu a Hudyo, “Makati gepakalibun eya kanya sinabi na a ang kitam nakoduman de paagowen na?” ");
INSERT INTO due_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tinumubeg i Hisus, “Ikamo ay tage sidong, ako ay tage ditas. Ikamo ay tage putok i, ako ay eyen. ");
INSERT INTO due_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kanya sinabi ko a nelibun kamo a am pa pinakaeyenan ni mammalotin yu. Talage ay nelibun kamo a am pa pinakaeyenan ni mammalotin yu be ang kamo nonulusun a ako ngani.” ");
INSERT INTO due_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ay tinanto de eya, “Misan pan ay ino ka man?” Tinumubeg i Hisus, “Ako ay un pepamatoden ko dikamo nun tagibu pa hanggen nano. ");
INSERT INTO due_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nano ay makmuk i nasasabi ko a paghatol tungkul dikamo misan ay pesabi ko la de kaagtaan dio i inikna ko de nagdodul deko ta eya i matud ngani.” ");
INSERT INTO due_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Misan ay an de nagketinggesan a nagsurut eya a tungkul de Ama a i Makedepat. ");
INSERT INTO due_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kanya sinabi ni Hisus a tuloy a, “Be pepaditas yu di de padipa i ako a Pineta nun Makedepat a napa ni agta ay ketinggesan yu di a ako ngani ta anok te peyedi de sadile ko ta gesurut ok la ni nappaayun de petodu deko ni Ama. ");
INSERT INTO due_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ta gepakikaisin deko i nagdodul deko, a anok na pewalat a lallan ta ugnay ko a peyedi i gepakasalig diya.” ");
INSERT INTO due_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pagkaikna ni kamakmokan de inon a surut na ay makmuk ngani i nanulusun de Hisus. ");
INSERT INTO due_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dingan sinabi pan ni Hisus de Hudyo ide a nanulusun diya a, “Be notuloy kamo a náabut de pagtodu ko ay matud ngani a ikamo ay mag-aadel ko. ");
INSERT INTO due_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ta aabuyenan yu i kamatoden ta dehil de kamatoden ay ang kamo di alepin.” ");
INSERT INTO due_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ay tinumubeg diya un kakmukan, “Mangápo kami ni Abraham ta kapide man ay ang kami alepin de misan ino. Ano i buot mo a sasabi a ang kami di alepin?” ");
INSERT INTO due_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tinumubeg pala i Hisus, “Talage a matud ay pesabi ko dikamo a i misan ino a geyedi ni mammalotin ay alepin di ni mammalotin na. ");
INSERT INTO due_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pati katinggesan yu ngani a i Anak a matud i gemana magpakapide pa man de beloy ni Ama na misan ay i alepin ay eyen. ");
INSERT INTO due_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kanya be dehil de Anak a te kapangyedihan ay an di i pagkaalepin yu ay ang kamo di alepin a talage. ");
INSERT INTO due_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nano ay katinggesan ko a ikamo ay mangápo a sagu ni Abraham misan pan ay pepelit ok yu a bobuno ta an yu buot a tatanggep i pagtodu ko. ");
INSERT INTO due_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pesabi ko la i kinta ko de Ama ko misan ay peyedi yu pan i inikna yu de Ama yu.” ");
INSERT INTO due_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tinumubeg ide de Hisus, “I Abraham i ama mi.” Tinumubeg pala i Hisus, “Be ikamo ay mangának a matud ni Abraham ay totolad yu tebe i pagyedi na a piyon. ");
INSERT INTO due_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Misan ay buot ok yu a bobuno a ako a gesabi la ni kamatoden a inikna ko de Makedepat. Talage a an maginon i yinadi ni Abraham ");
INSERT INTO due_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ta i peyedi yu la ay magi peyedi ni Ama yu.” Sinabi de de Hisus, “Ang kami anak ni ti ino ta ikami ay te isin la a Ama a i Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sinabi dide ni Hisus a liwet, “Ti talage a i Makedepat i Ama yu ay pebuot ok yu tebe ta ako ay inumapo de Makedepat ta anok dinumio de sadile ko la ti an dinodul ok na. ");
INSERT INTO due_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Talage a an yu katinggesan i pesabi ko ta an yu buot a petanggep i pagtodu ko. ");
INSERT INTO due_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","I esip yu ay inumapo de Ama yu a Satanas ta buot ok yu a bobuno dehil de inon pala i kabuotan ni Ama yu. Hanggen nunde gepo ay migbuno di eya pati an geyedi ni kamatoden ta an te kamatoden diya a unabis. Be gebutil eya ay iwina ay nappaayun de kabuotan na a sadili ta eya ay butelan pati Ama ni pesan a kabutelan. ");
INSERT INTO due_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kanya anok yu pepanulusonan ta pesabi ko pan dikamo i kamatoden. ");
INSERT INTO due_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ino ino dikamo i te kaya a gepamatud a ako ay te kasalanan? Be ang kamo te kaya ay bekot ta anok yu pepanulusonan de pesabi ko a kamatoden. ");
INSERT INTO due_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Talage a i mangának ni Makedepat ay gepatalikngoy de surut na misan ikamo pan ay an yu pepatalikngan i surut na ta ang kamo mangának na.” ");
INSERT INTO due_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tinumubeg un manga ponu a Hudyo de Hisus, “Matud ngani i pesabi mi a ikaw ay isin a tage Samaria a te libong de lawes mo.” ");
INSERT INTO due_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tinumubeg pala dide i Hisus, “An te libong de lawes ko ta pepapodian ko la i Ama ko misan ay pelibek ok yu pan. ");
INSERT INTO due_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Anok gelawag ni ako ay podiin ta i Makedepat i gelawag ni oyo para deko ta eya i gepamatud a ako i gesabi ni kamatoden. ");
INSERT INTO due_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Talage a matud ay pesabi ko dikamo a i misan ino a getalinga de surut ko ay kapide man ay an di i kalebunan na.” ");
INSERT INTO due_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sinabi nun manga ponu a Hudyo, “Nano ay katinggesan mi ngani a te libong ka de lawes mo ta nalibun di i kaapoapohan mi a Abraham pati magsasabi ide a den ta misan pesabi mo a i misan ino a getalinga de surut mo ay an di nelibun, kapide man. ");
INSERT INTO due_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","An maditas pa i kapangyedihan mo de kapangyedihan ni kaapoapohan mi a Abraham a eya ay nalibun di pati manga magsasabi a den. Malot ngani i pagpodi mo de sadile mo.” ");
INSERT INTO due_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tinumubeg i Hisus, “Be ako la i gepodi de sadile ko ay an yo te kabuluhan misan i Ama ko a pesabi yu a Makedepat yu ay pepapodian ok na. ");
INSERT INTO due_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Talage a an yu eya peabuyenan ta pati be sasabi ko a ang ko eya peabuyenan ay nappa ni butelan ok a magi ikamo misan ay peabuyenan ko eya ngani ta petalingaan ko i surut na. ");
INSERT INTO due_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I Abraham a kaapoapohan yu ay nagkasalig nun kinatinggesan na a nádetong ok dio. Kinta na ngani i adow ni pagdio ko kanya eya ay nasalig.” ");
INSERT INTO due_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Misan ay sinabi diya ni manga ponu a Hudyo, “Ay ang kami gepanulusun dikaw ta ang ka te lima a puwu a taon kanya am mo pa kinta i Abraham.” ");
INSERT INTO due_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tinumubeg i Hisus, “Talage a matud ay pesabi ko dikamo a dingan pa pinanganak i Abraham ay ako ay te edup di.” ");
INSERT INTO due_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pagkasabi na ninon ay namulut ide ni beto tangani bonglagin de eya misan ay an de nakitan i Hisus ta eya ay tinumotul duman de beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nano ay de pagtotul na ay te kinta i Hisus a lalaki a pinanganak a bulag. ");
INSERT INTO due_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tinanto i Hisus ni mag-aadel na ide, “Magtutodu, ano ta pinanganak a bulag i oyo a lalaki. Te kasalanan man eya o i kamoddenan na ide?” ");
INSERT INTO due_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tinumubeg i Hisus, “An pinanganak a bulag i lalaki a iwina dehil de kasalanan na o ni kamoddenan na ide ta pinanganak nay a maginon tangani mapakita diya i pepayedi ni Makedepat. ");
INSERT INTO due_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nano ay depat ko a yediin i pepayedi ni nagdodul deko ta adow pa misan be nádetong i abi ay an di te nakayedi. ");
INSERT INTO due_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ta hanggen ako ay dio de putok i ay ako i salong a gepatallang de esip ni kaagtaan dio.” ");
INSERT INTO due_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pagkasabi ni Hisus ninon ay binumuge eya de putok a nagyedi ni lutit ta pinunas na de mata nun bulag. ");
INSERT INTO due_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sinabi diya ni Hisus, “Kumang ka de limbok to i a hanga a Siloem ta mag-uges ka ni mata mo duman.” (I Siloem ay te kabuluhan a, “Pinakang”.) Maginon ngani i yinadi nun bulag ta inumuli eya a gekakita di. ");
INSERT INTO due_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kanya nun kinta eya ni kabeloy na ide pati nakakita ide diya nun eya ay bulag pa a gepalimus ay natulutantoan ide “Amman la iwina a lalaki un den a bulag a gepalimus?” ");
INSERT INTO due_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tinumubeg i tipide, “Iwina ngani.” Sinabi pan ni kakmukan, “Eyen ta kamukha na la.” Misan ay sinabi nun lalaki, “Akod ngan yo.” ");
INSERT INTO due_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pagkatubeg na ay tinanto de eya, “Papalano ka pan a te kaya a gekakita di?” ");
INSERT INTO due_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tinumubeg eya, “I lalaki a pengalanan a Hisus ay nagyedi ni lutit ta pinunas na de mata ko a sinabi na deko a, Kumang ka de limbok a hanga a Siloem ta mag-uges ka ni mata mo duman. Kanya kinumang ok a nag-uges ta te kaya ok di a gekakita.” ");
INSERT INTO due_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tinanto de eya a, “Deno di eya?” Ay tinubeg na, “Ay mainde.” ");
INSERT INTO due_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dingan inikag de un den a bulag de Pariseo ide. ");
INSERT INTO due_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Adow ni paimloy, nun nagyedi i Hisus ni lutit a papiyonin na un mata nun bulag. ");
INSERT INTO due_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kanya tinanto eya nun Pariseo ide a ti papalano a te kaya di eya a gekakita. Sinabi na dide, “Pinunasan na ni lutit i mata ko ta pagkatapos ay nag-uges ok ni mata ko ta nano ay te kaya ok di a gekakita.” ");
INSERT INTO due_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sinabi ni tipide a Pariseo ide a, “An gepo de Makedepat i agta a iwina ta an na pegelang i adow ni paimloy.” Misan ay sinabi pan ni kakmukan a, “Papalano pan a nakaya di eya ni magioyo a gepakataka be eya ay makikkakasalanan?” Ta an padepade i esip ni Pariseo ide tungkul de Hisus. ");
INSERT INTO due_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kanya tinanto de a liwet un den a bulag, “Ikaw pan, ano i sasabi mo tungkul diya a pesabi mo a pinapiyon na i mata mo?” Tinubeg na ide, “Eya ngani ay isin a magsasabi.” ");
INSERT INTO due_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Misan ay i manga ponu a Hudyo ay an de buot a nonulusun a eya ay den a bulag a pinapiyon kanya pinakangan de un kamoddenan nun lalaki a pinapiyon. ");
INSERT INTO due_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ta pagdetong de ay tinanto ide ni Pariseo ide, “Anak yu man yo? Matud man a pinanganak yo a bulag? Ano ta te kaya eya a gekakita nano?” ");
INSERT INTO due_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Tinumubeg i kamoddenan na ide, “Katinggesan mi a eya ay anak mi ta katinggesan mi pala a eya ay pinanganak a bulag, ");
INSERT INTO due_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","misan ay am mi katinggesan ti papalano a te kaya di eya a gekakita o ti ino i nagpapiyon de mata na. Eyad la i tantoin yu ta matande di a sukul a nakapesabi ni tungkul de sadile na.” ");
INSERT INTO due_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Maginon i sinabi ni kamoddenan na dehil de takut de de manga ponu a Hudyo ta pinagkasungduan ni manga ponu a Hudyo a kekiblag de de pigmitengan de i misan ino a magpamatud a i Hisus ay i Kristo a Pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kanya dehil de inon ay sinabi nun kamoddenan na a eyad la i tantoin de ta matande di a sukul. ");
INSERT INTO due_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kanya de káduwa a sila ay pinaolangan de un den a bulag ta sinabi de diya, “Sabiin mo i kamatoden tangani podiin i Makedepat ta i nagpapiyon dikaw a pepamatoden mo ay katinggesan mi ngani a makikkakasalanan a agta.” ");
INSERT INTO due_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tinumubeg eya, “Ang ko katinggesan ti makikkakasalanan eya o eyen misan ay isin la i katinggesan ko a ako ay den a bulag ta nano ay te kaya ok di a gekakita.” ");
INSERT INTO due_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tinanto de eya, “Ano i yinadi na dikaw? Papalano a pinapiyon na i mata mo?” ");
INSERT INTO due_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tinumubeg eya, “Sinabi ko di a an yu pan buot a nonulusun. Ano ta buot yu pan di a eikna a liwet? Kati buot yu pala a nappa ni mag-aadel na?” ");
INSERT INTO due_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pagkatubeg na ninon ay sinosol de eya ta sinabi de, “Ikaw mangani i mag-aadel na misan ikami ay mag-aadel la ni Moises. ");
INSERT INTO due_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Katinggesan mi a nagsurut i Makedepat de Moises ta i agta pan a iwina ay am mi katinggesan ti deno inumapo.” ");
INSERT INTO due_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tinumubeg un den a bulag, “Iwina ngani i gepakataka ta an yu katinggesan ti deno inumapo ta eya pan i nagpapiyon de mata ko. ");
INSERT INTO due_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nano katinggesan tam a an patalikngan ni Makedepat i agta a makikkakasalanan misan ay pepatalikngan na i agta a gegelang diya pati geyedi ni kabuotan na. ");
INSERT INTO due_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Talage a gepo nun yediin i putok i ay am pa te nakapagpapiyon ni mata ni agta a pinanganak a bulag. ");
INSERT INTO due_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","An te nayedi i agta a inon be an eya inumapo de Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tinumubeg ide, “Pinanganak ka a te kasalanan a masakut ta bekot ta peesip mo a ikaw ay te kaya a getodu dikami.” Inon i paglibek de diya ta dingan pinakiblag de eya de pigmitengan ni Hudyo ide. ");
INSERT INTO due_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nabereta ni Hisus a pinakiblag eya ni Pariseo ide kanya pagkákita ni Hisus de lalaki ay tinanto na, “Gepanulusun ka man de Anak nun Makedepat?” ");
INSERT INTO due_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tinumubeg un lalaki, “Ino man eya? Sabiin yu deko tangani manulusun ok diya.” ");
INSERT INTO due_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Sinabi ni Hisus, “Akod ngan yo a inabuyenan mo a gepakisurut pala dikaw nano.” ");
INSERT INTO due_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Sinabi ni lalaki, “Gepanulusun ok, Panginoon.” Ta dingan eya ay nagpodi de Hisus. ");
INSERT INTO due_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sinabi ni Hisus, “Dinumatong ok dio de putok i tangani te pagkakataon i agta ide a nátanggep deko o gekapoy. Ta i an te katinggesan a magi bulag ay nakakita di. Misan ay i gemayabeng ide a te katinggesan a magi gekakita ay nappa ni magi bulag.” ");
INSERT INTO due_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nun inikna yo ni tipide a Pariseo a alane diya ay tinanto de eya, “Buot mo man a sasabi a pati ikami ay an te katinggesan a magi bulag ta am mi pa ikaw petanggep.” ");
INSERT INTO due_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tinumubeg i Hisus, “Eyen ta be ikamo ay i an te katinggesan a magi bulag ay nappa ni naketingges a pakeeyenan di ikamo ni mammalotin yu misan pan ay gekapoy kamo deko a gemayabeng pala a ikamo i naketingges a magi gekakita kanya ang kamo pakeeyenan ni mammalotin yu.” ");
INSERT INTO due_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Pagkatapos ninon ay nagtodu i Hisus ni talinghage a magioyo a, “Talage a matud ay pesabi ko dikamo a gesilong de kolongan ni topa, a an de pintohan gesila ta gedewet de kakmukan a selan ay migpannakow o tulisan. ");
INSERT INTO due_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Misan pan i mag-aalage a matud ni topa ide i gesila de pintohan. ");
INSERT INTO due_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pepasilong eya ni magbebentay de pintohan. Pati peabuyenan ni topa ide i surut na kanya be peolangan na i topa na ide de ngalan ngalan de ay geabut ide diya a pabulwag de kolongan. ");
INSERT INTO due_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ta be nabulwag na di i topa na ide ay eya ay naona dide ta geabut pan ide diya ta peabuyenan de i surut na. ");
INSERT INTO due_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","An ide geabut de kakmukan a an de peabuyenan ta ide ay gegikan a gelayu diya ta an de peabuyenan i surut ni kakmukan.” ");
INSERT INTO due_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Sinabi dide ni Hisus i talinghage a inon misan ay an de kinatinggesan i buot na a sasabi. ");
INSERT INTO due_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kanya sinabi a liwet dide ni Hisus, “Talage a matud ay pesabi ko dikamo a ako pala i magi pintohan a pesilan ni topa ide. ");
INSERT INTO due_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ta i naona ide deko a i magtutodu a an matud ay magi migpannakow ide o tulisan misan ay an ide tinalingaan ni topa ide. ");
INSERT INTO due_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Talage a ako i magi pintohan. I misan ino a gesilong deko ay nalligtas ta pealagean eya a pepatibong misan deno paagow. ");
INSERT INTO due_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kanya i migpannakow ay nádetong la dio a nannanakow, nomuno pati gepakálat ni topa ide. Misan ay ako ay dinumio tangani i topa ide ay gekaduman ni edup a matud pati masampat a masakut magpakapide man. ");
INSERT INTO due_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ako i piyon a mag-aalage ni topa ide ta gepakalibun ok a kosa a innawa para de topa ko ide tangani nalligtas ide. ");
INSERT INTO due_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Misan i peupahan a mag-aalage a an matud ay gelimok be pekita na a gedetong i aso de bukod a nángaget ni topa ide ta pewalat na ide ta an la diya. Kanya pepakálat ni aso de bukod i manga topa ide. ");
INSERT INTO due_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Gelimok eya ta peupahan la ta panganó na i topa ide. ");
INSERT INTO due_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Misan ako ngani i piyon a mag-aalage ni topa ta ti papalano a naeisin ok pati Ama ko ay maginon pala ay naeisin ok pati topa ko ide ta gepakalibun ok a kosa a innawa para de topa ko ide. ");
INSERT INTO due_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Te duman ok pa a kakmukan a topa a an la i manga Hudyo kanya depat a ako ay nappa ni mag-aalage de pala ta aabuyenan de ngani i surut ko ta dingan ide a pesan a topa ko ay nappa ni isin la a kalugbuwen a te isin pala a mag-aalage. ");
INSERT INTO due_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Talage a gepakalibun ok a kosa a innawa tangani needup ok pala a liwet kanya dehil de inon ay pebuot ok ni Ama ko. ");
INSERT INTO due_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","An te kapangyedihan i misan ino a nomuno deko ta gepakalibun ok a kosa la a innawa. Talage a ako i te kapangyedihan a gepakalibun, a needup pala a liwet ta inon i dinodul ni Ama ko a yediin ko.” Inon i pagtodu ni Hisus a talinghage. ");
INSERT INTO due_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nano ay liwet a an padepade i esip nun manga ponu a Hudyo dehil de surut a inon ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","I kamakmokan dide ay nagipinagsabi a, “Eya ay te libong de lawes na pati nasede i esip na kanya wet kamo magpatalikngoy diya.” ");
INSERT INTO due_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sinabi pan ni kakmukan a “An nakapesabi ni maginon i isin a te libong de lawes na. Talage a angani nakapepamuklat ni bulag i te libong.” Inon i pinasurutsurotan ni Hudyo ide. ");
INSERT INTO due_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nano ay nun panahon di a tig-agidnaw ay te duman de Herusalem i kaadowen ni beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nun nanon ay getotul duman i Hisus de betalan a yinadi ni Hari a Solomon. ");
INSERT INTO due_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tinumipun de pelébut na i manga ponu a Hudyo ta sinabi de diya, “Sabiin mo dikami i kamatoden ti ikaw ngani i Kristo a Pinangako nun Makedepat o eyen tangani wet geuluaduwa i esip mi tungkul dikaw.” ");
INSERT INTO due_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tinumubeg i Hisus, “Sinabi ko dikamo misan ay anok yu pan pepanulusonan. I peyedi ko a gepakataka a nappaayun de kabuotan ni Ama ko ay gepamatud tungkul deko. ");
INSERT INTO due_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","An yu buot a nonulusun ta ang kamo kadugeng de topa ko ide. ");
INSERT INTO due_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Peabuyenan ni topa ko ide i surut ko ta peabuyenan ko ide pati geabut ide deko. ");
INSERT INTO due_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Bebiyen ko ide ni edup a an te kalog ta kapide man ay an ide nakkiblag de Makedepat, a an ide náagow ni misan ino de kumot ko. ");
INSERT INTO due_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Talage a ide ay binoy deko ni Ama ko ta eya ay te kapangyedihan pa de pesan kanya am pala ide náagow ni misan ino de kumot ni Ama ko. ");
INSERT INTO due_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ako pati Ama ay isin la.” ");
INSERT INTO due_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Dingan i manga ponu a Hudyo ay liwet a namulut ni beto a pomonglag de tebe diya. ");
INSERT INTO due_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kanya sinabi dide ni Hisus, “Pinakita ko di dikamo i makmuk a pippiyonin a gepakataka a gepo de kapangyedihan ni Ama. Bekot ta bobonglag ok yu? Ti deno i malot de inon ide a yinadi ko?” ");
INSERT INTO due_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tinumubeg ide diya, “Am mi ikaw bobonglag dehil de misan ano a pagyedi a pippiyonin ta dehil la de am mo pegelang i Makedepat ta pesabi mo a ikaw ay kapadepade ni Makedepat misan ay agta ka pan la.” ");
INSERT INTO due_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tinumubeg pala i Hisus, “Ay te duman de kasulatan ni pagdodul ide a peasaan yu i sinabi ni Makedepat a magioyo, ‘Ikamo a manga huwis ko ay manga makedepat’. ");
INSERT INTO due_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nano ay an nappatud a neeyenan ni kabuluhan i surut nun Makedepat kanya be nginalanan ni Makedepat a maginon ide a biniyen na ni surut na ");
INSERT INTO due_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ay an piyon a sasabi yu a anok te gelang de Makedepat dehil de sinabi ko a ako ay Anak nun Makedepat ta pineta ok na a pinakang dio de putok i. ");
INSERT INTO due_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Be ang ko peyedi i pepayedi deko ni Ama ko ay wet kamo manulusun de surut ko. ");
INSERT INTO due_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Misan ay be peyedi ko inon, ti an yu man ponulusonan i surut ko ay depat a ponulusonan yu inon a peyedi ko ta de maginon ay ketinggesan yu, a aabuyenan yu pala a ako pati Ama ay naeisin ngani.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ay i Hudyo ide ay te belak a liwet a dekopin eya misan ay tambing a winalat ide ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ta kinumang a liwet i Hisus de dipa ni Horden de lugel a nun tagibu ay pinaglinoden ni Huwen a Maglilenod ta tinumaan eya duman. ");
INSERT INTO due_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","I kamakmokan ay linumane diya ta pinasurutsurotan de a, “I Huwen ay angani te yinadi a gepakataka misan ay matud i pesan a pagpamatud na tungkul de agta a oyo.” Inon i pinasurutsurotan de ");
INSERT INTO due_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ta duman ay i kamakmokan ay nagpanulusun de Hisus. ");
INSERT INTO due_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Nano ay te isin a lalaki a nagkaorom a i ngalan na ay Lasaro. Eya ay nappataan de benwaan a Betania a ayun ni kabinsa na a ide Maria pati Marta. I Maria i nagpalis ni mabengo pati namunas ni sapok na de singit ni Panginoon. ");
INSERT INTO due_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kanya dehil de orom ni Lasaro ay nagpakang i kabinsa na a mahunain de Hisus a te tutugun a magioyo, “Panginoon, i ayun yu a pebuot ay nagkaorom.” ");
INSERT INTO due_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Misan ay nun inikna ni Hisus inon ay sinabi na, “I orom a oyo ay an paagow de kalebunan na ta nangyeyedi la yo tangani podiin i Makedepat ta dehil pala de oyo ay popodi ok a Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nano ay pebuot ni Hisus i magiwinale a Marta, Maria pati Lasaro ");
INSERT INTO due_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","misan ay pinatakig na pa i aduwa a adow nun mabereta na a nagkaorom i Lasaro. ");
INSERT INTO due_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dingan la sinabi na de mag-aadel na ide, “Umampulang kitam di de Betania a sákup ni Hudia.” ");
INSERT INTO due_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tinumubeg i mag-aadel na ide, “Magtutodu, ay am pa náloy ay binuot ni manga ponu a Hudyo a bobonglag kamo. Ano ta nákang kamo pan di duman?” ");
INSERT INTO due_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sinabi ni Hisus, “Napa de pesan a agta i sangpuwu pati aduwa a odes de maghapon a geyedi ni kabuotan ni Makedepat ta an nassingkug i getotul be adow ta petoplakan ni adow i bektas a pesilan ni agta. ");
INSERT INTO due_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Misan ay nassingkug i getotul be abi ta an diya i salong.” ");
INSERT INTO due_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Maginon i sinabi ni Hisus ta dingan sinabi na pa a, “Nappede di i ayun tam a Lasaro ta noduman ok tangani bogbogin ko eya.” ");
INSERT INTO due_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Sinabi ni mag-aadel na ide, “Panginoon, be nappede pan la eya ay nepiyon ngani.” ");
INSERT INTO due_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nano ay buot ni Hisus a sasabi a nallibun di i Lasaro misan ay inesip ni mag-aadel na ide a nagsurut eya tungkul de pagpede na la. ");
INSERT INTO due_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kanya dehil de an de kinatinggesan i buot na a sasabi ay matanus di a sinabi ni Hisus a, “Nallibun di i Lasaro. ");
INSERT INTO due_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Misan ay yadi pa para dikamo a anok kaduman nun eya ay nagkaorom ta nagkasalig ok di a kekita yu i gepakataka a gepatibong de pagpanulusun yu deko. Hale di. Kumang kitam di diya.” ");
INSERT INTO due_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","I Tomas a nginalanan a kambel ay sinabi na de mangáyun na a mag-aadel, “Sumut kitam diya misan de kalebunan tam.” ");
INSERT INTO due_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pagdetong nide Hisus de benwaan a Betania ay katinggesan de di a apat di a adow i Lasaro de táporan. ");
INSERT INTO due_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","I benwaan a Betania ay tiluwon a kilomitro hanggen de Herusalem. ");
INSERT INTO due_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ta makmuk a Hudyo ay kinumang dide Marta pati Maria tangani ide ay libengin tungkul de kabinsa de a nallibun. ");
INSERT INTO due_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nun inikna ni Marta a gedetong i Hisus ay tinagbu na eya ta i Maria pan ay nawalat la de beloy de. ");
INSERT INTO due_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sinabi ni Marta de Hisus, “Panginoon, be dio kamo tebe ay an nalibun un kabinsa ko ");
INSERT INTO due_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","misan ay katinggesan ko a misan nano ay boboy dikamo ni Makedepat i misan ano a agedin yu diya.” ");
INSERT INTO due_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Sinabi ni Hisus, “Liwet a needup i kabinsa mo.” ");
INSERT INTO due_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tinumubeg i Marta, “Katinggesan ko a eya ay needup a liwet de inapóan a adow a pagkeedup ni kaagtaan.” ");
INSERT INTO due_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Sinabi ni Hisus diya, “Ako i te kapangyedihan a gepakaedup ni nalibunin, a geboy dide ni edup a bowon magpakapide pa man. I misan ino a gepanulusun deko ay misan nalibun di ay pakeedup ko la a liwet. ");
INSERT INTO due_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta i misan ino a te edup a bowon a gepanulusun deko ay an di nakkiblag de Makedepat, magpakapide man. ");
INSERT INTO due_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Peppanulusonan mo man i sinabi ko a oyo?” Tinumubeg eya, “Ay-o, Panginoon, gepanulusun ok a ikamo i Kristo a Anak nun Makedepat a pinakang na dio de putok i.” ");
INSERT INTO due_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pagkasabi na ninon ay inumuli i Marta a kinumang de Maria ta inulit na a, “Wiyo i Magtutodu, pepakang na ikaw duman.” ");
INSERT INTO due_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","30","Nano ay am pa gepakadetong i Hisus de beriyu ta duman pa eya de kinatagbuan diya ni Marta kanya pagkaikna ni Maria ninon a surut ni Marta ay inumuddi eya a tambing ta tinumagbu de Hisus. ");
INSERT INTO due_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ta i Hudyo ide a kakoloy na de beloy, a gelibeng diya ay inumabut ide pala de Maria nun kinta de eya a inumuddi a tambing a tinumotul. Ta pinayin de ay noduman eya de gob a táporan tangani tumangos. ");
INSERT INTO due_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pagdetong ni Maria de kadumanan ni Hisus ay inumobbob eya de singitan na ta sinabi na, “Panginoon, be dio kamo tebe ay an nalibun i kabinsa ko.” ");
INSERT INTO due_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nakalbi i Hisus a masakut a nagulo i innawa na nun kinta na a getangos i Maria pati Hudyo ide a ayun na. ");
INSERT INTO due_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ta tinanto na, “Deno a gob yu eya pinuoy?” Tinumubeg ide, “Dumio kamo di ta pilawagin yu.” ");
INSERT INTO due_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ay napatangos i Hisus. ");
INSERT INTO due_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kanya sinabi ni Hudyo ide, “Pagelawagin yu ta an te kapadepade i pagbuot na de Lasaro.” ");
INSERT INTO due_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Misan ay sinabi ni tipide, “I oyo a agta ay nagpapiyon ni mata ni bulag kanya bekot ta an na nasablow i pagkalibun ni Lasaro?” Inon i sinabi de. ");
INSERT INTO due_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Misan i Hisus ay liwet a nagulo i esip na pagdetong na de kapuoyen ni bengkay. Inon ay gob a nattaklopan ni beto a hanga. ");
INSERT INTO due_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Sinabi ni Hisus, “Layuin yu i beto na.” Tinumubeg i Marta a kabinsa ni nallibun, “Panginoon, nobo di eya nano ta apat di a adow a nalibun.” ");
INSERT INTO due_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Sinabi ni Hisus diya, “Sinabi ko ngani dikaw a be nonulusun ka deko ay kekita mo ti magi ano i kapangyedihan ni Makedepat.” Inon i sinabi na ");
INSERT INTO due_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","dingan linayu de un beto ta nun tinumingala i Hisus ay sinabi na, “Ama, gepasalamat ok dikamo ta peyedi yu i pesan a nappaayun de peaged ko. ");
INSERT INTO due_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Katinggesan ko a ugnay ok yu a pebiyen ni peaged ko ta pesabi ko la yo dehil de agta ide a naddepalebut ko tangani manulusun ide a ikamo i nagdodul deko.” ");
INSERT INTO due_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pagkasabi na ninon ay inumolang eya ni malagdu, “Lasaro, bumulwag ka di.” ");
INSERT INTO due_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ta dingan binumulwag ngani un nallibun a naggulugiptan ni age a pambengkay i kumot pati singit na ide ta nattingos pala ni panyu i mukha na. Sinabi ni Hisus dide, “Ukasán yu eya tangani makatulutotul.” ");
INSERT INTO due_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kanya i makmuk de Hudyo ide a nanlibeng de Maria, a nakakita ni yinadi ni Hisus a gepakataka ay nanulusun ide diya. ");
INSERT INTO due_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Misan ay i tipide dide ay kinumang de Pariseo ide ta binareta de i yinadi ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kanya i ponu ide ni maghahandug ide pati Pariseo ide ay tinipun de i kapolongan ni pinakamatande ni Hudyo ide ta tinanto ide ni nagtipun, “Ano i yeyedi tam nano? Ta i agta a iwina ay makmuk i peyedi na a gepakataka. ");
INSERT INTO due_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Be eya ay pabiyaan tam ay nonulusun diya i pesan pati pan nedio i tage Roma ide ta sesede de i beloy a pighandogen de Makedepat ta aagow de pala i bensa tam.” ");
INSERT INTO due_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Misan ay isin dide i Kaipas a i pinakaponu a maghahandug nun nanon a panahon ay sinabi na i magioyo a, “Kasta ni ang kamo te katinggesan. ");
INSERT INTO due_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Talage a kasta ni an yu katinggesan a ti ano i nagkaddepat nano. Ta yadi pa a isin la a agta i malibun para dikitam pati de bensa tangani an nopuksa i pesan a Hudyo.” ");
INSERT INTO due_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","(Nano ay an yo sinabi ni Kaipas de sadile na a katinggesan ta eya ay pinakaponu a maghahandug nun panahon a inon kanya pinahola diya ni Makedepat a nelibun i Hisus para nunde Hudyo ide. ");
INSERT INTO due_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Misan an la para de Hudyo ide nagpakalibun i Hisus ta tangani tipunin na i pesan a mangának nun Makedepat a nappakálat de putok i.) ");
INSERT INTO due_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nano ay inon ide a te kapangyedihan, gepo nun nanon a adow ay nasurutsurotan a ti papalano a pobuno de i Hisus. ");
INSERT INTO due_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kanya i Hisus ay an di getotul de pekita ni makmuk a agta ta tinumotul di eya duman a paagow de benwaan a Epraim a alane de lugel a ilang. Ta duman eya tinumaan a kakoloy ni mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ay an di naaloy ay kaadowen di ni Hudyo ide a Paskuwa. Makmuk a tage buluberiyu i kinumang de Herusalem dingan ngona nádetong i kaadowen tangani handein de i sadile de a gepodi de Makedepat a nappaayun de ugeli de a Hudyo. ");
INSERT INTO due_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pelawag de i Hisus kanya nun nagpolong ide de beloy a pighandogen de Makedepat ay natulutantoan ide a magioyo a, “Ano i peesip yu? Nedio man eya de kaadowen o eyen?” ");
INSERT INTO due_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nano ay nagdodul i ponu ide ni maghahandug ide pati Pariseo ide a i misan ino a naketingges ni petaanan ni Hisus ay depat a toduin dide tangani mapadekop de eya. ");
INSERT INTO due_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nun anim pa a adow dingan nádetong i kaadowen ni Paskuwa ay dinumatong i Hisus de Betania a benwaan ni Lasaro a pinakaedup na a liwet de nalibunin. ");
INSERT INTO due_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Duman ay pinaghande de eya ni pangapun. Nag-akod i Marta ta i Lasaro ay isin de kasaló ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Dingan i Maria ay nangamit ni isin a oniden a mabengo a langis a mahal a masakut ta pinalis na yo de singit ni Hisus ta pinunasan na ni sapok na ta kinumálat i bengo na de pesan a disalad nun beloy. ");
INSERT INTO due_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Misan i isin de mag-aadel na ide a i Hodes Iskariyote a gepadekop de Hisus ay sinabi na, ");
INSERT INTO due_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bekot ta an peppanggetang iwina a langis a mabengo ta boyin de mahedepin ide i kapanggetangan na a manga aduwa a lebu a peso.” ");
INSERT INTO due_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Misan ay an dehil de eya ay te kalbi de mahedepin ay sinabi na inon ta eya i mag-aalage ni soput ni kuwarta a migpannakow eya duman. ");
INSERT INTO due_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tinumubeg i Hisus, “Pabiyaan yu eya ta yinadi na i paghande na de adow ni pagtapor deko. ");
INSERT INTO due_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ta naaloy yu pa a kakoloy i mahedepin ide misan ay ako ay an yu naaloy a kakoloy dio.” Inon i tubeg na. ");
INSERT INTO due_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nun nabereta ni makmuk a Hudyo a i Hisus ay duman de Betania ay kinumang ide duman misan ay an la dehil de Hisus ta dehil pala de buot de a kekita i Lasaro a pinakaedup na a liwet. ");
INSERT INTO due_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kanya te belak i ponu ide ni maghahandug ide a pobuno de pala i Lasaro ");
INSERT INTO due_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ta dehil diya ay makmuk de Hudyo ide i kinumiblag dide a ponu ta nanulusun de Hisus. ");
INSERT INTO due_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nun kinábiabian ay makmuk i agta a kinumang de kaadowen ta nabereta de a nádetong de Herusalem i Hisus. ");
INSERT INTO due_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kanya nangamit ide ni manga sanga ni kew a makiagid ta tinumotul ide a patagbu diya ta sinabi de a malagdu a magioyo, “Salamat de Pinakamaditas. Podiin eya a Hari ni Israel a gedetong a te kapangyedihan ni Panginoon a Makedepat.” Inon i sinabi de a malagdu. ");
INSERT INTO due_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nano ay sinumakoy i Hisus de an matande a asno a kinta na a magi sinabi ni kasulatan a den, ");
INSERT INTO due_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ikamo a tage benwaan a Herusalem ay wet kamo matakut ta pilawagin yu ta gedetong di i Hari yu a nappasakoy de an matande a asno.” ");
INSERT INTO due_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nano ay nun inon a panahon ay an kinatinggesan ni mag-aadel na ide a hinola inon a nangyedi misan ay nun pinakaedup di a liwet i Hisus ay dingan de naisepan a inon a hinola de kasulatan a tungkul diya ta maginon ngani i nangyedi. ");
INSERT INTO due_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Ay tungkul de kaagtaan a tinumagbu de Hisus ay nabereta de i gepakataka ni Hisus ta nagpamatud dide tungkul de Lasaro i kaagtaan a kinumita nun pabulwagen ni Hisus i Lasaro gepo de pigpuoyen ni bengkay na. ");
INSERT INTO due_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kanya nasurutsurotan i Pariseo ide ta sinabi de a “Ang kitam di te nayeyedi ta pilawagin yu ta nappaabut di diya i pesan a agta.” ");
INSERT INTO due_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nano ay te duman de kamakmokan a kinumang de Herusalem i tipide a Griego a gepodi nunde inon a kaadowen. ");
INSERT INTO due_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Linumane ide de Pilepi a tage Betsaida a sákup ni Galilea ta sinabi de diya, “Be nappatud tebe dikamo ay buot mi a nekisurut de Hisus.” ");
INSERT INTO due_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Sinabi yo ni Pilepi de Andres ta ide a aduwa ay kinumang de Hisus ta pinatingges de i kabuotan ni Griego ide. ");
INSERT INTO due_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tinumubeg i Hisus dide, “Dinumatong di i odes a pepakita i kapangyedihan ko a Pineta nun Makedepat a napa ni agta. ");
INSERT INTO due_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Talage a matud ay pesabi ko dikamo a be an nadegdeg i binhi de putok i a nátapor ay notuloy inon a binhi a lallan misan ay be nátapor yo ay náanak inon a binhi ni makmuk. ");
INSERT INTO due_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Kanya nákanugun i edup ni misan ino a agta a getalinga la de kabuotan na a sadili misan ay nalligtas a te edup a an te kalog eya a neeyenan ni kabuotan na a sadili dio de putok i. ");
INSERT INTO due_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","I misan ino a te buot a getabeng deko ay depat a geabut de ugeli ko ta de nádetong a adow ay náabut ngani i katabeng ko deko de kataanan ni Ama ta bebiyen na ni kapangyedihan na i misan ino a getabeng deko.” ");
INSERT INTO due_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sinabi na a tuloy, “Nano ay gehedep i innawa ko misan ay ang ko sasabi a, ‘Ama, ligtasin ok yu de tetiis ko a oyo,’ ta ako ay dinumio tangani magtiis ok ni oyo a kahedepan. ");
INSERT INTO due_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ama, paabuya yu i makapangyedihan a ngalan yu de pesan a kaagtaan.” Pagkasabi na ninon ay te nagsabi a gepo de langot a magioyo, “Pinakita ko di i kapangyedihan ko de pagyedi mo ta pepakita ko a liwet.” Inon i sinabi a gepo de langot. ");
INSERT INTO due_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nun inikna yo ni kaagtaan a nappaduman ay sinabi ni tipide a linumagpak. Sinabi pan ni kakmukan, “Ay nagsurut diya i isin a anghel.” ");
INSERT INTO due_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Misan ay sinabi ni Hisus, “I surut a inon ay pinaikna dikamo tangani pepatibong i pagpanulusun yu ta an para deko. ");
INSERT INTO due_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ta dinumatong di i odes a pehatolan i kaagtaan dio de putok i ta natalo di pala i ponu ni an gepanulusun ide de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pati be ako ay nappaditas di de padipa ay napálane ko deko i belang te buot a agta.” ");
INSERT INTO due_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sinabi yo ni Hisus tangani mapakita na a ti papalano a eya ay nelibun. ");
INSERT INTO due_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tinumubeg diya un agta ide, “Te duman pan de kasulatan a i Kristo a Pinangako nun Makedepat ay an nelibun magpakapide pa man kanya bekot ta pesabi mo a i Pineta nun Makedepat a napa ni agta ay depat a nappaditas de padipa. Inóman i Pineta nun Makedepat a napa ni agta?” ");
INSERT INTO due_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tinubeg dide ni Hisus i talinghage a oyo a tungkul de sadile na, “Untik dila a panahon a nakkakóloy yu i salong dio kanya maedup kamo ni kamatoden hanggen ayun yu pa i salong tangani ang kamo nappademadumos ta i getotul de madumos ay ugnay a nagkalagelag. ");
INSERT INTO due_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kanya depat pan a ikamo ay manulusun deko a salong hanggen ayun ok yu pa tangani i innawa yu ay gekaduman ni salong.” Pagkasabi ni Hisus ninon ay tinumotul eya duman ta an de kinatinggesan i pinapágowen na. ");
INSERT INTO due_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ta misan kinta ni kaagtaan a nagyedi eya ni makmuk a gepakataka ay am pala ide nagpanulusun diya. ");
INSERT INTO due_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ta de maginon ay nangyedi di i hinola ni magsasabi a den a Isais ta sinabi na, “Panginoon a Makedepat, inikna di ni kaagtaan i surut yu pati pinakita pala dide i kapangyedihan yu misan ay an de buot a gepanulusun dikamo.” ");
INSERT INTO due_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kanya pan an di ide te kaya a gepanulusun ta sinabi pa ni Isais i magioyo a talinghage, ");
INSERT INTO due_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Talage a inabetan di ni Makedepat i mata de ta pinakisa na i innawa de tangani wet ide makakita o makatingges ni kamatoden a makapagsosol tangani ide ay pakeeyenan ni mammalotin de.” ");
INSERT INTO due_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Hinola ni Isais a tungkul de Hisus a maginon ta kinta na ti magi ano a kahanga i kapangyedihan na ta naghola eya tungkul diya. ");
INSERT INTO due_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nano ay makmuk de ponu ide a Hudyo i nagpanulusun diya a misan ay an ide nagpamatud de kakmukan ta nagkatakut ide de Pariseo ide. Ta makati ide ay kiblagin de de pigmitengan ni Hudyo ide. ");
INSERT INTO due_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ta namas pa a te kabuluhan i pagkasalig ni agta dide de pagkasalig ni Makedepat. ");
INSERT INTO due_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nun i Hisus ay nagtodu a liwet ay malagdu a sinabi na a, “I gepanulusun deko ay an la deko gepanulusun ta pati de nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta i kinumita deko ay kinumita pala de nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ako ay dinumatong dio de putok i a magi salong tangani wet gekaduman pa ni madumos a esip i belang gepanulusun deko. ");
INSERT INTO due_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Be geikna i misan ino de surut ko ta dingan an na petalingaan ay ang ko eya hahatolan. Ta anok dinumatong dio tangani gehatol de agta ide ta dinumatong ok a nanleligtas dide. ");
INSERT INTO due_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kanya be an petanggep ni misan ino i surut ko, a gekapoy pala ide deko ay te duman di ide a huwis a i surut ko a nanhahatol dide de inapóan a adow. ");
INSERT INTO due_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ta anok gesurut dehil de sadile ko ta i Ama a nagdodul deko ay eya i gedodul a ti ano i depat a sasabi ko. ");
INSERT INTO due_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ta katinggesan ko a i pagtodu a inumapo de Ama a pesabi ko ay geboy ni edup a an te kalog kanya pan pesabi ko la i pepasabi na deko.” Inon i pagtodu ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nano ay nun isin a adow ay dingan ngona te gepo i kaadowen ni Paskuwa ay kinatinggesan ni Hisus a dinumatong di i panahon a pagtotul na de putok i, a náampulang de Ama. Ta hanggen nun de gepo ay hanga i pagbuot ni Hisus de belang gepanulusun diya dio ta nano ay pepakita na ti hanggen deno a kahanga i pagbuot na dide. ");
INSERT INTO due_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Pati katinggesan ni Hisus a binoy di diya ni Ama i pesan a kapangyedihan. Ta katinggesan na pala a eya ay gepo de Makedepat, a náampulang pala diya. Ta nun nanon pala ay pinaesip ni Satanas de Hodes Iskariyote a anak ni Simon i belak a pagpadekop de Hisus de katalo na ide. Nano ay nun gepangapun i Hisus pati mag-aadel na ide ");
INSERT INTO due_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ay inumuddi i Hisus a nag-ubed ni demit na ta nagbeyakos ni age a pampunas. ");
INSERT INTO due_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ta dingan namalis eya ni orat de palanggena ta ginapoan na a inugesan i singit ni mag-aadel na ide ta pati pinunasan na ni pampunas a nabbeyakos na. ");
INSERT INTO due_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Paglane na de Simon Pedro ay sinabi ni Pedro, “Panginoon, ay an nappatud a ikamo pa i nonguges ni singit ko.” ");
INSERT INTO due_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tinumubeg i Hisus, “Am mo katinggesan nano i oyo a peyedi ko misan ay ketinggesan mo a an naaloy.” ");
INSERT INTO due_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dingan sinabi ni Simon Pedro, “Talage a ang ko pabiyaan a ougesan yu i singit ko ide kapide man.” Tinumubeg i Hisus, “Be am mo pougesan i singit mo deko ay ang ka pa gepakikaisin deko.” ");
INSERT INTO due_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kanya sinabi ni Pedro, “Panginoon, be maginon ay an la i singit ko ta pati kumot pati ulo ko.” ");
INSERT INTO due_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sinabi ni Hisus, “Eyen ta an di kaelangan a ugesan pa i nandiyus di ta malenis di i pesan na a lawes puwide la i singit na misan ay para dikamo ay malenis a sukul i innawa yu puwide la i isin dikamo.” Inon i sinabi na, ");
INSERT INTO due_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ta kinatinggesan ni Hisus ti ino i gepadekop diya kanya sinabi na a “Malenis a sukul i innawa yu puwide la i isin dikamo.” ");
INSERT INTO due_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nano ay nun maugesan di ni Hisus i singit de ay eya ay nagbedu ta inumampulang de piglipaan na ta tinanto na ide, “Katinggesan yu man i buot ko a sasabi de inon a yinadi ko dikamo? ");
INSERT INTO due_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pengalanan ok yu a magtutodu pati Panginoon ta matud kamo ta akod ngan yo. ");
INSERT INTO due_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kanya ti ako a Panginoon yu pati magtutodu ay nagpakita ni masidong a innawa dehil de pag-uges ko de singit yu ay depat kamo pala a mag-ugesan de belang singit yu. ");
INSERT INTO due_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ta biniyen ko ikamo ni halimbewa a inon tangani toladin yu i yinadi ko dikamo. ");
INSERT INTO due_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Talage a matud ay pesabi ko dikamo a i katabeng ay an namas pa a maditas i kapangyedihan na de ponu na pati i dinodul ay am pala namas a maditas i kapangyedihan na de nagdodul diya. ");
INSERT INTO due_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nano ay katinggesan yu di i pagtodu ko kanya pan be yeyedi yu inon ay gekaduman kamo ni kasalegen. ");
INSERT INTO due_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","An tungkul dikamo a pesan i pesabi ko a oyo ta peabuyenan ko i pineta ko ide misan ay depat a mangyedi i sinabi ni kasulatan a, ‘Nappa ni kapagebuk ko i agta a kasaló ko la.’ ");
INSERT INTO due_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Pesabi ko yo dikamo dingan ngona nangyeyedi tangani be nangyedi di ay nonulusun kamo a ako ngani. ");
INSERT INTO due_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Talage a matud ay pesabi ko dikamo a i misan ino a getanggep de agta a dinodul ko ay getanggep pala deko pati pan i getanggep deko ay getanggep pala de nagdodul deko.” ");
INSERT INTO due_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Pagkasabi na ninon ay nagulo i innawa na ta pinamatoden na a “Talage a matud ay pesabi ko dikamo a padekop ok ni isin dikamo.” ");
INSERT INTO due_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ay dingan nasulusalepatan i mag-aadel na ide ta an de katinggesan ti ino dide i pesabi na. ");
INSERT INTO due_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nano ay i mag-aadel a pebuot ni Hisus ay nappalipa de alane na ");
INSERT INTO due_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","kanya hinalimbewaan eya ni Simon Pedro tangani tantoin ni pebuot a mag-aadel i Hisus a ti ino dide i pesabi na. ");
INSERT INTO due_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nun linumane eya de Hisus ay tinanto na, “Panginoon, inóman dikami i pesabi yu?” ");
INSERT INTO due_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Inumulit i Hisus ta tinubeg na, “I agta a pedolo ko ni tinapay a oyo ay eya dingani.” Ta nun madolo di ni Hisus i tinapay ay binoy na de Hodes a anak ni Simon Iskariyote. ");
INSERT INTO due_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nun matanggep di ni Hodes un tinapay ay te kapangyedihan di diya i Satanas dingan sinabi ni Hisus de Hodes, “Yediin mo a mandeli i belak mo a yeyedi.” ");
INSERT INTO due_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nano ay i kakmukan a mag-aadel de kásalo na ide ay an te nakatingges ta ti ano ta sinabi ni Hisus inon diya. ");
INSERT INTO due_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Misan ay katinggesan de a i Hodes i gealáge ni kuwarta kanya inesip ni tipide a mag-aadel a eya ay pepagetang ni Hisus ni pesan a kaelangan de de kaadowen o makati pepapaglimus ni Hisus de mahedepin ide. ");
INSERT INTO due_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kanya nun mapangan di ni Hodes un tinapay ay eya ay tinumotul ta abi di nun nanon. ");
INSERT INTO due_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pagkatotul ni Hodes ay sinabi ni Hisus, “Nano ay ako a Pineta nun Makedepat a napa ni agta ay pepakita ko di i kapangyedihan ko ta dehil deko ay pepakita pala i kapangyedihan ni Makedepat. ");
INSERT INTO due_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ta be dehil deko ay napakita di i kapangyedihan ni Makedepat ay i Makedepat pala i gepakita ni kapangyedihan ko a Anak na ta yeyedi na yo a tambing. ");
INSERT INTO due_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mangának ko a pebuot, untik dila a panahon a nakkakoloy ok yu ta lalawag ok yu misan ay pesabi ko dikamo a magi sinabi ko de manga ponu a Hudyo a ang kamo nakoduman de paagowen ko. ");
INSERT INTO due_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","35","Nano ay isin a bowon a pagdodul i boboy ko dikamo a magbuotan kamo ta ti papalano a binuot ko ikamo ay depat pala a magbuotan kamo tangani aabuyenan ni pesan a ikamo ay mag-aadel ko.” ");
INSERT INTO due_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tinanto eya ni Simon Pedro, “Panginoon deno kamo man paagow?” Tinumubeg i Hisus, “Ay ang ka nakoduman de paagowen ko nano misan ay nakáabut ka deko de naaloy pa a panahon.” ");
INSERT INTO due_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tinanto eya ni Pedro, “Panginoon, ano ta anok nakáabut dikamo nano? Ta para deko ay hinande ko di a gepakalibun para dikamo.” ");
INSERT INTO due_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tinumubeg i Hisus, “Pesabi mo a hinande mo di a gepakalibun para deko misan ay talage a matud ay pesabi ko dikaw a dingan ngona nátaráok i manok ay pengeyen ok mo ni tiluwon a sila.” Inon i sinabi na de Pedro. ");
INSERT INTO due_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Dingan sinabi ni Hisus de pesan a mag-aadel na, “Wet nagkogulo i innawa yu ta magpanulusun kamo a tuloy de Makedepat pati magpanulusun kamo pala a tuloy deko. ");
INSERT INTO due_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta duman de kataanan ni Ama ko ay makmuk a natataanan ta be an maginon ay ang ko sinabi dikamo a noduman ok tangani maghande ok ni natataanan yu. ");
INSERT INTO due_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ta be nakáduman ok di a makapaghande ni natataanan yu ay nedio ok pala a liwet ta eikag ko ikamo de kataanan ko tangani ti deno ok ay duman kamo pala. ");
INSERT INTO due_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ta katinggesan yu ti deno ok paagow pati bektas duman.” ");
INSERT INTO due_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Sinabi diya ni Tomas, “Panginoon, am mi katinggesan ti deno i paagowen yu kanya papalano pan a ketinggesan mi i bektas?” ");
INSERT INTO due_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tinumubeg i Hisus, “Ako i nasesilan a paagow de Ama pati gepo deko i kamatoden pati edup a an te kalog ta an te misan ino a nakoduman de Ama be an de padean ko. ");
INSERT INTO due_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Be ako ay peabuyenan yu ay peabuyenan yu pala i Ama ko. Gepo nano ay peabuyenan yu di eya pati kinta yu di.” ");
INSERT INTO due_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Sinabi diya ni Pilepi, “Panginoon, pakitain yu dikami i Ama ta sukul di inon dikami.” ");
INSERT INTO due_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tinumubeg i Hisus, “Naloy di a kakoloy ok yu, Pilepi, ta kasta ang ka pa te katinggesan tungkul deko ta i nakakita deko ngani ay nakakita pala de Ama kanya wet mo sasabia deko a, ‘Pakitain yu dikami i Ama.’ ");
INSERT INTO due_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Depat a manulusun kamo a ako pati Ama ay naeisin ta i pagtodu a pesabi ko dikamo ay an inumapo deko ta i Ama a gepakikaisin deko ay gepayedi deko ni pagyedi na. ");
INSERT INTO due_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kanya depat ngani a manulusun kamo a ako pati Ama ay naeisin. Misan be ang kamo nonulusun de inon a sinabi ko ay manulusun kamo tebe dehil de pagyedi ko a gepakataka. ");
INSERT INTO due_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Talage a matud ay pesabi ko dikamo a i nonulusun deko ay nakayedi ni magi pagyedi ko ta nakayedi pala eya a namas pa de inon a pagyedi ko dehil de noduman ok di de Ama. ");
INSERT INTO due_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ta misan ano i agedin yu de Ama de makapangyedihan a ngalan ko ay inon i yeyedi ko tangani dehil deko a Anak ay pepakita i kapangyedihan ni Ama. ");
INSERT INTO due_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Talage a yeyedi ko i misan ano a agedin yu de makapangyedihan a ngalan ko.” ");
INSERT INTO due_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sinabi ni Hisus a tuloy, “Nano ay be pebuot ok yu ay depat a petalingaan yu i pagtodu ko. ");
INSERT INTO due_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Ta nánalangin ok de Ama tangani ikamo ay bebiyen na ni magtatabeng a i Ispiritu a getodu dikamo ni kamatoden ta eya i kalewes ko a nappa ni kakoloy yu magpakapide pa man. An petanggep eya ni an gepanulusun ide de Makedepat dio de putok i ta an de peabuyenan eya o katinggesan man. Misan ikamo pan ay peabuyenan yu eya ta nappakoloy eya dikamo ta de an naaloy ay getaan di a tuloy dikamo. ");
INSERT INTO due_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ang ko ikamo wawalat a magi lubus ta naampulang ok dikamo. ");
INSERT INTO due_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Untik dila a panahon ay anok di kekita ni an gepanulusun ide dio de putok i. Misan ay kekita ok yu ta dehil de ako ay te edup a an te kalog ay ikamo pala ay te edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta de adow a inon ay katinggesan yu ngani a ako ay gepakikaisin de Ama pati naeisin kitam pala. ");
INSERT INTO due_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Talage i getanggep de pagtodu ko a getalinga pala ay eya i gebuot deko. Ta i gebuot deko ay pebuot pala ni Ama ko pati pebuot ko pala eya ta gepaabuya ok diya a matud.” ");
INSERT INTO due_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Pagkasabi ni Hisus ninon ay tinanto eya ni Hodes a am pan i Iskariyote ta sinabi na, “Panginoon, ano pan ta dikami kamo la gepaabuya a masakut ta an de kaagtaan dio de putok i?” ");
INSERT INTO due_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tinumubeg i Hisus, “I gebuot deko ay getalinga de surut ko ta eya ay pebuot ni Ama ko ta ikami ay nakoloy diya a getaan a tuloy pala, ");
INSERT INTO due_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","misan i an gebuot deko ay an getalinga de surut ko. Nano ay i surut ko a inikna yu ay an inumapo deko ta de Ama a nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Pesabi ko dikamo i magioyo a pesan hanggen kakoloy ok yu pa ");
INSERT INTO due_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","misan ay i magtatabeng a i Ispiritu nun Makedepat a dododul ni Ama de makapangyedihan a ngalan ko ay eya ngani i getodu dikamo ni pesan pati gepaesip eya ni pesan a sinabi ko dikamo. ");
INSERT INTO due_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nano ay i kasampatan a innawa a paaged i wawalat ko dikamo ta an yo magi peboy ni ugeli dio de putok i. Wet magulo i innawa yu pati wet kamo matakut. ");
INSERT INTO due_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Inikna yu di i sinabi ko a ‘Ako ay nototul pati náampulang pala.’ Kanya dehil de pagbuot yu deko ay depat a masalig kamo a ako ay paagow de Ama ta namas pa i kapangyedihan ni Ama de kapangyedihan ko a Anak na. ");
INSERT INTO due_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ta dingan ngona nangyedi i pagtotul ko ay sinabi ko dikamo inon tangani be nangyedi di a pesan ay manulusun kamo deko. ");
INSERT INTO due_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nano ay anok di gesurut dikamo ni naaloy pa ta gedetong di i Satanas a eya a te kapangyedihan de kaagtaan dio de putok i misan ay an eya te kapangyedihan deko a unabis. ");
INSERT INTO due_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ta i peyedi ko ngani ay i nappaayun de pedodul ni Ama ta depat a matinggesan ni kaagtaan dio de putok i a pebuot ko i Ama.” Inon i pagtodu ni Hisus ta dingan sinabi na, “Hale di, ta tol di.” ");
INSERT INTO due_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Nun getotul ide ay tinodu ni Hisus dide i talinghage a magioyo, “Ako i matud a lanut ta i Ama ko i mag-aalage ni lanut. ");
INSERT INTO due_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","I belang sanga a nappakitad deko a an gepinag-anak ay pepugtus a pebut pala ni Ama ta i sanga pan a gepinag-anak ay pelenis na tangani namas a umanak ni makmuk. ");
INSERT INTO due_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ikamo ay malenis de innawa yu dehil de surut a sinabi ko dikamo. ");
INSERT INTO due_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Depat a ugnay kamo a magpakikaisin deko ta maginon pala ay gepakikaisin ok dikamo. Ta ti papalano a i sanga ay an náanak be an nappakitad de lanut ay maginon kamo pala ay an náanak be ang kamo gepakikaisin deko. ");
INSERT INTO due_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ako i lanut, ikamo i manga sanga ta be naeisin kitam ay ikamo i náanak ni makmuk ta ang kamo te nayeyedi be napakiblag kamo deko. ");
INSERT INTO due_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","I an gepakikaisin deko a tuloy ay bobut eya a magi sanga a pinugtus di a narango ta inon ide a narango ay tetipun a wewitik de apoy a nosunug. ");
INSERT INTO due_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Misan pan be gepakikaisin kamo deko a tuloy, a getalinga pala de surut ko ay dingan agedin yu i misan ano a buot yu ta boboy ko dikamo. ");
INSERT INTO due_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ta be ikamo ay gepinag-anak ni makmuk ay pepakita di i kapangyedihan ni Ama ko ta de maginon pala ay napamatoden a ikamo ay mag-aadel ko a matud. ");
INSERT INTO due_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ta ti papalano a pebuot ok ni Ama ay maginon pala pebuot ko ikamo kanya be getalinga kamo deko ay gekaduman kamo ni pagbuot ko. ");
INSERT INTO due_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ta ti papalano a getalinga ok de pagdodul ni Ama ko a gekaduman ok ni pagbuot na ay maginon pala a gekaduman kamo ni pagbuot ko be getalinga kamo de pagdodul ko. ");
INSERT INTO due_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Pesabi ko dikamo i pesan a oyo tangani makabinsa ko ikamo de kasalegen ko a te kasalegen pa a masakut. ");
INSERT INTO due_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Nano i oyo i pagdodul ko a magbuotan kamo a magi pagbuot ko dikamo. ");
INSERT INTO due_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ta pepakita ni agta i pagbuot na a hanga be gepakalibun eya para de mangáyun na ta an te kapadepade de maginon a pagbuot. ");
INSERT INTO due_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kanya ikamo pala ay pepakita yu a ikamo ay mangáyun ko be getalinga kamo de pagdodul ko. ");
INSERT INTO due_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ang ko di ikamo ngangalanan a katabeng ta an pepatingges ni ponu de katabeng na i belak na misan ay pengalanan ko ikamo a mangáyun ko ta pepatingges ko dikamo i pesan a inikna ko de Ama ko. ");
INSERT INTO due_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Misan pan ay an ikamo i nagpeta deko ta ako i nagpeta dikamo ta pepakang ko ikamo a gepinag-anak ni piyon a pagyedi ta dingan an na kanungun i pagel yu. Pati misan ano i agedin yu de Ama de makapangyedihan a ngalan ko ay boboy na dikamo. ");
INSERT INTO due_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kanya i oyo dila i pedodul ko dikamo a magbuotan kamo. ");
INSERT INTO due_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nano be kagengsaan ikamo ni kaagtaan dio de putok i ay depat a matinggesan yu a ako ngona i kagengsaan de. ");
INSERT INTO due_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ta halimbewa be ikamo ngani ay kapadepade de, a an gepanulusun ay bobuot de ikamo misan ay ang kamo ngani kapadepade dide ta pineta ko ikamo gepo dide kanya kagengsaan de ikamo. ");
INSERT INTO due_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Esipin yu i sinabi ko dikamo a ‘I katabeng ay an namas pa a maditas i kapangyedihan na de ponu na.’ Kanya be ako ay pepahedepan de ay pehedepan de pala ikamo pati be petalingaan de i surut ko ay petalingaan de pala i surut yu. ");
INSERT INTO due_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Misan ay katinggesan yu a pehedepan de ikamo dehil de pagpanulusun yu deko ta an de peabuyenan i nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Be anok tebe dinumio de putok i a nagsabi dide ni kamatoden ay an di tebe pinakita i kasalanan de misan ay nano ay an ide te dehilan a sasabi a an ide te kasalanan. ");
INSERT INTO due_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","24","Talage a an tebe ide te kasalanan be anok nagyedi de pekita de ni makmuk a gepakataka a am pa nayedi ni misan ino. Misan ay nano ay kinta de di i yinadi ko ta kinagengsaan ok de pati Ama ko ta i nagkagengsa deko ay nagkagengsa pala de Ama ko. ");
INSERT INTO due_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kanya de maginon ay nangyedi di i hinola de kasulatan a peasahan de a magioyo a ‘Pagkagengsaan ok de a an te kasalanan.’ ");
INSERT INTO due_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Misan ay nádetong i magtatabeng a gepo de Ama ko a i Ispiritu a getodu dikamo ni kamatoden. I eya ay dododul ko a gepo de Ama ta gepamatud eya dikamo tungkul deko. ");
INSERT INTO due_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ta gepamatud kamo pala a tungkul deko ta nunde gepo pa ay ikamo ay ayun ko di. ");
INSERT INTO due_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nano ay nagsabi ok dikamo ni oyo tangani wet maeyen i pagpanulusun yu deko dehil de kahedepan. ");
INSERT INTO due_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ta pati pototul de ikamo de pigmitengan de. Talage a nádetong i panahon a i misan ino a nomuno dikamo ay peesip na a eya ay gepakatabeng de Makedepat. ");
INSERT INTO due_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ta geyedi ide ni oyo dehil de anok de peabuyenan pati Ama. ");
INSERT INTO due_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","I oyo ay pesabi ko dikamo tangani pagdetong ni odes a pepahedepan de ikamo ay nappahande i innawa yu ta sinabi kod yo dikamo. “Nano ay anok nagsabi dikamo ni oyo nun tagibu pa a pagiinayun tam ta kakoloy ok yu. ");
INSERT INTO due_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Misan nano ay noduman ok di de nagdodul deko. Malungkut kamo ngani a masakut dehil de pesabi ko a nototul ok misan ay bekot ta an te getanto deko isin man dikamo a ‘Ti deno kamo paagow?’ ");
INSERT INTO due_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Misan ay patalikngan yu i oyo a sasabi ko a kamatoden a tungkul de pagtotul ko ta namas pa a piyon para dikamo a ako ay nototul ta dingan pakang ko dikamo i magtatabeng a i Ispiritu ta be anok nototul ay an nedio i magtatabeng. ");
INSERT INTO due_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ta pagdetong na ay pamatoden na de kaagtaan dio de putok i, a ti ano i mammalotin de pati tungkul deko a kapiyonan ni Makedepat pati i pagpadusa na. ");
INSERT INTO due_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Talage a pamatoden na a tungkul de mammalotin de a an ide gepanulusun deko. ");
INSERT INTO due_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Pati pamatoden na a ako ngani i kapiyonan ni Makedepat ta dehil de inon ay noduman ok de Ama, ta anok yud kekita. ");
INSERT INTO due_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Pati pan pamatoden na a tungkul de pagpadusa ni Makedepat ta hinatolan di i Satanas a ponu dio de putok i. ");
INSERT INTO due_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Te makmuk ok pa a sasabi dikamo misan an yu pa kaya a ketinggesan nano. ");
INSERT INTO due_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pagdetong nun Ispiritu a getodu ni kamatoden ay tatabengan na ikamo tangani matinggesan yu i pesan a kamatoden. Ta an eya te sasabi a geapo de sadile na ta sasabi na la dikamo i inikna na de Ama a i pesan a nangyeyedi a nádetong. ");
INSERT INTO due_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pepapodian ok na ta náapo deko i totodu na dikamo. ");
INSERT INTO due_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Talage a i pesan a kamatoden a nade Ama ay deko pala kanya sinabi ko a deko náapo i totodu dikamo ni Ispiritu.” ");
INSERT INTO due_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sinabi ni Hisus a tuloy i oyo a talinghage, “Untik dila a panahon ay anok yud kekita ta pagkasila ni untik pa a panahon ay kekita ok yu a liwet.” ");
INSERT INTO due_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nasurutsurotan i tipide a mag-aadel na, “Ano man i buot na a sasabi nun sinabi na dikitam a ‘Untik dila a panahon ay anok yud kekita ta pagkasila ni untik pa a panahon ay kekita ok yu a liwet.’ Ta sinabi na pala a ‘Dehil de inon ay noduman ok de Ama.’ ");
INSERT INTO due_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ano man i buot na a sasabi de ‘Untik dila a panahon.’ Talage a an tam yo katinggesan.” ");
INSERT INTO due_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Misan ay katinggesan ni Hisus a buot de a getanto kanya sinabi na dide, “Natulutantoan kamo a ti ano i buot ko a sasabi de ‘Untik dila a panahon ay anok yu kekita ta pagkasila ni untik pa a panahon ay kekita ok yu a liwet.’ ");
INSERT INTO due_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Talage a matud ay pesabi ko dikamo a de untik dila a panahon ay nátangos kamo pati gehedep i innawa yu misan ay násalig i gekapoy deko dio de putok i. Malungkut kamo ngani a masakut misan i lungkut yu ay nappa ni kasalegen. ");
INSERT INTO due_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ta halimbewa be gebetyag di i isin a mahuna de panganak na ay nagkapatangos eya ta gedetong di i odes ni paghedep na misan be nakapanganak di ay an na di nagkaisepan i paghedep na ta nagkasalig dehil de pinanganak na di i isin a anak dio de putok i. ");
INSERT INTO due_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Maginon kamo pala nagkolungkut nano misan ay liwet a gepakita ok dikamo ay dingan hanga a masakut i kasalegen yu a an nabobut ni misan ino de innawa yu. ");
INSERT INTO due_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nano ay de adow a nádetong ay ang kamo di te kaelangan a geaged deko tungkul de misan ano ta talage a matud ay pesabi ko dikamo a misan ano i agedin yu de Ama de makapangyedihan a ngalan ko ay boboy na dikamo. ");
INSERT INTO due_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hanggen nano ay ang kamo pa geaged diya ni misan ano de makapangyedihan a ngalan ko kanya umaged kamo ta ikamo ay bebiyen tangani te kasalegen kamo pa a masakut. ");
INSERT INTO due_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“I oyo ide ay sinabi ko dikamo de talinghage misan ay nádetong i adow a anok gesurut dikamo ni talinghage ta madisapow a sasabi ko dikamo i tungkul de Ama. ");
INSERT INTO due_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","De adow a nádetong ngani ay geaged kamo diya de makapangyedihan a ngalan ko ta an di kaelangan a nanalangin ok de Ama para dikamo. ");
INSERT INTO due_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ta pebuot kamo ngani ni Ama dehil de pagbuot yu deko pati pagpanulusun yu a ako ay gepo diya. ");
INSERT INTO due_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Talage a gepo ok de Ama a dinumio de putok i ta nano pan ay nototul ok di de putok i, a náampulang ok de Ama.” ");
INSERT INTO due_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Sinabi diya ni mag-aadel na ide, “Nano ngani ay madisapow di i pagsurut yu dikami ta an di de talinghage. ");
INSERT INTO due_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nano ay katinggesan mi di a katinggesan yu i pesan ta misan ang kami nagtanto dikamo ay katinggesan yu i nadeinnawa mi kanya dehil de pagkatingges yu ninon a nadeinnawa mi ay gepanulusun kami a ikamo ay gepo de Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tinumubeg i Hisus dide, “Wet yu sabia a tambing a gepanulusun kamo deko. ");
INSERT INTO due_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ta nádetong i odes, a nano dingani, a nakálat kamo a paagow de belang beloy yu ta wawalat ok yu a lallan misan ay anok lallan ta i ayun ko ay i Ama ko. ");
INSERT INTO due_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Pesabi ko yo dikamo tangani magkaduman kamo ni kasampatan a innawa dehil de pagpakikaisin yu deko ta te duman kamo a kahedepan dio de putok i. Misan ay patibongin yu i innawa yu ta nanalo ok di de te kapangyedihan dio de putok i.” ");
INSERT INTO due_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkatapos ni Hisus ni pagsurut a inon ay tinumingala eya de langot ta nagpanalangin eya a magioyo, “Ama, dinumatong di i odes a pepakita yu i kapangyedihan ko a Anak tangani mapakita ko a Anak i kapangyedihan yu. ");
INSERT INTO due_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ta biniyen ok yu di ni kapangyedihan yu de pesan a kaagtaan tangani makapagboy ok ni edup a an te kalog de pesan a agta a binoy yu deko. ");
INSERT INTO due_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Talage a be peabuyenan ni kaagtaan a ikamo ay isin la a matud a Makedepat pati ako a Hisu Kristo a dinodul yu ay te edup ide ngani a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pinakita ko dio de putok i i kapangyedihan yu. Natapos ko di i pepayedi yu deko. ");
INSERT INTO due_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nano, Ama, pagdetong ko de kalane yu a liwet ay boyin yu pan di deko i kapangyedihan ko a nappadeko nun ako ay kalane yu dingan ngona yinadi i putok i. ");
INSERT INTO due_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pinaabuya ko ikamo de agta a binoy yu deko gepo de putok i. Ide ay mangának yu a binoy yu deko a pealagean ko ta tinumalinga ide de surut yu. ");
INSERT INTO due_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ta nano ay katinggesan de a i gepakataka pati pagtodu a binoy yu deko ay gepo dikamo. ");
INSERT INTO due_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ta tinodu ko dide a pesan i pesan a surut a tinodu yu deko ta tinanggep de pan. Ta katinggesan de a talage a ako ay inumapo dikamo ta gepanulusun ide a ikamo i nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Peppanalangin ko inon ide, a an i gekapoy ide de kamatoden dio de putok i ti an i pesan a binoy yu deko ta ide ay dikamo. ");
INSERT INTO due_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ta i pesan a deko ay dikamo ta i pesan a dikamo ay deko ta dehil de gepanulusun deko ay pepakita de i kapangyedihan ko. ");
INSERT INTO due_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nano, Ama a makapangyedihan, ay nákang ok di dikamo a nototul ok dio de putok i. Kanya dehil de makapangyedihan a ngalan yu ay alagean yu i pesan a binoy yu deko a naddeputok pa i tangani ide ay nappa ni naeisin a magi ikitam ay naeisin. ");
INSERT INTO due_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta nun ako ay kakoloy de ay dehil de kapangyedihan ni ngalan yu ay inalagean ko ide a binoy yu deko. Inalagean ko ide ta i misan isin dide ay an nopuksa puwide la i isin a nákang de padusa na ta inon i hinola ni kasulatan a pinasolat yu. ");
INSERT INTO due_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Misan ay mandeli ok di a nákang dikamo kanya pepanalangin ko yo hanggen dio ok pa de putok i tangani ide ay te kasalegen a magi kasalegen ko. ");
INSERT INTO due_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tinodu ko dide i surut yu ta pagkagengsaan ide ni kaagtaan ide dio de putok i ta ide a binoy yu deko ay an ide nagkeedup a nappaayun de ugeli dio de putok i a magi ako. ");
INSERT INTO due_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ang ko peaged a layuin yu ide dio de putok i ta pepanalangin ko a ligtasin yu ide de kapangyedihan ni Satanas. ");
INSERT INTO due_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Talage a an di ide nagkeedup a nappaayun de ugeli dio de putok i a magi ako. ");
INSERT INTO due_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ama, i surut yu ay kamatoden kanya de padean ninon a surut yu ay bukudin yu i gepanulusun ide deko tangani geabut ide dikamo. ");
INSERT INTO due_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ta ti papalano a dinodul ok yu dio de putok i ay maginon pala dododul ko ide de kaagtaan dio de putok i, ");
INSERT INTO due_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ta dehil dide ay hinande ko di a gepakalibun para dide tangani peboy de pala a matud dikamo i edup de. ");
INSERT INTO due_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“An la ide i peppanalangin ko ta pati i pesan a nonulusun deko magpakapide man dehil de pagpamatud de tungkul deko. ");
INSERT INTO due_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta peppanalangin ko pala a ide a pesan ay naeisin a magi ikitam, Ama, ay naeisin ta buot ko a ide a pesan ay gepakikaisin dikitam tangani manulusun i kaagtaan dio de putok i a ikamo i nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","I kapangyedihan a binoy yu deko ay binoy ko dide tangani ide ay naeisin a magi ikitam ay naeisin. ");
INSERT INTO due_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ako ay gepakikaisin dide ta ikamo ay gepakikaisin deko tangani ide ay naeisin a matud. Ta de maginon pala ay aabuyenan ni kaagtaan dio de putok i a dinodul ok yu pati katinggesan ni kaagtaan a pesan a pebuot yu pala i manga gepanulusun a magi pagbuot yu deko. ");
INSERT INTO due_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ama, buot ko a nakkakoloy de kadumanan ko i pesan a binoy yu deko tangani kitain de i kapangyedihan ko a i kapangyedihan a binoy yu deko ta ako ay pebuot yu dingan ngona yinadi i putok i. ");
INSERT INTO due_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Piyon a Ama, ang kamo peabuyenan ni kaagtaan dio de putok i misan ay peabuyenan ko ikamo a masakut ta katinggesan ni binoy yu ide deko a ikamo i nagdodul deko. ");
INSERT INTO due_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ta pinaabuya ko ikamo dide ta paabuya ko pa tangani i pagbuot yu deko ay mapa de innawa de ta ako pan ay gepakikaisin dide.” ");
INSERT INTO due_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nano ay nun pagkatapos ni Hisus ninon a pagpanalangin ay tinumotul ide pati mag-aadel na ide ta kinumang ide de dipa ni Orat a Kedron ta sinumilong ide de isin a kahardinan duman. ");
INSERT INTO due_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","I lugel a inon ay katinggesan ni Hodes a gepadekop de Hisus ta ugnay a geduman i Hisus pati mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kanya nun duman di ide Hisus ay dinumatong i Hodes a ayun na i tipide a magbebentay nunde beloy a pighandogen de Makedepat pati isin a bunglo a sundelo a pinakang ni ponu ide ni maghahandug ide pati Pariseo ide. Ta ide a dinumatong ay te manga adde ni salong pati utak. ");
INSERT INTO due_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Misan ay katinggesan ni Hisus i pesan a nangyeyedi diya kanya tinagbu na ide a tinanto na ide, “Inóman i pelawag yu?” ");
INSERT INTO due_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tinumubeg ide, “I Hisus a tage Nasarit.” Dingan sinabi na, “Akod yo.” Pagsabi na ninon ay nappauddi i Hodes a kakoloy ni manga gedekop ide diya ");
INSERT INTO due_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","misan nun sinabi ni Hisus a, “Akod yo,” ay napaórong ide a napaide pala de putok. ");
INSERT INTO due_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tinanto na ide a liwet, “Inóman a talage i pelawag yu?” Tinumubeg ide, “I Hisus a tage Nasarit.” ");
INSERT INTO due_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Sinabi ni Hisus, “Sinabi ko dikamo a ‘Akod yo,’ kanya be ako i pelawag yu ay pabiyaan yu ngona a makatotul i agta ide a oyo.” ");
INSERT INTO due_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sinabi na yo tangani te nangyedi di i surut na a an te nalagelag misan isin dide, a binoy diya ni Ama. ");
INSERT INTO due_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nano ay i Simon Pedro ay nangugnus ni utak na ta tinigbes na i isin a katebeng ni pinakaponu a maghahandug. Ta nasapsap i awenan a talinga ni katabeng a inon a i ngalan na ay Malko. ");
INSERT INTO due_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sinabi ni Hisus de Pedro, “Kalobenin mo i utak mo na ta depat ko a tatanggep i kahedepan a peboy deko ni Ama ko.” ");
INSERT INTO due_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ta dingan i magbebentay ide a Hudyo pati sundelo ide, dehil de pagdodul ni kapitan de, ay dinakop a ginapus de i Hisus. ");
INSERT INTO due_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Eya ay inadde de ngona de Anas a pinakaponu a maghahandug a den ta eya ay panuwangan ni Kaipas a pinakaponu a maghahandug nun inon a panahon. ");
INSERT INTO due_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","I Kaipas i nagsabi de manga ponu a Hudyo a yadi pa a i isin dila a agta i malibun para de pesan a kaagtaan. ");
INSERT INTO due_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Nano ay i Simon Pedro pati isin pa a mag-aadel ay inumabut de Hisus. Peabuyenan pan ni pinakaponu a maghahandug inon a mag-aadel kanya nakasilong eya a ayun ni Hisus de disalad ni bekoran ni pinakaponu a maghahandug. ");
INSERT INTO due_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nawalat pan i Pedro de ditow ni pintohan ni bekod kanya binumulwag i mag-aadel a peabuyenan ni pinakaponu a maghahandug ta pinagsabian ninon a mag-aadel i maddikit a bentay de pintohan. Dingan pinasilong ni mag-aadel i Simon Pedro. ");
INSERT INTO due_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pagkasilong na ay tinanto i Pedro ninon a maddikit, “Kasta isin ka pala a mag-aadel ni agta a iwina?” Tinumubeg i Pedro, “Eyen.” ");
INSERT INTO due_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nano ay magidnaw nun nanon kanya naggetong ni usang i manga katabeng ide pati bentay ide ta kauluuddi ide de palebut na tangani nanangdeng ta i Pedro pala ay nakiuddi a nanangdeng. ");
INSERT INTO due_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","I Hisus pan ay petanto ni Anas a pinakaponu a maghahandug a den a tungkul de mag-aadel na ide pati de pagtodu na. ");
INSERT INTO due_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tinumubeg i Hisus diya, “Nagsurut ok de peikna ni kamakmokan ta ang ko tinagu i pagtodu ko. Talage a nagtodu ok a ugnay de pigmitengan tam ide pati de beloy a pighandogen de Makedepat a pigpolongan ni manga Hudyo. ");
INSERT INTO due_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kanya wet ok yu tantoa ta i tantoin yu ay i geikna na ide deko ta katinggesan de i sinabi ko.” ");
INSERT INTO due_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nun pagkasabi na ni maginon ay tinampal i Hisus ni isin de magbebentay ide a nappauddi de alane na ta sinabi na, “Wet mo petubege ni maginon i pinakaponu a maghahandug.” ");
INSERT INTO due_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tinumubeg i Hisus diya, “Be gesurut ok ni an matud ay pamatoden mo misan ay be matud pan i pesabi ko ay bekot ta tinampal ok mo?” ");
INSERT INTO due_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pagkatapos ninon ay ginapus de pa i Hisus ta pinaadde ni Anas de Kaipas a pinakaponu a maghahandug. ");
INSERT INTO due_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nano ay i Pedro pan ay nappauddi pa duman a gepanangdeng. Tinanto eya ni tipide, “Kasta isin ka pala de mag-aadel na ide?” Sinabi ni Pedro, “Eyen.” ");
INSERT INTO due_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Te duman pa a isin a katabeng ni pinakaponu a maghahandug a mangáyun pan nun tinigbes ni Pedro a nasapsap i talinga na ta tinanto na, “Amman ikaw un kinta ko a ayun ni agta a iwina de kahardinan?” ");
INSERT INTO due_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Liwet a pinangeyen ni Pedro ta tambing pan a tinumaráok un manok. ");
INSERT INTO due_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nun mandeli di a adow ay gepo de beloy ni Kaipas ay inikag de i Hisus de beloy a hanga ni Gubernador a tage Roma. Misan i Hudyo ide ay an ide sinumilong de beloy nun Gubernador a an Hudyo. Ta gepo de ugeli de ay inesip de a ide ay nappa ni an malenis de pekita ni Makedepat be nálane ide de an Hudyo dingan an nappatud dide a námangan ide ni pangapun ni Paskuwa. ");
INSERT INTO due_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nano ay i Pilato a Gubernador ay binumulwag de beloy na a petanto na ide a, “Anóman i sumbong yu de agta a oyo?” ");
INSERT INTO due_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tinumubeg ide, “Be an tebe te yinadi a malot i agta a iwina ay am mi tebe inikag dio dikamo.” ");
INSERT INTO due_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sinabi dide ni Pilato, “Layuin yu eya dio ta hatolan yu a nappaayun de pagdodul yu.” Tinumubeg un manga ponu a Hudyo, “Ay katinggesan yu pan a ang kami te kapangyedihan a gehatol de misan ino ni kalebunan de.” (Inon i sinabi de, ");
INSERT INTO due_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ta de maginon ay nangyedi di i surut ni Hisus nun sinabi na a ti papalano i padean ni pagkalibun na.) ");
INSERT INTO due_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nano ay pagkasilong ni Pilato de beloy na ay pinakangan na i Hisus ta tinanto na eya, “Ikaw man i hari ni Hudyo ide?” ");
INSERT INTO due_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tinumubeg i Hisus, “Iwina man ay inumapo de sadile yu a esip o te nagbereta dikamo a tungkl deko?” ");
INSERT INTO due_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Sinabi ni Pilato diya, “Talage a te nagbereta deko ta anok yo Hudyo ta i tage dio pala ide de bensa mo pati i ponu ide ni maghahandug ide i nangikag dikaw dio. Anóman i yinadi mo a malot?” ");
INSERT INTO due_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tinumubeg i Hisus, “I pagkahari ko ay an gepo de kaagtaan dio de putok i ta be maginon ay nekilaben para deko i manga mag-aadel ko ide tangani wet ok di maadde de kapangyedihan ni manga ponu a Hudyo. Talage a i pagkahari ko ay an gepo de kaagtaan dio de putok i.” ");
INSERT INTO due_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sinabi ni Pilato, “Be maginon ay kasta hari ka.” Tinumubeg i Hisus, “Ikamo di i gesabi a ako ay hari ta dehil de pagsabi ko ni kamatoden ay dinumatong ok a pinanganak dio de putok i. Ta i pesan a te pagbuot de kamatoden ay getalinga de surut ko.” ");
INSERT INTO due_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tinanto eya ni Pilato, “Ano i buot mo a sasabi de surut a, ‘i kamatoden?’” Pagkatanto na ninon ay binumulwag i Pilato ta sinabi na de manga ponu a Hudyo, “Anok te depat a panhahatolan de agta a oyo. ");
INSERT INTO due_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Misan ay nappaayun de ugeli yu ay depat ok a magpabulwag ni isin a nabbilanggo de kaadowen ni Paskuwa. Buot yu man a pabulwagen ko dikamo i Hari ni Hudyo ide?” Inon i tanto ni Pilato. ");
INSERT INTO due_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ta dingan tinumubeg ide diya a malagdu a surut, “Am mi buot iwina a agta ta i Barabás pan i pabulwagen yu.” Inon i tubeg de ta i Barabás pan ay tulisan a migbuno. ");
INSERT INTO due_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kanya pinaikag ni Pilato i Hisus de beloy na a pinalapdit na eya. ");
INSERT INTO due_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Un sundelo ide ay nagyedi ni suklong a tinik a sinuklong de de Hisus pati kinulapyawen de eya ni mulumaderag a magi kulapyaw ni hari. ");
INSERT INTO due_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dingan ide ay linumane diya a sinabi de, “Maedup ka, Hari ni Hudyo ide.” Ta pagkasabi de ninon ay tinulutampal de eya. ");
INSERT INTO due_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Misan ay binumulwag a liwet i Pilato ta sinabi na de Hudyo ide de bekoran na, “Pagelawagin yu ta eikag ko di eya de kasagkaden yu na tangani matinggesan yu a anok te depat a panhahatolan diya.” ");
INSERT INTO due_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kanya pagkabulwag ni Hisus a te suklung ni tinik pati kulapyaw a mulumaderag ay sinabi dide ni Pilato, “Pagelawagin yu, wiyo i agta.” ");
INSERT INTO due_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nano ay pagkákita diya nun ponu ide ni maghahandug ide pati magbebentay ide ay nagiinolang ide a, “Pakuin yu eya de padipa. Pakuin yu de padipa.” Misan sinabi dide ni Pilato, “Amitin yu eya ta ikamo i magpaku diya de padipa ta anok te depat a panhahatolan diya.” ");
INSERT INTO due_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tinumubeg diya un manga ponu a Hudyo, “Ikami a Hudyo ay te pagdodul ta nappaayun de inon ay depat a eya ay malibun ta pesabi na a eya ay Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nano ay nun inikna ni Pilato inon a surut ay namas di a natakut eya. ");
INSERT INTO due_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kanya liwet a sinumilong i Pilato de beloy na ta tinanto na i Hisus a magioyo, “Tage deno ka man?” Misan ay an di tinumubeg i Hisus diya. ");
INSERT INTO due_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kanya sinabi diya ni Pilato, “Bekot ta ang ka gepakisurut deko? An yu man katinggesan a te kapangyedihan ok a magpaukas o magpapaku dikamo de padipa?” ");
INSERT INTO due_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tinumubeg i Hisus a liwet, “Ang kamo te kapangyedihan a magpapaku deko de padipa be an non nappaayun de kabuotan ni Makedepat. Kanya namas pa a hanga i kasalanan ni nangadde deko de kasagkaden yu i.” ");
INSERT INTO due_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Talage a nun ikikna yo ni Pilato ay namas di a buot na a poukasan i Hisus misan ay nagiinolang un manga Hudyo a magioyo, “Be iwina a agta aypoukasan yu ay ang kamo katabeng a matud ni Kaditasan a Hari yu. Ta i misan ino a gesabi a eya i hari ay kapagebuk ni Kaditasan a Hari yu.” ");
INSERT INTO due_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Dingan pagkaikna ni Pilato de manga surut a inon ay pinabulwag na i Hisus ta i Pilato ay linumipa de piglipaan na a pighatolan de lugel a pig-uddian a te ngalan de surut a Hebreo a Gabata. ");
INSERT INTO due_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nano ay odes di a getanga i adow ta nun nanon ay adow di ni paghande de Paskuwa ta sinabi ni Pilato de manga Hudyo ide, “Wiyo i hari yu.” ");
INSERT INTO due_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dingan nagiinolang ide, “Bunoin eya. Bunoin eya. Pakuin eya de padipa.” Misan tinanto ide ni Pilato, “Pepapaku yu man deko de padipa i hari yu?” Tinumubeg i ponu ide ni maghahandug ide, “Ang kami te hari ti an i Kaditasan a Hari yu.” ");
INSERT INTO due_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kanya pan binoy ni Pilato i Hisus dide a kapangyedihan tangani papakuan de eya de padipa. ");
INSERT INTO due_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Dingan inikag ni sundelo ide i Hisus a nappassan na un padipa na ta binumulwag ide de Herusalem a paagow de Golgota a te kabuluhan de surut a Hebreo a “Kaksan ni Ulo.” ");
INSERT INTO due_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ta pagdetong duman ay pinakuan de eya de padipa a kasabey na pala i aduwa, a i isin de awenan na, i isin pala de awile na. ");
INSERT INTO due_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nano ay pinasolat ni Pilato i pagsumbung de a pinakitad de padipa a kadepit a ditas ni ulo ni Hisus ta i pinasolat ay magioyo, “I Hisus a tage Nasarit a Hari ni Hudyo ide.” ");
INSERT INTO due_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","I pagsumbong a inon ay nassolat de surut a Hebreo, Griego pati Roma. I makmuk a Hudyo i nakabesa ninon ta alane la de Herusalem i pinagpakuan de Hisus. ");
INSERT INTO due_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kanya sinabi ni ponu ide ni maghahandug ide de Pilato a, “Wet yu solata, ‘I Hari ni Hudyo ide.’ Ta solatin yu pan a, ‘Sinabi ni agta a oyo a ako i Hari ni Hudyo ide.’” ");
INSERT INTO due_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Misan ay tinumubeg i Pilato, “Inon a sinolat ko di ay sukul.” ");
INSERT INTO due_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nun i Hisus ay pakuin ni sundelo ide ay inamit de i bedu na ide dingan pinabulubinsaan ni apat a sundelo ta inamit de pala i kulapyaw na. I oyo ay an tini gepo de ditas hanggen de sidong ");
INSERT INTO due_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","kanya nasurutsurotan ide ta sinabi de, “Wet tam yo pitasin ta magsugel kitam dila tangani matinggesan tam ti ino i nakáamit.” Maginon dila i yinadi ni sundelo ide ta nangyedi yo ta te duman de kasulatan i hinola a magioyo a, “Pinabulubinsaan de i bedu ko ide ta i kulapyaw ko pan ay pinagsugelan de.” ");
INSERT INTO due_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Nano ay kauluuddi de kaginglan ni padipa ni Hisus i ina na, wele a mahuna ni ina na, Maria a bebi ni Kleopas pati Maria Magdalena. ");
INSERT INTO due_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ta nun kinta ni Hisus i ina na pati mag-aadel na a pebuot a geuddi de alane ni padipa ay sinabi na de ina na a tungkul de mag-aadel na, “Ina, wina di i nappa ni anak yu.” ");
INSERT INTO due_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ta sinabi pan ni Hisus de mag-aadel na a tungkul de ina na, “Wina di i nappa ni ina mo.” Ta dingan gepo nun nanon ay pinataan eya ni mag-aadel a inon nunde beloy na. ");
INSERT INTO due_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pagkatapos ninon ay katinggesan di ni Hisus a nangyedi di i pesan kanya sinabi na, “Nagkoohow ok.” Ta de maginon ay nangyedi i hinola de kasulatan. ");
INSERT INTO due_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Te isin duman a mangkok a pino ni tayug a maapsut kanya binasá de duman i lumut a ginipot de tangbu a te ngalan a hisopo ta dingan pinasopsop de diya. ");
INSERT INTO due_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nun masopsop di ni Hisus un tayug a maapsut ay sinabi na, “Natapos di.” Ta dingan dinuko na i ulo na ta napugtusan di. ");
INSERT INTO due_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nano ay nun inon a adow ay adow ni paghande kanya inaged ni manga ponu a Hudyo de Pilato a pabeli na i bitis ni pinaku ide de padipa dingan layuin de. Ta an de buot a un bengkay nun nalibunin ide ay de padipa de adow ni paimloy ta mahalage i adow nun paimloy a oyo dide. ");
INSERT INTO due_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kanya pan dinumuman ngani un sundelo ide ta binale de i bitis nun aduwa a kakoloy ni Hisus a pinaku. ");
INSERT INTO due_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ay pagdetong de de Hisus ay kinta de di a nalibun di kanya an de di binale i bitis na. ");
INSERT INTO due_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Misan ay isin a sundelo ay tinagpuk nadla ni geyang i tagileden na ta dingan tambing a binumulus i sagu pati orat. ");
INSERT INTO due_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ta ako a gepamatud ay i kinumita de inon ta talage a matud i pagpamatud ko kanya manulusun kamo ta katinggesan ko a kamatoden i sinabi ko. ");
INSERT INTO due_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ta nangyedi yo tangani mapamatoden i sinabi ni kasulatan a, “An te nabeli misan isin de kaksan na.” ");
INSERT INTO due_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ta te duman pan de isin pa a kasulatan a, “Kekita de eya a tinagpuk ni geyang.” ");
INSERT INTO due_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nano ay pagkatapos pan ninon ay i Hose a tage Arimatea ay kinumang de Pilato a inaged na i bengkay ni Hisus. I Hose ay geabut pala de Hisus misan ay an gepatingges de manga ponu a Hudyo dehil de takut na dide. Sinabi pan ni Pilato a nappatud a aamit ni Hose i bengkay kanya dinumuman i Hose ta inamit na nunde padipa. ");
INSERT INTO due_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Sinumut diya i Nikodemo a te adde ni pabengo a pinagdugengan a mira pati alowe a te biyet ni manga apat a puwu a kilo. Eya dingani un kinumang de Hisus nun isin a abi. ");
INSERT INTO due_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dingan inamit de i bengkay ni Hisus ta tiningos de de age a matebe a te pabengo ta nappaayun non de ugeli ni Hudyo de pagtapor de. ");
INSERT INTO due_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nano ay nun de lugel a pinagpakuan de Hisus ay te alane a kahardinan a te gob a bowon a táporan a am pa te nagkattapor. ");
INSERT INTO due_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kanya dehil de apun di ni adow a Paghande, a mandeli a nádetong i adow ni paimloy ay duman dedla pinuoy i bengkay ni Hisus ta alane pan inon a táporan. ");
INSERT INTO due_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nano pan nun makatakig di i adow ni paimloy ta mulumadumos pa nun abiabi a simbe ay dinumuman i Maria Magdalena de gob a táporan. Ta pagdetong na ay kinta na a linayu di un pinangabet a beto nunde gob. ");
INSERT INTO due_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kanya ginumikan eya a kinumang de Simon Pedro pati de pebuot ni Hisus a mag-aadel ta sinabi na dide, “Inamit di nunde gob i bengkay ni Panginoon ta am mi katinggesan ti deno eya inadde.” ");
INSERT INTO due_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kanya kinumang i Pedro pati isin a mag-aadel a paagow nunde gob a táporan. ");
INSERT INTO due_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ta ide ay ginumikan misan ay maparipari pa un isin a mag-aadel de Pedro ta tagibu a nakadetong de táporan. ");
INSERT INTO due_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pagdetong na ay dinumuko eya ta sineling na un disalad ta kinta na un age ide a pambengkay misan ay an eya sinumilong. ");
INSERT INTO due_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Misan ay dinumatong pan i Simon Pedro ta sinumilong a tuloy de disalad nun gob ta kinta na un age ide a nappuoy. ");
INSERT INTO due_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pati un panyu a tiningos de ulo na ay an yo napadugeng nunde age ide ta natiklop de isin a kaginglan. ");
INSERT INTO due_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dingan sinumilong pala un mag-aadel a naona a dinumatong. Nun kinta na pala inon ay eya ay nanulusun a pinakaedup di a liwet i Hisus. ");
INSERT INTO due_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ta hanggen de inon a odes ay an de pa kinatinggesan i pesabi ni kasulatan a depat a pakeedup a liwet i Hisus. ");
INSERT INTO due_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pagkatapos ninon ay inumuli di un mag-aadel ide de sulusadile de a beloy. ");
INSERT INTO due_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Misan ay i Maria pan ay geuddi a getangos de ditow nun gob a táporan. Dingan nun eya ay getangos pa ay dinumuko eya ta sinumeling de disalad nun gob. ");
INSERT INTO due_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ta kinta na i aduwa a anghel a te manga bedu a malapsay ta kalipalipa ide de lugel a pinumuoyen ni bengkay ni Hisus. Un isin ay de kadepit a ulo ni Hisus ta isin pan ay de kadepit a singitan. ");
INSERT INTO due_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dingan tinanto de eya, “Mahuna, ano ta getangos ka?” Tinumubeg eya, “Inamit de pan i bengkay ni Panginoon ko ta ang ko katinggesan nano ti deno de eya inadde.” ");
INSERT INTO due_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pagkasabi na ninon ay linumingoy eya ta kinta na i Hisus a geuddi duman de ditow nun gob misan ay an na inabuyenan a eya ay i Hisus. ");
INSERT INTO due_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nano ay tinanto ni Hisus, “Mahuna, ano ta getangos ka? Inóman i pelawag mo?” Misan ay inesip ni Maria a eya ay mag-aalage ni kahardinan kanya sinabi na, “Be ikamo i nangamit diya ay toduin yu deko ti deno yu pinuoy ta aamit ko.” ");
INSERT INTO due_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sinabi ni Hisus, “Maria.” Ta dingan sinumagkad eya ta sinabi na de surut a Hebreo, “Raboni,” a buot na a sasabi a “Magtutodu.” ");
INSERT INTO due_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sinabi ni Hisus, “Wet ok mo ngona bolan ta anok pa gepakadeditas de Ama. Misan dumuman ka nunde gepanulusun ide deko a manga kabinsa ko ta sabiin mo a nadeditas ok di de Ama ko pati de Ama yu, de Makedepat ko pati de Makedepat yu pala.” Inon i sinabi ni Hisus ");
INSERT INTO due_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","kanya i Maria Magdalena ay kinumang nunde mag-aadel ide ta sinabi na dide, “Kinta ko di i Panginoon.” Ta sinabi na dide un pepasabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nun abi di a inon a simbe ay nagpolong un mag-aael ide misan ay nàabetan i pintohan nun beloy a pepolongan de dehil de takut de de manga ponu a Hudyo ta dingan loktat a inumuddi i Hisus de gitna de ta sinabi na, “Mapadikamo i kasampatan a innawa.” ");
INSERT INTO due_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pagkasabi na ninon ay pinakita na i kumot na pati tagileden na de mag-aadel na ide dingan ide ay nagkasalig dehil de pagkákita de de Panginoon. ");
INSERT INTO due_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Liwet a sinabi ni Hisus dide, “Mapadikamo i kasampatan a innawa ta ti papalano a ako ay dinodul ni Ama dio de putok i ay maginon pala pedodul ko ikamo de kaagtaan dio de putok i.” ");
INSERT INTO due_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ta pagkasabi na ninon ay ininnawaan na ide ta sinabi na dide, “Tanggepin yu di i Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ta ikamo ay te kapangyedihan di a gepamatud a pakaeyenan di i misan ino a gesosol ni mammalotin de pati pan ikamo ay te kapangyedihan pala a gepamatud a an pakaeyenan i misan ino a an gesosol ni mammalotin de.” Inon i sinabi ni Hisus dide. ");
INSERT INTO due_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Misan ay i Tomas a pengalanan a kambel a isin de sangpuwu pati aduwa ay an kaduman nun dinumatong i Hisus. ");
INSERT INTO due_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kanya nun an di kaduman i Hisus ay sinabi de Tomas nun mangáyun na a mag-aadel a magioyo, “Kinta mi di i Panginoon.” Misan ay tinumubeg i Tomas “Talage a anok nonulusun hanggen ang ko pekita i bulsut ni paku de kumot na a sosuksuk ko i guramut ko duman pati sosuksuk ko i kumot ko de bulsut de tagileden na.” ");
INSERT INTO due_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nano ay pagkatakig di ni walo a adow ay nagpolong a liwet i mag-aadel na ide a ayun de di i Tomas. Naabetan i pintohan ide nun beloy dingan loktat a inumuddi i Hisus de gitna de ta sinabi na dide, “Mapadikamo i kasampatan a innawa.” ");
INSERT INTO due_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dingan sinabi na de Tomas, “Pagelawagin mo i kumot ko ta suksukin mo i guramut mo dio pati umain mo i kumot mo a suksukin de bulsut de tagileden ko i. Wet geuluaduwa i esip mo ta manulusun ka di.” ");
INSERT INTO due_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tinumubeg i Tomas, “Ikamo dingani i Panginoon pati Makedepat ko.” ");
INSERT INTO due_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Sinabi diya ni Hisus, “Gepanulusun ka di ta kinta ok mo di misan ay pekalbian i gepanulusun a am pa kinumita deko.” ");
INSERT INTO due_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nano ay te makmuk pa a gepakataka a yinadi ni Hisus de pekita ni mag-aadel na ide a an nassolat dio de kasulatan a oyo. ");
INSERT INTO due_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Misan ay sinolat i oyo ide tangani manulusun kamo a i Hisus ay i Kristo a Anak nun Makedepat. Ta i belang gepanulusun de makapangyedihan a ngalan na ay gekaduman ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pagkatapos ninon ay liwet a nagpakita i Hisus de mag-aadel na ide de kaginglan ni uluataben a Tiberias ta magioyo i nangyedi. ");
INSERT INTO due_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Magkakoloy i Simon Pedro pati Tomas a pengalanan a kambel pati Natanael a tage Kana a sákup ni Galilea. Ta kakoloy pala i aduwa a anak ni Sabedeo pati aduwa pa a mag-aadel. ");
INSERT INTO due_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ta sinabi dide ni Simon Pedro, “Ako ay nengikan.” Ay sinabi de diya, “Ay nosut kami.” Kanya tinumotul ide ta sinumakoy ide de bengka de misan ay an ide nakámit magdemag. ");
INSERT INTO due_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nano ay nun mandeli di a abiabi ay inumuddi i Hisus nunde kaginglan nun uluataben misan ay an eya inabuyenan ni mag-aadel na ide. ");
INSERT INTO due_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sinabi na dide, “Manga lalaki, te námit kamo man?” Tinumubeg ide, “Unabis.” ");
INSERT INTO due_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Dingan sinabi na dide, “Degdegin yu i pokut yu na de kadepit a awenan ni bengka yu ta nakáamit kamo.” Kanya dinagdeg de un pokut de ta dingan anded nagkobotong dehil de kamakmuk di ni ikan a námit de. ");
INSERT INTO due_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ta sinabi nun mag-aadel a pebuot ni Hisus de Pedro, “Talage a eya i Panginoon tam.” Pag-ikna ni Simon Pedro ni sinabi ni ayun na ay nagbedu eya ta ubed eya nun nanon ta dingan tinumalun nunde orat. ");
INSERT INTO due_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Misan ay un mangayun na pan ide a mag-aadel ay nakadetong pala a napasakoy nunde bengka ta nauwey de un pokut de a pino ni ikan. Ta an ide alayu a masakut de langges ta manga isin la a dian a metro. ");
INSERT INTO due_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Paglusong de nunde langges ay kinta de i alabe a te nassube a ikan pati tipide a tinapay. ");
INSERT INTO due_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ta sinabi ni Hisus dide, “Mangadde kamo dio ni tipide a ikan a námit yu.” ");
INSERT INTO due_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kanya sinumalakat i Simon Pedro de bengka ta inuwey na un pokut a pino ni hangain a ikan. I kamakmuk na ay isin a dian pati lima a puwu pati tiluwon misan ay an nagise i pokut misan maginon a kamakmuk i ikan. ");
INSERT INTO due_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Sinabi pa ni Hisus dide, “Dumio kamo di ta mangábiabi kitam di.” Misan ay an te nagtanto a ti ino eya misan isin dide ta katinggesan de pan a eya i Panginoon. ");
INSERT INTO due_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dingan linumane i Hisus ta inamit na un tinapay ta binoy na dide. Maginon pala un ikan. ");
INSERT INTO due_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","I oyo i katiluwon a pagpakita ni Hisus nunde mag-aadel na ide pagkatapos a eya ay pinakaedup a liwet. ");
INSERT INTO due_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pagkapangan de ay tinanto na i Simon Pedro, “Simon a anak ni Huwen, te pagbuot ka man deko a matibong pa de pagbuot ni oyo ide deko?” Tinumubeg eya, “Ay-o, Panginoon, katinggesan yu ngani a pebuot ko ikamo.” Dingan sinabi diya ni Hisus, “Ungutin mo i mangának ko a topa a i gepanulusun ide deko.” ");
INSERT INTO due_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Liwet eya a tinanto ni Hisus, “Simon a anak ni Huwen, te pagbuot ka man deko a masakut?” Tinumubeg i Simon, “Ay-o, Panginoon, katinggesan yu ngani a pebuot ko ikamo.” Sinabi ni Hisus, “Alagean mo i topa ko ide.” ");
INSERT INTO due_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Dingan pakatiluwon a eya tinanto ni Hisus, “Simon a anak ni Huwen, te pagbuot ka man deko a masakut?” Misan ay nalungkut i Pedro ta pakatiluwon eya tinanto a ti te pagbuot eya de Hisus a masakut kanya sinabi na de Hisus, “Panginoon, katinggesan yu a pesan ta katinggesan yu pala a ako ay te pagbuot dikamo a masakut.” Ta dingan sinabi ni Hisus, “Ungutin mo i manga topa ko.” ");
INSERT INTO due_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Talage a matud ay pesabi ko dikaw a nun anak ka pa ay ikaw i gebeyakos de sadile mo ta getotul ka ti deno mo buot a paagow misan ay de pagtande mo ay dedipa mo i kumot mo ta i kakmukan i gegipot dikaw dingan aadde de ikaw de am mo buot a paagowen a kahedepan. ");
INSERT INTO due_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Maginon ay hinola ni Hisus a tungkul de pagkalibun ni Pedro a te tiis ta de inon ay popodian na i Makedepat. Dingan sinabi ni Hisus diya a, “Umabut ka di deko.” ");
INSERT INTO due_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Misan ay linumingoy i Pedro ta kinta na a geabut i mag-aadel a pebuot ni Hisus a eya a napalipa de alane ni Hisus nun ide ay gepangapun a nagtanto pala, “Panginoon, ino i gepadekop dikamo?” ");
INSERT INTO due_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nun makitan ni Pedro inon a mag-aadel ay nagtanto i Pedro de Hisus, “Panginoon, ano pan i nangyeyedi de agta a oyo?” ");
INSERT INTO due_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tinumubeg i Hisus de Pedro, “Be buot ko a needup eya hanggen de pagdetong ko ay panganó mo la? Bestat umabut ka di deko.” ");
INSERT INTO due_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kanya dehil de inon a surut ay kinumálat de manga kabinsa i bereta a an nelibun i oyo a mag-aadel. Misan an sinabi ni Hisus a an eya nelibun ta sinabi na a, “Be buot ko a needup eya hanggen de pagdetong ko ay panganó mo la.” ");
INSERT INTO due_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nano ako a Huwen a mag-aadel ay gepamatud a i pesan a solat ko i a oyo ay matud ta katinggesan ko a matud ngani i pagpamatud ko. ");
INSERT INTO due_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Talage a makmuk pa a yinadi ni Hisus a be sosolat a pesan ay peesip ko a kasta an te sukul a pomuoyen de putok i para nunde kasulatan Iwina i matud.");
INSERT INTO due_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ayun a Tiopilo a pegelang ko, nun ako a Lukas ay nagsolat dikamo a tagibu ay sinabi ko di de inon a solat i pesan a yinadi ni Hisus pati pagtodu na gepo nun eya ay napa ni agta ");
INSERT INTO due_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hanggen de eya ay pinaditas de langot. Misan ay dingan ngona eya pinaditas ay dinodul na gepo de kapangyedihan ni Ispiritu, i mag-aatid na ide a pineta a nanyeyedi ni kabuotan na. ");
INSERT INTO due_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nun pagkaedup na a liwet de kalibunan na ay dingan hanggen nun apat a puwu a adow ay nagpakita eya de mag-aatid na ide ni makmuk a sila ta de maginon ay napamatoden di a naedup di eya. Ta eya ay nagtodu pa a ti papalano a te kapangyedihan i Makedepat de innawa ni agta ide. ");
INSERT INTO due_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nun kakoloy de pa i Hisus ay dinodul na a, “Wet kamo ngona nototul de gitna ni benwaan a oyo a Herusalem ta mag-ilat kamo ni paaged a pinangako ni Ama a Makedepat a magi sinabi ko dikamo. ");
INSERT INTO due_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","I Huwen a Maglilenod ay naglinod eya ni manga agta de orat la be ide ay nakapagsosol di, misan ay de an naaloy ay lelinod ko pan ikamo de Ispiritu nun Makedepat.” Inon i sinabi ni Hisus. ");
INSERT INTO due_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nano ay nun gepolong ide Hisus pati mag-aatid na ide ay tinanto de eya a, “Panginoon, boboy yu man dikami a manga Hudyo i nasasakopan de nano a panahon de putok mi a sadili?” ");
INSERT INTO due_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tinubeg na dide, “I panahon pati odes a inon ay hinande la ni Ama a Makedepat de kapangyedihan na a sadile ta an di depat a ketinggesan yu pa i panahon a inon. ");
INSERT INTO due_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Misan ay paglusong dikamo ni Ispiritu nun Makedepat ay nátanggep kamo ni tibong a gepo de Ispiritu dingan gepamatud kamo ni tungkul deko de benwaan a Herusalem, de sulusákup ni Hudia, de sákup ni Samaria pati misan deno a kadepit ni putok i.” ");
INSERT INTO due_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Maginon i sinabi na dide ta dingan nun pillawag de eya ay pinaditas di de langot. Ta un kunom pan ay naghelum di kanya an ded kinta. ");
INSERT INTO due_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Misan ay nun gepakalawag pa ide de langot ay kinta de de alane de i aduwa a lalaki a kauluuddi a nappabeduin ni malapsayin a anduwonin. ");
INSERT INTO due_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ta sinabi de, “Manga lalaki a tage Galilea, ano ta gepakalawag kamo pa de langot? Ta i Hisus a oyo a pinaditas de langot ay náampulang pala a magi kinta yu nun eya ay pinaditas.” Inon i sinabi de. ");
INSERT INTO due_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pagkatapos ninon ay inumampulang ide de Herusalem a inumapo de Kalasan a Olibo ta am pan la alayu i tinotulán de. ");
INSERT INTO due_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ta pagdetong de de petuloyen de a beloy ay sinumalakat ide de ditas a salog. Ide ay i Pedro, Huwen, Santiago, Andres, Pilepi, Tomas, Bartolome, Mateo, Santiago a anak ni Alpeo, Simon a matibong i innawa na pati Hodes a anak ni Santiago. ");
INSERT INTO due_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ugnay ide a gekàeisin a gepanalangin ta kakoloy de pala i mahunain, i Maria a ina ni Hisus pati manga wele na a manga lalaki. ");
INSERT INTO due_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nun isin a adow ay nagpolong a liwet i manga kabinsa ide a isin a dian pati aduwa a puwu ta i Pedro ay inumuddi de gitna de a nagsurut. ");
INSERT INTO due_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ta sinabi na a, “Manga kabinsa, i Hodes i nagpadekop de Hisus misan ay nun nowon pa ay gepo de kapangyedihan ni Ispiritu ay naghola i Debid a malot ngani i násapit de Hodes kanya pan nano ay nangyedi di inon a hinola na. ");
INSERT INTO due_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","I Hodes ay kakoloy tam ta tinanggep na a magi ikitam i tungkolin na a inumapo de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ay katinggesan yu pala a i Hodes ay nanggetang ni putok gepo de pinandeyaan na dingan eya ay nadegdeg de kalibunan na a pinumitak i tiyen na ta tinumanga i bituka na. ");
INSERT INTO due_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Inon a nangyedi ay nabereta ni pesan a nappataan de Herusalem i, kanya pan nginalanan de inon a putok ni ‘Ginatang ni Sagu.’ ");
INSERT INTO due_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ta nappaayun pala inon de sinolat ni Debid de kasulatan a den a tungkul de Hodes a, ‘An di eya te mana ni taanan na a putok pati mangápo na ide. Talage ay náamit ni kakmukan i tungkolin na a mag-aalage a inumapo de Makedepat.’” ");
INSERT INTO due_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Sinabi a tuloy ni Pedro a, “Kanya nano ay depat kitam di a mameta ni isin a lalaki a nappa ni kakoloy mi, a gepamatud de pagkaedup a liwet ni Hisus. Misan ay i depat ay un kakoloy tam di, nun nappakoloy kitam pa de Hisus gepo nun gelinod i Huwen ni agta hanggen nun eya ay pinaditas de langot.” ");
INSERT INTO due_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kanya nameta di ide ni aduwa a manga lalaki a i Matias pati Hose Husto a te ngalan pala a Barsabas. ");
INSERT INTO due_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ta dingan ide ay nanalangin a magioyo, “Panginoon a Makedepat, katinggesan yu i esip ni pesan a agta kanya paabuya yu dikami ti ino de aduwa a oyo i pineta yu ");
INSERT INTO due_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a mag-aatid tangani eya i nanyeyedi ni tungkolin a binoy yu de Hodes ta winalat na di inon a tungkolin na a pinumapaagow di de padusa a hinande para diya.” ");
INSERT INTO due_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ay nun pagkatapos a nagsugel ide ay i Matias i napeta kanya eya ay napadugeng di de sangpuwu pati isin a mag-aatid. ");
INSERT INTO due_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nano ay nun dinumatong di i adow a Pentekostes ay nagpolong i gepanulusun ide de isin a beloy. ");
INSERT INTO due_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ay dingan loktat a inikna de i agewak a magi maslog a palos a inumapo de langot ta napino ngani ni agewak a inon i beloy a pelipaan de. ");
INSERT INTO due_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Dingan te kinta ide a gediladila a magi dilab de tipong ni belang isin dide. ");
INSERT INTO due_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ta napino di i belang isin dide ni Ispiritu nun Makedepat pati ginumapo ide a gesurut ni an de katinggesan a nappaayun de binuluboy dide ni Ispiritu. ");
INSERT INTO due_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nano ay te duman pan a manga Hudyo a inumapo de kulukakmukan a bensa a nakitaan duman de Herusalem. Migpodi ide de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nano ay nun iknain de i sadisadi a surut ni manga gepanulusun ide ay kinumang ide a getaka ta inikna de i sulusadile de a surut. ");
INSERT INTO due_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dehil de pagtaka de ay sinabi de, “Pagelawagin yu ngani ta i oyo ide a tage Galilea ay gesurut ide ni sadisadi a surut a an de sadili. ");
INSERT INTO due_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ano pan ta i peikna tam dide ay i surut di ni belang isin dikitam? ");
INSERT INTO due_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Misan ay ikitam pan a geikna ay tage Partia, Media, Elam, Mesopotamia, Hudia, Kapadosia, Ponto pati de Asia. ");
INSERT INTO due_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Te duman pala a tage Prigia, Pampilia, Ihipto pati gesurut ide ni Sirene a tage Libia. Te gekang pala a tage Roma a i Hudyo pati an Hudyo a te pagpanulusun a magi Hudyo. ");
INSERT INTO due_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Pati te duman pam pala a tage Kreta pati tage Arabia ta peikna tam ide a gesurut de belang surut tam ni tungkul de gepakataka a yinadi ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ta talage a nagtaka ide a masakut a nagkelito pala i esip de tungkul de sinumapit a inon kanya ide ay nattulutantoan a, “Ano man i kabuluhan ni oyo?” ");
INSERT INTO due_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Misan ay sinabi pan ni kakmukan a paglibek, “Ay bugnangin ide.” ");
INSERT INTO due_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kanya inumuddi i Pedro pati mag-aatid ide a sangpuwu pati isin de kasagkaden ni kaagtaan ta dingan sinabi ni Pedro a malagdu, “Kaagtaan a tage Herusalem pati manga Hudyo a nakitaán dio ay patalikngan yu a piyon i sasabi ko a oyo. ");
INSERT INTO due_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Angani bugnangin i oyo ide a magi peesip yu, a namas pa ta abiabi la a kadepit a an tigbugnang ni agta. ");
INSERT INTO due_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ta nano ay pepamatoden di un hinola ni magsasabi a Hoel a magioyo, ");
INSERT INTO due_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Gepayin i Makedepat a de inapóan a adow ay kasta papalis ko i Ispiritu ko de pesan a agta ta dehil ngan duman ay gesurut ni geapo de Ispiritu i mangának yu a mahunain pati manga lalaki ta i minangának yu a lalaki ay gekita ni pangitaán pati nangnenenop pala i matitandein a lalaki. ");
INSERT INTO due_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Talage ngani a de inon a adow ay kasta papalis ko i Ispiritu ko de manga katabeng ko ide a lalaki pati mahuna ta gesurut ide ni geapo de Ispiritu. ");
INSERT INTO due_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pati gepakita ok de pesan ni gepakataka a tande de langot pati pan de putok i. Ay te duman a tande a sagu, apoy pati asuk a hanga. ");
INSERT INTO due_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ta i adow ay nodumos, i bulan pan ay náderag a magi sagu dingan pa nádetong i adow a paghatol ni Panginoon. Inon di a adow i pinakamahalage ta kekita di ni pesan i Panginoon a Makedepat a Makapangyedihan. ");
INSERT INTO due_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ta i misan ino a geolang de Panginoon a Makedepat ay nalligtas ngani.’” ");
INSERT INTO due_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Sinabi a tuloy ni Pedro a, “Patalikngan yu, manga Hudyo, i sasabi ko a oyo. I Hisus a tage Nasarit ay dinodul ni Makedepat ta inon ay pinamatoden ni pagyedi a te kapangyedihan, ni gepakataka ide pati manga tande ta pinayedi diya ni Makedepat de pekita yu kanya katinggesan yu inon. ");
INSERT INTO due_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ta binoy yu eya de makikkakasalanan ide tangani pakuan de eya de padipa a binuno. Talage a i oyo a Hisus ay pinabiyaan ni Makedepat a dinakop ni manga agta ide a nappaayun de kabuotan na pati katinggesan hanggen nunde gepo. ");
INSERT INTO due_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Misan ay pinakaedup eya a liwet ni Makedepat ta pinakaeyen na diya i kapangyedihan ni kalibunan na. Ay an nappatud a natalo a liwet eya ni kalibunan. ");
INSERT INTO due_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ta magioyo i hinola ni Debid a tungkul de sinabi ni Hisus, ‘Katinggesan ko a kakoloy ko a ugnay i Panginoon a Makedepat ta pealagean ok na tangani wet ok nagkatakut. ");
INSERT INTO due_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kanya pan nagkasalig i innawa ko ta gekanta ok a te salig ta misan malibun ok ay te pag-asa ok diya a pakeedup ok na a liwet. ");
INSERT INTO due_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Talage, Panginoon, a be malibun ok ay an yu pabiyaan i kaleduwa ko a nákang de lugel ni nalibunin ide ta i lawes ko pan ay an yu pabiyaan a nobungtut ta ako ay anak yu ngani a an te kasalanan de pekita yu. ");
INSERT INTO due_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ta tinodu yu deko i bektas a paagow de edup ta hanga i kasalegen ko dehil de kakoloy ko ikamo, Makedepat.’” ");
INSERT INTO due_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Sinabi a tuloy ni Pedro, “Manga kabinsa, pesabi ko dikamo a matanus i tungkul de Hari a Debid a kaapoapohan tam a nun eya ay nalibun ay tinapor i bengkay na ta hanggen nano ay wiyo la dikitam i kataporan na. ");
INSERT INTO due_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Misan eya ay magsasabi ni Makedepat kanya kinatinggesan na i pinangako diya a sinumpa ni Makedepat a eya ay gekaduman ni isin a apo ta i oyo a apo na ay nappa ni hari pala a magi eya. ");
INSERT INTO due_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Naghola i Debid a tungkul de pagkaedup a liwet ni Kristo a an pan pabiyaan ni Makedepat i kaleduwa na de lugel ni nalibunin ide pati an na pala pabiyaan a nobungtut i lawes na. ");
INSERT INTO due_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kanya i Hisus a oyo ay pinakaedup a liwet ni Makedepat ta ikami pan i gepamatud tungkul de oyo. ");
INSERT INTO due_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ta i Hisus ay pinaditas di de langot a awenan ni Makedepat a te kapangyedihan di duman. Ta nano pan ay tinanggep na di i Ispiritu a pinangako diya ni Ama na kanya pan kasta pinalis na dikami nano i Ispiritu a magi pekita yu pati peikna nano. ");
INSERT INTO due_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Talage a tungkul de Debid ay an kinumang eya de langot misan ay hinola na a magioyo, ‘Sinabi ni Panginoon a Makedepat de Panginoon ko a, nano ay lumipa ka de awenan ko i ");
INSERT INTO due_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ta padeog ko dikaw i kapagebuk mo ide.’” ");
INSERT INTO due_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sinabi a tuloy ni Pedro, “Kanya matinggesan yu ngani a manga Hudyo, a i Hisus a pinapakuan yu de padipa ay eya ngani i yinadi ni Makedepat a Panginoon a Pinangako na.” Inon i sinabi ni Pedro. ");
INSERT INTO due_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nano ay nalungkut ide nun iknain de i sinabi na a inon ta natinggesan de di i mammalotin de kanya nagtanto ide de Pedro pati de kakmukan a mag-aatid, “Manga kabinsa, ano man i depat mi a yeyedi?” ");
INSERT INTO due_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ay tinubeg ide ni Pedro, “Magipinagsosol kamo ta dingan lelinod kamo de orat a tande ni pagpanulusun yu de ngalan ni Hisus. Ta pakeeyenan kamo ni mammalotin pati tatanggep yu pala i pangako na a i Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Inon a pangako na ay para dikamo pati mangápo yu a un belang pineta ni Panginoon tam a Makedepat misan deno a kadepit.” ");
INSERT INTO due_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Makmuk pangani i surut a pinamatoden dide ni Pedro ta pinagsabian na ide a tuloy a magioyo, “Lumayu kamo de belang geyedi ni malot dio de putok i tangani nalligtas kamo.” ");
INSERT INTO due_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kanya i nanulusun ide de pagpamatud na ay lininod ide ta i kapolongan a gepanulusun ay nadugengan ni tiluwon a lebu a agta nun nanon pala a adow. ");
INSERT INTO due_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ta ide ay nag-adel a masakut de pagtodu ni mag-aatid ide, a nagpanalangin, pinumisang ni tinapay a tande de pagkalibun ni Hisus pati ide ay gekàeisin a pesan. ");
INSERT INTO due_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ta nagpayedi i Makedepat de mag-aatid na ide ni makmuk a gepakataka pati manga tande kanya pan nagkagelang i kaagtaan a pesan de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pati i manga gepanulusun ide ay nagkaeisin kanya pan i adi de ay dide a pesan. ");
INSERT INTO due_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ta i pesan a adi de ay pinanggetang de ta dingan binuluboy de de belang te kaelangan ide. ");
INSERT INTO due_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pati adow adow ay nagpolong ide de beloy a pighandogen de Makedepat ta de binaloybeloy de pan ay nagpisang ide ni tinapay a tande de pagkalibun ni Hisus. Ide ay te salig, a te masidong a innawa a gepangan. ");
INSERT INTO due_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nagpodi ide de Makedepat kanya i pesan a kaagtaan ay te mabeit a esip de manga gepanulusun ide ta de belang adow pala ay pedugeng ni Panginoon dide i naligtas di. ");
INSERT INTO due_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nano ay nun isin a adow a kadepit a apun, a odes di ni panalangin ay sinumakat i Pedro pati Huwen a paagow de beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Te duman pan a lalaki a lungpo gepo pa nun eya-ay pinanganak. Adow adow ay peadde eya de pintohan ni beloy a pighandogen a te ngalan a “Masampat” ta dingan geaged eya ni limus na de gesilong ide. ");
INSERT INTO due_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kanya nun kinta na ngani ide Pedro pati Huwen a nesilong ay inaged na ngani i limus na. ");
INSERT INTO due_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dingan eya ay pinagelawag ni Pedro pati Huwen misan ay sinabi ni Pedro diya, “Magelawag ka dikami.” ");
INSERT INTO due_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dingan eya ay pinumagelawag ngan dide ta inumasa a eya ay bebiyen de ni misan ano. ");
INSERT INTO due_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Misan ay sinabi ni Pedro, “Anok te pelak o ginto a unabis misan ay boboy ko dikaw i te duman ta de makapangyedihan a ngalan ni Hisu Kristo a tage Nasarit ay pedodul ko a makatotul ka di.” ");
INSERT INTO due_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dingan binolan na de awenan na a kumot a pinauddi ta nano ay tinumibong di i tulutud pati bukubuku nun lungpo. ");
INSERT INTO due_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ay nakalawot dingani un lungpo a nakatotul di a tuloy ta eya ay sinumut dide a gekatotul a gelugulawot a gepodi de Makedepat a gesilong de beloy a pighandogen diya. ");
INSERT INTO due_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ay kinta eya ni pesan a kaagtaan a gepakatotul di a gepodi de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ta inabuyenan eya ni kaagtaan a eya ngani un lungpo a gelipa de “Pintohan a Masampat” kanya nagtaka ide dehil de sinumapit diya. ");
INSERT INTO due_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nun eya ay nappakipot pa dide Pedro pati Huwen ay ginumikan i kaagtaan a linumane dide de betalán a pinayedi ni Hari a den a Solomon ta nagtaka ide a masakut. ");
INSERT INTO due_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nun matinggesan ni Pedro a getaka ide ay sinabi na, “Misan ikamo a manga Hudyo ay getaka ay wet kamo magtaka a magpakalawag dikami a magi ikami i nakapagpatotul diya dehil de kapangyedihan o kapiyonan mi a sadili. ");
INSERT INTO due_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ta i Makedepat la a pepodian hanggen nano nide Abraham, Isak, Hakob pati pesan tam a kaapoapohan ay eya ngani i nagpaabuya de Anak na a Hisus a eya i depat a pepodian ni pesan. Misan ay kinapoyen yu eya de kasagkaden ni Gubernador a Pilato nun te buot i Pilato a pakabbutan na eya. ");
INSERT INTO due_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Talage a kinapoyen yu i oyo a agta a an te mammalotin, a migyedi ni kapiyonan ta i pinakábutan yu pan para dikamo ay un migbuno. ");
INSERT INTO due_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Binuno yu ngani i geboy ni edup a an te kalog misan ay pinakaedup eya ni Makedepat ta ikami ngani i gepamatud a eya ay pinakaedup di. ");
INSERT INTO due_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","I makapangyedihan a ngalan ni Hisus i nagpapiyon de lalaki a oyo a peabuyenan yu. Napa ni matibong di a gepakatotul eya dehil de pagpanulusun na de ngalan ni Hisus ta dehil de pagpanulusun na de Hisus ay pinumiyon eya a talage a magi pekita yu. ");
INSERT INTO due_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Manga kabinsa a Hudyo, katinggesan ko a an yu la kinatinggesan i yinadi yu pati ponu yu ide de Hisus. ");
INSERT INTO due_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Misan ay nun nowon pa ay pinahola di ni Makedepat de pesan a magsasabi na ide a depat a i Kristo a Pinangako na ay getiis ta nano ay nangyedi dingani inon a pinahola na. ");
INSERT INTO due_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kanya magipinagsosol kamo a makikasungdu a liwet de Panginoon a Makedepat tangani pakeeyenan na ikamo ni mammalotin yu, a nappa dikamo pan i kabeetan a esip na dehil de kakoloy yu eya. ");
INSERT INTO due_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ta pakang na a liwet dio i Pinangako a inon para dikamo a i Hisus ");
INSERT INTO due_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","a depat ngona a tumaan pa de langot hanggen an nádetong i pineta a adow a nappa ni bowon di i pesan ta inon ay pinasolat ni Makedepat de magsasabi na ide a den. ");
INSERT INTO due_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ta sinabi ni Moises de kaapoapohan tam ide, ‘I Panginoon a Makedepat ay nemeta ni magi ako ni isin a magsasabi de manga kasi Hudyo tam ide kanya depat a manulusun kamo de pesan a sasabi na dikamo. ");
INSERT INTO due_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ta i pesan pan a an nonulusun de inon a magsasabi ay nakkiblag eya de mangának ni Makedepat, a podusahan pan.’ ” ");
INSERT INTO due_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sinabi a tuloy ni Pedro a, “I pesan a magsasabi gepo de Samuel ay naghola ide tungkul de panahon a oyo. ");
INSERT INTO due_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kanya ikamo ngani i gemana de pinangako nun Makedepat de padean ni magsasabi ide a den pati de pagpakikasungdu na de kaapoapohan tam ide ta sinabi ni Makedepat de Abraham, ‘Dehil de apo mo a isin a nádetong ay kakalbian ko i pesan a agta dio de disapow ni putok i.’ ");
INSERT INTO due_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nano ay nun pinakaedup di a liwet ni Makedepat i Anak na a Hisus ay pinakang na eya dikamo a tagibu tangani be makapagsosol kamo de mammalotin yu ay piyon i edup yu.” ");
INSERT INTO due_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nano ay nun gesurut pa ide Pedro pati Huwen de kaagtaan ay dinumatong i tipide a maghahandug ide, Saduseo ide pati kapitan ni magbebentay ide de beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ta nagbulas ide de pagtodu ni aduwa a mag-aatid a pakeedup a liwet ni Makedepat i kaagtaan de nalibunin a magipagpakaedup na de Hisus. ");
INSERT INTO due_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kanya dinakop de un aduwa a binilanggo hanggen nun kinábiabian ta abi di nun nanon. ");
INSERT INTO due_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Misan ay makmuk dingani, a inumikna de pagtodu de, i nagpanulusun de Hisus ta i manga lalaki la ay manga lima di a lebu. ");
INSERT INTO due_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nun kinábiabian di ay nagpolong de Herusalem i manga ponu, pinakamatande ide pati magtutodu ide ni Hudyo. ");
INSERT INTO due_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Misan ay kakoloy de i Anas a pinakaponu ni maghahandug, i Kaipas, i Huwen, i Alehandro pati pesan a mangáyun ni pinakaponu a maghahandug. ");
INSERT INTO due_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ta nun pinasagkad de i mag-aatid ide ay tinanto de a magioyo, “Dehil man de kapangyedihan pati ngalan ni ino ay yinadi yu i pesan a oyo?” ");
INSERT INTO due_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nano ay napino i Pedro ni Ispiritu nun Makedepat kanya eya ay tinumubeg, “Ikamo a manga ponu pati pinakamatande, ");
INSERT INTO due_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","be petanto yu ikami a tungkul de piyon a yinadi mi de lungpo na a ti papalano a eya ay pinumiyon di ");
INSERT INTO due_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ay depat a ketinggesan yu pati manga Hudyo a pesan a i lungpo a oyo ay pinumiyon dehil de makapangyedihan a ngalan ni Hisu Kristo a tage Nasarit. Eya ngani un pinaku yu de padipa misan ay pinkaedup eya ni Makedepat a liwet. ");
INSERT INTO due_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ta i oyo a Hisus ay magi beto a kinapoyen yu a manga magyeyedi ni beloy misan ay eya pan i namas pa a pinakamahalage a beto de iwina a yinadi a beloy. ");
INSERT INTO due_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kanya i Hisu Kristo la i te kaya a nanleligtas ta an te misan ino a ngalan a binoy dio de putok i ti an i ngalan na la i nanleligtas dikitam.” ");
INSERT INTO due_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nagtaka ngani i kapolongan a Hudyo nun kitain de a matibong i innawa ni Pedro pati Huwen, namas pa nun kinatinggesan de a ide ay agta la a an nag-adel a masakut misan ay inabuyenan de pan a ide ay kakoloy di ni Hisus nun eya ay dio pa de putok i. ");
INSERT INTO due_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kanya nun kinta de un lungpo a pinumiyon di a geuddi de alane de ay an di ide nappatud a nekipagtalo de aduwa a mag-aatid. ");
INSERT INTO due_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Misan ay pinabulwag ngan ide ni kapolongan dingan nasurutsurotan ide. ");
INSERT INTO due_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ta sinabi de, “Anóman i yeyedi tam de agta ide a oyo? Ta nano ay katinggesan di de pesan a Herusalem i gepakataka a masakut a peyedi de, a an nappatud a pobutelan tam. ");
INSERT INTO due_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kanya yadi pa a sablowin tam ide a wet gesurut o getodu de misan dino tungkul de kapangyedihan ni ngalan ni Hisus tangani wet di nakálat pa i pagtodu de de pesan a agta.” ");
INSERT INTO due_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kanya pinakangan de a liwet ide Pedro pati Huwen ta dingan sinablow de ide a wet ide gesurut o getodu pa ni tungkul de Hisus. ");
INSERT INTO due_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Misan ay tinumubeg ide a, “Esipin yu ngona, i deno man i matud, i nátalinga kami dikamo a agta o de Makedepat ngona? ");
INSERT INTO due_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ta talage a para dikami ay totodu mi i kinta pati inikna mi.” ");
INSERT INTO due_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dingan sinablow pa ide a mahigpit, a pinabiyaan ide a tinumotul ta an nappatud a podusahan de i mag-aatid ide dehil de kaagtaan. Ta i pesan a manga agta ay nagpodi de Makedepat dehil de sinumapit a inon de lungpo. ");
INSERT INTO due_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nano ay i katande ni lalaki a pinapiyon de ay mahigit de apat a puwu a taon. ");
INSERT INTO due_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nano ay nun patotulin ide Pedro pati Huwen ay kinumang ide de manga kabinsa de ide ta binareta de i sinabi ni ponu ide ni maghahandug ide pati pinakamatande ide. ");
INSERT INTO due_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kanya nun iknain ni manga gepanulusun ide ay nanalangin ide de Makedepat a nagkaeisin i innawa de ta sinabi de, “Panginoon a Makapangyedihan, ikamo ngani i nagyedi ni putok pati langot, atab pati pesan a nappataan duman. ");
INSERT INTO due_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ta pinapagsabi yu i Ispiritu yu de katabeng yu a Debid a kaapoapohan mi kanya hinola na a magioyo, ‘Ano ta gebulas a masakut i an Hudyo ide de Panginoon a Makedepat ta ide a manga tage bensa ay gesurut ni an te kabuluhan. ");
INSERT INTO due_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ta i manga hari ide dio de putok i ay gebelak a nálaben diya pati gepinagpolong i ponu ide a katalo diya pati de Pinangako na a Kristo.’ Inon i sinabi ni Debid.” ");
INSERT INTO due_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nagpanalangin ide a tuloy, “Ta dio de oyo a benwaan ay nagipinagpolong i Herod, Ponsio Pilato pati an Hudyo ide a kakoloy pala i manga Hudyo ide a katalo de Hisus a Katabeng yu a an te kasalanan, a eya a Pinangako yu a Kristo. ");
INSERT INTO due_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Misan i yinadi de a inon ay nappaayun ngani de belak yu pa nun tagibu. ");
INSERT INTO due_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nano Panginoon ay pagelawagin yu i gebelak ide dikami ni malot kanya tabengan yu ikami tangani te tibong kami a innawa a gesabi ni surut yu de kaagtaan ide. ");
INSERT INTO due_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Paabuya yu pala i kapangyedihan yu a gepapiyon ni te manga orom ide pati magpayedi kamo dikami ni gepakataka pati tande ide de ngalan ni Hisus a Anak yu.” ");
INSERT INTO due_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkapanalangin de ay kasta yinumogyog de beloy a pinagpolongan de dingan napino ide ni Ispiritu nun Makedepat kanya matibong i innawa de a gesabi ni surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nano ay i manga gepanulusun ide ay nagkaeisin a innawa pati an peesip ni belang isin dide a i adi ni isin ay diya la ta inon ay adi de a pesan. ");
INSERT INTO due_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ta i mag-aatid ide ay te kapangyedihan a masakut a gepamatud tungkul de pagkaedup a liwet ni Hisus pati nagkaduman ide a pesan ni hanga a kosa a tabeng ni Makedepat. ");
INSERT INTO due_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ta an te naghedep dide ta pinanggetang ni belang te beloy pati putok inon ta i kapanggetangan de ");
INSERT INTO due_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ay binoy de de manga mag-aatid ide. Dingan binuluboy de pan de manga gepanulusun ide a nappaayun de kaelangan de. ");
INSERT INTO due_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Maginon pala i yinadi ni Hose a angkan ni Lebi a tage Pugu a Kipre misan ay nginalanan eya ni mag-aatid ide a Bernabi a i buot a sasabi a migtabeng. ");
INSERT INTO due_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Pinanggetang na ngani i putok na ta dingan binoy na i kapanggetang na de mag-aatid ide. ");
INSERT INTO due_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Te duman pala a magkálaki a nanggetang ni putok de. I ngalan nun lalaki ay i Ananias ta un mahuna pan ay i Sapira. ");
INSERT INTO due_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Misan ay un kapanggetangan pan nun putok de ay tinagu de un kakmukan ta inon i kasungduan de, magkálaki ta i binoy de la de mag-aatid ide a magi pesan ay un nattide la. ");
INSERT INTO due_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ta sinabi ni Pedro de Ananias, “Bekot ta pinabiyaan mo i Satanas a te kapangyedihan dikaw? Ta nagbutil ka pa de Ispiritu nun Makedepat ta tinagu mo i kabinsa ni kapanggetangan ni putok mo. ");
INSERT INTO due_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ta nun am mo pa pepanggetang un putok mo ay dikaw la ta nano pala a napanggetang mo di ay dikaw pam pala i kapanggetangan na kanya bekot ta yinadi mo inon? Talage a ang ka dikami nagbutil ta de Makedepat pan la.” ");
INSERT INTO due_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dingan pagkaikna ninon ni Ananias ay nabegsak di a nalibun di a tuloy ta i pesan a nakabereta ninon ay nagkaduman ide ni hanga a takut. ");
INSERT INTO due_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ta nagiinuddi i minangának ide duman ta tiningos de i bengkay na a inadde de de panaporan diya. ");
INSERT INTO due_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pagkatakig ni manga tiluwon a odes ay sinumilong pala i bebi na misan ay an na la katinggesan i sinumapit de kalakian na. ");
INSERT INTO due_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ta tambing eya a pinakisurotan ni Pedro ta sinabi na, “Magsabi ka ni matud. Matud man a i oyo la i kapanggetangan ni putok yu?” Ay dingan eya ay tinubeg nun mahuna, “Ay-o, iwina ngan la.” ");
INSERT INTO due_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kanya sinabi diya ni Pedro, “Bekot ta pinagkasungduan yu a sinubukan i Ispiritu nun Makedepat ta pagelawagin mo ta gedetong di un nagtapor ide nunde bebi mo ta nano ay ikaw pala i nosunud a tatapor.” ");
INSERT INTO due_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ta nabegsak ngani i Sapira a nalibun di de kasagkaden ni Pedro. Nano ay nun sinumilong i minangának ide ay kinta de a nalibun di eya kanya inadde de a tinapor de pala eya de alane ni bebi na. ");
INSERT INTO due_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kanya i pesan a manga gepanulusun a kapolongan ay nagkaduman ni hanga a takut pati pesan a nakabereta ni nangyedi a inon. ");
INSERT INTO due_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Makmuk a gepakataka pati manga tande i yinadi ni mag-aatid ide de pekita ni kaagtaan ide ta ugnay a gepolong i gepanulusun ide de betalán ni Hari a Solomon a gekàeisin a innawa. ");
INSERT INTO due_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ta i an ide gepanulusun ay an nangahas a nakipagpolong dide misan ay i pesan a kaagtaan ay gegelang de manga gepanulusun ide. ");
INSERT INTO due_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ta gemakmuk pa i lalaki pati mahuna a gepanulusun de Panginoon. ");
INSERT INTO due_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kanya i te manga orom ide ay peadde de de karsade a pepuoy de pig-eden de ide tangani pagsila ni Pedro ay nakalinonganan ide ni anino na misan tipide de te manga orom ide. ");
INSERT INTO due_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nagidinatong pala i kaagtaan, a inumapo de bulubenwaan a palebut ni Herusalem, a te manga adde ni te orom pati te manga libong de lawes de ta inon a pesan ay pinumiyon la. ");
INSERT INTO due_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Misan ay dehil de pagyedi a inon ni mag-aatid ide ay pagkagengsaan ide a masakut ni pinakaponu a maghahandug pati kakoloy na a i manga Saduseo ide. ");
INSERT INTO due_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kanya pinadekop de a binilanggo a tuloy i mag-aatid ide. ");
INSERT INTO due_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Misan ay nun abi pan a inon ay kinayesan ni anghel ni Panginoon i pintohan ni bilanggoan dingan ide ay pinabulwag na ta sinabi na, ");
INSERT INTO due_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Tumotul kamo di a kumang de beloy a pighandogen de Makedepat ta magsabi kamo duman ni tungkul de edup a oyo a bowon a geapo de Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ta tinumalinga pan ide kanya nun abiabi pa ay sinumilong ide de beloy a pighandogen de Makedepat a nagtodu ide. Nano ay nagpolong pan i pinakaponu a maghahandug pati kakoloy na ide ta pinakangan de pan i kapolongan ide a Hudyo pati pesan a pinakamatande ide dingan pinakangan de pala i nabbilanggo ide. ");
INSERT INTO due_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Misan ay pagdetong pan ni magbebentay ide de bilanggoan ay an di kaduman i mag-aatid ide kanya inumampulang ide ta sinabi de, ");
INSERT INTO due_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ay kinta mi a nàabetan a mahigpit i bilanggoan pati kauluuddi la duman i magbebentay ide misan ay nun kinayesan mi ay an di kaduman i nabbilanggo ide.” ");
INSERT INTO due_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nano ay nun iknain yo ni pinakaponu a maghahahandug, ponu ni magbebentay ide de beloy a pighandogen pati ponu ide ni maghahandug ide ay nalito ngani i esip de ta ide ay natulutantoan a sinabi de, “Ano man i nangyedi de agta ide a pinabilanggo tam?” ");
INSERT INTO due_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Misan ay te dinumatong pan a nagsabi dide a, “I manga lalaki a pinabilanggo yu ay duman ide de beloy a pighandogen de Makedepat a getodu de manga agta.” ");
INSERT INTO due_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pagkaikna de ninon ay kinumang i ponu ni magbebentay ide a kakoloy na i magbebentay ide ta inikag de i mag-aatid ide de pinakamatande ide a Hudyo misan ay an de pinaapdisan ta nagkatakut ide a kati bonglagin ide ni manga agta a gegelang de mag-aatid ide. ");
INSERT INTO due_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nano ay nun maikag de i mag-aatid ide de kapolongan a Hudyo ay sinabi dide ni pinakaponu a maghahandug a magioyo, ");
INSERT INTO due_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Sinablow mi ikamo a wet kamo di magtodu ni tungkul de kapangyedihan ni ngalan ni Hisus misan ay ang kamo nanulusun a unabis dikami ta nano pan ay kinumálat di i pagtodu yu de pesan a Herusalem. Ta pesabi yu pa a ikami i namahala de pagkalibun ni Hisus.” ");
INSERT INTO due_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dingan tinumubeg ide Pedro pati kakmukan a mag-aatid a, “Yadi pa a tumalinga kami ngona de Makedepat a wet di de agta la. ");
INSERT INTO due_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ta nun bunoin yu i Hisus a pinapakuan yu de padipa ay dingan pinakaedup eya a liwet ni Makedepat a pinanulusonan ni kaapoapohan tam ide. ");
INSERT INTO due_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ta nano ay pinaditas eya ni Makedepat de awenan na a te kapangyedihan pala ta eya ay i Ponu pati Magliligtas tangani i misan ino a Hudyo a gesosol ay pakeeyenan na ni mammalotin. ");
INSERT INTO due_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ikami i gepamatud de pesan a oyo pati Ispiritu na pala a peboy na de belang getalinga diya.” ");
INSERT INTO due_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ay nun iknain ni gepolong ide i surut a inon ay nagbulas ide a masakut ta buot de a pobuno tebe i mag-aatid ide. ");
INSERT INTO due_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Misan ay inumuddi i isin a Pariseo de kapolongan a te ngalan a Gamaliel ta eya ay magtutodu ni pagdodul ide a pegelang ni pesan ta dinodul na a pabulwagin ngona i mag-aatid ide. ");
INSERT INTO due_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ta sinabi na dide, “Manga Hudyo, esipin yu ngona ti piyon o eyen i yeyedi yu de agta ide a iwina. ");
INSERT INTO due_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Am pa nagkaaloy ay tinumanga i te ngalan a Tadyes a pesabi na a eya kon ay te kapangyedihan misan ay eyen. Ta eya ay nakaákit ni apat a dian a mag-aadel na misan ay nun eya ay binuno ay nakulukiblagen di i mag-aadel na ide. Ay naeyenan di ni kabuluhan i pagtodu na. ");
INSERT INTO due_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pagkatapos ninon nun panahon a gepalista i pesan a agta ay tinumanga pan di i Hodes a tage Galilea. Ta eya ay nakaákit pala ni makmuk a agta misan ay nun eya ay malibun ay nakulukiblagen di pala i pesan na a mag-aadel. ");
INSERT INTO due_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kanya pesabi ko dikamo a para de iwina ide a agta ay wet yu ide ilengan ta pabiyaan yu ide ta be i pagyedi de a oyo ay geapo de agta la ay mandeli di a neeyenan ni kabuluhan. ");
INSERT INTO due_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Misan ay be i pagyedi de a oyo ay geapo de Makedepat ay an yu ide natalo ta napa ni kalaben yu pan i Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kanya tinumalinga ide de sinabi ni Gamaliel dingan sinilong de a liwet i mag-aatid ide ta pinalapdit a pinagsabian a mahigpit a wet di ide magsabi ni tungkul de kapangyedihan ni ngalan ni Hisus. Ta dingan pinakábutan de ide. ");
INSERT INTO due_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Misan ay pagkatotul de ay nagkasalig ide a masakut a ide i nagkaddepat a te pagkakataon a getiis ni libek dehil de ngalan ni Hisus. ");
INSERT INTO due_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ta adow adow ay gekang ide de beloy a pighandogen de Makedepat pati de pesan a binaloybeloy de a getodu pati gesabi a i Hisus ngani i Kristo a Pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nun panahon a inon ay gemakmuk di i mag-aadel ide misan ay getampo pan i Hudyo ide a gesurut ni Griego de Hudyo ide a gesurut ni Hebreo ta pesabi ni gesurut ni Griego a pekolang kon i peboy a pápangan de belo de a mahanain. ");
INSERT INTO due_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kanya nun maginon ay pinaolangan ni Sangpuwu pati Aduwa i manga mag-aadel ide ta sinabi de a, “An depat a netimok kami a gesabi ni surut nun Makedepat tangani makapamoy kami la ni pápangan adow adow. ");
INSERT INTO due_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kanya manga kabinsa, mameta kamo ni pito a lalaki dikamo a un peabuyenan yu a masépag a geyedi ni piyon a te katinggesan, a napino pala ide ni Ispiritu. Ta ide ngani i yeyedi mi a te tungkolin ni oyo. ");
INSERT INTO due_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ta ikami pan ay depat a nappahande kami ni pesan a panahon de pagpanalangin pati de pagtodu ni surut nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ay nasalig i pesan a gepanulusun nun iknain de i sinabi a inon kanya pineta de i Isteban ta eya i te pagpanulusun a matibong pati eya ay napino ni Ispiritu nun Makedepat. Pineta de pala i Pilepi, Prokoro, Nikanor, Timon, Parmenas pati Nikolas a tage Antiokia ta i Nikolas ay nagpanulusun ngona de pagpanulusun a Hudyo dingan de Hisus. ");
INSERT INTO due_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ta ide ay inikag de de mag-aatid ide ta dingan tinapá de a pinanalangin i pito a nápeta. ");
INSERT INTO due_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nano ay gekálat a tuloy i surut nun Makedepat pati gemakmuk di i mag-aadel ide duman de Herusalem ta i maghahandug ide ay makmuk di pala i gepanulusun. ");
INSERT INTO due_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","I Isteban ay nagkaduman ni kapangyedihan pati hanga a kosa a tabeng ni Makedepat kanya eya ay nakayedi ni gepakataka pati tande de pekita ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nano ay te duman a agta ide de Herusalem a nagpolong de “Kapolongan ni Pinalaya Ide” a manga tage benwaan a Sirene, Alehandria, tage sákup pala ide ni Silisia pati Asia. Ta nakipagtalo ide de Isteban. ");
INSERT INTO due_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Misan ay natalo ide ni Isteban dehil de katinggesan a peboy diya ni Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kanya dehil de inon ay binayeden a nattagu ni natalo ide i tipide a agta tangani magbutil kanya binintang ni gebutil a, “Inikna mi a nagsabi i agta a iwina ni an te gelang de Makedepat pati de Moises.” ");
INSERT INTO due_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Maginon ay pinapagbulas ni natalo ide de Isteben i pinakamatande ide, magtutodu ide ni Hudyo pati kaagtaan ide. Kanya eya ay dinakop de ta dingan inikag de eya de kapolongan a Hudyo. ");
INSERT INTO due_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ta nangikag pala ide ni gepamatud ide a butelan ta sinabi ni gebintang, “I oyo a agta ay gesabi a ugnay ni an te gelang de pagdodul ide nun Makedepat pati ang kon te kabuluhan i beloy a pighandogen de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pesabi pala ni agta a oyo a i oyo a beloy a pighandogen ay sesede ni Hisus a tage Nasarit dingan lelewesan kon ni Hisus i ugeli tam a binoy ni Moises.” ");
INSERT INTO due_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nano ay nun i Isteban ay pinakalawag ni pesan de kapolongan ay i mukha na ay gepakaingap a magi mukha ni anghel. ");
INSERT INTO due_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Dingan eya ay tinanto ni pinakaponu a maghahandug a magioyo, “Matud man i pesan a inon a sinumbong de dikaw?” ");
INSERT INTO due_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ta dingan eya ay tinumubeg, “Manga kamoddenan pati manga kabinsa, patalikngan yu i sasabi ko a oyo. I Makedepat a Makapangyedihan de pesan ay nagpakita de kaapoapohan tam a Abraham, nun eya ay nappataan pa de sákup ni Mesopotamia a am pa getaan de benwaan a Haran. ");
INSERT INTO due_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Sinabi ni Makedepat de Abraham, ‘Tumotul ka di a walatin mo di i bensa mo a oyo pati mangáyun mo ta kumang ka de lugel a totodu ko dikaw.’ ");
INSERT INTO due_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kanya tinumotul dingani ide Abraham de lugel a Kaldeo ta tinumaan ide de Haran. Nano ay pagkalibun ni ama na ay pinakang pan di eya ni Makedepat de putok á oyo a kataanan tam di nano. ");
INSERT INTO due_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nano ay am pa eya biniyen ni Makedepat ni misan untik a mana a putok ta pinangako la diya ni Makedepat, nun am pa te anak i Abraham, a boboy na yo diya pati de mangápo na. ");
INSERT INTO due_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ta sinabi diya ni Makedepat, ‘Nekitaan ngona i mangápo mo de kakmukan a bensa ni apat a dian a taon ta duman aalepin ide pati pehedepan. ");
INSERT INTO due_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Misan ay podusahan ko i kaagtaan de inon a bensa a gealepin dide ta pagkatapos ninon ay pototul ko duman i mangápo mo ta dio ide gepodi deko.’ ");
INSERT INTO due_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ta dinodul ni Makedepat de Abraham a depat a gepapelat eya de lawes na ta inon ngani i tande a nakipagkasungdu di i Makedepat diya. Kanya pan nun walo pa a adow i anak na a i Isak ay pinelatan di ni Abraham. Maginon pala i yinadi ni Isak de anak na a Hakob. Maginon pala i yinadi ni Hakob de sangpuwu pati aduwa a mangának na a kaapoapohan tam. ");
INSERT INTO due_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“I Hose a isin de sangpuwu pati aduwa a mangának ide ni Hakob ay kinagengsaan ni manga kaka na a kaapoapohan tam kanya pinanggetang de eya a napa ni alepin de bensa a Ihipto misan ay inalagean eya ni Makedepat. ");
INSERT INTO due_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ta linigtas eya ni Makedepat de pesan a kahedepan na pati dehil de tabeng ni Makedepat ay napa ni naketingges eya, a kinasalegen pa nun Hari de Ihipto kanya eya ay yinadi nun Hari a gubernador de pesan a Ihipto pati de pesan a nappataan de beloy na a hanga. ");
INSERT INTO due_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nano ay nun nanon ay nagkaduman ni hanga a tigtegeng pati pagtiis de bensa a Ihipto. Maginon pala de Kanaan ta an te napangamitan ni pápangan i kaapoapohan tam ide. ");
INSERT INTO due_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kanya nun mabereta ni Hakob a te trigo de Ihipto ay pinakang na duman i kaapoapohan tam ide a i mangának na. ");
INSERT INTO due_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nano ay nun káduwa di a pagkang de ay nagpaabuya di i Hose de manga kabinsa na ide ta kinatinggesan pan nun Hari i tungkul de kamittanak ide ni Hose. ");
INSERT INTO due_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ta pinakangan ni Hose i ama na a Hakob pati pesan a mangáyun de. I kamakmuk de ay pito a puwu pati lima. ");
INSERT INTO due_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kanya kinumang i Hakob de Ihipto ta duman di eya nalibun. Maginon pala i kaapoapohan tam ide. ");
INSERT INTO due_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Misan ay i bengkay de ide ay inadde la de Sikem a lugel a den ni Hakob ta pinuoy i bengkay de de gob a ginatang ni Abraham de mangának ni Hamor a tage Sikem. ");
INSERT INTO due_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nano ay nun máloy di a masakut ay mandeli di a nádetong a pamatoden di ni Makedepat i pinangako na de Abraham ta nun nanon pala ay gemakmuk di a masakut i Hudyo ide de Ihipto. ");
INSERT INTO due_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Misan ay te hari pan de Ihipto a an te katinggesan a unabis a tungkul de Hose. ");
INSERT INTO due_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ay linolong nun hari a oyo i kasi Hudyo tam ide pati pinelit na a pinabut de kaapoapohan tam ide i kilasaan de ide a lalaki tangani malibunin. ");
INSERT INTO due_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nano nun panahon a inon ay pinanganak di i Moises a kinasalegen ni Makedepat ta eya ay inalagean ni kamoddenan na ide ni tiluwon a bulan. ");
INSERT INTO due_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nun eya ay binut di ni kamoddenan na ide ay inalagean pan eya ni mahuna a anak nun hari ta pinahanga na a magi anak na a sadili. ");
INSERT INTO due_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ta pinapag-adel eya ni pesan a katinggesan de Ihipto kanya pan eya ay te katinggesan a masakut de pagsurut na pati de pagyedi pala. ");
INSERT INTO due_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nano ay nun eya ay apat di a puwu a taon ay naisepan na a kakangan i manga kabinsa na ide a mangápo ni Israel tangani kitain na a ti papalano i kapuoyen de. ");
INSERT INTO due_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kanya nun kitain na a pelolong ni isin a tage Ihipto i isin a Hudyo ay tinabengan na un pelolong ta binuno na ngani un tage Ihipto. ");
INSERT INTO due_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Inesip di ni Moises a katinggesan di ni manga kabinsa na ide a Hudyo a leligtas dide ni Makedepat de padean na misan ay an de mangani kinatinggesan. ");
INSERT INTO due_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nun kinábiabian di ay kinumita eya ni aduwa a Hudyo a gegebuk ta binout na ide a aawakan tebe kanya sinabi na, ‘Bekot ta gegebuk kamo? Ay padepade kamo pan a Hudyo.’ ");
INSERT INTO due_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Misan ay tinongog eya nun matapang ta sinabi na, ‘Bekot ta gepakilabot ka dikami? Ay am mi pan ikaw ponu a depat a geawak dikami. ");
INSERT INTO due_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Makati buot ok mo pan a bobuno a magi binuno mo dipun i tage Ihipto?’ ");
INSERT INTO due_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nano ay nun iknain ni Moises inon ay natakut eya a masakut a linumimok de Ihipto, a nakitaán eya de bensa a Midian. Ta duman ay nagkabebi eya pati nagkaanak eya ni aduwa a lalaki. ");
INSERT INTO due_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nun makatakig di i apat a puwu a taon ay kinumang i Moises de lugel a ilang a alane de Kalasan a Sinai ta duman ay nagpakita diya i anghel di isin a kew a masidong a gedilab a an nagkasabsab. ");
INSERT INTO due_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Misan ay pagkákita ni Moises ay nagtaka eya a masakut ta paglane na a pelawag na ay dingan inikna na i surut nun Panginoon. ");
INSERT INTO due_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ta sinabi ni nagsurut, ‘Ako i Makedepat a pepodian hanggen nano nide Abraham, Isak, Hakob pati pesan a kaapoapohan yu ide.’ Ta i Moises pan ay gekinkin di ni takut pati an gepakasalepat duman. ");
INSERT INTO due_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dingan sinabi diya ni Panginoon, ‘Ukasin mo i paragetus mo na ta i kasikaden mo na ay de kasagkad ko a an te mammalotin. ");
INSERT INTO due_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ako ay dinumio tangani ligtasin ko i mangának ko a Hudyo de bensa a Ihipto ta pekita ko a ugnay i malot a pagyedi dide ni tage Ihipto ide ta peikna ko pala i pagpanalangin de deko kanya nano ay dododul ko ikaw duman.’ ” ");
INSERT INTO due_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Sinabi ni Isteban a tuloy, “Talage a kinapoyen ni Hudyo ide i oyo a Moises ta sinabi de, ‘Ay am mi pan ikaw ponu a depat a geawak dikami.’ Misan ay i Moises pan ay dinodul ni Makedepat a nappa ni ponu ni Hudyo ide a nanleligtas dide de padean ni anghel a kinta na nunde kew a gedilab a an nagkasabsab. ");
INSERT INTO due_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kanya i Moises ngani i ponu de a nangikag dide gepo de Ihipto ta yinadi na i gepakataka pati tande de Ihipto, de Atab a Maderag pati de lugel a ilang ni apat a puwu a taon. ");
INSERT INTO due_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","I Moises pala a oyo i naghola de Hudyo ide a, ‘I Panginoon a Makedepat ay nemeta ni magi ako ni isin a magsasabi de manga kasi Hudyo yu ide.’ ");
INSERT INTO due_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Eya pala i kakoloy ni Hudyo ide a kapolongan de lugel a ilang ta diya pala pati de kaapoapohan tam ide, nakisurut i anghel nun Makedepat de Kalasan a Sinai. I Moises pala a oyo i tinumanggep ni surut nun Makedepat a te kapangyedihan tangani magpatalikngoy kitam a manga Hudyo. ");
INSERT INTO due_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Misan ay an nagtalinga de surut ni Moises i kaapoapohan tam ide ta an de eya sinapot, a binuot de pa a náampulang de Ihipto. ");
INSERT INTO due_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ta nun duman pa i Moises de Kalasan ay sinabi ni kaapoapohan tam ide de Aron a maghahandug a tagibu a, ‘Magyedika ni makedepat ide a popodi mi ta i Moises a inon a nangikag dikami gepo de bensa a Ihipto ay ti deno di.’ ");
INSERT INTO due_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kanya nagyedi ide ni magi anak a beka dingan ide ay naghandug de inon ni manga paaged a hayup a binuno, a nagkasalig a masakut dehil de makedepat de a an matud a yinadi de. ");
INSERT INTO due_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ta kinapoyen ide ni Makedepat a pinabiyaan na ide a magpodi de adow, bulan pati butatala ide. Ta te duman de kasulatan ni magsasabi ide i hinola de a geapo de Makedepat a magioyo, ‘Ikamo a mangápo ni Israel ay an la ako i pehandogen yu ni manga paaged ide de lugel a ilang ni apat a puwu a taon. ");
INSERT INTO due_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ta nagpodi kamo de makedepat ide a an matud a yinadi yu pati pinauluadde yu i beloy ni Molok a madedepat a an matud pati butatala a makedepat yu a an matud a i Repan. Kanya pototul ko ikamo a paagow de dibelew pa ni bensa a Babilonia.’ Inon i hinola a geapo de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Nano de lugel a ilang ay te duman a untik a beloy a pighandogen de Makedepat i kaapoapohan tam ide ta inon i belak na. Kanya inon a beloy ay yinadi a nappaayun de pinakita ni Makedepat de Moises. ");
INSERT INTO due_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nun malibun di i Moises ay i Hosue pan i napa ni ponu ni kaapoapohan tam ide ta dingan la sinumilong ide a te adde ni untik a beloy de lugel tam i a Hudia, nun mapatotul di ni Makedepat un nappataan ide dio a tagibu. Maginon dila hanggen dinumatong i Hari a Debid. ");
INSERT INTO due_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","I Debid pala ay nagkaduman ni hanga a kosa a tabeng ni Makedepat kanya inaged na a magioyo, ‘Makedepat ko a pepodian ni Hakob, buot ko ay makayedi ok ni beloy a pighandogen dikamo.’ ");
INSERT INTO due_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Misan ay an nayedi ni Debid i beloy a inon ta i nagyedi pan ay i anak na a i Solomon. ");
INSERT INTO due_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Misan pan ay an getaan i Makedepat a Pinakamaditas de beloy a yinadi ni agta la ta i oyo ay nappaayun de sinabi ni magsasabi a, ‘Gepayin i Panginoon a Makedepat a, ");
INSERT INTO due_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","i langot i piglipaan ko ta i putok pan i pesikaden ni singit ko kanya an nappatud a nátaan ok de beloy a yinadi la ni agta ta anok gepaimloy dio de putok i. ");
INSERT INTO due_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ta i pesan pan i ay ako i nagyedi.’” ");
INSERT INTO due_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sinabi a tuloy ni Isteban, “Talage a maksa i innawa yu ta an yu buot a getalinga de Makedepat. Ikamo ay magi kaapoapohan yu ide ta pekapoyen yu a ugnay i Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","I pesan ngani a magsasabi ay yinadian ni malot ni manga kaapoapohan yu ide ta binuno de pan i nanhola ide de pagdetong ni Katabeng na a an te kasalanan ta ikamo pan i nagpadekop diya a binuno a tuloy. ");
INSERT INTO due_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Misan ay tinanggep yu pan i pagdodul ide ni Makedepat de padean ni manga anghel ide ay an yu non tinalingaan.” Inon i sinabi ni Isteban. ");
INSERT INTO due_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nano ay nun iknain non ni kapolongan a manga ponu ni Hudyo ide ay nagengsa ide a masakut de Isteban ta inumaratengot i ngipon de gepo de gengsa de. ");
INSERT INTO due_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Misan ay napino pan i Isteban ni Ispiritu nun Makedepat ta eya ay tinumingala de langot, a kinta na i Hisus a gelipa de awenan nun Makedepat a te gepakaingap de palebut de. ");
INSERT INTO due_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sinabi ni Isteban, “Pagelawagin yu ngani ta nakayesan di i langot ta pekita ko i Pineta nun Makedepat a napa ni agta a gelipa de awenan na.” ");
INSERT INTO due_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Misan ay rinumésag ide a tinaklopan de i talinga de dingan maparipari a dinakop de i Isteban. ");
INSERT INTO due_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ta inuwey de eya hanggen de ditow ni benwaan a bobonglag de ta dingan i gepamatud ni malot tungkul de Isteban ay nag-ubed ni bedu de ta winalat de de alane ni lalaki a malakas a te ngalan a Saulo. ");
INSERT INTO due_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ta binulubonglag de i Isteban a gepanalangin a magioyo, “Panginoon a Hisus, tanggepin yu di i kaleduwa ko.” ");
INSERT INTO due_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dingan eya ay linumuhud ta inumolang ni malagdu, “Panginoon, pakeeyenan yu ide ni kasalanan de de yinadi de a oyo.” Ta pagkasabi na ninon ay napugtusan di. ");
INSERT INTO due_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","I Saulo a te ngalan a Pablo ay nagkasalig de pagkalibun ni Isteban. I bengkay pan ni Isteban ay tinapor ni gegelang ide de Makedepat ta ide ay nagtangos a masakut. Nano gepo de adow a inon ay pinahedepan i manga gepanulusun a kapolongan de Herusalem. Ta napakálat ide de kulukaginglan ni sákup ni Hudia pati de Samaria puwide la i mag-aatid ide. ");
INSERT INTO due_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ta i Saulo pan a te ngalan a Pablo ay binuot na a sedein i manga kapolongan ide a gepanulusun de Hisus. Eya ay gekasilong de manga beloy de tangani uweyin na a bilanggoin a tuloy i mahuna pati lalaki a gepanulusun de Hisus. ");
INSERT INTO due_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nano ay i manga gepanulusun a napakálat ay misan deno ide makadetong ay gesabi ide ni piyon a bereta tungkul de Hisus. ");
INSERT INTO due_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ta i Pilepi pan ay dinumolug de isin a benwaan a sákup ni Samaria a gesabi ni piyon a bereta a tungkul de Kristo. ");
INSERT INTO due_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ta nun mabereta pan ni manga agta pati kinta de i peyedi na a gepakataka ay nagpatalikngoy ide a piyon a pesan de pesabi na. ");
INSERT INTO due_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pati i libong ide de lawes ni manga agta ay gelayu a geolang ni malagdu pati makmuk pala a lungpo, pilay i pinumiyon. ");
INSERT INTO due_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kanya de benwaan a inon ay nagkaduman ni hanga a kasalegen. ");
INSERT INTO due_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Misan ay te duman pan a lalaki a te ngalan a Simon a magsasalamangka de inon a benwaan kanya nagtaka diya i tage bensa a Samaria pati pemayabeng na a eya kon ay te kapangyedihan a masakut. ");
INSERT INTO due_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kanya eya ay pinanulusonan ni tage duman ide misan i te kapangyedihan man o eyen. Ta eya ay pengalan de a “Makapangyedihan a Magi Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Talage ngani a nagpatalikngoy diya i kaagtaan ta náloy a getaka ide de pagsalamangka na. ");
INSERT INTO due_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Misan ay nun magsabi pan i Pilepi duman ni piyon a bereta a tungkul de Hisu Kristo pati ti papalano a te kapangyedihan i Makedepat de innawa ni agta ay nagpanulusun i mahuna pati lalaki a lininod a tuloy. ");
INSERT INTO due_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ta pati i Simon ay nagpanulusun pala kanya nun eya ay malinod di ay ugnay di eya a gekoloy de Pilepi ta nagtaka eya nun kinta na i gepakataka pati manga tande a yinadi ni Pilepi. ");
INSERT INTO due_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nano ay nun mabereta nun mag-aatid ide de Herusalem a tinanggep di ni manga tage Samaria ide i surut nun Makedepat ay dinodul de i Pedro pati Huwen a kumang duman. ");
INSERT INTO due_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagdetong de duman ay pinanalangin de i gepanulusun ide a tage Samaria tangani tanggepin de pala i Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ta lininod di ide de orat a tande de pagpanulusun de de Panginoon a Hisus misan ay am pa gelusong de belang isin dide i Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Dingan nun tinapá ni Pedro pati Huwen ni kumot de i gepanulusun ide ay tinanggep de ngani i Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nano ay nun kinta ni Simon a dehil de pagtapá ni mag-aatid ide ay napa de agta i Ispiritu ay binuot na tebe a gegetang ni kuwarta i kapangyedihan nide Pedro pati Huwen. ");
INSERT INTO due_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ta sinabi na dide, “Biyen ok yu pala ni kapangyedihan a iwina tangani i belang tatapá ko ay nátanggep pala ni Ispiritu nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Misan ay sinabi diya ni Pedro, “Be maginon ay naddugeng ka de kuwarta mo a nabbut de impiyerno ta bekot ta buot mo a gegetang ni kuwarta i Ispiritu nun Makedepat a peboy na pan la a an te beyed. ");
INSERT INTO due_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Talage a ang ka te kabinsa de oyo a paaged ni Makedepat ta de pekita na ay an piyon i naddeinnawa mo. ");
INSERT INTO due_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kanya magsosol ka di de oyo a mammalotin mo, a manalangin ka de Panginoon a Makedepat ta makati pakeeyenan na la ikaw ni oyo a malot a belak mo. ");
INSERT INTO due_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Katinggesan ko a nagkesinna ka a masakut ta alepin ka pa ni mammalotin mo.” ");
INSERT INTO due_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kanya sinabi diya ni Simon, “Be maginon ay manalangin kamo de Panginoon para deko tangani wet ok di magkaduman ni pesan a sinabi yu ide a padusa.” ");
INSERT INTO due_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pagkatapos a nagpamatud ide Pedro pati Huwen ni surut nun Panginoon ay inumampulang ide de Herusalem ta sinumulusagid ide de buluberiyu a sákup ni Samaria ta nagpamatud pala ide ni piyon a bereta a tungkul de Kristo. ");
INSERT INTO due_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nano ay nun nanon a panahon ay i Pilepi pan ay pinagsabian ni isin a anghel ni Panginoon a magioyo, “Kumang ka a tambing de kadepit a temog a dumolug gepo de Herusalem a paagow pan de benwaan a Gasa. I oyo ay lugel a ilang.” ");
INSERT INTO due_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kanya eya ay kinumang ngani duman. Nano ay gedetong pan i isin a tage Etiopia a ponu ta eya i gepamahala de pesan a kayamanan ni Reyna na a Kandes. Eya ay inumapo de Herusalem a nagpodi de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pauli di eya a nappasakoy de sakoyen na ta gebesa eya ni kasulatan ni Isais a magsasabi a den. ");
INSERT INTO due_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Dingan sinabi ni Ispiritu de Pilepi, “Sumakoy ka de sakoyen a iwina.” ");
INSERT INTO due_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kanya pan ginumikan i Pilepi a paagow de sakoyen ta inikna na a pebesa nun tage Etiopia i kasulatan ni magsasabi a Isais kanya tinanto na un gebesa, “Katinggesan yu man i pebesa yu na?” ");
INSERT INTO due_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Misan ay tinumubeg pan un gebesa, “Ti papalano man a ketinggesan ko be am pan te gepatingges deko?” Dingan inakit na i Pilepi a sumakoy pala kanya sinumakoy pan i Pilepi ta linumipa de alane na. ");
INSERT INTO due_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","I behagi ni kasulatan a pebesa na ay i oyo, “Ti papalano a an geoni i topa a peuwey de pigbunoan o i anak a topa a peuwey de pig-ahetan ay maginon pala i Katabeng nun Makedepat ay an náyamyam be eya ay dedekop. ");
INSERT INTO due_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ta eya ay an ginalang ni manga agta ide, a pinadusahan pa misan an te kasalanan. Pati an te naketingges a ti papalano a hanga inon a mammalotin ni kaagtaan nun nanon a panahon ta binuno de eya.” ");
INSERT INTO due_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nano ay sinabi nun gepamahala de Pilepi, “Sabiin yu tebe deko. Ti ino i buot a sasabi ni magsasabi, i sadile na o te duman pa a kakmukan?” ");
INSERT INTO due_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kanya nano ay te gepo i Pilepi de inon a behagi a gesabi diya ni piyon a bereta a tungkul de Hisus. ");
INSERT INTO due_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Misan ay tuloy la i pagtotul de kanya dinumatong ide de lugel a te orat ta sinabi nun gepamahala, “Pagelawagin yu ta te orat dio. Nappatud man di a lelinod ok mo?” ");
INSERT INTO due_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“Aysa, be gepanulusun kamo a matud nano.” Ay tinumubeg un gepamahala, “Talage a gepanulusun ok a i Hisu Kristo ay Anak nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kanya pinatimok na un sakoyen na a dinumolug ide a paagow nunde orat ta dingan lininod eya ni Pilepi. ");
INSERT INTO due_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nano ay pagkasaka de ay loktat a inalis ni Ispiritu nun Panginoon i Pilepi kanya an di eya kinta ni tage Etiopia ta sinumakoy la de sakoyen na a nagkasalig a masakut. ");
INSERT INTO due_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ta i Pilepi pan ay duman di makatingges ni pagkaagta na de benwaan a Asoto ta gepo duman ay nagsabi eya ni piyon a bereta tungkul de Hisus de bulubenwaan hanggen dinumatong eya de benwaan a Sesarea. ");
INSERT INTO due_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Dehil de buot ni Saulo a te ngalan a Pablo a pehedepan na a mabuno a tuloy i mag-aadel ide ni Panginoon ay kinumang eya de pinakaponu a maghahandug. ");
INSERT INTO due_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ta inumaged ni solat a aadde na de Damasko de manga pigmitengan a Hudyo duman tangani madekop na i pesan a kinta na a gepanulusun de bowon a pagtodu, mahuna man o lalaki, a pepelit na a eikag ide de Herusalem. ");
INSERT INTO due_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dingan tinumotul ide Saulo a paagow de Damasko misan ay nun ide ay alane di ay loktat a te tinumallang de palebut na a geapo de langot a gepakaingap di a masakut. ");
INSERT INTO due_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ta eya ay napaobbob de putok ta inikna na i surut a malagdu a magioyo, “Saulo, bekot ta peyedian ok mo ni malot?” ");
INSERT INTO due_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nano ay nagtanto i Saulo nunde gesurut, “Ino kamo man, Panginoon?” Ta eya ay tinubeg nun gesurut, “Ako i Hisus a peyedian mo ni malot. ");
INSERT INTO due_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Misan ay umuddi ka di ta kumang ka de benwaan a Damasko ta sasabi dikaw duman i depat a yeyedi mo.” ");
INSERT INTO due_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","I kakoloy pan ide ni Saulo ay tinumimok de pagtotul de a an nakayamyam ta inikna de i nagsurut misan ay am pan ide te kinta. ");
INSERT INTO due_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Dingan inumuddi i Saulo misan nun minumoklat eya ay an di gekakita kanya kinabit dila eya nun kakoloy na ide hanggen de Damasko. ");
INSERT INTO due_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tiluwon a adow a an eya gepakakita, an eya gepangan pati geinom. ");
INSERT INTO due_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nano ay de Damasko pan ay te mag-aadel a te ngalan a Ananias ta eya ay pinagsabian ni Panginoon de pangitaán, “Ananias.” Ta tinumubeg eya, “Aman non, Panginoon?” ");
INSERT INTO due_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Sinabi diya ni Panginoon, “Kumang ka de karsade a te ngalan a ‘Matanus’ ta kangan mo de beloy ni Hodes i Saulo a tage benwaan a Tarso ta eya ay gepanalangin duman. ");
INSERT INTO due_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ta kinta na ikaw, Ananias, de pangitaán a ikaw i nádetong a nanapá diya tangani makakita eya a liwet.” ");
INSERT INTO due_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Misan ay tinubeg ni Ananias, “Panginoon, inikna ko di de kamakmokan i tungkul de malot na a peyedi de manga pineta yu ide de Herusalem. ");
INSERT INTO due_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pati kinumang eya dio de Damasko i, a te adde ni solat a inumapo de ponu ide ni maghahandug ide de Herusalem tangani dekopin na i pesan a gepanulusun dikamo dio.” ");
INSERT INTO due_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Misan ay sinabi diya ni Panginoon, “Kumang ka duman ta pineta ko eya a gepaabuya ni makapangyedihan ko a ngalan de an Hudyo ide, de manga hari pati de manga Hudyo pala ide. ");
INSERT INTO due_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ta pepatingges ko diya i pesan a tetiis na a kahedepan dehil de pagpanulusun na deko.” ");
INSERT INTO due_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kanya kinumang ngan i Ananias a sinumilong nunde beloy ta tinapá na i Saulo a sinabi na, “Kabinsa a Saulo, pinakang ok dio ni Panginoon a Hisus ta eya ngani un nagsurut dikaw nunde bektas a pakang dio tangani makakita ka a liwet, a mapino ka pa ni Ispiritu nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ta tambing dingan la a te nadegdeg de mata ni Saulo a kasta kiskis ta eya ay nakakita di. Dingan eya ay inumuddi ta lininod de orat. ");
INSERT INTO due_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Dingan eya ay namangan a inumampulang la i tibong na. Nano ay eya ay tipide pa a adow a kulukakoloy ni mag-aadel ide de Damasko. ");
INSERT INTO due_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ta eya ay gesilong de pigmitengan ide a nagpamatud tungkul de Hisus ta sinabi na a i Hisus ay Anak a talage nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kanya i pesan a agta a inumikna diya ay nagtaka ide a masakut ta natulutantoan ide, “Aman la i oyo a lalaki i migdekop de Herusalem dide a gepanulusun de inon a ngalan ni Hisus? Kanya pan eya ay dinumio tangani addein na ide a naggepus de ponu ide ni maghahandug ide de Herusalem i pesan dio a gepanulusun a maginon?” ");
INSERT INTO due_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Misan ay namas pa a napa ni naketingges i Saulo de pagsabi na ni piyon a bereta kanya natalo na i Hudyo ide a tage Damasko ta pinamatoden na ngani a i Hisus ay i Kristo a pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nano ay pagkatakig ni makmuk a adow ay nagbelak i Hudyo ide a bobuno de i Saulo ");
INSERT INTO due_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","misan ay natinggesan na pan a eya ay pebentayen de adow pati abi de belang pintohan ni benwaan tangani eya ay bunoin de. ");
INSERT INTO due_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kanya nun isin a abi ay sinakoy eya ni manga mag-aadel na ide de alat dingan hinogus de eya de ditow ni sagbong a beto. ");
INSERT INTO due_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ta pagdetong na de Herusalem ay pinelit na a nakidugeng de mag-aadel ide duman misan ay natakut ide diya ta an de peesip a eya ay kapadepade de di a mag-aadel. ");
INSERT INTO due_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Kanya eya ay inikag ni Bernabi de mag-aatid ide ta binareta na dide a ti papalano a kinta ni Saulo i Panginoon, a nakisurut pala diya nun eya ay duman nunde bektas ta binareta na pala a i Saulo ay matapang de pagsabi na ni tungkul de ngalan ni Hisus duman de Damasko. ");
INSERT INTO due_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kanya kulukakoloy de di i Saulo de Herusalem ");
INSERT INTO due_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","a nagsabi eya duman a matapang ni tungkul de ngalan ni Panginoon. Ta nakipagtalo pa eya de Hudyo ide a gesurut ni Griego kanya te belak ide a bobuno de eya. ");
INSERT INTO due_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nano nun mabereta inon ni manga kabinsa ay inikag de i Saulo a sinumila de benwaan a Sesarea a pauli de benwaan na a Tarso. ");
INSERT INTO due_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kanya pagkatakig ninon ay i pesan a kapolongan a gepanulusun de kulukaginglan ni Hudia, Galilea pati de Samaria ay an te gulo ta inon ide ay tinumibong. Pati gemakmuk ide a getalinga a te manga gelang de Panginoon dehil de tabeng ni Ispiritu na. ");
INSERT INTO due_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nun nanon ay nagbulubiseta i Pedro de manga kabinsa ide a gepanulusun ta eya ay nakadetong hanggen de benwaan a Lida de manga pineta pala duman. ");
INSERT INTO due_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nano ay kinta na duman i isin a lalaki a te ngalan a Eneas a lungpo di ni walo a taon. ");
INSERT INTO due_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Sinabi diya ni Pedro, “Eneas, nano ay pepapiyon ka di ni Hisu Kristo ta umuddi ka a lukutin mo di i pig-eden mo na.” Ta ginumiyos eya a tambing ");
INSERT INTO due_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","a kinta eya ni pesan a nappataan de Lida pati de sákup ni Saron kanya i kamakmokan dide ay nagpanulusun de Panginoon. ");
INSERT INTO due_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Te duman pan de benwaan a Hope a isin a mag-aadel a mahuna a te ngalan a Tabita. De surut a Griego i talage a ngalan na ay Dorkas a te kabuluhan a “usa”. Ta i mahuna a oyo ay migyedi ni piyon a migtabeng de mahedepin. ");
INSERT INTO due_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nun adow a inon ay nagkaorom eya a nalibun a tuloy. Nano nun mapakapiya di i bengkay na ay pinuoy de ditas a kuwarto. ");
INSERT INTO due_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Misan ay an la masakut a alayu de Lida i Hope, ta nun mabereta ni manga mag-aadel a de Lida i Pedro ay pinakangan de de aduwa a lalaki de Lida a pinakisurotan de, “Sumut kamo tebe a tambing dikami de Hope.” ");
INSERT INTO due_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ta sinumut pan dide i Pedro. Pagdetong de ay inikag de eya de kadumanan ni bengkay. Ta dingan linumane diya i mahunain a belo a gepinagtangos ta pinakita de i kulapyaw a anduwonin pati manga bedu a yinadi ni Dorkas para dide nun nàedup pa. ");
INSERT INTO due_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dingan pinabulwag na i pesan a manga agta ta eya ay linumuhud a nanalangin. Nano pagkapanalangin na ay pinagelawag na i bengkay ta sinabi na, “Tabita, gumiyos ka di.” Ta dingan minumuklat dingani un nallibun ta linumipa nun kinta na i Pedro. ");
INSERT INTO due_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ta binolan ni Pedro i kumot na a tinabengan na a inumuddi dingan inolangan na i manga pineta ide pati mahunain ide a belo ta pinakita na i Dorkas a te edup di. ");
INSERT INTO due_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kanya nun mabereta pala non de Hope ay makmuk dingani i nagpanulusun de Panginoon. ");
INSERT INTO due_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ay nagtaan pala i Pedro de Hope ni nulunáloy de beloy ni Simon a magyeyedi gepo de katat ni hayup. ");
INSERT INTO due_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","De benwaan pan a Sesarea ay te isin a lalaki a te ngalan a Kornelio a kapitan ni isin a kompania a manga sundelo de Italia. ");
INSERT INTO due_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I Kornelio ay talage a te pagpanulusun pati gelang a magi Hudyo de Makedepat pati pesan dila a mittanak na. Ta geboy pala eya ni kuwarta na a an mademut de Hudyo ide a mahedepin pati ugnay pala eya a gepanalangin de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nano ay isin a apun a kadepit ay kinta na a talage de pangitaán a sinumilong de beloy na i anghel nun Madedepat. Dingan inolangan eya nun anghel a, “Kornelio.” ");
INSERT INTO due_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ay pinakalawag na eya a nagkatakut a masakut ta tinumubeg eya, “Ano non, Panginoon?” Ay tinubeg nun anghel, “Pagkasalegen ni Makedepat i pagpanalangin mo pati pagtabeng de mahedepin ide. ");
INSERT INTO due_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kanya nano ay manodul ka ni tipide a agta, a nanlalawag de Hope ni Simon a isin a lalaki a te ngalan a Pedro. ");
INSERT INTO due_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ta eya ay nappataan de Simon a magyeyedi gepo de katat ni hayup. Ta i kataanan na a oyo ay de kaginglan ni atab.” ");
INSERT INTO due_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nano pagkatotul nun anghel a nagsurut diya ay inolangan ni Kornelio i aduwa a katabeng na pati isin de sundelo ide a getabeng diya a te gelang pala de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pagkasabi dide ni Kornelio nun sinabi nun anghel ay dinodul na ide de Hope. ");
INSERT INTO due_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nunde sinumunud a adow, a alane di i dinodul ide de Hope ay i Pedro pan ay sinumalakat de ditas a salog tangani duman eya manalangin ta nun nanon ay manga udto di. ");
INSERT INTO due_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ta eya ay nagketigeng di a masakut misan ay nun pehande pa i pápangan ay nagkaduman eya ni pangitaán. ");
INSERT INTO due_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kinta na a nakayesan i langot ta te getayon de alane na a magi kómut a hanga a naggiptan de magtulutimbeng na a lawis. ");
INSERT INTO due_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ta naunid duman i sadisadi a hayup a gepinagtotul, gedeyag de putok pati pesan a gelipad de longaw na. ");
INSERT INTO due_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Dingan inikna na i surut a gesabi a magioyo, “Pedro, umuddi ka di ta mamuno ka dingan mamangan a tuloy.” ");
INSERT INTO due_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Misan ay tinumubeg i Pedro, “Ay wet di, Panginoon, ta misan kapide ay anok gepangan ni misan ano a an malenis pati an nagkaddepat de ugeli mi a Hudyo.” ");
INSERT INTO due_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dingan inikna na a liwet i gesurut ta sinabi na, “Wet mo man esipa a madiplot i linenis di ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ta pakatiluwon non nagsurut dingan binotong di a paditas un magi kómut. ");
INSERT INTO due_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nano ay nun peesip pa ni Pedro i kabuluhan ni pangitaán a inon ay dinumatong pan di un dinodul ide ni Kornelio ta nun matinggesan de di i beloy ni Simon a petaanan ni Pedro ay dinumuman ide. ");
INSERT INTO due_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ta nagtanto i dinumatong ide ti duman ngani nappataan i Simon a te ngalan a Pedro. ");
INSERT INTO due_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Misan i Pedro pan nun peesip na pa i kabuluhan ni kinta na ay sinabi diya ni Ispiritu nun Makedepat a, “Wiyo, te tiluwon a manga lalaki a gelawag dikaw. ");
INSERT INTO due_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lumusong ka di ta sumut ka di a wet te aduwa a esip ta ako ngani i nagdodul dide.” ");
INSERT INTO due_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kanya linumusong i Pedro ta sinabi na de manga dinumatong ide, “Wiyo ok a pelawag yu. Ano man i kaelangan yu?” ");
INSERT INTO due_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tinumubeg ide, “Ikami ay pinakang dio ni kapitan a Kornelio. Eya ay piyon a agta a gegelang de Makedepat pati pegelang eya ni manga Hudyo ide ta sinabi diya ni isin a anghel nun Makedepat a kangan mi ikamo tangani gepatalikngoy eya de pagtodu yu.” ");
INSERT INTO due_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ta pinasilong ide ni Pedro a nekipilong ide duman. Ta nun kinábiabian di ay tinumotul ide Pedro pati sinotan pala eya ni kakmukan pa a manga kabinsa a tage Hope. ");
INSERT INTO due_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nunde sinumunud a adow ay dinumatong ide de Sesarea ta geilat di a masakut ide Kornelio, mangayun na pati pesan a inakit na tangani magpatalikngoy. ");
INSERT INTO due_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nano ay pagdetong nide Pedro ay tinagbu eya ni Kornelio a inumobbob de kasagkaden na a gepodi. ");
INSERT INTO due_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Misan ay binolan eya ni Pedro a sinabi na, “Umuddi kamo di ta ako ay agta pala a magi ikamo.” ");
INSERT INTO due_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ta dingan tinumuloy ide a pasilong nunde beloy a nasurutsurotan ta kinta ni Pedro duman i makmuk a kaagtaan a nattipun. ");
INSERT INTO due_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Sinabi na dide, “Katinggesan yu a an nappaayun de ugeli mi a Hudyo a makikoloy i Hudyo ide de an Hudyo ide o gebiseta man de belang beloy de misan ay pinatingges pan deko ni Makedepat a an depat a pengalanan ko i misan ino a agta ni an malenis a an nagkaddepat de pekita na. ");
INSERT INTO due_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kanya pan nun pinakangan ok yu ay sinumut ok a an te aduwa a esip ta nano ay buot ko a matinggesan ta ano ta pinalawag ok yu.” ");
INSERT INTO due_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Nano ay tinumubeg pan i Kornelio, “Ay-o, ta nun kaapat di a adow ay nagpanalangin ok dio de beloy ko i, ta odes di a pagpanalangin de kadepit a apun a i magi nano. Ta dingan te loktat dila a inumuddi de kasagkaden ko a lalaki a gepakaingap i bedu na. ");
INSERT INTO due_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ta sinabi na, ‘Kornelio, pagkasalegen ni Makedepat i pagpanalangin mo pati pagtabeng de mahedepin ide. ");
INSERT INTO due_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kanya pakangan mo i Simon a te ngalan pala a Pedro de Hope ta eya ay nappataan de Simon a magyeyedi gepo de katat ni hayup. Ta i kataanan na ay de kaginglan ni atab.’ ");
INSERT INTO due_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kanya nagpakang ok dikamo a tambing ta salamat pan ta dinumio kamo. Kanya nano ay dio kami a nattipun tangani magpatalikngoy ni surut nun Makedepat a sasabi yu.” ");
INSERT INTO due_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nano ay sinabi ni Pedro, “Nano ko la natinggesan a am mangan te pepeta i Makedepat. ");
INSERT INTO due_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ta de belang bensa ay pagkasalegen na i pesan a gegelang diya pati gepinagyedi ide ni piyon. ");
INSERT INTO due_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Katinggesan yu a de tage Israel la ide, binoy ni Makedepat i surut na ta dide pala pinatingges na i piyon a bereta tungkul de Hisu Kristo a geboy ni kasampatan a innawa ta eya ay Panginoon ni pesan. ");
INSERT INTO due_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ta katinggesan yu pan a kinumálat i oyo a piyon a bereta de kulukaginglan ni Hudia ta te gepo de Galilea nun nagsabi i Huwen a nagkaddepat a lelinod i manga agta a tande de pagsosol de. ");
INSERT INTO due_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ta dingan kasta pinalis ni Makedepat de Hisus a tage Nasarit i Ispiritu na pati kapangyedihan. Ta kinumulukang eya a geyedi ni piyon, a nagpapiyon pala de pepahedepan ide ni Satanas ta nappa diya ngani i Makedepat. ");
INSERT INTO due_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ta ikami pan i gepamatud de pesan a yinadi na de bensa ni manga Hudyo man o de Herusalem. Ta nun nanon pan ay binuno de eya a pinapakuan de padipa a kew ");
INSERT INTO due_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","misan ay pinakaedup eya ni Makedepat a liwet de katiluwon a adow ta eya ay pinakita na nun pinakaedup di a liwet. ");
INSERT INTO due_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Misan ay an eya pinakita de pesan ti an dikami la a nunde gepo pa ay pineta di ni Makedepat a gepamatud, a ikami pala a nakásaló na nun eya ay pinakaedup di a liwet. ");
INSERT INTO due_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ta ikami ngani i dinodul na a magsabi ni piyon a bereta de pesan a agta pati magpamatud a eya ngani i pineta nun Makedepat a nappa ni Huwis de nàedupin pati nalibunin di. ");
INSERT INTO due_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pati eya pala i hinola ni magsasabi ide nun sinabi de a i misan ino a nonulusun diya ay pakeeyenan ngani ni mammalotin de dehil de pagpanulusun de de makapangyedihan a ngalan na.” ");
INSERT INTO due_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nano ay gesurut pangani i Pedro ay linumusong di i Ispiritu nun Makedepat de pesan a gepatalikngoy de pagsurut na. ");
INSERT INTO due_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Kanya pan nagtaka ngani i manga gepanulusun ide a Hudyo a tage Hope a kakoloy ni Pedro, nun kinta de a kasta pinalis pala i Ispiritu a peboy nun Makedepat de an Hudyo ide. ");
INSERT INTO due_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Dingan te gepo i linusongan ide a nagsurut ni an de katinggesan, a gepodi pala de Makedepat. Kanya sinabi ni Pedro de Hudyo ide, ");
INSERT INTO due_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Talage a i manga agta ide a oyo ay magi ikitam pala a tinumanggep ni Ispiritu nun Makedepat kanya nano ay ino pa man i nakasablow dide a linoden de orat?” ");
INSERT INTO due_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kanya sinabi ni Pedro a depat di a linoden i oyo ide a an Hudyo a tande de pagpanulusun de de ngalan ni Hisus Kristo. Pagkatapos ninon ay inaged pa ni agta ide a tumaan ngona ide Pedro duman ni tipide pa a adow. ");
INSERT INTO due_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nano ay nabereta ni mag-aatid ide pati manga kabinsa ide a Hudyo de sákup ni Hudia a i manga an Hudyo ide ay tinumanggep di pala ni surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kanya nun sinumakat a liwet ide Pedro de Herusalem ay sinosol eya ni manga kabinsa ide a Hudyo a te pagtodu pa tungkul de pagpapelat. ");
INSERT INTO due_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ta sinabi de diya, “Bekot ta nakitaán ka pati nakisaló de manga an Hudyo ide?” ");
INSERT INTO due_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ay dingan te gepo i Pedro a nagsabi ni pesan a nangyedi hanggen nunde gepo. ");
INSERT INTO due_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Sinabi na, “Nun isin a adow a nanalangin ok de benwaan a Hope ay kinta ko i pangitaán a gepo de Makedepat a magi kómut a getayon gepo de langot de kasagkaden ko a naggiptan de magtulutimbeng na a lawis. ");
INSERT INTO due_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kanya pinakalawag ko a masakut ta kinta ko duman i pesan a sadisadi a hayup, a i gedeyag de putok, mailapin pati pesan a gelipad de longaw na. ");
INSERT INTO due_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dingan inikna ko pala i surut a magioyo, ‘Pedro, umuddi ka di ta mamuno ka dingan mamangan a tuloy.’ ");
INSERT INTO due_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Misan ay tinumubeg ok pan, ‘Ay wet di, Panginoon, ta misan kapide ay anok gepangan ni misan ano a an malenis pati an nagkaddepat de ugeli mi a Hudyo.’ ");
INSERT INTO due_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dingan inikna ko a liwet gepo de langot i surut a magioyo, ‘Wet mo man esipa a madiplot i linenis di ni Makedepat.’ ");
INSERT INTO due_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ta pakatiluwon non nagsurut dingan binotong di a paditas un magi kómut. ");
INSERT INTO due_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ta non nanon pala ay dinumatong pan di de kataanan ko i tiluwon a manga lalaki a pinakang deko gepo de benwaan a Sesarea. ");
INSERT INTO due_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pati sinabi deko ni Ispiritu nun Makedepat a, ‘Sumut ka a tambing a wet te aduwa a esip.’ Nun nototul kami di ay sinumut pala deko i oyo a anim a manga kabinsa tam a tage Hope ta sinumilong kami de beloy ni Kornelio. ");
INSERT INTO due_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ta binareta na dikami a te nagpakita diya de beloy na a anghel ta sinabi diya nun anghel a, ‘Pakangan mo i Simon a te ngalan pala a Pedro de Hope. ");
INSERT INTO due_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ta eya ngani i nanabi dikaw a ti papalano ka a nalligtas pati mittanak mo ide.’ ");
INSERT INTO due_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nano ay nun gesurut ok pa dide ay linumusong dide i Ispiritu nun Makedepat a magi nangyedi dikitam nun tagibu. ");
INSERT INTO due_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ta naisepan ko pala i sinabi ni Panginoon nun sinabi na a, ‘I Huwen a Maglilenod ay lininod na la ikamo de orat misan ay lelinod ko pan ikamo a talage de Ispiritu nun Makedepat.’ Inon i sinabi ni Panginoon ");
INSERT INTO due_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","kanya be peboy ni Makedepat i paaged na a i Ispiritu na de an Hudyo ide a magi binoy na pala dikitam a manga Hudyo nun nagpanulusun kitam de Hisus ay ino ok man a nansasablow de Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Kanya nun iknain de i maginon a sinabi ni Pedro ay tinumimok ide ni pagsosol diya, a nagpodi pan de Makedepat ta sinabi de, “Maginon ay biniyen pala i an Hudyo ide ni pagkakataon a makapagsosol, a gekaduman pala ni edup a an te kalog.” ");
INSERT INTO due_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nano ay nun bunoin ni Hudyo ide i Isteban, a pinahedepan de pala i gepanulusun ide de Hisus ay kinumálat i pinahedepan ide a kinumang de sákup ni Penisia, de Pugu a Kipre pati de benwaan a Antiokia ta nagsabi ide duman ni piyon a bereta de Hudyo la ide. ");
INSERT INTO due_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Misan ay i tipide a pinahedepan ay tage Pugu a Kipre pati sákup ni Sirene ta pagdetong de de Antiokia ay nagsabi ide ni piyon a bereta tungkul de Panginoon a Hisus de manga an Hudyo ide. ");
INSERT INTO due_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ta nagkaduman ide ni kapangyedihan ni Panginoon kanya pan makmuk dingani i nanulusun de Panginoon, a nanwalat ni ugeli de a den. ");
INSERT INTO due_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nano nun mabereta ni manga gepanulusun a kapolongan de Herusalem ay dinodul de i Bernabi de Antiokia. ");
INSERT INTO due_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Pagdetong na duman ay kinta na a nagkaduman ide ni kosa a tabeng ni Makedepat kanya nasalig eya ta pinagsabian na ide a depat ide a tumuloy de pagpanulusun de de Panginoon a wet te aduwa a esip. ");
INSERT INTO due_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nano ay i Bernabi ay piyon a agta ta napino eya ni Ispiritu nun Makedepat pati matibong i pagpanulusun na. Kanya makmuk ngani i nanulusun de Panginoon dehil de pagpamatud na. ");
INSERT INTO due_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Nun nanon ay kinumang i Bernabi de Tarso ta linawag na i Saulo. ");
INSERT INTO due_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ta nun kinta na di i Saulo ay inumampulang ide de Antiokia. Ta duman ay tinumaan ide ni isin a taon a kulukakoloy ni gepanulusun ide a kapolongan ta nagtodu a ugnay de kamakmokan a agta. Ta duman de Antiokia ay tagibu a te ngalan i mag-aadel ide a “Kristiano”. ");
INSERT INTO due_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nun nanon pan ay te dinumatong de Antiokia a magsasabi ide a inumapo de Herusalem. ");
INSERT INTO due_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ta inumuddi un isin a te ngalan a Agabo a naghola gepo de Ispiritu nun Makedepat a gekaduman ni hanga a tigtegeng de pesan a Iugel. Inon ay sinumapit nun panahon di a Hari a Kaditasan de Roma i Klaudio. ");
INSERT INTO due_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kanya nagbelak i mag-aadel ide a gepaadde ni tabeng de a kuwarta a nappaayun de kaya de de manga kabinsa ide a nappataan de Hudia. ");
INSERT INTO due_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Maginon ngani i yinadi de ta pinaadde de i tabeng de dide Bernabi pati Saulo de pinakamatande ide de kapolongan de Herusalem. ");
INSERT INTO due_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nun panahon pala a inon ay te gepo a pepadekop ni Hari a Herod i tipide a manga gepanulusun de kapolongan. ");
INSERT INTO due_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ta i Santiago a wele ni Huwen ay pinaputolan na ni bong. ");
INSERT INTO due_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nano ay nun kinta ni Herod a inon i kasalegen ni Hudyo ide ay pinadekop na pan i Pedro. I oyo ay nangyedi nun kaadowen ni Tinapay a An Te Pahelab. ");
INSERT INTO due_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pagkadekop na de Pedro ay pinabilanggo na eya a pinabentayen de tig-aapat a koloy a manga sundelo. Ta i belak ni Hari ay pagkatapos ni kaadowen ay hahatolan na i Pedro de pekita ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kanya i Pedro ay nabbilanggo la misan ay i manga kabinsa pan ide a kapolongan ay nagpanalangin de Makedepat ni matibong para diya. ");
INSERT INTO due_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nano ay nun abi a inon ay nappede i Pedro de pag-etan ni aduwa a sundelo a naggepus ni aduwa a tanikala. Ay te aduwa a bentay pa de pintohan ni bilanggoan ta be umabiabi di ay hahatolan tebe eya ni Herod. ");
INSERT INTO due_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ta loktat dila ay nagpakita i anghel nun Panginoon de disalad nun bilanggoan a tinumallang a masakut. Ta tinampal na i Pedro de tagileden na a sinabi na, “Gumiyos ka a tambing.” Dingan i tanikala ide a naggepus diya ay naukas-ukas de kumot na. ");
INSERT INTO due_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Sinabi diya nun anghel, “Magbedu ka pati magsapatus.” Maginon ngani i yinadi na ta dingan sinabi pa nun anghel, “Magkulapyaw ka ta umabut ka deko.” Kanya sinumut pan i Pedro nunde anghel. ");
INSERT INTO due_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ta binumulwag pan di i Pedro a inumabut diya misan ay an na katinggesan ti matud i yinadi a inon ni anghel ta inesip na a pangitaán la. ");
INSERT INTO due_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nano ay nun nakatakig di ide de tagibu a bentay pati de káduwa ay dinumatong ide de pintohan a bekal a bulwagen a paagow di nunde karsade nun benwaan. Ta i pintohan a inon ay kosa a kinumayes ta binumulwag ide. Pagkatakig de de isin a karsade ay linumisop di un anghel. ");
INSERT INTO due_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ay dingan la kinatinggesan ni Pedro i pagkaagta na ta sinabi na de sadile na a, “Angani pangitaán i nangyedi a inon ta kamatoden a dinodul ni Panginoon i anghel na tangani ligtasin ok na de Herod pati de pesan a peasahan ni Hudyo ide a nangyeyedi deko.” ");
INSERT INTO due_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Talage nun kinatinggesan na inon ay inesip na a nákang de beloy ni Maria a ina ni Huwen a te ngalan pala a Markos. Ta duman nattipun i makmuk a manga kabinsa a gepanalangin. ");
INSERT INTO due_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pagdetong na duman ay tinumuktuk eya de pintohan ni bekod ta kinumang pan i isin a maddikit a te ngalan a Rode tangani pagelawagin na ti ino non. ");
INSERT INTO due_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nano ay nun inabuyenan na i busis ni Pedro ay an eya nakatuloy a nangayes dehil de salig na ta ginumikan eya a paagow de disalad tangani sabiin na de pesan a nappaduman, a duman di de pintohan i Pedro. ");
INSERT INTO due_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Misan ay sinabi diya ni manga agta, “Ay makati nasede di i esip mo.” Misan ay pinelit na a i Pedro non kanya sinabi de, “Ay makati anghel a gealáge diya.” ");
INSERT INTO due_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ta getuloy pan la i Pedro a getuktuk ta nun kinayesan de ay kinta de ngani i Pedro kanya nagtaka ide a masakut. ");
INSERT INTO due_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Misan ay pagkapàpà na dide a tumimok ni ngalangala ay sinabi na dide a ti papalano eya binulwag ni Panginoon de bilanggoan ta sinabi na, “Sabiin yu yo de Santiago pati de manga kabinsa ide.” Dingan i Pedro ay tinumotul a paagow de kakmukan a lugel. ");
INSERT INTO due_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nano ay nun abiabi di ay nagkogulo a masakut i esip ni magbebentay ide ta an de katinggesan a ti papalano a an duman i Pedro. ");
INSERT INTO due_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Misan ay nun pinakangan ni Herod i Pedro, a an di eya kinta ay tinulutanto na i magbebentay ide dingan pinabuno na ide. Ta i Herod pan ay kinumang de Sesarea a tinumaan duman. ");
INSERT INTO due_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nano ay nun nanon ay te bulas i Herod de tage benwaan a Tiro pati Sidon kanya nasurutsurotan ide a nákang ide de Herod a nekisurut ide a tagibu de Blasto a katabeng ni Herod tangani tatabengan na ide a makipagkasungdu de Herod. Ta i pagkeedup de pan ay geapo de putok a nasasakopan ni Hari a Herod ay an na pepaadde dide. ");
INSERT INTO due_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nano ay nun adow di a pinagkasungduan i Herod pati tage aduwa a benwaan ay nagbedu i Herod ni bedu ni hari dingan linumipa de piglipaan na ta nagsurut eya dide. ");
INSERT INTO due_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ta pagkapagsurut na ay sinabi de a malagdu a, “An agta la i gesurut ta Makedepat di.” ");
INSERT INTO due_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Misan ay loktat eya a pinaapdisan ni isin a anghel ni Panginoon dehil de tinanggep na i pagpodi a nagkaddepat la de Makedepat. Kanya eya ay ginok a inon dingani i kinalibun na. ");
INSERT INTO due_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kanya pan i surut nun Makedepat ay kinumálat ta gemakmuk pan i manga gepanulusun. ");
INSERT INTO due_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ta ide Saulo pati Bernabi pan ay inumampulang gepo de Herusalem nun matapos di i pangatid de ni kuwarta duman ta inikag de i Huwen a te ngalan pala a Markos de Antiokia. ");
INSERT INTO due_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nano ay te duman pan de kapolongan de Antiokia a magsasabi pati magtutodu. Ide ay i Bernabi, Simeon a Malatom, Lusio a tage Sirene, Saulo pati Manaen a ayun ni Herod nun mangának pa ide. ");
INSERT INTO due_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nano nun ide ay an namangan ni untik a panahon a gepanalangin, a gepodi de Panginoon ay sinabi dide ni Ispiritu nun Makedepat a, “Bukudin yu i Bernabi pati Saulo a te tungkolin di ta te payedi ok dide.” ");
INSERT INTO due_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pagkatapos de a nanalangin a an namangan ni untik a panahon ay tinapá de ide Bernabi pati Saulo ta dingan pinatotul de ide a gesabi ni piyon a bereta. ");
INSERT INTO due_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kanya gepo de pagdodul ni Ispiritu nun Makedepat ay dinumolug ide Bernabi pati Saulo de benwaan a Selusia a pigdongan ni hangain a bengka ta ide ay sinumakoy a paagow de Pugu a Kipre. ");
INSERT INTO due_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nano ay pagdetong de de benwaan a Salamina ay nagsabi ide ni surut nun Makedepat de pigmitengan ide ni Hudyo ide. Te kakoloy ide a i Huwen Markos a nagtabeng dide. ");
INSERT INTO due_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ta nun kinulukangan de un pesan a pugu hanggen de benwaan a Papos ay kinta de i isin a magsasalamangka a te ngalan a Barhosuwe ta eya ay Hudyo a magsasabi a an matud ");
INSERT INTO due_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","a kakoloy ni Gubernador a Sergio Paulo a mataleno. Nano ay pinakangan na ide Bernabi pati Saulo ta binuot na a gepatalikngoy de surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Misan ay i magsasalamangka a te ngalan pala a Elimas de surut a Griego ay buot na pan a aabetan ide Saulo tangani wet nonulusun i Gubernador. ");
INSERT INTO due_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Dingan i Saulo pan a te ngalan a Pablo ay napino ni Ispiritu nun Makedepat ta pinakalawag na a masakut i magsasalamangka. ");
INSERT INTO due_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ta sinabi na, “Anak ka ni Satanas, katalo ka ni kapiyonan. Migdeya ka a migyedi ni mammalotin kanya nano ay tumimok ka di ta wet mo peabetan i surut nun Makedepat de agta a te buot a nonulusun. ");
INSERT INTO due_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nano ay podusahan ka ni Panginoon a Makedepat ta nappa ni bulag ka di a an nekita ni matallang ni naaloy a panahon.” Ay tambing dingan la a dinumumos i mata na kanya nag-aged ni nangabit diya. ");
INSERT INTO due_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ta un Gubernador pan ay nanulusun nun kinta na inon a nangyedi ta nagtaka eya de pagtodu tungkul de Panginoon. ");
INSERT INTO due_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Gepo de Papos ay sinumakoy ide Pablo pati kakoloy na ide a paagow de benwaan a Perge a sákup ni Pampilia. Misan ay kinumiblag dide i Huwen Markos a inumampulang de Herusalem. ");
INSERT INTO due_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ta gepo pan duman ay tinumuloy ide a dinumatong de Antiokia a sákup ni Pisidia. Nun adow ni paimloy ay sinumilong ide de pigmitengan a linumipa. ");
INSERT INTO due_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nano ay nun te makapagbesa di de kasulatan ni Moises pati kakmukan a magsasabi ay sinabi dide ni manga gepamahala ide de pigmitengan a, “Manga kabinsa, be te duman kamo a pagtodu a gepatibong de agta ide ay hale di.” ");
INSERT INTO due_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kanya inumuddi i Pablo a pinàpà na i agta ta sinabi na, “Manga kabinsa a Hudyo pati an Hudyo a gegelang de Makedepat ay magpatalikngoy kamo de sasabi ko dikamo. ");
INSERT INTO due_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nun nowon i Makedepat a matud a pepodian tam a tage Israel i nameta de kaapoapohan tam ide ta minumakmuk ide nun tinumaan ide de sákup ni Ihipto. Misan ay binulwag na pan ide de padean ni kapangyedihan na. ");
INSERT INTO due_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ta nun ide ay duman pa de lugel a ilang ay tiniyagean pan ide ni Makedepat ni apat a puwu a taon. ");
INSERT INTO due_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nano ay nun mapatotul na di de sákup ni Kanaan i an Hudyo ide a tage pito a bensa ay binuluboy na pan de kaapoapohan tam ide. Kanya nagmana ide ninon a putok. Pagkatapos ninon hanggen nun manga apat a dian pati lima a puwu a taon ");
INSERT INTO due_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ay binoy dide ni Makedepat a sunudsunud i pineta na ide a ponu hanggen de napa ni ponu di i Samuel a magsasabi a den. ");
INSERT INTO due_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ta dingan inumaged ide ni hari. Ay biniyen pan ide ni Makedepat ni lalaki a gepo de angkan ni Benhamin a i Saulo a anak ni Kis. Ta eya ay naghari ni apat a puwu a taon. ");
INSERT INTO due_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Misan ay nun binut di eya ni Makedepat de paghari na ay linewesan na pan ni Debid a napa ni hari de. Ta pinamatoden ni Makedepat i Debid a magioyo, ‘I Debid a anak ni Hesse ay lalaki a pagkasalegen ko ta getalinga eya de kabuotan ko.’ ");
INSERT INTO due_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ta gepo de oyo a lalaki ay binoy pala ni Makedepat de tage Israel ide i pinangako na a i Hisus a magliligtas de. ");
INSERT INTO due_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Misan ay dingan ngona dinumatong i Hisus ay nagsabi i Huwen a Maglilenod de pesan a tage Israel ide a depat a lelinod ide de orat a tande de pagsosol de de mammalotin de. ");
INSERT INTO due_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nano ay nun matapos di ni Huwen i tungkolin na ay tinanto na i manga agta, ‘Ano i peesip yu? Ino ok? An ako i pinangako nun Makedepat. Angani ta te nádetong pa a nappaabut deko ta anok te sukul a kapangyedihan a nongukas ni gipot la ni paragetus na.’” ");
INSERT INTO due_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Sinabi a tuloy ni Pablo, “Manga kabinsa a mangápo ni Abraham pati ikamo a an Hudyo a gegelang de Makedepat, ikitam ngani i pinaadden ninon a bereta a tungkul de kaligtasan. ");
INSERT INTO due_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Misan ay an kinatinggesan ni tage Herusalem ide pati ponu de ide a i Hisus ay magliligtas de pati an de pala kinatinggesan i hinola de kasulatan ni magsasabi ide a pebesa de belang adow ni paimloy. Ta nun hinatolan de i Hisus ay pinamatoden de pala i pesabi ni pebesa de a kasulatan. ");
INSERT INTO due_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ta misan an ide te matud a dehilan a panhahatolan de diya ni kalebunan ay inaged de de Pilato i Hisus tangani pakuan de de padipa. ");
INSERT INTO due_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nano ay nun nayedi de di inon a pesan a sinabi ni kasulatan ay linusong de di i bengkay na de padipa tangani mapuoy de de gob a yinadi ni agta. ");
INSERT INTO due_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Misan ay pinakaedup eya a liwet ni Makedepat. ");
INSERT INTO due_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ta eya ay nagpakita ni makmuk a adow de manga sinumut ide diya de Herusalem gepo de Galilea. Kanya ide pan nano i gepamatud de manga tage Israel ide. ");
INSERT INTO due_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ta nano pan ay napadio kami a gesabi dikamo ni piyon a bereta a i pinangako nun Makedepat de kaapoapohan tam ide. ");
INSERT INTO due_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Inon ay pinamatoden di ni Makedepat dikitam a mangápo de, nun pinakaedup na a liwet i Hisus. Ta magioyo i sinabi ni Makedepat de káduwa a kanta, ‘Ikaw i Anak ko ta de nano a adow a pinakaedup ko ikaw a liwet ay gepaabuya ok di a ako i Ama mo.’ ");
INSERT INTO due_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Sinabi na pala, ‘Gekaduman ka ni kapiyonan ko a magi pinangako pala de Debid a kaapoapohan mo.’ Kanya de surut a inon ay pinatingges ni Makedepat a nun pinakaedup na a liwet i Hisus ay an di nelibun a liwet. ");
INSERT INTO due_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Sinabi pala ni Debid de isin pa a kanta, ‘Talage a i lawes ni Pineta yu ay an yu pabiyaan a nobungtut.’ ");
INSERT INTO due_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Misan ay nun matapos di ni Debid a mayedi i kabuotan ni Makedepat ay nalibun eya a pinuoy de gob a alane ni kaapoapohan na ide ta nabungtut pan la i lawes na. ");
INSERT INTO due_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Tungkul pan de Hisus a pinakaedup a liwet ni Makedepat ay an na ngani pinabiyaan a nabungtut i lawes na. ");
INSERT INTO due_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kanya, manga kabinsa, depat a matinggesan yu a i pesabi dikamo a nappatud la a pakeeyenan kamo ni mammalotin yu dehil de lalaki a oyo a i Hisus. ");
INSERT INTO due_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ta dehil diya ay i belang gepanulusun ay nakabbut de kapangyedihan ni pesan a mammalotin de, a ang kamo pan nakabbut dehil de pag-abut yu de pagdul ide ni Moises. ");
INSERT INTO due_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kanya ngani mag-engat kamo tangani wet nappa dikamo i hinola ni magsasabi ide ni Makedepat a magioyo, ");
INSERT INTO due_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Pagalawagin yu, a ikamo a gelibek a an gepanulusun ta magtaka kamo dingan nopuksa. Ta yeyedi ko i gepakataka de kasagkaden yu ta ang kamo pan nappatud a nonulusun misan te nagpatingges dikamo.’” Inon i pagtodu ni Pablo. ");
INSERT INTO due_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nano ay nun makabulwag ide Pablo pati Bernabi de pigmitengan ay sinabi dide ni kaagtaan a, “Buot mi a ikamo pa a liwet i magtodu ni oyo de nosunud a adow ni paimloy.” ");
INSERT INTO due_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pagkatapos pala ni pagpolong ay inumabut dide Pablo pati Bernabi i makmuk a agta a Hudyo pati an Hudyo ide a te pagpanulusun a magi Hudyo. Ta nagsabi dide i aduwa a depat a ide ay tumuloy de pag-asa de de kosa a tabeng ni Makedepat. ");
INSERT INTO due_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kanya nun sinumunud a adow di ni paimloy ay natipun i kasta pesan a kaagtaan de benwaan, a gepatalikngoy de surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Misan ay nun kinta ni Hudyo ide i makmuk a gepatalikngoy ay nasinna ide kanya nakipagtalo ide de pagtodu ni Pablo pati linebek de eya. ");
INSERT INTO due_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ta i Pablo pati Bernabi pan ay nagsabi a matapang a magioyo, “Talage a depat ngona a gesabi kami dikamo a manga Hudyo ni surut nun Makedepat misan ay dehil de pekapoyen yu yo, a peesip yu pan a an te kabuluhan dikamo i pagtanggep ni edup a an te kalog ay nákang kami de an Hudyo ide. ");
INSERT INTO due_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ta magioyo i dinodul dikami ni Panginoon, ‘Ay pineta ko ikamo a gepatallang ni esip ni an Hudyo ide a gesabi kamo a leligtas ni Makedepat i misan ino a agta misan deno a kadepit.’” ");
INSERT INTO due_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kanya pan nun iknain inon ni manga an Hudyo ide ay nasalig ide a nagpasalamat dehil de surut nun Makedepat a inikna de. Ta te pagpanulusun a matud i belang binuot ni Makedepat a bebiyen ni edup a an te kalog. ");
INSERT INTO due_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nano ay de kulukaginglan ni sákup a inon ay kinumálat i surut nun Panginoon. ");
INSERT INTO due_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Misan ay pinapagbulas pan ni Hudyo ide i te kapangyedihan ide a pinakamatande pati mahunain a pegelang a te pagpanulusun a magi Hudyo ide. Kanya pinahedepan de i Pablo pati Bernabi tangani pototul de ide de sákup de. ");
INSERT INTO due_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Dingan pagtotul de ay pinagpag de i delpong de singit de a tande a kinapoyen ni tage duman ide i surut nun Makedepat. Ta ide ay kinumang de benwaan a Ikonio. ");
INSERT INTO due_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Misan ay i nawalat ide a mag-aadel de Antiokia a sákup ni Pisidia ay nagkasalig ide a masakut pati napino ide ni Ispiritu nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nano ay maginon pala de benwaan a Ikonio ay ide Pablo pati Bernabi ay sinumilong de pigmitengan ni Hudyo ide ta dehil de pagtodu de a te kapangyedihan ay makmuk a Hudyo pati an Hudyo i nanulusun. ");
INSERT INTO due_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Misan ay i Hudyo ide a an nagpanulusun ay pinapagbulas de i an Hudyo ide tangani geesip ide ni malot tungkul de manga kabinsa a gepanulusun de Hisus. ");
INSERT INTO due_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ay náloy pan a nagtaan duman ide Pablo pati Bernabi a gesabi ide a matapang a tungkul de Panginoon. Ta pinamatoden pan ni Panginoon i surut na a tungkul de kosa a tabeng na de padean ni manga tande pati gepakataka a pepayedi na dide. ");
INSERT INTO due_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kanya pan nabinsa i manga agta de benwaan a inon ta i kakmukan ay tinumalinga de mag-aatid ide ta i kakmukan pan ay de manga Hudyo ide. ");
INSERT INTO due_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Misan ay nun nagbelak i an Hudyo ide, i Hudyo ide pati manga ponu de ni malot de mag-aatid ide a bonglagin ide ");
INSERT INTO due_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ay natinggesan de inon kanya linumimok ide a paagow de benwaan ide a Listra, Derbe pati de pulupalebut de a sákup ni Likaonia. ");
INSERT INTO due_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ta nagsabi ide duman ni piyon a bereta. ");
INSERT INTO due_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nano ay duman de Listra ay te duman a lalaki a gelipa la ta lungpo eya a an gepakatotul gepo pa nun eya ay pinanganak. ");
INSERT INTO due_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Eya ay gepatalikngoy de pagsabi ni Pablo. Nano ay nun pinagelawag eya ni Pablo ay kinatinggesan na a te pagpanulusun i lungpo a nepiyon. ");
INSERT INTO due_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ta sinabi ni Pablo a malagdu, “Umuddi ka ni matanus.” Ay linumawot ngani un lalaki ta nakatotul di. ");
INSERT INTO due_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pagkakita ni kaagtaan de yinadi ni Pablo ay inumolang ide de surut a Likaonia ta sinabi de, “Linumusong di dikitam i makedepat ide a te anino ni agta.” ");
INSERT INTO due_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kanya nginalanan de i Bernabi a “Seus” ta i Pablo pan ay “Hermes” ta eya i kasta magsasabi ni Bernabi. ");
INSERT INTO due_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Nano ay duman pan de ditow ni benwaan i pigpodian a beloy de makedepat de a i “Seus”. Ta nun iknain di ni maghahandug de inon a beloy i gesapit ay inuwey na i manga beka a te manga kelong a bulaklak a bobuno a hahandug de tebe pati kaagtaan de mag-aatid ide. ");
INSERT INTO due_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Misan ay nun kinatinggesan ni mag-aatid ide a i Bernabi pati Pablo ay ginise de i bedu de ide a tande a an de buot inon dingan ide ay ginumikan a paagow de gitna ni kaagtaan ta sinabi a malagdu, ");
INSERT INTO due_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Kaagtaan, bekot ta peyedi yu i magiwina? Ta ikami ay agta pala a magi ikamo. Ta gesabi kami la ni piyon a berata tangani walatin yu di i pesan a oyo a ugeli yu a an te manga kabuluhan, a tumanggep kamo pan de Makedepat a needup kapide man a nagyedi ni putok, langot, atab pati pesan a nappataan duman. ");
INSERT INTO due_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ta nun nakasila a panahon ay pinabiyaan na i pesan a agta a geyedi ni kabuotan de a sadili. ");
INSERT INTO due_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Misan ay nun nanon pala ay nagpaabuya eya de padean ni pagyedi na a piyon ta biniyen na ikamo ni tapuk gepo de langot pati binoy na pala dikamo de panahon a pagguto i sukul a pápangan a nagkaduman kamo ni kasalegen.” ");
INSERT INTO due_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Misan pinagsabian ide ni Pablo a maginon ay mahedep de pangani a sinablow i manga agta ide a gehandug tebe dide. ");
INSERT INTO due_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pagkatapos ninon ay te dinumatong pan a manga Hudyo duman a inumapo de Antiokia pati de Ikonia. Ta pinapagbulas de i kaagtaan kanya binonglag de i Pablo dingan inuwey de hanggen de ditow ni benwaan ta inesip de a eya ay nalibun di. ");
INSERT INTO due_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Misan ay nun linebut eya ni manga mag-aadel ide ay ginumiyos eya a sinumilong a liwet de benwaan. Nano ay nun kinábiabian ay nagkoloy ide Pablo pati Bernabi a kinumang de benwaan a Derbe. ");
INSERT INTO due_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ta nun nasabi ide Pablo pati Bernabi ni piyon a bereta de benwaan a Derbe, a makmuk pala i nagpanulusun duman, ay inumampulang ide de benwaan ide a Listra, Ikonia pati de Antiokia a sákup ni Pisidia. ");
INSERT INTO due_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ta pinatibong de i innawa ni mag-aadel ide a pinagsabian a depat a tumuloy ide de pagpanulusun de ta sinabi de a, “Talage a getiis kitam ngona ni kahedepan dingan kitam pa nakásalakat de kataanan ni Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kanya de belang kapolongan ay nameta ide ni pinakamatande a depat a gealáge de gepanulusun ide ta dingan nagpanalangin ide a an namangan ni untik a panahon ta inaged de a alagean ni Panginoon i manga gepanulusun ide diya. ");
INSERT INTO due_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pagkasila de de sákup ni Pisidia ay dinumatong ide de sákup ni Pampilia. ");
INSERT INTO due_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ta nun nagsabi pala ide ni surut nun Makedepat de benwaan a Perge de inon a sákup ay dinumolug de benwaan a Atalia a pigdongan ni hangain a bengka. ");
INSERT INTO due_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ta gepo duman ay sinumakoy ide de hanga a bengka a inumampulamg de benwaan a Antiokia a sákup ni Siria. Ta dio ide ginumapo, nun nagpanalangin i manga kabinsa a napa dide i kosa a tabeng ni Makedepat, de pag-atid de ni piyon a bereta a natapos de di. ");
INSERT INTO due_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ta pagdetong de duman ay tinipun de i pesan a manga kabinsa de kapolongan dingan binareta de i pesan a pinayedi dide ni Makedepat a ti papalano a kinayesan na i innawa ni manga an Hudyo ide tangani manulusun ide diya. ");
INSERT INTO due_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nano ay tinumaan ide duman ni náloy a panahon a kulukakoloy ni manga mag-aadel ide. ");
INSERT INTO due_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Nano ay te dinumatong pan a tipide a inumapo de Hudia de Antiokia ta nagtodu ide de manga kabinsa a magioyo, “Be ang kamo gepapelat a nappaayun de pagdodul ni Moises ay talage a ang kamo nalligtas.” ");
INSERT INTO due_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Misan ay nakitalo pan a masakut ide Pablo pati Bernabi de pagtodu a inon kanya pinakang ni kapolongan, ide Pablo pati Bernabi a kakoloy i tipide a manga kabinsa a tage Antiokia tangani nasurutsurotan ide pati mag-aatid ide pati pinakamatande ide de Herusalem tungkul de pagtodu a inon. ");
INSERT INTO due_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kanya nun ide ay mapatotul di ni kapolongan a paagow de Herusalem ay sinumila ide de sákup ni Penisia pati Samaria. Ta binareta de duman a ti papalano nagpanulusun di i kamakmokan a an Hudyo ide kanya nagkaduman i manga kabinsa ide duman ni hanga a salig. ");
INSERT INTO due_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pagdetong de de Herusalem ay tinanggep pan ide a piyon ni mag-aatid ide, pinakamatande ide pati pesan a kapolongan ta dingan binareta de i pesan a pinayedi dide ni Makedepat. ");
INSERT INTO due_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Misan ay inumuddi i tipide a gepanulusun de Hisus a kakmukan ni Pariseo ide ta sinabi de, “Depat a pelatan i manga an Hudyo ide, a nátalinga pala ide de pagdodul ide ni Moises.” ");
INSERT INTO due_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kanya pan nagpolong i mag-aatid ide pati pinakamatande ide a nasurutsurotan tungkul de pagtodu a inon. ");
INSERT INTO due_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Misan ay nun matapos i pagitinalo de a mahigpit ay inumuddi i Pedro ta sinabi na, “Manga kabinsa, katinggesan yu ngani nun nakasila a adow a ako ay pineta dikamo ni Makedepat a geatid ni piyon a bereta de manga an Hudyo ide tangani nonulusun ide. ");
INSERT INTO due_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ta i Makedepat a gepakatingges ni innawa ni agta i nagpamatud a petanggep na i an Hudyo ide. Ta esipin yu a binoy na i Ispiritu na dide a magi pagboy na dikitam. ");
INSERT INTO due_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ta para diya ay padepade la i an Hudyo pati ikitam a Hudyo ta dehil de pagpanulusun de pala de Hisu Kristo ay pinakaeyenan na ide ni mammalotin a naddeinnawa de. ");
INSERT INTO due_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kanya bekot ta naketingges kamo pa de Makedepat, a pepayedi yu pa de an Hudyo ide a mag-aadel i magi ugeli tam a an di depat. Ta misan pan ikitam ay an tam pan la peyedi o i kaapoapohan tam ide. ");
INSERT INTO due_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Talage a katinggesan tam ngani a nalligtas kitam la dehil de kosa a tabeng ni Panginoon a Hisus a magi ide pala.” ");
INSERT INTO due_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nano ay i kapolongan ay an te geyamyam a tuloy ta nagpatalikngoy ide pala de Bernabi pati Pablo a gebereta dide ni pepayedi dide ni Makedepat a tande pati gepakataka duman de lugel ni an Hudyo ide. ");
INSERT INTO due_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pagkasabi de ninon ay i Santiago pala a mag-aatid i nagsurut ta sinabi na dide, “Manga kabinsa, patalikngan ok yu pala nano. ");
INSERT INTO due_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Nano ay bowon la a natapos i Simon Pedro a nagsabi a ti papalano a nagpaabuya i Makedepat a tagibu de an Hudyo ide tangani mameta eya dide ni mangának na pala a gepodi diya. ");
INSERT INTO due_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ta inon ay nappaayun de hinola ni magsasabi ide ta te duman de kasulatan a magioyo, ");
INSERT INTO due_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘De nádetong a adow ay náampulang ok ta misan nasede di i kapangyedihan ni mangápo ide ni Debid ay boboy ko a liwet dide i namas pa a te kapangyedihan a apo na ");
INSERT INTO due_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","tangani lalawag ok a Panginoon ni pesan a agta, a ide a an Hudyo a pineta ko a nappa ni mangának ko. ");
INSERT INTO due_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Talage a maginon i pesabi ko a Panginoon a pinatingges nun sakadow pa.’” ");
INSERT INTO due_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Sinabi ni Santiago a tuloy, “Nano ay peesip ko a wet tam abelaa i manga an Hudyo ide a gepanulusun de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ta yadi pa ay magpaadde kitam dide ni solat a wet ide námangan ni hinandug de makedepat ide a an matud, a wet pala námangan ni sagu pati unid ni hayup a nabitkol ta depat pala a wet ide nammamahuna pati nanlalalaki. ");
INSERT INTO due_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ta de maginon ay an pepaapdisan i Hudyo ide ta gepo pan nun nakasila a adow ay petodu de bulubenwaan a an Hudyo i kasulatan ni Moises pati de belang adow ni paimloy ay pebesa duman de pigmitengan a Hudyo i pagdodul na ide.” Inon i sinabi ni Santiago. ");
INSERT INTO due_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kanya inesip ni mag-aatid ide, pinakamatande ide pati pesan a kapolongan a piyon a mameta ide ni dododul de tangani paagow ide de Antiokia a kakoloy nide Pablo pati Bernabi. Ta dinodul de i Hodes a te ngalan a Barsabas pati Silas ta ide ay namas a pegelang a manga kabinsa de kapolongan. ");
INSERT INTO due_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ta ide ay pinapangadde de ni solat a gesabi ni magioyo, “Ikami a mag-aatid pati pinakamatande ide ay gebeti dikamo manga kabinsa mi a an Hudyo dena de benwaan a Antiokia de sulusákup ni Siria pati Silisia. ");
INSERT INTO due_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nano ay nabereta mi a pegulo i esip yu dehil de pagtodu ni tipide a inumapo dio de Herusalem i, misan ay am mi pan ide dinodul dena. ");
INSERT INTO due_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kanya pinagkasungduan mi a dodulin i aduwa a oyo a lalaki dena dikamo a kakoloy ni pebuot tam a ide Pablo pati Bernabi. ");
INSERT INTO due_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ta pinuhonan de i edup de de pagtabeng de de Panginoon tam a Hisu Kristo. ");
INSERT INTO due_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kanya dinodul mi dena ide Silas pati Hodes tangani ide i gepamatud dikamo ni pesabi ni solat a oyo. ");
INSERT INTO due_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ta ikami ay nagkasungdu di de tabeng ni Ispiritu a wet kamo di abelaa pa tungkul de kakmukan a ugeli ni Hudyo ti an i oya la i kaelangan pan a talage. ");
INSERT INTO due_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","I oyo ide a wet kamo námangan ni hinandug de makedepat ide a an matud, sagu pati unid ni hayup a binitkol. Ta depat pala a wet kamo nammamahuna pati nanlalalaki. Umelag kamo de oyo ide ta inon ay piyon. Ay gekaduman kamo ni kapiyonan be getalinga kamo de oyo ide a pagdodul mi. Hanggen dila duman i nasasabi mi.” ");
INSERT INTO due_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dingan nun pinatotul de i manga dinodul ide ay dinumatong ide de Antiokia ta tinipun de i manga gepanulusun a kapolongan dingan binoy de un solat. ");
INSERT INTO due_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nano ay pagkabesa de nun solat ay nasalig a masakut i kaagtaan ide dehil de solat a inon a nagpatibong de pagpanulusun de. ");
INSERT INTO due_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Nano ay ide Hodes pati Silas a magsasabi pala ay pinagsabian de ni makmuk i manga kabinsa ide kanya tinumibong i innawa pati pagpanulusun de. ");
INSERT INTO due_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ta tinumaan ide duman ni an náloy a panahon dingan nagpanalangin i manga kabinsa a nappa dide i kasampatan a innawa ta pepaampulang ide de nanodul dide. ");
INSERT INTO due_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Misan binuot pan ni Silas a mawalat ngona eya duman. ");
INSERT INTO due_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ta ide Pablo pati Bernabi pala ay tinumaan pa ide duman a te kakoloy ni makmuk pa a getodu pati gesabi ni surut nun Panginoon. ");
INSERT INTO due_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nano ay pagkatakig ni tipide a adow ay sinabi ni Pablo de Bernabi, “Yadi pa a umampulang kita a gebiseta de manga kabinsa de pesan a benwaan a pinagsabian ta ni surut nun Panginoon tangani matinggesan ta ti ano di i sinumapit dide.” ");
INSERT INTO due_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Nano ay buot pan ni Bernabi a ikagin de i Huwen a te ngalan a Markos. ");
INSERT INTO due_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Misan ay inesip ni Pablo a an non piyon ta i Markos ay kinumiblag dide de sákup ni Pampilia, a an sinumut a tuloy de tungkolin na. ");
INSERT INTO due_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Dehil de nagtalo ide Pablo pati Bernabi ay nagkibblagen ide. Kanya inikag ni Bernabi i Markos a sinumakoy ide de hanga a bengka a paagow de Pugu a Kipre. ");
INSERT INTO due_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Misan ay inikag pan ni Pablo i Silas ta pagkapanalangin ni manga kabinsa ide a nappa dide i kosa a tabeng ni Panginoon a Makedepat ay tinumotul ide. ");
INSERT INTO due_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ta sinumila ide Pablo de sákup ni Siria pati Silisia ta pinatibong na i pagpanulusun ni kapolongan ide duman. ");
INSERT INTO due_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nano ay kinumang pala ide Pablo de benwaan a Derbe pati Listra ta duman ay te isin a mag-aadel a te ngalan a Timoteo. Eya ay anak ni Hudyo a mahuna a gepanulusun ta i ama na pan ay Griego. ");
INSERT INTO due_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ta pepamatoden ni manga tage Listra pati Ikonia ide a i Timoteo ay piyon a agta. ");
INSERT INTO due_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Nano ay buot pan ni Pablo a maikag na i Timoteo kanya pan pinelatan na tangani wet eya sososol ni manga Hudyo duman ta kinatinggesan de a i ama ni Timoteo ay Griego. ");
INSERT INTO due_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ta de belang pesilan de a manga benwaan ay pebereta de i kabuotan ni mag-aatid ide de Herusalem pati pinakamatande ide a depat a talingaan non ni manga kabinsa ide. ");
INSERT INTO due_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kanya tinumibong i manga kapolongan ide pati de belang adow ay gemakmuk i manga gepanulusun ide de manga kapolongan. ");
INSERT INTO due_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Nano ay sinumila ide Pablo de sákup ni Prigia pati Galasia ta sinablow ide ni Ispiritu nun Makedepat a wet ide gesabi ni surut nun Makedepat de sákup ni Asia. ");
INSERT INTO due_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pagdetong de de alane ni sákup ni Misia ay inesip de a noduman ide de sákup ni Bitania misan ay an ide tinalingaan ni Ispiritu ni Hisus. ");
INSERT INTO due_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kanya tinumakig ide de Misia ta dinumolug ide de benwaan a Troas a kaginglan ni atab. ");
INSERT INTO due_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nano ay nun abi ay nagkaduman i Pablo ni pangitaán ta kinta na i isin a lalaki a tage sákup ni Masedonia a nag-aged a mahigpit a “Dumapit kamo dio de Masedonia ta tabengan yu ikami.” ");
INSERT INTO due_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pagkatapos ni pangitaán ay tambing kami naglawag ni sakoyen a nádepit de Masedonia ta kinatinggesan mi a dinodul kami ni Makedepat a magsabi ni piyon a bereta de sákup ni Masedonia. ");
INSERT INTO due_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Gepo de Troas ay sinumakoy kami de hanga a bengka a paagow de Pugu a Samotrasia ta nun kinábiabian pan ay tinumuloy kami de Neopolis a sákup ni Masedonia. ");
INSERT INTO due_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ta pag-apo mi duman ay tinumotul kami a paagow de benwaan a Pilepos a pinakamahalage a benwaan de sákup ni Masedonia. Inon a benwaan ay pigtaanan ni manga tage Roma ide. Nano ay tinumaan kami duman ni tipide a adow. ");
INSERT INTO due_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ta nun adow ni paimloy ay binumulwag kami de kaginglan ni orat ta inesip mi a duman pan i pigpanalanginan ni Hudyo ide kanya nagilinepa kami a nagsurut de mahunain a gepolong duman. ");
INSERT INTO due_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","I isin a gepatalikngoy de mahunain ide a inon ay i Lidia a tage benwaan a Tiatira ta eya ay magtitinde ni age a mulumaderag. Eya ay te gelang de Makedepat ta kinayesan pan ni Panginoon i esip na a nanulusun de pagsabi ni Pablo. ");
INSERT INTO due_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nun lininod di eya pati mittanak na ide ay sinabi na, “Be peesip yu a gepanulusun ok a matud de Panginoon ay geaged ok dikamo a tumaan de beloy mi.” Ta dehil de mahigpit a pag-aged na ay tinumalinga kami pan. ");
INSERT INTO due_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nano ay nun isin a adow a nákang kami de pigpanalanginan ay natagbu mi i isin a alepin a mahuna ta eya ay te libong de lawes na a gepahola diya kanya hanga i pakinabeng ni ponu na ide de paghola na. ");
INSERT INTO due_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ta eya ay inumabut dikami pati Pablo a geolang ni magioyo, “I oyo ide a agta ay katabeng ni Makedepat a Pinakamaditas ta ide ay getodu dikamo ti papalano kamo nalligtas.” ");
INSERT INTO due_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Dehil de pakamakmuk di a adow a peyedi na i maginon dide Pablo ay nagsawa i Pablo a linumingoy ta sinabi na nunde libong, “Pedodul ko ikaw de ngalan ni Hisu Kristo a lumaya ka de mahuna a iwina.” Ta nun nanon pala ay tinumotul un libong. ");
INSERT INTO due_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Misan ay nun kitain non, nun ponu ide ni mahuna a an di gehola eya a an di pala ide te pakinabeng diya ay binolan de ide Pablo pati Silas a inuwey de ide a paagow de te kapangyedihan ide de munisipio. ");
INSERT INTO due_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ta hinabla de ide duman de te kapangyedihan ide a tage Roma ta sinabi de, “I Hudyo ide a oyo ay gegulo de benwaan tam i. ");
INSERT INTO due_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Getodu ide ni ugeli a an nagkaddepat a tatanggep tam o tatalingaan man a manga tage Roma.” ");
INSERT INTO due_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kanya nagbulas pala dide un kauluuddi a kaagtaan ta pinaubedén ngona ide ni te kapangyedihan ide dingan pinalapdit ide Pablo pati Silas. ");
INSERT INTO due_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nano ay pagkalapdit dide ni makmuk a sila ay tinongog ide a pasilong de bilanggoan ta sinabi ni te kapangyedihan ide de magbebentay de bilanggoan a wet ide pakabbutan. ");
INSERT INTO due_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kanya sinilong ide ni magbebentay de kaduludisaladen nun bilanggoan ta pinasilpit na i singit de ni tabla a te tak-am. ");
INSERT INTO due_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nano ay nun gitna di ni abi ay nanalangin ide Pablo pati Silas pati nagkanta ide ni pagpodi de Makedepat ta gepatalikngoy pan i kakmukan ide a bilanggo. ");
INSERT INTO due_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ay dingan loktat a te yogyog ni malagdu a masakut kanya inumiwes-iwes i bilanggoan, a nakayesan a tambing i pintohan ide pati naukas di i manga tanikala ni manga bilanggo ide. ");
INSERT INTO due_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nano ay nun napagiyos i magbebentay ni bilanggoan a kinta na a nakayesan di i pintohan ide ay binurnut na i utak na ta buot na a gepakalibun ta inesip na a nakábut un bilanggo ide. ");
INSERT INTO due_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Misan ay inumolang a malagdu i Pablo a magioyo, “Wiyo kami la a pesan wet kamo gepakalibun.” ");
INSERT INTO due_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dingan inumaged ni salong un magbebentay ta sinumilong a maparipari a gekinkin ni takut na a linumuhud de kasagkaden ni Pablo pati Silas. ");
INSERT INTO due_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ta dingan pinabulwag na ide a sinabi, “Mangáyun, ano man i depat ko a yeyedi tangani nalligtas ok?” ");
INSERT INTO due_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ta tinubeg de eya, “Ay magpanulusun kamo de Panginoon a Hisus ta dingan nalligtas kamo ngani pati mittanak yu.” ");
INSERT INTO due_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Nano ay nagsabi ide ni surut nun Panginoon diya pati de pesan a nappataan de beloy na. ");
INSERT INTO due_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ta nun abi pala a inon ay inugesan na i biged ni lawes ni Pablo pati Silas dingan eya pati mittanak na ay lininod. ");
INSERT INTO due_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Dingan inikag na ide de beloy na ta nagpaakod eya ta nagkasalig eya a masakut pati mittanak na dehil de pagpanulusun de de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nano nun kinábiabian di ay dinodul ni te kapangyedihan ide ni benwaan i magbebentay de ide de magbebentay de bilanggoan ta sinabi de, “Pakábutan yu di i agta ide a iwina.” ");
INSERT INTO due_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ta binareta pan non ni magbebentay de Pablo ta sinabi na pa, “Ay tinutugun ni te kapangyedihan ide a pakábutan kamo di. Kanya nano ay nappatud kamo di a nototul a te kasampatan a innawa.” ");
INSERT INTO due_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Misan ay sinabi ni Pablo de magbebentay ide ni te kapangyedihan ide a, “Wet di ngona ta misan ikami ay biniyen di ni kapangyedihan a magi tage Roma ide ay pinalapdit de ikami de kasagkaden ni kaagtaan pati pinabilanggo de a ang kami pa hinatolan. Ta nano pan ay bekot ta pototul de ikami ni an katinggesan ni kaagtaan? Ay an non nappatud. Kanya sabiin yu dide a ide i dumio a magpatotul dikami.” ");
INSERT INTO due_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kanya pinatingges ngani de te kapangyedihan ide ni magbebentay de a ide Pablo ay te kapangyedihan pala a magi tage Roma. ");
INSERT INTO due_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ta ide ngani i kinumang dide Pablo ta nag-aged ide a patáwadin de ide dingan nun mapabulwag de ide ay inaged de a tumotul de benwaan de. ");
INSERT INTO due_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kanya nun binumulwag ide de bilanggoan ay tinumuloy ide de beloy ni Lidia ta dinatongan de duman i manga kabinsa ide. Nano ay dingan ngona ide tinumotul ay pinagsabian de pa i manga kabinsa ide a depat a tumuloy ide de pagpanulusun de. ");
INSERT INTO due_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nano ay pagtotul de ay sinumila ide de benwaan ide a Ampipolis pati Apolonia dingan dinumatong ide de Tesalonika ta de benwaan a inon ay te pigmitengan i Hudyo ide. ");
INSERT INTO due_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kanya nappaayun de ugeli ni Pablo ay sinumilong eya a nakipagpolong a tiluwon a simbe ta nakipagtantoan eya tungkul de kasulatan. ");
INSERT INTO due_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ta pinatingges na pati pinamatoden a depat ngona a i Kristo a Pinangako nun Makedepat ay magtiis ni kalibunan dingan eya ay maedup a liwet ta sinabi na, “I Hisus a oyo a pesabi ko dikamo ay eya ngani i Kristo a Pinangako nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ta i kakmukan ide a Hudyo ay inesip de a matud non ta nagpanulusun ide kanya ide ay sinumut de Pablo pati Silas. Maginon pala nagpanulusun i makmuk a an Hudyo a gegelang di de Makedepat pati mahunain a pegelang de benwaan. ");
INSERT INTO due_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Misan ay nasinna i Hudyo ide kanya tinipun de i migyedi ide ni malot ta pinapagbulas de i kaagtaan ta ginulo de i benwaan. Pati kinumang ide de beloy ni Hason a kataanan ni Pablo pati Silas ta linawag de ide a mapelit tangani ikagin de tebe ide de kasagkaden ni kaagtaan. ");
INSERT INTO due_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nano ay nun an de ide kinta ay inuwey de pan i Hason pati tipide a manga kabinsa de kasagkaden ni te kapangyedihan ide de benwaan ta inolang de a magioyo, “Dinumatong dio dikitam i oyo ide a manga agta a miggulo misan deno ide makadetong.” ");
INSERT INTO due_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ta sinabi de a tuloy, “I agta ide a gepanggulo ay pinataan ide ni Hason de beloy na. Ta ide ay getodu ni katalo de Hari a Kaditasan de Roma ta pesabi de pa a te duman kon a kakmukan pa a hari a i Hisus.” ");
INSERT INTO due_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nano nun iknain ni manga agta ide pati te kapangyedihan ide de benwaan i olang a inon ay nagulo ide a masakut. ");
INSERT INTO due_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ta i Hason pati mangáyun na ay pinangamitan ngona ni kuwarta ni te kapangyedihan ide a katibeyen a an pegulo a liwet i kaagtaan dingan ide ay pinatotul. ");
INSERT INTO due_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kanya ide Pablo pati Silas ay pinakang a tambing nun abi pa ni manga kabinsa ide de Beréa. Ta pagdetong de duman ay sinumilong ide de pigmitengan ni Hudyo ide. ");
INSERT INTO due_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Nano ay namas pa a piyon a pesabian i Hudyo ide dio, de Hudyo ide de Tesalonika ta buot de a masakut a gepatalikngoy de pagtodu ni Pablo. Ta de belang adow ay pelawag de i kasulatan tangani matinggesan de ti matud i pagtodu na. ");
INSERT INTO due_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Kanya makmuk ngani i nagpanulusun duman a Hudyo pati an Hudyo, lalaki man o mahuna, a pegelang de benwaan a inon. ");
INSERT INTO due_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Misan ay nun mabereta ni Hudyo ide de Tesalonika a gesabi pala i Pablo de tage Beréa ide ni surut nun Makedepat ay kinumang ide duman ta pinapagbulas de i kaagtaan kanya ginulo ni kaagtaan i benwaan. ");
INSERT INTO due_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Dehil de inon ay pinakang a tambing ni manga kabinsa ide i Pablo de kaginglan ni atab ta nawalat pan i Silas pati Timoteo. ");
INSERT INTO due_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Nano ay i nangatid ide de Pablo de kaginglan ni atab ay sinumut ide hanggen de Atenas ta dingan ide ay inumampulang de Beréa. Ta nagtutugun pan i Pablo dide Silas pati Timoteo a umabut ide a wet naaloy. ");
INSERT INTO due_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nun i Pablo ay geilat de Atenas ay kinta na a makmuk mangani i makedepat duman a an matud ta binumiyet i innawa na. ");
INSERT INTO due_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kanya ugnay a nagtodu eya a nakipagsurotan de Hudyo ide pati an Hudyo ide a gegelang de Makedepat. Ta duman de pigmitengan ni Hudyo misan de gitna ni benwaan ay nagtodu eya, adow adow, de belang pekita na. ");
INSERT INTO due_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nano ay te duman pala a tipide a gepilosopo a kakmukan ni Estoiko pati Epikureo ta pagkapagpatalikngoy de ay sinabi ni tipide, “Ano i pesabi ni oyo a an te kabuluhan?” Sinabi pan ni kakmukan a, “Gesabi eya ni tungkul de kakmukan a makedepat.” Sinabi de iwina dehil de pagsabi ni Pablo tungkul de Hisus a pinakaedup a liwet. ");
INSERT INTO due_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ta dingan inikag de eya de lugel a Areopago de gitna ni benwaan dingan sinabi de diya, “Nappatud man a sasabi mo dikami ti ano i bowon a oyo a pagtodu a pesabi mo dikami. ");
INSERT INTO due_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ta bowon yo dikami kanya buot mi a matinggesan ti ano i kabuluhan na.” ");
INSERT INTO due_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ta i tage Atenas ide pati bowon a detong duman ay an ide te buot a yeyedi ti an pagsurut pati pagpatalikngoy tungkul de misan ano a bowon a pagtodu. ");
INSERT INTO due_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kanya inumuddi i Pablo de gitna ni lugel a Areopago a nagsurut, “Manga tage Atenas, pekita ko a ikamo ay masépag a masakut a gehandug de makmuk a makedepat yu. ");
INSERT INTO due_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ta de pagtotul ko a gepakalawag de manga pigpodian yu ay kinta ko i isin a pighandogen a te solat a magioyo, ‘I oyo ay pighandogen de makedepat a an peabuyenan.’ Kanya nano ay gesurut ok dikamo ni tungkul de Makedepat a matud a pesabi yu a an yu peabuyenan ");
INSERT INTO due_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ta inon a Makedepat i nagyedi ni putok, langot pati pesan a nappataan duman. Ay eya ngani i Panginoon ni pesan ta an eya getaan de pigpodian a yinadi la ni agta. ");
INSERT INTO due_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Talage a an eya te kaelangan a unabis de tabeng ni agta ide ta eya pan i geboy ni edup, innawa pati pesan a kaelangan ni manga agta. ");
INSERT INTO due_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ta gepo de isin a agta ay yinadi na i kaagtaan a tage pesan a bensa a getaan de disapow ni putok i. Ta hinande na la i panahon a gesákup i manga te kapangyedihan ide dio de putok i pati kahanga ni nasasakopan de. ");
INSERT INTO due_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Hinande na yo tangani lawagin eya ni pesan, a aabuyenan pala. Ta eya ay am pan alayu de belang isin dikitam ");
INSERT INTO due_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ta talage i pesan a pagyedi tam, edup pati esip ay napadiya. Ta sinabi ni tipide a migyedi ni pigsabiin yu ide a, ‘Talage a ikitam ay mangának na.’ ");
INSERT INTO due_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Kanya nano dehil de ikitam ay mangának na a yinadi na ay wet tam eesipa a i Makedepat ay liburto a pelak ginto pati beto a yinadi la ni esip pati kumot ni agta. ");
INSERT INTO due_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nun nakasila a panahon ay an sinapot ni Makedepat i an te kabuluhan a edup ni kaagtaan misan nano ay pedodul na de agta, misan deno, a magsosol ide de pesan a mammalotin de. ");
INSERT INTO due_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ta hinande na di i adow a pepahatolan na a nappaayun de kamatoden i kaagtaan de isin a agta a pineta na ta pinamatoden na yo de pesan a agta nun pinakaedup na a liwet inon a agta a pineta na.” ");
INSERT INTO due_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nano ay nun iknain yo ni kaagtaan i tungkul de pagkaedup a liwet ay linibek eya ni tipide misan ay sinabi pan ni kakmukan, “Talage a buot mi a masakut a gepatalikngoy dikamo a liwet ni tungkul de oyo.” ");
INSERT INTO due_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kanya tinumotul duman i Pablo ");
INSERT INTO due_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","misan ay sinumut diya i tipide a nagpanulusun de Makedepat a kakoloy de i Dionisia a Huwis de lugel a Areopago pati mahuna a te ngalan a Damaris pati kakmukan pa. ");
INSERT INTO due_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pagkatapos ninon ay tinumotul i Pablo de Atenas a paagow de Korinto. ");
INSERT INTO due_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ta kinta na dio ide Akilo. Eya ay Hudyo a tage sákup ni Ponto. Ta ide pati bebi na a Priska ay bowon la a inumapo de Italia. Ta i pesan a Hudyo a nappataan de Roma ay pinatotul ni Klaudio a Hari a Kaditasan. Nano ay kinumang i Pablo de magkálaki ");
INSERT INTO due_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","a duman eya nakitaán. Ta dehil de ide ay kapadepade ni Pablo a magyeyedi ni tolde a beloy ay nakipagyedi eya dide. ");
INSERT INTO due_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ta de belang adow ni paimloy ay nagpatingges eya de pigmitengan ni Hudyo ide ta pinakisurotan na a mapelit a manulusun i manga Hudyo ide pati an Hudyo ide a gegelang de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nano ay nun dinumatong di ide Silas pati Timoteo a inumapo de sákup ni Masedonia ay hinande di ni Pablo i panahon na de pagsabi na pati pagpamatud de Hudyo ide a i Hisus ay eya ngani i Kristo a Pinangako nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Misan ay pinakitaloan de eya a linibek ni Hudyo ide kanya pinagpag na i delpong de bedu na a tande a kinapoyen de i surut nun Makedepat ta sinabi na, “Anok di te kasalanan misan padusahan kamo ta gepo nano ay noduman ok di de manga an Hudyo ide.” ");
INSERT INTO due_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ta eya ay tinumotul duman a nagtodu pan de beloy a alane ni pigmitengan ni Hudyo ide ta inon ay beloy ni isin a agta a te ngalan a Tisio Husto a gegelang de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nano ay i gepamahala a pinakamatande de pigmitengan a i Krispo pati mittanak na ay nagpanulusun de Panginoon. Pati i kamakmokan pa a tage Korinto a nagpatalikngoy de Pablo ay nagpanulusun a lininod na a tuloy. ");
INSERT INTO due_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nun isin a abi ay nagsurut i Panginoon de Pablo de pangitaán a magioyo ta sinabi na, “Wet ka matakut ta magtodu ka a wet netimok. ");
INSERT INTO due_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ta tatabengan ko ikaw kanya ang ka napalano ta dio de oyo a benwaan ay makmuk i nonulusun deko.” ");
INSERT INTO due_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kanya tinumaan duman i Pablo ni isin a taon pati kalahati a getodu ni surut nun Makedepat dide. ");
INSERT INTO due_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nano ay nun i Galion i napa ni gubernador de sákup ni Akaya ay nasurutsurotan i Hudyo ide a dekopin de i Pablo a eikag de de pighatolan. ");
INSERT INTO due_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ta sinumbong de eya, “Pinakisurotan a mapelit ni oyo a agta i kaagtaan a gepodi de Makedepat a an nappayun de betas mi a Hudyo.” ");
INSERT INTO due_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Nano ay nun gesurut di tebe i Pablo ay sinabi ni Galion a magioyo, “Be i pesumbong yu a oyo ay tungkul de pagsede ni betas o mabiyet a mammalotin ay talage ngani a tatalingaan ko ikamo a manga Hudyo. ");
INSERT INTO due_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Misan ay i pesumbong yu pan ay tungkul la de manga surut, manga ngalan pati de pagdodul yu la a manga Hudyo kanya anok nanhahatol de inon a sumbong yu ta ikamo dila i behala.” ");
INSERT INTO due_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Dingan pinabulwag na ide de pighatolan. ");
INSERT INTO due_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ta i Sostenes dila a gepamahala a pinakamatande pala de pigmitengan i binolan a binalbel ni manga an Hudyo ide de kasagkaden ni pighatolan misan ay an non sinapot ni Galion. ");
INSERT INTO due_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pagkatapos ninon ay tinumaan pa i Pablo de Korinto ni makmuk pa a adow dingan eya ay nabela de manga kabinsa ide. Ta sinumut diya i magkálaki a Priska pati Akilo a paagow de pigdongan a Senkrea. Ta duman ay pinapugtusan ni Pablo i sapok na a pinamatoden di i pinangako na a yeyedi dingan sinumakoy eya a paagow de Siria. ");
INSERT INTO due_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pagdetong de de Epeso a panwawalatan ni Pablo de magkálaki ay sinumilong pan i Pablo de pigmitengan ni Hudyo ide ta pinakisurotan na ide a mapelit. ");
INSERT INTO due_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Kanya nag-aged i manga agta ide diya a buot de tebe a tumaan eya duman ni naaloy pa a panahon misan ay an na buot. ");
INSERT INTO due_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ta sinabi na la dide, “Ako ay náampulang dila dio be nappaayun de kabuotan ni Makedepat.” Dingan tinumotul eya de Epeso a nappasakoy de bengka a paagow a tuloy de sákup ni Siria. ");
INSERT INTO due_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nano ay pagdong na de Sesarea ay sinumalakat ngona eya de Herusalem a nagbeti de kapolongan duman dingan eya ay tinumuloy la de Antiokia. ");
INSERT INTO due_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ta nun makataán eya duman ni untik a panahon ay tinumotol eya a liwet a sinilasilan na i bulubenwaan a sákup ni Galasia pati Prigia ta pinatibong na i pagpanulusun ni manga mag-aadel ide duman. ");
INSERT INTO due_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Nun nanon pala ay dinumatong pan de Epeso i isin a Hudyo a te ngalan a Apolos a pinanganak de Alehandria. Eya ay piyon a gesurut pati makmuk i katinggesan na tungkul de kasulatan a den. ");
INSERT INTO due_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ta eya ay natoduan tungkul de Panginoon ta masépag eya a getodu ni matud tungkul de Hisus hanggen de katinggesan na misan ay i katinggesan na la ay i pagtodu gepo de Huwen a Maglilenod. ");
INSERT INTO due_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Matibong i innawa na a gesabi de pigmitengan a Hudyo. Nano nun inikna eya ni Priska pati Akilo ay inikag de eya de beloy de dingan tinoduan de pa eya a matud tungkul de piyon a bereta a geapo de Makedepat. ");
INSERT INTO due_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ta nun eya ay te buot a nádepit de sákup ni Akaya ay pinatibong eya ni manga kabinsa ide duman ta nagsolat ide de mag-aadel ide de Akaya a tanggepin de a piyon i Apolos. Ta pagdetong na duman ay hanga i tabeng na dide a te pagpanulusun gepo de kosa a tabeng nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ta nagkatalo na a masakut i manga Hudyo ide de kasagkaden ni kaagtaan ta gepo de kasulatan ay pinamatoden na a i Hisus ay i Kristo a Pinangako nun Makedepat de Hudyo ide. ");
INSERT INTO due_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","I Apolos ay de benwaan a Korinto. I Pablo pan ay sinumulusagid de buluberiyu de gitna ni sákup ni Asia hanggen eya ay dinumatong de benwaan a Epeso ta kinta na duman i tipide a mag-aadel. ");
INSERT INTO due_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Dingan ide ay tinanto ni Pablo, “Tinanggep yu man di i Ispiritu nun Makedepat nun nagpanulusun kamo?” Misan ay tinumubeg ide, “Ay eyen ta am mi pa peikna i tungkul de Ispiritu nun Makedepat.” ");
INSERT INTO due_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Be maginon ay nun lininod kamo ay inóman i pepanulusonan yu?” Ta tinumubeg ide, “Ikami ay lininod la de paglinod ni Huwen a Maglilenod.” ");
INSERT INTO due_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Nano ay sinabi ni Pablo, “I paglinod ni Huwen ay tande la de pagsosol misan ay sinabi na de Hudyo ide a depat a ide ay manulusun de nappaabut diya a i Hisus.” ");
INSERT INTO due_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kanya nun iknain de i maginon ay nagpalinod ide a tande de pagpanulusun de de ngalan ni Panginoon a Hisus. ");
INSERT INTO due_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ta dingan nun tinapá ide ni Pablo ay linumusong dide i Ispiritu nun Makedepat ta nagsurut ide ni an de katinggesan pati nagsurut ide ni geapo de Ispiritu. ");
INSERT INTO due_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","I kamakmuk de ay te duman a sangpuwu pati aduwa a manga lalaki. ");
INSERT INTO due_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Nano ay de tiluwon a bulan ay gesilong i Pablo de pigmitengan ta nagtodu eya a matapang de napaduman, a nakipagtalo a nagpatingges a ti papalano a te kapangyedihan i Makedepat de innawa ni agta. ");
INSERT INTO due_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Misan ay te tipide a maksa i innawa de, a an de buot a nonulusun ta de kasagkaden ni kapolongan ay nagsurut ide ni malot tungkul de pagpanulusun de Panginoon kanya pan tinumotul i Pablo a kakoloy na i manga mag-aadel. Ta duman de iskul ni Tirano ay nagpatingges eya, adow adow, dide. ");
INSERT INTO due_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ta duman ay nagtodu eya a tuloy ni aduwa a taon kanya pan i pesan a tage sákup ni Asia, Hudyo man o an Hudyo ay inumikna ni surut nun Panginoon. ");
INSERT INTO due_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pati de padean ni Pablo ay nagyedi i Makedepat ni gepakataka a masakut. ");
INSERT INTO due_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kanya misan panyu la pati age i igud de de lawes ni Pablo ta dingan addein de de te orom ide ay gepiyon ngani ide pati gelayu i libong ide de lawes ni manga agta a te libong. ");
INSERT INTO due_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Nano ay te duman pan a tipide a Hudyo a nattulutotul a gepalayu ide ni libong de lawes ni agta ide ta sinubukan de a ginamit i ngalan ni Hisus de pagpalayu de ni libong. Ta sinabi de, “De ngalan ni Hisus a petodu ni Pablo ay pedodul ko ikaw a lumayu.” ");
INSERT INTO due_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","I gepalayu ide a oyo ay i pito a lalaki a mangának ni Eskeba a isin a pinakaponu a maghahandug a Hudyo. ");
INSERT INTO due_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Misan ay tinumubeg un libong, “Peabuyenan ko i Hisus pati Pablo a te kapangyedihan misan ay magi ino kamo la?” ");
INSERT INTO due_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dingan linumawot dide i lalaki a te libong a natalo na ide, a pinahedepan a masakut kanya ginumikan ide de beloy a inon a naubedan a te manga biged. ");
INSERT INTO due_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ta inon ay nabereta ni pesan a Hudyo pati an Hudyo a nappataan duman de Epeso kanya ide ay nagkaduman ni hanga a takut ta nagpodi ide de ngalan ni Hisus. ");
INSERT INTO due_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Pati makmuk ngani de gepanulusun ide i nagidinatong, a nagipinagsosol de malot a pagyedi de de kasagkaden ni manga kabinsa de. ");
INSERT INTO due_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ta dinumatong pala ide a nanggemit ni geling. Ta nun tinipun de i kasangkapan de a magi libro ay dingan sinunug de de pekita ni pesan ta nun bilangin de i kahalage ni kasangkapan a inon ay te lima a puwu a lebu a pelak. ");
INSERT INTO due_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kanya dehil de sinumapit a inon ay kinumálat a masakut pati nanalo i surut nun Makedepat. ");
INSERT INTO due_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pagkatapos ninon ay nagbelak i Pablo gepo de Ispiritu nun Makedepat a de pagkang na de Herusalem ay násagid ngona de porobinsia a Masedonia pati Akaya. Ta sinabi na a, “Buot ko a pag-apo ko de Herusalem ay nákang ok pan de Roma.” ");
INSERT INTO due_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Misan ay pinapaona na i Timoteo pati Erasto de Masedonia. I aduwa a oyo ay kakmukan de getabeng diya ta tinumaan pa eya ni untik a panahon de sákup ni Asia. ");
INSERT INTO due_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nano ay dehil de gengsa ni kakmukan de Bowon a Pagtodu ay nagkaduman de Epeso ni hanga a gulo. ");
INSERT INTO due_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ta te duman pan duman a lalaki a te ngalan a Demitrio a magyeyedi ni beloybeloyen a pelak ni makedepat a an matud a Diana. Ta i pesan a magyeyedi gepo de pelak ay te hanga a pakinabeng. ");
INSERT INTO due_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kanya tinipun na i pesan a te pagyedi a maginon ta sinabi na, “Mangáyun, katinggesan yu a dehil de pagyedi tam a oyo ay hanga i pakinabeng tam. ");
INSERT INTO due_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Misan ay pekita tam pati peikna i pagyedi ni Pablo a oyo dio man de Epeso pati de pesan a sákup ni Asia. Ta pesabi na a an kon Makedepat a matud i peyedi la ni kumot. Kanya dehil de inon ay nakiblag i kamakmokan de matud tam a pagpodi ta gepanulusun ide de pagtodu na. ");
INSERT INTO due_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kanya malot ngani i násapit de pagyedi tam dehil de pagtodu a oyo. Pati pan peeyenan de ni kabuluhan i beloy a hanga ni makapangyedihan a Diana a eya pam pa i pepodi ni pesan dio de Asia pati misan deno a kadepit. Misan nano ay neeyenan di ni kabuluhan.” ");
INSERT INTO due_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nano ay pagkaikna de ninon ay nágengsa ide a masakut dingan ide ay nagiinolang ni magioyo, “Makapangyedihan ngani i makedepat a Diana a tage dio de Epeso i.” ");
INSERT INTO due_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kanya nagkaduman ni hanga a gulo de benwaan. Ta de paggikan de a paagow de pigpolongan ni benwaan ay inuwey de ide Gayo pati Aristarko a tage Masedonia a kakoloy ni Pablo de pagtotul na. ");
INSERT INTO due_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Talage a binuot ni Pablo a eya ay násagkad de kaagtaan duman misan ay sinablow eya ni mag-aadel ide. ");
INSERT INTO due_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pati pinagsabian eya a mahigpit ni manga ayun na a tipide a ponu de Asia a wet eya nákang de pigpolongan. ");
INSERT INTO due_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ta i kapolongan a inon ay nagulo a masakut. I kakmukan ay gepinag-olang ni isin ta i kakmukan ay bukud i peolang de ta an katinggesan ni kakmukan ti ano ta ide ay nattipun. ");
INSERT INTO due_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Te duman a geesip a kanya ide nattipun ay dehil de Alehandro ta pinakadepit eya ni Hudyo ide de kasagkaden ni manga agta ta pinapa ide ni Alehandro tangani eya ay makapagsurut para de Hudyo la ide. ");
INSERT INTO due_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Misan ay nun inabuyenan di eya ni kaagtaan a eya ay Hudyo ay inumolang ide ni aduwa a odes a magioyo, “Makapangyedihan ngani i makedepat a Diana a tage dio de Epeso i.” ");
INSERT INTO due_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nano ay nun mapatimok di ni isin a ponu de benwaan i pag-olang ni kaagtaan ay sinabi na, “Manga tage Epeso, katinggesan di ni pesan a ikitam ay gealáge de beloy a hanga ni makapangyedihan a Diana. Pati pealagean tam pala i beto a benal a nadegdeg gepo de langot. ");
INSERT INTO due_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Inon ay matud a masakut kanya depat a tumimok kamo a wet maparipari a nanyeyedi ni malot. ");
INSERT INTO due_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ta i inikag yu pan ide dio ay am pan ide gesurut ni malot a tungkul de Diana a makedepat tam o gepannakow man de beloy na. ");
INSERT INTO due_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kanya be i Demetrio pati mangáyun na a magyeyedi gepo de pelak ay gesumbong de misan dino ay nappatud ngani ta te pighatolan pati te huwis ide a depat a nanhahatol kanya magsumbong ide duman. ");
INSERT INTO due_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Misan ay be ikamo ay te duman pa a kakmukan a buot a pasurutsurotan ay nappatud non be gepolong kitam a nappaayun de betas tam. ");
INSERT INTO due_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Misan ay nano de adow a oyo ay te panganib kitam ta kati hahabla kitam de huwis dehil de gulo a oyo, a ang kitam pan te nadedehilan.” ");
INSERT INTO due_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kanya pagkasabi na ninon ay pinatotul na di i manga agta ide a nagpolong. ");
INSERT INTO due_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dingan nun tinumimok di i gulo ay pinakangan ni Pablo i mag-aadel ide a pinatibong na i innawa de ta dingan nabela eya dide a nákang de Masedonia. ");
INSERT INTO due_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ta nun kinulukangan na i sulusákup ni iwina a porobinsia ay pinagsabian na ni makmuk a surut i manga gepanulusun ide duman ta tinumuloy la eya de Akaya. ");
INSERT INTO due_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Nano ay tinumaan eya duman ni tiluwon a bulan ta násakoy tebe eya a paagow de Siria misan ay nabereta na a te belak a malot i Hudyo ide diya kanya binalak na pan a nesila di de Masedonia a mamala de pag-ampulang na. ");
INSERT INTO due_vpl VALUES ("AC20_4","074_20_4",