﻿USE sofia;
DROP TABLE IF EXISTS sofia.dso_vpl;
CREATE TABLE dso_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dso_vpl WRITE;
INSERT INTO dso_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ଏଟା ଅଇଲାନି ଜିସୁକିରିସ୍‌ଟର୍‌ ଆନିଦାଦିମନର୍‌ ନାଉଁ ତାଲିକା । ସେ ଦାଉଦ୍‌ ବଁସର୍‌ ରଇଲା ଆରି ଦାଉଦ୍‌ ଅବ୍‌ରାଆମ୍ ବଁସର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଅବ୍‌ରାଅମର୍‌ ପଅ ଇସାକ୍‌, ଇସାକର୍‌ ପଅ ଜାକୁବ୍‌, ଜାକୁବର୍‌ ପଅ ଜିଉଦା ଆରି ତାର୍‌ ବାଇମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ଜିଉଦା ପେରସ୍‌ ଆରି ଜେରଅର୍‌ ବାବା ରଇଲା, ତାକର୍‌ ମାଆ ଅଇଲାନି ତାମର୍‌ । ପେରସର୍‌ ପଅ ଏସ୍‌ରନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ଏସ୍‌ରନର୍‌ ପଅ ଆରାମ୍‌, ଆରାମର୍‌ ପଅ ଅମିନାଦବ୍‌ ଅମିନାଦବର୍‌ ପଅ ନଅସନ୍‌, ନଅସନର୍‌ ପିଲା ସଲ୍‌ମନ୍‌ ");
INSERT INTO dso_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସଲ୍‌ମନର୍‌ ପଅର୍‌ ନାଉଁ ବୟଜ୍‌, ବୟଜର୍‌ ମାଆ ରାଅବ୍‌ । ବୟଜର୍‌ ପଅର୍‌ ନାଉଁ ଅବେଦ୍‌ ଆରି ଅବେଦର୍‌ ମାଆର୍‌ ନାଉଁ ରୁତ୍‌ । ଅବେଦର୍‌ ପଅ ଜସୟ, ");
INSERT INTO dso_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଦାଉଦ୍‌ ରାଜାର୍‌ ସାସନ୍‌ ବେଲେ ଅନି ଜେଡେବଲ୍‌ ଇସ୍‌ରାଏଲ୍‌ ଲକ୍‌ମନ୍‌କେ ବାବିଲନ୍‌ ଦେସେ ବାନ୍ଦି ନେଇରଇଲା ଜାକ ସେତ୍‌କି ଆନିଦାଦିମନର୍‌ ତାଲିକା ଆଚେ । ଜସୟର୍‌ ପଅ ଦାଉଦ୍‌ ରାଜା । ଉରିୟର୍‌ ମାଇଜିର୍‌ ପେଟେ ଅନି ସଲ୍‌ମନ୍‌କେ ଜନମ୍‌ ଦେଲା, ");
INSERT INTO dso_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ସଲମନର୍‌ ପଅ ରିଅବିୟାମ୍‌ ରିଅବିୟାମର୍‌ ପଅ ଅବିୟ । ");
INSERT INTO dso_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଅବିୟର୍‌ ପଅ ଆସା, ଆସାର୍‌ ପଅ ଜିଅସାପଟ୍‌, ଜିଅସାପଟର୍‌ ପଅ ଜରାମ୍‌, ଜରାମର୍‌ ପଅ ଉଜିୟ । ");
INSERT INTO dso_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜିୟର୍‌ ପଅ ଜତାମ୍‌, ଜତାମର୍‌ ପଅ ଆଅସ୍‌, ଆଅସର୍‌ ପଅ ଇଜକିୟ । ");
INSERT INTO dso_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ଇଜକିୟର୍‌ ପଅ ମନସେଅ, ମନସେଅର୍‌ ପଅ ଆମନ୍‌, ଆମନର୍‌ ପଅ ଜସିୟ । ");
INSERT INTO dso_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ଜସିୟ ବାବିଲନ୍‌ ନଅରେ ବାସା ଅଇରଇଲା ବେଲେ, ଜିକନିୟ ଆରି ତାର୍‌ ବାଇମନ୍‌ ଜନମ୍‌ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ବାବିଲନେ ବନ୍ଦିଅଇ ସାର୍‌ଲା ପଚେଅନି ଜିସୁର୍‌ ଜନମ୍‌ ଜାକ ଏତ୍‌କି ଆନିଦାଦିମନର୍‌ ତାଲିକା ଆଚେ । ଜିକନିୟ ବାବିଲନେ ବାସାଅଇରଇଲା ବେଲେ, ସଲ୍‌ଟିଏଲ୍‌ ଜନମ୍‌ ଅଇଲା, ସଲ୍‌ଟିଏଲର୍‌ ପଅ ଜିରୁବାବେଲ୍‌, ");
INSERT INTO dso_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବାବେଲର୍‌ ପଅ ଅବିଉଦ୍‌, ଅବିଉଦର୍‌ ପଅ ଏଲିୟାକିମ୍‌, ଏଲିୟାକିମର୍‌ ପଅ ଅଜୁର୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଅଜୁର୍‌ ପଅ ସାଦକ୍‌, ସାଦକର୍‌ ପଅ ଆକିମ୍‌, ଜାକିନର୍‌ ପଅ ଏଲିଉଦ୍‌, ଏଲିଉଦର୍‌ ପଅ ଏଲାଜାର୍‌, ଏଲାଜାରର୍‌ ପଅ ମତ୍‌ତାନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ମତ୍‌ତାନର୍‌ ପଅ ଜାକୁବ୍‌, ଜାକୁବର୍‌ ପଅ ଜସେପ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ଏ ଜସେପ୍‌ ମରିୟମ୍‌କେ ବିବା ଅଇରଇଲା । ମରିୟମର୍‌ ପେଟେଅନି ଜିସୁ ଜନମ୍‌ ଅଇରଇଲା । ଜିସୁ କିରିସ୍‌ଟକେ ମସିଅ ବଲି ମିସା ନାଉଁ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଏନ୍ତାରି ଅବ୍‌ରାଆମର୍‌ତେଇ ଅନି ଦାଉଦ୍‍ ରାଜାର୍‌ ଜାକ ଚଉଦ ଉତାର୍‌, ଦାଉଦର୍‌ତେଇ ଅନି ବାବିଲନ୍‌ ବନ୍ଦିରଇଲା ଜାକ ଚଉଦ ଉତାର୍‌, ଆରି ବାବିଲନେ ବନ୍ଦିଅଇରଇଲା ବେଲେଅନି ଜିସୁକିରିସ୍‌ଟର୍‌ ଜନମ୍‌ ଜାକ ଚଉଦ ଉତାର୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଏଟା ଅଇଲାନି ଜିସୁ କିରିସ୍‌ଟର୍‌ ଜନମ୍‌ ବିସଇ । ଜିସୁର୍‌ ମା ମରିୟମର୍‌ ସଙ୍ଗ୍‌ ଜସେପ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡାର୍‌ ପାଇ ବିବା ମାଙ୍ଗ୍‌ନି ଅଇରଇଲା । ମାତର୍‌ ସେମନର୍‌ ବିବା ନ ଅଇତେ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ଅନି ଗାଗ୍‌ଡେ ଅଇରଇବାଟା ମରିୟମ୍‌ ଜାନିପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ଜସେପ୍‌ ଗଟେକ୍‌ ଦରମ୍‌ ଲକ୍‌ ରଇଲା ଆରି ସବୁବେଲେ ସତ୍‌ କାମ୍‌ କର୍‌ତେରଇଲା । ଆରି ମରିୟମ୍‌କେ ଲକ୍‌ମନର୍‌ ଟାନେ ନିନ୍ଦା କାତା ସୁନାଇବାକେ ମନ୍‍ ନ କର୍‌ତେ ରଇଲା । ସେଟାର୍‌ପାଇ କେ ନାଜାନ୍‌ତେ ତାର୍‌ ବିବା ମାଙ୍ଗ୍‌ନି ପିଟାଇଦେବାକେ ଉପାଇ ପାଁଚ୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ସେ ଏନ୍ତି ଉପାଇ ପାଁଚ୍‌ଲା ବେଲେ, ଜସେପ୍‌କେ ଗଟେକ୍‌ ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ ସପ୍‍ନେ ଦେକାଇ ଅଇ କଇଲା, ଏ ଦାଉଦର୍‌ ନାତିର୍‌ ତିତି ଜସେପ୍‌, ଡର୍‌ନାଇ । ମରିୟମ୍‌କେ ମାଇଜି କରି ସଙ୍ଗଅ । କାଇକେବଇଲେ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ଅନି ସେ ଗାଗ୍‌ଡେ ଅଇଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ତାର୍‌ଟାନେଅନି ଗଟେକ୍‌ ପିଲା ଜନମ୍‌ ଅଇସି, ତମେ ତାକେ ଜିସୁ ବଲି ନାଉଁ ଦିଆସ୍‌, କାଇକେବଇଲେ ସେ ତାର୍‌ ଲକ୍‌ମନ୍‌କେ ସେମନର୍‌ ପାପେଅନି ଉଦାର୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ଆଇବା ଦିନ୍‌ମନ୍‌କେ କାଇଟା ଅଇସି ବଲି, ପର୍‌ମେସର୍‌ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତାକେ ପାଟାଇ ଜନ୍‌ କାତା ସୁନାଇରଇଲା, ସେଟା ପୁରାପୁରୁନ୍‌ ଅଇବାକେ ଏ ସବୁ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡି ଗାଗ୍‌ଡେ ଅଇ ପିଲା ଜନମ୍‌ କର୍‌ସି, ଆରି ସେ ପିଲା ଲକ୍‌ମନର୍‌ ଟାନେ ଇମାନୁଏଲ୍‌ ବଲି ନାମାଇ ଅଇସି, ଏ ନାଉଁର୍‌ ଅରତ୍‌ ଅଇଲାନି, ପର୍‌ମେସର୍‌ ଆମର୍‌ ସଙ୍ଗ୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଜସେପ୍‌ ସଇଲା ଟାନେଅନି ଉଟି, ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ ଜେନ୍ତି କଇରଇଲା, ସେନ୍ତି କଲା । ମରିୟମ୍‌କେ ବିବା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ମାତର୍‌ ସେ ପିଲା ଜନମ୍‌ ନ ଅଇବା ଜାକ ମରିୟମ୍‌ ସଙ୍ଗ୍‍ ସୁଆବସା କରେନାଇ । ଜସେପ୍‌ ସେ ପିଲାକେ ଜିସୁ ବଲି ନାଉଁ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ଏରଦ୍‌ ରାଜାର୍‌ ସାସନ୍‌ ବେଲେ, ଜିଉଦା ରାଇଜର୍‌ ବେତ୍‌ଲିଇମେ ଜିସୁ ଜନମ୍‌ ଅଇଲା । ଜନମ୍‌ ଅଇ ଚନେକ୍‌ ଜିବାକେ ପୁରୁବ୍‌ ଦେସର୍‌ କେତେଟା ତାରାର୍‍ ବିସଇ ପଡ୍‌ତେ ରଇବା ପଣ୍ଡିତ୍‌ମନ୍‌ ଜିରୁସାଲାମେ ଆସି ପାଚାର୍‌ଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ଜନ୍‌ ପିଲା ଜିଉଦିମନର୍‌ ରାଜା ଅଇବାକେ ଜନମ୍‌ ଅଇଲାଆଚେ, ସେ କନ୍ତି ଆଚେ ? କାଇକେବଇଲେ ଆମେ ପୁରୁବ୍‌ ଦେସେ ତାର୍‌ ତାରା ଦେକି ତାକେ ପୁଜା କର୍‌ବାର୍‌ ଆସିଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ପଣ୍ଡିତ୍‌ମନର୍‌ କାତା ସୁନି ଏରଦ୍‌ ରାଜା ଆରି ତାର୍‌ ସଙ୍ଗ୍‍ ରଇବା ଜିରୁସାଲାମର୍‌ ଲକ୍‌ମନ୍‌ ସବୁ କିଲ୍‌ବିଲ୍‌ ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ଆରି ଏରଦ୍‌ ସବୁ ମୁକିଅ ପୁଜାରିମନ୍‌କେ ଆରି ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌କେ ଡାକାଇ କରି, “ମସିଅ ଜେ କି କିରିସ୍‌ଟ କନ୍‌ ଜାଗାଇ ଜନମ୍‌ ଅଇଆଚେ ?” ସେଟା ସେମନର୍‌ତେଇ ଅନି ବୁଜ୍‌ବାକେ ଚେସ୍‌ଟା କଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ପଣ୍ଡିତ୍‌ମନ୍‌ ଏରଦ୍‌ ରାଜାକେ କଇଲାଇ, ଜିଉଦା ରାଇଜର୍‌ ବେତ୍‌ଲିଇମ୍‌ ଗଡେ, ଜନ୍‌ଟାକି ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ଏନ୍ତାରି ଲେକିଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ଏ ଜିଉଦା ଦେସର୍‌ ବେତ୍‌ଲିଇମ୍‌, ତୁଇ ଜିଉଦା ରାଇଜର୍‌ ମୁକିଅ ଗଡ୍‍ମନର୍‌ତେଇ ଅନି ସାନ୍‌ ନଉଁସ୍‌, କାଇକେବଇଲେ ମର୍‌ ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌କେ ବାଟ୍‌ ଦେକାଇସି, ଏନ୍ତାରି ଗଟେକ୍‌ ସାସନ୍‌କାରିଆ ତର୍‌ତେଇଅନି ଉବଜ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ଏଟା ସୁନି କରି ଏରଦ୍‌ ରାଜା ସେ ପଣ୍ଡିତ୍‌ମନ୍‌କେ ଲୁଚ୍‌ତେ ଡାକାଇ, ତାରା କନ୍‌ ବେଲାଇ ଉଦିରଇଲା, ସେମନର୍‌ତେଇ ଅନି ଟିକ୍ ସଙ୍ଗ୍‌ ବୁଜିନେଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ତାର୍‌ପଚେ ସେମନ୍‌କେ କଇ ପାଟାଇଲା, “ତମେ ଜାଆ ଆରି ବେତ୍‌ଲିଇମେ ସେ ପିଲାକେ ନିମାନ୍‌ କରି କଜିଦେକା, ଆରି ପିଲା ମିଲ୍‌ଲେସରି ମକେ ଜାନାଆ ମୁଇ ମିସା ଜାଇ ତାକେ ଦର୍‌ସନ୍‌ କର୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ପଣ୍ଡିତ୍‌ମନ୍‌ ରାଜାର୍‌ କାତା ସୁନି ସେ ଜାଗାଇଅନି ବାରିଗାଲାଇ । ଗାଲାବେଲେ ଏଦେ ଦେକା ! ସେମନ୍‌ ପୁରୁବ୍ ଦେସେ ଜନ୍‌ ତାରା ଦେକି ରଇଲାଇ, ସେ ତାରା ଆରି ତରେକ୍‌ ଡିସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ସେମନ୍‌ ତାରା ଦେକି ବେସି ସାର୍‌ଦା ଅଇଗାଲାଇ । ତାରା ସେମନର୍‌ ଆଗେ ଜାଇକରି ଜିସୁ ରଇଲା ଜାଗାର୍‌ ଉପ୍‌ରେ ଅଟ୍‌କିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ପଣ୍ଡିତ୍‌ମନ୍‌ ସେ ଗର୍‌ ବିତ୍‌ରେ ପୁରି ପିଲାକେ ତାର୍‌ ମା ମରିୟମ୍‌ ସଙ୍ଗ୍‌ ରଇଲାଟା ଦେକି, ତାକେ ମାଣ୍ଡିକୁଟା ଦେଇ ଜୁଆର୍‌ କଲାଇ, ଆରି ଆନିରଇବା ସୁନା, କୁନ୍ଦୁୁରୁ ଆରି ଗନ୍ଦ୍‌ରସ୍‌ ବେଟି, ପିଲାକେ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ପଚେ ସେମନ୍‌ ଏରଦର୍‌ ଲଗେ ଆରିତରେକ୍‌ ନ ଜାଇକରି ବିନ୍‌ ବାଟେ ନିଜର୍‌ ଦେସେ ବାଉଡି ଗାଲାଇ । କାଇକେବଇଲେ ଏରଦର୍‌ ଟାନେ ଆରିତରେକ୍‌ ବାଉଡି ନ ଜିବାକେ ପର୍‌ମେସର୍‌ ସେମନ୍‌କେ ସପ୍‍ନେ ଆଦେସ୍‌ ଦେଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ପଣ୍ଡିତ୍‌ମନ୍‌ ଗାଲାପଚେ, ପର୍‌ମେସରର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ଜସେପ୍‌କେ ସପ୍‌ନେ ଦର୍‌ସନ୍‌ ଦେଇ କଇଲା, “ଉଟ୍‌, ପିଲାକେ ଆରି ତାକର୍‌ ଆୟାକେ ଦାରି ମିସର୍‌ ଦେସେ ଦାପ୍‌ରେ ଉଟିଜା । ଏରଦ୍‌ ପିଲାକେ ମରାଇବାକେ କଜିବୁଲ୍‌ସି । ମୁଇ ସେ ଜାଗା ଚାଡା ବଲି ନ କଇବା ଜାକ ତେଇସେ ରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ଏ କାତା ସୁନି ଜସେପ୍‌ ସେ ରାତି, ପିଲାକେ ଆରି ତାର୍‌ ମାକେ ଦାରି ମିସର୍‌ ଦେସେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ଏରଦ୍‌ ରାଜା ମର୍‌ବା ଜାକ ମିସର୍‌ ଦେସେସେ ରଇଲାଇ, ଜେନ୍ତାର୍‌ କି ବବିସତ୍‌ବକ୍‌ତା କଇରଇଲା ମାପ୍‌ରୁର୍‌ ବାକିଅ ସିଦ୍‌ ଅଇଲା, ମର୍‌ ପିଲାକେ ମୁଇ ମିସର୍‌ ଦେସେଅନି ଡାକି ଆନ୍‌ଲି । ");
INSERT INTO dso_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ପୁରୁବ୍‌ ଦେସେଅନି ଆସିରଇଲା ପଣ୍ଡିତ୍‌ମନ୍‌ ତାକେ ନାଡାଇ କରି ଉଟିଗାଲାଇ ଆଚତ୍‌ ବଲି ଜାନି, ଏରଦ୍‌ ବେସି ରିସା ଅଇଗାଲା । ବେତ୍‌ଲିଇମ୍‌ ଆରି ସେ ଲଗେ ପାକେ ରଇବା ଦୁଇ ବରସ୍‌ ଅନି ତଲେ ରଇଲା ସବୁ ପିଲାମନ୍‌କେ ମରାଇବାକେ ଆଦେସ୍‌ ଦେଲା । ପଣ୍ଡିତ୍‌ମନର୍‌ ଟାନେଅନି ତାରା ଡିସ୍‌ତେ ରଇବା ବେଲା ସେ ଜାନିରଇଲା । ସେ ଇସାବେ ପିଲାମନର୍‌ ବରସ୍‌ ଟିକ୍‌ କରିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ଏନ୍ତି ଅଇଲାଜେ ଜିରିମିୟ ବବିସତ୍‌ବକ୍‌ତା କଇଲା ଏ ବାକିଅ ପୁରାପୁରୁନ୍‌ ଅଇଲା । ସେ ଏନ୍ତି କଇରଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ରାମା ନାଉଁର୍‌ ସଅରେ ମାର୍‌ଚପ୍‌ ଅଇ କାନ୍ଦ୍‌ବାଟା ସୁନି ଅଇଲାନି, ରାଏଲ୍‌ ତାର୍‌ ପିଲାମନର୍‌ ପାଇ କାନ୍ଦ୍‌ଲାନି । ତାକେ ଜେତେକ୍‌ ବୁଜାଇଲେ ମିସା ବୁଜେନାଇ । କାଇକେବଇଲେ ତାର୍‌ ପିଲାମନ୍‌ ସବୁ ମରିଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ଏରଦ୍‌ ମଲାପଚେ, ଏଦେ ଦେକା ! ମାପ୍‌ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ମିସର୍‌ ଦେସେ ଜସେପ୍‌କେ ଦର୍‌ସନ୍‌ ଦେଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ଉଟ୍‌ ଆରି ବାରଇକରି, ଦୁଇ ମାଆ ପିଲାକେ ଇସ୍‌ରାଏଲ୍‌ ଦେସେ ଦାରିଜା । କାଇକେବଇଲେ ଜନ୍‌ ଲକ୍‌ମନ୍‌ କି ପିଲାର୍‌ ଜିବନ୍‌ ନେବାକେ ଚେସ୍‌ଟା କର୍‌ତେରଇଲାଇ, ସେମନ୍‌ ମରିଗାଲାଇ ଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ଜସେପ୍‌ ଏ କାତା ସୁନି ଜିସୁ ଆରି ତାର୍‌ ମାଆ ମରିୟମ୍‌ ସଙ୍ଗ୍‍ ବାରଇକରି ଇସ୍‌ରାଏଲ୍‌ ଦେସେ ବାଉଡି ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ମାତର୍‌ ଜସେପ୍‌, ଏରଦର୍‌ ପଚେ ତାର୍‌ ପଅ ଆର୍‌କିଲାୟ ଜିଉଦା ରାଇଜର୍‌ ରାଜା ଅଇଆଚେ ବଲି ସୁନିକରି ତେଇ ଜିବାକେ ଡର୍‍ଲା । ");
INSERT INTO dso_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ମାତର୍‌ ଆରିଗଟେକ୍‌ ବିନ୍‌ ସପନ୍‌ ଇସାବେ ଗାଲିଲି ଦେସେ ଜାଇକରି ନାଜରିତ୍‌ ନାଉଁର୍‌ ଗଡେ ବାସା ଅଇ ରଇଲା । ଜେନ୍ତାର୍‌ କି ବବିସତ୍‌ବକ୍‌ତା କଇଲା ଏ ବାକିଅ ସିଦ୍‌ ଅଇଲା । ସେ ଏନ୍ତି ବଲି କଇରଇଲା, “ସେ ନାଜରିତିୟା ବଲି ଡାକ୍‌ପୁଟା ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ସେବେଲେ ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ଜିଉଦା ରାଇଜର୍‌ ମରୁବାଲି ବୁଏଁ ଆସି ଜାନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ସେ ଏନ୍ତି ବଲି କଇତେରଇଲା, “ପାପ୍‌ଟାନେଅନି ବାଉଡା, କାଇକେବଇଲେ ସରଗ୍‌ ରାଇଜ୍‌ ଲଗେ କେଟ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ଜିସାଇୟ ବବିସତ୍‌ବକ୍‌ତା ଜନ୍‌ ଲକର୍‌ ବିସଇନେଇ ଏ ବାକିଅ କଇରଇଲା, ଜଅନ ସେ, ସେ ଲକ୍‌ । ମରୁବାଲି ବୁଏଁ ଗଟେକ୍‌ ଲକ୍‌ ଆକ୍‌ମାରି କଇଲାନି, “ମାପ୍‌ରୁର୍‌ ବାଟ୍‌ ତିଆର୍‌ କରା, ସେ ଆଇବାକେ ଗଟେକ୍‌ ସଲକ୍‌ ବାଟ୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଜଅନ୍‌ ପିନ୍ଦ୍‌ବାଟା ଉଁଟ୍‌ ଚାମ୍‌ ସଙ୍ଗ୍‌ ତିଆର୍‌ ଅଇ ରଇଲା । ଆରି ଚାମର୍‌ ଆଁଟାବେଡା ବାନ୍ଦିଅଇତେ ରଇଲା । ସେ ଚିଟ୍‌କା ଆରି ବନେ ରଇବା ମୁଉ କାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ସେ ବେଲେ ଜିରୁସାଲମ୍‌ ଅନି ଗୁଲାଇ ଜିଉଦା ଦେସ୍‌ ଆରି ଜର୍‌ଦନର୍‌ ପାକର୍‌ ସବୁଟାନର୍‌ ଲକ୍‌ମନ୍‌ ବାରଇ ଜଅନର୍‌ ଲଗେ ଆଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ଆରି ନିଜର୍‌ ନିଜର୍‌ ପାପ୍‌ କଲାଟା ମାନିଅଇକରି ଜଅନର୍‌ ଟାନେ ଜାଇ ଜର୍‌ଦନ୍‌ ଗାଡେ ଡୁବନ୍‌ ନେଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ମାତର୍‌ ପାରୁସି ଆରି ସାଦୁକି ମନର୍‌ ବିତ୍‌ରେ ଅନି ମିସା କେତେକ୍‌ ଲକ୍‌ ଡୁବନ୍‌ ନେବାକେ ଆଇବାଟା ଦେକି ଜଅନ୍‌ ସେମନ୍‌କେ କଇଲା, “ଏ ବେସି ବିସ୍‌ରଇବା ସାଁପର୍‌ ପାରା ବଁସର୍‌ ଲକ୍‌ମନ୍‌, ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇବା ଡଣ୍ଡ୍‌ତେଇ ଅନି ପାଲାଇବାକେ ତମ୍‌କେ କେ ଚେତ୍‌ନା ଦେଲା ? ");
INSERT INTO dso_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ତେବର୍‌ ପାଇ, ଜଦି ପାପ୍‌ କାମ୍‌ କର୍‌ବାଟା ଚାଡିଆଚାସ୍‌, ସେନ୍ତାର୍‌ଆଲେ ନିକ କାମ୍‌ କରି ଦେକାଆ । ");
INSERT INTO dso_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ଅବ୍‌ରାଆମ୍ ଆମର୍‌ ପୁର୍‌ବର୍‌ ଆନିଦାଦି ବଲି କଇଲେ ତମ୍‌କେ ପର୍‌ମେସର୍‌ ଦେବା ଡଣ୍ଡ୍‌ ନ ମିଲେ ବଲି ବାବା ନାଇ । ମୁଇ ତମ୍‌କେ କଇଲିନି, ପର୍‌ମେସର୍‌ ପାକ୍‌ନାତେଇ ଅବ୍‌ରାଆମର୍‌ ବଁସ୍‌ ତିଆର୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ଆରି ଏବେ ମିସା ଗଚ୍‌ମନର୍‌ ବୁନ୍ଦେ ଟେଙ୍ଗିଆ ଲାଗିଆଚେ । ଜନ୍‌ ଗଚ୍‌ ନିକ ପଲ୍‌ ନ ପଲେ, ସେଟା କାଟିକରି ଜଇଟାନେ ପିଙ୍ଗା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ମୁଇ ସିନା ତମ୍‌କେ ପାପେଅନି ମନ୍‌ ବଦ୍‌ଲାଇଲାଟା ଦେକାଇଅଇବାକେ ବଲି ପାନିତେଇ ଡୁବନ୍‌ ଦେଲିନି, ମାତର୍‌ ମର୍‌ ପଚେ ଜେ ଆଇଲାନି, ସେ ମର୍‌ତେଇ ଅନି ଅଦିକ୍‌ ବପୁଟା । ତାର୍‌ ପାଦର୍‌ ପାଣ୍ଡଇ ମିସା ଦାରି ନେବାର୍‌ ମର୍‌ ଅଦିକାର୍‍ ନାଇ, ସେ ତମ୍‌କେ ସୁକଲ୍‌ଆତ୍‌ମାଇ ଆରି ଜଇଟାନେ ଡୁବନ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ଉଡାଲି କରି ପଟ୍‌ ବେଗ୍‌ଲାଇ ନିକଟାକେ ସଙ୍ଗଇବାକେ ତାର୍‌ ଆତେ କୁଲା ଆଚେ । ନିକଟା ତାର୍‌ କଲ୍‌କିତେଇ ସଙ୍ଗଇସି ଆରି ବେଗଲ୍‌ଲା ପଟ୍‌ ସବୁଦିନେ ଲାଗ୍‌ତେରଇବା ଜଇଟାନେ ପିଙ୍ଗିଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ସେଡ୍‌କିବେଲେ ଜିସୁ ଜଅନର୍‌ ଲଗେ ଡୁବନ୍‌ ନେବାକେ ଗାଲିଲି ଅନି ଜର୍‌ଦନ୍‌ ଗାଡେ ଆଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ମାତର୍‌ ଜଅନ୍‌ ଜିସୁକେ ମନାକରି କଇଲା, “ମୁଇ ସିନା ତମର୍‌ ଲଗେ ଡୁବନ୍‌ ନେବାର୍‍ ଆଚେ, ମାତର୍‌ ତମେ ମର୍‌ଲଗେ ଆଇଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ମାତର୍‌ ଜିସୁ ତାକେ କଇଲା, “ମର୍‌ କାତାଇ ରାଜି ଅଇ ଜା । କାଇକେବଇଲେ ଏଟାର୍‌ ଲାଗି ଆମେ ପର୍‌ମେସର୍‌ ମନ୍‍ କରିରଇବା କାମ୍‌ କରିଅଇସି ।” ସେଟାର୍‌ପାଇ ଜଅନ୍‌ ତାକେ ଡୁବନ୍‌ ଦେବାକେ ରାଜି ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଜିସୁ ଡୁବନ୍‌ ନେବାକେ ପାନି ବିତ୍‌ରେ ବୁଡି ବାରଇଲା ଦାପ୍‌ରେ ଏଦେ ଦେକା ! ସରଗ୍‌ ଉଗାଡି ଅଇ ରଇଲାଟା ଦେକ୍‌ଲା । ଆରି ପର୍‌ମେସରର୍‌ ଆତ୍‌ମା ପରୁଆ ପାରା ଅଇ ଜିସୁର୍‌ ଉପ୍‌ରେ ଉତର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ଆରି ଦେକା ଆକାସେ ଅନି ଏନ୍ତି କାତା ଆଇଲା “ଏ ମର୍‌ ଆଲାଦର୍‌ ପିଲା, ତର୍‌ଟାନେ ମୁଇ ବେସି ସାର୍‌ଦା ।” ");
INSERT INTO dso_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ତାର୍‌ପଚେ ସୁକଲ୍‌ଆତ୍‌ମା ଜିସୁକେ ମରୁବାଲି ବୁଏଁ ଡାକିନେଲା । ତେଇ ସଇତାନ୍‍ ତାକେ ପରିକା କଲା । ");
INSERT INTO dso_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ଜିସୁ ଚାଲିସ୍‌ ଦିନ୍‌ ଚାଲିସ୍‌ ରାତି ଉପାସ୍‌ ରଇକରି ବିତାଇଲା ପଚେ, ତାକେ ବେସି ବୁକ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ସେଡ୍‌କିବେଲେ ସଇତାନ୍‌ ତାର୍‌ ଲଗେ ଆସି କଇଲା “ତୁଇ ଜଦି ପର୍‌ମେସରର୍‌ ପଅ, ତେବେ ଏ ପାକ୍‌ନାମନ୍‌ ‘ରୁଟି ଅଇଜା’ ବଲି ଆଦେସ୍‌ ଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ମାତର୍‌ ଜିସୁ କଇଲା, “ସାସ୍‌ତରେ ଲେକାଆଚେ ମୁନୁସ୍‌ ଅବ୍‌କା ରୁଟି କାଇକରି ନ ବଁଚେ, ମାତର୍‌ ପର୍‌ମେସରର୍‌ ଟଣ୍ଡେ ଅନି ବାରଇବା ସବୁ ବାକିଅ ଟାନେ ବଁଚ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ତେଇଅନି ସଇତାନ୍‌ ଜିସୁକେ ସୁକଲ୍‌ ଗଡ୍‌ ଜିରୁସାଲାମ୍‌ ଡାକିନେଲା । ତେଇ ତାକେ ମନ୍ଦିର୍‌ ଟିପେ ଟିଆ କରାଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ତୁଇ ଜଦି ପର୍‌ମେସରର୍‌ ପଅ, ତେବେ ଇତିଅନି ତଲେ ଡେଗଇ ଦେସ୍‌, ସାସ୍‌ତରେ ଲେକା ଆଚେ, “ପର୍‌ମେସର୍‌ ତାର୍‌ ଦୁତ୍‌ମନ୍‌କେ ତର୍‌ ବିସଇନେଇ ଆଦେସ୍‌ ଦେଇସି, ଆରି ସେମନ୍‌ ତକେ ଆତେ ଦାରି ଟେକ୍‌ବାଇ । ତେବେ ତର୍‌ ଗଡେ ପାକ୍‌ନା ନ ପାଏ ।” ");
INSERT INTO dso_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ଜିସୁ ସଇତାନ୍‌କେ କଇଲା, “ ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଏନ୍ତି ଲେକାଆଚେ, ତୁଇ ତର୍‌ ମାପ୍‌ରୁ ପର୍‌ମେସର୍‌କେ ପରିକା କର୍‌ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ତାର୍‌ ପଚେ ସଇତାନ୍‌ ଜିସୁକେ ବେସି ଉଁଚ୍‌ ରଇବା ଗଟେକ୍‌ ଡଙ୍ଗର୍‌ ଟିପେ ଡାକି ଦାରିଗାଲା । ଆରି ଦୁନିଆର୍‌ ସବୁ ରାଇଜର୍‌ ଦନ୍‌ ସଁପତି ଦେକାଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ତୁଇ ଜଦି ମକେ ମାଣ୍ଡିକୁଟା ଦେଇ ଜୁଆର୍‌ କର୍‌ସୁ ବଇଲେ ମୁଇ ଏ ସବୁ ତକେ ଦେଇପାକାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ତେଇ ଜିସୁ ତାକେ କଇଲା “ମର୍‌ଟାନେଅନି ଦୁର୍‌ ଅ ସଇତାନ୍‌, ସାସ୍‌ତରେ ଲେକା ଆଚେ, ତୁଇ ପର୍‌ମେସର୍‌କେ ଜୁଆର୍‌ କର୍‌ସୁ, ଆରି ତାକେସେ ସେବା କର୍‌ସୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ତାର୍‌ପଚେ ସଇତାନ୍‌ ଜିସୁକେ ଚାଡି ବାରିଗାଲା, ଆରି ଏଦେ ଦେକା ! ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌ ଆସି ଜିସୁକେ ସେବା କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ତାର୍‌ପଚେ ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ବନ୍ଦି ଅଇଲାଆଚେ ବଲି ଜିସୁ ସୁନିକରି ଗାଲିିଲି ଉଟି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ତାର୍‌ ପଚେ, ସେ ନାଜରିତ୍‌ ଚାଡି କରି ସବ୍‌ଲୁନର୍‌ ଆରି ନପ୍‌ତାଲିନ୍‌ ନାଉଁର୍‌ ଜାଗା ଲଗେ ରଇବା ଗାଡ୍‌ କଣ୍ଡି ରଇଲା, କପରନାଉମେ ଜାଇ ବାସା କଲା । ");
INSERT INTO dso_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ଜେନ୍ତାର୍‌ କି ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ଏ କାତା ପୁରୁନ୍‌ ଅଇଲା । ସେ କଇରଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ଜର୍‌ଦନ୍‌ ଗାଡ୍‌ ସେପାଟେ ସମ୍‌ଦୁରେ ଜିବା ବାଟେ ରଇଲା ସବ୍‌ଲୁନ୍‌ ଆରି ନାପ୍‌ତାଲି ନାଉଁର୍‌ ଦୁଇଟା ଦେସ୍‌, ଅବିସ୍‌ବାସି ମନର୍‌ ଗାଲିଲି ! ");
INSERT INTO dso_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ଆନ୍ଦାରେ ରଇବା ଲକ୍‌ମନ୍‌ ବଡ୍‌ ଉଜଲର୍‌ ଦର୍‌ସନ୍‌ ଦେକ୍‌ବାଇ ଆରି ମରନର୍‌ ଆନ୍ଦାରେ ରଇଲା ଲକ୍‌ମନର୍‌ ଉପ୍‌ରେ ସେ ଉଜଲ୍‌ ଉଦ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ସେ ବେଲାଇ ଅନି ଜିସୁ କଇବାର୍‌ ଆରାମ୍‌ କରି ଜାନାଇବାର୍‌ ଦାର୍‌ଲା । ପାପ୍‌ କର୍‌ବାତେଇଅନି ମନ୍‌ ବଦ୍‌ଲାଆ, ସରଗ୍‌ ରାଇଜ୍‌ ଲଗେ କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ଜିସୁ ଗାଲିଲି ସମ୍‌ଦୁର୍‌ ପାଲି ରଇବା ଜାଗାମନ୍‌କେ ବୁଲ୍‌ବାବେଲେ ସିମନ୍‌ ଜାକେ କି ପିତର୍‌ ବଲି କଇବାଇ, ଆରି ତାର୍‌ ବାଇ ଆନ୍ଦ୍‌ରିୟ, ଏ ଦୁଇ ଲକ୍‌କେ ବେଟ୍‌ ଅଇଲା । ଏ ଦୁଇ ବାଇ ଗାଡେ ବଇଜାଲ୍‌ ମାରି ମାଚ୍‌ ଦାର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ଜିସୁ ସେ ଦୁଇ ବାଇକେ ଡାକି କଇଲା, “ମର୍‌ ସଙ୍ଗ୍‍ ଆସା, ମୁଇ ତମ୍‌କେ ଲକ୍‌ମନ୍‌କେ ମାପ୍‌ରୁର୍‌ବାଟେ ଆନ୍‌ବାଟା ସିକାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ସେଦାପ୍‌ରେ ସେମନ୍‌ ଜାଲ୍‌ ଚାଡି, ଜିସୁର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଜିସୁ ଆରି ତେଇଅନି କଣ୍ଡେକ୍‌ ଦୁର୍‌ ଆଗେ ଜାଇ ଜେବଦିର୍‌ ପଅ ଜାକୁବ୍ ଆରି ତାର୍‌ ବାଇ ଜଅନ୍‌କେ ବେଟ୍‌ ଅଇଲା । ସେଡ୍‌କିବେଲେ ଏ ଦୁଇବାଇ ତାକର୍‌ ବାବା ସଙ୍ଗ୍‌ ଡଙ୍ଗାଇ ଜାଲ୍‌ ସାଜାଡ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଜିସୁ ସେମନ୍‌କେ ମିସା ଡାକ୍‌ଲା ଆରି ସେମନ୍‌ ଦାପ୍‌ରେ ଡଙ୍ଗା ଆରି ତାକର୍‌ ବାବାକେ ଚାଡିକରି ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ଜିସୁ ଗାଲିଲିର୍‌ ଗୁଲାଇବାଟେ ବୁଲି ବୁଲି ଜିଉଦିମନର୍‌ ସବୁ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ସିକିଆ ଦେଇ, ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ବିସଇ ଜାନାଇଲା । ଆରି ବିନ୍‌ ବିନ୍‌ ରଗେ ରଇବା ଲକ୍‌ମନ୍‌କେ ସବୁ ରକାମର୍‌ ରଗ୍‌ ଆରି ସବୁ ଦୁକ୍‌ କସ୍‌ଟ, ନିମାନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ସିରିଆ ଦେସର୍‌ ଗୁଲାଇବାଟେ ତାର୍‌ ନାଉଁ ଜାନ୍‌ଲାଇ ଆରି ଲକ୍‌ମନ୍‌ ଡୁମା ଦାରିରଇବା, ମୁର୍‌ଚା ଅଇରଇବା, ଚେରେଙ୍ଗ୍‌ ଦାରି ରଇବା ଆରି ବିଆଦି ଦାରିରଇଲା ଲକ୍‌ମନ୍‌କେ ତାର୍‌ଲଗେ ଆନ୍‌ଲାଇ । ସେ ସବୁକେ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ଆନି ରଇବା ସବୁ ଲକ୍‌ମନ୍‌କେ ଜିସୁ ନିକ କଲା । ଗାଲିଲି ଅନି ଆରି ଦସ୍‌ଟା ସଅରେଅନି, ଆରି ଜିରୁସାଲାମ୍‌, ଜିଉଦା ଆରି ଜର୍‌ଦନ୍‌ ସେବାଟେ ରଇଲା ଜାଗାମନର୍‌ତେଇଅନି ବେସି ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଜିସୁ ଜବର୍‌ ଲକ୍‌ମନ୍‌ ତାର୍‌ଟାନେ ଆଇବାଟା ଦେକି ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ଜାଇ ବସ୍‌ଲା । ସିସ୍‌ମନ୍‌ ତାକେ ଚାରିବେଡ୍‌ତି ଗେରି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ସେବେଲେ ଜିସୁ ସେମନ୍‌କେ ସିକିଆ ଦେଇ କଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଆତ୍‌ମାଇ କାକୁର୍‌ତି ଅଇଆଚତ୍‌, ସେମନର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ସରଗ୍‌ ରାଇଜ୍‌ ତାକର୍‌ଟା ।” ");
INSERT INTO dso_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ଦୁକେ ରଇବା ଲକ୍‌ମନର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ପର୍‌ମେସର୍‌ ସେମନର୍‌ ଦୁକ୍‌ ସାରାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ସୁଆଲେ ରଇବା ଲକ୍‌ମନର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ସେମନ୍‌ ପର୍‌ମେସର୍‌ ସପତ୍‌ କରିରଇବା ବିସଇ ମିଲାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ମନ୍‍ କଲା ଇସାବେ କାମ୍‌ କର୍‌ବାକେ ଆସା କର୍‌ବାଇ, ତାକର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ପର୍‌ମେସର୍‌ ସେମନ୍‍କେ ସାର୍‌ଦା କରାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ଦୟା ଦେକାଇବା ଲକ୍‌ମନର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ସେମନ୍‌କେ ପର୍‌ମେସର୍‌ ଦୟା କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ମନ୍‌ ବିତ୍‌ରେ ନିର୍‌ମଲ୍‌ ରଇଲା ଲକ୍‌ମନର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ସେମନ୍‌କେ ପର୍‌ମେସରର୍‌ ଦର୍‌ସନ୍‌ ମିଲ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ସାନ୍ତିର୍‌ ପାଇ କାମ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ସେମନ୍‌ ପର୍‌ମେସରର୍‌ ପିଲାଟକି ବଲି ନାମାଇ ଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ମନ୍‍ କଲା ଇସାବେ କାମ୍‌ କରି ଦୁକ୍‌ କସ୍‌ଟ ପାଇବାଇ, ସେମନର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ସରଗ୍‌ ରାଇଜ୍‌ ତାକର୍‌ଟା । ");
INSERT INTO dso_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବାର୍‍ ଲାଗି ତମ୍‌କେ ଲକ୍‌ମନ୍‌ ନିନ୍ଦା ଆରି କସ୍‌ଟ ଦେବାଇ, ଆରି ଚୁଚାଇ ତମର୍‌ ବିରୁଦେ ମିଚ୍‌ କାତା କଇବାଇ, ନିଜ୍‌କେ କେଡେ କରମର୍‌ ଲକ୍‌ ବଲି ମନେ କରା । ");
INSERT INTO dso_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ସାର୍‌ଦା ଅଇ ସାର୍‌ଦାଇ ରୁଆ, କାଇକେବଇଲେ ସର୍‌ଗେ ତମର୍‌ ପାଇ ବଡ୍‌ ପୁରୁସ୍‌କାର୍‌ ସଙ୍ଗଇଲା ଆଚେ । ମନେରକା ସେନ୍ତାରି ତମର୍‌ ଆଗ୍‌ତୁ ରଇଲା ବବିସତ୍‍ବକ୍‍ତାମନ୍‍ ମିସା ଦୁକ୍‌ପାଇ ରଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ତମେ ସବୁ ମୁନୁସ୍‌ ଜାତିର୍‌ପାଇ ନୁନ୍‌ ପାରା । ମାତର୍‌ ନୁନ୍‌ ଜଦି ସୁଆଦ୍‌ ଆରାଇସି, ତେବେ ସେଟା କେନ୍ତି କରିଆ ଅଇସି ? ସେଟା ଆରି କାଇ କାମେ ନ ଆସେ, ତେବେ ତାକେ ବାଇରେ ପିଙ୍ଗି ଦେବାଇ ଆରି ସେଟା ଲକ୍‌ମନ୍‌ ମାଣ୍ଡି ପାକାଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ତମେ ଗୁଲାଇ ଜଗତର୍‌ ପାଇ ଉଜଲ୍‌ ପାରା । ଜନ୍‌ ଗଡ୍‌ ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ତିଆର୍‌ ଅଇଲାଆଚେ, ସେଟା କେବେ ମିସା ଲୁଚି ରଇ ନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","କେ ମିସା ବତି ଡସାଇକରି ଆଣ୍ଡିଡାବି ନ ସଙ୍ଗଅତ୍‌ । ସେଟା ବତିକୁଦ୍‌ରା ଉପ୍‌ରେ ସଙ୍ଗଇବାଇ ଆରି ଗରେ ରଇଲା ସବୁ ଲକ୍‌କେ ଉଜଲ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ସେନ୍ତାରିସେ ତମର୍‌ ଉଜଲ୍‌ ଲକ୍‌ମନର୍‌ଟାନେ ଉଜଲ୍‌ ଡିସ । ସେନ୍ତାର୍‌ଆଲେ ତମର୍‌ ସତ୍‌କାମ୍‌ ଦେକି ସେମନ୍‌ ସର୍‌ଗେ ରଇବା ବାବା ପର୍‌ମେସରର୍‌ ଡାକ୍‌ପୁଟା କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ମୁଇ ମିସା, କରିରଇବା ନିୟମ୍‌ କି ବାବବାଦିମନର୍‌ ଦରମ୍‌ ସାସ୍‌ତର୍‌ ବୁଡାଇବାକେ ଆସିଆଚି ବଲି ବାବା ନାଇ । ମୁଇ ସେଟା ବୁଡାଇବାକେ ଆସିନାଇ ମାତର୍‌ ସିଦ୍‌ କର୍‌ବାକେ ଆସିଆଚି । ");
INSERT INTO dso_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ମନେରକିରୁଆ, ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି ସରଗ୍‌ ଆରି ଦର୍‌ତନି ତବିର୍‌ ଅଇ ରଇବା ଜାକ ମସାର୍‌ ନିୟମର୍‌ ଗଟେକ୍‌ ଚିନ୍‌ ମିସା ନ ବୁଡେ । ସବୁ ବିସଇ ପୁରାପୁରୁନ୍‌ ନ ଅଇତେ ଏ ସବୁ ନ ଗଟେ । ");
INSERT INTO dso_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ତେବର୍‌ପାଇ ଜେ ମିସା ନିୟମ୍‌ ତେଇ ରଇବା ସବୁଟାନେଅନି ସାନ୍‌ ଆଦେସ୍‌ ନ ମାନେ ଆରି ସେନ୍ତି କର୍‌ବାକେ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ସିକାଇସି, ସେ ସରଗ୍‌ ରାଇଜେ ସବୁର୍‌ଟାନେଅନି ସାନ୍‌ ଲକ୍‌ ବଲି ଏଜାଇଅଇସି । ମାତର୍‌ ଜେ ନିୟମର୍‌ ସବୁ ବିସଇର୍‌ ସାନ୍‌ ଆଦେସ୍‌ ମାନ୍‌ସି ଆରି ସେଟା ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ସିକାଇସି, ସେ ସରଗ୍‌ ରାଇଜେ ବଡ୍‌ ଲକ୍‌ ବଲି ଏଜାଇଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","କାଇକେବଇଲେ ମୁଇ ତମ୍‌କେ କଇଲିନି, ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ଆରି ପାରୁସିମନର୍‌ତେଇଅନି ଅଦିକ୍‌ ବିସ୍‌ବାସ୍‌ ରଇ, ପର୍‌ମେସରର୍‌ ମନ୍‍ କଲା ଇସାବେ, କାମ୍‌ କଲେସେ ସରଗ୍‌ ରାଇଜେ ଜାଇପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ତମେ ସୁନି ଆଚାସ୍‌ ଜେ, ପୁର୍‌ବେଅନି ଲକ୍‌ମନ୍‌କେ କୁଆଅଇଲା ଆଚେ, ଲକ୍‌କେ ମରାଇବାର୍‌ ନାଇ । ଆରି ଜେ ମରାଇସି ବଇଲେ ସେ ବିଚାର୍‌ କରାଇଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ମାତର୍‌ ମୁଇ କଇଲିନି, ଜେ ମିସା ବାଇକେ ରିସା ଅଇସି, ତାକେ ସବାଟାନେ ବିଚାର୍‌ନା କରାଅଇସି । ଜେ ବାଇକେ ଏ ବେକାର୍‌ଟାସେ ବଲି କଇସି, ତାକେ ବଡ୍‌ ସବାଟାନେ ବିଚାର୍‌ନା କର୍‌ବାକେ ଆନ୍‌ବାଇ, । ଆରି ଜେ ବାଇକେ ଏ ବକୁଆଟାସେ ବଲି କଇସି, ତାର୍‌ପାଇ ନରକର୍‌ ଜଇଟାନେ ପିଙ୍ଗାଇଅଇବା ବିପଦ୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ସେଟାର୍‌ପାଇ ତମେ ପର୍‌ମେସର୍‌କେ ବେଦି ଟାନେ ନିଜର୍‌ ଦାନ୍‌ ଦେଲା ବେଲେ, ତେଇ ତମର୍‌ ବିରୁଦେ ତମର୍‌ ବାଇର୍‌ କାଇମିସା କାତା ଆଚେ ବଲି ମନେ ଏତାଇଲୁସ୍‍, ");
INSERT INTO dso_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ସେନ୍ତି ବଇଲେ ବେଦିଲଗେ ବଲିଦେବାଟା ସଙ୍ଗଇଦେଇ ବାରିଜା, ଆଗେ ନିଜର୍‌ ବାଇ ସଙ୍ଗ୍‌ ମିସା, ତାର୍‌ ପଚେ ଆସି ତମର୍‌ ବଲି ଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ଜଦି କେ ତମର୍‌ ବିରଦେ ତମ୍‌କେ ବିଚାର୍‌ କର୍‌ବା ଜାଗାଇ ଜିବାକେ ବାଦିଅ କର୍‌ସି ବଇଲେ, ବିଚାର୍‌ ଜାଗାଇ ଜିବା ଆଗ୍‌ତୁ, ବେଲ୍‌ ରଇତେସେ ତାର୍‌ ସଙ୍ଗ୍‌ ରାଜି ଅ । ନଇଲେ ବିଚାର୍‌ କର୍‌ବା ଜାଗାଇ କେଟିଗାଲେ, ସେ ତମ୍‌କେ ବିଚାର୍‌କରୁକେ ସର୍‌ପି ଦେଇସି ଆରି ଅଇପାରେ ବିଚାର୍‌ କରୁ ତମ୍‌କେ ବନ୍ଦି ଗରେ ନେବାକେ ଜମାନ୍‌କେ ସର୍‌ପି ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ତମର୍‌ ଉପ୍‌ରେ ଟିକ୍‌ ଅଇଲା ଜରିମନାର୍‌ ସାରାସାରି ଅଣା ମିସା ନ ଦେବା ଜାକ, ତେଇଅନି କୁଲାସ୍‌ ନ ଉଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ବେସିଆ କାମ୍‌ କରାନାଇ, ତମେ ପୁରୁବେ ଅନି ଏ ଆଦେସ୍‌ ସୁନି ଆସିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି, ଜେ ମିସା ବିନ୍‌ ମାଇଜିକେ ବେସିଆକାମ୍‌ ଇସାବେ ଆଁକି ଦେକ୍‌ସି, ସେ ତାର୍‌ ସଙ୍ଗ୍‍ ମନେ ମନେ ବେସିଆ କାମର୍‌ ଅପ୍‌ରାଦ୍‌ କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ସେଟାର୍‌ପାଇ ତମର୍‌ ଉଜାବାଟର୍‌ ଆଁକିର୍‌ ଲାଗି ତମେ ପାପ୍‌କରିଆଚାସ୍‌, ତେବେ ସେଟା ବେଟି ପିଙ୍ଗି ଦିଆସ୍‌, କାଇକେ ବଇଲେ ତମର୍‌ ସବୁ ଗାଗଡ୍‌ ନର୍‌କେ ଜିବା ବାଦୁଲେ ଗଟେକ୍‌ ଆଁକି ନସ୍‌ଟ ଅଇବାଟା ତମର୍‌ପାଇ ନିକ । ");
INSERT INTO dso_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଜଦି ତମର୍‌ ଉଜା ଆତ୍‌ ତମ୍‌କେ ପାପ୍‌ କାମ୍‌ କରାଇଲାନି ବଇଲେ, ସେଟା କାଟି ପିଙ୍ଗି ଦିଆସ୍‌, କାଇକେ ବଇଲେ ତମର୍‌ ସବୁ ଗାଗଡ୍‌ ନର୍‌କେ ଜିବା ବାଦୁଲେ ଗଟେକ୍‌ ଆତ୍‌ ନସ୍‌ଟ ଅଇବାଟା ନିକ ।” ");
INSERT INTO dso_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ଜଦି କେ ମିସା ନିଜର୍‌ ମାଇଜିକେ ଚାଡିଦେବାକେ ମନ୍‍ କଲାନି, ସେ ତାକେ ରାଜିନାମା ପତର୍‌ ଲେକି ଚାଡିଦେଅ । ଏ ସିକିଆ ତମେ ଆଗ୍‌ତୁ ପାଇଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ମାତର୍‌ ମୁଇ କଇଲିନି, ଜେକି ନିଜର୍‌ ମାଇଜିକେ ବେସିଆ କାମ୍‌ ଚାଡି ଅଲ୍‌ଗା ଦସ୍‌ ଦାରି ଚାଡ୍‌ସି, ସେ ତାକେ ପାଦ୍‌ରି କରାଇବା ଅପରାଦେ ଦସିଅଇସି, ଆରି ଜେକି ଚାଡ୍‌ଲା ମାଇଜିକେ ବିବା ଅଇସି, ସେ ପାଦ୍‌ରା ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ତମେ ପୁରୁବ୍‌ କାଲେଅନି ଏ ସିକିଆ ସୁନି ଆଇଲାସ୍‌ନି, ପର୍‌ମାନ୍‌ ବାଙ୍ଗା ନାଇ । ପର୍‌ମେସରର୍‌ ମୁଆଟେ ଜନ୍‌ ପର୍‌ମାନ୍‌ କରିଆଚାସ୍‌ ସେଟା ପୁରାପୁରୁନ୍‌ କରା । ");
INSERT INTO dso_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି ସପତ୍‌ କର୍‌ବା ବେଲେ ପର୍‌ମାନ୍‌ ନିୟମ୍‌ ପାକାଆ ନାଇ । ସରଗ୍‌ ନାଉଁ ଦାରି ରାନ୍‌ ପାକାଆ ନାଇ, କାଇକେବଇଲେ ସେଟା ପର୍‌ମେସରର୍‌ ବସ୍‍ବା ଜାଗା । ");
INSERT INTO dso_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ଦର୍‌ତନିର୍‌ ନାଉଁ ଦାରି ରାନ୍‌ ପାକାଆ ନାଇ, କାଇକେବଇଲେ, ସେଟା ପର୍‌ମେସରର୍‌ ପାଦ୍‌ ସଙ୍ଗଇବା ଜାଗା । ଜିରୁସାଲାମ୍‌ ଗଡର୍‌ ନାଉଁ ଦାରି ମିସା ରାନ୍‌ ପାକାଇବାଟା ଟିକ୍ ନାଇ, କାଇକେବଇଲେ ସେଟା ରାଜାମନର୍‌ ରାଜା ରଇବା ଜାଗା । ");
INSERT INTO dso_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ଆରି ନିଜର୍‌ ମୁଣ୍ଡ୍‌ ଚିଇ କରି ପର୍‌ମାନ୍‌ କରାନାଇ, କାଇକେବଇଲେ ତମେ, ତେଇର୍‌ ଗଟେକ୍‌ ଚେଣ୍ଡି ଦବ୍‌ଲା କି କାଲିଆ କରିନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ମାତର୍‌ ତମେ ପର୍‌ମାନ୍‌ ନିୟମ୍‌ ନ କରି, ତର୍‍ ଉଁ କାତା ଉଁ ଅ, ନାଇ କାତା ନାଇ ଅ, ଇତିଅନି ଆରି ଅଦିକ୍‌ କାତା କଇ ପର୍‌ମାନ୍‌ କର୍‌ବାଟା ସଇତାନର୍‌ଟାନେଅନି ଆଇଲାଟା ।” ");
INSERT INTO dso_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ଏ କାତା ତମେ ସୁନିଆଚାସ୍‌, ଆଁକିର୍‌ ବାଦୁଲେ ଆଁକି ଆରି ଦାଁତର୍‌ ବାଦୁଲେ ଦାଁତ୍‌, ");
INSERT INTO dso_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି, ତମର୍‌ ବିରଦେ କେ ଅନିଆଇ କାମ୍‌ କଲେ, ତାକେ ସୁଜାଇବାକେ ଚେସ୍‌ଟା କରା ନାଇ, ଜେ ତମର୍‌ ଉଜା ଗାଲେ ଚାପଡ୍‌ ମାର୍‌ସି, ତାକେ ଆରି ଗଟେକ୍‌ ଚାପ୍‌ଡା ମାର୍‌ବାକେ ଡେବ୍‌ରି ଗାଲ୍‌ ମିସା ଦେକାଇ ଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","କେ ଜଦି ତମର୍‌ସଙ୍ଗ୍‌ ବିରଦ୍‌ କରି ବିଚାର୍‌ ଲଗେ ଦାବିକରି ତମର୍‌ କାମିଜ୍‌ ନେବାକେ ମନ୍‍ କର୍‌ସି, ତାକେ ଚାଦର୍‌ ମିସା ଦେଇ ପାକାଆ । ");
INSERT INTO dso_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ସନିଅମନର୍‌ ବିତ୍‌ରେ ଅନି, କେ ମିସା ତମ୍‌କେ ତାର୍‌ ବଜ୍‌ ବୁଆଇ କରି ଗଟେକ୍‌ କିଲମିଟର୍‌ ଜୁ ଆକା ବଇଲେ, ତମେ ତାର୍‌ ସଙ୍ଗ୍‌ ଦୁଇ କିଲମିଟର୍‌ ଜା । ");
INSERT INTO dso_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","କେ ଜଦି ତମ୍‌କେ କାଇଆଲେ ଜିନିସ୍‌ ମାଙ୍ଗ୍‌ସି ବଇଲେ, ମନା ନ କରି ତାକେ ଦିଆସ୍‌ । କେ ମିସା କାଇଆଲେ ଉଦାର୍‌ ମାଙ୍ଗ୍‌ଲେ ତାକେ ଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ମଇତର୍‌କେ ଆଲାଦ୍‌ କରା ଆରି ତମର୍‌ ସତ୍‌ରୁକେ ଗିନ୍‌ କରା । ଏ ସିକିଆ ତମେ ପୁର୍‌ବେଅନି ସୁନି ଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି, ସତ୍‌ରୁମନ୍‌କେ ଆଲାଦ୍‌ କରା, ଜନ୍‌ ଲକ୍‌ ତମ୍‌କେ କସ୍‌ଟ ଦେଲାଇନି, ତାକର୍‌ପାଇ ପାର୍‌ତନା କରା । ");
INSERT INTO dso_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଏଟା କଲେ ସରଗର୍‌ ପର୍‌ମେସରର୍‌ ପିଲା ବଲି ଚିନାପଡ୍‌ସା । କାଇକେ ବଇଲେ ପର୍‌ମେସର ବଲ୍‌ କାରାପ୍‌ ଦୁଇ ଲକର୍‌ ପାଇ ମିସା ବେଲର୍‍ ଉଜଲ୍‍ ଦେଲାନି, ଆରି ଦରମ୍‌ ରଇବା, ଦରମ୍‌ ନ ରଇବା ସବୁର୍‌ ଉପ୍‌ରେ ବର୍‌ସା ମାରାଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ତେବେ, ତମ୍‌କେ ଆଲାଦ୍‌ କର୍‌ବା ଲକ୍‌କେ ଆଲାଦ୍‌ କଲେ, ପର୍‌ମେସର୍‌ ତମ୍‌କେ କାଇକେ ପୁରୁସ୍‌କାର୍‌ ଦେଇସି ? ସିସ୍‌ତୁ ମାଙ୍ଗ୍‌ବା ଲକ୍‌ମନ୍‌ ମିସା ସେନ୍ତି କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ତମେ ଜଦି ନିଜର୍‌ ନିଜର୍‌ ବାଇମନ୍‌କେସେ ଜୁଆର୍‌ କର୍‌ସା, ତେବେ ଆରି ଅଦିକ୍‌ କାଇଟା କଲାସ୍‌ନି ? ବିସ୍‌ବାସ୍‍ ନକଲା ଲକ୍‌ମନ୍‌ ମିସା ସେଟା କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ସେଟାର୍‌ ପାଇ ତମର୍‌ ସରଗର୍‌ ବାବା ଜେନ୍ତାର୍‌ ସିଦ୍‌, ତମେ ମିସା ସେନ୍ତାର୍‌ ସିଦ୍‌ ଅଇବା ଦର୍‌କାର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ଲକ୍‌ମନ୍‌କେ ଦେକାଇଅଇବାକେ ସବୁର୍‌ ମୁଆଟେ ନିକ କାମ୍‌ କରାନାଇ । ସେଟା କଲେ ସର୍‌ଗେ ରଇବା ତମର୍‌ ବାବାର୍‌ ଟାନେଅନି ପୁରୁସ୍‌କାର୍‌ ନ ପାଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ତେବେ ଗଟେକ୍‌ ଗରିବ୍‌ ଲକ୍‌କେ ଦାନ୍‌ ଦେବା ବେଲେ କୁଟିଆଲ୍‌ମନର୍‌ ପାରା ଦେକାଇ ନ ଉଆ । ସେମନ୍‌ ଲକ୍‌ମନର୍‌ତେଇ ଅନି ଡାକ୍‌ପୁଟା ପାଇବାକେ ପାର୍‌ତନା ଗରେ ଆରି ସାଇ ମଜାଇ ଦାନ୍‌ଦରମ୍‌ ଦେକାଇବାଇ । ମୁଇ ସତ୍‌ କଇଲିନି ଜେ, ସେମନ୍‌ ଇତିଅନି ସେମନର୍‌ ବୁତି ପୁରାପୁରୁନ୍‌ ପାଇସାରି ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ମାତର୍‌ ତମେ ଅବାବେ ରଇଲା ଲକ୍‌କେ ସାଇଜ କଲାବେଲେ, ଏନ୍ତାରି କରା, ଜେନ୍ତିକି ତମର୍‌ ଲଗର୍‍ ମଇତର୍‌ ମିସା ଏ କାତା ନାଜାନ । ");
INSERT INTO dso_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ତମର୍‌ ଏ ଦାନ୍‌ ଲୁଚ୍‌ତେ ଅଇରଇଲେ ମିସା ସବୁ ଦେକ୍‌ବା ବାବା ପର୍‌ମେସର୍‌ ସେଟା ଦେକି ତମ୍‌କେ ପୁରୁସ୍‌କାର୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ପାର୍‌ତନା କର୍‌ବା ବେଲେ କୁଟିଆଲ୍‌ ବିସ୍‌ବାସିମନର୍‌ ପାରା ଉଆନାଇ । କାଇକେ ବଇଲେ ସେମନ୍‌ ଲକ୍‌ମନ୍‌କେ ଦେକାଇ ଅଇବାକେ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ଆରି ଗାଉଁର୍‌ ମଜା ଡାଣ୍ଡେ ଟିଆ ଅଇକରି ପାର୍‌ତନା କର୍‌ବାକେ ମନ୍‌ କର୍‌ବାଇ । ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ପୁରୁସ୍‌କାର୍‌ ପାଇଲାଇବେ । ");
INSERT INTO dso_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ମାତର୍‌ ତମେ ପାର୍‌ତନା କର୍‌ବାକେ ତମର୍‌ ବାକ୍‌ରାଇ ଜାଇ, କାକେ ନ ଦେକାଇଅଇତେ ପୁରିକରି କାପାଟ୍‌ ଡାବିଅଇଦିଆସ୍‌ ଆରି ନ ଡିସାଇ ଅଇବା ତମର୍‌ ସର୍‌ଗର୍‌ ବାବାର୍‌ ଲଗେ ପାର୍‌ତନା କରା । ତମେ ଲୁଚ୍‌ତେ ଜାଇଟା କର୍‌ସା, ସେଟା ଦେକି ତମର୍‌ ବାବା ତମ୍‌କେ ପୁରୁସ୍‌କାର୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ପାର୍‌ତନା କର୍‌ବା ବେଲେ ପର୍‌ମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ ନ କର୍‌ବା ଲକ୍‌ମନର୍‌ ପାରା ଅରତ୍‌ ନଇଲା କାତା ତର୍‌କେ ତର୍‌ କଇ ଆଉଲି ନ ଉଆ, ବେସି ପର୍‌ ପାର୍‌ତନା କଲେ ସେ ପର୍‌ମେସର୍‌ ସୁନ୍‌ସି ବଲି, ସେମନ୍‌ ମନେ ବାବ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ସେମନର୍‌ ପାରା ଉଆ ନାଇ । ତମେ ମାଙ୍ଗ୍‌ବା ଆଗ୍‌ତୁ ଜାଇଟା ଦର୍‌କାର୍‌, ତମର୍‌ ସରଗର୍‌ ବାବା ପର୍‌ମେସର୍‌ ସେଟା ସବୁ ଜାନ୍‍ସି । ");
INSERT INTO dso_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ସେଟାର୍‌ ପାଇ ତମେ ଏନ୍ତାରି ପାର୍‌ତନା କର୍‌ବାର୍‌ ଆଚେ । ଏ ଆମର୍‌ ସରଗର୍‌ ବାବା, ତମର୍‌ ସୁକଲ୍‌ ନାଉଁ ଡାକ୍‍ପୁଟା ପାଅ । ");
INSERT INTO dso_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ତମର୍‌ ସାସନ୍‌ ଆସ । ସର୍‌ଗେ ତମର୍‌ ମନ୍‍ କଲାଟା ଜେନ୍ତାରି ସିଦ୍‌ ଅଇଲାନି, ଏ ରାଇଜେ ମିସା ସେନ୍ତାରି ତମେ ମନ୍‍ କଲାଟା ସିଦ୍‌ ଅ । ");
INSERT INTO dso_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ଆଜି ଆମ୍‌କେ ଦର୍‌କାର୍‌ ରଇଲା କାଦି କାଇବାକେ ଦିଆ । ");
INSERT INTO dso_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ଆମର୍‌ ବିରଦେ ଦସ୍‌ କରିରଇବା ଲକ୍‌ମନ୍‌କେ ଆମେ ଜେନ୍ତାର୍‌ କେମା କଲୁନି, ସେନ୍ତାରି ଆମର୍‌ ସବୁ ଦସ୍‌ କେମା କରା । ");
INSERT INTO dso_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ବେସି କସ୍‌ଟ ରଇବା ପରିକା ଆମ୍‍କେ ମୁରଚ୍‍ବାକେ ଦିଆ ନାଇ, ମାତର୍‌ କାରାପ୍‌ କାମେଅନି ରକିଆ କରା ଜେନ୍ତିକି ତମର୍‌ ରାଇଜ୍‌, ତମର୍‌ ବପୁ, ଆରି ଡାକ୍‌ପୁଟା ସବୁ ଜୁଗେଜୁଗେ ତମର୍‌ ଅଇକରି ରଅ । ଆମେନ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ତମର୍‌ ବିରଦେ ଦସ୍‌ କରିରଇବା ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ଜଦି ତମେ କେମା କର୍‌ସା, ତମର୍‌ ସରଗର୍‌ ବାବା ପର୍‌ମେସର୍‌ ମିସା ତମ୍‌କେ କେମା କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ମାତର୍‌ ତମେ ଜଦି ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ କେମା ନ କରାସ୍‌, ସରଗର୍‌ ବାବା ମିସା ତମେ କରିରଇବା ପାପ୍‌ଦସ୍‌ କେମା ନ କରେ ।” ");
INSERT INTO dso_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ଉପାସ୍‌ କର୍‌ବା ବେଲେ ଦରମ୍‌ ବଲି ଦେକାଇଅଇଲା ଲକର୍‌ ପାରା ବାଇରେ ସପାସୁତର୍‌ ଅଇବାଟା ଚାଡିଦେବାର୍‌ ନାଇ । ସେମନ୍‌ ଉପାସ୍‌ କଲୁନି ବଲି ଲକର୍‌ ଲଗେ ଦେକାଇ ଅଇବାକେ ସେନ୍ତାରି କର୍‌ବାଇ । ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ସେମନ୍‌ ଏନ୍ତି କର୍‌ବାର୍‌ ଲାଗି ନିଜର୍‌ ପୁରୁସ୍‌କାର୍‌ ସବୁ ପାଇଲାଇବେ । ");
INSERT INTO dso_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ମାତର୍‌ ତମେ ଉପାସ୍‌ କର୍‌ବା ବେଲେ, ମୁଣ୍ଡେ ଚିକନ୍‌ଲାଗାଇ ଅଇ ସପା ସୁତ୍‌ରା ରୁଆ । ");
INSERT INTO dso_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ଜେନ୍ତିକି ଉପାସ୍‌ କଲାସ୍‌ନି ବଲି ବିନ୍‌ ଲକ୍‌ମନ୍‌ ନାଜାନତ୍‌ । ମାତର୍‌ ତମର୍‌ ନ ଡିସ୍‌ବା ବାବା ସବୁ କାତା ଜାନେ । ତମେ ଲୁଚ୍‌ତେ ଜାଇଟା କର୍‌ସା, ସେଟା ଦେକି ତମ୍‌କେ ପୁରୁସ୍‌କାର୍‌ ଦେଇସି ।” । ");
INSERT INTO dso_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ଏ ଦୁନିଆଇ ନିଜର୍‌ପାଇ ଦନ୍‌ ଅର୍‌ଜା ନାଇ । ଇତି ସଙ୍ଗଇଲା ଦନ୍‌ ଅଲ୍‌ମା କାଇ ଚିଲମ୍‌ ଦାର୍‌ସି ଆରି ଚର୍‌ମନ୍‌ କତି କାଣା କରି ଚରାଇନେବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ସର୍‌ଗେ ତମର୍‌ ପାଇ ଏନ୍ତାରି ଦନ୍‌ ଅର୍‌ଜି ସଙ୍ଗୁଆ । ତେଇ ଅଲ୍‌ମା ଆରି ଚିଲମ୍‌ ନ ଦାରେ । ଆରି ଚର୍‌ମନ୍‌ ମିସା କତି କାଣାକରି ଚରାଇ ନେଇ ନାପାରତ୍‌ । ଜାଗ୍‌ରତ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","କାଇକେବଇଲେ ଜନ୍‌ଟାନେ ତମର୍‌ ଦନ୍‌, ତେଇସେ ତମର୍‌ ମନ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ତମର୍‌ ଆଁକି ଅଇଲାନି ଗାଗଡର୍‌ ବତି । ଜେଡେବେଲା ଆଁକି ନିର୍‌ମଲ୍‌ ରଇସି, ତେବେ ତମର୍‌ ଗୁଲାଇ ଗାଗଡ୍‌ ମିସା ଉଜଲ୍‌ ବର୍‌ତି ଅଇରଇସି । ");
INSERT INTO dso_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ମାତର୍‌ ଜେବେ ତମର୍‌ ଆଁକି ନସିରଇସି, ତେବେ ସବୁ ଗାଗଡ୍‌ ଆନ୍ଦାର୍‌ ଅଇସି । ତେବର୍‌ପାଇ ତମର୍‌ ମନ୍‌ ବିତ୍‌ରର୍‌ ଉଜଲ୍‌ ଜେବେ ଆନ୍ଦାର୍‌ ଅଇସି, ତେବେ ସେ ଆନ୍ଦାର୍‌ କେଡେକ୍‌ ବଡ୍‌ ବିପଦ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“କେ ମିସା ଗଟେକ୍‌ ଲକ୍‌ ଦୁଇଟା ସାଉକାରର୍‌ ସେବାକରି ନାପାରେ । ସେ ଗଟେକ୍‌ ଲକ୍‌କେ ମାନ୍‌ସି ଆରି ଗଟେକ୍‍ ଲକ୍‌କେ ଗିନ୍‌ କର୍‌ସି । ନଇଲେ ଗଟେକ୍‌ ଲକ୍‌କେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି ଆରି ଗଟେକ୍‍ ଲକ୍‌କେ ବିସ୍‌ବାସ୍‌ ନ କରେ । ତମେ ଏକାତର୍‌ ପର୍‌ମେସର୍‌କେ ଆରି ଡାବୁକାସୁକେ ସେବାକରି ନାପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ଏଟାର୍‌ପାଇ ମୁଇ ତମ୍‌କେ କଇଲିନି, ବଁଚ୍‌ବାକେ କାଇଟା କାଇବୁବେ ? ଆରି ଗାଗଡର୍‌ ପାଇ କାଇଟା ପିନ୍ଦ୍‌ବୁ ? ବଲି ବାବି ଚିନ୍ତା କରାନାଇ । କାଦିର୍‌ତେଇଅନି ଜିବନ୍‌, ଆରି ବସ୍‌ତର୍‌ ତେଇଅନି ଗାଗଡ୍‌ ମୁକିଅ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ଚଡଇମନ୍‌କେ ଦେକା, ସେମନ୍‌ ନ ବୁନତ୍‌ କି ନ କାଟତ୍‌, କି କଲ୍‌କିତେଇ ନ ସଙ୍ଗଅତ୍‌, ଅଇଲେ ମିସା ସରଗର୍‌ ବାବା ସେମନ୍‌କେ କାଇବାପାଇ ଜାଗାଇଲାନି । ତମେ କାଇ ସେମନର୍‌ତେଇଅନି ମୁକିଅ ନୁଆସ୍‌ କି ? ");
INSERT INTO dso_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ବଁଚ୍‌ବା ପାଇ ବଲି ନିଜେ ଚିନ୍ତାକରି ବିକଲ୍‌ ଅଇ ଜେ ତାର୍‌ କଣ୍ଡେକ୍‌ ମିସା ବଁଚ୍‍ବା ଦିନ୍‍ ପାର୍‌ସି କି ? ନାଇ ନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ବସ୍‌ତର୍‌ ପାଇ କାଇକେ ବିକଲ୍‌ ଅଇଲାସ୍‌ନି ? ଦେକା, ବନର୍‌ ପୁଲ୍‌ମନ୍‌ କେନ୍ତି ବଡ୍‌ଲାଇନି, ସେମନ୍‌ କାମ୍‌ଦାମ୍‌ କରତ୍‌ ନାଇ କି ନିଜର୍‌ ପାଇ ବସ୍‌ତର୍‌ ତିଆର୍‌ କରତ୍‌ ନାଇ, ");
INSERT INTO dso_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି, ରାଜା ସଲ୍‌ମନ୍‌ ତାର୍‌ ସବୁ ଦନ୍‌ ସଁପତି ସଙ୍ଗ୍‍ ମିସା ଏ ପୁଲ୍‌ ପାରା ସୁନ୍ଦର୍‌ ବସ୍‌ତର୍‌ କେବେ ପିନ୍ଦି ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ଆଜି ପଦାଇ ରଇଲା ଗାଁସ୍‌ କାଲିକେ ନ ମିସା ରଏ । କାଟିକରି ଜଇଟାନେ ପଡାଇଦେବାଇ । ଏଲେମିସା ତାକେ ପର୍‌ମେସର୍‌ ଏନ୍ତି ସୁନ୍ଦର୍‌ ବେସ୍‌ ଦେଇସି, ତେବେ ଏ ଅଲପ୍‌ ବିସ୍‌ବାସିମନ୍‌, ସେ ବାଇଦରେ ତମ୍‌କେ ଅଦିକ୍‌ ନିମାନ୍‌ ବସ୍‌ତର୍‌ ନ ଦେଏ କି ? ଦେଇସିସେ । ");
INSERT INTO dso_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ଏଟାର୍‌ ପାଇ କାଇଟା କାଇବି ? ଆରି କାଇଟା ପିଇବି ? ଆରି କାଇଟା ଅଡ୍‌ବି ବଲି ଚିନ୍ତା କରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","କାଇକେବଇଲେ ପର୍‌ମେସର୍‌କେ ନାଜାନ୍‌ଲା ଲକ୍‌ମନ୍‌ ଏ ସବୁ କଜିବୁଲ୍‌ବାଇ । ଆରି ଏ ସବୁ ବିସଇ ଜେ ତମ୍‌କେ ଲଡା, ସେଟା ତମର୍‌ ସରଗର୍‌ ବାବା ଜାନେ । ");
INSERT INTO dso_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ମାତର୍‌ ତମେ ତାର୍‌ ରାଇଜ୍‌ ଆରି ସେ ତମର୍‌ଟାନେଅନି କାଇଟା ମନ୍‍ କଲାନି, ସେ ବିସଇ କଜା । ସେନ୍ତାର୍‌ କଲେ, ସେ ତମ୍‌କେ ଲଡାକେ ଆଇବା ସବୁ ବିସଇ ଜାଗାଇ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ଆରି, କାଲିକର୍‌ ପାଇ ଚିନ୍ତା କରାନାଇ, କାଇକେବଇଲେ କାଲିିକର୍‌ ଚିନ୍ତା କାଲିକେ କରା । ଜନ୍‌ ଦିନର୍‌ କସ୍‌ଟ, ସେଦିନର୍‌ପାଇ ଅଦିକ୍‌ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ବିନ୍‌ ଲକର୍‌ ଦସ୍‌ କଜି ବୁଲାନାଇ । ତାକର୍‌ ବିଚାରର୍‌ ଦସ୍‌ ନ ଦାର୍‌ଲେ, ପର୍‌ମେସର୍‌ ତମର୍‌ ଦସ୍‌ ନ ଦାରେ । ");
INSERT INTO dso_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","କାଇକେବଇଲେ ତମେ ବିନ୍‌ ଲକର୍‌ ଦସ୍‌ ଜେନ୍ତି ବିଚାର୍‌ କର୍‌ତେରଇସା, ସେନ୍ତାରିସେ ପର୍‌ମେସର୍‌ ତମର୍‌ ବିଚାର୍‌ କର୍‌ସି । ତମେ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ଜନ୍‌ ନିୟମ୍‌ କର୍‌ସା, ପର୍‌ମେସର୍‌ ତମ୍‌କେ ସେ ନିୟମ୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ତମର୍‌ ଆଁକିତେଇ ବଡ୍‌ କାଚ୍‌ରା ରଇଲେ ମିସା, କାଇକେ ତମର୍‌ ବାଇର୍‌ ଆଁକିଟାନେ ରଇବା କାଚ୍‌ରା, ନିକସଙ୍ଗ୍‍ ଦେକ୍‌ଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ନିଜର୍‌ ଆଁକିତେଇ ବଡ୍‌ କାଚ୍‌ରା ରଉରଉ ତମେ କାଇ ସାଆସେ ତମର୍‌ ବାଇର୍‌ ଆଁକିତେଇ ରଇବା କାଚ୍‌ରା ବାର୍‌କରାଇ ଦେବି ବଲି କଇଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ଏରେ କୁଟିଆଲ୍‌ମନ୍‌ ! ଆଗେ ନିଜର୍‌ ଆଁକିତେଇ ରଇଲା କାଚ୍‌ରା ବାର୍‌କରାଇ ପାକା, ତାର୍‌ ପଚେ ନିଜର୍‌ ବାଇର୍‌ ଆଁକିତେଇ ରଇବା କାଚ୍‌ରା ବାର୍‌କରାଇବାକେ ନିମାନ୍‌ କରି ଦେକି ପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ସୁକଲ୍‌ ଦିନ୍‌ସୁ କୁକୁର୍‌ମନ୍‌କେ ଦିଆସ୍‌ ନାଇ, ସେମନ୍‌ ପାସ୍‌ଲିକରି ତମ୍‌କେ ଚାବିପାକାଇବାଇ । ଗୁସ୍‌ରି ମନର୍‌ ମୁଆଟେ ମୁକ୍‌ତା ପାକାଆ ନାଇ, ସେମନ୍‌ ମୁକ୍‌ତାର୍‌ ମୁଲିଅ ନ ବୁଜିକରି ମାଣ୍ଡିପାକାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ମାଙ୍ଗା, ତେବେ ତମ୍‌କେ ଦିଆଅଇସି । କଜା, ତେବେ ମିଲାଇସା, କାପାଟେ ମାରା କାପାଟ୍‌ ଉଗାଡି ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ଜେ ମାଙ୍ଗ୍‌ସି, ତାକେ ଦିଆଅଇସି, ଜେ କଜ୍‍ସି, ସେ ମିଲାଇସି, ଜେ କାପାଟେ ମାର୍‌ସି ତାର୍‌ପାଇ କାପାଟ୍‌ ଉଗାଡି ଦିଆଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ତମର୍‌ ବିତ୍‌ରେ ଏନ୍ତାରି ବାବା କେ ଆଚେ କି ? ତମର୍‌ ପିଲା ଜଦି ରୁଟି ମାଙ୍ଗ୍‌ଲେ, ତାକେ ପାକ୍‌ନା ଦେଇସା ? ");
INSERT INTO dso_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ନଇଲେ ସେ ମାଚ୍‌ ମାଙ୍ଗ୍‌ଲେ ତାକେ ସାଁପ୍‌ ଦେଇସା ? ");
INSERT INTO dso_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ତମେ କାରାପ୍‌ ଲକ୍‌ ଅଇରଇଲେ ମିସା ନିଜର୍‌ ପିଲାମନ୍‌କେ ନିକନିକ ଜିନିସ୍‌ ଦେଇସା । ସେନ୍ତାରିସେ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ସରଗର୍‌ ବାବାକେ ମାଙ୍ଗ୍‌ବାଇ ସେ ସେମନ୍‌କେ ଆରି କେତେ ନିକନିକ ଜିନିସ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“ତମର୍‌ ପାଇ ବିନ୍‌ ଲକ୍‌ମନ୍‌ ଜାଇଟା କରତ୍‌ ବଲି ମନ୍‍ କଲାସ୍‌ନି, ସେନ୍ତାରି ତମେ ବିନ୍‌ ଲକର୍‌ ପାଇ କରା । ଏଟା ଅଇଲାନି ମସା ଦେଇରଇବା ନିୟମ୍‌ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ସିକିଆର୍‌ ଅରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ଚିପଙ୍ଗା ଦୁଆର୍‌ ବାଟେ ଜାଆ । କାଇକେବଇଲେ ବିନାସ୍‌ କର୍‌ବାକେ ନେବା ନର୍‌କେ ଜିବା ବାଟ୍‌ ଅସାର୍‌ ଆରି ସୁବିଦାର୍‍ଟା । କେତେ କେତେ ଲକ୍‌ ସେ ବାଟେ ଜିବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ମାତର୍‌ ନ ସାର୍‌ବା ଜିବନେ ମିସି ରଇଲା ବାଟ୍‌, ଚିପଙ୍ଗା ଆରି ଜିବାଟା ବେସି କସ୍‌ଟ । ଉନା ଲକ୍‌ ସେ ବାଟ୍‌ କଜି କଜି ମିଲାଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ଟକାବଣ୍ଡା କର୍‌ବା ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ତେଇଅନି ଜାଗର୍‌ତା ଅଇରୁଆ, ସେମନ୍‌ ବାଇରେ ମେଣ୍ଡା ପାରା ଡିସ୍‌ବାଇ ମାତର୍‌ ତାକର୍‌ ମନ୍‌ ବିତ୍‌ରେ ବାଲିଆଡୁର୍‌କାମନର୍‌ ପାରା । ");
INSERT INTO dso_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ସେମନର୍‌ କର୍‌ବା କାମ୍‌ ଦେକି ତମେ ସେମନ୍‌କେ ଚିନିପାରାସ୍‌ । କାଟା ବୁଟାଇ ଅଙ୍ଗୁର୍‌ ନ ପଲେ କି କାଟାକଲି ବୁଟାଇ ଡୁମ୍‌ରି ପଲ୍‌ ନ ଦାରେ । ");
INSERT INTO dso_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ନିକ ଗଚେ ନିକ ପଲ୍‌ ଦାର୍‌ସି, ବାନିଆ ଗଚର୍‌ ପଲ୍‌ ବାନିଆ ସେ । ");
INSERT INTO dso_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ନିକ ଗଚେ ବାନିଆ ପଲ୍‌ ନ ପଲେ କି ବାନିଆ ଗଚେ ନିକ ପଲ୍‌ ଅଇନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ନିକ ପଲ୍‌ ନ ଦାର୍‌ଲେ ସେ ଗଚ୍‌ କାଟି କରି ଜଇଟାନେ ପାକାଇଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ସେନ୍ତାରି ସେ ଟକାବଣ୍ଡା କର୍‌ବା ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ କାମ୍‌ କର୍‌ବାଟାନେ ଅନି ତମେ ସେମନ୍‌କେ ଚିନିପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ମକେ ମାପ୍‌ରୁ, ମାପ୍‌ରୁ ବଲି ଡାକ୍‌ବା ଲକ୍‌ମନର୍‌ତେଇ ଅନି ସବୁ ଲକ୍‌ ସରଗ୍‌ ରାଇଜେ କେଟିନାପାରତ୍‌ । ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ସରଗର୍‌ ବାବା ମନ୍ କଲା ଇସାବେ ଚଲାଚଲ୍‍ତି କର୍‌ବାଇ, ସେମନ୍‍ସେ ସରଗ୍‌ ରାଇଜେ କେଟ୍‍ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ମାପ୍‌ରୁର୍‌ ବିଚାର୍‌ କର୍‌ବା ଦିନ୍‌ କେଟ୍‌ଲେ କେତେ କେତେ ଲକ୍‌ ମକେ କଇବାଇ, ଏ ମାପ୍‌ରୁ, ତମର୍‌ ନାଉଁ ଦାରି ଆମେ ପର୍‌ମେସରର୍‌ ସୁବ୍‌କବର୍‌ ଜାନାଇ ଆଚୁ । ତମର୍‌ ନାଉଁ ଦାରି ଡୁମାମନ୍‌କେ କେଦି ଆଚୁ ଆରି କେତେକ୍‌ କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କରିଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ସେଡ୍‌କି ବେଲେ ମୁଇ ସେମନ୍‌କେ କଇବି, ନାଇ, ମୁଇ ତମ୍‌କେ ନାଜାନି । କରାପ୍‍କାମ୍‍ କର୍‍ବା ଲକ୍‍ମନ୍‍, ମର୍‌ଲଗେ ରୁଆନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ଜେ ମର୍‌ କାତା ସୁନି, ସେ ଇସାବେ ଚାଲ୍‌ସି, ସେ ବଡ୍‌ ରାଙ୍ଗ୍‌ନି ପାକ୍‌ନା ଉପ୍‌ରେ ଗର୍‌ କର୍‌ବା ଗିଆନ୍‌ଲକର୍‌ ପାରା । ");
INSERT INTO dso_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ଅପର୍‌ବଲ୍‌ ବର୍‌ସା ମାର୍‌ଲାକେ ଗାଡ୍‌ ଉଚ୍‌ଲି ଗାଲା ଆରି ସେ ଗର୍‌ ଉପ୍‌ରେ ବେସି ପବନ୍‌ ଦାର୍‌ଲା । ମାତର୍‌ ସେ ଗର୍‌ ବସ୍‌ଲେ ନାଇ । କାଇକେ ବଇଲେ ସେଟା ପାକ୍‌ନା ଉପ୍‌ରେ ତିଆର୍‌ ଅଇରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ମର୍‌ କାତା ସୁନିକରି ମିସା ସେ ଇସାବେ ଚଲାଚଲ୍‌ତି ନ କରତ୍‌, ସେମନ୍‌ ବାଲି ଗାଦି ଉପ୍‌ରେ ଗର୍‌ ତିଆର୍‌ କରି ରଇବା ବକୁଆ ଲକ୍‍ ପାରା । ");
INSERT INTO dso_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ଅପର୍‌ବଲ୍‌ ବର୍‌ସା ଅଇଲାକେ ଗାଡ୍‌ ପୁରି ଉଚଲ୍‌ଲା, ଜବର୍‌ ବାଉଦୁକା ଆଇଲା ଆରି ଗର୍‌ କୁରୁପ୍‌ନାସ୍‌ ଅଇଗାଲା । ସେ କୁରୁପ୍‌ନାସ୍‌ ଅଇଲାଟା କେଡେ ଇନସ୍‌ତା ରଇଲା ! ” ");
INSERT INTO dso_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ସାରାସାରି ଜାକ ଜିସୁ ସିକିଆ ଦେବାଟାନେ ଏ ସବୁ କାତା ସୁନିକରି ଲକ୍‌ମନ୍‌ କାବା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ସେ ବିନ୍‌ବିନ୍‌ ସାସ୍‌ତର୍‌ ସିକାଉମନର୍‌ ପାରା ନ ସିକାଇକରି ନିଜର୍‌ ଅଦିକାର୍‌ ସଙ୍ଗ୍‍ ସିକାଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଜିସୁ ଡଙ୍ଗ୍‌ରେ ଅନି ଉତ୍‌ରି ଆଇଲା ଦାପ୍‌ରେ, ବେସି ଲକ୍‌ମନ୍‌ ତାର୍‌ ପଚେ ପଚେ ଇଣ୍ଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ସେବେଲେ ଗଟେକ୍‌ ବଡ୍‌ ରଗି ଜିସୁର୍‌ ମୁଆଟେ ଆସି ମାଣ୍ଡିକୁଟା ଦେଇ କଇଲା, “ଏ ମାପ୍‌ରୁ, ତମେ ଜଦି ମନ୍‍ କଲାସ୍‌ନି ବଇଲେ ମକେ ସୁକଲ୍‌ କରି ପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ତେଇ ଜିସୁ ଆତ୍‌ ଲାମାଇ ତାକେ ଚିଇ କଇଲା, “ମୁଇ ମନ୍‍ କଲିନି, ସୁକଲ୍‌ ଅ ।” ଜିସୁ ଏତ୍‌କି କଇଲା ଦାପ୍‌ରେ ସେ ଲକ୍‌ ବଡ୍‌ ରଗେଅନି ନିକ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଜିସୁ ତାକେ କଇଲା, “ସୁନ୍‌, ତୁଇ କେନ୍ତିଅଇ ନିକ ଅଇଲୁସ୍‌, ଏ କାତା କାକେ ମିସା କ ନାଇ, ମାତର୍‌ ସିଦା ପୁଜାରିର୍‌ ଲଗେ ଜାଇକରି ନିଜ୍‌କେ ଦେକାଇ ଅ, ଆରି ତୁଇ ନିକ ଅଇ ଆଚୁସ୍‌ ବଲି ସବୁ ଲକର୍‌ ଟାନେ ଜାନାଇଅଇବାକେ ମସାର୍‌ ନିୟମ୍‌ ଇସାବେ ପର୍‌ମେସର୍‌କେ ସର୍‌ପିଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ଜିସୁ କପର୍‌ନାଉମ୍‌ ସଅରେ କେଟ୍‌ଲା । ସେଦାପ୍‌ରେ ଗଟେକ୍‌ ରମିୟ ସନିଅମନର୍‌ ମୁକିଅ ତାକେ ବେଟ୍‌ ଅଇକରି ବାବୁଜିଆ କରି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ଏ ମାପ୍‌ରୁ, ମର୍‌ ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ଅଚ୍‌ନାଇ ଡୁଲିକରି ବେସି କସ୍‌ଟ ପାଇଲାନି ଉଟେ ନାଇ, ବସେ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ଆସି ତାକେ ନିକ କର୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ମାତର୍‌ ମୁକିଅ କଇଲା, “ନାଇ ମାପ୍‌ରୁ ତମେ ଜେ ମର୍‌ଗରେ ପାଦ୍‌ ପାକାଇସା, ଏଟାର୍‌ପାଇ ମର୍‍ ଅଦିକାର୍‍ ନଇ । ତମେ ପଦେକ୍‌ କଇଦିଆ, ମର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ନିକ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","କାଇକେବଇଲେ ମୁଇ ମର୍‌ ଉପ୍‌ରର୍‌ ଅଦିକାରିର୍‌ ତଲେ କାମ୍‌ କଲିନି, ଅଇଲେ ମିସା ମର୍‌ ତଲେ କେତେ କେତେ ସନିଅମନ୍‌ ଆଚତ୍‌ । ସେମନର୍‌ ବିତ୍‌ରେଅନି ଜଦି ମୁଇ ଗଟେକ୍‌ ଲକ୍‌କେ ଜାଆ ବଲି ଆଦେସ୍‌ ଦେଲେ, ସେ ଜାଇସି । ବିନ୍‌ଟାକେ ଆଉ ବଲି କଇଲେ ସେ ଆଇସି । ସେନ୍ତିସେ ମର୍‌ ଗତି ଦାଙ୍ଗ୍‌ଡାକେ ଏଟା କର୍‌ ବଲି କଇଲା ଦାପ୍‌ରେ ସେ ସେଟା କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ଜିସୁ ଏଟା ସୁନି କାବା ଅଇଗାଲା, ଆରି ତାର୍‌ ସଙ୍ଗ୍‍ ଆଇବା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ମୁଇ ସତ୍‌ କଇଲିନି, ଇସ୍‌ରାଏଲ୍‌ ବିତ୍‌ରେ କନ୍‌ ଲକର୍‌ଟାନେ ମିସା ଏ ଲକର୍‌ ପାରା ବିସ୍‌ବାସ୍‌ ମୁଇ ଦେକିନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ଏ କାତା ତମର୍‌ ମନେ ର, ପୁରୁବ୍‌ ଆରି ପସ୍‌ଚିମ୍‌ ବାଟର୍‌ ଦେସେଅନି କେତେ କେତେ ଲକ୍‌ ସରଗ୍‌ ରାଇଜେ ଆସି ଅବ୍‌ରାଆମ୍ ଇସାକ୍‌ ଆରି ଜାକୁବର୍‌ ସଙ୍ଗ୍‌ ବଜିତେଇ ଗଟେକ୍‌ଟାନେ କାଇବାକେ ବସ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ସରଗ୍‌ ରାଇଜେ ପୁର୍‍ବାର୍‍ ରଇଲାଇ, ସେମନ୍‌କେ ବାଇରର୍‌ ଆନ୍ଦାରେ ପିଙ୍ଗା ଅଇସି । ତେଇ ସେମନ୍‌ ଦାଁତ୍‌ ମୁଣ୍ଡ୍‌ କାତ୍‌ରି ମାରିଚପିଅଇ କାନ୍ଦ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଜିସୁ ସନିଅମନର୍‌ ମୁକିଅକେ କଇଲା, “ତୁଇ ଏବେ ଗରେ ଜା । ତୁଇ ଜେନ୍ତି ବିସ୍‌ବାସ୍‌ କଲୁସ୍‌ନି ସେନ୍ତାରିସେ ଅଇସି ।” ସମାନ୍‌ ସେ ବେଲାଇସେ ତାର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ପୁରାପୁରୁନ୍‌ ନିକ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ଜିସୁ ପିତରର୍‌ ଗରେ ଜାଇ ତାର୍‌ ସାତ୍‌ରି ଜର୍‌ଅଇକରି ଅଚ୍‌ନାଇ ଡୁଲି ରଇବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ସେ ପିତରର୍‌ ସାତ୍‌ରିର୍‌ ଆତେ ଚିଇଲା ଦାପ୍‌ରେ ତାର୍‌ ଜର୍‌ ଚାଡିଗାଲା । ଆରି ସେ ଉଟିକରି ଜିସୁର୍‌ ସେବା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ସଞ୍ଜ୍‌ ଅଇଲାକେ ଲକ୍‌ମନ୍‌, କେତେକ୍‌ କେତେକ୍‌ ଡୁମା ଦାରିରଇଲା ଲକ୍‌ମନ୍‌କେ ଜିସୁର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ତାର୍‌ ପଦେକ୍‌ କାତା କଇଲା ଦାପ୍‍ରେସେ ଡୁମା ଆତ୍‌ମାମନ୍‌କେ ବାର୍‌କରାଇଦେଲା ଆରି ରଗି ଲକ୍‌ମନ୍‌କେ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ଏଟା କଲାର୍‌ ଲାଗି ଜିସୁ ଜିସାଇୟ ବବିସତ୍‌ବକ୍‌ତା ଜାନାଇ ରଇଲାଟା ପୁରାପୁରୁନ୍‌ ସିଦ୍‌କଲା । ବବିସତ୍‌ବକ୍‌ତା କଇରଇଲା “ଆମର୍‌ ଦୁକାସୁକା ସବୁ ନିଜେ ନେଲା ଆରି ଆମର୍‌ ଜର୍‌ଦୁକା ବଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ଜିସୁ ତାର୍‌ ଚାରିବେଟ୍‌ତି ରଇଲା ବେସି ଲକ୍‌ମନ୍‌କେ ଦେକିକରି ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଗାଡ୍‌ ସେପାଟ୍‌ ଜିବାକେ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ତେଇ ଗଟେକ୍‌ ଜିଉଦିମନର୍‌ ସାସ୍‌ତର୍‌ ସିକାଉ ତାର୍‌ ଲଗେ ଆସି କଇଲା, “ଏ ଗୁରୁ ତମେ ଜନ୍‌ ଜାଗାଇ ଗାଲେ ମିସା ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‍ ଆଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ମାତର୍‌ ଜିସୁ ତାକେ କଇଲା, “କଲିଆ ରଇବାକେ ପାଆର୍‌ ଆଚେ, ଆରି ଉଡିବୁଲ୍‌ବା ଚଡଇମନ୍‌ ରଇବାକେ ଗୁଡା ଆଚେ, ମାତର୍‌ ନର୍‌ପିଲା ମୁଇ, ମକେ ରଇବାକେ ଜାଗା ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଆରି ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ସିସ୍‌ କଇଲା, “ଏ ମାପ୍‌ରୁ, ମକେ ପର୍‌ତୁମ୍‌ ମର୍‌ ବାବାକେ ଜାଇ ତପି ଆଇବାକେ ମେଲାନି ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ମାତର୍‌ ଜିସୁ ତାକେ କଇଲା, “ମରିଗାଲା ଲକ୍‌ମନ୍‌ ମଲା ଲକ୍‌ମନ୍‌କେ ତପତ୍‌, ତୁଇ ମର୍‌ ପଚେ ପଚେ ଆଉ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ତାର୍‌ ପଚେ ଜିସୁ ଗଟେକ୍‌ ଡଙ୍ଗାଇ ଚଗ୍‌ଲାକେ ତାର୍‌ ସିସ୍‌ମନ୍‌ ମିସା ତାର୍‌ ସଙ୍ଗ୍‍ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ସେ ବେଲା ଅଟାତ୍‌ ସମ୍‌ଦୁରେ ଏନ୍ତି ବାଉପବନ୍‌ ଆଇଲା ଆରି ଉଲ୍‌କାର୍‌ ଲାଗି ଡଙ୍ଗା ପାନିତେଇ ବୁଡିଜିବା ପାରା ଅଇଲା । ମାତର୍‌ ଜିସୁ ଡଙ୍ଗାଇ ସଇଦେଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ଆରି ସିସ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଜାଇକରି ତାକେ ଉଟାଇ କଇଲାଇ, “ଏ ମାପ୍‌ରୁ ଆମ୍‌କେ ରକିଆ କର୍‌ । ନଇଲେ ଆମେ ବୁଡି ମରିଜିବୁବେ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏ ବିସ୍‌ବାସେ ଡାଟ୍‌ ନ ରଇଲା ଲକ୍‌ମନ୍‌, ତମେ କାଇକେ ଏତେକ୍‌ ଡରିଗାଲାସ୍‌ନି ?” ଜିସୁ ବାଉପବନ୍‌କେ ଆରି ଲଅଡିକେ ଦମ୍‌କାଇଲା । ତେବର୍‌ପାଇ ବାଉପବନ୍‌ ଆରି ଲଅଡି ତବିର୍‌ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ଏଟା ଦେକି ସିସ୍‌ମନ୍‌ ବେସି କାବାଅଇଜାଇ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ଏ କେନ୍ତାର୍‌ ଲକ୍‌ ଜେ ବାଉପବନ୍‌ ଆରି ଲଅଡି ମିସା ଆର୍‌ କାତା ମାନ୍‌ଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଗାଡ୍‌ ସେପାଟର୍‌ ଗଦ୍‌ରିୟ ନାଉଁର୍‌ ଜାଗାଇ କେଟ୍‌ଲା ଦାପ୍‌ରେ, ଦୁଇଟା ଡୁମା ଡସ୍‌ଲା ଲକ୍‌ ତାକେ ବେଟ୍‌ ଅଇଲାଇ । ସେମନ୍‌ ମସନ୍‌ ବିତ୍‌ରେ ରଇତେରଇଲାଇ । ଆରି ସେମନ୍‌ ଏନ୍ତି ରଇଲାଇ ଜେ, ସେ ବାଟେ କେ ମିସା ଆସ୍‌ ଜା ନ ଅଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ସେ ଲକ୍‌ମନ୍‌ ବେସି କିର୍‌କିରି କରି କଇଲାଇ, “ଏ ପର୍‌ମେସରର୍‌ ପିଲା ଆମର୍‌ ଟାନେ ତର୍‌ କାଇ କାମ୍‌ ଆଚେ ? ବେଲ୍‌ କାଲ୍‌ ନ କେଟ୍‌ତେ ତୁଇ କାଇ ଡଣ୍ଡ୍‌ ଦେବାକେ ଇତି ଆଇଲୁସ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ସେବେଲାଇ ସେ ଜାଗାଇଅନି କଣ୍ଡେକ୍‌ ଦୁରିକେ ଗଟେକ୍‌ ବଡ୍‌ ଗୁସ୍‌ରି ମାନ୍ଦା ଚାରାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","କାରାପ୍‌ ଆତ୍‌ମାମନ୍‌ ଜିସୁକେ ଗୁଆରି କରି କଇଲାଇ, “ତୁଇ ଜଦି ଆମ୍‌କେ ଏ ଲକ୍‌ମନର୍‌ତେଇ ଅନି ବାର୍‌କରାଇ ଦେଇସୁ ବଇଲେ ସେ ଗୁସ୍‌ରି ମାନ୍ଦା ବିତ୍‌ରେ ଜିବାକେ, ଆଦେସ୍‌ ଦେ ।” ");
INSERT INTO dso_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ଜିସୁ ସେମନ୍‌କେ ଜା ! ବଲି କଇଲାକେ କାରାପ୍‌ ଆତ୍‌ମାମନ୍‌ ସେ ଲକ୍‌ମନର୍‌ତେଇଅନି ବାରଇକରି ଗୁସ୍‌ରିମନର୍‌ ବିତ୍‌ରେ ପୁର୍‌ଲାଇ । ତେବର୍‌ ପାଇ, ଗୁସ୍‌ରିମନ୍‌ ଟିପେଅନି ଗସ୍‌ରି ସମ୍‌ଦୁରେ ବୁଡି ମଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ଆରି ତେଇ ଗୁସ୍‌ରି ଚାରାଇତେ ରଇବା ଲକ୍‌ମନ୍‌ ପାଲାଇ କରି ଡୁମା ଡସି ରଇଲା ଲକ୍‌ମନ୍‌କେ କାଇକାଇଟା ଅଇଲା ସେଟା ସବୁ କଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ଆରି ସେ ଗଡର୍‌ ସବୁ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଦେକ୍‌ବାକେ ଆଇଲାଇ । ସେମନ୍‌ ତାକେ ଦେକିକରି ସେ ଜାଗା ଚାଡି ଜା ବଲି ଗୁଆରି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ଜିସୁ ଡଙ୍ଗାଇ ବସି ଗାଡ୍‌ ସେପାଟେ ରଇଲା ନିଜର୍‌ ଗଡେ ବାଉଡି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ଆରି ତେଇ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ଚେରେଙ୍ଗ୍‌ ରଗିକେ ବଇକରି ତାର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ଚେରେଙ୍ଗ୍‌ ରଗି ଅଚ୍‌ନାଇ ସଇରଇଲା । ସେ ଲକ୍‌ମନର୍‌ ବିସ୍‌ବାସ୍‌ ଦେକି ରଗିକେ କଇଲା, “ସାଆସ୍‌ ଦାର୍‌, ତର୍‌ ସବୁ ପାପ୍‌ କେମା ଅଇଗାଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ଏ କାତା ସୁନି କେତେଟା ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କାତା ଅଇଲାଇ, “ଏ ଲକ୍‌ କାଇକେ ପର୍‌ମେସରର୍‌ ନିନ୍ଦା କଲାନି ?” ");
INSERT INTO dso_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ଜିସୁ ତାକର୍‌ ମନର୍‌ ଚିନ୍ତା ଜାନି କଇଲା, “ତମେ ନିଜର୍‌ ନିଜର୍‌ ମନେ କାଇକେ କାରାପ୍‌ ଚିନ୍ତା କଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'ତମର୍‌ ପାପ୍‌ସବୁ କେମା ଅଇଗାଲା ବଲି କଇବାଟା ସଅଜ୍‌ କି 'ଉଟିକରି, ଇଣ୍ଡିଜା ବଲି କଇବାଟା ଅଦିକ୍‌ ସଅଜ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ମାତର୍‌ ଜଗତର୍‌ ପାପ୍‌ କେମା କର୍‌ବାକେ ନର୍‌ପିଲା, ମର୍‌ ଅଦିକାର୍‌ ଆଚେ, ମୁଇ ଏଟା ତମର୍‌ ମୁଆଟେ ଦେକାଇବି ।” ତାର୍‌ ପଚେ ଜିସୁ ଚେରେଙ୍ଗ୍‌ ରଗିକେ କଇଲା, “ଉଟ୍‌, ନିଜର୍‌ ଟାଟି ଦାରି ଗରେ ଉଟିଜା ।” ");
INSERT INTO dso_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ଆରି ସେ ଲକ୍‌ ଉଟିକରି ଗରେ ବାରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ଲକ୍‌ମନ୍‌ ସେଟା ଦେକି କାବା ଅଇଜାଇ ଡରିଗାଲାଇ । ମାତର୍‌ ନର୍‌ ଲକ୍‌କେ ଏନ୍ତାରି ଅଦିକାର୍‌ ଦେଲାର୍‌ ପାଇ ପର୍‌ମେସର୍‌କେ ଡାକ୍‌ପୁଟା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଜିସୁ ତେଇଅନି ଉଟି ଜିବାବେଲେ ମାତିଉ ନାଉଁର୍‌ ଗଟେକ୍‌ ସିସ୍‌ତୁ ମାଙ୍ଗୁକେ, ତାର୍‌ ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ମାଙ୍ଗ୍‌ବା ଜାଗାଇ ବସିରଇଲାଟା ଦେକି କଇଲା, “ମର୍‌ ସଙ୍ଗ୍‍ ଆଉ ।” ମାତିଉ ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ମାଙ୍ଗ୍‌ବା ଜାଗାଇଅନି ଉଟି ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ଜିସୁ ମାତିଉର୍‍ ଗରେ କାଇବାବେଲେ ବେସି ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌, ଆରି ପାପି ଲକ୍‌ମନ୍‌ ତେଇ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ର୍‌ ସଙ୍ଗ୍‌ ବସି କାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ଏଟା ଦେକି ପାରୁସି ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲାଇ, “କାଇକେ ତମର୍‌ ଗୁୁରୁ ସିସ୍‌ତୁମାଙ୍ଗୁମନର୍‌ ସଙ୍ଗ୍‌ ଆରି ପାପି ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ବସି କାଇଲାନି ?” ");
INSERT INTO dso_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ଜିସୁ କଇଲା, “ନିକ ରଇଲା ଲକର୍‌ ପାଇ ଡାକ୍‌ଦର୍‌ ଲଡା ନାଇ । ମାତର୍‌ ଜର୍‌ଦୁକାର୍‌ ଲକ୍‌ମନର୍‌ ପାଇ ଡାକ୍‌ଦର୍‌ ଲଡା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ସାସ୍‌ତରେ ଲେକାଅଇଆଚେ, 'ମୁଇ ପସୁ ପୁଜ୍‌ବା ବିରୁଟାନେଅନି, ଲକ୍‍ମନ୍‍କେ ଦୟା ଦେକାଇବାଟା ମନ୍‍ କଲିନି। ଏ କାତାର୍‌ ଅରତ୍‌ କାଇଟା ? ଜାଇକରି ବୁଜ୍‌ବାକେ ଚେସ୍‌ଟା କରା । ମୁଇ ଦରମ୍‌ ଲକ୍‌ମନ୍‌କେ ଡାକ୍‌ବାକେ ଆସି ନାଇ, ପାପିମନ୍‌କେ ଡାକ୍‌ବାର୍‌ ଆସିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ତାର୍‌ ପଚେ ଦିନେକ୍‌ ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ପାଚାର୍‌ଲାଇ, “ଆମେ ଆରି ପାରୁସିମନ୍‌ ବେସି ତର୍‌ ଲାକା ଉପାସ୍‌ କଲୁନି, ମାତର୍‌ ତମର୍‌ ସିସ୍‌ମନ୍‌ କାଇଜେ ଉପାସ୍‌ କରତ୍‌ ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ବିବା ଦାଙ୍ଗ୍‌ଡା ଜେଡେବେଲେ ଜାକ ଦାଙ୍ଗ୍‌ଡାମନର୍‌ ସଙ୍ଗ୍‌ ବିବାଗରେ ରଇସି, ସେ ଦିନ୍‌ ଜାକ ସଙ୍ଗର୍‍ ଦାଙ୍ଗ୍‌ଡାମନ୍‌ ଦୁକ୍‌ ନ କରତ୍‌ । ମାତର୍‌ ଜେଡେବଲ୍‌ ବିବା ଅଇବା ଦାଙ୍ଗ୍‌ଡାକେ ସଙ୍ଗର୍‍ଦାଙ୍ଗ୍‌ଡାମନର୍‌ଟାନେଅନି ଦାରିଜିବାଇ, ସେମନ୍‌ ଦୁକ୍‌ କରି ଉପାସ୍‌ କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","କେ ମିସା ପୁର୍‌ନା ଲୁଗା କାଣା ଅଇଲାଟାନେ, ନୁଆ ଲୁଗାର୍‌ ଗର୍‌ଣ୍ଡା ନ ସିଲାଅତ୍‌, କାଇକେ ବଇଲେ ନୁଆ ଗର୍‌ଣ୍ଡା ପୁର୍‌ନା ଲୁଗାକେ ବେସି ଚିରି ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ଆରି, କେ ମିସା ନୁଆ ଅଙ୍ଗୁର୍‌ ରସ୍‍, ଚାମ୍‌ ସଙ୍ଗ୍‌ ତିଆର୍‌ ଅଇଲା ପୁର୍‌ନା ମୁନାଇ ବେସି ଦିନ୍‌ ନ ସଙ୍ଗଅତ୍‌, ସଙ୍ଗଇଲେ ମୁନା ପାଟିଜାଇସି ଆରି ରସ୍‌ ଚିଡ୍‌ତେ ଡାଲି ଅଇଜାଇସି । ସେଟାର୍‌ ପାଇ ନୁଆ ରସ୍‍ ନୁଆ ମୁନାଇ ସଙ୍ଗଇବାଇ । ଏନ୍ତି ସଙ୍ଗଇଲେ ମୁନା ଆରି ରସ୍‌ ଦୁଇଟା ଜାକ ନସ୍‍ଟ ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଜିସୁ ସେମନ୍‌କେ ଏ ସବୁ କାତା କଇଲା ବେଲେ, ଦେକା ଗଟେକ୍‌ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରର୍‌ ନେତା ଜିସୁର୍‌ ଲଗେ ଆସି ମାଣ୍ଡିକୁଟା ଦେଇ କଇଲା, “ମର୍‌ ଟକି ଏବେସେ ମରିଗାଲା ଆଚେ, ମାତର୍‌ ତୁଇ ଆସି ତାର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇଲେ ସେ ବଁଚ୍‍ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ଜିସୁ ଦାପ୍‌ରେ ଉଟିକରି ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ତେଇ ଗଟେକ୍‌ ମାଇଜି ଜିସୁର୍‌ ପଚ୍‌ବାଟେ ଆଇଲା । ତାକେ ବାର ବରସ୍‌ ଜାକ ବନି ଜାଇତେ ରଇବା ରଗ୍‌ ଅଇରଇଲା । ସେ ମାଇଜି ପଚେ ଜାଇ ଜିସୁର୍‌ ଲୁଗା ଚିଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ସେ ମନେ ମନେ ବାବ୍‌ଲା ମୁଇ ତାର୍‌ ପିନ୍ଦ୍‌ଲାଟା ଚିଇଲେ ନିମାନ୍‌ ଅଇଜିବି । ");
INSERT INTO dso_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ମାତର୍‌ ଜିସୁ ପାସ୍‌ଲି କରି ତାକେ ଦେକି କଇଲା, “ଏ ନୁନି, ଡର୍‌ନାଇ ସାଆସ୍‌ ଦାର୍‌, ତର୍‌ ବିସ୍‌ବାସ୍‌ ତକେ ନିମାନ୍‌ କରିଆଚେ ।” ଏତ୍‌କି କଇଲା ଦାପ୍‌ରେ ସେ ମାଇଜି ନିମାନ୍‌ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ତାର୍‌ ପଚେ ଜିସୁ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରର୍‌ ମୁକିଆର୍‍ ଗରେ କେଟ୍‌ଲା । ତେଇ ଦନ୍‌କର୍‌ବାକେ ଆସି ରଇଲା ଲକ୍‌ମନ୍‌, ଆରି ବାଜ୍‌ନିଆମନ୍‌ କାନ୍ଦାବୁବା ଅଇବାଟା ଦେକି, ");
INSERT INTO dso_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ଜିସୁ କଇଲା, “ସବୁ ଲକ୍‌ ଇତିଅନି ବାରଇଜା । ଏ ଟକିତା ମରେନାଇ, ସଇଆଚେ ।” ତାର୍‌ କାତା ସୁନି ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ ତାକେ କିଜାଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ମାତର୍‌ ଲକ୍‌ମନ୍‌କେ ବାର୍‌କଲା ପଚେ ଜିସୁ ବାକ୍‌ରାଇ ଜାଇ ଟକିର୍‌ ଆତେ ଦାରି ତାକେ ଉଟାଇଲା । ଟକି ଦାପ୍‌ରେ ଉଟିକରି ଟିଆଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଏ ଗଟ୍‍ନାର୍‌ କବର୍‌ ସେ ଜାଗାର୍‌ ଗୁଲାଇ ବାଟର୍‌ ଲକ୍‌ ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ଜିସୁ ସେ ଜାଗାଇଅନି ବାରଇ ଜିବାବେଲେ ଦୁଇଟା କାଣା, ତାର୍‍ ପଚେ ପଚେ ଇଣ୍ଡି ଆଇଲାଇ । ସେମନ୍‌ ଆଉଲି ଅଇକରି କଇବାର୍‌ ଦାର୍‌ଲାଇ । “ଏ ଦାଉଦ୍‌ ରାଜାର୍‌ ପଅ ! ଆମ୍‌କେ ଦୟା କରା ।” ");
INSERT INTO dso_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ଜିସୁ ଗଟେକ୍‌ ଗରେ ଗାଲା ଆରି କାଣାମନ୍‌ ମିସା ତାର୍‌ ପଚ୍‌ ପଚ୍‌ ପୁର୍‌ଲାଇ । ପୁର୍‌ଲାକେ ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ମୁଇ ତମର୍‌ ଆଁକି ନିକ କରି ପାର୍‌ବି ବଲି ତମେ ବିସ୍‌ବାସ୍‌ କଲାସ୍‌ନି କି ?” ସେମନ୍‌ କଇଲାଇ “ଉଁ ମାପ୍‌ରୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ତାର୍‌ ପଚେ ଜିସୁ ସେମନର୍‌ ଆଁକି ଚିଇକରି କଇଲା, “ମକେ ବିସ୍‌ବାସ୍‌ କଲାର୍‌ ଲାଗି ତମର୍‌ ଆଁକି ଡିସ ।” ");
INSERT INTO dso_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ଜିସୁ କଇଲା ଦାପ୍‌ରେ କାଣାମନ୍‌ ଆଁକି ଦେକିପାର୍‌ଲାଇ । ଆରି ଜିସୁ, ସେମନ୍‌କେ ଡାଟ୍‌କରି, “ଏ ବିସଇ କାକେ ମିସା କୁଆ ନାଇ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ମାତର୍‌ ସେମନ୍‌ ବାରଇ ଜାଇ ଜିସୁର୍‌ ଏ କରିରଇବାଟା ଗୁଲାଇ ଦେସେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ସେ ଗରେଅନି ବାରଇ ଗାଲାବେଲେ କେତେଟା ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ଗୁଲା ଲକ୍‌କେ ତାର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ତାକେ ଡୁମାଦାରିରଇଲାକେ ସେ ଗୁଲା ଅଇଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଜିସୁ ଡୁମାକେ ସେ ଲକର୍‌ତେଇଅନି କେଦ୍‌ଲା ପଚେ ସେ କାତାଅଇବାର୍‌ ଦାର୍‌ଲା । ଆରି ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ କାବାଅଇଜାଇ କଇଲାଇ । “ଇସ୍‌ରାଏଲ୍‌ ଦେସେ ଏନ୍ତାରି ଗଟ୍‍ନା ଆମେ କେବେ ଦେକି ନ ରଇଲୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ମାତର୍‌ ପାରୁସିମନ୍‌ କଇଲାଇ, “ସେ ଡୁମାମନର୍‌ ନେତାର୍‌ ବପୁ ସଙ୍ଗ୍‌ ବିନ୍‌ ଡୁମାମନ୍‌କେ କେଦ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ଜିସୁ ଗାଉଁ ଗାଉଁ ବୁଲି ବୁଲି ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ଜାଇ ସିକାଇ ଦେଇତେ ରଇଲା । ଆରି ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ନିମାନ୍‌ କାତା କଇତେରଇଲା । ବିନ୍‌ ବିନ୍‌ ଜର୍‌ ଆରି ରଗ୍‌ ଦାର୍‌ଲା ଲକ୍‌ମନ୍‌କେ ସବୁ ନିକ କରିଦେଲା ଆରି ପାର୍‌ତନା ଗରେ ସିକିଆ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ଆରି ତେଇ ରଇଲା ଜବର୍‌ ଲକ୍‌ମନ୍‌କେ ଦେକିକରି ସେ ଦୟା କଲା । କାଇକେ ବଇଲେ ସେମନ୍‍ ବେସି ତାକିଜାଇରଇଲା ଆରି ସାଇଜ ପାଇବାକେ କନ୍‌ ବାଟେ ଜିବାର୍‌ ଆଚେ, ଜାନିନାପାର୍‌ତେ ରଇଲାଇ । ସେମନ୍‌ ଗଉଡ୍‌ ନଇଲା ମେଣ୍ଡାରାସି ପାରା ଅଇଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ସେଡ୍‌କିବେଲେ ସେ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ତାସ୍‌ ସିନା ବୁତେକ୍‌ । ମାତର୍‌ ସେଟା କାଟ୍‌ବାକେ, ଲକ୍‌ମନ୍‌ ଉନା ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ତେବର୍‌ପାଇ ‘କେତ୍‌ ରଇଲା ପଦାଇ କାଟ୍‌ବାକେ ବେସି ଲକ୍‌କେ ପାଟାଆ’ ବଲି ତାସ୍‌ କଲା ସାଉକାର୍‌କେ ପାର୍‌ତନା କରା ।” ");
INSERT INTO dso_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଜିସୁ ତାର୍‌ ବାର୍‌ଟା ପେରିତ୍‌ମନ୍‌କେ ଲଗେ ଡାକି ଡୁମା କେଦ୍‌ବାକେ, ସବୁ ରକାମର୍‌ ରଗ୍‌ ଆରି ଜର୍‌ଦୁକା ନିମାନ୍‌ କର୍‌ବାକେ ଅଦିକାର୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ସେ ବାର୍‌ଟା ପେରିତ୍‌ମନର୍‌ ନାଉଁ ଅଇଲାନି, ସିମନ୍‌ ଜାକେକି ପିତର୍‌ ବଲି ଡାକ୍‌ବାଇ, ଆରି ତାର୍‌ ବାଇ ଆନ୍ଦ୍‌ରିୟ, ଜେବଦିର୍‌ ପଅ ଜାକୁବ୍‌ ଆରି ତାର୍‌ ବାଇ ଜଅନ୍‌, ");
INSERT INTO dso_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ପିଲିପ୍‌ ଆରି ବାର୍‌ତଲମି, ତମା ଆରି ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ମାତିିଉ, ଆଲ୍‌ପିର୍‌ ପଅ ଜାକୁବ୍‌ ଆରି ତଦିୟ, ");
INSERT INTO dso_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","କିଣାନିୟ ସିମନ୍‌ ଜେ କି ଇସ୍‌ରାଏଲ୍‌ ଲକ୍‌ମନର୍‌ ମୁକ୍‌ତିର୍‌ ପାଇ ଚେସ୍‌ଟା କର୍‌ତେରଇଲା । ଆରି ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା, ଜେ ଜିସୁକେ ସତ୍‌ରୁମନ୍‍କେ ସର୍‌ପିଦେଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଜିସୁ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ପାଟାଇଲାବେଲେ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ କାଇଟା ନାଇ ବଲି ଆଦେସ୍‌ ଦେଇ କଇଲା, “ତମେ ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ କନ୍‌ ଜାଗାଇ ମିସା ଜାଆନାଇ କି ସମିରଣିୟ ଗଡେ ମିସା ପୁରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ମାତର୍‍ ଆଜିଗାଲା ମେଣ୍ଡାମନର୍‌ ପାରା ରଇବା ଇସ୍‌ରାଏଲ୍‌ମନର୍‌ ଲଗେ ଜା । ");
INSERT INTO dso_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ସେମନର୍‌ ଲଗେ ଜାଇ ଜାନାଇକରି କୁଆ, ସରଗ୍‌ ରାଇଜ୍ ଲଗେ ଆଇଲା ଆଚେ ! ");
INSERT INTO dso_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ଜରର୍‌ ଲକ୍‌ମନ୍‌କେ ନିମାନ୍‌ କରା, ମଲା ଲକ୍‌ମନ୍‌କେ ଉଟାଆ, ବଡ୍‌ ରଗିମନ୍‌କେ ନିମାନ୍‌ କରା, ଡୁମାମନ୍‌କେ କେଦିଦିଆସ୍‌ । ଏ ସବୁ ସରଗର୍‌ ମାପ୍‌ରୁର୍‌ ତେଇଅନି ତିନ୍‌ପଲିଆରେ ମିଲାଇ ଆଚାସ୍‌ । ସେନ୍ତି ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ କାଇଟା ନ ମାଙ୍ଗ୍‌ତେ ଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ଡାବୁ ମିସା ନିଆନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ଆରି ବୁଲ୍‌ବା ବେଲେ ମୁନା ଦାରି ବୁଲାନାଇ । ଗଟେକ୍‌ ଉଚ୍‌କା ପିନ୍ଦ୍‌ବା ପଚିଆ, ପାଣ୍ଡଇ, ଡାଙ୍ଗ୍‌ ନିଆ ନାଇ । ପାଇଟି କରୁ ତାର୍‌ ବୁତି ପାଇସିସେ ।” ");
INSERT INTO dso_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ଗଟେକ୍‌ ଗଡେ କି ଗାଏଁ କେଟ୍‌ସା ବଇଲେ, ତେଇ କେ ତମ୍‌କେ ନିଜର୍‌ ଗରେ ଡାକ୍‌ସି, ସେ ଲକ୍‌କେ କଜା, ଆରି ବିନେ ଜିବା ଜାକ ତାକର୍‌ ଗରେସେ ରୁଆ । ");
INSERT INTO dso_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ଗରେ କେଟ୍‌ଲା ବେଲେ ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌କେ ଜୁଆର୍‌ କରି କୁଆ, ‘ତମ୍‌କେ ସାନ୍ତି ମିଲ’ । ");
INSERT INTO dso_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ସେମନ୍‌ ଜଦି ତମ୍‌କେ ଗତିଆ କରି ଡାକ୍‌ବାଇ, ତମେ କଇଲା ସାନ୍ତିର୍‌ କାତା ପୁରୁନ୍‌ ଅଇସି । ମାତର୍‌ ସେମନ୍‌ ଜଦି ତମ୍‌କେ ଗତିଆ କରି ନ ଡାକତ୍‌ ବଇଲେ, ତମେ କଇଲାଟା ତମର୍‌ ଲଗେ ବାଉଡି ଆଇସି । ");
INSERT INTO dso_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଜଦି କେ ମିସା ତମ୍‌କେ ନ ଡାକତ୍‌ କି ତମେ କଇଲା କାତା ନ ସୁନତ୍‌ ବଇଲେ, ‘ଏ ଜାଗା ଚାଡ୍‌ଲୁ’ ବଲି ଗଟେକ୍‌ ଚିନ୍‌ ପାରା ଦେକାଇବାକେ, ପାଦର୍‌ ଦୁଲି ପାପ୍‌ଡି, ସେ ଜାଗା ଚାଡି ଉଟିଜା । ");
INSERT INTO dso_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ବିଚାର୍‌ନା ଦିନେ ସଦମ୍‌ ଗମରାକେ ପର୍‌ମେସର୍‌ ଅଦିକ୍‌ ଦୟା ଦେକାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ସୁନା, ବାଲିଆଡୁର୍‌କାମନର୍‌ ବିତ୍‌ରେ ମେଣ୍ଡାମନ୍‌କେ ପାଟାଇଲା ପାରା ମୁଇ ତମ୍‌କେ ପାଟାଇଲିିିନି । ସାଁପର୍‌ ପାରା ଚାଲାକି ଅଇ ପରୁଆପାରା ସୁଆଲ୍‌ ଉଆ । ");
INSERT INTO dso_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ମାତର୍‌ ଜାଗ୍‌ରତ୍‌ ଅଇରୁଆ, କାଇକେ ବଇଲେ ଲକ୍‌ମନ୍‌ ସେମନର୍‌ ବିଚାର୍‌ କର୍‌ବା ଜାଗାମନର୍‌ତେଇ ତମ୍‍କେ ସର୍‌ପିଦେବାଇ ଆରି ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ତମ୍‌କେ କର୍‌ଡା ମାର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ଆରି ତମେ ମର୍‌ ସିସ୍‌ ଅଇଲାର୍‌ ଲାଗି, ରାଜା ଆରି ସାସନ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ ଲଗେ ନିଆଅଇ ବିଚାର୍‌ କରାଇଅଇସା । ଇତିଅନି ସେମନ୍‌କେ ଆରି ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ ତେଇ ମର୍‌ ବିସଇନେଇ କଇବାକେ ତମେ ବେଲା ପାଇସା । ");
INSERT INTO dso_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ତମର୍‌ ବିଚାର୍‌ନା ଅଇବାବେଲେ ‘କାଇଟା କଇବି, କେନ୍ତି କଇବି’ ବଲି ଚିନ୍ତା କରି ତେରେପେତେ ନ ଉଆ । ଟିକ୍ ସେବେଲାଇ ସେଟା ତମ୍‌କେ ଜାନାଇ ଦିଆଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","କାଇକେ ବଇଲେ ତମେ ନିଜେ କାଇଟା କଇବାକେ ନ ପଡେ । ବାବା ପର୍‌ମେସର୍‌ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ତମର୍‌ ଟଣ୍ଡେଅନି କାତା କଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ଲକ୍‌ମନ୍‌ ନିଜର୍‌ ବାଇକେ ମରନର୍‌ ଡଣ୍ଡ୍‌ ବଗ୍‌ବାକେ ଦାରାଇଦେବାଇ । ବାବା ମିସା ନିଜର୍‌ ପିଲାମନ୍‌କେ ସେନ୍ତାରି କର୍‌ସି । ପିଲା ଟକିମନ୍‌ ବାବାମାଆର୍‌ ବିରଦେ ଉଟି ସେମନ୍‌କେ ମରାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ମକେ ବିସ୍‌ବାସ୍‌ କଲାର୍‌ ଲାଗି ତମ୍‌କେ ସବୁ ଲକ୍‌ ଗିନ୍‌ କର୍‌ବାଇ । ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ ସାରାସାରି ଜାକ ସାଆସ୍‌ ଦାରି ରଇସି, ସେ ମୁକ୍‌ତି ପାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ଗଟେକ୍‌ ନଅରେ ଦୁକ୍‌ କସ୍‌ଟ ଦେଲେ, ତମେ ଆରି ଗଟେକ୍‌ ନଅରେ ଉଟି ପାଲାଆ । ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ତମେ ଇସ୍‌ରାଏଲ୍‌ ଦେସେ ରଇବା ସବୁ ଗଡେ ବୁଲି ନ ସାର୍‌ତେ, ନର୍‌ପିଲା ମୁଇ ଆରି ତରେକ୍‌ ବାଉଡି ଆସିରଇବି । ");
INSERT INTO dso_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“କନ୍‌ ସିସ୍‌ ମିସା ଗୁରୁର୍‌ ତେଇଅନି ବଡ୍‌ ନଏଁ । ଗତିଦାଙ୍ଗ୍‌ଡା ସାଉକାରର୍‌ତେଇଅନି ବଡ୍‌ ନଏଁ । ");
INSERT INTO dso_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ସିସ୍‌ ତାର୍‌ ଗୁରୁର୍‌ ପାରା ଆରି ଗତିଦାଙ୍ଗ୍‌ଡା ନିଜର୍‌ ସାଉକାର୍‌ ପାରା ଅଇଲେ ସେମନ୍‌ ସାର୍‌ଦା ଅଇବାର୍‌ ଆଚେ । ଗଟେକ୍‌ ଗରର୍‌ ମୁକିଆ ମକେ, ବାଲ୍‍ଜିବୁଲ୍‌ ବଲି ଡାକ୍‌ଲାଇନି ବଇଲେ, ଗରର୍‌ ଆରି ଅଦେକ୍‌ ଲକ୍‌ମନ୍‌କେ ବାଇଦରେ ଅଦିକ୍‌ କାରାପ୍‌ ନାଉଁ ଦାରି ଡାକ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ସେଟାର୍‌ପାଇ ଲକ୍‌ମନ୍‌କେ ଡରାନାଇ । ଜନ୍‌ ବିସଇ କି ଲୁଚ୍‌ତେ ଆଚେ, ସେଟା କେବେ ନଇଲେ କେବେ ଡିସ୍‌ସି ଆରି ସବୁ ଲୁଚ୍‌ଲା କାତାମନ୍‌ ଜାନା ପଡ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ଜନ୍‌ଟା ମୁଇ ତମ୍‌କେ ଆନ୍ଦାର୍‌ ବେଲାଇ କଇଲିନି ସେଟା ତମେ ଉଜ୍‌ଲେ କୁଆ, ଆରି ଜନ୍‌ଟା ଲୁଚ୍‌ତେ ସୁନିଆଚାସ୍‌ ସେଟା ଗରର୍‌ ଚାଉନି ଉପ୍‌ରେ ଟିଆଅଇ କୁଆ । ");
INSERT INTO dso_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଜନ୍‌ଲକ୍‌ମନ୍‌ ତମର୍‌ ଗାଗଡ୍‌ ନସ୍‌ଟ କର୍‌ବାଇ ମାତର୍‌ ତମର୍‌ ଆତ୍‌ମାକେ କାଇଟା କରିନାପାରତ୍‌ ସେମନ୍‌କେ ଡରାନାଇ । ମାତର୍‌ ଜନ୍‌ ପର୍‌ମେସର୍‌ ତମର୍‌ ଗାଗଡ୍‌ ଆରି ଆତ୍‌ମାକେ ନରକ୍‌ କୁଣ୍ଡେ ପିଙ୍ଗ୍‌ସି, ତାକେ ଡରା । ");
INSERT INTO dso_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ଡାବୁଦେଇ ଦୁଇଟା ଚେଟିଆ ଚଡଇ ଗେନିପାରାସ୍‌, ମାତର୍‌ ତମର୍‌ ବାବା ପର୍‌ମେସର୍‌ ନାଜାନ୍‌ତେ ସେ ଚଡଇମନର୍‌ତେଇଅନି ଗଟେକ୍‌ ମିସା ନ ମରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ଆରି ପର୍‌ମେସର୍‌ ତମର୍‌ ମୁଣ୍ଡର୍‌ ଚେଣ୍ଡି ମିସା ଗଟେକ୍‌ ଗଟେକ୍‌ କରି ଏଜିଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ଡରାନାଇ, ବେସି ଚେଟିଆ ଚଡଇମନର୍‌ ତେଇ ଅନି ତମର୍‌ ଦାମ୍‌ ଅଦିକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ଜେ ମକେ ସବୁର୍‌ ମୁଆଟେ ‘ମର୍‌ ଲକ୍‌’ ବଲି ନାମ୍‌ସି, ମୁଇ ମିସା ମର୍‌ ସରଗର୍‌ ବାବାର୍‌ ମୁଆଟେ ସେମନ୍‍କେ ‘ମର୍‌ ଲକ୍‌’ ବଲି କଇବି । ");
INSERT INTO dso_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ ମକେ ସବୁର୍‌ ମୁଆଟେ ‘ତାକେ ନାଜାନି’ ବଲି କଇସି, ମୁଇ ମିସା ମର୍‌ ସରଗର୍‌ ବାବାର୍‌ ମୁଆଟେ ‘ତାକେ ନାଜାନି’ ବଲି କଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ମୁଇ ଏ ଦୁନିଆଇ ସାନ୍ତି ଦେବାର୍‌ ଆସିଆଚି ବଲି ତମେ ବାବା ନାଇ । ନାଇ, ସାନ୍ତି ଦେବାକେ ଆସି ନାଇ, କାଣ୍ଡା ଦେବାକେ ଆଇଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ମର୍‌ ଲାଗି ପିଲା ବାବାକେ ବିରଦ୍‌ କର୍‌ସି, ଟକି ଆୟାକେ ବିରଦ୍‌ କର୍‌ସି ଆରି ବୁଆରି ସାତ୍‌ରିର୍‌ ବିରଦେ ଉଟ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ନିଜର୍‌ ଗରର୍‌ ଲକ୍‌ମନ୍‌ସେ ନିଜର୍‌ ସତ୍‌ରୁ ଅଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“କେମିସା ଜଦି ନିଜର୍‌ ମାବାବାକେ ମର୍‌ତେଇଅନି ଅଦିକ୍‌ ଆଲାଦ୍‌ କର୍‌ସି, ସେ ମର୍‌ ସିସ୍‌ ଅଇନାପାରେ । ଆରି ଜନ୍‌ ଲକ୍‌ ମକେ ଆଲାଦ୍‌ କର୍‌ବାଟାନେ ଅନି ନିଜର୍‌ ପିଲାଟକିକେ ଅଦିକ୍‌ ଆଲାଦ୍‌ କର୍‌ସି ବଇଲେ ସେ ମର୍‌ ସିସ୍‌ ଅଇବାକେ ଅଦିକାର୍‍ ନ ପାଏ । ");
INSERT INTO dso_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଜନ୍‌ ଲକ୍‌ ନିଜର୍‌ କୁରୁସ୍‌ ବଇ ମର୍‌ ସଙ୍ଗ୍‍ ନ ଆସେ ବଇଲେ ସେ ମର୍‌ ସିସ୍‌ ଅଇବାକେ ଅଦିକାର୍‍ ନ ପାଏ । ");
INSERT INTO dso_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଜନ୍‌ଲକ୍‌ ନିଜର୍‌ ଜିବନ୍‌ ରକିଆ କର୍‌ବାକେ ଚେସ୍‌ଟା କର୍‌ସି ବଇଲେ ସେ ସେଟା ଆରାଇସି । ମାତର୍‌ ଜେ ମର୍‌ ଲାଗି ତାର୍‌ ଜିବନ୍‌ ଆରାଇସି ବଇଲେ, ସେ ସତଇସେ ସେଟା ରକିଆ କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ଜନ୍‌ ଲକ୍‌ ତମ୍‌କେ ଡାକିନେଇସି, ସେ ମର୍‌ପାଇ ସେଟା କଲାନି । ଆରି ଜନ୍‌ ଲକ୍‌ ମକେ ଡାକିନେଇସି ସେ ମକେ ପାଟାଇଲା ବାବା ପରମେସରର୍‌ ପାଇ ସେଟା କଲାନି । ");
INSERT INTO dso_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଜେ ମିସା ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତାକେ ‘ପର୍‌ମେସରର୍‌ କାତା ସୁନାଉ’ ବଲି ଡାକ୍‌ସି, ବବିସତ୍‍ବକ୍‍ତାକେ ମିଲ୍‌ବା ପୁରୁସ୍‌କାର୍‌ତେଇ ସେ ମିସା ମିସ୍‌ସି । ଆରି ଜେ ଦରମ୍‌ ଲକ୍‌କେ ଗରେ ଡାକ୍‌ସି, ଦରମ୍‌ ଲକ୍‌କେ ମିଲ୍‌ବା ପୁରୁସ୍‌କାର୍‌ତେଇ ସେ ମିସା ମିସ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ଆରି ଜନ୍‌ ଲକ୍‌ ମର୍‌ ପଚେ ପଚେ ଆଇବା ମୁକିଅ ନଇଲା ଗଟେକ୍‌ ସାନ୍‌ ସିସ୍‌କେ, ଗିଲ୍‍ସେକ୍‍ ପାନି ଦେଇସି, ସେ ମର୍‌ ସିସ୍‌ । ସେ ପୁରୁସ୍‌କାର୍‌ ପାଇସି ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଜିସୁ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ସିକାଇ କରି କଇ ପାଟାଇ ସାର୍‌ଲା ପଚେ, ସେ ଜାଗା ଚାଡିକରି ଲଗେ ରଇଲା ଗଡ୍‌ମନର୍‍ ଲକ୍‍ମନ୍‍କେ ଜାଇ ସିକାଇଲା ଆରି ମାପ୍‌ରୁର୍‌ କାତା ସୁନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ସେ ବେଲା ଡୁବନ୍‌ଦେଉ ଜଅନ୍‌ ବନ୍ଦିଗରେ ରଇଲା । ଜିସୁ ଜନ୍‌ କାମ୍‌ମନ୍‌ ସବୁ କର୍‌ତେ ରଇଲା, ତାର୍‌ କବର୍‌ ସୁନି ତାର୍‌ କେତେଟା ସିସ୍‌ମନ୍‌କେ ଜିସୁର୍‌ ଲଗେ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ସେମନ୍‌ ଜାଇ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଜନ୍‌ ଲକ୍‌ ଆଇସି ବଲି ଜଅନ୍‌ କଇରଇଲା, ସେ ଲକ୍‌ ତମେ କି ? ନଇଲେ, ଆମେ ଆରି ବିନ୍‌ ଲକ୍‌କେ ଜାଗ୍‌ବୁ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ବାଉଡି ଜାଇ ଜନ୍‌ଟା ସବୁ ଦେକ୍‌ଲାସ୍‌ ଆରି ସୁନ୍‌ଲାସ୍‌, ଜଅନ୍‌କେ କଇଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କାଣାମନ୍‌ ଦେକିପାର୍‌ଲାଇନି, ଚଟାମନ୍‌ ଇଣ୍ଡ୍‌ଲାଇନି, ବଡ୍‌ ରଗିମନ୍‌ ନିମାନ୍‌ ଅଇଲାଇନି, ବଇରାମନ୍‌ ସୁନ୍‌ଲାଇନି, ମଲା ଲକ୍‌ମନ୍‌ ଜିବନ୍‌ ଅଇଲାଇନି ଆରି ଗରିବ୍‌ ଲକ୍‌ମନର୍‌ ଲଗେ ନିମାନ୍‌ କବର୍‍ କେଟ୍‌ଲାନି । ");
INSERT INTO dso_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ଜେ ମର୍‌ ବିସଇ ନେଇକରି, ‘ସେ କି ନଏଁ ଆଲେ’ ବଲି ନ ବାବେ, ସେ କେଡେ ନିକ କରମର୍‌ ଲକ୍‌ । ଜେ ମକେ ନାମ୍‌ସି ଆରି ମକେ ସବୁ ବେଲା ବିସ୍‌ବାସ୍‌ କର୍‌ସି ତାକେ ପର୍‌ମେସର୍‌ ଆସିର୍‌ବାଦ୍‌ କର୍‌ସି ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ବାଉଡି ଗାଲାବେଲେ ଜିସୁ ଲକ୍‌ମନ୍‌କେ ଜଅନର୍‌ ବିସଇ କଇଲା, ତମେ ଜଅନ୍‌କେ ଦେକ୍‌ବାକେ ଜେଡେବଲ୍‌ ମରୁବାଲିବୁଏଁ ଜାଇରଇଲାସ୍‌, କାଇଟା ଦେକ୍‌ବାକେ ଆସା କରିରଇଲାସ୍‌ ? ପବନ୍‌ ମାର୍‌ଲେ ଜୁଲ୍‌ବା ଗାଁସ୍‌ ପତର୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","କାକେ ଦେକ୍‌ବାକେ ଜାଇ ରଇଲାସ୍‌ ? କାଇ ସୁନ୍ଦର୍‌ ବସ୍‌ତର୍‌ ପିନ୍ଦିରଇବା ଲକ୍‌କେ ଦେକ୍‌ବୁ ବଲି ଜାଇ ରଇଲାସ୍‌ କି ? ସେନ୍ତି ବସ୍‌ତର୍‌ ପିନ୍ଦ୍‌ବା ଲକ୍‌ ରାଜାର୍‌ ଗରେ ରଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ମକେ କୁଆ, କାଇଟା ଦେକ୍‌ବାକେ ଜାଇ ରଇଲାସ୍‌ ? ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତାକେ ଦେକ୍‌ବୁ ବଲିକରି କି ? ସେଟା ତ ସତ୍‌, ମାତର୍‌ ଅବ୍‍କା ବବିସତ୍‌ବକ୍‌ତା ଟାନେଅନି ଗଟେକ୍‌ ଅଦିକ୍‌ ବଡ୍‌ ଲକ୍‌କେ ବେଟ୍‍ପାଇଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","କାଇକେ ବଇଲେ ଏ ଜଅନର୍‌ ବିସଇ ସାସ୍‌ତରେ ଲେକାଅଇଲା ଆଚେ । ପର୍‌ମେସର୍‌ କଇଲା, “ତମର୍‌ ପାଇ ବାଟ୍‌ ତିଆର୍‌ କର୍‌ବାକେ ମୁଇ ପର୍‌ତୁମ୍‌ ମର୍‌ ଦୁତ୍‌କେ ପାଟାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଏ ଦୁନିଆଇ ପୁର୍‌ବେ ଅନି ଆଜିକେ ଜାକ ଜେତେକ୍‌ ଲକ୍‌ ସବୁ ଜନମ୍‌ ଅଇଲାଇଆଚତ୍‌, ସବୁ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ବଡ୍‌ । ମାତର୍‌ ସରଗ୍‌ ରାଇଜେ ଜେ ସବୁର୍‌ଟାନେଅନି ସାନ୍‌, ସେ ଜଅନର୍‌ତେଇ ଅନି ବଡ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ପର୍‌ମେସରର୍‌ ନିକ କାତା ଜାନାଇବାଟା ଆରାମ୍‌ କଲାବେଲେ ଅନି ଆଜିକେ ଜାକ ସରଗ୍‌ ରାଇଜ୍‌ ନେଇକରି ବେସି ଜୁଇଦ୍‌ ଚାଲ୍‌ଲାଆଚେ । ଦୟା ମାୟା ନଇଲା ଲକ୍‌ମନ୍‌ ତାକର୍‌ ବପୁସଙ୍ଗ୍‍ ସରଗ୍‌ ରାଇଜ୍‌ ଅଦିକାର୍‌ କର୍‌ବାକେ ଚେସ୍‌ଟା କଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଜଅନ୍‌ ଆଇବା ଜାକ ମସାର୍‌ ନିୟମ୍‌ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ସରଗ୍‌ ରାଇଜର୍‍ ବିସଇ କଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଜଦି ସେମନର୍‌ କାତା ତମେ ବିସ୍‌ବାସ୍‌ କର୍‌ସା, ତେବେ ଜଅନ୍‌ ଅଇଲାନି ସେ ଏଲିୟ, ଜେ କି ପର୍‌ତୁମ୍‌ ଆଇବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଜାକେ କାନ୍‌ଆଚେ, ସେ ସୁନ । ");
INSERT INTO dso_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ଏ ଜୁଗର୍‌ ଲକ୍‌ମନ୍‌କେ କାର୍‌ ସଙ୍ଗ୍‌ ସମାନ୍‍ କର୍‌ବି ? ସେମନ୍‌ ଆଟ୍‌ ମଜାଇ ବସିକରି କେଲ୍‌ବା ପିଲାମନର୍‌ ପାରା । ଗଟେକ୍‌ ଦଲର୍‌ ପିଲାମନ୍‌ ଆରି ଗଟେକ୍‌ ଦଲ୍‌କେ କଇବାଇ, ");
INSERT INTO dso_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ଆମେ ବିବା ବାଜା ବାଜାଇଲୁ, ମାତର୍‌ ତମେ ନାଟ୍‌ କରାସ୍‌ ନାଇ । ଦୁକର୍‌ ଗିତ୍‌ ଗାଇଲୁ ତମେ କାନ୍ଦାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ଜଅନ୍‌ ତର୍‌କେ ତର୍‌ ଉପାସ୍‌ କର୍‌ତେ ରଇଲା ଆରି କେବେ ମିସା ମଦ୍‌ ନ କାଇତେ ରଇଲା, ମାତର୍‌ ତମେ ତାକେ ଡୁମା ଦାର୍‌ଲା ଲକ୍‌ ବଲି କଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ମାତର୍‌ ନର୍‌ପିଲା ମୁଇ କାଇଲେ କି ପିଇଲେ ମକେ କାଉରାଟା ଆରି ମଦୁଆଟା ବଲି କଇଲାସ୍‌ନି । ସିସ୍‌ତୁ ମାଙ୍ଗୁମନର୍‌ ଆରି ପାପି ଲକ୍‌ମନର୍‌ ମଇତର୍‌ ବଲି କଇଲାସ୍‌ନି । ସେଟା ଜନ୍‌ଟା ଅବେ ଚାଡା, ପର୍‌ମେସରର୍‌ ବିଚାର୍‌ ସତ୍‌ ଆକା । ଏଟା ତାର୍‍ କାମେଅନି ଜାନାପଡ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ଜନ୍‌ ଗଡ୍‌ମନ୍‌କେ ଜିସୁ ତାର୍‌ ବେସି କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କରିରଇଲା, ସେ ଗଡର୍‌ ଲକ୍‌ମନ୍‌ ନିଜେ କରିରଇବା ପାପ୍‌ଲାଗି ମନ୍‌ ନ ବାଦ୍‌ଲାଇଲାଟା ଦେକି, ଜିସୁ ସେ ଗଡର୍‌ ଲକ୍‌ମନ୍‌କେ ନିନ୍ଦା କରି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ଏ କରାଜିନର୍‌ ଲକ୍‌ମନ୍‌, ତମେ କେଡେ ଇନସ୍‌ତା ଅଇ ଡଣ୍ଡ୍‌ ପାଇସା ! ଏ ବେତ୍‌ସାଇଦାର୍‌ ଲକ୍‌ମନ୍‌, ତମର୍‌ ଦସା ମିସା ସେନ୍ତିସେ । ତମର୍‌ ବିତରେ ଜନ୍‌ କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କରାଅଇଲାଆଚେ, ସେଟା ସବୁ ଜଦି ମୁଇ ସର ଆରି ସିଦନ୍‌ ଗଡେ କରି ରଇଲେ, ସେ ଗଡର୍‌ ଲକ୍‌ମନ୍‌ ପାପେଅନି ବାଅଡ୍‌ଲୁ ବଲି ଦେକାଇବାକେ ଗାଗ୍‌ଡେ ଚାର୍‌ ଡାଲିଅଇ, ବାସ୍‌ତା ପିନ୍ଦିକରି ମନ୍‌ ବାଦ୍‌ଲାଇତାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ପର୍‌ମେସରର୍‌ ବିଚାରର୍‌ ଦିନେ ତମର୍‌ତେଇଅନି ସର୍‌ ଆରି ସିଦନ୍‌ ଗଡର୍‌ ଲକ୍‌ମନ୍‌କେ ସେ ଅଦିକ୍‌ ଦୟା ଦେକାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ଏ କପର୍‌ନାଉମର୍‌ ଲକ୍‌ମନ୍‌ ! ତମେ କାଇ ନିଜେ ସର୍‌ଗେ ଜିବାକେ ଚେସ୍‌ଟା କଲାସ୍‌ନି ? ତମେ ନର୍‌କେ ପିଙ୍ଗା ଅଇସି । ତମର୍‌ ବିତ୍‌ରେ ମୁଇ ଜନ୍‌ କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କରିରଇଲି, ସେଟା ଜଦି ସଦମ୍‌ ଗଡେ କରି ରଇଲେ, ସେ ଗଡ୍‌ ଆଜିକେ ଜାକ ରଇତା । ");
INSERT INTO dso_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","“ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ପର୍‌ମେସରର୍‌ ବିଚାର୍‌ନା ଦିନେ ତମର୍‌ତେଇଅନି ସଦମର୍‌ ଲକ୍‌ମନ୍‌କେ ସେ ଅଦିକ୍‌ ଦୟା ଦେକାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ଜିସୁ ସେବେଲାଇ ପାର୍‌ତନା କରି କଇଲା, “ଏ ବାବା, ତମେ ସରଗ୍‌ ଆରି ମଚ୍‌ପୁରର୍‌ ମାପ୍‌ରୁ । ଏ ସବୁ ବିସଇ ସିକ୍‍ଲା ଲକ୍‍ ଆରି ଗିଆନି ରଇବା ଲକର୍‌ତେଇଅନି ଲୁଚାଇ ସଙ୍ଗଇ, ନସିକ୍‍ଲା ଲକ୍‌ମନର୍‌ ତେଇ ଜାନାଇ ଆଚୁସ୍‌ ବଲି ମୁଇ ତମ୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲିନି । ");
INSERT INTO dso_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ଉଁ ବାବା, ତମର୍‌ ମନ୍‍ କଲା ଇସାବେ ଏ ସବୁ ଗଟ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ମର୍‌ ବାବା ମକେ ସବୁ ବିସଇ ଦାନ୍‌ କଲାଆଚେ । ବାବାକେ ଚାଡି କେ ମିସା ତାର୍‍ ପିଲା, ମକେ ନାଜାନତ୍‌ । ଆରି ତାର୍‍ ପିଲା, ମକେ ଚାଡି କେ ମିସା ବାବାକେ ନାଜାନତ୍‌ । ତାର୍‌ ପିଲା ମୁଇ, ଜନ୍‌ ଲକ୍‌ମନର୍‌ ଲଗେ ବାବାକେ ଦେକାଇବି, ସେମନ୍‍ସେ ବାବାକେ ଚିନି ପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ବେସି ବଜ୍‌ ବଇକରି ତାକ୍‌ଲା ଲକ୍‌ମନ୍‌, ମର୍‌ ଲଗେ ଆସା । ମୁଇ ତମ୍‌କେ ପୁଣ୍ଡାଇବି । ");
INSERT INTO dso_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ମର୍‌ ଜୁଆଡି ବଇ ମର୍‌ଟାନେଅନି ସିକା । କାଇକେବଇଲେ ମୁଇ ନିଜେ ସୁଆଲ୍‌ ଆରି ମର୍‌ ମନ୍‌ କୁଉଁଲ୍‌ ଅଇଲାର୍‌ ଲାଗି ତମେ ମର୍‌ଲଗେ ପୁଣ୍ଡ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ମୁଇ ତମର୍‌ ଉପ୍‌ରେ ଜନ୍‌ ଜୁଆଡି ସଙ୍ଗଇବି ସେଟା ତମ୍‌କେ ବଇବାକେ ସଅଜ୍‌ ଅଇସି । ଆରି ତମ୍‌କେ ଜନ୍‌ ବଜ୍‌ ଦେବି, ସେଟା ମିସା ବେସି ଉସାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ତାର୍‌ କେତେ ଦିନ୍‌ ପଚେ ଜିସୁ ଗଟେକ୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ତାସ୍‌ପଦାର୍‌ ବାଟେ ଜାଇତେରଇଲା । ଜିବାବେଲେ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ବୁକ୍‌ ଲାଗ୍‌ଲାଜେ କେଡ୍‌ ଚିଡାଇ କାଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ସେଟା ଦେକି ପାରୁସିମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଦେକ୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ତର୍‌ ସିସ୍‌ମନ୍‌ କେନ୍ତାରି ସାସ୍‌ତରେ ରଇବା ରିତିନିତି ବିରଦର୍‌ କାମ୍‌ କଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଦିନେକ୍‌ ଦାଉଦ୍‌ ଆରି ତାର୍‌ ସଙ୍ଗ୍‍ ରଇଲା ଲକ୍‌ମନ୍‌ ବୁକେ ରଇଲା ବେଲେ, ଦାଉଦ୍‌ କାଇଟା କରି ରଇଲା, ତମେ ସାସ୍‌ତରେ ପଡାସ୍‌ ନାଇ କି ? ");
INSERT INTO dso_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ସେଦିନେ ସେମନ୍‌ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ପୁରି, ମାପ୍‌ରୁର୍‌ପାଇ ସର୍‌ପି ଅଇରଇବା ରୁଟି କାଇଲାଇ । ନିୟମ୍‌ ଇସାବେ ପୁଜାରିକେ ଚାଡି, ସେ ରୁଟି କେ ମିସା କାଇବାର୍‌ ଅଦିକାର୍‌ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ତମେ କାଇ ପଡାସ୍‌ ନାଇ କି ? ମସାର୍‌ ନିୟମ୍‌ ଇସାବେ ସବୁ ବିସ୍‌ରାମ୍‌ବାରେ ପୁଜାରିମନ୍‌ ନିୟମ୍‌ ନ ମାନ୍‌ଲେ ମିସା, ସେଟାର୍‌ ପାଇ, ସେମନ୍‌ ଦସି ବଲି ବିଚାର୍‌ନା ନ ଅଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ମୁଇ ତମ୍‌କେ କଇଲିନି, ଆଜି ଏ ମନ୍ଦିର୍‍ଟାନେଅନି ମୁକିଅ ବିସଇ ଇତି ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“ସାସ୍‌ତର୍‌ କଇଲାନି, ପସୁ ପୁଜ୍‌ବା ବିରୁ ନ କରି, ଲକ୍‍ମନ୍‍କେ ଦୟା କର୍‌ବାଟା, ମୁଇ ମନ୍‍ କଲିନି । ଏ କାତାର୍‌ ଅରତ୍‌ ଜଦି ସତ୍‌ ଇସାବେ ବୁଜିରଇତାସ୍‌ବଇଲେ, ଏ ଦସ୍‌ ନ କଲା ଲକ୍‌ମନ୍‌କେ ତମେ ଦସି ନ କର୍‌ତାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ଜାନିରୁଆ, ନର୍‌ପିଲା ମୁଇ ନିଜେ ବିସ୍‌ରାମ୍‌ବାରର୍‌ ମାପ୍‌ରୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଜିସୁ ସେ ଜାଗାଇଅନି ବାରଇ ଜାଇ ପାର୍‌ତନା ଗରେ ପୁର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ତେଇ ଆତ୍‌ ସୁକିଜାଇରଇଲା ଗଟେକ୍‌ ଲକ୍‌ ରଇଲା । ଜିସୁର୍‌ ଦସ୍‌ ଦାର୍‌ବାକେ ପାରୁସିମନ୍‌ ଗଟେକ୍‌ ଦଲଅଇ ତେଇ ଜାଗି ରଇଲାଇ । ସେଟାର୍‌ପାଇ ସେମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ବିସ୍‌ରାମ୍‌ବାରେ ନିମାନ୍‌ କର୍‌ବାଟା ଆମର୍‌ ନିୟମର୍‌ ବିରଦ୍‌ ନଏଁ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ଜିସୁ କଇଲା, “ଜଦି ବିସ୍‌ରାମ୍‌ବାରେ ତମର୍‌ ବିତ୍‌ରେ କାର୍‌ଆଲେ ମେଣ୍ଡା ଗଟେକ୍‌ ଡେଙ୍ଗ୍‌ କାଲେ ଅଦର୍‌ଲେ, ତମେ ତାକେ ଜିକି ନ ଆନାସ୍‌ କି ? ");
INSERT INTO dso_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ମେଣ୍ଡାର୍‌ତେଇ ଅନି ଗଟେକ୍‌ ଲକର୍‌ ମୁଲିଅ କେତେକ୍‌ ଅଦିକ୍‌ । ସେଟାର୍‌ ପାଇ ଆମେ ବିସ୍‌ରାମ୍‌ବାରେ ବିନ୍‌ ଲକ୍‌କେ ସାଇଜ କର୍‌ବାଟା ସାସ୍‌ତରେ ରଇବା ରିତିନିତିର୍‌ ବିରଦ୍‍ ଅଇବା କାମ୍‌ ନଏଁ ।” ");
INSERT INTO dso_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ଏତ୍‌କି କଇକରି ସେ ଆତ୍‌ ସୁକିଜାଇରଇଲା ଲକ୍‌କେ କଇଲା, “ଆତ୍‌ ସଲକ୍‌ କର୍‌ ।” ସେ ଲକ୍‌ ଆତ୍‌ ସଲକ୍‌ କଲା ଦାପ୍‌ରେ, ସେ ଆତ୍‌ ନିକ ଲକର୍‌ ଆତ୍‌ ପାରା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ତାର୍‌ପଚେ ପାରୁସିମନ୍‌ ସେ ଜାଗାଇଅନି ବାରଇ ଉଟିଜାଇ ଜିସୁକେ ମରାଇବାକେ ଜଜ୍‌ନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ତାର୍‌ ବିରୁଦେ ପାଁଚ୍‌ବାଟା ସୁନିକରି, ଜିସୁ ସେ ଜାଗା ଚାଡି ବିନେ ଉଟିଗାଲା । କେତେକ୍‌ କେତେକ୍‌ ଲକ୍‌ ତାର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ଆରି ସେ ସବୁ ରଗି ଲକ୍‌ମନ୍‌କେ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ତାର୍‌ ନିଜର୍‌ ବିସଇ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ କାଇ ବଲି ନ କୁଆ ବଲି ସେମନ୍‌କେ ଆଦେସ୍‌ ଦେଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ଟାନେଅନି ପର୍‌ମେସର୍‌ ଜନ୍‌ କାତା ସୁନାଇରଇଲା, ସେଟା ପୁରାପୁରୁନ୍‌ କର୍‌ବାକେ ଏଟା କଲା, ");
INSERT INTO dso_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ଏ ମର୍‌ ବାଚିରଇବା ସେବାକାରିଆ । ଆକେ ମୁଇ ଆଲାଦ୍‌ କଲିନି, ତାର୍‌ ଲଗେ ମର୍‍ ସାର୍‌ଦା । ମର୍‌ ଆତ୍‌ମା ତାର୍‌ ଉପ୍‌ରେ ଆସି ଡାବି ଅଇସି, ସେ ସବୁ ଜାତିର୍‌ ଲଗେ ଜାଇ ମର୍‌ ଟିକ୍‌ ବିଚାର୍‌ନା ଜାନାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ସେ କାକେ କିରଜାଟି ନ କରେ । ସେ ବେସି ଆଉଲି ନ ଅଏ । ସାଇର୍‌ ମଜାଇ ଟିଆ ନ ଅଏ ଆରି ଜବର୍‌ ଅଇତେ କାତା ନ କଏ । ");
INSERT INTO dso_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ଦୁର୍‌ବଲ୍‌ ଲକ୍‌ମନ୍‌କେ ସେ ଆଲାଦର୍‌ ଚଲାଚଲ୍‌ତି କର୍‌ସି, ଆରି ଆକା ସାକା ନଇଲା ଲକ୍‌ମନ୍‌କେ ଦୟା କର୍‌ସି । ସେମନ୍‌ ନିଆଇ ନ ପାଇବାଜାକ ସେ ତାର୍‌ କାମ୍‌ ବନ୍ଦ୍‌ ନ କରେ । ");
INSERT INTO dso_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ତାକେ ସବୁ ଦେସର୍‌ ଲକ୍‌ ଆସା କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ତାର୍‌ ପଚେ ଦିନେକ୍‌ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ କାଣା ଅଇ ଗୁଲା ଅଇଜାଇରଇଲା ଲକ୍‌କେ ଜିସୁର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ତାକେ ଡୁମା ଦାରିରଇଲାଜେ କାତାଅଇ ନାପାର୍‌ତେ ରଇଲା । ଜିସୁ ତାକେ ନିମାନ୍‌ କଲା । ଏଦେ ଦେକା ! ସେ ଦେକ୍‌ଲା ଆରି କାତା କଇପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ଜିସୁର୍‌ ଏ କାମ୍‌ ଦେକି ସବୁ ଲକ୍‌ କାବା ଅଇଜାଇ ପାଚାର୍‌ ଉଚାର୍‌ ଅଇଲାଇ, “ଏ କାଇ ସେ ଦାଉଦର୍‌ ପଅ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ଏଟା ସୁନି ପାରୁସିମନ୍‌ କଇଲାଇ, “ସେ ଡୁମାମନର୍‌ ମୁକିଅ ବାଲ୍‍ଜିବୁଲର୍‌ ଟାନେଅନି ବପୁ ପାଇ ଡୁମା ଚାଡାଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ଜିସୁ ତାକର୍‌ ମନର୍‌ କାତା ଜାନି ସେମନ୍‌କେ କଇଲା, ଗଟେକ୍‌ ରାଇଜର୍‌ ଲକ୍‌ ବିନ୍‌ବିନ୍‌ ଦଲେ ବାଗ୍‍ ଅଇ ନିଜର୍‌ ନିଜର୍‌ ବିତରେ ଲାଗାଲାଗି ଅଇଲେ, ସେ ଦେସ୍‌ ବେସି ଦିନ୍‌ ନ ରଏ । କନ୍‌ଆଲେ ସଅର୍‌ ନଇଲେ ଗର୍‌ ବିତ୍‌ରେ ବିନ୍‌ ବିନ୍‌ ଦଲ୍‌ ଗଡିକରି ଲାଗାଜଡା ଅଇଲେ ସେମନ୍‌ ଦାପ୍‌ରେସେ କୁରୁପ୍‌ନାସ୍‌ ଅଇଜିବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ସେନ୍ତାରିସେ, ସଇତାନର୍‌ ରାଇଜେ ଜଦି ଗଟେକ୍‌ ଦଲ୍‌ ବିନ୍‌ ଦଲ୍‌ ବିରୁଦେ ଲାଗ୍‌ଲାନି ବଇଲେ, ସେଟା କୁଟ୍‌କୁଟା ଅଇ ବିଲିଜାଇସି । ଏଟା ଜାନ୍‌ବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ମୁଇ ବାଲ୍‍ଜିବୁଲର୍‌ ବପୁ ପାଇ ଡୁମାମନ୍‌କେ ଚାଡାଇଲିନି ବଲି ତମେ କଇଲାସ୍‌ନି ତେବେ, ସେମନ୍‌କେ କେଦ୍‌ବାକେ ତମର୍‌ ସିସ୍‌ମନ୍‌କେ କେ ବପୁ ଦେଲାନି ? ତମର୍‌ ସିସ୍‌ମନର୍‌ ଏ କାମର୍‌ ଲାଗି, ତମେ ଦାବି କଲାଟା ମିଚ୍‌ ବଲି ଜାନାପଡ୍‌ଲାନି । ");
INSERT INTO dso_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ଡୁମା ଚାଡାଇବା ବପୁ ମୁଇ ବାଲ୍‍ଜିବୁଲର୍‌ ଟାନେଅନି ପାଇନାଇ । ସେଟା ମୁଇ ପର୍‌ମେସରର୍‌ ଆତ୍‌ମାର୍‍ଟାନେଅନି ପାଇଆଚି । ଏଟାର୍‌ ପାଇ ଆରି ଗଟେକ୍‌ ବିସଇ ଜାନାପଡି ଗାଲାନିଜେ ସରଗ୍‌ ରାଇଜ୍‌ ତମର୍‌ ଲଗେ ଆସି କେଟିଗାଲାବେ । ");
INSERT INTO dso_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ଆଗେ ଗଟେକ୍‌ ବପୁର୍‌ ଲକ୍‌କେ ନ ବାନ୍ଦ୍‌ତେ କେ ମିସା ତାର୍‌ ଗରେ ପୁରିକରି ଗରେ ରଇଲାଟା ଚରାଇ ନେଇ ନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ଜେ ମର୍‌ ବାଟେ ନ ରଏ, ବାଇଦରେ ସେ ମର୍‌ ବିରୁଦେ ଆଚେ । ଆରି ଜେ ମର୍‌ ସଙ୍ଗ୍‌ ମିସିକରି ନ ଟୁଲିଆଏ, ସେ ବିଚିଦେଲାନି । ");
INSERT INTO dso_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ସେଟାର୍‌ପାଇ ମୁଇ ତମ୍‌କେ କଇଲିନି, ଜଦି କେ ଆଲେ ପାପ୍‌ କଲେ କି ନିନ୍ଦା କାତା କଇଲେ ମିସା, ତାର୍‍ ଲାଗି ତାକେ କେମା ଦିଆଅଇସି । ମାତର୍‌ କେ ଜଦି ସୁକଲ୍‌ ଆତ୍‌ମାର୍‌ ବିରୁଦେ କାଇ ବଲି କଇସି ବଇଲେ, ତାକେ କେମା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଜଦି କେ ନର୍‌ପିଲା, ମର୍‌ ବିରଦେ ନିନ୍ଦା କାତା କଇଲେ, ତାକେ କେମା ମିଲ୍‌ସି, ମାତର୍‌ ଜେ ଜଦି ସୁକଲ୍‌ ଆତ୍‌ମାର୍‌ ବିରୁଦେ ନିନ୍ଦା କାତା କଇଲେ ତାକେ ଏବେ କି ପଚ୍‌କେ ମିସା କେମା ନ ମିଲେ । ");
INSERT INTO dso_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ନିକ ପଲ୍‌ ଦାର୍‌ବାର୍‌ଆଲେ ଗଟେକ୍‌ ଗଚ୍‌ ନିକ ଅଇବାର୍‌ ଆଚେ । ବାନିଆ ଗଚେ ବାନିଆ ପଲ୍‌ ଅଇସି । ଗଚ୍‌ କେନ୍ତିଟା, ତାର୍‌ ପଲେ ଅନି ଜାନାପଡ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ଏ ସାଁପ୍‌ ପାରା କାରାପ୍‌ ଲକ୍‌ମନ୍‌ ! ତମେ କାରାପ୍‌ ଅଇ ନିମାନ୍‌ କାତା କଇପାରାସ୍‌ କି ? ମନେ ଚିନ୍ତାକଲାଟା ଟଣ୍ଡ୍‌ବାଟେ ବାରଇସି । ");
INSERT INTO dso_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ଗଟେକ୍‌ ନିମାନ୍‌ ଲକ୍‌ ତାର୍‌ ମନ୍‌ବିତ୍‌ରେ ଅନି ନିମାନ୍‌ କାତା ଆନ୍‍ସି । ଗଟେକ୍‌ କାରାପ୍‌ ଲକ୍‌ ତାର୍‌ ମନ୍‌ ବିତ୍‌ରେ ବର୍‌ତିଅଇ ରଇବା ବାଦ୍‌ଲାପାରା କାତା ବାର୍‌କରାଇ ଆନ୍‍ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ତମେ କଇରଇଲା କାଇ ଲଡାକେ ନଇବା ସବୁ କାତା, ବିଚାର୍‌ନା ଦିନେ ତମ୍‌କେ ଇସାବ୍‌ ଦେବାକେ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ତମର୍‌ କାତାଇଅନି ତମେ ବିଚାର୍‌ କରାଇଅଇ, ଦସି ନଇଲେ ଦସ୍‍ ନ କଲା ଲକ୍‌ ବଲାଇଅଇସା ।” ");
INSERT INTO dso_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ଗଟେକ୍‌ ଦିନେ ଜିଉଦି ମନର୍‌ ନିୟମ୍‌ ସିକାଇଦେବା ଲକ୍‌ମନ୍‌ ଆରି ପାରୁସି ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି କେତେଲକ୍‌ ଜିସୁକେ କଇଲାଇ, “ଏ ଗୁରୁ, ତମର୍‌ ଗଟେକ୍‌ କାବାଅଇଜିବା ଚିନ୍‌ ଦେକ୍‌ବାକେ ଆମେ ମନ୍‍କଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏ ଜୁଗର୍‌ ବିସ୍‌ବାସ୍‌ ନ କରୁମନ୍‌ କେଡେ କାରାପ୍‌, ଆରି ପର୍‌ମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ନାଇ । ତମେ ମକେ ଗଟେକ୍‌ କାବାଅଇଜିବା କାମ୍‌ ଦେକାଇବାକେ କଇଲାସ୍‌ନି ? ନାଇ, ଅବ୍‍କା ବାବବାଦି ଜୁନସର୍‍ ଜିବନେ ଗଟିରଇଲା କାବାଅଇଜିବାଟା ତମ୍‌କେ ଦେକାଇଦେଇ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“ଜୁନସ୍‌ ଜେନ୍ତି ମାଚ୍‌ ପେଟେ ତିନ୍‌ ଦିନ୍‌ ତିନ୍‌ ରାତି ରଇଲା, ସେନ୍ତି ନର୍‌ପିଲା ମୁଇ ମିସା ମାଟି ତଲେ ତିନ୍‌ ଦିନ୍‌ ତିନ୍‌ ରାତି କାଟାଇବି । ");
INSERT INTO dso_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ଜନ୍‌ ଦିନେ ପର୍‌ମେସର୍‌ ଲକ୍‌ମନର୍‌ ବିଚାର୍‌ କର୍‌ସି, ସେ ଦିନେ ନିନିବିର୍‌ ଲକ୍‌ମନ୍‌ ତମର୍‌ ବିରୁଦେ ଦାବି କର୍‌ବାକେ ଟିଆ ଅଇବାଇ । କାଇକେ ବଇଲେ ସେମନ୍‌ ଜୁନସର୍‌ କାତା ସୁନି ପାପ୍‌ ବାଟେଅନି ବାଅଡ୍‌ଲାଇ । ମୁଇ ତମ୍‌କେ କଇଲିନି, ଜୁନସର୍‌ ଟାନେଅନି ବଡ୍‌ ଲକ୍‌ ଇତି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ବିଚାର୍‌ କର୍‌ବାବେଲେ ଦକିନ୍‌ ଦେସେ ରଇବା ସେବା ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାର୍‌ ରାନି, ତମର୍‌ ଦସ୍‌ ଦେକାଇବାକେ ଟିଆ ଅଇସି, କାଇକେ ବଇଲେ ସଲମନର୍‌ ଗିଆନର୍‌ କାତା ସୁନ୍‌ବାକେ ବେସି ଦୁର୍‌ ଦେସେଅନି ସେ ଆସି ରଇଲା । ମାତର୍‌ ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ସଲ୍‌ମନର୍‌ ଟାନେ ଅନି ଗଟେକ୍‌ ବେସି ବଡ୍‌ ଲକ୍‌ ଇତି ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ଜିସୁ ଆରି କଇଲା, ଜେଡେବଲ୍‌ କାରାପ୍‌ ଆତ୍‌ମା ଗଟେକ୍‌ ଲକର୍‌ ଗାଗ୍‌ଡେଅନି ବାରଇ ଜାଇସି, ସେବେଲା, ସେ ରଇବାକେ ମରୁବାଲିବୁଏଁ ଜାଗା କଜି ବୁଲ୍‌ସି । ମାତର୍‌ ସେନ୍ତି ଜାଗା ତାକେ ନ ମିଲ୍‌ଲେ । ");
INSERT INTO dso_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ସେ ବେଲା ସେ କଇସି, “ମୁଇ ଜନ୍‌ ଲକର୍‌ତେଇଅନି ବାରଇ ଆଇଲି ଆଚି, ତେଇସେ ଆରିତରେକ୍‌ ଜିବି” ବଲି ବାଉଡି ଉଟିଜାଇସି । ସେଡିକି ବେଲେ ସେ ଆସିକରି ବିତ୍‌ରେ ସପାସୁତର୍‌ ଅଇ ପରିଚଲ୍‌ ରଇବାଟା ଦେକ୍‌ଲେ, ସେ ଜାଇ ତାର୍‌ତେଇଅନି ଅଦିକ୍‌ କାରାପ୍‌ ରଇବା ସାତ୍‌ଟା ଆତ୍‌ମାମନ୍‌କେ ଡାକିଆନ୍‍ସି । ");
INSERT INTO dso_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ତାର୍‌ ପଚେ ସବୁ କାରାପ୍‌ ଆତ୍‌ମାମନ୍‌ ଜାଇକରି ସେ ଲକର୍‌ ବିତ୍‌ରେ ବାସାକରି ରଇବାଇ । ସେ ବେଲା ସେ ଲକ୍‌ ଆଗ୍‌ତୁର୍‌ତେଇଅନି ଅଦିକ୍‌ କରାପ୍‌ଅଇଜାଇସି । ଏନ୍ତିସେ ଆଜିକାଲି ଜିଇବା କାରାପ୍‌ ଲକ୍‌ମନ୍‌କେ ଅଇସି । ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ଜିସୁ ଜେଡେବେଲା ତେଇ ରୁଣ୍ଡିରଇଲା ଲକ୍‌ମନ୍‌କେ କାତା ସୁନାଇତେ ରଇଲା, ତାର୍‌ ଆୟା ଆରି ବାଇମନ୍‌ ଆସି ଡାଣ୍ଡେ ଟିଆଅଇରଇଲାଇ । ସେମନ୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ କାତାଅଇବାକେ ମନ୍‍ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ସେଡିକି ବେଲେ ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ କଇଲା, “ତର୍‌ ଆୟା ଆରି ବାଇମନ୍‌ ଡାଣ୍ଡେ ଜାଗ୍‌ଲାଇ ଆଚତ୍‌, ସେମନ୍‌ ତର୍‌ ସଙ୍ଗ୍‌ କାତା ଅଇବାକେ ମନ୍‍ କଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “କାକେ ମର୍‌ ଆୟା ଆରି ବାଇମନ୍‌ ବଲି ବାବ୍‌ଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ତାର୍‌ ସିସ୍‌ମନର୍‌ ବାଟେ ଆତ୍‌ ଦେକାଇ କଇଲା, “ଏ ଲକ୍‌ମନ୍‍ସେ ମର୍‌ ଆୟା ଆରି ବାଇମନ୍‌ ଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ଜେ ସର୍‌ଗେ ରଇବା ମର୍‌ ବାବାର୍‌ ମନ୍‍ କଲା ଇସାବେ କାମ୍‌ କର୍‌ସି, ସେମନ୍‌ ଆକା ମର୍‌ ବାଇ, ବଇନି ଆରି ଆୟା ଅଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ଦିନେକ୍‌ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଗରେ ଅନି ବାରଇ ସମ୍‌ଦୁର୍‌ କଣ୍ଡି ଗାଲା । ତେଇ ସେ ବସିକରି ସିକାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ଲକ୍‌ମନ୍‌ ତାର୍‌ ଚାରିବେଡ୍‌ତି ଜବର୍‌ ଅଇ ରୁଣ୍ଡିରଇଲାଇଜେ ସେ ଗଟେକ୍‌ ଡଙ୍ଗାଇ ଜାଇ ବସ୍‌ଲା । ଲକ୍‌ମନ୍‌ ଟିଆ ଅଇ ତାର୍‌ କାତା ସୁନ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ଆରି ସେ କେତେକ୍‌ କେତେକ୍‌ ବିସଇ, ଉଦାଅରଣ୍‌ ଦେଇ, ସିକାଇତେ ରଇଲା । ସେ କଇଲା, “ଗଟେକ୍‌ ଚାସି ତରେକ୍‌ ବିଅନ୍‌ ବୁନ୍‌ବାର୍‌ ବାରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ଚାସି ସେ ଜମିଟାନେ ବିଅନ୍‌ ବୁନ୍‌ବା ବେଲେ କେତେଟା ମୁଞ୍ଜି ମଜା ବାଟେ ଅଦର୍‌ଲାଜେ ସେଟା ଚଡଇମନ୍‌ ଆସି କାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ଆରି ଅଦେକ୍‌ ମାଟି ଉନାରଇ ଜବର୍‌ ପାକ୍‌ନା ରଇବା ପଦାଇ ଅଦର୍‌ଲା । ତେଇ ମାଟି ବଉଲ୍‌ ନ ରଇଲାଜେ ଦାପ୍‌ରେ ଆଁକ୍‌ରି ଗାଜା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ମାତର୍‌ ଗାଜାର୍‌ ଚେର୍‌ ବିତ୍‌ରେ ଜାଏ ନାଇଜେ, କାରା କଲାକେ ସେଟା ସୁକିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଆରି କେତେଟା ବିଅନ୍‌ କାଟାବୁଟା ବିତ୍‌ରେ ଅଦର୍‌ଲା, ଆରି କାଟାବୁଟା ଆଁକ୍‌ରି ଗାଜା ଅଇଲା । ବିଅନର୍‌ ଚାରିବେଡ୍‌ତି ବର୍‌ଡି ଜାଇ ସେଟା ସବୁ ଗିଲିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ମାତର୍‌ ଆରି ବାକି ସବୁ ବିଅନ୍‌ ନିକ ବୁଏଁ ଅଦ୍‌ରି ବୁଟା ଅଇ ବଡିକରି ପଲ୍‌ ଦାର୍‌ଲା । କେତେଟା ବୁଟାଇ ତିରିସ୍‌ ବାଗ୍‌, ସାଟେ ବାଗ୍‌, ଆରି ସଏ ବାଗ୍‌ ଅନି ଅଦିକ୍‌ ପଲ୍‌ଦାର୍‌ଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ଜିସୁ ଉଦାଅରଣ୍‌ ସାରାଇକରି କଇଲା, “ଜାକେ ସୁନ୍‌ଲା ପାରା କାନ୍‌ ଆଚେ, ସେ ସୁନ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ପଚେ ସିସ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ପାଚାର୍‌ଲାଇ, “ତମେ ଲକ୍‌ମନ୍‌କେ ସିକାଇଲା ବେଲେ କାଇକେ ଉଦାଅରଣ୍‌ ଇସାବେ କଇଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ଜିସୁ କଇଲା, “ସରଗ୍‌ ରାଇଜର୍‌ ଟିକି ନିକି କାତା ବୁଜ୍‌ବାକେ ତମେ ଗିଆନ୍‌ ପାଇଆଚାସ୍‌ । ମାତର୍‌ ସେମନ୍‌ ପାଅତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ଜାକେ ଆଚେ, ତାକେ ଦିଆଅଇସି । ତେଇଅନି ସେ ଅଦିକ୍‌ ଅଦିକ୍‌ ଲାବ୍‌ କର୍‌ସି । ମାତର୍‌ ଜାକେ ନାଇ, ତାର୍‌ଟାନେ ଜେତ୍‌କି ଆଚେ, ସେଟା ମିସା ନିଆଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ସେମନ୍‌କେ ମୁଇ କାତାନି ଇସାବେ ସିକାଇଲିନି । କାଇକେବଇଲେ ସେମନ୍‌ ଦେକି ଦେକି ରଇବାଇ, ମାତର୍‍ ନ ଦେକ୍‌ଲା ପାରା । ସୁନ୍‌ତେ ରଇବାଇ, ମାତର୍‍ ନ ସୁନ୍‌ଲା ପାରା ଆରି ନ ବୁଜତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତା କଇରଇବା ବାକିଅ ପୁରାପୁରୁନ୍‌ ଅଇଲା । ଏ ଲକ୍‌ମନ୍‌ ସୁନି ସୁନି ମିସା କାଇଟା ନ ବୁଜତ୍‌ ଦେକ୍‌ତେରଇବାଇ, ମାତର୍‌ ନ ଦେକ୍‌ଲା ପାରା । ");
INSERT INTO dso_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","କାଇକେ ବଇଲେ ସେମନର୍‌ ବୁଦି ଉନା । ସେମନ୍‌ କାନେ ଚୁଟିଅଇ ଦେଇଆଚତ୍‌ ଆରି ଆଁକି ଲିମିଦେଇ ଆଚତ୍‌ । ସେନ୍ତାର୍‌ ନ ଅଇରଇଲେ ସେମନ୍‌ ଦେକିପାର୍‌ତାଇ, ସୁନିପାର୍‌ତାଇ ଆରି ମର୍‌ ଲଗେ ବାଉଡି ଆଇତାଇ । ସେମନ୍‌କେ ମୁଇ ନିକ କରିଦେଇତି । ");
INSERT INTO dso_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ତମେ କେଡେକ୍‌ ନିକ କରମର୍‌ ଲକ୍‌ ! ତମେ ଦେକି ପାର୍‌ଲାସ୍‌ନି ଆରି ସୁନି ପାର୍‌ଲାସ୍‌ନି ! ");
INSERT INTO dso_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, କେତେକ୍‌ କେତେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ଆରି ପର୍‌ମେସରର୍‌ ଲକ୍‌ମନ୍‌ ତମେ ଜନ୍‌ଟା ଦେକ୍‌ଲାସ୍‌ନି, ସେଟା ଦେକ୍‌ବାକେ, ଆରି ଜାଇଟା ସୁନ୍‌ଲାସ୍‌ନି, ସେଟାମନ୍‌ ସୁନ୍‌ବାକେ ମନ୍‌ କର୍‌ତେରଇଲାଇ, ମାତର୍‌ ନାପାର୍‌ଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ତେବେ ସୁନା, ବିଅନ୍‌ ବୁନ୍‌ବା କାତାର୍‌ ଅରତ୍‌ କଇଲିନି । ତମେ ବୁଜ୍‌ବାକେ ଚେସ୍‌ଟା କରା । ");
INSERT INTO dso_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ସରଗ୍‌ ରାଇଜର୍‌ ବାକିଅ ସୁନି ନ ବୁଜତ୍‌, ସଇତାନ୍‌ ଆସି ସେମନର୍‌ ମନ୍‌ ବିତ୍‌ରେ ଅନି ଜନ୍‌ଟା ବୁନାଅଇ ରଇସି, ସେଟା ଜିକି ଦାରିଜାଇସି । ଏଟା ଅଇଲାନି ବାଟେ ଅଦ୍‌ରି ରଇବା ବିଅନର୍‌ ଅରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“ଜନ୍‌ ଲକ୍‌ମନ୍‌ ବାକିଅ ସୁନ୍‌ଲା ଦାପ୍‌ରେ ସାର୍‌ଦା ସଙ୍ଗ୍‌ ମାନ୍‌ବାଇ, ସେଟା ପାକ୍‌ନାବାଡି ଜାଗାଇ ଅଦ୍‌ରିରଇବା ବିଅନ୍‌ ପାରା । ");
INSERT INTO dso_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ବାକିଅ ପୁରାପୁରୁନ୍‌ ତାକର୍‌ ମନ୍‌ ବିତ୍‌ରେ ଜାଇ ନ ରଏ ଜେ, ସେମନ୍‌ ସେଟା ବେସି ଦିନ୍‌ ମାନିକରି ରଇ ନାପାରତ୍‌ । ବାକିଅର୍‌ ଲାଗି କସ୍‌ଟ କି ବେମ୍‍ଜା ଆଇଲେ, ସେମନ୍‌ ଦାପ୍‌ରେସେ ସେଟା ଚାଡିଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","କାଟାବୁଟା କେନ୍ତାର୍‌କି ସାନ୍‌ ବୁଟାମନ୍‌କେ ଚାପି ଗିଲିଦେଇସି, ସେନ୍ତାରି ଏ ଜଗତର୍‌ ପାଇଟି କାବାଡ୍‌ ଆରି ଦନ୍‌କେ ଲବ୍‌ ଅଇକରି, କେତେକ୍‌ ଲକ୍‌ମନର୍‌ ଟାନେ କେଟିରଇବା ବାକିଅ ନସାଇଦେଇସି । ସେମନ୍‌ କାଟାବୁଟାଇ ଅଦର୍‌ଲା ବିଅନ୍‌ ପାରା । ସେମନର୍‌ କାଇ ପସଲ୍‌ ନ ପାଚାଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ଜନ୍‌ଲକ୍‌ମନ୍‌ ବାକିଅ ସୁନି ନିକକରି ବୁଜ୍‌ବାଇ, ନିକ ପଦାଇ ଅଦ୍‌ରିରଇବା ବିଅନର୍‌ ପାରା । ସେମନ୍‌ ନିକ ପସଲ୍‌ ଲାବ୍‌ କର୍‌ବାଇ କେ ସଏ ପୁଟିଅନି ଅଦିକ୍‌, କେ ସାଟେ ପୁଟିଅନି ଅଦିକ୍‌, କେ ତିରିସ୍‌ ପୁଟିଅନି ଅଦିକ୍‌ ପସଲ୍‌ ପାଚାଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଆରି ଗଟେକ୍‌ ବିସଇ କାତାନି ଇସାବେ କଇଲା, ସରଗ୍‌ ରାଇଜ୍‌ ଏନ୍ତାରି ଗଟେକ୍‌ ଲକର୍‌ ପାରା । ସେ ଲକ୍‌ ତାର୍‌ ଜମିଟାନେ ନିକ ବିଅନ୍‌ ବୁନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ସେ ଦିନେକ୍‌, ରାତିଆ ସଇଲା ବେଲେ, ତାର୍‌ ଗଟେକ୍‌ ବିରଦ୍‌ ଲକ୍‌ ଆସି ସେ ଜମିଟାନେ ଗାଁସ୍‌ ମୁଞ୍ଜି ବୁନି ଦେଇ, ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ଜେଡେବେଲେ ଗଚ୍‌ ବଡି କେଡ୍‌ ଦାର୍‌ଲା, ମଜାଇମଜାଇ ଜୁଡ୍‌ ଗାଁସ୍‌ ଡିସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ସେ ଲକର୍‌ ଦାଙ୍ଗ୍‌ଡାମନ୍‌ ଆସି କଇଲାଇ, “ ଏ ସାଉକାର୍‌ ତମେ ଜମିଟାନେ ନିକ ବିଅନ୍‌ ବୁନିରଇଲାସ୍‌, ଏତେକ୍‌ମାଣ୍ଡ୍‌ ଜୁଡ୍‌ ଗାଁସ୍‌ କନ୍ତିଅନି ଆଇଲା ?” ");
INSERT INTO dso_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ଜମି ସାଉକାର୍‌ କଇଲା, ମର୍‌ ବିରଦି ଲକ୍‌ ଗଟେକ୍‌ ଏନ୍ତି କଲାଆଚେ । ସେମନ୍‌ ପାଚାର୍‌ଲାଇ, “ତେବେ ଆମେ ଜାଇ ସେ ଜୁଡ୍‌ ଗାଁସ୍‌ମନ୍‌କେ ଜିକି ପିଙ୍ଗିଦେବୁ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ସାଉକାର୍‌ କଇଲା, “ନାଇ, ଜୁଡ୍‌ ଗାଁସ୍‌ ଜିକ୍‌ବାବେଲେ କେଡେବଲ୍‌ ଦାନ୍‌ବୁଟା ମିସା ଜିକିଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","କାଟ୍‌ବା ଜାକ ଦାନ୍‌ ଆରି ଜୁଡ୍‌ ଗାଁସ୍‌ ମିସ୍‌ତେ ବଡ । କାଟ୍‌ବା ଲକ୍‌ମନ୍‌କେ କଉଁ ସେମନ୍‌ ପର୍‌ତୁମ୍‌ ଜୁଡ୍‌ ଗାଁସ୍‌ କାଟି ବାରା ବାନ୍ଦି ପଡାଇ ଦେଅତ୍‌ । ତାର୍‌ ପଚେ ଦାନ୍‌ କାଟି ମାଣ୍ଡାଇ କଲ୍‌କିଟାନେ ସଙ୍ଗଉ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଜିସୁ ଆରି ଗଟେକ୍‌ ବିସଇ କଇଲା, “ସରଗ୍‌ ରାଇଜ୍‌ ଏନ୍ତାରି ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‌ ଜମିଟାନେ ସର୍‌ସୁ ମୁଞ୍ଜି ତପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ସେ ମୁଞ୍ଜି ସବୁର୍‌ଟାନେଅନି ସାନ୍‌ ଅଇଲେ ମିସା ତେଇଅନି ଜନ୍‌ ଗଚ୍‌ ଅଇଲା, ଜମିଟାନେ ରଇଲା ବିନ୍‌ ଗଚ୍‌ମନର୍‌ତେଇଅନି ଅଦିକ୍‌ ଡେଙ୍ଗ୍‌ ଅଇ ଜୁଜୁରା ଅଇଲା । ଆରି ସେ ଗଚେ ଚଡଇମନ୍‌ ବାସା ଅଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ଜିସୁ ଆରି ତରେକ୍‌ ଏନ୍ତାରି କାତା କଇଲା, “ଗଟେକ୍‌ ମାଇଜି କଣ୍ଡେକ୍‌ କମିର୍‌ ନେଇ ଅଦ୍‌ବାସ୍‌ତା ଗୁଣ୍ଡ୍‌ଟାନେ ମିସାଇଦେଲା । ସମାନ୍‌ ବେଲାଇ ସବୁଜାକ ଗୁଣ୍ଡ୍‌ କମିର୍‌ତେଇ ମିସି ପୁଲ୍‌ଲା । ସରଗ୍‌ ରାଇଜ୍‌ ବଡ୍‌ବାଟା ମିସା ଏନ୍ତାରିସେ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଜିସୁ ଏନ୍ତାରି ଉଦାଅରଣ୍‌ ଦେଇ ସିକାଇତେ ରଇଲା । ଉଦାଅରଣ୍‌ ନ ଦେଇ ସେ କାଇଟା ମିସା ନ ସିକାଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ଏଟାର୍‌ପାଇ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ଏ ବାକିଅ ପୁରାପୁରୁନ୍‌ ଅଇଲା । ମୁଇ ଉଦାଅରଣ୍‌ ଦେଇ ସେମନ୍‌କେ କାତା କଇବି, ଏନ୍ତାରିସେ କାଇଟା ତିଆର୍‌ ନ ଅଇବା ଆଗ୍‌ତୁଅନି ନାଜାନି ରଇବା ସବୁ ବିସଇ ମୁଇ ସେମନ୍‌କେ ବୁଜାଇଦେବି । ");
INSERT INTO dso_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ଜିସୁ ଲକ୍‌ ଗଅଲି ବିତ୍‌ରେଅନି ବାରଇ ଆସି ଜେଡେବେଲେ ଗର୍‌ ବିତ୍‌ରେ ପୁର୍‌ଲା, ସେଡ୍‌କି ବେଲେ ତାର୍‌ ସିସ୍‌ମନ୍‌ ଆସି ପାଚାର୍‌ଲାଇ, “ଆମ୍‌କେ ଜୁଡ୍‌ ଗାଁସର୍‌ ଅରତ୍‌ ବୁଜାଇ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ଜିସୁ କଇଲା, “ଜନ୍‌ ଲକ୍‌ ନିକ ବିଅନ୍‌ ବୁନ୍‌ଲା, ସେ ନର୍‌ପିଲା ମୁଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ଏ ଦୁନିଆ ଅଇଲାନି ଜମି । ଜେମନ୍‌ ସରଗ୍‌ ରାଇଜର୍‌ ଲକ୍‌, ସେମନ୍‌ ନିକ ବିଅନ୍‌ । ଜୁଡ୍‌ ଗାଁସ୍‌ ଅଇଲାନି ସଇତାନର୍‌ ବାଟେ ଜିବା ଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ଜନ୍‌ ବିରଦି ଲକ୍‌ ଜୁଡ୍‌ ଗାଁସ୍‌ ମୁଞ୍ଜି ବୁନ୍‌ଲା, ସେ ସଇତାନ୍‌ । କାଟାବେଟାର୍‌ ବେଲା ଅଇଲାନି ଜୁଗ୍‌ ସାର୍‌ବା ଦିନ୍‌ । ତାସ୍‌ କାଟ୍‌ବା ଲକ୍‌ମନ୍‌ ଅଇଲାଇନି ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ଜୁଡ୍‌ ଗାଁସ୍‌ମନ୍‌ ଜେନ୍ତି ଟୁଲିଆଇକରି ପଡାଇଲାଇ, ଜୁଗର୍‌ ସାରାସାରି ବେଲେ ସେନ୍ତାରି ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ନର୍‌ପିଲା ମୁଇ ମର୍‌ ରାଇଜେଅନି ସବୁ ପାପ୍‌ କାମ୍‌ କଲା ଲକ୍‌ମନ୍‌କେ ଆରି ଜେଜେମନ୍‌ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ପାପ୍‌ କର୍‌ବାକେ ଉସ୍‌କାଇଲାଇନି, ସେମନ୍‌କେ ଟୁଲିଆଇବାକେ ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌କେ ପାଟାଇବି । ");
INSERT INTO dso_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ସେମନ୍‌ ଏ ସବୁ ଲକ୍‌ମନ୍‌କେ ଲାଗି ରଇବା ଜଇଟାନେ ପିଙ୍ଗ୍‌ବାଇ । ତେଇ ସେମନ୍‍ କିଲ୍‌ବିଲ୍‌ ଅଇ କାନ୍ଦ୍‌ବାଇ ଆରି ଦାତ୍‌ କାତ୍‌ରିଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ସେବେଲେ ପର୍‌ମେସର୍‌କେ ମାନ୍‌ବା ଲକ୍‌ମନ୍‌ ତାକର୍‌ ସରଗର୍‌ ବାବାର୍‌ ରାଇଜେ ବେଲ୍‌ପାରା ଜକ୍‌ମକିଜିବାଇ । ସୁନ୍‌ଲା ପାରା କାନ୍‌ ରଇଲେ ସୁନା ।” ");
INSERT INTO dso_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ଦିନେକ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଜମିଟାନେ କୁନି ନେଉନେଉ ତପିଅଇରଇଲା ଦନ୍‌ ମିଲାଇଲା । ସେଟା ସେ ଗୁଡାଇପାକାଇଲା ଆରି ସାର୍‌ଦା ସଙ୍ଗ୍‌ ନିଜର୍‌ ସବୁ ଦନ୍‌ ବିକି ଦେଇ, ସେ ଜମି ଗେନ୍‌ଲା । ସରଗ୍‌ ରାଇଜ୍‌ ମିସା ଏନ୍ତାରି ତପିଅଇରଇବା ଦନ୍‌ ପାରା ।” ");
INSERT INTO dso_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ଆରି ସରଗ୍‌ ରାଇଜ୍‌ ଏନ୍ତାରି, ଗଟେକ୍‌ ସୁନାରି ବେସି ମୁଲିଅର୍‌ ମୁକ୍‌ତା କଜି କଜି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ଗଟେକ୍‌ ବେସି ମୁଲିଅର୍‌ ମୁକ୍‌ତା ରଇଲାଟା ସୁନି, ସେ ତାର୍‌ ସବୁ ଦନ୍‌ ସଁପତି ବିକି ସେଟା ଗେନ୍‌ଲା । ସରଗ୍‌ ରାଇଜ୍‌ ମିସା ସେ ମୁକ୍‌ତା ପାରା । ");
INSERT INTO dso_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ସରଗ୍‌ ରାଇଜ୍‌ ଗଟେକ୍‌ ମାଚ୍‌ ଦାର୍‌ବା ଜାଲ୍‌ ପାରା । କେଉଟ୍‌ମନ୍‌ ଗାଡେ ଜାଲ୍‌ ପାକାଇ ବିନ୍‌ବିନ୍‌ ରକାମର୍‌ ମାଚ୍‌ ଦାର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","“ଜାଲ୍‌ ବର୍‌ତି ଅଇଗାଲେ କଣ୍ଡିତେଇ ଜିକିଆନି ନିକନିକ ମାଚ୍‌ ବାଚି କରି ମୁର୍‌ଡିତେଇ ସଙ୍ଗଇବାଇ ଆରି ବେଙ୍ଗ୍‍ଟିମାଚ୍‌ ପାରାଟାମନ୍‌ ପିଙ୍ଗି ଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଜୁଗ୍‌ ସାର୍‌ବା ବେଲେ ଏନ୍ତାରି ଅଇସି । ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌ ଦରମ୍‌ ଲକର୍‌ ଟାନେଅନି ପାପିମନ୍‌କେ ବେଗ୍‍ଲାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ସେମନ୍‌କେ ଲାଗ୍‌ବା ଜଇଟାନେ ପିଙ୍ଗିଦେବାଇ । ତେଇ ସେମନ୍‌ ମାରିଚପିଅଇ କାନ୍ଦି କସ୍‌ଟେ ମସ୍‌ଟେ ଦାତ୍‌ କାତ୍‌ରିଅଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଜିସୁ ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ଏ ସବୁ ବିସଇ ବୁଜି ପାର୍‌ଲାସ୍‌ନି କି ?” ସେମନ୍‌ “ଉଁ ମାପ୍‌ରୁ ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଜେନ୍ତାର୍‌କି ଗଟେକ୍‌ ଗରର୍‌ ଲକ୍‌, ତାର୍‌ ବାଣ୍ଡାର୍‌ ଗରେଅନି ତାକେ ଦର୍‌କାର୍‌ ଅଇବା ଇସାବେ ନୁଆ ଦିନ୍‌ସୁ ଆରି ପୁର୍‌ନା ଦିନ୍‌ସୁ ବାର୍‌କରାଇସି । ସରଗ୍‌ ରାଇଜେ ସିସ୍‌ ଅଇରଇବା ଗଟେକ୍‌ ଦରମ୍‌ ଗୁରୁ ସମାନ୍‌ ସେନ୍ତାରିସେ କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ଜିସୁ ଏ ଉଦାଅରଣ୍‌ କଇସାରାଇ, ସେ ଜାଗା ଚାଡି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ଆରି ନିଜର୍‌ ଜାଗାଇ ବାଅଡ୍‌ଲା । ସେ ଜାଗାର୍‌ ପାର୍‌ତନା ଗରେ ତାର୍‍ ସିକାଇବାଟା ସୁନି ଲକ୍‌ମନ୍‌ କାବା ଅଇଜାଇ କଇଲାଇ, “ଏତେକ୍‌ ଗିଆନ୍‌ ଏ କନ୍ତିଅନି ମିଲାଇଲା ? ଏ କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ କର୍‌ବାକେ ଆକେ କେ ବପୁ ଦେଲା ? ");
INSERT INTO dso_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ଏ କାଇ ସେ ବାଡଇର୍‌ ପିଲା ! ମରିୟମ୍‌ ତାର୍‌ ମାଆ ! ଜାକୁବ୍‌, ଜସେପ୍‌, ସିମନ୍‌ ଆରି ଜିଉଦା ତାର୍‌ ବାଇମନ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ତାର୍‌ ବଇନିମନ୍‌ ଇତି ଆଚତ୍‍ ! ତେବେ ଏ ସବୁ ବପୁ ସେ କନ୍ତିଅନି ମିଲାଇଲା ?” ");
INSERT INTO dso_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ଏନ୍ତାରି କଇ, ସେମନ୍‌ ଜିସୁକେ ନାମତ୍‌ ନାଇ । ଜିସୁ ସେମନ୍‌କେ କଇଲା “ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ନିଜର୍‌ ଗରେ ଆରି ଗାଏଁ ଚାଡିଦେଲେ, ସବୁଟାନେ ବଲ୍‌ ବଲାଇଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","କାଇକେବଇଲେ ସେମନ୍‌ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇଜେ ସେ ତେଇ ଆରି ଅଦିକ୍‌ କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ କରେ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ସେବେଲେ ଗାଲିଲି ଦେସର୍‌ ସାସନ୍‌ କାରିଆ ଏରଦ୍‌, ଜିସୁର୍‌ ବିସଇ ସୁନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ସେ ତାର୍‌ଟାନେ କାମ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ସତଇସେ ଏ ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ସେ । ସେ ଆରିତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟି ବାଉଡି ଆଇଲାଆଚେ । ସେଟାର୍‌ପାଇ ତାର୍‌ଟାନେ କାବା ଅଇଜିବା କାମ୍‌ କର୍‌ବା ବପୁ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ଆର୍‌ ଆଗ୍‌ତୁ ଏରଦ୍‌ ଜଅନ୍‌କେ ବାନ୍ଦ୍‌ବାକେ ଆଦେସ୍‌ ଦେଇରଇଲା ଆରି ତାକେ ସିକିଲି ସଙ୍ଗ୍‌ ବାନ୍ଦି, ବନ୍ଦି ଗରେ ସଙ୍ଗଇରଇଲା । ତାର୍‌ ବାଇ, ପିଲିପର୍‌ ମାଇଜି ଏରଦିଆର୍‌ ଲାଗି, ସେ ଏନ୍ତି କରିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ଜଅନ୍‌ ତାକେ କଇରଇଲା “ତମର୍‌ ବଉ ଏରଦିଆକେ ବିବା ଅଇବାଟା ତମର୍‌ ଟିକ୍ ଅଏନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ସେଟାର୍‌ପାଇ ଏରଦ୍‌ ଜଅନ୍‌କେ ମରାଇବାକେ ଜଜ୍‌ନା କର୍‌ତେରଇଲା, ମାତର୍‌ ସେ ଜିଉଦି ଲକ୍‌ମନ୍‌କେ ଡର୍‌ତେରଇଲା । କାଇକେବଇଲେ ଜିଉଦି ଲକ୍‌ମନ୍‌ ଜଅନ୍ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ବଲି ମାନ୍‍ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ମାତର୍‌ ଏରଦର୍‌ ଜନମ୍‌ ପୁର୍‌ତି ଦିନେ ଏରଦିଆର୍‌ ଟକି, ଡାକାଇରଇବା ଲକ୍‌ମନର୍‌ ମୁଆଟେ ନାଟ୍‌ କରିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ଏରଦ୍‌ ତାର୍‌ ଉପ୍‌ରେ ଏତେକ୍‌ ସାର୍‌ଦା ଅଇଲାଜେ, ସାର୍‌ଦା ଅଇ ପର୍‌ମାନ୍‌ ନିୟମ୍‌ କରି କଇଲା “ତୁଇ ଜାଇଟା ମାଙ୍ଗ୍‌ଲେ, ସେଟା ଦେବି !” ");
INSERT INTO dso_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ତାର୍‌ ଆୟାର୍‌ କାତା ଦାରି ଟକି କଇଲା “ମକେ ଏବେଆକା ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ମୁଣ୍ଡ୍‌ ଗଟେକ୍‌ ତାଲାଇ ସଙ୍ଗଇ କରି ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ଏଟା ସୁନିକରି ରାଜା ଦୁକ୍‌ ଅଇଗାଲା । ଏଲେମିସା ସବୁର୍‌ ମୁଆଟେ ନିଜେ ପର୍‌ମାନ୍‌ ନିୟମ୍‌ କରିରଇଲାଜେ ଟକିର୍‌ ମନ୍‌ କରିରଇବାଟା ପୁରୁନ୍‌ କର୍‌ବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ସେଟାର୍‌ପାଇ ବନ୍ଦି ଗରେ ଜଅନର୍‌ ମୁଣ୍ଡ୍‌ କାଟା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ଗଟେକ୍‌ ତାଲାଟାନେ ମୁଣ୍ଡ୍‌ ସଙ୍ଗଇ ଟକିକେ ଦେଲାଇ । ସେ ସେଟା ନେଇକରି ତାର୍‌ ମାକେ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ତାର୍‌ପଚେ ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ଆସି ମଲା ଗାଗଡ୍‌ ନେଇ ତପ୍‌ବାକେ ଦାରିଗାଲାଇ । ସେମନ୍‌ ଜାଇକରି ଜିସୁକେ ଏ ବିସଇ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ଜିସୁ ଜଅନର୍‌ କବର୍‌ ସୁନ୍‌ଲା ଦାପ୍‌ରେ ଡଙ୍ଗାଇ ଚଗ୍‌ଲା ଆରି ଗଟେକ୍‌ କିନରା ଜାଗାଇ ଗାଲା । ତେଇ ସେ ଜିବାଟା ଜାନିକରି ଲଗର୍‌ ପାକର୍‌ ସଅରେ ଅନି କେତେକ୍‌ କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ଗାଡ୍‌ କଣ୍ଡିକଣ୍ଡି ଇଣ୍ଡି ଜିସୁର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ଜେଡେବେଲେ ଜିସୁ ଡଙ୍ଗାଇଅନି ଉତ୍‌ରି ଏତେକ୍‌ମାଣ୍ଡ୍‌ ଲକ୍‌ମନ୍‌କେ ଦେକ୍‌ଲା, ସେ ଦୟା କଲା । ତେଇ ଜେତ୍‌କି ରଗିମନ୍‌ ରଇଲାଇ, ସବୁକେ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ସେଦିନେ ସଞ୍ଜ୍‌ବେଲାଇ, ସିସ୍‌ମନ୍‌ ଆସି ତାକେ କଇଲାଇ, “ବେସି ଅଲ୍‌ସମ୍‌ ଅଇଗାଲାନି । ଆରି ଏଟା ଗଟେକ୍‍ କିନରା ଜାଗା, ଲକ୍‌ମନ୍‌କେ କଇଦିଆସ୍‌, ସେମନ୍‌ ଗାଉଁମନ୍‌କେ ଜାଇ କାଦି ମିଲାଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ସେମନ୍‌ ଇତିଅନି ନ ଜାଅତ୍‍ । ତମେ ସେମନ୍‌କେ କାଇଟାଆଲେ କାଇବାକେ ଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ସିସ୍‌ମନ୍‌ କଇଲାଇ, “ଆମର୍‌ ଟାନେ ଏକାଇ ପାଁଚ୍‌ଟା ରୁଟି ଆରି ଦୁଇଟା ମାଚ୍‌ସେ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ଜିସୁ କଇଲା, “ସେଟା ମର୍‌ଟାନେ ଦାରିଆସା ।” ");
INSERT INTO dso_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ଜିସୁ ସବୁଲକ୍‌କେ ଗାଁସ୍‌ ଉପ୍‌ରେ ବସାଇବାକେ କଇଲା । ସେ ପାଁଚ୍‌ଟା ରୁଟି ଆରି ଦୁଇଟା ମାଚ୍‌ ଦାରି ସରଗ୍‌ବାଟେ ଦେକି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲା, ଆରି ରୁଟି ବାଙ୍ଗାଇ କରି ସିସ୍‌ମନ୍‍କେ ଦେଲା । ସିସ୍‌ମନ୍‌ ସବୁଲକ୍‌କେ ବାଟାକରି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ସେଟା ସବୁଲକ୍‌ କାଇକରି ସାନ୍ତି ଅଇଲାଇ । ତାର୍‌ପଚେ ସିସ୍‌ମନ୍‌ ଅଗ୍‌ଲି ରଇବା ରୁଟି ଆରି ମାଚ୍‌ ଟୁଲିଆଇ ବାର୍‌ଟା ଡାଲାଇ ବର୍‌ତି କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ତେଇ ମାଇଜିମନ୍‌ ଆରି ପିଲାମନ୍‌କେ ଚାଡି, ସେ କାଦି ପାଁଚ୍‌ ଅଜାର୍‌ ଲକ୍‌ କାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ତାର୍‌ପଚେ ଜିସୁ ସିସ୍‌ମନ୍‌କେ ଡଙ୍ଗାଇ ବସାଇ ଗାଡ୍‌ ସେପାଟେ ଜିବାକେ କଇଲା । ସେ ନିଜେ ପଚେ ରଇଜାଇକରି ଲକ୍‌ମନ୍‌କେ ପାଟାଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ସେ ଏକ୍‌ଲାସେ ପାର୍‌ତନା କର୍‌ବାକେ ଗଟେକ୍‌ ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ଗାଲା ଆରି ସଞ୍ଜ୍‌ ଅଇବା ଜାକ ଜିସୁ ଗଟେକ୍‌ ଲକ୍‌ସେ ତେଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ସେଡ୍‌କି ବେଲେ ଡଙ୍ଗା କଣ୍ଡିଅନି ବେସି ଦୁର୍‌ ଗାଡ୍‌ ବିତ୍‌ରେ ଉଟିଜାଇରଇଲା । ଆରି ଜବର୍‌ ପବନ୍‌ କଲାଜେ, ଲଅଡି ଟଲ୍‌ମଲି ଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","କୁକ୍‌ଡା ଡାକେ, ଏଦେ ଦେକା ! ଜିସୁ ପାନି ଉପ୍‌ରେ ଇଣ୍ଡି ଇଣ୍ଡି ସିସ୍‌ମନର୍‌ ଲଗେ ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ସିସ୍‌ମନ୍‌ ତାକେ ଦେକି କିଲ୍‌ବିଲ୍‌ ଅଇଗାଲାଇ । ଡରର୍‌ମାଡେ ଡୁମା ବଲି କିର୍‌କିର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ସେ ଦାପ୍‍ରେସେ ଜିସୁ ସେମନ୍‌କେ ସାଆସ୍‌ ଦେଇ କଇଲା, “ମୁଇ କାଇକି, ଡରାନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ଜିସୁର୍‌ ଏ କାତା ସୁନି ପିତର୍‌ କଇଲା, “ମାପ୍‌ରୁ ଜଦି ସତଇସେ ତମେ ଅଇରଇସା ବଇଲେ, ମକେ ପାନି ଉପ୍‌ରେ ଇଣ୍ଡି ଇଣ୍ଡି ତମର୍‌ ଲଗେ ଆଇବାକେ ଆଦେସ୍‌ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ଜିସୁ କଇଲା, “ଇଣ୍ଡି ଇଣ୍ଡି ଆଉ ।” ପିତର୍‌ ଡଙ୍ଗାଇଅନି ବାରଇ, ପାନି ଉପ୍‌ରେ ଇଣ୍ଡି ଇଣ୍ଡି ଜିସୁର୍‌ ବାଟେ ଆଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ମାତର୍‌ ପବନ୍‌ ଜବର୍‌ ଆଇବାଟା ଦେକିକରି ଡରିଗାଲା ଆରି ପାନିଟାନେ ବୁଡିଜିବାର୍‌ ଦାର୍‌ଲା । ତେବେ ଆକ୍‌ମାରି କରି ଡାକ୍‌ଲା ଏ ମାପ୍‌ରୁ ମକେ ରକିଆ କର୍‍ ! ");
INSERT INTO dso_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ଜିସୁ ସେ ଦାପ୍‌ରେ, ଆତ୍‌ ଲାମାଇକରି ତାକେ ଦାରିକରି କଇଲା, “ଏ ଅଲପ୍‌ ବିସ୍‌ବାସ୍‌ କରୁ, କାଇକେ ଦୁଇମନିଆ ଅଇଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ମାତର୍‌ ସେମନ୍‌ ଡଙ୍ଗାଇ ଚଗ୍‌ଲାକେ ପବନ୍‌ ବନ୍ଦ୍‌ଅଇ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ଡଙ୍ଗାଇ ରଇଲା ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଜୁଆର୍‌ କରି କଇଲାଇ, “ତମେ ସତ୍‌ସେ ମାପ୍‌ରୁର୍‌ ପିଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଗାଡ୍‌ଲଙ୍ଗିକରି ଗିନେସରତ୍‌ ଜାଗାଇ କେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଆରି ତେଇର୍‌ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଚିନିକରି ଲଗେ ପାକେ ରଇବା ଚାରିବେଡ୍‌ତିର୍‌ ସବୁ ଜାଗାଇ କବର୍‌ ପାଟାଇଲାଇ ଆରି ରଗି ଲକ୍‌ମନ୍‌କେ ତାର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ରଗିମନ୍‌ ଜିସୁର୍‌ ପିନ୍ଦ୍‌ଲା ଲୁଗାର୍‌ ଜାଲି ଚିଇବାକେ, ଆଦେସ୍‌ ଦେବାକେ, ଲକ୍‌ମନ୍‌ ତାକେ ବାବୁଜିଆକରି କଇଲାଇ । ମାତର୍‌ ଜେତେକ୍‌ଲକ୍‌ ସେଟା ଚିଇଲାଇ, ସବୁଲକ୍‌ ନିକଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ଦିନେକ୍‌ କେତେଟା ପାରୁସିମନ୍‌ ଆରି ଦରମ୍‌ ଗୁରୁମନ୍‌ ଜିରୁସାଲାମ୍‌ ଅନି ଆସି ଜିସୁକେ ପାଚାର୍‌ଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ଆମର୍‌ ଆନିଦାଦିମନ୍‌ ଜନ୍‌ ରିତିନିତି ଦେଇଆଚତ୍‌, ସେଟା ସବୁ କାଇକେ ତମର୍‌ ସିସ୍‌ମନ୍‌ ମାନତ୍‌ନାଇ ? ବିଦି ଇସାବେ କାଇବା ଆଗ୍‌ତୁ ନିକ କରି ଆତ୍‌ ନ ଦଅତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ଜିସୁ କଇଲା, “ତମେ କାଇକେ ପର୍‌ମେସରର୍‌ ଆଦେସ୍‌ ନ ମାନି ନିଜର୍‌ ରିତିନିତି ଇସାବେ କାମ୍‌ କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ପର୍‌ମେସର୍‌ ଆଦେସ୍‌ ଦେଲାଆଚେ, ମା ବାବାକେ ଆଲାଦ୍‌କରା । ଆରି କେ ମିସା ନିଜର୍‌ ବାବା ମାକେ ସାଇପ୍‌ ଦେଇକରି କାଇବଲି କଇସି ବଇଲେ, ସେ ମରନର୍‌ ଡଣ୍ଡ୍‌ ପାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ମାତର୍‌ ତମେ ସିକିଆ ଦେଲାସ୍‌ନି ଜେ, ଗଟେକ୍‌ ଲକ୍‌ ଜନ୍‌ ଦନ୍‌ ସଙ୍ଗ୍‌ ବାବା ମାକେ ସାଇଜ କରିପାର୍‌ତା, ସେଟା ପର୍‌ମେସର୍‌କେ ଦାନ୍‌ କଲିଆଚି ବଲି କଇଲେ, ");
INSERT INTO dso_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“ସେ ଆରି ତାର୍‌ ବାବା ମାଆର୍‌ ଦାଇତ୍‌ ନେବାର୍‌ ଲଡାନାଇ । ଏନ୍ତାରି ତମେ ପର୍‌ମେସରର୍‌ ଆଦେସ୍‌ ନ ମାନିକରି ନିଜର୍‌ ରିତିନିତି ଇସାବେ ଚାଲ୍‌ଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ଏରେ ଦରମ୍‌ ଲକ୍‌ ବଲାଇଅଇବା କୁଟିଆଲ୍‌ମନ୍‌, ତମର୍‌ ବିସଇ ନେଇ ଜିସାଇୟ ବବିସତ୍‌ବକ୍‌ତା କଇରଇବାଟା ଟିକ୍ ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ପର୍‌ମେସର୍‌ କଇଲାନି, ଏ ଲକ୍‌ମନ୍‌ କାତାଇସେ ମକେ ସନ୍‌ମାନ୍‌ ଦେଲାଇନି, ମାତର୍‌ ସେମନର୍‌ ମନ୍‌ ମର୍‌ତେଇଅନି ବେସି ଦୁରିକେ । ");
INSERT INTO dso_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ସେମନ୍‌ ମକେ ଡାକ୍‌ବାଟାନେ କାଇ ଅରତ୍‌ ନାଇ, କାଇକେ ବଇଲେ ସେମନ୍‌ ଲକ୍‌ମନ୍‌ ତିଆର୍‌କରି ରଇବା ରିତିନିତି ମର୍‌ ଆଦେସ୍‌ ବଲି ସିକାଇଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ତାର୍‌ପଚେ ଲକ୍‌ମନ୍‌କେ କଇଲା, “ମନ୍‌ ଦେଇ ସୁନା ଆରି ବୁଜ୍‌ବାକେ ଚେସ୍‌ଟା କରା । ");
INSERT INTO dso_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ଲକର୍‌ ଟଣ୍ଡେଅନି ଜାଇଟା ବିତ୍‌ରେ ଗାଲାନି, ସେଟା ତାକେ ଅସୁକଲ୍‌ ନ କରେ, ମାତର୍‌ ଜାଇଟା, ତାର୍‌ ବିତ୍‌ରେଅନି ବାରଇଆଇସି, ସେଟା ତାକେ ଅସୁକଲ୍‌ କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ସିସ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ପାଚାର୍‌ଲାଇ, “ତମେ କଇଲା କାତା ପାରୁସିମନ୍‌କେ ବେସି ବାଦ୍‌ଲା, ଏଟା କାଇ ତମେ ନାଜାନାସ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ଜିସୁ କଇଲା, “ଜନ୍‌ ଗଚ୍‌ମନ୍‌ ମର୍‌ ସରଗର୍‌ ବାବା ରପେ ନାଇ, ସେ ସବୁ ଜିକା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ସେମନର୍‌ ବିସଇନେଇ ତେରେପେତେ ଉଆନାଇ । ସେମନ୍‌ କାଣାମନ୍‌କେ ବାଟ୍‌ ଦେକାଉ କାଣାମନ୍‌ । ଗଟେକ୍‌ କାଣା ଆରି ଗଟେକ୍‌ କାଣାକେ ବାଟ୍‍ଦେକାଇଲେ ଦୁଇ ଲକ୍‌ ଜାକ କାଲେ ଅଦର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ପିତର୍‌ କଇଲା, “ଏ କାତା ଆମ୍‍କେ ନିକ କରି ବୁଜାଇଦେ ।” ");
INSERT INTO dso_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଜିସୁ କଇଲା, “ଆଜିକେ ଜାକ ବିନ୍‌ଲକ୍‌ମନର୍‌ତେଇ ଅନି ତମର୍‌ ବୁଜ୍‌ବା ବପୁ କଣ୍ଡେକ୍‌ ମିସା ଅଦିକ୍‌ ଅଏନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ତମେ ଏତ୍‌କି ବୁଜାସ୍‌ ନାଇ କି ? ଜନ୍‌ ଦିନ୍‌ସୁ ମୁନୁସର୍‌ ଟଣ୍ଡ୍‌ବାଟେ ପୁର୍‌ସି, ସେଟା ପେଟ୍‌ ବିତ୍‌ରେ ଜାଇସି ଆରି ଗାଗ୍‌ଡେଅନି ବାରଇ ଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ମାତର୍‌ ଜନ୍‌ଟା ସବୁ ମୁନୁସର୍‌ ଟଣ୍ଡେଅନି ବାରଇସି, ସେଟା ତାର୍‌ ମନ୍‌ବିତ୍‌ରେଅନି ଜନମ୍‌ ଅଇସି ଆରି ସେଟାସେ ତାକେ ଅସୁଚି କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","କାଇକେବଇଲେ ତାର୍‌ ମନେ ଜନମ୍‌ ଅଇଲା କାରାପ୍‌ ଚିନ୍ତାଇଅନି ସେ ନର୍‌ମାର୍‌ବାଟା, କାରାପ୍‌ କାମ୍‌ କର୍‌ବାଟା, ବେସିଆ କାମ୍‌ କର୍‌ବାଟା, ଚର୍‌ବାଟା, ମିଚ୍‌କାତା କଇବାଟା ଆରି ବିନ୍‌ଲକର୍‌ କୁଟ୍‌କାତା କଇବା ପାରା, ବିନ୍‌ ବିନ୍‌ ରକାମର୍‌ ନିୟମ୍‌ ନଇଲା କାମ୍‌ମନ୍‌ କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","“ଏସବୁ କାମ୍‌ ଲକ୍‌କେ ଅସୁକଲ୍‌ କର୍‌ସି । ମାତର୍‌ ସେମନ୍‌ କଇଲା ଇସାବେ ଆତ୍‌ ନ ଦଇକରି କାଇଲେ, କେ ଅସୁକଲ୍‌ ନଅଅତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଜିସୁ ସେ ଜାଗା ଚାଡିକରି ସର ଆରି ସିଦନର୍‌ ସଅରେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଆରି ଦେକା, ତେଇ ବାସାକରି ରଇଲା ଗଟେକ୍‌ କିଣାନିୟ ମାଇଜି ଜିସୁର୍‌ ଲଗେ ଆସି କଇଲା, “ଏ ଦାଉଦ୍‌ କୁଟୁମର୍‌ ମାପ୍‌ରୁ, ମକେ ଦୟାକରା । ମର୍‌ ଟକିକେ ଡୁମା ଦାର୍‌ଲା ଆଚେ ଆରି ସେ ବଡେ କସ୍‌ଟ ପାଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ମାତର୍‌ ଜିସୁ ତାକେ ପଦେକ୍‌ କାତା ମିସା କଏ ନାଇ । ସିସ୍‌ମନ୍‌ ତାର୍‌ ଲଗେ ଆସି ବାବୁଜିଆ କଲାଇ, “ତାକେ ବିଗି ପାଟାଇ ଦିଆସ୍‌ । ଦେକା ସେ କେନ୍ତି ଆଉଲିଅଇ ଆମ୍‌କେ କେଦିଆନ୍‌ଲାନି ?” ");
INSERT INTO dso_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ଜିସୁ କଇଲା, “ଆଜିରଇବା ମେଣ୍ଡାପାରା ବାଟ୍‌ ବାନା ଅଇଲା ଇସ୍‌ରାଏଲ୍‌ ଲକ୍‌ମନର୍‌ ଲଗେସେ ମୁଇ ଆଇଲି ଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ସେ ମାଇଜି ଆସି ଜିସୁର୍‌ ଗଡ୍‌ତଲେ ମାଣ୍ଡିକୁଟା ଦେଇ ଜୁଆର୍‌ କରି କଇଲା, “ମାପ୍‌ରୁ ମକେ ଦୟା କରା ।” ");
INSERT INTO dso_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ଜିସୁ କଇଲା, “ପିଲାମନର୍‌ କାଦି ନେଇ କୁକୁରର୍‌ ମୁଆଟେ ପିଙ୍ଗ୍‌ବାଟା ଟିକ୍ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ସେ ମାଇଜି କଇଲା, ଏଟା ସତ୍‌ କାତା ମାପ୍‌ରୁ, ମାତର୍‌ କୁକୁର୍‌ମନ୍‌ ମିସା ସାଉକାରର୍‌ ଅଦର୍‌ଲା ସକ୍‌ଡି କାଇବାକେ ପାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ଜିସୁ ତାକେ କଇଲା, “ତମେ ଗଟେକ୍‌ ଡାଟ୍‌ସଙ୍ଗ୍‍ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ମାଇଜି । ତୁଇ ମନ୍‍କଲାଟା ପୁରୁନ୍‌ ଅଇସି ।” ସେଦାପ୍‌ରେ ତାର୍‌ ଟକି ନିମାନ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଜିସୁ ତେଇଅନି ବାରଇ ଗାଡ୍‌ କଣ୍ଡି କଣ୍ଡି ଜାଇ ଗଟେକ୍‌ ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ବେସି ଲକ୍‌ମନ୍‌ ତାର୍‌ ଲଗେ ରୁଣ୍ଡ୍‌ଲାଇ । ସେମନର୍‌ ବିତ୍‌ରେ ଚଟା, କାଣା, ଆତ୍‌ଗଡ୍‌ ସୁକିଗାଲାଟା ଆରି ବେସି ଜରର୍‌ ଲକ୍‌ମନ୍‌କେ ଆନି, ଜିସୁର୍‌ ପାଦ୍‌ ତଲେ ଡୁଲାଇଲାଇ । ଆରି ସେ ସେମନ୍‌କେ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଗୁଲା କାତା ଅଇବାଟା, ସୁକ୍‌ଲା ଆତ୍‌ ନିକ ଅଇବାଟା, ଚଟା ଇଣ୍ଡ୍‌ବାଟା, କାଣା ଦେକିପାର୍‌ବାଟା ଦେକି ଲକ୍‌ମନ୍‌ କାବା ଅଇଗାଲାଇ ଆରି ଇସ୍‌ରାଏଲର୍‌ ମାପ୍‌ରୁକେ ଜୁଆର୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଜିସୁ ସିସ୍‌ମନ୍‌କେ ଡାକି କଇଲା, “ଏ ଲକ୍‌ମନ୍‌କେ ଦେକି ମକେ ଦୁକ୍‌ ଲାଗ୍‌ଲାନି, କାଇକେ ବଇଲେ ସେମନ୍‌ ମର୍‌ ସଙ୍ଗ୍‌ ତିନ୍‌ ଦିନ୍‌ ଅଇଲାନି ଆଚତ୍‌ ଆରି ସେମନର୍‌ ଲଗେ କାଇଟା ମିସା ନାଇ । ସେମନ୍‌ ନ କାଇ ଇତିଅନି ଉଟିଜାଅତ୍‌, ଏଟା ମୁଇ ମନ୍‍ କରି ନାଇ; କାଇକେ ବଇଲେ ବାଉଡିଗାଲାବେଲେ ବାଟେ ସେମନ୍‌ ତାକି ଜାଇ ଅଦର୍‌ ପଡ୍‌ ଅଇଜିବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ସିସ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ଏ ମରୁବାଲିବୁଏଁ ଏତେକ୍‌ ଲକ୍‌କେ କୁଆଇବାକେ ଆମେ କନ୍ତିଅନି ଏତେକ୍‌ମାଣ୍ଡ୍‌ କାଦି ଆନ୍‌ବୁ ?” ");
INSERT INTO dso_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଜିସୁ ପାଚାର୍‌ଲା, “ତମର୍‌ ଲଗେ କେତେଟା ରୁଟି ଆଚେ ?” ସେମନ୍‌ କଇଲାଇ, “ସାତ୍‌ଟା ରୁଟି ଆରି କେତେଟା ସାନ୍‌ ମାଚ୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ଜିସୁ ଲକ୍‌ମନ୍‌କେ ବୁଏଁ ବସ୍‌ବାକେ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ତାର୍‌ପଚେ ସେ ସାତ୍‌ଟା ରୁଟି ଆରି ମାଚ୍‌ ନେଇ ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲା ଆରି ବାଙ୍ଗାଇ କରି ସିସ୍‌ମନ୍‌କେ ଦେଲା । ସିସ୍‌ମନ୍‌ ସେଟା ଲକ୍‌ମନ୍‌କେ ବାଟାକରି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ସବୁ ଲକ୍‌ ପେଟ୍‍ପୁର୍‌ତେ କାଇଲାଇ । ଆରି ସିସ୍‌ମନ୍‌ ଅଗଲ୍‌ଲାଟା ସାତ୍‌ଟାଡାଲାଇ ବର୍‌ତି କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ମାଇଜିଟକି ଆରି ପିଲାମନ୍‌କେ ଚାଡି ଚାରି ଅଜାର୍‌ ଲକ୍‌ ଏ କାଦି କାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ଏଟାର୍‌ ପଚେ ଜିସୁ ଲକ୍‌ମନ୍‌କେ ପାଟାଇ ଦେଇ ଡଙ୍ଗାଇ ଚଗି ମଗ୍‌ଦାନ୍‌ ଜାଗାର୍‌ ସନ୍ଦିଲଗେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ଦିନେକ୍‌ କେତେଟା ପାରୁସିମନ୍‌ ଆରି ସାଦୁକିମନ୍‌ ଜିସୁର୍‌ ଦସ୍‌ ଦାର୍‌ବାକେ ତାର୍‌ ଲଗେ ଆଇଲାଇ । ସେମନ୍‌ ତାକେ କଇଲାଇ, “ପର୍‌ମେସର୍‌ ତକେ ବାଚ୍‌ଲା ଆଚେ ବଲି ଆମେ ଜାନ୍‌ବାକେ, ତୁଇ ଗଟେକ୍‌ ସରଗର୍‌ କାବାଅଇଜିବା ଚିନ୍‌ ଦେକା ।” ");
INSERT INTO dso_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ଜିସୁ କଇଲା, “ତମେ ସଞ୍ଜ୍‌ ବେଲାଇ ବାଦଲ୍‌ ରଙ୍ଗ୍‌ ଡିସ୍‌ଲେ ପାଗ୍‌ ବଲ୍‌ ଅଇସି ବଲି କଇସା, ");
INSERT INTO dso_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ଆରି ସାକାଲ୍‌ ବେଲାଇ ରଙ୍ଗ୍‌ ଆରି ଆନ୍ଦାର୍‌ ଡିସ୍‌ଲେ ପାନି ମାର୍‌ସି ବଲି ଜାନାସ୍‌ । ବାଦଲ୍‌ ଦେକି ପାଗର୍‌ କାତା ଆଗ୍‌ତୁ ଜାନ୍‌ସା । ମାତର୍‌ ଆଜିକାଲିର୍‌ ଡିସ୍‍ବା ଚିନ୍‌ ତମେ ବୁଜିନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ଏ ଜୁଗର୍‌ ଲକ୍‌ମନ୍‌ କେଡେ କାରାପ୍‌ ଆରି ପରମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ ନ କରୁମନ୍‌ ! ତମେ ଗଟେକ୍‌ କାବାଅଇଜିବା କାମ୍‌ ଦେକ୍‍ବାକେ କଇଲାସ୍‌ନି ? ମାତର୍‌ ନାଇ, ଜୁନସର୍‌ ଜିବନେ ଗଟ୍‌ଲାଟା ଚାଡି ଆରି ଗଟେକ୍‌ ମିସା କାବାଅଇଜିବା କାମ୍‌, ତମେ ମର୍‌ତେଇ ଦେକିନାପାରାସ୍‌ ।” ଏଟା କଇ ଜିସୁ ସେମନ୍‌କେ ଚାଡି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ସିସ୍‌ମନ୍‌ ଗାଡ୍‌ ସେପାଟେ ଜିବାବେଲେ ରୁଟି ନେବାକେ ପାସ୍‌ରି ଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଜାଗ୍‌ରତ୍‌, ପାରୁସି ଆରି ସାଦୁକିମନର୍‌ କମିର୍‌ତେଇଅନି ତରିକ୍‌ନା ଅଇ ରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କୁଆ ବଲା ଅଇଲାଇ, “ଆମେ ରୁଟି ଆନି ନ ରଇଲାର୍‌ ପାଇ ସେ ଏନ୍ତାରି କଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ସେମନ୍‌ କାଇଟା କଇତେ ରଇଲାଇ ସେଟା ଜାନି ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମର୍‌ ଲଗେ ରୁଟି ନାଇ ବଲି କାଇକେ କୁଆବଲା ଅଇଲାସ୍‌ନି ? ତମର୍‌ ବିସ୍‌ବାସ୍‌ କେତେ ଦୁର୍‌ବଲ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ଏବେ ଜାକ ତମେ ବୁଜାସ୍‌ ନାଇ କି ? ପାଁଚ୍‌ ଅଜାର୍‌ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ମୁଇ ପାଁଚ୍‌ଟା ରୁଟି ବାଟାକରି ରଇବା କାତା ତମେ କାଇ ପାସ୍‌ରି ଗାଲାସ୍‌ କି ? ସେଡ୍‌କିବେଲେ ତମେ କେତେଟା ଡାଲାଇ ବର୍‌ତି କରି ରଇଲାସ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ଆରି ଚାରି ଅଜାର୍‌ ଲକ୍‌କେ ସାତ୍‌ଟା ରୁଟିର୍‌ କାତା ମନେ ନାଇ କି ? ସେଡ୍‌କିବେଲେ କେତେ ଡାଲା ବର୍‌ତି କରି ରଇଲାସ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“ମୁଇ ରୁଟିର୍‍ ବିସଇ ନ କଇତେ ରଇଲି, ତମେ କେନ୍ତି ବୁଜାସ୍‌ ନାଇ ? ମୁଇ କଇଲିନି, ପାରୁସି ଆରି ସାଦୁକିମନର୍‌ କମିର୍‌ ପାରା ସିକିଆ ତେଇଅନି ତରିକ୍‌ନା ଅଇ ରୁଆ ବଲି ।” ");
INSERT INTO dso_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ସେଡ୍‌କିବେଲେ ସିସ୍‌ମନ୍‌ ବୁଜି ପାର୍‌ଲାଇ ଜେ, ଜିସୁ ରୁଟିର୍‌ କମିରର୍‌ କାତା ନ କଇତେ ରଇଲା, ମାତର୍‌ ପାରୁସି ଆରି ସାଦୁକିମନର୍‌ ସିକିଆ ତେଇ ତରିକ୍‌ନା ଅଇ ରୁଆ ବଲି କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ଜିସୁ କାଇସେରିଆ ପିଲିପି ଗଡ୍‌ ପାକାପାକି ଜାଗାଇ ଗାଲା ପଚେ ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ନର୍‌ପିଲା କେ ବଲି ଲକ୍‌ମନ୍‌ କାଇଟା କଇଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ସେମନ୍‌ କଇଲାଇ, “କେତେ ଲକ୍‌ କଇଲାଇନି, ସେ ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ । ଆରି କେତେ ଲକ୍‌ ‘ସେ ଏଲିୟ’, ବିନ୍‌ ଲକ୍‌ମନ୍‌ କଇଲାଇନି, ‘ସେ ଜିରିମିୟ ନଇଲେ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ତେଇଅନି ଗଟେକ୍‌ ଲକ୍‌’ ।” ");
INSERT INTO dso_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ଜିସୁ ପାଚାର୍‌ଲା, “ମୁଇ କେ ବଲି ତମେ କାଇଟା ବଇଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ସିମନ୍‌ ପିତର୍‌ କଇଲା, “ତମେ କିରିସ୍‌ଟ, ମସିଅ, ଜିବନ୍‌ ରଇବା ପରମେସରର୍‌ ପିଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ଜିସୁ କଇଲା, “ନିମାନ୍‌, ଜୁନସର୍‌ ପିଲା, ପିତର୍‌ ! ଏଟା ସତ୍‌, ତୁଇ ମୁନୁସର୍‌ଟାନେ ଅନି କଉସ୍‌ ନାଇ । ମର୍‌ ସରଗର୍‌ ବାବା ତକେ ଜାନାଇଲାକେ ତୁଇ କଇଲୁସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ସେଟାର୍‌ପାଇ ମୁଇ ତକେ କଇଲିନି, ତୁଇ ପିତର୍‌, ଜାର୍‌ ଅରତ୍‌ କି ପାକ୍‌ନା । ଏ ପାକ୍‌ନା ଉପ୍‌ରେ ମୁଇ ମର୍‌ ମଣ୍ଡଲି ତିଆର୍‌ କର୍‌ବି । ଜେନ୍ତିକି ମରନ୍‌ ପାରା ବପୁ ମିସା ତାକେ କାଇ କରିନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“ମୁଇ ତକେ ସରଗ୍‌ ରାଇଜର୍‌ କୁଚିକାଡି ଦେବି । ତୁଇ ଜାଇଟା ଜଗତେ ନାଇ ବଲ୍‌ସୁ, ସେଟା ସରଗେ ମିସା ନାଇ ଅଇସି । ତୁଇ ଜଗତେ ଜାଇଟା କରା ବଲି କଇସୁ ସେଟା ସର୍‌ଗେ ମିସା କରାଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ସେ ମସିଅ ବଲି କାକେ ନ କଇବାକେ, ସିସ୍‌ମନ୍‌କେ ଡାଟ୍‌କଲା । ");
INSERT INTO dso_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ସେବେଲେଅନି ଜିସୁ ସିସ୍‌ମନ୍‌କେ ବୁଜ୍‌ଲାପାରା କଇବାର୍‌ ଦାର୍‌ଲା, “ମୁଇ ଜିରୁସାଲାମ୍‌ ଜାଇ ଦରମ୍‌ଗୁରୁମନ୍‌, ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନର୍‌ଟାନେ ବେସି କସ୍‌ଟ ପାଇବି । ସାରାସାରି ମକେ ମରାଇବାଇ, ମାତର୍‌ ତିନ୍‌ ଦିନ୍‌ ଗାଲାପଚେ ମୁଇ ଆରି ତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ପିତର୍‌ ଜିସୁକେ ଅଁତ୍‌ରେ ଡାକିନେଇ ସେନ୍ତି ନ ଅ ବଲି ଦମ୍‌କାଇଲା । “ପର୍‌ମେସର୍‌ ତମ୍‌କେ କାଇଟା ନ କର, ମାପ୍‌ରୁ, ତମ୍‍କେ ଏ ସବୁ କେବେ ମିସା ନଅ ।” ");
INSERT INTO dso_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ଜିସୁ ପାସ୍‌ଲି କରି କଇଲା, “ମର୍‌ ମୁଆଟେଅନି ଦୁରିକେ ଜା ସଇତାନ୍‌ । ତୁଇ ମର୍‌ ବାଟ୍‌ ଚୁଟିଦେଲୁସ୍‌ନି । ମକେ ନିଚୁ ବଲି କଅ ନାଇ । କାଇକେ ବଇଲେ ତମର୍‌ ଚିନ୍ତା ମୁନୁସ୍‌ମନର୍‌ତେଇଅନି, ପର୍‌ମେସରର୍‌ତେଇ ଅନି ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ତାର୍‌ପଚେ ଜିସୁ ସିସ୍‌ମନ୍‌କେ କଇଲା, “କେ ମିସା ମର୍‌ ସଙ୍ଗ୍‍ ଆଇବାକେ ମନ୍‍ କଲେ, ନିଜର୍‌ ମନ୍‍ କଲାଟା ସବୁ ଚାଡିଦେଇ, ନିଜର୍‌ କୁର୍‌ସ ବଇବାକେ ଅଇସି, ଆରି ମର୍‌ ପଚେ ପଚେ ଇଣ୍ଡ୍‌ବାକେ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","କାଇକେ ବଇଲେ କେ ମିସା ନିଜର୍‌ ଜିବନ୍‌ ରକିଆ କର୍‌ବାକେ ମନ୍‍ କର୍‌ସି ବଇଲେ, ସେଟା ସେ ଆରାଇସି, ମାତର୍‌ ଜେ ମର୍‌ ଲାଗି ଜିବନ୍‌ ଦେଇସି, ସେ ସତଇସେ ସେଟା ରକିଆ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ଜଦି ଗଟେକ୍‌ ଲକ୍‌, ଗୁଲାଇ ଜଗତ୍‌ ଜିତିକରି ନିଜର୍‌ ଜିବନ୍‌ ଆରାଇଦେଇସି ବଇଲେ ସେଟା କାଇ ଲାବ୍‌ ? ଜିବନ୍‌ ବାଉଡାଇ ପାଇବାକେ ଆଲେ ସେ କାଇଟା ମିସା ଦେଇ ନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ନର୍‌ପିଲା ମୁଇ ବାବା ପର୍‌ମେସରର୍‌ ଡାକ୍‌ପୁଟା ପାଇ ସରଗ୍‌ ଦୁତ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଆରି ତରେକ୍‌ ଆଇବି । ସେଡ୍‌କି ବେଲେ ମୁଇ ସବୁ ଲକର୍‌ କରିରଇବା କାମ୍‌ ଦେକି ପୁରୁସ୍‌କାର୍‌ ଦେବି । ");
INSERT INTO dso_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ନର୍‌ପିଲା ମୁଇ ମର୍‌ ରାଇଜେ ରାଜା ଅଇ ଆଇବା ଜାକ, ଇତି ରଇଲା କେତେ ଲକ୍‌ ନ ମରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ଚଅ ଦିନ୍‌ପଚେ ଜିସୁ ପିତର୍‌, ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌ ଦୁଇ ବାଇକେ ନେଇ ଗଟେକ୍‌ ଡେଙ୍ଗ୍‌ ଡଙ୍ଗ୍‌ରେ ଗାଲା । ତେଇ କେ ମିସା ନ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ସିସ୍‌ମନ୍‌ ଦେକ୍‌ଲା ଦାପ୍‌ରେ ଜିସୁ, ଗଟେକ୍‌ ଦେକ୍‌ଲେ କାବା ଅଇଜିବା ରୁପ୍‌ ଅଇ ବାଦ୍‌ଲି ଗାଲା । ତାର୍‌ ମୁ ବେଲ୍‌ ପାରା ଉଜଲ୍‌ ଅଇଲା ଆରି ପଚିଆର୍‌ ଉଜଲ୍‌ ପୁଲ୍‌ପାରା ଦବ୍‌ ଡିସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ସିସ୍‌ମନ୍‌ ମସା ଆରି ଏଲିୟ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ କାତାବାର୍‌ତା ଅଇବାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ପିତର୍‌ ଜିସୁକେ କଇଲା, “କେଡେ ସୁକର୍‌ କାତା, ଆଜି ଆମେ ଇତି ଆଚୁ । ତମେ ଜଦି ମନ୍‍ କର୍‌ସା, ଇତି ମୁଇ ତିନ୍‌ଟା କୁଡିଆ ତିଆର୍‌ କର୍‌ବି । ତମର୍‌ ପାଇ ଗଟେକ୍‌, ମସା ଆରି ଏଲିୟର୍‌ ପାଇ ଦୁଇଟା ।” ");
INSERT INTO dso_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ପିତର୍‌ ଏଟା କଇବାବେଲେ ଏଦେ ଦେକା ! କଣ୍ଡେକ୍‌ ବାଦଲ୍‌ ଉଜଲ୍‌ ଅଇ ସେମନର୍‌ ଉପ୍‌ରେ ଉଡି ଆଇଲା ଆରି ତେଇଅନି ଗଟେକ୍‌ ସର୍‌ ଆଇଲା “ଏ ମର୍‌ ଆଲାଦର୍‌ ପଅ, ଆର୍‌ ଲଗେ ମୁଇ ବେସି ସାର୍‌ଦା । ତାର୍‌ କାତା ମନ୍‌ ଦେଇ ସୁନା ।” ");
INSERT INTO dso_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ସିସ୍‌ମନ୍‌ ସେ ସର୍‌ ସୁନି ଏତେକ୍‌ ଡରି ଗାଲାଇ ଜେ ସେମନ୍‌ ଉମ୍‌ତାଡିଅଇ ଅଦ୍‌ରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ଜିସୁ ସେମନର୍‌ ଲଗେ ଆସି ସେମନ୍‌କେ ଚିଇ କରି କଇଲା, “ଉଟା, ଡରା ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ଉପ୍‌ରେ ଦେକ୍‌ଲାଇଜେ ଜିସୁକେ ଚାଡି ଆରି କେ ଡିସତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ସେମନ୍‌ ଡଙ୍ଗ୍‌ରେଅନି ଉତ୍‌ରି ଆଇଲା ବେଲେ ଜିସୁ ସେମନ୍‌କେ ଆଦେସ୍‌ ଦେଇ କଇଲା, “ନର୍‌ପିଲା ମୁଇ ମଲାଟାନେଅନି ଆରିତରେକ୍‌ ନ ଉଟ୍‌ବା ଜାକ ଏ ଦେକ୍‌ଲା କାତା ତମେ କାକେ କୁଆ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ସିସ୍‌ମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ “ଆମର୍‌ ଦରମ୍‌ ଗୁରୁମନ୍‌ ଏଲିୟ ପର୍‌ତୁମ୍‌ ଆଇସି ବଲି କାଇକେ କଇଲାଇ ଆଚତ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ଜିସୁ କଇଲା, “ଉଁ ଏଲିୟ ପର୍‌ତୁମ୍‌ ଆସିକରି ସବୁ ବିସଇ ତିଆର୍‌ କରି ରଇବା କାତା । ");
INSERT INTO dso_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି, ଏଲିୟ ତା ଆସି ସାର୍‌ଲା ଆଚେ ଆରି ଲକ୍‌ମନ୍‌ ତାକେ ନ ଚିନି ଜନ୍‌ଟା ମନ୍‍ କଲା ସେଟା ତାକେ କଲାଇ ଆଚତ୍‌ । ସେନ୍ତାରିସେ ନର୍‌ପିଲା ମକେ ମିସା ସେମନ୍‌ ସେନ୍ତି କାରାପ୍‌ ଚଲାଚଲ୍‌ତି କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ସେଡ୍‌କି ବେଲେ ସେମନ୍‌ ବୁଜି ପାର୍‌ଲାଇ ଜେ, ଜିସୁ ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‍ ବିସଇ କଇଲାନି ବଲି । ");
INSERT INTO dso_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଲକ୍‌ ଗଉଲି ବିତ୍‌ରେ ବାଉଡି ଆଇଲା ପଚେ, ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ମାଣ୍ଡିକୁଟା ଦେଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ମାପ୍‌ରୁ, ମର୍‌ ପିଲାକେ ଦୟା କରା । ମୁର୍‌ଚା ବେମାର୍‌ ଲାଗି କସ୍‌ଟ ପାଇଲାନି । ସେ ବେସି ତର୍‌ ଜଇତେଇ ଆରି ପାନିତେଇ ଅଦ୍‌ରି ଦେଲାନି । ");
INSERT INTO dso_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ତାକେ ମୁଇ ତମର୍‌ ସିସ୍‌ମନର୍‌ ଲଗେ ଆନି ରଇଲି, ମାତର୍‌ ସେମନ୍‌ ନିକ କରି ନାପାର୍‌ଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ଜିସୁ କଇଲା, “ତମର୍‌ କେଡେ ଡାଟ୍‍ ନ ରଇବା ବିସ୍‌ବାସ୍‌ ଆରି ବୁଲ୍‌ ! ତମର୍‌ ସଙ୍ଗ୍‌ ଆରି ମୁଇ କେତେ ଦିନ୍‌ ରଇବି ? ଆରି କେତେ ଦିନ୍‌ ତମର୍‌ ଚଲାଚଲ୍‌ତିଟା ସୁନି ସୁନି ତୁମ୍‌ପୁଡି ରଇବି ? ସେ ପିଲାକେ ମର୍‌ ଲଗେ ଆନା ।” ");
INSERT INTO dso_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ପିଲା ବିତ୍‌ରେ ରଇଲା କାରାପ୍‌ ଆତ୍‌ମାକେ ଜିସୁ ଦମ୍‌କାଇଲା । କାରାପ୍‌ ଆତ୍‌ମା ଚାଡି ଉଟିଗାଲା ଆରି ସେ ଦାପ୍‌ରେସେ ପିଲା ନିକ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ତାର୍‌ ପଚେ ସିସ୍‌ମନ୍‌ ଜିସୁ ଏକ୍‌ଲା ରଇଲା ବେଲେ ଆସି ତାକେ ପାଚାର୍‌ଲାଇ, “ଆମେ କାଇକେ ସେ କାରାପ୍‌ ଆତ୍‌ମାକେ କେଦି ନାପାର୍‌ଲୁ ?” ");
INSERT INTO dso_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମର୍‌ ବିସ୍‌ବାସ୍‌ ବେସି ଦୁର୍‌ବଲ୍‌ । ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜଦି ଗଟେକ୍‌ ସର୍‌ସୁ ମୁଞ୍ଜି ଏତ୍‌କି ତମର୍‌ ବିସ୍‌ବାସ୍‌ ରଇଲେ, ଏ ଡଙ୍ଗର୍‌, ଇତିଅନି ତେଇ ଗୁଚି ଜିବାକେ କଇଲେ, ସେଟା ଗୁଚି ଜାଇସି । ବିସ୍‌ବାସର୍‌ ଲାଗି ତମେ ସବୁ ବିସଇ କରିପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ମାତର୍‌ ଉପାସ୍‌ ରଇକରି ପାର୍‌ତନା ନ କଲେ, କାଇ ବିନ୍‌ ଉପାଇ ନେଇ ମିସା ଏନ୍ତାରି ଡୁମା ବାରଇ ନ ଜାଏ । ");
INSERT INTO dso_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ସିସ୍‌ମନ୍‌ ଗାଲିଲିତେଇ ରୁଣ୍ଡ୍‌ଲା ପଚେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ନର୍‌ପିଲା ମୁଇ ଲକ୍‌ମନ୍‍କେ ସର୍‌ପି ଅଇବାର୍‌ ଗାଲିନି । ");
INSERT INTO dso_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ତେଇ ସେମନ୍‌ ମକେ ମରାଇବାଇ, ମାତର୍‌ ତିନ୍‌ ଦିନ୍‌ ପଚେ ମୁଇ ଆରି ତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ବି ।” ଜିସୁର୍‌ କାତା ସୁନି ସିସ୍‌ମନ୍‌ ବେସି ଦୁକ୍‌ ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ କପର୍‌ନାଉମେ କେଟ୍‌ଲା ପଚେ ମନ୍ଦିର୍‌ ପାଇ ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ପିତର୍‌କେ ପାଚାର୍‌ଲାଇ, “ତମର୍‌ ଗୁରୁ ମନ୍ଦିରର୍‌ ପାଇ ସିସ୍‌ତୁ ଦେଇସି କି ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ପିତର୍‌ କଇଲା, “ଦେଇସି ।” ପିତର୍‌ ଗର୍‌ ବିତ୍‌ରେ ପୁରୁପୁରୁ ଜିସୁ ତାକେ ପାଚାର୍‌ଲା, “ସିମନ୍‌, ତମେ କାଇଟା ବାବ୍‌ଲାସ୍‌ନି ? ଏ ଜଗତର୍‌ ରାଜାମନ୍‌ କାର୍‌ଟାନେଅନି ସିସ୍‌ତୁ ନେବାଇ ? ତାକର୍‌ ନିଜର୍‌ ଦେସର୍‌ ଲକ୍‌ମନର୍‌ଟାନେଅନି କି ବିନ୍‌ ଦେସର୍‌ ଲକ୍‌ମନର୍‌ଟାନେଅନି ?” ");
INSERT INTO dso_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ପିତର୍‌ କଇଲା, “ବିନ୍‌ ଦେସର୍‌ ଲକ୍‌ମନର୍‌ତେଇଅନି ।” ଜିସୁ କଇଲା, “ସେନ୍ତି ବଇଲେ ରାଇଜର୍‌ ଲକ୍‌ମନ୍‌ ସିସ୍‌ତୁ ନ ଦେଅତ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ମାତର୍‌ ଆମେ ଏବେ ସେମନ୍‌କେ ଇନ୍‌ କର୍‌ବାକେ ମନ୍‍ କରୁ ନାଇ । ତୁଇ ଗାଡେ ଜାଇ ବଡ୍‌ସି ପାକାଆ ଆରି ଜନ୍‌ ମାଚ୍‌ ପର୍‌ତୁମ୍‌ ଲାଗ୍‌ସି, ତାର୍‌ ଟଣ୍ଡେଅନି ଗଟେକ୍‌ ଅଦ୍‌ଲି ମିଲାଇସୁ । ସେଟା ନେଇ ମର୍‌ ପାଇ ଆରି ତମର୍‌ ପାଇ ମନ୍ଦିରର୍‌ ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌କେ ଦେଇଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ସେ ବେଲେ ସିସ୍‌ମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ସରଗ୍‌ ରାଇଜେ ସବୁର୍‌ଟାନେଅନି କେ ବଡ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ଜିସୁ ଗଟେକ୍‌ ସାନ୍‌ ପିଲାକେ ଡାକି ସେମନର୍‌ ଲଗେ ଟିଆକରାଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ତମର୍‌ ମନ୍‌ ବାଦ୍‌ଲାଇ ସାନ୍‌ ପିଲାମନର୍‌ ପାରା ନ ଅଇଲେ ସରଗ୍‌ ରାଇଜେ କେବେ ପୁରି ନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ଜେ ନିଜ୍‌କେ ସୁଆଲ୍‌ କରି ସାନ୍‌ ପିଲାପାରା ଅଇସି, ସେ ସରଗ୍‌ ରାଇଜେ ସବୁର୍‌ଟାନେଅନି ବଡ୍‌, ");
INSERT INTO dso_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ଆରି, ଜେକି ମର୍‌ ନାଉଁ ଦାରି ଏ ସାନ୍‌ ପିଲାକେ ନାମ୍‌ସି, ସେ ମକେ ମିସା ନାମ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ମର୍‌ତେଇ ବିସ୍‌ବାସ୍‌ କର୍‌ତେ ରଇବା ଏ ସାନ୍‌ ପିଲାମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‍ ଲକ୍‌ କେ ଆଲେ ବିସ୍‌ବାସେ ବାଦା ଗଟାଇସି ବଇଲେ, ତାର୍‌ ଗାଲାଇ ଜତା ପାକ୍‌ନା ବାନ୍ଦିକରି ତାକେ ସମ୍‌ଦୁରେ ବୁଡାଇଦେବାଟା ନିକ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ଲକ୍‌ମନର୍‌ ବିସ୍‌ବାସେ ବାଦା ଗଟାଇବାକେ ବେସି ବିସଇ ଆଚେ । ସେଟାର୍‌ ପାଇ ଏ ଜଗତର୍‌ ଦସା ବଡେ ଇନସ୍‌ତା । ସବୁ ବେଲେ ଏନ୍ତି ବାଦା ଆଇସି, ମାତର୍‌ ଜେ ବାଦା ଗଟାଇସି, ତାର୍‌ ଦସା କେଡେ ଇନସ୍‌ତା ଅଇସି !” ");
INSERT INTO dso_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ଜଦି ତମେ ତମର୍‌ ଆତ୍‌ ନଇଲେ ପାଦର୍‌ ଲାଗି ବିସ୍‌ବାସ୍‌ ଆରାଇଲାସ୍‌ନି, ତେବେ ସେଟା କାଟି ପିଙ୍ଗି ଦିଆସ୍‌ । ଜଡେକ୍‌ ପାଦ୍‌ ଆରି ଜଡେକ୍‌ ଆତ୍‌ ରଇ ସବୁବେଲେ ଲାଗି ରଇବା ଜଏ ପିଙ୍ଗାଇ ଅଇବା ବାଦୁଲେ ଗଟେକ୍‌ ପାଦ୍‌ ନଇଲେ ଗଟେକ୍‌ ଆତ୍‌ ନ ରଇ, ନ ସାର୍‌ବା ଜିବନେ ପୁର୍‌ବାଟା କେଡେ କରମର୍‌ କାତା । ");
INSERT INTO dso_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ଜଦି ତମର୍‌ ଆଁକିର୍‌ ଲାଗି ତମେ ବିସ୍‌ବାସ୍‌ ଆରାଇଲାସ୍‌ନି ବଇଲେ ତାକେ ବେଟି ପିଙ୍ଗି ଦିଆସ୍‌ । ଜଡେକ୍‌ ଆଁକି ରଇ ନର୍‌କେ ପିଙ୍ଗାଇଅଇବା ବାଦୁଲେ ଗଟେକ୍‌ ଆଁକି ରଇ ନ ସାର୍‌ବା ଜିବନେ ପୁର୍‌ବାଟା କେଡେ କରମର୍‌ କାତା ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ଏ ସାନ୍‌ ପିଲାମନର୍‌ ବିତ୍‌ରେ ଅନି ଗଟେକ୍‌କେ ମିସା ଇନ୍‌କରା ନାଇ । ମୁଇ ତମ୍‌କେ କଇଲିନି, ଏ ମନର୍‌ ଜତନ୍‌ ନେଇତେ ରଇବା ସରଗର୍‍ ଦୁତ୍‌ମନ୍‌ ସବୁ ବେଲା ମର୍‌ ବାବାର୍‌ ଲଗେ ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","କାଇକେ ବଇଲେ ବାଟ୍‌ ବାନା ଅଇଲା ଲକ୍‌ମନ୍‌କେ କଜି ରକିଆ କର୍‌ବାକେ ନର୍‌ପିଲା ମୁଇ ଆଇଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ତମେ କାଇଟା ବାବ୍‌ଲାସ୍‌ନି, ଜଦି ଗଟେକ୍‌ ଲକର୍‌ ସଏଟା ମେଣ୍ଡା ରଇସି ଆରି ସିତିଅନି ଗଟେକ୍‌ ଆଜି ଜାଇସି, ତେବେ ସେ କାଇଟା କର୍‌ସି ? ନବେ ନଅଟା ମେଣ୍ଡାକେ ଡଙ୍ଗରେ ଚାର୍‌ବାକେ ଚାଡିଦେଇ ସେ ଆଜ୍‌ଲା ମେଣ୍ଡାକେ କଜ୍‌ବାର୍‌ ବାରଇସି । ");
INSERT INTO dso_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜେଡେବଲ୍‌ ସେ ମେଣ୍ଡା ମିଲାଇସି, ଆଜି ନ ରଇଲା ନବେ ନଅଟା ମେଣ୍ଡାର୍‌ ପାଇ ତାର୍‌ ଜେତ୍‌କି ସାର୍‌ଦା, ଏ ଗଟେକ୍‌ ମେଣ୍ଡାର୍‌ ପାଇ ସେ ଅଦିକ୍‌ ସାର୍‌ଦା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ସମାନ୍‍ ସେନ୍ତି ସେ, ଏ ସାନ୍‌ ପିଲାମନର୍‌ ତେଇ ଅନି ଗଟେକ୍‌ ଲକ୍‌ ମିସା ବାଟ୍‌ ବାନା ଅଅତ୍‌, ଏଟା ତମର୍‌ ସରଗର୍‌ ବାବା ମନ୍‍ କରେ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ଜଦି ତମର୍‌ ବାଇ ତମର୍‌ ବିରୁଦେ ପାପ୍‌ କର୍‌ସି, ତାର୍‌ ଲଗେ ଜାଇ ତାର୍‌ ପାପ୍‌ ତାକେ ଦେକାଇ ଦିଆସ୍‌ । ମାତର୍‌ ତମେ ଦୁଇ ଲକ୍‌ ରଇଲା ବେଲେ ଏଟା ଲୁଚ୍‌ତେ କରା । ଜଦି ସେ ତମର୍‌ କାତା ସୁନ୍‌ସି, ତମର୍‌ ବାଇକେ ତମେ ଆରି ତରେକ୍‌ ପାଇସା । ");
INSERT INTO dso_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ଆରି ଜଦି ସେ ନ ସୁନ୍‌ଲେ, ଗଟେକ୍‌ ଲକ୍‌କେ ନଇଲେ ଦୁଇ ଲକ୍‌କେ ଡାକି ନେଇ ତାର୍‌ ଲଗେ ଜାଆ । ଆମର୍‌ ସାସ୍‌ତର୍‌ ନିୟମ୍‌ ଇସାବେ, ଦୁଇଟା ନଇଲେ ତିନ୍‌ଟା ସାକିର୍‌ ମୁଆଟେ ତମର୍‌ ଦାବି ସତ୍‌ ବଲି ଜାନା ପଡ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ଏଲେ ମିସା ଜଦି ସେ ତମର୍‌ କାତା ନ ସୁନେ, ମଣ୍ଡଲିତେଇ ଜାନାଇ ଦିଆସ୍‌ । ସାରାସାରି ଜଦି ମଣ୍ଡଲିର୍‌ କାତା ମିସା ନ ସୁନେ ବଇଲେ, ତାକେ ଗଟେକ୍‌ ସିସ୍‌ତୁମାଙ୍ଗୁ, ବିସ୍‍ବାସ୍‍ ନ କର୍‍ବା ଲକ୍‌ ବଲି ବାବିକରି, ତାର୍‌ ସଙ୍ଗ୍‌ ମିଲାମିସା କର୍‌ବାଟା ଚାଡି ଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ତମେ ଏ ଜଗତେ ଜାଇଟା ନାଇ ବଲ୍‌ସା, ସେଟା ସର୍‌ଗେ ମିସା ନାଇ ଅଇସି । ଆରି ଜନ୍‌ଟା ପାଇ ତମେ ଜଗତେ ଉଁ କଇସା, ସେଟା ସର୍‌ଗେ ମିସା ଉଁ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","କାଲି ସେତ୍‌କି ନଏଁ, ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜେଡେବେଲେ ମିସା ଏ ଜଗତେ ତମେ ଦୁଇ ଲକ୍‌ ଜନ୍‌ ବିସଇ ନେଇକରି ଗଟେକ୍‌ ମନ୍‌ ଅଇକରି ପାର୍‌ତନା କଲେ, ମର୍‌ ସରଗର୍‌ ବାବା ତମେ ମାଙ୍ଗ୍‍ଲାଟା ପୁରୁନ୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","କାଇକେ ବଇଲେ ଜନ୍ତି ଦୁଇ କି ତିନ୍‌ ଲକ୍‌ ରୁଣ୍ଡିକରି ମର୍‌ ନାଉଁ ଦାର୍‌ବାଇ, ତେଇ ମୁଇ ଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ଦିନେକ୍‍ ପିତର୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ପାଚାର୍‌ଲା, “ମାପ୍‌ରୁ, ଗଟେକ୍‌ ବାଇ ମର୍‌ ବିରଦେ ତର୍‌କେ ତର୍‌ ଦସ୍‌ କର୍‌ତେ ରଇଲେ, ତାକେ ମୁଇ କେତେ ତର୍‌ କେମା କର୍‌ବି ? କାଇ ସାତ୍‌ ତର୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ଜିସୁ କଇଲା, “ନାଇ ସାତ୍‌ ତର୍‌ ନାଇ । ସାତ୍‌ ତରର୍‌ ସତୁରି ଗୁନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ସରଗ୍‌ ରାଇଜର୍‌ ଆରି ଗଟେକ୍‌ କାତା ସୁନ୍‌ । ଗଟେକ୍‌ ରାଜା ଦିନେକ୍‌ ତାର୍‌ଟାନେ କାମ୍‌କରୁମନ୍‌ ରୁନ୍‌ ନେଇରଇବାଟା ଇସାବ୍‌ କିତାବ୍‌ କର୍‌ବାକେ ମନ୍‍ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ସେ ଇସାବ୍‌ କର୍‌ବାବେଲେ ତାର୍‌ଟାନେ ଗଟେକ୍‌ କାମ୍‌ କରୁ ଲାକ୍‌ ଲାକ୍‌ ଟାଙ୍ଗା ରୁନ୍‌ ନେଇରଇଲା ଲକ୍‌କେ ରାଜାର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ରୁନ୍‌ ସୁଜ୍‌ବାକେ ସେ ଲକର୍‌ଟାନେ ସେତ୍‌କି ବପୁ ନ ରଇଲା । ତେବର୍‌ପାଇ ରୁନ୍‌ ବାନ୍ଦ୍‌ବାକେ ବଲି ତାର୍‌ଟାନେ ଜେତ୍‌କି ରଇଲାଟା ବିକିକରି ତାକେ, ତାର୍‌ ମାଇଜିକେ ଆରି ତାର୍‌ ପିଲାଟକିମନ୍‌କେ ଗତି ଇସାବେ ବିକିଦେବାକେ ରାଜା ଆଦେସ୍‌ ଦେଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","କାମ୍‌ କରୁ ରାଜାର୍‌ ପାଦ୍‌ତଲେ ଅଦ୍‌ରି ଗୁଆରି କରି କଇଲା “ ଆଗିଆଁ ଆରି କେତେଦିନ୍‌ ଜାଗା, ମୁଇ ତମର୍‌ ସବୁଜାକ ରୁନ୍‌ ସୁଜିଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ରାଜା ତାକେ ଦୟା କଲା । ତେବର୍‌ପାଇ ତାକେ କେମା କରି ରୁନ୍‌ ନ ବାନ୍ଦାଇ ଚାଡିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ମାତର୍‌ ସେ ଗତି ବାରଇ ଜାଇ ତାର୍‌ତେଇ ଅନି ପଚାସ୍‌ ଟାଙ୍ଗା ରୁନ୍‌ କରି ରଇବା ଗଟେକ୍‌ ମିସ୍‌ତେ ରଇବା ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଦାରି ତାର୍‌ ଟଟ୍‌ରି ପିଚକ୍‌ବାର୍‌ ଦାର୍‌ଲା, “ମର୍‌ତେଇଅନି ନେଇ ରଇଲା ସବୁ ଡାବୁ ବାଉଡାଇ ଦେ ।” ");
INSERT INTO dso_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ସେ ଗତି ଦାଙ୍ଗ୍‌ଡା ତାର୍‌ ଗଡେଦାରି ବାବୁଜିଆ କରି କଇଲା, “ସାଆସ୍‌ ଦାରା, ତମର୍‌ ସବୁ ଡାବୁ ସୁଜି ଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ମାତର୍‌ ପର୍‌ତୁମ୍‌ ଲକ୍‌, ସେ ଗୁଆରି କଲାଟା ସୁନେ ନାଇ, ରୁନ୍‌ ସୁଜ୍‌ବା ଜାକ ତାକେ ବନ୍ଦି ଗରେ ପୁରାଇ ସଙ୍ଗଇବାକେ ତିଆର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ଏଟା ଅଇଲାଟା ଦେକି ବିନ୍‌ କାମ୍‌ କରୁମନ୍‌ ଦୁକ୍‌ କଲାଇ । ସେମନ୍‌ ରାଜାର୍‌ ଲଗେ ଜାଇ ଜନ୍‌ ଜନ୍‌ଟା ଅଇରଇଲା, ସବୁ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ରାଜା ପର୍‌ତୁମ୍‌ କାମ୍‌ କରୁକେ ଡାକାଇ କଇଲା, “ ଅଇରେ ମୁର୍‌କ ଦାଙ୍ଗ୍‌ଡା, ତୁଇ ଗୁଆରି କଲୁସ୍‌ ଜେ ମୁଇ ତର୍‌ ସବୁ ରୁନ୍‌ ଚାଡି ଦେଲି । ");
INSERT INTO dso_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ମୁଇ ଜେନ୍ତି ତକେ ଦୟା କଲି, ତୁଇ ମିସା ତର୍‌ ସଙ୍ଗର୍‌ କାମ୍‌ କରୁକେ ଦୟା କର୍‌ବାର୍‌ ରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ରାଜା ବେସି ରିସା ଅଇଗାଲା ଆରି ସବୁ ଜାକ ରୁନ୍‌ ନ ସୁଜ୍‌ବା ଜାକ ଡଣ୍ଡ୍‌ ପାଅ ବଲି ତାକେ ବନ୍ଦି ଗରେ ପାଟାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ଜିସୁ ଏ କାତା କଇସାରାଇ କଇଲା, “ତମର୍‌ ବିରୁଦେ ଦସ୍‌ କରି ରଇବା ବାଇମନ୍‌କେ ମନ୍‌ ବିତ୍‌ରେଅନି ଜଦି କେମା ନ ଦିଆସ୍‌, ତେବେ ମର୍‌ ସରଗର୍‌ ବାବା ମିସା ତମ୍‌କେ ଏନ୍ତାରିସେ କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଜିସୁ ଏ ସବୁ କଇସାର୍‌ଲା ପଚେ ଗାଲିଲି ଚାଡିକରି ଜର୍‌ଦନ୍‌ ଗାଡ୍‌ ସେପାଟେ ରଇଲା ଜିଉଦା ଜାଗାଇ କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ବେସି ଲକ୍‌ମନ୍‌ ତାର୍‌ ସଙ୍ଗ୍‌ ଗାଲାଇ ଆରି ସେ କେତେକ୍‍ କେତେକ୍‌ ରଗିମନ୍‌କେ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","କେତେଟା ପାରୁସିମନ୍‌ ଜିସୁକେ ବୁଲ୍‌ ଦାର୍‌ବାକେ ଚେସ୍‌ଟା କଲାଇ । ସେମନ୍‌ ତାର୍‌ ଲଗେ ଆସି ପାଚାର୍‌ଲାଇ, “ମସାର୍‌ ରିତିନିତି ଇସାବେ ଗଟେକ୍‌ ଲକ୍‌ କାଇଆଲେ ବୁଲର୍‌ ପାଇ ବଲି ତାର୍‌ ମାଇଜିକେ ଚାଡି ଦେଇ ପାରେ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ଜିସୁ କଇଲା, “ସାସ୍‌ତରେ ପଡାସ୍‌ ନାଇ କି ? ଆଦିପୁର୍‌ବେ ପର୍‌ମେସର୍‌ ନର୍‌ ଲକ୍‌କେ ମୁନୁସ୍‌ ଆରି ମାଇଜି କରି ତିଆର୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ସେଡେବେଲେ ମାପ୍‌ରୁ କଇରଇଲା, ଏଟାର୍‌ ପାଇ ବଲି ମୁନୁସ୍‌, ତାର୍‌ ଆୟା ବାବାର୍‌ତେଇ ଅନି ବିନେ ଅଇସି ଆରି ସେମନ୍‌ ଦୁଇ ଲକ୍‌ ଗଟେକ୍‌ ଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ଆରି ସେମନ୍‌ ଅଲ୍‌ଗା ନ ଅଅତ୍‌, ମିସି ରଇବାଇ । ସେମନ୍‌ ଦୁଇଲକ୍‌ ଇସାବେ ନ ରଅତ୍‌ । ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ପର୍‌ମେସର୍‌ ଜଡିଆଚେ, ଲକ୍‌ମନ୍‌ ସେମନ୍‌କେ ବେଗ୍‍ଲାଇବାଟା ଟିକ୍‌ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ପାରୁସିମନ୍‌ ଆରି ପାଚାର୍‌ଲାଇ, “ସେନ୍ତାର୍‌ ଆଲେ ମାଇଜିକେ ରାଜିନାମା ପତର୍‌ ଲେକି ଚାଡି ଦେବାକେ ମସା କାଇକେ ନିୟମ୍‌ କଲାଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ଜିସୁ କଇଲା, “ତମର୍‌ ମନ୍‌ବିତ୍‌ରର୍‌ ବୁଜ୍‌ବା ବପୁ ଦୁର୍‍ବଲ୍‍ ରଇଲାଟା ଦେକି ମସା ତମର୍‌ ମାଇଜିମନ୍‌କେ ଚାଡ୍‌ବାକେ ରାଜି ଅଇଲା । ମାତର୍‌ ଆଦିପୁର୍‌ବେ ତିଆର୍‌ ଅଇଲା ବେଲେ ଏନ୍ତାରି ନିୟମ୍‌ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି, କେ ମିସା ତାର୍‌ ମାଇଜିକେ ବେସିଆ କାମ୍‌ ଅପ୍‌ରାଦ୍‌କେ ଚାଡି, ବିନ୍‌ କାଇଆଲେ କାମର୍‌ ପାଇ ଚାଡାମେଲା କରି, ବିନ୍‌ ମାଇଜିକେ ସଙ୍ଗଇଲେ, ସେ ସେ ନିଜେ ଦାରିଆ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ କଇଲାଇ, “ଜଦି ମାଇଜି ମୁନୁସର୍‌ ବିତ୍‌ରେ ଏନ୍ତାରି ଆଚେ ବଇଲେ, ବିବା ନ ଅଇବାଟା ନିକ ।” ");
INSERT INTO dso_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ଜିସୁ କଇଲା, “ଏ ସିକିଆ ସବୁ ଲକ୍‌ ନ ମାନତ୍‌ । ପର୍‌ମେସର୍‌ ଟାନେଅନି ଜନ୍‌ଲକ୍‌ମନ୍‌କେ ଏଟା ଦିଆଅଇଆଚେ ସେମନ୍‍ସେ ଏଟା ମାନ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ବିନ୍‌ ବିନ୍‌ କାମର୍‌ପାଇ ଲକ୍‌ମନ୍‌ ବିବା ନ ଅଇ ରଇଜିବାଇ । କେତେ ଲକ୍‍ ଜନମେ ଅନି ବେଜୁ ଅଇ ବିବାଅଇ ନାପାରତ୍‌ । କେତେ ଲକ୍‌କେ ମୁନୁସ୍‌ମନ୍‌ ସେନ୍ତାରି କରି ଆଚତ୍‌, ଆରି କେତେ ଲକ୍‌ ସରଗ୍‌ ରାଇଜର୍‌ ପାଇ କାମ୍‌ କର୍‌ବାକେ ବିବା ନ ଅଇକରି ଆଚତ୍‌ । ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଏ ସିକିଆର୍‌ ଅରତ୍‌ ବୁଜିପାର୍‌ଲାଇନି, ସେମନ୍‌ ସେଟା ମାନତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","କେତେ ଲକ୍‌ ପିଲାମନର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇ ପାର୍‌ତନା କର୍‌ବାକେ, ସେମନ୍‍କେ ଜିସୁର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ମାତର୍‌ ସିସ୍‌ମନ୍‌ ସେମନ୍‌କେ ଦମ୍‌କାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ମାତର୍‌ ଜିସୁ କଇଲା, “ସାନ୍‌ ପିଲାମନ୍‌କେ ମର୍‌ ଲଗେ ଆଇବାକେ ବାଟ୍‌ ଦିଆସ୍‌ । ସେମନ୍‌କେ ମନା କରା ନାଇ । କାଇକେ ବଇଲେ ଏମନ୍‌ ଆକା ସରଗ୍‌ ରାଇଜେ ରଇବା ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ଜିସୁ ପିଲାମନର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇ ଆସିର୍‌ବାଦ୍‌ କଲା । ପଚେ ସେ ତେଇଅନି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ଦିନେକ୍‌ ଗଟେକ୍‌ ସାଉକାର୍‌ ପିଲା ଜିସୁର୍‌ ଲଗେ ଆସି ପାଚାର୍‌ଲା, “କାଇ ନିକ କାମ୍‌କଲେ, ନ ସାର୍‌ବା ଜିବନ୍‌ ମିଲ୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ଜିସୁ ତାକେ କଇଲା, “ନିକ କାମ୍‌ ବିସଇ ନେଇକରି ମକେ କାଇକେ ପାଚାର୍‌ଲୁସ୍‌ନି ? ପର୍‌ମେସର୍‌ସେ ସତ୍‌ । ତାର୍‌ ଆଦେସ୍‌ ମାନ୍‌ଲେ, ନ ସାର୍‌ବା ଜିବନ୍‌ ମିଲାଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ସେ ପାଚାର୍‌ଲା, “କାଇ କାଇ ଆଦେସ୍‌ ?” ଜିସୁ କଇଲା, “ନର୍‌ ଲକ୍‌ମନ୍‌କେ ମରାଇବାର୍‌ ନାଇ, ବେସିଆ କାମ୍‌ କର୍‌ବାର୍‌ ନାଇ, ଚରାଇବାର୍‌ ନାଇ, କାର୍‌ ବିରୁଦେ ମିଚ୍‌ ସାକି ଦେବାର୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ଆୟା ବାବାର୍‌ ସେବା କରା ଆରି ତମର୍‌ ପଡିସାର୍‌ ଲକ୍‌ମନ୍‌କେ ନିଜର୍‌ ପାରା ଆଲାଦ୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ସେ ବେଣ୍ଡିଆ କଇଲା, “ମୁଇ ଏ ସବୁ ଆଦେସ୍‌ ମାନି ଆଇଲିନି । ଆରି କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ଜଦି ସିଦ୍‌ ଅଇବାକେ ମନ୍‌ କଲୁସ୍‌ନି ବଇଲେ, ଜାଆ ତର୍‌ଟାନେ ରଇବା ସବୁଜାକ ବିକି ଦେଇ, ସେ ଡାବୁ ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ଦାନ୍‌ କରିଦେସ୍‌ । ଏଟା ସବୁ କରି ସାରାଇ ମର୍‌ ସଙ୍ଗ୍‍ ଆଉ । ସେନ୍ତାର୍‌ କଲେ ତକେ ସର୍‌ଗେ ଦନ୍‌ ମିଲ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ଏଟା ସୁନି କରି ସେ ବେଣ୍ଡିଆ ମୁ ଉତ୍‌ରାଇଦେଇ ତେଇଅନି ଉଟିଗାଲା । କାଇକେ ବଇଲେ ସେ ଲକ୍‌ ବେସି ସାଉକାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ଜିସୁ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ସାଉକାର୍‌ ଲକ୍‌ମନ୍‌ ସରଗ୍‌ ରାଇଜେ ସଲ୍‌କେ କେଟ୍‌ବାଟା ବଡେ ଆବଡ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ଆରି ତରେକ୍‌ କଇଲିନି, ଗଟେକ୍‌ ବଡ୍‍ଟା ପସୁ ଜେନ୍ତି ସୁଜି କାଣାବାଟେ ଚିଙ୍ଗ୍‌ଲି ଜିବାକେ ଆବଡ୍‌, ସାଉକାର୍‌ ଲକ୍‌ ସରଗ୍‌ ରାଇଜେ କେଟ୍‌ବାଟା ଅଦିକ୍‌ ଆବଡ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ସିସ୍‌ମନ୍‌ ଏ କାତା ସୁନି କାବାଅଇଜାଇ ପାଚାର୍‌ଲାଇ, “ଏନ୍ତି ବଇଲେ କେ ତେବେ ମୁକ୍‌ତି ପାଇପାର୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ଜିସୁ ସେମନର୍‌ ବାଟେ ଦିରେକରି ଦେକି କଇଲା, “ମୁନୁସ୍‌ମନର୍‌ଟାନେ ଏଟା ଅଇନାପାରେ, ମାତର୍‌ ପର୍‌ମେସରର୍‌ ଟାନେ ସବୁଟା ଅଇପାର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ଏ କାତା ସୁନି ପିତର୍‌ କଇଲା, “ଦେକା, ଆମେ ସବୁଜାକ ଚାଡିକରି ତମର୍‌ ସଙ୍ଗ୍‍ ଆସିଆଚୁ । ତେବେ ଆମ୍‌କେ କାଇଟା ମିଲ୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏ କାତା ସତ୍‌ ବଲି ଜାନ୍‌ସା, ଜେଡେବେଲେ ନୁଆ ଜୁଗେ ନର୍‌ପିଲା ମୁଇ ମର୍‌ ଡାକ୍‌ପୁଟା ଅଇବା ବସ୍‍ବାଟାନେ ବସ୍‌ବି । ମର୍‌ ବାର୍‌ଟା ସିସ୍‌, ତମେ ମିସା, ବାର୍‌ଟା ବସ୍‍ବାଟାନେ ବସି ଇସ୍‌ରାଏଲର୍‌ ବାର୍‌ଟା କୁଟୁମ୍‌କେ ସାସନ୍‌ କର୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ମର୍‌ଲାଗି ନିଜର୍‌ ଗର୍‌, ବାଇ ବଇନି, ଆୟା ବାବା, ପିଲାଟକି ଆରି ଜମିବାଡି ଚାଡି ଆଚତ୍‌, ସେମନ୍‌ ତାର୍‌ ସଏ ଗୁନ୍‌ ଆସିର୍‌ବାଦ୍‌ ପାଇବାଇ, ଆରି ନ ସାର୍‌ବା ଜିବନ୍‌ ମିସା ପାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ଏବେ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଆଗ୍‌ତୁ ଆଚତ୍‌, ସେମନର୍‌ ବିତ୍‌ରେଅନି ବେସି ଲକ୍‌ ପଚେ ଅଇଜିବାଇ । ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପଚେ ଆଚତ୍‌, ସେମନର୍‌ ବିତ୍‌ରେ ଅନି ବେସି ଲକ୍‌ ଆଗ୍‌ତୁ ଅଇଜିବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","ସରଗ୍‌ ରାଇଜ୍‌ କେନ୍ତିଟା, ଏଟାର୍‌ ପାଇ ଆରି ଗଟେକ୍‌ କାତା ସୁନା । ଦିନେକ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ସାକାଲ୍‌ ସାକାଲ୍‌ ତାର୍‌ ଅଙ୍ଗୁର୍‌ ବାଡେ କାମ୍‌ କରାଇବାକେ କୁଲିଆର୍‌ମନ୍‌କେ କଜ୍‌ବାର୍‌ ବାରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ସେ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ମିସ୍‌ଲା, ସେମନ୍‌କେ ଗଟେକ୍‍ ଦିନ୍‌କେ, ଗଟେକ୍‌ ଲାକା ରୁପାଟାଙ୍ଗା କୁଲି ଦେବାକେ ରାଜି କରି ତାର୍‌ ବାଡେ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ତାର୍‌ ପଚେ ସାକ୍‌ଲିଆ ନଅଟା ବେଲେ ଆଟେ ଜାଇ, ଗଟେକ୍‌ ଦଲର୍‍ ଲକ୍‌ କାଇ କାମ୍‌ ନ କରି ଟିଆଅଇ ରଇଲାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ସେ ଲକ୍‌ ସେମନ୍‌କେ କଇଲା, “ତମେ ମିସା ମର୍‌ ଅଙ୍ଗୁର୍‌ ବାଡେ ଜାଇ କାମ୍‌ କରା, ତମ୍‌କେ ମିସା ସମାନ୍‌ ଇସାବେ ବୁତି ଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ସେମନ୍‌ ଜାଇ କାମ୍‌ କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ସେନ୍ତାରିସେ ମୁଣ୍ଡ୍‌ବେଲାଇ, ଆଡ୍‌ବେଲାଇ ମିସା ଆରି କେତେଟା କୁଲିଆର୍‌ମନ୍‌କେ ଆନି କାମେ ମିସାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ସଞ୍ଜୁଆ ପାଁଚ୍‌ଟା ବେଲା ଆରି ତରେକ୍‌ ଆଟେ ଜାଇ ଆରି କେତେ ଲକ୍‌ ଚୁଚାଇ ଟିଆଅଇରଇବାଟା ଦେକ୍‌ଲା । ସେମନ୍‌କେ ପାଚାର୍‌ଲା “ଗୁଲାଇ ମୁଇଦାନ୍‌ କାମ୍‌ ନ କରି କାଇକେ ଇତି ଉଜେ ଉଜେ ଆଚାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ସେମନ୍‌ ତାକେ କଇଲାଇ, “ଆମ୍‌କେ ତା କେ ମିସା କାମେ ମିସାଅତ୍‌ ନାଇ ।” ସାଉକାର୍‌ ସେମନ୍‌କେ କଇଲା “ସେନ୍ତାର୍‌ଆଲେ ତମେ ସବୁ ଲକ୍‌ ମର୍‌ ଅଙ୍ଗୁର୍‌ ବାଡେ ଜାଇ କାମ୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","ସେ ଦିନେ ସଞ୍ଜ୍‌ ଅଇଲାକେ ଅଙ୍ଗୁର୍‌ ବାଡର୍‌ ସାଉକାର୍‌ ଗୁମୁସ୍‌ତାକେ କଇଲା, “କୁଲିଆର୍‌ମନ୍‌କେ ଡାକ୍‌ । ଜନ୍‌ ଲକ୍‌ମନ୍‌ ସବୁର୍‌ ପଚେ କାମ୍‌ ଦାର୍‌ଲାଇ, ସେମନ୍‌କେ ଆଗେ ବୁତି ଦେଇଦେସ୍‌ । ଜନ୍‌ ଲକ୍‌ମନ୍‌ ସବୁର୍‌ତେଇଅନି ପର୍‌ତୁମ୍‌ କାମେ ମିସି ଆଚତ୍‌, ସେମନ୍‌କେ ତାକର୍‌ ବୁତି ସାରାସାରି ପଚେ ଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ସଞ୍ଜୁଆ ପାଁଚ୍‌ଟା ବେଲେ କାମେ ମିସି ରଇଲାଇ ସେମନ୍‌କେ ସବୁ ଲକ୍‌କେ ଗଟେକ୍‌ ଗଟେକ୍‌ ରୁପା ଟାଙ୍ଗା ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପର୍‌ତୁମ୍‌ କାମ୍‌ ଆରାମ୍‌ କରି ରଇଲାଇ, ସେମନ୍‌କେ ଅଦିକ୍‌ ବୁତି ମିଲ୍‌ସି ବଲି ଆସା କଲାଇ । ମାତର୍‌ ସେମନ୍‌ ମିସା ଗଟେକ୍‌ସେ ରୁପା ଟାଙ୍ଗା ମିଲାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ସେମନ୍‌ ସେତ୍‌କି ନେଇ ମୁର୍‌ମୁରା ଅଇକରି ସାଉକାରର୍‌ ବିରୁଦେ କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“ସଞ୍ଜୁଆ ପାଁଚ୍‌ଟା ବେଲେ କାମ୍‌ ଆରାମ୍‌ କଲା କୁଲିଆର୍‌ମନ୍‌ ଏକାଇ ଗଟେକ୍‌ ଗଁଟାସେ କାମ୍‌ କଲାଇ ଆଚତ୍‌ । ଆମେ ଟାଇ ଟାଇ କାରାଇ, ଦିନ୍‌ଜାକ କଟ୍‌ଲୁ, ଏଲେ ମିସା ବୁତି ଦେବା ବେଲେ ଆମ୍‌କେ ମିସା ସେମନର୍‌ ସଙ୍ଗ୍‌ ସମାନ୍‌ କରିଦେଲାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ସାଉକାର୍‌ ସେମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌କେ କଇଲା, “ମଇତର୍‌ ମୁଇ ତମ୍‌କେ ନାଡାଇ ନାଇ । ଗଟେକ୍‌ ଦିନର୍‌ ବୁତି ପାଇ ଗଟେକ୍‌ ରୁପା ଟାଙ୍ଗା ନେଇ କାମ୍‌କର୍‌ବାକେ ତମେତା ସବୁ ଲକ୍‌ ରାଜି ଅଇରଇଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ତମର୍‌ ସେତ୍‌କି ବୁତି ଦାରି ଗରେ ଜାଆ । ତମ୍‌କେ ଜେତ୍‌କି ଦେଲି ଆଚି, ଗଟେକ୍‌ ଗଁଟା କାମ୍‌ କରିରଇବା ଲକ୍‌ମନ୍‌କେ ମିସା ସେତ୍‌କିସେ ଦେବାକେ ମର୍‌ ମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ମର୍‌ ନିଜର୍‌ ଦନ୍‌, ମୁଇ ଜେନ୍ତି ମନ୍‍ କଲିନି, ସେନ୍ତି କର୍‌ଚ କର୍‌ବାକେ ମର୍‌କାଇ ଅଦିକାର୍‌ ନାଇ କି ? କି ମୁଇ ଦାନ୍‌ ଇସାବେ ଦେଲିନି ବଲି ଆଁକାର୍‌ ଅଇଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ଜିସୁ ଏ କାତା କଇସାରାଇ କଇଲା, “ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଏବେ ପଚେ ଆଚତ୍‌ ସେମନ୍‌, ଆଗ୍‌ତୁ ଅଇବାଇ । ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଆଗ୍‌ତୁ ଆଚତ୍‌ ସେମନ୍‌ ପଚେ ସେ ରଇଜିବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ଜିସୁ ଜିରୁସାଲାମ୍‌ ଜିବା ବାଟେ ତାର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ଗଟେକ୍‌ ଲଗେ ଡାକି ନେଇ, କେ ନଇଲା ବେଲେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ସୁନା, ଆମେ ଜିରୁସାଲମେ ଗାଲୁନି । ତେଇ ନର୍‌ପିଲା ମୁଇ, ମୁକିଅ ପୁଜାରି ଆରି ଦରମ୍‌ ଗୁରୁମନ୍‍କେ ସର୍‌ପି ଅଇବି । ସେମନ୍‌ ମକେ ମରନ୍‌ ଡଣ୍ଡ୍‌ ଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ତାର୍‌ପଚେ ସେମନ୍‌ ମକେ, ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନ୍‍କେ ସର୍‌ପି ଦେବାଇ । ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନ୍‍, ମକେ କିଜାଇବାଇ, କର୍‌ଡା ସଙ୍ଗ୍‌ ମାର୍‌ବାଇ ଆରି କୁର୍‌ସେ ଚଗାଇବାଇ । ମାତର୍‌ ତିନ୍‌ଦିନ୍‌ ପଚେ ମୁଇ ଆରି ତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‍ବି ।” ");
INSERT INTO dso_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ସେଡିକିବେଲେ ଜେବଦିର୍‌ ମାଇଜି ତାର୍‌ ଦୁଇଟା ପିଲାମନର୍‌ ସଙ୍ଗ୍‌ ଜିସୁର୍‌ଲଗେ ଆସି ତାକେ ଜୁଆର୍‌କରି, ଗଟେକ୍‌ ବିସଇ ମାଙ୍ଗ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ଜିସୁ ତାକେ ପାଚାର୍‌ଲା, “ତୁଇ କାଇଟା ମନ୍‍ କଲୁସ୍‌ନି ?” ସେ କଇଲା, “ଜେଡେବଲ୍‌ ତମେ ତମର୍‌ ରାଇଜେ ରାଜା ଅଇସା, ମର୍‌ ଏ ଦୁଇଟା ପିଲାମନ୍‌କେ ତମର୍‌ ଡେବ୍‌ରି ବାଟେ ଆରି ଉଜା ବାଟେ ବସାଇବି ବଲି ମକେ କାତା ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ଜିସୁ ଜେବଦିର୍‌ ପିଲାମନ୍‌କେ କଇଲା, “ତମେ କାଇଟା ମାଗ୍‌ଲାସ୍‌ନି ସେଟା ବୁଜି ନାପାର୍‌ଲାସ୍‌ନି । ମୁଇ ଜନ୍‌ ଦୁକ୍‌ପୁରୁନ୍‌ ମୁତାର୍‌ ପାନି କାଇବାର୍‌ ଗାଲିନି, ତମେ କାଇ ପାରାସ୍‌ କି ?” ସେମନ୍‌ “ଉଁ” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ, ମର୍‌ ମୁତାର୍‌ ପାନି କାଇଲେ କାଇପାରାସ୍‌ । ମାତର୍‌ ମର୍‌ ଉଜା ବାଟେ ଆରି ଡେବ୍‌ରି ବାଟେ କେ ବସିପାରେ ସେଟା ବାଚ୍‌ବାକେ ମର୍‌ ଅଦିକାର୍‌ ନାଇ । ଜନ୍‌ ଲକ୍‌ମନର୍‌ ପାଇ ମର୍‌ ବାବା ସେ ଜାଗା ତିଆର୍‌ କଲା ଆଚେ, ସେଟା ସେମନର୍‌ ପାଇ ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ବିନ୍‌ ସିସ୍‌ମନ୍‌ ଜେଡେବେଲ୍‌ ଏ କାତା ସୁନ୍‌ଲାଇ, ସେ ଦୁଇ ବାଇର୍‍ ଲାଗି ବେସି ରିସା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ଜିସୁ ସିସ୍‌ମନ୍‌କେ ଗଟେକ୍‌ଟାନେ ଟୁଲ୍‌କରି କଇଲା, “ତମେତା ଜାନାସ୍‌ ଏ ଦୁନିଆର୍‌ ରାଜାମନ୍‌ ବିନ୍‌ ଲକ୍‍ମନ୍‍କେ ନିଜର୍‌ ଅଦିକାର୍‌ କରିରଇବାଇ । ବଡ୍‌ ବଡ୍‌ ନେତାମନ୍‌ ମିସା ବିନ୍‌ ଲକ୍‌ମନ୍‍କେ ସାସନ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ମାତର୍‌ ତମେ ସେନ୍ତାର୍‌ ଉଆନାଇ । ତମର୍‌ ବିତ୍‌ରେ ଗଟେକ୍‌ ଲକ୍‌ ବଡ୍‌ ଅଇବାକେ ମନ୍‌ କଲାନି ବଇଲେ, ସେ ସବୁଲକର୍‌ ସେବା କର୍‌ବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ତମର୍‌ ବିତ୍‌ରେ ଜେ ମୁକିଅ ଅଇବାକେ ମନ୍‌ କଲାସ୍‌ନି, ସେ ବିନ୍‌ ଲକର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ପାରା ଅଇ ସେମନର୍‌ ସେବା କର । ");
INSERT INTO dso_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ଜେନ୍ତାରି କି ପର୍‌ମେସର୍‌ ପାଟାଇଲା ନର୍‌ପିଲା ମୁଇ ମିସା ସେବା ମିଲ ବଲି ଆସି ନାଇ, ମାତର୍‌ ବିନ୍‌ ଲକ୍‌ମନର୍‌ ସେବା କରି ସେମନ୍‌କେ ମୁକ୍‌ତି ମିଲ ବଲି ନିଜର୍‌ ଜିବନ୍‌ ଦେବାକେ ଆଇଲି ଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ଦିନେକ୍‌ ଜିସୁ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଜିରିଅ ସଅର୍‌ ଚାଡିକରି ଜିବାବେଲେ କେତେ କେତେ ଲକ୍‌ମନ୍‌ ତାର୍‌ ପଚେ ପଚେ ଇଣ୍ଡ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ଆରି ଏଦେ ଦେକା ! ବାଟ୍‍ପାଲି ବସି ରଇବା ଦୁଇଟା କାଣା, ଜିସୁ ସେ ବାଟେ ଆଇଲାନି ବଲି ସୁନି, ଆକ୍‌ମାରି ଡାକ୍‌ଲାଇ, “ଏ ମାପ୍‌ରୁ ଦାଉଦର୍‌ ପଅ ! ଆମ୍‌କେ ଦୟା କର ।” ");
INSERT INTO dso_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ଲକ୍‌ମନ୍‌ ସେମନ୍‌କେ ଦମ୍‌କାଇ କରି ଚୁପ୍‌ଅଇ ରଇବାକେ କଇଲାଇ । ମାତର୍‌ ସେମନ୍‌ ଅଦିକ୍‌ ଅଦିକ୍‌ ଆକ୍‌ମାରି କଇଲାଇ, “ଏ ମାପ୍‌ରୁ, ଦାଉଦର୍‌ ପଅ ! ଆମ୍‌କେ ଦୟା କର ।” ");
INSERT INTO dso_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ଜିସୁ ତେଇ ଟିଆଅଇ ସେମନ୍‌କେ ଡାକି ପାଚାର୍‌ଲା, “ମୁଇ ତମର୍‌ ପାଇ କାଇଟା କର୍‌ବି ବଲି ମନ୍‌ କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ସେମନ୍‌ କଇଲାଇ, “ମାପ୍‌ରୁ ଆମ୍‌କେ ଦେକ୍‌ବା ବପୁ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ଜିସୁ ସେମନର୍‌ ପାଇ ଦୟା ଅଇ, ତାକର୍‍ ଆଁକି ଚିଇଲା । ସେ ଦାପ୍‌ରେସେ ସେମନ୍‌ ଦେକିପାର୍‌ଲାଇ ଆରି ଜିସୁର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜିରୁସାଲାମ୍‌ ଲଗାଲଗି ଅଇ କଣ୍ଡେକ୍‌ ଦୁର୍‌ ଜାଇ ଡଙ୍ଗର୍‌ଲଗେ ରଇଲା ବେତ୍‌ପାଗି ଆରି ବେତିନିଆ ନାଉଁର୍‌ ଗାଏଁ କେଟ୍‌ଲାଇ । ତାର୍‍ ଦୁଇଟା ସିସ୍‌ମନ୍‌କେ ଆଦେସ୍‌ ଦେଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ତମେ ମୁଆଟେ ରଇଲା ସେ ଗାଏଁ ଜାଆ । ତେଇ କେଟ୍‌ଲା ଦାପ୍‌ରେ, ଗଟେକ୍‌ ଗଦ ବାନ୍ଦିଅଇ ରଇବାଟା ଦେକ୍‌ସା ଆରି ତାର୍‌ ଲଗେ ତାର୍‌ ପିଲା ଆଚେ । ସେମନ୍‌କେ ମେଲି ମର୍‌ଲଗେ ଦାରି ଆସା । ");
INSERT INTO dso_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","କେ ଜଦି କାଇ ବଲି ପାଚାର୍‌ଲେ କଇସା, ‘ଏଟା ସାଉକାର୍‌କେ ଦର୍‌କାର୍‌ ଆଚେ ।’ ସେଡ୍‌କି ଦାପ୍‌ରେ ସେ ଗଦମନ୍‌କେ ଚାଡିଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ଏ ଗଟ୍‍ନାଅନି ବାବବାଦିମନ୍‌ ଲେକି ରଇଲା କାତା ସିଦ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ ସିଅନ୍‌ ଗଡେ କୁଆ ! ଦେକା, ତମର୍‌ ରାଜା ତମର୍‌ ଲଗେ ଆଇଲାନି, ସେ କେଡେ ସୁଆଲ୍‌ ଗଦପିଲାର୍‌ ପିଟିତେଇ ବସ୍‌ଲାଆଚେ ଦେକା, ସେ ଗଦପିଲା ଉପ୍‌ରେ ବସିଆଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ସିସ୍‌ମନ୍‌ ଜାଇ ଜିସୁ କଇବା ଇସାବେ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଗଦ ଆରି ତାର୍‌ ପିଲାକେ ଦାରି ଆସି ତାକର୍‌ ଉପ୍‌ରେ ଲୁଗାମନ୍‌ ଅଚାଇ ଦେଲାଇ ଆରି ଜିସୁ ଗଦ ଉପ୍‌ରେ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ ଜିସୁ ଜିବା ବାଟେ ନିଜର୍‌ ନିଜର୍‌ ପଚିଆମନ୍‌ ଅଚାଇ ଦେଲାଇ ଆରି କେତେକ୍‌ ଲକ୍‌ମନ୍‌ କଜ୍‌ରି ଡାଲ୍‌ ଆନି କରି ସେ ବାଟେ ଅଚାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଜିସୁର୍‌ ଆଗ୍‌ତୁବାଟେ ଆରି ପଚ୍‌ବାଟେ ଜାଇତେ ରଇଲା ଲକ୍‌ମନ୍‌ ଆକ୍‌ମାରି କରି କଇଲାଇ, “ଦାଉଦର୍‌ ପଅକେ ଡାକ୍‌ପୁଟା କରା, ଜେ ମାପ୍‌ରୁର୍‌ ନାଉଁ ଦାରି ଆଇଲାନି ତାକେ ପର୍‌ମେସର୍‌ ଆସିର୍‌ବାଦ୍‌ କର । ପର୍‌ମେସରର୍‌ ଡାକ୍‌ପୁଟା କରା ।” ");
INSERT INTO dso_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ଜିସୁ ଜିରୁସାଲାମ୍‌ କେଟ୍‌ଲାଦାପ୍‌ରେ ସେ ଗଡର୍‌ ଲକ୍‌ମନ୍‌ ଜିସୁ କେ ? ବଲି କରି ଗୁଲାଇ ବାଟେ ଉଡ୍‌ରା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ଲକ୍‌ମନ୍‌ ପାଚାର୍‌ଲାଇ, “ସେ କେ ?” ବିନ୍‌ ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ସେ ଅଇଲାନି ଗାଲିଲି ରାଇଜେ ରଇବା ନାଜରିତ୍‌ ଗଡର୍‌ ବବିସତ୍‌ବକ୍‌ତା ଜିସୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ପୁରିକରି ତେଇ ଗେନା ବିକା କର୍‌ତେ ରଇବା ସବୁ ଲକ୍‌ମନ୍‌କେ ବାର୍‌କରାଇ ଦେଲା । ଡାବୁ ବାଦ୍‌ଲାଉମନର୍‌ ଟେବୁଲ୍‌ ଆରି ପରୁଆ ବିକୁମନର୍‌ ବସ୍‌ବାଟା ପାସ୍‌ଲାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଦରମ୍‌ ସାସ୍‌ତରେ ଲେକା ଆଚେ, ମର୍‌ ମନ୍ଦିର୍‌ ପାର୍‌ତନା ଗର୍‌ ବଲି ନାଉଁ ଅଇସି । ମାତର୍‌ ତମେ ତାକେ ଚର୍‌ମନର୍‌ ଆକାଡା ସାଲ୍‌ ପାରା କରିଆଚାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ଜିସୁ ମନ୍ଦିରେ ରଇଲାବେଲେ କାଣାମନ୍‌ ଆରି ମେଟାମନ୍‌ ତାର୍‌ ଲଗେ ଆଇଲାଇ ଆରି ସେ ସେମନ୍‌କେ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ଦରମ୍‌ ଗୁରୁମନ୍‌ ତାର୍‌ କାବା ଅଇଜିବା କାମ୍‌ ସବୁ ଦେକି ଆରି ପିଲାମନ୍‌ ଦାଉଦର୍‌ ପଅର୍‌ ଜୟ ଜୟ ଅ, ବଲି କଇବାଟା ସୁନି ରିସା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ସେମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏମନ୍‌ କାଇବଲି କଇଲାଇନି ତୁଇ ସୁନି ପାର୍‌ଲୁସ୍‌ନି ?” ଜିସୁ କଇଲା, “ଉଁ ସୁନ୍‌ଲିନି । ଦରମ୍‌ ସାସ୍‌ତରେ କାଇ ଏ କାତା ପଡାସ୍‌ ନାଇ କି ? ‘ତମେ ପିଲାମନ୍‌କେ ଆରି କଅଁଲା ପିଲାମନ୍‌କେ ଟିକ୍‌ ଇସାବେ ଆରାଦନା କର୍‌ବାକେ’ ସିକାଇଆଚାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ଏ କାତା କଇକରି ଜିସୁ ସେମନ୍‌କେ ଚାଡି ଜିରୁସାଲମେଅନି ବେତ୍‌ନିଆଇ ଗାଲା । ସେ ତେଇ ଗଟେକ୍‍ ରାତି ବିତାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଜିସୁ ସାକାଲ୍‌ ସାକାଲ୍‌ ଜିରୁସାଲାମ୍‌ ବାଉଡ୍‌ଲା ବେଲେ ତାକେ ବୁକ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ବାଟ୍‍ପାଲି ଗଟେକ୍‌ ଡୁମ୍‌ରି ଗଚ୍‌ ରଇଲା । ଜିସୁ ସେ ଗଚ୍‌ ଲଗେ ଜାଇ ତେଇ ପତର୍‌ ରଇବାଟା ଚାଡି, ଆରି କାଇଟା ଦେକେ ନାଇ । ତେବେ ସେ ଗଚ୍‌କେ କଇଲା, “ତୁଇ ଆରି କେବେ ମିସା ପଲ୍‌ ନ ଦାରୁସ୍‌ !” ସେ ଦାପ୍‌ରେ ସେ ଡୁମ୍‌ରି ଗଚ୍‌ ସୁକିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ଏଟା ଦେକିକରି ସିସ୍‌ମନ୍‌ କାବା ଅଇଜାଇ ପାଚାର୍‌ଲାଇ, “ଏ ଗଚ୍‌ ଏତେକ୍‌ ଦାପ୍‌ରେ କେନ୍ତି ସୁକିଗାଲା ?” ");
INSERT INTO dso_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ଜିସୁ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ତମର୍‌ ମନେ ଅଇସି କି ନ ଅଏ ବଲି ଅଲପ୍‌ ମିସା ନ ବାବିକରି ଜଦି ପୁରାପୁରୁନ୍‌ ବିସ୍‌ବାସ୍‌ କର୍‌ସା ବଇଲେ ମୁଇ ଏ ଡୁମ୍‌ରି ଗଚ୍‌କେ ଜେନ୍ତି କରିଆଚି, ତମେ ମିସା ସେନ୍ତି କରିପାରାସ୍‌ । ସେତ୍‌କି ଆକା ନଏଁ, ଏ ଡଙ୍ଗର୍‌ ଉଲ୍‌ଟିକରି ସମ୍‌ଦୁରେ ଜାଇ ଅଦର୍‌ ବଲି କଇଲେ ମିସା ସେଟା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ତମେ ବିସ୍‌ବାସ୍‌ କରି ପାର୍‌ତନାଇ ଜନ୍‌ଟା ମାଙ୍ଗ୍‌ସା, ସେଟା ମିଲ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ଜିସୁ ମନ୍ଦିରେ ବାଉଡି ଆସି ତେଇ ସିକିଆ ଦେଇତେ ରଇଲା ବେଲେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ, “କାଇ ଅଦିକାରେ ତୁଇ ଏ ସବୁ କାମ୍‌ କଲୁସ୍‌ନି ? ତକେ ଏ ଅଦିକାର୍‌ କେ ଦେଲା ?” ");
INSERT INTO dso_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ଜିସୁ କଇଲା, “ମୁଇ ମିସା ତମ୍‌କେ ଏକାଇ ଗଟେକ୍‌ ସେ ପର୍‌ସନ୍‌ ପାଚାର୍‌ବି । ତାର୍‌ ଉତର୍‌ ଦେଇ ପାର୍‌ଲେ ମୁଇ କାଇ ଅଦିକାରେ ଏ ସବୁ କାମ୍‌ କଲିନି, ତମ୍‌କେ କଇଦେବି । ");
INSERT INTO dso_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ଜଅନ୍‌ ଡୁବନ୍‌ ଦେବା ଅଦିକାର୍‌ କାର୍‌ଟାନେଅନି ମିଲାଇ ରଇଲା ? ସର୍‌ଗେଅନି କି ମୁନୁସ୍‌ ମନର୍‌ଟାନେଅନି ?” ସେମନ୍‌ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ “ଏ ବିସଇ ନେଇ କାଇବଲି କଉଁ ? ଜଦି ପର୍‌ମେସରର୍‌ ଟାନେଅନି ବଲି କଇଲେ, ତେବେ ସେ ଆମ୍‌କେ ‘ଜଅନ୍‌କେ କାଇକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ ?’ ବଲି କଇସି । ");
INSERT INTO dso_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ଜଦି ଲକ୍‌ମନର୍‌ ଟାନେଅନି ବଲି କଇଲେ, ତେବେ ଲକ୍‌ମନ୍‌କେ ଡର୍‌ ଲାଗ୍‌ଲାନି । କାଇକେ ବଇଲେ ଜଅନ୍‌ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ବଲି ସେମନ୍‌ ସବୁଲକ୍‌ ବିସ୍‌ବାସ୍‌ କଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ସେଟାର୍‌ପାଇ ସେମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ଆମେ ନାଜାନୁ ।” ଜିସୁ ସେମନ୍‌କେ କଇଲା, “କନ୍‌ ଅଦିକାରେ ଏ ସବୁ କଲିନି ସେଟା ମୁଇ ମିସା ତମ୍‌କେ ନ କଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ଆଲେ ଏ ବିସଇ ତମେ କାଇ ବଲି ବାବ୍‌ଲାସ୍‌ନି କଇଦେକା ପନି ? ଗଟେକ୍‌ ଲକର୍‌ ଦୁଇଟା ପଅମନ୍‌ ରଇଲାଇ । ଦିନେକ୍‌ ସେ ଲକ୍‌ ତାର୍‌ ବଡ୍‌ ପଅକେ କଇଲା, “ନୁନାରେ, ଆଜି ଆମର୍‌ ଅଙ୍ଗୁର୍‌ ବାଡେ ଜାଇ ପାଇଟି କର୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘ନାଇ ମୁଇ ନ କରି’ ବଲି ବଡ୍‌ ପଅ କଇଲା । ମାତର୍‌ ପଚେ ମନ୍‌ ବାଦ୍‌ଲାଇ ପାଇଟି କର୍‌ବାର୍‌ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ସେ ଲକ୍‌ ସାନ୍‌ ପଅକେ ମିସା ସେ କାମ୍‌ କର୍‌ବାକେ କଇଲା । ‘ଉଁ ବାବା ଗାଲିନି’ ବଲି ସାନ୍‌ ପଅ କଇଲା । ମାତର୍‌ ସେ କାମ୍‌ଟାନେ ମୁଲ୍‌କେ ଜାଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","କଇଦେକା ପନି, ଏ ଦୁଇଟା ପଅର୍‌ ବିତ୍‌ରେ କେ ତାର୍‌ ବାବା ତିଆର୍‌ଲାଟା ମାନିରଇଲା ?” ସେମନ୍‌ କଇଲାଇ, “ବଡ୍‌ ପଅ ।” ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ସତ୍‌ କଇଲିନି ସିସ୍‌ତୁ ମାଙ୍ଗୁମନ୍‌ ଆରି ବେସିଆମନ୍‌ ତମର୍‌ଟାନେଅନି ପରମେସରର୍‌ ରାଇଜେ ଆଗ୍‌ତୁ କେଟ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ତମର୍‌ଟାନେ ଆସି ଦରମର୍‌ ବାଟ୍‌ ଦେକାଇ ଦେଇରଇଲା, ମାତର୍‌ ତମେ ତାକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ, ମାତର୍‌ ସିସ୍‌ତୁ ମାଙ୍ଗୁମନ୍‌ ଆରି ବେସିଆମନ୍‌ ତାର୍‌ କଇଲା କାତା ବିସ୍‌ବାସ୍‌ କଲାଇ । ଏଟା ଦେକିକରି ମିସା ପଚେ ତମେ ପାପ୍‌ କାମ୍‌କର୍‌ବାଟା ଚାଡି ମନ୍‌ ବାଉଡାଇ ତାକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ଜିସୁ କଇଲା, “ଆରି ଗଟେକ୍‌ କାତା ସୁନା, ଗଟେକ୍‌ ସାଉକାର୍‌ ତାର୍‌ ଜମିଟାନେ ଅଙ୍ଗୁର୍‌ ଚାସ୍‌ କରିରଇଲା । ତେଇ ଚାରିବେଟ୍‌ତି ବାଡ୍‌ ବୁନ୍‌ଲା ଆରି ଅଙ୍ଗୁର୍‌ ପିଲ୍‌ବାକେ ଗଟେକ୍‌ କୁଣ୍ଡ୍‌ ତିଆର୍‌କଲା । ଆରି ଜାଗୁଆଲିର୍‌ ପାଇ ଗଟେକ୍‌ ମାଚା ମିସା ତିଆର୍‌ କରିଦେଲା । ତାର୍‌ ପଚେ ସେ ଜମି, ଚାସିମନ୍‌କେ ଆଦିବାଗ୍‌ ଇସାବେ ଦେଇକରି, ସାଉକାର୍‌ ବିଦେସେ ଉଟିଗାଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ଅଙ୍ଗୁର୍‌ ତଲ୍‌ବାବେଲେ ସେ ସାଉକାର୍‌ ତାର୍‌ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ନିଜର୍‌ ଆଦିବାଗ୍‌ ମାଙ୍ଗ୍‌ବାକେ ଚାସିମନର୍‌ ଲଗେ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ଚାସିମନ୍‌ ସେ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ଦାରି, ଗଟେକ୍‌ ଲକ୍‌କେ ମାର୍‌ଲାଇ, ଆରି ଗଟେକ୍‌ ଲକ୍‌କେ ମରାଇଲାଇ, ଆରି ଗଟେକ୍‌ ଲକ୍‌କେ ପାକ୍‌ନାସଙ୍ଗ୍‌ ମାରିପାକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ଏଟାର୍‌ ପାଇ ଜମି ସାଉକାର୍‌ ଆଗର୍‌ତେଇଅନି ଅଦିକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ପାଟାଇଲା । ବାଗ୍‌ ଚାସିମନ୍‌ ସେମନ୍‌କେ ମିସା ସେନ୍ତାରିସେ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ସାରାସାରି ପଚେ ପଦା ସାଉକାର୍‌ ଚାସିମନର୍‌ଟାନେ ତାର୍‌ପିଲାକେ ପାଟାଇଲା । ସେ ବାବ୍‌ଲା, ସେମନ୍‌ ମର୍‌ ପିଲାକେ ବାଦିଅରେ ନାମ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ମାତର୍‌ ଚାସିମନ୍‌ ସାଉକାରର୍‌ ପଅକେ ଦେକିକରି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ଏଦେ ଦେକା, ସାଉକାରର୍‌ ପିଲା ! ଆସା ଆକେ ମିସା ମାରିପାକାଉ । ଏନ୍ତାର୍‌ କଲେ ଆକା ସାଉକାରର୍‌ ଦନ୍‌ ଆମର୍‌ଟା ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ଏନ୍ତାରି କଇକରି ସେମନ୍‌ ତାକେ ଜମିତେଇଅନି ଦାରି ବାର୍‌କରାଇ, ବାଇରେ ନେଇ ମାରି ମରାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ଜିସୁ ପାଚାର୍‌ଲା, “ଜେଡେବେଲ୍‌ ଜମି ସାଉକାର୍‌ ଆଇସି ସେ ଚାସିମନ୍‌କେ କାଇଟା କର୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ସେମନ୍‌ କଇଲାଇ “ବଦ୍‌ମାସ୍‌ମନ୍‌କେ ମାରି ମରାଇସି । ଆରି ଜନ୍‌ ଚାସିମନ୍‌ ସମାନ୍‌ ବେଲାଇ ତାର୍‌ ଆଦିବାଗ୍‌ ଦେବାଇ, ସେ ଜମି ସେମନର୍‌ ଆତେ ଜିମା ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏ ସାସ୍‌ତରର୍‌ କାତା କାଇ କେବେ ତମେ ପଡାସ୍‌ ନାଇ କି ? “ଗର୍‌ବାନ୍ଦୁମନ୍‌ ଜନ୍‌ ପାକ୍‌ନା ଲଡାକେ ନ ଅଏ ବଲି ଚାଡିଦେଇ ରଇଲାଇ, ସେଟାସେ ଗର୍‌ କନର୍‌ ମୁକିଅ ପାକ୍‌ନା ଅଇଲା । ନିଜେ ମାପ୍‌ରୁଆକା ଏଟା କଲା ଆଚେ । ତାର୍‍ କାମ୍‌ କେତେକ୍‌ କାବାଅଇଜିବା କାମ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ଜିସୁ ଆରି କଇଲା, “ସେଟାର୍‌ ପାଇ ତମ୍‌କେ କଇଲିନି, ପର୍‌ମେସରର୍‌ ରାଇଜେ ପୁର୍‌ବା ଅଦିକାର୍‌ ତମର୍‌ତେଇଅନି ଦାରିଜିବାଇ ଆରି ଜନ୍‌ ଦଲ୍‌ ଏ ରାଇଜର୍‌ ନିମାନ୍‌ ପଲ୍‌ ଦେକାଇ ପାର୍‌ବାଇ, ସେମନ୍‌କେ ସେଟା ଦିଆଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ଆରି ଜେ ଏ ପାକ୍‌ନା ଉପ୍‌ରେ ଅଦର୍‌ସି, ସେ କଣ୍ଡ୍‌ କଣ୍ଡ୍‌ ଅଇଜାଇସି । ଆରି ଏ ପାକ୍‌ନା ଜାର୍‌ ଉପ୍‌ରେ ଅଦର୍‌ସି, ସେଟା ତାକେ ଚାପି କରି ଗୁଣ୍ଡ୍‍ କରି ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ଏ କାତା ସୁନି, ଜିସୁ ସେମନ୍‌କେ ଦେକାଇ କରି କଇଲାନି ବଲି ବୁଜିପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ତାକେ ବାନ୍ଦାଇ ନେବାକେ ଚେସ୍‌ଟା କଲାଇ, ମାତର୍‌ ଲକ୍‌ମନ୍‌କେ ଡରି ସେମନ୍‌ ସେଟା କରି ନାପାର୍‌ଲାଇ, କାଇକେବଇଲେ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଗଟେକ୍‌ ବବିସତ୍‍ବକ୍‍ତା ବଲି ମନେ ବାବ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଜିସୁ ଆରିତରେକ୍‌ ଉଦାଅରଣ୍‌ ଦେଇ ଲକ୍‌ମନ୍‌କେ ସିକିଆ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","ପର୍‌ମେସରର୍‌ ସରଗ୍‌ ରାଇଜ୍‌ ଏନ୍ତାରି । ତରେକ୍‌ ଗଟେକ୍‌ ରାଜା ତାର୍‌ ପିଲାର୍‌ପାଇ ବଜି କରାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ବିବା ବଜିଟାନେ କବର୍‌ ଦେଇରଇଲା, ସେମନ୍‌କେ ଡାକିଆନ୍‌ବାକେ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ପାଟାଇଲା । ମାତର୍‌ ସେମନ୍‌ ନିଚ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ବିବାଟାନେ ଗାଗଡ୍‌ ଚେଲିମନ୍‌କେ ମାରି ବଜି ଅଇଲା ଆଚେ । ଦାପ୍‌ରେ ଆସା ବଲି ରାଜା ଆରି ତରେକ୍‌ ବିନ୍‌ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ କଇପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ମାତର୍‌ କବର୍‌ ପାଇରଇଲା ଲକ୍‌ମନ୍‌ ଏ କାତା ନ ମାନିକରି ନିଜର୍‌ ନିଜର୍‌ ପାଇଟି କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । କେତେ ଲକ୍‌ ବାରଇକରି ପଦାଇ ଉଟିଗାଲାଇ । ଆରି କେତେକ୍‌ ଲକ୍‌ ତାକର୍‌ ଦୁକାନେ ଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ଆରି କେତେ ଲକ୍‌ ରାଜାର୍‌ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ଦାରି ମାରି ମରାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ରାଜା ରିସାଅଇଜାଇ କରି ସଇନମନ୍‌କେ ପାଟାଇଲା । ସଇନମନ୍‌ ଜାଇକରି ସେ ମାରୁମନ୍‌କେ ମରାଇ ପାକାଇଲାଇ ଆରି ସେମନ୍‌ ରଇଲା ସଅର୍‌ ପଡାଇ ପାକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ତାର୍‌ ପଚେ ରାଜା ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ଡାକି କଇଲା, ବିବା ବଜିର୍‌ ରାନ୍ଦାବାଡା ସାର୍‌ଲାବେ ମାତର୍‌ ମୁଇ କବର୍‌ ଦେଇରଇଲା ଲକ୍‌ମନ୍‌ ଏ ବଜି କାଇବାକେ ବାଗ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ଏବେ ତମେ ଜାଇକରି ଗାଉଁପାଲିର୍‌ ଗୁଡା ଆରି ପୁଟ୍‌ମନ୍‌କେ, ଜେତ୍‌କି ଲକ୍‌କେ ବେଟ୍‌ ଅଇସା ସେ ସବୁ ଲକ୍‌ମନ୍‌କେ ଆମର୍‌ ବଜିଟାନେ ଡାକିଆନା । ");
INSERT INTO dso_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ତେବେ ଦାଙ୍ଗ୍‌ଡାମନ୍‌ ଲଗର୍‌ ପାକର୍‌ ଗାଉଁମନ୍‌କେ ବୁଲି ନିକ ଲକ୍‌ ଅଅତ୍‌ କି ବାନିଆ ଲକ୍‌ ଅଅତ୍‌ ଜେତ୍‌କି ଲକ୍‌କେ ବେଟ୍‌ ଅଇଲାଇ, ସବୁକେ ଡାକି ଆନ୍‌ଲାଇ । ଆରି ବିବା ଗରେ ଲକ୍‌ମନ୍‌ ମାଣ୍ଡାଚୁଣ୍ଡା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","ପଚେ ରାଜା ଡାକାଇଲା ଲକ୍‌ମନ୍‌କେ ଦେକ୍‌ବାର୍‌ ଆଇଲା । ସେ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅନି ଗଟେକ୍‌ ଲକ୍‌ ତିଆର୍‌ପିଆର୍‌ ନ ଅଇକରି ନିକଟା ପିନ୍ଦି ନ ଆସିରଇଲାଟା ରାଜା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ରାଜା ତାର୍‌ ଲଗେ ଜାଇ ପାଚାର୍‌ଲା, “ମଇତର୍‌, ତୁଇ ତିଆର୍‌ ପିଆର୍‌ ନ ଅଇତେ କେନ୍ତି ଏ ବଜିଟାନେ ଆଇଲୁସ୍‌” ସେ ଲକ୍‌ ଚିମ୍‌ରା ଅଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ରାଜା ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ କଇଲା, “ତାର୍‌ ଆତ୍‌ ଗଡ୍‌ ବାନ୍ଦି ବାଇରେ ନେଇ ଆନ୍ଦାରେ ପିଙ୍ଗିଦିଆସ୍‌ । ତେଇ ସେ ଦାଁତ୍‌ମୁଣ୍ଡ୍‌ କାତ୍‌ରିଅଇ କାନ୍ଦି କାନ୍ଦି ରଅ ।” ");
INSERT INTO dso_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ଜିସୁ କାତାନି କଇସାରାଇ କଇଲା, ବେସି ଲକ୍‌କେ ଡାକ୍‌ବାଇ, ମାତର୍‌ ଉନାଲକ୍‌କେ ବାଚ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","କେତେଟା ପାରୁସିମନ୍‌ ଜାଇକରି ଜିସୁକେ ପର୍‌ସନ୍‌ ପାଚାରି ପାନ୍ଦେ ପାକାଉଁ ବଲି ବାବ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ସେମନ୍‌ ତାକର୍‌ କେତେଟା ସିସ୍‌ମନ୍‌କେ ଆରି ଏରଦର୍‌ ଦଲେଅନି କେତେଟା ଲକ୍‌ମନ୍‌କେ ଜିସୁର୍‌ ଲଗେ ପାଟାଇଲାଇ । ଏମନ୍‌ ଆସି ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଗୁରୁ, ତମେ ସତ୍‌ କଇସା ଆରି ପର୍‌ମେସରର୍‌ ସତ୍‌ ବିସଇ ସିକିଆ ଦେବାଟା ଆମେ ଜାନୁ । ତମେ ମୁନୁସ୍‌ମନର୍‌ ମର୍‌ଜିତାକେ କାତୁର୍‌ କରାସ୍‌ ନାଇ । ଲକ୍‌ମନ୍‌ କାଇ ବଲି ବାବ୍‌ବାଇ ବଲି ଚିନ୍ତା କରାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ତେବେ କଇଦେକା ପନି, ଏ ବିସଇ ତମେ କାଇବଲି କଇଲାସ୍‌ନି ? ରମିୟ ସର୍‌କାର୍‌କେ ସିସ୍‌ତୁ ଦେବାଟା ଆମର୍‌ ଦରମ୍‌ ସାସ୍‌ତରର୍‌ ଇସାବେ ଟିକ୍‌ କି ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ମାତର୍‌ ଜିସୁ ସେମନର୍‌ କୁଟ୍‌କାତା ଜାନି କରି କଇଲା, “ଏ କୁଟିଆଲ୍‌ମନ୍‌, କାଇକେ ମକେ ପାନ୍ଦେ ପାକାଇବାକେ ଚେସ୍‌ଟା କଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ଜନ୍‌ ଅଦ୍‌ଲି ଡାବୁ ସିସ୍‌ତୁ ଦେଲାସ୍‌ନି, ତେଇଅନି ଗଟେକ୍‌ ଆନିକରି ମକେ ଦେକାଆ ।” ସେମନ୍‌ ଗଟେକ୍‌ ଅଦ୍‌ଲି ଆନି ତାକେ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା “ଏ ଅଦ୍‌ଲି ଡାବୁଟାନେ କାର୍‌ ମୁଉ ଆରି ନାଉଁ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ସେମନ୍‌ କଇଲାଇ, “ରମିୟ ରାଜାର୍‌ ମୁଉ ଆରି ନାଉଁ ଆଚେ ।” ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତେବେ ଜନ୍‌ଟା ରମିୟ ରାଜାର୍‌ଟା, ସେଟା ତାକେ ଦିଆସ୍‌ ଆରି ଜନ୍‌ଟା ପରମେସରର୍‌ଟା, ସେଟା ପରମେସର୍‌କେ ଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ଏ କାତା ସୁନି ସେମନ୍‌ କାବାଅଇଗାଲାଇ ଆରି ତେଇଅନି ଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ସେ ଦିନେ ସାଦୁକି ଦଲର୍‌ କେତେ ଲକ୍‌ ଜିସୁର୍‌ ଲଗେ ଆଇଲାଇ । ସାଦୁକିମନ୍‌ ମରିଗାଲେ ଆରି ତରେକ୍‌ ଉଟି ନଏଁ ବଲି ବିସ୍‌ବାସ୍‌ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ସେମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏ ଗୁରୁ, ଜଦି ଗଟେକ୍‌ ଲକ୍‌ ପିଲାଟକି ନ ଅଇତେ ମରିଜାଇସି, ତେବେ ମରିଜାଉର୍‌ ବାଇ ସେ ରାଣ୍ଡି ମାଇଜିକେ ସଙ୍ଗଇସି । ଆରି ତାକର୍‌ ଟାନେଅନି ଅଇଲା ପିଲାଜିଲା ସେ ମଲା ଲକର୍‌ପାଇ ଅଇସି ବଲି ମସା ନିୟମ୍‌ କଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ଗଟେକ୍‌ କାତା ସୁନା । ଇତି ଆମର୍‌ ବିତ୍‌ରେ ସାତ୍‌ବାଇ ରଇଲାଇ । ବଡ୍‌ ବାଇ ପିଲାଜିଲା ନ ଅଇତେ ମରିଗାଲାଜେ ତାର୍‌ ପିଟିର୍‌ ବାଇ ତାର୍‌ ବଉକେ ସଙ୍ଗଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ମାତର୍‌ ବଡ୍‌ମଜିଆ, ମଜିଆ, ସାନ୍‌ମଜିଆ ଏନ୍ତି ଅଇକରି ସାରାସାରି ସାନର୍‌ ଦସା ମିସା ଏନ୍ତି ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ସାରାସାରି ପଚେ ସେ ମାଇଜି ମିସା ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ଜେବେ ମଲା ଲକ୍‌ମନର୍‌ ଉଟ୍‌ବା ଦିନ୍‌ ଆଇସି, ତେବେ ଏ ମାଇଜି କାର୍‌ ମାଇଜି ଅଇସି ? ସବୁ ଲକ୍‌ସେ ତାକେ ସଙ୍ଗଇ ରଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ କେତେକ୍‌ ବୁଲ୍‌ ବିସଇ ବାବ୍‌ବା ଲକ୍‌ମନ୍‌ ! ଦରମ୍‌ ସାସ୍‌ତରେ ପର୍‌ମେସରର୍‌ ବପୁ ବିସଇ ସମାନ୍‍ ଇସାବେ ଚିନ୍‌ତା କରାସ୍‌ ନାଇଜେ, ତମେ ଏ କାତା ପାଚାର୍‌ଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ମରିକରି ଉଟ୍‌ଲା ପଚେ, ମଲା ଲକ୍‌ମନ୍‌ ସରଗର୍‌ ଦୁତ୍‌ମନର୍‌ ପାରା ଅଇଜିବାଇ । ସେମନ୍‌ ଆରି ବିବା ନ ଅଅତ୍‌ କି ନ କରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ମଲା ଲକ୍‌ମନ୍‌ ଆରି ତରେକ୍‌ ଉଟ୍‌ବା ବିସଇ, ପରମେସର୍‌ ଜନ୍‌ଟା କଇଲା ଆଚେ, ତମେ କାଇ ସାସ୍‌ତରେ କେବେ ପଡାସ୍‌ ନାଇ କି ? ");
INSERT INTO dso_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ପର୍‌ମେସର୍‌ କଇଲା ଆଚେ “ଆମେ ଅବ୍‌ରାଆମର୍‍, ଇସାକର୍‌ ଆରି ଜାକୁବର୍‌ ମାପ୍‌ରୁ ।” “ପର୍‌ମେସର୍‌ ତା ଜିବନ୍‌ ରଇଲା ଲକ୍‌ମନର୍‌ ମାପ୍‌ରୁ, ମଲା ଲକ୍‌ମନର୍‌ ଅଇନାପାରେ ।” ");
INSERT INTO dso_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ସିକାଇବାଟା ସୁନିକରି କାବାଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ଜିସୁ ସାଦୁକିମନ୍‌କେ ଚୁପ୍‌କରାଇ ରଇବାଟା ଜାନିକରି ପାରୁସିମନ୍‌ ସବୁଲକ୍‌ ଗଟେକ୍‌ ଅଇ ତାର୍‌ ଲଗେ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ଆରି ସେମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ନିୟମ୍‌ ସିକାଇବା ଦରମ୍‌ ଗୁରୁ ଜିସୁକେ ପାନ୍ଦେ ପାକାଇବାକେ ଗଟେକ୍‌ ପର୍‌ସନ୍‌ ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ଏ ଗୁରୁ ମସାର୍‌ ଦରମ୍‌ ସାସ୍‌ତରର୍‌ ନିୟମ୍‌ ଇସାବେ ସବୁଟାନେଅନି କନ୍‌ ଆଦେସ୍‌ ମୁକିଅ ?” ");
INSERT INTO dso_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ଜିସୁ ତାକେ କଇଲା, “ତମର୍‌ ମାପ୍‌ରୁ, ପରମେସର୍‌କେ ପୁରାପୁରୁନ୍‌ ମନ୍‌ଦେଇ, ପୁରାପୁରୁନ୍‌ ଜିବନ୍‌ ଦେଇ, ପୁରାପୁରୁନ୍‌ ଚିନ୍ତା ସଙ୍ଗ୍‌ ତାକେ ମାନା ଆରି ଆଲାଦ୍‌ କରା । ");
INSERT INTO dso_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ଏଟା ଅଇଲାନି ସବୁର୍‌ଟାନେଅନି ଆଗତୁ ଆରି ମୁକିଅ ଆଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ତାର୍‌ ପଚର୍‌ ମୁକିଅ ଆଦେସ୍‌ ଅଇଲାନି, ତମର୍‌ ଲଗର୍‌ ପାକର୍‌ ଗରର୍‌ ଲକ୍‌ମନ୍‌କେ ନିଜ୍‌କେ ଆଲାଦ୍‌ କଲା ପାରା ଆଲାଦ୍‌ କରା । ");
INSERT INTO dso_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ଏ ଦୁଇଟା ଆଦେସ୍‌ ଆକା ମସା କରିରଇବା ସବୁ ରିତିନିତି ଆରି ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ସିକିଆ ଜାନାଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","କେତେଟା ପାରୁସିମନ୍‌ ଜିସୁର୍‌ ଲଗେ ରଇଲା ବେଲେ, ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ କିରିସ୍‌ଟ ମସିଅର୍‌ ବିସଇ, ତମେ କାଇଟା ବାବ୍‍ଲାସ୍‌ନି ? ସେ କାର୍‌ ପଅ ?” ସେମନ୍‌ କଇଲାଇ, “ସେ ଦାଉଦର୍‌ ପଅ ।” ");
INSERT INTO dso_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ଜିସୁ ପାଚାର୍‌ଲା, “ସେନ୍ତାର୍‌ ଆଲେ ଦାଉଦ୍‌ ମସିଅକେ ‘ମର୍‌ ମାପ୍‌ରୁ !’ ବଲି କାଇକେ ଜାନାଇ ଆଚେ ?” କାଇକେବଇଲେ ଆତ୍‌ମା ଚାଲ୍‌ନା ଦେଲାକେ, ସେ ଲେକିଆଚେ, ");
INSERT INTO dso_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ପର୍‌ମେସର୍‌ ମର୍‌ ମାପ୍‌ରୁକେ କଇଲା, “ ଆମେ ତର୍‌ ସତ୍‌ରୁମନ୍‍କେ ତମର୍‍ ପାଦ୍‌ ତଲେ ନ ଆନ୍‌ବା ଜାକ ‘ତୁଇ ମର୍‌ ଉଜା ବାଟେ ବସି ରଅ ।’ ");
INSERT INTO dso_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“ଜଦି ଦାଉଦ୍‌ ମସିଅକେ ‘ମର୍‌ ମାପ୍‌ରୁ’ ବଲି ନାମି ଆଚେ, ତେବେ ମସିଅ କେନ୍ତି ତାର୍‌ ପଅ ଅଇପାର୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ଜିସୁକେ ଇତିର୍‌ ଉତର୍‌ କେ ମିସା ଦେଇ ନାପାର୍‌ଲାଇ । ସେ ଦିନେଅନି, ଆରି ତାକେ କେ ମିସା କାଇ ପର୍‌ସନ୍‌ ପାଚାର୍‌ବାକେ ସାଆସ୍‌ କରତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ଜିସୁ ସିସ୍‌ମନ୍‌କେ ଆରି ତେଇ ରୁଣ୍ଡି ରଇବା ଲକ୍‌ମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ପାରୁସି ଆରି ଦରମ୍‌ ଗୁରୁମନ୍‌କେ ମସାର୍‌ ନିୟମର୍‌ ଅରତ୍‌ ବୁଜାଇ ଦେବାର୍‌ ଅଦିକାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ସେମନ୍‌ ଜାଇଟା କର୍‌ବାକେ କଇଲାଇନି, ସେଟା କରା, ମାତର୍‌ ସେମନ୍‌ ଜାଇ ଜାଇଟା କଲାଇନି, ସେଟା ଦେକି ସେନ୍ତାରି କରାନାଇ । କାଇକେ ବଇଲେ ସେମନ୍‌ ନିଜେ ଜନ୍‌ ସିକିଆ ଦେବାଇ, ତାର୍‌ ଉଲ୍‌ଟା କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ସେମନ୍‌ ତାକର୍‍ ସିକିଆ ସବୁ ଲକ୍‌ମନର୍‌ ପିଟି ଉପ୍‌ରେ ବେସି ବଜ୍‌ ପାରା ଲାଦିଦେବାଇ । ମାତର୍‌ ସେ ସବୁ ବଜର୍‌ ନିୟମ୍‌, ଚିନି ଆଙ୍ଗ୍‍ଟିତେଇ ଉଟାଇବା ଏତ୍‍କି ମିସା ସାଇଜ ନ କରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ସେମନ୍‌ ଲକ୍‌କେ ଦେକାଇଅଇବାକେ ସବୁ କାମ୍‌ କର୍‌ବାଇ । ସାସ୍‌ତର୍‌ ପଦ୍‌ ଲେକାଅଇଲା କେଡେ କେଡେ ବଡ୍‌ ବଡ୍‌ ଡଅଁରାମନ୍‌ କାପାଲେ ଆରି ପଡିଆଇ ବାନ୍ଦିଅଇ ଆଚତ୍‌ । ଆରି ଦେକା, ସେମନର୍‌ ବସ୍‍ତରର୍‌ ଜାଲି କେତେକ୍‌ ଡେଙ୍ଗ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ସେମନ୍‌ ବଜିମନ୍‌କେ ମୁକିଅ ଜାଗାଇ ଆରି ପାର୍‌ତନା ଗରେ ବାଚିଅଇରଇଲା ଜାଗା ଅଦିକାର୍‌ କର୍‌ବାକେ ମନ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ଆଟେ ବାଟେ ଆରି ଦୁକାନେ ଲକ୍‌ମନ୍‌ ସେମନ୍‌କେ ମାନିକରି ଜୁଆର୍‌ କରତ୍‌ ଆରି ‘ଗୁରୁ’ ବଲି ଡାକତ୍‌, ଏନ୍ତାରି ସେମନ୍‌ ମନ୍‍ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ମାତର୍‌ ତମ୍‌କେ କେ ଗୁରୁ ବଲି ଡାକ୍‌ବାର୍‌ ଦର୍‌କାର୍‌ ନାଇ । କାଇକେ ବଇଲେ ସବୁ ଲକ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ବାଇ, ଆରି ତମର୍‌ ଗୁରୁ ଗଟେକ୍‌ ସେ । ");
INSERT INTO dso_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ଆରି ଜଗତେ ତମେ କାକେ ବାବା ବଲି ଡାକ୍‌ବାକେ ଦର୍‌କାର୍‌ ନାଇ । କାଇକେ ବଇଲେ ତମର୍‌ ଗଟେକ୍‌ସେ ବାବା, ସେ ସର୍‌ଗେ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ତମ୍‌କେ ନେତା ବଲି ମିସା କେ ନ ଡାକତ୍‌, କାଇକେ ବଇଲେ ଗଟେକ୍‌ ସେ ନେତା, ସେ ଅଇଲାନି ମାପ୍‌ରୁ ମସିଅ । ");
INSERT INTO dso_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ତମର୍‌ ବିତ୍‌ରେ ଜେ ସବୁର୍‌ ଟାନେଅନି ମୁକିଅ, ସେ ତମର୍‌ ସେବା କର । ");
INSERT INTO dso_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଜେ ନିଜ୍‌କେ ବଡ୍‌ ବଲି କଇସି, ତାକେ ସାନ୍‌ କରାଅଇସି ଆରି ଜେ ନିଜ୍‌କେ ସାନ୍‌ ବଲି ବାବ୍‌ସି, ତାକେ ବଡ୍‌ କରାଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ଅଇରେ ଦରମ୍‌ ଗୁରୁମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ! ସେସ୍‌ବେଲେ ତମର୍‌ ଦସା କେତେ ଅଦିକ୍‌ ଅଇସି ! ଏଇ ଟକାବଣ୍ଡା ଦଲ୍‌, ସରଗ୍‌ ରାଇଜେ କେଟ୍‌ବା ଦୁଆର୍‌ ତମେ ଡାବିଦେଇଆଚାସ୍‌ ! ନିଜେ ତେଇ କେଟାସ୍‌ ନାଇ ଆରି ଜନ୍‌ଲକ୍‌ମନ୍‌ ତେଇ କେଟ୍‌ବାକେ ମନ୍‍ କଲାଇନି, ସେମନ୍‌କେ ବାଟ୍‌ ଚାଡାସ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“ଏ କୁଟିଆଲ୍‌ ଦରମ୍‌ଗୁରୁମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ! ତମର୍‌ ଇନସ୍‌ତା କେତେକ୍‌ କାକୁର୍‌ତି ଅଇସି । ତମେ ଚାଲାକି ଅଇକରି ଜବର୍‌ ପର୍‌ ପାର୍‌ତନା କର୍‌ସା । ମାତର୍‌ ରାଣ୍ଡି ମାଇଜିମନର୍‌ ଗର୍‌ମନ୍‌ ସବୁ ଦାପ୍‌ରେ ଗିଲିଦେଇସା । ତେବେ ତମ୍‌କେ ଅଦିକ୍‌ ଡଣ୍ଡ୍‌ ଦିଆଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ଏ ଟକାବଣ୍ଡା ଦରମ୍‌ଗୁରୁମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ! ତମେ କେଡେ ଇନସ୍‌ତା ଅଇ କାକୁର୍‌ତି ଅଇସା । ସମ୍‌ଦୁର୍‌ ଲଙ୍ଗି ବିନ୍‌ ବିନ୍‌ ଦେସ୍‌ମନ୍‌କେ ଜାଇ ଗଟେକ୍‌ ଲକ୍‌କେ ତମର୍‌ ଦରମ୍‌ଟାନେ ମିସାଇବାକେ କଜି ବୁଲ୍‌ଲାସ୍‌ନି । ମାତର୍‌ ସେନ୍ତାର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ମିଲାଇଲେ, ତାକେ ତମର୍‌ ଟାନେଅନି ଅଦିକ୍‌, ନରକର୍‌ ଡଣ୍ଡ୍‌ ପାଇବାକେ ବାଚ୍‌ଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ଏଇ ବାଟ୍‌ ଦେକାଉ କାଣାମନ୍‌ ! ତମର୍‌ ଦସା କେତେକ୍‌ ଇନସ୍‌ତା ଅଇସି । କେ ମନ୍ଦିରର୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କଲେ, ସେଟା ସେମନ୍‌ ମାନ୍‌ବାର୍‌ ବାଦିଅ ନାଇ, ମାତର୍‌ ମନ୍ଦିରେ ରଇଲା ସୁନାର୍‌ ନାଉଁ ଦାରି ଜେ ପର୍‌ମାନ୍‌ କର୍‌ସି, ତାକେ ସେଟା ମାନ୍‌ବାକେ ପଡ୍‌ସି ବଲି ତମେ ସିକାଇତେ ରଇସା । ");
INSERT INTO dso_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ଏଇ ବୁଦି ନ ରଇବା କାଣାମନ୍‌ ! ସୁନା ବଡ୍‌, କି ସୁନାକେ ସୁକଲ୍‌ କର୍‌ତେ ରଇବା ମନ୍ଦିର୍‌ ବଡ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ଗଟେକ୍‌ ଲକ୍‌ ବେଦିର୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କଲେ ସେ ସେଟା ମାନ୍‌ବାର୍‌ ଆକା ଆଚେ ବଲି ନଏଁ, ମାତର୍‌ ବେଦି ଉପ୍‌ରେ ସଙ୍ଗଇ ରଇବା ମାପ୍‌ରୁକେ ଦେଲାଟା ନାଉଁଦାରି ପର୍‌ମାନ୍‌ କଲେ, ସେଟା ମାନ୍‌ବାଟା ବଲି ତମେ ସିକାଇତେ ରଇସା । ");
INSERT INTO dso_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ତମେ କେଡେବଡ୍‌ କାଣାମନ୍‌ ! କନ୍‌ଟା ମୁକିଅ ? ମାପ୍‌ରୁକେ ଦେଲାଟା କି, ମାପ୍‌ରୁକେ ଦେଲାଟା ସୁକଲ୍‌ କର୍‌ତେ ରଇବା ବେଦି ? ");
INSERT INTO dso_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ତେବର୍‌ ପାଇ କେ ମିସା ବେଦିର୍‍ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କଲେ, ସେ ବେଦି ଆରି ତାର୍‌ ଉପ୍‌ରେ ରଇବା ମାପ୍‌ରୁକେ ଦେଇ ରଇବା ସବୁ ଜିନିସ୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","କେ ମିସା ମନ୍ଦିରର୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କଲେ, ସେ ମନ୍ଦିର୍‌ ଆରି ତେଇ ବାସା ଅଇରଇବା ପର୍‌ମେସରର୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","କେ ମିସା ସରଗର୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କଲେ, ସେ ପରମେସରର୍‌ ବସ୍‍ବା ଜାଗା ଆରି ସେ ବସ୍‍ବା ଜାଗାଇ ବସି ରଇବା ପର୍‌ମେସରର୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ଏଇ କୁଟିଆଲ୍‌ ଦରମ୍‌ଗୁରୁମନ୍‌ ଆରି ପାରୁସିମନ୍‌, ତମର୍‌ ଦସା କେଡେ ଇନସ୍‌ତା ଆରି କାକୁର୍‌ତି ଅଇସି ! ତମେ ପର୍‌ମେସରର୍‌ ପାଇ ବଲି ସାନ୍‌ ସାନ୍‌ ଜିନିସ୍‌ ଅଇଲେ ମିସା ଦସ୍‌ବାଗ୍‌ ଅନି ବାଗେକ୍‌ ଦାନ୍‌ କର୍‌ସା, ମାତର୍‌ ନିଆଇ, ଦୟା, ବିସ୍‌ବାସ୍‌ ଏନ୍ତି ମୁକିଅ ମୁକିଅ ବିସଇର୍‌ ନିୟମର୍‌ ସିକିଆ ଏଲା କଲାସ୍‌ନି । ପୁର୍‌ବର୍‌ ମୁକିଅ ବିସଇ ଏଲା ନ କରି, ଏ ସବୁଜାକ ଆଗ୍‌ତୁଅନିସେ ଅବିଆସ୍‌ କର୍‌ବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ଏଇ ବାଟ୍‍ଦେକାଇବା କାଣା ଲକ୍‌ମନ୍‌ ! ତମେ କାଇବାବେଲେ କେଡେବଲ୍‌ ତେଇ କାଇଆଲେ କିଡା ଅଦ୍‌ରି ରଇସି ବଲି ସେଟା ଚାନି ପାକାଇତେ ରଇସା । ମାତର୍‌ ତମେ ଗଟେକ୍‌ ଗଟେକ୍‌ ବଡ୍‌ ପସୁକେ ମିସା ଗିଲି କାଇପାକାଇସା । ");
INSERT INTO dso_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ସାରାସାରି ଦିନେ ତମେ କେଡେ କାକୁର୍‌ତି ଅଇସା, ଏଇ କୁଟିଆଲ୍‌ ଦରମ୍‌ ଗୁରୁ ଆରି ପାରୁସିମନ୍‌ ! ତମେ ଉପ୍‌ରେ ଉପ୍‌ରେ ତାଲାଗିନା ମାଜି ପରିଚଲ୍‌ କରିରଇସା, ମାତର୍‌ ସେ ବିତ୍‌ରେ ଇଁସା ଆରି ନିଜର୍‌ ବିସଇ ଚିନ୍ତା କର୍‌ବାଟା ବର୍‌ତି ଅଇରଇସି । ");
INSERT INTO dso_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ଏଇ କାଣା ପାରୁସିମନ୍‌ ! ମୁତାର୍‌ ବିତ୍‌ରେ ରଇବାଟା ଆଗ୍‌ତୁ ପରିଚଲ୍‌ କରା, ସେନ୍ତାର୍‌ କଲେ ଉପ୍‌ରର୍‌ଟା ମିସା ପରିଚଲ୍‌ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ଏଇ ଦରମ୍‌ ଗୁରୁମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ! ତମ୍‌କେ କେଡେ ବଡ୍‌ ଡଣ୍ଡ୍‌ ମିଲ୍‌ସି । ଏଇ କୁଟିଆଲ୍‌ମନ୍‌ ! ତମେ ଉପ୍‌ରେ ଉପ୍‌ରେ ଚୁନ୍‍ସଙ୍ଗ୍‌ ସାରଇ ରଇବା ଗୁଡାମ୍‌ ପାରା । ଏଟାମନ୍‌ ଉପ୍‌ରେ ସୁନ୍ଦର୍‌ ଡିସ୍‌ସି, ମାତର୍‌ ବିତ୍‌ରେ କୁଇଲା ମଡ୍‌ ଆରି ଆଡ୍‌ଗଡ୍‌ ବର୍‌ତି ଅଇରଇସି । ");
INSERT INTO dso_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ସେନ୍ତାରିସେ ତମେ ମିସା ବାଇରେ ଲକ୍‌ମନର୍‌ ଦେକ୍‌ତେ ଦରମ୍‌ ପାରା ଡିସ୍‌ତେରଇସା, ମାତର୍‌ ତମର୍‌ ବିତ୍‌ରେ କୁଟ୍‌ କାତା, ଆଁକାର୍‌, ଆରି ପାପ୍‌ ବର୍‌ତି ଅଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ଏଇ ଦରମ୍‌ଗୁରୁମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ! ଏ ଟକାବଣ୍ଡା କରୁମନ୍‌ ! ତମର୍‌ ପାଇ ଏଟା କେଡେକ୍‌ ଇନସ୍‌ତାର୍‌ ବିସଇ । ତମେ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ପାଇ ସୁନ୍ଦର୍‌ ସୁନ୍ଦର୍‌ ସମାଦି ତିଆର୍‌ କଲାସ୍‌ନି ଆରି ଦରମ୍‌ ଲକ୍‌ମନ୍‌କେ ସବୁ ଦିନ୍‌ ଏତାଇବାକେ ନାଉଁ ଲେକି ଡସାଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ଆରି ତମେସେ କଇଲାସ୍‌ନି ଜଦି ତମର୍‌ ଆନିଦାଦିମନର୍‌ ବେଲେ, ତମେ ରଇତାସ୍‌ ବଇଲେ, ସେମନର୍‌ ପାରା ଚଲାଚଲ୍‌ତି ନ କର୍‌ତାସ୍‌, କି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ନ ମରାଇତାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ଏ କାତା କଇଲାର୍‌ ପାଇ ତମେ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ମରାଉମନର୍‌ ନାତି ତିତିର୍‌ ଲକ୍‌ ବଲି ଏବେ ମାନ୍‌ଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ତେବେ ତମେ ଆଗ୍‌ତୁ ଉଆ । ତମର୍‌ ଆନିଦାଦିମନ୍‌ କରିରଇବା କର୍‌ତା କାମ୍‌ ପୁରାପୁରୁନ୍‌ ସାରାଇ ଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ଏଇ ସାଁପ୍‌ମନ୍‌ ! ବିସ୍‌ରଇବା ସାଁପର୍‌ କୁଟୁମର୍‌ ପାରା ଲକ୍‌ମନ୍‌, ତମେ କେନ୍ତି ନରକର୍‌ ଡଣ୍ଡେଅନି ରକିଆ ମିଲ୍‌ସି ବଲି ଆସା କଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ସେଟାର୍‌ ପାଇ ମୁଇ ତମ୍‌କେ କଇଲିନି, ତମର୍‌ ଲଗେ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ, ସିକାଇବା ଗୁରୁମନ୍‌କେ ଆରି ଗିଆନ୍‌ ରଇବା ବଡ୍‌ ଲକ୍‌ମନ୍‌କେ ମୁଇ ପାଟାଇବି । ତାକର୍‌ ବିତ୍‌ରେଅନି ତମେ କେତେ ଲକ୍‌କେ ମରାଇସା, କେତେ ଲକ୍‌କେ କୁର୍‌ସେ ଚଗାଇସା, ଆରି ବାକି ଲକ୍‌ମନ୍‌କେ ପାର୍‌ତନା ଗରେଅନି କର୍‌ଡା ସଙ୍ଗ୍‌ ମାରି ମାରି ଗଟେକ୍‌ ନଅରେ ଅନି ଆରିଗଟେକ୍‌ ନଅରେ କେଦି ଦେଇସା । ");
INSERT INTO dso_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ଜେନ୍ତିକି ଏବଲର୍‌ ବେଲେଅନି ଆରାମ୍‌ କରି ବର୍‌କିଆର୍‌ ପ ଜିକରିୟର୍‌ ଜାକ, ଜାକେ କି ତମେ ମନ୍ଦିର୍‌ ଆରି ବେଦିର୍‌ ମଜାଇ ମରାଇରଇଲାସ୍‌, ଦସ୍‌ ନ କରିରଇବା ସବୁ ଲକ୍‌ମନ୍‌କେ ମରାଇଲା ପାଇ ତମେ ଦସିଅଇ ଡଣ୍ଡ୍‌ ପାଇସା । ");
INSERT INTO dso_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ମୁଇ ସତ୍‌ କଇଲିନି, ଏ ସବୁ ଲକ୍‌ମନ୍‌କେ ମରାଇଲା ପାଇ ଏ ଜୁଗର୍‌ ଲକ୍‌ମନ୍‌ ଡଣ୍ଡ୍‌ ପାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ଏ ଜିରୁସାଲାମ୍‌, ଏ ଜିରୁସାଲାମ୍‌, ତୁଇ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ମରାଇଲୁସ୍‌ନି ଆରି ପର୍‌ମେସର୍‌ ପାଟାଇରଇଲା କବର୍‌ ଆନୁମନ୍‌କେ ପାକ୍‌ନା ମାରି ମରାଇଲୁସ୍‌ନି । ମାଇ କୁକ୍‌ଡା ତାର୍‌ ଟିଅଁମନ୍‌କେ ଡେନା ବିତ୍‌ରେ ଦାରି ଅଲଣ୍ଡ୍‌ଲାପାରା, ତର୍‌ ଲକ୍‌ମନ୍‌କେ ମୁଇ ପାଟାଲି ରକିଆ କର୍‌ବାକେ କେତେ କେତେ ତର୍‌ ଚେସ୍‌ଟା କଲି । ମାତର୍‌ ମକେ ସେନ୍ତାରି କର୍‌ବାକେ ଦେଉସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ସେଟାର୍‌ ପାଇ ତର୍‌ ମନ୍ଦିର୍‌ ବାଙ୍ଗିରୁଜି ଚିନ୍‌ବିନ୍‌ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ମାତର୍‌ ମୁଇ କଇଲା କାତା ରଇସି, ମାପ୍‌ରୁର୍‌ ନାଉଁ ଦାରି ଜେ ଆଇଲାନି, ସେ କେଡେ କରମର୍‌ ଲକ୍‌ ବଲି ଏଟା ଜେବେ ଜାକ ନ କୁଆସ୍‌, ଆଜିଅନି ଆରି କେବେ ମକେ ଦେକି ନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଜିସୁ ମନ୍ଦିରେଅନି ବାରଇ ଇଣ୍ଡିଜାଇତେ ରଇବାବେଲେ ସିସ୍‌ମନ୍‌ ମନ୍ଦିର୍‌ ପିଣ୍ଡା ଦୁଆରେ ରଇବା ବଡ୍‌ ବଡ୍‌ ପାକ୍‌ନା ବାଟେ ଦେକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ଜିସୁ କଇଲା, “ଏବେ ସିନା ଏ ସବୁ ଦେକ୍‌ଲାସ୍‌ନି । ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି ଏ ମନ୍ଦିରର୍‌ ଗଟେକ୍‌ ମିସା ପାକ୍‌ନା ତାର୍‌ ଜାଗାଇ ନ ରଏ । ସବୁଜାକ ଅଦ୍‌ରି ବିଲିଜାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ଜିସୁ ଜିତ୍‌ ନାଉଁର୍‌ ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ବସିରଇଲା ବେଲେ, ତେଇ କେ ନ ରଇଲା ବେଲେ, ସିସ୍‌ମନ୍‌ ଆସି ତାକେ ପାଚାର୍‌ଲାଇ, “ଏ ସବୁଜାକ କେବ୍‌କେ ଅଇସି ଆମ୍‌କେ କୁଆ କାଇ ଗଟ୍‍ନା ଗଟ୍‌ଲେ ଆମେ ଜାନିପାର୍‌ବୁ ଜେ ତମର୍‌ ଆଇବା ବେଲା ଅଇଲାନି ଆରି ଏ ଜୁଗ୍‌ ସେସ୍‌ ଅଇସି ବଲି ?” । ");
INSERT INTO dso_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ଜିସୁ କଇଲା, “ଜାଗ୍‌ରତ୍‌ଅଇକରି ରୁଆ, ଜେନ୍ତିକି କେ ମିସା ତମ୍‌କେ ନ ନାଡାଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","କେତେ କେତେ ଲକ୍‌ମନ୍‌ ମର୍‌ ନାଉଁ ଦାରି ଆସି କଇବାଇ, ‘ମୁଇ ଆକା କିରିସ୍‌ଟ ମସିଅ ।’ ସେମନ୍‌ ଏନ୍ତାର୍‌ କଇ କେତେ କେତେ ଲକ୍‌ମନ୍‌କେ ନାଡାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ତମର୍‌ ଲଗେ ଅଇତେ ରଇବା ଜୁଇଦର୍‌ କିଲ୍‌ବିଲ୍‌ ଅଇବାଟା ସୁନ୍‌ସା ଆରି ଦୁରିକେ ଅନି ଅଇତେ ରଇବା ଜୁଇଦର୍‌ କବର୍‌ ଜାନ୍‌ସା । ମାତର୍‌ ଡରାନାଇ, ବାଇଦରେ ଏନ୍ତି ଗଟ୍‍ନା ଅଇସି । ମାତର୍‌ ଏଟାର୍‌ ଅରତ୍‌ ନଏଁ ଜେ, ଜୁଗ୍‌କାଲ୍‌ କେଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଦେସ୍‌ ଦେସ୍‌ ବିତ୍‌ରେ ଜୁଇଦ୍‌ ଅଇସି, ଗଟେକ୍‌ ରାଇଜ୍‌ ଆରି ଗଟେକ୍‌ ରାଇଜ୍‌ ଉପ୍‌ରେ ଜୁଇଦ୍‌ କର୍‌ସି । ସବୁ ବାଟେ ମର୍‌ଡି ଆରି ଦର୍‌ତନି ଚୁଲ୍‌ବୁଲ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ମାତର୍‌ ଏଟାମନ୍‌ ସବୁ ମାଇଜିମନର୍‌ ଆତ୍‌ଗଡ୍‌ ସୁକ୍‌ଅଇବା ବେଲେ ପର୍‌ତୁମ୍‌ ପର୍‌ତୁମ୍‌ ଅଇବା ଦୁକାସୁକା ପାରା । ");
INSERT INTO dso_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ତମେ ଦାରାଇ ଅଇ ମାଡ୍‌ କାଇବାକେ ଆରି ମରନର୍‌ ଡଣ୍ଡ୍‌ ପାଇବାକେ ସର୍‌ପି ଅଇସା । ତମେ ମକେ ବିସ୍‌ବାସ୍‌ କଲାର୍‍ ପାଇ ବଲି ସବୁ ଲକ୍‌ ଗିନ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ସେଡ୍‌କିବେଲେ କେତେ କେତେ ଲକ୍‌ ତାକର୍‌ ବିସ୍‌ବାସ୍‌ ଆରାଇବାଇ, ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ ଗିନ୍‌ ଅଇକରି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦିଆ ଦିଇ ଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ସେବେଲେ କେତେ କେତେକ୍‌ ଟକାବଣ୍ଡା ବବିସତ୍‌ବକ୍‌ତା ଆସିକରି ଲକ୍‌ମନ୍‌କେ ନାଡାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ଏନ୍ତାରି ଅଇ ପାପ୍‌ ଅଦିକ୍‌ ଅଦିକ୍‌ ଅଇସି ଆରି ପର୍‌ମେସର୍‌ ପାଇରଇବା ଲକ୍‌ମନର୍‌ ଆଲାଦ୍‌ ସିତଲ୍‌ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ମାତର୍‌ ଜେ ସାରାସାରି ଜାକ ମୁର୍‌ଚିକରି ରଇସି, ସେ ମୁକ୍‌ତି ପାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ରାଇଜର୍‌ ସବୁ ବାସାର୍‌ ଲକ୍‌ମନର୍‌ ଲଗେ, ମାପ୍‌ରୁର୍‌ ସାକିଦେବାକେ ଦୁନିଆର୍‌ ଗୁଲାଇବାଟେ ତାର୍‌ କାତା ସୁନାଇବାଇ । ତାର୍‌ପଚେ ସେ ଜୁଗ୍‌ ସାର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ଦାନିଏଲ୍‌ ବବିସତ୍‌ବକ୍‌ତା ଟିକି ନିକି ଇସାବେ ଲେକିରଇବା ସେ ବାୟାବିକଲର୍‌ ଦିନ୍‌ ତମେ ଆରି ତରେକ୍‌ ଦେକ୍‌ସା । ସେଟା ସୁକଲ୍‌ ଜାଗାକେ ଅସୁକଲ୍‌ କରିଦେଇସି । ଇତିର୍‌ ଅରତ୍‌ କାଇଟା, ପଡ୍‌ଲା ଲକ୍‌ ବୁଜା । ");
INSERT INTO dso_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ସେବେଲେ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଜିଉଦା ରାଇଜେ ରଇବାଇ, ସେମନ୍‌ ଡଙ୍ଗ୍‌ରେ ପାଲାଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଚାଉନି ଉପ୍‌ରେ ରଇବାଇ, ସେମନ୍‌ ଗର୍‌ବିତ୍‌ରର୍‌ ଜିନିସ୍‌ ପତର୍‌ ନେବାକେ ତଲେ ଆସି ଚୁଚାଇ ଚୁଚାଇ ବେଲା ନ ଗଡାଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପଦାଇ ଜାଇତେ ରଇବାଇ, ସେମନ୍‌ ତାକର୍‌ ଲୁଗା ପଚିଆ ନେବାକେ ଗରେ ନ ବାଉଡତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ସେଡ୍‌କିବେଲେ ଗାଗ୍‌ଡେ ରଇବା ମାଇଜିମନ୍‌ ଆରି ପିଲାକେ ଦୁଦ୍‌ କୁଆଇତେ ରଇବା ମାମନର୍‌ ଦସା କେଡେ ଇନସ୍‌ତା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ଏ ସବୁ ଗଟ୍‍ନା ସିତ୍‌ ଦିନେ ନ ଅ । ସେଟାର୍‌ପାଇ ପର୍‌ମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ତେ ରୁଆ, ଜେନ୍ତାରି କି ସିତ୍‌ମାସେ ନଇଲେ ବିସ୍‌ରାମ୍‌ବାରେ ତମ୍‌କେ ପାଲାଇବାକେ ନ ପଡେ । ");
INSERT INTO dso_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ସେବେଲେ ଜନ୍‌ ଦୁକ୍‌ ପାଇବାକେ ପଡ୍‌ସି, ଦୁନିଆ ତିଆର୍‌ ଅଇଲାଟାନେଅନି ଆଜିକେ ଜାକ ଅଇ ରଇବା ସବୁ କସ୍‌ଟତେଇଅନି ଅଦିକ୍‌ ଅଇଜାଇସି । ସେନ୍ତାରି ଦୁକ୍‌ ଆଗ୍‌କେ ଆରି କେବେ ନ ଆସେ । ");
INSERT INTO dso_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ମାତର୍‌ ପର୍‌ମେସର୍‌ ଦୁକର୍‌ ବେଲା ଉନାକରି ଦେଇଆଚେ । ସେନ୍ତାରି ନ କରିରଇଲେ କେ ମିସା ନ ରଇତାଇ । ମାତର୍‌ ସେ ବାଚିରଇବା ଲକ୍‌ମନ୍‌କେ ଜିଆଇବାପାଇ ପର୍‌ମେସର୍‌ ସେ ବେଲା ଉନାକରି ଦେଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ସେବେଲେ କେ ଜଦି ତମ୍‌କେ ଇତି କିରିସ୍‌ଟ ଆଚେ ନଇଲେ ତେଇ ସେ ଆଚେ ବଲି କଇସି, ତାକେ ବିସ୍‌ବାସ୍‌ କରା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","କାଇକେ ବଇଲେ ମୁଇ ନିଜେ ମସିଅ କି ମୁଇ ନିଜେ ବବିସତ୍‌ବକ୍‌ତା ବଲାଇଅଇତେ ରଇବା ଟକାବଣ୍ଡାକରୁମନ୍‌ ସେବେଲେ ଦେକାଇଅଇବାଇ । ସେମନ୍‌ କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ଦେକାଇ ପର୍‌ମେସର୍‌ ବାଚି ରଇବା ଲକ୍‌ମନ୍‌କେ ମିସା ନାଡାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ଦେକା, ସେ ବେଲା ନ ଆଇବା, ଆଗ୍‌ତୁ ମୁଇ ତମ୍‌କେ ଜାନାଇଦେଲିନି । ");
INSERT INTO dso_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ଦେକା, ଜଦି ଲକ୍‌ମନ୍‌ ସେ ମରୁବାଲି ରଇବା ଜାଗାଇ ଆଚେ ବଲି କଇବାଇ, ତମେ ତେଇ ଜାଆ ନାଇ । କି ସେମନ୍‌ ଇତି ଦେକିଦେକା ସେ ଲୁଚିଆଚେ ବଲି କଇବାଇ, ସେମନ୍‌କେ ବିସ୍‌ବାସ୍‌ କରା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ଉଦିଆନ୍‌ ଦିଗେଅନି ବୁଡ୍‌ତି ଦିନ୍‌ ଜାକ ଜେନ୍ତାରି ବିଜ୍‌ଲି ମାରିକରି ଗୁଲାଇ ଆକାସ୍‌ ଉଜଲ୍‌ ଅଇସି, ସେନ୍ତାରି ଅଇକରିସେ ନର୍‌ପିଲା ମୁଇ ଆଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ଜନ୍ତି ମଡା ପିଙ୍ଗି ରଇବାଇ, ତେଇ ମଡ୍‌କାଉ ଗିଦ୍‌ମନ୍‌ ରୁଣ୍ଡିରଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ସେ ଦୁକର୍‌ବେଲା ସାର୍‌ବା ବେଲେ, ବେଲ୍‌ ଜାଉଁଲି ଜାଇସି, ଜନ୍‌ ଆରି ଉଜଲ୍‌ ନ ଡିସାଏ, ବାଦ୍‌ଲେଅନି ତାରାମନ୍‌ ଅଦର୍‌ବାଇ ଆରି ବାଦ୍‌ଲେ ଉଜଲ୍‌ ଦେବାଟାମନ୍‌ ସବୁ ବାଟ୍‌ ବାନା ଅଇଜିବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ତାର୍‌ ପଚେ ନରପିଲା ମୁଇ ବାଦ୍‌ଲେ ଆଇବାଟା ଦେକ୍‌ସା । ଆରି ଡାକ୍‌ପୁଟାଅଇ ପାନି ବାଦ୍‌ଲେ ବପୁ ସଙ୍ଗ୍‍ ଆଇବାଟା ଦେକି ଦର୍‍ତନିର୍‍ ଲକ୍‌ମନ୍‌ କାନ୍ଦାବୁବା ଅଇଜିବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ବଡ୍‌ ମଇରି ବାଜ୍‌ସି । ଆରି ଗୁଲାଇ ସରଗର୍‌ ଗଟେକ୍‌ କନେ ଅନି ବିନ୍‌ ବିନ୍‌ କନେ ରଇବା ମର୍‌ ବାବା ବାଚି ରଇବା ଲକ୍‌ମନ୍‌କେ ଟୁଲିଆଇବାକେ ମୁନୁସ୍‌ ପିଲା ମୁଇ ମର୍‌ ଦୁତ୍‌ମନ୍‌କେ ପାଟାଇବି । ");
INSERT INTO dso_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ଡୁମ୍‌ରି ଗଚେଅନି ସିକା । ଜେଡେବେଲେ ତାର୍‌ କେନ୍ଦିଅନି ପତର୍‌ ପାଲୁଆନି କର୍‌ସି, ଆରି କାଁଚାପତ୍‌ରିଆ ଡିସ୍‌ଲେ କାରାଦିନ୍‌ କେଟ୍‌ଲା ବଲି ତମେ ଜାନ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ସମାନ୍‍ ସେନ୍ତାର୍‌ସେ ଏ ସବୁ ଜାକ ଅଇବାଟା ଦେକ୍‌ଲେ, ସାରାସାରି ଦିନ୍‌କାଲ୍‌ ଆରାମ୍‌ ଅଇଲା ବଲି ତମେ ଜାନା । ");
INSERT INTO dso_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“ ଏତାଇରୁଆ, ମୁଇ ସତ୍‌ କଇଲିନି, ଏବେ ଜିବନ୍‌ ରଇଲା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ସବୁ ଲକ୍‌ ମର୍‌ବା ଆଗ୍‌ତୁ, ଏସବୁ ବିସଇ ଗଟ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ସରଗ୍‌ ଆରି ମଚ୍‌ପୁର୍‌ କୁରୁପ୍‌ନାସ୍‌ ଅଇଜାଇସି, ମାତର୍‌ ମର୍‌ ସବୁ ବାକିଅ କେବେ ମିଚ୍‌ ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ସେ ଦିନ୍‌, ସେ ବେଲା କେବେ ଆଇସି, କେ କଇନାପାରତ୍‌ । ପର୍‌ମେସରର୍‌ ପିଲା ମୁଇ ମିସା କି ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌ ମିସା ସେ କାତା ନାଜାନତ୍‌, ବାବା ପର୍‌ମେସର୍‌ ଆକା ଜାନିଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ନଅର୍‌ ବେଲେ ଜେନ୍ତାରି ଗଟିରଇଲା, ସମାନ୍‍ ସେନ୍ତାରିସେ ନର୍‌ପିଲା ମୁଇ ଆଇବା ବେଲା ମିସା । ");
INSERT INTO dso_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ପୁର୍‌ତିବି ଉପ୍‌ରେ ପାନି ବର୍‌ତି ଅଇବାବେଲେ ଅନି ନଅ ପାନିଜାଜେ ପୁର୍‌ବା ଜାକ, ଲକ୍‌ମନ୍‌ କାଆ ପିଇ ଅଇ ବିବା କାମେ ତେରେପେତେ ଅଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ପାନିତେଇ ସେମନ୍‌ ବଅଁଲି ଜିବା ଜାକ, କାଇଟା ଅଇଲାନି, ଜାନି ନ ରଇଲାଇ । ନର୍‌ପିଲା ମୁଇ ଆଇବା ବେଲେ ସମାନ୍‍ ସେନ୍ତାରି ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ସେ ବେଲାଇ ପଦାଇ ପାଇଟି କର୍‌ତେ ରଇବା ଦୁଇ ଲକର୍‌ ବିତ୍‌ରେ ଅନି ଗଟେକ୍‌ ଲକ୍‌କେ ବାଚ୍‌ବାଇ ଆରି ଗଟେକ୍‌ ଲକ୍‌କେ ଚାଡିଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ଗର୍‌ତେରଇବା ଦୁଇଟା ମାଇଜି ମନର୍‌ ବିତ୍‌ରେ ଅନି ଗଟେକ୍‌ ଲକ୍‌ ବାଚି ଅଇସି ଆରି ଗଟେକ୍‌ ଲକ୍‌ ରଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ସେନ୍ତି ବଇଲେ ତମେ ଜାଗ୍‌ରତ୍‌ ଅଇ ରୁଆ, କାଇକେ ବଇଲେ ତମର୍‌ ମାପ୍‌ରୁ କେଡେବେଲା ଆଇସି, ତମେ ନାଜାନାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","କେଡେବଲ୍‌ ଚର୍‌ ପୁର୍‌ସି ବଲି ଜାନିରଇଲେ, ଗର୍‌ ସାଉକାର୍‌ ଜାଗ୍‌ରତ୍‌ ରଇ ଚର୍‌କେ ଗରେ ପୁର୍‌ବାକେ ନ ଦେଏ । ");
INSERT INTO dso_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ତମେ ମିସା ସବୁବେଲେ ଜାଗ୍‌ରତ୍‌ ରଇକରି ତିଆର୍‌ ଅଇ ରୁଆ । କାଇକେ ବଇଲେ ତମେ ଜାଗି ନ ରଇଲା ବେଲେସେ ନର୍‌ପିଲା ମୁଇ ଉଟିଆଇବି । ");
INSERT INTO dso_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ସେନ୍ତି ବଇଲେ କେ ତେବେ ନିମାନ୍‌ ଆରି ବୁଦି ରଇବା ଦାଙ୍ଗ୍‌ଡା ? ଜାର୍‌ ଉପ୍‌ରେ ସାଉକାର୍‌ ବିନ୍‌ ଦାଙ୍ଗ୍‌ଡାମନର୍‌ ଟିକ୍‌ ବେଲାଇ, କାଇବା କାଦି ଦେବା ଦାଇତ୍‌ ଦେଇରଇସି । ");
INSERT INTO dso_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ସାଉକାର୍‌ ବାଉଡି ଆଇଲା ବେଲେ ସେ ଦାଙ୍ଗ୍‌ଡା ଜଦି ଟିକ୍‌ ସଙ୍ଗ୍‍ କାମ୍‌ କରିରଇସି ବଇଲେ, ତାର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ମୁଇ ସତ୍‌ କଇଲିନି, ସେନ୍ତାରି ଦାଙ୍ଗ୍‌ଡାକେ ସାଉକାର୍‌ ଗଟେକ୍‌ ଦିନେ ତାର୍‌ ସବୁ ଦନ୍‌ ସଁପତିର୍‌ ଦାଇତ୍‌ ଦେଇ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ମାତର୍‌ ସେ ଦାଙ୍ଗ୍‌ଡା ଜଦି ‘ସାଉକାର୍‌ ନ ଆସେତା’ ବଲି ବାବ୍‌ସି ଆରି ");
INSERT INTO dso_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ବିନ୍‌ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ମାର୍‌ପିଟ୍‌ କରି ମଦୁଆମନର୍‌ ସଙ୍ଗ୍‌ କିଆପିଆ କର୍‌ତେ ରଇସି, ");
INSERT INTO dso_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ସେ ଜାଗ୍‌ରତ୍‌ ନ ରଇଲା ବେଲେ ଆରି ଜନ୍‌ ବେଲାଇ ସେ ନାଜାନି ରଏ, ସେ ଦିନେ ଆରି ସେ ବେଲାଇସେ ସାଉକାର୍‌ ବାଉଡିଆଇସି । ");
INSERT INTO dso_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ତାକେ ସେଡ୍‌କି ବେଲେ କଣ୍ଡ୍‌ କଣ୍ଡ୍‌ କରି କାଟି ଦେଇସି । ସେ ନାଡାଉମନର୍‌ ଦସାର୍‌ ଡଣ୍ଡ୍‌ ପାଇସି । ଆରି ସାରାସାରି ଦାଁତ୍‌ କାତ୍‌ରି ମାର୍‌ଚପ୍‌ ଅଇ କାନ୍ଦ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ସେଡିକିବେଲେ ସରଗ୍‌ ରାଇଜେ କେଟ୍‌ବା ବାଟ୍‌ ଏନ୍ତି ଅଇସି । ଦସ୍‌ଟା ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ସବୁ ଲକ୍‌ ଗଟେକ୍‌ ଗଟେକ୍‌ ବତି ଦାରି ବାଟେ, ବର୍‌ ଦାଙ୍ଗ୍‌ଡାକେ ଜାଗ୍‌ବାର୍‌ ଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ସେମନର୍‌ ବିତ୍‌ରେଅନି ପାଁଚ୍‌ଟା ଦାଙ୍ଗ୍‌ଡି ଚତୁର୍‌ ରଇଲାଇ, ଆରି ପାଁଚ୍‌ଟା ଦାଙ୍ଗ୍‌ଡି ବକୁଆ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ବକୁଆ ରଇଲା ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ଅଦିକ୍‌ ଚିକନ୍‌ ନେଇ ନ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ମାତର୍‌ ଚତୁର୍‌ ରଇବା ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବତି ଟାନେ ରଇବାଟା ଚାଡି ଆରି କାଁଚେ ମିସା ଚିକନ୍‌ ବର୍‌ତି କରି ନେଇରଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ବର୍‌ ଦାଙ୍ଗ୍‌ଡା ଆଇବାଟା ଅଲ୍‌ସମ୍‌ ଅଇଲାକେ ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ଜୁମ୍‌ରି ଜୁମ୍‌ରି କରି ସଇଦେଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ମଜା ରାତିବେଲାଇ ଆଉଲି ସୁନି ଅଇଲା, “ଏଦେ ଦେକା ! ବର୍‌ ଦାଙ୍ଗ୍‌ଡା ଆଇଲାବେ ! ଆସା ସେମନ୍‌କେ ଡାକିଆନୁ !” ");
INSERT INTO dso_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ଉଟିକରି ନିଜର୍‌ ନିଜର୍‌ ବତିମନ୍‌ ସାଜାଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ସେଡ୍‌କି ବେଲେ ବକୁଆ ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ଚତୁର୍‌ ରଇଲା ଦାଙ୍ଗ୍‌ଡିମନ୍‌କେ କଇଲାଇ “ଆମ୍‌କେ କଣ୍ଡେକ୍‌ ଚିକନ୍‌ ଦିଆ । ଆମର୍‌ ବତି ଲିବିଗାଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ଚତୁର୍‌ ଦାଙ୍ଗ୍‌ଡିମନ୍‌ କଇଲାଇ, “ତମ୍‌କେ ଦେଲେସରି ଆମର୍‌ ପାଇ ଚିକନ୍‌ ନ ଅଏ । ତମେ ଦୁକାନେ ଜାଇ ନିଜର୍‌ ନିଜର୍‌ ପାଇ ଚିକନ୍‌ ଗେନିଆନା ।” ");
INSERT INTO dso_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ସେଟାର୍‌ପାଇ ବୁଦି ନଇଲା ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ଚିକନ୍‌ ଗେନ୍‌ବାକେ ବାରଇଲାଇ । ସେମନ୍‌ ଗାଲା, ପଚେ ବର୍‌ ଦାଙ୍ଗ୍‌ଡା ଆସି କେଟ୍‌ଲା । ଜାଗ୍‌ରତ୍‌ ଅଇରଇଲା ପାଁଚ୍‌ଟା ଚତୁର୍‌ ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ତାକର୍‌ ସଙ୍ଗ୍‌ ବିବା ବଜିତେଇ ଗାଲା ପଚେ କାପାଟ୍‌ ଡାବିଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","ସେ ବୁଦି ନ ରଇଲା ଦାଙ୍ଗ୍‌ଡିମନ୍‌ ପଚେ ସେ ଜାଗାଇ ଆଇଲାଇ, ଏ ମାପ୍‌ରୁ, ଏ ମାପ୍‌ରୁ କାପାଟ୍‌ ଉଗାଡା, ଆମେ ବିତ୍‌ରେ ଜିବୁ ବଲି ସେମନ୍‌ ଆଉଲି ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ବର୍‌ଦାଙ୍ଗ୍‌ଡା କଇଲା, “ମୁଇ ସତ୍‌ କଇଲିନି, ତମେ କେ, ମୁଇ ନାଜାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","କାତା କଇବାଟା ସାରାଇ, କରି ଜିସୁ କଇଲା, “ଜାଗ୍‌ରତ୍‌ ଅଇ ରୁଆ । ସେ ଦିନ୍‌ କି ବେଲା କେ ମିସା ନାଜାନାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ସରଗ୍‌ ରାଇଜ୍‌ ଏନ୍ତାରି, ସେ ବିସଇର୍‍ ଆରି ଗଟେକ୍‌ କାତା ସୁନା । ତରେକ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‌ ଚାକର୍‌ମନ୍‍କେ, ତାର୍‌ ସଁପତି ଚାଡିଦେଇ ବିଦେସେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ସେମନର୍‌ ପାର୍‌ବା ଇସାବେ ସେମନ୍‌କେ କେତେକ୍‌ କେତେକ୍‌ ଡାବୁ ଜିମା ଦେଲା । ଗଟେକ୍‌ ଲକ୍‌କେ ପାଁଚ୍‌ ଅଜାର୍‌ ରୁପା ଟାଙ୍ଗା ଦେଲା, ଗଟେକ୍‌ ଲକ୍‌କେ ଦୁଇ ଅଜାର୍‌, ଆରି ଗଟେକ୍‍ଲକ୍‌କେ ଅଜାର୍‌ ରୁପା ଟାଙ୍ଗା ଦେଲା । ଆରି ବିଦେସେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ପାଁଚ୍‌ ଅଜାର୍‌ ରୁପାଟାଙ୍ଗା ନେଇରଇଲା ଚାକର୍‌ ସେ ଡାବୁ ବେବାର୍‌ କରି ଆରି ପାଁଚ୍‌ ଅଜାର୍‌ ଲାବ୍‌କଲା । ");
INSERT INTO dso_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ସେନ୍ତାରି ଦୁଇ ଅଜାର୍‌ଟା ନେଇରଇଲା ଚାକର୍‌ ମିସା ଆରି ଦୁଇ ଅଜାର୍‌ ଲାବ୍‌କଲା । ");
INSERT INTO dso_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ମାତର୍‌ ଜନ୍‌ ଚାକର୍‌ ଅଜାର୍‌ଟା ପାଇରଇଲା, ସେ ଗଟେକ୍‌ କାଲ୍‌କୁନି ସାଉକାର୍‌ ଦେଇରଇବା ସେ ରୁପା ଟାଙ୍ଗା ଲୁଚାଇ ସଙ୍ଗଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ବେସିଦିନ୍‌ ଗାଲା ପଚେ ସାଉକାର୍‌ ବାଅଡ୍‌ଲା ଆରି ଚାକର୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଇସାବ୍‌କିତାବ୍‌ କଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ପାଁଚ୍‌ ଅଜାର୍‌ ରୁପାଟାଙ୍ଗା ନେଇରଇଲା ଚାକର୍‌ ଆସି ଆରି ପାଁଚ୍‌ ଅଜାର୍‌ ଦେଇ କଇଲା, “ସାଉକାର୍‌ ତମେ ମକେ ପାଁଚ୍‌ ଅଜାର୍‌ ଦେଇରଇଲାସ୍‌, ଏଦେ ଦେକା, ମୁଇ ଆରି ପାଁଚ୍‌ ଅଜାର୍‌ ଲାବ୍‌ କଲିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ସାଉକାର୍‌ ସାର୍‌ଦା ଅଇ ତାକେ କଇଲା, “ ଟିକ୍‌ କରିଆଚୁସ୍‌, ତୁଇ ମର୍‌ କେଡେକ୍‌ ନିକ ଆରି ବିସ୍‌ବାସ୍‍ ରଇବା ଚାକର୍‌ ! ତମେ ବିସ୍‌ବାସ୍‌ ସଙ୍ଗ୍‍ ଉନା ଦନ୍‌ କାର୍‌ବାର୍‌ କରି ରଇଲାର୍‍ ପାଇ ତମ୍‍କେ ବେସି ଦନ୍‌ ଚାଡିଦେବି । ଆଉ ମର୍‌ ସଙ୍ଗ୍‌ ସାର୍‌ଦା କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ଦୁଇ ଅଜାର୍‌ ରୁପାଟାଙ୍ଗା ନେଇ ରଇଲା ଚାକର୍‌ ଆସି କଇଲା, ସାଉକାର୍‌ ତମେ ମକେ ଦୁଇ ଅଜାର୍‌ ଦେଇ ରଇଲାସ୍‌, ମୁଇ ଆରି ଦୁଇ ଅଜାର୍‌ ଲାବ୍‌ କଲିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ସାଉକାର୍‌ କଇଲା, କେଡେକ୍‌ ନିକ ! ତୁଇ ମିସା ମର୍‌ ବଡିଆ ଚାକର୍‌ । ଉନା ଡାବୁ ମିସା ନିକକରି କାମେ ଲାଗାଇଲୁସ୍‌ । ଏବେ ତର୍‌ ଜିମାରେ ମୁଇ ବୁତେକ୍‌ ଦନ୍‌ ଦେବି । ଆଉ ମର୍‌ ସଙ୍ଗ୍‌ ସାର୍‌ଦା କର୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ସାରାସାରି ଅଜାର୍‌ ରୁପାଟାଙ୍ଗା ପାଇରଇଲା ଚାକର୍‌ ଆସି କଇଲା, “ଏ ସାଉକାର୍‌ ମୁଇ ଜାନି, ତମେ ଗଟେକ୍‌ ବେସି ରିସା ଅଇବା ଲକ୍‌ । ବୁନି ନ ରଇବା ପଦାଇ କାଟ୍‌ସା ଆରି ବିଅନ୍‌ ନ ବୁନିକରି ତାସ୍‌ ବାରା ବାନ୍ଦ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ସେଟାର୍‌ ପାଇ ମୁଇ ଡରିକରି ତମର୍‌ ଦନ୍‌ ମାଟିତେଇ କାଲ୍‌କୁନି ତପି ରଇଲି । ଏଦେ ଦେକା ! ତମର୍‌ ସେ ଟାଙ୍ଗା !” ");
INSERT INTO dso_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ସାଉକାର୍‌ କଇଲା, “ଅଇରେ କାମ୍‌କେ ନଇଲା ବାଡୁ ! ତୁଇତା ଜାନିରଇଲୁସ୍‌, ମୁଇ ଜନ୍ତି ବୁନି ନ ରଇ, ତେଇ ତାସ୍‌ ଟୁଲିଆଇବି । ");
INSERT INTO dso_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ତେବେ ମର୍‌ ଟାଙ୍ଗାନେଇ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ କଲନ୍ତର୍‌ ଇସାବେ ଦେଇରଇଲେ ମିସା ତେଇଅନି ମକେ କଲନ୍ତର୍‌ ମିଲ୍‌ତା ।” ");
INSERT INTO dso_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଏନ୍ତାରି କଇ ସାଉକାର୍‌ ଆଦେସ୍‌ ଦେଲା, ଏ ଚାକରର୍‌ଟାନେ ଅନି ସବୁ ଟାଙ୍ଗା ନେଇ, ଜାର୍‌ ଆତେ ଦସ୍‌ଅଜାର୍‌ ଆଚେ, ତାକେ ଦେଇଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","କାଇକେ ବଇଲେ ଜାକେ ଆଚେ, ତାକେ ଅଦିକ୍‌ ଦିଆଅଇସି । ଆରି ସେ ଅଦିକ୍‌ ଅଦିକ୍‌ ଲାବ୍‌ କର୍‌ସି । ମାତର୍‌ ଜାକେ ନାଇ ତାର୍‌ଲଗେ ଜାଇଟା ଆଚେ, ସେଟା ମିସା ତାରତେଇଅନି ଚାଡାଇ ନିଆଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଏ କାମ୍‌କେ ନଇଲା ଚାକର୍‌କେ ବାଇରେ ଦାରିଜା ଆରି ଆନ୍ଦାରେ ପଙ୍ଗିଦିଆସ୍‌ । ତେଇ ସେ କିଲିବିଲିଅଇ ଦାତ୍‌ କାତ୍‌ରି ମାରି ଚପି ଅଇ କାନ୍ଦ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ଜେଡେବେଲା ନର୍‌ପିଲା ମୁଇ ରାଜାଅଇ ମର୍‌ ସରଗର୍‌ ଦୁତ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଆଇବି, ଆରି ମର୍‌ ଡାକ୍‌ପୁଟା ବସ୍‍ବା ଜାଗାଇ ବସ୍‌ବି, ");
INSERT INTO dso_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ସବୁ ଜାତିର୍‌ ଲକ୍‌ ମର୍‌ ମୁଆଟେ ଟୁଲ୍‌ ଅଇବାଇ । ସେଡ୍‌କି ବେଲା ଗଉଡ୍‌ ଜେନ୍ତି ମେଣ୍ଡା ଆରି ଚେଲିମନ୍‌କେ ବେଗ୍‍ଲାଇସି, ସେନ୍ତି ନର୍‌ପିଲା ମୁଇ ଲକ୍‌ମନ୍‌କେ ଦୁଇ ଦଲ୍‌ କରି ବାଗ୍‌ କର୍‌ବି । ");
INSERT INTO dso_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ଦରମ୍‌ ଲକ୍‌ମନ୍‌କେ ଉଜା ବାଟେ ଆରି ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ମର୍‌ ଡେବ୍‌ରି ବାଟେ ସଙ୍ଗଇବି । ");
INSERT INTO dso_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ତାର୍‌ ପଚେ ମର୍‌ ଉଜାବାଟେ ରଇଲା ଲକ୍‌ମନ୍‌କେ ମୁଇ କଇବି, “ଆସା, ତମ୍‌କେ ମର୍‌ ବାବା ଆସିର୍‌ବାଦ୍‌ କଲାଆଚେ । ଦୁନିଆ ତିଆର୍‌ଅଇଲା ବେଲେଅନି ଜନ୍‌ ରାଇଜ୍‌ ତମର୍‌ ପାଇ ତିଆର୍‌ ଅଇଲା ଆଚେ, ଆସା, ତେଇ ଜାଇ ପୁରା । ");
INSERT INTO dso_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ମୁଇ ବୁକେ ରଇଲି, ତମେ ମକେ କୁଆଇଲାସ୍‌ । ମକେ ସସ୍‍ କଲା, ତମେ ମକେ କାଇବାକେ ଦେଲାସ୍‌ । ମୁଇ ଚିନାର୍‌ ଜାନାର୍‌ ନ ରଇଲି, ମକେ ତମର୍‌ ଗରେ ଗତିଆ କରି ଡାକ୍‌ଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ମୁଇ ଡୁମ୍‌ଣ୍ଡା ରଇଲି, ମକେ ବସ୍‌ତର୍‌ ପିନ୍ଦାଇଲାସ୍‌ । ମୁଇ ଜର୍‌ଦାରାଇ ଅଇରଇଲି, ମକେ ଜତନ୍‌ କଲାସ୍‌ । ମୁଇ ବନ୍ଦି ଗରେ ରଇଲି ମକେ ଦେକ୍‌ବାର୍‌ ଆସିରଇଲାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ଦରମ୍‌ ଲକ୍‌ମନ୍‌ କଇବାଇ, “ମାପ୍‌ରୁ ! କେବେ ତମେ ବୁକେ ରଇଲାଟା ଦେକି ତମ୍‌କେ କାଇବାକେ ଦେଇରଇଲୁ ? କେବେ ତମ୍‍କେ ସସ୍‍ କଲାଜେ ପାନି କାଇବାକେ ଦେଇ ରଇଲୁ ? ");
INSERT INTO dso_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","କେବେ ତମେ ଚିନାର୍‌ ଜାନାର୍‌ ନ ଅଇରଇଲାସ୍‌ ଜେ ଆମେ ତମ୍‌କେ ଗତିଆ କରି ଗରେ ଡାକି ରଇଲୁ ? ଆରି କେବେ ଡୁମ୍‌ଣ୍ଡା ରଇଲାସ୍‌ ଜେ ପିନ୍ଦ୍‌ବାକେ ବସ୍‌ତର୍‌ ଦେଇ ରଇଲୁ ? ");
INSERT INTO dso_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","କେବେ ତମେ ଜର୍‌ ଦାରାଇ ଅଇରଇଲାସ୍‌ଜେ ଆମେ ତମ୍‌କେ ଜତନ୍‌ କଲୁ ? ଆରି କେବେ ତମେ ବନ୍ଦି ଗରେ ରଇଲାସ୍‌ଜେ ଆମେ ଦେକ୍‌ବାର୍‌ ଆସିରଇଲୁ ?” ");
INSERT INTO dso_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ପଚେ, ମୁଇ ସେମନ୍‌କେ କଇବି, ମୁଇ ତମ୍‌କେ ସତ୍‌କଇଲିନି, ଏ ମର୍‌ ବାଇମନର୍‌ ବିତ୍‌ରେ ସବୁର୍‌ଟାନେଅନି ଗଟେକ୍‌ ସାନ୍‌ ଲକର୍‌ ପାଇ, ଜାଇଟା ସବୁ କରିଆଚାସ୍‌, ସେଟା ମର୍‌ ପାଇ କରିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ତାର୍‌ପଚେ ଡେବ୍‌ରିବାଟେ ବସି ରଇବା ଲକ୍‌ମନ୍‌କେ ମୁଇ କଇବି “ଏଇ ସାଇପ୍‌ ପାଇରଇବା ଦଲର୍‌ ଲକ୍‌ମନ୍‌ ! ମର୍‌ ମୁଆଟେ ରୁଆନାଇ । ସଇତାନ୍‌ ଆରି ତାର୍‌ ସଙ୍ଗ୍‍ ରଇଲା ଦୁତ୍‌ମନର୍‌ ପାଇ, ସବୁବେଲେ ଲାଗି ରଇବା ଜଇକୁଣ୍ଡ୍ ତିଆର୍‌ ଅଇଲାଆଚେ । ତେଇ ଜାଆ ! ");
INSERT INTO dso_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ମୁଇ ବୁକେ ରଇଲି, ତମେ ମକେ କାଇବାକେ ଦିଆସ୍‌ ନାଇ, ମକେ ସସ୍‍ କଲାଜେ ପାନି ଗୁଡିକ୍‌ ଦିଆସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ମୁଇ ଅଚିନାର୍‌ ଅଇ ରଇଲା ବେଲେ ମକେ ଡାକାସ୍‌ ନାଇ । ମୁଇ ଡୁମ୍‍ଣ୍ଡା ରଇଲା ବେଲେ ମକେ ବସ୍‌ତର୍‌ ପିନ୍ଦାଆସ୍‌ ନାଇ । ଜର୍‌ ଦାରାଅଇ ଆରି ବନ୍ଦି ଅଇ ରଇଲା ବେଲେ, ମକେ ଜତନ୍‌ କରାସ୍‌ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ସେମନ୍‌ ସେଡ୍‌କିବେଲେ ମକେ କଇବାଇ, “ମାପ୍‌ରୁ, ତମ୍‌କେ ଆମେ କେବେ ବୁକେ ରଇଲା ବେଲେ, ସସେ ରଇଲା ବେଲେ, ଅଚିନାର୍‌ ରଇଲା ବେଲେ, ଡୁମ୍‍ଣ୍ଡା ରଇଲା ବେଲେ ଆରି ଜର୍‌ ଦାରାଇଅଇ ବନ୍ଦି ରଇବାଟା ଦେକି ତମ୍‌କେ ସାଇଜ କରୁ ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ସତଇସେ ମୁଇ କଇବି, “ଏ ସାନ୍‌ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌କେ ସାଇଜ କର୍‌ବାକେ ମନାକର୍‌ବା ବେଲେ, ତମେ ମକେ ସାଇଜ କରାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ଏନ୍ତାରି ଲକ୍‌ମନ୍‌କେ ସବୁ ଦିନର୍‌ ପାଇ ଡଣ୍ଡ୍‌ ମିଲ୍‌ସି ଆରି ଦରମ୍‌ ଲକ୍‌ମନ୍‌ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ଜିସୁ ଏ ସବୁ ସିକିଆ ଦେଇ ସାରାଇଲା ପଚେ ସିସ୍‌ମନ୍‌କେ, ");
INSERT INTO dso_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ନିସ୍‌ତାର୍‌ ପରବ୍‌ ଅଇବାକେ ଆରି ଦୁଇ ଦିନ୍‌ ଆଚେ । ସେଟା ତମେ ଜାନାସ୍‌ । ସେଡ୍‌କିବେଲେ ନର୍‌ପିଲା ମୁଇ କୁର୍‌ସେ ମର୍‌ବାକେ ଲକ୍‌ମନ୍‍କେ ସର୍‌ପି ଅଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ସେବେଲେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ବଡ୍‌ ପୁଜାରି କୟାପାର୍‌ ଗରେ ରୁଣ୍ଡ୍‌ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ସେମନ୍‌ କେ ନାଜାନ୍‌ଲାପାରା ଜିସୁକେ ଦାରି ମରାଇବାକେ ପାଁଚ୍‌ନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ମାତର୍‌ ସେମନ୍‌ କଇଲାଇ, “ଆମେ ପରବ୍‌ ବେଲେ ଏ କାମ୍‌ କର୍‌ବାଟା ଟିକ୍‌ ନଏଁ । ସେ ବେଲେ ଲକ୍‌ମନ୍‌ ଗଣ୍ଡ୍‍ଗଲ୍‌ ମିସା କରିପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ଜିସୁ ଦିନେକ୍‌ ବେତ୍‌ନିଆଇ, ଆଗେଅନି ବଡ୍‌ରଗ୍‌ ଅଇ ରଇବା ସିମନର୍‌ ଗରେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ସିମନର୍‌ ଗରେ ସେ କାଇବାକେ ବସି ରଇଲା ବେଲେ, ଏଦେ ଦେକା ! ଗଟେକ୍‌ ମାଇଜି ଆଲାବାସ୍‌ଟା ନାଉଁର୍‌ ପାକ୍‌ନାସଙ୍ଗ୍‌ ତିଆର୍‌କଲା କଣ୍ଡିତେଇ ବେସି ଦାମର୍‌ ବାସ୍‌ନା ଚିକନ୍‌ ବର୍‌ତି କରି ଆନି ତାର୍‌ ମୁଣ୍ଡେ ଡାଲି ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ଏଟା ଦେକିକରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ରିସା ଅଇଗାଲାଇ । ସେମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ, “ଏତେକ୍‌ପାରା ଚିକନ୍‌ କାଇକେ ଚୁଚାଇ ଚୁଚାଇ ଡାଲିପାକାଇଲୁସ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ଏ ବାସ୍‌ନା ଚିକନ୍‌ ବିକ୍‌ଲେ ସରି, ବେସି ଡାବୁ ମିଲ୍‌ତା ଆରି ସେଟା ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ଦାନ୍‌ ଦେବାର୍‌ ଅଇତା ।” ");
INSERT INTO dso_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ସେମନ୍‌ କାଇଟା ବଲି କଇଲାଇନି, ଏଟା ଜାନିକରି ଜିସୁ କଇଲା, “ତାକେ କାଇକେ ତମେ ଅଇରାନ୍‌ କଲାସ୍‌ନି ? ସେ ମର୍‌ ପାଇ ଗଟେକ୍‌ ନିକ ଆରି ସୁନ୍ଦର୍‌ କାମ୍‌ କଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","“ତମେ ସବୁବେଲେ ଗରିବ୍‌ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ମିସ୍‌ସା । ମାତର୍‌ ମର୍‌ସଙ୍ଗ୍‌ ସବୁବେଲେ ରଇ ନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ସେ ମର୍‌ ଉପ୍‌ରେ ବାସ୍‌ନା ଚିକନ୍‌ ରକଇକରି, ମକେ ସମାଦି ଦେବା ଆଗ୍‌ତୁ, ତିଆର୍‌ କରି ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ଗୁଲାଇ ଜଗତେ ଜନ୍‌ ଜାଗାଇ ମିସା ମାପ୍‌ରୁର୍‌ ନିକ କବର୍‌ ଜାନାଇଅଇସି, ଏ ମାଇଜି ଜାଇଟା କଲାଆଚେ, ତାକେ ଏତାଇକରି ସେଟା ମିସା କଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ଜିସୁର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ନାଉଁର୍‌ ଗଟେକ୍‌ ସିସ୍‌ ମୁକିଅ ପୁଜାରିମନର୍‌ ଲଗେ ଜାଇ ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ ଜିସୁକେ ଦାରାଇଦେଲେ ମକେ କାଇଟା ଦେଇସା ?” ସେମନ୍‌ ତାକେ ତିରିସ୍‌ଟା ରୁପାଟାଙ୍ଗା ଏଜିକରି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ସେ ଦିନେଅନି ଜିଉଦା ଜିସୁକେ ଦାରାଇ ଦେବାକେ ବେଲା କଜ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ନିସ୍‌ତାର୍‌ ପରବର୍‌ ପର୍‌ତୁମ୍‌ ଦିନେ ସିସ୍‌ମନ୍‌ ଆସି ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ତମର୍‌ ପାଇ ଆମେ କନ୍ତି ନିସ୍‌ତାର୍‌ ପରବର୍‌ ବଜି ତିଆର୍‌ କର୍‌ବୁ ?” ");
INSERT INTO dso_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ଜିସୁ କଇଲା, “ନଅରେ ଜାଇ ସେ ଲକ୍‌କେ କଇସା, ତାର୍‌ ଦିନ୍‌କାଲ୍‌ କେଟି ଆଇଲାନି ବଲି ଗୁରୁ କଇଲା ଆଚେ । ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ତମର୍‌ ଗରେ ସେ ନିସ୍‌ତାର୍‌ ପରବ୍‌ ମାନ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ସିସ୍‌ମନ୍‌, ଜିସୁ କଇଲା ଇସାବେ ନିସ୍‌ତାର୍‌ ପରବର୍‌ ବଜି ତିଆର୍‌କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ସଞ୍ଜ୍‌ ଅଇଲାକେ ଜିସୁ ଆରି ତାର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌ କାଇବାର୍‌ ବସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","କାଇବା ବେଲେ ଜିସୁ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ତମର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ମକେ ବିସ୍‌ବାସେ ବିସ୍‌ଦେଲା ପାରା କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ଏ କାତା ସୁନି ସିସ୍‌ମନ୍‌ କାବା ଅଇଗାଲାଇ । ଆରି ଗଟେକ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ “ମାପ୍‌ରୁ ସେ ଲକ୍‌ ମୁଇ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଜିସୁ କଇଲା, “ଜନ୍‌ ଲକ୍‌କି ମର୍‌ସଙ୍ଗ୍‌ ଗିନାତେଇ ରୁଟି ଚବାଲ୍‌ଲା, ସେ ଆକା ।” ସେ ମକେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ସାସ୍‌ତରର୍‌ ଲେକା ଇସାବେ ମୁନୁସ୍‌ପିଲା ମୁଇ ମରିଜିବି, ମାତର୍‌ ଜେ ମକେ ଦାରାଇ ଦେଇସି, ତାର୍‌ ଦସା କେଡେ ଇନସ୍‌ତା ଅଇସି ! ସେ ଜନମ୍‌ ନ ଅଇରଇଲେ ନିକ ଅଇତା । ");
INSERT INTO dso_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଉ ଜିଉଦା ଉଟି ପାଚାର୍‌ଲା, “ଗୁରୁ ତମେ ମକେ ଦେକାଇକରି କୁଆସ୍‌ନାଇ ତ ?” ଜିସୁ ତାକେ କଇଲା, “ସେଟା ତୁଇସେ କଇଲୁସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ସେମନ୍‌ କାଇବା ବେଲେ ଜିସୁ ଗଟେକ୍‌ ରୁଟି ଦାରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲା, ଆରି ସେଟା ବାଙ୍ଗାଇ ସିସ୍‌ମନ୍‌କେ ଦେଇ କଇଲା, “ଏଟା ମର୍‌ ଗାଗଡ୍‌ । ନିଆ ଆରି କାଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ତାର୍‌ପଚେ ଅଙ୍ଗୁର୍‌ରସ୍‌ ରଇଲା ମୁତା ଦାରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲା ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ତମେ ସବୁ ଲକ୍‌ ଏ ମୁତାର୍‌ଟା କାଆ । ");
INSERT INTO dso_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ଏଟା ମର୍‌ ବନି । ମୁନୁସ୍‌ମନର୍‌ ପାପ୍‌କେମାର୍‌ ଲାଗି ମୁଇ ମର୍‌ ଜନ୍‌ ବନି ଡାଲି ଦେବି ବଲି ଗାଲିନି, ସେଟା ପର୍‌ମେସର୍‌ ନୁଆ ନିୟମ୍‌ ଟିକ୍‍ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ମୁଇ ତମ୍‌କେ କଇଲିନି, ମର୍‌ ବାବାର୍‌ ରାଇଜେ ତମର୍‌ ସଙ୍ଗ୍‌ ନୁଆ ଅଙ୍ଗୁର୍‌ ରସ୍‌ କାଇବା ଜାକ ମୁଇ ଆରି କେବେ ଏ ରସ୍‌ ନ କାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ତାର୍‌ପଚେ ସେମନ୍‌ ଦନିଅବାଦର୍‌ ଗିତ୍‌ ଗାଇ ଗାଇ କରି ଜିତ୍‌ନାଉଁର୍‌ ପର୍‌ବତେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ସେବେଲେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଆଜି ରାତି ତମେ ସବୁ ଲକ୍‌ ମକେ ଚାଡିକରି ଉଟିଜାଇସା । ସାସ୍‌ତର୍‌ କଇଲାନି, ମୁଇ ମେଣ୍ଡା ଚାରାଉକେ ମରାଇବି ଆରି ମେଣ୍ଡାମନ୍‌ ଚିନ୍‌ବିନ୍‌ ଅଇଜିବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ମାତର୍‌ ମୁଇ ମରିକରି ଆରି ତର୍‌ ଉଟ୍‌ଲା ପଚେ, ତମର୍‌ ଆଗ୍‌ତୁ ଆଗ୍‌ତୁ ଗାଲିଲି ରାଇଜେ ଜିବି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ପିତର୍‌ ଜିସୁକେ କଇଲା, “ତମ୍‌କେ ବିନ୍‌ ଲକ୍‌ମନ୍‌ ସବୁ ଚାଡିକରି ଉଟିଗାଲେ ମିସା ମୁଇ ଚାଡି ନ ଜାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ଜିସୁ ପିତର୍‌କେ କଇଲା, “ମୁଇ ସତ୍‌ କଇଲିନି ଆଜି ରାତି କୁକ୍‌ଡା ନ ଡାକ୍‌ତେ, ତୁଇ ମକେ ତିନ୍‌ ତର୍‌ ନାଜାନି ବଲି କଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପିତର୍‌ କଇଲା, “ଜଦି ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‌ ମର୍‌ବାର୍‌ ରଇଲେ ମିସା, ମୁଇ ତମ୍‌କେ କେବେ ନାଜାନି ବଲି ନ କଇ ।” ବିନ୍‌ ସିସ୍‌ମନ୍‌ ମିସା ସେନ୍ତାର୍‌ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ତାର୍‌ ପଚେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଗେତ୍‌ସିମନି ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ ଜାଇ ସେମନ୍‌କେ କଇଲା, “ତମେ ଇତି ଚନେକ୍‌ ବସି ରୁଆ । ମୁଇ ସେ ଲଗେ ଜାଇ ପାର୍‌ତନା କର୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ସେ ପିତର୍‌କେ ଆରି ଜେବଦିର୍‌ ଦୁଇଟା ପିଲାମନ୍‌କେ ତାର୍‌ ସଙ୍ଗ୍‌ ଡାକିନେଲା । ସେଡ୍‌କି ବେଲେ ସେ ବେସି ଦୁକ୍‌ କସ୍‌ଟ ଆରି କିଲ୍‌ବିଲ୍‌ଅଇ, ");
INSERT INTO dso_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ସେମନ୍‌କେ କଇଲା, “ଦୁକ୍‌ ଅଇ ମର୍‌ ଜିବନ୍‌ ଚିଡିଗାଲା ପାରା ଲାଗ୍‌ଲାନି । ଇତି ତମେ ମକେ ଜାଗିରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଜିସୁ ତାକର୍‌ ଟାନେଅନି କଣ୍ଡେକ୍‌ ଦୁରିକେ ଜାଇ ବୁଏଁ ଉମ୍‌ତାଡିଅଇ ପାର୍‌ତନା କଲା, “ବାବା ଜଦି ଅଇସି ବଇଲେ ଏ ଦୁକ୍‌ ପୁରୁନର୍‌ ମୁତା ମର୍‌ଟାନେଅନି ଦାରି ଜା, ମାତର୍‌ ମୁଇ ମନ୍‍ କଲାଟା ନଏଁ, ତମେ ମନ୍‍ କଲାଟା ପୁରାପୁରୁନ୍‌ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ତାର୍‌ପଚେ ସେ ତିନ୍‌ଟା ସିସ୍‌ମନର୍‌ ଲଗେ ବାଉଡି ଆସି ଦେକ୍‌ଲା, ସେମନ୍‌ ସଇଦେଇଆଚତ୍‌ । ଜିସୁ ପିତର୍‌କେ କଇଲା, “ତମେ ଗଟେକ୍‍ ଗଁଟା ମିସା ଜାଗି ନାପାର୍‌ଲାସ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ଜେନ୍ତିକି ପରିକାର୍‌ ବେଲାଇ ନ ଆରିଜିବାକେ, ଜାଗିରଇ ପାର୍‌ତନା କରା । କାଇକେ ବଇଲେ ଆତ୍‌ମା କର୍‌ବି ବଲି ମନ୍‍ କଲାନି, ମାତର୍‌ ଗାଗଡ୍‌ ନିଚି ବଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଜିସୁ ଆରି ତରେକ୍‌ ଜାଇ ପାର୍‌ତନା କଲା, “ଏ ମର୍‌ ବାବା ଜଦି ଏ ଦୁକର୍‌ ମୁତା ମର୍‌ଟାନେଅନି ନ ନେଲେ, ମୁଇ ସେଟା କାଇବାକେ ସେ ପଡ୍‌ସି । ମାତର୍‍ ମୁଇ ମନ୍‍ କଲାଟା ନାଇ, ତମେ ମନ୍‍ କଲାଟା ପୁରାପୁରୁନ୍‌ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ସେ ଆରି ତରେକ୍‌ ବାଉଡି ଆସି ସିସ୍‌ମନ୍‌ ସଇରଇଲାଟା ଦେକ୍‌ଲା । ସେମନ୍‌କେ ଗୁନ୍‌ ଡାବି ଆନ୍‌ତେ ରଇଲାଜେ ଆଁକି ଦେକି ନାପାର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ଏଟାସଙ୍ଗ୍‌ ତିନ୍‌ତର୍‌ ଅଇଲା ଜିସୁ ସେମନ୍‌କେ ଚାଡିକରି କଣ୍ଡେକ୍‌ ଦୁରିକେ ଜାଇ ସେନ୍ତାରି ପାର୍‌ତନା କଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ତାର୍‌ ପଚେ ସିସ୍‌ମନର୍‌ ଲଗେ ଆସି କଇଲା, “ଏବେ ଜାକ ତମେ ସଇଆଚାସ୍‌ ? ଦେକା ପର୍‌ମେସରର୍‌ ନର୍‌ପିଲା ମୁଇ ପାପିମନ୍‍କେ ସର୍‌ପି ଅଇବା ବେଲା କେଟିଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ଉଟା, ଜୁ । ଏଦେ ଦେକା ! ମକେ ଦାରାଇ ଦେବା ଲକ୍‌ ଆସି କେଟ୍‌ଲାବେ ।” ");
INSERT INTO dso_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଏ କାତା କଇବା ବେଲେ ତାର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅନି ଜିଉଦା ନାଉଁର୍‌ ସିସ୍‌ ଆସି କେଟ୍‌ଲା । ତାର୍‌ ସଙ୍ଗ୍‍ କାତି କାଣ୍ଡା ଆରି ଟେଙ୍ଗ୍‌ ଡାଙ୍ଗ୍‌ ଦାରି ବେସି ଲକ୍‌ ତେଇ ଟୁଲ୍‌ ଅଇଲାଇ । ସେମନ୍‌କେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ପାଟାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଉ ଜିଉଦା ସେମନ୍‌କେ ଜାନାଇ ରଇଲା । ସେ ସେମନ୍‌କେ କଇରଇଲା ମୁଇ ଜନ୍‌ ଲକ୍‌କେ ଚୁମ୍‌ବି ତାକେ ତମେ କଜ୍‌ଲାସ୍‌ନି, ତାକେ ଦାରା । ");
INSERT INTO dso_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଜିଉଦା ସଲ୍‌କେ ଜିସୁର୍‌ଲଗେ ଜାଇ ତାକେ “ଏ ଗୁରୁ ଜୁଆର୍‌ !” ବଲିକରି ଚୁମ୍‍ଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ଜିସୁ ଜିଉଦାକେ କଇଲା, “ମଇତର୍‌ ତର୍‌ କାମ୍‌ ଦାପ୍‌ରେ ସାରାଇଦେସ୍‌ ।” ତାର୍‌ ପଚେ ସେମନ୍‌ ଜିସୁକେ ଦାରି ବାନ୍ଦି ପାକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ଜିସୁର୍‌ ବାଟର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‌ ନିଜର୍‌ କାଣ୍ଡା ବାର୍‌କରାଇ ମୁକିଅ ପୁଜାରିର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ମାର୍‌ଲା । ସେ ଲକର୍‌ କାନ୍‌ ଚିଡି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ଜିସୁ ତାକେ କଇଲା, “ତର୍‌ କାଣ୍ଡା ପୁରାଇକରି ସଙ୍ଗ । ଜନ୍‌ ଲକ୍‌ମନ୍‌ କାଣ୍ଡା ଉଟାଇବାଇ, ସେମନ୍‌ କାଣ୍ଡାଇସେ ମର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ତୁଇ କାଇ ନାଜାନୁସ୍‌ କି ? ମୁଇ ମର୍‌ ବାବାକେ ସାଇଜ ମାଙ୍ଗ୍‌ଲେ, ସେ ମର୍‌ପାଇ ଦାପ୍‌ରେସେ, ବାର୍‌ଟା ଦଲେଅନି ଅଦିକ୍‌ ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌କେ ପାଟାଇପାରେ । ");
INSERT INTO dso_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ମାତର୍‌ ସେନ୍ତାର୍‌ ଆଲେ ଏଟାମନ୍‌ ସବୁ ଗଟ୍‌ସି ବଲି ସାସ୍‌ତରେ ଜାଇ ଜାଇଟା ଲେକା ଅଇଲା ଆଚେ, ସେଟା କେନ୍ତି ପୁରାପୁରୁନ୍‌ ଅଇସି ?” ");
INSERT INTO dso_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ତାର୍‌ ପଚେ ଜିସୁ ତେଇ ଟୁଲ୍‌ଅଇରଇବା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ମୁଇ କାଇ ଗଟେକ୍‌ ପାଲାଇବା କାଙ୍ଗାର୍‌ଜେ ଟେଙ୍ଗ୍‌ ଡାଙ୍ଗ୍‌ ଆରି କାଣ୍ଡା ଦାରି ମକେ ଦାର୍‌ବାର୍‌ ଆସିଆଚାସ୍‌ ? ମୁଇ ସବୁ ଦିନ୍‌ ମନ୍ଦିରେ ବସି ସିକିଆ ଦେଇତେ ରଇଲି, ସେବେଲେତା ମକେ ଦାରାସ୍‌ ନାଇ ! ");
INSERT INTO dso_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ଜାଇଟା ଅବେ, ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ସାସ୍‌ତରେ ଜାଇଟା ଲେକ୍‌ଲାଇ ଆଚତ୍‌, ସେ ସବୁ ସିଦ୍‌ ଅଇବାକେ ଏଟା ଗଟ୍‌ଲା ।” ସେଡ୍‌କିବେଲେ ସିସ୍‌ମନ୍‌ ସବୁଲକ୍‌ ଜିସୁକେ ଚାଡି ପାଲାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଜିସୁକେ ବନ୍ଦି କରୁମନ୍‌ ତାକେ ବଡ୍‌ ପୁଜାରି କାୟାପାର୍‌ ଗରେ ନେଲାଇ । ସିତି ଦରମ୍‌ ଗୁରୁ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ଟୁଲ୍‌ ଅଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ପିତର୍‌ କଣ୍ଡେକ୍‌ ଦୁରିକେ ରଇକରି ଜିସୁକେ ଦେକ୍‌ତେ ରଇଲା । ଆରି ସେ କାୟାପା ଗରର୍‌ ଡାଣ୍ଡ୍‍ଜାକ ଗାଲା । ଏ ସବୁ ଗଟ୍‍ନା କାଇଟା ଅଇସି ବଲି ସେଟା ଦେକ୍‌ବାକେ ପିତର୍‌ ମନ୍ଦିର୍‌ ଜାଗୁଆଲ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ତେଇ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ବଡ୍‌ ସବାଇ ରଇଲା ସବୁ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ମରନ୍‌ ଡଣ୍ଡ୍‌ ଦେବାକେ ତାର୍‌ ବିରୁଦେ ମିଚ୍‌ କାତା କଜ୍‌ବାକେ ଚେସ୍‌ଟା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","କେତେ କେତେ ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ବିରୁଦେ ମିଚ୍‌ କାତା କଇଲାଇ । ମାତର୍‌ ସେନ୍ତାରି କାଇ ବୁଲ୍‌ କାତା ମିସା ମିଲେ ନାଇ । ପଚେ ଦୁଇଲକ୍‌ ଉଟିକରି, ");
INSERT INTO dso_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ଏ ଲକ୍‌ ମୁଇ ପର୍‌ମେସରର୍‌ ମନ୍ଦିର୍‌ ବାଙ୍ଗାଇ ଦେଇ, ସେଟା ତିନ୍‌ ଦିନ୍‌ ବିତ୍‌ରେ ଆରି ତରେକ୍‌ ଉଟାଇ ଦେଇପାରି । ” ବଲି କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ବଡ୍‌ ପୁଜାରି ଟିଆଅଇକରି ଜିସୁକେ କଇଲା, “ତୁଇ କାଇକେ କାଇଟାବଲି କଉସ୍‌ ନାଇ ? ଏମନ୍‌ କଇବା କାତା ଚାପ୍‌ବାକେ ତୁଇ ଆରି କାଇଟା କଇବାର୍‌ ଆଚେ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ମାତର୍‌ ଜିସୁ ଚିମ୍‌ରାଅଇ ରଇଲା । ବଡ୍‌ ପୁଜାରି କଇଲା, “ମୁଇ ତମ୍‌କେ ଜିବନ୍‌ ରଇବା ପର୍‌ମେସରର୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କରାଇ ପାଚାର୍‌ଲିନି, ସତ୍‌ କଅ, ତୁଇ କାଇ ପର୍‌ମେସରର୍‌ ପିଲା ମସିଅ କି ?” ");
INSERT INTO dso_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଜିସୁ କଇଲା, “ତୁଇ ସମାନ୍‌ କାତା କଇଆଚୁସ୍‌ । ମାତର୍‌ ମୁଇ ତମ୍‌କେ ସବୁ ଲକ୍‌କେ କଇଲିନି, ପର୍‌ମେସର୍‌ ପାଟାଇଲା ନର୍‌ପିଲା ମୁଇ, ଦାପ୍‌ରେ ସେ ସବୁର୍‌ ଉପ୍‌ରର୍‌ ମାପ୍‌ରୁର୍‌ ଉଜା ବାଟେ ବସ୍‌ବାକେ ଗାଲିନି, ଆରି ମକେ ତମେ ସର୍‌ଗେଅନି ବାଦଲ୍‌ ସଙ୍ଗ୍‌ ଉତ୍‌ରି ଆଇବାଟା ଦେକ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ଏ କାତା ସୁନି ବଡ୍‌ ପୁଜାରି ତାର୍‌ ପିନ୍ଦି ରଇବାଟା ଚିରିପାକାଇ କଇଲା, “ଏଟା ସେ ପର୍‌ମେସର୍‌କେ ନିନ୍ଦା କର୍‌ବାଟା ! ଆରି ବିନ୍‌ ସାକି ଦର୍‌କାର୍‌ ନାଇ । ତମେ ଏବେସେ ଏ ଲକ୍‌ ପର୍‌ମେସର୍‌କେ ନିନ୍ଦା କର୍‌ବାଟା ସୁନ୍‌ଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ଏ ବିସଇନେଇ କରି ତମେ କାଇଟା ବାବ୍‌ଲାସ୍‌ନି ?” ସେମନ୍‌ ସବୁ ଲକ୍‌ କଇଲାଇ, “ସେ ଦସ୍‌ କରିଆଚେ, ମରନ୍‌ ଡଣ୍ଡ୍‌ ପାଇବାର୍‌ ଦର୍‌କାର୍‌ ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ତାର୍‌ ପଚେ ସେମନ୍‌ ଜିସୁର୍‌ ମୁଏଁ ତୁକ୍‌ଲାଇ ଆରି ମାର୍‌ଲାଇ । କେତେ ଲକ୍‌ ତାକେ ଚାପଡ୍‌ ସଙ୍ଗ୍‌ ମାରି କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ଏ କିରିସ୍‌ଟ ! ବବିସତ୍‌ କାତା ଅଲପ୍‌ କଅ । ତକେ କେ ମାର୍‌ଲା କଇଦେକ୍‌ ପନି !” ");
INSERT INTO dso_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ପିତର୍‌ ବଡ୍‌ ପୁଜାରିର୍‌ ଦୁଆର୍‌ ମୁଆଟେ ବସି ରଇଲା ବେଲେ ଗଟେକ୍‌ ବଡ୍‌ ପୁଜାରିର୍‌ ପାଇଟିକାରିଆନି ଲଗେ ଆସି କଇଲା, “ତୁଇ ମିସା ଗାଲିଲିର୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ରଇଲୁସ୍‌ କାଇକି ?” ");
INSERT INTO dso_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ମାତର୍‌ ପିତର୍‌ ସବୁର୍‌ ମୁଆଟେ ନାଡାଇ କରି ଏ କାତା କଇଲା, “ତୁଇ କାଇ ବଲି କଇଲୁସ୍‌ନି ମୁଇ ନାଜାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ଏନ୍ତି କଇକରି ପିତର୍‌ ଦୁଆର୍‌ ମୁଆଁଟ୍‌ ଲଗେ ଉଟିଗାଲା । ଆରି ଗଟେକ୍‌ ବିନ୍‌ ପାଇଟିକାରିଆନି ତାକେ ଦେକି ତେଇ ରଇବା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ଏ ନାଜରିତର୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ପିତର୍‌ ଆରି ତରେକ୍‌ କଇଲା, “ମୁଇ ପର୍‌ମାନ୍‌ କରି କଇଲିନି, ସେ ଲକ୍‌କେ ନାଜାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","କେତେପର୍‌ ଗାଲାପଚେ ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ ପିତରର୍‌ ଲଗେ ଆସି କଇଲାଇ, “ବାଇଦରେ ତୁଇ ମିସା ସେମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ । ତର୍‌ କାତାବାର୍‌ତାଇଅନି ଏଟା ଜାନା ପଡିଗାଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ପିତର୍‌ କଇଲା, “ମୁଇ ପର୍‌ମାନ୍‌ କରି କଇଲିନି, ମର୍‌ କାତା ସତ୍‌ ଆକା । ନଇଲେ ପର୍‌ମେସର୍‌ ମକେ ଡଣ୍ଡ୍‌ ଦେଅ । ସେ ଲକ୍‌କେ ମୁଇ ନାଜାନି ।” ସେଦାପ୍‌ରେ କୁକ୍‌ଡା ଡାକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ଆରି ଜିସୁ ଜନ୍‌ ଜନ୍‌ କାତା କଇରଇଲା, କୁକ୍‌ଡା ନ ଡାକ୍‌ତେ ତୁଇ ମକେ ତିନ୍‌ ତର୍‌ ନାଜାନି ବଲି କଇସୁ । ସେ ସବୁ ପିତର୍‌ ଏତାଇଲା ଆରି ସେ ବାଇରେ ଜାଇ ବେସି ଦୁକ୍‌ ଅଇ କାନ୍ଦ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ତାର୍‌ ଆରକର୍‌ ଦିନର୍‌ ସାକାଲ୍‌ ସାକାଲ୍‌ ଜିସୁକେ ମରାଇଦେବାକେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ରାଜି ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ସେମନ୍‌ ଜିସୁକେ ସିକିଲି ସଙ୍ଗ୍‍ ବାନ୍ଦି ରମ୍‌ରାଇଜର୍‌ ରାଜା ପିଲାତର୍‌ ଲଗେ ଦାରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ଜେଡେବେଲେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଉ ଜିଉଦା ଜିସୁକେ ମରନର୍‌ ଡଣ୍ଡ୍‌ ଆଦେସ୍‌ ଅଇଲା ଆଚେ ବଲି ସୁନ୍‌ଲା, ସେ ଦୁକ୍‌ ଅଇ ଏତାଇଲା ଆରି ମୁକିଅ ପୁଜାରିମନ୍‌କେ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌କେ ତିରିସ୍‌ଟା ରୁପାଟାଙ୍ଗା ବାଉଡାଇଦେଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ଗଟେକ୍‌ କାଇ ଦସ୍‌ ନ ରଇଲା ଲକ୍‌କେ ମୁଇ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା କରି ବଡ୍‌ ପାପ୍‌ କରିଆଚି ।” ସେମନ୍‌ କଇଲାଇ, “ତେଇ ଆମର୍‌ କାଇଟା ଆଚେ ? ସେଟା ତର୍‌ ନିଜର୍‌ କାତା ।” ");
INSERT INTO dso_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ଜିଉଦା ସେମନ୍‌ ଦେଇରଇବା ରୁପାଟାଙ୍ଗା ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ପିଙ୍ଗିଦେଇ ଉଟିଗାଲା । ତାର୍‌ପଚେ ସେ ଜାଇକରି ଗାଲାଇ ଡର୍‌ ବାନ୍ଦି ଉଚ୍‌କିଅଇ ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ମୁକିଅ ପୁଜାରିମନ୍‌ ଜିଉଦା ପିଙ୍ଗି ରଇଲା ରୁପାଟାଙ୍ଗାମନ୍‌ ଟୁଲିଆଇ କଇଲା, “ଏଟା ବନିର୍‌ ମୁଲିଅ, ଏଟା ମନ୍ଦିରର୍‌ ଦାନ୍‌ଦେବା ଜାଗାଇ ସଙ୍ଗଇବାଟା ନିୟମ୍‌ ବିରୁଦର୍‌ କାମ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ସେ ଡାବୁ କେନ୍ତାରି କର୍‌ଚ କରିଅଇସି, ଏ ବିସଇର୍‍ କାତାବାର୍‌ତା ଅଇ କୁମାର୍‌କେତ୍‌ ନାଉଁର୍‌ କଣ୍ଡେକ୍‌ ଜମି ଗେନ୍‌ଲାଇ । ଏଟା ବିନ୍‌ ଦେସର୍‌ ମଲା ଲକ୍‌ମନର୍‌ ପାଇ କବର୍‌ ଦେବା ଜାଗା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ତେବର୍‌ ପାଇ ଆଜିକେ ଜାକ ସେ ଜାଗାକେ ବନିର୍‌ ଜାଗାବଲିକରି କଇଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ଏ ବିସଇ ନେଇକରି ଜିରିମିୟ ବବିସତ୍‌ବକ୍‌ତା ଜେନ୍ତି କଇରଇଲା, ସେଟା ପୁରାପୁରୁନ୍‌ ଅଇଲା । ଜନ୍‌ଟା ତିରିସ୍‌ ଟାଙ୍ଗାକେ ବିକ୍‌ବାକେ ଇସ୍‌ରାଇଲର୍‌ ପିଲାମନ୍‌ ରାଜି କରିରଇଲାଇ ସେଟା ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ଆରି ତିରିସ୍‌ଟା ଅଦ୍‌ଲି ଡାବୁ ନେଇ ସେମନ୍‌ କୁମାର୍‌ କେତ୍‌ ଗେନ୍‌ଲାଇ । ଏଟା କର୍‌ବାକେ ମକେ ମାପ୍‌ରୁ ଆଦେସ୍‌ ଦେଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ଜିସୁର୍‍ ମୁଆଟେ ଦେକି ରମ୍‌ ରାଇଜର୍‍ ସାସନ୍‌କାରିଆ ପିଲାତ ପାଚାର୍‌ଲା, “ତୁଇ କାଇ ଜିଉଦି ମନର୍‌ ରାଜା କି ?” ଜିସୁ ତାକେ କଇଲା, ତୁଇ ସେଟା କଇଲୁସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ମାତର୍‌ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ଜିସୁର୍‌ ବିରୁଦେ ଆନିରଇବା ନିନ୍ଦା କାତାର୍‌ କାଇମିସା ଉତର୍‌ ଦେଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ତେବର୍‌ ପାଇ ପିଲାତ୍‌ ତାକେ କଇଲା, ତର୍‌ ବିରୁଦେ ସେମନ୍‌ ଜାଇ ଜାଇଟା କଇଲାଇନି ସେଟା କାଇ ତୁଇ ସୁନି ନାପାର୍‌ଲୁସ୍‌ନି କି ? ");
INSERT INTO dso_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ମାତର୍‌ ଜିସୁ ପଦେକ୍‌ ମିସା କଏନାଇ ଜେ ପିଲାତ୍‌ କାବାଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ନିସ୍‌ତାର୍‌ ପରବ୍‌ ବେଲେ ରମିୟ ସାସନ୍‌କାରିଆ ଲକ୍‌ମନର୍‌ ମନ୍‍ କଲା ଇସାବେ କାକେ ମିସା ଗଟେକ୍‌ ବନ୍ଦି ଲକ୍‌କେ ବନ୍ଦିଗରେଅନି ମୁକ୍‌ଲାଇଦେବା ରିତିନିତି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ସେବେଲେ ବାର୍‌ବା ନାଉଁର୍‌ ଗଟେକ୍‌ ବଡ୍‌ ଟାଉଟରିଆ ନର୍‌ମାରୁ ବନ୍ଦି ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ତେଇ ଆସି ରଇଲା ଲକ୍‌ମନ୍‌କେ ପିଲାତ୍‌ ପାଚାର୍‌ଲା, “ମୁଇ କାକେ ମୁକ୍‌ଲାଇ ଦେବି ବଲି ତମେ ମନ୍‍ କଲାସ୍‌ନି ? ବାର୍‌ବାକେ କି ଜିସୁକେ, ଜାକେ କିରିସ୍‌ଟ ବଲି କଇବାଇ ?” ");
INSERT INTO dso_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ପିଲାତ୍‌, ଜିଉଦି ନେତାମନ୍‌ ଆଁକାର୍‌ ଅଇ ଜିସୁକେ ତାର୍‌ଟାନେ ସର୍‌ପିଦେଇ ଆଚତ୍‌ ବଲି ନିକ ସଙ୍ଗ୍‌ ଜାନିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ପିଲାତ୍‌ ବିଚାର୍‌ନା ଜାଗାଇ ବସି ରଇଲାବେଲେ ତାର୍‌ ମାଇଜି ଗଟେକ୍‌ କବର୍‌ କଇଲା, “କାଇ ଦସ୍‌ପାପ୍‌ ନ କଲା ସେ ଲକ୍‌କେ କାଇଟା କରା ନାଇ । କାଲି ରାତି ସପ୍‌ନେ ତାର୍‌ ଲାଗି ମୁଇ ବେସି କସ୍‌ଟ ପାଇଲି । ” ");
INSERT INTO dso_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ବାର୍‌ବାକେ ମୁକ୍‌ଲାଇ ଦେଇକରି, ଜିସୁକେ ମରନ୍‌ ଡଣ୍ଡ୍‌ ଦେବାକେ ଲକ୍‌ମନ୍‌କେ ପିଲାତର୍‌ ଲଗେ ଜାଇ ଦାବି କର୍‌ବାକେ ଉସ୍‌କାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ପିଲାତ୍‌ ଆରି ତରେକ୍‌ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ମୁଇ ଏ ଦୁଇ ଲକର୍‌ ବିତ୍‌ରେଅନି କାକେ ମୁକ୍‌ଲାଇ ଦେବି ବଲି ତମେ ମନ୍‍ କଲାସ୍‌ନି ?” ସେମନ୍‌ କଇଲାଇ, “ବାର୍‌ବାକେ ” ");
INSERT INTO dso_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତ୍‌ ପାଚାର୍‌ଲା, “ତେବେ ସବୁ ଲକ୍‌ ମସିଅ ବଲି ଜାନିରଇଲା ଜିସୁକେ ମୁଇ କାଇଟା କର୍‌ବି ?” “ତାକେ କୁର୍‌ସେ ଚଗାଆ” ବଲି ସବୁଲକ୍‌ ଆଉଲି ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ପିଲାତ୍‌ ପାଚାର୍‌ଲା, “ମାତର୍‌ ସେ କାଇ ଦସ୍‌ କଲା ଆଚେ ?” ସେମନ୍‌ ଆରି ଅଦିକ୍‌ ଆଉଲିଅଇ କଇବାର୍‌ ଦାର୍‌ଲାଇ “ତାକେ କୁର୍‌ସେ ଚଗାଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ଜେଡେବେଲେ ପିଲାତ୍‌ ଦେକ୍‌ଲା ଜେ ସେମନ୍‌କେ ଆରି କାଇଟା କଇକରି ମିସା ଲାବ୍‌ ନାଇ, ନଇଲେ ଗଣ୍ଡ୍‍ଗଲ୍‌ ଅଇବାର୍‌ ଉପ୍‌ରେ ଆଚେ, ସେ ପାନି ଗୁଡିକ୍‌ ନେଇ, ସବୁ ଲକ୍‌ମନର୍‌ ମୁଆଟେ ଆତ୍‌ ଦଇପାକାଇ କଇଲା, “ଏ ଲକର୍‌ ମରନର୍‌ ପାଇ ମୁଇ ଦାଇ ନାଇ । ଏଟା ତମର୍‌ କାମ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ତାର୍‌ ମରନର୍‍ ଡଣ୍ଡର୍‌ ଦସ୍‌ ପାଇବାର୍‌ ରଇଲେ, ସେ ଦସ୍‌ ଆମ୍‌କେ ଆରି ଆମର୍‌ ପିଲାଜିଲାକେ ପଡ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ସାରାସାରି ପିଲାତ୍‌ ବାର୍‌ବାକେ ମୁକ୍‌ଲାଇଦେଇ ଜିସୁକେ କର୍‌ଡା ସଙ୍ଗ୍‌ ମାର୍‌ବାକେ ଆଦେସ୍‌ ଦେଲା, ତାର୍‌ ପଚେ କୁର୍‌ସେ ମରାଇବା ପାଇ ସନିଅମନ୍‍କେ ସର୍‌ପି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ପିଲାତର୍‌ ସନିଅମନ୍‌ ଜିସୁକେ ରମିୟ ସାସନ୍‌କାରିଆର୍‌ ଗରେ ଦାରି ଗାଲାଇ ଆରି ତାର୍‌ ଚାରିବେଟ୍‌ତି ଟିଆଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ସେ ପିନ୍ଦି ରଇବାଟା ବେଟି ନେଇକରି ତାକେ ଗଟେକ୍‌ ଜାମ୍‌କଲି ରଙ୍ଗର୍‌ ବସ୍‌ତର୍‌ ପିନ୍ଦାଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","କାଟାର୍‌ ମୁକୁଟ୍‌ ତିଆର୍‌ କରି ତାର୍‌ ମୁଣ୍ଡେ ପିନ୍ଦାଇ ଦେଲାଇ ଆରି ତାର୍‌ ଉଜା ଆତେ ଗଟେକ୍‌ ଡାଙ୍ଗ୍‌ ଦାରାଇ ଦେଲାଇ । ତାର୍‌ ପଚେ, ତାର୍‌ ମୁଆଟେ ମାଣ୍ଡିକୁଟା ଦେଇ କିଜାଇକରି କଇଲାଇ, “ଏ ଜିଉଦିମନର୍‌ ରାଜା ! ବେସି ଦିନ୍‌ ବଁଚି ରଅ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ସେମନ୍‌ ଜିସୁର୍‌ ଉପ୍‌ରେ ତୁକି ପାକାଇଲାଇ ଆରି ସେ ଦାରି ରଇବା ଡାଙ୍ଗ୍‌ସଙ୍ଗ୍‌ ତାର୍‌ ମୁଣ୍ଡେ ମାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ତାକେ ଏନ୍ତାରି କିଜାଇ ସାର୍‌ଲା ପଚେ ରାଜା ପିନ୍ଦ୍‌ବା ବସ୍‌ତର୍‌ ବେଟିଦେଇ ତାର୍‌ ନିଜର୍‌ ବସ୍‌ତର୍‌ ପିନ୍ଦାଇଦେଲାଇ ଆରି ତେଇଅନି ତାକେ କୁର୍‌ସେ ଚଗାଇବାକେ ଦାରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ସେମନ୍‌ ଜିବାବାଟେ କୁରିଣି ସଅରର୍‌ ସିମନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ବେଟ୍‌ଅଇଲାଇ ଆରି ସନିଅମନ୍‌ ତାକେ ଜିସୁର୍‌ କୁର୍‌ସ ବଇ ନେବାକେ ବାଦିଅ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ସେମନ୍‌ ଗଲ୍‌ଗତା ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ କେଟ୍‌ଲାଇ । ଗଲ୍‌ଗତାର୍‌ ଅରତ୍‌ ଅଇଲାନି, ମୁଣ୍ଡ୍‍ଗିଗ୍‌ଡି ପାରା ରଇବା ଜାଗା । ");
INSERT INTO dso_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ତେଇ ସେମନ୍‌ ଜିସୁକେ ପିତା ରଇବା ଅଙ୍ଗୁର୍‌ ରସ୍‌ କାଇବାକେ ଦେଲାଇ । ସେଟା ଜିସୁ ଅଲପ୍‌ ଚାକିକରି ଆରି କାଏନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ସେମନ୍‌ ଜିସୁକେ କୁର୍‌ସେ ମାରି କରି ସେ ପିନ୍ଦିରଇବା ବସ୍‌ତର୍‌ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କେଡ୍‌ପୁଟାଇ ବାଟାକରି ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ତାର୍‌ପଚେ ସେମନ୍‌ କୁର୍‌ସେ ଚଗାଇଲା ଜିସୁକେ, ତେଇ ଜାଗି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ତାର୍‌ ବିରୁଦେ ଲେକାଅଇରଇବା ଗଟେକ୍‌ ବରଡ୍‌ ଲେକି ତାର୍‌ ମୁଣ୍ଡ୍‌ ଉପ୍‌ରେ, ଜୁଲାଇ ରଇଲାଇ । ସେ ବରଡ୍‌ ଲଗେ ଏନ୍ତି ଲେକାଅଇରଇଲା, ଏ ଅଇଲାନି ଜିଉଦିମନର୍‌ ରାଜା, ଜିସୁ । ");
INSERT INTO dso_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ତାର୍‌ପଚେ ସେମନ୍‌ ତେଇ ଦୁଇଟା ଚର୍‌ମନ୍‌କେ ଆନ୍‌ଲାଇ । ଗଟେକ୍‌କେ ଜିସୁର୍‌ ଉଜା ବାଟେ ଆରି ଗଟେକ୍‌କେ ତାର୍‌ ଡେବ୍‌ରି ବାଟେ କୁର୍‌ସେ ଚଗାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ସେବାଟେ ଜାଇତେ ରଇବା ଲକ୍‌ମନ୍‌ ମୁଣ୍ଡ୍ ଜୁଲାଇ ଜୁଲାଇ ଜିସୁକେ କିଜାଇ କିଜାଇ କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ ତୁଇସେ କାଇକି ମନ୍ଦିର୍‌ ବସ୍‌ଲାଇଦେଇ ତିନ୍‌ ଦିନ୍‌କେ ଆରି ତରେକ୍‌ ତିଆର୍‌ କରିଦେଇତେ ରଇଲୁସ୍‌ ? ତୁଇ ଜଦି ପର୍‌ମେସରର୍‌ ପଅ, ନିଜ୍‌କେ ରକିଆ କର୍‌ ଆରି କୁର୍‌ସେଅନି ଉତ୍‌ରି ଆଉ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ମୁକିଅ ପୁଜାରି, ଦରମ୍‌ ଗୁରୁ ଆରି ଜିଉଦି ଜାତିର୍‌ ପାର୍‌ଚିନ୍‌ ନେତାମନ୍‌ ମିସା ଜିସୁକେ କିଜାଇକରି କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ସେ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ରକିଆ କର୍‌ତେ ରଇଲା, ମାତର୍‌ ନିଜ୍‌କେ ରକିଆ କରିନାପାର୍‌ଲାନି । ସେ ଇସ୍‌ରାଏଲର୍‌ ରାଜା କାଇକି ? ଏବେ ଜଦି ସେ କୁର୍‌ସେଅନି ଉତ୍‌ରି ଆସି ପାର୍‌ସି ବଇଲେ ଆମେ ତାକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବୁ । ");
INSERT INTO dso_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ସେ ନିଜେ ମୁଇ ପର୍‌ମେସରର୍‌ ପଅ ବଲି କଇ, ପର୍‌ମେସର୍‌ଟାନେ ଆସା କଲାଆଚେ । ଆଲେ ଦେକୁ ତେବେ, ପର୍‌ମେସର୍‌ ତାକେ ଏବେ ରକିଆ କର୍‌ବାକେ ମନ୍‍ କଲାନି କି ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ଜିସୁର୍‌ ସଙ୍ଗ୍‍ କୁର୍‌ସେ ଚଗିରଇବା ଦୁଇଟା ଚର୍‌ମନ୍‌ ମିସା ତାକେ ସେନ୍ତାରି କିଜାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ସେ ଦିନେ ମୁଣ୍ଡ୍‌ବେଲାଇ ଅନି ଆଡ୍‌ବେଲାଇ ଜାକ ଗୁଲାଇ ଜଗତ୍‌ ଆନ୍ଦାର୍‌ ଅଇଗାଲା ଆରି ସେଟା ତିନ୍‌ ଗନ୍‌ଟାଜାକ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ଆଡ୍‌ବେଲାର୍‌ ତିନ୍‌ଟା ବେଲେ ଜିସୁ ଆକ୍‌ମାରି କଇଲା, “ଏଲି, ଏଲି, ଲାମାସବକ୍‌ତାନି, ବଇଲେ ଏ ମର୍‌ ପର୍‌ମେସର୍‌, ଏ ମର୍‌ ପର୍‌ମେସର୍‌, ମକେ ତମେ କାଇକେ ଚାଡିଦେଲାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ଲଗେ ଟିଆ ଅଇରଇବା କେତେ ଲକ୍‌ ଏଟା ସୁନିକରି କଇଲାଇ, “ସେ ଏଲିୟକେ ଡାକ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ଗଟେକ୍‌ ଲକ୍‌ ପାଲାଇ ଜାଇ ପିତା ରଇଲା ଅଙ୍ଗୁର୍‌ରସ୍‌ଟାନେ ଗଟେକ୍‌ ସୁତାର୍‌ ଗର୍‌ଣ୍ଡା ବୁଡାଇଲା । ଆରି ସେଟା ଲାଟି ଟିପେ ବାନ୍ଦି କାଅ ବଲି ଜିସୁର୍‌ ମୁଆଟେ ଲାମାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ବିନ୍‌ ଲକ୍‌ମନ୍‌ କଇଲାଇ “ଚନେକ୍‌ ଜାଗା, ତାକେ ଏଲିୟ ରକିଆ କର୍‌ବାକେ ଆଇଲାନି କି ନାଇ ଦେକିଦେକୁ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ଜିସୁ ଆରି ତରେକ୍‌ ଆକ୍‌ମାରିକରି, ସାରାସାରି ଜିବନ୍‌ ଚାଡିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ସେଡ୍‌କି ବେଲେ ମନ୍ଦିରେ ଜୁଲ୍‌ତେ ରଇବା ପାର୍‌ଦା ଉପ୍‌ରେଅନି ତଲେ ଜାକ ଦୁଇ ଗନ୍ଦାଅଇ ଚିରିଅଇଗାଲା । ଦର୍‌ତନି ଚୁଲ୍‌ବୁଲି ପାକ୍‌ନାମନ୍‌ ସବୁ ପୁଟିଗାଲା ");
INSERT INTO dso_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ଆରି କବର୍‌ ଦେଇରଇବା କାଲ୍‌ମନ୍‌ ଉଗାଡିଅଇ କେତେକ୍‌ କେତେକ୍‌ ପର୍‌ମେସରର୍‌ ଦରମ୍‌ ଲକ୍‌ମନ୍‌ ଆରିତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ସେମନ୍‌ କବର୍‌ ଦେଇରଇବା କାଲେଅନି ଉଟି ଆଇଲାଇ । ଜିସୁ ଆରିତରେକ୍‌ ଉଟ୍‌ଲା ପଚେ ଲକ୍‌ମନ୍‌, ଏମନ୍‌କେ ସୁକଲ୍‌ ଜାଗା ଜିରୁସାଲମେ ଜିବାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ଦର୍‌ତନି ଚୁଲ୍‌ବୁଲି ବିନ୍‌ ବିନ୍‌ ଗଟ୍‍ନା ଅଇବାଟା ଦେକି, ଜିସୁକେ ଜାଗିରଇବା ସନିଅମନର୍‌ ମୁକିଅ ଆରି ବିନ୍‍ ସନିଅମନ୍‌ ଡରିଗାଲାଇ । ସେମନ୍‌ କଇଲାଇ, “ସତଇସେ ଏ ନିଜେ ପର୍‌ମେସରର୍‌ ପଅ ଆକା !” ");
INSERT INTO dso_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଗାଲିଲିଅନି ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ରଇକରି ତାକେ ସାଇଜ କରିରଇବା କେତେଟା ମାଇଜି ଦୁରିକେ ରଇକରି ଏଟା ସବୁ ଦେକ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ସେମନର୍‌ ବିତ୍‌ରେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଜାକୁବ୍‌ ଆରି ଜସେପର୍‌ ମାଆ ମରିୟମ୍‌ ଆରି ଜେବଦିର୍‌ ମାଇଜି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ସଞ୍ଜ୍‌ବେଲାଇ ଆରାମାତିଆ ସଅରର୍‌ ଜସେପ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ସାଉକାର୍‌ ଆସି କେଟ୍‌ଲା । ସେ ମିସା ଗଟେକ୍‌ ସିସ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ସେ ପିଲାତ୍‌କେ ବେଟ୍‌ଅଇକରି ଜିସୁର୍‌ ମଲାମଡ୍‌ ଦାରିଜିବାକେ ଗୁଆରି କଲା । ଜସେପ୍‌ ଗୁଆର୍‌ଲାକେ ପିଲାତ୍‌ ମଡ୍‌ ନେବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ସେ ଜିସୁର୍‌ ଗାଗଡ୍‌ ଦାରିଗାଲା ଆରି ଗଟେକ୍‌ ନୁଆ ଚାଦର୍‌ ଗର୍‌ଣ୍ଡାଇ ଗୁଡିଆଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ପାକ୍‌ନାଇ ତାକର୍‌ ନିଜର୍‌ ପାଇ କୁନି ରଇବା ଗଟେକ୍‌ ନୁଆ କବର୍‌ ଦେବା ପାଆରେ ସେଟା ନେଇ ସଙ୍ଗଇଲା ଆରି ସେ ପାଆର୍‌ ମୁଆଟେ ଗଟେକ୍‌ ବଡ୍‌ଟା ଚାଚଡା ପାକ୍‌ନା ଡାବିଦେଇ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆରି ବିନ୍‌ ମରିୟମ୍‌ ଜିସୁକେ କବର୍‌ ଦେଲା ପାଆର୍‌ ମୁଆଟେ ବସି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନର୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ପିଲାତ୍‌କେ ବେଟ୍‌ଅଇ କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ଆଗିଆଁ, ସେ ବେସି ମିଚୁଆଟା । ବଁଚିରଇଲାବେଲେ ‘ମୁଇ ତିନ୍‌ଦିନ୍‌ ପଚେ ଆରିତରେକ୍‌ ଉଟ୍‌ବି’ ବଲି କଇତେ ରଇଲା । ଏଟା ଆମର୍‌ ମନେ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ତେବର୍‌ ପାଇ ତିନ୍‌ ଦିନ୍‌ ଜାକ ତାକେ କବର୍‌ ଦେଲାଟାନେ ଜାଗୁଆଲ୍‌ ଦାର୍‌ବାକେ ଆଦେସ୍‌ ଦିଆସ୍‌ । ସେନ୍ତି କଲେ ତାର୍‌ ସିସ୍‌ମନ୍‌ ତାର୍‌ ଗାଗଡ୍‌ ଚରାଇନେଇ ସେ ଜିବନ୍‌ ଅଇକରି ମଲାତେଇଅନି ଉଟ୍‌ଲା ବଲି କଇନାପାରତ୍‌ ।” ସେମନର୍‌ ଏନ୍ତାରି ମିଚ୍‌ କାତା ଜାନାଇବାଟା ସବୁର୍‍ଟାନେଅନି ଅଦିକ୍‌ କେତି ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତ୍‌ କଇଲା, “ଗଟେକ୍‌ ଦଲ୍‌ ଜାଗୁଆଲ୍‌ମନ୍‌କେ ନିଆ ଆରି ତାକେ କବର୍‌ ଦେଲାଟାନେ କାଇଟା ନ ପୁର୍‌ଲା ପାରା ଜାଗାଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ସେମନ୍‌ ଜାଇକରି ଜିସୁକେ କବର୍‌ ଦେଲାଟାନେ ଜାଗ୍‍ବାକେ ସନିଅମନ୍‌ ଟିକ୍ କଲାଇ । କବର୍‌ ମୁଆଟେ ଡାବି ରଇବା ପାକ୍‌ନା ଉପ୍‌ରେ ସିଲ୍‌ମାରି ଜାଗୁଆଲ୍‌ମନ୍‌କେ ଜାଗାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ବିସ୍‌ରାମ୍‌ବାରର୍‌ ଆର୍‌କର୍‌ ଦିନେ, ରଇବାର୍‌ ସାକାଲେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆରି ବିନ୍‌ ମରିୟମ୍‌ ଜିସୁକେ ସଙ୍ଗଇରଇବା କବର୍‌ ଦେକ୍‌ବାର୍‌ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ସେଡ୍‌କିବେଲେ ଅଟାତ୍‌ ଦର୍‌ତନି ଚୁଲ୍‌ବୁଲିଗାଲା । ଏଦେ ଦେକା ! ମାପ୍‌ରୁର୍‌ ଗଟେକ୍‌ ସରଗ୍‌ ଦୁତ୍‌ ଉତ୍‌ରି ଆସି, କବର୍‌ ମୁଆଟେ ଡାବିରଇଲା ପାକ୍‌ନା ଡୁଲ୍‌ଗୁଡାଇଦେଇ ତାର୍‌ ଉପ୍‌ରେ ବସି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ତାର୍‌ ଗୁଲାଇ ଗାଗଡ୍‌ ବିଜ୍‌ଲି ପାରା ଜଟକ୍‌ତେରଇଲା ଆରି ସେ ପିନ୍ଦିରଇବାଟା ବରପ୍‌ ପାରା ଚିଟ୍‌ ଦବ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ଜାଗୁଆଲ୍‌ମନ୍‌ ଦୁତ୍‌କେ ଦେକି ଡରି ତର୍‌ତରି ଗାଲାଇ ଆରି ମଲା ଲକର୍‌ପାରା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ସରଗର୍‌ ଦୁତ୍‌ ମାଇଜିମନ୍‌କେ କଇଲା, “ଡରା ନାଇ । ମୁଇ ଜାନି, ତମେ କୁର୍‌ସେ ମରିରଇବା ଜିସୁକେ ଦେକ୍‌ବାର୍‌ ଆସିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ସେ ଇତି ନାଇ । ସେ କଇଲା ଇସାବେ ଆରି ତରେକ୍‌ ଉଟି ଆଚେ । ଆସି ଦେକା, ଇତି ତାର୍‌ ମଲା ଗାଗଡ୍‌ ସଙ୍ଗଇରଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“ତମେ ଦାପ୍‌ରେ ଜାଇ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କୁଆ, ସେ ଆରି ତରେକ୍‌ ଜିବନ୍‌ ଅଇଆଚେ ଆରି ତମର୍‌ ଆଗେ ଆଗେ ଗାଲିଲି ଗାଲା ଆଚେ । ତମେ ତେଇ ତାକେ ଦେକ୍‌ସା । ମୁଇ ଜାଇଟା କଇଲି ମନେ ରକିରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ଏ କାତାସୁନି ସେମନ୍‌ ଦାପ୍‌ରେ କବର୍‌ଦେଲା ଟାନେଅନି ସିସ୍‌ମନର୍‌ ଲଗେ ପାଲାଇଲାଇ । ଡରିକରି ରଇଲେ ମିସା, ତାକର୍‌ ମନେ ବେସି ସାର୍‌ଦା ଜାନିପାର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ସେଦାପ୍‌ରେ ଜିସୁ ସେମନ୍‌କେ ବେଟ୍‌ଅଇ କଇଲା, “ତମ୍‌କେ ସାନ୍ତି ମିଲ !” ସେମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଜାଇ ତାର୍‌ ପାଦ୍‌ ଦାରି ଜୁଆର୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଡରା ନାଇ । ମର୍‌ ବାଇମନ୍‌କେ କୁଆ, ସେମନ୍‌ ଗାଲିଲି ଆସତ୍‌ । ତେଇ ସେମନ୍‌ ମକେ ଦେକ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ମାଇଜିମନ୍‌ ତେଇଅନି ଇଣ୍ଡିଜାଇତେ ରଇଲାଇ । ଜିବାବେଲେ ଜିସୁକେ କବର୍‌ ଦେଇ ରଇବାଟାନେ ଜାଗି ରଇଲା କେତେଟା ସନିଅମନ୍‌ ନଅରେ ବାଉଡି ଗାଲାଇ । ଜାଇକରି ମୁକିଅ ପୁଜାରିମନ୍‌କେ ଏ ସବୁ ଅଇଲାଟା ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ମୁକିଅ ପୁଜାରିମନ୍‌ ପାର୍‌ଚିନ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ମିସି କୁଟ୍‌ ପାଁଚ୍‌ଲାଇ । ସେମନ୍‌ ସନିଅମନ୍‌କେ ବେସି ଡାବୁ ଲାଁଚ୍‍ଦେଇ କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ତମେ କୁଆ “ଆମେ ରାତିଆ ସଇଦେଇ ରଇଲା ବେଲେ ତାର୍‌ ସିସ୍‌ମନ୍‌ ଆସି ତାର୍‌ ମଲା ଗାଗଡ୍‌ ଚରାଇ ଦାରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଜଦି ସାସନ୍‌କାରିଆ ଏ କାତା ନ ସୁନ୍‍ସି, ବଇଲେ ତମର୍‌ ଦସ୍‌ ନାଇ ବଲି ଆମେ ବୁଜାଇ ଦେବୁ । ଏ ବିସଇନେଇ ତମେ ଦାନ୍ଦା ଉଆନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ସନିଅମନ୍‌ ଡାବୁ ନେଇକରି, ସେମନ୍‌କେ କଇରଇଲା ଇସାବେ କାମ୍‌ କଲାଇ । ସେମନ୍‌ ସେବେଲେ ଜେନ୍ତି କଇରଇଲାଇ, ଜିଉଦିମନ୍‌ ଆଜିକେ ଜାକ ସେ କାତା ଜାନାଇଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ଜିସୁ କଇବା ଇସାବେ ତାର୍‌ ଏଗାର୍‌ଟା ସିସ୍‌ମନ୍‌ ଗାଲିଲିର୍‌ ଗଟେକ୍‌ ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ଜିସୁକେ ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ଦେକି ସେମନ୍‌ ତାକେ ଜୁଆର୍‌ କଲାଇ । କେତେ ଲକ୍‌ ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଜିସୁ ସେମନର୍‌ ଲଗେ ଜାଇ କଇଲା, “ସରଗ୍‌ ଆରି ମଚ୍‌ପୁରର୍‌ ସବୁ ଅଦିକାର୍‌ ମକେ ଦିଆଅଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ତେବେ ତମେ ଦେସ୍‌ମନ୍‌କେ ରଇବା ସବୁ ବାସାର୍‌ ଲକ୍‌ମନର୍‌ ଲଗେ ଜାଇ, ସେମନ୍‌କେ ମର୍‌ ସିସ୍‌ କରାଆ । ବାବା, ପଅ ଆରି ସୁକଲ୍‌ ଆତ୍‌ମାର୍‌ ନାଉଁଦାରି ସେମନ୍‌କେ ଡୁବନ୍‌ ଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ଆରି ମୁଇ ଜନ୍‌ ସବୁ ସିକିଆ ଦେଇଆଚି, ସେଟା ମାନା ବଲି ସିକାଆ । ଆରି ମନେ ରଅ, କାଲ୍‌ କାଲ୍‌ ଜୁଗ୍‌ ଜୁଗ୍‌ ମୁଇ ସବୁବେଲେ ତମର୍‌ ସଙ୍ଗ୍‌ ରଇବି ।”");
INSERT INTO dso_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ଏଟା ଅଇଲାନି ପର୍‌ମେସରର୍‌ ପଅ ଜିସୁ କିରିସ୍‌ଟର୍‌ ନିମାନ୍‌ କବରର୍‌ ଆରାମ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ଏଟା ଏନ୍ତାରି ଆରାମ୍‌ ଅଇଲା । ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ସାସ୍‌ତରେ ଜେନ୍ତାର୍‌ ଲେକାଅଇଲା ଆଚେ, ପର୍‌ମେସର୍‌ କଇଲା, ଦେକା ମୁଇ ମର୍‌ କବର୍‌ ଜାନାଉକେ ତମର୍‌ ଆଗେ ପାଟାଇଲିନି, ସେ ତମର୍‌ ବାଟ୍‌ ତିଆର୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ତାର୍‌ ସର୍‌ ମରୁବାଲି ବୁଏଁ ଆଉଲିଅଇକରି ସୁନାଇଲାନି ମାପ୍‌ରୁର୍‌ ବାଟ୍‌ ତିଆର୍‌ କରା, ତାର୍‌ପାଇ ବାଟ୍‌ ସଲ୍‌କାଆ । ");
INSERT INTO dso_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ତାର୍‌ପଚେ ଏ ସବୁ କାତା ପୁରାପୁରୁନ୍‌ ଅଇଲା, ଜେଡେବେଲେ, ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ମରୁବାଲିବୁଏଁ ଆସି ପାପ୍‌ କେମାର୍‌ ଲାଗି ବଲି ପାପ୍‌ଟାନେଅନି ବାଉଡାଇବା ବିସଇ କଇବାର୍‌ ଦାର୍‌ଲା । “ତମର୍‌ ପାପ୍‌ କେମା ଅଇବାକେ ପାପ୍‌ଟାନେ ମନ୍‌ ବାଦ୍‌ଲାଇ ଡୁବନ୍‌ ନିଆ । ପର୍‌ମେସର୍‌ ତମର୍‌ ପାପ୍‌ କେମା କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ସେଡ୍‌କିବେଲେ ଜିଉଦାଦେସର୍‌ କେତେକ୍‌ ଲକ୍‌ ଆରି ଜିରୁସାଲାମ୍‌ ରାଇଜର୍‌ ସବୁ ଲକ୍‌ମନ୍‌ ବାରଇକରି ଜଅନର୍‌ କାତା ସୁନୁ ବଲି ଆଇବାର୍‌ ଦାର୍‌ଲାଇ । ଆରି ନିଜର୍‌ ନିଜର୍‌ ପାପ୍‌କଲାଟା ମାନିକରି ଜର୍‌ଦନ୍‌ ଗାଡେ ତାର୍‌ତେଇଅନି ଡୁବନ୍‌ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ଜଅନ୍‌ ଉଟର୍‌ ଚେଣ୍ଡିସଙ୍ଗ୍‌ ତିଆର୍‌ ଅଇଲା ଲୁଗା ପିନ୍ଦି, ପସୁ ଚାମର୍‌ ଆଁଟାବେଡା ଆଁଟାଇ ବାନ୍ଦି ଅଇତେରଇଲା । ତାର୍‌ କାଦି ଅଇଲା ଚିଟ୍‌କା ଆରି ବନର୍‌ ମୁ । ");
INSERT INTO dso_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ସେ ଜାନାଇକରି କଇବାର୍‌ ମୁଲିଆଇଲା, “ମର୍‌ ପଚେ ଗଟେକ୍‌ ବେସି ବପୁର୍‌ ଲକ୍‌ ଆଇସି, ତାର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ଅଇକରି ତାର୍‌ ଗଡର୍‌ ପାଣ୍ଡଇ ବେଟ୍‌ବାର୍‌ ମିସା ମର୍‍ ଅଦିକାର୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ମୁଇ ତମ୍‌କେ ପାନିତେଇ ଡୁବନ୍‌ ଦେଲିନି, ମାତର୍‌ ସେ ତମ୍‌କେ ସୁକଲ୍‌ଆତ୍‌ମାଇ ଡୁବନ୍‌ ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ସେଡ୍‌କିବେଲେ ଜିସୁ ଗାଲିଲି ଜାଗାର୍‌ ନାଜରିତ୍‌ ଗଡେ ଅନି ଆସି ଜର୍‌ଦନ୍‌ ଗାଡେ ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ଟାନେ ଡୁବନ୍‌ ନେଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ସେ ପାନିତେଇ ଅନି ବାରଇ ଆଇବାବେଲେ, ସରଗ୍‌ ଉଗାଡି ଅଇ ପର୍‌ମେସରର୍‌ ଆତ୍‌ମା ପରୁଆ ପାରା ଅଇ ଜିସୁର୍‌ ଉପ୍‌ରେ ଉତ୍‌ରି ଆଇବାଟା ସେ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ଆରି ସର୍‌ଗେଅନି ଗଟେକ୍‌ ସର୍‌ ସୁନିଅଇଲା, “ତୁଇ ମର୍‌ ଆଲାଦର୍‌ ପିଲା, ତର୍‌ଟାନେ ମୁଇ ବେସି ସାର୍‌ଦା ।” ");
INSERT INTO dso_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ସେଦାପ୍‌ରେ ସୁକଲ୍‌ ଆତ୍‌ମା ଜିସୁକେ ମରୁବାଲି ବୁଏଁ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ମରୁବାଲି ବୁଏଁ ଚାଲିସ୍‌ ଦିନ୍‌ ରଇଲାବେଲେ, ସଇତାନ୍‌ ତାକେ ପାପ୍‌କରାଇବାକେ ଚେସ୍‌ଟା କର୍‌ତେରଇଲା । ସେ ଜାଗାଇ ବନର୍‌ ଜଁତ୍‌ମନ୍‌ ରଇଲାଇ, ଆରି ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌ ଆସି ତାର୍‌ ସେବା କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","କେତେଦିନ୍‌ ଗାଲାପଚେ ଏରଦ୍‌ରାଜା ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌କେ ବନ୍ଦି ଗରେ ସଙ୍ଗଇଲା ପଚେ ଜିସୁ ଗାଲିଲି ଗାଏଁ ବାଉଡିଆସି, ପର୍‌ମେସରର୍‌ ନିମାନ୍‌ କବର୍‌ ସୁନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“ସମାନ୍‍ ବେଲା ଆଇଲା, ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଲଗେ କେଟ୍‌ଲା ଆଚେ । ତମେ ପାପେ ଅନି ମନ୍‌ ବାଉଡାଇକରି ନିମାନ୍‌ କାତାଇ ବିସ୍‌ବାସ୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ଜିସୁ ଗାଲିଲି ସମ୍‌ଦୁର୍‌ କଣ୍ଡିବାଟେ ଜିବା ବେଲେ ସିମନ୍‌ ଆରି ତାର୍‌ ବାଇ ଆନ୍ଦ୍‌ରିଅକେ ସମ୍‌ଦୁରେ ବଇଜାଲ୍‌ ପାକାଇବାଟା ଦେକ୍‌ଲା, ସେମନ୍‌ ମାଚ୍‌ ଦାରୁ କେଉଟ୍‌ମନ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମର୍‌ ସଙ୍ଗ୍‌ ଆସା, ମୁଇ ତମ୍‌କେ ଲକ୍‌ମନ୍‌କେ ପର୍‌ମେସରର୍‌ ବାଟେ ଆନ୍‌ବା ବିସଇ ସିକାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ସେଦାପ୍‌ରେ ସେମନ୍‌ ଜାଲ୍‌ ଚାଡି ଜିସୁର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ପଚେ କଣ୍ଡେକ୍‌ ଦୁର୍‌ ଜାଇ ଜେବଦିର୍‌ ପଅମନ୍‌ ଜାକୁବ୍‌ ଆରି ତାର୍‌ ବାଇ ଜଅନ୍‌କେ ଡଙ୍ଗାଇ ଜାଲ୍‌ ସାଜାଡ୍‌ବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ଜିସୁ ସେମନ୍‌କେ ଦେକ୍‌ଲା ଦାପ୍‌ରେ ଡାକ୍‌ଲା, ଆରି ସେମନ୍‌ ତାକର୍‌ ବାବା ଜେବଦିକେ ଆରି କୁଲିଆର୍‌ମନ୍‌କେ ଡଙ୍ଗାଇ ଚାଡି ତାର୍‌ ସଙ୍ଗ୍‌ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ପଚେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ କପର୍‌ନାଉମେ ଗାଲାଇ, ଆରି ବିସ୍‌ରାମ୍‌ବାର୍‌ କେଟ୍‌ଲାକେ ସେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ପୁରି, ଲକ୍‌ମନ୍‌କେ ସିକାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ଲକ୍‌ମନ୍‌ ତାର୍‌ ସିକିଆ ସୁନି କାବା ଅଇଗାଲାଇ, ସେ ସାସ୍‌ତର୍‌ ସିକାଉପାରା ନ ସିକାଇ, ନିଜର୍‌ ଅଦିକାର୍‌ ସଙ୍ଗ୍‌ ସିକିଆ ଦେଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ସେ ଦାପ୍‌ରେ ସେମନର୍‌ ପାର୍‌ତନା ଗରେ ଗଟେକ୍‌ ଡୁମା ଦାର୍‌ଲା ଲକ୍‌ କିର୍‌କିରି କରି ଜିସୁକେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ଏ ନାଜରିତ୍‌ ଗଡର୍‌ ଜିସୁ, ତୁଇ କାଇକେ ଆମ୍‌କେ ଅରିଆନ୍‌ କଲୁସ୍‌ନି ? ତୁଇ କାଇ ଆମ୍‌କେ ବିନାସ୍‌ କର୍‌ବାକେ ଆଇଲୁସ୍‌ କି ? ତୁଇ କେ, ସେଟା ମୁଇ ଜାନି, ତୁଇ ଅଇଲୁସ୍‌ନି ପର୍‌ମେସରର୍‌ ସୁକଲ୍‌ ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ଜିସୁ ଡୁମାକେ ଦମ୍‌କାଇ କରି କଇଲା, “ଚୁପ୍‌ ଅ, ଆରି ଏ ଲକର୍‌ତେଇ ଅନି ବାର୍‌ଇ ଜା ।” ");
INSERT INTO dso_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ସେଡ୍‌କି ବେଲେ ଡୁମା ତାକେ ମଡିପିଙ୍ଗି ବେସି କିର୍‌କିରି କରି ତାର୍‌ଲଗେ ଅନି ବାରଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ତେବର୍‌ପାଇ ପାର୍‌ତନା ଗରେ ରଇବା ସବୁ ଲକ୍‌ କାବା ଅଇଗାଲାଇ ଆରି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ । “ଏଟା କେନ୍ତାର୍‌ ? ଏଟାତା ଅଦିକାର୍‌ ସଙ୍ଗର୍‌ ନୁଆ ସିକିଆ । ଡୁମା ଆତ୍‌ମାମନ୍‌ ମିସା, ସେ ତିଆର୍‌ଲାଟା ମାନ୍‌ଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ସେଡ୍‌କିବେଲେ ଜିସୁର୍‌ କାତା ଗାଲିଲିର୍‌ ଚାରିବେଡ୍‌ତିର୍‌ ଗାଉଁମନ୍‌କେ କେଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ତାର୍‌ ପଚେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ପାର୍‌ତନା ଗରେ ଅନି ବାରଇ ଜାକୁବ୍‌ ଆରି ଜଅନର୍‌ ସଙ୍ଗ୍‌ ସିମନ୍‌ ଆରି ଆନ୍ଦ୍‌ରିୟର୍‌ ଗରେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ ସିମନର୍‌ ସାତ୍‌ରି ଜର୍‌କେ ସଇରଇଲା ବିସଇ ଜିସୁକେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ସେଟାର୍‌ପାଇ ଜିସୁ ଜାଇ ସିମନର୍‌ ସାତ୍‌ରିର୍‌ ଆତେ ଦାରି ଉଟାଇଲା, ସେଦାପ୍‌ରେ ତାର୍‌ ଜର୍‌ ଚାଡିଗାଲା, ଆରି ସେ ଜାଇ ସେମନ୍‌କେ ସେବା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ସଞ୍ଜ୍‌ ବେଲାଇ ବେଲ୍‌ ବୁଡିଗାଲା ପଚେ, ଲକ୍‌ମନ୍‌ ଜରର୍‌ ଲକ୍‌ମନ୍‌କେ ଆରି ଡୁମାଦାରି ରଇବା ସବୁଲକ୍‌ମନ୍‌କେ ଜିସୁର୍‌ ଲଗେ ଆନ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ଆରି ଗାଉଁର୍‌ ଲକ୍‌ମନ୍‌ ସେ ଗରର୍‌ ଦୁଆରେ ରୁଣ୍ଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ସେଡ୍‌କିବେଲେ ସେ ବିନ୍‌ ବିନ୍‌ ରକାମର୍‌ ରଗ୍‌ ଅଇରଇବା ଜବର୍‌ ରଗି ଲକ୍‌ମନ୍‌କେ ନିମାନ୍‌ କଲା ଆରି ଜବର୍‌ ଡୁମାମନ୍‌କେ ଚାଡାଇଲା, ମାତର୍‌ ସେ ଡୁମାମନ୍‌କେ କାତା କଇବାକେ ଦେଏନାଇ । କାଇକେବଇଲେ ଡୁମାମନ୍‌ ଜିସୁ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲାଆଚେ ବଲିକରି ଜାନି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ଆର୍‌କର୍‌ ସାକାଲେ କୁକ୍‌ଡା ଡାକ୍‌ ବେଲାଇ ଜିସୁ ଉଟି ଗରେଅନି ବାରଇ ଜାଇ ଗଟେକ୍‌ କିନରା ରଇବା ଚିମ୍‌ରା ଜାଗାଇ, ଜାଇ ପାର୍‌ତନା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ସେଡ୍‌କିବେଲେ ସିମନ୍‌ ଆରି ତାର୍‌ ସଙ୍ଗର୍‌ଲକ୍‌ ତାକେ କଜ୍‌ବାର୍‌ ଗାଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ଜେଡେବଲ୍‌ ସେମନ୍‌ ଜିସୁକେ ବେଟ୍‌ ଅଇଲାଇ, ଆରି କାବାଅଇ ତାକେ କଇଲାଇ, “ସବୁ ଲକ୍‌ ତମ୍‌କେ କଜ୍‌ଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ସେଡ୍‌କିବେଲେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଆସା, ଆମେ ରଇବା ବିନ୍‌ ବିନ୍‌ ଗାଉଁମନ୍‌କେ ଜୁ, କାଇକେବଇଲେ ସେ ଜାଗାମନ୍‌କେ ମିସା ମୁଇ ପର୍‌ମେସରର୍‌ କାତା କଇବି । କାଇକେବଇଲେ ସେଟାର୍‌ପାଇସେ ମୁଇ ଆଇଲିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ଆରି ଗାଲିଲିର୍‌ ସବୁଟାନେ ବୁଲି ବୁଲି ସେମନର୍‌ ସବୁ ପାର୍‌ତନା ଗରେ, ମାପ୍‌ରୁର୍‌ କାତା ସୁନାଇଲା, ଆରି ଡୁମା ଦାର୍‌ଲା ଲକ୍‌ମନ୍‌କେ ଚାଡାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ସେଡ୍‌କି ବେଲେ ଗଟେକ୍‌ ବଡ୍‌ ରଗି ତାର୍‌ ଲଗେ ଆସି ମାଣ୍ଡିକଟା ଦେଇ ତାକେ ବାବୁଜିଆ କରି କଇଲା, “ତମେ ଜଦି ମନ୍‌କଲେ ମକେ ସୁକଲ୍‌ କରି ପାର୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ତେଇ ସେ ତାକେ ଜିବନ୍‌ ଦୁକାଇଲା ଆରି ଆତ୍‌ ଲାମାଇ କରି ତାକେ ଚି‍ଇକରି କଇଲା, “ମୁଇ ମନ୍‌ କଲିନି, ତୁଇ ସୁକଲ୍‌ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ସେଦାପ୍‌ରେ ବଡ୍‌ ରଗ୍‌ ତାର୍‌ ଲଗେ ଅନି ଦୁର୍‌ଅଇଲା ଆରି ସେ ସୁକଲ୍‌ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ଆରି, ଜିସୁ ସେ ଲକ୍‌କେ ଡାଟ୍‌ସଙ୍ଗ୍‌ ଆଦେସ୍‌ ଦେଇ ସେଦାପ୍‌ରେ କଇ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ଜାଗ୍‌ରତ୍‌, ମୁଇ ତକେ ସୁକଲ୍‌ କଲି ବଲି କାକେ ମିସା କ ନାଇ, ମାତର୍‌ ଜା ଆରି ନିଜେ ପୁଜାରିକେ ଦେକାଇ ଅ ଆରି ମସା ଜନ୍‌ ଜନ୍‌ ବିରୁ ପର୍‌ମେସର୍‌କେ ଦେବାକେ ଆଦେସ୍‌ ଦେଲାଆଚେ, ସେ ଇସାବେ ଦେସ୍‌ । ଏଟାର୍‌ ଲାଗି ତୁଇ ସୁକଲ୍‌ ଅଇଜାଇଆଚୁସ୍‌ ବଲିକରି ପୁଜାରି ସବୁଲକର୍‌ ମୁଆଟେ ସାକି ଦେଅ ।” ");
INSERT INTO dso_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ମାତର୍‌ ସେଲକ୍‌ ବାରଇ ଜାଇ ଜିସୁ ସୁକଲ୍‌ କରିରଇବା କବର୍‌ ଏତେକ୍‌ ରାଟୁକରି କଇବୁଲ୍‌ଲାଇ ଜେ, ଜିସୁ ଲକ୍‌ମନର୍‌ ଦେକ୍‌ତେ ଦେକ୍‌ତେ କନ୍‌ ଗାଉଁମନ୍‌କେ ମିସା ଜାଇ ପୁରି ନାପାର୍‌ଲା । ମାତର୍‌ ବାଇରେ ଜାଇ ଚିମ୍‌ରା ଜାଗାମନ୍‌କେ ରଇଲା । ଅଇଲେ ମିସା ଲକ୍‌ମନ୍‌ ଚାରିଦିଗେ ଅନି ତାର୍‌ ଲଗେ ଆଇବାର୍‌ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","କେତେଦିନ୍‌ ଗାଲା ପଚେ ଜିସୁ ଆରି ତରେକ୍‌ କପର୍‌ନାଉମେ ବାଅଡ୍‌ଲାକେ, ସେ ଗରେ ଆଚେ ବଲି ଆଲା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ସେ ଗରେ ଏତେମାଣ୍ଡ୍‌ ଲକ୍‌ ଜମ୍‌ଲାଇ ଜେ, ଦୁଆରେ ମିସା ଟାନ୍‌ ଦାରିନାପାର୍‌ଲା, ଆରି ଜିସୁ ସେମନର୍‌ ଲଗେ ପର୍‌ମେସରର୍‌ ବାକିଅ ସୁନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ସେଡ୍‌କି ବେଲେ କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ଚେରେଙ୍ଗ୍‌ ରଗିକେ ବଇକରି ତାର୍‌ ଲଗେ ଦାରିଆଇଲାଇ । ତାକର୍‌ ବିତ୍‌ରେ ଅନି ଚାର୍‌ଲକ୍‌ ରଗିକେ ବଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ମାତର୍‌ ଲକ୍‌ମନ୍‌ ଚିପାଟେଲା ଅଇରଇଲାଇକେ, ତାକେ ଜିସୁର୍‌ ଲଗେ ନେଇ ନାପାର୍‌ଲାଇ । ନାପାରିକରି, ଜିସୁ ଜନ୍‌ଟାନେ ରଇଲା, ତେଇର୍‌ ଚାନି ବଡ୍‌ଟା କାଣାକରି, ରଗିକେ କଟ୍‌ ମିସ୍‌ତେ ତାର୍‌ ମୁଆଟେ ସିଦା ଉତ୍‌ରାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଜିସୁ ସେମନର୍‌ ବିସ୍‌ବାସ୍‌ ଦେକି ଚେରେଙ୍ଗ୍‌ ରଗିକେ କଇଲା, “ବାବୁରେ ମୁଇ ତର୍‌ ପାପ୍‌ କେମା କରିଦେଲି ।” ");
INSERT INTO dso_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ମାତର୍‌ ସେ ଗର୍‌ ବିତ୍‌ରେ କେତେଟା ସାସ୍‌ତର୍‌ ସିକାଇବା ଲକ୍‌ମନ୍‌ ବସି ନିଜର୍‌ ନିଜର୍‌ ମନ୍‌ ବିତ୍‌ରେ ବାବିଅଇତେରଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ଏ ଲକ୍‌ ଚେରେଙ୍ଗ୍‌ ରଗିକେ ‘ତର୍‌ ପାପ୍‌ କେମା କରିଦେଲି ।’ ବଲି କେନ୍ତି କଇପାର୍‌ଲା ? ଏ ପର୍‌ମେସର୍‌କେ ନିନ୍ଦା କର୍‌ସିଆଚେ, ସେ ଗଟେକ୍‌ ମାପ୍‌ରୁକେ ଚାଡିଦେଲେ, ଆରି କେ ମିସା ପାପ୍‌ କେମା କରି ପାରତ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ସେଦାପ୍‌ରେ ଜିସୁ ସେମନ୍‌ ମନେ ମନେ ଏନ୍ତାରି ବାବିଅଇଲାଟା, ନିଜର୍‌ ଆତ୍‌ମାଇ ଜାନି ସେମନ୍‌କେ କଇଲା, “ତମେ କାଇକେ ନିଜର୍‌ ନିଜର୍‌ ମନେ ଏ ସବୁଜାକ ବାବିଅଇଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","କନ୍‌ଟା କର୍‌ବାଟା ସଅଜ୍‌ ଅଇଲାନି ? ବାବୁରେ ‘ମୁଇ ତର୍‌ ପାପ୍‌ କେମା କରିଦେଲି ।’ ବଲି କଇବାଟା, କି ‘ଉଟ୍‌ ତର୍‌ କଟ୍‌ ବଇ ଇଣ୍ଡିଜା ।’ ବଲ୍‌ବାଟା ? ");
INSERT INTO dso_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ମାତର୍‌ ଗୁଲାଇ ଜଗତର୍‌ ପାପ୍‌ କେମା କର୍‌ବାକେ ପର୍‌ମେସର୍‌ ପାଟାଇଲା ନର୍‌ପିଲା ମର୍‌ ଅଦିକାର୍‌ ଆଚେ ବଲି ଏବେ ମୁଇ, ଏ ଲକ୍‌କେ ନିକ କରି ଦେକାଇବି ।” ସେ ଚେରେଙ୍ଗ୍‌ ରଗିକେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ମୁଇ ତକେ କଇଲିନି ଉଟ୍‌, ତର୍‌ କଟ୍‌ ବଇ, ନିଜର୍‌ ଗରେ ବାରିଜା ।” ");
INSERT INTO dso_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ସେଦାପ୍‌ରେ ସେ ରଗି ଉଟି କଟ୍‌ ବଇକରି ସବୁ ଲକର୍‌ ଦେକ୍‌ତେ ବାରଇ ଗାଲା । ସେବେଲାଇ ସବୁଲକ୍‌ କାବା ଅଇ ପର୍‌ମେସରର୍‌ ମଇମା କରି କରି କଇଲାଇ, “ଆମେ ଏନ୍ତାରିଟା କେବେ ମିସା ଦେକି ନ ରଇଲୁ ।” ");
INSERT INTO dso_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ସେ ଆରିତରେକ୍‌ ସମ୍‌ଦୁରର୍‌ କଣ୍ଡିବାଟେ ବାରଇଗାଲା । ବେସି ଲକ୍‌ମନ୍‌ ତାର୍‌ ଲଗେ ଆଇଲାକେ, ଜିସୁ ସେମନ୍‌କେ ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଆରି ସେ ଜାଉ ଜାଉ ଆଲ୍‌ପିଅର୍‌ ପଅ ଲେବିକେ ରମିୟ ସର୍‌କାରର୍‌ ପାଇ ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ମାଙ୍ଗ୍‌ବା ଜାଗାଇ ବସି ରଇବାଟା ଦେକି ତାକେ କଇଲା, “ମର୍‌ ସଙ୍ଗ୍‌ ଆଉ ।” ତେଇଅନି ସେ ତାର୍‌ ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ମାଙ୍ଗ୍‌ବାଟା ଚାଡି ଉଟିକରି ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ପଚେ ଜିସୁ ଲେବିର୍‌ ଗରେ ଜାଇ କାଇବା ବେଲେ ବେସି ସିସ୍‌ତୁମାଙ୍ଗ୍‌ବା ଲକ୍‌ ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ପାପି ବଲି କଇତେରଇଲାଇ, ତାର୍‌ ସିସ୍‌ମନ୍‌ର୍‌ ସଙ୍ଗ୍‌ ମିସି କାଇତେରଇଲାଇ । କାଇକେବଇଲେ ଏନ୍ତାରି ବେସି ଲକ୍‌ ତାର୍‌ ସଙ୍ଗ୍‌ ଜାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ଜିସୁ ପାପି ଆରି ସିସ୍‌ତୁମାଙ୍ଗୁମନର୍‌ ସଙ୍ଗ୍‌ କାଇଲାନି, ଏଟା ଦେକିକରି ପାରୁସି ଦଲର୍‌ ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇବାର୍‌ ଦାର୍‌ଲାଇ, “ସେ କାଇକେ ସିସ୍‌ତୁମାଙ୍ଗୁମନର୍‍ ଆରି ପାପିମନର୍‌ ସଙ୍ଗ୍‌ କାଇଲାନି ?” ");
INSERT INTO dso_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ସେଟା ସୁନି ଜିସୁ ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌କେ କଇଲା, “ ନିମାନ୍‌ ଲକ୍‌ମନର୍‌ପାଇ ଡାକ୍‌ଦରର୍‌ ଲଡା ନାଇ, ମାତର୍‌ ନିମାନ୍‌ ନ ରଇଲା ଲକ୍‌ମନ୍‌କେ ଲଡା ଆଚେ । ଜେ ନିଜେ ‘ମୁଇ ଦରମ୍‌ ଲକ୍‌ ।’ ବଲି ବାବିଅ‍ଇବା ଲକର୍‌ପାଇ ମୁଇ ଆସିନାଇ, ମାତର୍‌ ପାପିମନ୍‌କେ ପାପ୍‌ଟାନେଅନି ବାଉଡାଇବାକେ ଆସିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ଉପାସ୍‌ କର୍‌ତେ ରଇଲାଇ । ସେବେଲାଇ କେତେଲକ୍‌ ଆସି ଜିସୁକେ କଇଲାଇ, “ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ଆରି ପାରୁସିମନର୍‌ ସିସ୍‌ମନ୍‌ ଉପାସ୍‌ କର୍‌ବାଇ, ମାତର୍‌ ତର୍‌ ସିସ୍‌ମନ୍‌ କାଇକେ ଉପାସ୍‌ ନ କରତ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ବଜିଟାନେ ବିବା ଦାଙ୍ଗ୍‌ଡା ରଇବା ଜାକ ବିବା ଦାଙ୍ଗ୍‌ଡାର୍‌ ସଙ୍ଗ୍‌ ର‍ଇବା ଦାଙ୍ଗ୍‌ଡାମନ୍‌ ଉପାସେ ରଇବାଇ କି ? ନାଇ ନ ର‍ଅତ୍‌ । ବିବା ଦାଙ୍ଗ୍‌ଡା ଜେଡେବେଲାଜାକ ରଇସି, ସେ ବେଲାଜାକ ସେମନ୍‌ ଉପାସେ ନ ରଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ମାତର୍‌ ବେଲା ଆଇସି, ଜେଡେବେଲେ ଲକ୍‌ମନ୍‌ ଆସି ତାକର୍‌ ଲଗେ ଅନି ବିବା ଦାଙ୍ଗ୍‌ଡାକେ ଦାରିଜିବାଇ, ସେଦିନେ ସେମନ୍‌ ଉପାସ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“କେ ନୁଆ ଲୁଗାର୍‌ ଗର୍‌ଣ୍ଡା ପୁର୍‌ନା ଲୁଗାଇ ନ ସିଲାଏ, ସିଲାଇଲେ ନୁଆ ଗର୍‌ଣ୍ଡା ପୁର୍‌ନା ଲୁଗାକେ ଅଦିକ୍‌ ଚିରି ପାକାଇସି, ଆରି ଅଦିକ୍‌ ବଡ୍‌ଟା କାଣା କରିଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ଆରି କେ ନୁଆ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ପୁର୍‌ନା ଚାମ୍‌ ସଙ୍ଗ୍‌ ତିଆର୍‌ କଲା ମୁନାଇ ନ ସଙ୍ଗଅତ୍‌, ସଙ୍ଗଇଲେ ସେ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ଆରି ଚାମ୍‌ ମୁନା ନସିଜାଇସି । ନାଇ ନୁଆ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ନୁଆ ଚାମ୍‌ ମୁନାଇ ସଙ୍ଗଇବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ଜିସୁ ତରେକ୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ତାସ୍‌ ରଇବା କେତ୍‌ ବାଟେ ଜାଇତେ ରଇଲା, ଆରି ଜିବାବେଲେ ତାର୍‌ ସିସ୍‌ମନ୍‌ ଦାନ୍‌ କେଡ୍‌ ଚିଡାଇତେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ସେ ଜାଗାଇ ରଇବା ପାରୁସିମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ଦେକ୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ଜନ୍‌ଟା କର୍‌ବାର୍‌ ଆମର୍‌ ବିଦି ନଏଁ । ତର୍‌ ସିସ୍‌ମନ୍‌ କାଇକେ ସେଟା କଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ଆମର୍‌ ଡାକ୍‌ପୁଟା ଆନିଦାଦି ଦାଉଦର୍‌ ଅବାବ୍‌ ବେଲେ, ସେ ଆରି ତାର୍‌ ସଙ୍ଗ୍‌ର୍‌ ଲକ୍‌ମନ୍‌ ବୁକେ ରଇଲାଇ, ସେଡ୍‌କିବେଲେ ସେ କାଇଟା କରି ରଇଲା, ସେଟା କାଇ ତମେ କେବେ ପଡାସ୍‌ ନାଇ କି ? ");
INSERT INTO dso_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ବଡ୍‌ ପୁଜାରି ଅବିୟାତର୍‌ ବେଲେ ସେ କେନ୍ତି ପର୍‌ମେସରର୍‌ ମନ୍ଦିରେ ପୁରିକରି ମାପ୍‌ରୁକେ ସର୍‌ପିଦେଲା ଜନ୍‌ ଦର୍‌ସନି ରୁଟି, ପୁଜାରିମନ୍‌କେ ଚାଡିଦେଲେ ଆରି କେ ମିସା କାଇବାର୍‌ ବିଦି ନଏଁ, ସେଟା ସେ କାଇଲା, ଆରି ସେ ରୁଟି ନିଜର୍‌ ସଙ୍ଗର୍‌ ଲକ୍‌ମନ୍‌କେ ମିସା ବାଟାକରି ଦେଇରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ ବିସ୍‌ରାମ୍‌ବାର୍‌ ଲକ୍‌ମନର୍‌ ସାଇଜର୍‌ପାଇ ଅଇଲା ଆଚେ, ସେଟା ଲକ୍‌ମନ୍‌କେ ବିଜାର୍‌ କର୍‌ବାକେ ଅଏନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ତେବର୍‌ପାଇ ପର୍‌ମେସର୍‌ ପାଟାଇଲା ନର୍‌ପିଲା ମୁଇ ବିସ୍‌ରାମ୍‌ବାରେ ଲକ୍‌ମନ୍‌ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ, କାଇଟା କର୍‌ବାର୍‌ ନାଇ, ସେଟା କଇବାର୍‌ ମର୍‌ ଅଦିକାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ପଚେ ଜିସୁ ଆରି ଗଟେକ୍‌ ତର୍‌ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ଗାଲା । ତେଇ ଗଟେକ୍‌ ଲକ୍‌ ରଇଲା । ତାର୍‌ ଗଟେକ୍‌ ଆତ୍‌ ସୁକିଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ଜିସୁ କେଜାନେ ବିସ୍‌ରାମ୍‌ ବାରେ ନିମାନ୍‌ କର୍‌ସି ବଲି, ସେମନ୍‌ ଆଁକି ନ ମରାଇତେ ଦେକ୍‌ତେରଇଲାଇ, କାଇକେବଇଲେ ଜେନ୍ତିକି ତାର୍‌ ବିରୁଦେ ଦସ୍‌ ଦାରିପାର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ଜନ୍‌ ଲକର୍‌ ଆତ୍‌ ସୁକି ଜାଇରଇଲା, ତାକେ ଜିସୁ କଇଲା, “ଆଉ ମଜାଇ ଟିଆ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ଆରି ଜିସୁ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ ବିସ୍‌ରାମ୍‌ବାରେ କାଇଟା କର୍‌ବା ନିଅମ୍‌ ? ନିକ କର୍‌ବାର୍‌ କି ଆସାର୍‌ କର୍‌ବାର୍‌ ? ଜିବନ୍‌ ବଁଚାଇବାର୍‌ କି ମରାଇଦେବାର୍‌ ?” ମାତର୍‌ ସେମନ୍‌ କାଇଟା ନ କଇ ଚିମ୍‌ରାଅଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ସେବେଲେ ତାକର୍‌ ମନ୍‌ ଡାଟ୍‌ ର‍ଇବାଟା ଦେକିକରି ଜିସୁ ଦୁକ୍‌ଅଇ ରିସାସଙ୍ଗ୍‌, ଚାରିବେଡ୍‌ତି ଦେକ୍‍ଲା । ଆରି ସେ ଲକ୍‌କେ କଇଲା, “ଆତ୍‌ ଲାମା ।” ସେ ଲକ୍‌ ଆତ୍‌ ଲାମାଇଲା, ଆରି ତାର୍‌ ଆତ୍‌ ନିମାନ୍‌ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ତେଇଅନି ପାରୁସିମନ୍‌ ସେ ଜାଗାଇଅନି ଦାପ୍‌ରେ ବାରଇ ଜାଇ ଜିସୁକେ ମରାଉ ବଲି ତାର୍‌ ବିରୁଦେ ଏରଦ୍‌ ରାଜାର୍‌ ଲକ୍‌ମନର୍‌ସଙ୍ଗ୍‌ ଉପାଇ ପାଁଚ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ସେଡ୍‌କିବେଲେ ଜିସୁ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଲକ୍‌ମନର୍‌ଟାନେଅନି ବେଗ୍‌ଲି କରି, ସମ୍‌ଦୁର୍‌ କଣ୍ଡିବାଟେ ବାରଇ ଗାଲା । ଆରି ଗାଲିଲି ଅନି ବେସି ଲକ୍‌ ତାର୍‌ ପଚେ ପଚେ ଆଇଲାଇ, ଆରି ଜିଉଦା, ");
INSERT INTO dso_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଜିରୁସାଲାମ୍‌, ଇଦମ୍‌, ଜର୍‌ଦନ୍‌ର୍‌ ଉପର୍‌ ବାଟେ ରଇବା ସର ଆରି ସିଦନର୍‌ ଚାରିବେଡ୍‌ତିର୍‌ ଲକ୍‌ ସେ କରିରଇବା ସବୁ କାମର୍‌ କାତା ସୁନି ତାର୍‌ ଲଗେ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ସେଡ୍‌କିବେଲେ ଚିପାଟେଲା ରଇଲାକେ, ଲକ୍‌ମନ୍‌ ଜେନ୍ତିକି ଉପ୍‌ରେ ଡାବି ନ ଅଅତ୍‌, ତେବର୍‌ ପାଇ ଜିସୁ ସିସ୍‌ମନ୍‌କେ ତାର୍‌ପାଇ ଗଟେକ୍‌ ସାନ୍‌ଟା ଡଙ୍ଗା ଆନି ଜାଗାଇବାକେ ତିଆର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","କାଇକେବଇଲେ ସେ ବେସି ଲକ୍‌ମନ୍‌କେ ନିମାନ୍‌ କଲାଜେ ଜର୍‌ଦୁକା ଅଇରଇବା ଲକ୍‌ମନ୍‌ ତାକେ ଚିଉଁ ବଲି ଉପ୍‌ରେ ଡାବିଅଇ ଜାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ଆରି ଜେଡେବେଲେ ଜିସୁକେ କରାପ୍‌ ଆତ୍‌ମାମନ୍‌ ଦେକ୍‌ତେ ରଇଲାଇ, ସେ ଆତ୍‌ମାମନ୍‌ ତାର୍‌ ମୁଆଟେ ଅଦ୍‌ରି ଆଉଲିଅଇ କଇତେରଇଲାଇ, “ତୁଇ ଆକା ପର୍‌ମେସରର୍‌ ପଅ ।” ");
INSERT INTO dso_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ମାତର୍‌ ଜିସୁ ଡୁମାମନ୍‌କେ ତାର୍‌ ବିସଇନେଇ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ କାଇ ବଲି ନ କୁଆ ବଲି ଡାଟ୍‌ସଙ୍ଗ୍‌ ଆଦେସ୍‌ ଦେଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ଜିସୁ ପର୍‌ବତ୍‌ ଉପ୍‌ରେ ଜାଇ, ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ସେ ମନ୍‍ କଲା, ସେମନ୍‌କେ ଲଗେ ଡାକ୍‌ଲା, ଆରି ସେମନ୍‌ ତାର୍‌ ଲଗେ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ସେ ବାର ଲକ୍‌କେ ବାଚ୍‌ଲା ଆରି ସେମନ୍‌କେ ତାର୍‌ କବର୍‌ ନେଉ ବଲି ଡାକ୍‌ଲା । ଜେନ୍ତି ସେମନ୍‌ ତାର୍‌ ସଙ୍ଗ୍‌ ରଇପାରତ୍‌ ଆରି ସେମନ୍‌ ତାର୍‌ କବର୍‌ ଜାନାଇବାଇ, ");
INSERT INTO dso_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ଆରି ଡୁମାଚାଡାଇବାକେ ଅଦିକାର୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ଜିସୁ ବାର ଲକ୍‌କେ ବାଚ୍‌ଲା, ଜନ୍‌ଲକ୍‌ମନ୍‌ କି ସିମନ୍‌, ଜାକେ ସେ ପିତର୍‌ ବଲି ନାଉଁ ଦେଲା, ");
INSERT INTO dso_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବଦିର୍‌ ପ ଜାକୁବ୍ ଆରି ତାର୍‌ ବାଇ ଜଅନ୍‌କେ ସେ ବିନେରିଗସ୍‌ ବଲି ନାଉଁ ଦେଲା, ଆର୍‌ ଅରତ୍‌ ଅଇଲାନି ମେଗ୍‌ନାଦର୍‌ ପଅମନ୍‌, ");
INSERT INTO dso_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍‌ରିୟ, ପିଲିପ୍‍, ବାର୍‌ତଲମି, ମାତିଉ, ତମା, ଆଲ୍‌ପିର୍‌ ପଅ ଜାକୁବ୍, ତଦିୟ, କିଣାନିୟ ସିମନ୍‌, ଜେ କି ରମିୟ ସର୍‌କାରର୍‌ ବିରୁଦେ ଉଟିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ଆରି ଇସ୍‌କାରିୟତିୟ ଜିଉଦା, ଜେ କି ଜିସୁକେ ସତ୍‌ରୁକେ ସର୍‌ପି ଦେଇର‍ଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ପଚେ ଜିସୁ ଗଟେକ୍‌ ଗରେ ପୁର୍‌ଲା । ସେଡ୍‌କି ବେଲେ ଲକ୍‌ମନ୍‌ ଆରି ତରେକ୍‌ ଏତେକ୍‌ ରୁଣ୍ଡ୍‌ଲାଇ ଜେ, ସେ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ କାଇବାର୍‌ ମିସା ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","“ ଜିସୁକେ କାଇବାକେ ମିସା ବେଲା ନାଇ ।” ବଲି କଇ ତାକର୍‌ ଗରର୍‌ ଲକ୍‌ ସୁନି, ତାକେ ଗରେ ଡାକିନେବାକେ ଆଇଲାଇ । କାଇକେବଇଲେ ସେମନ୍‌ କଇଲାଇ, “ତାର୍‌ ବୁଦି ବାନାଅଇଗାଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଆରି, ଜିରୁସାଲାମ୍‌ ଅନି ଆସିରଇବା ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ କଇଲାଇ, “ଆକେ ଡୁମାମନର୍‌ ନେତା ବାଲ୍‍ଜିବୁଲ୍‌ ଦାରିଆଚେ, ଆରି ଡୁମାମନର୍‌ ନେତାର୍‌ ବପୁସଙ୍ଗ୍‍ ଡୁମା ଚାଡାଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ସେଡ୍‌କିବେଲେ ଜିସୁ ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌କେ ଲଗେଡାକି ଉଦାଅରନ୍‌ ଦେଇ କଇଲା, “ସଇତାନ୍‍ କେନ୍ତି ସଇତାନ୍‌କେ ଚାଡାଇ ପାର୍‌ସି ? ");
INSERT INTO dso_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ଜଦି ଗଟେକ୍‌ ରାଇଜ୍‌ ଦୁଇ ବାଗ୍‌ ଅଇ ନିଜର୍‌ ବିରୁଦେ ଉଟ୍‌ସି, ତେବେ ସେ ରାଜିଅ ବେସିଦିନ୍‌ ନ ରଏ । ");
INSERT INTO dso_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ଗଟେକ୍‌ ଗର୍‌ ବାଗ୍‌ ଅଇ ନିଜର୍‌ ବିରୁଦେ ଉଟ୍‌ସି, ତେବେ ସେ ଗର୍‌ ବେସି ଦିନ୍‌ ନ ରଏ । ");
INSERT INTO dso_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ସେନ୍ତାର୍‌ସେ ସଇତାନ୍‌ ଜଦି ବାଗ୍‌ ଅଇ ନିଜର୍‌ ବିରୁଦେ ଉଟ୍‌ସି, ତେବେ ସେ ତବିର୍‌ ଅଇ ରଇ ନାପାରେ, ମାତର୍‌ ତାର୍‌ ବିନାସ୍‌ ଗଟ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ମାତର୍‌ କେ ମିସା ବପୁ ରଇବା ଲକ୍‌କେ ପର୍‌ତୁମ୍‌ ନ ବାନ୍ଦ୍‌ତେ, ତାର୍‌ ଗରେ ପୁରିକରି ସେଲକର୍‌ ନିଜର୍‌ ସବୁ ଚରାଇ ନେଇ ନାପାରେ, ମାତର୍‌ ସେ ବପୁ ରଇବା ଲକ୍‌କେ ଆଗେ ବାନ୍ଦ୍‌ଲେ ସିନା ସେ ତାର୍‌ ଗରେ ପୁରି ଚରିପାର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଲକ୍‌ମନର୍‌ ସବୁ ପାପ୍‌, ଆରି ସେମନ୍‌ ଜେତେକ୍‌ ନିନ୍ଦା କାତା କଇ ପର୍‌ମେସରର୍‌ ନିନ୍ଦା କଲେ ମିସା, ସେ ସବୁଜାକ କେମା କରାଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ଜେକି ସୁକଲ୍‌ଆତ୍‌ମାର୍‌ ବିରୁଦେ ନିନ୍ଦା କାତା କଇସି, ତାକେ କନ୍‌ କାଲେ ମିସା ପର୍‌ମେସର୍‌ କେମା ନ ଦେଏ, ଆରି ସେ ନ ସାର୍‌ବା ପାପର୍‌ ଦସି ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ତାକେ କାରାପ୍‌ ଆତ୍‌ମା ଲାଗିଆଚେ ବଲି ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ କଇଲାଇକେ, ଜିସୁ ଏନ୍ତାରି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ସେଡ୍‌କିବେଲେ ଜିସୁର୍‌ ମା ଆରି ବାଇମନ୍‌ ଆସି ବାଇରେ ଟିଆ ଅଇ ଜିସୁକେ ଡାକାଇପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ତେଇ ତାର୍‌ ଚାରିବେଡ୍‌ତି ବସି ରଇବା ଲକ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ଦେକା, ତମର୍‌ ମାଆ ଆରି ବାଇ ବଇନି ବାଇରେ ରଇ ତମ୍‌କେ କଜ୍‌ଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “କେ ମର୍‌ ମା ଆରି ବାଇବଇନିମନ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ସେ ତାର୍‌ ଚାରିବେଡ୍‌ତି ବସିରଇବା ଲକ୍‌ମନ୍‌କେ ଦେକିକରି କଇଲା, “ଏମନ୍‌ ମର୍‌ ମାଆ ଆରି ମର୍‌ ବାଇ ବଇନି । ");
INSERT INTO dso_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସର୍‌ ମନ୍‌କଲାଟା ପୁରାପୁରୁନ୍‌ କର୍‌ବାଇ, ସେ ମର୍‌ ବାଇ, ବଇନି ଆରି ମା ।” ");
INSERT INTO dso_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ଜିସୁ ଆରିତରେକ୍‌ ଗାଲିଲି ସମ୍‌ଦୁର୍‌ କଣ୍ଡିଟାନେ ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲା, ଆରି ଏତେକ୍‌ ମାଣ୍ଡ୍‌ ଲକ୍‌ମନ୍‌ ତାର୍‌ ଲଗେ ଟୁଲ୍‌ଅଇଲାଇଜେ, ସେ ସମ୍‌ଦୁରେ ରଇବା ଗଟେକ୍‌ ଡଙ୍ଗାଇ ଜାଇ ବସ୍‌ଲା, ଆରି ଗୁଲାଇ ଲକ୍‌ମନ୍‌ ସମ୍‌ଦୁର୍‌ ପାଲିକେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ଜିସୁ ସେମନ୍‌କେ ବେସି ବିସଇ ଉଦାଅରନ୍‌ ଦେଇ ସିକାଇଲା । ଆରି ସିକାଇବାବେଲେ ସେମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ସୁନା ଗଟେକ୍‌ ଚାସି ତାର୍‌ ବିଅନ୍‌ ବୁନ୍‌ବାର୍‌ ବାରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ସେ ବୁନୁ ବୁୁନୁ କେତେକ୍‌ ବିଅନ୍‌ ବାଟେ ଅଦର୍‌ଲା, ଆରି ଚଡଇମନ୍‌ ଆସି ସବୁଜାକ ବିଅନ୍‌ କାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ଆରି କେତେକ୍‌ ବିଅନ୍‌ ଉନା ମାଟିରଇ ତଲେ ପାକ୍‌ନା ରଇଲା ବୁଏଁ ଅଦର୍‌ଲା, ଆରି ମାଟି ଉନା ରଇଲାକେ ଦାପ୍‌ରେ ଗାଜା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ମାତର୍‌ ବେଲ୍‌ ଉଦ୍‌ଲାକେ ଗାଜା ଅଇଲାଟା ପଡି ମସ୍‌ରିଗାଲା, ଆରି ଚେର୍‌ ବେଦି ନ ରଇଲାଜେ ସୁକିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ଆରି କେତେକ୍‌ ବିଅନ୍‌ କାଟା ବୁଟା ମଜାଇ ଅଦର୍‌ଲା, ଆରି କାଟା ବୁଟାମନ୍‌ ଉଟି ବଡିକରି ଗାଜା ଅଇ ସବୁକେ ଚାପି ପାକାଇଲାଇ । ଚାପିଦେଲାକେ କାଇ ଦାନ୍‌ ମିସା ଅଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ମାତର୍‌, ଆରି କେତେକ୍‌ ବିଅନ୍‌ ନିକ ବୁଏଁ ଅଦର୍‌ଲା ଆରି ଗାଜା ଅଇ ଉଟି ବଡିକରି ତିରିସ୍‌ ଗୁଣ୍‌ ସାଟେ ଗୁଣ୍‌ ଆରି ସଏ ଗୁଣ୍‌ ଜାକ ପସଲ୍‌ ଦେଲା ।” ");
INSERT INTO dso_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଆରି ଜିସୁ କଇଲା, “ଜାକେ ସୁନ୍‌ବାକେ କାନ୍‌ ଆଚେବଇଲେ, ସେ ମନ୍‌ଦେଇ ସୁନ ।” ");
INSERT INTO dso_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ଜିସୁ ଗଟେକ୍‌ଲକ୍‌ ରଇଲା ବେଲେ ତାର୍‌ସଙ୍ଗ୍‌ ରଇଲା ଲକ୍‌ମନ୍‌ ଆରି ବାର୍‌ଟା ସିସ୍‌ମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ, “ତମେ କାଇକେ ଉଦାଅରନ୍‌ ଦେଇ ସିକାଇଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ପର୍‌ମେସରର୍‌ ରାଇଜେ ଲୁଚିକରି ରଇଲା ବିସଇ ତମେ ବୁଜିପାର୍‌ଲାସ୍‌ନି, ମାତର୍‌ ବାଇରେ ରଇବା ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ଉଦାଅରନ୍‌ ଦେଇ କୁଆ ଅଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ଜେନ୍ତାର୍‌କି “ମୁଇ କର୍‌ବା କାମ୍‌ମନ୍‌ ଦେକ୍‌ତେ ରଇଲେ ମିସା ବୁଜି ନାପାରତ୍‌, ଆରି କଇଲାଟାମନ୍‌ ସୁନି ସୁନି ମିସା ନ ବୁଜତ୍‌, ବୁଜ୍‌ତାଇଆଲେ ସେମନ୍‌ ପର୍‌ମେସରର୍‌ ଲଗେ ବାଅଡ୍‌ତାଇ ଆରି ପାପ୍‌ କେମା ପାଇତାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏ ଉଦାଅରନର୍‌ ଅରତ୍‌ ତମେ ବୁଜାସ୍‌ ନାଇ କି ? ତେବେ ବିନ୍‍ ଉଦାଅରନର୍‍ ଅରତ୍‌ କେନ୍ତି ବୁଜ୍‌ସା ? ");
INSERT INTO dso_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ଚାସି ପର୍‌ମେସରର୍‌ ବାକିଅ ବୁନ୍‌ସି, ");
INSERT INTO dso_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ଜନ୍‌ଲକ୍‌ମନ୍‌ ସୁନ୍‌ବାଇ ଆରି ସୁନ୍‌ଲା ଦାପ୍‌ରେ, ସଇତାନ୍‌ ଆସି ସେମନ୍‌ର୍‌ ଟାନେଅନି ବୁନିରଇବା ବାକିଅ ଜିକି ନେଇସି, ସେମନ୍‌ ବୁନିରଇବା ବାଟ୍‌ଲଗର୍‌ ବିଅନ୍‌ ପାରା । ");
INSERT INTO dso_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ସେନ୍ତାର୍‌ ସେ, ଜନ୍‌ଲକ୍‌ମନ୍‌ ବାକିଅ ସୁନ୍‌ଲା ଦାପ୍‌ରେ ସାର୍‌ଦା ଅଇ ସେଟା ମାନ୍‌ବାଇ, ସେଲକ୍‌ ପାକ୍‌ନା ରଇବା ଜାଗାଇ ଅଦର୍‌ଲା ବିଅନ୍‌ ପାରା । ");
INSERT INTO dso_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ମାତର୍‌ ସେମନର୍‌ ଟାନେ ଚେର୍‌ ନ ବେଦିରଏଜେ ଚନେକର୍‌ପାଇ ବିସ୍‌ବାସ୍‌ କରି ରଇବାଇ, ପଚେ ବାକିଅର୍‌ଲାଗି କସ୍‌ଟ କି ତାଡ୍‌ନା ଆଇଲେ, ସେ ଦାପ୍‌ରେ ବିସ୍‌ବାସ୍‌ ଚାଡି ଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ଆରି ଜନ୍‌ଲକ୍‌ମନ୍‌ ବାକିଅ ସୁନ୍‌ବାଇ, ମାତର୍‌ ତାର୍‌ ଦିନ୍‌କର୍‌ ବିସଇର୍‌ ଚିନ୍ତା, ଦନର୍‌ ମାୟା ଆରି ବିନ୍‌ ବିନ୍‌ ବିସଇର୍‌ ଲାଲ୍‌ସାଟାନେ ପୁରିକରି ମାପ୍‌ରୁର୍‌ ବାକିଅକେ ଚାପିପାକାଇସି, ତେଇ ମାପ୍‌ରୁର୍‌ ବାକିଅ ନିକ କାମ୍‍ ନ କରେ । ");
INSERT INTO dso_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ସେନ୍ତାରି ଅଦେକ୍‌ ଲକ୍‌ମନ୍‌ ବିଅନ୍‌ ବୁନିରଇବା କାଟାଲାଟା ବୁଇଁ ପାରା । ");
INSERT INTO dso_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ବାକିଲକ୍‌ମନ୍‌ ବାକିଅ ସୁନି ସେଟା ମାନ୍‌ବାଇ ଆରି ତିରିସ୍‌ ଗୁଣ୍‌, ସାଟେ ଗୁଣ୍‌ ଆରି ସଏ ଗୁଣ୍‌ ପଲ୍‌ ଦେବାଇ, ସେମନ୍‌ ବିଅନ୍‌ ଅଦ୍‌ରି ରଇବା ନିକ ବୁଇଁ ପାରା ।” ");
INSERT INTO dso_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଜିସୁ ଆରିତରେକ୍‌ ସେମନ୍‌କେ କଇଲା, “ବତି ଡସାଇ ମାନ୍‌ ତଲେ କି କଟ୍‌ ତଲେ ସଙ୍ଗଇବାକେ ନ ଆନତ୍‌ । ବତି, କୁଦ୍‌ରାଇ ସଙ୍ଗଇବାକେ ଡସାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","କାଇକେବଇଲେ ଲକ୍‌ମନ୍‌କେ ଏବେଜାକ ନାଜାନି ରଇବା ବିସଇ ଜାନାଇ ଦିଆଅଇସି, ଆରି ଜନ୍‌ ବିସଇ ସବୁ ଲୁଚି ରଇସି, ସେଟା ମେଲାକରି ଦିଆଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଜଦି ଜାକେ ନିକ ସଙ୍ଗ୍‌ ସୁନ୍‌ବାର୍‌ ଆଚେ, ସେ ନିକ ସଙ୍ଗ୍‌ ସୁନ ।” ");
INSERT INTO dso_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଆରି ଜିସୁ ସେମନ୍‌କେ କଇଲା, “କାଇଟା ସୁନ୍‌ଲାସ୍‌ନି, ସେ ବିସଇ ଏତାଇକରି ଜାଗରତ୍‌ ରୁଆ । ଜନ୍‌ ନାପେ ତମେ ନାପ୍‌ସା, ସେ ନାପେ ପର୍‌ମେସର୍‌ ତମ୍‌କେ ନାପ୍‌ସି, ଆରି ତାର୍‌ତେଇଅନି ଅଦିକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","କାଇକେବଇଲେ ଜାକେ ରଇ, କାମେ ଲାଗାଇରଇସି ତାକେ ଅଦିକ୍‌ ଦିଆଅଇସି, ଆରି ଜାକେ ରଇ, କାମେ ନ ଲାଗାଏ, ତାର୍‌ଟାନେ ଅନି ସେ ଅଲପ୍‌ ରଇଲାଟା ମିସା ନିଆଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଆରି ସେ କଇଲା, “ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଏନ୍ତାରି । ଗଟେକ୍‌ ଲକ୍‌ ନିଜର୍‌ ପଦାଇ ବିଅନ୍‌ ବୁନ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ଆରି, ସେ ଦିନ୍‌ବେଲେ କି ରାତିବେଲେ, ସଇଲେ କି କାମ୍‌ କଲେ ମିସା ବିଅନ୍‌ କେନ୍ତି ଆଁକ୍‌ରି ବଡ୍‌ସି, ସେଟା ନାଜାନେ, ");
INSERT INTO dso_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ଜମି ତାର୍‌ମନ୍‌କେ ପଲ୍‌ ଉବ୍‌ଜାଇସି, ପର୍‌ତୁମ୍‌ ପତର୍‌, ପଚେ କେଡ୍‌, ତାର୍‌ପଚେ ମୁଞ୍ଜି ପୁରୁନ୍‌ ରଇବା କେଡ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ମାତର୍‌ ଚାସ୍‌ ପାଚ୍‌ଲା ଦାପ୍‌ରେ କାଟ୍‌ବା ବେଲା କେଟିଆଇଲେ, ଚାସି କାଟ୍‌ବାକେ ଇଲା ଲାଗାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ସେ ଆରି ତରେକ୍‌ କଇଲା, “ଆମେ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ କାଇଟା ସଙ୍ଗ୍‌ ସମାନ୍‌ କରୁ ? ନଇଲେ କାଇ ଉଦାଅରନ୍‌ ସଙ୍ଗ୍‌ ବୁଜାଇଦେଉଁ ? ");
INSERT INTO dso_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ସେଟା ଗଟେକ୍‌ ସର୍‌ସୁ ମୁଞ୍ଜି ପାରା, ବୁଏଁ ବୁନ୍‌ବା ବେଲେ ସେଟା ପୁର୍‌ତିବିର୍‌ ସବୁ ମୁଞ୍ଜିତେଇ ଅନି ସାନ୍‌ଟା, ");
INSERT INTO dso_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ମାତର୍‌ ବୁନ୍‌ଲେ, ସେଟା ବଡିକରି ସବୁ ସାଗର୍‌ ଟାନେଅନି ବଡ୍‌ ଅଇସି, ଆରି ତାର୍‌ କେନ୍ଦି ଏନ୍ତି ବଡ୍‌ ବଡ୍‌ ଅଇଜାଇସି ଜେ, ସରଗର୍‌ ଚଡଇମନ୍‌ ତାର୍‌ କେନ୍ଦାଇ ବାସା ଅଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ଜିସୁ ଏନ୍ତି କେତେକ୍‌ କେତେକ୍‌ ଉଦାଅରଣ୍‌ ସଙ୍ଗ୍‌ ସେମନର୍‌ ବୁଜ୍‍ବା ବପୁ ଇସାବେ ବାକିଅ ସୁନାଇତେ ରଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ଆରି ଉଦାଅରନ୍‌ ନଇତେ ସେ ତାକର୍‌ ଲଗେ କାଇ କାତା ନ କଇତେରଇଲା । ମାତର୍‌ ଜିସୁ ବିନ୍‌ ଲକ୍‌ମନ୍‌ କେ ନ ରଇଲାବେଲେ ନିଜର୍‌ ସିସ୍‌ମନ୍‌କେ ସବୁ ବିସଇ ବୁଜାଇ ଦେଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ସେଦିନେ ସଞ୍ଜ୍‌ ଅଇଲାକେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଆସା, ଗାଡ୍‌ ସେପାଟେ ଜୁ ।” ");
INSERT INTO dso_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ସେଡ୍‌କିବେଲେ ସେମନ୍‌ ଲକ୍‌ ଗଅଲି ଚାଡିକରି, ଜିସୁ ବସି ରଇଲା, ଗଟେକ୍‌ ଡଙ୍ଗାଇ ଜାଇ ବସ୍‌ଲାଇ । ଆରି ବିନ୍‌ ବିନ୍‌ ଡଙ୍ଗା ମିସା ତାକର୍‌ ସଙ୍ଗ୍‍ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ପଚେ ଅଟାତ୍‌ ବେସି ବାଉପବନ୍‌ ଆଇଲା, ଆରି ଲଅଡିର୍‌ ମାଡ୍‌କେ ଡଙ୍ଗାଇ ପାନି ପୁରୁନ୍‌ ଅଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ସେଡ୍‌କିବେଲେ ଜିସୁ ଡଙ୍ଗାର୍‌ ପଚ୍‌ ଚଟୁ ମାର୍‌ବା ଲଗେ ମଚ୍‌ଲା ମୁଣ୍ଡିସାକରି ସଇଦେଇ ରଇଲା । ସିସ୍‌ମନ୍‌ ତାକେ ଉଟାଇ କଇଲାଇ, “ଏ ଗୁରୁ, ଆମେ ବୁଡିଜିବୁବେ, ତମ୍‌କେ କାଇ ଚେତ୍‌ନା ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ସେଡ୍‌କିବେଲେ ଜିସୁ ଉଟି ପବନ୍‌କେ ଦମ୍‌କାଇ ଦେଇ ଲଅଡିକେ କଇଲା, “ତବିର୍‌ ଅଇ ଚୁପ୍‌ ର ।” ସେଡ୍‌କି ବେଲେ ପବନ୍‌ ବନ୍ଦ୍‌ ଅଇଲା, ଆରି ସବୁ ତବିର୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ଆରି ସେ ସିସ୍‌ମନ୍‌କେ କଇଲା, “କାଇକେ ଏତେକ୍‌ ଡର୍‌ଲାସ୍‌ନି ? ତମ୍‌କେ ଏବେଜାକ ମର୍‌ଲଗେ ବିସ୍‌ବାସ୍‌ ନାଇ କି ?” ");
INSERT INTO dso_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ସେମନ୍‌ ବେସି ଡରି ଜାଇକରି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ତେବେ ଏ କେ ଜେ, ପବନ୍‌ ଆରି ଲଅଡି ମିସା ତାର୍‌ ଆଦେସ୍‌ ମାନ୍‌ଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ସମ୍‌ଦୁର୍‌ ସେପାଟେ ରଇବା ଗରାସିୟମନର୍‌ ଜାଗାଇ କେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଜିସୁ ଡଙ୍ଗାଇଅନି ଉତର୍‌ଲା ଦାପ୍‌ରେ ଗଟେକ୍‌ ଡୁମା ଦାରିରଇବା ଲକ୍‌ ମସ୍‌ନେ ଅନି ବାରଇ ତାକେ ବେଟ୍‌ଅଇବାକେ ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ସେ ଲକ୍‌ ମସ୍‌ନେ ବାସାଅଇରଇଲା, ଆରି କେ ମିସା ତାକେ ସିକିଲି ସଙ୍ଗ୍‌ ବାନ୍ଦି ନାପାର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ତାକେ କେତେକ୍‌ ତର୍‌ ଗଡେ କଡୁ ଆରି ଆତେ ସିକିଲି ସଙ୍ଗ୍‍ ବାନ୍ଦ୍‌ଲେ ମିସା, ସେ ସିକିଲି ସବୁ ଚିଡାଇ ଦେଇ, କଡୁ ସବୁ ବାଙ୍ଗାଇ ପାକାଇତେ ରଇଲା । ତାକେ ବାନ୍ଦି ସଙ୍ଗଇବାକେ କାର୍‌ ମିସା ବପୁ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ସେ ଦିନ୍‌ ରାତି ସବୁବେଲେ ମସ୍‌ନେ ଆରି କୁପ୍‌ଲିତେଇ ରଇ କିର୍‌କିର୍‌ତେ ରଇଲା, ଆରି ପାକ୍‌ନା ସଙ୍ଗ୍‌ ଗାଗ୍‌ଡେ ମୁଣ୍ଡେ ମାରିଅଇ କଣ୍ଡିଆ ବଣ୍ଡିଆ ଅଇଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ସେ ଜିସୁକେ ଦୁରିକେ ଅନି ଦେକି ପାଲାଇ ଆସି ତାର୍‌ ମୁଆଟେ ଅଦର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ଆରି ଆଉଲି ଅଇ କିର୍‌କିରି କରି କଇଲା, “ଏ ସବୁର୍‌ ଟାନେଅନି ବଡ୍‌ ପର୍‌ମେସରର୍‌ ପ ଜିସୁ, ମର୍‌ ଟାନେ ତମର୍‌ କାଇ କାମ୍‌ ଆଚେ ? ମୁଇ ତମ୍‌କେ ପର୍‌ମେସରର୍‌ ନାଉଁ ଦାରି ଗୁଆରି କରି କଇଲିନି, ମକେ କସ୍‌ଟ ଦିଆନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","କାଇକେବଇଲେ ଜିସୁ ତାକେ ଆଗ୍‌ତୁ କଇତେରଇଲା, “ଏରେ ଡୁମା, ଏ ଲକର୍‌ଟାନେଅନି ବାରଇ ଜା ।” ");
INSERT INTO dso_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଆରି, ଜିସୁ ତାକେ ପାଚାର୍‌ଲା, “ତର୍‌ ନାଉଁ କାଇ ନାଉଁ ?” ସେ ତାକେ କ‍ଇଲା, “ମର୍‌ ନାଉଁ ବାଇନି ଡୁମା, ଏନ୍ତି ଆମେ ଜବର୍‌ ଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ଆରି, ସେ ଲକ୍‌ ଜେନ୍ତିକି ସେମନ୍‌କେ ସେ ଜାଗାଇ ଅନି ବାଇରେ ନ ପାଟାଅ ବଲି, ଜିସୁକେ ତର୍‌କେ ତର୍‌ ଜୁଆର୍‌ ବିଆର୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ସେ ଲଗର୍‌ କୁପ୍‌ଲି ପାଲିକେ ବେସି ଗୁସ୍‌ରି ମାନ୍ଦା ଚାର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ଆରି ଡୁମାମନ୍‌ ଜିସୁକେ ଜୁଆର୍‌ ବିଆର୍‌ କରି କଇଲାଇ, “ସେ ଗୁସ୍‌ରିମନର୍‌ ବିତ୍‌ରେ ପୁର୍‌ବାକେ ଆମ୍‌କେ ପାଟାଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ଜିସୁ ସେମନ୍‌କେ ଆଦେସ୍‌ ଦେଲାଦାପ୍‌ରେ, ସେ ଲକର୍‌ ଲଗେଅନି ଡୁମାମନ୍‌ ବାରଇକରି ଗୁସ୍‌ରିମନର୍‌ ବିତ୍‌ରେ ପୁର୍‌ଲାଇ । ସେଡ୍‌କିବେଲେ, ସେ ଆଡାର୍‌ ବିଡ୍‌କିକରି ପାଲାଇଲାଇ ଆରି କୁପ୍‌ଲି ଅନି ଗସ୍‌ରିକରି ସମ୍‌ଦୁରେ ଜାଇ ବୁଡି ମରିଗାଲାଇ । ଆଡାରେ ଗୁସ୍‌ରି ମାନ୍ଦା ପାକାପାକି ଦୁଇଅଜାର୍‌ଟା ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ଗୁସ୍‌ରିମନ୍‌କେ ଚାରାଇତେରଇବା ଲକ୍‌ମନ୍‌ ପାଲାଇ ଜାଇ ଗାଉଁ ଆରି ଗୁଡାମନ୍‌କେ ସେଟା ଜାନାଇଲାଇ । ଜାନାଇଲାଟା ସୁନି ଲକ୍‌ମନ୍‌ “ତେଇ କାଇଟା ଅଇଲାଆଚେ ?” ବଲି ଦେକ୍‌ବାର୍‌ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ଆରି ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସିକରି ସେ ଡୁମା ଦାରି ରଇଲା ଜନ୍‌ଲକ୍‌କେ କି ଆଗ୍‌ତୁ ବାଇନି ଡୁମା ଦାରିରଇଲା, ସେ ଲକ୍‌ ନିମାନ୍‌ ଲୁଗା ପିନ୍ଦିକରି ନିକ ଲକର୍‌ପାରା ବସିରଇବାଟା ଦେକି ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଦେକିରଇଲାଇ, ସେମନ୍‌ ସେ ଡୁମା ଦାରିରଇବା ଲକ୍‍କେ କାଇଟା ଅଇରଇଲା, ସେଟା ଆରି ଗୁସ୍‌ରିମନ୍‌କେ ଅଇଲା ବିସ‍ଇ ସେମନ୍‍କେ କଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ତେଇ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ସେମନର୍‌ ସନ୍ଦିଅନି ଚାଡି ଜିବାକେ ବାବୁଜିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ପଚେ ଜିସୁ ଡଙ୍ଗାଇ ଚଗ୍‌ବା ବେଲେ ଜନ୍‌ଲକ୍‌କେ ଆଗ୍‌ତୁ ଡୁମା ଦାରିରଇଲା, ସେ ଲକ୍‌ ତାର୍‌ ସଙ୍ଗ୍‍ ରଇବାକେ ବାବୁଜିଆ କଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ମାତର୍‌ ଜିସୁ ତାକେ ତେବାଇକରି କଇଲା, “ତମର୍‌ ଗରେ, ତମର୍‌ ନିଜର୍‌ ଲକ୍‌ମନର୍‌ ଟାନେ ଜା, ଆରି ପର୍‌ମେସର୍‌ ତର୍‌ପାଇ ଜନ୍‍ ବଡ୍‌ କାମ୍‌ କଲା ଆଚେ ଆରି ତକେ ଜନ୍‌ ଦୟା ଦେକାଇ ଆଚେ, ସେଟା ସବୁ ସେମନ୍‌କେ ଜାନାଇଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ତେଇଅନି ସେ ଲକ୍‌ ଜାଇକରି, ଜିସୁ ତାର୍‌ପାଇ ଜନ୍‍ ବଡ୍‌ କାମ୍‌ କରିରଇଲା, ସେ ସବୁ ଦେକାପଲି ନଅରେ, ଗାଉଁମନ୍‌କେ କଇବୁଲ୍‌ଲା । ତେଇ ସବୁଲକ୍‌ କାବା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଜିସୁ ଡଙ୍ଗା ଲଙ୍ଗି ଜାଇ ଆରିତରେକ୍‌ ବାଉଡି ଆଇଲାଦାପ୍‌ରେ, ଜବର୍‌ଲକ୍‌ ତାର୍‌ ଲଗେ ରୁଣ୍ଡ୍‌ଲାଇ, ଆରି ସେ ସମ୍‌ଦୁର୍‌ କଣ୍ଡି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ସେଡ୍‌କିବେଲେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରର୍‌ ମୁକିଅ, ଜାଇରସ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଆସି ଜିସୁକେ ଦେକି ତାର୍‌ ଗଡ୍‌ତଲେ ଅଦର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ଆରି ବେସି ବାବୁଜିଆ କରି କଇଲା, “ମର୍‌ ଟକି ମର୍‌ବା ଉପ୍‌ରେ ଆଚେ, ସେ ଜେନ୍ତି ନିକ ଅଇ ବଁଚ୍‌ସି, ତେବର୍‌ ପାଇ ତମେ ଆସି ତାର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ଜିସୁ ତାକର୍‌ ସଙ୍ଗ୍‌ ଗାଲା, ଆରି ଗାଦିଲକ୍‌ ତାର୍‌ ପଚେ ପଚେ ଜିବାର୍‌ ଦାର୍‌ଲାଇ, ଆରି ଲକ୍‌ମନ୍‌ ତାକେ ଡାବାଡାବି ଅଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ତେଇ ଗଟେକ୍‌ ବାର ବରସ୍‌ ଜାକ ଗାଗ୍‌ଡେଅନି ବନି ଜିବା ମାଇଜିଟକି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ଜେ କି କେତେ କେତେ ଡାକ୍‌ଟର୍‌ଟାନେ ଜାଇକରି ମିସା ସାସ୍‌ତି ବଗି ସବୁ ବିକିଦେଇ ରଇଲା । ମାତର୍‌ ଅଲପ୍‌ମିସା ନିକ ନ ଅଇ ଅଦିକ୍‌ ଅଦିକ୍‌ ଅଇଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ଜେଡେବେଲେ ସେ ଜିସୁର୍‌ ବିସଇ ସୁନି, ଲକ୍‌ ଗଅଲି ବିତ୍‌ରେ ପଚ୍‌ବାଟେ ଆସି ଜିସୁର୍‌ ଲୁଗା ଚିଇଲା, କାଇକେବଇଲେ ସେ କଇତେ ରଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“କେନ୍ତି ମିସା ମୁଇ ତାର୍‌ ଲୁଗାଜାଲି ଅଲପ୍‌ ଚିଇଲେ ନିମାନ୍‌ ଅଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ସେ ଦାପ୍‌ରେ ତାର୍‌ ବନି ଜିବାଟା ବନ୍ଦ୍‌ଅଇଗାଲା, ସେଟା ସେ ନିଜେ ଜାନି ପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ସେ ଦାପ୍‌ରେ ଜିସୁ ନିଜର୍‌ ଟାନେଅନି ସକ୍‌ତି ବାରଇବାଟା ଜାନିକରି ଲକ୍‌ମନର୍‌ ବାଟେ ବୁଲି ଦେକି କଇଲା, “କେ ମର୍‌ ଲୁଗା ଚିଇଲା ?” ");
INSERT INTO dso_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ତାର୍‌ ସିସ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ତମେତା ଦେକ୍‌ଲାସ୍‌ନି, ଲକ୍‌ମନ୍‌ ତମର୍‌ ଉପ୍‌ରେ ଡାବା ଡାବି ଅଇଗାଲାଇନି ଆରି ତମେ କେନ୍ତି କଇଲାସ୍‌ନି, କେ ମକେ ଚିଇଲା ବଲି ?” ");
INSERT INTO dso_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ମାତର୍‌ ଜେ ଏଟା କରିରଇଲା, ତାକେ ଦେକ୍‌ବାକେ ସେ ଚାରିବେଡ୍‌ତି ଆଁକି ବୁଲାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ସେଡ୍‌କି ବେଲେ ସେ ମାଇଜିଟକି ତାକେ ଜନ୍‌ ଜନ୍‌ଟା ଗଟିଆଚେ, ସେଟା ଜାନି, ଡରିକରି ତର୍‌ତରି ତର୍‌ତରି ଆସି ଜିସୁର୍‌ ଗଡ୍‌ତଲେ ଅଦ୍‌ରି ସବୁ ସତ୍‌କାତା କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ଜିସୁ ତାକେ କଇଲା, “ନୁନି, ମର୍‌ଟାନେ ବିସ୍‌ବାସ୍‌ କଲାକେ ତୁଇ ନିମାନ୍‌ ଅଇ ଆଚୁସ୍‌, ସାନ୍ତିଅଇ ଜା ଆରି ତର୍‌ ରଗେଅନି ନିମାନ୍‌ ଅଇ ର ।” ");
INSERT INTO dso_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ସେ ଏ କାତା କଇଲା ବେଲେ ଜିଉଦି ମନର୍‌ ପାର୍‌ତନା ଚାଲାଉ ଜାଇରସର୍‌ ଗରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଆସି କଇଲା, “ତମର୍‌ ନୁନି ମରିଗାଲାବେ, କାଇକେ ଗୁରୁକେ ଆରି କସ୍‌ଟ ଦେଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ମାତର୍‌ ଜିସୁ ସେମନ୍‌ କାତା ଅଇଲାଟା ନ ସୁନ୍‌ଲାପାରାଅଇ ପାର୍‌ତନା ଚାଲାଉକେ କଇଲା, “ଡରାନାଇ, ଆବ୍‌କା ବିସ୍‌ବାସ୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ଆରି ପିତର୍‌, ଜାକୁବ ଆରି ତାର୍‌ ବାଇ ଜଅନକେ ଚାଡି ଆରି କାକେ ନିଜର୍‌ ସଙ୍ଗ୍‌ ଜିବାକେ ଦେଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ସେମନ୍‌ ପାର୍‌ତନା ଚାଲାଉର୍‌ ଗରେ ଆଇଲା ଦାପ୍‌ରେ, ଜିସୁ, ଆଉଲି ଅଇବାଟା ଆରି ବେସି ମାର୍‌ଚପ୍‌ ଅଇ କାନ୍ଦ୍‌ବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ମାତର୍‌ ବିତ୍‌ରେ ଜାଇ ଲକ୍‌ମନ୍‌କେ କଇଲା, “କାଇକେ ଆଉଲି ଅଇ କାନ୍ଦ୍‌ଲାସ୍‌ନି ? ଏ ନୁନି ମରେ ନାଇ, ଅବ୍‌କା ସଇଦେଇଆଚେ ।” ସେଡ୍‌କି ବେଲେ ସେମନ୍‌ ଜିସୁକେ ଲାଜ୍‌ କରାଇ କଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ମାତର୍‌ ସେ ସବୁକେ ବାର୍‌କରି ଟକିର୍‌ ଆୟାବାବାକେ ଆରି ନିଜର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌, ତାକେ ଜନ୍‌ ଲଗେ ଡୁଲାଇ ରଇଲାଇ, ସେ ଜାଗାଇ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ଆରି ଟକିର୍‌ ଆତେଦାରି ତାକେ କଇଲା, “ଟଲିତାକୁମ୍‌ !” ବଇଲେ “ଏ ନୁନି ମୁଇଁ ତକେ କଇଲିନି ଉଟ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ଏତ୍‌କି କଇଲା ଦାପ୍‌ରେ ଟକି ଉଟି ବୁଲ୍‌ବାର୍‌ ଦାର୍‌ଲା, ତାକେ ବାର ବରସ୍‌ ଅଇରଇଲା । ସେଡ୍‌କିବେଲେ ସବୁଲକ୍‌ମନ୍‌ ଦେକି ଅଦିକ୍‌ କାବାଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ଜେନ୍ତି ଆରି, କେ ମିସା ଟକିକେ ଗଟ୍‌ଲା ବିସଇ ନାଜାନତ୍‌, ତେବର୍‌ ପାଇ ସେ ଟକିର୍‌ ଆୟାବାବାକେ ଅଦିକ୍‌ ଡାଟ୍‌ ସଙ୍ଗ୍‌ ଆଦେସ୍‌ ଦେଲା, ଆରି “ଟକିକେ କାଇଟା ଆଲେ କାଇବାକେ ଦିଆସ୍‌ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ଜିସୁ ସେ ଜାଗା ଚାଡି, ସାନ୍‌ବେଲେ ଅନି ବଡିଆଇଲା ନଅରେ ଆଇଲା, ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ମିସା ତାର୍‌ ସଙ୍ଗ୍‌ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ବିସ୍‌ରାମ୍‌ବାର୍‌ ଆଇଲାକେ, ସେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲା, ଆରି କେତେ କେତେ ଲକ୍‌ ତାର୍‌ କାତା ସୁନି କାବା ଅଇ କଇଲାଇ, “ଏ ଲକ୍‌ ଏ ସବୁଜାକ କନ୍ତି ଅନି ସିକ୍‌ଲା ? ଆରି, ଆକେ ଏନ୍ତାରି ଗିଆନ୍‌ କେ ଦେଲା ? ଆରି କେବେ ନ ଅଇବା କାମର୍‌ ବପୁ କନ୍ତିଅନି ପାଇଲା ? ");
INSERT INTO dso_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ଏ ଲକ୍‌ତା ସେ ବାଡଇ । ସେ ମରିୟମର୍‌ ପଅ, ଜାକୁବ୍‌, ଜସି, ଜିଉଦା ଆରି ସିମନ୍‌ ତାର୍‌ ବାଇ ଅଇବାଇ । ଆର୍‌ ବଇନିମନ୍‌ ତା ଇତି ଆମର୍‌ ସଙ୍ଗ୍‌ ଆଚତ୍‌ । ” ଏନ୍ତାରି କ‍ଇକରି ସେମନ୍‌ ତାକେ ମାନତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ତେଇ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ନିଜର୍‌ ନଅରର୍‌ କୁଟୁମର୍‌ ଲକ୍‌ମନ୍‌କେ ଆରି ନିଜର୍‌ ଗରର୍‌ ଲକ୍‌କେ ଚାଡି ବାକି ସବୁ ଜାଗାଇ ବାବବାଦିମନ୍‌କେ ସନ୍‌ମାନ୍‌ ମିଲ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ସେଜାଗାଇ ଆରି କେତେଟା ରଗିମନ୍‌କେ ସେ ଆତ୍‌ ସଙ୍ଗ‍ଇକରି ନିକ କର୍‌ବାଟା ଚାଡି ଆରି କାଇ ନ ଅଇବା କାମ୍‌ କରିନାପାର୍‌ଲା । କାଇକେବଇଲେ ତେଇର୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ଆରି ତେଇର୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ବିସ୍‌ବାସ୍‌ ନ କର୍‌ବାଟା ଦେକି ଜିସୁ କାବାଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ପଚେ ସେ ଚାରିବେଡ୍‌ତିର୍‌ ଗାଉଁ ମନ୍‌ ବୁଲି ବୁଲି ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲା । ଏତ୍‌କି ବିତ୍‌ରେ ସେ ବାରଟା ସିସ୍‌ମନ୍‌କେ ଲଗେ ଡାକି, ଦୁଇ ଦୁଇ ଲକ୍‌କେ ପାଟାଇବାର୍‌ ଆରାମ୍‌ କଲା, ସେମନ୍‌କେ ଡୁମାମନ୍‌କେ ଚାଡାଇବାକେ ଅଦିକାର୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ଜିବାବେଲେ ଗଟେକ୍‌ ଡାଙ୍ଗ୍‌ ଚାଡି ବାଟ୍‌ କର୍‌ଚର୍‌ ପାଇ ରୁଟି କି ବେସ୍‌ନିଟାନେ ଡାବୁ ନ ନିଆ ବଲି ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ମାତର୍‌ ସେମନ୍‌କେ ପାଣ୍ଡଇ ପିନ୍ଦ୍‌ବାକେ କଇଲା, ପିନ୍ଦିରଇବା ଚକା ଚାଡି ଆରି ଗଟେକ୍‌ ଚକା ନିଆନାଇ ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“ଜେଡେବେଲେ ତମ୍‌କେ ଜାର୍‌ ଗରେ ଡାକ୍‌ବାଇ ସେ ନଅର୍‌ ଚାଡିଜିବା ଜାକ ତେଇସେ ରୁଆ । ");
INSERT INTO dso_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ଜଦି କନ୍‌ ନଅରର୍‌ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ନ ନାମତ୍‌, ଆରି ତମର୍‌ କାତା ନ ସୁନତ୍‌, ସେ ଜାଗାଇ ଅନି ଆଇବା ବେଲେ ସେମନର୍‌ ବିରଦେ ସାକି ଇସାବେ, ତମର୍‌ ପାଦର୍‌ ଦୁଲି ପାପ୍‌ଡିଦିଆସ୍‌ । ଏଟାର୍‌ଲାଗି ସେ ନଅରର୍‌ ଲକ୍‌ମନ୍‌ ଜାନ୍‌ବାଇ ଜେ, ପର୍‌ମେସର୍‌ ସେମନ୍‌କେ ଡଣ୍ଡ୍‌ ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ସିସ୍‌ମନ୍‌ ବାରଇ ଜାଇ ଲକ୍‌ମନ୍‌କେ “ତମର୍‌ ପାପ୍‌ ଟାନେଅନି ବାଉଡା ।” ବଲି ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","କେତେକ୍‌ କେତେକ୍‌ ଲକ୍‌ମନର୍‌ ଟାନେଅନି ଡୁମା ଚାଡାଇଲାଇ, ଆରି କେତେକ୍‌ ରଗି ଲକ୍‌ମନ୍‌କେ ଚିକନ୍‌ ଲାଗାଇ ନିମାନ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଜିସୁର୍‌ ନାଉଁ ସବୁବାଟେ ଉଡ୍‌ରା ଅଇଗାଲାକେ, ଏରଦ୍‌ ରାଜା ଜିସୁର୍‌ ବିସଇ ସୁନ୍‌ଲା, ଆରି ଲକ୍‌ମନ୍‌ କଇତେରଇଲାଇ, ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ମରିକରି ଉଟି ଆଚେ, ତେବର୍‌ପାଇ ଏ ସବୁ ନ ଅଇବା କାମର୍‌ ସକ୍‌ତି ତାର୍‌ଟାନେ କାମ୍‌ କଲାନି । ");
INSERT INTO dso_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ମାତର୍‌ ବିନ୍‌ ବିନ୍‌ ଲକ୍‌ମନ୍‌ କଇତେ ରଇଲାଇ, ଏ ଏଲିୟ, ଆରି କେ କେ କଇତେ ରଇଲାଇ, ଆଗର୍‌ ବାବବାଦି ମନର୍‌ପାରା ଗଟେକ୍‌ ଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ମାତର୍‌ ଏରଦ୍‌ ଏଟା ସୁନି କଇଲା, “ମୁଇ ଜନ୍‌ ଜଅନର୍‌ ମୁଣ୍ଡ୍‌ କାଟାଇଲି, ସେ ମଲାତେଇଅନି ଉଟିଆଚେ !” ");
INSERT INTO dso_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ତେବେ ଏରଦ୍‌ ନିଜର୍‌ ବାଇ ପିଲିପର୍‌ ମାଇଜି ଏରଦିଆକେ ବିବା ଅଇ ରଇଲା । ତାକେ ସାର୍‌ଦା କର୍‌ବାକେ ନିଜେ ଏରଦ୍‌ ଲକ୍‌ମନ୍‌କେ ପାଟାଇ ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌କେ ଦାରି, ବାନ୍ଦିକରି ବନ୍ଦି କର୍‌ବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","କାଇକେବଇଲେ ଜଅନ୍‌ ଏରଦ୍‌କେ ତର୍‌କେତର୍‌ କଇତେରଇଲା “ମସାର୍‌ ନିୟମ୍‌ ଇସାବେ ନିଜର୍‌ ବାଇର୍‌ ମାଇଜିକେ ସଙ୍ଗଇବାର୍‌ ତର୍‌ ବିଦି ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ଏନ୍ତାରି କଇଲାକେ ଏରଦିଆ ଜଅନ୍‌କେ ରିସା ଅଇ ତାକେ ମରାଇବାକେ ମନ୍‌ କର୍‌ତେରଇଲା, ମାତର୍‌ ନାପାର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","କାଇକେବଇଲେ ଏରଦ୍‌ ଜଅନ୍‌କେ ଗଟେକ୍‌ ଦରମ୍‌ ଆରି ସୁକଲ୍‌ ଲକ୍‌ ବଲି ଜାନି ଡର୍‌ତେ ରଇଲା, ଆରି ତାକେ ରକିଆ କର୍‌ବାକେ ଚେସ୍‌ଟା କର୍‌ତେରଇଲା । ଜେଡେବେଲେ ମିସା ତାର୍‌ କାତା ସୁନ୍‌ତେରଇଲା, ବେସି କିଲ୍‌ବିଲ୍‌ ଅଇତେରଇଲା । ଏଲେମିସା ସେଟା ସାର୍‌ଦା ସଙ୍ଗ୍‌ ସୁନ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ପଚେ ଏରଦିଆର୍‌ ଜାଗ୍‌ତେ ର‍ଇବା ଦିନ୍‌ କେଟିଆଇଲା । ଏରଦର୍‌ ଜନମ୍‌ ଦିନେ, ନିଜର୍‌ ମନ୍ତ୍‍ରି ମନ୍‌କେ ଆରି ମୁକିଅ ମୁକିଅ ସେନାପତି ଆରି ଗାଲିଲିର୍‌ ବଡ୍‌ବଡ୍‌ ଲକ୍‌ମନ୍‌କେ ଡାକି, ରାତିଆ ଗଟେକ୍‌ ବଜିକଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ତେଇ ଏରଦିଆର୍‌ ଟକି ବିତ୍‌ରେ ପୁରି ଏରଦ୍‌ ଆରି ତାର୍‌ ସଙ୍ଗ୍‌ ବସି କାଇବା ଲକ୍‌ମନ୍‌କେ ନାଟ୍‌କରି ମନ୍‌ଚାଇ ଦେଲା । ରାଜା ଟକିକେ କଇଲା, “ତୁଇ ଜାଇଟା ମନ୍‌ କଲୁସ୍‌ନି ସେଟା ମାଙ୍ଗ୍‌, ମୁଇ ତକେ ଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ଆରି ଏରଦ୍‌ ତାର୍‌ ଲଗେ ପର୍‌ମାନ୍‌ କଲା, “ତୁଇ ଆମ୍‌କେ ଜାଇଟା ମାଙ୍ଗ୍‌ଲେ ମିସା, ମୁଇ ରାଇଜର୍‌ ଅଦ୍‌ ବାଗ୍‌ ଜାକ ତକେ ଦେଇ ଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ତେଇଅନି ସେ ବାରଇଜାଇ ତାର୍‌ ମାଆକେ ପାଚାର୍‌ଲା, “ମୁଇ କାଇଟା ମାଙ୍ଗ୍‌ବି ?” ତାର୍‌ ମାଆ କଇଲା, “ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ମୁଣ୍ଡ୍‌ ମାଙ୍ଗ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ସେଦାପ୍‌ରେ ଟକି ରାଜାର୍‌ ଲଗେ ଆସି ଏଟା କଇ ମାଙ୍ଗ୍‌ଲା, “ତୁଇ ମକେ ଏବେ ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ମୁଣ୍ଡ୍‌ ଗଟେକ୍‌ ତାଲାଇ କାଟି ଦେ ।” ");
INSERT INTO dso_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ସେକାତା ସୁନି ରାଜା ବେସି ଦୁକ୍‌ କଲା ମାତର୍‌ ନିଜେ କାତା ଦେଇର‍ଇଲାଟା ଆରି କାଇବାକେ ବସି ରଇବା ଲକ୍‌ମନର୍‌ମୁଆଟେ ମାଙ୍ଗ୍‌ଲାଟା ନାଇ ବଲି କ‍ଇବାକେ ମନ୍‌ କରେନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ତେବେ ରାଜା ସେଦାପ୍‌ରେ ଗଟେକ୍‌ ସଇନକେ ପାଟାଇ ତାର୍‌ ମୁଣ୍ଡ୍‌ ଆନ୍‌ବାକେ ଆଦେସ୍‌ ଦେଲା, ତେଇ ସଇନ ବନ୍ଦି ଗରେ ଜାଇ, ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ମୁଣ୍ଡ୍‌ କାଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଆରି ସେ ମୁଣ୍ଡ୍‌ ଗଟେକ୍‌ ତାଲାଇ ଆନି ଟକିକେ ଦେଲା, ଆରି ଟକି ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ମୁଣ୍ଡ୍‌ ନେଇ ତାର୍‌ ମାକେ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ତେଇର୍‌ କବର୍‌ ସୁନି ଆଇଲାଇ, ଆରି ମଲା ମଡ୍‌କେ ନେଇ ମସ୍‌ନେ ତପ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ପଚେ ପେରିତ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ରୁଣ୍ଡ୍‌ଲାଇ, ଆରି ସେମନ୍‌ ଜନ୍‌ ଜନ୍‌ଟା କରି ରଇଲାଇ, ଆରି ଜାଇ ଜାଇଟା ସିକାଇ ଦେଇରଇଲାଇ, ସେସବୁ ତାକେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ସେଡ୍‌କି ବେଲେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେମନ୍‌ ମର୍‌ସଙ୍ଗ୍‌ ଆସା ଆମେ ଗଟେକ୍‌ କିନରା ଜାଗାଇ ଜାଇ ଚନେକ୍‌ ବିସ୍‌ରାମ୍‌ କରୁ ।” କାଇକେବଇଲେ କେତେକ୍‌ କେତେକ୍‌ ଲକ୍‌ ଆସ୍‌ ଜା ଅଇତେରଇଲାଇଜେ ସେମନ୍‌କେ କାଇବାକେ ମିସା ସୁଜଗ୍‌ ନ ମିଲ୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ତେବେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ବାରଇ ବେଗ୍‌ଲି ଜାଇ ଡଙ୍ଗାଇ ବସି ଗଟେକ୍‌ କିନରା ଜାଗାଇ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ମାତର୍‌ ସେମନ୍‌ ବାରଇ ଜିବାଟା ବେସିଲକ୍‌ ଦେକି ଚିନ୍‌ଲାଇ, ଆରି ସବୁ ନଅରେ ଅନି ଲକ୍‌ମନ୍‌ ପାଲାଇ ପାଲାଇ ଜାଇ ସେମନର୍‌ ଆଗ୍‍ତୁ କେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ଜିସୁ ଡଙ୍ଗାଇଅନି ବାରଇ, ବେସି ଲକ୍‌ମନ୍‌କେ ଦେକି ତାର୍‍ ଜିବନ୍‌ ଦୁକାଇ ଦୟାକଲା । କାଇକେବଇଲେ ସେମନ୍‌ ଗଉଡ୍‌ ନ ରଇଲା ମେଣ୍ଡାରାସି ପାରା ରଇଲାଇ ଆରି ସେ ସେମନ୍‌କେ କେତେକ୍‌ ବିସଇ ସିକିଆ ଦେବାର୍‌ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ଏତ୍‌କି ବିତ୍‌ରେ ବେଲ୍‌ ବସି ଆଇବାକେ ସିସ୍‌ମନ୍‌ ଆସି ଜିସୁକେ କଇଲାଇ, “ଏ ଜାଗା ତା ଚିମ୍‌ରା ଜାଗା ଆରି ବେଲ୍‌ ମିସା ବସିଆଇଲାନି, ");
INSERT INTO dso_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ତେବର୍‌ପାଇ ଲକ୍‌ମନ୍‌କେ ପାଟାଇ ଦିଆସ୍‌ । ଜେନ୍ତି କି ସେମନ୍‌ ଚାରିବେଡ୍‌ତିର୍‌ ଗାଉଁ ମନ୍‌କେ ଜାଇ ନିଜର୍‌ ନିଜର୍‌ ପାଇ କାଇବାକେ କାଇଟା ମିସା ଗେନତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ତମେ ସେମନ୍‌କେ କାଇଟା ମିସା କାଇବାକେ ଦିଆସ୍‌ ।” ସେମନ୍‌ ତାକେ କଇଲାଇ, “ଆମେ ଜାଇ ଆଟ୍‌ ମାସର୍‌ କୁଲି ଡାବୁ ନେଇ ଏମନ୍‌କେ ରୁଟି ଗେନିଆନି କୁଆଇବୁ କି ?” ");
INSERT INTO dso_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମର୍‌ ଲଗେ କେତେଟା ରୁଟି ଆଚେ ? ଜାଇ ଦେକା ।” ସେମନ୍‌ ଦେକିଆସି ତାକେ କଇଲାଇ, “ପାଁଚ୍‌ଟା ରୁଟି ଆରି ଦୁଇଟା ମାଚ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ତେଇ ସବୁଲକ୍‌ ଜେନ୍ତି ଦଲ୍‌ଦଲ୍‌ ଅଇ କଅଁଲି ଗାଁସ୍‌ ଉପ୍‌ରେ ବସ୍‌ବାଇ, ଏଟାର୍‌ପାଇ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ତିଆର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ସେମନ୍‌ ସଏ ସଏ ଆରି ପଚାସ୍‌ ପଚାସ୍‌ ଲକ୍‌ ଦାଡି ଦାଡି ଅଇ ବସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ପଚେ ଜିସୁ ପାଁଚ୍‌ଟା ରୁଟି ଆରି ଦୁଇଟା ମାଚ୍‌ ଦାରି ସରଗ୍‌ ବାଟେ ଦେକି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲା, ଆରି “ରୁଟି ବାଙ୍ଗାଇ ଲକ୍‌ମନ୍‌କେ ଦିଆସ୍‌ ।” ବଲି ସିସ୍‌ମନ୍‌କେ ଦେଲା । ଆରି, ସେ ଦୁଇଟା ମାଚ୍‌ ସବୁକେ ବାଟାକରି ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ତେଇ ସବୁଲକ୍‌ କାଇକରି ପେଟ୍‌ ପୁରାଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ଆରି ସେମନ୍‌ ବାଙ୍ଗ୍‌ଲା ରୁଟି ଆରି ମାଚ୍‌ ରୁଣ୍ଡାଇ ବାର୍‌ଟା ଡାଲାଇ ପୁରୁନ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ତେଇ କାଇଲା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅବ୍‌କା ମନସ୍‌ ପିଲାମନ୍‌ ପାଁଚ୍‌ ଅଜାର୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ସେଦାପ୍‌ରେ ଜିସୁ ନିଜର୍‌ ସିସ୍‌ମନ୍‌କେ ଡଙ୍ଗାଇ ବସି ଗାଡ୍‌ ସେପାଟର୍‌ ବେତ୍‌ସାଇଦାଇ ତାର୍‌ ଆଗ୍‌ତୁ ଜିବାକେ କଇଲା, ଆରି ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌କେ ନିଜର୍‌ ନିଜର୍‌ ଗର୍‌ମନ୍‌କେ ପାଟାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ଜିସୁ ଲକ୍‌ମନ୍‌କେ ପାଟାଇଲା ପଚେ, ପାର୍‌ତନା କର୍‌ବାକେ କୁପ୍‌ଲିଉପ୍‌ରେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ରାତି ଅଇଲାକେ ଡଙ୍ଗା ସମ୍‌ଦୁର୍‌ ମଜାଇ ରଇଲା, ଆରି ସମ୍‌ଦୁର୍‌ ପାଲି ଜିସୁ ଗଟେକ୍‌ ଲକ୍‌ସେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ମୁଆଟ୍‌ ବାଟେ ଅନି ପବନ୍‌ ଆଇତେ ରଇଲାଜେ ତାର୍‌ ସିସ୍‌ମନ୍‌ ଡଙ୍ଗା ଗାଟ୍‌ବାକେ କସ୍‌ଟ ଅଇବାଟା ଜିସୁ ଦେକ୍‌ଲା । କୁକ୍‌ଡା ଡାକେ ଜିସୁ ସମ୍‌ଦୁର୍‌ ଉପ୍‌ରେ ଇଣ୍ଡି ଇଣ୍ଡି ସେମନର୍‌ ଲଗେ ଗାଲା, ଆରି ସେମନ୍‌କେ ବାଟ୍‌ ଦେଇ ଜିବାଟା ସିସ୍‌ମନ୍‌ ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ମାତର୍‌ ସେମନ୍‌ ଜିସୁ ପାନିତେଇ ଇଣ୍ଡ୍‌ବାଟା ଦେକି ଡୁମା ବଲି ବାବି କିର୍‌କିର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","କାଇକେବଇଲେ ସବୁଲକ୍‌ ତାକେ ଦେକି କିଲ୍‌ବିଲ୍‌ ଅଇଜାଇତେ ରଇଲାଇ । ସେଦାପ୍‌ରେ ଜିସୁ ସେମନର୍‌ ସଙ୍ଗ୍‌ କାତା ବାର୍‌ତା ଅଇ ସେମନ୍‌କେ କଇଲା, “ଡରାନାଇ ସାଆସ୍‌ ଦାରା, ଏଟାତା ମୁଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଆରି, ସେ ସେମନର୍‌ ଲଗେ ଜାଇ ଡଙ୍ଗାଇ ଚଗ୍‌ଲା, ଆରି ପବନ୍‌ ବନ୍ଦ୍‌ ଅଇଲା । ତେଇ ସେମନ୍‌ ମନେ ମନେ କାବା ଅଇଗାଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","କାଇକେବଇଲେ ପାଁଚ୍‌ଟା ରୁଟିର୍‌ ଗଟ୍‍ନାଇଅନି ଜିସୁ କେ ବଲି ବୁଜି ନ ରଇଲାଇଜେ ସେମନର୍‌ ବୁଦି ଗୁପିଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଗାଡ୍‌ ଲଙ୍ଗି ଗିନେସରତ୍‌ ବାଟେ ଜାଇକରି କେଟ୍‌ଲାଇ ଆରି ଗାଡ୍‌ପାଲି ଡଙ୍ଗା ବାନ୍ଦ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ଆରି, ଡଙ୍ଗାଇ ଅନି ଉତର୍‌ଲା ଦାପ୍‌ରେ, ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଚିନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ଆରି ସେମନ୍‌ ଜିସୁ ଆଇଲା କବର୍‌ ସୁନାଇବାକେ ସବୁ ଗାଏଁ ପାଲାଇଲାଇ । ସେ ଜନ୍‌ ଜନ୍‌ ଜାଗାଇ ଆଚେ ବଲି ସୁନ୍‌ଲାଇ, ସେ ଜାଗାଇ ଜରର୍‌ ଲକ୍‌ମନ୍‌କେ କଟ୍‌ ମିସ୍‌ତେ ବଇ ଆନ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଆରି ସେ ଜେତେକ୍‌ ଜେତେକ୍‌ ଗାଉଁ, ସଅର୍‌ ଆରି ପୁଟ୍‌ ମନ୍‌କେ କେଟ୍‌ଲା, ଲକ୍‌ମନ୍‌ ସେ ସବୁ ଜାଗାଇ ଆଟ୍‌ ବଜାର୍‌ମନ୍‌କେ ରଗିମନ୍‌କେ ସଙ୍ଗଇଦେଇ, ସେମନ୍‌ ତାର୍‌ ଲୁଗା ଅଁଟିଟାନେ ଚିଇବୁ ବଲି ଜୁଆର୍‌ବିଆର୍‌ କଲାଇ । ଜେତେକ୍‌ ଲକ୍‌ ତାକେ ଚିଇଲାଇ, ସବୁଲକ୍‌ ନିକ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ପଚେ ପାରୁସିମନ୍‌ ଆରି ଜିରୁସାଲାମ୍‌ ଅନି ଆସିରଇବା କେତେଟା ସାସ୍‌ତର୍‌ ସିକାଉ ପଣ୍ଡିତ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ରୁଣ୍ଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ତାର୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅନି କେତେକ୍‌ ସିସ୍‌ମନ୍‌ ଜିଉଦିମନର୍‌ ରିତିନିତି ଇସାବେ ଆତ୍‌ ନ ଦଇତେ କାଇବାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ପାରୁସିମନ୍‌ ଆରି ସବୁ ଜିଉଦିଲକର୍‌ ପାର୍‌ଚିନ୍‌ମନର୍‌ ନିୟମ୍‌ ମାନି ରିିତିନିତି ଇସାବେ ଆତ୍‌ ନ ଦଇତେ ନ କାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ଆରି ଆଟ୍‌ବାଟ୍‌ କରିଆସି ରିତିନିତି ଇସାବେ ପାନି ନ ଚିଚି ଅଇତେ ନ କାଇତେ ରଇଲାଇ । ଗିନା, ମୁତା, ପିତଲ୍‌ ତାଲା ଆରି ସଇବା କଟ୍‌ କେନ୍ତି ଦଇବାର୍‌, ସେଟା ସଙ୍ଗ୍‌ ଅଲ୍‌ଗା ରିତିନିତି ମିସା ମାନ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ତେବେ ପାରୁସି ଆରି ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “କାଇକେ ତର୍‌ ସିସ୍‌ମନ୍‌ ପାର୍‌ଚିନ୍‌ମନର୍‌ ରିତିନିତି ନ ମାନି ଆତ୍‌ ନ ଦଇ କାଇଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏରେ କୁଟିଆଲ୍‌ମନ୍‌, ତମର୍‌ ବିସଇନେଇ ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତା ନିକସଙ୍ଗ୍‍ ଜାନାଇଆଚେ, ସେ ଏନ୍ତି କଇଲା ଆଚେ ।” ପର୍‌ମେସର୍‌ କଇଲାନି “ଏ ଜାତି, ମକେ ମୁଏ ସନ୍‌ମାନ୍‌ ଦେବାଇ, ମାତର୍‌ ତାକର୍‌ ମନ୍‌ ମର୍‌ଟାନେଅନି ଦୁରିକେ ରଇସି । ");
INSERT INTO dso_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ସେମନ୍‌ ଲକ୍‌ମନ୍‌ କଲା ନିୟମ୍‌ ମାପ୍‌ରୁର୍‌ ନିୟମ୍‌ ବଲି ସିକାଇବାଇ ମାତର୍‌ ସେ ଉପାସନାର୍‌ କିଚି ମୁଲିଅ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ତମେ ପର୍‌ମେସରର୍‌ ଆଦେସ୍‌ ଇନ୍‌କରି ନର୍‌ଲକର୍‌ ରିତିନିତି ଦାରି ବସିଆଚାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ଆରି ଜିସୁ ସେମନ୍‌କେ କଇଲା, ତମେ ଚତୁର୍‌ ଅଇ ନିଜର୍‌ ରିିତିନିିତି ମାନ୍‌ବାକେ ବଲି ପର୍‌ମେସରର୍‌ ଆଦେସ୍‌ ନିଚୁ ବଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","କାଇକେବଇଲେ ମସା ସିକିଆ ଦେଇଆଚେ, ମା ବାବାକେ ମାନା, ଆରି ଜେ କି ତାର୍‌ ବାବାକେ କି ମାକେ ସାଇପ୍‌ ଦେଇସି, ସେ ମରନ୍‌ ଡଣ୍ଡ୍‌ ପାଇସି ଆକା । ");
INSERT INTO dso_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ମାତର୍‌ ତମେ ସିକାଇଲାସ୍‌ନି କି ଜେବେ ବାବାକେ କି ମାକେ କଇସା, “ଜନ୍‌ଟା ମୁଇ ତମ୍‌କେ ଦେବାର୍‌ ରଇଲା ସେଟା କର୍‌ବାନ୍‌ ।” କର୍‌ବାନ୍‌ ବଇଲେ ମାପ୍‌ରୁକେ ଆକା ମାନତ୍‌ କର୍‌ବାଟା । ");
INSERT INTO dso_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ତେବେ ତମେ ତାର୍‌ ବାବାର୍‌ କି ମାଆର୍‌ କାଇ ଉପ୍‌କାର୍‌ କର୍‌ବାଟାକେ ତେବାଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଏନ୍ତାରି ତମେ ନିଜର୍‌ ଆନିଦାଦିମନର୍‌ ବେଲେ ଅନି ଆଇବା ରିତିନିତି ମାନିକରି ପର୍‌ମେସରର୍‌ ବାକିଅ ଏଡାଇ ଦେଲାସ୍‌ନି, ଆରି ଏନ୍ତାରି କେତେକ୍‌ କେତେକ୍‌ କାମ୍‌ମନ୍‌ କଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ଜିସୁ ଆରି ତରେକ୍‌ ଲକ୍‌ମନ୍‌କେ ଲଗେଡାକି କଇଲା, “ତମେ ସବୁଲକ୍‌ ମର୍‌ କାତା ସୁନା ଆରି ବୁଜା । ");
INSERT INTO dso_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ଲକର୍‌ ଟଣ୍ଡେଅନି ଏନ୍ତାରି କାଇ ବିସଇ ନାଇ, ଜନ୍‌ଟା ତାର୍‌ ବିତ୍‌ରେ ପୁରି ତାକେ ଅସୁକଲ୍‍ କରି ପାରେ, ମାତର୍‌ ଜନ୍‌ ଜନ୍‌ଟା ମୁନୁସ୍‌ମନର୍‌ଟାନେଅନି ବାରଇସି ସେ ସବୁ ତାକେ ଅସୁକଲ୍‍ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ଜଦି ଜାକେ ସୁନ୍‌ବାର୍‌ କାନ୍‌ ଆଚେ, ସେ ସୁନ ।” ");
INSERT INTO dso_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ଆରି ଜିସୁ ଲକର୍‌ ମାନ୍ଦା ଚାଡି ଗରେ ପୁର୍‌ଲାପଚେ ତାର୍‌ ସିସ୍‌ମନ୍‌ ସେ ଉଦାଅରନର୍‌ ଅରତ୍‌ କାଇଟା ବଲି ପାଚାର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ମିସା କାଇ ବୁଜାସ୍‌ ନାଇ ? ଜନ୍‌ ଜିନିସ୍‌ ମିସା ବାଇରେ ଅନି ମୁନୁସ୍‌ମନର୍‌ ବିତ୍‌ରେ ପୁର୍‌ସି, ସେଟା ତାକେ ଆସାର୍‌ ନ କରେ । ");
INSERT INTO dso_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","କାଇକେବଇଲେ ସେଟା ତାର୍‌ ମନ୍‌ ବିତ୍‌ରେ ପୁରେନାଇ, ମାତର୍‌ ପେଟ୍‌ ବିତ୍‌ରେ ପୁରି କରି ବାଇରେ ବାରଇ ଆଇସି ।” ଏନ୍ତାରି କଇଲାକେ ସବୁ କାଦି ସୁକଲ୍‍ ଆକା ବଲି ଜିସୁ ଜାନାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଆରି ସେ କଇଲା, “ମୁନୁସର୍‌ ମନ୍‌ବିତ୍‌ରେ ଅନି ଜନ୍‌ଟା ବାରଇସି, ସେଟାସେ ତାକେ ଆସାର୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","କାଇକେବଇଲେ ମୁନୁସର୍‌ ମନ୍‌ ବିତ୍‌ରେ ଅନି କରାପ୍‌ ଚିନ୍ତା ବାରଇସି । ସେଟାମନ୍‌ ଅଇଲାନି, ପାଦ୍‌ରା ପାଦ୍‌ରି କାମ୍‌, ଚର୍‌କାମ୍‌, ଲକ୍‌ମନ୍‌କେ ମରାଇବା କାମ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ବିବା ଅଇ କର୍‌ବା ବେସିଆ କାମ୍‌, ବିବା ନଇତେ କର୍‌ବା ବେସିଆ କାମ୍‌, ଲବାଇବାଟା, ମିଚ୍‌ କଇବାଟା, ଅଲ୍‌ସୁଆ ଅଇବାଟା, ଆଁକାର୍‌ ଅଇବାଟା, ନିନ୍ଦା କାତା କଇବାଟା, ବଡ୍‌ପନ୍‌ ଅଇବାଟା, ବକୁଆ ଅଇବାଟା । ");
INSERT INTO dso_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ଏ ସବୁ କରାପ୍‌ ବିସଇମନ୍‌ ବିତ୍‌ରେଅନି ବାରଇ ଲକ୍‌କେ ନସାଇଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ତାର୍‌ପଚେ ଜିସୁ ସେ ଜାଗା ଚାଡିକରି ସର ଆରି ସିଦନର୍‌ ସଅରେ ଗାଲା । ତେଇ ଗଟେକ୍‌ ଗରେ ପୁର୍‌ଲା । ଜେନ୍ତି କେ ମିସା ସେଟା ନାଜାନତ୍‌, ଏଟା ସେ ମନ୍‍ କର୍‌ତେ ରଇଲା, ମାତର୍‌ ସେ ନ ଜାନାଇ ଅଇତେ ରଇନାପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ଜିସୁ ଆଇଲାଆଚେ ବଲି ସୁନ୍‌ଲା ଦାପ୍‌ରେ, ଗଟେକ୍‌ ମାଇଜି ଜାର୍‌ ସାନ୍‌ ଟକିକେ ଡୁମା ଦାରିରଇଲା, ତାର୍‌ ଗଡ୍‌ତଲେ ଆସି ଅଦର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ସେ ସୁର ଦେସର୍‌ ପଇନିକିଆ ଜାଗାଇ ଜନମ୍‌ ଅଇ ଜିଉଦି ଜାତିର୍‌ ନ ରଇଲା, ତାର୍‌ ଟକିକେ ଡୁମା ଚାଡାଇବାକେ ସେ ଜିସୁକେ ବାବୁଜିଆ କଲା । ");
INSERT INTO dso_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ତେବେ ଜିସୁ ତାକେ କଇଲା, “ଆଗ୍‌ତୁ ପିଲାମନ୍‌କେ ପେଟ୍‌ ପୁରୁନ୍‌ କାଇବାକେ ଦେସ୍‌, କାଇକେବଇଲେ ପିଲାମନର୍‌ କାଦି ନେଇ କୁକୁର୍‌ମନର୍‌ ଟାନେ ପାକାଇବାଟା ଟିକ୍‌ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ମାତର୍‌ ମାଇଜି ତାକେ କଇଲା, “ଉଁ ମାପ୍‌ରୁ, କୁକୁର୍‌ମନ୍‌ ମିସା ପିଲାମନର୍‌ ଅଦ୍‌ରି ରଇଲା ସକ୍‌ଡି କାଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ସେଡ୍‌କି ବେଲେ ଜିସୁ ତାକେ କଇଲା, “ଏନ୍ତାରି କଇଲାର୍‌ପାଇ ଜା, ତର୍‌ ଟକିତେଇଅନି ଡୁମା ବାରଇଗାଲାବେ ।” ");
INSERT INTO dso_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ଆରି ସେ ମାଇଜି ଗରେ ଜାଇ, ଟକି କଟେ ସଇରଇବାଟା ଆରି ତାର୍‌ଟାନେଅନି ଡୁମା ବାରଇଜାଇ ରଇବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ଜିସୁ ଆରିତରେକ୍‌ ସର ସନ୍ଦିଅନି ଜାଇ ସିଦନ୍‌ ଦେଇ ଦେକାପଲି ଦସ୍‌ଟା ସଅରେ ଉତ୍‌ରି ଗାଲିଲି ସମ୍‌ଦୁରେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ଆରି ତେଇ କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ କସ୍‌ଟସଙ୍ଗ୍‍ କାତା ଅଇବା ବଇରାକେ ଜିସୁର୍‌ ଲଗେ ଆନି ତାର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇବାକେ ବାବୁଜିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଜିସୁ ସେ ବଇରାକେ ଲକ୍‌ମନର୍‌ ଟାନେଅନି ବେଗ୍‌ଲାଇ କରି, ଡାକିନେଇ ତାର୍‌ ଦୁଇଟା କାନେ ଆଙ୍ଗ୍‍ଟି ପୁରାଇଲା ଆରି ତୁକିକରି ଆତ୍‌ସଙ୍ଗ୍‌ ସେ ଲକର୍‌ ଜିବେ ଲାଗାଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ଆରି ସରଗ୍‌ ବାଟେ ଦେକିକରି ଡେଙ୍ଗ୍‌ ପୁଣ୍ଡା ଦାରି ବଇରାକେ କଇଲା, “ଇପ୍‍ପତା !” ବଇଲେ ପୁଟିଅ । ");
INSERT INTO dso_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ସେ ଦାପ୍‌ରେ ତାର୍‌ କାନ୍‌ ଉଗାଡି ଅଇଲା, ଆରି ଜିବର୍‌ ବନ୍ଦନ୍‌ ପିଟିଗାଲା, ଆରି ସେ ନିମାନ୍‌ ସଙ୍ଗ୍‌ କାତା ଅଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଜିସୁ ଲକ୍‌ମନ୍‌କେ ଏ ବିସଇ କାକେ ନ କଇବାକେ ଆଦେସ୍‌ ଦେଲା, ମାତର୍‌ ସେ ଲକ୍‌ମନ୍‌କେ ଜେତେକ୍‌ ନିଚୁବଇଲେ ମିସା ସେମନ୍‌ ଆରି ଅଦିକ୍‌ ଅଦିକ୍‌ ସେଟା ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ଆରି ଲକ୍‌ମନ୍‌ ଅଦିକ୍‌ କାବା ଅଇ କଇଲାଇ, “ସେ ସବୁ କାମ୍‌ ନିମାନ୍‌ ସଙ୍ଗ୍‌ କରିଆଚେ, ସେ ବଇରାମନ୍‌କେ ସୁନ୍‌ବା ବପୁ ଆରି ଗୁଲାମନ୍‌କେ କଇବା ବପୁ ମିସା ଦେଇଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ସେବେଲେ ଆରି ତରେକ୍‌ ବେସି ଲକ୍‌ମନ୍‌ ମିସ୍‌ଲାଇ, ଆରି ସେମନର୍‌ ଲଗେ କାଇବା ପିଇବାକେ କାଇଟା ନ ରଇଲାଜେ ଜିସୁ ସିସ୍‌ମନ୍‌କେ ଲଗେଡାକି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ଏ ଲକ୍‌ମନ୍‌କେ ଦେକି ମକେ ଦୁକ୍‌ ଲାଗ୍‌ଲାନି, କାଇକେବଇଲେ ଏମନ୍‌ ତିନ୍‌ଦିନ୍‌ ଅଇଲାନି ମର୍‌ ସଙ୍ଗ୍‍ ଆଚତ୍‌ ଆରି ଏମନର୍‌ ଲଗେ କାଇବାକେ କାଇଟା ମିସା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ତେବେ ମୁଇ ସେମନ୍‌କେ ନ କୁଆଇତେ ଗରେ ପାଟାଇଲେ, ବାଟେ ସେମନର୍‌ ଚେତା ଆଜିଜାଇସି, ସେମନର୍‌ ବିତ୍‌ରେ କେତେକ୍‌ ଲକ୍‌ ଦୁରେଅନି ଆସି ଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ସିସ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ଇତି ଏ ଚିମ୍‌ରା ଜାଗାଇ ଲକ୍‌ ନ ରଇବାଟାନେ କନ୍ତିଅନି ରୁଟି ଆନି ଏମନ୍‌କେ ପେଟ୍‌ ପୁରାଇବାର୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ତମର୍‌ଲଗେ କେତେଟା ରୁଟିଆଚେ ?” ସେମନ୍‌ କଇଲାଇ, “ସାତ୍‌ଟା ।” ");
INSERT INTO dso_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ତେଇ ଜିସୁ ସେ ସବୁ ଲକ୍‌ମନ୍‌କେ ବୁଏଁ ବସ୍‌ବାକେ କଇଲା, ଆରି ସେ ସାତ୍‌ଟା ରୁଟି ଦାରିକରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଇ ସେଟା ସବୁ ବାଙ୍ଗାଇକରି ବାଟାକରିଦେବାକେ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଦେଲା । ଆରି ସେମନ୍‌ ଲକ୍‌ମନ୍‌କେ ସେଟା ବାଟାକଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ସେମନର୍‌ ଲଗେ ଜଡେକ୍‌ ପାରା କେତେଟା ସାନ୍‌ ମାଚ୍‌ ରଇଲା, ସେଟା ମିସା ସେ ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଇ ବାଟାକର୍‌ବାକେ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ତେଇ ସେମନ୍‌ ସବୁ ଲକ୍‌ ପେଟ୍‍ପୁର୍‌ତେ କାଇଲାଇ ଆରି ଅଗଲ୍‌ଲାଟା ସାତ୍‌ଡାଲା ବେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ତେଇ ଚାରିଅଜାର୍‌ ଲକ୍‌ମନ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ତାର୍‌ପଚେ ଜିସୁ ଲକ୍‌ମନ୍‌କେ ପାଟାଇ ଦେଲା ଆରି ନିଜର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ଡଙ୍ଗାଇ ଚଗି ଦଲ୍‌ମନୁତା ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ପଚେ ପାରୁସିମନ୍‌ ବାରଇ ଆସି ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ଦଦାପେଲା ଅଇବାର୍‌ ଦାର୍‌ଲାଇ । ତାକେ ପରିକା କର୍‌ବାକେ ପାନ୍ଦେ ପାକାଉଁ ବଲି ମନ୍‍କରି, ସେ ଜେ ପର୍‌ମେସର୍‌ଟାନେଅନି ଆସିଆଚେ, ଏଟା ଦେକାଇବାକେ ଆକାସେଅନି ଗଟେକ୍‌ କାବାଅଇଜିବା ଚିନ୍‌ ଦେକାଆ ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ଜିସୁ ଗଟେକ୍‌ ଡେଙ୍ଗ୍‌ପୁଣ୍ଡା ପୁଣ୍ଡିକରି କଇଲା, “ଏବର୍‌ ଲକ୍‌ମନ୍‌ କାଇକେ କାବା ଅଇବା ଚିନ୍‌ ମାଙ୍ଗ୍‌ଲାଇନି ? ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଆଜିକାଲିର୍‌ ଏ ଲକ୍‌ମନ୍‌କେ କାବା ଅଇବା କାଇ ଚିନ୍‌ ମିସା ଦେକାଇ ନଏଁ ।” ");
INSERT INTO dso_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ତାର୍‌ପଚେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ସେମନ୍‌କେ ତେଇ ଚାଡି ଡଙ୍ଗାଇ ଚଗି ଆରି ତରେକ୍‌ ଗାଡ୍‌ ସେପାଟେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ ଡଙ୍ଗାଇ ଗାଲାବେଲେ କାଇବାକେ ରୁଟି ନେବାକେ ପାସ୍‌ରିଜାଇରଇଲାଇ । ସେମନର୍‌ଟାନେ ଏକାଇ ଗଟେକ୍‌ ସେ ରୁଟି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ଜିସୁ ସେମନ୍‌କେ ଜାଗ୍‌ରତ୍‌ କରାଇ କଇଲା, “ପାରୁସିମନର୍‌ ଆରି ଏରଦର୍‌କମିର୍‌ ଅନି ତରିକ୍‌ନା ଅଇ ରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ଏଟା ସୁନି ସିସ୍‌ମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କାତାବାର୍‌ତା ଅଇକରି କଇଲାଇ, “ଆମର୍‌ଲଗେ କାଇବାକେ ରୁଟିନାଇ ବଲି ସେ ଏନ୍ତାରି କଇଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ସେମନ୍‌ କାଇ ବିସଇନେଇ କାତାବାର୍‌ତା ଅଇଲାଇନି ବଲି ଜିସୁ ଜାନିକରି ସେମନ୍‌କେ କଇଲା, “ତମର୍‌ ଲଗେ ଜେତ୍‌କି ଦର୍‌କାର୍‌ ଆଚେ, ସେତ୍‌କି ରୁଟିନାଇ ବଲିକରି ତମେ କାଇକେ କାତାବାର୍‌ତା ଅଇଲାସ୍‌ନି ? ଏବେଜାକ ତମେ କାଇ ଦେକାସ୍‌ ନାଇ କି ବୁଜାସ୍‌ନାଇ ? ତମର୍‌ ମନ୍‌ କାଇ ଆଁଟ୍‌ ଅଇଗାଲା ଆଚେ କି ? ");
INSERT INTO dso_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ଆଁକି ରଉ ରଉ ଦେକାସ୍‌ ନାଇ ? ଆରି, କାନ୍‌ ରଉ ରଉ ସୁନାସ୍‌ ନାଇ ? ଆମର୍‌ଟାନେ ଜେଡେବେଲେ କାଇବାକେ ଉନା ରଇଲା, ସେ ବେଲେ ମୁଇ କାଇଟା କରିରଇଲି ? ସେ ବିସଇ ତମେ ଏତାଆସ୍‌ ନାଇକି ? ");
INSERT INTO dso_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ମୁଇ ଜେଡେବେଲେ ପାଁଚ୍‌ ଅଜାର୍‌ ଲକର୍‌ ବିତ୍‌ରେ ପାଁଚ୍‌ଟା ରୁଟିବାଙ୍ଗାଇ ରଇଲି, ସେଡ୍‌କି ବେଲେ ତମେମନ୍‌ ସବୁ କେତେକ୍‌ ଡାଲା ବାଙ୍ଗ୍‌ଲା କଣ୍ଡ୍‌ ବେଟି ନେଇ ରଇଲାସ୍‌, ସେଟାକାଇ ତମର୍‌ ମନେ ନାଇ ?” ସେମନ୍‌ ତାକେ କଇଲାଇ, “ବାର ଡାଲା ।” ");
INSERT INTO dso_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ଆରି, ସେ ଚାରି ଅଜାର୍‌ ଲକର୍‌ ବିତ୍‌ରେ ମୁଇଁ ଜେଡେବେଲ୍‌ ସାତଟା ରୁଟି ବାଙ୍ଗାଇ ରଇଲି, ସେଡ୍‌କିବେଲେ ତମେମନ୍‌ ସବୁ କେତେକ୍‌ ଡାଲା ବାଙ୍ଗ୍‌ଲା କଣ୍ଡ୍‌ ଟୁଲିଆଇ ରଇଲାସ୍‌ ?” ସେମନ୍‌ କଇଲାଇ “ସାତ୍‌ ଡାଲା ।” ");
INSERT INTO dso_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ଆରି ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ମୁଇ କାଇଟା କଇଲିନି, ତମେ କେନ୍ତି ବୁଜାସ୍‌ ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ପଚେ ସେମନ୍‌ ବେତସାଇଦାଇ ଉଟି ଆଇଲାଇ, ଆରି ତେଇ କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ କାଣାଲକ୍‌କେ ଜିସୁର୍‌ ଲଗେ ଆନିକରି ତାକେ ଚିଇକରି ନିକ କର୍‌ବାକେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ଜିସୁ ତାକେ ଆତେଦାରି ଗାଉଁ ବାଇରେ ଡାକିନେଲା, ଆରି ତୁକିକରି ତାର୍‌ ଲାଲ୍‌ ସେ କାଣାର୍‌ ଆଁକିତେଇ ଲାଗାଇଲା । ତାର୍‌ମୁଣ୍ଡେ ଆତ୍‌ ସଙ୍ଗଇକରି “ତୁଇ ଅଲପ୍‌ ମିସା ଦେକି ପାର୍‌ଲୁସ୍‌ନି କି ?” ବଲି ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ସେ ଚାରିବେଡ୍‌ତି ଦେକିକରି କଇଲା, “ମୁଇ ଲକ୍‌ମନ୍‌ ଇଣ୍ଡ୍‌ବାଟା ଦେକିପାର୍‌ଲିନି, ମାତର୍‌ ସେମନ୍‌ ଗଚ୍‌ପାରା ଡିସ୍‌ଲାଇନି” ବଲିକରି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ଜିସୁ ଆରିତରେକ୍‌ ସେ କାଣାଲକର୍‌ ଆଁକିତେଇ ଆତ୍‌ସଙ୍ଗ୍‌ ଚିଇଲା । ସେଦାପ୍‌ରେ ଅନି ତାର୍‌ ଆଁକି ନିମାନ୍‌ ଅଇଗାଲା ଆରି ପୁରାପୁରୁନ୍‌ ନିମାନ୍‌ ଦେକିପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ଆରି ଜିସୁ ତାକେ କଇଲା, “ଏବେ ତୁଇ ଗାଏଁ ନ ଜାଆ, ମାତର୍‌ ତର୍‌ ନିଜର୍‌ ଗରେ ଉଟିଜା” ବଲିକରି ପାଟାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ତାର୍‌ପଚେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ କାଇସେରିଆ ପିଲିପ୍‌ ନାଉଁର୍‌ ଗଡ୍‌ଲଗେ ରଇବା ଚାରିବେଡ୍‌ତିର୍‌ ଗାଉଁ ମନ୍‌କେ ଗାଲାଇ । ବାଟେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ଲକ୍‌ମନ୍‌ ମକେ କେ ବଲିକରି ବାବ୍‌ଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ସେମନ୍‌ ତାକେ କଇଲାଇ, “କେତେ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ବଲିକରି କଇଲାଇନି, ଆରି ଅଦେକ୍‌ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଆଗର୍‌ ଏଲିୟ ବଲି କଇଲାଇନି ଆରି କେତେଲକ୍‌ ତମ୍‌କେ ପର୍‌ମେସରର୍‌ଟାନେଅନି ଆଦେସ୍‌ ପାଇ ଆସି, କାତାଅଇବା ବବିସତ୍‌ବକ୍‌ତା ମନର୍‌ଟାନେଅନି ଗଟେକ୍‌ଲକ୍‌ ବଲି କଇଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ଆରି ତମେ ମକେ କେ ବଲିକରି ବାବ୍‌ଲାସ୍‌ନି ? ବଲି ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା । ପିତର୍‌ କଇଲା, “ତୁଇ ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ଉଦାର୍‌କାରିଆ କିରିସ୍‌ଟ” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ତେଇ ଜିସୁ ସେମନ୍‌କେ ଡାଟ୍‌ସଙ୍ଗ୍ ଜାଗ୍‌ରତା କରାଇ କଇଲା, “ମୁଇ କେ ବଲି କାକେ ନ କୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ତାର୍‌ପଚେ ଜିସୁ, ପର୍‌ମେସର୍‌ ଅନି ଆଇଲା ନର୍‌ପିଲାକେ କାଇ କାଇଟା ଅଇସି ବଲି ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ସିକାଇଦେବାର୍‌ ଦାର୍‌ଲା । ସେ କଇଲା, “ପର୍‌ମେସରର୍‌ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ବେସି ଦୁକ୍‌ କସ୍‌ଟ ପାଇବାର୍‌ ଆଚେ । ମୁକିଅ ନେତାମନ୍‌, ମୁକିଅ ପୁଜାରିମନ୍‌, ଆରି ନିୟମ୍‌ ସିକାଇଦେବା ଲକ୍‌ମନ୍‌ ମକେ ନ ନାମତ୍‌ । ସେମନ୍‌ ମକେ ମରାଇବାଇ ଆରି ତିନ୍‌ଦିନ୍‌ ଗାଲାପଚେ ମୁଇ ଆରି ତରେକ୍‌ ମଲାତେଇଅନି ଜିବନ୍‌ ଅଇ ଉଟ୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ଏ ସବୁ ବିସଇର୍‌ କାତା ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କାଇଟାମିସା ନ ଲୁଚାଇକରି କୁଲାକୁଲି ବାବେ କଇଦେଲା । ସେ ବେଲା ପିତର୍‌ ଜିସୁକେ ଅଁତ୍‌ରେ ଡାକିନେଇକରି କଇଲା, “ତମେ କଇବା କାତା ସବୁ ସେନ୍ତି ନ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ଜିସୁ ପିଟିବାଟେ ପାସ୍‌ଲି ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଦେକ୍‌ଲା ଆରି ପିତର୍‌କେ କଇଲାଇ, “ତୁଇ ଏ କାତା ସଇତାନେଅନି କଇଲୁସ୍‌ନି, ତୁଇ ମର୍‌ଟାନେଅନି ଉଟି ଜା । ତୁଇ ପର୍‌ମେସର୍‌ ପାରା ଚିନ୍ତା ନ କରି ଲକ୍‌ମନର୍‌ ପାରା ଚିନ୍ତା କଲୁସ୍‌ନି ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ତାର୍‌ପଚେ ଜିସୁ ସିସ୍‌ମନ୍‌କେ ଆରି ଲକ୍‌ମନ୍‌କେ ତାର୍‌ଲଗେ ଡାକିକରି କଇଲାଇ “କେ ମର୍‌ ସିସ୍‌ ଅଇବାକେ ମନ୍‍ କଲାନି ବଇଲେ, ସେ ତାର୍‌ ନିଜର୍‌ ମନ୍‍ କଲାଟା ଚାଡିଦେଇକରି କୁର୍‌ସତେଇ ମର୍‌ବା ଲକ୍‌ମନ୍‌ ପାଇବା ଦୁକ୍‌ କସ୍‌ଟ ପାରା ଦୁକ୍‌ କସ୍‌ଟ ପାଇବାକେ, ତିଆର୍‌ ଅଇକରି ମର୍‌ସଙ୍ଗ୍‍ ଆଇବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ମାତର୍‌ କେ ନିଜର୍‌ ଜିବନ୍‌ ରକିଆ କର୍‌ବାକେ ମନ୍‍ କର୍‌ସି, ସେ ସେଟା ଆରାଇସି, ମାତର୍‌ ଜେ ମର୍‌ ଲାଗି ଆରି ସୁବ୍‍କବର୍‍ ଜାନାଇବାକେ ତାର୍‌ ଜିବନ ଆରାଇସି ବଇଲେ, ସେ ତାର୍‌ ଜିବନ୍‌ ରକିଆ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ଜଦି ଗଟେକ୍‌ ଲକ୍‌ ଦୁନିଆର୍‌ ସବୁ ଜିନିସ୍‌ ପାଇକରି, ନିଜର୍‌ ଜିବନ୍‌ ଆରାଇସି, ସେଟା ତାର୍‌ପାଇ କାଇ ଲାବ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ଆରି ତାର୍‌ ଆତ୍‌ମାର୍‌ ବାଦୁଲେ କାଇଟା ଦେଲେ ମିସା ସମାନ୍‌ ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ପର୍‌ମେସର୍‌କେ ଚାଡିକରି ରଇବା ଏ କାରାପ୍‍ ଦୁନିଆଇ, ଲକ୍‌ମନ୍‌ ଜଦି ମର୍‌ ଲାଗି ଆରି ମର୍‌ କାତାର୍‌ ଲାଗି ଲାଜ୍‌ ଅଇବାଇ, ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ମିସା ମର୍‌ ବାବାର୍‌ ବେସି ଉଜଲ୍‌ ଆରି ଡାକ୍‌ପୁଟା ସଙ୍ଗ୍‍ ଆରି ସରଗର୍‌ ସୁକଲ୍‌ ଦୁତ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଆଇଲାବେଲେ, ସେମନ୍‍କେ ମର୍‌ଲକ୍‌ମନ୍‌ ବଲି କଇବାକେ ମୁଇ ମିସା ଲାଜ୍‌ ଅଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ଆରିତରେକ୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି । ସେଟାର୍‌ପାଇ ସୁନା, ଏବେ ଇତି ରଇବା କେତେ ଲକ୍‌ମନ୍‌, ପର୍‌ମେସର୍‌ ରାଜା ଅଇକରି ତାର୍‌ ରାଇଜ୍‌ ସାସନ୍‌ କର୍‌ବାଟା ନ ଦେକ୍‌ବା ଜାକ ନ ମରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ଚଅ ଦିନ୍‌ ପଚେ ଜିସୁ ପିତର୍‌ ଜାକୁବ୍‌ ଆରି ଜଅନକେ ତାର୍‌ ସଙ୍ଗ୍‌ ମିସ୍‌ତେ ଡାକିକରି କେ ନଇବା ଗଟେକ୍‌ ଡେଙ୍ଗ୍‌ ପର୍‌ବତ୍‌ ଉପ୍‌ରେ ଗାଲା । ସିତି ସେମନର୍‌ ମୁଆଟେ ତାର୍‌ ରୁପ୍‌ ବଦ୍‌ଲିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ଆରି ତାର୍‌ ପଚିଆ ବେସି ଜଗ୍‌ଜଗି ଜାଇ, ଦବ୍‌ ଅଇଗାଲା । ଆରି ଏ ଦୁନିଆ ଇସାବେ କେ ମିସା ସେନ୍ତି ଦବ୍‌ କରି ଦଇନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ଆରି ମସାର୍‌ ସଙ୍ଗ୍‍ ଏଲିୟ ଆରି ଜିସୁ ମିସ୍‌ତେ କାତାବାର୍‌ତା ଅଇବାଟା ସେମନ୍‌କେ ଡିସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ତେଇ ପିତର୍‌ ଜିସୁକେ କଇଲା, “ଏ ଗୁରୁ ଆମେ ଇତି ରଇବାଟା ନିକ । ଇତି ତିନ୍‌ଟା କୁଡିଆ ତିଆର୍‌ କରୁ । ତମର୍‌ପାଇ ଗଟେକ୍‌, ମସାର୍‌ପାଇ ଗଟେକ୍‌ ଆରି ଏଲିୟର୍‌ ପାଇ ଗଟେକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ପିତର୍‌ କଇବା ବିସଇ କାଇଟା ବଲି ନିଜେ ନାଜାନି ରଇଲା । କାଇକେବଇଲେ ସେମନ୍‌ ବେସି ଡରିଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଆରି ସେମନ୍‌କେ ମେଗର୍‌ ଚାଇ ଡାବିଅଇଦେଲା । ସେ ମେଗେଅନି ଏନ୍ତାରି କାତା ଅଇଲା, “ଏ ମର୍‌ ଆଲାଦର୍‌ ପ, ଆର୍‌ କାତା ସୁନା ।” ");
INSERT INTO dso_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ଆରି ଅଟାତ୍‌ ସେମନ୍‌ ଚାରିବେଡ୍‌ତି ଦେକ୍‌ଲାଇ, ତାକର୍‌ ସଙ୍ଗ୍‍ ଜିସୁକେ ଚାଡି ଆରି କାକେ ମିସା ଦେକତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ସେମନ୍‌ ପର୍‌ବତେ ଅନି ଉତର୍‌ଲାବେଲେ ଜିସୁ ସେମନ୍‌କେ ଡାଟ୍‌ ସଙ୍ଗ୍‍ ଆଦେସ୍‌ ଦେଇ ଏନ୍ତି ବଲି କଇଲା, “ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆସିରଇବା ନର୍‌ପିଲା ମୁଇ, ମଲାଟାନେଅନି ଆରିତରେକ୍‌ ନ ଉଟ୍‌ବା ଜାକ ଇତି କାଇକାଇଟା ତମେ ଦେକ୍‌ଲାସ୍‌, ସେ ବିସଇ କାକେମିସା ନ କୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ସେଟାର୍‌ପାଇ ପର୍‌ବତ୍‌ ଉପ୍‌ରେ ଜାଇଟା ସେମନ୍‌ ଦେକ୍‌ଲାଇ, ସେ ବିସଇ କାକେମିସା କଅତ୍‌ ନାଇ । ମାତର୍‌ ମଲାଟାନେଅନି ଆରିତରେକ୍‌ ଉଟ୍‌ବା ଅରତ୍‌ କାଇଟା ବଲିକରି ସେମନ୍‌ କାତାବାର୍‌ତା ଅଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ସିସ୍‌ମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏଲିୟ ପର୍‌ତୁମ୍‌ ଆଇବାର୍‌ ଆଚେ ବଲି ନିୟମ୍‌ ସିକାଇଦେବା ଲକ୍‌ମନ୍‌ କାଇକେ କଇଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଉଁ ପର୍‌ମେସରର୍‌ ବଇତେଇ ଏଲିୟ ଆଗ୍‌ତୁ ଆଇସି ବଲି ଲେକା ଅଇଲାକାତା ସତ୍‌ସେ । ଏଲିୟ ପର୍‌ତୁମ୍‌ ଆସିକରି ସବୁ ବିସଇ ଟିକ୍ କର୍‌ସି, ମାତର୍‌ ପର୍‌ମେସର୍‌ ଅନି ଆସିରଇବା ନର୍‌ପିଲା ମୁଇ ବେସି ବେସି କସ୍‌ଟ ପାଇବି ଆରି ଲକ୍‌ମନ୍‌ ମକେ ନ ନାମତ୍‌ ବଲି ମିସା କାଇ ପର୍‌ମେସରର୍‌ ବଇଟାନେ ଲେକା ଅଏନାଇ କି ? ");
INSERT INTO dso_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଏବେ ଏଲିୟ ଆସି ସାର୍‌ଲା ଆଚେ । ଆରି ତାର୍‌ ବିସଇ ପର୍‌ମେସର୍‌ ଟାନେ କାଇଟା ଲେକା ଅଇଲା ଆଚେ, ସେ ସେନ୍ତିସେ ଲକ୍‌ମନ୍‌ ମିସା ତାକର୍‌ ନିଜର୍‌ ମନ୍‍ କଲା ଇସାବେ କରାପ୍‌ ଚଲାଚଲ୍‌ତି କଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ତାର୍‌ପଚେ ଜିସୁ, ପିତର୍‌, ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌ ବିନ୍‌ ସିସ୍‌ମନର୍‌ ଲଗେ କେଟ୍‌ଲାବେଲେ ତେଇ ବେସି ଲକ୍‌ମନ୍‌ ରୁଣ୍ଡିରଇବାଟା ଦେକ୍‌ଲାଇ । ଆରି ନିୟମ୍‌ ସିକାଇଦେବା ଲକ୍‌ମନ୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଦଦାପେଲା ଅଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ଲକ୍‌ମନ୍‌ ଜେଡେବେଲ୍‌ ଜିସୁ ତେଇ ଆଇବାଟା ଦେକ୍‌ଲାଇ, ସାର୍‌ଦାରେ କାବା ଅଇଗାଲାଇ ଆରି ଜିସୁକେ ଦୁକ୍‌ ସୁକ୍‌ ପାଚାର୍‌ବାକେ ତାର୍‌ଲଗେ ପାଲାଇ ଆସି ଜୁଆର୍‌ କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ତମେ ନିୟମ୍‌ ସିକାଇବା ଲକ୍‌, ମର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ କାଇ ବିସଇନେଇ ଦଦାପେଲା ଅଇତେରଇଲାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ସେ ମାନ୍ଦା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ ଡାକି କଇଲା, “ଏ ଗୁରୁ, ମୁଇ ମର୍‌ ପିଲାକେ ନିକ କର୍‌ବାକେ ତମର୍‌ ଟାନେ ଆନିରଇଲି । ତାର୍‌ ବିତ୍‌ରେ ଗଟେକ୍‌ କାରାପ୍‌ ଆତ୍‌ମା ପୁରିକରି ତାକେ କାତା ଅଇବାକେ ଦେଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ସେ କରାପ୍‌ ଆତ୍‌ମା ପିଲାକେ ଦାର୍‌ଲାବେଲେ, ତାକେ ମଡିକରି ଅଦ୍‌ରାଇଦେଲାନି ଆରି ତାର୍‌ ଟଣ୍ଡେଅନି ପେପୁଲ୍‌ ବାରଇଲାନି ଆରି ସେ ଦାତ୍‌ କାତର୍‌ସି । ଆରି ତାର୍‌ ଗାଗଡ୍‌ ସିଦା ଅଇଜାଇସି । ମୁଇ ତାର୍‌ତେଇ ଅନି କାରାପ୍‌ ଆତ୍‌ମାକେ ବାର୍‌କରାଇ କେଦିଦେବାଇ ବଲି ତମର୍‌ ସିସ୍‌ମନର୍‌ ଲଗେ ଆନିରଇଲି । ମାତର୍‌ ତମର୍‌ ସିସ୍‌ମନ୍‌ ନାପାର୍‌ଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏ ପର୍‌ମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ ନ ରଇବା ଆଜିକାଲିର୍‌ ଲକ୍‌ମନ୍‌, ତମେ ବିସ୍‌ବାସ୍‌ କର୍‌ବାକେ ଆରି କେତେ ଦିନ୍‌ ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‍ ରଇବାର୍‌ ଆଚେ ? ଆରି କେତେଦିନ୍‌ ମୁଇ ସାଆସ୍‌ ଦାରି ତମର୍‌ ସଙ୍ଗ୍‌ ରଇବାର୍‌ ଆଚେ ? ସେ ପିଲାକେ ମର୍‌ଲଗେ ଆନା ।” ");
INSERT INTO dso_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ଆରି ଲକ୍‌ମନ୍‌ ସେ ପିଲାକେ ଜିସୁର୍‌ଲଗେ ଆନ୍‌ଲାଇ । ସେ କରାପ୍‌ ଆତ୍‌ମା ଜିସୁକେ ଦେକ୍‌ଲା ଦାପ୍‌ରେ ପିଲାକେ ତଲେ ମଡିକରି ଅଦ୍‌ରାଇଲା । ଆରି ଗୁଣ୍ଡ୍‌ଲି ଗୁଣ୍ଡ୍‌ଲି କରି ତାର୍‌ ଟଣ୍ଡେଅନି ପେପୁଲ୍‌ ବାରଇ ଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ଜିସୁ ସେ ପିଲାର୍‌ ବାବାକେ ପାଚାର୍‌ଲା, “ଏ ପିଲା ଏନ୍ତି ଅଇ କେତେଦିନ୍‌ ଅଇଲା ?” ପିଲାର୍‌ ବାବା କଇଲା, “ ସାନ୍‌ବେଲେଅନି ” ବଲି । ");
INSERT INTO dso_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ଆରି ସେ କଇଲା, “ସେ କାରାପ୍‌ ଆତ୍‌ମା ପିଲାକେ ମରାଇବାକେ ବେସିତର୍‌ ପାନିଟାନେ ଆରି ଜଇଟାନେ ମଡିକରି ଅଦ୍‌ରାଇ ଆଚେ । ମାତର୍‌ ତୁଇ ଜଦି କାଇଟା କର୍‌ବାକେ ପାରୁସ୍‌ ବଇଲେ ଆମର୍‌ ପାଇ ଦୟାକରି ସାଇଜ କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ଜିସୁ ତାକେ କଇଲା, “କାଇକେ ଜଦି ପାରୁସ୍‌ ବଇଲେ ନିମାନ୍‌ କର୍‌ ବଲିକରି କଇଲୁସ୍‌ନି ? କାଇକେବଇଲେ ପର୍‌ମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ ତେଇ ସବୁ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ସେ ଦାପ୍‌ରେ ପିଲାର୍‌ ବାବା ଆଉଲିଅଇକରି, “ମୁଇ ବିସ୍‌ବାସ୍‌ କଲିନି, ଆରି ଅଦିକ୍‌ ବିସ୍‌ବାସ୍‌ କର୍‌ବାକେ ମକେ ସାଇଜ କର୍‌ ।” ବଲିକରି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ଏ ଗଟ୍‍ନାର୍‌ କାମ୍‌ ଦେକ୍‌ବାକେ ଲକ୍‌ମନ୍‌ ଏକାତରେ ପାଲାଇଆଇବାଟା ଜିସୁ ଦେକିକରି ସେ କାରାପ୍‌ ଆତ୍‌ମାକେ ଦମ୍‌କାଇକରି କଇଲା, “ଏ କରାପ୍‌ ଆତ୍‌ମା, ତୁଇ ଏ ପିଲାକେ ଗୁଲା ଆରି ବଇରା କରାଇଆଚୁସ୍‌ । ଏ ପିଲାର୍‌ ଗାଗ୍‌ଡେଅନି ବାରଇ ଉଟିଜା ଆରି କେବେ ମିସା ତାର୍‌ ଗାଗ୍‌ଡେ ନ ପୁର୍‌, ବଲି ମୁଇ ତକେ ଆଦେସ୍‌ ଦେଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ଆରି କାରାପ୍‌ ଆତ୍‌ମା ବେସି ଆଉଲିଅଇକରି ପିଲାକେ ମଡିକରି ଅଦ୍‌ରାଇ, ତାର୍‌ଟାନେଅନି ବାରଇଗାଲା । ଆରି ପିଲା ମରିଗାଲା ଲକର୍‌ ପାରା ଡିସ୍‌ଲା, ଏନ୍ତିକି କେତେକ୍‌ ଲକ୍‌ମନ୍‌ “ସେ ମରିଗାଲା ।” ବଲିକରି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ମାତର୍‌ ଜିସୁ ସେ ପିଲାକେ ଆତେଦାରି ଉଟାଇକରି ତାକେ ଟିଆ କରାଇଲାକେ ସେ ଟିଆଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଗଟେକ୍‌ ଗର୍‌ ବିତ୍‌ରେ ଗାଲାପଚେ, ଲକ୍‌ମନ୍‌ କେ ନଇଲାବେଲେ ତାକେ ପାଚାର୍‌ଲାଇ, “ଆମେ କାଇକେ ସେ କାରାପ୍‌ ଆତ୍‌ମାକେ କେଦି ନାପାର୍‌ଲୁ ?” ");
INSERT INTO dso_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ଏ କାତା ସୁନି ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏନ୍ତାରି କାରାପ୍‌ ଆତ୍‌ମା ପର୍‍ମେସର୍‍କେ ପାର୍‌ତନା କରିସେ କେଦ୍‌ବାର୍‌ ଅଇସି, ଆରି କାଇ ବାଟ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ତାର୍‌ପଚେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ସେ ଜାଗା ଚାଡିକରି ଉଟିଗାଲାଇ । ସେମନ୍‌ ଗାଲିଲି ଦେସର୍‌ ବାଟ୍‍ଦେଇକରି ଜାଇତେରଇଲାଇ । ସେମନ୍‌ କନ୍‌ ଜାଗାଇ ଆଚତ୍‌ ବଲିକରି ଲକ୍‌ମନ୍‌ ନ ଜାନତ୍‌ ବଲି ଜିସୁ ମନ୍‍ କର୍‌ତେରଇଲା ");
INSERT INTO dso_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","କାଇକେବଇଲେ ସେ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ସିକାଇ ଦେବାକେ ମନ୍‍ କର୍‌ତେରଇଲା । ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ସତ୍‌ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆସିରଇବା ନର୍‌ପିଲା ମକେ, ଲକ୍‌ମନର୍‌ ଆତେ ସର୍‌ପି ଦେବାଇ ଆରି ସେମନ୍‌ ମକେ ମରାଇଦେବାଇ । ମାତର୍‌ ମୁଇ ମରିକରି ତିନ୍‌ଦିନ୍‌ ଗାଲାପଚେ ଆରି ତରେକ୍‌ ମଲାଟାନେଅନି ଜିବନ୍‌ ଅଇ ଉଟ୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ମାତର୍‌ ଜିସୁ କଇବା ଏ କାତାର୍‌ ଅରତ୍‌ ସିସ୍‌ମନ୍‌ ବୁଜତ୍‌ ନାଇ ଆରି ସେମନ୍‌ ସେ କାତାର୍‌ ଅରତ୍‌ ପାଚାର୍‌ବାକେ ଡର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ କପର୍‌ନାଉମେ ଆଇଲାଇ ଆରି ସେମନ୍‌ ଗର୍‌ ବିତ୍‌ରେ ଗାଲାଇ । ତାର୍‌ପଚେ ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ତମେ ବାଟେ କନ୍‌ ବିସଇନେଇ ଦଦାପେଲା ଅଇତେରଇଲାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ମାତର୍‌ ତାର୍‌ ସିସ୍‌ମନ୍‌ ଚିମ୍‌ରା ଅଇଦେଲାଇ । କାଇକେବଇଲେ ସେମନ୍‌ ବାଟେ, ଆମର୍‌ ବିତ୍‌ରେ ସବୁର୍‌ଟାନେଅନି କେ ବଡ୍‌ ବଲି ଦଦାପେଲା ଅଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ଜିସୁ ବସ୍‌ଲା ଆରି ତାର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ତାର୍‌ଲଗେ ଡାକାଇ ସେମନ୍‌କେ କଇଲା, “ଜଦି କେ ମୁକିଆ ଅଇବାକେ ମନ୍‍ କଲେ, ସେ ସବୁର୍‌ଟାନେଅନି ସାନ୍‌ ଅଇବାର୍‌ ଆଚେ, ଆରି ସବୁଲକର୍‌ ସେବା କର୍‌ବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ତାର୍‌ପଚେ ଜିସୁ ଗଟେକ୍‌ ସାନ୍‌ଟା ପିଲାକେ ନେଇକରି ସେମନର୍‌ ମୁଆଟେ ଟିଆ କରାଇ ସେମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“କେ କେ ମର୍‌ ଲାଗି ଏନ୍ତାରି ଗଟେକ୍‌ ସାନ୍‌ଟା ପିଲାକେ ନାମ୍‌ବାଇ, ସେମନ୍‌ ମକେ ନାମ୍‌ଲାଇନି, ଆରି କେ କେ ମକେ ନାମ୍‌ଲାଇନି, ସେମନ୍‌ ମକେ ନାଇ, ମାତର୍‌ ମକେ ପାଟାଇରଇବା ମର୍‌ ବାବାକେ ନାମ୍‌ଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଜଅନ୍‌ ଜିସୁକେ କଇଲା, “ଏ ଗୁରୁ, ଗଟେକ୍‌ ଲକ୍‌ ତର୍‌ନାଉଁ ଦାରି ଲକ୍‌ମନର୍‌ଟାନେଅନି କାରାପ୍‌ ଆତ୍‌ମାକେ ବାର୍‌କରାଇ କେଦିଦେବାଟା ଆମେ ଦେକିକରି, ତାକେ ସେନ୍ତି ନ କର୍‌ ବଲି କଇଲୁ, କାଇକେବଇଲେ ସେ ଆମର୍‌ ନିଜର୍‌ ଲକ୍‌ ନଏଁ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ମାତର୍‌ ଜିସୁ କଇଲା, “ତାକେ ଏନ୍ତି ନ କର୍‌ ବଲି ତେବାଆ ନାଇ କାଇକେବଇଲେ, ମର୍‌ ନାଉଁର୍‌ ବପୁ ପାଇକରି କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ କରିପାର୍‌ବା ଲକ୍‌, ମର୍‌ ବିରୁଦେ କାରାପ୍‌ କାତା ନ କଏ । ");
INSERT INTO dso_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","କାଇକେବଇଲେ ଜେ ଆମ୍‌କେ ବିରଦ୍‌ ନ କରେ, ସେ ଆମର୍‌ ନିଜର୍‌ ଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ଆରି ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, କେ ତମ୍‌କେ ମର୍‌ନାଉଁ ଦାରି ଗଟେକ୍‌ ଗିଲାସ୍‌ ପାନି କାଇବାକେ ଦେଇସିବଇଲେ, ସେଟାର୍‌ପାଇ ସତ୍‌ସେ ତାକେ ପୁରୁସ୍‌କାର୍‌ ମିଲ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ଜିସୁ କଇବାର୍‌ ଦାର୍‌ଲା “ଜଦି କେ ମର୍‌ତେଇ ବିସ୍‌ବାସ୍‌ କରିରଇବା ଗଟେକ୍‌ ଲକ୍‌କେ, ସେ କରିରଇବା ବିସ୍‌ବାସ୍‌ ଚାଡିଦେବାକେ ପାପ୍‌କାମ୍‌ କରାଇଲାଇନି ବଇଲେ, ସେ ଲକର୍‌ ଗାଲାଇ ଜତା ପାକ୍‌ନା ବାନ୍ଦିକରି ତାକେ ସମ୍‌ଦୁରେ ପିଙ୍ଗିଦେବାଟା ତାର୍‌ପାଇ ନିକ ଅଇତା । ");
INSERT INTO dso_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ଜଦି ତମର୍‌ ଆତ୍‌ ତମ୍‌କେ ପାପ୍‌ କରାଇଲାନି ବଇଲେ, ସେ ଆତ୍‌ କାଟିପାକାଆ । କାଇକେବଇଲେ ଜଡେକ୍‌ ଆତ୍‌ ରଇକରି ସବୁଦିନର୍‌ପାଇ ଜଇଲାଗ୍‌ବା ନର୍‌କେ ପେଲାଇଅଇବା ବାଦୁଲେ ଗଟେକ୍‌ ଆତ୍‌ ନ ରଇକରି ସର୍‌ଗେ କେଟ୍‌ବାଟା ନିକ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","କାଇକେବଇଲେ ନର୍‌କେ ସେମନର୍‌ କିଡା ନସ୍‌ଟ ନ ଅଅତ୍‌ ଆରି ଜଇ ନ ଲିବେ । ");
INSERT INTO dso_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଜଦି ତମର୍‌ ପାଦ୍‌ ତମ୍‌କେ ପାପ୍‌କାମ୍‌ କରାଇଲାନି ବଇଲେ, ସେ ପାଦ୍‌ କାଟି ପିଙ୍ଗିଦିଆସ୍‌ । ଜଡେକ୍‌ ପାଦ୍‌ ରଇକରି ନର୍‌କେ ପେଲାଇଅଇବା ବାଦୁଲେ ଚଟା ଅଇକରି ସର୍‌ଗେ କେଟ୍‌ବାଟା ତମର୍‌ପାଇ ନିକଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","କାଇକେବଇଲେ ନର୍‌କେ ସେମନର୍‌ କିଡା ନସ୍‌ଟ ନ ଅଅତ୍‌ ଆରି ଜଇ ନ ଲିବେ । ");
INSERT INTO dso_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ଜଦି ତମର୍‌ ଆଁକିର୍‌ ଲାଗି ତମେ ବିସ୍‌ବାସ୍‌ ଆରାଇଲାସ୍‌ନି ବଇଲେ, ସେ ଆଁକି ବେଟି ପିଙ୍ଗିଦିଆସ୍‌ । କାଇକେବଇଲେ ଜଡେକ୍‌ ଆଁକି ରଇ ନର୍‌କେ ପେଲାଇଅଇବା ବାଦୁଲେ, ଗଟେକ୍‌ ଆଁକି ରଇକରି ସରଗ୍‌ ରାଇଜେ କେଟ୍‌ବାଟା ତମର୍‌ପାଇ ନିକରଇସି । ");
INSERT INTO dso_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","କାଇକେବଇଲେ ନର୍‌କେ ସେମନର୍‌ କିଡା ନସ୍‌ଟ ନ ଅଅତ୍‌ ଆରି ଜଇ ନ ଲିବେ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ଜେନ୍ତିକି ସୁନା ଜଇଟାନେ ପଡାଇକରି ନିର୍‌ମଲ୍‌ କଲାପାରା ସବୁ ଲକ୍‌ମନ୍‌କେ ଜଇସଙ୍ଗ୍‌ ନିର୍‌ମଲ୍‌ କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ନୁନ୍‌ ଗଟେକ୍‌ ନିମାନ୍‌ ଜିନିସ୍‌ । ମାତର୍‌ ନୁନ୍‌ ଜଦି ତାର୍‌ କରିଆ ଅଇବାଟା ଆରାଇସି ବଇଲେ ସେ ଆରି ତରେକ୍‌ କେନ୍‌ତାର୍‌ କରିଆ ଅଇପାର୍‌ସି ? ତମେ ନୁନ୍‌ ପାରା ନିମାନ୍‌ ଗୁନେ ପୁରାପୁରୁନ୍‌ ଅଇ ସବୁଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ମିସି ବିଡି କରି ସୁଆଲେ ରୁଆ” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ତାର୍‌ପଚେ ଜିସୁ ସେ ଜାଗା ଚାଡିକରି ଜିଉଦା ରାଇଜର୍‌ ସନ୍ଦି ଆରି ଜର୍‌ଦନର୍‌ ଆରି ଗଟେକ୍‌ ବାଟେ ଆଇଲା । ଆରି ସବୁ ବେଲାର୍‌ ପାରା ଲକ୍‌ମନ୍‌ ତାର୍‌ ଲଗେ ରୁଣ୍ଡ୍‌ଲାଇ । ଆରି ଜିସୁ ସେମନ୍‌କେ ପର୍‌ମେସରର୍‌ କାତା ସିକାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","କେତେଟା ପାରୁସିମନ୍‌ ଜିସୁରୁ ଲଗେ ଆସିକରି ତାକେ ବୁଲ୍‌ ଦାର୍‌ବାକେ ଏନ୍ତାରି ପର୍‌ସନ୍‌ ପାଚାର୍‌ଲାଇ । “ଗଟେକ୍‌ ମୁନୁସ୍‌ ତାର୍‌ ମାଇଜିକେ ଚାଡିଦେବାଟା ଆମର୍‌ ନିୟମେ ଆଚେ କି ?” ");
INSERT INTO dso_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମସା ତମ୍‌କେ କାଇ ଆଦେସ୍‌ ଦେଲା ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ସେମନ୍‌ କଇଲାଇ, “ଗଟେକ୍‌ ମୁନୁସ୍‌ ତାର୍‌ ମାଇଜିକେ ଚାଡିଦେବାର୍‌ ରାଜିନାମା ପତର୍‌ ଲେକି ତାକେ ଦେଲାପଚେ ତାକେ ପାଟାଇଦେଇ ଅଇସି ବଲି ମସା କଇଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମସା କାଇକେ ଏନ୍ତି ଲେକିରଇଲା ବଇଲେ, ତମର୍‌ ମନ୍‌ବିତ୍‌ରର୍‌ ବୁଜ୍‌ବା ବପୁ ଡାଟ୍‌ ରଇଲାଟା ଦେକିକରି ସେ, ଏ ଆଦେସ୍‌ ଲେକିଦେଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ଜେନ୍ତି ସାସ୍‌ତର୍‌ କଇଲାନି, ପର୍‌ମେସର୍‌ ଜେଡେବେଲେ ଏ ଦୁନିଆ ତିଆର୍‌କଲା, ସେବେଲେ ସେ ମାଇଜିମୁନୁସ୍‌ କରି ତିଆର୍‌କଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ସେଟାର୍‌ପାଇ ଗଟେକ୍‌ ମୁନୁସ୍‌ ତାର୍‌ ବାବା ମାକେ ଚାଡିକରି ତାର୍‌ ମାଇଜି ସଙ୍ଗ୍‌ ମିସ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ସେ ଦୁଇଲକ୍‌ ଗଟେକ୍‌ ଅଇବାଇ, ଆରି ସେମନ୍‌ ଦୁଇଲକ୍‌ ଇସାବେ ନ ରଅତ୍‌, ମାତର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଇସାବେ ରଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ସେଟାର୍‌ପାଇ ପର୍‌ମେସର୍‌ ଜନ୍‌ ଦୁଇଲକ୍‌କେ ମିସାଇଆଚେ, କେ ମିସା ସେମନ୍‌କେ ବିନେ ନ ବେଗ୍‌ଲାଅତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଗରେ ବାଉଡିଗାଲା ପଚେ, ସିସ୍‌ମନ୍‌ ଆରିତରେକ୍‌ ଏ ବିସଇ ତାକେ ପାଚାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଗଟେକ୍‌ ମନସ୍‌ ତାର୍‌ ମାଇଜିକେ ଚାଡ୍‌ପତର୍‌ ଦେଇ ବିନ୍‌ ମାଇଜିକେ ବିବା ଅଇସି ବଇଲେ, ସେ ମନସ୍‌ ପର୍‌ତୁମ୍‌ ମାଇଜିର୍‌ ବିରୁଦେ ପାଦ୍‌ରା କାମ୍‌ କଲାନି । ");
INSERT INTO dso_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ଆରି ସେନ୍ତି ସେ ଜନ୍‌ ମାଇଜିଟକି ତାର୍‌ ମୁନୁସ୍‌କେ ଚାଡ୍‌ ପତର୍‌ ଦେଇ, ବିନ୍‌ ମୁନୁସ୍‌କେ ବିବା ଅଇସି ବଇଲେ ସେ ମିସା ପର୍‌ତୁମ୍‌ ମନସ୍‌ ବିରୁଦେ ପାଦ୍‌ରି କାମ୍‌ କଲାନି ।” ବଲିକରି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ଗଟେକ୍‌ ଦିନ୍‌ କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ତାକର୍‌ ପିଲାଟକିମନ୍‌କେ ଜିସୁ ଆତ୍‌ ସଙ୍ଗଇ ଆସିର୍‌ବାଦ୍‌ କର ବଲି ତାର୍‌ଲଗେ ଆନ୍‌ଲାଇ । ମାତର୍‌ ତାର୍‌ ସିସ୍‌ମନ୍‌ ଲକ୍‌ମନ୍‌କେ, ଦମ୍‌କାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଜିସୁ ଏଟା ଦେକି ବେସି ରିସାଅଇ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ସାନ୍‌ ପିଲାମନ୍‌କେ ମର୍‌ ଲଗେ ଆଇବାକେ ବାଟ୍‌ ଦିଆସ୍‌, ସେମନ୍‌କେ ମନା କରାନାଇ । କାଇକେବଇଲେ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଏନ୍ତି ପିଲାଟକିମନର୍‌ ପାରା ରଇବା ଲକ୍‌ମନର୍‌ ପାଇସେ । ");
INSERT INTO dso_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, କେ ମିସା ଗଟେକ୍‌ ସାନ୍‌ ପିଲାର୍‌ ପାରା ନ ଅଇ, ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ନ ନାମତ୍‌, ସେମନ୍‌ କେବେ ମିସା ତାର୍‍ ରାଇଜେ କେଟି ନାପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ତାର୍‌ପଚେ ଜିସୁ ସାନ୍‌ ସାନ୍‌ ପିଲାଟକିମନ୍‌କେ ଉଁଚାରି ତାକର୍‌ ମୁଣ୍ଡେ ଚିଇକରି ଆସିର୍‌ବାଦ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ତେଇଅନି ବାରଇ ଜିବାବେଲେ ବାଟେ ଗଟେକ୍‌ ଲକ୍‌ ପାଲାଇ ଆସି ତାର୍‌ ଲଗେ କେଟ୍‌ଲା ଆରି ତାର୍‌ ମୁଆଟେ ମାଣ୍ଡିକୁଟା ଦେଇ ପାଚାର୍‌ଲା, “ଏ ନିମାନ୍‌ ଗୁରୁ, ନ ସାର୍‌ବା ଜିବନ୍‌ ମିଲାଇବାକେ ଆଲେ ମୁଇ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ମକେ କାଇକେ ନିମାନ୍‌ ଲକ୍‌ ବଲି କଇଲୁସ୍‌ନି ? କାଇକେବଇଲେ ପର୍‌ମେସର୍‌କେ ଚାଡିକରି ଆରି ବିନ୍‌ଟା କେ ମିସା ନିମାନ୍‌ ଲକ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ଆରି ତୁଇ ନିଅମ୍‍ତା ଜାନିଆଚୁସ୍‌, ମାର୍‌ବାର୍‌ ନାଇ, ପାଦ୍‌ରାପାଦ୍‌ରି କାମ୍‌ କର୍‌ବାର୍‌ ନାଇ, ଚର୍‌ କାମ୍‌ କର୍‌ବାର୍‌ ନାଇ, ମିଚ୍‌ ସାକି ଦେବାର୍‌ ନାଇ, ଆୟା ବାବାକେ ସନ୍‌ମାନ୍‌ ଦିଆସ୍‌ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ସେ ଲକ୍‌ ଜିସୁକେ କଇଲା, “ଏ ଗୁରୁ, ମୁଇତା ଏସବୁ ଆଦେସ୍‌ ସାନ୍‌ ବେଲେ ଅନି ମାନ୍‌ଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ଜିସୁ ତାକେ ନିକକରି ଦେକ୍‌ଲା ଆରି ତାକେ ଆଲାଦ୍‌ କରି କଇଲା, “ତୁଇ ଏବେ ମିସା ଗଟେକ୍‌ ବିସଇତେଇ ଉନା ଆଚୁସ୍‌ । ତୁଇ ଜାଇ ତର୍‌ ଦନ୍‌ସଁପତି ବିକି, ସେ ଡାବୁ ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ବାଟାକରି ଦେସ୍‌, ତୁଇ ସର୍‌ଗେ ଦନ୍‌ ପାଇସୁ । ଏନ୍ତିକରି ମର୍‌ ପଚେ ପଚେ ଆଉ ।” ବଲିକରି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ଜିସୁ କଇଲା ଏ କାତା ସୁନିକରି ସେ ଲକ୍‌ ମୁ ସୁକାଇ କରି, ଗରେ ଉଟିଗାଲା । କାଇକେବଇଲେ ସେଲକ୍‌ ବେସି ସାଉକାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ଜିସୁ ଚାରିବେଡ୍‌ତି ଦେକିକରି ସିସ୍‌ମନ୍‌କେ କଇଲା, “ସାଉକାର୍‌ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ରାଇଜେ ଜିବାଟା ବେସି କସ୍‌ଟ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଜିସୁର୍‌ କାତା ସୁନିକରି ସିସ୍‌ମନ୍‌ କାବା ଅଇଗାଲାଇ । ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ ଆରିତରେକ୍‌ କଇଲା, “ଏ ମର୍‌ ପିଲାମନ୍‌ ପର୍‌ମେସରର୍‌ ରାଇଜେ ଜିବାଟା ଲକ୍‌ମନ୍‌କେ କେଡେକ୍‍ କସ୍‌ଟ ! ");
INSERT INTO dso_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ଜେନ୍ତି ଗଟେକ୍‌ ବଡ୍‌ ଜଁତ୍‌ ସୁଜି ବାଟେ ଚିଙ୍ଗ୍‌ଲି ଜିବାକେ କସ୍‌ଟ, ସାଉକାର୍‌ ଲକ୍‌ ପର୍‌ମେସରର୍‌ ରାଇଜେ କେଟ୍‌ବାଟା ତାର୍‌ତେଇଅନି ଅଦିକ୍‌ କସ୍‌ଟ ।” ");
INSERT INTO dso_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ସିସ୍‌ମନ୍‌ ଆରିତରେକ୍‌ ବେସି କାବା ଅଇଗାଲାଇ ଆରି ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କାତା ଅଇଲାଇ, “ଏନ୍ତି ବଇଲେ କେ ତେବେ ରକିଆ ପାଇସି ?” ");
INSERT INTO dso_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ଜିସୁ ସେମନ୍‌କେ ଦେକିକରି କଇଲା, “ଏ ବିସଇ ଲକ୍‌ମନର୍‌ ଟାନେ ଅଇନାପାରେ, ମାତର୍‌ ପର୍‌ମେସରର୍‌ ଟାନେ ସବୁଟା ଅଇପାର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ପିତର୍‌ ଜିସୁକେ କଇଲା, “ଦେକା ଆମେ ଆମର୍‌ ସବୁ ଚାଡିଦେଇ ତମର୍‌ ସଙ୍ଗ୍‍ ଆଇଲୁଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ଜେ ମର୍‌ ସଙ୍ଗ୍‍ ଆଇବାକେ ଆରି ପର୍‌ମେସରର୍‌ ନିମାନ୍‌ କାତା ଜାନାଇବାକେ ଗର୍‌ ଦୁଆର୍‌, ବାଇ ବଇନି, ମା ବାବା, ପିଲାଟକି ଆରି ଜମିବାଡି ଚାଡିକରି ଆଚେ, ");
INSERT INTO dso_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ସେ ସତ୍‌ସେ, ନିଜର୍‌ ଚାଡିରଇଲା ସବୁ ବିସଇତେଇଅନି ସଏ ବାଗ୍‌ ଅଦିକ୍‌ ଏ ଜୁଗେ ପାଇସି । ଗର୍‌ ଦୁଆର୍‌, ବାଇ ବଇନି, ମାଆ ବାବା, ପିଲାଟକି ଆରି ଜମିବାଡି ଏ ସବୁ ଦିନ୍‌ସୁ ଅଦିକ୍‌ ପାଇସି ଆରି ତାର୍‌ ସଙ୍ଗ୍‍ ଗେଞ୍ଜ୍‌ନା ମିସା ପାଇସି । ମାତର୍‌ ଆଇବା ଜୁଗେ ପର୍‌ମେସରର୍‌ ରାଇଜେ, ସେ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇସି । ");
INSERT INTO dso_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ମାତର୍‌ ଜନ୍‍ ଲକ୍‌ମନ୍‌ ଆଗ୍‌ତୁ ଅଇତେରଇବାଇ, ସେମନ୍‌ ପଚେ ରଇବାଇ । ଆରି କେ କେ ପଚେ ରଇବାଇ, ସେମନ୍‌ ଆଗ୍‌ତୁ ରଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ସେମନ୍‌ ଜିରୁସାଲମେ ଗାଲାବେଲେ, ଜିସୁ ସେମନର୍‌ ଆଗ୍‌ତୁ ଆଗ୍‌ତୁ ଜାଇତେ ରଇଲା । ସେବେଲା ସିସ୍‌ମନ୍‌ କାବାଅଇଜାଇତେ ରଇଲାଇ । ଆରି ଜିସୁର୍‌ ପଚେ ପଚେ ଜିବା ଲକ୍‌ମନ୍‌ ସବୁ ସେ ଜିରୁସାଲେମେ ଗାଲାନି ବଲି ଡରିଜାଇତେ ରଇଲାଇ । ଜିସୁ ତାର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ବିନେ ଡାକିନେଇକରି ନିଜ୍‌କେ କାଇକାଇଟା ଅଇସି, ସେ ବିସଇ କଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ସୁନା ଆମେ ଜିରୁସାଲମେ ଗାଲୁନି । ତେଇ ପର୍‌ମେସରର୍‌ଟାନେଅନି ଆସିରଇବା ନର୍‌ପିଲା, ମକେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା କରି ମୁକିଅ ପୁଜାରିମନ୍‍ ଆରି ନିୟମ୍‌ ସିକାଇ ଦେବା ଲକ୍‌ମନ୍‍କେ ସର୍‌ପି ଦେବାଇ । ସେମନ୍‌ ମକେ କିଜାଇକରି ବିଚାର୍‌ କରି ‘ଆକେ ମରାଇବାର୍‌ ଆଚେ ।’ ବଲି ରମିୟ ଲକ୍‍ମନ୍‍କେ ସର୍‌ପି ଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ସେମନ୍‌ ମକେ ଟାପ୍‌ରା କର୍‌ବାଇ, ମର୍‌ ଉପ୍‌ରେ ତୁକ୍‌ବାଇ । ମକେ କର୍‌ଡା ସଙ୍ଗ୍‌ ମାର୍‌ବାଇ, ଆରି ସାରାସାରି ମରାଇବାଇ । ମାତର୍‌ ମରିକରି ତିନ୍‌ଦିନ୍‌ ଗାଲାପଚେ, ମୁଇ ଆରି ତରେକ୍‌ ମଲାଟାନେଅନି ଉଟ୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ଜେବଦି ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକର୍‌ ପିଲାମନ୍‌ ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌ ଜିସୁର୍‌ତେଇ ଆସି ତାକେ କଇଲାଇ, “ଏ ଗୁରୁ, ଆମେ ତର୍‌ତେଇ ଜାଇଟା ମାଙ୍ଗ୍‌ବୁ, ତୁଇ ସେଟା କର୍‌ ବଲି ଆମେ ମନ୍‍ କଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ଜିସୁ ପାଚାର୍‌ଲା, “ମୁଇ ତମର୍‌ ପାଇ କାଇଟା କର୍‌ବି ବଲି ମନ୍‍ କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ସେମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ତୁଇ ତର୍‌ ଡାକ୍‌ପୁଟା ପାଇବା ବସ୍‍ବା ଜାଗାଇ ବସ୍‌ଲା ବେଲେ ଆମର୍‌ ଦୁଇଲକର୍‌ ବିତ୍‌ରେ ଅନି ଗଟେକ୍‌ ଲକ୍‌କେ ତର୍‌ ଉଜା ବାଟେ ଆରି ଗଟେକ୍‌ ଲକ୍‌କେ ଡେବ୍‌ରି ବାଟେ ବସାଅ ବଲି ମନ୍‍ କଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ କାଇ ବିସଇ ମାଙ୍ଗ୍‌ଲାସ୍‌ନି ସେ ବିସଇ ନାଜାନାସ୍‌ । ମକେ ଜନ୍‌ ମୁତାଇ ଦୁକ୍‌କସ୍‌ଟ ପାଇବାକେ ଆଚେ, ସେ ମୁତାର୍‌ ଦୁକ୍‌କସ୍‌ଟ ପାଇପାରାସ୍‌ କି ? ଆରି ମୁଇ ଜନ୍‌ ଡୁବନ୍‌ ନେବାର୍‌ ଆଚେ, ସେ ଡୁବନ୍‌ ନେଇ ପାରାସ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ସେମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ଉଁ ଆମେ ପାର୍‌ବୁ ।” ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏଟା ସତ୍‌ସେ । ମୁଇ ଜନ୍‌ ମୁତାର୍‌ ଦୁକ୍‌କସ୍‌ଟ ପାଇବି ଆରି ଜନ୍‌ ଡୁବନ୍‌ ନେବି ତମେମିସା ସେ ମୁତାର୍‌ ଦୁକ୍‌ କସ୍‌ଟ ଆରି ଡୁବନ୍‌ ପାଇସା । ");
INSERT INTO dso_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ମାତର୍‌ ମର୍‌ ଉଜାବାଟେ କି ଡେବ୍‌ରିବାଟେ ବସ୍‌ବାକେ ଦେବାର୍‌, ମର୍‌ ଅଦିକାର୍‌ ନାଇ, ମାତର୍‌ ମର୍‌ ବାବା ବାଚ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌ କଇଲା କାତା ବିନ୍‌ ସିସ୍‌ମନ୍‌ ଜେଡେବେଲ୍‌ ସୁନ୍‌ଲାଇ, ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌କେ ବେସି ରିସା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ମାତର୍‌ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଗଟେକ୍‌ଟାନେ ଡାକି କରି ସେମନ୍‌କେ କଇଲା, “ଏ ଦୁନିଆର୍‌ ରାଜାମନ୍‌ ଆରି ନେତାମନ୍‌ ଲକ୍‌ମନ୍‌କେ ନିଜର୍‌ ଅଦିକାରେ ରକ୍‌ବାକେ ମନ୍‍ କର୍‌ବାଇ । ଆରି ସର୍‌କାର୍‌ ମିସା ତାକର୍‌ ତଲେ ରଇଲା ଲକ୍‌ମନ୍‌କେ ନିଜର୍‌ ଅଦିକାରେ ରକି ରଇବାକେ ମନ୍‍ କର୍‌ବାଇ । ଏ ବିସଇ ତମେ ଜାନିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ମାତର୍‌ ତମର୍‌ ବିତ୍‌ରେ ଏନ୍ତି ନ ରଇକରି ବିନ୍‌ବାବେ ରଇବାର୍‌ ଆଚେ । ତମର୍‌ ବିତ୍‌ରେଅନି କେ ବଡ୍‌ ଲକ୍‌ ପାରା ଦେକାଇଅଇବାକେ ମନ୍‍ କଲାନି ବଇଲେ, ସେ ତମର୍‌ ସବୁ ଲକର୍‌ ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ପାରା ରଅ । ");
INSERT INTO dso_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ଜଦି କେ ତମର୍‌ ବିତ୍‌ରେ ଅନି ପର୍‌ମେସରର୍‌ ମୁଆଟେ ମୁକିଅ ଲକ୍‌ ଅଇବାକେ ମନ୍‍ କଲାନି ବଇଲେ, ସେ ଗଟେକ୍‌ ଗେନ୍‌ଲା ଗତିଦାଙ୍ଗ୍‌ଡା ପାରା ସେବା କର । ");
INSERT INTO dso_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","କାଇକେ ବଇଲେ ପର୍‌ମେସର୍‌ଟାନେଅନି ଆସିରଇବା ନର୍‌ପିଲା ମୁଇ, ବିନ୍‌ ଲକ୍‌ମନର୍‌ଟାନେଅନି ମକେ ସେବା ମିଲ ବଲି ଆସି ନାଇ, ମାତର୍‌ ସେବା କର୍‌ବାକେ ଆସି ଆଚି । ଆରି ମୁଇ ଜିବନ୍‌ ଦେବାର୍‍ ଲାଗି, ବେସି ଲକ୍‌ ଦସି ବଲି ଏଜାଇ ନ ଅଇ, ପାପେଅନି ରକିଆ ପାଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ତାର୍‌ପଚେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜିରିଅ ନାଉଁର୍‌ ଗଡେ କେଟ୍‌ଲାଇ । ସେ ଗଡ୍‌ ଚାଡିକରି ଗାଲାବେଲେ, ତିମାୟ ନାଉଁର୍‍ ଲକର୍‌ ପିଲା ବାର୍‌ତିମୟ ବଲି ଗଟେକ୍‌ କାଣା ଲକ୍‌ ବାଟ୍‍ପାଲି ବସି ବିକ୍‌ ମାଙ୍ଗ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ନାଜରିତର୍‌ ଜିସୁ ଏବାଟେ ଆଇଲାନି ବଲି ସୁନି, ସେ ବେସି ଆଉଲି ଅଇକରି କଇଲା, “ଏ ଦାଉଦର୍‌ ପଅ ଜିସୁ, ମକେ ଦୟାକରା !” ");
INSERT INTO dso_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ବେସି ଲକ୍‌ମନ୍‌ ତାକେ ଚିମ୍‌ରାଇଅଇ ରଇବାକେ କଇଲାଇ, ମାତର୍‌ ସେ କାଣାଲକ୍‌ ଅଦିକ୍‌ ଅଦିକ୍‌ ଆଉଲିଅଇକରି କଇଲା, “ଏ ଦାଉଦର୍‌ ପଅ ! ମକେ ଦୟା କରା ।” ");
INSERT INTO dso_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ଜିସୁ ତେବିକରି କଇଲା, “ତାକେ ମର୍‌ ଲଗେ ଆଇବାକେ କୁଆ ।” ଲକ୍‌ମନ୍‌ କାଣାକେ ଡାକିକରି କଇଲାଇ, “ସାଆସ୍‌ ଦାରିକରି ଉଟ୍‌, ଜିସୁ ତକେ ଡାକ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","କାଣା ଲକ୍‌ ତାର୍‌ ଚାଦର୍‌ ତେଇ ପିଙ୍ଗିଦେଇକରି ଚିକାଲ୍‌ନା ଡେଗଇ ଉଟ୍‌ଲା ଆରି ଜିସୁର୍‌ ଲଗେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ଜିସୁ ତାକେ ପାଚାର୍‌ଲା “ମୁଇ ତର୍‌ପାଇ କାଇଟା କର୍‌ବି ବଲି ତୁଇ ମନ୍‍ କଲୁସ୍‌ନି ?” ସେ କଇଲା, “ଏ ଗୁରୁ, ମୁଇ ଜେନ୍ତିକି ଦେକି ପାର୍‌ବି ସେଟା ମନ୍‍ କଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ଜିସୁ ତାକେ କଇଲା, “ଜା, ତୁଇ ନିମାନ୍‌ ଅଇଜାଇ ଆଚୁସ୍‌ । କାଇକେବଇଲେ ତୁଇ ମକେ ବିସ୍‌ବାସ୍‌ କରି ଆଁକି ଦେକି ପାର୍‌ଲୁସ୍‌ନି ।” ସେଦାପ୍‌ରେସେ କାଣା ଆଁକି ଦେକି ବାଟେ ବାଟେ ଜିସୁର୍‌ ପଚେ ଜିବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜିରୁସାଲାମ୍‌ ଲଗାଲଗି ଅଇକରି ଜିତ୍‌ ନାଉଁର୍‌ ଡଙ୍ଗର୍‌ଲଗେ ରଇଲା ବେତ୍‌ପାଗି ଆରି ବେତ୍‌ନିଆ ନାଉଁର୍‌ ଗାଏଁ କେଟ୍‌ଲାଇ । ଜିସୁ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଦୁଇଲକ୍‌କେ ଡାକିକରି ସେମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ତମେ ଆମର୍‌ ମୁଆଟେ ରଇଲା ଗାଏଁ ଜା । ତମେ ଗାଉଁ ବିତ୍‌ରେ ଜିବାବେଲେ, ଗଟେକ୍‌ ଗଦ ପିଲା ବାନ୍ଦିରଇଲାଟା ଦେକ୍‌ସା । ସେ ଗଦ ପିଲାର୍‌ ଉପ୍‌ରେ ଏବେଜାକ କେ ମିସା ଚଗତ୍‌ ନାଇ । ତାକେ ମେଲିକରି ମର୍‌ଲଗେ ଦାରିଆସା । ");
INSERT INTO dso_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ଜଦି କେ ତମ୍‌କେ କାଇକେ ମେଲିକରି ନେଲାସ୍‌ନି ? ବଲି ପାଚାର୍‌ଲେ, ମାପ୍‌ରୁକେ ଦର୍‌କାର୍‌ ଆଚେ ଆରି ସେ ତମ୍‌କେ ଦାପ୍‌ରେସେ ବାଉଡାଇଦେଇସି । ବଲି ସେମନ୍‌ ଜିବା ଆଗ୍‌ତୁ ସେମନ୍‌କେ ପାଟାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ସେ ଗାଏଁ ଗାଲାଇ ଜେ ଗଟେକ୍‌ ଗରର୍‌ ଡାଣ୍ଡର୍‌ ଡିଆଗଡିଲଗେ ଗଦ ପିଲା ବାନ୍ଦିଅଇ ରଇଲାଟା ଦେକିକରି ତାକେ ଜାଇ ମେଲ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ତେଇ ଟିଆଅଇରଇଲା କେତେଲକ୍‌ମନ୍‌ କଇଲାଇ, “ତମେ କାଇଟା କଲାସ୍‌ନି ? ଆରି କାଇକେ ଏ ଗଦ ପିଲାକେ ମେଲ୍‌ଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ସେମନ୍‌କେ ଜିସୁ ଜେନ୍ତି କଇବାକେ କଇରଇଲା, ସେନ୍ତାରିସେ ସିସ୍‌ମନ୍‌ ଲକ୍‌ମନ୍‌କେ କଇଲାଇ । ତାର୍‌ପଚେ ସେ ଲକ୍‌ମନ୍‌ “ଗଦ ପିଲାକେ ନିଆ ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ସେମନ୍‌ ଗଦ ପିଲାକେ ଜିସୁର୍‌ ଲଗେ ଆନ୍‌ଲାଇ ଆରି ନିଜର୍‌ ନିଜର୍‌ ପଚିଆମନ୍‌ ଗଦ ପିଲାର୍‌ ପିଟି ଉପ୍‌ରେ ପାକାଇଲାଇ । ଆରି ଜିସୁ ଗଦ ଉପ୍‌ରେ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ବେସି ଲକ୍‌ମନ୍‌ ଜିସୁକେ ସନ୍‌ମାନ୍‌ ଦେବାକେ ନିଜର୍‌ ନିଜର୍‌ ପଚିଆମନ୍‌ ବାଟେ ଅଚାଇଦେଲାଇ ଆରି ବିନ୍‌ଲକ୍‌ମନ୍‌ ଗଚର୍‌ ଡାଲ୍‌ପତର୍‌ ଆରି କେନ୍ଦାମନ୍‌ କାଟିଆନିକରି ବାଟେ ଅଚାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ଜିସୁର୍‌ ଆଗ୍‌ତୁବାଟେ ଆରି ପଚ୍‌ବାଟେ ଜିବା ଲକ୍‌ମନ୍‌ ବେସି ଆଉଲିଅଇ ଏନ୍ତି କଇତେରଇଲାଇ, “ଅସାନା, ପର୍‌ମେସର୍‌କେ ଡାକ୍‌ପୁଟା କରା । ପର୍‌ମେସର୍‌ ତାକେ ଆସିର୍‌ବାଦ୍‌ କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ଆମର୍‌ ଆନିଦାଦି ଦାଉଦ୍‌ ରାଜାର୍‌ ରାଇଜ୍‌ ଆଇଲାନି, ତାର୍‌ ରାଇଜ୍‌ ପର୍‌ମେସର୍‌ ଆସିର୍‌ବାଦ୍‌ କର । ସର୍‌ଗେ ରଇବା ବାବା ପର୍‌ମେସର୍‌ ସନ୍‌ମାନ୍‌ ପାଇଲାପାରା କାତା କୁଆ” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ତାର୍‌ପଚେ ଜିସୁ ଜିରୁସାଲାମ୍‌ ଆସିକରି ପର୍‌ମେସରର୍‌ ଗର୍‌ ବିତ୍‌ରେ ପୁର୍‌ଲା । ଆରି ଚାରିବେଡ୍‌ତି ରଇଲା ସବୁ ଜିନିସ୍‌ମନ୍‌ ନିମାନ୍‌ କରି ଦେକ୍‌ଲା । ସେ ବେଲା ବେସି ଅଲ୍‌ସମ୍‌ ଅଇଗାଲାଜେ, ସେ ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ବେତ୍‌ନିଆ ନାଉଁର୍‌ ଗାଏଁ ଉଟିଜାଇକରି ତେଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ବେତ୍‌ନିଆଇଅନି ଜିରୁସାଲାମ୍‌ ଆଇବାବେଲେ ଜିସୁକେ ବେସି ବୁକ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ଜିସୁ ଦୁରିକେ ଅନି ବେସି ପତର୍‌ ରଇବା ଗଟେକ୍‌ ଡୁମ୍‌ରିଗଚ୍‌ ଦେକ୍‌ଲା । ଆରି ସେ ଗଚେ କେତେଟା ପଲ୍‌ ଦାରିରଇସି ବଲି ବାବିକରି ଗଚ୍‌ବୁନ୍ଦେ ଗାଲା । ମାତର୍‌ ଗଚ୍‌ଲଗେ ଜାଇକରି ଦେକ୍‌ଲାଜେ, ଗଟେକ୍‌ ମିସା ପଲ୍‌ ମିଲେ ନାଇ । କାଇକେବଇଲେ, ସେଟା ଡୁମ୍‌ରିପଲ୍‌ ଦାର୍‌ବା ଦିନ୍‌ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ଜିସୁ ଗଚ୍‌କେ କଇଲା, “ତୁଇ ଆରି କେବେ ମିସା ପଲ୍‌ ନ ଦାରୁସ୍‌ ।” ସେ କାତା ତାର୍‌ ସିସ୍‌ମନ୍‌ ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ତାର୍‌ପଚେ ଜିସୁ ଜିରୁସାଲାମର୍‌ ଗଡେ ଜାଇ, ମନ୍ଦିରେ ପୁରିକରି ତେଇ ଗେନାବିକା କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ଡାଣ୍ଡେ ବାର୍‌କରାଇଦେଲା । ବିନ୍‌ ଦେସର୍‌ ଡାବୁ ବାଦ୍‌ଲାଇବା ଲକ୍‌ମନର୍‌ ଟେବୁଲ୍‌ ଆରି ବିରୁ କର୍‌ବା ପରୁଆ ବିକ୍‌ବା ଲକ୍‌ମନର୍‌ ବସ୍‌ବା ପିଡା ପାସ୍‌ଲାଇ ପାକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ମନ୍ଦିରର୍‌ ଡାଣ୍ଡେ ଗେନା ବିକା କର୍‌ବାକେ ସେ କାକେମିସା ଦେଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ତାର୍‌ ପଚେ ସେ ଲକ୍‌ମନ୍‌କେ ସିକାଇଦେବାବେଲେ ଏନ୍ତି କଇଲା, “ମର୍‌ ମନ୍ଦିର୍‌ ସବୁ ଜାତିର୍‌ ଲକ୍‌ମନର୍‌ ପାର୍‌ତନା ଗର୍‌ ବଲି ନାମ୍‌ବାଇ ବଲି ପର୍‌ମେସରର୍‌ ବଇଟାନେ ଲେକା ଅଇଆଚେ, ମାତର୍‌ ତମେ ସେ ଗର୍‌ ଚର୍‌ମନର୍‌ ପାଆର୍‌ କରିଆଚାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ତେଇ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ନିୟମ୍‌ ସିକାଉମନ୍‌ ଏ କାତା ସୁନି, ଜିସୁକେ କେନ୍ତି ମରାଇବାର୍‌ ଅଇସି ବଲି ଚେସ୍‌ଟା କର୍‌ତେରଇଲାଇ । ମାତର୍‌ ଲକ୍‌ମନ୍‌କେ ଡର୍‌ତେରଇଲାଇ । କାଇକେବଇଲେ ଲକ୍‌ମନ୍‌ ସେ ସିକାଇଦେବା ବିସଇ କାବା ଅଇକରି ବେସି ମନ୍‍ କରି ସୁନ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ଆରି ସେଦିନର୍‌ ସଞ୍ଜ୍‌ ଅଇଲାକେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜିରୁସାଲାମ୍‌ ନଅରେଅନି ବାରଇକରି ଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନର୍‌ ସାକାଲେ ବାଉଡି ଆଇବାବେଲେ, ଏଦେ ଦେକା ! ସେ ଡୁମ୍‌ରିଗଚ୍‌ ବୁନ୍ଦେଅନି ଟିପେଜାକ ସୁକି ଜାଇରଇଲାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ସେବେଲା ଜିସୁ ଆଗ୍‌ତୁ କଇରଇଲା କାତା ପିତର୍‌ ଏତାଇକରି ତାକେ କଇଲା, “ଏ ଗୁରୁ ଜନ୍‌ ଡୁମ୍‌ରି ଗଚ୍‌କେ ତମେ ସାଇପ୍‌ ଦେଇରଇଲାସ୍‌, ସେ ଗଚ୍‌ ସୁକିଗାଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ପର୍‌ମେସରର୍‌ ତେଇ ବିସ୍‌ବାସ୍‌ କରିରୁଆ । ");
INSERT INTO dso_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ଜେ ନିଜର୍‌ ମନେ ଅଇସି କି ନଏ ବଲିକରି ଏନେ ତେନେ ନ ଅଇ, ସେ କଇବା କାତାଇ ବିସ୍‌ବାସ୍‌ କରି, ‘ଏ ଡଙ୍ଗର୍‌ ଉଲ୍‌ଟିକରି ସମ୍‌ଦୁରେ ଜାଇ ଅଦର୍‌ ।’ ବଲି କଇଲେ ସେଟା ସେନ୍ତାରି ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ସେଟାର୍‌ପାଇ ମୁଇ ତମ୍‌କେ କଇଲିନି, ତମେ ପାର୍‌ତନାଇ ଜନ୍‌ଟା ମିଲ୍‌ସି ବଲି ବିସ୍‌ବାସ୍‌ କରି ମାଙ୍ଗ୍‌ଲେ, ସେଟା ତମ୍‌କେ ମିଲ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ମାତର୍‌ ତମେ ପାର୍‌ତନା କର୍‌ବା ବେଲେ ତମର୍‌ ମନେ କାର୍‌ ବିରଦେ ମିସା କାଇ କାତା ରଇଲେ, ତାକେ କେମା ଦିଆସ୍‌ । ଏନ୍ତି କଲେ ତମର୍‌ ସରଗର୍‌ ବାବା ମିସା ତମ୍‌କେ ତମର୍‌ ପାପେଅନି କେମା ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ମାତର୍‌ ତମେ କେମା ନ କଲେ, ତମର୍‌ ସରଗର୍‌ ବାବା ମିସା ତମ୍‌କେ କେମା ନ ଦେଏ ।” ");
INSERT INTO dso_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ସେମନ୍‌ ଆରିତରେକ୍‌ ଜିରୁସାଲାମେ ଆଇଲାଇ । ଜିସୁ ମନ୍ଦିରର୍‍ ଦୁଆରେ ବୁଲ୍‌ବାବେଲେ ମୁକିଅ ପୁଜାରିମନ୍‌, ନିୟମ୍‌ ସିକାଉମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ତାର୍‌ ଲଗେ ଆସି ପାଚାର୍‌ଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ତୁଇ କାଇ ଅଦିକାରେ ଏ ସବୁ କାମ୍‌ମନ୍‌ କଲୁସ୍‌ନି ? ଆରି ଏ ସବୁ କାମ୍‌ମନ୍‌ କର୍‌ବାକେ ତକେ କେ ଅଦିକାର୍‌ ଦେଲାଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ମିସା ତମ୍‌କେ ଏକାଇ ଗଟେକ୍‌ ସେ ପର୍‌ସନ୍‌ ପାଚାର୍‌ବି, ସେ ପର୍‌ସନର୍‌ ଉତର୍‌ ତମେ କଇଲେ, ମୁଇ ଏ ସବୁ କାମ୍‌ କନ୍‌ ଅଦିକାରେ କଲିନି, ସେଟା ତମ୍‌କେ କଇବି । ");
INSERT INTO dso_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଜଅନ୍‌ ଡୁବନ୍‌ ଦେବା ଅଦିକାର୍‌ ସରଗର୍‌ ପର୍‌ମେସରର୍‌ଟାନେଅନି ଆସିରଇଲା କି ଲକ୍‌ମନର୍‌ ଟାନେଅନି ଆସିରଇଲା ? ଏଟା ମକେ କୁଆ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ତେଇ ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ଆମେ ଜଦି ସରଗର୍‌ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ବଲି କଇବୁ ବଇଲେ, ସେନ୍ତାର୍‍ ଆଲେ ତମେ ଜଅନ୍‌ ଜନ୍‌ଟା କଇଲା ସେଟା କାଇକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ ? ବଲିକରି ଜିସୁ ଆମ୍‌କେ କଇସି । ");
INSERT INTO dso_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ମାତର୍‌ ଲକ୍‌ମନର୍‌ଟାନେଅନି ବଲି କଇବାକେ ଆମ୍‌କେ ଡର୍‌ ଲାଗ୍‌ଲାନି । କାଇକେ ବଇଲେ ଜଅନ୍‌ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ବଲି ସେମନ୍‌ ସବୁଲକ୍‌ ବିସ୍‌ବାସ୍‌ କଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ସେଟାର୍‌ପାଇ ସେମନ୍‌ ଆମେ ନାଜାନୁ । ବଲି ଜିସୁକେ କଇଲାଇ । ତାର୍‌ପଚେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏନ୍ତି ବଇଲେ ମୁଇ ମିସା କନ୍‌ ଅଦିକାରେ ଏସବୁ କାମ୍‌ କଲିନି, ସେଟା ତମ୍‌କେ ନ କଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ତାର୍‌ପଚେ ଜିସୁ ଲକ୍‌ମନ୍‌କେ ବୁଜାଇବାକେ କେତେଟା କାତାନି କଇବାର୍‌ ଦାର୍‌ଲା । ପର୍‌ତୁମ୍‌ କାତାନି ଅଇଲାନି, ଗଟେକ୍‌ ଲକ୍‌ ଗଟେକ୍‌ ଅଙ୍ଗୁର୍‌ବାଡ୍‌ ତିଆର୍‌କରି, ତାର୍‌ ଚାରିବେଡ୍‌ତି ବାଡ୍‌ ବୁନ୍‌ଲା, ଆରି ଅଙ୍ଗୁର୍‌ ପିଲ୍‌ବାକେ ଗଟେକ୍‌ କୁଣ୍ଡ୍‌ ତିଆର୍‌କଲା । ବାଡ୍‌ ଜାଗ୍‌ବାକେ ଗଟେକ୍‌ ଚାଙ୍ଗ୍‌ ତିଆର୍‌କଲା । ଚାସ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ବାଡ୍‌ ଆଦିବାଗ୍‌ କର୍‌ବାକେ ଦେଇକରି, ସେ ଗଟେକ୍‌ ବିନ୍‌ ଦେସେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ତାର୍‌ପଚେ ଅଙ୍ଗୁର୍‌ ତଲ୍‌ବା ବେଲା ଆଇଲାକେ, ସାଉକାର୍‌ ତାର୍‌ ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଅଙ୍ଗୁର୍‌ପଲର୍‌ ବାଗ୍‌ ବାଟା ପାଇବାକେ ଚାସିମନର୍‌ଲଗେ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ମାତର୍‌ ଚାସି ଲକ୍‌ମନ୍‌, ସାଉକାର୍‌ ପାଟାଇଲା ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଦାରିକରି ମାରିପାକାଇଲାଇ ଆରି କାଇଟା ନ ଦେଇ ଚୁଚା ଆତେ ପାଟାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ସାଉକାର୍‌ ତାର୍‌ ଆରିଗଟେକ୍‌ ଗତି ଦାଙ୍ଗ୍‌ଡାକେ ଚାସିମନର୍‌ ଲଗେ ପାଟାଇଲା । ଚାସି ଲକ୍‌ମନ୍‌ ସେ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ମିସା ମୁଣ୍ଡ୍‌ ପୁଟ୍‌ତେ ମାର୍‌ଲାଇ ଆରି ଇଜତ୍‌ ଜିକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ସାଉକାର୍‌ ଆରି ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ପାଟାଇଲା ଜେ, ଚାସିଲକ୍‌ମନ୍‌ ତାକେ ମର୍‌ତେ ମାରିଦେଲାଇ । ତାର୍‌ପଚେ ସାଉକାର୍‌ ଆରି ଗାଦି ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ପାଟାଇଲା ଜେ କେତେଟା ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ମାର୍‍ଲାଇ ଆରି କେତେଟାକେ ମର୍‌ତେ ମାରିପାକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ଏବେ ସାଉକାରର୍‌ ଲଗେ ଗଟେକ୍‌ ଲକ୍‌ସେ ରଇଲା, ତାର୍‌ ନିଜର୍‌ ଆଲାଦର୍‌ ପିଲା । ମର୍‌ ପିଲାକେ ଚାସିଲକ୍‌ମନ୍‌ ନାମ୍‌ବାଇ ଆକା ଆରି ମର୍‌ ବାଗ୍‌ ପାଟାଇଦେବାଇ । ବଲି ବାବିକରି ସେ ସାରାସାରି ତାର୍‌ ପିଲାକେ ଚାସିମନର୍‌ ଲଗେ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ମାତର୍‌ ଚାସିମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କାତା ଅଇଲାଇ, “ଏ ଲକ୍‌ ତା ଆମର୍‌ ସାଉକାରର୍‌ ଗଟେକ୍‌ ବଲି ପିଲା, ଆସା ଆମେ ଆକେ ମର୍‌ତେ ମାର୍‌ଲେ ଏ ବାଡ୍‌ ଆମର୍‌ ଅଇଜାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ଆରି ଚାସିମନ୍‌ ସାଉକାରର୍‌ ପିଲାକେ ଦାରିକରି ମର୍‌ତେ ମାରି ଅଙ୍ଗୁର୍‌ ବାଡର୍‌ ସେପାଟେ ପିଙ୍ଗିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ଏ କାତାନି କଇସାରାଇଲା ପଚେ, ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ଏନ୍ତି ବଇଲେ ଅଙ୍ଗୁର୍‌ ବାଡର୍‌ ସାଉକାର୍‌ କାଇଟା କର୍‌ସି ? ସେ ଆସିକରି ଚାସିମନ୍‌କେ ମର୍‌ତେ ମାର୍‌ସି । ଆରି ଅଙ୍ଗୁର୍‌ ବାଡ୍‌ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ଆଦିବାଗ୍‌ କର୍‌ବାକେ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“ଗର୍‌ ବାନ୍ଦ୍‌ବା ଲକ୍‌ମନ୍‌ ଜନ୍‌ ପାକ୍‌ନା ନଏଁ ବଲି ଚାଡ୍‌ଲାଇ, ସେ ପାକ୍‌ନା ମୁକିଆ ପାକ୍‌ନା ଅଇଲା ବଲିକରି ତମେ ପର୍‌ମେସରର୍‌ ବଇତେଇ ପଡାସ୍‌ ନାଇ କି ?” ");
INSERT INTO dso_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ଏ ବିସଇ ମାପ୍‌ରୁ କରିଆଚେ, ଏଟା ଆମର୍‌ ପାଇ କାବାଅଇଜିବା ବିସଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ତେଇ ଜିଉଦି ଲକର୍‍ ମୁକିଅ ପୁଜାରିମନ୍‌ ଜିସୁକେ ବାନ୍ଦିନେବାକେ ବାଟ୍‌ କଜ୍‌ଲାଇ । କାଇକେବଇଲେ ଜିସୁ ଆମର୍‌ ବିରଦେ ଏ କାତାନି କଇଲାଇନି ବଲିକରି ସେମନ୍‌ ଜାନିରଇଲାଇ । ମାତର୍‌ ଲକ୍‌ମନ୍‌ ଆମ୍‌କେ କାଇ କାଇଟା କର୍‌ବାଇ। ବଲିକରି ଡରି, ତାକେ ଚାଡିକରି ଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ତାର୍‌ପଚେ ଜିସୁକେ ତାର୍‌ କାତାଇ ବୁଲ୍‌ ଦାର୍‌ବାକେ ଜିଉଦି ନେତାମନ୍‌ କେତେଟା ପାରୁସି ଦଲର୍‌ ଲକ୍‌ମନ୍‌କେ ଆରି ଏରଦ୍‌ ରାଜାର୍‌ କେତେଟା ଲକ୍‌ମନ୍‌କେ ତାର୍‌ ଲଗେ ପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ସେମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସିକରି, “ଏ ଗୁରୁ ତମେ ସତ୍‌ କାତା କଇଲାସ୍‌ନି ଆରି କାକେ ମିସା ନ ଡରାସ୍‌, ସବୁ ଲକ୍‌ମନ୍‌କେ ସମାନ୍‌ ଇସାବେ ଦେକ୍‌ଲାସ୍‌ନି ବଲି ଆମେ ଜାନିଆଚୁ । କାଇକେବଇଲେ ତମେ ଲକ୍‌ମନର୍‌ ଇସାବେ ନାଇ, ମାତର୍‌ ସତ୍‌ ବାବେ ସିକାଇଲାସ୍‌ନି । ଏବେ ଆମ୍‌କେ କୁଆ, ରମିଅ ରାଜାକେ ସିସ୍‌ତୁ ଦେବାଟା ନିୟମ୍‌ କି ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","“ଆମେ ସିସ୍‌ତୁ ବାନ୍ଦ୍‌ବୁ କି ନାଇ ?” ଜିସୁ ସେମନର୍‌ ମନ୍‌ବିତ୍‌ରର୍‌ କୁଟ୍‌ କାତା ବୁଜିକରି ସେମନ୍‌କେ କଇଲା, “କାଇକେ ତମେ ମକେ ପାନ୍ଦେ ପାକାଇବାକେ ଚେସ୍‌ଟା କଲାସ୍‌ନି ? ରମିୟ ସର୍‌କାରର୍‌ ଗଟେକ୍‌ ଅଦ୍‌ଲି ଡାବୁ ମର୍‌ ଲଗେ ଆନା, ମୁଇ ସେଟା ଦେକ୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ସେମନ୍‌ ଗଟେକ୍‌ ଅଦ୍‌ଲି ଡାବୁ ଆନ୍‌ଲାକେ ଜିସୁ ପାଚାର୍‌ଲା, “ଏ ଡାବୁ ଉପ୍‌ରେ କାର୍‌ ମୁର୍‌ତି ଆରି ନାଉଁ ଲେକା ଅଇଆଚେ ?” ସେମନ୍‌ କଇଲାଇ, “ରମିୟ ରାଜାର୍‌ ମୁର୍‌ତି ଆରି ତାର୍‌ ନାଉଁ ଲେକା ଅଇଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ଜିସୁ କଇଲା, “ଏନ୍ତି ବଇଲେ ଜନ୍‌ଟା ରମିୟ ରାଜାର୍‌, ସେଟା ରମିୟ ରାଜାକେ ଆରି ଜନ୍‌ଟା ପର୍‌ମେସରର୍‌, ସେଟା ପର୍‌ମେସର୍‌କେ ଦିଆସ୍‌ ।” ଏ କାତା ସୁନିକରି ସେମନ୍‌ କାବା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ତାର୍‌ପଚେ ମଲାଟାନେଅନି ଉଟ୍‌ବା ବିସଇ, ବିସ୍‌ବାସ୍‌ ନ କର୍‌ବା ସାଦୁକି ଦଲର୍‌ ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସିକରି ଏ ପର୍‌ସନ୍‌ ପାଚାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ଏ ଗୁରୁ, ଜଦି ଗଟେକ୍‌ ଲକ୍‌ ବିବାଅଇକରି ପିଲାଜିଲା ନ ଅଇତେ ମରିଜାଇସି ବଇଲେ, ତାର୍‌ ବାଇ ସେ ମାଇଜିକେ ବିବାଅଇ ପିଲାଜିଲା ପାଇବାର୍‌ ଆଚେ । ଏନ୍ତି କଲେ ମରିଗାଲା ବାଇର୍‌ ପାଇ ସେ ପିଲାଟକିମନ୍‌ ତାର୍‌ ନାଉଁ ଦାର୍‌ବାଇ ବଲି ମସା ଆମର୍‌ପାଇ ନିଅମ୍‌ ଲେକିଦେଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ଏନ୍ତି ସାତ୍‌ ବାଇ ରଇଲାଇ, ସବୁର୍‌ଟାନେଅନି ବଡ୍‌ ବାଇ ବିବା ଅଇଲା । ମାତର୍‌ ପିଲାଟକି ନ ଅଇତେ ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ସେଟାର୍‌ପାଇ ତାର୍‌ ପଚର୍‌ ବାଇ ସେ ମାଇଜିକେ ସଙ୍ଗଇଲା । ସେ ମିସା ପିଲାଟକି ନଇତେ ମରିଗାଲା । ତାର୍‌ପଚର୍‌ ବାଇ ମିସା ବିବା ଅଇ ପିଲାଟକି ନଇତେ ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ସାତ୍‌ବାଇ ଜାକ ସେ ମାଇଜିକେ ଗଟେକ୍‌ ଲକର୍‌ ପଚେ ଗଟେକ୍‌ ଲକ୍‌ ବିବା ଅଇରଇଲାଇ । ସାରାସାରି ସାତ୍‌ ବାଇ ଜାକ ପିଲାଟକି ନ ଅଇତେ ମରିଗାଲାଇ । ତାର୍‌ପଚେ ସେ ମାଇଜି ମିସା ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ସାତ୍‌ବାଇ ଜାକ ତାକେ ବିବା ଅଇରଇଲାଇ, ତେବେ ମରିକରି ଉଟ୍‌ଲା ବେଲେ, ସେ କାର୍‌ ମାଇଜି ଅଇସି ? ସାତ୍‌ବାଇ ଜାକ ତାକେ ବିବା ଅଇରଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଦରମ୍‌ ସାସ୍‌ତରେ ପର୍‌ମେସରର୍‌ କାଇଟା ଲେକା ଅଇଲା ଆଚେ ସେ ବିସଇ, ଆରି ତାର୍‌ ବପୁର୍‌ ବିସଇ ତମେ ନାଜାନି କରି ବୁଲ୍‌ ବାବ୍‌ଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ଜେଡେବେଲେ ଲକ୍‌ମନ୍‌ ମରିକରି ଆରି ତରେକ୍‌ ଉଟ୍‌ବାଇ, ସେବେଲେ ମୁନୁସ୍‌ପିଲାମନ୍‌ ବିବା ନ ଅଅତ୍‌, କି ମାଇଜି ଟକିମନ୍‌କେ ବିବା ଅଇବାକେ ନ ଦେଅତ୍‌ । ସେମନ୍‌ ସବୁଲକ୍‌ ସରଗର୍‌ ଦୁତ୍‌ପାରା ଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ମଲାଟାନେଅନି ଉଟ୍‌ବା ବିସଇ ମସା ଲେକ୍‌ଲା ବଇଟାନେ ପଡାସ୍‌ ନାଇ କି ? ପର୍‌ମେସର୍‌ ଜଇଲାଗ୍‌ବା ବୁଟାଇ ମସାକେ ଦେକାଇରଇଲାଜେ, ‘ମୁଇ ଅବ୍‌ରାଆମର୍‍, ଇସାକର୍‌ ଆରି ଜାକୁବର୍‌ ପର୍‌ମେସର୍‌ ।’ ବଲି କଇଲାଟା, ଲେକା ଅଇଲାଆଚେ । ମାତର୍‌ ଏ ଲକ୍‌ମନ୍‌ ସବୁ ମରିଗାଲାଇ ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ପର୍‌ମେସର୍‌ ମଲାଲକ୍‌ମନର୍‌ ମାପ୍‌ରୁ ନଏଁ । ସେ ଜିବନ୍‌ ରଇଲା ଲକ୍‌ମନର୍‌ ମାପ୍‌ରୁ । ଏ ବିସଇ ତମେ ବେସି ବୁଲ୍‌ ବୁଜ୍‌ଲାସ୍‌ନି ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ଜିସୁ ଆରି ସାଦୁକି ଦଲର୍‌ ଲକ୍‌ମନ୍‌ ଦଦା ପେଲା ଅଇବାବେଲେ ଗଟେକ୍‌ ନିୟମ୍‌ ସିକାଉ ତାର୍‌ ଲଗେ ଆଇଲା । ଜିସୁ ଲକ୍‌ମନର୍‌ ପର୍‌ସନର୍‌ ଉତର୍‌ ନିମାନ୍‌ସଙ୍ଗ୍‌ କଇବାଟା ସୁନିକରି, ତାକେ ପାଚାର୍‌ଲା, “କନ୍‌ ଆଦେସ୍‌ ସବୁର୍‌ଟାନେଅନି ଅଦିକ୍‌ ମୁକିଅ ?” ");
INSERT INTO dso_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ଜିସୁ କଇଲା, “ସବୁର୍‌ଟାନେଅନି ପର୍‌ତୁମର୍‌ ମୁକିଅ ଆଦେସ୍‌ ଅଇଲାନି, ସୁନା ଏ ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌ ମାପ୍‌ରୁ ଆମର୍‌ ପର୍‌ମେସର୍‌ ଗଟେକ୍‌ସେ ମାପ୍‌ରୁ । ");
INSERT INTO dso_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ତମେ ତମର୍‌ ପୁରାପୁରୁନ୍‌ ମନ୍‌ ସଙ୍ଗ୍‌, ପୁରାପୁରୁନ୍‌ ଆତ୍‌ମା ସଙ୍ଗ୍‌, ପୁରାପୁରୁନ୍‌ ଚିନ୍ତାର୍‌ ସଙ୍ଗ୍‌ ଆରି ପୁରାପୁରୁନ୍‌ ବପୁସଙ୍ଗ୍‌ ତାକେ ଆଲାଦ୍‌ କର୍‌ବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ଆରି ପଚର୍‌ ମୁକିଅ ଆଦେସ୍‌ ଅଇଲାନି, ତମେ ନିଜ୍‌କେ ଆଲାଦ୍‌ କଲାପାରା ପଡିସାର୍‌ ଲକ୍‌କେ ମିସା ଆଲାଦ୍‌ କରା । ଏ ଦୁଇଟା ଆଦେସ୍‌ ଚାଡିକରି ଆରି କାଇ ମିସା ମୁକିଅ ଆଦେସ୍‌ ନାଇ” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ଏ କାତା ସୁନି ସେ ଲକ୍‌ ଜିସୁକେ କଇଲା, “ଏ ଗୁରୁ, ପର୍‌ମେସର୍‌ ଗଟେକ୍‌ ସେ, ତାକେ ଚାଡିଦେଲେ ଆରି କେ ମିସା ନାଇ । ଏ କାତା ତମେ ଟିକ୍ ବାବେ କଇଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ପର୍‌ମେସର୍‌କେ ସବୁ ମନ୍‌ଦେଇକରି ସବୁ ଚିନ୍ତା ଦେଇକରି ଆରି ସବୁ ବପୁ ଦେଇ ଆଲାଦ୍‌ କର୍‌ବାର୍‌ ଆଚେ ଆରି ନିଜ୍‌କେ ଆଲାଦ୍‌ କଲା ପାରା ବିନ୍‌ ଲକ୍‌କେ ମିସା ଆଲାଦ୍‌ କର୍‌ବାର୍‌ଆଚେ ବଲିକରି ତମେ କଇଲା କାତା ଟିକ୍‌ ସେ । ଆମେ ପର୍‌ମେସର୍‌କେ ଜେତେକ୍‌ ଅମ୍‌ କଲେ ମିସା ଆରି ଜେତେକ୍‌ କାଇଟା ପୁଜ୍‌ଲେ ମିସା, ଏ ଦୁଇଟା ଆଦେସ୍‌ ବେସି ମୁକିଅ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ସେଲକ୍‌ ବେସି ବୁଦି ସଙ୍ଗ୍‍ ଉତର୍‌ ଦେଲା ଆଚେ ବଲି ଜିସୁ ଦେକି, ତାକେ କଇଲା, “ତୁଇ ପର୍‌ମେସରର୍‌ ରାଇଜେ ପୁର୍‌ବା ଲଗେସେ ଆଚୁସ୍‌ ।” ତାର୍‌ପଚେ ଆରି କେ ମିସା ଜିସୁକେ ପର୍‌ସନ୍‌ ପାଚାର୍‌ବାକେ ସାଆସ୍‌ କରି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ଜିସୁ ଜିଉଦିମନ୍‌ ରୁଣ୍ଡ୍‌ବା ଗରର୍‌ ଡାଣ୍ଡେ ସିକିଆ ଦେବାବେଲେ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ପର୍‌ମେସର୍‌ ବାଚିକରି ପାଟାଇଲା ରାଜା ଦାଉଦର୍‌ ନାତିତିତି ବଲିକରି ନିୟମ୍‌ ସିକାଇଦେବା ଲକ୍‌ମନ୍‌ କେନ୍ତି କଇଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ଦାଉଦ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ଅନି ଏନ୍ତି କଇଲା, ପର୍‌ମେସର୍‌ ମର୍‌ ମାପ୍‌ରୁକେ କଇଲା, “ମୁଇ ତର୍‌ ସତ୍‌ରୁମନ୍‌କେ ତର୍‌ ପାଦ୍‌ ତଲେ ନ ଆନ୍‌ବା ଜାକ ତୁଇ ମର୍‌ ଉଜାଆତ୍‌ବାଟେ ବସି ର ।” ");
INSERT INTO dso_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“ଜଦି ଦାଉଦ୍‌ ରାଜା ନିଜେ ମାପ୍‌ରୁବଲି କଇରଇଲା ବଇଲେ ପର୍‌ମେସର୍‌ ବାଚିକରି ପାଟାଇରଇବା ମସିଅ କେନ୍ତି ଦାଉଦର୍‌ ପିଲା ଅଇସି ?” ତେଇ ରଇଲା ବେସି ଲକ୍‌ମନ୍‌ ସାର୍‌ଦା ସଙ୍ଗ୍‌ ଏ କାତା ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ଜିସୁ ଆରି କେତେଟା ବିସଇ ସିକାଇଦେବା ବେଲେ କଇଲା, “ତମେ ନିୟମ୍‌ ସିକାଇଦେବା ଲକ୍‌ମନର୍‌ପାରା ଚଲାଚଲ୍‌ତି ନ ଅଇକରି ଜାଗ୍‌ରତ୍‌ ସଙ୍ଗ୍‌ ରୁଆ । ସେମନ୍‌ ସନ୍‌ମାନ୍‌ ପାଇବାକେ ବେସି ଡେଙ୍ଗ୍‌ ପଚିଆ ପିନ୍ଦିକରି ଏନେ ତେନେ ବୁଲ୍‌ବାଇ । ଆଟେ ବାଟେ ଲକ୍‌ମନର୍‌ଟାନେଅନି ଜୁଆର୍‌ ପାଇକରି ସନ୍‌ମାନ୍‌ ପାଇବାକେ ମନ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ମୁକିଅ ଜାଗାଇ, ବଜିଟାନର୍‌ ମୁକିଅ ଜାଗାଇ ବସ୍‌ବାକେ ମନ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ଆରି ସେମନ୍‌ ରାଣ୍ଡି ମାଇଜିମନ୍‌କେ ନାଡାଇକରି ସେମନର୍‌ ଦନ୍‌ସଁପତି ଜୁରି ନେବାଇ । ସେମନ୍‌ ନିମାନ୍‌ ଲକ୍‌ ବଲିକରି ଦେକାଇଅଇବାକେ ବେସି ପର୍‌ ପାର୍‌ତନା କର୍‌ବାଇ । ଏନ୍ତି ଲକ୍‌ମନ୍‌କେ ପର୍‌ମେସର୍‌ ବିନ୍‌ ଲକ୍‌ମନର୍‌ଟାନେଅନି ବେସି ବଡ୍‌ ଡଣ୍ଡ୍‌ ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ଜାଇକରି ଚାନ୍ଦାଦେବା ପେଡିଲଗେ ବସିକରି ଲକ୍‌ମନ୍‌ ପର୍‌ମେସର୍‌କେ କେନ୍ତି ଚାନ୍ଦା ଦେଲାଇନି ବଲି ଦେକ୍‌ତେରଇଲା । ସାଉକାର୍‌ ଲକ୍‌ମନ୍‌ ଲଚେକ୍‌ ଲଚେକ୍‌ ଡାବୁ ଦେବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ସାରାସାରି ଗଟେକ୍‌ ଗରିବ୍‌ ରାଣ୍ଡି ମାଇଜି ଦାନ୍‌ ଦେବା ପେଡିଲଗେ ଆସିକରି ଦୁଇଟା ସାନ୍‌ ତାମା କାସୁ ପୁରାଇଦେଲା । ସେ ଦୁଇଟା ଡାବୁର୍‌ ଦାମ୍‌ ଗଟେକ୍‌ ଟାଙ୍ଗାଇ ଅନି ମିସା ଉନା । ");
INSERT INTO dso_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ତାର୍‌ପଚେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଲଗେ ଡାକି କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ଏ ସବୁ ସାଉକାର୍‌ ଲକ୍‌ମନ୍‌ ଦେଲା ଡାବୁତେଇଅନି, ଏ ଅର୍‌କିତ୍‌ ରାଣ୍ଡି ମାଇଜି ଅଦିକ୍‌ ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","କାଇକେବଇଲେ ସବୁ ଲକ୍‌ମନ୍‌ ସେମନ୍‌କେ ଦର୍‌କାର୍‌ ଅଇକରି ଅଗଲ୍‌ଲା ଡାବୁ ଦେଲାଇଆଚତ୍‌ । ମାତର୍‌ ଏ ଗରିବ୍‌ ରାଣ୍ଡି ମାଇଜି, ସେ ବଁଚ୍‌ବାପାଇ ଜେତ୍‌କି ଡାବୁ ରଇଲା, ସେ ସବୁ ଦେଲାଆଚେ” ବଲିକରି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଜିସୁ, ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେଅନି ବାରଇକରି ଜିବାବେଲେ ତାର୍‌ ଗଟେକ୍‌ ସିସ୍‌ ତାକେ କଇଲା, “ଏ ଗୁରୁ ଏଦେ ଦେକା ! ବଡ୍‌ ବଡ୍‌ ପାକ୍‌ନାଇ ମନ୍ଦିର୍‌ କେତେକ୍‌ ସୁନ୍ଦର୍‌ ଅଇ ତିଆର୍‌ ଅଇଲାଆଚେ !” ");
INSERT INTO dso_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ଏ ବଡ୍‌ ବଡ୍‌ ପାକ୍‌ନାଇ ତିଆର୍‌ ଅଇଲା ପର୍‌ମେସରର୍‌ ଗର୍‌ ଦେକ୍‌ଲୁସ୍‌ନି ? ଏ ସବୁ ଗର୍‌ ନସ୍‌ଟ ଅଇଜାଇସି । ସବୁ ପାକ୍‌ନାମନ୍‌ ଡୁଲିକରି ମାଟିତେଇ ଏନେତେନେ ଅଇଜାଇସି, ଗଟେକ୍‌ ପାକ୍‌ନା ଆରି ଗଟେକ୍‌ ପାକ୍‌ନାର୍‌ ଉପ୍‌ରେ ନ ରଏ ।” ");
INSERT INTO dso_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ତାର୍‌ପଚେ ଜିସୁ ପର୍‌ମେସରର୍‌ ଗରର୍‌ ମୁଆଟେ ରଇଲା ଜିତ୍‌ ନାଉଁର୍‌ ଗଚ୍‌ମନ୍‌ ରଇବା ଡଙ୍ଗ୍‌ରେ ବସିରଇଲା । ସେବେଲା ପିତର୍‌, ଜାକୁବ୍‌, ଜଅନ୍‌ ଆରି ଆନ୍ଦ୍‌ରିୟ, କେ ନ ରଇଲାବେଲେ ତେଇ ଆସିକରି ତାକେ ପାଚାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ଏ ସବୁ ଗଟ୍‍ନା କେବେ ଅଇସି ଆରି ସବୁ ଅଇବା ଚିନ୍‌ମନ୍‌ କାଇଟା, ଆମ୍‌କେ କଇଦେ ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ଜାଗ୍‌ରତ୍‌ ଅଇକରି ରୁଆ, ତମ୍‌କେ କେ ମିସା ନ ନାଡାଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","କାଇକେବଇଲେ ବେସି ଲକ୍‌ମନ୍‌ ମର୍‌ ନାଉଁ ଦାରି, ସେମନ୍‌ କିରିସ୍‌ଟ ବଲି ବେସି ଲକ୍‌ମନ୍‌କେ ବୁଲ୍‌କାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ମାତର୍‌ ଜେଡେବେଲେ ତମେ ଜୁଇଦର୍‌ ବିସଇ ନଇଲେ ଜୁଇଦ୍‌ ଇତି ଅଇସି ନଇଲେ ସିତି ଅଇସି ବଲିକରି ଲକ୍‌ମନ୍‌ କଇବାଟା ସୁନ୍‌ଲେ, କିଲ୍‌ବିଲ୍‌ ନ ଉଆ । ଏ ସବୁ ଗଟ୍‍ନା ଅଇସି, ମାତର୍‌ ସେଦାପ୍‌ରେ ଆକା ଜୁଗ୍‌ ସେସ୍‌ ନଏଁ । ");
INSERT INTO dso_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","କାଇକେବଇଲେ, ଗଟେକ୍‌ ଦେସର୍‌ ଲକ୍‌ମନ୍‌ ଆରି ଗଟେକ୍‌ ଦେସର୍‌ ଲକ୍‌ମନର୍‍ ବିରଦେ ଜୁଇଦ୍‌ କର୍‌ବାଇ । ଗଟେକ୍‌ ରାଇଜ୍‌ ଆରିଗଟେକ୍‌ ରାଇଜର୍‌ ବିରଦେ ଉଟ୍‌ବାଇ । ବେସି ଜାଗାଇ ଦର୍‌ତନି ଚୁଲ୍‌ବୁଲ୍‌ସି, ଆରି ବେସି ଜାଗାଇ ମର୍‌ଡି ଅଇସି । ଏସବୁ ଗଟ୍‍ନା ଗଟେକ୍‌ ପିଲା ଜନମ୍‌ ଅଇବା ଆଗ୍‌ତୁ ଆଇବା ଦୁକାସୁକା ପାରା ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“ଏନ୍ତି ସବୁ ଅଇବା ବେଲା ତମେ ଜାଗ୍‌ରତ୍‌ ରୁଆ । ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ବାନ୍ଦିକରି ବିଚାର୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‍କେ ସର୍‌ପିଦେବାଇ । ସେମନ୍‌ ନିଆଇ କର୍‌ବା ଜାଗାଇ ତମ୍‌କେ ମାରିପାକାଇବାଇ । ତମେ ମର୍‌ ସିସ୍‌ ଅଇରଇବା ଲାଗି, ସାସନ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ଟାନେ ଆରି ରାଜାମନର୍‌ ମୁଆଟେ ଟିଆ କରାଇବାଇ । ତମେ ମର୍‌ଟାନେ ବିସ୍‌ବାସ୍‌ କଲା ବିସଇ ତେଇ ସାକି ଦେଇସା । ");
INSERT INTO dso_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ଏ ସବୁ ଗଟ୍‍ନା ଅଇଜିବା ଆଗ୍‌ତୁ, ସବୁ ଦେସର୍‌ ଲକ୍‌ମନର୍‌ ଲଗେ, ଏ ନିମାନ୍‌ କବର୍‌ କେଟ୍‌ବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ସେମନ୍‌ ତମ୍‌କେ ବନ୍ଦିକରି ବିଚାର୍‌ କର୍‌ବା ବେଲେ ତେଇ କାଇଟା କଇବୁ ବଲିକରି ଆଗ୍‌ତୁ ଚିନ୍ତା କରାନାଇ । ତମେ କାଇଟା କଇବାର୍‌ ଆଚେ, ସେ କାତା ପର୍‌ମେସର୍‌ ତମ୍‌କେ ସମାନ୍‌ ବେଲାଇ ଦେଇସି । କାଇକେବଇଲେ ସେ ବେଲାଇ ତମେ ନିଜେ ନ କୁଆସ୍‌ ମାତର୍‌ ସୁକଲ୍‌ଆତ୍‌ମା ତମର୍‌ଟାନେଅନି କାତା କଇସି । ");
INSERT INTO dso_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ବାଇ ବାଇକେ ମରାଇବାତେଇ ସର୍‌ପିଦେବାଇ ଆରି ବାବା ପିଲାକେ ମରାଇବାତେଇ ସର୍‌ପି ଦେବାଇ ଆରି ପିଲାଟକିମନ୍‌ ତାକର୍‌ ମାଆ ବାବା ବିରୁଦେ ଉଟିକରି ସେମନ୍‌କେ ମରାଇବାକେ ସର୍‌ପିଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ତମେ ମର ସିସ୍‌ ଅଇରଇଲାର୍‌ ଲାଗି ସବୁ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଗିନ୍‌ କର୍‌ବାଇ । ମାତର୍‌ ଜେ ସାରାସାରି ଜାକ ମୁର୍‌ଚି କରି ରଇସି, ସେ ରକିଆପାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ମାତର୍‌ ତମେ ଜେଡେବେଲା କେ ମନ୍‍ ନ କର୍‌ବାଟା ଆରି ନାସ୍‌ ଅଇବା ଦିନ୍‌ସୁ ଜନ୍‌ଟାକି ସୁକଲ୍‌ ଜାଗାଇ ସଙ୍ଗଇବାର୍‌ ନଏଁ, ସେ ଜାଗାଇ ସଙ୍ଗଇବାଟା ଦେକ୍‌ଲେ, ତମେ ସେ ଜାଗାଇଅନି ପାଲାଇବାର୍‌ ଆଚେ । ଏ ବିସଇ ପଡ୍‌ବା ଲକ୍‌ମନ୍‌, ତମେ ଏ କାତା ବୁଜା । ସେବେଲେ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଜିଉଦା ରାଇଜେ ରଇବାଇ, ସେମନ୍‌ ଡଙ୍ଗ୍‌ରେ ପାଲାଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ଜଦି କେ ଗରର୍‌ ଚାଉନି ଉପ୍‌ରେ ରଇସିବଇଲେ, ସେ ଗର୍‌ ବିତ୍‌ରେ ତାର୍‌ କାଇମିସା ଦିନ୍‌ସୁ ଆନ୍‌ବି ବଲିକରି ନ ଜାଅ । ");
INSERT INTO dso_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ଜଦି କେ ଚାସ୍‌ ରଇବା ପଦାଇ ରଇସି, ସେ ତାର୍‌ ଚାଦର୍‌ ଆନ୍‌ବାକେ ଗରେ ବାଉଡି ନ ଜାଅ । ");
INSERT INTO dso_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ଗାଗ୍‌ଡେ ରଇଲା ମାଇଜିମନର୍‌ପାଇ ଆରି ଦୁଦ୍‌ କୁଆଇବା ମାଇଜିମନର୍‌ ପାଇ ସେବେଲେ ପାଲାଇବାକେ ବେସି କସ୍‌ଟ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ଏ ସବୁ ଗଟ୍‍ନା ସିତ୍‌ ଦିନେ ନ ଅଇବାକେ ପାର୍‌ତନା କରା । ");
INSERT INTO dso_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","କାଇକେବଇଲେ ପର୍‌ମେସର୍‌ ଏ ଦୁନିଆ ତିଆର୍‌କଲା ଦିନେଅନି ଆଜିକେ ଜାକ ସେନ୍ତାରି ଦୁକ୍‌ କସ୍‌ଟ ଅଏନାଇ ଆରି ପଚେ କେବେମିସା ନ ଅଏ । ସେନ୍ତି ବେସି ଦୁକ୍‌ କସ୍‌ଟର୍‌ ଗଟ୍‍ନା ସେ ଦିନ୍‌ମନ୍‌କେ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ଜଦି ପର୍‌ମେସର୍‌ ଅପର୍‌ବଲ୍‌ ଦୁକର୍‌ ଦିନ୍‌ମନ୍‌ ଉନା ନ କରି ରଇଲେ, ତେବେ ଦୁନିଆର୍‌ କେ ମିସା ରକିଆ ନ ପାଇକରି ମରି ଜିବାର୍‌ ଅଇତା । ମାତର୍‌ ସେ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ବାଚିଆଚେ ସେ ଲକ୍‌ମନର୍‌ପାଇ ସେ ଦୁକର୍‌ ଦିନ୍‌ମନ୍‌ ଉନା କଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ସେବେଲେ କେ ଜଦି ତମ୍‌କେ ଇତି କିରିସ୍‌ଟ ଆଚେ । ନଇଲେ ତେଇ ସେ ଆଚେ । ବଲି କଇସି, ତାକେ ବିସ୍‌ବାସ୍‌ କରା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ସେଦିନ୍‌ମନ୍‌କେ ମୁଇଆକା କିରିସ୍‌ଟ । ବଲିକରି ମିଚ୍‌ କଇବା ବବିସତ୍‌ କଇବାଲକ୍‌, ବିନ୍‌ ବିନ୍‌ ରକାମର୍‌ ଚିନ୍‌ ଆରି କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ଦେକାଇବାଇ । ପର୍‌ମେସର୍‌ ବାଚ୍‌ଲା ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ମିସା ନାଡାଇବାକେ ଚେସ୍‌ଟା କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ସେଦିନ୍‌ମନ୍‌କେ କାଇ କାଇଟା ଅଇସି ସେ ବିସଇନେଇ ତମେ ଜାଗ୍‌ରତ୍‌ ଅଇ ରୁଆ । ସେଟାର୍‌ପାଇ, ଦେକା ସେ ବେଲା ନ ଆଇବା ଆଗ୍‌ତୁ ମୁଇ ତମ୍‌କେ ଜାନାଇଦେଲିନି । ");
INSERT INTO dso_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","ସେଦିନ୍‌ମନ୍‌କେ, ସେ ଦୁକର୍‌ ଗଟ୍‍ନା ଅଇଲାପଚେ ବେଲ୍‌ ଉଜଲ୍‌ ନ ଦେଇକରି ଆନ୍ଦାର୍‌ ଅଇଜାଇସି ଆରି ଜନ୍‌ ମିସା ଉଜଲ୍‌ ନ ଦେଏ । ");
INSERT INTO dso_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ତାରାମନ୍‌ ବାଦ୍‌ଲେଅନି ଅଦର୍‌ବାଇ ଆରି ବାଦ୍‌ଲେ ଉଜଲ୍‌ ରଇବାଟାମନ୍‌କେ ପର୍‌ମେସର୍‌ ଆଲାଇଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“ସେବେଲା ନର୍‌ପିଲା ମୁଇ, ବେସି ବପୁତେଇ ଆରି ଡାକ୍‌ପୁଟା ସଙ୍ଗ୍‌ ବାଦଲ୍‌ଟାନେ ଆଇବାଟା ଲକ୍‌ମନ୍‌ ଦେକ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ସେବେଲା ମର୍‌ ଦୁତ୍‌ମନ୍‌କେ ପାଟାଇକରି ଦୁନିଆ ସାର୍‌ଲାଅନି ଆରି ସରଗ୍‌ ଚିଡ୍‌ଲା ତେଇଅନି ପର୍‌ମେସର୍‌ ବାଚ୍‌ଲା ଲକ୍‌ମନ୍‌କେ ଟୁଲିଆଇବି ।” ");
INSERT INTO dso_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ଏବେ ଡୁମ୍‌ରି ଗଚର୍‌ ଉଦାଅରନ୍‌ ଅନି ଏ ବିସଇ ସିକା । ଜେଡେବେଲେ ତାର୍‌ କେନ୍ଦିଅନି ପତର୍‌ ପାଲୁଆନି କରି, କାଁଚାପତ୍‌ରିଆ ଡିସ୍‌ଲେ, କାରାଦିନ୍‌ କେଟ୍‌ଲା ବଲିକରି ତମ୍‌କେ କେ ନ କଇଲେମିସା ଜାନାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ସେନ୍ତିସେ ତମେ ଏ ସବୁ ଗଟ୍‍ନା ଦେକ୍‌ବାବେଲେ, ମୁଇ ଆଇବା ଦିନ୍‌ କେଟ୍‌ଲା, ବଲିକରି ଜାନ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ଏ ଗଟ୍‍ନା ନ ଅଇବାଜାକ, ଏବେ ରଇଲା ଲକ୍‌ମନ୍‌ ନ ମରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ବାଦଲ୍‌ ଆରି ତେଇ ଉଜଲ୍‌ ଅଇ ରଇବାଟାମନ୍‌, ଦୁନିଆଇ ଆରି ତେଇରଇବା ସବୁ ଦିନ୍‌ସୁ ନାସ୍‌ ଅଇବା ସାରାସାରି ଦିନ୍‌ ଆଇସି, ମାତର୍‌ ମର୍‌ ବାକିଅ କେବେ ମିସା ନ ସାରେ ।” ");
INSERT INTO dso_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ମାତର୍‌ ସବୁ ଗଟ୍‍ନା କେବେ ଆରି ଜେଡେବେଲା ଅଇସି ବଲିକରି କେ ମିସା ନାଜାନତ୍‌ । ସରଗର୍‌ ଦୁତ୍‌ କି ସତ୍‌ ମାପ୍‌ରୁର୍‌ ପିଲା ମୁଇ ମିସା ନାଜାନି । ମର୍‌ ବାବା ପର୍‌ମେସର୍‌ ଗଟେକ୍‌ ଲକ୍‌ସେ ଜାନିଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ସେ ଦିନ୍‌ କି ବେଲା କେବେ ଆଇସି, ସେଟା ତମେ କେ ନାଜାନାସ୍‌ । ସେଟାର୍‌ପାଇ ତମେ ଜାଗ୍‌ରତ୍‌ ଅଇ ତିଆର୍‌ଅଇ ରୁଆ । ");
INSERT INTO dso_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ମୁଇ ଆଇବା ଦିନ୍‌, ଏନ୍ତି ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‍ ଗର୍‌ ଚାଡି ବିନ୍‌ ଦେସେ ଜିବା ବିସଇ ସମାନ୍‍ କରିଅଇସି । ସେ ନିଜର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ଡାକିକରି ସେମନ୍‌ କାଇ କାଇ କାମ୍‌ କର୍‌ବାର୍‌ଆଚେ, ସେ ସବୁ ବିସଇ ସେମନ୍‌କେ କଇଲା । ବାଟ୍‌ ଡିଆଗଡି ଜାଗ୍‌ବା ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଡାକିକରି ସେ ବାଉଡି ଆଇବା ଜାକ ଜାଗିକରି ରଇବାକେ କଇକରି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ତମେମିସା ଜାଗୁଆଲର୍‌ ପାରା ଜାଗ୍‌ରତ୍‌ ଅଇ ରୁଆ । କାଇକେବଇଲେ ସାଉକାର୍‌ ସଞ୍ଜ୍‌ବେଲା, କି ମଜାରାତି, କି କୁକ୍‌ଡାଡାକେ କି ସାକ୍‌ଲିଆ ଆଇସି ସେଟା ତମେ ନାଜାନାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ଜଦି ସେ ଅଟାତ୍‌ ଆସିକରି ଦେକ୍‌ଲାବେଲେ, ତମେ ଇସ୍‌ରାଇଲର୍‌ ଲକ୍‌ମନର୍‌ ପାରା ରଇବାଟା ସେ ଦେକ୍‌ବାର୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ମୁଇ ତମ୍‌କେ କାଇଟା କଇଲିନି, ସେ ବିସଇସେ ସବୁ ଲକ୍‌କେ କଇଲିନି । ମୁଇ ଆଇବା ଦିନ୍‌ପାଇ ତିଆର୍‌ ଅଇକରି ସବୁବେଲା ଜାଗ୍‌ରତ୍‌ ଅଇକରି ରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ନିସ୍‌ତାର୍‌ ପରବ୍‌ ଆରି କମିର୍‌ ନ ମିସାଇ ରୁଟି କାଇବା ପରବ୍‌ ଅଇବାକେ ଆରି ଦୁଇଦିନ୍‌ ବାକିରଇଲା । ସେବେଲେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ନିୟମ୍‌ ସିକାଉମନ୍‌ କେ ନାଜାନ୍‌ତେ ଜିସୁକେ କେନ୍ତି ବନ୍ଦିକରି ମରାଇଅଇସି ବଲିକରି ବୁଦି ପାଁଚ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ମାତର୍‌ ସେମନ୍‌ କଇଲାଇ, “ପରବ୍‌ ଦିନ୍‌ମନ୍‌କେ ତାକେ ବନ୍ଦିକରି ନଏଁ । କାଇକେବଇଲେ ଲକ୍‌ମନ୍‌ ଗଣ୍ଡ୍‍ଗଲ୍‌ କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ଜିସୁ ବେତ୍‌ନିଆ ଗଡେ ଆଗ୍‌ତୁ ବଡ୍‌ ରଗ୍‌ ଅଇଲା ସିମନର୍‌ ଗରେ କାଇବାକେ ବସ୍‌ଲାବେଲେ, ଗଟେକ୍‌ ମାଇଜି କାଁଚେ ବେସି ଦାମ୍‌ ଦେବା ବାସ୍‌ନା ଚିକନ୍‌ ଆନିକରି କାଁଚର୍‌ ଗାଲା ବାଙ୍ଗାଇ, ଜିସୁର୍‌ ମୁଣ୍ଡେ ରକଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ମାତର୍‌ ତେଇ ରଇବା କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ରିସାଅଇ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କାତା ଅଇଲାଇ, “ଏ ଚିକନ୍‌ କାଇକେ ବେକାର୍‌ ବେକାର୍‌ ନସ୍‌ଟ କରି ପାକାଇଲାନି ? ");
INSERT INTO dso_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ଏଟା ବର୍‌ସେକର୍‌ କାମାଇଲାତେଇଅନି ଅଦିକ୍‌ ଡାବୁକେ ବିକି ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ଦେବାର୍‌ ଅଇତା ।” ବଲିକରି ସେମନ୍‌ ସେ ମାଇଜିକେ ବେସି କଇପାକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ସେ ମାଇଜିକେ ଚାଡିଦିଆସ୍‌, କାଇକେ ତାକେ ଲାଗିକରି କସ୍‌ଟ ଦେଲାସ୍‌ନି ? ସେ ମର୍‌ପାଇ ନିକ କାମ୍‌ କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","କାଇକେବଇଲେ, ଗରିବ୍‌ ଲକ୍‌ମନ୍‌ ସବୁବେଲା ତମର୍‌ସଙ୍ଗ୍‍ ଆଚତ୍‌ । ତମେ ଜେଡେବେଲା ମନ୍‍କଲେ, ସେଡେବେଲା ସେମନ୍‌କେ ସାଇଜ କରିପାରାସ୍‌ । ମାତର୍‌ ମୁଇ ଆରି ବେସିଦିନ୍‌ ତମର୍‌ ସଙ୍ଗ୍ ନ ରଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ଏ ମାଇଜି ଜେତ୍‌କି ପାର୍‌ଲା, ସେତ୍‌କି କଲାଆଚେ । ସେ ମର୍‌ ମଲା ଗାଗଡ୍‌ ମସ୍‌ନେ ତପ୍‌ବା ଆଗ୍‌ତୁ ଚିକନ୍‌ ଲାଗାଇଦେଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ଗୁଲାଇ ଜଗତେ ଜନ୍‌ ଜାଗାଇ ମିସା ମାପ୍‌ରୁର୍‌ ନିକ କବର୍‌ ଜାନାଇଅଇସି । ଏ ମାଇଜି ଜାଇଟା କଲାଆଚେ, ତାକେ ଏତାଇକରି ସେଟା ମିସା କଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ତାର୍‌ପଚେ ଜିସୁର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ନାଉଁର୍‌ ଗଟେକ୍‌ ସିସ୍‌ ଜିସୁକେ ମୁକିଅ ପୁଜାରିମନର୍‌ ଆତେ ଦାରାଇଦେବାକେ ରାଜିଅଇକରି ସେମନର୍‌ ଲଗେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ସେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଜିଉଦାର୍‌ କାତା ସୁନିକରି ବେସି ସାର୍‌ଦା ଅଇଗାଲାଇ । ଏ କାମ୍‌ କଲେ ସେମନ୍‌ ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦାକେ ଡାବୁ ଦେବୁ ବଲିକରି ପର୍‌ମାନ୍‌ କରି କଇଲାଇ । ସେଟାର୍‌ପାଇ ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ଜିସୁକେ ମୁକିଅ ପୁଜାରିମନ୍‍କେ ଦାରାଇ ଦେବାକେ ବେଲା କଜ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","କମିର୍‌ ନ ମିସାଇକରି ରୁଟି ତିଆର୍‌କରି କାଇବା ବଜିର୍‌ ପରବର୍‌ ପର୍‌ତୁମ୍‌ ଦିନେ, ରକିଆ ପାଇବା ପରବେ ମେଣ୍ଡାପିଲା ପୁଜ୍‌ବାଇ । ସେଦିନେ ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ ତାକେ “ତର୍‌ପାଇ ରକିଆ ପାଇବା ପରବର୍‌ ବଜି ସବୁ ଟିକ୍ କର୍‌ବାକେ ଆମେ କନ୍‌ ଜାଗାଇ ଜିବୁ ବଲିକରି ତୁଇ ମନ୍‍ କଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ସେଟାର୍‌ପାଇ ଜିସୁ ତାର୍‌ ଦୁଇଟା ସିସ୍‌ମନ୍‌କେ ଡାକିକରି କଇଲା ତମେ ଗଡେ ଜା । ତେଇ ଗଟେକ୍‌ ବଡ୍‌ଟା ଆଣ୍ଡିତେଇ ପାନି ନେବା ଲକ୍‌କେ ଦେକ୍‌ସା । ତମେ ତାର୍‌ ପଚେ ପଚେ ଜା । ");
INSERT INTO dso_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ସେ ପାନିନେବା ଲକ୍‌ ଗଟେକ୍‌ ଗରେ ପୁର୍‌ସି । ତମେ ମିସା ସେ ଗର୍‌ ବିତ୍‌ରେ ପୁରିକରି ସେ ଗରର୍‌ ସାଉକାର୍‌କେ କୁଆ, “ଆମର୍‌ ଗୁରୁ ପାଚାର୍‌ଲାନି, ମୁଇ ମର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ରକିଆ ପାଇବା ପରବର୍‌ ବଜି କର୍‌ବା ବାକ୍‌ରା କନ୍ତି ଆଚେ ? ");
INSERT INTO dso_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ସେ ଗରର୍‌ ସାଉକାର୍‌ ତମ୍‌କେ ଗର୍‌ ଉପ୍‌ରେ ରଇବା ନିମାନ୍‌ ସଜାଇଅଇରଇଲା ଗଟେକ୍‌ ବଡ୍‌ଟା ବାକ୍‌ରା ଦେକାଇଦେଇସି । ତେଇ ଆମର୍‌ପାଇ କାଇବା କାଦି ତିଆର୍‌କରା ।” ବଲି ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ତାର୍‌ ପଚେ ଦୁଇଟା ସିସ୍‌ମନ୍‌ ସେ ଗରେ ଗାଲାଇ । ତେଇ ଜିସୁ ସେମନ୍‌କେ ଜେନ୍ତି କଇରଇଲା, ସବୁ ସେନ୍ତି ଦେକ୍‌ଲାଇ । ସେଟାର୍‌ପାଇ ସେମନ୍‌ ତେଇ ନିସ୍‌ତାର୍‌ ପରବର୍‌ ବଜି ତିଆର୍‌କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ସଞ୍ଜ୍‌ ଅଇଲାକେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଡାକିନେଇ ତେଇ କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ସେମନ୍‌ ବସି କାଇବାବେଲେ ଜିସୁ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ଏବେ ତମର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଜେକି ଆମର୍‌ ସଙ୍ଗ୍‌ କାଇଲାନି, ସେ ମକେ ସତ୍‌ରୁମନ୍‍କେ ଦାରାଇଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ଏ କାତା ସୁନିକରି ସିସ୍‌ମନ୍‌ ବେସି ମନ୍‌ଦୁକ୍‌ ଅଇଲାଇ । ସବୁଲକ୍‌ ଗଟେକ୍‌ ଗଟେକ୍‌ ଅଇକରି ଜିସୁକେ ସେଲକ୍‌ ମୁଇ କି ? ବଲିକରି ପାଚାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମର୍‌ ବାର ଲକର୍‌ ବିତ୍‌ରେଅନି ଜନ୍‌ ଲକ୍‌ ମର୍‌ସଙ୍ଗ୍‌ ଗିନାତେଇ ରୁଟି ଚବାଲିଆଚେ, ସେ ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“ମର୍‌ ବିସଇ ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ କେନ୍ତି ଲେକା ଅଇଲାଆଚେ, ସେନ୍ତିସେ ସବୁ ଅଇଲାନି, ସେଟା ସତ୍‌ସେ, ମାତର୍‌ ଜାର୍‌ଟାନେଅନି ନର୍‌ପିଲା ମୁଇ ସତ୍‌ରୁମନର୍‌ ଆତେ ଦାରାଇଅଇବି, ସେ ବେସି ବଡ୍‌ ଡଣ୍ଡ୍‌ ପାଇବାଲକ୍‌ ଆରି ସେ ଜନମ୍‌ ନ ଅଇରଇଲେ ନିକ ଅଇତା ।” ");
INSERT INTO dso_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ସିସ୍‌ମନ୍‌ କାଇବାକେ ବସ୍‌ଲାବେଲେ, ଜିସୁ ରୁଟିଦାରିକରି ପର୍‌ମେସର୍‌କେ ଜୁଆର୍‌କଲା ଆରି ସେଟା ବାଙ୍ଗାଇ ସେମନ୍‌କେ ଦେଇକରି କଇଲା, “ ନିଆ ଏଟା ମର୍‌ ଗାଗଡ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ତାର୍‌ପଚେ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ଦାରି ପର୍‌ମେସର୍‌କେ ଜୁଆର୍‌ କରି ସବୁ ଲକ୍‌କେ କାଇବାକେ ଦେଲାଜେ ସେମନ୍‌ କାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଆରି ସେ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, ଏଟା ଅଇଲାନି ବେସି ଲକର୍‌ପାଇ ଜରାଇଲା ମର୍‌ ବନି । ଏ ବନି ସଙ୍ଗ୍‌ ପର୍‌ମେସର୍‌ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ରାଜିନାମା କଲାନି । ");
INSERT INTO dso_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, “ମୁଇ ପର୍‌ମେସରର୍‌ ରାଇଜେ ନୁଆ ଅଙ୍ଗୁର୍‌ ରସ୍‌ କାଇବା ଦିନ୍‌ ନ ଆଇବାଜାକ, ଏଟା ଆରି କେବେ ମିସା ନ କାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ସବୁ ସିସ୍‌ମନ୍‌ ମିସିକରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦର୍‌ ଗିତ୍‌ ଗାଇ ଗାଇ କରି ଜିତ୍‌ ନାଉଁର୍‌ ପର୍‌ବତେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ସେବେଲେ ଜିସୁ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ତମେ ସବୁଲକ୍‌ ମକେ ଚାଡିକରି ଉଟିଜାଇସା । ସେଟା ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଏନ୍ତି ଲେକାଅଇଲାଆଚେ, “ମୁଇ ମେଣ୍ଡା ଗଉଡ୍‌କେ ମରାଇବି । ତେଇର୍‌ ମେଣ୍ଡାମନ୍‌ ଚିନ୍‌ଚତର୍‌ ଅଇଜିବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“ମାତର୍‌ ମୁଇ ମଲାଟାନେଅନି ଆରିତରେକ୍‌ ଉଟ୍‌ଲାପଚେ, ତମେ ଗାଲିଲି ଦେସେ ଜିବା ଆଗ୍‌ତୁ, ମୁଇ ତମର୍‌ ଆଗ୍‌ତୁ ଆଗ୍‌ତୁ ଗାଲିଲି ରାଇଜେ ଜିବି ।” ");
INSERT INTO dso_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ମାତର୍‌ ପିତର୍‌ ଜିସୁକେ କଇଲା, “ସବୁ ସିସ୍‌ମନ୍‌ ତମ୍‌କେ ଚାଡିକରି ଗାଲେ ମିସା ମୁଇ ତମ୍‌କେ କେବେ ନ ଚାଡି ।” ");
INSERT INTO dso_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ତକେ ସତ୍‌କାତା କଇଲିନି, ଆଜି ରାତି ଦୁଇତର୍‌ କୁକ୍‌ଡା ଡାକ୍‌ବା ଆଗ୍‌ତୁ, ତୁଇ ମକେ ତିନ୍‌ତର୍‌ ଚିନିନାଇ ବଲିକରି କଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ଏ କାତା ସୁନି ପିତର୍‌ ଜିସୁକେ ଆରିତରେକ୍‌ ଡାଟ୍‌ସଙ୍ଗ୍‌ କଇଲା, “ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‍ ମର୍‌ବାର୍‌ ଆଲେ ମିସା କେବେ ତମ୍‌କେ ନାଜାନି ବଲି ନ କଇ ।” ଆରି ବାକି ସିସ୍‌ମନ୍‌ ମିସା ସେନ୍ତିସେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ତାର୍‌ପଚେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଗେତ୍‌ସିମନି ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ ଆଇଲାଇ । ତେଇ ଜିସୁ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ମୁଇ ପାର୍‌ତନା କର୍‌ବାବେଲେ ତମେ ଇତି ବସିରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ପିତର୍‌, ଜଅନ୍‌ ଆରି ଜାକୁବ୍‌କେ ତାର୍‌ ସଙ୍ଗ୍‌ ମିସ୍‌ତେ ଡାକିନେଲା । ସେ ଦୁକ୍‌ଅଇ କିଲ୍‌ବିଲ୍‌ ଅଇବାର୍‌ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ଆରି ଜିସୁ, ପିତର୍‌, ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌କେ କଇଲା, “ମର୍‌ ମନେ ବେସି ଦୁକ୍‌ ଅଇଗାଲା ଆଚେ । ଜିବନ୍‌ ଚିଡିଗାଲା ପାରା ଲାଗ୍‌ଲାନି । ତମେ ଇତି ବସିରଇ ଜାଗିରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ଜିସୁ ତାକର୍‌ଟାନେଅନି କଣ୍ଡେକ୍‌ ଦୁରିକେ ଇଣ୍ଡିଜାଇ ଉମ୍‌ତାଡିଅଇ ବୁଏଁ ଅଦ୍‌ରିକରି ପର୍‌ମେସର୍‌କେ ଏନ୍ତି ପାର୍‌ତନା କଲା, “ଏନ୍ତି କରିଅଇସି ବଇଲେ, ଏ କସ୍‌ଟର୍‌ ବେଲା ମକେ ନ ଆସ । ");
INSERT INTO dso_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ଏ ମର୍‌ ବାବା ତୁଇ ମନ୍‍କଲୁସ୍‌ ବଇଲେ କାଇ କାମ୍‌ ମିସା କରିପାରୁସ୍‌ । ସେଟାର୍‌ପାଇ ଏ ଦୁକ୍‌ କସ୍‌ଟର୍‌ ମୁତା ମର୍‌ଟାନେଅନି ଦାରି ଜା । ମାତର୍‌ ମର୍‌ ମନ୍‍ କଲା ଇସାବେ ନ କରି ତମର୍‌ ମନ୍‍ କଲା ଇସାବେ କରା” ବଲି ପାର୍‌ତନା କଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ତାର୍‌ପଚେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନର୍‌ ଲଗେ ବାଉଡି ଆଇଲାଜେ, ସେମନ୍‌ ସଇରଇବାଟା ଦେକ୍‌ଲା । ସେ ପିତର୍‌କେ କଇଲା, “ ସିମନ୍‌ ପିତର୍‌, ତମେ ସଇଦେଲାସ୍‌ନି କି ? ଗଟେକ୍‌ ଗଁଟା ମିସା ଚେତା ରଇ ଜାଗି ନାପାର୍‌ଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ତମେ ଜେନ୍ତିକି ପରିକାର୍‌ ପାନ୍ଦେ ନ ଅଦର୍‌ବାପାଇ ଜାଗି ରଇକରି ପାର୍‌ତନା କରା । ମନ୍‌ କର୍‌ବି ବଲି ମନ୍‍ କଲାନି ମାତର୍‌ ଗାଗଡ୍‌ ନିଚ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ଜିସୁ ଆରିତରେକ୍‌ ଜାଇକରି ଆଗ୍‌ତୁର୍‌ ପାରା କଇକରି ପାର୍‌ତନା କଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ତାର୍‌ପଚେ ସେ ସିସ୍‌ମନର୍‌ ଲଗେ ଆରି ତରେକ୍‌ ବାଉଡି ଆସି ଦେକ୍‌ଲା । ସେମନ୍‌ ଆରିତରେକ୍‌ ସଇଦେଇରଇଲାଇ । ସେମନର୍‌ ଆଁକିତେଇ ଗୁନ୍‌ ଡାବି ଆଇତେରଇଲାଜେ ସେମନ୍‌ ଜିସୁକେ କାଇବଲି ମିସା କଇବାକେ ଜାନି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ଏନ୍ତି ତିନ୍‌ତର୍‌ ପାର୍‌ତନା କରି ସାରାଇଲାପଚେ ଜିସୁ ସିସ୍‌ମନର୍‌ଲଗେ ଆରିତରେକ୍‌ ବାଉଡି ଆଇଲା ଆରି ସେମନ୍‌କେ କଇଲା, “ଏବେଜାକ ତମେ ପୁଣ୍ଡିକରି ସଇଦେଇ ଆଚାସ୍‌ ? ଏତ୍‌କି ଅଇସିବେ, ଏବେ ନର୍‌ପିଲା ମକେ, ପାପି ଲକ୍‌ମନର୍‌ ଆତେ ଦାରାଇଦେବା ବେଲା ଆସି କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ଉଟା ଆମେ ଜୁବେ । ଏଦେ ଦେକା ! ମକେ ସତ୍‌ରୁମନ୍‍କେ ଦାରାଇ ଦେବା ଲକ୍‌ ଆଇଲାଆଚେ ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ସେ ଦାପ୍‌ରେ ଜିସୁ ଏ କାତା କଇବାବେଲା, ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଜେକି ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ଆସି କେଟ୍‌ଲା । ଆରି ତାର୍‌ ସଙ୍ଗ୍‌ ବେସି ଲକ୍‌ମନ୍‌ ରଇଲାଇ । ସେ ଲକ୍‌ମନର୍‌ ଆତେ କାଣ୍ଡା ଆରି ଟେଙ୍ଗ୍‌ ଦାରିରଇଲାଇ । ସେ ଲକ୍‌ମନ୍‌କେ ମୁକିଅ ପୁଜାରିମନ୍‌, ନିୟମ୍‌ ସିକାଇବା ଲକ୍‌ମନ୍‌ ଆରି ମୁକିଅ ଜିଉଦି ନେତାମନ୍‌, ପାଟାଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ସତ୍‌ରୁମନର୍‌ ଆତେ ଦାରାଇଦେବା ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ଜିସୁକେ ଦେକାଇଦେବାକେ ଏନ୍ତି ଗଟେକ୍‌ ଚିନ୍‌ କଇରଇଲା, “ମୁଇ ଜନ୍‌ ଲକ୍‌କେ ଚୁମ୍‌ବି, ସେ ଆକା ଜିସୁ । ତମେ ତାକେ ବନ୍ଦିକରି ଜାଗରତ୍‌ ସଙ୍ଗ୍‍ ଦୁରିକେ ଦାରିଜାଇସା ।” ");
INSERT INTO dso_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ସେମନ୍‌ ତେଇ ଆସିକରି କେଟ୍‌ଲା ଦାପ୍‌ରେ, ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ଜିସୁର୍‌ ଲଗେ ଜାଇକରି “ଏ ଗୁରୁ, ଜୁଆର୍‌ !” ବଲିକରି ଚୁମ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ସେବେଲା ସେଲକ୍‌ମନ୍‌ ଜିସୁକେ ଦାରି ବନ୍ଦିକରି ନେବାବେଲେ, ");
INSERT INTO dso_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ସେ ଲଗେ ଟିଆଅଇରଇଲା ଜିସୁର୍‌ ଗଟେକ୍‌ ସିସ୍‌ ତାର୍‌ କାଣ୍ଡା ବେଟି ମୁକିଅ ପୁଜାରିର୍‌ ଗତି ଦାଙ୍ଗ୍‌ଡାର୍‌ ଉଜା କାନ୍‌ କାଟିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଜିସୁ ସେ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ମୁଇ କାଇ ଗଟେକ୍‌ ଅପ୍‌ରାଦି ଲକ୍‌ କି, ତମେ କାଣ୍ଡା ଆରି ଟେଙ୍ଗ୍‌ମନ୍‌ ଦାରି ମକେ ନେବାର୍‌ ଆସିଆଚାସ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ସବୁ ଦିନ୍‌ ମୁଇ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ସିକାଇଦେବା ବେଲେ ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‌ ରଇଲି । ମାତର୍‌ ସେବେଲେ ମକେ ଦାରାସ୍‌ନାଇ । ମାତର୍‌ ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଜେନ୍ତି ଲେକାଅଇରଇଲା ସେଟା ସବୁ ସତ୍‌ ଅଇବାକେସେ ଏନ୍ତି ଅଇଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ସେବେଲା ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ ତାକେ ଚାଡି ଉଟିପାଲାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ମାତର୍‌ ସେବେଲା ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡା ଅବ୍‌କା ପାତଲ୍‌ ଚାଦର୍‌ ଡାବିଅଇ ଜିସୁର୍‌ ପଚେ ପଚେ ଜାଇତେରଇଲା । ଲକ୍‌ମନ୍‌ ତାକେ ବନ୍ଦିକର୍‌ବାକେ ଚେସ୍‌ଟା କଲାଇକେ ");
INSERT INTO dso_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ସେ ଦାଙ୍ଗ୍‌ଡା ପାତଲ୍‌ ଚାଦର୍‌ ଚାଡିକରି ଡୁମ୍‌ଣ୍ଡା ଉଟିପାଲାଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ପଚେ ସେ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ସବୁର୍‌ଟାନେଅନି ବଡ୍‌ପୁଜାରିତେଇ ଦାରିଗାଲାଇ । ମୁକିଅ ପୁଜାରିମନ୍‌, ପାର୍‌ଚିନ୍‌ମନ୍‌ ଆରି ନିୟମ୍‌ ଗୁରୁମନ୍‌ ସବୁଲକ୍‌ ଗଟେକ୍‌ ତେଇ ରୁଣ୍ଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତର୍‌ ଜିସୁର୍‌ ଟାନେଅନି ଦୁରିକେ ରଇ ତାର୍‌ ପଚେ ପଚେ ଗାଲା ଆରି ମୁକିଅ ପୁଜାରିର୍‌ ଡାଣ୍ଡ୍‌ବିତ୍‌ରେ ଗାଲା । ଜାଗୁଆଲ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ବସିକରି ଜଇ ଚେକ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ତେଇ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ବିଚାର୍‌ କର୍‌ବା ଜିଉଦି ନେତାମନ୍‌ ଜିସୁକେ ମର୍‌ବା ଡଣ୍ଡ୍‌ ଦେବାକେ ତାର୍‌ ବିରଦେ ସାକି କଜ୍‌ତେରଇଲାଇ । ମାତର୍‌ ସାକି ଦେବାକେ କେ ମିସା ମିଲତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ବେସି ଲକ୍‌ମନ୍‌ ଆସିକରି ଜିସୁର୍‌ ବିରଦେ ମିଚ୍‌ ସାକି କଇଲାଇ, ମାତର୍‌ ସେମନ୍‌ ସବୁଲକ୍‌ ବିନ୍‌ ବିନ୍‌ ରକାମର୍‌ କାତା କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ସାରାସାରି କେତେ ଲକ୍‌ ଉଟିକରି ତାର୍‌ ବିରଦେ ମିଚ୍‌ ସାକି ଦେଇ ଏନ୍ତି କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ଲକ୍‌ମନ୍‌ ତିଆର୍‌କଲା ଏ ପର୍‌ମେସରର୍‌ ମନ୍ଦିର୍‍ ମୁଇ ବାଙ୍ଗାଇ ଦେଇ, ସେଟା ତିନ୍‌ ଦିନ୍‌ ବିତ୍‌ରେ ଆରି ତିଆର୍‌କରିଦେବି, ଜନ୍‌ଟାକି ଲକ୍‌ମନ୍‌ ତିଆର୍‌ ନ କରିରଅତ୍‌ ବଲି ସେ କଇବା ଏ କାତା ଆମେ ସୁନିଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ମାତର୍‌, ଏନ୍ତି ବଇଲେମିସା ଏ ଲକ୍‌ମନ୍‌ କାଇ କାଇ ବିସଇ ସବୁ କଇତେରଇଲାଇ, ସେଟା, ଗଟେକ୍‌ ଲକର୍‌ କାତା ଆରି ଗଟେକ୍‌ ଲକର୍‌ କାତା ସଙ୍ଗ୍‌ ନ ମିସ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ତାର୍‌ପଚେ ସବୁଲକର୍‌ ଆଗ୍‌ତୁ ବଡ୍‌ ପୁଜାରି ଟିଆଅଇକରି ପାଚାର୍‌ଲା, “ଏ ଲକ୍‌ମନ୍‌ ତର୍‌ ବିରଦେ କେତେ କାତା କଇଲାଇନି, ସେ ବିସଇନେଇ ତକେ କାଇଟା ମିସା କଇବାର୍‌ ଆଚେ କି ?” ");
INSERT INTO dso_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ମାତର୍‌ ଜିସୁ ଚିମ୍‌ରା ଅଇକରି ରଇଲା, କାଇଟା ମିସା କଏନାଇ । ବଡ୍‌ପୁଜାରି ଜିସୁକେ ଆରି ତର୍‍ ପାଚାର୍‌ଲା, “ତୁଇ କାଇ ପୁଜା ପାଇବା ପର୍‌ମେସରର୍‌ ପଅ କିରିସ୍‌ଟ କି ?” ");
INSERT INTO dso_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ଜିସୁ କଇଲା, “ଉଁ, ମୁଇ ସେ । ଆରି ନର୍‌ପିଲା ମୁଇ, ପର୍‌ମେସରର୍‌ ବେସି ବପୁର୍‌ ଉଜା ଆତ୍‌ ବାଟେ ବସିରଇଲାଟା ଆରି ସରଗର୍‌ ମେଗେ ଆଇବାଟା ଦେକ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ବଡ୍‌ ପୁଜାରି ଏ କାତା ସୁନିକରି ବେସି ରିସାଅଇଜାଇ ତାର୍‌ ନିଜର୍‌ ପଚିଆ ଚିରିପାକାଇଲା ଆରି ସବୁଲକ୍‌ମନ୍‌କେ କଇଲା, “ଆମ୍‌କେ ଆରି କାଇ ସାକି ଦର୍‌କାର୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“ସେ ପର୍‌ମେସରର୍‌ ପିଲା ବଲିକରି କଇଲାଟା ତମେ ସୁନିଆଚାସ୍‌ । ଏବେ ତମେ କାଇଟା ବଲି ବାବ୍‌ଲାସ୍‌ନି ?” ତେଇ ସବୁ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଦସି କରାଇ, ତାକେ ମର୍‌ବା ଡଣ୍ଡ୍‌ ମିଲ ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ତେଇ ରଇଲା କେତେ ଲକ୍‌ମନ୍‌ ତାର୍‌ ଉପ୍‌ରେ ତୁକ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । କେତେଲକ୍‌ମନ୍‌ ତାର୍‌ ମୁଏଁ ଡାବିକରି ତାକେ ବିଦାସଙ୍ଗ୍‌ ମାର୍‌ଲାଇ । ତାକେ କିଜାଇକରି କଇଲାଇ, “ତୁଇ ଜଦି ପର୍‌ମେସରର୍‌ କାତା କଇବା ବବିସତ୍‌ବକ୍‌ତା ବଇଲେ, ତକେ କେ ମାର୍‌ଲା କ ?” ପଚେ ସନିଅମନ୍‌ ତାକେ ଦାରିଜାଇକରି ମାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ପିତର୍‌ ମଜାଡାଣ୍ଡେ ଟିଆଅଇଲାବେଲେ ବଡ୍‌ ପୁଜାରିର୍‌ ଗତି ଦାଙ୍ଗ୍‌ଡି ତେଇ ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ପିତର୍‌ ଜଇ ଚେକ୍‌ବାବେଲେ ତାକେ ନିମାନ୍‌ ଦେକିକରି କଇଲା, “ତୁଇମିସା ନାଜରିତର୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ରଇଲୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ମାତର୍‌ ପିତର୍‌ ତାକେ କଇଲା, “ସେଟା ମୁଇ ନଇ, ମୁଇ କେବେ ମିସା ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ରଇନାଇ, ତମେ କାଇଟା କଇଲାସ୍‌ନି ମୁଇ ନାଜାନି ।” ତାର୍‌ପଚେ ପିତର୍‌ ଡାଣ୍ଡେ ପୁର୍‌ବା ବାଟେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଆରି ତରେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡି ପିତର୍‌କେ ଦେକି ତେଇ ଟିଆଅଇଲା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ଏ ଲକ୍‌ ମିସା ଜିସୁର୍‌ ଦଲେଅନି ଗଟେକ୍‌ ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ମାତର୍‌ ପିତର୍‌ ଆରିତରେକ୍‌ କଇଲା, “ଏ କାତା ମୁଲ୍‍କେ ସତ୍‌ ନାଇ ।” ଆରି କେତେପର୍‌ ଗାଲା ପଚେ, ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ “ତୁଇ ସେମନର୍‌ ମାନ୍ଦାଇ ରଇଲୁସ୍‌ ଆକା, ତୁଇ ଗଟେକ୍‌ ଗାଲିଲି ଅନି ଆଇଲା ଲକ୍‌ ପାରା ଡିସ୍‍ଲୁସ୍‌ନି ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ମାତର୍‌ ପିତର୍‌ ସାଇପ୍‌ ଦେଇ ରାନ୍‌ ପାକାଇ କଇଲା, “ମୁଇ ପର୍‌ମେସରର୍‌ ନାଉଁ ଦାରି ପର୍‌ମାନ୍‌ କରି କଇଲିନି, ତମେ କାର୍‌ କାତା କଇଲାସ୍‌ନି, ମୁଇ ତାକେ ମୁଲ୍‌କେ ନାଜାନି ।” ");
INSERT INTO dso_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ପିତର୍‌ ଏ କାତା କଇଲା ଦାପ୍‌ରେ କୁକ୍‌ଡା ଦୁଇତର୍‌ ଡାକ୍‌ଲା । ଜିସୁ କଇରଇବା ସବୁ କାତା ପିତର୍‌ ଏତାଇଲା । ଜିସୁ କଇରଇଲା, କୁକ୍‌ଡା ଦୁଇତର୍‌ ଡାକ୍‌ବା ଆଗ୍‌ତୁ ତୁଇ ମକେ ତିନ୍‌ ତର୍‌ ନାଜାନି ବଲିକରି କଇସାରାଇରଇସୁ ବଲି । ତାର୍‌ପଚେ ପିତର୍‌ ବେସି ଦୁକ୍‌କରି କାନ୍ଦ୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ସାକାଲ୍‌ ସାକାଲ୍‌ ପାର୍‌ତନା ଗରର୍‌ ମୁକିଅ ପୁଜାରିମନ୍‌, ମୁକିଅ ନେତାମନ୍‌, ଜିଉଦି ନେତାମନ୍‌, ନିୟମ୍‌ ସିକାଇବା ଲକ୍‌ମନ୍‌ ଆରି ଜିଉଦି ଲକ୍‌ମନ୍‌କେ ସାସନ୍‌ କର୍‌ବା ସବୁ ରକାମର୍‌ ନେତାମନ୍‌ ଜିସୁକେ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ? ବଲି ଗଟେକ୍‌ ବଡ୍‌ ପଁଚାଦି କଲାଇ । ସେମନ୍‌ ତାକେ ବାନ୍ଦିକରି ସାସନ୍‌ କର୍‌ବା ପିଲାତ୍‍କେ ସର୍‌ପିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲା, “ତୁଇ କାଇ ଜିଉଦି ମନର୍‌ ରାଜା ?” ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ଜନ୍‌ଟା ପାଚାର୍‌ଲୁସ୍‌ନି, ସେଟା ସତ୍‌ସେ ।” ");
INSERT INTO dso_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ମୁକିଅ ପୁଜାରିମନ୍‌ ଜିସୁକେ ଦସ୍‍ ଦେଇ କଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ସେବେଲା ପିଲାତ୍‌ ତାକେ ଆରିତରେକ୍‌ ପାଚାର୍‌ଲା, “ତୁଇ କାଇକେ ଚିମ୍‌ରା ଅଇଦେଲୁସ୍‌ ? କାଇଟା ମିସା କଉସ୍‌ ନାଇ । ଦେକା ସେମନ୍‌ ତର୍‌ ବିରଦେ କେତେକ୍‌ ନିନ୍ଦା କାତା କଇଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ମାତର୍‌ ଜିସୁ କାତା ଅଏ ନାଇ । ସେଟା ଦେକିକରି ପିଲାତ୍‌ ବେସି କାବା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ରକିଆ ପାଇବାର୍‌ ପରବ୍‌ କଲାବେଲେ ସବୁ ବରସର୍‌ ରିତିନିତି ଇସାବେ ପିଲାତ୍‌, ଜନ୍‍ ଆଲେ ବନ୍ଦି ଲକ୍‌କେ, ଲକ୍‌ମନ୍‌ ବାର୍‌କରାଇ ଦେବାକେ ମନ୍‍ କରତେରଇଲାଇ, ତାକେ ବାର୍‌କରାଇ ଦେଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ସେବେଲେ ସର୍‌କାରର୍‌ ବିରୁଦେ ଦାବିକରି ବାର୍‌ବା ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ବନ୍ଦି ଅଇରଇଲା । ଏ ଲକ୍‌ ଆରି କେତେଟା ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌, ଲକ୍‌ମନ୍‌କେ ମରାଇ ବନ୍ଦି ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ଲକ୍‌ମନ୍‌ ପିଲାତର୍‌ଟାନେ ଆସି, କଇଲାଇ, “ସବୁ ବରସର୍‌ ରିତିନିତି ଇସାବେ ଏ ତରେକ୍‌ ମିସା ଗଟେକ୍‌ ବନ୍ଦି ଲକ୍‌କେ ମୁକ୍‌ଲାଇ କରି ବାର୍‌କରାଇଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ପିଲାତ୍‌ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ତମେ କାକେ ମନ୍‍ କଲାସ୍‌ନି ? ମୁଇ ତମର୍‌ ଲାଗି ଜିଉଦିମନର୍‌ ରାଜାକେ ଚାଡିଦେବି କି ?” ");
INSERT INTO dso_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ପିଲାତ୍‌ ରାଜା କାଇକେ ଏନ୍ତି କଇଲା ବଇଲେ, ମୁକିଅ ପୁଜାରିମନ୍‌ କୁଟ୍‌ ପାଁଚି ଜିସୁକେ ତାର୍‌ ଆତେ ସର୍‌ପିଦେଇ ଆଚତ୍‌ ବଲିକରି ସେ ଜାନିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ମାତର୍‌ ମୁକିଅ ପୁଜାରିମନ୍‌ ଲକ୍‌ମନ୍‌କେ ଉସ୍‌କାଇ କରି, “ଜିସୁର୍‌ ବାଦୁଲେ ବାର୍‌ବାକେ ଆମର୍‌ପାଇ ବନ୍ଦି ଗରେଅନି ମୁକ୍‌ଲାଇବାକେ କୁଆ ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ମାତର୍‌ ପିଲାତ୍‌ ଆରିତରେକ୍‌ ପାଚାର୍‌ଲା, “ସେନ୍ତିଆଲେ ତମେ ଜନ୍‌ ଲକ୍‌କେ ଜିଉଦିମନର୍‌ ରାଜା ବଲି କଇଲାସ୍‌ନି, ତାକେ ମୁଇ କାଇଟା କର୍‌ବି ବଲି ତମେ ମନ୍‍ କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ଲକ୍‌ମନ୍‌ ବେସି ରାଟୁକରି କଇଲାଇ, “ତାକେ କୁର୍‌ସେ ମରାଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ତେଇଅନି ପିଲାତ୍‌ ଆରିତରେକ୍‌ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “କାଇକେ, ସେ କାଇ ଦସ୍‌ କଲାଆଚେ ଜେ ?” ମାତର୍‌ ଲକ୍‌ମନ୍‌ ଅଦିକ୍‌ ଅଦିକ୍‌ ରାଟୁଅଇକରି କଇଲାଇ, “ତାକେ କୁରୁସ୍‍ କାଟେ ମରାଆ ।” ");
INSERT INTO dso_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ସେଟାର୍‌ପାଇ ପିଲାତ୍‌ ଲକ୍‌ମନ୍‌କେ ସାର୍‌ଦା କରାଇବାକେ ମନ୍‍କରି ବାର୍‌ବାକେ ବନ୍ଦି ଗରେଅନି ମୁକ୍‌ଲାଇଦେଇ ଜିସୁକେ କର୍‌ଡା ସଙ୍ଗ୍‌ ମାରି, କୁରୁସ୍‍କାଟେ କୁଟିମାରି ମରାଇଦେବାକେ ସନିଅମନ୍‌କେ ସର୍‌ପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ସନିଅମନ୍‌ ଜିସୁକେ ରମିୟ ସର୍‌କାରର୍‌ ସାସନ୍‌କାରିଆ ପିଲାତର୍‌, ମୁକିଅ ଗରର୍‌ ଡାଣ୍ଡେ ଦାରିଗାଲାଇ ଆରି ସେମନ୍‌ ବିନ୍‌ ସନିଅମନ୍‌କେ ଗଟେକ୍‌ ଟାନେ ଡାକି ରୁଣ୍ଡାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ସେମନ୍‌ ଜିସୁକେ କିଜାଇବାକେ ଜାମ୍‌କଲି ରଙ୍ଗର୍‌ ବସ୍‍ତର୍‍ ପିନ୍ଦାଇଲାଇ ଆରି ଗଟେକ୍‌ କାଟାର୍‌ ମୁକୁଟ୍‌ ତିଆର୍‌କରି ତାର୍‌ ମୁଣ୍ଡେ ପିନ୍ଦାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ସେମନ୍‌ ଜିସୁକେ କିଜାଇ କରି କଇଲାଇ, “ଏ ଜିଉଦିମନର୍‌ ରାଜା ତକେ ଜୁଆର୍‌, ତୁଇ ବେସି ଦିନ୍‌ ବଁଚ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ସେମନ୍‌ ତର୍‌କେତର୍‌ ବେତ୍‌ ଡାଙ୍ଗ୍‌ ସଙ୍ଗ୍‌ ତାର୍‌ ମୁଣ୍ଡେ ମାର୍‌ତେରଇଲାଇ ଆରି ତାର୍‌ ଉପ୍‌ରେ ତୁକି କିଜାଇକରି ମାଣ୍ଡିକୁଟା ଦେଇ ଜୁଆର୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ସେମନ୍‌ ଜିସୁକେ କିଜାଇ ସାରାଇଲାପଚେ, ଜାମ୍‌କଲି ରଙ୍ଗର୍‌ ବସ୍‍ତର୍‍ ତାର୍‌ ଗାଗ୍‌ଡେଅନି ବେଟିକରି, ନିଜର୍‌ ବସ୍‍ତର୍‍ ପିନ୍ଦାଇଦେଲାଇ । ତାର୍‌ପଚେ ସେମନ୍‌ ତାକେ କୁର୍‌ସକାଟେ ମରାଇବାକେ ଗଡ୍‌ ବାଇରେ ଦାରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ସେବେଲା ଆଲେକ୍‌ଜାଣ୍ଡାର୍‌ ଆରି କୁର୍‌ନିୟ ଜାଗାର୍‌ ରୁପ୍‌ଅର୍‌ ବାବା ସିମନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌, ପଲିଗାରାମ୍‌ ଅନି ଆସିକରି ସେ ବାଟେ ଜାଇତେରଇଲା । ସେ ସନିଅମନ୍‌ ତାକେ ଜିସୁର୍‌ କୁର୍‌ସ ବଇବାକେ ବାଦିଅ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ତାର୍‌ପଚେ ସେମନ୍‌ ଜିସୁକେ ଗଲ୍‌ଗତା ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ ଦାରିଗାଲାଇ । ଗଲ୍‌ଗତାର୍‌ ଅରତ୍‌ ଅଇଲାନି, କାପାଲ୍‌ ଜାଗା । ");
INSERT INTO dso_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ସେମନ୍‌ ଜିସୁକେ ଅସ ମିସାଇଲା ଅଙ୍ଗୁର୍‌ ରସ୍‌ କାଅ ବଲିକରି ଦେଲାଇ, ମାତର୍‌ ସେ ନିଚ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ତାର୍‌ପଚେ ଜିସୁକେ କୁର୍‌ସେ ଚଗାଇଲାଇ ଆରି ତାର୍‌ ବସ୍‍ତର୍‍ କାର୍‌ବାଗେ କାଇଟା ମିଲ୍‌ସି ବଲି ବାଟାକରି ନେବାକେ, କେଡ୍‌ ପୁଟାଇକରି ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ବାଟାକରି ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ସେମନ୍‌ ସାକ୍‌ଲିଆ ନ ଗଁଟା ବେଲାଇ ଜିସୁକେ କୁର୍‌ସେ ଚଗାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଆରି “ଏଟା ଜିଉଦିମନର୍‌ ରାଜା । ” ବଲି ନିନ୍ଦା କାତା ଲେକି କୁରୁସ୍‌ ଉପ୍‌ରେ ଡସାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","କୁର୍‌ସେ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଆରି ଦୁଇଟା ଚର୍‌ମନ୍‌କେ, ତାର୍‌ ଉଜାବାଟେ ଗଟେକ୍‌କେ, ଡେବ୍‌ରି ବାଟେ ଆରିଗଟେକ୍‌କେ ଚଗାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ସେ ବୁଲ୍‌ କଲା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ବଲି, ଇସାବ୍‌ ଅଇଲା ବଲିକରି ପର୍‍ମେସରର୍‌ ସାସ୍‌ତରେ ଲେକାଅଇରଇବା ବିସଇ ସିଦ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ସେ ବାଟ୍‌ ଦେଇ ଜିବା ଲକ୍‌ମନ୍‌ ନିଜେ ନିଜେ ମୁଣ୍ଡ୍‌ ଜୁଲାଇ ଜିସୁକେ ନିନ୍ଦାକରି କଇଲାଇ, “ପାର୍‌ତନା ଗର୍‌ ବାଙ୍ଗାଇ କରି ତିନ୍‌ଦିନ୍‌ ବିତ୍‌ରେ ତିଆର୍‌ କର୍‌ବାଲକ୍‌ ଏ ସେ କି ?” ବଲି କିଜାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","“ତୁଇ ଏବେ କୁର୍‌ସେ ଅନି ଉତ୍‌ରି ନିଜ୍‌କେ ରକିଆ କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ନିୟମ୍‌ ସିକାଇବା ଲକ୍‌ମନ୍‌ ମିସା ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କାତାଅଇକରି କିଜାଇଲାଇ । ସେମନ୍‌ କଇତେରଇଲାଇ, “ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ରକିଆ କର୍‌ତେରଇଲା, ମାତର୍‌ ସେ ନିଜେ ରକିଆ ଅଇ ନାପାର୍‌ଲା ।” ");
INSERT INTO dso_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“ତମେ ସତଇସେ ଇସ୍‌ରାଏଲର୍‌ ରାଜା କିରିସ୍‌ଟ ଅଇରଇଲେ, କୁର୍‌ସେ ଅନି ଉତ୍‌ରି ଆଉ । ସେନ୍ତି ଅଇଲେ ଆମେ ଦେକିକରି ବିସ୍‌ବାସ୍‌ କର୍‌ବୁ ।” ବଲି କଇଲାଇ । ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ କୁର୍‌ସେ ଚଗାଇରଇଲାଇ, ସେମନ୍‌ ମିସା ଜିସୁକେ ନିନ୍ଦା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ମୁଇଦାନିଆ ବାର୍‌ଟା ବେଲାଇଅନି ତିନ୍‌ଟା ଜାକ ଗୁଲାଇ ଦେସ୍‌ ଆନ୍ଦାର୍‌ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ଦିନ୍‌ ତିନ୍‌ଟା ବେଲେ ଜିସୁ ଆଉଲିଅଇ କଇଲା, “ଏଲଇ ଏଲଇ ଲାମା ସବକ୍‌ତାନି ।” ଆର୍‌ ଅରତ୍‌ ଅଇଲାନି, “ଏ ମର୍‌ ପର୍‌ମେସର୍‌ ଏ ମର୍‌ ପର୍‌ମେସର୍‌, ତମେ ମକେ କାଇକେ ଚାଡିଦେଲାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ଏ କାତା ସୁନି ସେଲଗେ ଟିଆ ଅଇରଇବା କେତେ ଲକ୍‌ କଇଲାଇ, “ସେ ଏଲିୟକେ ଡାକ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ତେଇଅନି ଗଟେକ୍‌ ଲକ୍‌ ପାଲାଇ ଜାଇ ଅଙ୍ଗୁର୍‌ ରସେ, ତୁଲା ବୁଡାଇ ଡାଙ୍ଗେ ବାନ୍ଦି ଉପ୍‌ରେ ଲାମାଇଦେଲା । ସେ ଲକ୍‌ କଇଲା, “ଏବେ ଏଲିୟ ଆସିକରି ଆକେ କୁର୍‍ସେ ଅନି ଉତ୍‌ରାଇଦେଇସି କି ନାଇ ଦେକୁ ।” ");
INSERT INTO dso_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ମାତର୍‌ ଜିସୁ ଆଉଲିଅଇଲା ଦାପ୍‌ରେ ତାର୍‌ ଜିବନ୍‌ ଚାଡିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ସେବେଲା ମନ୍ଦିରର୍‍ ସୁକଲ୍‌ ଜାଗା ବିନେ କର୍‌ବା ପାର୍‌ଦା ଉପ୍‌ରେଅନି ତଲେ ଜାକ ଦୁଇ ତାଡ୍‌ ଅଇ ଚିରିଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ତେଇ ଜିସୁର୍‌ କୁର୍‌ସ ମୁଆଟେ ଟିଆଅଇରଇଲା ସଏଟା ସନିଅମନର୍‌ ମୁକିଅ, ଜିସୁ ସାରାସାରି ଆଉଲି ଅଇଲାଟା ଆରି ସେ କେନ୍ତି ଅଇକରି ମଲା, ଦେକିକରି କଇଲା, “ସତଇସେ ଏ ପର୍‌ମେସରର୍‌ ପିଲା ରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ତେଇ କେତେଟା ମାଇଜିମନ୍‌ ମିସା କୁର୍‌ସେ ଅନି ଦୁରିକେ ଟିଆଅଇ ଦେକ୍‌ତେରଇଲାଇ । ସେମନ୍‌ ଅଇଲାଇନି, ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ସାନ୍‌ଟା ଜାକୁବ୍‌ ଆରି ଜସିର୍‌ ମା ମରିୟମ୍‌ ଆରି ସଲମି । ");
INSERT INTO dso_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଜିସୁ ଗାଲିଲିତେଇ ରଇଲାବେଲେ ଏ ମାଇଜିମନ୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ଜାଇତେରଇଲାଇ । ଆରି ତାକେ ଦର୍‌କାର୍‌ ରଇଲା ବିସଇ ସାଇଜ କର୍‌ତେରଇଲାଇ । ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଜିରୁସାଲାମେ ଆସିରଇଲା ବିନ୍‌ ମାଇଜିମନ୍‌ ମିସା ତେଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ସେ ଦିନ୍‌ ବିସ୍‌ରାମ୍‌ ଦିନ୍‌ ପାଇ ତିଆର୍‌ ଅଇବା ଦିନ୍‌ ଅଇରଇଲା । ସେଦିନେ ସଞ୍ଜ୍‌ବେଲା, ");
INSERT INTO dso_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ଆରାମାତିଆ ଗାଉଁର୍‌ ବିଚାର୍‌କର୍‌ବା ମୁକିଅ ଲକ୍‌ ବିତ୍‌ରେ ରଇଲା ଜସେପ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌, ପର୍‌ମେସର୍‌ ସାସନ୍‌ କର୍‌ବା ରାଇଜର୍‌ ବେଲା ଆସ ବଲି ଜାଗିରଇବା ଗଟେକ୍‌ ଲକ୍‌ । ବେସି ସାଆସ୍‌ଅଇ ପିଲାତର୍‌ ଲଗେ ଜାଇକରି ଜିସୁର୍‌ ମଲାମଡ୍‌ ମାଙ୍ଗ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ଜିସୁ ଏତେକ୍‌ ଦାପ୍‌ରେ ମରିଗାଲା ବଲି ସୁନି ପିଲାତ୍‌ କାବା ଅଇଗାଲା । ତାର୍‌ ସନିଅମନର୍‌ ନେତାକେ ଡାକି “ଜିସୁ ମଲାବେ କି ?” ବଲି ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ସେ ସନିଅମନର୍‌ ନେତା, ଜିସୁ ମରିଗାଲା ବିସଇ ପିଲାତ୍‌କେ କଇଲା । ତାର୍‌ପଚେ ଜସେପ୍‌କେ ପିଲାତ୍‌ କଇଲା, “ତୁଇ ମଡ୍‌ ନେଇ ପାରୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ସେଟାର୍‌ପାଇ ଜସେପ୍‌ ଜିସୁର୍‌ ଗାଗଡ୍‌ କୁର୍‌ସ ଉପ୍‌ରେଅନି ଉତ୍‌ରାଇ ଆନ୍‌ଲା ଆରି ଗଟେକ୍‌ ନୁଆ ଲୁଗା ସଙ୍ଗ୍‌ ଗୁଡିଆଇକରି ରାଙ୍ଗ୍‌ନି କାଟି ତିଆର୍‌ କରି ରଇଲା ଗଟେକ୍‌ ପାଆରେ ନେଇକରି ସଙ୍ଗଇଲା । ଗଟେକ୍‌ ବଡ୍‌ ଚାଚଡା ପାକ୍‌ନା ନେଇ ପାଆର୍‌ ମୁଆଟେ ଡାବିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ଜିସୁକେ ଜନ୍‌ ଜାଗାଇ ନେଇ ସଙ୍ଗଇ ରଇଲାଇ, ସେ ଜାଗା ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆରି ଜସିର୍‌ ମା ମରିୟମ୍‌ ଦେକିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ବିସ୍‌ରାମ୍‌ବାର୍‌ ସାର୍‌ଲା ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଜାକୁବର୍‌ ମାଆ ମରିୟମ୍‌ ଆରି ସଲମି, ଜିସୁର୍‌ ମଲା ଗାଗ୍‌ଡେ ଲାଗାଇବାକେ ବାସ୍‌ନା ଚିକନ୍‌ ଗେନିଆନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ରଇବାର୍‌ ଦିନର୍‌ ସାକାଲ୍‌ ସାକାଲ୍‌ ସେମନ୍‌ ତାର୍‌ ଗାଗଡ୍‌ ସଙ୍ଗଇଲା ଜାଗାକେ ଜାଇତେରଇଲାଇ । ସେବେଲେ ବେଲ୍‌ ଉଦି ଆଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ “ଜିସୁର୍‌ ଗାଗଡ୍‌ ସଙ୍ଗଇରଇଲା ମୁଆଟର୍‌ ବଡ୍‌ ଚାଚଡା ପାକ୍‌ନା ଆମର୍‌ ପାଇ କେ ଗୁଚାଇଦେଇସି ତେବେ ?” ବଲି କାତା ଅଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ସେମନ୍‌ ସେ ଜାଗାଇ କେଟିକରି ଦେକ୍‌ଲାବେଲେ, ଏଦେ ଦେକା ! ସେ ବଡ୍‌ ଚାଚଡା ପାକ୍‌ନା ଗୁଚିଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ସେବେଲା ସେମନ୍‌ ସେ ଜାଗା ବିତ୍‌ରେ ପୁରିକରି ଦେକ୍‌ଲାବେଲେ ଗଟେକ୍‌ ବିଜ୍‌ଲି ପାରା ଜଗ୍‌ଜଗି ଜାଇତେରଇବା ଦବ୍‌ ପଚିଆ ପିନ୍ଦିରଇବା ଦାଙ୍ଗ୍‌ଡା, ଜିସୁର୍‌ ମଡ୍‌ ସଙ୍ଗଇରଇଲା ଜାଗାର୍‍ ଉଜାବାଟେ ବସିରଇଲା । ସେଟା ଦେକି ସେମନ୍‌ ବେସି ଡରିଜାଇ କାବା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ମାତର୍‌ ସେ ଲକ୍‌ ସେମନ୍‌କେ କଇଲା, “ଡରାନାଇ, ତମେ କୁର୍‌ସେ ମଲା ନାଜରିତ୍‌ ଗଡର୍‌ ଜିସୁ କିରିସ୍‌ଟକେ କଜ୍‌ଲାସ୍‌ନି କି ? ସେ ଇତି ନାଇନି, ଏବେ ମଲାଟାନେଅନି ଉଟ୍‌ଲା ଆଚେ । ତାର୍‌ ମଡ୍‌ ସଙ୍ଗଇଲା ଜାଗା ଦେକା ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“ତମେ ଜାଇକରି ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଆରି ପିତର୍‌କେ ବାଇଦରେ କୁଆ, ତମେ ଜିବା ଆଗ୍‌ତୁ ଜିସୁ ଗାଲିଲି ଗଡେ ଗାଲା ଆଚେ । ସେ ତମ୍‌କେ ଜେନ୍ତି କଇରଇଲା, ସେନ୍ତିସେ ଗାଲିଲି ଗଡେ ତାକେ ଦେକ୍‌ସା ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ସେ ମାଇଜିମନ୍‌ ବେସି କାବା ଅଇଜାଇ, ତର୍‌ତରି ଜାଇକରି ସେ ଜାଗାଇଅନି ବାରଇକରି ପାଲାଇଲାଇ ଆରି ସେମନ୍‌ ବେସି ଡରିଜାଇକରି କାକେ ମିସା କାଇବଲି କଅତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ଜିସୁ ମଲାଟାନେଅନି ଉଟ୍‌ଲା ଆଟର୍‌ ପର୍‌ତୁମ୍‌ ଦିନର୍‌ ସାକାଲେ ଜନ୍‌ ମାଇଜିଟାନେଅନି ଜିସୁ ସାତ୍‌ଟା ଡୁମାମନ୍‌କେ କେଦିରଇଲା, ମଗ୍‌ଦଲିନି ନାଉଁର୍‌ ମରିୟମ୍‌କେ ପର୍‌ତୁମ୍‌ ଦେକାଇଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ସେ ମାଇଜି ତେଇଅନି ଜାଇକରି, ଦୁକ୍‌ଅଇ କରି କାନ୍ଦ୍‌ତେ ରଇଲା ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“ଜିସୁ ମଲାତେଇଅନି ଉଟ୍‌ଲା ଆଚେ ଆରି ମୁଇ ତାକେ ନିଜେ ଦେକିଆଚି ।” ବଲି କଇଲା । ସିସ୍‌ମନ୍‌ ତାକେ ମୁଲ୍‌କେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ତାର୍‌ପଚେ ଦୁଇଟା ସିସ୍‌ମନ୍‌ ଗଟେକ୍‌ ଗାଏଁ ଜିବାବେଲେ ଜିସୁ ସେମନ୍‌କେ ବିନ୍‌ ରୁପେ ଦେକାଇଅଇଲା । ସିସ୍‌ମନ୍‌ ତାକେ ଚିନି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ସେ ଦୁଇଟା ସିସ୍‌ମନ୍‌ ବାଉଡିଆସିକରି ବିନ୍‌ ସିସ୍‌ମନ୍‌କେ ଏ କାତା କଇଲାଇ । ଏନ୍ତି କଇଲେ ମିସା ସିସ୍‌ମନ୍‌ ତାକର୍‌ କାତା ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ତାର୍‌ପଚେ ଏଗାର୍‌ଟା ସିସ୍‌ମନ୍‌ କାଇବାବେଲେ ଜିସୁ ସେମନ୍‌କେ ଦେକାଇଅଇଲା । ଜିସୁ ମଲାଟାନେଅନି ଉଟ୍‌ଲାଟା ଦେକିରଇଲା ଲକ୍‌ମନ୍‌ କଇଲା କାତା ବିସ୍‌ବାସ୍‌ ନ କରି, ସେମନର୍‌ ମନ୍‌ ଆଁଟ୍‌ କଲାର୍‌ ଲାଗି ସେମନ୍‌କେ ଲାଗ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ଏ ଦୁନିଆର୍‌ ଗୁଲାଇବାଟେ ଜାଇକରି ସବୁ ଲକ୍‌ମନ୍‌କେ ମର୍‌ ନିମାନ୍‌ କାତା କୁଆ । ");
INSERT INTO dso_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ଜେ ଜେ ଏ ନିମାନ୍‍ କାତା ବିସ୍‌ବାସ୍‌ କରି ଡୁବନ୍‌ ନେବାଇ, ସେମନ୍‌ ପାପେଅନି ରକିଆ ପାଇବାଇ, ମାତର୍‌ ଜେ ଜେ ଏ ନିମାନ୍‍ କାତା ବିସ୍‌ବାସ୍‌ ନ କରତ୍‌, ପର୍‌ମେସର୍‌ ସେମନ୍‌କେ ଡଣ୍ଡ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ଆରି ବିସ୍‌ବାସି ଲକ୍‌ମନ୍‌ ମର୍‌ ନାଉଁ ଦାରି ଡୁମାମନ୍‌କେ ବାର୍‌କରାଇ କେଦିଦେବାଇ ଆରି ନାଜାନିରଇବା ବାସାଇ କାତା ଅଇବାଇ । ଏନ୍ତି ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ଟାନେ ଗଟେକ୍‌ ଚିନ୍‌ ପାରା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ସେମନ୍‌ ନାଜାନିକରି ସାଁପ୍‌ ଆତେ ଦାର୍‌ଲେ କି ବିସ୍‌ କାଇଲେ ନ ମରତ୍‌ । ଜର୍‌ଦୁକାର୍‌ ଲକ୍‌ମନ୍‌କେ ଆତ୍‌ ଚିଇ କରି ପାର୍‌ତନା କଲେ, ସେଲକ୍‌ମନ୍‌ ନିମାନ୍‌ ଅଇଜିବାଇ” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ମାପ୍‌ରୁ ଜିସୁ ଏ ସବୁ କାତା ସେମନ୍‌କେ କଇ ସାରାଇଲା ପଚେ, ପର୍‌ମେସର୍‌ ତାକେ ସର୍‌ଗେ ଦାରିଗାଲା ଆରି ପର୍‌ମେସର୍‌ ସନ୍‌ମାନ୍‌ ଜାଗାଇ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ତାର୍‌ପଚେ ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜାଇକରି ଏ ଦୁନିଆର୍‌ ଗୁଲାଇବାଟେ ମାପ୍‌ରୁ ଜିସୁର୍‌ ନିମାନ୍‌ କାତା କଇଲାଇ ଆରି ମାପ୍‌ରୁ ତାକର୍‌ ସଙ୍ଗ୍‍ ରଇକରି କାବାଅଇଜିବା ବିନ୍‌ ବିନ୍‌ କାମ୍‌ କଲା । ଏନ୍ତାରି ସେମନ୍‌ କଇବା କାତା ସତ୍‌ ବଲି ଦେକାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ଏ ତିଅପିଲ୍‌ ମଆସୟ, ଆମର୍‌ ବିତ୍‌ରେ ଜନ୍‌ ସବୁ ଗଟ୍‍ନା ଗଟ୍‌ଲା, ସେସବୁ ଲେକ୍‌ବାକେ ବେସି ଲକ୍‌ ଚେସ୍‌ଟା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ଆରାମ୍‌ ଅଇଲା ମୁଲେ, ଜେଜେ ଏ ସବୁ ଦେକିରଇଲାଇ ଆରି ସୁବ୍‌ କବର୍‌ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ଜାନାଇଲାଇ, ସେମନ୍‌ ଆମ୍‌କେ କଇଲା ଇସାବେ ଲେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ତେବର୍‌ପାଇ ଏ ମାନନିୟ ତିୟପିଲ୍‌. ପୁର୍‌ବେଅନି ଟିକିନିକି କଜ୍‌ଲଡ୍‌କରି ତେଇ ସବୁଜାକ ରିତିିନିତି ସଙ୍ଗ୍‌ ଅଇଲାଟା ତମର୍‌ପାଇ ମୁଇ ଲେକ୍‌ବିଆକା ବଲି ମନ୍‌କଲି । ");
INSERT INTO dso_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ଜେନ୍ତି ତୁଇ ସବୁ ବିସଇର୍‌ ସିକିଆ ପାଇଆଚୁସ୍‌, ସେ ସିକିଆର୍‌ ପୁରାପୁରୁନ୍‌ ସତ୍‌ ପାଇପାରୁସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଜିଉଦା ଦେସର୍‌ ରାଜା ଏରଦର୍‌ ବେଲେ, ଅବିୟ ପୁଜାରି ଦଲେ ଜିକରିୟ ନାଉଁର୍‌ ଗଟେକ୍‌ ପୁଜାରି ରଇଲା । ତାର୍‌ ମାଇଜି ଏଲିସାବେତ୍‌ । ସେ ଆରଣ୍‌ ବଁସର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ପର୍‌ମେସରର୍‌ ଦେକ୍‌ବା ଇସାବେ ସେମନ୍‌ ଦୁଇଲକ୍‌ ଜାକ ମାପ୍‌ରୁର୍‌ ସବୁ ଆଦେସ୍‌, ବିଦି ଇସାବେ କରତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ମାତର୍‌ ସେମନ୍‌କେ ପିଲାଜିଲା ନ ରଇଲା । କାଇକେ ବଇଲେ ଏଲିସାବେତ୍‌ ବାଞ୍ଜି ରଇଲା । ଆରି ସେମନ୍‌ ଡକ୍‌ରା ଡକ୍‌ରି ଅଇଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ଦିନେକ୍‌ ଜିକରିୟ ନିଜର୍‌ ଦଲର୍‌ ପାଲି ଇସାବେ, ଜିଉଦିମନର୍‌ ମନ୍ଦିରେ ପୁଜାରି କାମ୍‌ କର୍‌ବାବେଲେ, ");
INSERT INTO dso_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ରିତିନିତି ଇସାବେ ଜିକରିୟର୍‍ ନାଉଁ କେଡ୍‌ ପୁଟ୍‌ଲାଜେ ତାକେ ମାପ୍‌ରୁର୍‌ ମନ୍ଦିରେ ଜାଇକରି ବେଦିଟାନେ ଦୁପ୍‌ ଦେବାକେ ପଡ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ଆରି ଦୁପ୍‌ ଦେବାବେଲେ ଲକ୍‌ମନ୍‌ ବାଇରେ ପାର୍‌ତନା କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ସେଡ୍‌କିବେଲେ ଏଦେ ଦେକା ! ମାପ୍‌ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ଦୁପ୍‌ ଦେବା ବେଦିର୍‌ ଉଜାବାଟେ ଟିଆଅଇ ତାକେ ଦର୍‌ସନ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜିକରିୟ ତାକେ ଦେକି କିଲ୍‌ବିଲ୍‌ ଅଇ ଡରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ମାତର୍‌ ଦୁତ୍‌ ତାକେ କଇଲା, “ଜିକରିୟ ଡର୍‌ନାଇ, କାଇକେବଇଲେ ତମେ ଗୁଆରି କଲାଟା ପର୍‌ମେସର୍‌ ସୁନିଆଚେ । ତର୍‌ ମାଇଜି ଏଲିସାବେତ୍‌ ଗଟେକ୍‌ ପିଲା ଜନମ୍‌ ଦେଇସି । ତମେ ତାକେ ଜଅନ୍‌ ବଲି ନାଉଁ ଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ସେ ତମର୍‌ ପାଇ ବେସି ସାର୍‌ଦା ଆନ୍‌ସି ଆରି କେତେ କେତେ ଲକ୍‌ମନ୍‌ ତାର୍‌ ଜନମେ ସାର୍‌ଦା କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ମାପ୍‌ରୁର୍‌ ଦେକ୍‌ବା ଇସାବେ ସେ ଗଟେକ୍‌ ଡାକ୍‌ପୁଟା ଲକ୍‌ ଅଇସି । ସେ ଆମଟ୍‌ ଅଇଜାଇରଇବା ଅଙ୍ଗୁର୍‌ ରସ୍‌ କି ନିସା ଜିନିସ୍‌ ମୁଲ୍‌କେ ନ କାଏ ଆରି ମାଆର୍‌ ଗର୍‌ବେ ଅନି ସୁକଲ୍‌ ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇ ଆଇସି । ");
INSERT INTO dso_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ଆରି ଇସ୍‌ରାଏଲ୍‌ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅନି କେତେ କେତେ ଲକ୍‌ମନ୍‌କେ ମାପ୍‌ରୁ ତାର୍‌ ପର୍‌ମେସରର୍‌ ଟାନେ ବାଉଡାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ସେ ବବିସତ୍‌ବକ୍‌ତା ଏଲିୟର୍‌ ଆତ୍‌ମାଇ ବପୁଅଇ ପର୍‌ମେସରର୍‌ ଆଗ୍‌ତୁ ଜାଇସି । ବାବାମନର୍‌ ମନ୍‌ ପିଲାମନର୍‌ଟାନେ ବାଉଡାଇସି । ପର୍‌ମେସରର୍‌ କାତା ନ ମାନ୍‌ବା ଲକ୍‌ମନ୍‌କେ ଦରମ୍‌ ଲକ୍‌ମନ୍‌ ଚିନ୍ତା କର୍‌ବା ଟାନେ ବାଉଡାଇସି । ଆରି ପର୍‌ମେସରର୍‌ ଲକ୍‌ମନ୍‌କେ ତାର୍‌ ପାଇ ଜାଗ୍‌ରତ୍‌ କରାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ତେଇ ଜିକରିୟ ଦୁତ୍‌କେ କଇଲା, “ତମେ କଇବାଟା ସତ୍‌ ଅଇସି ବଲି ମୁଇ କେନ୍ତି ଜାନ୍‌ବି ? କାଇକେବଇଲେ ମୁଇତା ଡକ୍‌ରା ଅଇଗାଲିବେ, ଆରି ମର୍‌ ମାଇଜି ମିସା ଡକ୍‌ରି ଅଇଗାଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ଦୁତ୍‌ ତାକେ କଇଲା “ମୁଇ ଗାବ୍‌ରିଏଲ୍‌, ମୁଇ ପର୍‌ମେସରର୍‌ ମୁଆଟେ ଟିଆ ଅଇରଇବା ଦୁତ୍‌, ତମ୍‌କେ ଏ କବର୍‌ ଜାନାଇବାକେ ମକେ ପାଟାଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ଦେକ୍‌, ଏ ସବୁ ନ ଅଇବା ଦିନ୍‌ ଜାକ ତୁଇ ଗୁଲାଅଇ ରଇସୁ । କାଇକେବଇଲେ ମର୍‌ ସବୁ ବାକିଅ ସମାନ୍‌ ବେଲାଇସେ ପୁରାପୁରୁନ୍‌ ଅଇସି । ସେଟା ସବୁ ତୁଇ ବିସ୍‌ବାସ୍‌ କୁରୁସ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ଏତ୍‌କି ଅଇବା ବିତ୍‌ରେ ଲକ୍‌ମନ୍‌ ଜିକରିୟକେ ବାଇରେ ଜାଗିରଇଲାଇ ଆରି ଦେଉଲେ ତାର୍‌ ଅଲ୍‌ସମ୍‌ ଅଇଲାଜେ ସେମନ୍‌ କାବାଅଇ ଜାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ମାତର୍‌ ଜିକରିୟ ବାରଇ ଆସି ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ କାତାଅଇ ନାପାର୍‌ଲା, ତେଇ ସେ ଦେଉଲେ ଦର୍‌ସନ୍‌ ପାଇଆଚେ ବଲି ଲକ୍‌ମନ୍‌ ବୁଜ୍‌ଲାଇ ଆରି ସେ ଲକ୍‌ମନ୍‌କେ ଆତ୍‌ ସଗିଆ କରି ଜାନାଇବାର୍‌ ଦାର୍‌ଲା ଆରି ଗୁଲାଅଇକରି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ଜିକରିୟ ତାର୍‌ ସେବା କର୍‌ବା ପାଲି ଦିନ୍‌ ସବୁ ସାର୍‌ଲା ପଚେ ତାର୍‌ ଗରେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ଏତ୍‌କି ଅଇ କେତେକ୍‌ ଦିନ୍‌ ଗାଲା ପଚେ ତାର୍‌ ମାଇଜି ଏଲିସାବେତ୍‌ ଗାଗ୍‌ଡେ ଅଇଲା ଆରି ସେ ପାଁଚ୍‌ ମାସ୍‌ ଜାକ କାକେ ନ ଜାନାଇ ଗରେସେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ତାର୍‌ପଚେ ଏଲିସାବେତ୍‌ କଇଲା, “ଲକ୍‌ମନର୍‌ ଜେଞ୍ଜେଟ୍‌ କର୍‌ବାଟା ଦୁର୍‌ କର୍‌ବାକେ ସାରାସାରି ମକେ ଦୟା କରି ମାପ୍‌ରୁ ଏନ୍ତାରି କଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଏଲିସାବେତ୍‌ ଗାଗ୍‌ଡେଅଇ ଚ ମାସ୍‌ ଅଇଲାକେ, ପର୍‌ମେସର୍‌ ଗାବ୍‌ରିଏଲ୍‌ ଦୁତ୍‌କେ ଗାଲିଲି ରାଇଜର୍‌ ନାଜରିତ୍‌ ନାଉଁର୍‌ ନଅରେ ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡିର୍‌ ଟାନେ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ସେ ଦାଙ୍ଗ୍‌ଡିର୍‌ ନାଉଁ ମରିୟମ୍‌, ଦାଉଦ୍‌ ବଁସର୍‍ ଜସେପ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡା ସଙ୍ଗ୍‌ ତାର୍‌ ମାଙ୍ଗ୍‌ନି ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ଦୁତ୍‌ ମରିୟମର୍‍ ଲଗେ ଆସି କଇଲା, “ଏ ନୁନି, ମାପ୍‌ରୁ ତକେ ଦୟାକଲା ଆଚେ, ଆରି ତର୍‌ସଙ୍ଗ୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ମରିୟମ୍‌ ସରଗର୍‌ ଦୁତ୍‌ କଇଲା ବାକିଅ ସୁନ୍‌ଲା ଆରି କାଇଟା ବୁଜିନାପାରି ଉଡୁକ୍‌ ଦୁଡୁକ୍‌ ଅଇଜାଇକରି, ବାବିବାବି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ଦୁତ୍‌ ତାକେ କଇଲା, “ମରିୟମ ଡର୍‌ ନାଇ, ତୁଇ ମାପ୍‌ରୁର୍‌ ଦୟା ପାଇଆଚୁସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ଦେକ୍‌ ତୁଇ ଗାଗ୍‌ଡେ ଅଇ ପିଲା ଗଟେକ୍‌ ଜନମ୍‌ କର୍‌ସୁ ଆରି ତାର୍‌ ନାଉଁ ଜିସୁ ଦେଇସା । ");
INSERT INTO dso_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ସେ ଗଟେକ୍‌ ଡାକ୍‌ପୁଟା ଲକ୍‌ ଅଇସି ଆରି ସବୁର୍‌ ଉପ୍‌ରେ ରଇବା ପର୍‌ମେସରର୍‌ ପଅ ବଲି କଇବାଇ, ସରଗର୍‌ ମାପ୍‌ରୁ ତାକେ, ତାର୍‌ ଆନିଦାଦି ଦାଉଦର୍‌ ପାରା ରାଜା କରାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ସେ କାଲ୍‌କାଲ୍‌ ଜୁଗ୍‌ଜୁଗ୍‌ ଇସ୍‌ରାଏଲ୍‌ ଲକ୍‌ମନ୍‌କେ ସାସନ୍‌ କର୍‌ସି । ତାର୍‌ ରାଇଜ୍‌ କେବେ ନ ସାରେ ।” ");
INSERT INTO dso_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ମରିୟମ୍‌ ଦୁତ୍‌କେ କଇଲା, “ଏଟା କେନ୍ତି ଅଇସି ? ମୁଇତା ମୁନୁସ୍‌କେ ନାଜାନି !” ");
INSERT INTO dso_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ଦୁତ୍‌ ତାକେ କ‍ଇଲା, “ସୁକଲ୍‌ ଆତ୍‌ମା ଆସି ତକେ ଡାବି ଅଇସି, ଆରି ସବୁର୍‌ ଉପ୍‌ରେ ରଇବା ପର୍‌ମେସରର୍‌ ବପୁ ତକେ ଗୁଡିଆଇ ଅଇସି, ତେବର୍‌ପାଇ ଜେ ଜାତ୍‌ ଅଇସି, ସେ ସୁକଲ୍‌ ପର୍‌ମେସରର୍‌ ପଅ ବଲି ଡାକ୍‌ପୁଟା ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ଆରି ଦେକ୍‌, ତର୍‌ ଲାଗାର୍‌ ଲିତାର୍‌ ଏଲିସାବେତ୍‌ ମିସା ଡକ୍‌ରି ବେଲେ ଗାଗ୍‌ଡେ ଆଚେ, ଜାକେ ଲକ୍‌ମନ୍‌ ବାଞ୍ଜି ବଲି କଇତେରଇଲାଇ । ତାକେ ଏବେ ଚ ମାସ୍‌ ଅଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","କାଇକେବଇଲେ ପର୍‌ମେସରର୍‌ଟାନେ କାଇଟା ମିସା ନ ଅଇବା କାମ୍‌ ନାଇ, ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ତେଇ ମରିୟମ୍‌ କଇଲା, “ଦେକା, ମୁଇ ଗଟେକ୍‌ ମାପ୍‌ରୁର୍‌ ଦାସି, ତମେ କଇବା ଇସାବେ ମକେ ଅ ।” ତାର୍‌ପଚେ ଦୁତ୍‌ ତାର୍‌ଟାନେଅନି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ସେଡ୍‌କିବେଲେ ମରିୟମ୍‌ ବାରଇକରି ଜିଉଦା ରାଇଜର୍‌ ଡଙ୍ଗର୍‌ ଜାଗାର୍‌ ଗଟେକ୍‌ ନଅରେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ତେଇ ଜିକରିୟର୍‌ ଗରେ ପୁରିକରି ସେ ଏଲିସାବେତ୍‌କେ ଜୁଆର୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ମରିୟମ୍‌ ଜୁଆର୍‌କଲାଟା ସୁନ୍‌ଲା ଦାପ୍‌ରେ ଏଲିସାବେତର୍‌ ଗର୍‌ବେ, ପିଲା ସାର୍‌ଦା ଅଇ ଡେଗଇଲା ଆରି ଏଲିସାବେତ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ଏଲିସାବେତ୍‌ ଆଉଲି ଅଇକରି କଇଲା, “ତୁଇ ସବୁ ମାଇଜିମନର୍‌ ବିତ୍‌ରେ ଅନି କେଡେକ୍‌ ନିକ କରମର୍‌ ଲକ୍‌ ! ତର୍‌ ଗରବର୍‌ ପିଲାର୍‌ ମିସା କେଡେକ୍‌ କରମ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ମୁଇ କେ ଜେ ମର୍‌ ମାପ୍‌ରୁର୍‌ ମାଆ, ମକେ ଦେକ୍‌ବାର୍‌ ଆଇଲା ଆଚେ ? ");
INSERT INTO dso_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","କାଇକେବଇଲେ, ଦେକ୍‌, ତୁଇ ଜୁଆର୍‌କଲାଟା ସୁନ୍‌ଲା ଦାପ୍‌ରେ ମର୍‌ ଗରବର୍‌ ପିଲା ସାର୍‌ଦା ଅଇ ଡେଗଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ଜେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି ତାର୍‌ କେଡେକ୍‌ ନିମାନ୍‌ କରମ୍‌, କାଇକେବଇଲେ ମାପ୍‌ରୁ ତାକେ ଜାଇଜାଇଟା କୁଆଅଇଲାଆଚେ, ସେ ସବୁଜାକ ଅଇସି ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ତେଇ ମରିୟମ୍‌ କଇଲା, “ମର୍‌ ଜିବନ୍‌ ମର୍‌ ମାପ୍‌ରୁର୍‌ ମଇମା କଲାନି । ");
INSERT INTO dso_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ଆରି ମର୍‌ ଆତ୍‌ମା ମର୍‌ ରକିଆକାରି ପର୍‌ମେସରର୍‌ଟାନେ ସାର୍‌ଦା କଲାନି । ");
INSERT INTO dso_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","କାଇକେବଇଲେ ସେ ମର୍‌ପାରା କାକୁର୍‌ତିଆନିକେ ନିଜର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡି ବଲି ଏତାଇଲା ଆଚେ । ଆରି ଦେକା ଆଜିଅନି କାଲ୍‍କାଲ୍‍ ଜୁଗ୍‌ଜୁଗ୍‌, ସବୁ ଲକ୍‌ ମକେ ପର୍‌ମେସରର୍‌ ତେଇଅନି ଆସିର୍‌ବାଦ୍‌ ମିଲ୍‌ଲା ଲକ୍‌ ବଲି କଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","କାଇକେବଇଲେ ସବୁର୍‌ଟାନେଅନି ବପୁର୍‌ ମାପ୍‌ରୁ, ମର୍‌ପାଇ କାବାଅଇଜିବା କାମ୍‌ କଲାଆଚେ, ତାର୍‌ ନାଉଁ ସୁକଲ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ଡରିକରି ରଇବାଇ, ଜୁଗେ ଜୁଗେ ସେ ସେମନ୍‌କେ ଦୟା କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ସେ ତାର୍‌ ନିଜର୍‌ ବପୁର୍‌ ଆତ୍‌ ଦେକାଇଆଚେ, ସେ ଆଁକାର୍‌ ଲକ୍‌ମନ୍‌କେ ସେମନର୍‌ ମନେ ବାବ୍‌ନା କଲାଟା ଚିନ୍‌ଚତର୍‌ କଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ସେ ବଡ୍‌ ବଡ୍‌ ରାଜାମନ୍‌କେ ସେମନ୍‍ ରଇବାଟାନେଅନି ଉତ୍‌ରାଇ ଦେଲା ଆଚେ, ଆରି କାକୁର୍‌ତିଆମନ୍‌କେ ଉପ୍‌ରେ ଉଟାଇ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ସେ ବୁକର୍‌ ଲକ୍‌ମନ୍‌କେ ନିକ ନିକ ବିସଇ ଦେଇ ସାର୍‌ଦା କରାଇ ଆଚେ, ସାଉକାର୍‌ଲକ୍‌ମନ୍‌କେ ଚୁଚା ଆତେ ବାଉଡାଇଦେଇ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ଆମର୍‌ ଆନିଦାଦିମନ୍‌କେ ଜନ୍‌ କାତା ଦେଇରଇଲା, ସେଟା ପୁରାପୁରୁନ୍‌ କଲା ଆରି ତାର୍‌ ନିଜର୍‌ ଚାକର୍‌ ଇସ୍‌ରାଏଲର୍‌ ଉପ୍‌କାର୍‌ କରି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ସେ ଅବ୍‌ରାଆମ୍ ଆରି ତାର୍‌ ନାତିମନ୍‌କେ ତାର୍‌ ଦୟା କାଲ୍‍କାଲ୍‍ ଜୁଗ୍‌ଜୁଗ୍‌ ଏତାଅତ୍‌ବଲି ଦେକାଇଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ଆରି ମରିୟମ୍‌ ତିନ୍‌ ମାସ୍‌ ପାରା ଏଲିସାବେତର୍‌ ସଙ୍ଗ୍‌ ରଇ ନିଜର୍‌ ଗରେ ବାଉଡି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ପଚେ ଏଲିସାବେତର୍‌ ଆତ୍‌ଗଡ୍‌ ସୁକ୍‌ ଅଇବା ଦିନ୍‌ କେଟି ଆଇଲାଜେ, ସେ ଗଟେକ୍‌ ପିଲା ଜନମ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ଆରି ମାପ୍‌ରୁଜେ ତାକେ ଦୟା କଲାଆଚେ, ଏଟା ସୁନି ଜିକରିୟର୍‌ ଲାଗାର୍‍ଲିତାର୍‌ ଲକ୍‍ ଆରି ଗତିଆ କୁଟୁମ୍‌ ତାକର୍‌ ସଙ୍ଗ୍‌ ସାର୍‌ଦା କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ଆଟ୍‌ ଦିନ୍‌ ଗାଲାପଚେ ଲକ୍‌ମନ୍‌ ପିଲାର୍‌ ସୁନତ୍‌ଟାନେ ଆଇଲାଇ ଆରି ତାର୍‌ ବାବାର୍‌ ନାଉଁ ଇସାବେ ପିଲାର୍‌ ନାଉଁ ମିସା ଜିକରିୟ ଦେବାକେ ମନ୍‌କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ମାତର୍‌ ଏଲିସାବେତ୍‌ କଇଲା, “ନାଇ ତାର୍‌ ନାଉଁ ଜଅନ ଦିଆ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ଲକ୍‌ମନ୍‌ ତାକେ କଇଲାଇ “ତମର୍‌ ବଁସ୍‌ ବିତ୍‌ରେ ତା ଏନ୍ତାରି ନାଉଁର୍‌ ଲକ୍‌ କେ ମିସା ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ତେଇ ସେମନ୍‌ ପିଲାକେ କାଇ ନାଉଁ ଦେଉଁ ବଲି ମନ୍‌ କଲୁସ୍‌ନି ? ସେଟା ଜିକରିୟକେ ଆତ୍‌ ଦେକାଇକରି ପାଚାର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ସେଡ୍‌କିବେଲେ ଜିକରିୟ ଲକ୍‌ମନ୍‌କେ ଗଟେକ୍‌ ଲେକ୍‌ବା ପାଟା ମାଙ୍ଗ୍‌ଲା ଆରି “ଏଦେ ଦେକା ! ତାର୍‌ ନାଉଁ ଜଅନ୍‌ !” ବଲି ଲେକ୍‌ଲା । ତେଇ ସବୁଲକ୍‌ କାବା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ସେଡ୍‌କି ଦାପ୍‌ରେ ଜିକରିୟର୍‌ ଟଣ୍ଡ୍‌ ପୁଟ୍‌ଲା, ସେ ଆରି ତରେକ୍‌ କାତା ଅଇ ପର୍‌ମେସର୍‌କେ ମଇମା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ତାର୍‌ ଲଗର୍‌ ପାକର୍‌ ଲକ୍‌ମନ୍‌ ଡରିଗାଲାଇ, ଆରି ଏସବୁ କାତା ଜିଉଦା ରାଇଜର୍‌ ଡଙ୍ଗର୍‌ ଜାଗାର୍‌ ସବୁ ବାଟର୍‌ ଲକ୍‌ମନ୍‌ କୁଆବଲା ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ଆରି ସୁନିରଇବା ସବୁ ଲକ୍‌ମନ୍‌ କାବା ଅଇକରି, ମନେ ମନେ ବାବ୍‌ଲାଇ, ତେବେ ଏ ପିଲା କାଇଟା ଅଇସି ? କାଇକେବଇଲେ ମାପ୍‌ରୁର୍‌ ବପୁ ପିଲାର୍‌ସଙ୍ଗ୍‌ ଆଚେ ବଲି ସବୁକେ ଜାନାପଡ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ଆରି ଜଅନର୍‌ ବାବା ଜିକରିୟ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇ ପର୍‌ମେସରର୍‌ କବର୍‌ କଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ଆସା ଆମେ ଇସ୍‌ରାଏଲର୍‌ ମାପ୍‌ରୁକେ ଦନିଅବାଦ୍‌ ଦେଉ କାଇକେବଇଲେ ସେ ତାର୍‌ ନିଜର୍‌ ଲକ୍‌ମନ୍‌କେ ଦୟାକରି ମୁକ୍‌ଲାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ତାର୍‍ ନିଜର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ଦାଉଦର୍‌ କୁଟୁମେ ଅନି ଆମର୍‌ ପାଇ ଗଟେକ୍‌ ବପୁ ସଙ୍ଗର୍‌ ଉଦାର୍‌କାରିଆକେ ଦେଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ପୁରବ୍‌ କାଲେଅନି ସୁକଲ୍‌ ରଇବା ନିଜର୍‌ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ଟଣ୍ଡେଅନି କାତା ଦେଇ ଜେନ୍ତି କଇରଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ସେନ୍ତାରି ଆମ୍‌କେ ଇନ୍‌ କର୍‌ବା ସବୁ ସତ୍‌ରୁମନର୍‌ ଟାନେଅନି ମୁକ୍‌ଲାଇ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ଜେନ୍ତି ସେ ଆମର୍‌ ଆନିଦାଦିମନର୍‌ପାଇ ଦୟା ଦେକାଇଆଚେ, ଆରି ସେମନର୍‌ ସଙ୍ଗ୍‌ କରିରଇବା ନିଜର୍‍ ସୁକଲ୍‌ ନିୟମ୍‌ ଏତାଇ ଆଚେ, ");
INSERT INTO dso_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ଆମର୍‌ ପୁର୍‌ବର୍‌ ବାବା ଅବ୍‌ରାଆମ୍‍କେ ଜନ୍‌ କାତା ଦେଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ଆରି ଜେନ୍ତାରିକି ସତ୍‌ରୁର୍‌ ଆତେଅନି ଉଦାର୍‌ ପାଇ ଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ଜେନ୍ତାରିକି ଆମେ ଜିବନ୍‌ସାରା ଦରମ୍‌ ସଙ୍ଗ୍‍, ସୁକଲ୍‌ ସଙ୍ଗ୍‍ ତାର୍‌ ସେବା କର୍‌ବାକେ, ଆମ୍‌କେ ଦୟା କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ଏ ମର୍‌ ନୁନା, ତୁଇ ସବୁର୍‌ ଉପ୍‌ରେ ରଇବା ପର୍‌ମେସରର୍‌ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ବଲି ଡାକ୍‌ପୁଟା ଅଇସୁ । ତୁଇ ସେ ପାଟାଇରଇବା ଗଟେକ୍‌ ଦୁତ୍‌ପାରା, ତାର୍‌ପାଇ ବାଟ୍‌ ତିଆର୍‌ କର୍‌ସୁ । ");
INSERT INTO dso_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ପାପ୍‌ଟାନେଅନି କେମା ପାଇକରି ଜେନ୍ତି କି ଉଦାର୍‌ ଅଇବାଇ, ସେ କାତା ଜାନାଇବାକେ ଜାଇସୁ । ");
INSERT INTO dso_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ଆମର୍‌ ପାଦ୍‌ ସାନ୍ତିର୍‌ ବାଟେ ଆନ୍‌ବାକେ, ଆମର୍‌ ପର୍‌ମେସରର୍‌ ଆଲାଦର୍‌ ଦୟାର୍‍ଲାଗି, ଆମର୍‌ପାଇ ସର୍‍ଗେଅନି ବେଲ୍‌ ତାରାସ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ସେ ପୁରାପୁରୁନ୍‌ ଆଲାଦର୍‌ ଦୟାର୍‍ଲାଗି ମାପ୍‌ରୁର୍‌ ଲକ୍‌ମନ୍‌କେ, ସେମନର୍‌ ପାପ୍‌ଟାନେଅନି ମୁକ୍‌ଲାଇବା ଗିଆନ୍‌ ଦେଇସୁ । ତାର୍‌ ବାଟ୍‌ ତିଆର୍‌ କର୍‌ବାକେ ମୁଲିଆଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ଆରି ଜଅନ୍‌ ବଡିକରି ଆତ୍‌ମାଇ ବପୁ ଅଇଲା ଆରି ଲକ୍‌ମନର୍‌ ଟାନେ ଜାନାଇ ନ ଅଇକରି କିନରା ଜାଗାମନ୍‌କେ ରଇତେ ରଇଲା । ପଚେ ସେ ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନର୍‌ଟାନେ ବାକିଅ ସୁନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ସେବେଲେ ରମିୟ ରାଇଜର୍‌ ବଡ୍‌ ସାସନ୍‌ କାରିଆ ଅଗସ୍‌ଟ କାଇସରର୍‌ ଆଦେସ୍‌ ଇସାବେ ସବୁଲକ୍‌କେ ନାଉଁ ଲେକାଇବାର୍‍ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","କିରିଣିୟ ନାଉଁର୍‌ ସାସନ୍‌ କାରିଆ ସିରିଆ ରାଇଜ୍‌ ସାସନ୍‌ କର୍‌ବା ବେଲେ ପର୍‌ତୁମ୍‌ ତର୍‌ ଏନ୍ତାରି ନାଉଁ ଲେକା ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ସେଟାର୍‌ପାଇ ବଲି ସବୁଲକ୍‌ ନାଉଁ ଲେକାଇବାକେ ନିଜର୍‌ ନିଜର୍‌ ନଅରେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ଆରି ଜସେପ୍‌ ମିସା ନାଉଁ ଲେକାଇବାକେ ମରିୟମର୍‌ ସଙ୍ଗ୍‌ ଗାଲିଲି ରାଇଜର୍‌ ନାଜରିତ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ନଅରେ ଅନି ଜିଉଦା ରାଇଜର୍‌ ବେତ୍‌ଲିଇମ୍‌ ବଲି ଦାଉଦ୍‌ ରାଜାର୍‌ ଜନମ୍‌ ନଅରେ ଗାଲାଇ । କାଇକେବଇଲେ, ଜସେପ୍‌ ଦାଉଦ୍‌ ବଁସର୍‌ ଆରି ସେ କୁଟୁମର୍‌ ଲକ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ତାର୍‌ସଙ୍ଗ୍‌ ମରିୟମର୍‌ ବିବା ମାଙ୍ଗ୍‌ନି ଅଇରଇଲା, ଆରି ମରିୟମ୍‌ ଗାଗ୍‌ଡେ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ଜସେପ୍‌ ଆରି ମରିୟମ୍‌ ବେତ୍‌ଲିଇମେ ରଇଲାବେଲେ, ମରିୟମର୍‌ ଆତ୍‌ଗଡ୍‌ ସୁକ୍‌ ଅଇବା ଦିନ୍‌ କେଟି ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ଆରି ମରିୟମ୍‌ ତାର୍‌ ପଣୁଆ ପିଲାକେ ତେଇ ଜନମ୍‌ଦେଲା, ଆରି ତାକେ ଲୁଗାସଙ୍ଗ୍‌ ଗୁଡିଆଇକରି ଗରୁସାଲର୍‌ ଡଙ୍ଗାକୁଣ୍ଡେ ଡୁଲାଇରଇଲା, କାଇକେବଇଲେ ସେମନ୍‌କେ ରଇବାପାଇ ବାସାଗରେ ଟାନ୍‌ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ବେତ୍‌ଲିଇମ୍‌ ଲଗେ କେତେଟା ମେଣ୍ଡା ଚାରାଉ ଗଉଡ୍‌ମନ୍‌ ସେ ରାତିଆ ପଦାଇ ରଇ ତାକର୍‌ ମେଣ୍ଡା ଗଟାନି ଜାଗ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ଆରି ଏଦେ ଦେକା ! ମାପ୍‌ରୁର୍‌ ଦୁତ୍‌ ଗଟେକ୍‌ ଆସି ସେମନର୍‌ ଲଗେ ଟିଆଅଇଲା, ଆରି ମାପ୍‌ରୁର୍‌ ମଇମାର୍‍ ଉଜଲ୍‌ ତାକର୍‌ ଚାରିବେଡ୍‌ତି ଜଲ୍‌ସିଗାଲାଜେ ଗଉଡ୍‌ମନ୍‌ ବେସି ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ତେଇ ଦୁତ୍‌ ସେମନ୍‌କେ କଇଲା, “ଡରାନାଇ ! ଦେକା ମୁଇ ସବୁଲକର୍‌ପାଇ ଗଟେକ୍‌ ବେସି ସାର୍‌ଦାର୍‌ କବର୍‌ ତମ୍‌କେ ଜାନାଇଲିନି, ଜନ୍‌ଟାକି ସବୁଲକର୍‌ପାଇ ସାର୍‌ଦାର୍‌ ବିସଇ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","କାଇକେବଇଲେ, ଆଜିସେ ଦାଉଦ୍‌ ରାଜାର୍‌ ଜନମ୍‌ ନଅରେ ତମର୍‌ପାଇ ଗଟେକ୍‌ ଉଦାର୍‌କାରିଆ ଜନମ୍‌କଲା ଆଚେ, ସେ କିରିସ୍‌ଟ ମାପ୍‌ରୁ । ");
INSERT INTO dso_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ଆରି ତମର୍‌ପାଇ ବଲି ଏଟା ଗଟେକ୍‌ ଚିନ୍‌ପାରା ଅଇସି, ତମେ ଲୁଗା ଗୁଡିଆଇକରି ଗଟେକ୍‌ ପିଲା ଗରୁସାଲର୍‌ ଡଙ୍ଗାଇ ଡୁଲାଇ ରଇବାଟା କଜି ମିଲାଇସା ।” ");
INSERT INTO dso_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ସେଡ୍‌କିବେଲେ ଅଟାତ୍‌ ସର୍‌ଗେଅନି ଦୁତ୍‌ମନ୍‌ ମାନ୍ଦାଅଇ, ସେ ସରଗର୍‌ ଦୁତ୍‌ଟାନେ କେଟି ପର୍‌ମେସର୍‌କେ ସୁମର୍‌ନା କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ସର୍‌ଗେ ରଇବା ପର୍‌ମେସରର୍‌ ଜୟ ଜୟ କରୁ, ଆରି ଦର୍‌ତନିଟାନେ ରଇବା ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ପର୍‌ମେସର୍‌ ବାଚ୍‌ଲାଆଚେ ସେମନ୍‌କେ ସାନ୍ତି ମିଲ ।” ");
INSERT INTO dso_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ଦୁତ୍‌ମନ୍‌ ମେଣ୍ଡା ଚାରାଉ ଗଉଡ୍‌ମନ୍‌କେ ଚାଡି ସର୍‌ଗେ ଉଟିଗାଲା ପଚେ, ଗଉଡ୍‌ମନ୍‌ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇବାର୍‌ ଦାର୍‌ଲାଇ, “ଆସା ଆମେ ସବୁ ବେତ୍‌ଲିଇମ୍‌ ଜାକ ଜାଇକରି, ପର୍‌ମେସର୍‌ ଜାନାଇରଇଲା ବିସଇ ଦେକୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ତେଇଅନି ସେମନ୍‌ ଦାପ୍‌ରେ ଜାଇ କଜିକରି ମରିୟମ୍‌, ଜସେପ୍‌ ଆରି ଗରୁସାଲର୍‌ ଡଙ୍ଗାଇ ପିଲା ଡୁଲିରଇଲାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ସେମନ୍‌ ପିଲାକେ ଦେକିକରି, ଦୁତ୍‌ ଜାଇ ଜାଇଟା କଇରଇଲା, ତେଇ ରଇଲା ସବୁଲକ୍‌କେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ଆରି ଜେତ୍‌କି ଲକ୍‌ ତେଇ ରଇଲାଇ ଗଉଡ୍‌ମନର୍‌ ଟାନେଅନି ସେ ସବୁ କାତା ସୁନି କାବା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ମାତର୍‌ ମରିୟମ୍‌ ଏ ସବୁ କାତା ନିଜର୍‌ ମନେ ସଙ୍ଗଇ, ସେ ବିସଇସେ ଚିନ୍ତା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ଆରି ମେଣ୍ଡା ଚାରାଉମନ୍‌କେ ଦୁତ୍‌ ଜେନ୍ତି କଇରଇଲା, ସେନ୍ତା ସୁନ୍‌ଲାଇ ଆରି ଦେକ୍‌ଲାଇ । ସେ ସବୁର୍‌ଲାଗି ପର୍‌ମେସରର୍‌ ମଇମା କରି କରି ବାଅଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଆଟ୍‌ ଦିନ୍‌ ଅଇଲାପଚେ ଜିଉଦିମନର୍‌ ନିୟମ୍‌ ଇସାବେ ପିଲାକେ ସୁନତ୍‌ କର୍‌ବାକେ ମନ୍ଦିରେ ନେଲାଇ । ଆରି ପିଲାର୍‌ ନାଉଁ ଜିସୁ ବଲି ଦିଆଅଇଲା । ଏ ନାଉଁ ମରିୟମ୍‌ ଗାଗ୍‌ଡେ ନ ଅଇତେ, ସର୍‌ଗର୍‌ ଦୁତ୍‌ କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ପଚେ ଜେଡେବଲ୍‌ ମସାର୍‌ ବିଦି ଇସାବେ, ଜସେପ୍‌ ଆରି ମରିୟମର୍‌ ସୁତକ୍‌ ଅଇରଇବା ବେଲା ପୁରୁନ୍‌ ଅଇଆଇଲା, ପିଲାକେ ପର୍‌ମେସର୍‌କେ ସର୍‌ପି ଦେବାକେ ଜିରୁସାଲାମ୍‌ ମନ୍ଦିରେ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ମାପ୍‌ରୁର୍‌ ଲେକା ଅଇରଇବା ସାସ୍‌ତର୍‌ ଇସାବେ, ସେ ବେଲେ ଜନ୍‌ ଗରେ ମିସା, ପର୍‌ତୁମ୍‌ ଜନମ୍‌ ଅଇଲା ପଣୁଆ ପିଲାମନ୍‌ ପର୍‌ମେସରର୍‌ ସେବାର୍‌ ପାଇ ସର୍‌ପି ଅଇବାଇ ବଲି ମାନ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ଜସେପ୍‌ ଆରି ମରିୟମ୍‌ ଜିସୁକେ ଲେକା ଅଇରଇବା ସାସ୍‌ତର୍‌ ଇସାବେ ପର୍‌ମେସର୍‍କେ ସର୍‌ପି ଦେବାକେ ଆରି ସୁକଲ୍‌ ଅଇବା ବିରୁର୍‌ପାଇ ଦୁଇଟା ପରୁଆ ପିଲା ଦାରି ଜିରୁସାଲାମ୍‌ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ସେବେଲେସେ ଜିରୁସାଲାମେ ସିମିୟନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଦରମ୍‌ ଲକ୍‌ ର‍ଇଲା । ସେ ମାପ୍‌ରୁ ଦେକ୍‌ବା ଇସାବେ ନିମାନ୍‌ ଲକ୍‌ । ଇସ୍‌ରାଏଲ୍‌ ଦେସେ ଉଦାର୍‌କାରିଆ ଆସି ସାନ୍ତି ଦେଅ ବଲି ଜାଗିରଇଲା । ଆରି ତାର୍‌ଟାନେ ସୁକଲ୍‌ ଆତ୍‌ମା ବାସାଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ସୁକଲ୍‌ ଆତ୍‌ମା ତାକେ ଜାନାଇଦେଇରଇଲା ଜେ, ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ଉଦାର୍‌କାରିଆର୍‌ ଦର୍‌ସନ୍‌ ନ ମିଲ୍‌ବାଜାକ ତାର୍‌ ମରନ୍‌ ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ତାକେ ଆତ୍‌ମା ଚାଲାଇ ଆନ୍‌ଲାଜେ ସେ ଦେଉଲର୍‌ ଡାଣ୍ଡେ ଆଇଲା, ଆରି ଜେଡେବଲ୍‌ ସାନ୍‌ପିଲା ଜିସୁର୍‌ ଆୟା ବାବା ତାକେ ବିତ୍‌ରେ ଆନ୍‌ଲାଇ, ");
INSERT INTO dso_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ସେଡ୍‌କିବେଲେ ସିମିୟନ୍‌ ସାନ୍‌ପିଲାକେ କଲେ ଦାରି ପର୍‌ମେସରର୍‌ ମଇମା କରି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ଏ ମାପ୍‌ରୁ ! ଏବେ ତୁଇ ନିଜର୍‌ ବାକିଅ ଇସାବେ ତର୍‌ ନିଜର୍‌ ଦାସ୍‌ ମକେ ସାନ୍ତିସଙ୍ଗ୍‌ ଜିବାକେ ଦେଲୁସ୍‌ନି ! ");
INSERT INTO dso_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","କାଇକେବଇଲେ ମର୍‌ ଆଁକି ତର୍‌ ଉଦାର୍‌ ଦେକି ଆଚେ, ");
INSERT INTO dso_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ଜନ୍‌ ଉଦାର୍‌କାରିଆକେ ତମେ ସବୁଲକର୍‌ ମୁଆଟେ ପାଟାଇ ଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ଆରି ବିଜାତି ଲକ୍‌ମନର୍‌ପାଇ ବଲି ଜାନାଇଅଇଲା ସତର୍‌ ଉଜଲ୍‌ ଆରି ତମର୍‌ ଲକ୍‌ମନ୍‌ ଇସ୍‌ରାଏଲର୍‌ ମଇମା କରି ଆଚାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ସିମିୟନର୍‌ଟାନେଅନି ଜିସୁର୍‌ ବିସଇର୍‌ କାତା ସୁନି ଜସେପ୍‌ ଆରି ମରିୟମ୍‌ କାବାଅଇ ଜାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ଆରି ସିମିୟନ୍‌ ସେଲକ୍‌କେ ଆସିର୍‌ବାଦ୍‌ ଦେଇ ଜିସୁର୍‌ ମାକେ କଇଲା, “ଏ ପିଲା ଇସ୍‌ରାଏଲ୍‌ ଦେସର୍‌ କେତେ କେତେ ଲକ୍‌ ଉବଜ୍‌ବାଟା ଆରି କେତେ କେତେ ଲକ୍‌ ବୁଡିଜିବାର୍‌ପାଇ ବଲି ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା ଲକ୍‌ ଅଇସି । କେତେ କେତେ ଲକ୍‌ମନ୍‌ ତାର୍‌ ବିରୁଦେ କଇବା, ଗଟେକ୍‌ ଚିନ୍‌ ପାରା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","କେତେ କେତେ ଲକ୍‌ ତାକେ ବିରଦ୍‌ କରି ନିଜର୍‌ ମନ୍‌ ବିତ୍‌ରର୍‌ କାତା ସବୁ ଜାନାଇବାଇ । ଆରି ତମର୍‌ ଜିବ୍‌ନେ ଗଟେକ୍‌ କାଣ୍ଡା ବୁସିଅଇରଇଲାପାରା ତମ୍‌କେ ବେସି ଦୁକ୍‌ ଆଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ସେ ଦାପ୍‌ରେ, ଏଦେ ଦେକା ! ଆନା ନାଉଁର୍‌ ଗଟେକ୍‌ ମାଇଜି ବବିସତ୍‌ବକ୍‌ତା ତାକର୍‌ ଲଗେ ଆଇଲା । ସେ ଆସେର୍‌ ବଁସର୍‌ ପିନୁଏଲର୍‌ ଟକି, ସେ ବେସି ଡକ୍‌ରି ଅଇଜାଇରଇଲା । ବିବା ଅଇ ମୁନୁସ୍‌ ସଙ୍ଗ୍‌ ସାତ୍‌ ବରସ୍‌ ରଇକରି, ରାଣ୍ଡି ଅଇଗାଲା । ଆରି ତାକେ ଚାରିକଡିଚାରି ବରସ୍‌ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ସେ ଦେଉଲେଅନି କେନେ ନ ଜାଇ, ଉପାସ୍‌ ରଇକରି ଦିନ୍‌ ରାତି ମାପ୍‌ରୁର୍‌ ଉପାସନା କର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ପିଲାକେ ମାପ୍‌ରୁର୍‌ଟାନେ ସର୍‌ପି ଦେବାବେଲେ ସେ ଦେଉଲର୍‌ ଡାଣ୍ଡେ କେଟି, ପର୍‌ମେସରର୍‌ ମଇମା କରିକରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଜିରୁସାଲାମର୍‌ ମୁକ୍‌ତି ମିଲ ବଲି ଜାଗ୍‌ତେରଇଲାଇ, ସେ ଲକ୍‌ମନ୍‌କେ ପିଲାର୍‌ ବିସଇ କଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ପଚେ ଜସେପ୍‌ ଆରି ମରିୟମ୍‌ ମାପ୍‌ରୁର୍‌ ରିତିନିତି ଇସାବେ କର୍‌ବା ସବୁ କାମ୍‌ ସାରାଇ, ଗାଲିଲି ନିଜର୍‌ ନଅର୍‌ ନାଜରିତେ ବାଅଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ଆରି ପିଲା ଦିନ୍‌କେ ଦିନ୍‌ ବଡିକରି ବପୁଅଇଲା, ଆରି ଗିଆନେ ପୁରାପୁରୁନ୍‌ ଅଇଲା । ତାକେ ପର୍‌ମେସରର୍‌ ଦୟା ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ଜିସୁର୍‌ ବାବା, ମା ସବୁବର୍‌ସେ ଜିଉଦିମନର୍‌ ନିସ୍‌ତାର୍‌ ପରବ୍‌ ପାଇ ଜିରୁସାଲାମେ ଜାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ତରେକ୍‌ ଜିସୁକେ ବାର ବରସ୍‌ ଅଇଲାବେଲେ ସେମନର୍‌ ରିତିନିତି ଇସାବେ ଜିରୁସାଲାମେ ପରବ୍‌ ମାନ୍‌ବାର୍‌ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ସେମନ୍‌ ପରବ୍‌ ସାରାଇ ବାଉଡି ଆଇଲାବେଲେ, ପିଲା ଜିସୁ ଜିରୁସାଲାମେ ରଇଗାଲା । ମାତର୍‌ ତାର୍‌ ବାବା ମାଆ ମିସା ସେ ତେଇ ରଇଲାଟା ଜାନି ନ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ତାର୍‌ ସଙ୍ଗର୍‌ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଆଚେ କାଇକି ବଲି ବାବିକରି ସେମନ୍‌ ଗଟେକ୍‌ ଦିନର୍‌ ବାଟେ ଇଣ୍ଡି ଉଟି ଜାଇରଇଲାଇ । ସେମନ୍‍ ସାଇପଡିସା, ଚିନାର୍‌ ଜାନାର୍‌ ଲକ୍‌ମନ୍‌କେ ପାଚାରି କଜ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ଡିସେନାଇକେ ଆରି କଜି କଜି ଜିରୁସାଲାମେ ବାଉଡିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ତିନ୍‌ଦିନ୍‌ ପଚେ ସେମନ୍‌ ତାକେ ମନ୍ଦିରେ ଦେକ୍‌ଲାଇ, ସେ ସାସ୍‌ତର୍‌ ସିକାଉମନର୍‌ ମଜାଇ ବସି, ତାକର୍‌ କାତା ସୁନ୍‌ତେରଇଲା, ଆରି ପର୍‌ସନ୍‌ ପାଚାର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ଆରି ତେଇ ଜେତ୍‌କି ଲକ୍‌ ତାର୍‌ କାତା ସୁନ୍‌ତେରଇଲାଇ, ସବୁଲକ୍‌ ସେ କାତା ଅଇବାଟା ଆରି ତାର୍‌ ବୁଦି ଦେକି କାବାଅଇ ଜାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ଜସେପ୍‌ ଆରି ମରିୟମ୍‌ ମିସା ଜିସୁକେ ଦେକି କାବା ଅଇଗାଲାଇ, ଆରି ତାର୍‌ ମାଆ ତାକେ କଇଲା, “ତୁଇ କାଇକେ ନୁନା ଆମ୍‌କେ ଏନ୍ତାରି କଲୁସ୍‌ ? ଦେକ୍‌ନି ତର୍‌ ବାବା ଆରି ମୁଇ କେତେକ୍‌ କିଲ୍‌ବିଲ୍‌ ଅଇ କଜ୍‌ଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ତେଇ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “କାଇକେ ମକେ କଜ୍‌ତେରଇଲାସ୍‌ ? ମର୍‌ ବାବାର୍‌ ଗରେ ମୁଇ ରଇବାର୍‌ ଆଚେଆକା, ଏଟା ନାଜାନି ରଇଲାସ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ ଜନ୍‌ କାତା କଇଲା, ସେଟା ସେମନ୍‌ ବୁଜିନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ପଚେ ଜିସୁ ତାର୍‌ ବାବା ମାଆ ସଙ୍ଗ୍‌ ନାଜରିତେ ବାଉଡି ଆଇଲା ଆରି ତାକର୍‍ କାତା ମାନ୍‌ତେରଇଲା, ମରିୟମ୍‌ ମିସା ଏ ସବୁ କାତା ନିଜର୍‌ ମନ୍‌ ବିତ୍‌ରେ ସଙ୍ଗଇ ଚିନ୍ତା କଲା । ");
INSERT INTO dso_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ଜିସୁ, ଗିଆନେ, ଗାଗ୍‌ଡେ, ପର୍‌ମେସର୍‌ ଆରି ଲକ୍‌ମନର୍‌ ଦୟାଇ ବଡିଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ବଡ୍‌ ସାସନ୍‌କାରିଆ ତିବିରିଆ କାଇସର୍‌ ସାସନ୍‌ କର୍‌ବା ପନ୍ଦ୍‌ର ବରସ୍‌ ଅଇଲାବେଲେ, ପାନ୍ତିୟ ପିଲାତ୍‌ ଜିଉଦା ରାଇଜ୍‌ ସାସନ୍‌ କର୍‌ତେରଇଲା । ଆରି ଏରଦ୍‌ ଗାଲିଲିର୍‌ ସାସନ୍‌କାରିଆ ରଇଲା । ଏରଦର୍‌ ବାଇ ପିଲିପ୍‌ ଇତୁରିଆ ଆରି ତାକ୍‌ନିତ୍‌ ରାଇଜର୍‌ ସାମନ୍ତ୍‌ ରାଜା ରଇଲା । ଲୁସାନିଆ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଅବିଲିନି ରାଇଜର୍‌ ସାମନ୍ତ୍‌ ରାଜା ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ଆନାନ୍‌ ଆରି କୟାପ୍‌ ନାଉଁର୍‌ ଦୁଇ ଲକ୍‌ ବଡ୍‌ ପୁଜାରି ରଇଲାଇ । ସେବେଲେ ଜିକରିୟର୍‌ ପଅ ଜଅନ୍‌, ମରୁବାଲି ବୁଏଁ ରଇଲାବେଲେ ପର୍‌ମେସରର୍‌ କାତା ସେ ସୁନ୍‍ଲା । ");
INSERT INTO dso_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ଜର୍‌ଦନ୍‌ ଗାଡ୍‌ ଲଗେ ରଇବା ଲଗର୍‌ ପାକର୍‌ ଗାଉଁଗଣ୍ଡାଇ ଜାଇ ଜଅନ୍‌ ପାପ୍‌ କେମାର୍‌ ଲାଗି, ପାପ୍‌କାମ୍‌ ଚାଡିକରି ମାପ୍‌ରୁର୍‌ ବାଟେ ଆସି ଡୁବନ୍‌ ନେବାକେ ଜାନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ଜେନ୍ତାରି ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତା ସୁନାଇରଇବା ସାସ୍‌ତରେ ଲେକା ଅଇଲାଆଚେ, “ମରୁବାଲିବୁଏଁ ଆଉଲିଅଇ କଇବା ଗଟେକ୍‌ ଲକ୍‌ ସବଦ୍‌ କରି କଇଲାନି, ମାପ୍‌ରୁ ଆଇବାଟା ତିଆର୍‌କରା, ତାର୍‌ ଆଇବା ବାଟ୍‌ ସଲ୍‌କାଆ । ");
INSERT INTO dso_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ବଡ୍‌ ବଡ୍‌ ଡଙ୍ଗର୍‌ ପର୍‌ବତ୍‌ ସବୁ ସଦ୍‌ରମ୍‌ ଅଇକରି ଗାଡ୍‌ କଣ୍ଡି କଣ୍ଡି ରଇବା ଆଁଟାଲ୍‌ ବୁଟାଲ୍‌ ସାର୍‌ଦି ଅଇସି, ବାଁକ୍‌ ଟେକ୍‌ ବାଟ୍‌ ସଲକ୍‌ ଅଇସି, ଆରି କାଲ୍‌ ଡେପ୍‌ ଜମି ସଦ୍‌ରମ୍‌ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ମଚ୍‌ପୁରର୍‌ ସବୁଲକ୍‌ ପର୍‌ମେସରର୍‌ ଉଦାର୍‍କାରିଆକେ ଦେକ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ଜଅନ୍‌ଟାନେ ଡୁବନ୍‌ ନେବାର୍‍ଲାଗି ବାରଇ ଆଇବା ଲକ୍‌ମନ୍‌କେ ସେ କଇଲା, “ଏ ବିସ୍‌ ରଇଲା ସାଁପର୍‌ ବଁସର୍‌ ଲକ୍‌ମନ୍‌, ଆଇବା ପର୍‌ମେସରର୍‌ କପେଅନି ପାଲାଇବାକେ ତମ୍‌କେ କେ ଚେତ୍‌ନା ଦେଲା ? ");
INSERT INTO dso_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ତେବର୍‌ପାଇ ପାପ୍‌କାମ୍‌ ଚାଡି ନିକ କାମ୍‌ କରା, ଅବ୍‌ରାଆମ୍‌ତା ଆମର୍‌ ଆନିଦାଦି ବଲି ମନେ ମନେ ବାବାନାଇ, କାଇକେବଇଲେ ମୁଇ ତମ୍‌କେ କଇଲିନି, ପର୍‌ମେସର୍‌ ଏ ପାକ୍‌ନାମନର୍‌ଟାନେଅନି ମିସା ଅବ୍‌ରାମର୍‌ ପିଲାଜିଲା ଉବ୍‌ଜାଇ ପାର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ଏବେମିସା ଗଚ୍‌ମନର୍‌ ବୁନ୍ଦେ କୁରାଡି ଲାଗିଆଚେ, ତେବର୍‌ପାଇ ଜନ୍‌ ଗଚ୍‌ ନିମାନ୍‌ ପଲ୍‌ ନ ପଲେ, ସେଟା କାଟିକରି ଜଇଟାନେ ପିଙ୍ଗାଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ତେଇ ଲକ୍‌ମନ୍‌ ଜଅନ୍‌କେ ପାଚାର୍‌ଲାଇ, “ସେନ୍ତାର୍‌ ଆଲେ ଆମେ କାଇଟା କର୍‌ବୁ ?” ");
INSERT INTO dso_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ଜଅନ୍‌ ସେମନ୍‌କେ କ‍ଇଲା “ଜାର୍‌ଟାନେ ଦୁଇଟା ପିନ୍ଦ୍‌ବା ଲୁଗା ଆଚେ, ଜାକେ ନାଇ, ତାକେ ସେ ଗଟେକ୍‌ ଦେଅ, ଆରି ଜାର୍‌ଟାନେ କାଦି ଆଚେ, ସେ ମିସା ସେନ୍ତାରି ବାଟା କରି ଦେଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ମିସା ଡୁବନ୍‌ ନେବାକେ ଆସି ତାକେ ପାଚାର୍‌ଲାଇ “ଏ ଗୁରୁ ଆମେ କାଇଟା କର୍‌ବୁ ?” ");
INSERT INTO dso_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ଜଅନ୍‌ ସେମନ୍‌କେ କଇଲା, “ତମର୍‌ ଜେତ୍‌କି ନେବାର୍‌ ଅଦିକାର୍‌ ଆଚେ, ତାର୍‌ତେଇଅନି ଅଦିକ୍‌ ମାଙ୍ଗା ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ସନିଅମନ୍‌ ମିସା ତାକେ ପାଚାର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ, “ଆରି ଆମେ କାଇଟା କର୍‌ବୁ ?” ଜଅନ୍‌ ସେମନ୍‌କେ କଇଲା, “ବପୁ ଦେକାଇ କାଇଟା ମିସା ଜିକି ଆନା ନାଇ କି ନାଡାଇକରି କାର୍‌ ଦନ୍‌ସଁପତି ଆନା ନାଇ, ତମ୍‌କେ ଜେତ୍‌କି କୁଲି ମିଲ୍‌ଲାନି ସେତ୍‌କି ନେଇକରି ସାର୍‌ଦା ସଙ୍ଗ୍‌ ରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ଲକ୍‌ମନ୍‌ ଆସାଅଇ କିରିସ୍‌ଟକେ ଜାଗ୍‌ତେ ରଇଲାଇ ଜେ, କେଡେବେଲେ ଏ ମିସା କିରିସ୍‌ଟ ଅଇରଇସି ବଲି ବାବି, ଜଅନର୍‌ ବିସଇ ଚିନ୍ତା କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ତେବେ ଜଅନ୍‌ ସବୁଲକ୍‌ମନ୍‌କେ କ‍ଇଲା, “ମୁଇସିନା ତମ୍‌କେ ପାନିଟାନେ ଡୁବନ୍‌ ଦେଲିନି, ମାତର୍‌ ମର୍‌ଟାନେଅନି ଅଦିକ୍‌ ବପୁର୍‌ଲକ୍‌ ଆଇଲାନି, ମୁଇ ତାର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ଅଇ ପାଦର୍‌ ପାଣ୍ଡଇ ମିସା କୁସ୍‌ଲାଇବାକେ ମର୍‍ ଅଦିକାର୍‍ ନାଇ । ସେ ତମ୍‌କେ ଜଇସଙ୍ଗ୍‌ ଆରି ସୁକଲ୍‌ ଆତ୍‌ମାଇ ଡୁବନ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ତାର୍‌ ଆତେ କୁଲାଆଚେ, ତେବେ ସେ କଟାରେ ରଇଲା ଦାନ୍‌ ପରିଚଲ୍‌ କରି ଟୁଲିଆଇ କଲ୍‌କିଟାନେ ସଙ୍ଗଇସି । କାଇ କାମେ ନ ଆଇବାଟା ଜାକ ସବୁବେଲେ ଲାଗିରଇବା ଜଇଟାନେ ପଡାଇଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ଜଅନ୍‌ ଏନ୍ତାରି କେତେକ୍‌ କେତେକ୍‌ ଉପ୍‌ଦେସ୍‌ ଦେଇକରି ଲକ୍‌ମନ୍‌କେ ମାପ୍‌ରୁର୍‌ବାଟେ ଆଇବାକେ ମନ୍‌ କରାଇତେରଇଲା ଆରି ମାପ୍‌ରୁର୍‌ ନିକ କାତା ସୁନାଇତେରଇଲା ଆରି ପାପ୍‌ କର୍‌ବାଟାନେଅନି ବାଅଡ୍‌ବାକେ ବୁଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ମାତର୍‌ ସାମନ୍ତ ରାଜା ଏରଦ୍‌ ନିଜର୍‌ ବାଇର୍‌ ମାଇଜି ଏରଦିଆକେ ସଙ୍ଗଇଲାକେ ତାର୍‌ କରିରଇବା ବିନ୍‌ ବିନ୍‌ ପାପ୍‌କାମର୍‌ ବିସଇ ଜାନି ଜଅନ୍‌ ତାକେ ଦମ୍‌କାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ଏରଦ୍‌ ଜଅନ୍‌କେ ବନ୍ଦିକରି ସେ କରିରଇବା ସବୁ ପାପ୍‌କାମର୍‌ ସଙ୍ଗ୍‌ ଏ ବଡ୍‌ ପାପ୍‌ ମିସା ଜଡ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ସବୁଲକ୍‌ ଡୁବନ୍‌ ନେଲା ପଚେ ଜିସୁ ମିସା ଡୁବନ୍‌ ନେଲା । ଆରି ପାର୍‌ତନା କର୍‌ବାବେଲେ, ଏଦେ ଦେକା ! ବାଦଲ୍‌ ଉଗାଡିଅଇଗାଲା, ");
INSERT INTO dso_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ଆରି ସୁକଲ୍‌ ଆତ୍‌ମା ପରୁଆର୍‌ ଗାଗଡ୍‌ ଦାରି ଉତ୍‌ରି ଆସି, ଜିସୁର୍‌ ଉପ୍‌ରେ ବସ୍‌ଲା । ସର୍‌ଗେଅନି ଗଟେକ୍‌ ଏନ୍ତାରି ସବଦ୍‌ ଆଇଲା, “ତୁଇସେ ମର୍‌ ଆଲାଦର୍‌ ପିଲା, ତର୍‌ଟାନେ ମୁଇ ବେସି ସାର୍‌ଦା ଅଇଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ଜିସୁ ପର୍‌ମେସରର୍‌ କାମ୍‌ ଆରମ୍‌ କଲାବେଲେ ତାକେ ତିରିସ୍‌ ବରସ୍‌ ଅଇରଇଲା । ଲକ୍‌ମନର୍‌ ବାବ୍‌ନା ଇସାବେ, ଜିସୁ ଜସେପର୍‌ ପଅ, ଜସେପ୍‌ ଏଲିର୍‌ ପଅ । ");
INSERT INTO dso_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲି ମତ୍‌ତାତର୍‌ ପଅ, ମତ୍‌ତାତ୍‌ ଲେବିର୍‌ ପଅ, ଲେବି ମଲ୍‌କିର୍‌ ପଅ, ମଲ୍‌କି ଜନୟର୍‌ ପଅ, ଜନୟ ଜସେପର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଜସେପ୍‌ ମତିତିଆର୍‌ ପଅ, ମତିତିଆ ଅମସର୍‌ ପଅ, ଅମସ୍‌ ନାଉମର୍‌ ପଅ, ନାଉମ୍‌ ଏସ୍‌ମିର୍‌ ପଅ, ଏସ୍‌ମି ନଗୟର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଗୟ ମଅତର୍‌ ପଅ, ମଅତ୍‌ ମତିତିଆର୍‌ ପଅ, ମତିତିଆ ସମଇର୍‌ ପଅ, ସମୟି ଜସେକର୍‌ ପଅ, ଜସେକ୍‌ ଜଦାର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଜଦା ଜଅନର୍‌ ପଅ, ଜଅନ୍‌ ରେସାର୍‌ ପଅ, ରେସା ଜିରୁବାବେଲର୍‌ ପଅ, ଜିରୁବାବେଲ୍‌ ସିଅଲ୍‌ତିଏଲର୍‌ ପଅ, ସଅଲ୍‌ତିଏଲ୍‌ ନେରିର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରି ମଲ୍‌କିର୍‌ ପଅ, ମଲ୍‌କି ଅଦିର୍‌ ପଅ, ଅଦି କସାମର୍‌ ପଅ, କସାମ୍‌ ଏଲୁଦାନର୍‌ ପଅ, ଏଲୁଦାନ୍‌ ଏରର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏର ଜିୟସୁଅର୍‌ ପଅ, ଜିୟସୁଅ ଏଲିଏଜର୍‌ ପଅ, ଏଲିଏଜ୍‌ ଜରିମର୍‌ ପଅ, ଜରିମ୍‌ ମତ୍‌ତାତର୍‌ ପଅ, ମତ୍‌ତାତ୍‌ ଲେବିର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେବି ସିମିୟନର୍‌ ପଅ, ସିମିୟନ୍‌ ଜିଉଦାର୍‌ ପଅ, ଜିଉଦା ଜସେପର୍‌ ପଅ, ଜସେପ୍‌ ଜନାମର୍‌ ପଅ, ଜନାମ୍‌ ଏଲିଆକିମର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲିଆକିମ୍‌ ମଲାଅର୍‌ ପଅ, ମଲାଅ ମନାର୍‌ ପଅ, ମନା ମତତାର୍‌ ପଅ, ମତତା ନାତନର୍‌ ପଅ, ନାତନ୍‌ ଦାଉଦର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଉଦ୍‌ ଜିୟସୁଅର୍‌ ପଅ, ଜିୟସୁଅ ଆବେଦର୍‌ ପଅ, ଆବେଦ୍‌ ବୟଜର୍‌ ପଅ, ବୟଜ୍‌ ସେଲଅର୍‌ ପଅ, ସେଲଅ ନଅସନର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନଅସ୍‌ ଅମିନାଦାବର୍‌ ପଅ, ଅମିନାଦାବ୍‌ ଅଦ୍‌ମିନର୍‌ ପଅ, ଅଦ୍‌ମିନ୍‌ ଅର୍‌ନିର୍‌ ପଅ, ଅର୍‌ନିର୍‌ ଏସ୍‌ରନର୍‌ ପଅ, ଏସ୍‌ରନ୍‌ ପେରସର୍‌ ପଅ, ପେରସ୍‌ ଜିଉଦାର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଜିଉଦା ଜାକୁବର୍‌ ପଅ, ଜାକୁବ୍‌ ଇସାକର୍‌ ପଅ, ଇସାକ୍‌ ଅବ୍‌ରାମର୍‌ ପଅ, ଅବ୍‌ରାଆମ୍ ତେରଅର୍‌ ପଅ, ତେରଅ ନାଅର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାଅର୍‌ ସରୁଗର୍‌ ପଅ, ସରୁଗ୍‌ ରଗୁର୍‌ ପଅ, ରଗୁ ପେଲଗର୍‌ ପଅ, ପେଲଗ୍‌ ଏବର୍‌ ପଅ, ଏବ ସେଲଅର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ସେଲା କଇନାନର୍‌ ପଅ, କଇନାନ୍‌ ଆର୍‌ପାକ୍‌ସଡର୍‌ ପଅ, ଆର୍‌ପାକ୍‌ସେଡର୍‌ ସେ ମର୍‌ ପଅ, ସେମ ନଅର୍‌ ପଅ, ନଅ ଲାମେକର୍‌ ପଅ, ");
INSERT INTO dso_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲାମେକ୍‌ ମିତୁସେଲଅର୍‌ ପଅ, ମିତୁସେଲଅ ଅନକର୍‌ ପଅ, ଅନକ୍‌ ଜାରେଦର୍‌ ପଅ, ଜାରେଦ୍‌ ମଅଲେଲର୍‌ ପଅ, ମଅଲେଲ୍‌ କେନାନର୍‌ ପଅ ");
INSERT INTO dso_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କେନାନ୍‌ ଏନସର୍‌ ପଅ, ଏନସ୍‌ ସେତର୍‌ ପଅ, ସେତ ଆଦମର୍‌ ପଅ, ଆଦମ୍‌ ପର୍‌ମେସରର୍‌ ପଅ । ");
INSERT INTO dso_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ଜିସୁ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇକରି ଜର୍‌ଦନ୍‌ ଗାଡେଅନି ବାଉଡି ଆଇଲା । ଆରି ସଇତାନର୍‌ ଟାନେ ପରିକା କରାଇବାକେ ତାକେ ଆତ୍‌ମା ଚାଲାଇ ନେଲା । ତେଇ ଚାଲିସ୍‌ ଦିନ୍‌ ଜାକ ସଇତାନ୍‌ ତାକେ ପରିକା କର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ସର୍‌ତେ ଦିନ୍‌ ସାର୍‌ଲା ପଚେ ସେ ବୁକ୍‌କେ ବାୟାଚୁରା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ତେଇ ସଇତାନ୍‌ ଜିସୁକେ କଇଲା, “ତୁଇ ଜଦି ପର୍‌ମେସରର୍‌ ପ, ତେବେ ଏ ପାକ୍‌ନା କାଦି ଅ ବଲି ଆଦେସ୍‌ ଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ଜିସୁ ତାକେ କ‍ଇଲା, “ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଲେକାଅଇ ଆଚେ, ମୁନୁସ୍‌ ଅବ୍‌କା କାଦି କାଇ ନ ବଁଚେ । ” ");
INSERT INTO dso_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ତାର୍‌ପଚେ ସଇତାନ୍‌ ଜିସୁକେ ଗଟେକ୍‍ ଉଁଚ୍‌ ଜାଗାଇ ଡାକି ଦାରିଜାଇ କରି ଆଁକିମିଟ୍‌କା ମାର୍‌ବା ଏତ୍‌କି ପର୍‌କେ ଜଗତର୍‌ ସବୁ ରାଇଜ୍‌ ଦେକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ଆରି ଜିସୁକେ କଇଲା, “ମୁଇ ତକେ ଏ ସବୁ ଦନ୍‌ ସଁପତିର୍‌ ଅଦିକାର୍‌ ଆରି ମଇମା ଦେବି । କାଇକେବଇଲେ ସେଟା ସବୁ ମକେ ସର୍‌ପିଦେଲାଆଚେ, ଆରି ମୁଇ ଜାକେ ମନ୍‌ କର୍‌ବି, ତାକେ ଦେବି । ");
INSERT INTO dso_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ତେବର୍‌ପାଇ, ଜେବେ ତୁଇ ମକେ ଜୁଆର୍‌ କର୍‌ସୁ, ତେବେ ସେ ସବୁଜାକ ତର୍‌ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ଜିସୁ ତାକେ କ‍ଇଲା, “ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଲେକାଅଇଆଚେ, ତୁଇ ତର୍‌ ପର୍‌ମେସର୍‌କେସେ ଜୁଆର୍‌ କର୍‌ସୁ, ଆରି ତାକେସେ ସେବା କର୍‌ସୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ପଚେ ସଇତାନ୍‌ ଜିସୁକେ ଜିରୁସାଲାମେ ଡାକିଦାରିଜାଇ, ମନ୍ଦିରର୍‌ ଚାଉନି ଟିପେ ଟିଆକରାଇ କଇଲା, “ତୁଇ ଜଦି ପର୍‌ମେସରର୍‌ ପ, ତେବେ ଇତିଅନି ତଲେ ଡେଗଇଦେସ୍‌, ");
INSERT INTO dso_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","କାଇକେବଇଲେ ସାସ୍‌ତରେ ଲେକାଆଚେ ତକେ ରକିଆ କର୍‌ବାକେ ପର୍‌ମେସର୍‌ ତାର୍‌ ନିଜର୍‌ ଦୁତ୍‌ମନ୍‌କେ ଆଦେସ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ଆରି ମିସା ଲେକା ଆଚେ, ‘ଜେନ୍ତିକି ତର୍‌ ପାଦ୍‌ ପାକ୍‌ନାଇ ନ ପାଏ, ସେଟାର୍‌ପାଇ ଦୁତ୍‌ମନ୍‌ ତକେ ଆତେଦାରି ଟେକି ନେବାଇ ।’ ” ");
INSERT INTO dso_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ଜିସୁ ସଇତାନ୍‌କେ କଇଲା, “ଏଟା ମିସା ଲେକାଆଚେ, ତୁଇ ତର୍‌ ମାପ୍‌ରୁ ନିଜର୍‌ ପର୍‌ମେସର୍‌କେ ପରିକା କର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ସଇତାନ୍‌ ସବୁ ରକାମର୍‌ ପରିକା ସାରାଇଲା ପଚେ, ଆରି ତରେକ୍‌ ବେଲା ମିଲ୍‌ବାଜାକ କେତେ ଦିନର୍‌ ପାଇ ଜିସୁକେ ଚାଡି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ତାର୍‌ପଚେ ଜିସୁ ଆତ୍‌ମାଇ ବପୁଅଇକରି ଗାଲିଲି ରାଇଜେ ବାଉଡିଗାଲା । ଆରି ତାର୍‌ କବର୍‌ ଗାଲିଲି ରାଇଜର୍‌ ଗୁଲାଇ ଗାଉଁମନ୍‌ ଜାନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ପଚେ ଜିସୁ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ବୁଲି ବୁଲି ସିକିଆ ଦେଇକରି ସବୁ ଲକର୍‌ଟାନେ ଅନି ଡାକ୍‌ପୁଟା ପାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ଏତ୍‌କିବିତ୍‌ରେ ନାଜରିତେ, ଜନ୍‌ ଜାଗାଇ କି ଜିସୁ ସାନ୍‌ବେଲେ ଅନି ବଡ୍‌ ଅଇରଇଲା, ସେ ଜାଗାଇ ଗାଲା । ଆରି ନିଜର୍‌ ରିତିନିତି ଇସାବେ, ବିସ୍‌ରାମ୍‌ ବାରେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ କେଟି ଦରମ୍‌ ସାସ୍‌ତର୍‌ ପଡ୍‌ବାକେ ଟିଆ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ସେଡ୍‌କିବେଲେ ତାକେ ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତା ଲେକିରଇଲା ଦରମ୍‌ ସାସ୍‌ତର୍‌ ଦିଆଅଇଲା, ଆରି ଜିସୁ ସେ ଜିସାୟ ବଇଟାନେ ଲେକାଅଇରଇଲା ଏନ୍ତାରି ବାକିଅ ମେଲାକରି ପାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ମାପ୍‌ରୁର୍‌ ଆତ୍‌ମା ମର୍‍ ସଙ୍ଗ୍‍ ଆଚେ, ତେବର୍‌ପାଇ ନଇଲା ମଇଲା ଲକ୍‌ମନର୍‌ଟାନେ ସୁବ୍‌ କବର୍‌ ଜାନାଇବାକେ, ପର୍‌ମେସର୍‌ ମକେ ବାଚିକରି ପାଟାଇଲା, ବନ୍ଦି ଗରେ ରଇବା ଲକ୍‌ମନ୍‌କେ ମୁକ୍‌ଲାଇବାକେ, କାଣା ଲକ୍‌ମନ୍‌କେ ଦେକାଇବା ବିସଇ ଜାନାଇବାକେ ଆରି ଦୁକର୍‌ ଲକ୍‌ମନ୍‌କେ ମୁକ୍‌ଲାଇବାକେ, ");
INSERT INTO dso_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ଆରି ମାପ୍‌ରୁ ତାର୍‌ ଲକ୍‌ମନ୍‌କେ ରକିଆ କର୍‌ବା ବେଲା ଆସିଆଚେ, ବଲି ଜାନାଇବାକେ ସେ ମକେ ପାଟାଇଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ପଚେ ସେ ସାସ୍‌ତର୍‌ ଡାବି, ପାର୍‌ତନା ଚାଲାଇବା ଗଟେକ୍‌ ଲକ୍‌କେ ବାଉଡାଇଦେଇ ବସିଦେଲା । ପାର୍‌ତନା ଗରେ ରଇଲା ଲକ୍‌ମନ୍‌ ତାକେସେ ଦେକ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ଜିସୁ ଲକ୍‌ମନ୍‌କେ କଇବାର୍‌ ଦାର୍‌ଲା, “ଆଜି ତମେ ସୁନ୍‌ଲା ଏ ଦରମ୍‌ ସାସ୍‌ତରର୍‌ ବାକିଅ ପୁରାପୁରୁନ୍‌ ଅଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ଜିସୁର୍‌ ବିସଇ ନେଇକରି ସବୁଲକ୍‌ ନିକ ସାକି ଦେବାର୍‌ ଦାର୍‌ଲାଇ ଆରି ସେ କଇବା, ମନ୍‌କେ ପାଇଲା ବାକିଅ ସୁନି କାବାଅଇଲାଇ, ଆରି ସେମନ୍‌ “ଏଟାକାଇ ଜସେପର୍‌ ପ ନଏଁ ଜେ ?” ବଲି କଇବାର୍‌ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ଜିସୁ ଲକ୍‌ମନ୍‌କେ କଇଲା, “ତମେ ସେ ଗାଲା କାତା ଆରିତରେକ୍‌ କଇସା ବଲି ମୁଇ ଜାନିରଇଲି, ଏ ଅସ ଦେଉ, ନିଜେ ତୁଇ ନିକ ଅ, ଆରି କପର୍‌ନାଉମେ ଜାଇ ଜାଇଟା ଗଟିଆଚେ ବଲି ଆମେ ସୁନିଆଚୁ, ସେଟା ସବୁ ଏ ଜାଗାଇ, ତର୍‍ ନିଜର୍‌ ଜନମ୍‌ ନଅରେ ମିସା କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“ମାତର୍‌ ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ବବିସତ୍‌ବକ୍‌ତା ଅଇରଇବା କାକେମିସା ନିଜର୍‌ ଗାଏଁ ନ ନାମତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“ମାତର୍‌ ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ଜେଡେବେଲେ ବବିସତ୍‌ବକ୍‌ତା ଏଲିୟର୍‌ ବେଲେ ତିନ୍‌ବରସ୍‌ ଚ ମାସ୍‌ ଜାକ ବାଦଲେଅନି ପାନିମାରେ ନାଇକେ ଗୁଲାଇ ଦେସେ ମର୍‌ଡି ଅଇରଇଲା, ସେବେଲେ ଇସ୍‌ରାଏଲ୍‌ ଦେସେ କେତେ କେତେ ରାଣ୍ଡିମାଇଜିମନ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ରଇଲେ ମିସା ପର୍‌ମେସର୍‌ ଏଲିୟକେ କାର୍‌ଲଗେ ମିସା ନ ପାଟାଇ ସିଦନ୍‌ ଦେସର୍‌ ସାରିପତ୍‌ ବଲି ଗଟେକ୍‌ ଜାଗାଇ, ଗଟେକ୍‌ ରାଣ୍ଡିମାଇଜିର୍‌ ଲଗେ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ଆରି ମାପ୍‌ରୁର୍‌ ବବିସତ୍‌ବକ୍‌ତା ଏଲିସାୟର୍‌ ବେଲେ ଇସ୍‌ରାଏଲ୍‌ ଦେସେ କେତେ କୁସ୍‌ଟି ରଗି ରଇଲାଇ, ଏଲେ ମିସା ତାକର୍‌ ବିତ୍‌ରେ କାକେମିସା ନିକକରି ନ ରଇଲା, ସୁରିଆ ଦେସର୍‌ ନାମାନ୍‌ ନାଉଁର୍‌ ଲକ୍‌କେ ସେ ନିକକରି ରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ଏ କାତା ସୁନି ଲକ୍‌ମନ୍‌ ବେସି ରିସାଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ଆରି ସେମନ୍‌ ଉଟିକରି ଜିସୁକେ ନଅରେଅନି ବାର୍‌କରାଇଦେଲାଇ । ତାକର୍‌ ନଅରର୍‌ ଜନ୍‌ ପର୍‌ବତ୍‌ ଉପ୍‌ରେ ତିଆର୍‌ ଅଇରଇଲା, ସେ ପର୍‌ବତର୍‌ ଦାରେଅନି ତଲେ ପିଙ୍ଗିଦେଉଁ ବଲି, ତାକେ ତେଇ ଦାରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ମାତର୍‌ ଜିସୁ ସେମନର୍‌ ବିତ୍‌ରେ ପୁରି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ଜିସୁ ଗାଲିଲି ରାଇଜର୍‌ କପର୍‌ନାଉମ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ନଅରେ ଆଇଲା, ଆରି ବିସ୍‌ରାମ୍‌ବାରେ ଲକ୍‌ମନ୍‌କେ ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ଲକ୍‌ମନ୍‌ ତାର୍‌ ସିକାଇବାଟା ଦେକି କାବାଅଇଗାଲାଇ, କାଇକେବଇଲେ ତାର୍‌ ବାକିଅ ଅଦିକାର୍‌ ସଙ୍ଗ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ଦିନେକ୍‌ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ଗଟେକ୍‌ ଡୁମା ଡସିରଇବା ଲକ୍‌ ରଇଲା । ସେ ଆଉଲିଅଇ କିର୍‌କିରି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ଏ ନାଜରିତର୍‌ ଜିସୁ, ଆମର୍‌ଟାନେ ତର୍‌ କାଇ କାମ୍‌ ଆଚେ ? ତୁଇ କାଇ ଆମ୍‌କେ ମରାଇବାକେ ଆସିଆଚୁସ୍‌ ? ତୁଇ କେ ସେଟା ମୁଇ ଜାନି, ତୁଇ ପର୍‌ମେସରର୍‌ ସୁକଲ୍‌ ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ଜିସୁ ତାକେ ଦମ୍‌କାଇ କରି କଇଲା, “ଚୁପ୍‌ ର, ଆର୍‌ଟାନେଅନି ବାରଇ ଜା ।” ତେଇଅନି ସେ ଡୁମା ସେ ଲକ୍‌କେ ସବୁର୍‌ ମୁଆଟେ ଅଦ୍‌ରାଇଲା ଆରି, ତାକେ କାଇଟା ନ କରି ତାର୍‌ ଗାଗ୍‌ଡେଅନି ବାରଇ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ତେଇ ସବୁଲକ୍‌ କାବାଅଇକରି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ଏଟା କାଇ କାତା, ସେ ବପୁ ଆରି ଅଦିକାର୍‌ ସଙ୍ଗ୍‌ ଡୁମାମନ୍‌କେ ମିସା ଆଦେସ୍‌ ଦେଲାନି । ସେମନ୍‌ ମିସା ବାରଇ ଗାଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ଜିସୁର୍‌ ଏ କବର୍‌ ସେ ଜାଗାର୍‌ ଗୁଲାଇବାଟର୍‌ ଲକ୍‌ ଜାନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ପଚେ ଜିସୁ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେଅନି ଉଟି ସିମନର୍‌ ଗରେ ଗାଲା । ସିମନର୍‌ ସାତ୍‌ରିକେ ବେସି ଜର୍‌ ଅଇରଇଲାଜେ ସେମନ୍‌ ତାର୍‌ ବିସଇ ନେଇ ଜିସୁକେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ତେଇ ସେ ସିମନର୍‌ ସାତ୍‌ରିର୍‌ ଲଗେ ଟିଆଅଇ ଜର୍‌କେ ଦମ୍‌କାଇଲା ଆରି ତାକେ ଜର୍‌ ଚାଡିଗାଲା । ସେଦାପ୍‌ରେ ସେ ଉଟିକରି ସେମନ୍‌କେ ସେବା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ବେଲ୍‌ବସି ସଞ୍ଜ୍‌ ଅଇଲାଜେ ଜର୍‌ଦୁକା ଅଇରଇଲା ଲକ୍‌ମନ୍‌କେ ଜିସୁର୍‌ ଲଗେ ଆନ୍‌ଲାଇ, ଆରି ସେ ଜର୍‌ଦୁକାର୍‌ ଲକ୍‌ମନ୍‌କେ ଗଟେକ୍‌ ଗଟେକ୍‌ ଲକର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ଡୁମା ଦାରିରଇବା ବେସି ଲକ୍‌ମନ୍‌ ମିସା କିର୍‌କିରି କରି “ତୁଇ ପର୍‌ମେସରର୍‌ ପଅ !” ବଲି ଲକର୍‌ ଟାନେଅନି ଚାଡି ପାଲାଇଲାଇ । ଜିସୁ ସେମନ୍‌କେ ଦମ୍‌କାଇ କରି କାତାଅଇବାକେ ମିସା ଦେଏନାଇ, କାଇକେବଇଲେ ସେମନ୍‌ ତାକେ କିରିସ୍‌ଟ ବଲି ଜାନିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ସାକାଲ୍‌ ପାଇଲାଜେ ଜିସୁ ନଅରେ ଅନି ବାରଇ ଗଟେକ୍‌ କିନରା ଜାଗାଇ ଗାଲା । ଲକ୍‌ମନ୍‌ କଜି କଜି ତାର୍‌ ଲଗେ ଆଇଲାଇ, ଆରି ସେ ଜେନ୍ତିକି ତାକର୍‌ ଲଗେଅନି ଉଟିନଜାଅ ବଲି ଅଟ୍‌କାଇବାକେ ଚେସ୍‌ଟା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ବିନ୍‌ ବିନ୍‌ ନଅରେ ମିସା ମୁଇ ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ନିକ କବର୍‌ ଜାନାଇବାର୍‌ ଆଚେ, କାଇକେ ବଇଲେ ସେଟାର୍‌ପାଇ ପର୍‌ମେସର୍‌ ମକେ ପାଟାଇଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ଆରି ସେ ଜିଉଦା ଦେସର୍‌ ଜିଉଦି ଲକ୍‌ମନର୍‌ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ବାକିଅ ସୁନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ଦିନେକ୍‌ ଜିସୁ ଗିନେସରତ୍‌ ଗାଡ୍‌କଣ୍ଡି ଟିଆଅଇରଇଲା ବେଲେ ଲକ୍‌ମନ୍‌ ମାଣ୍ଡାଚୁଣ୍ଡା ଅଇ ପର୍‌ମେସରର୍‌ ବାକିଅ ସୁନ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ସେଡ୍‌କିବେଲେ ସେ ଗାଡ୍‌କଣ୍ଡି ଦୁଇଟା ଡଙ୍ଗା ରଇଲାଟା ଦେକ୍‌ଲା, କେଉଟ୍‌ମନ୍‌ ଡଙ୍ଗାଇଅନି ଉତ୍‌ରି ଜାଲ୍‌ ଦଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ସେ ଡଙ୍ଗାମନର୍‌ ବିତ୍‌ରେଅନି ଜନ୍‌ଟା କେଉଟ୍‌ ସିମନର୍‌ଟା ରଇଲା, ଜିସୁ ତେଇ ଚଗିକରି “କଣ୍ଡିତେଇଅନି କଣ୍ଡେକ୍‌ ଦୁର୍‌ ପାନିତେଇ ଚାଲାଇନେ ।” ବଲି ସିମନ୍‌କେ କଇଲା, ଆରି ଡଙ୍ଗାଇ ବସିକରି ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ଜିସୁ କାତା ସାରାଇକରି ସିମନ୍‌କେ କଇଲା, “ଡେଙ୍ଗ୍‌ ପାନିଟାନେ ଜାଇକରି ମାଚ୍‌ ଦାର୍‌ବାକେ ତମର୍‌ ଜାଲ୍‌ ପାକାଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ତେଇ ସିମନ୍‌ କଇଲା, “ଏ ଗୁରୁ ଆମେ ସବୁଲକ୍‌ ଗୁଲାଇରାତି କସ୍‌ଟ କରି ଗଟେକ୍‌ ମିସା ଦାରୁନାଇ, ମାତର୍‌ ତମର୍‌ କାତା ଦାରି ମୁଇ ଜାଲ୍‌ ପାକାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ଆରି ଜାଲ୍‌ ପାକାଇଲାଇକେ, ଏଦେ ଦେକା ! ଏନ୍ତି ମାଚ୍‌ ଲାଗ୍‌ଲାଇଜେ ତାକର୍‌ ଜାଲ୍‌ ଚିରିଅଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ଡଙ୍ଗାଇ ମାଚ୍‌ ବର୍‌ତି କଲାଇଜେ ସେ ଦୁଇଟା ଡଙ୍ଗା ବୁଡ୍‌ଲା ପାରା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ଏଟା ଦେକି ସିମନ୍‌ ପିତର୍‌ ଜିସୁର୍‌ ପାଦେ ମାଣ୍ଡିକୁଟା ଦେଇ ଜୁଆର୍‌ କରି କଇଲା, “ମର୍‌ଟାନେଅନି ଜାଆ ମାପ୍‌ରୁ, କାଇକେବଇଲେ ମୁଇ ଗଟେକ୍‌ ପାପି ମୁନୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","କାଇକେବଇଲେ ତେଇ ସେମନ୍‌ ଏତେକ୍‌ ମାଚ୍‌ ଦାରିରଇଲାଇଜେ, ସେଟା ଦେକି ସିମନର୍‌ ସଙ୍ଗାରିମନ୍‌ କାବାଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ଆରି ଜେବଦିର୍‌ ଦୁଇଟା ପ ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌ ଜନ୍‌ଲକ୍‌ମନ୍‌ ସିମନର୍‌ ସଙ୍ଗାରି ରଇଲାଇ, ସେମନ୍‌ ମିସା ସେନ୍ତାରିସେ କାବା ଅଇଗାଲାଇ । ଆରି ଜିସୁ ସିମନ୍‌କେ କଇଲା, “ଡରାନାଇ, ଆଜିଅନି ତମେ ମାଚ୍‌ ନ ଦାରି, ଲକ୍‌ମନ୍‌କେ ମର୍‌ଟାନେ ଆନ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ତେଇ ସେମନ୍‌ ସବୁ ତାକର୍‍ ଡଙ୍ଗା କଣ୍ଡି ଆନି ଚାଡିଦେଇକରି ଜିସୁର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ତରେକ୍‌ ଜିସୁ ଗଟେକ୍‌ ନଅରେ ରଇଲାବେଲେ ଗଟେକ୍‌ ଗୁଲାଇ ଗାଗଡେ ବଡ୍‌ରଗ୍‌ ଅଇରଇବା ଲକ୍‌ ତେଇ ରଇଲା । ସେ ଡାଣ୍ଡାସନ୍‌ ପଡି ମୁ ବୁଏଁ ଚିଆଇ ଜିସୁକେ ବାବୁଜିଆ କରି କଇଲା, “ଏ ମାପ୍‌ରୁ, ତମେ ଜଦି ମନ୍‌କଲୁସ୍‌ନି ବଇଲେ, ମକେ ନିକ କରିପାରୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ତେଇ ଜିସୁ ଆତ୍‌ ଲାମାଇ ତାକେ ଚିଇ କରି କଇଲା, “ମୁଇ ମନ୍‌ କଲିନି, ତୁଇ ସୁକଲ୍‌ ଅ ।” ଦାପ୍‌ରେସେ ତାର୍‌ ବଡ୍‌ ରଗ୍‌ ଚାଡିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ଆରି ଜିସୁ ତାକେ ଆଦେସ୍‌ ଦେଇ କଇଲା, “ଏ କାତା କାକେ କ ନାଇ । ମାତର୍‌ ପୁଜାରିର୍‌ ଲଗେ ଜା ଆରି ସେ ତକେ ପରିକା କରି ଦେକ । ତୁଇ, ‘ନିକ ଅଇଲିଆଚି’ ବଲି ବିନ୍‌ ଲକର୍‌ ଟାନେ ସାକିଦେବାକେ ମସାର୍‌ ଆଦେସ୍‌ ଇସାବେ ବିରୁ ଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ମାତର୍‌ ଜିସୁର୍‌ କବର୍‌ ଗୁଲାଇ ଚାରିବେଡ୍‌ତିର୍‌ଲକ୍‌ ଜାନ୍‌ଲାଇ । ତାର୍‍ କାତା ସୁନ୍‌ବାପାଇ ଆରି ନିଜର୍‌ ନିଜର୍‌ ରଗେଅନି ନିକ ଅଉଁବଲି ଗାଦି ଲକ୍‌ମନ୍‌ ଟୁଲ୍‌ଅଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ମାତର୍‌ ଜିସୁ କିନରା ଜାଗାମନ୍‌କେ ଜାଇ ପାର୍‌ତନା କର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ଦିନେକ୍‌ ଜିସୁ ସିକିଆ ଦେଇତେରଇଲା । ତେଇ ଗାଲିଲିର୍‌ ସବୁ ଗାଏଁଅନି, ଜିଉଦା ଆରି ଜିରୁସାଲମେଅନି ଆସିରଇବା ପାରୁସିମନ୍‌ ଆରି ନିଅମ୍‌ ସିକାଉମନ୍‍ ତେଇ ବସିରଇଲାଇ । ଆରି ରଗିମନ୍‌କେ ନିକ କର୍‌ବାକେ ମାପ୍‌ରୁର୍‌ ବପୁ, ଜିସୁକେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ଆରି ଏଦେ ଦେକା ! ଗଟେକ୍‌ ଚେରେଙ୍ଗ୍‌ବାତ୍‌ ଦାର୍‌ଲା ମୁନୁସ୍‌କେ, କେତେଲକ୍‌ କଟ୍‌ ମିସ୍‌ତେ ବଇଆନିକରି, ଗର୍‍ ବିତ୍‌ରେ ନେଇ ଜିସୁର୍‌ ମୁଆଟେ ସଙ୍ଗଉବଲି, ଚେସ୍‌ଟା କରତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ମାତର୍‌ ଚିପାଟେଲାର୍‌ଲାଗି, ତାକେ ବିତ୍‌ରେ ନେବାକେ ବାଟ୍‌ ମିଲେନାଇ । ଏଦେ ଦେକା ! ସେମନ୍‌ ରଗିକେ ଗର୍‌ ଉପ୍‌ରେ ଚଗାଇ ଚାଉନି ଉଜାଡି, କଟ୍‌ ମିସ୍‌ତେ ଲକ୍‌ମନର୍‌ ମଜାଇ ଜିସୁର୍‌ ମୁଆଟେ ଉତ୍‌ରାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ଜିସୁ ସେମନର୍‌ ବିସ୍‌ବାସ୍‌ ଦେକି କଇଲା, “ଏ ବାବୁ, ତମର୍‌ ସବୁ ପାପ୍‌ କେମା ଅଇଗାଲାବେ ।” ");
INSERT INTO dso_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ସାସ୍‌ତର୍‌ ସିକାଇବା ଲକ୍‌ମନ୍‌ ଆରି ପାରୁସି ଲକ୍‌ମନ୍‌ ମନେ ମନେ କୁଆବଲା ଅଇ, ଏନ୍ତି କଇବାର୍‌ ଦାର୍‌ଲାଇ, “ଏ କେ ଜେ ପର୍‌ମେସରର୍‌ ନିନ୍ଦାକଲାନି ? ପର୍‌ମେସର୍‌କେ ଚାଡି ଆରି କେ ପାପ୍‌ କେମା କରିପାର୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ତେଇ ସେମନ୍‌ ମନେ ମନେ କୁଆବଲା ଅଇବାଟା ଜାନିକରି ସେମନ୍‌କେ ଜିସୁ କଇଲା, “ତମେ କାଇକେ ସବୁଲକ୍‌ ନିଜର୍‌ ମନେ ମନେ ଏନ୍ତାରି କୁଆବଲା ଅଇଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","କାଇଟା ଉପାସ୍‌ କାତା ? ତର୍‌ ସବୁ ପାପ୍‌ କେମା ଅଇଗାଲା ବଲି କଇବାଟା, କି ଉଟିକରି ଇଣ୍ଡି ଜା ବଲି କଇବାଟା ? ");
INSERT INTO dso_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ମାତର୍‌ ପୁର୍‌ତିବିର୍‌ ସବୁ ପାପ୍‌ କେମା କର୍‌ବାକେ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମର୍‌ ଅଦିକାର୍‌ଆଚେ ।” ଏଟା ତମେ ଜେନ୍ତି ଜାନିପାରାସ୍‌ । ଏଟାର୍‌ପାଇ ଜିସୁ ଚେରେଙ୍ଗ୍‌ବାତ୍‌ ଦାର୍‌ଲା ରଗିକେ କଇଲା, “ମୁଇ ତକେ କଇଲିନି, ଉଟ୍‌ ନିଜର୍‌ ବିଚ୍‌ନା ଦାରି ଗରେ ଜା ।” ");
INSERT INTO dso_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ସେଦାପ୍‌ରେ ଚେରେଙ୍ଗ୍‌ ଦାର୍‌ଲା ଲକ୍‌ ସବୁଲକର୍‌ ଦେକ୍‌ତେ ଉଟିକରି ଜନ୍‌ କଟେ ସଇରଇଲା, ସେଟା ବଇ ପର୍‌ମେସରର୍‌ ମଇମା କରି କରି ତାର୍‌ ଗରେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ତେଇ ରଇଲା ସବୁଲକ୍‌ କାବା ଅଇଜାଇକରି ପର୍‌ମେସରର୍‌ ମଇମା କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ ଆରି ମାପ୍‌ରୁର୍‌ ଚକିତ୍‌ କାମ୍‌ ଦେକି, “ଆଜି ଆମେ କେବେ ନ ଅଇଲାଟା ଦେକ୍‌ଲୁ !” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ତାର୍‌ପଚେ ଜିସୁ ବାରଇଜାଇ ଲେବି ନାଉଁର୍‌ ଗଟେକ୍‌ ସିସ୍‌ତୁମାଙ୍ଗୁ, ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ମାଙ୍ଗ୍‌ବାଟାନେ ବସିରଇବାଟା ଦେକି, ତାକେ କଇଲା, “ମର୍‌ସଙ୍ଗ୍‌ ଆଉ ।” ");
INSERT INTO dso_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ତେଇ ଲେବି ସବୁଜାକ ଚାଡିଦେଇ ଉଟିକରି ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଜିବାର୍‌ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ଆରି ଲେବି ଜିସୁର୍‌ପାଇ ନିଜର୍‌ ଗରେ, ଗଟେକ୍‌ ବଡ୍‌ ବଜିକଲା । ତେଇ ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌, ଅଦିକ୍‌ ଲକ୍‌ ଆରି ବିନ୍‌ ବିନ୍‌ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ସେ କାଇବାକେ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ତେଇ ପାରୁସିମନ୍‌ ଆରି ତାକର୍‌ ଦଲର୍‌ ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ଜିସୁର୍‌ ମୁଆଟେ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଦସ୍‌ ଦେକାଇ କଇଲାଇ, “ତମେ କାଇକେ ସିସ୍‌ତୁମାଙ୍ଗୁମନର୍‌ ସଙ୍ଗ୍‌ ଆରି ପାପିମନର୍‌ ସଙ୍ଗ୍‌ ମିସି କିଆ ପିଆ କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ଜାକେ ଦୁକାଦାରି ରଇସି, ସେସେ ଅସ କାଇସି, ଜାକେ ଦୁକା ଦାରେ ନାଇ ତାକେ ଅସ ଲଡାନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ମୁଇ ଦରମ୍‌ ଲକ୍‌ବଲି ନିଜ୍‌କେ ବାବ୍‌ବା ଲକ୍‌ମନର୍‌ ପାଇ ଆସିନାଇ, ମାତର୍‌ ପାପି ଲକ୍‌ମନ୍‌କେ ପାପେଅନି ମନ୍‌ ବାଦ୍‌ଲାଇବାକେ ଆଇଲିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","କେତେକ୍‌ ଲକ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ତର୍‌କେତର୍‌ ଉପାସ୍‌ କରି ପାର୍‌ତନା କର୍‌ବାଇ । ପାରୁସିମନର୍‌ ସିସ୍‌ମନ୍‌ ମିସା ସେନ୍ତାରି ସେ କର୍‌ବାଇ । ମାତର୍‌ ତମର୍‌ ସିସ୍‌ମନ୍‌ କିଆ ପିଆ କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ବର୍‌ବାଟର୍‌ ଲକ୍‌ମନର୍‌ସଙ୍ଗ୍‌ ବର୍‌ ରଇଲାବେଲେ, ତମେ କାଇ ସେମନ୍‌କେ ଉପାସ୍‌ କରାଇପାରାସ୍‌ ? ନାଇ, ନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ମାତର୍‌ ବେଲା ଆଇସି, ଜେଡେବେଲେ ତାକର୍‌ଟାନେଅନି ବର୍‌କେ ଡାକିଦାରିଜିବାଇ, ସେଡ୍‌କିବେଲେ ସେମନ୍‌ ଉପାସ୍‌ କଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ଜିସୁ ସେମନ୍‌କେ ଆରି ଗଟେକ୍‌ ଉଦାଅରନ୍‌ ଦେଇ କଇଲା, “କେ ମିସା ପୁର୍‌ନା ଲୁଗା ପାଟିରଇଲାଟାନେ ନୁଆଲୁଗା ଚିରି ଚାପ୍‌ ନ ଦେଅତ୍‌, ଚାପ୍‌ ଦେଲେ ନୁଆଟା ମିସା ନସିଜାଇସି, ନୁଆ ଲୁଗାର୍‌ ଚାପ୍‌ ପୁର୍‌ନାଟାନେ ନ ମିସେ । ");
INSERT INTO dso_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ବେସି ଦିନର୍‌ ପୁର୍‌ନା ଗାଗ୍‌ରିଟାନେ କେ ମିସା ଏବେ ଉତ୍‌ରାଇଲା ମଦ୍‌ ନ ରକଅତ୍‌, ତେଇ ଜଦି ସେ ମଦ୍‌ ରକଇ ଡାବିଦେଲେ, ଗାଗ୍‌ରି ପୁଟିକରି ପଡାଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ତେବେ ମଦ୍‌ ଉତ୍‌ରାଇଲା ଦାପ୍‌ରେ ନୁଆ ଗାଗ୍‌ରିଟାନେ ରକଇ ସଙ୍ଗଇବାର୍‌ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ଆରି କେ ମିସା ପୁର୍‌ନା ମଦ୍‌ କାଇକରି ଏବେ ଉତ୍‌ରାଇଲା ମଦ୍‌ କାଇବାକେ ମନ୍‌ ନ କରତ୍‌, କାଇକେବଇଲେ, ସେ ବାସିଟା ଆକା ନିକ ବଲି କଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ତରେକ୍‌ ବିସ୍‌ରାମ୍‌ ବାରେ ଜିସୁ ତାସ୍‌ ରଇଲା ପଦାବାଟେ ଜିବାବେଲେ ତାର୍‌ ସିସ୍‌ମନ୍‌ କେଡ୍‌ ଚିଡାଇ ଆତେ ରମ୍‌ଦି କାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ସେମନ୍‌କେ ଦେକ୍‌ତେରଇବା ପାରୁସି ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି କେତେଲକ୍‌ କଇଲାଇ, “ବିସ୍‌ରାମ୍‌ ବାରେ ଜନ୍‌ଟା କର୍‌ବାର୍‌ ବିଦି ନଏଁ, ସେଟା ତମେ କାଇକେ କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ଦାଉଦ୍‌ ଆରି ତାର୍‌ ସଙ୍ଗର୍‌ ଲକ୍‌ମନ୍‌ ବୁକେ ରଇଲାବେଲେ, ଦାଉଦ୍‌ କାଇଟା କରିରଇଲା, ସେଟା କାଇ ତମେ ପଡାସ୍‌ ନାଇ କି ? ");
INSERT INTO dso_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ସୁନା, ଦାଉଦ୍‌ ପର୍‌ମେସରର୍‌ ଗରେ ପୁରି, ପର୍‌ମେସର୍‌କେ ସର୍‌ପି ଅଇରଇଲା ଜନ୍‌ ରୁଟି, ପୁଜାରିମନ୍‌କେ ଚାଡି ଆରି କେ ମିସା କାଇବାର୍‌ ବିଦି ନ ରଇଲା, ସେଟା ନେଇକରି କାଇଲା ଆରି ତାର୍‌ ସଙ୍ଗର୍‌ ଲକ୍‌ମନ୍‌କେ ମିସା ଦେଇରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ଆରି ଜିସୁ କଇଲା, “ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମୁଇ ବିସ୍‌ରାମ୍‌ ବାରେ ଲକ୍‌ମନ୍‌ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ କାଇଟା କର୍‌ବାର୍‌ ନାଇ, ସେଟା କଇବାର୍‌ ମର୍‌ ଅଦିକାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଆରି ଜିସୁ ବିନ୍‌ ଗଟେକ୍‌ ବିସ୍‌ରାମ୍‌ବାରେ, ଜିଉଦି ଲକ୍‌ମନର୍‌ ପାର୍‌ତନା ଗରେ ଜାଇକରି ସିକାଇତେରଇଲା । ତେଇ ଗଟେକ୍‌ ଲକ୍‌ ରଇଲା । ତାର୍‍ ଉଜା ଆତ୍‌ ସୁକିଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ଆରି ଜିସୁ ବିସ୍‌ରାମ୍‌ବାରେ ମିସା କେ ଜାନେ ନିକ କର୍‌ସି, ଏଟା ଦେକୁ ବଲି ପାରୁସି ଲକ୍‌ମନ୍‌ ଆରି ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ତାକେସେ ଦେକି ଦେକି ରଇଲାଇ, କାଇକେବଇଲେ ତାର୍‌ ବିରୁଦେ ଦସ୍‌ ଦାର୍‌ବାକେ । ");
INSERT INTO dso_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ମାତର୍‌ ଜିସୁ ତାକର୍‌ ମନେ ବାବ୍‌ଲାଟା ଜାନିକରି, ଜନ୍‌ ଲକର୍‌ ଆତ୍‌ ସୁକିଜାଇରଇଲା, ତାକେ କଇଲା, “ଉଟ୍‌ ଆରି ସବୁଲକର୍‌ ମୁଆଟେ ଟିଆ ଅ ।” ଆରି ସେଲକ୍‌ ଉଟି ଟିଆଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ତେଇ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ତମ୍‌କେ ପାଚାର୍‌ଲିନି, ବିସ୍‌ରାମ୍‌ବାରେ ବିଦି ଇସାବେ କାଇଟା କର୍‌ବାର୍‌ ? ନିକ କର୍‌ବାର୍‌ କି କାରାପ୍‌ କର୍‌ବାର୍‌ ? ଜିବନ୍‌ ବଁଚାଇବାର୍‌ କି ମରାଇବାର୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ଆରି ସେ ଚାରିବେଡ୍‌ତି ସବୁକେ ଦେକି ସେ ଲକ୍‌କେ କଇଲା, “ତମର୍‌ ଆତ୍‌ ଲାମାଆ ।” ତେଇ ସେ ସେନ୍ତାର୍‌ କଲା, ଆରି ତାର୍‌ ଆତ୍‌ ପୁରାପୁରୁନ୍‌ ନିକ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ମାତର୍‌ ପାରୁସିମନ୍‌ ଆରି ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ବେସି ରିସା ଅଇଗାଲାଇ ଆରି ଜିସୁର୍‌ ବିରୁଦେ “କାଇଟା କରୁ ?” ବଲି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ ନିଆଇ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ସେବେଲେ ଦିନେକ୍‌ ଜିସୁ ପାର୍‌ତନା କର୍‌ବାକେ ବାରଇ, ପର୍‌ବତେ ଗାଲା ଆରି ଗୁଲାଇରାତି ପର୍‌ମେସର୍‌କେ ପାର୍‌ତନା କରି କରି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ସାକାଲ୍‌ ପାଇଲାକେ, ଜିସୁ ସିସ୍‌ମନ୍‌କେ ଲଗେ ଡାକି ସେମନର୍‌ ବିତ୍‌ରେଅନି ବାର ଲକ୍‌କେ ବାଚ୍‌ଲା, ଆରି ସେମନ୍‌କେ ପେରିତ୍‌ ବଲି ନାଉଁ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ସେମନ୍‌ ରଇଲା, ସିମନ୍‌ ଜାକେ କି ସେ ପିତର୍‌ ବଲି ମିସା ନାଉଁ ଦେଲା, ଆରି ସିମନର୍‌ ବାଇ ଆନ୍ଦ୍‌ରିୟ, ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌, ପିଲିପ୍‌ ଆରି ବାର୍‌ତଲମି । ");
INSERT INTO dso_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାତିଉ ଆରି ତମା, ଆଲ୍‌ପିର୍‌ ପ ଜାକୁବ୍‌ ଆରି ସିମନ୍‌, ଜାକେ କି କାଇ କାମ୍‌ କର୍‌ବାକେ ମିସା ଆଗ୍‌ତୁ ଅଇସି ବଲି କଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଜାକୁବର୍‌ ପ ଜିଉଦା ଆରି ଇସ୍‌କାରିତ ଜିଉଦା, ଜେ କି ଜିସୁକେ ସତ୍‌ରୁମନ୍‍କେ ସର୍‌ପିଦେଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ଆରି ଜିସୁ ପେରିତ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଉତ୍‌ରିକରି, ଗଟେକ୍‌ ସଦ୍‌ରମ୍‌ ରଇଲା ଜାଗାଇ ଟିଆଅଇଲା । ଆରି ତେଇ ତାର୍‌ ବେସି ସିସ୍‌ମନ୍‌, ଜିଉଦା ରାଇଜର୍‌ ବେସି ଲକ୍‌, ଜିରୁସାଲାମ୍‌ ଆରି ସମ୍‌ଦୁର୍‌ ପାଲି ରଇବା ସର ଆରି ସିଦନ୍‌ ସଅରେଅନି ବେସି ଲକ୍‌ମନ୍‌ ରୁଣ୍ଡିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ଲକ୍‌ମନ୍‌ ତାର୍‌ ବାକିଅ ସୁନ୍‌ବାକେ ଆରି ନିଜର୍‌ ନିଜର୍‌ ରଗେଅନି ନିକ ଅଇବାକେ ଆସିରଇଲାଇ । ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଡୁମା ଦାରାଇଅଇ ଦୁକ୍‌ କସ୍‌ଟ ପାଇତେରଇଲାଇ, ସେମନ୍‌କେ ଜିସୁ ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ସବୁଲକ୍‌ମନ୍‌ ଜିସୁକେ ଚିଇବାକେ ଚେସ୍‌ଟା କର୍‌ତେରଇଲାଇ । କାଇକେବଇଲେ ତାର୍‌ ଗାଗ୍‌ଡେଅନି ମାପ୍‌ରୁର୍‌ ବପୁ ବାରଇତେରଇଲା ଆରି ସବୁଲକ୍‌ମନ୍‌କେ ନିକ କରତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ସେବେଲେ ଜିସୁ ନିଜର୍‌ ସିସ୍‌ମନର୍‌ ବାଟେ ଦେକି କଇଲା, “ତମେ ଏବେ କାକୁର୍‌ତି ଅଇଆଚାସ୍‌ ତମର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ତମର୍‌ଟା । ");
INSERT INTO dso_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ତମେମନ୍‌ ଏବେ ବୁକେ ଆଚାସ୍‌, ତମର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ, ତମ୍‌କେ ପର୍‌ମେସର୍‌ ପୁରାପୁରୁନ୍‌ ଦେଇସି । ତମେମନ୍‌ ଏବେ କାନ୍ଦ୍‌ଲାସ୍‌ନି, ତମର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌, କାଇକେବଇଲେ ତମେମନ୍‌ ସାର୍‌ଦା ଅଇକରି ଆଁସ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ଲକ୍‌ମନ୍‌ ଜେବେ ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମର୍‌ ଲାଗି ତମ୍‌କେ ଇନ୍‌ କର୍‌ବାଇ, ଆରି ବେଗ୍‌ଲାଇ ଦେବାଇ, ନିନ୍ଦାକରି ତମର୍‌ ନାଉଁ ମନ୍ଦ୍‌ ବଲି ଦାର୍‌ବାଇ, ତମର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ସେ ଦିନେ ସାର୍‌ଦା ଅଇ ନାଟ୍‌ କର୍‌ସା । କାଇକେବଇଲେ ଦେକା, ସର୍‌ଗେ ତମର୍‌ ପୁରୁସ୍‌କାର୍‌ ଅଦିକ୍‌ ଆରି ସେନ୍ତାରି ତା ସେମନର୍‌ ଆନିଦାଦିମନ୍‌, ବବିସତ୍‍ବକ୍‍ତାମନ୍‌କେ କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ମାତର୍‌ ଏ ଡଣ୍ଡ୍‌ ପାଉମନ୍‌, ତମେମନ୍‌ ଏବେ ସାଉକାର୍‌ ଆଚାସ୍‍, କାଇକେବଇଲେ ତମେ ନିଜେ ନିଜେ ସୁକ୍‌ ପାଇଲାସ୍‌ବେ । ");
INSERT INTO dso_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ଏ ଡଣ୍ଡ୍‌ପାଉମନ୍‌, ଏବେ ତମେ ନିକସଙ୍ଗ୍‌ କାଇଲାସ୍‌ନି, କାଇକେବଇଲେ, ତମେ ବୁକେସେ ରଇସା । ଏ ଡଣ୍ଡ୍‌ପାଉମନ୍‌, ତମେମନ୍‌ ଏବେ ଆଁସ୍‌ଲାସ୍‌ନି, କାଇକେବଇଲେ ପଚେ ଦୁକେ ରଇକରି କାନ୍ଦ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“ଜେଡେବେଲେ ତମ୍‌କେ ଲକ୍‌ମନ୍‌ ବଲ୍‌ ବଲିକରି ବାବ୍‌ଲାଇନି, ଏ ଡଣ୍ଡ୍‌ପାଉମନ୍‌, ତାକର୍‌ ଆନିଦାଦି ତା ମାପ୍‌ରୁର୍‌ କାତା ବୁଲ୍‌କାଉମନର୍‌ପାଇ ସେନ୍ତାରି କର୍‌ତେରଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ମାତର୍‌ ତମେମନ୍‌ ସୁନି ଆଚାସ୍‍ଜେ ମୁଇ ତମ୍‌କେ କଇଲିନି, ତମର୍‌ ସତ୍‌ରୁମନ୍‌କେ ଆଲାଦ୍‌ କରା, ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଇନ୍‌ କର୍‌ବାଇ, ସେମନର୍‌ ମଙ୍ଗଲ୍‌ କରା । ");
INSERT INTO dso_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ସାଇପ୍‌ ଦେବାଇ, ସେମନ୍‌କେ ଆସିର୍‌ବାଦ୍‌ କରା । ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଇଜତ୍‌ ଜିକ୍‌ବାଇ, ସେମନର୍‌ପାଇ ପାର୍‌ତନା କରା । ");
INSERT INTO dso_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଜେ ତମ୍‌କେ ଗଟେକ୍‌ ଗାଲେ ଚାପଡ୍‌ ମାର୍‌ସି, ତାକେ ଆରିଗଟେକ୍‌ ଗାଲ୍‌ ମିସା ଦେକାଇଦିଆସ୍‌ । ଜେ ତମର୍‌ ଚାଦର୍‌ ଦାରିଜାଇସି, ତାକେ ତମର୍‌ ପିନ୍ଦ୍‌ଲାଟା ନେବାକେ ମିସା ମନା କରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଜେ ତମ୍‌କେ ମାଙ୍ଗ୍‌ସି, ତାକେ ଦିଆସ୍‌ । ଆରି ଜେ ତମର୍‌ ଦନ୍‌ ସଁମ୍‌ପତି ଉଦାର୍‌ ନେଇସି, ତାର୍‌ଟାନେଅନି ସେଟା ଆରିତରେକ୍‌ ମାଙ୍ଗାନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଜେନ୍ତି କରତ୍‌ ବଲି ମନ୍‌ କଲାସ୍‍ନି, ତମେମିସା ସେମନର୍‌ଟାନେ ସେନ୍ତାର୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଆଲାଦ୍‌ କଲାଇନି, ଜଦି ସେମନ୍‌କେସେ ତମେ ଆଲାଦ୍‌ କର୍‌ସା ବଇଲେ କାଇ ଆସିର୍‌ବାଦ୍‌ ପାଇସା ? କାଇକେବଇଲେ ପାପିମନ୍‌ ମିସା ସେନ୍ତାରି କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ଜଦି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତମର୍‌ ମଙ୍ଗଲ୍‌ କଲାଇନି, ସେମନ୍‌କେସେ ମଙ୍ଗଲ୍‌ କର୍‌ସା ବଇଲେ, କାଇ ଆସିର୍‌ବାଦ୍‌ ପାଇସା ? କାଇକେବଇଲେ ପାପିମନ୍‌ ମିସା ସେନ୍ତାରି କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ଆରି ଜନ୍‌ ଲକ୍‌ମନର୍‌ଟାନେଅନି ତମର୍‌ ମିଲାଇବାର୍‌ ଆସା ରଇସି, ଜଦି ସେମନ୍‌କେସେ ଉଦାର୍‌ ଦେଇସା ବଇଲେ, ତମେ କାଇ ଆସିର୍‌ବାଦ୍‌ ପାଇସା ? ପାପିମନ୍‌ ମିସା ସମାନ୍‌ ଇସାବେ ବାନ୍ଦ୍‌ଲାଟା ମିଲବଲି, ରୁନ୍‌ ଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ମାତର୍‌ ତମର୍‌ ସତ୍‌ରୁମନ୍‌କେ ଆଲାଦ୍‌ କରା । ଆରି ସେମନର୍‌ ମଙ୍ଗଲ୍‌ କରା । ରୁନ୍‌ ବାନ୍ଦ ବଲି ଆସା ନ କରି, ରୁନ୍‌ ଦିଆସ୍‌ । ସେନ୍ତାର୍‌କଲେ ତମର୍‌ ପୁରୁସ୍‌କାର୍‌ ଅଦିକ୍‌ ଅଇସି । ଆରି ତମେ ପର୍‌ମେସରର୍‌ ପ ଅଇସା । କାଇକେବଇଲେ ସେ ନ ମାନ୍‌ବା ଲକର୍‌ ଆରି କରାପ୍‌ ଲକର୍‌ ମିସା ଦୟାକାରିଆ । ");
INSERT INTO dso_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ତମର୍‌ ସରଗର୍‌ ବାବା ଜେନ୍ତାରି ଦୟା କଲାନି, ସେନ୍ତାରି ତମେ ମିସା ଦୟା କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ବିନ୍‌ଲକର୍‌ ବିଚାର୍‌ କରାନାଇ, ସେନ୍ତାର୍‌କଲେ ପର୍‌ମେସର୍‌ ତମ୍‌କେ ବିଚାର୍‌ କର୍‌ସି । ଦସ୍‌ ନ ଦିଆସ୍‌, ସେନ୍ତାର୍‌କଲେ ପର୍‌ମେସର୍‌ ତମ୍‌କେ ଦସ୍‌ ନ ଦାରେ । କେମା କରା, ସେନ୍ତାର୍‌କଲେ ତମ୍‌କେ କେମା ମିଲ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ବିନ୍‌ ଲକ୍‌କେ ଦାନ୍‌ କରା, ସେନ୍ତାର୍‌କଲେ ପର୍‌ମେସର୍‌ ତମ୍‌କେ ଦାନ୍‌ ଦେଇସି, ଲକ୍‌ମନ୍‌ ମାନ୍‌ଟାନେ କାଦି ପୁରୁନ୍‌କରି ତାକେ ଚାପି ଜୁଲାଇ, ଉଚ୍‌ଲାଇକରି, ତମର୍‌ ଅଁଟିତେଇ ଦେବାଇ, କାଇକେବଇଲେ ଜନ୍‌ ଇସାବେ ତମେ ନାପ୍‌ସା, ସେ ଇସାବେ ସେ ତମ୍‌କେ ନାପି ଦିଆଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଜିସୁ ସେମନ୍‌କେ ଉଦାଅରନ୍‌ ଦେଇ କଇଲା, “କାଣା କାଇ କାଣାକେ ବାଟ୍‌ ଦେକାଇପାରେକି ? ନାଇ, ନାପାରେ । ଜଦି ସେମନ୍‌ ସେନ୍ତାରି କର୍‌ବାଇ ବଇଲେ ଦୁଇଲକ୍‌ଜାକ କାଲେ ନ ଅଦ୍‌ରତ୍‌ କି ? ");
INSERT INTO dso_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଗୁରୁର୍‌ଟାନେଅନି ସିସ୍‌ ବଡ୍‌ ନାଇ । ମାତର୍‌ ସିସ୍‌ମନ୍‌ ସିକିଆ ପାଇ ସାରାଇଲେ ସିଦ୍‌ଅଇ ଗୁରୁର୍‌ ସମାନ୍‌ ଅଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ଆରି କାଇକେ ତମର୍‌ ବାଇର୍‌ ଆଁକିଟାନେ ରଇବା ସାନ୍‌ କାଚ୍‌ରା ଦେକ୍‌ଲାସ୍‌ନି ? ମାତର୍‌ ତମର୍‌ ନିଜର୍‌ ଆଁକିଟାନେ ଜନ୍‍ ବଡ୍‌ କାଚ୍‌ରା ଆଚେ, ସେଟା ବାବିଦେକାସ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ତମେ ନିଜର୍‌ ଆଁକିଟାନେ ରଇବା ବଡ୍‌ଟା କାଚ୍‌ରା ନ ଦେକିକରି, ନିଜର୍‌ ବାଇର୍‌ ଆଁକି ଟାନେ ରଇବା ସାନ୍‌ କାଚ୍‌ରା ଦେକି କେନ୍ତି କଇପାରାସ୍‌, ଆଉ ବାଇ ତମର୍‌ ଆଁକିଅନି କାଚ୍‌ରା ବାର୍‌କରାଇଦେବି ? ଏ କୁଟିଆଲ୍‌ମନ୍‌, ପର୍‌ତୁମ୍‌ ନିଜର୍‌ ଆଁକିଅନି କାଚ୍‌ରା ବାର୍‌କରାଇପାକା, ତାର୍‌ପଚେ ନିଜର୍‌ ବାଇର୍‌ ଆଁକିଟାନେ ରଇବା କାଚ୍‌ରା ସବୁ ବାର୍‌କରାଇବାକେ, ନିକକରି ଦେକିପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ନିକ ଗଚେ କାରାପ୍‌ ପଲ୍‌ ନ ପଲେ, କାରାପ୍‌ ଗଚେ ନିକ ପଲ୍‌ ନ ପଲେ । ");
INSERT INTO dso_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","କାଇକେବଇଲେ ଗଚ୍‌ମନ୍‌କେ ତାର୍‌ ପଲର୍‌ଲାଗି ଜାନିଅଇସି । କାଟା ଗଚେଅନି ଲକ୍‌ମନ୍‌ ଡୁମ୍‌ରି ପଲ୍‌ ନ ତଲତ୍‌, କି କାଟା ବୁଟାଇଅନି ଅଙ୍ଗୁର୍‌ ପଲ୍‌ ନ ତଲତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ନିକ ଲକ୍‌ ନିଜର୍‌ ମନ୍‌ ବିତ୍‌ରର୍‌ ଗରବ୍‌ବିତ୍‌ରେ ଅନି ନିକଟା ବାର୍‌କରାଇସି । ଆରି କାରାପ୍‌ ଲକ୍‌ମନ୍‌ ନିଜର୍‌ ମନ୍‌ ବିତ୍‌ରର୍‌ ଗରବ୍‌ଟାନେ ଅନି କାରାପ୍‌ଟା ବାର୍‌କରାଇବାଇ । କାଇକେବଇଲେ, ମନ୍‌ବିତ୍‌ରେ ଚିନ୍ତା କର୍‌ବାଟା, ଟଣ୍ଡ୍‌ କାତା କଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ଆରି ତମେ କାଇକେ ମକେ ଏ ମାପ୍‌ରୁ ଏ ମାପ୍‌ରୁ, ବଲି ଡାକିକରି ମର୍‌ ଆଦେସ୍‌ ମାନାସ୍‌ ନାଇ ? ");
INSERT INTO dso_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଜେ ମିସା ମର୍‌ଲଗେ ଆସି, ମର୍‌ କାତା ସୁନି, ସେଟା ସବୁ ମାନ୍‌ସି, ସେ କାର୍‌ ସମାନ୍‌ ରଇସି, ସେଟା ମୁଇ ତମ୍‌କେ ଦେକାଇବି । ");
INSERT INTO dso_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ସେ ଏନ୍ତାରି ଗଟେକ୍‌ ଗର୍‌ ଉଟାଇବା ଲକର୍‌ପାରା । ଜେ ଗଇର୍‌ କରି କୁନି, କୁନାଦି ପାକ୍‌ନା ଉପ୍‌ରେ ବସାଇଲା । ବନିଆ ପାନି ଆସି ସେଟା ଉଲ୍‌କା ମାର୍‌ଲା ମିସା ସେଟା ବସ୍‌ଲାଇ ନାପାର୍‌ଲା । କାଇକେବଇଲେ ସେଟା ନିମାନ୍‌କରି ଉଟାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ମର୍‌କାତା ସୁନିକରି ମିସା ସେ ଇସାବେ ଚଲାଚଲ୍‌ତି ନ କରତ୍‌, ସେ କୁନାଦି ନ କରି, ବାଲି ଉପ୍‌ରେ ଗର୍‌କଲା ଲକର୍‌ପାରା । ଜବର୍‌ ଅଇତେ ଉଦ୍‌କାମାର୍‌ଲା ଦାପ୍‌ରେ ସେ ଗର୍‌ ବସ୍‌ଲିଗାଲା ଆରି ସେଟା ଅପର୍‌ବଲ୍‌ ବିନାସ୍‌ ଅଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ଜିସୁ ଲକ୍‌ମନ୍‌କେ ସବୁ କାତା କଇ ସାରାଇକରି କପର୍‌ନାଉମ୍‌ ସଅରେ କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ସେବେଲେ ସଏଟା ସନିଅମନର୍‌ ମୁକିଆର୍‌ ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା, ଜର୍‌ ଅଇକରି ମଲାପାରା ଅଇଜାଇରଇଲା । ସେ ତାକେ ନିଜର୍‌ଲକ୍‌ ପାରା ଆଲାଦ୍‌ କର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ସେ ଜିସୁର୍‌ ବିସଇର୍‌ କବର୍‌ ସୁନି, ଜିସୁ ଜେନ୍ତିକି ଆସି ତାର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାର୍‌ ଜିବନ୍‌ ରକିଆ କର୍‌ସି ବଲି ବାବ୍‌ଲା । ସେଟାର୍‌ପାଇ ଜିସୁର୍‌ ଲଗେ କେତେଟା ଜିଉଦି ପାର୍‌ଚିନ୍‌ମନ୍‌କେ ପାଟାଇ ତାକେ ବାବୁଜିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ପାର୍‌ଚିନ୍‌ମନ୍‌ ଜିସୁର୍‌ଲଗେ କେଟିକରି ତାକେ ଜୁଆର୍‌ ବିଆର୍‌ କରି କଇବାର୍‌ ଦାର୍‌ଲାଇ, “ତାର୍‌ପାଇ ତମେ ଏନ୍ତାରି କରିର‍ଇଲେ, ନିକର‍ଇସି । ");
INSERT INTO dso_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","କାଇକେବଇଲେ ସେ ଆମର୍‌ ଲକ୍‌ମନ୍‌କେ ଆଲାଦ୍‌ କର୍‌ସି ଆରି ନିଜେ ସେ ଆମର୍‌ ସବୁଲକର୍‌ ପାଇ ପାର୍‌ତନାଗର୍‌ ତିଆର୍‌କରି ଦେଇଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ତେଇ ଜିସୁ ତାକର୍‌ ସଙ୍ଗ୍‌ ଗାଲା । ସେ ଗରେ କେଟ୍‌ବାକେ କଣ୍ଡେକ୍‌ ଦୁର୍‌ ରଇଲାକେ, ସଏଟା ସନିଅମନର୍‌ ମୁକିଆ ଲକ୍‌ମନ୍‌କେ ପାଟାଇ ତାକେ କଇଲା, “ମାପ୍‌ରୁ, କସ୍‌ଟ ଉଆନାଇ, କାଇକେବଇଲେ ତମେ ଜେ ମର୍‌ ଗରେ ପାଦ୍‌ ପାକାଇସା, ମର୍‌ ଏନ୍ତାରି ବାଗିଅ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ଏଟାର୍‌ପାଇ ମୁଇ ତମର୍‌ଟାନେ ଆଇବାକେ ମନ୍‌ କରିନାଇ । ମାତର୍‌ ଗଟେକ୍‌ ପଦ୍‌ ଆଦେସ୍‌ କରା, ମର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ନିକ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ମୁଇ ଗଟେକ୍‌ ଲକର୍‌ ତଲେ କାମ୍‌ କର୍‌ତେରଇଲେ ମିସା ମର୍‌ ତଲେ ସନିଅମନ୍‌ ଆଚତ୍‌ । ଆରି ମୁଇ ଗଟେକ୍‌ ଲକ୍‌କେ ଜା ବଲି କଇଲେ, ସେ ଜାଇସି । ବିନ୍‌ ଲକ୍‌କେ ଆଉ ବଇଲେ ସେ ଆଇସି । ମର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଏଟା କର୍‌ ବଇଲେ, ସେ ସେଟା କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଜିସୁ ତାର୍‌ ଏ ସବୁ ବିସଇ ସୁନି କାବା ଅଇଗାଲା, ଆରି ବୁଲିକରି ତାର୍‌ ପଚେ ଆଇତେରଇବା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ମୁଇ ତମ୍‌କେ କଇଲିନି, ଇସ୍‌ରାଏଲ୍‌ ବିତ୍‌ରେ ମିସା ଏତେକ୍‌ ବଡ୍‌ ବିସ୍‌ବାସି ନ ମିଲତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ଆରି ଜିସୁକେ ଡାକ୍‌ବାକେ ଜାଇରଇଲା ଲକ୍‌ମନ୍‌ ଗରେ ବାଉଡି ଆସି ଗତିଦାଙ୍ଗ୍‌ଡା ନିକ ଅଇରଇବାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ତେଇଅନି ଜିସୁ ନାଇନ୍‍ ନାଉଁର୍‌ ନଅରେ ଗାଲା । ତାର୍‌ସଙ୍ଗ୍‌ ସିସ୍‌ମନ୍‌ ଆରି ଲକ୍‌ମନ୍‌ ବେସି ଜାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ସେ ନଅରର୍‌ ଦୁଆର୍‌ଲଗେ କେଟୁ କେଟୁ, ଏଦେ ଦେକା ! ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ମଲା ଲକ୍‌କେ ବଇଆନ୍‌ତେ ରଇଲାଇ । ସେ ନିଜର୍‌ ମାଆର୍‌ ଗଟେକ୍‌ ସେ ପିଲା, ଆରି ସେ ମାଇଜି ରାଣ୍ଡିଟା । ନଅରର୍‌ ବେସିଲକ୍‌ମନ୍‌ ତାର୍‌ ସଙ୍ଗ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ସେ ରାଣ୍ଡି ମାଇଜିକେ ଦେକି ଜିସୁ ଦୁକ୍‌କଲା ଆରି ତାକେ କଇଲା, “ଏ ମାଆ କାନ୍ଦ୍‌ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ଆରି, ଜିସୁ ଜାଇକରି ଡାଣ୍ଡିଆ ଚିଇଲାକେ ବଇ ଆନ୍‌ତେରଇବା ଲକ୍‌ମନ୍‌ ଟିଆଅଇଲାଇ । ଆରି ସେ କଇଲା, “ମୁଇ ତକେ କଇଲିନି, ନୁନା ଉଟ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ତେଇ ସେ ଦାଙ୍ଗ୍‌ଡା ଉଟିବସ୍‌ଲା ଆରି କାତା କଇବାର୍‌ ଦାର୍‌ଲା । ଆରି ଜିସୁ ସେ ଦାଙ୍ଗ୍‌ଡାକେ ତାର୍‌ ମାକେ ସର୍‌ପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ତେଇ ସବୁଲକ୍‌ ଡରିଗାଲାଇ, ଆରି ପର୍‌ମେସରର୍‌ ମଇମା କରି କରି କଇଲାଇ “ଆମର୍‌ ବିତ୍‌ରେ ଗଟେକ୍‌ ମଆନ୍‌ ବବିସତ୍‌ବକ୍‌ତା ଆଇଲାଆଚେ, ଆରି ପର୍‌ମେସର୍‌ ନିଜର୍‌ ଲକ୍‌ମନ୍‌କେ ଉଦାର୍‌ କର୍‌ବାକେ ଆସିଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ଜିସୁର୍‌ ଏ ବିସଇର୍‌ କାତା ଗୁଲାଇ ଜିଉଦା ଦେସେ ଆରି ଚାରିବାଟର୍‌ ଗାଉଁଗଣ୍ଡାର୍‌ ଲକ୍‌ମନ୍‌ ଜାନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ପଚେ ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ଏ ସବୁ କାତା ଜଅନ୍‌କେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ତେଇ ଜଅନ୍‌ ନିଜର୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଦୁଇଲକ୍‌କେ ଡାକି ମାପ୍‌ରୁର୍‌ ଲଗେ ଏନ୍ତାରି କଇ ପାଟାଇଲା, “ଜେ ଆଇବାର୍‌ ରଇଲା, ସେ ଲକ୍‌ ତମେସେ କି ? କି କାଇ ବିନ୍‌ ଲକ୍‌କେ ଆମେ ଜାଗ୍‌ବୁ ?” ");
INSERT INTO dso_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ସେ ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ଲଗେ କେଟିକରି କଇଲାଇ, “ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ଆମ୍‌କେ ଏନ୍ତାରି କଇ ତମର୍‌ଲଗେ ପାଟାଇଆଚେ, ଜେ ଆଇବାର୍‌ ରଇଲା, ସେ ଲକ୍‌ ତମେ କି ? କି କାଇ ଆମେ ଆରି ବିନ୍‍ ଲକ୍‌କେ ଜାଗ୍‌ବୁ ?” ");
INSERT INTO dso_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ସେବେଲେ ଜିସୁ ଜର୍‌ ଦୁକା, ଆରି ଡୁମା ଦାର୍‌ଲା ଲକ୍‌ମନ୍‌କେ ନିକ କଲା । ଆରି କେତେଟା କାଣାମନ୍‌କେ ମିସା ଆଁକି ଡିସାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଜିସୁ ଜଅନର୍‌ ସିସ୍‌ମନ୍‌କେ କ‍ଇଲା, “ତମେମନ୍‌ ଜନ୍‌ ଜନ୍‌ଟା ଦେକ୍‌ଲାସ୍‌ ଆରି ସୁନ୍‌ଲାସ୍‌, ସେଟା ସବୁ ଜାଇ ଜଅନ୍‌କେ ଜାନାଆ, କାଣା ଲକ୍‌ମନ୍‌ ଦେକିପାର୍‌ଲାଇନି, ଚଟାମନ୍‌ ଇଣ୍ଡିବୁଲ୍‍ଲାଇନି, ବଡ୍‌ ରଗିମନ୍‌ ନିକ ଅଇଲାଇନି, ବଇରା ଲକ୍‌ମନ୍‌ ସୁନ୍‌ଲାଇନି, ମଲାଲକ୍‌ମନ୍‌ ଜିବନ୍‌ଅଇ ଉଟ୍‌ଲାଇନି, ଆରି ଦୁକର୍‌ ଲକ୍‌ମନ୍‌କେ ମାପ୍‌ରୁର୍‌ ବାକିଅ ସୁନାଇଅଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ଜନ୍‌ଲକ୍‌ ମକେ ‘କିରିସ୍‌ଟ ସେ କି ନଏଁ ?’ ବଲି ନ ବାବିକରି ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ତାର୍‌ କେଡେକ୍‌ ନିକ କରମ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ବାଉଡିଗାଲାପଚେ ଜିସୁ ଲକ୍‌ମନ୍‌କେ ଜଅନର୍‌ ବିସଇ କଇବାର୍‌ଦାର୍‌ଲା, “କାଇଟା ଦେକ୍‌ବାକେ ତମେ ମରୁବାଲି ବୁଏଁ ବାରଇ ଜାଇରଇଲାସ୍‌ ? କାଇ ପବନେ ଜୁଲ୍‌ତେରଇବା ବାଉଁସ୍‌ ନାଲା ? ");
INSERT INTO dso_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ସେଟା ନଇଲେ ତମେ କାଇଟା ଦେକ୍‌ବାକେ ବାରଇଜାଇ ରଇଲାସ୍‌ ? କାଇ ଜବର୍‌ ଡାବୁଦେଇ ବସ୍‍ତର୍‍ ଗେନି ପିନ୍ଦିରଇବା ଗଟେକ୍‌ ଲକ୍‌କେ ଦେକ୍‌ବାକେ ? ଦେକା, ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଜେ କି ସୁନ୍ଦର୍‌ ବସ୍‍ତର୍‍ ପିନ୍ଦିକରି, ସୁକର୍‌ ସଙ୍ଗ୍‌ ଦିନ୍‌ ବିତାଇବାଇ, ସେମନ୍‌ ତା ରାଜାର୍‌ ନଅରେ ରଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ସେନ୍ତାର୍‌ ନଇଲେ କାଇକେ ବାରଇ ଜାଇରଇଲାସ୍‌ ? କାଇ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତାକେ ଦେକ୍‌ବାକେ ? ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜଅନ୍‌ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ତେଇଅନି ମିସା ଅଦିକାର୍‌ ର‍ଇବା ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଜାର୍‌ ବିସଇ ନେଇକରି ଦରମ୍‌ ସାସ୍‌ତରେ ଲେକାଆଚେ । ପର୍‌ମେସର୍‌ କଇଲା, “ଆମେ ନିଜର୍‌ ଦୁତ୍‌କେ ତମର୍‌ ଆଗେ ପାଟାଇଲୁନି, ସେ ତମର୍‌ ମୁଆଟେ ତମର୍‌ପାଇ ବାଟ୍‌ ତିଆର୍‌ କର୍‌ସି, ଏ ସେ ଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ମାଇଜିମନର୍‌ ଟାନେଅନି ଜାତ୍‌ କରିରଇବା ସବୁର୍‌ ବିତ୍‌ରେ, ଜଅନର୍‌ ଟାନେଅନି ଆରି ମୁକିଅ କେ ମିସା ନାଇ, ଏଲେମିସା ପର୍‌ମେସରର୍‌ ରାଇଜେ ଜେ ସାନ୍‌, ସେ ଜଅନର୍‌ ଟାନେଅନି ବଡ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ଜନ୍‌ଲକ୍‌ମନ୍‌ ଏ ସବୁ କାତା ସୁନ୍‌ତେରଇଲାଇ, ସେମନ୍‌, ଜେନ୍ତାରିକି ସିସ୍‌ତୁମାଙ୍ଗୁମନ୍‌ ମିସା ପର୍‌ମେସରର୍‌ ଦାବିକଲାଟା ମାନି ଜଅନର୍‌ ଟାନେ ଡୁବନ୍‌ ନେଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ମାତର୍‌ ପାରୁସିମନ୍‌ ଆରି ନିଅମ୍‌ ସିକାଉମନ୍‌ ତାକର୍‌ ଜିବନର୍‌ପାଇ ପର୍‌ମେସର୍‌ କରିରଇବା ଜଜ୍‌ନା ମାନତ୍‌ନାଇ, ଆରି ଜଅନର୍‌ଟାନେ ଡୁବନ୍‌ ନେଅତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ଜିସୁ ଆରିତରେକ୍‌ କଇଲା, ଏବର୍‌ ଲକ୍‌ମନ୍‌କେ ମୁଇ କାର୍‌ ସଙ୍ଗ୍‍ ସମାନ୍‌ କର୍‌ବି ? ଆରି ସେମନ୍‌ କାର୍‌ ପାରା ? ");
INSERT INTO dso_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ଜନ୍‌ ପିଲାମନ୍‌ ଡାଣ୍ଡେବାଟେ ବସି ସେମନ୍‌ ସେମନ୍‌ ଡାକାଡାକିଅଇ କୁଆକୁଇ ଅଇବାଇ, “ ଅଇରେ, ଆମେ ତମର୍‌ଲଗେ ବାଉଁସି ପୁକ୍‌ଲୁ, ତମେ ନାଟ୍‌ କରାସ୍‌ନାଇ, ଦୁକର୍‌ ଗିତ୍‌ ଗାଇଲୁ, ତମେ କାନ୍ଦାସ୍‌ନାଇ, ସେମନ୍‌ ତାକର୍‌ପାରା । ");
INSERT INTO dso_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","କାଇକେବଇଲେ, ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ଆସି ଉପାସେ ରଇ, ଆମଟ୍‌ ଅଇଲା ପଲ୍‌ରସ୍‌ ମିସା କାଏନାଇ, ଆରି ତମେ ତାକେ କଇଲାସ୍‌ନି ଡୁମା ଦାରିଆଚେ ବଲି । ");
INSERT INTO dso_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମୁଇ ଆସି କିଆପିଆ କଲିନି, ଆରି ତମେମନ୍‌ କଇଲାସ୍‌ନି, ଦେକା ଅ ! ଏ ଗଟେକ୍‌ କାଉରାଟା ଆରି ମଦୁଆଟା, ସିସ୍‌ତୁମାଙ୍ଗୁମନର୍‌ ଆରି ପାପିମନର୍‌ ମଇତର୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ମାତର୍‌ ଜନ୍‌ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ଗିଆନ୍‌ ମାନ୍‌ବାଇ, ସେମନର୍‌ଟାନେ ମାପ୍‌ରୁ ସତ୍‌ ଇସାବେ ଡିସ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ଆରି ପାରୁସିମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ କାଇବାକେ ଡାକ୍‌ଲା । ତେଇ ଜିସୁ ପାରୁସିର୍‌ ଗରେ ଜାଇକରି କାଇବାକେ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ଆରି ଦେକା, ସେ ନଅରେ ଗଟେକ୍‌ ପାପି ମାଇଜି ରଇଲା । ଜିସୁ ପାରୁସିର୍‌ ଗରେ କାଇବାକେ ବସିଆଚେ ବଲି ଜାନିକରି, ସେ ଗଟେକ୍‌ କଣ୍ଡିତେଇ ବାସ୍‌ନା ଚିକନ୍‌ ଆନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ପଚ୍‌ବାଟେ ଜିସୁର୍‌ ପାଦ୍‌ଲଗେ ଟିଆଅଇ ଆଁସୁ ଜରାଇ ଜରାଇ ତାର୍‌ ଆଁସୁ ପାନି ସଙ୍ଗ୍‌ ଜିସୁର୍‌ ପାଦ୍‌ ବିଜାଇକରି ତାର୍‌ ଚେଣ୍ଡିସଙ୍ଗ୍‌ ସେଟା ପୁଚ୍‌ବାର୍‌ ଦାର୍‌ଲା । ଆରି ତାର୍‌ ପାଦେ ଚୁମି ଚୁମି କରି ସେ ଚିକନ୍‌ ଲାଗାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ସେଟା ଦେକିକରି ଜନ୍‌ ପାରୁସି ତାକେ ଡାକିରଇଲା, ସେ ମନେ ମନେ ବାବ୍‌ଲା, “ଜଦି ଏ ଲକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ଅଇରଇତା ବଇଲେ, ଆକେ ଜେ ଚିଇଲାନି, ସେ କେ ଆରି ସେଟା କେନ୍ତାର୍‌ ମାଇଜି, ବଲି ଜାନ୍‌ତା । କାଇକେବଇଲେ ସେ ଗଟେକ୍‍ ପାପି ମାଇଜି ।” ");
INSERT INTO dso_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ଜିସୁ ତାକେ କ‍ଇଲା, “ସିମନ୍‌ ତକେ ମୁଇ ଅଲପ୍‌ କଇବାର୍‌ ଆଚେ ।” ସେ କଇଲା, “ଗୁରୁ କୁଆ ତେବେ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“ଗଟେକ୍‌ ସାଉକାରର୍‌ ରୁନ୍‌ ନେଇରଇବା ଦୁଇଲକ୍‌ ରଇଲାଇ, ଗଟେକ୍‌ଲକ୍‌ ପାଁଚ୍‌ସ ରୁପାଟାଙ୍ଗା ଆରି ଗଟେକ୍‌ଲକ୍‌ ପଚାସ୍‌ ରୁପାଟାଙ୍ଗା ରୁନ୍‌ କରିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ରୁନ୍‌ ବାନ୍ଦ୍‌ବାକେ ସେମନ୍‌କେ କାଇଟା ନ ରଇଲାଜେ, ସାଉକାର୍‌ ଦୁଇଲକର୍‌ ଜାକ ରୁନ୍‌ ଚାଡିଦେଲା । ତେବେ ସେମନର୍‌ ବିତ୍‌ରେ କେ ତାକେ ବେସି ଆଲାଦ୍‌ କର୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ସିମନ୍‌ କ‍ଇଲା, “ମୁଇ ବାବ୍‌ଲିନି, ସାଉକାର୍‌ ଜାକେ ଅଦିକ୍‌ ରୁନ୍‌ ଚାଡିଦେଲା, ସେ ।” ଜିସୁ ତାକେ କଇଲା, “ତମେ ଟିକ୍ ବିଚାର୍‌ କଲାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ଆରି ଜିସୁ ସେ ମାଇଜିର୍‌ବାଟେ ମୁ ବୁଲାଇକରି ସିମନ୍‌କେ କଇଲା, “ଏ ମାଇଜିକେ ଦେକ୍‌ଲୁସ୍‌ନି ? ମୁଇ ତମର୍‌ ଗରେ ଆଇଲି, ମକେ ଗଡ୍‌ ଦଇବାକେ ପାନି ଦିଆସ୍‌ନାଇ, ମାତର୍‌ ଏ ତାର୍‍ ଆଁସୁପାନି ସଙ୍ଗ୍‌ ମର୍‌ ପାଦ୍‌ ବିଜାଇ ତାର୍‍ ଚେଣ୍ଡିସଙ୍ଗ୍‌ ସେଟା ପୁଚିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ତମେ ମକେ ଚୁମାସ୍‌ନାଇ, ମାତର୍‌ ମୁଇ ବିତ୍‌ରେ ଆଇଲା ବେଲେଅନି ଏ ମର୍‌ ପାଦେ ଚୁମି ଚୁମି, ତାକେନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ତମେ ମକେ ସନ୍‌ମାନର୍‌ ସଙ୍ଗ୍‌ ମୁଣ୍ଡେ ଚିକନ୍‌ ଲାଗାଆସ୍‌ନାଇ, ମାତର୍‌ ଏ ମର୍‌ ପାଦେ ବାସ୍‌ନା ଚିକନ୍‌ ଲାଗାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ତେବର୍‌ପାଇ ମୁଇ ତକେ କଇଲିନି, ଏ ମାଇଜିର୍‌ କେତେ କେତେ ପାପ୍‌ କେମାଅଇଲାଆଚେ, କାଇକେବଇଲେ ସେ ବେସି ଆଲାଦ୍‌ କଲା, ମାତର୍‌ ଜାକେ ଅଲପ୍‌ କେମା ଦିଆଅଇସି, ସେ ଅଲପ୍‌ ଆଲାଦ୍‌ କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ଆରି ଜିସୁ ସେ ମାଇଜିକେ କଇଲା, “ତର୍‌ ସବୁ ପାପ୍‌ କେମା ଅଇଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ତେଇ ଜିସୁର୍‌ସଙ୍ଗ୍‍ କାଇବାକେ ବସିରଇବା ଲକ୍‌ମନ୍‌ ମନେ ମନେ କଇବାର୍‌ ଦାର୍‌ଲାଇ, “ପାପ୍‌ ମିସା କେମାକଲାନିଜେ, ଏ କେ ?” ");
INSERT INTO dso_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ମାତର୍‌ ଜିସୁ ସେ ମାଇଜିକେ କଇଲା, “ତୁଇ ମକେ ବିସ୍‌ବାସ୍‌ କଲାର୍‌ପାଇ ବଲି ରକିଆ ପାଇଆଚୁସ୍‌, ସାନ୍ତିସଙ୍ଗ୍‍ ଉଟିଜା ।” ");
INSERT INTO dso_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ତେଇଅନି ଚନେକ୍‌ ଗାଲାପଚେ, ଜିସୁ ନଅରେ ନଅରେ ଆରି ଗାଏଁ ଗାଏଁ ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ସୁବ୍‌କବର୍‌ କଇ ବୁଲ୍‌ବାର୍‌ ଦାର୍‌ଲା, ଆରି ବାରଟା ସିସ୍‌ମନ୍‌ ତାର୍‌ ସଙ୍ଗ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ଜନ୍‌ ମାଇଜିମନ୍‌ ଡୁମାଦାର୍‌ଲା ଟାନେଅନି ଆରି ଜର୍‌ଦୁକା ଟାନେଅନି ନିକ ଅଇରଇଲାଇ, ସେମନ୍‌ ମିସା ତାର୍‌ ସଙ୍ଗ୍‌ ରଇଲାଇ । ମାଇଜିମନର୍‌ ବିତ୍‌ରେ ଅନି ମରିୟମ୍‌ ଜାକେ କି ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ବଲି କଇବାଇ । ଜାର୍‌ଟାନେଅନି ସାତ୍‌ଟା ଡୁମା ବାରଇ ଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ଏରଦ୍‌ ରାଜାର୍‌ ଗୁମସ୍‌ତା କୁଜାର୍‌ ମାଇଜି ଜଆନା, ସସନା, ଆରି କେତେକ୍‌ କେତେକ୍‌ ମାଇଜିମନ୍‌, ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ରଇ ନିଜର୍‌ ନିଜର୍‌ ଦନ୍‌ ସାରାଇ ତାକେ ସେବା କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ଜେଡେବେଲେ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ଜାଗାଇ ଟୁଲ୍‌ଅଇଲାଇ, ଆରି ନଅରେ ନଅରେ ଅନି ତାର୍‌ଲଗେ ଆଇଲାଇଜେ ଜିସୁ ଏନ୍ତି ଉଦାଅରନ୍‌ ଦେଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ଗଟେକ୍‌ ଚାସି ତାର୍‌ ବିଅନ୍‌ ବୁନ୍‌ବାକେ ବାରଇଲା । ସେ ବୁନୁ ବୁନୁ କେତେଟା ବିଅନ୍‌ ବାଟେ ଅଦର୍‌ଲା । ଲକ୍‌ମନ୍‌ ସେଟା ମାଣ୍ଡ୍‌ଚୁଣ୍ଡ କରିଦେଲାଇ ଆରି ଚଡଇମନ୍‌ ଆସି କାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","କେତେଟା ପାକ୍‌ନା ବାଡି ରଇଲା ବୁଏଁ ଅଦର୍‌ଲା, ସେଟା ଆଁକ୍‌ରି ଗାଜା ଅଇଲା, ମାତର୍‌ ମାଟି ନ ବିଜିରଇଲାଜେ ସୁକିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","କେତେଟା କାଟାବୁଟାମନର୍‌ ମଜାଇ ଅଦର୍‌ଲା । କାଟାବୁଟାମନ୍‌ ଦାପ୍‌ରେ ବଡିକରି ଆଁକର୍‌ଲାଟାମନ୍‌କେ ଚାପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ଆରି ବାକି କେତେଟା ନିକ ଜମିଟାନେ ଅଦର୍‌ଲା ଆରି ସଏ ଗୁନ୍‌ ପଲ୍‌ ପଲ୍‌ଲା ।” ଏଟା କଇସାରାଇ ଜିସୁ ଆଉଲିଅଇକରି କଇଲା, “ଜାକେ ସୁନ୍‌ଲାପାରା କାନ୍‌ ଆଚେ, ସେ ସୁନ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ତାର୍‌ ସିସ୍‌ମନ୍‌ ଏ ଉଦାଅରନ୍‌ ଦେଇରଇବାଟା କାଇଟା ଅଇରଇସି ବଲି ତାକେ ପାଚାର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ତେଇ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ଟିକିନିକି ବିସଇ ଜାନତ୍‌ ବଲି ତମ୍‌କେ ଗିଆନ୍‌ ଦିଆଅଇଲାଆଚେ, ମାତର୍‌ ବିନ୍‌ଲକ୍‌ମନ୍‌କେ ଉଦାଅରନ୍‌ ଦେଇ କ‍ଇଅଇସି, ଜେନ୍ତାରିକି ସେମନ୍‌ ଦେକି ଦେକି ନ ଦେକତ୍‌ କି ସୁନି ସୁନି ମିସା ନ ବୁଜତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“ଉଦାଅରନର୍‌ କାତା ଏନ୍ତାରି, ବିଅନ୍‌ ଅଇଲାନି ପର୍‌ମେସରର୍‌ ବାକିଅ । ");
INSERT INTO dso_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ବାଟ୍‌ଲଗେ ଅଦର୍‌ଲା ବିଅନ୍‌, ଏନ୍ତାରି ଲକ୍‌ମନର୍‌ପାରା, ଜେମନ୍‌ ବାକିଅ ସୁନ୍‌ବାଇ । ତାର୍‌ପଚେ ସଇତାନ୍‌ ଆସି, ଜେନ୍ତିକି ସେମନ୍‌ ବିସ୍‌ବାସ୍‌ କରି ରକିଆ ନ ପାଅତ୍‌, ସେ ଲକ୍‌ମନର୍‌ ମନ୍‌ବିତ୍‌ରେଅନି ବାକିଅ ଜିକିନେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ପାକ୍‌ନାବାଡି ବୁଏଁ ଅଦର୍‌ଲା ବିଅନ୍‌ ଏନ୍ତାରି ଲକ୍‌ମନ୍‌କେ ବୁଜାଇସି । ସେମନ୍‌ ବାକିଅ ସୁନି ସାର୍‌ଦାସଙ୍ଗ୍‌ ମାନ୍‌ବାଇ, ମାତର୍‌ ସେମନ୍‌କେ ଚେର୍‌ ନ ରଇଲାର୍‌ପାଇ ବଲି ଚନେକ୍‌ ବିସ୍‌ବାସ୍‌ କର୍‌ବାଇ ଆରି କାଇଆଲେ ପରିକା ବେଲାଇ ବିସ୍‌ବାସ୍‌ ଚାଡିଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ଆରି କାଟାବୁଟାମନର୍‌ ମଜାଇ ଅଦର୍‌ଲା ବିଅନ୍‌ ଏନ୍ତାରି ଲକ୍‌ମନ୍‌କେ ବୁଜାଇସି । ଜନ୍‌ଲକ୍‌ମନ୍‌ ବାକିଅ ସୁନ୍‌ବାଇ, ମାତର୍‌ ଜଗତର୍‌ ଚିନ୍ତା, ଦନ୍‌ ସଁପତିର୍‌ ଚିନ୍ତା କରି କରି ଚାପିଅଇଜିବାଇ । ତେଇ ନିକ ଦାନ୍‌ ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ଆରି ନିମାନ୍‌ ବୁଏଁ ଅଦର୍‌ଲା, ବିଅନ୍‌ ଏନ୍ତାରି ଲକ୍‌ମନ୍‌କେ ବୁଜାଇସି । ଜନ୍‌ ଲକ୍‌ମନ୍‌ କି ନିମାନ୍‌ ଆରି ଦରମ୍‌ ମନେ ବାକିଅ ସୁନିକରି ସେଟା ଡାଟ୍‌ ସଙ୍ଗ୍‌ ଦାରି ସଙ୍ଗଇବାଇ ଆରି ଜାଗିରଇକରି ପଲ୍‌ପଲ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ବତି ଡସାଇ କରି କେ ମିସା ଡାଲାଡାବି ନ ସଙ୍ଗଅତ୍‌ । କି କଟ୍‌ ତଲେ ନ ସଙ୍ଗଅତ୍‌ । ମାତର୍‌ ବତି କୁଦ୍‌ରା ଉପ୍‌ରେ ସଙ୍ଗଇବାଇ । ଜେନ୍ତାରିକି ଆଇଲା ଲକ୍‌ମନ୍‌ ଉଜଲ୍‌ ଦେକିପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“କାଇକେବଇଲେ, ଏନ୍ତାରି ଲୁଚିରଇବା ବିସଇ କାଇଟା ନାଇ, ଜନ୍‌ଟା ଜାନା ନ ପଡେ । ଡାବିଅଇରଇବା ବିସଇ କାଇଟା ନାଇ ଜନ୍‌ଟା ଉଗାଡି ନଏଁ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“ସେଟାର୍‌ ପାଇ, ଜେନ୍ତାରି ସୁନ୍‌ସା, ସେ ବିସଇ ନେଇକରି ଜାଗ୍‌ରତ୍‌ ରୁଆ । କାଇକେବଇଲେ ଜାକେ ଆଚେ ତାକେ ଅଦିକ୍‌ ଦିଆଅଇସି । ଆରି ଜାକେ ନାଇ, ସେ ଜେତ୍‌କି ନିଜର୍‌ଟା ଆଚେ ବଲି ବାବ୍‌ସି, ସେ ଅଲପ୍‌ଟା ମିସା ତାର୍‌ଟାନେଅନି ନିଆଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଜିସୁର୍‌ ମାଆ ଆରି ବାଇମନ୍‌ ତାର୍‍ ଲଗେ ଆଇଲାଇ । ମାତର୍‌ ଲକ୍‌ମନ୍‌ ଜବର୍‌ ରଇଲାଇକେ ତାର୍‌ ସଙ୍ଗ୍‌ ମିସିନାପାର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ତେଇ ଜିସୁକେ ଏ କବର୍‌ ଦେଲାଇ, “ତମର୍‌ ମାଆ ଆରି ବାଇମନ୍‌ ତକେ ଦେକ୍‌ବାକେ ମନ୍‌କରି ବାଇରେ ଟିଆଅଇଲାଇ ଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ମାତର୍‌ ଜିସୁ ଲକ୍‌ମନ୍‌କେ କ‍ଇଲା, “ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ବାକିଅ ସୁନ୍‌ବାଇ ଆରି ମାନ୍‌ବାଇ ସେମନ୍‌ ମର୍‌ ମାଆ ଆରି ବାଇମନ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ଦିନେକ୍‌ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଗଟେକ୍‌ ଡଙ୍ଗାଇ ଚଗ୍‌ଲାଇ, ଆରି ସେ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଆସା, ଗାଡ୍‌ ସେପାଟେ ଜୁ ।” ତେଇ ସେମନ୍‌ ଡଙ୍ଗା ମେଲ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ମାତର୍‌ ଡଙ୍ଗାଗାଟି ଗାଲାବେଲେ ଜିସୁ ସଇଦେଲା । ସେଡ୍‌କିବେଲେ ଗାଡେ ଅଟାତ୍‌ ବାଉପବନ୍‌ ଆଇଲା ଆରି ଡଙ୍ଗାଇ ପାନିପୁରି ବର୍‌ତି ଅଇବାର୍‌ ଦାର୍‌ଲା । ସେମନ୍‌ ବଡ୍‌ ବିପଦେ ପଡିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ତେଇ ସିସ୍‌ମନ୍‌ ଜିସୁର୍‌ଲଗେ ଆସି ତାକେ ଉଟାଇ କଇଲା “ଏ ଗୁରୁ, ଏ ଗୁରୁ, ଆମେ ମରିଜିବୁବେ !” ତେଇ ଜିସୁ ଉଟିକରି ପବନ୍‌ ଆରି ବଡ୍‌ ଲଅଡିକେ ଦମ୍‌କାଇଲା, ଆରି ସେଟା ସବୁ ଚିମ୍‌ରାଇଅଇ ତବିର୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ସେ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ତମର୍‌ ବିସ୍‌ବାସ୍‌ କେନେ ଅଇଲା ?” ମାତର୍‌ ସେମନ୍‌ ଡରିକରି କାବାଅଇ ନିଜେ ନିଜେ କଇବାର୍‌ ଦାର୍‌ଲାଇ । “ତେବେ ଏ କେ ଜେ ପବନ୍‌ ଆରି ପାନିକେ ମିସା ଆଦେସ୍‌ ଦେଲା ଦାପ୍‌ରେ, ସେଟା ସବୁ ତାର୍‌ ଆଦେସ୍‌ ମାନ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ପଚେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଗାଲିଲି ମୁଆଟର୍‌ ସେପାଟେ ଗରାସିୟମନର୍‌ ଜାଗାଇ କେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ଜିସୁ ଡଙ୍ଗାଇଅନି ଉତର୍‌ଲା ଦାପ୍‌ରେ, ସେ ନଅରର୍‌ ଗଟେକ୍‌ ଡୁମାଦାର୍‌ଲା ଲକ୍‌ ତାକେ ବେଟ୍‌ଅଇଲା । ସେ ବେସି ଦିନେଅନି କାଇଟା ନ ପିନ୍ଦିକରି ଗରେ ନ ରଇ, ମସ୍‌ନେ ରଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ସେ ଜିସୁକେ ଦେକି କିର୍‌କିରି ତାର୍‌ ପାଦେ ଅଦ୍‌ରି, ଆଉଲିଅଇ କଇଲା, “ଏ ବେସି ବପୁର୍‌ସଙ୍ଗ୍‌ ରଇବା ପର୍‌ମେସରର୍‌ ପଅ ଜିସୁ, ମର୍‌ ଲଗେ ତମର୍‌ କାଇ କାମ୍‌ ଆଚେ ? ମୁଇ ତମ୍‌କେ ବାବୁଜିଆ କରି କଇଲିନି, ମକେ କସ୍‌ଟ ନ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","କାଇକେ ବଇଲେ ଜିସୁ ଡୁମାକେ ସେ ମୁନୁସର୍‌ ଟାନେଅନି ବାରଇଜାଅ ବଲି ଆଦେସ୍‌ ଦେଇରଇଲା । ସେ ଡୁମା ସେଲକ୍‌କେ ଦାରିଲାଗିରଇଲା, ଆରି ଲକ୍‌ମନ୍‌ ତାକେ ସିକିଲି ସଙ୍ଗ୍‌ ବାନ୍ଦି ଜାଗ୍‌ତେ ରଇଲାଇ । ମାତର୍‌ ସେ ବାନ୍ଦ୍‌ଲାଟା ସବୁ ଚିଡାଇ ପାକାଇତେରଇଲା ଆରି ଡୁମା ତାକେ କିନରା ଜାଗାମନ୍‌କେ ଦାରିଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଜିସୁ ତାକେ ପାଚାର୍‌ଲା, “ତର୍‌ ନାଉଁ କାଇ ନାଉଁ ?” ସେ କଇଲା, ବାଇନି, କାଇକେ ବଇଲେ ତାକେ ଗାଦା ଡୁମାମନ୍‌ ଦାରି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ଆରି ଜିସୁ ଜେନ୍ତିକି ସେମନ୍‌କେ ପାତାଲେ ଜିବାକେ ଆଦେସ୍‌ ନ ଦେଏ, ଏଟାର୍‌ ପାଇ ସେମନ୍‌ ତାକେ ବାବୁଜିଆ କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ତେଇ କୁପ୍‌ଲି ଲଗେ ଗଟେକ୍‌ ମାନ୍ଦା ଗୁସ୍‌ରି ରାସି ଚାର୍‌ତେ ରଇଲାଇ । ଆରି ସେ ଜେନ୍ତାରି ସେମନ୍‌କେ ସେ ଗୁସ୍‌ରି ମାନ୍ଦାର୍‌ ମଜାଇ ପୁର୍‌ବାକେ ଆଦେସ୍‌ ଦେଇସି, ଏଟାର୍‌ ପାଇ ସେମନ୍‌ ଜିସୁକେ ବାବୁଜିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ଜିସୁ ସେମନ୍‌କେ ଆଦେସ୍‌ ଦେଲା ଦାପ୍‌ରେ ଡୁମାମନ୍‌ ସେ ମୁନୁସର୍‌ଟାନେଅନି ବାରଇ ଗୁସ୍‌ରି ରାସିର୍‌ ମଜାଇ ପୁର୍‌ଲାଇ । ପୁର୍‌ଲାକେ ଗୁସ୍‌ରି ମାନ୍ଦା ଜବର୍‌ ପାଲାଇକରି ଗଡ୍‌ଗଡାବାଟେ ଜାଇ ଗାଡେ ଅଦ୍‌ରି ମରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ଗୁସ୍‌ରି ଚାରାଇତେ ରଇଲା ଲକ୍‌ମନ୍‌ ସେ ଗଟ୍‍ନା ଦେକି ପାଲାଇକରି ନଅରେ ଆରି ଗାଉଁମନ୍‌କେ ଜାଇ ସେ କାତା ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ତେଇ ଲକ୍‌ମନ୍‌ ସେ ଗଟ୍‍ନା ଦେକ୍‌ବାକେ ବାରଇ ଆଇଲାଇ ଆରି, ସେମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ଜନ୍‌ ମୁନୁସର୍‌ ଟାନେଅନି ଡୁମାମନ୍‌ ବାରଇଲାଇ, ସେ ଲକ୍‌ ଲୁଗା ପିନ୍ଦି ନିକ ମନର୍‌ ସଙ୍ଗ୍‌ ଜିସୁର୍‌ ପାଦ୍‌ ତଲେ ବସି ରଇବାଟା ଦେକି ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ଆରି ଜନ୍‌ଲକ୍‌ମନ୍‌ ଏଟା ସବୁ ଦେକି ରଇଲାଇ, ସେମନ୍‌ ସେ ଡୁମା ଦାର୍‌ଲା ଲକ୍‌ କେନ୍ତାରି ନିକ ଅଇଲା, ସେଟା ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ତେଇ ଗରାସିୟମନର୍‌ ଚାରିବେଡ୍‌ତିର୍‌ ଜାଗାର୍‌ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ତାକର୍‌ଟାନେଅନି ଜିବାକେ ଗୁଆରି କଲାଇ । କାଇକେବଇଲେ ସେମନ୍‌ ବେସି ଡରିଜାଇ ରଇଲାଇ ଆରି, ଜିସୁ ଗଟେକ୍‌ ଡଙ୍ଗାଇ ବସି ବାଉଡି ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ମାତର୍‌ ଜନ୍‌ ଲକର୍‌ଟାନେଅନି ଡୁମାମନ୍‌ ବାରଇଜାଇ ରଇଲାଇ, ସେ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ରଇବି ବଲି ଗୁଆରି କର୍‌ବାର୍‌ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ମାତର୍‌ ସେ ତାକେ କଇକରି ପାଟାଇଲା । “ତର୍‌ ଗରେ ବାଉଡି ଜା ଆରି ପର୍‌ମେସର୍‌ ତର୍‌ଲାଗି ଜନ୍‌ ଜନ୍‌ କାମ୍‌ କଲାଆଚେ ସେ ସବୁ କଇଦେସ୍‌ ।” ତେଇ ସେ ଲକ୍‌ ଇଣ୍ଡିଜାଇ ଜିସୁ ତାର୍‌ ପାଇ ଜନ୍‌ ଜନ୍‌ କାମ୍‌ କରିରଇଲା, ଗୁଲାଇ ନଅରେ ଜାନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ଜିସୁ ଗାଡ୍‌ ସେପାଟେ ଅନି ଏ ପାଟେ ଆରିତରେକ୍‌ ବାଉଡି ଆଇଲା ପଚେ, ଲକ୍‌ମନ୍‌ ତାକେ ସାର୍‌ଦା ସଙ୍ଗ୍‌ ମାନ୍‌ଲାଇ । କାଇକେ ବଇଲେ ସେମନ୍‍ ତାକେ ଜାଗି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ଆରି ଏଦେ ଦେକା ! ଜାଇରସ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଆଇଲା । ସେ ଜିଉଦି ଲକ୍‌ମନର୍‌ ପାର୍‌ତନା ଗରର୍‌ ମୁକିଆ ରଇଲା । ସେ ଜିସୁର୍‌ ପାଦ୍‌ ତଲେ ଅଦ୍‌ରି ତାର୍‌ ଗରେ ଆଇବାକେ ଗୁଆରି କଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","କାଇକେ ବଇଲେ ତାଉଁକେ ଗଟେକ୍‌ସେ ବାର ବରସର୍‌ ଟକି ରଇଲା ଆରି ସେ ମଲାପାରା ଅଇଜାଇରଇଲା । ମାତର୍‌ ଜିସୁ ଜାଇତେ ରଇବାବେଲେ ଲକ୍‌ମନ୍‌ ତାର୍‌ ଉପ୍‌ରେ ମାଣ୍ଡାଚୁଣ୍ଡାଅଇଜାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ସେଡ୍‌କିବେଲେ ବାର ବରସ୍‌ ଦାରି ବନି ଜାଇତେ ରଇବା ଗଟେକ୍‌ ରଗିନି ମାଇଜି ରଇଲା । ନିଜର୍‌ ସବୁଡାବୁ ସାରାଇକରି ମିସା କାର୍‌ ଲଗେ ଜାଇ ନିକ ଅଇ ନାପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ସେ ପଚ୍‌ବାଟେଅନି ଆସି ଜିସୁର୍‌ ଲୁଗା ଜାଲି ଚିଇଲା । ଚିଇଲା ଦାପ୍‌ରେ ତାର୍‌ ବନି ଜିବାଟା ତେବ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ତେଇ ଜିସୁ କଇଲା, “କେ ମକେ ଚିଇଲା ?” ମାତର୍‌ ସବୁ ଲକ୍‌ ନାଇ ବଲି କଇଲାଇଜେ, ପିତର୍‌ କଇଲା, “ଏ ଗୁରୁ ଲକ୍‌ମନ୍‌ ମାଣ୍ଡାଚୁଣ୍ଡାଅଇ ତମର୍‌ ଉପ୍‌ରେ ଡାବିଅଇଆଇଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ମାତର୍‌ ଜିସୁ କଇଲା, “କେ କି ଗଟେକ୍‌ ଲକ୍‌ ମକେ ଚିଇଲା, କାଇକେ ବଇଲେ ମର୍‌ ବିତ୍‌ରେଅନି ବପୁ ବାରଇଲା ବଲି ମୁଇ ଜାନ୍‌ଲି ।” ");
INSERT INTO dso_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ଜେଡେବଲ୍‌ ମାଇଜି ଦେକ୍‌ଲାଜେ ମୁଇ ଲୁଚିନାପାରି, ସେ ତର୍‌ତରି ତର୍‌ତରି ଆସି ଜିସୁର୍‌ ପାଦେ ଅଦ୍‌ରି, କାଇଟାର୍‌ ପାଇ ତାକେ ଚିଇଲା, ଆରି କେନ୍ତାରି ଦାପ୍‌ରେ ନିକ ଅଇଲା, ସେଟା ସବୁ ଲକର୍‌ ମୁଆଟେ ଜାନାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ତେଇ ଜିସୁ ତାକେ କଇଲା, “ନୁନି ତର୍‌ ବିସ୍‌ବାସ୍‌ ତକେ ନିମାନ୍‌ କଲାଆଚେ ସାନ୍ତିଅଇ ଉଟିଜା ।” ");
INSERT INTO dso_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ସେ ଏ କାତା କଇବା ବେଲେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରର୍‌ ମୁକିଆ ଜାଇରସର୍‌ ଗରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଆସି କଇଲା, “ତମର୍‌ ଟକି ମରିଗାଲାବେ, ଗୁରୁକେ ଆରି କସ୍‌ଟ ଦିଆସ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ମାତର୍‌ ଜିସୁ ଏଟା ସୁନି ଜାଇରସ୍‌କେ କ‍ଇଲା, “ଡରାନାଇ ଅବ୍‌କା ବିସ୍‌ବାସ୍‌ କରା, ସେ ବଁଚ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ଜିସୁ ଜାଇରସର୍‌ ଗରେ ଆସି ପିତର୍‌, ଜଅନ୍‌ ଆରି ଜାକୁବ୍‌ ଆରି ଟକିର୍‌ ବାବା ମାଆ କେ ଚାଡିକରି କାକେ ମିସା ବିତ୍‌ରେ ଡାକିନେଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ମାତର୍‌ ସବୁ ଲକ୍‌ ଟକିର୍‌ ଲାଗି କାନ୍ଦି କାନ୍ଦି କରି ବୁକେ ମାରିଅଇତେ ରଇଲାଇ । ତେଇ ଜିସୁ କଇଲା “କାନ୍ଦା ନାଇ, ସେ ମରେ ନାଇ, ମାତର୍‌ ସଇ ଦେଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ମାତର୍‌ ଟକି ମରିଗାଲାଆଚେ ବଲି ଜାନି ରଇଲାଇଜେ ଲକ୍‌ମନ୍‌ ଜିସୁକେ କିଜାଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ମାତର୍‌ ଜିସୁ ଟକିର୍‌ ଆତେ ଦାରି କଇଲା, “ଏ ନୁନି ଉଟ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ତେଇ ଟକିର୍‌ ଜିବନ୍‌ ବାଉଡି ଆଇଲା, ଆରି ସେ ସେଡ୍‌କି ବେଲେସେ ଉଟ୍‌ଲା । ଜିସୁ ତାକେ କାଇଟା ଆଲେ କାଇବାକେ ଦିଆସ୍‌ ବଲି ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ତେଇ ଟକିର୍‌ ବାବା ମା କାବା ଅଇଗାଲାଇ, ମାତର୍‌ ଜିସୁ ସେ ଗଟ୍‍ନାର୍‌ କାତା କାକେ ଜାନାଆ ନାଇ ବଲି ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ପଚେ ଜିସୁ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ରୁଣ୍ଡାଇକରି, ସେମନ୍‌କେ ସବୁ ଡୁମା ଚାଡାଇବାକେ, ରଗ୍‌ ନିକ କର୍‌ବାକେ ବପୁ ଆରି ଅଦିକାର୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ଆରି ସେମନ୍‌କେ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଜାନାଇବାକେ ଆରି ରଗ୍‌ଦୁକା ଅଇରଇବା ଲକ୍‌ମନ୍‌କେ ନିକ କର୍‌ବାକେ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ସେମନ୍‌କେ କଇଲା, “ତମେ ଜିବାବେଲେ ଡାଙ୍ଗ୍‌ କି ମୁନା କି ରୁଟି, କି ଡାବୁ କାଇଟା ମିସା ନିଆନାଇ । ପିନ୍ଦ୍‌ଲାଟା ଚାଡିକରି ଆରି ଉଚ୍‌କା ନିଆନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ଜେଡେବେଲେ ତମ୍‌କେ ଜାର୍‌ ଗରେ ଡାକିନେବାଇ, ସେ ନଅର୍‌ ଚାଡି ଜିବାଜାକ ତେଇସେ ରୁଆ । ");
INSERT INTO dso_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ଆରି ଜେତେଲକ୍‌ ତମ୍‌କେ ନ ମାନତ୍‌, ସେ ନଅରେଅନି ବାରଇ ଆଇବା ବେଲାଇ, ତାକର୍‌ ବିରୁଦେ ସାକି ଇସାବେ ତମର୍‌ ପାଦେଅନି ଦୁଲି ପାପ୍‌ଡି ଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ତେଇଅନି ସିସ୍‌ମନ୍‌ ଜାଇକରି ଗାଉଁ ଗାଉଁ ବୁଲି ଗୁଲାଇ ଜାଗାଇ ସୁବ୍‌ କବର୍‌ କଇ କଇ ଆରି ଜର୍‌ଦୁକାର୍‌ ଲକ୍‌ମନ୍‌କେ ନିମାନ୍‌ କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଏତ୍‌କିବିତ୍‌ରେ ଗାଲିଲିର୍‌ ମୁକିଅ ରାଜା ଏରଦ୍‌ ଏ ସବୁ ଅଇର‍ଇବା ବିସଇ ଜାନି କାନାବାନା ଅଇଗାଲା । କାଇକେବଇଲେ ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ମଲାତେଇଅନି ଉଟ୍‌ଲାଆଚେ ବଲି କେ କେ କଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ଆରି, କେ କେ ଏଲିୟ ଦର୍‌ସନ୍‌ ଦେଲାଆଚେ ବଲି କଇଲାଇ । ବିନ୍‌ ଲକ୍‌ମନ୍‌ ପୁର୍‌ବକାଲର୍‌ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ଲକ୍‍ ଉଟି ଆସିଆଚେ ବଲି କଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ମାତର୍‌ ଏରଦ୍‌ କଇଲା, “ମୁଇ ତା ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ମୁଣ୍ଡ୍‌ କାଟାଇଆଚି, ମାତର୍‌ ଜାର୍‌ ବିସଇ ଆମେ ଏନ୍ତାର୍‌ କାତା ସୁନ୍‌ଲୁନି, ଏ କେ ?” ଆରି ସେ ତାକେ ଦେକ୍‌ବିବଲି ଚେସ୍‌ଟା କର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ପଚେ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌ ବାଉଡି ଆସି ଜାଇ ଜାଇଟା କରିରଇଲାଇ, ସେ ସବୁ ଜିସୁର୍‌ ଲଗେ ବାତାଇଦେଲାଇ । ତେଇଅନି ଜିସୁ ଜେନ୍ତିକି ଲକ୍‌ମନର୍‌ଟାନେଅନି ବିନେ ରଇବାକେ ସେମନ୍‌କେ ବେତ୍‌ସାଇଦା ନାଉଁର୍‌ ନଅରେ ଡାକିନେଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ମାତର୍‌ ଲକ୍‌ମନ୍‌ ସେଟା ଜାନିକରି ତାକର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ଜିସୁ ସେମନ୍‌କେ ମିସା ଆଲାଦ୍‌କରି ଡାକି ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ବିସଇ କଇବାର୍‌ ଦାର୍‌ଲା । ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ନିକ ଅଇବାର୍‌ ର‍ଇଲା, ସେମନ୍‌କେ ନିକକଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ଏତ୍‌କିବିତ୍‌ରେ ଦିନ୍‌ ସାରି ରାତିଅଇବାର୍‌ ଆରାମ୍‌ ଅଇଲା, ତେଇ ପାଟାଇରଇବା ବାର୍‌ଟା ସିସ୍‌ ଜିସୁର୍‌ଲଗେ ଆସି କଇଲାଇ, “ଲକ୍‌ମନ୍‌ ଜାଇକରି ତାକର୍‌ପାଇ ବାସା ଆରି କାଦିର୍‌ପାଇ ଚାରିବେଡ୍‌ତିର୍‌ ଗାଉଁ ଆରି ଗୁଡାମନ୍‌କେ କଜତ୍‌ । ସେଟାର୍‌ପାଇ ତମେ ସେମନ୍‌କେ ମେଲାନି ଦିଆସ୍‌ । କାଇକେବଇଲେ ଆମେ ଇତି ମେଲାନ୍‌ ଜାଗାଇ ଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ସେମନ୍‌କେ କାଇବାକେ ଦିଆସ୍‌ ।” ସେମନ୍‌ କଇଲାଇ, “ଆମର୍‌ଲଗେ ଏକାଇ ପାଁଚ୍‌ଟା ରୁଟି ଆରି ଦୁଇଟା ମାଚ୍‌ ଚାଡି ଅଦିକ୍‌ ନାଇ । ସେନ୍ତାର୍‌ଆଲେ ଆମେ ଜାଇକରି ଏ ସବୁଲକର୍‌ପାଇ କନ୍ତିଅନି କାଦି ଗେନ୍‌ବୁ ?” ");
INSERT INTO dso_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","କାଇକେବଇଲେ ସେମନ୍‌ ଅବ୍‌କା ମୁନୁସ୍‌ପିଲାମନ୍‌ସେ ପାଁଚ୍‌ ଅଜାର୍‌ ରଇଲାଇ । ଜିସୁ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଗଟେକ୍‌ ଗଟେକ୍‌ ଦାଡି, ପଚାସ୍‌ ଲକ୍‌କେ ଲାକା ବସାଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ତେଇ ସେମନ୍‌ ସେନ୍ତାରିକରି ଲକ୍‌ମନ୍‌କେ ବସାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ଆରି, ଜିସୁ ପାଁଚ୍‌ଟା ରୁଟି ଆରି ଦୁଇଟା ମାଚ୍‌ ଦାରି, ସରଗ୍‌ବାଟେ ମୁ କରି ଦନିଅବାଦ୍‌ ଦେଲା ଆରି ବାଙ୍ଗାଇକରି ସିସ୍‌ମନ୍‌କେ ବାଟାକଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ତେଇ ସବୁଲକ୍‌ ପେଟ୍‌ ପୁର୍‌ତେ କାଇଲାଇ ଆରି ସାନ୍ତି ଅଇଲାଇ । ପଚେ ସିସ୍‌ମନ୍‌ ତେଇ ଅଗ୍‌ଲି ରଇବା ବାଙ୍ଗାଇଲାଟାମନ୍‌ ବାର ଡାଲା ଉବ୍‌ରାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ତରେକ୍‌ ଜିସୁ ଗଟେକ୍‌ ଲକ୍‌ସେ କିନରା ଜାଗାଇ ବସି ପାର୍‌ତନା କର୍‌ବାବେଲେ ସିସ୍‌ମନ୍‌ ତାର୍‌ଲଗେ ଆଇଲାଇ, ଆରି ସେ ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ମୁଇ କେ ବଲି ଲକ୍‌ମନ୍‌ କଇଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ସେମନ୍‌ କ‍ଇଲାଇ, “କେ କେ ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌, ଆରି କେ କେ ଏଲିୟ, ଆରି କେ କେ ପୁର୍‌ବର୍‌ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ଲକ୍‌ ମଲାତେଇଅନି ଜିବନ୍‌ ଅଇଲାଆଚେ ବଲି କଇଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ସେ ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ମାତର୍‌ ତମେ ମୁଇ କେ ବଲି ବାବ୍‌ଲାସ୍‌ନି ?” ପିତର୍‌ କ‍ଇଲା “ତମେ ପର୍‌ମେସର୍‌ ପାଟାଇଲା କିରିସ୍‌ଟ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ତେଇ ଜିସୁ ଏଟା କାକେ ନ କଇବାପାଇ ସେମନ୍‌କେ ଜାଗ୍‌ରତ୍‌କରି ତିଆର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ସେ ସେମନ୍‌କେ କଇଲା, “ପର୍‌ମେସର୍‌ ପାଟାଇଲା ନର୍‌ପିଲା ମୁଇ ବେସି ଦୁକ୍‌ କସ୍‌ଟ ଅଇବାର୍‌ଆଚେ । ପାର୍‌ଚିନ୍‌ମନ୍‌, ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ଆରି ମୁକିଅ ପୁଜାରିମନ୍‌ ମକେ ନ ନାମତ୍‌ । ସେମନ୍‌ ମକେ ମରାଇବାଇ । ଆରି ତିନ୍‌ଦିନ୍‌ ପଚେ ମୁଇ ଆରିତରେକ୍‌ ମଲାତେଇଅନି ଜିବନ୍‌ ଅଇ ଉଟ୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ସେଡ୍‌କିବେଲେ ଜିସୁ ସବୁଲକ୍‌କେ କଇଲା, “ତେବେ କେ ମିସା ମର୍‌ସଙ୍ଗ୍‌ ଆଇବାକେ ମନ୍‌ କର୍‌ସି, ସେ ନିଜର୍‌ ମନ୍‌କଲାଟା ସବୁ ଚାଡିଦେବାର୍‌ ଆଚେ, ଆରି ସବୁଦିନ୍‌ ତାର୍‌ ନିଜର୍‌ କୁର୍‌ସ ବଇ ମର୍‌ ସଙ୍ଗ୍‍ ଆସ । ");
INSERT INTO dso_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","କାଇକେବଇଲେ, ଜେ ନିଜର୍‌ ଜିବନ୍‌ ବଁଚାଇବାକେ ମନ୍‌ କର୍‌ସି, ସେ ସେଟା ଆରାଇସି । ମାତର୍‌ ଜେ ମର୍‌ପାଇବଲି ଜିବନ୍‌ ଆରାଇସି, ସେ ସେଟା ରକିଆ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ଆରି ଜଦି ଗଟେକ୍‌ ମୁନୁସ୍‌ ଗୁଲାଇ ଦୁନିଆ ଜିତିକରି ନିଜେ ବିନାସ୍‌ ଅଇସି, କି ଆରାଇସି, ତେବେ ତାର୍‌ କାଇ ଲାବ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ତେବେ କେ ମିସା ମର୍‌ପାଇ ଆରି ମର୍‌ ବାକିଅର୍‍ ଲାଜ୍‌ ଅଇସି, ଜେଡ୍‌କିବେଲେ ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମୁଇ ନିଜର୍‌ ଆରି ବାବାର୍‌, ଆରି ସୁକଲ୍‌ ଦୁତ୍‌ମନର୍‌ ମଇମାସଙ୍ଗ୍‌ ବାଉଡି ଆଇବି, ସେଡ୍‌କିବେଲେ ତାର୍‌ ବିସ‍ଇ ନେଇ ଲାଜ୍‌ଅଇବି । ");
INSERT INTO dso_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ମାତର୍‌ ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ନ ଦେକ୍‌ବାଜାକ ଇତି ଟିଆଅଇରଇବା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି କେତେଲକ୍‌, ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଦେକ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ଜିସୁ ଏ ସବୁ କଇ ପାକାପାକି ଆଟ୍‍ଦିନ୍‌ ଗାଲାପଚେ, ଜଅନ୍‌, ପିତର୍‌ ଆରି ଜାକୁବର୍‌ ସଙ୍ଗ୍‌ ପାର୍‌ତନା କର୍‌ବାକେ ପର୍‌ବତ୍‌ ଉପ୍‌ରେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଆରି, ସେ ପାର୍‌ତନା କର୍‌ବାବେଲେ ତାର୍‌ ମୁ ବିନ୍‌ ଅଇଗାଲା ଆରି ସେ ପିନ୍ଦ୍‌ଲା ଲୁଗା ଦବ୍‌ ଅଇ ବିଜ୍‌ଲିପାରା ଜିକ୍‌ମିକିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ଆରି ଏଦେ ଦେକା ! ସେଦାପ୍‌ରେ ମସା ଆରି ଏଲିୟ ତାର୍‌ସଙ୍ଗ୍‌ କାତାବାର୍‌ତା ଅଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ସେମନ୍‌ ସରଗର୍‌ ମଇମାସଙ୍ଗ୍‌ ଡିସ୍‌ତେ ରଇଲାଇ । ସେ କେନ୍ତି ଜିରୁସାଲାମେ ଦୁକ୍‌ କସ୍‌ଟ ପାଇ ମରିକରି ପର୍‌ମେସରର୍‌ ଜଜ୍‌ନା ସିଦ୍‌ କର୍‌ବାର୍‌ ଆଚେ ବଲି ସେମନ୍‌ ଜିସୁର୍‌ସଙ୍ଗ୍‌ କାତା ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ସେଡ୍‌କିବେଲେ ପିତର୍‌ ଆରି ତାର୍‌ ସଙ୍ଗର୍‌ ଲକ୍‌ମନ୍‌ ଟାଟିଅଇତେ ସଇଦେଇରଇଲାଇ, ମାତର୍‌ ସେମନ୍‌ ଚେତାଅଇ ଜାଗ୍‌ରତ୍‌ ଅଇବାକେ, ଜିସୁର୍‌ ମଇମା ଆରି ତାର୍‌ସଙ୍ଗ୍‌ ଦୁଇଲକ୍‌ ଟିଆଅଇରଇବାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ମସା ଆରି ଏଲିୟ ବାରଇ ଜିବା ବେଲେ ପିତର୍‌ ଜିସୁକେ କଇବାର୍‌ ଦାର୍‌ଲା, “ଏ ଗୁରୁ, ଆମେ ତା ଏ ଜାଗାଇ ଆଚୁ, ଏଟା ନିକ ଜାଗା, ଇତି ତିନ୍‌ଟା କୁଡିଆ ତିଆର୍‌ କରୁ । ତମର୍‌ପାଇ ଗଟେକ୍‌, ମସାର୍‌ପାଇ ଗଟେକ୍‌ ଆରି ଏଲିୟର୍‌ପାଇ ଗଟେକ୍‌ ।” ମାତର୍‌ ସେ କାଇଟା କଇଲାନି, ସେଟା ସେ ଜାନିନାପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ସେ ଏନ୍ତି କଇବାବେଲେ ବାଦଲ୍‌ ଆସି ସେମନ୍‌କେ ଡାବିଅଇଦେଲା । ବାଦଲ୍‌ ଡାବିଦେଲାକେ ସେମନ୍‌ ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ଆରି, ବାଦ୍‌ଲେଅନି ଏନ୍ତି ବାକିଅ ଆଇଲା, “ଏଟାସେ ମର୍‌ ପିଲା, ଆକେ ମୁଇ ବାଚିଆଚି, ସେ କ‍ଇବାଟା ସୁନା ।” ");
INSERT INTO dso_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ସେ ସବଦ୍‌ ଅଇଲାପଚେ ଜିସୁ ଗଟେକ୍‌ଲକ୍‌ସେ ଡିସ୍‌ଲା । ଆରି, ସେମନ୍‌ ଚିମ୍‌ରା ଅଇରଇଲାଇ, ତେଇ ଜାଇଜାଇଟା ଦେକିରଇଲାଇ, ସେବେଲେ ସେ କାତା କାକେ ନ କଇ, ମନେ ଦାରିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ଆର୍‌କର୍‌ ଦିନେ ଜିସୁ ଆରି ତିନ୍‌ଟା ସିସ୍‌ମନ୍‌ ଡଙ୍ଗ୍‌ରେଅନି ଉତ୍‌ରି ଆଇଲାଇ । ଆରି ସେ ଜାଗାଇ ବେସି ଲକ୍‌ମନ୍‌ ତାକର୍‌ସଙ୍ଗ୍‌ ବେଟ୍‌ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ଆରି ଦେକା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଆଉଲିଅଇ କଇଲା, “ଏ ଗୁରୁ ମୁଇ ତମ୍‌କେ ବାବୁଜିଆ କଲିନି, ମର୍‌ ପିଲାକେ ଅଲପ୍‌ ଦେକି ଦୟାକରା, କାଇକେବଇଲେ ସେ ମର୍‌ ଗଟେକ୍‌ ବଲି ପଅ । ");
INSERT INTO dso_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ଦେକା, ତାକେ ଗଟେକ୍‌ ଡୁମା ଦାର୍‌ସି, ଆରି ସେ ଅଟାତ୍‌ କିର୍‌କିରି ଉଟ୍‌ସି, ତାକେ ସେ ଏନ୍ତି ମଡିପାକାଇସିଜେ, ତାର୍‌ ମୁଏଅନି ପେପୁଲ୍‌ ବାରଇଜାଇସି, ଆରି ସେ ତାକେ କଣ୍ଡିଆବଣ୍ଡିଆ କରି ତାର୍‌ଟାନେଅନି କସ୍‌ଟେ ବାରଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ତାକେ ଡୁମା ଚାଡାଇବାକେ ବଲି ମୁଇ ତମର୍‌ ସିସ୍‌ମନର୍‌ ଲଗେ ଆନି ଗୁଆରି କରିରଇଲି, ମାତର୍‌ ସେମନ୍‌ ନାପାର୍‌ଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଜିସୁ କ‍ଇଲା, “ଏରେ କରାପ୍‌ବାଟେ ଜାଇ ବିସ୍‌ବାସ୍‌ ନ କଲା ଲକ୍‌ମନ୍‌, କେତେ କାଲ୍‌ ଆରି ମୁଇ ତମର୍‌ସଙ୍ଗ୍‌ ମୁର୍‌ଚି ରଇବି, ପିଲାକେ ଇତି ଦାରିଆସା ।” ");
INSERT INTO dso_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ପିଲା ଆଇବାବେଲେ କାର୍‌ ଆତ୍‌ମା ତାକେ ବୁଏଁ ଆପ୍‌ଟିଦେଇ ମଡିପାକାଇଲା, ସେ ଆତ୍‌ମାକେ ଜିସୁ ଦମ୍‌କାଇଲା ଆରି ପିଲାକେ ନିକକରି ତାର୍‌ ବାବାକେ ସର୍‌ପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ତେଇ କେବେ ଦେକି ନ ରଇବା ପର୍‌ମେସରର୍‌ ବପୁ ଦେକି ସବୁଲକ୍‌ କାବା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ତାର୍‌ କରିରଇବା ସବୁ କାମର୍‌ଲାଗି ସବୁଲକ୍‌ ଚକିତ୍‌ ଅଇବାବେଲେ ସେ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଏବେ ମୁଇ କାତା ନିମାନ୍‌କରି କଇଦେଲିନି, ସୁନା । କାଇକେବଇଲେ ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମୁଇ ବିସ୍‌ବାସେ ବିସ୍‌ଦେଲାପାରା ଲକ୍‌ମନ୍‌କେ ସର୍‌ପି ଅଇବାର୍‌ ଗାଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ମାତର୍‌ ସିସ୍‌ମନ୍‌ ସେ କାତା ବୁଜିନାପାର୍‌ଲାଇ, ଆରି ସେଟା ତାକର୍‌ଟାନେଅନି ଲୁଚିରଇଲା । ତେବର୍‌ପାଇ ସେମନ୍‌ ଏଟା ବୁଜିନାପାର୍‌ଲେ ମିସା ଜିସୁକେ ପାଚାର୍‌ବାକେ ଡର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ତରେକ୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେ କେ ମୁକିଆ, ସେ ବିସଇ ନେଇ ଦଦାପେଲା ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ମାତର୍‌ ଜିସୁ ତାକର୍‌ ମନ୍‌ବିତ୍‌ରର୍‌ କାତା ଜାନିକରି, ଗଟେକ୍‌ ସାନ୍‌ ପିଲାକେ ଦାର୍‌ଲା ଆରି ତାକର୍‌ ମୁଆଟେ ଟିଆକରି ସେମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“କେ ମିସା ମର୍‌ ନାଉଁଦାରି ଏ ପିଲାକେ ନାମ୍‌ସି, ସେ ମକେ ନାମ୍‌ସି । ଜେ ମକେ ନାମ୍‌ସି, ସେ ମର୍‌ ପାଟାଇରଇବା ବାବାକେ ନାମ୍‌ସି । ସେଟାର୍‌ପାଇ ତମର୍‌ ବିତ୍‌ରେ ଜେ ସବୁର୍‌ ଟାନେଅନି ସାନ୍‌, ସେ ପର୍‌ମେସର୍‌ ତେଇ ମୁକିଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ତେଇ ଜଅନ୍‌ କ‍ଇଲା, “ଏ ଗୁରୁ, ଆମେ ଗଟେକ୍‌ ଲକ୍‌, ତମର୍‌ ନାଉଁ ଦାରି ଡୁମା ଚାଡାଇବାଟା ଦେକ୍‌ଲୁ ଆରି ତାକେ ନ କର୍‌ ବଲି ତେବାଇଲୁ କାଇକେବଇଲେ ସେ ଆମର୍‌ ଦଲର୍‌ ଲକ୍‌ ନଏଁ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତେବାଆ ନାଇ, ଜନ୍‌ଲକ୍‌ ତମର୍‌ ବିରଦେ ନାଇ, ସେମନ୍‌ ତମର୍‌ ବାଟେ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ପଚେ ଜେଡେବେଲେ ଜିସୁର୍‌ ସର୍‌ଗେ ଜିବାର୍‌ ବେଲା କେଟିଆଇତେରଇଲା, ସେଡେବେଲେ ସେ ଜିରୁସାଲାମ୍‌ ଜିବାକେ ମନ୍‌କଲା । ");
INSERT INTO dso_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ସେ ଜିବା ଆଗ୍‌ତୁ କେତେଟା ଲକ୍‌ମନ୍‌କେ ପାଟାଇଲା । ସେମନ୍‌ ଜାଇକରି ଜିସୁର୍‌ପାଇ ସବୁ କର୍‌ବାକେ ସମିରଣିୟମନର୍‌ ଗଟେକ୍‌ ଗାଏଁ କେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ମାତର୍‌ ଜିସୁ ଜିରୁସାଲାମ୍‌ ଜିବାକେ ମନ୍‌କଲାଆଚେ ବଲି ଜାନିକରି, ତାକେ ଡାକି ବସାଅତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ଏଟାଦେକି ଜାକୁବ୍‌ ଆରି ଜଅନ୍‌ କଇଲାଇ, “ମାପ୍‌ରୁ ଏଲିୟ ମିସା ଜେନ୍ତି କରିରଇଲା, ସେନ୍ତାର୍‌ସେ ଆମେ ବାଦ୍‌ଲେଅନି ଜଇ ଅଦ୍‌ରାଇ ସେମନ୍‌କେ ନାସ୍‌କର୍‌ବାକେ ତମେ ମନ୍‌ କଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ମାତର୍‌ ଜିସୁ ବୁଲିକରି ସେମନ୍‌କେ ଦମ୍‌କାଇକରି କଇଲା, “ତମେମନ୍‌ କେନ୍ତାରି ଆତ୍‌ମାର୍‌ ଲକ୍‌, ଏଟା ନାଜାନାସ୍‌ । ମାପ୍‌ରୁ ପାଟାଇରଇବା ନର୍‌ପିଲା ମୁଇ ମୁନୁସ୍‌ମନର୍‌ ଜିବନ୍‌ ନାସ୍‌ କର୍‌ବାକେ ନ ଆସି, ରକିଆ କର୍‌ବାକେ ଆସିଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ତାର୍‌ପଚେ ସେମନ୍‌ ଆରିଗଟେକ୍‌ ଗାଏଁ ଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ସେମନ୍‌ ଜିବାବେଲେ ବାଟେ ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ କଇଲା, “ତମେ ଜନ୍‌ ଜାଗାଇ ଜାଇସା, ମୁଇ ତମର୍‌ସଙ୍ଗ୍‌ ଆଇବି ।” ");
INSERT INTO dso_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ଜିସୁ ତାକେ କଇଲା, “କକପାନ୍ଦିର୍‌ ପାଆର୍‌ ଆଚେ, ଚଡଇମନ୍‍କେ ଗୁଡା ଆଚେ, ମାତର୍‌ ମାପ୍‌ରୁ ପାଟାଇରଇବା ନର୍‌ପିଲା ମକେ ବସ୍‌ବାକେ ନିଜର୍‌ ଗର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ତାର୍‌ପଚେ ଜିସୁ ଆରିଗଟେକ୍‌ ଲକ୍‌କେ କଇଲା, “ମର୍‌ସଙ୍ଗ୍‌ ଆଉ ।” ମାତର୍‌ ସେ କଇଲା, “ପର୍‌ତୁମ୍‌ ଜାଇ ମର୍‌ ବାବାକେ ଦନ୍‌ କରିଆଇବାଜାକ ମକେ ଆଦେସ୍‌ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ମାତର୍‌ ଜିସୁ ତାକେ କଇଲା, “ମଲାଲକ୍‌ମନ୍‌ ମଲାଲକ୍‌ମନ୍‌କେ ଦନ୍‌ କର୍‌ବାକେ ଚାଡିଦିଆସ୍‌, ମାତର୍‌ ତମେ ଜାଇ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଜାନାଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ଆରିଗଟେକ୍‌ ଲକ୍‌ କଇଲା, “ମାପ୍‌ରୁ ମୁଇ ତମର୍‌ସଙ୍ଗ୍‌ ଆଇବି, ମାତର୍‌ ଗରର୍‌ ଲକ୍‌ମନ୍‌କେ ଗାଲିନି ବଲି କଇକରି ଆଇବାକେ ଆଦେସ୍‌ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ମାତର୍‌ ଜିସୁ ତାକେ କଇଲା, “ଜେ କସ୍‌ବାବେଲେ ନଙ୍ଗଲ୍‌ଦାରି ପଚେ ଦେକିଲାଗିରଇସି, ସେ ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ସେବା କର୍‌ବାକେ ଅଦିକାର୍‍ ନ ପାଏ ।” ");
INSERT INTO dso_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ତାର୍‌ପଚେ ମାପ୍‌ରୁ ଆରି ସତୁରିଦୁଇ ଲକ୍‌କେ ମିସାଇଲା ଆରି ସେ ଜନ୍‌ ଜନ୍‌ ଜାଗାଇ ଆରି ଜନ୍‌ ଜନ୍‌ ନଅରେ ଜିବାକେ ମନ୍‌ କରିରଇଲା, ସେ ଜାଗାମନ୍‌କେ ଦୁଇ ଦୁଇ ଲକ୍‍କରି, ସେ ଜିବା ଆଗ୍‌ତୁ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ଆରି ଜିସୁ ସେମନ୍‌କେ କଇଲା, ଜମିତେଇ ପସଲ୍‌ ସିନା ଅଦିକ୍‌, ମାତର୍‌ କାମ୍‌କରୁମନ୍‌ ଉନା । ତେବର୍‌ପାଇ ତାର୍‌ ଚାସ୍‌କେତେ, ଅଦିକ୍‌ ଲକ୍‌ମନ୍‌କେ ପାଟାଇ ଦେବାକେ ଜମି ସାଉକାର୍‌ଟାନେ ଜାନାଆ । ");
INSERT INTO dso_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ତମେ ଜାଆ । ଦେକା, ବାଲିଆଡୁର୍‌କାମନର୍‌ ବିତ୍‌ରେ ମେଣ୍ଡାମନ୍‌କେ ପାଟାଇଲା ପାରା ମୁଇ ତମ୍‌କେ ପାଟାଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ତାଲା, ମୁନା କି ପାଣ୍ଡଇ ମିସା ନିଆନାଇ, ଆରି ବାଟେ କାକେ ଜୁଆର୍‌ କରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଜାର୍‌ ଗରେ ତମେ କେଟ୍‌ଲେ, ପର୍‌ତୁମ୍‌ କରା, ଏ ଗରେ ସାନ୍ତି ମିଲ । ");
INSERT INTO dso_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ଜଦି ସେ ଜାଗାଇ ଗଟେକ୍‌ ସାନ୍ତିର୍‍ ଲକ୍‌ ରଇସି, ସେନ୍ତାର୍‌ଆଲେ ତମର୍‌ ଆସିର୍‌ବାଦ୍‌ ତାକେ ମିଲ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ତାକର୍‌ଲଗେ ଜନ୍‌ଟା ରଇସି, ସେଟା କାଇକରି, ସେ ଗରେ ରୁଆ । କାଇକେବଇଲେ, ପାଇଟିକରୁ ନିଜର୍‌ ବୁତି ପାଇବାଇଆକା । ଗର୍‌ ଗର୍‌କେ ଜାଆନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଜନ୍‌ ନଅରେ ତମେ କେଟ୍‌ଲେ, ଆରି ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଡାକିନେଲେ, ତେଇ ତମ୍‌କେ ଜନ୍‌ଟା କାଇବାକେ ଦେଲେ ସେଟା କାଆ । ");
INSERT INTO dso_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ସେ ଜାଗାଇ ଜର୍‌ ଦୁକା ଅଇରଇଲା ଲକ୍‌ମନ୍‌କେ ନିକ କରା, ଆରି ସେମନ୍‌କେ କୁଆ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ତମର୍‌ଲଗେ ସେ । ");
INSERT INTO dso_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ମାତର୍‌ ଜନ୍‌ ନଅରେ ତମେ କେଟ୍‌ସା, ତେଇର୍‌ ଲକ୍‌ ତମ୍‌କେ ନ ଡାକିନେଲେ, ସେ ଡାଣ୍ଡେଅନି, ସେ ସାଇ ଅନି ବାରଇ କୁଆ, ");
INSERT INTO dso_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ତମର୍‌ ନଅରର୍‌ ଜନ୍‌ ଦୁଲି ଆମର୍‌ ପାଦେ ଲାଗିଆଚେ, ସେଟାମିସା ତମର୍‌ପାଇ ପାପ୍‌ଡିଦେଲୁନି, ଅଇଲେମିସା ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଲଗେସେ, ଏଟା ତମେ ଜାନିରୁଆ । ");
INSERT INTO dso_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ବିଚାର୍‌ ଅଇବାଦିନେ ସେ ନଅରର୍‌ ଦସା, ଡଣ୍ଡର୍‌ଲାଗି ସଦମର୍‌ ଦସାତେଇଅନି ଅଦିକ୍‌ ରଇସି । ");
INSERT INTO dso_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ଅଇରେ ଡଣ୍ଡ୍‌ପାଇବାକେ ଜାଗିରଇବା କରାଜିନ୍‌ ! ଅଇରେ ଡଣ୍ଡ୍‌ପାଇବାକେ ଜାଗିରଇବା ବେତ୍‌ସାଇଦା ! ତମର୍‌ଟାନେ ବପୁର୍‌ସଙ୍ଗ୍‌ ଜନ୍‌ ଜନ୍‌ ନ ଅଇବା କାମ୍‌ମନ୍‌ ଅଇଲାଆଚେ, ସେ ସବୁ ସର ଆରି ସିଦନେ ଅଇରଇତା ବଇଲେ, ସେମନ୍‌ କେତେକାଲ୍‌ ପୁର୍‌ବେ ବାସ୍‌ତା ପିନ୍ଦି, ଚାରେ ବସି, ମାପ୍‌ରୁର୍‌ଟାନେ ମନ୍‌ ବାଉଡାଇତାଇ । ");
INSERT INTO dso_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ଅଇଲେମିସା ବିଚାର୍‌ଦିନେ ତମର୍‌ ଦସା ସର ଆରି ସିଦନର୍‌ ଦସାଟାନେଅନି ଅଦିକ୍‌ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ଆରି ଏ କପର୍‌ନାଉମ୍‌, ସରଗ୍‌ ଜେତ୍‌କି ଉଁଚ୍‌, ତୁଇ କାଇ ସେତ୍‌କିଜାକ ଉଁଚ୍‌ ଅଇସୁ କି ? ପାତାଲ୍‌ ଜେତ୍‌କି ତଲେ ଆଚେ, ସେତ୍‌କି ତଲେ ତକେ ଆନାଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଜେଡେବେଲେ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତମର୍‌ କାତା ସୁନ୍‌ବାଇ, ସେମନ୍‌ ମର୍‌ କାତା ସୁନ୍‌ବାଇ । ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ନ ମାନତ୍‌, ସେମନ୍‌ ମକେ ନ ମାନତ୍‌, ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ମକେ ନ ମାନତ୍‌, ସେମନ୍‌ ମକେ ପାଟାଇରଇବା ପର୍‌ମେସର୍‌କେ ମିସା ନ ମାନତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ତାର୍‌ପଚେ ସେ ସତୁରି ଲକ୍‌ ବାଉଡି ଆଇଲାଇ ଆରି ସାର୍‌ଦାଅଇକରି କଇଲାଇ, “ମାପ୍‌ରୁ, ତମର୍‌ ନାଉଁ ଦାରି ଆଦେସ୍‌ ଦେଲେ ଡୁମାମନ୍‌ମିସା ଆମର୍‌ କାତା ମାନ୍‌ଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ସଇତାନ୍‌ ବାଦ୍‌ଲେଅନି ବିଜ୍‌ଲି ପାରା ଅଇ ଅଦର୍‌ବାଟା ମୁଇ ଦେକ୍‌ଲି । ");
INSERT INTO dso_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ଦେକା, ମୁଇ ତମ୍‌କେ ସାଁପ୍‌ ଆରି ବିସ୍‌କାକ୍‌ଡା ଉପ୍‌ରେ ଇଣ୍ଡ୍‌ବାକେ ବପୁ ଦେଲିଆଚି, ଆରି ସତ୍‌ରୁର୍‌ ଉପ୍‌ରେ ର‍ଇବା ବପୁ ମିସା ଦେଲିଆଚି । ତମ୍‌କେ କେ ମିସା କାଇଟା କରିନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ଏଲେମିସା ଆତ୍‌ମାମନ୍‌ ଆମର୍‌ କାତା ମାନ୍‌ଲାଇନି ବଲି ସାର୍‌ଦା ଉଆନାଇ । ତମର୍‌ ନାଉଁମନ୍‌ ସର୍‌ଗେ ଲେକାଅଇଆଚେ ବଲି ସାର୍‌ଦାଉଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ଜିସୁ ସେ ଡାଣ୍ଡେ ସୁକଲ୍‌ଆତ୍‌ମାଇ ପୁରୁନ୍‌ଅଇ କଇଲା, “ଏ ବାବା ! ସରଗ୍‌ ଆରି ମଚ୍‌ପୁରର୍‌ ମାପ୍‌ରୁ ! ତୁଇ ଗିଆନି ଆରି ବୁଦିରଇବା ଲକ୍‌ମନର୍‌ଟାନେଅନି ଏ କାତା ଲୁଚାଇରଇଲେ ମିସା, ସାନ୍‌ ପିଲାମନର୍‌ ପାରା ଲକର୍‌ଟାନେ ଜାନାଇଲାସ୍‌ । ଏଟାର୍‌ପାଇ ତମ୍‌କେ ସୁମର୍‌ନା କଲିନି । ଉଁ ବାବା, କାଇକେବଇଲେ ତମେ ଏନ୍ତାଟା ଦେକ୍‌ବାକେ ମନ୍‌କର୍‌ତେ ରଇଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ମର୍‌ ବାବାର୍‌ ସବୁ ବିସଇ ମକେ ସର୍‌ପି ଅଇଲାଆଚେ, ଆରି ପଅ କେ, ଏଟା ବାବାକେ ଚାଡି ଆରି କେ ନାଜାନତ୍‌, ଆରି ବାବା କେ, ଏଟା ପଅକେ ଚାଡି କେ ନାଜାନତ୍‌ । ପଅ ଜାର୍‌ଲଗେ ମର୍‌ ବାବାକେ ଜାନାଇବି ବଲି ମନ୍‌କରିରଇସି, ସେସେ ଜାନିରଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ଜିସୁ ସିସ୍‌ମନର୍‌ବାଟେ ମୁ ବୁଲାଇ ସେମନ୍‌କେ କଇଲା, “ତମେ ଜନ୍‌ ଜନ୍‌ଟା ଦେକ୍‌ଲାସ୍‌ନି, ସେ ସବୁ ଜେ ଦେକ୍‌ସି, ସେଟା ନିକ । ");
INSERT INTO dso_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","କାଇକେବଇଲେ ମୁଇ ତମ୍‌କେ କଇଲିନି, ତମେ ଜନ୍‌ ଜନ୍‌ଟା ଦେକ୍‌ଲାସ୍‌ନି, ସେ ସବୁଜାକ ଦେକ୍‌ବାକେ କେତେ କେତେ ରାଜାମନ୍‌ ଆରି ମାପ୍‌ରରୁ କବର୍‍ ଜାନାଉମନ୍‌ ମନ୍‌କଲାଇ, ମାତର୍‌ ଦେକିନାପାର୍‌ଲାଇ । ଆରି ତମେ ଜନ୍‌ ଜନ୍‌ଟା ସୁନ୍‌ଲାସ୍‌ନି, ସେ ସବୁ ସୁନ୍‌ବାକେ ସେମନ୍‌ ମନ୍‌କଲାଇ, ମାତର୍‌ ସୁନିନାପାର୍‌ଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ତାର୍‌ପଚେ ଗଟେକ୍‌ ଦରମ୍‌ ସାସ୍‌ତର୍‌ ସିକାଉ ତାକେ ପରିକାକରି ପାଚାର୍‌ଲା, “ଏ ଗୁରୁ କେବେ ନ ସାର୍‌ବା ଜିବନ୍‌ ମିଲାଇବାକେ ଆଲେ ମୁଇ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ଜିସୁ ତାକେ କଇଲା, “ନିୟମ୍‌ ସାସ୍‌ତରେ କାଇଟା ଲେକାଆଚେ ? ତୁଇ କେନ୍ତାରି ପଡ୍‌ଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ସେ କଇଲା, “ତମେ ନିଜର୍‌ ସବୁ ଗାଗଡ୍‌, ମନ୍‌, ଆତ୍‌ମା ଆରି ବପୁ ଦେଇ ପର୍‌ମେସର୍‌କେ ଆଲାଦ୍‌ କରା । ଆରି ପଡିସାର୍‌ ଲକ୍‌ମନ୍‌କେ ନିଜର୍‌ ସମାନ୍‌ ଆଲାଦ୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ତାର୍‌ପଚେ ଜିସୁ ତାକେ କଇଲା, “ତମେ ଟିକ୍‌ କଇଲାସ୍‌ । ଏନ୍ତାର୍‌ କର୍‌, ତେବେ ଜିବନ୍‌ ମିଲାଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ମାତର୍‌ ସେ ନିଜେ ଦରମ୍‌ଲକ୍‌ ବଲି ଦେକାଇବାକେ ମନ୍‌କରି ଜିସୁକେ ପାଚାର୍‌ଲା, “ତେବେ କେ ମର୍‌ ପଡିସାର୍‌ ଲକ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଜିସୁ ତାକେ କଇଲା, ଗଟେକ୍‌ ଲକ୍‌ ଜିରୁସାଲମେଅନି ଜିରିଅ ଜିବାବେଲେ ଚର୍‌ମନର୍‌ ମୁଆଟେ ପଡ୍‌ଲା । ଚର୍‌ମନ୍‌ ତାର୍‍ ଲୁଗାପଚିଆ ଚାଡାଇ, ତାକେ ମାର୍‌ଲାଇ ଆରି ମରିଗାଲାପାରା ଅଇଲାକେ ଚାଡି ଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ସେଟା ଅଇସାରି କେତେପର୍‌ ଜିବାକେ ଗଟେକ୍‌ ପୁଜାରି ସେ ବାଟେ ଜାଇତେରଇଲା ଆରି ତାକେ ଦେକି, ବାଟ୍‌ ପିଟାଇଅଇ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ସେନ୍ତାରିସେ ଗଟେକ୍‌ ଲେବିୟ ଲକ୍‌ ମିସା ସେ ଜାଗାଇ ଆସି ତାକେ ଦେକି ବାଟ୍‌ ପିଟାଇଅଇ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ମାତର୍‌ ସମିରଣିୟର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‌ଲଗେ ଆସି, ଦେକ୍‌ଲା ଆରି ବେସି ମନ୍‌ଦୁକ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ଆରି ତାର୍‌ଲଗେ ଜାଇ ମାଡ୍‌ଅଇ କଣ୍ଡିଆ ବଣ୍ଡିଆ ଅଇଲାଟାନେ, ଚିକନ୍‌ ଆରି ଆମଟ୍‌ ଅଙ୍ଗୁର୍‌ରସ୍‌ ଲାଗାଇଦେଲା । ତାକେ ଗର୍‌ଣ୍ଡା ବାନ୍ଦି, ଗଦଉପ୍‌ରେ ବସାଇ, ଲକ୍‌ମନ୍‌ ବସି ମିଟିଙ୍ଗ୍‌ କର୍‌ବା ଗରେ ନେଇ ସେବାଜତନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ସିମରଣିୟ ଲକ୍‌ ଦୁଇଟା ରୁପାଟାଙ୍ଗା ବାର୍‌କରାଇ, ମିଟିଙ୍ଗ୍‌ ଗରର୍‌ ମୁକିଆକେ ଦେଇ କଇଲା, “ଆର୍‌ ସେବା ଜତନ୍‌ କରା, ଆରି ଅଦିକ୍‌ କର୍‌ଚ ଅଇଲେ, ସେଟା ମୁଇ ବାଉଡିଆଇବା ବେଲେ ତମ୍‌କେ ସୁଜିଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ଏ ତିନ୍‌ଲକର୍‌ ବିତ୍‌ରେଅନି କେ ଚର୍‌ମନର୍‌ ଟାନେ ମାଡ୍‌କାଉ ଲକର୍‌ ପଡିସାର୍‌ ଲକ୍‌ ବଲି ବାବ୍‌ଲୁସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ସାସ୍‌ତର୍‌ ସିକାଉ କଇଲା, “ଜନ୍‌ ଲକ୍‌ ତାକେ ଦୟାକଲା, ସେ ଆକା ।” ଜିସୁ ତାକେ କଇଲା, “ଜା ତୁଇ ମିସା ସେନ୍ତାରି କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜିବାବେଲେ ଗଟେକ୍‌ ଗାଏଁ କେଟ୍‌ଲାଇ । ତେଇ ମାର୍‌ତା ନାଉଁର୍‌ ଗଟେକ୍‌ ମାଇଜି ଜିସୁକେ ତାର୍‍ ଗରେ ଡାକି ବସାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ମାର୍‌ତାକେ ମରିୟମ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ବଇନି ରଇଲା । ସେ ମାପ୍‌ରୁର୍‌ ପାଦେ ବସି ତାର୍‌ ବାକିଅ ସୁନ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ମାତର୍‌ ମାର୍‌ତାକେ ବେସି ପାଇଟି ରଇଲାଜେ ଦାନ୍ଦା ଅଇଜାଇତେ ରଇଲା । ତେବର୍‌ପାଇ ସେ ଜିସୁର୍‌ଲଗେ ଆସି କଇଲା, “ଏ ମାପ୍‌ରୁ, ମର୍‌ ବଇନି ଗରର୍‌ ସବୁ ପାଇଟି ମକେ ସେ କରାଇଲାନି, ସେବାଟେ କାଇ ତମର୍‌ ମନ୍‌ ନାଇ କି ? ସେଟାର୍‌ପାଇ ତାକେ କୁଆ, ସେ ମକେ ଆସି ସାଇଜ କର ।” ");
INSERT INTO dso_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ମାତର୍‌ ମାପ୍‌ରୁ ତାକେ କଇଲା, “ଏ ମାର୍‌ତା, ତୁଇ ବେସି ବିସଇ ଚିନ୍ତା କରି, ଦାନ୍ଦାଅଇଗାଲୁସ୍‌ନି, ");
INSERT INTO dso_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ମାତର୍‌, ଗଟେକ୍‌ ବିସଇ ଆକା ସବୁର୍‌ଟାନେଅନି ମୁକିଅ । ସେଟା ମରିୟମ୍‌ ବାଚିକରି ନେଇଆଚେ । ସେଟା ତାର୍‌ଟାନେଅନି କେ ନେଇ ନାପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ତରେକ୍‌ ଜିସୁ ଗଟେକ୍‌ ଜାଗାଇ ପାର୍‌ତନା କର୍‌ତେରଇଲା । ସେ ପାର୍‌ତନା କରି ସାରାଇଲା ପଚେ, ତାକର୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ତାକେ କଇଲା, “ଏ ମାପ୍‌ରୁ ଡୁବନ୍‌ ଦେଉ ଜଅନ ଜେନ୍ତାରି ନିଜର୍‌ ସିସ୍‌ମନ୍‌କେ ପାର୍‌ତନା କର୍‌ବାକେ ସିକାଇଲା, ତମେମିସା ଆମ୍‌କେ ପାର୍‌ତନା କର୍‌ବାକେ ସିକାଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ଜିସୁ ସେମନ୍‌କେ କଇଲା, ଜେଡେବେଲେ ତମେ ପାର୍‌ତନା କର୍‌ସା, ସେଡ୍‌କିବେଲେ କୁଆ, “ବାବା ତମର୍‌ ନାଉଁ ସୁକଲ୍‌ବଲି ସବୁଲକ୍‌ ମାନତ୍‌ । ତମର୍‌ ରାଇଜ୍‌ ଆସ । ");
INSERT INTO dso_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ସବୁଦିନ୍‌ ଆମ୍‌କେ ଆମର୍‌ ଦର୍‌କାର୍‌ ରଇଲା କାଦି କାଇବାକେ ଦିଆ । ");
INSERT INTO dso_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ଆମର୍‌ ସବୁ ପାପ୍‌ କେମା କରିଦିଆସ୍‌, କାଇକେବଇଲେ ଆମେ ମିସା ଆମର୍‌ ବିରୁଦେ ବୁଲ୍‌ କଲା ଲକ୍‌ମନ୍‌କେ କେମା କଲୁନି । ଆମ୍‍କେ ପାପ୍‌ ଦସ୍‌ କରାଇବା ସବୁର୍‌ତେଇଅନି ରକିଆ କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ପଚେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ତମର୍‌ ଏନ୍ତାରି କାର୍‌ ମଇତର୍‌ ଆଚେ କି, ଜାର୍‌ଲଗେ କି ତମେ ମଜାରାତି ଜାଇ କଇପାରାସ୍‌, ଏ ମଇତର୍‌, ମକେ ତିନ୍‌ଟା ରୁଟି ଉଦାର୍‌ ଦେଇରୁଆ, ");
INSERT INTO dso_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","କାଇକେବଇଲେ, ମର୍‌ ଗଟେକ୍‌ ବେସି ଦୁରର୍‌ ସାଙ୍ଗ ଆସିଆଚେ, ତାକେ କାଇବାକେ ଦେବାକେ ମର୍‌ଲଗେ କାଇଟାମିସା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ଆରି ବିତ୍‌ରେଅନି ସେ କ‍ଇସି, ମକେ କସ୍‌ଟ ଦିଆନାଇ, କାପାଟ୍‌ ଡାବ୍‌ଲୁବେ, ଆରି ମର୍‌ସଙ୍ଗ୍‌ ମର୍‌ ପିଲାମନ୍‌ ସଇଆଚତ୍‌ । ତମ୍‌କେ ଉଟିକରି ଦେଇନାପାରି । ");
INSERT INTO dso_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ମୁଇ ତମ୍‌କେ କଇଲିନି, ତମର୍‌ ମ‍ଇତର୍‌ ଅଇରଇଲେ ମିସା ସେ ଉଟିକରି ରୁଟି ନ ଦେଏ, ମାତର୍‌ ତମେ ଲାଜ୍‌ ନ ଅଇ ମାଙ୍ଗିଲାଗିରଇଲେ, ସେ ଉଟିକରି ତକେ ଜେତ୍‌କି ଲଡା, ସେତ୍‌କି ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ମୁଇ ତମ୍‌କେ କଇଲିନି, ମାଙ୍ଗା ତେବେ ତମ୍‌କେ ଦିଆଅଇସି । କଜା, ତେଇ ତମେ ମିଲାଇସା । କାପାଟେ ବାଜାଆ, ତେଇ ତମର୍‌ପାଇବଲି ଉଗାଡି ଦିଆଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","କାଇକେବଇଲେ, ଜେ ମାଙ୍ଗ୍‌ସି, ସେ ପାଇସି । ଜେ କଜ୍‌ସି, ସେ ମିଲାଇସି । ଜେ କାପାଟେ ବାଜାଇସି, ତାର୍‌ପାଇ କାପାଟ୍‌ ଉଗାଡି ଦିଆଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“ଆରି ତମର୍‌ ବିତ୍‌ରେ ଏନ୍ତାରି ବାବା କେ ଆଚେ, ଜେ କି ଜନ୍‌ ବାବାକେ ତାର୍‌ ପଅ ମାଚ୍‌ ମାଙ୍ଗ୍‌ଲେ, ତାକେ ମାଚ୍‌ ନ ଦେଇ ସାଁପ୍‌ ଦେଇସି ? ");
INSERT INTO dso_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","କି ଗାର୍‌ ମାଙ୍ଗ୍‌ଲେ, ସେ ତାକେ ବିସ୍‌କାକ୍‌ଡା ଦେଇସି ? ");
INSERT INTO dso_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ତେବେ ତମେ କରାପ୍‌ ଲକ୍‌ ଅଇଲେ ମିସା, ନିଜର୍‌ ନିଜର୍‌ ପିଲାମନ୍‌କେ ନିକ ନିକ ବିସଇ ଦେବାର୍‌ ଜାନାସ୍‌ । ତେବେ ଜନ୍‌ ବାବା ସର୍‌ଗେଅନି ଦାନ୍‌ କଲାନି, ସେ ଜାନେ, ସେ ତାକେ ମାଙ୍ଗ୍‌ବା ଲକ୍‌କେ କେତେକ୍‌ ଅଦିକ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମା ଦେଇସି !” ");
INSERT INTO dso_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ତରେକ୍‌ ଜିସୁ ଗଟେକ୍‌ ଲକର୍‌ତେଇଅନି ଡୁମା ଚାଡାଇତେରଇଲା । ସେ ଡୁମା ଗୁଲାଟା । ଡୁମା ବାରଇଗାଲା ପଚେ ଗୁଲା ଲକ୍‌ କାତା କଇଲା । କାତାକଇଲାକେ ତେଇ ରଇବା ଲକ୍‌ମନ୍‌ କାବାଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ମାତର୍‌ ସେମନର୍‌ ବିତ୍‌ରେ କେ କେ କଇଲାଇ, “ସେ ଡୁମାମନର୍‌ ନେତା ବାଲ୍‍ଜିବୁଲର୍‌ ସାଇଜ ନେଇ ଡୁମା ଚାଡାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ବିନ୍‌ଲକ୍‌ମନ୍‌ ଜିସୁକେ ପରିକାକରି ପାନ୍ଦେ ପାକାଇବାକେ ବାବ୍‌ତେ ରଇଲା । ତେବର୍‌ପାଇ ପର୍‌ମେସର୍‌ ତାର୍‌ ରକିଆକାରି ବଲି ସବୁକେ ଜାନାଇବାକେ ଗଟେକ୍‌ କାବାଅଇଜିବା ଚିନ୍‌ ଦେକାଇବାକେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ମାତର୍‌ ଜିସୁ ତାକର୍‌ ମନର୍‌ କାତା ଜାନି, ସେମନ୍‌କେ କଇଲା, “ଗଟେକ୍‌ ରାଇଜ୍‌ ଦୁଇ ବାଗ୍‌ ଅଇକରି, ନିଜର୍‌ ନିଜର୍‌ ବିରୁଦେ ଜୁଇଦ୍‌ କଲେ, ସେଟା କୁରୁପ୍‌ନାସ୍‌ ଅଇଜାଇସି । ଗଟେକ୍‌ ଗରର୍‌ ଲକ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିରୁଦେ ଲାଗ୍‌ଲେ, ସେ ଗର୍‌ ମିସା ବାଙ୍ଗିଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ଆରି ସଇତାନ୍‌ ମିସା ବାଗ୍‌ ବାଗ୍‌ ଅଇ, ନିଜର୍‌ ବିରୁଦେ ଉଟ୍‌ଲାନି ବଇଲେ, ତାର୍‌ ରାଇଜ କେନ୍ତି ତବିର୍‌ ଅଇକରି ରଇସି ? ନାଇ ନ ର‍ଏ । ମୁଇ କାଇକେ ଏଟା କଇଲିନି ବଇଲେ, ବାଲ୍‍ଜିବୁଲର୍‌ ସାଇଜ ନେଇ ଡୁମା ଚାଡାଇଲିନି ବଲି ତମେ ତା କଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ତମର୍‌ ପଅମନ୍‌ ବାଲ୍‍ଜିବୁଲର୍‌ ବପୁ ପାଇ ସେମନ୍‌କେ ଚାଡାଇବାଇ, ତେବର୍‌ପାଇ ସେମନ୍‌ସେ ତମ୍‌କେ ବିଚାର୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ନାଇ, ମୁଇ ପର୍‌ମେସରର୍‌ ବପୁସଙ୍ଗ୍‌ ଡୁମା ଚାଡାଇବି । ତେବେ ତା ଏଟା ଜାନାଇ ଦେଲାନି, କି ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ତମର୍‌ ଲଗେ କେଟ୍‌ଲାବେ ବଲି ।” ");
INSERT INTO dso_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ଜେଡେବେଲେ ଗଟେକ୍‌ ବପୁର୍‌ ଲକ୍‌ ଆତ୍‌ଅତିଆର୍‌ ଦାରି ନିଜର୍‌ ଗର୍‌ ଜାଗ୍‌ସି, ସେଡେବେଲାଜାକ ତାର୍‌ ଦନ୍‌ କାଇଟା ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ମାତର୍‌ ଜେଡେବେଲେ ତାର୍‌ ଟାନେଅନି ଅଦିକ୍‌ ବପୁର୍‌ଲକ୍‌ ଆସି, ତାକେ ଲାଗିକରି ଜିତ୍‌ସି । ଗରର୍‌ ସାଉକାର୍‌ ଜନ୍‌ ଆତ୍‌ଆତିଆର୍‌ ଦାରି ନିଜେ ରକିଆ ପାଇତେର‍ଇଲା , ସେ ସବୁଜାକ ବପୁର୍‌ ଲକ୍‌ ଚାଡାଇନେଇସି । ଆରି ଚାଡାଇ ନେଲାଟା ସେ ମନ୍‍କଲା ପାରା କାକେ ମିସା ବାଟା କରିଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ଜେ ଆମ୍‌କେ ବିରଦ୍‌ ନ କରେ, ସେ ଆମର୍‌ ନିଜର୍‌ ଲକ୍‌ । ଜେ ମର୍‌ ସଙ୍ଗ୍‍ କୁଡାଏନାଇ, ସେ ବିଚିପାକାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ଗଟେକ୍‌ କରାପ୍‌ ଆତ୍‌ମା ମୁନୁସର୍‌ଟାନେଅନି ବାରଇଗାଲାପଚେ, ସେ ଆତ୍‌ମା ବିସ୍‌ରାମ୍‌ କର୍‌ବାକେ ସୁକ୍‌ଲା ଜାଗାଇ କନ୍‌ଆଲେ ଲକର୍‌ଟାନେ ରଇବାକେ କଜି ବୁଲ୍‌ସି । ଆରି ଜାଗା ନ ମିଲ୍‌ଲେ କଇସି, ମୁଇ ଜନ୍‌ ଲକର୍‌ ଟାନେଅନି ବାରଇଆସି ରଇଲି, ସେ ଲକର୍‌ଟାନେସେ ବାଉଡି ଜିବି । ");
INSERT INTO dso_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ଜେଡେବେଲେ ସେ ଡୁମା ଚାଡ୍‍ଲା ମୁନୁସର୍‌ଲଗେ ଆସି ପରିଚଲ୍‌ରଇ ନିମାନ୍‌ ସଜାଇଅଇରଇଲାଟା ଦେକ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ତାର୍‌ପଚେ ସେ ଡୁମା ଜାଇକରି ତାର୍‌ଟାନେଅନି ବାନିଆରଇବା ବିନ୍‌ ବିନ୍‌ ସାତ୍‌ଟା ଡୁମାମନ୍‌କେ ଡାକିଆନ୍‌ସି । ସେମନ୍‌ କେଟିକରି ତେଇ ବାସା ଅଇବାଇ, ଆରି ସେ ଲକ୍‌ ଆଗ୍‌ତୁ ଜେନ୍ତାର୍‌ ଅଇରଇଲା, ତାର୍‌ତେଅନି ସାରାସାରି ଅଦିକ୍‌ କରାପ୍‌ ଅଇଜାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ଜିସୁ ଏନ୍ତାରି ସବୁ କାତା କଇବାବେଲେ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ମାଇଜିଟକି ଆଉଲିଅଇ କଇଲା, “କେଡେକ୍‌ କରମର୍‌ ମାଆ ଜେ କି ତମ୍‌କେ ଜନମ୍‌ ଦେଲା ଆରି ନିଜର୍‌ ଦୁଦ୍‌ କୁଆଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ମାତର୍‌ ଜିସୁ କ‍ଇଲା, “ନାଇ, ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ବାକିଅ ସୁନ୍‌ବାଇ ଆରି ସେଟା ମାନ୍‌ବାଇ, ସେମନ୍‌ ନିକ କରମର୍‌ ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ଲକ୍‌ମନ୍‌ ଦଲ୍‌ ଦଲ୍‌ ଅଇ ଜିସୁର୍‌ଲଗେ ଟୁଲ୍‌ ଅଇବାବେଲାଇ ସେ କଇବାର୍‌ ଦାର୍‌ଲା । “ଏବର୍‌ ଜୁଗର୍‌ ମୁନୁସ୍‌ମନ୍‌ କରାପ୍‌, ଏମନ୍‌ କାବା ଅଇଜିବା କାମର୍‌ ଚିନ୍‌ କଜ୍‌ଲାଇନି । ମାତର୍‌ ଜୁନସ୍‌କେ ଗଟ୍‌ଲା ଚିନ୍‌ ଚାଡିକରି ଆରି କାଇ ବିନ୍‌ ଚିନ୍‌ ମିସା ଦିଆ ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","କାଇକେବଇଲେ ଜୁନସ୍‌ ଜେନ୍ତି ନିନିବିୟ ଲକ୍‌ମନର୍‌ପାଇ ଚିନ୍‌ପାରା ଅଇଲା, ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମୁଇ ମିସା ଏବର୍‌ ଲକ୍‌ମନର୍‌ପାଇ ଚିନ୍‌ ପାରା ଅଇବି । ");
INSERT INTO dso_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ବିଚାର୍‌ନା ଦିନେ ଦକିନ୍‌ ଦେସେ ରଇବା ସେବା ନାଉଁର୍‌ ରାନି, ଏବର୍‌ ଲକ୍‌ମନର୍‌ ବିରଦେ ଉଟି, ଏମନ୍‌କେ ଦସି କରାଇସି, କାଇକେବଇଲେ ସେ ରାନି, ସଲ୍‌ମନ୍‌ ରାଜା ସିକାଇରଇବା ଗିଆନର୍‌ କାତା ସୁନ୍‌ବାକେ ବେସି ଦୁର୍‌ଅନି ଆସିରଇଲା । ଆରି ଦେକା ! ସଲ୍‌ମନର୍‌ଟାନେଅନି ଅଦିକ୍‍ ବଡ୍‌ ଲକ୍‌ ଇତି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ବିଚାର୍‌ନାଦିନେ ନିନିବିର୍‌ ଲକ୍‌ମନ୍‌ ଏବର୍‌ ମୁନୁସ୍‌ମନର୍‌ ବିରୁଦେ ଟିଆଅଇ ଏମନ୍‌କେ ଦସି କର୍‌ବାଇ । କାଇକେବଇଲେ ସେମନ୍‌, ଜୁନସ୍‌ ମାପ୍‌ରୁର୍‌ କାତା ଜାନାଇଲାକେ, ପାପ୍‌କାମେଅନି ବାଉଡିରଇଲାଇ, ଆରି ଦେକା ! ଜୁନସର୍‌ ଟାନେଅନି ବଡ୍‌ ଲକ୍‌ ଇତି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“କେ ମିସା ବତି ଡସାଇ ମାନ୍‌ତଲେ ଡାବିକରି ନ ସଙ୍ଗଅତ୍‌ । ମାତର୍‌ ବତି ସଙ୍ଗଇବା କୁଦ୍‌ରାଇ ସଙ୍ଗଇବାଇ, ଜେନ୍ତାରିକି ଗର୍‌ବିତ୍‌ରେ ଜିବାଲକ୍‌ମନ୍‌ ଉଜଲ୍‌ ଦେକିପାର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ତମର୍‌ ଆଁକି, ଗାଗଡର୍‌ ବତି । ଜେଡେବଲ୍‌ ତମର୍‌ ଆଁକି ନିକ ରଇସି, ସେଡେବେଲେ, ତମର୍‌ ଗୁଲାଇ ଗାଗଡ୍‌ ମିସା ଉଜଲ୍‌ ଅଇସି । ମାତର୍‌ ଜେଡେବେଲେ ସେଟା ମୁର୍‌କି ରଇସି, ସେଡ୍‌କିବେଲା ତମର୍‌ ଗାଗଡ୍‌ ମିସା ଆନ୍ଦାର୍‌ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ତେବେ ମନେ ରଅ, ଜାଗ୍‌ରତ୍‌ଅଇ ରୁଆ, ଜେନ୍ତିକି ତମର୍‌ ବିତ୍‌ରର୍‌ ଉଜଲ୍‌ କେବେ ଆନ୍ଦାର୍‌ ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ଏଟାର୍‌ପାଇ ତମର୍‌ ଗୁଲାଇ ଗାଗଡ୍‌ ଜଦି ଉଜଲ୍‌ ଅଇସି ଆରି ତେଇର୍‌ କଣ୍ଡେକ୍‌ ମିସା ଆନ୍ଦାର୍‌ ନ ରଏ, ସେନ୍ତାର୍‌ଅଇଲେ, ବତି ଜେନ୍ତି ଜଗ୍‌ଜଗି ଜାଇ ଉଜଲ୍‌ ଦେଇସି, ସେନ୍ତାରି ତମର୍‌ ଗୁଲାଇ ଗାଗଡ୍‌ ଉଜଲ୍‌ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଜିସୁ କାତା କଇସାରାଇଲା ପଚେ ଗଟେକ୍‌ ପାରୁସିଲକ୍‌ ତାକେ ନିଜର୍‌ ଗରେ କାଇବାକେ ଡାକ୍‌ଲା, ଆରି ଗରେ ବସାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ମାତର୍‌ ଜିସୁ ଜିଉଦି ରିତିନିତି ଇସାବେ ଦୁଆପୁଚା ନ ଅଇରଇଲାକେ ଏଟା ଦେକି ସେ ପାରୁସି ଲକ୍‌ କାବା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ଜିସୁ ତାକେ କଇଲା, “ତମେ ପାରୁସିମନ୍‌ ଗିନା ଆରି ତାଲାର୍‌ ବାଇରେ ମାଞ୍ଜିରଇସା, ମାତର୍‌ ତମର୍‌ ବିତ୍‌ରର୍‌ ସକ୍‌ଡି ବେନ୍‌ବେନା ରଇସି । କରାପ୍‌ଟା ଆରି ଲବ୍‌ କର୍‌ବାଟା ସବୁ ପୁରୁନ୍‌ ଅଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ଏ ବକୁଆମନ୍‌ ! ଜେ ଗାଗଡର୍‌ ବାଇରର୍‌ଟା ତିଆର୍‌ କଲା ଆଚେ, ସେ କାଇ ବିତ୍‌ରର୍‌ଟା ମିସା ତିଆର୍‌ କରେନାଇ କି ? ");
INSERT INTO dso_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ତେବର୍‌ପାଇ ତମେ ଜନ୍‌ଟା କଟିକରି ସଙ୍ଗଇ ଆଚାସ୍‌, ସେଟା ଦୁକିରୁକି ଲକ୍‌ମନ୍‌କେ ଦାନ୍‌କରା, ଆରି ଦେକା, ତମେ ପୁରାପୁରୁନ୍‌ ପରିଚଲ୍‌ ଅଇଜାଇସା ।” ");
INSERT INTO dso_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ଅଇରେ ପାରୁସିମନ୍‌ ! ତମର୍‌ ଉପ୍‌ରେ ଗଟେକ୍‌ ବଡ୍‌ ଡଣ୍ଡ୍‌ ଲାଦିଅଇସିବେ ! କାଇକେବଇଲେ ତମର୍‌ ବାଡେଅନି କାମାଇଲାଟା ଦସ୍‌ବାଗ୍‌ ଅନି ବାଗେକ୍‌ ଦେଲାସ୍‌ନି । ମାତର୍‌ ତମେ ନିଆଇ ଆରି ଦୟା ଏଲା କଲାସ୍‍ନି । ଏଟାସଙ୍ଗ୍‌ ବାଗେକ୍‌ ଦେବାଟା ମିସା ଚାଡ୍‌ବାର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ଅଇରେ ପାରୁସିମନ୍‌, ତମର୍‌ ଉପ୍‌ରେ ଗଟେକ୍‌ ବଡ୍‌ ଡଣ୍ଡ୍‌ ଲାଦିଅଇସିବେ ! କାଇକେବଇଲେ ତମେ ପାର୍‌ତନାଗରେ ମୁକିଅ ଜାଗାଇ ବସ୍‌ବାକେ ମନ୍‌ କର୍‌ସା ଆରି ଆଟେବାଟେ ଲକ୍‌ମନର୍‌ଟାନେଅନି ଜୁଆର୍‌ କରାଇଅଇବାକେ ବଲ୍‌ ବଲାଇଅଇସା । ");
INSERT INTO dso_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ଅଇରେ ପାରୁସିମନ୍‌ ! ତମର୍‌ ଉପ୍‌ରେ ଗଟେକ୍‌ ବଡ୍‌ ଡଣ୍ଡ୍‌ ଲାଦିଅଇସିବେ । କାଇକେବଇଲେ, ତମେ ନ ଡିସ୍‌ବା ସମାଦି ପାରା । ତାର୍‌ ଉପ୍‌ରେ ଆସା ଜା କର୍‌ବା ଲକ୍‌ମନ୍‌ ସେଟା ସମାଦି ବଲି ନାଜାନତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ତେଇ ସାସ୍‌ତର୍‌ ସିକାଇବା ଦରମ୍‌ ଗୁରୁମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ପଣ୍ଡିତ୍‌ ଜିସୁକେ କ‍ଇଲା, “ଏ ଗୁରୁ ତମେ ପାରୁସିମନର୍‌ ବିସଇ କଇକରି ଆମ୍‌କେ ଲାଜ୍‌ କରାଇଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ଜିସୁ କଇଲା, “ଅଇରେ ସାସ୍‌ତର୍‌ ସିକାଉ ପଣ୍ଡିତ୍‌ମନ୍‌ ! ତମର୍‌ ଉପ୍‌ରେ ଗଟେକ୍‌ ବଡ୍‌ ଡଣ୍ଡ୍‌ ଲାଦିଅଇସିବେ ! କାଇକେବଇଲେ ତମେ ଲକ୍‌ମନ୍‌କେ ବେସି ଆବଡ୍‌ ନିୟମ୍‌ ମାନ୍‌ବାକେ କଇଲାସ୍‌ନି, ଆରି ସେ ନିୟମ୍‌ ମାନ୍‌ବାକେ ମୁଲ୍‌କେ ଆଙ୍ଗ୍‍ଟିତେଇ ଉଟାଇବା ଏତ୍‌କି ମିସା ସାଇଜ କରାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ଅଇରେ, ଡଣ୍ଡ୍‌ ପାଉମନ୍‌! ତମର୍‌ ଉପ୍‌ରେ ଗଟେକ୍‌ ବଡ୍‌ ଡଣ୍ଡ୍‌ ଲାଦିଅଇସିବେ । କାଇକେବଇଲେ, ତମେ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ମସ୍‌ନେ ସମାଦି ତିଆର୍‌ କର୍‌ତେରଇସା, ମାତର୍‌ ତମର୍‌ ଆନିଦାଦିମନ୍‌ ସେମନ୍‌କେ ମରାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ତେବେ ତମର୍‌ ଆନିଦାଦିମନର୍‌ ଦରମ୍‌ କରମ୍‌ ବିସଇର୍‌ ତମେ ସାକି ଆଚାସ୍‌ । ଆରି ସେଟା ମାନ୍‌ଲାସ୍‌ନି କାଇକେବଇଲେ ସେମନ୍‌ ସିନା ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ମରାଇରଇଲାଇ, ମାତର୍‌ ତମେ ସେମନର୍‌ ସମାଦିର୍‌ କାମ୍‌ ତିଆର୍‌ କଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ତେବେ ପର୍‌ମେସର୍‌ ମିସା ନିଜର୍‌ ବୁଦିରେ କଇଲାଆଚେ, ମୁଇ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ଆରି କବର୍‌ ନେଉମନ୍‌କେ ସେମନର୍‌ ଲଗେ ପାଟାଇବି । ସେମନର୍‌ ବିତ୍‌ରେ କେତେଲକ୍‌କେ ସେମନ୍‌ ମରାଇବାଇ ଆରି କେତେଲକ୍‌କେ ନିନ୍ଦାକରି କସ୍‌ଟ ଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ସେଟାର୍‌ପାଇ ଜଗତ୍‌ ତିଆର୍‌ଅଇଲାଟାନେଅନି, ଏବଲର୍‌ ବେଲେଅନି ଆରାମ୍‌ କରି ବର୍‌କିଆର୍‌ ପ ଜିକରିୟର୍‌ ଜାକ, ଜାକେ କି ତମେ ମନ୍ଦିର୍‌ ଆରି ବେଦିର୍‌ ମଜାଇ ମରାଇରଇଲା ଜେତ୍‌କି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ମରାଇଆଚାସ୍‌ ସେ ସବୁ ଡଣ୍ଡ୍‌ ଏ ଆଜିକାଲିର୍‌ ଲକ୍‌ମନ୍‌ ପାଇବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ସେ ସବୁର୍‌ ମୁଲିଅ, ଏବର୍‌ ଲକ୍‌ମନର୍‌ ଟାନେଅନି ନିଆ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ଅଇରେ, ଦରମ୍‌ଗୁରୁମନ୍‌ ! ତମର୍‌ ଉପ୍‌ରେ ଗଟେକ୍‌ ବଡ୍‌ ଡଣ୍ଡ୍‌ ଲାଦିଅଇସିବେ ! କାଇକେବଇଲେ, ତମେ ପର୍‌ମେସରର୍‌ ଗିଆନର୍‌ କାପାଟ୍‌ ଡାବିଦେଇ ଆଚାସ୍‌ । ନିଜେ ପର୍‌ମେସରର୍‌ ଗିଆନ୍‌ଟାନେ ନ ଜାଇକରି ତେଇ ଜିବାକେ ମନ୍‌କଲା ଲକ୍‌ମନ୍‌କେ ମିସା ବାଦାଦେଲାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଆରି ଜିସୁ ତେଇଅନି ବାରଇଗାଲାପଚେ, ପାରୁସିମନ୍‌ ଆରି ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ବେସି ଡାଟ୍‌ସଙ୍ଗ୍‌ ଜିସୁକେ ବିରଦ୍‌ କର୍‌ବାକେ ଆରାମ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ତାର୍‌ଟାନେଅନି ବୁଲ୍‌ ଦାର୍‌ବାକେ କାଇ କାଇ ପର୍‌ସନ୍‌ ପାଚାର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ଏତ୍‌କି ବିତ୍‌ରେ ଅଜାର୍‌ ଅଜାର୍‌ ଲକ୍‌ ଟୁଲ୍‌ଅଇକରି, ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ ମାଣ୍ଡାଚୁଣ୍ଡା ଅଇଜାଇତେ ରଇଲାଇ, ସେଡ୍‌କିବେଲେ ଜିସୁ ପର୍‌ତୁମ୍‌ ନିଜର୍‌ ସିସ୍‌ମନ୍‌କେ କଇବାର୍‌ ଦାର୍‌ଲା, “ପାରୁସିମନର୍‌ କମିର୍‌ ପାରା କପଟ୍‌ ତେଇଅନି ଜାଗ୍‌ରତ୍‌ ଅଇରୁଆ । ");
INSERT INTO dso_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ଡାବିଅଇରଇବା ସବୁ ବିସଇ ଜାନାପଡ୍‌ସି, ଆରି ଲୁଚିରଇବା ବିସଇ ସବୁ ଦେକାଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ତେବର୍‌ପାଇ, ତମେମନ୍‌ ଜନ୍‌ ଜନ୍‌ଟା ଆନ୍ଦାରେ କଇଆଚାସ୍‌, ସେ ସବୁଜାକ ଉଜ୍‌ଲେ ସୁନ୍‌ବାଇ, ଆରି ଜନ୍‌ ଜନ୍‌ଟା ବିତର୍‌ଗରେ, କେ ନ ସୁନ୍‌ତେ କଇଆଚାସ୍‌, ସେଟା ଗରର୍‌ ଚାନିଉପ୍‌ରେ ଅନି ସୁନାଇଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ମାତର୍‌ ତମେ ମର୍‌ ମଇତର୍‌, ତମ୍‌କେ ମୁଇ କଇଲିନି, ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଗାଗଡ୍‌କେ ମରାଇବାଇ, ମାତର୍‌ ତାର୍‌ପଚେ ତମର୍‌ ଆତ୍‌ମାକେ କାଇଟା କରିନାପାରତ୍‌, ସେମନ୍‌କେ ଡରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ମାତର୍‌ କାକେ ଡର୍‌ସା, ସେଟା ମୁଇ ତମ୍‌କେ ଜାନାଇବି, ମରାଇଲାପଚେ ନର୍‌କେ ପିଙ୍ଗ୍‌ବାକେ ଜାର୍‌ ଅଦିକାର୍‌ ଆଚେ, ତାକେ ଡରା, ଉଁ ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ପର୍‌ମେସର୍‌କେ ଡରା । ");
INSERT INTO dso_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ପାଁଚ୍‌ଟା ଚେଟିଆ ଚଡଇ କାଇ ଅଲପ୍‌ ଡାବୁକେ ବିକା ନଅଏ କି ? ଏଲେ ମିସା ସେମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌କେ ମିସା ପର୍‌ମେସର୍‌ ନ ପାସ୍‌ରେ । ");
INSERT INTO dso_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ମାତର୍‌ ତମର୍‌ ମୁଣ୍ଡର୍‌ ସବୁ ଚେଣ୍ଡି ମିସା ଏଜା ଅଇଲାଆଚେ । ଡରାନାଇ, ତମେମନ୍‌ କେତେକ୍‌ କେତେକ୍‌ ଚେଟିଆ ଚଡଇର୍‌ ଟାନେଅନି ମୁକିଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ଆରି ମୁଇ ତମ୍‌କେ କଇଲିନି, ଜେ ଜଦି ମକେ ଲକ୍‌ମନର୍‌ ମୁଆଟେ ନାମ୍‌ସି ଆରି ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମୁଇ ମିସା ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ମନର୍‌ ମୁଆଟେ ତାକେ ନାମ୍‌ବି । ");
INSERT INTO dso_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ମାତର୍‌ ଜେ ଲକ୍‌ମନର୍‌ ମୁଆଟେ ମକେ ନ ନାମି, ବିସ୍‌ବାସ୍‌ ନ କରେ, ତାକେ ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ମନର୍‌ ମୁଆଟେ ମୁଇ ଇନ୍‌ କର୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“ଆରି ଜେ ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲାର୍‌ ବିରୁଦେ କଇଲେ, ତାକେ କେମା ଦିଆଅଇସି, ମାତର୍‌ ଜେ ସୁକଲ୍‌ ଆତ୍‌ମାର୍‌ ବିରୁଦେ କଇସି, ତାକେ କେମା ନ ଦିଆଅଏ । ");
INSERT INTO dso_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ଆରି ଜେଡେବେଲେ ସେମନ୍‌ ତମ୍‌କେ ଜିଉଦି ଲକ୍‌ମନର୍‌ ପାର୍‌ତନା ଗରେ, ସାସନ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ଟାନେ କି ବିନ୍‌ ବିନ୍‌ ଅଦିକାରି ମନର୍‌ଟାନେ ବାନ୍ଦିନେଲେ, ସେଡ୍‍କିବେଲେ କାଇଟାବଲି କଇସା, ସେ ବିସଇ ନେଇକରି ଚିନ୍ତା କରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","କାଇକେବଇଲେ କାଇଟା କଇବାକେ ଅଇସି, ସେବେଲାଇ ସୁକଲ୍‌ଆତ୍‌ମା ତମ୍‌କେ ସିକାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ଲକ୍‌ମନର୍‌ ଗଅଲି ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ କଇଲା, “ଏ ଗୁରୁ, ମର୍‌ ବାବାର୍‌ ସଁପତି ବାଗ୍‌ବାଟା କର୍‌ବାକେ ମର୍‌ ବାଇକେ କୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ଏଟା ସୁନି ଜିସୁ ତାକେ କଇଲା, “ଏ ମଇତର୍‌, ତମର୍‌ ବିତ୍‍ରେ ନିଆଇ କର୍‌ବାକେ ଆରି ଦନ୍‌ସଁପତି ବାଗ୍‌ବାଟା କରିଦେବାକେ ମକେ କେ ଅଦିକାର୍‌ ଦେଲାଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଆରି ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଜାଗର୍‌ତା, ସବୁରକାମର୍‌ ଲବ୍‌ କର୍‌ବାଟାନେଅନି ନିଜେ ନିଜେ ଦୁରେ ରୁଆ । କାଇକେବଇଲେ ଗଟେକ୍‌ ଲକର୍‌ ଜିବନ୍‌ଟାନେଅନି ଦନ୍‌ସଁପତି ବଡ୍‌ ବିସଇ ନଏ ।” ");
INSERT INTO dso_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ଆରି ସେ ଲକ୍‌ମନ୍‌କେ ଗଟେକ୍‌ ଉଦାଅରନ୍‌ ଦେଇ କଇଲା, ଗଟେକ୍‌ ସାଉକାର୍‌କେ ତାର୍‌ ଜମିଟାନେଅନି ବେସି ତାସ୍‌ ପାଚ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ସେ ଲକ୍‌ ମନେ ମନେ ବାବ୍‌ନାକରି କଇଲା, “କାଇଟା କର୍‌ବି ? ମର୍‌ କାଦି ଆନି ସଙ୍ଗଇବାକେ ଜାଗାନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ଆରି ସେ କଇଲା, “ଏନ୍ତାରି କର୍‌ବି, ମର୍‌ କାଦି ସଙ୍ଗଇବା ଗରର୍‌ କତି ବାଙ୍ଗାଇକରି ବଡ୍‌ ବଡ୍‌ କରି ତିଆର୍‌କର୍‌ବି ଆରି ତେଇ ମର୍‌ ସବୁ କାଦିକଣ୍ଡା ଜାଗ୍‌ରତ୍‌ କରି ସଙ୍ଗଇବି । ");
INSERT INTO dso_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଆରି ମର୍‌ ଜିବନ୍‌କେ କଇବି, ର ଜିବନ୍‌, ତର୍‌ପାଇବଲି ବେସି ବରସର୍‌ କାଦିକଣ୍ଡା ସଙ୍ଗଇ ଅଇଲାଆଚେ, ପୁଣ୍ଡ୍‌, କାଆ ଆରି ଆରାମ୍‌ସଙ୍ଗ୍‌ ର ।” ");
INSERT INTO dso_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ମାତର୍‌ ପର୍‌ମେସର୍‌ ତାକେ କଇଲା, “ଏରେ ବକୁଆ ଜଦି ଆଜି ରାତି ପର୍‌ମେସର୍‌ ତର୍‌ ଜିବନ୍‌ ମାଙ୍ଗ୍‌ସି ବଇଲେ, ତୁଇ ତର୍‌ପାଇ ଜେତ୍‌କି ସଙ୍ଗଇଆଚୁସ୍‌, ସେ ସବୁ କାର୍‌ଟା ଅଇସି ? ");
INSERT INTO dso_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଜେ ନିଜର୍‌ପାଇ ଦନ୍‌ ଜତନ୍‌ କରି ସଙ୍ଗଇସି, ସେ ପର୍‌ମେସରର୍‌ ମୁଆଟେ ସାଉକାର୍‌ ନଏଁ, ତାର୍‌ପାଇ ଏନ୍ତାରି ଗଟ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଜିସୁ ନିଜର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଏଟାର୍‌ପାଇ ମୁଇ ତମ୍‌କେ କଇଲିନି, କାଇଟା କାଇକରି ଜିବନ୍‌ ବଁଚାଉ ଆରି ଗାଗଡର୍‌ପାଇ କାଇଟା ପିନ୍ଦ୍‌ବୁ ବଲି ଚିନ୍ତା କରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","କାଇକେବଇଲେ କାଦିଟାନେଅନି ଜିବନ୍‌ ଆରି ବସ୍‌ତର୍‌ଟାନେଅନି ଗାଗଡ୍‌ ଆକା ମୁକିଅ । ");
INSERT INTO dso_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ଚଡଇମନର୍‌ ବିସଇନେଇକରି ବାବିଦେକା, ସେମନ୍‌ ନ ବୁନତ୍‌ କି ନ କାଟତ୍‌, ଆରି ସେମନର୍‌ ବାଣ୍ଡାର୍‌ଗର୍‌ କି କାଦି ସଙ୍ଗଇବା ଆମାର୍‌ ଗର୍‌ ନାଇ । ଅଇଲେ ମିସା ମାପ୍‌ରୁ ସେମନ୍‌କେ କାଦି ଜାଗାଇଦେଇସି । ତମେ ଚଡଇମନର୍‌ ଟାନେଅନି କେତେକ୍‌ ଅଦିକାରର୍‌ ଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ତମର୍‌ ବିତ୍‌ରେ ଏନ୍ତାରିଲକ୍‌ ନ ରଅତ୍‍, ଜେ କି ଚିନ୍ତାକରି ତାର୍‌ କଣ୍ଡେକ୍‌ ମିସା ଆଇସ୍‌ ବଡାଇ ପାର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ତେବର୍‌ପାଇ ତମେମନ୍‌ ଗଟେକ୍‌ ସାନ୍‌ ବିସଇ ମିସା କରିନାପାର୍‌ଲାସ୍‌ନି ବଇଲେ ବଡ୍‌ ବଡ୍‌ ବିସଇ କାଇକେ ଚିନ୍ତା କଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ପୁଲ୍‌ମନର୍‌ ବିସଇ ବାବିଦେକା, ସେମନ୍‌ କେନ୍ତି ପୁଟ୍‌ଲାଇନି, ସୁତା ନ କାଟତ୍‌ କି ଲୁଗା ନ ବୁନତ୍‌ । ଏଲେମିସା ମୁଇ ତମ୍‌କେ କଇଲିନି, ସବୁର୍‌ଟାନେଅନି ମଆନ୍‌ ଆରି ଦନି ରାଜା ସଲ୍‌ମନ୍‌ ମିସା ସେ ପୁଲ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ପୁଲର୍‌ ଏତ୍‌କି ସଜାଇ ନ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ଆଜି ଜନ୍‌ ଗାଁସ୍‌ ପଦାଇ ଆଚେ, କାଲିକେ ସେଟା ରୁଣ୍ଡାଇ ଜଇ ଲାଗାଇବାଇ । ସେଟାକେ ପର୍‌ମେସର୍‌ ଏନ୍ତାରି ବେସ୍‌ ଦେଲାନି ବଇଲେ, ଏ ଅଲପ୍‌ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌, ସେ ତମ୍‌କେ ପିନ୍ଦ୍‌ବାକେ କେତେକ୍‌ ଅଦିକ୍‌ ଦେଇସି !” ");
INSERT INTO dso_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“ଆରି କାଇଟା କାଇବୁ ? ବଲି ଚିନ୍ତାକରି ଲାଗିରୁଆନାଇ, ");
INSERT INTO dso_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","କାଇକେବଇଲେ ପର୍‌ମେସର୍‌କେ ନାଜାନ୍‌ଲା ଲକ୍‌ମନ୍‌ ଏ ସବୁ ବିସଇ କଜିବୁଲ୍‌ବାଇ । ମାତର୍‌ ଏ ସବୁ ବିସଇ ତମ୍‌କେ ଦର୍‌କାର୍‌, ସେଟା ତମର୍‌ ବାବା ଜାନିରଇସି । ");
INSERT INTO dso_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ମୁଇ କଇଲିନି ତମେ ପର୍‌ମେସରର୍‌ ସରଗ୍‌ ରାଇଜ୍‌ କଜା, ଆରି ଏ ସବୁ ବିସଇ ସେ ତମ୍‌କେ ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ଏ ଉନା ମେଣ୍ଡାରାସି, ଡରାନାଇ, କାଇକେବଇଲେ ତମର୍‌ ବାବା ତମ୍‌କେ ତାର୍‌ ରାଇଜ୍‌ ଦେବାକେ ମନ୍‌କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ତମ୍‌କେ ଜନ୍‌ ଜନ୍‌ଟା ଆଚେ, ସେଟା ବିକିଦେଇ ଗରିବ୍‌ମନ୍‌କେ ଦାନ୍‌ କରା । ଜନ୍‌ଟା କି କେବେ ନ ସାରେ, ନିଜର୍‌ ନିଜର୍‌ପାଇ ଏନ୍ତାରି କାଣା ନ ଅଇବା ବେସ୍‌ନି ତିଆର୍‌କରା । ଜନ୍‌ଟାନେ ଚର୍‌ ନ ଆସେ କି କିଡାମନ୍‌ ମିସା ନ ନସାଅତ୍‌ । ସର୍‌ଗେ ଏନ୍ତାରି ନ ସାର୍‌ବା ଦନ୍‌ ସଙ୍ଗଇରୁଆ । ");
INSERT INTO dso_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","କାଇକେବଇଲେ ଜନ୍‌ଟାନେ ତମର୍‌ ଦନ୍‌, ତେଇସେ ତମର୍‌ ମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ତମର୍‌ ଆଟର୍‌ ତୁଆଲ୍‌ ବାନ୍ଦିଅଇ ସେବା କର୍‌ବାକେ ଜାଗିରୁଆ, ଆରି ବତି ଲାଗ୍‌ତେରଅ । ");
INSERT INTO dso_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ମାପ୍‌ରୁ ବିବା ବଜିଟାନେଅନି ବାଉଡିଆସି କାପାଟେ ବାଜାଉ ବାଜାଉ ଜନ୍‌ଲକ୍‌ମନ୍‌ ଦାପ୍‌ରେ କାପାଟ୍‌ ଉଗାଡ୍‌ବାକେ ଜାଗିରଇବାଇ, ତମେ ସେମନର୍‌ପାରା ଅଇରୁଆ । ");
INSERT INTO dso_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ମାପ୍‌ରୁ ଆସି ଜନ୍‌ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ଜାଗ୍‌ରତ୍‌ ରଇବାଟା ଦେକ୍‌ସି, ସେମନ୍‌ କେଡେ ନିକ କରମର୍‌ ଲକ୍‌ । ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ସେ ନିଜର୍‌ ଆଁଟାଇ ତୁଆଲ୍‌ ବାନ୍ଦିକରି, ସେମନ୍‌କେ କାଇବାକେ ବସାଇ, ତାକର୍‌ଲଗେ ଜାଇ ସେବାକର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଆରି ସେ ଜଦି ମଜାରାତି କି କୁକ୍‌ଡାଡାକେ ମିସା ଆସି ସେମନ୍‌କେ, ସେନ୍ତାରି ରଇବାଟା ଦେକ୍‌ସି, ସେନ୍ତାର୍‌ଆଲେ ସେ ଦାଙ୍ଗ୍‌ଡାମନ୍‌ କେଡେ ନିକ କରମର୍‌ ଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ମାତର୍‌ ଏଟା ଜାନିରୁଆ, କେଡେବେଲେ ଚର୍‌ ଆଇସି, ଏଟା ଗରର୍‌ ସାଉକାର୍‌ ଜେବେ ଜାନ୍‌ସି, ସେନ୍ତାର୍‌ଆଲେ ସେ ନିଜର୍‌ ଗରର୍‌ ପେଡି ବାଙ୍ଗାଇବାକେ ନ ଦେଏ । ");
INSERT INTO dso_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ତମେ ମିସା ଜାଗ୍‌ରତ୍‌ଅଇ ରୁଆ, କାଇକେବଇଲେ, କେବେ ତମେ ବାବି ନ ରୁଆସ୍‌, ସେ ବେଲେ ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମୁଇ ଆଇବି ।” ");
INSERT INTO dso_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ସେଟାସୁନି ପିତର୍‌ କଇଲା, “ଏ ମାପ୍‌ରୁ ତମେ ଆମ୍‌କେସେ କି ସବୁଲକ୍‌କେ ଏନ୍ତାରି କାତା ଦେକାଇ କଇଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ଜିସୁ କ‍ଇଲା, “ବିସ୍‌ବାସେ ରଇବା ଲକ୍‌ ଆରି ବୁଦିମାନ୍‌ ଲକ୍‌ କେ ଆଚତ୍‌ ? ତାକେ ସେ ସାଉକାର୍‌ ଗର୍‌ ଚାଲାଇବା ଦାଇତ୍‌ ଦେଇସି । ସେ ସମାନ୍‌ ବେଲାଇ ବିନ୍‌ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ କାଦି ଜାଗାଇ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ସାଉକାର୍‌ ଆସି, ତାର୍‌ ନିଜର୍‌ ଦାଙ୍ଗ୍‌ଡା ଏନ୍ତାର୍‌ କର୍‌ବାଟା ଦେକ୍‌ସି ବଇଲେ ସେ କେଡେ ନିକ କରମର୍‌ ଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ସେ ତାକେ ନିଜର୍‌ ସବୁର୍‌ ଉପ୍‌ରେ ଅଦିକାର୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ଜଦି ସେ ଦାଙ୍ଗ୍‌ଡା, ମର୍‌ ସାଉକାର୍‌ ଆଇବାଟା ଅଲ୍‌ସମ୍‌ ଅଇସି ବଲି ମନେକରି, ମାତୁଆଲ୍‌ ଅଇ ବିନ୍‍ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ଲାଗ୍‌ମାର୍‌ କର୍‌ବାର୍‌ ଆରାମ୍‌ କର୍‌ସି, ");
INSERT INTO dso_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ସେନ୍ତାର୍‌ଆଲେ ଜନ୍‌ ଦିନେ ସେ ଜାଗି ନ ରଏ, ଆରି ସେ କେଡେବେଲେ ଆଇବାଟା ଜାନି ନ ରଏ, ସେ ସାଉକାର୍‌ ଆସି ତାକେ ବେସି ବଡ୍‌ ଡଣ୍ଡ୍‌ ଦେଇସି । ଆରି ବିସ୍‌ବାସ୍‌ ନ କର୍‌ବା ଲକର୍‌ ସଙ୍ଗ୍‌ ମିସାଇ ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“ଆରି ଜନ୍‌ ଦାଙ୍ଗ୍‌ଡା ନିଜର୍‌ ସାଉକାରର୍‌ ମନ୍‍ ଜାନିକରି ଜାଗରତ୍‌ ନ ଅଇରଏ, କି ସାଉକାରର୍‌ ମନ୍‌କଲା ଇସାବେ ପାଇଟି ନ କରେ, ତାକେ କର୍‌ଡା ସଙ୍ଗ୍‌ ଅପର୍‌ବଲ୍‌ ମାଡ୍‌ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ମାତର୍‌ ଜେ ତାର୍‌ ମନ୍‌କଲାଟା ନାଜାନିକରି, ଡଣ୍ଡ୍‌ମିଲ୍‌ବା କାମ୍‌ କର୍‌ବାର୍‌ ଦାର୍‌ସି, ତାକେ ଅଲପ୍‌ ମାଡ୍‌ ଅଇସି । ଜନ୍‌ ଲକ୍‌କେ ଅଦିକ୍‌ ଦିଆଅଇରଇସି, ତାକେ ଅଦିକ୍‌ ଦାବି କରାଅଇସି । ଆରି ଲକ୍‌ମନ୍‌ ତାକେ ଜାର୍‌ଲଗେ ଅଦିକ୍‌ ସର୍‌ପି ଦେଲାଇଆଚତ୍‌, ଅଦିକ୍‌ ଅଦିକ୍‌ ଦାବି କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ଜିସୁ କଇଲା, “ମୁଇ ଏ ଦୁନିଆଇ ଜଇ ଲାଗାଇବାର୍‌ ଆଇଲିଆଚି । ସେଟା ଜଦି ଲାଗ୍‌ବାକେ ଆରାମ୍‌ ଅଇଲାନି, ସେନ୍ତାର୍‌ଆଲେ ମୁଇ ମନ୍‌କଲାଟା ପୁରାପୁରୁନ୍‌ ଅଇଗାଲାବେ । ");
INSERT INTO dso_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ମାତର୍‌ ମକେ ଆରି ଗଟେକ୍‌ ଡୁବନେ ଡୁବନ୍‌ ନେବାକେ ପଡ୍‌ସି, ଆରି ସେଟା ନ ସାର୍‌ବାଜାକ, ମର୍‌ ମନ୍‌ବିତ୍‌ରେ କେନ୍ତି କସ୍‌ଟ ଲାଗ୍‌ଲାନି । ");
INSERT INTO dso_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ଜଗତେ ସାନ୍ତି ଦେବାକେ ଆସିଆଚେ ବଲି ତମେ କାଇ ମକେ ବାବ୍‌ଲାସ୍‌ନି କି ? ନାଇ ମୁଇ ସାନ୍ତି ଆନ୍‌ବାକେ ନାଇ, ମାତର୍‌ ବିଚାର୍‌ନା କର୍‌ବାକେ ଆସିଆଚି । ");
INSERT INTO dso_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ଏବେଅନି ଗଟେକ୍‌ ଗରେ ପାଁଚ୍‌ ଲକ୍‌ ରଇଲେ, ଦୁଇଲକର୍‌ ବିରୁଦେ ତିନ୍‌ଲକ୍‌ ଆରି ତିନ୍‌ଲକର୍‌ ବିତ୍‌ରେ ଦୁଇ ଲକ୍‌ ବାଗ୍‌ ଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ପଅର୍‌ ବିରୁଦେ ବାବା, ବାବାର୍‌ ବିରୁଦେ ପଅ, ଜିଇର୍‌ ବିରୁଦେ ମା, ମାଆର୍‌ ବିରୁଦେ ଜିଇ, ବୁଆରିର୍‌ ବିରୁଦେ ସାତ୍‌ରି, ସାତ୍‌ରିର୍‌ ବିରୁଦେ ବୁଆରି ବିନେ ଅଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ଆରି ଜିସୁ ଲକ୍‌ମନ୍‌କେ କଇଲା, “ବୁଡ୍‌ତି ଦିଗେ ବାଦଲ୍‌ ଚଗ୍‌ବାଟା ଦେକ୍‌ଲେ, ପାନି ଆଇସିବେ ବଲି କଇସା । ଆରି ସେନ୍ତାରି ସେ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ଆରି ଦକିଣ୍‌ଦିଗ୍‌ ବାଟେଅନି ପବନ୍‌ ମାର୍‌ବାଟା ଜାନ୍‌ଲେ କାରା ଅଇସି ବଲି କଇସା । ଆରି ସେଟା ସେନ୍ତାରି ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ଏ କୁଟିଆଲ୍‌ମନ୍‌, ତମେ ଜଗତର୍‌ ଆରି ସରଗର୍‌ କାତା ଜାନି ପାଗ୍‌ କେନ୍ତି ଅଇସି ବଲି ଆଗ୍‌ତୁ କଇଲାସ୍‌ନି, ମାତର୍‌ ଏବେ କାଇଟା ଗଟ୍‌ସି, ସେଟା କାଇକେ ନାଜାନ୍‌ଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ଆରି ନିଜେ ନିଜେ କାଇକେ ଟିକ୍‌ ବିଚାର୍‌ କରାସ୍‌ ନାଇ ? ");
INSERT INTO dso_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ଜଦି ତମର୍‌ ବିରଦିସଙ୍ଗ୍‌ ବିଚାର୍‌କାରିଆର୍‍ଲଗେ ଗାଲାସ୍‍ନି, ମଜାବାଟେ ତାର୍‌ସଙ୍ଗ୍‌ ବୁଜାମାନା ଅଇବାକେ ଚେସ୍‌ଟା କରା । ନଇଲେ କେଡେବେଲେ ସେ ତମ୍‌କେ ବିଚାର୍‌କାରିଆର୍‌ ଟାନେ ଜିକିନେଇସି, ବିଚାର୍‌କାରିଆ ସନିଅମନର୍‌ ଆତେ ସର୍‌ପିଦେଇସି, ସନିଅମନ୍‌ ତମ୍‌କେ ବନ୍ଦି ଗରେ ନେଇ ପୁରାଇଦେବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ମୁଇ ତମ୍‌କେ କଇଲିନି, “କେନ୍ତିକଲେ ମିସା ସବୁ ଡାବୁ ନ ସୁଜ୍‌ବାଜାକ ସେ ଜାଗାଇଅନି ବାରଇ ଆସିନାପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ଗାଲିଲିଅନି କେତେ ଲକ୍‌ ଆସି ପାର୍‌ତନା ଗରେ ବଲି ଦେଇତେରଇଲାବେଲେ ପିଲାତ୍‌ ତାର୍‌ ସଇନମନ୍‌କେ ପାଟାଇ ଗାଲିଲିଅ ମନ୍‌କେ ମରାଇଲା । ତେଇ ମଲାଲକର୍‌ ବନି ପୁଜ୍‌ଲା ପସୁର୍‌ ବନି ସଙ୍ଗ୍‌ ମିସ୍‌ଲା । ଏ ବିସଇ କେତେଲକ୍‌ ଆସି ଜିସୁକେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ତେଇ ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ଏ ସବୁ କସ୍‌ଟ ପାଇବାକେ, ଏ ଗାଲିଲିୟମନ୍‌ ବିନ୍‌ ସବୁ ଗାଲିଲିୟମନର୍‌ ଟାନେଅନି ଅଦିକ୍‌ ପାପ୍‍ କଲାଇ ଆଚତ୍‍ ବଲି ବାବ୍‌ଲାସ୍‌ନି କି ? ");
INSERT INTO dso_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ମୁଇ ତମ୍‌କେ କଇଲିନି, ଜେଡେବେଲେ ଜାକ ପାପେଅନି ମନ୍‌ ନ ବାଦ୍‌ଲାଆସ୍‌, ତମେ ସବୁ ଲକ୍‌ ସେନ୍ତାରି କୁରୁପ୍‌ନାସ୍‌ ଅଇଜାଇସା । ");
INSERT INTO dso_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ନଇଲେ ସିଲଅତେଇ ରଇଲା ଜନ୍‌ ଅଟ୍‌ର ଲକର୍‌ ଉପ୍‌ରେ ବଡ୍‍ ଗର୍‌ ଅଦ୍‍ରି ମରିଜାଇ ରଇଲା, ସେମନ୍‍ ତେବେ ? ତମେ ସେମନ୍‌କେ ଜିରୁସାଲାମର୍‌ ବିନ୍‌ ଲକ୍‌ମନର୍‌ ଟାନେଅନି ଅଦିକ୍‌ ପାପ୍‍ କଲାଇ ଆଚତ୍‍ ବଲି ବାବ୍‌ଲାସ୍‌ନି କି ? ");
INSERT INTO dso_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ନାଇ, ମୁଇ ତମ୍‌କେ କଇଲିନି, ପାପେଅନି ମନ୍‌ ନ ବାଦ୍‌ଲାଇଲେ ତମେସବୁ ଲକ୍‌ ସେନ୍ତି କୁରୁପ୍‌ନାସ୍‌ ଅଇଜାଇସା ।” ");
INSERT INTO dso_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଆରି ଜିସୁ ଏ କାତାନି କଇଲା, ଗଟେକ୍‌ ଲକର୍‌ ଅଙ୍ଗୁର୍‌ ବାଡେ ଗଟେକ୍‌ ଡୁମ୍‌ରି ଗଚ୍‌ ରପିରଇଲା । ସେ ସାଉକାର୍‌ ଆସି ତେଇ ପଲ୍‌ କଜ୍‌ଲା, ମାତର୍‌ ମିଲେନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ସେଟାର୍‌ପାଇ ସାଉକାର୍‌ ଅଙ୍ଗୁର୍‌ ବାଡର୍‌ ଜାଗୁଆଲ୍‌କେ କଇଲା, “ଦେକା, ଏଟା ତିନ୍‌ ବରସ୍‌ ଅଇଲା ମୁଇ ଆସି ଏ ଡୁମ୍‌ରି ଗଚେ ପଲ୍‌ କଜ୍‌ଲିନି ମାତର୍‌ ମିଲାଇ ନାଇ, ଏଟା କାଟି ପାକା । ଏଟା କାଇକେ ବେକାର୍‌ ମାଟିକେ ମିସା କାରାପ୍‌ କର୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ମାତର୍‌ ଜାଗୁଆଲ୍‌ ସାଉକାର୍‌କେ କଇଲା, “ସାଉକାର୍‌ ଏଟାକେ ବର୍‌ସେକ୍‌ ମିସା ଚାଡିଦେଉଁ, ମୁଇ ଏ ବିତ୍‌ରେ ଗଚର୍‌ ଚାରିବେଡ୍‌ତି କୁନିକରି କତ୍‌ ଦେବି, ");
INSERT INTO dso_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ତାର୍‌ ପଚେ ଜଦି ପଲ୍‌ ଦାର୍‌ଲେତା ନିକ, ନଇଲେ ତାକେ କାଟି ପାକାଉଁ ।” ");
INSERT INTO dso_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ତରେକ୍‌ ଜିସୁ ବିସ୍‌ରାମ୍‌ବାରେ ଗଟେକ୍‌ ପାର୍‌ତନା ଗରେ ସିକିଆ ଦେଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ତେଇ ଗଟେକ୍‌ ମାଇଜି ରଇଲା । ତାକେ ଡୁମା ଦାରି ଅଟ୍‍ର ବରସ୍‌ ଜାକ କୁବ୍‍ଡି ଅଇରଇଲା । ସେ ବିଲ୍‌କୁଲ୍‌ ସିଦା ଅଇ ଇଣ୍ଡି ନାପାର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ଜିସୁ ତାକେ ଦେକି ଲଗେ ଡାକି କଇଲା, “ଏ ନିନି ତକେ ମୁଇ, ଏ କୁବ୍‍ଡି ରଗେଅନି ନିକ କଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ଜିସୁ ସେ ମାଇଜିର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇଲା । ସେ ମାଇଜି ସେ ଦାପ୍‌ରେସେ ସଲକ୍‌ ଅଇ ପର୍‌ମେସର୍‌କେ ମଇମା କର୍‌ବାର୍‌ ଲାଗ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ଜିସୁ ବିସ୍‌ରାମ୍‌ଦିନେ ସେ ମାଇଜିକେ ନିକ କଲାଟା ଦେକି ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରର୍‌ ମୁକିଆ ବେସି ରିସା ଅଇଗାଲାଇ । କାଇକେ ବଇଲେ ଲକ୍‌ମନ୍‌କେ ନିକ କର୍‌ବାଟା ଗଟେକ୍‌ କାମ୍‌ ବଲି ଜିଉଦି ଲକ୍‌ମନ୍‌ ବାବ୍‌ତେ ରଇଲାଇ । ସେଟାର୍‌ ପାଇ ପାର୍‌ତନା ଗରର୍‌ ମୁକିଅ କଇଲା, “ଗଟେକ୍‌ ଆଟେ କାମ୍‌ କର୍‌ବାକେ ଚଅ ଦିନ୍‌ ଆଚେ, ସେ ଦିନ୍‌ ମନ୍‌କେ ତମେ ନିକ ଅଇବାକେ ଆସା । ମାତର୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ନିକ ଅଇବାକେ କେବେ ମିସା ଆସାନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ମାତର୍‌ ଜିସୁ ତାକେ ଆରି ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ଏ କୁଟିଆଲ୍‌ମନ୍‌ ! ତମେ ତମର୍‌ ଗରୁମନ୍‌କେ ମେଲି ପାନି କୁଆଇବାକେ ନିଆସ୍‌ ନାଇ କି ? ସେଟା ମିସା ଗଟେକ୍‌ କାମ୍‌ସେ ।” ");
INSERT INTO dso_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","“ମୁଇ ତାକେ ନିକ କଲି ଆଚି । ଏ ମାଇଜି ଅବ୍‌ରାଆମର୍‌ କୁଟୁମର୍‌ ଲକ୍‌ । ସଇତାନ୍‌ ତାକେ ଅଟ୍‌ର ବରସ୍‌ ଜାକ ଦାରି ରଇଲା । ସେ ମାଇଜି ବିସ୍‌ରାମ୍‌ ବାରେ ନିକ ଅଇବାଟା ଟିକ୍‌ ନଏଁ କି ?” ");
INSERT INTO dso_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ଜିସୁ କଇଲା କାତା ସୁନି ତାର୍‌ ବିରଦି ଲକ୍‌ମନ୍‌ ଲାଜ୍‌ ଅଇଲାଇ । ମାତର୍‌ ବିନ୍‌ ଲକ୍‌ମନ୍‌ ସେ କର୍‌ବା ସବୁ କାବାଅଇଜିବା କାମ୍‌ ଦେକି ସାର୍‌ଦା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ତାର୍‌ ପଚେ ଜିସୁ କଇଲା, “ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ କେନ୍ତାଟା, ଆରି ମୁଇ କାଇଟା ସଙ୍ଗ୍‌ ସେଟା ସମାନ୍‌ କର୍‌ବି ? ");
INSERT INTO dso_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଗଟେକ୍‌ ବଡ୍‌ ବର୍‌ ଗଚର୍‌ ସାନ୍‌ଟା ମୁଞ୍ଜି ପାରା । ଗଟେକ୍‌ ଲକ୍‍ ଗଟେକ୍‌ ସାନ୍‌ଟା ମୁଞ୍ଜି ରପିଦେଲା । ସେ ମୁଞ୍ଜି ତେଇ ଗାଜା ଅଇ ବଡ୍‌ ଗଚ୍‌ପାରା ଅଇଲା ଆରି ଚଡଇମନ୍‌ ଆସି ତାର୍‌ କେନ୍ଦାଇ ଗୁଡା ବାନ୍ଦ୍‌ଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଜିସୁ ଆରି କଇଲା, “ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ କେନ୍ତିଟା ଆରି କାଇଟା ସଙ୍ଗ୍‌ ସମାନ୍‌ କରିଅଇସି ?” ");
INSERT INTO dso_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ସେଟା କମିର୍‌ ପାରା । ଜନ୍‌ଟା କି ଗଟେକ୍‌ ମାଇଜି ମାନେକ୍‌ ଗୁଣ୍ଡ୍‌ଟାନେ କଣ୍ଡେକ୍‌ କମିର୍‌ ପାକାଇ ଚକଟ୍‌ଲା ଆରି ସାରାସାରି ସେ କମିର୍‌, ଗୁଲାଇ ଗୁଣ୍ଡ୍‌ ଆମଟ୍‌ କରିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ତାର୍‌ ପଚେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଜିରୁସାଲମେ ଗାଲାବେଲେ ଗାଉଁମନ୍‌କେ ଆରି ଗଡ୍‌ମନ୍‌କେ ପର୍‌ମେସରର୍‌ ରାଇଜର୍ ବିସଇ ସିକାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ସେବେଲେ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ କ‍ଇଲା, “ଏ ମାପ୍‌ରୁ, ଉନା ଲକ୍‌ମନ୍‍ସେ ପାପେ ଅନି ରକିଆ ପାଇବାଇ କି ?” ଜିସୁ ସେମନ୍‍କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ଚିପୁଙ୍ଗି ଦୁଆର୍‌ ବାଟେ ପୁର୍‌ବାକେ ଚେସ୍‌ଟା କରା । କାଇକେ ବଇଲେ ବେସି ଲକ୍‌ମନ୍‌ ସେ ଚିପୁଙ୍ଗିବାଟ୍‌ଦେଇ ଜିବାକେ ଚେସ୍‌ଟା କର୍‌ବାଇ ମାତର୍‌ ଜାଇ ନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ମୁଇ ଗଟେକ୍‌ ଗରର୍‌ ସାଉକାର୍‌ ପାରା । ଜେଡେବଲ୍‌ ସେ ସାଉକାର୍‌ କାପାଟ୍‌ ଡାବି ଦେଇସି । ସେଡ୍‌କି ବେଲେ ତମେ ଦୁଆରେ ଟିଆ ଅଇ ରଇସା ଆରି କାପାଟ୍‌ ଡକ୍‌ ଡକ୍‌ କରି ଏ ମାପ୍‌ରୁ ଆମର୍‌ ପାଇ କାପାଟ୍‌ ଉଗାଡା ! ବଲି ଜୁଆର୍‌ ବିଆର୍‌ କର୍‌ସା । ମାତର୍‌ ସେ କାପାଟ୍‌ ନ ଉଗାଡି ସେମନ୍‌କେ କଇସି, ‘ତମେ କନ୍‌ତିଅନି ?’ ମୁଇ ତମ୍‌କେ ମୁଲ୍‌କେ ନାଜାନି । ");
INSERT INTO dso_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ମାତର୍‌ ତମେ କଇସା ‘ଏ ମାପ୍‌ରୁ ଆମେ ତମର୍‌ ସଙ୍ଗ୍‌ କାଇପିଇ ଅଇରଇଲୁ, ତୁଇ ଆମର୍‌ ଦୁଆର୍‌ ମନ୍‌କେ ସିକିଆ ଦେଇତେରଇଲୁସ୍‌ ବଲି କଇସା’ ");
INSERT INTO dso_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ଆରି ସେ ତମ୍‌କେ କଇସି, ତମେ କନ୍‌ ଜାଗାର୍‌ ଲକ୍‌ମନ୍‌ ମୁଇ ତମ୍‌କେ ମୁଲ୍‌କେ ନାଜାନି, ଏ କରାପ୍‌ କାମ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌, ‘ତମେ ସବୁ ମର୍‌ ମୁଆଟେ ଅନି ଉଟି ଜା ।’ ");
INSERT INTO dso_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ଆରି ସେ ତମ୍‌କେ ପାଟାଇଦେବା ଜାଗାଇଅନି ଅବ୍‌ରାଆମ୍ ଇସାକ୍‌, ଜାକୁବ୍‌, ଆରି ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆସି ରଇଲା ବବିସତ୍‌ ବକ୍‌ତାମନ୍‌ ରଇବାଟା ଦେକ୍‌ସା । ମାତର୍‌ ପର୍‌ମେସର୍‌ ତାର୍‌ ରାଇଜେ ତମ୍‌କେ ଜାଗା ନ ଦେଏ । ଜେଡେବଲ୍‌ ଏଟା ଅଇସି, ସେ ବେଲା ସେଟା ଦେକି, ତମେ କାଇକାଇ କାରାପ୍‌ କାମ୍‌ମନ୍‌ କରି ରଇଲାସ୍‌ ସେଟା ସବୁ ଏତାଇ କରି ମାରିଚପିଅଇ କାନ୍ଦ୍‌ସା ଆରି ଦାତ୍‌ ମୁଣ୍ଡ୍‌ କାତ୍‌ରି ଅଇସା । ");
INSERT INTO dso_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ଆରି ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌ ଏ ଦୁନିଆର୍‌ ସବୁ କନ୍ଦିବିକନ୍ଦି ଅନି ଆସି ପର୍‌ମେସରର୍‌ ରାଇଜେ କାଇବାକେ ବସ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ଆରି ଦେକା, ସାରାସାରି ରଇଲା ଲକ୍‌ ଆଗ୍‌ତୁ ଅଇବାଇ ଆରି ଆଗ୍‌ତୁ ରଇବା ଲକ୍‌ମନ୍‌ ପଚେ ଅଇଜିବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ସେଡ୍‌କିବେଲେ କେତେଟା ପାରୁସି ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି କଇଲାଇ, “ତମେ ଏ ଜାଗା ଚାଡି ଉଟି ଜା, କାଇକେ ବଇଲେ ଏରଦ୍‌ ତମ୍‌କେ ମରାଇବାକେ ମନ୍‌ କଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ଜାଇ ସେ କଲିଆପାରା ଲକ୍‌କେ କୁଆ, ଦେକ୍‌ ଆଜି ଆରି କାଲି ମୁଇ ଡୁମା ଚାଡାଇଲିନି ଆରି ନିକ କଲିନି । ଆରି ପର୍‌ଦିନ୍‌କେ ମୁଇ ମର୍‌ କାବା ଅଇଜିବା କାମ୍‌କଲିନି । ପର୍‌ମେସରର୍‌ ଜଜ୍‌ନାଇ ରଇଲା ବେଲା କେଟ୍‌ବା ଆଗ୍‌ତୁ, ମୁଇ ଏନ୍ତି କାମ୍‌ କରି ସାରାଇବି । ");
INSERT INTO dso_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","କାଇଟା ମିସା ଅ, ମୁଇ ଆଜି, କାଲିକେ ଆରି ପର୍‌ଦିନ୍‌କେ ଜାଇତେ ରଇବାର୍‌ ଆଚେ, କାଇକେ ବଇଲେ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ସବୁ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ଜିରୁସାଲାମେସେ ମରାଇଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ଜିସୁ କଇଲା, “ଏ ଜିରୁସାଲମର୍‌ ଲକ୍‌ମନ୍‌ ! ପର୍‌ମେସର୍‌ ତମର୍‌ଟାନେ ଜେତ୍‌କି ପାଟାଇରଇଲା ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ମାରି ମରାଇଲାସ୍‌ ! ଆରି ପେରିତ୍‌ମନ୍‌କେ ତର୍‌କେ ତର୍‌ ପାକ୍‌ନା ମାରି ମରାଇଲାସ୍‌ । ତେବେ ତମର୍‌ପାଇ ମର୍‌ ଲଗେ ଗଟେକ୍‌ କାତା ଆଚେ । ମାଇ କୁକୁଡା ଜେନ୍ତି ତାର୍‍ ଟିଅଁମନ୍‌କେ ଡେନା ତଲେ ରୁଣ୍ଡାଇସି, ମୁଇ ସେନ୍ତି କେତେ ତର୍‌ ତମ୍‍କେ ରକିଆ କର୍‌ବାକେ ମନ୍‌ କଲି । ମାତର୍‌ ସେନ୍ତି କର୍‌ବାକେ ତମେ ନ ଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ଦେକା, ତମର୍‌ ମନ୍ଦିର୍‌ ଚାଡିଦେଇ ଆଚତ୍‌ । ସେଟାର୍‌ ପାଇ ପର୍‌ମେସର୍‌ ଏବେ ତମ୍‌କେ ‘ପାର୍‌ତନା ଗର୍‌ ଆରି ତମର୍‌ ଗଡ୍‌ ନିଜେ ରକିଆ କରା’ ବଲି ଚାଡି ଦେଲାଆଚେ । ମୁଇ ତମ୍‌କେ କଇଲିନି, ପର୍‌ମେସର୍‌ ଜନ୍‌ ଲକ୍‌କେ ଆସିର୍‌ବାଦ୍‌ କରି ଆମର୍‌ ଲଗେ ପାଟାଇଲାଆଚେ ବଲି ମର୍‌ ବିସଇ ନେଇ, ତମେ ନ କଇବାଜାକ ମକେ ଦେକିନାପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ତରେକ୍‌ ଜିସୁ ବିସ୍‌ରାମ୍‌ବାରେ ବଜି କାଇବାକେ ଗଟେକ୍‌ ପାରୁସି ନେତାର୍‌ ଗରେ ଗାଲା । ଆରି ସେମନ୍‌ ଜିସୁକେ କାଇଆଲେ ବୁଲ୍‌ ଦାର୍‌ବାକେ ଆଁକିମରାଇ ଦେକ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ତେଇ ଜିସୁ ତାର୍‌ ମୁଆଟେ ଗଟେକ୍‌ ପୁଲାରଗ୍‌ ଅଇରଇଲା ଲକ୍‌କେ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ତାର୍‌ ପଚେ ଜିସୁ ସେ ପାରୁସି ଆରି ମସାର୍‌ ନିୟମ୍‌ ସିକାଇଦେବା ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା । “ମସାର୍‌ ନିୟମ୍‌ ଇସାବେ ବିସ୍‌ରାମ୍‌ବାରେ ଗଟେକ୍‌ ରଗ୍‌ ଅଇଲା ଲକ୍‌କେ ନିକ କର୍‌ବା ବିଦି ଆଚେ କି ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ମାତର୍‌ ସେମନ୍‌ କାଇଟାବଲି ମିସା ନ କଇ ଚୁପ୍‍ଚାପ୍‌ ଅଇ ରଇଲାଇ । ସେଟାର୍‌ ପାଇ ଜିସୁ ସେ ରଗିକେ ଚିଇଲା ଆରି ନିକ କରି ପାଟାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ତାର୍‌ ପଚେ ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ ବିସ୍‌ରାମ୍‌ବାରେ ତମର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ କାର୍‌ଆଲେ ନିଜର୍‌ ପିଲା ନଇଲେ ଗଟେକ୍‌ ଗରୁ କୁଇସାଲେ ଅଦ୍‌ରି ରଇଲେ ତାକେ ଦାପ୍‌ରେ ଜିକି ନ ଆନାସ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ଏତର୍‌ ମିସା ସେମନ୍‌ ଏ କାତାର୍‌ ଉତର୍‌ ଦେଇ ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ଆରି ତେଇ କାଇବାର୍‌ ଆସି ରଇଲା ଲକ୍‌ମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ପାଇ ମୁକିଅ ଜାଗା ବାଚି ରଇଲାଇ । ସେଟା ଜିସୁ ଦେକି କରି ସେମନ୍‌କେ ଏ ଉଦାଅରନ୍‌ ଦେଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ଜେଡେବେଲା ତମ୍‌କେ କାର୍‌ଆଲେ ବିବାଗରେ ଜିବାକେ ଡାକ୍‌ବାଇ, ସେବେଲା ମୁକିଅ ଲକ୍‌ମନ୍‌ ବସ୍‌ବା ଜାଗାଇ ଜାଇ ବସାନାଇ । କାଇକେ ବଇଲେ ସେମନ୍‌ ତମର୍‌ତେଇଅନି ବଡ୍‌ ଲକ୍‌କେ ମିସା ବିବାଟାନେ ଜିବାକେ ଡାକି ରଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","କେ ତମ୍‌କେ ଆରି ବଡ୍‌ ଲକ୍‌କେ ଡାକ୍‌ଲା ଆଚେ ସେ ଆସିକରି ତମ୍‌କେ କଇସି, ‘ଆକେ ଏ ନିକ ଜାଗା ଦେସ୍‌’ ବଲି । ତେଇ ତମେ ଉଟି ମୁକିଅ ନଇଲା ଜାଗାଇ ଜାଇ ବସ୍‌ବାର୍‌ ଆଚେ । ସେବେଲାଇ ତମ୍‌କେ ବେସି ଲାଜ୍‌ ଲାଗ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ମାତର୍‌ ଜେଡେବଲ୍‌ ତମ୍‌କେ ଡାକ୍‌ବାଇ, ସେଡ୍‌କିବେଲେ ତମେ ଜାଇ ମୁକିଅ ନଇଲା ଜାଗାଇ ବସା । ସେବେଲା ତକେ ଡାକ୍‌ଲା ଲକ୍‌ ଆସି କଇସି, ‘ଏ ମଇତର୍‌ ତୁଇ କାଇକେ ଇତି ବସିଆଚୁସ୍‌ ? ଆଉ ଏ ନିମାନ୍‌ ଜାଗାଇ ବସ୍‍’ । ସେବେଲା ତମର୍‌ ସଙ୍ଗ୍‌ ବସ୍‌ଲା ସବୁ ଲକ୍‌ମନର୍‌ ମୁଆଟେଅନି ଡାକିନେଇ ନିକ ଜାଗାଇ ବସାଇ ଦେଇସି । ଆରି ସବୁ ଲକର୍‌ ମୁଆଟେ ତମେ ସନ୍‌ମାନ୍‌ ପାଇସା । ");
INSERT INTO dso_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","କେ ନିଜ୍‌କେ ବଡ୍‌ ଲକ୍‌ ବଲି ବାବ୍‌ଲାନି ତାକେ ପର୍‌ମେସର୍‌ ସାନ୍‌ କରାଇସି । ଆରି କେ ନିଜ୍‌କେ ସାନ୍‌ ଲକ୍‌ ବଲି ବାବ୍‌ସି ତାକେ ପର୍‌ମେସର ବଡ୍‌ କରାଇସି ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ତାର୍‌ପଚେ ଜିସୁ ବଜିତେଇ ଡାକ୍‌ଲା ଲକ୍‌କେ କଇଲା, “ତୁଇ ଲକ୍‌ମନ୍‌କେ ବଜିତେଇ ଡାକ୍‌ବା ବେଲାଇ ତର୍‌ ମଇତର୍‌ମନ୍‌କେ, ବାଇମନ୍‌କେ, ନିଜର୍‌ ଲକ୍‌ମନ୍‌କେ ଆରି ସାଉକାର୍‌ ଲକ୍‌ମନ୍‌କେ ଡାକ୍‌ ନାଇ । କାଇକେବଇଲେ ସେମନ୍‌ କେଡେବଲ୍‌ ମିସା ତକେ ଡାକିକରି ତୁଇ ଦେଲାପାରା ବଜି ବାଉଡାଇ ଦେଇପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ତେବେ ତୁଇ ବଜି କଲେ ଗରିବ୍‌, କାଣା, ଚଟା ଆରି ଚେରେଙ୍ଗ୍‌ରଗି ଏନ୍ତାରି ଲକ୍‌ମନ୍‌କେ ଡାକି ଦେସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ସେନ୍ତି କଲେ ପର୍‌ମେସର୍‌ ତକେ ଆସିର୍‌ବାଦ୍‌ କର୍‌ସି । କାଇକେ ବଇଲେ ଏନ୍ତାରି ଲକ୍‌ମନ୍‌ ତୁଇ ଦେଲା ବଜି ବାଉଡାଇ ଦେଇ ନାପାରତ୍‌ । ପର୍‌ମେସର୍‌ ଦରମ୍‌ ଲକ୍‌ମନ୍‌କେ ମଲାଟାନେଅନି ଉଟାଇଲା ବେଲେ ତକେ ପୁରୁସ୍‌କାର୍‌ ମିଲ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ଜିସୁ କଇଲା ବିସଇ ସୁନିକରି ତାର୍‌ ସଙ୍ଗ୍‌ ବଜିତେଇ କାଇବାକେ ବସି ରଇଲା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ କଇଲା, “କେ କେ ପର୍‌ମେସରର୍‌ ରାଇଜେ ତାର୍‌ ସଙ୍ଗ୍‌ ବଜି କାଇବାକେ ବସ୍‌ବାଇ, ସେଟା ତାକର୍‌ ପାଇ ଗଟେକ୍‌ ବଡ୍‌ ଆସିର୍‌ବାଦ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ଜିସୁ ସେ ଲକ୍‌କେ କଇଲା, “ତରେକ୍‍ ଗଟେକ୍‌ ଲକ୍‌ ବେସି ବଡ୍‌ ବଜି କଲା ।” ସେ ବଜିତେଇ ବେସି ଗତିଆମନ୍‌କେ ଡାକି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ଆରି ରାନ୍ଦ୍‌ବାଟା ଟିକ୍‌ ଅଇଲା ପଚେ ସାଉକାର୍‌ ତାର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଡାକି କଇଲା, “ମୁଇ ବଜିର୍‌ ପାଇ ଡାକ୍‌ଲା ଲକ୍‌କେ ଜାଇ କଅ, କାଇବାଟା ଅଇଗାଲାବେ କାଇବାକେ ଆସତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ମାତର୍‌ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ରକାମ୍‌ କଇଲାଇ, “ମକେ କାମ୍‌ ଆଚେ, ନ ଆସୁ” ବଲି । ଗଟେକ୍‌ ଲକ୍‌ କଇଲା “ମୁଇ ନୁଆ ବେଡା ଗେନ୍‌ଲି ଆଚି ସେ ବେଡା ଦେକ୍‌ବାକେ ଜିବି । ଆସି ନାପାରି, ଦୟାକରି ତର୍‌ ସାଉକାର୍‌କେ ଅଲପ୍‌ କଇଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ଆରି ଗଟେକ୍‌ ଲକ୍‌ କଇଲା, “ମୁଇ ପାଁଚ୍‌ମୁଣ୍ଡ୍‌ ଗରୁ ଗେନ୍‌ଲି ଆଚି, ଗରୁମନ୍‌କେ କସିକରି ଦେକ୍‌ବାକେ ଗାଲିନି । ଆସିନାପାରି ଦୟାକରି ତର୍‌ ସାଉକାର୍‌କେ ଅଲପ୍‌ କଇଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ଆରି ଗଟେକ୍‌ ଲକ୍‌ କଇଲା, “ମୁଇ ନୁଆରେ ବିବା ଅଇଆଚି, ତେବେ ମୁଇ ଆସି ନାପାରି ।” ");
INSERT INTO dso_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ତାର୍‌ ପଚେ ସେ ଗତିଦାଙ୍ଗ୍‌ଡା ଆସି ସାଉକାର୍‌କେ ଏ ସବୁ କାତା ଜାନାଇଲା । ସେଟା ସୁନି ସାଉକାର୍‌ ବେସି ରିସାଅଇଜାଇ ତାକେ କଇଲା, “ଦାପ୍‌ରେ ଜାଇକରି ନଅରେ ଆରି ଗାଉଁ ମନ୍‌କେ ରଇଲା ଗରିବ୍‌, କାଣା, ଚଟା, ବଇରା ଆରି ଚେରେଙ୍ଗ୍‌ରଗିମନ୍‌କେ ଇତି ଡାକି ଆନ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ସେ ଗତିଦାଙ୍ଗ୍‌ଡା ଜାଇକରି ସାଉକାର୍‌ କଇଲାପାରା ଲକ୍‌ମନ୍‌କେ ଆନ୍‌ଲା । ତାର୍‌ ପଚେ ଗତିଦାଙ୍ଗ୍‌ଡା ତାର୍‌ ସାଉକାର୍‌କେ କଇଲା, “ଏ ସାଉକାର୍‌ ତୁଇ କଇଲା ଇସାବେ ମୁଇ ଡାକିଆନ୍‌ଲି । ଏଲେ ମିସା ଆରି କେତେ ଲକର୍‌ ପାଇ ଜାଗା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ଆରି ସାଉକାର୍‌ ସେ ଗତିଦାଙ୍ଗ୍‌ଡାକେ କଇଲା, “ଗଡର୍‌ ସଡକ୍‌ ପାଲି ରଇଲା ଲକ୍‌ମନ୍‌କେ ଆରି ଗାଏଁ ରଇଲା ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ଜାଇକରି ଡାକିଆନ୍‌ । ମର୍‌ ଗରେ ଲକ୍‌ ପୁରୁନ୍‌ ଅଅତ୍‌ ବଲି ମୁଇ ମନ୍‌ କଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ତାର୍‌ପଚେ ଜିସୁ କଇଲା, “ମୁଇ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ପର୍‌ତୁମ୍‌ ଡାକିରଇଲି, ସେମନ୍‌ କଣ୍ଡେକ୍‌ ମିସା ଚାକି ନାପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ତରେକ୍‌ ବେସି ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଜାଇତେ ରଇଲାଇ । ଆରି ସେ ପଚ୍‌ବାଟେ ବୁଲିକରି ସେମନ୍‌କେ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ଜେ ମର୍‌ ଲଗେ ଆସିକରି ନିଜର୍‌ ବାବା, ମାଆ, ମାଇଜି ପିଲା, ବାଇ ବଇନି ଆରି ନିଜ୍‌କେ ମର୍‌ତେଇଅନି ଅଦିକ୍‌ ଆଲାଦ୍‌ କର୍‌ସି, ସେ ମର୍‌ ସିସ୍‌ ଅଇନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଗଟେକ୍‌ ଲକ୍‌ ମର୍‌ ପଚେ ପଚେ ଇଣ୍ଡ୍‌ବାର୍‌ଆଲେ, ତାକେ ଦିଆଅଇଲା କୁରୁସ୍‌ ବଇକରି ନ ଇଣ୍ଡେ ବଇଲେ, ସେ କେବେ ମର୍‌ ସିସ୍‌ ଅଇନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ତମେ ଜଦି ଗଟେକ୍‌ ବଡ୍‌ ଗର୍‌ ବାନ୍ଦ୍‌ବାକେ ମନ୍‌ କଲାସ୍‌ନି ବଇଲେ, ବାନ୍ଦ୍‌ବା ଆଗ୍‌ତୁ କେତେକ୍‌ କର୍‌ଚ ଅଇସି ସେଟା ବସି କରି ଇସାବ୍‌ କର୍‍ସା । ଆରି ସେ ଗରର୍‌ ସବୁ କାମ୍‌ କରିସାରାଇବାକେ ତମର୍‌ ଲଗେ ସେତ୍‌କି ଡାବୁ ଆଚେକି ନାଇ ବଲି ଇସାବ୍‌ କରିଦେକ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ତମେ ଜଦି ଇସାବ୍‌ କରି ନ ଦେକ୍‌ଲେ ଗର୍‌ କାମ୍‌ ଆରାମ୍‌ କରି ସାରାଇ ନାପାରାସ୍‌ । ସେ କାମ୍‌ କରି ନ ସାରାଇଲେ ତମ୍‌କେ ଦେକ୍‌ବା ଲକ୍‌ମନ୍‌ ଆଁସିକରି ଲାଜ୍‌କରି ଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ସେମନ୍‌ କଇବାଇ, ଏ ଲକ୍‌ ବଡ୍‌ଟା ଗର୍‌ ବାନ୍ଦ୍‌ବାର୍‌ ଆରାମ୍‌ କଲା, ମାତର୍‌ ସାରାଇବାର୍‌ ନାପାର୍‌ଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ଆରି ଜିସୁ କଇଲା, “ଗଟେକ୍‌ ରାଜା ଦସ୍‌ଅଜାର୍‌ ସନିଅ ଦାରି, କଡେଅଜାର୍‌ ସନିଅ ରଇଲା ରାଜାସଙ୍ଗ୍‌ ଜୁଇଦ୍‌ କର୍‌ବାର୍‌ ଆଇଲେ, ପର୍‌ତୁମ୍‌ ତାର୍‌ ସନିଅମନ୍‌ ସଙ୍ଗ୍‌ ବସିକରି ତାର୍‌ ଦସ୍‌ଅଜାର ସନିଅମନ୍‌ ସଙ୍ଗ୍‌ ଜୁଇଦ୍‌ କଲେ ଜିତି ଅଇସି କି ନାଇ ବଲି ଜଜ୍‌ନା ନ କରେକି ? ");
INSERT INTO dso_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଜଦି ସେ ରାଜା ଜିତି ନଏଁ ବଲି ବାବ୍‌ଲେ ସେମନ୍‌ ଦୁରିକେ ରଇଲା ବେଲେସେ, ଏ ରାଜା ତାର୍‌ କେତେଟା ଲକ୍‌କେ ପାଟାଇ କରି, ଜୁଇଦ୍‌ ନ କରି ସାନ୍ତିର୍‍ ରାଜିନାମା କର୍‌ବାକେ କଇସି । ");
INSERT INTO dso_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ତମେମିସା ସେନ୍ତାରିସେ ମର୍‌ ସିସ୍‌ ଅଇବାକେ ମନ୍‍ କଲେ ତମର୍‌ତେଇ ରଇଲା ସବୁଟା ଚାଡିଦେବାକେ ମନ୍‌ କର୍‌ବାର୍‌ ଆଚେ । ନଇଲେ ତମେ ମର୍‌ ସିସ୍‌ ଅଇ ନାପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ନୁନ୍‌ ଗଟେକ୍‌ ବଡିଆ ଦିନ୍‌ସୁ । ନୁନ୍‌ ଜଦି ନୁନ୍‌ ପାରା କରିଆ ନ ଅଇଲେ ସେଟା ଆରିତରେକ୍‌ କେନ୍ତି ନୁନ୍‌ପାରା କରିଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ସେଟା ମାଟି କି କତ୍‌ କର୍‌ବାକେ ମିସା କାମେ ନ ଆସେ । ସେଟା ପିଙ୍ଗି ଦେବାର୍‌ସେ ଅଇସି । ଜାକେ ସୁନ୍‌ଲାପାରା କାନ୍‌ ଆଚେ ସେ ସୁନ ।” ");
INSERT INTO dso_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ଦିନେକ୍‌ ଜିସୁ କଇବା କାତା ସୁନ୍‌ବାକେ ସିସ୍‌ତୁ ମାଙ୍ଗ୍‌ବା ଲକ୍‌ମନ୍‌ ଆରି ଏନ୍ତି ବେସି ପାପିଲକ୍‌ମନ୍‌ ତାର୍‌ ଲଗେ ଆଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ତେଇ ପାରୁସି ଲକ୍‌ମନ୍‌ ଆରି ନିୟମ୍‌ ସିକାଇ ଦେବା ଲକ୍‌ମନ୍‌, ଏଟା ଦେକି ତାର୍‌ ବିରଦେ ଏନ୍ତି କଇବାର୍‌ ବସ୍‌ଲାଇ । “ଏ ଲକ୍‌କେ ଦେକା, ସେ ପାପି ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ମଇତର୍‌ ପାରା ଅଇ ତାକର୍‌ ସଙ୍ଗ୍‌ ମିସ୍‌ତେ କାଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ସେଟାର୍‌ ପାଇ ଜିସୁ ସେମନ୍‌କେ ଏ ଉଦାଅରନ୍‌ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ଜଦି ତମର୍‌ ବିତ୍‌ରେ ଗଟେକ୍‌ ଲକର୍‌ ସଏଟା ମେଣ୍ଡା ରଇସି ଆରି ସେ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଆଜିଜାଇସି ବଇଲେ ତମେ କାଇଟା କର୍‌ସା ? ସେ ନବେ ନଅଟା ମେଣ୍ଡାମନ୍‌କେ ଚାରତ୍‌ବଲି ଚାଡିଦେଇ, ଆଜିଗାଲା ଗଟେକ୍‌ ମେଣ୍ଡା ମିଲ୍‌ବାଜାକ ନ କଜାସ୍‌ କି ? ");
INSERT INTO dso_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ଆରି ଜେଡେବଲ୍‌ ସେ ମେଣ୍ଡା ମିଲାଇସି, ବେସି ସାର୍‌ଦା ଅଇ ମେଣ୍ଡାକେ କନ୍ଦେ ବଇକରି ଗରେ ଦାରିଆଇସା । ");
INSERT INTO dso_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ତମେ ଗରେ କେଟ୍‌ଲା ପଚେ, ତମର୍‌ ମଇତର୍‌ମନ୍‌କେ ଆରି ଗର୍‌ ଲଗର୍‌ ଲକ୍‌କେ ଡାକିକରି ‘ମର ସଙ୍ଗ୍‌ ସାର୍‌ଦା କରା, କାଇକେବଇଲେ ମର୍‌ ଆଜିଗାଲା ମେଣ୍ଡା ମିଲ୍‌ଲା’ ବଲି କଇସା । ");
INSERT INTO dso_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ସେନ୍ତାରି ମୁଇ ତମ୍‌କେ କଇଲିନି, ‘ଆମେ ପାପି ଲକ୍‌ମନ୍‌ ନଉଁ’ ବଲି ବାବ୍‌ତେରଇବା ନବେ ନଅଟା ଦରମ୍‌ ଲକ୍‌ମନ୍‌ ରଇଲେମିସା ଗଟେକ୍‌ ପାପି ଲକ୍‌ ନିଜେ ‘ମୁଇ ଗଟେକ୍‌ ପାପି’ ବଲି ଏତାଇସି । ପଚେ ମନ୍‌ବାଦ୍‌ଲାଇ କରି ପର୍‌ମେସରର୍‌ ଲଗେ ଆଇସି । ସେ ନବେ ନଅଟା ଦରମ୍‌ ଲକ୍‌ମନର୍‌ତେଇ ଅନି ଏ ଗଟେକ୍‌ ଲକର୍‌ ପାଇ ସର୍‌ଗେ ଅଦିକ୍‌ ସାର୍‌ଦା କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ଏ କାତା ସୁନାଇ ଦେବାକେ ଜିସୁ ଆରି ଗଟେକ୍‌ କାତାନି ସେମନ୍‌କେ କଇଲା, “ଜଦି ଗଟେକ୍‌ ମାଇଜିର୍‌ ଦସ୍‌ଟା ରୁପାଟାଙ୍ଗା ରଇଲା । ତେଇଅନି ଗଟେକ୍‌ ଅଦ୍‌ଲି ଆଜିଗାଲେ ସେ କାଇଟା କର୍‌ସି ? ସେ ବତି ଲାଗାଇ ଗୁଲାଇ ଗର୍‌ ସେଟା ନ ମିଲ୍‌ବାଜାକ ବାଡାନ୍‌ ଚୁଡାନ୍‌ କରି କଜ୍‍ସି । ");
INSERT INTO dso_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ଆରି ସେଟା ମିଲ୍‌ଲା ଦାପ୍‌ରେ ତାର୍‌ ମଇତର୍‌ମନ୍‌କେ ଆରି ଗର୍‌ ଲଗେ ରଇଲା ଲକ୍‌ମନ୍‌କେ କଇସି ‘ତମେ ମର୍‌ସଙ୍ଗ୍‌ ସାର୍‌ଦା କରା, କାଇକେ ବଇଲେ ଆଜିଗାଲା ରୁପାଅଦ୍‌ଲି ଡାବୁ ମକେ ମିଲ୍‌ଲା ଆଚେ’ । ");
INSERT INTO dso_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ମୁଇ ତମ୍‌କେ କଇଲିନି, ସେନ୍ତିସେ ଗଟେକ୍‌ ପାପି ଲକ୍‌ ମାପ୍‌ରୁର୍‌ତେଇ ମନ୍‌ବାଦ୍‌ଲାଇସି ବଇଲେ, ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ମନ୍‌ ବେସି ସାର୍‌ଦା କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଏ କାତା ବୁଜାଇ ଦେବାକେ ଜିସୁ ସେମନ୍‌କେ ଆରି ଗଟେକ୍‌ କାତାନି କଇଲା । ଗଟେକ୍‌ ଲକ୍‌କେ ଦୁଇଟା ପିଲାମନ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ଦିନେକ୍‌ ସାନ୍‌ ପଅ ତାର୍‌ ବାବାକେ କଇଲା, “ଏ ବାବା ତର୍‌ ଦନ୍‌ ମର୍‌ବାଗେ ଜେତ୍‌କି ଅଇସି, ସେଟା ଏବେ ମକେ ଦେଇପାକା ।” ସେଟାର୍‌ ପାଇ ତାର୍‌ ବାବା ତାର୍‌ ଦନ୍‌ ଦୁଇବାଗ୍‌ କରି ତାର୍‌ ପିଲାମନ୍‌କେ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ଅଲପ୍‌ ଦିନ୍‌ ଗାଲା ପଚେ ସାନ୍‌ ପିଲା ତାର୍‌ ବାଗର୍‌ ସବୁ ଦନ୍‌ ବିକିଦେଇ ମିଲ୍‌ଲା ଡାବୁ ଟୁଲିଆଇ ଗଟେକ୍‌ ଦୁର୍‌ ଦେସେ ଉଟିଗାଲା । ଆରି ତାର୍‌ ସବୁ ଡାବୁ ନିଜେ ମନ୍‌କଲା ଇସାବେ କର୍‌ଚ କଲା । ");
INSERT INTO dso_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ତାର୍‌ଲଗେ ରଇଲା ସବୁ ଡାବୁ ସାରାଇଦେଲା । ପଚେ ସେ ଦେସର୍‌ ଗୁଲାଇ ବାଟେ ମର୍‌ଡି ଅଇଲା । ଆରି କାଇଟା ମିସା ଗେନି କାଇବାକେ ତାର୍‌ଲଗେ ଡାବୁ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ତେବେ ସେ ଗଡେ ଗଟେକ୍‌ ଲକର୍‌ ଗରେ କୁଲି ମିଲ୍‌ସି କାଇକି ବଲି କାମ୍‌ କଜ୍‌ବାର୍‌ ଗାଲା । ସେ ଲକ୍‌ ତାକେ ଗୁସ୍‌ରି ଚାରାଇବା କାମ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ଆରି ତାକେ ବେସି ବୁକ୍‌ ଲାଗ୍‌ତେ ରଇଲା । ତାକେ ଗୁସ୍‌ରିମନର୍‌ କାଦି କାଇବାକେ ମନ୍‌ଲାଗ୍‌ଲା ମାତର୍‌ ସେ କାଦି ମିସା ଦେଅତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ସେବେଲେ ତାକେ ଚେତ୍‌ନା ଆଇଲାଜେ ସେ ମନେ ମନେ ଏନ୍ତି ବାବ୍‌ଲା । ମର୍‌ ବାବାର୍‌ ଗରେତା କାମ୍‌ କର୍‌ବା ଗତିଦାଙ୍ଗ୍‌ଡାମନର୍‌ କେତେ କାଦି ଉବ୍‌ରି ଗାଲାନି । ମାତର୍‌ ମୁଇ ଇତି ବୁକେ ମରିଜିବିବେ । ");
INSERT INTO dso_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ସେଟାର୍‌ପାଇ ମୁଇ ଏ ଜାଗା ଚାଡିକରି ମର୍‌ ବାବାର୍‌ ଲଗେ ବାଉଡି ଜିବି । ଆରି ତାକେ କଇବି, “ଏ ବାବା ମୁଇ ପର୍‌ମେସର୍‌ ଆରି ତର୍‌ ବିରଦେ ପାପ୍‌ କରିଆଚି । ");
INSERT INTO dso_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ମୁଇ ଆରି ତର୍‌ ପିଲା ଅଇବାର୍‌ ଅଦିକାର୍‌ ନାଇ ଆରି ତର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାମନର୍‌ ବିତ୍‌ରେ ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ଅଇ ରଇବି” ବଲି କଇବି । ");
INSERT INTO dso_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ଆରି ସେ ଜାଗା ଚାଡି ବାବାର୍‌ ଲଗେ ଜିବାକେ ବାରଇଲା । ମାତର୍‌ ସେ ପିଲା ଦୁରିକେ ରଇଲାବେଲେ ବାବା ତାକେ ଦେକ୍‌ଲା । ତାକେ ଦେକି ବେସି କଲିକରମ୍‌ ଅଇ, ତାର୍‌ ଲଗେ ପାଲାଇ ଆସି ପାଟାଲିକରି ଚୁମ୍‍ଲା । ");
INSERT INTO dso_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ସେ ପିଲା ତାର୍‌ ବାବାକେ କଇଲା, “ଏ ବାବା ମୁଇ ପର୍‌ମେସରର୍‌ ବିରଦେ ଆରି ତର୍‌ ବିରଦେ ପାପ୍‌ କଲିଆଚି ସେଟାର୍‌ପାଇ ତର୍‌ ପିଲା ଅଇବାର୍‌ ମର୍‌ ଅଦିକାର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ମାତର୍‌ ତାର୍‌ ବାବା ନିଜର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ କଇଲା, “ତମେ ବେଗି ଜାଇକରି ସବୁର୍‌ଟାନେଅନି ନିମାନ୍‌ ଚକାପଚିଆ ତାକେ ପିନ୍ଦାଇଦିଆସ୍‌ । ଆରି ତାର୍‌ ଆଙ୍ଗ୍‍ଟି ମୁନ୍ଦି ପିନ୍ଦାଆ । ତାର୍‌ ଗଡେ ପାଣ୍ଡଇ ପିନ୍ଦାଇଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ଆରି ତାର୍‍ ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ କଇଲା, “ଆମର୍‌ତେଇ ରଇଲା ସବୁର୍‌ଟାନେଅନି ଗଟେକ୍‌ ଗାଗଡ୍‌ ର‍ଇବା ପସୁ ଆନି ମାରା, ଆରି ଆମେ ସାର୍‌ଦା ଅଇକରି ବଜି କରୁ । ");
INSERT INTO dso_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","କାଇକେ ବଇଲେ ମର୍‌ ପିଲା ମରିଜାଇରଇଲା, ଆରି ଏବେ ଜିବନ୍‌ ଅଇଲା ଆଚେ । ସେ ଆଜିଜାଇ ରଇଲା ଏବେ ମିଲ୍‌ଲା ଆଚେ ।” ସେଟାର୍‌ପାଇ ସେମନ୍‌ ବଜି କର୍‌ବାର୍‌ ବସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ସେ ବେଲା ତାର୍‌ ବଡ୍‌ ପଅ ତାସ୍‌ପଦାଇ ରଇଲା । ସେ ବାଉଡି କରି ଗର୍‌ ଲଗେ ଆଇବା ବେଲାଇ ବାଜାବାଇଦ୍‌ କରି ନାଟ୍‍ଗିତ୍‌ କର୍‌ବାଟା ସୁନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ସେ ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଡାକିକରି ପାଚାର୍‌ଲା, “ଇତି କାଇଟା ଅଇଲାନି ?” ");
INSERT INTO dso_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ଗତିଦାଙ୍ଗ୍‌ଡା ତାକେ କଇଲା, “ତର୍‌ ବାଇ ଗରେ ବାଉଡି ଆଇଲା ଆଚେ । ଆରି ତର୍‌ ବାବା, ତର୍‌ ବାଇ ଜର୍‌ଦୁକା ନ ଅଇ ଜିବନ୍‌ଅଇ ଆଇଲାକେ ଗଟେକ୍‌ ଗାଗଡ୍‌ ପସୁକେ ମାର୍‌ଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ଏ କାତା ସୁନି ବଡ୍‌ ପଅ ବେସି ରିସା ଅଇଗାଲା । ସେ ଗର୍‌ ବିତ୍‌ରେ ପୁରେ ମିସା ନାଇ । ମାତର୍‌ ତାର୍‌ ବାବା ବଡ୍‌ ପଅର୍‌ ଲଗେ ଜାଇ ଗରେ ଜିବାକେ ବୁଜାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ମାତର୍‌ ବଡ୍‌ ପଅ ତାର୍‌ ବାବାକେ କଇଲା, “ଦେକ୍‌, ମୁଇ ଏତେକ୍‌ ବରସ୍‌ ଜାକ ଗଟେକ୍‍ ଗତିଦାଙ୍ଗ୍‌ଡା ପାରା ତର୍‌ ସେବା କଲିନି ଆରି ତର୍‌ କାତା ମାନି କରି ରଇଲି । ତୁଇ ମକେ କାଇଟା ଦେଇଆଚୁସ୍‌ ? ମର୍‌ ମଇତର୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ବଜି କରା ବଲି ଗଟେକ୍‌ ସାନ୍‌ଟା ପସୁ ମିସା ଦେଉସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ମାତର୍‌ ତର୍‌ ଏ ସାନ୍‌ ପଅ ସବୁ ଦନ୍‌ ଦାରିଜାଇ ବେସିଆମନ୍‌କେ ଦେଇ ସାରାଇଦେଲା ଆରି ସେ ଗରେ ବାଉଡି ଆଇଲାକେ ତୁଇ ତାର୍‌ ପାଇ ଗଟେକ୍‌ ଗାଗଡ୍‌ଟା ପସୁକେ ମାର୍‌ଲୁସ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ସେବେଲେ ତାର୍‌ ବାବା ବଡ୍‌ ପଅକେ କଇଲା, “ଏ ନୁନା ତୁଇତା ସବୁ ବେଲା ମର୍‌ ସଙ୍ଗ୍‌ ରଇଲୁସ୍‌ନି ଆରି ମର୍‌ ଜେତ୍‌କି ଦନ୍‌ ଆଚେ ସେଟା ସବୁ ତର୍‌ଟାସେ । ");
INSERT INTO dso_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ମାତର୍‌ ତର୍‌ ବାଇ ମରିଜାଇରଇଲା । ଏବେ ସେ ଜିବନ୍‌ ଅଇଆଚେ ସେ ଆଜିଜାଇରଇଲା ମାତର୍‌ ଏବେ ମିଲ୍‌ଲା ଆଚେ । ସେଟାର୍‌ପାଇ ଆମେ ସାର୍‌ଦା କର୍‌ବାର୍‌ ରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ଗଟେକ୍‌ କାତାନି ବୁଜାଇ କଇଲା । “ଗଟେକ୍‌ ସାଉକାର୍‌ ଲକ୍‌ ରଇଲା । ତାର୍‌ ଦନ୍‌ ଇସାବ୍‌କିତାବ୍‌ କର୍‌ବାକେ ଗଟେକ୍‌ ମୁକିଅ ଗତିଦାଙ୍ଗ୍‌ଡା ରଇଲା । ଆରି ସେ ସବୁ ଦନ୍‌ ଏନେତେନେ କରିଦେଲାନି ବଲି ଗଟେକ୍‌ ଲକର୍‌ତେଇ ଅନି ସାଉକାର୍‌ ସୁନ୍‍ଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ସେଟାର୍‌ ପାଇ ସାଉକାର୍‌ ମୁକିଅ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଡାକି କଇଲା, “ତୁଇ ଟିକ୍‌ ସଙ୍ଗ୍‍ ଇସାବ୍‍ପତର୍‌ କରୁସ୍‌ ନାଇ ବଲି ମୁଇ ବେସି କାତା ସୁନ୍‌ଲିନି । ମର୍‌ ସବୁ ଡାବୁର୍‌ ଇସାବ୍‌ ମକେ ଦେ । କାଇକେ ବଇଲେ ତୁଇ ଆରି ମର ମୁକିଅ ଗତିଦାଙ୍ଗ୍‌ଡାର୍‌ କାମେ ନ ରଉସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ସେବେଲା ସେ ମୁକିଅ ଗତିଦାଙ୍ଗ୍‌ଡା ମନେ ମନେ ଏତାଇଲା । ଏବେ ମୁଇ କାଇଟା କର୍‌ବି ? ମର୍‌ ସାଉକାର୍‌ କାମେ ଅନି ବାର୍‌କରିଦେବି ବଲି କଇଲା ଆଚେ । ମାଟି ମାର୍‌ବାକେ ମକେ ବପୁ ନାଇ ଆରି ବିକ୍‌ ମାଗ୍‌ବି ବଇଲେ ମିସା ଲାଜ୍‌ ଲାଗ୍‌ଲାନି । ");
INSERT INTO dso_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ମୁଇ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ବଲି ଜାନି ଆଚି । ମକେ ଏ କାମେଅନି ବାର୍‌ କରିଦେଲା ପଚେ କାଇଟା କଲେ ଲକ୍‌ମନର୍‌ ଗରେ ମକେ ଡାକି ନିକକରି ଦେକ୍‌ବାଇ ବଲି ବାବ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ତେବେ ସେ ମୁକିଅ ଗତିଦାଙ୍ଗ୍‌ଡା ତାର୍‌ ସାଉକାର୍‌ତେଇଅନି ଉଦାର୍‌ ନେଲା ସବୁ ଲକ୍‌କେ ଡାକ୍‌ଲା । ପର୍‌ତୁମ୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ଡାକି ପାଚାର୍‌ଲା, “ତୁଇ ମର୍‌ ସାଉକାର୍‌କେ କେତେକ୍‌ ଦେବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ସେ ଲକ୍‌ ତାକେ “ସଏ ଡାବା ଚିକନ୍‌ ।” ବଲି କଇଲା । ମୁକିଅ ଗତିଦାଙ୍ଗ୍‌ଡା ତାକେ କଇଲା, “ତମେ ଉଦାର୍‌ ନେଲା ପତିଲଗେ ଉନା କରି ପଚାସ୍‌ ଡାବା ବଲି ଲେକିଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ତାର୍‌ ପଚେ ସେ ଆରି ଗଟେକ୍‌ ଲକ୍‌କେ ପାଚାର୍‌ଲା, “ତମେ କେତେକ୍‌ ଦେବାର୍‌ ଆଚେ ?” ଉଦାର୍‌ ନେଲା ଲକ୍‌ କଇଲା, “ଅଜାର୍‌ ବାସ୍‌ତା ଦାନ୍‌ ।” ମୁକିଅ ଗତିଦାଙ୍ଗ୍‌ଡା ତାକେ କଇଲା “ତୁଇ ଉଦାର୍‌ ନେଲା ପତିତେଇ ଉନାକରି ଆଟ୍‌ ସଅ ବାସ୍‌ତା ବଲି ଲେକିଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ଏଟାର୍ ପାଇ ସେ ମିଚୁଆ ମୁକିଅ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ତାର୍‌ ସାଉକାର୍‌ କଇଲା, “ତୁଇ ବେସି ଚାଲାକି ଅଇକରି ଏନ୍ତି କାମ୍‌ କରିଆଚୁସ୍‌ । କାଇକେ ବଇଲେ ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ନିଜର୍‌ କାମ୍‌ କର୍‌ବାକେ ପର୍‌ମେସରର୍‌ ଲକ୍‌ମନର୍‌ ଟାନେଅନି ଅଦିକ୍‌ ଚାଲାକି ।” ");
INSERT INTO dso_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ଆରି ଜିସୁ କଇଲା, “ସେଟାର୍‌ ପାଇ ମୁଇ ତମ୍‌କେ କଇଲିନି, ଲକ୍‌ମନ୍‌କେ ଏ ଦୁନିଆର୍‌ ଦନ୍‌ ଦେଇ କରି ନିଜର୍‌ ନିଜର୍‌ ପାଇ ମଇତର୍‌ କରା । ସେନ୍ତାରି କଲେ ଜେଡେବଲ୍‌ ତମର୍‌ ଦୁନିଆର୍‌ ଦନ୍‌ ସାରିଜାଇସି, ପର୍‌ମେସର୍‌ ତମ୍‌କେ କାଲ୍‌କାଲ୍‌ ଜୁଗ୍‌ଜୁଗ୍‌ ରଇବା ଗରେ ଡାକି ନେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","କେ ସାନ୍‌ ବିସଇ ସତ୍‌ସଙ୍ଗ୍‌ କର୍‌ସି, ସେ ବଡ୍‌ ବିସଇ ସତ୍‌ସଙ୍ଗ୍‌ କର୍‌ସି । ସେନ୍ତାର୍‌ସେ କେ ସାନ୍‌ ବିସଇ ନେଇକରି ସତ୍‌ କାମ୍‌ ନ କରେ ସେ ବଡ୍‌ ବିସଇତେଇ ମିସା ସତ୍‌ କାମ୍‌ ନ କରେ । ");
INSERT INTO dso_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ପର୍‌ମେସର୍‌ ତମ୍‌କେ ଏ ଦୁନିଆଇ ଦେଲା ଡାବୁ ଆରି ଦନର୍‌ ବିସଇ ସତ‍ଇସେ ନ କରାସ୍‌ ବଇଲେ ସରଗର୍‌ ଦନ୍‌ ତମ୍‌କେ ମିଲ୍‌ବାକେ ନ ଦେଏ । ");
INSERT INTO dso_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ତମେ ବିନ୍‌ ଲକ୍‌ମନର୍‌ ଦନ୍‌ ସତ୍‌ବାବେ ନ ସଙ୍ଗଇଲେ ନିଜର୍‌ ଦନ୍‌ କେ ତମ୍‌କେ ଦେଇସି ? ");
INSERT INTO dso_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ଦୁଇଟା ସାଉକାରର୍‌ ଦାଇତ୍‌ ସମାନ୍‌ ବାବେ କରିନାପାରେ । କାଇକେବଇଲେ ସେ ଗଟେକ୍‌ ସାଉକାର୍‌କେ ଆଲାଦ୍‌ କର୍‌ସି ଆରି ଗଟେକ୍‌ ସାଉକାର୍‌କେ ଗିନ୍‌ କର୍‌ସି । ଗଟେକ୍‌ ସାଉକାର୍‌କେ ନାମ୍‌ସି ଆରି ଗଟେକ୍‌କେ ନ ନାମେ । ସେନ୍ତାର୍‌ସେ ଗଟେକ୍‌ ଲକ୍‌ ଏକାତରେକ୍‌ ଏ ଦୁନିଆର୍‌ ଦନ୍‌ ଆରି ପର୍‌ମେସର୍‌କେ ସମାନ୍‌ବାବେ ସେବା କରିନାପାରେ ।” ");
INSERT INTO dso_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ପାରୁସି ଦଲର୍‌ ଲକ୍‌ମନ୍‌ ଏ ସବୁ କାତା ସୁନି ଜିସୁକେ ଟାପ୍‌ରା କଲାଇ, କାଇକେ ବଇଲେ ଡାବୁ ଆକା ସେମନର୍‌ ଜିବର୍‌ ଦନ୍‌ ବଲି ବାବ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ଲକର୍‌ ମୁଆଟେ ନିକ ବଲି ଦେକାଇ ଅଇଲାସ୍‌ନି । ମାତର୍‌ ତମର୍‌ ମନ୍‌ବିତ୍‌ରେ କାଇଟା ଆଚେ ସେଟା ପର୍‌ମେସର୍‌ ଜାନିଆଚେ । ଜନ୍‌ ଦିନ୍‍ସୁ ଲକ୍‌ମନ୍‌ ବେସି ମୁଲିଅ ବଲି ବାବ୍‌ଲାଇନି ସେଟା ପର୍‌ମେସର୍‌ ଦେକ୍‌ବା ଇସାବେ ବେସି ଗିନର୍‌ ବିସଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ଆସି ନିକ କାତା କଇବାଟା ଆରାମ୍‌ କର୍‌ବା ଜାକ, ମସାର୍‌ ନିୟମ୍‌ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ କାତା ତମ୍‌କେ କାଡାଇ ନେଇତେ ରଇଲା । ଜଅନ୍‌ ଆଇଲା ପଚେ, ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ସୁବ୍‌ କବର୍‌ ଜାନାଇଲାଇନି । ଆରି ନିଜର୍‌ ବପୁସଙ୍ଗ୍‌ ପର୍‌ମେସରର୍‌ ରାଇଜେ ଜିବାକେ ବେସି ଲକ୍‌ମନ୍‌ ଚେସ୍‌ଟା କଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ସରଗ୍‌ ଆରି ଦୁନିଆ ନସିଗାଲେ ମିସା ନିୟମେ ଲେକା ଅଇରଇଲାଟା ଗଟେକ୍‌ ମିସା ଅଇକର୍‌ ନ ନସେ ।” ");
INSERT INTO dso_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“କେମିସା ନିଜର୍‌ ମାଇଜିକେ ଚାଡି ବିନ୍‌ଟା ଆନ୍‌ଲେ, ସେ ଦାଙ୍ଗ୍‌ଡିସଙ୍ଗ୍‌ ବେସିଆ କାମ୍‌ କଲା ଲକ୍‌ ଅଇଜାଇସି । ଆରି କେ, ସେ ଚାଡ୍‌ଲା ଦାଙ୍ଗ୍‌ଡିକେ ବିବା ଅଇସି ବଇଲେ ସେ ମିସା ଦାଙ୍ଗ୍‌ଡିସଙ୍ଗ୍‌ ବେସିଆ କାମ୍‌ କଲା ଆଚେ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ଜିସୁ ସେମନ୍‌କେ ଗଟେକ୍‌ କାତାନି ବୁଜାଇକରି କଇଲା, “ଗଟେକ୍‌ ସାଉକାର୍‌ ଲକ୍‌ ରଇଲା । ସେ ଲଚେକ୍‌ ମଲ୍‌ ଦେଇ ଗେନ୍‌ଲା ନିକ ନିକ ଚକା ପଚିଆ ପିନ୍ଦ୍‌ତେ ରଇଲା । ସେ ସବୁଦିନ୍‌ ବଜି କରି ନିଜେ ସାର୍‌ଦା ଅଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ତେଇ ଲାଜାର୍‌ ନାଉଁର୍‌ ଅର୍‌କିତ୍‌ ଲକ୍‌ ଗଟେକ୍‌ ରଇଲା । ତାର୍‌ ଗୁଲାଇ ଗାଗଡ୍‌ ଗାଉ ଅଇରଇଲା । ତାକେ ଆନିକରି ସାଉକାରର୍‌ କାପାଟ୍‌ ଲଗେ ଡୁଲାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ତେଇ ରଇ, ସେ ସାଉକାରର୍‌ ତାଲିଅନି ଅଦର୍‌ଲା ସକ୍‌ଡି ବାତ୍‌ସିତା ବେଟି କାଇବାକେ ମନ୍‍ କର୍‌ତେ ରଇଲା । କୁକୁର୍‌ମନ୍‌ ତାର୍‌ ଗାଗ୍‌ଡର୍‌ ଗାଉ ଚାଟ୍‌ତେ ରଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","କେତେ ଦିନ୍‌ ଗାଲାପଚେ ସେ ଅର୍‌କିତ୍‌ ଲକ୍‌ ମରିଗାଲା । ଆରି ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ମନ୍‌ ଆସି ତାକେ ସରଗ୍‌ପୁରର୍‌ ବଜିତେଇ ଅବ୍‌ରାଆମର୍‌ ଲଗେ ବସ୍‌ବାକେ ଦାରି ଗାଲାଇ । ଆରି କେତେ ଦିନ୍‌ ଗାଲାପଚେ ସେ ସାଉକାର୍‌ ମିସା ମରିଗାଲା । ତାକେ ନେଇ ତପିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ଆରି ସେ ନରକ୍‌ କୁଣ୍ଡେ ଗାଲା । ତେଇ ସେ ବେସି କସ୍‌ଟ ପାଇବାବେଲା ଉପ୍‌ରେ ସରଗ୍‌ପୁରେ ଦେକ୍‌ଲେ ଲାଜାର୍‌ ଅବ୍‌ରାଆମର୍‌ ଲଗେ ବସି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ସେ ଆଉଲି ଅଇ କଇଲା, “ଏ ବାବା ଅବ୍‌ରାଆମ୍‍, ମକେ ଦୟା କର୍‌ । ଲାଜାର୍‌କେ ମର ଲଗେ ପାଟାଇଦେସ୍‌ । ସେ ଆସିକରି ନିଜର୍‌ ଆଙ୍ଗ୍‍ଟି ସଙ୍ଗ୍‌ ପାନି ଦେଇ, ମର୍‌ ଜିବ୍‌ କାକର୍‌ କର । କାଇକେ ବଇଲେ ମୁଇ ଏ ନରକ୍‌ପୁରର୍‌ ଜଇଲଗେ ବେସି କସ୍‌ଟ ପାଇଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ମାତର୍‌ ଅବ୍‌ରାଆମ୍ କଇଲା, “ବାବୁରେ, ତୁଇ ଜିବନ୍‌ ରଇଲାବେଲାର୍‌ କାତା ମନେ ଏତାଇ ଦେକ୍‌ । ତର୍‌ ଜିବ୍‌ନେ ସବୁ ନିମାନ୍‌ ବିସଇ ପାଇରଇଲୁସ୍‌ । ଆରି ଲାଜାର୍‌ ସବୁ କାରାପ୍‌ ବିସଇ ପାଇଲା । ମାତର୍‌ ସେ ଏବେ ଏ ଜାଗାଇ ସାର୍‌ଦାଅଇ ଆଚେ । ଆରି ତୁଇ ବେସି କସ୍‌ଟ ପାଇଲୁସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ଆରି ଗଟେକ୍‌ ବିସଇ ଅଇଲାନି, ତର୍‌ ଆମର୍‌ ମଜାଇ ଗଟେକ୍‌ ବଡେଟା ପାଗଡ୍‌ ଆଚେ । ଇତିର୍‌ ଲକ୍‌ ସିତି ଜାଇ ନଏଁ ଆରି ସିତିର୍‌ ଲକ୍‌ ଇତି ଆସି ନଏଁ ” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ସେ ବେଲା ସେ ସାଉକାର୍‌ କଇଲା, “ଏ ବାବା ଏନ୍ତି ବଇଲେ ମୁଇ ତକେ ବାବୁଜିଆ କଲିନି ଲାଜାର୍‌କେ ଦୟାକରି ମର୍‌ ବାବାର୍‌ ଗରେ ପାଟାଇଦେସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","କାଇକେ ବଇଲେ ତେଇ ମର୍‌ ପାଁଚ୍‌ଟା ବାଇମନ୍‌ ଆଚତ୍‌ । ଲାଜାର୍‌ ଜାଇ ସେମନ୍‌କେ ଜାଗ୍‌ରତ୍‌ କରାଅ । ସେମନ୍‌ ସେ କାତା ସୁନି ପାପେଅନି ମନ୍‌ ବାଦ୍‌ଲାଅତ୍‌ । ସେମନ୍‌ ମଲେ ମୁଇ ଏବେ ବେସି କସ୍‌ଟ ପାଇବା ଏ ଜାଗାଇ ନ ଆସତ୍‌” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ମାତର୍‌ ଅବ୍‌ରାଆମ୍ ତାକେ କଇଲା, “ସେମନ୍‌ ଜାଗ୍‌ରତ୍‌ ଅଇ ରଇବାକେ ମସାର୍‌ ନିୟମ୍‌ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ କଇଲା କାତା ସବୁ ତାକର୍‌ ଲଗେ ଆଚେ । ସେଟା ସେମନ୍‌ ପଡିକରି ସିକତ୍‌ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ଆରି ସେ ସାଉକାର୍‌ ଅବ୍‌ରାଆମ୍‍କେ କଇଲା, “ସେତ୍‌କି ନଏଁ ବାବା, ମଲାଟାନେଅନି ଉଟିକରି ଗଟେକ୍‌ ଲକ୍‌ ଜାଇ କଇଲେ ସେମନ୍‌ ବିସ୍‌ବାସ୍‌ କରି ପାପେଅନି ମନ୍‌ ବାଉଡାଇବାଇ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ଅବ୍‌ରାମ୍‌ ତାକେ କଇଲା, “ତର୍‌ ବାଇମନ୍‌ ମସାର୍‌ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ କାତା ନ ସୁନତ୍‌ ବଇଲେ ମଲାଟାନେଅନି ଉଟିକରି ଗଟେକ୍‌ ଲକ୍‌ ଜାଇ କଇଲେ ମିସା ସେମନ୍‌ ନ ମାନତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଦିନେକ୍‌ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଏ ଦୁନିଆଇ ସବୁ ବେଲା ଲକ୍‌ମନ୍‌କେ ପାପ୍‌ କରାଇବାକେ କାଇଆଲେ ପରିକା ଆଇସି । ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ ଏନ୍ତି ବିନ୍‌ ଲକ୍‌କେ ପାପ୍‌ କରାଇସି, ସେମନ୍‌କେ କେତେକ୍‌ କସ୍‌ଟର୍‌ ଦସା ଅଇସି । କାଇକେବଇଲେ ପର୍‌ମେସର୍‌ ସେମନ୍‌କେ ବେସି ବଡ୍‌ ଡଣ୍ଡ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ସେନ୍ତାରି ଲକ୍‌, ଦରମ୍‌ ଲକ୍‌ମନ୍‌କେ ପାପ୍‌କରାଇବା ବାଦୁଲେ ଗାଲାଇ ଗଟେକ୍‌ ବଡ୍‌ଟା ଜତା ପାକ୍‌ନା ବାନ୍ଦିକରି ଡେଙ୍ଗ୍‌ ପାନିତେଇ ପିଙ୍ଗି ଦେବାପାରା ଡଣ୍ଡ୍‌ ତାର୍‌ପାଇ ନିକ ଅଇତା । ");
INSERT INTO dso_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ତେବର୍‌ପାଇ ତମର୍‌ ଚଲାଚଲ୍‌ତିତେଇ ବେସି ଜାଗ୍‌ରତ୍‌ଅଇ ରୁଆ । ଜଦି ତମର୍‌ ବାଇ କି ବଇନି ପାପ୍‌ କଲେ, ସେଟା ନିକ କାମ୍‌ ନଏଁ ବଲି ଟିକ୍‌ କରା । ଆରି ସେ କରିରଇବା ବୁଲ୍‌ ଏତାଇ କରି ମନ୍‌ ବାଦ୍‌ଲାଇସି ବଇଲେ, ତାକେ କେମା ଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ଜଦି ସେ ଗଟେକ୍‌ ଦିନେ ସାତ୍‌ପାଲି ଜାକ ତମର୍‌ ବିରଦେ ପାପ୍‌ କରି, ପଚେ ନିଜର୍‌ ବୁଲ୍‌ କଲାଟା ଏତାଇ ମନ୍‌ ବାଦ୍‌ଲାଇକରି ତମର୍‌ ତେଇ ଆସି ଜେତେପାଲି କେମା ମାଗ୍‌ଲେ, ସେତ୍‌କିପାଲି ତାକେ କେମା ଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ଆରି ପେରିତ୍‌ମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ଆମର୍‌ ବିସ୍‌ବାସ୍‌ ଅଦିକ୍‌ କରିଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଗଟେକ୍‌ ସର୍‌ସୁ ମୁଞ୍ଜି ପାରା ତମର୍‌ ବିସ୍‌ବାସ୍‌ ରଇସି ବଇଲେ ତମେ ବଡ୍‌ ଗଚ୍‌କେ ଜିକିଅଇ ସମ୍‌ଦୁରେ ଜାଇ ରପିଅ ବଲି କଇଲେ ସେ ଗଚ୍‌ ତମର୍‌ କାତା ମାନ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ଜଦି ତୁଇ ଗଟେକ୍‌ ସାଉକାର୍‌ ଅଇରଇସୁ ବଇଲେ ତର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା କସ୍‌ବାଟାନେଅନି ନଇଲେ ଗରୁଚାରାଇବାଟାନେଅନି ଆସି ତାର୍‌ ନିଜର୍‌ କାମ୍‌ ନ ସାରାଇବା ଆଗ୍‌ତୁ ତୁଇ ତାକେ ‘କାଇବାକେ ବସ୍‌ବେ’, ବଲି କଇସୁ କି ? ନାଇ, ସେନ୍ତି ନ କଉସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ମାତର୍‌ ସେ ନିଜର୍‌ କାଦି କାଇବା ଆଗ୍‌ତୁ ତର୍‌ପାଇ ରାନ୍ଦି ନ ଦେବା ଜାକ, ତୁଇ ତାକେ କାଇବାକେ ନ ଦେଉସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ଆରି ତୁଇ ସେ ଗତିଦାଙ୍ଗ୍‌ଡାକେ ‘ସବୁ କାମ୍‌ କରି ସାରାଇଲୁସ୍‌ !’ ବଲି ଦନିଅବାଦ୍‌ ଦେଇସୁ କି ? ନାଇ ନ ଦେଉସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ସେନ୍ତାରି ତମ୍‌କେ କଇରଇଲା ସବୁ ବିସଇ କରିସାରାଇଲା ପଚେ ତମେ କଇବାର୍‌ ଆଚେ । ଆମେ ଅବ୍‌କା ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌, ଆମର୍‌ ଜେତ୍‌କି କର୍‌ବାର୍‌ ରଇଲା, ସେତ୍‌କିସେ ଆମେ କରିଆଚୁ।” ");
INSERT INTO dso_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଜିରୁସାଲମେ ଜିବା ବେଲେ ସେ ଗାଲିଲି ଆରି ସମିରଣ ଜିଲାର୍‌ ମଜାଇ କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ଆରି ସେ ଗାଉଁ ବିତ୍‌ରେ ପୁର୍‌ବା ବେଲେ ବଡ୍‌ରଗ୍‌ ଅଇରଇଲା ଦସ୍‌ଟା ଲକ୍‌ମନ୍‌ ତାକେ ଦୁରିକେଅନି ଦେକ୍‌ଲାଇ । ସେମନର୍‌ ନିୟମେ ବଡ୍‌ରଗ୍‌ ରଇଲା ଲକ୍‌ମନ୍‌, ବିନ୍‌ ଲକ୍‌ମନର୍‌ ଲଗେ ଆସି ନାପାରତ୍‌ । ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ଜିସୁର୍‌ ଲଗେ ନ ଆସି ଦୁରିକେ ରଇକରି, ");
INSERT INTO dso_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ବେସି ଆଉଲିଅଇ କଇଲାଇ, “ଜିସୁ ! ଏ ଗୁରୁ ! ଆମ୍‌କେ ଦୟାକରା ।” ");
INSERT INTO dso_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ଜିସୁ ସେମନ୍‌କେ ଦେକି କରି କଇଲା, “ତମେ ଜାଇକରି ପର୍‌ମେସରର୍‌ ପୁଜାରିମନ୍‌କେ ତମର୍‌ ଗାଗଡ୍‌ ଦେକାଆ । ତମେ ନିମାନ୍‌ ଅଇଲାସ୍‌ କି ନାଇ ବଲି ସେମନ୍‌ ଦେକତ୍‌ ।” ପଚେ ସେ ଦସ୍‌ ଲକ୍‌ ପର୍‌ମେସରର୍‌ ପୁଜାରିମନର୍‌ ଲଗେ ଜିବା ବେଲେ, ବାଟେ ନିମାନ୍‌ ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ଏଦେ ଦେକା ! ସେମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ନିଜର୍‌ ଗାଗଡ୍‌ ନିମାନ୍‌ ଅଇଲାଟା ଦେକି, ଜିସୁର୍‌ ଲଗେ ବାଉଡି ଆଇଲା । ଆରି ସେ ବେସି ଆଉଲି ଅଇ ପର୍‌ମେସରର୍‌ ଡାକ୍‌ପୁଟା କଲା । ");
INSERT INTO dso_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ସେ ପାଲାଇ ଆସି ଜିସୁର୍‌ ପାଦେ ଅଦର୍‌ଲା “ତମେ ମକେ ନିମାନ୍‌ କରିଆଚାସ୍‌” ବଲି ଦନିଅବାଦ୍‌ କଲା । ସେ ଜିଉଦି ଲକ୍‌ ନଏଁ । ସେ ସମିରଣିୟ ବଲି ଗଟେକ୍‌ ଜାଗାର୍‌ ଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ଜିସୁ ତାକେ କଇଲା, “ମୁଇତା ଦସ୍‌ଲକ୍‌କେ ନିମାନ୍‌ କରି ରଇଲି । ତକେ ଗଟେକ୍‌ ଲକ୍‌କେ ଚାଡି ଆରି ନଅ ଲକ୍‌ କେନେ ଗାଲାଇ ? ");
INSERT INTO dso_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ନିମାନ୍‌ ଅଇଲା ପଚେ ବାଉଡି ଆସି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ କର୍‌ବାକେ ଏ ଗଟେକ୍‌ ସମିରଣିୟ ଲକ୍‌ସେ ରଇଲା କି ?” ");
INSERT INTO dso_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ତାର୍‌ ପଚେ ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ଏବେ ଉଟ୍‌ ଆରି ଜାଆ, କାଇକେ ବଇଲେ ମୁଇ ତକେ ନିମାନ୍‌ କରିପାର୍‌ବି ବଲି ବିସ୍‌ବାସ୍‌ କରିରଇଲୁସ୍‍ ।” ");
INSERT INTO dso_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","କେତେଟା ପାରୁସି ଲକ୍‌ମନ୍‌ ଜିସୁକେ “କେବେଅନି ପର୍‌ମେସର୍‌ ଲକ୍‌ମନ୍‌କେ ସାସନ୍‌ କର୍‌ସି ?” ବଲି ପାଚାର୍‌ଲାଇ । ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ପର୍‌ମେସର୍‌ କେନ୍ତି ସାସନ୍‌ କର୍‌ସି, ସେ ରାଇଜ୍‌ ତମର ଆଁକିତେଇ ନ ଡିସେ । ");
INSERT INTO dso_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ଆରି ପର୍‌ମେସର୍‌ ଇତି ସାସନ୍‌ କଲାନି ନଇଲେ ସିତି ସାସନ୍‌ କଲାନି ବଲି କଇବାର୍‌ ନାପାରାସ୍‌ । କାଇକେ ବଇଲେ, ଲକ୍‌ମନର୍‌ ମନ୍‌ ବିତ୍‌ରେ ପର୍‌ମେସର୍‌ ସାସନ୍‌ କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ପଚେ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, ଏନ୍ତି ବେଲା ଆଇସି ତମେ ପର୍‌ମେସର୍‌ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମର୍‌ସଙ୍ଗ୍‌ ଗଟେକ୍‌ ଦିନ୍‌ ରଇବାକେ ବେସି ମନ୍‌ କର୍‌ସା । ମାତର୍‌ ସେବେଲା ମକେ ଦେକି ନାପାରାସ୍‌ ");
INSERT INTO dso_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ଲକ୍‌ମନ୍‌ ତମ୍‌କେ କଇବାଇ, ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ଇତି ଆଚେ ସିତି ଆଚେ ବଲି । ତମେ ସେଟା ଦେକ୍‌ବାକେ ନ ଜାଆ । ତମେ କନ୍ତି ଆଚାସ୍‌ ତେଇସେ ରୁଆ । ");
INSERT INTO dso_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","କାଇକେବଇଲେ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ, ବାଉଡ୍‌ବାଟା ତମେ ଦେକ୍‌ସା । ସେଟା କେନ୍ତାର୍‌ ବଇଲେ, ଆକାସେ ଜେନ୍ତି ଗଟେକ୍‌ ବାଟେଅନି ଆରି ଗଟେକ୍‌ ବାଟେ ବିଜ୍‌ଲି ମାରିକରି ଗୁଲାଇ ଆକାସ୍‌ ଉଜଲ୍‌ ଅଇସି, ସେନ୍ତାରିସେ ସବୁ ଲକ୍‌ମନ୍‌ ଦେକିଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ମାତର୍‌ ସେଟା ଅଇବା ଆଗ୍‌ତୁ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ବେସି ଦୁକ୍‌ କସ୍‌ଟ ପାଇବାର୍‌ ଆଚେ । ଆରି ମର୍‌ ସବୁ କାମ୍‌ ଦେକ୍‌ଲା ଲକ୍‌ମନ୍‌ ମକେ ନ ନାମତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ନଅ ରଇଲା ବେଲା ଲକ୍‌ମନ୍‌ ଜେନ୍ତାରି ରଇଲାଇ ସେନ୍ତାରିସେ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ବାଉଡି ଆଇବାବେଲେ ଲକ୍‌ମନ୍‌ ରଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ସେବେଲାଇ ନଅ ବଡେଟା ପାନିଜାଜେ ପୁର୍‌ବା ଦିନ୍‌ ଜାକ ଲକ୍‌ମନ୍‌ ଅବ୍‌କାସେ ରଇଲାଇ । ସେମନ୍‌ ବଜି କର୍‌ବାର୍‌, ଦାଙ୍ଗ୍‌ଡି ଆନ୍‌ବାର୍‌, ଆରି ଦାଙ୍ଗ୍‌ଡି ଦେବାର୍‌ କର୍‌ତେ ରଇଲାଇ । ପଚେ ବେସି ପାନିଅଇ ସବୁ ଡାବିଅଇଲା । ନଅ ଆରି ତାର୍‌ କୁଟୁମର୍‌ ଲକ୍‌କେ ଚାଡି ସବୁ ଲକ୍‌କେ ପାନି ବୁଡାଇ ପାକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଲତ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକର୍‌ ବେଲେ ମିସା ସେନ୍ତାର୍‌ ପାରା ଅଇରଇଲା । ଲକ୍‌ମନ୍‌ ସବୁ ଦିନର୍‌ ପାରାସେ କାଆ ପିଇ, ବିକାବିକ୍‌ରି, ଗଚ୍‌ରପା ଆରି ଗର୍‌ବାନ୍ଦାତେଇ ଲାଗିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ମାତର୍‌ ଲତ୍‌ ସଦମ୍‌ ନାଉଁର୍‌ ଗଡେଅନି ବାରଇକରି ଜିବା ଦିନେ ସେ ବାଦ୍‌ଲେଅନି ଜଇ ଆରି ଗନ୍ଦ୍‌ଗୁଲା ଆସି ଲତ୍‌ ଆରି ତାର୍‌ କୁଟୁମର୍‌ ଲକ୍‌କେ ଚାଡି ସେ ଗଡର୍‌ ସବୁ ଲକ୍‌କେ ମରାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ବାଉଡି ଆଇବା ଦିନେ ମିସା ସେନ୍ତାରିସେ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ସେ ଦିନେ ନିଜର୍‌ ଗର୍‌ ଉପ୍‌ରେ ରଇଲେ ତୁଇ ଉତ୍‌ରି ତର୍‌ ଦିନ୍‌ସୁ ଆନ୍‌ବାକେ ଗର୍‌ ବିତ୍‌ରେ ନ ଜାଆ । ସେନ୍ତାରି ତାସ୍‌ ପଦାଇ ରଇଲେ, ଦିନ୍‌ସୁ ବେଟି ନେବାକେ ଗରେ ନ ଆଉ । ");
INSERT INTO dso_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲତର୍‌ ମାଇଜିକେ କାଇଟା ଅଇରଇଲା ସେଟା ଏତାଇ ଦେକା । ତାର୍‌ ଦନ୍‌ ସଁପତି କେନ୍ତାର୍‌ ଅଇଲା ବଲି ପାସ୍‌ଲି ଦେକ୍‌ଲାଜେ ସେ ନୁନ୍‌ କୁମ୍‌ ପାସ୍‌ଲି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","କେ କେ ଏ ଦୁନିଆଇ ଜିଇବା ଜିବନ୍‌ ମନ୍‍ କଲେ ତାକେ ନ ସାର୍‌ବା ଜିବନ୍‌ ନ ମିଲେ । ଆରି କେ କେ ଏ ଦୁନିଆଇ ଜିଇବା ଜିବନ୍‌ ଆରାଇସି, ତାକେ ନ ସାର୍‌ବା ଜିବନ୍‌ ମିଲ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ମୁଇ ବାଉଡି ଆଇବା ସେ ରାତି, ତମେ ଦୁଇ ଲକ୍‌ ଗଟେକ୍‌ ବାକ୍‌ରାଇ ସଇରଇସା । ଗଟେକ୍‌ ଲକ୍‌କେ ଡାକି ନେବି, ଆରି ଗଟେକ୍‌ ଲକ୍‌କେ ଚାଡି ଦେବି । ");
INSERT INTO dso_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ଦୁଇଟା ମାଇଜିମନ୍‌ ଗର୍‌ତେ ରଇବାଇ, ତେଇଅନି ଗଟେକ୍‌ ମାଇଜିକେ ନେବି ଆରି ଗଟେକ୍‌କେ ଚାଡି ଦେବି । ");
INSERT INTO dso_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ଦୁଇ ଲକ୍‌ ପଦାଇ ରଇବାଇ, ଗଟେକ୍‌ ଲକ୍‌କେ ନେବି, ଆରି ଗଟେକ୍‌ ଲକ୍‌କେ ଚାଡିଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ତାର୍‌ପଚେ ସିସ୍‌ମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏ ମାପ୍‌ରୁ ଏଟା କନ୍ତି ଗଟ୍‌ସି ?” ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଜନ୍ତି ମଡା ରଇସି, ତେଇ ମଡ୍‌କାଉ ଗିଦ୍‌ମନ୍‌ ରୁଣ୍ଡିରଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ଜିସୁ ଦିନେକ୍‌ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ପର୍‌ମେସର୍‌କେ ମାଙ୍ଗ୍‌ବାବେଲେ ନ ତାକି ପାର୍‌ତନା କରିକରି ରଇବାକେ, ଗଟେକ୍‌ କାତାନି ବୁଜାଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ଗଟେକ୍‌ ଗଡେ ଗଟେକ୍‌ ବିଚାର୍‌ କାରିଆ ଲକ୍‌ ରଇଲା । ସେ ପର୍‌ମେସର୍‌କେ ନ ଡର୍‌ତେ ରଇଲା, କି ଲକ୍‌ମନ୍‌କେ ନ ନାମ୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ସେ ଗଡେ ଗଟେକ୍‌ ରାଣ୍ଡି ମାଇଜି ମିସା ରଇଲା । ସେ ସବୁ ବେଲେ ବିଚାର୍‌ କାରିଆର୍‌ ଲଗେ ଜାଇ ଏନ୍ତି କଇତେ ରଇଲା, ଗଟେକ୍‌ ଲକ୍‌ ମର୍‌ ବିରଦି ଅଇଲା ଆଚେ । ଏ ବିସଇନେଇକରି ତମେ ମର୍‌ ବିରଦିକେ ବିଚାର କରା । ଜେନ୍ତିକି, ସେ ମକେ ନିଆଇ ଇସାବେ ଚଲାଚଲ୍‌ତି କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ଏନ୍ତି ବେସି ଦିନ୍‌ ସେ ବିଚାର୍‌କାରିଆ ନିଆଇ କର୍‌ବାକେ ମନ୍‌ ନ କଲେ ମିସା, ସେ ଦିନ୍‌କେ ଆସି ବେମ୍‍ଜା କର୍‌ତେରଇଲା । ମାତର୍‌ ସେ ବିଚାର୍‌କାରିଆ ଲକ୍‌ ମନେ ମନେ ବାବ୍‌ଲା, “ମୁଇ ପର୍‌ମେସର୍‌କେ ଡରି ନାଇକି ଲକ୍‌ମନ୍‌କେ ନାମି ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ମାତର୍‌ ଏ ରାଣ୍ଡିମାଇଜି ସବୁ ବେଲା ଆସି ବେମ୍‍ଜା କଲାନି । ସେଟାର୍‌ପାଇ ତାକେ ନିଆଇ ମିଲ୍‌ଲା ପାରା ବିଚାର୍‌ କର୍‌ବି । କାଇକେ ବଇଲେ ଏନ୍ତି ବିଚାର୍‌ ନ କଲେ ସେ ସବୁଦିନ୍‌ ଆସି ମକେ ବେମ୍‍ଜା କର୍‌ତେ ରଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ତେଇ ମାପ୍‌ରୁ କଇଲା, “ଏ ଅନିଆଇ ବିଚାର୍‌କାରିଆ କାଇଟା କର୍‌ବାକେ ବାଚ୍‌ଲା, ସେଟା ତମେ ସିକା । ");
INSERT INTO dso_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ସେନ୍ତି ଲାଚୁଆଁ ବିଚାର୍‌କାରିଆ ସେ ରାଣ୍ଡିମାଇଜିର୍‌ ବିଚାର୍‌ କଲା । ସେନ୍ତାର୍‍ ଆଲେ, ତାର୍‌ତେଇଅନି କେତେ ନିମାନ୍‌ ଇସାବେ ପର୍‌ମେସର୍‌ ସେ ବାଚ୍‌ଲା ଲକ୍‌ମନର୍‌ ଦିନ୍‌ରାତିର୍‌ ପାର୍‌ତନା ସୁନି ନିମାନ୍‌ ନିଆଇ ବିଚାର୍‌ କର୍‍ସି । ସେମନ୍‌କେ ସାଇଜ କର୍‌ବାକେ ସେ ଅଲ୍‌ସମ୍‌ ନ କରେ । ");
INSERT INTO dso_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ମୁଇ ତମ୍‌କେ କଇଲିନି, ସେ ଦାପ୍‌ରେସେ ତାର୍‌ ଲକ୍‌ମନର୍‌ପାଇ ନିମାନ୍‌ ନିଆଇବିଚାର୍‌ କର୍‌ସି । ମାତର୍‌ ପର୍‌ମେସର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ଆରିତରେକ୍‌ ଆଇବାବେଲେ ଏ ଦୁନିଆଇ, ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ଦେକ୍‌ବି କି ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ତେଇ ରଇଲା କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ନିଜ୍‌କେ ମୁଇ ନିକ ଆଚି ବଲି ବାବିଅଇ ବିନ୍‌ଲକ୍‌କେ ଗିନ୍‌ କର୍‌ତେ ରଇଲାଇ । ସେନ୍ତି ଲକ୍‌ମନର୍‌ ବିସଇ ବୁଜାଇବାକେ ଜିସୁ ସେମନ୍‌କେ ଏ କାତାନି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ଦିନେକ୍‌ ଦୁଇଲକ୍‌ ପାର୍‌ତନା କର୍‌ବାକେ ଗଟେକ୍‌ ମନ୍ଦିରେ ଗାଲାଇ । ଗଟେକ୍‌ ଲକ୍‌ ପାରୁସି ଦଲର୍‌ ଲକ୍‌ ଆରି ଗଟେକ୍‌ ସିସ୍‌ତୁମାଙ୍ଗୁ । ");
INSERT INTO dso_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ପାରୁସି ଲକ୍‌ ନିଜେ ଅଲପ୍‌ ଦୁରିକେ ଟିଆଅଇ ଏନ୍ତି ପାର୍‌ତନା କର୍‌ବାର୍‌ ବସ୍‌ଲା, “ଏ ପର୍‌ମେସର୍‌ ମୁଇ ତମ୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲିନି । ମୁଇ ବିନ୍‌ଲକର୍‌ପାରା ଲବ୍‌ରା ନାଇ କି ମିଚ୍‌ମାୟା ନାଇ କି ବେସିଆ କାମ୍‌ କରି ନାଇ । ଆରି ତକେ ଜୁଆର୍‌ କଲିନି ମୁଇ ଏ ସିସ୍‌ତୁମାଙ୍ଗୁ ପାରା ନଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ଆରି ସେ କଇଲା, “ମୁଇ ଜିଉଦିମନର୍‌ ନିୟମ୍‌ ଇସାବେ ଆଟ୍‌କେ ଦୁଇ ଦିନ୍‌ ଉପାସ୍‌ ରଇ ପାର୍‌ତନା କଲିନି । କାମାଇଲାଟାନର୍‌ ଦସ୍‌ବାଗର ବାଗେକ୍‌ ତମ୍‌କେ ଦେଲିନି ।” ବଲି ପାର୍‌ତନା କଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ମାତର୍‌ ସେ ସିସ୍‌ତୁମାଙ୍ଗୁ ଦୁରିକେ ଟିଆଅଇ ପାର୍‌ତନା କର୍‌ବା ବେଲେ ସରଗ୍‌ବାଟେ ଦେକ୍‌ବାକେ ମିସା ମନ୍‌ ନକରି ନିଜର୍‌ ବୁକେ ମାରିଅଇ ଏନ୍ତି ପାର୍‌ତନା କଲା । “ଏ ପର୍‌ମେସର୍‌ ମୁଇ ଗଟେକ୍‌ ପାପି ଲକ୍‌ ମକେ ଦୟା କରା !” ");
INSERT INTO dso_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ସେ ଦୁଇଲକ୍‌ ପାର୍‌ତନା ସାରାଇ ବାଅଡ୍‌ଲାକେ, ସିସ୍‌ତୁମାଙ୍ଗୁସେ ପର୍‌ମେସର୍‌ ଦେକ୍‌ବା ଇସାବେ ଦରମ୍‌ ରଇଲା । ପାରୁସି ନାଇ । ଜେ ବଡ୍‌ପନ୍‌ ଦେକାଇ ଅଇସି ଆରି ବଡ୍‌ ବଲି ବାବ୍‌ସି, ତାକେ ପର୍‌ମେସର୍‌ ସାନ୍‌ ଲକ୍‌ କର୍‌ସି । ମାତର୍‌ ଜେ ନିଜ୍‌କେ ସାନ୍‌ ଲକ୍‌ପାରା ବାବ୍‌ସି ତାକେ ପର୍‌ମେସର୍‌ ବଡ୍‌ ଲକ୍‌ କର୍‌ସି, ଏ କାତା ଏତାଇ ରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଆରି ଗଟେକ୍‌ ଦିନେ ଲକ୍‌ମନ୍‌ ତାକର୍‌ ସାନ୍‍ସାନ୍‌ ପିଲାମନ୍‌କେ “ଜିସୁ ଚି କରି ଆସିର୍‌ବାଦ୍‌ କର ।” ବଲି ଆନ୍‌ତେ ରଇଲାଇ । ସିସ୍‌ମନ୍‌ ସେଟା ଦେକି ଲକ୍‌ମନ୍‌କେ ଲାଗ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ମାତର୍‌ ଜିସୁ ପିଲାମନ୍‌କେ ଲଗେ ଡାକି, ସିସ୍‌ମନ୍‌କେ କଇଲା, “ପିଲାମନ୍‌କେ ମର୍‌ ଲଗେ ଆନ୍‌ବାକେ ମନାକରା ନାଇ । କାଇକେ ବଇଲେ ସରଗ୍‌ ରାଇଜ୍‌ ଏନ୍ତି ସାନ୍‌ ସାନ୍‌ ପିଲାମନର୍‌ ପାରା ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ପାଇସେ । ");
INSERT INTO dso_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ଏତାଇ ରୁଆ ! ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି । କେ ମିସା ଏ ସାନ୍‌ଲକ୍‌ ବିସ୍‌ବାସ୍‌ କଲାପାରା ମକେ ବିସ୍‌ବାସ୍‌ ନ କଲେ, ସେ ପର୍‌ମେସରର୍‌ ରାଇଜେ ଜାଇ ନାପାରେ ।” ");
INSERT INTO dso_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ଦିନେକ୍‌ ଗଟେକ୍‌ ଜିଉଦି ନେତା ଜିସୁକେ ପାଚାର୍‌ଲା, “ଏ ନିମାନ୍‌ ଗୁରୁ ! ନ ସାର୍‌ବା ଜିବନ୍‌ ମିଲାଇବାକେ ମୁଇ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ଜିସୁ ତାକେ କଇଲା, ମକେ କାଇକେ ନିମାନ୍‌ ବଲି କଇଲୁସ୍‌ନି ? କାଇକେ ବଇଲେ ପର୍‌ମେସର୍‌ ଗଟେକ୍‌ ଲକ୍‌ସେ ନିମାନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି “ବେସିଆ କାମ୍‌ କରା ନାଇ, କାକେ ମରାଆ ନାଇ, ବିନ୍‌ ଲକର୍‌ ଦିନ୍‌ସୁ ଚରାଆ ନାଇ, ମିଚ୍‌ ସାକି କୁଆ ନାଇ, ଆରି ତମର ମାଆବାବାର୍‌ କାତା ମାନା । ପର୍‌ମେସର୍‌ ମସାକେ ଏନ୍ତି ନିୟମ୍‌ ଦେଲାଆଚେ ଜାନି ଆଚୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ସେ ଲକ୍‌ ଜିସୁକେ କଇଲା, “ଏ ସବୁ ନିୟମ୍‌ ତା ମୁଇ ପିଲାବେଲେ ଅନି ମାନ୍‌ଲିନି । ମୁଇ ଆରି କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଜିସୁ ଏଟା ସୁନି ତାକେ କଇଲା, ତର୍‌ଟାନେ ଆରି ଗଟେକ୍‌ ବିସଇ ଉନା ଆଚେ । ତର୍‌ ସବୁ ଦନ୍‌ ସଁପତି ବିକି ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ବାଟାକରିଦେସ୍‌ । ଏନ୍ତି କଲେ ତକେ ସର୍‌ଗେ ଦନ୍‌ ରଇସି । ଏଟା ସବୁ କଲା ପଚେ ତୁଇ ମର୍‌ ସଙ୍ଗ୍‌ ଆଉ । ");
INSERT INTO dso_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ମାତର୍‌ ସେ ଲକ୍‌ ଏ କାତା ସୁନି ମନ୍‌ ଦୁକ୍‌ ଅଇ ଉଟିଗାଲା । କାଇକେ ବଇଲେ ସେ ବେସି ସାଉକାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ସେ ଲକ୍‌ ମନ୍‌ଦୁକ୍‌ ଅଇଲାଟା ଦେକି ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ସାଉକାର୍‌ ଲକ୍‌ମନ୍‌ ସରଗ୍‌ ରାଇଜେ ଜିବାଟା କେଡେ କସ୍‌ଟର୍‌ ବିସଇ ! ");
INSERT INTO dso_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ସେ ଲକ୍‌ମନ୍‌ ସରଗ୍‌ ରାଇଜେ ଜିବାଟାନେଅନି ଗଟେକ୍‌ ବଡ୍‌ ଜଁତ୍‌ ସୁଜିକାଣାବାଟେ ଚିଙ୍ଗ୍‌ଲି ଜିବାକେ ସଅଜ୍‌ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଏକାତା ସୁନ୍‌ତେ ରଇଲା ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ଏନ୍ତି ବଇଲେ କେ ତେବେ ଉଦାର୍‌ ପାଇସି ?” ");
INSERT INTO dso_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ଜିସୁ କଇଲା, “ପର୍‌ମେସରର୍‌ ଟାନେ ନାପାର୍‌ଲା ବିସଇ କାଇଟା ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ପିତର୍‌ ଜିସୁକେ କଇଲା, “ଦେକା ଆମର୍‌ ଗରର୍‌ ସବୁ ଚାଡିକରି ତମର୍‌ ସଙ୍ଗ୍‍ ଆଇଲୁଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଉଁ ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି । ଜନ୍‌ ଲକ୍‌ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ପାଇ ନିଜର୍‌ ଗର୍‌ଦୁଆର୍‌, ମାଇଜିପିଲା, ବାଇବଇନି, ମାଆବାବା ଆରି ପିଲାଟକିକେ ଚାଡି ଆଚେ ବଇଲେ, ");
INSERT INTO dso_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ତାକେ ଏ ଦୁନିଆର୍‌ ଜିବନେ, ସେ ଜେତ୍‍କି ଚାଡି ରଇଲା ତାର୍‍ ତେଇ ଅନି ଅଦିକ୍‌ ମିଲ୍‌ସି । ଆରି ପଚେ ତାକେ ନ ସାର୍‌ବା ଜିବନ୍‌ ମିଲ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ତାର୍‌ ପଚେ ଜିସୁ ତାର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ବିନେ ଡାକିନେଇ କଇଲା, “ସୁନା ! ଆମେ ଜିରୁସାଲମେ ଗାଲୁନି, ଜନ୍‌ବେଲା ଆମେ କେଟ୍‌ବୁ ସେବେଲା ପର୍‌ମେସର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା, ମର୍‌ ବିସଇ ନେଇ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ଲେକି ରଇଲା ସବୁ ବିସଇ ପୁରାପୁରୁନ୍‌ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ସେଟା କାଇଟା ବଇଲେ, ଜିରୁସାଲମେ ମକେ ରମିୟ ଲକ୍‌ମନ୍‌କେ ସର୍‌ପିଦେବାଇ ଆରି ସେମନ୍‌ ମକେ କିଜାଇବାଇ ଆରି ଲାଜ୍‌ କରାଇ, ମର୍‌ ଉପ୍‌ରେ ତୁକ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ତାର୍‌ପଚେ କର୍‌ଡା ସଙ୍ଗ୍‌ ମାର୍‍ବାଇ, ପଚେ ମକେ ମରାଇବାଇ । ମାତର୍‌ ତିନ୍‌ଦିନ୍‌ ପଚେ ମୁଇ ଆରି ତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ମାତର୍‌ ସିସ୍‌ମନ୍‌ ଏ ସବୁ କାତା ଅଲପ୍‌ ମିସା ବୁଜିନାପାର୍‌ଲାଇ, ସେ ବିସଇ ସେମନର୍‌ଟାନେଅନି ଲୁଚିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଜିସୁ ଜିରିଅ ଗଡେ କେଟାକେଟି ଅଇଲାବେଲେ ଗଟେକ୍‌ କାଣା ବାଟ୍‍ପାଲି ବସି ବିକ୍‌ ମାଙ୍ଗ୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଜିବା ଲକର୍‌ କାତା ସୁନି, “ଏଟା କାଇଟା ଅଇଲାନି ?” ବଲି ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ସେ ଲକ୍‌ମନ୍‌ କାଣାକେ କଇଲାଇ, “ନାଜରିତ୍‌ ଗାଉଁର୍‌ ଜିସୁ ଏ ବାଟେ ଗାଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ତେଇ ସେ ଆଉଲିଅଇ କଇଲା, “ଏ ଦାଉଦ୍‌ ରାଜାର୍‌ କୁଟୁମର୍‌ ପିଲା ଜିସୁ ! ତମେ ମକେ ଦୟା କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ଆଗେ ଜିବା ଲକ୍‌ମନ୍‌ କାଣାକେ ଦମ୍‌କାଇ କରି ଚୁପ୍‌ଅଇ ରଇବାକେ କଇଲାଇ । ମାତର୍‌ ସେ ଅଦିକ୍‌ ଅଦିକ୍‌ ଆଉଲି ଅଇ “ଏ ଦାଉଦ୍‌ ରାଜାର୍‌ କୁଟୁମର୍‌ ପିଲା ଜିସୁ ! ମକେ ଦୟା କରା !” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ଜିସୁ ତାର୍‌ କାତା ସୁନି ଟିଆ ଅଇଲା ଆରି, “ତାକେ ମର୍‌ ଲଗେ ଆନା” ବଲି ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","କାଣା ବିକାରି ଜିସୁର୍‌ ଲଗେ ଆଇଲାଜେ, ଜିସୁ ତାକେ ପାଚାର୍‌ଲା, “ମୁଇ ତର୍‌ପାଇ କାଇଟା କର୍‌ବି ବଲି ମନ୍‌ କଲୁସ୍‌ନି ?” ସେ ଜିସୁକେ “ଏ ମାପ୍‌ରୁ, ମକେ ଦେକ୍‌ବା ବପୁ ଦିଆ । ସେନ୍ତି ମକେ ନିମାନ୍‌ କରିଦେ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ତେବେ ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ଦେକ୍‌ବାକେ ପାଆ ! ମୁଇ ତର୍‌ ଆଁକି ନିକ କର୍‌ବି କାଇକେ ବଇଲେ, ତୁଇ ମର୍‌ତେଇ ବିସ୍‌ବାସ୍‌ କରି ଆଚୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ସେ ଦାପ୍‌ରେ, ସେ କାଣା ଦେକି ପାର୍‌ଲା । ଆରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ କରିକରି ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଗାଲା । ଏ ଗଟ୍‍ନା ଦେକ୍‌ଲା ସବୁ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ଡାକ୍‌ପୁଟା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜିରିଅ ବାଟେ ଜାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ତେଇ ଜକିୟ ନାଉଁର୍‌ ଗଟେକ୍‌ ମୁକିଅ ସିସ୍‌ତୁମାଙ୍ଗୁ ରଇଲା । ସେ ବେସି ସାଉକାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଜିସୁ କେନ୍ତାର୍‌ ଲକ୍‌ ବଲି ଦେକ୍‌ବାକେ ଜକିୟ ମନ୍‍ କର୍‌ତେ ରଇଲା । ମାତର୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ବେସି ଲକ୍‌ମନ୍‌ ଜାଇତେ ରଇଲାଇକେ ତାକେ ଦେକିନାପାର୍‌ତେ ରଇଲା । କାଇକେବଇଲେ ସେ ବୁଟି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ସେଟାର୍‌ ପାଇ ସେ, ଲକ୍‌ମନର୍‌ ଆଗ୍‌ତୁ ପାଲାଇ ଜାଇ ଜିସୁକେ ଦେକ୍‌ବାକେ ଗଟେକ୍‍ ଡୁମ୍‌ରି ଗଚେ ଚଗ୍‌ଲା । କାଇକେ ବଇଲେ ଜିସୁ ସେ ବାଟ୍‍ଦେଇ ଜିବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଜିସୁ ସେ ଜାଗାଇ କେଟି ଉପ୍‌ରେ ଦେକିକରି ଜକିୟକେ କଇଲା, “ଜକିୟ ବିଗି ଉତ୍‌ରି ଆଉ, ଆଜି ମୁଇ ତମର୍‌ ଗରେ ରଇବି ।” ");
INSERT INTO dso_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ତାର୍‌ ପଚେ ଜକିୟ ଦାପ୍‌ରେ ଉତ୍‌ରି ଆସି ବେସି ସାର୍‌ଦାଅଇ ଜିସୁକେ ତାର୍‍ ଗରେ ଡାକିନେଲା । ");
INSERT INTO dso_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ସେଟା ଦେକି ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ ଜିସୁ ଗଟେକ୍‌ ପାପି ଲକର୍‌ ଗରେ କାଇବାକେ ଗାଲାନି ବଲି ଗୁର୍‌ମୁରି ଜାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ଜକିୟ ଟିଆଅଇ ଜିସୁକେ କଇଲା, “ଏ ମାପ୍‌ରୁ, ସୁନା ! ମର୍‌ ସଁପତିଅନି ଅଦାବାଗ୍‍ ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ଦାନ୍‌ କରିଦେବି । ଆରି ସିସ୍‌ତୁ ମାଙ୍ଗ୍‌ବା ବେଲାଇ କାର୍‌ଟା ଅନିଆଇକରି ଆନି ରଇଲାଟା ମୁଇ ଚାର୍‌ଗୁନ୍‌ ଅଦିକ୍‌ ବାଉଡାଇ ଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ଜିସୁ ଜକିୟକେ କଇଲା, “ଆଜି ଏ ଗରେ ମୁକ୍‌ତି ମିଲ୍‌ଲା । କାଇକେବଇଲେ ଏ ମିସା ଗଟେକ୍‌ ଅବ୍‌ରାଆମର୍‌ ନାତିତିତି । ");
INSERT INTO dso_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ପର୍‌ମେସର୍‌ ଟାନେଅନି ଆସିରଇବା ନର୍‌ପିଲା ମୁଇ ପାପେ ରଇଲା ଲକ୍‌ମନ୍‌କେ ସେମନର୍‌ ପାପେଅନି ରକିଆ କର୍‌ବାକେ ଆସିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ସେମନ୍‌ ଜିରୁସାଲାମ୍‌ ଲଗେ ଆଇଲା ବେଲାଇ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଜିବା ଲକ୍‌ମନ୍‌ ତାର୍‌ କଇବା ସବୁ କାତା ସୁନ୍‌ତେ ରଇଲାଇ । କାଇକେବଇଲେ ତାର୍‌ କାତା ସୁନ୍‌ଲା ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ରାଇଜର୍‌ ସାସନ୍‌ ଦାପ୍‌ରେ ଅଇସି ବଲି ବାବ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ସେଟାର୍‌ପାଇ ସେ ଏ କାତାନି କଇଲା, ଗଟେକ୍‌ ବଡ୍‌ ଗରେ ଜନମ୍‌ ଅଇଲା ଲକ୍‌ ଦୁର୍‌ ଦେସେ ଜିବାକେ ତିଆର୍‌ ଅଇଲା । କାଇକେ ବଇଲେ ତେଇ ତାକେ ରାଜା କରାଇବାଇ । ସମାନ୍‌ ବେଲାଇ ତାର୍‌ ଦେସେ ସେ ବାଉଡି ଆଇସି । ");
INSERT INTO dso_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ତାର୍‌ ଆଗ୍‌ତୁ ସେ ତାର୍‌ ଦସ୍‌ଟା ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ଡାକି, ଗଟେକ୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ଗଟେକ୍‌ ଗଟେକ୍‌ ସୁନାର୍‌ ଡାବୁ ଦେଇ କରି କଇଲା, “ମୁଇ ବାଉଡି ଆଇବାଜାକ ଏ ଡାବୁ ବେବାର୍‌ କରି ବୁତେକ୍‌ କରି ରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ମାତର୍‌ ତାର୍‌ ଦେସର୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ଇନ୍‌ କର୍‌ତେରଇଲାଇ । ଆରି ସାସନ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ ଲଗେ କବର୍‌ କଇ ପାଟାଇଲାଇ, “ଏ ଲକ୍‌ ଆମ୍‌କେ ସାସନ୍‌ କର ବଲି ଆମେ ମନ୍‌ କରୁନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ଏନ୍ତି ବଲି କଇଲେ ମିସା, ସେ ରାଜାଅଇ ଗରେ ବାଉଡି ଆଇଲା । ଆରି ସେ କାକେ କାକେ ସୁନାର୍‌ ଡାବୁ ଦେଇ ରଇଲା, ସେମନ୍‌ କେତେକ୍‌ ଲାକା ଲାବ୍‌ କଲାଇ ଆଚତ୍‌ ବଲି ଜାନ୍‌ବାକେ ଡାକାଇ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ତେଇ ପର୍‌ତୁମର୍‌ ଲକ୍‌ ଆସି କଇଲା, “ଏ ଆଗିଆଁ, ତମେ ଦେଲା ଗଟେକ୍‌ ସୁନାର୍‌ ଡାବୁ ନେଇ ଆରି ଦସ୍‌ଟା କଲିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ସେ ରାଜା ସାର୍‌ଦା ଅଇ ତାକେ କଇଲା “ତୁଇ ନିକ ଦାଙ୍ଗ୍‌ଡା, ଅଲପ୍‌ ବିସଇ ଦାଇତ୍‌ ନେଇ କାମ୍‌ କଲୁସ୍‌ । ସେଟାର୍‌ପାଇ ମୁଇ ତକେ ଦସ୍‌ଟା ଗଡ୍‌ ଉପ୍‌ରେ ସାସନ୍‌ କର୍‌ବାକେ ସର୍‌ପି ଦେଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ଆରି ଗଟେକ୍‌ ଲକ୍‌ ଆସି କଇଲା, “ଆଗିଆଁ, ତୁଇ ଦେଇରଇଲା ସୁନାର୍‌ ଡାବୁ ନେଇ ଆରି ପାଁଚ୍‌ଟା ଲାବ୍‌ କଲିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ସେ ରାଜା ତାକେ ମିସା କଇଲା “ତକେ ସାସନ୍‌ କର୍‌ବାକେ ପାଁଚ୍‌ଟା ଗଡ୍‌ ସର୍‌ପିଦେଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ମାତର୍‌ ଆରି ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡା ରାଜାର୍‌ ଲଗେ ଆସି କଇଲା, “ଏ ଆଗିଆଁ, ତମେ ଦେଇରଇଲା ସୁନାର୍‌ ଡାବୁ ଏଦେ ଦେକା, ଗଟେକ୍‌ ଗର୍‌ଣ୍ଡାଇ ଗୁଡିଆ ବାନ୍ଦି ସଙ୍ଗଇ ଦେଇରଇଲି । ");
INSERT INTO dso_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ତୁଇ ସାସନ୍‌ କର୍‌ବା ଲକ୍‌ ବଲି ଡରିକରି ମୁଇ ସେଟା ନେଇ ବେବାର୍‌ କରିନାଇ । କାଇକେବଇଲେ ଜାକେ ଦେଇ ନ ରଉସ୍‌ ତାର୍‌ତେଇଅନି ମାଙ୍ଗିନେଇସୁ । ଆରି ଜନ୍ତି ବୁନି ନ ରଉସ୍‌ ତେଇଅନି କାଟି ନେଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ସେ ରାଜା ରିସାଅଇ କଇଲା, “ଅଇରେ ଦାଙ୍ଗ୍‌ଡା, ତର୍‌ କାତା ଇସାବେ ଆକା ତକେ ବିଚାର୍‌ କର୍‌ବି । ମୁଇ ଲକ୍‌ମନ୍‌ ଜନ୍‌ଟା ଦେଇ ନ ର‍ଇ ସେଟା ମାଗିନେବି, ଆରି ଜନ୍‌ତେଇ ବୁନି ନ ରଇ ତେଇଅନି କାଟ୍‌ବି, ସେଟା ଜାନିରଇଲୁସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ସେନ୍ତାର୍‌ଆଲେ ମର୍‌ ସୁନାର୍‌ ଡାବୁ କାଇକେ ବେଁକେ ସଙ୍ଗଉସ୍‌ ନାଇ ? ସଙ୍ଗଇ ରଇଲେ ତେଇଅନି ମକେ କଲନ୍ତର୍‌ ମିଲ୍‌ତା ।” ");
INSERT INTO dso_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ଆରି ସେ ଲଗେ ଟିଆଅଇଲା ଲକ୍‌ମନ୍‌କେ ରାଜା କଇଲା, “ତାର୍‍ ତେଇଅନି ଏ ଅଦ୍‌ଲି ମାଗିନେଇ ଜେ ଦସ୍‌ଟା ଅଦ୍‌ଲି ଲାବ୍‌କଲା ଆଚେ, ତାକେ ଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ମାତର୍‌ ସେ ଲକ୍‌ମନ୍‌ ରାଜାକେ ପାଚାର୍‌ଲାଇ, “ଏ ଆଗିଆଁ ତାର୍‌ଟାନେ ଦସ୍‌ଟା ଆଚେ ଆରି ତାକେ କାଇକେ ଦେଉଁ ?” ");
INSERT INTO dso_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ସେ କଇଲା, “ମୁଇ ତମ୍‌କେ କଇଲିନି, ଜାକେ ଆଚେ ତାକେ ଅଦିକ୍‌ ଦିଆଅଇସି, ମାତର୍‌ ଜାର୍‌ ନାଇ, ତାର୍‌ତେଇ ରଇଲା ଅଲପ୍‌ ମିସା ଚାଡାଇ ନିଆଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ମାତର୍‌ ଜେମନ୍‌ ମୁଇ ତାକର୍‌ ରାଜା ଅଇବାକେ ମନ୍‍ ନ କର୍‌ତେ ରଇଲାଇ, ସେମନ୍‍କେ ଡାକି ଆନି ମର୍‌ ମୁଆଟେ ମରାଇଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଜିସୁ ଏ ସବୁ କାତା କଇସାରାଇ ସିସ୍‌ମନର୍‌ ଆଗ୍‌ତୁ ଆଗ୍‌ତୁ ଜିରୁସାଲାମ୍‌ ବାଟେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ଜେଡେବଲ୍‌ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜିତ୍‌ଗଚ୍‌ମନ୍‌ ରଇଲା ଡଙ୍ଗର୍‌ ପାଲି ଆରି ବେତ୍‌ପାଗି ଆରି ବେତ୍‌ନିଆ ଗଡେ କେଟ୍‌ଲାଇ, ସେ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅନି ଦୁଇ ଲକ୍‌କେ, ସେମନ୍‌ ଜିବା ଆଗ୍‌ତୁ ଏନ୍ତାରି କଇପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ତମର୍‌ ମୁଆଟେ ରଇବା ଗାଏଁ ଜାଆ । ସେ ଗାଏଁ ଗାଲେ, କେ କେବେ ମିସା ଚଗିନରଇବା ଗଦପିଲା ବାନ୍ଦିଅଇରଇଲାଟା ଦେକ୍‌ସା । ତାକେ ମେଲି ଦାରିଆସା । ");
INSERT INTO dso_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ଜେ ଜଦି ତମ୍‌କେ “କାଇକେ ମେଲି ନେଲାସ୍‌ନି ?” ବଲି କଇଲେ “ଏଟା ଗୁରୁକେ ଦର୍‌କାର୍‌ ଆଚେ ବଲି କୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ପଚେ ସିସ୍‌ମନ୍‌ ସେ ଗାଏଁ ଜାଇ, ଜିସୁ ଜେନ୍ତି କଇରଇଲା ସେନ୍ତି ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ଆରି ସେମନ୍‌ ସେ ଗଦପିଲାକେ ମେଲ୍‌ବାବେଲେ ଗଦ ପିଲାର୍‌ ସାଉକାର୍‌ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “କାଇକେ ଗଦପିଲାକେ ମେଲ୍‌ଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ସିସ୍‌ମନ୍‌ କଇଲାଇ, “ଏ ଗଦପିଲା ଗୁରୁକେ ଦର୍‌କାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ସିସ୍‌ମନ୍‌ ଗଦ ପିଲାକେ ଜିସୁର୍‌ ଲଗେ ଆନି ନିଜର୍‌ ନିଜର୍‌ ଲୁଗା ଗଦର୍‌ ଉପ୍‌ରେ ଡାବି ଜିସୁକେ ତାର୍‌ ଉପ୍‌ରେ ବସାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ଆରି ଜିସୁ ଗାଲା ବାଟେ ଲକ୍‌ମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ପଚିଆମନ୍‌ ଅଚାଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ଜିସୁ ଜେଡେବଲ୍‌ ଜିତ୍‌ଗଚ୍‌ମନ୍‌ ରଇଲା ଗଡ୍‌ଗଡା ଜାଗା ଲଗେ କେଟ୍‌ଲା, ସେବେଲା ତେଇ ରଇଲା ତାର୍‌ ଜେତ୍‌କି ସିସ୍‌ ମାନ୍ଦା ସେ କରିରଇଲା କାବାଅଇଜିବା କାମ୍‌ ଏତାଇ, ସାର୍‌ଦାଅଇ ଆଉଲିଅଇକରି ପର୍‌ମେସର୍‌କେ ଜୁଆର୍‌ କରି କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ପର୍‌ମେସରର୍‌ ନାଉଁ ନେଇକରି ଜନ୍‌ ରାଜା ଆଇଲାନି ତାକେ ସେ ଆସିର୍‌ବାଦ୍‌ କର । ସର୍‌ଗେ ସାନ୍ତି ଅ, ଆରି ସବୁର୍‌ଟାନେ ଅନି ବଡ୍‌ ପର୍‌ମେସରର୍‌ ମଇମା ଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ସେ ସିସ୍‌ ମାନ୍ଦାର୍‌ ବିତ୍‌ରେ କେତେଟା ପାରୁସିମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ଏ ଗୁରୁ ତର୍‌ସଙ୍ଗ୍‌ ଆଇବା ସିସ୍‌ମନ୍‌କେ ଚିମ୍‌ରାଅଇ ରଇବାକେ କଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ତମ୍‌କେ କଇଲିନି, ଏ ଲକ୍‌ମନ୍‌ ଚିମ୍‌ରାଅଇ ରଇଲେ ପାକ୍‌ନାମନ୍‌ ତାକର୍‌ ନିଜେ ନିଜେ ଆଉଲି ଅଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ଜିସୁ ଜିରୁସାଲାମ୍‌ ଲଗେ କେଟ୍‌ଲା ବେଲେ ସେ ଗଡ୍‌ ଦେକି କାନ୍ଦିକରି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“ସାନ୍ତି ପାଇବାକେ କାଇଟା ଦର୍‌କାର୍‌, ସେଟା ଜଦି ତମେ ଆଜି ଜାନିରଇତାସ୍‌ ଆଲେ, କେତେ ନିକ ଅଇତା ! ମାତର୍‌ ସେସବୁ ଏବେ ତମେ ଦେକି ନାପାର୍‌ଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ସେଟାର୍‌ପାଇ ବଲି ଏନ୍ତି ବେସି ବାଦା ଅଇଜିବା ଦିନ୍‌ ଆଇସି । ତମର୍‌ ସତ୍‌ରୁମନ୍‌ ତମର୍‌ ଚାରିବେଟ୍‌ତି ପାଚୁରି ବାନ୍ଦି ଅଟ୍‌କାଇବାଇ ଆରି ଚାରିବେଡ୍‌ତି ଅନି ତମର୍‌ ଉପ୍‌ରେ ମାଣ୍ଡି ଆଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ସେମନ୍‌ ତମ୍‌କେ ଆରି ତମର୍‌ ପାଚୁରି ତେଇ ରଇବା ଲକ୍‌ମନ୍‌କେ ପୁରାପୁରୁନ୍‌ ନସାଇ କୁଟ୍‌କୁଟା କରିଦେବାଇ । ଗଟେକ୍‌ ପାକ୍‌ନା ମିସା ନିଜର୍‌ ଜାଗାଇ ନ ଚାଡତ୍‌ । କାଇକେବଇଲେ ପର୍‌ମେସର୍‌ ତମ୍‌କେ ରକିଆ କର୍‌ବାକେ ଆସିରଇଲା, ସେବେଲା ତମେ ଜାନି ନାପାର୍‌ଲାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ଆରି ଜିସୁ ଜିରୁସାଲାମ୍‌ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ପୁରିକରି ତେଇ ଗେନାବିକା କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ବାର୍‌କରାଇଦେବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ସେମନ୍‌କେ କଇଲା, “ଦରମ୍‌ ସାସ୍‌ତରେ ଏନ୍ତାରି ଲେକାଅଇଲା ଆଚେ, ମର୍‌ ଗର୍‌ ପାର୍‌ତନା ଗର୍‌ ଅଇସି । ମାତର୍‌ ତମେ ସେଟା ଚର୍‌ମନର୍‌ ଲୁଚ୍‌ବା ଜାଗା କରିଆଚାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ତାର୍‌ ପଚେ ଜିସୁ ସବୁଦିନେ ଜିରୁସାଲାମ୍‌ ମନ୍ଦିରେ ସିକିଆ ଦେଇତେ ରଇଲା । ମାତର୍‌ ମୁକିଅ ପୁଜାରିମନ୍‌, ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ଆରି ନେତାମନ୍‌ ମିସି ଜିସୁକେ ମରାଇବାକେ ଚେସ୍‌ଟା କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","କାଇକେ ବଇଲେ ଗୁଲାଇ ଲକ୍‌, ଜିସୁ ସିକାଇଦେବା କାତା ଆରି ସେ କଇତେରଇବା ପଦ୍‌ମନ୍‌ ମନ୍‌ଦିଆନ୍‌ ଦେଇ ସୁନ୍‌ତେ ରଇଲାଇ । ତେବର୍‌ ପାଇ ସେମନ୍‌ କେନ୍ତାର୍‌ କର୍‌ବାର୍‌ ବଲି ବାଟ୍‌ ମିଲାଇ ନାପାର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ଦିନେକ୍‌ ଜିସୁ ମନ୍ଦିରେ ଲକ୍‌ମନ୍‌କେ ମାପ୍‌ରୁର୍‌ ନିମାନ୍‌ କାତାର୍‍ ସିକିଆ ଦେଇତେରଇଲା । ସେବେଲାଇ ମୁକିଅ ପୁଜାରିମନ୍‌, ନିୟମ୍‌ ସିକାଇଦେବା ଲକ୍‌ମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ପାଚାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“ତୁଇ କାର୍‌ ଅଦିକାର୍‌ ମିଲାଇକରି ଏସବୁ ବିସଇ କଲୁସ୍‌ନି ? କେ ତକେ ଏ ଅଦିକାର୍‌ ଦେଲା ? ଆମ୍‌କେ କ ।” ");
INSERT INTO dso_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ମାତର୍‌ ଜିସୁ କଇଲା, “ମୁଇ ମିସା ତମ୍‌କେ ଗଟେକ୍‌ କାତା ପାଚାର୍‌ବି, ତମେ ମକେ କୁଆ । ");
INSERT INTO dso_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ଜଅନ୍‌ କାର୍‌ ଅଦିକାର୍‌ ମିଲାଇ ଲକ୍‌ମନ୍‌କେ ଡୁବନ୍‌ ଦେଇତେ ରଇଲା ? ସରଗର୍‌ ପର୍‌ମେସର୍‌ ଦେଲାଟାନେ ଅନି କି, ଲକ୍‌ମନର୍‌ଟାନେ ଅନି ?” ");
INSERT INTO dso_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ସେବେଲାଇ ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ଦଦାପେଲା ଅଇଲାଇ । ଜଦି ଜଅନର୍‌ ଡୁବନ୍‌ ସର୍‌ଗେଅନି ବଲି କଇଲେ, କାଇକେ ତାକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ ? ବଲି କଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ମାତର୍‌ ଆମେ ଲକ୍‌ମନର୍‌ତେଇଅନି ବଲି କଇଲେ ସବୁ ଲକ୍‌ ଆମ୍‌କେ ପାକ୍‌ନା ମାର୍‌ବାଇ । କାଇକେ ବଇଲେ, ଜଅନ୍‌ ସତ‍ଇସେ ପର୍‌ମେସରର୍‌ତେଇ ଅନି ଆଇଲା ବବିସତ୍‌ବକ୍‌ତା ବଲି ଆମର୍‌ ଜିଉଦି ଲକ୍‌ମନ୍‌ ବିସ୍‌ବାସ୍‌ କଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଏଟା ବାବିକରି ସେମନ୍‌ “ଆମେ ନାଜାନୁ ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଆରି ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏନ୍ତି ବଇଲେ ମୁଇ ମିସା କାର୍‌ ଅଦିକାର୍‌ ମିଲାଇକରି ଏସବୁ ବିସଇ କଲିନି, ସେଟା ତମ୍‌କେ ନ କଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ତାର୍‌ ପଚେ ଜିସୁ ଲକ୍‌ମନ୍‌କେ ବୁଜାଇବାକେ ଗଟେକ୍‌ କାତାନି କଇଲା । “ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‌ ପଦାଇ ଅଙ୍ଗୁର୍‌ ତାସ୍‌ କରି, କେତେଟା ତାସିକେ ଆଦିବାଗ୍‌ କର୍‌ବାକେ ଦେଲା । ଦେଇକରି ସେ ବେସି ଦିନର୍‌ ପାଇ ଗଟେକ୍‌ ଦୁର୍‌ ଦେସେ ରଇବାକେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ଆରି ଅଙ୍ଗୁର୍‌ ତଲ୍‌ବାବେଲା କେଟ୍‌ଲାକେ ସାଉକାର୍‌ ତାର୍‌ ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡାକେ ତାର୍‌ ବାଗ୍‌ ମାଙ୍ଗି ଆନ୍‌ବାକେ ପାଟାଇଲା । ମାତର୍‌ ସେ ଲକ୍‌ମନ୍‌ ତାର୍‌ ବାଗ୍‌ ନ ଦେଇ ତାର୍‌ ଦାଙ୍ଗ୍‌ଡାକେ କୁଟ୍‌କୁଟା ମାରି ଚୁଚା ଆତେ ପାଟାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ତାର୍‌ ପଚେ ସେ ଆରି ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡାକେ ପାଟାଇଲା । ସେମନ୍‌ ତାକେ ମିସା ମାରିକରି ନିନ୍ଦା କାତା କଇ, ଲାଜ୍‌ କରାଇକରି ଚୁଚା ଆତେ ପାଟାଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ତାର୍‌ ପଚେ ସାଉକାର୍‌ ଆରି ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡାକେ ସେମନର୍‌ ଲଗେ ପାଟାଇଲା । ମାତର୍‌ ସେ ଦାଙ୍ଗ୍‌ଡାକେ ମିସା ରଗ୍‍ରଗା ଅଇତେ ମାରି କେଦିଦେଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ତାର୍‌ ପଚେ ସାଉକାର୍‌ ମନେ ମନେ ବାବ୍‌ଲା, “ଏବେ ମୁଇ କାଇଟା କର୍‌ବି ? ମୁଇ ବେସି ଆଲାଦ୍‌ କର୍‌ବା ମର୍‌ ପିଲାକେ ପାଟାଇବି । ବାଇଦରେ ସେମନ୍‌ ତାକେ ମାନ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ମାତର୍‌ ସେମନ୍‌ ସେ ପିଲା ଆଇବାଟା ଦେକିକରି ତାକର୍‌ ବିତ୍‌ରେ କାତାଅଇଲାଇ, “ଏଟାସେ ସେ ସାଉକାରର୍‌ ପିଲା, ଆମେ ଆକେ ମରାଇଦେଲେ ଏ ସବୁ ଦନ୍‌ ଆମର୍‌ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ଆରି ସେମନ୍‌ ସାଉକାରର୍‌ ପିଲାକେ ବାଇରେ ନେଇ ମାରି ମରାଇଦେଲାଇ । ଏନ୍ତି ବଇଲେ ସାଉକାର୍‌ ସେ ଲକ୍‌ମନ୍‌କେ କାଇଟା କରିରଇସି ? ");
INSERT INTO dso_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ମୁଇ ତମ୍‌କେ କଇଲିନି, ସେ ଆସିକରି ସେ ଲକ୍‌ମନ୍‌କେ ମରାଇ ଦେଇସି । ଆରି ବଡ୍‌ ବିନ୍‌ଲକ୍‌ମନ୍‌କେ ଆଦିବାଗ୍‌ କର୍‌ବାକେ ଦେଇସି ।” ମାତର୍‌ କାତାନି ସୁନ୍‌ତେ ରଇଲା ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ଏନ୍ତାର୍‌ କେବେ ମିସା ନଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ମାତର୍‌ ଜିସୁ ଲକ୍‌ମନ୍‌କେ ନିକ ଦେକିକରି କଇଲା, “ଏନ୍ତି ବଇଲେ ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଲେକାଅଇଲା ଅରତ୍‌ କାଇଟା ? ଗର୍‌ବାନ୍ଦ୍‌ବା ଲକ୍‌ମନ୍‌ ଜନ୍‌ ପାକ୍‌ନା ‘ନଏଁ’ ବଲି ଚାଡି ଦେଇରଇଲାଇ ସେ ପାକ୍‌ନାସେ ଗର୍‌ କନର୍‌ ମୁଲ୍‌ ପାକ୍‌ନା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ସେ ପାକ୍‌ନା ଉପ୍‌ରେ ଅଦର୍‌ବାଇ, ସେମନ୍‌ କଣ୍ଡ୍‌ କଣ୍ଡ୍‌ ଅଇଜିବାଇ, ଆରି ସେ ପାକ୍‌ନା ଜାର୍‌ ଉପ୍‌ରେ ଅଦର୍‌ସି, ସେ ବିଲି ଆଜିଜାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ସେବେଲା ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ଆରି ମୁକିଅ ପୁଜାରିମନ୍‌ ଜିସୁର୍‌ କାତାନି ସୁନି, ତାକେ ଦାପ୍‌ରେ ବନ୍ଦି କର୍‌ବାକେ ବାଟ୍‌ କଜ୍‌ତେ ରଇଲାଇ । କାଇକେ ବଇଲେ ଜିସୁ କଇବା ଅଙ୍ଗୁର୍‌ ବାଡର୍‌ କାତା, ସେମନର୍‌ ବିସଇନେଇ କଇଲାନି ବଲି ବୁଜ୍‌ଲାଇ । ମାତର୍‌ ସେମନ୍‌ ଲକ୍‌ମନ୍‌କେ ଡର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ସେଟାର୍‌ପାଇ ସେମନ୍‌ ତାର୍‌ ବୁଲ୍‌ ଦାର୍‌ବାକେ ଗଟେକ୍‌ ସୁଜଗ୍‌ କଜ୍‌ତେ ରଇଲାଇ । ସେମନ୍‌ କେତେଟା ଚର୍‌ମନ୍‌କେ ଲାଁଚ୍‍ଦେଇ ଦରମ୍‌ ଲକ୍‌ପାରା ଦେକାଇ ଅଇବାକେ ପାଟାଇଲାଇ । କାଇକେ ବଇଲେ ଜିସୁର୍‌ ଟଣ୍ଡେଅନି ବୁଲ୍‌କାତା ବାର୍‌କରାଇ, ଦସ୍‌ ଦାରି, ରମିୟ ସାସନ୍‌କାରିଆକେ ସର୍‌ପି ଦେବାକେ ମନ୍‌କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ସେଟାର୍‌ପାଇ ସେ ଚର୍‌ମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏ ଗୁରୁ, ତମେ ଟିକ୍ କଇଲାସ୍‌ନି ଆରି ଟିକ୍ ସିକାଇଲାସ୍‌ନି ବଲି ଆମେ ଜାନିଆଚୁ । କାର୍‌ବାଟେ ନ ଅଇ ଲକ୍‌ମନର୍‌ ଜିବନର୍‌ପାଇ ପର୍‌ମେସରର୍‌ ସତ୍‌ ବିସଇସେ ସିକାଇଲୁସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ଏବେ ତୁଇ ଆମ୍‌କେ କଅ, ରମିୟ ସର୍‌କାରର୍‌ ରାଜା କାଇସର୍‌କେ ସିସ୍‌ତୁ ଦେବାଟା ଆମର୍‌ ନିୟମ୍‌ ଇସାବେ ଟିକ୍‌ କି ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ମାତର୍‌ ଜିସୁ ସେମନର୍‌ ମନ୍‌ବିତ୍‌ରର୍‌ କାତା ଜାନିକରି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ମକେ ଗଟେକ୍‌ ରମିୟ ସର୍‌କାରର୍‌ ଅଦ୍‌ଲି ଡାବୁ ଦେକାଆ । ତେଇ କାର୍‌ ମୁର୍‌ତି ଆରି କାର୍‌ ନାଉଁ ଆଚେ ?” “କାଇସରର୍‌ ମୁର୍‌ତି ଆରି ନାଉଁ ଆଚେ ।” ବଲି ସେମନ୍‌ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“ସେନ୍ତାର୍‌ ରଇଲେ ଜନ୍‌ଟା କାଇସରର୍‌ଟା ସେଟା କାଇସର୍‌କେ ଦିଆସ୍‌, ଜନ୍‌ଟା ପର୍‌ମେସରର୍‌ଟା ସେଟା ପର୍‌ମେସର୍‌କେ ଦିଆସ୍‌ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ଏ କାତା ସୁନି ସବୁଲକର୍‌ ମୁଆଟେ ସେମନ୍‌ ଜିସୁର୍‌ ବୁଲ୍‌ ଦାର୍‌ବାର୍‌ ନାପାର୍‌ଲାଇ । ଆରି ଜିସୁର୍‌ କାତା ସୁନି ସେମନ୍‌ କାବାଅଇଜାଇ, ଚୁପ୍‌ଅଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ତାର୍‌ ପଚେ କେତେଟା ସାଦୁକି ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଗାଲାଇ । ସେମନ୍‌, ମଲା ଲକ୍‌ମନ୍‌ ଆରି ତରେକ୍‌ ଜିବନ୍‌ଅଇ ଉଟ୍‌ବା ବିସଇ ବିସ୍‌ବାସ୍‌ ନ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ସେମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏ ଗୁରୁ, ମସା ଆମର୍‌ ପାଇ ଏନ୍ତି ନିୟମ୍‌ ଲେକିଆଚେ ଜେ, ଗଟେକ୍‌ ଲକ୍‌ ବିବାଅଇ ପିଲାଟକି ନ ଅଇତେ ମରିଗାଲେ ତାର୍‌ ବାଇ ସେ ରାଣ୍ଡିମାଇଜିକେ ସଙ୍ଗଇସି । ଆରି ପିଲାଟକି ଅଇଲେ ତାର୍‌ ବଡ୍‌ବାଇର୍‌ କୁଟୁମ୍‌ ରକିଆ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ଏନ୍ତି ସାତ୍‌ବାଇ ରଇଲାଇ । ପର୍‌ତୁମ୍‌ ବାଇ ବିବା ଅଇ ପିଲାଟକି ନଇତେ ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ତାର୍‌ ପଚେ ବଡ୍‌ମଜିଆ ରାଣ୍ଡିମାଇଜିକେ ସଙ୍ଗଇଲା । ମାତର୍‌ ସେ ମିସା ପିଲାଟକି ନଇତେ ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ତାର୍‌ ପଚେ ମଜିଆବାଇ ରାଣ୍ଡିମାଇଜିକେ ସଙ୍ଗଇଲାକେ ପିଲାଟକି ନଇତେ ମରିଗାଲା । ସେନ୍ତି ସେ ରାଣ୍ଡିମାଇଜିକେ ସାତ୍‌ ବାଇ ଜାକ ସଙ୍ଗଇ ପିଲାଟକି ନଇତେ ମରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ସାରାସାରି ପଚେ ସେ ମିସା ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ଏନ୍ତି ବଇଲେ ମଲାତେଇଅନି ଉଟ୍‌ଲା ପଚେ ସେ କାର୍‌ ମାଇଜି ଅଇସି ? କାଇକେ ବଇଲେ ସେମନ୍‌ ସାତ୍‌ ଲକ୍‌ଜାକ ତାକେ ସଙ୍ଗଇ ରଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏ ଜୁଗର୍‌ ମାଇଜି ମନସ୍‌ ବିବା ଅଇବାଇ, ");
INSERT INTO dso_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ମାତର୍‌ ଜନ୍‌ ମାଇଜିମନସ୍‌ ମଲାଟାନେଅନି ଉଟି, ଆଇବା ଜଗତେ ଜିଇବା କାଇବାକେ ବାଚିଅଇଆଚତ୍‌, ସେମନ୍‌ ବିବା ନ ଅଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ସେମନ୍‌ ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ମନର୍‌ପାରା ଅଇ ଆରି କେବେମିସା ନ ମରତ୍‌ । ପଚେ ମଲାଟାନେଅନି ଉଟି ପର୍‌ମେସରର୍‌ ପିଲାଟକି ଅଇ ରଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ମସା ବଲ୍‌ କରି ବୁଜାଇ ଦେକାଇଦେଇ ଆଚେ । ମଲା ଲକ୍‌ମନ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ବାଇ । ଲାଗ୍‌ତେ ରଇବା ବୁଟାର୍‌ କାତାଇ, ମସା ଅବ୍‌ରାଆମର୍‌ ପର୍‌ମେସର୍‌, ଇସାକର୍‌ ପର୍‌ମେସର୍‌ ଆରି ଜାକୁବର୍‌ ପର୍‌ମେସର୍‌ ବଲି ପର୍‌ମେସର୍‌କେ ଜାନାଇ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ପର୍‌ମେସର୍‌ ମଲା ଲକ୍‌ମନର୍‌ ମାପ୍‌ରୁ ନଏଁ, ଜିବନ୍‌ ରଇଲା ଲକ୍‌ମନର୍‌ ମାପ୍‌ରୁ । ପର୍‌ମେସରର୍‌ ଦେକ୍‌ବା ଇସାବେ ତେଇ ସେମନ୍‌ ସବୁ ଲକ୍‌ ଜିବନ୍‌ ଅଇଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ତାର୍‌ ପଚେ କେତେଟା ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ “ଏ ଗୁରୁ ତୁଇ ବଡେ ନିକସଙ୍ଗ୍‍ ଉତର୍‌ ଦେଇଆଚୁସ୍‌ !” ବଲି ଜିସୁକେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","କାଇକେବଇଲେ ଜିସୁକେ ଆରି କେ ମିସା ପର୍‌ସନ୍‌ ପାଚାର୍‌ବାକେ ସାଆସ୍‌ କରତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ତାର୍‌ ପଚେ ଜିସୁ ତାର୍‌ କାତା ସୁନ୍‌ବା ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ପର୍‌ମେସର ବାଚିପାଟାଇଲା କିରିସ୍‌ଟ ଦାଉଦ୍‌ ରାଜାର୍‌ ନାତିତିତି ବଲି ଲକ୍‌ମନ୍‌ କାଇକେ କଇଲାଇନି ?” ");
INSERT INTO dso_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","କାଇକେ ବଇଲେ ଦାଉଦ୍‌ ରାଜା ଗିତ୍‌ସଙ୍ଗିତା ବଇତେଇ ନିଜେ ଏନ୍ତି ଲେକି ଆଚେ, ପର୍‌ମେସର୍‌ ମର୍‌ ମାପ୍‌ରୁକେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ମୁଇ ତର୍‌ ବିରଦିମନ୍‌କେ ଆରାଇକରି ତର୍‌ ପାଦ୍‌ତଲେ ସଙ୍ଗଇବା ପିଡାପାରା ନ କର୍‌ବା ଜାକ, ତୁଇ ମର୍‌ ଉଜାବାଟେସେ ବସି ର । ");
INSERT INTO dso_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ଜଦି ଦାଉଦ୍‌ ରାଜା କିରିସ୍‌ଟକେ ମାପ୍‌ରୁ ବଲି ଡାକି ରଇଲେ ଆରି କିରିସ୍‌ଟ କେନ୍ତି ଦାଉଦ୍‌ ରାଜାର୍‌ ନାତିତିତି ଅଇସି ? ବଲି ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ସେବେଲା ସବୁ ଲକ୍‌ମନ୍‌ ଜିସୁ ସିକାଇବା ବିସଇ ସୁନ୍‌ତେ ରଇଲାବେଲେ, ସେ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ନିୟମ୍‌ ସିକାଇବା ଲକ୍‌ମନର୍‌ତେଇଅନି ଜାଗ୍‌ରତ୍‌ ରୁଆ । ସେମନ୍‌ ନିମାନ୍‌ ପଚିଆ ପିନ୍ଦି ବୁଲ୍‌ବାକେ ମନ୍‌ କର୍‌ବାଇ । ଆଟେବାଟେ ଜୁଆର୍‌ ପାଇବାକେ, ପାର୍‌ତନା ଗରର୍‌ ମୁକିଆ ଜାଗାଇ ବସ୍‌ବାକେ, ଆରି ବଜିତେଇ ସବୁ ଲକର୍‌ଟାନେଅନି ଆଗ୍‌ତୁ ବସ୍‌ବାକେ ମନ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ସେମନ୍‌ ଲାଜ୍‌ ନଅଇ ରାଣ୍ଡି ମାଇଜିମନ୍‌କେ ନାଡାଇକରି ସେମନର୍‌ ଦନ୍‌ସଁପତି ଜୁରି ନେବାଇ । ମାତର୍‌ ସେମନ୍‌ ନିମାନ୍‌ ଲକର୍‌ପାରା ଦେକାଇଅଇବାଇ । ଆରି ଲକ୍‌ମନର୍‌ ମୁଆଟେ ବେସି ଲମାଇକରି ପାର୍‌ତନା କର୍‌ବାଇ । ଏନ୍ତାରି ଲକ୍‌ମନ୍‌କେ ପର୍‌ମେସର ବେସି ବଡ୍‌ ଡଣ୍ଡ୍‌ ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ତାର୍‌ ପଚେ ଜିସୁ ଚାରିବେଡ୍‌ତି ଦେକ୍‌ଲା ଆରି ସାଉକାର୍‌ ଲକ୍‌ମନ୍‌ ମନ୍ଦିରର୍‌ ପେଟିଆଟାନେ ଦାନ୍‌ ଦେବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ସେବେଲା ଗଟେକ୍‌ ଅର୍‍କିତ୍‍ ରାଣ୍ଡି ମାଇଜି ମିସା ଜଡେକ୍‌ ତାମାକାସୁ ଦେବାଟା ଜିସୁ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ସବୁ ଲକର୍‌ଟାନେଅନି ଏ ରାଣ୍ଡିମାଇଜି ଅଦିକ୍‌ ଦେଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","କାଇକେ ବଇଲେ ସାଉକାର୍‌ ଲକ୍‌ମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ଅଗଲ୍‌ଲା ଦନ୍‌ତେଇଅନି ଅଲପ୍‌ ଅଲପ୍‌ ଦେଲାଇ ଆଚତ୍‌ । ମାତର୍‌ ଏ, ନିଜେ ବଁଚ୍‌ବା ପାଇ ତାର୍‍ ଜେତ୍‌କି ରଇଲା ସବୁ ଦେଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","କେତେଟା ସିସ୍‌ମନ୍‌ ମନ୍ଦିରର୍‌ ବିସଇ ନେଇକରି ନିଆଇ କର୍‌ତେ ରଇଲାଇ । “ତେଇ ଲାଦିରଇବା ସୁନ୍ଦର୍‌ ସୁନ୍ଦର୍‌ ପାକ୍‌ନା ଆରି ପର୍‌ମେସର୍‌କେ ସର୍‌ପି ଦେଲା ଦାନ୍‌ ସଙ୍ଗ୍‌ କେତେକ୍‌ ସୁନ୍ଦର୍‌ ଗର୍‌ ବାନ୍ଦ୍‌ଲାଇ ଆଚତ୍‌” ବଲି କାତାଅଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“ଏନ୍ତି ଦିନ୍‌ ଆଇସି, ଏବେ ତମେ କାଇ କାଇଟା ଦେକ୍‌ଲାସ୍‌ନି ସେଟା ସବୁ କୁରୁପ୍‍ନାସ୍‍ ଜାଇସି । ଗଟେକ୍‌ ପାକ୍‌ନା ମିସା ତାର୍‌ ଜାଗାଇ ନ ରଏ । ସବୁ ମାଟିତେଇ ମିସି ଜାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ତାର୍‌ ପଚେ ସେମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏ ଗୁରୁ, ଏଟା ସବୁ କେବେ ଅଇସି ? ଆରି ଏ ସବୁ ଗଟ୍‍ନା କେଟ୍‌ବା ଆଗ୍‌ତୁ ସେଟା କେଡେବଲ୍‌ ଅଇସି ବଲି କେନ୍ତି ଚିନି ଅଇସି ?” ");
INSERT INTO dso_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଜାଗ୍‌ରତ୍‌ଅଇକରି ରୁଆ, ନାଡାଇ ଉଆ ନାଇ । ବେସି ଲକ୍‌ ମର୍‌ ନାଉଁଦାରି ଆସି କଇବାଇ, ‘ମୁଇ ସେ ଆକା ।’ ବେଲା କେଟ୍‌ଲା ଆଚେ, ମାତର୍‌ ତମେ ସେମନର୍‌ ପଚେ ଜାଆ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ଆରି କେବେ ତମେ ଜୁଇଦ୍‌ ଆରି କିରମାର ଅଇବାଟା ସୁନ୍‌ସା, ସେବେଲା ଡରା ନାଇ । କାଇକେ ବଇଲେ ଏ ସବୁ ଗଟ୍‍ନା ଆଗ୍‌ତୁ ଅଇସିସେ । ମାତର୍‌ ଏ ଦୁନିଆର୍‌ ସେସ୍‌ ଦିନ୍‌ ସେଦାପ୍‌ରେ ନ ଆସେ ।” ");
INSERT INTO dso_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ଆରି ଜିସୁ କଇଲା, “ଦେସ୍‌ ବିରୁଦେ ଦେସ୍‌ ଆରି ଜାତି ବିରୁଦେ ଜାତି ଉଟ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ଦର୍‌ତନି ଚୁଲ୍‌ବୁଲ୍‌ସି । ବଡ୍‌ ରଗ୍‌ମନ୍‌ ଅଇସି ଆରି ଆକାସେ କେବେ ନ ଅଇବା କାବା ଅଇଜିବା ଚିନ୍‌ମନ୍‌ ଡିସ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ମାତର୍‌ ଏ ସବୁ ବିସଇ ନ ଅଇବା ଆଗ୍‌ତୁ, ତମ୍‌କେ ବାନ୍ଦିକରି ନେଇ ସାସ୍‌ତି ଦେବାଇ, ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ବିଚାର୍‌ କରି ବନ୍ଦିଗରେ ପାକାଇବାକେ ସର୍‌ପିଦେବାଇ । ମର୍‌ପାଇ ତମେ ରାଜା ଆରି ସାସନ୍‌ କାରିଆମନର୍‌ ମୁଆଟେ ଟିଆ ଅଇସା । ");
INSERT INTO dso_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ମର୍‌ ବିସଇ ତମେ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ କଇବାକେ ଗଟେକ୍‌ ସମାନ୍‍ ବେଲା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ତେବର୍‌ ପାଇ ‘ମୁଇ ନିଜ୍‌କେ କେନ୍ତି ରକିଆ କର୍‌ବି ?’ ସେ ବିସଇ ବାବିକରି ଆଗେଅନି ଚିନ୍ତା କରା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","କାଇକେ ବଇଲେ ମୁଇ ତମ୍‌କେ ଟିକ୍‌ପଦ୍‌ କଇବାକେ ଗିଆନ୍‌ ଦେବି । ତମ୍‌କେ ବିରଦ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌ ସେ ଗିଆନର୍‌ ବାଦୁଲେ କାଇଟା କ‍ଇନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ଆରି ତମର୍‌ ମାଆ ବାବା, ବାଇ, ନିଜର୍‌ ଲାଗାର୍‌ ଲିତାର୍‌ ଲକ୍‌, ମଇତର୍‌ମନ୍‌ ଆରି କୁଟୁମର୍‌ ଲକ୍‌ମନ୍‌, ତମ୍‌କେ ବିରଦିମନ୍‌କେ ସର୍‌ପି ଦେବାଇ ଆରି ତମର୍‌ ବିତ୍‌ରେ ଅନି କେତେ ଲକ୍‌କେ ମରାଇଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ତମେ ମର୍‌ତେଇ ବିସ୍‌ବାସ୍‌ କଲାସ୍‌ନି ବଲି ଗୁଲାଇ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଇନ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ମାତର୍‌ ତମର୍‌ ମୁଣ୍ଡର୍‌ ଚେଣ୍ଡି ମିସା ଗଟେକ୍‌ ନ ନସେ । ");
INSERT INTO dso_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ତମେ ଡାଟ୍‌ଅଇ ରଇଲେ ଏ ସବୁ ବିସଇ ମୁର୍‌ଚିକରି, ତମର୍‌ ଆତ୍‌ମାକେ ରକିଆ କର୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ମାତର୍‌ ଜେଡେବଲ୍‌ ତମେ ଜିରୁସାଲମ୍‌ ଗଡେ ବିରଦି ସନିଅମନ୍‌ ଚାରିବେଡ୍‌ତି କିନ୍ଦ୍‌ରି ରଇବାଟା ଦେକ୍‌ସା ବଇଲେ, ସେବେଲା ଜିରୁସାଲାମ୍‌ ନସ୍‌ଟ ଅଇବା ବେଲା ଲଗେ କେଟ୍‌ଲା ବଲି ଜାନା । ");
INSERT INTO dso_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ସେବେଲାଇ କେ କେ ଜିଉଦା ଦେସେ ରଇବାଇ, ସେମନ୍‌ ଡଙ୍ଗର୍‌ ବିତ୍‌ରେ ପାଲାଅତ୍‌ । କେ କେ ଗଡ୍‌ ବିତ୍‌ରେ ରଇବାଇ ସେମନ୍‌ କେନେ ମିସା ବଁଚ୍‌ବାକେ ପାଲାଅତ୍‌ । କେ କେ ଗଡ୍‌ ବାଇରେ ରଇବାଇ ସେମନ୍‌ ଗଡ୍‌ ବିତ୍‌ରେ ନ ପୁରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","କାଇକେ ବଇଲେ ସେଟା ସାସ୍‌ତରର୍‌ ସବୁ ବିସଇ ଜେନ୍ତିକି ସିଦ୍‌ ଅଇସି, ସେଟାର୍‌ ପାଇ ସେ ଦିନ୍‌ମନ୍‌ ବେସି ଡଣ୍ଡ୍‌ ପାଇବା ଦିନ୍‌ମନ୍‍ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ସେ ଦିନ୍‌ମନ୍‌କେ ଗାଗ୍‌ଡେ ରଇବା ମାଇଜିମନ୍‌ ଆରି ଦୁଦ୍‌ କୁଆଇତେରଇବା ମାଆମନର୍‌ କେତେକ୍‌ ଦୁକର୍‌ ଦିନ୍‌ ଅଇସି । ଏ ଦେସର୍‌ ଲକ୍‌ମନ୍‍କେ ଅପର୍‌ବଲ୍‌ ଦୁକ୍‌ ଆଇସି ଆରି ସେମନ୍‌ ଡଣ୍ଡ୍‌ ପାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","କେତେ ଲକ୍‌କେ କାଣ୍ଡାର୍‌ଦାର୍‌ ସଙ୍ଗ୍‌ ମରାଇବାଇ ଆରି କେତେ ଲକ୍‌ମନ୍‌କେ ବନ୍ଦିକରି ବିନ୍‌ବିନ୍‌ ଦେସେ ଦାରିଜିବାଇ । ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ ବେଲା ନ ସାର୍‌ବାଜାକ ଜିରୁସାଲାମ୍‌ ବିନାସ୍‌ କର୍‌ବାକେ ଚାଡିଦେବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ବାଦ୍‌ଲେ, ବେଲ୍‌ଟାନେ, ଜନ୍‌ଟାନେ ତାରାମନର୍‌ଟାନେ କେବେ ନ ଡିସ୍‌ବା ଚିନ୍‌ମନ୍‌ ଡିସ୍‌ସି । ଦୁନିଆର୍‌ ସବୁ ଦେସର୍‌ ଲକ୍‌, ବେସି ଦୁକ୍‌ କସ୍‌ଟ ପାଇବାଇ । ଜେଡେବେଲା ସମ୍‌ଦୁରର୍‌ ବଡ୍‌ ଲଅଡି ଗରଜ୍‌ଲେ ଲକ୍‌ମନ୍‌ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ କାଇଟା ନାଇ ବଲି ବାୟାବିକଲ୍‌ ଅଇଜିବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ଆରି ଲକ୍‌ମନ୍‌ ଦୁନିଆଇ ଆଇବା ସବୁ ଗଟ୍‍ନା ଦେକିକରି ‘କାଇକେ ଏନ୍ତି ଅଇଲାନି ?’ ବଲି ଡରିକରି କେତେ ଲକ୍‌ ମୁର୍‌ଚା ଅଇଜିବାଇ । କାଇକେ ବଇଲେ ଆକାସେ ରଇଲା ସବୁ ବିସଇ ପର୍‌ମେସର ଚୁଲ୍‌ବୁଲାଇ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ସେବେଲାଇ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସର୍‌ ତେଇଅନି ଆସିରଇବା ନର୍‌ପିଲା ମୁଇ, ବେସି ବପୁସଙ୍ଗ୍‌ ଆରି ଡାକ୍‌ପୁଟାଅଇକରି ବାଦ୍‌ଲେ ଆଇବାଟା ଦେକ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ମାତର୍‌ ଏ ସବୁ ଗଟ୍‍ନା ଆରାମ୍‌ ଅଇଲେ ତମେ ଡାଟ୍‌ସଙ୍ଗ୍‍ ଟିଆଅଇ ଉପ୍‌ରେ ଦେକା । କାଇକେ ବଇଲେ ତମର୍‌ ରକିଆ ପାଇବା ଦିନ୍‌ ଲଗେ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ଆରି ଜିସୁ ସେମନ୍‌କେ ଗଟେକ୍‌ ଉଦାଅରନ୍‌ କଇଲା, “ଡୁମ୍‌ରି ଗଚ୍‌ ଆରି ବିନ୍‌ ସବୁ ଗଚର୍‌ କାତା ଚିନ୍ତା କରା । ");
INSERT INTO dso_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ଜେଡେବେଲେ ତାର୍‌ କେନ୍ଦିଅନି ପତର୍‌ ପାଲୁଆନି କର୍‌ସି, ଆରି କାଁଚାପତ୍‌ରିଆ ଡିସ୍‌ଲେ କାରାଦିନ୍‌ କେଟ୍‌ଲା ବଲି ତମେ ଜାନ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ସେନ୍ତାରିସେ ଏ ସବୁ ବିସଇ ଅଇବାଟା ଦେକ୍‌ଲେ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ କେଟି ଆଇଲା ବଲି ଜାନ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି । ମନେ ରକା, ଏବେ ଜିବନ୍‌ ରଇବା ସବୁ ଲକ୍‌ମନର୍‌ ମରନ୍‌ ଅଇବା ଆଗ୍‌ତୁ ଏ ସବୁ ଗଟ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ସରଗ୍‌ ଆରି ମଚ୍‌ପୁର୍‌ ନସି ଜାଇସି, ମାତର୍‌ ମର୍‌ ବାକିଅ କେବେ ନ ନସେ ।” ");
INSERT INTO dso_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ମାତର୍‌ ତମେ ନିଜର୍‌ ନିଜର୍‌ ବିସଇ ନେଇକରି ଜାଗ୍‌ରତ୍‌ ରୁଆ । ତମର୍‌ ମନ୍‌ ସବୁବେଲାଇ ବଜିବାତ୍‌ କରି ମଦ୍‌ ପେଣ୍ଡମ୍‌ କାଇବା ବିସଇ ଆରି କେନ୍ତାର୍‌ ଜିଇବାର୍‌ ଅଇସି କେନ୍ତାର୍‌ ନାଇ ବଲି ଚିନ୍ତାକରି ରଇଲାବେଲେ, ସେ ଦିନ୍‌ ଅଟାତ୍‌ ପାନ୍ଦ୍‌ ପାରା ଆସି ଲାଗିଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ସେନ୍ତାରିସେ ଏ ଦୁନିଆର୍‌ ସବୁ ଲକ୍‌କେ ସେଟା ଗଟ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ସେ ଦିନ୍‌ମନ୍‌କେ ଗଟ୍‌ବା ସବୁ ବିସଇ ଦେଇ, କାଇ ବିପଦ୍‌ ନ ଅଇ ଜିବାକେ ଆରି ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ନର୍‌ପିଲା ମର୍‌ ମୁଆଟେ ଟିଆ ଅଇବାକେ, ପାର୍‌ତନା କରି ଜାଗରତ୍‌ ଅଇରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ଜିସୁ ସେ ଦିନ୍‌ମନ୍‌କେ ମନ୍ଦିରେ ଜାଇ ନିମାନ୍‌ କାତା ସିକାଇ ଦେଇତେ ରଇଲା । ଆରି ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ସବୁ ରାତି ବାରିଜାଇ ଜିତ୍‌ ନାଉଁର୍‌ ଡଙ୍ଗ୍‌ରେ ବିତାଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ବେସି ଲକ୍‌ ଜିସୁର୍‌ କାତା ସୁନ୍‌ବାକେ ସବୁ ଦିନ୍‌ ସାକାଲେ ମନ୍ଦିରେ ଜାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","କମିର୍‌ ନ ପାକାଇ ରୁଟି ତିଆର୍‌ କର୍‌ବା ପରବ୍‌ ଜାକେକି ନିସ୍‌ତାର୍‌ ପରବ୍‌ ବଲି ମିସା କଇବାଇ, ସେ ପରବ୍‌ ଲଗାଲଗି କେଟି ଆଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ଆରି ମୁକିଅ ପୁଜାରିମନ୍‌, ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ଲକ୍‌ମନ୍‌କେ ଡର୍‌ତେ ରଇଲାଇ । ଜିସୁକେ କେନ୍ତି ଲୁଚ୍‌ତେ ମରାଉଁ ? ବଲି ବାଟ୍‌ କଜ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ଆରି ଜିସୁର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ନାଉଁର୍‌ ଗଟେକ୍‌ ସିସ୍‌ ରଇଲା । ସେବେଲାଇ ତାର୍‌ ମନ୍‌ ବିତ୍‌ରେ ସଇତାନ୍‌ ପୁରିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ଆରି ସେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ମନ୍ଦିର୍‌ ଜାଗି ରଇବା ସେନାପତିମନର୍‌ ଲଗେ, କେନ୍ତିକରି ଜିସୁକେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲା ପାରା କରି, ତାକେ ଦାରାଇଦେବି ବଲି ସେମନର୍‌ ସଙ୍ଗ୍‌ କାତାବାର୍‌ତା ଅଇବାର୍‌ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ସେଟାର୍‌ପାଇ ସେ ଲକ୍‌ମନ୍‌ ବେସି ସାର୍‌ଦା ଅଇକରି ତାକେ ଡାବୁ ଦେବାକେ ରାଜି ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ଜିଉଦା ମିସା ରାଜି ଅଇଲା ଆରି ଲକ୍‌ମନର୍‌ ନ ଜାନ୍‌ତେ ଜିସୁକେ ଦାରାଇଦେବାକେ ସୁଜଗ୍‌ କଜ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ତାର୍‌ପଚେ ନିସ୍‌ତାର୍‌ ପରବର୍‍ ବଜି କରି ମେଣ୍ଡାପିଲା ମାର୍‌ବା ଦିନ୍‌ ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ଜିସୁ, ପିତର୍‌ ଆରି ଜଅନ୍‌କେ ଏ କାତା କଇ ପାଟାଇଲା । “ଜା ଆରି ଆମର୍‌ପାଇ ନିସ୍‌ତାର୍‌ ପରବର୍‌ ବଜି କାଇବାକେ ଟିକ୍ କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ସେମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଆମେ କନ୍‌ ଜାଗାଇ ବଜି ତିଆର୍‌କର୍‌ବୁ ବଲି ତମେ ମନ୍‌ କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ଜିସୁ ସେମନ୍‌କେ କଇଲା, ଦେକା, ତମେ ଗଡ୍‌ ବିତ୍‌ରେ ପୁର୍‌ବା ବେଲେ ଗଟେକ୍‌ ଆଣ୍ଡିତେଇ ପାନିନେଇ ଜିବା ଲକ୍‌କେ ବେଟ୍‍ପାଇସା । ସେ ଜନ୍‌ ଗରେ ପୁର୍‌ସି, ତାର୍‌ ପଚ୍‌ପଚ୍‌ ଜାଇ ସେ ଗରର୍‌ ସାଉକାର୍‌କେ କୁଆ, ");
INSERT INTO dso_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","“ଆମର୍‌ ଗୁରୁ ତମ୍‌କେ ଏ କବର୍‌ କଇ ପାଟାଇଆଚେ, ମୁଇ ଆରି ମର୍‌ ସିସ୍‌ମନ୍‌ କନ୍‌ ବାକ୍‌ରାଇ ରକିଆ ପାଇବା ପରବର୍‌ ବଜି ମାନ୍‌ବୁ ? ");
INSERT INTO dso_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ତାର୍‌ପଚେ ସେ ଲକ୍‌ ତମ୍‌କେ ଗର୍‌ ଉପ୍‌ରେ ରଇବା ମଅଲା ତିଆର୍‌ ଅଇରଇଲା ଗଟେକ୍‌ ବଡ୍‌ ବାକ୍‌ରା ଦେକାଇ ଦେଇସି । ତେଇ ତମେ କାଦି ତିଆର୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ସେମନ୍‌ ଜାଇକରି ଜିସୁ ସେମନ୍‌କେ ଜେନ୍ତି କଇରଇଲା ସେନ୍ତିସେ ଦେକ୍‌ଲାଇ । ଆରି ନିସ୍‌ତାର୍‌ ପରବର୍‌ ବଜି ତିଆର୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ସମାନ୍‌ ବେଲା କେଟ୍‌ଲାକେ ଜିସୁ ପେରିତ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ କାଇବାକେ ମିସ୍‌ତେ ବସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ସେବେଲା ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ଦୁକ୍‌ କସ୍‌ଟ ପାଇବା ଆଗ୍‌ତୁ ନିସ୍‌ତାର୍‌ ପରବ୍‌ ତମର୍‌ସଙ୍ଗ୍‌ ମିସ୍‌ତେ କର୍‌ବାକେ ବେସି ମନ୍‌ କରିରଇଲି । ");
INSERT INTO dso_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ମୁଇ ତମ୍‌କେ କଇଲିନି, ପର୍‌ମେସରର୍‌ ରାଇଜେ ଏଟା ପୁରାପୁରୁନ୍‌ ନ ଅଇବାଜାକ, କେବେ ମିସା ଏଟା ନ କାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ଆରି ସେ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ଦାରି ପର୍‌ମେସର୍‌କେ ଜୁଆର୍‌ କରି କଇଲା, “ଏଟା ନେଇ ତମର୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ବାଟା କରା । ");
INSERT INTO dso_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ମୁଇ ତମ୍‌କେ କଇଲିନି ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ନ ଆଇବା ଜାକ, ଏ ରସ୍‌ କେବେ ମିସା ନ କାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ଆରି ରୁଟି ଦାରିକରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‍ଦେଇ ବାଙ୍ଗାଇ ସେମନ୍‌କେ ଦେଇକରି କଇଲା, “ଏଟା ମର୍‌ ଗାଗଡ୍‌, ଜନ୍‌ଟା ତମର୍‌ ପାଇ ଦିଆଅଇଲା ଆଚେ । ମକେ ଏତାଇବା ପାଇ ଏଟା କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ସେନ୍ତାରିସେ କାଇଲା ପଚେ ସେ ମୁତାଇ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ଦାରି କଇଲା, “ଏ ମୁତା ମର୍‌ ବନିତେଇ, ପର୍‌ମେସର୍‌ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ କଲା ନୁଆ ରାଜିନାମା । ଏଟା ତମର୍‌ପାଇ ଜର୍‌ଲା ମର୍‌ ବନି ।” ");
INSERT INTO dso_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ମାତର୍‌ ଦେକା ଇତି ମର୍‌ସଙ୍ଗ୍‍ ବସି କାଇବା ଗଟେକ୍‌ ଲକ୍‌ସେ ବିରଦି ଲକ୍‌ମନର୍‌ ଆତେ ମକେ ଦାରାଇ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ପର୍‌ମେସରର୍‌ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ, ସେ ଜେନ୍ତି ଜଜ୍‌ନା କଲାଆଚେ, ସେନ୍ତାରିସେ ମର୍‌ବାକେ ଅଇସି । ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ ମକେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା ବିରଦିମନର୍‌ ଆତେ ଦାରାଇ ଦେଇସି, ତାକେ ବେସି ଡଣ୍ଡ୍‌ ମିଲ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ସେବେଲାଇ ସିସ୍‌ମନ୍‌ ସେମନର୍‌ ବିତ୍‌ରେ କାତା ଅଇଲାଇ, “ଏନ୍ତି ବଇଲେ ଆମର୍‌ ବିତ୍‌ରେ କେ ଜିସୁକେ ସେନ୍ତି କର୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ତାର୍‌ ପଚେ ସେମନର୍‌ ବିତ୍‌ରେଅନି କେ ବଡ୍‌ ବଲି ଦଦାପେଲା ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏ ଦୁନିଆର୍‌ ରାଜାମନ୍‌ ସେମନର୍‌ ଲକ୍‌ମନ୍‌କେ ନିଜର୍‌ ଅଦିକାର୍‌ ଦେକାଇ ସାସନ୍‌ କର୍‌ବାଇ । ଆରି ସେମନ୍‌, ଆମେ ଲକ୍‌ମନ୍‌କେ ଦରମ୍‌ କର୍‌ବା ଲକ୍‌ ବଲି ଡାକ୍‌ପୁଟା ଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ମାତର୍‌ ତମର୍‌ ବିତ୍‌ରେ ଏନ୍ତି ନ ଉଆ । କେ ବଡ୍‌ ସେ ସାନ୍‌ ଅ । ଆରି କେ ନେତା ରଇସି ସେ ସବୁଲକର୍‌ ସେବା କର୍‌ବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ଏ ଦୁନିଆର୍‌ ଇସାବେ, ବସିକରି କାଇବା ଲକ୍‌ ବଡ୍‌ କି, ବାଟାକରି ଦେବା ଲକ୍‌ ବଡ୍‌ ? ବସିକରି କାଇବା ଲକ୍‌ ସେ ବଡ୍‌ ଅଇସି । ମାତର୍‌ ମୁଇ ସେନ୍ତି ନଇ । ମୁଇ ତମର୍‌ ବିତ୍‌ରେ ବାଟାକରି ଦେବା ଲକର୍‌ ପାରା । ");
INSERT INTO dso_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ତମେ ମର୍‌ ସବୁ ପରିକାଟାନେ ମର୍‌ସଙ୍ଗ୍‌ ରଇ ଆଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ମର୍‌ ବାବା ପର୍‌ମେସର୍‌ ଜେନ୍ତି ସାସନ୍‌ କର୍‌ବାକେ ମକେ ତାର୍‌ ରାଇଜର୍‌ ଅଦିକାର୍‌ ଦେଲା ଆଚେ, ସେନ୍ତି ମୁଇ ମିସା ତମ୍‌କେ ଅଦିକାର୍‌ ଦେବି । ");
INSERT INTO dso_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ଆରି ତମେ ମର୍‌ ରାଇଜେ ମର୍‌ସଙ୍ଗ୍‌ ବସି କାଆପିଆ କର୍‌ସା । ରାଜ୍‌ଗାଦି ବସି ଇସ୍‌ରାଏଲର୍‌ ବାରଟା ଜାତିର୍‌ ଲକ୍‌ମନ୍‌କେ ସାସନ୍‌ କର୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ଏ ସିମନ୍‌, ସିମନ୍‌ ! ସୁନ୍‌ ! ଚାସି ଜେନ୍ତି ଦାନ୍‌ ଉଡାଲିକରି ପଟ୍‌ ବିନେ କର୍‌ସି, ସେନ୍ତାରି ସଇତାନ୍‍ ତମ୍‌କେ ତେରେପେତେ କର୍‌ବାକେ ଆଦେସ୍‌ ପାଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ମାତର୍‌ ତର୍‌ ବିସ୍‌ବାସ୍‌ ଉନା ନ ଅ ବଲି ମୁଇ ପାର୍‌ତନା କଲିଆଚି । ସେ ପରିକାଇ, ବିସ୍‍ବାସେ ଡାଟ୍‌ଅଇ, ଜିତି ଆଇଲେ ତର୍‌ ବାଇମନ୍‌କେ ମିସା ସେନ୍ତି ଡାଟ୍‌ କରାଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ସେବେଲାଇ ସିମନ୍‌ ଜିସୁକେ କଇଲା, “ଏ ମାପ୍‌ରୁ ମୁଇ ତର୍‌ସଙ୍ଗ୍‌ ବନ୍ଦି ଗରେ ଜିବାକେ ଆରି ମର୍‌ବାକେ ମିସା ରାଜି ଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ତାର୍‌ ପଚେ ଜିସୁ କଇଲା, “ଏ ପିତର୍‌ ମୁଇ ତକେ କଇଲିନି, ତୁଇ ଏବେ ଏନ୍ତି କଇଲୁସ୍‌ନି, ମାତର୍‌ ଆଜି ରାତି କୁକ୍‌ଡା ନ ଡାକ୍‌ବା ଆଗ୍‌ତୁ ମକେ ତିନ୍‌ତର୍‌ ନାଜାନି ବଲି କଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା । “ମୁଇ ତମ୍‌କେ ପାଟାଇଲାବେଲେ ବେସ୍‌ନି, ମୁନା ଆରି ପାଣ୍ଡଇ ନ ନେବାକେ କଇରଇଲି । ସେବେଲାଇ ତମ୍‌କେ କାଇ ଅବାବ୍‌ ଅଇଲା କି ?” “ନାଇ, କାଇଟା ମିସା ଅବାବ୍‌ ଅଏ ନାଇ ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ଆରି ସେ କଇଲା, “ମାତର୍‌ ଏବେ ତମ୍‌କେ କଇଲିନି, ବେସ୍‌ନି କି ମୁନା ରଇଲେ ନିଆ । ଆରି ଜାକେ କାଣ୍ଡା ନାଇ, ସେ ପିନ୍ଦ୍‌ବାଟା ବିକି କାଣ୍ଡା ଗେନ । ");
INSERT INTO dso_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ମୁଇ ତମ୍‌କେ କାଇକେ କଇଲିନି ‘ସେ ଅପରାଦିମନର୍‌ ସଙ୍ଗ୍‌ ସମାନ୍‌ ଦସା ପାଇଲା’ ବଲି ସାସ୍‌ତରେ ଲେକା ଅଇଲା କାତା ସିଦ୍‌ ଅଇବାକେ ଗାଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ସିମନ୍‌ ଜିସୁକେ କଇଲା, “ଏ ମାପ୍‌ରୁ, ଦେକା ଆମର୍‌ ବିତ୍‌ରେ ଜଡେକ୍‌ କାଣ୍ଡା ଆଚେ ।” ଜିସୁ କଇଲା, “ସେତ୍‌କି ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ତେଇଅନି ଜିସୁ ଗଡ୍‌ ଚାଡି ଆଗ୍‌ତୁର୍‌ ଅବିଆସ୍‌ ଇସାବେ ଜିତ୍‌ନାଉଁର୍‌ ଡଙ୍ଗ୍‌ରେ ପାର୍‌ତନା କର୍‌ବାକେ ଗାଲା । ସିସ୍‌ମନ୍‌ ମିସା ତାର୍‌ ସଙ୍ଗ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ଆରି ସେ ଜାଗାଇ କେଟିକରି ସିସ୍‌ମନ୍‌କେ କଇଲା, “ତମେ ପରିକାର୍‌ ପାନ୍ଦେ ନ ଲାଗାଇ ଅଇବାକେ ପାର୍‌ତନା କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ତାର୍‌ ପଚେ ଜିସୁ ତାକର୍‌ତେଇଅନି କଣ୍ଡେକ୍‌ ଦୁର୍‌ ଜାଇ ମାଣ୍ଡିକୁଟା ଦେଇକରି ପାର୍‌ତନା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ଏ ବାବା, ତୁଇ ମନ୍‌କଲେ ଏ କସ୍‌ଟର୍‌ ମୁତା ମର୍‌ତେଇଅନି ଦୁରିକେ ନେ । ମାତର୍‌ ମୁଇ ମନ୍‌ କଲା ଇସାବେ ନାଇ, ତର୍‌ ମନ୍‌କଲା ଇସାବେ ସିଦ୍‌ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ସେଡ୍‌କିବେଲେ ଏଦେ ଦେକା ! ପର୍‌ମେସରର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ଆସି ଜିସୁକେ ଦେକାଇଅଇଲା ଆରି ଡାଟ୍‌ସଙ୍ଗ୍‌ ରଇବାକେ ବପୁଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ମାତର୍‌ ଜିସୁ ଅଦିକ୍‌ ବିକଲ୍‌ ଅଇ, ମନ୍‌ଦିଆନ୍‌ ଦେଇ ପାର୍‌ତନା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ତାର୍‌ ଗାଗ୍‌ଡର୍‌ ଜାଲ୍‌ ପାନି, ବନିପାରା ଜର୍‌ଜର୍‌ ଅଇ ବୁଏଁ ତିପିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଆରି ଜିସୁ ପାର୍‌ତନା କରିସାରାଇ ସିସ୍‌ମନର୍‌ ଲଗେ ଗାଲା । ସେମନ୍‌ ସବୁ ଲକ୍‌ ଦୁକ୍‌ଅଇକରି ତାକିଜାଇ ସଇରଇଲାଟା ସେ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ତେଇ ସେମନ୍‌କେ କଇଲା, “ତମେ କାଇକେ ସଇଦେଇ ଆଚାସ୍‌ ? ଉଟା ପରିକାର୍‌ ପାନ୍ଦେ ନ ଲାଗାଇ ଅଇବାକେ ପାର୍‌ତନା କରା ।” ");
INSERT INTO dso_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ଜେଡେବଲ୍‌ ଜିସୁ ଏ କାତା କଇତେରଇଲା ଗାଦି ଲକ୍‌ମନ୍‌ ତେଇ ଆଇଲାଇ । ଜିସୁର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଜିଉଦା ନାଉଁର୍‌ ସିସ୍‌, ସେମନର୍‌ ଆଗ୍‌ତୁ ଅଇ ସେମନ୍‌କେ ଡାକିଆନ୍‌ଲା, । ଆରି ଜିସୁକେ ଚୁମିକରି ସେମନ୍‌କେ ଚିନାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ଜିସୁ ଜିଉଦାକେ ପାଚାର୍‌ଲା, “ଏ ଜିଉଦା ପର୍‌ମେସର୍‌ତେଇ ଅନି ଆଇଲା ନର୍‌ପିଲା ମକେ, ତୁଇ ବିରଦି ଲକ୍‌ମନ୍‌କେ ଚୁମିକରି ଦାରାଇଦେଲୁସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ସେ ବିରଦି ଲକ୍‌ମନ୍‌ ଜିସୁକେ ବନ୍ଦିକରି ଦାରିଜିବାଇ ବଲି ସିସ୍‌ମନ୍‌ ଜାନ୍‌ଲାଇ । ସେବେଲାଇ ସିସ୍‌ମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏ ମାପ୍‌ରୁ, ଆମର୍‌ କାଣ୍ଡା ବେଟ୍‌ବୁ କି ?” ");
INSERT INTO dso_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌, ବଡ୍‌ ପୁଜାରିର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାର୍‌ ଉଜା କାନ୍‌ ଚିଡ୍‌ତେ କାଟିପାକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ଏଟା ଦେକି ଜିସୁ କଇଲା, “ନିଚୁ” । ସେ ଚିଡ୍‌ଲା କାନ୍‌ ଚିଇକରି ନିକ କଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ଜିସୁ ତାକେ ବନ୍ଦି କର୍‌ବାକେ ଆଇଲା ମୁକିଅ ପୁଜାରିମନ୍‍କେ, ମନ୍ଦିର୍‌ ଜାଗି ରଇବା ସେନାପତିମନ୍‌କେ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌କେ କଇଲା, “ମୁଇ କାଇ ଡାକୁ କି ? ମକେ ଦାର୍‌ବାକେ ବଡ୍‌ ବଡ୍‌ ଟେଙ୍ଗ୍‌ ଆରି କାତିକାଣ୍ଡା ଦାରି ଆସି ଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ସବୁ ଦିନେତା ମୁଇ ମନ୍ଦିରେ ତମର୍‌ ସଙ୍ଗ୍‌ ରଇଲି, ମାତର୍‌ ତମେ ମକେ ବାନ୍ଦାସ୍‌ ନାଇ । ଏବେ ବେଲା କେଟ୍‌ଲା ଆଚେ । ମକେ କାଇଟାମିସା କର୍‌ବାକେ ପର୍‌ମେସର୍‌ ସଇତାନ୍‌କେ ଅନୁମତି ଦେଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ତାର୍‌ ପଚେ ସେମନ୍‌ ଜିସୁକେ ବାନ୍ଦିକରି ବଡ୍‌ ପୁଜାରିର୍‌ ଗରେ ଦାରିଗାଲାଇ । ପିତର୍‌ ଦୁରିକେ ରଇ ସେମନର୍‌ ପଚେପଚେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ସନିଅମନ୍‌ ଜଇଲାଗାଇ ଚାରିବେଡ୍‌ତି ବସ୍‌ଲାଇ । ପିତର୍‌ ମିସା ସେମନର୍‌ ସଙ୍ଗ୍‌ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡି ପିତର୍‌କେ ଜଇପାଲି ବସ୍‌ଲାଟା ନିକକରି ଦେକି କଇଲା, “ଏ ଲକ୍‌ ମିସା ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ରଇଲା !” ");
INSERT INTO dso_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ମାତର୍‌ ପିତର୍‌ ରାଜି ନ ଅଇ କଇଲା, “ଏ ଗତିଦାଙ୍ଗ୍‌ଡି, ତାକେ ମୁଇ ମୁଲ୍‌କେ ନାଜାନି ।” ");
INSERT INTO dso_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ଚନେକ୍‌ ରଇଲା ପଚେ ଆରି ଗଟେକ୍‌ ଲକ୍‌ ପିତର୍‌କେ ଦେକି କଇଲା, “ତୁଇ ମିସା ତାର୍‌ ସଙ୍ଗ୍‌ ରଇଲୁସ୍‌ ।” ମାତର୍‌ ପିତର୍‌ ତାକେ କଇଲା, “ମୁଇ ନଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ଗଟେକ୍‌ ଗଁଟା ଗାଲାପଚେ ଆରି ଗଟେକ୍‌ ଲକ୍‌ ପିତର୍‌କେ ଦେକି କଇଲା, “ଏ ଲକ୍‌ମିସା ନିଜେ ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ରଇଲା । ଆକେ ମୁଇ ନିକକରି ଜାନି । କାଇକେ ବଇଲେ ସେ ଗଟେକ୍‌ ଗାଲିଲିର୍‌ ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ଏଟା ସୁନି ପିତର୍‌ ସେ ଲକ୍‌କେ କଇଲା, “ଏ ବାଇ ତୁଇ କାଇଟା କଇଲୁସ୍‌ନି ? ମୁଇ ବିଲ୍‌କୁଲ୍‌ ନାଜାନି ।” ସେ କାତା ପିତର୍‌ କଇଲା ଦାପ୍‌ରେ, କୁକ୍‌ଡା ଡାକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ସେବେଲେ ଜିସୁମାପ୍‌ରୁ ପିତର୍‌କେ ପାସ୍‌ଲି ନିମାନ୍‌ କରି ଦେକ୍‌ଲା । ଜିସୁ ଆଗ୍‌ତୁ କଇଲା କାତା ସେ ଏତାଇଲା । ସେ ତାକେ କଇରଇଲା ତୁଇ ମକେ ଆଜି କୁକ୍‌ଡା ଡାକ୍‌ବା ଆଗ୍‌ତୁ ତିନ୍‌ତର୍‌ ନାଜାନି, ବଲି କଇସୁ । ");
INSERT INTO dso_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ସେଟାର୍‌ପାଇ ପିତର୍‌ ସେଟା ଏତାଇ, ଦୁକ୍‌ ଅଇ ଡାଣ୍ଡେଅନି ବିନେ ଜାଇ ବେସି କାନ୍ଦ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ଜିସୁକେ ଦାରିକରି ସଙ୍ଗ‍ଇର‍ଇଲା ଲକ୍‌ମନ୍‌ ତାକେ ମାରିମାରି କିଜାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ଆରି ତାର୍‌ ଆଁକି ବାନ୍ଦିକରି ତାକେ ପାଚାର୍‌ଲାଇ, “ତକେ କେ ମାର୍‌ଲା, କଅ ?” ");
INSERT INTO dso_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ଆରି କେତେଟା କାତା କଇ ତାକେ ନିନ୍ଦା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଜୁଲ୍‌ପୁଲ୍‌ ଉଜଲ୍‌ ବେଲାଇ, ପାର୍‌ଚିନ୍‌ମନ୍‌, ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ସାସ୍‌ତର୍‌ ସିକାଇଦେବା ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ଟାନେ ରୁଣ୍ଡ୍‌ଲାଇ । ଆରି ଜିସୁକେ ବିଚାର୍‌ କର୍‌ବା ବଡ୍‌ଟା ଜାଗାଇ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“ତୁଇ ସତଇସେ ପର୍‌ମେସର୍‌ ବାଚିପାଟାଇଲା କିରିସ୍‌ଟ କି ? ଆମ୍‌କେ କଅ ।” ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ କଇଲେ ମିସା ତମେ ବିସ୍‌ବାସ୍‌ ନ କରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ମୁଇ ତମ୍‌କେ ପାଚାର୍‌ଲେ ମିସା ନ କୁଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ମାତର୍‌ ଏବେ ଅନି, ପର୍‌ମେସରର୍‌ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ତାର୍‌ ଉଜାବାଟେ ବସିରଇବି ।” ");
INSERT INTO dso_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ସେ କାତା ସୁନି ଗୁଲାଇ ଲକ୍‌ମନ୍‌ ଆଉଲିଅଇ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏନ୍ତି ବଇଲେ ତୁଇକାଇ ପର୍‌ମେସରର୍‌ ପିଲା କି ?” ଜିସୁ ସେମନ୍‌କେ କଇଲା “ମୁଇସେ ବଲି ତମେ କଇଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ଆରି ସେମନ୍‌ କଇଲାଇ, “ଆମ୍‌କେ ଆରି କାଇ ସାକି ଦର୍‌କାର୍‌ ତା ? ଆମେ ନିଜେ ତାର୍‌ ଟଣ୍ଡେଅନି ସୁନ୍‌ଲୁ ଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ତାର୍‌ ପଚେ ବିଚାର୍‌ କର୍‌ବା ବଡ୍‌ ସବାର୍‌ ଜାଗାଇ ବସିରଇଲା ସବୁ ଲକ୍‌ମନ୍‌ ଉଟିକରି ଜିସୁକେ ପିଲାତର୍‌ ଲଗେ ଦାରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ସେ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ନିନ୍ଦା କରି ଏନ୍ତି କଇବାର୍‌ ବସ୍‌ଲାଇ, “ଏ ଲକ୍‌ ଆମର୍‌ ଲକ୍‌ମନ୍‌କେ ବୁଲ୍‌ ସିକିଆ ଦେଇତେ ରଇଲା ଆରି କାଇସର୍‌ ସମ୍‌ରାଟ୍‌କେ ସିସ୍‌ତୁ ଦିଆସ୍‌ ନାଇ ବଲି ସିକାଇଲା ବେଲେ ତାକେ ଦାର୍‌ଲୁ । ଆରି ସେ ନିଜ୍‌କେ ମୁଇ ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା ରାଜା କିରିସ୍‌ଟ ବଲି କଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ସେଟାର୍‌ ପାଇ ପିଲାତ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲା, “ତୁଇ କାଇ ଜିଉଦି ଲକ୍‌ମନର୍‌ ରାଜା କି ?” ଜିସୁ ତାକେ କଇଲା, “ତମେତା କଇଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ତାର୍‌ ପଚେ ପିଲାତ୍‌ ମୁକିଅ ପୁଜାରିମନ୍‍କେ ଆରି ତେଇ ରଇଲା ସବୁ ଲକ୍‌ମନ୍‌କେ କଇଲା, “ମୁଇ ଏ ଲକ୍‌ ଦସି ବଲି କାଇ ବୁଲ୍‌ ଦେକି ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ମାତର୍‌ ସେମନ୍‌ ତର୍‌କେତର୍‌ ଆଉଲିଅଇ କଇଲାଇ, “ତାର୍‌ ସିକିଆର୍‌ ଲାଗି ସେ ଜିଉଦାର୍‌ ସବୁବାଟର୍‌ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ କଲି ଲାଗାଇଲାନି । ସେଟା, ସେ ଗାଲିଲିତେଇ ଆରାମ୍‌ କରି, ଏବେ ଇତି ଜାକ ଆଇଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ଏ କାତା ସୁନି ପିଲାତ୍‌ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ଏଟା ଗଟେକ୍‌ ଗାଲିଲି ଦେସର୍‌ ଲକ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ପିଲାତ୍‌ ଜିସୁକେ ଗାଲିଲି ଦେସର୍‌ ଲକ୍‌ ବଲି ଜାନି, ତାକେ ଗାଲିଲି ଦେସ୍‌ ସାସନ୍‌ କର୍‌ବା ଏରଦର୍‌ଲଗେ ପାଟାଇ ଦେଲା । କାଇକେ ବଇଲେ, ସେ ବେଲେ ଏରଦ୍‌ ମିସା ଜିରୁସାଲମେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ଏରଦ୍‌ ଜିସୁକେ ଦେକି କରି ବେସି ସାର୍‌ଦା ଅଇଲା । କାଇକେ ବଇଲେ ଜିସୁର୍‌ ବିସଇ ଆଗ୍‌ତୁ ସୁନି ରଇଲା ଆରି ତାର୍‌ ମୁଆଟେ କାବା ଅଇଜିବା କାମ୍‌ ଦେକ୍‌ବାକେ ମନ୍‍ କର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ସେଟାର୍‌ ପାଇ ଏରଦ୍‌ ତାକେ କାଇ କାଇ ବିସ‍ଇ ପାଚାର୍‌ବାର୍‌ ଦାର୍‌ଲା । ମାତର୍‌ ଜିସୁ ତାକେ କାଇବଲି ମିସା କଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ସେଡିକି ବେଲେ ତେଇ ଟିଆଅଇରଇଲା ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ନିୟମ୍‌ ସିକାଉମନ୍‌ ସବୁ ମିସି କରି ଜିସୁର୍‌ ବିରୁଦେ ଆଉଲିଅଇ କଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ଏରଦ୍‌ ଆରି ତାର୍‌ ସନିଅମନ୍‌ ଜିସୁକେ କିଜାଇଲାଇ ଆରି ନିନ୍ଦା କଲାଇ । ଜିସୁକେ ରାଜାମନ୍‌ ପିନ୍ଦ୍‌ବା ନିମାନ୍‌ ପଚିଆ ପିନ୍ଦାଇ ପିଲାତ୍‌ଟାନେ ପାଟାଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ସେ ଦିନେଅନି ପିଲାତ୍‌ ଆରି ଏରଦ୍‌ ମଇତର୍‌ ଅଇଲାଇ । ତାର୍‌ ଆଗ୍‌ତୁ ସେମନ୍‌ ଦୁଇ ଲକ୍‌ ସତ୍‌ରୁ ଅଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ତାର୍‌ପଚେ ପିଲାତ୍‌ ମୁକିଅ ପୁଜାରିମନ୍‌କେ, ନେତାମନ୍‌କେ ଆରି ସବୁ ଲକ୍‌ମନ୍‌କେ ଗଟେକ୍‌ଟାନେ ରୁଣ୍ଡାଇକରି ସେମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ଏ ଲକ୍‌ ଲକ୍‌ମନ୍‌କେ ସର୍‌କାରର୍‌ ବିରୁଦେ ବୁଲ୍‌ ସିକିଆ ଦେଲାନି ବଲି ମର୍‌ ଲଗେ ଆନିଆଚାସ୍‌ । ଆରି ଦେକା ମୁଇ ତମର୍‌ ମୁଆଟେ ତାକେ ପରିକା କଲି, ତାର୍‌ ବିରଦେ ତମେ ସବୁଲକ୍‌ ନିନ୍ଦାକଲାଟା ମିଲେନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ଏରଦ୍‌ ମିସା ତାର୍‌ଟାନେ କାଇ ବୁଲ୍‌କଲାଟା ନ ଦେକି ଆମ୍‌କେ ବାଉଡାଇଦେଲା ଆଚେ । ଏ ଲକ୍‌ ମରନ୍‌ ଡଣ୍ଡ୍‌ ପାଇବାପାରା ବୁଲ୍‌ କାମ୍‌ କରେ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ସେଟାର୍‌ପାଇ ମୁଇ ଆକେ କର୍‌ଡା ମାଡ୍‌ ମାରିକରି ଚାଡିଦେବି । ");
INSERT INTO dso_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ଆରି ଦେକା ସବୁ ବର୍‌ସେ ରକିଆ ପାଇବା ପରବ୍‌ ବେଲାଇ ଜିଉଦି ଜାତିକେ ସନ୍‌ମାନ୍‌ ଦେବାକେ ଗଟେକ୍‌ ବନ୍ଦିକେ ମୁକ୍‌ଲାଇ ଦେବା ନିୟମ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ମାତର୍‌ ସବୁଲକ୍‌ମନ୍‌ ଆଉଲିଅଇ କଇଲାଇ, “ଆକେ ମରାଆ ଆରି ଆମର୍‌ ପାଇ ବାର୍‌ବାକେ ଚାଡିଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ଏ ବାର୍‌ବା ବଲ୍‌ବା ଲକ୍‌, ସର୍‌କାରର୍‌ ବିରଦେ ବୁଲ୍‌ କରିରଇଲା ଆରି ଗଟେକ୍‌ ଲକ୍‌କେ ମାରି ରଇଲା । ସେଟାର୍‌ପାଇ ତାକେ ବନ୍ଦି କରିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ମାତର୍‌ ପିଲାତ୍‌ ଜିସୁକେ ଚାଡିଦେବାକେ ମନ୍‌କରି ତାର୍‌ ଲଗେ କାଇ ବୁଲ୍‌କଲାଟା ଡିସେନାଇ ବଲି ସେମନ୍‌କେ ତର୍‌କେ ତର୍‌ ବୁଜାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ମାତର୍‌ ଲକ୍‌ମନ୍‌ ବେସି ଆଉଲି ଅଇ, “ତାକେ କୁର୍‌ସେ ଚଗାଇ ମରାଆ ! ତାକେ କୁର୍‌ସେ ଚଗାଇ ମରାଆ !” ");
INSERT INTO dso_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ତାର୍‌ପଚେ ପିଲାତ୍‌ ସେମନ୍‌କେ ଆଗେ ଦୁଇତର୍‌ ପାଚାର୍‌ଲାଟା ଚାଡି ଆରିତରେକ୍‌ ସମାନ୍‌ଟାସେ କଇଲା, “କାଇକେ ? ସେ କାଇ ବୁଲ୍‌ କଲାଆଚେ ଜେ ? ତାର୍‌ଟାନେ କାଇମିସା ମରନ୍‌ ପାଇବା ଡଣ୍ଡ୍‌ ଏତ୍‌କି ଦସ୍‌ ମିଲେ ନାଇ । ଏନ୍ତି ବଇଲେ ମିସା ତାକେ କର୍‌ଡା ମାଡ୍‌ ମାରି ଚାଡି ଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ମାତର୍‌ ଲକ୍‌ମନ୍‌ ଆରି ବେସି ଆଉଲିଅଇ ତର୍‌କେ ତର୍‌ “ତାକେ କୁର୍‌ସେ ଚଗାଇ ମରାଆ !” ବଲି ବାଦିଅ କଲାଇ । ସାରାସାରି ପଚେ ସେମନ୍‌ ଆଉଲିଅଇଲାଟା ଜିତ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ତାର୍‌ ପଚେ ପିଲାତ୍‌ ଲକ୍‌ମନର୍‌ ଜାଇଟା କର୍‌ବାକେ ମନ୍‌ କଲାଇ, ସେ ଇସାବେ ଜିସୁକେ ମରନର୍‌ ଡଣ୍ଡ୍‌ ଦେବାକେ ରାଜି ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ପଚେ ପିଲାତ୍‌ ଲକ୍‌ମନର୍‌ କଇବା ଇସାବେ, ବାର୍‌ବା ନାଉଁର୍‌ ଲକ୍‌ ଜେ କି, ଆଗ୍‌ତୁ ଗଟେକ୍‌ ଲକ୍‌କେ ମରାଇରଇଲା ଆରି ସର୍‌କାରର୍‌ ବିରୁଦେ ବୁଲ୍‌କାମ୍‌ କରି ବନ୍ଦି ଅଇରଇଲା, ତାକେ ମୁକ୍‌ଲାଇଲା । ଜିସୁକେ ତାକର୍‌ ମନ୍‌କଲା ଇସାବେ ଡଣ୍ଡ୍‌ ଦେବାକେ ସର୍‌ପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ସନିଅମନ୍‌ ଜିସୁକେ ଦାରିଜିବା ବେଲେ କୁରିଣିୟ ସିମନ୍‌ ନାଉଁର୍‌ ଲକ୍‌କେ ବେଟ୍‍ପାଇଲାଇ । ଜେ କି ଗାଏଁଅନି ଜିରୁସାଲାମେ ଆଇତେରଇଲା । ତାକେ ଅଟ୍‌କାଇକରି ଜିସୁ ବଇଲା କୁର୍‌ସ ଲାଦିଦେଲାଇ ଆରି ତାର୍‌ ପଚେ ଜିବାକେ ବାଦିଅ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ଆରି ବେସି ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ପଚେ ପଚେ ଜାଇତେ ରଇଲାଇ । ତେଇ କେତେଟା ବୁକେ ପିଟିଅଇ କାନ୍ଦ୍‌ବା ମାଇଜିମନ୍‌ ମିସା ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ମାତର୍‌ ଜିସୁ ସେମନର୍‌ ବାଟେ ପାସ୍‌ଲିକରି କଇଲା, ଏ ଜିରୁସାଲମ୍‌ ଗଡର୍‌ ମାଇଜିମନ୍‌, ମର୍‌ପାଇ କାନ୍ଦା ନାଇ । ମାତର୍‌ ନିଜର୍‌ ପାଇ ଆରି ନିଜର୍‌ ପିଲାମନର୍‌ ପାଇ କାନ୍ଦା । ");
INSERT INTO dso_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","କାଇକେବଇଲେ ଦେକା “ଜନ୍‌ ମାଇଜି ବାଞ୍ଜି ଆରି କେବେ ମିସା ଗାଗ୍‌ଡେ ନ ଅଇକରି ଆଚତ୍‌, ଆରି ଜେ କି କେବେ ମିସା ଦୁଦ୍‌ କୁଆଏ ନାଇ, ସେମନ୍‌ କେଡେକ୍‌ ନିକ କରମର୍‌ ଲକ୍‌ !” ବଲି କଇବା ଦିନ୍‌ ଆଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ସେବେଲାଇ ଲକ୍‌ମନ୍‌ ଡଙ୍ଗର୍‌ମନ୍‌କେ କଇବାର୍‌ ଦାର୍‌ବାଇ, ଆମର୍‌ ଉପ୍‌ରେ ଅଦ୍‌ରି ଦିଆସ୍‌ । କୁପ୍‌ଲିମନ୍‌କେ କଇବାର୍‌ ଦାର୍‌ବାଇ, ଆମ୍‌କେ ତପିଦିଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","କାଇକେ ବଇଲେ ଗଚ୍‌ କାଁଚାପତ୍‌ରିଆ ରଇଲା ବେଲେ, ଜଦି ଏ ସବୁ ଗଟ୍‍ନା ଗଟ୍‌ଲାନି ବଇଲେ ସେଟା ସୁକିଗାଲେ ଆରି କାଇଟା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ଆରି ଦୁଇଟା ବଡ୍‌ ବୁଲ୍‌ କରିରଇବା ଲକ୍‌ମନ୍‌କେ ମିସା ମରାଇବାକେ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ଆରି ସେମନ୍‌ କପ୍‌ରି ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ କେଟିକରି ଜିସୁକେ ଆରି ଚର୍‌ମନ୍‌କେ, ତାର୍‌ ଡେବ୍‌ରି ବାଟେ ଗଟେକ୍‌ ଲକ୍‌କେ ଆରି ଉଜାବାଟେ ଗଟେକ୍‌ ଲକ୍‌କେ ଆତେ, ପାଦେ କୁଟିମାରି ଟେକିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ସେବେଲା ଜିସୁ କଇଲା, “ଏ ବାବା ଏମନ୍‌କେ କେମା କରିଦିଆସ୍‌, କାଇକେ ବଇଲେ ଏମନ୍‌ କାଇଟା କଲାଇନି ସେଟା ନାଜାନତ୍‌ ।” ସେମନ୍‌ ଜିସୁର୍‌ ପଚିଆ ନେଇ କାକେ ମିଲ୍‌ସି ବଲି କେଡ୍‌ ପୁଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ସବୁ ଲକ୍‌ମନ୍‌ ଟିଆଅଇ ଦେକ୍‌ବାବେଲେ ଜିଉଦି ନେତାମନ୍‌ ଜିସୁକେ କିଜାଇକରି ଆଁସ୍‌ଲାଇ ଆରି କଇଲାଇ “ସେ ବିନ୍‌ଲକ୍‌ମନ୍‌କେ ରକିଆ କଲା, ଜଦି ତୁଇ ପର୍‌ମେସର୍‌ ବାଚିପାଟାଇଲା କିରିସ୍‌ଟ ବଇଲେ ନିଜ୍‌କେ ରକିଆ କର ।” ");
INSERT INTO dso_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ଆରି ସନିଅମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସିକରି ତାକେ ଗନ୍ଦ୍‌ବା ରସ୍‌ ଦେଇ କିଜାଇକରି କଇଲାଇ, । ");
INSERT INTO dso_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ତୁଇ ଜଦି ଜିଉଦି ଲକ୍‌ମନର୍‌ ରାଜା, ନିଜ୍‌କେ ରକିଆ କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ଆରି ତାର୍‌ କୁର୍‌ସର୍‌ ଟିପେ ଏଟା ଜିଉଦିମନର୍‌ ରାଜା, ବଲି ଲେକି ଅଲାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ତେଇ ବଡ୍‌ ବୁଲ୍‌ କରି କୁର୍‌ସେ ଚଗାଇଅଇରଇବା ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ ନିନ୍ଦା କରି କଇଲା, “ତୁଇ ଜଦି ପର୍‌ମେସର ବାଚି ପାଟାଇଲା କିରିସ୍‌ଟ ରାଜା ଜିସୁ ବଇଲେ, ନିଜ୍‌କେ ରକିଆ କରି ଆମ୍‌କେ ମିସା ରକିଆ କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ମାତର୍‌ ଆରି ଗଟେକ୍‌ ଲକ୍‌ ତାକେ ଦମ୍‌କାଇ କରି କଇଲା, “ତୁଇ କାଇ ପର୍‌ମେସର୍‌କେ ଡରୁସ୍‌ ନାଇ କି ? ତୁଇ ମିସା ତାର୍‌ପାରା ସମାନ୍‌ ଡଣ୍ଡ୍‌ ପାଇଲୁସ୍‌ନି କି ନାଇ ? ");
INSERT INTO dso_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ଆରି ଆମେ ବୁଲ୍‌କରି ନିୟମ୍‌ ଇସାବେ ଡଣ୍ଡ୍‌ ପାଇଲୁନି । ମାତର୍‌ ସେତା କାଇ ବୁଲ୍‌ କରେ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ଆରି ସେ ଜିସୁକେ, “ଏ ଜିସୁ, ତୁଇ ନିଜର୍‌ ରାଇଜେ ରାଜା ଅଇ ଆଇଲେ ମକେ ଏତାଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ତକେ ସତ୍‌ କଇଲିନି, ଆଜିସେ ତୁଇ ମର୍‌ସଙ୍ଗ୍‌ ପାରଦେସେ ରଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ସେବେଲେ ଆଡ୍‌ବେଲା ଅଇରଇଲା । ଆରି ବେଲର୍‌ ଉଜଲ୍‌ ଜାଉଁଲିଜାଇକରି, ତିନ୍‌ ଗଁଟା ଜାକ ଗୁଲାଇ ଦେସ୍‌ ଆନ୍ଦାର୍‌ ଅଇଗାଲା ");
INSERT INTO dso_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ଆରି ଏଦେ ଦେକା ! ମନ୍ଦିରର୍‌ ସୁକଲ୍‌ ଜାଗା, ବିନେ କର୍‌ବା ପାର୍‌ଦା ମଜାଇ ଦୁଇପଡା ଅଇ ଚିରିଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ଆରି ଜିସୁ ଆଉଲିଅଇ କଇଲା, “ଏ ବାବା, ମର୍‌ ଆତ୍‌ମା ତକେ ସର୍‌ପିଦେଲିନି ।” ଏତ୍‌କି କଉ କଉ ତାର୍‌ ଜିବନ୍‌ ଚାଡିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ରମିୟ ସନିଅମନର୍‌ ସେନାପତି ଏ ଗଟ୍‍ନା ଦେକି, ପର୍‌ମେସରର୍‌ ମଇମା କରି କଇଲା, “ସତଇସେ ଏ ଗଟେକ୍‌ ଦରମ୍‌ ଲକ୍‌ ରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ଆରି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଏ ଗଟ୍‍ନା ଦେକ୍‌ବାକେ ରୁଣ୍ଡିରଇଲାଇ ସେମନ୍‌ ସେଟା ସବୁ ଦେକି ଦୁକ୍‌କରି ବୁକେ ମାରିଅଇ ଗରେ ବାଅଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ମାତର୍‌ ଜିସୁର୍‌ ଚିନାର୍‌ଜାନାର୍‌ ଲକ୍‌ମନ୍‌ ଆରି ଗାଲିଲିଅନି ଆସି ତାର୍‌ ପଚ୍‌ପଚ୍‌ ଆଇତେରଇବା ମାଇଜିମନ୍‌ ଦୁରିକେ ଟିଆଅଇ ଏ ସବୁ ଦେକ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ଆରି ଦେକା, ଆରାମାତିଆ ଗଡର୍‌ ଜିଉଦିମନର୍‌ ନେତା ଜସେପ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଦରମ୍‌ ଆରି ମର୍‌ଜିତାର୍‌ ଲକ୍‌ ରଇଲା । ସେ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଆସ ବଲି ଜାଗିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ମାତର୍‌ ଆରାମାତିଆ ଗାଉଁର୍‌ ସେ ଲକ୍‌ ବଡ୍‌ସବାର୍‌ ଗଟେକ୍‌ ମେମର୍‌ ରଇଲେ ମିସା, ସେମନର୍‌ ନିଆଇ ଆରି କାମ୍‌ ସଙ୍ଗ୍‌ ରାଜିଅଇ ନ ରଇଲା । ଆରି ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଜାଗ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ସେ ପିଲାତର୍‌ ଲଗେ ଜାଇ ଜିସୁର୍‌ ମଲା ମଡ୍‌ ମାଙ୍ଗ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ଜିସୁର୍‌ ମଡ୍‌ କୁର୍‌ସେଅନି ଉତ୍‌ରାଇ ଉଲ୍‌ଉଲା ପଚିଆଇ ଗୁଡିଆଇକରି ଜେନ୍ତିକି କେବେ କାକେ ନ ସଙ୍ଗଇରଇଲା, ଗଟେକ୍‌ ରାଙ୍ଗ୍‌ନି କାଟି ତିଆର୍‌କରି ରଇଲା ପାଆରେ ନେଇ ସଙ୍ଗଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ସେ ଦିନ୍‌ ବିସ୍‌ରାମ୍‌ବାର୍‌ ଦିନ୍‌ ନ ଅଇରଇଲା, ସେ ଦିନ୍‍ କେଟି ଆଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ଆରି ଗାଲିଲିଅନି ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ରଇଲା ମାଇଜିମନ୍‌ ଜସେପର୍‌ ସଙ୍ଗ୍‌ ଜାଇକରି ପାଆର୍‌ ବିତ୍‌ରେ ଜିସୁର୍‌ ଗାଗଡ୍‌ କେନ୍ତି ସଙ୍ଗଇଲା ଆଚେ ବଲି ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ସେମନ୍‌ ବାଉଡିଜାଇ ବାସ୍‌ନା ଚିକନ୍‌ ଆରି ବାସ୍‌ନା ଦିନ୍‌ସୁ ତିଆର୍‌ କର୍‌ତେ ରଇଲାଇ । ସେ କାମ୍‌ ସାର୍‌ବାକେ ବିସ୍‌ରାମ୍‌ଦିନ୍‌ କେଟ୍‌ଲା । ଆରି ସେ ଦିନେ ମସାର୍‌ ନିୟମ୍‌ ଇସାବେ, ସେମନ୍‌ ବିସ୍‌ରାମ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ଆଟର୍‌ ପର୍‌ତୁମ୍‌ ଦିନର୍‌ ସାକାଲେ, ମାଇଜିମନ୍‌ ସେମନ୍‌ ତିଆର୍‌ କରିରଇବା ବାସ୍‌ନା ଦିନ୍‍ସୁ ଆରି ବାସ୍‌ନା ଚିକନ୍‌ ଦାରି ଜିସୁର୍‌ ମଡ୍‌ ରଇଲା ପାଆରେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ଆରି ପାଆରର୍‌ ମୁଆଟେ ରଇଲା ପାକ୍‌ନା ଗୁଣ୍ଡ୍‌ଲିରଇଲାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ସେଟା ଦେକି ପାଆର୍‌ ବିତ୍‌ରେ ଜାଇ ଦେକ୍‌ଲାଇ, ତେଇ ଜିସୁର୍‌ ଗାଗଡ୍‌ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","କାଇଟା ଅଇଲାବେ, ବଲି, ବାବିକରି ରଇଲାବେଲେ, ଏଦେ ଦେକା ! ବିଜ୍‌ଲି ପାରା ଜଗ୍‌ଜଗି ଜାଇତେରଇବା ଲୁଗା ପିନ୍ଦି ଦୁଇ ଲକ୍‌ ସେମନର୍‌ ମୁଆଟେ ଟିଆ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ମାଇଜିମନ୍‌ ସେ ଦୁଇ ଲକ୍‌କେ ଦେକି ଡରିକରି ଉଁତାଡିଅଇ ଡୁଲିଦେଲାଇ । ସେ ଦୁଇଲକ୍‌ ସେମନ୍‌କେ କଇଲାଇ, “ଜିବନ୍‌ ରଇଲା ଲକ୍‌କେ କାଇକେ ମଲା ଲକ୍‌କେ ସଙ୍ଗଇଲାଟାନେ କଜ୍‌ଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ଜିସୁ ଇତି ନାଇ, ପର୍‌ମେସର୍‌ ତାକେ ଉଟାଇଲାଆଚେ । ସେ ତମର୍‌ ସଙ୍ଗ୍‌ ଗାଲିଲିତେଇ ମିସ୍‌ତେ ରଇଲା ବେଲେ ତମ୍‌କେ କାଇବଲି କଇରଇଲା, ସେଟା ତମର୍‌ ମନେ ନାଇ କି ? ");
INSERT INTO dso_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ନର୍‌ପିଲା ପାପି ଲକ୍‌ମନର୍‌ ଆତେ ସର୍‌ପାଇ ଅଇସି ଆରି ସେମନ୍‌ ତାକେ କୁର୍‌ସେ କୁଟିମାରି ମରାଇ ଦେବାଇ । ମାତର୍‌ ତିନ୍‌ଦିନ୍‌ ଗାଲାପଚେ ସେ ଆରି ତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ସେଡ୍‌କି ବେଲେ ମାଇଜିମନ୍‌ ଜିସୁ ଏନ୍ତି କାତା କଇରଇଲା ବଲି ଏତାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ତେଇଅନି ଦାପ୍‌ରେ ବାଉଡି ଆସିକରି ଏଗାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ଆରି ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌କେ ସେ ଜାଗାଇ ଅଇଲା ଗଟ୍‍ନା ସବୁ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଜଆନା, ଜାକୁବର୍‌ ମାଆ ମରିୟମ୍‌ ଆରି ତାକର୍‌ସଙ୍ଗ୍‌ ରଇଲା ବିନ୍‌ ମାଇଜିମନ୍‌ ମିସା କାଇ କାଇଟା ଗଟ୍‌ଲା, ସେ ସବୁ ବିସଇ ପେରିତ୍‌ମନ୍‌କେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ମାତର୍‌ ପେରିତ୍‌ମନ୍‌ ମାଇଜିମନର୍‌ କାତା ଟଣ୍ଡେ ପାନ୍ଦି କଇଲାଇନି ବଲି ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ମାତର୍‌ ପିତର୍‌ ଅଦର୍‌ପଡ୍‌ ଅଇ ପାଲାଇ ପାଆରେ ଜାଇ ଏରି ଦେକ୍‌ଲା । ପାଆର୍‌ ବିତ୍‌ରେ ଏରି ଦେକ୍‌ଲାକେ ତେଇ ଜିସୁକେ ଗୁଡିଆଇଲା ଉଲ୍‌ଉଲା ପଚିଆ ଚାଡି ଆରି କାଇଟା ନ ରଇଲା । ପିତର୍‌ ସେ ଗଟ୍‍ନା ଦେକି କାବାଅଇ ଜାଇକରି, ଗରେ ବାଉଡି ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ସେ ଦିନେସେ ଜିସୁର୍‌ ଦୁଇଟା ସିସ୍‌ମନ୍‌ ଜିରୁସାଲମେଅନି ଏଗାର କିଲମିଟର୍‌ ଦୁର୍‌କେ ରଇଲା ଇମାୟୁ ନାଉଁର୍‌ ଗାଏଁ ଇଣ୍ଡିକରି ଜାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ଜିସୁକେ କାଇକାଇଟା ଅଇରଇଲା ଆରି ସେ ସବୁ ବିସଇନେଇ ସେମନ୍‌ କାତାଅଇ କାତାଅଇ ଇଣ୍ଡ୍‍ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ସେମନ୍‌ ଏନ୍ତି କାତାବାର୍‌ତା ଅଇ ଆଇବାବେଲେ ଏଦେ ଦେକା ! ଜିସୁ ନିଜେ ଆସି ସେମନର୍‌ ସଙ୍ଗ୍‌ ଇଣ୍ଡ୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ସେମନ୍‌ ତାକେ ଦେକ୍‌ଲାଇ, ମାତର୍‌ ଚିନି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ସେଡିକିବେଲେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ଇଣ୍ଡି ଇଣ୍ଡି କାର୍‌ ବିସଇନେଇକରି ଏତେକ୍‌ କାତା ଅଇଲାସ୍‌ନି ?” ସେବେଲାଇ ସେମନ୍‌ ମନ୍‌ଦୁକ୍‌କରି ମୁଁ ସୁକାଇ ଟିଆଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","“ଗାଲା କେତେଦିନ୍‌ ବିତ୍‌ରେ ଜିରୁସାଲାମ୍‌ ଜନ୍‌ ଗଟ୍‍ନା ଗଟିଗାଲା ଆଚେ ? ସେଟା ନାଜାନ୍‌ଲାଟା ତୁଇ ଗଟେକ୍‌ ଲକ୍‌ସେ କି ?” ");
INSERT INTO dso_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “କାଇଟା ଅଇର‍ଇବା ବିସଇ ତମେ କଇଲାସ୍‌ନି ?” ସେମନ୍‌, “ନାଜରିତର୍‌ ଜିସୁକେ ଜାଇଟା ସବୁ ଗଟ୍‌ଲା । ସେ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ରଇଲା । ପର୍‌ମେସରର୍‌ ମୁଆଟେ ଆରି ଲକ୍‌ମନର୍‌ଟାନେ ଗଟେକ୍‌ ବପୁସଙ୍ଗର୍‌ ଲକ୍‌ ରଇଲା । ତାର୍‌ ସବୁକାମ୍‌ ଆରି କାତାଇଅନି ଏ ସବୁ ଜାନାପଡ୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ଆମର୍‌ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ସାସନ୍‌ କାରିଆମନ୍‌ ତାକେ ମରନ୍‌ ଡଣ୍ଡ୍‌ ପାଇବାକେ ସତ୍‌ରୁମନ୍‌କେ ସର୍‌ପିଦେଲାଇ ଆରି ତାକେ କୁର୍‌ସେ ଚଗାଇ ମରାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ସେ ଆକା ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌କେ ରକିଆ କର୍‌ସି ବଲି ଆସା କରି ରଇଲୁ । ମାତର୍‌ ତାକେ ମରାଇ ତିନ୍‌ଦିନ୍‌ ଅଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ଆମର୍‌ ଦଲର୍‌ କେତେଟା ମାଇଜିମନ୍‌ ଆମ୍‌କେ କାବାଅଇଜିବା କାତା କଇଲାଇ । ସେମନ୍‌ ଆଜି ସାକାଲ୍‌ ସାକାଲ୍‌ ତାର୍‌ ମଡ୍‌ ରଇବା ପାଆରେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ମାତର୍‌ ତେଇ ତାର୍‌ ଗାଗଡ୍‌ ନ ରଇଲା । ସେମନ୍‌ କଇଲାଇ, ପାଆରେଅନି ବାଉଡ୍‌ଲାବେଲେ ସରଗର୍‌ ଦୁତ୍‌ମନର୍‌ ଦର୍‌ସନ୍‌ ପାଇରଇଲା ଆରି ସେ ଦୁତ୍‌ମନ୍‌ ଜାନାଇଲାଇଜେ, ସେ ଏବେ ଜିବନ୍‌ ଅଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ଆମର୍‌ ସଙ୍ଗାରିମନର୍‌ ବିତ୍‌ରେଅନି ଜେ ଜେ ସେ ପାଆରେ ଜାଇ ଦେକ୍‌ଲାଇ ମିସା ମାଇଜିମନ୍‌ ଜେନ୍ତି କଇରଇଲାଇ, ସେ ସମାନ୍‌ ଇସାବେ ଦେକ୍‌ଲାଇ । ମାତର୍‌ ସେମନ୍‌ ଜିସୁକେ ଦେକତ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ସେବେଲେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ କେତେକ୍‌ ବକୁଆ ଲକ୍‌ମନ୍‌, ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ କଇଲା କାତା ବିସ୍‌ବାସ୍‌ କର୍‌ବାକେ କାଇକେ ଜାଗ୍‌ରତ୍‌ ଉଆସ୍‌ ନାଇ ? ");
INSERT INTO dso_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ଏ ସବୁ ଦୁକ୍‌କସ୍‌ଟ ପାଇଲା ପଚେସେ ପର୍‌ମେସର୍‌ ବାଚିପାଟାଇଲା କିରିସ୍‌ଟକେ ମଇମା ପାଇବାକେ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ଜିସୁ ମସାର୍‌ ବଇତେଇଅନି ଆରି ବିନ୍‌ ବିନ୍‌ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ଲେକିରଇଲା କାତାଇ ଅନି ଆରାମ୍‌ କରି ସବୁ ଦରମ୍‌ ସାସ୍‌ତରେ ତାର୍‌ ଜେତ୍‌କି ବିସ‍ଇ ଲେକା ଅଇରଇଲା, ସେ ସବୁ ସେମନ୍‌କେ ବୁଜାଇଦେଲା ।” ");
INSERT INTO dso_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଆରି ସେମନ୍‌ ଜନ୍‌ ଗାଉଁ ଜିବାର୍‌ ରଇଲା, ସେ ଗାଉଁ ଲଗାଲଗି ଅଇବାକେ ଜିସୁ ଆଗ୍‌ତୁ ଗାଲାପାରା ଅଇ ଇଣ୍ଡ୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ମାତର୍‌ ସେ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ସୁତ୍‌ରାଇ କରି କଇଲାଇ, “ଆମର୍‌ ସଙ୍ଗ୍‍ ର, କାଇକେ ବଇଲେ ବେଲ୍‌ ବସିଗାଲା ଆରି ରାତି ଅଇଗାଲାନି ।” ସେଟାର୍‌ ପାଇ ଜିସୁ ସେମନର୍‌ ସଙ୍ଗ୍‍ ରଇବାକେ ଗର୍‌ବିତ୍‌ରେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ଆରି ସେମନର୍‌ ସଙ୍ଗ୍‌ କାଇବାକେ ବସ୍‌ଲା । ରୁଟି ଦାରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଇକରି ସେଟା ବାଙ୍ଗାଇକରି ସେମନ୍‌କେ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ସେ ବେଲାଇ ସେମନର୍‌ ଡାବିଅଇ ଜାଇରଇଲା ଆଁକି ପିଟିଗାଲାଜେ ତାକେ ଚିନି ପାର୍‌ଲାଇ । ମାତର୍‌ ସେ ଦାପ୍‌ରେ ଜିସୁ ସେମନର୍‌ତେଇଅନି ମାୟା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ସେବେଲାଇ ସେମନ୍‌ ସେମନର୍‌ ବିତ୍‌ରେ କାତା ଅଇଲାଇ, “ଜେଡେବଲ୍‌ ସେ ଆମର୍‌ ସଙ୍ଗ୍‌ ବାଟେ କାତା ଅଇତେ ରଇଲା, ଆରି ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରର୍‌ କାତା ବୁଜାଇ ଦେଇତେ ରଇଲା, ଆମର୍‌ ମନ୍‌ ବିତ୍‌ରେ ଉଡୁକ୍‌ ଦୁଡୁକ୍‌ ନ ଅଇତେ ରଇଲା କି ?” ");
INSERT INTO dso_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ସେଦାପ୍‌ରେ ସେମନ୍‌ ଦୁଇଲକ୍‌ ଉଟିକରି ଜିରୁସାଲାମେ ବାଉଡି ଉଟିଗାଲାଇ । ତେଇ ଜିସୁର୍‌ ଏଗାର୍‌ଟା ସିସ୍‌ମନ୍‌ ଆରି ବିନ୍‌ଲକ୍‌ମନ୍‌ କାତାବାର୍‌ତା ଅଇତେରଇଲାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ସେ ଲକ୍‌ମନର୍‌ତେଇଅନି ସେମନ୍‌ ଜିସୁମାପ୍‌ରୁ ଆରି ତରେକ୍‌ ଜିବନ୍‌ଅଇ ଉଟ୍‌ଲା ଆଚେ ଆରି ସିମନ୍‌କେ ଦେକାଇଅଇଲା ଆଚେ ବଲି ଜାନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ତାର୍‌ ପଚେ ଦୁଇଲକ୍‌ ଇମାୟୁ ଗାଉଁ ଆଇବା ବାଟେ କାଇକାଇଟା ଅଇରଇଲା ସେଟା ସବୁ କଇଲାଇ । ଆରି ସେମନ୍‌ ଜିସୁ ରୁଟି ବାଙ୍ଗାଇ କରି ଦେଲାବେଲେ କେନ୍ତି ତାକେ ଚିନି ଦେଇରଇଲାଇ ସେଟା ମିସା ସେମନ୍‌କେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ସେ ଦୁଇଲକ୍‌ ଏନ୍ତି କଇବା ବେଲେ ଏଦେ ଦେକା ! ମାପ୍‌ରୁ ନିଜେ ସେମନର୍‌ ମଜାଇ ଟିଆଅଇଦେଲା । ଆରି ସେମନ୍‌କେ କଇଲା, “ତମ୍‌କେ ସାନ୍ତି ଅ ।” ");
INSERT INTO dso_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ମାତର୍‌ ସେମନ୍‌ ସବୁ ଲକ୍‌ ଏଟା ଗଟେକ୍‌ ବୁତ୍‌ ଦେକ୍‌ଲୁନି ବଲି ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ କାଇକେ ଡର୍‌ଲାସ୍‌ନି ? ଆରି ଦେକି କରି ମିସା କାଇକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ ? ");
INSERT INTO dso_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ମର୍‌ ଆତେ ଆରି ଗଡେ ଦେକା, ଏଟା ମୁଇ ନିଜେ । ମକେ ଚିଇକରି ଦେକା । ଏଟା ମକେ ଜେନ୍ତାରି ଆଡ୍‌ ଆରି ମାଉଁସ୍‌ ଆଚେ ସେନ୍ତି ବୁତ୍‌କେ ନ ରଏ ।” ");
INSERT INTO dso_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ଜିସୁ ଏଟା କଇକରି, ତାର୍‌ ଆତ୍‌ ଆରି ଗଡ୍‌ ସେମନ୍‌କେ ଦେକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ସେଟା ଦେକି ସେମନ୍‌ ସାର୍‌ଦା ଅଇକରି କାବାଅଇ ଗାଲାଇ ମିସା ତାକେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇ । ସେଟାର୍‌ ପାଇ ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ତମର୍‌ ଲଗେ କାଇଟା କାଇବାଟା ଆଚେ କି ?” ");
INSERT INTO dso_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ସେବେଲାଇ ସେମନ୍‌ ତାକେ କଣ୍ଡେକ୍‌ ବାଜ୍‌ଲା ମାଚ୍‌ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ସେଟା ଜିସୁ ଦାରିକରି ସେମନର୍‌ ମୁଆଟେ କାଇଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମସାର୍‌ ନିୟମ୍‌ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ କଇଲା କାତା ଆରି ଗିତ୍‌ସଙ୍ଗିତା ବଇଟାନେ କାଇକାଇଟା ଲେକା ଅଇଲାଆଚେ ସେ ସବୁ, ସତ୍‌ ଅଇବାର୍‌ ରଇଲା । ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‌ ରଇଲାବେଲେ ଏ ସବୁ କାତା ତମ୍‌କେ କଇରଇଲି ।” ");
INSERT INTO dso_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ତାର୍‌ପଚେ ଦରମ୍‌ ସାସ୍‌ତରର୍‌ ଅରତ୍‌ ବୁଜ୍‌ବାକେ ଜିସୁ ସେମନର୍‌ ବୁଜ୍‌ବା ବପୁ ଉଗାଡି ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଆରି ସେମନ୍‌କେ କଇଲା, “ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା କିରିସ୍‌ଟ ରାଜା ମୁଇ, ଏନ୍ତି ଦୁକ୍‌ କସ୍‌ଟ ପାଇକରି ମର୍‌ବି । ପଚେ ତିନ୍‌ଦିନ୍‌ ଗାଲେ ଆରି ତରେକ୍‌ ଉଟ୍‌ବି ବଲି ଲେକା ଅଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ଆରି ଜିରୁସାଲମେଅନି ଆରାମ୍‌ କରି ସବୁ ଦେସର୍‌, ସବୁ ଜାତିର୍‌ ଲକ୍‌ମନ୍‌କେ ମର୍‌ ନାଉଁଦାରି ପାପ୍‌ କେମା କରାଇ, ମନ୍‌ ବଦ୍‌ଲାଇବାକେ କଇବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ତମେ ଏ ସବୁ ବିସଇର୍‌ ସାକି ଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ଆରି ମର୍‌ ବାବା ଜନ୍‌ ଜିଦ୍‌ କରିରଇଲା, ମୁଇ ନିଜେ ସେଟା ପାଟାଇବି । ମାତର୍‌ ତମେ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ବପୁ ନ ମିଲ୍‌ବା ଜାକ, ଏ ଜିରୁସାଲମେସେ ରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ତାର୍‌ପଚେ ଜିସୁ ସେମନ୍‌କେ ବେତ୍‌ନିଆ ନାଉଁର୍‌ ଜାଗାଇ ଜିବା ବାଟ୍‌ଜାକ ଡାକିନେଲା । ଆରି ସେମନ୍‌କେ ଆତ୍‌ ଟେକି ଆସିର୍‌ବାଦ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ସେ ଏନ୍ତି ସେମନ୍‌କେ ଆସିର୍‌ବାଦ୍‌ କର୍‌ବାବେଲେ ପର୍‌ମେସର୍‌ ତାକେ ସରଗ୍‌ପୁରେ ଦାରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ସେମନ୍‌ ତାକେ ଜୁଆର୍‌ କଲାଇ ଆରି ସାର୍‌ଦାଅଇ ଜିରୁସାଲମେ ବାଉଡି ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ସବୁବେଲା ମନ୍ଦିରେ ରଇକରି ପର୍‌ମେସରର୍‌ ଡାକ୍‌ପୁଟା କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ ।");
INSERT INTO dso_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","କାଇଟା ତିଆର୍‌ ନ ଅଇରଇଲା ପୁର୍‌ବେ ବାକିଅ ରଇଲା । ସେ ବାକିଅ ପର୍‌ମେସରର୍‌ ସଙ୍ଗ୍‌ ରଇଲା । ସେ ଆରି ପର୍‌ମେସର୍‌ ଗଟେକ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","କାଇଟା ତିଆର୍‌ ନ ଅଇବା ଆଗ୍‌ତୁ ଏ ବାକିଅ ପର୍‌ମେସର୍‌ ସଙ୍ଗ୍‍ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ପର୍‌ମେସର୍‌ ସେ ବାକିଅ ଦେଇ ସବୁ ବିସଇ ତିଆର୍‌ କଲାଆଚେ । ଏ ଦୁନିଆଇ ତିଆର୍‌ ଅଇଲା ଗଟେକ୍‌ ବିସଇ ମିସା ତାର୍‌ଟାନେଅନି ତିଆର୍‌ ନ ଅଇଲାଟା ନ ର‍ଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ସେ ବାକିଅ ନ ସାର୍‌ବା ଜିବନର୍‌ ଦାନ୍‌ ଦେଲା ଆରି ସେ ଜିବନ୍‌ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌କେ ଉଜଲ୍‌ ଦେକାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ସେ ଉଜଲ୍‌ ଆନ୍ଦାର୍‌ ବିତ୍‌ରେ ସବୁବେଲେ ଉଜଲ୍‌ ଦେଇସି । ଆନ୍ଦାର୍‌ କେବେ ମିସା ସେ ଉଜଲ୍‌ ଲିବାଇ ନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ପର୍‌ମେସର୍‌, ଜଅନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ତାର୍‌ କବର୍‌ନେଉ କରି ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ସେ ଲକ୍‌ମନ୍‌କେ ଉଜଲ୍‌ ବିସଇ କଇବାର୍‌ ଆସିରଇଲା । ଜେନ୍ତାରିକି ଗୁଲାଇ ଜଗତର୍‌ ଲକ୍‌ମନ୍‌ ତାର୍‌ତେଇଅନି ସେ ଉଜଲର୍‌ ବିସଇ ସୁନ୍‌ବାଇ ଆରି ବିସ୍‌ବାସ୍‌ କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ଜଅନ୍‌ ନିଜେ ସେ ଉଜଲ୍‌ ନ ରଇଲା, ମାତର୍‌ ଲକ୍‌ମନ୍‌କେ ସେ ଉଜଲ୍‌ ବିସଇର୍‍ ସାକି ଦେବାକେ ଆସିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ସେ ସତ୍‌ ଏବେ ଉଜଲ୍‌ ଅଇଲା, ଏ ଉଜଲ୍‌ ଦୁନିଆଇ ଆଇଲା ଆରି ସବୁ ଲକ୍‌ମନର୍‌ ମନ୍‌ବିତ୍‌ରେ ରଇବା ଆଁକି ଡିସାଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ବାକିଅ ଏ ଦୁନିଆଇ ରଇଲା । ତାର୍‌ଟାନେଅନି ପର୍‌ମେସର୍‌ ଏ ଦୁନିଆ ତିଆର୍‌ କରିରଇଲେ ମିସା ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ଚିନତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ସେ ତାର୍‌ ନିଜର୍‌ ଲକ୍‌ମନର୍‌ ଟାନେ ଆଇଲା, ମାତର୍‌ ତାର୍‌ ନିଜର୍‌ ଲକ୍‌ ଇସ୍‌ରାଏଲର୍‌ ପିଲାଜିଲା ତାକେ ନାମତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ମାତର୍‌ ଜେ ଜେ ତାକେ ନାମ୍‍ଲାଇ, ଆରି ତାକେ ବିସ୍‌ବାସ୍‌ କଲାଇ, ସେ ଲକ୍‌ମନ୍‌କେ ପର୍‌ମେସରର୍‌ ପିଲାଜିଲା ଅଇଜିବାକେ ସେ ଅଦିକାର୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ସେମନ୍‌ ମୁନୁସ୍‌ମ‌ନ୍‌ ମନ୍‌କଲା ଇସାବେ ଜନମ୍‌ ଅଅତ୍‌ନାଇ, କି ଗାଗଡର୍‌ ବନି ଇସାବେ ଅଅତ୍‌ନାଇ । ନିଜେ ପର୍‌ମେସର୍‌ ସେମନର୍‌ ବାବା । ");
INSERT INTO dso_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ଆରି ସେ ବାକିଅ ନର୍‌ ଲକ୍‌ ଅଇକରି ଆମର୍‌ ସଙ୍ଗ୍‌ ଜିଇଲା । ତାର୍‌ ସତ୍‌ ଆରି ଜିବନ୍‌ ଦୁକାଇବାଟା ପୁରାପୁରୁନ୍‌ ରଇଲା । ତାର୍‌ ବାବାର୍‌ ଗଟେକ୍‌ସେ ପିଲା ବଲି ସେ ମଇମା ପାଇରଇଲା । ତାର୍‌ ମଇମା ଆମେ ଦେକିଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ଜିସୁର୍‌ ବିସଇ ଲକ୍‌ମନ୍‌କେ ଆକ୍‌ମାରି କରି ଏନ୍ତାରି କଇଲା, “ଏ ଲକର୍‌ ବିସଇ ମୁଇ ଏନ୍ତି କଇରଇଲି, ଜେ ମର୍‌ପଚେ ଆଇଲାନି, ସେ ମର୍‌ତେଇଅନି ବେସି ମୁକିଅ, କାଇକେବଇଲେ ମୁଇ ଜନମ୍‌ ଅଇବା ଆଗ୍‌ତୁଅନି ସେ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","“ତାର୍‌ ମନ୍‌ ବିତ୍‌ରେ ରଇଲା ପୁରାପୁରୁନ୍‌ ଜିବନ୍‌ ଦୁକାଇବା ତେଇଅନି ଆମେ ସବୁ ଆସିର୍‌ବାଦ୍‌ ପାଇଆଚୁ । ଉଁ, ଆସିର୍‌ବାଦର୍‌ ପଚେ ଆସିର୍‌ବାଦ୍‌ ପାଇଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","କାଇକେ ବଇଲେ ପର୍‌ମେସର୍‌ ଆମ୍‌କେ ମସାର୍‌ଟାନେଅନି ନିୟମ୍‌ ଦେଲା ଆଚେ । ମାତର୍‌ ଜିସୁ କିରିସ୍‌ଟର୍‌ଟାନେଅନି ଆମ୍‌କେ ଜିବନ୍‌ ଦୁକାଇ ସତ୍‌ ବାଟ୍‌ ଆଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","କେ ମିସା କେବେ ପର୍‌ମେସର୍‌କେ ଦେକତ୍‌ନାଇ । ମାତର୍‌ ତାର୍‌ ଗଟେକ୍‌ ବଲି ପିଲା ଜେ କି ପର୍‌ମେସରର୍‌ ସମାନ୍‌ ଆଚେ ଆରି ତାର୍‌ କଲେ ଆଚେ, ସେ ଆକା ଆମ୍‌କେ ତାର୍‌ ବିସଇ ଜାନାଇ ଦେଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ଜିରୁସାଲମର୍‌ ଜିଉଦି ନେତାମନ୍‌, କେତେଟା ଦରମ୍‌ ଗୁରୁମନ୍‌କେ ଆରି ଲେବି ଦଲର୍‌ ଲକ୍‌ମନ୍‌କେ ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ଲଗେ “ତମେ କେ ?” ବଲି ପାଚାର୍‌ବାକେ ପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ସେ ସତ୍‍ ବିସଇ କଇବାକେ ନ ନିଚିକରି, ସବୁ ଲକ୍‌ ବୁଜ୍‌ଲା ପାରା କଇଲା, “ମୁଇ କିରିସ୍‌ଟ ନଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ତେଇ ସେମନ୍‌ ପାଚାର୍‌ଲାଇ, “ସେନ୍ତି ବଇଲେ ତମେ କେ ତେବେ ? ବବିସତ୍‌ବକ୍‌ତା ଏଲିୟ କି ?” ଜଅନ୍‌ କଇଲା, “ନଇ, ମୁଇ ଏଲିଅ ନଇ ।” ଆରି ସେମନ୍‌ ପାଚାର୍‌ଲାଇ, “ତୁଇ ସେ ବବିସତ୍‌ବକ୍‌ତା କି ?” ଜଅନ୍‌ କଇଲା, “ମୁଇ ସେ ନଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ତାର୍‌ ପଚେ ସେମନ୍‌ ପାଚାର୍‌ଲାଇ, “ସେନ୍ତାର୍‌ଆଲେ ତମେ କେ ? ଆମ୍‌କେ ପାଟାଇଲା ଲକ୍‌ମନ୍‌କେ ଆମେ ଜାଇ, କାଇଟା ବଲି କ‍ଇବୁ, ସେଟାର୍‌ପାଇ ତମର୍‌ ନିଜର୍‌ ବିସଇ ଅଲପ୍‌ କଇଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତା ଜେନ୍ତି କଇରଇଲା, ଜଅନ୍‌ ସେମନ୍‌କେ ସେନ୍ତି କଇଲା । “ମୁଇ ମରୁବାଲି ବୁଏଁ ଆକ୍‌ମାରି ବୁଲ୍‌ବା ଗଟେକ୍‌ ସବଦ୍‌ ମାପ୍‌ରୁ ଜିବାକେ ଗଟେକ୍‌ ସଲକ୍‌ ବାଟ୍‌ ତିଆର୍‌ କରା !” ");
INSERT INTO dso_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ତାର୍‌ ପଚେ ପାରୁସିମନ୍‌ ପାଟାଇ ରଇଲା କବର୍‌ ନେଉମନ୍‌ ଜଅନ୍‌କେ ପାଚାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“ତମେ ଜଦି କିରିସ୍‌ଟ ନୁଆସ୍‌, ଏଲିୟ ନୁଆସ୍‌, ଆରି ବବିସତ୍‌ବକ୍‌ତା ନୁଆସ୍‌, କାଇକେ ଲକ୍‌ମନ୍‌କେ ଡୁବନ୍‌ ଦେଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ଜଅନ୍‌ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ଲକ୍‌ମନ୍‌କେ ପାନିତେଇ ଡୁବନ୍‌ ଦେଲିନି, ଜନ୍‌ ଲକ୍‌କେ କି ତମେ ନାଜାନାସ୍‌, ମାତର୍‍ ସେ ତମର୍‌ ସଙ୍ଗ୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ସେ ମର୍‌ ପଚେ ଆଇଲାନି । ଆରି ତାର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ଅଇ ତାର୍‌ ପାଣ୍ଡଇର୍‌ ପିତା ବେଟ୍‌ବାର୍‌ ମିସା ମର୍‌ ଅଦିକାର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ଏ ଗଟ୍‍ନା ଜର୍‌ଦନ୍‌ ଗାଡର୍‌ ସେପାଟେ ବେତ୍‌ନି ନାଉଁର୍‌ ଜାଗାଇ, ଜଅନ୍‌ ଲକ୍‌ମନ୍‌କେ ଡୁବନ୍‌ ଦେଲା ବେଲା ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଜିସୁ ତାର୍‌ ଲଗେ ଆଇବାଟା ଦେକିକରି ଜଅନ୍‌ କଇଲା, “ଏଦେ ଦେକା ! ପର୍‌ମେସରର୍‌ ମେଣ୍ଡାପିଲା ଜେ କି, ଏ ଦୁନିଆର୍‌ ସବୁ ଲକ୍‌ମନର୍‌ ପାପର୍‌ ଡଣ୍ଡ୍‌ ବଇକରି ନେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ଏ ଲକର୍‌ ବିସଇ ମୁଇ ଆଗ୍‌ତୁ ଏନ୍ତି କଇରଇଲି, ମୁଇ ଆଇଲା ପଚେ ଜନ୍‌ ଲକ୍‌ ଆଇଲାନି ସେ ମର୍‌ତେଇଅନି ବେସି ବଡ୍‌ଲକ୍‌ ଆରି ମୁଇ ଜନମ୍‌ ଅଇଲା ବେସି ଆଗ୍‌ତୁଅନି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ମୁଇ ନିଜେ ମିସା ସେ କେ ଅଇରଇସି ବଲି ନାଜାନିରଇଲି । ମାତର୍‌ ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌ ତାର୍‍ ବିସଇ ଜାନତ୍‌ ବଲି ମୁଇ ପାନିତେଇ ଡୁବନ୍‌ ଦେବାକେ ଆସିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ତାର୍‌ ପଚେ ଜଅନ୍‌ ଆରି ଏ ସାକି ଦେଇ କଇଲା, “ସୁକଲ୍‌ ଆତ୍‌ମା ପରୁଆପାରା ଅଇକରି ସର୍‌ଗେଅନି ଉତ୍‌ରି ଆସି ତାର୍‌ ଉପ୍‌ରେ ବସ୍‌ବାଟା ମୁଇ ଦେକିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ଏଲେମିସା ସେଡ୍‌କିବେଲା ଜାକ ଏ ଲକ୍‌ ସେ ଆକା ବଲି ମୁଇ ଜାନି ନ ରଇଲି । ମାତର୍‌ ପାନିତେଇ ଡୁବନ୍‌ ଦେବାକେ ପାଟାଇରଇଲା ପର୍‌ମେସର୍‌ ମକେ କଇରଇଲା, ଜେଡେବେଲା ଗଟେକ୍‌ ଲକର୍‌ ଉପ୍‌ରେ ସୁକଲ୍‌ ଆତ୍‌ମା ଉତ୍‌ରି ଆଇବାଟା ତୁଇ ଦେକ୍‌ସୁ, ସେସେ ଅଇଲାନି ତୁଇ କଜ୍‌ବା ଲକ୍‌ । ସେ ଲକ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ଡୁବନ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ଏନ୍ତି ସୁକଲ୍‌ ଆତ୍‌ମା ତାର୍‍ ଉପ୍‌ରେ ଉତ୍‌ରି ଆଇବାଟା ମୁଇ ଦେକ୍‌ଲି ଆରି ସେ ପର୍‌ମେସରର୍‌ ପିଲା ବଲି ମୁଇ ତମ୍‌କେ ସାକିଦେଲିନି” ବଲି ଜଅନ୍‌ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେମିସା ଜଅନ୍‌ ସେ ଜାଗାଇସେ ରଇଲା । ଆରି ତାର୍‌ ଦୁଇଟା ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଟିଆ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ଆରି ଜିସୁ ସେ ବାଟେ ଜିବାଟା ଜଅନ୍‌ ଦେକିକରି କଇଲା, “ଏଦେ ଦେକା ! ପର୍‌ମେସରର୍‌ ମେଣ୍ଡାପିଲା ଗାଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ଜଅନର୍‌ ଦୁଇଟା ସିସ୍‌ମନ୍‌ ତାର୍‌ କାତା ସୁନି, ଜିସୁର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ଜିସୁ ପାସ୍‌ଲିକରି ଦେକ୍‌ବା ବେଲେ ସେ ଦୁଇଟା ସିସ୍‌ମନ୍‌ ତାର୍‌ ପଚେ ପଚେ ଜିବାଟା ଦେକି ସେମନ୍‌କେ ପାଚାର୍‌ଲା ତମେ କାଇଟା କଜ୍‌ଲାସ୍‌ନି ? ସେମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ରାବି ତମେ କନ୍‌ ଜାଗାଇ ରଇଲାସ୍‌ନି ?” ରାବିର୍‌ ଅରତ୍‌ ଅଇଲାନି ସିକାଇ ଦେବା ଗୁରୁ । ");
INSERT INTO dso_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମର୍‌ ସଙ୍ଗ୍‌ ଆସା ମୁଇ ରଇବା ଜାଗା ଦେକ୍‌ସା ।” ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ତାର୍‌ ସଙ୍ଗ୍‌ ଜାଇ ସେ ରଇବା ଜାଗା ଦେକ୍‌ଲାଇ । ଆରି ସେ ଦିନେ ତାର୍‌ ସଙ୍ଗ୍‌ ରଇଲାଇ । ସେବେଲା ସଞ୍ଜୁଆ ଚାର୍‌ଟା ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ତାକର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଅଇଲାନି ସିମନ୍‌ ପିତରର୍‌ ବାଇ, ଆନ୍ଦ୍‌ରିୟ । ");
INSERT INTO dso_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ସେ ଦାପ୍‌ରେ ସେ ତାର୍‌ ବାଇ ସିମନ୍‌ ପିତର୍‌କେ କଜିକରି ବେଟ୍‌ ପାଇ କଇଲା, “ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା ମସିଅକେ ଆମେ ବେଟ୍‍ପାଇଲୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ତାର୍‌ ପଚେ ଆନ୍ଦ୍‌ରିୟ ସିମନ୍‌ପିତର୍‌କେ ଜିସୁର୍‌ ଲଗେ ଡାକି ଆନ୍‌ଲା । ଜିସୁ ତାକେ ଦେକି କଇଲା, “ତମେ ସିମନ୍‌, ଜଅନର୍‌ ପିଲା ଏବେଅନି ତକେ କେପା ବଲି ଡାକ୍‌ବାଇ ।” କେପାର୍‌ ଅରତ୍‌ ଅଇଲାନି ପିତର୍‌ ଆରି ପିତରର୍‌ ଅରତ୍‌ ଅଇଲାନି ରାଙ୍ଗ୍‌ନି ପାକ୍‌ନା । ");
INSERT INTO dso_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ତାର୍‌ ଆରକର୍‌ ଦିନେ ଜିସୁ ଗାଲିଲି ଦେସେ ଜିବାକେ ମନ୍‍ କଲା । ଆରି ସେ ଜିବା ବେଲେ ପିଲିପ୍‌କେ ବେଟ୍‍ପାଇ ତାକେ କଇଲା, “ମର୍‌ ସଙ୍ଗ୍‌ ଆଉ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ଆନ୍ଦ୍‌ରିୟ ଆରି ପିତର୍‌ ପାରା ପିଲିପ୍‌ ମିସା ବେତ୍‌ସାଇଦା ଗଡର୍‌ ଲକ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପିଲିପ୍‌ ନିତନିଏଲ୍‌କେ ବେଟ୍‌ ପାଇ କଇଲା, “ଜନ୍‌ ଲକର୍‌ ବିସଇ ମସାର୍‌ ନିୟମେ ଲେକିରଇଲା ଆରି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ଲେକି ଆଚତ୍‌, ଆମେ ତାକେ ଦେକ୍‌ଲୁ ଆଚୁ । ସେ ଜସେପର୍‌ ପିଲା ନାଜରିତ୍‌ ଗଡର୍‌ ଜିସୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିତନିଏଲ୍‌ ପିଲିପ୍‌କେ ପାଚାର୍‌ଲା, “ନାଜରିତ୍‌ ଗଡେଅନି କାଇଆଲେ ନିକ ବିସଇ ଆଇସି କି ?” ପିଲିପ୍‌ ତାକେ କଇଲା, “ତୁଇ ଆସିକରି ଦେକ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ଜିସୁ ନିତନିଏଲ୍‌କେ ତାର୍‌ ଲଗେ ଆଇବାଟା ଦେକି ତାର୍‌ ବିସଇ ନେଇ କଇଲା, “ଏଦେ ଦେକା ! ଏ ଗଟେକ୍‌ ଇସ୍‌ରାଏଲର୍‌ ସତ୍‌ ଲକ୍‌, ଏ ଲକର୍‌ତେଇ କାଇମିସା କୁଟ୍‌କପଟ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିତନିଏଲ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲା “ମକେ କେନ୍ତି ଜାନୁସ୍‌ ?” ଜିସୁ କଇଲା, “ପିଲିପ୍‌ ତମ୍‌କେ ଡାକ୍‌ବା ଆଗ୍‌ତୁ ମୁଇ ତକେ ଡୁମ୍‌ରି ଗଚ୍‌ ତଲେ ଦେକି ରଇଲି ।” ");
INSERT INTO dso_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ତାର୍‌ ପଚେ ନିତନିଏଲ୍‌ ଜିସୁକେ କଇଲା, “ଏ ଗୁରୁ, ତମେ ପର୍‌ମେସରର୍‌ ପିଲା ଆରି ଇସ୍‌ରାଏଲର୍‌ ରାଜା !” ");
INSERT INTO dso_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ତକେ ଡୁମ୍‌ରି ଗଚ୍‌ ତଲେ ଟିଆଅଇଲାଟା ଦେକ୍‌ଲି ବଲି କଇଲାକେ ବିସ୍‌ବାସ୍‌ କଲୁସ୍‌ନି କି ? ଇତିଅନି ଆରି ଅଦିକ୍‌ ବଡ୍‌ ବଡ୍‌ କାବା ଅଇଜିବା ବିସଇମନ୍‌ ଦେକ୍‌ସୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ଜିସୁ ଆରି ତରେକ୍‌ କଇଲା, “ମୁଇ ତକେ ସତ୍‌କାତା କଇଲିନି, ସରଗ୍‌ ଉଗାଡି ଅଇଜାଇ ନର୍‌ପିଲା ମର୍‌ ଉପ୍‌ରେ, ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ମନ୍‌ ଚଗି ଜିବାଟା ଆରି ଉତ୍‌ରି ଆଇବାଟା ତମେ ଦେକ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ଦୁଇ ଦିନ୍‌ ପଚେ ଗାଲିଲି ଦେସର୍‌ କାନା ନାଉଁର୍‌ ଗଡେ ଗଟେକ୍‌ ବିବା ଅଇତେ ରଇଲା । ସେ ବିବାତେଇ ଜିସୁର୍‌ ମାଆ ମରିୟମ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ମିସା ସେ ବିବାତେଇ ଡାକି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ବଜି ନ ସାର୍‌ତେ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ସାରିଗାଲାକେ ଜିସୁର୍‌ ମାଆ ଆସି ତାକେ କଇଲା, “ସେମନର୍‌ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ସାରିଗାଲାବେ ।” ");
INSERT INTO dso_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ଜିସୁ ତାକେ କଇଲା, “ଏ ମାଆ, ମର୍‌ଟାନେ ତର୍‌ କାଇଟା ଆଚେ ? ତୁଇ ମକେ କାଇଟା ମିସା କର୍‌ବାକେ କଅ ନାଇ । ମର୍‌ ବେଲା ଏବେ ଜାକ ଆସେ ନାଇତା ।” ");
INSERT INTO dso_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ଜିସୁର୍‌ ମା ବାଣ୍ଡାର୍‌ଗରିଆମନ୍‌କେ କଇଲା, “ଜିସୁ ତମ୍‌କେ ଜାଇଟା କଇସି ସେଟା କରା ।” ");
INSERT INTO dso_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ସେ ଜାଗାଇ ବଡ୍‌ ବଡ୍‌ ପାକ୍‌ନା ସଙ୍ଗ୍‌ ତିଆର୍‌ କଲା ଚଅଟା କୁଣ୍ଡ୍‌ ରଇଲା । ଜିଉଦି ଲକ୍‌ମନ୍‌ ସୁକଲ୍‌ ଅଇବାକେ ସେମନର୍‌ ରିତିନିତି ଇସାବେ ଏ କୁଣ୍ଡର୍‌ ପାନି କାମେ ଲାଗାଇତେ ରଇଲାଇ । ଗଟେକ୍‌ ଗଟେକ୍‌ କୁଣ୍ଡେ ସଏ ଲିଟର୍‌ ଲାକା ପାନି ଦାର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ଜିସୁ ବାଣ୍ଡାର୍‌ଗରିଆମନ୍‌କେ “ସେ କୁଣ୍ଡ୍‌ମନ୍‌କେ ପାନି ବର୍‌ତି କରା” ବଲି କଇଲା ଆରି ସେମନ୍‌ ସେ ସବୁ କୁଣ୍ଡେ ପାନି ବର୍‌ତି କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ତାର୍‌ ପଚେ ଜିସୁ ସେମନ୍‌କେ ତେଇର୍‌ ପାନି ଡୁମିନେଇ ବଜି ଦାଇତେ ରଇଲା ଲକ୍‌କେ ଦିଆସ୍‌ ବଲି କଇଲା । ସେମନ୍‌ ତେଇର୍‌ ପାନି ଡୁମି ନେଇ ତାକେ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ମାତର୍‌ ସେ ସବୁ ପାନି ଅଙ୍ଗୁର୍‌ ରସ୍‌ ଅଇଜାଇରଇଲା । ବଜି ଦାଇତେ ରଇଲା ଲକ୍‌ ଅଙ୍ଗୁର୍‌ ରସ୍‌ କନ୍ତିଅନି ବଲି ଜାନି ନ ରଇଲା । ମାତର୍‌ ସେ ପାନି ଡୁମି ନେଲା ଲକ୍‌ମନ୍‌ ଜାନି ରଇଲାଇ, ପଚେ ସେ ଲକ୍‌ ଚାକି କରି ଏ ରସ୍‌ କନ୍ତିଅନି ଆନ୍‌ଲାଇ ବଲି ବିବା ଅଇବା ଦାଙ୍ଗ୍‌ଡାକେ ଡାକି ପାଚାର୍‌ଲା, ");
INSERT INTO dso_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ଲକ୍‌ମନ୍‌ ସବୁ ବେଲା ପର୍‌ତୁମ୍‌ ପର୍‌ତୁମ୍‌ କାଇବାକେ ନିମାନ୍‌ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ଦେବାଇ । ଆରି ଗତିଆ ଲକ୍‌ମନ୍‌ କାଇ ପୁରୁନ୍‌ ଅଇଲା ପଚେ ଚପ୍‌ରାଟା ଦେବାଇ । ମାତର୍‌ ତମେ ଏବେ ସାରାସାରି ଜାକ ନିମାନ୍‌ ଅଙ୍ଗୁର୍‌ ରସ୍‌ କନ୍ତି ସଙ୍ଗଇ ରଇଲାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଏଟା ଜିସୁ ପର୍‌ତୁମ୍‌ କଲା କାବାଅଇଜିବା କାମ୍‌ । ସେଟା ଗାଲିଲି ଦେସର୍‌ କାନା ନଅରେ କରିରଇଲା । ଏନ୍ତି କରି ତାର୍‌ ମଇମା ଦେକାଇଲା ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ତାକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ତାର୍‌ ପଚେ ଜିସୁ, ତାର୍‌ ମାଆ ତାର୍‌ ବାଇମନ୍‌ ଆରି ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ କପର୍‌ନାଉମ୍‌ ଗଡେ ଜାଇ ତେଇ କେତେ ଦିନ୍‌ ପାରା ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ସେ ବେଲା ଜିଉଦି ଲକ୍‌ମନର୍‌ ନିସ୍‌ତାର୍‌ ପରବ୍‌ କେଟି ଆଇତେ ରଇଲା । ସେଟାର୍‌ପାଇ ଜିସୁ ଜିରୁସାଲମେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ତେଇ ସେ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ, ଲକ୍‌ମନ୍‌ ଗରୁଗାଇ ମେଣ୍ଡା, ଆରି ପାରୁଆମନ୍‌ ବେବାର୍‌ କର୍‌ବାଟା, ଆରି ବିନ୍‌ ଦେସର୍‌ ଡାବୁ ବାଦ୍‌ଲାଉମନ୍‌ ସେମନର୍‌ ଟେବୁଲେ ବସିରଇଲାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ତେଇ ଜିସୁ କସିରା ସଙ୍ଗ୍‌ କର୍‌ଡା ତିଆର୍‌ କରି ମେଣ୍ଡା ଆରି ଗରୁମନର୍‌ ସଙ୍ଗ୍‌ ସବୁ ଲକ୍‌ମନ୍‌କେ ମନ୍ଦିରେଅନି ବାର୍‌କରାଇ ଦେଲା । ଆରି ଲକ୍‌ମନର୍‌ତେଇ ଅନି ବାଦ୍‌ଲାଇ ନେବା ଡାବୁ ସବୁ ବିଚିଦେଇ ସେମନର୍‌ ଟେବୁଲ୍‌ ପାସ୍‌ଲାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ପରୁଆ ବିକ୍‌ବା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ଏ ସବୁ ଦିନ୍‌ସୁ ଇତିଅନି ଦାରିଜା । ମର୍‌ ବାବାର୍‌ ଗରେ ଗେନା ବିକା ଜାଗା ପାରା କରାନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ଏ ସବୁ ଗଟ୍‍ନା ଅଇବାବେଲେ ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଲେକାଅଇଲା ଗଟେକ୍‌ ବାକିଅ ଏତାଇଲାଇ । ତମର୍‌ ଗରର୍‍ ପାଇ ରଇବା ମର୍‍ ବକ୍‌ତି, ମର୍‌ ମନ୍‌ ବିତ୍‌ରେ ଜଇ ଲାଗ୍‌ଲା ପାରା ଲାଗ୍‌ଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ତେଇ ଜିଉଦି ନେତାମନ୍‌ ଜିସୁର୍‌ ଲଗେ ବାଉଡି ଆସି ଏନ୍ତାରି କଇଲାଇ । “ତୁଇ ଏନ୍ତାରି ସବୁ କାମ୍‌ କର୍‌ବାକେ ଅଦିକାର୍‌ ପାଇଆଚୁସ୍‌ ବଲି ଆମେ କେନ୍ତି ଜାନ୍‌ବୁ ଆରି କାଇ ଚିନର୍‌ଲାଗି ଆମ୍‌କେ ସେଟା ଦେକାଇଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ତମେ ଏ ମନ୍ଦିର୍‌ ବସ୍‌ଲାଇ ଦିଆସ୍‌ । ସେଟା ମୁଇ ତିନ୍‌ଦିନ୍‌ ବିତ୍‌ରେ ଆରିତରେକ୍‌ ତିଆର୍‌ କରିଦେବି ।” ");
INSERT INTO dso_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ଜିସୁର୍‌ ଏ କାତା ସୁନି ସେମନ୍‌ କଇଲାଇ, “କାଇଟା ! ତିନ୍‌ଦିନ୍‌ ବିତ୍‌ରେ ତୁଇ ତିଆର୍‌ କରି ପାରୁସ୍‌ କି ? ଏ ମନ୍ଦିର୍‌ ତିଆର୍‌ କର୍‌ବାକେ ଚାଲିସ୍‌ ଚଅ ବରସ୍‌ ଲାଗିରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ମାତର୍‌ ଜିସୁ ତାର୍‌ ନିଜର୍‌ ଗାଗଡର୍‍ ବିସଇ ମନ୍ଦିର୍‌କେ ଦେକାଇ କରି ଏ କାତା କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ସେ ମରିକରି ଆରିତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ଲା ପଚେ ସିସ୍‌ମନର୍‌ ମନେ ପଡ୍‌ଲା ଜେ, ସେ ଏନ୍ତାରି କଇରଇଲା । ତେବର୍‌ପାଇ ସେମନ୍‌ ଦରମ୍‌ ସାସ୍‌ତର୍‌ ଆରି ଜିସୁର୍‌ ବାକିଅ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ନିସ୍‌ତାର୍‌ ପରବ୍‌ବେଲେ ଜିସୁ ଜିରୁସାଲାମ୍‌ ରଇଲାବେଲେ କେତେକ୍‌ କେତେକ୍‌ ଲକ୍‌ ସେ କରିରଇବା କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ କଲାଟା ଦେକି ତାକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ମାତର୍‌ ଜିସୁ ସେ ଲକ୍‌ମନ୍‌ ବିସ୍‌ବାସ୍‌ କରିରଇବାଟା ସତ୍‌ବଲି ବାବେନାଇ । କାଇକେ ବଇଲେ ସେ ସବୁ ଲକର୍‌ ବିସଇ ସେ ନିକସଙ୍ଗ୍‌ ଜାନି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ଲକ୍‌ମନର୍‌ ବିସଇନେଇକରି ତାକେ, କେ ମିସା କାଇଟାବଲି କଇବାର୍‌ ଦର୍‌କାର୍‌ ନ ରଇଲା, କାଇକେବଇଲେ ସେ ତାକର୍‌ ମନ୍‌ ବିତ୍‌ରର୍‌ କାତା, ନିଜେ ଜାନି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ପାରୁସିମନର୍‌ ବିତ୍‌ରେଅନି ନିକଦିମ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ରଇଲା । ସେ ଜିଉଦି ମନର୍‌ ଗଟେକ୍‌ ନେତା । ");
INSERT INTO dso_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ସେ ଦିନେକ୍‌ ରାତିଆ ଜିସୁର୍‌ ଲଗେ ଆସି କଇଲା, “ଏ ଗୁରୁ ଆମେ ଜାନୁ, ତମେ ପର୍‌ମେସର୍‌ ପାଟାଇରଇବା ଗଟେକ୍‌ ଗୁରୁ । କାଇକେ ବଇଲେ ଜଦି ଗଟେକ୍‌ ଲକର୍‌ ସଙ୍ଗ୍‍ ପର୍‌ମେସର୍‌ ନ ରଇଲେ, ତମେ ଜନ୍‌ ସବୁ କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କଲାସ୍‌ନି, ସେତ୍‌କି କାମ୍‌ମନ୍‌ କେ ମିସା କରିନାପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ଜିସୁ ତାକେ କ‍ଇଲା, “ମୁଇ ତକେ ସତ୍‌ କାତା କଇଲିନି, ଆରିତରେକ୍‌ ଜନମ୍‌ ନ ଅଇଲେ କେ ମିସା ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ଦେକି ନାପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନିକଦିମ ତାକେ ପାଚାର୍‌ଲା, “ଡକ୍‌ରା ଅଇଲା ଲକ୍‌ କେନ୍ତି ଆରି ତରେକ୍‌ ଜନମ୍‌ ଅଇସି ? ସେ ଆରି ତରେକ୍‌ ମାଆର୍‌ ପେଟ୍‌ ବିତ୍‌ରେ ଜାଇକରି ଜନମ୍‌ ଅଇସି କି ? ନାଇ ଅଇ ନଏଁ ।” ");
INSERT INTO dso_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ତକେ ସତ୍‌କାତା କଇଲିନି, ଗଟେକ୍‌ ଲକ୍‌ ପାନି ଆରି ଆତ୍‌ମାଇଅନି ଜନମ୍‌ ନ ଅଇଲେ, ପର୍‌ମେସରର୍‌ ରାଇଜେ ଜାଇ ନାପାରେ । ");
INSERT INTO dso_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ଗଟେକ୍‌ ନର୍‌ ଲକ୍‌ ତାର୍‌ ନର୍‌ ମାଆ ବାବାର୍‌ତେଇଅନି ଜନମ୍‌ ଅଇସି । ମାତର୍‌ ସୁକଲ୍‌ ଆତ୍‌ମା ତାର୍‌ ଆତ୍‌ମାଇ ନୁଆ ଜିବନ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ସେଟାର୍‌ପାଇ ମୁଇ ତକେ ଆରିତରେକ୍‌ ଜନମ୍‌ ଅଇବାକେ ଅଇସି ବଲି କଇବା ବିସଇ ସୁନି କାବାଅଇଜାଆ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ପବନ୍‌ ଜନ୍‌ ବାଟେ ଜିବାକେ ମନ୍‌ କର୍‌ସି ସେ ବାଟେସେ ଜାଇସି, ଆରି ତମେ ତାର୍‌ ସବଦ୍‌ ସୁନ୍‌ସା । ମାତର୍‌ ସେଟା କନ୍ତିଅନି ଆଇସି ଆରି କନ୍‌ ବାଟେ ଜାଇସି ସେଟା ନାଜାନାସ୍‌ । ଆତ୍‌ମାଇ ଜନମ୍‌ ଅଇଲା ସବୁ ଲକ୍‌ମନ୍‌ ମିସା ସେନ୍ତାରିସେ ।” ");
INSERT INTO dso_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନିକଦିମ ଜିସୁକେ ପାଚାର୍‌ଲା, “ଏବେ ତୁଇ କଇବା କାତା କେନ୍ତି ଅଇପାର୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ଇସ୍‌ରାଏଲର୍‌ ଗଟେକ୍‌ ବଡ୍‌ ଗୁରୁ ଅଇକରି ମିସା କେନ୍ତି ଏ ସବୁ କାତା ବୁଜି ନାପାର୍‌ଲୁସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ମୁଇ ତକେ ସତ୍‌କାତା କଇଲିନି, ଆମେ ଜନ୍‌ଟା ଜାନୁ ସେଟା କଇଦେବୁ, ଜନ୍‌ଟା ଦେକିରଇବୁ ସେଟା ସାକି ଦେବୁ, ଅଇଲେ ମିସା ତୁଇ କାଇକେ ବିସ୍‌ବାସ୍‌ କରୁସ୍‌ନାଇ ? ");
INSERT INTO dso_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ମୁଇ ତକେ ଏ ଦୁନିଆର୍‌ ବିସଇ କଇବାବେଲେ ବିସ୍‌ବାସ୍‌ କରୁସ୍‌ ନାଇ । ଆରି ସରଗର୍‌ ବିସଇ କଇବି ବଇଲେ କେନ୍ତି ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସୁ ? ");
INSERT INTO dso_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ସର୍‌ଗେଅନି ଉତ୍‌ରି ଆଇଲା ନର୍‌ପିଲା ମୁଇ, ମକେ ଚାଡିକରି ଆରି କେ ମିସା ସର୍‌ଗେ ଜାଅତ୍‌ ନାଇତା ।” ");
INSERT INTO dso_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“ଆରି ମସା କେନ୍ତି ମରୁବାଲି ବୁଏଁ ପିତଲ୍‌ ସାଁପ୍‌କେ ଡେଲି ଉପ୍‌ରେ ଟେକି ରଇଲା, ସମାନ୍‌ ସେନ୍ତାରିସେ ପର୍‌ମେସର୍‌ ତେଇଅନି ଆଇଲା ନର୍‌ପିଲା ମକେ ମିସା, ଗଟେକ୍‌ ଦିନେ ଉପ୍‌ରେ ଟେକ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ତେବେ, ତାକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ସବୁ ଲକ୍‌ମନ୍‌ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ପର୍‌ମେସର୍‌ ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌କେ ଏତେକ୍‌ ଆଲାଦ୍‌ କଲାଜେ, ତାର୍‌ ଗଟେକ୍‌ ବଲି ପିଲାକେ ସର୍‌ପିଦେଲା । ଜେ ମିସା ତାକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବାଇ ବଇଲେ, ସେମନ୍‌ ନସ୍‌ଟ ନ ଅଇକରି, ନ ସାର୍‌ବା ଜିବନ୍‌ ମିଲାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ପର୍‌ମେସର୍‌ ତାର୍‌ ପିଲାକେ ଏ ଦୁନିଆଇ ବିଚାର୍‌ କର୍‌ବାକେ ପାଟାଏନାଇ, ମାତର୍‌ ତାର୍‌ ଲାଗି ଦୁନିଆ ରକିଆ ପାଅ ବଲି ପାଟାଇ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","କେ ପର୍‌ମେସରର୍‌ ପିଲାକେ ବିସ୍‌ବାସ୍‌ କଲାନି ତାର୍‌ ବିଚାର୍‌ନା ନଏଁଁ । ମାତର୍‌ ଜେ ପର୍‌ମେସରର୍‌ ପିଲାକେ ବିସ୍‌ବାସ୍‌ କରେନାଇ ତାର୍‌ ବିଚାର୍‌ନା ଅଇସାର୍‌ଲାବେ । କାଇକେବଇଲେ ସେ ଗଟେକ୍‌ ବଲି ପିଲାକେ ବିସ୍‌ବାସ୍‌ କରେନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ଆରି ସେ ବିଚାର୍‌ନା ଏନ୍ତି ଅଇସି, ସର୍‌ଗେ ଅନି ଉଜଲ୍‌ ଏ ଦୁନିଆଇ ଆସିରଇଲା । ମାତର୍‌ ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ସେ ଉଜଲେଅନି ଆନ୍ଦାର୍‌କେ ବେସି ମନ୍‌ କଲାଇ । କାଇକେବଇଲେ ସେମନ୍‌ କର୍‌ବା କାମ୍‌ ସବୁ ବେସି କାରାପ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ଜନ୍‌ଲକ୍‌ମନ୍‌ କାରାପ୍‌ କାମ୍‌ କଲାଇନି ସେମନ୍‌ ଉଜଲ୍‌କେ ଗିନ୍‌ କଲାଇନି । ଆରି ସେ ଉଜଲେ ନ ଆସତ୍‌ । କାଇକେବଇଲେ ସେମନର୍‌ ସବୁ କାରାପ୍‌ କାମ୍‌ ସେ ଉଜଲେ ଡିସ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ମାତର୍‌ ଜନ୍‌ଲକ୍‌ ସତ୍‌ ଆରି ଟିକ୍ ଇସାବେ କାମ୍‌ କରି ଚଲାଚଲ୍‌ତି କଲାନି, ସେ ଉଜଲ୍‌ ଲଗେ ଆଇସି । ତେବେ, ସେ କର୍‌ବା କାମ୍‌ ପର୍‌ମେସରର୍‌ ମନ୍‍ କର୍‍ବା ଇସାବେ ଅଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ତାର୍‌ ପଚେ ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ଜିଉଦା ଦେସେ ଗାଲାଇ ଆରି ସେ ଜାଗାଇ ରଇକରି ଲକ୍‌ମନ୍‌କେ ଡୁବନ୍‌ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ସେ ବେଲାଇ ଜଅନ୍‌ ମିସା ସାଲମ୍‌ ଗଡ୍‌ଲଗେ ଏନନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଗାଏଁ ଡୁବନ୍‌ ଦେଇତେ ରଇଲା । କାଇକେ ବଇଲେ ସେ ଜାଗାଇ ବେସି ପାନି ରଇଲା । ଆରି ଲକ୍‌ମନ୍‌ ଆସିକରି ଡୁବନ୍‌ ନେଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ସେତ୍‌କି ଦିନ୍‌ ଜାକ ଜଅନ୍‌ ବନ୍ଦି ନ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ସେବେଲା ଗଟେକ୍‌ ଜିଉଦି ଲକ୍‌ ଆରି ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ଅସୁକଲ୍‌ଅନି ରିତିନିତି ଇସାବେ ସୁକଲ୍‌ ଅଇବା ବିସଇ ନେ‍ଇ ତାକର୍‌ ବିତ୍‌ରେ ଦଦାପେଲା ଅଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ଆରି ଜଅନର୍‌ ସିସ୍‌ମନ୍‌ ତାର୍‍ ଲଗେ ଆସି କଇଲାଇ, “ଏ ଗୁରୁ, ତମେ ଜର୍‌ଦନ୍‌ ଗାଡ୍‌ ସେପାଟେ କାର୍‌ସଙ୍ଗ୍‌ ବେଟ୍‌ ଅଇରଇଲାସ୍‌ ଆରି ତାର୍‌ ବିସଇ ତମେ ସାକି ଦେଇତେରଇଲାସ୍‌, ସେ ଲକ୍‌ ଏବେ ଲକ୍‌ମନ୍‌କେ ଡୁବନ୍‌ ଦେଲାନି ଆରି ସବୁ ଲକ୍‌ମନ୍‌ ତାର୍‌ ଲଗେ ଗାଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଜଅନ୍‌ କ‍ଇଲା, “ପର୍‌ମେସର୍‌ ନ ଦେଲେ, କେ ମିସା କାଇଟା ନ ପାଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ମୁଇ କଇରଇଲି ପର୍‌ମେସର୍‌ ପାଟାଇଲା ମସିଅ ମୁଇ ନଇ ବଲି । ମୁଇ ଅବ୍‌କା ପାଟାଇରଇବା ଗଟେକ୍‌ ଦୁତ୍‌ ପାରା ଅଇ ଆସିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ଜେ ବିବା ଅଇସି, ସେ ବର୍‌ ଦାଙ୍ଗ୍‌ଡା । ମାତର୍‌ ବର୍‌ ଦାଙ୍ଗ୍‌ଡାର୍‌ ଲଗେ ବରର୍‌ ସଙ୍ଗାରି ଟିଆଅଇ ତାର୍‌ କାତା ସୁନ୍‌ସି । ସେ ବର୍‌ ଦାଙ୍ଗ୍‌ଡାର୍‌ କାତା ସୁନି, ବେସି ସାର୍‌ଦା ଅଇସି । ସେନ୍ତାରିସେ ମର୍‌ ସାର୍‌ଦା ମିସା ପୁରାପୁରୁନ୍‌ ଅଇଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ସେ ମଆନ୍‌ ଅଇତେ ଜାଅ ଆରି ମୁଇ ସାନ୍‌ ଅଇତେ ଜିବି ।” ");
INSERT INTO dso_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“ଜେ ସର୍‌ଗେଅନି ଆଇଲା ଆଚେ, ସେ ସବୁ ଲକ୍‌ମନର୍‌ତେଇଅନି ମଆନ୍‌ । ଜେ ଜଗତେ ଅନି ଜନମ୍‌ ଅଇଆଚେ, ସେ ଜଗତର୍‌ କାତାସେ କଇସି । ମାତର୍‌ ଜେ ସର୍‌ଗେଅନି ଆସିଆଚେ, ସେ ସବୁକଲର୍‌ତେଇ ଅନି ମଆନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ସେ ଜନ୍‌ଟା ଦେକ୍‌ଲା ଆଚେ ଆରି ସୁନ୍‌ଲା ଆଚେ ସେ ବିସଇ ସେ ଜାନାଇଲାନି । ମାତର୍‌ ସେ କଇରଇବା କାତା କେ ମିସା ନାମତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ଜେ ତାର୍‌ କଇରଇବା କାତା ନାମ୍‌ସି, ସେ ପର୍‌ମେସର୍‌ ସତ୍‌ଟା ବଲି ନାମ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ଜାକେ ପର୍‌ମେସର୍‌ ପାଟାଇଲା ଆଚେ, ସେ ପର୍‌ମେସରର୍‌ ବାକିଅ କଇସି । କାଇକେ ବଇଲେ ତାକେ ପର୍‌ମେସରର୍‌ ଆତ୍‌ମା ପୁରାପୁରୁନ୍‌ ଦିଆଅଇଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ବାବା ପିଲାକେ ଆଲାଦ୍‌ କରି ସବୁ ବିସଇ ତାର୍‌ ଆତେ ସର୍‌ପି ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ଆରି କେ ପର୍‌ମେସରର୍‌ ପିଲାକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ସେ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇସି । ମାତର୍‌ ଜେ ପର୍‌ମେସରର୍‌ ପିଲାକେ ନାମେ ନାଇ, ସେ ନ ସାର୍‌ବା ଜିବନ୍‌ ନ ପାଏ । ଆରି ପର୍‌ମେସରର୍‌ ଡଣ୍ଡ୍‌ ପାଇବାକେ ସେ ରଇସି । ” ");
INSERT INTO dso_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ଜଅନର୍‌ତେଇଅନି ଜିସୁକେ ଅଦିକ୍‌ ସିସ୍‌ ଅଇବାଟା ଆରି ଡୁବନ୍‌ ଦେବା କାତା ପାରୁସିମନ୍‌ ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ଜିସୁ ସତ‍ଇସେ ନିଜେ କାକେ ମିସା ଡୁବନ୍‌ ନ ଦେଇତେ ରଇଲା, ମାତର୍‌ ତାର୍‌ ସିସ୍‌ମନ୍‌ ଡୁବନ୍‌ ଦେଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ତାର୍‌ ବିସଇ ନେଇ ଲକ୍‌ମନ୍‌ ଏନ୍ତାରି କାତା ଅଇବାଟା ସୁନି, ଜିସୁ ଜିଉଦା ରାଇଜ୍‌ ଚାଡିକରି ଆରି ତରେକ୍‌ ଗାଲିଲି ଦେସେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ମାତର୍‌ ତାକେ ସମିରଣ୍‌ ଗଡ୍‌ ବାଟେ ଜିବାକେ ପଡ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ଆରି ଜାକୁବ୍‌ ତାର୍‌ ନିଜର୍‌ ପିଲା ଜସେପ୍‌କେ ଜନ୍‌ ଜାଗା ଦାନ୍‌ ଦେଇରଇଲା, ସେ ଲଗେ ସମିରଣ୍‌ ଗଡର୍‌ ଗଟେକ୍‌ ସୁକାର୍‌ ନାଉଁର୍‌ ଜାଗାଇ ଜିସୁ ଆସି କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ସେ ଜାଗାଇ ଜାକୁବର୍‌ ଗଟେକ୍‌ କୁଇସାଲ୍‌ ରଇଲା । ଜିସୁ ଇଣ୍ଡି ଇଣ୍ଡି ତାକି ଜାଇକରି କୁଇସାଲ୍‌ ଲଗେ ବସି ରଇଲା । ସେବେଲା ଟିଆମୁଇଦାନ୍‌ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଗଟେକ୍‌ ସମିରଣିୟ ମାଇଜି କୁଇସାଲେ ପାନି ନେବାକେ ଆଇଲା । ଆରି ଜିସୁ ସେ ମାଇଜିକେ କଇଲା, “ଏ ମା ମକେ ଗୁଡିକ୍‌ ପାନି କାଇବାକେ ଦେ ।” ");
INSERT INTO dso_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ସେଡ୍‌କିବେଲେ ତାର୍‌ ସିସ୍‌ମନ୍‌ କାଦି ଗେନ୍‌ବାକେ ଗଡ୍‌ ବିତ୍‌ରେ ଜାଇରଇଲାଇ ଆରି ଜିସୁ ଗଟେକ୍‌ ଲକ୍‌ ସେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ତେଇ ସମିରଣିୟ ମାଇଜି କାବାଅଇ ଜିସୁକେ କଇଲା, “ତୁଇ ଗଟେକ୍‌ ଜିଉଦି ଲକ୍‌ ଆରି ମୁଇ ଗଟେକ୍‌ ସମିରଣିୟ, ତୁଇ କେନ୍ତି ମର୍‌ ଆତର୍‌ ପାନି କାଇବାକେ ମାଙ୍ଗ୍‌ଲୁସ୍‌ନି ?” କାଇକେ ବଇଲେ, ଜିଉଦି ଲକ୍‌ମନ୍‌ ସମିରଣିୟ ଲକ୍‌ମନର୍‌ କାଇବାତେଇ ନ କାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ଜିସୁ ତାକେ କଇଲା, “ପର୍‌ମେସର୍‌ ଦେବା ଦାନର୍‍ ବିସଇ, ତୁଇ ଅଲପ୍‌ ଆଲେ ଜାନି ରଇଲେ ଆରି ମୁଇ କେ ବଲି ଜାନ୍‌ତୁସ୍‌ ବଇଲେ ମକେ ମାଙ୍ଗ୍‌ତୁସ୍‌ । ଆରି ମୁଇ ତକେ ଜିବନ୍‌ ଦେବା ପାନି ଦେଇତି ।” ");
INSERT INTO dso_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ମାଇଜି କଇଲା, “ଆଗିଆଁ, ତମର୍‌ ଲଗେତା ପାନି ଜିକ୍‌ବାକେ ବାଲ୍‌ଟିନାଇ, ଆରି ଏ କୁଇସାଲ୍‌ ବେସି ଡେଙ୍ଗ୍‌ ଆଚେ । କନ୍ତିଅନି ତମେ ଜିବନ୍‌ ଦେବା ପାନି ମିଲାଇସୁ ? ");
INSERT INTO dso_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ତୁଇ କାଇ ଆମର୍‌ ଆନିଦାଦି ଜାକୁବର୍‌ତେଇ ଅନି ବଡ୍‌ କି ? ଜାକୁବ୍‌ ଆମ୍‌କେ ଏ କୁଇସାଲ୍‌ ଦେଇରଇଲା । ସେ ନିଜେ ମିସା ଏ କୁଇସାଲର୍‌ ପାନି କାଇତେରଇଲା । ତାର୍‌ ଗରର୍‌ ଲକ୍‌ମନ୍‌ ଆରି ସେ ପସିରଇଲା ଗରୁଗାଇମନ୍‌ ଇତିର୍‌ ପାନି କାଇଲାଇ” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ଜିସୁ ତାକେ କଇଲା, “ଏ କୁଇସାଲର୍‌ ପାନି କାଇବା ସବୁ ଲକ୍‌ମନ୍‌କେ ଆରିସେ ସସ୍‌ ଲାଗ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ମାତର୍‌ ମୁଇ ଜନ୍‌ ପାନି ଦେବି, ସେ ପାନି ଜେ କାଇସି ବଇଲେ, ତାକେ କେବେ ମିସା ସସ୍‌ ନ ଲାଗେ । ମୁଇ ଜନ୍‌ ପାନି ଦେବି, ସେଟା ଜିବନ୍‌ ଦେବା ପାନି ପାରା ଉଚ୍‌ଲି ଜାଇତେରଇସି । ତେଇ ଅନି ଜେ କାଇଲେ, ସେ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ସେ ମାଇଜି ଜିସୁକେ କଇଲା, “ଏ ଆଗିଆଁ ମକେ ସେ ପାନି ଦେ, ଜେନ୍ତିକି କେବେ ମିସା ମକେ ସସ୍‌ ନ ଲାଗ ଆରି ମୁଇ ଏତେକ୍‌ ଦୁର୍‌ ପାନି ନେବାକେ ନ ଆସି ।” ");
INSERT INTO dso_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ଜିସୁ ସେ ତାକେ କଇଲା, “ତୁଇ ଜାଇକରି ତର୍‌ ମୁନୁସ୍‌କେ ଇତି ଡାକିଆନ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ସେ ମାଇଜି “ମକେ ମୁନୁସ୍‌ ନାଇ” ବଲି କଇଲା । ଜିସୁ ତାକେ କଇଲା, “ମକେ ମୁନୁସ୍‌ ନାଇ ବଲି ସତ୍‌ କାତା କଇଆଚୁସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","କାଇକେ ବଇଲେ ତର୍‌ ପାଁଚ୍‌ଟା ମୁନୁସ୍‌ ରଇଲାଇ ଆରି ଏବେ ତୁଇ ଜନ୍‌ ଲକର୍‌ ସଙ୍ଗ୍‌ ଆଚୁସ୍‌, ସେ ମିସା ତର୍‌ ମୁନୁସ୍‌ ନଏଁ । ଏଟା ସତ୍‌ କଇଆଚୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ସେ ମାଇଜି କଇଲା, “ଏ ଆଗିଆଁ ତୁଇ ଗଟେକ୍‌ ବବିସତର୍‌ କାତା କଇବା ଲକ୍‌ ବଲି, ଏବେ ମୁଇ ଜାନିପାର୍‌ଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ଆମର୍‌ ସମିରଣିୟ ଆନିଦାଦିମନ୍‌ ପର୍‌ମେସର୍‌କେ ଏ ଡଙ୍ଗ୍‌ରେ ଉପାସନା କର୍‌ତେ ରଇଲାଇ । ମାତର୍‌ ତମେ ଜିଉଦି ଲକ୍‌ମନ୍‌ କଇଲାଇନି ଜିରୁସାଲମ୍‌ସେ ପର୍‌ମେସର୍‌କେ ଉପାସନା କର୍‌ବା ଟିକ୍‌ ଜାଗା ।” ");
INSERT INTO dso_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଜିସୁ ତାକେ କଇଲା, “ଏ ମାଆ ମର୍‌କାତା ବିସ୍‌ବାସ୍‌ କର୍‌ । ଏନ୍ତାରି ବେଲା ଆଇଲାନି ତମେ ପର୍‌ମେସର୍‌କେ ଏ ଡଙ୍ଗ୍‌ରେ କି ଜିରୁସାଲାମେ ମିସା ଉପାସନା ନ କରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ତମେ ସମିରଣ୍‌ ଲକ୍‌ମନ୍‌ ଜାକେ ଉପାସନା କଲାସ୍‌ନି ତାକେ ସତ‍ଇସେ ନାଜାନାସ୍‌ । ମାତର୍‌ ଆମେ ଜିଉଦି ଲକ୍‌ମନ୍‌ ତାକେ ଜାନିକରି ଉପାସନା କଲୁନି । କାଇକେ ବଇଲେ ମୁକ୍‌ତି ଜିଉଦି ଲକ୍‌ମନର୍‌ ତେଇଅନି ଆଇସି । ");
INSERT INTO dso_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ବେଲା ଆଇଲାନି ଆରି ସେ ବେଲା କେଟ୍‌ଲାବେ, ଜେଡେବେଲା କି ସୁକଲ୍‌ଆତ୍‌ମାର୍‌ ବପୁସଙ୍ଗ୍‌ ଲକ୍‌ମନ୍‌, ବାବା ପର୍‌ମେସର୍‌କେ ନିକସଙ୍ଗ୍‌ ଚିନ୍‌ବାଇ । ସେବେଲେ ସେମନ୍‌ ତାକର୍‌ ମନେ ସତ୍‌ସଙ୍ଗ୍‌ ଉପାସନା କର୍‌ବାଇ । ସେନ୍ତି ଉପାସନା କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ବାବା ମନ୍‌ କଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ପର୍‌ମେସର୍‌ ଅଇଲାନି ଆତ୍‌ମା । ଆରି ଜନ୍‌ଲକ୍‌ମନ୍‌ ତାକେ ଉପାସନା କଲାଇନି, ସେମନ୍‌ ସତ୍‌ସଙ୍ଗ୍‌ ଆତ୍‌ମାଇ ଉପାସନା କର୍‌ବାର୍‌ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ସେ ମାଇଜି କଇଲା, “ମୁଇ ଜାନି, ମସିଅ ଜାକେ କି କିରିସ୍‌ଟ ବଲ୍‌ବାଇ । ସେବେଲାଇ ଆସି ଆମ୍‌କେ ସବୁ ବିସଇ ବୁଜାଇ ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ଜିସୁ ତାକେ କଇଲା, “ଏବେ ତର୍‌ ସଙ୍ଗ୍‌ ଜେ କାତା ଅଇଲାନି, ମୁଇ ସେ ।” ");
INSERT INTO dso_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ସେବେଲା ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ ଗଡେଅନି ବାଉଡି ଆଇଲାଇ । ଜିସୁ ଗଟେକ୍‌ ମାଇଜିସଙ୍ଗ୍‌ କାତା ଅଇବାଟା ଦେକି କାବାଅଇଗାଲାଇ । ମାତର୍‌ ତାକେ କେ ମିସା ତୁଇ କାଇକେ ତାର୍‌ ସଙ୍ଗ୍‌ କାତା ଅଇଲୁସ୍‌ନି, କି କାଇ ବିସଇ ତମେ କାତା ଅଇତେ ରଇଲାସ୍‌ ? ବଲି ପାଚାର୍‌ବାକେ ସାଆସ୍‌ କରତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ତାର୍‌ ପଚେ ସେ ମାଇଜି ତାର୍‌ ଆଣ୍ଡିର୍‌ ପାନି, ତେଇ ଚାଡିକରି ସଅର୍‌ ବିତ୍‌ରେ ଉଟିଗାଲା ଆରି ଜାଇକରି ସବୁ ଲକ୍‌ମନ୍‌କେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ଆସା ଗଟେକ୍‌ ଲକ୍‌କେ ଦେକ୍‌ସା । ଆଗେ ମୁଇ ଜାଇଜାଇଟା କରିରଇଲି, ସେ ସବୁ କାତା ସେ ମକେ କଇଦେଲା । ସେ ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା ରାଜା ମସିଅ ଅଇଲେ ଅଇରଇସି କାଇକି ।” ");
INSERT INTO dso_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ସେଟାର୍‌ପାଇ ଲକ୍‌ମନ୍‌ ସଅରେ ଅନି ବାରଇକରି ଜିସୁକେ ଦେକ୍‌ବାକେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ଏତ୍‌କି ବିତ୍‌ରେ ସିସ୍‌ମନ୍‌ ଜିସୁକେ “ଏ ଗୁରୁ କାଇଟା ଆଲେ ଅଲପ୍‌ କାଆ ।” ବଲି ବାବୁଜିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମର୍‌ ଲଗେ ଜନ୍‌ କାଦି ଆଚେ, ସେ କାଦିର୍‍ ବିସଇ ତମେ ନାଜାନାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ସେଟାର୍‌ ପାଇ ସିସ୍‌ମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ତାର୍‌ପାଇ କେ କାଦି ଆନିଦେଲାଇ ଆଚତ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମକେ ପାଟାଇରଇବା ପର୍‌ମେସର୍‌ ମନ୍‌କଲାଟା ମାନିକରି ଆରି ସେ ଦେଇରଇବା କାମ୍‌ ପୁରାପୁରୁନ୍‌ କର୍‌ବାଟାସେ ମର୍‌ କାଦି । ");
INSERT INTO dso_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ଚାରି ମାସ୍‌ ଗାଲେ କାଟାବେଟା ଦିନ୍‌ ଆଇସି ବଲି ତମେ କଇତେରଇସା । ମାତର୍‌ ମୁଇ ତମ୍‌କେ କଇଲିନି କେତ୍‌ମନ୍‌କେ ନିକ କରି ଦେକିଦେକା । ଏବେ ତେଇର୍‌ ତାସ୍‌ ପାଚିଗାଲା ଆଚେ ଆରି କାଟ୍‌ବା ବେଲା ସମାନ୍‌ ଅଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ଏବେ ମିସା ଜନ୍‌ ଲକ୍‌ ତାସ୍‌ କାଟ୍‌ଲାନି ତାକେ ବୁତି ଦିଆ ଅଇଲାନି, ସେ ନ ସାର୍‌ବା ଜିବନର୍‌ ପାଇ ତାସ୍‌ ଟୁଲିଆଇଲାନି । ସେଟାର୍‌ ପାଇ ବୁନ୍‌ଲା ଲକ୍‌ ଆରି କାଟ୍‌ବା ଦୁଇ ଲକ୍‌ଜାକ ମିସି ସାର୍‌ଦା କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","କାଇକେବଇଲେ ଗଟେକ୍‌ ଲକ୍‌ ବିଅନ୍‌ ବୁନ୍‌ଲେ ସେଟା ବିନ୍‌ ଲକ୍‌ କାଟ୍‌ସି । ଏ କାତା ପୁରାପୁରୁନ୍‌ ସତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ତମେ ଜନ୍ତି ବୁନି ନ ରଇଲାସ୍‌ ତେଇ କାଟ୍‌ବାକେ ପାଟାଇଆଚି । ବିନ୍‌ ଲକ୍‌ମନ୍‌ କାମ୍‌କଲାଇ ଆରି ତମେ ସେମନ୍‌ କଲା କାମେଅନି ଲାବ୍‍ ପାଇଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ସେ ସଅରର୍‌ କେତେକ୍‌ କେତେକ୍‌ ସମିରଣିୟମନ୍‌ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । କାଇକେବଇଲେ, ସେ ମାଇଜି ସେମନ୍‌କେ କଇରଇଲା । ଆଗେ ମୁଇ ଜାଇଜାଇଟା କରିରଇଲି, ସେ ସବୁ କାତା ସେ ମକେ କଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ଆରି ସମିରଣିୟ ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ତାର୍‌ ସଙ୍ଗ୍‌ କେତେ ଦିନ୍‌ ରଇବାକେ ଗୁଆରି କଲାଇ, ସେଟାର୍‌ପାଇ ସେ ତେଇ ଦୁଇ ଦିନ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ଜିସୁର୍‌ କାତା ସୁନି ତାକେ ବେସି ଲକ୍‌ମନ୍‌ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ଲକ୍‌ମନ୍‌ ସେ ମାଇଜିକେ କଇଲାଇ, “ତୁଇ କଇଲାକେ ଆମେ ବିସ୍‌ବାସ୍‌ କରୁନାଇ, ଆମେ ନିଜେ ତାର୍‌ କାତା ସୁନି କରି ଏ ଆକା ଦୁନିଆର୍‌ ରକିଆକରୁ ବଲି ବିସ୍‌ବାସ୍‌ କଲୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ଜିସୁ ତେଇ ଦୁଇ ଦିନ୍‌ ରଇଲା ପଚେ ଗାଲିଲି ରାଇଜେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ଆରି ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ନିଜର୍‌ ଦେସେ ସନ୍‌ମାନ୍‌ ନ ପାଏ ବଲି ଜିସୁ ଆଗ୍‌ତୁସେ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ସେଟାର୍‌ପାଇ ସେ ଜେଡେବେଲା ଗାଲିଲି ଦେସେ କେଟ୍‌ଲା, ସେବେଲା ଲକ୍‌ମନ୍‌ ଆଲାଦ୍‌ ସଙ୍ଗ୍‌ ଡାକିନେଲାଇ । କାଇକେବଇଲେ ଆଗେ ଜିରୁସାଲାମେ ନିସ୍‌ତାର୍‌ ପରବ୍‌ଟାନେ ସେମନ୍‌ ସେ କରିରଇବା କାମ୍‌ ସବୁ ଦେକିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ଜିସୁ ଗାଲିଲିର୍‌ କାନା ନାଉଁର୍‌ ଗଡେ ଆରି ତରେକ୍‌ ଗାଲା । ସେ ଗଡେସେ ପାନି ଅଙ୍ଗୁର୍‌ ରସ୍‌ କରିରଇଲା । ତେଇ ରମିଅ ସାସନ୍‍କାରିଆର୍‍ ଗଟେକ୍‌ ମୁକିଅ ଲକର୍‌ ପଅ କପର୍‌ନାଉମେ ଜର୍‌ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ଜିସୁ ଜିଉଦାଇ ଅନି ଗାଲିଲି ଆଇଲା ଆଚେ ବଲି ସୁନିକରି ଜର୍‌ ଅଇଲା ପିଲାର୍‌ ବାବା ତାର୍‍ ଲଗେ ଗାଲା । ମର୍‌ବା ସମାନ୍‌ ଅଇରଇବା ପିଲାକେ ନିମାନ୍‌ କର୍‌ବାକେ କପର୍‌ନାଉମେ ଜୁ ବଲି ଜିସୁକେ ଜୁଆର୍‌ ବିଆର୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ଜିସୁ ତାକେ କଇଲା, “ତମେ କାବା ଅଇଜିବାଟା ଆରି କେବେ ନ ଅଇଲା ପାରା କାମର୍‌ ଚିନ୍‌ମନ୍‌ ନ ଦେକ୍‌ଲେ କେବେ ମିସା ମକେ ବିସ୍‌ବାସ୍‌ ନ କରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ସେ ଲକ୍‌ ତାକେ କଇଲା, “ଏ ଗୁରୁ, ମର୍‌ ପିଲା ନ ମର୍‌ବା ଆଗ୍‌ତୁ ତମେ ମର୍‌ ସଙ୍ଗ୍‌ ଆସା ।” ");
INSERT INTO dso_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଜିସୁ ତାକେ କଇଲା, “ଏବେ ତୁଇ ତର୍‌ ଗରେ ଜା, ତର୍‌ ପିଲା ଜିବନ୍‌ ଅଇଗାଲାବେ ।” ସେ ଲକ୍‌ ଜିସୁ କଇରଇବା କାତା ବିସ୍‌ବାସ୍‌ କରି ବାଉଡିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ସେ ଗରେ ଗାଲାବେଲେ ତାର୍‌ କେତେଟା ଗତି ଦାଙ୍ଗ୍‌ଡାମନ୍‌ ତାକେ ବେଟ୍‍ପାଇକରି, “ତର୍‌ ପିଲା ନିମାନ୍‌ ଅଇଲାବେ” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ସେ ଲକ୍‌ ତାର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ପାଚାର୍‌ଲା, “ପିଲା କେଡେବେଲେ ନିମାନ୍‌ ଅଇଲା ?” ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌, “କାଲି ଗଁଟେ ବେଲେ ନିମାନ୍‌ ଅଇଲା” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ଜିସୁ ଟିକ୍‌ ସେବେଲାସେ ତର୍‌ ପିଲା ନିମାନ୍‌ ଅଇଲାବେ ବଲି କଇରଇଲାଟା ସେ ମୁକିଅ ଲକ୍‌ ମନେପାକାଇଲା । ସେଟାର୍‌ପାଇ ସେ ଲକ୍‌ ଆରି ତାର୍‌ ଗରର୍‌ ସବୁ ଲକ୍‌ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଜିସୁ ଜିଉଦାଇ ଅନି ଗାଲିଲି ଦେସେ ଆଇଲା ପଚେ ଏଟାସଙ୍ଗ୍‌ ଦୁଇପାଲି କାବାଅଇଜିବା କାମ୍‌ କରି ରଇଲାଟା । ");
INSERT INTO dso_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ତାର୍‌ ପଚେ ଜିଉଦିମନର୍‌ ଗଟେକ୍‌ ମୁକିଅ ପରବ୍‌ ରଇଲା । ସେଟାର୍‌ ପାଇ ଜିସୁ ଜିରୁସାଲାମ୍‌ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଜିରୁସାଲାମର୍‌ ମେଣ୍ଡା ଦୁଆର୍‌ ଲଗେ ଗଟେକ୍‌ ବନ୍ଦ୍‌ ରଇଲା । ସେଟାକେ ଏବ୍‌ରି ବାସାଇ ବେତେସ୍‌ଦା ବଲି କଇବାଇ । ତେଇ ପାଁଚ୍‌ଟା ମଣ୍ଡପ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ସେ ମଣ୍ଡପ୍‌ ମନର୍‌ଟାନେ କେତେକ୍‌ କେତେକ୍‌ ଜର୍‌ଦୁକା ଅଇଲା ଲକ୍‌ମନ୍‌ ରଇତେ ରଇଲାଇ । ରଗିମନର୍‌ ବିତ୍‌ରେଅନି କାଣା, ଚଟା, ଆରି କେତେକ୍‌ ଅଦୁଆ ରଗିମନ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","କାଇକେବଇଲେ କେଡେ କେଡେବଲ୍‌ ପର୍‌ମେସରର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ଆସିକରି ସେ ବନ୍ଦର୍‌ ପାନି ଅଲ୍‌କା କର୍‌ତେ ରଇଲା । ଆରି ସେ ଅଲ୍‌କା ଅଇଲାପଚେ, ଜନ୍‌ ଲକ୍‌ ପର୍‌ତୁମ୍‌ ଜାଇତେ ରଇଲା, ତାକେ କାଇ ରଗ୍‌ ଅଇରଇଲେ ମିସା ନିମାନ୍‌ ଅଇଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ତାକର୍‌ ବିତ୍‌ରେ ତିରିସ୍‌ ଆଟ୍‌ ବରସ୍‌ ଜାକ ଡୁଲିରଇବା ଗଟେକ୍‌ ରଗି ଲକ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ତେଇ ଜିସୁ ସେ ରଗି ଡୁଲିରଇବାଟା ଦେକି, ଏ ଲକ୍‌ ବେସି ବରସର୍‌ ରଗି ବଲି ଜାନି ତାକେ ପାଚାର୍‌ଲା “ତମେ କାଇ ନିମାନ୍‌ ଅଇବାକେ ମନ୍‍ କଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ସେ ରଗି ଲକ୍‌ ଜିସୁକେ କଇଲା, “ଏ ଆଗିଆଁ ପାନି ଅଲ୍‌କା କଲାବେଲେ, ସେ ବନ୍ଦ୍‌ ବିତ୍‌ରେ ମକେ ନେବାକେ କେ ନାଇ । ଆରି ବନ୍ଦ୍‌ ବିତ୍‌ରେ ଜିବାକେ ଚେସ୍‌ଟା କଲାବେଲେ ବିନ୍‌ ଲକ୍‌ ମର୍‌ ଆଗ୍‌ତୁ ଉଟିଜିବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ଜିସୁ ତାକେ କଇଲା, “ଉଟି ଟିଆଅ, ଆରି ତର୍‌ ଟାଟି ଦାରି ଇଣ୍ଡିଜା ।” ");
INSERT INTO dso_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ସେ ଦାପ୍‌ରେ ସେ ଲକ୍‌ ନିମାନ୍‌ ଅଇଗାଲା ଆରି ନିଜର୍‌ ଟାଟି ଦାରିକରି ଇଣ୍ଡ୍‌ବାର୍‌ ଦାର୍‌ଲା । ସେ ଦିନ୍‌ ବିସ୍‌ରାମ୍‌ବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ସେଟାର୍‌ପାଇ ଜିଉଦି ନେତାମନ୍‌, ନିମାନ୍‌ ଅଇଲା ରଗିକେ କଇବାର୍‌ ଦାର୍‌ଲାଇ, “ଆଜି ବିସ୍‌ରାମ୍‌ ଦିନେ, ତୁଇ ଟାଟି ଦାରି ଜିବାଟା ଆମର୍‌ ନିୟମ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ମାତର୍‌ ସେ ଲକ୍‌ ସେମନ୍‌କେ କଇଲା, “ଜେ ମକେ ନିମାନ୍‌ କଲା ସେ ମକେ ତମର୍‌ ଟାଟିଦାରିକରି ଜା ବଲି କଇଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ସେମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ, “ଜେ ତକେ ଟାଟି ଦାରି ଜା ବଲି କଇଲା, ସେ ଲକ୍‌ କେ ?” ");
INSERT INTO dso_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ମାତର୍‌ ସେ ନିମାନ୍‌ ଅଇଲା ଲକ୍‌ ଜିସୁ କେ ବଲି ଚିନି ନରଇଲା, କାଇକେ ବଇଲେ ସେ ଜାଗାଇ ବେସି ଲକ୍‌ମନ୍‌ ରଇଲାଇଜେ, ଜିସୁ ତେଇଅନି ବିନେ ପିସ୍‌ଲି ଉଟିଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ତାର୍‌ ପଚେ ଜିସୁ ସେ ନିକ ଅଇଲା ଲକ୍‌କେ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ଦେକିକରି କଇଲା, “ଦେକ୍‌ ଏବେ ତୁଇ ନିକ ଅଇଜାଇଆଚୁସ୍‌ । ତୁଇ ଆରି ପାପ୍‌ କାମ୍‌ କର୍‌ନାଇ । ନଇଲେ ତକେ ଆରି ଅଦିକ୍‌ ଦୁକ୍‌ କସ୍‌ଟ ଆଇସି ମିସା ।” ");
INSERT INTO dso_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ତାର୍‌ ପଚେ ସେ ନିକ ଅଇଲା ଲକ୍‌ ଜିଉଦି ନେତାମନର୍‌ ଲଗେ ଜାଇକରି, “ଜେ ତାକେ ନିକ କରିରଇଲା, ସେ ଜିସୁ” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ଏ ନିମାନ୍‌ କାମ୍‌ କଲାଟା, ବିସ୍‌ରାମ୍‌ ବାରେ ଅଇରଇଲା ଜେ, ଜିଉଦି ନେତାମନ୍‌ ଜିସୁକେ ଦୁକ୍‌କସ୍‌ଟ ଦେବାର୍‌ ବସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମର୍‌ବାବା ପର୍‌ମେସର୍‌ ସବୁବେଲା କାମ୍‌କଲାନି, ମୁଇ ମିସା ସେନ୍ତି କାମ୍‌ କଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ଜିସୁ ଏନ୍ତି କଇରଇଲାଜେ ଜିଉଦି ନେତାମନ୍‌ ତାକେ ମରାଇବାକେ ଅଦିକ୍‌ ଚେସ୍‌ଟା କଲାଇ । କାଇକେ ବଇଲେ ଜିସୁ ବିସ୍‌ରାମ୍‌ ବାରର୍‌ ନିୟମ୍‌ ମାନେ ନାଇ ବଲି ନାଇ, ମାତର୍‌ ସେ ପର୍‌ମେସର୍‌କେ ମର୍‌ ବାବା ବଲି କଇ, ନିଜ୍‌କେ ପର୍‌ମେସର୍‌ ସଙ୍ଗ୍‌ ସମାନ୍‌ କରି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ପର୍‌ମେସରର୍‌ ପିଲା ମୁଇ ନିଜେ କାଇଟା ମିସା କରିନାପାରି । ମର୍‌ ବାବା ଜନ୍‌ ଜନ୍‌ଟା ସବୁ କର୍‌ବାଟା ମୁଇ ଦେକ୍‌ଲିନି ସେଟାସେ ମୁଇ କରିପାରି । କାଇକେ ବଇଲେ ବାବା ଜନ୍‌ ଜନ୍‌ଟା ସବୁ କଲାନି ତାର୍‌ପିଲା ମୁଇ ମିସା ସେଟା ସବୁ ସେନ୍ତିସେ କଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ବାବା ମକେ ଆଲାଦ୍‌ କର୍‌ସି ଆରି ନିଜେ ଜନ୍‌ଟା କର୍‌ସି, ସେ ସବୁ ମକେ ଦେକାଇସି । ଆରି ଏବେ ଜାଇଟା ଗଟ୍‌ଲା ଆଚେ, ତାର୍‌ତେଇଅନି ଅଦିକ୍‌ ବଡ୍‌ ବଡ୍‌ କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ ମକେ ଦେକାଇସି । ସେଟା ସବୁ ଦେକି ତମେ ସବୁଲକ୍‌ କାବାଅଇଜାଇସା । ");
INSERT INTO dso_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ବାବା ପର୍‌ମେସର୍‌ ଜେନ୍ତି ମଲାଲକ୍‌ମନ୍‌କେ ଜିବନ୍‌ କରି ଉଟାଇସି, ସମାନ୍‍ ସେନ୍ତି ମୁଇ ମିସା ତାର୍‌ ପିଲା ଜାକେ ଜାକେ ମନ୍‍ କର୍‌ବି, ସେମନ୍‌କେ ମଲାତେଇଅନି ଉଟାଇବି । ");
INSERT INTO dso_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ବାବା ପର୍‌ମେସର୍‌ କାକେ ମିସା ତାର୍‌ ପାପ୍‌ କାମ୍‍ଲାଗି ବିଚାର୍‌ ନ କରେ । ମାତର୍‌ ସବୁ ଲକ୍‌ମନର୍‌ ବିଚାର୍‌ କର୍‌ବା ପୁରାପୁରୁନ୍‌ ଅଦିକାର୍‌ ତାର୍‌ ପିଲା ମକେ, ଦେଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ତେବେ ସବୁ ଲକ୍‌ମନ୍‌ ବାବାକେ ଜେନ୍ତି ସନ୍‌ମାନ୍‌ ଦେଲାଇନି, ସେନ୍ତିସେ ତାର୍‌ ପିଲା ମକେ ମିସା ସନ୍‌ମାନ୍‌ ଦେବାଇ । ଜଦି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତାର୍‌ ପିଲା ମକେ ସନ୍‌ମାନ୍‌ ଦେଅତ୍‌ ନାଇ, ସେମନ୍‌ ମକେ ପାଟାଇଲା ବାବାକେ ମିସା ସନ୍‌ମାନ୍‌ ଦେଅତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜେ ମର୍‌ କାତା ସୁନି ମକେ ପାଟାଇଲା ପର୍‌ମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ସେ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇସି । ଆରି ସେ ବିଚାର୍‌ନା କରାଇ ନ ଅଏ । କାଇକେବଇଲେ ସେ ମରନ୍‌କେ ଜିତି କରି ଜିବନ୍‌ ପାଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି ଏନ୍ତି ଗଟେକ୍‌ ବେଲା ଆଇଲାନି, ସେ ବେଲା ଏବେ କେଟିଆଚେ । ଜେଡେବେଲା ମଲା ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ପିଲା ମର୍‌ କଁଟର୍‌ ସର୍‌ ସୁନ୍‌ବାଇ, ସେମନ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ବାବା ଜେନ୍ତିକି ଜିବନର୍‌ ମୁଲ୍‌, ସେନ୍ତାରିସେ ତାର୍‌ ପିଲା ମୁଇ ମିସା ଜିବନର୍‌ ମୁଲ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ଆରି ମୁଇ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା ଅଇଲାର୍‌ଲାଗି, ସବୁ ଲକ୍‌ମନ୍‌କେ ବିଚାର୍‌ କର୍‌ବା ଅଦିକାର୍‌ ସେ ମକେ ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ତମେ ଏଟାର୍‌ପାଇ କାବା ଉଆନାଇ, ଏନ୍ତି ବେଲା ଆଇଲାନି, ମରିକରି ତପିଅଇଲା ସବୁ ଲକ୍‌ମନ୍‌ ମର୍‌ କଁଟ୍‌ସର୍‌ ସୁନ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ଆରି ସେମନ୍‌ ସମାଦି ଅନି ଆରି ତରେକ୍‌ ଉଟ୍‌ବାଇ । କେ କେ ନିକ କାମ୍‌ କରିଆଚତ୍‌, ସେମନ୍‌ ମଲାଟାନେଅନି ଜିବନ୍‌ ଅଇକରି ଉଟ୍‌ବାଇ । କାରାପ୍‌ କାମ୍‌ କରୁମନ୍‌ ମିସା ମଲାଟାନେଅନି ଉଟ୍‌ବାଇ ଆରି ଦସି ବଲାଇଅଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ମୁଇ ମର୍‌ ନିଜର୍‌ ଅଦିକାରେ କାଇଟା ମିସା କରିନାଇ, ବାବା ମକେ କେନ୍ତି କଇଲା ଆଚେ, ସେନ୍ତିସେ ବିଚାର୍‌ କର୍‌ବି । ଆରି ମୁଇ କର୍‌ବାଟା ଟିକ୍‌ସେ । କାଇକେବଇଲେ ମୁଇ ନିଜେ ମନ୍‌କଲାଟା ପୁରାପୁରୁନ୍‌ କର୍‌ବାକେ ନାଇ, ମାତର୍‌ ମକେ ପାଟାଇଲା ପର୍‌ମେସର୍‌ ମନ୍‌କଲାଟା ପୁରାପୁରୁନ୍‌ କଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ମର୍‌ ନିଜର୍‌ ପାଇ ଜଦି ମୁଇ ସାକି ଦେବି, ସେଟା ସତ୍‌ ବଲି ଦାରା ନ ଜାଏ । ");
INSERT INTO dso_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ମାତର୍‌ ମର୍‌ ପାଇ ଆରି ଗଟେକ୍‌ ଲକ୍‌ ସାକିଦେଲାନି, ଆରି ସେଟା ମୁଇ ଜାନି । ସେ ମର୍‌ ବିସଇ କାଇଟା ସବୁ କଇଲାନି ସେଟା ସବୁ ସତ୍‌ସେ । ");
INSERT INTO dso_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ତମେ ଜଅନ୍‌ ଲଗେ କବର୍‌ ନେଉମନ୍‌କେ ପାଟାଇ ରଇଲାସ୍‌, ଆରି ସେ ତମ୍‌କେ ସତ୍‌ ବିସଇ ସାକି ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ମର୍‌ ବିସଇ କେ ମିସା ସାକି ଦେଅତ୍‌ ବଲି ମୁଇ ମନ୍‌ କରିନାଇ । ଜେନ୍ତିକି ତମେ ପାପେଅନି ରକିଆ ପାଇସା ସେଟାର୍‌ ପାଇ ମୁଇ ଏ ସବୁ କଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଜଅନ୍‌ ଗଟେକ୍‌ ବତିପାରା ଲାଗିକରି ଅଲପର୍‌ ପାଇ ଉଜଲ୍‌ ଦେଇତେରଇଲା । ଆରି ତମେ ସେ ଉଜଲ୍‌, ଅଲପ୍‌ ଦିନର୍‌ ପାଇ ପାଇକରି ସାର୍‌ଦା ଅଇରଇଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ମାତର୍‌ ମର୍‌ଲଗେ, ଜଅନର୍‌ ତେଇଅନି ଅଦିକ୍‌ ବପୁର୍‌ ଗଟେକ୍‌ ସାକି ଆଚେ । ପର୍‌ମେସରର୍‌ ଆଦେସ୍‌ ଇସାବେ ମୁଇ ଜନ୍‌ ସବୁ କାମ୍‌ କଲିନି, ସେଟା ସବୁ ମର୍‌ ପାଇ ନିକ ସାକି । ସେ ସବୁ କଇଲାନିଜେ, ମକେ ପର୍‌ମେସର୍‌ ପାଟାଇଲା ଆଚେ ବଲି । ");
INSERT INTO dso_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ଆରି ମକେ ପାଟାଇଲା ବାବା ପର୍‌ମେସର୍‌ ମିସା ମର୍‌ ବିସଇ ସାକି ଦେଲାନି । ତମେ କେବେ ମିସା ତାର୍‌ କଁଟ୍‌ ସୁନାସ୍‌ ନାଇ, କି ସେ କେନ୍ତାଟା ଦେକାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ଆରି ତାର୍‌ କାତା ତମର୍‌ ମନ୍‌ବିତ୍‌ରେ ର‍ଏନାଇ । କାଇକେବଇଲେ ସେ ଜାକେ ପାଟାଇଲା ଆଚେ ତାକେ ତମେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ତମେ ଜତନ୍‌ସଙ୍ଗ୍‍ ସାସ୍‌ତର୍‌ମନ୍‌ ପଡି କଜ୍‌ଲାସ୍‌ନି । ତେଇଅନି ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇଅଇସି ବଲି ସେ ସବୁ ପଡ୍‌ଲାସ୍‌ନି । ସେ ସବୁ ସାସ୍‌ତର୍‌ ମର୍‌ ବିସଇସେ ସାକି ଦେଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ଏଲେମିସା ତମେ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇବାକେ ମର୍‌ ଲଗେ ଆଇବାକେ ନିଚ୍‌ଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ମୁଇ ମୁନୁସ୍‌ ଲକ୍‌ମନର୍‌ ଟାନେଅନି ଡାକ୍‌ପୁଟା କଜି ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ମୁଇ ଜାନି, ତମେ କେନ୍ତି ରକାମର୍‌ ଲକ୍‌, ତମର୍‌ ମନ୍‌ ବିତ୍‌ରେ ପର୍‌ମେସର୍‌କେ ଆଲାଦ୍‌ କର୍‌ବାଟା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ମୁଇ ମର୍‌ ବାବା ପର୍‌ମେସରର୍‌ ଅଦିକାର୍‌ ପାଇ ଆଇଲିଆଚି । ମାତର୍‌ ତମେ ମକେ ନାମାସ୍‌ ନାଇ । ମାତର୍‌ ଜେଡେବେଲା କେ ମିସା ବିନ୍‌ ଲକ୍‌ ନିଜେ ମନ୍‌କରି ଆଇଲେ ତାକେ ଡାକିନେଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ତମେ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ସନ୍‌ମାନ୍‌ ପାଇବାକେ ମନ୍‌କଲାସ୍‌ନି । ମାତର୍‌ ପର୍‌ମେସରର୍‌ ଆଲାଦ୍‌ ପାଇବାକେ ମନ୍‌ କରାସ୍‌ ନାଇ । ସେନ୍ତି ବଇଲେ ତମେ କେନ୍ତି ମକେ ବିସ୍‌ବାସ୍‌ କରିପାରାସ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ମୁଇ ତମର୍‌ ବିରଦେ ପର୍‌ମେସର୍‌ତେଇ ଦସି କର୍‌ବି ବଲି ତମେ ବାବାନାଇ । ତମେ ଜନ୍‌ଟା ମସାର୍‌ ତେଇ ଆସା କରିଆଚାସ୍‌ ସେ ସେ ତମର୍‌ ବିରଦେ ଦସି କଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ଜଦି ତମେ ମସାକେ ସତ୍‌ବଲି ବିସ୍‌ବାସ୍‌ କଲାସ୍‌ନି ବଇଲେ ମକେ ମିସା ବିସ୍‌ବାସ୍‌ କର୍‌ତେ ରଇସା । କାଇକେବଇଲେ ମସା ମର୍‌ ବିସଇସେ ଲେକିଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ମାତର୍‌ ସେ ଜନ୍‌ଟା ଲେକିଆଚେ, ତେଇ ଜଦି ତମର୍‌ ବିସ୍‌ବାସ୍‌ ନାଇ ବଇଲେ, ମୁଇ ଜନ୍‌ଟା କଇଲିନି, ସେଟା କେନ୍ତି ବିସ୍‌ବାସ୍‌ କର୍‌ସା ?” ");
INSERT INTO dso_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ତାର୍‌ ପଚେ ଜିସୁ ଗାଲିଲି ଗାଡ୍‌ ସେପାଟେ ସେ ଗାଡ୍‌କେ ତିବିରିଆ ଗାଡ୍‌ ବଲି ମିସା କଇବାଇ, ସେ ଜାଗାଇ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ଆରି ବେସି ଲକ୍‌ମନ୍‌ ତାର୍‍ ପଚେ ପଚେ ଗାଲାଇ । କାଇକେ ବଇଲେ ସେ ରଗି ଲକ୍‌ମନ୍‌କେ ତାର୍‌ କାବାଅଇଜିବା ବପୁ ସଙ୍ଗ୍‌ ନିମାନ୍‌ କର୍‌ବାଟା ସେମନ୍‌ ଦେକି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଗଟେକ୍‌ ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ଜାଇ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ସେବେଲେ ଜିଉଦି ମନର୍‌ ନିସ୍‌ତାର୍‌ ପରବ୍‌ କେଟି ଆଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ତାର୍‌ ଲଗେ ବେସି ଲକ୍‌ମନ୍‌ ଆଇବାଟା ଦେକିକରି ଜିସୁ ପିଲିପ୍‌କେ ପାଚାର୍‌ଲା, “ଏତେକ୍‌ମାଣ୍ଡ୍‌ ଲକ୍‌ମନର୍‌ ପାଇ କନ୍ତିଅନି ଜାଇ କାଦି ଗେନିଆନି ଅଇସି ?” ");
INSERT INTO dso_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ମାତର୍‌ ପିଲିପ୍‌କେ ପରିକା କର୍‌ବାକେ ଜିସୁ ଏନ୍ତାରି ପାଚାରି ରଇଲା । କାଇକେ ବଇଲେ ଜିସୁ କାଇଟା କର୍‌ବାକେ ଗାଲାନି ବଲି ସେ ନିଜେ ଜାନିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ପିଲିପ୍‌ ଜିସୁକେ କଇଲା, “ଇତି ରଇଲା ସବୁ ଲକ୍‌ମନ୍‌କେ ଦୁଇସ ତେଇ ଅନି ଅଦିକ୍‌ ରୁପାଟାଙ୍ଗାର୍‌ ରୁଟି ଗେନ୍‌ବାକେ ପଡ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ତେଇ ଆନ୍ଦ୍‌ରିୟ ନାଉଁର୍‌ ଗଟେକ୍‌ ସିସ୍‌ ରଇଲା, ସେ ସିମନ୍‌ ପିତରର୍‌ ବାଇ । ସେ କଇଲା, “ଇତି ଗଟେକ୍‌ ପିଲାର୍‌ ଟାନେ ପାଁଚ୍‌ଟା ରୁଟି ଆରି ଦୁଇଟା ବାଜ୍‌ଲା ସାନ୍‌ ମାଚ୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ମାତର୍‌ ଏତ୍‌କି ଲକର୍‌ପାଇ ସେଟା ନ ଅଏ ।” ");
INSERT INTO dso_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଲକ୍‌ମନ୍‌କେ ଗାଁସ୍‌ ଉପ୍‌ରେ ବସାଆ ।” ସେ ପଡିଆଇ ବେସି ଗାଁସ୍‌ ରଇଲା । ଗାଁସ୍‌ ଉପ୍‌ରେ ସବୁଲକ୍‌ ବସ୍‌ଲାଇ । ଆରି ତେଇ ଅବ୍‌କା ମୁନୁସ୍‌ ପିଲାସେ ପାଁଚ୍‌ ଅଜାର୍‌ ଲକ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ଜିସୁ ରୁଟି ଦାରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲା ଆରି ତେଇ ବସିରଇବା ଲକ୍‌ମନ୍‌କେ ବାଟାକରି ଦେଲା । ସେନ୍ତିସେ ମାଚ୍‌ ମିସା ବାଟାକରି ଦେଲା । ତେଇ ସେମନ୍‌କେ ପେଟ୍‌ ପୁର୍‌ତେ କାଇବାକେ ମିଲ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ସବୁ ଲକ୍‌ମନ୍‌ ପେଟ୍‌ ପୁର୍‌ତେ କାଇଲା ପଚେ, ଜିସୁ ତାର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଅଗଲ୍‌ଲା ମାଚ୍‌ ଆରି ରୁଟି ଗଟେକ୍‌ଟାନେ ଟୁଲିଆଉ, ତେବେ କଣ୍ଡେକ୍‌ ମିସା ନସ୍‌ଟ ନ ଅଏ ।” ");
INSERT INTO dso_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ଲକ୍‌ମନ୍‌ କାଇସାରାଇଲା ପଚେ, ସେ ପାଁଚ୍‌ଟା ରୁଟିଅନି ଜେତ୍‌କି ଅଗଲ୍‌ଲା, ସିସ୍‌ମନ୍‌ ସେଟା ଟୁଲିଆଇ କରି ବାର୍‌ଟା ଡାଲାଇ ବର୍‌ତି କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଜିସୁ କଲା ଏ କାବାଅଇଜିବା କାମ୍‌ ଦେକିକରି ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ କଇଲାଇ “ଏ ଦୁନିଆଇ ପର୍‌ମେସରର୍‌ ଜନ୍‌ ବବିସତ୍‌ବକ୍‌ତା ଆଇବାର୍‌ ରଇଲା, ସତ‍ଇସେ ଏ ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ସେଦାପ୍‌ରେସେ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ରାଜା କରାଇବାକେ ତିଆର୍‌ ଅଇବାଟା ଜାନି, ତେଇଅନି ସେ ଗଟେକ୍‌ ଲକ୍‌ ଡଙ୍ଗର୍‌ ଉପ୍‌ରେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ସେ ଦିନେ ସଞ୍ଜ୍‌ ଅଇଗାଲାକେ ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ ତେଇଅନି ଉତ୍‌ରିକରି ଗାଡେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ସିସ୍‌ମନ୍‌ ଡଙ୍ଗାଇ ବସି ଗାଡ୍‌ ସେପାଟେ ରଇଲା କପର୍‌ନାଉମ୍‌ ଜାଗାଇ ବାଉଡ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ସେଡ୍‌କିବେଲେ ଆନ୍ଦାର୍‌ ଅଇ ଆଇତେ ରଇଲା । ମାତର୍‌ ସେ ବେଲା ଜାକ ଜିସୁ ତାକର୍‌ ଲଗେ ଆସି ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ଆରି ତେଇ ବେସି ବାଉ ପବନ୍‌ ଅଇବାର୍‌ ଦାର୍‌ଲାଜେ ଗାଡେ ବେସି ବଡ୍‌ ବଡ୍‌ ଲଅଡି ଅଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ସେମନ୍‌ ଚଟୁ ଗାଟି ଗାଟି ପାଁଚ୍‌ କି ଚଅ କିଲମିଟର୍‌ ଗାଲା ପଚେ, ଜିସୁ ପାନି ଉପ୍‌ରେ ଇଣ୍ଡି ଇଣ୍ଡି ଡଙ୍ଗା ଲଗେ ଆଇବାଟା ଦେକିକରି ସେମନ୍‌ ବେସି ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଡରାନାଇ, ଏଟା ମୁଇସେ ।” ");
INSERT INTO dso_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ଜିସୁ ଏ କାତା କଇଲା ପଚେ, ସିସ୍‌ମନ୍‌ ତାକେ ବେସି ସାର୍‌ଦା ସଙ୍ଗ୍‌ ଡଙ୍ଗାଇ ଚଗାଇଲାଇ । ଆରି ସେମନ୍‌ ଜନ୍‌ ଜାଗାଇ ଜାଇତେରଇଲାଇ, ସେ ଜାଗାଇ ଦାପ୍‌ରେ ଜାଇ କେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନର୍‌ ସାକାଲେ, ଗାଡ୍‌ ସେପାଟେ ରଇଲା ଲକ୍‌ମନ୍‌ ଜାନିପାର୍‌ଲାଇ ଜେ, ତେଇ ଗଟେକ୍‌ସେ ଡଙ୍ଗା ରଇଲା । ଆରି ସିସ୍‌ମନ୍‌ ଜିସୁକେ ମିସ୍‌ତେ ଡାକି ନ ନେଇ, ଡଙ୍ଗାଇ ବସି ମଜାଗାଡେ ଉଟିଗାଲାଇ ଆଚତ୍‌ ବଲି । ସେମନ୍‍ ତାକେ ଚାଡିକରି ଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ଜନ୍‌ ଜାଗାଇ ମାପ୍‌ରୁ ଜିସୁ ପାର୍‌ତନା କରି ଲକ୍‌ମନ୍‌କେ ରୁଟି କାଇବାକେ ଦେଇରଇଲା, ସେ ଜାଗା ଲଗେ ତିବିରିଆ ଗାଡେଅନି ଆରି କେତେଟା ଡଙ୍ଗା ଆସି କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ସେ ଜାଗାଇ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌କେ ବେଟ୍‌ ନ ଅଇଲାକେ, ଡଙ୍ଗାମନ୍‍କେ ଚଗି ତାକେ କଜି କଜି କପର୍‌ନାଉମ୍‌ ଜାଗାବାଟେ ଜିବାକେ ବାରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଗାଡ୍‌ ସେପାଟେ ବେଟ୍‌ଅଇକରି ପାଚାର୍‌ଲାଇ, “ଏ ଗୁରୁ ତମେ ଇତି କେଡେବଲ୍‌ ଆସି କେଟ୍‌ଲାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ଜିସୁ ସେମନ୍‌କେ କଇଲା, ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ମୁଇ କରିରଇବା କାବାଅଇଜିବା କାମ୍‌ ବୁଜିକରି ମକେ କଜାସ୍‌ ନାଇ । ମାତର୍‌ ତମେ ପେଟ୍‌ ପୁର୍‌ତେ ରୁଟି କାଇରଇଲାସ୍‌ ବଲି ଆସିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ଜନ୍‌ କାଦି ନସିଜାଇସି, ସେ କାଦିର୍‌ ପାଇ ଏତେକ୍‌ କସ୍‌ଟ କରାନାଇ, ମାତର୍‌ ଜନ୍‌ଟା ନ ନସେ, ସେଟା ନ ସାର୍‌ବା ଜିବନ୍‌ ଦେଇସି, ସେଟାର୍‌ ପାଇ କସ୍‌ଟ କରା । ଏ କାଦି ନର୍‌ପିଲା ମୁଇ ଦେବି । କାଇକେ ବଇଲେ, ସେଟାର୍‌ପାଇ ବାବା ପର୍‌ମେସର୍‌ ମକେ ଅଦିକାର୍‌ ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ସେବେଲେ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଜନ୍‍ଟା ପର୍‌ମେସର୍‌ ମନ୍‌ କଲାନି, ସେଟା ଆମେ କର୍‌ବାର୍‌ ଆଲେ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ଜାକେ ପର୍‌ମେସର୍‌ ପାଟାଇଲା ଆଚେ, ତାକେ ତମେ ବିସ୍‌ବାସ୍‌ କଲେ ସେଟା କରିପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ସେବେଲା ସେମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ଏନ୍ତି ବଇଲେ ଆମେ ଜେନ୍ତି ବିସ୍‌ବାସ୍‌ କର୍‌ବୁ, ସେଟାର୍‌ ପାଇ ଆମ୍‌କେ କାଇଆଲେ କାବାଅଇଜିବା କାମ୍‌ କରି ଦେକାଇପାରୁସ୍‌ କି ? କ କାଇଟା କରିପାରୁସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ଆରି ସେମନ୍‌ କଇଲାଇ, “ଆମର୍‌ ଆନିଦାଦିମନ୍‌ ମରୁବାଲି ବୁଏଁ ମାନା କାଦି କାଇରଇଲାଇ, ସେଟା ଆମର୍‌ ଦରମ୍‌ ସାସ୍‌ତର୍‌ ଇସାବେ ପର୍‌ମେସର୍‌ ସେମନ୍‌କେ ସର୍‌ଗେ ଅନି ଦେଇର‍ଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜନ୍‌ଟା ମସା ତମ୍‌କେ ଦେଇରଇଲା, ସେଟା ସର୍‌ଗେଅନି ଆସିରଇଲା କାଦି ନଏଁ । ମାତର୍‌ ମର୍‌ ବାବା ତମ୍‌କେ ସର୍‌ଗେଅନି ସତ୍‌ କାଦି ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ପର୍‌ମେସରର୍‌ କାଦି ଅଇଲାନି ଗଟେକ୍‌ ଲକ୍‌ ଜେ କି ନ ସାର୍‌ବା ଜିବନ୍‌ ଦେବାକେ ସର୍‌ଗେଅନି ଦୁନିଆଇ ଆସିରଇଲା” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ଲକ୍‌ମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ଆଗିଆଁ ସବୁବେଲେ ଆମ୍‌କେ ଏ କାଦି ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ତାର୍‌ ପଚେ ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ସେ ଜିବନର୍‌ କାଦି । ଜନ୍‌ ଲକ୍‌ ମର୍‌ ଲଗେ ଆଇସି, ସେ କେବେ ମିସା ବୁକେ ନ ରଏ । ଆରି କେ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି ତାକେ କେବେ ମିସା ସସ୍‌ ନ ଲାଗେ । ");
INSERT INTO dso_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ମୁଇ ତମ୍‌କେ କଇଲିନି, ତମେ ମକେ ଦେକିକରି ମିସା ବିସ୍‌ବାସ୍‌ କରାସ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ମର୍‌ ବାବା ପର୍‌ମେସର୍‌ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ମକେ ଦେଲା ଆଚେ, ସେ ଲକ୍‌ମନ୍‌ ମର୍‌ ଲଗେ ଆଇବାଇ । ଆରି ମର୍‌ ଲଗେ ଆଇବା ଲକ୍‌ମନ୍‌କେ କେବେ ମିସା ନ ବାଉଡାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","କାଇକେବଇଲେ ମୁଇ ନିଜେ ମନ୍‌ କଲାଟା ପୁରାପୁରୁନ୍‌ କର୍‌ବାକେ ଆସି ନାଇ, ମାତର୍‌ ମକେ ପାଟାଇରଇବା ପର୍‌ମେସରର୍‌ ମନ୍‌କଲାଟା ପୁରାପୁରୁନ୍‌ କର୍‌ବାକେ ସର୍‌ଗେଅନି ଆସିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ସେ ମକେ ଦେଲାଆଚେ, ସେମନର୍‌ ବିତ୍‌ରେଅନି ମୁଇ ଗଟେକ୍‌ ଲକ୍‌କେ ମିସା ନ ଆଜାଇ । ସାରାସାରି ଦିନେ ସେ ସବୁ ଲକ୍‌କେ ଆରିତରେକ୍‌ ଜିବନ୍‌ କରି ଉଟାଇବି । ଏଟା ଆକା ସେ ମନ୍‌ କର୍‌ବାଟା । ");
INSERT INTO dso_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ପର୍‌ମେସରର୍‌ ପିଲା ମୁଇ କେ କେ ମକେ ଦେକ୍‌ବାଇ ଆରି ବିସ୍‌ବାସ୍‌ କର୍‌ବାଇ, ସେମନ୍‌ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇବାର୍‌ ଆଚେ ବଲି ପର୍‌ମେସର୍‌ ମନ୍‌ କଲାନି । ଆରି ମୁଇ ସେମନ୍‌କେ ସାରାସାରି ଦିନେ ମଲାଟାନେଅନି ଜିବନ୍‌ ଅଇକରି ଉଟାଇ ଦେବାର୍‌ ଆଚେ ବଲି ମିସା ପର୍‌ମେସର୍‌ ମନ୍‌ କଲାନି” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ଏଟା ସୁନିକରି ଜିଉଦି ନେତାମନ୍‌ ଜିସୁର୍‌ ବିରଦେ ସେମନର୍‌ ବିତ୍‌ରେ ଦଦାପେଲା ଅଇଲାଇ । କାଇକେ ବଇଲେ, ଜିସୁ ମୁଇ ସର୍‌ଗେ ଅନି ଆସିରଇବା କାଦି ବଲି କଇଲାର୍‌ ପାଇ ସେମନ୍‌ ଏନ୍ତି ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ସେମନ୍‌ କଇଲାଇ “ଏଟା ଜସେପର୍‌ ପିଲା ଜିସୁ ନଏଁ କି ? ଆମେ ତାର୍‌ ଆୟା ବାବାକେ ଜାନି ଆଚୁ । ସେ କେନ୍ତି ‘ମୁଇ ସର୍‌ଗେଅନି ଆସିଆଚି’ ବଲି କଇଲାନି ?” ");
INSERT INTO dso_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ଜିସୁ ସେମନ୍‌କେ କଇଲା, ତମେ ଦଦାପେଲା ଉଆନାଇ, ଚିମ୍‌ରାଇଅଇ ରୁଆ । ");
INSERT INTO dso_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ମକେ ପାଟାଇରଇବା ପର୍‌ମେସର୍‌ ମର୍‌ ଲଗେ ଡାକି ନ ଆନ୍‌ଲେ, କେ ମିସା ମର୍‌ ଲଗେ ଆସିନାପାରତ୍‌ । ଆରି ଜେ ଜେ ଆଇବାଇ, ସେମନ୍‌କେ ମୁଇ ସାରାସାରି ଦିନେ ମଲାଟାନେଅନି ଜିବନ୍‌ କରି ଉଟାଇବି । ");
INSERT INTO dso_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ଦରମ୍‌ ସାସ୍‌ତରେ ଲେକିଆଚତ୍‌, ପର୍‌ମେସର୍‌ଟାନେଅନିସେ ସବୁଲକ୍‌ ସିକ୍‌ବାଇ । କେ ମିସା ବାବାର୍‌ କାତା ସୁନି ତାର୍‌ ସିକିଆ ପାଇସି, ସେ ମର୍‌ଲଗେ ଆଇସି । ");
INSERT INTO dso_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","କେ ମିସା ବାବାକେ ଦେକତ୍‌ନାଇ । ମୁଇ ପର୍‌ମେସରର୍‌ ତେଇଅନି ଆସିଆଚେ, ମୁଇସେ ବାବାକେ ଦେକିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜନ୍‌ ଲକ୍‌ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ସେ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇସି । ");
INSERT INTO dso_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ଉଁ, ମୁଇସେ ଜିବନ୍‌ ଦେବା କାଦି । ");
INSERT INTO dso_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ତମର୍‌ ଆନିଦାଦିମନ୍‌ ମରୁବାଲିବୁଏଁ ମାନା କାଦି କାଇରଇଲାଇ, ଏଲେମିସା ସେମନ୍‌ ମଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ମାତର୍‌ ଜନ୍‌ କାଦି ସର୍‌ଗେଅନି ଆଇସି, ସେଟା ଜେ କାଇଲେ ମିସା, ନ ମରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ମୁଇସେ ସର୍‌ଗେଅନି ଆଇଲା ଜିବନ୍‌ ଦେବା କାଦି । ଏ କାଦି କାଇଲା ଲକ୍‌ମନ୍‌ ସବୁ ଦିନର୍‌ ପାଇ ବଁଚି ରଇବାଇ । ଏ କାଦି ଅଇଲାନି ମର୍‌ ଗାଗଡ୍‌ । ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ କାଲ୍‍କାଲ୍‍ ଜୁଗ୍‌ଜୁଗ୍‌ ବଁଚି ରଇବାକେ ମର୍‌ଗାଗଡ୍‌ ଦେବି ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ଜିସୁ କଇଲା କାତା ସୁନି ଜିଉଦି ନେତାମନ୍‌ ରିସାଅଇ ଆଉଲିଅଇକରି “ଏ ଲକ୍‌ କେନ୍ତି ନିଜର୍‌ ଗାଗଡ୍‌ ଆମ୍‌କେ କାଇବାକେ ଦେଇ ପାରେ ?” ବଲି ଦଦାପେଲା ଅଇ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ସତ୍‌କାତା କଇଲିନି, ପର୍‌ମେସର୍‌ ପାଟାଇ ରଇବା ନର୍‌ପିଲା ମୁଇ, ମର୍‌ ଗାଗଡ୍‌ ଆରି ବନି ନ କାଇଲେ, ଜିବନ୍‌ ମିଲାଇ ନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ ମର୍‌ ଗାଗଡ୍‌ ଆରି ବନି କାଇସି ସେ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇସି । ମୁଇ ସେ ଲକ୍‌କେ ସାରାସାରି ଦିନେ ମଲାଟାନେଅନି ଉଟାଇବି । ");
INSERT INTO dso_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","କାଇକେବଇଲେ, ମର୍‌ ଗାଗଡ୍‌ ଅଇଲାନି ସତ୍‌ କାଦି ଆରି ମର୍‍ ବନି ଅଇଲାନି ସତ୍‌ ପାନି । ");
INSERT INTO dso_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଜନ୍‌ ଲକ୍‌ ମର୍‌ ଗାଗଡ୍‌ ଆରି ବନି କାଇସି, ସେ ମର୍‌ଟାନେ ରଇସି ଆରି ମୁଇ ତାର୍‌ଟାନେ ରଇବି । ");
INSERT INTO dso_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ଜିବନ୍‌ ରଇବା ବାବା ମକେ ପାଟାଇଆଚେ, ଆରି ତାର୍‌ଲାଗି ମୁଇ ବଁଚିଆଚି । ସେନ୍ତାରିସେ ଜେ ମକେ କାଇସି, ମର୍‌ଲାଗି ବଁଚିରଇସି । ");
INSERT INTO dso_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ଏଟାସେ ସର୍‌ଗେଅନି ଆସିରଇବା କାଦି । ଜନ୍‌ କାଦି ତମର୍‌ ଆନିଦାଦିମନ୍‌ କାଇକରି ପଚେ ମଲାଇ, ଏଟା ସେନ୍ତାରି କାଦି ନଏଁ । ଏ କାଦି ଜେ କାଇସି ସେ କାଲ୍‍କାଲ୍‍ ଜୁଗ୍‌ଜୁଗ୍‌ ବଁଚିରଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ଜିସୁ କପର୍‌ନାଉମେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ସିକିଆ ଦେବାବେଲେ ଏ ସବୁ କାତା କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ଜିସୁର୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅନି କେତେକ୍‌ ଲକ୍‌ ଏ କାତା ସୁନିକରି କଇଲା, “ଏ ସିକିଆ ମୁଲ୍‌କେ ବୁଜି ନଇଲାନି । ସେଟାର୍‌ପାଇ କେ ଏଟା ନାମ୍‌ସି ?” ");
INSERT INTO dso_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ଜିସୁକେ ଏ ବିସଇ ନେ‍ଇକରି କେ କାଇବଲି ନ କଇରଇଲେ ମିସା, ସିସ୍‌ମନ୍‌ କୁଆବଲା ଅଇଲାଇନି ବଲି ଜାନିକରି, ସେ ସେମନ୍‌କେ କଇଲା, “ତମେ ଏ କାତା ସୁନି ମନ୍‌ଦୁକ୍‌ କଲାସ୍‌ନି କି ? ");
INSERT INTO dso_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ଏନ୍ତି ବଇଲେ, ନର୍‌ପିଲା ମୁଇ ଜନ୍‌ ଜାଗାଇଅନି ଆସିରଇଲି, ସେ ଜାଗାଇ ଆରି ତରେକ୍‌ ବାଉଡି ଜିବାଟା ଦେକ୍‌ଲେ ତମେ କାଇଟା ବଲି କ‍ଇସା ? ");
INSERT INTO dso_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ପର୍‌ମେସରର୍‌ ଆତ୍‌ମାସେ ଜିବନ୍‌ ଦେଇପାରେ । ମୁନୁସର୍‌ ବପୁ କାଇଟା କରିନାପାରେ । ପର୍‌ମେସରର୍‌ ଜିବନ୍‌ ଦେବା ଆତ୍‌ମା ତମେ ଜେନ୍ତାରିକି ଜାନି ପାର୍‌ସା ? ସେଟାର୍‌ପାଇ ମୁଇ ଏ କାତା କଇଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ମାତର୍‌ ତମର୍‌ ବିତ୍‌ରେଅନି କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ମକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ ।” କାଇକେବଇଲେ ବିସ୍‌ବାସ୍‌ ନ କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ଜିସୁ ଆଗେଅନି ଜାନିରଇଲା । ଆରି ପଚେ ଜନ୍‌ ଲକ୍‌ ତାକେ ସତ୍‌ରୁକେ ସର୍‌ପି ଦେଇସି, ତାକେ ମିସା ଜାନି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ଆରି ଜିସୁ କଇଲା, “ସେଟାର୍‌ ପାଇସେ ମୁଇ ତମ୍‌କେ କଇଲିନି, ଜଦି ବାବା ନ ପାଟାଇଲେ, କେ ମିସା ମର୍‌ ଲଗେ ଆସିନାପାରେ ।” ");
INSERT INTO dso_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ଜିସୁ ଏ କାତା କଇଲାକେ ତାର୍‌ ସଙ୍ଗ୍‍ ଜାଇତେରଇବା ଲକ୍‌ମନର୍‌ତେଇଅନି ବେସିଲକ୍‌ ତାର୍‌ ସଙ୍ଗ୍‌ ଜିବାକେ ମନ୍‌ ନ କରି ଚାଡି ଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ସେବେଲେ ଜିସୁ ତାର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ତମେ ମିସା ମକେ ଚାଡିକରି ଉଟିଜିବାକେ ମନ୍‍ କଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ସିମନ୍‌ ପିତର୍‌ ତାକେ କଇଲା, “ମାପ୍‌ରୁ ତମ୍‌କେ ଚାଡି ଆମେ କାର୍‌ଲଗେ ଜିବୁ ? ତମର୍‌ଟାନେତା ନ ସାର୍‌ବା ଜିବନର୍‌ ବାକିଅ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ତମେତା ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ସୁକଲ୍‌ ଲକ୍‌ ବଲି, ଏବେ ଆମେ ବିସ୍‌ବାସ୍‌ କରି ଜାନ୍‌ଲୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ମୁଇ କାଇ ତମ୍‌କେ ବାର ଲକ୍‌କେ ବାଚି ନାଇ କି ? ଏଲେମିସା ତମର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ସଇତାନର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଇସ୍‌କାରିୟତର୍‌ ପିଲା ଜିଉଦାକେ ଦେକାଇକରି ସେ ଏନ୍ତି କଇରଇଲା । କାଇକେ ବଇଲେ ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅନି ଜିଉଦା ଗଟେକ୍‌ ଲକ୍‌ ଅଇମିସା, ଜିସୁକେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା ସତ୍‌ରୁମନ୍‌କେ ସର୍‌ପି ଦେବାକେ ମନ୍‍ କର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ତାର୍‌ ପଚେ ଜିସୁ ଗାଲିଲି ବାଟେ ବୁଲ୍‌ବାର୍‌ ଗାଲା । ସେ ଜିଉଦା ଦେସେ ଜିବାକେ ମନ୍‌ କରେନାଇ । କାଇକେ ବଇଲେ ଜିଉଦି ନେତାମନ୍‌ ତାକେ ମରାଇବାକେ ଚେସ୍‌ଟା କର୍‌ତେ ରଇଲାଟା, ସେ ଜାନି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ସେ ବେଲେ ଜିଉଦିମନର୍‌ ଗଟେକ୍‌ କୁଡିଆ ପରବ୍‌ ଲଗେ କେଟି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ସେଟାର୍‌ପାଇ ଜିସୁର୍‌ ବାଇମନ୍‌ ତାକେ କଇଲାଇ, “ତୁଇ ଏ ଜାଗା ଚାଡିକରି ଜିଉଦା ଦେସେ ପରବ୍‌ କାଇବାର୍‌ ଜା, ତେବେ ତୁଇ କର୍‌ବା କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ ତର୍‌ ସିସ୍‌ମନ୍‌ ଦେକି ପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ଜେ ଡାକ୍‌ପୁଟା ବଲି ଜାନାଇ ଅଇବାକେ ମନ୍‌କଲାନି, ସେ ନିଜର୍‌ କାମ୍‌ ଲୁଚାଇକରି ନ ସଙ୍ଗଇ ରଏ । ଜେଡେବେଲା ତମେ ଏସବୁ କରିପାର୍‌ଲାସ୍‌ନି ବଇଲେ, ଦୁନିଆର୍‌ ସବୁଲକ୍‌ ତମ୍‌କେ ଜାନ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","କାଇକେ ବଇଲେ ଜିସୁର୍‌ ନିଜର୍‌ ବାଇମନ୍‌ ମିସା ତାକେ ବିସ୍‌ବାସ୍‌ ନ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ଜିସୁ ତାର୍‌ ବାଇମନ୍‌କେ କଇଲା, “ଏବେ ଜାକ ମର୍‌ ସମାନ୍‌ ବେଲା ଆସେ ନାଇତା । ମାତର୍‌ ତମର୍‌ପାଇ ସବୁ ବେଲା ସମାନ୍‌ସେ । ");
INSERT INTO dso_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ତମ୍‌କେ ଗିନ୍‌ ନ କରତ୍‌, ମାତର୍‌ ମକେ ଗିନ୍‌ କର୍‌ବାଇ । କାଇକେ ବଇଲେ ସେମନ୍‌ କର୍‌ବା କାମ୍‌ମନ୍‌ କାରାପ୍‌ ବଲି ମୁଇ ଜାନାଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ତମେ ପରବ୍‌ କର୍‌ବାକେ ଜାଆ, ମୁଇ ଜାଇ ନାପାରି । କାଇକେ ବଇଲେ ଏବେ ଜାକ ମର୍‌ ସମାନ୍‌ ବେଲା ଆସେ ନାଇତା ।” ");
INSERT INTO dso_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଜିସୁ ସେମନ୍‌କେ ଏ ସବୁ କାତା କଇକରି ଗାଲିଲିତେଇସେ ରଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ତାର୍‌ ବାଇମନ୍‌ ପରବ୍‌ ଟାନେ ଗାଲାପଚେ, ଜିସୁ ମିସା ତେଇ ଗାଲା । ସେ ସବୁଲକ୍‌ ଦେକ୍‌ଲାପାରା ନ ଜାଇକରି ଲୁଚ୍‌ତେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ତେବେ ପରବ୍‌ତେଇ ଜିଉଦି ନେତାମନ୍‌, “ଜିସୁ କନ୍ତି ଆଚେ ?” ବଲି ପାଚାରି ପାଚାରି କଜ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ତେଇ ରଇଲା ବେସି ଲକ୍‌ମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ଜିସୁର୍‌ ବିସଇ କାତା ଅଇତେ ରଇଲାଇ । କେତେ ଲକ୍‌ ଜିସୁ ବେସି ନିକ ଲକ୍‌, ବଲି କଇତେ ରଇଲାଇ ମାତର୍‌ ଆରି ଅଦେକ୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ନାଇ, ସେ ଲକ୍‌ମନ୍‌କେ ବୁଲ୍‌ ସିକିଆ ଦେଲାନି, ବଲି କଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ମାତର୍‌ ଜିଉଦି ନେତାମନ୍‌କେ ଡରିକରି କେ ମିସା ଜିସୁର୍‌ ବିସଇ ସବୁଲକ୍‌ ଜାନ୍‌ତେ ସବୁର୍‌ ମୁଆଁଟେ କଅତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ଆରି ପରବ୍‌ ଅଦାଅଦି ସାରିଗାଲା ପଚେ, ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ଜାଇକରି ଲକ୍‌ମନ୍‌କେ ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ତେଇ ଜିଉଦି ନେତାମନ୍‌ କାବାଅଇଜାଇ କରି କଇଲାଇ, “ଏ ଲକ୍‌ ପାଟ୍‌ ନ ପଡି ମିସା କେନ୍ତି ଏତ୍‌କି ବିସଇ ଜାନିଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ସିକାଇଦେବା ଏ ସିକିଆ ମର୍‌ ନିଜର୍‌ଟାନେ ଅନି ନଏଁ, ମାତର୍‌ ମକେ ପାଟାଇରଇବା ପର୍‌ମେସରର୍‌ ତେଇଅନି ଆସିଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଜେ ଜଦି ପର୍‌ମେସର୍‌ ମନ୍‌କଲାଟା ପୁରୁନ୍‌ କର୍‌ବାକେ ମନ୍‍ କର୍‌ସି ବଇଲେ ସେ ଜାନିପାର୍‌ସି, ମୁଇ ଦେଇତେରଇବା ସିକିଆ ପର୍‌ମେସରର୍‌ ଟାନେ ଅନି ଆଇଲାନି କି ସେଟା ମର୍‌ ନିଜର୍‌ ବପୁର୍‌ ସଙ୍ଗ୍‌ କଲିନି ବଲି । ");
INSERT INTO dso_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଜନ୍‌ ଲକ୍‌ ନିଜର୍‌ ଅଦିକାରେଅନି କାତା କଇସି ସେ ନିଜେ ମଇମା ପାଇ ଅଇବାକେ କଇସି । ମାତର୍‌ ଜନ୍‌ଲକ୍‌ ମକେ ପାଟାଇଲା ଲକ୍‌ ସନ୍‌ମାନ୍‌ ପାଅ ବଲି ମନ୍‌ କର୍‌ସି ବଇଲେ, ସେ ମିଚ୍‌ ନ କଇ ସତ୍‌ କାତା କଇସି । ଆରି ତାର୍‌ଟାନେ କାଇ ବୁଲ୍‌ ବିସଇ ନ ରଏ । ");
INSERT INTO dso_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମସା ତମ୍‌କେ ନିୟମ୍‌ ଦେଲା ଆଚେ, ଏଟା ସତ୍‌ । ମାତର୍‌ ତମର୍‌ ବିତ୍‌ରେ କେ ମିସା ଏ ନିୟମ୍‌ ମାନାସ୍‌ ନାଇ । ତମେ କାଇକେ ମକେ ମରାଇବାକେ ଚେସ୍‌ଟା କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ଲକ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ତକେ ଡୁମା ଦାର୍‌ଲା ଆଚେ । କେ ତକେ ମରାଇବାକେ ଚେସ୍‌ଟା କଲାନି ?” ");
INSERT INTO dso_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ଗଟେକ୍‌ ଚକିତ୍‍ ଅଇଜିବା କାମ୍‌ କଲି, ସେଟା ଦେକି ତମେ କାବା ଅଇଗାଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","‘ତମର୍‌ ପିଲାଜିଲାମନ୍‌କେ ସୁନତ୍‌ କରାଆ’ ବଲି ମସା ଆଦେସ୍‌ ଦେଇରଇଲା । ଅଇଲେମିସା ମସା ଏ ନିୟମ୍‌ ଆରାମ୍‌ କରି ନ ରଇଲା । ତମର୍‌ ଆନିଦାଦିମନର୍‌ ବେଲେଅନି ଏଟା ଚଲିଆଇତେରଇଲା ଆରି ତମର୍‌ ପିଲାମନ୍‌କେ ବିସ୍‌ରାମ୍‌ବାରେ ସୁନତ୍‌ କରାଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ଜଦି ବିସ୍‌ରାମ୍‌ବାରେ ଗଟେକ୍‌ ପିଲାକେ ସୁନତ୍‌ କରାଇବାକେ ମସାର୍‌ ନିୟମ୍‌ ମାନାସ୍‌ ନାଇ, ମୁଇ ଜଦି ବିସ୍‌ରାମ୍‌ବାରେ ଗଟେକ୍‌ ଲକ୍‌କେ ପୁରାପୁରୁନ୍‌ ନିକ କଲେ, କାଇକେ ରିସା ଅଇଗାଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ବାଇରର୍‌ ବିସଇ ଦେକିକରି କାଇ ବିଚାର୍‌ କରାନାଇ । ଜନ୍‌ଟା ଟିକ୍, ସେ ଇସାବେ ବିଚାର୍‌ କରା ।” ");
INSERT INTO dso_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ଜିରୁସାଲାମର୍‌ କେତେକ୍‌ ଲକ୍‌ କଇଲାଇ, “ସେ ଜିଉଦି ନେତାମନ୍‌ ଜନ୍‌ ଲକ୍‌କେ ମରାଇବାକେ ଚେସ୍‌ଟା କଲାଇନି, ଏ କାଇ ସେ ଲକ୍‌ ନଏଁଁ କି ? ");
INSERT INTO dso_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ଦେକା, ସବୁଲକର୍‌ଟାନେ ଏତ୍‌କି ସବୁ କଇପାକାଇଲାନି, ମାତର୍‌ ତାକେ ର ବଲିକରି କେ ମିସା ପଦେକ୍‌ କଅତ୍‌ନାଇ । ସତ‍ଇସେ ଏ ପର୍‌ମେସର୍‌ ପାଟାଇଲା ମସିଅ ବଲି ନେତାମନ୍‌ ଜାନିଆଚତ୍‌ କି ? ");
INSERT INTO dso_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ଜେଡେବେଲେ ପର୍‌ମେସର୍‌ ପାଟାଇଲା ମସିଅ ଆଇସି, ସେଡ୍‌କିବେଲେ ସେ କନ୍ତି ଅନି ଆସିଆଚେ ବଲି କେ ମିସା ନାଜାନତ୍‌ । ମାତର୍‌ ଏ ଲକ୍‌ କନ୍ତିଅନି ଆସିଆଚେ, ସେଟା ଆମେ ସବୁ ଜାନୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ଜିସୁ ମନ୍ଦିରେ ସିକିଆ ଦେବାବେଲେ ବେସି ଆଉଲିଅଇ କଇଲା, “ଉଁ ତମେ ମକେ ନିକ ସଙ୍ଗ୍‌ ଜାନିଆଚାସ୍‌ । ସତ‍ଇସେ ମୁଇ କେ ଆରି କନ୍ତିଅନି ଆସିଆଚି ଜାନିଆଚାସ୍‌ କି ? ମାତର୍‌ ମୁଇ ମର୍‌ ନିଜର୍‌ ଅଦିକାରେ ଆସିନାଇ, ମକେ ଜେ ପାଟାଇ ଆଚେ ସେ ସତ୍‌ । ତମେ ତାକେ ନାଜାନାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ମାତର୍‌ ମୁଇ ତାକେ ଜାନି ଆଚି । କାଇକେ ବଇଲେ ମୁଇ ତାର୍‌ତେଇଅନି ଆଇଲି ଆଚି ଆରି ସେ ମକେ ପାଟାଇଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ଜିସୁ ଏ କାତା କଇବାବେଲେ, ସେମନ୍‌ ସୁନିକରି ତାକେ ଦାର୍‌ବାକେ ଚେସ୍‌ଟା କଲାଇ । ମାତର୍‌ କେ ମିସା ଚିଇ ନାପାର୍‌ଲାଇ । କାଇକେ ବଇଲେ ସେଡ୍‌କି ବେଲା ଜାକ ତାର୍‌ ବେଲା କେଟି ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ମାତର୍‌ ତେଇ ରଇଲା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି କେତେକ୍‌ ଲକ୍‌ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କରି କଇଲାଇ, “ମସିଅ ଆଇଲେ ଆର୍‌ଟାନେଅନି ସେ କାଇ ଅଦିକ୍‌ କାବା ଅଇଜିବା କାମ୍‌ କର୍‌ସି କି ? ନାଇ ନ କରେ ।” ");
INSERT INTO dso_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ବିସଇ ତାକର୍‌ ବିତ୍‌ରେ ଏନ୍ତାରି କାତା ଅଇତେ ରଇଲାଟା ପାରୁସି ଦଲର୍‌ କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ସୁନ୍‌ଲାଇ । ତେବେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାରୁସି ଲକ୍‌ମନ୍‌ ଜିସୁକେ ବନ୍ଦି କର୍‌ବାକେ କେତେଟା ମନ୍ଦିର୍‌ ଜାଗୁଆଲ୍‌ମନ୍‌କେ ପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ପଚେ ଜିସୁ କଇଲା, “ମୁଇ ଚନେକ୍‌ସେ ତମର୍‌ ସଙ୍ଗ୍‌ ରଇବି । ତାର୍‌ ପଚେ ମକେ ଜେ ପାଟାଇଲା ଆଚେ, ତାର୍‌ ଲଗେ ବାଉଡି ଜିବି । ");
INSERT INTO dso_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ତମେ ମକେ କଜ୍‍ସା, ମାତର୍‌ ବେଟ୍‌ ନ ଉଆସ୍‌ । ଆରି ମୁଇ ଜନ୍‌ ଜାଗାଇ ରଇବି, ସେ ଜାଗାଇ ତମେ ଆସି ନାପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ଜିଉଦି ନେତାମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କାତା ଅଇଲାଇ “ଏନ୍ତି ବଇଲେ ଏ ଲକ୍‌ କନ୍ତି ଜାଇସିଜେ ଆମେ ତାକେ କଜି ନାପାରୁ । ସେ କାଇ ଗିରିକ୍‌ ନଅରେ ଜାଇକରି ଏନେ ତେନେ ଅଇରଇବା ଆମର୍‌ ଲକ୍‌ମନ୍‌କେ ସିକିଆ ଦେଇସି କି ? ");
INSERT INTO dso_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ସେ କଇଲାନି, ତମେ ମକେ କଜ୍‍ସା ମାତର୍‌ ବେଟ୍‌ ଅଇ ନାପାର୍‌ସା ବଲି । ଆରି ଏନ୍ତି ମିସା କଇଲାନି, ‘ମୁଇ ଜନ୍‌ ଜାଗାଇ ଜିବି, ତେଇ ତମେ ଆସିନାପାରାସ୍‌’ ବଲି । ଏନ୍ତି ବଇଲେ ସେ କଇବା କାତାର୍‌ ଅରତ୍‌ କାଇଟା ?” ");
INSERT INTO dso_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ପରବର୍‌ ସାରାସାରି ଦିନେ, ଜନ୍‌ଟାକି ମୁକିଅ ଦିନେ, ଜିସୁ ଟିଆଅଇ ଆକ୍‌ମାରି କଇଲା, “ଜଦି କାକେ ସସ୍‌ କଲାନି, ସେ ମର୍‌ ଲଗେ ଆସ । ");
INSERT INTO dso_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ଜେ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ସେ ଆସି କାଅ । କାଇକେବଇଲେ ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଏନ୍ତି ଲେକା ଆଚେ, ଜେ ମର୍‌ଟାନେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି ତାର୍‌ ମନ୍‌ ବିତ୍‌ରେଅନି ନ ସାର୍‌ବା ଜିବନ୍‌ ଦେବା ପାନି ଉଚ୍‌ଲି କରି ବାରଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଜିସୁ ଜିବନ୍‌ ଦେବା ପାନି ବଲି ସୁକଲ୍‌ ଆତ୍‌ମାର୍‌ ବିସଇ କଇତେ ରଇଲା । ତାକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ପଚେ ପର୍‌ମେସର୍‌ ଏ ସୁକଲ୍‌ ଆତ୍‌ମା ଦେଇସି । ମାତର୍‌ ଏବେ ଜାକ, କାକେ ଦେଇ ନ ରଇଲାଇ । କାଇକେବଇଲେ ଜିସୁ ସେବେଲା ଜାକ ମଇମାଇ ପୁରାପୁରୁନ୍‌ ନ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ଜିସୁର୍‌ ଏ କାତା ସୁନିକରି କେତେକ୍‌ ଲକ୍‌ କଇଲାଇ, “ ସତ୍‌କାତା, ଏ ଲକ୍‌ ଗଟେକ୍‌ ପର୍‌ମେସର୍‌ ଟାନେଅନି ଆସିରଇବା ବବିସତ୍‌ବକ୍‌ତା !” ");
INSERT INTO dso_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ଆରି ଅଦେକ୍‌ ଲକ୍‌ କଇଲାଇ, “ସେ ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା ମସିଅ” ବଲି । ଆରି ଅଦେକ୍‌ ଲକ୍‌ମନ୍‌ ପାଚାର୍‌ଲାଇ, “ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା ରାଜା ମସିଅ କାଇ ଗାଲିଲି ଦେସେଅନି ନ ଆସେ କି ? ");
INSERT INTO dso_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ସାସ୍‌ତରେ ଏନ୍ତି ଲେକା ଅଇଲା ଆଚେ, ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା ରାଜା ମସିଅ, ଦାଉଦ୍‌ ରାଜାର୍‌ ଜାଗାଇ, ତାର୍‌ କୁଟୁମେ ବେତ୍‌ଲିଇମ୍‌ ଗଡେ ଜନମ୍‌ ଅଇ ଆଇସି । ” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ଏନ୍ତି ସେମନର୍‌ ବିତ୍‌ରେ ଜିସୁର୍‌ ବିସଇନେଇ ବାଗ୍‍ ବାଗ୍‍ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ଆରି ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି କେତେ ଲକ୍‌ ଜିସୁକେ ବାନ୍ଦାଇ ଅ ବଲି ମନ୍‍ କର୍‌ତେରଇଲାଇ । ମାତର୍‌ କେ ମିସା ତାକେ ଦାରି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ଜିସୁକେ ବନ୍ଦି କର୍‌ବାକେ ଜାଇରଇବା ଜାଗୁଆଲ୍‌ମନ୍‌, ବାଉଡିଆଇଲାଇକେ ମୁକିଅ ପୁଜାରି ଆରି ପାରୁସିମନ୍‌ ସେମନ୍‌କେ ପାଚାର୍‌ଲାଇ, “ତମେ କାଇକେ ଜିସୁକେ ବାନ୍ଦି କରି ଆନାସ୍‌ ନାଇ ?” ");
INSERT INTO dso_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ଜାଗୁଆଲ୍‌ମନ୍‌ କ‍ଇଲାଇ, “ଏ ଲକ୍‌ କଇଲା ପାରା କାତା ଆଜିକେଜାକ କେ ମିସା କଅତ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ପାରୁସିମନ୍‌ ସେମନ୍‌କେ କଇଲାଇ, “ଏନ୍ତି ବଇଲେ ତମ୍‌କେ ମିସା ସେ ବକୁଆ କରିଦେଲା କି ?” ");
INSERT INTO dso_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ଆରି ପାଚାର୍‌ଲାଇ, “ଗଟେକ୍‌ ନେତା ନଅଇଲେ ଗଟେକ୍‍ ପାରୁସି ତାକେ ବିସ୍‌ବାସ୍‌ କରିଆଚତ୍‌ ବଲି ତମେ ସୁନିଆଚାସ୍‌ କି ? ");
INSERT INTO dso_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ମାତର୍‌ ଏ ଲକ୍‌ମନ୍‌, ମସାର୍‌ ନିୟମ୍‌ ନାଜାନତ୍‌ । ତେବର୍‌ ପାଇ ଏମନ୍‌ ସବୁ ଅବିସାପ୍‌ ପାଇରଇବା ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ତେଇ ସେ ଦଲେଅନି ନିକଦିମ ନାଉଁର୍‌ ଗଟେକ୍‌ ନେତା ରଇଲା । ସେ ତରେକ୍‌ ଜିସୁକେ ଦେକ୍‌ବାର୍‌ ଜାଇରଇଲା । ସେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ଆମର୍‌ ନିୟମ୍‌ ଇସାବେ ଗଟେକ୍‌ ଲକ୍‌କେ ଦସି କର୍‌ବା ଆଗ୍‌ତୁ ତାର୍‌ କାତା ସୁନ୍‌ବାକେ ପଡ୍‌ସି ଆରି କାଇଟା କଲାଆଚେ କଜ୍‌ବାକେ ପଡ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ବିନ୍‌ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ଏନ୍ତି ବଇଲେ ତୁଇ ମିସା କାଇ ଗଟେକ୍‌ ଗାଲିଲିର୍‌ ଲକ୍‌ କି ? କେ ମିସା ପର୍‌ମେସରର୍‌ ତେଇଅନି ବବିସତ୍‌କାତା କଇବା ଲକ୍‌ ଗାଲିଲିଅନି ଆସତ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ତାର୍‌ ପଚେ ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌ ସେ ଜାଗା ଚାଡିକରି ନିଜର୍‌ ନିଜର୍‌ ଗରେ ବାଉଡି ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ଜିସୁ ଜିତ୍‌ ନାଉଁର୍‌ ଗଚ୍‌ମନ୍‌ ରଇଲା ପର୍‌ବତେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନର୍‌ ସାକାଲେ ସେ ମନ୍ଦିରେ ବାଉଡି ଆଇଲା ଆରି ତେଇ ସବୁଲକ୍‌ ତାର୍‌ଲଗେ ରୁଣ୍ଡ୍‌ଲାଇଜେ, ସେ ବସିକରି ସେମନ୍‌କେ ସିକାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ସେଡ୍‌କିବେଲେ କେତେଟା ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌ ଆରି ପାରୁସିମନ୍‌, ଗଟେକ୍‌ ବେସିଆନି ମାଇଜିକେ ବେସିଆ କାମ୍‌ କର୍‌ବାବେଲେ ଦାରିକରି ଜିସୁର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ତାକେ ସବୁ ଲକର୍‌ ମୁଆଟେ ଟିଆ କରାଇ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, ");
INSERT INTO dso_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ଏ ଗୁରୁ, ଏ ମାଇଜିକେ ବେସିଆ କାମ୍‌ କଲାବେଲେ ଦାରିଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଏନ୍ତାରି ମାଇଜିକେ ପାକ୍‌ନା ସଙ୍ଗ୍‌ ମାରି ମରାଆ ବଲି ମସାର୍‌ ନିୟମେ ଲେକା ଅଇଲା ଆଚେ । ଏନ୍ତି ବଇଲେ ତୁଇ କାଇଟା ବଲି କଇଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ସେମନ୍‌ ଜେନ୍ତିକି ଜିସୁ କଇବା ଉତର୍‌ତେଇଅନି ବୁଲ୍‌ ଦାରି ତାକେ ଦସି କର୍‌ବାକେ ଏ କାତା କଇଲାଇ । ମାତର୍‌ ଜିସୁ ଲଇଁ କରି ଆଙ୍ଗ୍‍ଟି ସଙ୍ଗ୍‌ ବୁଏଁ ଲେକ୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ମାତର୍‌ ସେମନ୍‌ ତାକେ ତର୍‌କେ ତର୍‌ ପାଚାରିଲାଗି ରଇଲାଇ ଜେ ସେ ଟିଆଅଇ କଇଲା, “ ଇତି ମୁଲ୍‌କେ ପାପ୍‌ ନ କଲା ଲକ୍‌ କେ ଆଚାସ୍‌ ବଇଲେ ସେ ଆଗ୍‌ତୁ ଆସିକରି ତାକେ ପାକ୍‌ନା ମାର ।” ");
INSERT INTO dso_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ତାର୍‌ପଚେ ସେ ଆରି ତରେକ୍‌ ଲଇଁକରି ବୁଏଁ ଲେକ୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ଜିସୁର୍‌ ଏ କାତା ସୁନି ମାଇଜିକେ ଆନିରଇବା ସବୁଲକ୍‌ ସେ ଜାଗାଇଅନି ଗଟେକ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ବାରଇ ଉଟିଗାଲାଇ । ପର୍‌ତୁମ୍‌ ଡକ୍‌ରାମନ୍‌ ଗାଲାଇ । ତେଇ ସାରାସାରି ଜାକ ଜିସୁ ଆରି ସେ ମାଇଜିସେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ଜିସୁ ଟିଆଅଇ ତାକେ ପାଚାର୍‌ଲା, “ସେ ଲକ୍‌ମନ୍‌ କେନେ ଗାଲାଇ ? ଇତି କେ ମିସା ତକେ ଦସ୍‌ ଦାର୍‌ବାକେ ନାଇ କି ?” ");
INSERT INTO dso_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ସେ କଇଲା, “ନାଇ ମାପ୍‌ରୁ କେ ମିସା ମକେ ଦସି ବଲି ବିଚାର୍‌ କରତ୍‌ ନାଇ ।” ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ମିସା ତକେ ଦସି ବଲି ବିଚାର୍‌ ନ କରି । ମାତର୍‌ ଜା ଆରି ପାପ୍‌ କର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ଜିସୁ ଆରିତରେକ୍‌ ପାରୁସିମନ୍‌କେ କଇଲା, “ମୁଇସେ ଏ ଦୁନିଆର୍‌ ଉଜଲ୍‌ । ଜନ୍‌ ଲକ୍‌ ମର୍‌ ପଚେ ପଚେ ଆଇସି, ସେ ଜିବନର୍‌ ଉଜଲ୍‌ ପାଇସି । ଆରି କେବେ ମିସା ଆନ୍ଦାରେ ନ ରଏ ।” ");
INSERT INTO dso_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ପାରୁସିମନ୍‌ ତାକେ କଇଲାଇ, “ତୁଇ ନିଜେ ନିଜର୍‌ ବିସଇ ସାକି ଦେଲୁସ୍‌ନି, ସେଟାର୍‌ପାଇ, ତର୍‌ ସାକି ଦେଲାଟା ସତ୍‌ ନଏଁ ।” ");
INSERT INTO dso_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ନାଇ, ମୁଇ ମର୍‌ ନିଜର୍‌ ପାଇ ସାକି ଦେଲେ ମିସା, ମୁଇ ଜନ୍‌ଟା କଇଲିନି ସେଟା ସତ୍‌ସେ । କାଇକେ ବଇଲେ ମୁଇ କନ୍ତିଅନି ଆଇଲି ଆଚି ଆରି କନ୍ତି ଗାଲିନି, ସେଟା ମୁଇସେ ଜାନି । ମାତର୍‌ ମୁଇ କନ୍ତିଅନି ଆଇଲିଆଚି ଆରି କନ୍ତି ଜିବି, ସେଟା ତମେ ନାଜାନାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ଆରି ତମେ ମକେ ଲକ୍‌ମନର୍‌ ଇସାବେ ବିଚାର୍‌ କଲାସ୍‌ନି । ମାତର୍‌ ମୁଇ କାକେ ବିଚାର୍‌ ନ କରି । ");
INSERT INTO dso_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ଜଦି ମୁଇ ବିଚାର୍‌ କର୍‌ତି ବଇଲେ ମର୍‌ ବିଚାର୍‌ ପୁରାପୁରୁନ୍‌ ଟିକ୍‌ ଅଇତା । କାଇକେ ବଇଲେ ମୁଇ ଗଟେକ୍‌ ଲକ୍‌ ନାଇ, ମାତର୍‌ ମକେ ପାଟାଇରଇବା ମର୍‌ ବାବା ମିସା ମର୍‌ ସଙ୍ଗ୍‌ ମିସ୍‌ତେ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","କାଇଆଲେ ଗଟ୍‍ନାର୍‌ ବିସଇ ର‍ଇଲେ, ଦୁଇ ଲକର୍‌ ସାକି ସମାନ୍‌ ଅଇଲାନି ବଇଲେ, ସେମନ୍‌ କଇଲା କାତା ସତ୍‌ସେ । ତମର୍‌ ଦରମ୍‌ ସାସ୍‌ତରେ ଏନ୍ତି ଲେକା ଅଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ମୁଇ ନିଜେ ନିଜର୍‌ ବିସଇ ସାକି ଦେଲିନି, ଆରି ମକେ ପାଟାଇଲା ପର୍‌ମେସର୍‌ ମିସା ମର୍‌ ସାକି ଦେଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ଲକ୍‌ମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ “ତର୍‌ ବାବା କନ୍ତି ଆଚେ ?” ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ମକେ ନାଜାନାସ୍‌ ଆରି ମର୍‌ ବାବାକେ ମିସା ନାଜାନାସ୍‌ । ତମେ ଜଦି ମକେ ଜାନିରଇତାସ୍‌ ବଇଲେ ମର୍‌ ବାବାକେ ମିସା ଜାନ୍‌ତାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ଜିସୁ ମନ୍ଦିରର୍‌ ଦାନ୍‌ ସଙ୍ଗଇବା ପେଡିମନ୍‌ ରଇବା ଆକ୍‌ରାଇ ଏ ସବୁ ବିସଇ ସିକିଆ ଦେଇତେରଇଲା । ଆରି କେ ମିସା ତାକେ ବନ୍ଦି କରି ନାପାର୍‌ଲାଇ । କାଇକେବଇଲେ ତାର୍‌ ବେଲା କେଟି ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଜିସୁ ଲକ୍‌ମନ୍‌କେ ଆରି ତରେକ୍‌ କଇଲା, “ମୁଇ ଗାଲିନି ଆରି ତମେ ମକେ କଜ୍‍ସା । ମାତର୍‌ ନିଜର୍‌ ନିଜର୍‌ ପାପ୍‌ କେମା ନ କରାଇଅଇ ମର୍‌ସା । ଆରି ମୁଇ ଜନ୍‌ ଜାଗାଇ ଜିବି ତମେ ତେଇ ଆସି ନାପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ଜିସୁ ଏନ୍ତି କଇଲାକେ ଜିଉଦି ନେତାମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ସେ କାଇକେ ମୁଇ ଜନ୍‌ ଜାଗାଇ ଗାଲିନି, ତମେ ତେଇ ଜାଇନାପାରାସ୍‌ ବଲି କଇଲାନି ? ଜିସୁ କାଇ ନିଜେ ଉଚ୍‌କି ଅଇ ମର୍‌ବାକେ ମନ୍‍ କଲାନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ତମେ ଏ ଦୁନିଆଇଅନି ଆସିଆଚାସ୍‌ । ମାତର୍‌ ମୁଇ ସର୍‌ଗେଅନି ଆସିଆଚି । ତମେ ଏ ଦୁନିଆର୍‌ ଲକ୍‌, ମାତର୍‌ ମୁଇ ଏ ଦୁନିଆର୍‌ ଲକ୍‌ ନଇ । ");
INSERT INTO dso_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ତମେ ନିଜର୍‌ ନିଜର୍‌ ପାପ୍‌ କେମା ନ କରାଇଅଇତେ ମର୍‌ସା ବଲି ମୁଇ ତମ୍‌କେ କଇରଇଲି । ନିଜେ ମୁଇ ସେ । ଏଟାକେ ବିସ୍‌ବାସ୍‌ ନ କଲେ, ତମେ ନିଜର୍‌ ପାପେ ସେ ମର୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ଜିଉଦି ନେତାମନ୍‌ ପାଚାର୍‌ଲାଇ, “ତୁଇ କେ ? ଆମ୍‌କେ କ ।” ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଆରାମେ ଅନି ମୁଇ କେ ବଲି କଇଆଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ତମେ ପାପ୍‌ କରିରଇବାଟା ଆରି ଦସ୍‌ କରିରଇବା ବିସଇ ମର୍‌ ଟାନେ ବେସି ଆଚେ । କାଇକେବଇଲେ, ଜେ ମକେ ପାଟାଇ ଆଚେ, ତାର୍‌ତେଇ ଅନି ମୁଇ ଜାଇଟା ସୁନି ଆଚି, ସେଟା ସେ ଜାନାଇଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ମାତର୍‌ ଜିସୁ ତାର୍‌ ବାବାର୍‌ ବିସଇ ଏନ୍ତାରି କଇଲାନି ବଲି ସେମନ୍‌ ମୁଲ୍‌କେ ବୁଜି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ସେଟାର୍‌ପାଇ ସେ ସେମନ୍‌କେ କଇଲା, “ତମେ ନର୍‌ପିଲା ମକେ କୁର୍‌ସେ କୁଟି ମାରି ଉଟାଇଲାବେଲେ ଜାନ୍‌ସା, ସେ ନିଜେ ମୁଇ ସେ । ମୁଇ ନିଜର୍‌ ଅଦିକାରେ କାଇଟା କରି ନାପାରି, ମର୍‌ ବାବାର୍‌ ଟାନେଅନି ଜାଇଟା ସିକ୍‍ଲି ଆଚି, ସେଟାସେ କଇଲିନି, ସେଟା ତମେ ବୁଜ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ଜେ ମକେ ପାଟାଇଆଚେ, ସେ ମର୍‌ ସଙ୍ଗ୍‌ ଆଚେ । ସେ ମକେ ଏକ୍‌ଲା ଚାଡି ଦେଏନାଇ, କାଇକେବଇଲେ ସେ ଜାଇଟା ମନ୍‌କଲାନି, ମୁଇ ସେଟାସେ କଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ଜିସୁର୍‌ ଏ ସବୁ କାତା ସୁନି, ବେସି ଲକ୍‌ମନ୍‌ ତାକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ଜିସୁ ତାର୍‌ଟାନେ ବିସ୍‌ବାସ୍‌ କରିରଇବା ଜିଉଦି ଲକ୍‌ମନ୍‌କେ କଇଲା, “ଜଦି ତମେ ମର୍‌ ସିକିଆ ମାନିକରି ତବିର୍‌ ଅଇ ରଇସା, ବଇଲେ ସତ‍ଇସେ ମର୍‌ ସିସ୍‌ ଅଇସା । ");
INSERT INTO dso_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ଆରି ତମେ ସତ୍‌ ବିସଇ ଜାନ୍‌ସା, ସେ ସତ୍‌ ତମ୍‌କେ ମୁକ୍‌ଲାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ଜିଉଦି ଲକ୍‌ମନ୍‌ ତାକେ କଲାଇ, “ଆମେ ଅବ୍‌ରାଆମର୍‌ ନାତିତିତିମନ୍‌, ଆରି ଆମେ କେବେ ମିସା କାର୍‌ ଗତିଅଇ ରଉନାଇ, ଏନ୍ତି ବଇଲେ ତମେ କେନ୍ତି ମୁକଲ୍‌ସା ବଲି କଇଲୁସ୍‌ନି ? ଏ କାତାର୍‌ ଅରତ୍‌ କାଇଟା ?” ");
INSERT INTO dso_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ଜିସୁ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ଜେ ପାପ୍‌ କର୍‌ସି, ସେ ପାପର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା । ");
INSERT INTO dso_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ଗତିଦାଙ୍ଗ୍‌ଡା ଗଟେକ୍‌ ଗରେ ସବୁ ଦିନର୍‌ପାଇ ନ ରଏ । ମାତର୍‌ ସେ ଗରର୍‌ ପିଲାସେ ସବୁଦିନର୍‌ପାଇ ରଇସି । ");
INSERT INTO dso_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ସେଟାର୍‌ପାଇ ମୁଇ ଜଦି ତମ୍‌କେ ମୁକ୍‌ଲାଇବି ବଇଲେ, ସତଇସେ ତମେ ମୁକଲ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ତମେ ଅବ୍‌ରାଅମ୍‌ କୁଟୁମର୍‌ ଲକ୍‌ମନ୍‌ ବଲି ମୁଇ ଜାନିଆଚି, ଅଇଲେ ମିସା ତମର୍‌ ବିତ୍‌ରେଅନି କେତେ ଲକ୍‌ମନ୍‌ ମକେ ମରାଇବାକେ ଚେସ୍‌ଟା କଲାସ୍‌ନି । କାଇକେ ବଇଲେ ମର୍‌ ସିକିଆ ତମେ ମାନାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ମୁଇ ମର୍‌ ବାବା ସଙ୍ଗ୍‌ ରଇଲାବେଲେ ମକେ ସେ ଜାଇଟା ଦେକାଇଆଚେ, ସେଟା ତମ୍‌କେ କଇଲିନି । ମାତର୍‌ ତମର୍‌ ବାବା ତମ୍‌କେ ଜାଇଟା ସିକାଇଆଚେ, ସେଟା କଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ଜିଉଦି ଲକ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ଆମର୍‌ ବାବା ଅବ୍‌ରାଆମ୍ ।” ଜିସୁ କଇଲା, “ତମେ ଜଦି ସତ‍ଇସେ ଅବ୍‌ରାଅମର୍‌ ନାତିତିତି ଅଇରଇତାସ୍‌ ବଇଲେ, ଅବ୍‌ରାମ୍‌ କରିରଇଲା କାମ୍‌ମନ୍‌ କର୍‌ତାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ପର୍‌ମେସର୍‌ ତେଇଅନି ସୁନ୍‌ଲା ସତ୍‌ କାତା ଚାଡି ମୁଇ ଆରି ତମ୍‌କେ କାଇଟା କଇନାଇ । ଅଇଲେ ମିସା ତମେ ମକେ ମରାଇବାକେ ଚେସ୍‌ଟା କଲାସ୍‌ନି । ମାତର୍‌ ଅବ୍‌ରାଆମ୍ ଏନ୍ତାରି କାଇ କାମ୍‌ କରି ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ତମର୍‌ ବାବାମନ୍‌ ଜନ୍‌ କାମ୍‌ମନ୍‌ କରି ରଇଲାଇ, ତମେ ସେଟା କଲାସ୍‌ନି ।” ମାତର୍‌ ଜିଉଦିମନ୍‌ କଇଲାଇ, “ଆମର୍‌ ବାବା ପର୍‌ମେସର୍‌ସେ । ଆମେସେ ତାର୍‌ ପିଲାଟକିମନ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଜଦି ପର୍‌ମେସର୍‌ ତମର୍‌ ବାବା ଅଇରଇଲେ, ତମେ ମକେ ଆଲାଦ୍‌ କର୍‌ତାସ୍‌ । କାଇକେ ବଇଲେ ମୁଇ ପର୍‌ମେସର୍‌ ତେଇଅନି ଆସି ଏବେ ଇତି ଆଚି । ମାତର୍‌ ନିଜର୍‌ ଅଦିକାରେ ଆସିନାଇ । ସେ ମକେ ଏ ଦୁନିଆଇ ପାଟାଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ତମେ କାଇକେ ମର୍‌ କାତା ବୁଜି ନାପାର୍‌ଲାସ୍‌ନି ? କାଇକେ ବଇଲେ ତମେ ମର୍‌ ସିକିଆ ସୁନି ତବିର୍‌ଅଇ ର‍ଇ ନାପାର୍‌ଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ସଇତାନ୍‌ ଅଇଲାନି ତମର୍‌ ବାବା । ଆରି ତମେ ସେ କର୍‌ବା କାରାପ୍‌ କାମ୍‌ମନ୍‌ କର୍‌ବାକେ ମନ୍‌ କଲାସ୍‌ନି । ସେ ଆଗ୍‌ତୁଅନି ଲକ୍‌ମନ୍‌କେ ନସ୍‌ଟ କଲାନି, ଆରି ସେ ସତ୍‌ ବିସଇ ଗିନ୍‌ କଲାନି । ତାର୍‌ତେଇ ସତ୍‌ ବିସଇ ନାଇ । ଜେଡେବେଲା ସେ ମିଚ୍‌ କଇଲାନି, ସେବେଲା ସେ ନିଜର୍‌ ଗୁନ୍‌ ଚଲନ୍‌ଅନି ସେନ୍ତି କଇଲାନି । କାଇକେ ବଇଲେ ସେ ମିଚ୍‌ କଇବା ଲକ୍‌, ଆରି ମିଚ୍‌ କଇବା ଲକ୍‌ମନର୍‌ ବାବା । ");
INSERT INTO dso_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ଏବେ ମୁଇ ସବୁବେଲା ସତ୍‌କାତା କଇଲିନି ମିସା ତମେ ମକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ତମର୍‌ ବିତ୍‌ରେ ଅନି କେମିସା ଗଟେକ୍‌ ଲକ୍‌ ମୁଇ ପାପ୍‌ କଲିଆଚି ବଲି ମକେ ଦସି କରାଇପାରେ କି ? ଆରି ମୁଇ ଜଦି ସତ୍‌କାତା କଇଲିନି ବଇଲେ, ତମେ କାଇଜେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ ନାଇ ? ");
INSERT INTO dso_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଜେତ୍‌କି ଲକ୍‌ ପର୍‌ମେସରର୍‌ ଅଇଲାଇ ଆଚତ୍‌, ସେମନ୍‌ ପର୍‌ମେସରର୍‌ କାତା ସୁନ୍‌ବାଇ । ଆରି ତମେ ପର୍‌ମେସରର୍‌ତେଇଅନି ଆଇଲା ଲକ୍‌ ନୁଆସ୍‌ । ସେଟାର୍‌ପାଇ ତମେ ମର୍‌ ବାକିଅ ସୁନାସ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ଜିଉଦିମନ୍‌ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ତୁଇ ଗଟେକ୍‌ ସମିରଣିୟ ଲକ୍‌, ତକେ ଗଟେକ୍‌ ଡୁମା ଦାର୍‌ଲା ଆଚେ ବଲି ଆମେ କଇଲା କାତା ସତ୍‌ ନଏଁ କି ?” ");
INSERT INTO dso_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ନାଇ ! ମକେ ଡୁମା ଦାରେ ନାଇ । ମୁଇ ମର୍‌ ବାବାକେ ସନ୍‌ମାନ୍‌ ଦେଲିନି । ମାତର୍‌ ତମେ ମକେ ନିନ୍ଦାକାତା କ‍ଇ ଲାଜ୍‌ କରାଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ମୁଇ ନିଜେ ଡାକ୍‌ପୁଟା ପାଇବାକେ ଚେସ୍‌ଟା କରିନାଇ । ମାତର୍‌ ଆରି ଗଟେକ୍‌ ଲକ୍‌ ମକେ ଡାକ୍‌ପୁଟା କରାଇବାକେ ମନ୍‌ କଲାନି । ସେ ଟିକ୍‌ ବାବେ ବିଚାର୍‌ କର୍‌ବା ମାପ୍‌ରୁ । ");
INSERT INTO dso_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ଜେ ମୁଇ ସିକାଇବା କାତା ମାନ୍‌ସି, ସେ କେବେ ମିସା ନ ମରେ ।” ");
INSERT INTO dso_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ସେମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ଏବେ ଆମେ ଜାନ୍‌ଲୁ ତକେ ଗଟେକ୍‌ ଡୁମା ଦାର୍‌ଲା ଆଚେ । ଅବ୍‌ରାଆମ୍ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ମରିଗାଲାଇ ଆଚତ୍‌, ମାତର୍‌ ତୁଇ କଇଲୁସ୍‌ନି ଜଦି କେ ମିସା ମର୍‌ କାତା ମାନ୍‌ସା ବଇଲେ ସେ କେବେ ମିସା ନ ମରେ ବଲି ।” ");
INSERT INTO dso_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ସେମନ୍‌ ପାଚାର୍‌ଲାଇ “ତୁଇକାଇ ଆମର୍‌ ବାବା ଅବ୍‌ରାଆମ୍‌ଟାନେଅନି ବଡ୍‌ ଲକ୍‌କି ? ସେମନ୍‌ ମିସା ମରିଗାଲାଇ ଆଚତ୍‌ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ମିସା ମରିଜାଇଆଚତ୍‌ । ତୁଇ ନିଜ୍‌କେ କେ ବଲି ବାବ୍‌ଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ମୁଇ ଜଦି ନିଜ୍‌କେ ଡାକ୍‌ପୁଟା କର୍‌ବି ବଲି ଚେସ୍‌ଟା କର୍‌ତି ବଇଲେ, ସେ ଡାକ୍‌ପୁଟାର୍‌ କାଇ ମୁଲିଅ ନାଇ । ମର୍‌ ବାବା ଜାକେ କି ତମେ ତମର୍‌ ପର୍‌ମେସର୍‌ ବଲି କଇଲାସ୍‌ନି, ସେ ସେ ମକେ ଡାକ୍‌ପୁଟା କରାଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ତମେ ତାକେ ନାଜାନାସ୍‌, ମାତର୍‌ ମୁଇ ଜାନି । ଜଦି ମୁଇ ତାକେ ନାଜାନି ବଲି କଇବି, ସେନ୍ତାର୍‌ଆଲେ ମୁଇ ମିସା ତମର୍‌ପାରା ମିଚ୍‌ କଇବା ଲକ୍‍ ଅଇବି । ମାତର୍‌ ମୁଇ ତାକେ ଜାନିଆଚି ଆରି, ତାର୍‌ କାତା ମାନ୍‌ଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ମୁଇ ଆଇବା ଦିନ୍‌ ଦେକ୍‌ବି ବଲି ତମର୍‌ ବାବା ଅବ୍‌ରାଆମ୍, ବେସି ଆସା କରି ସାର୍‌ଦା ଅଇତେ ରଇଲା । ଆରି ସେ ଦିନ୍‌କେ ଦେକି କରି ସାର୍‌ଦା ଅଇଲା” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ତାର୍‌ ପଚେ ଜିଉଦିମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ତକେ ପଚାସ୍‌ ବରସ୍‌ ମିସା ଅଏ ନାଇତା, ତୁଇ କାଇ ଅବ୍‌ରାଆମ୍‍କେ ଦେକି ଆଚୁସ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ଅବ୍‌ରାଆମ୍ ଜନମ୍‌ ଅଇବା ଆଗ୍‌ତୁଅନି ମୁଇ ଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ଜିସୁ ଏ କାତା କଇବାବେଲେ ସେମନ୍‌ ତାକେ ମାର୍‌ବାକେ ପାକ୍‌ନା ବେଟ୍‌ଲାଇ, ମାତର୍‌ ଜିସୁ, ମନ୍ଦିରେ ଅନି ବାରଇ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ପୁରି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ଦିନେକ୍‌ ଜିସୁ ଜିବାବେଲେ ଗଟେକ୍‌ ଜନ୍‌ମେଅନି କାଣା ରଇଲା ଲକ୍‌କେ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ, “ଏ ଗୁରୁ କେ ପାପ୍‌ କଲାଇଜେ ଏ ଲକ୍‌ କାଣାଅଇ ଜନମ୍‌ ଅଇଲା ? ସେ ନିଜେ କି ତାର୍‌ ବାବା ମାଆର୍‌ ପାପର୍‌ ଲାଗି ?” ");
INSERT INTO dso_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ଜିସୁ କ‍ଇଲା, “ତାର୍‌ କି ତାର୍‌ ବାବା ମାଆର୍‌ କାଇ ପାପ୍‌ଦସ୍‌ ନାଇ । ପର୍‌ମେସରର୍‌ ବପୁ ତାର୍‌ଟାନେ ଜାନାପଡ୍‌ସି ବଲି, ସେ କାଣା ଅଇ ଜନମ୍‌ ଅଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ବେଲ୍‌ ରଇତେସେ ମକେ ପାଟାଇରଇବା ପର୍‌ମେସରର୍‌ କାମ୍‌ ଆମେ କର୍‌ବାର୍‌ ଆଚେ । ଏନ୍ତି ଆନ୍ଦାର୍‌ ଆଇଲାନି ସେ ବେଲାଇ କେ ମିସା କାଇ କାମ୍‌ କରି ନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ମୁଇ ଜେତେ ଦିନ୍‌ ଜାକ ଏ ଦୁନିଆଇ ରଇବି ସେତ୍‌କି ଦିନ୍‌ ଜାକ ଏ ଦୁନିଆର୍‌ ଉଜଲ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଜିସୁ ଏ କାତା କଇଲା ପଚେ, ମାଟିତେଇ ତୁକି ସେ ତୁକ୍‌ ସଙ୍ଗ୍‌ କାଦ ଚକଟ୍‌ଲା । ଆରି ସେ କାଦ ନେଇକରି କାଣାର୍‌ ଦୁଇଟା ଆଁକିତେଇ ଲିପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ଆରି ତାକେ କଇଲା, “ତୁଇ ଜା ଆରି ସିଲଅ ନାଉଁର୍‌ ବନ୍ଦେ ଜାଇକରି ମୁ ଦଇ ଆଉ ।” ସିଲଅର୍‌ ଅରତ୍‌ ଅଇଲାନି ପାଟାଇଲାଟା । ତାର୍‌ ପଚେ ସେ ଲକ୍‌ ବନ୍ଦେ ଜାଇକରି ମୁ ଦଇଲାଜେ, ଦେକିପାର୍‌ଲା ଆରି ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ଏ ଲକ୍‌କେ ଆଗ୍‌ତୁ ବିକ୍‌ ମାଙ୍ଗ୍‌ବାଟା ଦେକି ରଇଲାଇ । ସେଟାର୍‌ ପାଇ ଏ ଲକ୍‌ମନ୍‌ ଆରି କାଣାର୍‌ ଗର୍‌ ଲଗର୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ଦେକି କଇଲାଇ, “ଜନ୍‌ ଲକ୍‌କି ସବୁବେଲା ବସିକରି ବିକ୍‌ ମାଙ୍ଗ୍‌ତେ ରଇଲା ସେ କାଇ ଏ ଲକ୍‌ ନଏଁ କି ?” ");
INSERT INTO dso_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","କେତେ ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ଉଁ ଏତାଉ ସେ ଲକ୍‌ସେ ।” ମାତର୍‌ ଆରି ଅଦେକ୍‌ ଲକ୍‌ କଇଲାଇ, “ନାଇ ଏ ସେ ଲକ୍‌ ନଏଁ ମାତର୍‌ ତାର୍‌ ପାରା ଡିସ୍‌ଲାନି ।” ମାତର୍‌ କାଣା କଇଲା, “ମୁଇସେ ଆଗ୍‌ତୁ କାଣା ଅଇରଇଲି ।” ");
INSERT INTO dso_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ଲକ୍‌ମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ, “ଏନ୍ତି ବଇଲେ ତୁଇ କେନ୍ତି ଦେକିପାର୍‌ଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","କାଣା ସେମନ୍‌କେ କଇଲା, “ଲକ୍‌ମନ୍‌ ଜନ୍‌ ଲକ୍‌କେ ଜିସୁ ବଲି କଇଲାଇନି, ସେ କାଦ କରି ମର୍‌ ଆଁକିତେଇ ଲିପିଦେଲା । ତାର୍‌ପଚେ ସେ ମକେ ‘ସିଲଅ ନାଉଁର୍‌ ବନ୍ଦେ ଜାଇକରି ଦ’ ବଲି କଇଲା । ପଚେ ମୁଇ ଜାଇକରି ବନ୍ଦେ ମୁ ଦଇଲା ଦାପ୍‌ରେ ଦେକି ପାର୍‌ଲି ।” ");
INSERT INTO dso_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ଆରି ଲକ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ସେ କନ୍ତି ଆଚେ ?” ସେ “ମୁଇ ନାଜାନି” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ତାର୍‌ ପଚେ ଲକ୍‌ମନ୍‌ ଆଗେଅନି କାଣା ଅଇରଇଲା ଲକ୍‌କେ ପାରୁସିମନର୍‌ ଲଗେ ଡାକିନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ଜିସୁ ଜନ୍‌ ଦିନେ କାଦ ଲିପିକରି ତାର୍‌ ଆଁକି ନିକ କରିରଇଲା, ସେ ଦିନ୍‌ ବିସ୍‌ରାମ୍‌ବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ପାରୁସି ଲକ୍‌ମନ୍‌ ତାକେ ଆରିତରେକ୍‌ ପାଚାର୍‌ଲାଇ, “ତୁଇ କେନ୍ତାର୍‌ ଦେକିପାର୍‌ଲୁସ୍‌ନି ?” ତେଇ ସେ ସେମନ୍‌କେ କଇଲା, “ଜିସୁ ମର୍‌ ଆଁକିଟାନେ କାଦ ଲାଗାଇଦେଲା । ପଚେ ମୁଇ ମୁ ଦଇ ଆଇଲି ଆରି ଏବେ ଦେକି ପାର୍‌ଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","କେତେଟା ପାରୁସିମନ୍‌ କଇଲାଇ, “ଏ ଲକ୍‌ ପର୍‌ମେସରର୍‌ ତେଇଅନି ଆସେ ନାଇ । ସେଟାର୍‌ ପାଇଁ ସେ ବିସ୍‌ରାମ୍‌ ଦିନର୍‌ ନିୟମ୍‌ ମାନେନାଇ ।” ଆରି ଅଦେକ୍‌ ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ଗଟେକ୍‌ ପାପି ଲକ୍‌ କେବେ ମିସା ଏନ୍ତି କାବାଅଇଜିବା କାମ୍‌ କରିନାପାରେ ।” ଏନ୍ତି ଜିଉଦି ଲକ୍‌ମନ୍‌ ଦୁଇ ବାଗ୍‌ ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ସେ ଲକ୍‌କେ ଆରି ତରେକ୍‌ ପାଚାର୍‌ଲାଇ, “ତକେ ଜିସୁ ନିମାନ୍‌ କଲାଜେ ଦେକି ପାର୍‌ଲୁସ୍‌ନି । ଏନ୍ତି ବଇଲେ ତୁଇ ତାକେ କେ ବଲି ବାବ୍‌ଲୁସ୍‌ନି ?” ସେ ଲକ୍‌ ସେମନ୍‌କେ କଇଲା, “ସେ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ।” ");
INSERT INTO dso_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ଜିଉଦି ନେତାମନ୍‌ ସେ ନିମାନ୍‌ ଅଇଲା ଲକ୍‌ ଆଗ୍‌ତୁ କାଣା ରଇଲା ଜେ ଏବେ ସେ ଦେକିପାର୍‌ବା ବିସଇ ମୁଲ୍‌କେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ନାଇ । ପାରୁସିମନ୍‌ ସେ ଲକର୍‌ ମାଆ ବାବାକେ ନ ଡାକ୍‌ବା ଜାକ ମୁଲ୍‌କେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ସେମନ୍‌ ତାର୍‌ ମାଆ ବାବାକେ ପାଚାର୍‌ଲାଇ, “ଏଟା ତମର୍‌ ପିଲା କି ? ସେ ଜନ୍‌ମେ ଅନି କାଣାଟା ବଲି ତମେ କଇଲାସ୍‌ନି, ଏନ୍ତି ବଇଲେ ସେ କେନ୍ତି ଦେକିପାର୍‌ଲାନି ?” ");
INSERT INTO dso_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ତାର୍‌ ମାଆ ବାବା କଇଲାଇ, “ଉଁ ଏଟା ଆମର୍‌ ପିଲା । ସେ ଜନ୍‌ମେଅନି କାଣା ରଇଲା ବଲି ଆମେ ଜାନି ଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ମାତର୍‌ ଏବେ ସେ କେନ୍ତି ଦେକିପାର୍‌ଲାନି ଆରି କେ ତାକେ ନିମାନ୍‌ କଲା ସେଟା ଆମେ ନାଜାନୁ । ସେ ଏବେ ବଡ୍‌ ଅଇଲା ଆଚେ ତାକେ ପାଚାରା ସେ ନିଜେ କଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ତାର୍‌ ମାଆ ବାବା ଜିଉଦି ନେତାମନ୍‌କେ ଡରି ଏନ୍ତି ବଲି କଇଦେଲାଇ । କାଇକେ ବଇଲେ ଜିସୁକେ ଜଦି ମସିଅ ବଲି କଇସି ବଇଲେ ତାକେ ପର୍‌ମେସର୍‌କେ ଉପାସନା କର୍‌ବା ଗର୍‌ ବିତ୍‌ରେ ଜିବାକେ ନ ଦେଅତ୍‌ ବଲି ଆଗ୍‌ତୁସେ କଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ସେଟାର୍‌ପାଇ ସେ ମାଆ ବାବା କଇଲାଇ, “ସେ ତ ବଡ୍‌ ଅଇଲା ଆଚେ, ତାକେ ପାଚାରା ।” ");
INSERT INTO dso_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ସେମନ୍‌ ସେ ଲକ୍‌କେ ଆରି ତରେକ୍‌ ବିତ୍‌ରେ ଡାକି କରି ପାଚାର୍‌ଲାଇ, “ପର୍‌ମେସର୍‌କେ ରାନ୍‌ ପାକାଇ କ । ଜିସୁ ଗଟେକ୍‌ ପାପି ଲକ୍‌ ବଲି ଆମେ ଜାନୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ତାର୍‌ ପଚେ ସେମନ୍‌କେ ସେ କଇଲା, “ସେ ପାପି ଲକ୍‌କି ନଏଁ ସେଟା ମୁଇ ଜାନି ନାଇ । ମାତର୍‌ ମୁଇ ଗଟେକ୍‌ ବିସଇ ଜାନି ଆଚି ସେଟା ଅଇଲାନି, ମୁଇ ଆଗ୍‌ତୁ କାଣା ରଇଲି, ଏବେ ଦେକି ପାର୍‌ଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ଜିଉଦି ନେତାମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ, “ସେ ତକେ କାଇଟା କଲା ? କେନ୍ତି ତର୍‌ ଆଁକି ପିଟାଇଦେଲା ?” ");
INSERT INTO dso_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ସେ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ଆଗ୍‌ତୁସେ କଇ ସାରାଇଆଚି, ମାତର୍‌ ତମେ ମାନ୍‌ବାକେ ମନ୍‌ କରାସ୍‌ ନାଇ । ଏବେ ଆରି ତରେକ୍‌ କାଇକେ ପାଚାର୍‌ଲାସ୍‌ନି ? ତମେ ମିସା କାଇ ତାର୍‌ ସିସ୍‌ ଅଇବାକେ ମନ୍‌କଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ସେମନ୍‌ ସାଇପ୍‌ ଦେଇ କଇଲାଇ, “ତୁଇ କାଇ ତାର୍‌ ସିସ୍‌ ଅଇସୁ, ଆମେ ନଉଁ, ଆମେ ମସାର୍‌ ସିସ୍‌ମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ପର୍‌ମେସର୍‌ ମସାର୍‌ତେଇ କାତା ଅଇରଇଲାଟା ଆମେ ଜାନିଆଚୁ, ମାତର୍‌ ଏ ଲକ୍‌ କନ୍ତିଅନି ଆଇଲାଆଚେ, ସେଟା ନାଜାନୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ତାର୍‌ ପଚେ ସେ ଲକ୍‌ ଜିଉଦି ନେତାମନ୍‌କେ କଇଲା, “ଏଟା ଗଟେକ୍‌ ବେସି ବଡ୍‌ କାବାଅଇଜିବା ବିସଇ । ସେ ଲକ୍‌ ମର୍‌ ଆଁକି ନିମାନ୍‌ କଲାଆଚେ, ମାତର୍‌ ସେ କନ୍ତିଅନି ଆଇଲା ଆଚେ, ସେଟା ତମେ ନାଜାନୁ ବଲି କଇଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ପାପି ଲକ୍‌ମନର୍‌ ପାର୍‌ତନା ପର୍‌ମେସର୍‌ ନ ସୁନେ ବଲି ସବୁ ଲକ୍‌ମନ୍‌ ଜାନିଆଚତ୍‌ । ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ ପର୍‌ମେସର୍‌କେ ଜୁଆର୍‌ କରି ସେ ମନ୍‌କଲା ଇସାବେ ଚଲାଚଲ୍‌ତି କଲାନି, ସେ ତାର୍‌ କାତା ସୁନ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ଦୁନିଆ ଆରାମେଅନି, ଜନ୍‌ମେ ଅନି କାଣା ରଇଲା ଗଟେକ୍‌ ଲକ୍‌କେ ଆଁକି ଡିସାଇବାଟା ଏବେ ଜାକ ମିସା ନ ସୁନିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଏ ଲକ୍‌ ଜଦି ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆସି ନ ରଇଲେ, କେବେ ମିସା ଏ କାମ୍‌ କରିନାପାର୍‌ତା । ");
INSERT INTO dso_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ସେବେଲା ଜିଉଦି ନେତାମନ୍‌ କ‍ଇଲାଇ, “ତୁଇ ପାପେ ଜନମ୍‌ ଅଇକରି ପୁରାପୁରୁନ୍‌ ପାପେ ବୁଡି ଆଚୁସ୍‌ । ତେଇଅନି ତୁଇ ବାଅଡ୍‌ । ଆମ୍‌କେ ସିକାଇଲୁସ୍‌ନି ?” ଏନ୍ତି କଇକରି ସେମନ୍‌ ତାକେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେଅନି ବାର୍‌କରାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ଜିସୁ ସେ ଲକ୍‌କେ ପାର୍‌ତନା ଗରେ ଅନି ବାର୍‌ କରାଇ ଦେଲାଟା ସୁନି ଆରିତରେକ୍‌ ତାକେ ଦେକାଇଅଇ, ପାଚାର୍‌ଲା, “ତୁଇ ପର୍‌ମେସର୍‌ ତେଇଅନି ଆଇଲା ନର୍‌ପିଲାକେ ବିସ୍‌ବାସ୍‌ କଲୁସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ସେ କାଣା ଲକ୍‌ କଇଲା, “ଏ ଆଗିଆଁ ସେ ଲକ୍‌ କେ ? ମୁଇ ତାକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ତାକେ ଦେକିଆଚୁସ୍‌, ଆରି ଏବେ ଜନ୍‌ ଲକର୍‌ ସଙ୍ଗ୍‌ କାତା ଅଇଲୁସ୍‌ନି, ସେ ଆକା ସେ ଲକ୍‌।” ");
INSERT INTO dso_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ସେବେଲାଇ ସେ କଇଲା, “ମାପ୍‌ରୁ ମୁଇ ତକେ ବିସ୍‌ବାସ୍‌ କଲିନି ।” ଆରି ଜିସୁର୍‌ ମୁଆଟେ ମାଣ୍ଡିକୁଟା ଦେଇ ଜୁଆର୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ଜିସୁ କଇଲା, “ମୁଇ ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌କେ ବିଚାର୍‌ କର୍‌ବାର୍‌ ଆସିଆଚି । ସେଟାର୍‌ ପାଇ କାଣା ଲକ୍‌ମନ୍‌ ଦେକିପାର୍‌ବାଇ, ଆରି ଦେକିପାର୍‌ବା ଲକ୍‌ମନ୍‌ କାଣା ଅଇଜିବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ଜିସୁ ଏନ୍ତି କଇବା କାତା, ଲଗେ ରଇଲା କେତେଟା ପାରୁସି ଲକ୍‌ମନ୍‌ ସୁନିକରି ତାକେ ପାଚାର୍‌ଲାଇ, “ଏନ୍ତି ବଇଲେ ଆମ୍‌କେ କାଇ କାଣା ଲକ୍‌ମନ୍‌ ବଲି ବାବ୍‌ଲୁସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ତମେ କାଣା ଅଇରଇତାସ୍‌ ଆଲେ ଦସି ନ ଅଇତାସ୍‌ । ମାତର୍‌ ଦେକି ପାର୍‌ଲୁନି ବଲି କଇଲାସ୍‌ନିଜେ ଅଦିକ୍‌ ଦସି ।” ");
INSERT INTO dso_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ଜିସୁ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜେ ଦୁଆର୍‌ ବାଟେ ନ ଜାଇ ବିନ୍‌ବାଟେ ଜାଇ ମେଣ୍ଡାସାଲେ କେଟ୍‌ସି, ସେ ଚର୍‌ ଆରି କାଙ୍ଗାର୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ମାତର୍‌ ଜେ ଦୁଆର୍‌ ବାଟେ ଜାଇ ମେଣ୍ଡାସାଲେ କେଟ୍‌ସି, ସେ ମେଣ୍ଡା ରାସିର୍‌ ଗଉଡ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ଜାଗୁଆଲ୍‌ ଦୁଆର୍‌ ଉଗାଡି ଦେଇସି ଆରି ନାଉଁ ଦାରି ଡାକ୍‌ସି । ମେଣ୍ଡାମନ୍‌ ତାର୍‌ ଡାକ୍‌ଲାଟା ସୁନ୍‌ବାଇ, ଆରି ସେମନ୍‌କେ ବାର୍‌କରାଇ ଦାରିଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ନିଜର୍‌ ସବୁ ମେଣ୍ଡାମନ୍‌କେ ବାଇରେ ଆନ୍‌ବା ବେଲେ, ସେ ଆଗେ ଆଗେ ଇଣ୍ଡ୍‌ସି ଆରି ମେଣ୍ଡାମନ୍‌ ତାର୍‌ ପଚେ ପଚେ ଜିବାଇ । କାଇକେବଇଲେ ମେଣ୍ଡାମନ୍‌ ତାର୍‌ ଡାକ୍‌ଲାଟା ଜାନତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ମାତର୍‌ ମେଣ୍ଡାମନ୍‌ କେବେ ମିସା ନ ଚିନ୍‌ଲା ଲକର୍‌ ପଚ୍‌ ପଚ୍‌ ନ ଜାଅତ୍‌, ତାର୍‌ଲଗେଅନି ପାଲାଇବାଇ । କାଇକେବଇଲେ ସେମନ୍‌ ଅଚିନାର୍‌ ଲକ୍‌ ଡାକ୍‌ଲେ ନ ଜାଅତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଜିସୁ ସେମନ୍‌କେ ଏନ୍ତି ଉଦାଅରଣ୍‌ ଦେଇ କଇଲା, ମାତର୍‌ ସେମନ୍‌ ତାର୍‌ ଅରତ୍‌ କାଇଟା ବଲି ବୁଜି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ସେଟାର୍‌ ପାଇ ଜିସୁ ଆରିତରେକ୍‌ କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି ମୁଇ ମେଣ୍ଡାମନର୍‌ ଡିଆଗଡି । ");
INSERT INTO dso_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ମର୍‌ ଆଗ୍‌ତୁ ଜେତେଲକ୍‌ ଆସିଆଚତ୍‌, ସେମନ୍‌ ସବୁଲକ୍‌ ଜାକ ଚର୍‌ ଆରି କାଙ୍ଗାର୍‌ମନ୍‌, ସେଟାର୍‌ପାଇ ମେଣ୍ଡାମନ୍‌ ତାକର୍‌ କାତା ମୁଲ୍‌କେ ସୁନତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ମୁଇ ଦୁଆର୍‌, ଜଦି କେ ମିସା ମର୍‌ ବାଟେ ଆସି କେଟ୍‌ସି ବଇଲେ, ସେ ରକିଆପାଇସି, ଆରି ସେ ବିତ୍‌ରେ ଆରି ବାଇରେ ଜାଇ ଚାରି ପାର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ଚର୍‌, ଚରାଇବାକେ, ମରାଇବାକେ, ଆରି ନାସ୍‌ କର୍‌ବାକେସେ ଆଇସି, ମାତର୍‌ ମୁଇ ଜେନ୍ତିକି ସେମନ୍‌କେ ପୁରାପୁରୁନ୍‌ ଜିବନ୍‌ ଦେବାକେ ଆଇଲି ଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ମୁଇ ନିମାନ୍‌ ମେଣ୍ଡା ଚାରାଉ ଗଉଡ୍‌ । ନିମାନ୍‌ ଗଉଡ୍‌ ମେଣ୍ଡାମନର୍‌ ଲାଗି ନିଜର୍‌ ଜିବନ୍‌ ମିସା ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ଜେ ମେଣ୍ଡା ଚାରାଉ ନଏଁ, ମାତର୍‌ ବୁତି ପାଉ, ମେଣ୍ଡାମନ୍‌ ତାର୍‌ ନିଜର୍‌ଟା ନଅତ୍‌, ସେଟାର୍‌ପାଇ ଡୁର୍‌କା ଆଇବାଟା ଦେକି ମେଣ୍ଡାମନ୍‌କେ ଚାଡି ପାଲାଇସି । ଆରି ଡୁର୍‌କା ମେଣ୍ଡାମନ୍‌କେ ଦାରି ଚିନ୍‌ ଚତର୍‌ କରିଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ଜେ ବୁତି ମିଲବଲି ମେଣ୍ଡା ଚାରାଇସି, ସେ ମେଣ୍ଡାମନ୍‌କେ ଚାଡି ଉଟିଜାଇସି । କାଇକେବଇଲେ ସେ ମେଣ୍ଡାମନର୍‌ ପାଇ ଚିନ୍ତା ନ କରେ । ");
INSERT INTO dso_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ମୁଇ ନିକ ମେଣ୍ଡା ଚାରାଉ । ବାବା ଜେନ୍ତାରି ମକେ ଜାନେ, ମୁଇ ମିସା ସେନ୍ତି ବାବାକେ ଜାନି, ");
INSERT INTO dso_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ସେନ୍ତାରିସେ ମୁଇ ମର୍‌ ନିଜର୍‌ ମେଣ୍ଡାମନ୍‌କେ ଜାନି । ଆରି ମେଣ୍ଡାମନ୍‌ ମିସା ମକେ ଜାନତ୍‌ । ମୁଇ ସେମନର୍‌ ଲାଗି ମର୍‌ ଜିବନ୍‌ ଦେବାକେ ମିସା ରାଜି । ");
INSERT INTO dso_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ଏନ୍ତାରି ମର୍‌ ବିନ୍‌ ମେଣ୍ଡାମନ୍‌ ଆଚତ୍‌ । ସେମନ୍‌ ଏ ରାସି ଟାନେ ନାଇ, ମକେ ସେମନ୍‌କେ ମିସା ଆନ୍‌ବାକେ ପଡ୍‌ସି । ସେମନ୍‌ ମୁଇ ଡାକ୍‌ବାଟା ସୁନ୍‌ବାଇ ଆରି ତେଇର୍‌ ଗଟେକ୍‌ ରାସି ଅଇ ରଇବାଇ । “ ");
INSERT INTO dso_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ମର୍‌ ବାବା ମକେ ଆଲାଦ୍‌ କଲାନି, କାଇକେବଇଲେ ମୁଇ ମର୍‌ ଜିବନ୍‌ ଦେବାକେ ମନ୍‌ କଲିନି । ଆରି ମର୍‌ ଜିବନ୍‌ ଦାନ୍‌ କର୍‌ବି ବଇଲେ ଆରିତରେକ୍‌ ସେଟା ପାଇବି । ");
INSERT INTO dso_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ମର୍‌ ଜିବନ୍‌ ବିନ୍‌ ଲକ୍‌ ନେଇ ନାପାରତ୍‌ । ସେଟା ମୁଇ ନିଜେ ମନ୍‌କରି ଦାନ୍‌ କର୍‌ବି କି ଆରିତରେକ୍‌ ଆନ୍‌ବାକେ ମିସା ମର୍‌ ଅଦିକାର୍‌ ଆଚେ । ମର୍‌ ବାବା ମକେ ଏ ଅଦିକାର୍‌ ଦେଇଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଜିସୁର୍‌ ଏ ସବୁ କାତାର୍‌ ଲାଗି ଜିଉଦିମନ୍‌ ବାଗ୍‌ ବାଗ୍‌ ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ସେମନର୍‌ ବିତ୍‌ରେ କେତେକ୍‌ ଲକ୍‌ କଇବାର୍‌ ଦାର୍‌ଲାଇ, “ତାକେ ଡୁମା ଦାରିଆଚେ, ସେ ବାୟାଟା, କାଇକେ ତାର୍‌ କାତା ସୁନ୍‌ଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ମାତର୍‌ ବିନ୍‌ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ଏ ସବୁ କାତା ତା ଡୁମା ଦାରି ରଇବା ଲକ୍‌ କଇନାପାରେ । ଡୁମା କାଇ କାଣା ଲକର୍‌ ଆଁକି ନିମାନ୍‌ କରିଦେଇପାରେ କି ?” ");
INSERT INTO dso_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ସେ ବେଲେ ସିତ୍‌ ଦିନ୍‌ ଅଇରଇଲା ଆରି ଜିରୁସାଲାମ୍‌ ମନ୍ଦିର୍‌ ତିଆର୍‌ କଲା ପରବ୍‌ ଅଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ତେଇ ଜିସୁ ମନ୍ଦିରେ ସଲ୍‌ମନର୍‌ ମଣ୍ଡପେ ବୁଲ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ତେଇ ଜିଉଦିମନ୍‌ ତାକେ ଚାରିବେଟ୍‌ତିଅନି ଡାବିଅଇ ପାଚାର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ, “ଆରି କେତେ ଦିନ୍‌ ଜାକ ଆମ୍‌କେ ନାଡାଇସୁ ? ତମେ ଜଦି ପର୍‌ମେସର୍‌ ବାଚି ପାଟାଇଲା ରାଜା ମସିଅ ଅଇରଇଲେ ଆମ୍‌କେ ସତ୍‌ କାତା କ ।” ");
INSERT INTO dso_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ମୁଇ ତମ୍‌କେ ପର୍‌ତୁମ୍‌ କଇଆଚି, ମାତର୍‌ ମକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ନାଇ । ମର୍‌ ବାବାର୍‌ ଅଦିକାରେ ମୁଇ ଜନ୍‌ ଜନ୍‌ କାମ୍‌ମନ୍‌ କଲିଆଚି, ସେ ସବୁଜାକ ମର୍‌ ବିସଇର୍‍ ସାକି ଦେଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ମାତର୍‌ ତମେ ମକେ ବିସ୍‌ବାସ୍‌ କରାସ୍‌ନାଇ, କାଇକେବଇଲେ ତମେ ମର୍‌ ମେଣ୍ଡାମନ୍‌ ନୁଆସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ମର୍‌ ସବୁ ମେଣ୍ଡାମନ୍‌ ମୁଇ ଡାକ୍‌ବାଟା ସୁନ୍‌ବାଇ, ମୁଇ ସେମନ୍‌କେ ଜାନି, ଆରି ସେମନ୍‌ ମର୍‌ ପଚେ ପଚେ ଆଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ଆରି ମୁଇ ସେମନ୍‌କେ ନ ସାର୍‌ବା ଜିବନ୍‌ ଦେବି । ସେମନ୍‌ କେବେମିସା ନସ୍‌ଟ ନ ଅଅତ୍‌ । ସେମନ୍‌କେ ମର୍‌ ଆତେଅନି କେ ମିସା ଚାଡାଇ ନେଇ ନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ମର୍‌ ବାବା ମକେ ଜନ୍‌ଟା ଦେଲାଆଚେ, ସେଟା ସବୁର୍‌ଟାନେଅନି ଅଦିକ୍‌ ମୁଲିଅ । ବାବାର୍‌ ଆତେଅନି ସେଟା କେ ମିସା ଚାଡାଇ ନେଇ ନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ବାବା ଆରି ମୁଇ ଗଟେକ୍‌ ସେ ।” ");
INSERT INTO dso_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ଏ କାତା ସୁନି ଲକ୍‌ମନ୍‌ ତାକେ ଆରିତରେକ୍‌ ମାର୍‌ବାକେ ପାକ୍‌ନା ବେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ମୁଇ ବାବାର୍‌ ଆଦେସ୍‌ ଇସାବେ ତମ୍‌କେ କେତେକ୍‌ କେତେକ୍‌ ନିମାନ୍‌ କାମ୍‌ ଦେକାଇ ଆଚି, ସେ ସବୁ ନିମାନ୍‌ କାମ୍‌ ବିତ୍‌ରେଅନି, କନ୍‌ କାମର୍‌ପାଇ ମକେ ମାର୍‌ବାକେ ପାକ୍‌ନା ବେଟିଆଚାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ସେମନ୍‌ ତାକେ କଇଲାଇ, “ନିମାନ୍‌ କାମର୍‌ ଲାଗି ତକେ ଆମେ ମାର୍‌ବାକେ ପାକ୍‌ନା ବେଟୁନାଇ, ମାତର୍‌ ପର୍‌ମେସର୍‌କେ ନିନ୍ଦା କଲୁସ୍‌ନି ବଲିକରି, ଆରି ତୁଇ ମନସ୍‌ ଅଇକରି ନିଜ୍‌କେ ପର୍‌ମେସର୍‌ ବଲାଇଅଇବାର୍‌ ଲାଗି ।” ");
INSERT INTO dso_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ତମର୍‌ ରିତିନିତି ଟାନେ କାଇ ଏଟା ଲେକାନାଇ କି ? ପର୍‌ମେସର୍‌ କଇଲା ତମେ ପର୍‌ମେସର୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ଆମେ ଜାନୁ ସାସ୍‌ତରର୍‌ ବାକିଅ ସବୁ ଦିନର୍‌ ପାଇ ସତ୍‌ । ପର୍‌ମେସରର୍‌ ବାକିଅ ଜନ୍‌ଲକ୍‌ମନ୍‌ ଜାନିଆଚତ୍‌, ସେମନ୍‍କେ ପର୍‌ମେସର୍‌ ବଲି କୁଆ ଅଇଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ବାବା ମକେ ବାଚିକରି ଏ ଦୁନିଆଇ ପାଟାଇଆଚେ, ସେନ୍ତାର୍‌ ଆଲେ ମୁଇ ନିଜ୍‌କେ ପର୍‌ମେସରର୍‌ ପ ବଲି କଇଲାକେ, ତମେ ମକେ କେନ୍ତି ପର୍‌ମେସର୍‌କେ ନିନ୍ଦା କଲୁସ୍‌ନି ବଲି କଇଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ମୁଇ ଜଦି ମର୍‌ ବାବାର୍‌ କାମ୍‌ ନ କରି, ସେନ୍ତାର୍‌ଆଲେ ମକେ ବିସ୍‌ବାସ୍‌ କରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ଜଦି ମୁଇ ସେ ମନ୍‌କଲାଟା ପୁରାପୁରୁନ୍‌ କର୍‌ବି ବଇଲେ, ମକେ ବିସ୍‌ବାସ୍‌ ନ କଲେମିସା ମୁଇ କର୍‌ବା କାମ୍‌ ବିସ୍‌ବାସ୍‌ କରା । ସେଟାର୍‌ ପାଇ ତମେ ଜାନିପାରାସ୍‌ ଜେ, ମର୍‌ ବାବା ପର୍‌ମେସର୍‌ ମର୍‌ ସଙ୍ଗ୍‌ ଆଚେ ଆରି ମୁଇ ତାର୍‌ଟାନେ ଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ସେମନ୍‌ ଆରିତରେକ୍‌ ଜିସୁକେ ଦାର୍‌ବାକେ ଚେସ୍‌ଟା କଲାଇ, ମାତର୍‌ ଜିସୁ ସେମନ୍‌କେ ଦାରାଇ ନ ଅଇକରି କସ୍‌ରି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ତାର୍‌ପଚେ ସେ ଆରିତରେକ୍‌ ଜର୍‌ଦନ୍‌ ଗାଡର୍‌ ସେପାଟେ ଉଟିଜାଇକରି ଆଗେ ଜଅନ୍‌ ଜନ୍‌ ଜାଗାଇ ଡୁବନ୍‌ ଦେଇ ରଇଲା, ସେ ଜାଗାଇ ଜାଇକରି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ଆରି ବେସିଲକ୍‌ମନ୍‌ ତାର୍‌ଲଗେ ଆସିକରି କଇଲାଇ, “ଜଅନ୍‌ ସିନା କାଇ କାବାଅଇ ଜିବା କାମ୍‌ କରି ନ ରଇଲା, ମାତର୍‌ ଏ ଲକର୍‌ ବିସଇନେଇ ଜଅନ୍‌ ଜେତ୍‌କି କାତା କଇରଇଲା, ସେ ସବୁ ସତ୍‌ ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ଆରି ସେ ଜାଗାଇ ବେସି ଲକ୍‌ମନ୍‌ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେତ୍‌ନିଆ ଗଡେ ଲାଜାର୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ଜର୍‌ ଅଇରଇଲା । ମରିୟମ୍‌ ଆରି ତାର୍‌ ବଇନି ମାର୍‌ତା ସେ ଗାଏଁ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ଏ ମରିୟମ୍‌ ଅଇଲାନି, ଜନ୍‌ ମାଇଜି କି ବେସି ଦାମ୍‌ଦେବା ବାସ୍‌ନା ଚିକନ୍‌ ଜିସୁର୍‌ ପାଦେ ରକଇକରି ତାର୍‌ ଚେଣ୍ଡିସଙ୍ଗ୍‌ ପୁଚିଦେଇରଇଲା । ତାର୍‌ ବାଇ ଲାଜାର୍‌କେ ଆକା ଜର୍‌ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ସେଟାର୍‌ପାଇ ତାର୍‌ ବଇନିମନ୍‌ ଜିସୁର୍‌ ଲଗେ କବର୍‌ ପାଟାଇଲାଇ, “ମାପ୍‌ରୁ ତମେ ଜାକେ ଆଲାଦ୍‌ କଲାସ୍‌ନି, ସେ ବେସି ଜର୍‌ ଅଇଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ମାତର୍‌ ଜିସୁ ଏ କାତା ସୁନିକରି କଇଲା, “ଏ ଜର୍‌ ମର୍‌ବାପାଇ ଅଏ ନାଇ, ମାତର୍‌ ପର୍‌ମେସରର୍‌ ମଇମାର୍‌ ପାଇ । ସେଟାର୍‌ ଲାଗି, ତାର୍‌ ପଅ, ମୁଇ ମିସା ମଇମା ପାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଜିସୁ, ମାର୍‌ତା, ତାର୍‌ ବଇନି ଆରି ଲାଜାର୍‌କେ ବେସି ଆଲାଦ୍‌ କର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ସେଟାର୍‌ପାଇ ଲାଜାର୍‌ ନିକ ନ ରଇବା କବର୍‌ ପାଇ ଜିସୁ ଜନ୍‌ ଜାଗାଇ ରଇଲା, ସେ ଜାଗାଇ ଆରି ଦୁଇଦିନ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ତାର୍‌ ପଚେ ସେ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଆସା, ଆମେ ଆରିତରେକ୍‌ ଜିଉଦା ଦେସେ ବାଉଡି ଜୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ସିସ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ଏ ଗୁରୁ, ତମ୍‌କେତା କେତେ ଦିନ୍‌ ଆଗେ, ଲକ୍‌ମନ୍‌ ପାକ୍‌ନା ସଙ୍ଗ୍‌ ମାର୍‌ବାକେ ଚେସ୍‌ଟା କର୍‌ତେରଇଲାଇ, ତମେ ଆରିତରେକ୍‌ ତେଇ ଜିବାକେ ମନ୍‌ କଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଜିସୁ କ‍ଇଲା “ଗଟେକ୍‌ ଦିନେ କାଇ ବାର ଗଁଟା ଉଜଲ୍‌ ନ ରଏ କି ? ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଦିନ୍‌ବେଲାର୍‌ ଉଜ୍‌ଲେ ରଇବାଇ, ସେମନ୍‌ ଜଟିଆଇ ନ ଅଅତ୍‌, କାଇକେବଇଲେ ସେମନ୍‌କେ ଏ ଜଗତର୍‌ ଉଜଲ୍‌ ଡିସ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ମାତର୍‌ ରାତିଆ ଇଣ୍ଡ୍‌ଲେ ଜଟିଆଇ ଅଇବାଇ । କାଇକେବଇଲେ ସେମନର୍‌ଟାନେ ଉଜଲ୍‌ ନ ରଏ ।” ");
INSERT INTO dso_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଜିସୁ ଏ ସବୁ କାତା କଇଲା ପଚେ, ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଆମର୍‌ ସବୁଲକର୍‌ ମଇତର୍‌ ଲାଜାର୍‌ ଏବେ ସଇଆଚେ, ତାକେ ମୁଇ ଉଟାଇବାର୍‌ ଗାଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ତେଇ ସିସ୍‌ମନ୍‌ ଜିସୁକେ କଇଲାଇ, “ମାପ୍‌ରୁ, ଜଦି ସେ ସଇଲାଆଚେ ବଇଲେ ନିକ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ଜିସୁ ଲାଜାରର୍‌ ମରନ୍‌ ବିସଇ ନେଇକରି କଇରଇଲା, ମାତର୍‌ ସିସ୍‌ମନ୍‌ ଲାଜାର୍‌କେ ଗୁନର୍‌ଲାଗି ସଇଲା ବିସଇ କଇଲାନି ବଲି ବାବ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ସେଟାର୍‌ପାଇ ଜିସୁ ସେମନ୍‌କେ ନିକ ସଙ୍ଗ୍‌ ବୁଜ୍‌ଲା ପାରା କଇଲା, “ଲାଜାର୍‌ ମରିଗାଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ଆରି ମୁଇ ତେଇ ନ ରଇଲି, ସେଟାର୍‌ପାଇ ତମର୍‌ ସଙ୍ଗ୍‌ ସାର୍‌ଦା କଲିନି, ଜେନ୍ତାରିକି ତମେ ବିସ୍‌ବାସ୍‌ କର୍‌ସା । ମାତର୍‌ ଆସା, ଏବେ ଆମେ ତାକେ ଜାଇ ଦେକୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ତେଇ ତମା ନାଉଁର୍‌ ଜାକେ କି ବିଦୁମ୍‌ ବଲି କଇବାଇ, ସେ ତାର୍‌ ସଙ୍ଗର୍‌ ସିସ୍‌ମନ୍‌କେ କଇଲା, “ଜୁ ଆମେ ମିସା ଗୁରୁର୍‌ ସଙ୍ଗ୍‌ ଜାଇ ତାର୍‌ସଙ୍ଗ୍‌ ମରୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଜିସୁ ବେତ୍‌ନିଆଇ କେଟିକରି ସୁନ୍‌ଲା ଜେ ଲାଜାର୍‌କେ ସମାଦି ଦେଇ ଚାର୍‌ଦିନ୍‌ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ଜିରୁସାଲାମ୍‌ ଅନି ବେତ୍‌ନିଆ ତିନ୍‌ କିଲମିଟର୍‌ ତେଇଅନି ଉନାର୍‌ ବାଟ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ଆରି ଜିଉଦିମନର୍‌ ତେଇଅନି କେତେକ୍‌ କେତେକ୍‌ ଲକ୍‌ମନ୍‌ ମାର୍‌ତା ଆରି ମରିୟମ୍‌ ଲଗେ ତାର୍‌ ମରିଜାଇରଇବା ବାଇର୍‌ ବିସଇ ସାଁତାଇବାକେ ଆସିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ଜିସୁ ଆଇଲାନି ବଲି ସୁନ୍‌ଲା ଦାପ୍‌ରେ ମାର୍‌ତା ତାକେ ବେଟ୍‌ଅଇବାର୍‌ ଗାଲା । ମାତର୍‌ ମରିୟମ୍‌ ଗରେସେ ବସିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ମାର୍‌ତା ଜିସୁକେ କଇଲା, “ମାପ୍‌ରୁ ତମେ ଜଦି ଇତି ରଇତାସ୍‌ ବଇଲେ, ମର୍‌ ବାଇ ନ ମର୍‌ତା । ");
INSERT INTO dso_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ମାତର୍‌, ମୁଇ ଜାନି ଆଚି । ଏବେ ମିସା ତମେ ପର୍‌ମେସର୍‌କେ ଜାଇଟା ମାଙ୍ଗ୍‌ଲେ, ସେଟା ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଜିସୁ ତାକେ କଇଲା, “ତର୍‌ ବାଇ ଆରି ଜିବନ୍‌ ଅଇ ଉଟ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମାର୍‌ତା ଜିସୁକେ କଇଲା, “ସେ ସାରାସାରି ଦିନେ ଆରିତରେକ୍‌ ଉଟ୍‌ବା ବେଲାଇ ଉଟ୍‌ସି, ଏଟା ମୁଇ ଜାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ଜିବନ୍‌ ଆରି ମରିକରି ଆରିତରେକ୍‌ ଉଟ୍‌ବା ଲକ୍‌ । ଜେ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ସେ ମଲେ ମିସା, ବଁଚ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ଆରି ଜେ ଜଦି ବଁଚି ରଇକରି ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ସେ କେବେ ମିସା ନ ମରେ । ଏ କାତା ବିସ୍‌ବାସ୍‌ କଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ମାର୍‌ତା ଜିସୁକେ କଇଲା, “ଉଁ ମାପ୍‌ରୁ, ମୁଇ ବିସ୍‌ବାସ୍‌ କଲିନି । ତମେ ସେ ପର୍‌ମେସରର୍‌ ପ । ଜନ୍‌ ମସିଅ ଏ ଜଗତେ ଆଇବାର୍‌ ରଇଲା, ତମେ ସେ ଆକା ।” ");
INSERT INTO dso_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ଏ ସବୁ କାତା କଇସାର୍‌ଲାପଚେ ମାର୍‌ତା ଜାଇକରି ନିଜର୍‌ ବଇନିକେ କେ ନ ସୁନ୍‌ଲାପାରା ଡାକି କଇଲା, “ଆଉ ଗୁରୁ ଆସିଆଚେ ଆରି ତକେ ଡାକ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ମରିୟମ୍‌ ଏ କାତା ସୁନିକରି ଦାନ୍ଦା ପାନ୍ଦା ଅଇ ଜିସୁକେ ବେଟ୍‌ ଅଇବାର୍‌ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ଜିସୁ ସେଡ୍‌କିବେଲା ଗାଉଁ ବିତ୍‌ରେ ଆସି ନ ରଇଲା, ମାତର୍‌ ମାର୍‌ତା ତାକେ ଜନ୍‌ ଜାଗାଇ ବେଟ୍‌ ଅଇରଇଲା, ତେଇସେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ମରିୟମ୍‌ ଉଟିକରି ଦାନ୍ଦା ପାନ୍ଦା ଅଇ ବାଇରେ ସାଁତାଇବାକେ ଆସିରଇଲା ଲକ୍‌ମନ୍‌ ଦେକ୍‌ଲାଇ, ସେମନ୍‌ ମିସା ତାର୍‌ ପଚେ ପଚେ ଗାଲାଇ । ସେମନ୍‌ ବାବ୍‌ଲାଇ, ସେ କବର୍‌ ଲଗେ କାନ୍ଦ୍‌ବାର୍‌ ଗାଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ତେଇ ଜିସୁ ଜନ୍‌ ଜାଗାଇରଇଲା, ମରିୟମ୍‌ ସେ ଜାଗାଇ କେଟ୍‌ଲା ଆରି ଜିସୁକେ ଦେକିକରି ତାର୍‌ ପାଦେ ଡାଣ୍ଡାସନ୍‌ ପଡି କଇଲା, “ମାପ୍‌ରୁ ତମେ ଜଦି ଇତି ରଇତାସ୍‌ଆଲେ ମର୍‌ ବାଇ ନ ମର୍‌ତା ।” ");
INSERT INTO dso_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ମରିୟମ୍‌ ତାକେ ଆରି ତାର୍‌ ସଙ୍ଗ୍‌ ରଇବା ଲକ୍‌ମନ୍‌ କାନ୍ଦ୍‌ତେରଇବାଟା ଦେକି ଜିସୁ ଆତ୍‌ମାଇ ବେସି ମନ୍‌ଦୁକ୍‌ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ସେ ପାଚାର୍‌ଲା, “ତାକେ କନ୍ତି କବର୍‌ ଦେଇଆଚାସ୍‌ ?” ସେମନ୍‌ ତାକେ କଇଲାଇ, “ମାପ୍‌ରୁ ଆସିଦେକା ।” ");
INSERT INTO dso_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଜିସୁ କାନ୍ଦ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ତେଇ ଜିଉଦି ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ଦେକା, ସେ ଲାଜାର୍‌କେ କେନ୍ତି ଆଲାଦ୍‌ କର୍‌ତେରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ମାତର୍‌ ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେକ୍‌ ଲକ୍‌ କଇଲାଇ, “ଏ ଲକ୍‌ ଜନ୍‌ କାଣାକେ ଆଁକି ଡିସାଇରଇଲା, ସେ ମନ୍‌କଲେ କାଇ ଏ ଲାଜାରର୍‌ ମରନ୍‌ ମିସା ତେବାଇ ନାପାର୍‌ତା କି ?” ");
INSERT INTO dso_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ତେଇ ଆରିତରେକ୍‌ ଜିସୁ ମନ୍‌ ବିତ୍‌ରେ କିଲ୍‌ବିଲ୍‌ ଅଇ ସମାଦି ଲଗେ ଗାଲା । ସମାଦିଟାନେ ଗଟେକ୍‌ ପାଆର୍‌ ଆରି ପାଆର୍‌ ମୁଆଟେ ଗଟେକ୍‌ ବଡ୍‌ ପାକ୍‌ନା ଡାବିଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ଜିସୁ ତିଆର୍‌ଲା, “ଏ ପାକ୍‌ନା ଗୁଚାଇଦିଆସ୍‌ ।” ମରିଜାଉ ଲାଜାରର୍‌ ବଇନି ମାର୍‌ତା କଇଲା, “ମାପ୍‌ରୁ ସେଟା କୁଇକରି ଗନ୍ଦି ଗାଲାବେ, କାଇକେବଇଲେ, ତାକେ କବର୍‌ଦେଇ ଚାର୍‌ଦିନ୍‌ ଅଇଗାଲା ।” ");
INSERT INTO dso_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ଜିସୁ ମାର୍‌ତାକେ କଇଲା, “ତୁଇ ଜଦି ବିସ୍‌ବାସ୍‌ କର୍‌ସୁ ବଇଲେ ପର୍‌ମେସରର୍‌ ମଇମା ଦେକ୍‌ସୁ ବଲି ମୁଇ ତକେ କଇ ନ ର‍ଇଲି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ତେଇ ସେମନ୍‌ ପାକ୍‌ନା ଗୁଚାଇଲାଇ । ଜିସୁ ସରଗ୍‌ବାଟେ ମୁ କରି କଇଲା, “ବାବା ତମେ ମର୍‌ ପାର୍‌ତନା ସୁନ୍‌ଲାସ୍‌ ବଲି ମୁଇ ତମ୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ତମେ ଜେଡେବେଲେ ମିସା ମର୍‌ ପାର୍‌ତନା ସୁନ୍‌ସା, ଏଟା ମୁଇ ଜାନି, ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଏ ଚାରିବେଡ୍‌ତି ଟିଆଅଇ ଆଚତ୍‌, ସେମନ୍‌ ଜେନ୍ତିକି ତମେଆକା ମକେ ପାଟାଇଆଚାସ୍‌ ବଲି ବିସ୍‌ବାସ୍‌ କର୍‌ବାଇ, ଏଟାର୍‌ ପାଇ ମୁଇ ଏନ୍ତିବଲି କଇଲି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଏନ୍ତି କଇ ସାରାଇ ଜିସୁ ଆକ୍‌ମାରି ଡାକ୍‌ଲା, “ଲାଜାର୍‌ ତୁଇ ବାରଇ ଆଉ ।” ");
INSERT INTO dso_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ଡାକ୍‌ଲା ଦାପ୍‌ରେ ମଲା ଲାଜାର୍‌ ବାରଇ ଆଇଲା । ତାର୍‌ ଆତେ ଗଡେ ମଡା ଲୁଗା ବାନ୍ଦାଅଇରଇଲା । ମୁଏ ମିସା ଗର୍‌ଣ୍ଡା ଗୁଡିଆଇ ଅଇରଇଲା । ଜିସୁ ସେମନ୍‌କେ କଇଲା “ତାକେ ବାନ୍ଦ୍‌ଲାଟା କୁସ୍‌ଲାଇ କରି, ଜିବାକେ ଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ଜିଉଦି ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି, ବେସି ଲକ୍‌ ମରିୟମର୍‌ ଲଗେ ଆସିରଇଲାଇ, ଆରି ଜିସୁର୍‌ ଏ କାମ୍‌ ଦେକି, ତାକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ଆରି ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେଲକ୍‌ ପାରୁସିମନର୍‌ ଲଗେ ଜାଇକରି ଜିସୁ କରି ରଇବା କାମ୍‌ ଲକ୍‌ମନ୍‌କେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ପଚେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ଗଟେକ୍‌ ବଡ୍‌ ପଁଚାଦି ଡାକାଇ କଇଲାଇ, “ଆମେ କାଇଟା କରୁ ? ଦେକା ଏ ଲକ୍‌ ତା କେତେକ୍‌ କେତେକ୍‌ କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ଆମେ ଜଦି ଆକେ ଏନ୍ତାରି ଚାଡିଦେଉଁ ବଇଲେ ସବୁଲକ୍‌ ତାର୍‌ଟାନେ ବିସ୍‌ବାସ୍‌ କର୍‌ବାଇ ଆରି ରମିୟ ଅଦିକାରି ଆସିକରି ଆମର୍‌ ଏ ମନ୍ଦିର୍‌ ଆରି ଆମର୍‌ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଦରମ୍‌ ସବୁ କୁରୁପ୍‌ନାସ୍‌ କରିପାକାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ମାତର୍‌ ସେମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ କୟାପା ନାଉଁର୍‌, ସେ ବରସର୍‌ ପାଇ ବାଚିରଇବା ବଡ୍‌ ପୁଜାରି, କଇଲା “ତମେ କେତେ ବକୁଆ ଲକ୍‌ମନ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ତମେ କାଇ ବୁଜି ନାପାର୍‌ଲାସ୍‌ନି ? ଗୁଲାଇ ଜାତି ନାସ୍‌ ଅଇବା ବାଦୁଲେ ଗଟେକ୍‌ ଲକ୍‌ ମର୍‌ବାଟା ନିକ ।” ");
INSERT INTO dso_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","କୟାପା ସତ‍ଇସେ ତାର୍‌ ନିଜର୍‌ଟାନେ ଅନି ଏନ୍ତି କଇ ନ ରଇଲା, ମାତର୍‌ ସେ ବରସର୍‌ ବଡ୍‌ ପୁଜାରି ଅଇରଇଲାର୍‌ ଲାଗି ପଚର୍‌ ଗଟ୍‍ନା ସବୁ ବବିସତ୍‌କାତା ତାର୍‌ ମୁଏଁ ଅନି ବାରଇରଇଲା । ସେ ଜାନିଦେଇ ରଇଲା ଜେ, ");
INSERT INTO dso_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଚିନ୍‌ ଚତର୍‌ ଅଇଜାଇରଇବା ପର୍‌ମେସରର୍‌ ଲକ୍‌ମନ୍‌କେ ଟୁଲିଆଇ, ଗଟେକ୍‌ କୁଟୁମ୍‌ କରାଇବାକେ ଜିସୁ ମର୍‌ବାକେ ଗାଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ତେବର୍‌ପାଇ ସେ ଦିନେଅନି ଜିଉଦିନେତାମନ୍‌ ଜିସୁକେ ମରାଇବାକେ ପାଁଚ୍‌ନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ତେବେ ଜିସୁ ଜିଉଦି ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ସବୁଲକ୍‌ ଜାନ୍‌ଲା ପାରା ବୁଲାଚାଲା ନ କର୍‌ତେ ରଇଲା । ସେ ଜାଗାଇଅନି ବାରଇଜାଇକରି, ମରୁବାଲି ବୁଏଁ ରଇବା କିନରା ଜାଗାଇ ରଇଲା ଏପ୍‌ରଇମ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଗଡେ ଜାଇ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ତେଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ଜିଉଦିମନର୍‌ ନିସ୍‌ତାର୍‌ ପରବ୍‌ କେଟିଆଇଲା । ସେ ପରବ୍‌ ଅଇବା ଆଗ୍‌ତୁ ନିଜେ ନିଜେ ସୁକଲ୍‌ ଅଇବାକେ ଗୁଲାଇ ରାଇଜର୍‌ ଲକ୍‌ମନ୍‌ ନିସ୍‌ତାର୍‌ ପରବ୍‌ ଆଗ୍‌ତୁ ଜିରୁସାଲାମ୍‌ ଜିବାକେ ବାଟ୍‍ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ସେମନ୍‌ ଜିସୁକେ କଜ୍‌ଲାଇ ଆରି ମନ୍ଦିର୍‌ ଟିଆଅଇଲାବେଲେ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ସେ ପରବ୍‌ଟାନେ ନ ଆସେବଲି କାଇ ତମେ ବାବ୍‌ଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ମୁକିଅ ପୁଜାରି ଆରି ପାରୁସି ଲକ୍‌ମନ୍‌ ଜିସୁକେ ଦାର୍‌ବାକେ ସେ କନ୍ତି ଆଚେ ଜାନିରଇବାଇ ବଲି, ସେଟା ଆଦେସ୍‌ ଦେଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ଏତ୍‌କି ବିତ୍‌ରେ ଜିସୁ ନିସ୍‌ତାର୍‌ ପରବ୍‌ ଅଇବାକେ ଚ ଦିନର୍‌ ଆଗ୍‌ତୁ ବେତ୍‌ନିଆ ଗାଲା । ତେଇ ଲାଜାରର୍‌ ଗର୍‌ । ଜିସୁ ଏ ଲାଜାର୍‌କେସେ ମଲାଟାନେଅନି ଉଟାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ସେ ରାତି ତେଇ ଜିସୁର୍‌ପାଇ ଗଟେକ୍‌ ବଜି ଟିକ୍‌ କଲାଇ । ଆରି ମାର୍‌ତା ସେମନ୍‌କେ କୁଆପୁଚା କରାଇତେରଇଲା । ଲାଜାର୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ବଜିତେଇ ବସି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ସେଡ୍‌କିବେଲେ ମରିୟମ୍‌ ଜଟାମାଉଁସ୍‌ ନାଉଁର୍‌ ବେସି ଦାମେ ତିଆର୍‌ ଅଇଲା ଅଦ୍‌ ଲିଟର୍‌ ବାସ୍‌ନା ଚିକନ୍‌ ଆନି ଜିସୁର୍‌ ପାଦେ ରକଇ ନିଜର୍‌ ଚେଣ୍ଡିସଙ୍ଗ୍‌ ପୁଚିଦେଲା । ଆରି ସେ ଚିକନର୍‌ ସୁନ୍ଦର୍‌ ବାସ୍‌ନା ଗୁଲାଇ ଗର୍‌ ଗମ୍‌କିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ଜିସୁର୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେ ଅନି ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ନାଉଁର୍‌ ସିସ୍‌, ଜେ କି ଜିସୁକେ ସତ୍‌ରୁମନ୍‍କେ ସର୍‌ପିଦେବାକେ ଜାଇତେ ରଇଲା, ସେ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ଏ ବାସ୍‌ନା ଚିକନ୍‌ ତିନ୍‌ ସଅ ରୁପା ଟାଙ୍ଗାକେ ବିକିକରି ସେ ଡାବୁ ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ଦେଲେ ନଇତା କି ?” ");
INSERT INTO dso_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ଗରିବ୍‌ ଲକ୍‌ମନର୍‌ପାଇ ଚିନ୍ତା କର୍‌ତେରଇଲାଜେ ଏନ୍ତି କଇଲା ବଲି ନାଇ, ମାତର୍‌ ସେ ଗଟେକ୍‌ ଚର୍‌ । ତାର୍‌ ଦାଇତେ ରଇଲା ଟାଙ୍ଗାମୁନା ଟାନେଅନି ସେ ନିଜର୍‌ ପାଇ କେତେକ୍‌ କେତେକ୍‌ ଲୁଚାଇ ନେଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ମାତର୍‌ ଜିସୁ କଇଲା, “ତାକେ କାଇଟା ବଲି କୁଆ ନାଇ, ତାର୍‌ଟାନେ ଜେତ୍‌କି ଆଚେ, ସେଟା ଜେନ୍ତିକି ମର୍‌ ସମାଦି ଦିନର୍‌ପାଇ ସଙ୍ଗଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ଗରିବ୍‌ ଲକ୍‌ମନ୍‌ ତା ସବୁବେଲେ ତମର୍‌ ସଙ୍ଗ୍‌ ରଇଲାଇନି, ମାତର୍‌ ମୁଇ ସବୁବେଲେ ନ ରଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ଏତ୍‌କିବିତ୍‌ରେ ଜିସୁ ବେତ୍‌ନିଆଇ ଆଚେ ବଲି ଜାନିକରି ବେସି ଜିଉଦି ଲକ୍‌ମନ୍‌ ଆଇଲାଇ । ଅବ୍‌କା ଜିସୁକେ ସେ ଦେକ୍‌ବାକେ ନାଇ, ମାତର୍‌ ଜନ୍‌ ଲାଜାର୍‌କେ ଜିସୁ ମଲାଟାନେଅନି ଉଟାଇରଇଲା ତାକେ ମିସା ଦେକ୍‌ବାର୍‌ ଆସିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ମାତର୍‌ ମୁକିଅ ପୁଜାରିମନ୍‌ ଲାଜାର୍‌କେ ମିସା ମରାଇବାକେ ଜଜ୍‌ନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","କାଇକେବଇଲେ ତାର୍‌ଲାଗି ବଲି କେତେକ୍‌ କେତେକ୍‌ ଜିଉଦି ଲକ୍‌ମନ୍‌ ନେତାମନ୍‌କେ ଚାଡି ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ରକିଆପାଇବା ପରବେ ଆସିରଇବା ବେସି ଲକ୍‌ମନ୍‌ ଜିସୁ ଜିରୁସାଲାମ୍‌ ଆଇଲାନି ବଲି ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ସେଟାର୍‌ ପାଇ ସେମନ୍‌ କଜ୍‌ରିଡାଲ୍‌ ଦାରି ଜିସୁକେ ବେଟ୍‌ଅଇବାର୍‌ ଗାଲାଇ, ଆରି ଆଉଲିଅଇକରି କଇଲାଇ, “ଅସାନା, ଜେ ମାପ୍‌ରୁର୍‌ ନାଉଁଦାରି ଆଇଲାନି ତାର୍‌ ମଙ୍ଗଲ୍‌ ଅ, ପର୍‌ମେସର୍‌ ତାକେ ଆସିର୍‌ବାଦ୍‌ କର । ସେ ଇସ୍‌ରାଏଲର୍‌ ରାଜା ଡାକ୍‌ପୁଟା ପାଅ ।” ");
INSERT INTO dso_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ଆରି ଜିସୁ ଗଟେକ୍‌ ଗଦ ପିଲାର୍‌ ଉପ୍‌ରେ ବସି ଆଇତେ ରଇଲା । ଜେନ୍ତିକି ସାସ୍‌ତରେ ଲେକାଅଇଲା ଏ ବବିସତ୍‌ କାତା ସିଦ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ଏ ସିୟନ୍‌ ନଅରର୍‌ ଲକ୍‌ମନ୍‌, ତମେ ଡରାନାଇ ଦେକା ତମର୍‌ ରାଜା ଗଟେକ୍‌ ଗଦ ପିଲାର୍‌ ଉପ୍‌ରେ ବସି ଆଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ପର୍‌ତୁମ୍‌ ପର୍‌ତୁମ୍‌ ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ ଏ ବିସଇ ବୁଜି ନ ରଇଲାଇ । ମାତର୍‌ ଜିସୁ ଜେଡେବେଲା ମଲାଟାନେଅନି ଉଟ୍‌ଲା ପଚେ ଏ ସବୁଜାକ ଲେକା ଏତାଇଲାଇଜେ, ସାସ୍‌ତରେ ତାର୍‌ ବିସଇସେ ଲେକା ଅଇରଇଲା । ଆରି ସେମନ୍‌ ତାର୍‌ ପାଇ ସବୁ କାମ୍‌ କରିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ଜିସୁ ଲାଜାର୍‌କେ ମଲାଟାନେଅନି ଉଟାଇକରି ସମାଦିଅନି ବାରଇବାକେ କଇଲାବେଲେ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ରଇଲାଇ, ସେମନ୍‌ ସେ ଗଟ୍‍ନା ବିସଇର୍‌ ସାକି ଦେବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ସେଟାର୍‌ପାଇ ଲକ୍‌ମନ୍‌ ତାକେ ବେଟ୍‌ଅଇବାକେ ଜାଇରଇଲାଇ । କାଇକେବଇଲେ ସେ ଆକା ଏ କାବା ଅଇବା କାମ୍‌ମନ୍‌ କଲାନି ବଲି ସେମନ୍‌ ସୁନିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ତେଇ ପାରୁସିମନ୍‌ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ଦେକ୍‌ଲାସ୍‌ନି କାଇକି, ଆମେ ଚେସ୍‌ଟା କଲାଟା ଗଟେକ୍‌ ମିସା ଅଏନାଇ, ଦେକାନି ଗୁଲାଇ ଦୁନିଆଜାକ ତାର୍‌ ପଚେ ଗାଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ନିସ୍‌ତାର୍‌ ପରବ୍‌ କର୍‌ବାକେ ଆସିରଇବା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ଗିରିକ୍‌ ଲକ୍‌ମନ୍‌ ମିସା କେତେଲକ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ସେମନ୍‌ ପିଲିପର୍‌ ଲଗେ ଆସି ତାକେ କଇଲାଇ, “ଏ ଆଗିଆଁ ଆମେ ଜିସୁକେ ଦେକ୍‌ବାକେ ମନ୍‌ କଲୁନି ।” ପିଲିପ୍‌ ବେତ୍‌ସାଇଦାର୍‌ ଲକ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ପିଲିପ୍‌ ଜାଇ ଆନ୍ଦ୍‌ରିୟକେ ଏ କବର୍‌ ଜାନାଇଲାକେ ସେମନ୍‌ ଜାଇ ଜିସୁକେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ପର୍‌ମେସର୍‌ତେଇ ଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ଡାକ୍‌ପୁଟା ପାଇବା ବେଲା ଆସି କେଟି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି ଜଦି ଗଅମ୍‌ ମୁଞ୍ଜି ବୁଏଁ ଅଦ୍‌ରି ନ ମର୍‌ବା ଜାକ ସେନ୍ତିସେ ରଇସି । ସେଟା ମଲେ ସେ ବେସି ମୁଞ୍ଜି ଦାର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଜେ ନିଜର୍‌ ଜିବନ୍‌କେ ବେସି ଆଲାଦ୍‌ କର୍‌ସି, ସେ ସେଟା ଆରାଇସି । ଜେ ନିଜର୍‌ ଜିବନ୍‌ ଗିନ୍‌ କର୍‌ତେରଇସି, କାଲ୍‌ କାଲ୍‌ ଜୁଗ୍‌ ଜୁଗ୍‌ ଜାକ ତାର୍‌ ଜିବନ୍‌ ରକିଆ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ଜନ୍‌ ଲକ୍‌ ମର୍‌ ସେବା କର୍‌ବାକେ ମନ୍‌ କଲାନି, ସେ ମର୍‌ ସଙ୍ଗ୍‌ ଆସ । ମୁଇ ଜନ୍‌ ଜାଗାଇ ରଇବି, ମର୍‌ ସେବା କାମ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌ମିସା ସେ ଜାଗାଇ ରଇବାଇ । ଆରି ସେ ମର୍‌ ଆରି ମର୍‌ ବାବା ପର୍‌ମେସରର୍‌ ସନ୍‌ମାନ୍‌ ପାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ଏବେ ମର୍‌ ଜିବନ୍‌ ବେସି ବାୟାବିକଲ୍‌ ଅଇଗାଲାନି । କାଇଟା କଇବି ? ଏ ବାବା ମକେ ଏ ଦୁକର୍‌ ବେଲାଇଅନି ରକିଆ କର୍‌ ବଲି ଗୁଆରି କର୍‌ବି କି ? ନାଇ ସେନ୍ତି ନ କଇ । ଦୁକ୍‌ କସ୍‌ଟ ମୁରଚ୍‍ବାକେ ସେ ମୁଇ ଆଇଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ଏ ବାବା ତର୍‌ ନାଉଁ ଡାକ୍‌ପୁଟା କର । ସେ ବେଲା ସର୍‌ଗେଅନି ଏ କାତା କଇବା ସବଦ୍‌ ଆଇଲା, “ମର୍‌ ନାଉଁ ଡାକ୍‌ପୁଟା କଲିଆଚି, ଆରି ତରେକ୍‌ ଡାକ୍‌ପୁଟା କର୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ତେଇ ଟିଆଅଇ ରଇଲା ଲକ୍‌ମନ୍‌ ଏ ସବଦ୍‌ ସୁନି କରି “ଏଟା ବାଦଲ୍‌ ଗୁଡ୍‌ଗୁଡ୍‌ଲା” ବଲି କଇଲାଇ । ମାତର୍‌ ଅଦେକ୍‌ ଲକ୍‌ମନ୍‌, “ସର୍‌ଗେଅନି ଗଟେକ୍‌ ଦୁତ୍‌ ତାର୍‌ ସଙ୍ଗ୍‌ କାତା ଅଇଲାନି” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ଜିସୁ ସେ ଲକ୍‌ମନ୍‌କେ କଇଲା, “ଏ ସବଦ୍‌ ମର୍‌ ପାଇ ଅଏନାଇ, ମାତର୍‌ ତମର୍‌ ପାଇସେ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ଏବେ ଏ ଦୁନିଆର୍‌ ବିଚାର୍‌ କର୍‌ବା ଦିନ୍‌ କେଟ୍‌ଲା ଆଚେ, ଏ ଦୁନିଆର୍‍ ସାସନ୍‌ କରୁକେ ମୁଇ ବାଇରେ ପିଙ୍ଗିଦେବି । ");
INSERT INTO dso_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ଆରି ମକେ କୁର୍‌ସେ ଟେକ୍‌ଲେ, ସବୁ ଲକ୍‌ମନ୍‌କେ ମର୍‌ବାଟେ ଜିକ୍‌ବି ” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ସେ କେନ୍ତିଅଇ ମର୍‌ବାକେ ଗାଲାନି, ସେଟା ଜାନାଇବାକେ ଏନ୍ତି କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ସେବେଲା ସବୁ ଲକ୍‌ମନ୍‌ ତାକେ କଇଲାଇ, “ମସିଅ ସବୁ ଦିନର୍‌ ପାଇ ବଁଚି ରଇସି ବଲି ଆମର୍‌ ସାସ୍‌ତରେ ଲେକା ଆଚେ । ତୁଇ କେନ୍ତି ପର୍‌ମେସରର୍‌ ପିଲାକେ କୁର୍‌ସେ ଟେକ୍‌ବାଇ ବଲି କଇଲୁସ୍‌ନି ? ଏନ୍ତିବଇଲେ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆଇଲା ନର୍‌ପିଲା କେ ତେବେ ?” ");
INSERT INTO dso_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ଏବେ ତମର୍‌ ମୁଆଟେ ଜନ୍‌ ଉଜଲ୍‌, ଉଜଲ୍‌ ଦେଲାନି, ସେଟା ଚନେକର୍‌ପାଇସେ ରଇସି । ଜନ୍‌ ଜାଗାଇ ଜିବାର୍‌ ଆଚେ, ଉଜଲ୍‌ ରଇତେ ଆକା ଇଣ୍ଡା । ସେନ୍ତାର୍‌ଆଲେ ତମ୍‌କେ ଆନ୍ଦାର୍‌ ନ ଡାବେ । ଆନ୍ଦାରେ ରଇବା ଲକ୍‌ କେନେ ଗାଲାନି ସେଟା ନାଜାନେ । ");
INSERT INTO dso_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ସେଟାର୍‌ ପାଇ ତମର୍‌ ଲଗେ ଉଜଲ୍‌ ରଇତେସେ ଉଜଲ୍‌ ପାରା ରଇବା ମର୍‌କାତା ବିସ୍‌ବାସ୍‌ କରା । ତେବେ ତମେ ଉଜଲର୍‌ ଲକ୍‌ ଅଇସା ” ବଲିକରି କଇଲା । ଜିସୁ ଏ କାତା କଇକରି ଉଟିଗାଲା ଆରି ସେମନ୍‌କେ ନ ଦେକାଇଅଇକରି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ଜିସୁ ସେମନର୍‌ ଦେକ୍‌ତେ କେତେକ୍‌ କେତେକ୍‌ କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ କରିରଇଲେ ମିସା, ସେମନ୍‌ ତାକେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ଜେନ୍ତାରି ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତା କଇଲା କାତା ସତ୍‌ ଅଇଲା । ସେ ଏନ୍ତି କଇରଇଲା, “ଏ ମାପ୍‌ରୁ, ଆମେ କଇଲା କାତା ସୁନିକରି କେ ବିସ୍‌ବାସ୍‌ କଲାଆଚେ ? ଆରି ମାପ୍‌ରୁ କାର୍‌ଲଗେ ତାର୍‌ ରକିଆ କର୍‌ବା ବପୁ ଦେକାଇଲା ?” ");
INSERT INTO dso_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ସେଟାର୍‌ପାଇ ସେମନ୍‌ ବିସ୍‌ବାସ୍‌ ନ କର୍‌ତେରଇଲାଇ । ତେବେ ଜିସାୟ ଆରିତରେକ୍‌ କଇଲାଆଚେ, ");
INSERT INTO dso_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ପର୍‌ମେସର୍‌ ଜେନ୍ତିକି ତାକର୍‌ ଦେକ୍‌ବା ଆଁକି କାଣା କରିଦେଇଆଚେ ଆରି ସେମନର୍‌ ବୁଜ୍‌ବା ବପୁ ନସାଇଦେଇଆଚେ ସେଟାର୍‌ପାଇ ସେମନ୍‌ ଦେକି ନାପାର୍‌ଲାଇନି କି ମୁଲ୍‌କେ ବୁଜି ନାପାର୍‌ଲାଇନି । ସେମନ୍‌ ନିକ ଅଇବାକେ ମର୍‌ଟାନେ ବାଉଡି ଆସତ୍‌ନାଇ । ଏଟା ପର୍‌ମେସର୍‌ କଇଲାନି । ଆମେ ସେମନ୍‌କେ ନିକ ନ କରୁ । ");
INSERT INTO dso_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତା ପୁର୍‌ବେ ଜିସୁ ମାପ୍‌ରୁର୍‌ ଏ ସବୁ ମଇମା ଜାନିରଇଲାଜେ ଏନ୍ତି ବଲି କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଏଲେ ମିସା ଜିଉଦି ନେତାମନର୍‌ ବିତ୍‌ରେଅନି କେତେ ଲକ୍‌ ତାକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ମାତର୍‌ ସେମନ୍‌ ପାରୁସି ମନର୍‌ଲାଗି ପାର୍‌ତନା ଗରେ ଅନି ବାର୍‌କରାଇଦେବାଇ ବଲି ଡରିକରି କାତାବାର୍‌ତା ନ ଅଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ସେମନ୍‌ ପର୍‌ମେସର୍‌କେ ମାନାଇବା ଟାନେଅନି ଲକ୍‌ମନ୍‌କେ ମାନାଇବାଟା ଅଦିକ୍‌ ନିକ ବଲି ବାବ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ଜିସୁ ଆଉଲିଅଇ କଇଲା, “ଜନ୍‌ ଲକ୍‌ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ସେ ମକେସେ ବିସ୍‌ବାସ୍‌ କରେନାଇ, ମକେ ଜେ ପାଟାଇଲା ଆଚେ, ତାକେ ମିସା ବିସ୍‌ବାସ୍‌ କଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ଜେ ମକେ ଦେକି ଆଚେ, ସେ ମକେ ପାଟାଉକେ ମିସା ଦେକି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ମୁଇ ଜଗତର୍‌ ଉଜଲ୍‌ ଅଇ ଆଇଲିଆଚି । ଜେ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ସେ ଆରି ଆନ୍ଦାରେ ନ ରଏ । ");
INSERT INTO dso_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ଜେ ମର୍‌ ବାକିଅ ସୁନି ନ ମାନେ, ମୁଇ ତାର୍‌ ବିଚାର୍‌ ନ କରି । କାଇକେବଇଲେ ମୁଇ ଜଗତର୍‌ ଲକ୍‌ମନ୍‌କେ ବିଚାର୍‌ କର୍‌ବାର୍‌ ଆସିନାଇ, ମାତର୍‌ ସେମନ୍‌କେ ରକିଆ କର୍‌ବାର୍‌ ଆସିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଜେ ମକେ ନିଚି କରି ମର୍‌ ବାକିଅ ନ ମାନେ, ମର୍‌ ଟଣ୍ଡର୍‌ ବାକିଅ ତାର୍‌ ବିଚାର୍‌ କାରିଆ ଅଇସି । ସାରାସାରି ଦିନେ ସେ ବାକିଅସେ ତାକେ ବିଚାର୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ମୁଇ ନିଜର୍‌ ମନେ ଅନି କାଇଟା ମିସା କଇନାଇ, ଏ କାତା ସତ୍‌ । ମାତର୍‌ ମୁଇ କଇବାଟା ମକେ ପାଟାଇରଇବା ବାବା ଆଦେସ୍‌ ଦେଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ଆରି ମୁଇ ଜାନିଆଚି, ତାର୍‌ ଆଦେସ୍‌ ନ ସାର୍‌ବା ଜିବନ୍‌ ଦେଇସି । ମର୍‌ ବାବା ମକେ ଜନ୍‌ କାତା କଇବାକେ ଆଦେସ୍‌ ଦେଇଆଚେ, ସେଟାସେ ମୁଇ କଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ନିସ୍‌ତାର୍‌ ପରବର୍‌ ଆଗ୍‌ତୁର୍‌ ଦିନ୍‌ ଅଇରଇଲା । ଜିସୁ, ଏ ଜଗତ୍‌ ଚାଡି ବାବା ପର୍‌ମେସରର୍‌ ଲଗେ ଜିବାକେ ତାର୍‌ ବେଲା କେଟ୍‌ଲାବେ ବଲି ଜାନିରଇଲା । ଦୁନିଆଇ ରଇବା ତାର୍‌ ସବୁ ଲକ୍‌ମନ୍‌କେ ସାରାସାରି ଜାକ ବେସି ଆଲାଦ୍‌ କର୍‌ତେର‍ଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ସେଦିନର୍‌ ରାତି ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ କାଇବାକେ ବସିରଇଲାଇ । ଜିସୁକେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା କରାଇବା ଚିନ୍ତା, ସଇତାନ୍‍ ସିମନ୍‌ ଇସ୍‌କାରିୟତର୍‌ ପିଲା ଜିଉଦାର୍‌ ମନେ ପୁରିକରି ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ବାବା ପର୍‌ମେସର୍‌, ତାକେ ସବୁ ବିସଇର୍‌ ଅଦିକାର୍‌ ଦେଇ ଆଚେ, ସେ ପର୍‌ମେସରର୍‌ ଟାନେଅନି ଆସିଆଚେ ଆରି ତାର୍‌ ଲଗେସେ ଜାଇସି, ବଲି ଜିସୁ ସବୁ ବିସ‍ଇ ଜାନିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ତେବର୍‌ପାଇ ସେ କାଇବା ଜାଗାଇଅନି ଉଟିକରି ଅଡି ରଇବା ବସ୍‌ତର୍‌ ବେଟି ସଙ୍ଗଇ, ଆଁଟାଇ ଗଟେକ୍‌ ତୁଆଲ୍‌ ବାନ୍ଦିଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ତାର୍‌ ପଚେ ସେ ଗଟେକ୍‌ ମୁତାଇ ପାନିନେଲା ଆରି ନିଜର୍‌ ସିସ୍‌ମନର୍‌ ପାଦ୍‌ ଦଇକରି ବାନ୍ଦିଅଇଲା ତୁଆଲ୍‌ ବେଟି ପୁଚି ଦେବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଜେଡେବେଲେ ଜିସୁ ସିମନ୍‌ ପିତରର୍‌ ଲଗେ ଆଇଲା, ପିତର୍‌ ତାକେ କଇଲା, “ମାପ୍‌ରୁ ତମେ ମର୍‌ ପାଦ୍‌ ଦଇସା କି ?” ");
INSERT INTO dso_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଜିସୁ ତାକେ କ‍ଇଲା, “ମୁଇ ଏବେ ଜାଇଟା କଲିନି, ସେଟା ତମେ ବୁଜି ନାପାରାସ୍‌, ମାତର୍‌ ପଚେ ବୁଜ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପିତର୍‌ ତାକେ ମନାକରି କଇଲା, “ନିଚୁ, ତମେ ମର୍‌ ପାଦ୍‌ ଦୁଆନାଇ ।” ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ଜଦି ତର୍‌ ପାଦ୍‌ ନ ଦଇଲେ, କେବେ ମିସା ମର୍‌ ସିସ୍‌ ଅଇ ନାପାରୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ସିମନ୍‌ ପିତର୍‌ ତାକେ କଇଲା, “ମାପ୍‌ରୁ ସେନ୍ତାର୍‌ଆଲେ କାଇକେ ମର୍‌ ପାଦ୍‌ସେ ଦଇ ଦେଇସୁ ? ମର୍‌ ମୁଣ୍ଡ୍ ଆରି ଆତ୍‌ ମିସା ଦଇଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ଜିସୁ ପିତର୍‌କେ କଇଲା, “ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଗାଦଇ ସାରିଆଚତ୍‌, ସେମନ୍‌ ପୁରାପୁରୁନ୍‌ ସୁକଲ୍‌ । ପାଦ୍‌ ଦଇବାଟା ଚାଡି, କାଇଟା ଦଇବାର୍‌ ଲଡାନାଇ । ଗଟେକ୍‌ ଲକ୍‌କେ ଚାଡି, ତମେ ସବୁଲକ୍‌ ସୁକଲ୍‌ ଆଚାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","କାଇକେ ବଇଲେ ଜନ୍‌ ସିସ୍‌ ଜିସୁକେ ସତ୍‌ରୁମନ୍‍କେ ଦାରାଇଦେଇସି ତାକେ ଜିସୁ ଜାନି ରଇଲା । ସେଟାର୍‌ ପାଇ ସେ ଗଟେକ୍‌ ଲକ୍‌କେ ଚାଡି ସବୁଲକ୍‌ ସୁକଲ୍‌ ଆଚାସ୍‌ ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ଜିସୁ ସିସ୍‌ମନର୍‌ ପାଦ୍‌ ଦଇଲା ପଚେ ବେଟିର‍ଇଲା ବସ୍‌ତର୍‌ ପିନ୍ଦିକରି ବସି ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ଏବେ ମୁଇ ତମର୍‌ ପାଇ କଲା କାମ୍‌ ବୁଜ୍‌ଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ଆରି ସେ କଇଲା, “ତମେ ମକେ ଗୁରୁ ଆରି ମାପ୍‌ରୁ ବଲି ଡାକ୍‌ଲାସ୍‌ନି, ସେଟା ଟିକ୍‌ସେ । କାଇକେ ବଇଲେ ଗୁରୁ ଆରି ମାପ୍‌ରୁ ମୁଇସେ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ମୁଇ ତମର୍‌ ଗୁରୁ ଆରି ମାପ୍‌ରୁ ଅଇକରି, ତମର୍‌ ପାଦ୍‌ ଦଇଦେଲି ଆଚି ବଇଲେ ତମେ ମିସା ତମର୍‌ ତମର୍‌ ବିତ୍‌ରେ ପାଦ୍‌ ଦଇବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ମୁଇ ଏଟା ତମର୍‌ ପାଇ ଗଟେକ୍‌ ଉଦାଅରଣ୍‌ ପାରା କଲିଆଚି, ତମେ ମିସା ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ଏନ୍ତି କରା । ");
INSERT INTO dso_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ଗତିଦାଙ୍ଗ୍‌ଡା ନିଜର୍‌ ସାଉକାରର୍‌ ତେଇଅନି ବଡ୍‌ ନଏଁ । ଆରି କବର୍‌ ନେଉଁ କବର୍‌ ପାଟାଇଲା ଲକର୍‌ତେଇଅନି ବଡ୍‌ ନଏଁ । ");
INSERT INTO dso_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ଜଦି ତମେ ଏ ସବୁ ବିସଇ ଜାନିଆଚାସ୍‌, ଆରି ସେ ଇସାବେ କର୍‌ସା ବଇଲେ ବେସି ସାର୍‌ଦା ଅଇସା । ");
INSERT INTO dso_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ମୁଇ ତମର୍‌ ସବୁ ଲକର୍‌ ବିସଇ ନେଇକରି କଇନାଇ, ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ବାଚି ଆଚି, ସେମନ୍‌ କେନ୍ତି ବଲି ଜାନିଆଚି । ମାତର୍‌ ସାସ୍‌ତରେ ଲେକା ଅଇଲା କାତା ସିଦ୍‌ ଅଇବାକେ ଏନ୍ତି ଗଟ୍‍ନା ଅଇଲାନି । ସାସ୍‌ତରେ ଲେକା ଅଇଲା ଆଚେ ଜେ ମର୍‌ ସଙ୍ଗ୍‌ କାଇଲାନି ସେ ମର୍‌ ବିରଦେ ଉଟ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ଏବେ ଏ ଗଟ୍‍ନା ଅଇବା ଆଗ୍‌ତୁସେ ମୁଇ ତମ୍‌କେ ଏ କାତା କଇଲିନି । ଜେଡେବେଲା ଏ ଗଟ୍‍ନା ଗଟ୍‌ସି, ତମେ ମୁଇ ମସିଅ ବଲି ବିସ୍‌ବାସ୍‌ କର୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ଜନ୍‌ ଲକ୍‌ମନ୍‌ ମର୍‌ କବର୍‌ ନେବା ଲକ୍‌ମନ୍‌କେ ନାମ୍‌ବାଇ, ସେମନ୍‌ ମକେ ମିସା ନାମ୍‌ବାଇ, ଆରି ମକେ ପାଟାଇଲା ପର୍‌ମେସର୍‌କେ ମିସା ନାମ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଜିସୁ ଏ ସବୁ କାତା କଇସାରାଇଲା ପଚେ, ଆତ୍‌ମାଇ ବାୟାବିକଲ୍‌ ଅଇ ପୁଟ୍‌କାର୍‌ କରି କଇଲା, “ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ତମର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ମକେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ସେ ଏ କାତା, କାର୍‌ ବିସଇ ନେଇକରି କଇଲାନି ବଲି ସିସ୍‌ମନ୍‌ ବୁଜିନାପାରି ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ଆର୍‌ ମୁଏ ସେ ତାର୍‌ ମୁଏ ଏ, ଦେକାଦେକି ଅଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ଜିସୁର୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଜଅନ୍‌, ଜାକେକି ଜିସୁ ମୁକିଅ ଇସାବେ ଆଲାଦ୍‌ କର୍‌ତେ ରଇଲା, ସେ ଜିସୁର୍‌ ଲଗେ ବସିକରି କାଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ସିମନ୍‌ ପିତର୍‌ ଜଅନ୍‌କେ ସଗିଆ କରି କଇଲା, “ସେ କାର୍‌ ବିସଇ ନେଇକରି କଇଲାନି, ତାକେ ପାଚାର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ସେଟାର୍‌ ପାଇ ଜଅନ୍‌ ଜିସୁର୍‌ ଉପ୍‌ରେ ଆଉଜି ଅଇକରି ପାଚାର୍‌ଲା, “ଏ ମାପ୍‌ରୁ, ସେ ଲକ୍‌ କେ ?” ");
INSERT INTO dso_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ଜିସୁ କ‍ଇଲା, “ମୁଇ ଏ ରୁଟି ଜଲେ ଚବାଲି ଜାକେ ଦେବି, ସେ ଲକ୍‌ ସେ ।” ସେବେଲେ ସେ ରୁଟି ଜଲେ ଚବାଲି କରି ସିମନ୍‌ ଇସ୍‌କାରିୟତର୍‌ ପିଲା ଜିଉଦାକେ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ରୁଟି ମାଙ୍ଗ୍‌ଲା ଦାପ୍‌ରେ ସଇତାନ୍‌ ତାର୍‌ ମନ୍‌ ବିତ୍‌ରେ ଜାଇକରି ଚାଲାଇବାର୍‌ ଦାର୍‌ଲା । ଜିସୁ ସେ ବେଲାଇ ତାକେ କଇଲା, “ତୁଇ ଜାଇଟା କର୍‌ବାକେ ଗାଲୁସ୍‌ନି ବେଗି କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ଜିସୁ ଏ କାତା ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦାକେ କାଇକେ କଇଲା, ତେଇ କାଇବାକେ ବସି ରଇଲା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି କେମିସା, ବୁଜି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦାର୍‌ ଲଗେ ଡାବୁ ପେଡି ରଇଲାଜେ କେତେଟା ସିସ୍‌ମନ୍‌ ପାଚାର୍‌ଲାଇ, “ପରବ୍‌ ପାଇ କାଇକାଇଟା ଦର୍‌କାର୍‌ ଆଚେ, ସେଟାର୍‌ପାଇ ନଇଲେ ଗରିବ୍‌ ଲକ୍‌ମନ୍‌କେ ଦାନ୍‌ଦେବାକେ ଜିସୁ ତାକେ କଇଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ତାର୍‌ ପଚେ ଇସ୍‌କାରିୟତ ଜିଉଦା ରୁଟି ମାଙ୍ଗି ଦାପ୍‌ରେ ବାରଇକରି ଉଟିଗାଲା । ସେ ବେଲେ ରାତି ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ବାରଇକରି ଉଟିଗାଲା ପଚେ ଜିସୁ କଇଲା, “ଏବେ ପର୍‌ମେସରର୍‌ ତେଇଅନି ଆଇଲା ନର୍‌ପିଲା ମୁଇ ତାର୍‌ଟାନେଅନି ଡାକ୍‌ପୁଟା ପାଇବା ବେଲା ଆସିଆଚେ । ଆରି ମର୍‌ ଲାଗି ପର୍‌ମେସର୍‌ ମିସା ଡାକ୍‌ପୁଟା ପାଇସି । ");
INSERT INTO dso_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଜଦି ପର୍‌ମେସର୍‌ ମର୍‌ତେଇଅନି ଡାକ୍‌ପୁଟା ଅଇଲେ, ନିଜର୍‌ ମ‍ଇମାସଙ୍ଗ୍‍ ନର୍‌ପିଲା ମକେ ମିସା ଡାକ୍‌ପୁଟା କରାଇସି । ଦାପ୍‌ରେସେ ମକେ ସେନ୍ତି କରାଇସି । ");
INSERT INTO dso_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ଏ ମର୍‌ ପିଲାମନ୍‌ ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‌ ଚନେକର୍‌ପାଇ ରଇବି । ତାର୍‌ ପଚେ ତମେ ମକେ କଜ୍‍ସା, ଆରି ମୁଇ ଜନ୍ତି ଗାଲିନି ତମେ ତେଇ ଜାଇନାପାରାସ୍‌ । ଏ ବିସଇ ଜିଉଦି ନେତାମନ୍‌କେ ଜେନ୍ତି କଇରଇଲି, ସେନ୍ତି ଏବେ ତମ୍‌କେ ଆରିତରେକ୍‌ କଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ମୁଇ ତମ୍‌କେ ଗଟେକ୍‌ ନୁଆ ଆଦେସ୍‌ ଦେଲିନି, ତମେ ତମର୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ଆଲାଦ୍‌ କରା । ମୁଇ ଜେନ୍ତି ତମ୍‌କେ ଆଲାଦ୍‌ କଲିଆଚି, ତମେ ମିସା ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ଆଲାଦ୍‌ କର୍‌ବାର୍‌ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ତମର୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ଆଲାଦ୍‌ ରଇଲେ, ତମେ ମର୍‌ ସିସ୍‌ ବଲି ସବୁଲକ୍‌ ଜାନ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ସିମନ୍‌ ପିତର୍‌ ଜିସୁକେ ପାଚାର୍‌ଲା, “ଏ ମାପ୍‌ରୁ ତମେ କନ୍ତି ଗାଲାସ୍‌ନି ?” ଜିସୁ କଇଲା, “ମୁଇ ଜନ୍ତି ଗାଲିନି ସେ ଜାଗାଇ ଏବେ ତୁଇ ଆସି ନାପାରୁସ୍‌ ମାତର୍‌ ପଚେ ଆଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ପିତର୍‌ ଜିସୁକେ କଇଲା, “ଏ ମାପ୍‌ରୁ ଏବେ କାଇକେ ତମର୍‌ ପଚେ ପଚେ ଆସିନାପାରି ? ମୁଇ ତମର୍‌ପାଇ ମର୍‌ବାକେ ମିସା ରାଜିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ଜିସୁ ତାକେ କଇଲା, “ତୁଇ କାଇକେ ମର୍‌ପାଇ ମର୍‌ସୁ ? ମୁଇ ତକେ ସତ୍‌ କାତା କଇଲିନି କୁକୁଡା ନ ଡାକ୍‌ତେ ତୁଇ ମକେ ତିନ୍‌ ତର୍‌ ନାଜାନି ବଲି କଇସୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ଆରି ଜିସୁ କଇଲା, “ତମେ କିଲ୍‌ବିଲ୍‌ ନ ଉଆ, ପର୍‌ମେସରର୍‌ଟାନେ ବିସ୍‌ବାସ୍‌ କରା । ଆରି ମର୍‌ଟାନେ ମିସା ବିସ୍‌ବାସ୍‌ କରା । ");
INSERT INTO dso_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ମର୍‌ ବାବାର୍‌ ଗରେ ରଇବାକେ ବେସି ବାକ୍‌ରା ଆଚେ । ଆରି ତେଇ ମୁଇ ତମର୍‌ ପାଇ ଜାଗା ଟିକ୍‌ କର୍‌ବାର୍‌ ଗାଲିନି । ଜଦି ଏଟା ସତ୍‌ ନଇତା ଆଲେ, ମୁଇ ତମ୍‌କେ ଏନ୍ତି ବଲି ନ କଇତି । ");
INSERT INTO dso_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ଆରି ମୁଇ ଜାଇ ତମର୍‌ ପାଇ ଜାଗା ଟିକ୍‌ କଲା ପଚେ, ଆରି ତରେକ୍‌ ବାଉଡି ଆସି ତମ୍‌କେ ମର୍‌ ସଙ୍ଗ୍‌ ଡାକିନେବି । ମୁଇ ଜନ୍‌ ଜାଗାଇ ରଇବି, ସେ ଜାଗାଇ ତମେ ମର୍‌ ସଙ୍ଗ୍‌ ରଇସା । ");
INSERT INTO dso_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ମୁଇ ଜନ୍‌ ଜାଗାଇ ଗାଲିନି, ତମେ ସେ ଜାଗାଇ ଜିବା ବାଟ୍‌ ଜାନିଆଚାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ତମା ଜିସୁକେ କଇଲା, “ଏ ମାପ୍‌ରୁ ତମେ କନ୍‌ ଜାଗାଇ ଗାଲୁସ୍‌ନି, ସେଟା ଆମେ ନାଜାନୁ, ଆରି ତେଇ ଜିବା ବାଟ୍‌ କେନ୍ତି ଜାନ୍‌ବୁ ?” ");
INSERT INTO dso_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଜିସୁ ତାକେ କଇଲା, “ମୁଇ ସତ୍‌, ବାଟ୍‌ ଆରି ଜିବନ୍‌ । ମର୍‌ବାଟେ ନ ଗାଲେ ବାବା ପର୍‌ମେସର୍‌ ଲଗେ କେ ମିସା ଜାଇନାପାରେ ।” ");
INSERT INTO dso_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ସେ କଇଲା, “ଜଦି ତମେ ମକେ ଜାନିରଇତାସ୍‌ ବଇଲେ, ମର୍‌ ବାବାକେ ମିସା ଜାନ୍‌ତାସ୍‌ । ଏବେ ମିସା ତମେ ତାକେ ଜାନ୍‌ଲାସ୍‌ନି ଆରି ଦେକ୍‌ଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ପିଲିପ୍‌ ଜିସୁକେ କଇଲା, “ଏ ମାପ୍‌ରୁ ଆମ୍‌କେ ବାବାକେ ଦେକାଇ ଦେ, ସେତ୍‌କିସେ ଆମର୍‌ପାଇ ବେସି ।” ");
INSERT INTO dso_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ଜିସୁ ତାକେ କଇଲା, “ପିଲିପ୍‌ ଏତ୍‌କି ଦିନ୍‌ ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‌ ରଇଲି, ତୁଇ ମକେ ଚିନି ନାପାର୍‌ଲୁସ୍‌ କି ?” ଜେ ମକେ ଦେକ୍‌ଲା ଆଚେ ସେ ମର୍‌ ବାବା ପର୍‌ମେସର୍‌କେ ଦେକ୍‌ଲା ଆଚେ । କେନ୍ତି ଆମ୍‌କେ ତର୍‌ ବାବାକେ ଦେକାଇ ଦେ ବଲି କଇଲୁସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ତୁଇ ବିସ୍‌ବାସ୍‌ କୁରୁସ୍‌ ନାଇ କି ପିଲିପ୍‌ ? ମୁଇ ବାବାର୍‌ ତେଇ ଆଚି ଆରି ବାବା ମର୍‌ଟାନେ ଆଚେ । ମୁଇ ତମ୍‌କେ ଜନ୍‌ କାତା ସବୁ କଇଲିଆଚି, ସେ ସବୁ କାତା ମର୍‌ ନିଜର୍‌ତେଇଅନି କଇନାଇ । ମାତର୍‌ ବାବା ମର୍‌ତେଇ ରଇକରି ତାର୍‌ କାମ୍‌, ମର୍‌ଟାନେଅନି କଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ମୁଇ ବାବାର୍‌ତେଇ ଆଚି ଆରି ବାବା ମର୍‌ଟାନେ ଆଚେ ବଲି ମୁଇ କଇବା ଏ କାତା ବିସ୍‌ବାସ୍‌ କରା । ନଇଲେ ମୁଇ କର୍‌ବା କାମ୍‌ ଦେକି ବିସ୍‌ବାସ୍‌ କରା । ");
INSERT INTO dso_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ମୁଇ ତମ୍‌କେ ସତ୍‌ କଇଲିନି, ଜେ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି ସେ, ମୁଇ କର୍‌ବା ଏନ୍ତି କାମ୍‌ମନ୍‌ କର୍‌ସି ଆରି ମର୍‌ତେଇଅନି ଅଦିକ୍‌ ବଡ୍‌ ବଡ୍‌ କାମ୍‌ମନ୍‌ ମିସା କର୍‌ସି । କାଇକେ ବଇଲେ ମୁଇ ମର୍‌ ବାବାର୍‌ ଲଗେ ଗାଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ତମେ ମର୍‌ ନାଉଁଦାରି ଜାଇଟା ମାଙ୍ଗ୍‌ସା ସେଟା ସବୁ ମୁଇ ତମ୍‌କେ ଦେବି । ଇତିଅନି ବାବାର୍‌ ଡାକ୍‌ପୁଟା ମର୍‌ତେଇ ଜାନାପଡ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ତମେ ଜଦି କାଇ ବିସଇ ମିସା ମର୍‌ ନାଉଁଦାରି ମାଙ୍ଗ୍‌ସା ବଇଲେ ମୁଇ ସେଟା ଦେବି । ");
INSERT INTO dso_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ତମେ ଜଦି ମକେ ଆଲାଦ୍‌ କର୍‌ସା, ମର୍‌ ଆଦେସ୍‌ ମିସା ମାନ୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ମୁଇ ମର୍‌ ବାବାକେ ଗୁଆରି କର୍‌ବି । ଆରି ତମର୍‌ ସଙ୍ଗ୍‌ ସବୁବେଲା ରଇବା ପାଇ, ସେ ଗଟେକ୍‌ ସାଇଜକାରିଆକେ ପାଟାଇସି । ");
INSERT INTO dso_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ସେ ଅଇଲାନି ସତ୍‌ ଆତ୍‌ମା, ଜେକି ସତ୍‌ସଙ୍ଗ୍‌ ପର୍‌ମେସରର୍‌ ବିସଇ ଦେକାଇସି । ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ନ ନାମତ୍‌, କାଇକେ ବଇଲେ ତାକେ ଦେକତ୍‌ ନାଇ କି ଜାନତ୍‌ ନାଇ । ମାତର୍‌ ତମେ ତାକେ ଜାନି ଆଚାସ୍‌ । କାଇକେ ବଇଲେ ସେ ତମର୍‌ ସଙ୍ଗ୍‌ ଆଚେ ଆରି ତମର୍‌ ମନ୍‌ ବିତ୍‌ରେ ରଇସି । ");
INSERT INTO dso_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ମୁଇ ଜେଡେବଲ୍‌ ଜିବି, ତମ୍‌କେ ଟୁରା ପିଲାମନର୍‌ ପାରା କରି ଚାଡି ନ ଜାଇ । ଆରିତରେକ୍‌ ତମର୍‌ ଲଗେ ବାଉଡି ଆଇବି । ");
INSERT INTO dso_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ଚନେକ୍‌ ଗାଲେ ଦୁନିଆ ଆରି ମକେ ଦେକିନାପାରେ । ମାତର୍‌ ତମେ ଦେକ୍‌ସା, କାଇକେ ବଇଲେ ମୁଇ ସବୁବେଲେ ଜିବନ୍‌ ରଇବି, ଆରି ତମେ ମିସା ଜିବନ୍‌ ରଇସା । ");
INSERT INTO dso_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ସେ ଦିନ୍‌ ଆଇଲେ ତମେ ଜାନ୍‌ସା, ମୁଇ ବାବାର୍‌ ଲଗେ, ତମେ ମର୍‌ ଲଗେ, ଆରି ମୁଇ ତମର୍‌ ଲଗେ ସବୁବେଲେ ରଇବି । ");
INSERT INTO dso_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ଜେ ମର୍‌ ଆଦେସ୍‌ ମାନ୍‌ସି, ସେ ଆକା ମକେ ଆଲାଦ୍‌ କର୍‌ସି । ଜେ ମକେ ଆଲାଦ୍‌ କର୍‌ସି, ମର୍‌ ବାବା ତାକେ ଆଲାଦ୍‌ କର୍‌ସି । ମୁଇ ମିସା ତାକେ ଆଲାଦ୍‌ କରି ନିଜ୍‌କେ ତାର୍‌ଟାନେ ଦେକାଇଅଇବି ।” ");
INSERT INTO dso_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ତାର୍‌ ପଚେ ଜିଉଦା, ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ନଏଁ, କଇଲା “ଏ ମାପ୍‌ରୁ ଏଟା କେନ୍ତି ଅଇସି ? ତମେ ନିଜ୍‌କେ ଦୁନିଆଇ ଦେକାଇ ନ ଅଇ ଆମର୍‌ ଲଗେ କେନ୍ତି ଦେକାଇଅଇସା ?” ");
INSERT INTO dso_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ଜିସୁ ତାକେ କ‍ଇଲା, “ଜନ୍‌ ଲକ୍‌ ମକେ ଆଲାଦ୍‌ କର୍‌ସି ସେ ମୁଇ ସିକାଇବା ବାକିଅ ମାନ୍‍ସି । ସେନ୍ତି କଲେ ମର୍‌ ବାବା ପର୍‌ମେସର୍‌ ତାକେ ଆଲାଦ୍‌ କର୍‌ସି । ବାବା ଆରି ମୁଇ ଆସି ସେ ଲକର୍‌ ଟାନେ ରଇବୁ । ");
INSERT INTO dso_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଜେ ମକେ ଆଲାଦ୍‌ ନ କରେ, ସେ ମର୍‌ ବାକିଅ ନ ମାନେ । ଆରି ମୁଇ କଇବା ଏ କାତା ସବୁ ମର୍‌ତେଇ ଅନି ନଏଁ, ମାତର୍‌ ମକେ ପାଟାଇଲା ମର୍‌ ବାବାର୍‌ ତେଇଅନି କଇଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ମୁଇ ତମର୍‌ ଲଗେ ରଇକରିସେ ଏ ସବୁ କାତା କଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ମାତର୍‌ ପର୍‌ମେସର୍‌ ଜନ୍‌ ସାଇଜକାରିଆ ସୁକଲ୍‌ ଆତ୍‌ମାକେ ମର୍‌ ନାଉଁ ଦାରି ତମର୍‌ ଲଗେ ପାଟାଇସି, ସେ ତମ୍‌କେ ସବୁ ବିସଇ ସିକାଇଦେଇସି ଆରି ମୁଇ ଜନ୍‌ ଜନ୍‌ କାତା କଇଲିଆଚି ସେଟା ସବୁ ତମ୍‌କେ ଏତାଇ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ମୁଇ ତମ୍‍କେ ସାନ୍ତି ଦେଇକରି ଗାଲିନି । ମର୍‌ ନିଜର୍‌ ସାନ୍ତି ତମ୍‌କେ ଦାନ୍‌ ଦେଇକରି ଗାଲିନି । ଏଟା ଦୁନିଆ ଦାନ୍‌ ଦେଲାପାରା ସାନ୍ତି ନଏଁ । ସେଟାର୍‌ ପାଇ ଚିନ୍ତା କରା ନାଇ କି କିଲ୍‌ବିଲ୍‌ ଅଇ ଡରା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ମୁଇ ଜାଇଟା କଇରଇଲି, ସେଟା ସୁନିଆଚାସ୍‌ । ମୁଇ ଗାଲିନି ମାତର୍‌ ଆରି ତରେକ୍‌ ବାଉଡି ଆଇବି । ମକେ ଜଦି ଆଲାଦ୍‌ କର୍‌ତାସ୍‌ ବଇଲେ, ମୁଇ ବାବାର୍‌ ଲଗେ ଗାଲିନି ବଲି ସୁନି ସାର୍‌ଦା ଅଇତାସ୍‌, କାଇକେ ବଇଲେ ମର୍‌ ବାବା ମର୍‌ତେଇଅନି ବଡ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ଜାଇଟା ସବୁ ଗଟ୍‌ବାର୍‌ ଆଚେ ସେଟା ସବୁ ମୁଇ ତମ୍‌କେ ଆଗ୍‌ତୁ ଜାନାଇଦେଲି । ଜେନ୍ତିକି ସେଟା ସବୁ ଗଟ୍‌ଲେ, ତମେ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସା । ");
INSERT INTO dso_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‌ ଆରି ଅଦିକ୍‌ ପର୍‌ କାତାବାର୍‌ତା କରି ନାପାରି । କାଇକେ ବଇଲେ, ଏ ଦୁନିଆର୍‌ ସାସନ୍‌କାରିଆ ଆଇଲାନି । ଆରି ମର୍‌ଟାନେ ତାର୍‌ କାଇ ଅଦିକାର୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ମୁଇ ମର୍‌ ବାବାକେ ଆଲାଦ୍‌ କଲିନି ଆରି ବାବାର୍‌ ଆଦେସ୍‌ ଇସାବେ କାମ୍‌ କଲିନି, ଏଟା ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ଜାନତ୍‌ ବଲି ଏନ୍ତି ଗଟ୍‍ନା ଅଇଲାନି । ଜୁ, ଆମେ ଏ ଜାଗାଇଅନି ବାରଇ ଉଟି ଜୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ମୁଇ ଅଇଲିନି ସତ୍‌ ଅଙ୍ଗୁର୍‌ ମାଲ୍‌ ଆରି ମର୍‌ ବାବା ଅଇଲାନି ଚାସି । ");
INSERT INTO dso_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ମର୍‌ଟାନେ ରଇବା ପିଲ୍‌କା ମାଲେ ପଲ୍‌ ନ ଦାର୍‌ଲେ, ସେ କାଟି ପାକାଇସି । ଆରି ଜନ୍‌ ମାଲେ ପଲ୍‌ ଦାର୍‌ସି ସେ ମାଲ୍‌ ଅଦିକ୍‌ ପଲ୍‌ ଦାର୍‌ବାକେ ପରିଚଲ୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ମର୍‌ତେଇ ଅନି ପାଇରଇବା ସିକିଆଇ ଅନି ତମେ ପରିଚଲ୍‌ ଅଇସାରି ଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ତମେ ମର୍‌ସଙ୍ଗ୍‌ ମିସିକରି ରୁଆ । ସେନ୍ତି ବଇଲେ ମୁଇ ମିସା ତମର୍‌ ସଙ୍ଗ୍‌ ରଇବି । କେନ୍ଦା ଜଦି ବୁନ୍ଦ୍‌ସଙ୍ଗ୍‌ ମିସିକରି ନ ରଇଲେ ନିଜେ ପଲ୍‌ ନ ଦାରେ, ସେନ୍ତି ତମେ ମିସା ମର୍‌ତେଇ ମିସି ନ ରଇଲେ, ପଲ୍‌ ଦାରିନାପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ମୁଇ ଅଇଲିନି ମୁଲ୍‌ ଅଙ୍ଗୁର୍‌ ମାଲ୍‌, ତମେ ଅଇଲାସ୍‌ନି ପିଲ୍‌କା ମାଲ୍‌ । ଜେ ମର୍‌ତେଇ ରଇସି ଆରି ମୁଇ ଜାର୍‌ତେଇ ରଇବି ସେ ବେସି ପଲ୍‌ ଦାର୍‌ସି, କାଇକେ ବଇଲେ ମକେ ଚାଡିକରି ତମେ କାଇଟା କରି ନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ଜେ ମର୍‌ତେଇ ନ ରଏ, ତାକେ ଗଟେକ୍‌ ଗର୍‌ଣ୍ଡି କରି ପିଙ୍ଗ୍‌ଲା ମାଲ୍‌ପାରା ବାଇରେ ପିଙ୍ଗି ଦେବାଇ ଆରି ସେଟା ସୁକି ଜାଇସି । ଏନ୍ତାରି ମାଲ୍‌ମନ୍‌କେ ଟୁଲିଆଇ ଜଇତେଇ ପିଙ୍ଗି ଦେବାଇ ଆରି ସେଟା ପଡି ଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ଜଦି ତମେ ମର୍‌ସଙ୍ଗ୍‌ ମିସିକରି ରଇସା ଆରି ମର୍‌ ବାକିଅ ତମର୍‌ ମନେ ରଇସି, ତମେ ମନ୍‌କରି କାଇ ବିସଇ ମାଙ୍ଗ୍‌ସା ବଇଲେ ସେଟା ମିଲାଇସା । ");
INSERT INTO dso_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ତମେ ବେସି ପଲ୍‌ ଦାର୍‌ଲେ, ମର୍‌ ବାବା ଡାକ୍‌ପୁଟା ପାଇସି, ଆରି ଇତିଅନି ତମେ ମର୍‌ ସତ୍‌ ସିସ୍‌ମନ୍‌ ବଲି ଜାନ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ମର୍‌ ବାବା ଜେନ୍ତି ମକେ ଆଲାଦ୍‌ କଲା ଆଚେ, ସେନ୍ତି ମୁଇ ମିସା ତମ୍‌କେ ଆଲାଦ୍‌ କଲିନି । ମର୍‌ ଆଲାଦେ ତବିର୍‌ ଅଇରୁଆ । ");
INSERT INTO dso_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ମୁଇ ଜେନ୍ତି ମର୍‌ ବାବାର୍‌ ଆଦେସ୍‌ ମାନିକରି ତବିର୍‌ ଅଇଆଚି । ସେନ୍ତି ତମେ ମର୍‌ ଆଦେସ୍‌ ମାନ୍‌ସା ବଇଲେ ମର୍‌ ଆଲାଦେ ତବିର୍‌ ଅଇକରି ରଇସା ।” ");
INSERT INTO dso_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ଜେନ୍ତିକି ମର୍‌ ସାର୍‌ଦା ତମର୍‌ ଟାନେ ରଇକରି, ସେ ସାର୍‌ଦା ପୁରାପୁରୁନ୍‌ ଅଇବାକେ ତମ୍‌କେ ଏ ସବୁ କାତା କଇଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ମୁଇ ତମ୍‌କେ ଜେନ୍ତି ଆଲାଦ୍‌ କଲିଆଚି, ସମାନ୍‌ ସେନ୍ତି ତମେ ମିସା ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ଆଲାଦ୍‌ ଅଇକରି ରୁଆ । ଏଟାସେ ମର୍‌ ଆଦେସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ନିଜର୍‌ ମଇତର୍‌ମନର୍‌ ଲାଗି ଜିବନ୍‌ ଦେବାଟା ଅଇଲାନି ସବୁର୍‌ଟାନେଅନି ବଡ୍‌ ଆଲାଦ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ମୁଇ ତମ୍‌କେ ଜନ୍‌ ଆଦେସ୍‌ ଦେଇଆଚି, ସେଟା ମାନ୍‌ସା ବଇଲେ ତମେ ମର୍‌ ମଇତର୍‌ମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ଏବେ ମୁଇ ତମ୍‌କେ ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌ ବଲି ନ ଡାକି, କାଇକେ ବଇଲେ, ଗତିଦାଙ୍ଗ୍‌ଡା ତାର୍‌ ସାଉକାର୍‌ କାଇଟା କର୍‌ସି ସେଟା ନାଜାନେ । ମାତର୍‌ ମୁଇ ତମ୍‌କେ ମଇତର୍‌ ବଲି ଡାକ୍‌ବି, କାଇକେ ବଇଲେ ମୁଇ ବାବାର୍‌ତେଇ ଅନି ଜନ୍‌ ଜନ୍‌ ବିସଇ ସୁନି ଆଚି, ସେଟା ତମ୍‌କେ କଇଦେଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ତମେ ମକେ ବାଚାସ୍‌ ନାଇ, ମାତର୍‌ ମୁଇ ତମ୍‌କେ ବାଚ୍‌ଲି ଆଚି । ଆରି ଜାଇକରି ଅଦିକ୍‌ ଅଦିକ୍‌ ପଲ୍‌ ଦାର୍‌ବାକେ ତମ୍‌କେ ଦାଇତ୍‌ ଦେଲି । ତମର୍‌ ପଲ୍‌ ସବୁ ଦିନର୍‌ ପାଇ ରଇସି । ତେବେ ତମେ ମର୍‌ ନାଉଁ ଦାରି ବାବାକେ କାଇଟା ମାଙ୍ଗ୍‌ଲେ ମିସା ସେ ତମ୍‌କେ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ତମର୍‌ ତମର୍‌ ବିତ୍‌ରେ ଆଲାଦ୍‌ କରା । ଏଟା ଅଇଲାନି ମର୍‌ ଆଦେସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ଜାନିରୁଆ, ତମ୍‌କେ ଜଦି ଏ ଦୁନିଆ ଗିନ୍‌ କର୍‌ସି, ତେବେ ତମ୍‌କେ ଗିନ୍‌ କର୍‌ବା ଆଗ୍‌ତୁସେ ମକେ ଗିନ୍‌ କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ତମେ ଜଦି ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ଅଇରଇତାସ୍‌ ଆଲେ ଏ ଦୁନିଆ ତମ୍‌କେ ନିଜର୍‌ ବାବି ଆଲାଦ୍‌ କର୍‌ତା, ମାତର୍‌ ମୁଇ ତମ୍‌କେ ବାଚି ଦୁନିଆଇଅନି ବେଗ୍‌ଲାଇ ଦେଇଆଚି । ସେଟାର୍‌ ପାଇ ଏ ଦୁନିଆ ତମ୍‌କେ ଗିନ୍‌କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ମୁଇ ଜନ୍‌ଟା କଇରଇଲି ଏତାଇଦେକା, ଗତିଦାଙ୍ଗ୍‌ଡା ତାର୍‌ ସାଉକାର୍‌ତେଇଅନି ବଡ୍‌ ନଏଁ ବଲି ମୁଇ ତମ୍‌କେ କଇରଇଲି । ସେମନ୍‌ ମକେ ସାଦି ଆଚତ୍‌ ଆରି ତମ୍‌କେ ମିସା ସାଦ୍‌ବାଇ । ଜଦି ସେମନ୍‌ ମର୍‌ ସିକିଆ ମାନିଆଚତ୍‌ ବଇଲେ ତମର୍‌ କାତା ମିସା ମାନ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ମାତର୍‌ ତମେ ମର୍‌ ଲକ୍‌ ଅଇରଇବାର୍‌ ଲାଗି ସେମନ୍‌ ତମ୍‌କେ ଏନ୍ତାରି କର୍‌ବାଇ । କାଇକେ ବଇଲେ ମକେ ଜେ ପାଟାଇଲା ଆଚେ, ସେଟା ସେମନ୍‌ ନାଜାନତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ଜଦି ମୁଇ ଆସି ଏ ସବୁ ବିସଇ ସେମନ୍‌କେ ବୁଜାଇ ନ ରଇତି ବଇଲେ, ସେମନ୍‌ ଦସି ନ ଅଇତାଇ, ମାତର୍‌ ଏ ପାପର୍‌ ଚଲାଚଲ୍‌ତି ପାଇ କାଇ ଚାଲାକି ଦେକାଇ ନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଜେ ମକେ ଗିନ୍‌ କର୍‌ସି, ସେ ମର୍‌ ବାବା ପର୍‌ମେସର୍‌କେ ମିସା ଗିନ୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ଜଦି ମୁଇ ତାକର୍‌ ବିତ୍‌ରେ କାବା ଅଇଜିବା କାମ୍‌ ନ କରି ରଇଲେ, ସେମନ୍‌ ପାପି ବଲି ଦସି ନ ଅଇତାଇ । ମାତର୍‌ ସେମନ୍‌ ମୁଇ କଲା କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ ଦେକ୍‌ଲାଇ ଆଚତ୍‌ । ଏନ୍ତି ବଇଲେ ମିସା ସେମନ୍‌ ମକେ ଆରି ମର୍‌ ବାବା ପର୍‌ମେସର୍‌କେ ଗିନ୍‌ କଲାଇ ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ମାତର୍‌ ଏସବୁ ଗଟ୍‌ବାର୍‌ ରଇଲା । କାଇକେବଇଲେ ସେଟାର୍‌ ଲାଗି ସେମନର୍‌ ସାସ୍‌ତରେ ଜାଇଟା ଲେକାଅଇଲା ଆଚେ, ସେଟା ସିଦ୍‌ ଅଇଲା । କାଇ ଦସ୍‌ ନ ରଇତେ ସେମନ୍‌ ମକେ ଗିନ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","ସତଇସେ ସାଇଜକାରିଆ ଆତ୍‌ମା ଆଇସି । ସେ ବାବାର୍‌ତେଇ ଅନି ଆସି, ପର୍‌ମେସରର୍‌ ସବୁ ବିସଇର୍‌ ସତ୍‌ ଦେକାଇଦେଇସି । ମୁଇ ତାକେ ବାବାର୍‌ତେଇଅନି, ତମର୍‌ ଲଗେ ପାଟାଇବି । ଆରି ସେ ମର୍‌ ବିସଇ ତମ୍‌କେ କଇସି । ");
INSERT INTO dso_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ଆରି ତମେ ମିସା ମର୍‌ ବିସଇସେ କଇସା, କାଇକେବଇଲେ ଆରାମେଅନି ତମେ ମର୍‌ ସଙ୍ଗ୍‍ ଆଚାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ତମେ ମକେ କରିରଇବା ବିସ୍‌ବାସ୍‌ ନ ଚାଡି, ଡାଟ୍‌ ସଙ୍ଗ୍‌ ରଇବାକେ, ମୁଇ ଏ ସବୁ କାତା କଇଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ସେମନ୍‌ ତମ୍‌କେ ପାର୍‌ତନା ଗରେଅନି ବାର୍‌କରାଇ ଦେବାଇ । ଉଁ ଏନ୍ତାରି ବେଲା ଆଇଲାନି, ଜେ ମିସା ତମ୍‌କେ ମରାଇବାଇ, ସେଟା ପର୍‌ମେସର୍‌କେ ସେବା କଲାପାରା ରଇସି । ");
INSERT INTO dso_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ତମ୍‌କେ ସେମନ୍‌ ଏନ୍ତି ସବୁ କାମ୍‌ମନ୍‌ କର୍‌ବାଇ । କାଇକେ ବଇଲେ ସେମନ୍‌ ମକେ ଆରି ମର୍‌ ବାବାକେ ନାଜାନତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ଏବେ ମୁଇ ଏ ସବୁ କାତା କଇଲିନି । ସେଟାର୍‌ ପାଇ ଏ ସବୁ ଗଟ୍‍ନାମନ୍‌ ଗଟ୍‌ବା ବେଲା କେଟ୍‌ଲେ ମୁଇ କଇଲା କାତା ଏତାଇସା । ଆରାମେ ଅନି ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‌ ରଇଲି ଜେ ଏ ସବୁ କାତା କଇ ନ ରଇଲି ।” ");
INSERT INTO dso_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ମାତର୍‌ ମୁଇ ଏବେ ମର୍‌ ପାଟାଉର୍‌ ଲଗେ ଗାଲିନି । ଏଲେମିସା ତମର୍‌ ବିତ୍‌ରେ ଅନି କେ ମିସା ମକେ କେନେ ଜାଇସୁ ବଲି ପାଚାରାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ମାତର୍‌ ଏବେ ମର୍‌ ଏ ସବୁ କାତା ସୁନିକରି ଦୁକ୍‌ ଅଇକରି ଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ମୁଇ ତମ୍‌କେ ସତ୍‌କାତା କଇଲିନି, ମୁଇ ଉଟିଜିବା ବିସଇ ତମର୍‌ ପାଇ ଗଟେକ୍‌ ମଙ୍ଗଲର୍‌ ବିସଇ ଅଇସି । କାଇକେ ବଇଲେ ମୁଇ ନ ଗାଲେ ସାଇଜକାରିଆ ତମର୍‌ଟାନେ ନ ଆସେ, ମୁଇ ଗାଲେ ତାକେ ତମର୍‌ଟାନେ ପାଟାଇଦେବି । ");
INSERT INTO dso_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ସେ ଆସିକରି ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌କେ ପାପ୍‌, ଦରମ୍‌ ଆରି ନିଆଇ ବିସଇର୍‌ ସାକି ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ଏ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ପାପ୍‌ ବିସଇ ବୁଲ୍‌ ବୁଜ୍‌ଲାଇ ଆଚତ୍‌ । ସେ ଦେକାଇ ଦେଇସି ଜେ, ମକେ ବିସ୍‌ବାସ୍‌ ନ କର୍‌ବାଟାସେ ପାପ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଟିକ୍ ଇସାବେ ଚଲାଚଲ୍‍ତି କର୍‍ବା ବିସଇ, ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ବୁଲ୍‌ ବୁଜିଆଚତ୍‌ । ମୁଇ ମର୍‌ ବାବାର୍‌ ଲଗେ ବାଉଡି ଗାଲିନି, ଆରି ତମେ ମକେ ଦେକିନାପାରାସ୍‌ । ସେଟା ମୁଇ ମାନ୍‌ବା ଦରମ୍‌ ବିସଇ ସାକି ଦେଲାନି । ");
INSERT INTO dso_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ବିଚାର୍‌ କର୍‌ବା ବିସଇ ବୁଲ୍‌ ବୁଜ୍‌ଲାଇ ଆଚତ୍‌ । କାଇକେବଇଲେ ଏ ଦୁନିଆର୍‌ ସାସନ୍‌କାରିଆ ଦସି ବଲି ବିଚାର୍‍ ଅଇ ସାରାଇ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ମୁଇ ତମ୍‌କେ କେତେକ୍‌ କେତେକ୍‌ କାତା କଇବାର୍‌ ଆଚେ । ମାତର୍‌ ଏବେ ତମେ ସେ ସବୁ କାତା ଦାରିନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ମାତର୍‌ ସତ୍‌ ଆତ୍‌ମା ଆଇଲେ, ସେ ତମ୍‌କେ ସବୁ ସତ୍‌ ବିସଇର୍‌ ବାଟେ ଡାକିନେଇସି । କାଇକେ ବଇଲେ, ସେ ନିଜର୍‌ ଅଦିକାରେ କାଇ କାତା ନ କଏ । ମାତର୍‌ ସେ ବାବାର୍‌ତେଇଅନି ଜନ୍‌ ଜନ୍‌ କାତା ସୁନ୍‍ସି, ସେ ସବୁ କଇସି । ଆରି ଆଇବା ଦିନ୍‌ମନ୍‌କେ କାଇଟା ଅଇସି ସେ ସବୁ ବିସଇ ମିସା କଇସି । ");
INSERT INTO dso_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ସେ ମୁଇ କଇବାଟାନେ ଅନି ନେଇକରି ଆକା ତମ୍‌କେ କଇସି । ଆରି ମକେ ଡାକ୍‌ପୁଟା କରାଇ ଦେକାଇସି । ");
INSERT INTO dso_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ଜନ୍‌ଟା ବାବାର୍‌ଟା, ସେ ସବୁ ମର୍‌ଟା । ସେଟାର୍‌ପାଇ ମୁଇ ତମ୍‌କେ କଇଲିନି, ସୁକଲ୍‌ ଆତ୍‌ମା ମର୍‌ଟାନେଅନି ନେଇକରି ସେ ତମ୍‌କେ କଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ଚନେକ୍‌ ଗାଲା ପଚେ ତମେ ଆରି ମକେ ଦେକି ନାପାରାସ୍‌ । ଆରି ଚନେକ୍‌ ଗାଲେ ଦେକ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ସେବେଲେ ତାର୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି କେତେ ଲକ୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ । “ସେ ଆମ୍‌କେ କଇଲାନି, ଚନେକ୍‌ ଗାଲାପଚେ ତମେ ଆରି ମକେ ଦେକି ନାପାରାସ୍‌, ଆରି ଚନେକ୍‌ ଗାଲେ ମକେ ଦେକ୍‌ସା । ମୁଇ ଏବେ ବାବାର୍‌ ଲଗେ ଗାଲିନି ବଲି କଇବା ଅରତ୍‌ କାଇଟା ?” ");
INSERT INTO dso_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ତେବେ ସେମନ୍‌ କଇଲାଇ, “ଏ ଚନେକ୍‌ ପଚେ ବଲି କାଇକେ କଇଲାନି ? ସେ କାଇଟା ବଲି କଇଲାନି, ଆମେ ବୁଜି ନାପାର୍‌ଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ସେମନ୍‌ ମକେ ପାଚାର୍‌ବାକେ ମନ୍‍ କଲାଇନି ବଲି ଜିସୁ ଜାନିକରି ସେମନ୍‌କେ କଇଲା, “ଚନେକ୍‌ ଗାଲେ ତମେ ଆରି ମକେ ଦେକି ନାପାରାସ୍‌ ଆରି ଚନେକ୍‌ ଗାଲାପଚେ ମକେ ଦେକ୍‌ସା ବଲି କଇଲା ଏ କାତା ନେଇକରି ତମର୍‌ ତମର୍‌ ବିତ୍‌ରେ କାଇକେ କୁଆବଲା ଅଇଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ତମେ ସାତାରି ସାତାରି କାନ୍ଦ୍‌ସା, ମାତର୍‌ ଦୁନିଆର୍‌ ଲକ୍‌ମନ୍‌ ସାର୍‌ଦା ଅଇବାଇ । ତମେ ପର୍‌ତୁମ୍‌ ଦୁକ୍‌ ଅଇରଇସା ମାତର୍‌ ତମର୍‌ ଦୁକ୍‌ ସାର୍‌ଦାଇ ପୁରୁନ୍‌ ଅଇଜାଇସି । ");
INSERT INTO dso_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ଗଟେକ୍‌ ମାଇଜି ନିକ ଅଇବା ବେଲା କେଟ୍‌ଲେ ବେସି ଦୁକ୍‌ ଅଇସି । କାଇକେବଇଲେ ତାର୍‌ ଦୁକ୍‌ କସ୍‌ଟର୍‌ ବେଲା କେଟିଆଚେ । ମାତର୍‌ ନିମାନ୍‌ ଅଇସାର୍‌ଲା ପଚେ ତାର୍‌ ଦୁକ୍‌ କସ୍‌ଟ ପାସ୍‌ରିଜାଇସି । କାଇକେ ବଇଲେ ତାର୍‌ତେଇଅନି ଗଟେକ୍‌ ପିଲା ଦୁନିଆଇ ଜନମ୍‌ ଅଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ସେନ୍ତାରିସେ ତମ୍‌କେ ମିସା ଅଇସି । ଏବେ ତମେ ଦୁକ୍‌ଅଇ ଆଚାସ୍‌, ମାତର୍‌ ଆରି ତରେକ୍‌ ମୁଇ ତମ୍‌କେ ଦେକାଇଅଇବି, ତାର୍‌ ପଚେ ତମେ ବେସି ସାର୍‌ଦା ଅଇସା । ଆରି କେମିସା ତମର୍‌ ସାର୍‌ଦା ତମର୍‌ଟାନେଅନି ଚାଡାଇ ନେଇ ନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ସେବେଲା ତମେ ମକେ ମୁଲ୍‌କେ ନ ପାଚାରାସ୍‌ । ମୁଇ ତମ୍‌କେ ସତ୍‌ କାତା କଇଲିନି, ତମେ ମର୍‌ ନାଉଁ ଦାରି ବାବାକେ କାଇଟା ମିସା ମାଙ୍ଗ୍‌ସା ବଇଲେ ସେଟା ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ତମେ ଏବେ ଜାକ ମର୍‌ ନାଉଁ ଦାରି କାଇଟା ମିସା ମାଙ୍ଗାସ୍‌ ନାଇତା । ଏବେ ମାଙ୍ଗା, ତେବେ ତମ୍‌କେ ମିଲ୍‌ସି । ଆରି ତମର୍‌ ସାର୍‌ଦା ପୁରାପୁରୁନ୍‌ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ମୁଇ ତମ୍‌କେ କାତା ମଲ୍‌କାଇ କରି ଏ ସବୁ କଇଲିନି, ଏନ୍ତି ବେଲା ଆଇସି, ତମ୍‌କେ ଆରି ମୁଇ କାତା ନ ମଲ୍‌କାଇ, ସଲ୍‌କେ ବାବାର୍‌ ବିସଇ କଇଦେବି । ");
INSERT INTO dso_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ତମେ ସେ ଦିନ୍‌ମନ୍‌କେ ମର୍‌ ନାଉଁ ଦାରି ପର୍‌ମେସର୍‌କେ ବେସି ବିସଇମନ୍‌ ମାଙ୍ଗ୍‌ସା । ଆରି ମୁଇ ତମର୍‌ ପାଇ ବାବା ପର୍‌ମେସରର୍‌ ତେଇ ଗୁଆରି କର୍‌ବାର୍‌ ଦର୍‌କାର୍‌ ନ ରଏ । ");
INSERT INTO dso_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","କାଇକେବଇଲେ ବାବା ତମ୍‌କେ ଆଲାଦ୍‌ କଲାନି, ସେ ତମ୍‌କେ ଆଲାଦ୍‌ କଲାନି କାଇକେବଇଲେ ତମେ ଜେନ୍ତିକି ମକେ ଆଲାଦ୍‌ କରି ଆଚାସ୍‌, ଆରି ମୁଇ ପର୍‌ମେସରର୍‌ ତେଇଅନି ଆଇଲି ଆଚି ବଲି ବିସ୍‌ବାସ୍‌ କରିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ମୁଇ ବାବାର୍‌ଟାନେଅନି ଏ ଦୁନିଆଇ ଆସିଆଚି, ଆରି ଏବେ ମୁଇ ଏ ଦୁନିଆ ଚାଡିକରି ବାବାର୍‌ ଲଗେ ବାଉଡି ଗାଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ଜିସୁର୍‌ ସିସ୍‌ମନ୍‌ କଇଲାଇ, “ଏବେ ତମେ ଆମ୍‌କେ କାତା ମଲ୍‌କାଇ ନ କଇକରି ସଲ୍‌କେସେ କଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ତମେ ସବୁ ବିସଇ ଜାନିଆଚୁସ୍‌, ଏଟା ଏବେ ଆମେ ଜାନ୍‌ଲୁ । ଆରି କେ ତମ୍‍କେ ଜାନେ କି ନାଇ ବଲି, ପାଚାର୍‌ବାର୍‌ ଲଡା ନାଇ । ଏଟାର୍‌ପାଇ ତମେ ପର୍‌ମେସରର୍‌ଟାନେ ଅନି ଆସିଆଚୁସ୍‌ ବଲି ଆମେ ବିସ୍‌ବାସ୍‌ କଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଏବେ କାଇ ତମେ ବିସ୍‌ବାସ୍‌ କଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ଦେକା, ଏନ୍ତି ବେଲା ଆଇଲାନି, ଉଁ ସେ ବେଲା କେଟ୍‌ଲା ଆଚେ, ତମେ ମକେ ଗଟେକ୍‌ ଲକ୍‌କେ ଚାଡି, ଏନେ ତେନେ ଅଇକରି ନିଜର୍‌ ନିଜର୍‌ ଗରେ ଉଟିପାଲାଇସା । ଏଲେମିସା ମୁଇ ଗଟେକ୍‌ ଲକ୍‌ ନାଇ, ସବୁବେଲା ମର୍‌ ସଙ୍ଗ୍‌ ବାବା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ଜେନ୍ତାରି କି ତମେ ମର୍‌ତେଇ ରଇକରି ସାନ୍ତି ପାଇସା, ସେଟାର୍‌ପାଇ ମୁଇ ତମ୍‌କେ ଏ ସବୁ ବିସଇ କଇଆଚି । ଏ ଦୁନିଆଇ ତମର୍‌ପାଇ ବେସି ଦୁକ୍‌ କସ୍‌ଟ ଆଚେ, ମାତର୍‌ ଡାଟ୍‌ସଙ୍ଗ୍‌ ରୁଆ, ମୁଇ ଦୁନିଆର୍‌ କାରାପ୍‌ ବପୁ ନସାଇକରି ଜିତିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ଜିସୁ ଏ ସବୁ କାତା କଇସାରାଇଲା ପଚେ, ସରଗ୍‌ ବାଟେ ଦେକି କଇଲା, “ଏ ସରଗର୍‌ ବାବା, ଏବେ ବେଲା କେଟ୍‌ଲା ଆଚେ । ତମର୍‌ ପିଲା ମକେ ଡାକ୍‌ପୁଟା କରା । ଜେନ୍ତିକି ତମର୍‌ ପିଲା ମୁଇ ତମ୍‌କେ ଡାକ୍‌ପୁଟା କର୍‌ବି । ");
INSERT INTO dso_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ତମେ ମକେ ସବୁ ମୁନୁସ୍‌ ଜାତି ଉପ୍‌ରେ ଅଦିକାର୍‌ ଦେଇଆଚାସ୍‌ । ଆରି ଜନ୍‌ଲକ୍‌ମନ୍‌କେ ମକେ ସର୍‌ପି ଦେଇଆଚାସ୍‌, ସେମନ୍‌କେ ମୁଇ ନ ସାର୍‌ବା ଜିବନ୍‌ ଦେବି । ");
INSERT INTO dso_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ତମେସେ ଗଟେକ୍‌ ପର୍‌ମେସର୍‌, ତମ୍‌କେ ଆରି ତମେ ପାଟାଇରଇବା ଜିସୁ କିରିସ୍‌ଟକେ ଜାନ୍‌ବାଟା ଅଇଲାନି ନ ସାର୍‌ବା ଜିବନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ତମେ ମକେ ଜନ୍‌ କାମ୍‌ମନ୍‌ କର୍‌ବାକେ ଦେଇଆଚାସ୍‌, ସେଟା ମୁଇ ସାରାଇ କରି, ଏ ଦୁନିଆଇ ତମ୍‌କେ ଡାକ୍‌ପୁଟା କରିଆଚି । ");
INSERT INTO dso_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ଏ ବାବା, ଏ ଦୁନିଆ ତିଆର୍‌ ନ ଅଇତେ, ତମର୍‌ ସଙ୍ଗ୍‌ ରଇଲାବେଲେ, ମର୍‌ ଜନ୍‌ ଡାକ୍‌ପୁଟା ରଇଲା, ଏବେ ତମେ ରଇତେ ଆକା, ମକେ ଡାକ୍‌ପୁଟା କର୍‍ । ");
INSERT INTO dso_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ଏ ଜଗତର୍‌ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ତମେ ମକେ ସର୍‌ପି ଦେଇରଇଲାସ୍‌, ସେମନର୍‌ ଲଗେ ମୁଇ ତମ୍‌କେ ଜାନାଇଆଚି । ସେମନ୍‌ ତମର୍‌ ଅଇରଇଲାଇ, ଆରି ମକେ ସେମନ୍‌କେ ସର୍‌ପିଦେଲୁସ୍‌ । ସେମନ୍‌ ତମର୍‌ ବାକିଅ ମାନ୍‌ଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ତମେ ମକେ ଜନ୍‌ ଜନ୍‌ଟା ସର୍‌ପି ଦେଇ ଆଚାସ୍‌, ସେଟାମନ୍‌ ସବୁ ତର୍‌ଟାନେଅନି ଆକା ଅଇଲାଆଚେ, ବଲି ଏବେ ସେମନ୍‌ ବୁଜିଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ତମେ ମକେ ଦେଇରଇବା କବର୍‌ ମୁଇ ସେମନ୍‌କେ ସୁନାଇଆଚି, ସେମନ୍‌ ସେଟା ମାନି ଆଚତ୍‌ । ମୁଇ ତମର୍‌ଟାନେଅନି ଆସିଆଚି ଆରି ତମେ ମକେ ପାଟାଇଆଚାସ୍‌, ସେମନ୍‌ ଏ କାତା ସତ୍‌ ବଲି ଜାନିକରି ବିସ୍‌ବାସ୍‌ କଲାଇ ଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ମୁଇ ସେମନର୍‌ଲାଗି ପାର୍‌ତନା କଲିନି, ଦୁନିଆର୍‌ ଲକ୍‌ମନର୍‌ ପାଇ ପାର୍‌ତନା କରିନାଇ । ମାତର୍‌ ତମେ ମକେ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ଦେଇଆଚାସ୍‌, ସେ ଲକ୍‌ମନର୍‌ ପାଇ ପାର୍‌ତନା କଲିନି । କାଇକେ ବଇଲେ ସେମନ୍‌ ତମର୍‌ ଲକ୍‌ମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ଜେତ୍‌କି ମର୍‌ଟା, ସେ ସବୁ ତମର୍‌ଟା । ଆରି ଜେତ୍‌କି ତମର୍‌ଟା ସେ ସବୁ ମର୍‌ଟା । ଆକର୍‌ଲାଗି ଆକା ମର୍‌ ଡାକ୍‌ପୁଟା ଅଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ଏବେ ମୁଇ ତମର୍‌ ଲଗେ ଆଇଲିନି, ମୁଇ ଏ ଦୁନିଆଇ ରଇନାଇ । ମାତର୍‌ ଏମନ୍‌ ରଇଲାଇନି । ସୁକଲ୍‌ ରଇବା ବାବା ! ତମେ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ମକେ ସର୍‌ପି ଦେଇଆଚୁସ୍‌, ତମେ ଦେଇରଇବା ନାଉଁର୍‌ ବପୁର୍‌ ଲାଗି ସେମନ୍‌କେ ରକିଆ କରା । ଜେନ୍ତାରି ତମେ ଆରି ମୁଇ ଗଟେକ୍‌ । ସେନ୍ତାରିସେ ସେମନ୍‌ ଗଟେକ୍‌ ଅଇରଇବାକେ ସାଇଜ କରା । ");
INSERT INTO dso_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ମୁଇ ସେମନର୍‌ ସଙ୍ଗ୍‌ ରଇଲା ବେଲେ ତମର୍‌ ନାଉଁର୍‌ ବପୁସଙ୍ଗ୍‌ ସେମନ୍‌କେ ରକିଆ କରିରଇଲି । ଜେନ୍ତି କି ସେମନ୍‌ କାଲ୍‌କାଲ୍‌ ଜୁଗ୍‌ଜୁଗ୍‌ ପର୍‌ମେସରର୍‌ଟାନେ ଅନି ବିନେ ଅଇ ନସ୍‌ଟ ନ ଅଅତ୍‌ । ଗଟେକ୍‌ ଲକ୍‌କେ ଚାଡି ସବୁଲକ୍‌କେ ରକିଆ କରିଆଚି । ସେ ଗଟେକ୍‌ ଲକ୍‌ ନସ୍‌ଟ ଅଇସି ଆକା । ଜେନ୍ତିକି ଦରମ୍‌ ସାସ୍‌ତରେ ଲେକା ଅଇଲାଟା ସିଦ୍‌ ଅଇବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ଏବେ ମୁଇ ତମର୍‌ ଲଗେ ଆଇଲିନି । ଏ ଦୁନିଆଇ ରଇଲା ବେଲେ ସେମନ୍‌କେ, ସେମନର୍‌ ମନେ ରଇବା ମର୍‌ ସାର୍‌ଦା ପୁରାପୁରୁନ୍‌ ଅଇବାକେ, ଏ ବିସଇ କଇରଇଲି । ");
INSERT INTO dso_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ମୁଇ ସେମନ୍‌କେ ତମର୍‌ ବାକିଅ ସୁନାଇଆଚି । ତେବର୍‌ପାଇ ଏ ଦୁନିଆ ସେମନ୍‌କେ ଗିନ୍‌ କଲାନି । କାଇକେ ବଇଲେ ମୁଇ ଜେନ୍ତି ଏ ଦୁନିଆଇ ଅନି ଜାତ୍‌ ଅଇଲାଟା ନଇ, ସେନ୍ତି ସେମନ୍‌ ମିସା ଏ ଦୁନିଆର୍‌ ନଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ତମେ ସେମନ୍‌କେ ଏ ଦୁନିଆଇଅନି ଦାରିଜା ବଲି ମୁଇ ପାର୍‌ତନା କରିନାଇ । ମାତର୍‌ ସଇତାନର୍‌ ପାନ୍ଦେ ଅନି ରକିଆ କରା ବଲି ଗୁଆରି କଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ମୁଇ ଜେନ୍ତିକି ଏ ଦୁନିଆର୍‌ ନଇ, ସେନ୍ତି ସେମନ୍‌ ମିସା ଏ ଦୁନିଆର୍‌ ନଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ତମର୍‌ ସତ୍‌ସଙ୍ଗ୍‌ ସେମନ୍‌କେ ସୁକଲ୍‌ କରା, ତମର୍‌ ବାକିଅ ତା ସତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ତମେ ମକେ ଜେନ୍ତି ଏ ଦୁନିଆଇ ପାଟାଇ ଆଚାସ୍‌, ସେନ୍ତାରି ମୁଇ ମିସା ସେମନ୍‌କେ ଏ ଦୁନିଆଇ ପାଟାଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ଜେନ୍ତିକି ସେମନ୍‌ ତମର୍‌ଟାନେ ସର୍‌ପି ଅଇବାଇ । ସେଟାର୍‌ପାଇ ମୁଇ ନିଜ୍‌କେ ତମର୍‌ତେଇ ସୁକଲ୍‌ ଅଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ମୁଇ ଅବ୍‌କା ଏ ସିସ୍‌ମନର୍‌ ଲାଗିସେ ପାର୍‌ତନା କରିନାଇ, ମାତର୍‌ ଏ ଲକ୍‌ମନ୍‌ ଜାନାଇବା କାତାଇଅନି ଜନ୍‌ ଲକ୍‌ମନ୍‌ ମକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବାଇ, ସେ ଲକ୍‌ମନର୍‌ ପାଇ ମିସା ପାର୍‌ତନା କଲିନି । ");
INSERT INTO dso_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ଏ ବାବା ତମେ ଜେନ୍ତାରି ମର୍‌ଟାନେ ମିସି ଗଟେକ୍‌ ଅଇଆଚାସ୍‌, ଆରି ମୁଇ ତମର୍‌ଟାନେ ମିସିକରି ଗଟେକ୍‌ ଅଇଆଚି । ସେନ୍ତାରିସେ ସେମନ୍‌ ମିସା ସେମନର୍‌ ବିତ୍‌ରେ ମିସିକରି ଗଟେକ୍‌ ଅଇ ରଇବାକେ ମୁଇ ପାର୍‌ତନା କଲିନି । ଜେନ୍ତିକି ତମେସେ ମକେ ପାଟାଇ ଆଚାସ୍‌ ବଲି ଏ ଦୁନିଆ ବିସ୍‌ବାସ୍‌ କର । ");
INSERT INTO dso_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ଜେନ୍ତି ତମର୍‌ ଡାକ୍‌ପୁଟା ମକେ ଦେଇଆଚାସ୍‌, ସେନ୍ତି ସେଟା ମୁଇ ସେମନ୍‌କେ ଦେଇଆଚି । ତେବେ ଆମେ ଗଟେକ୍‌ ଅଇରଇଲାପାରା, ସେମନ୍‌ମିସା ସେମନର୍‌ ବିତ୍‌ରେ ଗଟେକ୍‌ ଅଇରଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ତମେ ଜେନ୍ତି ମର୍‌ଟାନେ ଆଚାସ୍‌, ସେନ୍ତି ମୁଇ ମିସା ତାକର୍‌ ଟାନେ ରଇବି । ସେନ୍ତି ରଇଲେ ଆକା ସେମନ୍‌ ପୁରାପୁରୁନ୍‌ ଗଟେକ୍‌ ଅଇ ରଇବାଇ । ଏନ୍ତି ଅଇଲେ ଦୁନିଆ ଜାନ୍‌ସି ଜେ, ତମେ ମକେ ପାଟାଇ ଆଚାସ୍‌, ଆରି ମକେ ଜେନ୍ତି ଆଲାଦ୍‌ କଲାସ୍‌ନି, ସେମନ୍‌କେ ମିସା ସେନ୍ତିସେ ଆଲାଦ୍‌ କଲାସ୍‌ନି ।” ");
INSERT INTO dso_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ଏ ବାବା, ତମେ ମକେ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ଦେଇଆଚାସ୍‌, ମୁଇ ଜନ୍‌ ଜାଗାଇ ରଇବି, ସେମନ୍‌ ମିସା ମର୍‌ ସଙ୍ଗ୍‌ ରଅତ୍‌ ବଲି ମନ୍‍ କଲିନି । ତେବେ ମକେ ଦେଇରଇବା ଡାକ୍‌ପୁଟା ସେମନ୍‌ ଦେକ୍‌ବାଇ । କାଇକେ ବଇଲେ ତମେ ଏ ଦୁନିଆ ତିଆର୍‌ କର୍‌ବା ଆଗ୍‌ତୁସେ ମକେ ଆଲାଦ୍‌ କରିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ଏ ଦରମର୍‌ ବାବା, ଏ ଦୁନିଆ ତମ୍‌କେ ନାଜାନେ, ମାତର୍‌ ମୁଇ ତମ୍‌କେ ଜାନିଆଚି । ଆରି ତମେସେ ମକେ ପାଟାଇଆଚାସ୍‌ ବଲି ସିସ୍‌ମନ୍‌ ଜାନିଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ମୁଇ ସେମନ୍‌କେ ତମର୍‌ ବିସଇ ଜାନାଇ ଆଚି, ଆରି ସବୁ ବେଲେ ଜାନାଇତେରଇବି । ତେବେ ମର୍‌ଲାଗି ସେମନ୍‌ ତମର୍‌ ଆଲାଦ୍‌ ଏତାଇବାଇ ଆରି ମୁଇ ସେମନର୍‌ ମନ୍‌ ବିତ୍‌ରେ ରଇବି । ");
INSERT INTO dso_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ଜିସୁ ଏ ପାର୍‌ତନା ସାରାଇକରି ନିଜର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ କିଦ୍‌ରଣ୍‌ ନାଉଁର୍‌ ଜଲା ସେପାଟର୍‌ ଜାଗାଇ ଗାଲା । ତେଇ ଗଟେକ୍‌ ବାଡ୍‌ ରଇଲା, ଜିସୁ ଆରି ତାର୍‌ ସିସ୍‌ମନ୍‌ ସେ ବାଡେ ପୁର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ଜନ୍‌ ଜିଉଦା କି ଜିସୁକେ ସତ୍‌ରୁମନ୍‌କେ ସର୍‌ପିଦେଲା, ସେ ମିସା ସେ ଜାଗା ଜାନି ରଇଲା । କାଇକେବଇଲେ ଜିସୁ ତାର୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ସେ ବାଡେ କେତେ ତର୍‌ ଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ସେଟାର୍‌ ପାଇ ଜିଉଦା ରମିୟ ସନିଅମନର୍‌ ଗଟେକ୍‌ ଦଲ୍‌, ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାରୁସିମନ୍‌ ପାଟାଇ ରଇବା ମନ୍ଦିର୍‌ ଜାଗୁଆଲ୍‌ମନ୍‌କେ ଦାରି, ସେ ବାଡେ କେଟ୍‌ଲା । ସେମନ୍‌ ଆତ୍‌ଆତିଆର୍‌, ଲାଁତର୍‌ ଆରି ଜଇଉମ୍‌ଲା ଦାରିକରି ତେଇ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ସେବେଲା କାଇ କାଇ ଗଟ୍‍ନାମନ୍‌ ଗଟ୍‌ସି, ସେଟା ସବୁ ଜିସୁ ଜାନିକରି ଆଗ୍‌ତୁ ଗାଲା ଆରି ସେମନ୍‌କେ “ତମେ କାକେ କଜ୍‌ଲାସ୍‌ନି ?” ବଲି ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“ନାଜରିତିୟ ଜିସୁକେ କଜ୍‌ଲୁନି ।” ସେମନ୍‌ କଇଲାଇ । “ମୁଇସେ ଜିସୁ ।” ବଲି ସେମନ୍‌କେ କଇଲା । ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଉ ଜିଉଦା ମିସା ସେ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ଟିଆଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ଜିସୁ ଜେଡେବେଲା “ମୁଇ ଆକା ସେ ଲକ୍‌ ।” ବଲି ସେମନ୍‌କେ କଇଲା, ସେ ଲକ୍‌ମନ୍‌ ପଚେ ଗୁଚିଜାଇ ତଲେ ଅଦର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ଜିସୁ ସେମନ୍‌କେ ଆରିତରେକ୍‌ ପାଚାର୍‌ଲା, “ତମେ କାକେ କଜ୍‌ଲାସ୍‌ନି ?” ସେମନ୍‌ କଇଲାଇ, “ଆମେ ନାଜରିତିୟ ଜିସୁକେ କଜ୍‌ଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ଜିସୁ କଇଲା, “ମୁଇ ଆକା ସେ ଲକ୍‌ ବଲି ତମ୍‌କେ କଇଲି । ତମେ ଜଦି ମକେ କଜ୍‌ଲାସ୍‌ନି ବଇଲେ ଏ ଲକ୍‌ମନ୍‌କେ ଚାଡିଦିଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ଜେନ୍ତିକି ସେ ଆଗ୍‌ତୁ କଇରଇଲା ବାକିଅ ସିଦ୍‌ ଅଇସି, ବାବା ତମେ ମକେ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ଦେଇଆଚାସ୍‌, ସେମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌କେ ମିସା ଆଜାଇ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ସିମନ୍‌ ପିତରର୍‌ ଆତେ ଗଟେକ୍‌ କାଣ୍ଡା ରଇଲା । ସେ କାଣ୍ଡା ବାର୍‌କରାଇ ବଡ୍‌ ପୁଜାରିର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାର୍‍ ଉଜା କାନ୍‌ ଚିଡ୍‌ତେ ମାର୍‌ଲା । ସେ ଗତିଦାଙ୍ଗ୍‌ଡାର୍‌ ନାଉଁ ମାଲକ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ମାତର୍‌ ଜିସୁ ପିତର୍‌କେ କଇଲା, “ତର୍‌ କାଣ୍ଡା ଜାଗ୍‌ରତ୍‌ କରି କଲ୍‌ ବିତ୍‌ରେ ପୁରାଇ ସଙ୍ଗଇ ଦେସ୍‌ । ମର୍‌ ବାବା ପର୍‌ମେସର୍‌ ମକେ ଜନ୍‌ ଦୁକ୍‌କସ୍‌ଟ ପାଇବାକେ ପାଟାଇ ଆଚେ, ସେଟା ମୁଇ ନ ପାଇ କି ?” ");
INSERT INTO dso_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ତାର୍‌ ପଚେ ରମିୟ ସନିଅମନ୍‌, ସନିଅ ମନର୍‌ ମୁକିଅ ନେତାମନ୍‌ ଆରି ମନ୍ଦିର୍‌ ଜାଗୁଆଲ୍‌ମନ୍‌ ଜିସୁକେ ଦାରି ବାନ୍ଦ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ଆରି ତାକେ ବାନ୍ଦିକରି ପର୍‌ତୁମ୍‌ କାୟାପାର୍‌ ସାତ୍‌ରା ଆନାର୍‌ ଲଗେ ନେଲାଇ । କାଇକେ ବଇଲେ ଆନା ସେ ବରସର୍‌ ବଡ୍‌ ପୁଜାରି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ଏ କାୟାପାସେ ଆଗ୍‌ତୁ ଜିଉଦି ନେତାମନ୍‌କେ, ସବୁ ଲକର୍‌ ପାଇ ଗଟେକ୍‌ ଲକ୍‌ ମର୍‌ବାଟା ଗଟେକ୍‌ ମଙ୍ଗଲର୍‌ ବିସଇ ବଲି କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ସିମନ୍‌ ପିତର୍‌ ଆରି ଗଟେକ୍‌ ବିନ୍‌ ସିସ୍‌ ଜିସୁର୍‌ ପଚେ ପଚେ ଜାଇତେ ରଇଲାଇ । ବିନ୍‌ ସିସ୍‌ ବଡ୍‌ ପୁଜାରିକେ ଜାନି ରଇଲା । ସେଟାର୍‌ପାଇ ଜିସୁର୍‌ ସଙ୍ଗ୍‌ ବଡ୍‌ ପୁଜାରିର୍‌ ଡାଣ୍ଡେ ପୁର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ମାତର୍‌ ପିତର୍‌ ବାଇରର୍‌ ଡିଆଗଡିଲଗେ ଟିଆଅଇ ରଇଲା । ବଡ୍‌ ପୁଜାରିକେ ଜାନିରଇଲା ସିସ୍‌ ଡାଣ୍ଡେ ବାଉଡି ଆସି ଡାଣ୍ଡର୍‌ ଡିଆଗଡି ଲଗେ ଜାଗିରଇଲା । ଗତିଦାଙ୍ଗ୍‌ଡିକେ କଇକରି ପିତର୍‌କେ ବିତ୍‌ରେ ଡାକିନେଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ସେ ଡିଆଗଡି ଜାଗି ରଇଲା ଗତିଦାଙ୍ଗ୍‌ଡି ସେବେଲା ପିତର୍‌କେ ପାଚାର୍‌ଲା, “ତୁଇ ମିସା ଏ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ନଉଁସ୍‌ କି ?” ପିତର୍‌ କଇଲା “ମୁଇ ତାର୍‌ ଲକ୍‍ ନଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ସିତ୍‌ କଲାଜେ ଗତିଦାଙ୍ଗ୍‌ଡାମନ୍‌ ଆରି ଜାଗୁଆଲ୍‌ମନ୍‌ ଜଇଲାଗାଇକରି ଚାରିବେଡ୍‌ତି ଟିଆଅଇ ଜଇ ଚେକ୍‌ତେ ରଇଲାଇ । ପିତର୍‌ ମିସା ସେମନର୍‌ ସଙ୍ଗ୍‌ ଟିଆଅଇକରି ଜଇଚେକ୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ଏତ୍‌କି ବିତ୍‌ରେ ବଡ୍‌ ପୁଜାରି ଜିସୁର୍‌ ସିସ୍‌ମନର୍‌ ବିସଇ ଆରି ଜିସୁ ସିକାଇଦେଲା ବିସଇ ସେମନ୍‌କେ ପାଚାର୍‌ବାର୍‌ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ଜିସୁ ସେମନ୍‌କେ କ‍ଇଲା, “ମୁଇ ସବୁବେଲେ ଲକ୍‌ମନର୍‌ ଜାନ୍‌ତେ ସିକାଇତେ ରଇଲି । ଆରି ଜିଉଦି ଲକ୍‌ମନର୍‌ ଉପାସନା ଗରେ ଆରି ମନ୍ଦିର୍‍ତେଇ ସବୁ ଜିଉଦି ଲକ୍‌ମନ୍‌ ରୁଣ୍ଡିରଇଲା ବେଲେ ସେମନ୍‌କେ ସିକାଇଲିଆଚି । କାଇଟାମିସା ଲୁଚ୍‌ତେ କଇନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ଏନ୍ତି ବଇଲେ କାଇକେ ମକେ ପାଚାର୍‌ଲୁସ୍‌ନି ? ଜନ୍‌ ଲକ୍‌ମନ୍‌ ମୁଇ କଇଲା କାତା ସୁନିଆଚତ୍‌, ସେ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ । ମୁଇ ଜାଇଜାଇଟା କଇଲିଆଚି, ସେଟା ସେମନ୍‌ ଜାନିଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ଜିସୁ ଏ କାତା କଇବା ବେଲେ ଜିସୁର୍‌ ଲଗେ ଟିଆଅଇରଇଲା ଜାଗୁଆଲ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଜିସୁକେ ଗଟେକ୍‌ ଚାପ୍‌ଡା ମାରି କଇଲା, “ତୁଇ ବଡ୍‌ ପୁଜାରିକେ ଏନ୍ତାରି କାତା ଅଇଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ଜିସୁ ତାକେ କଇଲା “ମୁଇ ଜଦି ବୁଲ୍‌ କାତା କଇରଇଲେ, ସବୁର୍‌ ମୁଆଟେ ମର୍‌ ବୁଲ୍‌ ଦେକାଆ, ମୁଇ ସତ୍‌କାତା କଇଲିନି ବଇଲେ, ମକେ କାଇକେ ମାର୍‌ଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ତାର୍‌ପଚେ ଆନାନ୍‌ ଜିସୁକେ ବାନ୍ଦ୍‌ନେସେ ବଡ୍‌ ପୁଜାରି କାୟାପାର୍‌ ଲଗେ ପାଟାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ସିମନ୍‌ ପିତର୍‌ ଟିଆଅଇ ଜଇଚେକ୍‌ବା ବେଲେ ବିନ୍‌ ଲକ୍‌ମନ୍‌ ତାକେ ପାଚାର୍‌ଲାଇ, “ତୁଇ ମିସା ଏ ଲକର୍‌ ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ନଉଁସ୍‌ କି ?” ମାତର୍‌ ପିତର୍‌ କଇଲା, “ନାଇ ମୁଇ ତାର୍‌ ସିସ୍‌ ନଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ବଡ୍‌ ପୁଜାରିର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡାମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌ ଲକ୍‌ ଜାକେ କି ପିତର୍‌ କାନ୍‌ କାଟିପାକାଇରଇଲା, ସେ ଡାଟ୍‌ ସଙ୍ଗ୍‌ କଇଲା, “ସେ ବାଡେ ମୁଇ ତକେ ତାର୍‌ ସଙ୍ଗ୍‍ ରଇଲାଟା ଦେକି ରଇଲି । ” ");
INSERT INTO dso_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ପିତର୍‌ ଆରି ତରେକ୍‌ କଇଲା “ନାଇ ମୁଇ ତାକେ ମୁଲ୍‌କେ ନାଜାନି ।” ସମାନ୍‍ ସେଡ୍‌କି ଦାପ୍‌ରେ କୁକ୍‌ଡା ଡାକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ତାର୍‌ ପଚେ ଜିସୁକେ କାୟାପାର୍‌ ଗରେଅନି ରମିୟ ସର୍‌କାର୍‌ ପିଲାତର୍‌ତେଇ ଦାରିଗାଲାଇ । ସେଟା କୁକ୍‌ଡା ଡାକେ ଅଇରଇଲା । ଆରି ଜିସୁକେ ନିନ୍ଦା କର୍‌ବା ଲକ୍‌ମନ୍‌ ନିଜ୍‌କେ ଅସୁକଲ୍‌ ଅଇବାର୍‌ ଅଇସି ବଲିକରି ବିତ୍‌ରେ ଜାଅତ୍‌ନାଇ । କାଇକେ ବଇଲେ ନିସ୍‌ତାର୍‌ ପରବର୍‌ ବଜିର୍‌ ପାଇ ବଲି ସେମନ୍‌ ଅସୁକଲ୍‌ ଅଇବାକେ ମନ୍‌ ନ କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ତେବେ ରମିୟ ସର୍‌କାର୍‌ ପିଲାତ୍‌, ବାଇରେ ଆସିପାଚାର୍‌ଲା, “ଏ ଲକର୍‌ ବିରୁଦେ ତମର୍‌ କାଇ ଦାବି ଆନିଆଚାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ସେ ଲକ୍‌ମନ୍‌ ପିଲାତ୍‌କେ କଇଲାଇ, “ଏ ଲକ୍‌ ଜଦି ବୁଲ୍‌ କାମ୍‌ କରି ନ ରଇଲେ, ଆମେ ତମର୍‌ ଲଗେ ନ ଆନ୍‌ତୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ସେଡ୍‌କି ବେଲା ପିଲାତ୍‌ ସେମନ୍‌କେ କଇଲା, “ତମେ ତାକେ ଦାରିଜାଇକରି ତମର୍‌ ନିୟମ୍‌ ଇସାବେ ବିଚାର୍‌ କରା ।” ଜିଉଦି ନେତାମନ୍‌ କଇଲାଇ, “ଗଟେକ୍‌ ଲକ୍‌କେ ମରନ୍‌ ଡଣ୍ଡ୍ ଦେବାଟା ରମିୟ ସର୍‌କାର୍‌କେ ସେ ଆଚେ । ଜିଉଦି ଲକ୍‌ମନ୍‌ କାକେମିସା ମରନ୍‌ ଡଣ୍ଡ୍ ଦେବାକେ ଆମର୍‌ ଅଦିକାର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ଜିସୁ କେନ୍ତାରି ଅଇ ମର୍‌ବାକେ ଗାଲାନି ସେ ବିସଇ ନେଇକରି ଜନ୍‌ କାତା କଇରଇଲା ସେ କାତା ସିଦ୍‌ଅଇବାକେ ଏନ୍ତି ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ପିଲାତ୍‌ ଆରି ତରେକ୍‌ ମେଡ୍‌ ବିତ୍‌ରେ ବାଉଡି ଜାଇକରି, ଜିସୁକେ ଡାକି ପାଚାର୍‌ଲା, “ତୁଇ କାଇ ଜିଉଦି ମନର୍‌ ରାଜା କି ?” ");
INSERT INTO dso_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଜିସୁ ତାକେ କ‍ଇଲା, “ତୁଇ କାଇ ଏଟା ନିଜର୍‌ଟାନେଅନିସେ କଇଲୁସ୍‌ନି, କି ବିନ୍‌ ଲକ୍‌ମନ୍‌ ତକେ କଇଲାଜେ କଇଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତ୍‌ ପର୍‌ସନ୍‌ କଲା, “ମୁଇ ଗଟେକ୍‌ ଜିଉଦି ଲକ୍‌ ବଲି ବାବ୍‌ଲୁସ୍‌ନି କି ? ତର୍‌ ନିଜର୍‌ ଲକ୍‌ମନ୍‌ ଆରି ମୁକିଅ ପୁଜାରିମନ୍‌ ତକେ ମର୍‌ଟାନେ ସର୍‌ପି ଦେଇ ଆଚତ୍‌ । ତୁଇ କାଇ ବୁଲ୍‌ କରିଆଚୁସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଜିସୁ କଇଲା “ମର୍‌ ରାଇଜ୍‌ ଏ ଦୁନିଆର୍‌ ରାଇଜ୍‌ପାରା ନଏଁ । ଜଦି ମର୍‌ ରାଇଜ୍‍ ଏ ଦୁନିଆର୍‌ ରାଇଜ୍‌ ପାରା ଅଇତା, ସେନ୍ତାର୍‌ଆଲେ ମର୍‌ ସିସ୍‌ମନ୍‌ ମର୍‌ବାଟେ ଅଇ ଜୁଇଦ୍‌ କର୍‌ତାଇ । ଆରି ମକେ ଜିଉଦି ନେତାମନର୍‌ ଟାନେ ସର୍‌ପି ନ ଦେଇତାଇ । ମାତର୍‌ ମର୍‌ ରାଇଜ୍‌ ଏ ଦୁନିଆର୍‌ ରାଇଜ୍‌ପାରା ନଏଁ ।” ");
INSERT INTO dso_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ସେବେଲେ ପିଲାତ୍‌ ତାକେ ପାଚାର୍‌ଲା, “ଏନ୍ତି ବଇଲେ ତୁଇ କାଇ ଗଟେକ୍‌ ରାଜା ନଉଁସ୍ କି ?” ଜିସୁ କଇଲା, “ତୁଇସେ ମକେ ରାଜା ବଲି କଇଲୁସ୍‌ନି । ମୁଇ ସତ୍‌ ବାଟେ ସାକି ଦେବାକେ ଆକା ଜନମ୍‌ କରି, ଏ ଦୁନିଆଇ ଆସିଆଚି । ଜନ୍‌ଲକ୍‌ମନ୍‌ ସତ୍‌ କଜ୍‌ଲାଇନି, ସେମନ୍‌ସେ ମର୍‌ କାତା ସୁନ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତ୍‌ ଜିସୁକେ କଇଲା “ଏନ୍ତି ବଇଲେ ସତ୍‌ ବିସଇ କାଇଟା ?” ପଚେ ସେ ଡାଣ୍ଡେ ବାରଇ କରି ଜିଉଦି ନେତାମନ୍‌କେ କଇଲା, “ଏ ଲକର୍‌ଟାନେ ଡଣ୍ଡ୍‌ ଦେବା ଏତ୍‌କି କାଇ ଦସ୍‌ ଦେକିନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“ତମର୍‌ ରିତିନିତି ଇସାବେ ନିସ୍‌ତାର୍‌ ପରବ୍‌ ବେଲେ ଗଟେକ୍‌ ବନ୍ଦି ଲକ୍‌କେ, ମୁଇ ମୁକ୍‌ଲାଇବାର୍‍ ଆଚେ । ତେବର୍‍ ପାଇ ତମର୍‌ ଜିଉଦିମନର୍‌ ରାଜା ଜିସୁକେ ମୁଇ ମୁକ୍‌ଲାଇ ଦେବି । ଏଟା ତମେ ମନ୍‌କଲାସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ମାତର୍‌ ଲକ୍‌ମନ୍‌ ଆଉଲିଅଇକରି କଇଲାଇ, “ନାଇ ଏ ଲକ୍‌କେ ନାଇ, ମାତର୍‌ ବାର୍‌ବାକେ ମୁକ୍‌ଲାଇ ଦିଆସ୍‌ ।” ଏ ବାରବ୍‌ବା ଗଟେକ୍‌ ଡାକୁ ଲକ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ତାର୍‌ ପଚେ ପିଲାତ୍‌ ଜିସୁକେ ନେଇ କର୍‌ଡା ସଙ୍ଗ୍‌ ମାରା ବଲି ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ସନିଅମନ୍‌ କାଟାର୍‌ ମୁକୁଟ୍‌ ତିଆର୍‌ କରି ଜିସୁର୍‌ ମୁଣ୍ଡେ ପିନ୍ଦାଇଲାଇ ଆରି ଜାମ୍‌କଲି ରଙ୍ଗର୍‌ ପଚିଆ ଗାଗ୍‌ଡେ ପିନ୍ଦାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ସେମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସିକରି କଇଲାଇ “ଏ ଜିଉଦିମନର୍‌ ରାଜା ଜୁଆର୍‌ ! ତୁଇ ବେସି ବରସ୍‌ ବଁଚ୍‌ !” ବଲି ତାକେ ଚାପଡ୍‌ ଚାପଡ୍‌ ମାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତ୍‌ ଆରି ତରେକ୍‌ ଡାଣ୍ଡେ ବାରଇକରି ରୁଣ୍ଡିରଇଲା ଲକ୍‌ମନ୍‌କେ କଇଲା, “ଦେକା, ଏବେ ମୁଇ ତାକେ ଦସି କର୍‌ବାକେ କାଇ ବୁଲ୍‌କଲାଟା ମିଲେନାଇ । ଏଟାର୍‌ପାଇ ତମର୍‌ ଲଗେ ଆନ୍‌ବି । ଜେନ୍ତିକି ତମେ ଜାନ୍‌ବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ସେବେଲା ଜିସୁ କାଟାର୍‌ ମୁକୁଟ୍‌ ଆରି ଜାମ୍‌କଲି ରଙ୍ଗର୍‌ ପଚିଆ ପିନ୍ଦି ଡାଣ୍ଡେ ଆଇଲା । ପିଲାତ୍‌ ସେମନ୍‌କେ କଇଲା, “ଏଦେ ଦେକା ! ଏଦେ ସେ ଲକ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ତାକେ ଦେକ୍‌ଲା ଦାପ୍‌ରେ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ମନ୍ଦିର୍‌ ଜାଗୁଆଲ୍‌ମନ୍‌ ଆଉଲିଅଇକରି କଇଲାଇ, “ତାକେ କୁରୁସେ ଚଗାଆ ! ତାକେ କୁର୍‌ସେ ଚଗାଆ !” ବଲି । ପିଲାତ୍‍ କଇଲା, “ତମେ ତାକେ ନେଇକରି କୁର୍‌ସେ ଚଗାଆ, କାଇକେ ବଇଲେ, ମୁଇ ତାର୍‌ଟାନେ କାଇ ବୁଲ୍‌ ମିସା ଦେକିନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଜିଉଦି ନେତାମନ୍‌ ତାକେ କଇଲାଇ, “ଆମର୍‌ ଗଟେକ୍‌ ନିୟମ୍‌ ଆଚେ । ସେ ନିୟମ୍‌ ଇସାବେ ଏ ମର୍‌ବାର୍‌ ଆଚେ ଆକା । କାଇକେ ବଇଲେ ସେ ନିଜେ ମୁଇ ପର୍‌ମେସରର୍‌ ପିଲା ବଲି ଦାବି କଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ତେଇ ପିଲାତ୍‌ ଏ କାତା ସୁନିକରି ଅଦିକ୍‌ ଡରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ପିଲାତ୍‌ ଜିସୁକେ ଆରିତରେକ୍‌ ତାର୍‌ ମେଡେ ବାଉଡାଇ ନେଇ ପାଚାର୍‌ଲା, “ତୁଇ କନ୍ତିଅନି ଆସିଆଚୁସ୍‌ ?” ମାତର୍‌ ଜିସୁ ତାକେ ପଦେକ୍‌ ମିସା କ‍ଏନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ସେବେଲାଇ ପିଲାତ୍‌ ତାକେ କଇଲା, “ତୁଇ କାଇ ମର୍‌ ସଙ୍ଗ୍‌ କାତା ନ ଅଉସ୍‌ କି ? ତକେ ମୁକ୍‌ଲାଇବାର୍‌ ମର୍‌ ଅଦିକାର୍‌ ଆଚେ ଆରି କୁର୍‌ସେ ଚଗାଇବାର୍‌ ମିସା ମର୍‌ ଅଦିକାର୍‌ ଆଚେ । ଏଟା ତୁଇ ନାଜାନୁସ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ଜିସୁ ତାକେ କଇଲା, “ପର୍‌ମେସର୍‌ ତକେ ଦେଲାକେସେ ମର୍‌ ଉପ୍‌ରେ ତର୍‌ ଅଦିକାର୍‌ ଆଚେ, ମାତର୍‌ ତର୍‌ଟାନେ ମକେ ଜେ ସର୍‌ପି ଦେଲାଆଚେ, ତାର୍‌ ପାପ୍‌ ଅଦିକ୍‌ ଜବର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ଏ କାତା ସୁନି ପିଲାତ୍‌ ଜିସୁକେ ମୁକ୍‌ଲାଇବାକେ ଚେସ୍‌ଟା କଲା । ମାତର୍‌ ଜିଉଦି ଲକ୍‌ମନ୍‌ ଆଉଲିଅଇ କଇଲାଇ, “ତୁଇ ଜଦି ଆକେ ମୁକ୍‌ଲାଇସୁ ବଇଲେ, ସମ୍‌ରାଟର୍‌ ମଇତର୍‌ ନଉଁସ୍‌ । ଜେ ନିଜ୍‌କେ ରାଜା ବଲି ଦାବି କର୍‍ସି, ସେ ତାର୍‌ ବିରଦେ କଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ପିଲାତ୍‌ ଜିଉଦି ନେତାମନର୍‌ଟାନେଅନି ଏ କାତା ସୁନିକରି ଜିସୁକେ ବାର୍‌କରାଇ ଆନି ପାକ୍‌ନାଇ ତିଆର୍‌ ଅଇରଇଲା ବିଚାର୍‌ କର୍‌ବା ମଣ୍ଡପେ ବସ୍‌ଲା । ଜନ୍‌ଟାକି ଇବ୍‌ରୁ ବାସାଇ ଗବ୍‌ବତା ବଲି କଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ସେଦିନେ ନିସ୍‌ତାର୍‌ ପରବର୍‌ ପାଇ ତିଆର୍‌ ଅଇବା ଦିନ୍‌ ରଇଲା । ସେଟା ସେଦିନର୍‌ ଆଡ୍‌ବେଲାଇ ଅଇ ଆଇତେ ରଇଲା । ଆରି ପିଲାତ୍‌ ଜିଉଦିନେତାମନ୍‌କେ କଇଲା, “ଏଦେ ଦେକା ! ତମର୍‌ ରାଜା !” ");
INSERT INTO dso_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ସେବେଲାଇ ଜିଉଦି ଲକ୍‌ମନ୍‌ ଆଉଲିଅଇ କଇଲାଇ “ତାକେ ମରାଆ ! “ତାକେ ମରାଆ ! କୁର୍‌ସେ ଚଗାଆ !” ପିଲାତ୍‌ ସେମନ୍‌କେ କଇଲା, “ମୁଇ ତମର୍‌ ରାଜାକେ କୁର୍‌ସେ ଚଗାଇବି କି ?” ଏଟା ସୁନି ମୁକିଅ ପୁଜାରିମନ୍‌ କଇଲାଇ, “ସମ୍‌ରାଟ୍‌କେ ଚାଡିକରି ଆମର୍‌ ଆରି କେ ରାଜା ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ସାରାସାରି ପିଲାତ୍‌ ଜିସୁକେ ସେମନର୍‌ ମନ୍‍ କଲା ଇସାବେ କୁର୍‌ସେ ଚଗାଇ ମରାଇବାକେ ସର୍‌ପିଦେଲା । ତାର୍‌ପଚେ ସନିଅମନ୍‌ ଜିସୁକେ ଦାରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ଜିସୁ ତାର୍‌ ନିଜର୍‌ କୁର୍‌ସ ବଇକରି ନଅରର୍‌ ବାଇରେ ରଇବା କାପାଲ୍‌ ନାଉଁର୍‌ ଜାଗାଇ ଗାଲା । ଏବ୍‌ରି ବାସାଇ ସେ ଜାଗାକେ ଗଲ୍‌ଗାତା ବଲି କଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ତେଇ ସେମନ୍‌ ଜିସୁକେ କୁର୍‌ସେ ଚଗାଇଲାଇ । ତାର୍‌ ସଙ୍ଗ୍‍ ଦୁଇ ଲକ୍‌କେ ମିସା କୁର୍‌ସେ ଚଗାଇଲାଇ । ଦୁଇ ଲକ୍‌କେ ଦୁଇବାଟେ ଚଗାଇ ଜିସୁକେ ମଜାଇ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ଆରି ପିଲାତ୍‌ ନିଜେ ଗଟେକ୍‌ ବରଡ୍‌ ଲେକି କୁର୍‌ସେ ଅଲାଇବାକେ ଆଦେସ୍‌ ଦେଲା । ସେ ବରଡ୍‌ତେଇ ନାଜରିତିୟ ଜିସୁ, ଜିଉଦିମନର୍‌ ରାଜା ବଲି ଲେକିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ଜିସୁକେ ଜନ୍‌ ଜାଗାଇ କୁର୍‌ସେ ଚଗାଇ ରଇଲାଇ, ସେଟା ଗଡେ ଅନି ବେସି ଦୁର୍‌ ନ ରଇଲା । ସେ ବର୍‌ଡେ ଏବ୍‌ରି ବାସାଇ, ଲାଟିନ୍‌ ବାସାଇ ଆରି ଗିରିକ୍‌ ବାସାଇ ଲେକାଅଇରଇଲା । ବେସି ଲକ୍‌ମନ୍‌ ତେଇ ଲେକ୍‍ଲାଟା ପଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ସେବେଲା ଜିଉଦିମନର୍‌ ମୁକିଅ ପୁଜାରିମନ୍‌ ପିଲାତ୍‌କେ କଇଲାଇ “ ଜିଉଦିମନର୍‌ ରାଜା ବଲି ନ ଲେକି, ସେ ନିଜେ ମୁଇ ଜିଉଦିମନର୍‌ ରାଜା ବଲି କଇଲା ପାରା ଲେକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ପିଲାତ୍‌ କଇଲା “ନାଇ ମୁଇ ଜନ୍‌ଟା ଲେକ୍‌ଲି ଆଚି ସେଟା ଆରି ନ ବାଦ୍‌ଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ଜିସୁକେ କୁର୍‌ସେ ଚଗାଇଲା ପଚେ, ଚାର୍‌ଟା ସନିଅମନ୍‌ ତାର୍‌ ପଚିଆ ନେଇ ଚାରି ବାଗ୍‌ କଲାଇ । ସବୁ ସନିଅମନ୍‌କେ ଗଟେକ୍‌ ଗଟେକ୍‌ ବାଗ୍‌ ମିଲ୍‌ଲା । ସେମନ୍‌ ଜିସୁ ଉପ୍‌ରେ ପିନ୍ଦ୍‌ବା ବସ୍‍ତର୍‍ ମିସା ବେଟ୍‌ଲାଇ । ସେ ବସ୍‍ତର୍‍ ସିଲାଇ ନ ଅଇ ଉପ୍‌ରେଅନି ତଲେ ଜାକ ଗଟେକ୍‌ସେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ସେଟାର୍‌ପାଇ ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ କାତା ଅଇଲାଇ । “ଆମେ ଏ ପଚିଆ ନ ଚିରିକରି ଏଟା କାକେଅଇସି ବଲି ଜାନ୍‌ବାକେ କେଡ୍‌ ପୁଟାଉଁ ।” ଜେନ୍ତିକି ସାସ୍‌ତରେ ଲେକାଅଇଲା କାତା ସିଦ୍‌ ଅଇବାକେ ଏନ୍ତି ଅଇଲା । “ମର୍‌ ପଚିଆ ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ବାଟା କଲାଇ, ଆରି ମୁଇ ପିନ୍ଦ୍‌ବା ପଚିଆର୍‌ ପାଇ କେଡ୍‌ପୁଟାଇଲାଇ ।” ସେଟାସେ ସନିଅମନ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ଜିସୁର୍‌ କୁର୍‌ସ ଲଗେ ତାର୍‌ ଆୟା ମରିୟମ୍‌, ତାର୍‌ ଆୟାର୍‌ ବଇନି, କଲ୍‌ପାର୍‌ ମାଇଜି ମରିୟମ୍‌ ଆରି ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଟିଆଅଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ଜିସୁ ବେସି ଆଲାଦ୍‌ କର୍‌ବା ଗଟେକ୍‌ ସିସ୍‌ ତାର୍‌ ମାଆର୍‌ ଲଗେ ଟିଆ ଅଇରଇଲାଟା ଦେକି ଜିସୁ ତାର୍‌ ମାକେ କଇଲା, “ଏଦେ ଦେକା ! ତର୍‌ ପଅ !” ");
INSERT INTO dso_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ତାର୍‌ ପଚେ ସେ ସିସ୍‌କେ କଇଲା “ଏଦେ ଦେକା ! ତର୍‌ ଆୟା !” ସେଦିନେ ଅନି ସେ ସିସ୍‌ ଜିସୁର୍‌ ମାକେ ନିଜର୍‌ ଗରେ ଡାକିନେଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ଏତ୍‌କି ବିତ୍‌ରେ ଜିସୁ ସବୁ ବିସଇ ପୁରାପୁରୁନ୍‌ ଅଇଲାଟା ଜାନିପାର୍‌ଲା, ମାତର୍‌ ସାସ୍‌ତରର୍‌ ବବିସତ୍‌ କାତା ପୁରା କର୍‌ବାପାଇ ସେ କଇଲା “ମକେ ସସ୍‌ କଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ତେଇ ଗଟେକ୍‌ ନକିଟାନେ ଚପ୍‌ରା ଅଙ୍ଗୁର୍‌ ରସ୍‌ ରଇଲା । ସନିଅମନ୍‌ ଗଟେକ୍‌ ସୁତାର୍‌ ଗର୍‌ଣ୍ଡା ଚବାଲ୍‌ଲାଇ ଆରି ଡେଙ୍ଗ୍‌ ସୁଲ୍‌ଡାଙ୍ଗ୍‌ ଟିପେ ବାନ୍ଦି ଜିସୁର୍‌ ଟଣ୍ଡ୍‌ଲଗେ ଲାମାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ଜିସୁ ସେଟା କାଇକରି “ସାରିଗାଲାବେ ! ” ବଲି କ‍ଇଲା । ଏତ୍‌କି କଇକରି ତାର୍‌ ଆତ୍‌ମା ସର୍‌ପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ସେଦିନ୍‌ ନିସ୍‌ତାର୍‌ ପରବର୍‌ ନିଉତା ଦିନ୍‌ ରଇଲାଜେ, ମଲା ଗାଗଡ୍‌ କୁର୍‌ସ ଉପ୍‌ରେ ନ ରଏ, କାଇକେବଇଲେ ସେ ଦିନ୍‌ ବିସ୍‌ରାମ୍‌ବାରର୍‌ ସୁକଲ୍‌ ଦିନ୍‌ ରଇଲା । ସେଟାର୍‌ପାଇ କୁର୍‌ସେ ରଇବା ତିନ୍‌ଲକର୍‌ ଗଡ୍‌ ବାଙ୍ଗାଇକରି ବିନ୍‌ ଜାଗାଇ ନେଅତ୍‌ ବଲି ଜିଉଦିଲକ୍‌ମନ୍‌ ପିଲାତ୍‌କେ ଗୁଆରି କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ସେଟାର୍‍ପାଇ ସନିଅମନ୍‌ ଜାଇ ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ଚଗାଇଅଇରଇବା ଆରି ଦୁଇଲକର୍‌ ଗଡ୍‌ ବାଙ୍ଗାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ମାତର୍‌ ଜେଡେବେଲା ସେମନ୍‌ ଜିସୁର୍‌ ଲଗେ ଆସି ଦେକ୍‌ଲାଇଜେ, ସେ ମରିଜାଇରଇଲା । ସେଟାର୍‌ପାଇ ସେମନ୍‌ ତାର୍‌ ଗଡ୍‌ ବାଙ୍ଗାଅତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ମାତର୍‌ ଗଟେକ୍‌ ସନିଅ ଚେଲ୍‌ ସଙ୍ଗ୍‌ ତାର୍‌ ପାଞ୍ଜ୍‍ରା ତଲେ ବୁସ୍‌ଲା ଦାପ୍‌ରେ ବନି ଆରି ପାନି ବାରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଏଟା ଜେ ଦେକି ରଇଲା, ସେ ଏ ସାକି ଦେଲାଆଚେ । (ସେଟାର୍‌ ପାଇ ତମେ ମିସା ବିସ୍‌ବାସ୍‌ କରା । ତାର୍‌ ସାକିଦେଲାଟା ସତ୍‌ସେ । ଆରି ସେ ସତ୍‌କାତା କଇଲା ଆଚେ ବଲିକରି ନିଜେ ବିସ୍‍ବାସ୍‍ କର୍‍ସୁ ।) ");
INSERT INTO dso_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","କାଇକେବଇଲେ ସାସ୍‌ତରର୍‍ ଏ ବାକିଅ ପୁରାପୁରୁନ୍‌ ଅଇବାପାଇ ବଲି ଏ ସବୁ ବିସଇ ଗଟ୍‌ଲା, “ତାର୍‌ ଗଟେକ୍‌ ଆଡ୍‌ ମିସା ନ ଚିଲ୍‌ପେ ।” ");
INSERT INTO dso_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ପର୍‌ମେସରର୍‌ ସାସ୍‌ତରେ ଆରି ଗଟେକ୍‌ ବାକିଅ ଏନ୍ତାରି ଆଚେ ଜାକେ ସେମନ୍‌ ବୁସ୍‌ଲାଇଆଚତ୍‌, ତାକେ ଦେକ୍‌ବାଇ ଆରି ତାର୍‌ ବାଟେସେ ଦେକ୍‌ତେ ରଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ଏ ସବୁ ଗଟ୍‍ନା ଅଇଲା ପଚେ ଆରାମାତିଆ ଗଡର୍‌ ଜସେପ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ପିଲାତ୍‌କେ ଜିସୁର୍‌ ଗାଗଡ୍‌ ମାଙ୍ଗ୍‌ଲା । ଜସେପ୍‌ ଜିସୁର୍‌ ସିସ୍‌ ରଇଲା । ମାତର୍‌ ସେ ଜିଉଦି ନେତାମନ୍‌କେ ଡରିକରି ଜାନାଇ ନ ଅଇ ରଇତେ ରଇଲା । ପିଲାତ୍‌ ଜସେପ୍‌କେ ଜିସୁର୍‌ ଗାଗଡ୍‌ ନେ ବଇଲାକେ, ସେ ଜିସୁର୍‌ ମଲାଗାଗଡ୍‌ ଦାରି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ନିକଦିମ ମିସା ଜସେପର୍‌ ସଙ୍ଗ୍‍ ଗାଲା । ଏ ନିକଦିମ ଗଟେକ୍‌ ରାତି ଜିସୁକେ ମିସ୍‌ବାର୍‌ ଜାଇରଇଲା । ସେ ଜିସୁର୍‌ ଗାଗ୍‌ଡେ ଲାଗାଇବାକେ ଗନ୍ଦ୍‌ରସ୍‌ ଆରି ଅଙ୍ଗୁର୍‌ ମିସାଇଲା ବାସ୍‌ନା ଚିକନ୍‌ ତିରିସ୍‌ କେଜି ଆନିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ସେମନ୍‌ ଦୁଇ ଲକ୍‌ ମିସିକରି ଜିଉଦିମନର୍‌ ରିତିନିତି ଇସାବେ ଜିସୁର୍‌ ଗାଗଡ୍‌ ନେଇ ବାସ୍‌ନା ଦିନ୍‌ସୁ ସଙ୍ଗ୍‌, ଡେଙ୍ଗ୍‌ ପଚିଆ ଗୁଡିଆଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ତାକେ ଜନ୍‌ ଜାଗାଇ କୁର୍‌ସେ ଚଗାଇ ରଇଲାଇ, ସେ ଜାଗାଇ ଗଟେକ୍‌ ବାଡ୍‌ ରଇଲା । ଆରି ସେ ବାଡେ ମଲା ଲକ୍‌ମନ୍‌କେ ସଙ୍ଗଇବାକେ ଗଟେକ୍‌ ନୁଆ ପାଆର୍‌ ରଇଲା । ସେ ପାଆରେ କେବେ ମିସା କାକେ ନ ସଙ୍ଗଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ବିସ୍‌ରାମ୍‌ ବାରର୍‌ ନିଉତା ଦିନ୍‌ ଅଇରଇଲା ଆରି ସେ ପାଆର୍‌ ଲଗେ ରଇଲା ଜେ, ସେମନ୍‌ ଜିସୁର୍‌ ଗାଗଡ୍‌ ନେଇକରି ସେ ପାଆରେ ସଙ୍ଗଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ଆଟର୍‌ ପର୍‌ତୁମ୍‌ ଦିନର୍‌ ସାକାଲେ ଜୁଲ୍‌ପୁଲ୍‌ ଉଜଲ୍‌ ବେଲାଇ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଜିସୁକେ ପାକ୍‌ନା ସଙ୍ଗ୍‌ ତିଆର୍‌ କରି ସଙ୍ଗଇଲା ପାଆରେ ଆସିକରି ଡାବିରଇଲା ପାକ୍‌ନା ଗୁଚିରଇଲାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ସେଟାର୍‌ପାଇ ସେ ପାଲାଇ କରି ସିମନ୍‌ ପିତର୍‌ ଆରି ଜିସୁ ଜନ୍‌ ସିସ୍‌କେ ବେସି ଆଲାଦ୍‌ କର୍‌ତେ ରଇଲା, ସେମନ୍‍କେ ଆସି କଇଲା, “ସେମନ୍‌ ମାପ୍‌ରୁକେ, ସଙ୍ଗଇଲା ଜାଗାଇଅନି ଦାରିଗାଲାଇ ଆଚତ୍‌ । ଆରି ତାକେ କନ୍‌ ଜାଗାଇ ସଙ୍ଗଇଲାଇ ଆଚତ୍‌ ସେଟା ଆମେ ନାଜାନୁ ।” ");
INSERT INTO dso_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ସେଡ୍‌କି ବେଲେ ପିତର୍‌ ଆରି ସେ ସିସ୍‌, ଜିସୁକେ ସଙ୍ଗଇଲା ଜାଗାଇ ଜିବାକେ ବାରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ସେମନ୍‌ ଦୁଇ ଲକ୍‌ ମିସ୍‌ତେ ପାଲାଇତେ ରଇଲାଇ । ଆରି ସେ ବିନ୍‌ ସିସ୍‌ ପିତର୍‌କେ ପଚେ କରି ଆଗ୍‌ତୁ ସଙ୍ଗଇ ରଇଲା ଜାଗାଇ କେଟ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ସେ ପାଆର୍‌ ବିତ୍‌ରେ ଲଇଁକରି ଏରି ଦେକ୍‌ଲାଜେ, ଏଦେ ଦେକା ! ତେଇ ଜିସୁର୍‌ ଗାଗ୍‍ଡେ ଗୁଡିଆଇ ଅଇରଇଲା ଲୁଗା ଅଦ୍‌ରିରଇଲାଟା ଦେକ୍‌ଲା । ମାତର୍‌ ସେ ବିତ୍‌ରେ ପୁରେନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ପଚେ ସିମନ୍‌ ପିତର୍‌ ମିସା ତାର୍‌ ପଚେ ପଚେ ଜାଇ କେଟ୍‌ଲା ଆରି ପାଆର୍‌ ବିତ୍‌ରେ ଜାଇ ତେଇ ଅଦ୍‌ରି ରଇଲା ଲୁଗା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ଆରି ଜିସୁର୍‌ ମୁଣ୍ଡେ ଜନ୍‌ ଲୁଗା ଗୁଡିଆଇ କରି ବାନ୍ଦିରଇଲାଇ, ସେଟା ପାତଲ୍‌ ଲୁଗା ସଙ୍ଗ୍‌ ନ ଅଇକରି ଗଟେକ୍‌ ବିନ୍‌ଟାନେ ଗୁଡିଆଇଅଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ତାର୍‌ ପଚେ ସେ ବିନ୍‌ ସିସ୍‌ ଜେକି ଆଗ୍‌ତୁ କେଟି ରଇଲା ସେ ପାଆର୍‌ ବିତ୍‌ରେ ଜାଇକରି ସେଟା ସବୁ ଦେକିକରି ବିସ୍‌ବାସ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(ସେ ସିସ୍‌ମନ୍‌ ସେ ବେଲା ଜାକ ପର୍‌ମେସରର୍‌ ବଇତେଇ ଲେକା ଅଇଲା ଇସାବେ, ଜିସୁ ମଲାଟାନେଅନି ଆରି ତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ସି ବଲି ବୁଜି ନ ରଇଲାଇ ।) ");
INSERT INTO dso_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ତାର୍‌ ପଚେ ସିସ୍‌ମନ୍‌ ପାଆର୍‌ ଦେକି ସାରାଇ ଗରେ ବାଉଡି ଉଟି ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ମାତର୍‌ ମରିୟମ୍‌ ଜିସୁର୍‌ ଗାଗଡ୍‌ ସଙ୍ଗଇରଇଲା ପାଆର୍‌ ଲଗେ ଟିଆଅଇ କାନ୍ଦ୍‌ତେ ରଇଲା । ସେ କାନ୍ଦି କାନ୍ଦି ଲଇଁକରି ପାଆର୍‌ ବିତ୍‌ରେ ଦେକ୍‌ଲା, ");
INSERT INTO dso_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ଆରି ଏଦେ ଦେକା ! ତେଇ ଦବ୍‍ପଚିଆ ପିନ୍ଦିରଇବା ଦୁଇଟା ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌ ଜିସୁକେ ଜନ୍‌ ଜାଗାଇ ସଙ୍ଗଇରଇଲାଇ, ଗଟେକ୍‌ ଲକ୍‌ ମୁଣ୍ଡ୍‌ବାଟେ ଆରିଗଟେକ୍‌ ଲକ୍‌ ଗଡ୍‌ବାଟେ ବସିରଇଲାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ସେମନ୍‌ ମରିୟମ୍‌କେ ପାଚାର୍‌ଲାଇ, “ତୁଇ କାଇକେ ମା କାନ୍ଦ୍‌ଲୁସ୍‌ନି ?” ମରିୟମ୍‌ କଇଲା, “ ସେମନ୍‌ ମର୍‌ ମାପ୍‌ରୁର୍‌ ଗାଗଡ୍‌ କେନେକି ଦାରିଗାଲାଇ ଆଚତ୍‌ । ଆରି ସେମନ୍‌ ତାକେ କନ୍ତି ସଙ୍ଗଇଲାଇ ଆଚତ୍‌ ସେଟା ମୁଇ ନାଜାନି ।” ");
INSERT INTO dso_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ସେ ଏନ୍ତି କଇକରି ପାସଲ୍‌ଲା ବେଲେ, ତେଇ ଜିସୁ ଟିଆଅଇ ରଇଲାଟା ଦେକ୍‌ଲା । ମାତର୍‌ ମରିୟମ୍‌ ତାକେ ଜିସୁ ବଲି ଚିନି ନାପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ଜିସୁ ତାକେ ପାଚାର୍‌ଲା “ଏ ମାଆ ତୁଇ କାଇକେ କାନ୍ଦ୍‌ଲୁସ୍‌ନି ? ତୁଇ କାକେ କଜ୍‌ଲୁସ୍‌ନି ?” ମରିୟମ୍‌ ଏ ଲକ୍‌ ବାଡର୍‍ କାମ୍‌ କରୁ ମାଲି ବଲି ବାବିକରି ତାକେ କଇଲା, “ଏ ଆଗିଆଁ, ତୁଇ କାଇ ଜିସୁର୍‌ ଗାଗଡ୍‌ ନେଇ ଆଚୁସ୍‌ କି ? ତାକେ ତୁଇ କନ୍ତି ସଙ୍ଗଇ ଆଚୁସ୍‌ ? ମକେ କଇଦେ, ମୁଇ ଜାଇକରି ତାକେ ଦାରିଜିବି ।” ");
INSERT INTO dso_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ଜିସୁ ତାକେ “ମରିୟମ୍‌ !” ବଲି ଡାକ୍‌ଲା । ମରିୟମ୍‌ ତାର୍‌ ବାଟେ ପାସ୍‌ଲି କରି “ରାବ୍‌ବୁନି !” ବଲି ଏବ୍‌ରି ବାସାଇ କଇଲା । ଏଟାର୍‌ ଅରତ୍‌ ଅଇଲାନି ଗୁରୁ । ");
INSERT INTO dso_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ଜିସୁ ତାକେ କଇଲା, “ମକେ ଦାରି ର ନାଇ, ଏବେ ଜାକ ମୁଇ ବାବା ପର୍‌ମେସର୍‌ ଲଗେ ଜାଇନାଇ । ମାତର୍‌ ତୁଇ ଜାଇକରି ମର୍‌ ବାଇମନ୍‌କେ କଅ, ମୁଇ, ମର୍‌ ବାବା ଆରି ସେମନର୍‌ ବାବା, ମର୍‌ ପର୍‌ମେସର୍‌ ଆରି ସେମନର୍‌ ପର୍‌ମେସରର୍‌ ଲଗେ ବାଉଡି ଗାଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ସିସ୍‌ମନର୍‌ ଲଗେ ବାଉଡି ଗାଲା ଆରି କଇଲା “ମୁଇ ମାପ୍‌ରୁକେ ଦେକ୍‌ଲି ଆଚି ।” ଆରି ଜିସୁ କଇଲା ସବୁ କାତା ସିସ୍‌ମନ୍‌କେ କଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ସେ ଦିନ୍‌ ଆଟର୍‌ ପର୍‌ତୁମ୍‌ ଦିନ୍‌ ଅଇରଇଲା । ସଞ୍ଜ୍‌ ବେଲା ସବୁ ସିସ୍‌ମନ୍‌ ଗଟେକ୍‌ ତେଇ ରୁଣ୍ଡ୍‌ଲାଇ । ସେମନ୍‌ ଜିଉଦି ନେତାମନ୍‌କେ ଡରିକରି ଗରର୍‌ କାପାଟ୍‌ ସବୁ ଡାବିଅଇଦେଇ ରଇଲାଇ । ସେ ବେଲା, ଏଦେ ଦେକା ! ଜିସୁ ଅଟାତ୍‌ ସେମନ୍‌କେ ଦେକାଇଅଇକରି ସେମନ୍‌ ଟିଆଅଇଲା ଜାଗାଇ “ତମ୍‌କେ ସାନ୍‌ତି ମିଲ !” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଜିସୁ ଏ କାତା କଇଲା ପଚେ ନିଜର୍‌ ଆତ୍‌ ଆରି ପାଞ୍ଜ୍‍ରା ଦେକାଇଲା । ସିସ୍‌ମନ୍‌ ମାପ୍‌ରୁକେ ଦେକିକରି ବେସି ସାର୍‌ଦା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଜିସୁ ଆରି ତରେକ୍‌ ସେମନ୍‌କେ କଇଲା “ତମ୍‌କେ ସାନ୍ତି ମିଲ ! ବାବା ପର୍‌ମେସର୍‌ ମକେ ଜେନ୍ତି ପାଟାଇଆଚେ, ସେନ୍ତିସେ ମୁଇ ତମ୍‌କେ ପାଟାଇଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ତାର୍‌ ପଚେ ଜିସୁ ସେମନର୍‌ ଉପ୍‌ରେ ପୁଣ୍ଡ୍‌ଲା ଆରି “ତମେ ସୁକଲ୍‌ ଆତ୍‌ମାକେ ନାମା !” ");
INSERT INTO dso_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“ ଜଦି ତମେ ଲକ୍‌ମନର୍‌ ପାପ୍‌ କେମା କର୍‌ସା ବଇଲେ, ପର୍‌ମେସର୍‌ ମିସା ସେମନର୍‌ ପାପ୍‌ କେମା ଦେଲା ଆଚେ । ଜଦି ତମେ ଲକ୍‌ମନର୍‌ ପାପ୍‌ କେମା ନ କରାସ୍‌ ବଇଲେ ପର୍‌ମେସର୍‌ ମିସା ସେମନର୍‌ ପାପ୍‌ କେମା ନ କରେ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ଜିସୁର୍‌ ବାର୍‌ଟା ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ତମା ଜାକେକି ଜଅଁଲା ବଲି ଡାକ୍‌ବାଇ, ଜିସୁ ସିସ୍‌ମନ୍‌କେ ଦେକାଇଅଇଲା ବେଲେ ସେ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ସେଟାର୍‌ ପାଇ ତେଇ ରଇଲା ବିନ୍‌ ସିସ୍‌ମନ୍‌ ତମା ଆଇଲା ପଚେ କଇଲାଇ, ଆମେ ମାପ୍‌ରୁକେ ଦେକ୍‌ଲୁ ଆଚୁ । ମାତର୍‌ ତମା କଇଲା, “ମୁଇ ତାର୍‌ ଆତେ କୁଟିର୍‌ ଚିନ୍‌ ନ ଦେକ୍‌ତେ ଆରି ସେ ଚିନେ ମର୍‌ ଆଙ୍ଗ୍‍ଟି ନ ଚିଙ୍ଗ୍‌ଲାଇବା ଜାକ ଆରି ତାର୍‌ ପାଞ୍ଜ୍‍ରାଇ ଆତ୍‌ ନ ପୁରାଇବା ଜାକ ବିସ୍‌ବାସ୍‌ ନ କରି ।” ");
INSERT INTO dso_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ଗଟେକ୍‌ ଆଟ୍‌ ଗାଲା ପଚେ ସିସ୍‌ମନ୍‌ ଆରି ତରେକ୍‌ ଗର୍‌ ବିତ୍‌ରେ ରଇଲାଇ, ତମା ମିସା ସେମନର୍‌ ସଙ୍ଗ୍‌ ତେଇ ରଇଲା । କାପାଟେ ଗାଡା ଦେଇରଇଲାଇ । ମାତର୍‌ ଏଦେ ଦେକା ! ଆଗ୍‌ତୁର୍‌ ପାରା ଜିସୁ ଗର୍‌ ବିତ୍‌ରେ ପୁରିକରି ସେମନର୍‌ ମଜାଇ ଟିଆଅଇକରି କଇଲା, “ତମ୍‌କେ ସାନ୍ତି ମିଲ !” ");
INSERT INTO dso_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ତାର୍‌ ପଚେ ଜିସୁ ତମାକେ କଇଲା, “ତର୍‌ ଆଙ୍ଗ୍‍ଟି ଇତି ସଙ୍ଗଇ ମର୍‌ ଆତ୍‌ ଦେକ୍‌, ଆରି ମର୍‌ ପାଞ୍ଜ୍‍ରାଇ ଆତ୍‌ ପୁରାଇ ଦେକ୍‌ । ଆରି କେବେ ମିସା ବିସ୍‌ବାସ୍‌ କରିନାଇ ବଲି କ‍ଅ ନାଇ, ମାତର୍‌ ବିସ୍‌ବାସ୍‌ କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ତମା ଜିସୁକେ କଇଲା, “ଏ ମର୍‌ ମାପ୍‌ରୁ, ଏ ମର୍‌ ପର୍‌ମେସର୍‌ !” ");
INSERT INTO dso_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଜିସୁ ତାକେ କଇଲା, “ତୁଇ ମକେ ଦେକିକରି ବିସ୍‌ବାସ୍‌ କଲୁସ୍‌ନି କି ? ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ମନ୍‌ ମକେ ନ ଦେକିକରି ମିସା ବିସ୍‌ବାସ୍‌ କଲାଇନି, ସେମନ୍‌ କେତେ ସାର୍‌ଦା ପାଇବାଇ ! ” ");
INSERT INTO dso_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ଜିସୁ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‌ ରଇଲାବେଲେ କେତେକ୍‌ କେତେକ୍‌ କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କରିରଇଲା । ସେଟା ସବୁ ଏ ବଇତେଇ ଲେକା ଅଏନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ମାତର୍‌ ଏତ୍‌କିସେ ଲେକାଅଇଲା, “ତମେ ଜେନ୍ତିକି ବିସ୍‌ବାସ୍‌ କର୍‌ସା ଜେ, ଜିସୁସେ ପର୍‌ମେସରର୍‌ ପଅ, ଜେକି ମସିଅ, ଆରି ତାକେ ବିସ୍‌ବାସ୍‌ କଲେସେ ତମେ ଜିବନ୍‌ ପାଇସା ।” ");
INSERT INTO dso_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ତାର୍‌ ପଚେ ଜିସୁ ନିଜେ ଆରି ତରେକ୍‌ ସିସ୍‌ମନ୍‌କେ ତିବିରିଆର୍‌ ଗାଡ୍‌ପାଲି ଦେକାଇଅଇଲା । ସେଟା ଏନ୍ତି ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ଜିସୁର୍‌ କେତେଟା ସିସ୍‌ମନ୍‌ ଗଟେକ୍‌ ତେଇ ରୁଣ୍ଡିରଇଲାଇ । ସେମନ୍‌ ଅଇଲାଇନି, ସିମନ୍‌ ପିତର୍‌, ବିଦୁମ୍‌ ବଲି ଡାକ୍‌ବା ତମା ନାଉଁର୍‌ ସିସ୍‌, ଗାଲିଲି ଦେସର୍‌ କାନା ଗଡେ ରଇଲା ନିତନିଏଲ୍‌, ଜେବଦିର୍‌ ଦୁଇଟା ପିଲା ଜାକୁବ୍‌, ଜଅନ୍‌ ଆରି ବିନ୍‍ ଦୁଇଟା ସିସ୍‌ମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ସିମନ୍‌ ପିତର୍‌ ସେମନ୍‌କେ “ମୁଇ ମାଚ୍‌ ଦାର୍‌ବାର୍‌ ଗାଲିନି ।” ବଲି କଇଲା । ସେମନ୍‌ ମିସା “ତର୍‌ ସଙ୍ଗ୍‌ ଆଇବୁ ।” ବଲି କଇଲାଇ । ଆରି ଡଙ୍ଗାଇ ଚଗି, ସେମନ୍‌ ଗୁଲାଇ ରାତି ଜାଲ୍‌ ମାର୍‌ଲାଇ, ମାତର୍‌ ମୁଲ୍‌କେ ଦାରତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ଆର୍‌କର୍‌ ଦିନେ ଜୁଲ୍‌ପୁଲ୍‌ ଉଜଲେ ଜିସୁ ଗାଡ୍‌କଣ୍ଡି ଟିଆଅଇରଇଲା । ମାତର୍‌ ସିସ୍‌ମନ୍‌ ତାକେ ଜିସୁ ବଲି ଚିନି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଜିସୁ ସେମନ୍‌କେ ପାଚାର୍‌ଲା, “ଏ ମଇତର୍‌ମନ୍‌ ତମେ ଜଡେକ୍‌ ମିସା ମାଚ୍‌ ଦାରାସ୍‌ ନାଇ କି ?” ସେମନ୍‌ “ମୁଲ୍‌କେ ଦାରୁ ନାଇ ।” ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ଡଙ୍ଗାର୍‌ ଉଜାବାଟେ ଜାଲ୍‌ ମାରା, ତମେ ମାଚ୍‍ଦାର୍‌ସା ଆଲେ ।” ସେ କଇଲା ପାରା ଜାଲ୍‌ ପାକାଇଲାଇ ଜେ, ଏତର୍‌ ତାକର୍‌ ଜାଲେ ଏତେକ୍‌ ମାଚ୍‌ ଲାଗ୍‌ଲାଇଜେ, ସେମନ୍‌ ଜାଲ୍‌ ଜିକି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ଜିସୁ ଜନ୍‌ ସିସ୍‌କେ ଆଲାଦ୍‌ କର୍‌ତେ ରଇଲା, ସେ ସିସ୍‌ ପିତର୍‌କେ କଇଲା, “ଏଦେ ଦେକା ! ଏଟା ନିଜେ ଆମର୍‌ ମାପ୍‌ରୁ ସେ !” ପିତର୍‌ ଏଟା ମାପ୍‌ରୁ ଆକା ବଲି କଇଲାଟା ସୁନିକରି ବେଟି ସଙ୍ଗଇଲା ବସ୍‍ତର୍‍ ପିନ୍ଦି ଗାଡେ ଡେଗଇଦେଲା । କାଇକେ ବଇଲେ ସେ ମାଚ୍‌ ଦାର୍‌ବାବେଲେ, ଉପ୍‌ରେ ପିନ୍ଦ୍‌ଲା ବସ୍‍ତର୍‍ ବେଟି ସଙ୍ଗଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ଆରି ବାକି ସିସ୍‌ମନ୍‌ ମାଚ୍‌ ବର୍‌ତି ରଇଲା ଜାଲ୍‌ ଜିକିଜିକି ଡଙ୍ଗା କଣ୍ଡିତେଇ ଆନି ଲାଗାଇଲାଇ । ସେମନ୍‌ କଣ୍ଡିଅନି ଦୁଇସ ଆତ୍‌ ଦୁରିକେସେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ସିସ୍‌ମନ୍‌ ଡଙ୍ଗାଇଅନି ଉତ୍‌ରିକରି ପଦାଇ କେଟ୍‌ଲାବେଲେ, ଜଇରଇଲା ଇଙ୍ଗ୍‌ରା ଉପ୍‌ରେ କେତେଟା ବାଜିଅଇଲା ମାଚ୍‌ ଆରି ରୁଟି ସଙ୍ଗଇଅଇ ରଇଲାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ତାର୍‌ ପଚେ ଜିସୁ “ତମେ ଏବେ ଦାର୍‌ଲା କେତେଟା ମାଚ୍‌ ଆନା ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ସେଟାର୍‌ ପାଇ ସିମନ୍‌ ପିତର୍‌ ଜାଇ ମାଚ୍‌ ବର୍‌ତି ରଇଲା ଜାଲ୍‌ ପଦାପାଲିକେ ଜିକି ଆନ୍‌ଲା । ସେ ଜାଲେ ସଏ ପଚାସ୍‌ ତିନ୍‌ଟା ବଡ୍‌ବଡ୍‌ ମାଚ୍‌ ଲାଗି ରଇଲାଇ । ମାଚ୍‌ମନର୍‌ ଲାଗି ବେସି ବଜ୍‌ ରଇଲା ମିସା, ଜାଲ୍‌ ଚିଡେନାଇ । ");
INSERT INTO dso_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଜିସୁ ସେମନ୍‌କେ “ଆସା କାଆ !” ବଲି କଇଲା । ସିସ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି କେ ମିସା ତୁଇ କେ ? ବଲି ପାଚାର୍‌ବାକେ ସାଆସ୍‌ କରତ୍‍ ନାଇ । କାଇକେ ବଇଲେ ସେମନ୍‌ ସେ ମାପ୍‌ରୁ ବଲି ଜାନି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଜିସୁ ତାକର୍‌ ଲଗେ ଜାଇ ରୁଟି ଆରି ମାଚ୍‌ ବାଟାକରିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ଜିସୁ ମରିକରି ଜିବନ୍‌ଅଇ, ସିସ୍‌ମନ୍‌କେ ଏଟା ସଙ୍ଗ୍‌ ମିସାଇ, ତିନ୍‌ତର୍‌ ଦେକାଇଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ସେମନ୍‌ କାଇଲା ପଚେ ଜିସୁ ସିମନ୍‌ ପିତର୍‌କେ କଇଲା, “ଜଅନର୍‌ ପଅ ସିମନ୍‌, ତୁଇକାଇ ଏମନର୍‌ତେଇଅନି ମକେ ଅଦିକ୍‌ ଆଲାଦ୍‌ କଲୁସ୍‌ନି କି ?” ପିତର୍‌ କଇଲା, “ଉଁ ମାପ୍‌ରୁ ମୁଇ ଆଲାଦ୍‌ କଲିନି ବଲି ତୁଇ ଜାନିଆଚୁସ୍‌ ।” ଜିସୁ ତାକେ “ତୁଇ ମର୍‌ ମେଣ୍ଡାମନ୍‌କେ ନିମାନ୍‌ କରି ଜତନ୍‌ କର୍‌ ।” ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ତାର୍‌ ପଚେ ଜିସୁ ଆରି ତରେକ୍‌ ତାକେ ପାଚାର୍‌ଲା, “ଜଅନର୍‌ ପଅ ସିମନ୍‌, ତୁଇ କାଇ ମକେ ସତଇସେ ଆଲାଦ୍‌ କଲୁସ୍‌ନି କି ?” ପିତର୍‌ କଇଲା, “ଉଁ ମାପ୍‌ରୁ ମୁଇ ତକେ ଆଲାଦ୍‌ କଲିନି ବଲି ତୁଇ ଜାନିଆଚୁସ୍‌ ।” ତାର୍‌ ପଚେ ଜିସୁ କଇଲା, “ସେନ୍ତାର୍‌ଆଲେ ମର୍‌ ମେଣ୍ଡାମନର୍‌ ଜତନ୍‌ କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ଜିସୁ ଦୁଇତର୍‌ ପାଚାରି ସାରି ଆରିତରେକ୍‌ ପାଚାର୍‌ଲା, “ଏ ଜଅନର୍‌ ପଅ ସିମନ୍‌ ତୁଇ ମକେ ଆଲାଦ୍‌ କଲୁସ୍‌ନି କି ?” ଜିସୁ ତାକେ ତିନ୍‌ ତର୍‌ ଜାକ ଗଟେକ୍‌ କାତାସେ ପାଚାର୍‌ଲାଜେ ପିତର୍‌ ଦୁକ୍‌ ଅଇଗାଲା, ଆରି କଇଲା, “ଏ ମାପ୍‌ରୁ ! ମୁଇ ଆଲାଦ୍‌ କଲିନି ବଲି ତୁଇ ସବୁ ଜାନିଆଚୁସ୍‌ ।” ଜିସୁ ପିତର୍‌କେ କଇଲା, “ତୁଇ ମର୍‌ ମେଣ୍ଡାମନ୍‌କେ ନିମାନ୍‌ କରି କୁଆଉ । ");
INSERT INTO dso_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“ମୁଇ ତକେ ସତ୍‌ କାତା କଇଲିନି, ତୁଇ ଦାଙ୍ଗ୍‌ଡା ରଇଲାବେଲେ, ଚକା ପଚିଆ ପିନ୍ଦି କରି ଜେନେ ପାର୍‌ଲା ତେନେ ଜାଇତେ ରଇଲୁସ୍‌ । ମାତର୍‌ ଡକ୍‌ରା ଅଇଲେ ଆତ୍‌ ଟେକ୍‌ସୁ, ଆରି ବିନ୍‌ ଲକ୍‌ମନ୍‌ ତକେ ବାନ୍ଦି ଜନ୍ତି ଜିବାକେ ମନ୍‌ ନ ରଏ, ସେ ବାଟେସେ ତକେ ନେବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ସେ କେନ୍ତାରି ଅଇ ମରିକରି ପର୍‌ମେସରର୍‌ ଡାକ୍‌ପୁଟା କର୍‌ସି, ସେଟା ଜାନାଇବାକେ ଜିସୁ ଏନ୍ତାରି କଇଲା । ଏନ୍ତି କଇ ସାରାଇ ସେ ପିତର୍‌କେ କଇଲା “ମର୍‌ ସଙ୍ଗ୍‌ ଆଉ ।” ");
INSERT INTO dso_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ପିତର୍‌ ପାସ୍‌ଲିକରି ଜିସୁର୍‌ ଆଲାଦର୍‌ ବିନ୍‌ ସିସ୍‌କେ ଦେକ୍‌ଲା । ଜାକେ କି ଜିସୁ ବେସି ଆଲାଦ୍‌ କର୍‌ତେରଇଲା । ଜନ୍‌ ସିସ୍‌ କି ରାତିଆ କାଇଲାବେଲେ ଜିସୁର୍‌ ବୁକେ ଆଉଜି ଅଇକରି ପାଚାରିରଇଲା । “ମାପ୍‌ରୁ କେ ତମ୍‌କେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା ସତ୍‌ରୁମନ୍‍କେ ସର୍‌ପି ଦେଇସି ?” ");
INSERT INTO dso_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପିତର୍‌ ସେ ସିସ୍‌କେ ଦେକି ଜିସୁକେ ପାଚାର୍‌ଲା, “ଏ ମାପ୍‌ରୁ ଆର୍‌ ବିସଇ କାଇଟା ଅଇସି ?” ");
INSERT INTO dso_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ଜିସୁ ତାକେ କଇଲା, “ଏ ଦୁନିଆଇ ଆରି ତରେକ୍‌ ଆଇବା ଜାକ ସେ ବଁଚି କରି ରଅ ବଲି ମୁଇ ମନ୍‌ କଲିନି ବଇଲେ, ଏଟାର୍‌ପାଇ ତୁଇ କାଇକେ ଚିନ୍ତା କଲୁସ୍‌ନି ? ତୁଇ ମର୍‌ ସଙ୍ଗ୍‍ ଆଉ ।” ");
INSERT INTO dso_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ତେବେ ଜିସୁ ଜନ୍‌ ସିସ୍‌କେ ଆଲାଦ୍‌ କର୍‌ତେ ରଇଲା, ସେ ନ ମରେ ବଲି କଇରଇଲା ବିସଇ ଗୁଲାଇ ବାଟର୍‌ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ବାଇମନର୍‌ତେଇ କେଟ୍‌ଲା । ମାତର୍‌ ସେ ନ ମରେ ବଲି ଜିସୁ କଇ ନ ରଇଲା । ମୁଇ ଏ ଦୁନିଆଇ ଆରି ତରେକ୍‌ ଆଇବା ଜାକ ସେ ବଁଚିକରି ରଅ ବଲି ମୁଇ ଜଦି ମନ୍‌ କଲିନି ବଇଲେ, ଏଟାର୍‌ପାଇ ତୁଇ କାଇକେ ଚିନ୍ତା କଲୁସ୍‌ନି ? ବଲି କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ସେ ସିସ୍‌ ଏ ସବୁ ବିସଇ କଇଲାଆଚେ, ଏ ସବୁଜାକ ସେ ଲେକି ମିସା ଆଚେ ଆରି ସେଟା ଆମେ ଜାନୁ । ସେ ଜାଇଟା କଇଲା ଆଚେ ସେଟା ସବୁ ସତ୍‌ସେ । ");
INSERT INTO dso_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ଜିସୁ କରିରଇବା କାମ୍‌ମନ୍‍ ଆରି କେତେକ୍‌ କେତେକ୍‌ ଆଚେ, ମାତର୍‌ ମର୍‌ ବିଚାର୍‌ ଇସାବେ ସେ ସବୁଜାକ ଜଦି ଗଟେକ୍‌ ଲକ୍‌ ଲେକ୍‌ଲେ, ଜେତ୍‌କି ବଇ ଲେକା ଅଇସି, ସେଟାମନ୍‌ ସଙ୍ଗଇବାକେ ଟାନ୍‌ ନ ଅଏ ।");
INSERT INTO dso_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ସାର୍‌ଦାର୍‌ ତିଅପିଲ୍‌, ମର୍‌ ପର୍‌ତୁମ୍‌ ଲେକିରଇବା ଲୁକ୍‌ବଇଟାନେ ଆରାମେଅନି, ପର୍‌ମେସର୍‌ ତାକେ ସର୍‌ଗେ ନେବା ଦିନ୍‌ ଜାକ, ଜିସୁ କରିରଇବା ଆରି ସିକାଇରଇବା ସବୁ ବିସଇ ଲେକିରଇଲି । ");
INSERT INTO dso_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ତାର୍‌ ଆଗ୍‌ତୁ ସୁକଲ୍‌ଆତ୍‌ମାର୍‌ ବପୁସଙ୍ଗ୍‍ ସେ ବାଚିରଇବା ପେରିତ୍‌ମନ୍‌କେ କେତେଟା ଆଦେସ୍‌ ଦେଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ସେ ଦୁକ୍‌ କସ୍‌ଟ ଅଇଲାପଚେ, ସେମନ୍‌କେ ନିଜେ ବେସି ତର୍‌ ଦେକାଇଅଇଲା । ଚାଲିସ୍‌ ଦିନ୍‌ଜାକ ବିନ୍‌ ବିନ୍‌ ବେଲାଇ ଦେକାଇଅଇଲା । ମଲାତେଇଅନି ଉଟ୍‌ଲାଟା ସତ୍‌ସଙ୍ଗ୍‍ ଜାନାଇଲା । ସେମନ୍‌ ତାକେ ଦେକ୍‌ଲାଇ, ଆରି ସେ ସେମନର୍‌ସଙ୍ଗ୍‍ ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ବିସଇନେଇ କାତା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ତରେକ୍‌ ସେମନର୍‌ସଙ୍ଗ୍‍ ମିସିକରି କାଇବା ବେଲେ, ସେ ଏ ଆଦେସ୍‌ ଦେଲା, “ଜିରୁସାଲମ୍‌ ଚାଡାନାଇ । ମାତର୍‌ ଜନ୍‌ଟା ମର୍‌ ସରଗର୍‌ ବାବା, ଇନାମେ ଦେବିବଲି କଇଆଚେ, ସେଟା ନ ମିଲ୍‌ବା ଜାକ ଜାଗିରୁଆ । ");
INSERT INTO dso_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","କାଇକେବଇଲେ ଜଅନ୍‌ ପାନିତେଇ ଡୁବନ୍‌ ଦେଇରଇଲା, ମାତର୍‌ କେତେ ଦିନ୍‌ ବିତ୍‌ରେ ପର୍‌ମେସର୍‌ ତମ୍‌କେ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ଡୁବନ୍‌ ଦେଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ଦିନେକ୍‌ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ଗଟେକ୍‌ତେଇ ରୁଣ୍ଡିରଇଲା ବେଲେ ଜିସୁକେ ପାଚାର୍‌ଲାଇ, “ମାପ୍‌ରୁ, ତମେ କାଇ ଏବେ ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌କେ ତାକର୍‌ ରାଇଜ୍‌ ଆରିତରେକ୍‌ ବାଉଡାଇ ଦେଇସୁ କି ?” ");
INSERT INTO dso_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ଜିସୁ ସେମନ୍‌କେ କଇଲା, “ମର୍‌ ବାବା ତାର୍‌ ନିଜର୍‌ ଅଦିକାର୍‌ସଙ୍ଗ୍‍ ବେଲାଗଡି ଟିକ୍‌କରି ସଙ୍ଗଇ ଆଚେ । ଏ ସବୁ କେବେ ଗଟ୍‌ସି, ସେଟା ତମର୍‌ ଜାନ୍‌ବା ଦର୍‌କାର୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ମାତର୍‌ ସୁକଲ୍‌ ଆତ୍‌ମା ତମର୍‌ ଉପ୍‌ରେ ଉତର୍‌ଲେ, ତମେ ପୁରାପୁରୁନ୍‌ ବପୁ ଅଇସା ଆରି ଜିରୁସାଲମ୍‌, ଜିଉଦାର୍‌ ସବୁଟାନେ, ସମିରଣ୍‌ ଆରି ଜଗତର୍‌ ସାରାସାରି ଜାକ ମର୍‌ ନାଉଁ ଦାରି ସାକି ଅଇସା ।” ");
INSERT INTO dso_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ଏତ୍‌କି କାତା ସେମନ୍‌କେ କଇସାରାଇଲା ପଚେ, ସେମନ୍‌ ଜିସୁକେ ସର୍‌ଗେ ନେବାଟା ଦେକ୍‌ଲାଇ । ଗଟେକ୍‌ ଚେଲ୍‌କା ବାଦଲ୍‌ ଆସି ଡାବିଅଇଲାକେ ସେ ବାନା ଅଇଗାଲା । ଆରି ସେମନ୍‌ ତାକେ ଦେକି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ସେ ସର୍‌ଗେ ଗାଲାପଚେ ମିସା ସେମନ୍‌ ଆଁକି ମରାଇକରି ଉପ୍‌ରେ ସେ ଦେକ୍‌ତେ ରଇଲାଇ । ସେଡ୍‌କିବେଲେ ଏଦେ ଦେକା ! ଦବ୍‌ ପଚିଆ ପିନ୍ଦ୍‌ଲା ଦୁଇ ଲକ୍‌, ସେମନର୍‌ ମୁଆଟେ ଆସି ଟିଆଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ଆରି କଇଲାଇ “ଏ ଗାଲିଲିର୍‌ ଲକ୍‌ମନ୍‌, ତମେ କାଇକେ ଇତି ଟିଆଅଇ ଆକାସେ ଦେକ୍‌ଲାସ୍‌ନି ? ଏ ଜିସୁକେ ପର୍‌ମେସର୍‌ ତମର୍‌ଟାନେଅନି ସର୍‌ଗେ ନେଲା ଆଚେ । ସେ ସର୍‌ଗେ ଜେନ୍ତି ଜାଇରଇଲା, ସେନ୍ତାରିସେ ଦର୍‌ତନିତେଇ ଆଇବାଟା ଦେକ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ତାର୍‌ପଚେ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ଜିତ୍‌ ପର୍‌ବତେଅନି ଜିରୁସାଲାମ୍‌ ବାଉଡି ଗାଲାଇ । ସେ ପର୍‌ବତ୍‌, ଜିରୁସାଲମ୍‌ ନଅରେଅନି ଗଟେକ୍‌ କିଲମିଟର୍‌ ଦୁର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ଜିରୁସାଲେମ୍‌ ନଅରେ ଜାଇକରି ସେମନ୍‌ ରଇବା ବାକ୍‌ରାଇ ପୁର୍‌ଲାଇ । ପିତର୍‌, ଜଅନ୍‌, ଜାକୁବ୍‌ ଆରି ତାର୍‌ ବାଇ ଆନ୍ଦ୍‌ରିୟ, ପିଲିପ୍‌, ତମା, ବାର୍‌ତଲମି, ମାତିଉ, ଆଲ୍‌ପିର୍‌ ପିଲା ଜାକୁବ୍‌, ଦେସ୍‌ ଆଲାଦ୍‌କର୍‌ବା ସିମନ୍‌ ଆରି ଜାକୁବର୍‌ ପିଲା ଜିଉଦା, ଏମନ୍‌ ରଇଲା ତେଇର୍‌ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ସେମନ୍‌ ତର୍‌କେତର୍‌ ଗଟେକ୍‌ ଦଲ୍‌ ଇସାବେ ପାର୍‌ତନା କର୍‌ବାକେ ରୁଣ୍ଡ୍‍ତେ ରଇଲାଇ । ଆରି ସେମନର୍‌ସଙ୍ଗ୍‍ ଜିସୁର୍‌ ଆୟା ମରିୟମ୍‌, ବିନ୍‌ ମାଇଜିମନ୍‌ ଆରି ଜିସୁର୍‌ ବାଇମନ୍‌ ମିସା ମିସ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","କେତେ ଦିନ୍‌ ଗାଲାପଚେ ପାକାପାକି ସଏ କଡେ ଲକ୍‌ ବିସ୍‌ବାସି ବାଇମନ୍‌ ରଇଲା ଗଟେକ୍‌ ସବାଇ, ପିତର୍‌ ଲକ୍‌ମନର୍‌ ମୁଆଟେ ଉଟି ଟିଆଅଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ଏ ମର୍‌ ବାଇବଇନିମନ୍‌, ଜନ୍‌ ଇସ୍‌କାରିୟତ୍‌ ଜିଉଦା ଜିସୁକେ ଦାରାଇଦେବାକେ ସତ୍‌ରୁମନ୍‌କେ ବାଟ୍‌ ଦେକାଇ ଆନିରଇଲା, ତାର୍‌ ବିସଇ, ଦାଉଦ୍‌ ସୁକଲ୍‌ଆତ୍‌ମାଇ ପୁରୁନ୍‌ଅଇ ବବିସତ୍‌କାତା ସୁନାଇ ରଇଲା । ଦରମ୍‌ ସାସ୍‌ତରର୍‌ କାତା ସିଦ୍‌ ଅଇବାକେ ଏଟା ଗଟ୍‌ବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ଏଲେମିସା ସେ ଆମର୍‌ ଦଲର୍‌ ଲକ୍‌ ରଇଲା । ଆରି ଆମର୍‌ ସଙ୍ଗ୍‍ କାମ୍‌ କର୍‌ବାକେ ବାଚାଇଅଇ ରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ଜିଉଦା କରିରଇବା କରାପ୍‌ କାମେଅନି ମିଲାଇଲା ଡାବୁକେ ଗଟେକ୍‌ ଜମି ଗେନାଅଇରଇଲା । ଆରି ସେ ଜମିତେଇ, ଉମ୍‌ତାଡିଅଇ ଅଦ୍‌ରି ମଲା । ତାର୍‌ ପେଟ୍‌ ଚିରିଅଇ ଆଁତି ବାରଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଜିରୁସାଲମ୍‌ ନଅରେ ବାସାଅଇରଇବା ସବୁ ଲକ୍‌ମନ୍‌ ଏ ସବୁ ବିସଇ ସୁନ୍‌ଲାଇ । ସେମନର୍‌ ବାସାଇ ସେ ଜମିର୍‌ ନାଉଁ ଆକେଲ୍‌ଦାମା ତାର୍‌ ଅରତ୍‌ ଅଇଲାନି ବନିର୍‌ ପଦା ବଲି ନାଉଁ ଦେଲାଇ ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ଗିତ୍‌ସଙ୍ଗିତା ବଇଟାନେ ଏ ବିସଇ ଲେକା ଅଇଲା ଆଚେ, “ତାର୍‌ ଗର୍‌ ଚୁଚା ଅଇଜାଅ, ତେଇ ବାସା ଅଇବାକେ କେ ମିସା ନ ରଅତ୍‌ ।” ଆରି ମିସା ଲେକା ଅଇଲା ଆଚେ, “ତାର୍‌ ଜାଗାଇ ସେବା କର୍‌ବାକେ ଆରି ଗଟେକ୍‌ ଲକ୍‌ ମିସ ।” ");
INSERT INTO dso_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ସେଟାର୍‌ ପାଇ, ଜିସୁମାପ୍‌ରୁ ଆମର୍‌ ସଙ୍ଗ୍‍ ଗାଲାବେଲେ ଜେ ଆମର୍‌ ଦଲେ ସବୁବେଲେ ରଇଲା, ସେନ୍ତାରି ଗଟେକ୍‌ ଲକ୍‌କେ ବାଚ୍‌ବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ଜନ୍‌ ଲକ୍‌କେ ଆମେ ବାଚ୍‌ବୁ, ପର୍‌ମେସର୍‌ ଜିସୁକେ ଜେନ୍ତି ଜିବନ୍‌ କରି ଉଟାଇଲା, ସେ ବିସଇ ଆମର୍‌ସଙ୍ଗ୍‍ ସେ ସାକି ଅଇବାର୍‌ଆଚେ । ଜଅନ୍‌ ଜିସୁକେ ଡୁବନ୍‌ଦେଲା ବେଲେଅନି, ପର୍‌ମେସର୍‌ ଆମର୍‌ଟାନେଅନି ତାକେ ସର୍‌ଗେ ନେବା ଜାକ, ସେ ଲକ୍‌ ଆମର୍‌ ଦଲେ ରଇବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ସେମନ୍‌ ଦୁଇ ଲକର୍‌ ନାଉଁ ଦେଲାଇ । ଜସେପ୍‌ ଜେକି ବର୍‌ସବା ଆରି ଜୁସ୍‌ତକ୍‌ ବଲି ମିସା କଇବାଇ ଆରି ମତିୟ । ");
INSERT INTO dso_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ଆରି ସେମନ୍‌ ପାର୍‌ତନା କଲାଇ, “ମାପ୍‌ରୁ ତମେତା ସବୁ ଲକର୍‌ ମନର୍‌ କାତା ଜାନାସ୍‌ । ଜିଉଦା ଜନ୍‌ ଜାଗାଇ ରଇବାର୍‌ରଇଲା, ଟିକ୍‌ ତେଇ ଉଟିଗାଲା । ପଚେ ତାର୍‌ ଜାଗାଇ ତମେ ବାଚିରଇବା ଲକ୍‌, ଏ ଦୁଇ ଲକର୍‌ ବିତ୍‌ରେ ଅନି କେ ଅଇରଇସି ? ");
INSERT INTO dso_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଜେ ପେରିତ୍‌ ସିସ୍‌କାମ୍‌ କରିପାର୍‌ସି, ତାକେ ଆମ୍‌କେ ଜାନାଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ତାର୍‌ପଚେ ଦୁଇ ଲକର୍‌ଟାନେଅନି ଗଟେକ୍‌ ଲକ୍‌କେ ବାଚ୍‌ବାକେ କେଡ୍‌ପୁଟାଇଲାଇ । କେଡ୍‌ପୁଟାଇଲାକେ ମତିୟସର୍‌ ନାଉଁ ପୁଟ୍‌ଲା । ସେନ୍ତାରି, ଏଗାର୍‌ଟା ସିସ୍‌ମନର୍‌ ଦଲେ ସେ ମିସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ଜନ୍‌ ଦିନେ ସେମନ୍‌ ପେନ୍‌ଟିକସ୍‌ଟ୍‌ ପରବ୍‌ ମାନ୍‌ତେରଇଲାଇ, ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ସବୁ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ଜାଗାଇ ରୁଣ୍ଡିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଅଟାତ୍‌ ଆକାସେଅନି ବେସି ପବନ୍‌ ଆଇଲାପାରା ଗଟେକ୍‌ ସବଦ୍‌ ଅଇଲା । ଆରି ଜନ୍‌ ଗରେ ସେମନ୍‌ ବସି ରଇଲାଇ, ସେଟା ସେ ସବଦେ ପୁରୁନ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ତାର୍‌ପଚେ ସେମନ୍‌ ଦେକ୍‌ଲାଇ, କେତେଟା ଜଇଜିବ୍‌ ଉଦ୍‌ଲିକରି ବିଚି ଅଇଲା । ଆରି ତେଇ ରଇଲା ସବୁ ବିସ୍‌ବାସିମନ୍‌କେ ଚିଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ସେମନ୍‌ ସବୁଲକ୍‌ ସୁକଲ୍‌ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇଲାଇ ଆରି ଆତ୍‌ମା ଦେଲା ବପୁ ଇସାବେ ନାଜାନ୍‌ଲା ବାସାମନର୍‌ ସଙ୍ଗ୍‍ କାତା ଅଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ଜଗତର୍‌ ବିନ୍‌ ବିନ୍‌ ଦେସେଅନି ଆସିରଇଲା ଜିଉଦି ଲକ୍‌ମନ୍‌ ସେଡ୍‌କିବେଲେ ଜିରୁସାଲମେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ଏନ୍ତାରି ଅଇଲାଟା ଦେକି ସେମନ୍‌ ସାର୍‌ଦା ଅଇଗାଲାଇ । କାଇକେବଇଲେ ସେ ବିସ୍‌ବାସିମନ୍‌ ତାକର୍‌ ତାକର୍‌ ବାସାଇ କାତା ଅଇବାଟା ସେମନ୍‌ ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ସେମନର୍‌ ବୁଦିଗୁପିଗାଲା ଆରି କାବା ଅଇଜାଇ ପାଚାର୍‌ଲାଇ, “ଏନ୍ତାରି ବାସାଇ କାତା ଅଇବା ଲକ୍‌ମନ୍‌ ଗାଲିଲିଅନି ନଅତ୍‌ କି ? ");
INSERT INTO dso_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ସେନ୍ତିଆଲେ ଆମେ କେନ୍ତି ସେମନ୍‌କେ ଆମର୍‌ ନିଜର୍‌ ନିଜର୍‌ ଜନମ୍‌ ଜାଗାର୍‌ ବାସାଇ କାତା ଅଇବାଟା ସୁନିଆଚୁ ? ");
INSERT INTO dso_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ଆମେ ପାର୍‌ତିୟ, ମାଦିୟ, ଏଲାମିୟ ଆରି ମେସପଟାମିୟ, ଜିଉଦା ଦେସ୍‌ ଆରି କାପ୍‍ପାଦକିଆ, ପନ୍ତ୍‌ ଆରି ଆସିଆ, ");
INSERT INTO dso_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ପିରିଜିଆ ଆରି ପପୁଲିଆ, ମିସର୍‌ ଆରି କୁରିଣି ଲଗେ ରଇଲା ଲିବିଆ ଜାଗାର୍‌ ଲକ୍‌ । ଆମର୍‌ ବିତ୍‌ରେ ରମ୍‌ରାଇଜେଅନି ଆସିରଇବା, ଜନମେ ଅନି ଜିଉଦି ଅଇଲା ଲକ୍‌ ଆଚୁ ଆରି ପଚେ ଜିଉଦି ଦରମ୍‌ ନେଲା ଲକ୍‌ ମିସା ଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ଆମର୍‌ ବିତ୍‌ରେଅନି କେତେଲକ୍‌ କିର୍‌ତିୟଅନି ଆରି ଆରବିୟଅନି ଆଇଲୁ ଆଚୁ । ଏନ୍ତି ଆମେ ସବୁ ବିନ୍‌ ବିନ୍‌ ଜାଗାଇଅନି ଆଇଲୁ ଆଚୁ । ଏନ୍ତି ବଇଲେ ମିସା ପର୍‌ମେସର୍‌ କଲା ବଡ୍‌ ବଡ୍‌ କାବାଅଇଜିବା କାମ୍‍ ଏ ଲକ୍‌ମନ୍‌ ଆମର୍‌ ନିଜର୍‌ ନିଜର୍‌ ବାସାଇ କାତାଅଇବାଟା ସୁନ୍‌ଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ଏନ୍ତି ବଲି ସେମନ୍‌ ବେସି କାବାଅଇଗାଲାଇ । ଆରି ସେମନର୍‌ ବୁଦି ଆଜି ଗାଲା । ଆରି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ “ଏଟା କେନ୍ତାର୍‌ ଅଇଲା ତେବେ ?” ବଲି ସବୁ ବେଲେ ପାଚାର୍‌ଉଚାର୍‌ ଅଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ମାତର୍‌ ବିନ୍‌ ଲକ୍‌ମନ୍‌ ବିସ୍‌ବାସିମନ୍‌କେ କିଜାଇକରି କଇଲାଇ, “ସେମନ୍‌ ମାତିଆଚତ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ପିତର୍‌ ତାର୍‌ ସଙ୍ଗ୍‍ ରଇଲା ଏଗାର୍‌ଟା ପେରିତ୍‌ ମନର୍‌ ସଙ୍ଗ୍‍ ଟିଆଅଇ ଆଉଲି ଅଇ କଇଲା, “ଏ ମର୍‌ ପାରା ଜିଉଦି ଲକ୍‌ମନ୍‌ ଆରି ଜିରୁସାଲମେ ରଇବା ସବୁ ବାଇମନ୍‌, ମର୍‌ କାତା ମନ୍‌ଦେଇ ନିମାନ୍‌ ସୁନା । ଏଟା କାଇଟା ଅଇଲାନି ବଲି ମୁଇ ତମ୍‌କେ ବୁଜାଇ କଇବି । ");
INSERT INTO dso_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ଏବେ ସାକ୍‌ଲିଆ ନଅଟା ବେଲା ଅଇଲା ଆଚେ । ତମେ ବାବ୍‌ଲାପାରା ଏ ଲକ୍‌ମନ୍‌ ମାତତ୍‍ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ଏଟା ଜଏଲ୍‌ ନାଉଁର୍‌ ବବିସତ୍‌ବକ୍‌ତା କଇଲା କାତା ପାରା ଗଟ୍‍ନା ଗଟି ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ସେଟା କାଇଟା ବଇଲେ ପର୍‌ମେସର୍‌ କଇଲାନି, “ସାରାସାରି ଦିନେ ମୁଇ ଏ ସବୁ ବିସଇ କର୍‌ବି । ମର୍‌ ଆତ୍‌ମା ଜବର୍‌ ଅଇତେ ସବୁବାଟର୍‌ ଲକ୍‌କେ ଦେବି । ତମର୍‌ ପିଲାଜିଲା ମୁଇ କଇବା କାତା କଇବାଇ । ତମର୍‌ ଦାଙ୍ଗ୍‌ଡାପିଲାମନ୍‌କେ ମୁଇ ଦର୍‌ସନ୍‌ ଦେକାଇବି । ଆରି ଡକ୍‌ରା ଲକ୍‌ମନ୍‌ ମର୍‌ ବିସଇନେଇ ସପନ୍‌ ଦେକ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ସେ ଦିନ୍‌ମନ୍‌କେ ମର୍‌ ଆତ୍‌ମା ଜବର୍‌ ଅଇତେ ମର୍‌ ଦାଙ୍ଗ୍‌ଡା ଅଇରଇବା ମାଇଜିମୁନୁସ୍‌ମନ୍‌କେ ଆଜାଡି ଦେବି । ସେମନ୍‌ ମୁଇ କଇବା କାତା କଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ଆକାସେ କାବା ଅଇଜିବା କାମ୍‌ କର୍‌ବି । ଦର୍‌ତନି ତେଇ ମିସା କାବାଅଇଜିବା ଚିନ୍‌ମନ୍‌ କର୍‌ବି । ଲକ୍‌ମନ୍‌ ବନି, ଜଇ ଆରି କାଲିଆ ଦୁଆଁ ଦେକ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ବେଲ୍‌କେ ଆନ୍ଦାର୍‌ ଡିସ୍‌ଲା ପାରା କରାଇବି, ଜନ୍‌, ବନି ପାରା ଡିସ୍‌ବାକେ କରାଇବି । ମୁଇ ବାଉଡି ଆଇବା ସେ ବଡ୍‌ ଉଜଲର୍‌ ଦିନ୍‌ ଆଗ୍‌ତୁ, ଏଟାସବୁ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ଜେତ୍‌କି ଲକ୍‌ ମର୍‌ ନାଉଁ ଦାରି ଡାକ୍‌ବାଇ, ସେମନ୍‌କେ ମୁଇ ରକିଆ କର୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ପିତର୍‌ କଇଲା, “ଏ ଇସ୍‌ରାଏଲ୍‌ ଦେସର୍‌ ଲକ୍‌ମନ୍‌ ତମେ ମୁଇ କଇବା କାତା ସୁନା । ପରମେସର୍‌ସେ ବାଚି ପାଟାଇଲା ଲକ୍‌, ନାଜରିତ୍‌ ଗଡର୍‌ ଜିସୁ ବଲିକରି ସେ ତମର୍‌ ଲଗେ ରଇଲା ବେଲେ, ଦେକାଇଦେଲା । ସେଟା କେନ୍ତାର୍‌ ବଇଲେ, ପରମେସର୍‌ ତାର୍‌ତେଇଅନି କାବା ଅଇଜିବା କାମ୍‌ କଲାଆଚେ । ଏଟା ସତ୍‌ ବଲି ତମେ ଜାନିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ତାର୍‌ ଆଗ୍‌ତୁର୍‌ ଜଜ୍‌ନା ଇସାବେ ସେ କାତା ଦେଇସାରାଇରଇଲା କି, ଜିସୁ ତମର୍‌ ଆତେ ସର୍‌ପାଇ ଅଇସି । ତାର୍‌ପଚେ ତାର୍‌ ନିୟମ୍‌ ନ ମାନ୍‌ବା ଲକ୍‌ମନ୍‌ ତାକେ କୁର୍‌ସେ ଚଗାଇ ମରାଅତ୍‌ ବଲି ତମେ ତାକେ ଏନ୍ତି କଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ମାତର୍‌ ପରମେସର୍‌ ଜିସୁକେ ମଲାଟାନେଅନି ଆରି ତରେକ୍‌ ଉଟାଇଲା । ମରନର୍‌ ବପୁତେଇଅନି ତାକେ ମୁକ୍‌ଲାଇଲା । କାଇକେବଇଲେ କେ ମିସା ତାକେ ମରାଇକରି ସେ ଜାଗାଇ ସଙ୍ଗଇ ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଏ ବିସଇ ଦାଉଦ୍‌ ରାଜା ଏନ୍ତି କଇ ଆଚେ । ସେଟା କାଇଟା ବଇଲେ, “ପରମେସର୍‌ ସବୁ ବେଲା ମର୍‌ ମୁଆଟେ ରଇବାଟା ଦେକ୍‌ଲି । ସେ ମର୍‌ ସଙ୍ଗ୍‍ ଆଚେ । ସେଟାର୍‌ପାଇ ମକେ କେ ମିସା କଚପଚ କରିନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ସେଟାର୍‌ ପାଇ ମୁଇ ସାର୍‌ଦାସଙ୍ଗ୍‍ ଆଚି । ଆରି ସାର୍‌ଦାର୍‌ କାତା କଇବି । ମର୍‌ ଏ ମର୍‌ବା ଗାଗଡ୍‌ ରଇଲେ ମିସା ମୁଇ ସବୁବେଲେ ତମର୍‌ ତେଇ ଆସା କର୍‌ବି । ");
INSERT INTO dso_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","କାଇକେ ବଇଲେ ତୁଇ ମକେ ମଲାଲକ୍‌ମନର୍‌ ଜାଗାଇ ଚାଡି ନ ଦିଆସ୍‌ । ତମର୍‌ ସୁକଲ୍‌ ଦାଙ୍ଗ୍‌ଡାକେ ସମାଦିଟାନେ କୁଇବାକେ ନ ଚାଡାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ତମେ ମକେ ଜିବନର୍‌ ବାଟ୍‌ ଦେକାଇ ଆଚାସ୍‌ । ତମେ ମର୍‌ ସଙ୍ଗ୍‍ ଆଚାସ୍‌, ସେଟାର୍‌ପାଇ ମୁଇ ସାର୍‌ଦା ସଙ୍ଗ୍‍ ରଇବି ।” ");
INSERT INTO dso_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ଆରି ପିତର୍‌ କଇଲା, “ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇବଇନିମନ୍‌, ଆମର୍‌ ଆନିଦାଦିବେଲର୍‌ ଦାଉଦ୍‌ ରାଜାର୍‌ ବିସଇ ଡାଟ୍‌ସଙ୍ଗ୍‍ କଇବାକେ ମର୍‌ ଅଦିକାର୍‌ ଆଚେ । ସେ ମଲାକେ ତାକେ ତପି ଦେଲାଇ । ସେ ତପ୍‌ଲା ଜାଗା ଏବେ ଜାକ ଇତି ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ସେ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ରଇଲା ଆରି ପର୍‌ମେସର୍‌ ସପତ୍‌କରି କଇଲା ବିସଇ ଜାନିରଇଲା । ପର୍‌ମେସର୍‌ ତାକେ କାତା ଦେଇରଇଲା ଜେ, ତାର୍‌ ଗଟେକ୍‌ ନାତିତିତି ଦିନେକ୍‌ ତାର୍‌ପାରା ସାସନ୍‌ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ଏ ବିସଇ ଆଗେ ସେ ଜାନି ରଇଲାର୍‌ପାଇ ପର୍‌ମେସର୍‌ ମସିଅକେ ମଲାତେଇଅନି ଆରିତରେକ୍‌ ଜିବନ୍‌ କରାଇସି ବଲି ସେ କଇପାର୍‌ଲା ।” “ପର୍‌ମେସର୍‌ ତାକେ ମରିକରିସେ ତେଇ ରଇବାକେ ଚାଡିଦେଏ ନାଇ । ଆରି ତାର୍‌ ଗାଗଡ୍‌ ସମାଦି ତେଇ କୁଇ ଜିବାକେ ଚାଡେନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ଏବେ ଏ ଜିସୁକେ ପରମେସର୍‌ ଜିବନ୍‌ ଦେଇ ଉଟାଇଆଚେ । ଆମେ ସବୁ ସେ ଗଟ୍‍ନାର୍‌ ସାକି । ");
INSERT INTO dso_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ପରମେସର୍‌ ତାକେ ତାର୍‌ ଉଜାବାଟେ ବସ୍‌ବାକେ ଉଟାଇଆଚେ । ଆରି ସେ କାତା ଦେଲା ଇସାବେ ତାର୍‌ଟାନେଅନି ସୁକଲ୍‌ଆତ୍‌ମା ପାଇଲାଆଚେ । ତମେ ଏବେ ଜନ୍‌ଟା ଦେକ୍‌ଲାସ୍‌ନି ଆରି ସୁନ୍‌ଲାସ୍‌ନି, ସେଟା ଅଇଲାନି ତାର୍‌ ଦାନ୍‌କରି ରଇବାଟା । ଜନ୍‌ଟା କି ସେ ଆମ୍‌କେ ଜବର୍‌ ଅଇତେ ଆଜାଡି ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ସର୍‌ଗେ ଗାଲା ଲକ୍‌ ଦାଉଦ୍‌ ନଏଁ । ମାତର୍‌ ସେ କଇଲା, “ପର୍‌ମେସର୍‌ ମର୍‌ ମାପ୍‌ରୁକେ କଇଲା ତମର୍‌ ସବୁ ସତ୍‌ରୁମନ୍‌କେ ଆରାଇବା ଜାକ ମର୍‌ ଉଜାବାଟେ ବସ୍‌ ଆରି ସାସନ୍‌ କର୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ଆରି ତର୍‌ ସତ୍‌ରୁମନ୍‌କେ ତର୍‌ ପାଦ୍‌ତଲେ ନ ଆନ୍‌ବା ଜାକ ମର୍‌ ଉଜାବାଟେ ବସି ର । ");
INSERT INTO dso_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ପିତର୍‌ ଆରି କଇଲା “ଏ ଇସ୍‌ରାଏଲର୍‌ ସବୁ ଲକ୍‌ମନ୍‌, ତମେ ଜନ୍‌ ଜିସୁକେ କୁର୍‌ସେ କୁଟିମାରି ମରାଇରଇଲାସ୍‌, ପର୍‌ମେସର୍‌ ତାକେ ମାପ୍‌ରୁ ଆରି ମସିଅ କଲାଆଚେ ବଲି ଡାଟ୍‌ସଙ୍ଗ୍‍ ଜାନ୍‌ବାର୍‌ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ଏ କାତା ପିତର୍‌ଟାନେଅନି ସୁନ୍‌ଲା ସବୁ ଲକ୍‌ମନ୍‌ ତାକର୍‌ ନିଜର୍‌ ବୁଲ୍‌ ଏତାଇକରି ମନ୍‌ ବିତ୍‌ରେ କିଲ୍‌ବିଲ୍‌ ଅଇଗାଲାଇ । ସେମନ୍‌ ପିତର୍‌କେ ଆରି ପେରିତ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲାଇ, “ଏ ବାଇମନ୍‌ ଏନ୍ତାର୍‌ ବଲି କଇଲେ ଆମେ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ପିତର୍‌ ସେମନ୍‌କେ କଇଲା, “ତମେ ଗଟେକ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ପାପେଅନି ବାଉଡିକରି ଜିସୁ କିରିସ୍‌ଟର୍‌ ନାଉଁ ଦାରି ଡୁବନ୍‌ ନେବାର୍‌ ଆଚେ, ଜେନ୍ତାରି କି ତମର୍‌ ପାପ୍‌ ସବୁ କେମା ଅଇସି ଆରି ପରମେସର୍‌ ତମ୍‌କେ ସୁକଲ୍‌ ଆତ୍‌ମା ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ଏ ସପତ୍‌ ତମର୍‌ପାଇ ଆରି ତମର୍‌ ପିଲାମନର୍‌ପାଇ । ଆରି ଇତିଅନି ଦୁରିକେ ରଇବା ସବୁର୍‌ପାଇ । ଜନ୍‌ ସବୁଲକ୍‌କେ ସେ, ତାର୍‌ ଲଗେ ଡାକ୍‌ଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ଆରି ପିତର୍‌ ସେମନ୍‌କେ ଜାଗ୍‌ରତ୍‌ କରାଇବାକେ ବେସି ବିସଇ କଇଲା ଆରି ସେମନ୍‌କେ ବାବୁଜିଆ କଲା । ବିସ୍‌ବାସ୍‌ ନ କର୍‌ବା ଜିଉଦି ବାଇମନ୍‌କେ ଆଇତେରଇବା ବଡ୍‌ ଡଣ୍ଡେଅନି ନିଜ୍‌କେ ରକିଆ କରା। ବଲି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ତେଇ ପିତରର୍‌ କାତା ସୁନି ବେସି ଲକ୍‌ ବିସ୍‌ବାସ୍‌ କଲାଇ । ଆରି ସିସ୍‌ମନ୍‌ ସେମନ୍‌କେ ଡୁବନ୍‌ ଦେଲାଇ । ସେ ଦିନେ ତିନ୍‌ଅଜାର୍‌ ଲକ୍‌ମନ୍‌ ତାକର୍‌ ଦଲେ ମିସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ସେମନ୍‌ ପେରିତ୍‌ମନ୍‌ ସିକାଇଲା ବିସଇ ମାନ୍‌ଲାଇ । ମିସିବିଡି ରଇବାକେ, ମିସିକରି କାଇବାକେ, ଆରି ପାର୍‌ତନା କର୍‌ବାକେ । ");
INSERT INTO dso_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ଆରି ଲକ୍‌ମନ୍‌ ଡରିଜାଇତେରଇଲାଇ । ପର୍‌ମେସର୍‌ ପେରିତ୍‌ମନର୍‌ ତେଇଅନି ବେସି କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କର୍‌ତେ ରଇଲା । ସବୁ ଲକ୍‌ମନ୍‌ ପରମେସର୍‌କେ ନାମ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲା ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ଗରର୍‌ ଲକ୍‌ପାରାଅଇ ରଇତେ ରଇଲାଇ । ଆରି ତାକର୍‌ତେଇ କାଇକାଇଟା ରଇଲା, ସେଟା ସେମନ୍‌ ବାଟା କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ତାକର୍‌ ବିତ୍‌ରେ କେତେଲକ୍‌ ଜମି ଆରି ନିଜର୍‌ପାଇ ରଇବାଟା ବିକିକରି, ସେ ଡାବୁ ଦର୍‌କାର୍‌ ଅଇଲା ଲକ୍‌ମନ୍‌କେ ଦେଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ସବୁଦିନ୍‌ ପାର୍‌ତନା କର୍‌ବା ମନ୍ଦିରେ ଗଟେକ୍‌ ଦଲ୍‌ଅଇ ମିସ୍‌ତେରଇଲାଇ । ଗରେ ଗରେ ମିସିବିଡି କାଇତେରଇଲାଇ । ସାର୍‌ଦାସଙ୍ଗ୍‍ ରଇକରି, ମନେ କାଇଟା ନ ବାବି ଦିଆନିଆ ଅଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ସେମନ୍‌ ପର୍‌ମେସର୍‌କେ ଡାକ୍‌ପୁଟା କର୍‌ତେରଇଲାଇ ଆରି ଜିରୁସାଲେମର୍‌ ସବୁଲକ୍‌ ସେମନ୍‌କେ ନିକ ବଲି ବାବ୍‌ତେରଇଲାଇ । ମାପ୍‌ରୁ ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ମୁକ୍‌ତି କର୍‌ତେରଇଲା, ଦିନ୍‌କେ ଦିନ୍‌ ସେମନର୍‌ ଦଲେ ମିସାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ଗଟେକ୍‌ ଦିନେ ପିତର୍‌ ଆରି ଜଅନ୍‌ ପାର୍‌ତନା କର୍‌ବାକେ ମନ୍ଦିରେ ଗାଲାଇ, ଜେଡେବେଲେ କି ପାର୍‌ତନା କର୍‌ବା ବେଲା ମୁଇଦାନିଆ ତିନ୍‌ ଗଁଟା ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ତେଇ ଗଟେକ୍‌ ଲକ୍‌ ରଇଲା । ସେ ଜନମେଅନି ଚଟା । ତାକେ ସବୁଦିନ୍‌ ଲକ୍‌ମନ୍‌ ବଇକରି ସୁନ୍ଦର୍‌ ବଲି କଇବା ମନ୍ଦିରର୍‌ ଡିଆଗଡି, ନିଆ ଆନା କର୍‌ତେରଇଲାଇ । ସେ ଜେନ୍ତିକି ମନ୍ଦିରେ ଆଇଲା ଲକ୍‌ମନ୍‌କେ ବିକ୍‌ ମାଙ୍ଗି ପାର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ପିତର୍‌ ଆରି ଜଅନ୍‌ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ପୁର୍‌ବାଟା ଦେକି ସେ ସେମନ୍‌କେ କାଇଟା ମିସା ଦିଆ, ବଲି ବିକ୍‌ମାଗ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ପିତର୍‌ ଆରି ଜଅନ୍‌ ତାକେ ନିମାନ୍‌କରି ତିରିଆଇ ଦେକ୍‌ଲାଇ ଆରି ପିତର୍‌ କଇଲା, “ଆମର୍‌ ବାଟେ ଦେକ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ସେ କାଇଟାଆଲେ ପାଇବା ଆସାଇ ସେମନର୍‌ ବାଟେ ମୁ ବୁଲାଇ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ମାତର୍‌ ପିତର୍‌ ତାକେ କଇଲା, “ମର୍‌ଲଗେ ସୁନା କି ରୁପା ନାଇ, ମକେ ଜାଇଟା ଆଚେ ସେଟା ତକେ ଦେଲିନି । ନାଜରିତର୍‌ ଜିସୁର୍‌ ନାଉଁଦାରି ମୁଇ ଆଦେସ୍‌ ଦେଲିନି, ଉଟ୍‌ ଆରି ଇଣ୍ଡ୍ !” ");
INSERT INTO dso_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ଏନ୍ତି କଇକରି ପିତର୍‌ ତାକେ ଉଜା ଆତ୍‌ ଦାରି ଉଟାଇଲା, ସେ ଦାପ୍‌ରେ ସେ ଲକର୍‌ ପାଦ୍‌ ଆରି ଗଡ୍‌ ସବୁ ଡାଟ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ସେ ଚିକାଲ୍‌ନା ଡେଗଇକରି ଉଟ୍‌ଲା ଆରି ଇଣ୍ଡ୍‌ବାର୍‌ ଦାର୍‌ଲା । ସେ ଇଣ୍ଡି ଇଣ୍ଡି ଡେଗଇ ଡେଗଇ ପର୍‌ମେସରର୍‌ ଡାକ୍‌ପୁଟା କରିକରି ତାକର୍‌ ସଙ୍ଗ୍‍ ମନ୍ଦିରେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ତେଇ ରଇବା ଲକ୍‌ମନ୍‌ ତାକେ ଇଣ୍ଡ୍‌ବାଟା ଆରି ପର୍‌ମେସର୍‌କେ ଡାକ୍‌ପୁଟା କର୍‌ବାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ମନ୍ଦିରର୍‌ ସୁନ୍ଦର୍‌ ନାଉଁର୍‌ ଡିଆଗଡି ବସି ରଇଲା ମାଙ୍ଗ୍‌ତିଆ ବଲି ଚିନ୍‌ଲାଇ । ଆରି ତାକେ ଜାଇଟା ଗଟି ରଇଲା ସବୁ ଜାନି କାବାଅଇଜାଇ କାନାବାନା ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ସେ ଲକ୍‌ ପିତର୍‌କେ ଆରି ଜଅନ୍‌କେ ନ ଚାଡ୍‌ତେରଇଲା । ସଲ୍‌ମନର୍‌ ପିଣ୍ଡାଇ ତାକର୍‌ ସଙ୍ଗ୍‌ ରଇବାଟା ଦେକି, ଲକ୍‌ମନ୍‌ କାବାଅଇଗାଲାଇ । ପଚେ ପାଲାଇ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପିତର୍‌ ସେମନ୍‌କେ ଦେକି କଇଲା, “ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌, ତମେ କାଇକେ କାବାଅଇଜାଇ ଆମର୍‌ ବାଟେ ଏନ୍ତାର୍‌ ଦେକ୍‌ଲାସ୍‌ନି ? କାଇଟା ବାବ୍‌ଲାସ୍‌ନି ? ଆମର୍‌ ନିଜର୍‌ ବପୁସଙ୍ଗ୍‍ କି ଦରମ୍‌ସଙ୍ଗ୍‍ ଏ ଲକ୍‌କେ ଇଣ୍ଡ୍‌ବା ବପୁ ଦେଲୁଆଚୁ ? ");
INSERT INTO dso_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଆମର୍‌ ଆନିଦାଦିମନର୍‌ ପର୍‌ମେସର୍‌ ଅବ୍‌ରାଆମର୍‌, ଇସାକର୍‌ ଆରି ଜାକୁବର୍‌ ପରମେସର୍‌ ତାର୍‌ ସେବାକାରିଆ ଜିସୁକେ ଡାକ୍‌ପୁଟା କଲାଆଚେ । ମାତର୍‌ ତମେ ତାକେ ସାସନ୍‌କାରିଆମନର୍‌ ଆତେ ସର୍‌ପିଦେଲାସ୍‌ । ଏନ୍ତି କି ପିଲାତ୍‌ ତାକେ ଚାଡିଦେବାକେ ମନ୍‌କରି ରଇଲେ ମିସା ତାର୍‌ ମୁଆଟେ ଚାଡ୍‌ନାଇ ବଲି କଇଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ସେ ଆକା ଗଟେକ୍‌ସେ ସୁକଲ୍‌ ଆରି ଦରମ୍‌ ଲକ୍‌ ରଇଲା । ମାତର୍‌ ତମେ ତାକେ ନାମାସ୍‌ ନାଇ ଆରି ତାର୍‌ ବାଦୁଲେ ଗଟେକ୍‌ ନର୍‌ମାରୁକେ ମୁକ୍‌ଲାଇବାକେ ପିଲାତ୍‌କେ ଗୁଆରି କଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ଜେ ଜିବନର୍‌ ବାଟ୍‌ ଦେକାଉ, ତାକେ ତମେ ମାର୍‌ଲାସ୍‌, ମାତର୍‌ ପର୍‌ମେସର୍‌ ତାକେ ମଲାଟାନେଅନି ଆରି ତରେକ୍‌ ଜିବନ୍‌ କରି ଉଟାଇଲା । ଆମେ ଅଇଲୁନି ତାର୍‌ ସାକି । ");
INSERT INTO dso_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ତାର୍‌ ନାଉଁର୍‌ ବପୁ ସଙ୍ଗ୍‍ ଏ ଚଟା ନିମାନ୍‌ ଅଇଲାଆଚେ । ଜନ୍‌ ଗଟ୍‍ନା ଏବେ ତମେ ନିଜେ ଦେକି ସତ୍‌ ବଲି ଜାନ୍‌ଲାସ୍‌, ସେଟା ଅବ୍‌କା ତାର୍‌ ନାଉଁଦାରି ବିସ୍‌ବାସ୍‌ କଲାକେସେ ମିଲ୍‌ଲା ଆଚେ । ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲାକେ ସେ ନିମାନ୍‌ ଅଇଲା ଆଚେ, ଏଟା ତମେ ଦେକ୍‌ଲାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ସେଟାର୍‌ ପାଇ ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌, ତମେ ଆରି ତମର୍‌ ନେତାମନ୍‌ ଜିସୁକେ ଜାଇଟା କଲାସ୍‌, ସେଟା ନାଜାନିକରି କଲାସ୍‌, ଏଟା ମୁଇ ଜାନି । ");
INSERT INTO dso_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ବେସି ବରସ୍‌ ଆଗ୍‌ତୁ ତାର୍‌ ବବିସତ୍‌ବକ୍‌ତା ମନର୍‌ଟାନେ ଅନି ଜାନାଇରଇବା କାତା ଇସାବେ ଏବେ ସିଦ୍‌ ଅଇଲା ଜେ, ସେ ମସିଅ ଦୁକ୍‌ପାଇବାକେ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ସେନ୍ତିଆଲେ ତମେ ମନ୍‌ବାଦ୍‌ଲାଇ କରି ପରମେସରର୍‌ ବାଟେ ବାଉଡି ଆସା । ତେବେ ସେ ତମର୍‌ ପାପ୍‌ କେମା କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ଆରି ମାପ୍‌ରୁର୍‌ଟାନେଅନି ଆତ୍‌ମାଇ ବପୁ ପାଇସା, ପରମେସର୍‌ ତମର୍‌ପାଇ ସେ ଆଗେଅନି ବାଚ୍‌ଲା, ମସିଅ ଜିସୁକେ ପାଟାଇସି । ");
INSERT INTO dso_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ପର୍‌ମେସର୍‌ ସବୁ ବିସଇ ନୁଆ କର୍‌ବା ବେଲା ଜାକ ସେ ସର୍‌ଗେ ରଇସି । ଏଟା ପର୍‌ମେସର୍‌ ପୁର୍‌ବେ ରଇଲା ତାର୍‌ ସୁକଲ୍‌ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ସପତ୍‌ କରିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ସେ ବିସଇ ମସା କଇରଇଲା, ତମର୍‌ ମାପ୍‌ରୁ ପରମେସର୍‌ ତମର୍‌ ଲଗେ ମର୍‌ପାରା ବବିସତ୍‌ବକ୍‌ତାକେ ପାଟାଇସି । ତମର୍‌ ବାଇମନର୍‌ ବିତ୍‌ରେ ଅନି ଗଟେକ୍‌ ଲକ୍‌କେ ପାଟାଇସି । ସେ ଜେତ୍‌କି ବିସଇ କଇସି, ସେଟା ସବୁ ତମେ ମାନ୍‌ବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","କେ ଜଦି ସେ ବବିସତ୍‌ବକ୍‌ତାର୍‌ କାତା ନ ନାମେ ତାକେ ପରମେସରର୍‌ ଲକ୍‌ମନର୍‌ଟାନେଅନି ଅଲ୍‌ଗା କରି କୁରୁପ୍‌ନାସ୍‌ କରିପାକାଇସି । ");
INSERT INTO dso_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ଜେତ୍‌କି କବର୍‌ ସୁନିରଇବା ବବିସତ୍‌ବକ୍‌ତା ରଇଲାଇ, ସାମୁଏଲ୍‌ ଆରି ଜେ ଜେ ତାର୍‌ ପଚେ ଆଇଲାଇ ଆରି ଏବେ ଜାଇଟା ଗଟ୍‌ଲା, ସେ ବିସଇ କଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ପର୍‌ମେସର୍‌ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ଟଣ୍ଡେଅନି ଜନ୍‍ସବୁ କାତା ଦେଲାଆଚେ ସେଟା ତମର୍‌ ପାଇସେ ଟିକ୍‌ । ତମର୍‌ ଆନିଦାଦିମନର୍‌ ସଙ୍ଗ୍‍ ଜନ୍‌ ରାଜିନାମା କଲାଆଚେ, ତମେ ମିସା ତେଇ ମିସିଆଚାସ୍‌ । ପର୍‌ମେସର୍‌ ଅବ୍‌ରାଆମ୍‍କେ କଇରଇଲା, “ମୁଇ ତମର୍‌ ନାତିତିତି ମନର୍‌ଟାନେଅନି ଜଗତର୍‌ ସବୁ ଲକ୍‌କେ ଆସିର୍‌ବାଦ୍‌ କର୍‌ବି । ");
INSERT INTO dso_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ସେଟାର୍‌ପାଇ ପରମେସର୍‌ ତାର୍‌ ସେବାକାରିଆକେ ବାଚ୍‌ଲା ଆରି ତମ୍‌କେ ସବୁ ଲକ୍‌କେ ବାନିଆ ବାଟେଅନି ବାଉଡାଇଆନ୍‌ବାକେ ଆରି ଆସିର୍‌ବାଦ୍‌ କର୍‌ବାକେ ପର୍‌ତୁମ୍‌ ତାକେ ତମର୍‌ ଲଗେ ପାଟାଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ପିତର୍‌ ଆରି ଜଅନ୍‌ ଲକ୍‌ମନ୍‌କେ ଏନ୍ତି ସିକିଆ ଦେଇତେ ରଇଲା ବେଲେ ମନ୍ଦିରର୍‌ କେତେଟା ପୁଜାରି ଆରି ଜାଗୁଆଲ୍‌ମନର୍‌ ସେନାପତି ଆରି କେତେଟା ସାଦୁକିମନ୍‌ ଆସି କେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ସେମନ୍‌ ରିସା ଅଇଗାଲାଇ କାଇକେ ବଇଲେ ପେରିତ୍‌ ସିସ୍‌ ଦୁଇଲକ୍‌ ଜିସୁ ମଲାତେଇଅନି ଉଟ୍‌ଲା ଆଚେ ବଲି ସିକାଇତେରଇଲାଇ । ଏନ୍ତି ସିକାଇଲେସରି ଲକ୍‌ମନ୍‌ ମଲାଟାନେଅନି ଉଟ୍‌ବାଇବଲି ପର୍‌ମାନ୍‌ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ସେଟାର୍‌ପାଇ ସେ ଦୁଇଟା ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ଦାରି ବାନ୍ଦ୍‌ଲାଇ । ଆରି ସେ ଦିନେ ବେସି ଅଲ୍‌ସମ୍‌ ଅଇଜାଇରଇଲାକେ ଆର୍‌କର୍‌ ଦିନ୍‌ ଜାକ ବନ୍ଦିଗରେ ରକିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ମାତର୍‌ ବେସି ଲକ୍‌ ସେମନର୍‌ ସିକିଆ ସୁନିକରି ବିସ୍‌ବାସ୍‌ କଲାଇ, ଆରି ତାକର୍‌ ବିତ୍‌ରେଅନି ମୁନୁସ୍‌ପିଲା ସେ ଅଦିକ୍‌ ଅଇକରି ପାକାପାକି ପାଁଚ୍‌ଅଜାର୍‌ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଜିଉଦି ନେତାମନ୍‌, ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ଆରି ନିୟମ୍‌ ସିକାଉମନ୍‌ ଜିରୁସାଲମେ ରୁଣ୍ଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ସେମନର୍‌ ବିତ୍‌ରେ ବଡ୍‌ପୁଜାରି ଆନାନ୍‌, କାୟାପା, ଜଅନ୍‌, ଆଲେକ୍‌ଜାଣ୍ଡାର୍‌ ଆରି ବଡ୍‌ ପୁଜାରିର୍‌ କୁଟୁମେ ରଇବା ବିନ୍‌ ଲକ୍‌ମନ୍‌ ମିସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ପେରିତ୍‌ମନ୍‌କେ ସେମନର୍‌ ମୁଆଟେ ଡାକାଇ ପାଚାର୍‌ଲାଇ, “ତମେ ଏଟା ସବୁ କେନ୍ତାର୍‌ କଲାସ୍‌ନି ? କାର୍‌ ବପୁସଙ୍ଗ୍‍ ନଇଲେ କାର୍‌ ନାଉଁଦାରି ଏଟା କଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ସେଟାର୍‌ପାଇ ପିତର୍‌ ସୁକଲ୍‌ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇ ସେମନ୍‌କେ କଇଲା, “ତମେ ଜେ କି ଆମର୍‌ ସାସନ୍‌କାରିଆମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ଜଦି ଆଜି ଏ ଚଟାର୍‌ ପାଇ କରିରଇଲା ନିମାନ୍‌ କାମର୍‌ଲାଗି ଆମ୍‌କେ ପର୍‌ସନ୍‌ କଲାସ୍‌ନି ଆରି ସେ କେନ୍ତାର୍‌ ନିମାନ୍‌ ଅଇଲା ବଲି ଜାନ୍‌ବାକେ ମନ୍‌ କଲାସ୍‌ନି, ");
INSERT INTO dso_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ତେବେ ତମେ ଆରି ଇସ୍‌ରାଏଲର୍‌ ସବୁ ଲକ୍‌ ଜାନ୍‌ବାର୍‌ ଦର୍‌କାର୍‌ ଜେ, ତମର୍‌ ମୁଆଟେ ଟିଆଅଇରଇଲା ଏ ଲକ୍‌ ଅବ୍‌କା ନାଜ୍‌ରିତ୍‌ ଗଡର୍‌ ଜିସୁକିରିସ୍‌ଟର୍‌ ବପୁସଙ୍ଗ୍‍ ପୁରାପୁରୁନ୍‌ ନିମାନ୍‌ ଅଇଲା ଆଚେ । ସେ ଜିସୁକେ ତମେ କୁର୍‌ସେ ମରାଇଲାସ୍‌ । ମାତର୍‌ ପର୍‌ମେସର୍‌ ତାକେ ମଲାତେଇଅନି ଆରି ତରେକ୍‌ ଉଟାଇଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଜିସୁର୍‌ ବିସଇ ଦରମ୍‌ ସାସ୍‌ତରେ ଲେକା ଅଇଲାଆଚେ, ଗର୍‌ ତିଆର୍‌କରୁମନ୍‌ ଜନ୍‌ ପାକ୍‌ନା ନଏଁ ବଲି ପିଙ୍ଗିଦେଇ ରଇଲାଇ, ସେଟାସେ କନର୍‌ ମୁକିଅ ପାକ୍‌ନା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ସେ ଆକା ଆମ୍‌କେ ମୁକ୍‌ତି ଦେଇସି । ଗୁଲାଇ ଜଗତର୍‌ପାଇ ପର୍‌ମେସର୍‌ ତାକେସେ ଦେଲା ଆଚେ । ଜେ କି ଆମ୍‌କେ ରକିଆ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ବଡ୍‌ସବାର୍‌ ଲକ୍‌ମନ୍‌ ପିତର୍‌ ଆରି ଜଅନର୍‌ ସାଆସ୍‌ ଦେକି କାବା ଅଇଗାଲାଇ । ସେମନ୍‌ ପାଟ୍‌ସାଟ୍‌ ନ ପଡି ଅବ୍‌କା ଲକ୍‌ମନ୍‌ସେ ବଲି ଜାନିରଇଲାଇ । ଆରି ସେମନ୍‌ ଦୁଇ ଲକ୍‌ ଜିସୁର୍‌ ସଙ୍ଗ୍‍ ରଇଲାଇ ବଲି ଚିନିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ମାତର୍‌ ତାକର୍‌ ବିରୁଦେ କାଇବଲି କଇନାପାର୍‌ଲାଇ, କାଇକେ ବଇଲେ ନିମାନ୍‌ ଅଇଲା ଲକ୍‌କେ ପିତର୍‌ ଆରି ଜଅନ୍‍ସଙ୍ଗ୍‍ ଟିଆଅଇରଇଲାଟା ଦେକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ସିସ୍‌ମନ୍‌କେ ସେ ସବାଇଅନି ବାର୍‌କରାଇଦେଇକରି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କାତାବାର୍‌ତା ଅଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ସେମନ୍‌ କାତା ଅଇଲାଇ, “ଆମେ ଏମନ୍‌କେ କାଇଟା କରୁ ? ଏମନ୍‌ କରିରଇବା ଏ କାବା ଅଇଜିବା କାମ୍‌ ବିସଇ ଜିରୁସାଲମର୍‌ ସବୁ ଲକ୍‌ ଜାନିଗାଲାଇ ଆଚତ୍‌ । ଏ ସତ୍‌ ଗଟେନାଇ କି ନାଜାନୁ ବଲି କଇ ନାପାରୁ । ");
INSERT INTO dso_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ମାତର୍‌ ଏ କାତା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ଆରି ଅଦିକ୍‌ ଉଡ୍‌ରା ଅଇ ନ ଜାଅ, ଜିସୁର୍‌ ବିସଇ ଆରି କେବେ କାର୍‌ ମୁଆଟେ ନ କଇବାକେ ସେମନ୍‌କେ ଆମେ ଡାଟ୍‌ ସଙ୍ଗ୍‍ ଜାଗ୍‍ରତ୍‌ କରାଇଦେଉଁ ।” ");
INSERT INTO dso_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ପିତର୍‌ ଆରି ଜଅନ୍‌କେ ଆରି ତରେକ୍‌ ବିତ୍‌ରେ ଡାକ୍‌ଲାଇ । ଆରି କେବେମିସା ଜିସୁର୍‌ ନାଉଁ ଦାରି କାଇମିସା କାତା ନ କଇବାକେ ଆରି ସିକିଆ ନ ଦେବାକେ ଜାଗ୍‍ରତ୍‌ କରାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ମାତର୍‌ ପିତର୍‌ ଆରି ଜଅନ୍‌ କଇଲାଇ, “ତମର୍‌ ବାଦିଅ ଅଇବୁ, କି ପରମେସରର୍‌ ବାଦିଅ ଅଇବୁ, କନ୍‌ ବିସଇ ପରମେସରର୍‌ ମୁଆଟେ ଟିକ୍‌ ସେଟା ତମେ ବିଚାର୍‌ କରା । ");
INSERT INTO dso_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","କାଇକେ ବଇଲେ ଆମେ ଜାଇଟା ଦେକ୍‌ଲୁ ଆଚୁ ଆରି ସୁନ୍‌ଲୁ ଆଚୁ ସେଟା ନ କଇକରି ରଇନାପାରୁ ।” ");
INSERT INTO dso_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ମାତର୍‌ ବଡ୍‌ସବାର୍‌ ଲକ୍‌ ଆରି ଡାଟ୍‌ସଙ୍ଗ୍‍ ସେମନ୍‌କେ ଦମ୍‌କାଇକରି ଚାଡି ଦେଲାଇ । ସେମନ୍‌କେ ଡଣ୍ଡ୍‌ଦେବାଟା କସ୍‌ଟ ବଲି ସେମନ୍‌ ଜାନିପାର୍‌ଲାଇ । କାଇକେ ବଇଲେ ସେ କାବାଅଇଜିବା କାମର୍‌ ଲାଗି ଲକ୍‌ମନ୍‌ ପର୍‌ମେସର୍‌କେ ଜୁଆର୍‌ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ଜନ୍‌ ଲକ୍‌ କାବା ଅଇଜିବା କାମର୍‌ଲାଗି ନିମାନ୍‌ ଅଇରଇଲା, ତାକେ ଚାଲିସ୍‌ ବରସେଅନି ଅଦିକ୍‌ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ପିତର୍‌ ଆରି ଜଅନ୍‌ ମୁକଲ୍‌ଲା ଦାପ୍‌ରେ ନିଜର୍‌ ଦଲେ ବାଉଡିଗାଲାଇ ଆରି ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ ଜାଇଟା କଇରଇଲାଇ, ସେଟା ସେମନ୍‌କେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ବିସ୍‌ବାସିମନ୍‌ ସବୁ କାତା ସୁନ୍‌ଲା ପଚେ ଗଟେକ୍‌ ଅଇ ପର୍‌ମେସର୍‌କେ ଏ ପାର୍‌ତନା କଲାଇ, ଏ ମାପ୍‌ରୁ ! ସରଗ୍‌, ଦର୍‌ତନି, ସମ୍‌ଦୁର୍‌ ଆରି ତେଇ ରଇବା ସବୁ ବିସଇ ତମେସେ ତିଆର୍‌ କଲାସ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ତମେ ସୁକଲ୍‌ ଆତ୍‌ମାଇଅନି ଆମର୍‌ ଆନିଦାଦିମନର୍‌ ଆରି ତମର୍‌ ଦାଙ୍ଗ୍‌ଡା ଦାଉଦର୍‌ ଟଣ୍ଡେଅନି ଏ କାତା ସୁନାଇ ରଇଲାସ୍‌ । ସେ କଇରଇଲା, ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌ କାଇକେ ରିସା ଅଇଲାଇ ? ଲକ୍‌ମନ୍‌ କାଇକେ ଚୁଚାଇ ସଡ୍‌ଜଁତର୍‌ କଲାଇ ? ");
INSERT INTO dso_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ମାପ୍‌ରୁର୍‌ ବିରଦେ ଆରି ତାକର ମସିଆର୍‌ ବିରଦେ ଜଗତର୍‌ ରାଜାମନ୍‌ ଆରି ସାସନ୍‌କାରିଆମନ୍‌ ଜୁଜ୍‌ବାକେ ନିଜ୍‌କେ ତିଆର୍‌ ଅଇ ରୁଣ୍ଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","କାଇକେବଇଲେ ଏ ନଅରେ ଏରଦ୍‌ ଆରି ପନ୍ତିୟ ପିଲାତ୍‌ ଇସ୍‌ରାଏଲିୟମନର୍‌ ସଙ୍ଗ୍‍ ଆରି ଜିଉଦି ନ ଅଇରଇବା ଲକର୍‌ସଙ୍ଗ୍‍ ମିସି ଜିସୁର୍‌ ବିରଦେ ଜଜ୍‌ନା କଲାଇ । ସେ ସେ ତମର୍‌ ସୁକଲ୍‌ ଦାଙ୍ଗ୍‌ଡା ଆରି ତମେ ବାଚ୍‌ଲା ମସିଅ । ");
INSERT INTO dso_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ତମର୍‌ ବପୁ ଆରି ମନ୍‌ କଲାଟା ଇସାବେ ଜାଇଟା ସବୁ ଗଟାଇବାପାଇ ତମେ ଟିକ୍‌ କରି ରଇଲାସ୍‌, ସେମନ୍‌ ଗଟେକ୍‌ ଅଇ ସେ ସବୁ କର୍‌ବାକେ ଲାଗିପଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“ଏ ମାପ୍‌ରୁ, ସେମନ୍‌ ଆମ୍‌କେ ଜନ୍‌ ଦମକ୍‌ ଦେଲାଇ ଆଚତ୍‌ ସେ ବିସଇ ସୁନା ଆରି ନ ଡର୍‌ତେ ତମର୍‌ କାତା ଜାନାଇବାକେ ତମର୍‌ ଏ ଦାଙ୍ଗ୍‌ଡାମନ୍‌କେ ଡାଟ୍‌ କରା । ");
INSERT INTO dso_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ନିମାନ୍‌ କର୍‌ବାକେ ତମର୍‌ ଆତ୍‌ ଲାମାଆ ଆରି ତମର୍‌ ସୁକଲ୍‌ ଦାଙ୍ଗ୍‌ଡା ଜିସୁର୍‌ ନାଏଁ ନ ଅଇବା କାମ୍‌ ଆରି କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ସାଦନ୍‌ କରାଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ସେମନ୍‌ ପାର୍‌ତନା କରିସାରାଇଲା ପଚେ ଜନ୍‌ ଜାଗାଇ ରୁଣ୍ଡିରଇଲାଇ, ସେଟା ଚୁଲ୍‌ବୁଲିଗାଲା । ସେମନ୍‌ ସବୁ ସୁକଲ୍‌ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇଲା । ଆରି ନ ଡର୍‌ତେ ପର୍‌ମେସରର୍‌ କାତା ଜାନାଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ସବୁ ବିସ୍‌ବାସିମନ୍‌ ଗଟେକ୍‌ ବିସଇ ଚିନ୍ତା କରି ମନ୍‌ କଲାଇ । କେ ମିସା ନିଜର୍‌ ସଁମ୍‌ପତି ନିଜର୍‌ ବଲି ଦାବି ନ କର୍‌ତେ ରଇଲାଇ । ତାକର୍‌ଟାନେ ଜେତ୍‌କି ରଇଲା ସେଟା ସବୁଲକ୍‌ ସମାନ୍‌ କରି ବାଟାସାଟା କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ବପୁସଙ୍ଗ୍‍ ସାକି ଦେବାର୍‌ ଦାର୍‌ଲାଇ । ପର୍‌ମେସର୍‌ ମାପ୍‌ରୁ ଜିସୁକେ କେନ୍ତିକରି ମଲାଟାନେଅନି ଉଟାଇଲା ବଲି । ଆରି ପର୍‌ମେସର୍‌ ସବୁ ବିସ୍‌ବାସିମନ୍‌କେ ଅଦିକ୍‌ ଅଦିକ୍‌ ଜିବନ୍‌ ଦୁକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ତାକର୍‌ ଦଲେ ଜିଇବା କାଇବାକେ କାକେ ମିସା ଅବାବ୍‌ ନ ରଇଲା । ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ଗର୍‌ ଆରି ଜମିରଇଲା, ସେମନ୍‌ ସେଟା ବିକିକରି ଡାବୁ ଆନି, ");
INSERT INTO dso_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ପେରିତ୍‌ମନ୍‌କେ ସର୍‌ପିଦେଇରଇଲା । ସେ ଡାବୁ, ପେରିତ୍‌ ମନ୍‌ ଅବାବେ ରଇଲା ଲକ୍‌ମନ୍‌କେ ବାଟାକରି ଦେଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ସାଇପରସ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ ଜନମ୍‌ କରିରଇବା ଲେବି କୁଟୁମର୍‌ ଜସେପ୍‌, ଜାକେ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ବର୍‌ନବା ବଲି ନାଉଁ ଦେଇ ରଇଲାଇ । ବର୍‌ନବାର୍‌ ଅରତ୍‌ ଦୁକ୍‌ ସାରାଇବା ପିଲା । ସେ ତାର୍‌ ଜମି ବିକ୍‌ଲା ଆରି ");
INSERT INTO dso_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ଡାବୁ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ସର୍‌ପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ସେ ଦଲର୍‌ ଅନନିୟ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଆରି ତାର୍‌ ମାଇଜି ସପିରା ସେମନର୍‌ କେତେକ୍‌ ଜମି ବିକ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ମାତର୍‌ ମାଇଜିମୁନୁସ୍‌ ରାଜିଅଇକରି ବିକିକରି ପାଇଲା କେତେକ୍‌ ଡାବୁ ଅନନିୟ ନିଜର୍‌ ପାଇ ସଙ୍ଗଇଲା । ଅଗଲ୍‌ଲାଟା ସେ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ପିତର୍‌ ତାକେ କଇଲା, “ଅନନିୟ ତୁଇ କେନ୍ତି ସଇତାନର୍‌ ପାନ୍ଦେପଡି ଜମି ବିକି ଆନିରଇବା ଡାବୁ କେତେକ୍‌ ନିଜର୍‌ ପାଇ ସଙ୍ଗଇକରି ସୁକଲ୍‌ ଆତ୍‌ମାର୍‌ ମୁଆଟେ ମିଚ୍‌ କଇଲୁସ୍‌ ? ");
INSERT INTO dso_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ବିକ୍‌ବା ଆଗ୍‌ତୁ ସେ ଜମି ତମର୍‌ ରଇଲା । ବିକ୍‌ଲା ପଚେ ମିସା ସେ ଡାବୁ ତମର୍‌ଟାସେ । ଏନ୍ତି କାମ୍‌ କର୍‌ବାକେ କାଇକେ ମନ୍‌ କଲୁସ୍‌ ? ତୁଇ ଲକ୍‌ମନ୍‌କେ ନାଡାଉସ୍‌ ନାଇ ମାତର୍‌ ପର୍‌ମେସର୍‌କେ ନାଡାଇଆଚୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ଅନନିୟ ଏ କାତା ସୁନ୍‌ଲା ଦାପ୍‌ରେ ତଲେ ଆପ୍‌ଟି ଅଇ ଅଦ୍‌ରି ମରିଗାଲା । ଜନ୍‌ ଲକ୍‌ମନ୍‌ ଏ କାତା ସୁନ୍‌ଲାଇ ସେମନ୍‌ ସବୁଲକ୍‌ ବେସି ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ଦଲର୍‌ ଦାଙ୍ଗ୍‌ଡାମନ୍‌ ଅନନିୟର୍‌ ମଲା ଗାଗଡ୍‌ ଲୁଗାଇ ଗୁଡିଆଇକରି ବାଇରେ ବଇକରି ଦାରିଗାଲାଇ ଆରି ତପିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ପାକାପାକି ତିନ୍‍ଗଁଟା ପଚେ ଅନନିୟର୍‌ ମାଇଜି ତେଇ ଆସି କେଟ୍‌ଲା । ସେ, ଏ ଗଟ୍‍ନା ନାଜାନି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ପିତର୍‌ ତାକେ ପାଚାର୍‌ଲା “ମକେ କ ପନି, ତୁଇ ଆରି ତର୍‌ ମୁନୁସ୍‌ ଜେତ୍‌କି ଜମି ବିକ୍‌ଲାସ୍‌, ଏଟା କାଇ ତାର୍‌ ପୁରାଦାମ୍‌ କି ?” ସେ କଇଲା, “ଉଁ ଏତ୍‌କିସେ ।” ");
INSERT INTO dso_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ପିତର୍‌ ତାକେ କଇଲା, “ମାପ୍‌ରୁର୍‌ ଆତ୍‌ମାକେ ପରିକା କର୍‌ବାକେ ତୁଇ ଆରି ତର୍‌ ମୁନୁସ୍‌ କାଇକେ ରାଜିଅଇଲାସ୍‌ ? ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତର୍‌ ମୁନୁସ୍‌କେ ସମାଦି ଦେଲାଇ ଆଚତ୍‌, ବାଟ୍‌ ଡିଆଗଡି କେଟ୍‌ଲାଇବେ, ସେମନ୍‌ ତକେ ମିସା ବଇ ଦାରିଜିବାଇବେ ।” ");
INSERT INTO dso_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ସେ ଦାପ୍‌ରେ ସେ ମିସା ପିତରର୍‌ ପାଦ୍‌ତଲେ ଅଦ୍‌ରି ମରିଗାଲା । ଦାଙ୍ଗ୍‌ଡାମନ୍‌ ବିତ୍‌ରେ ଆସି ତାର୍‌ ମଲା ଗାଗଡ୍‌ ବଇନେଲାଇ ଆରି ତାର୍‌ ମୁନୁସର୍‌ ଲଗେ ତାକେ ମିସା ସମାଦି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ଜିରୁସାଲେମର୍‌ ଗୁଲାଇ ମଣ୍ଡଲିର୍‌ ଲକ୍‌ମନ୍‌ ଆରି ଜେତ୍‌କି ଲକ୍‌ ଏ କାତା ସୁନ୍‌ଲାଇ, ସବୁଲକ୍‌ ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ପେରିତ୍‌ ସିସ୍‌ମନର୍‌ ଟାନେଅନି ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ବେସି କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ଆରି ଚିନ୍‌ମନ୍‌ ସାଦନ୍‌ ଅଇତେ ରଇଲା । ସବୁ ବିସ୍‌ବାସିମନ୍‌ ସଲ୍‌ମନର୍‌ ମଣ୍ଡପେ ରୁଣ୍ଡ୍‍ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ସେମନର୍‌ ବିସଇ ବିନ୍‌ଲକ୍‌ମନ୍‌ ନିମାନ୍‌ କାତା କଇତେ ରଇଲାଇ । ମାତର୍‌ ଦଲ୍‌ ବାଇରେ ରଇଲା ଲକ୍‌ମନ୍‌ କେ ମିସା ଦଲେ ମିସ୍‌ବାକେ ସାଆସ୍‌ ନ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ଏଲେ ମିସା ପର୍‌ମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ କରି ଅଦିକ୍‌ ଅଦିକ୍‌ ମାଇଜିଟକି ଆରି ମୁନୁସ୍‌ ପିଲାମନ୍‌ ଏ ଦଲେ ମିସ୍‌ଲାଇ । ଆରି ସେ ଦଲ୍‌ ଦିନ୍‌କେ ଦିନ୍‌ ଅଦିକ୍‌ ଅଦିକ୍‌ ବଡ୍‌ତେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ପେରିତ୍‌ ସିସ୍‌ମନର୍‌ କାମ୍‌ ଅଦିକ୍‌ ବଡି ବଡି ଗାଲା । ଏନ୍ତିକି ପିତର୍‌ ଇଣ୍ଡିଗାଲାବେଲେ ତାର୍‌ ଚାଇଆଲେ ଅଲପ୍‌ ପଡବଲି ଲକ୍‌ମନ୍‌ ରଗିମନ୍‌କେ ବଇଆନି ବାଟ୍‍ପାଲି କଟେ ଆରି ଟାଟିମନ୍‌ ଅଚାଇକରି ସୁଆଇ ଦେଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଜିରୁସାଲମର୍‌ ଚାରିବେଟ୍‌ତି ରଇବା ଗଡର୍‌ ରଗି ଆରି ଡୁମାଦାର୍‌ଲା ଲକ୍‌ମନ୍‌କେ ପେରିତ୍‌ମନର୍‌ ଲଗେ ଆନ୍‌ତେ ରଇଲାଇ । ଆରି ସେମନ୍‌ ସବୁ ଲକ୍‌ ନିମାନ୍‌ ଅଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ତାର୍‌ ପଚେ ବଡ୍‌ ପୁଜାରି, ତାର୍‌ସଙ୍ଗ୍‍ ରଇବା ଲକ୍‌ମନ୍‌ ଆରି ସାଦୁକି ଦଲର୍‌ ଲକ୍‌ମନ୍‌, ସିସ୍‌ମନ୍‍କେ ଇଁସା ଅଇଗାଲାଇ । ଆରି ସେମନର୍‌ ବିରୁଦେ କାଇଟାଆଲେ କରୁ ବଲି ଜଜ୍‌ନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ସେମନ୍‌ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ଦାରି ବାନ୍ଦିକରି ବନ୍ଦିଗରେ ସଙ୍ଗଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ମାତର୍‌ ସେ ରାତି ମାପ୍‌ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ବନ୍ଦିଗରର୍‌ କାପାଟ୍‌ ଉଗାଡିଦେଲା ଆରି ସେମନ୍‌କେ ମୁକ୍‌ଲାଇ ଆନି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ଜା ଆରି ମନ୍ଦିରେ ଟିଆଅଇକରି ଲକ୍‌ମନ୍‌କେ ଏ ନୁଆ ଜିବନ୍‌ ବିସଇ ସବୁ କାତା କୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ସିସ୍‌ମନ୍‌ ସେ ଦୁତର୍‌ କାତା ମାନି ସାକାଲ୍‌ ସାକାଲ୍‌ ମନ୍ଦିରେ ପୁରି ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲାଇ । ବଡ୍‌ ପୁଜାରି, ତାକର୍‌ ସଙ୍ଗାରିମନ୍‌ ଆରି ଇସ୍‌ରାଏଲର୍‌ ପାର୍‌ଚିନ୍‌ମନ୍‌ ଗଟେକ୍‌ ପୁରା ସବା ପାଇ ଡାକାଇ ପାଟାଇଲାଇ । ତାର୍‌ ପଚେ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ବନ୍ଦିଗରେ ଅନି ସବାଇ ଆନ୍‌ବାକେ ବନ୍ଦିଗରର୍‌ ଜାଗୁଆଲ୍‌ମନର୍‌ ମୁକିଆମନ୍‌କେ ଆଦେସ୍‌ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ମାତର୍‌ ସେ ମୁକିଆମନ୍‌ ବନ୍ଦିଗରେ କେଟ୍‌ଲାକେ ପେରିତ୍‌ମନ୍‌କେ ତେଇ ଦେକତ୍‌ନାଇ । ସେଟାର୍‌ପାଇ ସେମନ୍‌ ବଡ୍‌ସବାଇ ବାଉଡି ଆଇଲାଇ । ଆରି ଲକ୍‌ମନ୍‌କେ କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ଆମେ ବନ୍ଦି ଗରେ କେଟି ଦେକ୍‌ଲୁ ଜେ ଦୁଆର୍‌ ନିକସଙ୍ଗ୍‌ ଡାବି ଅଇରଇଲା । ଆରି ଜାଗୁଆଲ୍‌ମନ୍‌ ମିସା ଜାଗିରଇଲାଇ । ମାତର୍‌ କାପାଟ୍‌ ଉଗାଡ୍‌ଲା ପଚେ ଆମେ ବିତ୍‌ରେ କାକେ ମିସା ଦେକୁ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ଏ କାତା ସୁନି ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ମନ୍ଦିର୍‌ ଜାଗୁଆଲ୍‌ମନର୍‌ ଦାଇତେ ରଇଲା ଲକ୍‌ମନ୍‌ କାବାଅଇଗାଲାଇ । ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ କାଇଟା ଅଇଲାଆଚେ ବଲି ସେମନ୍‌ ବୁଜି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ସେଡ୍‌କିବେଲେ ଗଟେକ୍‌ ଲକ୍‌ ଆସି କଇଲା “ସୁନା ! ଜନ୍‌ ଲକ୍‌ମନ୍‌କେ ବନ୍ଦି ଗରେ ରକିରଇଲାସ୍‌, ସେମନ୍‌ ଏବେ ମନ୍ଦିରେ ଲକ୍‌ମନ୍‌କେ ସିକିଆ ଦେଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ମନ୍ଦିରର୍‌ କାମ୍‌କରୁମନ୍‌ ଜାଗୁଆଲ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ଜାଇ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ସୁତ୍‌ରାଇକରି ଆରିତରେକ୍‌ ଡାକିଆନ୍‌ଲାଇ । ସେମନ୍‌ ଡରାବିଡ୍‌ରା କରତ୍‌ ନାଇ । କାଇକେବଇଲେ ସେମନ୍‌କେ ଲକ୍‌ମନ୍‌ ପାକ୍‌ନାପୁକ୍‌ନି ମାର୍‌ବାଇ ବଲି ଡରିଜାଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ବିତ୍‌ରେ ଡାକିଆନି ବଡ୍‌ସବାର୍‌ ମୁଆଟେ ଟିଆ କରାଇଲାଇ, ଆରି ବଡ୍‌ ପୁଜାରି ସେମନ୍‌କେ ପାଚାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ଏ ଜିସୁର୍‌ ନାଉଁ ଦାରି କାଇମିସା ସିକିଆ ନ ଦେବାକେ ତମ୍‌କେ ଡାଟ୍‌ ସଙ୍ଗ୍‍ ଆଦେସ୍‌ ଦେଇରଇଲୁ, ମାତର୍‌ ଦେକା, ତମେ କାଇଟା କରିଆଚାସ୍‌ ! ତମେ ଦେଇରଇବା ଏ ସିକିଆ ଜିରୁସାଲମେ ରଇଲା ଲକ୍‌ମନର୍‌ଟାନେ କେଟ୍‌ଲା ଆଚେ । ଆରି ତାର୍‌ ମରନ୍‌ ପାଇ ଆମ୍‌କେ ଦାଇ କର୍‌ବାକେ ଚେସ୍‌ଟା କଲାସ୍‌ନି !” ");
INSERT INTO dso_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ପିତର୍‌ ଆରି ବିନ୍‌ ସିସ୍‌ମନ୍‌ କଇଲାଇ, “ଆମେ ତମର୍‌ ଆଦେସ୍‌ ମାନ୍‌ବା ବାଦୁଲେ ପର୍‌ମେସରର୍‌ ଆଦେସ୍‌ ମାନ୍‌ବୁ । ");
INSERT INTO dso_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ତମେ ଜିସୁକେ କୁର୍‌ସେ ଚଗାଇ ମରାଇଲାପଚେ, ଆମର୍‌ ଆନିଦାଦିମନର୍‌ ପର୍‌ମେସର୍‌ ତାକେ ମଲାଟାନେଅନି ଉଟାଇଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌ ତାକର୍‌ ପାପେଅନି ବାଅଡତ୍‌ ଆରି ପାପ୍‌ କେମା ଅଅତ୍‌ ବଲି ପର୍‌ମେସର୍‌ ତାକେ ତାର୍‌ ଉଜା ବାଟେ ବସାଇଆଚେ । ଜେନ୍ତିକି ସେ ଆମର୍‌ ସାସନ୍‌କାରିଆ ଆରି ରକିଆକର୍‌ବା ଲକ୍‌ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ଆମେ ଏ ସବୁ ବିସଇର୍‌ ସାକି ଆଚୁ । ଆରି ଜନ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମାକେ ପର୍‌ମେସର୍‌ ତାକର୍‌ ଆଗିଆଁକାରିମନ୍‌କେ ଦାନ୍‌କଲାଆଚେ, ସେ ମିସା ଏଟାର୍‌ ସାକି ।” ");
INSERT INTO dso_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ବଡ୍‌ସବାର୍‌ ଲକ୍‌ମନ୍‌ ଏ କାତା ସୁନି ଏତେକ୍‌ ରିସାଅଇଗାଲାଇ ଜେ, ପେରିତ୍‌ମନ୍‌କେ ମରାଇବାକେ ମନ୍‍ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ମାତର୍‌ ସେମନର୍‌ ବିତ୍‌ରେଅନି ଗମଲିଏଲ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ପାରୁସି ଲକ୍‌ ରଇଲା । ସେ ନିୟମ୍‌ ସିକାଇତେ ରଇଲା । ତାକେ ଲକ୍‌ମନ୍‌ ମାନିଅ କର୍‌ତେରଇଲାଇ । ସେ ବଡ୍‌ ସବାଇ ଟିଆଅଇ ପେରିତ୍‌ମନ୍‌କେ ଚନେକର୍‌ ପାଇ ବାଇରେ ନେବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ଆରି ବଡ୍‌ ସବାର୍‌ ଲକ୍‌ମନ୍‌କେ କଇଲା, “ଏ ଇସ୍‌ରାଏଲିୟ ବାଇମନ୍‌, ଏ ଲକ୍‌ମନ୍‌କେ ଜାଇଟା କର୍‌ବାକେ ଗାଲାସ୍‌ନି ଅଲପ୍‌ ବାବିଚିନ୍ତି କରି କରା । ");
INSERT INTO dso_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ତମର୍‌ ମନେରଇସି, ଅଲପ୍‌ ଆଗ୍‌ତୁ ତିଉଦା ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ରମିୟମନର୍‌ ବିରୁଦେ ଉଟ୍‌ଲା । ସେ ନିଜେ ବଡ୍‌ଲକ୍‌ ବଲି ଲକ୍‌ମନ୍‌କେ କଇଲାକେ ତାର୍‌ ସଙ୍ଗ୍‍ ଚାରିସଅ ଲକ୍‌ ମିସି ରଇଲାଇ । ମାତର୍‌ ତାକେ ମରାଇଲାଇ, ତାର୍‌ପଚେ ତାର୍‌ସଙ୍ଗର୍‌ ଲକ୍‌ମନ୍‌ ଚିନ୍‌ବିନ୍‌ ଅଇଗାଲାଇ ଆରି ତାର୍‌ ଦଲ୍‌ ବୁଡିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ତାର୍‌ପଚେ ଗାଲିଲି ଅନି ଜିଉଦା ନାଉଁର୍‌ ଆରି ଗଟେକ୍‌ ଲକ୍‌ ରମିୟମନର୍‌ ବିରୁଦେ ଉଟ୍‌ଲା । ରମିୟ ସର୍‌କାର ଲକ୍‌ମନର୍‌ ନାଉଁ ଲେକାଇବା ବେଲେ ଏଟା ଅଇଲା । ବେସି ଲକ୍‌କେ ତାର୍‌ ଦଲେ ମିସାଇବାକେ ସୁତ୍‌ରାଇଲା । ମାତର୍‌ ତାକେ ମିସା ମରାଇଲାଇ । ଆରି ତାର୍‌ ସବୁ ସିସ୍‌ମନ୍‌ ଚିନ୍‌ବିନ୍‌ ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ସେଟାର୍‌ ପାଇ ଜିସୁର୍‌ ସିସ୍‌ମନର୍‌ ବିସଇ ମୁଇ ତମ୍‌କେ କଇଲିନି, ସେମନ୍‌ କର୍‌ବା କାମ୍‌ ତେବାଆ ନାଇ, ଚାଡିଦିଆସ୍‌ । ସେମନ୍‌ କର୍‌ବା କାମ୍‌ ଆରି ଜଜନା ଜଦି ଲକ୍‌ମନର୍‌ଟାନେଅନି ଆସିରଇସି, ତେବେ ସେମନ୍‌ ମିସା ଆରିଜିବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ମାତର୍‌ ସେଟା ଜଦି ପର୍‌ମେସରର୍‌ଟାନେ ଆସିରଇସି ବଇଲେ, ତାକେ ତମେ ଦବାଇନାପାରାସ୍‌ । ସେତ୍‌କିଅନି ଡିସ୍‌ସି ଜେ ତମେ ପର୍‌ମେସରର୍‌ ବିରଦେ ଜୁଜ୍‌ଲାସ୍‌ନି ।” ବଡ୍‌ସବାର୍‌ ଲକ୍‌ମନ୍‌ ଗମଲିଏଲ୍‌ କଇଲା କାତା ମାନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ସେମନ୍‌ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ବଡ୍‌ସବାର୍‌ ବିତ୍‌ରେ ଆନ୍‌ବାକେ ଆଦେସ୍‌ ଦେଲାଇ । ଡାକିଆନିକରି ସେମନ୍‌କେ କର୍‌ଡା ସଙ୍ଗ୍‌ ମାରାଇଲାଇ । ଆରି ଜିସୁର୍‌ ନାଉଁଦାରି କାଇମିସା କାତା ନ କଇବାକେ ଆଦେସ୍‌ ଦେଇ ଚାଡିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ସାର୍‌ଦାସଙ୍ଗ୍‍ ବଡ୍‌ସବାଇଅନି ବାରଇଲାଇ, କାଇକେବଇଲେ ପର୍‌ମେସର୍‌ ଦେକ୍‌ବା ଇସାବେ ଜିସୁର୍‌ ସିସ୍‌ ଅଇକରି ଅପ୍‌ମାନ୍‌ ପାଇବାକେ ଅଦିକାର୍‍ ପାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ଆରି ସେମନ୍‌ ସବୁ ଦିନ୍‌ ମନ୍ଦିରେ ଆରି ଲକ୍‌ମନର୍‌ ଗରେ ଗରେ ମସିଅ ଜିସୁର୍‌ ବିସଇର୍‌ ସୁବ୍‌କବର୍‌ ଜାନାଇଲାଇ ଆରି ସିକିଆ ଦେବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ସେ ବେଲା, ବେସି ଜିଉଦି ଲକ୍‌ମନ୍‌ ଜିସୁର୍‌ ସିସ୍‌ ଅଇ ଆଇଲାଇ । ଗିରିକ୍‌ ବାସା କଇତେରଇବା ଜିଉଦିମନ୍‌, ଏବ୍‌ରି ବାସା କଇତେରଇବା ଜିଉଦିମନର୍‌ ବିରୁଦେ କାତା ଉଟାଇଲାଇ । କାଇକେବଇଲେ ଗିରିକ୍‌ ବାସାଇ କାତା ଅଇବା ଜିଉଦିମନ୍‌, ରାଣ୍ଡିମନ୍‌କେ ଦିନ୍‌କର୍‌ କାଦି ବାଟା କଲାବେଲେ ତାକର୍‌ ରାଣ୍ଡିମନ୍‌କେ ଏଲା କର୍‌ତେରଇଲାଇ ପନି । ");
INSERT INTO dso_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ସେଟାର୍‌ ପାଇ ବାର୍‌ଟା ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ସବୁ ବିସ୍‌ବାସିମନ୍‌କେ ରୁଣ୍ଡାଇକରି କଇଲାଇ, “କାଇବାଟା ବାଟାକର୍‌ବାର୍‌ ଆଚେ ବଲିକରି ପର୍‌ମେସରର୍‌ ବାକିଅ ସିକାଇବାଟା ଜଦି ଆମେ ଏଲା କର୍‌ବୁ ବଇଲେ ସେଟା ନିକ ବିସଇ ନଏଁ । ");
INSERT INTO dso_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ସେଟାର୍‌ ପାଇ ଏ ବାଇବଇନିମନ୍‌, ତମର୍‌ ବିତ୍‌ରେଅନି ସୁକଲ୍‌ଆତ୍‌ମାଇ ଆରି ଗିଆନେ ପୁରାପୁରୁନ୍‌ ଅଇରଇବା ଲକ୍‌ ବଲି ସବୁଲକ୍‌ ଜାନିରଇବା ସାତ୍‌ ଲକ୍‌କେ ବାଚା । ଆମେ ସେମନ୍‌କେ ଏ ସବୁ ବିସଇ କର୍‌ବାକେ ଦାଇତ୍‌ ଦେବୁ । ");
INSERT INTO dso_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ସେନ୍ତାର୍‌ ଆଲେ ପାର୍‌ତନା ଆରି ପର୍‌ମେସରର୍‌ ବାକିଅ ସିକାଇବାକେ ଆମେ ସବୁ ଦିଆନ୍‍ ଦେଇପାରିଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ଦଲର୍‌ ସବୁ ଲକ୍‌ ପେରିତ୍‌ ସିସ୍‌ମନର୍‌ କଇଲା କାତାଇ ରାଜିଅଇଲାଇ, ଆରି ଏ କାମ୍‌ କର୍‌ବାକେ ବିସ୍‌ବାସ୍‌ ଆରି ସୁକଲ୍‌ ଆତ୍‌ମାଇ ପୁରୁନ୍‌ ଅଇରଇବା ତିପାନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌, ଆରି ପିଲିପ୍‌, ପକ୍‌ରସ୍‌, ନିକାନର, ତିମନ୍‌, ପର୍‌ମନା ଆରି ଆଗେ ଜିଉଦି ଦରମ୍‌ ବିସ୍‌ବାସ୍‌ କରିରଇବା, ଆନ୍‌ଟିକିୟଇ ଅନି ଆସିରଇବା ଗଟେକ୍‌ ଜିଉଦି ନ ଅଇଲା, ନିକଲାୟକେ ବାଚ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ବିସ୍‌ବାସିମନ୍‌ ଏ ସାତ୍‌ଲକ୍‌କେ ପେରିତ୍‌ମନର୍‌ ଲଗେ ଆନ୍‌ଲାଇ । ସେମନ୍‌କେ, ଆତ୍‌ ସଙ୍ଗଇ ପାର୍‌ତନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଏନ୍ତାରି ପର୍‌ମେସରର୍‌ ବାକିଅ ଗୁଲାଇବାଟର୍‌ ଲକ୍‌ ସୁନ୍‌ଲାଇ । ଜିରୁସାଲମେ ଅଦିକ୍‌ ଅଦିକ୍‌ ସିସ୍‌ମନ୍‌ ବଡ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ, ବେସି ପୁଜାରିମନ୍‌ ମିସା ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ପର୍‌ମେସର୍‌ଟାନେ ବେସି ଆସିର୍‌ବାଦ୍‌ ପାଇ ଆରି ବପୁ ସଙ୍ଗ୍‍ ପୁରୁନ୍‌ ଅଇରଇବା ତିପାନ୍‌, ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ବେସି ନ ଅଇବା କାମ୍‌ମନ୍‌, କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ସାଦନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ମାତର୍‌ କେତେଲକ୍‌ ତାକେ ବିରଦ୍‌ କଲାଇ । ଏମନ୍‌ ଗତି କଟ୍‌ବାତେଇଅନି, ମୁକ୍‌ଲିରଇବା ଜିଉଦିମନ୍‌କେ ନେଇ, ଅଇରଇବା ପାର୍‌ତନା ଗରର୍‌ କେତେ ଲକ୍‌, ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେଲକ୍‌ ସାରିଆ ଅନି, କେତେକ୍‌ ଆଲେକ୍‌ଜାଣ୍ଡ୍‌ରିଆ ଅନି । ସେମନ୍‌ ସିଲିସିଆ ଅନି ଆରି ଆସିଆଇଅନି ଆସିରଇବା ବିନ୍‌ ଜିଉଦିମନର୍‌ ସଙ୍ଗ୍‍ ମିସିକରି ତିପାନର୍‌ ବିରଦେ ଦଦାପେଲା ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ମାତର୍‌ ସୁକଲ୍‌ ଆତ୍‌ମା ତିପାନ୍‌କେ ଏନ୍ତି ଗିଆନ୍‌ ଦେଲାଜେ, କେମିସା ତାର୍‌ କାତା ଚାଡାଇକରି କଇ ନାପାର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ଏଲେମିସା ସେ “ମସାର୍‌ ବିରଦେ ଆରି ପର୍‌ମେସରର୍‌ ବିରଦେ କାତା କଇବାଟା ଆମେ ସୁନ୍‌ଲୁ ।” ବଲି, ଏ ମିଚ୍‌ ସାକି ଦେବାକେ କେତେ ଲକ୍‌କେ ଲାଁଚ୍‌ ଦେଇ ଉସ୍‌କାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ଏନ୍ତାରିକରି ସେମନ୍‌ ଲକ୍‌ମନ୍‌କେ, ପାର୍‌ଚିନ୍‌ମନ୍‌ ଆରି ସାସ୍‌ତର୍‌ ସିକାଉମନ୍‌କେ ରିସା ଅଇବା କାତା କଇଲାଇ । ଆରି ତିପାନ୍‌କେ ଦାରି ବଡ୍‌ସବାଇ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ତାର୍‌ ପଚେ ସେମନ୍‌ ତାର୍‌ ବିରୁଦେ ମିଚ୍‌ ସାକି ଦେବାକେ କେତେଟା ଲକ୍‌ମନ୍‌କେ ବିତ୍‌ରେ ଆନ୍‌ଲାଇ । ସେମନ୍‌ କଇଲାଇ, “ଏ ଲକ୍‌ ସବୁବେଲେ ଆମର୍‌ ସୁକଲ୍‌ ମନ୍ଦିର୍‌ ଆରି ମସାର୍‌ ରିତିନିତି ବିରୁଦେ ନିନ୍ଦା କାତା କଇବୁଲ୍‌ଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ନାଜରିତର୍‌ ଜିସୁ ମନ୍ଦିର୍‌ ବାଙ୍ଗାଇ ପାକାଇସି ଆରି ଆମେ ମସାର୍‌ ଟାନେଅନି ପାଇ ରଇବା ସବୁ ବିଦିବିଦାନ୍‌ ବାଦ୍‌ଲାଇ ଦେଇସି ବଲି ଏ ଲକ୍‌ କଇବାଟା ଆମେ ସୁନି ଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ସେଡ୍‌କି ବେଲେ ବଡ୍‌ସବାଇ ବସି ରଇବା ସବୁ ଲକ୍‌ ଆକିଗାଡି ତିପାନର୍‌ ବାଟେ ଦେକ୍‌ଲାଇ ଜେ, ଏଦେ ଦେକା ! ତାର୍‌ ମୁ ସରଗର୍‌ ଦୁତ୍‌ ପାରା ଡିସ୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ବଡ୍‌ ପୁଜାରି ତିପାନ୍‌କେ ପାଚାର୍‌ଲା, “ତର୍‌ ବିରୁଦେ କଇବା ଏ ସବୁ କାତା ସତ୍‌ କି ?” ");
INSERT INTO dso_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ତିପାନ୍‌ କଇଲା, “ଇତି ରଇବା ମର୍‌ ବାଇମନ୍‌ ଆରି ବାବାମନ୍‌ ଅଲପ୍‌ ସୁନା, ଆମର୍‌ ଆନିଦାଦି ଅବ୍‌ରାଆମ୍ ଆରନେ ବାସା ଅଇବାକେ ଜିବା ଆଗ୍‌ତୁ ମଇମା କର୍‌ବା ପର୍‌ମେସର୍‌ ମେସପଟାମିଆଇ ଦେକାଇଅଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ଆରି ତାକେ କଇଲା, 'ତମର୍‌ ଦେସ୍‌ ଆରି ତମର୍‌ କୁଟୁମ୍‌କେ ଚାଡିକରି ମୁଇ ଜନ୍‌ ଦେସ୍‌ ଦେକାଇବି, ସେ ଦେସେ ଜା । ");
INSERT INTO dso_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ତେବର୍‌ପାଇ ସେ ତାର୍‌ ଦେସ୍‌ ଚାଡିକରି ଆରାନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଦେସେ ବାସା ଅଇବାକେ ଗାଲା । ଅବ୍‌ରାଆମର୍‌ ବାବା ମଲା ପଚେ, ପର୍‌ମେସର୍‌ ତାକେ, ତମେ ରଇବା ଏ ଦେସେ ଆନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ସେବେଲେ ପର୍‌ମେସର୍‌ ଅବ୍‌ରାଆମ୍‍କେ ଏ ଦେସେ କାଇ ଅଦିକାର୍‌ କି ପାଦେକ୍‌ ଜମି ମିସା ଦେଇ ନ ରଇଲା । ମାତର୍‌ ତାକେ ଏ ଦେସ୍‌ ପଚେ ଦେବାକେ ପର୍‌ମେସର୍‌ କାତାଦେଇରଇଲା । ଆରି ସେଟା ତାର୍‌ ନାତିତିତି ମନର୍‌ ପାଇ ଅଇସି ବଲି ସପତ୍‌ କଲା । ପର୍‌ମେସର୍‌ ଏ କାତା ଦେଇରଇଲା ବେଲେ ଅବ୍‌ରାଆମ୍‍କେ ପିଲାଟକି ନ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ସେବେଲେ ପର୍‌ମେସର୍‌ ଅବ୍‌ରାଆମ୍‍କେ ଏନ୍ତିବଲି କଇରଇଲା, “ତମର୍‌ ନାତିତିତିମନ୍‌ ବିନ୍‌ ଦେସେ ଚାଲିସ୍‌ ବରସ୍‌ ଜାକ ଗତି ଅଇକରି ରଇବାଇ । ସେ ଦେସର୍‌ ଲକ୍‌ ସେମନ୍‌କେ କରାପ୍‌ ଚଲାଚଲ୍‌ତି ଦେକାଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ମାତର୍‌ ସେମନ୍‌ ଜନ୍‌ ଲକ୍‌ମନର୍‌ ସେବା କର୍‌ବାଇ, ମୁଇ ସେ ଲକ୍‌ମନ୍‌କେ ବିଚାର୍‌ କର୍‌ବି । ପଚେ ତମର୍‌ ନାତିତିତିମନ୍‌ ସେ ଦେସେଅନି ବାରଇ ଆଇବାଇ ଆରି ଏ ଜାଗାଇ ମର୍‌ ଉପାସନା କର୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ତାର୍‌ପଚେ ପର୍‌ମେସର୍‌ ଅବ୍‌ରାଆମର୍‌ ସଙ୍ଗ୍‍ କାତାଦେଇ ରଇବା ରାଜିନାମାର୍‌ ଚିନ୍‌ ଇସାବେ ସୁନତ୍‌ କର୍‌ବା ବିଦି ତିଆର୍‌ କଲା । ଇସାକ୍‌ ଜନମ୍‌ ଅଇ ଆଟ୍‍ଦିନ୍‌ ପଚେ ଅବ୍‌ରାଆମ୍ ତାକେ ସୁନତ୍‌ କଲା । ପଚେ ଇସାକ୍‌ ତାର୍‌ ପଅ ଜାକୁବ୍‌କେ ସେନ୍ତାରି କଲା । ସେନ୍ତାରିସେ ଜାକୁବ୍‌ ତାର୍‌ ବାର୍‌ଟା ପଅମନ୍‌କେ ସୁନତ୍‌ କଲା, ଜନ୍‌ ଲକ୍‌ମନ୍‌ କି ଆମର୍‌ ଡାକ୍‌ପୁଟା ସଙ୍ଗ୍‍ ରଇବା ଆନିଦାଦିମନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ଜାକୁବର୍‌ ପଅମନ୍‌ ତାକର୍‌ ସାନ୍‌ ବାଇ ଜସେପ୍‌କେ ଇଁସା ଅଇକରି, ମିସର୍‌ ଦେସର୍‌ ବେବାରିମନ୍‌କେ ବିକିଦେଲାଇ । ମାତର୍‌ ପର୍‌ମେସର୍‌ ଜସେପର୍‌ ସଙ୍ଗ୍‍ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ଆରି ସବୁ ଦୁକ୍‌ କସ୍‌ଟତେଇଅନି ତାକେ ରକିଆ କଲା । ଜେଡେବେଲେ ଜସେପ୍‌ ମିସର୍‌ ରାଜାର୍‌ ମୁଆଟେ ଟିଆଅଇଲା, ପର୍‌ମେସର୍‌ ତାକେ ଗିଆନ୍‌ ଦେଲା । ଆରି ସବୁଲକ୍‌ ମନ୍‌କଲାପାରା ଚଲାଚଲ୍‍ତି ଦେଲା । ପାର ରାଜା ଜସେପ୍‌କେ ସେ ଦେସର୍‌ ସାସନ୍‌କାରିଆ ଆରି ତାର୍‌ କୁଟୁମର୍‌ ସବୁ ଦେକାରକା କର୍‌ବା ଦାଇତ୍‌ ସର୍‌ପି ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ଜସେପ୍‌ ସାସନ୍‌କାରିଆ ରଇଲାବେଲେ ମିସର୍‌ ଆରି କିଣାନ୍‌ ଦେସେ ମର୍‌ଡି ଅଇଲା ଜେ ଲକ୍‌ମନ୍‌ ବେସି ଅଇରାନ୍‌ ଅଇଗାଲାଇ । ସେବେଲେ ଆମର୍‌ ଆନିଦାଦିମନ୍‌କେ କାଇଟା ମିସା କାଇବାଟା ମିଲେନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ମିସର୍‌ ଦେସେ ଦାନ୍‌ ମିଲ୍‌ସି, ବଲି ସୁନି ଜାକୁବ୍‌ ପର୍‌ତୁମ୍‌ତର୍‌ ତାର୍‌ ପିଲାମନ୍‌କେ କାଦି ଗେନ୍‌ବାକେ ପାଟାଇଲା । ଜେକି ଆମର୍‌ ଆନିଦାଦିମନ୍‌ ଅଇବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ତେଇ ସେମନ୍‌ ପଚର୍‌ ପାଲି ଗାଲାବେଲେ ଜସେପ୍‌ ତାର୍‌ ନିଜର୍‌ ବାଇମନ୍‌କେ ଚିନାଇ ଅଇଲା ଆରି ମିସରର୍‌ ରାଜା ପାର ଜସେପର୍‌ କୁଟୁମ୍‍କେ ଜାନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ତାର୍‌ ପଚେ ଜସେପ୍‌ ତାର୍‌ ବାବା ଜାକୁବ୍‌ ଆରି ତାର୍‌ କୁଟୁମର୍‌ ସବୁକେ ମିସାଇ ସତୁରି ପାଁଚ୍‌ ଲକ୍‌କେ ମିସରେ ଆଇବାକେ କବର୍‌ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ଜାକୁବ୍‌ ମିସର୍‌ ଦେସେ ଗାଲା, ତେଇ ସେ, ତାର୍‌ ପଅମନର୍‌ ମରନ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ସେମନର୍‌ ମଲା ଗାଗଡ୍‌ ସେକିମେ ନେଲାଇ । ଆରି ଅବ୍‌ରାଆମ୍ କେତେକ୍‌ ଡାବୁଦେଇ ଆମ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ କୁଟୁମେ ଅନି ଗେନ୍‌ଲା ମସ୍‌ନେ ନେଇ ସେମନ୍‌କେ ସଙ୍ଗଇଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ପର୍‌ମେସର୍‌ ଅବ୍‌ରାଆମ୍ ଜନ୍‌ ସପତ୍‌ ଦେଇ ରଇଲା ସେଟା ସିଦ୍‌ଅଇଲା । ମିସର୍‌ଦେସେ ଆମର୍‌ ଜାତିର୍‌ ଲକ୍‌ମନ୍‌ ବେସି ବଡି ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ସାରାସାରି, ଜସେପର୍‌ ବିସଇ ଜାନି ନ ରଇବା ଗଟେକ୍‌ ରାଜା, ମିସର୍‌ ଦେସ୍‌ ସାସନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ସେ ଆମର୍‌ ଆନିଦାଦିମନ୍‌କେ ବେସି ନାଡାଇଲା । ଆରି ବେସି ଅଇରାନ୍‌ କଲା । ସେମନର୍‌ କଅଁଲା ପିଲାମନ୍‌କେ ନିପାତ୍‌ କରି ବାଇରେ ପିଙ୍ଗି ଦେବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ସେ ବେଲାଇ ମସା ଜନମ୍‌ ଅଇଲା । ସେ ଗଟେକ୍‌ ବେସି ସୁନ୍ଦର୍‌ ପିଲା ରଇଲା । ତାକେ ତିନ୍‌ ମାସ୍‌ ଜାକ ଗରେସେ ପସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ଆରି ଜେଡେବେଲେ ବାଇରେ ଲୁଚାଇଦେଲାଇ, ପାର ରାଜାର୍‌ କନିଆ ତାକେ ମିଲାଇକରି ନିଜର୍‌ ପିଲାପାରା ପସ୍‌ପାଲ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ମିସର୍‌ ଦେସେ ଜେତ୍‌କି ଗିଆନ୍‌ ରଇଲା, ସେ ସବୁ ଗିଆନ୍‌ ମସାକେ ସିକାଇଲାଇ । ସେ ବଡିକରି ତାର୍‌ କାତାବାର୍‌ତା ଆରି କାମର୍‌ ଲାଗି ଗଟେକ୍‌ ଡାକ୍‌ପୁଟା ଲକ୍‌ ବଲାଇଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ଜେଡେବେଲେ ମସାକେ ଚାଲିସ୍‌ ବରସ୍‌ ଅଇଲା, ସେ ତାର୍‌ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌ କାମ୍‌ କର୍‌ବା ଜାଗା ଦେକ୍‌ବାକେ ମନ୍‌କଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ଇସ୍‌ରାଏଲିଅ ମନର୍‌ ବିତ୍‌ରେଅନି ଗଟେକ୍‌କେ ମିସରିୟର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ସାଦ୍‌ବାନ୍ଦ୍‌ କର୍‌ବାଟା ଦେକି ମସା ତାକେ ରକିଆ କଲା । ଆରି ସେ କର୍‌ବାଟା ସୁଜାଇବି ବଲି ମିସରିଅକେ ସେ ମରାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ମସା ବାବିରଇଲା, ସେମନ୍‌କେ ମୁକ୍‌ଲାଇବାକେ ପର୍‌ମେସର୍‌ ତାକେ ବାଚ୍‌ଲାଆଚେ ବଲି ତାର୍‌ ନିଜର୍‌ ବାଇମନ୍‌ ଏତାଇବାଇ । ମାତର୍‌ ସେମନ୍‌ ସେଟା ବୁଜତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଦୁଇଟା ଇସ୍‌ରାଏଲିଅ ମନ୍‌ ମାରାମାରି ଅଇତେରଇବାଟା ଦେକ୍‌ଲା । ଆରି ସେମନ୍‌ ମିସତ୍‌ ବଲି ବୁଜାଇବାକେ ଚେସ୍‌ଟା କଲା । ସେ କଇଲା, “ସୁନା ତମେ ଦୁଇ ଲକ୍‌ତା ଇସ୍‌ରାଏଲର୍‌ ବାଇବାଇ ଅଇସା । କାଇକେ ଏନ୍ତାରି ମାରାମାରି ଅଇଲାସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ମାତର୍‌ ଜନ୍‌ ଲକ୍‌ ଆରିଗଟେକ୍‌ ଲକ୍‌କେ କାରାପ୍‌ କାତା କଇ ଲାଗ୍‌ତେରଇଲା, ସେ ମସାକେ ଏଡାଇଦେଇ କଇଲା, “ଆମ୍‌କେ ସାସନ୍‌ କର୍‌ବାକେ ଆରି ଆମ୍‌କେ ବିଚାର୍‌ କର୍‌ବା ଅଦିକାର୍‌, କେ ତକେ ଦେଇଆଚେ ? ");
INSERT INTO dso_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","କାଲି ଜେନ୍ତି ଗଟେକ୍‌ ମିସରିୟକେ ମରାଇଲୁସ୍‌, ସେନ୍ତି ମକେ ମିସା ମରାଇବାକେ ମନ୍‌ କଲୁସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ଏଟା ସୁନିକରି ମସା ମିସର୍‌ଦେସେଅନି ଉଟିପାଲାଇଲା ଆରି ମିଦିଅନ୍‌ ଦେସେ ଜାଇ ବାସାକଲା । ତେଇ କେତେ ବରସ୍‌ ରଇକରି ଆରି ତାର୍‌ ଦୁଇଟା ପିଲା ଜନମ୍‌ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“ଚାଲିସ୍‌ ବରସ୍‌ ରଇଲା ପଚେ, ମରୁବାଲି ରଇବା ଜାଗାର୍‌ ସିନୟ ନାଉଁର୍‌ ପର୍‌ବତେ ଗଟେକ୍‌ ଜଇ ଲାଗ୍‌ବା ବୁଟାର୍‌ ମଜାଇ ପର୍‌ମେସରର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌, ମସାକେ ଦେକାଇ ଅଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମସା ଏଟା ଦେକି ବେସି କାବା ଅଇଗାଲା, ଆରି କଣ୍ଡେକ୍‌ ନିକକରି ଦେକ୍‌ବି ବଲି ବୁଟା ଲଗେ ଗାଲା । ମାତର୍‌ ତେଇ ସେ ମାପ୍‌ରୁର୍‌ କାତା ସୁନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“ମୁଇ ତମର୍‌ ଆନିଦାଦି ଅବ୍‌ରାଆମ୍, ଇସାକ୍‌ ଆରି ଜାକୁବର୍‌ ପର୍‌ମେସର୍‌ ।” ମସା ଡରିକରି ତର୍‌ତର୍‌ ଗଜ୍‌ଗଜ୍‌ ଅଇ ଦେକ୍‌ବାର୍‌ ନାପାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ମାପ୍‌ରୁ ତାକେ କଇଲା, “ତୁଇ ପିନ୍ଦିରଇବା ପାଣ୍ଡଇ ବେଟ୍‌ । କାଇକେବଇଲେ ତୁଇ ଜନ୍‌ ଜାଗାଇ ଟିଆଅଇଆଚୁସ୍‌, ସେଟା ସୁକ୍‌ଲା ଜାଗା । ");
INSERT INTO dso_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ମିସର୍‌ ଦେସେ ମର୍‌ ଲକ୍‌ମନ୍‌ କସ୍‌ଟ ଅଇବାଟା ଦେକିଆଚି । ମୁଇ ସେମନର୍‌ କାନ୍ଦାବୁବା ସୁନିଆଚି ଆରି ସେମନ୍‌କେ ମୁକ୍‌ଲାଇ ଆନ୍‌ବାକେ ଉତ୍‌ରି ଆଇଲିଆଚି । ଏବେ ଆଉ, ମୁଇ ତକେ ମିସର୍‌ ଦେସେ ପାଟାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ମସାକେ ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌ ନିଚ୍‌ତେରଇଲାଇ । ସେମନ୍‌ ପାଚାରି ରଇଲାଇ, “ଆମ୍‌କେ ସାସନ୍‌ କର୍‌ବାକେ ଆରି ଆମ୍‌କେ ବିଚାର୍‌ କର୍‌ବାକେ କେ ଅଦିକାର୍‌ ଦେଇଆଚେ ?” ମାତର୍‌ ପର୍‌ମେସର୍‌ ଆକା ନିଜେ ମସାକେ ସେ ଲକ୍‌ମନର୍‌ ଉପ୍‌ରେ ସାସନ୍‌ କର୍‌ବାକେ ଆରି ସେମନ୍‌କେ ମୁକ୍‌ଲାଇ ଆନ୍‌ବାକେ ପାଟାଇରଇଲା । ଜଇଲାଗ୍‌ବା ବୁଟାଇ ଦର୍‌ସନ୍‌ ଇସାବେ ଦେକାଇଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ମିସର୍‌ ଦେସେ, ଲଇତ୍‌ ସାଗରେ ଆରି ଚାଲିସ୍‌ ବରସ୍‌ ମରୁବାଲି ବୁଏଁ କେତେକ୍‌ କେତେକ୍‌ କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ଆରି ଚିନ୍‌ମନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ମସା ନିଜେ ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌କେ କଇରଇଲା, “ମକେ ଜେନ୍ତି ପର୍‌ମେସର୍‌ ପାଟାଇଲା । ସେନ୍ତାରିସେ ତମର୍‌ ବାଇମନର୍‌ ଲଗେ ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତାକେ ପାଟାଇସି, ସେ ତମର୍‌ ନିଜର୍‌ ଲକ୍‌ମନର୍‌ ଟାନେଅନିସେ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“ଇସ୍‌ରାଏଲିଅ ଲକ୍‌ମନ୍‌ ମରୁବାଲି ବୁଏଁ ରଇଲାବେଲେ ସେ ସେମନର୍‌ ସଙ୍ଗ୍‍ ରଇଲା । ସିନୟ ପର୍‌ବତେ ଆମର୍‌ ଆନିଦାଦିମନର୍‌ ସଙ୍ଗ୍‍ ଦୁତ୍‌ କାତା ଅଇଲାବେଲେ ସେ ରଇଲା । ଆରି ସେ ପର୍‌ମେସର୍‌ଟାନେଅନି ଜିବନ୍‌ ଦେବା ବାକିଅ ମିଲାଇକରି ଆମ୍‌କେ ଜାନାଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ମାତର୍‌ ଆମର୍‌ ପୁର୍‌ବର୍‌ ଆନିଦାଦିମନ୍‌ ମସାର୍‌ କାତା ସୁନତ୍‌ ନାଇ । ମିସର୍‌ ଦେସେ ବାଉଡି ଜୁ ବଲି ମନ୍‌କଲାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ସେଟାର୍‌ପାଇ ସେମନ୍‌ ଆରଣ୍‌କେ କଇଲାଇ, “ଆମ୍‌କେ ମିସର୍‌ ଦେସେଅନି ବାର୍‌କରାଇ ଆନ୍‌ଲା ମସା କେନେ ଗାଲାଆଲେ, ଆମେ ନାଜାନୁ । ଏବେ ଆମ୍‌କେ ବାଟ୍‌ ଦେକାଇ ନେବାକେ କେତେଟା ପୁତ୍‌ଲା ବନାଇ ଦେ । ସେମନ୍‌ ଆମର୍‌ ଦେବ୍‌ତା ଅଇ ବାଟ୍‍ଦେକାଇବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ସେବେଲେ ସେମନ୍‌ ତେଇ ଗଟେକ୍‌ ବାଚାପିଲା ପାରା ଡିସ୍‌ବା ପୁତ୍‌ଲା ତିଆର୍‌କଲାଇ । ଆରି ତାର୍‌ଲାଗି ପୁଜାକରୁ ବଲି ଚଗାଇଲାଇ । ଆରି ନିଜେ ତିଆର୍‌ କରିରଇବା ସେ ମୁର୍‌ତିକେ ସନ୍‌ମାନ୍‌ ଦେବାକେ ଗଟେକ୍‌ ବଜି କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ସେଟାର୍‌ପାଇ ପର୍‌ମେସର୍‌ ସେମନ୍‌କେ ଦେକେନାଇ ଆରି ସେମନ୍‌କେ, ଆକାସର୍‌ ତାରାମନ୍‌ ପୁଜା କରତ୍‌ ବଲି ଚାଡିଦେଲା । ଏ ବିସଇ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ବଇଟାନେ ଲେକା ଆଚେ, “ଏ ଇସ୍‌ରାଏଲ୍‌ ବଁସର୍‌ ଲକ୍‌ମନ୍‌, ମରୁବାଲି ବୁଏଁ ଚାଲିସ୍‌ବରସ୍‌ ଜାକ ତମେ ପସୁମନ୍‌କେ ମରାଇକରି ବଲି ଇସାବେ ଦେଲାସ୍‌ । ମାତର୍‌ ସେଟା ମର୍‌ପାଇ ଦେଇ ନ ରଇଲାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ମଲେକ୍‌ ପୁତ୍‌ଲାକେ ପର୍‌ମେସର୍‌ ବଲି ତାର୍‌ ତମୁ ଗଟେକ୍‌ ଜାଗାଇଅନି ଆରିଗଟେକ୍‌ ଜାଗାଇ ବଇନେଲାସ୍‌ । ରେପାନ୍‌ ତାରାର୍‌ ପୁତ୍‌ଲା ମିସା ଗଟେକ୍‌ ଜାଗାଇଅନି ଆରିଗଟେକ୍‌ ଜାଗାଇ ବଇନେଲାସ୍‌ । ଏ ସବୁଜାକ ପୁତ୍‌ଲାମନ୍‌କେ ତମେ ପୁଜାବିଦି କର୍‌ବାକେ ବନାଇରଇଲାସ୍‌ । ସେଟାର୍‌ପାଇ ମୁଇ ତମ୍‌କେ ତମର୍‌ ନିଜର୍‌ ଦେସେଅନି ବାବିଲନ୍‌ ଦେସର୍‌ ତେନ୍‌କେ ନେବାକେ ଜଜ୍‌ନା କର୍‌ବି ।” ");
INSERT INTO dso_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ତିପାନ୍‌ ଆରି କଇଲା, “ମରୁବାଲିବୁଏଁ ଆମର୍‌ ଆନିଦାଦିମନ୍‌ ରଇଲାବେଲେ ପର୍‌ମେସର୍‌ ସେମନ୍‌କେ ଲେକି ଦେଇରଇବା ନିୟମ୍‌ ମନ୍‌ ବିତ୍‌ରେ ରଇଲା । ସେଟା ପର୍‌ମେସର୍‌ ମସାକେ ଜେନ୍ତି ତମୁ ତିଆର୍‌ କର୍‌ବାକେ କଇରଇଲା, ଆରି ତାକେ ଜନ୍‌ କାମ୍‌ ଦେକାଇ ରଇଲା, ଏଟା ସେନ୍ତାରିସେ ତିଆର୍‌ ଅଇରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","“ପଚେ ଆମର୍‌ ଆନିଦାଦିମନ୍‌ ସେମନର୍‌ ଆନିଦାଦିମନର୍‌ ଟାନେଅନି ମିଲାଇକରି ସେ ତୁମ୍‌ ଜିଅସୁଅ ସଙ୍ଗ୍‍ ବଇ ଦାରିଗାଲାଇ । ଆରି ପର୍‌ମେସର୍‌ ବାର୍‌କରାଇ କେଦି ରଇବା ବିନ୍‌ ଜାତିମନର୍‌ ଦେସ୍‌, ସେମନ୍‌ ଅଦିକାର୍‌ କଲାଇ । ଦାଉଦର୍‌ ସାସନ୍‌ ବେଲେ ଜାକ ସେ ତମୁ ତେଇସେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ଦାଉଦ୍‌ ପର୍‌ମେସରର୍‌ ମନ୍‌କେ ଜାଇରଇଲାଜେ ଜାକୁବର୍‌ ପର୍‌ମେସରର୍‌ ପାଇ ଗଟେକ୍‌ ମନ୍ଦିର୍‌ ତିଆର୍‌ କର୍‌ବି ବଲି ତାର୍‌ ଆଦେସ୍‌ ପାଇବାକେ ମନ୍‌ କର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ପଚେ ସେ ମନ୍ଦିର୍‌ ଦାଉଦର୍‌ ପଅ ସଲ୍‌ମନ୍‌ ତିଆର୍‌ କର ବଲି ମନ୍‍କଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ଅଇଲେ ମିସା ସବୁର୍‌ ଉପ୍‌ରର୍‌ ପର୍‌ମେସର୍‌ ଲକ୍‌ମନ୍‌ ତିଆର୍‌ କଲା ଗରେ ବାସା ନ କରେ । ଏ ବିସଇ ବବିସତ୍‌ବକ୍‌ତା ଲେକ୍‌ଲା ଆଚେ, ");
INSERT INTO dso_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ମାପ୍‌ରୁ କଇଲାନି, ସରଗ୍‌ ମର୍‌ ବସ୍‌ବା ଜାଗା ଦର୍‌ତନି ଅଇଲାନି ମର୍‌ ପାଦର୍‌ ପିଡା । ତମେ ମର୍‌ପାଇ କେନ୍ତାରି ଗର୍‌ ତିଆର୍‌ କର୍‌ସା ? ମୁଇ ପୁଣ୍ଡ୍‌ବାକେ କନ୍ତି ଜାଗା ଆଚେ କି ? ");
INSERT INTO dso_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","“ମୁଇ ନିଜେ କାଇ ଏ ସବୁ ବିସଇ ତିଆର୍‌ କରି ନାଇ କି ?” ");
INSERT INTO dso_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ତିପାନ୍‌ ଆରି କଇଲା, “ତମେ ବିଲ୍‌କୁଲ୍‌ କାତା ନ ମାନ୍‌ବା ଲକ୍‌ମନ୍‌ ।” ତମର୍‌ ମନ୍‌ ଡାଟ୍‌ ଅଇଗାଲା ଆଚେ । ମାପ୍‌ରୁର୍‌ ବାକିଅର୍‌ପାଇ ପୁରାପୁରୁନ୍‍ ବଇରା ଅଇଆଚାସ୍‌ । ତମେ ସମାନ୍‌ ତମର୍‌ ଆନିଦାଦିମନର୍‌ ପାରା । ସବୁବେଲେ ସୁକଲ୍‌ ଆତ୍‌ମାକେ ବିରୁଦ୍‌ କଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ତମର୍‌ ଆନିଦାଦିମନ୍‌ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ନ ସାଦିକରି ଚାଡିରଇଲାଇ କି ? ମସିଅ ଆଇସି ବଲି କେତେ କେତେ ବରସ୍‌ ଆଗ୍‌ତୁ ଜାନାଇବା ପର୍‌ମେସରର୍‌ କାତାଜାନାଉମନ୍‌କେ ମରାଇଲାଇ । ଏବେ ତମେ ତାକେ ବିସ୍‌ବାସେ ବିସ୍‌ ଦେଲାପାରା କରି ମରାଇଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ତମେ ସରଗର୍‌ ଦୁତ୍‌ମନ୍‌ ଜାନାଇରଇବା ରିତିନିତି ଦାରିଆଚାସ୍‌ । ମାତର୍‌ ସେଟା ମାନାସ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ବଡ୍‌ ସବାର୍‌ ଲକ୍‌ମନ୍‌ ତିପାନ୍‌ କାତା ଅଇବାଟା ସୁନିକରି ବେସି ରିସା ଅଇଗାଲାଇ ଆରି ରିସାର୍‌ ମାଡେ ଦାତ୍‌ କାତ୍‌ରି ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ମାତର୍‌ ତିପାନ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇ ସରଗ୍‌ ବାଟେ ମୁ କଲା । ଆରି ପର୍‌ମେସରର୍‌ ମଇମା ଆରି ଜିସୁ ତାର୍‌ ଉଜାବାଟେ ଟିଆଅଇରଇବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ତିପାନ୍‌ କଇଲା, “ଏଦେ ଦେକା ! ସରଗ୍‌ ଉଗାଡି ଅଇବାଟା ଆରି ନର୍‌ପିଲା ପର୍‌ମେସରର୍‌ ଉଜାବାଟେ ଟିଆ ଅଇରଇବାଟା ଦେକ୍‌ଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ବଡ୍‌ ସବାର୍‌ ଲକ୍‌ମନ୍‌ ସେ କାତା ସୁନିକରି ଆତ୍‌ ସଙ୍ଗ୍‍ କାନେ ଚୁଟିଅଇଦେଲାଇ, ଆରି ବେସି ଆଉଲିଅଇଲାଇ । ତାର୍‌ପଚେ ସବୁଲକ୍‌ ଗଟେକ୍‌ ଅଇକରି ତିପାନର୍‌ ବାଟେ ଉଦ୍‌ଲି ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ତାକେ ନଅରର୍‌ ବାଇରେ ଜିକିନେଇକରି ତାର୍‌ ଉପ୍‌ରେ ପାକ୍‌ନା ସଙ୍ଗ୍‍ ମାର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ସାକି ଦେଉମନ୍‌ ତିପାନ୍‌ ପିନ୍ଦିରଇଲା ବସ୍‌ତର୍‌ ସାଉଲ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡାକେ ଜିମାଦେଇ ଚାଡି ଜାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ସେମନ୍‌ ତିପାନର୍‌ ଉପ୍‌ରେ ପାକ୍‌ନା ମାର୍‌ବା ବେଲେ ସେ ମାପ୍‌ରୁକେ ପାର୍‌ତନା କରି କଇଲା, “ମାପ୍‌ରୁ ଜିସୁ, ମର୍‌ ଆତ୍‌ମାକେ ସଙ୍ଗୁଆ !” ");
INSERT INTO dso_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ତିପାନ୍‌ ମାଣ୍ଡିକୁଟା ଦେଇ ଆକ୍‌ମାରି କଇଲା, “ମାପ୍‌ରୁ, ଏମନର୍‌ ବିରଦେ ଏ ପାପ୍‌ ଆରି ଏତାଆ ନାଇ କି ଡଣ୍ଡ୍‌ ଦିଆସ୍‌ନାଇ ।” ଏତ୍‌କି କଇଲା ଦାପ୍‌ରେ ତାର୍‌ ଜିବନ୍‌ ଚାଡିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ସାଉଲ୍‌ ତିପାନର୍‌ ମରନେ ରାଜିଅଇକରି ତେଇ ରଇଲା । ସେ ଦିନେଅନି ଜିରୁସାଲାମେ ରଇବା ମଣ୍ଡଲିମନ୍‌କେ ଲକ୍‌ମନ୍‌ ଜବର୍‌ ତାଡ୍‌ନା ଦେବାର୍‌ ଆରାମ୍‌ କଲାଇ । ସେଟାର୍‌ପାଇ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ତେଇରଇଲାଇ ଆରି ବିନ୍‌ ବିସ୍‌ବାସିମନ୍‌ ଜିବନ୍‌ ଆତେଦାରି ଜିଉଦା ଆରି ସମିରଣ୍‌ ଜାଗାଇ ପାଲାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ପର୍‌ମେସର୍‌କେ ନାମ୍‌ବା କେତେକ୍‌ ଲକ୍‌ ଆକ୍‌ମାରି କାନ୍ଦିକରି ତିପାନର୍‌ ମଲା ଗାଗଡ୍‌ ନେଇ ସମାଦି କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ମାତର୍‌ ସାଉଲ୍‌ ମଣ୍ଡଲିକେ କୁରୁପ୍‌ନାସ୍‌ କର୍‌ବାକେ ଚେସ୍‌ଟା କଲା । ସେ ଗରେ ଗରେ ଜାଇ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ମୁନୁସ୍‌ ପିଲା ଆରି ମାଇଜି ଟକିମନ୍‌ ସବୁକେ ଜିକି ଆନି ବନ୍ଦି ଗରେ ପୁରାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ଜିରୁସାଲମେଅନି ପାଲାଇରଇବା ବିସ୍‌ବାସିମନ୍‌ ଗୁଲାଇବାଟେ ଜାଇ ସୁବ୍‌କବର୍‌ ଜାନାଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ସେମନର୍‌ ବିତ୍‌ରେଅନି ପିଲିପ୍‌ ବଲି ଗଟେକ୍‌ ଲକ୍‌ ସମିରଣର୍‌ ମୁକିଅ ନଅରେ ଜାଇ, ତେଇ ରଇବା ଲକ୍‌ମନ୍‌କେ ମସିଅ କଇରଇବା କାତା ଜାନାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ପିଲିପ୍‌ କଇବା କାତା ସୁନି ଆରି ସେ କରିରଇବା କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ସବୁ ଦେକି ଲକ୍‌ମନ୍‌ ତାକେ ଅଦିକ୍‌ ମନ୍‌ଦିଆନ୍‌ ଦେଇ ସୁନ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","କେତେ କେତେ ଲକ୍‌ମନର୍‌ ଟାନେଅନି ଡୁମାମନ୍‌ କିର୍‌କିରି କରି ବାରଇ ଗାଲାଇ । କେତେ କେତେ ଚେରେଙ୍ଗ୍‌ ରଗି ଆରି ଆତ୍‌ ଗଡ୍‌ ନ ଆଇବାଟାମନ୍‌ ନିକ ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ଏଟାର୍‌ ପାଇ ସେ ନଅର୍‌ ସାଇସାର୍‌ଦା ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ସମରିଆ ଜାଗାଇ ସିମନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‌ ଜନ୍ତର୍‌ ମନ୍ତର୍‌ ବିଦିଆ କରିକରି ତେଇର୍‌ ଲକ୍‌ମନ୍‌କେ କାବା କରାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ସେ, ମୁଇ ନିଜେ ଗଟେକ୍‌ ବଡ୍‌ ଲକ୍‌ ବଲାଇଅଇତେରଇଲା । ଆରି ସେ ନଅରେ ରଇବା ସାନ୍‌ ବଡ୍‌ ସବୁ ତାକେ ମାନିରଇଲାଇ । ପର୍‌ମେସରର୍‌ ଜନ୍‌ ବପୁ ମଆନ୍‌ ସେ ବପୁ ଏଟା ଆକା ବଲି ଲକ୍‌ମନ୍‌ କଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ବେସି ବରସ୍‌ ଦାରି ତାର୍‌ ଗୁନି ବିଦିଆର୍‌ ବପୁ ସଙ୍ଗ୍‍ ତେଇର୍‌ ଲକ୍‌ମନ୍‌କେ କାବା କରାଇତେରଇଲା । ସେଟାର୍‌ପାଇ ଗୁଲାଇ ସମିରଣିୟ ଲକ୍‌ମନ୍‌ ତାକେ ମାନିକରି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ମାତର୍‌ ପିଲିପର୍‌ ଟାନେଅନି ପର୍‌ମେସରର୍‌ ରାଇଜ ଆରି ଜିସୁର୍‌ ବିସଇ ସୁନ୍‌ଲାଇ । ସୁନିକରି ତେଇର୍‌ ଲକ୍‌ମନ୍‌ ମାପ୍‌ରୁକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ଆରି ସେ ଜାଗାର୍‌ ବିସ୍‌ବାସ୍‌ କଲା ମନସ୍‌ ପିଲା ଆରି ମାଇଜିଟକିକେ ପିଲିପ୍‌ ଡୁବନ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ସିମନ୍‌ ନିଜେ ପିଲିପ୍‌ ଜାନାଇରଇବା ମାପ୍‌ରୁର୍‌ ବାକିଅ ସୁନି ବିସ୍‌ବାସ୍‌ କଲା । ଆରି ପିଲିପ୍‌ ତାକେ ଡୁବନ୍‌ ଦେଲା । ସେ ପିଲିପର୍‌ ସଙ୍ଗ୍‍ ସବୁଜାଗାଇ ଜିବାର୍‌ ଦାର୍‌ଲା । ପିଲିପ୍‌ କରିରଇବା କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ଆରି ଚିନ୍‌ମନ୍‌ ଦେକିକରି ସେ କାବା ଅଇଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ସମରିଆର୍‌ ଲକ୍‌ମନ୍‌ ପର୍‌ମେସରର୍‌ ବାକିଅ ବିସ୍‌ବାସ୍‌ କଲାଇ ଆଚତ୍‌ ବଲି ଜିରୁସାଲାମ୍‌ ରଇବା ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ସୁନ୍‌ଲାଇ । ପିତର୍‌ ଆରି ଜଅନ୍‌କେ ସେମନର୍‌ ଲଗେ ପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ସେମନ୍‌ ତେଇ କେଟ୍‌ଲା ପଚେ ସମିରଣର୍‌ ବିସ୍‌ବାସିମନ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମା ପାଇବାକେ, ପାର୍‌ତନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","କାଇକେ ବଇଲେ ସେଡ୍‌କିବେଲ୍‌ ଜାକ କାର୍‌ ଉପ୍‌ରେ ସୁକଲ୍‌ ଆତ୍‌ମା ଉତ୍‌ରି ନ ରଇଲା । ସେମନ୍‌କେ ଜିସୁକିରିସ୍‌ଟର୍‌ ନାଉଁଦାରି ଅବ୍‌କାସେ ଡୁବନ୍‌ ଦେଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ପିତର୍‌ ଆରି ଜଅନ୍‌ ସେମନର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇଲା ଦାପ୍‌ରେ ସେମନ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମା ପାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ବିସ୍‌ବାସିମନର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇଲାକେ ସୁକଲ୍‌ଆତ୍‌ମା ପାଇଲାଟା ଦେକି, ସିମନ୍‌, ପିତର୍‌ ଆରି ଜଅନ୍‌କେ ଡାବୁ ଜାଚ୍‌ଲା ଆରି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ମୁଇ ବିନ୍‌ ଲକର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇଲେ, ସେମନ୍‌ ଜେନ୍ତି ସୁକଲ୍‌ ଆତ୍‌ମା ପାଇପାର୍‌ବାଇ, ସେଟାର୍‌ ପାଇ ମକେ ସେ ବପୁ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ମାତର୍‌ ପିତର୍‌ ତାକେ କଇଲା, “ତର୍‌ ଡାବୁ ତର୍‌ ସଙ୍ଗ୍‍ ନସ୍‌ଟ ଅ । ତର୍‌ ସଙ୍ଗ୍‍ ତର୍‌ ଡାବୁ ମିସା ନର୍‌କେ ଜାଅ । କାଇକେବଇଲେ ପର୍‌ମେସରର୍‌ ଦାନ୍‌ ଡାବୁସଙ୍ଗ୍‍ ଗେନ୍‌ବି ବଲି ବାବ୍‌ଲୁସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ଆମର୍‌ କାମ୍‌ଟାନେ ତର୍‌ କାଇମିସା ବାଗ୍‌ ନାଇ, କାଇକେବଇଲେ ପର୍‌ମେସର୍‌ ଦେକ୍‌ବା ଇସାବେ ତର୍‌ ମନ୍‌ ନିକ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ସେଟାର୍‌ ପାଇ ତମର୍‌ ଏ କରାପ୍‌ ବାବ୍‌ନାର୍‌ ପାଇ ମନ୍‌ ବାଦ୍‌ଲାଆ । ଏନ୍ତାରି ବିସଇ ଚିନ୍ତାକଲାର୍‌ ପାଇ ମାପ୍‌ରୁ ଜେନ୍ତାରି କେମା ଦେଇସି, ତାର୍‌ ଲାଗି, ମାପ୍‌ରୁକେ ପାର୍‌ତନା କର୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","କାଇକେ ବଇଲେ ମୁଇ ଦେକ୍‌ଲିନି ଜେ ତର୍‌ ମନ୍‌ ଆଁକାରେ ବର୍‌ତି ଅଇଆଚେ । ତୁଇ ପାପର୍‌ ବନ୍ଦନେ ବନ୍ଦିଅଇ ଆଚୁସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ସିମନ୍‌ ସେମନ୍‌କେ କଇଲା, “ତମେ ଜାଇଟା ସବୁ କଇଲାସ୍‌ ସେଟା ଜେନ୍ତି ମର୍‌ ଉପ୍‌ରେ ନ ଗଟ । ମୁଇ ତମ୍‌କେ ବାବୁଜିଆ କଲିନି ମର୍‌ପାଇ ମାପ୍‌ରୁକେ ପାର୍‌ତନା କରା ।” ");
INSERT INTO dso_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ନିଜର୍‌ ଜିବନେ ଅଇରଇବା ବିସଇର୍‌ ସାକି ଆରି ମାପ୍‌ରୁର୍‌ ସୁବ୍‌ କବର୍‌ କଇସାରାଇଲା ପଚେ ପିତର୍‌ ଆରି ଜଅନ୍‌ ଜିରୁସାଲାମେ ବାଅଡ୍‌ଲାଇ । ବାଅଡ୍‌ବା ବାଟେ ସେମନ୍‌ ସମିରଣର୍‌ ବେସି ଗାଉଁମନ୍‌କେ ସୁବ୍‌କବର୍‌ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ପର୍‌ମେସରର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ପିଲିପ୍‌କେ କଇଲା, “ତିଆର୍‌ ଅ, ଆରି ଦକିଣ୍‌ ଦିଗେ ଜିରୁସାଲମେଅନି ଗାଜା ବଲି ଗଟେକ୍‌ ଜାଗାଇ ଜିବାବାଟେ ଜା । ଆଜିକାଲି ଏବାଟେ ଆରି ଲକ୍‌ମନ୍‌ ଆସ୍‌ ଜା କରତ୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ପିଲିପ୍‌ ତିଆର୍‌ ଅଇ ସେବାଟେ ଗାଲା । ଏଦେ ଦେକା ! ଇତିଅପିଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ! ସେ ଗଟେକ୍‌ ବେଜୁ ରଇଲା । ସେ ଜିରୁସାଲମେ ପାର୍‌ତନା କର୍‌ବାକେ ଆସିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ସେ ଗଟେକ୍‌ ମୁକିଅ ଆରି ଇତିଅପିଆ ରାନିର୍‌ ବାଣ୍ଡାର୍‌ଗରିଆ ରଇଲା । ସେ ପର୍‌ମେସର୍‌କେ ଉପାସନା କର୍‌ବାକେ ଜିରୁସାଲେମ୍‌ ଜାଇରଇଲା । ତାର୍‌ ରତେ ବସି ଗରେ ବାଉଡି ଆଇତେରଇଲା । ବସିକରି ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ବଇଟାନେଅନି ଆଉଲି ଅଇ ପଡ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ସୁକଲ୍‌ଆତ୍‌ମା ପିଲିପ୍‌କେ କଇଲା, “ସେ ରତେ ଜା ଆରି ସେ ଲକର୍‌ ଲଗେ ର ।” ");
INSERT INTO dso_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ପିଲିପ୍‌ ପାଲାଇ ପାଲାଇ ଗାଲା ଆରି ସେ ଲକ୍‌ ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ବଇ ପଡ୍‌ବାଟା ସୁନ୍‌ଲା । ସେ ତାକେ ପାଚାର୍‌ଲା “ତୁଇ ଜାଇଟା ପଡ୍‌ଲୁସ୍‌ନି, ସେଟା ବୁଜିପାର୍‌ଲୁସ୍‌ନିକି ?” ");
INSERT INTO dso_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ସେ ବାଣ୍ଡାର୍‌ ଗରିଆ କଇଲା, “କେ ମିସା ଗଟେକ୍‌ ଲକ୍‌ ବୁଜାଇ ନ ଦେଲେ ମୁଇ କେନ୍ତି ବୁଜିପାର୍‌ବି ?” ତାର୍‌ ସଙ୍ଗ୍‍ ରତେ ବସ୍‌ବାକେ ସେ ପିଲିପ୍‌କେ ଡାକ୍‌ଲା । ପିଲିପ୍‌ ଜାଇ ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ଦରମ୍‌ ସାସ୍‌ତରର୍‌ ଏ ପଦ୍‌ ପଡ୍‌ତେ ରଇଲା, “ମରାଇବାକେ ନେବା ମେଣ୍ଡାପାରା, ଲକ୍‌ମନ୍‌ ତାକେ ଡାକିନେଲାଇ, ଗଟେକ୍‌ ମେଣ୍ଡାର୍‌ ବାଲ୍‌ କାଟ୍‌ବା ବେଲେ ଜେନ୍ତି ସେ ଚିମ୍‌ରାଇଅଇରଇସି, ସେନ୍ତାରି ସେ ପଦେକ୍‌ ମିସା କାତା କଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ଲକ୍‌ମନ୍‌ ନିନ୍ଦା କଲାବେଲେ ତାକେ ନିଆଇ ମିଲେ ନାଇ ତାର୍‌ କୁଟୁମର୍‌ ଲକର୍‌ ବିସଇ, କେ କଇ ନାପାରତ୍‌, କାଇକେବଇଲେ ମଚ୍‌ପୁରେ ତାର୍‌ ଜିବନ୍‌ ସାରିଗାଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ବାଣ୍ଡାର୍‌ଗରିଆ ପିଲିପ୍‌କେ ପାଚାର୍‌ଲା, “ମୁଇ ତକେ ଗୁଆରି କଲିନି । ବବିସତ୍‌ବକ୍‌ତା କାର୍‌ ବିସଇ କଇଲାନି, ମକେ କୁଆ । ତାର୍‌ ନିଜର୍‌ ବିସଇ କି ଆରି କାର୍‌ ବିସଇ ?” ");
INSERT INTO dso_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ପିଲିପ୍‌ ଦରମ୍‌ ସାସ୍‌ତରର୍‌ ଏ ପଦେଅନି ଆରାମ୍‌ କରି ଜିସୁର୍‌ ବିସଇର୍‌ ସୁବ୍‌ କବର୍‌ ତାକେ ଜାନାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ସେମନ୍‌ ଜାଉ ଜାଉ ଗଟେକ୍‌ ବନ୍ଦ୍‌ ଲଗେ କେଟ୍‌ଲାଇ । ସେ ବାଣ୍ଡାର୍‌ଗରିଆ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“ଇତି ପାନି ଆଚେ, କାଇ ଅସୁବିଦା ନ ରଇଲେ ମକେ ଡୁବନ୍‌ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ସେ ଲକ୍‌ ରତ୍‌ ତେବାଇବାକେ ତିଆର୍‌ଲା । ପିଲିପ୍‌ ଆରି ସେ, ପାନି ବିତ୍‌ରେ ଗାଲାଇ ଆରି ପିଲିପ୍‌ ତାକେ ପାନିତେଇ ଡୁବନ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ସେମନ୍‌ ପାନିତେଇଅନି ବାରଇ ଆଇଲା ପଚେ, ମାପ୍‌ରୁର୍‌ ଆତ୍‌ମା ପିଲିପ୍‌କେ ଆରିଗଟେକ୍‌ ଜାଗାଇ ମାୟା କରି ଦେଲା, ସେ ଲକ୍‌ ପିଲିପ୍‌କେ ଆରି କେବେ ଦେକି ନାପାର୍‌ଲା, ମାତର୍‌ ସାର୍‌ଦାଇ ପୁରୁନ୍‌ ଅଇ ତାର୍‌ ବାଟେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ଚନେକ୍‌ ଗାଲା ପଚେ ପିଲିପ୍‌ ଦେକ୍‌ଲାଜେ ସେ ଅସଦର୍‌ ବଲି ଗଟେକ୍‌ ଜାଗାଇ କେଟିଆଚେ । ତେଇଅନି ସେ କାଇସେରିଆଇ ଗାଲା ଆରି ବାଟେ ରଇବା ସଅର୍‌ମନ୍‌କେ ସୁବ୍‌ କବର୍‌ ଜାନାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ସେ ସବୁ ଗଟ୍‌ବା ବେଲେ, ସାଉଲ୍‌ ମାପ୍‌ରୁର୍‌ ସିସ୍‌ମନ୍‌କେ ମରାଇଦେବି ବଲି ଦମ୍‌କାଇତେ ରଇଲା । ସେ ବଡ୍‌ ପୁଜାରିର୍‌ ଲଗେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ଜାଇକରି ଦାମାସ୍‌କାସେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ଦେବାକେ ଅଦିକାରର୍‌ ଚିଟି ମାଙ୍ଗ୍‌ଲା । ଦାମାସ୍‌କାସେ ଜନ୍‌ ମାଇଜି ଆରି ମୁନୁସ୍‌ମନ୍‌ ମାପ୍‌ରୁର୍‌ ବାଟେ ଆଇଲାଇ ଆଚତ୍‍, ସେମନ୍‌କେ ବନ୍ଦିକରି ଡଣ୍ଡ୍‌ ଦେବାକେ, ଜିରୁସାଲମର୍‌ ଜିଉଦି ନେତାମନର୍‌ଟାନେ ଆନିଅଇସି । ବାନ୍ଦିକରି ଜିରୁସାଲମେ ଆନ୍‌ବାକେ ସାଉଲ୍‌କେ ଏ ଚିଟି ଅଦିକାର୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ସାଉଲ୍‌ ଦାମାସ୍‌କସ୍‌ ନଅର୍‌ ଲଗାଲଗି ଅଇବା ବେଲେ, ଅଟାତ୍‌ ବାଦ୍‌ଲେଅନି ଗଟେକ୍‌ ଉଜଲ୍‌ ସାଉଲର୍‌ ଚାରିବେଡ୍‌ତି ଜଗ୍‌ଜଗି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ତେଇ ସେ ତଲେ ଅଦ୍‌ରି ଗାଲା ଆରି ଗଟେକ୍‌ କଇବା କାତା ସୁନ୍‌ଲା “ଏ ସାଉଲ୍‌ ତୁଇ ମକେ କାଇକେ ସାଦ୍‌ଲୁସ୍‌ନି ?” ");
INSERT INTO dso_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ସେ କଇଲା, “ତମେ କେ ମାପ୍‌ରୁ ?” “ତୁଇ ଜାକେ ସାଦ୍‌ଲୁସ୍‌ନି, ସେ ଜିସୁ ମୁଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ଏବେ ଉଟ୍‌, ନଅରେ ଜା, କାଇଟା କର୍‌ବାକେ ଅଇସି, ତେଇ ତକେ ଜାନାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ସାଉଲର୍‌ ସଙ୍ଗ୍‍ ଜିବା ଲକ୍‌ମନ୍‌ କାବାଅଇଜାଇ ତେବିଦେଲାଇ, ତାକର୍‌ ଟଣ୍ଡେଅନି ପଦେକ୍‌ କାତା ବାରଏ ନାଇ । କଇବା ସବଦ୍‌ ସେମନ୍‌ ସୁନ୍‌ଲାଇ, ମାତର୍‌ କାକେ ଦେକି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ସାଉଲ୍‌ ଉଟି ଆଁକି ଦେକ୍‌ଲା ମାତର୍‌ ତାକେ କାଇଟା ଡିସେ ନାଇ । ତେବେ ତାର୍‌ ସଙ୍ଗର୍‌ ଲକ୍‌ମନ୍‌ ଆତେ ଦାରି ଦାମାସ୍‌କସ୍‌ ଡାକିନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ତିନ୍‌ଦିନ୍‌ ଜାକ ସେ କାଇଟା ଦେକି ନାପାର୍‌ଲା ଆରି ତିନ୍‌ଦିନ୍‌ ଜାକ କାଏ ନାଇ କି ପିଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦାମାସ୍‌କସେ ଅନନିୟ ନାଉଁର୍‌ ଗଟେକ୍‌ ବିସ୍‌ବାସି ଲକ୍‌ ରଇଲା, ସେ ମାପ୍‌ରରୁ ଦର୍‌ସନ୍‌ ପାଇଲା, ମାପ୍‌ରୁ ତାକେ କଇଲା, “ଅନନିୟ !” ସେ କଇଲା, “ମୁଇ ଇତି ଆଚି ମାପ୍‌ରୁ, କୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ମାପ୍‌ରୁ କଇଲା, “ତିଆର୍‌ ଅ । ସଲକ୍‌ ନାଉଁର୍‌ ବାଟ୍‍ଦାରି ଜିଉଦାର୍‌ ଗରେ ଜା । ତେଇ ତାର୍‌ସସେଅନି ଆସି ରଇବା ସାଉଲ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ କଜ୍‌ । ସେ ପାର୍‌ତନା କଲାନି । ");
INSERT INTO dso_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ସେ ଦର୍‌ସନ୍‌ ଦେକ୍‌ଲାବେଲେ ଅନନିୟ ବଲି ଗଟେକ୍‌ ଲକ୍‌ ତାର୍‌ ଗରେ ପୁର୍‌ବାଟା ସେ ଦେକିଆଚେ, ତୁଇ ଜା ଆରି ସେ ଜେନ୍ତିକି ଆରିତରେକ୍‌ ଦେକିପାର୍‌ସି ତାର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗ ।” ");
INSERT INTO dso_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ମାତର୍‌ ଅନନିୟ କଇଲା, “ମାପ୍‌ରୁ ଏ ଲକ୍‌ ଜିରୁସାଲାମେ ତମର୍‌ ଲକ୍‌ମନ୍‌କେ ଜେତ୍‌କି ପାପ୍‌ କାମ୍‌ କଲା ଆଚେ, ସେ ବିସଇ କେତେ କେତେ ଲକ୍‌ ମକେ ଜାନାଇ ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ଆରି ସେ ଲକ୍‌ ମୁକିଅ ପୁଜାରିମନର୍‌ ଟାନେଅନି ଅଦିକାର୍‌ କାଗଜ୍‌ ନେଇକରି ଦାମାସ୍‌କାସେ, ତମ୍‌କେ ପାର୍‌ତନା କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ଦାରି ନେବାକେ ଆସିଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ମାପ୍‌ରୁ ତାକେ କଇଲା, “ଜାଆ ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନ୍‌, ତାକର୍‌ ରାଜାମନ୍‌ ଆରି ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌କେ, ମର୍‌ ନାଉଁ ଜାନାଇବାକେ ଆରି ମର୍‌ ସେବା କର୍‌ବାକେ ମୁଇ ତାକେ ବାଚ୍‌ଲି ଆଚି । ");
INSERT INTO dso_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ସେ ମର୍‌ ପାଇ ଜେତ୍‌କି ସବୁ କସ୍‌ଟ ମୁରଚ୍‌ବାର୍‌ ଆଚେ, ମୁଇ ନିଜେ ତାକେ ଜାନାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ଅନନିୟ ଗାଲା ଆରି ସାଉଲ୍‌ ରଇବା ଗରେ କେଟ୍‌ଲା । ସାଉଲ୍‌କେ ବେଟ୍‌ଅଇ ତାର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇ ତାକେ କଇଲା, “ଏ ବାଇ ସାଉଲ୍‌, ଇତି ତର୍‌ଟାନେ ଆଇବାକେ ମାପ୍‌ରୁ ଜିସୁ ମକେ ପାଟାଇଆଚେ । ତୁଇ ଇତି ଆଇବା ବାଟେ ସେସେ ତକେ ଦେକାଇଅଇଲା । ତୁଇ ଜେନ୍ତିକି ଆରି ତରେକ୍‌ ଦେକି ପାରୁସ୍‌ ଆରି ସୁକଲ୍‌ ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇପାରୁସ୍‌ । ସେଟାର୍‌ପାଇ ପର୍‌ମେସର୍‌ ମକେ ପାଟାଇଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ଅନନିୟ ଏ କାତା କଇଲା ଦାପ୍‌ରେ ଏଦେ ଦେକା ! ସାଉଲର୍‌ ଆଁକିଅନି ମାଚ୍‌ କସ୍‌ଲି ପାରାଟା କୁସ୍‌ଲି ଅଦର୍‌ଲା । ସେ ଆରି ତରେକ୍‌ ଦେକି ପାର୍‌ଲା । ସେ ଉଟ୍‌ଲା ଆରି ଅନନିୟ ତାକେ ଡୁବନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ଆରି କାଆପିଆ ଅଇ ବପୁ ଅଇଲା । ସାଉଲ୍‌ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ଦାମାସ୍‌କସେ କେତେ ଦିନ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ସେ ସିଦା ପାର୍‌ତନା କର୍‌ବା ଗର୍‌ମନ୍‌କେ ଜାଇ ଜିସୁସେ ପର୍‌ମେସରର୍‌ ପଅ ବଲି ଜାନାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ଜନ୍‌ ଲକ୍‌ମନ୍‌ ତାର୍‌ କାତା ସୁନ୍‌ଲାଇ, କାବାଅଇଜାଇକରି ପାଚାର୍‌ଲାଇ, “ଜିରୁସାଲମେ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କରି ପାର୍‌ତନା କର୍‌ବା ଲକ୍‌ମନ୍‌କେ ଜନ୍‌ଲକ୍‌ ମରାଇତେ ରଇଲା, ଏ କାଇ ସେ ଲକ୍‌ ନଏଁ କି ? ସେମନ୍‌କେ ମୁକିଅ ପୁଜାରିମନର୍‌ ଲଗେ ଦାରିନେବାକେ ସେ କାଇ ଇତି ଆସି ନ ରଇଲା କି ?” ");
INSERT INTO dso_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ମାତର୍‌ ସାଉଲ୍‌ ଦରମ୍‌ ସାସ୍‌ତରେ ଅନି, ଜିସୁ ଆକା ମସିଅ ବଲି ସତ୍‌ ଦେକାଇଲା । ଏ ବିସଇଟାନେ ତାର୍‌ କଇବା କାତା ଏତେ ବପୁ ରଇଲା ଜେ, ଦାମାସ୍‌କସେ ବାସାଅଇ ରଇବା ଜିଉଦିମନ୍‌ ତାର୍‌ କଇବା କାତାର୍‌ ଗଟେକ୍‌ ମିସା ଉତର୍‌ ଦେଇନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","କେତେଦିନ୍‌ ଗାଲା ପଚେ ଜିଉଦିମନ୍‌ ଗଟେକ୍‌ ଅଇକରି ସାଉଲ୍‌କେ ମରାଇବାକେ ପାଚ୍‌ନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ମାତର୍‌ ସାଉଲ୍‌ ସେମନର୍‌ କୁଟ୍‌ କାତା ଜାନ୍‌ଲା । ସାଉଲ୍‌କେ ମରାଇବାକେ ସେମନ୍‌ ଦିନ୍‌ ରାତି ନଅରର୍‌ ସବୁ ଦୁଆର୍‌ମନ୍‌କେ ଜାଗ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ମାତର୍‌ ଦିନେକ୍‌, ରାତିବେଲେ ସାଉଲର୍‌ ସିସ୍‌ମନ୍‌ ତାକେ ଡାଲାଇ ସାଜାଡି ନଅରର୍‌ ଚାରିବେଟ୍‌ତି ରଇବା ପାଚୁରିର୍‌ କାଣା ବାଟେ ତଲେ ଉତ୍‌ରାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ସାଉଲ୍‌ ଜିରୁସାଲାମେ ଜାଇ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ବାକେ ଚେସ୍‌ଟା କଲା । ମାତର୍‌ ସେମନ୍‌ ସାଉଲ୍‌କେ ଗଟେକ୍‌ ସିସ୍‌ ବଲି ମୁଲ୍‌କେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇ । ସବୁ ଲକ୍‌ ତାକେ ଡର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ମାତର୍‌ ପଚେ, ବର୍‌ନବା ତାକେ ପେରିତ୍‌ ସିସ୍‌ମନର୍‌ ଲଗେ ନେଲା । ଦାମାସ୍‌କସର୍‌ ବାଟେ କେନ୍ତି ସାଉଲ୍‌ ମାପ୍‌ରୁର୍‌ ଦର୍‌ସନ୍‌ ପାଇରଇଲା, ଆରି ମାପ୍‌ରୁ ତାକେ କାତା କଇରଇଲା, ଏ ସବୁ ବିସଇ ସେମନ୍‌କେ ବୁଜାଇକରି କଇଲା । ଦାମାସ୍‌କସେ ସାଉଲ୍‌ ନ ଡର୍‌ତେ କେନ୍ତାରି ଜିସୁର୍‌ ନାଉଁ ଦାରି ତାର୍‌ ବାକିଅ ଜାନାଇରଇଲା, ସେମନ୍‌କେ ଟିକି ନିକି ବୁଜାଇ କରି କଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ଆରି ସାଉଲ୍‌, ପେରିତ୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ରଇଲା ଆରି ଜିରୁସାଲମର୍‌ ଗୁଲାଇବାଟେ ଜାଇ, ନ ଡର୍‌ତେ ମାପ୍‌ରୁର୍‌ ବାକିଅ ଜାନାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ସାଉଲ୍‌ ଏ ସବୁ ବିସଇ ଗିରିକ୍‌ ବାସା କଇବା ଜିଉଦିମନର୍‌ ସଙ୍ଗ୍‍ ଦଦାପେଲା ଅଇଲା । ମାତର୍‌ ସେମନ୍‌ ସାଉଲ୍‌କେ ମରାଇବାକେ ଚେସ୍‌ଟା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ବିସ୍‌ବାସି ବାଇମନ୍‌ ଏ କାତା ଜାନିକରି ସାଉଲ୍‌କେ କାଇସରିଆ ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ ଦାରିଗାଲାଇ । ଆରି ତେଇଅନି ତାକେ ତାର୍‌ସିସ୍‌ ବଲି ବିନ୍‌ ଗଟେକ୍‌ ଜାଗାଇ ପାଟାଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଜିଉଦା, ଗାଲିଲି ଆରି ସମିରଣେ ରଇବା ମଣ୍ଡଲିମନର୍‌ ପାଇ ସେବେଲା ଗଟେକ୍‌ ସାନ୍ତିର୍‌ ବେଲା ରଇଲା । ସୁକଲ୍‌ ଆତ୍‌ମା ସେମନର୍‌ ସଙ୍ଗ୍‍ ରଇଲା ଜେ ଲକ୍‌ମନ୍‌ ଦିନ୍‌କେଦିନ୍‌ ଅଦିକ୍‌ ଅଦିକ୍‌ ଅଇ ଡାଟ୍‌ ଅଇଲାଇ । ଜିସୁକେ ବିସ୍‌ବାସ୍‌କର୍‌ବା ଲକ୍‌ମନ୍‌, ମାପ୍‌ରୁକେ ଡରିକରି ଆରି ମାନିକରି ଜିଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ପିତର୍‌ ବିନ୍‌ ବିନ୍‌ ଜାଗାଇ ବୁଲି ବୁଲି ତରେକ୍‌ ଲୁଦାଇ ବାସାଅଇରଇବା, ମାପ୍‌ରୁର୍‌ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ବାକେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ତେଇ ଏନିୟ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ସେ ବେଟ୍‌ ଅଇଲା, ଏନିୟକେ ଚେରେଙ୍ଗ୍‌ ବାତ୍‌ ଦାରି ଆଟ୍‌ ବରସ୍‌ ଅଇଜାଇରଇଲା । ସଇଲାଟାନେଅନି ଉଟି ନାପାର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପିତର୍‌ ତାକେ କଇଲା, “ଏନିୟ ଜିସୁ ମାପ୍‌ରୁ ତକେ ନିକ କରିଆଚେ । ଉଟ୍‌ ଆରି ତର୍‌ ଅଚ୍‌ନା ସାଜାଡ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","କଇଲା ଦାପ୍‌ରେ ଏନିୟ ଉଟି ଟିଆଅଇଲା । ଏଟା ଦେକି କରି ଲୁଦା ଆରି ସାରନେ ବାସା ଅଇରଇବା ସବୁ ଲକ୍‌ମନ୍‌ ମାପ୍‌ରୁର୍‌ ବାଟେ ଆଇବାକେ ମନ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଜପାଇ, ଟାବିତା ନାଉଁର୍‌ ଗଟେକ୍‌ ବିସ୍‌ବାସି ମାଇଜି ବାସା ଅଇରଇଲା । ତାର୍‌ ଗିରିକ୍‌ ନାଉଁ, ଦାର୍‌କାସ୍‌ । ତାର୍‌ ଅରତ୍‌ କଟ୍‌ରା । ସେ ସବୁବେଲା ସତ୍‌ କାମ୍‌ କରି, ରଗି ଦୁକିମନର୍‌ ସେବା କର୍‌ତେ ରଇଲା । ସେବେଲେ ସେ ରଗ୍‌ବେମାର୍‌ ଅଇ ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ତାର୍‌ ଲକ୍‌ବାକ୍‌ମନ୍‌ ଟାବିତାର୍‌ ମଲାମଡ୍‌ ପାନିଦୁଆଇଲାଇ ଆରି ଲୁଗା ସଙ୍ଗ୍‍ ଗୁଡିଆଇ ଉପର୍‌ ତାଲାର୍‌ ବାକ୍‌ରାଇ ସୁଆଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଜପା ଜାଗା ଲୁଦାଇଅନି ଦୁରିକେ ନ ରଇଲା । ପିତର୍‌ ଲୁଦାଇ ଆଚେ ବଲି ସୁନିକରି ଜପାଇ ରଇବା ବିସ୍‌ବାସିମନ୍‌ ଦୁଇ ଲକ୍‌କେ ପିତରର୍‌ ଲଗେ କଇ ପାଟାଇଲାଇ । “ଅଲସମ୍‌ ନ କରି, ଦାପେ ଆମର୍‌ ଲଗେ ଚନେକ୍‌ ଆସା ।” ");
INSERT INTO dso_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ପିତର୍‌ ତିଆର୍‌ ଅଇକରି ସେମନର୍‌ ସଙ୍ଗ୍‍ ଗାଲା । ତେଇ ସେ କେଟ୍‌ଲା ଦାପ୍‌ରେ ଲକ୍‌ମନ୍‌ ତାକେ ଉପର୍‌ ତାଲାର୍‌ ବାକ୍‌ରାଇ ଡାକି ନେଲାଇ । ରାଣ୍ଡି ମାଇଜିମନ୍‌ ଚାରିବେଡ୍‌ତି ଅଇକରି କାନ୍ଦି କାନ୍ଦି ଦାର୍‌କାସ୍‌ ଜିବନ୍‌ ରଇଲାବେଲେ ସିଲାଇ ରଇବା ବସ୍‌ତର୍‌ ଆରି ଲୁଗାମନ୍‌ ସବୁ ପିତର୍‌କେ ଦେକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ପିତର୍‌ ବାକ୍‌ରାଇଅନି ସବୁକେ ବାର୍‌କରାଇ ଦେଲା ଆରି ମାଣ୍ଡିକୁଟା ଦେଇ ପାର୍‌ତନା କଲା । ତାର୍‌ପଚେ ଦର୍‌କାସର୍‌ ମଲା ଗାଗଡର୍‌ବାଟେ ଦେକିକରି କଇଲା, “ଟାବିତା ଉଟ୍‌ !” ଏଦେ ଦେକା ! ଦର୍‌କାସ୍‌ ଆଁକି ଦେକ୍‌ଲା ଆରି ପିତର୍‌କେ ଦେକି ଉଟିକରି ବସ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ପିତର୍‌ ଆତ୍‌ ଲାମାଇ ତାକେ ଉଟାଇଲା । ତାର୍‌ ପଚେ ତେଇ ରୁଣ୍ଡି ରଇଲା ସବୁ ବିସ୍‌ବାସି ଆରି ରାଣ୍ଡି ମାଇଜିମନ୍‌କେ ଡାକି ଦର୍‌କାସ୍‌କେ ସର୍‌ପିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ଏ କବର୍‌ ଜପାର୍‌ ଗୁଲାଇ ବାଟର୍‌ ଲକ୍‌ ସୁନ୍‌ଲାଇ ଆରି କେତେ କେତେ ଲକ୍‌ମନ୍‌ ମାପ୍‌ରୁକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ପିତର୍‌ ବେସି ଦିନ୍‌ ଜପାଇ ସିମନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌, ଜେକି ପସୁମନର୍‌ ଚାମ୍‌ ସଙ୍ଗ୍‍ କାଇକାଇ ଜିନିସ୍‌ମନ୍‌ ତିଆର୍‌ କରି ବଁଚ୍‌ତେ ରଇଲା, ତାର୍‌ ଗରେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାଇସରିଆ ଅନି କର୍‌ନିଲିଅ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ରଇଲା । ସେ, ଇଟାଲି ଅନି ଆଇବା ଗଟେକ୍‌ ବଡ୍‌ ଦଲର୍‌ ରମିୟ ସନିଅମନର୍‌, ନେତା ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ସେ ଗଟେକ୍‌ ଦରମ୍‌ ଲକ୍‌ ରଇଲା । ସେ ଆରି ତାକର୍‌ ଗରର୍‌ ଲକ୍‌ମନ୍‌ ସବୁ ପର୍‌ମେସର୍‌କେ ଉପାସନା କର୍‌ତେ ରଇଲାଇ । ସେ ରକିଦୁକି ଜିଉଦିମନ୍‌କେ ବେସି ଉପ୍‌କାର୍‌ କର୍‌ତେ ରଇଲା । ଆରି ଜେଡେବେଲ୍‌ ମିସା ପର୍‌ମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ଦିନେକ୍‌ ଆଡ୍‌ବେଲାର୍‌ ତିନ୍‌ଟା ବେଲେ କର୍‌ନିଲିଅ ପାର୍‌ତନା କଲାବେଲେ, ଗଟେକ୍‍ ଦର୍‌ସନ୍‌ ପାଇଲା । ତେଇ ପର୍‌ମେସରର୍‌ ଦୁତ୍‌ ଆସି ତାକେ “କର୍‌ନିଲିଅ !” ବଲି ଡାକ୍‌ବାଟା ନିକ ସଙ୍ଗ୍‍ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ସେ ଡରିକରି ସରଗର୍‌ ଦୁତ୍‌ବାଟେ ଦେକିକରି କଇଲା, “କାଇଟା ବଲି କଇଲୁସ୍‌ନି ମାପ୍‌ରୁ ?” ସରଗର୍‌ ଦୁତ୍‌ କଇଲା, “ପର୍‌ମେସର୍‌ ତର୍‌ ପାର୍‌ତନା ଆରି ଦୁକିରକିମନ୍‌କେ ଦାନ୍‌ କର୍‌ବାଟା ଦେକି ସାର୍‌ଦା ଅଇଲା । ଆର୍‌ ବାଦୁଲେ କାଇଟାଆଲେ ଦେବାକେ ସେ ମନ୍‌ କଲାନି । ");
INSERT INTO dso_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ଏବେ ସିମନ୍‌ ପିତର୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ଇତି ଡାକି ଆନ୍‌ବାକେ, ଜପାଇ ଲକ୍‌ ପାଟାଆ । ");
INSERT INTO dso_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ସେ ସମ୍‌ଦୁର୍‌ କଣ୍ଡି ବାସାଅଇରଇବା ସିମନ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌, ପସୁମନର୍‌ ଚାମ୍‌ ସଙ୍ଗ୍‍ କାଇକାଇଟା ତିଆର୍‌ କର୍‌ବା ଲକର୍‌ ଗରେ ରଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ଏତ୍‌କି କାତା କଇ ସରଗର୍‌ ଦୁତ୍‌ ଉଟିଗାଲା । କର୍‌ନିଲିଅ ତାକର୍‌ ଗରର୍‌ ଦୁଇଟା ଗତିଦାଙ୍ଗ୍‌ଡାକେ ଆରି ତାକେ ସେବା କର୍‌ତେରଇବା ଆରି ପର୍‌ମେସର୍‌କେ ଉପାସନା କର୍‌ତେରଇବା ଗଟେକ୍‌ ସଇନକେ ଡାକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ସେ ସେମନ୍‌କେ ଦୁତ୍‌ କଇରଇବା ସବୁ କାତା ଜାନାଇ କରି ଜପାଇ ପାଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଆଡ୍‌ବେଲାଇ ସେମନ୍‌ ଜପାର୍‌ ଲଗାଲଗି ଅଇଲାବେଲେ, ପିତର୍‌ ପାର୍‌ତନା କର୍‌ବାକେ ମେଡ୍‌ଗରର୍‌ ଚାଉନି ଉପ୍‌ରେ ଜାଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ସେ ଉପାସ୍‌ ସାରାଇକରି, କାଇଟାଆଲେ କାଇବାକେ ମନ୍‌ କଲା ଆରି କାଦି ତିଆର୍‌ ଅଇବା ବେଲାଇ ସେ ଗଟେକ୍‌ ଦର୍‌ସନ୍‌ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ଏଦେ ଦେକା ! ଆକାସ୍‌ ଉଗାଡିଅଇଲାଟା ଆରି ଗଟେକ୍‌ ବଡ୍‌ ଚାଦର୍‌ ଚାରିକନେ ବାନ୍ଦିଅଇକରି ଦର୍‌ତନି ଉପ୍‌ରେ ଉତ୍‌ରି ଆଇବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ତେଇ ଜଗତେ ରଇବା ରକାମ୍‌ ରକାମର୍‌ ଗଡ୍‌ ସଙ୍ଗ୍‍ ଇଣ୍ଡ୍‌ବା ପସୁ, ରାଙ୍ଗ୍‌ବା ଜନ୍ତ୍‌ ଆରି ଉଡ୍‌ବା ଚଡଇମନ୍‌ ! ");
INSERT INTO dso_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ଆରି ସେ ଗଟେକ୍‌ କାତା ଅଇବା ସବଦ୍‌ ସୁନ୍‌ଲା, “ପିତର୍‌ ! ଉଟ୍‌ ସେମନ୍‌କେ ମାରିକରି କାଆ !” ");
INSERT INTO dso_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ମାତର୍‌ ପିତର୍‌ କଇଲା, “ନାଇ ମାପ୍‌ରୁ, ଆମର୍‌ ଜିଉଦି ନିୟମ୍‌ ଇସାବେ ଅସୁକଲ୍‌ ବଲି କଇବା କାଇ ମାଉଁସ୍‌ ମିସା କାଇନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ସେ ସବଦ୍‌ ଆରି କଇଲା “ପର୍‌ମେସର୍‌ ଜନ୍‌ଟା ସୁକଲ୍‌ କଲାଆଚେ ସେଟା ନିଚ୍‌ବାର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ଏନ୍ତାରି ତିନ୍‌ତର୍‌ ଅଇଲା ପଚେ ଚାଦର୍‌ ସରଗ୍‌ ବାଟେ ଚଗାଇ ଦାରି ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପିତର୍‌ ଜନ୍‌ ଦର୍‌ସନ୍‌ ପାଇରଇଲା, ତାର୍‌ ଅରତ୍‌ କାଇଟା, ସେଟା ବାବି କାନାବାନା ଅଇଗାଲା । ଟିକ୍‌ ସେନ୍ତି ଅଇଲାବେଲେ, ଏଦେ ଦେକା ! କର୍‌ନିଲିଅ ପାଟାଇଲା ଲକ୍‌ମନ୍‌ ସିମନ୍‌କେ କଜି କଜି ଆସି, ତାର୍‌ ଗରର୍‌ ବାଟ୍‍ଡିଆଗଡି ଲଗେ ଟିଆଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ସେମନ୍‌ ଡାକିକରି ପାଚାର୍‌ଲାଇ, “ସିମନ୍‌ ପିତର୍‌, ନାଉଁର୍‌ ଗତିଆ ଲକ୍‌ ଇତି ଆଚେ କି ?” ");
INSERT INTO dso_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପିତର୍‌ ସେ ଦର୍‌ସନ୍‌ ବିସଇ ଚିନ୍ତା କର୍‌ତେ ରଇଲାବେଲେ ଆତ୍‌ମା ତାକେ କଇଲା, “ସୁନ୍‌ ! ତକେ ତିନ୍‌ ଲକ୍‌ କଜ୍‌ଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","“ଉଟ୍‌, ତଲେ ଜାଆ । ଏ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ଜିବାକେ ନିଚ୍‌ନାଇ, କାଇକେବଇଲେ ମୁଇ ସେମନ୍‌କେ ପାଟାଇଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ତେଇଅନି ପିତର୍‌ ସେ ଲକ୍‌ମନର୍‌ ଲଗେଜାଇ କଇଲା, “ତମେ ଜାକେ କଜ୍‌ଲାସ୍‌ନି, ସେ ଲକ୍‌ ମୁଇ, ତମେ କାଇକେ ଆସି ଆଚାସ୍‌ ?” ");
INSERT INTO dso_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ସେମନ୍‌ କଇଲାଇ, “କର୍‌ନିଲିଅ ନାଉଁର୍‌ ରମିୟ ସଇନମନର୍‌ ନେତା ଆମ୍‌କେ ପାଟାଇଆଚେ । ଜେ କି ଗଟେକ୍‌ ଦରମ୍‌ ଲକ୍‌ ଆରି ପର୍‌ମେସର୍‌କେ ନାମ୍‌ସି । ଗୁଲାଇ ଜିଉଦି ଲକ୍‌ମନ୍‌ ତାକେ ନାମ୍‌ବାଇ । ତୁଇ କଇବାଟା ସୁନ୍‌ବାକେ, ସେ ତକେ ତାର୍‌ ଗରେ ଡାକାଇଆଚେ । ଏନ୍ତାରି କର୍‌ବାକେ ପର୍‌ମେସର୍‌ ପାଟାଇଲା ଦୁତ୍‌ ତାକେ ତିଆର୍‌ଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ପିତର୍‌ ସେମନ୍‌କେ ବିତ୍‌ରେ ଡାକିନେଇକରି ସେ ରାତି ତେଇ ରଇବାକେ ଗୁଆରି କଲା । ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ସେ ଉଟି ସେମନର୍‌ ସଙ୍ଗ୍‍ ଗାଲା । ଆରି ଜପା ନାଉଁର୍‌ ଜାଗାର୍‌ କେତେଟା ବିସ୍‌ବାସି ବାଇମନ୍‌ ମିସା ସେମନର୍‌ ସଙ୍ଗ୍‍ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ଆରି ଗଟେକ୍‍ ଦିନେ ସେମନ୍‌ ସିସେରିଆଇ କେଟ୍‌ଲାଇ । ତେଇ କର୍‌ନିଲିଅ ତାର୍‌ ମଇତର୍‌ମନ୍‌କେ ଆରି କୁଟୁମର୍‌ ଲକ୍‌ମନ୍‌କେ ରୁଣ୍ଡାଇକରି ପିତର୍‌କେ ଜାଗିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତର୍‌ ଗର୍‌ ବିତ୍‌ରେ ଜିବାବେଲେ କର୍‌ନିଲିଅ ତାକେ ବେଟ୍‌ଅଇ, ତାର୍‌ ପାଦେ ଡାଣ୍ଡାସନ୍‌ ପଡି ଜୁଆର୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ପିତର୍‌ ତାକେ ଉଟାଇକରି କଇଲା, “ଟିଆ ଅ, ମୁଇ ମିସା ତର୍‌ପାରା ଗଟେକ୍‌ ମୁନୁସ୍‌ସେ ।” ");
INSERT INTO dso_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ପିତର୍‌ କର୍‌ନିଲିଅର୍‌ ସଙ୍ଗ୍‍ କାତା ଅଇ ଅଇ ଗର୍‌ ବିତ୍‌ରେ କେଟ୍‌ଲା ଆରି ତେଇ ବେସିଲକ୍‌ ରୁଣ୍ଡିରଇବାଟା ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ସେ ସେମନ୍‌କେ କଇଲା, “ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ବାଟା କି ତାକର୍‌ ଗରେ ଜିବାଟା ଆମର୍‌ ଜିଉଦି ଲକ୍‌ମନର୍‌ ବିଦି ନାଇ । ସେଟା ତମେ ନିକକରି ଜାନାସ୍‌ । ଏଲେମିସା କନ୍‌ଆଲେ ଗଟେକ୍‌ ଲକ୍‌କେ ଅସୁକଲ୍‌ ଇସାବେ ଦେକ୍‌ବାର୍‌ ନାଇ ବଲି ପରମେସର୍‌ ମକେ କଇଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ତେବେ ମକେ ଡାକାଇଲା ଦାପ୍‌ରେ କାଇଟା ନ ବାବିକରି ଆଇଲି । ମକେ କାଇକେ ଡାକାଇଲୁସ୍‌ ତେବେ ? ସେଟା ମୁଇ ଜାନ୍‌ବାକେ ମନ୍‌ କଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍‌ନିଲିଅ କଇଲା, ତିନ୍‌ଦିନ୍‌ ଆଗ୍‌ତୁ ଆଡ୍‌ବେଲାର୍‌ ତିନ୍‌ଟା ସମାନ୍‍ ଏଡ୍‌କି ବେଲାଇ, ମୁଇ ଗରେ ପାର୍‌ତନା କର୍‌ତେ ରଇଲି । ସେଡ୍‌କି ବେଲେ, ଏଦେ ଦେକା ! ଦବ୍‌ ପଚିଆ ପିନ୍ଦି ରଇବା ଗଟେକ୍‌ ଲକ୍‌ ମର୍‌ ମୁଆଟେ ଟିଆଅଇଲା, ଆରି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“କର୍‌ନିଲିଅ ! ପର୍‌ମେସର୍‌ ତର୍‌ ପାର୍‌ତନା ସୁନ୍‌ଲା ଆରି ତମେ ଦୁକିରକିକେ ସାଇଜ କର୍‌ବାଟା ଦେକି ସାର୍‌ଦା ଅଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ସିମନ୍‌ ପିତର୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌କେ ଆନ୍‌ବାକେ ଜପା ନାଉଁର୍‌ ଜାଗାଇ, ଲକ୍‌ମନ୍‌କେ ପାଟାଆ । ସେ ସମ୍‌ଦୁର୍‌ କଣ୍ଡି ବାସାଅଇରଇବା ପସୁମନର୍‌ ଚାମ୍‌ ସଙ୍ଗ୍‍ କାଇକାଇଟା ତିଆର୍‌କରୁ ସିମନର୍‌ ଗରେ ଗତିଆ ଅଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ତେବର୍‌ ପାଇ, ମୁଇ ତକେ ଦାପ୍‌ରେ ଡାକାଇଲି, ଆରି ତମେ ମର୍‌ କାତା ମାନିକରି ଆସି ଆଚାସ୍‌ । ଏବେ ଆମେ ସବୁ ଲକ୍‌ ପରମେସର୍‌ ରଇବା ଏ ଜାଗାଇ ରୁଣ୍ଡିଆଚୁ । ମାପ୍‌ରୁ ତକେ ଜନ୍‌ଟା କଇବାକେ ଆଦେସ୍‌ ଦେଲା ଆଚେ, ସେଟା ସୁନ୍‌ବାକେ ଜାଗିଆଚୁ ।” ");
INSERT INTO dso_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ସିତିଅନି ପିତର୍‌ କଇଲା, “ଏବେ ମୁଇ ବୁଜିପାର୍‌ଲିନି ଜେ ପର୍‌ମେସର୍‌ କେତେଟା ଦଲ୍‌ମନ୍‌କେସେ ଡାକ୍‌ସି, ସେନ୍ତାରି ନଏଁ, ମାତର୍‌ ସବୁକେ ସମାନ୍‌ ଇସାବେ ଡାକ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ଜନ୍‌ ଜାତିର୍‌ ଲକ୍‌ ମିସା ତାକେ ଡରିକରି, ତାର୍‌ ମୁଆଟେ ସତ୍‌କାମ୍‌ କଲେ, ମାପ୍‌ରୁ ତାକେ ଡାକ୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ଇସ୍‌ରାଏଲିଅ ମନର୍‌ ଲଗେ ପର୍‌ମେସର୍‌ ଜନ୍‌ କବର୍‌ ପାଟାଇରଇଲା, ସେଟା ତୁଇ ଜାନିଆଚୁସ୍‌ । ଜିସୁ କିରିସ୍‌ଟ ଜେ କି ସବୁର୍‌ ମାପ୍‌ରୁ, ସେ କରିରଇବା କାମେଅନି ସବୁଲକ୍‌ମନ୍‌ ସାନ୍ତିସଙ୍ଗ୍‍ ମିସ୍‌ବାଇ, ବଲି ପର୍‌ମେସର୍‌ ଆମ୍‌କେ ଜାନାଇଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ଡୁବନ୍‌ ଦେଉ ଜଅନ୍‌ ପାପ୍‌ କାମ୍‌ କର୍‌ବାଟାନେଅନି ବାଉଡ୍‌ବା ବିସଇ ଆରି ଡୁବନ୍‌ ନେବା ବିସଇ କଇଲାପଚେ, ଗାଲିଲିଅନି ଆରାମ୍‌ କରି ଗୁଲାଇ ଜିଉଦାର୍‌ ସବୁବାଟେ ଜନ୍‌ ଗଟ୍‍ନାସବୁ ଗଟ୍‌ଲା ଆଚେ, ସେଟା ତୁଇ ଜାନୁସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ନାଜରିତର୍‌ ଜିସୁର୍‌ ବିସଇ ଆରି ପରମେସର୍‌ ତାକେ କେନ୍ତି ସୁକଲ୍‌ ଆତ୍‌ମା ଆରି ବପୁ ପୁରାପୁରୁନ୍‌ ଦେଇରଇଲା, ସେଟା ଜାନୁସ୍‌ । ଆରି ଜାନିଆଚୁସ୍‌, ସେ ସବୁ ବାଟେ ଜାଇ ନିକନିକ କାମ୍‌ମନ୍‌ କରିରଇଲା । ସଇତାନର୍‌ ବାନ୍ଦନେ ରଇଲା ଲକ୍‌ମନ୍‌କେ ମୁକ୍‍ଲାଇଲା । କାଇକେବଇଲେ ପରମେସର୍‌ ତାର୍‌ ସଙ୍ଗ୍‍ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଜିସୁ ଇସ୍‌ରାଏଲ ଦେସେ ଆରି ଜିରୁସାଲାମେ ଜେତ୍‌କି ସବୁ କାମ୍‌ମନ୍‌ କଲା, ଆମେ ସବୁ ଲକ୍‌ ତାର୍‌ ସାକି ଆଚୁ । ତାର୍‌ପଚେ ତାକେ କୁର୍‌ସେ କୁଟି ମାରି, ମରାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ମାତର୍‌ ପର୍‌ମେସର୍‌ ତାକେ ତିନ୍‌ଦିନ୍‌ ଅଇଲାକେ ମଲାତେଇଅନି ଉଟାଇ ଜିବନ୍‌ କରାଇ, କେତେଲକ୍‌କେ ଦେକାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ସବୁଲକ୍‌ ତାକେ ଦେକ୍‌ବାକେ ପର୍‌ମେସର୍‌ ଦେଏନାଇ, ଅବ୍‌କା ସେ ବାଚ୍‌ଲା ସାକିମନ୍‌କେସେ । ତାକେ ଆରିତରେକ୍‌ ଜିବନ୍‌ କରାଇଲାପଚେ, ତାର୍‌ ସଙ୍ଗ୍‍ କାଆ ପିଇ ଅଇରଇଲା ଲକ୍‌ମନ୍‌ ଆମେସେ । ");
INSERT INTO dso_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ଲକ୍‌ମନର୍‌ ଲଗେ ସୁବ୍‌କବର୍‌ ଜାନାଇବାକେ ସେ ଆମ୍‌କେ ଆଦେସ୍‌ ଦେଲା । ବଁଚିରଇବା ଲକର୍‌ ଆରି ମଲା ଲକର୍‌ ବିଚାର୍‌କାରିଆ ଇସାବେ ତାକେସେ ବାଚ୍‌ଲା ଆଚେ, ଏ କାତାର୍‌ ସାକିଦେବାକେ ମିସା ସେ ଆମ୍‌କେ ଆଦେସ୍‌ ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ସବୁ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ତାର୍‌ ବିସଇନେଇ, ଏ କବର୍‌ କଇରଇଲାଇ । ଜେ ମସିଅକେ ବିସ୍‌ବାସ୍‌ କର୍‌ସି, ମସିଅ କରିରଇବା କାମର୍‌ ଲାଗି, ପର୍‌ମେସର୍‌ ତାର୍‌ ପାପ୍‌କେମା କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତର୍‌ ସିକିଆ ଦେବା ବେଲେ ଜେତେ ଲକ୍‌ ସୁନ୍‌ତେ ରଇଲାଇ, ସେ ସବୁ ଲକର୍‌ ଉପ୍‌ରେ ସୁକଲ୍‌ ଆତ୍‌ମା ଉତ୍‌ରି ଡାବିଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ଜିଉଦିନଇଲା ଲକ୍‌ମନର୍‌ ଉପ୍‌ରେ ମିସା ପରମେସରର୍‌ ସୁକଲ୍‌ ଆତ୍‌ମା ଡାବିଅଇବାଟା ଦେକି ଜପାଇଅନି ପିତର୍‌ ସଙ୍ଗ୍‍ ଆସିରଇବା ଜିଉଦି ବିସ୍‌ବାସିମନ୍‌ କାବାଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","କାଇକେବଇଲେ ସେମନ୍‌ ପରମେସର୍‌କେ ଡାକ୍‌ପୁଟା କର୍‌ବାଟା, ଆରି ବିନ୍‌ବିନ୍‌ ବାସାଇ କାତାଅଇବାଟା, ଜିଉଦି ବିସ୍‌ବାସିମନ୍‌ ସୁନ୍‌ଲାଇ । ଜପାଇଅନି ଆସିରଇବା ଜିଉଦି ବିସ୍‌ବାସିମନ୍‌କେ ପିତର୍‌ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ପର୍‌ମେସର୍‌ ଆମ୍‌କେ ଜେନ୍ତି ସୁକଲ୍‌ଆତ୍‌ମା ଦେଲାଆଚେ, ସେନ୍ତାରିସେ ଏ ଲକ୍‌ମନ୍‌କେ ମିସା ଦେଲାଆଚେ । ସେମନ୍‌କେ ଡୁବନ୍‌ ନ ନିଆ ବଲି କେ ମିସା ଅଟ୍‌କାଇପାର୍‌ସି କି ?” ");
INSERT INTO dso_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ସେଟାର୍‌ ପାଇ ପିତର୍‌ ସେମନ୍‌କେ ଜିସୁକିରିସ୍‌ଟର୍‌ ନାଉଁ ଦାରି ଡୁବନ୍‌ ଦେଲାପଚେ କର୍‌ନିଲିଅ ଆରି ତାର୍‌ ସଙ୍ଗ୍‍ ରଇବାଲକ୍‌ମନ୍‌ ତାକେ ଆରି କେତେ ଦିନ୍‌ ସେମନର୍‌ ସଙ୍ଗ୍‍ ରଇବାକେ ବାବୁଜିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌ ମିସା ପର୍‌ମେସରର୍‌ ବାକିଅ ନାମି ଆଚତ୍‌ ବଲି ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ଆରି ଜିଉଦା ରାଇଜର୍‌ ବିନ୍‌ ବିସ୍‌ବାସି ବାଇମନ୍‌ ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ପିତର୍‌ କାଇସେରିଆ ଅନି ଜିରୁସାଲାମ୍‌ ଗାଲା । ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌କେ ସୁନତ୍‌ କରୁ ବଲି କଇବା ଲକ୍‌ମନ୍‌ ତାକେ ବାକାନିକରି କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ତୁଇ ଜିଉଦି ନଇଲା ଗରେ, ଅବ୍‌କା ଗତିଆଅଇ ଜାଉସ୍‌ ନାଇ, ତେଇ କାଇଲୁସ୍‌ ମିସା ।” ");
INSERT INTO dso_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ମାତର୍‌ ମୁଲେଅନି କର୍‌ନିଲିଅକେ କାଇକାଇଟା ଗଟିରଇଲା, ସେଟା ବୁଜାଇବାକେ ପିତର୍‌ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ମୁଇ ଜପା ନାଉଁର୍‌ ନଅରେ ପାର୍‌ତନା କର୍‌ବା ବେଲେ ଗଟେକ୍‌ ଦର୍‌ସନ୍‌ ଦେକ୍‌ଲି । ଗଟେକ୍‌ ବଡେଟା ଚାଦର୍‌ ଚାରିକନେ ଡର୍‌ସଙ୍ଗ୍‍ ବାନ୍ଦି ଜୁଲାଇଅଇ ଆକାସେଅନି ଉତର୍‌ଲା ଆରି ସେଟା ମର୍‌ଲଗେ ଅଟକ୍‌ଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ସେ ବିତ୍‌ରେ, ଗରେପସ୍‌ବା ପସୁ, ଡଙ୍ଗ୍‌ରେ ରଇବା ପସୁ, ରାଙ୍ଗି ବୁଲ୍‌ବାଟାମନ୍‌ ଆରି ବିନ୍‌ ବିନ୍‌ ରକାମର୍‌ ଚଡଇମନ୍‌ ରଇଲାଟା ନିକକରି ଦେକ୍‌ଲି । ");
INSERT INTO dso_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ତାର୍‌ପଚେ ଗଟେକ୍‌ କଁଟ୍‌ ସୁନ୍‌ଲି, “ପିତର୍‌ ! ଉଟ୍‌, ମାରିକରି କାଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ମାତର୍‌ ମୁଇ କଇଲି, “ନାଇ ମାପ୍‌ରୁ ! ମୁଲ୍‌କେ ନିଚି ! ଆମର୍‌ ଜିଉଦିମନର୍‌ ନିୟମ୍‌ ମନାକରିରଇବା ଇସାବେ, ଏବେ ଜାକ କାଇମିସା ମାଉଁସ୍‌ ଟଣ୍ଡେ ଚିଆଇ ନାଇତା ।” ");
INSERT INTO dso_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ସର୍‌ଗେଅନି ଆରିତରେକ୍‌ ଏ କଁଟ୍‌ ଆଇଲା, “ପରମେସର୍‌ କାଇଟା ଆଲେ କାଇ ଅଇସି ବଲି କଇଲେ ସେଟା ନିଚ୍‌ବାର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ଏନ୍ତାରି ତିନ୍‌ତର୍‌ ଅଇଲା ପଚେ, ସେ ଜଁତ୍‌ମନ୍‌ ରଇଲାଟା ସଙ୍ଗ୍‍ ସେ ଚାଦର୍‌ ସରଗ୍‌ ଉପ୍‌ରେ ଜିକିନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ସମାନ୍‌ ବେଲାଇସେ, କର୍‌ନିଲିଅ ପାଟାଇଲା ତିନ୍‌ ଲକ୍‌ ସିସେରିଆଇ ଅନି ମୁଇ ରଇବା ଗରେ ଆସି କେଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ଦୁଇମନିଆ ନ ଅଇ ସେମନର୍‌ ସଙ୍ଗ୍‍ ଜିବାକେ ମକେ ସୁକଲ୍‌ଆତ୍‌ମା ଚାଲ୍‌ନା ଦେଲା । ଜପାରର୍‌ ଏ ଚଅଟା ବିସ୍‌ବାସି ବାଇମନ୍‌ ମିସା ମର୍‌ ସଙ୍ଗ୍‍ ସିସେରିଆଇ ଗାଲାଇ ଆରି ଆମେ ସବୁ ଲକ୍‌ କର୍‌ନେଲିଅର୍‌ ଗରେ କେଟ୍‌ଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ତାର୍‌ ଗରେ ସେ କେନ୍ତି ସରଗ୍‌ ଦୁତର୍‌ ଦର୍‌ସନ୍‌ ପାଇରଇଲା, ସେ ବିସଇ ଆମ୍‌କେ ଜାନାଇଲା । ସରଗ୍‌ ଦୁତ୍‌ ତାକେ ଏନ୍ତି କଇରଇଲା, ଜପାତେଇ ରଇବା ପିତର୍‌କେ, ତାର୍‌ ଆରି ଗଟେକ୍‌ ନାଉଁ ଅଇଲାନି ସିମନ୍‌, ତାକେ ଇତି ଡାକି ଆନ୍‌ବାକେ ଲକ୍‌ ପାଟା । ");
INSERT INTO dso_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ସେ ଆସି ତମ୍‌କେ ସିକିଆ ଦେଇସି ଆରି ସିତିଅନି ତମ୍‌କେ ଆରି ତମର୍‌ ଗରର୍‌ ଲକ୍‌କେ ପର୍‌ମେସର୍‌ ରକିଆ କର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ଆରି ମୁଇ ଜେଡେବଲ୍‌ ସିକିଆଦେବାର୍‌ ଆରାମ୍‌ କଲି, ଆଗେ ସୁକଲ୍‌ ଆତ୍‌ମା ଜେନ୍ତାରି ଆମର୍‌ ଉପ୍‌ରେ ଡାବିଅଇରଇଲା, ସେନ୍ତାରି ସେମନର୍‌ ଉପ୍‌ରେ ଡାବିଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ତାର୍‌ପଚେ ମୁଇ ମାପ୍‌ରୁର୍‌ ଏ ବାକିଅ ଏତାଇଲି, ଜଅନ୍‌ ତମ୍‌କେ ପାନି ସଙ୍ଗ୍‍ ଡୁବନ୍‌ ଦେଲା, ମାତର୍‌ ପର୍‌ମେସର୍‌ ତମ୍‌କେ ସୁକଲ୍‌ଆତ୍‌ମାଇ ଡୁବନ୍‌ ଦେଇସି । ");
INSERT INTO dso_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","“ଏଟା ପୁରାପୁରନ୍‌ ସତ୍‌ ଜେ, ଆମେ ମାପ୍‌ରୁ ଜିସୁକିରିସ୍‌ଟକେ ବିସ୍‌ବାସ୍‌ କଲାକେ ପରମେସର୍‌ ଆମ୍‌କେ ଜନ୍‌ ଦାନ୍‌ ଦେଲାଆଚେ, ଜିଉଦିନଇଲା ଲକ୍‌ମନ୍‌କେ ମିସା ସେ ଦାନ୍‌ ଦେଲା ଆଚେ । ଜଦି ପର୍‌ମେସର୍‌ ମନ୍‍ କର୍‌ସି ବଇଲେ, ମୁଇ କେ ଜେ ପରମେସରର୍‌ ଏ କାମ୍‌ ଅଟ୍‌କାଇବି !” ");
INSERT INTO dso_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ଜିଉଦି ବିସ୍‌ବାସିମନ୍‌ ଏଟା ସୁନ୍‌ଲା ପଚେ ଆରି ନ ବାକାନିକରି ପର୍‌ମେସର୍‌କେ ଡାକ୍‌ପୁଟା କଲାଇ, “ସେନ୍ତାର୍‌ ଆଲେ ଜିଉଦିନଇଲା ଲକ୍‌ମନ୍‌କେ ମିସା ପାପ୍‌ କଲାଟା ମାନିଅଇକରି ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇବାକେ ସେ ସୁଜଗ୍‌ ଦେଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ଜିରୁସାଲେମର୍‌ ଲକ୍‌ମନ୍‌ ତିପାନ୍‌କେ ମରାଇଲାପଚେ ବିସ୍‌ବାସିମନ୍‌କେ ତାଡ୍‌ନା ଦେଲାଇ । ତେଇଅନି କେତେଲକ୍‌ ଚିନ୍‌ବିନ୍‌ ଅଇଗାଲାଇ । ସେମନ୍‌, ପିନିସିଆ, ସାଇପରସ୍‌ ଆରି ଆନ୍‌ଟିଅକ୍‌ ଟାନେ ଜାଇ ଅବ୍‌କା ଜିଉଦିମନ୍‌କେସେ ସୁବ୍‌ କବର୍‌ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ମାତର୍‌ କେତେଟା ସାଇପରସ୍‌ ଆରି କୁରିନିୟର୍‌ ବିନ୍‌ ବିସ୍‌ବାସିମନ୍‌, ଆନ୍‌ଟିଅକେ ଜାଇ ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ତେଇ ଜିସୁ ମାପ୍‌ରୁର୍‌ ସୁବ୍‌ କବର୍‌ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ପରମେସରର୍‌ ବପୁ ସେମନର୍‌ ସଙ୍ଗ୍‍ ରଇଲା ଆରି ବେସି ଲକ୍‌ ବିସ୍‌ବାସ୍‌ କରି ମାପ୍‌ରୁର୍‌ ବାଟେ ମନ୍‌ ବାଉଡାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ଆନ୍‌ଟିୟକିଆଇ ବେସି ଲକ୍‌ ଜିସୁର୍‌ଟାନେ ବିସ୍‌ବାସ୍‌ କଲାଇନି ବଲି ଜିରୁସାଲେମର୍‌ ମଣ୍ଡଲିମନ୍‌ ସୁନ୍‌ଲାଇ । ଆରି ସେମନ୍‌ ବର୍‌ନବାକେ ଆନ୍‌ଟିୟକିଆଇ ପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ବର୍‌ନବା ତେଇ କେଟିକରି ପର୍‌ମେସର୍‌ ସେ ଲକ୍‌ମନ୍‌କେ କେନ୍‌ତି ଆସିର୍‌ବାଦ୍‌ କଲାଆଚେ, ସେଟା ଦେକି ସାର୍‌ଦା ଅଇଲା । ଆରି ମନ୍‌ପରାନ୍‌ ଦେଇକରି ମାପ୍‌ରୁକେ ବିସ୍‌ବାସ୍‌ କରି ଚଲାଚଲ୍‌ତି କର୍‌ବାକେ ସେମନ୍‌କେ ସିକିଆ ଦେଇ ସାର୍‌ଦା କଲା । ");
INSERT INTO dso_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ବର୍‌ନବା ସୁକଲ୍‌ଆତ୍‌ମାଇ ଆରି ବିସ୍‌ବାସେ ପୁରୁନ୍‌ ଅଇ ରଇବା ଗଟେକ୍‌ ଦରମ୍‌ ଲକ୍‌ ରଇଲା । ସେ କବର୍‌ ଜାନାଇଲାକେ ବେସି ଲକ୍‌ ମାପ୍‌ରୁର୍‌ ଲଗେ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ତାର୍‌ ପଚେ ବର୍‌ନବା ସାଉଲ୍‌କେ କଜ୍‌ବାକେ ତାର୍‌ସସ୍‌ ଜାଗାଇ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ତେଇ ତାକେ ବେଟ୍‍ପାଇ ବର୍‌ନବା ଆନ୍‌ଟିଅକେ ଡାକି ଦାରିଆଇଲା । ପୁରା ଗଟେକ୍‌ ବରସ୍‌ ଜାକ ବର୍‌ନବା ଆରି ସାଉଲ୍‌ ତେଇ ମଣ୍ଡଲିର୍‌ ବିସ୍‌ବାସିମନର୍‌ ସଙ୍ଗ୍‍ ମିସି, ଲକ୍‌ମନ୍‌କେ ସିକିଆ ଦେଲାଇ । ଏ ଆନ୍‌ଟିଅକର୍‌ ବିସ୍‌ବାସିମନ୍‌କେସେ ଲକ୍‌ମନ୍‌ ସିଗ୍‌ ପର୍‌ତୁମ୍‌ କିରିସ୍‌ଟାନ୍‌ ବଲି କଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ସେବେଲାଇ କେତେଟା ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ଜିରୁସାଲମେଅନି ଆନ୍‌ଟିଅକେ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ସେମନର୍‌ ବିତ୍‌ରେଅନି ଆଗାବ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଆତ୍‌ମାର୍‌ ବପୁ ସଙ୍ଗ୍‍ ପୁରୁନ୍‌ ଅଇ, ଗୁଲାଇ ଦେସେ ଗଟେକ୍‌ ବଡ୍‌ ମର୍‌ଡି ଅଇସି ବଲି ବବିସତ୍‌ କାତା ସୁନାଇ ରଇଲା । ଏଟା ବଡ୍‌ ସାସନ୍‌କାରିଆ କଲ୍‌ଡିୟ ରମ୍‌ଦେସେ ସାସନ୍‌ କଲାବେଲେ ଗଟି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ଆନ୍‌ଟିକିଅର୍‌ ସିସ୍‌ମନ୍‌ ଜିଉଦାଇ ରଇଲା ବିସ୍‌ବାସି ବାଇମନ୍‌କେ ତାକର୍‌ ପାର୍‌ଲା ଏତ୍‌କି ଡାବୁ ପାଟାଇବାକେ ଟିକ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ସେମନ୍‌ ଡାବୁ ଜମାଇକରି ବର୍‌ନବା ଆରି ସାଉଲର୍‌ ଆତେ, ମଣ୍ଡଲିର୍‌ ପାର୍‌ଚିନ୍‌ମନର୍‌ ଲଗେ ପାଟାଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ଏ ବେଲାଇ, ଏରଦ୍‌ ରାଜା ଜିରୁସାଲେମ୍‌ ମଣ୍ଡଲିର୍‌ କେତେକ୍‌ ବିସ୍‌ବାସିମନ୍‌କେ ତାଡ୍‌ନା ଦେବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ଜଅନର୍‌ ବାଇ ଜାକୁବ୍‌କେ କାଣ୍ଡା ସଙ୍ଗ୍‍ ମାରି ମରାଇଲା, ଜାକୁବ୍‌ ଜଅନର୍‌ ବଡ୍‌ ବାଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ଜାକୁବ୍‌କେ ମରାଇଲାଟା ଜିଉଦିମନ୍‌କେ ସାର୍‌ଦା କରାଇଲା । ଏଟା ଦେକି ଏରଦ୍‌ ପିତର୍‌କେ ମିସା ବନ୍ଦି କର୍‌ବାକେ ତିଆର୍‌ଲା । ଏଟା ଜିଉଦିମନ୍‌ କମିର୍‌ ନ ମିସାଇତେ ରୁଟିକର୍‌ବା ପରବ୍‌ ବେଲେ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ସଇନମନ୍‌ ପିତର୍‌କେ ବାନ୍ଦିକରି ବନ୍ଦିଗରେ ପୁରାଇଲାଇ । ରକିଆ ପାଇବା ପରବର୍‌ ପଚେ ସବୁ ଲକର୍‌ ମୁଆଟେ ବିଚାର୍‌ନା କର୍‌ବି ବଲି ଏରଦ୍‌ ବାବି ରଇଲା । ସେଟାର୍‌ପାଇ ଗଟେକ୍‌ ଦଲେ ଚାରିଲକ୍‌ ଲାକା ଅଇ, ଚାରିଟା ଦଲ୍‌କରି ସନିଅମନ୍‌ ତାକେ ଜାଗିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ପିତର୍‌ ବନ୍ଦିଗରେ ରଇଲାବେଲେ ଜିରୁସାଲେମେ ରଇବା ମଣ୍ଡଲିର୍‌ ବିସ୍‌ବାସିମନ୍‌ ଗଟେକ୍‌ ଅଇକରି ତାର୍‌ପାଇ ପର୍‌ମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ଜନ୍‌ ଦିନେ ଏରଦ୍‌ ପିତର୍‌କେ ଲକ୍‌ମନର୍‌ ମୁଆଟେ ଆନ୍‌ବାକେ କାତା ଦେଇରଇଲା, ତାର୍‌ ଆଗ୍‌ତୁର୍‌ ରାତି ପିତର୍‌ ବନ୍ଦିଗରେ ଦୁଇଟା ଜାଗୁଆଲ୍‌ମନର୍‌ ମଜାଇ ସଇରଇଲା । ତାକେ ସନିଅମନର୍‌ ମିସ୍‌ତେ ଦୁଇଟା ଆତେ ଦୁଇଟା ସିକ୍‌ଲି ସଙ୍ଗ୍‍ ବାନ୍ଦିରଇଲାଇ । ଆରି ଜାଗୁଆଲ୍‌ମନ୍‌ ବନ୍ଦିଗରର୍‌ ଦୁଆରେ ଜାଗିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ସେ ଦାପ୍‌ରେ, ଏଦେ ଦେକା ! ମାପ୍‌ରୁର୍‌ ଗଟେକ୍‌ ଦୁତ୍‌ ଆସି ପିତରର୍‌ ମୁଆଟେ ଟିଆଅଇଲା ଆରି ଗୁଲାଇ ବାକ୍‌ରା ଉଜଲ୍‌ ଅଇଗାଲା । ସରଗର୍‌ ଦୁତ୍‌ ପିତର୍‌କେ କନ୍ଦେ ଦାରି ଚୁଲ୍‌ବୁଲାଇଲା ଆରି ସଇଲାଟାନେଅନି ଉଟାଇକରି କଇଲା “ଦାପ୍‌ରେ ଉଟ୍‌ !” ଉଟ୍‌ଲା ଦାପ୍‌ରେ ବାନ୍ଦି ଅଇରଇଲା ସିକ୍‌ଲି କୁସ୍‌ଲିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ତାର୍‌ପଚେ ଦୁତ୍‌ କଇଲା, “ଆଁଟାଇ ତୁଆଲ୍‌ ବାନ୍ଦିଅ ଆରି ପାଣ୍ଡଇ ପିନ୍ଦ୍‌ ।” ପିତର୍‌ ସେନ୍ତି କଲା ପଚେ ଦୁତ୍‌ କଇଲା, “ଚାଦର୍‌ ଡାବିଅଇକରି ମର୍‌ ସଙ୍ଗ୍‍ ଆଉ ।” ");
INSERT INTO dso_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ପିତର୍‌ ଦୁତର୍‌ ପଚେ ପଚେ ବନ୍ଦିଗରେ ଅନି ବାରଇ ଆଇଲା । ଦୁତ୍‌ ଜନ୍‌ଟା କର୍‌ତେରଇଲା, ସେଟା ସତ୍‌ କି ନଏଁ ବଲି ଜାନି ନାପାର୍‌ତେରଇଲା । “ଏଟା ଗଟେକ୍‌ ଦର୍‌ସନ୍‌ ଦେକ୍‌ଲିନି ।” ବଲି ବାବ୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ସେମନ୍‌ ଜାଗୁଆଲ୍‌ମନ୍‌ ରଇବା ଦୁଇଟା ଜାଗା ଜିତିକରି ପଚେ ନଅରେ ପୁର୍‌ବା ଲୁଆ କାପାଟ୍‌ ରଇବା ଲଗେ ଆଇଲାଇ । ତାକର୍‌ପାଇ ଲୁଆ କାପାଟ୍‌ ତାର୍‌ମନ୍‌କେସେ ଉଗାଡିଅଇଗାଲା ଆରି ସେମନ୍‌ ବାରଇ ଉଟିଆଇଲାଇ । ସେମନ୍‌ ବାଟେ ଇଣ୍ଡୁ ଇଣ୍ଡୁ ଅଟାତ୍‌ ସରଗର୍‌ ଦୁତ୍‌ ପିତର୍‌କେ ଚାଡି ମାୟା ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ତାର୍‌ପଚେ ଜାଇଟା ଗଟିରଇଲା, ସେଡ୍‌କିବେଲେ ତାକେ କାଇଟା ଅଇରଇଲା, ସେଟା ପିତର୍‌ ଜାନିପାରି କଇଲା, “ଏଟା ସତ୍‌ ବଲି ମୁଇ ଜାନିଆଚି । ଏରଦର୍‌ ଟାନେଅନି ଆରି ଜିଉଦି ଲକ୍‌ମନ୍‌ ଜାଇଟା ଗଟ୍‌ସି ବଲି ଆସା କରିରଇଲାଇ, ତେଇଅନି ମକେ ରକିଆ କର୍‌ବାକେ ମାପ୍‌ରୁ ସରଗର୍‌ ଦୁତ୍‌କେ ପାଟାଇରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ନିଜର୍‌ ବିସଇ ଜାନିକରି ସେ ଜଅନ୍‌ ମାର୍‌କର୍‌ ଆୟା ମରିୟମର୍‌ ଗରେ ଗାଲା । ତେଇ ବେସି ବିସ୍‌ବାସିମନ୍‌ ରୁଣ୍ଡିକରି ପିତରର୍‌ ପାଇ ପାର୍‌ତନା କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପିତର୍‌ ବାଇରର୍‌ କାପାଟେ ଟକ୍‌ଟକ୍‌ କରି ମାର୍‌ଲାକେ, ରଦା ନାଉଁର୍‌ ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡି କାପାଟ୍‌ ଉଗାଡ୍‌ବାକେ ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ପିତରର୍‌ କଁଟ୍‌ସର୍‌ ଜାନିପାରି ସେ ଏତେକ୍‌ ସାର୍‌ଦା ଅଇଲା ଜେ କାପାଟ୍‌ ନ ଉଗାଡି ବିତ୍‌ରେ ପାଲାଇକରି ତେଇର୍‌ ବିସ୍‌ବାସିମନ୍‌କେ କଇଲା, “ପିତର୍‌ ବାଇରେ ଟିଆଅଇଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ସେମନ୍‌ ତାକେ କଇଲାଇ, “ତୁଇ ବାୟାଅଇଲୁସ୍‌ନି ! ମାତର୍‌ ‘ଏଟା ସତ୍‌ ।’ ବଲି ସେ ଡାଟ୍‌ ସଙ୍ଗ୍‍ କଇଲାଗ୍‌ଲାକେ, ସେମନ୍‌ ଏଟା ତାର୍‌ ଦୁତ୍‌ କାଇକି,” ବଲି ବାବ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ପିତର୍‌ ତର୍‌କେ ତର୍‌ କାପାଟେ ମାର୍‌ତେ ରଇଲା । ସାରାସାରି ସେମନ୍‌ କାପାଟ୍‌ ଉଗାଡି ତାକେ ଦେକି କାବାଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ସେ ଆତ୍‌ ସାଗିଆକରି ସେମନ୍‌କେ ଚିମ୍‌ରା ଅଇବାକେ କଇଲା । ଆରି ମାପ୍‌ରୁ କେନ୍ତି ତାକେ ବନ୍ଦି ଗରେଅନି ବାର୍‌କରାଇ ଆନ୍‌ଲା, ସେ ବିସଇ ସେମନ୍‌କେ କଇଲା । ତାର୍‌ ପଚେ ଏ ସବୁ କାତା ଜାକୁବ୍‌ ଆରି ବିନ୍‌ ସବୁ ବାଇମନ୍‌କେ ଜାନାଆ ବଲି କଇଲା । ପଚେ ସେ ତେଇଅନି ବିନ୍‌ବାଟେ ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ସାକାଲ୍‌ ପାଇଲାକେ “ପିତର୍‌ କେନେଗାଲା ?” ବଲି ଜାଗୁଆଲ୍‌ମନ୍‌ କିଲ୍‌ବିଲ୍‌ ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ଏରଦ୍‌ ଏଟା ସୁନିକରି ପିତର୍‌କେ କଜ୍‌ବାକେ ତାର୍‌ ସନିଅମନ୍‌କେ ଆଦେସ୍‌ ଦେଲା । ମାତର୍‌ ସେମନ୍‌ ତାକେ ମିଲାଇ ନାପାର୍‌ଲାଇ । ତେବେ ସାରାସାରି ଜାଗୁଆଲ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା । କେନ୍ତି ଏଟା ଅଇଲାଟା କଇନାପାର୍‌ଲାକେ ସେମନ୍‌କେ ମରନର୍‌ ଡଣ୍ଡ୍ ଦେବାକେ ଆଦେସ୍‌ ଦେଲା । ତାର୍‌ ପଚେ ଏରଦ୍‌ ଜିଉଦା ରାଇଜେଅନି ଜାଇ କେତେ ଦିନର୍‌ପାଇ କାଇସରିଆଇ ବାସା ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ସେ ବେଲାଇ ଏରଦ୍‌ ସର୍‌ ଆରି ସିଦନର୍‌ ଲକ୍‌ମନ୍‌କେ ବେସି ରିସା ଅଇରଇଲା । ସେଟାର୍‌ ପାଇ ତେଇର୍‌ ଲକ୍‌ମନ୍‌ ଗଟେକ୍‌ ଦଲ୍‌, ତାକେ ବେଟ୍‌ ଅଇବାକେ ଗାଲାଇ । ପର୍‌ତୁମ୍‌ ସେମନ୍‌ ରାଜା ସଇବା ଗର୍‌ ଦାଇତେ ରଇଲା ବାଲସ୍‌ଟସ୍‌କେ ବୁଜାଇ, ତାର୍‌ ସାଇଜ ପାଇଲାଇ । ତାର୍‌ ପଚେ ସେମନ୍‌ ଏରଦର୍‌ ଲଗେ ଜାଇ ସାନ୍ତିସଙ୍ଗ୍‍ ରଉଁ ବଲି କାତା ଅଇଲାଇ, କାଇକେ ବଇଲେ ଏରଦର୍‌ ରାଇଜେଅନି ସେମନର୍‌ ଦେସେ କାଇବା ଜିନିସ୍‌ ଜାଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ଜନ୍‌ ଦିନେ ଏରଦର୍‌ ସଙ୍ଗ୍‍ ସେମନ୍‌ ବେଟ୍‌ ଅଇବାକେ ଟିକ୍‌ କରିରଇଲାଇ, ସେ ରାଜାମନ୍‌ ପିନ୍ଦ୍‌ବା ବସ୍‌ତର୍‌ ପିନ୍ଦ୍‌ଲା ଆରି ତାର୍‌ ବସ୍‌ବା ଜାଗାଇ ବସି ଲକ୍‌ମନ୍‌କେ ଗଟେକ୍‌ ବାସନ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ସୁନ୍‌ବା ଲକ୍‌ମନ୍‌ ଆଉଲିଅଇଲାଇ, “ଜେ କାତା ଅଇଲାନି, ସେ ଲକ୍‌ ନଏଁ, ମାତର୍‌ ପର୍‌ମେସର୍‌ !” ");
INSERT INTO dso_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","“ମୁଇ ପର୍‌ମେସର୍‌ ନଇ,” ବଲି କଏ ନାଇକେ ଦାପ୍‌ରେ ମାପ୍‌ରୁର୍‌ ଦୁତ୍‌ ଏରଦ୍‌କେ ରଗି କରାଇଲା । ସେଟାର୍‌ପାଇ ତାର୍‌ ଗୁଲାଇଗାଗଡ୍‌ କିଡା କାଇଲାଇ ଆରି ମରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ଏ ବେଲାଇ ବିସ୍‌ବାସିମନ୍‌ ପର୍‌ମେସରର୍‌ ବାକିଅ ସୁନ୍‌ଲାଇ ଆରି ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌ ବଡିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ଜିଉଦା ଦେସର୍‌ ବିସ୍‌ବାସିମନ୍‌କେ ଡାବୁ ଦେଇ ସାରାଇକରି ବର୍‌ନବା ଆରି ସାଉଲ୍‌, ଆନ୍‌ଟିଅକିଆଇ ଆଇଲାଇ । ଜଅନ୍‌ ଆରି ମାର୍‌କକେ ମିସା ସେମନ୍‌ ସଙ୍ଗ୍‍ ନେଇ ଜିରୁସାଲମେ ବାଅଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ଆନ୍‌ଟିଅକି ମଣ୍ଡଲିତେଇ କେତେଟା ବବିସତ୍‌ବକ୍‌ତା ଆରି ସିକିଆ ଦେବା ଗୁରୁ ରଇଲାଇ । ସେମନର୍‌ ବିତ୍‌ରେ ରଇଲାଇ ବର୍‌ନବା, ସିମନ୍‌ ଜାକେ କି ନିଗର୍‌ ଡାକ୍‌ତେରଇଲାଇ, ଲୁସିଅସ୍‌, ଜେ କି କୁରିନିୟ ଅନି ଆସିରଇଲା, ମନଏଁମ୍‌ ଜେ କି ଏରଦର୍‌ ଗରେ ବଡି ରଇଲା ଆରି ସାଉଲ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ସେମନ୍‌ ମାପ୍‌ରୁର୍‌ ସେବା ଆରି ଉପାସ୍‌ କଲାବେଲେ, ସୁକଲ୍‌ ଆତ୍‌ମା ସେମନ୍‌କେ କଇଲା, “ମୁଇ ଜନ୍‌ କାମ୍‌ପାଇ ସାଉଲ୍‌ ଆରି ବର୍‌ନବାକେ ଡାକ୍‌ଲି ଆଚି, ସେଟାର୍‌ ପାଇ ସେମନ୍‌କେ ଅଲ୍‌ଗା କରା ।” ");
INSERT INTO dso_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ସେଟାର୍‌ପାଇ ସେମନ୍‌ ଉପାସ୍‌ କଲାଇ ଆରି ପାର୍‌ତନା କରି ତାକର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ସଙ୍ଗଇ ସେମନ୍‌କେ କବର୍‌ କଇବା କାମେ ପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ସୁକଲ୍‌ ଆତ୍‌ମାଇଅନି ଆଦେସ୍‌ ପାଇକରି ଜାଇରଇବା ବର୍‌ନବା ଆରି ସାଉଲ୍‌ ସେଲୁକିଆଇ ଗାଲାଇ । ଆରି ତେଇଅନି ପାନି ଜାଜେ ବସି ସାଇପରସ୍‌ ସମ୍‌ଦୁର୍‌ ମଜାଇ ରଇବା ଜାଗାଇ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ସାଲାମି ଗଡେ କେଟି ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ପରମେସରର୍‌ ବାକିଅ ଜାନାଇଲାଇ । ଜଅନ୍‌ ମାର୍‌କ ମିସା ସେମନର୍‌ ସଙ୍ଗ୍‍ ରଇକରି ସେମନ୍‌କେ ସାଇଜ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ସେମନ୍‌ ସାଇପରସ୍‌ ଜାଗା ଚାଡି ପାପ୍‌ତେ ନାଉଁର୍‌ ଜାଗାଇ ଗାଲାଇ । ତେଇ ବାର୍‌ଜିସୁ ନାଉଁର୍‌ ଗଟେକ୍‌ ମଁତର୍‌ ସିକିରଇବା ଜିଉଦିକେ ବେଟ୍‌ଅଇଲାଇ । ସେ ନିଜ୍‌କେ ମିଚ୍‌ରେ ବବିସତ୍‌ବକ୍‌ତା ବଲି କଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ସେ ସମ୍‌ଦୁର୍‌ ମଜାଇ ରଇଲା ଜାଗାର୍‌ ସାସନ୍‌ କାରିଆର୍‌ ସର୍‌ଗିଅ ପାଉଲର୍‌ ମଇତର୍‌ ରଇଲା । ସର୍‌ଗିଅସ୍‌ ଗଟେକ୍‌ ଗିଆନି ଲକ୍‌ ରଇଲା । ସେ ପରମେସରର୍‌ ବାକିଅ ସୁନ୍‌ବାକେ ମନ୍‌ କରି ବର୍‌ନବା ଆରି ପାଉଲ୍‌କେ ଡାକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ମାତର୍‌ ଗୁନିଆଁ ଏଲିମାସ୍‌, (ଏଟା ତାର୍‌ ଗିରିକ୍‌ ନାଉଁ) ସେମନ୍‌କେ ନିଚୁ ବଲି କଇଲା, କାଇକେ ବଇଲେ, ସେ ସାସନ୍‌ କାରିଆ କିରିସ୍‌ଟକେ ବିସ୍‌ବାସ୍‌ ନ କର ବଲି ବାବ୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ମାତର୍‌ ସାଉଲ୍‌ ଜାର୍‌ ନାଉଁକି ପାଉଲ୍‌, ସୁକଲ୍‌ ଆତ୍‌ମାଇ ପୁରୁନ୍‌ ଅଇ, ମଁତର୍‌ ଜାନିରଇବା ଲକର୍‌ ବାଟେ ନିକ ଦେକ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ଆରି କଇଲା, “ଏ ସଇତାନର୍‌ ପିଲା ! ତୁଇ, ସବୁ ନିମାନ୍‌ ବିସଇ ବିରଦ୍‌ କଲାସ୍‌ନି । ତୁଇ ସବୁ ରକାମର୍‌ କରାପ୍‌ କାମେ ପୁରୁନ୍‌ ଅଇ ଆଚୁସ୍‌ ଆରି ସବୁବେଲେ ପର୍‌ମେସରର୍‌ କାମ୍‌ ମିଚ୍‌ ବଲି ଦେକାଇବାକେ ଚେସ୍‌ଟା କଲୁସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଏବେ ମାପ୍‌ରୁର୍‌ ଆତେ ଡଣ୍ଡ୍ ପାଇସୁ । ତୁଇ କାଣା ଅଇଜାଇକରି ଚନେକର୍‌ପାଇ ବେଲର୍‌ ଉଜଲ୍‌ ଦେକି ନାପାରୁସ୍‌ ।” ସେଦାପ୍‌ରେ ଏଲିମାସର୍‌ ଆଁକି ଦୁଉଁରି ଆନ୍ଦାର୍‌ ଅଇଗାଲାପାରା ଲାଗ୍‌ଲା । ଆରି ତାକେ ଆତେ ଦାରି ଡାକିନେବାକେ ଗଟେକ୍‌ ଲକ୍‌କେ ଏନେତେନେ ଆଣ୍ଡାଲି ଅଇ କଜି ବୁଲ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ଏଟା ଦେକି ସାସନ୍‌କାରିଆର୍‌ ବିସ୍‌ବାସ୍‌ ଅଇଲା, କାଇକେ ବଇଲେ ମାପ୍‌ରୁର୍‌ ସିକିଆ ସୁନି ସେ କାବା ଅଇଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ପାଉଲ୍‌ ଆରି ତାର୍‌ ସଙ୍ଗ୍‍ ଜିବା ଲକ୍‌ମନ୍‌ ପାପସ୍‌ ଜାଗାଇ ଅନି ପାନିଜାଜେ ଜାଇ ପପୁଲିଆର୍‌ ପର୍‌ଗା ନାଉଁ ଜାଗାର୍‌ ଗଟେକ୍‌ ଗଡେ କେଟ୍‌ଲାଇ । ଜଅନ୍‌ମାର୍‌କ ତେଇ ସେମନ୍‌କେ ଚାଡିକରି ଜିରୁସାଲାମ୍‌ ବାଉଡିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ସେମନ୍‌ ପର୍‌ଗାଇଅନି ଜାଇ ପିସିଦିଆର୍‌ ଆନ୍‌ଟିଅକେ କେଟ୍‌ଲାଇ । ଆରି ବିସ୍‌ରାମ୍‌ବାର୍‌ ଦିନେ ପାର୍‌ତନା ଗରେ ଜାଇ ବସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ମସାର୍‌ ନିୟମ୍‌ ଆରି ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ଲେକା ପଡ୍‌ଲା ପଚେ, ପାର୍‌ତନା ଚାଲାଉମନ୍‌ ସେମନ୍‌କେ ଏ କାତା କଇପାଟାଇଲାଇ, “ବାଇମନ୍‌ ଜଦି ଲକ୍‌ମନର୍‌ ସାର୍‌ଦା ବଡାଇବାପାରା ଉପ୍‌ଦେସ୍‌ ଦେବାର୍‌ ଆଚେ, ତେବେ କୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ପାଉଲ୍‌ ଟିଆଅଇ ଲକ୍‌ମନ୍‌କେ ଚିମ୍‌ରାଇ ଅଇବାକେ ଆତ୍‌ ସାଗିଆ କରି କଇଲା । “ଇତି ରୁଣ୍ଡ୍‌ଅଇଲା ଇସ୍‌ରାଏଲ ବାଇମନ୍‌ ଆରି ପର୍‌ମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ବା ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌, ମର୍‌ କାତା ସୁନା ! ");
INSERT INTO dso_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ଇସ୍‌ରାଏଲ୍‌ ଜାତିର୍‌ ପରମେସର୍‌ ଆମର୍‌ ଆନିଦାଦିମନ୍‌କେ ବାଚ୍‌ଲା । ଆରି ମିସର୍‌ ଦେସେ ସେମନ୍‌ ପର୍‌ଦେସିଅଇ ରଇତେ ରଇଲା ବେଲେ, ଗଟେକ୍‌ ବଡ୍‌ ଜାତି କଲା । ପରମେସର୍‌ ତାର୍‌ ବଡ୍‌ ବପୁ ସଙ୍ଗ୍‍ ସେମନ୍‍କେ ମିସରେଅନି ବାର୍‌କରାଇ ଆନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ଆରି ଚାଲିସ୍‌ ବରସ୍‌ ଜାକ ମରୁବାଲିବୁଏଁ ସେମନର୍‌ ସାଦ୍‌ବାନ୍ଦ୍‌ କଲାଟା ମୁରଚ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ସେ କିଣାନେ ସାତ୍‌ଟା ଦଲ୍‌କେ ନସ୍‌ଟ କରି ତାର୍‌ ବାଚ୍‌ଲା ଲକ୍‌ମନ୍‌କେ ସେ ଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ପାକାପାକି ଚାର୍‌ ସଅ ପଚାସ୍‌ ବରସ୍‌ ବିତ୍‌ରେ ଏ ସବୁ ଗଟ୍‍ନା ଗଟିଗାଲା ।” “ତାର୍‌ ପଚେ ସାମୁଏଲ୍‌ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ବେଲା ଜାକ ପରମେସର୍‌ ସେମନର୍‌ ଉପ୍‌ରେ ବିଚାର୍‌ପତିମନ୍‌କେ ବାଚ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ଜେଡେବେଲେ ସେମନ୍‌ ଗଟେକ୍‌ ରାଜା ଦର୍‌କାର୍‌ ବଲି କଇଲାଇ, ପରମେସର୍‌ ସେମନ୍‌କେ ଚାଲିସ୍‌ ବରସ୍‌ ଜାକ ସାସନ୍‌ କର୍‌ବାକେ ବେନ୍‍ଜାମିନ୍‌ କୁଟୁମର୍‌ କିସ୍‌ଅର୍‌ ପଅ ସାଉଲ୍‌କେ ବାଚ୍‌ଲା । ସାଉଲ୍‌ ଇସ୍‌ରାଏଲିୟମନ୍‌କେ ଚାଲିସ୍‌ବରସ୍‌ ସାସନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ତାର୍‌ ପଚେ ପର୍‌ମେସର୍‌ ତାକେ ରାଜା ପଦ୍‌ ଚାଡାଇକରି ଦାଉଦ୍‌କେ ସେମନର୍‌ ରାଜା କଲା ।” ପରମେସର୍‌ ତାର୍‌ ବିସଇ କଇରଇଲା, “ମୁଇ ଜନ୍‌ ରକାମେ ଲକ୍‌ମନ୍‌କେ ଆଲାଦ୍‌ କର୍‌ବି, ଜେସିର୍‌ ପଅ ଦାଉଦ୍‌ ସେନ୍ତାରି ଗଟେକ୍‌ ଲକ୍‌ । ସେ ମୁଇ ମନ୍‌କଲା ଇସାବେ ସବୁଜାକ କାମ୍‌ କର୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ଏ ଦାଉଦର୍‌ କୁଟୁମର୍‌ ଲକର୍‌ଟାନେଅନି ପର୍‌ମେସର୍‌ ସେ କାତା ଦେଲା ଇସାବେ ଜିସୁକେ ଇସ୍‌ରାଏଲ୍‌ ଜାତିର୍‌ ମୁକ୍‌ତିକାରିଆ କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ଜିସୁ ତାର୍‌ କାମ୍‌ ଆରାମ୍‌ କର୍‌ବା ଆଗ୍‌ତୁ, ଜଅନ୍‌ ଇସ୍‌ରାଏଲର୍‌ ସବୁ ଲକର୍‌ ଲଗେ ଜାନାଇକରି, ସେମନ୍‌କେ ପାପେଅନି ମନ୍‌ ବାଉଡାଇ ଡୁବନ୍‌ ନେବାକେ ଅଇସି ବଲି କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ଆରି ଜଅନ୍‌ ତାର୍‌ ସେବା କାମ୍‌ ସାରାଇବା ଆଗ୍‌ତୁ ଲକ୍‌ମନ୍‌କେ ପାଚାର୍‌ଲା, “ମର୍‌ ବିସଇ ତମେ କାଇଟା ବାବ୍‌ଲାସ୍‌ନି ? ତମେ ଜାକେ ଜାଗି ଆଚାସ୍‌, ମୁଇ ସେ ନଇ । ମାତର୍‌ ସୁନା ! ସେ ଦାପ୍‌ରେ ଆଇଲାନି । ତାର୍‌ ଗତିଦାଙ୍ଗ୍‌ଡା ଅଇକରି ପାଣ୍ଡଇର୍‌ ପିତା ମିସା କୁସ୍‌ଲାଇବାକେ ମର୍‍ ଅଦିକାର୍‍ ନଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ଏ ମର୍‌ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌, ଅବ୍‌ରାଆମର୍‌ ନାତିତିତିମନ୍‌ ଆରି ପରମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ବାକେ ଇତି ରୁଣ୍ଡ୍‌ଲା ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌, ଆମ୍‌କେ ସେ ମୁକ୍‌ତିର୍‌ କବର୍‌ ମିଲ୍‌ଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ମାତର୍‌ ସେ ଆକା ଉଦାର୍‌କାରିଆ । ଜିରୁସାଲମର୍‌ ଲକ୍‌ ଆରି ସେମନର୍‌ ନେତାମନ୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ଲେକାଇଅନି ପଡ୍‌ଲାଟା ଲକ୍‌ମନ୍‌ ବୁଜତ୍‌ନାଇ । ଏଲେମିସା ଜିସୁକେ ଦସି କରି ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ କାତା ସିଦ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ଜିସୁକେ ବେସି ଲକ୍‌ ଦସ୍‌ଦେଲାଇ । ମାତର୍‌ କେ ମିସା ମରନର୍‌ ଡଣ୍ଡ୍‌ ପାଇବା ଏତ୍‌କି ଦସ୍‌ କଜି ନାପାର୍‌ଲାଇ । ଏଲେମିସା ତାକେ ମରନର୍‌ ଡଣ୍ଡ୍ ଦେବାକେ ପିଲାତ୍‌କେ ବାଦିଅ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ସାସ୍‌ତରେ ଜନ୍‌ ସବୁ ବିସଇ ଲେକା ଆଚେ, ସେ ଇସାବେ ସବୁ କାମ୍‌ କଲାପଚେ ସେମନ୍‌ ତାକେ କୁର୍‌ସେଅନି ଉତ୍‌ରାଇ ଆନ୍‌ଲାଇ । ବିନ୍‌ଲକ୍‌ମନ୍‌ ଆସିକରି ତାର୍‌ ଗାଗଡ୍‌ ନେଇ ସମାଦିଟାନେ ସଙ୍ଗଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ମାତର୍‌ ପର୍‌ମେସର୍‌ ତାକେ ମଲାତେଇଅନି ଉଟାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ବେସି ଦିନ୍‌ ଜାକ, ତାର୍‌ ସଙ୍ଗ୍‍ ଗାଲିଲିଅନି ଜିରୁସାଲମ୍‌ ଆଇବାଜିବା ଲକ୍‌ମନ୍‌ ତାକେ ଦେକ୍‌ଲାଇ । ଏବେ ସେମନ୍‌ ଇସ୍‌ରାଏଲ୍‌ ଲକ୍‌ମନର୍‌ତେଇ ତାର୍‌ ସାକି ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ଆମର୍‌ ଆନିଦାଦିମନକେ ପର୍‌ମେସର୍‌ କାତା ଦେଇରଇଲା ଇସାବେ ଆମେ ତମ୍‌କେ ଏ ସୁବ୍‌ କବର୍‌ ଜାନାଇଲୁନି । ");
INSERT INTO dso_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ପରମେସର୍‌ ଜିସୁକେ ମଲାତେଇଅନି ଉଟାଇକରି ସେଟା ସିଦ୍‌ କଲାଆଚେ । ସେମନର୍‌ ପିଲାମନ୍‌ ଆମ୍‌କେ, ଆମର୍‌ ବିତ୍‌ରେ ସେ କାତା ଦେଲାଟା ସିଦ୍‌ ଅଇଲା ଆଚେ । ଗିତ୍‌ ସଙ୍ଗିତାର୍‌ ଦୁଇ ଲମର୍‌ ଗିତେ ଦାଉଦ୍‌ ଏନ୍ତାରି ଲେକିଆଚେ, “ତମେ ମର୍‌ ପଅ, ଆଜି ମୁଇ ସବୁକେ ଦେକାଇ ଆଚି ଜେ ସତଇସେ ମୁଇ ତର୍‌ ବାବା ।” ");
INSERT INTO dso_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ଆରି ପର୍‌ମେସର୍‌ ପୁର୍‌ବେଅନି ସପତ୍‌ କରି କାତାଦେଇରଇଲା । ମୁଇ ତାକେ ମଲାତେଇଅନି ଉଟାଇବି । ତାର୍‌ ଗାଗଡ୍‌ ସମାଦିତେଇ କୁଇ ଜିବାକେ ନ ଦେଇ । ଦାଉଦ୍‌କେ ଦେଇ ରଇବା ସପତ୍‌ ଇସାବେ ସତଇସେ ମୁଇ ତମ୍‌କେ ସୁକଲ୍‌ କରି ସବୁ ଆସିର୍‌ବାଦ୍‌ ଦେବି । ");
INSERT INTO dso_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ଦାଉଦ୍‌ ଆରି ଗଟେକ୍‌ ଗିତସଙ୍ଗିତାଇ ଲେକ୍‌ଲାଆଚେ, ମୁଇ ମରିଗାଲେ ମର୍‌ଗାଗଡ୍‌ ତୁଇ ସମାଦିତେଇ କୁଇ ଜିବାକେ ଚାଡି ନ ଦେଉସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଉଦ୍‌ ସାସନ୍‌ କଲାବେଲେ ପର୍‌ମେସର୍‌ ମନ୍‌ କଲା ଇସାବେ କାମ୍‌ କରି ସାରାସାରି ମଲା । ଆରି ଆନିଦାଦିମନର୍‌ ସଙ୍ଗ୍‍ ତପିଅଇଲା । ତାର୍‌ ଗାଗଡ୍‌ ସମାଦିତେଇ କୁଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ମାତର୍‌ ପର୍‌ମେସର୍‌ ଜାକେ ମଲାଟାନେଅନି ଉଟାଇଲା, ତାର୍‌ ଗାଗଡ୍‌ କୁଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ତେବର୍‌ପାଇ ମର୍‌ ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌, ତମେ ଏଟା ଜାନିରୁଆ । ଜିସୁ କରିରଇବା କାମେଅନି ସେ, ତମର୍‌ ପାପ୍‌ କେମା ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ମସାର୍‌ ନିୟମ୍‌ ମାନିକରି ଆଚୁ ବଇଲେ ପାପ୍‌ କେମା ନ ଅଇତା । ମାତର୍‌ ଜିସୁର୍‌ ଟାନେ ବିସ୍‌ବାସ୍‌ କଲାର୍‌ପାଇ ଆମେ ସବୁଲକ୍‌ ପାପେ ଅନି ମୁକ୍‌ଲି ଆଚୁ, ସେଟା ତମେ ଜାନ୍‌ବାର୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ଜାଗ୍‍ରତ୍‌, ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ଜାଇଟା କଇଲାଇ ଆଚତ୍‌, ସେଟା ଜେନ୍ତିକି ତମ୍‌କେ ନ ଗଟ । ");
INSERT INTO dso_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ପର୍‌ମେସର୍‌ କଇଲା, ଏ ମକେ କିଜାଇବା ଲକ୍‌ମନ୍‌ ! ତମେମନ୍‌ କିଲ୍‌ବିଲ୍‌ ଅଇ ମରା ! କାଇକେ ବଇଲେ ତମର୍‌ ବେଲାଇ ମୁଇ ଜନ୍‌ କାମ୍‌ କର୍‌ବାକେ ଗାଲିନି, ସେଟା ଜେ ମିସା ବୁଜାଇ କଇଲେ, ତମେ ବିସ୍‌ବାସ୍‌ ନ କରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ପାର୍‌ତନା ଗରେଅନି ବାରଇବା ବେଲେ, ଆରି ଗଟେକ୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ବାଉଡି ଆସି ଏ ସବୁ ବିସଇ ଆରି ବୁଜାଇବାକେ, ଲକ୍‌ମନ୍‌ ବାବୁଜିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ଲକ୍‌ମନ୍‌ ପାର୍‌ତନା ଗରେଅନି ଉଟିଗାଲା ପଚେ, ବେସି ଜିଉଦିମନ୍‌ ଆରି ଜିଉଦି ଦରମ୍‌ ନେଇରଇବା ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନ୍‌, ସାଉଲ୍‌ ଆରି ବର୍‌ନବାର୍‌ ସଙ୍ଗ୍‍ ଜିବାର୍‌ଦାର୍‌ଲାଇ । ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ତାକର୍‌ ସଙ୍ଗ୍‍ କାତା ଅଇ ପରମେସରର୍‌ ଜିବନ୍‌ଦୁକାଇଲାଟାକେ ମାନିକରି ଜିଇବାକେ ସେମନ୍‌କେ ସାର୍‌ଦା କରାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ତାର୍‌ ଆର୍‌କର୍‌ ବିସ୍‌ରାମ୍‌ବାରେ ଆନ୍‌ଟିଅକିଅ ଗଡର୍‌ ସବୁ ଲକ୍‌ ମାପ୍‌ରୁର୍‌ ବାକିଅ ସୁନ୍‌ବାକେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ରୁଣ୍ଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ବେସି ଲକ୍‌ ରୁଣ୍ଡ୍‌ଲାଟା ଦେକି, ଜିଉଦି ନେତାମନ୍‌ ଇଁସା ଅଇଲାଇ । ଆରି ପାଉଲ୍‌ କଇବା କାତା, ବିରଦ୍‌ କରି ନିନ୍ଦା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ମାତର୍‌ ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ଅଦିକ୍‌ ଡାଟ୍‌ ସଙ୍ଗ୍‍ କଇଲାଇ, “ପର୍‌ତମେ ପରମେସରର୍‌ ବାକିଅ ତମର୍‌ ଲଗେ ଜାନାଇବାର୍‌ ଦର୍‌କାର୍‌ ରଇଲା । ମାତର୍‌ ତମେ ସେଟା ନିଚ୍‌ଲାସ୍‌ନି । ଆରି ତାର୍‌ ସଙ୍ଗ୍‍ ନ ସାର୍‌ବା ଜିବନ୍‌ ପାଇବାକେ ଅଦିକାର୍‍ ନାଇ ବଲି ବିଚାର୍‌ କଲାସ୍‌ନି । ସେଟାର୍‌ପାଇ ଆମେ ତମ୍‌କେ ଚାଡି, ଏ କାତା ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌କେ କଇବାର୍‌ ଗାଲୁନି । ");
INSERT INTO dso_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","କାଇକେ ବଇଲେ ମାପ୍‌ରୁ ଆମ୍‌କେ ଏ ଆଦେସ୍‌ ଦେଲା ଆଚେ ।” ଆନ୍ଦାରେ ଉଜଲ୍‌ ଅଇଲାପାରା ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନ୍‌କେ ମର୍‌ ବିସଇ ଜାନାଇବାକେ ମୁଇ ତମ୍‌କେ ବାଚିଆଚି । ଜେନ୍ତାରି କି ମୁଇ ସେମନ୍‌କେ ରକିଆ କରି ପାର୍‌ବି ବଲି ଦୁନିଆର୍‌ ସବୁ ଲକ୍‌ମନ୍‌କେ ତମେ କଇପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌ ଏଟା ସୁନି ବେସି ସାର୍‌ଦା ଅଇଗାଲାଇ ଆରି ପର୍‌ମେସରର୍‌ କବର୍‌ ପାଇ ଜୁଆର୍‌ କଲାଇ । ଜନ୍‌ ଲକ୍‌ମନ୍‌ ନ ସାର୍‌ବା ଜିବନର୍‌ ପାଇ ବାଚାଇ ଅଇରଇଲାଇ, ସେମନ୍‌ ସେ କବର୍‌ ସୁନି ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ତେଇର୍‌ ବିସ୍‌ବାସିମନ୍‌ ସେ ଜାଗାଇ ବୁଲି ବୁଲି ମାପ୍‌ରୁର୍‌ ବାକିଅ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ମାତର୍‌ ସେ ଗଡର୍‌ ବଡ୍‌ ଲକ୍‌ମନ୍‌ ଆରି ପର୍‌ମେସର୍‌କେ ଉପାସନା କର୍‌ବା ଉପର୍‌କେ ରଇବା ଜିଉଦି ନ ଅଇଲା ମାଇଜିମନ୍‌କେ ସୁତ୍‌ରାଇକରି, ତେଇର୍‌ ଜିଉଦିମନ୍‌, ପାଉଲ୍‌ ଆରି ବର୍‌ନବାକେ ବିରଦ୍‌ କଲାଇ । ସେମନ୍‌ ତାଉଁକେ ତାଡ୍‌ନା ଦେବାର୍‌ ଆରାମ୍‌ କଲାଇ । ଆରି ସେ ଜାଗାଇଅନି ବାର୍‌ କରିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ତେଇଅନି ଜିବାବେଲେ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ସେ ଲକ୍‌ମନର୍‌ ବିରଦେ ତାକର୍‌ ପାଦର୍‌ ଦୁଲି ପାପ୍‌ଡିଦେଇ ଇକନିଅତେଇ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଆନ୍‌ଟିଅକର୍‌ ବିସ୍‌ବାସିମନ୍‌ ସୁକଲ୍‌ ଆତ୍‌ମାଇ ଆରି ସାର୍‌ଦାଇ ପୁରୁନ୍‌ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଜନ୍‌ଟା ଆନ୍‌ଟିଅକିତେଇ ଗଟିରଇଲା, ସେ ସମାନ୍‌ ବିସଇ ଆକିଅଟାନେ ମିସା ଅଇଲା । ପାଉଲ୍‌ଆରି ବର୍‌ନବା ପାର୍‌ତନା ଗରେ ଏନ୍ତି ଡାଟ୍‌ ସଙ୍ଗ୍‍ ପର୍‌ଚାର୍‌ କଲାଇ ଜେ ବେସି ଜିଉଦି ଆରି ଗିରିକ୍‌ ଲକ୍‌ମନ୍‌ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ମାତର୍‌ ଜନ୍‌ ଜିଉଦିମନ୍‌ ସେ ବାକିଅ ବିସ୍‌ବାସ୍‌ କରତ୍‌ନାଇ, ସେମନ୍‌ ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନ୍‌କେ ବେମ୍‍ଜା କରି, ବିସ୍‌ବାସି ବାଇମନ୍‌କେ ବିରଦ୍‌ କରାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ଏଲେମିସା ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ତେଇ ବେସିଦିନ୍‌ ରଇକରି ଡାଟ୍‌ ସଙ୍ଗ୍‍ ମାପ୍‌ରୁର୍‌ ବିସଇ ଜାନାଇଲାଇ । ମାପ୍‌ରୁ ଏମନ୍‌କେ କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ କରି ଦେକାଇବାକେ ବପୁଦେଲା । ଏନ୍ତାରି ମାପ୍‌ରୁ ତାର୍‌ ଜିବନ୍‌ ଦୁକାଇଲା ବାକିଅ ସତ୍‌ବଲି ଦେକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ଇକନିଆ ନଅରର୍‌ ଲକ୍‌ମନ୍‌ ଦୁଇଟା ଦଲେ ବାଗ୍‌ ଅଇଲାଇ । ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେ ଲକ୍‌ ଜିଉଦିମନର୍‌ ବାଟେ ଆରି କେତେ ଲକ୍‌ ପେରିତ୍‌ ସିସ୍‌ମନର୍‌ ବାଟେ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ତାର୍‌ପଚେ କେତେଟା ଜିଉଦି ନଇଲା ଲକ୍‌ ଆରି ଜିଉଦିମନ୍‌ ସେମନର୍‌ ନେତାମନର୍‌ ସଙ୍ଗ୍‍ ଏକ୍‌ଜୁଟ୍‌ ଅଇ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌କେ ବେସି କାରାପ୍‌ ଚଲାଚଲ୍‌ତି କରି ସେମନର୍‌ ଉପ୍‌ରେ ପାକ୍‌ନା ମାରି ମରାଇଦେବାକେ ପାଁଚ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ମାତର୍‌ ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ସେଟା ଜାନିକରି ଲୁକାନିଆଇ ରଇବା ଲୁସ୍‌ତାରା ଆରି ଦର୍‌ବି ଗଡର୍‌ ଚାରିବେଡ୍‌ତିର୍‌ ଜାଗାଇ ଦାପ୍‌ରେ ପାଲାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ଆରି ସିତି ସୁବ୍‌ କବର୍‌ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍‌ତାରାତେଇ ଜନ୍‌ମେଅନି ଗଡ୍‌ ବାଙ୍ଗ୍‍ଟି ରଇଲା ଗଟେକ୍‌ ଚଟା ଲକ୍‌ ରଇଲା । ସେ ବିଲ୍‌କୁଲ୍‌ ଇଣ୍ଡି ନାପାର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ତେଇ ବସି, ସେ ପାଉଲର୍‌ ସିକିଆ ସୁନ୍‌ତେ ରଇଲା । ତାର୍‌ ମନେ ବିସ୍‌ବାସ୍‌ ଅଇଲାଆଚେ ଆରି ସେ ନିମାନ୍‌ ଅଇପାର୍‌ସି ବଲି ପାଉଲ୍‌ ଜାନି ପାର୍‌ଲା । ସେଟାର୍‌ ପାଇ ତାର୍‌ବାଟେ ତିରିଆଇ ଦେକି, ");
INSERT INTO dso_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ଆଉଲିଅଇ କଇଲା, “ମଇତର୍‌ ପାଦ୍‌ ମାଣ୍ଡିକରି, ସିଦା ଟିଆ ଅ !” ସେ ଲକ୍‌ ଡେଗଇ କରି ଚାରିବେଟ୍‌ତି ଇଣ୍ଡ୍‌ବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ତେଇ ରୁଣ୍ଡ୍‌ଲା ଲକ୍‌ମନ୍‌ ପାଉଲର୍‌ କାମ୍‌ ଦେକି ତାକର୍‌ ଲୁକାନିଆ ବାସାଇ ସାର୍‌ଦା ଅଇ ଆଉଲିଅଇବାର୍‌ ଦାର୍‌ଲାଇ । “ଦେକା, ଏ ଲକ୍‌ମନ୍‌ ସତଇସେ ଦେବ୍‌ତା ଅଇରଇବାଇ । ନିଜେ ମନସ୍‌ ରୁପ୍‌ ଦାରି ଉତ୍‌ରି ଆଇଲାଇ ଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ସେମନ୍‌ ବର୍‌ନବାକେ ଜିଅସ୍‌ ବଲି ଜେ କି ତାକର୍‌ ମୁକିଅ ଦେବ୍‌ତା ରଇଲା, ଆରି ପାଉଲ୍‌କେ ଏରମିସ୍‌‍ ବଲି ନାମ୍‍ଲାଇ । ଏରମିସ୍‌ କାଇକେବଇଲେ ସେ ବେସି କାତା ଅଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ଗଡ୍‌ ବାଇରର୍‌ ମୁଆଟେ ରଇଲା ଜିଅସ୍‌ ମନ୍ଦିରର୍‌ ପୁଜାରି, ଦୁଆର୍‌ ଲଗେ କେତେଟା ପୁଲ୍‌ ମାଲା ପିନ୍ଦାଇକରି, କେତେଟା ସଣ୍ଡମନ୍‌କେ ଆନ୍‌ଲା । କାଇକେବଇଲେ ସେ ଆରି ସିତି ରୁଣ୍ଡ୍‌ଲା ଲକ୍‌ମନ୍‌ ପେରିତ୍‌ ସିସ୍‌ମନର୍‌ ପାଇ ବଲଦ୍‌ମନ୍‌କେ ବିରୁ କର୍‌ବାକେ ମନ୍‌ କରିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ସେମନ୍‌ ଜନ୍‌ କାମ୍‌ କର୍‌ବାକେ ଜାଇରଇଲାଇ, ବର୍‌ନବା ଆରି ପାଉଲ୍‌ ସେଟା ସୁନ୍‌ଲା ଦାପ୍‌ରେ, ନିଜର୍‌ ବସ୍‌ତର୍‌ ଚିରିପାକାଇଲାଇ, ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ପାଲାଇଜାଇ ଆଉଲିଅଇ କରି କଇଲାଇ, ");
INSERT INTO dso_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ଏ ଲକ୍‌ମନ୍‌ ତମେ କାଇକେ ଏଟା କଲାସ୍‌ନି ? ଆମେ ତମର୍‌ ପାରା ଲକ୍‌ ସେ । ତମ୍‌କେ ସୁବ୍‌ କବର୍‌ ଜାନାଇବାକେ ଆଇଲୁଆଚୁ । ଆରି ଏ ଚୁଚାଇ ରଇବା ପୁତ୍‌ଲାମନ୍‌କେ ପୁଜା କର୍‌ବାଟା ଚାଡିକରି, ଜିବନ୍‌ ରଇବା ପର୍‌ମେସର୍‌କେ ଉପାସନା କରା ବଲି, କଇବାକେ ଆସିଆଚୁ । ଏ ପର୍‌ମେସର୍‌ ସରଗ୍‌, ଦର୍‌ତନି, ସମ୍‌ଦୁର୍‌ ଆରି ତାର୍‌ ବିତ୍‌ରେ ରଇବା ସବୁ ବିସଇ ତିଆର୍‌ କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ପୁର୍‌ବେ ନିଜେ ମନ୍‌କରି ନିଜର୍‌ ବାଟେ ଜିବାକେ, ପରମେସର୍‌ ଲକ୍‌ମନ୍‌କେ ଚାଡିଦେଇ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ମାତର୍‌ ତାକର୍‌ ସବୁ ନିମାନ୍‌ କାମେଅନି ସେ ସବୁବେଲାଇ ଚିନ୍‌ ଦେକାଇଆଚେ; ସେ ଆକାସେଅନି ପାନି ଆରି ସମାନ୍‌ ବେଲାଇ କାଦି ପାଚାଇସି, ବେସି କାଦି ଜାଗାଇସି ଆରି ସାର୍‌ଦା ସଙ୍ଗ୍‍ ତମର୍‌ ମନ୍‌ ପୁରୁନ୍‌ ଅଇଜାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ଏତ୍‌କି କଇଲେ ମିସା, ପାଉଲ୍‌ ଆରି ବର୍‌ନବାର୍‌ପାଇ ବଲି ଦେବାର୍‌ ଆଚେଆକା ବଲି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ପଚେ ପିସିକିଆର୍‌ ଆନ୍‌ଟିଅକ ଆରି ଇକନିୟଅନି କେତେଟା ଜିଉଦିମନ୍‌ ଆଇଲାଇ । ସେମନ୍‌ ଲକ୍‌ମନ୍‌କେ ସୁତ୍‌ରାଇକରି ତାକର୍‌ବାଟେ ନେଲାଇ । ପାଉଲ୍‌କେ ପାକ୍‌ନାମାରାଇଲାଇ ଆରି ତାକେ ମଲାବଲି ବାବି ଗଡ୍‌ ବାଇରେ ଅର୍‌ଗଡି ଜିକିନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ମାତର୍‌ ବିସ୍‌ବାସିମନ୍‌ ଆସି ତାର୍‌ ଚାରିବେଟ୍‌ତି ଟିଆଅଇଲାକେ, ସେ ଉଟିକରି ତାକର୍‌ ସଙ୍ଗ୍‍ ଗଡ୍‌ ବିତ୍‌ରେ ବାଅଡ୍‌ଲା । ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ସେ ଆରି ବର୍‌ନବା ଲୁସ୍‌ରା ଚାଡି ଦର୍‌ବିଏ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ପାଉଲ୍‌ ଆରି ବରନ୍‌ବା ଦର୍‌ବିତେଇ ସୁବ୍‌ କବର୍‌ ଜାନାଇକରି ବେସି ଲକ୍‌ମନ୍‌କେ ସିସ୍‌କଲାଇ । ତାର୍‌ ପଚେ ସେମନ୍‌ ଲୁସ୍‌ତାରା, ଦର୍‌ବି, ଇକନିଅ ଆରି ପିସିଦିଆର୍‌ ଆନ୍‌ଟିଅକିତେଇ ବାଉଡି ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ସେମନ୍‌ ବିସ୍‌ବାସିମନ୍‌କେ ବିସ୍‌ବାସେ ଡାଟ୍‌ଅଇ ରଇବାକେ ସାର୍‌ଦା କଲାଇ । ସେମନ୍‌ ସିକିଆ ଦେଇ କଇଲାଇ, “ପରମେସରର୍‌ ରାଇଜେ କେଟ୍‌ବାକେ ଆଲେ ଆମ୍‌କେ ବେସି ଦୁକ୍‌କସ୍‌ଟ ଦେଇ ଜିବାକେ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ସବୁ ମଣ୍ଡଲିର୍‌ ପାର୍‌ଚିନ୍‌ମନ୍‌କେ ବାଚ୍‌ଲାଇ ଆରି ଜନ୍‌ ମାପ୍‌ରୁର୍‌ତେଇ ସେମନ୍‌ ବିସ୍‌ବାସ୍‌ କରି ରଇଲାଇ, ସେମନ୍‌କେ ପାର୍‌ତନା ଆରି ଉପାସ୍‌ ସଙ୍ଗ୍‍ ସର୍‌ପାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ପିସିଦିଆ ବାଟ୍‍ଦେଇ ସେମନ୍‌ ପପୁଲିଆଇ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ତାର୍‌ପଚେ ପର୍‌ଗାଇ କେଟ୍‌ଲାଇ । ଆରି ମାପ୍‌ରୁର୍‌ କାତା ଜାନାଇ ଆତାଲିଆତେଇ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ଆତାଲିଆଇ ସେମନ୍‌ ପାନିଜାଜେ ଚଗି ଆନ୍‌ଟିଅକିଅତେଇ ବାଉଡି ଆଇଲାଇ । ଏ ଆନ୍‌ଟିକିଅର୍‌ ବିସ୍‌ବାସିମନ୍‌ ପାଉଲ୍‌ ଆରି ବର୍‌ନବାକେ ପର୍‌ମେସର୍‌ଟାନେ ସର୍‌ପାଇଦେଇକରି ବିନ୍‌ ଜାଗାମନ୍‌କେ ମାପ୍‌ରୁର୍‌ ବାକିଅ ଜାନାଇବାକେ ପାଟାଇରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ସେମନ୍‌ ଆନ୍‌ଟିକିଅ କେଟି ମଣ୍ଡଲିର୍‌ ଲକ୍‌ମନ୍‌କେ ରୁଣ୍ଡାଇଲାଇ । ପରମେସର୍‌ ତାକର୍‌ଟାନେ କରିରଇବା ସବୁ କାମ୍‌ ସେମନ୍‌କେ ଜାନାଇଲାଇ । ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନ୍‌ ଜିସୁଟାନେ ବିସ୍‌ବାସ୍‌ କର୍‌ବାକେ ପର୍‌ମେସର୍‌ କେନ୍ତି ବାଟ୍‌ ଉଗାଡ୍‌ଲା, ସେଟା ସବୁଜାକ ସେମନ୍‌କେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ତେଇ ବିସ୍‌ବାସିମନର୍‌ ସଙ୍ଗ୍‍ ବେସି ଦିନ୍‌ ଜାକ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଜିଉଦାଇଅନି କେତେକ୍‌ ଲକ୍‌ ଆନ୍‌ଟିଅକ୍‍ ନଅରେ ଆଇଲାଇ । ସେମନ୍‌ ଆନ୍‌ଟିଅକର୍‌ ବିସ୍‌ବାସି ବାଇମନ୍‌କେ ଏନ୍ତି କଇକରି ସିକାଇଲାଇ, “ମସାର୍‌ ନିୟମ୍‌ ଇସାବେ ଜଦି ତମେ ସୁନତ୍‌ ନ ଉଆସ୍‌, ତମର୍‌ ପାପର୍‌ ଡଣ୍ଡେଅନି ମୁକ୍‌ତି ନ ପାଆସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ଏ ବିସଇ, ସେମନର୍‌ ସଙ୍ଗ୍‍ ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ବେସି ଦଦାପେଲା ଅଇଲାଇ । ତେବର୍‌ପାଇ ଆନ୍‌ଟିଅକର୍‌ ବିସ୍‌ବାସିମନ୍‌ ରାଜି ଅଇଲାଇଜେ, ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ଆରି ଆନ୍‌ଟିଅକ୍‍ ମଣ୍ଡଲିଅନି କେତେ ଲକ୍‌ ଜିରୁସାଲାମେ ଜାଅତ୍‌ ଆରି ତେଇର୍‌ ପାର୍‌ଚିନ୍‌ ଆରି ପେରିତ୍‌ ସିସ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ଏ ବିସଇ କାତା ଅଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ଆନ୍‌ଟିଅକର୍‌ ମଣ୍ଡଲି ସେମନ୍‌ ଜିବାଟା ସୁବିଦା କରିଦେଇ ପାଟାଇଲାଇ । ସେମନ୍‌ ପିନିସିଆ ଆରି ସମିରଣ୍‌ ବାଟ୍‌ ଦେଇ ଜିବାବେଲେ, ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌ କେନ୍ତି ମନ୍‌ ବାଦ୍‌ଲାଇକରି ପରମେସର୍‌କେ ନାମ୍‍ଲାଇ, ସେ ବିସଇ ଜାନାଇଲାଇ । ଏ କାତା ସୁନି ବିସ୍‌ବାସି ବାଇମନ୍‌ ବେସି ସାର୍‌ଦା ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ସେମନ୍‌ ଜିରୁସାଲାମ୍‌ କେଟ୍‌ଲା ପଚେ ମଣ୍ଡଲିର୍‌ ଲକ୍‌, ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ଆରି ମଣ୍ଡଲିର୍‌ ପାର୍‌ଚିନ୍‌ମନ୍‌କେ ବେଟ୍‌ଅଇଲାଇ । ଆରି ପରମେସର୍‌ ତାକର୍‌ଲଗେ କରିରଇବା କାମ୍‌ ବିସଇ ପାଉଲ୍‌ ଆରି ବର୍‌ନବାକେ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ମାତର୍‌ ପାରୁସି ଦଲର୍‌ କେତେଟା ବିସ୍‌ବାସିମନ୍‌ ଟିଆଅଇ କଇଲାଇ, “ ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌ ସୁନତ୍‌ ଅଇବାର୍‌ ଆଚେ ଆକା ଆରି ମସାର୍‌ ବିନ୍‌ ନିୟମ୍‌ମନ୍‌ ମାନ୍‌ବାକେ ମିସା ସେମନ୍‌କେ ସିକାଇବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ଏ ବିସଇ ଆଲ୍‍ଚନା କର୍‌ବାକେ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌ ଆରି ମଣ୍ଡଲିର୍‌ ପାର୍‌ଚିନ୍‌ ରୁଣ୍ଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ବେସି ପର୍‌ ଦଦାପେଲା ଅଇଲା ପଚେ ପିତର୍‌ ଟିଆଅଇ କଇଲା, “ମର୍‌ ବାଇବଇନିମନ୍‌ ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌, ସୁନିକରି ବିସ୍‌ବାସ୍‌ କର୍‌ବାକେ ସେମନର୍‌ଟାନେ ସୁବ୍‌କବର ଜାନାଇବାକେ, ଆଗେଅନି ମକେସେ ବାଚ୍‌ଲାଆଚେ । ଏଟା ତମେ ଜାନାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ସବୁ ଲକ୍‌ମନର୍‌ କାତା ଜାନ୍‌ବା ପରମେସର୍‌ ଆମ୍‌କେ ଜେନ୍ତି ସୁକଲ୍‌ ଆତ୍‌ମା ଦାନ୍‌ କଲା ଆଚେ, ସମାନ୍‍ ସେନ୍ତି ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌କେ ମିସା ଦାନ୍‌ଦେଇ ସେମନ୍‌କେ ବାଚ୍‌ଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ସେମନର୍‌ ଆରି ଆମର୍‌ ବିତ୍‌ରେ, ସେ କାଇମିସା ବଡ୍‌ସାନ୍‌ ଦେକେ ନାଇ । ସେମନ୍‌ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲାର୍‌ପାଇ, ସେ ସେମନ୍‌କେ ସୁକଲ୍‌ କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ସେନ୍ତି ଆଲେ ଗଟେକ୍‌ ବଡ୍‌ ବଜ୍‌ ପିଟିତେଇ ଲାଦିଦେଲାପାରା, ଆମର୍‌ ସବୁ ନିୟମ୍‌ ମାନ୍‌ବାର୍‌ ଆଚେ ବଲି କଇକରି ପର୍‌ମେସର୍‌କେ କାଇକେ ପରିକା କଲାସ୍‌ନି ? ଆଜି ଜନ୍‌ ବଜ୍‌ ବଇବାକେ, ଆମର୍‌ ଆନିଦାଦିମନ୍‌ କି ଆମେ ମିସା ବଇ ନାପାର୍‌ତେ ରଇଲୁ। ");
INSERT INTO dso_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ନାଇ, ମନେ ଏତାଇଦେକା, ଆମେ ଜେନ୍ତି ବିସ୍‌ବାସ୍‌ କରି ମାପ୍‌ରୁ ଜିସୁ ଜିବନ୍‌ଦୁକାଇଲାକେ ମୁକ୍‌ତି ପାଇଆଚୁ, ସେମନ୍‌ ମିସା ସେନ୍ତାରିସେ ।” ");
INSERT INTO dso_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ତାର୍‌ପଚେ ପାଉଲ୍‌ ଆରି ବର୍‌ନବାଟାନେଅନି ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ତେଇ ପରମେସର୍‌ ଜନ୍‌ ସବୁ କାବା ଅଇଜିବା କାମ୍‌ମନ୍‌ ଆରି ଚକିତ୍‌ ବିସଇ କରି ରଇଲା, ସେ ସବୁ କାତା ସୁନି ଦଲର୍‌ ସବୁ ଲକ୍‌ ଚିମ୍‌ରାଅଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ସେମନ୍‌ କଇସାରାଇଲା ପଚେ ଜାକୁବ୍‌ କଇଲା, ଏ ମର୍‌ ବାଇବଇନିମନ୍‌ ମର୍‌ କାତା ସୁନା ! ");
INSERT INTO dso_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ପରମେସର୍‌ ପର୍‌ତମେ ଜିଉଦି ନଅଇଲା ଲକ୍‌ମନ୍‌କେ ଆଲାଦ୍‌ କରି, ତାର୍‌ ନିଜର୍‌ ଲକ୍‌ ଅଅତ୍‌ ବଲି, ତାକର୍‌ ବିତ୍‌ରେ ଅନି, ଲକ୍‌ମନ୍‌କେ ବାଚ୍‌ଲାଇ । ଏ କାତା ସିମନ୍‌ ବୁଜାଇ ଦେଇଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ପର୍‌ମେସର୍‌ କରିରଇବା ଏ କାମ୍‌ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ କଇରଇବାଟା ସଙ୍ଗ୍‍ ସମାନ୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ମାପ୍‌ରୁ କଇଲା, “ତାର୍‌ ପଚେ ମୁଇ ନିଜେ ଦିନେକ୍‌ ବାଉଡି ଆଇବି, ଆରି ଦାଉଦର୍‌ ବାଙ୍ଗିଜାଇରଇବା ରାଇଜ୍‌ ଆରିତରେକ୍‌ ତିଆର୍‌ କର୍‌ବି । ଜେନ୍ତିକି ସେଟା ପୁରାପୁରୁନ୍‌ ଡାଟ୍‌ ରଇସି । ");
INSERT INTO dso_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ତେଇଅନି ସବୁଜାକ ମନସ୍‌ ଜାତି ମର୍‌ ଲଗେ ଆଇବାଇ, ଜନ୍‌ ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌କେ ମାପ୍‌ରୁ ନିଜର୍‌ କର୍‌ବାକେ ଡାକ୍‌ଲାଆଚେ ସେମନ୍‌ ସବୁ ଲକ୍‌ ମକେ ନାମ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ମାପ୍‌ରୁ ଏ କାତା କଇଲାନି, ଜେ କି ବେସି ଆଗ୍‌ତୁ ଏ କାତା କଇରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ଏବେ ଜାକୁବ୍‌ କଇବାକେ ଆରାମ୍‌କଲା । ସେ କଇଲା, “ମର୍‌ ବିଚାର୍‌ ଇସାବେ, ଜନ୍‌ ଜିଉଦି ନଇଲା ଲକ୍‌ମନ୍‌ ପରମେସରର୍‌ ବାଟେ ବାଅଡ୍‌ଲାଇ ଆଚତ୍‌, ଆମେ ଆରି ସେମନ୍‌କେ ଅଇରାନ୍‌ ନ କରୁ । ");
INSERT INTO dso_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ଏଲେ ସେମନ୍‌ ଆରି ଜେନ୍ତିକି ପୁତ୍‌ଲା ଦେବ୍‌ତାମନ୍‌କେ ସର୍‌ପିଦେଲା କାଇମିସା ଅସୁକଲ୍‌ କାଦି ନ କାଆ, ବିନ୍‌ ଲକର୍‌ ମାଇଜି କି ମୁନୁସର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ବାଟାନେଅନି ଦୁରିକେ ରଅତ୍‌, ଟଟ୍‌ରି ପିଚ୍‌କି ମରାଇରଇବା ପସୁର୍‌ ମାଉଁସ୍‌ କି ବନି, ନ କାଅତ୍‌ ଏ ସବୁ ବିସଇଟାନେ ସେମନ୍‌କେ ଉପ୍‌ଦେସ୍‌ ଦେଇ, ସେମନର୍‌ ଲଗେ ଗଟେକ୍‌ ଚିଟି ଲେକୁ । ");
INSERT INTO dso_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","କାଇକେବଇଲେ ବେସି ଦିନେଅନି ସବୁ ବିସ୍‌ରାମ୍‌ବାରେ ଆମର୍‌ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ମସାର୍‌ ନିୟମ୍‌ ପଡ୍‌ଲାଇନି, ଆରି ସବୁ ଗଡେ ସେ ନିୟମ୍‌ମନ୍‌ ଜାନାଇଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ପଚେ ପେରିତ୍‌ ସିସ୍‌ମନ୍‌, ମଣ୍ଡଲିର୍‌ ପାର୍‌ଚିନ୍‌ମନ୍‌, ଆରି ସବୁ ମଣ୍ଡଲିର୍‌ ବାଇମନ୍‌ ରୁଣ୍ଡ୍‌ଲାଇ । ସେମନ୍‌ ରାଜିଅଇରଇବା କାତା ଆନ୍‌ଟିଅକର୍‌ ବିସ୍‌ବାସିମନ୍‌କେ ଜାନାଇବାକେ ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ସଙ୍ଗ୍‍ ଜିବାକେ କେତେଲକ୍‌କେ ବାଚ୍‌ଲାଇ । ବର୍‌ସବା ନାଉଁର୍‌ ଜିଉଦା ଆରି ସିଲାକେ ବାଚ୍‌ଲାଇ । ଏ ଦୁଇଲକ୍‌କେ ସବୁ ବିସ୍‌ବାସିମନ୍‌ ସନ୍‌ମାନ୍‌ ଦେଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ବିସ୍‌ବାସିମନ୍‌ ଏ ତଲେ ଲେକାଅଇଲା ଚିଟି, ସେ ଦୁଇ ଲକର୍‌ ଆତେ ପାଟାଇଲାଇ । “ଆନ୍‌ଟିଅକ, ସିରିଆ ଆରି ସିଲିସିଆ ରଇବା ଜିଉଦିନଇଲା ଆମର୍‌ ବାଇମନ୍‌, ଜୁଆର୍‌ ! ଜିରୁସାଲମର୍‌ ପେରିତ୍‌ମନ୍‌, ପାର୍‌ଚିନ୍‌ମନ୍‌ ଆରି ତମର୍‌ ବାଇମନ୍‌, ଏ ଚିଟି ପାଟାଇଲୁନି । ");
INSERT INTO dso_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ଆମେ ସୁନ୍‌ଲୁନି ଜେ, ଆମର୍‌ ଦଲେଅନି କେତେ ଲକ୍‌ ତମର୍‌ଟାନେ ଆସି, ଜାଇଜାଇଟା ସିକାଇଆଚତ୍‌, ତେଇଅନି ସେମନ୍‌ ତମ୍‌କେ କଚପଚ ଆରି ତେରେପେତେ କଲାଇଆଚତ୍‌ । ମାତର୍‌ ଆମେ ସେମନ୍‌କେ ସେନ୍ତାରି କର୍‌ବାକେ, କାଇମିସା ଆଦେସ୍‌ ଦେଉନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ସେଟାର୍‌ ପାଇ ଆମେ ସବୁ ଲକ୍‌ ଗଟେକ୍‌ ଅଇକରି କେତେଟା କବର୍‌ କଉମନ୍‌କେ ବାଚି, ତମର୍‌ ଲଗେ ପାଟାଇବାକେ ଟିକ୍‌ କଲୁ । ସେମନ୍‌ ଆମର୍‌ ଆଲାଦର୍‌ ମଇତର୍‌ମନ୍‌, ବର୍‌ନବା ଆରି ପାଉଲର୍‌ ସଙ୍ଗ୍‍ ଜିବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଏ ମଇତର୍‌ମନ୍‌ ମାପ୍‌ରୁ ଜିସୁର୍‌ ସେବାତେଇ ନିଜର୍‌ ଜିବନ୍‌ ସର୍‌ପିଦେଇ ଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ସେଟାର୍‌ ପାଇ ଜିଉଦା ଆରି ସିଲାକେ ତମର୍‌ ଲଗେ ପାଟାଇଲୁନି । ଆମେ ଜାଇଟା ଲେକିଆଚୁ, ସେଟା ତମ୍‌କେ ସେମନ୍‌ ନିଜେ ବାତାଇଦେବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","କେତେଟା ଦର୍‌କାର୍‌ ରଇଲା ନିୟମ୍‌ ଚାଡି, ତମର୍‌ ଉପ୍‌ରେ ଆରି କାଇମିସା ବଜ୍‌ ନ ଲାଦ୍‌ବାକେ ଆମେ ସୁକଲ୍‌ଆତ୍‌ମାଇ ଅନି ଚାଲ୍‌ନା ପାଇଲୁଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ସେ କେତେଟା ନିୟମ୍‌ ଅଇଲାନି ପୁତ୍‌ଲା ଦେବ୍‌ତାମନ୍‌କେ ପୁଜା କରିରଇବା କାଇମିସା କାଦି କାଇବାର୍‌ ନାଇ । ଟଟ୍‌ରି ପିଚ୍‌କି ମରାଇଲା କନ୍‌ ମିସା ପସୁର୍‌ ବନି କି ମାଉଁସ୍‌ କାଇବାର୍‌ ନାଇ । ଆରି ବିନ୍‌ ମାଇଜି କି ମୁନୁସର୍‌ ମିଲାମିସା ଟାନେଅନି ଦୁରିକେ ରଇବାର୍‌ । ଏ ସବୁ କାମ୍‌ ନ କର୍‌ବାକେ ତମେ ଜାଗ୍‍ରତ୍‌ ରଇଲେ, ଅଇଜାଇସି । ଏତ୍‌କିକେ ରଇଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ଜନ୍‌ କବର୍‌ କଉମନ୍‌କେ ପାଟାଇ ରଇଲାଇ, ସେମନ୍‌ ଆନ୍‌ଟିଅକ୍‍ତେଇ ଜାଇ ବିସ୍‌ବାସିମନର୍‌ ସବୁ ଦଲ୍‌କେ ରୁଣ୍ଡାଇକରି ସେ ଚିଟି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ତେଇର୍‌ ବିସ୍‌ବାସିମନ୍‌ ସେ ଚିଟି ପଡିକରି ବେସି ସାର୍‌ଦା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଜିଉଦା ଆରି ସିଲା ନିଜେ ଦୁଇ ଲକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ରଇଲାଇ । ସେମନ୍‌ ଆନ୍‌ଟିଅକର୍‌ ବିସ୍‌ବାସି ବାଇମନ୍‌କେ ବେସିଦିନ୍‌ ରଇକରି, କବର୍‌ ଜାନାଇ, ସେମନର୍‌ ବିସ୍‌ବାସ୍‌ ଡାଟ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ତେଇ କେତେ ଦିନ୍‌ ରଇଲା ପଚେ, ଜନ୍‌ଲକ୍‌ମନ୍‌ ସେମନ୍‌କେ ପାଟାଇରଇଲାଇ, ସେମନର୍‌ ଲଗେ ବାଉଡି ଜିବାକେ, ବିସ୍‌ବାସି ବାଇମନ୍‌ ସେମନ୍‌କେ ସାନ୍ତି ସଙ୍ଗ୍‍, ପାଟାଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ମାତର୍‌ ସିଲା ତେଇସେ ରଇବାଟା ଟିକ୍‌ ବଲି ତେଇ ରଇବାକେ ମନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ପାଉଲ୍‌ ଆରି ବର୍‌ନବା ଆନ୍‌ଟିଅକ୍‍ତେଇ କେତେ ଦିନ୍‌ ରଇକରି ବେସି ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍, ମିସିବିଡି ମାପ୍‌ରୁର୍‌ ବାକିଅ ଜାନାଇଲାଇ ଆରି ସିକିଆ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","କେତେ ଦିନ୍‌ ପଚେ ପାଉଲ୍‌ ବର୍‌ନବାକେ କଇଲା, “ଜୁ, ଆମେ ବାଉଡି ଜୁ, ସବୁ ଗଡ୍‌ମନ୍‌କେ, ଆମର୍‌ ଜନ୍‌ ବାଇମନ୍‌କେ ମାପ୍‌ରୁର୍‌ ବାକିଅ ଜାନାଇ ରଇଲୁ, ସେମନ୍‌କେ ବେଟ୍‌ ଅଉଁ ଆରି ସେମନ୍‌ ବିସ୍‌ବାସେ କେନ୍ତି ଆଚତ୍‌ ବୁଜି ଦେକୁ ।” ");
INSERT INTO dso_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ଜଅନ୍‌ ମାର୍‌କକେ ମିସା ତାକର୍‌ ସଙ୍ଗ୍‍ ନେବାକେ ବର୍‌ନବା ମନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ମାତର୍‌ ପାଉଲ୍‌ କଇଲା “ନିଚୁ, କାଇକେ ବଇଲେ, ପପୁଲିଆଇ ଜନ୍‌ ଦିନେ ଆମର୍‌ କାମ୍‌ ସାରି ନ ରଇଲା, ସେ ଆମ୍‌କେ ଚାଡି ବାଉଡି ଉଟିଆଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ଏ ବିସଇ, ବେସି କୁଆବଲା ଅଇଲାଇ ଆରି ସେମନ୍‌ ବିନେ ଅଇଲାଇ । ବର୍‌ନବା ଜଅନ୍‌ମାରକକେ ନେଇ ସାଇପରସେ ଜିବା ପାନିଜାଜେ ଚଗ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ମାତର୍‌ ପାଉଲ୍‌ ତାର୍‌ସଙ୍ଗ୍‍ ଜିବାକେ ସିଲାକେ ବାଚ୍‌ଲା । ଆରି ମାପ୍‌ରୁର୍‌ ଜିବନ୍‌ଦୁକାନି ତେଇ ସେମନ୍‌କେ ସର୍‌ପିଦେଇ, ବିସ୍‌ବାସିମନ୍‌ ପାଟାଇ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ପାଉଲ୍‌ ଆରି ସିଲା, ସିରିଆ ଆରି ସିଲିସିଆଇ ବୁଲି ବୁଲି କରି ତେଇର୍‌ ମଣ୍ଡଲିମନ୍‌କେ ଡାଟ୍‌ କରାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ତେଇଅନି ପାଉଲ୍‌ ଦର୍‌ବି ଆରି ଲୁସ୍‌ତାରାଇ ଆଇଲା । ସେ ନଅରେ ତିମତି ନାଉଁର୍‌ ଗଟେକ୍‌ ବିସ୍‌ବାସି ଲକ୍‌ ରଇଲା । ତାର୍‌ ମାଆ ଗଟେକ୍‌ ଜିଉଦି ବିସ୍‌ବାସି ରଇଲା । ମାତର୍‌ ତାର୍‌ ବାବା ଗଟେକ୍‌ ଗିରିକ୍‌ ଲକ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ଲୁସ୍‌ତାରା ଆରି ଇକନିଅତେଇ ରଇବା ସବୁ ବିସ୍‌ବାସି ବାଇମନ୍‌ ତିମତିକେ ସନ୍‌ମାନ୍‌ କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ପାଉଲ୍‌ ତାର୍‌ ସଙ୍ଗ୍‍ ତିମତିକେ ନେବାକେ ମନ୍‌ କଲା, ସେଟାର୍‌ପାଇ ଜିବା ଆଗ୍‌ତୁ ମସାର୍‌ ନିୟମ୍‌ ଇସାବେ ତାକେ ସୁନତ୍‌ କଲା । ଜେନ୍ତିକି ସେ ଜାଗାର୍‌ ଜିଉଦିମନ୍‌ ତାକେ ନିନ୍ଦା ନ କରତ୍‌ । କାଇକେବଇଲେ ତେଇର୍‌ ଲକ୍‌ମନ୍‌ ତିମତିର୍‌ ବାବା ଗିରିକ୍‌ ଲକ୍‌ ବଲି ଜାନିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ସେମନ୍‌ କେଟ୍‌ଲା ସବୁ ଜାଗାଇ ଜିଉଦି ନ ଅଇଲା ବିସ୍‌ବାସିମନର୍‌ପାଇ, ଜିରୁସାଲମର୍‌ ପାର୍‌ଚିନ୍‌ମନ୍‌ ଆରି ପେରିତ୍‌ମନ୍‌ ରାଜି ଅଇରଇବା ନିତିନିୟମ୍‌ ବିସଇ କଇଲାଇ । ଏ ସବୁ ନିୟମ୍‌ ମାନ୍‌ବାକେ ବିସ୍‌ବାସିମନ୍‌କେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ସେଟାର୍‌ପାଇ ମଣ୍ଡଲିମନର୍‌ ଲକ୍‌ମନ୍‌ ବିସ୍‌ବାସେ ଡାଟ୍‌ ଅଇଲାଇ ଆରି ଦିନ୍‌କେ ଦିନ୍‌ ତାକର୍‌ ବିସ୍‌ବାସ୍‌ ବଡ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ସୁକଲ୍‌ଆତ୍‌ମା ସେମନ୍‌କେ ଆସିଆ ଦେସେ ମାପ୍‌ରୁର୍‌ କାତା କଇବାକେ ଚାଲ୍‌ନା ଦେଅତ୍‌ନାଇକେ, ସେମନ୍‌ ପିରିଜିଆ ଆରି ଗାଲାତିଅ ଜାଗାଇ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ମିସିଆର୍‌ ସନ୍ଦିଲଗେ କେଟି ବିତିନିଆ ରାଇଜେ ଜିବାକେ ଚେସ୍‌ଟା କଲାଇ । ମାତର୍‌ ବାରଇଲାବେଲେ ଜିସୁର୍‌ଲାଗି ତାକର୍‌ ବିତ୍‌ରେ ରଇବା ସୁକଲ୍‌ ଆତ୍‌ମା, ସେମନ୍‌କେ ଜିବାକେ ଚାଲ୍‌ନା ଦେଏନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ମିସିଆବାଟ୍‌ ଦେଇ ତରଆତେଇ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ତରଆଇ ରଇଲାବେଲେ, ସେ ରାତିଆ ପାଉଲ୍‌ ଗଟେକ୍‌ ଦର୍‌ସନ୍‌ ଦେକ୍‌ଲା । ସେ ଦର୍‌ସନେ ମାସିଦନିଆର୍‌ ଗଟେକ୍‌ ଲକ୍‌ ଟିଆଅଇ ବାବୁଜିଆ କରି କଇଲା “ମାସିଦନିଆଇ ଆସି ଆମ୍‌କେ ସାଇଜ କରା !” ");
INSERT INTO dso_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ପାଉଲ୍‌ ଏ ଦର୍‌ସନ୍‌ ଦେକ୍‌ଲା ଦାପ୍‌ରେ, ମାସିଦନିଆଇ ଜିବାକେ ଆମେ ତିଆର୍‌ ଅଇଲୁ, କାଇକେବଇଲେ ଆମେ ନିକ ସଙ୍ଗ୍‍ ଜାନ୍‌ଲୁ, ପର୍‌ମେସର୍‌ ତେଇର୍‌ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ, ସୁବ୍‌ କବର୍‌ ଜାନାଇବାକେ ଆମ୍‌କେ ଡାକ୍‌ଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ଆମେ ତରଆଅନି ଜାଜେ ଚଗି ସିଦା ସାମ୍‌ତରା ଗାଲୁ ଆରି ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ନିଆପଲି କେଟ୍‌ଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ତେଇଆମେ ଉତ୍‌ରିକରି ମାସିଦନିଆ ଜିଲାର୍‌ ମୁକିଅ ଗଡ୍‌ ପିଲିପେ ଗାଲୁ । ଏ ଗଡ୍‌ ଗଟେକ୍‌ ରମିୟ ଦଲ୍‌ ରଇବା ଗଡ୍‌ ରଇଲା । ତେଇ ଆମେ ବେସି ଦିନ୍‌ ଜାକ ରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ବିସ୍‌ରାମ୍‌ବାରେ ଗଡ୍‌ ବାଇରର୍‌ ଗାଡ୍‌ କଣ୍ଡି ଗାଲୁ । ତେଇ ଜିଉଦିମନ୍‌ ରୁଣ୍ଡିକରି ପାର୍‌ତନା କର୍‌ବାକେ ଗଟେକ୍‌ ଜାଗା ବଲି ବାବ୍‌ଲୁ । ଆମେ ତେଇ ବସ୍‌ଲୁ ଆରି ତେଇ ରୁଣ୍ଡି ରଇବା ମାଇଜି ମନର୍‌ ସଙ୍ଗ୍‍ କାତାବାର୍‌ତା ଅଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ସେମନର୍‌ ବିତ୍‌ରେଅନି ତୁୟଟିରା ଗଡର୍‌ ଲୁଦିଆ ନାଉଁର୍‌ ଗଟେକ୍‌ ମାଇଜି, ଆମର୍‌ କାତା ସୁନ୍‌ତେରଇଲା । ସେ ବେସି ଦାମ୍‌ ଅଇବା ଜାମ୍‌କଲିଆ ରଙ୍ଗର୍‌ ଲୁଗା ବିକ୍‌ତେରଇଲା । ସେ ପରମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ବା, ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ । ପାଉଲ୍‌ ମାପ୍‌ରୁର୍‌ କାତା କଇଲାବେଲେ ସେଟା ନାମ୍‌ବାକେ ମାପ୍‌ରୁ ତାର୍‌ ମନ୍‌ ଉଗାଡିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ବିସ୍‌ବାସ୍‌ କଲାପଚେ, ସେ ଆରି ତାର୍‌ କୁଟୁମର୍‌ ଲକ୍‌ ଡୁବନ୍‌ ନେଲାଇ । ତାର୍‌ ପଚେ ସେ ଆମ୍‌କେ ଡାକିକରି କଇଲା, “ଜଦି ସତଇସେ ମୁଇ ମାପ୍‌ରୁକେ ବିସ୍‌ବାସ୍‌ କଲିନି ବଲି ତମେ ବାବ୍‌ଲାସ୍‌ନି, ତେବେ ଆସି ମର୍‌ ଗରେ ରୁଆ ।” ସେ ଏନ୍ତି କଇ ଆମ୍‌କେ ତାର୍‌ ଗରେ ଜିବାକେ ସୁତ୍‌ରାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ଆରି ଗଟେକ୍‌ଦିନେ ଆମେ ପାର୍‌ତନା ଜାଗାଇ ଜାଇରଇଲୁ । ତେଇ ଡୁମା ଡସିରଇବା ଗଟେକ୍‌ ଗତିଦାଙ୍ଗ୍‌ଡିକେ ବେଟ୍‌ଅଇଲୁ । ସେ ତାର୍‌ ବିତ୍‌ରେ ରଇଲା କାରାପ୍‌ଆତ୍‌ମାର୍‌ ବପୁ ସଙ୍ଗ୍‍ ବବିସତ୍‌ କାତା କଇପାର୍‌ତେ ରଇଲା । ସେ ଲକ୍‌ମନର୍‌ ଆତ୍‌ ଦେକି, ବବିସତ୍‌ କାତା କଇଦେଇକରି, ସାଉକାର୍‌ମନ୍‌କେ ବେସି ଡାବୁ କାମାଇଦେଇତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ଆମେ ତାର୍‌ଲଗେ ଗାଲାକେ, ସେ ପାଉଲ୍‌ ବଲି କିର୍‌କିରି ଆମର୍‌ ପଚ୍‌ ପଚ୍‌ ଆଇଲା । ଆରି କଇଲା, “ଏ ଲକ୍‌ମନ୍‌ ସବୁର୍‌ଟାନେଅନି ବଡ୍‌ ପରମେସରର୍‌ ସେବାକରୁମନ୍‌ । ତମେ କେନ୍ତି ମୁକ୍‌ତି ପାଇସା, ଏ କାତା ସେମନ୍‌ କଇଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ସେ ଦାଙ୍ଗ୍‌ଡି ବେସି ଦିନ୍‌ ଦାରି ଏନ୍ତି କଲା । ସାରାସାରିପଚେ ପାଉଲ୍‌ ବିଜାର୍‌ ଅଇଲା । ସେ ପଚ୍‌ବାଟେ ପାସ୍‌ଲି ଦେକି କାରାପ୍‌ଆତ୍‌ମାକେ ଦମ୍‌କାଇକରି କଇଲା, “ଜିସୁ କିରିସ୍‌ଟର୍‌ ନାଉଁ ଦାରି ଆଦେସ୍‌ ଦେଲିନି, ତାର୍‌ତେଇଅନି ବାରଇ ଜା ।” ସେ କଇଲା ଦାପ୍‌ରେ, କରାପ୍‌ ଆତ୍‌ମା ତାର୍‌ତେଇଅନି ବାରଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ଜେଡେବେଲ୍‌ ତାକର୍‌ ସାଉକାର୍‌ମନ୍‌କେ ନିଜର୍‌ ଦନ୍‌ ଅରଜ୍‌ବାଟା, ବୁଡିଗାଲା ବଲି ଜାନ୍‌ଲାଇ, ପାଉଲ୍‌ ଆରି ସିଲାକେ ଗଡର୍‌ ମଜାଇ ରଇବା ରମିଅ ଅଦିକାରିର୍‌ ଲଗେ ଜିକି ଆନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ସେମନ୍‌କେ ତାକର୍‌ ମୁଆଟେ ଆନି ଦସ୍‌ଦେଇ କରି କଇଲାଇ “ଏମନ୍‌ ଜିଉଦି ଲକ୍‌, ଆମର୍‌ ଗଡେ ଆସି ଗଣ୍ଡ୍‍ଗଲ୍‌ କଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ଆମର୍‌ ନିୟମ୍‌ ବିରଦେ ରିତିନିତି ସିକାଇଲାଇନି । ଆମେ ରମିଅ ଲକ୍‌, ସେଟାର୍‌ ପାଇ ଏ ରିତିନିତି ମାନି ନାପାରୁ । ");
INSERT INTO dso_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ସାଉକାର୍‌ ମନର୍‌ କାତାମିସାଇ ତେଇ ରଇଲା ଲକ୍‌ମନ୍‌, ପାଉଲ୍‌ ଆରି ସିଲାର୍‌ ବିରଦେ ଉଟ୍‌ଲାଇ । ସେ ଅଦିକାରିମନ୍‌ ପାଉଲ୍‌ ଆରି ସିଲାର୍‌ ବସ୍‌ତର୍‌ ଚିରିକରି କର୍‌ଡା ସଙ୍ଗ୍‍ ମାର୍‌ବାକେ ଆଦେସ୍‌ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ବେସି ମାଡ୍‌କାଇଲା ପଚେ ସେମନ୍‌କେ ବନ୍ଦି ଗରେ ପୁରାଇଲାଇ ଆରି କୁଚିଦେଇ ଜାଗ୍‌ବାକେ ବନ୍ଦି ଗର୍‌ ଜାଗୁଆଲ୍‌କେ ଆଦେସ୍‌ ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ଏ ଆଦେସ୍‌ ପାଇ ବନ୍ଦି ଗର୍‌ ଜାଗୁଆଲ୍‌ ସେମନ୍‌କେ ଗଟେକ୍‌ ବିତ୍‌ରର୍‌ ବାକ୍‌ରାଇ ପୁରାଇ ଦେଇ, ବଜ୍‌ରଇବା ଦାରୁମୁଟ୍‌ଲାଇ ତାକର୍‌ ଗଡ୍‌ ବାନ୍ଦିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ପାଉଲ୍‌ ଆରି ସିଲା ମଜା ରାତି ବେଲାଇ ପର୍‌ମେସର୍‌କେ ପାର୍‌ତନା କରି ଗିତ୍‌ ଗାଇତେ ରଇଲାଇ । ବନ୍ଦି ଗରେ ରଇବା ବିନ୍‌ଲକ୍‌ମନ୍‌ ସେଟା ସବୁ ସୁନ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ସେଡ୍‌କିବେଲେ, ଅଟାତ୍‌ ବେସି ଦର୍‌ତନି ଚୁଲ୍‌ବୁଲ୍‌ଲା ଆରି ବନ୍ଦି ଗରର୍‌ ପାକାଇଲା କୁନାଦି ପାକ୍‌ନା ଆଲିଗାଲା, ସେ ଦାପ୍‌ରେ କାପାଟ୍‌ମନ୍‌ ଉଗାଡି ଅଇଗାଲା ଆରି ସବୁ ବନ୍ଦିମନର୍‌ ସିକ୍‌ଲି କୁସ୍‌ଲି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ବନ୍ଦି ଗରର୍‌ ଜାଗୁଆଲ୍‌ ଚେତାଅଇ ଉଟ୍‌ଲା ଆରି ବନ୍ଦି ଗରର୍‌ କାପାଟ୍‌ ଉଗ୍‌ଡା ଅଇରଇଲାଟା ଦେକ୍‌ଲା । ସେ ବନ୍ଦିମନ୍‌ ସବୁ ପାଲାଇ ଆଚତ୍‌ ବଲି ବାବ୍‌ଲା । ସେଟାର୍‌ ପାଇ ସେ ତାର୍‌ କାଣ୍ଡା ବେଟି ବୁସି ଅଇ ମର୍‌ବାକେ ଜାଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ମାତର୍‌ ପାଉଲ୍‌ ଆଉଲିଅଇ କଇଲା, “ନିଜେ ତର୍‌ ଗାଗଡ୍‌ କାଟିଅଇ ନସାନାଇ । ଆମେ ସବୁ ଲକ୍‌ ଇତି ଆଚୁ ! କେ ପାଲାଉ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ବନ୍ଦି ଗର୍‌ ଜାଗୁଆଲ୍‌ ଗଟେକ୍‌ ବତି ଆନ୍‌ବାକେ ତିଆର୍‌ଲା । ଆରି ସେ ବତି ଦାର୍‌ଲା ଆରି ତର୍‌ତରି ତର୍‌ତରି ଆସି ପାଉଲ୍‌ ଆରି ସିଲାର୍‌ ଗଡ୍‌ ତଲେ ଅଦର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ତାର୍‌ ପଚେ ସେମନ୍‌କେ ବାଇରେ ନେଇ ପାଚାର୍‌ଲା, “ଆଗିଆଁମନ୍‌ ! ପର୍‌ମେସରର୍‌ ଡଣ୍ଡେଅନି ରକିଆ ପାଇବାକେ ମୁଇ କାଇଟା କର୍‌ବାର୍‌ ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ସେମନ୍‌ କଇଲାଇ, “ମାପ୍‌ରୁ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କଲେ, ତୁଇ ଆରି ତମର୍‌ କୁଟୁମର୍‌ ସବୁ, ମୁକ୍‌ତି ପାଇସା ।” ");
INSERT INTO dso_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ତାର୍‌ ପଚେ ସେମନ୍‌ ତାକେ ଆରି ତାକର୍‌ ଗରର୍‌ ସବୁ ଲକ୍‌କେ ମାପ୍‌ରୁର୍‌ ବାକିଅ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ସେ ଦାପ୍‌ରେ ମଜାରାତି ବେଲେ, ବନ୍ଦି ଗର୍‌ ଜାଗୁଆଲ୍‌ ସେମନ୍‌କେ ଡାକିନେଇ ସେମନର୍‌ ଗାଉ ଅଇଲାଟା ସବୁ ଦଇଦେଲା । ତାର୍‌ପଚେ ସେ ଆରି ତାର୍‌ କୁଟୁମର୍‌ ସବୁ ଲକ୍‌ ଡୁବନ୍‌ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ତାର୍‌ପଚେ ସେ ପାଉଲ୍‌ ଆରି ସିଲାକେ ତାକର୍‌ ଗରେ ଡାକିନେଇ କାଇବାକେ ଦେଲା । ତେଇ ପରମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ କଲାର୍‌ ପାଇ ସେ ଆରି ତାର୍‌ କୁଟୁମର୍‌ ସବୁ ଲକ୍‌ମନ୍‌ ସାର୍‌ଦା ଅଇଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ଆରିଗଟେକ୍‌ ଦିନର୍‌ ସାକାଲେ ରମିଅ ସାସନ୍‌କାରିଆମନ୍‌ ସେ ଲକ୍‌ମନ୍‌କେ ଚାଡି ଦିଆସ୍‌ ବଲି ଜାଗୁଆଲ୍‌ମନ୍‌କେ କଇକରି ପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ସେଟାର୍‌ ପାଇ ବନ୍ଦିଗର୍‌ ଜାଗୁଆଲ୍‌ ପାଉଲ୍‌କେ କଇଲା, “ରମିଅ ସାସନ୍‌କାରିଆ ତମ୍‌କେ ଆରି ସିଲାକେ ଚାଡି ଦେବାକେ ଆଦେସ୍‌ ଦେଲା ଆଚେ । ଏବେ ତମେ ଏ ଜାଗାଇଅନି ସାନ୍ତି ସଙ୍ଗ୍‍ ଉଟି ଜା ।” ");
INSERT INTO dso_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ମାତର୍‌ ପାଉଲ୍‌ ସନିଅମନ୍‌କେ କଇଲା, “କାଇମିସା ଅପ୍‌ରାଦେ ଦସି ଅଇ ନ ରଇଲେ ମିସା, ସେମନ୍‌ ଆମ୍‌କେ ଲକ୍‌ମନର୍‌ ମୁଆଟେ ମାର୍‌ଲାଇ । ଆମେ ରମିଅ ଲକ୍‌, ମାତର୍‌ ସେମନ୍‌ ଆମ୍‌କେ ବନ୍ଦି କଲାଇ । ଏବେ ଆମ୍‌କେ ଲୁଚ୍‌ତେ ଚାଡିଦେବାକେ ମନ୍‍ କଲାଇନି । ଏଟା କର୍‌ବାକେ ଆମେ ନ ଦେଉଁ । ରମିୟ ଅଦିକାରି ନିଜେ ଆସି ଇତି ଆମ୍‌କେ ମୁକ୍‌ଲାଅ ।” ");
INSERT INTO dso_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ସନିଅମନ୍‌ ରମିଅ ସାସନ୍‌କାରିଆକେ ଏ କାତା ଜାନାଇଲାଇ । ପାଉଲ୍‌ ଆରି ସିଲା ରମିଅ ଲକ୍‌ ବଲି ସୁନି ସେମନ୍‌ ଡରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ସେଟାର୍‌ପାଇ ବନ୍ଦିଗରେ ଜାଇ ସେମନ୍‌କେ କେମା ମାଙ୍ଗ୍‌ଲାଇ ଆରି ସେମନ୍‌କେ ବନ୍ଦି ଗରେଅନି ବାର୍‌କରାଇ ଗଡ୍‌ ଚାଡି ଉଟିଜିବାକେ ବାବୁଜିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ପାଉଲ୍‌ ଆରି ସିଲା ବନ୍ଦି ଗରେଅନି ବାରଇ ଲୁଦିଆର୍‌ ଗରେ ଗାଲାଇ । ତେଇ ସେମନ୍‌ ବିସ୍‌ବାସି ବାଇମନ୍‌କେ ବେଟ୍‌ ଅଇ, ସେମନ୍‌କେ ସାର୍‌ଦା କରାଇ, ସେ ଜାଗା ଚାଡିଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ପାଉଲ୍‌ ଆରି ସିଲା ଅମ୍‌ପିପଲି ଆରି ଆପଲନିଆ ବାଟ୍‍ଦେଇ ତେସ୍‌ଲନି ଜାଗାଇ କେଟ୍‌ଲାଇ । ତେଇ ଜିଉଦିମନର୍‌ ଗଟେକ୍‌ ପାର୍‌ତନା ଗର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ପାଉଲ୍‌ ତାର୍‌ ରିତିନିତି ଇସାବେ, ପାର୍‌ତନା ଗରେ ଗାଲା । ତେଇ ସେ ଲାଗି ଲାଗି ତିନ୍‌ଟା ବିସ୍‌ରାମ୍‌ବାରେ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ କାତାବାର୍‌ତା କଲା । ");
INSERT INTO dso_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଦରମ୍‌ ସାସ୍‌ତର୍‌ ପଡିକରି ବୁଜାଇଲା ଜେ, ମସିଅ ଦୁକ୍‌ ପାଇବାର୍‌ ରଇଲା ଆରି ପର୍‌ମେସର୍‌ ତାକେ ମଲାତେଇଅନି ଉଟାଇବାର୍‌ ରଇଲା । ପାଉଲ୍‌ କଇଲା, “ଜନ୍‌ ଜିସୁର୍‌ ବିସଇ ମୁଇ ଜାନାଇଲି, ସେ ଅଇଲାନି ମସିଅ ।” ");
INSERT INTO dso_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେ ଲକ୍‌ ଏଟା ବିସ୍‌ବାସ୍‌ କଲାଇ । ପାଉଲ୍‌ ଆରି ସିଲାର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ଲାଇ । ସେନ୍ତି ଡାକ୍‌ପୁଟା ରଇବା ମାଇଜିମନ୍‌ ଆରି ପରମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ବା ଗିରିକ୍‌ ମନର୍‌ ଗଟେକ୍‌ ବଡ୍‌ ଦଲ୍‌ ମିସା ସେମନର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ମାତର୍‌ କେତେଟା ଜିଉଦିମନ୍‌ ପାଉଲ୍‌ ଆରି ସିଲାକେ କୁଟ୍‌ କରି, କାଇ କାମ୍‌ ନ କର୍‌ବା ଅଲ୍‌ସିଆ ଲକ୍‌ମନ୍‌କେ ଏକ୍‌ଜୁଟ୍‌ କଲାଇ, ଆରି ଟୁଲିଆଇ, ଗୁଲାଇ ଗଡ୍‌ ଜାକର୍‌ ଲକ୍‌କେ ଉସ୍‌କାଇ ରିସା କରାଇଲାଇ । ସେମନ୍‌ ପାଉଲ୍‌ ଆରି ସିଲାକେ କଜି ଆନ୍‌ବାକେ ଗଟେକ୍‌ ଜେସନ୍‌ ନାଉଁର୍‌ ଗରେ ଜାଇ, ତାର୍‌ ଗର୍‌ ଚପିପାକାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ମାତର୍‌ ତେଇ ପାଉଲ୍‌ ଆରି ସିଲା ଡିସତ୍‌ ନାଇଜେ, ସେମନ୍‌ ଜେସନ୍‌ ଆରି ବିନ୍‌ କେତେଟା ବିସ୍‌ବାସି ବାଇମନ୍‌କେ, ଗଡର୍‌ ନେତାମନର୍‌ ଲଗେ ଜିକିନେଇ ଆଉଲିଅଇ କଇଲାଇ, “ଏ ଲକ୍‌ମନ୍‌ ଚାରିବେଟ୍‌ତି ଗଣ୍ଡ୍‍ଗଲ୍‌ କଲାଇନି ! ଏବେ ଆମର୍‌ ଗଡେ ମିସା ଆଇଲାଇ ଆଚତ୍‌ ");
INSERT INTO dso_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ଆରି ଏସନ୍‌ ସେମନ୍‌କେ ତାର୍‌ ଗରେ ରକିରଇଲା । ଜିସୁ ନାଉଁ ଦାରି ଆରି ଗଟେକ୍‌ ରାଜା ଆଚେ ବଲି କଇକରି ସେମନ୍‌ ଆମର୍‌ ବଡ୍‌ ସାସନ୍‌କାରିଆର୍‌ ନିୟମ୍‌ ବାଙ୍ଗ୍‌ଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ଏ କାତା କଇ ସେମନ୍‌, ଲକ୍‌ମନ୍‌କେ ଆରି ସାସନ୍‌କାରିଆର୍‌ ବିରଦେ ଆଉଲି ଅଇକରି ବେସି ରିସା କରାଇଲାଇ ଆରି ଗଣ୍ଡ୍‍ଗଲ୍‌ କରାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ସାସନ୍‌ କରୁମନ୍‌ ଜେସନ୍‌ ଆରି ବିସ୍‌ବାସିମନର୍‌ତେଇଅନି ଚାଡ୍‌ବାକେ, ଜେତ୍‌କି ଡାବୁ ବାନ୍ଦ୍‌ବାକେ ରଇଲା, ଲାଁଚ୍‌ ନେଇକରି ସେମନ୍‌କେ ଜାମିଲେ ଚାଡିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ରାତି ଅଇଲା ଦାପ୍‌ରେ, ବିସ୍‌ବାସି ବାଇମନ୍‌ ପାଉଲ୍‌ ଆରି ସିଲାକେ ବେରିଆ ନାଉଁର୍‌ ଜାଗାଇ ପାଟାଇଦେଲାଇ । ସେମନ୍‌ ତେଇ କେଟି, ଜିଉଦି ଲକ୍‌ମନର୍‌ ପାର୍‌ତନା ଗରେ ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ତେସଲନିର୍‌ ଜିଉଦିମନର୍‌ ଟାନେଅନି ବେରିଆର୍‌ ଜିଉଦିମନ୍‌ କୁଲାକୁଲି ମନ୍‌ ରଇବା ଲକ୍‌ ରଇଲାଇ । ସେମନ୍‌ ଅଦିକ୍‌ ମନ୍‌ଦିଆନ୍‌ ଦେଇ ସିସ୍‌ମନର୍‌ ସିକିଆ ସୁନ୍‌ଲାଇ । ଆରି ପାଉଲ୍‌ କଇଲା କାତା, ସତ୍‌ କି ନାଇ ବଲି ଜାନ୍‌ବାକେ ସବୁ ଦିନ୍‌ ଦରମ୍‌ ସାସ୍‌ତର୍‌ ପଡ୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ସେମନର୍‌ ବିତ୍‌ରେଅନି ବେସି ଲକ୍‌ ବିସ୍‌ବାସ୍‌ କଲାଇ । ବେସି ସାଉକାର୍‌ ଅଇ ସନ୍‌ମାନ୍‌ ପାଇବା ଗିରିକ୍‌ ମାଇଜି ଆରି ଗିରିକ୍‌ ଲକ୍‌ମନ୍‌ ମିସା ବିସ୍‌ବାସିମନର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ମାତର୍‌ ଜେଡେବଲ୍‌ ତେସ୍‌ଲନିର୍‌ ଜିଉଦିମନ୍‌ ସୁନ୍‌ଲାଇ ଜେ ବେରିଆତେଇ ମିସା ପାଉଲ୍‌ ପରମେସରର୍‌ ବାକିଅ ଜାନାଇଲାନି, ସେମନ୍‌ ତେଇ ଆସି ପାଉଲର୍‌ ବିରଦେ ଗଣ୍ଡ୍‍ଗଲ୍‌ କର୍‌ବାକେ ଲକ୍‌ମନ୍‌କେ ଉସ୍‌କାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ସେ ଦାପ୍‌ରେ ବିସ୍‌ବାସି ବାଇମନ୍‌ ପାଉଲ୍‌କେ ସମ୍‌ଦୁର୍‌ ପାଲିବାଟେ ପାଟାଇଦେଲାଇ, ମାତର୍‌ ସିଲା ଆରି ତିମତି ଦୁଇ ଲକ୍‌ ବେରିଆଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ପାଉଲ୍‌କେ ଡାକିନେବା ଲକ୍‌ମନ୍‌, ତାର୍‌ ସଙ୍ଗ୍‍ ଆତେନସ୍‌ ଜାକ ଗାଲାଇ । ତେଇଅନି ସେମନ୍‌ ବେରିଆଇ ବାଉଡି ଆସି, ସିଲା ଆରି ତିମତିକେ କଇଲାଇ, “ତମ୍‌କେ ପାଉଲ୍‌ ବେଗି ମିସ୍‌ବାକେ କବର୍‌ ପାଟାଇ ଆଦେସ୍‌ ଦେଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ସିଲା ଆରି ତିମତିକେ ଆତେନେସ୍‌ତେଇ ଜାଗି ରଇଲା ବେଲେ, ଗଡ୍‌ଜାକର୍‌ ଲକ୍‌ ପୁଜା କର୍‌ବା ଦେବ୍‌ତାମନର୍‌ ମୁର୍‌ତିମନ୍‌ ଦେକି, ପାଉଲର୍‌ ମନ୍‌ ବେସି ଉଡୁକ୍‌ଦୁଡୁକ୍‌ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ସେଟାର୍‌ପାଇ ସେ ଜିଉଦିମନର୍‌ ପାର୍‌ତନା ଗରେ ସେମନର୍‌ ସଙ୍ଗ୍‍, ଆରି ପରମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ବା ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍, ଏ ବିସଇ ସବୁ ଦିନ୍‌ ଆଲ୍‍ଚନା କର୍‌ବାର୍‌ ଦାର୍‌ଲା । ଆଟେବାଟେ ଜିବାଆଇବା କର୍‌ବା ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ସେ ବିସଇ ଆଲ୍‍ଚନା କଲା । ");
INSERT INTO dso_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","କେତେଟା ଏପିକିଉରିଆନ୍‌ ଆରି ଟଇକ୍‌ ସିକିଆ ଦେବା ଗୁରୁମନର୍‌ ସଙ୍ଗ୍‍ ଦଦାପେଲା ଅଇଲାଇ । ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେ ଲକ୍‌ କଇଲାଇ, “ଏ ବକୁଆ ବଡ୍‌ପନିଆ, କାଇଟା କଇବାକେ ଚେସ୍‌ଟା କଲାନି ?” ବିନ୍‌ ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ବିନ୍‌ ଦେସେ ରଇବା ଦେବ୍‌ତାମନର୍‌ ବିସଇ, ସେ ଜାନାଇଲାନି ପାରା ଲାଗ୍‌ଲାନି ।” ଜିସୁ ଆରି ତରେକ୍‌ ଜିବନ୍‌ ଅଇ ଉଟ୍‌ଲା ବିସଇ ପାଉଲ୍‌ ଜାନାଇବାଟା ସୁନି ସେମନ୍‌ ଏନ୍ତି କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ସେଟାର୍‌ପାଇ ସେମନ୍‌ ପାଉଲ୍‌କେ ଦାରି ସେ ନଅରର୍‌ ବିଚାର୍‌ କର୍‌ବା ଜାଗା, ଜନ୍‌ଟା କି ଏରିଅପାଗସ୍‌ ତେଇ ଆନ୍‌ଲାଇ । ଆରି ତେଇ କଇଲାଇ, “ତୁଇ ଜନ୍‌ ନୁଆ ସିକିଆ ବିସଇ କଇଲୁସ୍‌ନି, ସେ ବିସଇ ଆମେ ଜାନ୍‌ବାକେ ମନ୍‌ କଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ତୁଇ କଇବା କେତେଟା କାତା ଆମେ ଆଗ୍‌ତୁ କେବେ ସୁନି ନ ରଇଲୁ । ଆମେ ତାର୍‌ ଅରତ୍‌ ଜାନ୍‌ବାକେ ମନ୍‍ କଲୁନି । ");
INSERT INTO dso_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","କାଇକେବଇଲେ ଆତେନେସର୍‌ ଲକ୍‌ ଆରି ତେଇ ରଇବା ବିନ୍‌ ଦେସର୍‌ ଲକ୍‌ମନ୍‌ ନୁଆ ବିସଇ ସୁନ୍‌ବାକେ ଆରି କଇବାକେ ବଲ୍‌ପାଇତେ ରଇଲାଇ । ତେଇ ସେମନ୍‌ ବେସି ବେଲା ଦେଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ପାଉଲ୍‌ ସେ ଗଡର୍‌ ସବା ମୁଆଟେ ଟିଆ ଅଇ କଇଲା, ଆତେନିଅର୍‌ ଲକ୍‌ମନ୍‌, ତମେ ସବୁ ଦରମ୍‌ ଲକ୍‌ ବଲି ଜାନାପଡ୍‌ଲାନି । ");
INSERT INTO dso_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","କାଇକେବଇଲେ, ମୁଇ ତମର୍‌ ନଅରେ ବୁଲି ଦେକ୍‌ଲା ବେଲେ, ତମର୍‌ ପୁଜା କର୍‌ବା ଜାଗାମନ୍‌ ଦେକ୍‌ଲି । ତେଇ ଗଟେକ୍‌ ବେଦି ରଇଲା । ଗଟେକ୍‌ ନ ଜାନ୍‌ଲା ଦେବ୍‌ତାକେ, ଲେକାରଇଲାଟା ମିସା ଦେକ୍‌ଲି । ତମେ ଜାକେ ନାଜାନି ପୁଜାକଲାସ୍‌ନି । ଏବେ ତାର୍‌ ବିସଇ ତମ୍‌କେ ଜାନାଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ପରମେସର୍‌ ଦୁନିଆ ଆରି ତେଇ ରଇଲା ସବୁ ବିସଇ ତିଆର୍‌ କଲା । ସେ ସରଗ୍‌ ଆରି ଜଗତର୍‌ ମାପ୍‌ରୁ । ଲକ୍‌ମନ୍‌ ତିଆର୍‌ କଲା ମନ୍ଦିରେ ରଇବାକେ ମନ୍‌ ନ କରେ । ");
INSERT INTO dso_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ଆମେ ତାର୍‌ ପାଇ କାମ୍‌ କରି ତାକେ ଦେଇପାର୍‌ବୁ ପାରା କାଇଟା ମିସା ସେ ମନ୍‌ କରେ ନାଇ । କାଇକେବଇଲେ ସେ ସବୁକେ ଜିବନ୍‌, ପବନ୍‌ ଆରି ସବୁ ଦର୍‌କାର୍‌ ରଇଲାଟା ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ଗଟେକ୍‌ ଲକ୍‌ଅନି ସେ ସବୁ ମୁନୁସ୍‌ ଜାତିକେ ତିଆର୍‌ କଲା । ଆରି ତାର୍‌ ଆଦେସ୍‌ ଇସାବେ ସେମନ୍‌ ଦୁନିଆର୍‌ ବିନ୍‌ ବିନ୍‌ ଜାଗାଇ ବାସା ଅଇଲାଇ ଆଚତ୍‌, ସେଟା ପୁର୍‌ବେଅନି ପରମେସର୍‌ ଟିକ୍‌ କଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ତାକର୍‌ ଆଦେସ୍‌ ରଇଲା ଜେ ସବୁ ଲକ୍‌ ତାକେ କଜି କରି ବେଟ୍‌ ଅଅତ୍‌ । ମାତର୍‌ ସତଇସେ ପର୍‌ମେସର୍‌ କାର୍‌ଟାନେଅନି ମିସା ଦୁରିକେ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ଏ ବିସଇ କେକି ଗଟେକ୍‌ ଲକ୍‌ କଇଲା ଆଚେ, “ତାର୍‌ ଲଗେ ଆକା ଆମର୍‌ ଜିବନର୍‌ କୁଚିକାଡି ଆଚେ ।” ତମର୍‌ ବିତ୍‌ରେଅନି କେତେଲକ୍‌ କଇଆଚତ୍‌, ଆମେ ମିସା ତାର୍‌ ପିଲାଜିଲା । ");
INSERT INTO dso_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ଆମେ ପର୍‌ମେସରର୍‌ ପିଲାଜିଲା ଅଇଲାର୍‌ ପାଇ ମୁନୁସ୍‌ ତିଆର୍‌ କଲା ସୁନା, ରୁପା ନଇଲେ ପାକ୍‌ନା ସଙ୍ଗ୍‍ ତିଆର୍‌ କଲା ପୁତ୍‌ଲା, ପରମେସର୍‌ ରୁପ୍‌ ବଲି ବାବି ନାପାରୁ । ");
INSERT INTO dso_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ଲକ୍‌ମନ୍‌ ପରମେସର୍‌କେ ଜାନି ନ ରଇଲା ବେଲେ, ସେ ଦସ୍‌ ଦାରି ନ ରଇଲା, ମାତର୍‌ ଏବେ ସବୁ ଜାଗାର୍‌ ସବୁ ଲକ୍‌ମନ୍‌କେ, ସେମନର୍‌ ପାପ୍‌ ବାଟେଅନି ବାଅଡ୍‌ବାକେ ଆଦେସ୍‌ ଦେଲାନି । ");
INSERT INTO dso_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ସେ ଗଟେକ୍‌ ଦିନ୍‌ ଟିକ୍‌ କଲା ଆଚେ । ସେ ଦିନେ, ସେ ବାଚିରଇବା ଲକର୍‌ ସଙ୍ଗ୍‍ ଗୁଲାଇ ଦୁନିଆର୍‌ ବିଚାର୍‌ କର୍‌ସି । ସେ ଲକ୍‌ ମଲାଟାନେଅନି ଉଟି ଏ କାତା ସତ୍‌ ବଲି, ସବୁକେ ଜାନାଇଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ପାଉଲର୍‌ଟାନେ, ମଲାଟାନେଅନି ଉଟ୍‌ଲା ବିସଇ ସୁନି ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେ ଲକ୍‌ ତାକେ କିଜାଇଲାଇ, ମାତର୍‌ ବିନ୍‌ ଲକ୍‌ମନ୍‌ କଇଲାଇ, “ତମର୍‌ତେଇଅନି ଆମେ ଆରିତରେକ୍‌ ଏ ବିସଇ ସୁନ୍‌ବାକେ ମନ୍‌ କଲୁନି ।” ");
INSERT INTO dso_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ପାଉଲ୍‌ ସେ ଦିନର୍‌ ସବାଇ ଅନି ଉଟି ବାରିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ଡାୟନିସିଅସ୍‌ ନାଉଁର୍‌ ସବାର୍‌ ଗଟେକ୍‌ ମେମର୍‌, ଦାମାରି ନାଉଁର୍‌ ଗଟେକ୍‌ ମାଇଜି ଆରି କେତେଟା ଲକ୍‌, ବିସ୍‌ବାସ୍‌ କରି ତାର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ତାର୍‌ପଚେ ପାଉଲ୍‌ ଆତେନ୍‌ସ୍‌ ଚାଡି କରନ୍ତିଅ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ତେଇ ପନ୍‌ତସ୍‌ତେଇ ଜନମ୍‌ କରିରଇବା ଆକିଲା ନାଉଁର୍‌ ଗଟେକ୍‌ ଜିଉଦିକେ ବେଟ୍‌ ଅଇଲା । ବଡ୍‌ ସାସନ୍‌କାରିଆ କଲଡିଅସ୍‌, ସବୁ ଜିଉଦିକେ ରମ୍‌ ଦେସ୍‌ ଚାଡ୍‌ବାକେ ଆଦେସ୍‌ ଦେଇରଇଲା । ସେଟାର୍‌ପାଇ, ସେ ଅଲପ୍‌ ଦିନ୍‌ ଆଗ୍‌ତୁ ତାର୍‌ ମାଇଜି ପିରିସ୍‌କିଲାର୍‌ ସଙ୍ଗ୍‍ ଇଟାଲିଅନି ଆସିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ପାଉଲ୍‌ ସେମନ୍‌କେ ବେଟ୍‌ ଅଇବାକେ ଜାଇ ସେମନର୍‌ ସଙ୍ଗ୍‍ ରଇଲା । କାଇକେବଇଲେ ସେ ମିସା ସେମନର୍‌ ପାରା ତୁମ୍‌ ତିଆର୍‌ କରି ଜିଉନାକାଉନା କର୍‌ତେରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ଜିଉଦି ଆରି ଗିରିକ୍‌ ମନ୍‌ ମାପ୍‌ରୁକେ ଅଦିକ୍‌ ବିସ୍‌ବାସ୍‌ କରାଇବାକେ, ସବୁ ବିସ୍‌ରାମ୍‌ବାରେ ପାର୍‌ତନା ଗରେ ଆଲ୍‍ଚନା କର୍‌ତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ସିଲା ଆରି ତିମତି ମାସିଦନିଆଇଅନି ବାଉଡି ଆଇଲା ପଚେ ପାଉଲ୍‌ ଜିଉଦିମନର୍‌ ଲଗେ ଜିସୁର୍‌ ସୁବ୍‌ କବର୍‌ ଜାନାଇବାକେ ପୁରାପୁରି ବେଲା ଦେଲା ଆରି ଜିସୁକେ ମସିଅ ବଲି ସାକି ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ମାତର୍‌ ସେମନ୍‌ ତାକେ ବିରଦ୍‌ କରି ତାର୍‌ କୁଟ୍‌ ପାଁଚ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ, ସେଟା ବିରଦ୍‌ କର୍‌ବା ଇସାବେ, ତାର୍‌ ବସ୍‌ତରର୍‌ ଦୁଲି ପାପ୍‌ଡିଦେଇ ସେ ସେମନ୍‌କେ କଇଲା, “ଜଦି ତମେ କୁରୁପ୍‌ନାସ୍‌ ଅଇସା, ତେବେ ସେଟାର୍‌ପାଇ ତମେ ନିଜେ ଦାଇ ଅଇସା । ମୁଇ ଏଟାର୍‌ପାଇ ଦାଇ ନଇ, ଏବେ ମୁଇ ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ ଲଗେ ଜିବି ।” ");
INSERT INTO dso_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ସେଟାର୍‌ପାଇ ସେ ସେମନ୍‌କେ ଚାଡି ପର୍‌ମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ବା ତିତସ୍‌ ଜୁସ୍‌ତ ନାଉଁର୍‌ ଗଟେକ୍‌ ଜିଉଦି ନଇଲା ଲକର୍‌ ଗରେ ରଇବାକେ ଗାଲା । ଜୁସ୍‌ତର୍‌ ଗର୍‌ ପାର୍‌ତନା ଗର୍‌ ଲଗେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ପାର୍‌ତନା ଗରର୍‌ ମୁକିଅ କିରିସ୍‌ପସ୍‌ ଆରି ତାର୍‌ କୁଟୁମର୍‌ ସବୁ ଲକ୍‌ ମାପ୍‌ରୁର୍‌ତେଇ ବିସ୍‌ବାସ୍‌ କଲାଇ ଆରି କରନ୍ତିଅର୍‌ ଅଦିକ୍‌ ଅଦିକ୍‌ ଲକ୍‌ ପାଉଲର୍‌ ସିକିଆ ସୁନି ବିସ୍‌ବାସ୍‌ କଲାଇ ଆରି ପାନିତେଇବୁଡି ଡୁବନ୍‌ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ଗଟେକ୍‌ ରାତି, ପାଉଲ୍‌ ଦର୍‌ସନ୍‌ ଦେକ୍‌ଲା । ଦର୍‌ସନେ ମାପ୍‌ରୁ ତାକେ କଇଲା, “ଡର୍‌ ନାଇ, ଜାନାଇତେ ରଅ, ସେଟା ତେବାନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","କାଇକେ ବଇଲେ ମୁଇ ତର୍‌ ସଙ୍ଗ୍‍ ଆଚି । କେ ତମ୍‌କେ କାଇଟା କରି ନାପାରତ୍‌, କାଇକେବଇଲେ ଏ ନଅରେ ମର୍‌ ବେସି ଲକ୍‌ ଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ସେଟାର୍‌ପାଇ ପାଉଲ୍‌ ପର୍‌ମେସରର୍‌ ବାକିଅ ସିକିଆ ଦେଇ, ତେଇ ବର୍‌ସେକ୍‌ ଚ ମାସ୍‌ ଜାକ ରଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ଗାଲିୟନ୍‌ ଆକାୟର୍‌ ରମିଅ ସାସନ୍‌କାରିଆ ରଇଲା ବେଲେ, ଜିଉଦିମନ୍‌ ଏକ୍‌ଜୁଟ୍‌ଅଇ ପାଉଲ୍‌କେ ଦାରି ବିଚାର୍‌ନା ଜାଗାଇ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ସେମନ୍‌ କଇଲାଇ, “ଏ ଲକ୍‌ ଆମର୍‌ ନିୟମ୍‌ ବିରଦେ ପରମେସର୍‌କେ ପାର୍‌ତନା କର୍‌ବାକେ ଲକ୍‌ମନ୍‌କେ ସୁତ୍‌ରାଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ପାଉଲ୍‌ କାତା ଅଇବାକେ ଗାଲାବେଲେ, ଗାଲିଅ ଜିଉଦିମନ୍‌କେ କଇଲା, “ଜଦି ଇତି କାଇ ଦସ୍‌ ନଇଲେ ଅପ୍‌ରାଦର୍‌ ବିସଇ ରଇସି, ତେବେ ତମର୍‌ ବିସଇ ସମାଲି କରି, ତମର୍‌ କାତା ସୁନ୍‌ବାଟା, ମର୍‌ ଇସାବେ ଟିକ୍‌ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ମାତର୍‌ ଏ କାତା ତମର୍‌ ବିଦିବିଦାନ୍‌ ଆରି ରିତିନିତିର୍‌ କାତା ଅଇଲାର୍‌ ପାଇ, ଏଟା ତମେ ଟିକ୍‌କର୍‌ବାଟା ନିକ ଅଇସି । ମୁଇ ଏନ୍ତି ବିଚାର୍‌ ନ କରି ।” ");
INSERT INTO dso_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ଏନ୍ତି କଇକରି ସେମନ୍‌କେ ବିଚାର୍‌ନା ଜାଗାଇଅନି କେଦିଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ସେମନ୍‌ ପାର୍‌ତନା ଗରର୍‌ ମୁକିଆ ସସ୍‌ତନସ୍‌କେ ଦାରି ବିଚାର୍‌ନା ଜାଗାର୍‌ ମୁଆଟେ ମାଡ୍‌ମାର୍‌ଲାଇ । ମାତର୍‌ ଗାଲିଅ ସେଟାକେ ମନ୍‌ଦେଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ପାଉଲ୍‌ କରନ୍ତିତେଇ ବିସ୍‌ବାସି ବାଇମନ୍‌ ସଙ୍ଗ୍‍ ବେସି ବେଲା ଜାକ ରଇଲା । ତାର୍‌ପଚେ ସେମନ୍‌କେ ଚାଡି ପିରିସ୍‌କିଲା ଆରି ଆକିଲାର୍‌ ସଙ୍ଗ୍‍, ସିରିଆ ଜିବାକେ ପାନିଜାଜେ ବାଟ୍‌ ଦାର୍‌ଲାଇ । ସେକେରିଆଅନି ଜିବାଟା ଆରାମ୍‌ କର୍‌ବା ଆଗ୍‌ତୁ ତାକର୍‌ ଗଟେକ୍‌ ମାନତ୍‌ ଇସାବେ ପାଉଲ୍‌ ମୁଣ୍ଡ୍‌ କୁରାଇଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ସେମନ୍‌ ଏପିସିସ୍‌ତେଇ କେଟ୍‌ଲା ପଚେ ପାଉଲ୍‌ ପିରିସ୍‌କିଲା ଆରି ଆକିଲାକେ ପାଟାଇଦେଲା । ତେଇ ସେ ପାର୍‌ତନା ଗରେ ଜାଇ ଜିଉଦିମନର୍‌ ସଙ୍ଗ୍‍ କାତାବାର୍‌ତା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ଲକ୍‌ମନ୍‌ ତାକେ ଆରି ବେସି ଦିନ୍‌ ରଇବାକେ କଇଲାଇ, ମାତର୍‌ ସେ ରାଜି ନଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ଜିବା ବେଲାଇ ସେ ସେମନ୍‌କେ କଇଲା, “ଜଦି ପରମେସର୍‌ ମନ୍‌ କଲେ, ତମର୍‌ ଲଗେ ବାଉଡି ଆଇବି ।” ତାର୍‌ ପଚେ ସେ ଏପିସେ ଅନି ଜାଜେ ଚଗି ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ସେ ସିରିଆ କେଟିକରି ତେଇଅନି ଜିରୁସାଲାମେ ଗାଲା ଆରି ମଣ୍ଡଲିକେ ଜୁଆର୍‌ ଜାନାଇ ତେଇଅନି ଆନ୍‌ଟିକିଅ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ତେଇ କେତେ ଦିନ୍‌ ରଇଲା ପଚେ, ସେ ଆରି ତରେକ୍‌ ଜିବାଟା ଆରାମ୍‌ କରି ଗାଲାତିଅ ଆରି ପିରିଜିଆ ବାଟ୍‍ଦେଇ ଗାଲା । ବାଟେ ବିସ୍‌ବାସିମନ୍‌କେ ବିସ୍‌ବାସେ ଡାଟ୍‌ ଅଇରଇବାକେ ସାଆସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ସେ ବେଲାଇ ଆଲେକ୍‌ଜାଣ୍ଡ୍‌ରିଆଇ ଜନମ୍‌ ଅଇ ରଇଲା, ଆପଲ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଜିଉଦି ଏପିସେ ଆଇଲା । ସେ ଗଟେକ୍‌ ନିମାନ୍‌ ସଙ୍ଗ୍‍ କାତାକଉ ଆରି ଦରମ୍‌ ସାସ୍‌ତରେ ତାର୍‌ ବେସି ଗିଆନ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ସେ ମାପ୍‌ରୁ ଜିସୁର୍‌ ବାଟ୍‌ ବିସଇ ସିକିଆ ପାଇରଇଲା ଆରି ଆତ୍‌ମାଇ ପୁରାପୁରୁନ୍‌ ଅଇକରି ବେସି ସାର୍‌ଦା ସଙ୍ଗ୍‍ ସତ୍‌ କାତା ବାର୍‌କରି, ସିକିଆ ଦେଇତେ ରଇଲା । ମାତର୍‌ କାଲି ଜଅନ ଡୁବନ୍‌ ଦେବା ବିସଇ ଜାନି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ପାର୍‌ତନା ଗରେ ସେ ନ ଡର୍‌ତେ ସିକିଆ ଦେବାକେ ଲାଗ୍‌ଲା । ତାର୍‌ ସିକିଆ ସୁନି ପିରିସ୍‌କିଲା ଆରି ଆକିଲା ତାକର୍‌ ନିଜର୍‌ ଗରେ ଡାକିନେଲାଇ ଆରି ତେଇ ପରମେସରର୍‌ ବାଟ୍‌ ବିସଇ ଅଦିକ୍‌ ବୁଜାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ତାର୍‌ ପଚେ ଆପଲ ଆକାୟା ରାଇଜେ ଜିବାକେ ଟିକ୍‌ କଲାକେ, ଏପିସର୍‌ ବିସ୍‌ବାସି ବାଇମନ୍‌ ତାକେ ସାଇଜ୍‌ କଲାଇ ଆରି ତାକେ ସାର୍‌ଦା ସଙ୍ଗ୍‍ ଗତିଆ କର୍‌ବାକେ କଇ ଆକାୟାର୍‌ ବିସ୍‌ବାସିମନ୍‌କେ ଚିଟି ଲେକ୍‌ଲାଇ । ସେ ତେଇ କେଟିକରି ପରମେସର ଜିବନ୍‌ ଦୁକାଇଲାକେ ବିସ୍‌ବାସି ଅଇରଇବା ଲକ୍‌ମନ୍‌କେ ବେସି ସାଇଜ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ଜିସୁ ଜେ ମସିଅ, ତାକର୍‌ ବେସି ଡାଟ୍‌ ଜୁକ୍‌ତି, ଦରମ୍‌ ସାସ୍‌ତରେଅନି ଜାନାଇ କରି, ଜିଉଦିମନ୍‌କେ ଆରାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ଆପଲ୍‌ କରନ୍ତିଏ ରଇଲାବେଲେ, ପାଉଲ୍‌ ସେ ରାଇଜର୍‌ ଉପର୍‌ ବାଗେ ବୁଲି ସାରାଇ, ଏପିସିଏ କେଟ୍‌ଲା । ତେଇ ସେ କେତେଟା ସିସ୍‌ମନ୍‌କେ ବେଟ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ସେମନ୍‌କେ ପାଚାର୍‌ଲା “ତମେ ବିସ୍‌ବାସି ଅଇବା ବେଲାଇ ସୁକଲ୍‌ ଆତ୍‌ମା ପାଇରଇଲାସ୍‌ କି ?” ସେମନ୍‌ କଇଲାଇ, “ସୁକଲ୍‌ ଆତ୍‌ମା ଆଚେ ବଲି ଆମେ କେବେ ମିସା ସୁନୁ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ପାଉଲ୍‌ ପାଚାର୍‌ଲା, “ସେନ୍ତି ଆଲେ ତମେ କେନ୍ତାରି ଡୁବନ୍‌ ନେଇ ଆଚାସ୍‌ ?” ସେମନ୍‌ କଇଲାଇ “ଡୁବନ୍‌ ଦେଉ ଜଅନର୍‌ ଡୁବନ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ପାଉଲ୍‌ କଇଲା, “ଜନ୍‌ ଲକ୍‌ମନ୍‌ ପାପେଅନି ବାଉଡି ରଇଲାଇ, ଜଅନର୍‌ ଡୁବନ୍‌ ସେମନର୍‌ ପାଇ ଟିକ୍‌ ରଇଲା । ମାତର୍‌ ତାର୍‌ପଚେ ଜେ ଆଇବାର୍‌ ରଇଲା, ଜନ୍‌ଟା କି, ଜିସୁ, ତାର୍‍ ଲଗେ ବିସ୍‌ବାସ୍‌ କର୍‌ବାକେ, ଜଅନ୍‌ ଇସ୍‌ରାଏଲ୍‌ ଲକ୍‌ମନ୍‌କେ କଇରଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ଏଟା ସୁନି ସେମନ୍‌ ମାପ୍‌ରୁ ଜିସୁର୍‌ ନାଉଁ ଦାରି ଡୁବନ୍‌ ନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ପାଉଲ୍‌ ସେମନର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ଚିଇଲା ଆରି ସୁକଲ୍‌ ଆତ୍‌ମା ତାକର୍‌ଟାନେ ଉତର୍‌ଲା । ସେମନ୍‌ ବିନ୍‌ ବିନ୍‌ ବାସାଇ କାତା କଇଲାଇ ଆରି ପରମେସରର୍‌ ସୁବ୍‌ କବର୍‌ ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ସେମନ୍‌ ମୁନୁସ୍‌ ପିଲା ବାର ଲକ୍‌ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ତାର୍‌ ପଚେ ପାଉଲ୍‌ ତିନ୍‌ ମାସ୍‌ ଜାକ ନ ଡର୍‌ତେ ପାର୍‌ତନା ଗରେ କାତାବାର୍‌ କରି ପରମେସରର୍‌ ରାଇଜ୍‌ ବିସଇ ସେମନର୍‌ ମନେ ବିସ୍‌ବାସ୍‌ ଜନ୍‌ମାଇବାକେ ଚେସ୍‌ଟା କଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ମାତର୍‌ ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେକ୍‌ ଲକର୍‌ ମନ୍‌ ଡାଟ୍‌ ରଇଲା । ସେମନ୍‌ ବିସ୍‌ବାସ୍‌ କରତ୍‌ନାଇ । ଦଲର୍‌ ସବୁ ଲକର୍‌ ମୁଆଟେ ସେମନ୍‌ ମାପ୍‌ରୁର୍‌ ବାଟ୍‌ ବିସଇନେଇ, ତିପୁଲ୍‌ କାତା କଇଲାଇ । ସେଟାର୍‌ପାଇ ପାଉଲ୍‌ ସେମନ୍‌କେ ଚାଡି, ବିସ୍‌ବାସିମନ୍‌କେ ନେଇ, ସବୁ ଦିନ୍‌ ଟିରାନସ୍‌ ନାଉଁର୍‌ ଗରେ ନିଆଇ କର୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ଏଟା ଦୁଇ ବରସ୍‌ ଦାରି ଚାଲ୍‌ଲା । ରମ୍‌ ଦେସର୍‌ ଆସିଆ ଦେସେ ବାସା କରିରଇବା ବେସି ଜିଉଦି ଆରି ଗିରିକ୍‌ ଲକ୍‌ ମିସା ମାପ୍‌ରୁର୍‌ ବାକିଅ ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ପର୍‌ମେସର୍‌ ପାଉଲର୍‌ତେଇଅନି ବେସି ବଡ୍‌ ବଡ୍‌ କାବାଅଇଜିବା କାମ୍‌ମନ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ଏନ୍ତି କି ପାଉଲ୍‌ ପୁଚିଅଇବା ଉର୍‌ମାଲ୍‌ ଆରି ବସ୍‌ତର୍‌ ରଗିମନର୍‌ ଲଗେ ନେଲେ, ସେମନ୍‌ ନିମାନ୍‌ ଅଇତେ ରଇଲାଇ । ସେମନର୍‌ ଗାଗ୍‌ଡେଅନି କାରାପ୍‌ ଆତ୍‌ମାମନ୍‌ ସବୁ ବାରଇଜାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","କେତେଟା ଏନେତେନେ ବୁଲ୍‌ବା ଡୁମା ଚାଡାଇବା ଜିଉଦିମନ୍‌ ମିସା, ଜିସୁର୍‌ ନାଉଁ ଦାରି ଡୁମା ଚାଡାଇବାକେ ଚେସ୍‌ଟା କଲାଇ । ସେମନ୍‌ କାରାପ୍‌ ଆତ୍‌ମାମନ୍‌କେ କଇତେ ରଇଲାଇ, “ପାଉଲ୍‌ ଜାନାଇବା ଜିସୁର୍‌ ନାଉଁ ଦାରି ତକେ ଆଦେସ୍‌ ଦେଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ଏସ୍‌କେବା ନାଉଁର୍‌ ଗଟେକ୍‌ ଜିଉଦି, ବଡ୍‌ ପୁଜାରିର୍‌ ସାତ୍‌ଟା ପିଲାମନ୍‌, ଏ ରକାମ୍‌ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ମାତର୍‌ କାରାପ୍‌ ଆତ୍‌ମା ସେମନ୍‌କେ କଇଲା, “ମୁଇ ଜିସୁକେ ଜାନି ଆରି ପାଉଲ୍‌କେ ଚିନ୍‌ଲି ଆଚି, ମାତର୍‌ ତମେ କେ ?” ");
INSERT INTO dso_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","କାରାପ୍‌ ଆତ୍‌ମା ଦାରିରଇଲା ଲକ୍‌, ସେମନ୍‌କେ ଦାରି ଚାବ୍‌କାତର୍‌ କରି ପାକାଇଲା । ସେମନର୍‌ ଲୁଗାପଚିଆ ଚିରି ଡୁମ୍‌ଣ୍ଡା କରିଦେଲା । ସେମନ୍‌ କଣ୍ଡିଆ ବଣ୍ଡିଆ ଅଇ ତାର୍‌ ଗରେଅନି ବାରଇ ପାଲାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ଏପିସେ ବାସାଅଇରଇବା ଜିଉଦି ବିସ୍‌ବାସିମନ୍‌ ଆରି ଗିରିକ୍‌ ଲକ୍‌ମନ୍‌, ଏ ବିସଇ ସୁନି ଡରିଗାଲାଇ ଆରି ତେଇ ମାପ୍‌ରୁ ଜିସୁର୍‌ ନାଉଁ ଅଦିକ୍‌ ଡାକ୍‌ପୁଟା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ବିସ୍‌ବାସିମନର୍‌ ବିତ୍‌ରେଅନି ବେସି ଲକ୍‌ ସବୁର୍‌ ମୁଆଟେ ନିଜେ କଲା କାରାପ୍‌ କାମ୍‌ ମାନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ପାଙ୍ଗନ୍‌ ବିଦିଆ ଅବିଆସ୍‌ କର୍‌ତେରଇବା ବେସି ଲକ୍‌ମନ୍‌ ତାକର୍‌ ବଇମନ୍‌ ଆନି ଟୁଲିଆଇକରି ସବୁ ଲକର୍‌ ମୁଆଟେ ପଡାଇ ଦେଲାଇ । ସବୁ ମିସିକରି ସେମନର୍‌ ବଇର୍‌ ଦାମ୍‌ ପଚାସ୍‌ ଅଜାର୍‌ ରୁପାଟାଙ୍ଗା ଏତ୍‌କି ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ଏନ୍ତିବାବ୍‌ରେ ପରମେସରର୍‌ ବାକିଅ ଅଦିକ୍‌ ଅଦିକ୍‌ ଗୁଲାଇବାଟେ ଉଡ୍‌ରା ଅଇଜାଇ ଅଦିକ୍‌ ବପୁ ଅଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ଏ ସବୁ ଗଟ୍‍ନା ପଚେ ପାଉଲ୍‌ ମାସିଦନିଆ ଆରି ଆକାୟା ବାଟ୍‌ ଦେଇ ଜିରୁସାଲମେ ଜିବାକେ ଟିକ୍‌ କଲା । ସେ କଇଲା, “ତେଇ ଗାଲା ପଚେ, ମୁଇ ରମ୍‌ ଦେସେ ମିସା ଜିବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ସେଟାର୍‌ପାଇ ସେ ତାର୍‌ ଦୁଇଟା ସଙ୍ଗାରି, ତିମତି ଆରି ଏରାସ୍‌ତସ୍‌କେ ମାସିଦନିଆଇ ପାଟାଇଲା, ମାତର୍‌ ସେ ନିଜେ ଆସିଆ ଦେସେ ଆରି କେତେ ଦିନ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ଏତ୍‌କି ବିତ୍‌ରେ ମାପ୍‌ରୁ ଦେକାଇରଇବା ବାଟ୍‌ ବିସଇ ନେଇ, ଗଟେକ୍‌ ବେସି ବଡ୍‌ ଗଣ୍ଡ୍‍ଗଲ୍‌ ଅଇବାଟା ଉବଜ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ଦିମିତିରିୟ ନାଉଁର୍‌ ଗଟେକ୍‌ ରୁପାର୍‌ ପୁତ୍‌ଲା ତିଆର୍‌ କରୁ, ଆର୍‌ତେମି ଦେବିର୍‌ ମନ୍ଦିରେ ପୁତ୍‌ଲା ତିଆର୍‌ କର୍‌ତେ ରଇଲା । ଏନ୍ତାରି ବେବାର୍‌କରି ପୁତ୍‌ଲା ତିଆର୍‌ କରୁମନ୍‌, ବେସି ଲାବ୍‌ ପାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ସେଟାର୍‌ପାଇ ସେ ତାର୍‌ ସଙ୍ଗର୍‌ ବେବାରିମନ୍‌କେ ରୁଣ୍ଡାଇକରି କଇଲା, “ଆଗିଆମନ୍‌, ଏ ବେବାର୍‌ ଆମ୍‌କେ ସାଉକାର୍‌ କଲାଆଚେ ବଲି ସବୁ ଲକ୍‌ ଜାନାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ଏବେ, ଏ ଲକ୍‌ ପାଉଲ୍‌ କାଇଟା କଲାନି, ସେଟା ତମେ ନିଜେ ଦେକିପାର୍‌ଲାସ୍‌ନି ଆରି ସୁନି ପାର୍‌ଲାସ୍‌ନି । ସେ କଇଲାନି, ଲକର୍‌ ଆତେ ତିଆର୍‌ କଲା ଦେବ୍‌ତା ସବୁ ବିଲ୍‌କୁଲ୍‌ ଦେବ୍‌ତା ନଅତ୍‌ । ସେ ଇତି ଏପିସେ ଆରି ସବୁ ଆସିଆ ଦେସେ ବେସି ଲକ୍‌ମନ୍‌କେ ଏ ବିସଇ କଇ ଉସ୍‌କାଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ସେଟାର୍‌ପାଇ ଆମର୍‌ ବେବାର୍‌ ବୁଡିଜିବାର୍‌ ଉପ୍‌ରେ ଆଚେ । କାଲି ସେତ୍‌କି ନଏଁ, ଜନ୍‌ ଦେବି ଆସିଆଇ ଆରି ଗୁଲାଇ ଜଗତେ ସବୁର୍‌ଟାନେଅନି ପୁଜାପାଇସି, ସେ ଡାକ୍‌ପୁଟା ଆର୍‌ତେମି ଦେବି, ମନ୍ଦିରର୍‌ ଡାକ୍‌ପୁଟା ଆରି ନ ରଏ, ଆରି ଆର୍‌ତେମି ଦେବିର୍‌ ମର୍‌ଜିତା ନସ୍‌ଟ ଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ଲକ୍‌ମନ୍‌ ଏ କାତା ସୁନି ରିସା ଅଇଗାଲାଇ ଆରି ଆଉଲିଅଇ କଇଲାଇ, “ଏପିସିୟର୍‌ ଆର୍‌ତେମି ବଡ୍‌ଦେବିର୍‌ ଡାକ୍‌ପୁଟା ଅ !” ");
INSERT INTO dso_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ଏ ଗଣ୍ଡ୍‍ଗଲ୍‌ ଅଇଲାଟା ଗୁଲାଇ ନଅରେ କେଟିଗାଲା । ଲକ୍‌ମନ୍‌ ପାଉଲ୍‌ ସଙ୍ଗ୍‍ ରଇବା ମାକିଦନିଆର୍‌ ଗାୟ ଆରି ଆରିସ୍‌ତାକସ୍‌, ଦୁଇଲକ୍‌କେ ଦାରି, ଦାପ୍‌ରେ ଜୁଇଦ୍‌ ବାଟେ ପାଲାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ତେଇ ପାଉଲ୍‌ ଏକ୍‌ଲାସେ ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ଜିବାକେ ମନ୍‌କଲା । ମାତର୍‌ ବିସ୍‌ବାସିମନ୍‌ ତାକେ ବିତ୍‌ରେ ଜିବାକେ ଚାଡତ୍‌ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ଆସିଆ ରାଇଜର୍‌ କେତେଟା ମୁକିଅ ସାସନ୍‌ କାରିଆମନ୍‌ ମିସା ପାଉଲର୍‌ ମଇତର୍‌ ରଇଲାଇଜେ, ପାଉଲ୍‌କେ ଜୁଇଦ୍‌ ପଡିଆଇ ନ ଜାଅ ବଲି, କବର୍‌ ପାଟାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ଏତ୍‌କି ବିତ୍‌ରେ ରୁଣ୍ଡିରଇବା ସବୁ ଲକ୍‌ ରିସା ଅଇଜାଇରଇଲାଇ । ଲକ୍‌ମନ୍‌ ଦଲ୍‌ଦଲ୍‌ ଅଇକରି ଏକାତା, ସେ କାତା କଇକଇ କରି ଆଉଲିଅଇ ଜାଇତେ ରଇଲାଇ । ମାତର୍‌ ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେକ୍‌ ଲକ୍‌, କାଇକେ ରୁଣ୍ଡିଆଚତ୍‌ ବଲି ନାଜାନିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ସେମନର୍‌ ବିତ୍‌ରେଅନି କେତେକ୍‌ ଲକ୍‌ ଏଟାର୍‌ପାଇ ଆଲେକ୍‌ଜାଣ୍ଡାର୍‌କେ ଦାଇ କଲାଇ । କାଇକେବଇଲେ ଜିଉଦି ଲକ୍‌ମନ୍‌, ଆଗ୍‌ତୁ ତାକେ ଟିଆ କରାଇରଇଲା । ଆଲେକ୍‌ଜାଣ୍ଡାର୍‌ ଲକ୍‌ମନ୍‌କେ ଆତ୍‌ଟେକି ଚିମ୍‌ରାଇଅଇ ରଇବାକେ କଇଲା ଆରି ତାର୍‌ ବାସନ୍‌ଟାନେ ବିସ୍‌ବାସିମନର୍‌ ବାଟେ ଅଇକରି ବୁଜାଇବାକେ ଚେସ୍‌ଟା କଲା । ");
INSERT INTO dso_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ମାତର୍‌ ସେ ଗଟେକ୍‌ ଜିଉଦିଲକ୍‌ ବଲି ଜାନିକରି ଲକ୍‌ମନ୍‌ ଏକାତରେକ୍‌ ଆଉଲିଅଇକରି “ଆର୍‌ତେମି ଦେବିର୍‌ ଜୟ ଜୟ ଅ !” ବଲି ଦୁଇ ଗଁଟା ଜାକ ଆଉଲି ଅଇ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ପଚେ ନଅରର୍‌ ଅଦିକାରେ ରଇବା ଗଟେକ୍‌ କାମ୍‌କରୁ, ଲକ୍‌ମନ୍‌କେ ବୁଜା ସୁଜା କରି ଚିମ୍‌ରା କଲା ଆରି କଇଲା, “ଏ ଏପିସିୟର୍‌ ବାଇମନ୍‌, ଏପିସିସ୍‌ ନଅରେ ବଡ୍‌ଦେବି ଆର୍‌ତେମିର୍‌ ମନ୍ଦିର୍‌ ଆରି ଆକାସେଅନି କସ୍‌ରି ଆଇଲା ସୁକଲ୍‌ ପାକ୍‌ନା ରକିଆ କର୍‌ବା ଦାଇତ୍‌, ଏପିସିୟ ନଅରେ ରଇବା ଲକ୍‌ମନର୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","କେ ମିସା ଏଟା ନଏଁ ବଲି କଇନାପାରତ୍‌ । ସେଟାର୍‌ ପାଇ ତମେ ସବୁ ଲକ୍‌ ଚିମ୍‌ରାଇ ଉଆ । କାଇକାମ୍‌ ମିସା ବକୁଆପାରା କରାନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ଏ ଲକ୍‌ମନ୍‌ ମନ୍ଦିରେଅନି କାଇଟା ଚରି କରତ୍‌ ନାଇ, କି ଆମର୍‌ ଦେବିର୍‌ ବିରଦେ, କାଇମିସା କାରାପ୍‌ କାତା କଅତ୍‌ ନାଇ, ଏଲେମିସା ତମେ ଏମନ୍‌କେ ଦାରି ଆନିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ଜଦି ଦିମିତିରିୟ ଆରି ତେଇର୍‌ ପୁତ୍‌ଲା ତିଆର୍‌କରୁମନ୍‌କେ, କାର୍‌ ବିରଦେ ଦାବାକର୍‌ବାଟା ଆଚେ, ସେଟା ବିଚାର୍‌ କର୍‌ବାକେ ଆମର୍‌ ଲକ୍‌ମନ୍‌ ଆଚତ୍‌ । ଆରି ବିଚାର୍‌ ଅଇବା ଗଟେକ୍‌ ଦିନ୍‌ ଆଚେ । ତେଇ ସେ ଦାବା ବିସଇ କଇପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ଜଦି ଆର୍‌ତେଇଅନି ଆରି ଅଦିକ୍‌ କାଇଟା ଜାନ୍‌ବାକେ ମନ୍‌ କଲାସ୍‌ନି, ତେବେ ଲକ୍‌ମନ୍‌ ଟିକ୍‌କଲା ନିୟମର୍‌ ସବାଇ, ସେଟା ଟିକ୍‌ କରାଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ଆଜି ଜାଇଟା ଗଟ୍‌ଲା ଆଚେ, ତେଇ ଗଣ୍ଡ୍‍ଗଲ୍‌ କର୍‌ବା ଆରି ଦାବା କର୍‌ବା ବିସଇ ଆମର୍‌ ବିରଦେ କାତା ଉଟିପାରେ । ଏ ଗଣ୍ଡ୍‍ଗଲର୍‌ କାଇମିସା କାରନ୍‌ ଦେକାଇ ନାପାରୁ ।” ");
INSERT INTO dso_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ଏ ସବୁ କାତା କଇ ସେ ଲକ୍‌ମନ୍‌କେ ଚିମ୍‌ରା କରାଇ ସବା ସେସ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ଗଣ୍ଡ୍‍ଗଲ୍‌ ବନ୍ଦ୍‌ ଅଇଲା ପଚେ, ପାଉଲ୍‌ ବିସ୍‌ବାସିମନ୍‌କେ ଗଟେକ୍‌ତେଇ ରୁଣ୍ଡାଇ ସାର୍‌ଦାର୍‌ କାତା ସୁନାଇଲା । ସେମନ୍‌କେ ଜିବିବେ ବଲି କଇ, ତେଇଅନି ବାରଇ ମାକେଦନିଆଇ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ତେଇର୍‌ ସବୁ ଜାଗାଇ ଗାଲା, ଆରି ବେସି ଲକ୍‌ମନ୍‌କେ ଉପ୍‌ଦେସ୍‌ ଦେଇ, ସାର୍‌ଦା କରାଇଲା, ତାର୍‌ପଚେ ସେ ଗିରିସେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ତେଇ ସେ ତିନ୍‌ ମାସ୍‌ ରଇଲା, ଆରି ସିରିଆଇ ଜିବାକେ ତିଆର୍‌ ଅଇଲାବେଲେ, ଜିଉଦିମନ୍‌ ତାକର୍‌ ବିରଦେ କୁଟ୍‍ପାଁଚ୍‌ଲାଇନି ବଲି କବର୍‌ ପାଇ ମାକିଦନିଆବାଟେ ବାଉଡି ଜିବାକେ ଟିକ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ବେରିଆତେଇ ରଇବା ପୁରର୍‌ ପଅ ସପାତର୍‌, ତେସ୍‌ଲନିକିୟ ଆରିସ୍‌ତାକସ୍‌ ଆରି ସେକୁଦ୍‌, ଦର୍‌ବିର୍‌ ଗାୟ, ଏସିଆ ଦେସର୍‌ ତୁକିକ୍‌, ତର୍‌ପିମ୍‌ ଆରି ତିମତି । ");
INSERT INTO dso_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ସେମନ୍‌ ଆଗ୍‌ତୁ ଜାଇ ତରିୟାଇ ଆମ୍‌କେ ଜାଗି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","କମିର୍‌ ନ ପାକାଇ ରୁଟି କାଇବା ପରବର୍‌ ପଚେ, ଆମେ ପିଲିପେଅନି ପାନିଜାଜେ ଜାଇ ପାଁଚ୍‌ ଦିନ୍‌ ପଚେ ତରୟାଇ ସେମନର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ଲୁ ଆରି ତେଇ ଗଟେକ୍‌ ଆଟ୍‌ ଜାକ ରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ଆଟର୍‌ ପର୍‌ତୁମ୍‌ ଦିନର୍‌ ସଞ୍ଜ୍‌ବେଲାଇ ଆମେ ସବୁଲକ୍‌ ମିସି କାଇବାକେ ରୁଣ୍ଡ୍‌ଲୁ । ପାଉଲ୍‌ ଲକ୍‌ମନ୍‌କେ ମଜାରାତି ଜାକ ଉପ୍‌ଦେସ୍‌ ଦେଲା । କାଇକେବଇଲେ ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ସେ ଜାଗା ଚାଡି ଜିବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ଜନ୍‌ ଉପର୍‌ ତାଲାର୍‌ ବାକ୍‌ରାଇ ଆମେ ସବା କର୍‌ତେ ରଇଲୁ, ତେଇ ବେସି ବତିମନ୍‌ ଲାଗିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ତେଇ ଇଉଟିକସ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଦାଙ୍ଗ୍‌ଡା କିଡ୍‌କି ଲଗେ ବସି ରଇଲା । ପାଉଲ୍‌ କାତା କଇବା ବେଲାଇ, ତାକେ ଗୁନ୍‌ ଡାବି ଆଇଲା, ସେ ଗୁନର୍‌ ଲାଡେ, ତିନ୍‌ତାଲାର୍‌ ଗର୍‌ ଉପ୍‌ରେଅନି ତଲେ ଅଦ୍‌ରିଦେଲା । ସେମନ୍‌ ତାକେ ଉଟାଇବା ବେଲାଇ, ସେ ମରିଜାଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ମାତର୍‌ ପାଉଲ୍‌ ତଲ୍‌କେ ଉତ୍‌ରି ଆସି ତାକେ ପାଟାଲି, ଦାରି କଇଲା, “ଡରା ନାଇ । ତାକେ ଜିବନ୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ତାର୍‌ପଚେ ସେ ଉପ୍‌ରେ ବାଉଡିଜାଇ ରୁଟି ବାଙ୍ଗାଇ କାଇଲା, ଆରି ବେଲ୍‌ ଉଦ୍‌ବାଜାକ ସେମନର୍‌ ସଙ୍ଗ୍‍ ବେସି କାତାବାର୍‌ତା ଅଇ ତେଇଅନି ବାରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ଲକ୍‌ମନ୍‌ ଦାଙ୍ଗ୍‌ଡାକେ ଜିବନ୍‌ ରଇଲାଟା ଦେକି ତାର୍‌ ଗରେ ଦାରିଗାଲାଇ ଆରି ସାର୍‌ଦା ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ଆମେ ଆଗ୍‌ତୁ ଜାଜେ ଚଗି, ଆସସେ ଜିବାକେ ବାରଇଲୁ । ତେଇଅନି ଆମେ ପାଉଲ୍‌କେ ଜାଜେ ନେଇଜିବାକେ ଟିକ୍‌ କରିରଇଲୁ । କାଇକେବଇଲେ ସେ ସମ୍‌ଦୁର୍‌ବାଟେ ଜାଇ, ସେ ଜାଗାଇ କେଟ୍‌ବି ବଲି କଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ସେ ଜେଡେବେଲା ଆମ୍‌କେ ଆସସେ ବେଟ୍‌ ଅଇଲା, ଆମେ ତାକେ ଜାଜେ ଚଗାଇ ମିତିଲିନି ଜାଗାଇ ଗାଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ତେଇଅନି ଆରି ଜିବାର୍‌ଦାରି ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ କିଅସ୍‌ ଲଗେ କେଟ୍‌ଲୁ । ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ମିଲିଟସେ କେଟ୍‌ଲୁ । ଆରି ଗଟେକ୍‌ ଦିନ୍‌ ପଚେ ଆମସେ କେଟ୍‌ଲୁ । ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ମିଲିଟସେ କେଟ୍‌ଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ଆସିଆ ରାଇଜେ ଆରି ବେସି ଦିନ୍‌ ନ ରଇକରି, ଏପିସସ୍‌ କଣ୍ଡିକଣ୍ଡି ଜାଜ୍‌ ଚାଲାଇବାକେ ପାଉଲ୍‌ ଟିକ୍‌ କଲା । ଜଦି ଅଇପାର୍‌ସି, ପେନ୍‌ଟିକସ୍‌ଟ୍‌ ଦିନେ ଜିରୁସାଲାମ୍‌ କେଟ୍‌ବାକେ ସେ ତେରେପେତେ ଅଇତେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ପାଉଲ୍‌ ମିଲିଟସେଅନି ଏପିସି ମଣ୍ଡଲିର୍‌ ପାର୍‌ଚିନ୍‌ ମନ୍‌କେ ତାର୍‌ ସଙ୍ଗ୍‍ ମିସ୍‌ବାକେ ଡାକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ସେମନ୍‌ ଆସି କେଟ୍‌ଲାକେ ପାଉଲ୍‌ କଇଲା, “ରମିୟ ରାଇଜର୍‌ ଆସିଆଇ କେଟ୍‌ଲା ପର୍‌ତୁମ୍‌ ଦିନେଅନି, କେନ୍ତି ତମର୍‌ ସଙ୍ଗ୍‍ ବେସି ବେଲା କାଟାଇଲି ଆଚି, ସେଟା ତମେ ଜାନିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ଜିଉଦିମନର୍‌ କୁଟ୍‌ ପାଁଚ୍‌ନାର୍‌ ଲାଗି, ମକେ ଜନ୍‌ ଦୁକ୍‌ କସ୍‌ଟ ପାଇକରି ମୁରଚ୍‌ବାକେ ପଡ୍‌ଲା, ସେ ବିତ୍‌ରେ ମୁଇ ପରମେସରର୍‌ ସେବାକାରିଆ ଇସାବେ ଆଁସୁପାନି ଜଡାଇ, ମୁଣ୍ଡ୍‌ ତଲେକରି, କାମ୍‌ କଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ତମେ ଜାନିଆଚାସ୍‌, ଲକ୍‌ମନର୍‌ ଲଗେ କବର୍‌ ଜାନାଇଲାବେଲେ ଆରି ତମର୍‌ ଗର୍‌ମନ୍‌କେ ଉପ୍‌ଦେସ୍‌ ଦେଲାବେଲେ, ତମର୍‌ ଉପ୍‌କାର୍‌ ଅଇଲାପାରା କାଇ ବିସଇ ମିସା ଜାନାଇବାକେ ମୁଇ ଦୁଇମନିଆ ଅଇନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ଜିଉଦି ଆରି ଗିରିକ୍‌ ଲକ୍‌ମନ୍‌କେ ସବୁକେ ମୁଇ ଡାଟ୍‌ ସଙ୍ଗ୍‍ ଜାଗ୍‍ରତ୍‌ ରଇବା କାତା ସୁନାଇ ରଇଲି, ଜେନ୍ତାରିକି, ସେମନ୍‌ ପାପେଅନି ବାଉଡିକରି ପର୍‌ମେସରର୍‌ ବାଟେ ମନ୍‌ ଦେଅତ୍‌ ଆରି ମାପ୍‌ରୁ ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ଏବେ ସୁକଲ୍‌ଆତ୍‌ମାର୍‌ ଚାଲ୍‌ନାଦେଲା ଆଦେସ୍‌ ମାନିକରି, ମୁଇ ଜିରୁସାଲମେ ଗାଲିନି । ତେଇ ମକେ କାଇଟା ଅଇସି ନାଜାନି । ");
INSERT INTO dso_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ସୁକଲ୍‌ଆତ୍‌ମା ମକେ ଜାଗ୍‍ରତ୍‌ କରିଦେଇ ଆଚେ ଜେ, ମୁଇ ସବୁ ନଅରେ ବନ୍ଦି ଗରେ ରଇକରି କସ୍‌ଟ ପାଇବି । ");
INSERT INTO dso_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ମର୍‌ ନିଜର୍‌ ଜିବନ୍‌, ମର୍‌ ପାଇ, ମୁଇ ଇନ୍‌ କଲିନି । ପର୍‌ମେସରର୍‌ ଜିବନ୍‌ ଦୁକାଇଲା ବିସଇ ଆରି ମାପ୍‌ରୁ ଜିସୁ ଜନ୍‌ କାତା ଜାନାଇବାକେ ମକେ ଦାଇତ୍‌ ଦେଲାଆଚେ, ସେଟା ସାରାଇବି ଆରି ସୁବ୍‌ କବର୍‌ ଜାନାଇବାଟା ପୁରାପୁରୁନ୍‌ କର୍‌ବି । ଏତ୍‌କି ସେ ମୁଇ ମନ୍‌ କଲିନି । ");
INSERT INTO dso_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ପର୍‌ମେସରର୍‌ ରାଇଜ୍‌ ବିସଇ ଜାନାଇବାକେ ମୁଇ ତମର୍‌ ସବୁ ଲକର୍‌ ଲଗେ ଜାଇଆଚି । ଏବେ ମୁଇ ଜାନିଆଚି, ତମର୍‌ ବିତ୍‌ରେଅନି କେମିସା ମର୍‌ ମୁଁ କେବେ ଦେକି ନାପାରାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ତେବର୍‌ପାଇ ଆଜି ବେଲା ମିଲ୍‌ଲା ଆଚେ ବଲି ମୁଇ ଡାଟ୍‌ ସଙ୍ଗ୍‍ ତମ୍‌କେ ଜାନାଇଲିନି । ତମର୍‌ ବିତ୍‌ରେଅନି କେ ଜଦି ବାଟ୍‌ ବାନା ଅଇଗାଲେ, ସେଟାର୍‌ପାଇ ମୁଇ ଦାଇ ନଇ । ");
INSERT INTO dso_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","କାଇକେବଇଲେ ତମର୍‌ଟାନେ ପର୍‌ମେସରର୍‌ ସବୁଜାକ ଆଦେସ୍‌ ଜାନାଇବାକେ, ମୁଇ ଦୁଇମନିଆ ଅଇନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ତେବର୍‌ପାଇ ତମେ ନିଜର୍‌ ବିସଇ ଆରି ସୁକଲ୍‌ଆତ୍‌ମା ତାର୍‌ ସତ୍‌ ଗିଆନେ ଜନ୍‌ ବିସ୍‌ବାସି ମାନ୍ଦାକେ ଦେକାରକାପାଇ ଚାଡିଦେଇ ଆଚେ, ସେ ସବୁ ବିସଇଟାନେ ଜାଗ୍‍ରତ୍‌ ଉଆ । ମେଣ୍ଡା ଚାରାଉ ଗଉଡ୍‌ପାରା ପରମେସରର୍‌ ମଣ୍ଡଲିର୍‌ ଜତନ୍‌ ନିଆ । ସେ ମଣ୍ଡଲିକେ ପରମେସର୍‌ ତାର୍‌ ନିଜର୍‌ ବନିଦେଇ ଗେନିଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ମୁଇ ଜାନିଆଚି, ମୁଇ ଗାଲାପଚେ ତମର୍‌ ବିତ୍‌ରେ ଅପର୍‌ବଲ୍‌ ଗଦଡୁର୍‌କାମନ୍‌ ଆଇବାଇ ଆରି ମେଣ୍ଡାରାସିକେ ଚିନ୍‌ ଚତର୍‌ କରିସେ ଚାଡ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ବେଲା ଆଇସି, ତମର୍‌ ନିଜର୍‌ ଦଲର୍‌ କେତେ ଲକ୍‌ ବିସ୍‌ବାସିମନ୍‌କେ ମିଚ୍‌ କାତା କଇ ତାକର୍‌ ବାଟେ ଡାକି ନେବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ସେ ବେଲେ ତମେ ଜାଗ୍‍ରତ୍‌ ଅଇ ରୁଆ । ମୁଇ ତିନ୍‌ ବରସ୍‌ ଜାକ ଦିନ୍‌ ରାତି ଆଁସୁପାନି ଜରାଇ, ତମ୍‌କେ ଗଟେକ୍‌ ଗଟେକ୍‌ କରି, ସବୁ ଲକ୍‌କେ ସିକାଇ ଆଚି, ଏ କାତା ଏତାଇରୁଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ଏବେ ମୁଇ ତମ୍‌କେ ପରମେସର୍‍କେ, ଆରି ତାର୍‌ ଜିବନ୍‌ ଦୁକାଇବା ବାକିଅଟାନେ ସର୍‌ପି ଦେଲିନି । ସେ ବାକିଅ ତମ୍‌କେ ଡାଟ୍‌ କରାଇସି ଆରି ପରମେସରର୍‌ ଲକ୍‌ମନର୍‌ ପାଇ ଅଇବା ସବୁ ଆସିର୍‌ବାଦ୍‌ ତମ୍‌କେ ଦେଇପାର୍‌ସି । ");
INSERT INTO dso_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ମୁଇ କାର୍‌ ସୁନା, ରୁପା କି ଲୁଗାପଚିଆ ମିଲାଇବି ବଲି ଆସା କରିନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ମର୍‌ ଏ ଦୁଇଟା ଆତେ କସ୍‌ଟ କରି, ମର୍‌ ପାଇ ଆରି ମର୍‌ସଙ୍ଗ୍‍ ରଇବାଲକର୍‌ ପାଇ, ଦର୍‌କାର୍‌ ରଇଲାଟା ପୁରାପୁରୁନ୍‌ କଲିଆଚି ଏଟା ତମେ ଜାନିଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ମିଲାଇବାଟାନେଅନି ଦାନ୍‌ଦେବାଟା ଅଦିକ୍‌ ସାର୍‌ଦାର୍‌ ବିସଇ ଅଇରଇସି । ନିଜେ ଜିସୁ ମାପ୍‌ରୁ ଏ ବାକିଅ ସୁମର୍‌ନା କରିରଇଲା । ଏନ୍ତାରି କସ୍‌ଟ କାମେଅନି ନାପାର୍‌ଲା ଲକ୍‌ମନ୍‌କେ ସାଇଜ କର୍‌ବାର୍‌ ଆଚେ । ଏ ବିସଇ ମୁଇ ତମ୍‌କେ ସବୁବେଲେ କରିଦେକାଇଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ଏ ସବୁ କାତା କଇସାରାଇ ପାଉଲ୍‌ ସେମନର୍‌ ସଙ୍ଗ୍‍ ମାଣ୍ଡିକୁଟା ଦେଇ ପାର୍‌ତନା କଲା । ");
INSERT INTO dso_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ସବୁ ଲକ୍‌ କାନ୍ଦି କାନ୍ଦି କରି ପାଉଲ୍‌କେ ପାଟାଲିକରି ଚୁମ୍‍ଚାଟ୍‌ କରି ପାଟାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ପାଉଲ୍‌ ସେମନ୍‌କେ “ତମେ ଆରି ମକେ ଦେକିନାପାରାସ୍‌ ।” ବଲି କଇରଇଲାକେ, ସେମନ୍‌ ବେସି ମନ୍‌ଦୁକ୍‌ ଅଇଜାଇରଇଲାଇ । ଲକ୍‌ମନ୍‌ ପାଉଲ୍‌କେ ପାଟାଇ ଦେବାକେ, ଜାଜେ ନେଇ ଚାଡ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ସେମନ୍‌କେ ପାଟାଇଦେଇକରି ଆମେ ତେଇଅନି ଜାଜେ ଚଗି ସିଦା କସ୍‌ ନାଉଁର୍‌ ଜାଗାଇ କେଟ୍‌ଲୁ । ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ରଦେ କେଟ୍‌ଲୁ, ସମ୍‌ଦୁର୍‌ ପାଲି ପାଲି ଜାଇ ପାତାରା ନାଉଁର୍‌ ଜାଗାଇ ଗାଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ତେଇଅନି ପିନିସିଆଇ ଜାଇତେ ରଇବା ଗଟେକ୍‌ ଜାଜେ ଚଗି ଜିବାର୍‌ ଦାର୍‌ଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ତାର୍‌ପଚେ ଡିସ୍‌ତେରଇବା ସାଇପରସ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ କେଟ୍‌ଲୁ । ତେଇଅନି ତାର୍‌ ଦକିଣ୍‌ଦିଗ୍‌ ବାଟେ ଜାଇ ସିରିଆଇ କେଟ୍‌ଲୁ । ଆମେ ଟାୟର୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ, ପାନିଜାଜେଅନି ଉତର୍‌ଲୁ, କାଇକେ ବଇଲେ, ଏ ଜାଜେଅନି ଦିନ୍‍ସୁମନ୍‌ ଉତ୍‌ରାଇବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ତେଇ ଆମେ କେତେଟା ବିସ୍‌ବାସିମନର୍‌ ସଙ୍ଗ୍‍ ବେଟ୍‌ ଅଇ ସେମନର୍‌ ସଙ୍ଗ୍‍ ଗଟେକ୍‌ ଆଟ୍‌ ରଇଲୁ, ସୁକଲ୍‌ଆତ୍‌ମାର୍‌ ଚାଲ୍‌ନା ପାଇକରି ସେମନ୍‌, ଜିରୁସାଲମେ ଜିବାକେ ପାଉଲ୍‌କେ ମନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ମାତର୍‌ ସେମନର୍‌ ସଙ୍ଗ୍‍ ଗଟେକ୍‌ ଆଟ୍‌ ରଇଲା ପଚେ, ଆମେ ସେମନ୍‌କେ ଚାଡିକରି ଆମର୍‌ ବାଟେ ଉଟି ଆଇଲୁ । ଆମ୍‌କେ ପାଟାଇ ଦେବାକେ ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ପିଲା ମାଇଜି ସଙ୍ଗ୍‍ ଗଡ୍‌ ବାଇରେ ରଇବା, ସମ୍‌ଦୁର୍‌ କଣ୍ଡିଜାକ ଆଇଲାଇ । ତେଇ ଆମେ ସବୁ ଲକ୍‌ ମାଣ୍ଡିକୁଟା ଦେଇ ପାର୍‌ତନା କଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ତାର୍‌ପଚେ ଆମେ ସେମନର୍‌ ସଙ୍ଗ୍‍, ଜୁଆର୍‌ବେଟ୍‌ ଅଇ ଜାଜେ ଚଗ୍‌ଲୁ, ସେମନ୍‌ ଗରେ ବାଉଡି ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ଆମେ ଟାୟରେଅନି ପାନିଜାଜେ ବାରଇ ପତ୍‌ଲମା ନାଉଁର୍‌ ଜାଗାଇ କେଟ୍‌ଲୁ, ତେଇ ବିସ୍‌ବାସି ବାଇମନର୍‌ ସଙ୍ଗ୍‍ ଜୁଆର୍‌ବେଟ୍‌ ଅଇ ଗଟେକ୍‌ ଦିନ୍‌ ରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ଆର୍‌କର୍‌ ଦିନେ ଆମେ ସେ ଜାଗା ଚାଡି, ସିସେରିଆ ନାଉଁର୍‌ ଜାଗାଇ କେଟ୍‌ଲୁ, ତେଇ ମାପ୍‌ରୁର୍‌ କାତା ଜାନାଇବା, ପିଲିପର୍‌ ଗରେ ରଇଲୁ, ଜିରୁସାଲମେ ସେବା କର୍‌ବାକେ ବାଚାଇଅଇରଇବା ସାତ୍‌ ଲକର୍‌ ବିତ୍‌ରେଅନି, ପିଲିପ୍‌ ଗଟେକ୍‌ ଲକ୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ପିଲିପର୍‌ ଚାର୍‌ଟା ଦାଙ୍ଗ୍‌ଡି ଟକିମନ୍‌ ବିବା ନ ଅଇକରି ରଇଲାଇ, ସେମନ୍‌ ପରମେସର୍‌ କଇଲା କାତା ଜାନାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ଆମେ ସେ ଜାଗାଇ ବେସି ଦିନ୍‌ ରଇଲା ପଚେ, ଜିଉଦା ରାଇଜେଅନି ଆଗାବ୍‌ ନାଉଁର ଗଟେକ୍‌ ବବିସତ୍‌ବକ୍‌ତା ତେଇ ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ସେ ଆମର୍‌ ଲଗେ ଆସି ପାଉଲର୍‌ ଆଟାବେଡା ନେଲା, ତେଇ ସେ ନିଜର୍‌ ଆତ୍‌ ଗଡ୍‌ ବାନ୍ଦି କରି କଇଲା, “ସୁକଲ୍‌ଆତ୍‌ମା ମକେ ଜାନାଇଲା ଆଚେ ଜେ, ଏ ଆଟାବେଡାର୍‌ ସାଉକାର୍‌କେ ଜିରୁସାଲାମର୍‌ ଜିଉଦିମନ୍‌, ଏନ୍ତି ବାନ୍ଦି ଜିଉଦିନଇଲା ଲକ୍‌ମନ୍‍କେ ସର୍‌ପିଦେବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ଏଟା ସୁନି ଆମେ ଆରି ସେ ଜାଗାଇ ରଇଲା ବିନ୍‌ଲକ୍‌ମନ୍‌, ପାଉଲ୍‌କେ “ ଜିରୁସାଲାମେ ନ ଜାଆ” ବଲି ବାବୁଜିଆ କଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ମାତର୍‌ ପାଉଲ୍‌ କଇଲା, “ତମେ ଏଟା କାଇଟା କଲାସ୍‌ନି, କାଇକେ ଏନ୍ତି କାନ୍ଦାବୁବା ଅଇ ମର୍‌ ମନ୍‌ କିଲ୍‌ବିଲ୍‌ କଲାସ୍‌ନି ? ଜିରୁସାଲାମ୍‌ ଅବ୍‌କା ବାନ୍ଦାଇ ଅଇବାକେସେ ନାଇ, ମାତର୍‌ ମୁଇ ମାପ୍‌ରୁ ଜିସୁର୍‌ ପାଇ ମର୍‌ବାକେ ମିସା ରାଜି ଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ଆମେ ତାକେ ବୁଜାଇ ନାପାରି, ତେଇଅନି ଚିମ୍‌ରାଇ ଅଇ କଇଲୁ “ମାପ୍‌ରୁ ମନ୍‍ କଲାଟା ପୁରାପୁରୁନ୍‌ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ତେଇ କେତେଦିନ୍‌ ରଇକରି, ଆମର୍‌ ଦିନ୍‍ସୁପତର୍‌ ସାଜାଡି ଜିରୁସାଲମେ ଜିବାକେ ବାରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ସିସେରିଆର୍‌ କେତେଟା ସିସ୍‌ମନ୍‌, ଆରି ସାଇପରସର୍‌ ମନାସନ୍‌ ନାଉଁର୍‌ ବିସ୍‌ବାସି ମିସା ଆମର୍‌ ସଙ୍ଗ୍‍ ଆଇଲା । ମନାସନର୍‌ ଗରେ ଆମେ ରଇବାକେ ଟିକ୍‌ ଅଇରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ଜିରୁସାଲମର୍‌ ବିସ୍‌ବାସି ବାଇମନ୍‌ ଆମ୍‌କେ ସାର୍‌ଦାସଙ୍ଗ୍‍ ଗତିଆ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ପାଉଲ୍‌ ଆମର୍‌ ସଙ୍ଗ୍‍ ଜାକୁବ୍‌କେ ଦେକ୍‌ବାକେ ଗାଲା, ମଣ୍ଡଲିର୍‌ ସବୁ ପାର୍‌ଚିନ୍‌ମନ୍‌ ତେଇ ରୁଣ୍ଡି ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ପାଉଲ୍‌ ସେମନ୍‌କେ ଜୁଆର୍‌ବେଟ୍‌ ଅଇ ତାକର୍‌ କାମେଅନି, ପରମେସର୍‌ ଜିଉଦିନଇଲା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ଜାଇଟା କରିରଇଲା ତାର୍‌ ଗଟେକ୍‌ ଟିକିନିକିର୍‌ ତାଲିକା ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ତାର୍‌ କାତା ସୁନ୍‌ଲାପଚେ ସେମନ୍‌ ସବୁ ଲକ୍‌ ପରମେସରର୍‌ ଡାକ୍‌ପୁଟା କଲାଇ । ତାର୍‌ପଚେ କଇଲାଇ, “ବାଇ ପାଉଲ୍‌, ତମେ ଦେକ୍‌ଲାସ୍‌ନି, କେନ୍ତି, ଏବେ ଅଜାର୍‌ ଅଜାର୍‌ ଜିଉଦିମନ୍‌ ମାପ୍‌ରୁ ଜିସୁକେ ମାନ୍‌ଲାଇନି ଆରି ସେମନ୍‌ ରିତିନିତି ମିସା ମାନ୍‌ଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ସେମନ୍‌ କବର୍‌ ପାଇଆଚତ୍‌ ଜେ, ତମେ ଜିଉଦିନଇଲା ଦେସେ ବାସା ଅଇରଇଲା, ଜିଉଦିମନ୍‌କେ ମସାର୍‌ ରିତିନିତି ଚାଡିଦେବାକେ, ସେମନର୍‌ ପିଲାମନ୍‌କେ ସୁନତ୍‌ ନ କର୍‌ବାକେ ଆରି ଜିଉଦି ରିତିନିତି ନ ମାନ୍‌ବାକେ ସିକିଆ ଦେଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ତମେ ଇତି କେଟିଆଚାସ୍‌ ବଲି ସେମନ୍‌ ସତ୍‌ସେ ସୁନ୍‌ବାଇ । ସେନ୍ତି ଆଲେ କାଇଟା କରିଅଇସି ? ");
INSERT INTO dso_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ଆମେ ମନ୍‍କଲୁନି ତମେ ଗଟେକ୍‌ କାମ୍‌ କରା ବଲି । ଇତି ରଇଲା ଚାରିଲକ୍‌ ଗଟେକ୍‌ ମାନତ୍‌ କଲାଇଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ସେମନର୍‌ ସଙ୍ଗ୍‍ ଜାଆ । ସୁକଲ୍‌ ଅଇବା ବିଦି ମାନ୍‌ବାତେଇ ସେମନର୍‌ ସଙ୍ଗ୍‍ ମିସା ଆରି ସେମନର୍‌ କର୍‌ଚା ଦେ । ତାର୍‌ପଚେ ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ମୁଣ୍ଡ୍ କୁରାଇ ଅଅତ୍‌ । ଇତିଅନି ଜାନାପଡ୍‌ସି ଜେ, ତମର୍‌ ବିସଇ ବାରଇରଇବା କାଇମିସା କବର୍‌ ସତ୍‌ ନଏଁ, ମାତର୍‌ ତମେ ମସାର୍‌ ରିତିନିତି ଇସାବେ ଜିବନ୍‌ ଜିଇଲାସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ମାତର୍‌ ଜିଉଦି ନ ଅଇଲା ଲକ୍‌ମନ୍‌ ବିସ୍‌ବାସି ଅଇଆଚତ୍‌ । ସେମନ୍‍କେ ଗଟେକ୍‌ ଚିଟି ଲେକି ଉପ୍‌ଦେସ୍‌ ଦେଲୁଆଚୁ ଜେ, ଆମର୍‌ କଇଲା କାତା ଇସାବେ, ସେମନ୍‌ ପୁତ୍‌ଲାମନ୍‌କେ ବିରୁକଲା କାଦି ନ କାଅତ୍‌, ବନି ନ କାଅତ୍‌, ଟଟ୍‌ରି ପିଚ୍‌କି ମରାଇରଇବା ପସୁର୍‌ ମାଉଁସ୍‌ ନ କାଅତ୍‌ ଆରି ବିନ୍‌ ମାଇଜିମନର୍‌ ସଙ୍ଗ୍‍ ପାପ୍‌ କାମ୍‌ କର୍‌ବାଟାନେଅନି ଦୁରିକେ ରଅତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ତାର୍‌ ପର୍‌ଦିନେ ପାଉଲ୍‌ ସେ ଚାର୍‌ ଲକର୍‌ ସଙ୍ଗ୍‍ ସୁକଲ୍‌ ଅଇବା ବିଦି ମାନ୍‌ଲା । ତାର୍‌ ପଚେ ସେ ମନ୍ଦିରେ ଜାଇ ସୁକଲ୍‌ ଅଇବା କାମ୍‌ କେବେ ସାର୍‌ସି, ଆରି କେଡେବଲ୍‌ ବିରୁ କର୍‌ବାଟା ଅଇସି, ସେଟା ଜାନାଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ଏ ସୁକଲ୍‌ ଅଇବା କାମର୍‌ ସାତ୍‌ ଦିନ୍‌ ଗାଲା ପଚେ, ଆସିଆ ରାଇଜର୍‌ କେତେଟା ଜିଉଦିମନ୍‌ ପାଉଲ୍‌କେ ମନ୍ଦିରେ ଦେକ୍‌ଲାଇ, ସେମନ୍‌ ତେଇ ରୁଣ୍ଡ୍‌ଲା ଲକ୍‌ମନ୍‌କେ ଉସ୍‌କାଇକରି ପାଉଲ୍‌କେ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ସେମନ୍‌ ଆଉଲି ଅଇକରି କଇଲାଇ, “ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌ ଆମ୍‌କେ ସାଇଜ କରା ! ଏ ଲକ୍‌ ଚାରିବାଟେ ଜାଇକରି ଇସ୍‌ରାଏଲ୍‌ ମନର୍‌ ବିରଦେ, ମସାର୍‌ ନିୟମ୍‌ ଆରି ଏ ମନ୍ଦିର୍‌ ବିରଦେ, ସିକିଆ ଦେଲାନି । ଏବେ କେତେଟା ଗିରିକ୍‌ ଲକ୍‌ମନ୍‌କେ ମନ୍ଦିର୍‌ ବିତ୍‌ରେ ଆନି, ଏ ସୁକଲ୍‌ ଜାଗା ଅସୁକଲ୍‌ କଲା ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ସେମନ୍‌ ଗଡ୍‌ ବିତ୍‌ରେ ଏପିସସର୍‌ ତର୍‌ପିମ୍‌କେ ପାଉଲ୍‌ ସଙ୍ଗ୍‍ ଦେକି ରଇଲାର୍‌ ପାଇ ବାବ୍‌ଲାଇ ଜେ, ପାଉଲ୍‌ ତାକେ ମନ୍ଦିରେ ନେଲା ଆଚେ ବଲି । ");
INSERT INTO dso_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ଗଡର୍‌ ଗୁଲାଇ ବାଟେ ରିସାର୍‌ କିଲ୍‌ବିଲ୍‌ ଡାବିଅଇଗାଲା । ଲକ୍‌ମନ୍‌ ପାଉଲ୍‌କେ ମନ୍ଦିର୍‌ ବାଇରେ ଅର୍‌ଗଡି ଆନ୍‌ଲାଇ, ଆରି ମନ୍ଦିରର୍‌ କାପାଟ୍‌ମନ୍‌ ଡାବିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ରିସାଅଇଲା ଲକ୍‌ମନ୍‌ ପାଉଲ୍‌କେ ମରାଇବାକେ ଚେସ୍‌ଟା କଲାଇ, ମାତର୍‌ ସମାନ୍‍ ସେ ବେଲାଇ “ ଜିରୁସାଲାମେ ଗଣ୍ଡ୍‍ଗଲ୍‌ ଚାଲ୍‌ଲା ଆଚେ ।” ବଲି ରମିୟ ସନିଅମନର୍‌ କବର୍‌ ସୁନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ସେ କେତେଟା ସେନାପତି କେତେଟା ସନିଅମନ୍‌କେ ଦାରି ଦାପ୍‌ରେ, ଗଟ୍‍ନା ଗଟ୍‌ଲା ଜାଗାଇ ଆସି କେଟ୍‌ଲା । ଲକ୍‌ମନ୍‌ ସନିଅ ଆରି ସେନାପତିକେ ଦେକିକରି ପାଉଲ୍‌କେ ମାର୍‌ବାଟା ଚାଡିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ସେନାପତି ପାଉଲ୍‌କେ ବନ୍ଦିକରି, ତାକେ ଦୁଇଟା ସିକ୍‌ଲିତେଇ ବାନ୍ଦ୍‌ବାକେ ଆଦେସ୍‌ ଦେଲା, ତାର୍‌ ପଚେ ସେ ପାଚାର୍‌ଲା, “ଏ ଲକ୍‌ କେ ? ଆରି ସେ କାଇଟା କଲା ଆଚେ ?” ");
INSERT INTO dso_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ଲକ୍‌ମନର୍‌ ମାନ୍ଦାଇଅନି କେ କେତେ ରକାମ୍‌ କାତା କଇ ଆଉଲିଅଇଲାଇ । ଏନ୍ତି କିରମାର୍‌ ଅଇଲା ଜେ, ସନିଅମନର୍‌ ମୁକିଆ, ସତ୍‌ସେ, ଏ ଗଟ୍‍ନା କାଇକେ ଅଇଲା ବଲି ବୁଜିନାପାର୍‌ଲା । ସେଟାର୍‌ପାଇ ସେ ପାଉଲ୍‌କେ ଗଡ୍‌ବିତ୍‌ରେ ଦାରିଜିବାକେ ସନିଅମନ୍‌କେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ସନିଅମନ୍‌ ପାଉଲ୍‌କେ ଦାରି ଚଗ୍‌ବା ପାଉଚେ କେଟ୍‌ଲା ଦାପ୍‌ରେ, ତାର୍‌ ଚାରିବେଡ୍‌ତି ରଇଲା ଲକ୍‌ମନ୍‌ ବେସି ଆଉଲି ଅଇଲାଇକେ ସନିଅମନ୍‌ ତାକେ ବଇ ଦାରିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ବଇନେବା ବେଲେ ଲକ୍‌ମନ୍‌ ପଚ୍‌ପଚ୍‌ ଆସି ତାକେ ମରାଆ ବଲି ଆଉଲି ଅଇତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ପାଉଲ୍‌କେ ସନିଅମନ୍‌ ଗଡ୍‌ବିତ୍‌ରେ ନେବାବେଲେ ସେ ସନିଅମନର୍‌ ମୁକିଆକେ କଇଲା, “ମୁଇ ତମର୍‌ ସଙ୍ଗ୍‍ କାତା ଅଇପାର୍‌ବି କି ?” ସନିଅମନର୍‌ ମୁକିଆ କଇଲା, “ତୁଇତା ଗିରିକ୍‌ କଇଲୁସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ସେନ୍ତି ଆଲେ କେତେ ଦିନ୍‌ ଆଗେ ମିସରର୍‌ ଜନ୍‌ ଲକ୍‌ ଚାରି ଅଜାର୍‌ କାଙ୍ଗାର୍‌ମନର୍‌ ସଙ୍ଗ୍‍ କେଟିରଇଲା, ତମେ ସେ ଲକ୍‌ ନୁଆଁସ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ପାଉଲ୍‌ କଇଲା, “ମୁଇ ସିଲିସିଆର୍‌ ତାର୍‌ସିସେ ଜନମ୍‌ କରିରଇବା ଗଟେକ୍‌ ଜିଉଦି, ଗଟେକ୍‌ ମୁକିଅ ଗଡର୍‌ ଲକ୍‌ । ଏ ଲକ୍‌ମନ୍‌କେ ବୁଜାଇ କଇବାକେ ଦୟାକରି ମକେ ଅଲପ୍‌ ଆଦେସ୍‌ ଦିଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ସେନାପତି ତାକେ ଆଦେସ୍‌ ଦେଲାକେ ପାଉଲ୍‌ ପାଉଚ୍‌ ଉପ୍‌ରେ ଟିଆଅଇ, ଲକ୍‌ମନ୍‌କେ ଚିମ୍‌ରା ଅଇବାକେ ଆତ୍‌ ସାଗିଆ କଲା । ସେମନ୍‌ ଚିମ୍‌ରା ଅଇଲାଇକେ, ପାଉଲ୍‌ ଇବ୍‌ରୁ ବାସାଇ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ମର୍‌ ସଙ୍ଗାରି ଜିଉଦି ବାଇ ଆରି ବାବାମନ୍‌, ମର୍‌ ନିଜର୍‌ବାଟେଅନି ମୁଇ ଜାଇଟା କଇଲିନି ସେଟା ସୁନା !” ");
INSERT INTO dso_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ସେମନର୍‌ ସଙ୍ଗ୍‍ ସେ ଇବ୍‌ରୁ ବାସାଇ କାତା କଇବାଟା ସୁନି, ଲକ୍‍ ମାନ୍ଦା ଚୁପ୍‍ଚାପ୍‌ ଅଇଲାଇ ଆରି ପାଉଲ୍‌ କଇବାକେ ଦାର୍‌ଲା, ");
INSERT INTO dso_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ମୁଇ ଗଟେକ୍‌ ଜିଉଦି ଲକ୍‌, ସିଲିସିଆର୍‌ ତାର୍‌ସିସେ ମର୍‌ ଜନମ୍‌, ମାତର୍‌ ମୁଇ ଜିରୁସାଲାମେ କାଇପିଇ ବଡ୍‌ ଅଇରଇଲି ଆରି ଗମଲିଏଲର୍‌ ସିସ୍‌ ରଇଲି । ଆମର୍‌ ଆନିଦାଦିମନର୍‌ ରିତିନିତି, ମୁଇ ଟିକ୍‌ ଇସାବେ ସିକିରଇଲି ଆରି ତମର୍‌ ପାରା ପର୍‌ମେସର୍‌କେ ମାନିକରି ଜିଇତେରଇଲି । ");
INSERT INTO dso_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ମାପ୍‌ରୁର୍‌ ବାଟେ ଜିବା ଲକ୍‌ମନ୍‌କେ ମାର୍‌ଦାର୍‌ କରି ସେମନ୍‌କେ ମରାଇଦେଇତେ ରଇଲି । ମାଇଜିଟକି ମୁନୁସ୍‌ପିଲା ସବୁକେ ବାନ୍ଦିକରି ବନ୍ଦି ଗରେ ପୁରାଇ ଦେଇତେ ରଇଲି । ");
INSERT INTO dso_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ମର୍‌ ଏ କାତା ପୁରା ସତ୍‌ । ବଡ୍‌ ପୁଜାରି ଆରି ବଡ୍‌ ସବାର୍‌ ସବୁ ପାର୍‌ଚିନ୍‌ମନ୍‌ ସାକି ଆଚତ୍‌ । ଲକ୍‌ମନ୍‌କେ ବନ୍ଦି କରି ସିକ୍‌ଲି ସଙ୍ଗ୍‍ ବାନ୍ଦି ଜିରୁସାଲାମ୍‌ ଦାରିଆଇବାକେ, ମୁଇ ବଡ୍‍ ପୁଜାରିର୍‌ ଟାନେଅନି ଆଦେସ୍‌ ପତର୍‌ ପାଇ, ଦାମାସ୍‌କସେ ରଇବା ଜିଉଦି ବାଇମନର୍‌ ଲଗେ ଗାଲି ।” ");
INSERT INTO dso_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ମୁଇ ଜେଡେବେଲା ବାରଇ ଜିରୁସାଲମେ ଜିବାବେଲେ ଦାମାସ୍‌କସ୍‌ ଲଗାଲଗି ଅଇଲି, ପାକାପାକି ମୁଣ୍ଡ୍‌ବେଲାଇ, ଆକାସେଅନି ଗଟେକ୍‌ ଉଜଲ୍‌ ମର୍‌ ଚାରିବେଡ୍‌ତି ଉଜଲ୍‌ ଅଇଗାଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ମୁଇ ବୁଏଁ ଉମ୍‌ତାଡିଅଇ ଅଦ୍‌ରିଗାଲି ଆରି ମର୍‌ପାଇ ଏ କାତା ସୁନ୍‌ଲି, ସାଉଲ୍‌, ସାଉଲ୍‌ ! ମକେ ତୁଇ କାଇକେ କସ୍‌ଟ ଦେଲୁସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ମୁଇ ପାଚାର୍‌ଲି, “ମାପ୍‌ରୁ, ତମେ କେ ? ସେ ମକେ କଇଲା, ‘ତମେ ଜାକେ କସ୍‌ଟ ଦେଲାସ୍‌ନି’ ମୁଇ ସେ ନାଜରିତର୍‌ ଜିସୁ ।” ");
INSERT INTO dso_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ମର୍‌ସଙ୍ଗ୍‍ ରଇଲା ଲକ୍‌ ସେ ଉଜଲ୍‌ ଦେକ୍‌ଲାଇ, ମାତର୍‌ ମର୍‌ ସଙ୍ଗ୍‍ କାତା ଅଇବା ଲକର୍‌ ସର୍‌ ସୁନି ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ମୁଇ ପାଚାର୍‌ଲି, “ମାପ୍‌ରୁ, ମୁଇ କାଇଟା କର୍‌ବି ?” ମାପ୍‌ରୁ ମକେ କଇଲା, “ଉଟ୍‌, ଆରି ଦାମାସ୍‌କସେ ଜାଆ, ପରମେସର୍‌ ତର୍‌ ପାଇ ଜନ୍‌ କାମ୍‌ ଟିକ୍‌ କଲା ଆଚେ, ସେଟା ତମ୍‌କେ ତେଇ ଜାନାଇ ଦିଆଅଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ସେ ଉଜଲ୍‌ ଏତେକ୍‌ ଉଜଲ୍‌ ରଇଲା ଜେ, ସେ ଉଜଲର୍‌ ବପୁ ସଙ୍ଗ୍‍, ମୁଇ କାଣା ଅଇଜାଇରଇଲି । ସେଟାର୍‌ପାଇ ମର୍‌ ସଙ୍ଗ୍‍, ଜିବା ଲକ୍‌ମନ୍‌, ମର୍‌ ଆତେ ଦାରି, ମକେ ଦାମାସ୍‌କସେ ଡାକିନେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","ଦାମାସ୍‌କାସେ ଅନନିଅ ନାଉଁର୍‌ ଗଟେକ୍‌ ଦରମ୍‌ ଲକ୍‌ ରଇଲା । ସେ ଆମର୍‌ ରିତିନିତି ନାମି କରି ରଇଲା, ତେଇ ରଇବା ଜିଉଦିମନ୍‌ ସବୁ ତାକେ ବେସି ନାମ୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ସେ ମର୍‌ଲଗେ ଆସି ଟିଆଅଇ କଇଲା, “ବାଇ ସାଉଲ୍‌, ତୁଇ ଆଁକି ଆରି ତରେକ୍‌ ଦେକ୍‌ ।” ଟିକ୍‌ ସେ ଦାପ୍‌ରେ, ମୁଇ ଆରି ତରେକ୍‌ ଦେକ୍‌ବା ବପୁ ପାଇଲି । ");
INSERT INTO dso_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ସେ କଇଲା, “ଆମର୍‌ ଆନିଦାଦିର୍‌ ମାପ୍‌ରୁ ସେ ମନ୍‌କର୍‌ବାଟା ଜାନ୍‌ବାକେ, ତାର୍‌ ଦରମର୍‌ ଦାଙ୍ଗ୍‌ଡାକେ ଦେକ୍‌ବାକେ ଆରି ତାର୍‌ କାତା ସୁନ୍‌ବାକେ, ତକେ ବାଚ୍‌ଲା ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ତୁଇ କାଇଟା ଦେକିଆଚୁସ୍‌ ଆରି ସୁନି ଆଚୁସ୍‌, ସେଟା ସବୁ ଲକର୍‌ ଲଗେ ଦେକାଇବାକେ ଆରି ସୁନାଇବାକେ ତାକର୍‌ ସାକି ଅଇସୁ । ");
INSERT INTO dso_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ଆରି କାଇକେ ଅଲ୍‌ସମ୍‌ କଲୁସ୍‌ନି ? ଉଟ୍‌, ଡୁବନ୍‌ ନେ, ଆରି ତାକେ ପାର୍‌ତନା କରି ତର୍‌ ସବୁ ପାପେଅନି ପରିଚଲ୍‌ ଅ ।” ");
INSERT INTO dso_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ମୁଇ ଜିରୁସାଲମେ ବାଉଡି ଜାଇ, ତେଇର୍‌ ମନ୍ଦିରେ ପାର୍‌ତନା କର୍‌ବାବେଲେ, ମକେ ମାପ୍‌ରୁର୍‌ ଦର୍‌ସନ୍‌ ମିଲ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ମାପ୍‌ରୁ ମକେ ନିଜେ ଦେକାଇଅଇ କଇଲା, ଦାପ୍‌ରେ ଜିରୁସାଲମ୍‌ ଚାଡି ଉଟି ଜା, କାଇକେ ବଇଲେ ଇତିର୍‌ ଲକ୍‌ମନ୍‌ ମର୍‌ ବିସଇ, ତୁଇ ସାକିଦେବାଟା ନ ନାମତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ମୁଇ କଇଲି “ମାପ୍‌ରୁ, ମୁଇ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ଜାଇ, ତମ୍‌କେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଲକ୍‌ମନ୍‌କେ, କେନ୍ତାରି ବନ୍ଦି କରି ରଇଲି ଆରି ମାଡ୍‌ ମାରି ରଇଲି, ଏଟା ସେମନ୍‌ ନିକ ସଙ୍ଗ୍‍ ଜାନତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ଆରି ଜେଡେବେଲ୍‌ ତମର୍‌ ସାକି ଦେଇ ରଇବା ତିପାନ୍‌କେ ମରାଇଦେଲାଇ, ମୁଇ ନିଜେ ତେଇ ରଇଲି, ତାକେ ମାରି ମରାଇଦେବାକେ ରାଜିଅଇରଇଲି । ମାରୁମନର୍‌ ବେଟ୍‌ଲା ବସ୍‌ତର୍‌ ଜାଗି ରଇଲି ।” ");
INSERT INTO dso_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ମାପ୍‌ରୁ ମକେ କଇଲା, “ଜାଆ ମୁଇ ତକେ ବେସି ଦୁରିକେ ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ ଲଗେ ପାଟାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ପାଉଲ୍‌ ଏ କାତା କଇବାଜାକ ଲକ୍‌ମନ୍‌ ମନ୍‌ଦିଆନ୍‌ ଦେଇ ସୁନ୍‌ତେ ରଇଲାଇ, ମାତର୍‌ ତାର୍‌ ପଚେ ସେମନ୍‌ ଆଉଲିଅଇକରି କଇଲାଇ, “ତାକେ ଜଗତେଅନି ବାର୍‌କରାଇ ଦିଆସ୍‌ ! ମରାଇ ଦିଆସ୍‌, ସେନ୍ତା ଲକ୍‌ ଜିଇବାକେ ଲଡା ନାଇ !” ");
INSERT INTO dso_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ସେମନ୍‌ ଆଉଲି ଅଇକରି ବସ୍‌ତର୍‌ ଉପ୍‌ରେ ଉଡାଇତେରଇଲାଇ ଆରି ଦୁଲି ମିସା ଉପ୍‌ରେ ଉଡାଇତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ରମିୟ ସନିଅମନର୍‌ ମୁକିଆ ପାଉଲ୍‌କେ ଗଡ୍‌ ବିତ୍‌ରେ ଦାରିଜିବାକେ ସନିଅମନ୍‌କେ ତିଆର୍‌ଲା ଆରି ଜିଉଦିମନ୍‌ କାଇକେ ତାର୍‌ ବିରୁଦେ ଆଉଲି ଅଇଲାଇନି, ସେଟା ଜାନ୍‌ବାକେ ପାଉଲ୍‌କେ କର୍‌ଡା ସଙ୍ଗ୍‍ ମାର୍‌ବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ମାତର୍‌ ସେମନ୍‌ ତାକେ କର୍‌ଡା ମାର୍‌ବାକେ ବାନ୍ଦିରଇଲା ବେଲେ, ପାଉଲ୍‌ ତେଇ ରଇବା ଗଟେକ୍‌ ଅଦିକାରିକେ କଇଲା, “କାଇ ଦସ୍‌ ନ ରଇକରି ଏବେ ଜାକ ବିଚାର୍‌ନା ନ ଅଇରଇବା ଗଟେକ୍‌ ରମିଅ ଲକ୍‌କେ କର୍‌ଡା ସଙ୍ଗ୍‍ ମାର୍‌ବାଟା, ଏଟା ତୁଇ ନିୟମ୍‌ ମାନ୍‌ଲୁସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ଏ କାତା ସୁନିକରି ସନିଅ ଗାଲା ଆରି ସନିଅମନର୍‌ ମୁକିଅକେ କଇଲା, “ତୁଇ କାଇଟା କଲୁସ୍‌ନି? ଏ ଗଟେକ୍‌ ରମିଅ ଲକ୍‌ !” ");
INSERT INTO dso_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ସନିଅମନର୍‌ ମୁକିଅ ପାଉଲର୍‌ ଲଗେ ଜାଇ ପାଚାର୍‌ଲା, “ସତଇସେ ତମେ କାଇ, ରମିଅ ଲକ୍‌ କି ?” ପାଉଲ୍‌ ଉତର୍‌ ଦେଲା “ଉଁ ।” ");
INSERT INTO dso_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ସେନାପତି କଇଲା, “ମୁଇ ରମିଅ ସର୍‌କାର୍‌କେ ଡାବୁ ଦେଇକରି ଗଟେକ୍‌ ରମିଅ ଲକ୍‌ ଅଇଲି ଆଚି ।” ପାଉଲ୍‌ କଇଲା “ମାତର୍‌ ମୁଇ ଜନମ୍‌ କଲାବେଲେଅନି ରମିଅ ଲକ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ଏଟା ସୁନିକରି ଜନ୍‌ଲକ୍‌ମନ୍‌ ପାଉଲ୍‌କେ ପାଚାର୍‌ବାର୍‌ ଜାଇରଇଲାଇ, ସେମନ୍‌ ପଚ୍‌କେ ଗୁଚ୍‌ଲାଇ । ପାଉଲ୍‌ ଗଟେକ୍‌ ରମିୟ ଲକ୍‌ ବଲି ଜାନ୍‌ଲାକେ, ସେମନର୍‌ ନେତା ମିସା ଡର୍‌ଲା । କାଇକେବଇଲେ ପାଉଲ୍‌କେ ସିକ୍‌ଲି ସଙ୍ଗ୍‍ ବାନ୍ଦ୍‌ବାକେ ସେ ସେ ତିଆରିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ଜିଉଦିମନ୍‌ ପାଉଲ୍‌କେ କାଇବଲି ନିନ୍ଦା କର୍‌ତେରଇଲାଇ, ସେଟା ଜାନ୍‌ବାକେ ସନିଅମନର୍‌ ମୁକିଅ ମନ୍‌ କର୍‌ତେରଇଲା । ତେବର୍‌ପାଇ ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ସବୁ ପୁଜାରିମନ୍‌କେ ଆରି ବଡ୍‌ ସବାର୍‌ ମେମର୍‌ମନ୍‌କେ ରୁଣ୍ଡାଇବାକେ ତିଆର୍‌ଲା । ତାର୍‌ ପଚେ ସେ ପାଉଲ୍‌କେ ବାନ୍ଦ୍‌ଲା ସିକ୍‌ଲି କୁସ୍‌ଲାଇ, ଦାରିକରି ଆନ୍‌ଲା ଆରି ବଡ୍‌ ସବାଇ ତାକର୍‌ ମୁଆଟେ ଟିଆ କରାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ପାଉଲ୍‌ ବଡ୍‌ସବାର୍‌ ଲକ୍‌ମନ୍‌କେ ସିଦା ଦେକି କଇଲା, “ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌ ! ଆଜିକେ ଜାକ ମୁଇ ପରମେସରର୍‌ ମୁଆଟେ କେନ୍ତାର୍‌ ଜିବନ୍‌ ବିତାଇ ଆଚି, ସେ ବିସଇଟାନେ ମନ୍‌ ପୁରାପୁରୁନ୍‌ ନିର୍‌ମଲ୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ଏ କାତା ସୁନିକରି ଅନନିଅ ନାଉଁର୍‌ ବଡ୍‌ ପୁଜାରି ପାଉଲର୍‌ ଲଗେ ଟିଆଅଇରଇବା ଲକ୍‌ମନ୍‌କେ, ତାର୍‌ ଗାଲେ ଚାପଡ୍‌ ମାରା ବଲି ତିଆର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ପାଉଲ୍‌ ତାକେ କଇଲା, “ଏ ଚୁନ୍‌ ମାରିଅଇଲା ଦବ୍‌ଲା ଉଆଁରି କତି, ପର୍‌ମେସର୍‌ ତକେ ଡଣ୍ଡ୍ ଦେଇସି ଆକା । ନିୟମ୍‌ ଇସାବେ ମର୍‌ ବିଚାର୍‌ କର୍‌ବାକେ, ତୁଇ ତେଇ ବସିଆଚୁସ୍‌ । ଏଲେ ମିସା, ନିୟମ୍‌ ବାଙ୍ଗିକରି ମକେ ମାର୍‌ବାକେ ତିଆର୍‌ଲୁସ୍‌ନି !” ");
INSERT INTO dso_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ଲଗେ ରଇବା ଲକ୍‌ମନ୍‌ ପାଉଲ୍‌କେ କଇଲାଇ, “ପର୍‌ମେସର୍‌ ବାଚିରଇବା ବଡ୍‌ ପୁଜାରିକେ ତୁଇ ନିନ୍ଦା କଲୁସ୍‌ନି !” ");
INSERT INTO dso_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ପାଉଲ୍‌ କଇଲା, “ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌, ସେ ବଡ୍‌ ପୁଜାରି ବଲି ମୁଇ ନାଜାନିରଇଲି । ସାସ୍‌ତରେ ଲେକାଆଚେ, ତମେ ନିଜର୍‌ ଜାତିର୍‌ ସାସନ୍‌କାରିଆକେ କରାପ୍‌ କାତା କଇବାର୍‌ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ବଡ୍‌ ସବାର୍‌ ମେମର୍‌ମନର୍‌ ବିତ୍‌ରେ କେତେଟା ପାରୁସି ଆରି କେତେଟା ସାଦୁକିମନ୍‌ ରଇଲାଟା ଦେକି ପାଉଲ୍‌ ବଡ୍‌ ସବାର୍‌ ଲକ୍‌ମନ୍‌କେ ଦେକାଇ ଆଉଲି ଅଇକରି କଇଲା, “ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌, ମୁଇ ଗଟେକ୍‌ ପାରୁସି ଲକ୍‌, ମର୍‌ ଆୟା ବାବା ମିସା ପାରୁସି । ମଲା ଲକ୍‌ମନ୍‌ ଆରିତରେକ୍‌ ଉଟ୍‌ବାଟା ମର୍‌ ଆସା ଆଚେ ବଲି, ଇତି ମର୍‌ ବିଚାର୍‌ନା ଅଇଲାନି ।” ");
INSERT INTO dso_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ପାଉଲ୍‌ ଏ କାତା କଇଲା ଦାପ୍‌ରେ, ପାରୁସି ଆରି ସାଦୁକିମନର୍‌ ବିତ୍‌ରେ ଲାଗାଜଡା ଅଇଗାଲାଇ ଆରି ସେମନ୍‌ ବେଗ୍‌ଲି ଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","କାଇକେବଇଲେ ସାଦୁକିମନର୍‌ ବିସ୍‌ବାସ୍‌ ଇସାବେ ମଲା ଲକ୍‌ମନ୍‌ ନ ଉଟତ୍‌ । ସରଗର୍‌ ଦୁତ୍‌ କି ଆତ୍‌ମା ମିସା ନାଇ ବଲି, ବିସ୍‌ବାସ୍‌ କର୍‌ବାଇ, ମାତର୍‌ ପାରୁସିମନ୍‌ ଏ ତିନ୍‌ଟା ଜାକ ବିସ୍‌ବାସ୍‌ କର୍‌ତେରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ସେମନର୍‌ କିରଜାଟି ଅଇବାଟା ଅଦିକ୍‌ ଅଦିକ୍‌ ଅଇଆଇଲା । ପାରୁସି ଦଲର୍‌ କେତେଟା ଦରମ୍‌ ଗୁରୁ ଉଟିକରି ଡାଟ୍‌ ସଙ୍ଗ୍‍ କଇଲାଇ, “ଆମେ ଏ ଲକର୍‌ ଟାନେଅନି କାଇ ଦସ୍‌ ମିସା ମିଲାଉ ନାଇ । କେଜାନେ ଆକେ ଗଟେକ୍‌ ସରଗର୍‌ ଦୁତ୍‌ କି ଆତ୍‌ମା କାତା କଇରଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ତାକର୍‌ ଦଦାପେଲା ଅଦିକ୍‌ ଅଦିକ୍‌ ଅଇଗାଲାକେ ଲକ୍‌ମନ୍‌ ପାଉଲ୍‌କେ ଗନ୍ଦାଗନ୍ଦା କରି ଚିରି ପାକାଇବାଇ ବଲି ସନିଅମନର୍‌ ମୁକିଅ ଡର୍‌ଲା । ତେବେ ସେ ଗଣ୍ଡ୍‍ଗଲ୍‌ ଅଇବା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ପାଉଲ୍‌କେ ରକିଆ କରି ଗଡ୍‌ ବିତ୍‌ରେ ଦାରି ଜିବାକେ ସନିଅମନ୍‌କେ ତିଆର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ସେ ରାତି ମାପ୍‌ରୁ ପାଉଲର୍‌ ଲଗେ ଟିଆଅଇ କଇଲା, “ଡର୍‌ ନାଇ ! ମର୍‌ ପାଇ ଇତି ଜିରୁସାଲାମେ ତୁଇ ସାକି ଦେଇ ଆଚୁସ୍‌ । ରମ୍‌ ଦେସେ ମିସା ତୁଇ ସେନ୍‌ତାରି କର୍‌ବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ଆରକର୍‌ ଦିନର୍‌ ସାକାଲେ କେତେଟା ଜିଉଦିମନ୍‌ ଗଟେକ୍‌ଟାନେ ରୁଣ୍ଡି ଜଜ୍‌ନା କଲାଇ । ପାଉଲ୍‌କେ ନ ମରାଇବା ଜାକ ସେମନ୍‌ ଅରନ୍‌ପାନି ନ ଚିଉ ବଲି ସପତ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ଚାଲିସ୍‌ତେଇଅନି ଅଦିକ୍‌ ଲକ୍‌ ଏ ଜଜ୍‌ନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ସେମନ୍‌ ଜାଇକରି ମୁକିଅ ପୁଜାରିମନ୍‌କେ ଆରି ପାର୍‌ଚିନ୍‌ମନ୍‌ କେ କଇଲାଇ, “ପାଉଲ୍‌କେ ନ ମରାଇବା ଜାକ ଅରନ୍‌ପାନି ନ ଚିଉ ବଲି ଆମେ ସପତ୍‌ କରିଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ତମେ ଆରି ବଡ୍‌ସବାର୍‌ ଲକ୍‌ମନ୍‌ ରମିୟ ନେତା ପାଉଲ୍‌କେ ଇତି ଆରିତରେକ୍‌ ଆନା ବଲି କବର୍‌ ପାଟାଆ । ତାର୍‌ ବିସଇର୍‌ ଟିକିନିକି ଜାନ୍‌ବାର୍‌ ଆଚେ ବଲି ମିଚ୍‌ କଇକରି ଆନାଆ । ସେ ବଡ୍‌ ସବାଇ ଆଇବା ବେଲେ ତାକେ ବାଟେ ଜାଗି ମାରି ମରାଇଦେବୁ ।” ");
INSERT INTO dso_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ପାଉଲର୍‌ ବାନ୍‌ଜା ଏମନର୍‌ କୁଟ୍‌ କାତା ସୁନିକରି ଗଡ୍‌ ବିତ୍‌ରେ ଗାଲା ଆରି ସବୁ କାତା ପାଉଲ୍‌କେ କଇଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ପାଉଲ୍‌ ଗଟେକ୍‌ ରମିୟ ଅଦିକାରିକେ ଡାକାଇ କରି କଇଲା, “ଏ ଦାଙ୍ଗ୍‌ଡାକେ ସନିଅମନର୍‌ ମୁକିଅ ଲଗେ ଦାରି ଜାଅତ୍‌ । ସେ ତାକେ କାଇଟାକି କଇବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ସନିଅ ତାକେ ମୁକିଆର୍‌ ଲଗେ ନେଇ କଇଲା, “ବନ୍ଦି ରଇବା ପାଉଲ୍‌ ମକେ ଡାକି ଏ ଦାଙ୍ଗ୍‌ଡାକେ ତମର୍‌ ଲଗେ ଆନ୍‌ବାକେ କଇଲା । ତମ୍‌କେ ପନି ସେ କାଇଟା କଇବାର୍‌ ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ସନିଅମନର୍‌ ମୁକିଅ ତାର୍‌ ଆତ୍‌ ଦାରିକରି ଗଟେକ୍‌ ପାଲିକେ ଡାକିନେଲା ଆରି ପାଚାର୍‌ଲା, “କାଇଟା କଇବାର୍‌ ଆଚେ କଅ !” ");
INSERT INTO dso_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ଦାଙ୍ଗ୍‌ଡା କଇଲା, “ପାଉଲର୍‌ ଟିକିନିକି ବିସଇ ଜାନ୍‌ବାର୍‌ ଆଚେ ବଲି ନାଡାଇକରି ତାକେ ଜିଉଦିମନ୍‌ ବଡ୍‌ ସବାଇ ନେବାକେ, ତମ୍‌କେ ଗୁଆରି କର୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ମାତର୍‌ ତମେ ତାକର୍‌ କାତା ସୁନା ନାଇ । କାଇକେ ବଇଲେ ଚାଲିସ୍‌ତେଇଅନି ଅଦିକ୍‌ ଲକ୍‌ ଲୁଚିକରି ପାଉଲ୍‌କେ ମରାଇବାକେ ଜାଗିଆଚତ୍‌ । ‘ତାକେ ନ ମରାଇବା ଜାକ ଅରନ୍‌ପାନି ନ କାଉଁ’ ବଲି ସପତ୍‌ କଲାଇ ଆଚତ୍‌ । ଏବେ ସେମନ୍‌ ତମର୍‌ ଆଦେସ୍‌ ଦେବାଟାକେ ଜାଗିକରି ଆଚତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ସନିଅମନର୍‌ ମୁକିଅ କଇଲା, “ତୁଇ ମକେ ଏ କାତା ଜାନାଇ ଆଚି ବଲି କାକେ କଅ ନାଇ ।” ଏନ୍‌ତାରି କଇକରି ଦାଙ୍ଗ୍‌ଡାକେ ପାଟାଇ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ସନିଅମନର୍‌ ମୁକିଅ ତାର୍‌ ତଲେ ରଇଲା ଦୁଇଟା ସନିଅକେ ଡାକାଇ କଇଲା, “ଆଜି ରାତି ନଅଟା ବିତ୍‌ରେ ସିସେରିଆ ଜିବାକେ ଦୁଇସ ସନିଅକେ ତିଆର୍‌, ଆରି ସତୁରିଟା ଗଡାଇ ଚଗୁମନ୍‌ ଆରି ଦୁଇ ସଅ ବର୍‌ଚି ଦାରୁମନ୍‌କେ ଟିକ୍‌ କର୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ପାଉଲ୍‌ ଜିବା ପାଇ କେତେଟା ଗଡା ଦିଆସ୍‌ ଆରି ନିକ ସଙ୍ଗେ ତାକେ ସାସନ୍‌କାରିଆ ପେଲିକ୍‍ସ୍ ଲଗେ ଦାରି ଜାଆ ।” ");
INSERT INTO dso_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ସନିଅମନର୍‌ ମୁକିଅ ପେଲିକ୍‍ସ୍‍କେ ଏନ୍‌ତି ଗଟେକ୍‌ ଚିଟି ଲେକ୍‌ଲା, ");
INSERT INTO dso_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ଏ ଚିଟି ମୁଇ କାଲାଡିଆକେ ଲିସିଆର୍‌ ସବୁର୍‌ଟାନେଅନି ଡାକ୍‌ପୁଟା ରଇବା ସନ୍‌ମାନର୍‌ ସାସନ୍‌କାରିଆ ପେଲିକ୍‍ସ୍‍କେ ଲେକ୍‌ଲିନି, ଜୁଆର୍‌ ! ");
INSERT INTO dso_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ଆଗିଆ, ଜିଉଦିମନ୍‌ ଏ ଲକ୍‌କେ ଦାରି ତାକେ ମର୍‌ତେ ମାରିଦେବାକେ ଚେସ୍‌ଟା କର୍‌ତେ ରଇଲାଇ । ସେ ଗଟେକ୍‌ ରମିୟ ଲକ୍‌ ବଲି ଜାନ୍‌ଲା ପଚେ, ମୁଇ ତାକେ ମର୍‌ ସନିଅମନ୍‌ ସଙ୍ଗେ ତାକେ ରକିଆ କଲି । ");
INSERT INTO dso_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ସେମନର୍‌ ବିରଦେ ସେ କାଇ ଦସ୍‌ କଲା ଆଚେ, ସେଟା ଜାନ୍‌ବାକେ ତାକେ ମୁଇ ସେମନର୍‌ ବଡ୍‌ସବାଇ ଦାରିଗାଲି । ");
INSERT INTO dso_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ମାତର୍‌ ସେ ମରନର୍‌ କି ବନ୍ଦି ଡଣ୍ଡ୍ ପାଇବା ପାରା କାଇମିସା ବୁଲ୍‌ କାମ୍‌ କରେ ନାଇ ବଲି ମୁଇ ଜାନିପାର୍‌ଲି । ତାର୍‌ ବିରଦେ ଅଇଲା ଦାବା ସବୁ, ତାକର୍‌ ନିଜର୍‌ ଦରମ୍‌ ବିସଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ଆରି ତାର୍‌ ବିରଦେ ଗଟେକ୍‌ କୁଟ୍‌ ଜଜ୍‌ନା ଅଇଲାନି ବଲି କବର୍‌ ସୁନି, ବେଗି ବେଗି ତମର୍‌ ଲଗେ ପାଟାଇ ଦେବାକେ ଟିକ୍‌ କଲି, ତାର୍‌ ବିରଦେ ରଇଲା ଦାବା, ତର୍‌ ମୁଆଟେ ଜାନାଇବାକେ ତାର୍‌ ଦାବାଦାରିମନ୍‌କେ ମୁଇ କଇଲିଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ସନିଅମନ୍‌ ସେ ଆଦେସ୍‌ ଇସାବେ ପାଉଲ୍‌କେ ସେ ରାତି ଆନ୍‌ତିପଟ୍‌ରିସେ କେଟାଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଇଣ୍ଡିଜିବା ସନିଅମନ୍‌ ଗଡେ ବାଉଡିଗାଲାଇ ଆରି ଗଡାଇ ଜାଉ ସନିଅମନ୍‌କେ ଜିବାକେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ସନିଅମନ୍‌ ପାଉଲ୍‌କେ ଦାରି ସିସେରିଆଇ କେଟ୍‌ଲାଇ । ତେଇ ସନିଅମନର୍‌ ମୁକିଅର୍‌ ଚିଟି ସଙ୍ଗେ ପାଉଲ୍‌କେ ସାସନ୍‌କାରିଆର୍‌ ଆତେ ଜିମାଦେଇଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ସାସନ୍‌କାରିଆ ଚିଟି ପଡି ପାଉଲ୍‌କେ କନ୍‌ ରାଇଜେଅନି ଆସିଆଚୁସ୍‌ ? ବଲି ପାଚାର୍‌ଲା । ପାଉଲ୍‌ ସିଲିସିଆଇଅନି, ବଲି ଜାନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ସେ କଇଲା, “ତମର୍‌ ଦାବାଦାରିମନ୍‌ ଆସି କେଟ୍‌ଲା ପଚେ, ମୁଇ ତର୍‌ କାତା ସୁନ୍‌ବି ।” ତାର୍‌ ପଚେ ପାଉଲ୍‌କେ ଏରଦ୍‌ ରାଜାର୍‌ ନଅରେ ବନ୍ଦି କରି ସଙ୍ଗଇବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ପାଁଚ୍‍ଦିନ୍‌ ପଚେ ବଡ୍‌ ପୁଜାରି ଅନନିୟ କେତେଟା ପାର୍‌ଚିନ୍‌ ଆରି ତର୍‌ତୁଲସ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଅକିଲ୍‌ ସଙ୍ଗ୍‍ ସିସେରିଆଇ ଗାଲାଇ । ସେମନ୍‌ ପେଲିକ୍‌ସର୍‌ ମୁଆଟେ ଟିଆଅଇ ପାଉଲର୍‌ ବିରଦେ ସେମନର୍‌ ଦାବା ଜାନାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ତାର୍‌ପଚେ ପାଉଲ୍‌କେ ତେଇଆନି ଟିଆ କରାଇଲାଇ ଆରି ତର୍‌ତୁଲସ୍‌ ଏନ୍ତି ତାକର୍‌ ଦାବାମନ୍‌ ସବୁ ଜାନାଇଲା । “ ଆଗିଆଁ, ତମେ ଗଟେକ୍‌ ଡାକ୍‌ପୁଟା ଲକ୍‌, ତମର୍‌ ନିମାନ୍‌ ସାସନ୍‌ଅନି ଆମେ ବେସି ଦିନ୍‌ ଦାରି ସାର୍‌ଦା ଅଇ ସାନ୍ତି ସଙ୍ଗ୍‍ ଜିଇଲୁନି, ଆମର୍‌ ଦେସର ମଙ୍ଗଲ୍‌ ପାଇ ବେସି ଦର୍‌କାର୍‌ ରଇଲା କାମ୍‌ମନ୍‌ କରାଇଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ସବୁଜାଗାଇ ଆରି ସବୁ ବେଲାଇ ଆମେ ଏଟାକେ ନାମ୍‍ଲୁନି, ଏଟାର୍‌ପାଇ ଆମେ ତମ୍‌କେ ମାନି ଆଇଲୁନି । ");
INSERT INTO dso_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ସେଟା ଜାଇଟା ଅ, ମୁଇ ତମର୍‌ ଅଦିକ୍‌ ବେଲା ନେବାକେ ମନ୍‍ କରିନାଇ । ସେଟାର୍‌ ପାଇ ଆମର୍‌ ଗଟେକ୍‌ ଚଟ୍‌ ଅର୍‌ସାସଙ୍ଗର୍‌ କାତା ସୁନ୍‌ବାକେ ବାବୁଜିଆ କଲିନି । ");
INSERT INTO dso_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ଏ ଲକ୍‌ ଗଟେକ୍‌ ବେସି ବଡ୍‌ ଗଣ୍ଡ୍‍ଗଲ୍‌ କରାଉ ବଲି ଆମେ ଜାନୁ, ସେ ଦେସ୍‌ବିଦେସେ ସବୁ ବାଟେ ବୁଲିବୁଲି ଜିଉଦିମନ୍‌କେ କିରମାର କରାଇବାକେ ଉସ୍‌କାଇଲାନି, ସେ ନାଜରିତ୍‌ ଦଲର୍‌ ଗଟେକ୍‌ ନେତା । ");
INSERT INTO dso_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ସେ ଆମର୍‌ ମନ୍ଦିର୍‌ ଅସୁକଲ୍‌ କର୍‌ବାକେ ଚେସ୍‌ଟା କଲାବେଲେ ଆମେ ତାକେ ବନ୍ଦି କଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ଆମର୍‌ ନିୟମ୍‌ ଇସାବେ ଏ ଲକ୍‌କେ ବିଚାର୍‌ କର୍‌ବାକେ ଆମେ ମନ୍‌ କର୍‌ତେରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ଆର୍‌ ବିରଦେ ଜନ୍‌ ସବୁ ଦାବା କଲୁଆଚୁ, ସେଟା ତମେ ଏ ଲକ୍‌କେ ପାଚାରିକରି ଜାନିପାରାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ତେଇରଇଲା ଜିଉଦିମନ୍‌ ଏଟା ସତ୍‌ବଲି ଡାଟ୍‌ ସଙ୍ଗ୍‍ ସେ କାତାଇ ରାଜି ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ତାର୍‌ପଚେ ସାସନ୍‌କାରିଆ ପାଉଲ୍‌କେ କାତା ଅଇବାକେ ସାଗିଆ କଲାକେ ପାଉଲ୍‌ କଇଲା । “ମୁଇ ଜାନି ଜେ ବେସି ବରସ୍‌ ଦାରି ତମେ ଏ ଜାତିର୍‌ ବିଚାର୍‌କରୁ ଅଇ ଆଚୁସ୍‌, ସେଟାର୍‌ ପାଇ ତମର୍‌ ମୁଆଟେ କଇବାଟା କେଡେ କରମର୍‌ କାତା । ");
INSERT INTO dso_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ଆଗିଆ, ତମେ ନିଜେ କଜିକରି ଜାନିପାର୍‌ସା ଜେ, ପାକାପାକି ବାରଦିନ୍‌ ତଲେ, ମୁଇ ଜିରୁସାଲାମେ ପାର୍‌ତନା କର୍‌ବାକେ ଜାଇରଇଲି । ");
INSERT INTO dso_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ମନ୍ଦିରେ କାର୍‌ ସଙ୍ଗ୍‍, ମୁଇ ଦଦାପେଲା କର୍‌ବାଟା ଜିଉଦିମନ୍‌ ଦେକି ନ ରଇଲାଇ କି ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ କି ଗଡର୍‌ କନ୍‌ ବିନ୍‌ ଜାଗାଇ ଲକ୍‌ମନ୍‌କେ ଉସ୍‌କାଇବାଟା ଦେକି ନ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ସେଟାର୍‌ ପାଇ ମର୍‌ ବିରଦେ ଏବେ ଆନିରଇବା ଦାବାର୍‌ ପାଇ, ସେମନ୍‌ କାଇମିସା ସାକି ଦେଇ ନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ଏଲେ ମିସା ମୁଇ ତମର୍‌ ଲଗେ ରାଜି ଅଇଲିନି ଜେ, ଜନ୍‌ ବାଟ୍‌ ସେମନ୍‌ ମିଚ୍‌ ବଲି କଇଲାଇନି, ସେ ବାଟେ ଜାଇ, ଆମର୍‌ ଆନିଦାଦିମନର୍‌ ପରମେସର୍‌କେ ପାର୍‌ତନା କଲିନି । ମାତର୍‌ ମୁଇ ମିସା ମସାର୍‌ ରିତିନିତି ଆରି ବବିସତ୍‌ବକ୍‌ତାମନର୍‌ ସାସ୍‌ତରେ ଲେକାଅଇଲା ସବୁ ବିସଇ ବିସ୍‌ବାସ୍‌ କଲିନି । ");
INSERT INTO dso_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ଏମନର୍‌ ପାରା, ମାପ୍‌ରୁର୍‌ ଲଗେ ମର୍‌ ଗଟେକ୍‌ ଆସା ଆଚେ ଜେ, ନିକ ଲକ୍‌ ଅଅତ୍‌ କି କାରାପ ଲକ୍‌ ଅଅତ୍‌, ସବୁ ମଲାଟାନେଅନି ଉଟ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ସେଟାର୍‌ ପାଇ ପରମେସରର୍‌ ଆରି ମୁନୁସର୍‌ ମୁଆଟେ ନିର୍‌ମଲ୍‌ ବିବେକ୍‌ ଇସାବେ ଚଲାଚଲ୍‌ତି କର୍‌ବାକେ ସବୁବେଲେ ଚେସ୍‌ଟା କଲିନି । ");
INSERT INTO dso_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ବେସି ବରସ୍‌ ଦାରି ଦୁରିକେ ରଇଲା ପଚେ, ଜିରୁସାଲେମର୍‌ ଲକ୍‌ମନର୍‌ ପାଇ କିଚି ଡାବୁ ନେବାକେ ଆରି ବଲିଦେବାକେ ମୁଇ ତେଇ ଜାଇରଇଲି । ");
INSERT INTO dso_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ମୁଇ ନିର୍‌ମଲ୍‌ ଅଇବା ବିଦି ସାରାଇଲା ବେଲେ, ସେମନ୍‌ ମକେ ମନ୍ଦିରେ ଦେକ୍‌ଲାଇ । ସେଡ୍‌କିବେଲେ ମର୍‌ ଲଗେ ବେସି ଲକ୍‌ ନ ରଇଲାଇ କି କାଇମିସା ଗଣ୍ଡ୍‍ଗଲ୍‌ ଅଇ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ମାତର୍‌ ତେଇ ଆସିଆ ଦେସର୍‌ କେତେଟା ଜିଉଦି ରଇଲାଇ, ଜଦି ସେମନ୍‌କେ ମର୍‌ ବିରଦେ କାଇଟା କଇବାର୍‌ ରଇଲା, ଆଗ୍‌ତୁ ସେମନ୍‌ ନିଜେ ତମର୍‌ ମୁଆଟେ ଆସି ଦାବା କର୍‌ବାର୍‌ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ଆରି ତରେକ୍‌ ମୁଇ ଜେଡେବେଲା ବଡ୍‌ ସବାର୍‌ ମୁଆଟେ ଟିଆଅଇରଇଲି, କନ୍‌ ଅପ୍‌ରାଦେ ଦସି ଅଇଲି, ସେଟା ଇତି ରଇଲା ଲକ୍‌ମନ୍‌ କଅତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ଏଲେମିସା ମୁଇ ଗଟେକ୍‌ କାତା କଇରଇଲି । ସେମନର୍‌ ମୁଆଟେ ଟିଆ ଅଇରଇଲା ବେଲେ ମଲାଲକ୍‌ମନ୍‌ ଆରିତରେକ୍‌ ଉଟ୍‌ବାଇ ବଲି ଡାଟ୍‌ ସଙ୍ଗ୍‍ ବିସ୍‌ବାସ୍‌ କର୍‌ତେ ରଇଲାର୍‌ ପାଇ ଆଜି ତମର୍‌ଟାନେ ବିଚାର୍‌ନା ପାଇଲିନି । ଏଟାକେ ଚାଡି ଆରି ସେମନର୍‌ ମୁଆଟେ କିଚି କଇନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ପେଲିକ୍‍ସ୍ ସେ ବାଟ୍‌ ବିସଇର୍‌ ଟିକିନିକି ଜାନି ରଇଲାର୍‌ ପାଇ ସୁନାଇବାଟା ବନ୍ଦ୍‌ କରି କଇଲା, “ ସନିଅମନର୍‌ ମୁକିଅ ଲିସିଅସ୍‌ କେଟ୍‌ଲା ପଚେ, ମୁଇ ତମର୍‌ ବିଚାର୍‌ନା ସୁନାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ତାର୍‌ପଚେ ସେ ଅଦିକାରେ ରଇବା ମୁକିଆକେ କଇଲା, “ପାଉଲ୍‌କେ ବନ୍ଦି ଇସାବେ ଜାଗିରଇବାର୍‌ ଆଚେ, ମାତର୍‌ ତାକେ ଦର୍‌କାର୍‌ ଅଇବା ଜିନିସ୍‌ ତାର୍‌ ଲକ୍‌ମନ୍‌ ଆନିଦେଲେ, ସେଟା ତେବାଇବାର୍‌ ନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","କେତେଦିନ୍‌ ପଚେ ପେଲିକ୍‍ସ୍ ତାର୍‌ ଜିଉଦି ମାଇଜି ଦୁର୍‌ସିଲା ସଙ୍ଗ୍‍ ତେଇ ଆଇଲା । ସେ ପାଉଲ୍‌କେ ଡାକାଇ ଜିସୁକିରିସ୍‌ଟକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ବିସଇ, ତାର୍‌ କାତା ନିକକରି ସୁନ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ମାତର୍‌ ଜେଡେବେଲେ ପାଉଲ୍‌ ଦରମ୍‌ ଚଲାଚଲ୍‌ତି ଆରି ଲକ୍‌ମନ୍‌ ନିଜର୍‌ ପାପର୍‌ ଗୁନ୍‌ଚଲନ୍‌ ଇସାବେ ନ ଜାଇକରି ନିଜେ ଦାରିଅଇରଇବା ବିସଇ, ଆରି ଆଇବା ଦିନର୍‌ ବିଚାର୍‌ନା ବିସଇ କଇବାକେ ଦାର୍‍ଲା, ପେଲିକସ୍‌ ଡରିଜାଇକରି “ତମେ ଏବେ ଜାଇପାରାସ୍‌ ।” ବଲି କଇଲା, “ବେଲା ପାଇଲେ ଆରି ତରେକ୍‌ ମୁଇ ତମ୍‌କେ ଡାକାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ସେ ବେଲା ପାଉଲ୍‌ ତାକେ କେତେକ୍‌ ଡାବୁ ଲାଚ୍‌ଁ ଦେଇସି ବଲି ସେ ଆସା କରି ରଇଲା, ସେଟାର୍‌ ପାଇ ସେ ତର୍‌କେ ତର୍‌ ତାକେ ଡାକାଇ ତାର୍‌ ସଙ୍ଗ୍‍ କାତାବାର୍‌ତା ଅଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ଏନ୍ତି ଦୁଇ ବରସ୍‌ ଗାଲାପଚେ ପର୍‌କିୟସ୍‌ ପେସ୍‌ଟସ୍‌ ପେଲିକର୍‌ ଜାଗାଇ ସାସନ୍‌କାରିଆ ଅଇ ଆଇଲା । ପେଲିକ୍‍ସ୍ ଜିଉଦିମନ୍‌କେ ବଲ୍‌ବଲାଇ ଅଇବାକେ ମନ୍‍ କରି ପାଉଲ୍‌କେ ନ ମୁକ୍‌ଲାଇ ବନ୍ଦି ଗରେ ଚାଡି ଉଟିଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ପେସ୍‌ଟସ୍‌ ସାସନ୍‌କାରିଆ ଅଇକରି ଆଇଲା ଜାଗାଇ, ତିନ୍‌ ଦିନ୍‌ ପଚେ, ସେ ସିସିରିଆ ଅନି ଜିରୁସାଲମେ ଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ସେ ଜିରୁସାଲମେ ରଇଲାବେଲେ, ତେଇ ମୁକିଅ ପୁଜାରି ଆରି ଜିଉଦିନେତାମନ୍‌ ଆରି ତରେକ୍‌ ପାଉଲର୍‌ ବିରଦେ ରଇବା ଦାବି ନେଇ, ସେମନର୍‌ ଲଗେ ଗାଲାଇ । ସେମନ୍‌ ପେସ୍‌ତେସ୍‌କେ ବାବୁଜିଆ କଲାଇ, ");
INSERT INTO dso_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ଜେନ୍ତିକି ପାଉଲ୍‌କେ ଜିରୁସାଲାମେ ଆନ୍‌ବାକେ ଗୁଆରି କଲାଇ । କାଇକେବଇଲେ ବାଟେ ଜାଗିରଇ ସେମନ୍‌ ପାଉଲ୍‌କେ ମାରିମରାଇବାକେ ଜଜ୍‌ନା ତିଆର୍‌ କରିରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ପେସ୍‌ଟସ୍‌ କଇଲା, “ପାଉଲ୍‌କେ ଗଟେକ୍‌ ବନ୍ଦି ଇସାବେ ସିସେରିଆଇ ରକାଅଇଲା ଆଚେ ଆରି ବେଗି ମୁଇ ତେଇ ବାଉଡି ଜିବି । ");
INSERT INTO dso_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ଜଦି ସେ କାଇ ଦସ୍‌ କଲା ଆଚେ, ତେବେ ତମର୍‌ ନେତାମନ୍‌ ମର୍‌ ସଙ୍ଗ୍‍ ସିସେରିଆଇ ଆସତ୍‌ ଆରି ତାର୍‌ ବିରଦେ ସେମନର୍‌ ଦାବା ଜାନାଅତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ପେସ୍‌ଟସ୍‌ ସେମନର୍‌ ସଙ୍ଗ୍‍ ଆଟ୍‌ ଦସ୍‌ ଦିନ୍‍ ଜିରୁସାଲମେ ରଇକରି ସିସେରିଆଇ ବାଅଡ୍‌ଲା । ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ବିଚାର୍‌ କର୍‌ବା ଗରେ ବସି ପାଉଲ୍‌କେ ଆନ୍‌ବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ପାଉଲ୍‌ ଆଇଲା ଦାପ୍‌ରେ ଜିରୁସାଲମେଅନି ଆସିରଇବା ଜିଉଦିମନ୍‌ ତାକର୍‌ ଚାରିବେଟ୍‌ତି ବେଡି ଟିଆ ଅଇଲାଇ ଆରି ତାର୍‌ ବିରଦେ କେତେକ୍‌ କେତେକ୍‌ ବଡ୍‌ ବଡ୍‌ ଦାବା କଲାଇ, ମାତର୍‌ ସେମନ୍‌ ଏ ସବୁ ସତ୍‌ ବଲି ଦେକାଇ ନାପାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ମାତର୍‌ ପାଉଲ୍‌ ନିଜେ ନିଜର୍‌ ବାଟେ ଅନି କଇଲା, “ଜିଉଦିମନର୍‌ ରିତିନିତି, ମନ୍ଦିରର୍‌ କି ରମିଅ ସାସନ୍‌କାରିଆ, କାର୍‌ ମିସା ବିରଦେ ମୁଇ ଦସ୍‌ କରିନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ମାତର୍‌ ପେସ୍‌ଟସ୍‌ ଜିଉଦିମନ୍‌କେ ବଲ୍‌ ବଲାଇ ଅଇବାକେ ମନ୍‌ କରି ପାଉଲ୍‌କେ ପାଚାର୍‌ଲା, “ଜିରୁସାଲମେ ଜିବାକେ ଆରି ତେଇ ମର୍‌ ମୁଆଟେ, ଏ ସବୁ ଦାବାର୍‌ ବିଚାର୍‌ କର୍‌ବାକେ ତୁଇ କାଇ ରାଜି ଅଇସୁ କି ?” ");
INSERT INTO dso_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ପାଉଲ୍‌ କଇଲା, “ମୁଇ ବଡ୍‌ ସାସନ୍‌କାରିଆର୍‌ ନିଜର୍‌ ବିଚାର୍‌ନା ଜାଗାଇ ଟିଆ ଅଇଲିଆଚି, ଇତିସେ ମର୍‌ ବିଚାର୍‌ ଅଇବାର୍‌ ଦର୍‌କାର୍‌ । ତମେ ନିକକରି ଜାନାସ୍‌ ଜେ, ମୁଇ ଜିଉଦିମନର୍‌ ବିରଦେ କାଇମିସା ଦସ୍‌ କରିନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ଜଦି ମୁଇ ରିତିନିତି ନ ମାନି ମରନ୍‌ ଡଣ୍ଡ୍ ପାଇବାପାରା କାଇ ଦସ୍‌ କଲିଆଚି ବଇଲେ, ମର୍‌ବାକେ ନ ଡରି । ମାତର୍‌ ସେମନ୍‌ ମର୍‌ ବିରଦେ ଆନିରଇବା ଦାବା ବିତ୍‌ରେ କାଇମିସା ସତ୍‌ ନ ରଏ, ତେବେ କେ ମିସା ମକେ ସେମନ୍‍କେ ସର୍‌ପିଦେଇ ନାପାରତ୍‌ । ବଡ୍‌ ସାସନ୍‌କାରିଆ ଆକା ମକେ ବିଚାର୍‌ନା କର ବଲି ଗୁଆରି କଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ତାର୍‌ପଚେ ପେସ୍‌ଟସ୍‌ ତାର୍‌ ସବାଇ ରଇଲା ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ କାତାବାର୍‌ତା ଅଇ କଇଲା, “ତମେ ବଡ୍‌ ସାସନ୍‌କାରିଆ ବିଚାର୍‌ କର ବଲି ଗୁଆରି କରିଆଚାସ୍‌, ସେଟାର୍‌ ପାଇ ତମ୍‌କେ ବଡ୍‌ ସାସନ୍‌କାରିଆର୍‌ ଲଗେ ପାଟାଇବି ।” ");
INSERT INTO dso_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","କେତେଦିନ୍‌ ପଚେ ରାଜା ଆଗ୍‌ରିପା ଆରି ବର୍‌ନିସ୍‌ ପେସ୍‌ଟସ୍‌କେ ଜୁଆର୍‌ ଜାନାଇବାକେ କାଇସରିଆଇ ମିସ୍‌ବାର୍‌ ଆଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ତେଇ ସେମନ୍‌ କେତେ ଦିନ୍‌ ରଇଲା ପଚେ ପେସ୍‌ଟସ୍‌ ପାଉଲର୍‌ ବିସଇ ରାଜାକେ ଜାନାଇଲା, “ପେଲିକସ୍‌ ବନ୍ଦିକରି ଜାଇରଇବା ଗଟେକ୍‌ ଲକ୍‌ ଇତି ଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ମୁଇ ଜେଡେବେଲା ଜିରୁସାଲାମ୍‌ ଜାଇରଇଲି, ଜିଉଦିମନର୍‍ ମୁକିଅ ପୁଜାରିମନ୍‌ ଆରି ସେ ଦରମର୍‌ ପାର୍‌ଚିନ୍‌ମନ୍‌ ତାର୍‌ ବିରଦେ କେତେଟା ଦାବା କଲାଇ ଆରି ତାକେ ଦସି କର୍‌ବାକେ ମକେ କଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ମାତର୍‌ ମୁଇ ସେମନ୍‌କେ କଇଲି ଜେ, ଗଟେକ୍‌ ଦସିକେ ବିଚାର୍‌ କର୍‌ବା ଗରେ, ତାକେ ଦାବା କରୁମନର୍‌ ମୁଆଟେ ନିଜର୍‌ ବାଟେଅନି କଇବାକେ ବେଲା ଦେବା ଆଗ୍‌ତୁ, ତାକେ ଦସି କର୍‌ବାଟା ଆମର୍‌ ରମିୟମନର୍‌ ନିୟମେ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ସେମନ୍‌ ଇତି ଆଇଲା ପଚେ ମୁଇ ଅଲ୍‌ସମ୍‌ ନ କରି, ତାର୍‌ ପର୍‌ଦିନେ ବିଚାର୍‌ କର୍‌ବା ଗରେ ବସ୍‌ଲି ଆରି ସେ ଲକ୍‌କେ ବିତ୍‌ରେ ଆନ୍‌ବାକେ ଆଦେସ୍‌ ଦେଲି । ");
INSERT INTO dso_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ମର୍‌ ବାବ୍‌ବାଟା ବୁଲ୍‌ ରଇଲା, ସେମନ୍‌ ତାର୍‌ ବିରୁଦେ ଆନିରଇବା ଦାବି, ସେ କରିରଇବା କରାପ୍‌ ବିସଇ ଅଇରଇସି ବଲି ବାବ୍‌ଲି, ମାତର୍‌ ସେନ୍ତାର୍‌ ନ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ସେମନର୍‌ ଦାବି ତାକର୍‌ ନିଜର୍‌ ଦରମ୍‌ ବିସଇ ରଇଲା, ଆରି ଜିସୁ ବଲି ଗଟେକ୍‌ ମରିଜାଇରଇବା ଲକର୍‌ ବିସଇ ରଇଲା । ମାତର୍‌ ସେଲକ୍‌ ବଁଚ୍‌ଲା ଆଚେ ବଲି ପାଉଲ୍‌ କଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ଏ ସବୁ ବିସଇର୍‌ ସତ୍‌ କେନ୍ତି ବାର୍‌କରାଇବି ବଲି ମୁଇମିସା ନାଜାନିରଇଲି, ତେବେ ଏ ସବୁ ବିଚାର୍‌ନା କର୍‌ବାକେ ପାଉଲ୍‌କେ ଜିରୁସାଲମେ ଜାଇସୁ କି ନାଇ ବଲି ପାଚାର୍‌ଲି । ");
INSERT INTO dso_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ମାତର୍‌ ପାଉଲ୍‌, ନିଜେ ରମ୍‌ ରାଇଜର୍‌ କାଇସର୍‌ ରାଜା, ତାର୍‌ ବିଚାର୍‌ କର ବଲି କଇ ସନିଅମନ୍‌ ରକିଆ କରତ୍‌ ବଲି ମନ୍‌ କଲା । ସେଟାର୍‌ପାଇ ବଡ୍‌ ସାସନ୍‌କାରିଆ ଲଗେ ପାଟାଇବା ଜାକ ବନ୍ଦି କରି ରକ୍‌ବାକେ ଆଦେସ୍‌ ଦେଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ଆଗ୍‌ରିପା ପେସ୍‌ଟସ୍‌କେ କଇଲା, “ମୁଇ ନିଜେ ଏ ଲକର୍‌ କାତା ସୁନ୍‌ବାକେ ମନ୍‌ କଲିନି ।” ପେସ୍‌ଟସ୍‌ କଇଲା, “କାଲିକେ ତମେ ତାର୍‌ କାତା ସୁନ୍‌ସା ।” ");
INSERT INTO dso_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଆଗ୍‌ରିପା ଆରି ବର୍‌ନିସ୍‌ ଆସି କେଟ୍‌ଲାଇ । ସେମନ୍‌ ରାଜାମନ୍‌ ପିନ୍ଦ୍‌ଲାପାରାଟା ପିନ୍ଦିର ଇଲା । ସନିଅମନର୍‌ ନେତାମନ୍‌ ଆରି ସେ ଗଡର୍‌ ବଡ୍‌ ବଡ୍‌ ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ବେସି ଡାକ୍‌ପୁଟା ସଙ୍ଗ୍‍ ଆସି, ବିଚାର୍‌ନା ଜାଗାଇ ପୁର୍‌ଲାଇ । ପେସ୍‌ଟସ୍‌ ଆଦେସ୍‌ କଲାକେ, ପାଉଲ୍‌କେ ବିତ୍‌ରେ ଆନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ପେସ୍‌ଟସ୍‌ କଇଲା, “ରାଜା ଆଗ୍‌ରିପା ଆରି ରୁଣ୍ଡି ରଇଲା ସବୁ ଲକ୍‌, ତମେ ଏ ଜନ୍‌ ଲକ୍‌କେ ଦେକ୍‌ଲାସ୍‌ନି, ତାର୍‌ ବିରଦେ ଇତିର୍‌ ଜିଉଦିମନ୍‌ ଆରି ଜିରୁସାଲମର୍‌ ଜିଉଦିମନ୍‌ ମର୍‌ ଲଗେ ଦାବା କଲାଇ ଆଚତ୍‌ । ସେମନ୍‌ ତାକେ ମରାଉଁ ବଲିକରି କଇ ଆଉଲି ଅଇଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ମାତର୍‌ ମୁଇ କଜି ବାର୍‌କରାଇଲି ଜେ, ଏ ଲକ୍‌ ମରନ୍‌ ଡଣ୍ଡ୍ ପାଇବା ଏତ୍‌କି, କାଇ ଦସ୍‌ କରେନାଇ । ସେ ନିଜେ ବଡ୍‌ସାସନ୍‌କାରିଆକେ ଗୁଆରି କଲାର୍‌ ପାଇ, ମୁଇ ତାକେ ତେଇ ପାଟାଇବାକେ ଟିକ୍‌ କଲି ଆଚି । ");
INSERT INTO dso_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ମାତର୍‌ ତାର୍‌ ଦାବି ବିସଇ ଟିକ୍‌ ସଙ୍ଗ୍‍ ବଡ୍‌ସାସନ୍‌କାରିଆକେ ଲେକ୍‌ବାକେ ମର୍‌ ଲଗେ କାଇଟା ନାଇ । ସେଟାର୍‌ପାଇ ମୁଇ ସବୁର୍‌ ମୁଆଟେ ଆରି ଏ ଆଗ୍‌ରିପା ରାଜା, ତମର୍‌ ମୁଆଟେ ଆନ୍‌ଲି ଆଚି, ଜେନ୍ତି କି ତାର୍‌ ବିସଇ ତମେ ନିକ ସଙ୍ଗ୍‍ କଜ୍‌ଲା ପଚେ ବଡ୍‌ସାସନ୍‌କାରିଆକେ ଲେକିପାର୍‌ବି । ");
INSERT INTO dso_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","କାଇକେବଇଲେ ଗଟେକ୍‌ ବନ୍ଦିର୍‌ ବିରଦର୍‌ ଦାବା ନିକସଙ୍ଗ୍‍ ନ ଦେକାଇ, ବଡ୍‌ସାସନ୍‌କାରିଆର୍‌ ଲଗେ ପାଟାଇବାଟା ଟିକ୍‌ ନଏଁ ବଲି ମୁଇ ବାବ୍‌ଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ଆଗ୍‌ରିପା ପାଉଲ୍‌କେ କଇଲା, “ତକେ ତର୍‌ ନିଜର୍‌ ବିସଇ ଜାଇଟା କଇବାର୍‌ ଆଚେ, ସେଟା କଇବାକେ ଅଦିକାର୍‌ ଦିଆଅଇଲା ।” ପାଉଲ୍‌ ଆତ୍‌ ଉଟାଇକରି ନିଜର୍‌ବାଟେଅନି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“ରାଜା ଆଗ୍‌ରିପା ! ଜିଉଦିମନ୍‌ ମକେ ଜନ୍‌ ସବୁ ବିସଇ ନେଇ ଦସି କରିଆଚତ୍‌, ସେଟାର୍‌ ବିରଦେ ତମର୍‌ ମୁଆଟେ, ନିଜର୍‌ ବାଟେଅନି କଇବାକେ ବେଲା ପାଇଲାର୍‌ ପାଇ ମୁଇ କେଡେ କରମର୍‌ ଲକ୍‌ ବଲି ବାବ୍‌ଲିନି ।” ");
INSERT INTO dso_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","କାଇକେବଇଲେ ଜିଉଦିମନର୍‌ ରିତିନିତି ବିସଇ ଆରି ସେମନର୍‌ ଲାଗାଜଡା ବିସଇ ତମେ ନିକସଙ୍ଗ୍‍ ଜାନାସ୍‌ । ମୁଇ ଗୁଆରି କଲିନି, ତମେ ବିଜାର୍‌ ନ ଅଇକରି ମର୍‌ ସବୁକାତା ସୁନା । ");
INSERT INTO dso_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ପିଲାବେଲେଅନି କେନ୍ତି ମୁଇ ଜିଇଲି ଆଚି, ସେଟା ଜିଉଦିମନ୍‌ ଜାନତ୍‌ । ପର୍‌ତୁମ୍‌ ମର୍‌ ନିଜର୍‌ ଦେସେ ଆରି ପଚେ ଜିରୁସାଲମେ ମୁଇ କେନ୍ତି ଜିବନ୍‌ କାଟ୍‌ଲି ଆଚି, ସେଟା ମିସା ସେମନ୍‌ ଜାନତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ଆଗେଅନି ମୁଇ ଜିଉଦି ନିୟମ୍‌ ସବୁ ମାନିକରି ପାରୁସିମନର୍‌ ପାରା ଚଲାଚଲ୍‌ତି କଲିଆଚି, ସେ ବିସଇ ସେମନ୍‌ ସାକି ଦେଇପାରତ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ପର୍‌ମେସର୍‌ ଆମର୍‌ ଆନିଦାଦିମନ୍‌କେ ଜନ୍‌ କାତା ଦେଇ ରଇଲା, ତେଇ ମର୍‌ ଆସା ରଇଲାର୍‌ପାଇ ଆଜି ମୁଇ ଇତି ବିଚାର୍‌ନା କରାଇଅଇବାକେ ଟିଆ ଅଇଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ମାତର୍‌ ଏ ରାଜା, ଏ ଆସା ଆମର୍‌ ବାର୍‌ଟା ଜିଉଦି ଜାତିର୍‌ ଲକ୍‌ ଦିନ୍‌ ରାତି ମାପ୍‌ରୁକେ ପାର୍‌ତନା କରି, ପାଇବାକେ ଆସାକଲାଇନି । ଆରି ଏ ଆସାର୍‌ ଲାଗି ଆମର୍‌ ଜିଉଦିମନ୍‌ ମକେ ଦସି କରିଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ପର୍‌ମେସର୍‌ ମଲା ଲକ୍‌କେ ଉଟାଇସି, ବଲି କାଇକେ ବିସ୍‌ବାସ୍‌ କରିନାପାର୍‌ଲାସ୍‌ନି ? ");
INSERT INTO dso_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ମୁଇ ମିସା ସେମନର୍‌ ପାରା ରଇଲି । ନାଜରିତିୟ ଜିସୁର୍‌ ବାଟେ ଜିବା ସବୁ ଲକ୍‌ମନର୍‌ ବିରୁଦେ ମର୍‌ ଜେତ୍‌କି ବପୁ ସଙ୍ଗ୍‍ ମିସା କାମ୍‌ କର୍‌ବାର୍‌ ଆଚେ ବଲି ଚିନ୍ତା କଲି । ");
INSERT INTO dso_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ମୁଇ ଜିରୁସାଲାମେ ସେନ୍ତି କଲି । ମୁକିଅ ପୁଜାରିମନର୍‌ତେଇଅନି ଅଦିକାର୍‌ ଚିଟି ପାଇ, ପରମେସରର୍‌ ବେସି ଲକ୍‌ମନ୍‌କେ ବାନ୍ଦି କରି, ବନ୍ଦି ଗରେ ପୁରାଇଦେଲି । ଆରି ସେମନ୍‌କେ ମରନର୍‌ ଡଣ୍ଡ୍ ଦେବାକେ ବିଚାର୍‌ନା କଲାବେଲେ, ସେମନର୍‌ ବିରୁଦେ ଟିଆଅଇଲି । ");
INSERT INTO dso_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","କେତେ କେତେ ତର୍‌ ପାର୍‌ତନା ଗର୍‌ମନ୍‌କେ ସେମନ୍‌ ବିସ୍‌ବାସ୍‌ ଚାଡତ୍‌ ବଲି ମାର୍‌ବାକେ ତିଆର୍‌ଲି, ସେମନର୍‌ ଉପ୍‌ରେ ଏତେ ରିସା ଅଇଜାଇରଇଲି ଜେ, ସେମନ୍‌କେ କସ୍‌ଟ ଦେବାକେ ବିଦେସେ, ରଇବା ଗଡ୍‌ମନ୍‌କେ ମିସା ଜାଇରଇଲି ।” ");
INSERT INTO dso_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ଏଟା କର୍‍ବାକେ ମୁଇ ମୁକିଅ ପୁଜାରିମନର୍‌ତେଇଅନି ଅଦିକାର୍‌ ଚିଟି ଆରି ଆଦେସ୍‌ ନେଇ ଦାମାସ୍‌କସେ ଜାଇରଇଲି । ");
INSERT INTO dso_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ଏ ରାଜା ଏଗ୍‌ରିପା, ଅଟାତ୍‌ ଦିନେକ୍‌ ମୁଣ୍ଡ୍‌ବେଲା ଲଗେ, ଜିବାବାଟେ ବେଲ୍‌ ତାରାସେଅନି ଅଦିକ୍‌ ଉଜଲ୍‌ ଦେକ୍‌ଲି । ସର୍‌ଗେଅନି ସେ ଉଜଲ୍‌ ଆସି ମକେ ଆରି ମର୍‌ ସଙ୍ଗ୍‍ ଜିବା ଲକର୍‌ ଚାରିବେଟ୍‌ତି ବିଚି ଅଇଲା ।” ");
INSERT INTO dso_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ଆମେ ସବୁ ଲକ୍‌ ତଲେ ଅଦ୍‌ରି ଡୁଲିଦେଲୁ ଆରି ଇବ୍‌ରୁ ବାସାଇ ମକେ କଇତେରଇବା ଏ କାତା ସୁନ୍‌ଲି, “ସାଉଲ୍‌, ସାଉଲ୍‌ !” ତୁଇ ମକେ କାଇକେ କସ୍‌ଟ ଦେଲୁସ୍‌ନି ? କସ୍‌ଲାବେଲେ କସ୍‌ବାଲକ୍‌ ବଲଦ୍‌କେ ତୁତାରିବୁସ୍‌ଲେ ବଲଦ୍‌ ଲାତ୍‌ମାର୍‌ବା ପାରା, ତୁଇ ନିଜେ କସ୍‌ଟ ପାଇଲୁସ୍‌ନି । ");
INSERT INTO dso_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“ମୁଇ ପାଚାର୍‌ଲି, ‘ମାପ୍‌ରୁ ତମେ କେ ?’ ସେ କଇଲା, ‘ମୁଇ ଜିସୁ, ମକେସେ ତୁଇ କସ୍‌ଟ ଦେଲୁସ୍‌ନି ।’ ");
INSERT INTO dso_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ମାତର୍‌ ଉଟିକରି ଟିଆ ଅ । ତକେ ମର୍‌ ସେବାକାରିଆ କର୍‌ବାକେ, ଦର୍‌ସନ୍‌ ଦେଲିଆଚି । ଆଜି ତୁଇ ମର୍‌ ବିସଇ ଜାଇଟା ଦେକ୍‌ଲୁସ୍‌ ଆରି ପଚ୍‌କେ ମିସା ମୁଇ ଜାଇଟା ଦେକାଇବି, ସେ ବିସଇ ତୁଇ ବିନ୍‌ ଲକ୍‌ମନ୍‌କେ ସାକିଦେସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ଜନ୍‌ ଜିଉଦି ଆରି ଜିଉଦିନଇଲା ଲକ୍‌ମନର୍‌ତେଇ ତକେ ପାଟାଇବି, ସେମନର୍‌ତେଇ ଅନି ତାଡ୍‌ନା ପାଇଲେ, ମୁଇ ତକେ ରକିଆ କର୍‌ବି । ");
INSERT INTO dso_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ତୁଇ ସେମନର୍‌ ଆଁକି ପିଟାଇଦେସ୍‌ ବଲି ମୁଇ ତକେ କଇଲିନି । ଜେନ୍ତିକି ସେମନ୍‌ ଆନ୍ଦାରେଅନି ଉଜଲେ ଆରି ସଇତାନର୍‌ ବାନ୍ଦନେଅନି ମାପ୍‌ରୁର୍‌ ବାଟେ ବାଅଡ୍‌ବାଇ । ଜେନ୍ତିକି ମକେ ବିସ୍‌ବାସ୍‌ କଲାର୍‌ ପାଇ, ସେମନର୍‌ ପାପ୍‌ କେମା ଅଇସି । ଆରି ମାପ୍‌ରୁ ବାଚ୍‌ଲା ଲକ୍‌ମନର୍‌ ସଙ୍ଗ୍‍ ସେମନ୍‌କେ ମିସା ଡାକିନେବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“ସେଟାର୍‌ପାଇ ଏ ରାଜା ଆଗ୍‌ରିପା ମୁଇ ସର୍‌ଗେଅନି ଜନ୍‌ ଦର୍‌ସନ୍‌ ପାଇଲିଆଚି, ସେଟା ପୁରାପୁରୁନ୍‌ ମାନ୍‌ଲି । ");
INSERT INTO dso_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ସେନ୍ତାରି ମୁଇ ପର୍‌ତମେ ଦାମାସ୍‌କସେ ଆରାମ୍‌କରି ତାର୍‌ପଚେ ଜିରୁସାଲାମେ, ପଚେ ଜିଉଦାର୍‌ ସବୁବାଟେ ଆରି ଜିଉଦିନଇଲା ଲକ୍‌ମନର୍‌ ବିତରେ ମାପ୍‌ରୁର୍‌ ବିସଇ ଜାନାଇଲି । ଜେନ୍ତି କି ସେମନ୍‌ କରିରଇବା ପାପ୍‌ ଏତାଇ, ଦୁକ୍‌କରି ମାପ୍‌ରୁର୍‌ବାଟେ ବାଅଡ୍‌ବାଇ । ଆରି ସେମନ୍‌ ଜନ୍‌ଟା ମାନିଆଇଲାଇ ଆଚତ୍‌, ସେଟା ତାକର୍‌ ଚଲାଚଲ୍‌ତିଅନି ଜାନିଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ଏଟାର୍‌ପାଇ ମୁଇ ମନ୍ଦିରେ ରଇଲାବେଲେ ଜିଉଦିମନ୍‌ ମକେ ଦାରି ମରାଇବାକେ ଚେସ୍‌ଟା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ମାତର୍‌ ପର୍‌ମେସର୍‌ ମକେ ଆଜିକେଜାକ ରକିଆ କଲାଆଚେ ଆରି ସେଟାର୍‌ପାଇ ଆଜି ସାନ୍‌ ବଡ୍‌ ସବୁ ଲକର୍‌ ଲଗେ ସମାନ୍‌ ଇସାବେ ମର୍‌ ସାକିଦେବାକେ ଟିଆକରାଇଆଚେ । ବବିସତ୍‌ବକ୍‌ତା ଆରି ମସା ଜାଇଟା ଗଟ୍‌ସି ବଲି କଇରଇଲାଇ, ଟିକ୍‌ ସେ କାତା ମୁଇ କଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ମସିଅ ଦୁକ୍‌ ପାଇସି ଆରି ମଲାଲକ୍‌ମନର୍‌ ବିତ୍‌ରେଅନି ସିଗ୍‌ ପର୍‌ତୁମେ ଉଟି, ଜିଉଦି ଆରି ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ ଲଗେ ମୁକ୍‌ତିର୍‌ ଉଜଲ୍‌ ଦେକାଇସି ।” ");
INSERT INTO dso_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ପାଉଲ୍‌ ନିଜର୍‌ ବାଟେଅଇ କଇଲା ବେଲେ, ପେସ୍‌ଟସ୍‌ ତାକେ ଆଉଲିଅଇ କରି କଇଲା, “ପାଉଲ୍‌, ତୁଇ ବାୟା ଅଇଗାଲୁସ୍‌ ! ତୁଇ ପାଟ୍‍ପଡି ବେସି ପାଇରଇବା ଗିଆନ୍‌ ତକେ ବାୟା କଲାଆଚେ ।” ");
INSERT INTO dso_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ପାଉଲ୍‌ କଇଲା, “ଏ ମାପ୍‌ରୁ ପେସ୍‌ଟସ୍‌, ମୁଇ ବାୟା ଅଇନାଇ, ମୁଇ ଜାଇଟା କଇଲିନି ସେଟା ପୁରାପୁରୁନ୍‌ ସତ୍‌ । ଆରି ତବିର୍‌ ବୁଦିର୍‌ କାତା କଇଲିଆଚି । ");
INSERT INTO dso_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ଏ ରାଜା ଅଗ୍‍ରିପା ! ତମେ ଏ ବିସଇ ଜାନିରଇଲାର୍‌ ପାଇ, ତମର୍‌ ମୁଆଟେ ଏ କାତା କଇବାକେ ସାଆସ୍‌ କଲିନି ! ମୁଇ ଜାନାଇରଇବା ସବୁ ବିସଇର୍‌ କାଇ କାତା ମିସା, ସେ ନାଜାନେ, ବଲି ମୁଇ ବିସ୍‌ବାସ୍‌ କରିନାଇ ! କାଇକେବଇଲେ ଏଟା ଲୁଚ୍‌ତେ କରାଅଏ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ରାଜା ଆଗ୍‌ରିପା, ତମେ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ବିସ୍‌ବାସ୍‌ କଲାସ୍‌ନି ତ ? ମୁଇ ଜାନି ତମେ ବିସ୍‌ବାସ୍‌ କଲାସ୍‌ନି !” ");
INSERT INTO dso_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ଆଗ୍‌ରିପା ପାଉଲ୍‌କେ କଇଲା, “ଏ ଅଲପ୍‌ ବେଲା ବିତ୍‌ରେ ତୁଇ କାଇ ମକେ ବିସ୍‌ବାସି କରିଦେବି ବଲି ବାବ୍‌ଲୁସ୍‌ନି କି ?” ");
INSERT INTO dso_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ପାଉଲ୍‌ କଇଲା, “ଚନେକ୍‌ ଅ କି ପରେକ୍‌ ଅ, ପର୍‌ମେସରର୍‌ ଲଗେ ମର୍‌ ଏତ୍‌କି ମାଙ୍ଗ୍‌ଲିନି । ଅବ୍‌କା ତମେସେ ନାଇ ରାଜା, ଆଜି ମର୍‌ କାତା ସୁନିରଇବା ସବୁ ଲକ୍‌ ମର୍‌ପାରା କିରିସ୍‌ଟର୍‌ ସିସ୍‌ ଉଆ । ମାତର୍‌ ମର୍‌ପାରା ଏନ୍ତି ସିକ୍‌ଲିସଙ୍ଗ୍‍ ବାନ୍ଦାଇ ଉଆ ବଲି ମୁଇ କଇନାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ତାର୍‌ ପଚେ ରାଜା, ସାସନ୍‌କାରିଆ, ଆରି ବର୍‌ନିସ୍‌ ଆରି ବିନ୍‌ ଲକ୍‌ମନ୍‌ ଜିବାକେ ଉଟ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ସେମନ୍‌ ବାରଇଲା ବେଲେ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କଇଲାଇ, “ଏ ଲକ୍‌ ଏନ୍ତି କାଇମିସା କାମ୍‌ କରେ ନାଇ, ଜନ୍‌ଟା କି ସେ ମରନର୍‌ ଡଣ୍ଡ୍ ପାଇବାକେ କି ବନ୍ଦି ଅଇବାକେ ।” ");
INSERT INTO dso_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ଆଗ୍‌ରିପା ପେସ୍‌ଟସ୍‌କେ କଇଲା, “ଜଦି ଏ ଲକ୍‌ ବଡ୍‌ସାସନ୍‌କାରିଆଟାନେ ବିଚାର୍‌ ପାଇବି ବଲି ଗୁଆରି କରି ନ ରଇଲେ, ତେବେ ଆମେ ତାକେ ଚାଡି ଦେଇତୁ ।” ");
INSERT INTO dso_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ଆମେ ଜେଡେବେଲେ ପାନି ଜାଜେ ବସି ଇଟାଲି ଜିବାକେ ଟିକ୍‌ କଲାଇ, ସେଡ୍‌କିବେଲେ କେତେଟା ବନ୍ଦି ଅଇଲା ଲକ୍‌କେ ଆରି ପାଉଲ୍‌କେ ରମିୟ ସନିଅମନର୍‌ ସେନାପତି ଜୁଲିୟସ୍‍କେ ସର୍‌ପି ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ଆମେ ସବୁଲକ୍‌ ରମ୍‌ ରାଇଜର୍‌ ଆସିଆ ଜାଗାର୍‌ ଗାଡ୍‌କଣ୍ଡି ରଇଲା ବିନ୍‌ ବିନ୍‌ ଜାଗାଇ ଜୁ ବଲି ଆଦ୍‌ରାମୁଦିୟମର୍‌ ଗଟେକ୍‌ ପାନିଜାଜେ ବସି ଗାଲୁ । ଆରି ମାକିଦନିଆ ବଲି ଗଟେକ୍‌ ଜାଗାର୍‌ ଆରିସ୍‌ତାକସ୍‌ ନାଉଁର୍‌ ତେସ୍‌ଲନିକି ଲକ୍‌ ଆମର୍‌ ସଙ୍ଗ୍‍ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ଆର୍‌କର୍‌ ଦିନେ ଆମେ ସିଦନେ କେଟ୍‌ଲୁ । ଜୁଲିୟସ୍‌ ପାଉଲ୍‌କେ ବେସି ଦୟା ଦେକାଇତେରଇଲା । ପାଉଲର୍‌ ସଙ୍ଗାରିମନର୍‌ ଟାନେଅନି ତାର୍‌ ଦର୍‌କାର୍‌ ଅଇବା ଜିନିସ୍‌ମନ୍‌ ଟୁଲିଆଇବାକେ ତାକର୍‌ସଙ୍ଗ୍‍ ଜାଇ ମିସତ୍‌ ବଲି ପାଉଲ୍‌କେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ଆମେ ତେଇଅନି କେତେଦୁର୍‌ ଗାଲାପଚେ ପବନ୍‌ ଅଇଲାଜେ ସାଇପରସ୍‌ ଗାଡର୍‌ ପାଲି ପାଲି ଗାଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ସିଲିସିଆ ଆରି ପପୁଲିଆ ନାଉଁର୍‌ ଦୁଇଟା ଜାଗା ଜିତିକରି ଲୁକିଆ ବଲି ମୁରା ନଅର୍‌ ଜାଗାଇ ଆଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ତେଇ ସେନାପତି ଆଲେକ୍‌ଜାଣ୍ଡ୍‌ରିଆର୍‌ ଗଟେକ୍‌ ପାନି ଜାଜ୍‌ ଇଟାଲି ଜାଇତେରଇଲାଜେ ଆମ୍‌କେ ଦେକି, ସେ ଜାଜେ ବସାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ପଚେ ଆମ୍‌କେ ବେସିଦିନ୍‌ ଲାଗିଗାଲା ଦିରେ ଦିରେ ଜାଇ କରି କେଡେକ୍‌ କସ୍‌ଟେ କିଦ୍‌ ନାଉଁର୍‌ ଗଟେକ୍‌ ଜାଗାଇ କେଟ୍‌ଲୁ । ତେଇ କେଟ୍‌ଲା ପଚେ ବେସି ପବନ୍‌ ଆଇଲାଜେ ଆମେ ଆରି ଆଗ୍‌କେ ଜାଇ ନାପାର୍‌ଲୁ । ତେବେ ସାଲନି ବଲି ଗଟେକ୍‌ ଜାଗାର୍‌ ମୁଆଟ୍‌ ବାଟେ ଜାଇ କିରିତର୍‌ ପାଲି ପାଲି ଗାଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ଆରି ପାଲି ପାଲି ଆସି ବଡେ କସ୍‌ଟେ ସୁନ୍ଦର୍‌ ବନ୍ଦ୍‌ ବଲି ଗଟେକ୍‌ ପାନିଜାଜ୍‌ମନ୍‌ ଲାଗ୍‌ବାଟାନେ ଆସି କେଟ୍‌ଲୁ । ସେଟା ଲାସିଆ ସଅର୍‌ ଲଗେ ରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ସେ ଜାଗାଇ ଆମେ ବେସିଦିନ୍‌ ରଇଲୁ । ଜିଉଦିମନର୍‌ ଉପାସ୍‌ ମାନିଅଇବା ପରବ୍‌ ସାରି ଜାଇରଇଲା । ତେବେ ଗାଡ୍‌ ଗାଡ୍‌ ଜିବାଟା ବିପଦ୍‌ ରଇଲା । ସେଟାର୍‌ପାଇ ପାଉଲ୍‌ ସେମନ୍‌କେ ଜାଗ୍‌ରତ୍‌ କରାଇ କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“ମଇତର୍‌ମନ୍‌ ଆମେ ଏ ଗାଡ୍‌ ଗାଡ୍‌ ଗାଲେ ସରି ଜାଆଜ୍‌ ଆରି ଜିନିସ୍‌ପତର୍‌ ଆକା କେତି ନ ଅଏ, କେଡେବେଲେ ଜାଜେ ଜିବା ଲକ୍‌ମନର୍‌ ମିସା ଦସା କେଟ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ମାତର୍‌ ସେନାପତି ପାଉଲର୍‌ କାତା ବିସ୍‌ବାସ୍‌ ନ କରି, ଜାଜ୍‌ ଚାଲାଉ, ଜାଜ୍‌ ସାଉକାରର୍‌ କାତା ବିସ୍‌ବାସ୍‌ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ସେ ଗାଡେ ସିତ୍‌ମାସେ ରଇବାଟା ବେସି କସ୍‌ଟ ରଇଲା । ତେବେ କେନ୍ତି କରି ମିସା କସ୍‌ଟେ ମସ୍‌ଟେ ପେନିକସ୍‌ ବଲି ଗଟେକ୍‌ ଜାଗାଇ କେଟି, ଦର୍‌କାର୍‌ ପଡ୍‌ଲେ ତେଇ ରଇବାକେ ଜାଜେ ଜିବା କେତେଲକ୍‌ମନ୍‌ କର୍‌ତେରଇଲାଇ । ପିନିକସ୍‌ ଅଇଲାନି କିରିତେ ଦକିଣ୍‌, ପଚିମ୍‌ ଆରି ଉତର୍‌ ପୁରୁବ୍ ଦିଗେ ରଇବା ଗଟେକ୍‌ ଜାଗାର୍‌ ନାଉଁ । ");
INSERT INTO dso_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ଜେଡେବେଲେ ଦକିନ୍‌ ଦିଗ୍‌ବାଟେଅନି ଅଲପ୍‌ ଅଲପ୍‌ ପବନ୍‌ ଆଇଲା, ସେଡେବେଲେ ଜାଜେ ବସିରଇବା ଲକ୍‌ମନ୍‌ ଏଟା ଗଟେକ୍‌ ସୁବ୍‌କବର୍‌ ବଲି ବାବ୍‌ଲାଇ । ଜାଜ୍‌ ଅଟ୍‌କାଇବା ପାର୍‌ଦା ଟେକିଦେକ୍‌ଲାଇ ଆରି କିରିତ୍‌ ଗାଡ୍‌ ପାଲି ପାଲି ଜାଜ୍‌ ଚାଲାଇ ଚାଲାଇ ନେବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ମାତର୍‌ ଚନେକ୍‌ ଗାଲା ପଚେ କିରତ୍‌ବାଟେଅନି ଉତର୍‌ ପୁରବ୍‌ ବଲି କଇବା ପବନ୍‌ ଆଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ସେ ପବନ୍‌ ଅପର୍‌ବଲ୍‌ ଆସି ଜାଜେ ପିଟିଅଇଲା । ପବନ୍‌ ଆଇବା ମୁଆଟ୍‌ବାଟେ ଜାଜ୍‌ ନେବାକେ ଚେସ୍‌ଟା କରି କରି ନାପାରି ତାକିଗାଲୁ । ତେବେ ପବନ୍‌ ଜାଜ୍‌କେ ପାନି ଟାନେ ଉପ୍‌କାଇକରି ନେଅ ବଲି ଚାଡିଦେଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ଆରି କାଉଦ୍‌ ବଲି ଗୁଲାଇ ବାଟେ ପାନି ରଇକରି ମଜାଇ ସୁକ୍‌ଲା ବୁଇଁ ରଇବା ଜାଗାର୍‌ ଦକିଣ୍‌ ଦିଗ୍‌ବାଟେ ଗାଲାବେଲେ ଅଲପ୍‌ ପବନ୍‌ଟାନେ ଅନି ରକିଆ ପାଇଲୁ । ତେଇ ଆମେ କସ୍‌ଟେମସ୍‌ଟେ ଜାଆଜର୍‌ ସାନ୍‌ଡଙ୍ଗା କାଇ ବିପଦ୍‌ ନଇତେ ସଙ୍ଗଇପାର୍‌ଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ଜାଜ୍‌ ଚାଲାଉମନ୍‌ ସାନ୍‌ ଡଙ୍ଗା ଜାଜ୍‌ଉପ୍‌ରେ ଟେକି ନେଲାଇ ଆରି ଡର୍‌ ସଙ୍ଗ୍‍ ଡାଟ୍‌କରି ଜାଜର୍‌ ଚାରିବେଟ୍‌ତି ନ ବାଙ୍ଗ ବଲି ବାନ୍ଦି ଦେଲାଇ । ଜାଜ୍‌ ଚାଲାଉମନ୍‌ ଜାଜ୍‌କେ ଲିବିଆର୍‌ ପାଲି ପାଲି ବାଲିବନ୍ଦ୍‌ ବାଟେ ଉଟିଜାଇସି ବଲି ଜାଜେ ବାନ୍ଦି ରଇବା ଡେରା ଉତ୍‌ରାଇକରି ପବନେ ସେ ବଁଲି ବଁଲି ର ବଲି ଚାଡି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ଚନେକ୍‌ ମିସା ନ ତେବି ଅପର୍‌ବଲ୍‌ ପବନ୍‌ ଆଇବାର୍‌ ଦାର୍‌ଲା ଜେ, ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ସେମନ୍‌ ଜାଜେଅନି ଜିନିସ୍‌ ପତର୍‌ ପାନିତେଇ ପିଙ୍ଗ୍‌ବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ସେମନ୍‌ ଜାଜର୍‌ ପାଇ ଦର୍‌କାର୍‌ ଅଇବା କେତେଟା ଜିନିସ୍‌ ବେଟି ପିଙ୍ଗି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ବେସି ଦିନ୍‌ ଅଇଗାଲା ଆମେ ବେଲର୍‌ ମୁକ୍‌ ନାଇ କି ତାରାର୍‌ ମୁକ୍‌ ଦେକୁନାଇ ସେନ୍ତି ରଇଗାଲୁ । ପବନ୍‌ ଚନେକ୍‌ ମିସା ତେବେ ନାଇ, ଅଦିକ୍‌ ଅଦିକ୍‌ ଆଇତେସେ ରଇଲା । ସାରାସାରି ଆମେ ବଁଚ୍‌ବାର୍‌ ଆସା ଚାଡି ଦେଇରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ଏତେକ୍‌ ଦିନ୍‌ ଅଇଲା ସବୁ ଲକ୍‌ଜାକ ନ କାଇ ନ ପିଇ ରଇଲା ପଚେ ପାଉଲ୍‌, ଜାଜେ ଜିବା ଲକ୍‌ମନର୍‌ ମଜାଇ ଟିଆଅଇ କଇଲା, ମଇତର୍‌ମନ୍‌ ତମେ ମର୍‌ କାତା ଦାରି କିରତେଅନି ଜାଜ୍‌ ନ ଆନି ରଇଲେ ଆମ୍‌କେ ଏ ଦସା ନ ଆଇତା । ");
INSERT INTO dso_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ମାତର୍‌ ଏବେ ତମ୍‌କେ ଗୁଆରି କରି କଇଲିନି, ନ ଡରି, ବରସ୍‌ ଅଇରୁଆ । ତମର୍‌ ବିତ୍‌ରେଅନି କେ ମିସା ନ ମରାସ୍‌ । ଜାଜ୍‌ସେ ନସ୍‌ଟ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","କାଇକେବଇଲେ ମୁଇ ଜାର୍‌ ଲକ୍‌ ଅଇଲିଆଚି, ଆରି ଜନ୍‌ ପର୍‌ମେସର୍‌କେ ପାର୍‌ତନା କଲିନି, କାଲି ରାତି ତାର୍‌ ଗଟେକ୍‌ ସରଗର୍‌ ଦୁତ୍‌ ମକେ ଆସି କଇଲା, ");
INSERT INTO dso_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ପାଉଲ୍‌ ତୁଇ ଡର୍‌ ନାଇ । ବାଇଦରେ ସମ୍‌ରାଟର୍‌ ମୁଆଟେ ତୁଇ ଟିଆ ଅଇସୁଆକା । ପର୍‌ମେସର୍‌ ତକେ ଜିବନ୍‌ ଦୁକାଇଲାଆଚେ । ଜେ କି, ତକେ ଆରି ତର୍‌ ସଙ୍ଗ୍‍ ଜାଇତେ ରଇବା ସବୁ ଲକ୍‌ମନ୍‌କେ ବଁଚାଇସି । ");
INSERT INTO dso_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ତେବେ ବାଇମନ୍‌ ତମେ ନ ଡରି ବରସ୍‌ ଅଇରୁଆ । କାଇକେ ବଇଲେ ମୁଇ ପରମେସର୍‌କେ ବିସ୍‌ବାସ୍‌ କଲିନି, ମକେ ଜେନ୍ତି କଇଲାଆଚେ ଟିକ୍‌ ସେନ୍ତାରିସେ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ମାତର୍‌ ଆମେ ଆଗ୍‌କେ ଗାଲେ ଗଟେକ୍‌ ଗୁଲାଇବାଟେ ପାନି ରଇକରି ମଜାଇ ରଇବା ସୁକ୍‌ଲା ଜାଗାଇ ପବନ୍‌ କେଟାଇସି । ");
INSERT INTO dso_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ଏନ୍ତାରି ଆମେ ବାଉପବନ୍‌ ଆରାମ୍‌ଅଇକରି ଚଉଦ ଦିନ୍‌ ଚଉଦ ରାତି ମିସା ଅଇଗାଲା । ପବନ୍‌ ଆମ୍‌କେ ବୁମଦ୍‌ ସମ୍‌ଦୁରେ ଏନେ ତେନେ ନେଇତେରଇଲା । ମଜାରାତି ଅଇଲାକେ ଜାଜ୍‌ ଚାଲାଉମନ୍‌ ଗଟେକ୍‌ କଣ୍ଡିପାଲି ଲଗାଲଗି ଆଇଲୁ ବଲି ଅନ୍‌ମାନ୍‌ କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ତେବେ ସେମନ୍‌ ଗଟେକ୍‌ ବଜ୍‌ ଜିନିସ୍‌ ଡର୍‌ସଙ୍ଗ୍‍ ବାନ୍ଦିକରି ନାପିକରି ଜାନ୍‌ଲାଇ ଜେ, ତେଇ ସଏ କଡେ ପୁଟ୍‌ ପାନି ଡେଙ୍ଗ୍‌ ରଇଲା । ଆରି କଣ୍ଡେକ୍‌ ଦୁର୍‌ ଆଇଲାଇକେ ନବେ ପୁଟ୍‌ ପାନି ନାପ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ପାନି ଜାଜ୍‌ କନ୍‌ଆଲେ ଡଙ୍ଗ୍‌ରର୍‌ ପାକ୍‌ନାଇ ଡୁକାଇ ଅଇଜାଇସି ବଲି ଡରିକରି ସେମନ୍‌ ପଚ୍‌ବାଟେ ଚାର୍‌ଟା ଜାଜ୍‌ ଅଟ୍‌କାଇବାଟା ପାକାଇଲାଇ । ଆରି ଦାପ୍‌ରେ ସାକାଲ୍‌ ପାଅ ବଲି ପାର୍‌ତନା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ତାର୍‌ ପଚେ ଜାଜ୍‌ ଚାଲାଉମନ୍‌ ଜାଜେଅନି ଲୁଚି ପାଲାଇବାକେ ଚେସ୍‌ଟା କଲାଇ । ସାନ୍‌ ଡଙ୍ଗା ବାନ୍ଦିରଇବା ଡର୍‌ ବେଟି ଡଙ୍ଗା ସମ୍‌ଦୁରେ ଉତ୍‌ରାଇଲାଇ । ସେମନ୍‌ ଆରି କେତେଟା ଜାଜ୍‌ ଅଟ୍‌କାଇବାଟା ମୁଆଟ୍‌ବାଟେ ପାକାଇବୁ ବଲି ନାଡାଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ମାତର୍‌ ପାଉଲ୍‌, ସେନାପତି ଆରି ସନିଅମନ୍‌କେ କଇଲା, “ଜଦି ଜାଜ୍‌ ଚାଲାଉମନ୍‌ ଜାଜେ ନ ରଇଲେ ତମେ ମରିଜାଇସା ।” ");
INSERT INTO dso_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ସେଟାର୍‌ପାଇ ସନିଅମନ୍‌ ଡଙ୍ଗାର୍‌ ଡର୍‌ କାଟି ଦେଲାଇ ଆରି ପାନି ଉପ୍‌ରେ ବଁଲି ଜାଅ ବଲି ଚାଡି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ପାଉଲ୍‌ କୁକ୍‌ଡାଡାକେ ସବୁ ଲକ୍‌କେ କାଆ ବଲି ବାବୁଜିଆ କଲା । ସେ କଇଲା, ଆଜିକେ ଚଉଦ ଦିନ୍‌ ଅଇଗାଲା କାଆସ୍‌ ନାଇ, ପିଆସ୍‌ ନାଇ, ବୁକେସେ ଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ତେବେ ମୁଇ ତମ୍‌କେ କାଇଟା ଆଲେ କାଆ ବଲି ବୁଜାଇଲିନି, କାଇକେ ବଇଲେ, ବଁଚି ରଇବାର୍‌ ଆଲେ କାଇବାର୍‌ ଆଚେଆକା । ଡରା ନାଇ ! ତମ୍‌କେ କାଇଟା ନ ଅଏ । ");
INSERT INTO dso_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ପାଉଲ୍‌ ଏନ୍ତାରି କଇକରି ରୁଟି ଦାର୍‌ଲା ଆରି ସବୁ ଲକର୍‌ ମୁଆଟେ ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଇ ରୁଟି ଚିଡାଇ କାଇବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ତେଇ ସେମନ୍‌ ସବୁ ଲକ୍‌ ସାଆସ୍‌ ଅଇକରି ଆରି ନିଜେ ନିଜେ କାଇବାର୍‌ ଦାର୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ଆମେ ସେ ଜାଜେ ସବୁ ଲକ୍‌ ମିସି ଦୁଇସ ସତୁରି ଚଅ ଲକ୍‌ ରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ସବୁ ଲକ୍‌ ପେଟ୍‌ ପୁର୍‌ତେ କାଇ ସାର୍‌ଲା ପଚେ ଜାଜ୍‌ ଉସାସ୍‌ ଅ ବଲି ଜାଜେ ରଇଲା ସବୁ କାଦିକଣ୍ଡା ସମ୍‌ଦୁରେ ପିଙ୍ଗି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ସାକାଲ୍‌ ପାଇଲାକେ କଣ୍ଡିର୍‌ କନ୍‌ ଜାଗାଇ ଆସି କେଟ୍‌ଲୁଆଚୁ ବଲି ଜାଜ୍‌ ଚାଲାଉମନ୍‌ ଜାନି ନାପାର୍‌ଲାଇ । ମାତର୍‌ ସେମନ୍‌ ଦେକ୍‌ଲାଇ, ଜେ ସେଟା ଗଟେକ୍‌ ସମ୍‌ଦୁର୍‌ ଆରି ଗାଡ୍‌ ମିସ୍‌ଲା ବାଲିପଟା ଜାଗା । ଜଦି ପାର୍‌ଲେ ତେଇ ଜାଜ୍‌ ଲାଗାଉଁ ବଲି ଚେସ୍‌ଟା କଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ସେଟାର୍‌ପାଇ ଜାଜ୍‌ ଅଟ୍‌କାଇବାକେ ବାନ୍ଦି ରଇବା ଡର୍‌ ସବୁ କାଟି ଦେଇ, ସେଟା ସବୁ ସମ୍‌ଦୁରେ ତପି ଅଇବାକେ ଚାଡି ଦେଲାଇ । ଆରି ଜାଜ୍‌ ସଲ୍‌କାଇବାକେ ବାନ୍ଦି ରଇବା ଡର୍‌ କୁସ୍‌ଲାଇଦେଇ ମୁଆଟେ ବାନ୍ଦି ଅଇରଇବା ଡେରାକେ ଟେକି ଦେଲାଇ । ସେନ୍ତା କଲାକେ ଜାଜ୍‌ ପବ୍‌ନେ ଟେଲାଇ ଟେଲାଇ ଅଇକରି କଣ୍ଡିବାଟେ ଜିବାର୍‌ ଦାର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ଗାଡ୍‌ ଆରି ସମ୍‌ଦୁର୍‌ ମିସ୍‌ଲା ସାଙ୍ଗାମର୍‌ ବାଲିପାଟାଇ, ଜାଜ୍‌ ଡୁକାଇ ଅଇ ମୁଆଁଟ୍‌ ବାଟର୍‌ଟା ତଲେ ତପିଅଇ ଅଟ୍‌କି ଦେଲା । ଅପର୍‌ବଲ୍‌ ଲଉଡି ଆସି ଜାଜର୍‌ ପଚ୍‌ବାଟେ ଡୁକାଇ ଅଇଲାକେ ପଚ୍‌ ବାଟର୍‌ଟା ମିସା ବାଙ୍ଗି କଣ୍ଡ୍ କଣ୍ଡ୍ ଅଇଗାଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ସନିଅମନ୍‌ ବନ୍ଦି ଲକ୍‌ମନ୍‌କେ ପଅଁରି ପଅଁରି ଉଟିଜିବାଇ ବଲି ବାବି କରି ମାରିମରାଇବାକେ ବାବ୍‍ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ମାତର୍‌ ସେନାପତି ପାଉଲର୍‌ ଜିବନ୍‌ ବଁଚାଇବି ବଲି ବାବ୍‌ତେ ରଇଲା । ତେବେ ସେ ସନିଅମନ୍‌କେ ସେନ୍ତାରି କରାନାଇ ବଲି ମନାକଲା । ଜେତ୍‌କି ପଅଁରି ପାର୍‌ବା ସବୁ ଲକ୍‌ମନ୍‌କେ ପାନିଟାନେ ଡେଗଇକରି ପଅଁରି ପଅଁରି କଣ୍ଡିତେଇ ଜିବାକେ ଆଦେସ୍‌ ଦେଲା । ");
INSERT INTO dso_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ଆରି ବାକି ଲକ୍‌ମନ୍‌କେ ଜାଜର୍‌ ବାଙ୍ଗ୍‌ଲା ପାଟା ଆରି କାଇ କାଇଟାମନ୍‌ ଦାରି ପଅଁରି କରି ବାରୁଆ । ବଲି କଇଲା । ଏନ୍ତାରି ଅଇ ସବୁଲକ୍‌ କାଇଟା ନ ଅଇତେ କଣ୍ଡି ଆସି ବାରଇଲାଇ । ସାରାସାରି ଆମେ ସବୁଲକ୍‌ କଣ୍ଡି କେଟ୍‌ଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","କାଇଟା ନ ଅଇ, କଣ୍ଡିପାଲି ଜାଇ ଦେକ୍‌ଲୁ ଜେ, ଆମେ ମେଲିତି ନାଉଁର୍‌ ଚାରିବେଟ୍‌ତି ପାନିର୍‌ ମଜାଇ ରଇବା ସୁକ୍‌ଲା ଜାଗାଇ କେଟିଆଚୁ । ");
INSERT INTO dso_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ତେଇ ପୁର୍‌ବେଅନି ରଇବା ଲକ୍‌ମନ୍‌ ଆମ୍‌କେ ଆଲାଦ୍‌ ଦେକାଇଲାଇ, ସେବେଲେ ବର୍‌ସା ମାରି ସିତ୍‌ ଅଇତେ ରଇଲା । ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ଆମ୍‌କେ ଜଇ ଲାଗାଇ ଗତିଆ ମାନ୍‌ଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ପାଉଲ୍‌ ଗଟେକ୍‌ ବିଡା ଦାରୁ ଜଇତେଇ ପାକାଇବା ବେଲେ ଜଇ ତାତିର୍‌ ଲାଗି ବିଡାଇଅନି ଗଟେକ୍‌ ବିସ୍‌ରଇବା ସାଁପ୍‌ ବାରଇଲା ଆରି ପାଉଲର୍‌ ଆତେ ଚଗି ଚାବି ଡସିରଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ସେ ଜାଗାର୍‌ ଲକ୍‌ମନ୍‌ ପାଉଲର୍‌ ଆତେ ଚାବିକରି ଡସି ଜୁଲ୍‌ତେ ରଇବା ସାଁପ୍‌କେ ଦେକି ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ କୁଆବଲା ଅଇଲାଇ, “ଏ ବାଇଦରେ ଗଟେକ୍‌ ନର୍‌ମାରୁ ଲକ୍‌, ସେ ଜାଇଟା ମିସା ଅ ବେ, ସେ ସମ୍‌ଦୁରେ ରକିଆ ପାଇରଇଲେ ମିସା ତାର୍‌ କରମ୍‌ ତାକେ ବଁଚ୍‌ବାକେ ନ ଦେଏ ।” ");
INSERT INTO dso_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ମାତର୍‌ ପାଉଲ୍‌ ତାର୍‌ ଆତ୍‌ ଜିଞ୍ଜାଡ୍‌ଲାକେ ସାଁପ୍‌ ଜଇତେଇ ଅଦର୍‌ଲା ଆରି ତାକେ କାଇଟା ଅଏନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ଲକ୍‌ମନ୍‌ ପାଉଲର୍‌ ଆତ୍‌ ପୁଲିଜାଇସି ନଇଲେ ଅଟାତ୍‌ ଅଦ୍‌ରି ମରିଜାଇସି ବଲି ଜାଗିରଇଲାଇ, ମାତର୍‌ ବେସି ପର୍‌ ଜାଗିକରି ଦେକ୍‌ଲାଇ ମିସା ତାକେ କାଇଟା ଅଏ ନାଇ । ପଚେ ସେମନ୍‌ କାତା ପାସ୍‌ଲାଇକରି କଇଲାଇ “ଏ ଗଟେକ୍‌ ଦେବ୍‌ତା !” ");
INSERT INTO dso_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ତେଇଅନି ଅଲପ୍‌ ଦୁରିକେ ସେ ଜାଗାର୍‌ ମୁକିଅ ନେତା, ତାର୍‌ ନାଉଁ ପବ୍‌ଲିଅ । ତାର୍‍ କେତେଟା ପଦା ରଇଲା, ସେ ଆମ୍‌କେ ଗତିଆ ମାନିକରି ଡାକିନେଲା । ଆରି ଆମେ ତିନ୍‌ ଦିନ୍‌ ଜାକ ତାକର୍‌ ଗରେ ଗତିଆ ଅଇ ରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ସେବେଲେ ପବ୍‌ଲିଅସର୍‌ ବାବା ଜର୍‌ ଆରି ରକତ୍‌ଜାଡା ଦାରାଇଅଇ ଡୁଲିରଇଲା । ପାଉଲ୍‌ ତାକର୍‌ ବାକ୍‌ରାଇ ଜାଇ ତାର୍‌ପାଇ ପାର୍‌ତନା କରି ତାର୍‌ ଉପ୍‌ରେ ଆତ୍‌ ଚିଇ ତାକେ ନିମାନ୍‌କଲା । ");
INSERT INTO dso_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ଏ ଗଟ୍‍ନା ପଚେ ସେ ଜାଗାର୍‌ ଜେତ୍‌କି ରଗିମନ୍‌ ସବୁ ପାଉଲର୍‌ ଲଗେ ଆସି ନିମାନ୍‌ ଅଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ସେମନ୍‌ ଆମ୍‌କେ ବେସି ବିନ୍‌ ବିନ୍‌ ରକାମର୍‌ ଜିନିସ୍‌ ଇନାମେ ଦେଲାଇ ଆରି ଆମେ ତେଇଅନି ଜାଜେ ବସି ଜିବାବେଲେ ସେମନ୍‌ ଆମର୍‌ପାଇ ଦର୍‌କାର୍‌ ରଇଲା ସବୁ ଜିନିସ୍‌ ଜାଜେ ଆନି ଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ସେ ଜାଗାଇଅନି ବାରଇବାକେ ଆମ୍‌କେ ତିନ୍‌ମାସ୍‌ ଲାଗ୍‌ଲା । ସିତ୍‌ଦିନ୍‌ ଅଇରଇଲାକେ ତବିର୍‌ଅଇଲା ଆଲେକ୍‌ଜାଣ୍ଡ୍‌ରିଆ ନଅରେଅନି ଆସିରଇବା ଗଟେକ୍‌ ଜାଜେ ଆମେ ବାରଇଲୁ । ସେ ଜାଜର୍‌ ନାଉଁ ରଇଲା ଜଁଲି ଦେବ୍‌ତା । ");
INSERT INTO dso_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ପର୍‌ତୁମ୍‌ ସିର୍‌କୁସ୍‌ ନାଉଁର୍‌ ନଅରେ କେଟି ତେଇ ତିନ୍‌ଦିନ୍‌ ରଇଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ତେଇଅନି ଆରି ତରେକ୍‌ ଜିବାଟା ଆରାମ୍‌ କରି ଆମେ ରେଜିଅମ୍‌ ସଅରେ କେଟ୍‌ଲୁ । ତାର୍‌ ଆର୍‌କର୍‌ ଦିନେ ଦକିଣ୍‌ ଦିଗେଅନି ପବନ୍‌ ଆଇଲା ଆରି ଦୁଇଦିନ୍‌ ପଚେ ପୁତେଅଲି ସଅରେ କେଟ୍‌ଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ତେଇ କେତେଟା ଜିସୁକେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ବାଇମନ୍‌କେ ମିସ୍‌ଲୁ । ତାକର୍‌ ସଙ୍ଗ୍‍ ଗଟେକ୍‌ ଆଟ୍‌ ରଇବାକେ ସେମନ୍‌ ଆମ୍‌କେ ବାବୁଜିଆ କଲାଇ । ସାରାସାରିପଚେ ଆମେ ରମ୍‌ ଦେସେ ଜାଇ କେଟ୍‌ଲୁ । ");
INSERT INTO dso_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ଆମେ ଗାଲା କବର୍‌ ସୁନିକରି ରମ୍‌ ଦେସର୍‌ ବିସ୍‌ବାସି ବାଇମନ୍‌ ତେଇଅନି ଆପିଅ ଜାଗାର୍‌ ଆଟେ ଆରି ତିନ୍‌ସରା ନାଉଁର୍‌ ନଅର୍‌ମନ୍‌ ଜାକ ଆମ୍‌କେ ବେଟ୍‌ ଅଇବାକେ ଇଣ୍ଡି ଇଣ୍ଡି ଆଇଲାଇ । ସେମନ୍‌କେ ଦେକି ପାଉଲ୍‌ ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲା ଆରି ବେସି ସାର୍‌ଦା ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ଆମେ ରମ୍‌ ଦେସେ କେଟ୍‌ଲା ପଚେ ପାଉଲ୍‌କେ ଗଟେକ୍‌ ସନିଅ ସଙ୍ଗ୍‍ ଗଟେକ୍‌ ଗରେ ରଇବାକେ ଆଦେସ୍‌ ମିଲ୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ତିନ୍‌ ଦିନ୍‌ ପଚେ ପାଉଲ୍‌ ସେ ଜାଗାର୍‌ ଜିଉଦି ନେତାମନ୍‌କେ ଗଟେକ୍‌ ସବା କର୍‌ବାକେ କବର୍‌ ପାଟାଇଲା । ସେମନ୍‌ ଆସି ରୁଣ୍ଡ୍‌ଲାଇକେ ପାଉଲ୍‌ ସେମନ୍‌କେ କଇଲା, “ଏ ଇସ୍‌ରାଏଲର୍‌ ବାଇମନ୍‌, ମୁଇ ଆମର୍‌ ଲକ୍‌ମନର୍‌ ବିରୁଦେ କି ଆମର୍‌ ଆନିଦାଦିମନର୍‌ ଟାନେଅନି ସିକିରଇବା ରିତିନିତି ବିରୁଦେ କିଚି କରିନାଇ, ଏଲେ ମିସା ଜିରୁସାଲାମର୍‌ ଜିଉଦିମନ୍‌ ମକେ ଦାରି ବନ୍ଦିଗରେ ପୁରାଇ ରମିଅମନ୍‌କେ ସର୍‌ପିଦେଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ମକେ ପାଚାର୍‌ ଉଚାର୍‌ କଲା ପଚେ ମରନ୍‌ ଡଣ୍ଡ୍ ପାଇବା ଏତ୍‌କି କାଇ ଅପ୍‌ରାଦ୍‌ କରେ ନାଇ ବଲି ଜାନ୍‌ଲାଇ । ପଚେ ରମିଅ ଲକ୍‌ମନ୍‌ ମକେ ମୁକ୍‌ଲାଇବାକେ ମନ୍‍ କର୍‌ତେ ରଇଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ମାତର୍‌ ଜିଉଦି ଲକ୍‌ମନ୍‌ ମକେ ଚାଡ୍‌ବାକେ ରାଜି ଅଅତ୍‌ନାଇ । ତେବେ ମର୍‌ ନିଜର୍‌ ଲକ୍‌ମନର୍‌ ବିରୁଦେ ମର୍‌ କାଇ ଦାବି ନ ରଇଲା ମିସା, ମୁଇ ବଡ୍‌ସାସନ୍‌କାରିଆକେ ଗୁଆରି କର୍‌ବି ଆକା ବଲି ବାବ୍‌ଲି । ");
INSERT INTO dso_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ସେଟାର୍‌ପାଇ ଏ ବିସଇ କାତାବାର୍‌ତା ଅଉଁ ବଲି ମୁଇ ତମ୍‌କେ ଡାକାଇ ଆଚି । ଇସ୍‌ରାଏଲର୍‌ ଲକ୍‌ମନ୍‌ ଏବେ ଜାକେ ଆସା କରି ଆଇଲାଇନି, ତାର୍‌ପାଇ ବଲିକରି ମୁଇ ଆଜି ସିକ୍‌ଲି ସଙ୍ଗ୍‍ ବାନ୍ଦାଇ ଅଇଆଚି ।” ");
INSERT INTO dso_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ସେମନ୍‌ କଇଲାଇ, “ଆମ୍‌କେ ଜିଉଦା ଦେସେଅନି ତମର୍‌ ବିସଇ କାଇ ଚିଟି ଗଟେକ୍‌ ମିସା ମିଲେ ନାଇ, କି ବାଇମନର୍‌ ବିତ୍‌ରେଅନି କେ ମିସା ଇତି ଆସି ତମର୍‌ ବିସଇର୍‍ ବୁଲ୍‌ କାତା ସୁନାଅତ୍‌ ନାଇ କି କଅତ୍‌ ମିସା ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ମାତର୍‌ ତମେ କାଇଟା ବଲି ବିସ୍‌ବାସ୍‌ କଲାସ୍‌ନି, ସେଟା ତମର୍‌ଟାନେଅନି ଆମେ ସୁନ୍‌ବାକେ ମନ୍‍ କଲୁନି । କାଇକେବଇଲେ, ଗୁଲାଇବାଟର୍‌ ଲକ୍‌ ତମର୍‌ ଦଲ୍‌ ବିରୁଦେ କାତା ଅଇଲାଇନି ।” ");
INSERT INTO dso_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ସେମନ୍‌ ଗଟେକ୍‌ଦିନ୍‌ ଟିକ୍‌ କଲାଇ ଆରି ଟିକ୍‌ କଲା ଦିନେ ସେମନର୍‌ ବିତ୍‌ରେଅନି ବେସି ଲକ୍‌ ପାଉଲ୍‌ ରଇବା ଜାଗାଇ ଆଇଲାଇ । ପାଉଲ୍‌ ସେମନ୍‌କେ ସାକାଲେଅନି ସଞ୍ଜ୍‌ଜାକ ପରମେସର୍‌ ରାଇଜ୍‌ ବିସଇ ବୁଜାଇଦେଲା ଆରି ମସାର୍‌ ରିତିନିତି ଆରି ବବିସତ୍‌ବକ୍‌ତାମନ୍‌ ଲେକ୍‌ଲା ସାସ୍‌ତରର୍‌ ବାକିଅ ଦେକାଇକରି ଜିସୁର୍‌ ବିସଇ ବୁଜାଇଲା । ");
INSERT INTO dso_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ତେଇ କେତେ ଲକ୍‌ ପାଉଲ୍‌ କଇଲା କାତା ବିସ୍‌ବାସ୍‌ କଲାଇ, ମାତର୍‌ କେତେ ଲକ୍‌ ବିସ୍‌ବାସ୍‌ କରତ୍‌ ନାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ତେବେ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ ଦଦାପେଲା ଅଇକରି ବାରଇ ଉଟିଗାଲାଇ । ପାଉଲ୍‌ ଗଟେକ୍‌ କାତା କଇଲା, ସୁକଲ୍‌ ଆତ୍‌ମା ତମର୍‌ ଆନିଦାଦିମନ୍‌କେ ଜିସାୟ ବବିସତ୍‌ବକ୍‌ତାର୍‌ ଡଣ୍ଡେଅନି ସତ୍‌ କାତା କଇରଇଲା ! ");
INSERT INTO dso_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ସେ କଇରଇଲା, “ଏ ଲକ୍‌ମନ୍‌କେ ଜାଇ କଅ, ତମେ ସୁନି ସୁନି ରଇସା, ମାତର୍‌ ନ ବୁଜାସ୍‌ । ଦେକି ଦେକି ରଇସା, ମାତର୍‌ ନ ଚିନାସ୍‌ ।” ");
INSERT INTO dso_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","କାଇକେ ବଇଲେ ଏ ଲକ୍‌ମନର୍‌ ମନ୍‌ ବେସି ଆଁଟ୍‌, ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ଆଁକି ଲିମିଦେଇ ଆଚତ୍‌ ଆରି କାନ୍‌ ଚୁଟି ଦେଇ ଆଚତ୍‌, ସେମନ୍‌ ଜଦି ଆଁକି ଦେକ୍‌ତାଇ, ଆରି ଚୁଟି ଅଇଲା କାନ୍‌ ଉଗାଡି ସୁନ୍‌ତାଇ । ସେନ୍ତାର୍‌ ଆଲେ ସେମନ୍‌ ମନେ ମନେ ବୁଜ୍‌ତାଇ । ଆରି ସେମନ୍‌ ମର୍‌ଲଗେ ବାଅଡ୍‌ତାଇ ଆରି ମୁଇ ସେମନ୍‌କେ ନିକ କର୍‌ତି । ଏଟା ପରମେସର୍‌ କଇଲାନି । ");
INSERT INTO dso_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ସାରାସାରିପଚେ ପାଉଲ୍‌ କଇଲା “ତେବେ ପରମେସରର୍‌ ମୁକ୍‌ତି ଜିଉଦିନଇଲା ଲକ୍‌ମନର୍‌ ପାଇ ଆଇଲା ଆଚେ । ଏଟା ତମେ ଜାନିରୁଆ, ସେମନ୍‌ ମିସା ସେଟା ମାନ୍‌ବାଇ ।” ");
INSERT INTO dso_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ପାଉଲ୍‌ ଏ ସବୁ କାତା କଇଲାକେ, ଜିଉଦିମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ବିତ୍‌ରେ ଦଦାପେଲା ଅଇଅଇକରି ଉଟିଗାଲାଇ । ");
INSERT INTO dso_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ପାଉଲ୍‌ ଗଟେକ୍‌ ଗର୍‌ ବାଡାକରି ତେଇ ଦୁଇ ବରସ୍‌ ଜାକ ରଇଲା ଆରି ତାକେ ଦେକ୍‌ବାକେ ଆଇଲା ସବୁ ଲକ୍‌ମନ୍‌କେ ତେଇ ଗତିଆ ମାନ୍‌ତେରଇଲା । ଜେତ୍‌କି ଲକ୍‌ ପାଉଲର୍‌ ଲଗେ ଆଇତେ ରଇଲାଇ ସେ ସବୁ ଲକ୍‌କେ ଡାକି, କାକେ ନ ଡର୍‌ତେ କଲା । ");
INSERT INTO dso_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ଆରି ତାକେ କେ ମିସା ତେବାଅତ୍‌ ନାଇ । ସେ ପରମେସରର୍‌ ରାଇଜ୍‌ ବିସଇ ଜାନାଇକରି ମାପ୍‌ରୁ ଜିସୁକିରିସ୍‌ଟର୍‍ ବିସଇ ସିକିଆ ଦେଇତେରଇଲା ।");
INSERT INTO dso_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ମୁଇ ପାଉଲ୍‌ ଏଟା ଲେକ୍‌ଲିନି, ମୁଇ କିରିସ୍‌ଟ ଜିସୁର୍‌ ଗଟେକ୍‌ ସେବାକାରିଆ । ପର୍‌ମେସର୍‌ ମକେ ବାଚ୍‌ଲା ଆରି ତାର୍‌ ନିମାନ୍‌ କବର୍‌ ଜାନାଇବାକେ ସର୍‌ପିଦେଲା । ରମ୍‌ ରାଇଜେ ରଇବା ତମର୍‌ ସବୁଲକର୍‌ପାଇ ମୁଇ ଏ ଚିଟି ପାଟାଇଲିନି । ");
INSERT INTO dso_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ପର୍‌ମେସର୍‌ ଏ ବିସଇ ଆଗେଅନି କାତା ଦେଇରଇଲା, ଆରି ସୁକଲ୍‌ ସାସ୍‌ତରେ ସେ ସବୁ ଲେକ୍‌ବା ପାଇ ତାର୍‌ ବବିସତ୍‌ବକ୍‌ତାମନ୍‌କେ ତିଆର୍‌ଲା । ");
INSERT INTO dso_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ଏ ସୁବ୍‌କବର୍‌ତେଇ ପରମେସରର୍‌ ପଅ, ଆରି ଆମର୍‌ ମାପ୍‌ରୁ ଜିସୁକିରିସ୍‌ଟର୍‌ ବିସଇ ଆଚେ । ସେ ଏ ମଚ୍‌ପୁରେ ନର୍‌ ରୁପ୍‌ଦାରି ଦାଉଦର୍‌ ନାତିତିତି ଅଇ ଜାତ୍‌ ଅଇଲା । ");
INSERT INTO dso_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ମାତର୍‌ ସେ ପୁରାପୁରୁନ୍‌ ସୁକଲ୍‌ ରଇଲା, ଆରି ପର୍‌ମେସରର୍‌ ବଡ୍‌ ବପୁସଙ୍ଗ୍‍ ତାକେ ମଲାଟାନେଅନି ଉଟାଇଲା । ମଲାଟାନେଅନି ଉଟ୍‌ଲାର୍‌ପାଇ ସେ ପରମେସରର୍‌ ପଅ ବଲି ଦେକାଇଲା । ");
INSERT INTO dso_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ପରମେସର୍‌ କିରିସ୍‌ଟର୍‌ ତେଇଅନି ମକେ ଗଟେକ୍‌ ପେରିତ୍‌ କଲାଆଚେ, ଜେନ୍ତାରି କି ସବୁ ଜଗତର୍‌ ଲକ୍‌ମନ୍‍କେ ତାର୍‌ ବିସଇ ଜାନାଇବି । ସେମନ୍‌ ସେଟା ବିସ୍‌ବାସ୍‌ କରି ମାନ୍‌ବାଇ । ");
INSERT INTO dso_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ଏ ରମ୍‌ ଦେସର୍‌ ଲକ୍‌ ! ତମେମିସା ଜିସୁକିରିସ୍‌ଟର୍‌ ସିସ୍‌ ଅଇବାକେ ବାଚାଇ ଅଇଆଚାସ୍‌ । ");
INSERT INTO dso_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ରମେ ରଇବା ସବୁ ଲକ୍‌କେ ଏ ଚିଟି ଲେକ୍‌ଲିନି । କାଇକେବଇଲେ ତମ୍‌କେ ପରମେସର୍‌ ଆଲାଦ୍‌ କଲାନି । ଆରି ତାର୍‌ ନିଜର୍‌ ଲକ୍‌ ଅଇବାକେ ଡାକି ଆଚେ । ଆମର୍‌ ବାବା ପରମେସର୍‌ ଆରି ମାପ୍‌ରୁ ଜିସୁକିରିସ୍‌ଟ ତମ୍‌କେ ଜିବନ୍‌ ଦୁକାଇ ସାନ୍ତି ଦେଅ । ");
INSERT INTO dso_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ମୁଇ ତମ୍‌କେ ପର୍‌ତମେ ଏ ବିସଇ କଇବାକେ ମନ୍‍ କରି ରଇଲିଜେ, ତମର୍‌ ସବୁଲକର୍‌ପାଇ ମୁଇ ମାପ୍‌ରୁ ଜିସୁର୍‌ ନାଉଁ ଦାରି ପର୍‌ମେସର୍‌କେ ଦନିଅବାଦ୍‌ ଦେଲିନି । କାଇକେବଇଲେ ଗୁଲାଇ ଜଗତର୍‌ ଲକ୍‌, ତମେ ବିସ୍‌ବାସ୍‌ କରିରଇବା ବିସଇ ସୁନ୍‌ଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ମୁଇ ମର୍‌ ସବୁ ମନ୍‌ପରାନ୍‌ ଦେଇ ଜନ୍‌ ପରମେସର୍‌କେ ସେବା କଲିନି, ଆରି ଜନ୍‌ ପରମେସରର୍‌ ପଅର୍‌ ସୁବ୍‌ କବର୍‌ ଜାନାଇଲିନି, ସେ ପରମେସର୍‌ ମର୍‌ ସାକି । ");
INSERT INTO dso_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ମୁଇ ପାର୍‌ତନା କଲାବେଲେ ତମ୍‌କେ ସବୁବେଲେ ଏତାଇଲିନି । ସେ ମନ୍‍ କଲେ, ମକେ ତମର୍‌ ଲଗେ ଜିବାକେ ବେଲା ଟିକ୍‍ କରି ଦେଅ ବଲି ପରମେସର୍‌କେ ଗୁଆରି କଲିନି । ");
INSERT INTO dso_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ତମର୍‌ ଲଗେ ଆଇବାକେ ମୁଇ ବେସି ମନ୍‍ କଲିନି । ମର୍‌ ପାଇରଇଲା ଆତ୍‌ମାର୍‌ ଦାନ୍‌ ବିସଇ ଜାନାଇବାଟାନେଅନି ତମର୍‌ ବିସ୍‌ବାସ୍‌ ଡାଟ୍‌ କରାଇବି । ");
INSERT INTO dso_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ଏଟାର୍‌ ଲାଗି ତମର୍‌ ବିସ୍‌ବାସେଅନି ମର୍‌ ବିସ୍‌ବାସ୍‌ ଡାଟ୍‌ ଅଇସି ଆରି ମର୍‌ ବିସ୍‌ବାସେଅନି ତମର୍‌ ବିସ୍‌ବାସ୍‌ ଡାଟ୍‌ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ବାଇବଇନିମନ୍‌, ତମର୍‌ ଟାନେ ଆଇବାକେ ମୁଇ ବେସି ତର୍‌ ମନ୍‍ କରିରଇଲି, ମାତର୍‌ ଦାରାବାନ୍ଦାଅଇ ଜାଇରଇଲି ଜେ ଆଜିକେ ଜାକ ଆସି ନାପାର୍‌ଲିନି । ବିନ୍‌ ବିନ୍‌ ଜାଗାର୍‌ ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ ବିତ୍‌ରେ ସୁବ୍‍କବର୍‍ ଜାନାଇକରି ମକେ ଜେତ୍‌କି ସାର୍‌ଦା ମିଲ୍‌ଲା ଆଚେ, ତମର୍‌ ଜାଗାଇ ମିସା ସେଟା କର୍‌ବାକେ ମୁଇ ମନ୍‍ କଲିନି । ");
INSERT INTO dso_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","କାଇକେବଇଲେ, ଗିରିକ୍‌ ଲକ୍‌ମନର୍‌ ପାରା ଗିଆନ୍‌ ରଇଲେ ମିସା, ମୁର୍‌କ ଲକ୍‌ ଅଇରଇଲେ ମିସା, ସିକିର‍ଇବା ଲକ୍‌ ଅଇରଇଲେ ମିସା, କି ନ ସିକିର‍ଇବା ଲକ୍‌ ଅଇରଇଲେ ମିସା, ଏ ସବୁ ଦଲର୍‌ ଲକ୍‌ମନର୍‌ ପାଇ ମର୍‌ ଦାଇତ୍‌ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ସେଟାର୍‌ ପାଇ ରମ୍‌ ଗଡର୍‌ ଲକ୍‌, ତମର୍‌ ଲଗେ ମିସା ନିମାନ୍‌ କବର୍‌ ଜାନାଇବାକେ ମୁଇ ମନ୍‌ କଲିନି । ");
INSERT INTO dso_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ସେ ସୁବ୍‌ କବର୍‌ଟାନେ ମର୍‌ ପୁରାପୁରୁନ୍‌ ଆସାଆଚେ, ସେଟା ସିଗ୍‌ ପର୍‌ତମେ ଜିଉଦି ଲକ୍‌ମନର୍‌ ପାଇ ଆରି ତାର୍‌ ପଚେ ବିସ୍‌ବାସ୍‌ କର୍‌ବା ଜିଉଦି ନଇଲା ଲକ୍‌ମନର୍‌ ପାଇ ପରମେସରର୍‌ ବଡ୍‌ ବପୁ । ");
INSERT INTO dso_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ଲକ୍‌ମନ୍‌ ପରମେସରର୍‌ ଲଗେ କେନ୍ତି ଦରମ୍‌ ଲକ୍‌ ବଲାଇ ଅଇ ପାର୍‌ବାଇ, ତାର୍‌ ଉପାଇ ତେଇ ଦେକାଇ ଦିଆଅଇଲା ଆଚେ । ଆରାମେ ଅନି ସାରାସାରିଜାକ ମୁକ୍‌ତି ପାଇବା ଗଟେକ୍‌ ମାତର୍‌ ଉପାଇ ଅଇଲାନି, ବିସ୍‌ବାସ୍‌ । ସାସ୍‌ତରର୍‌ ବାକିଅ ଇସାବେ “ଜେ ବିସ୍‌ବାସ୍‌ କରି ପରମେସରର୍‌ ମୁଆଟେ ଦରମ୍‌ ବଲାଇ ଅଇସି, ସେ ବଁଚ୍‌ସି ।” ");
INSERT INTO dso_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ଜନ୍‌ ପାପି ଲକ୍‌ମନ୍‌ ନିଜର୍‌ କାରାପ୍‌ କାମେଅନି ସତ୍‌ ବିସଇ ଅଟ୍‌କାଇବାଇ, ସେମନର୍‌ ବିରଦେ ସର୍‌ଗେଅନି ପରମେସରର୍‌ ରିସା ଦେକାଇ ଅଇସି । ");
INSERT INTO dso_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","କାଇକେବଇଲେ ପରମେସରର୍‌ ବିସଇନେଇ ଜାଇଟା ଜାନ୍‌ବାର୍‍ ରଇଲା ସେମନ୍‌ ସେଟା ଜାନ୍‌ଲାଇ ଆଚତ୍‌ । ପରମେସର୍‌ ନିଜେ ସେଟା ଦେକାଇ ଦେଲାଆଚେ । ");
INSERT INTO dso_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ପରମେସର୍‌ ଜଗତ୍‌ ତିଆର୍‌ କଲାତେଇଅନି, ତାର୍‌ ନ ଦେକାଇଅଇବା ଗୁନ୍‌ ଅଇଲାନି, ତାର୍‌ କାବାଅଇଜିବା କାମ୍‌ ଆରି ନ ସାର୍‌ବା ବପୁ । ସେ ତିଆର୍‌ କଲା ବିସଇତେଇ ସେଟା ଦେକିଅଇଲାନି । ସେଟାର୍‌ ପାଇ ସେମନ୍‌ ନାଜାନୁବଲି କଇନାପାରତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ସେମନ୍‌ ପରମେସର୍‌କେ ଜାନିକରି ମିସା ନିକ ନାମତ୍‌ ନାଇ କି ତାକେ କାଇ ବିସଇ ନେଇକରି ମିସା ଦନିଅବାଦ୍‌ ଦେଅତ୍‌ ନାଇ । ସେମନ୍‌ ଚିନ୍ତା କର୍‌ବାଟା ସବୁ କାରାପ୍‌ ଆରି ତାକର୍‌ ଚୁଚାଇ ରଇବା ମନ୍‌, ଆନ୍ଦାରେ ଆଚେ । ");
INSERT INTO dso_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ସେମନ୍‌ ନିଜ୍‌କେ ଗିଆନି ବଲି ବାବ୍‌ଲାଇନି, ମାତର୍‌ ସତଇସେ ସେମନ୍‌ ବକୁଆ । ");
INSERT INTO dso_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ସତ୍‌ ପରମେସର୍‌କେ ନ ନାମିକରି ନସିଜିବା ମୁନୁସ୍‌, ପସୁ, ଚଡଇ, ସାଁପ୍‍ପାରା ପୁତ୍‌ଲା ତିଆର୍‌ କରି ସେଟାମନ୍‌କେ ପୁଜା କଲାଇନି । ");
INSERT INTO dso_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ସେଟାର୍‌ ପାଇ ପରମେସର୍‌ ସେମନ୍‌କେ ଚାଡିଦେଲାଆଚେ, ଆରି ସେମନ୍‌ ନିଜର୍‌ ନିଜର୍‌ ମନ୍‍ କଲା କାରାପ୍‌ କାମେ ବୁଡି ରଇଲାଇନି । ସେମନ୍‌ ତାକର୍‌ ତାକର୍‌ ବିତ୍‌ରେ ଲାଜ୍‌ଅଇଜିବା ମିସାବିଡା କର୍‌ବାଟା ସଙ୍ଗଇଆଚତ୍‌ । ");
INSERT INTO dso_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ସେମନ୍‌ ପରମେସରର୍‌ ବିସଇଟାନେ ରଇବା ସତ୍‌ ବାଦୁଲେ ମିଚ୍‌ ଦାରିକରି ଆଚତ୍‌ । ସବୁବେଲେ ଡାକ୍‌ପୁଟା ପାଇବା ପରମେସର୍‌କେ ପାର୍‌ତନା ନ କରି, ତିଆର୍‌ କଲା ଦିନ୍‍ସୁମନ୍‌କେ ପାର୍‌ତନା କଲାଇନି । ସେ କାଲ୍‌ କାଲ୍‌ ଜୁଗ୍‌ ଜୁଗ୍‌ ଡାକ୍‌ପୁଟା ପାଅ ! ଆମେନ୍‌ । ");
INSERT INTO dso_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ସେମନ୍‌ ଲାଜ୍‌ଅଇଜିବା ପାପ୍‌କାମେ ବୁଡି ରଇଲାର୍‌ ପାଇ ପରମେସର୍‌ ସେମନ୍‌କେ ଚାଡି ଦେଲାଆଚେ । ତାକର୍‌ ମାଇଜିମ