﻿USE sofia;
DROP TABLE IF EXISTS sofia.dov_vpl;
CREATE TABLE dov_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dov_vpl WRITE;
INSERT INTO dov_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ibbuku lyabansiku ba Jesu Kkilisito, mwana wakwe Devidi, mwana wakwe Abbulahamu. ");
INSERT INTO dov_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abbulahamu wakali wisi wa Ayizeki, alakwe Ayizeki wisi wa Jakobu, alakwe Jakobo wisi wa Juda abakulana bakwe. ");
INSERT INTO dov_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda wakali wisi wa Pelezi a Zela kuli Tamala, Pelezi wisi Hezelani alakwe Hezelani wisi wa Lamu. ");
INSERT INTO dov_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamu wakali wisi wa Aminadabbu, Aminadabbu wisi wa Nasoni, alakwe Nasoni wisi wa Salumoni. ");
INSERT INTO dov_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salumoni wakali wisi wa Bbowazi kuli Lahabbu, Bbowazi wisi wa Obbedi kuli Lute, Obbedi wisi wa Jese. ");
INSERT INTO dov_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese wakali wisi wa Mwami Devidi Mwami, Devidi wisi wa Solomoni kuli muka Uliya. ");
INSERT INTO dov_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni wakali wisi wa Lehobbowamu, Lehobbowamu wisi wa Abbija, Abbija wisi wa Asa. ");
INSERT INTO dov_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa wakali wisi wa Jehosiafati, Jehosiafati wisi wa Jolamu, alakwe Jolamu ngusikale wa Uziya. ");
INSERT INTO dov_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya wakali wisi wa Jotamu, Jotamu wisi wa Ahazi, Ahazi wisi wa Hezekkiya. ");
INSERT INTO dov_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekkiya wakali wisi wa Manase, Manase wisi wa Amoni, alakwe Amoni wisi wa Josiya. ");
INSERT INTO dov_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiya wakali sikale wa Jekoniya antomwe abakulana bakwe kuchindi chakutolwa kubuzike ku Bbabbiloni. ");
INSERT INTO dov_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Musule lyakulonzegwa kutolwa ku Bbabbiloni, Jekoniya wakali wisi wa Sialitiyeli, Sialitiyeli wakali sikale wa Zelubbabbeli. ");
INSERT INTO dov_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubbabbeli wakali wisi wa Abbiyudi, Abbiyudi wisi wa Eliyakkimu, alakwe Eliyakkimu wisi wa Azola. ");
INSERT INTO dov_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azola wakali wisi wa Zadoki, Zadoki wisi wa Akkimu, alakwe Akkimu wisi wa Eliyudi. ");
INSERT INTO dov_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudi wakali wisi wa Eliyazali wisi wa Matani, alakwe Matani wisi wa Jakobo. ");
INSERT INTO dov_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakobo wakali wisi wa Josefa mulumi wa Meli, oyo wakazyala Jesu ooyo utegwa Kkilisito. ");
INSERT INTO dov_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Woonse mazyalani kuzwa kuli Abbulahamu kusika kuli Devidi akali mazyalane ali ikkumi aane, kuzwa kuli Devidi kusika kukulonzegwa kwabo kutolwa ku Bbabiloni mazyalane ali ikkumi aane, alimwi kuzwa kukulonzegwa kutolwa ku Bbabbiloni kusikila kuli Kkilisito mazyalane ali kkumi aane. ");
INSERT INTO dov_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kuzyalwa kwa Jesu Kkilisito kwaka chitika munzila itobela. Banyina, Meli bakatangilwakuti bakwatwe a Jozefu, pesi kabatana kuswanana, wakajanika kuti wakali mintide kumuuya uusalala. ");
INSERT INTO dov_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pesi Jozefu, mulumi wakwe, wakali mwalumi ululeme alimwi tewakayanda kumufwisya bweeme pe chaantanganana, aboobo wakayeya kumuleka chuumunizi akusiya chizuminano chabo. ");
INSERT INTO dov_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Awo mpakali kuyeeya ezi zintu, mungelo wa Mwami wakaboneka kulinguwe muchiloto, waamba kuti, “Jozefu mwana wa Devidi, utayowi pe kubweza Meli kuti abe mwanakazi wako, nkambo oyo umintidwe mulinguwe umintidwe a Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Uyozyala mwana mulombe, alimwi uyomuzika izina lyakuti ngu Jesu, nkambo uyofutula bantu bakwe kuzwa kuzibi zyabo.” ");
INSERT INTO dov_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Zyonseezi zyakachitika kuzuzikizya zyakaambwa a Mwami kwinda kubasinsiimi, wamba wati, ");
INSERT INTO dov_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Amubone, ooyo musimbi uzominta uzotumbuka mwana mulombe, mpawo izina lyakwe bazomuzika kuti ngu Imanuwele” - elyo lipandululwa kutegwa, “Leza ulandiswe. ");
INSERT INTO dov_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jozefu wakabuka kuzwa kukoona kwakwe wachita mbuli mungelo wa Mwami mbakamulayilila, mpawo wakamubweza waba mwanakazi wakwe. ");
INSERT INTO dov_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pesi takwepe nakamuziba kusika watumbuka mwana mulombe. Elyo wakamuzika izina kuti ngu Jesu. ");
INSERT INTO dov_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nikwakamana kuzyalwa kwa Jesu muBbetelehemu waku Judiya mumazuba a Mwami Helodi, balumi bayiide bazwa kujwe bakasika mu Jelusalema kabamba kuti ");
INSERT INTO dov_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ulikuli ooyo wakazyalwa kali Mwami waba Juda? Twakabona nyenyezi yakwe kujwe alimwi twaza kuzomukomba.” ");
INSERT INTO dov_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Awo Helodi Mwami nakamvwa eechi, zyakamukatazya abantu boonse mbakali abo mu Jelusalemu. ");
INSERT INTO dov_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Helodi wakabeta amwi boonse bapaizi bapati alimwi abalembi babantu, mpawo wakababuzya, “Nkukuli Kkilisito nkwayozyalilwa?” ");
INSERT INTO dov_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bakaamba kuti kulinguwe, “Mu Bbetelehemu wa Judiya, nkambo oobu mbubo mbukwakalembwa amusinsiimi, ");
INSERT INTO dov_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Pesi iwebo, Bbetelehemu, chisi cha Judiya tamuli banini pe akati kabendelezi baJuda, nkambo kuzwa kulinduwe kuyozwa uyowendelezya, uyoyembela bantu bangu Izilayeli.” ");
INSERT INTO dov_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mpawo Helodi chakusisikizya wakiita baalumi bayiide kuti abuzye kuti nchiindinzi loko inyenyezi niyakaboneka. ");
INSERT INTO dov_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wakabatuma kuBbetelehemu, wati, “kamuya mukamulangule chabusongo, mwana munini. kuti naa mwakumujana, mundetele mazembe ambebo inga ndilabola kuzomukomba. ");
INSERT INTO dov_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nibakamaninsya kumvwa Mwami, bakeenda anzila yabo, alimwi inyenyezi njibakalibwene kujwe yakabazulwida kusikila yayimikila awo mwana munini mpakalibede. ");
INSERT INTO dov_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Aboobo nibakabona inyenyezi, bakabotelwa alukondo lupati. ");
INSERT INTO dov_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bakanjila mung'anda bamubona mwana munini antomwe a Meli banyina. Bakawidaansi akumukomba. Bakavununa buvubi bwabo mpawo bamupa izipo zyangolida, tununkilizyo atwa mili. ");
INSERT INTO dov_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Leza wakabachenjezya kumaloto kuti batajokeli pe kuli Helodi, aboobo bakajoka kunyika yabo anzila imbi. ");
INSERT INTO dov_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nibakabuka akwenda, mu ngelo wa Mwami wakalibonia kuli Jozefu muchiloto wamba wati, “Buka, bweza mwana munini abanyina, uchijile ku Ijipita. Ukkale mumo kusikila ndikwambile, nkambno Helodi uyomulanguula mwana munini kuti amuzimaazye.” ");
INSERT INTO dov_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Mansiku ngawo aayo Jozefu wakabuka wamubweza mwana munini antomwe abanyina mpawo wanyampuka winka ku Ijipita. ");
INSERT INTO dov_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wakakkala nkukoko kusikila lufu lwa Helodi. Eechi chakazuzikizya eecho chakaambwa a Mwami kwiinda kumusinsiimi, “Kuzwa mu Ijipita ndamwiita mwana wangu.” ");
INSERT INTO dov_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mpawo Helodi, naakabona kuti weenwa abalumi bayiide, wakanyema kapati. Wakatumina akujaya boonse bana balombe bakali mu Bbetelehemu azisi zyoonse zizyungulukide bakaala minyaka ibiili kaziya ansi yakuzyalwa kakwendelana a chiindi mbuuli mbwakaziba kubaalumi bayiide. ");
INSERT INTO dov_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Lino chakazuzikizya chakaambwa kwiinda kumusinsiimi Jelemiya. ");
INSERT INTO dov_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ijwi lyakamvwigwa mu Lama, kulila a koomoka, Lakkeli ukwilila bana bakwe, alimwi wakkaka kumbulizigwa, nkambo tabachiwo.” ");
INSERT INTO dov_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Elyo Helodi nakaafwa, langa mungelo wa-Leza wakaboneka muchiloto kuli Jozefu mu Ijiputi akwamba kuti, ");
INSERT INTO dov_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Buka akubweza mwana a banyina akuya kunyika ya Izilayeli, nkambo abo bakalikuvwima buumi bwamwana bakafwa.” ");
INSERT INTO dov_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jozefu wakabuka, wakabweza mwana a banyina, akuboola munyika ya Izilayeli. ");
INSERT INTO dov_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pesi nakamvwa kuti Achelawusi wakali kwendelezya atala a Judiya abusena bwawisi Helodi, wakayoowa kwiinka nkuko. Nakamana kumuchenjezya Leza muchiloto, wakazwa wayakuchisi chaba Gilili ");
INSERT INTO dov_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","alimwi wakinka wakukkala mudolopo pati litegwa Nazaleta. Echi chakazuzikizigwa chakaambidwe kwinda kubasinsimi, kuti uyoyitwa kutegwa mu Nazaleta. ");
INSERT INTO dov_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mumazubayo Joni mubbabbatizyi wakasika kakambawuka munkanda yaku Judiya kawamba kuti, ");
INSERT INTO dov_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Amusanduke, nkambo Bwami bwakujulu bwaba afwifwi.” ");
INSERT INTO dov_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nkambo oyu ngonguwe iwakambwa amusinsimi Isaya kuti, “Ijwi lyayooyo uwompoolola mulusaka munkanda, Ámululamike inzila ya Mwami, muchite kuti nzila zyakwe zilulame.” ");
INSERT INTO dov_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lino Joni wakalikusama boya bwa nkamela abbanti lyachikumba muchibuno chakwe. Kulya kwakwe zyakali nsozi abuchi bwamulusaka. ");
INSERT INTO dov_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mpawo Jelusalema, Judiya yonse, azilikiti zyoonse zizyungulukide mulonga wa Jolodani zyakayinka kulinguwe. ");
INSERT INTO dov_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bakabbabbatizigwa anguwe mumulonga wa Jolodani, kabalyamba izibi zyabo. ");
INSERT INTO dov_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pesi nakabona kuti ba Falisi bayingi abasimulawu kabeza kulinguwe kuti ababbabbatizye, wakabambila kuti, “Inywe nizyalani lyabachipile, ngwani wakamuchenjezya kuchija bukali buza. ");
INSERT INTO dov_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Amuzyale michelo yelela kusanduka. ");
INSERT INTO dov_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mutayeyi kamwamba kuti akati kanu, 'Tula Abbulahamu wamataatesu. Nkambo ndamwambila kuti Leza ulakonzya kubusya bana ba Abbulahamu nikuba kuzwa kumabwe. ");
INSERT INTO dov_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kabikwa kale kaleba kumiyanda yaminsamu itazyali michelo mibotu ulagonkwa akuwalilwa mumulilo. ");
INSERT INTO dov_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ndamubbabbatizya amanzi kuti musanduke. Pesi oyo uuza musule lyangu ulenguzu kwiinda ndime, alimwi tandelede nikuba kunyampula manyatela akwe. Uyomubbabbatizya a Muuya Uusalala amulilo. ");
INSERT INTO dov_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ipanga lyakwe lilimumanza akwe kuti akukule lubuwa lwakwe akubungania witi mungánda yachiyobwedo. Pesi uyowumpa buungu amulilo kuti obo butakonzeki kubikwa anze.” ");
INSERT INTO dov_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mpawo Jesu wakasika kuzwa ku Galili akuya kumulonga wa Jolodani kuti akabbabbatizigwe a Joni. ");
INSERT INTO dov_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pesi Joni wakasyezye kumukasya, kaamba kuti, “Ndiyanda kubbabbatizigwa anduwe, ani wasika kulindime biyeni?” ");
INSERT INTO dov_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesu wakamuvwiila wati, “chizuminine lino, nkambo kulelede kuti swebo tuzuzikizye bululamiboonse. Mpawo Joni wakamuzumizya. ");
INSERT INTO dov_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nakamana kubbabbatizigwa Jesu wakazwa mpawawo mumeenda, amulange, majulu akajulilwa nguwe. Wakabona Muuya wa Leza kuuseluka ansi mbuli inziba akukkala alinguwe. ");
INSERT INTO dov_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Amulange, ijwi lyakazwa kuzwa kumajulu kalyamba kuti, “Oyu ngu Mwana wangu ngundiyandisya. Ndilabotelwa anguwe. ");
INSERT INTO dov_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mpawo Jesu wakazulwidwa a Muuya kuya munkanda kuti akasunkwe asimwaba. ");
INSERT INTO dov_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lino nakalyimya mazuba makumi aane amansiku ali makumi aane, wakaba enzala. ");
INSERT INTO dov_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sikusunka wakasika akwamba kuti kulinguwe, “kuti koli mwana wa Leza, layilila mabwe aya kuti abe chinkwa.” ");
INSERT INTO dov_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pesi Jesu wakasandula akwamba kuti kulinguwe, “Kulilembedwe kuti Muntu takoyopona achinkwa luzutu, pes ajwi lyoonse lizwa kumulomo wa Leza.” ");
INSERT INTO dov_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mpawo simwaba wakamutola kuchisi chisalala akumukkazika aatala ansonge yangánda ya Leza, ");
INSERT INTO dov_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","akwamba kuti kulinguwe, “Na koli mwana a Leza, liwalile aansi, nkambo kulilembedwe kuti uyolayilila bangelobakwe kuti bakubambe; alimwi, bayokubaka mumaanza abo, kuti utakalyumpuni abbwe.” ");
INSERT INTO dov_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu wakabambila kuti, “Alubo kulilembedwe kuti, utasunki Mwami Leza wako.” ");
INSERT INTO dov_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Alubo simwaba wakamutola kukalundu kalamfu akumutondezya Bwami boonse bwanyika abulemu bwayo bonse. ");
INSERT INTO dov_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Wakamwambila kuti, “zyonse zintu eezi ndiyokupa, kuti wandivundamina akundikomba.” ");
INSERT INTO dov_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mpawo Jesu wakamwambila kuti, zwaawa, siluuni! Nkambo kulilembedwe kuti, uyokomba Mwami Leza wako, akukutawukila nguwe luzutu.” ");
INSERT INTO dov_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mpawo simwaba wakayinka, Amubone bangelo bakaza akumukutawukila. ");
INSERT INTO dov_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lino Jesu nakamvwa kuti Joni wakaabwa wakazwa waya ku Galili. ");
INSERT INTO dov_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wakazwa mu Nazaleta akwinka kuyokkala muKkapenawuma, ilikumbali lyalwizi lwa Galili mumasena a Zebbuluni a Nafutali. ");
INSERT INTO dov_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Eezi zyakachitika kuti kuzuzikizigwe zyakaambwa amusinsiimi Isaya kuti, ");
INSERT INTO dov_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Chisi cha Zebbuluni achisi cha Nafutali kaziya kulwizi, luli kunembo lya Jolodani, Galili wabamasi! ");
INSERT INTO dov_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bantu bakalikkede mumudima babona mumuuni mupati, akulibaabo bakalikkede muchilikiti amumwenzule walufu, alimbabo kwanyamuka mumuuni.” ");
INSERT INTO dov_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuzwa kulecho chindi Jesu wakatalika kukambawuka akuti, “Amusanduke, nkambo Bwami bwakujulu bwasika afwifwi.” ");
INSERT INTO dov_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nakali kwenda ambali lyalwizi lwaGalili, wakabona bana bakwabo babili, Sayimoni utegwa Pita, a Endulo mukulana wakwe, bakali kuwala tuzamba mulwizi, nkambo bakali bazubi babaswi. ");
INSERT INTO dov_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu wakati kulimbabo, “amuze, munditobele, alimwi ndiyomuchita kuba bazubi babantu.” ");
INSERT INTO dov_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mpawawo bakasiya tuzamba bamutobela. ");
INSERT INTO dov_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesu nakali kuyabwenda kuzwa mpawawo wakabona bambi bana bakwabo babili, Jemusi mwana a Zebbedi, a Joni mukulanakwe. Bakali mubwato awisi Zebbedi kabali kusuma tuzamba twabo. Wakabayita, ");
INSERT INTO dov_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Alimwi mpawawo bakasiya bwato awisi akumutobela. ");
INSERT INTO dov_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu wakiinka mu Galili yoonse, kayobuyiisya muzikombelo, kakambawuka makani mabotu a Bwami akusilika misyobo yamalwazi amachise akali mubantu. ");
INSERT INTO dov_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Impuwo atala anguwe yakamwayika mu Siliya yoonse, alimwi bantu bakeeta boonse bakali kuchiswa misyobo-misyobo yamalwazi amachise, abaabo bakanjidwemyuuya mibi, basimasuntu, abayuminide mibili, Jesu wakabasilika. ");
INSERT INTO dov_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Makamu makamu abantu akamutobela kuzwa kuGalili, Ba Dekkapolisi, Jelusalemu, aku Judiya, akuzwa kunembo lya Jolodani. ");
INSERT INTO dov_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesu naakabona makamu makamu aabantu wakatanta aatala aachilundu. Akkale biyo, baskwiiya bakwe bakaswena kulinguwe, ");
INSERT INTO dov_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","eelyo wakabbanuna mulomo wakwe, wakabayiisya kuti, ");
INSERT INTO dov_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bali achoolwe bachete mumuuya, nkaambo bwami bwakujulu mbubwabo. ");
INSERT INTO dov_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bali achoolwe aabo balila, nkaambo bazowuuzigwa. ");
INSERT INTO dov_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bali achoolwe aabo balibombya, nkaambo bazoovuba nyika. ");
INSERT INTO dov_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bali achoolwe aabo bafwa nzala yabululami anyota yambubo, nkaambo bazookkuta. ");
INSERT INTO dov_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bali achoolwe beetelezi, nkaambo mbobonya bazooyetelelwa. ");
INSERT INTO dov_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bali achoolwe aabo basalala mumoyo, nkaambo bazoobona Leza. ");
INSERT INTO dov_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bali achoolwe basikutontozya, nkaambo bazootegwa bana ba Leza. ");
INSERT INTO dov_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bali achoolwe aabo bapenzegwa nkaambo kubululami, nkaambo bwami bwakujulu mbubwabo. ");
INSERT INTO dov_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Inywe muli achoolwe nibazoomutukila akumupenzya akumutamikizya zintu zibi zyoonse zyakubeja nkaambo kandime. ");
INSERT INTO dov_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Amukombe akusekelela, nkaambo bulumbu bwanu bwakujulu mbupati, nkaambo mbubonya oobo mbubakapenzya basinsimibakali kunembo lyanu. ");
INSERT INTO dov_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ndinywe munyo wanyika, pesi munyo kuti, wasampuka ulungwe buti tuuchikwe mulimo pesi kuswewegwa buyo akulyatawilwa abantu. ");
INSERT INTO dov_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ndinywe mumuni wanyika. Muunzi uyakidwe aatala achilundu tukonzyi kusisigwa. ");
INSERT INTO dov_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Alimwi bantu nibamunikalampi tabalibiki munsi lyalusuwo, pesi balalibika aachibikilo kuti limunikile boonse bali mung'anda. ");
INSERT INTO dov_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mbubonya oobo mumuni wanu umunike kunembo lyabantu kuti babone milimo yanu mibotu, balemeke wuso wanu ulikujulu. ");
INSERT INTO dov_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mutayeeyi kuti ndeza kuzoojaya mulawu nibaba basinsimi. Teensi kiujaya nkuzidide pe, ndizide kukulondola. ");
INSERT INTO dov_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nkaambo ndamwaambila chakusinizya kuti julu anyika zyoonse zilakonzya kumana, pesi tachikonzeki kuti kamane kabala nikaba komwe nikaba kazila komwe kamumulawu mane lumwi zintu zyoonse zikachitwe. ");
INSERT INTO dov_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","kaako umwi awumwi usotoka nikaba kanini akati kamilazyo eeyi, alimwi ulayiisya bantu mbubonya oobo, ooyo uzotegwa muniini mubwami bwakujulu, pesi umwi awumwi uyiilomya, alimwi ulayiisya ooyo uzootegwa mupati mubwami bwakujul. ");
INSERT INTO dov_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nkaambo, ndamwaambila kuti, bululami bwanu kabutayindi bululami bwabalembi abwaba Falisi, tamukanjili mubwami bwakujulu. ");
INSERT INTO dov_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","bantu bakalekale mbubakaambilwa kuti, utajayi, umwi amwumwi uujaya uleede kubetekwa. ");
INSERT INTO dov_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pesi mebo ndamwaambila kuti, umwi awumwi uukalalila munyina uleede uleelde kubetekwa. Alimwi umwi awumwi uusampawula munyina uleelede lubeta lupati, pesi umwi awumwi utukila uleelede mulilo wa Gehena. ");
INSERT INTO dov_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","kaako kuti kuli mukutuula chipo chako nkukonya ooko kunembo lyachipayiliilo, uye ukasangune kuyanzaana amunyoko, ");
INSERT INTO dov_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kosiya chipo chako kunembo lyachipayililo, akwiinka kunzila yako. Lutaanzi koyanzaana amunyoko, mpawo usike akuzootuula chipo chako. ");
INSERT INTO dov_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Fwambaana kuzuminana asinkondo nyokwe nochili aawe munzila, kuti sinkondo nyokwe atakutoli kumubetesi, alkwe mubetesi atakutoli kumupolis, alakwe mupolisa atakubiki muntolongo. ");
INSERT INTO dov_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kasimpe ndamwaambila kuti tokoozwa oomo mane ukaliye nikaba kasyaalizi ");
INSERT INTO dov_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mwakamvwa mbukwaambwa kuti, 'utachiti bumambi.' ");
INSERT INTO dov_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pesi mebo ndamwaambila kuti, umwi awumwi weemuuzya mwanakazi wamuchitya kale bumambi mumoyo wakwe. ");
INSERT INTO dov_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na liso lyako lyalulyo lyakulebya, uligwisye ulisowe nkaambo kulakubotela kuti ufwidwe chipanzi chomwe kwiinda kusowelwa mu Gehena mubili wako woonse. ");
INSERT INTO dov_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Alimwi kuti jaanza lyako lyalulyo lyakulebya, ulikosole ulisowe, nkaambo kulakubotela kuti ufwidwe chipanzi chomwe kwiinda kusowelwa mu Gehena mubili wako woonse. ");
INSERT INTO dov_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Alimwi kwakaambwa kuti, umwi awumwi uuleka mukakwe amupe lugwalo lwakulekana. ");
INSERT INTO dov_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pesi mebo ndamwaambila kuti, umwi awumwi ulekede mukakwe kutaamba kuti nkaambo kakuvuulakuluumbi, wamuchitya bumambi alimwi umwi awumwi ooyo mwanakazi uleledwe wamuchitya bumambi. ");
INSERT INTO dov_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mwakamvwa bantu bakalekale mbubakaambilwa kuti, utakombi chakubeja uchitile Jehova mbubonya oobo mbuwakakonkezya. ");
INSERT INTO dov_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mebo ndamwaambila kuti, utakonki pe nikuba bunini, nikuba kujulu nkaambo nchichuuno chabwami bwa Leza. ");
INSERT INTO dov_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nikuba kunyika nkaambo nchichuuno chamawulu aakwe, nikuba ku Jelusalemu, nkaambo ngumuunzi wamwami mupati. ");
INSERT INTO dov_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Alimwi utakonki kumutwe wako, nkaambo tokonzyi kusandula kasusu nikaba komwe kati katube na kasiye. ");
INSERT INTO dov_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kwaamba kwanu akube, Ii ii, na pe, nkaambo nzyoonse ziyungizigwa zilazwa kumubi. ");
INSERT INTO dov_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mwakamvwa mbukwakaambwa kuti, liso kuliso lino kulino, ");
INSERT INTO dov_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","mebo ndamwaambila kuti utamutontekki muntu mubi pesi muntu umwi awumwi ukuuma seya lyalulyo ");
INSERT INTO dov_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Alimwi uuli buti uyanda kukubika kaambo akunyanzya chikobela chako, mulekele achalo chibaki chako. ");
INSERT INTO dov_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Alimwi ukusungilizya kuyumuna musinzo omwe, musindikile musinzo yobile. ");
INSERT INTO dov_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Umwi awumwi ukumbila kwako umupe, mpawo umwi awumwi kukolota kwako utamufutatili pe. ");
INSERT INTO dov_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mwakamvwa mbukakaambwa kuti yanda mweenzinyokwe, pesi sinkondo nyokwe umusule. ");
INSERT INTO dov_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mebo ndamwaambila kuti amuyande basinkonyokwe mubakombele bamupenzya, ");
INSERT INTO dov_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","kuti mube bana bakwe uso wanu uli kujulu nkaambo ulapusuzya zuba lyakwe kubabi akubabotu, ulawisizya mvulakuli boonse baluleme abataluleme. ");
INSERT INTO dov_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kuti kamuyanda aabo bamuyanda ino mbulumbuunzi mbumujisi? sa abalo basimutelo tabachiti mbubonya oobo? ");
INSERT INTO dov_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na mwazuminina bakwanu, muchita buti ziinda kulibamwi? Sena abalabo bamasi tabachiti mbubonya? ");
INSERT INTO dov_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nkaambo kaako amulondoke mbuli uso wanu uli kujuliu mbwalondokede ");
INSERT INTO dov_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Amuchenjele kuti mutachiti milimo yanu iluleme kumeso abantu kuti mwebelwe ambabo. Mwachita obo, tamukwe bulumbu kuli Uuso wanu uulikujulu. ");
INSERT INTO dov_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nkambo kaako chindi nchowabila bantu izipo utasibi imwembo kubusyu bwabo mbuli mbubachita basikuupawupa ameso muzikombelo amumigwagwa, kuti batembawulwe kubantu. Nchobeni ndamwambila kuti balijene kale bulumbu bwabo. ");
INSERT INTO dov_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pesi webo, ichindi nchowabila bantu zipo ijanza lyako lyakululyo litazibi mbulichita lyakuchimwensi. ");
INSERT INTO dov_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kuti zipo zyako zibe kumbali, lino Uuso ubonena kumbali uzokulumbula. ");
INSERT INTO dov_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Alimwi chindi nchomukomba mutabi mbuli basikupawupa amenso nkambo balayanda kukomba bwimvwi muzikombelo amuzyooko zyamigwagwa mipati kuti babonwe kubantu. Nchobeni ndamwambila kuti balijene kale bulumbu bwabo. ");
INSERT INTO dov_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Iwebo chindi nchokomba njila muchimpetu chako ulijalile kumulyango ukkombe kuli Uuso uubonena kumbali uzokulumbula. ");
INSERT INTO dov_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Alimwi mukukomba kwenu mutayindululi mbuli mbubachita bamaasi, nkambo balayeya kuti balaswililwa kukubwanta kwabo. ");
INSERT INTO dov_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nkinkaako, mutakozyani abo nkambo Uuso wanu ulikujulu ulizi zintu zyonse nzimubula kamutana kumubuzya ");
INSERT INTO dov_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","mbuboobu mbumwelede kukomba: 'Taata wesu ooli kujulu, alilemekwe izina lyako, abuze bwami bwako. ");
INSERT INTO dov_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aluchitwe luyando lwako, ansi aano mbubonya mbuli kujulu. ");
INSERT INTO dov_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Utupe sunu zilyo zitwelede. ");
INSERT INTO dov_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Utulekelele milandu yesu, mbubonya mbuli mbutu balakelela aswe bali amilandu kuli ndiswe. ");
INSERT INTO dov_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Utatwenzyi mukutempawulwa. Utuvune kumubi, nkambo bwami mbubwako anguzu, abulemu, mane kukabe kutamani. Ameni. ");
INSERT INTO dov_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nkambo mwalekelela bantu milandu yabo alakwe Uusowanu ulikujulu ulamulekelela anywebo. ");
INSERT INTO dov_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pele mwatabalekelela bantu milandu yabo anywebo tamukoyolekelelwa. ");
INSERT INTO dov_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Alimwi chindi nchomulyiimya kulya mutabi mbuli basikuwupawupa amenso, nkambo balo balawungumana, balabisya masyu aabo, kuti baboneke kubantu mbubalyimya kulya. Nchobeni ndamwambila kuti balijene kale bulumbu bwabo. ");
INSERT INTO dov_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pele chiindi ncholyimya kulya webo, ubotye mutwe wako akusamba kumenso aako. ");
INSERT INTO dov_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kuti kulyiimya kwako kutaboneki kubantu pele kuli Uuso uuli kumbali lino Uuso uubonena kumbali uzokulumbula. ");
INSERT INTO dov_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mutaliyobwedi lubono aansi ano mpaabisya mapempe ankalaya ababbi mpobatulula kuti babbe. ");
INSERT INTO dov_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amuliyobwede lubono lwakujulu nkwatabisyi mapempe ankalaya, ababbi nkubatatululi kuti babbe. ");
INSERT INTO dov_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nkambo lubono lwako nkulubede nkukonya oko nkubede moyo wako. ");
INSERT INTO dov_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ilampi lyamubili ndinso nkambo kaako linso lyako kuti kalili sibuuya mubili wako woonse ulazula mumuni. ");
INSERT INTO dov_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Anukuti linso lyako kalili abutavu mubili wako woonse lino mumuni mulinduwe wakali mudima. Mudima wayo ulasiya mbi. ");
INSERT INTO dov_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Takwe muntu ukonzya kumanina baami bobile milimo nkambo ulasula umwi ulayanda umwi na ulakakilila umwi akusampawula umwi. Tamukonzyi kubelekela Leza antomwe alubono. ");
INSERT INTO dov_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nkambo kaako ndamwambila kuti, mutalibilikili kubuumi bwanu kuti tukalyeenzi? Nikuba kumibili yenu kuti, tukasamenzi? Buumi bwenu tabwiindi zilyo awalo mubili sa tuyindi zyakusama? ");
INSERT INTO dov_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Amulange bayuni bakujulu nkambo tababyali tabatebuli, tabayoboli mumatala, nekuba boobo Uusowanu ulikujulu ulabasanina. Sa inywe tamuyandiki kwinda mbabo? ");
INSERT INTO dov_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ngwani akati kenu ulibilika ukonzya kukomezya chiimo chakwe nikuba kakokola komwe? ");
INSERT INTO dov_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Alimwi nkamboonzi mulalibilikila zyakusama? Amuyeye masamu amusokwe mbwamena, tabeleki, takonzyi kuluka, ");
INSERT INTO dov_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","pele ndamwambila kuti naba Solomoni mubulemu bwakwe boonse takakonzya kusama mbuli limwi akati kanzizyo. ");
INSERT INTO dov_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lino kuti Leza kasamika boobo maani amusokwe, aaliko sunu pele ijunza alasowelwa muchikko, sa takayindi loko kumusamika anywebo nobasilusyomo lunini. ");
INSERT INTO dov_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nkambo kaako mutalibiliki akaamba kuti tukalyeenzi? Tukanyweenzi? Tukasamenzi?' ");
INSERT INTO dov_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nkambo kazeezi zyoonseni nzibayandula bamaasi, alimwi Uusowanu ulikujulu ulizi kuti eezi zyonse zilayandwa kulindinywe. ");
INSERT INTO dov_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pele amusangune kuyandula bwami bwa Leza abululami bwakwe eelyo zintu ezi zyoonse mulaziyungizizigwa azyalo. ");
INSERT INTO dov_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nkambo kaako mutalibilikili zyejunza, nkambo bwejunza bula lilibilikila bwini. Buzuba bwasunu bulizulide mapenzi abo bwalo. ");
INSERT INTO dov_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mutabeteki, nkambo muzobetekwa. ");
INSERT INTO dov_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Alubeta ndomutakabeteke alo muyobetekwa aandulo, achelesyo nchimuyoyelesya, muyokuyelesezegwa anchicho. ");
INSERT INTO dov_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nkambonzi nulanga katanda kali mulinso lyamukulana wako, pele wasiya itanda lili mulinso lyako? ");
INSERT INTO dov_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chilakonzeka na kuti utedi kumukulana, leka ndikugusye katanda kali mulinso lyako; kakuli tanda mulinso lyako? ");
INSERT INTO dov_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Inywe nobasikuupaupa! Tanguna kugusya itanda lilimulinso lyako, alubo ulakonzya kubona kabotu katanda kalimulinso lyamukulana wako. ");
INSERT INTO dov_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mutapi zisalala kubankala, alubo mutasoweli zibi kumpela angulube. Ulabona zyalyatuulwa aansi amawulu, alubo zilasanduka akumudabula mutu fwapufwapu. ");
INSERT INTO dov_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Amukumbile, alubo muyopegwa. Amuyandawule, mulajana. Amukonkomone mulajulilwa. ");
INSERT INTO dov_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nkambo umwi awumwi ukumbila ulatambula, alakwe uyanduula ulajana alakwe uukonkomona ulajulilwa. ");
INSERT INTO dov_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nguli muntu akati kenu uupa mwanaakwe ibbwe, amukumbila insima? ");
INSERT INTO dov_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Alimwi, kuti wakumbila imuswi, sa ulamupa inzoka? ");
INSERT INTO dov_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Lino mbuli bmumuzi kupa bana benu zintu zibotu, inywe nobabi, alakwe Wuso wenu ulikujulu sa tazoyindi loko kupa zintu zibotu kulibaabo bamukumbila? ");
INSERT INTO dov_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nkaambo kaako zintu zyoonse zili buti nzimuyanda kuti bantu bamuchitile, anywebo amubachitile nzizyoonya, nkambo mbuboobo mbuwamba mulawo abasinsimi. ");
INSERT INTO dov_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Amunjile mumulyango umanikide, nkambo mulyango ukwazamukide anzila impati njiitola kukunyoonyoka, nkabela abo banjila mulinjiyo mbanji banji. ");
INSERT INTO dov_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pesi mulyango umanikide anzila ipatide njiitola kubuumi, nkabela abo banjila mbache. ");
INSERT INTO dov_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Amuchenjelele basinsimi babeji beeza kulindinywe basamide zyakusama zyambelele, anukuti mukati lyabo mbawumpe babutambo. ");
INSERT INTO dov_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Michelo yabo njiiti muzibye mbubabede. Sa kulachelwa masansa kumuunga niziba inkuyu kumutubatuba? ");
INSERT INTO dov_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Mbubonya obo musamu umwi awumwi mubotu ulazyala michelo mibotu, alimwi musamu usampawukide ulazyala michelo mibi. ");
INSERT INTO dov_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Musamu mubotu tukonzyi kuzyala michelo mibi, alimwi musamu usampawukide tukonzyi kuzyala michelo mibotu, ");
INSERT INTO dov_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Musamu umwi awumwi utazyali michelo mibotu ulatemwa akusowelwa mumulilo. ");
INSERT INTO dov_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aboobo michelo yabo njita muzibye mbubabede. ");
INSERT INTO dov_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Boonse bandambila kuti, Mwami, Mwami, teensi mbabo bayonjila mubwami bwakujulu, ngooyo uuchita luyando lwa-Taata uli kujulu. ");
INSERT INTO dov_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kubuzuba obo banji banji bayondambila njako alimwi sa teensi kuzina lyako nkutwakatanda madayimona Sa teensi kuzina lyako nkotwakachita milimo mipati myiingi?' ");
INSERT INTO dov_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Lino nzobaambila kuti, nsimuzi pe, amuzwe kulindime inywe nubamuchita zibi!' ");
INSERT INTO dov_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nkambo kaako umwi awumwi uuswilila majwi aangu aya akwachita uzokozyanisigwa amuntu uchenjede iwakayaka ing'anda yakwe atala amwaala. ");
INSERT INTO dov_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lino imvula yakawa nyingi, milonga yakeeta, amyuuwo yakawunga, yakawuma ang'anda eyo, nekuba boobo teyakawa pe, nkambo yakatalikilidwe aamwala. ");
INSERT INTO dov_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pele umwi awumwi uuswilila majwi aangu aya akutachita uzokozyanisigwa amuntu mufuba fuba iwakayaka ing'anda yakwe amusele, ");
INSERT INTO dov_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","lino niyakawa imvula milonga yakeeta, myuuwo yakawunga, yakawuma ang'anda eyo, elyo yakawa, nkabela buwe bwayo bwakakomena. ");
INSERT INTO dov_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lino Jesu nakamana kwamba majwi aya oonse, makamu makamu abantu aka kankabala kukuyiisya kwakwe, ");
INSERT INTO dov_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","nkambo wakali kubayiisya chabwami kutakozyenie abalembi babo pe. ");
INSERT INTO dov_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Chiindi Jesu nakaseluka kuzwa muchilundu makamu mingi akamutobela. ");
INSERT INTO dov_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Eelyo, sichinsenda wakasika kulinguwe alimw wakamufugamina, wakati, “Mwami na kuzumina ulakonzya kundisalazya. ");
INSERT INTO dov_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesu wakatambika kuboko kwakwe alimwi wakamwampa, wakati, “Ndilazumina. Salala.” Mpawawo wakasalazigwa kuchipele. ");
INSERT INTO dov_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesu wakati kulinguwe, “Utakambili muntu naba umwi” Ulitondezye kumupayizi, alimwi ukape chipo kuli Mozesi nchakakulayilila, kuti bukabe bukamboni kulimbabo.” ");
INSERT INTO dov_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Awo Jesu nakanjila mu Kapenawuma, silutwe wempi wakaza kulinguwe, wakamulombela. ");
INSERT INTO dov_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","alimwi wakati, “Mwami, mubelesi wangu ulilede kungánda, uliyuminide akumvwa machise mapati.” ");
INSERT INTO dov_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu wakati kulinguwe, “Ndilasika alimwi ndizomuponye.” ");
INSERT INTO dov_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Silutwe wankamu wakasandula alimwi wakati, “Mwami, tandeelede kuti unjile mungánda yangu pesi amba ijwi alimwi mubelesi ulapona. ");
INSERT INTO dov_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngambulindime lubo ndili muntu usalidwe mubwendelezi, alimwi ndilabasilumamba balimunsi lyangu. Ngandati kuloyu, 'Koya' alimwi ulenda, alimwi akulumwi, ngandati, 'Sika' alimwi ngawaza, akulumbi mubelesi, ngandati, 'chita echi; alimwi ulachichita.” ");
INSERT INTO dov_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chindi Jesu nakamvwa ezi, wakagamba alimwi wakati kuli abo bakali kumutobela, “Nchobeni ndamwambila kuti takwe pe ngundakali ndajana ulalusyomo luli obu mu Izilayeli. ");
INSERT INTO dov_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ndamwambila, bingi bayozwa kumbo alimwi akujwe, alimwi bayolya atebuli a Abbulahamu, Ayizeki, a Jakobo, mubwami bwakujulu. ");
INSERT INTO dov_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pesi baana babaami bayotandilwa anze mumudima, chindi nikunoli kulila akuluma ntwino.” ");
INSERT INTO dov_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesu wakati kulinguwe, “Enda! mbuli mbuwasyoma, aboobo achichitwe kulinduwe.” Alimwi mubelesi wakapona mu hola ndilelyo. ");
INSERT INTO dov_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chindi Jesu nakasika mungánda ya Pita, wakabona banyinazyala a Pita kabachisidwe ntuntumanzi. ");
INSERT INTO dov_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesu wakajata kuboko kwabo, mpawo ntuntumanzi yakamana mpawo bakabuka alimwi bakatalika kumukutawukila. ");
INSERT INTO dov_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Elyo nikwakaba mangolezya bantu bakamwetela Jesu bakanjidwe amadimoni. Wakitanda myuuya mibi ajwi alimwi wakaponisya boonse bakali kuchiswa. ");
INSERT INTO dov_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Munzila eyi zyakazuzikizigwa ezyo zyakambidwe amusinsimi Isaya, wakati, “Nguwelwakwe ubweza machise esu akunyampula malwazi esu oonse.” ");
INSERT INTO dov_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lino Jesu nakabona makamu kamuzyungulukide, wakabalayilila kuti bazubukile mutala eliya lyalwizi lwa Galilaya. ");
INSERT INTO dov_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mpoonyawo mulembi wakasika kulinguwe alimwi wakati, “Mwiiyi, Ndiyokutobela kufumbwa nkoya.” ");
INSERT INTO dov_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu wakati kulinguwe, “Bamwaba balijisi mapako, alimwi tuyuni twakujulu tulazizumbo, pesi Mwana a Muntu takwe ampalazika mutwe wakwe.” ");
INSERT INTO dov_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Umwi wabasikwiiya wakati kulinguwe, “Mwami, ndizumizye saansi kuti njiinke alimwi ndikavwikke ndeende.” ");
INSERT INTO dov_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pesi Jesu wakati kulinguwe, “Nditobele alimwi usiye bafwide bazikkane lwabo.” ");
INSERT INTO dov_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lino Jesu nakanjila mubwato, basikwiya bakwe bakamutobela alimwi. ");
INSERT INTO dov_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Elyo kwakaba iguwo ipati mulwizi, lumwi bwato bwavumbwa amayuwe. Pesi Jesu wakali winkilila koona. ");
INSERT INTO dov_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Basikwiya bakaza kulinguwe alimwi bakamubusya, bakati, “Tugwasye, Mwami; twamba kumana kufwa!” ");
INSERT INTO dov_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu wakati kulimbabo, “Nkamboonzi nomuyowa, inywe nobalusyomo lunini? Mpawo wakabuka alimwi wakawumuzya iguwo alimwi alwizi. Mpoonya kwakaba kumuuna kupati. ");
INSERT INTO dov_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bantu bakagamba alimwi bakati, “musyobonzi wamuntu ulibobu, kuti nikuba iguwo alimwi alwizi zilamulemeka?” ");
INSERT INTO dov_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lino Jesu nakasika kulubazu lumbi alimwi kubantu bakkala kuchisi chitegwa Gadala bantu babili bakanjidwe madimoni bakaswanana anguwe. Bakali kuzwa kuzibunda alimwi bakali abukali alubo tebakali kuyanda muntu winda munzila eyo. ");
INSERT INTO dov_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Elyo, bakoompolola bakati, “uyandaanzi kulindiswe Mwana wa Leza? Wasika okuno kuti uzotufwabye nkachitanasika chiindi chibambidwe. ");
INSERT INTO dov_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Lino sikwembela wabutanga bwangulube wakaliwo kalikucheezya, katali kule loko ambabo. ");
INSERT INTO dov_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Madimoni akaliswini kukombelezya Jesu alimwi kati, 'Na watutanda, tutumine kubutanga bwangulube.” ");
INSERT INTO dov_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu wakati kulimbabo, “Kamuya! Madimoni akazwa akiya mungulube, alimwi zyoonse ngulube zyakafwambana kukunkulikila mujenga zyanjila akufwida mumanzi. ");
INSERT INTO dov_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abo bakali kwembela butanga bwengulube bakachija alimwi bakaya mudolopo alimwi bakamba zyoonse, kapati loko azyakachitika kumuntu wakanjidwe dimoni. ");
INSERT INTO dov_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mpawo, Lyoonse dolopo lyakasika kuti baswanane a Jesu. Nibakamubona bakamukombelezya kuti azwe muchisi chabo. ");
INSERT INTO dov_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu nakanjila mubwaato, wakazubuka, alimwi wakasika kudolopo lyakulimbaabo. ");
INSERT INTO dov_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Amubone, bata kulinguwe muntu ulebukide kaleede aabulo. Nakabona lusyomo lwabo, Jesu wakati kumuntu ulebukide, “Mwana mulombe, sungwazigwa zibi zyako zyalekelelwa.” ");
INSERT INTO dov_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Amubone, bamwi balembi bakati kulilwabo beni,” “Imuntu oyu ulatukila.” ");
INSERT INTO dov_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nkabela Jesu wakaziba miyeeyo yabo, elyo wakati, “Nkambonzi nimuyeeya buubi mumyoyo yenu? ");
INSERT INTO dov_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nkambo nchichili chuuba kwamba kuti, Ízibi zyanu zyalakelelwa, na kwamba kuti, Nyampuka alimwi uyende'? Pesi mulelede kuziba kuti Mwana a Muntu ulanguzu ansi zyakulekelela izibi,...”Nyampuka, bweeza bulo bwako, ");
INSERT INTO dov_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","alimwi uyinke kungánda yako” Mpawo mwalumi wakanyampuka alimwi wakeenda kungánda yakwe.” ");
INSERT INTO dov_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mpawo mwalumi wakanyampuka alimwi wakeenda kungánda yakwe. ");
INSERT INTO dov_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chiindi makamu makamu nakabona eechi, bakayoowa alimwi bakatalika kulumbayizya Leza, wakapede inguzu ziliboobu kubantu. ");
INSERT INTO dov_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mbubonya Jesu nakayinda kuzwa awo, wakabona mwalumi utegwa Mateyo kakkede aziyako zyabasimutelo wasikuti kulinguwe, “Nditobela.” Wakanyampuka alimwi wakamutobela. ");
INSERT INTO dov_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mbubonya Jesu wakakkala ansi kuti alye mungánda, amubone, basimutelo biingi abasizibi bakasika alimwi bakasusula a Jesu abasikwiiya bakwe. ");
INSERT INTO dov_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lino baFalisi nibakachibona echi bakati kuli basikwiya bakwe, “Nkambonzi muyisi wenu ulalya abasimutelo alimwi abasizibi?” ");
INSERT INTO dov_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Eelyo Jesu nakamvwa echi, wakati, bantu basimide mubili tabayandi musilisi, pesi abo bachisidwe. ");
INSERT INTO dov_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mulelede kwinka akuyoyiiya kuti ezi zyambayi. Ndilombozya luzyalo alimwi zitali zipayizyo.' Mbulikuti ndakasika, kuti nditazoyiti balulami kuti musanduke, pesi basizibi.” ");
INSERT INTO dov_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Eelyo basikwiya ba John bakasika kulinguwe alimwi bakati, “Nkambonzi iswe antomwe abaFalisi nitulyiimya, pesi basikwiya bako tabalyiimyi pe?” ");
INSERT INTO dov_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu wakati kuli mbabo, “Ani bana basimusa balakonzya na kulila nibachili asibwinga? Pesi mazuba ayosika elyo sibwinga nayobwezegwa kuzwa kuli mbabo, alimwi bayolyimya. ");
INSERT INTO dov_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Takwe muntu ubika chisamo chipya atala a jansi kkulukulu, nkambo chigamba chiladeluka kuzwa kujansi, alimwi ibbanga elyo lilayindilila kukomena. ");
INSERT INTO dov_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nekuba kuti bantu babika wayini mupya muzibikilo zikulukulu zyewayini. Na bachita boobo zibikilo zilakwamuka. Wayini ulatika alimwi zibikilo zyawayini zilanyonyonwa. Anukuti, babika wayini mupya muchibikilo chipya cha wayini, alimwi zyoonse zilalondokeka.” ");
INSERT INTO dov_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Alimwi Jesu nakali kwamba eezi kulimbabo, amubone, mwendelezi wakasika alimwi wakkkotama aansi kulinguwe wakati, “Mwana wangu musimbi wafwa lino, pesi sika alimwi uzobike ijanza lyako alinguwe, alimwi uyopona.” ");
INSERT INTO dov_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Mpawo Jesu wakabuka akumutobela, alimwi mbubakachita basikwiiya bakwe. ");
INSERT INTO dov_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Amubone, mwanakazi wakali kufwabisigwa akalobola kwaminyaka ili kkumi ayibili wakeza musule lya Jesu alimwi wakajata moombe wejansi lyakwe. ");
INSERT INTO dov_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Nkambo wakali walyambila lwakwe mwini, “kuti na nkajate chisamo, ndiyopona.” ");
INSERT INTO dov_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pesi Jesu wakachebuka mpawo wakamubona, alimwi wakati, “Musimbi, koba mukozu, lusyomo lwako lwakuponya. Mpawo mwanakazi wakapona muchindi ncicheecho. ");
INSERT INTO dov_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chiindi Jesu nakeza kungánda yamwendelezi, wakabona bakali kusobana mutetele alimwi makamu makamu akali kuyowela. ");
INSERT INTO dov_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wakati, “Muzwe awa, nkambo musimbi tafwide pe, pesi ulilede. “Pesi bakamuseka chakumuniaka. ");
INSERT INTO dov_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kuchindi makamu nakazwa anze, wakanjila mungánda alimwi wakamubweza akuboko, alimwi musimbi wakanyampuka. ");
INSERT INTO dov_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Makani atala azezi akazulila munyika yoonse. ");
INSERT INTO dov_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mbubonya Jesu nakayinda kuzwa oko, bantu babili boofu bakamutobela. Bakali koompolola alimwi kabati, “Tufwide luzyalo Mwana wa Devidi. ");
INSERT INTO dov_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Chiindi Jesu nakeza mungánda. bantu boofu bakasika kulinguwe. Jesu wakati kuli mbabo, mulasyoma na kuti nga ndilachichita eechi? Bakati kuli nguwe, “Iyii, Mwami.” ");
INSERT INTO dov_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mpawo Jesu wakajata menso abo akwamba kuti, “achichitike kulindinywe mbuli lusyomo lwenu,” ");
INSERT INTO dov_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","alimwi meso abo akajulika. Mpawo Jesu wakabalayilila akwamba kuti, “mubone kuti takwe uumbi utakazibe atala azezi.” ");
INSERT INTO dov_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pesi bantu babili bakeenda biinka alimwi makani akakuzulila munyika yoonse. ");
INSERT INTO dov_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mbubnya bantu abo babili nibakayobwenda, muntu uutambuli kazwide muuya wadimoni wakeetwa kuli Jesu. ");
INSERT INTO dov_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Dimoni nilyakagwisigwa, muntu utaambuli wakaambula. Makamu makamu akagamba, akaamba kuti, “eezi tazinakuboneka mu Izilayeli!” ");
INSERT INTO dov_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pesi ba Falisi bakali kuti, “Mubwendelezi bulama dimoni, ulagwisya dimoni.” ");
INSERT INTO dov_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu wakenda kumadolopo woonse akumagunzi wakendelela anembo kayobuyiisya muzikombelo zyabo kakambawuka makani mabotu abwami, akuyobuponia zilwazi zyonse zyamisyobo misyobo amachise woonse amisyobo misyobo. ");
INSERT INTO dov_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lino nakabona makamu makamu, wakaba aluzyalo kuli mbabo, nkambo bakali kupeekezezegwa akunyansigwa. Bakali mbuli mbelele zitakwe mweembeli. ");
INSERT INTO dov_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wakati kuli basikwiiya bakwe, “Butebuzi bwavula, pesi batebuzi mbache. ");
INSERT INTO dov_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nkabela amukombe chakufwambana ku Mwami wabutebuzi, kuchitila kuti atuume batebuzi mubutebuzi bwakwe. ");
INSERT INTO dov_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu wakayita basikwiiya bakwe boonse ibali kkumi ababili alimwi wabapa inguzu aatala amyuuya mibi, kuti bayitande. Akuponia zilwazi zyamisyobo isiyene amachise amisyobo isiyene. ");
INSERT INTO dov_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Lino mazina abatumwa balikkumi ababili ngaya. Wakusanguna, Sayimoni (oyo ngwakiita kuti Pita), a Endulo mukulana; Jemusi mwana wa Zebbedi, a Joni mukulana wakwe; ");
INSERT INTO dov_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipu, a Bbatolomyu; Tomasi, a Mateyo simutelo; Jemusi mwana wa Alufiyasi, a Tediyasi; ");
INSERT INTO dov_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sayimoni mu Ziloti, a Judasi Sikaliyoti, oyo wakali sikuyomwaba. ");
INSERT INTO dov_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aaba bali kkumi ababili Jesu mbakatuma wakabalayilila akwamba kuti, “Mutakayinki kunyoika kukkala bamaasi alimwi mutakanjili kufumbwa dolopo lyaba Samaliya. ");
INSERT INTO dov_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kamuya kumbelele ziswekede zyang'anda ya Izilayeli. ");
INSERT INTO dov_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Alimwi nimuyoyinka, mukakambawuke akwamba kuti, “Bwami bwakujulu bwaba afwifwi. ");
INSERT INTO dov_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mukaponie bachiswa, mukabusye bafwide, musanzye basizinsenda, akuyotanda madimoni. Mwatambula kakutakwe muliyo, anywebo amukape katakwe muliyo. ");
INSERT INTO dov_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mutakabwezi ingolida, nsiliva, nikuba kkopa muzibbeeke zyenu. ");
INSERT INTO dov_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mutakabwezi zibbeeke zyamulwendo mukwenda kwenu, nikuba zibaki zibili na insangu, na inkoli, nkambo simulimu uyolijanina chakulya. ");
INSERT INTO dov_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kufumbwa muunzi ngumuyonjila, mukalange kuti ngwani uyelede, kuti mukkale alinguwe manedo mukeende. ");
INSERT INTO dov_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mbubonya mwakunjila mung'anda, mukiijuzye. ");
INSERT INTO dov_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kuti ing'anda kiyelela, akube kuti luumuno lwenu lukabe mulinjiyo. Pele na kitelede lumuno, luumuno lwenu ngalubwede kulindinywe. ");
INSERT INTO dov_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kuli abo batakabule kumutambula nikuba kumutelela kumajwi enu, nimutakazwe mung'anda na mudolopo, mukakunkumune lusuko kumawulu enu. ");
INSERT INTO dov_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nchooncyo ndamwambila kuti, kuyoba kulansya moyo kunyika ye Sodomu a Gomola mubuzuba bwalubeta kwinda kwamudolopo elyo. ");
INSERT INTO dov_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Amulange, Ndamutuma mbuli imbelele akati kabawumpe, nkenkaako amuchenjele mbuli inzoka alimwi mube basalali mbuli inziba. ");
INSERT INTO dov_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Amukabalangisisye bantu! bayomutola kumbeta alimwi bayomutanda muzikombelo zyabo. ");
INSERT INTO dov_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mpoonya bayomweta kunembo lyabendelezi akubaami nkambo kangu, bukabe bukamboni kuli mbabo akuli bamaasi. ");
INSERT INTO dov_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kuchindi nibayomujata akumwaba, mutakalikatazyi kuti mbobuli nakuti tuyowambula katutyeni, nkambo izyakuyowamba muyozipegwa nywebo muchiindi echo. ");
INSERT INTO dov_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nkambo teensi ndinywe nimuyowambula, pesi kuti Muuya wa Wuso ngutakaambule mulindinywe. ");
INSERT INTO dov_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mukwesu uyowaba munyina kulufu, alimwi wisi uyowaba mwana. Bana bayobukila bazyali baabo alimwi akuchita kuti bajayigwe. ");
INSERT INTO dov_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Muyosuligwa abantu boonse akambo kezina lyangu. Pesi oyo ukakatila kuyosika kumamanino, imuntu oyo uyofutulwa. ");
INSERT INTO dov_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chindi nibayomupenzya mudolopo elyo, mukachijile kuli liimbi, nkambo zyamasimpe ndamwambila, tamukoyo yenda mukati kamadolopo a Izilayeli Mwana a Muntu katanakusika. ");
INSERT INTO dov_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sikwiiya temupati kwiinda muyiisyi wakwe, nikuba mulanda talimupati kwiinda simalelo wakwe. ");
INSERT INTO dov_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Zilelede mbuli sikwiiya kuti aabe mbuli muyiisyi, alimwi mulanda mbuli simalelo wakwe. Na bayita mulanda wang'anda ya Bbeluzebbulu, zilaba kazyindilila byeni mbuli mazina ngibayita bamwi babeleki bang'anda yakwe! ");
INSERT INTO dov_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nkinkakako mutakabayoowi, mbulikuti takwe chisisikene chitakaleke kuzwa entanganana alimwi takwe chisisikene chitakaleke kuyozibinkana. ");
INSERT INTO dov_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nzendikumubuzya mumudima, muzyambe mumumuuni, alimwi nzimumvwa kanonono mumatwi enu, mukaziluule aziluli zyamaanda. ");
INSERT INTO dov_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mutayoowi abo bajaya, mibili pesi kabakachilwa kujaya muuya. Anukuti mwelede kuyowa oyo ukonzya kujaya muuya a nyama mugehena. ");
INSERT INTO dov_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sena tuyuni tobile tatuulwi a kkobili? Takwe naba omwe wabo uuwa aansi katakwe luzibo lwa Wuso. ");
INSERT INTO dov_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pesi nikuba masusu mumutwe yenu woonse alibalidwe. ");
INSERT INTO dov_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mutayowi. Mulayandika kwinda tuyuni twiingi. ");
INSERT INTO dov_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nkinkakako kuliwoonse ulisola kulindime kunembo lyabantu, andime ndiyolisola kuli Taata ulikujulu. ");
INSERT INTO dov_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pesi oyo undikkaka kunembo lyabantu, Ambebo ndiyomukkaka kunembo lya Taata uli kujulu. ");
INSERT INTO dov_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mutayeeyi kuti ndakeza kuzoyeta lumuno ansi aano. Tindakazida kuzoyeta luumuno, pesi ikafulo. ");
INSERT INTO dov_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mbulikuti ndakazida kuzokazyanisya mwana awisi, alakwe mwana musimbi abanyina, alakwe mukamwana abanyinazyala. ");
INSERT INTO dov_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nkabela basinkondonyina bamwalumi mbimbabo beng'anda yakwe. ");
INSERT INTO dov_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Oyo uyanda wisi na banyina kwinda ndimeteelede kulindime, oyo uyanda mwanakwe mulombe na musimbi kwinda ndime teelede kulindime. ");
INSERT INTO dov_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Oyo utabwezi chiingano chakwe alimwi atobelele musule lyangu telede kulindime. ");
INSERT INTO dov_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Oyo uyanda buumi bwakwe uyobuswekelwa. Pesi oyo uswekelwa buumi bwakwe akambo kangu uyobujana. ");
INSERT INTO dov_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Oyo ukutambula utambula ndime, alimwi oyo unditambula alimwi watambula ayoyo iwakandituma. ");
INSERT INTO dov_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Oyo utambula musinsimi muzina lyamusinsiimi uyojana mpindu yamusinsiimi, alimwi oyo utambula bululami bwamuntu muzina lyabululami bwamuntu uyojana mpindu yabululami bwamuntu. ");
INSERT INTO dov_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kufumbwa uupa kulumwi wabaaba banini, nikaba kanywido kamaanzi atontola kuti banywe, nkambo ngusikwiiya, chamasimpe ndamwambila, takwepe nayobula impindu yakwe.” ");
INSERT INTO dov_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nichakaba kuti Jesu wamaninsya kulayilila basikwiya bakwe balikkumi ababili, wakazwa nkukonya oko wakuyisya akukambawuka mumadolopo aabo. ");
INSERT INTO dov_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lino Joni nakamvwa muntolongo atala anchito zya Kkilisito, wakatuma basikwiya bakwe ");
INSERT INTO dov_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ajwi elyo bakati kulinguwe, “Nduwe na ulokuza, na kuti tuchilangilila uumbi?” ");
INSERT INTO dov_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu wakasandula akwamba kulimbabo, “Mwinke mukaambe kuli Joni nzimwabona akumvwa. ");
INSERT INTO dov_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bataboni balikutambula kubona, zilema zilenda, balezipele balokusalazigwa, batamvwi balokumvwa lubo, bafwide balokubusigwa lubo kubawumi, amakani mabotu alokukambawukwa kubachete. ");
INSERT INTO dov_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Alubo ngusicholwe kufumbwa utabilizigwi andime.” ");
INSERT INTO dov_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lino aba bantu nibakeenda munzila yabo Jesu wakatalika kwamba kumakamu atala a Joni, “Mwakayinka kuya kunkanda kuyobonanzi - ityetye lizunganisigwa aguuwo? ");
INSERT INTO dov_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pesi mwakayinka kuya kuyobonanzi - muntu usamide ziteete? Mbukubede, abo basama zisamo ziteetete bakkala mumaanda abami. ");
INSERT INTO dov_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pesi mwakainka kunze kuyobonanzi - musinsimi? Iyi, ndati kulindinywe, akwinda musinsimi. ");
INSERT INTO dov_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Echi nchenchicho nguchakali kulembeledwe obu. 'Bona, ndinokutuma mutumwa wangu kunembo lyabusyu bwako, uyokubambila nzila kunembo lyako. ");
INSERT INTO dov_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ndamba kulindinye nkasimpe, takukwe nikwakabukide akati kabaabo bazyalwa abanakazi unga ulaba mupati kwinda Joni mubbabbatizyi. Nekubaboobo, munini muntu mukolondo kubwami bwakujulu mupati kwinda nguwe. ");
INSERT INTO dov_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuzwa kumazuba a Joni mubbabbtizyi kusikila lino, bwami bwakujulubulokufwabisigwa alupyopyongano, lino bantu balupyopyongana balalubweza changuzu. ");
INSERT INTO dov_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mbukunga boonse basinsimi amulawu wakali kusinsima kusikila kuli Joni. ");
INSERT INTO dov_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Elyo nawayanda kuzumina kuchitambula, oyu ngu Elija, nguwe wakali kuzosika. ");
INSERT INTO dov_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kuliyoyo ulamatwi akumvwa, ngamvwe. ");
INSERT INTO dov_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kuli chili nchindinga ndilayezyanisya azyalane lyasunu? Chili mbuli bana basobana kuchisambalilo, bakkala akwita umwi awumwi, ");
INSERT INTO dov_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","akwamba, 'twakakulizizya muteetele, aboobo tewakazyana pe. Twakayeema, pele tewakalila. ");
INSERT INTO dov_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aboobo Joni wakasika katalyi chinkwa nanka kunywa masansa, elyo bakati, Uladimoni. ");
INSERT INTO dov_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana amuntu wakasika akulya akunywa elyo bakati, Langa, mwalumi sindya amukolwi, muzolwani abasimutelo abasizibi!' Pesi busongo bulalulamikwa anchito zyakwe.” ");
INSERT INTO dov_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Elyo Jesu wakatalika kukalalila madolopo omo mwakachita malele akwe manji, nkambo tebakeempwa. ");
INSERT INTO dov_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Maawe kulinduwe, Kkolazini! Mawe kulinduwe, Bbetisayida! Kansinga malele akachitwa ku Taya a Sidoni akachitwa kulindinywe, ninga bakeempwa kale kuchindi chakayinda muzisamo zyamasaka amudyota. ");
INSERT INTO dov_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pesi kulakuyandika chakwindilila kubuzuba bwalubeta kwinda nduwe. ");
INSERT INTO dov_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Webo, Kapenawumu, uyeeya kuti uzosumpulwa kujulu? Peepe, unoyoyetwa ansi kumulindi utagoli Hadesi. Nikwali kuti mu Sodomu mwakachitwa malele akachitwa mulinduwe, ninga mwachili asunu. ");
INSERT INTO dov_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pele ndati kulinduwe chiyobachubila kunyika ya Sodomu mubuzuba bwalubeta kwinda nduwe.” ");
INSERT INTO dov_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kuchindi echo Jesu wakati, “Ndilikutembawula Taata, Mwami, wakujulu anyika, nkambo wasisila basongo abamvwisya, akuyubunwida bana banini: ");
INSERT INTO dov_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iyii, Taata, Eechi chakalikubotezya kumeso ako. ");
INSERT INTO dov_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Zintu zyonse zyakapegwa ndime kuzwa kuli Taata. Elyo takwe umwi uzi mwana kunze kwa Taata, mpawo, takwe uzi Taata kunze kwamwana aboobo kuloyo mwana ngwasala kuti amuyubunune. ");
INSERT INTO dov_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Amuze kulindime, moonse nimukatede animulemenwa ndiyomupa kulyokezya. ");
INSERT INTO dov_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Amubweze ijokwe lyangu lili alindime akwiiya kulindime, nkambo ndilimubombe akuba mutete moyo, eelyo muyojana kulyokezya kwmyuuya yanu. ");
INSERT INTO dov_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nkambo ijokwe lyangu niteete alubo ndiguba amukuli wangu tulemi pe.” ");
INSERT INTO dov_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kuchindi echo Jesu wakayinka mubuzuba bwakulyokezya wayinda mumyunda yazilyo. Basikwiya bakwe bakafwa anzala eelyo bakasanguna kukulula mayila nkwalikumpela akwalya mituutu. ");
INSERT INTO dov_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pesi baFalisi nibakabona oobo bakati kuli Jesu, “Bona, basikwiya bako bachita zitali mumulawu kuchitwa mubuzuba bwakulyokezya.” ");
INSERT INTO dov_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pesi Jesu wakati kulimbabo, “Takwe nimwakabalide Devidi mbakachita nakaba anzala, abaabo balumi mbakali aabo? ");
INSERT INTO dov_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wakanjila mungánda ya-Leza akulya chinkwa chakutwa, chitensi kumulawu kuti alye alubo chitali kumulawu akulabo mbakali abo, pesi kazili kumuawu kupela kubapayizi. ");
INSERT INTO dov_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tamubalide mulawu kuti mubuzuba bwakulyokezya bapayizi muchikombelo balataluka mulawu wabuzuba bwakulyokezya pesi tabakwe mulandu? ");
INSERT INTO dov_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pele ndati kulindinywe umwi mupati kwinda ngánda yaLeza ulaano. ");
INSERT INTO dov_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Namwakalizi echi nchichalikwamba, 'mebo ndiyanda luse pepe chipayizyo; temwalikubapa kambo batakwe mulandu. ");
INSERT INTO dov_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Eelyo mwana amuntu ngu Mwami wazuba lyakulyokezya.” ");
INSERT INTO dov_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Mpawo Jesu wakazwa oko akwinka kuchikombelo. ");
INSERT INTO dov_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Amubone, kwakali muntu wakalinyanide kuboko. Bafalisi bakabuzya Jesu, bakati, “sena chililuleme kusikila mubuzuba bwakulyokezya?” Ikuti bamutamikizye kubisya. ");
INSERT INTO dov_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu wakati kulimbabo, “Inga ulaba mwalumi biyeni akati kanu, ngwani, na wali ambelele imwi, aboobo, na imbelele eyi yawida mudindi mubuzuba bwakulyokezya, takonga ulijata na akwigusya aanze? ");
INSERT INTO dov_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Chiinda bulemu biyeni, eelyo kumuntu nekuba kumbelele! Aboobo chililuleme kuchita chibotu mubuzuba bwakulyokezya.” ");
INSERT INTO dov_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mpawo Jesu wakati kumuntu, 'Tandabika kuboko kwako.” Wakatandabika, alubo lwakabwedezegwa mukupona, mbuli kwenzinyina kuboko. ");
INSERT INTO dov_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pesi ba Falisi bakayinka bakubamba mbubonya kabalikumuvwiya. Bakali kuyandula mbubanga balamujaya. ");
INSERT INTO dov_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Mbuli mbwakaziba Jesu, wakazwa oko. Bantu banji bakamutobela, lino wakabasilika boonse. ");
INSERT INTO dov_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Wakabalayilila kuti batachiti kuti azibinkane kulibamwi, ");
INSERT INTO dov_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","zikazuzikizigwe, zyakambwa muli Isaya musinsimi, kuti, ");
INSERT INTO dov_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bona, mulanda wangu ngundakasala; Muyandwi wangu umwi, oyo muuya wangu ngundibotelwa. Ndiyobika muuya wangu alinguwe, eelyo uyobakambawukila bululami kulibamasi. ");
INSERT INTO dov_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Takoyojana buyumuyumu na kukulililisya; nikuba umwi kumumvwa ijwi lyakwe mumigwagwa. ");
INSERT INTO dov_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Takwe nayotyola limwi ityetye lyakapwayulwa; takwepe nayozima kamuni kasuka kamulilo, kusikila wendelezya bululami mukuzunda, ");
INSERT INTO dov_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Abalabo bamasi bayoba bulangizi muzina lyakwe.” ");
INSERT INTO dov_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Eelyo umwi muntu utakuboni katambuli, wakanjidwe adimoni, wakeetwa kuli Jesu. Wakamusilika, azezyo zyakazwa kuti utambuli muntu wambula akubona. ");
INSERT INTO dov_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Makamu wonse akagamba akwamba, “ooyu muntu ngaulaba mwana wa Devidi na?” ");
INSERT INTO dov_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pesi baFalisi nibakamvwa malele aaya bakati, “Ooyu muntu tatandi madimoni kunze kwa Bbelezebbulu, mupati wamadimoni.” ");
INSERT INTO dov_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pele Jesu walizi miyeyo yabo mpawo wakati kulimbabo, “Bwami boonse bukazyania lwabo, buyomwayisigwa, alubo kufumbwa dolopo niba ng'anda ikazyania lwayo tikayimikili pe. ");
INSERT INTO dov_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ikuti satani watanda satani, unoli ulikulikazya lwakwe. Bwami bwakwe nga bulimikila byeni? ");
INSERT INTO dov_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Lino na ndilatanda madimoni a Bbelizebbulu, ani batobezi banu batandyanzi? Nkambo kachechi, bayoba babetesi banu. ");
INSERT INTO dov_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pesi do katwatanda madimoni a muuya wa Leza, mpawo bwami bwa Leza bwasika akati alindinywe? ");
INSERT INTO dov_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Alubo kulibiyeni kuti umwi anjile mung'anda yamuntu usimide akubba makwebo akwe katamusungide muntu usimide chakusanguna? Elyo uyobba makwebo akwe kuzwa mungánda yakwe. ");
INSERT INTO dov_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Umwi utali andime ukazyanya andime, alubo ayoyo utabungani andime ulamwayula. ");
INSERT INTO dov_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aboobo ndati kulinduwe, chibi choonse akusampawuula bantu bayolekelelwa, pesi kutukila muuya takukwe kulekelelwa pe. ");
INSERT INTO dov_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kufumbwa uwambula ijwi atala amwana muntu, ooyo uyolekelelwa. Pesi kufumbwa uwambula bubi atala a Muuya Uusalala, oyo takoyolekelelwa, na munyika eyi, na kuleeyo ichizosika. ");
INSERT INTO dov_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Chita musamu ubote ayala michelo yawo ibote, na kuchita musamu kuba mubi, amuchelo wayo ubije, mbuli kuti musamu uboneka amichelo yawo. ");
INSERT INTO dov_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nywebo nubana banzoka, mbomunga muli babi, ngamulamba buti izintu zibotu? Kuzwa mumoyo mulizinji mulomo nzuwambula. ");
INSERT INTO dov_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Muntu mubotu kuzwa kuzintu zibotu zyamoyo wakwe ulagusya nzizyonya, pele muntu mubi wakuzintu zibi zyamoyo wakwe mulazwa bubi kupela. ");
INSERT INTO dov_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ndati kulinduwe mubuzuba bwalubeta bantu balakupa bupandanuzi kuli alimwi ijwi litali kabotu ndibakaamba. ");
INSERT INTO dov_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kuzwa kumajwi ako uyolulamikwa, akumajwi ako uyopegwa mulandu.” ");
INSERT INTO dov_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Elyo balembi bamulawu bamwi, abaFalisi bakasandula akut, “Muyiisi tuyanda kubona chitondezyo kuzwa kulinduwe.” ");
INSERT INTO dov_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pesi Jesu wakasandula akuti kulimbabo, kufumbwa bubi abumambi kuzukulu lyasunu lyabayandula chitondezyo. Pesi tokwe chitondezyo pe chiyopegwa kunze kwachitondezyo cha Jona musinsiimi. ");
INSERT INTO dov_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mbanga Jona wakali amazuba atatu mubula bwamuswi mupati, alakwe Mwana Muntu uyoba amazuba atatu amansiku atatu mumoyo wanyika. ");
INSERT INTO dov_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bantu baku Ninivu bayoyimikila kunembo lyalubeta azukulu eli lyabantu aboobo liyopegwa mulandu. Nkambo bakeempwa mukukambawuka kwa Jona, lino amubone, umwi mupati kwinda Jona uli aano. ");
INSERT INTO dov_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mwami mwanakazi wakumusama uyobuka kulubeta abantu bakwe bazukulu eli lyabantu akulipa mulandu. Wakazwa kumajinkilo anyika kuti azomvwe busongo bwa Solomoni, alubo bona, umwi mupati kwinda Solomoni ulaano. ");
INSERT INTO dov_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Na muuya mubi wazwa kumuntu, wakwinda mukati kamasena atakwe maanzi akuyandula kulyokezya, pesi tawubujani pe. ");
INSERT INTO dov_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mpawo lyakat, “Ndiyobweda kungánda yangu nkundakazwa; Nilyakabwed, lyakujana ng'anda eyo yakakukulwa akubambwa obotu. ");
INSERT INTO dov_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Elyo lilayinka akubweza bweza imbi myuuya ili musanu ayibili mibi kwinda nguwo, lino ilasika kuzokkala omo. Abobo bubi bwamuntu kumamanino bwakabisisisya kwinda kumatalikilo. Mbukuyoba mbubobo kuzukulu lyabubi eli.” ");
INSERT INTO dov_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nakachili kwambula Jesu kumakamumakamu, amubone, banyina abakulana bakwe bakayimikila aanze, kabayandula kuti bambule anguwe, ");
INSERT INTO dov_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Umwi wakati kulinguwe, “Bona banyoko abanike bako balimvwi aanze bayanda kwambula anduwe.” ");
INSERT INTO dov_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pesi Jesu wakasandula kuliyoyo wakamwambila, “Mbani baama bangu alubo mbaani banike bangu?” ");
INSERT INTO dov_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eelyo wakatandabika kuboko kwakwe akutondeka basikwiya bakwe mpawo wakati, “Bona, mbabo baama abanike bangu! ");
INSERT INTO dov_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nkambo kufumbwa uchita luyando lwa Taata ulikujulu, muntu oyo mukulana wangu, muchizi wangu, mbebaaba bangu.” ");
INSERT INTO dov_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mubuzuba obo Jesu wakazwa aanze ang'anda akukkala ambali alwizi. ");
INSERT INTO dov_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Inkamu mpati yakamubunganina achakumuzyunguluka, lino wakanjila mubwato akukkala mukati, inkamu yoonse niyakachimvwi kunkomwe. ");
INSERT INTO dov_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Elyo wakamba zintu zyiingi kulimbabo muzikozyanio. Wakati, “Amubone, mulimi wakaya kunze kukuyobyala imbuto. ");
INSERT INTO dov_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nakayobubyala, Imwi imbuto zyakawida ambali lyamugwagwa, mpawo bayuni bakasika akuzilya. ");
INSERT INTO dov_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Imwi imbuto yakawida anyika ilamabwe, kwakati kwakatali muse mwingi. Mpawo mpawo zyakamena nkambo imuse tewakali abulamfu kukuyaansi. ");
INSERT INTO dov_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pesi izuba nilyakatenta, zyakawuumpwa, nkambo tezyakali amiyanda, aboobo zyakayuma. ");
INSERT INTO dov_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imbuto zimwi zyakawida mumaamvwa. Maamvwa akakomena mpawo akazisyanikizya. ");
INSERT INTO dov_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Zimwi imbuto zyakawida mumuse mubotu mpawo zyakazyala zilyo, zimwi mwanda umwi windulwidwe chakuvula, zimwi makumi musanu alimwi, mpawo zimwi makumi aatatu. ");
INSERT INTO dov_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ooyo ulamatwi muleke amvwe.” ");
INSERT INTO dov_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Basikwiya bakasika mpawo bakati kuli Jesu, “Nkambonzi nowambula makani aya muzikozyanio?” ");
INSERT INTO dov_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu wakasandula akwamba kuti kuli mbabo, “mulipedwe mwenya wakumvwisisya zisisidwe zyabwami bwakujulu, pesi kulimbabo tabapedwe pe. ");
INSERT INTO dov_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nkambo kufumbwa ujisi uyopegwa zyingi, alimwi uyoba azyindilide zyingi. Pesi utakwe, nekuba anchalacho chiyobwezegwa kuzwa kulinguwe. ");
INSERT INTO dov_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nchenchicho nchingambulaabo muzikozyanio: nekuba banokubona, pesi tababonesesyi pe; alubo nekuba balamvwa, pesi tabamvwisisisyi, nekuba kumvwisisisya. ");
INSERT INTO dov_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kulimbabo chisinsimicha Isaya chili zuzikizizigwe, echo chamba kuti, “Nekuba kumvwa mulamvwa, pesi takwe abunini nimuyomvwisisya; nekuba kubona muyobona, pesi takwepe nimuyobonesesya. ");
INSERT INTO dov_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nkambo myoyo yabantu aaba yaba mifubafuba mpawo miyumu kukumvwa, alubo bakajala meso aabo, kuti bataboni ameso aabo, nekuba kumvwa amatwi aabo, nikuba kumvwisisisya amyoyo yabo, kuti basanduke lubo, alubo ndikabaponesye.' ");
INSERT INTO dov_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pesi alongezegwe meso anu, nkambo alabona. ");
INSERT INTO dov_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nkasimpe ndati kulindinywe kuti basinsimi bayingi abantu baluleme bakayandisya kubona zintu ezyo nzimubona pesi tebakazibona. Bakayandisya kuzimvwa zintu nzimumvwa alimwi tebakazimvwa. ");
INSERT INTO dov_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Lino ngamuswilile kuchikozyanyo chamulimi wakabyala imbutozyakwe. ");
INSERT INTO dov_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Na umwi wamvwa ijwi lyabwami bwakujulu pesi talimvwisisisya, mubi umwi wasika akubweza chakabyalwa mumoyo wakwe. Eyi nimbuto yakabyalilwa ambali lyamugwagwa. ");
INSERT INTO dov_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chakabyalwa anyika ilamabwe muntu umvwa ijwi elyo mpawo mpawo wakalitambula akukondwa, ");
INSERT INTO dov_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","nekubabobo takwe miyanda mulinguwe nkambo mpawo ulakakatila chabunini. Nikuba makatazyo akupenzegwa kaabuka ankambo kajwi, ulafwambana kuwa. ");
INSERT INTO dov_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chakabyalwa mumuse ulamamvwa, oyu muntu umvwa ijwi, pesi misaalo yenyika abongelezyi bwabuvubi bwasyanikizya ijwi, elyo ulaba utachizyali michelo. ");
INSERT INTO dov_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Imbuto yakaminzwa mumuse mubotu, ooyu muntu uumvwa ijwi akulimvwisisisya. Ulazyala michelo akuleta zilyo, kakutebulwa uumwi myanda, amuli umwi makumi musanu alimwi, amuli umwi makumi aatatu akayindululwa mbubonya mbozyakabyalwa. ");
INSERT INTO dov_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu wakababikila chimbi chikozyanyo kuli mbabo. Wakati, “Bwami bwakujulu bulimbuli mwalumi wakabyala imbuto imbotu mumuunda wakwe. ");
INSERT INTO dov_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pesi ibantu nibakachili koona, sinkondonyina wakasika elyo mpawo wakabyala masokwe akati ka wiiti mpawo wakiinka. ");
INSERT INTO dov_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mpawo masoonso nakazwa akuzyala bana balamuseke, aboobo isokwe lyakaboneka alyalo. ");
INSERT INTO dov_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Babelesi bamukamuunda nibakasika mpawo bakati kulinguwe, 'Taa,' temwakabyala imbuto mbotu na mumuunda wenu? Nkambonzi nikwaba masokwe?' ");
INSERT INTO dov_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wakati kulimbabo, 'Sinkondoma nguwakachita echi.' Babelesi bakati kulinguwe, 'Mpo mulayanda na kuti twinke tukazinonkole?' ");
INSERT INTO dov_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mwini muunda wakati, 'Pee. Nkambo mwanoli kamunonkola masokwe, ngamuyononkokezya a wiiti. ");
INSERT INTO dov_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Muleke zikule antomwe kusikila kukutebula. Elyo kuchiindi chakutebula ndizoti kubatebuzi, “Chakusanguna amunonkoole masokwe akwawanga misunta kuti akawumpwe, pesi mubunganisye wiiti mubutala bwangu.” ");
INSERT INTO dov_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Elyo Jesu wakabika chikozyanisyo chiimbi kulimbaabo. Wakati, “Bwami bwakujulu buli mbuli inseeke yalubangulamuntu njakabweza akwiibyala mumuunda wakwe. ");
INSERT INTO dov_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Inseke eyi nindini loko kunseke zyoonse. Pesi na yakomena, inga yabampati kwinda misamu yamuchilili. Ngayakomena kwinda ziziki zyamuchilili, ngayaba musamu wakuti bayuni bawuluka basike akuyaka zizumbo mumitabi yayo?” ");
INSERT INTO dov_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Alimwi Jesu wakabambila chimbi chikozyanyo. “Bwami bwakujulu buli mbuli bumena bwamwanakazi bwakabweza akuswanizya zimpanzi zitaatu zyabusu bwa wiiti kusikila zyafufumuka.” ");
INSERT INTO dov_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Zyoonse ezi zintu Jesu wakazyaamba muzikozyanio kumakamu; aboobo takwe nchakamba katambide muchikozyanio. ");
INSERT INTO dov_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Echi chakalibobo kuchitila kuti chakambwa kwinda mumusinsimi chizuzikizigwe, Awo mpakamba kuti, “Ndiyojula mulomo muzikozyanisyo. Ndiyowamba zintu zyakasisikene kuzwa kumatangunino anyika..” ");
INSERT INTO dov_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesu wakasiya makamu makamu akuya mungánda. Basikwiya bakwe bakeza kulinguwe akwamba kuti, “Tupandulwide chikozyanio chamasokwe amumuunda.” ");
INSERT INTO dov_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu wakabasandula wamba elyo wakati, “Ooyo ubyala imbuto mbotu Mwana a Muntu. ");
INSERT INTO dov_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Muunda ninyika; mpawo imbuto mbotu, aba mbana baLeza bamubwami. Imasokwe mbana bamubi umwi. ");
INSERT INTO dov_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Lino sinkondo wakabyala ngudyabulosi. Butebuzi ngimamanino achiindi, mpawo batebuzi mbaangelo. ");
INSERT INTO dov_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nkinkako mbuli masokwe mbabunganigwa akuumpwa amulilo, aboobo mbukuyooba kumamanino achiindi. ");
INSERT INTO dov_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana amuntu uyotuma baangelo bakwe, elyo bayobunganisya aanze abwami bwakwe zintu zyoonse zyakali kuchita kuti kube ababo bakachita zitelede. ");
INSERT INTO dov_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bayobawalila mumabanga banga amulilo, nkubanoli kabakwila akuyoluma intwino. ");
INSERT INTO dov_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Elyo kuyoba bantu balume kabamweka mbuli zuba mubwami bwa Wisi. Ulamatwi, ngamvwe ");
INSERT INTO dov_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ibwami bwakujulu buli mbuli buvubi busisidwe mumuunda. Muntu wakabona akubusisa. Mukukondwa kwakwe wakinka, wakawuzya zintu zyoonse nzyakali azyo, akuyowula munda oyo. ");
INSERT INTO dov_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Alubo, Bwami bwakujulu bulimbuli muntu musambali uyandula ngale imbotu. ");
INSERT INTO dov_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nakijana imwi ngale imbotu, wakeenda akuzya zyoonse nzyakalazyo zintu akuyoyiwula. ");
INSERT INTO dov_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Alubo bwami bwakujulu buli mbuli kazamba kakawalwa mulwizi, mpawo kabungania baswi bamisyobo yoonse. ");
INSERT INTO dov_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nikakazula, bazubi bakakabweza, bazubi bakakakwelela aanze kunkomwe. Elyo bakakkala ansi akubungania imbotu muzibikilo, pesi zyakatali kabotu bakazisowa. ");
INSERT INTO dov_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kuyoba obo kumamanino achindi. Baangelo bayosika akuyowandanya babi kuzwa kubaluleme. ");
INSERT INTO dov_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bayobawalila mumabangabanga oko nkubayokwila akuyoluma intwino zyameno. ");
INSERT INTO dov_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Mwazimvwa na zintu eezi zyoonse?” Basikwiiya bakati kulinguwe, “Iyii.” ");
INSERT INTO dov_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mpawo Jesu wakamba kuti kulimbabo, “Aboobo woonse mulembi wamulawu waba sikwiya kubwami bwakujulu ulimbuli muntu mwiningánda, ugwisya aanze zintu zyakwe zikulukulu ezipya kuzwa muzibikilo zyakwe.” ");
INSERT INTO dov_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Abobo nichakaba kuti Jesu wamaninsya zikozyanio ezi, wakazwa kubusena oobo. ");
INSERT INTO dov_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Eelyo Jesu nakanjila kuchisi chakwe akuyiisya bantu muchikombelo chabo. Chakazwa chakuti bakagamba akwamba kuti, “Muntu oyu ubujana kuli busongo bwakwe anguzu zyamalele aaya? ");
INSERT INTO dov_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Oyu muntu teensi mwana wamubezi na? Sena banyina tabitwi kuti Meli? Sena bana bakwabo tabali ba Jemusi, Jozefu, Sayimoni a Judasi? ");
INSERT INTO dov_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Sena bachizi bakwe, tabali akkati kesu? Uzijana kuli zintu zyoonse ezi?” ");
INSERT INTO dov_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bakalimvwa kabali amulandu anguwe. Pesi Jesu wakati kulimbabo, “Musinsimi takwe bulemu kunze akuchisi chakulimbabo amumpuli yakwe.” ");
INSERT INTO dov_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Alubo takwe pe nakachita malele miingi nkuko akambo kakutamusyoma kwabo. ");
INSERT INTO dov_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kuchindi echo, Mwami Helodi watamvwa makani atala a Jesu. ");
INSERT INTO dov_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wakamba kuti kubazike bakwe, “ooyu ngu Joni mubbabbatizyi; wabuka kuzwa kubafu. Nkinkaako nguzu eezi zilikubeleka mulinguwe.” ");
INSERT INTO dov_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nkambo Helodi wakali wajata Joni, wamwanga akumubika muntolongo nkambo ka Helodiyasi, mukamwanike wakwe Filipu. ");
INSERT INTO dov_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nkambo Joni wakambide kuti kulingu, “Tachili mumulawu pe kuti umukwate.” ");
INSERT INTO dov_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helodi wakali kukonzya kumujaya pesi wakayoowa bantu, nkambo bakali kumuyeyela kuti musinsiimi. ");
INSERT INTO dov_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pesi buzuba bwakuzyalwa kwa Helodi nibwakasika, mwana musimbi wa Helodiyasi wakazyana aakati kabo akubotezya Helodi. ");
INSERT INTO dov_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Mukusandula wakasyomezya aachikonke chakuti uyomupa kufumbwa nchayokumbila. ");
INSERT INTO dov_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Musule akulayililwa abanyina, wakamba kuti, “Mundipe aano, mundyido, mutwe wa Joni mu Bbabbatizyi.” ");
INSERT INTO dov_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Mwami wakawusa kuchikumbizyo chakwe, pesi nkambo kachikonke chakwe alimwi akambo kabaabo mbakali kususula aabo, wakalayilila kuti kuchitwobo. ");
INSERT INTO dov_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Wakatumina kuyodunsulwa kwamutwe wa Joni muntolongo. ");
INSERT INTO dov_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mpawo mutwe wakwe wakaletwa mundyido akupegwa kumwana musimbi oyo wakutola kuli banyina. ");
INSERT INTO dov_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mpawo basikwiya bakwe bakasika, babweza mutunta akuyowuzikka. Kwinda kwachechi, bakiinka akuyowambila Jesu. ");
INSERT INTO dov_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lino Jesu nakamvwa eechi, wakazwa mpawo awo, wakunjila mubwato kubusena buli kumbali. Makamu nakamvwa aanchicho, akamutobela amawulu kuzwa kumyunzi. ");
INSERT INTO dov_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mpawo Jesu wakasika musule lyabo akubona makamu mapati. Wakabaluzyalo kulimbabo eelyo wakaponya bachiswa babo. ");
INSERT INTO dov_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nilyakaba goko, basikwiya bakasika kulinguwe akwamba kuti, “Oobu busena mbwankanda, alimwi chiindi chamana. Mwayisya makamu kuti bayinke kumyuunzi mpawo bakalyulile chakulya kwabo.” ");
INSERT INTO dov_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lino Jesu wakabambila kuti, “Tabelede kumwayika. Amubape chimwi nchibatalye.” ");
INSERT INTO dov_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bakamba kuti kulinguwe, “Aano tuli aazinkwa zili musanu biyo answii zyobile. ");
INSERT INTO dov_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu wakati, “Amuzilete kulindime.” ");
INSERT INTO dov_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mpawo Jesu wakalayilila makamu abantu kuti akkale aansi mubwizu. Wakabweza zinkwa zili musanu answi zyobile. Walanga kujulu, wazilongezya akukwamuna zinkwa mpawo wazipa kuli basikwiya, alimwi basikwiiya bakapa makamu. ");
INSERT INTO dov_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Boonse bakalya akukkuta. Mpawo bakabwezelela bufwefwelenga bwakachaala bwechakulya - nsangwa zizwide zili kkumi azibili. ");
INSERT INTO dov_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aabo bakalya bakali zyuulu zili musanu zyabaalumi, kutaamba abanakazi abaana. ");
INSERT INTO dov_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mpawo mpawo wakachita kuti basikwiya banjile mubwaato akwinka kunembo lyakwe kuli bumwi busena, mbubonya mbwakachili kumwayisya makamu makamu. ");
INSERT INTO dov_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nakamana kumwayisya makamu, wakatanta achilundu kuyokoomba. Nilyakaba goko wakali aalikke. ");
INSERT INTO dov_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pesi lino bwato bwakali bwabakule aanyika. Kabuchundwa amayuwe, nkambo muuwo wakali kuunga kuubakachizya. ");
INSERT INTO dov_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Muchiindi chane mansiku Jesu wakabasikila, keenda aatala aalwizi. ");
INSERT INTO dov_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Basikwiya nibakamubona kayobwenda ataala alwizi, bakakatazika akwamba kuti, “Musangu,” mpawo bakalila chakuyowa. ");
INSERT INTO dov_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pesi Jesu wakaamba kuli mbabo aawo akuti, “Amube bakozu ndime! Mutayowi.” ");
INSERT INTO dov_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita wakamusandula akwamba kuti, “Mwami, na nduwe, ndilayilile kuti ndize kulinduwe atala amaanzi.” ");
INSERT INTO dov_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu wakati, “Kweza.” Mpawo Pita wakazwa mubwato akweenda aatala aamanzi kayinka kuli Jesu. ");
INSERT INTO dov_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pesi Pita nakabona muuwo mupati, wakayoowa. Mbwakatalika kubbila biyo, wakalila akwamba kuti, “Mwami ndifutule.” ");
INSERT INTO dov_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mpawo mpawo Jesu wakatandabika kuboko kwakwe, wajata Pita, akwamba kuti kulinguwe, “Nusilusyomo luniini, nkambonzi nodoneeka?” ");
INSERT INTO dov_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mpawo Jesu aa Pita nibakanjila mubwato, muuwo wakiimikila kuunga. ");
INSERT INTO dov_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mpawo basikwiiya bakali mubwato bakakomba Jesu akwaamba kuti, “Nkasimpe uli Mwana wa Leza.” ");
INSERT INTO dov_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nibakazubuka bakasika kunyika yaku Genesaleti. ");
INSERT INTO dov_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bantu bakubusena oobo nibakaziba kuti ngu Jesu, bakatumina makani konse muchisi choonse chizyungulukide, alimwi bakaleta kulinguwe woonse wakali kuchiswa. ");
INSERT INTO dov_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bakamukumbila kuti bajate moombe wajansi lyakwe, alimwi biingi bakuujata bakapona. ");
INSERT INTO dov_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mpawo bamwi ba Falisi abalembi bakasika kuli Jesu kabazwa ku Jelusalema. Bakaamba kuti, ");
INSERT INTO dov_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nkamboonzi basikwiya bako nibakazyania aziyanza zyabapati? Nkambo tabasambi pe mumaboko nibalya chinkwa.” ");
INSERT INTO dov_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wakasandula akwamba kuti kulimbabo, “Alimwi nywebo - nkambonzi nimukazyania amulawu wa Leza nkambo kaziyanza zyanu? ");
INSERT INTO dov_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nkambo Leza wakamba kuti, “Lemeka wuso abanyoko, alimwi ooyo wambula bubi kuli wisi na banyina nkasimpe uyoofwa. ");
INSERT INTO dov_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pesi mwamba kuti, kufumbwa lugwasyondunoli watambula kuzwa kuli ndime lino nchipo chipegwa kuli Leza,” ");
INSERT INTO dov_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ooyo muntu telede kulemeka wisi. Munzila eyi mwawubula ijwi lya Leza. Malembe mabotu aachindi ali aajwi lya Leza aamwi malembe aachindi ali aamulawu. Nkuyumu kusalula chibalo chibotu. Nkambo kachiyanza chenu. ");
INSERT INTO dov_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nywebo nobasikuwupawupa! Isaya wakachita kabotu nakasinsiima aatala andinywe nakamba kuti, ");
INSERT INTO dov_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Bantu aba balandilemya amilomo yabo, pesi myoyo yabo ilikule andime. ");
INSERT INTO dov_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Balandikomba chabuyo, nkambo balayiisya milawo yabantu mbuli njiisyo zyabo.” ");
INSERT INTO dov_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Mpawo wakiita makamu kulinguwe mwini akwamba kuti kuli mbabo, “Amuswilile akumvwisya - ");
INSERT INTO dov_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tachiwo chinjila mukanwa chisofwazya muntu. Pesi echo chizwa mukanwa, eechi ncheenchicho chisofwazya muntu.” ");
INSERT INTO dov_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mpawo basikwiya bakasika akwamba kuti kuli Jesu, “Ulizi na kuti ba Falisi bakalebwa nibakamvwa makani aaya?” ");
INSERT INTO dov_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesu wakasandula akwamba kuti, “Zizikki zyoonse ezyo Taata wakujulu nzyakatazikila ziyononkolwa. ");
INSERT INTO dov_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Amubaleke aabalike, mbeenzyi boofu. Na moofu weenzya moofunyina, boonse bayowida mukkomba.” ");
INSERT INTO dov_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita wakasandula akwamba kuti kuli Jesu, “Pandulula kalabiko aaka kulindiswe.” ");
INSERT INTO dov_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu wakaamba kuti, “Anywebo aambuli sunu tamumvwisisyi na? ");
INSERT INTO dov_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tamumvwisisisyi na kuti kufumbwa echo chinjila mukanwa chilayinda mwida mpawo chilazwa aanze mpawo chilasowegwa mukkomba? ");
INSERT INTO dov_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pesi izintu ezyo zizwa mukanwa zilazwa mumoyo. Nzenzizyo ezyo zisofwazya muntu. ");
INSERT INTO dov_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nkambo kumoyo kulazwa miyeyo mibi, bujayi, bumambi, bwamu, kubba, bukamboni bwakubeja, akulengelela. ");
INSERT INTO dov_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Eezi nzenzizyo eezyo zisofwazya muntu. Pesi kulya amaboko atasambie pe takusofwazyi muntu pe.” ");
INSERT INTO dov_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mpawo kuzwa awo Jesu wakazwa ooko akwinka kuzisi zyakumyunzi yaku Taya aku Sidoni. ");
INSERT INTO dov_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Amubone, mwanakazi mu Kkenani wakazwa kuchisi echo. Wakoompolola akwamba kuti, “Ndifwide luzyalo, Mwami, Mwana wa Devidi! Mwana wangu musimbi ulijisi loko dimoni. ");
INSERT INTO dov_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pesi Jesu taakwe jwi ndyakamusandula pe. Basikwiiya bakwe bakeza akumukumbila, bakati, “Mutande, nkambo uli koompolola musule lyesu.” ");
INSERT INTO dov_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pesi Jesu wakasandula akwamba kuti, “Nsitumidwe nikuba kuli umwi pesi kumbelele ziswekede zyakungánda ya Izilayeli.” ");
INSERT INTO dov_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pesi wakeza akuvundama aansi kunembo lyakwe, wati, “Mwami, ndigwasye.” ");
INSERT INTO dov_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Wakasandula akwamba kuti, “Tachili kabotu pe kubweza chinkwa chabana akuchisowela tunkala.” ");
INSERT INTO dov_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wakati, “Mbukubede, Mwami, pesi aatulato tunkala tulalya tumwi twatufwefwelenga ooto tuuwa kumatebule abasimalelo aato.” ");
INSERT INTO dov_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mpawo Jesu wakasandula akwamba kuti kulinguwe, “Yo mwanakazi, lusyomo lwako ndupati; akuchitwe kulinduwe mbubonya mbuli mboyanda.” Mwana wakwe musimbi wakaponesegwa kuzwa kuchindi echo. ");
INSERT INTO dov_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesu wakazwa kubusena oobo akwinka kumbali aalwizi lwaku Galili. Mpawo wakatanta akukkala nkuko. ");
INSERT INTO dov_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Makamu makamu abantu mapati akeza kulinguwe. Bakaza abalema, boofu, basyataambi, abantu batyokede, abamwi bayingi bakali kuchiswa. Bakababika kumawulu aa Jesu, mpawo wakabasilika. ");
INSERT INTO dov_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Eelyo makamu makamu akagamba nakabona bantu batambuli kabambula, batyokede kababakabotu, balemene kabeenda, aboofu kababona. Bakalumbayizya Leza wa Izilayeli. ");
INSERT INTO dov_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesu wakaiita basikwiya bakwe akwamba kuti, “Ndafwaluzyalo kumakamu nkambo bakkala aandime kwamazuba ataatu kale mpawo tabakwe achakulya. Tandiyandi kubamwayisya kabatalyide, nkambo ngabayowizuka munzila.” ");
INSERT INTO dov_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Basikwiya bakati kulinguwe, “Nkukuli nkotunga tulajana zinkwa zizulila kubusena bwankanda buliboobu kuti zikkutye makamu makamu mapati aalibobu?” ");
INSERT INTO dov_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesu wakati, “Mujisi zinkwa zyongane?” Bakati, “musanu azibili, atuswi tuchebiyo.” ");
INSERT INTO dov_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Mpawo Jesu wakalayilila makamu kuti akkale aansi aanyika. ");
INSERT INTO dov_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Wakabweza zinkwa zili musanu azibili answi, mpawo nakamana kulumba, wakakwamuna zinkwa akuzipa kuli basikwiya. ");
INSERT INTO dov_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Basikwiya bakazipa kumakamu. Bantu boonse bakalya mpawo bakakkuta. Mpawo bakabunganisya nsangwa zili musanu azibili zyabu fwefwelenga bwakachaala. ");
INSERT INTO dov_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aabo bakazilya bakali zyuulu zyone zyabaalumi, kutabala abanakazi abaana. ");
INSERT INTO dov_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mpawo Jesu wakamwayisya makamu makamu abantu akunjila mubwato mpawo wakaya kuchisi chaku Magadani. ");
INSERT INTO dov_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ba Falisi aba Sadusi bakeza mpawo bamusunka akumubuzya kuti abatondezye chitondezyo chizwa kujulu. ");
INSERT INTO dov_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pesi wakasandula akwamba kuti kuli mbabo, “Nikwasiya, mwamba kuti, 'Kuyoba kunze kubotu, nkambo ijulu lilasalala.' ");
INSERT INTO dov_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nikuba chifuma, mwamba kuti, 'Kunze kunoli kubi, nkambo ijulu lilasalala alimwi lilivumbidwe. Mulizi kupandulula bwime bwakujulu, pesi tamukonzyi kupandulula zitondezyo zyazyiindi. ");
INSERT INTO dov_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Izyalane ibbi abwamu lilangula chitondezyo, pesi takwe chitondezyo chiyopegwa kulindilyo kutaamba chitondezyo cha Jona.” Mpawo, Jesu wakabasiya akutozya kumbi. ");
INSERT INTO dov_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Basikwiya nibakasika mutala, bakalubide kubweza chinkwa. ");
INSERT INTO dov_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu wakati kulimbabo, “Amubone akuchenjela kubumena bwaba Falisi aba Sadusi.” ");
INSERT INTO dov_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Elyo basikwiya bakabuzyanya akwamba kuti, nkambo tetwabweza pe chinkwa.” ");
INSERT INTO dov_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu wakaziba achechi mpawo wakati, “Nywebo nubasilusyomo lunini, nkambonzi mulabuzyania lwanu mpawo mulati nkambo tetwabweza pe chinkwa? ");
INSERT INTO dov_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tamuna kuziba na kwibaluka zinkwa zili musanu kulibali zyuulu zili musanu, alimwi kuti mwakabungika nsangwa zyongane? ");
INSERT INTO dov_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Na zinkwa zili musanu aazibili kuzyuulu zine, alimwi kuti ninsangwa zyongane nzimwakabungika? ");
INSERT INTO dov_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ino nkambonzi kuti tamumvwisisyi kuti tendakalikwamba kulindinywe aatala achinkwa? Aamubone akuchenjela kubumena bwaba Falisi aba Sadusi.” ");
INSERT INTO dov_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mpawo bakamvwisya kuti takali kubambila kuti bachenjele bumena bwakali bwachinkwa pe, pesi kuti bachenjelele injisyo zyaba Falisi aba Sadusi. ");
INSERT INTO dov_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Lino Jesu nakasika kuzisi zili kufwifwi aa Kkayisaliya Filipi, wakabuzya basikwiya bakwe, wati, “Ino bantu bati Mwana aa Muntu ngwani? ");
INSERT INTO dov_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bakati, “Bamwi bakwamba kuti nduwe Joni mubbabbatizyi; bamwi bati, Elayija; alimwi bamwi bakuti, Jelemiya, na umbi wabasinsimi.” ");
INSERT INTO dov_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wakati kulimbabo, “Pesi nywebo mundamba kuti ndimeni?” ");
INSERT INTO dov_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sayimoni Pita wakasandula wati, “Nduwe Kkilisito Mwana wa Leza uupona.” ");
INSERT INTO dov_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesu wakasandula akwamba kuti kulinguwe, “Uli aacholwe, Sayimoni mwana a Jona, nkambo nyama abulowa teensi nzizyo zyakuyubunwida eezi, pesi Taata wangu uli kujulu. ");
INSERT INTO dov_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Alimwi ambebo ndamba kuti kulinduwe nduwe Pita, mpawo aatala amwaala ooyu ndiyoyaka mbungano yangu. Milyango yazibunda tikozokuzunda. ");
INSERT INTO dov_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ndiyokupa zijaluzyo zyabwami bwakujulu. Kufumbwa nchotakaange aansi chiyosungwa akujulu, alimwikufumbwa nchotakangunune aansi chiyosungununwa aakujulu.” ");
INSERT INTO dov_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mpawo Jesu wakalayilila basikwiya kuti batakaambili naba umwi kuti wakali Kkilisito. ");
INSERT INTO dov_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kuzwa kuchindi echo Jesu wakatalika kwambila basikwiya bakwe kuti welede kwinka ku Jelusalema, kuyopengela zinti zyingi kumaanza abapati abapayizi bapati abalembi, kujayigwa, akubusigilwa kubuumi kubuzuba bwatatu. ");
INSERT INTO dov_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Mpawo Pita wakamubweza akumutola kiumbali akumuchibula, wati, “Eezi azibe kule anduwe, Mwami; eezi zitazochitiki kulinduwe.” ");
INSERT INTO dov_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pesi Jesu wakachebuka akwamba kuli Pita kuti, “Zwaawa kusule lyangu, Satani! Uli chilebyo kulindime, nkambo toyeeyi atala azintu zya Leza, pesi ataala aazintu zyabantu.” ");
INSERT INTO dov_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mpawo Jesu wakati kuli basikwiya bakwe, “Na muntu kayanda kunditobela, aalilube lwakwe, abweze chiingano chakwe mpawo anditobele. ");
INSERT INTO dov_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nkambo kufumbwa uyanda kufutula buumi bwakwe uyobuswekelwa, alimwi kufumbwa uswekelwa buumi bwakwe nkambo kandime uyobujana. ");
INSERT INTO dov_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nkambo chigwasyanzi kumuntu kuvuba nyika yoonse pesi akaswekelwe buumi? Ninzi nchakonzya kupa muntu muchibaka chabuumi bwakwe? ");
INSERT INTO dov_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nkambo Mwana muntu uyoboola mubulemju bwa Wisi abangelo bakwe. Mpawo uyolumbula muntu umwi awumwi mbuli milimo yakwe. ");
INSERT INTO dov_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Chakasimpe ndamwambila kuti, mpubali bamwi benu bayiimvwi ano batakwe nibayolabila lufu mane lumwi bakabone Mwana aa Muntu kaboola mubwami bwakwe.” ");
INSERT INTO dov_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nikwakayinda mazuba aali musanu abumwi Jesu wakabweza Pita, Jemusi a Joni mwanike wakwe, akubatola atala achilundu chilamfu abalikke. ");
INSERT INTO dov_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wakasanduka kunembo lyabo. Busyu bwakwe bwakabalama mbuli zuba, azisamo zyakwe zyakaba mbuli mumuuni. ");
INSERT INTO dov_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Amubone kwakaboneka Mozesi a Elija balaambula awe. ");
INSERT INTO dov_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita wakasandula akwamba kuti kuli Jesu, “Mwami, nchibotu kuli ndiswe kuti tube aano. Kuti koyanda, ndilakuchita matumba aatatu - chimwi chibe chako, achimwi chibe cha Mozesi, achimwi chibe cha Elayija.” ");
INSERT INTO dov_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Elyo kachili mukwambula, amubone, ijoba libalaama lyakabavumba, mpawo amubone, kwakazwa ijwi mujoba, lyakati, “Ngoyu Mwanangu ngundiyandisya, muli nguwe mundibotelwa. Amuswilile nguwe.” ");
INSERT INTO dov_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lino basikwiya nibakalimvbwa, bakavundaama aansi, akuyowa loko. ");
INSERT INTO dov_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mpawo Jesu wakaza, akubaguma akwamba kuti, “Mubuke mutayowi.” ");
INSERT INTO dov_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mpawo bakalanga kujulu pesi takwe ngubakabona kunze kwa Jesu luzutu. ");
INSERT INTO dov_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lino nibakali kuseluka achilundu, Jesu wakabalayilila, wati, mutambili muntu chilengano eechi kusikila mwana amuntu akabuke kubafu.” ");
INSERT INTO dov_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Basikwiya bakwe bakamubuzya, bati, ino nkamboonzi balembi bamulawu balaamba kuti Elija welede kusanguna kuza?” ");
INSERT INTO dov_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu wakasandula wati, “Elayija nchoonzyo uleza akubukulusya zintu zyoonse. ");
INSERT INTO dov_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lino ndamwambil, Elayija wakasika kale, pesi tebakamuziba pe. Kwinda kuchita nchibakali kuyanda kuli nguwe. Munzila njiiyo, Mwana amuntu uyofwaba mumaboko aabo.” ");
INSERT INTO dov_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mpawo basikwiya bakamvwa kuti wakalikwambambuula ambabo atala a Joni Mubbabbatizyi. ");
INSERT INTO dov_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eelyo nibakasika kunkamu, mwalumi wakaza kulinguwe, wafugama kunembo lyakwe akwamba, ");
INSERT INTO dov_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Mwami, komufwida luzyalo mwanawangu, mbuli mbwali sichisuntu ulokufwaba loko. Nkambo ukkala kawida mumulilo na mumaanzi. ");
INSERT INTO dov_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ndali mwetede kuli basikwiya bako, pesi tebamuponia pe.” ");
INSERT INTO dov_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu wakavwiila akwamba kuti, “Izyalane litasyomi akukakatila, ndiyooba achiindi chilamfu biyeni kandikkede andinywe? Ndiyoba andinywe kusika lili? Mumweete okuno kuli ndime.” ");
INSERT INTO dov_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesu wakalayilila dimoni, mpawo lyakazwa mulinguwe, amulombe wakaponesegwa kuzwa muhola eelyo. ");
INSERT INTO dov_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mpawo basikwiiya bakeza kuli Jesu kumbali akwaamb, Nkaambonzi nitwakachilwa kulitandila aanze?” ");
INSERT INTO dov_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu wakati kulimbabo, “Nkambo kalusyomo lwenu lunini. Nkambo ndamwambila kasimpe, kansyonga mulijisi lusyomo niluba lunini mbuli nseke yembuto yamusitada, nga ulambila chilundu eechi, Eenda kuzwa ano kuya okiiya, alimwi chiyoyeenda, takukwe chiyokachizya kuli nduwe.” ");
INSERT INTO dov_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Malembe mabotu achindi tajisi pe. Pesi oyu musyobo wadimoni tuyendi akuzwa kunze kwakukomba akulyiimya. ");
INSERT INTO dov_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kabachikede mu Galili, Jesu wakati kuli basikwiiya bakwe, “Mwana amuntu uyopegwa mumanza abantu, ");
INSERT INTO dov_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","alimwi bayomujaya, amubuzuba bwatatu uyobusigwa.” Basikwiya bakawusa kapati. ");
INSERT INTO dov_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Elyo nibakasika ku Kapenawuma, ibalumi ibakabweza zipanzi zibili zyamali yamutelo bakaza kuli Pita akwamba, “Sa muyiisi wanu tagwisyi zipanzi zyamali yamutelo? ");
INSERT INTO dov_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wakati, “Iyii ulatela.” Pesi Pita nakanjila mungánda Jesu wakaamba wati kuli nguwe chakusanguna akuti, “Uyeyaanzi, Sayimoni? Kuzwa kuliini bami baansi nkubabweza mutelo na bulumbu? Kuzwa kubana baabo na nkubeenzu?” ");
INSERT INTO dov_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita mpaakati, “kuzwa kubeenzu,” Jesu wakati kulinguwe, Pita wakasandula. “Lino bana bangununwa,” Jesu wakaamba. ");
INSERT INTO dov_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pesi kuti tutachiti basimutelo kuti bachite chibi, koya kulwizi, mukawaale kalobyo, akugwisya aanze inswi eyo itakazwe kutanguna. Na wajula mulomo wayo, ulajana Ishekkeli. Wibweze akwiipa basimutelo njiyangu ayako. ");
INSERT INTO dov_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kuchiindi eecho basikiiya bakaza kuli Jesu akwaamba kuti, “Ngwani mupati mubwami bwakujulu?” ");
INSERT INTO dov_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesu wakayiita kana kanini kulinguwe wakakkazika aakati kabo, ");
INSERT INTO dov_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","akwaamba kuti kasimpe ndamwaambilamkuti ado musanduke akuba mbuli kana kaniini takukwe nimunga muyoonjila mubwami. ");
INSERT INTO dov_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nkaambo kakaako, kufumbwa ulibombya mbuli mwana muniini nguumupati mubwami bwakujulu. ");
INSERT INTO dov_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kufumbwa utambula kana kaniini mbuli oobu muzina lyangu wambula ndime. ");
INSERT INTO dov_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pesi kufumbwa utuka umwi wabaaba baniini bamusyoma ulabalebya, chilabota mbubo kulinguwe kuti aangwe ndomba lyabbwe munsingo yakwe, akubbizigwa aakati kalwizi. ");
INSERT INTO dov_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Maawe kunyika nkaambo kazilebyo! Aboobo kuleelede kuti zilebyo zibe, pesi maawe kuli yooyo muntu weeta zilebyo! ");
INSERT INTO dov_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kuti luboko lwakp na chituta chako chikupa chilebyo, chigonke ukuwaalila kule anduwe, kuli mbubo, kunjila mubuumi koli chilema na kotyokede kwiinda kuowelwa mumulilo utamani koli aamaboko aabili na mawuulu aabili. ");
INSERT INTO dov_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na liso lyko likuchita kuba chilebyo, ulidadule ulisowele kule aanduwe. Kuli mbubo kuti unjle mubuumi aliso limwi kwiinda kusowelwa mubbila lyamulilo koli ameso aabili. ");
INSERT INTO dov_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Amuchenjele kuti utasmpawuuli umwi wabaaba baniini. Mbuli mbundaamba kulindinywe kuti kujulu kuli baangelo lyoonse balanga kubusyu bwa Taata uli kujulu. ");
INSERT INTO dov_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Malembe mabotu achi Giliki taajisi munchali ooyo ulaabupanduliuzi bujanika muli bumwi, nkaambo Mwana aamuntu wakaza kuzoofutula eecho chakasweekede. ");
INSERT INTO dov_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Uyeeyanzi? Kuti umwi uli aambelele mwaanda, mpawo iimwi yasweek, takonzyi kusiya zili makumi aali musanu aane azili musanu azine aatala aakalundu akuya kuyooyanduula eeyo isweekede? ");
INSERT INTO dov_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na wayijana, ndamwaambila kasimpe, ulabotelwa kwiinda eezyo zitasweekede. ");
INSERT INTO dov_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Munzila ikozyene, teesi kuyanda kwa Taata uli kujuliu kuti umwi wabaaba baniini kuti batafwidilili. ");
INSERT INTO dov_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kuti munyoko wakubisizya, koya ukamutapatile aakati kako anguwe luzutu. Na wakuswiilila, ulajana munyoko. ");
INSERT INTO dov_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pesi na takuswiilili, bweza umwi na bambi babili kuti milomo yababili na baka, mboni batatu lyoonse jwi lilazuminika. ");
INSERT INTO dov_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lino kuti wakaka kubaswiila, ambila mbungano, kuti wakaka alimwi kuswiilila mbungano, muleke aabe mbuli muhedeni akuba mbuli simutelo. ");
INSERT INTO dov_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ndamwaambila kasimpe, kufumbwa zintu nzimwaanga ansi zilaangwa akuju; lu, akufumbwa zyaangununwa ansi zilaanguununwa akujuliu. ");
INSERT INTO dov_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Alubo ndamwaambila na babili bazuninana atala achimwi nchibakumbila balachichitilwa a Taata uli kukulu ");
INSERT INTO dov_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20",". Aawa ali kobile na kotatu mpubabungene aamwi muzina lyangu, akooko ndinooli aakati kabo. ");
INSERT INTO dov_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Eelyo Pita waza akwaamba wati kuli Jesu, “Mwamio tungee mukwesu kandisizya nzyentimulekelele? Kusikila tuli musanu atubili! ");
INSERT INTO dov_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu wakati kuli nguwe, “Tandimwaambili tuli musanu atubili, kusikila kumakumi musanu aabili katupetedwe kusika kumusanu atubili. ");
INSERT INTO dov_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nkaambo kaako bwami Bwakujulu bulikozyene awumwi Mwami wakayanda kubamba makani aababelesi bakwe. ");
INSERT INTO dov_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mbuli mbwakasanguna kubamba, umwi wababelesi wakaletwa kuli nguwe iwakapedwe kkumi lyazyuulu zyamataalenta. ");
INSERT INTO dov_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pesi mbwatakajisi chakuliya, Mwami wakwe wakamulayilila kuti awuzigwe, antoomwe amwanakazi wakwe abana azyoonse nzyakaliya kuchitwe. ");
INSERT INTO dov_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mpawo mubelesi wakawida ansi, wavundama akwaamba wati, “Mwami ndikkazike moyo, lino ndilakuya yoonse. ");
INSERT INTO dov_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Lino Mwami wamubelesi mbukunga wamufwida wamufwida luzyalo wamwaangwida mpawo wamulekelela chikoloto. ");
INSERT INTO dov_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pesi mubesi ooyo wakeenda akujana umwi mubelesi wamunyina wakalijisi madinali mwaanda, wakamubweza, watalika kumusina akwaamba kuti ndiliye nzwakabweza kuli ndime. ");
INSERT INTO dov_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mpawo mubelesinyina wakawida ansio wamukumbila wati, “Ndikkazikile moyo, ndilakuliya. ");
INSERT INTO dov_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pesi mubelesi mutaanzi wakakaka. kwiinda, wakaya wakuya kuyoomuwalila muntolongo kusika akaliye nzyakali mupede. ");
INSERT INTO dov_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lino babelesinyina nibakabona zyakachika, bakawusa loko. Bakasika akwaambila mwami wabo zyoonse zyachitika. ");
INSERT INTO dov_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mpawo mwami wamubelesi wakamwiita wati kulinguwe, iwe numubesi mubi, ndakakulekelela chikoloto choonse nkaambo wakandikumbila. ");
INSERT INTO dov_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Waleleede kumufwida luzyalo mubelesinyokwe, mbuli mbundakakufwida luzyalo? ");
INSERT INTO dov_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mwami wakwe wakanyema akumupeda kuli basintolongo kusikila akaliye zyoonse nzyakabwezede. ");
INSERT INTO dov_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mbuboobo alakwe Taata wakujulu mbwayoomuchitila na temwalekelela munyoko kuzwa mumoyo. ");
INSERT INTO dov_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kwakaba kuti Jesu amane majwi ay, wakazwa ku Galili waya kuchisi cha Judiya mutala amulonga wa Jodani. ");
INSERT INTO dov_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Makamu makamu akamutobela, mpawo wakabaponia nkukoko. ");
INSERT INTO dov_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ba Falisi bakaza kuli nguwe, bamusunka, baamba kuli nguwe, “chili mumulawu kuti mwalumi aleke mwanakazi wakwe, katakwe kaambo. ");
INSERT INTO dov_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu wakasandula akwaamba, “sa temwakabala kuti oyo wakabalenga kuzwa kumatalikilo wakabalenga baalumi a abanakazi?” ");
INSERT INTO dov_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Alubo oyo iwakabelnga wakati, 'Nkambo kaako Mwalumi uyosiiya wisi abanyina akukakatila kumwanakazi wakwe, aba bobile babe nyama imwi. ");
INSERT INTO dov_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lino tabachili babili, pesi nyama imwi. Nkinkaako echo Leza nchakaswaniizya, kutabi muntu uchipambukanya.” ");
INSERT INTO dov_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bakati kulinguwe, “Nkaambonzi elyo Mozesi wakatulayilila kuti apegwe lugwalo lwakulekana mpawo amuleke?” ");
INSERT INTO dov_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wakati kuli mbabo, “Nkaambo kabuyumu bwamyooyo yenu, Mozesi wakamuzumizya kuleka banakazi benu, pesi kumatalikilo tekwakali munzila eyo pe. ");
INSERT INTO dov_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ndamwambila, kufumbwa uleka mwanakazi wakwe, kunze kwamakani abuvule, akuyo kwata uumbi, wachita bumambi; amwalumi ukwata mwanakazi wakalekwa wachita bumambi.” ");
INSERT INTO dov_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Basikwiiya bakati kuli Jesu, “Na kuti ntwaambo twamwalumi amwanakazi wakwe, tachili chibotu kukwata.” ");
INSERT INTO dov_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pesi Jesu wakati kuli mbabo, “Teensi bonse batambula kaambo aka, pesi kuli baabo luzutu bapedwe. ");
INSERT INTO dov_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nkambo nkubali bazibe bakachitwa bazibe abantu, alimwi mpubali bazibe bakalichita bazibe lwabo beni nkambo ka Bwami bwakujulu kuli ooyo ukonzya kutambula injiisyo eyi, muleke ayitambule.” ");
INSERT INTO dov_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lino bana baniini bakaletwa kuli nguwenkuti abaampe amaboko akukomba, pesi basikwiiya bakwe bakabakasya babakalalila. ");
INSERT INTO dov_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pesi Jesu wakaamba wati, “Amuzumizye bana banini, mutabakasyi kuti baze kuli ndime, nkambo Bwami bwakujulu mbubwabo bali boobu.” ");
INSERT INTO dov_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wakabika maboko aakwe alimbabo mpawo wakabasiya. ");
INSERT INTO dov_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Amubona, mwalumi wakaza kuli Jesu akwamba kuti, “Muyiisi, nchichili chintu chibotu nchindinga ndilachita kuti ndibe abuumi ibutamani?” ");
INSERT INTO dov_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu wakati kuli nguwe, Nkamboonzi niwandibuzya atala chitegwa nchibotu? Kunze kwachintu chimwi, pesi na koyanda kunjila mubuumi, baamba milayizyo.” ");
INSERT INTO dov_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Oyu mwalumi wakati kuli nguwe, milayizyo nzi?” Utajayi, utachiti bumambi, utabbi, utapi bukamboni bwakubeja, ");
INSERT INTO dov_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","lemeka wuuso abanyoko akuyanda ngoyakilene anguwe mbuli lwako omwini.” ");
INSERT INTO dov_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mwalumi mukubusi wakati kuli nguwe, “Zyoonse ezi zintu ndakazilemeka. Ndichiyanaanzi?” ");
INSERT INTO dov_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu wakamwambila wati, “Na koyanda kuti ulondoke, koya, ukawuzye lubono lwako, akuyopa bachete, mpawo uyooba abuvubi kujulu, lino uboole, unditobele.” ");
INSERT INTO dov_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pesi eelyo mwalumi mukubusi nakamvwa Jesu nzyakaamba, wakayinka kawuside, nkambo wakalijisi imbono nyiingi. ");
INSERT INTO dov_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesu wakaambila basikwiiya bakwe, “Kasimpe ndamwambila, nchiyumu kumuvubi kuti akanjile kubwami bwakujulu. ");
INSERT INTO dov_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Alimwi ndamwambila kuti, nkutete kunkamela kunjila muliso lyaneleti kwinda kuti muvubi anjile mubwami bwa Leza.” ");
INSERT INTO dov_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lino basikwiiya nibakamvwa oobo, bakagambilwa loko, akwaamba kuti, “Ino ngwani ukoonzya kuyofutulwa?” ");
INSERT INTO dov_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesu wakabalanga akwaamba kuti, 'kubantu tachikonzeki, pesi kuli Leza zintu zyoonse zilakonzeka.” ");
INSERT INTO dov_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Mpawo Pita wakavwiila akwamba kuti “Langa, twasiya zintu zyesu zyoonse twatobela nduwe. Ani mpawo tukajanenzi?” ");
INSERT INTO dov_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu wakati kuli mbabo, “Ndamwambila kasimpe kuti, muchiindi chiza Mwana a Muntu nayokkala achuno chakwe chabulemu, inywe nimwakanditobela muzokkala azyuno zilikkumi azibili, mukabeteke misyobo ili kkumi ayibili ya Izilayeli. ");
INSERT INTO dov_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Woonse oyo iwakasiide maanda, babunyiina, bachizi, wisi, banyina niiba myuunda nkambo kazina lyangu uyotambula tuli mbuli mwanda umwi akukona buumi ibutamani. ");
INSERT INTO dov_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pesi bataanzi baanji bayoba bakumamanino, abakumamanino bayoba batanzi. ");
INSERT INTO dov_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Nkambo bwami bwakujulu buli mbuli mwanimunda wakazwa kuseni loko kuyotamba basikubeleka mumuunda wakwe wamasansa. ");
INSERT INTO dov_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nikwakamana kuzuminana abasimulimu kudinali lyomwe abuzuba, wakabatuma kumunda wamasansa wakwe. ");
INSERT INTO dov_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Alubo wakenda chindi chamahola atatu mpawo wakabona bamwi basimilimu kabayimvwi kabatakwe nchibachita kubusena bwakuuzizya. ");
INSERT INTO dov_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kuli mbabo wakati, 'Anywebo, kamuya mumuunda wamasansa alubo ndilakumupa zilikabotu.' Nkako bakayinka kumulimu. ");
INSERT INTO dov_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Alimwi wakiinka kunze muhola lyamusanu alimwi amuhola lyamusanu aane, akuyochita chikozyenie. ");
INSERT INTO dov_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Limbi lubo kusika kuhola lyakkumi alimwi wakazwa alimwi wakujana bamwi balimvwi katakwe nchibalikuchita. ");
INSERT INTO dov_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wakati kulimbabo, 'nkambonzi nimwimvwi awa kamutakwe nchimulikuchita zuba lyoonse?' “Kulinguwe bakamba kuti, 'nkambo takwe pe watutambila mulimo.' “kulimbabo wakati, ánywebo lubo mwinke mumunda wamasansa.” ");
INSERT INTO dov_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lino nilyakaba golezya, mwani muunda wakati kumupati wamulimo, 'Yita basikubeleka alubo ubape bulumbu bwabo, utangune abasyalizi umane akumutaanzi.' ");
INSERT INTO dov_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Eelyo basimilimo bakanjila ahola lyakkumi alimwi bakeza, awumwi wabo wakatambula dinali. ");
INSERT INTO dov_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nibakeza basimulimo batanzi, bakalikuyeya kuti balatambula zyiingi, pesi abalabo bakatambula dinali lyomwe awumwi. ");
INSERT INTO dov_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nibakatambula bulumbu bwabo, bakasyoloka atala mwanimunda. ");
INSERT INTO dov_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bakati, 'Aba basimulimo basyalizi babeleka biyo hola lyomwe, pesi mwabachitila bvukozyenie andiswe, iswebo nitwaminwa buzuba bonse alubo muzuba lyuumpa obu.' ");
INSERT INTO dov_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Pesi mwanimunda wakavwiila umwi wabo wati, 'mwenzuma, takwe chibi nchindamuchitila. Temwazuminene andime na ku dinali lyomwe? ");
INSERT INTO dov_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Amubweze zyanu mwende enzila yanu. Ndasala kupa basimulimo basyalizi zikozyenie azyenu. ");
INSERT INTO dov_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tazili mumulawu na kuchita mbuli m bwenjanda achintu changu? Wabasibbivwe na nkambo ndimwabi?' ");
INSERT INTO dov_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nkinkako musyalizi uyoba mutanzi, amutaanzi uyoba musyalizi.” Malembe aansiku mabotu takwe banji bayitidwe, pesi basalidwe mbache. ");
INSERT INTO dov_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lino Jesu nakalikuya ku Jelusalema, wakabweza abalikkumi ababili kumbali, alubo munzila wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Amubone, tuyobuya ku Jelusalema, alubo Mwana Muntu nkwayowabwa mumaboko abapayizi bapati abalembi basimulawu. Bayomutama kusikila kulufu ");
INSERT INTO dov_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","alubo bayomutola kuli bamasi kuti bamuniake, akumuuma, akuyomubambula. Pesi mubuzuba bwatatu uyobusigwa.” ");
INSERT INTO dov_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mpawo banyina babana balombe ba Zebbediya bakaza kuli Jesu abana babo. Wakafugama aansi kunembo lyakwe alubo wakakumbila chimwi chintu kulinguwe. ");
INSERT INTO dov_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu wakati kulinguwe, “Niinzi ncholombozya?” wakati kulinguwe, “Layila bana bangu aba kuti bakkale, umwi kululyo umwi kulumwensi lwaluboko, mubwami bwako.” ");
INSERT INTO dov_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pesi Jesi wakasandula wati, “Tochizi nchokumbila. Ulakonzyana kunywa mukanywido nkindaamba kunywa?” Kulinguwe bakamba kuti, “Tulakonzya.” ");
INSERT INTO dov_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wakamba kuti kulimbabo, “Kanywido kangu mulakonzya kunywa. Pesi kukkala kululyo lwangu akuchimweensi tendime uupa pe, pesi nzizyabaabo bakabambilwa a Taata.” ");
INSERT INTO dov_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Elyo basikwiya bamwi balikkumi nibakachimvwa echi bakanyema kapati abaaba babunyina babili. ");
INSERT INTO dov_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pesi Jesu wakabita kulinguwe akwamba kuti, “mulizi kuti bendelezi babamaasi balabendelezya, abalabo bapati baabo babulemu bezyanisya nguzu zyabo alimbabo. ");
INSERT INTO dov_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pesi tazyelede kuti kube anzila eyo akati kenu. Anukuti, kufumbwa ulomboozya kuba mupati akati kenu abe mulanda wenu, ");
INSERT INTO dov_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","alubo kufumbwa ulombozya kuba mutanzi akati kenu welede kuba mulanda wenu, ");
INSERT INTO dov_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","mbuli Mwana Muntu mbatakazidide kukutawukilwa, pesi kukutawuka, akupa buumi bwakwe mbuli muulo wabingi.” ");
INSERT INTO dov_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nibakazwa ku Jelikko, inkamu mpati yakamutobela. ");
INSERT INTO dov_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kwakali balumi babili boofu bakakkede kumbali lyamugwagwa. Elyo nibakamvwa kuti Jesu walikwiinda, bakompolola, “Mwami, Mwana Davida, ba aluzyalo andiswe.” ");
INSERT INTO dov_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mbungano yakaba kalalila, bababuzya kuti bawumune, pesi bakakwila chakwindilila, “Mwami, Mwana Davida, ba luzyalo kulindiswe.” ");
INSERT INTO dov_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Mpawo Jesu wakayima alubo wakita kulimbabo wati, “ninzi nchimulombozya kuti ndimuchitile?” ");
INSERT INTO dov_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bakaamba kuti kulinguwe, “Mwami, kuti meso esu ajulike.” ");
INSERT INTO dov_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mpawo Jesu, kali wasungilizigwa aluzyalo, wakabaguma meso aabo, mpoonya awo bakatambula kubona akumutobela. ");
INSERT INTO dov_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Awo Jesu abasikwiya bakwe nibakasika ku Jelusalema alubo bakakusika ku Bbetipegi, kukalundu ka Olivusi, mpawo Jesu wakatuma basikwiya bakwe bobile, ");
INSERT INTO dov_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","wakati kuli mbao, “Kamuya kumunzi ulikunembo, alimwi muyofwambana kubona donki lyangidwe nkuko, alubo akana kelyo. Mwawangunune mwalete kulindime. ");
INSERT INTO dov_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kuti kwaba utabe achakwamba atala angawo, mukambe kuti, 'Mwami ulayanda,'alimwi oyo muntu uyofwambana kumupa ngawo. ");
INSERT INTO dov_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","'Lino kwakaba kuti ezyo zyakali zyambwa kwinda kumusinsimi zizuzikizigwe. Wakati, ");
INSERT INTO dov_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ambila mwana musimbi we Zioni, 'Langa, Mwami wanu ulaza kulindinywe, Ulibombede alimwi ulitantide a donki, Akukana ka donki, mwana we donki.” ");
INSERT INTO dov_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mpawo basikwiya bakinka bakuchita mbunya Jesu mbwakabalayililide. ");
INSERT INTO dov_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bakakuleta donki akana alubo bakabika zikobela zyabo a donki, alimwi Jesu Jesu wakakkala ajulu azikobela. ");
INSERT INTO dov_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Makamumakamu manji akayala zikobela zyabo mumugwagwa, alimwi bamwi bakagonka ntabi zyamisamu akuyobuyala mumugwagwa. ");
INSERT INTO dov_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mpawo makamu akenda kunembo lya Jesu alubo abaabo bakali kuyobutobela kabayobompolola, “Hosana kumwana wa Davida!” Ulongezezegwe ngoyo uuza muzina lya Mwami! Hosana kuli simajulu!” ");
INSERT INTO dov_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Elyo Jesu nakasika ku Jelusalema, idolopo lyoonse lyakali lyanyonganisigwa akwamba kuti, “Ngwani oyu?” ");
INSERT INTO dov_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Makamumakamu akasandula, “Oyu ngu Jesu musinsimi uzwa waku Nazaleta mu Galili.” ");
INSERT INTO dov_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mpwo Jesu wakanjila mungánda ya Leza. Wakaandilanze boonse abo bakali kuula akuuzya mungánda ya Leza, alubo wakasandamuna matafula abasikuzizya mali alubo azikkalo zyababo bakali kuzya nziba. ");
INSERT INTO dov_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wakati kulimbabo, “Kulilembedwe, 'Ngánda yangu iyowambwa kuti ngánda yakukambya; pesi mwayichita kuti ibe chikkalilo chababb.” ");
INSERT INTO dov_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mpawo mofu achilima bakeza kulinguwe mungánda ya Leza, alubo wakabaponya. ");
INSERT INTO dov_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pesi elyo bapayiza bapati alubo abalembi bamulawu nibakabona zintu nzyakachita, alubo elyo nibakamvwa bana balompolola mungánda yaLeza alubo balamba, “Hosana kumwana a Davida, “bakaba akunyema kupati. ");
INSERT INTO dov_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bakati kulinguwe, “Ulibamvwide na kuti balikutyeni Jesu wakati kulimbabo, “Iyii! Pesi takwe nimwakabalide, 'kuzwa kumilomo yabana banini atunyonka wakabamba intembawuzyo'?” ");
INSERT INTO dov_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mpawo Jesu wakabasiya alubo akuzwa mudolopo lya Bbetani akumana busiku nkuko. ");
INSERT INTO dov_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lino kuseni wakayinka nakali kujokela kudolopo, wakali waba anzala. ");
INSERT INTO dov_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nakabona mukuyu munsi lyamugwagwa, wakayinka kulinguwo akujana kakutakwe chintu kuli nguwo kunze kwamatu. Wakaamba kuti kulinguwo, “Kutakabi kuti kukabe michelo lubo kuzwa kulinduwe alimbi,” alubo mponya awo mukuyu wakapusama. ");
INSERT INTO dov_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Elyo basikwiya nibakawubona, bakagamba akwamba bati, “Ibiyeni mukuyu wapusama mpawonyaawa?” ");
INSERT INTO dov_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu wakasandula akwamba kulimbabo, “Masimpe ndamba kulindinywe, na mulijisi lusyomo alubo kamutadoneki, tamukwe nimuyochita zyakachitwa amukuyu biyo pe, pesi muyowamba nikuba kuchilundu echi, 'Zyukuka akuwalwa mulwizi; alubo ziyochitika. ");
INSERT INTO dov_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kufumbwa nchimuyolomba munkombyo, chakuzumina, muyozitambula.” ");
INSERT INTO dov_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Elyo Jesu nakasika mungánda yaLeza. Bapayizi bapati antomwe abapati babantu bakasika kulinguwe kali mukuyisya basikuti, “Anguzu nzi nzyochitya zintu ezi, alubo ngwani wakakupa nguzu ezi?” ");
INSERT INTO dov_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu wakasandula akwamba kulimbabo, “Ambebo ndilamubuzya mubuzyo umwi. Na mwandambila, ndiyomwambila kuti nkunguzunzi nzindichitya ezi. ");
INSERT INTO dov_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Lubbabbatizyo lwaJoni - nkukuli nkulwakazwa? Lwakazwa kujulu na kuti nkubantu?” Bakambuzyania akati kabo, bakati, ");
INSERT INTO dov_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Na tutedi, Luzwa kujulu,' Ulamba kuti kulindiswe, 'Nkambonzi mpo nimwakatamusyoma?'Pesi na tutedi nkubantu,'tuyowa nkamu yabantu nkambo boonse babona Joni mbuli musinsimi.” ");
INSERT INTO dov_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mpawo bakasandula Jesu alubo bati, “Tatuzi pe.” Wakamba alimwi kulimbabo, “Nsikwe nensikamwambile ambebo kuti ninguzunzi nzindichitya azyozintu ezi. ");
INSERT INTO dov_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pesi muyeyaanzi mwalumi wakali abana balombe babili. Wakaya kumutanzi alubo wakati, “mwanangu, koya ukabeleke sunu mumunda wamasansa. ");
INSERT INTO dov_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Mwana wakasandula wati, “Tandiinki, pesi mukuya kwachiindi wakasandula mizezo yakwe wakinka. ");
INSERT INTO dov_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mpawo mwalumi wakaya kumwana wachibili akwamba chintu chikozyenie. Wakasandula wati, 'Ndilayinka, 'Ta; pesi takwe nakinka pe. ");
INSERT INTO dov_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nguuli mubana babili aba wakachita kuyanda kwawisi?” Bakati, “Mutanzi.” Jesu wakati kulimbabo, “Masimpe ndaamba kulindinywe, basimutelo abasimamambe bayonjila mubwami bwa Leza kamutana kunjila. ");
INSERT INTO dov_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nkambo Joni wakeza kulindinywe minzila yabululami, pesitemwakamusyoma pe. Pesi basimutelo abasimamambe bakamusyoma. Pesi nywebo, nikuba elyo mwakazibona ezi, temwakeempwa mukuya kwachindi alubo temwakamusyoma. ");
INSERT INTO dov_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Amuswilile kuli ambi mambilambali. Kwakali umwi mwalumi, mukamwini munda wakabyala masansa, wakayaka lubaya alinguwo; wasikusya chikandilo mukati kawo, wayaka ngánda yamujulu, alubo wakayiboleka kuli basikulima masansa. Mpawo wakaya kulichimwi chisi ");
INSERT INTO dov_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Elyo chiindi chakutebulwa kwamasansa nichakasika, wakatuma bamwi babelesi kuli basikulimina masansa kuti bakabweze michelo yakwe. ");
INSERT INTO dov_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pesi basikulimina masansa bakabweza babelesi bakwe bawuma umwi, bajaya awumwi, alubo bamutulula mabwe. ");
INSERT INTO dov_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Alubo, mwanimunda wakatuma bambi babelesi bayingi kwinda batanzi, pesi basikulimina masansa bakabajata zikozyenie. ");
INSERT INTO dov_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kwiinda awo, mwanimunda wakazotuma mwanakwe kulimbabo, kuti, 'Bayo mulemeka mwanangu. ");
INSERT INTO dov_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Pesi elyo balimi bamasansa nibakabona mwana, bakati akati kabo, 'Ngoyu sikukona. Mubole, muleke tumujaye akubweza lukono. ");
INSERT INTO dov_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'Nkinkako bakamubweza, bamusowela kunze amuunda akumujaya. ");
INSERT INTO dov_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Lino elyo mwanimunda asika, ninzi nchayochita abo balimi bamasansa?” ");
INSERT INTO dov_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bakati kulinguwe, “Uyonyonyona abo baalumi babuyo muli imwi nzila njumu, alubo uyobatandila aanze amuunda akubika bambi basikulimina masansa, bantu bayomupa chabilo chazilimwa kuchiindi chakuyebula.” ");
INSERT INTO dov_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesu wakati kulimbabo, “Sena temwakabala mumalembe, Íbbwe bayaki ndibakakaka lyakachitwa munsemo. Echi chakazwa ku Mwami, alubo zilagambya mumeso esu'? ");
INSERT INTO dov_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nkinkako ndamba kuti kulindinywe, bwami bwa Leza buyobwezwa kuzwa kulindinywe akuyopegwa kuchisi chiyopanga michelo yacho. ");
INSERT INTO dov_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kufumbwa uwida atala abbwe eli ulakutyoka kuba tumpanzi, pesi umwi ngulitawide atala ulakupwasuka.” ");
INSERT INTO dov_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Elyo bapayizi bapati aba Falisi nibakamvwa mambilambali akwe, bakamvwisisisya kuti wakalikwamba ataala ambabo. ");
INSERT INTO dov_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bakayandula kumwanga, pesi bakayoowa makamu abantu, nkambo bantu bakali mujisi mbuli musinsiimi. ");
INSERT INTO dov_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesu wakambula lubo kulimbabo mumambila mbali wakati, ");
INSERT INTO dov_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bwami bwakujulu buli mbuli umwi mwami wakabambila ipobwe lyakukwatana lyamwanakwe. ");
INSERT INTO dov_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wakatuma babelesi bakwe kuyoyita abo bakatambidwe kuti baze kupobwe pesi tebakasika. ");
INSERT INTO dov_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Alimwi mwami wakatuma bambi babelesi, kuti, bambile aabo batambidwe, “Mulange, ndabambilila chisusulo chabasune bangu angómbe zyangu zinenede zyajayigwa, alubo zintu zyoonse zyabizwa. Muze kupobwe lyalukwatano.” ");
INSERT INTO dov_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pesi tebakaswilila pe alimwi bakainka, umwu kumunda wakwe mupati, awumwi kumakwebo akwe. ");
INSERT INTO dov_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Bamwi bakajata babelesi ba Mwami, bakabajata enzila ifwisya nsoni, akubajaya. ");
INSERT INTO dov_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mwami wakanyema, akutuma basilumamba bakwe akuyonyonyona aabo bajayi akubawumpila dolopo lyabo. ");
INSERT INTO dov_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Mpawo wakati kubabelesi bakwe, kuswanizigwa kwazulila, pesi abo bakatambidwe tebakali kwelela. ");
INSERT INTO dov_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aboobo kamuya mumanzanino anzila akuyotamba bantu banji kupobwe lyakukwatana mbuli mbimutajane.' ");
INSERT INTO dov_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Babelesi bakayinka enzila akubunganya antomwe bantu boonse mbibakajana, bonse babi ababotu. Nkinkako ngánda yepobwe lyakukwatana yakazozula abantu. ");
INSERT INTO dov_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pesi Mwami nakasika mukati kuzolanga batambidwe, wakabona kakuli mwalumi wakatazwete zizwato zyapobwe lyalukwatano. ");
INSERT INTO dov_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mwami wakati kulinguwe, Mwenzuma, wanjila byeni omuno kotasamide zizwato zyapobwe lyalukwatano?'Pesi mwalumi wakabula alyakwamba. ");
INSERT INTO dov_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mpawo mwami wakati kubabelesi, 'mumwange mwalumi oyu kumaboko akumawulu, alubo mumusowele aanze mumudima, oko kunoli kulila akuluma ntwino.' ");
INSERT INTO dov_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nkambo mbingi bantu batambidwe, pesi mbache biyo basalidwe.” ");
INSERT INTO dov_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mpawo baFalisi bakinka akuyobamba mbubatamuche Jesu kuzwa kungambwido yakwe. ");
INSERT INTO dov_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mpawo bakatuma kulinguwe basikwiya babo, antomwe abaka Helodiya. Bakati kuli Jesu, 'Ómuyisyi, tulizi kuti uli wakasimpe, alubo kuti uyiisya nzila yaLeza mubwini. Tomvwi miyeyo yawumwi pe alubo totondezya kusiyanisya pe akati kabantu. ");
INSERT INTO dov_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mpo kotwambila, uyeyanzi? Zili mumulawu na kubbadala mutelo kuli Siza na pe?” ");
INSERT INTO dov_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pesi Jesu wakamvwisisisya bubi bwabo wakati, “Nkambonzi nimundisunka, nywebo nobasikuupawupa? ");
INSERT INTO dov_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Munditondezye mali yabbwe yamutelo.” Mpawo bakamwetela dinali kulinguwe. ");
INSERT INTO dov_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesu wakati k ulimbabo, “Ngwani ulachechi chikozyanisyo e zina?” ");
INSERT INTO dov_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bakasandula kuti, “nzizya Siza.” Mpawo Jesu wakati kulimbabo, “alimwi amupe Siza zintu zya Siza, alubo kuli Leza zintu zya Leza.” ");
INSERT INTO dov_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Elyo nibakazimvwa, bakagamba. Mpawo bakamusiya akwenda. ");
INSERT INTO dov_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mubuzuba oobo bamwi ba Sadusi, abo baamba kuti takwepe bubuke bwabafu, bakeza kulinguwe. Bakamubuzya, ");
INSERT INTO dov_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","kabati, 'Muyisyi, Mozesi wakatedi, “Na mwalumi wafwa, kataside bana, mukulana wakwe welede kukwata banakwe akumujanina bana mukulana wakwe. ");
INSERT INTO dov_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kwakali bakulana bali musanu ababili. Mutanzi wakakwata mpawo wakafwa katasiide bana, wakasiya mwanakazi wakwe kumwanike wakwe. ");
INSERT INTO dov_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Alimwi alakwe mwanike wachibili wakachita chintu chikozyania, mpawo awatatu, mulongo woonse kusikila kuli wamusanu ababili. ");
INSERT INTO dov_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kwinda kwabo boonse, mwanakazi wakazofwa. ");
INSERT INTO dov_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lino kububuke bwabafu, ngwani utakabe mwani mwanakazi mubakulana bali musanu ababili? Nkambo boonse bakali mukwete.” ");
INSERT INTO dov_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pesi Jesu wakbasandula akuti kulimbabo, “Nywebo muliswekede, nkambo tamuzi malembe naa inguzu zya Leza. ");
INSERT INTO dov_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nkambo mububuke bwabo takwe nekuba kukwata nikuba kukwatisigwa. Anukuti, bayoba mbuli baangelo bali kujulu. ");
INSERT INTO dov_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pesi atala abubuke bwabafu, temwakabala na zyakaambwa kulindinywe a Leza, kuti ");
INSERT INTO dov_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ndime Leza wa Abbulahamu, Leza wa Ayizeki, alimwi Leza wa Jakobo'? Leza teensi Leza wabafwide, pesi waba pona.” ");
INSERT INTO dov_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Eelyo makamu nakamvwa eezi, bakagamba kunjiisyo zyakwe. ");
INSERT INTO dov_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pesi ba Falisi nibakamvwa kuti Jesu wakawumuzya ba Saduki, bakalibungania lwabo beni antomwe. ");
INSERT INTO dov_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Umwi wabo, uyiide zyamulawu, wakamubuzya mubuzyo, kumusunka - ");
INSERT INTO dov_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Muyiisi, nguuli mulayizyo mupati mumulawu?” ");
INSERT INTO dov_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu wakati kulinguwe “Yanda Mwami Leza wako a moyo woonse, alubo amiyeyo yako yoonse.' ");
INSERT INTO dov_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Oyu ngomulazyo mupati alubo ngomutanzi. ");
INSERT INTO dov_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Alimwi awabili mulayizyo ulimbuli oyu - Ýanda mwenzinyokwe mbuli mboliyanda lwako.' ");
INSERT INTO dov_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Amilawu eyi ibili mpokuzulila mulawu woonse abasinsimi.” ");
INSERT INTO dov_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lino ba Falisi nibakachibungene antomwe, Jesu wakababuzya mubuzyo. ");
INSERT INTO dov_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Wakati, “muyeeyanzi aatala a Kkilisito? Mwana wani?” Bakamusandula, “mwana wa Devidi.” ");
INSERT INTO dov_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu wakati kulimbabo, “Biyeni mpo Devidi mumuuya ulamwiita kuti Mwami, kaamba, ");
INSERT INTO dov_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Mwami wakati ku Mwami wangu. “Kkala kuluboko lwangu lwachilisyo, kusikila ndayita basinkonyokwe chikkalilo chamawulu ako”? ");
INSERT INTO dov_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kuti Devidi wakiita Kkilisito kuti 'Mwami,' nkambonzi nali mwana wa Devidi?” ");
INSERT INTO dov_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Takwe wakakonzya kumusandula jwilyomwe, alubo takukwe wakachili kuyanda kumubuzya imbi mibuzyo kuzwa elyo zuba. ");
INSERT INTO dov_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mpawo Jesu wakambuula kubbunga lyabantu alimwi akuli basikwiiya bakwe. ");
INSERT INTO dov_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Wakati, “Balembi aba Falisi bakkala muchuno cha Mozesi. ");
INSERT INTO dov_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nkiinkako kufumbwa nchibamulayilila kuchita amuchite nzizyo akuzibeleka. Pesi mutakatobelezyi inchito zyabo pe, nkambo baambula zintu nzibatachiti pe. ");
INSERT INTO dov_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iyii, balabamba mitolo miyumu kukwinyampula, alimwi balabikkala amakkuko aabantu. Pesi bo lwabo tabanyampuli pe kanwe kabo kuti banyampule. ");
INSERT INTO dov_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Balachita zyoonse nzibachita kuti babonwe abantu. Balalichitila zipati alimwi balakomezya myoombe yezibaki zyabo. ");
INSERT INTO dov_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bayanda zyuuno zyabapati kumapobwe alimwi azyuuno ezyuuno zyabapati muzikombelo, ");
INSERT INTO dov_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","alimwi bayanda injuzyo zilikabotu muzisambalilo, alimwi akwiitwa kuti 'Mwami'abantu. ");
INSERT INTO dov_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pesi inywebo tamwelede pe kwitwa kuti 'Mwami' nkambo mulijisi umwi alimwi nywebo moonse mulibabunyina. ");
INSERT INTO dov_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Alimwi mutayiti muntu anyika ansi aano kuti Taata, nkambo mulawe omwe Taata, alimwi ulikujulu. ");
INSERT INTO dov_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nikuba kuti ngamulategwa muyiisi, nkambo mulijisi muyisi umwi luzutu, Kkilisitu. ");
INSERT INTO dov_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pesi oyo mupati akati kenu uyoba mulanda wenu. ");
INSERT INTO dov_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nikuba nabaani ulisumpula uyofwinsigwa, alimwi nikubaani ulifwinsya uyosumpulwa. ");
INSERT INTO dov_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pesi maawe kuli ndinywe, nobalembi alimwi abaFalisi, nobasikuupawupa! mulajala abwami bwakujulu kubantu. ");
INSERT INTO dov_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nkambo tamunjili pe nywebo, alimwi tamukwe nimubazumizya aabo abayanda kunjila kuti banjile. ");
INSERT INTO dov_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Maawe kulindinywe, nobalembi alimwi nobaFalisi, basikuupawupa! nkaambo muulya zintu zili mumaanda abamukabafu kamukomba nkombyo ndamfu. Muyotambula mulandu mupati. Maawe kulindinywe, nobalembi alimwi nobaFalisi, basikuupawupa! Nkambo mulayinka akulwizi alimwi akunyika kuti mukasandule muntu umwi, alimwi na waba oyo umwi, ngamwamuchita tubili kuba mwana wegehena mbuli ndinywe. ");
INSERT INTO dov_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Maawe kuli ndinywe, nobeenzyi baboofu, inywe nimuti, “Ooyo ukonka antempele takwe pe. Pesi ooyo ukonka angolida zyantempeli, ulangidwe kuchizuminano chakwe. ");
INSERT INTO dov_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Inywe noboofu bafubafuba! Niinzi chipati, ingolida nikuba ntempeli eyo ichita ngolida kuti isalale? ");
INSERT INTO dov_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Alimwi, óyo ukonka kuchipayililo, takukwepe. Pesi ooyo ukonka echo chili achipayililo, ulaangidwe kuchizuminano chakwe. ");
INSERT INTO dov_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Inywe nobantu boofu, Niinzi chipati, ichipo nikuba chipayililo eecho chichita kuti ichipo chisalale? ");
INSERT INTO dov_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eelyo, ooyo ukonka kuchipayililo ukonka nchiicho alimwi azyoonse ezyo zili alinchicho. ");
INSERT INTO dov_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ooyo ukonka kuntempeli ukonka njiiyo alimwi ayooyo ukkala mukati. ");
INSERT INTO dov_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Alimwi ayooyo ukonka akujulu ukonka achuuno chabulemu bwa Leza alimwi ayooyo ukkala alinchiicho. ");
INSERT INTO dov_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Maawe kulindinywe nobalembi alimwi anoba Falisi basikuupawupa! Nkambo mulapayizya chakumi chazisyu zyachinsyungwa abbonko akanyansya, pesi mwasiya akutachita zintu zipati ezyo zyaamba mulawu- bwendelezi bubotu alimwi aluzyalo mpawo alusyomo. Pesi eezi mwalelede kuti naka mwazichita alimwi akutasiya nikuba chimwi chanzizyo. ");
INSERT INTO dov_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Inywebo nobasikwenzya boofu, mulatingwa akawuka pesi mumena inkamela! ");
INSERT INTO dov_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Maawe kulindinywe, nobalembi alimwi aba Falisi, basikuupawupa! Nkaambo musanzya inkomeki kunze kwayo mpawo andyido, pesi muzili mukati zilizwide kutangala akutayendelezegwa kabotu. ");
INSERT INTO dov_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Inywe noba Falisi boofu! Musanzye muzili mukati nkomeki sansina amukati kandyido, kuchitila kuti kunze kusambe akulako. ");
INSERT INTO dov_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Maawe kulindinywe, nobalembi aba Falisi basikuupawupa! Nkaambo mulimbuli tubanda tulambidwe amilambo ituuba, eezyo zilangiika kubota anze, pesi mukati zizwide mafuwa abantu bakafwa alimwi azyoonse zyamudima. ");
INSERT INTO dov_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Munzila njiyeeyo, anywebo aanze kwanu muli mbuli bantu baluleme kubantu, pesi mukati mulizwide kuupawupa ameso alimwi abubi. ");
INSERT INTO dov_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Maawe kulindinywe, nobalembi aba Falisi, basikuupawupa! Nkaambo mulayaka tubanda twabasinsiimi alimwi akubotezya tubanda twabaluleme. ");
INSERT INTO dov_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mwamba kuti, “Kwanoli twakaliko mumazuba abamataata, nikuli tetwakabape mulibaabo bakatila bulowa bwabasinsiimi.' ");
INSERT INTO dov_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nkinkaako mulalyaamba nobeeni kuti muli bana babaabo bakajaya basinsiimi. ");
INSERT INTO dov_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Alimwi mwazuzikizya bulemu bwabamawuso. ");
INSERT INTO dov_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Inywe nobazooka, inywe nobana bachipile, muyokuchija biyeni kubetekwa kwagehena? ");
INSERT INTO dov_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nkambo kako, amubone, ndamutumina basinsimi abalumi basongo alimwi abalembi. Bamwi babo muyobajaya akubagankamina, alimwi bamwi muyobakwipawula muzikombelo zyenu alimwi muyobatanda kuzwa kumunzi akumunzi. ");
INSERT INTO dov_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Impindu njakuti andinywe kuyozwa bulowa boonse bwabataluleme oobo bwakatika enyika, kuzwa kubulowa bwa Abbelu mululami, domane kubulowa bwa Zakkaliya mwana wa Bbelekkiya, ooyo ngumwakajaya akati kantempeli achipayililo. ");
INSERT INTO dov_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kasimpe ndamwambila, zintu eezi zyoonse ziyozida aabo bapona sunu ");
INSERT INTO dov_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jelusalema, Jelusalema, inywe nimujaya basinsiimi alimwi akudonkola aabo batumwa kuli nduuwe! Ndakaliswini kuyanda kubunganya bana bako antoomwe, mbuli inkuku mbifukatila twana twayo munsi lyamababa ayo, pesi tewakazumina pe! ");
INSERT INTO dov_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Amubone, ngánda yenu yachaala kulindinywe yaba mbulitongo. ");
INSERT INTO dov_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Alimwi ndamwambila, tamuchizondiboni pe kuzwa lino dokusikila mukaambe kuti, uulachoolwe ooyo uuza muzina lya Mwami.” ");
INSERT INTO dov_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesu wakazwa aanze achikombelo weenda. Basikwiiya bakwe bakeza kulinguwe kuzomutondezya mayake achikombelo. ");
INSERT INTO dov_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pesi wakabasandula wati kulimbabo, “Tamuzibwene pe zintu eezi zyoonse? Nkasimpe ndamwambila, takukwe ibbwe liyochala atala alimwi litakwe kuyobwalwa aansi.” ");
INSERT INTO dov_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nakachikkede atala lyechilundu cha Olivusi, basikwiiya bakamusikila kumbali bati, “twambile, ndilili nikuyochitika zintu eezi? Ninzi chiyoba chitondezyo chakuboola kwaako alimwi amamanino anyika?” ");
INSERT INTO dov_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu wakabasandula wati kulimbabo, “Amuchenjele kuti kutabi umwi umusowa. ");
INSERT INTO dov_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nkaambo kuyozwa bayingi muzina lyangu. Bayowaamba kuti, 'ndindime Kkilisito, álimwi bayosowa bantu bayingi. ");
INSERT INTO dov_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","'Muyomvwa nkondo azyaambo zyankondo. Amukalange kuti zitakamukatazyi pe, alimwi eezi zintu zyeelede zichitike; pesi mamanino katanakuba pe. ");
INSERT INTO dov_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nkambo inyika iyobukila nyikanyina, alimwi bwami abwaminyina. Kuyoba nzala alimwi amuzuzumina wenyika mumabazu asiyene siyene. ");
INSERT INTO dov_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pesi zintu ezi zyoonse matangunino biyo amachise amuntu sikutumbuka. ");
INSERT INTO dov_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Elyo bayomutola kukwezegwa akuyomujaya. Muyosulwa enyika zyoonse akambo kezina lyangu. ");
INSERT INTO dov_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Eelyo bantu bayingi bayobukilwa, alimwi akwaba umwi awumwi akusulana umwi awumwi. ");
INSERT INTO dov_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Basinsiimi bayingi babeji bayoza akuzosowa bayingi. ");
INSERT INTO dov_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nkambo bupapi buyovula, luyando lwabayiongi luyotontola. ");
INSERT INTO dov_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pesi oyo uyokakatila kusikila kumamanino uyofutulwa. ");
INSERT INTO dov_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ayamakani mabotu abwami ayokawukwa munyika yoonse mbuli bukamboni kumanyika oonse. Eelyo mamanino ayosika. ");
INSERT INTO dov_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Lino, nimuzobona chisesemyo chisisidwe, chaakambwa a Daniyele musinsiimi, kayiimvwi mubusena busalala” ( ooyo ubala amvwisisisye). ");
INSERT INTO dov_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Amuchite kuti aabo balimuJudiya bachijile kuzilundu, ");
INSERT INTO dov_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ooyo uli achiluli changanda ataseluki aansi kuzobweza nikuba chimwi chintu chilimungánda, ");
INSERT INTO dov_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","alimwi amuchite ooyo ulimumuunda aleke kujokela kuzobweza chakusama chakwe. ");
INSERT INTO dov_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pesi maawe kubabo bamintide akuli baabo banyonsya bana mumazuba aayo! ");
INSERT INTO dov_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Amukombe kuti kuchija kwenu kutakabi muchindi champeyo nikuba mubuzuba bwasabata. ");
INSERT INTO dov_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nkambo kuyoba mapenzi mapati loko, aayo atana kubonwa pe kuzwaida kumasangunino anyika kuzosikila lino, pe, takwe nikuzoba zili mbubobu pe. ");
INSERT INTO dov_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nakuti mazuba aayo pesi afwinsigwa, tekwali kunooba naba muntu walikuzofulwa. Pesi nkambo kabasale aayo mazuba ayofwinsigwa. ");
INSERT INTO dov_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lino kuti umwi muntu wamba kulindinywe kuti, 'Langa, ngoyu Kkilisito!'mutakamuzuminini pe akuzisyoma. ");
INSERT INTO dov_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nkambo baKkilisito bakubeja abasinsimi babeji bayosika akuchita malele mapati azigambyo, kuti baleesye, nikuba, aabo basale. ");
INSERT INTO dov_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Amubone, ndamwambila kazitana kuchitika pe. ");
INSERT INTO dov_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Lino kuti baamba kuti kulindinywe, 'Mulange, ulimunkanda, 'mutakayinki pe oko kunkanda. Nikuba kuti, 'mulange, mwali mungánda zyamukati, 'mutakasyomi pe. ");
INSERT INTO dov_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mbuli lulabi mbulumweka kuzwa kubuzwezuba alimwi lulamvwikkila koonse kusikila kububbila, oko kuyoba nkuboola kwa Mwana Muntu. ");
INSERT INTO dov_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Oko kuli munyama ufwide, nkukubungene makubi. ");
INSERT INTO dov_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Pesi mpawawo kwakumana mazuba amapenzi aya izuba liyosiya, mweezi tuchiko kuyopa mumuni pe, inyenyezi ziyoowa kuzwa kujulu, alimwi manguzu ejulu ayotikinisigwa. ");
INSERT INTO dov_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lino chitondezyo cha Mwan a Muntu chiyoboneka mujulu, alimwi misyobo yoonse iyolila. Bayomubona Mwana a Muntu kalikuza atala lyamayoba akujulu anguzu alimwi abulemu bupati. ");
INSERT INTO dov_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Uyotuma baangelo bakwe akulila kwamweembo, alimwi bayobunganya antomwe basale bakwe kuzwa kumabazu aane, kuzwa kumpela imwi kuyosika kumpela yomwe yakujulu kusikila kuliimwi. ");
INSERT INTO dov_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Amwiiye chiiyo kuzwa kumukuyu. Aawo mutabi nuuba muteete akusyuuka matu, ngamwaziba kuti mayiinza abafwifwi. ");
INSERT INTO dov_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lino zilikozyenie, naa mwabona zintu ezi zyoonse, mweelede kuziba kuti waba afwifwi, amulyango loko. ");
INSERT INTO dov_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nchobeni ndamwambila, izyalani eeli talikoyomana pe kazitanachitika pe zintu eezi. ");
INSERT INTO dov_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ijulu anyika ziyomana, pesi majwi aangu takwe natakamane pe. ");
INSERT INTO dov_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pesi takukwe uuzi buzuba nikuba chiindi niziyochitika eezi, nikuba baangelo bakujulu, nikuba Mwana a Muntu, pesi Taata alike. ");
INSERT INTO dov_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mbuli kumazuba a Nowa, mbukuyooba kubola kwa Mwana a Muntu. ");
INSERT INTO dov_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mbuli kumazuba kakutana boola zambangulwe bakali kulya alimwi akunywa, kabakwatana akukwatanisigwa kusikila kubuzuba Nowa mbwakanjila mubwato., ");
INSERT INTO dov_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","alimwi takukwe anchibakalizi pe kusikila izambangulwe lyabatola - lino mbukuyoba kusika kwa Mwana a Muntu. ");
INSERT INTO dov_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Eelyo bantu babili banoli mumuunda - umwi akati kabo uyobwezegwa, alimwi umwi uyosiigwa. ");
INSERT INTO dov_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Banakazi babili banoli kabaziiya aziiyo - umwi akati kabo uyobwezegwa, alimwi umwi uyosiigwa. ");
INSERT INTO dov_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nkinkaako amuchenjele, nkambo tamuzi pe buzuba Mwami wenu nayoboola. ");
INSERT INTO dov_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pesi amuzizibe eezi, kuti kwanoli mwani ngánda walizi chindi akati kamansiku sikubba namusikila, walikuno lindide alimwi talikunoleka ngánda yakwe pe kuti itululwe. ");
INSERT INTO dov_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nkinkaako anywebo mulelede kulibambila, nkambo Mwana Muntu uyobola muchiindi nchimutalangilide pe. ");
INSERT INTO dov_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Lino nguuli mulanda usyomekede alimwi kalimusongo ooyo wakabikwa asimalelo wakwenkuti abaambe ngánda yakwe kuchitila kuti abape chakulya kuchiindi cheelede? ");
INSERT INTO dov_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Uli achoolwe ooyo mulanda uyojanwa kachita oobo. ");
INSERT INTO dov_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nkasimpe, ndamwambila kuti simalelaakwe uyomubika kuti akabambe zintu zyoonse. ");
INSERT INTO dov_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pesi mulanda mubi kuti waamba eezi mumoyo wakwe, 'Simalelaangu wanonoka, ");
INSERT INTO dov_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","alimwi akatangune kuuma balanda bakwe, alimwi kulya akunywa azidakwa, ");
INSERT INTO dov_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","lino simalelaakwe ooyo mulanda uyosika mubuzuba ooyo mulanda mpatalibambilide pe alimwi achindi nchatazipe. ");
INSERT INTO dov_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Simalelaakwe uzomugonkola goonkola akumwaaba kubusena kuti bakabe aamwi abasikuupawupa, ooko kuyoba kulila akuluma ntwino. ");
INSERT INTO dov_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Lino bwami bwakujulu buyokozyanisigwa abasimbi balikkumi bakabweza malampi aabo alimwi bayinka kuyochinga simusa. ");
INSERT INTO dov_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Balimusanu baabo bakali bafubafuba alimwi balimusanu bakali basongo. ");
INSERT INTO dov_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Aawo basimbi bafubafuba nibakabweza malampi aabo, tebakabweza pe mafuta aabo. ");
INSERT INTO dov_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pesi basimbi basongo bakabweza mafuta aabo muzibikilo. ");
INSERT INTO dov_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lino simusa wakanonoka, boonse bakaguna alimwi bakoona. ");
INSERT INTO dov_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pesi akati kabusiku kwakamvwigwa ikongolola, Ámulange, simusa! Amuzwe aanze alimwi mukamuchinge akumutambula. ");
INSERT INTO dov_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Éelyo basimbi boonse bakabuka alimwi bayasya malampi aabo. ");
INSERT INTO dov_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bafubafuba bakaamba kuti kubasongo, 'mutwabile amwi mafuta aanu nkambo malampi esu azima.' ");
INSERT INTO dov_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Pesi bo basongo bakasandula kuti, 'mbokunga takotukwanina swebo andinywe, amwinke kuli baabo basambala alimwi mukalyulile eenu nobeni. ");
INSERT INTO dov_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Áawo nubakachili kukuyowula, simusa wakasika, alimwi aabo bakalibambilide bakayinka aawe kupobwe, alimwi imulyango wakajalwa. ");
INSERT INTO dov_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kumane boobu bamwi basimbi abalabo bakaboola alimwi baamba kuti, “Simalelo wesu, Simalelo wesu, tujulile.' ");
INSERT INTO dov_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Pesi wakabasandula alimwi wakati, 'Nchobeni ndamwambila, tandimuzi pe. ");
INSERT INTO dov_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nkinkaako amuchenjele, nkambo tamulizi izuba nikuba ichindi. ");
INSERT INTO dov_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Zyakozyania amwalumi wakali afwifwi akuya munyika iimbi. Wakayita balanda bakwe alimwi wabaabila buvubi bwakwe. ");
INSERT INTO dov_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Umwi wakamupa matalenta alimusanu, mpawo umwi wakamupa aabili, alimwi umbi lubo wakamupa limwi talenta. Umwi awumwi wakatambula eecho chendelana ambuli mbakonzya, mpawo mwalumi ooyo wakeenda mulweendo lwakwe. ");
INSERT INTO dov_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ooyo wakatambula matalenta alimusanu wakeenda wakubuka akwabelesya mpawo wakabbindawuka ambi alimusanu. ");
INSERT INTO dov_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mbuboobo, oyo wakatambwide aabili alakwe wakabbindawuka wajana aambi aabili. ");
INSERT INTO dov_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pesi oyo mulanda wakalalimwi wakeenda, wakusya kkomba mulubuwa, alimwi wakasisa mamali asimalelaakwe. ");
INSERT INTO dov_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Lino mumazuba simalelo wabalanda aaba boonse wakaboola wazolangalanga myeelwe yabuvubi antomwe ambabo balanda bakwe. ");
INSERT INTO dov_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mulanda oyo wakatambwide matalenta alimusanu wakaboola alimwi weeta aambi alimusanu. Wakamba kuti, 'Simalelo wangu, Langa, ndakakubbindawuka aambi alimusanu. ");
INSERT INTO dov_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Simalelaakwe wakati kulinguwe, 'wakachita kabotu, iwe nomulanda mubotu alimwi usyomeka! Walikusyomeka muzintu ziche. Ndiyokubika kuti ukeendelezye zintu zyiingi. Njila mubusekelezi bwasimalelaako.' ");
INSERT INTO dov_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ooyo mulanda wakatambwide matalenta aabili wakaboola waamba kuti, 'Simalelo wangu, wakandipa matallenta aabili. Langa, ndakabbindawuka aambi abili lubo. ");
INSERT INTO dov_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Simalelo wakwe wakati kuli nguwe, 'wakachita kabotu, iwe numulanda mubotu alimwi usyomeka! Walikusyomeka muzintu ziche. Ndiyokubika kuti ukeendelezye zintu zyiingi. Njila mubusekelezi bwasimalelo wako.' ");
INSERT INTO dov_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Eelyo oyo mulanda wakatambwide talenta lyomwe wakasika alakwe wati, 'Simalelo wangu, ndilikwizi kuti ulimwalumi ukalala. Ulatebula mpotabyalide, alimwi ulatebula mpotakwe niwamwaya. ");
INSERT INTO dov_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ndakayoowa, lino ndakeenda mpawo ndakusiisa talenta munyika. Langa ndeeli lyako ndabozya. ");
INSERT INTO dov_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Pesi Simalelaakwe wakamusandula wati kulinguwe, Íwe nomulanda mubi alimwi mutolo, wakaziba kuti ndilatebula aawo mpondatabyalape alimwi ndilatebula aawo mponditamwayide pe. ");
INSERT INTO dov_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nkiinkaako wakeelede kupa mamali kulibasikulondola, alimwi kukuyobola kwangu ndakati kunobweza aangu antoomwe ayaayo alikunozyalwa. ");
INSERT INTO dov_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nkiinkako amumubwezele talenta alimwi mulipe ooyo mulanda ulamatalenta alikkumi. ");
INSERT INTO dov_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mpawo kuli umwi awumwi weeta zyiingi uyopegwa, alimwi uyooba azyiingi. Pesi kuliyooyo utayeti chintu, uyonyanzigwa nikuba eecho nchajisi. ");
INSERT INTO dov_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mumubwale mumudima ooyo mulanda utakwe anchabede, omo mulikulila alimwi akuluma ntwino.' ");
INSERT INTO dov_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Eelyo Mwana a Muntu nayoboola mubulemu alimwi abaangelo bakwe boonse, uyokkala achuuno chakwe chabulemu. ");
INSERT INTO dov_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kuyobunganisigwa misyobo yoonse, alimwi uyopambula bantu umwi akulumwi, mbuli mwembeli mbwapambula imbelele kuzwa kumpongo. ");
INSERT INTO dov_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Uyobika mbelele kuchilisyo chakwe, pesi mpongo kuchimweensi chakwe. ");
INSERT INTO dov_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Eelyo Mwami uyowamba kuli zeezyo zitanoli kuchilisyo kuti, 'Muze, inywe nimulongezezegwe a Taata, amujane bwami oobo mbumwakabambilidwe kuzwa kumatalikilo anyika. ");
INSERT INTO dov_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nkaambo ndakali enzala alimwi mwakandipa chakulya.' ndakali enyota alimwi mwakandipa chakunywa.' ndakali mwenzu alimwi mwakandinjizya mungánda.' ");
INSERT INTO dov_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ndakali chintanda alimwi mwakandisamika.' ndakali kuchiswa alimwi mwakandisilika.' ndakali mujele alimwi mwakandiswaya.' ");
INSERT INTO dov_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Éelyo baluleme bayosandula alimwi kabati, 'Mwami, ndilili nitwakakubona koli enzala alimwi twakakusanina? Nikuba nyota alimwi twakakupa meenda? ");
INSERT INTO dov_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ndilili nitwakakubona koli mwenzu alimwi twakakutambula akukunjizya? Nikuba chintaanda alimwi twakakusamika? ");
INSERT INTO dov_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Alimwi ndilili nitwakakubona kochiswa nikuba muntolongo alimwi twasika kulinduwe?' ");
INSERT INTO dov_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Eelyo Mwami uyosandula alimwi uyoti kuli mbaabo, 'Nchobeni ndamwambila, nzimwakachitila kumunini wabakwesu, mwakazichitila ndime.' ");
INSERT INTO dov_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Eelyo uyoti kuli baabo batanoli kuchimweensi chakwe, 'Muzwe kuli ndime, inywe nimutukidwe, munjile mumulilo utamani ooyo ubambilidwe Satani abaangelo bakwe, ");
INSERT INTO dov_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","nkambo ndakali enzala, pesi temwakandipa pe chakulya; ndakali enyota, pesi temwakandipa pe meenda; ");
INSERT INTO dov_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ndakali mweenzu, pesi temwakandinjizizye pe mungánda; ndakali chintanda, pesi temwakandisamika pe; ndakali kuchiswa alimwi nikuba nindakali muntolongo, pesi takwepe nchimwakayeeya andime.' ");
INSERT INTO dov_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Mpawo abalabo bayosandula alimwi kabati, 'Mwami ndilili nitwakakubona koli enzala, nikuba nyota, nikuba koli mwenzu, nikuba chintanda, nikuba kochiswa, nikuba koli muntolongo, alimwi twakaleka kukubelekela?' ");
INSERT INTO dov_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Eelyo uyobasandula kuti, 'Nchobeni ndamwambila, nzimwakatachitila abo banini babaaba, temwakazichita pe kulindime.' ");
INSERT INTO dov_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aaba bayonjila muchisubulo chitamani, pesi baluleme bayonjila mubuumi ibutamani.” ");
INSERT INTO dov_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lino chakaba kuti Jesu nakamana majwi aya oonse, wakati kuli basikwiya bakwe, ");
INSERT INTO dov_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mulizi kuti kwayinda mazuba abili pobwe lyakwindilila ngalyasika, e; yo Mwana Muntu waabwa kuti akagankaminwe.” ");
INSERT INTO dov_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mpawo mupayizi mupati abapati bamwi babantu bakali bungene aantomwe mungánda yamuapyizi silutwe, wakalikutegwa ngu Kkayafasi. ");
INSERT INTO dov_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bakalangula inzila isisikene kabali antomwe kuti bamwange Jesu chakumubba akuyomujaya. ");
INSERT INTO dov_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nkambo bakali kwamba kuti, “kutabi chiindi chapobwe litakwe bumena, kuti kutabi kunyongana akati kabantu.” ");
INSERT INTO dov_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Lino Jesu nakali mu Bbetani mungánda ya Sayimoni sichinsenda, ");
INSERT INTO dov_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nakalikulya atafula, elyo kwakasika mwanakazi wakajisi cinkuli wamafuta adula, elyo wakatila Jesu amutwe ");
INSERT INTO dov_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pesi basikwiya bakwe nibakaziba, bakabilila alimwi bakati, ");
INSERT INTO dov_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Ninzi chapa kuti aanyonyone obu? Ayaa alikuzigwa amali inyingi akuyopa bachete.” ");
INSERT INTO dov_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pesi Jesu nakaziba echi wakati kulimbabo, “Nkambonzi nimumukatazya mwanakazi ooyu? Nkambo wandichitila chintu chibotu. ");
INSERT INTO dov_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bachete mulaabo chiindi chonse, pesi tamukoyooba andime pe chindi choonse. ");
INSERT INTO dov_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nkambo mpatila mafuta aya amubili wangu, wazichitila kuzikwa kwangu ");
INSERT INTO dov_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","kasimpe ndamwambila kuti kufumbwa nkwayokambawukwa makani mabotu, munyika yoonse echi nchaachita mwanakazi oyu chinoyowambwa kuti bakamwibaluke. ");
INSERT INTO dov_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mpawo umwi wabali kkumi ababili, wakali kuteghwa Judasi sikaliyoti, wakayinka kumupayizi mupati ");
INSERT INTO dov_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Alimwi wakati, “Ninzi nchimuyanda kundipa kuti ndimwabe kulindinywe?” Bakazuminana makumi ataatu ansiliva kuti bamupe. ");
INSERT INTO dov_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kuzwa kuleechochindi wakalangula mwenya wakumwaba kulimbabo. ");
INSERT INTO dov_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lino mubuzuba butaanzibwachinkwa chitakwe bumena basikwiya bakaza kuli Jesu akumwambila kuti, “Nkukuli nkoyanda kuti tukakubambilile kuti ukalye pobwe lyakwindilila? ");
INSERT INTO dov_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wakamba kuti, “Ngamwinke mumyuunzi kuli umwi mwalumi akumwambila kuti, “Muyisi wati, “chindi changu chaba mumaanza. Ndiyobamba ipobwe lyakwindilila kungánda yako abasikwiya bangu. ");
INSERT INTO dov_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Basikwiya bakachita mbuli Jesu mbwakabalayilila, alimwi bakakubamba kulya kwapobwe lyakwindilila. ");
INSERT INTO dov_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lino nichakaba chindi chagoko, wakakkala aansi kuti alye abasikwiya balikkumi ababili. ");
INSERT INTO dov_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Awo nibakali kulya, wakabambila kuti, “Nkasimpe ndamwambila kuti umwi wanu uyondaaba.” ");
INSERT INTO dov_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bakawusa kapati, elyo umwi wakatalika kumubuzya kuti, “Zyanchonzyo tendime na Mwami?” ");
INSERT INTO dov_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wakasandula kati, “Ngumwi oyo unika kuboko kwakwe andime mukabbavu ngonguwe uyondaaba. ");
INSERT INTO dov_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mwana Muntu uleenda, mbuli mbukulembedwe atala anguwe, pesi maawe kulooyo muntu uwaaba Mwana a Muntu! Chalikubota kuloyo muntu natakazyalwa.” ");
INSERT INTO dov_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasi oyo wakali wakayanda kuyomuuzya wakati, “Ndime na, Mwami?” wakamwambila kuti, “walyambila olikke.” ");
INSERT INTO dov_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kabalimukulya, Jesu wakabweza chinkwa, wachilongezya, akuchikwamuna. Wakachipa basikwiya akubambila kuti, “Mubweze, mulye. Ooyu ngomubili wangu.” ");
INSERT INTO dov_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wakabweza nkomeki akulumba, alimwi wakabapa akwamba kuti, “Munywe, moonse. ");
INSERT INTO dov_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nkambo obumbulowa bwangu bwachizuminano butililwa bayingi kuti balekelelwe zibi. ");
INSERT INTO dov_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pesi ndimwambila kuti, tandi koyonywa limbi muchelo wamasansa, kusikila mubuzuba obo mbwintakanywe bupya andinywe mu Bwami bwa Taata.” ");
INSERT INTO dov_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lino nibakazwa kwimba lwiimbo, bakayinka kuchilundu chama oliva. ");
INSERT INTO dov_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mpawo Jesu wakabambila kuti, “moonse muyolebwa mansiku aano nkambo kandime, nkambo kuli lembedwe kuti, Ndiyowuma mwembeli alimwi butanga bwambelele buyomwayika.' ");
INSERT INTO dov_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pesi musule ndakubusigwa, ndiyomusangunina kuya mu Galili.” ");
INSERT INTO dov_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pesi Pita wakati kulinguwe, “Nekuba boonse balebwa nkambo kanduwe, mebo andike tandikoyolebwa pe.” ");
INSERT INTO dov_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu wakamwambila kuti, “chakasimpe ndakwambila kuti, busiku mbubobuno, mukombwe katana kukokolika, unoli wandikaka tutaatu.” ");
INSERT INTO dov_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita wakamwambila kuti, “Nikuba kufwa anduwe ndilakonzya, nsikoyokukaka pe. “Boonse basikwiya bakamba chomwe. ");
INSERT INTO dov_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mpawo Jesu wakinkabo kubusena ibutegwa Gesemane alimwi wakati kuli basikwiiya bakwe, “Amukkale aano ninchiya kukukomba.” ");
INSERT INTO dov_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wakabweza Pita abana ba Zebbedi babili antoomwe anguwe alimwi bakatalika kuba amawuse aku katazika. ");
INSERT INTO dov_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Mpawo wakati kuli mbabo, “Muuya wangu wawusa kapati, nikuba kusikila akulufu. Amuchale ano alimwi mulindile.” ");
INSERT INTO dov_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wakayinka anembo kulekule, wakakotamika busyu bwakwe, akukomba wakamba kuti, “Taata, na chakonzeka, nkomeki eyi ngindiinde. Pesi, kutabi kuyanda kwangu, pesi kube kuyanda kwako. ");
INSERT INTO dov_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wakaboola kuli basikwiya akubajanabalimukoona, alimwi wakati kuli Pita, “Niinzi, sa tamukonzyi kulindila andime hoola limwi? ");
INSERT INTO dov_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Amulindile akukomba kuti mutanjilinmukusunkwa. Nchoonzyo Muuya ulayanda, pesi mubili wezuuka.” ");
INSERT INTO dov_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wakayinka lwachibili akuyokoomba. Wakamba kuti, “Taata, kuti echi tachikonzeki kwinda kumbali kwakuti ndinywe, kuyanda kwako kuchitwe. ");
INSERT INTO dov_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wakaza lubo wazobajana balikoona, nkambo meso aabo akali alema. ");
INSERT INTO dov_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wakabasiya lubo, wakayinka akuyokoomba kachitaatu, kayindulula majwi omwe. ");
INSERT INTO dov_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mpawo Jesu wakeza kuli basikwiya akubambila kuti, “Muchoona na akulyokezya? Amulange, hola lyaba mumaboko, alimwi Mwana Muntu waabwa mumaboko abasizibi ");
INSERT INTO dov_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mubuke, twinkeAmulange, oyo sikundaaba waba afwifwi.” ");
INSERT INTO dov_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nakachili kwambula, Judasi, umwi wabali kkumi awumwi, wakasika, wakaaza amakamu makamu abantu kuzwa kumupayizi mupati abapati babantu. Bakeza amafulo enkoli. ");
INSERT INTO dov_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lino oyo mwalumi wakali kuyanda kuuzya Jesu wakali bapede chitondezyo, chamba kuti, “oyo ngwensikamyonte ngonguwe. Mukamuvumpile.” ");
INSERT INTO dov_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mpawawo wakasika kuli Jesu akwamba kuti, “Wapona, Omuyisi!” akumumyonta. ");
INSERT INTO dov_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu wakamwambila kuti, “Mweenzuma, chita echo nchwazida kuzochita.” mpawo bakasika, babika maanza ali Jesu, akumuvuntila. ");
INSERT INTO dov_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Amulange, umwi wababo bakali a Jesu wakatandabika janza lyakwe, wasomona kafulo, akuma muzike wamupayizi mupati, akumudyunkula kutwi kwakwe. ");
INSERT INTO dov_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Mpawo Jesu wakati kulinguwe, “Bwedezya kafulo kako muchibikilo chako, nkambo boonse abo babweza tufulo bayolobesegwa atufulo. ");
INSERT INTO dov_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Muyeeye kuti tendali kukonzya na kwiita Taata, alimwi walikunditumina baangelo bayinda myuya mibi ilikkumi ayibili? ");
INSERT INTO dov_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pesi alikuyo zuzikizigwa biyeni malembe, “kuti echi chichitike?” ");
INSERT INTO dov_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kuleecho chindi Jesu wakati kumakamu abantu, “Mwaaza azifulo enkoli kuti muzondivuntile mbotatedi ndimubbi? Mazuba oonse ndakali kuyiisya mungánda ya Leza, alimwi tamwakandaanga pe. ");
INSERT INTO dov_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pesi zyoonse eezi zyachitika kuti malembe amusinsimi azuzikizigwe. “Mpawo basikwiya boonse bakamutakata akuchija. ");
INSERT INTO dov_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Abo bakamuvuntila Jesu bakamutola kuli Kkayafasi muapayizi mupati, oko balembi abapati nkabakabungene. ");
INSERT INTO dov_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pesi Pita wakamutobelela kule kule kusikila mulubuwa lwamupayizi mupati. Wakanjila mukati akukkala aansi abasikulinda kuti abone chitachitike. ");
INSERT INTO dov_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Lino mupayizi mupati abankuta boonse bakali kulangila bukamboni bwakubeja aatala a Jesu kuti bakonzye kumubika kulufu. ");
INSERT INTO dov_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Takwepe nchibakajana, nekuba kuti bakamboni bakubeja bakeza. Pesi nichakaba chiindi babili bakasika. ");
INSERT INTO dov_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Akwamba kuti, “Oyu mwalumi wakali kuti, 'Ndilakonzya kumwayula ngánda ya Leza akwiyakulula mumazuba ataatu.” ");
INSERT INTO dov_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mupayizi mupati wakimikila akumwambila kuti, “Tukwe nsandulo na?” Niinzi zyoonse eezi nzibalokukukwambila atala anduwe?” ");
INSERT INTO dov_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pesi Jesu wakawumuna. Mupayizi mupati wakamwambila kuti, “Ndakulayilila muli Leza upona, twambile na nduwe Kkilisito, Mwana a Leza.” ");
INSERT INTO dov_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu wakamuvwiila kati, “wamba nduwe omwini. Pesi ndakwambila, kuzwa lino uyoobona Mwan Muntu kakkede kukuboko kwachilisyo kwenguzu, akuyoboola mumayooba akujulu.” ");
INSERT INTO dov_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mpawo mupayizi mupati wakadelula zisamo zyakwe akwamba kuti, “wambula masampu! Nkambonzi nituchiyanda bukamboni? Amulange lino mwamvwa masampu. ");
INSERT INTO dov_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Muyeyaanzi? Bakasandula akwamba kuti, “Welede lufu.” ");
INSERT INTO dov_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mpawo bakamuswida kumeso akumuuma, akumuvatula mabbayi, ");
INSERT INTO dov_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","akwamba kuti, “Tusinsimine, webo Kkilisito. Ngwani wakuuma?” ");
INSERT INTO dov_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lino Pita wakalikkede aanze mukati kalubbaya lwankuta, elyo mulanda musimbi wakasika kulinguwe akumwambila kuti, “wakalawe Jesu mu Galili.” ");
INSERT INTO dov_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pesi wakazikaka kunembo lyabo boonse kaamba kati, “tandizizi pe eezyo nzyolikwamba.” ");
INSERT INTO dov_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lino nakazwa anze amulyango walubaya, awumwi musimbi mulanda wakamubona akwambila abo mbakalabo, “Ooyu mwalumi wakali awe Jesu waku Nazaleta.” ");
INSERT INTO dov_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wakakaka lubo chakukonka, “tandimuzipe me mwalumi ooyu.” ");
INSERT INTO dov_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Musule lyakayindi abo bakalimvwi bakasika akwamba kuti kuli Pita, “Nchamasimpe uli umwi wabo, nkambo nzila njowambula ayo ilakwamba.” ");
INSERT INTO dov_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mpawo wakatalika kutukila akukonka, “tandimuzi pe mwalumi oyu,” alimwi mpawawo mukombwe waka kokolika. ");
INSERT INTO dov_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pita wakayeeya majwi Jesu ngakaambide, “mukombwe katana kokolika uyonditama tutatu.” Mpawo wakaya aanze wakutalika kweema. ");
INSERT INTO dov_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lino nikwaba kuseni, boonse bapayizi bapati abapati babantu bakalangula inzila mbubanga balamubika kulufu Jesu. ");
INSERT INTO dov_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bakamwaanga, akumutola aanze, akumusisya kuli Payileti mwendelezi. ");
INSERT INTO dov_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mpawo Judasi, wakamuuzya, nakabona kuti Jesu wapegwa mulandu, wakasanduka akujosya mali yansiliva ili makumi atatu kubapayizi bapati akuzuluzi, ");
INSERT INTO dov_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","alimwi wakati ndabisya akwaaba bulowa butakwe mulandu. Pesi bakati, “Niinzi echo kulindiswe? Libonene olikke.” ");
INSERT INTO dov_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mpawo wakasowela aansi tumpanzi twansiliva mungánda ya Leza, akwinka, alimwi wakaya anze wakulisina. ");
INSERT INTO dov_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mupayizi mupati wakatubweza tupanzi twansiliva akwamba kuti, “tachili mumulawu pe kuti eechi chibikwe muchiyobwedo nkambo muulo wabulowa.” ");
INSERT INTO dov_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bakambuuzyania antoomwe, alimwi bakawula muunda wamubumbi muzikkilwa beenzu. ");
INSERT INTO dov_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nkambo kacheechi, oyo muunda wakategwa, “Muunda wabulowa.” kusika lino. ");
INSERT INTO dov_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mpawo echo chakambidwe amusinsimi Jelemiya chakazuzikizigwa, chaamba kuti, “Bakabweza tumpanzi tulimakumi ataatu twansiliva, muulo wakabamba abana ba Izilayeli, ");
INSERT INTO dov_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","alimwi bakawupa kuti muunda wamubumbi, mbuli Mwami mbakandilayilila. ");
INSERT INTO dov_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lino Jesu wakayimikila kunembo lyamwendelezi, alimwi mwendelezi wakamubuzya, “Uli Mwami waba -Juda na?” Jesu wakavwila kuti, “wamba mbubo.” ");
INSERT INTO dov_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pesi nakatamikizigwa amupayizi mupati abapati, takwepe nakasandula. ");
INSERT INTO dov_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mpawo Payileti wakamwambila kuti, “Sa totumvwide twambo ntubalo kukutamikizya?” ");
INSERT INTO dov_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pesi takwe nakasandula niliba ijwi lyomwe, awo mwendelezi wakagamba kapati. ");
INSERT INTO dov_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lino kupobwe mbuli bwakali mulawu wamwendelezi kuti bagwisye umwi mwaange wasaluzigwa abantu. ");
INSERT INTO dov_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kuchindi eecho kwakali mwaange wakale mpewo utegwa Bbalabbasi. ");
INSERT INTO dov_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lino nibakabungana antomwe Payileti wakabambila kuti, “ngwani ngumuyanda kuti ndimwangunwide? Bbalabbasi na Jesu utegwa ngu Kkilisito?” ");
INSERT INTO dov_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wakalizi kuti bapeda Jesu kulinguwe nkambo kakwemuzya. ");
INSERT INTO dov_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Awo nakakkede achuuno chabbetekelo, mwanakazi wakwe wakamutumina ijwi elyo lyakati, “utachiti chintu kumwalumi oyo utakwe kaambo. Nkambo ndakatazigwa loko sunu nkambo kaziloto nzindalota atala anguwe.” ");
INSERT INTO dov_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lino bapayizi bapati abendelezi bakasungilizya makamu abantu kuti bakumbile Bbalabbasi, akupegwa Jesu kuti akajiigwe. ");
INSERT INTO dov_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mwendelezi wakababuzya kuti, “Nguuli akati kababili ngumuyanda kuti ndimwangunwide?” bakaamba kuti, “Bbalabbasi.” ");
INSERT INTO dov_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Payileti wakababuzya kuti niinzi nchinjelede kuchitila Jesu utegwa ngu Kkilisito? Bakamuvwiila boonse bakati, Ngagankaminwe.” ");
INSERT INTO dov_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mpawo wakamba kuti, “Nkambonzi, mbubiinzi mbwaachita?” Pesi bakompololesya kapati, “Mumugankamine.” ");
INSERT INTO dov_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lino Payileti nakabona kuti takwe chintu nchakali wajana, pesi kuti kunyongana kwakali kwatalika, wakabweza maanzi wasamba maboko kunembo lyamakamu abantu, akubambila kuti, tandikwe pe mulandu kubulowa bwamwalumi oyu. Amulibonene lwenu.” ");
INSERT INTO dov_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Boonse bantu bakati, “Mbubo bulowa bwakwe abube kulindiswe abana besu.” ");
INSERT INTO dov_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mpawo wakabaangunwida Bbalabbasi, pesi wakawuma Jesu achimboko akumupeda kulimbabo kuti akagankaminwe. ");
INSERT INTO dov_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mpawo basilumamba abeendelezi bakabweza Jesu akumutola mukati kangánda yabwendelelezi bapati akubungania nkamu mpati yoonse yabasilumamba. ");
INSERT INTO dov_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bakamuzwatununa akumusamika bbaki lisalalisya. ");
INSERT INTO dov_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bakaluka musini wamvwa akumuzwatika amutwe wakwe, akumubika mufunko kukuboko kwakwe kwalulyo. Bakafugama aansi kunembo lyakwe akumuniaka, kabamba kuti, “Mwalemekwa Mwami waba Juda!” ");
INSERT INTO dov_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bakamuswida mate, alimwi bakabweza mufunko akumuuma mumutwe kabalokwindulula. ");
INSERT INTO dov_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lino nibakamuniaka, bakamuzwatununa bbaki lyabo akumuzwatika zisamo zyakwe, akumutola kuyomugankamina. ");
INSERT INTO dov_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Awo nibakazwa aanze, bakajana mwalumi uzwa ku Sayilini utegwa Sayimoni, ngubakaangila kuti beende aamwi kuti anyumpule chiingano chakwe. ");
INSERT INTO dov_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bakasika kubusena butegwa Gologota, kachamba kuti, “Mbusena bwatupepe twamitwe.” ");
INSERT INTO dov_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Bakamupa wayini uvwelene andulwe kuti anywe. Pesi nakalabila wakakaka kunywa. ");
INSERT INTO dov_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Lino nibaka mugankamina, bakabaana zyakusama zyakwe akuuma chisolo, ");
INSERT INTO dov_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","alimwi bakakkala ani kabali kumulinda. ");
INSERT INTO dov_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Atala amutwe wakwe bakabikka bulembo bumubeteka, bwamba kuti, “Ooyu ngu Jesu Mwami waba Juda.” ");
INSERT INTO dov_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kwakali basikubba bobile mbakagankaminwa aabo, umwi kuchimweensi aumwi kuchilisyo chakwe. ");
INSERT INTO dov_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aabo bakali kwinda enzila bakali kumutukila, kabatikinia mitwe yabo ");
INSERT INTO dov_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kabamba kuti, “Iwe nuyomwaya ngánda ya Leza akwiyakulula mumazuba ataatu, lifutule omwini! do kuli Mwan a Leza, seluka achingano aawo!” ");
INSERT INTO dov_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Munzila ikozyenie abalabo bapayizi bapati bakali kumuniaka kabala balembi abapati kabamba kuti, ");
INSERT INTO dov_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","wakali kufutula bamwi, pesi we takonzyi pe kulifutula. Ngu Mwami wa Izilayeli. Ngaseluke aachingano, alimwi tuyomusyoma. ");
INSERT INTO dov_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wakali kusyoma Leza, Leza ngamuvune lino, na Leza kayanda kumwangununa. Nkaambo wakali kwamba kuti ndimwana a Leza.” ");
INSERT INTO dov_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Munzila ikozyenie abalabo basikubba mbakagankamidwe aabo abalabo bakamutukila. ");
INSERT INTO dov_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lino kuzwa kuchindi chahola lamusanu alimwi mudima wakasikila nyika yoonse kuyosika kuhola lyamusanu aane. ");
INSERT INTO dov_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nichakaba chiindi chamusanu mwaane, Jesu wakoompolola ejwi pati kaamba kuti, Eli, Eli, lama, sabakkatani?” Kazyamba kuti, Leza wangu Leza wangu, nkambonzi niwandisiya?” ");
INSERT INTO dov_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lino abo bakiimvwi mpawo bakazimvwa, bakaamba kuti, “ulikwiita Elayija.” ");
INSERT INTO dov_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mpawo umwi wakachijana akuyobweza nsisa akwizuzya awayini ulwela, wakisekka kumufunko, elyo wakamupa kuti ayinywe ");
INSERT INTO dov_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bayingi boonse bakati, mumuleke alikke, Tumubone na Elayija uleza na kuzomufutula.” ");
INSERT INTO dov_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mpawo Jesu wakalila lubo ajwi pati elyo wakapa muuya wakwe. ");
INSERT INTO dov_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Amubone, chisitilizyo changánda ya Leza chakanduka muzimpanzi zibili kuzwa kujulu kusika aansi, anyika yakandendema, amabwe akaanduka. ");
INSERT INTO dov_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tubanda twakavunuka, amibili yabasalali bakali boona yakabusigwa, ");
INSERT INTO dov_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bakazwa mutubanda musule lyakubuka kwakwe, bakanjila mugunzi lisalala, akuboneka kubayingi. ");
INSERT INTO dov_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lino silumamba mupati abaabo bakali kulinda Jesu bakawubona muzuzumo azintu zyakachitika, bakayoowa baamba kuti, “Chamasimpe ooyu wali Mwana a Leza.” ");
INSERT INTO dov_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Banakazi biingi bakali batobela Jesu kuzwa ku Galili kuti bamukutawukile bakali kulanga alaale. ");
INSERT INTO dov_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Akati kabo kwakali Meli Magadalini, Meli banyina ba Jemusi a Jozefa, abanyina babana ba Zebbedi. ");
INSERT INTO dov_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lino nilyakaba goko, kwakasika mwalumi uzwa ku Alimatiya, utegwa Jozefu, wakali sikwiiya wa Jesu. ");
INSERT INTO dov_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wakayinka kuli Payileti akuyokumbila mutunta wa Jesu. Mpawo Payileti wakalayilila kuti awupegwe. ");
INSERT INTO dov_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jozefu wakabweza mutunta, wamuzambilila mulembo utenteema, ");
INSERT INTO dov_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","wakulazika mukabanda kakwe kapya nkakali wafokola mubbwe. Mpawo waka kkunkulisya ibbwe pati wasinka amulyango wenda. ");
INSERT INTO dov_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meli Magadalini amumwi Meli bakaliwo, bakalikkede kulubazu lyakabanda. ");
INSERT INTO dov_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Buzuba bwakatobela bwakali buzuba bwinda bwakulibambila, bapayizi bapati abaFalisi bakali bungene antomwe a Payileti. ");
INSERT INTO dov_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bakali kwamba kuti, “Mwami, tuchiyeeya ulya silweno nakachili kupona, wakaamba kuti, “kwinda mazuba ataatu ndiyobuka alubo.' ");
INSERT INTO dov_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nkinkaako layilila kuti kabanda kakwe kalindwe kusikila kubuzuba bwatatu. Chimwi chindi ulabona basikwiya bakwe basika bazomubba akwambila bantu, 'Kuti wabuka kuzwa kubafu.'Alweeno lwakumamanino ngalulayinda lwakusanguna.” ");
INSERT INTO dov_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Payileti wakabambila kuti, “mwinke mukalinde mbuli mbumukonzya.” ");
INSERT INTO dov_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mpawo bakiinka akuyochita kuti kabanda kalindwe, bakazilulula abbwe akubikka basikulinda. ");
INSERT INTO dov_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lino niyakayinda isabata, kakuya kubuchedo mubuzuba butanzi bwamviki, Meli magadalini awumwi Meli bakaza kuzolanga chibunda. ");
INSERT INTO dov_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Amulange, wakaba muzuzumo mupati wanyika, nkambo angelo wamwami wakaseluka kuzwa kujulu, wakaza akukunkulisya ibbwe, akukkala alindilyo. ");
INSERT INTO dov_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chiiwa chakwe chakali mbuli lulabi, azyakusama zyakwe zyakalikutuba mbuli buluba bwatonje. ");
INSERT INTO dov_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Balindizi bakandengenda akuyowa alimwi bakaba mbuli bantu bafwide. ");
INSERT INTO dov_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mu angelo wakazibya banakazi akwamba kuti kulimbabo, “Mutayowi, ndilizi kuti mulangula Jesu, wakagankaminwa. ");
INSERT INTO dov_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tawope okuno, pesi wabuka, mbuli mbwaakamba. Amuze mubone abusena Mwami mpakalilazikidwe. ");
INSERT INTO dov_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mwinke chakufwambana alimwi mwambile basikwiiya bakwe, 'wabuka kuzwa kubafu. Amubone, ulikunembo lyanu kuyaku Galili. Ámulange, ndamwambila.” ");
INSERT INTO dov_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Banakazi bakazwa mukabanda chakufwambana kabala akuyoowa akukondwa kupati, alimwi bakachijana kuyowambila basikwiya bakwe. ");
INSERT INTO dov_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Amulange Jesu wakabaswania akubambila kuti, “Mwapona!” Banakazi bakaza, bajana mawulu akwe akumukomba. ");
INSERT INTO dov_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mpawo Jesu wakabambila kuti, “Mutayowi. Amwinke mwambile bakwesu kuti bayinke ku Galili. Nkuko nkubayondibonena.” ");
INSERT INTO dov_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lino awo banakazi nibakalikwenda, Amulange, bamwi babalindizi bakayinka mugunzi akuyowambila bapayizi bapati zintu zyoonse zyakachitika. ");
INSERT INTO dov_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lino bapayizi nibakaswanana abapati akuyooma aabo ikkani eeli, bakapa mali nyiingi kuli basilumamba ");
INSERT INTO dov_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","akubaambila kuti, “Mwambe kuti kuti bamwi, 'Basikwiiya ba Jesu basika mansiku akubba mutunta wakwe nitwachilikoona. ");
INSERT INTO dov_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'kuti na makani aya asika kumwendelezi, tulamukombelezya akugwisya makatazyo alimulindinywe.” ");
INSERT INTO dov_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mpawo basilumamba bakabweza mali akuchita mbuli mbubakalayililwa. Aya makani akamwayika kapati akati kama Juda alimwi akeendelela anembo nikuba asunu. ");
INSERT INTO dov_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pesi basikwiiya ibalkkumi awumwi bakayinka ku Galilii, kuchilundu oko Jesu nkwakabalayilila. ");
INSERT INTO dov_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mpawo nibakamubona, bakamukomba, pesi bamwi bakadoneeka. ");
INSERT INTO dov_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesu wakaza kuli mbabo akwaambula abo akuti, “Nguzu zyoonse ndakazipegwa kujulu aansi. ");
INSERT INTO dov_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Aboobo amwinke alimwi mukachite basikwiiya bamisyoobo yoonse. Mukaba bbabbatizye muzina lya Taata, lya Mwana, alya Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mubayiisye kulemeka zintu zyoonse nzindakamulayilila, amubone, ndilandinywe chiindi choonse, nikuba kusikila kumamanino.” ");
INSERT INTO dov_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aya ngingawo matalikilo a makani mabotu a Jesu Kilisito, Mwana wa-Leza. ");
INSERT INTO dov_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mbuli mbukulembedwe kuli Isaya musinsimi, “Mulange, ndatuma mutumwa kunembo lyabusyu bwake oyo ulolulamika nzila yako. ");
INSERT INTO dov_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ijwi lya oyo uwompolola munkanda, “Mubambe inzila yaMwami; mululamike inzila yakwe”. ");
INSERT INTO dov_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Joni wakasika, kabbizya munkanda alimwi kakambawuka lubbizyo lwakusanduka. Akulekelelwa izibi. ");
INSERT INTO dov_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ichisi choonse cha Judiya abantu boonse baku Jelusalemu bakayinka kulinguwe. Bakabbizigwa anguwe mumulonga utegwa Jodani, bakalyamba zibi zyabo. ");
INSERT INTO dov_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Joni wakali kuzwaata zizwaato zyaboya bwankamela alukumba lwachikumba muchibuno chakwe, nkabela wakali kulya insozi abuchi bwalusaka. ");
INSERT INTO dov_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wakambula wati, “Oyu uza musule lyangu ulanguzu kwiinda ndime, lukole lwambatata zyakwe nsikwe chelelo chakukotama ansi akuzyangununa. ");
INSERT INTO dov_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ndamubbizya amanzi, asi we uyomubbizya a Muuya Usalala”. ");
INSERT INTO dov_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Zyakachitika mumazuba ayo Jesu wakazwa ku Nazaleta ya Galili, alimwi wakabbizigwa a Joni mumulonga utegwa Jodani. ");
INSERT INTO dov_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kachizwa biyo Jeso mumanzi, wakabona ijulu kalyanzana akujulika ");
INSERT INTO dov_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","alimwi Muuya kuseluka akukkala atala anguwe mbuli nziba. Ijwi lyakazwa kujulu kalyamba kuti, “Ulimwana wangu. Ndiboteledwe kapati anduwe”. ");
INSERT INTO dov_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nkabela Muuya wakamusungilizya kuya munkanda. ");
INSERT INTO dov_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wakali munkanda mazuba makumi ane, kalokusunkwa aSatani. Wakali abanyama balusaka, alimwi bangelo bakamugwasizya. ");
INSERT INTO dov_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lino musule Joni kalimwangwa, Jesu wakasika muGalilaya kakambawuka makani mabotu aLeza. Wakamba kuti, “Ichindi chazuzikizigwa, ");
INSERT INTO dov_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","alimwi bwami bwaLeza bwaba afwifwi. Musanduke musyome makani mabotu”. ");
INSERT INTO dov_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nakalibwenda kumbali alwizi lwaGlili, wakabona Sayimoni a Andilaya muzyalwanyina wa Sayimoni kabawala kanyandi mulwizi, nkambo bakali bazubi babaswi. ");
INSERT INTO dov_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu wakabambila kuti, “Kamuzuba, munditobele, alimwi ndilomuchita bazubi babantu”. ");
INSERT INTO dov_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Akufwambana bakasiya tunyandi twabo mpawo bamutobela. ");
INSERT INTO dov_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Elyo Jesu nakachilikuyobweda kuya kunembo, wakabona Jakobo mwana wa Zebbediya amuzyalwanyina wakwe Joni; bakali mubwaato kabaluka tunyandi. ");
INSERT INTO dov_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Wakabayita alimwi bakasiya wisi Zebbediya antoomwe ababelesi mubwaato mpawo bamutobela. ");
INSERT INTO dov_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Lino bakasika kuKkapenawume, alimwi kabuli bunsi bwaSabata, Jesu wakanjila muchikombelo wakuyisya. ");
INSERT INTO dov_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bakagamba kunjisyo yakwe, nkambo wakali kuyisya mbuli muntu ulanguzu utali mbuli balembi pe. ");
INSERT INTO dov_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mpawo awo mwalumi wakali amuuya mubi wakakwiila muchikombelo, kati, ");
INSERT INTO dov_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Tulanzi anduwe, Jesu waNazaleta? Waza kuzotunyonyona na? Ndilikwizi kuti nduwe ni. Nduwe Usalala Mwana wa-Leza!”. ");
INSERT INTO dov_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu wakakalalila dayimona kati, “Tedi zwa alimwi uzwe mulinguwe!” ");
INSERT INTO dov_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Idayimona lyakamuwalila ansi mpawo lyazwa mulinguwe akukwiila kupati. ");
INSERT INTO dov_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bantu boonse bakagamba, akubuzyanya, “Kuti ninzi eechi? Ninjisyo impya ilanguzu Ukonzya kutanda madayimona na amuswilizye” ");
INSERT INTO dov_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Alimwi mpuwo yakwe yakazula muchisi choonse chaGalilaya. ");
INSERT INTO dov_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Musule lyakuzwa muchikomelo, bakayinka kunganda yaSayimoni a Andilaya, kabali antoomwe a Jakobo a Joni. ");
INSERT INTO dov_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lino banyinazyala baSayimoni bakalikuchiswa intutumanzi, alimwi bakamwambila Jesu atala amukayintu oyu. ");
INSERT INTO dov_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wakaza wakamujata aluboko, wamubusya; intutumanzi yakazwa, mpawo watalika kubakutawukila. ");
INSERT INTO dov_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Igolezya izuba kalili lyabbila, baketa kulinguwe boonse bachiswa abakanjidwe amadayimona. ");
INSERT INTO dov_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ibantu bamunzi boonse bakabungana amulyango. ");
INSERT INTO dov_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wakaponya boonse bakalamalwazi asiyene-siyene akutanda madayimona miingi, asi takazumizya madayimona kwambula nkambo akalimuzi. ");
INSERT INTO dov_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wakabuka kuseni, kakuchisiya; wakayinka kusisikene kuyokomba. ");
INSERT INTO dov_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sayimoni ababo bakali anguwe bakamuyandula. ");
INSERT INTO dov_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bakamujana bamwambila kabati, “Bantu boonse balokukuyandula”. ");
INSERT INTO dov_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wakabambila wati, “Ngatuye kumbi, anze kumadolopo alafwifwi, kuti ndikakambawuke akulako. Ncindazwide anze obu”. ");
INSERT INTO dov_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wakayinka kuGalilaya yoonse, kakambawuka muzikombelo zyabo akutanda madayimona. ");
INSERT INTO dov_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sichipele wakasika kulinguwe. Kumukumbila; wakafugama wamba wati, “Kuti kuyanda, ulakonzya kundisalazya”. ");
INSERT INTO dov_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Wakazula luzyalo, Jesu wakatandabika kuboko kwakwe wamuguma, kamba kuti, “Ndilayand. Kopona” ");
INSERT INTO dov_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mpawo awo chipele chakayinka, mpo wasalazigwa. ");
INSERT INTO dov_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesu wakamulayilila changuzu mpo wamuti yinka. ");
INSERT INTO dov_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Wakamwambila kuti, “Ube asimpe lyakuti tubuzyi naba omwe muntu, asi kuya, ukalitondezye kumupayizi, ukapayilile nkambo kakusalazigwa kwako, mbuli Mozesi mbwakalayilila, mbuli bukamboni kuli mbabo”. ");
INSERT INTO dov_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Asi wakiinka watalika kwaambula kangunukide kamwaya ijwi, zyakachitisya kuti Jesu takachili kukonzya kunjila idolopo kangunukide, asi wakakkala anze mumyunzi. Nikuba bobo bantu bakachili kusika kulinguwe kabazwa kumasena asiyene-siyene. ");
INSERT INTO dov_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nakabola kuKkapenawumi nikwakiinda mazuba mache kwakamvwika kuti Jesu mwali mumunzi. ");
INSERT INTO dov_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bantu bingi bakabungana kwakuti takwe nikwachili busena, munganda nikuba kumulyango, Jesu kali kukambawuka ijwi kuli mbabo. ");
INSERT INTO dov_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kwakasika balumi bakanyampwide mwalumi wakayuminide mubili; kanyampwidwe abalumi bone. ");
INSERT INTO dov_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nibakabula mweenya wakuswena afwifwi anguwe nkambo kakuvula kwabantu, bakavumbula kaluli awo Jesu mpakabede nibakavumbula bakaseluzya bulo bwawaka yuminide mubili mpakabede. ");
INSERT INTO dov_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nakabona kusyoma lwabo, Jesu wakati kuli wakayuminide mubili, “Omwana, zibi zyako zyalekelelwa”. ");
INSERT INTO dov_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lino bamwi balembi bakekkede, bakayeya munyono yabo, ");
INSERT INTO dov_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nkambonzi mwalumi oyu nambula obu? Utuka Leza alikke?” ");
INSERT INTO dov_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chakufwambana Jesu wakaziba mumuya wkwe nzibakali kuyeya mumyoyo yabo. Wakati kulimbabo, “Nkambonzi nimulikuyeya ezi mumyoyo yanu? ");
INSERT INTO dov_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nchechili chuuba kwamba kuti kumulwazi, “Walekelelwa zibi, na kuti bweza bulo bwako weende?” ");
INSERT INTO dov_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Asi kuti muzibe kuti Mwana aMuntu ulamanguzu ano ansi enyika kulekelela zibi, wakati kuliwakayuminide mubili ");
INSERT INTO dov_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ndati kulinduwe nyampuka, bweza bulo bwako, uye kunganda yako”. ");
INSERT INTO dov_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wakanyampuka chakufwambana wabweza bulo, wakazwa munganda kunembo lyabantu boonse, abobo boonse bakagamba bapabulumbu kuli Leza, bati, “Ezi tatuna zibona pe”. ");
INSERT INTO dov_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Wakayinka lubo kunkomwe yalwizi, makamu abantu akamutobela, mpawo wakabayiisya. ");
INSERT INTO dov_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kayabweenda, wakabona Levi mwana wa Alufayewusi kakkede mutente lyabasimutelo wakati kulinguwe, “Nditobele”. Wakanyampuka wamutobela. ");
INSERT INTO dov_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesu wakali kulya munganda yaLevi, abasimutelo abasizibi bakali kulya awe abasikwiiya bakwe, kwakali biingi abobo bakamutobela. ");
INSERT INTO dov_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Balembi, bakali baFalisi, nibakabona Jesu kalikulya abasizibi, bakati kuli basikwiiya bakwe, “Nkamboonzi nalya abasimutelo abasizibi?” ");
INSERT INTO dov_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesu nakamvwa obo wakati kulimbabo, “Bantu baponede mumubili tabayandi musilisi; asi bachiswa, mbibayanda musilisi. Tendazida kwiita baluleme asi basizibi”. ");
INSERT INTO dov_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lino basikwiiya ba Joni abaFalisi kali kulyimya kulya. Bamwi bantu bakasika kulinguwe, “Nkambonzi basikwiiya baJoni abaFalisi balalyiima, asi bako tabalyimyi pe?” ");
INSERT INTO dov_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu wakati kulimbabo, “Nkujana basikutambwa kubwinga balyiimya na sibwiinga nkalabo?” Nkachilabo sibwiinga, tabalyimyi. ");
INSERT INTO dov_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ayosika mazuba sibwiinga akubwezegwa kuzwa kulimbabo, ayo mazuba bayolyiimya. ");
INSERT INTO dov_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Takwe usuma chigamba chamulembo mupya achizwato chikulukulu, chigamba chilakonzya kudeluka, chipya kuzwa kuli chachiindi, chiyodelukisya. ");
INSERT INTO dov_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Takwe ubikka wayini mupya munkomo yachiindi wabona wayini ulabbalula inkomo mpawo zyoonse wayini a ziyonyonyoka. Wayini mupya ubikwa munkomo mpya. ");
INSERT INTO dov_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Musabata Jesu wakayinda mumunda wamayila, basikwiiya bakabweza mayila. ");
INSERT INTO dov_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mpawo baFalisi bakati kulinguwe, “Langa nkambonzi basikwiiya nibalikuchita zintu zityola mulawo abuzuba bwaSabata?” ");
INSERT INTO dov_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Wakati kulimbabo, “Temwakabala na kuti Davida nakabula akuba anzala - we abalumi mbakalabo - ");
INSERT INTO dov_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","mbakanjila munganda yaJehova Abbiyata nkali mupatiyizi mupati, akulya chinkwa chabukamu, chitazumizigwi kuligwa amuntu kupela kunze kwabapayizi, wakapa abalabo mbakalabo?” ");
INSERT INTO dov_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesu wakati, “Sabata lyakalengelwa bantu, pepe bantu kulengelwa Sabata. ");
INSERT INTO dov_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aboobo, Mwana aMuntu Mwami, ku Sabata”. ");
INSERT INTO dov_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesu wakanjila lubo muchikombelo, wakajana mwaalumi wakakokonyene kuboko. ");
INSERT INTO dov_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bantu biingi bakamulangisisya kuyanda kubona kuti ulamuponisya na mubuzuba bwa Sabata bamupe mulandu. ");
INSERT INTO dov_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu wakaambila mwaalumi wakakokonyene kuboko kuti, “Nyampuka uyimikile aakati kabantu aaba.” ");
INSERT INTO dov_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mpawo wakati kubantu, “Ncheechili chibotu, kuchita chibotu na chibi mubuzuba bwa Sabata; kuvuna buumi na kujaya?” Pesi bakawumuna. ");
INSERT INTO dov_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Wakabalanga chakunyema, alimwi kawuside, nkaambo kakuyuma kwamyoyo yabo, wakati kumwaalumi ooyo, “Tandabika kuboko kwako. ” Mpawo wakatandabika, elyo kuboko kwakwe kwakaba kabotu. ");
INSERT INTO dov_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lino ba Falisi bakazwa aanze mpawo, antoomwe aba Heloda bakatanguna kulanguula nzila mbubanga balamujaya. ");
INSERT INTO dov_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Mpawo Jesu, wakasosoloka abasikwiiya bakwe baya kulwizi, elyo makamu makamu abantu kuzwa kuGalilii, aku Judiya akabatobela. ");
INSERT INTO dov_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Lino nibakamvwa nzyakali kuchita, bantu bayingi bakeza kuli nguwe kuzwa ku Jelusalema, Idumiya azisi zilimutala a Jodani azyeengelede Taya a Sidoni. ");
INSERT INTO dov_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nkaambo kamakamu aabantu wakaambila basikwiiya bakwe kuti bamubambile bwaato buniini afwiifwi, kuti akonzye kusosoloka aakati kabantu. ");
INSERT INTO dov_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nkaambo wakalikusilika bayingi, aboobo bakali aamalwazi balikuchundana kabaya kunembo kuti bamugume. ");
INSERT INTO dov_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kufumbwa myuuya mibi niyakamubona yakawida aansi kunembo lyakwe akoompolola, kuti, “Nduwe Mwana wa Leza. ” ");
INSERT INTO dov_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Alimwi wakayilayila changuzu kuti itamudomboli kuti ngwani. ");
INSERT INTO dov_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wakatanta achilundu akwiita aabo mbakalikuyanda, alimwi bakeza kulinguwe. ");
INSERT INTO dov_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wakasaluuzya balikkumi ababili; (aabo mbakati mmbatumwa) kuti bakabe aamwi anguwe, alimwi kuti akabatume kukukambawuka, ");
INSERT INTO dov_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","akubapa ngunzu, zyakutanda myuuya mibi. ");
INSERT INTO dov_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aaba mbimbabo bali kkumi ababili mbakasaluuzya: Sayimoni, oyu wakamupa zina lyakuti ngu Pita; ");
INSERT INTO dov_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jemusi mwana wa Zebbediya, aJoni mwana wakwabo wa Jemusi, aba wakabawuzika kuti mba Bbowanejesi, nkukwamba kuti bana ba ndabi; ");
INSERT INTO dov_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andulo, Filipo, Bbatolomiya, Matayo, Tomasi, Jemusi mwana wa Alifasi, Tediyasi, a Sayimoni munkutwe ");
INSERT INTO dov_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","a Judasi Sikkaliyoti, nguwe wakazomuuzya. ");
INSERT INTO dov_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mpawo wakabweeda kumuunzi, alimwi makamu aabantu akamubunganina, aboobo basikwiiya bakwe anguwe tebakachili kujana chiindi chakulya pe. ");
INSERT INTO dov_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lino bang'anda yakwabo nibakamvwa zyalikuchitika, bakamulanguula, kabaamba kuti “Wapenga. ” ");
INSERT INTO dov_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Balembi bakazwa kuJelusalema bakaamba kuti, “Unjidwe muuya mubi utegwa Bbelizabbeli,” akuti “Alimwi nguzu nzyatanzya myuuya mibi nzizyakwe Bbelizabbeli mwami wamyuuya mibi.” ");
INSERT INTO dov_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesu wakabayita mpawo watanguna kwaambula ambabo muzikozyanio, “Satani ulakonzya biyeni kulitanda? ");
INSERT INTO dov_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na bwaami kabupambukene, bwaami oobo tabukonzyi kwiimikila. ");
INSERT INTO dov_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Alimwi na tekwaba kumwvanana mung'anda, eeyo ng'anda tikonzyi kwiimikila. ");
INSERT INTO dov_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Alimwi na Satani walikazya elyo kanzeene, takonzyi kwiimikila; nkokuti mamanino aakwe asika. ");
INSERT INTO dov_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Pesi taakwe muntu ukonzya kunjila mung'anda yamwaalumi singuzu kuti abbe lubono lwakwe, atatanguna kumuzunda akumwaanga ooyo mwaalumi singuzu. Awo mpanga ulakonzya kubba lubono mung'anda eeyo. ");
INSERT INTO dov_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ndamwaambila kasimpe, zyoonse zibi akusampawula kwabantu kulalekelelwa, ");
INSERT INTO dov_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pesi kufumbwa muntu usampawula Muuya Uusalala takonzyi kulekelelwa; ulaamulandu wachibi chitamani. ” ");
INSERT INTO dov_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu wakabaambila eezi, nkaambo bakalikwaamba kuti, “Ulaa muuya mubi.” ");
INSERT INTO dov_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mpawo banyina abakwabo bakasika. Kabayimvwi aanze, bakatuma umwi kuti amwiite. ");
INSERT INTO dov_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bantu bayingi bakalikkede kabamubunganide, alimwi bakamwaambila kuti, “Banyoko abanike bako balaanze baliikukulanguula.” ");
INSERT INTO dov_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wakabasandula wati, “Baama abakwesu mbaani? ” ");
INSERT INTO dov_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Lino wakalanga aabo bakakkede kabamuzyungulukide wati, “Bakwesu abaama mbaaba! ");
INSERT INTO dov_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kufumbwa uuchita kuyanda kwaLeza nguumukwesu wangu abaama.” ");
INSERT INTO dov_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Alimwi Jesu wakatalika kuyiisya kali kumbali aalwizi. Inkamu yabantu bakamuzyungulukide yakali mpati loko zyakuti wakanjila mubwaato, kuchitila kuti akonzye kusosolokela mumaanzi akukkala, bantu boonse bakalitobezezye lwizi kunkomwe. ");
INSERT INTO dov_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mpawo wakabayiisya zintu zyiingi kabelesya zikozyanio, alimwi mukuyiisya kwakwe wakati, ");
INSERT INTO dov_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Amuswiilizye, mulimi wakaya kukumiza mbuto yakwe. ");
INSERT INTO dov_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Awo naakali kumiza mbuto, imwi yakawida munzila, mpawo tuyuni twakasika twiilya. ");
INSERT INTO dov_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Imwi yakawida amwaala, aatakwe muse mwiingi. Yakamena kufwambaana, nkaambo muse wakali muche. ");
INSERT INTO dov_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pesi zuba nilyakabala yakapya, mpawo yakayuma nkaambo kamiyanda yakatabbide. ");
INSERT INTO dov_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Imwi mbuto yakawida mumaamvwa, maamvwa akakomena asyanikizya matu aayo, aboobo teeyakakonzya kuzyala. ");
INSERT INTO dov_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Imwi mbuto yakawida mumuse uvubide. Yakamena, akukomena mane yazyala michelo, imwi makkumi otatwe, imwi makkumi musanu alimwi, imwi mwaanda. ” ");
INSERT INTO dov_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lino wakati, “Ooyo ulaamatwi aakumvwa, ngamvwe.” ");
INSERT INTO dov_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lino Jesu naakaba alike, mbakali aabo antoomwe abasikwiiya bakwe balikkumi ababili bakamubuzya aatala azikozyanisyo eezyo. ");
INSERT INTO dov_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wakabaambila wati, “Insiswa ya bwami bwa Leza ilipedwe kuli ndinywe. Pesi kuli bamwi biyo bali kunze, zyoonse zyaambwa muzikozyanisyo, ");
INSERT INTO dov_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kuchitila kuti, lyoonse kababona pesi kabatabonesesyi, alimwi kabamvwa lyoonse, pesi kabatamvwisisisyi; kansinga balikumvwa balikunosanduka kabalekelelwa zibi zyabo.” ");
INSERT INTO dov_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Lino wakati kuli mbabo, “Ani sena tamulokumvwisisisya na chikozyanisyo eechi? Na kakuli boobo nga kulakonzeka biyeni kuti mumvwisisisye zimwi zikozyanisyo? ");
INSERT INTO dov_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mulimi uumiza mbuto nguwe uumiza jwi. ");
INSERT INTO dov_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bamwi bantu bali mbuli nzila, aawo mpulimizidwe jwi. Mpawo mbubalimvwa biyo, Satani wasika wabweza jwi lyali lyamizwa muli mbabo. ");
INSERT INTO dov_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bamwi, mbuli muse ulaamwaala mpuyakamizwa mbuto, balalimvwa jwi, mpawo, akufwambaana balalitambula chakubotelwa. ");
INSERT INTO dov_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pesi nkaambo tabajisi miyanda ibbide, balajata kwachiindi chiniini biyo. Nikwasika mapenzi nikuba kusyonsegwa nkaambo kajwi, balafwambaana kuwa. ");
INSERT INTO dov_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Alubo bamwi, mbuli muse ulaamaamvwa muyakamizwa mbuto, balalimvwa jwi, ");
INSERT INTO dov_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pesi masukusyo aanyika, kweenwa aabuvubi aziyandisyo zyazimwi zintu zyabuyo zilasika zyasyanikizya jwi, zyachita kuti litabi aamichelo. ");
INSERT INTO dov_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bamwi, mbuli muse uuvubide muyakabyalwa mbuto, balalimvwa jwi, balitambula, akuzyala michelo imwi makkumi otatwe, imwi makkumi musanu alimwi, imwi kusika mwaanda.” ");
INSERT INTO dov_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu wakati kuli mbabo, “Sena nga mweeta lambi kuti mulitibbike alusuwo, na kulibika muchinkuma chabulo? Ani nga tamulibiki atala aachibikilo chalyo na? ");
INSERT INTO dov_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nkaambo zintu zyoonse zisisidwe ziyooyubununwa, alimwi choonse chitibbikidwe chiyotibbulwa. ");
INSERT INTO dov_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kufumbwa ulamatwi akumvwa ngamvwe.” ");
INSERT INTO dov_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wakaya kunembo akubaambila kuti, “Amuchenjele loko nzimumvwa. Cheelesyo nchimubelesya anywebo muyoyelesegwa anchicho, nikuba kwindilila kulindinywe. ");
INSERT INTO dov_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nkaambo kufumbwa uujisi uyoopegwa zyiingi. Ooyo uutajisi, niziba nzyalaazyo uyoonyanzigwa.” ");
INSERT INTO dov_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Alimwi wakati, “Mbobubede oobu bwami bwa Leza mbuli muntu uumiza mbuto aansi. ");
INSERT INTO dov_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mpawo uloona mansiku akubuka nibwacha, pesi mbuto ilamena akukomena, nikuba kuti tazi mbozichitika. ");
INSERT INTO dov_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Muse awulike: ulamezya nseke zyamayila kusaanguna munsonga, kakutobela miyungi, mane miyungi yatuba. ");
INSERT INTO dov_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mayila mbaatuba biyo, ulabelesya chakunenzya, nkaambo chiindi chakutebula chasika.” ");
INSERT INTO dov_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Alimwi wakati, “Sena niinzi nchitujnga tulachikozyanisya abwami bwa Leza, nakuti tubelesye chikozyanisyoonzi kubupandulula? ");
INSERT INTO dov_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Buli mbuuli mbuto itegwa musitada, ni mbuto ndiini loko njobyala aansi. ");
INSERT INTO dov_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pesi niyabyalwa, ilakomena kwiinda zilimwa zyoonse zyamumuunda, kilaamitabi mipati izyakuti tuyuni tulakonzya kukala mumweenzule wayo.” ");
INSERT INTO dov_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu wakabaambila jwi kabelesya zikozyanisyo zyiingi mbuuli mbubalikumvwa, ");
INSERT INTO dov_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","mpawo taakwe nchaakabaambila pe katabelesezye chikozyanisyo. Pesi nakaba alike abasikwiiya bakwe, wakapandulula zyoonse. ");
INSERT INTO dov_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Oobo buzuba, nilyakaba goko, wakati kuli mbabo, “Atuzubuke tuye mutala. ” ");
INSERT INTO dov_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bakasiya makamu makamu aabantu musule, bakamutobela, mubwaato mwakabede Jesu. Amwi maato akaliwo aalawo akamutobela. ");
INSERT INTO dov_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mbubakendeenda biyo kwakawunga guwo pati, alimwi mayuwe akalikukupila maanzi mubwaato, mane bwaato bwakasizule. ");
INSERT INTO dov_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesu wakalilede kasegede musego, kusule mubwaato. Basikwiiya bakamubusya alimwi bakati kuli nguwe, “Omuyiisyi, sena tokwe nolikataazya nikuba kuti twaamba kufwa? ” ");
INSERT INTO dov_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wakabuka, wakalayilila guwo, alimwi wakati kumayuwe, “Umuna! Batama! ” Mpawo guwo lyakuumuna, mayuwe akayosa, kuumuna kuti zii! ");
INSERT INTO dov_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wakati kuli basikwiiya bakwe, “Nkamboonzi nimuyoowa boobu? Sena ambuli sunu tamunaba lusyomo na? ” ");
INSERT INTO dov_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bakayoowa loko alimwi bakabuzyania bati, “Ani ngwani ooyu, nkaambo guwo amayuwe zilamumvwa akumuswiilila?” ");
INSERT INTO dov_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Bakazubuka lwizi baya kuchisi cha Jelasenesi. ");
INSERT INTO dov_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mpawaawo Jesu nakazwa mubwaato, mwaalumi wakanjidwe muuya mubi kazwa kuzibunda wakaza kuli nguwe. ");
INSERT INTO dov_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ooyu mwaalumi wakali kukkala kumawumbwe, alimwi katakwe naba umwi wakachili kukonzya kumwaanga, nikuba kuti wabelesya nsimbi. ");
INSERT INTO dov_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nkaambo chiindi chiingi wakanoonga waangwa nsimbi kumaboko akumawulu, pesi wakanoonga wazipasuula akutyola zyoonse nzyakanoonga waangwa aazyo. Takwe naba umwi wakali anguzu zyakumuzunda ");
INSERT INTO dov_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chiindi choonse sikati amansiku wakali kukwiila kumawumbwe amuzilundu akulichubbulula amabwe. ");
INSERT INTO dov_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Lino naakabona Jesu kulekule, wakachijaana wakuwa bufugeme munsi lyamawulu aakwe, kunembo lyakwe. ");
INSERT INTO dov_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wakoompolola ajwi pati wati, “Uyaandanzi kulindime Jesu, Mwana wa Leza Mupati Kampatila? Ndakumbila muzina lya Leza kuti utandipenzyi pe! ” ");
INSERT INTO dov_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nkaambo Jesu wakali wati kuli nguwe, “Zwaa mumwaalumi oyu iwe nomuuya mubi!” ");
INSERT INTO dov_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Lino Jesu wakabuzya kuti, “Nduweni izina lyako? ” Wakasandula wati, “Izina lyangu ndime Ligiyoni, nkaambo tulibayiingi. ” ");
INSERT INTO dov_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wakakombelezya Jesu kuti atabatandi pe kuzwa mubusena oobo. ");
INSERT INTO dov_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kwakali butanga bupati bwangulube bwakali kuchela aakalundu kali afwiifwi, ");
INSERT INTO dov_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","myuuya mibi yakakombelezya Jesu yati, “Tutandile mungulube; utuzumizye kuti tunjile mulinzizyo. ” ");
INSERT INTO dov_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Wakayizumizya, elyo myuuya mibi yakazwa yaakunjila mungulube. Mweelwe uli zyuulu zibili wabutanga bwa ngulube zyakagwilimina kujenga zyaaliwalila mulwizi zyanikila ");
INSERT INTO dov_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Aabo bakali kweembela ngulube bakachijanina kuyowaamba kudolopo amumyuunzi, lino bantu bakayinka kuyobona chakali chachitika. ");
INSERT INTO dov_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lino nibakasika kuli Jesu, bakamubona mwaalumi wakanjidwe ligiyoni wamyuuya mibi. Wakalikkede, kasamide, amizeezo yakwe yakali yaba kabotu. Eelyo bakayoowa. ");
INSERT INTO dov_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Abo bakazibona bakaambila bantu azyakachitika kuli ooyu mwaalumi wakanjidwe muuya mubi, bakapandulula azyakachitika kungulube. ");
INSERT INTO dov_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mpawo bantu bakatanguna kumukombelezya Jesu kuti azwe muchisi chabo. ");
INSERT INTO dov_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Lino Jesu nakaanjila mubwaato, mwaalumi wakanjidwe muuya mubi wakamukumbila kuti beende amwi. ");
INSERT INTO dov_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesu wakamukakila, pesi wakati, “Kuya kumuunzi kuli bakulindinywe ukabaambile Mwami nzyaakuchitila, ambaakufwida luzyalo. ” ");
INSERT INTO dov_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eelyo mwaalumi ooyu wakeenda wakwaambila baku Dekkapolisi nzyakamuchitila Jesu. Mpawo bantu boonse bakagamba. ");
INSERT INTO dov_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lino Jesu naakazubuka lubo abwaato kuya mutala alwizi, bantu bayingi bakamubunganina kali kunkomwe yalwizi. ");
INSERT INTO dov_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Lino umwi mweendelezi wachikombelo utegwa Jayilosi, wakaya nkukooko. Naakabona Jesu, wakawida kumawulu aakwe. ");
INSERT INTO dov_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mpawo wakamukombelezya chamoyo woonse wati, “Mwanaangu musimbi waamba kufwa, wenche kuza umubike maboko, ulasilikwa apone. ” Lino Jesu wakeenda awe. ");
INSERT INTO dov_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bantu bayiingi bakamutobela bamubunganina bamubika aakati. ");
INSERT INTO dov_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mpawo awo kwakali mwanakazi wakali kuchiswa kalobola kwaminyaka ilikkumi ayibili. ");
INSERT INTO dov_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wakafwaba kapati loko mukusilikwa abasilisi bayingi, alubo wakamana lubono lwake loonse. Nikuba boobo taakwe nakapona pe, bulwazi bwakayindilila. ");
INSERT INTO dov_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kali wamvwa impuwo zya Jesu, wakasika wanjila munkamu kusule lya Jesu wajata chisamo chakwe. ");
INSERT INTO dov_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nkaambo wakayeeya kuti, “Kufumbwa ndaguma chisamo chakwe ndilapona. ” ");
INSERT INTO dov_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mpawo awo bulowa bwakagama, alimwi wakamvwa mumubili wakwe kuti wapona bulwazi bwakwe. ");
INSERT INTO dov_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mpawo awo Jesu wakamvwa kuti nguzu zyamana mumubil wakwe. Wakachebukila musule wabuzya wati, “ani ngwani waguma chisamo changu? ” ");
INSERT INTO dov_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Basikwiiya bakwe bakasandula bati, nga ulabuzya biyeni kuti, “ngwani wandiguma? ” Kubwene bantu bayiingi balikubunganidile bakubikkide akati. ");
INSERT INTO dov_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pesi Jesu wakachiliswini kalanguula oyo wakamuguma. ");
INSERT INTO dov_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Lino mwanakazi olya mbwakalizi zyoonse zyakachitika alinguwe, wakaza kuli Jesu wawa kumawulu akwe, kazazama mukuyoowa, wamwaambila choonzyo chakachitika. ");
INSERT INTO dov_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lino wakamwaambila kuti, “Mwanaangu lusyomo lwako lwakuponia. Kuya muluumuno, waangunuke kuzwa mumafwabi ako.” ");
INSERT INTO dov_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Lino Jesu kachaambula, kwakasika bamwi bantu bakazwa kung'anda yaJayilosi Muzulwidi wambungano bati, “uchimukatazizyaanzi Muyiisi, ” teemwanaako musimbi wafwa kale?.” ");
INSERT INTO dov_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesu tatambwide pe ezizyakali kwaambuulwa, wakaambila Jayilosi kuti, “Syoma utayoowi pe. ” ");
INSERT INTO dov_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wakeenda aPita, Jemusi aJoni mukulana waJemusi, tewakazumizya bantu bayiingi pe. ");
INSERT INTO dov_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lino nibakasika kung'anda yamweendelezi wachikombelo, Jesu wakabona kunyongana, akuchundaana kwabantu balila akomooka kupati. ");
INSERT INTO dov_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Mpawo wakanjila mukati wabaambila kuti, “Nkaambonzi nimunyongana akoomoka, Mwana tafwide pe uledebiyo? ” ");
INSERT INTO dov_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mpawo bakamuseka. Lino naakamana kubatandila anze boonse, wakabweza wisi amusimbi abanyina abasikwiiya mbakali abo, wanjila omo mwakali mwana. ");
INSERT INTO dov_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wakajata luboko lwamusimbi wamwaambila kuti, “Talita kkumi! ” (chaamba kuti, kasimbi buka! ”) ");
INSERT INTO dov_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mpawo awo musimbi wakanyampuka, weendeenda (wakali aminyaka ilikkumi ayibili). Alizeezi, bantu bakagambwa loko. ");
INSERT INTO dov_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wakabaambila malayilile mayumu akuti bataambili muntu atala azyakachitika, mpawo wakati amumupe chakulya. ");
INSERT INTO dov_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wakazwa awo mpawo waya ku chisi chakulimbabo, mpawo basikwiiya bakwe bakamutobela. ");
INSERT INTO dov_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lino buzuba bwa Sabata nibwakasika, wakatalika kuyiisya muchikombelo. Bantu bayiingi bakamumvwa kayiisya bakagamba. Bakabuzya kuti, “Ooyu mwaalumi wakazijana kuli njiisyo eez? i” “Mbusongoonzi mbwapedwe?” “Maleele alibuti aaya ngachita amaanza aakwe?” ");
INSERT INTO dov_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Ooyu teensi nguwena mubezi mwana wa Meli? Mwana wakwabo waJemusi, Josefa, Judasi aSayimoni? Bachizi bakwe teensi mbabo aaba mbitulabo na? Mpawo bakamubijilwa Jesu. ");
INSERT INTO dov_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu wakati kulimbabo, “Musinsimi tajani bulemu pe, kunze kwamuchisi, amung'anda mwazyalwa aakati kabasinzubo zyakwe. ” ");
INSERT INTO dov_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tewakakonzya pe kuchita malele, kunze kwakukumbila biyo bachiswa akubabikka maboko akubasilika. ");
INSERT INTO dov_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Alimwi kutasyoma kwabo kwakamugambya. Wakeendeenda mugunzi eelyo kayabuyiisya. ");
INSERT INTO dov_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Mpawo wakayita bali kkumi ababili wabatuma babili babili akubapa nguzu zyakuzunda myuuya mibi, ");
INSERT INTO dov_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","mpawo wakabaambila kuti tababwezi chintu mulweendo lwabo kunze, chakulya niiba nkomwe niiba mali mumikumba yanu kunze amufunko, ");
INSERT INTO dov_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","pesi basame nsangu pesi batabwezi zisamo zimbi. ");
INSERT INTO dov_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mpawo wakati kuibabo, “Nimuyoonjila mumuunzi mukkale mumo omo lumwi do mukazwe mugunzi eelyo. ");
INSERT INTO dov_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na kulibusena nkubakaka kumutambula nikuba kumuswiilizya, nimuyozwa mubusena oobo, mukasansamune lusuko kumawulu anu bukabe bukamboni atala lyambabo.” ");
INSERT INTO dov_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bakazwa baya kukukambawuka kuti bantu basanduke. ");
INSERT INTO dov_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bakaanda myuuya mibi miingi mpawo bakananika bachiswa bayiingi amafuta alimwi bakapona. ");
INSERT INTO dov_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mwami Helodi wakazimvwa eezi, nkaambo zina lya Mwami Jesu lyakali lyazibikana loko. Bamwi bakati, “Amwi ngu Joni Mubbabbatizyi wabusigwa kuzwa kubafu, nkikaako nguzu zyamalele nzizilikubeleka mulinguwe. ” ");
INSERT INTO dov_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bamwi bakati, “Ngu Elayija”. Alimwi bamwi bakati, “Musinsimi, nguumwi wabasinsimi bachiindi.” ");
INSERT INTO dov_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pesi Helodi naakamvwa obu wakati, “Joni mwaalumi oolya ngundakadunsula mutwe wakabusigwa kuzwa kubafu. ” ");
INSERT INTO dov_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nkaambo Helodi lwake ngwakali wapa nguzu kuti Joni aangwe, alimwi wakaangwa akubikwa muntolongo nkaambo ka Helodiyasi (muka Filipi mwanana wakwabo) ngwakali wakwata. ");
INSERT INTO dov_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nkaambo Joni wakanoonga waambila Helodi kuti, “Tachili chibotu kuti ukwate mukayintu wamwana wakwenu. ” ");
INSERT INTO dov_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Lino Helodiyasi wakalijisi mfwindilili yakuyanda kujeya Joni, pesi tewakakonzya pe, ");
INSERT INTO dov_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","nkaambo Helodi wakali kumuyoowa Joni; wakalimwizi kuti muntu ululeme kali musalali, aboobo wakali kumutabilila. kumuswiilila kwakalikumunyongania loko, pesi wakalikumumvwa chiindi choonse kawangunukide. ");
INSERT INTO dov_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lino mweenya wakaba awo Helodi naakachita pobwe lyakuzyalwa kwakwe mpawo wakachita pobwe pati kachitila bapati abasilumamba bakwe, abeendelezi bapati bamu Galili. ");
INSERT INTO dov_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mpawo mwana musimbi waHelodiyasi nakasika wazyana, zyakabotezya Helodi abeenzu bakatambidwe kupobwe. Lino Mwami wakati kumusimbi, “Ndikumbile kufumbwa nchuyanda, ndilakupa.” ");
INSERT INTO dov_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mpawo wakamusyomezya achikonke wati, “Kufumbwa nchuyokumbila nichiba chipanzi cha bwami bwangu, ndilakupa. ” ");
INSERT INTO dov_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wakazwa waya kuli banyina wakwaamba kuti, “Ngandilakumbilaanzi? ” Banyina bakati, “Mutwe wa Joni Mubbabbatizyi” ");
INSERT INTO dov_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mpawo aawo wakanjila akufwabaana kuMwami achikumbilo chakwe wakwaamba wati: “Ndiyanda kuti lino, undipe mutwe waJoni Mubbabbatizya mukasuwo.” ");
INSERT INTO dov_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nikuba kuti eechi chakamuchisa loko mwami, pesi nkaambo kachikonke achikumbizyo, antoomwe abeenzu bakwe taakayanda kumukakila pe. ");
INSERT INTO dov_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mpawo wakafwambaana kutuma silumamba kuti akeete mutwe waJoni. Lino wakeenda wakudunsula mutwe waJoni muntolongo, ");
INSERT INTO dov_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","mpawo wawuleta mukasuwo wamupa musimbi oyo, mpawo musimbi, wakatola kuli banyina. ");
INSERT INTO dov_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nibakamvwa oobo, basikwiiya baJoni bakaza kuzobweza mutumba akuubaamba muchibunda. ");
INSERT INTO dov_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mmpawo baTumwa, bakamubunganina Jesu, bamwaambila zyoonse nzibakachita akuyiisya. ");
INSERT INTO dov_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lino nkaambo kakuti bantu bayiingi bakalikuza kabeenda kabatakwe nibajana chiindi chakuti balye, wakati kulimbabo, “Muzide okuno kusitikide mulyookezye. ” ");
INSERT INTO dov_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bakeenda muli chabochabo mubwaato bazubuka baya kutakwe bantu pe. ");
INSERT INTO dov_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lino bamwi bakababona nibakazubuka bakabaziba mpawo bakeenda amawulu kuzwa mumyuunzi yoonse bakubatangunina kusika. ");
INSERT INTO dov_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lino nibakasika kuchito Jesu wakabona makamu makamu abantu, wakabafwida luzyalo, nkaambo bakali mbuli mbelele zitakwe mweembeli. Mpawo wakatanguna kubayiisya zintu zyiingi. ");
INSERT INTO dov_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lino muchiindi eechi lyakali lyaba goko, basikwiiya bakwe bakaza kuli nguwe bakati, “Okuno nkubusena butakwe chintu, alubo chiindi chamana. ");
INSERT INTO dov_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Baande bantu aba baye mumyuunzi izyungulukide munyika oomu bakalyulile chakulya.” ");
INSERT INTO dov_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pesi wakabasandula wati, “Mubape chakulya ndinywe. ” Bakati kuli nguwe, “Nga tulayinka na tukawule mikamu yachinkwa yiita myaanda yobile yama denari kuti tubape balye?” ");
INSERT INTO dov_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wakababuzya wati, “Mujisi zinkwa zingane? Mwiinke mukalange. ” Nibakalanguula bakati, “Tujisi zinkwa zili musanu abaswi babili.” ");
INSERT INTO dov_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wakabalayilila kuti baambile bantu boonse kuti bakkale muzibumga zibumga abwizu butete. ");
INSERT INTO dov_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mpawo bakakkala ansi muzibunga; muzibunga zyamyaanda azya makumi musanu. ");
INSERT INTO dov_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Wakabweza zinkwa zili musanu abaswi babili, mpawo wakalanga kujulu, wakapa kulumba elyo wakakwamuna zinkwa mpawo wazipa kuli baikwiiya kuti bape bantu. wakakwamuna baswi babili mpawo wabapa boonse. ");
INSERT INTO dov_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bakalya boonse bakkuta. ");
INSERT INTO dov_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bakabwezelela bufwefwelenga bwazinkwa, abaswi bwakachala bazuzya zisuwo zili kkumi azibili. ");
INSERT INTO dov_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Imweelwe wabaluumi bakalya wakali kusika kuzyuulu zili musanu. ");
INSERT INTO dov_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mpawaawo wakaambila basikwiiya bakwe kuti banjile mubwaato bazulule baye mutala, ku Betisayida, wakaambila bantu kuti bamwayike. ");
INSERT INTO dov_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nibakeenda, wakaya kuchilundu kuti akakombe. ");
INSERT INTO dov_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lino nilyakaba goko, bwaato bwakali akati kalwizi, we wakachaala alikke kunze. ");
INSERT INTO dov_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wakabona kuti kuti balokuzundaana aluuwo, nkaambo luuwo lwakabalwanisya. Achiindi chamansiku wakeenda atala ameenda, kaya kuli mbabo. Wakali wamba kubayinda kumbali. ");
INSERT INTO dov_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pesi nibakamubona keenda atala alwizi, bakayeeyanga ncheelo, bakoomba, ");
INSERT INTO dov_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","nkaambo boonse nibakamubona bakayoowa. Mpawo awo wakabaambuuzya wati, “Mujate moyo! Ndime. Mutayoowipe!” ");
INSERT INTO dov_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Elyo wakatanta mubwaaato ambabo, mpawo luuwo lwakamana. Bakagambwa loko, ");
INSERT INTO dov_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mbokunga tebakamvwisisisya pe atala azinkwa; myoyo yabo yakayumisigwa. ");
INSERT INTO dov_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lino nibakazubukila mutala, bakasika ku Jenesaleti bakaanga bwaato kunkomwe yalwizi. ");
INSERT INTO dov_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kabachizwa biyo mubwaato bantu batalika kumuziba Jesu. ");
INSERT INTO dov_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bakachijaana chisi choonse alimwi bakabweza bachiswa amalo akubatola oko kufumbwa nkubakamvwa kuti nkwabede. ");
INSERT INTO dov_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lino kufumbwa kumyuunzi nkwakaya, kumadolopo naanka kumabazu anyika bakalikubikka bachiswa muzisambalilo. Bakamukumbila kuti bajate chisamo chakwe, abaabo bakajata bakaponesegwa. ");
INSERT INTO dov_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","BaFalisi abamwi bayiisyi bamulawu bakali bazwa ku Jelusalema bakamubunganina ");
INSERT INTO dov_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mpawo bakabona bamwi basikwiiya bakwe kabanikulya chakulya amaboko “atasalali, ” nkukuti, atasambide. ");
INSERT INTO dov_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(BaFalisi abaJuda boonse tabalyi chakulya kabatasambide maboko pe mbuli kuchiyanza chabo, nkaambo bajisi mbuli tunsiyasiya twabapati. ");
INSERT INTO dov_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nibazwa kuzisambalilo ba Falisi tabalyi pe kabatasambide. Balalondola atumwi tunsiyansiya twiingi, tuli mbuli kusanzya nkomechi, nongo zyameenda azilongo nzikbalida.) ");
INSERT INTO dov_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Lino baFalisi abayiisyi bamulawu bakabuzya Jesu bati, “Nkaamboonzi basikwiiya bako nibatalondoli tunsiyansiya twabapati, balalya kabatasambide?” ");
INSERT INTO dov_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Wakabasandula wati, “Isaya wakasinsima kabotu aatala andinywe nibasikuupawupa; mbuli mbaakalemba kuti: 'Aba bantu bandilemeka amilomo yabo, pesi myoyo yabo ilikule andime. ");
INSERT INTO dov_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nkombyo zyabo tazikwe nchizyaamba, bayiisya milawu yabantu aziyanza zyabo.' ");
INSERT INTO dov_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mwakalekezya milawu yaLeza, mpawo mwajatisya ziyanza zyabantu. ” ");
INSERT INTO dov_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mpawo wakabaambila wati, “Mujisi nzila inembene yakusunzulusya mulawu waLeza akuubikka kumbali kuti mulondole kabotu tunsiyansiya twanu! ");
INSERT INTO dov_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mozesi wakati, 'Lemeka wuso abanyoko,' akuti 'kufumbwa muntu utukila wisi abayina, weelede kujeegwa.' ");
INSERT INTO dov_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pesi nywe mulati, 'Na muntu waamba kuli wisi abanyina, kuti “Kufumbwa zilibiyeni nzimwakagwasigwa kulindime ngu ‘Kkobbani’ (nkukuti, 'Nchilumbyo cha Leza',) - ");
INSERT INTO dov_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","elyo tamumuzumizyi kuti achitile wisi abanyina chimwi chintu. ");
INSERT INTO dov_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mulalobya ijwi lya Leza nkaambo katunsiyansiya twanu ntumwakabamba. Alimwi mulachita zintu zyiingi zili mbuli eezyo.” ");
INSERT INTO dov_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mpawo Jesu wakayita makamumakamu abantu wati kulimbabo, “Amundiswilizye, moonse, mumvwisisisye. ");
INSERT INTO dov_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Takwe chili kunze amuntu chikonzya kumuninaania kuti chanjila mulinguwe. Chininaania muntu ncheecho chizwa mukati mumoyo wamuntu nchimuninaania.” ");
INSERT INTO dov_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesu kali wasiya makamumakamu aabantu akunjila mung'anda, basikwiiya bakwe bakamubuzya atala achikozyano eechi. ");
INSERT INTO dov_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesu wakati, “Tamunaaba akumvwisisisya pe? ” Tamubwene na kuti taakwe chinjila mumuntu chili kunze kwamuntu chinga chilamuninaania chanjila mukati mulinguwe, mbukunga ");
INSERT INTO dov_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tachinjili mumoyo wakwe pesi muubula biyo mpawo chazwa kunze. ” Mukwaamba oobu Jesu wakasalazya zyakulya zyoonse. ");
INSERT INTO dov_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wakati, “Chizwa mumuntu nchichita kuti aninaane. ");
INSERT INTO dov_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nkaambo mukati ka myoyo ya bantu, muzwa mizeezo mibi, buyangwe, kubba, bujayi, ");
INSERT INTO dov_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bwamu, bwaanka, luuni, lweeno, cheendwe, ibbivwe, kusinga, kulipunayizya abufubafuba. ");
INSERT INTO dov_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Zibi eezi zyoonse zizwa mumoyo nzizininaania muntu.” ");
INSERT INTO dov_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wakanyampuka aabusena oobo akuya kuchlikiti cha chaTaya a Sidon. Wakanjila mung'anda alimwi tewakayanda kuti azibinkane kuti mpali amuntu naba omwe, nekuba boobo wakakachilwa kuyuba kuti bantu batamuboni. ");
INSERT INTO dov_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mpawaawo umwi mwanakazi wakali amwana wakanjidwe muuya mubi, mbakamvwa biyo aatala aJesu wakaza wawida kumawulu aakwe. ");
INSERT INTO dov_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mwanakazi oyu wakali wamusyobo waba Gilikki wakazyalilwa kuSiliya Fonisiya. Wakakumbila Jesu kuti atande muuya mubi uzwe mumwana wakwe. ");
INSERT INTO dov_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Wakamwaambila wati, “Weelede kulekela bana kuti balye saansi. Nkaambo tachili kabotupe kubweza chakulya chabana mpawo usowele bankala. ” ");
INSERT INTO dov_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pesi wakamuvwiila wati, “Iiyi, Mwami, nekubaboobo alabo bankala balabwezelela bumbulumbulu bulosya bana munsi lyatafula.” ");
INSERT INTO dov_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Mpawo wakamwaambila kuti, “Mbwasandula obo, enda biyo, muuya mubi wazwa kale mumwana wako. ” ");
INSERT INTO dov_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mpawo wakajoka kung'anda wajana mwana ulilede abulo, muuya mubi kali wazwa kale. ");
INSERT INTO dov_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lino Jesu wakazwa kubusena bwaTaya wakeenda wayinda muSidoni, katozya kulwizi lwaGalili mpawo wanjila muchilikiti chaDekkapolisi. ");
INSERT INTO dov_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ooku, bamwi bantu bakamweetela mwaalumi musinkematwi kali sichilimilimi, mpawo bakamukumbila kuti amubikke luboko lwakwe amuponisye. ");
INSERT INTO dov_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Wakamubweza wakamugwisya mubantu biingi wamutola kumbali, wakamunjizya minwe mumatwi. naakaswida wamudompa alulimi. ");
INSERT INTO dov_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mpawo wakalungumana walanga kujulu, woompomoka wati kulinguwe, “Efata, ” nkukwaamba kuti, “Sinkuka! ”. ");
INSERT INTO dov_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nizyakachitwa eezi mwaalumi oolya akasinkuka matwi aakwe, lulimi lwakwe lwakaangunuka mpawo watanguna kwaambuula kabotu. ");
INSERT INTO dov_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Wakabalayilila kuti bataambili bantu. Pesi nakanoonga wabalayilila oobu, bantu nibakayindilila loko kwaambuula azyakachitika. ");
INSERT INTO dov_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bantu bakazula kugamba kabaamba kuti, “Uchita kabotu loko muzintu zyoonse ulaponia basinkematwi abasichilimilimi.” ");
INSERT INTO dov_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kumazuba ayo, kwakaba alubo bantu bayingi loko, alimwi kabatajisi nekuba chakulya. Jesu wakayita basikwiya bakwe mpawo wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ndamvwa lweetelelo amakani nkaambo bakendelela kunembo kabali ambebo kale kwamazuba otatwe alimwi kabatakwe nchebakalya. ");
INSERT INTO dov_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Na ndabambila kuti kabaya kumyuunzi yabo katakwe nchebalya, bayoowizuka munzila. Bamwi babo bazwa musinzo mulamfu”. ");
INSERT INTO dov_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Basikwiiya bakwe bakamusandula, “Nkukuli nkotuyojana chinkwa chizulide mubusena buyuminide buyokkutya bantu aba?” ");
INSERT INTO dov_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wakababuzya, “Mujisi zinkwa zyongane?” Bakamba kuti, “Musanu azibili”. ");
INSERT INTO dov_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wakalayilila makamu kuti akkale ansi. Wakabweza zinkwa musanu azibili, wakapa kulumba alimwi wakazikwamuna. Wakapa basikwiiya bakwe kuti babikke kunembo lyabo, alimwi bakabikka kunembo lyamakamu. ");
INSERT INTO dov_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aboobo bakala answi ziche, nakamana kupa kulumbila mbabo, wakalayilila basikwiiya kuti baabe azezi lubo. ");
INSERT INTO dov_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bakalya pele bakakkuta, pele bakabwezazelela bufwefwelenga bwakachala, insuwo mpati zilimusanu azibili. ");
INSERT INTO dov_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kwakachibe zyuulu zyoone zyabantu. ");
INSERT INTO dov_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mpawo wakabatuma kuti beende. Nibakamana bakanjila mubwaato abasikwiiya bakwe, alimwi bakaya kuchisi chaku Dayimanuta. ");
INSERT INTO dov_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mpawo baFalisi bakasika anze kumukanza. Bakakumbila zitondezyo zyakujulu, kuti bamusunke. ");
INSERT INTO dov_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wakagamba kapati wayoyela mukati wamba wati, “Nkambonzi izyalane eli niliyandula zitondezyo? Nchobeni ndamwambila kuti, takwe chitondezyo nchiyopegwa kuzyalane eli”. ");
INSERT INTO dov_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mpawo wakabasiya, wabweeda mubwaato lubo, akwiinka kulubazu lumbi. ");
INSERT INTO dov_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lino basikwiiya bakaluba kubweza chinkwa beni. Tebakachilikwe chinkwa nikuba chomwe mubwaato. ");
INSERT INTO dov_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Wakabalayilila wakati, “Mube akulangila alimwi muchenjele kubumena bwama Falisi akubumena bwa Heloda”. ");
INSERT INTO dov_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Basikwiiya bakabonisyana umwi awumwi, “Nkambo kakuti tatukwe chinkwa”. ");
INSERT INTO dov_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu wakaziziba ezi, wakati kuli mbabo, “Nkambonzi nimulikubonisyana akubula chinkwa? Sa tamuna kubona? Sa tamuna kumvwisya? Sa myoyo yanu ichilimiyumu? ");
INSERT INTO dov_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mula ameso, tamuboni na? Mulamatwi, tamumvwi na? Sa tamuyeyi? ");
INSERT INTO dov_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nindaka kwamuna zinkwa zilimusanu mumwelwe wamusanu wazyuulu, nzingane nsuwo zyakazwide zyabufwefwelenga bwazinkwa nzimwakabwezelela? Bakati kulinguwe, “Ikkumi azibili. ");
INSERT INTO dov_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Nindakakwamuna zinkwa zilimusanu azibili mumwele wazyuulu zine, nzingane nsuwo zyabufwefwelenga bwazinkwa nzemwakabweza?” Bakati kulinguwe, “Musanu azibili”. ");
INSERT INTO dov_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wakati, “Sa tamunakumvwisya na?” ");
INSERT INTO dov_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bakasika kuBetisayida. Bantu bankuko bakamwetela umwi mwalumi mofu alimwi bakakumbila Jesu kuti amugume. ");
INSERT INTO dov_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesu wakajata mwalumi mofu ajanza, akumutola kumbali agunzi. Nakasikaswida aansi wakanda bulongo wakamunanika kumeso akwe akumubikka janza lyakwe, wakamubuzya, “Kuli nchwabona na?” ");
INSERT INTO dov_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Wakalanga kujulu wakati, Ndabona balumi balangika anga minsamu ilokweenda. ");
INSERT INTO dov_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Alimwi wakabikka lubo maanza atala ameso akwe, aboobo mwalumi wakabona, meso akwe akabweda, akubona zintu zyoonse chaantanganana. ");
INSERT INTO dov_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu wakamutuma wakati koya kumunzi wanu, “Utakunjili mudolopo”. ");
INSERT INTO dov_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesu wakiinka abasikwiiya bakwe mugunzi lyaKayisala Filipo. Kabachili munzila wakabuzya basikwiiya bakwe, “Bantu bandamba kuti ndimeni?” ");
INSERT INTO dov_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bakamusandula bakati, “Joni muBbizyi. Bamwi baamba kuti Eliya, abamwi, nduwe umwi wabasinsimi”. ");
INSERT INTO dov_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wakababuzya, “Pele nywebo mundamba kuti ndimeni?” Pita wakati kulinguwe, “Nduwe Kilisito” ");
INSERT INTO dov_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesu wakabachenjezya kuti batambili nikuba umwi atala anguwe. ");
INSERT INTO dov_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wakasanguna kubayiisya atala akuti Mwana Muntu uyofwabisigwa muzintu zyingi, alimwi uyokukakwa abapati akuba payizi bami akubalembi, akuyojayigwa, pele mumazuba atatu uyobuka. ");
INSERT INTO dov_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wakamba makani aya chaantanganana. Mpawo Pita wakamutola kumbali akumukalalila ");
INSERT INTO dov_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pele Jesu wakachebuka akulanga basikwiiya bakwe mpawo wakakalalila Pita wakati, “Kozwa kusule lyangu, Satani! Tubikkide miyeyo yako kuzintu zya-Leza, pele kuzintu zyabantu”. ");
INSERT INTO dov_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mpawo wakayita makamu abasikwiiya antoomwe, wakabambila kuti, “Na kulumwi uyanda kunditobela welede kulitakata lwakwe mwini, abweze chingano chakwe, akunditobela ");
INSERT INTO dov_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kufumbwa uyanda kufutula buumi bwakwe uyobuswekelwa, ayoyo usweekelwa bumi bwakwe akuyanda kwangu akujwi lyangu uyobujana. ");
INSERT INTO dov_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nimpindunzi njajana muntu kukuvuba nyika yoonse alimwi akuyoswekelwa buumi bwakwe? ");
INSERT INTO dov_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nchili muntu nchakonzya kupa kwinda buumi bwakwe? ");
INSERT INTO dov_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kufumbwa ufwa nsoni akaambo kangu amajwi angu muchibaka chamamambe achibi chazyalane, Mwana aMuntu uyowusigwa nsoni anguwe nakusika mubulemu bwaWisi antoomwe abangelo basalala”. ");
INSERT INTO dov_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wakati kulimbabo, “Nchobeni ndati kuli ndinywe, mpubali bamwi banu bayimvwi awa katakoyofwa banjila kabatana bona Bwami bwakujulu bwa-Leza busika kabuli anguzu. ");
INSERT INTO dov_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nikwakayinda mazuba alimusanu alimwi, Jesu wakabweza Pita, Jemusi aJoni wakeenda ambabo atala amulundu, lwakwe ambabo. Mpo wakasanduka kunembo lyabo. ");
INSERT INTO dov_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zyakusama zyakwe zyakangayima, zyakatubisisya kwiindilila loko kutuba kwiinda chintu chitubisisya munyika chinga chilakonzya kupenda chimwi. ");
INSERT INTO dov_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mpawo Elayija kali aMozesi wakalibonya kulimbabo alimwi wakalikwambula a Jesu. ");
INSERT INTO dov_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita wakasandula akwamba kuti kuli Jesu, “Muyiisi, nchibotu kuba ano toonse, atuyake zilawu zyotatwe, chimwi chibe chako, chimwi chibe chaMozesi alimwi chimwi chibe cha Eliya”. ");
INSERT INTO dov_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Takalizi zyakwamba, nkambo wakali yowede.) ");
INSERT INTO dov_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ijoba lyakasika akubavumba. Mpawo ijwi lyakazwa mujoba,”Ooyu ngomwana wangu ngundiyandisya. Amumuswiilile”. ");
INSERT INTO dov_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aboobo, nibakalanga kumbali, bakabona kakutachikwe muntu akati kabo pesi Jesu alikke. ");
INSERT INTO dov_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nibakalikuya buseluka kuzwa achilundu, wakabalayilila kuti tabelede kubuzya kufumbwa omwe nzibakabona kusikila Mwana aMuntu akabuke kuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mpo bakabamba twaambo twabo beni, pesi bakazuwisyana lwabo beni ninzi “Kubuka kuzwa kubafu” zyambaayi. ");
INSERT INTO dov_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bakamubuzya, “Nkambonzi balembi nibakati Eliya nguyelede kutalika kusika?” ");
INSERT INTO dov_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wakati kulimbabo, “Eliya ulelede kutalika kusika kuzobambulula zintu zyoonse. Lino nkaambonzi nikulembedwe kuti Mwana waMuntu nelede kufwabisigwa kuzintu zyiingi akunyonganisigwa? ");
INSERT INTO dov_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pesi ndamwambila kuti Eliya wasika, bakachita kufumbwa nzibayanda kuchita alinguwe mbuli mbukulembedwe atala anguwe”. ");
INSERT INTO dov_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mpawo nibakasika kuli basikwiiya, bakabona makamu abantu kabazyungulikide. ");
INSERT INTO dov_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mpo balembi bakali kukazyanya ambabo. Lino nibakabona Jesu, makamu woonse akagamba nibakamuchijanina bakamujuzya. ");
INSERT INTO dov_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wakabuzya basikwiiya bakwe, “Mulikukazyananzi ambabo?” ");
INSERT INTO dov_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Umwi wakalinkamu wakasandula, “Omwiiyi, ndeeta mwana wangu kulinduwe ulamuuya umwiita kuti atambuulipe. ");
INSERT INTO dov_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Umumana manguzu akumuwunsizya ansi akuzwa kkovu mumulomo, ngawayuma ntwiinyo, akuyuma mubili. Ndakabuzya basikwiiya bako kuti bamugusye asi bakakachilwa”. ");
INSERT INTO dov_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Wakabasandula, “Mazyalane atasyomi, ndakkala andinywe kwachiindi chilibuti? Ndiyomukombelezya kuchiindi chilibuti? Mumweete kuli ndime” ");
INSERT INTO dov_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bakamweta mulombe kulinguwe. Kuchindi muuya nwakabona Jesu, mpawo awo lyakamuwisya lyamupa kugwigwima. Mulombe wakawida ansi akuzwa ikkovu mumulomo. ");
INSERT INTO dov_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu wakabuzya wisi, “Kwaba chiindi chilibiyeni kazichitikana?” Wisi wakati, “Kuzwa kachili mwanikenike”. ");
INSERT INTO dov_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Chimuwisizya mumulilo kkana mumanzi akwezya kumujeyakuti kukonzya kuchita kufumbwa, tufwide luzyalo utugwasye”. ");
INSERT INTO dov_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu wakati kulinguwe, “Kuti kazikonzeka zyoonse zintu zilakonzeka kuliyoyo usyoma!” ");
INSERT INTO dov_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mpawo wisi wamwana wakalila akwamba kuti, “Ndimusyomi! kondigwasya akutasyoma kwangu!” ");
INSERT INTO dov_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu nakabona makamu kabachijanina, wakatanda myuuya mibi akwaamba kuti, “Nutambuli nutamvwi ndakwambila kuti, zwamulinguwe, utazobi nunjila lubo mulinguwe”. ");
INSERT INTO dov_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lyakalila akugwigwimya mulombe akuzwa mulinguwe. Mulombe wakalanga mbuli wakalifwide, biingi bakati,”Ulifwide”. ");
INSERT INTO dov_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pele Jesu wakamubeza aluboko wamunyampula, mulombe wakayimikila. ");
INSERT INTO dov_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesu nakasika munganda, basikwiiya bakamubuzya chakusisikizya, “Nkambonzi nitwatalitanda?” ");
INSERT INTO dov_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wakati kulumbabo, “Ezi zyamisyobo oyu tazitandiki pesi akukomba”. ");
INSERT INTO dov_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bakeenda kuzwa awo akwiinda muGalilaya. Takalikuyanda kufumbwa kuti bazibe nkubakabede, ");
INSERT INTO dov_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nakalikuyiisya basikwiiya bakwe. Wakati kulimbabo, “Mwanamuntu uyopendekezegwa mumaboko amuntu, alimwi bayomujeya. Natayobikwe kulufu, nikutakayinde mazuba atatu uyobuka kuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pesi tebakazimvwisisisya pe nzyakali kwamba, alimwi bakalikuyowa kumubuzya. ");
INSERT INTO dov_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mpawo nibakasika kuKkapenamu. Mpawo nakanjila munganda wakababuzya, Mwalikwambanzi munzila?” ");
INSERT INTO dov_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pesi bakawumuna. Mbulikuti bakalibuya bukazyanya awumwi amwenzinyina kabali munzila atala akuti ngwani mupati. ");
INSERT INTO dov_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nakakkala ansi, wakayita basikwiiya bakwe bali kkumi ababili kabali boonse alimwi wakati kulimbabo, “Na kuli uyanda kuba wakusanguna, welede kuba wakumaninsizya kuli boonse akubalanda boonse”. ");
INSERT INTO dov_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wakabweza mwana munini wakamibikka akati kabo. Wakamubweza akumubikka amakwiko akwe alimwi wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kufumbwa utambula mwana oyu muzina lyangu watambula ndime, kufumbwa oyo unditambula tatambuli ndime pesi utambula oyo wakandituma”. ");
INSERT INTO dov_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Joni wakati, “Muyiisi, twabona umwi katanda badayimona munzina lyako alimwi twamukasya, nkaambo tatutobeli pe”. ");
INSERT INTO dov_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pesi Jesu wakati, “Mutamukasyi, mbulikuti takwe utakachite milimu mipati muzina lyangu alimwi mbulikuzwa awo bakambule kufumbwa zili atala andime. ");
INSERT INTO dov_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kufumbwa utakazyani andiswe ngwesu. ");
INSERT INTO dov_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kufumbwa ukupa nkomesi yamanzi kuti unywe muzina lyangu nkambo uzwa kwaKilisito, nchobeni ndamwambila kuti, takoyoyibulikilwa impindu yakwe. ");
INSERT INTO dov_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kufumbwa uchita banikenike bandisyoma kui bae, zinoli zibotu kulinguwe kuti abeze ibwe asungililwe munsingo yakwe alimwi awalwe mulwizi. ");
INSERT INTO dov_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Naa kuboko kwako kwakubisizya, kudunsule. Nchibotu kunjila mubwami bwakubotelwa kwiinda kuba amaboko abili alimwi wakuwida mubbibi lyamulilo, kumulilo utazimi. ");
INSERT INTO dov_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Munchali 44mutabikkilizidwe mu ULB. Amba kuti ichikoye chabo tachikoyofwa, alimwi mulilo tukoyozimwa. ");
INSERT INTO dov_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Na kuulu kwako kwakuchita kuti ubisye, kudunsule. Nchibotu kunjila mubuumi bwakubotelwa kuli chilema kwiinda kuba amawulu abili alimwi wakuwida mubbibi lyamulilo. ");
INSERT INTO dov_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Munchali 46 tabikkidwe pe mu ULB. Amba kuti ichikonye chabo tachikoyofwa, alimwi mulilo tukoyozimwa. ");
INSERT INTO dov_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na liso lyako lyakuchita kuti ubisye, ligusye. Nchibotu kunjila mubwami bwakujulu aliso limwi kwiinda kuba ameso abili wakuwisigilwa mubbibi lyamulilo, ");
INSERT INTO dov_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kutayofwa kwachikonye chabo, mulilo tukoyozima. ");
INSERT INTO dov_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nkaambo moonse muyolungwa amunyo wamulilo. ");
INSERT INTO dov_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Munyo mubotu, pesi kuti munyo wasapuka, ulachitwa biyeni kuti ube munyo lubo? Amube munyo nywebo nobeni, alimwi mube alumuno kuli umwi awumwi”. ");
INSERT INTO dov_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu nakazwa kubusena obo waya kuchisi chaku Judiya a kubusena bwamutala a mulongaJodani, alimwi bantu biingi bakaza lubo kulinguwe. Wakali kubayiisya lubo, mbuli mbakali wazibila kuchita. ");
INSERT INTO dov_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mpawo baFalisi bakaza kulinguwe kuzomusunka alimwi bakmubuzya kuti, “Chili mumulawu na kuti mwalumi aleke banakwe?” Wakasandula, ");
INSERT INTO dov_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","“Wakamulayilila buti Mozesi?” ");
INSERT INTO dov_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bakati, “Mozesi wakazuminina mwalumi kulemba lugwalo lwakulekana alimwi akumutanda”. ");
INSERT INTO dov_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Nkuyuma kwamyoyo yanu chakapa kuti alembe mulawo oyu”, Jesu wakabambila. ");
INSERT INTO dov_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Pele kuzwa kumatalikilo akulenga, 'Leza wakababumba, mwalumi amwanakazi'. ");
INSERT INTO dov_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Akambo kachechi mwalumi uyozwa kuliwisi abanyina ");
INSERT INTO dov_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","alimwi akakkale abanakwe, alimwi bobile bayooba nyama yomwe! Aboobo tabachili bobile pe, pele nyama yomwe”. ");
INSERT INTO dov_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aboobo Leza nzyaswanizya antoomwe, kutakabi muntu uzyaanzania”. ");
INSERT INTO dov_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Awo nibakali mun'anda, basikwiiya bakamubuzya lubo aatala achechi. ");
INSERT INTO dov_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wakati kulimbabo, “Naba ani uleka mwanakazi akukwata umbi wamuchita bumambi. ");
INSERT INTO dov_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Naa mukayintu waleka mulumi wakwe wakwatwa awumbi mwalumi, wachita bumambi”. ");
INSERT INTO dov_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mpawo bakeeta bana babo banini kulinguwe kuti abagume, pele basikwiiya bakabakalalila. ");
INSERT INTO dov_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pele Jesu nakazibona, tezyakamubotezya pe alimwi wakati kulimbabo, “Muzumizye bana mutabakasyi, nkambo bwami bwaLeza mbubwabo bali boobo. ");
INSERT INTO dov_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chakasimpe ndamwambila, naba ani utatambuli bwami bwaLeza mbuli mwana munini takonzyi kuyobunjila”. ");
INSERT INTO dov_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mpawo wakababweza bana mumanza akwe alimwi wabalongezya nakabikka maboko akwe alimbabo. ");
INSERT INTO dov_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nakatalisya lweendo lwakwe, umwi mwalumi wakachijana wazofugama kunembo lyakwe alimwi wabuzya, “Muyisi mubotu, ndichite buti kuti ndikajane buumi butamani?” ");
INSERT INTO dov_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu wakati, “Nkambonzi nuti ndimubotu? Tako pe mubotu naba umwi kunze kwaLeza alikke. ");
INSERT INTO dov_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ulizi milawo: 'Utajayi, utachiti bumambi, utabbi, utabejelezyi umwi, utabbi chakweenena, lemeka uso abanyoko.” ");
INSERT INTO dov_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mwalumimwakati, “Muyisi, zyoonse ezi zintu ndakazitibelezya kuzwa kandichili mukubusi”. ");
INSERT INTO dov_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu wakamulanga alimwi wamuyanda. Wakati kulinguwe, “Chintu chimwi nchobula. Weelede kuuzya zyoonse nzulazyo alimwi uzipe kubachete, elyo uyojana buvubi kujulu. Mpawo sika, unditobele”. ");
INSERT INTO dov_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pesi akaambo kamakani aya wakawusa kapati alimwi wakayinka kafwisya nsoni, nkambo wakali azintu zyiingi. ");
INSERT INTO dov_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu wakalangalanga mpawo wakati kulibasikwiiya bakwe, “Nchiyumu buti kubavubi kunjila mu bwami bwaLeza!” ");
INSERT INTO dov_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Basikwiiya bakagamba kumajwi akwe. ");
INSERT INTO dov_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pesi Jesu wakabambila lubo, “Nobana, nchuubawuba kunkamela kuti yiinde mumpako yanaliti kwiinda muvubi kuti anjile mubwami bwaLeza”. ");
INSERT INTO dov_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bakagamba kapati alimwi baambilana kuti, “Ngwani unga ulakonzya kufutulwa?” ");
INSERT INTO dov_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu wakabalanga alimwi wati, “Kubantu tachikonzeki, pele kuli Leza chilakonzeka. Nkambo zintu zyoonse zilakonzeka a Leza”. ");
INSERT INTO dov_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita wakatalika kwambula kulinguwe, “Boona, twasiya zyoonse twakutobela”. ");
INSERT INTO dov_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu wakati, “Nchobeni ndamwambila, takwe pe wasiya n'anda naa banyandumi naa bachizi naa banyina naa bana naa nyika akambo kandime alimwi akambo kavangeli, ");
INSERT INTO dov_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","utakabule kutambula zyiindulwidwe mwaanda munyika omuno lino: n'anda abanyandumi a bachizi a mamama abana anyika, mukupenzegwa, munyika utobela, buumi butamani. ");
INSERT INTO dov_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pele biingi balikumatangunino bayooba bakumamanino”. ");
INSERT INTO dov_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bakali mumugwagwa kabayabuya kuJelusalema, alimwi Jesu wakali kunembo lyab. Basikwiiya bakagamba, alimwi abaabo bakali kutobela musule bakayowa. Mpawo Jesu wakabweza bali kkumi ababili wabatola kumbali alubo watalika kubambila zizochitikana kulinguwe kuchiindi chitobela linolino. ");
INSERT INTO dov_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Amubone, tuyabuya kuJelusalema, alimwi Mwana waMuntu uyowabwa kubapayizi bapati abalembi. ");
INSERT INTO dov_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bayomupa mulandu walufu akumwaaba kulibamasi. Bayomusonsya, bayomuswida mate amubili, bayomuuma, alimwi bakamujeye. Pele kwiinda mazuba atatu uyobuka. ");
INSERT INTO dov_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jemusi a Joni, bana baZebbadi, bakaza kulinguwe bati, “Muyisi, tuyanda kuti mutuchitile kufumbwa nzituyomukumbila kulinduwe”. ");
INSERT INTO dov_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wakati kulimbabo, “Niinzi nchimuyanda kuti ndikamuchitile?” ");
INSERT INTO dov_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bakati, “Tuzumizye kuti tukkale anduwe mubulemu bwako, umwi kuchilisyo umwi kuchimwensi.” ");
INSERT INTO dov_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pele Jesu wakabasandula, “Tamuchizi nchimuli kukumbila. Mulakonzya na kunywa nkomechi njesikanywe naa kukakatila kulubbizizyo ndwesikabbizigwe andulo?” ");
INSERT INTO dov_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bakati kulinguwe, “Tulakonzya.” Jesu wakati kulimbabo, “Nkomechi njesikanywe, muyoyinywa, alimwi lubbizizyo ndwesikabbizigwe andulo, anywebo muyolubbizigwa. ");
INSERT INTO dov_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pele utakakkale kuchilisyo kana kuchimwensi tensi ndime nensyambe pe, pele nkukwabaabo babambilidwe mbubo.” ");
INSERT INTO dov_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Awo bamwi balikkumi nibakamvwa eecho, bakatalika kunyemena Jemusi a Joni. ");
INSERT INTO dov_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesu wakabayita kulinguwe wati, “Mulizi aabo baambwa kuti mbendelezi babamasi balabeendelezya, alimwi basikutwe babo bakatondezya manguzu aabo alimbabo. ");
INSERT INTO dov_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pele tazikoyooba mbubo pe akati kanu. Naba ani uyanda kuba mupati akati kanu weelede kuba mupati mulanda, ");
INSERT INTO dov_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","alimwi naba ani uyanda kuba mutanzi akati kanu weelede kuba muzike waboonse ");
INSERT INTO dov_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nkambo Mwana aMuntu takazida kuzofutulwa pe, pele kufutula, alimwi akupa buumi bwakwe kukwangununa biingi.” ");
INSERT INTO dov_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bakasika kuJelikko. Nakazwa kuJelikko abasikwiiya bakwe amakamu makamu, mwana wa Timiyasi, Bbatimiyasi, moofu, wakalikkede kumbali amugwagwa. ");
INSERT INTO dov_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Awo nakamvwa kuti Jesu muNazaleni, wakatalika koompolola wati, “Jesu Mwana waDavida, ndifwide luzyalo!” ");
INSERT INTO dov_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Biingi bakamukasya mwalumi boofu, bamwambila kuti awumune. Pele wakompolola changuzu, “Mwana waDavida, ndifwide luzyalo!” ");
INSERT INTO dov_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu wakayimikila alimwi wabalayilila kuti bamwiite. Bakamwiita mwalumi moofu, bati, “Koyuma! Nyampuka! Ulikukwiita.” ");
INSERT INTO dov_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wakasowela ansi chikobela chakwe, wasotoka alimwi wasika kuli Jesu. ");
INSERT INTO dov_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu wakamusandula wati, “Niinzi nchuyanda kuti ndikuchitile?” Mwalumi moofu wakati, “Muyisi ndiyanda kubona.” ");
INSERT INTO dov_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mpawo Jesu wakati kulinguwe, “Kuya. Lusyomo lwako lwakuponya.” Mpaawo wakabona lubo, alimwi wakamutobela mumugwagwa. ");
INSERT INTO dov_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nibakasika ku Jelusalemu kabali aafwiifwi aku Bbetipeji a Bbetani aku Chilundu chama Oliva, Jesu wakatuma basikwiiya bakwe bobile, ");
INSERT INTO dov_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","wakati kuli mbabo, “Amwiinke kugunzi lilikunembo lyenu, mbumutakanjile biyo, muyoojana mwana wembongolo waangidwe nkuko, uutanatantwa naba womwe muntu. Mukamwaangunune mumweete okuno. ");
INSERT INTO dov_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Na kuli uyomubuzya kuti, “Muchitilaanzi oobu”? mukamwaambile kuti, ‘Mwami nguulikumuyanda alubo ulamuboozya aano muchiindi chifwiifwi.” ");
INSERT INTO dov_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bakayinka baakumujana mwana wedonki kumbali aamunzi, kaangidwe kumanjililo aamunzi. Nibakamwaangununa. ");
INSERT INTO dov_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Bamwi bantu bakayimvwi mpawo bakabuzya kuti, “Muchitaanzi, nimwaangununa mwana wembongolo donki ooyu? ” ");
INSERT INTO dov_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bakasandula mbuli Jesu mbaakabaambilide, mpawo bantu bakabazumizya kuti beende. ");
INSERT INTO dov_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nibakamweeta mwana wembongolo kuli Jesu bakayala majansi amusana wakwe, Jesu wakakkala aalinguwe. ");
INSERT INTO dov_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bantu biingi bakayala milembo yabo mumugwagwa, bamwi bakayala matu ngibakatemene mumuunda. ");
INSERT INTO dov_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bakazulwide abakalimusule bakoompolola kabati, “Hossana! Ulilongezezedwe ooyo uza muzina lyaMwami. ");
INSERT INTO dov_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bulilongezegedwe ibwaami buyobuza ibwa taata wesu Davida! Hossana mujulu lyamajulu!” ");
INSERT INTO dov_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu wakanjila mu Jelusalema akwiinka ku Chikombelo bakalangalanga boonse busena, pele nkaambo kakuti lyakali lyaba goko, wakayinka ku Bbetani abalikumi aababili. ");
INSERT INTO dov_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Buzuba butobela nibakaboola kuzwa ku Bbetani, wakali waba aanzala. ");
INSERT INTO dov_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mukubona mukuyu amatu aawo chakule, wakayinka kuti akabone kuti ulaamichelo na. Naakasika afwiifwi wabona matu luzutu kakutakwe michelo, kambo techakali chiindi chankuyu pe. ");
INSERT INTO dov_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Elyo wakaambila mukuyu kuti, “Kutazoobi naba womwe uzoolya michelo kulinduwe. ” Basikwiiya baakwe bakamumvwa kawamba majwi aayo. ");
INSERT INTO dov_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Naakasika mu Jelusalema, wakanjila muchikombelo mpawo wakatalika kwaandingania bakalikuula akuuzya oomo. Wakatonta matebuli aabasimuchincha mali ezyuuno zyabaabo bakalikuuzya nkwilimba. ");
INSERT INTO dov_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mpawo takwe naakazumizya naba omwe kuti abweze zyakalikuuzigwa mulubaya lwatempele. ");
INSERT INTO dov_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mpawo naakabayiisya wakati, “Tachilembedwe na kuti: `Ng'anda yangu iyotegwa ning'anda yakukombela kwamanyika wonse’? Pesi nywebo mwayichita ng'anda yabasikubba. ” ");
INSERT INTO dov_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bapati babapayizi abasimilawo bakaamvwa makani aya eelyo bakayandula nzila zyakumujaya aazyo, bakalikumuyowa nkaambo bantu biingi boonse bakaba aakugamba enjiisyo yakwe. ");
INSERT INTO dov_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nilyakaba igoko, bakazwa mudolopo. ");
INSERT INTO dov_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chifumofumo nkabayobweenda, bakabona mukuyu nkuuyumide kuzwa kumiyanda. ");
INSERT INTO dov_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita wakayeeya mpawo wakati kuli Jesu, “Muyisi wangu langa! Mukuyu ngwakatukila wayuma!” ");
INSERT INTO dov_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu wakasandula kuti, “Amube aalusyomo muli Leza. ");
INSERT INTO dov_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ndimwaambila kasimpe kuti, na umwi wati kuchilundu, ‘Nkoya ukaliwalile mulwizi, ’ mpawo nkatadooneki mumoyo wakwe pesi nkasyoma kuti ezyo nzyawamba ziyochitika, ziyochitika mbubo. ");
INSERT INTO dov_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nkaako ndamwaambila kuti: Kufumbwa nchimuyookumbila mukukomba, amusyome kuti muyoochijana, mpawo chiyooba chanu. ");
INSERT INTO dov_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mpawo naa wayimikila kokomba, na nkowangilide umwi moyo, mulekelele, nkokuti Wuso wako ulikujulu akulekelele zibi zyako. ");
INSERT INTO dov_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Nkambo kuti inywe nkamutalekeleli bantu balaamilandu kuli ndinywe, alakwe Wuso uulikujulu takoyoomulekelela milandu yenu”. ");
INSERT INTO dov_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bakasika lubo kuJelusama. Eelyo Jesu naakayobweenda mulubuwa lwaChikombelo, bapayizi bapati, abayisyi bamulawu abapati bembungano bakeza kulinguwe. ");
INSERT INTO dov_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bakati, “Mumanguzu aani mochita zintu ziloobu? Alimwi ngwani ukupa inguzu zyakuchita zintu eezi? ”. ");
INSERT INTO dov_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu wakasandula kuti, “Ndiyobuzya mubuzyo womwe. Mundisandule, eelyo ndiyomwaambila kuti munguzu zyani mwendiikuchita zintu eezi. ");
INSERT INTO dov_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Lubbabbatizyo lwaJohani, lwakalikuzwa kujulu na, nakuti lwakazwa kumuntu? Mundambile!” ");
INSERT INTO dov_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bakayizya aatala amakani aaya mpawo bakakazyania bati, “Nitwaamba kuti, ‘Luzwa kuzulu, ’ ulatubuzya kuti 'Nkamboonzi nimutamusyomi? ’ ");
INSERT INTO dov_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pesi nitwaamba kuti, 'Luzwa kumuntu’.... ” bakayoowa bantu nkaambo muntu woonse wakalizi kuti Joni musinsimi mwinimwini. ");
INSERT INTO dov_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Alimwi bakasandula Jesu kuti “Tatuzi pe.” Mpawo Jesu wakabaambila kuti, “Nsikomwaambila pe ambebo kuti manguzu aani ngechita aawo zintu eezi”. ");
INSERT INTO dov_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mpawo wakasanguna kubaambila maambila mbali wakati, “Mwaalumi umwi wakabyala misamu yamisansa. Wakayakila lubaya aalinjiyo, wakasya dindi lyakudinina nsansa, akuyaka ingaze yasikulinda. Alimwi wakajana kupa bamwi balimi mpawo wakaya kuchisi chimbi. ");
INSERT INTO dov_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Muchiindi chakutebula wakatuma umwi wababelesi bakwe kuyoobweza michelo yamansansa. ");
INSERT INTO dov_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pesi balimi abo bakakumujata, akumuma, akumwaanda nkakutakwe nchakabweda aacho pe. ");
INSERT INTO dov_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wakatuma uumbi mubelesi; oyo mwaalumi bakamutulula mumutwe akumusampawula. Wakatuma uumbi, alubo oyo bakakumujaya. ");
INSERT INTO dov_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wakatuma bambi bingi; bamwi bakawumwa, bamwi bakajayigwa. ");
INSERT INTO dov_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kwakasyaala omwe biyo wakutuma, nkali mwana ngwaakali kuyandisya kapati. Wakamutuma nkali wakumaninsizya, wakati, “Bayomulemeka mwanaangu.” ");
INSERT INTO dov_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pesi balimi bakaambilana kuti, “Ooyu ngusimulya lukono. muze tumujaye, mpawo lukono luyoba lwesu.” ");
INSERT INTO dov_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nkabela bakamujata akumujaya, akumuwaalila anze aamuunda waminsansa. ");
INSERT INTO dov_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Aboobo ulachita buti mwani muunda? Ulasika akujaya balimi akape bambi muunda wamisaansa. ");
INSERT INTO dov_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tamuna kwaabala na malembe: ‘Ibbwe lyakasowedwe abasikuyaka ndilyakazooba ibbwe lyachooko. ");
INSERT INTO dov_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mwaami ngwaakachichita eechi, mpawo chilabotezya kumenso eesu? ’” ");
INSERT INTO dov_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Eelyo bakayanduula nzila yakumwaanga aayo nkaambo bakaziba kuti wakali kwaamba mbabo kumaambila mbali aaya. Pesi bakayoowa inkamu yabantu yakaliwo, nkaako bakamusiya mpawo bakeenda. ");
INSERT INTO dov_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Muchiindi chitobela bakatuma bamwi baba Falisi aba Heloda kuli Jesu kuti bakamujate mumakani aakwe. ");
INSERT INTO dov_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bakasika kulinguwe bakati, “Muyisi, tulizi kuti ulimwaalumi ulaabulemu usyomekede. Topenzegwi abantu, nkaambo toswiilizyi makani aamuntu na kulanga chiwa chamuntu; pesi uyiisya nzila ya Leza mbuli mbiibede amubwini. Chileede na kutela kuli Kkayisala na pe? Tweelede kuti tubbadale na, naa kuti pe? ” ");
INSERT INTO dov_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pesi Jesu wakalizi kuupawupa kwabo. Jesu wakababuzya kuti, “Kaambonzi nimulikweezya kunditeya? ” Wakati, “Amundeetele nsiliva yanu alimwi ndiibone mbiibede.” ");
INSERT INTO dov_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Elyo bakiiyeta nsiliva, alimwi wakababuzya kuti, “Mbubwani busyu obu? Alimwi ndizina lyani lilembedwe mpawo? ” Bakasandula kuti, “Nzizya Kkayisala. ” ");
INSERT INTO dov_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mpawo Jesu wakati kulimbabo, “Amupe Kkayisala zyaKkayisala, alimwi mupe Leza izya Leza. ” Bakaba aakugamba aatala anguwe. ");
INSERT INTO dov_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mpawo ba Saduki, baamba kuti takwe bubuke, bakaza kulinguwe amubuzyo. Bakati, ");
INSERT INTO dov_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Muyisi, Mozesi wakatulembela kuti, 'Na mukulana wamulumi mpawo wasiya mwanakazi kabatakwe bana, mwaalumi weelede kukwata mukamufu mpawo babe abana bamukulana.' ");
INSERT INTO dov_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kwakali bana bachaalumi bali musanu ababili. Mutaanzi wakakwata mpawo wakafwa katasiide mwana naba womwe. ");
INSERT INTO dov_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wachibili wakakwata mukamufu, pesi alakwe wakafwa katasiide mwana. Chakaba mbubo akuli watatu. ");
INSERT INTO dov_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tawope akati kababa bali musanu ababili wakasiya mwana. Kumamanino, alakwe mwanakazi wakafwa. ");
INSERT INTO dov_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kububuke bwabafu, oyu mwanakazi uyooba wani? Mbunga boonse kabali musanu abatatu bakalimukwete.” ");
INSERT INTO dov_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu wakasandula kuti, “Tamuli mubulubizi na kambo malembe tamwaazi naa kuti manguzu aa Leza? ");
INSERT INTO dov_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bafu nibayoobuka, tabakoyookwata nikuba kukwatanisigwa; bayooba mbuli bangelo kujulu. ");
INSERT INTO dov_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lino mukwaamba atala abafu nibayoobuka temwakabala na muBbuku lyaMozesi, kuleezyo zyakachitika kuchiteyo, Leza mbakaambula kulinguwe, ‘Ndime Leza wa Abbulamu, Leza wa Ayizeki, alubo Leza wa Jakobo?' ");
INSERT INTO dov_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tali Leza wabafwide, pesi ngwababapona. Mulilubizizye kapati!” ");
INSERT INTO dov_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Umwi wabayisyi bamulawo naakasika wakamvwa kabakazyania. Nkabwene kuti Jesu wakali wabapa nsandulo mbotu, wakabuzya Jesu kuti, “Nguuli mulawo mupati kwiinda imwi akati kamilawo yoonse? ” Jesu wakamusandula kuti, ");
INSERT INTO dov_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","“Ngooyu: ‘Amuswiilile, noma Izilayeli, Mwaami Leza wesu, Mwaami ngumwi. ");
INSERT INTO dov_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yanda Mwami Leza wako amoyo wako woonse, amizeezo yako yoonse, mpawo amanguzu aako woonse. ’ Wabili ngooyu: ");
INSERT INTO dov_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","‘Yanda mweenzinyokwe mbuli mboliyanda. ’ Tuwope mulawo mupati wiinda eeyi.” ");
INSERT INTO dov_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Oyu mwaalumi wakasandula kuti, “Waamba kabotu omuyisyi, waamba kabotu kuti Leza ngumwi alubo takukwe umbi kunze kwakwe alike. ");
INSERT INTO dov_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kumuyanda amoyo wako woonse, akumvwisisisya kwako alubo amanguzu aako woonse, mpawo akuyanda simabambanwa wako mbuli mboliyanda nkubotu loko kwiinda zipayizyo. ” ");
INSERT INTO dov_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Lino Jesu naakabona kuti wasandula chabuchenjezu, wakati kuli nguwe, “Tolikulepe a Bwami bwa Leza. ” Elyo kuzwa awo tawope naba omwe wakeezya kumubuzya iimbi mibuzyo. ");
INSERT INTO dov_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nkali kuyiisya Jesu mulubuwa lwatempele, wakabuzya mubuzyo wakati, “Nkamboonzi bayiisi bamulawo nibati Kilisitu mwana waDavida? We lwakwe ");
INSERT INTO dov_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devidi, kaambuzigwa a Muuya Uusalala, wakachaamba antanganana wakati: ‘Mwami wakati kuMwami wangu, kkala kukuboko kwachilisyo kwangu kusikila basinkondonyokwe ndibabike kunsi amawulu aako. ’ ");
INSERT INTO dov_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","We lwakwe Devidi umwiita kuti ‘Mwami. ’ Ani inga ulaba mwana wakwe biyeni? ” Inkamu yabantu yaka muswiilizya chalumwemwe. ");
INSERT INTO dov_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Naakalikuyiisya Jesu wakati, “Amubachenjelele bayiisi bamulawo balayandisya kweendeenda kabatungana mulongo kabajuzigwa kumasambalilo, ");
INSERT INTO dov_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","alubo akupegwa zyuuno zibotu mumambungano akulemekwa kapati aabungene bantu. ");
INSERT INTO dov_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Balanyonyoona maanda abamukabafu kabakomba ankombyo ndamfu chakweebwa. Aaba bantu bayoopegwa chisubulo chipati.” ");
INSERT INTO dov_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu wakakkala kumbali lyachiykoobwedo chazituzyo mung'anda ya Leza; bantu nibakalikuwaala mali muchiyobweedo. Bavubi biingi bakalikuwala imali nyingi. ");
INSERT INTO dov_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pesi mukamufu muchete wakabika biyo tupeni tobile, tweelene aaseleni lyomwe. ");
INSERT INTO dov_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Lino wakayita basikwiiya bakwe, wakati, Ndiikumwaambila kasimpe kuti, ooyu mukamufu wabika kwiinda boonse muchiyobwedo. ");
INSERT INTO dov_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Boonse bapa mukweendelana abuvubi bwabo; pesi we, mubuchete bwakwe, wabika zyoonse nzyaalangilide mubuumi bwakwe kuti apone anzizyo.” ");
INSERT INTO dov_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Awo Jesu nakali kweenda kuzwa mucikombelo, umwi wabasikwiiya bakwe wakati kuli nguwe, “Muyiisi langa imabwe aziyako zigambwa!” ");
INSERT INTO dov_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Wakati kulinguwe, “Ulizibwene na iziyako zipati eezi? Takwe ibwe lyomwe litakasyale atala alimwi litakwe kwakukolomwedwa ansi”. ");
INSERT INTO dov_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Awo nakakkala achilundu chama Oliva chilengene achikombelo, Pita a Jemusi a Endulu bakabuzya chakusisikizya, ");
INSERT INTO dov_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Twambile eezi zintu ziyochitikana lili? Niinzi chiyooba chitondezyo chazintu eezi kuti zyamba kuchitika?” ");
INSERT INTO dov_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu wakatalika kubambila, “Amukachenjele kuti kutakabi uyomwena. ");
INSERT INTO dov_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bangi bayoza muzina lyangu kabati, 'Ndime nguwe', pesi bayoyena bangi. ");
INSERT INTO dov_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Chiindi nimuyomvwa inkondo ampuwo zyankondo, mutakalikatazyi; ezi zintu kuleede zikachitike, pesi mamanino anoli katanasika pe. ");
INSERT INTO dov_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nkaambo inyika iyobukilana enyika, abwami buyobukilana abwaminyina. Kuyoba kuteketa kwamasena mangi anzala zyiingi. Ezi matalikilo amachise akutumbuka. ");
INSERT INTO dov_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Amukalinde. Bayomupeda kukubetekwa, alimwi muyowumwa muzikombelo. Muyoyima kunembo lyabendelezi abaami nkambo kangu, kuti bukabe bukamboni kuli mbabo. ");
INSERT INTO dov_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pesi makani mabotu ayotalika kukambawuka kunyika zyoonse. ");
INSERT INTO dov_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Alimwi nibayomwanga akumupeda, mutakalikatazyi ikuti muyotyeni. Nkambo muchiindi echo nzimutakambe muyozipegwa; teensi ndinywe mutanowambule, pesi Muuya Usalala. ");
INSERT INTO dov_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mukulana uyoozya mwanike kulufu, a wisi kumwanakwe. Bana bayobukilana abazyali babo bakabatole kulufu. ");
INSERT INTO dov_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Muyosungwa abantu boonse nkambo kazina lyangu. Pesi utajatilile mane kukabe kumamanino, oyo muntu uyofutulwa. ");
INSERT INTO dov_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nimuyobona chisesemyo chalunyonyoko kachimvwi mpuchitelede kwimikila (Oyo ubala ngamvwisye), abanolimu Judiya abachijile mumalundu, ");
INSERT INTO dov_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","akube kuti oyo uli achiluli changanda ataseluki kuya mun'anda naba kuti kuyotola chintu mukati, ");
INSERT INTO dov_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ayoyo uli mulukuba atakabwedi kukutola chisamo. ");
INSERT INTO dov_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pesi maawe kuli babo balamada ababo banyonsya bana batete mumazuba ayo! ");
INSERT INTO dov_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Amukombe kuti ezi zitakachitikani mumpeyo. ");
INSERT INTO dov_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nkambo ayo anoli mazuba akupengana kupati, atakabawo kuzwa kumatalikilo, awo Leza nakalenge nyika, kusikila lino, pe, nikuba kuti achiza alimwi. ");
INSERT INTO dov_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na kuti Mwami takafwiinsya mazuba, takwe mubuli walikuzofutulwa. Pesi nkaambo kababo basale abo basalala, wakafwiinsya mazuba. ");
INSERT INTO dov_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ino kuti umwi akatedi kulindime, 'Amulange, ngoyu Kilisito!' na kuti 'Amulange, ngulya!' mutakasyomi pe. ");
INSERT INTO dov_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nkambo kuyoba aba Kilisito bakubeja aba sinsimi bakubeja batakalibonye alimwi kuyoba zitondezyo azigambyo atakaboneke, na kuti chali chuba, basale. ");
INSERT INTO dov_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amukalindile! Ndamwambila zintu zyoonse kunembo lyachiindi. ");
INSERT INTO dov_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Pesi musule lyamazuba akupenzegwa, zuba liyoba mudima, amweezi tukoyopa mumuni, ");
INSERT INTO dov_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nyenyezi ziyoloka kuzwa kujulu, alawo manguzu alikujulu ayoteketegwa. ");
INSERT INTO dov_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Alimwi nibatakabone Mwana waMuntu kazamumayoba amanguzu a bulemu. ");
INSERT INTO dov_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Alimwi uyotuma bangelo bakwe, uyobunganya aamwi basale bakwe kuzwa kumyuya yone, kuzwa kumamanino anyika kusika kumamanino ajulu. ");
INSERT INTO dov_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Amwiiye chiiyo kuzwa kumukuyu. Awo ntabi niyisyukila matu, mwaziba kuti minza aswena. ");
INSERT INTO dov_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mbubobo, na kuti mwabona zintu kazchitikana, muzibe kuti waswena, afwifwi amilyango. ");
INSERT INTO dov_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nchobeni, ndamwambila, olu luzubo talukoyoyinda ezi zintu kazitana chitikana. ");
INSERT INTO dov_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ijulu anyika ziyoyinda, pesi majwi angu takoyinda pe. ");
INSERT INTO dov_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pesi buzuba obo achiindi, takwe muntu uzi, nikuba bangelo kujulu, na kuti Mwana, pesi kuti Taata. ");
INSERT INTO dov_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Muchengele! Mulange, nkambo tamuzi kuti chiindinzi. Amwi malembe achiindi alembedwe muchiGilikki: Muchenjele! Mulange akukomba. ");
INSERT INTO dov_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Zilimbuli muntu winka musinzo - wabusiya nganda yakwe wakwiibikka mumanza abalanda bakwe kuti bayibambe, umwi awumwi amulimu wakwe, wawabambila balinda nganda kuti amubuke. ");
INSERT INTO dov_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Aboobo amuchenjele nkambo tamuzi kuti simalelo wanganda nabola kunganda; zilakonzya kuba goko, na kuti akati kamansiku, awo mukuku niwulila, na kuti bwacha. ");
INSERT INTO dov_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Na kuti asike mpawawo, atakajani mulilede. ");
INSERT INTO dov_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nzindimwambila nywebo nditi kumuntu woonse: Linda!” ");
INSERT INTO dov_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Lino kakutanasika mazuba abili kuya kupobwe lyakwindilila alyamikamu bwachinkwa chitakwe bumena. Mupati wabapayizi abalembi bakalangula inzila isisikene kuti ngabalamujata biyeni Jesu akumujaya. ");
INSERT INTO dov_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nkambo balikwamba kuti “kutabi muchindi chapobwe, kuti kutabi kunyongana akati kabantu” ");
INSERT INTO dov_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lino Jesu kalimu Bbetani mun'anda ya Sayimoni sichinsenda, kachili mukulya atafula, mwanakazi wakasika kulinguwe amunkuli watununkilizyo tudula loko, ooyo wakali wanadi. Wakapwaya munkuli akutila nadi amutwe wakwe. ");
INSERT INTO dov_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pesi kuli bamwi bakabijilwa. Bakambuzyana akati kabo kabati, “Wanyonywedanzi? ");
INSERT INTO dov_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tununkilizyo otu tweelede kuuzigwa ikwiinda myaanda itatu yamaseleni ikapegwe bachete”. Mpawo wakamukasya. ");
INSERT INTO dov_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pesi Jesu wakati, “Amumusiye alikke. Mumukatazizyanzi? Wandichitila chintu chibotu. ");
INSERT INTO dov_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bachete mulaabo kaale lyoonse, kufumbwa chindi nimwayanda mulakonzya kubachitila kabotu, tamukoyooba andime lyoonse pe. Wachita eecho nchakoonzya. ");
INSERT INTO dov_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wananika kale mubili wangu kuti ukazikwe. ");
INSERT INTO dov_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ndamwambila kasimpe kuti, kufumbwa makani mabotu nkwayookambawukwa munyika yoonse, eechi nchachita mwanakazi ooyu chinowambuulwa, mukumuyeya”. ");
INSERT INTO dov_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mpawo Judasi Isikkaliyoti umwi balikkumi ababili wakaya kubapayizi kuti akamupede kuli mbabo. ");
INSERT INTO dov_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lino bapayizi bapati nibamvwa oobo, bakabotelwa akumusyomezya kuti apege mali. Wakatalika kuyandula mweenya wakumupeda kuli mbabo. ");
INSERT INTO dov_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mubuzuba butaanzi bwachinkwa chitakwe bumena, lino nibakapayizya kabelele kapobwe lyakundilila, basikwiiya bakati kuli nguwe, “Nkokuli nkuyanda kuti tukabambilile kuti ukalye chakulya chapobwe lyakwindilila?” ");
INSERT INTO dov_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wakatuma basikwiiya babili akubaambila kuti, “Kamuya mugunzi, eelyo muyooswanana amwalumi unyampwide munkuli wameenda mumutobele. ");
INSERT INTO dov_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ooko nkwayojinka mun'anda mukamutobele mukati kuli munan'and, 'Muyisi wati, “Ilikuli yangu n'anda yabeenzu ooko nkundiyolinda ipobwe lyakwindilila abasikwiya bangu?” ");
INSERT INTO dov_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Uyomutondezya n'anda mpati yamujulu ibambidwe kabotu. Mukatubambilile mumo”. ");
INSERT INTO dov_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mpawo basikwiya bakazwa bayinka mumunzi. Lino bakazijana zyoonse mbuli mbakabambila, eelyo bakambilila chakulya chapobwe lyakwindilila. ");
INSERT INTO dov_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nikwakaba golezya, wakaza abali kkumi ababili. ");
INSERT INTO dov_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aawo nibakali yeeme atafula akulya, Jesu wakati kasimpe ndamwambila kuti umwi wanu ngundilikulya aawe uyonduuzya. ");
INSERT INTO dov_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mpawo boonse bakawusaloko, alimwi awumwi wakati kuli nguwe, “Masimpe tensi ndime pe?” ");
INSERT INTO dov_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesu wakasandula wakati kuli mbabo, “Nguumwi wabali kkumi ababili, ooyu wazwa kunika chinkwa lino mundido andime?” ");
INSERT INTO dov_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aboobo Mwana waMuntu uyoyinka mbuli mbukulembedwe atala anguwe. Pesi maawe kulooyo muntu wachitya kuti Mwana aMuntu awuzigwe chali kubota kumntu ooyo natakazyalwa”. ");
INSERT INTO dov_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aawo nibakachili kulya Jesu wakabweza chinkwa, wachilongezya, akuchikwamuna. Wabapa akwamba kuti, “Mubeze eechi ngumubili wangu”. ");
INSERT INTO dov_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Alimwi wakabweza nkomechi, wapa kulumba, akukapa, eelyo bakanywa boonse. ");
INSERT INTO dov_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wakati kuli mbabo, “Oobu mbubulowa bwangu bwachizuminano, bulowa butilwa baangi” ");
INSERT INTO dov_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kasimpe ndamwambila kuti, nsikoyonywa limbi e ooyu muchelo wamasansa kusikila buzuba oobo nindiyoonywa mubwami bwaLeza”. ");
INSERT INTO dov_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mpawo nibakali kwiimba lwiimbo, bakazwa baya kuchilundu chaOlivisi. ");
INSERT INTO dov_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu wakati kuli mbabo, “Moonse muyoowa, mbuuli mbukulembedwe, 'Ndiyowuma mwembeli butanga buyomwayika'. ");
INSERT INTO dov_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pesi kandili ndabuka, ndilamwindila kunembo kuya kuGalili”. ");
INSERT INTO dov_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita wakateedi, “Nikuba kuti boonse bawa pesi mebo pe”. ");
INSERT INTO dov_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu wakati kulinguwe, “Kasimpe ndakwambila, sunu iyii, mbubo busiku oobuno mukombwe kutana kokolika tubili uyondikaka tutatu. ");
INSERT INTO dov_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lino Pita wakati kuti kandeleede kufa ayebo, mezyo chikozyene. ");
INSERT INTO dov_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bakasika kubusena butegwa Gesemane, mpawo Jesu wakati kuli basikwiya bakwe, “Amukkale aawo nenchiya kukukomba”. ");
INSERT INTO dov_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wakabweza Pita, Jemusi a Joni, winka aabo, watalika kulilya akulikataazya. ");
INSERT INTO dov_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wakati kuli mbabo, “Muuya wangu wawusa loko, nikuba kusika kulufu. Muchaale aawa kamulindide” ");
INSERT INTO dov_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kabachiya kunembo, Jesu wakawida aansi akukomba kuti nichali kukonzeka chiindi echi chimwiinde. ");
INSERT INTO dov_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wakati, “Abba, Taata, kuti nduwe zintu zyoonse zilakonzeka. Gwisya nkomechi eeyi kuli ndime pesi kutabi kuyanda kwangu pe, asi kwako”. ");
INSERT INTO dov_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wakaboola, wakajana baloona, mpawo wakati kuli Pita, “Sayimoni, muloona na? Tamukonzyi kulindila hola lyomwe? ");
INSERT INTO dov_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mulindile akukomba kuti mutanjili mukusunkwa. ");
INSERT INTO dov_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Lino wakazwa lwabili wakukomba majwi ngawonya. ");
INSERT INTO dov_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nakaboola lubo wakajana balokoona, nkambo meso aabo akali alema. Tebakaziba chakwamba kuli nguwe. ");
INSERT INTO dov_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wakaza kachitatu wakati kulimbabo, “Muchili koona na? Kwazulila! Chindi chasika. Amulange! Mwana aMuntu uli kuziigwa mumaanza abasizibi. ");
INSERT INTO dov_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Munyampuke; tweende. Amulange, sikunduuzya waba afwifwi.” ");
INSERT INTO dov_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kachili kwambula, Judasi, umwi wabali kkumi ababili wakasika, ankamu mpati kabajisi mapanga amasumu, kuzwa kubapati babapayizi, abalembi, abaalu. ");
INSERT INTO dov_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lino sikumuuzya wakapa chitondeezyo, wati, “Ooyo ngundiyomyonta ngonguwe. Amumujate mumtole atamuchiji pe.” ");
INSERT INTO dov_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Awo Judasi nakasika, mpawoawo wakaya kuli Jesu wati, “Muyisi!” Akumumyonta. ");
INSERT INTO dov_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Mpawo bakabikka maboko alinguwe bamwaanga. ");
INSERT INTO dov_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pesi umwi wababo bakalimvwi wakasomona ipanga wakakwazula akudunsula kutwi kwamuzike wamupayizi mupati. ");
INSERT INTO dov_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu wakati kulimbabo, “Mwaza mbuli muyanda sikubba, amapanga, amasumu kuzondijata? ");
INSERT INTO dov_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Aboobo ndali anywebo mazuba woonse akuyisya mun'anda yaLeza, temwakandisunga pe. Pesi eechi chachitika kuti malembe azuzikizigwe”. ");
INSERT INTO dov_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Boonse mbakali aabo Jesu bakamusiya akumuchija. ");
INSERT INTO dov_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mwalumi munini, wakali samide mulembo luzutu uteentema ngwakali lipopode wakali kutobela Jesu. ");
INSERT INTO dov_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Lino baalumi nibakamwanga wakasiya mulembo uteentema wachija kali chintanda. ");
INSERT INTO dov_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bakatola Jesu kumupayizi mupati. Bamubunganina bapayizi bapati, abaalu abalembi. ");
INSERT INTO dov_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Lino Pita wakali buya butobela kulaale kulubaya kwamupayizi mupati wakakkala akati kabalindizi bakali afwifwi amulilo kuti akasalilwe. ");
INSERT INTO dov_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lino bapati babapayizi ankuta yoonse yaba Juda yakali kuyandula bukamboni bubi kuchita kuti bamutole kulufu. Pesi tebakabujana pe. ");
INSERT INTO dov_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Eelyo biingi bakaleta bukamboni bwakubeja atala aanguwe, pesi bukamboni obu tebwali kuzuminina pe. ");
INSERT INTO dov_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bamwi bakayima akupa bukamboni bwakubeja atala anguwe; Kabati,” ");
INSERT INTO dov_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Twakamumvwa kati, 'Ndiyomwaya n'anda yaLeza yakwa amaanza, mukati kwamazuba atatu ndiyoyiyaka imbi itachitwi amaanza”. ");
INSERT INTO dov_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Nikuba boobo bukamboni bwabo tebwakazumina pe. ");
INSERT INTO dov_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mupayizi Mupati wakayimikila akati kabo wabuzya Jesu, “Tujisi nsandulo na? Ninzi eezi aaba balumi nzibapeda bukamboni atala anduwe?” ");
INSERT INTO dov_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Asi we wakawumuna takwe nakasandula chintu pe. Alubo mupayizi mupati wakati wakamubuzya kuti, “Nduwe Kkilisito, Mwana wawulongezedwe?” ");
INSERT INTO dov_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu wakati, “Ndime! alimwi muyoomubona Mwana aMuntu ulikkede kululyo lwaluboko lwasinguzu akuboola amayoba akujulu.” ");
INSERT INTO dov_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mupayizi mupati wakadelula zisamo mpawo wati, “Sa tuchiyanda bukamboni? ");
INSERT INTO dov_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mwamvwa mbwamba chisapi. Muzeezo wanu ngwakutyeni?” Mpawo bakamupa mulandu welela lufu. ");
INSERT INTO dov_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bamwi bakatalika kumuswida mate akumuvumba busyu akumunabba akwamba kuti kuli nguwe, “Sinsima!” Basolooli bakamubweza akumuuma. ");
INSERT INTO dov_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Eelyo Pita kachili munsi alubaya umwi wabalanda basimbi bamupayizi mupati wakaza kuli nguwe. ");
INSERT INTO dov_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nakabona Pita kali kuyota mulilo, wakalangisisya akwamba kuti, “Mwakali aamwi a Jesu muNazaleta”. ");
INSERT INTO dov_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pesi wakakaka akwamba kuti tandimuzi pe nikuba kumvwa atala anzinokwambuula anzizyo”. Lino wakazwa waya anze aamulyango. Alimwi malembe achindi alawungizya. Mpawo mukombwe wakokolika. ");
INSERT INTO dov_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pesi mulanda musimbi wakamubona mpawo watalika kwamba lubo kuti aabo balimwi mpawo, “Ooyu mwalumi nguumwi wabo!” ");
INSERT INTO dov_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lino wakakaka alubo. Nikwakayinda chindi chinini aabo bakalimvwi aawo bakati kuli Pita, kasimpe nduwe umwi wabo, nkambo alako uli muna Galiliyeni.” ");
INSERT INTO dov_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mukombwe mpawawo wakakokolika kachibili. Mpawo Pita wakayeeya majwi aaJesu ngakamwambila: ");
INSERT INTO dov_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","“Mukombwe kutana kukokolika kachibili, uyondikaka tutatu” alimwi wakawusa akulila. ");
INSERT INTO dov_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Muchifumofumo, bapati babapayizi bakabungana abaalu abalembi abasilutwe babbooma lya Judiya. Bakamwanga bamutola. Akumupeda kuli Payileti. ");
INSERT INTO dov_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Payileti wakabuzya kuti, “Nduwe Mwami waba Juda na?” Wakasandula kuti, “Wamba”. ");
INSERT INTO dov_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bapayizi bapati bakali kumutamikizya zintu zyiingi. ");
INSERT INTO dov_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Alubo Payileti wakabuzya, “Tosanduli na?” Langa kuvula zintu zyiingi nzibali kukutamikizya!” ");
INSERT INTO dov_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pesi Jesu takwe naakamusandula, mpawo eecho chakamugambya Payileti. ");
INSERT INTO dov_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kuchindi chapobwe, Payileti wakaba angunywida umwi wabange, mwange ngubatanoli bakumbila. ");
INSERT INTO dov_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mpawo kwakali mwalumi utegwa Bbanabbasi muntolongo kalamwi abapati bakali amilandu yabujayi muchindi chalupapi. ");
INSERT INTO dov_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Makamu akaza kuli Payileti mpawo bakatalika kukumbila kuti achite echo nchakali kunoonga wabachitila. ");
INSERT INTO dov_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Payileti wakabasandula wati, “Muyanda kuti ndimwangunwide Mwami waba Juda na?” ");
INSERT INTO dov_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","We wakalizi kuti nkambo kabbivwe bapayizi bapati nchibakaaba Jesu kulinguwe. ");
INSERT INTO dov_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pesi bapayizi bapati bakasungilizya makamu kuti balilile kwangununwa kwaBbanabbasi. ");
INSERT INTO dov_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Payileti wakasandula lubo wakati, “Mpoo ndichite biyeni aMwami wabaJuda?” ");
INSERT INTO dov_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bakawompolola lubo, “Ngagankaminwe!” ");
INSERT INTO dov_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Payileti wakabambila kuti, “Mulandunzi ngwakachita?” Pesi bakayinkilila kunembo akoompolola kuti, “Amumugankamine”. ");
INSERT INTO dov_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Payileti wakayanda kukutisika makamu, elyo wakabangunwida Bbanabbasi. Wakamupenzya Jesu mpawo wamupeda kuti akagankaminwe. ");
INSERT INTO dov_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Basilumamba bakamutola bamunjizya mubbetekelo (alingawo maanda afulumende mapati), mpawo bakayita imbunga yabasilumamba. ");
INSERT INTO dov_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bakamubikka kunembo wantumbula Jesu, mpawo bakazinga musini wamaamvwa elyo bakamusamika. ");
INSERT INTO dov_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bakatalika kumuseka kabati, “Mwalemekwa, Mwami wabaJuda!” ");
INSERT INTO dov_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bakali kumumuma mumtwe atete mpawo bakamuswida mate. Bamufugamina akumukotamikila mitwe. ");
INSERT INTO dov_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nibakamana kumusonsya, bakamugwisya mulembo wantumbula mpawo bamusamika zisamo zyakwe, elyo bakamutola kuyomugankamina. ");
INSERT INTO dov_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Umwi mwalumi, Sayimoni wakuSayilini, wakayabuza kuzwa kumunzi (wakali wisi wa Alekizanda a Lufusi), mpawo bakamwangila kuti amubwezele chiingano. ");
INSERT INTO dov_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Basilumamba bakeeta Jesu kubusena butegwa Gologota (busenandululwa kutegwa, “Busena bwazipepe zyamyitwe”). ");
INSERT INTO dov_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Bakamupa wayini ivwelengene andulwe, pesi takanywa pe. ");
INSERT INTO dov_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bakamugankamina mpawo bakaabana zisamo zyakwe bakasaana chisolo kuti basilumamba babone kuti umwi ulabweza chisamo chaali ");
INSERT INTO dov_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chakali chiindi chahola lyatatu nibakamugankamina. ");
INSERT INTO dov_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Achikwankwani bakalemba mulandu ngubakamupa, bakati, “Mwami wabaJuda”. ");
INSERT INTO dov_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bakamugankamina aamwi ababbi babili, umwi kululyo lwakwe umwi kulumwensi lwakwe. ");
INSERT INTO dov_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Malembi mabotu akale taakwe Makko 15: 28, (Malembe akazuzikizigwa akuti, “Wakabb. alikizigwa amwi abasikutyola milawo) ");
INSERT INTO dov_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Abo bakali kwiinda nibakamubona bakali kutikinia mitwe kabati, “Iiwe! nokonzya kumwaya chikombelo mpawo akuchiyakulula mumazuba otatwe, ");
INSERT INTO dov_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Livune useluke achingano!” ");
INSERT INTO dov_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Munzila ikozyenie, bapati bapayizi bakati kumuniaka antoomwe abalembi, mpawo bakati, “Wakafutula bamwi, pesi takonzyi kulifutula. ");
INSERT INTO dov_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Akube kuti Kilisito, Mwami wa Izilayeli, aseluka lino achingano ikuti tubone akusyoma.” Abalabo bakagankaminwa amwi anguwe bakamuseka. ");
INSERT INTO dov_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Muhola lyamusanu alimwi, mudima wakazulila busena boonse kusikila kuhola lyamusanu aane. ");
INSERT INTO dov_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Muhola lyamusanu aane Jesu wakalila ajwi pati wakati, “Eloyi, Eloyi, sabakkatani?” echi chipandulula kuti, “Leza wangu, Leza wangu wandisilaanzi?” ");
INSERT INTO dov_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bamwi babaabo bakayimvwi kumbali bakamvwa majwi akwe mpawo bakati, “Langa, ulikwiita Elija.” ");
INSERT INTO dov_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Umwi wakachijana, wakanika nsinsa muwayini ilweela, wachibikka atete, mpawo wakamupa kuti anywe. Mwalumwi oyu wakati, “Atubone naa Elija ulaza kuzomwangununa.” ");
INSERT INTO dov_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Elyo Jesu wakalila ajwi pati mpawo wafwa. ");
INSERT INTO dov_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Isila lyachikombelo lyakadeluka muzipanzi zibili kuzwa kujulu kusika ansi. ");
INSERT INTO dov_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Elyo mupati wabasilumamba balimwaanda wakayimvwi kalangide Jesu naakabona kuti wafwa munzila eyi, wakati, “Masimpe mwalumi oyu wali Mwana waLeza.” ");
INSERT INTO dov_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kwakaliko alimwi banakazi bakali kweebela chakule. Akati kabo kwakali Maliya Magadalini, Maliya (bayina a Jemusi mwanike a Josesi) mwalumi walikutegwa Josesi lino utegwa Jozefu muli Makko 6: 3. Izina liti Josefu lyiimikilila mbuli mbulyakali kwaamba muchiHebbulu, mpawo izina liti Josesi lyiimikilila mbuli mbulyakali kwaambwa muchiGilikki, mpawo a Salume. ");
INSERT INTO dov_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nakali muGalili bakalikumutobela mpawo akuchita milimu yakwe. Alimwi banakazi bayingi abalabo bakali kumusindikila ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nilyakaba golezya, nkambo kakuti lyakaliZuba lya Mabambe, nkuukuti, izuba lilimusanu abuzuba butegwa Sabata, ");
INSERT INTO dov_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jozefu waku Alimatiya wakasika aawo. Wakali kulemekwa kali umwi wabapati bachisi wakali kulindila bwaami bwaLeza. Wakayinka chabulemu kuli Payileti mpawo wakakumbila mutunta waJesu. ");
INSERT INTO dov_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Payileti chakamgambya kuti Jesu wakali wafwa kale; wakayita mupati wabasilumamba bali mwaanda mpawo wakabuzya kuti kulinguwe Jesu wafwa. ");
INSERT INTO dov_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Elyo Payileti nakaziba kuzwa kumupati wabasilumamba balimwaanda kuti Jesu wafwa, wakuupa Jozefu mutunta. ");
INSERT INTO dov_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jozefu wakawula mulembo utentema wakamwangununa achingano, wamuvungilizya amulembo utentema, mpawo wamulazika muchiyumbwe chamumpako yabbwe. Elyo wakatendelesya bbwe wajala mulyango wachumbwe. ");
INSERT INTO dov_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maliya Magadalini a Maliya bayina a Josesi bakakubona busena Jesu mbwakalazikwa. ");
INSERT INTO dov_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nibwakamana buzuba butegwa Sabata, Meli Magadaleni, Meli banyina aJemusi, a Salome bakawula tununkilizyo kuti bayinke kuyoonanika mutumba wa Jesu. ");
INSERT INTO dov_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Chifumo fumo mubuzuba butaanzi bwamviki, zuba mbulyakapasula buyo bakayinka kuchibunda. ");
INSERT INTO dov_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Alimwi kabacheenda munzila bakabuzyania umwi awumwi kuti, “Nguni uutakatugwisizye bbwe kuzwa kumulyango wachibunda? ” ");
INSERT INTO dov_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pesi balange buyo, bakabona bbwe lyakali pati oko, kaligwisizigwe kale. ");
INSERT INTO dov_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nibakanjila muchibunda, bakabona mwaalumi mukubusi kasamide chisamo chituba, kakkede kululyo, mpawo bakagamba a kuyoowa. ");
INSERT INTO dov_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wakati kulimbabo, “Mutayoowi. Mulanguula Jesu mu Nazeleta, wakagankaminwa aachiingano. Tawo pe aano, ulibukide! Amulange aabusena mpubakamubikide. ");
INSERT INTO dov_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pesi kamuya, mukaambile basikwiiya bakwe a Pita kuti, ulazulula kunembo lyanu kaya ku Galilii. Nkukonya muyoomubona, mbuli mbwakaamwaambilide,” ");
INSERT INTO dov_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Mbubakazwa muchibunda; kabatalika kuchijaana bakalikuteketa kabagambide. Taakwe nchimbakaambilana pe nkaambo bakali yoweede. ");
INSERT INTO dov_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Malembe mayingi aakutanguna abukamboni bwachiindi mubbuku lya Maakko Chandano 16. munchali 9 kusika ku 20 taawo pe.  Mubuzuba butaanzi bwamviki, naakabuka, wakasanguna kulitondeezya kuli Meli Magadalena, ooyo ngwakagwisya myuuya mibi ili musanu ayiibili. ");
INSERT INTO dov_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Wakayinka wakwaambila aabo bakali anguwe, aabo bakali komookaakulila. ");
INSERT INTO dov_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pesi nibakamvwa kuti Jesu muumi akuti wamubona, tebakasyoma pe. ");
INSERT INTO dov_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nikwakiinda zintu eezi, wakalibonia muzila zisiyene kuli babili, nibakalikuyobweenda kuya kumyuunzi. ");
INSERT INTO dov_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bakayinka kuyowambila basikwiya boonse, pesi taakwe nibakabasyoma ");
INSERT INTO dov_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mukweenda kwachiindi Jesu wakalibonia kulibali kkumi awumwi nibakali kulya; wakabakalalila mukutasyoma akuyuma kwamyoyo yabo, nkaambo bakakaka kuzuminina aabo bakamubona naakabuka. ");
INSERT INTO dov_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wakaamba kuti kulimbabo, “Kamuya munyika yoonse alimwi mukakambawukile zilengwa zyoonse. ");
INSERT INTO dov_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kufumbwa uusyoma akubbapatizigwa uyoofutulwa, pesi kufumbwa uutasyomi uyoopegwa mulandu. ");
INSERT INTO dov_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Alimwi zigambyo eezi ziyoobatobela boonse basyoma: Bayootanda myuuya mibi muzina lyangu. bayoowambuula mumilaka mipya. ");
INSERT INTO dov_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bayoojata nzoka amaboko aabo, alimwi nibayoonywa chijaya, tachikwe kuyoobachisa pe, bayoobika maanza aabachiswa, alimwi bachiswa bayoopona.” ");
INSERT INTO dov_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mpawo Mwami naakamana kubaambila, wakatolwa kujulu mpawo wakakukkala kuluboko lwalulyo lwa Leza. ");
INSERT INTO dov_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mpawo basikwiiya bakazwa akuyookambawuka koonse koonse, alimwi Mwami wakabeeleka aabo akusiimya jwi lyakwe azitondeezyo zyakali aandilyo. ");
INSERT INTO dov_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Biingi bakatola mulimu wakubikka antoomwe zintu zyakazuzikizigwa akati kesu, ");
INSERT INTO dov_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","mbuli mbuzyakayinzigwa kizosika kulindiswe abaabo kuzwa chiindi bakali bakamboni alubo kabali bala bejwi. ");
INSERT INTO dov_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Chakabaanga nchibotu kulindime ambebo - nkaambo ndakachita mfunkununo izulide aatala azeezyo zyakachitika kuzwa kumatalikilo - kuti ndikulembele lugwalo, webo nomusongo Tiofilasi. ");
INSERT INTO dov_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kuti uzibe choonzyo aatala azintu nzuwakayiisigwa. ");
INSERT INTO dov_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Mumazuba aHelodi mwami waku Judiya, kwakali umwi mupaizi wakalikutegwa Zekaliya, wakali kwakulubazu lwa Abija. Mukayintu wakwe Elizabeti alubo wakali walunyungu lwa Aaloni. ");
INSERT INTO dov_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bakaliluleme boonse kunembo lya Leza, kabalemeka milawu yoonse anzyatalide Mwami. ");
INSERT INTO dov_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pesi tebakalikwe mwana pe nkaambo Elizabetji wakali ngomwa, alubo bakali bachembaala boonse mulechi chiindi. ");
INSERT INTO dov_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lino kwakasika aachiindi Zekkaliya mpakali mubuliwo bwa Leza, kalikuchita milimu ya bupayizi mbuli mumabambe aakwe. ");
INSERT INTO dov_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mbuli munzila yachiyanza yakusala mupayizi utabeleke, wakali wasaligwa achisolo kuti anjile muchikombelo cha Leza kuti akatente tununkilizyo. ");
INSERT INTO dov_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Choonse chibunga chabantu chakali kukomba aanze kuhola eelyo tununkilizyo nitwakali kutentwa. ");
INSERT INTO dov_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mungelo wa Mwami wakalibonia kuli nguwe alimwi wakayima kubbazu lyakululyo lyachipayililo, ");
INSERT INTO dov_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zekaliya, naakamubona wakateketa nkaambo kuyoowa kwakamujata. ");
INSERT INTO dov_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pesi mungelo wakati kulinguwe, “Utayoowi, Zekaliya, nkaambo nkombyo yako yamvwika. Mukako Elizabetki ulakuzyalila mwana mulombe. Uzomuuzika kuti ngu Joni ");
INSERT INTO dov_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Uyooba aakukondwa akusekelela, alubo banji bayoobotelwa akuzyalwa kwakwe. ");
INSERT INTO dov_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nkaambo uyooba mupati kubusyu bwa Mwami. atazonywi wayini na zinywigwa zilula, alubo unozwide Muuya Uusalala kuzwa mwida lyabanyina. ");
INSERT INTO dov_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Biingi bana ba Izilayili bayobweeda ku Mwami Leza wabo. ");
INSERT INTO dov_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Uzoya kunembo lya Mwami mumuuya amumanguzu aa Elija. Uzoochita eezi kuti azosandule myoyo yamataata kuti ibweede kubana babo, kuchitila kuti batalemeki mulawu bazoyende mubusongo bwabaluleme - kuchitila kubambila Mwami bantu babambilidwe nguwe.” ");
INSERT INTO dov_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekaliya wakati kumungelo.”Ndilaziziba biyeni eezi? Nkaambo ndachembaala abanangu bachembaala.” ");
INSERT INTO dov_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mungelo wakamusandula wati kulinguwe, “Ndime Gabbuliyeli, wiima mububewo bwa Leza. Ndatumwa kuti ndizowambule aanduwe, ndikweetele majwi mabotu aaya. ");
INSERT INTO dov_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Langa, uyowumuna, tokoyokonzya kwaambula pe, kuyosika zikachitike zintu eezi. Eezi zyachitika nkaambo taakwe niwasyoma majwi aangu, ayoozuzikizigwa muchiindi cheelede.” ");
INSERT INTO dov_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lino bantu bakalikulinda Zekaliya, bakagamba kuti nkaambonzi naatola chiindi chilamfu chiloobu kachili muchikombelo. ");
INSERT INTO dov_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pesi naakazwida aanze takachili kukonzya pe kwaambula. Bakakubona kuti wakabona chilengaano nakali muchikombelo. Wakalikwaambuula katondeeka biyo muchuumunizi. ");
INSERT INTO dov_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Chiindi chakumana kwamulimu wakwe nichakasika wakabweeda kung'anda yakwe. ");
INSERT INTO dov_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Musule lyamazuba aaya, mukayintu wakwe Elizabeti wakajata da. Wakalisisa kwamyeezi musanu. Wakaamba kuti, ");
INSERT INTO dov_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Eechi nchaandichitila Mwami naakandilanga wandimvwida luzyalo kuti andigwisye mawuse kunembo lyabantu. ");
INSERT INTO dov_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mumweezi wamusanu awumwi, mungelo Gabbuliyeli wakatumwa kuzwa kuli Leza kuya kudpolopo lyaku Galilii litegwa Nazaleta, ");
INSERT INTO dov_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kuya kuli nakalindu wakatangidwe kumwaalumi wakalikutegwa Jozefu. Wakali walunyungu lwa Devidi, alubo pzina lyamusimbi lyakali Meli. ");
INSERT INTO dov_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wakasika kulinguwe wati, “Wapona iwe noopedwe luzyalo lupati. Mwami uli aayebo.” ");
INSERT INTO dov_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pesi wakanyonga kapati amajwi aamungelo alwimwi wakagamba kuti nkujuzigwa kulibiyeni ooku. ");
INSERT INTO dov_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mungelo wakati kulinguwe, “Utayoowi, Meli, nkaambo wajana luzyalo kuli Leza. ");
INSERT INTO dov_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Langa uzoojata da uzoozyale mwana mulombe. uzomuuzika zina lyakuti, 'Jesu'. ");
INSERT INTO dov_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Unooli mupati alubo unoyitwa kuti Mwana wa Simajulu. Mwami Leza uyomupa chuuno chabwami bwa syanyinakulu Devidi. ");
INSERT INTO dov_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Uzooyendelezya ng'anda ya Jakobo mane kukabe kutamani, alimwi bwami bwakwe tabukozoomana pe. ");
INSERT INTO dov_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meli wakati kumungelo, “Ziyoochitika biyeni eezi nkaambo nsinaziba mwaalumi pe?” ");
INSERT INTO dov_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mungelo wakatgi kulinguwe, “Muuya Uusalala uzoosika kulinduwe, alubo nguzu zya Simalelo zizoosika alinduwe. Aboobo ooyo uusalala uutazozyalwe uzootegwa Mwana wa Leza. ");
INSERT INTO dov_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Langa munakwenu Elizabeti ulaada lyamwana mulombe mubuchembele bwakwe, lino wanba mumweezi wamusanu awumwi, ooyo wakalikutegwa ningomwa. ");
INSERT INTO dov_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nkaambo taakwe chimukachila pe Leza. ");
INSERT INTO dov_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meli wakati, “Langa ndimulanda waMwami, azibe kulindime mbuli majwi aako.” Mpawo mungelo wakamusiya. ");
INSERT INTO dov_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mpawo mumazuba aayo Meli wakanyamnpuka watgozya kubusena bwazilundu, kudolopo lya Judiya. ");
INSERT INTO dov_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wakanjila mung'anda ya Zekaliya wakujuzya Elizabeti. ");
INSERT INTO dov_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aawo Elizabeti naakamvwa kujuzya kwa Meli, mwana wakali mwida lyakwe wakasotoka, mpawo Elizabeti wakazuzigwa aMuuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wakoompolola ajwi pati wati, “Ulilongezezegwe iwe akati kabamwi banakazi, alubo ulilongezezegwe muchelo weda lyako. ");
INSERT INTO dov_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nkamboonzi nikchachitika kuti banyina aMwami wangu basike kulindime? ");
INSERT INTO dov_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nkaambo langa, majwi aako akundijuzya naanjila mumatwi aangu mwana uulimwida lyangu wasotoka alukondo. ");
INSERT INTO dov_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Aboobo ulilongezezegwe ooyo uuyoosyoma kuti kuyooba kuzuzikizigwa kwazintu eezi nzyaakambilwa kuzwa kuMwami.” ");
INSERT INTO dov_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meli wakati moyo wangu ulalumbayizya Mwami, ");
INSERT INTO dov_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","alubo muuya wangu ulalumbayizya Leza mufutuli wangu. ");
INSERT INTO dov_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nkaambo wakalanga chiimo chaansi chamulanda wakwe. Nkaambo amulange, kuzwa lino mazyalane woonse ayondiijta kutghi ndili longezezegwe. ");
INSERT INTO dov_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nkaambo ooyo wandichitila zintu zipati, alimwi zina lyakwe lilasalala. ");
INSERT INTO dov_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Luzyalo lwakwe luyoozulila kuzwa kuzyalane kuya kulilimbi zyalane kuli aabo bamuyoowa. ");
INSERT INTO dov_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wakatondeezya nguzu ejanza lyakwe; wakasansaanya aabo balisumpula aatala amizeezzo yamyoyo yabo. ");
INSERT INTO dov_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wakagwisya bana babaami kuzwa kuzyuno zyaabo alimwi wakasumpula aabo bali aachiimo chilaansi. ");
INSERT INTO dov_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wakakutya basinzala azintu zibotu, pesi bavubi wakabaanda kabatakwe chintu. ");
INSERT INTO dov_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Wakapa lugwasya kuli Izilayeli mulanda wakwe, kuti ayeeye kutondeezya luse ");
INSERT INTO dov_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","(mbuli mbakaamba kuli basikale besu) kuli Abraham alunyungu lwakwe.” ");
INSERT INTO dov_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meli wakakkala a Elizabeti kwamyeezi yotatwe mpawo wabweda kung'anda yakwe. ");
INSERT INTO dov_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lino chakasikachiindi chakuti Elizabeti atumbuke aboobo wakatumbuka mwana mulombe. ");
INSERT INTO dov_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Basimabambanwa antoomwe abasinzubo zyakwe bakamvwa kuti Leza wakamutondeezya luzyalo, mpawo bakabotelwa aamwi anguwe. ");
INSERT INTO dov_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mpawo mubuzuba bwamusanu aatatu bakasika kuzopalula mwana. Bakalikuyanda kumuuzika kuti “Zekaliya” zina lyawisi. ");
INSERT INTO dov_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pesi banyina bakasandula bati “Pe. ulayitwa kuti ngu Joni.” ");
INSERT INTO dov_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bakati kulinguwe, taakwe pe kuluzubo lwesu loonse ulazina eeli.” ");
INSERT INTO dov_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mpawo bakaambuula awisi anzila yakutondeeka kababuzya kuti uyanda kuti mwana awuzikwe zina lili. ");
INSERT INTO dov_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wisi wakakumbila aakulembela, mpawo wakalemba kuti, “Izina lyakwe ngu Joni.” Boonse zyakabagambya eezi. ");
INSERT INTO dov_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mpawaawo mulomo wakwe wakajulika mpawo lulimi lwakwe lwakaangunuka. Wakaambula akulumbayizya Leza. ");
INSERT INTO dov_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kuoyoowa kwakabasikila boonse bakalikukkala afwiifwi ambabo. Impuwo yoonse eeyi yakazula kumalundu achisi cha Judiya. ");
INSERT INTO dov_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Boonse bakazimwa bakazibamba mumyoyo yabo, kabati, “Ooyu mwana uzooba nyamaanzi?” Nkaambo kuboko kwa Leza kwakali aanguwe. ");
INSERT INTO dov_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wisi Zekaliya wakazula Muuya Uusalala mpawo wakasinsima, kati, ");
INSERT INTO dov_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Atembawulwe Mwami, Leza wa Izilayeli, nkaambo wasika kuzogwasya alimwi weeta lufuko kubantu bakwe. ");
INSERT INTO dov_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wakatunyampwida lwija lwalufutuko mung'anda yamulanda wakwe Devidi, ");
INSERT INTO dov_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","mbuli mbakaambula amilomo yabasinsimi bakwe basalala bakale. ");
INSERT INTO dov_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ulatufutula kuzwa kulibasinkondoma akulibaabo batusulide. ");
INSERT INTO dov_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Uzoochita eezi mukutondezya luzyalo kumataata esu akuyeeya chizuminano chakwe chisalala, ");
INSERT INTO dov_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","chikonke nchaakachita kuli Abbulahamu taatesu. ");
INSERT INTO dov_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Wakakonka kuti swe, nitwakafutgulwa kuzwa kumaanza abasinkondoma, tuzomubelekele kaututayoowi pe, ");
INSERT INTO dov_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","mubusalali amubululami kunembo lyakwe mumazuba esu woonse. ");
INSERT INTO dov_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Iyii, anduwe, nomwana, uzoyitwa kuba musinsimi waSimajulu, nkaambo uzoyhinda kunembo lya Mwami koyabubamba nzila, kobambila bantu mukusika kwakwe, ");
INSERT INTO dov_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kupa luzibo lwalufutuko kubantu bakwe akulekelelwa kwazibi zyabo. ");
INSERT INTO dov_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Eezi zizoochitika nkaambo kaluzyalo lwa Leza wesu, nkambo mukuyozwa kwazuba uzoosika kuzotugwasya, ");
INSERT INTO dov_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","likabamunikile bakkede mumudima amumweenzule walufu. Uyoochita eezi kuti akazulwide mawulu eesu munzila yaluumuno.” ");
INSERT INTO dov_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Lino mwana wakakomena wasima mumuuya, alimwi wakakkala munkanda kuyoosika buzuba mbwakalitodeezya kuli Izirayeli. ");
INSERT INTO dov_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lino mulayo mazuba, kwakasika akuti oyo siza Agasitasi wakatamuna mulumbe kulayilila kuti kubalwa kwachitwe kwabantu boonse bapona munyika. ");
INSERT INTO dov_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Oku kwakali kubalwa kutanzi kwakachitwa chiindi kkwiniliyasi nakali mwendelezyi wa Siliya. ");
INSERT INTO dov_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aboobo muntu woonse wakiinka kudolopo lyakwe kuti akalembesye kubalwa ");
INSERT INTO dov_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josefa alakwe wakinka atala kuzwa ku Galile, kuzwa kudolopo lya Nazaleta, kuya kuJudiy, kuya kudolopo lyaDavida, oyo utegwa Betelehema, nkaambo wakali wang'anda a lunyungu lwaDavida. ");
INSERT INTO dov_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wakayinka ooko kuti akalembesye aantomwe a Meli, ooyo ngwakatuminide alumwi wakali aatambu. ");
INSERT INTO dov_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lino kwakasika kuti biyo nibakachiliko oko, ichindi chakasika chakwe kuti atumbuke mwana wakwe. ");
INSERT INTO dov_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wakatumbuka mwana mulombe, mwana mutanzi wakwe, alimwi wakamuputila mumalembo akasala malamfu alimwi wamulazika muchata, nkaambo tekwakalikwe busena bulabo munga'nda yabenzu. ");
INSERT INTO dov_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kwakaliwo bembeli mubusena obo bakalikukkala mumyuunda, kabalo kulinda butanga bwabo mansiku. ");
INSERT INTO dov_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mungelo wamulami wakaboneka kuli mbabo, alimwi abulemu bwaMwami bwaka yubununwa alimbababo, alimwi bakazula akuyowa kupati. ");
INSERT INTO dov_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mpawo mungelo wakamba wakati, “Mutayowinkambo ndamwetela makani mabotu ayo atazo yete kukondwa kupati kubantu boonse. ");
INSERT INTO dov_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sunu mufuli wazyalilwa ndinywe mudolopo lyaDavida nguKKilisto mwami! ");
INSERT INTO dov_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Echi nchichitondezyo chitakapegwe kuli ndinywe. Mulojana mwana kaputilidwe mulembo likasalaalimwi kalede luchaata.” ");
INSERT INTO dov_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mpawo mpawo kwakaliwo antomwe abangelo biingi loko bazwa kujulu, kulumbaizya Leza alimwi kabati, ");
INSERT INTO dov_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Bulemu kuli Leza usumpukide, alimwi ngakube luumuno munyika akati kabantu amwi amoyo ngwaboteledwe.” Amwi malembo achiindi achi Greeki alakupeleta kusiyenesiyene oko kubona kwaamba kwamabala abili akonzya kwaamba zilikumamanino amabala mache a muchala 14, yabili nkili njiyandisigwa. Kubona kwaamba nkoku.” chiyandisisyo chibotu kubantu kana akati kabantu alumwi awoyo we (LEZA) ngwabo teledwe ");
INSERT INTO dov_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kwakaba kuti awo bangelo kabali bayinka kuzwa alimbabo kuya kujulu, bembeli bakati kuli umwi awumwi, “ngatwiinke lino ku Betelehema alimwi tukabone echi chintu chachitika, echo Mwami nchatuyubnwida. ");
INSERT INTO dov_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bakafwambanina nkuko alumwi bakujana Malia, Josefa, amwana oyo wakalede muchata ");
INSERT INTO dov_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kuzwawo abo nibakabamubona, bakazibisya ezyo zimbakali babuzigwa bo atala amwana. ");
INSERT INTO dov_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Boonse abo bakamvwa bakagamba kuli zezyo zyakambwa abembeli. ");
INSERT INTO dov_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pesi Maliya wakali kuyeya a makani ngakali wamvwa, wakalondolawo mumoyo wakwe. ");
INSERT INTO dov_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bembeli bakabweda kabalumbaizya akutembawula Leza kuli zyoonse ezyo zibakamvwa akubona, mbuli mbubaka mbilwa. ");
INSERT INTO dov_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Elyo kwakiinda mazuba masanu aatatu, elyo nakabalulwa, wakuzikwa wategwa Jsu, izina ndyakapedwe amungelo musule katana mintwa mwida ");
INSERT INTO dov_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Elyo ilangililwa mweelwe yamazuba akulisalazya kwabo nakiinda, mbuli mumulawo waMozesi, bo bakamweta kuchikombelo kuJelusalema kulomupeda kumwaami. ");
INSERT INTO dov_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mbuli mbukulembedwe mumulawu wamwami, “woonse mwana mulombe ujula ida ulo bikkwa kumbali kuMwami.” ");
INSERT INTO dov_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Abobo bakapa chipaizyo mbuli ezyo zyakambidwe mumulawu wamwana, “inziba zibili nabana bankuilimba. ");
INSERT INTO dov_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Amubone kwakali mwalumi muJelusalema ula zina litegwa Simiyoni, alumwi oyo mwalumi wakali luleme a kulipeda. Wakali kalangilila kumbilizigwa kwabaIzilayeli, alubo muuya usalala wakala tala anguwe. ");
INSERT INTO dov_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Zyakali zyayubununwa kuli nguwe amuya usalala kutitakozobona lufu katanakubona uNanikidwewaMwami. ");
INSERT INTO dov_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kazulwidwa aMuuya, Simiyoni waka sika muchikombelo. Elyo bazyali bakanjizya mukati mwana Jeso, kulo muchitila mbuli chiyanza chabo chamulawo. ");
INSERT INTO dov_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Wakamubweza mumaboko aakwe alimwi walumbaizya Leza, alimwi wakati, ");
INSERT INTO dov_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lino leka mulandawako ayiinde mulumuno, mwami, mbuli ijwi lyako. ");
INSERT INTO dov_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nkaambo menso angu abona lufutuko lwako, ");
INSERT INTO dov_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","olo mbwakambilwa abuliwo bwabantu boonse. ");
INSERT INTO dov_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","“Mumuni wachiyubunuzyo kuli bamasi alimwi bulemu kubantu bako izilayeli.” ");
INSERT INTO dov_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wisi abanyina, bakagambilwa aatala azintu zyakalikwaambulwa aatala amwana wabo. ");
INSERT INTO dov_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyoni wakabalongezya mpawo wakati kuli banyina, “Amulange mwana ooyu ulisalidwe kuti kube kuwa akusumpulwa kwabamwi bantu biingi muli Izirayeli achitondeezyo chikakidwe - ");
INSERT INTO dov_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","alimwi ipanga liyoyasa muuya wako - kuchitila kuti myoyo myiingi ikayubununwe.” ");
INSERT INTO dov_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Musinsimi mwanakazi uutegwa Ana wakaliwo. Wakali mwana musimbi waFanuwelo kuzwa kumukowa wa Asha. Wakali wapona amulumi wakwe minyaka ili musanu ayibili kuzwa kubusimbi bwakwe. ");
INSERT INTO dov_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Alimwi wakali mukamufu kwamwinyaka ili makumi musanu aatatu atune. Takwe nakazwide muchikombelo pesi wakali kubelekela kulyimya a kukomba mansiku, asikati. ");
INSERT INTO dov_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kuli ndilelyo wola wakaswena afwifwi kuli mbabo almwi wakatalika kupa kulumba kuli Leza, alimwi wakambula alubo aatala amwana kubantu boonse abo bakali kulindila kufutulwa kwaJelusalema. ");
INSERT INTO dov_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Eelyo aabo boonse nibakamanisya nzibakeelede kuchitambuli mulawo wamwami, bakabweeda ku Galilii, kudolopo lyabo lya Nazaleta. ");
INSERT INTO dov_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana wakakomena alimwi wakasima, kuyungizya mubusongo, alimwi luzyalo lwaleza lwakali aanguwe ");
INSERT INTO dov_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bazyali bakwe bakali kwiinka munyaka umwi awumwi ku Jelusalema kupobwe lya kwindilila. ");
INSERT INTO dov_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Awo nakaba aminyaka kkumi ayibili, bakabweda lubo mbuli chiindi chachiyanza chabo kupobwe. ");
INSERT INTO dov_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nibakakkala mazuba azulide aa pobwe, bakabweda kumunzi. Pesi mulombe Jeso wakasyala ku Jelusalema alimwi bazyali bakwe tebakazipe. ");
INSERT INTO dov_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bakayelela kuti wakali akabunga ako nkibakayobwenda aako, mpawo bo bakenda musinzo wazuba limwi. Mpawo bakasanguna kumulangula akati kanzubo zyabo abeenzinyina. ");
INSERT INTO dov_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Eelyo nibakamubula, bakabweda ku Jelusalema alimwi bakatalika kumuyandula nkuko. ");
INSERT INTO dov_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Zyakachitika kuti musule lyamazuba aatatu bakasanguna kumuyandula mung'anda ya Leza, kakkede akati kabayisyi, kalokubaswilizya akubabuzya mibuzyo. ");
INSERT INTO dov_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Boonse bakamumvwa bakagamba kukumvwisisisya kwakwe akunsandulo zyakwe ");
INSERT INTO dov_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Elyo nibakamubona bakakankabala. Banyina bakati kulinguwe, “Mwanaangu, nkambonzi nwatujata enzila eyi? Langa, wuso andime twalikukuyandula achakutankalinkana.” ");
INSERT INTO dov_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wakati kulimbabo, “Nkambonzi nimwalikundiyandula? Temwazi na kuti ndeelede kuba mungánda yandeende?” ");
INSERT INTO dov_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pesi bo tebakamvwisisya nzyakalikwamba awayo majwi. ");
INSERT INTO dov_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Elyo wakabweda kumunzi kulimbabo kuNazaleta alimwi wakali kulibombya kuli mbabo. Banyina bakalondola zyoonse ezi mumoyo wabo. ");
INSERT INTO dov_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Pesi Jeso wakaya kunembo akukomena mubusongo a muchiimo, alimwi wakayungizya kuluzyalo kuli Leza aku bantu ");
INSERT INTO dov_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Mumunyaka wakkumi amusanu mubweendelezi bwa Tibeliyasi Kkayisala - aawo Pontiyasi Payileti nakali mwendelezyi waku Judiya, Heloda kali mwendelezyi waku Galilii, mwana wakwabo Filipo kali mweendelezi wachisi chaku Ituliya a Tilankonitis, a Lisaniyasi kali mwendelezyi waku Abilene, ");
INSERT INTO dov_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","kuzwa kubupayizyi bwa Anasi aKkefasi - ijwi lya Leza lyakasika kuli Joni mwana wa Zakaliya munkanda. ");
INSERT INTO dov_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wakeenda muzisi zyoonse zizyuungulukide Joodani kakambauka lubbabbatizyo lwakusanduka akulekelela kwazibi. ");
INSERT INTO dov_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mbuli mbukulembedwe mubbuku lyamakani aIsaya musinsimi, “Ijwi lyasikompolola munkanda, 'Amubambenzila yamwami, amululamike nzila zyakwe ");
INSERT INTO dov_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yonse mimpata iyozuzukizigwa, a zilundu zyoonse atulundu tuyoba ansi amigwagwa ipilingene iyo lulamikwa, amasen aatabambinkene ayooyakwa akuba migwagw, ");
INSERT INTO dov_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","bantu boonse bayoobona lufutuko lwa Leza.'” ");
INSERT INTO dov_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mpawo Joni wakati kumakamu akalikuza kuzo bbabbatizigwa anguwe, “Nywebo nobana bachipile! ngwani wakamuchenjezya kuti muchije kuzwa kubukali bulokuza? ");
INSERT INTO dov_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Aaboobo, muzyale michelo mibotu iitondezya kusanduka alimwi mutataliki kwaamba mukati kanu, “Tula Abulahamu kali taata wesu; mbundamwambila kuti Leza ulakonzya kusumpula bana ba Abulahamu kuzwa kumabwe aya. ");
INSERT INTO dov_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Alino kaleba kalibikidwe kale kumiyanda yamisamu. Aboobo kufumbwa musamu utazyali muchelo mubotu ulawugonkela kunsi akuuwalila mumulilo.” ");
INSERT INTO dov_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Alimwi makamu akendelela kunembo akumubuzya bakati, “Niinzi mpawo nzitutachite?” ");
INSERT INTO dov_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wakasandula akuti kulimbabo, “Na kulumwi uujisi twakuzwata tubili, uleelede kwabana amuntu utakwe ayooyo ujisi chakulya ayiite mbobo.” ");
INSERT INTO dov_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abasimutelo abalabo bakaza kuzo bbabbatizigwa, akwamba kuli nguwe kuti, “Muyisi, niinzi nchitweelede kuchita?” ");
INSERT INTO dov_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wakati kulimbabo, “Mutakabwezi mali nyiingi njimutabuzizigwe kubweza.” ");
INSERT INTO dov_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bamwi basilumamba abalabo bakamubuzya, bakati, “Aniswe ninzi nchitweelede kuchita?” Wakati kulimbabo, “Mutakabwezi mali kufumbwa kulumwi changuzu, alimwi mutakapenzyi omwe chakubeja. amukakutisikane amiholo yanu.” ");
INSERT INTO dov_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lino bantu nibakachili kulindila chakupekezya kusika kwa Kkilisto boonse bakali kugamba mukati kamooyo yabo aatala aJoni, kutii ngunguwe Kkilisto. ");
INSERT INTO dov_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Joni wakasandula wakati kuliboonse, “Imebo lwangu ndamubbabbatizya amanzi, pele kulumwi ulobuza ulanguzu kwiinda ndime, aboobo nsikonzyi nikuba nkwangununa misungo yansangu zyakwe. Uyomu bbabbatizya aMuya Uusalala antomwe amulilo. ");
INSERT INTO dov_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kajisi pologwe yakupupuluzya mujanza lyakwe chakusalazya lubuwa lwakwe akubunganya bbali munganda yakwe. Pele uyowumpa buungu amulilo alimwi mulilo tukoyoozima pe.” ");
INSERT INTO dov_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mubwingi bwakumusumpula Joni wakalikwambula makani mabotu kubantu. ");
INSERT INTO dov_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Alimwi Heloda kali mwendelezyi wakazumizigwa kukukwata mwanakazi wamwana wakwabo Helodiyasi azyoonse zintu zibi Heloda nzyakachitide, ");
INSERT INTO dov_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","wakayungizya ezi kulimbabo boonse, akujalila Joni muntolongo. ");
INSERT INTO dov_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lino nichakasika chiindi aawo bantu boonse bakabbabbatizigwa Jesu alakwe wakabbabbatizigwa, nibakachili kukomba, majulu akajulika, ");
INSERT INTO dov_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","aMuuya Uusalala muchimo chamubili wakaza mbuli nziba, alimwi jwi lyakazwa kujulu “Ulimwana wangu ngwendiyandisisya. Ndabotelwa anduwe.” ");
INSERT INTO dov_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mpawo Jesu naakatalika mulimu wakwe wakali amyaaka yakuzyalwa makumi aatatu. Wakali mwana mulombe (mbuli mbukwakaklikuyelelwa) kuti Josefa mulombe waHeli, ");
INSERT INTO dov_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","mwana waMatati, mwana waLevi, mwana Melichi, mwana wa Janayi, mwana waJosefa. ");
INSERT INTO dov_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josefa wakali mwana wa Matatiyasi, mwana wa Amos, mwana wa Naumi, mwana wa Esili, mwana wa Nagayi, ");
INSERT INTO dov_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","mwana wa Mati, mwana wa Matatiyasi, mwana wa Simiyoni, mwana wa Josekki, mwana wa Juda. ");
INSERT INTO dov_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda wakali mwana waJowanani, mwana wa Lesa, mwana wa Zelubbabbeli, mwana wa Salatiyeli, mwana wa Neli, ");
INSERT INTO dov_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","mwana wa Melikki, mwana wa Elimadamu, mwana wa Eli, ");
INSERT INTO dov_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","mwana wa Joshuwa, mwana wa Eliyeza, mwana wa Jolimu, mwana wa Matati, mwana wa Levi ");
INSERT INTO dov_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi wakali mwana wa Simiyoni, mwana wa Juda, mwana wa Josefa, mwana wa Eliyakim, mwana wa ");
INSERT INTO dov_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meliya, mwana wa Mena, mwana Matata, mwana wa Natani, mwana wa Davida, ");
INSERT INTO dov_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","mwana wa Jese, mwana wa Obbeti, mwana wa Bbowazi, mwana wa Salimoni, mwana wa Nasiyoni. ");
INSERT INTO dov_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashoni wakali mwana wa Aminadabu, mwana Adimini, mwan wa Alini, mwana wa Heziloni, mwana wa Perez, mwana wa Juda, ");
INSERT INTO dov_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","mwana wa Jakkobo, mwana wa Isakka, mwana wa Abbulamu, mwana wa Tela, mwana wa Nawoli, ");
INSERT INTO dov_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","mwana wa Selugi, mwana wa Lewu, mwana wa Pelegi, mwana wa Ebba, mwana wa Shela. ");
INSERT INTO dov_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila wakali mwana wa Kkayinani, mwana wa Alipazada, mwana wa Semu, mwana wa Nowa, mwana wa Lameki, ");
INSERT INTO dov_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","mwana wa Metusela, mwana wa Inoki, mwana wa Jaledi, mwana wa Mahalaleli, mwana wa Kkayini, ");
INSERT INTO dov_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","mwana wa Inosi, mwana wa Seti, mwana wa Adamu, mwana wa Leza. ");
INSERT INTO dov_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mpawo Jesu, kazwide Muuya Uusalala, wakaboola kuzwa kumulonga wa Jodani, wakazulwidwa a Muuya kuya munkanda ");
INSERT INTO dov_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ooko nkwakaakusunkwa mazuba makumi one adyabbulosi. Takwe nchakalya mumazuba aayo, kumamanino achiindi echo wakaba aanzala. ");
INSERT INTO dov_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dyabbulosi wakati kulinguwe. “na kana koli mwana wa Leza lailila ibwe eli libe chinkawa.” ");
INSERT INTO dov_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu wakamusandula wati, “Zililembedwe, 'Muntu taponi achinkwa luzutu pe.”' ");
INSERT INTO dov_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mpawo dyabbulosi wakazulida Jesu akutomudenzya bwaami boonse bulanyika muchindi chinini. ");
INSERT INTO dov_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mpawo dyabbulosi wakati kulinguwe, “Ndilapa nduwe bwendelezi boonse abulemu mbuli mbundakabupegwa, alimwi ndilakonzya kupa kufumbwa ngundiyanda. ");
INSERT INTO dov_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kuti mpawo, na wafugama akundikomba, zilaba zyako.” ");
INSERT INTO dov_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pesi Jesu wakamusandula wati, “Zililembedwe, 'Ulelede kukomba Mwaami Leza wako, akumumanina milimu yakwe.”' ");
INSERT INTO dov_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Mpawo dyabbulosi wakatola Jesu ku Jelusalema akumubikka ansonge yakaluli katempele, akumwambila kuti, “Na koli mwana wa Leza liwaalile, aansi kuzwa aawa. ");
INSERT INTO dov_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nkaambo kulilembedwe kuti, 'Uyolailila bangelo bakwe atala andinywe, kuti bakukwabilile, ");
INSERT INTO dov_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","mpawo bayokunyampula amaboko aabo, kuchitila kuti utakaligubbuli.'” ");
INSERT INTO dov_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nakamusandula Jesu wakati, “Kulaambidwe kuti, 'Utabiki Mwami Leza wako kumisunko.” ");
INSERT INTO dov_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mpawo diyabbulosi nakamana ku sunka Jesu, wakeenda wakamusiya kusikila chiindi chimbi. ");
INSERT INTO dov_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesu wakabweda ku Galillaya munguzu zyamuuya, a makani atala anguwe akazulila mukati kachisi chizyungulukide. ");
INSERT INTO dov_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Mpawo wakasanguna kuyisya muzikombelo zyabo alimwi wakalumbaizigwa aboonse. ");
INSERT INTO dov_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nakasika ku Nazaleta nkwakakomenezegwa, a mbuli muchiyanza, wakannjila muchikkomnbelo muzuba bwa sabata wakayimikila akubala chakompolola. ");
INSERT INTO dov_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mabhuku amunsinsimi Isaya akapegwa mumaboko akwe. Wakajula bhuku akujana ndawu yakalembedwe kuti. ");
INSERT INTO dov_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Muuya wa Leza uli aalindime, nkaambo wakandinaanika kuti ndaambe makani mabotu kuli bafwaba, wakandituma kuzowamba lwaangunuko kuli aabo baangidwe akuzobonia batakuboni, kwangununa aabo baadyaminizigwe, ");
INSERT INTO dov_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kuzowamba munyaka wa Luse.” ");
INSERT INTO dov_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nakajula mabhuku, wakapa lubo kuli baka bungene kabakkede aansi. Menso aboonse bakali muchikombelo kamulangide. ");
INSERT INTO dov_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wakatalika kwambula ambabo, “Sunu eli jwi lyazuzikizigwa mukumvwa kwanu.” ");
INSERT INTO dov_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Boonse awo bakambula zibotu atala anguwe akugamba majwi aakwe alumbayizigwa akalikuzwa mumulomo wakwe, bakali kuti, “Ooyu temwana wa Josefa na?” ");
INSERT INTO dov_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wakati kulimbabo, “Chamasimpe muyowaamba kasimpi aaka kulindime, musilisi liponye omwini. Kufumbwa nzitwakamvwa nzuwakachita mu Kapenawumu, ita zikozyenie akudolopo lyakulindinywe. ");
INSERT INTO dov_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pele wakati, “Nchobeni ndamwambila kuti takwe musinsimi utambulwa mudolopo lyakwe. ");
INSERT INTO dov_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pele mukasimpe ndamubuzya kuti kwakali bamuka bafu biingi mu Izilayeli muchiindi cha Elayija, ijulu nilyajalwa kwaminyaka iitatu amyeezi iilamusanu awumwi alimwi nzaala mpati yakasika munyika. ");
INSERT INTO dov_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pele Elayija taakwe nakatumwa nikuba kuli umwi wabo, pele kuli Zalafati mu Sidoni, kulimukamufu ukkala nkukooko. ");
INSERT INTO dov_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kwakali bali aazipele biingi mu Izilayeli kwamazuba a Elisya musinsimi, pele takwe nikuba umwi wakali salazidwe kusiya Namani muSayilini.” ");
INSERT INTO dov_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Boonse bantu muchikombelo bakazula kuyoowa nibakamvwa zintu eezi. ");
INSERT INTO dov_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bakabuka bamutanda kuti azwe mudolopo akumuizya atala akalundu idolopo lyabo nkulyakayakilidwe nkumbali kulundu, kabayanda kuti bakamutontele aansi. ");
INSERT INTO dov_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pesi wakayinda akati kabo waya kuli bumbi busena. ");
INSERT INTO dov_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Alimwi wakeendelela akuya ku Kkapenamu, idolopo lilimu Galilii, alimwi wakasanguna kubayiisya atala aSabata. ");
INSERT INTO dov_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bakagamba enjisyo yakwe, nkaambo wakali kwambula changuzu. ");
INSERT INTO dov_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Lino muchikombelo kwakali mwaalumi wakali aamuuya mubi wadayimona, alimwi wakalila akoompolola ajwi pat, ");
INSERT INTO dov_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aah! Niinzi nzitwelede kuchita anduwe, Jesu waku Nazareta? Wasika kuzotujaya na? Ndilizi kuti nduweni - Uusalala wa Leza!” ");
INSERT INTO dov_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu wakamutukila dayimona, akwaamba kuti, “Utaambuli zwa mulinguwe. Aawo dayimona nakamuwisya mwaalumi aakati kabo, wakazwa mulinguwe, alimwi telyakamuchisa abunini. ");
INSERT INTO dov_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Boonse bantu bakagamba, alimwi bakaliswini kwambula atala anzizyo umwi awuumwi. Bakat, “Musyobo nzi wamabala ali obu? Wakulayilila myuuya mibi chabwendelezi anguzu alimwi yazwa.” ");
INSERT INTO dov_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Alimwi makani mabotu akatalika kuyanzala kumabazu woonse akuchisi. ");
INSERT INTO dov_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mpawo Jesu wakazwa muchikombelo, alimwi wakanjila mung'anda ya Sayimoni. Lino banyinazyala ba Sayimoni bakalikuchiswa akupya mubili, alimwi bakabakombelezezya kuli nguwe. ");
INSERT INTO dov_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mpawo wakayimikila kunembo lyamwanakazi akukalalila kupya kwamubili, alimwi bwakamusiya bulwazi. Mpawo, wakanyampuka akutalika kubakutawukila. ");
INSERT INTO dov_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Mpawo zuba nilyakabbila, bantu bakamwetela Jeso boonse bakali aamalwazi asiyenesiyene wakabika maboko akwe kuli boonse akubaponia. ");
INSERT INTO dov_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Madayimona alawo akazwa kubayingi babo, kalikulila kaamba kuti, “Uli Mwana wa Leza!” Jesu wakakalalila ma daimona alimwi akutazumizya kuti uaambule nkaambo akalizi kuti ngu Kkilisto. ");
INSERT INTO dov_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lino nibwakasika buzuba bwakulyokezya, wakaya kubusena buumwide. Makamu abantu akalikumulanguula akasika nkwaakabede. Bakeezya kumukasya kuti atazwi pe akati kabo. ");
INSERT INTO dov_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pele wakati kulimbabo, “Ndilelede alimwi kukambawuka ijwi atala abwami bwa Leza kumadolopo miingi, nkaambo aka nkikambo nkindakatuminwa.” ");
INSERT INTO dov_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Alimwi wakeendelela kukambawuka muzikombelo zyoonse zyamu Judiya. ");
INSERT INTO dov_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lino kwakachitika kuti bantu nibakabungene munsi aJeso akuswilila jwi lya Leza, awo nakimvwi kulubbazu lwalwizi lwa Genesareti. ");
INSERT INTO dov_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wakabona maato obile kagwisigilwe kunkomwe ya lwizi. Basikuzuba nswi bakali bazwa mulingawo bakali kusanzya tunsabwe twabo. ");
INSERT INTO dov_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jeso wakanjila mulilimwi lya bwaato, ilyakali lya Sayimon, akumukumbila kuti aligwisye kuzwa mumanzi kwamusinzo mufwifwi anyika. Alimwi wakakkala ansi akuyiisya bantu anze abwaato. ");
INSERT INTO dov_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Awo nakamana kwambuula, wakati kuli Sayimoni, “Bweeza bwato ububike mumanzi uwaale mansabwe kuti uche.” ");
INSERT INTO dov_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sayimoni wakasandula wati, “Mwaami, twabeleka busiku boonse pesi takwe nchitwajata, pesi mujwi lyako, ndilawala mansabwe. ");
INSERT INTO dov_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lino nibakachita oobo, bakabungika nswi nyinji, a nsabwe zyabo zyakalikudeluka. ");
INSERT INTO dov_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mpawo bakobola benziina bakali muli bumwi bwaato kuti baboole akuzobagwasya. Bakasika akuzuzya maato obile, alimwi batalika kubbila. ");
INSERT INTO dov_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Aboobo Sayimoni Pita, nakachibona wakawida kumawulu aJeso wamba, “Kozwa kulindime nkaambo ndimwaalumi uuchita zibi, Mwami.” ");
INSERT INTO dov_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nkaambo wakagamba, aboonse mbakali aabo, kunswi nzibakajata eezyo nzibakatola. ");
INSERT INTO dov_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Eechi chakabikkilizya Jemusi a Joni, bana ba Zebediya, bakali basimulimunyina a Sayimoni. Jeso wakati kuli Sayimoni, “Utayoowi nkaambo kuzwa sunu kuya kunembo uyozuba bantu.” ");
INSERT INTO dov_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nibakeeta maato aabo kunze, bakasiya zyoonse akutomubela. ");
INSERT INTO dov_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Chakachita kuti nakali kuli limwinya dolopo mwaalumi wakazwide chipele wakali mo. Elyo nakamubona Jeso, wakawida kubusyu bwakwe akumukumbila, wati, “Mwaami, kuti wayanda kondi salazya.” ");
INSERT INTO dov_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Mpawo Jeso wakatambika janza lyakwe wamujata, wati “Ndilayanda kosalala.” Mpawaawo chipele chakamusiya. ");
INSERT INTO dov_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Wakamulayila kuti atawambili naba omwe, mpawo wakamwambila kuti, “Yinka munzila yako, ukalitondezye kumupayizyi ukatuule chipayizyo chakusalazigwa kwako, mbuli mbwakalailila Mozesi bube bukamboni kuli mbabo.” ");
INSERT INTO dov_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pele impuwo atala anguwe yakiinka kule, elyo makamu abantu akasika antoomwe kuti amvwe kuyisya kwakwe akuponisigwa kumalwazi aabo. ");
INSERT INTO dov_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pesi we wakanoonga waya kumasena asisikene kuyookomba. ");
INSERT INTO dov_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kwati limwi zuba kuli eecho chiindi naakali kuyiisya, kwakali baFalisi abayisyi bamulawu bakali kkede aawo, bakazwide kumasena miingi amu Galili, Judiya aku Jelusalema. Nguzu zya Mwami zyakali anguwe zyakuponia. ");
INSERT INTO dov_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nkabela bamwi baalumi bakaza babwezede umwi mwaalumi aabulo wakayuminide mubili, bakayandula nzila yakumunjizya mukati kuti bamubike aansi kunembo a Jeso. ");
INSERT INTO dov_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tebakajana nzila yakumweeta mukati akambo kamakamu, lino bakinka aachiluli chang'anda baseluzya mwalumi achiluli abulo bwakwe, akati lyabantu kunembo lya Jeso. ");
INSERT INTO dov_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Naakabona lusyomo lwabo, Jeso wakati, “Yomwaalumi zibi zyako zyalekelelwa.” ");
INSERT INTO dov_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lino balembi bamulawu aba Falisizi bakatalika kubuzya bakati, “Ngwani oyo waambula chakusampawula ngwani ukonzya kulekelela zibi kunze kwa Leza alikke? ");
INSERT INTO dov_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pesi Jeso wakabona mbubakali kuyeeya, wakasandula wati kuli mbabo, “Nkaamboonzi nimulibuzya mumyoyo yanu? ");
INSERT INTO dov_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nchichili chuuba kwaamba kuti, 'Zibi zyako zyako zyalekelelwa akwaamba kuti nyampuka uyende?' ");
INSERT INTO dov_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pele kuti mukazibe kuti mwana wamuntu ulaanguzu aanyika zyakulekelela zibi, ndati kuli nduwe, “Nyampuka bweza bulo bwako uye kung'anda yako.” ");
INSERT INTO dov_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mpawaawo wakabuka kunembo lyabo wabweza bulo bwakwe mpaakalede. Mpawo wakiinka kung'anda yakwe, kayabulumbayizya Leza. ");
INSERT INTO dov_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Boonse bakagamba mpawo balumbaizya Leza. Bakazuzigwa buyoofu bati, “Twabona zintu zyiindilide sunu.” ");
INSERT INTO dov_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Musule lyazezi zyakachitika, Jeso wakazwa wayinka eelyo wakabona simutelo uutegwa Levi kakkede aatente lyabasimutelo. Wakati kuli nguwe, “Nditobele.” ");
INSERT INTO dov_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mpawo Levi wakabuka wamutobela wasiya zyoonse musule. ");
INSERT INTO dov_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nkabela Levi wakachitila Jesu pobwe pati mung'anda yakwe, kwakaliko basimutelo biingi abantu bakakkede aabo aatafula kuti balye ambabo ");
INSERT INTO dov_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","pesi ba Falisi bakalikutongawukila basikwiiya bakwe kabati, “Nkaamboonzi nalya abasimutelo abasizibi?” ");
INSERT INTO dov_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu wakabasandula wati, “Bantu batachiswi tabayandi musilisi, pesi luzutu aabo bachiswa. ");
INSERT INTO dov_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tendakazida baluleme pesi aabo basizibi kuti basanduke.” ");
INSERT INTO dov_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bakati kulinguwe, “Basikwiiya ba Joni bakalikulyiimya kulya akukomba abasikwiiya baba Falisi bachita mbubo. Pesi basikwiiya bako balalya akunywa.” ");
INSERT INTO dov_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mpawo Jesu wakati kulimbabo, “Mpali na uukonzya kwaamba kulibasikutambwa kupobwe kuti balyiimye chakulya sikukwata kachiliwo? ");
INSERT INTO dov_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pesi buzosika buzuba aawo sikukwata natazo bwezwe kuzwa kulimbabo, kumazuba aayo bazolyimya.” ");
INSERT INTO dov_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Lino Jesu wakaamba chikozyanisyo kulimbabo. “Taakwe naba omwe uudelula chigamba chachisamo chipya akuchibelesya aachisamo chikulukulu. Kuti wachita oobo uladeluula chisamo chipya. Lino chigamba chizwa kuchisamo chipya tachikonzyi kweelela kuchisamo chikulukulu. ");
INSERT INTO dov_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Taakwe uubika wayini mupya muchibikilo chachiindi. Kuti wachita oobo wayini mupya ulabbalula chibikilo. Lino wayini ooyo uyoofusuka alimwi chibikilo achilacho chilanyonyooka. ");
INSERT INTO dov_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pele wayini mupya welede kubikwa muchibikilo chipya chakubikila wayini. ");
INSERT INTO dov_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Taakwe naba omwe uunywa wayini mukulukulu uuyanda kunywa wayini mupya, uwamba kuti wachiindi ulimbubo. ");
INSERT INTO dov_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lino zyakachitika muSabata awo Jesu nakalikuyabweenda akwiinda akati kamyuunda yazilyo, alimwi basikwiya bakwe bakabweza nseke zyazilyo, kabapukapuka akati kamaboko abo, akulya. ");
INSERT INTO dov_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pele bamwi babaFalisi bakati, “Nkaamboonzi nimuchita chitali mumulawu mubuzuba bwaSabata?” ");
INSERT INTO dov_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Wakasandula Jesu wakati, “Sa tamunabala eezyo nzyakachita Davita awo naakaba aanzala, mwini ambakali abo? ");
INSERT INTO dov_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wakanjila mung'anda yaLeza alimwi wabweza chinkwa chisalala mpawo walya chisela, alimwi wapa chimwi kuli baabo mbakalabo kuti balye, nikuba chakalimumulawu luzutu kuti bapayizi abalikke bachilye.” Mpawo wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Mwana a Muntu ngoMwami waSabata.” ");
INSERT INTO dov_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Zyakachitika kuti imwi Sabata wakanjila muchikombelo chamaJuda wayisya bantu. Mumoomo mwakali mwalumi wakali akuboko kwachilisyo kwakayumide. ");
INSERT INTO dov_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Balembi bamulawo abaFalisi bakamulangisisya kuyanda kubona kuti ulaponya umwi na muSabata, kuti bamujanine kaambo kakumupa mulandu. ");
INSERT INTO dov_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pele wakalizizi nzibakali kuyeeye alimwi wakati kumwalumi wakali akuboko kuyumide, “Nyampuka mpawo wiimikile akati kaboonse.” Aboobo wakanyampuka wayimikila aawo. ");
INSERT INTO dov_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesu wakati kulimbabo, “Ndamubuzya, chili mumulawu na muSabata kuchita bubotu na bubi kuvuna buumi na kujaya?” ");
INSERT INTO dov_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Mpawo wakalangalanga kuli boonse wasikuti kumwaalumi, “Tandibika luboko lwako.” Wakachita mbubo, alimwi lwakatalamuka.” ");
INSERT INTO dov_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pesi bakazula kunyema abasikwaambilana kuti bamuchite buti Jesu. ");
INSERT INTO dov_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Zyakachitika mumazuba aayo mpakayinka kuchilundu kukukomba. Wakiinkila kunembo mansiku woonse mukukomba kuli Leza. ");
INSERT INTO dov_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nibwakacha, wakayita basikwiya bakwe kulinguwe, alimwi wakasala bali kkumi ababili, aabo mbakati mbatumwa. ");
INSERT INTO dov_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mazina abatumwa mbaba Sayimoni (oyo ngwakati Pita) a mukulana wakwe Endulu, Jemusi, Joni, Filipu, Bbatolomiyo, ");
INSERT INTO dov_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo, Tomasi, Jemusi mwana wa Alufiyasi, Sayimoni walikutegwa muZiloti, ");
INSERT INTO dov_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judasi Sikkaliyoti, wakazoba sikwaaba Jesu. ");
INSERT INTO dov_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pele Jesu wakaseluka kuzwa kuchilundu ambakali aabo mpawo wiimikila antandabale amakamu mapati abasikwiya bakwe a bantu biingi bazwa kuJudiya a kuJelusalema akunkomwe yalwizi lwaTaya a Sidoni. ");
INSERT INTO dov_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bakaza kuzoswiilila kulinguwe akuponesegwa zilwazi zyabo. Bantu bakali kukatazigwa amyuuya mibi bakaponesegwa abalabo. ");
INSERT INTO dov_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Woonse wakali munkamu wakali kweezya kumuguma nkambo manguzu akuponya akali kuzwa mulinguwe, alimwi wakabaponya boonse. ");
INSERT INTO dov_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mpawo wakalanga kulibasikwiiya bakwe alimwi wati, “Mulilongezedwe nywebo nobachete, nkambo bwami bwaLeza mbubwanu. ");
INSERT INTO dov_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mulilongezedwe nywebo nimufwa nzala, nkambo muyokkutisigwa. Mulilongezedwe nimulila lino, nkambo muyooseka. ");
INSERT INTO dov_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mulilongezedwe nywebo nimuyosulwa abantu, alimwi bayomusaamika akumusampawula, akaambo kaMwana waMuntu. ");
INSERT INTO dov_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mukabotelwe mubuzuba oobo akusotoka mulukondo, nkambo chakasimpe muyooba ampindu mpati kujulu, nkaambo basikale babo bakajisi basinsimi munzila ilibobu. ");
INSERT INTO dov_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pele chabija kulindinywe nibavubi, nkaambo mwatambula kale luumbulizyo lwanu. ");
INSERT INTO dov_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Chabija kulindinywe nimukkusi lino, nkaambo muyooba anzala, chabija kulindinywe nimuseka lino, nkaambo muyolila akukwiila muchindi chitobela. ");
INSERT INTO dov_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Chabija kulindinywe na woonse muntu kawamba bubotu andinywe, nkaambo mbubo basikalebabo mbubakabajisi basinsimi bakubeja. ");
INSERT INTO dov_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pele ndati kulindinywe nimulikuswilizya, yanda basinkondonyokwe alimwi muchite zibotu kulimbabo bamusula. ");
INSERT INTO dov_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mulongezye baabo bamutuka alimwi mukombele aabo bamusukuusya. ");
INSERT INTO dov_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kuli wooyo ukuuma seya mupe lubo alimbi. Na umwi muntu wabweza chibaki chaajulu utamwiimi chakunsi. ");
INSERT INTO dov_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pa kumuntu woonse uukukumbila. Na umwi muntu wabweza chintu chako utamwaambili kuti achiboozye kulinduwe. ");
INSERT INTO dov_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mbuli mboyanda kuti bantu bakuchitile weelede kubachtila ayebo mbuboobo. ");
INSERT INTO dov_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Na wayanda luzutu aabo bakuyanda mbulumbuunzi buli kulinduwe? Nkaambo nikuba abasizibi balabayanda aabo babayanda. ");
INSERT INTO dov_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na wachitila kabotu aabo bakuchitila kabotu, zikugwasyanzi? Nkaambo abalabo basizibi balazichita eezyo. ");
INSERT INTO dov_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na kogwasya biyo aabo bakonzya kukubweedezya nzuwabapa, chikugwasyayi? Nkaambo basizibi abalabo balapa basizibinyina, kuti bajane mpindu ikozyenie. ");
INSERT INTO dov_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pesi muyande basinkondonyokwe mubachitile zibotu. Mupegwe mutalangili kupegwa lubo aboobo mpindu yenu iyooba mpati alimwi muyooba bana ba Simajulu, nkaambo we lwakwe uli aaluyando nikuba akulaabo batakwe luyando abasizibi. ");
INSERT INTO dov_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mube aaluzya nkaambo Wuso alakwe ulaaluzyalo. ");
INSERT INTO dov_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mutabeteki, alimwi tamkoyobetekwa. Mutapi mulandu, alimwi tamukoyoopegwa mulandu. Mukalekelele bamwi, alimwi muyolekelelwa. ");
INSERT INTO dov_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pa, alimwi chiyoopegwa kulinduwe. Cheelelo chibotezya - chisindiidwe akuzula chakufusuuka - chiyootiliilwa aazibelo zyako. Nkaambo mweelo ngobelesya nguwonya uyoobelesegwa kulinduwe.” ");
INSERT INTO dov_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mpawo wakabaambila lubo chimbi chikozyanisyo. “Sa muntu moofu ulakonzya na kukwela moofunyina? Na wachita boobo, bobile te balawida mugolonga, anga tabakoowida na? ");
INSERT INTO dov_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sikwiiya takomeneni muyiisyi wakwe pe, pesi woonse kuti wayiisigwa ulamba mbuli muyiisyi wakwe. ");
INSERT INTO dov_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nkaambonzi nolanga kasyapu kakasamu kali mulinso lyamwana wakwanu, pesi kotaboni chisamu chili mulilyako linso lyako nomwini? ");
INSERT INTO dov_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ibuti mbonga ulakonzya kwaambila mwana wakwanu kuti, 'Mwanakesu, leka ndikugwisye kasyapu kakasamu kali mulinso lyako,' pesi iwe muli lyako linso kotabwene chisamu chilimo? Nduwe sikuupawupa! Sanguna ugwisye chisamu chilimulinso lyako, mpawo uyoobona kabotu kugwisya kasyapu kakasamu kali mulinso lyamwanakwanu. ");
INSERT INTO dov_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Nkaambo taakwe musamu mubotu uuzyala michelo iibolede, taaakwe munsamu uubolede uunga ulazyala muchelo mubotu. ");
INSERT INTO dov_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nkaambo awumwi munsamu ulizibikene amusyobo wamichelo nguuzyala. Nkaammbo bantu tabacheli nkuyu kuzwa kumuumvwa, nikuba kuchela masansa kuzwa kumoobankonono. ");
INSERT INTO dov_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Muntu mubotu kuzwa kububotu bwamoyo wakwe, alimwi muntu mubi kuzwa mububi bwamoyo wakwe ugwisya zibi. Nkaambo kuzwa mubuvule bwamoyo mulomo ulaambuula. ");
INSERT INTO dov_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nkaamboonzi nimundiita kuti, 'Mwami, Mwami,' pesi tamulemeki zintu nzewamba? ");
INSERT INTO dov_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Woonse muntu uuza kulindime akumvwa majwi aangu alimwi kaalemeka, ndiyoomwambila kuti ulimbuli nyamanzi. ");
INSERT INTO dov_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ulimbuli muntu uuli kuyaka ng'anda, wakasya wanika mpawo wayaka ntalisyo yang'anda yakwe amwaala uusimide. Awo zambangulwe nilyasikide, maanzi miingi alakunka awuma ng'anda pesi taakakonzya kwpiizungania pe, nkaambo yakauyakwa kabotu. ");
INSERT INTO dov_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pele uumvwa majwi aangu akutaalemeka, ulimbuli muntu uuyaka ng'anda aamuse kaatakwe ntalisyo, maanzi aakasika abukali bwawo bwakuuma ng'anda eeyo mpawo yawa lunyonyooko loonse lweenda amaanzi.” ");
INSERT INTO dov_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aawo Jesu nakamana zyoonse nzyakalikwaamba kubantu, wakanjila mu Kkapenawuma. ");
INSERT INTO dov_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lino mupati wabasilumamba wakali aamuzike wakwe ngwaakalikuyandisya, pesi wakali wachiswa kali waamba kufwa. ");
INSERT INTO dov_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mupati wabasilumamba nakamvwa aatala a Jesu, wakamutumina bapati babaJuda, kamukumbila kuti asike azosilike muzike wakwe. ");
INSERT INTO dov_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nibakasika kuli Jesu, bakamukumbila chamoyo woonse kabati, “Uleelede kuti ajane luzyalo kuzwa kulinduwe, ");
INSERT INTO dov_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","nkaambo ulayiyandisya nyika yesu, alimwi nguwe wakatuyakila chikombelo.” ");
INSERT INTO dov_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Lino Jesu wakeendela kunembo ambabo. Pesi katananba kule ang'anda, Silumamba mupati wakatuma beenzinyina kaamba kuti, “Mwami utalikataazyhi lwako, nkaambo nsyeelede pe kuti usike mung'anda yangu. ");
INSERT INTO dov_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nkaambo kaako nchindabona nkesyeelede pe kuti ndisike kulinduwe, pesi wamba biyo jwi ulapona mulanda wangu. ");
INSERT INTO dov_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nkaambo andime ndili mwaalumi ulimunsi lyanguzu, ndilaabasilumamba munsi lyangu. Ndilaamba kuliyooyu kuti, 'Yinka', ulayinka, akuli umbi kuti, 'Sika,' ulasika, aku, mulanda wangu kuti, 'Chita eechi,' alimwi ulachichita.” ");
INSERT INTO dov_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesou naakamvwa majwi aaya akamugambya, wakalanga makamu akayobumutobela wati, “Ndati kuli ndinywe, taakwe nikuba mu Izilayeli moonse nkundakajene lusyomo luli boobu.” ");
INSERT INTO dov_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aboobo aabo bakatuminwe nibakabweeda kung'anda bakajana muzike wapona. ");
INSERT INTO dov_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kuzwa aawo Jesu wakaya kudolopo litegwa Nayini, mpawo basikwiiya bakwe abantu biingi bakiinka aawe. ");
INSERT INTO dov_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kali waamba kusika afwiifwi amulyango wadolopo eelyo, langa, kuli mwaalumi wakafwide wakalikuyabugwisigwa, wakali mwana wabanyina kali aalike (banyina bakali mukamufu), nkamu yabantu mpati kuzwa mudolopo oomu yakali aanguwe mwanakazi ooyu. ");
INSERT INTO dov_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aawo Mwami naakamubona, luzyalo lwakamujata loko nkaambo kayooyu mwanakazi mpawo wakati kuli nguwe, “Utalili pe.” ");
INSERT INTO dov_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mpawo wakayinka wakujata bulo bwakalazikidwe mutunta, mpawo aabo bakanyampwide bakayimikila. Wakati, “Mulombe, ndati kulinduwe, buka.” ");
INSERT INTO dov_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ooyu mwaalumi wakafwide wakabuka wakkala akusanguna kwaambuula, mpawo Jesu wakamupeda kuli banyina. ");
INSERT INTO dov_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mpawo kuyoowa kwakanbasikila boonse, alimwi bakaumbayizya Leza, bakati, “Musinsimi mupati wabusigwa akati kesu” akuti “Leza wabalanga bantu bakwe.” ");
INSERT INTO dov_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aaya makani aatala a Jesu akazula mukati ka Judea yoonse amukati kamasena ayizyungulukide. ");
INSERT INTO dov_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Basikwiiya ba Joni bakamwaambila zyoonse eezi izntu. ");
INSERT INTO dov_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Mpawo Joni wakayita basikwiiya bakwe babili mpawo wabatuma ku Mwami kuti bakatedi, “Nduwe na uzabuza, naakuti tulangile umbi?” ");
INSERT INTO dov_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nibakasika aafwiifwi a Jesu bakati Joni Mubbabbatizyi watutuma kuti tozotedi, 'Nduwe na uzabuza, nakuti tulangile umbi?” ");
INSERT INTO dov_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Muwola eelyo wakapnia bantu bangi kuzwa kumalwazi, machise akumyuuya mibi, mpawo boofu biingi wakabania babona. ");
INSERT INTO dov_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesu wakabasandula wati, “Nimwabweeda amukaambe kuli Joni eezyo nzimwabona akumvwa. Boofu balikubona, basinkematwi balikumvwa, bateemndi balikweenda, bachiswa chipele balikusalazigwa, bafu balikubuka kababoola kubuumi, bafwaba mbalikubuzigwa majwi mabohtu. ");
INSERT INTO dov_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ooyo muntu uutaleki kusyoma mulindime nkaambo kanchito zyangu uli longezezegwe.” ");
INSERT INTO dov_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nibakabweeda basikutumwa ba Joni, Jesu wakasanguna kwaambula kumakamu aabantu aatala a Joni kati, “Niinzi nchimwayinka munkanda kuyoobona? Itete lilikuteketesegwa aguwo? ");
INSERT INTO dov_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pesi niinzi nchimwaya kukubona aanze? Mwaalumi uuzwete zizwaato zibotu? Amulange, aabo bazwata zizwaato zibotu abakkede buumi bubotu bali mumaanda abaami. ");
INSERT INTO dov_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pesi mniinzi nchimwaya kukubona aanze? Musinsimi? Iyii, ndati kulindinywe mupati kwiinda musinsimi. ");
INSERT INTO dov_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ngonguwe ulembeledwe majwi ati, 'Amulange, ndatuma mutumwa kunembo lyabusyu bwako, utakabambe nzila kunembo lyako.' ");
INSERT INTO dov_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ndati kuli ndinywe, woonse wakazyalwa aamwanakazi, taakwe mupati kwiinda Joni. Pesi ooyo muniini mu bwami bwa Leza mupati kwiinda nguwe.” ");
INSERT INTO dov_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aawo bantu boonse nibakazimvwa eezi kubika aantomwe abasimutelo, bakaamba kuti Leza uli luleme, kwiinda mukubbabbatizigwa alubbabbatizyo lwa Joni. ");
INSERT INTO dov_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pesi ba Falisi abasibusongo bamulawu wachi Juda bakalikakila luyando lwa Leza kulimbabo, nkaambo taakwe nibakali babbabbatizigwa a Joni pe. ");
INSERT INTO dov_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Mpo, nga ndilabakozyanisya aanyamanzi aba bantu baleeli zyalane? ");
INSERT INTO dov_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Balimbuli bana balikusobana kuchisambalilo, aabo bakkede kabalikwiitilana kuti, 'Twakulizizya nyeele taakwe nuwazyana pe. Twakwiimbila lwiimbo lwadilwe pesi takwe nuwalila pe.' ");
INSERT INTO dov_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nkaambo Joni mubbabbatizyi wakasika katalyi chinkwa katanywi wayini, pesi mwaamba kuti, 'Ula dayimona.' ");
INSERT INTO dov_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwana wa Muntu wakasika kalya akunywa, mwaamba kuti, 'Amulange ulaamafwiti mpawo ulakolwa, muzolani wabasimutelo abasizibi! ");
INSERT INTO dov_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pesi mbusongo buboneka kwiinda mubana babusongo.” ");
INSERT INTO dov_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lino ba Falisi bakamutamba Jesu kuti azolye aabo. Aboobo Jesu nakanjila mung'anda yaba Falisi wakakkala atafula kuti alye. ");
INSERT INTO dov_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Amulange kwakali mwanakazi wamudolopo eelyo wakali sizibi. Naakamvwa kuti wakali kutafula mung'anda yamu Falisi, wakeeta kankuli kakazwide mafuta anunkilila. ");
INSERT INTO dov_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nakiimvwi kusule lyakwe afwiifwi amawulu aakwe, kalikulila, wakasanguna kutetya mawulu aakwe amisozi yakwe, mpawo wakaabukusa amasusu aakwe akumyonta mawulu aayo akwananika mafuta aanunkilila. ");
INSERT INTO dov_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aawo mu Falisi wakatambide Jesu naakabona eezi kazichitika wakayeeya mumoyo wakwe, wakati, “Kansinga ooyu mwaalumi walimusinsimi, walikunooziba musyobo wamwanakazi ulikumwampampa kuti ngusizibi.” ");
INSERT INTO dov_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesu wakasandula wati kulinguwe, “Sayimoni, mpuchili ncheyanda kwaamba kuli nduwe.” Wakati, “Wamba. Muyiisyi!” ");
INSERT INTO dov_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesu wakati, “Umwi wakalikua zikwelete zyamali wakali aabasizikwelete nbabil. Umwi wakali aachikwelete chama dinari aali myaanda musanu, umwi makkumi musanu. ");
INSERT INTO dov_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nibakakachilwa kubweedezya mali yakwe, wakabalekelela boonse. Aboobo nguli akati kabo uutamuyande loko?” ");
INSERT INTO dov_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sayimoni wakamusandula wati, “Ndiyeeya kuti ngooyo wakalekelelwa aapati.” Jesu wakamusanduka wati, “Wasandula kabotu.” ");
INSERT INTO dov_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesu wakachengunukila kumwanakazi wasikuti kuli Sayimoni, “Wamubona ooyu mwanakazi. Ndanjila mung'anda yako. Taakwe nuwandipa maanzi akusamba mawulu aangu, pesi we watetya mawulu aangu amisozi yakwe akwaabukusa amasusu aakwe. ");
INSERT INTO dov_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Taakwe pe nuwandimyonta, pesi kuzwa mpundasikila talikuleka pe kumyonta mawulu aangu. ");
INSERT INTO dov_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Taakwe nuwananika mutwe wangu amafuta, pesi we wananika mawulu aangu amafuta aanunkilila. ");
INSERT INTO dov_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aboobo ndati kulinduwe, zibi zyakwe zyali zyiingi loko, zyalekelelwa - nkaambo waba aluyando lupati. Pesi ooyo ulekelelwa buniini uyanda buniini.” ");
INSERT INTO dov_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mpawo wakati kumwanakazi, “Zibi zyako zyalekelelwa.” ");
INSERT INTO dov_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aabo mbaakakkede aabo atafula bakasanguna kwaambula akati kabo kabati, “Ngwani ooyu uulekelela niku zibi?” ");
INSERT INTO dov_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mpawo Jesu wakati kumwanakazi, “Lusyomo lwako lwakufutula, koya muluumuno. ");
INSERT INTO dov_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Musule aachiindi Jesu wakeenda muzisi amumyuunzi kayabukambawuka akwaamba makani mabotu aatala abwaami bwa Leza. Balikumi ababili bakali antoomwe anguwe, ");
INSERT INTO dov_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","alubo bakali aamwi awumwi mwanakazi wakaponesegwa kuzwa kumyuuya mibi akuzilwazi. Meli wakalikutegwa Magadalini ooyo wakaponesegwa kuzwa kuma dayimona ali musanu aabili; ");
INSERT INTO dov_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jowana, mukayintu wa Chuza, mubanzi wa Helodi, Susana abamwi biingi bakalikumusanina, kuzwa kulubono lwabo. ");
INSERT INTO dov_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lino makamu aabantu naakabungene, bakaza kulinguwe kabazwa mumadolopo asiyene siyene wakabaambila chikozyanisyo. ");
INSERT INTO dov_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mulimi wakaya kukubyala mbuto zyakwe, awo kalikubyala imwi yakawida munzila yalyatwa aamawulu abantu atuyuni twakujulu twakiilya. ");
INSERT INTO dov_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Imwi yakawida aabwe, yakamena chakufwambaana, mpawo yakanyana, nkaambo teyakalikwe kuteta aansi. ");
INSERT INTO dov_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Imwi yakawida mumaamvwa, mpawo maamvwa akakomena aamwi ambuto mpawo akiiyasa mbuto. ");
INSERT INTO dov_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pesi imwi yakawida mumuse mubotu mpawo yakazyala michelo yakali abana biinda mwaanda.” Jesu nakaamana kwamba eezi zintu, wakoompola wati, “Ooyo uulamatwi aakumvwa, ngamvwe.” ");
INSERT INTO dov_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Basikwiiya bakwe bakabuzya kuti chaambayi chikozyanisio eechi. ");
INSERT INTO dov_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wakati, “Luzibo lwansiswa zya Leza lulipedwe kulindinywe, pesi kulibamwi ndaambula muzikozyanisyo, nkaambo 'balabona pesi tababonesesyi, mpawo balamvwa pesi balakonzya kutamvwisisisya.' ");
INSERT INTO dov_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Lino nchechi chaamba chikomzyanisyo eechi: mbuto ndijwi lya Leza. ");
INSERT INTO dov_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aabo bali munzila mbaabo bamvwa, pesi dyabbulosi wasika wabweza jwi kuzwa mumyoyo yabo, kuchitila kuti tabasyomi akufutulwa. ");
INSERT INTO dov_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mpawo aabo bali aabbwe mbaabo, banga balimvwa jwi, balalimvwa chakukondwa. Pesi tabakwe miyanda; balasyoma kwakayindi kaniini mpawo muchiindi chamasunko balawida aansi. ");
INSERT INTO dov_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mmbuto yakawida mumaamvwa mbantu banga balimvwa jwi, pesi nibeenda mnzila zyabo, balayaswa azintu zyenyika abuvubi antoomwe abubotu bwabuumi oobu, alimwi michelo yabo tiikomeni pe. ");
INSERT INTO dov_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pesi imbuto yakawida mumuse mubotu, aaba mbaabo, bamvwa jwi amoyo wachoonzyo alusyomo, balalijata akuzyala michelo kabali alukakatizyo ");
INSERT INTO dov_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Lino, taakwe, uunga nadomeka lampi wali vumba achisuwo mna kulibika smuchinkuma. Ulalibika aachibikilo chalampi kuchitila kuti limunikile boonse banjila mung'anda, kuti babone mumuni. ");
INSERT INTO dov_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nkaambo tachiwo pe chisisikene chitakaleke kuzibwa, nikuba nsiswa iitakaleke kuzibwa mumuni wazoosika. ");
INSERT INTO dov_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aboobo amuswiilizye kabotu nkaambo ooyo uula nchajisi uyooyungizigwa, pesi ooyo uutakwe nchajisi nikuba eezyo nzyayeeya kuti ulijisi uyoonyanzigwa.” ");
INSERT INTO dov_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mpawo banyina abakwabo bakasika kuli nguwe, pesi taakwe nibakamuswena afwiifwi pe nkaambo kamakamu miingi. ");
INSERT INTO dov_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bakamwaambila kuti, “Banyoko abakwanu, baliimvwi aanze bayanda kukubona.” ");
INSERT INTO dov_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pesi Jesu wakavwiila wati kuli mbabo, “Baamba abakwesu mbaabo bamvwa jwi lya Leza akulichita.” ");
INSERT INTO dov_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lino bumwi buzuba wakanjila mubwaato abasikwiiya bakwe, mpawo wakati kulimbabo. “Atuye kulilimbi bbazu lya lwizi.” Bakayamba. ");
INSERT INTO dov_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kabachiyabuyamba, wakawona. Imvula mpati ilaaguwo yakasika aatala alwizi, bwaato bwabo bwakatalika kunjila maanzi alimwi bakali baba mubuyumuyumu. ");
INSERT INTO dov_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mpawo basikwiiya ba Jesu bakaza kuli nguwe bamusinsimuna bati, “Mwami, Mwami, twaamba kufwa. Wakabuka mpawo wuumuzya guwo amaanzi mpawo kwabatama. ");
INSERT INTO dov_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Mpawo wakati kuli mbabo, “Luli kuli lusyomo lwanu?” Pesi bakayoowa akugamba, bakabuzyania umwi awumwi kabati, “Ngwani ooyu, iguwo amanzi eelyo zilamuswiilizya?” ");
INSERT INTO dov_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bakayamba bakusika kuchisi cha Gelasensi, chili miutala eeliya alwizi lwa Galili. ");
INSERT INTO dov_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Lino Jesu naakalyata aanyika wakaswaana umwi mwaalumi wakali aama dimoni. Wakali waba achiindi chilamfu katakwe naakazwete zigogo pe, alubo teensi wakali kukkala mung'anda pesi wakali kukkala kuzyuumbwe. ");
INSERT INTO dov_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Aawo naakabona Jesu waka kwiila akuwida munsi lakwe wati kulinguwe ajwi pati, “Uli aamakanze nzi andime, Jesu mwana wa Leza uusumpukide loko? Ndakukumbila utandipenzyi.” ");
INSERT INTO dov_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nkaambo Jesu wakali walayilila muuya mubi kuti uzwe mumuntu. Nkaambo wakali wamupenzya kwachiindi chilamfu, nikuba wakuli kunoonga waangwa nsimbi anketani, wakalikuzidunsula alimwi wakalikunoonga wazulwidwa amuuya ooyo kuya mulusaka. ");
INSERT INTO dov_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Mpawo Jesu wakamubuzya wati, “Nduweni zina lyako?” Wakasandula wati, “Ligiyoni,” nkaambo bakali biingi badayimona bakamunjide. ");
INSERT INTO dov_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aawo bakali kumukumbila kuti atabatandili mumulindi uutagoli. ");
INSERT INTO dov_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lino butanga bwa ngulube bwakali kuchela munsi aachilundu. Mpawo badayimona aabo bakakumbila kuti banjizigwe mungulube eezyo, mpawo Jesu wakaazumizya. ");
INSERT INTO dov_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Madayimona aayo akazwa mumuntu aakunjila mungulube, alimwi ingulube eezyo zyakachijaana zyankunukila mulwizi zyayinkila. ");
INSERT INTO dov_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lino aabo bakali kweembela tanga lya ngulube nibakabona zyakachitika, bakachijanina muguzi bakuluula zakachitika. ");
INSERT INTO dov_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mpawo bantu biingi bakasika kuti bazobone zyakachitika, mpawo bakasika kuli Jesu bazojana kuli mwaalumi ooyo kuli nguwe badyabbulosi nkubaka tandwa. Walkalikkede munsi lya Jesu, kazwete alimwi kali waba amaanu kalikabotu mpawo bakayoowa. ");
INSERT INTO dov_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lino aabo bakazibona zyakachitika bakababuzya mbuzyakachitika zyakuponesegwa kwa mwaalumi wakali aaba dayimona mbaakaponesegwa. ");
INSERT INTO dov_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lino bantu bamu Gerasensi bakakumbila Jesu kuti azwe kuli mbabo, nkaambo obakali baba aakuyowa kupati. Aboobo wakaknjila mubwaato kuti basangune kuyamba babweede. ");
INSERT INTO dov_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mwaalumi ooyu wakagwisigwa ba dyabbulosi wakakumbila Jesu kuti bayinke aamwi, pesi Jesu wakamukakila wati, ");
INSERT INTO dov_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Bweeda kumunzi wako ukabaambile zyoonse Leza nzyakuchitila.” Ooyu mwaalumi wakayinka kayobwaamba mudolopo lyoomnse aatala anzyakamuchitila Jesu. ");
INSERT INTO dov_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lino Jesu nakabweeda, makamu akamutambula nkaambo bakali kumulangila. ");
INSERT INTO dov_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Amubone umwi mwaalumi uutegwa Jayilasi wakali uumwi wabeendelezi bachikombelo, wakasika wawida kumawulu aa Jesu mpawo wamukumbila kuti ayinke kung'anda yakwe, ");
INSERT INTO dov_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","nkaambo mwanakwe uzyedwe alikke, musimbi wakali amyaaka yakachibe kkumi ayibili wakali waamba kufwa. Awo Jesu nakali munzila kuya nkuko, makamu makamu aabantu akamuzyunguluka chaku syankana. ");
INSERT INTO dov_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lino aawo kwakaliwo mwanakazi wakali kuzwa gazi kwamyaaka iilikumi ayibili mpawo wakabelesya mali yakwe yoonse kuzibbadela, pesi taakwe naakapona pe. ");
INSERT INTO dov_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wakasika kusule lya Jesu mpawo wakajata lupipito lwa jansi lyakwe, mpawo aawo gazi lyakayimikila kuzwa. ");
INSERT INTO dov_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu wakati, “Ngwani wandi guma?” Boonse nibakakazya Pita wakati, “Makamu makamu aabantu alikuzyungulukide alimwi akusyankania.” ");
INSERT INTO dov_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pesi Jesu wakati, “Mpali wandiguma nkaambo ndaziba kuti inguzu zyazwa mulindime.” ");
INSERT INTO dov_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lino mwanakazi ooyo naakabona kuti takuyubiki wakaza ulakankamba akuwida ansi kunembo lyakwe. Wakalungununa kunembo lyabantu boonse nchaakamugumina akuponesegwa nkwaakachita mpawo aawo. ");
INSERT INTO dov_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mpawo wakati kuli nguwe “Mwanangu, lusyomo lwako lwakufutula. Yinka muluumuno.” ");
INSERT INTO dov_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Naakachili kwaambula, umwi wakasika kuzwa kung'anda yamuzuluzi wachikombelo, wati, “Mwana wako wafwa kale. Utachimukatazyi pe muyiisyi.” ");
INSERT INTO dov_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pesi Jesu naakamvwa eezi wakasansula Jayilasi wati, “Utayoowi, syoma biyo, mpawo ulaponesegwa.” ");
INSERT INTO dov_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Naakasika kung'anda, taakwe muntu ngwaakazumizya kunjila aawe, kunze kwa Pita a Joni a Jemusi, awisi wamwana abanyina. ");
INSERT INTO dov_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lino boonse bakali kuusa akumulila, pesi wakati, “Mutalili pe; tafwide pe ulikoona biya.” ");
INSERT INTO dov_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pesi bakamuseka, nkaambo bakalizi kuti ulifwide. ");
INSERT INTO dov_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mpawo wakamujata akuboko akoompolola, wakati, “Yo mwana buka!” ");
INSERT INTO dov_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Muuya wakwe waka boola, mpao aawo wakabuka. wakabalayilila kuti bamupe chakulya. ");
INSERT INTO dov_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bazyali bakwe bakagamba pesi wakabalayilila kuti bataambili muntu achakachitika. ");
INSERT INTO dov_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wakiita bali kumi ababili mpawo wabapa nguzu anzumizyo aatala abadayimona boonse akuponia malwazi. ");
INSERT INTO dov_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wakabatuma kuyo kambawuka bwami bwa Leza akuyosilika bachiswa. ");
INSERT INTO dov_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wakati kulimbabo, “Mutabwezi chintu mulweendo lwenu, nuuba mufunko, niiba nkomo, nichiba chinkwa, nichiba chimbi chizwaato. ");
INSERT INTO dov_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kufumbwa ng'anda njimutakakanjile, amukakkale mulinjiyo mane mukeende. ");
INSERT INTO dov_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kufumbwa nkubatakaleke kumutambula, nimwayoozwa mudolop eelyo muka kunkumune lusuko lwakumawulu aanu kunembo lyabo bukabe bukamboni kulimbabo.” ");
INSERT INTO dov_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mpawo bakeenda biinda mum gunzi, kabayabwaambuula majwi mabotu akuyabuponia bantu koonse koonse. ");
INSERT INTO dov_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lino Helodi naakamvwa aatala azyoonse zyakalikuchitika, wakali kataazya, nkaambo bamwi bakali kwaamba kuti Joni Mubbabbatizyi wakali wabuka kubafu, ");
INSERT INTO dov_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","alimwi kwakali kutegwa Elija wakali kuboneka, akuti bamwi basinsimi biingi bakale bakali babuka. ");
INSERT INTO dov_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helodi wakati, “Ndakamugonka mutwe Joni, mpo ngwani ooyu ngwelikumvwa aatala azeezi zintu?” Aboobo wakeezya kumubona. ");
INSERT INTO dov_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nibakabpoola batumwa, bakaambila Jesu zyoonse nzibakakuchita. Mpawo wakababweza, bakayinka kubusena bulikule kudolopo litegwa Bbetisayida. ");
INSERT INTO dov_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pesi makamu aabantu naakamvwa eezi akamutobela. Wakabatambula akwaambula kulimbabo aatala abwami bwa Leza, akuponia aabo bakalikuyanda kuponesegwa. ");
INSERT INTO dov_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","lino buzuba sbwakali bwaamba kusika kumamanino, mpawo baikkumi ababili bakasika kulinguwe bati, “Wambila bantu aaba beende baye muma gunzi ali aafwiifwi bakayandule akoona achakulya, nkaambo ookuno nkutubede mbusena butakwe chintu pe.” ");
INSERT INTO dov_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pesi we wakati kulimbabo, “Amubape chakulya ndinywe.” Bakati, “Tujisi biyo zinkwa zilimusanu abaswi babili- kunze aakuti twiinke tukawulile bantu boonse aaba chakulya.” ");
INSERT INTO dov_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Kwakali baluumi bakalikusika zyuulu zisanu.) Wakati kuli basikwiiya bakwe “Amubaambile bakkale muzibunga zyamakkumi musanu.” ");
INSERT INTO dov_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aboobo bakachita mbubakaambilwa bakkazika bantu aansi. ");
INSERT INTO dov_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wakabweza zinkwa zilimusanu abaswi babili, wakalanga kujulu, wakazilongezya mpawo wakazikwamuuna, mpawo wakapa kuli basikwiiya kuti baabile bantu. ");
INSERT INTO dov_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Boonse bakalya bakuta, bufwefwelenga bwakabweezelelwa bwakachaala bwakali kuzuzya zisuwo zili kumi azibili ");
INSERT INTO dov_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Chakasika chiindi chakuti Jesu wakalikukomba alike, basikwiiya bakali anguwe. Wakabuzya kuti, “Makamu aabantu ati ndimeeni?” ");
INSERT INTO dov_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bakasandula kuti, “Joni Mubbabbatizyi. Pesi bamwi bati Elija, mpawo bamwi bati umwi musinsimi wakale wakabuka.” ");
INSERT INTO dov_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mpawo wakati kulimbabo, “Pesi nywe muti ndimeni?” Pita wakasandula kuti, “Munanike Kkilisito wa Leza.” ");
INSERT INTO dov_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pesi wakabadidimizya chamanguzu kuti bataambili muntu pe, ");
INSERT INTO dov_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","kati, “Mwana wa Muntu welede kusyonsegwa kuzintu zyiingi akukakwa abapati, bapati babapayizi antoomwe abalembi bamulawu, mpawo uzojiigwa mpawo mubuzuba bwatatu uzobuka.” ");
INSERT INTO dov_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mpawo wakati kuli mbabo boonse, “Na kwaba muntu uyanda kunditobela weelede alikake abweze chiingano chakwe abuzuba anditobele. ");
INSERT INTO dov_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ooyo uyanda kutabilila buumi bwakwe uyoobuswekelwa, pesi ooyo uyoswekelwa buumi bwakwe nkaambo kandime uyoobubamba. ");
INSERT INTO dov_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Niinzi chibotu kuti muntu ajane nyika yoonse, pesi akasweekelwe abumi bwakwe? ");
INSERT INTO dov_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ooyo uufwa bweeme nkaambo kangu amajwi aangu, alakwe Mwana wa Muntu uyofwa bweeme nayooza mubulemu bwakwe, bulemu bwa Wisi abangelo basalala. ");
INSERT INTO dov_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pesi ndatki kulindinywe nchobeni, kulibamvwi biimvwi aawa batayi kuyoomvwa lufu kabatana bona bwami bwa Leza.” ");
INSERT INTO dov_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","lino pmusule lyamazuba musanu aatatu Jesu kali waamba majwi aaya, wakabweza Pita a Joni a Jemusi mpawo wakatanta kalundu kuyookomba. ");
INSERT INTO dov_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nakali kukomba busyu bwakwe bwakasanduka, mpawo zisamo zyakwe zyakatuba chakwiindilizya. ");
INSERT INTO dov_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mpawo amulange, baalumi bobile bakali kwaambula aawe, Mozesi a Elija, ");
INSERT INTO dov_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","bakaboneka muchiimo chabulemu bupati. Bakali kwaambula aatala akwenda kwakwe, oko nkwakali walangila kweeta kumamanino mu Jelusalemu. ");
INSERT INTO dov_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Lino Pita abaabo bakali aawe bakali fwide biya akoona, pesi nibakasinsimuka, bakabonuna bulemu bwakwe abaalumi bobile bakayimvwi aawe. ");
INSERT INTO dov_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aawo nibakali kuyobusosoloka kuzwa kuli Jesu, Pita wakati kulinguwe, “Mwami, nchibotu kulindiswe kuti katuli aano. Atuyake zitumba zyotatwe, chimwi chako, chimwi cha Mozesi, achimbi cha Elija” (taakwe nakezi nzyaakali kwaambuula). ");
INSERT INTO dov_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kachaambuula oobu, joba lyakasika lyabavumba, mpawo bakayoowa nibakanjila mujoba. ");
INSERT INTO dov_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ijwi lyakamvwika mujoba kaliti, “Ooyu mwana wangu, uusalidwe; amumuswiilile.” ");
INSERT INTO dov_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ijwi nilyakamana kwaambula Jesu waka chaala kali aalike. Bakawumuna alimwi taakwe ngubakaambila pe mumazuba aayo anzibakabona. ");
INSERT INTO dov_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Likno mubuzuba bwakatobela, nibakaselela mukalundu, inkamu yabantu mpati yakamutambula. ");
INSERT INTO dov_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Amulange umwi mwaalumi kuzwa munkamu wakoompolola, kati, “Muyiisyi, ndakombelela ulange mwana wangu, nkaambo ngomwana wangu alike. ");
INSERT INTO dov_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Langa, muuya nga wamujata mpawo nga wasanguna kukwiila; zimupa kusuntuka mpawo nga wazwa fulu kumulomo. Tuufwaambani kumuleka pe alimwi umupa kuchubbuuka kapati. ");
INSERT INTO dov_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ndakumbila basikwiiya bako kuti bawutande pesi bakachilwa.” ");
INSERT INTO dov_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu wakasandula wati, “Nywebo nozyalane litasyomi, ndeelede kuba aandinywe kwachiindi chilamfu biyeni akukkala aandinywe? Yeta mwana wako aano.” ");
INSERT INTO dov_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nakalikuyobuza mulombe ooyu, muuya wakamuwisizya aansi akumusuntula. Pesi Jesu wakawulayilila muuya mubi akumuponia, akumubwedezya kulo wisi. ");
INSERT INTO dov_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mpawo bakagamba abupati bwa Leza. Aawo kabachigamba boonse aali nzyakali wachita, wakati kulo basikwiiya bakwe, ");
INSERT INTO dov_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Aaya majwi ayelede kunjila loko mmatwi eenu: Mwana wa Muntu uzowabwa kumaanza abaalumi.” ");
INSERT INTO dov_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pesi tebakamvwisisisya nzyakalikwaamba. Zyakasiswa kuli mbabo, aboobo tebakaziba nchizyaamba. Alimwi bakayoowa kuti babuzye aatala amajwi aaya. ");
INSERT INTO dov_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mpawo kwakabuka kukazyania aatala akuti ngwani aakati kabo utaazobe mupati kwiinda bamwi. ");
INSERT INTO dov_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pesi Jesu naakaziba zyakali mumyoyo yabo, wakabweza mwana muniini wamweeta kubbazu lyakwe ");
INSERT INTO dov_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mpawo wakati kulimbabo, “Ooyo uutambula mwana ooyu muzina lyangu, utambula ndime, ayooyo uutambula ndime, utambula ooyo wakandituma. Nkaambo ooyo muniini akati kenu ngonguwe mupati.” ");
INSERT INTO dov_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Joni walkasandula wati, “Mwami, twabona umwi muntu kalikutanda madayimona muzina lyako pesi twamukasya, nkaambo takutobeli pe antoomwe andiswe.” ");
INSERT INTO dov_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Tamumukasyi pe,” Jesu wakasandula, “nkaambo ooyo uutamulwani nguwenu.” ");
INSERT INTO dov_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nakaswemna mazuba akuti atolwe kujulu, wakabikka budyu bwakwe kuti baye ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wakatma batumwa kunembo lyakwe, bakayinka bakunjila mulilimwi kgunzi lyama Samaria kabamubambila zyoonse. ");
INSERT INTO dov_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pesi bantu bamugunzi eelyo tebakamutambula pe nkaambo wakalikutozya ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Basikwiiya bakwe nibakachibona eechi, bakati kulinguwe, “Mwami, uyanda kuti twiite mulilo na kuzwa kujulu iunbanyonyoone boonse?” ");
INSERT INTO dov_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pesi wakabalanga wabakalalila, ");
INSERT INTO dov_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","mpawo kbakaya kulilimbi gunzi. ");
INSERT INTO dov_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kabayobweenda munzila, umwi muntu wakati, “Ndilakutobela koonse nkotakaye.” ");
INSERT INTO dov_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu wakati kulinguwe, “Baswumpe bali aabulyango, atuyuni twamujulu tuli azizoumbo, pesi mwana wamuntu takwe mpanga ulasegezya mutwe wakwe.” ");
INSERT INTO dov_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mpawo wakati kuli umwi, “Nditobele.” Pesi wakati, “Mwami, Ndizumine ndikavwike taata wangu sansi.” ");
INSERT INTO dov_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pesi wakati kulinguwe, “Leka bafu bavwikke bafunyina. Pesi webo, yinka ukakambawuke kule aatala abwami bwa Leza.” ");
INSERT INTO dov_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mpawo umwi wakati, “Ndilakutobela, Mwami, pesi ndizumine ndooneke aabo bali amuunzi ");
INSERT INTO dov_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","wangu.”Jesu wakamusandula wati, “Taakwe uubikka kubo kwakwe ");
INSERT INTO dov_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Lino musule azyoonse eezi, Mwami wakasala bambi basika makkumi mousanu amakumi aabili, amwi malembe manji achiindi aamba kuti makumi usanu aabili pesi amwi ati makumi musanu ababili mpawo wakabatuma babili babili, kunembo lyakwe kumadolopo woonse ngakalangilide kwiinda mulingawo. ");
INSERT INTO dov_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wakati kulimbabo, “Butebuzi mbunji loko, pesi babelesi mbache. Aboobo amukumbile kuli Leza wabutezi kuti atumine babelesi kumuunda wakwe. ");
INSERT INTO dov_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Amwinke munzila yanu. Amulange ndamutuma mbuli mbelele akati kabawumpe. ");
INSERT INTO dov_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tamubwezi nkomwe yamali, tamubwezi zikwama, tamubwezi nsangu, mpawo tamujuzyi bantu munzila. ");
INSERT INTO dov_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kufumbwa ng'anda njimuyonjila, amukasangune akuti, “Luumuno alube aatala ang'and eeyi!' ");
INSERT INTO dov_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na kakuli muntu waluumuno aawo, luumuno lwenu luyokkala aalinguwe, pesi kuti kaatakwe, luyoobola kulindinywe. ");
INSERT INTO dov_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Amukakkale mung'anda eeyo kamulya akunywa eezyo nzibayoomupa, nkaambo mubelesi uleelede mufolo walkwe. Tamukeendi kuzwa kulimwi ng'anda kuya kuliimbi. ");
INSERT INTO dov_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kufumbwa dolopo ndimuyoonjila, bakamutambule, amukalye eezyo nzibatakamupe, ");
INSERT INTO dov_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","mpawo mukasilike bachiswa aawo. Amukatedi kulmbabo, 'Bwami bwa Leza bwasika afwiifwi andinywe.' ");
INSERT INTO dov_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kufumbwa doloo ndimuyoonjila, bakakake kumutambula, amukayinke mumigwagwa mukatedi, ");
INSERT INTO dov_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Nikuba lusuko lwamudolopo lyenu lwajatilila kumawulu eesu tulalukunkumuna kunembo lyenu! Pesi amuzibe eechi: Bwami bwa Leza bwasika afwiifwi.' ");
INSERT INTO dov_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ndamwaambila kuti nibwayoosika buzuba bwakubetekwa kuyoba mbubo ku Sodoma kwiinda eelyo dolopo. ");
INSERT INTO dov_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mapenzi kulinduwe, Kkolazini! Mapenzi kulinduwe, Bbetisayida! Na milimu mipati yakachitwa mulindinywe yakali yachitwa mu Taya amu Sidon, nibanga bakasanduka chiindi loko, kabakkede muzizwato zyamasaka akulinana dota. ");
INSERT INTO dov_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pesi chiyoba mbubo ku Taya a Sidon kwiinda ndinywe. ");
INSERT INTO dov_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iwe, Kkapenawuma, uyeeya kuti uzosumpwidwa kujulu na? Pepe, uzoboozegwa aansi ku Hadesi. ");
INSERT INTO dov_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ooyo uyoomuswiilila waswiilila ndime, ayooyo uyoomukaka wakaka ndime, aboobo ooyo undikaka wakaka awakandituma.” ");
INSERT INTO dov_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aaba balimakumi musanu amakumi aabili nakaboola lkabali mulukondo, kabaamba kuti, “Mwami, abadayimona boonse bakali kutuswiilila muzina lyako.” ");
INSERT INTO dov_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu wakasandula kati, “Ndalikweeba Satani kawa kuzwa kujulu mbuli kalabi. ");
INSERT INTO dov_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Amulange ndamupa manguzu aakulyata aatala anzoka atubanze, anguuzu zyoonse kwiinda zyasinkondonyokwe, alimwi taakwe nikuba muliili nzila chiyoomuchisa. ");
INSERT INTO dov_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nikuliboobo tamukondwi loko kuli zeezi azilike, pesi amupakale nkaambo mazina aanu alembwa kujulu.” ");
INSERT INTO dov_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kuchiindi nchincheecho wakabotelwa loko mu Muuya Uusalala, mpawo wakati, “Ndakutembawula, Taata, Mwami wa julu anyika, nkaambo wakasisa zikntu eezi kulibasibusongo akumvwisisisya, mpawo waziyubununa kuli aabo batayisizigwe, mbuli bana baniini. Iyii, Taata, kakuliboobo chalikubotezya kubusyu bwako.” ");
INSERT INTO dov_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Zintu zyoonse zyapegwa kulindime kuzwa kuli Taata, alimwi taakwe uuzi Mwana kuti ngwani kunze kwa Taata, mpawo taakwe uuzi kuti Taata ngwani kunze kwa Mwana akuli wooyo Mwana ngasala kuybunwida.” ");
INSERT INTO dov_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mpawo wakachengunukila kuli basikwiiya bakwe mpawo wabaambila chansiswa kuti, “Balilongezezegwe aabo babona nzimubona. ");
INSERT INTO dov_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ndati kulindinywe, kuli basinsimi biingi bakali aachiyandsyo chakubona nzimubona, pesi taakwe nibakazibona pe, akumvwa zintu nzimumvwa, pesi, taakwe nibakazimvwa pe. ");
INSERT INTO dov_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Amulange umwi muyiisyi wamilawu yachi Juda, wakanyampuka kayanda kumusunka, wakati, “Muyiisyi, niinzi nchenga ndilachita kuti ndijane buumi butamani?” ");
INSERT INTO dov_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu wakamusandula wati, “Kulembedwe kutyeni mumulawu? Muubala biyeni?” ");
INSERT INTO dov_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Naakasandula wakati, “Yanda Mwami Leza wako amoyo wako woonse, amuuya wako woonse, anguzu zyako zyoonse, akuyeeya kwako koonse, mpawo uyande simabambanwa wako mbuli mbmoliyanda omwini.” ");
INSERT INTO dov_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu wakatgu kulinguwe, “Wasandula kabotu. Zichite eei ulapona.” ");
INSERT INTO dov_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pesi muyiisyi ooyu, nakalikweezya kulilwanina wakabuzya lubo kuli Jesu wati, “Animpo simabambanwa wangu ngwani?” ");
INSERT INTO dov_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kalikumusandula Jesu wakati, “Umwi mwaalumi wakalikuyabuselela kazwa ku Jelusalema katozya ku Jelikko, wakaswaana babbi bakamubbida zintu zyakwe, mpawo bakamuuma bamusiya kali waamba kufwa. ");
INSERT INTO dov_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Muchoolwe umwi mupayizi wakalikuyabweenda anzila njiyeeyo, mpawo naakamubona, wakiimnda mbali. ");
INSERT INTO dov_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Alubo mu Levi alakwe, nakasika aawo wamubona, wakiinda mbali. ");
INSERT INTO dov_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pesi umwi mu Samaliya, wakali mulweendo lwakwe alakwe, wakasika aawo mpaakabede. Naakamubona wakamufwida luzyalo. ");
INSERT INTO dov_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wakaswena aafwiifwi wamwaanga zilonda, akumutila mafuta awayini aazilonda. Wakamutansika aamunyama wakwe mpawo wamutola kung'anda yabeenzu, kuyomubamba. ");
INSERT INTO dov_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nibwakacha wakagwisya maseleni aabili, wapa mwani muunzi mpawo wakati, “Mubambe alimwi zyoonse nzuyoobelesya kwiinda aawa, ndaboola ndizokuliya.' ");
INSERT INTO dov_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ngwani akati kabaaba batatu, ngumunga mulayeeya kuti, ngosimabambanwa kuli ooyo pwakawumwa abasikubba?” ");
INSERT INTO dov_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Muyiisyi wakati, “Ooyo wakamutondeezya luzyalo.” Jesu wakamusandula wati, “Koya ukachite mbubo ayebo.” ");
INSERT INTO dov_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lino nibakali kuyobweenda wakanjila mulilimwi gunzi, mpawo umwi mwanakazi uutegwa ngu Malita wakamutambula mung'anda. ");
INSERT INTO dov_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wakali amwana wakwabo walikutegwa ngi Meli, ooyo wakakkala kumawu a Mwami akumvwa jwi lyakwe. ");
INSERT INTO dov_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pesi Malita wakalijisinkini loko akubakutawukila kuti abape chakulya. Wakasika kuli Jesu wati, “Mwami, tokubwene na kuti mwanakesu wandilekelezya kuti ndibeleke endike? Mwaambile asike azoondoigwasye.” ");
INSERT INTO dov_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pesi Mwami wakamusandula wati, “Malita, Malita, uli aakulikataazya azintu zyiingi, ");
INSERT INTO dov_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pesi nchintu chomwe biyo chiyandikana. Meli wasala chibotu loko kwiindilila alimwi tachikwe nayoochinyanzigwa pe.” ");
INSERT INTO dov_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Zyakachitika limwi zuba Jesu kalikukomba kuli bumwi busena, awo nakamanisya umwi wabasikwiya bakwe wakati, “Mwami, tuyisye kukomba mbuli Joni mbwakayisya basikwiya bakwe.” ");
INSERT INTO dov_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesu wakati kuli mbabo, “Mwakomba mwambe kuti, 'Taata, izina lyako lilemekwe mbuli lisalala. Akuze bwami bwako. ");
INSERT INTO dov_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Utupe zilyo zitwelede buzuba abuzuba. ");
INSERT INTO dov_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Utulekelele zibi zyesu, mbuli mbutubalekelela boonse bali azikweleta kulindiswe. Utatweenzi mukusunkwa.” ");
INSERT INTO dov_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesu wakati kulimbabo, “Kuli na uyooba amwenzinyina, elyo akayinke akati kamansiku, akwamba kuti kulinguwe, 'Mwenzuma, ndikwelete zinkwa zitatu, ");
INSERT INTO dov_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nkambo mwenzuma wasika, kazwida kumugwagwa, alimwi takwe nchindilacho pe kuti ndimupe.' ");
INSERT INTO dov_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Oyo wakali mukati ulakonzya kwamba kuti, 'Utandidubi. Ikkoma lyajalwa kale, alimwi bana bangu, balandime, bali abulo. Tandikonzyi kubuka pe kuti ndipe nduwe chinkwa.' ");
INSERT INTO dov_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ndamba kuti kulindunywe, nikuba kuti takobuka akumupa chinkwa mkambo kakuti mwenzinyokwe, asi nkambo kakukakatila kwanu chabuusu, uyobuka akupa zyoonse zinkwa nzimunooli kamuyanda. ");
INSERT INTO dov_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Alubo ndamwambila kuti, mukumbile, ellyo muyoopegwa; muyandule; alimwi mulajana; mukonkomone, alimwi mulajulilwa. ");
INSERT INTO dov_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nkambo kuli woonse ukumbila ulapegwa; ayooyo uyandula ulajana; akuli woyo ukonkomona uyojulilwa. ");
INSERT INTO dov_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nguni wisi akati kanu, na mwana ake walomba muswi ulamupa nzoka muchindi chakumupa muswi? Malembe mabotu achindi alachibalo chifwifwi. Amwi malembe achiindi alachibalo chilamfu, chikonzya kujanika lubo muli Matayo 7: 9: Nguni wisi akati kanu, na mwana wakwe mulombe wakumbila chinkwa, ulamupa bbwe na? Na muswi, ulamupa nzoka na?. ");
INSERT INTO dov_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Na walomba iiji, ulamupa kabanze na? ");
INSERT INTO dov_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nikubaboobo, na inywe nubabi mulizi kupa zipo zibotu kubana banu, zyiinda biyeni Taata wanu ulikujulu upa Muuya Usalala kulaabo bamukumbila?” ");
INSERT INTO dov_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lino Jesu wakalikutanda dayimona utambuli pe. Mpawo dayimona nakazwa, mwalumi utakwe wakalikwambula wakambula, alimwi makamu abantu akagamba! ");
INSERT INTO dov_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pesi bamwi bantu bakati, “NguBbelizebbule mwendelezi wabadayimona, ngwatanzya badayimona.” ");
INSERT INTO dov_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bamwi bakamusunka akuyanda kubona chitondezyo chizwa kujulu. ");
INSERT INTO dov_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pesi Jesu wakalizi muzeezo yabo elyo wakati kulimbabo, “Boonse bwaami bupambukene bulasaalwa, an'anda ipambukene ilawa. ");
INSERT INTO dov_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na Satani walipambula, ibwami bwakwe buyooyimikila biyeni? nkambo mwamba kuti nditanzya Bbelizebbule badayimona. ");
INSERT INTO dov_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na nditanzya Bbelizebbule badayimona, nguni batobela banu ngubatanzya? Nkambo kacheechi, bayooba babetesi banu. ");
INSERT INTO dov_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pesi na nditanda badayimona akutondeka kanwe kaLeza, nkukuti Bwami bwaLeza bwasika kulindinywe. ");
INSERT INTO dov_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kuti mwalumi singuzu ulaazilwano zikwene walinda n'anda yakwe, lubono lwakwe lunokkede kabotu, ");
INSERT INTO dov_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","pesi na mwalumi singuzu wamuzunda, oyo mwalumi singuzu ulabweza zilwano ezyo mwalumi oyo nzyalikusyoma akupaza lubono lwamwalumi oyo. ");
INSERT INTO dov_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Oyoo utalamwi andime ngundilwisya, ayooyo utabunganizyi andim ngumwaya. ");
INSERT INTO dov_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Namuuya mubi wazwa mumwalumi, ngawayinda mubusena butakwemaanzi akuyandula kulyokezya. Nutakajane takwe busena, ulamba kuti, 'Ndiyojokela mun'anda mundakazwa.' ");
INSERT INTO dov_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na wajokela, ulajana kuti mun'anda muliyiidwe kamubambidwe kabotu. ");
INSERT INTO dov_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mpawo ulajoka kwakweeta imyuuya ili musanu ayibili mibi kwiinda nguwo elyo yoonse ilaza kuzokkala mumo. Mamannino abuumi bwamwalumi oyu bulabija kwiinda lutanzi.” ");
INSERT INTO dov_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Zyakachitika kuti, na kalikwamba zintu eezi, umwi mwanakazi wakoonzomoka atala amakamu abantu kaamba kuti kulimbabo, “Bulilongezedwe bula obo bwakatumbuka ankolo ezyo zyakakukomezya.” ");
INSERT INTO dov_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pesi wakamba kuti, “Kwindilila, balilongezedwe abo bamvwa ijwi lyaLeza akulibamba.” ");
INSERT INTO dov_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Awo makamu abantu nakalibuyobuvula, Jesu wakatalika kwamba kuti, “Elizyalani ndizyalani bbi. Lilangula chitondeezyo, nikuba takwe chitondezyo nchiliyopegwa kunze kwachitondeezyo cha Jona. ");
INSERT INTO dov_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nkaambo mbuli Jona mbwakaba chitondeezyo kuli ba Niniva, aboobo alakwe Mwana mulombe wa Muntu uyooba chitondeezyo kuzyalani eeli. ");
INSERT INTO dov_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Mwami mwanakazi wakumbo uyoonyampuka kulubeta abantu bazyalani eli akubapa mulandu, nkambo wakazwa kumasimpilo anyika kuti akamvwe busongo bwaSolomoni, amubone, umwi mupati wiinda Solomoni kuti mpali. ");
INSERT INTO dov_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bantu bakuNiniva bayooyima kulubeta azyalani eli lyabantu akubapa mulandu, nkambo bakasanduka kukukambawuka kwaJona, amubone, umwi mupati kwiinda Jona mpali. ");
INSERT INTO dov_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Takwe ungaamana kutunginizya lampi, inga walibikka asisikene na ansi alusuwo, pesi kuti achikkalilo chalyo, kwitila kuti abo banjila bakonzye kulibona. ");
INSERT INTO dov_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Liso lyako ndilampi lyamubili wako. Na liso lyako ndibotu, mubili woonse ngawazuzigwa mumuni. ");
INSERT INTO dov_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pesi na liso lyako ndibbi, mubili wako woonse uzwide kusiya. ");
INSERT INTO dov_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kuti na mibili yanu yazuzigwa amumuni, katakwe chimwi chzo chilimumudima, elyo mibili yanu iyooba mbuli lampi mbuli mweekesya alindinywe.” ");
INSERT INTO dov_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Lino nakamana kwambula, muFalisi wakamukumbila kuti bakalye antoomwe kun'anda yakwe, mpawo Jesu wayinka wakulya. ");
INSERT INTO dov_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","MuFalisi wakagamba kuti Jesu take nakasanguna kusamba pe kayanda kulya. ");
INSERT INTO dov_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pesi Mwami wakati kulinguwe, “Lino mpo, inywe nimaFalisi musanzya kunze kwankomeki azilido, pesi mukati kanu muzwide bungu abubu. ");
INSERT INTO dov_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Inywe nubantu nimutakonzyi kuyeeya! Oyo wakalenga kunze teensi nguwe na wakalenga mukati? ");
INSERT INTO dov_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mupe echo chilimukati mbuli chabilo, awo zintu zyoonse kulindinywe ziyosalazigwa. ");
INSERT INTO dov_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Pesi maawe nywebo kulindinywe nimFalisi, nkambo mulapa chakkumi champoko achamusamu wakulisilika ayimwi michelo yamuchilili, pesi mukaka kusalazigwa a luyando lwaLeza. Zilimbubo biyo kusyomeka akuyanda Leza, kakutakwe chikachizya kuchita zimwi azilazyo. ");
INSERT INTO dov_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Maawe nywebo nimaFalisi, nkambo muyanda zyuno zyakunembo muzikombelo akujuzigwa chabulemu muzisambalilo. ");
INSERT INTO dov_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Maawe kulindinywe, nkambo muli mbuli zibunda zitaboneki awo bantu mpubendela kabatazi.” ");
INSERT INTO dov_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Umwi wabasikulingula mulawo wakati kulinguwe, “Muyisi eezi nzulikwamba ulikututukila aswebo.” ");
INSERT INTO dov_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu wakati, “Maawe nywebo, nibayiisi bamulawu! Nkambo mubikka bantu mikuli milemu njibatakonzyi kunyampula, pesi takwe nimwiguma pe mikuli eyo akanwe kanu kamwi. ");
INSERT INTO dov_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Maawe kulindinywe, nkambo muyakila basinsimi zibunda, alimwi mbasikale banu bakabajaya. ");
INSERT INTO dov_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nkambo inywe mulibakamboni akuzuminana amilimu yabasikale banu, nkambo mbakabajaya alimwi mulikuyaka zibunda zyabo. ");
INSERT INTO dov_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","51","Nkambo kacheechi, busongo bwaLeza bwamba kuti, 'Ndiyotuma basinsimi aBatumwa, alimwi bayobapenzya akubajaya bamwi babo.' Eeli zyalani, ndilyo, liyooyimikila bulowa boonse bwabasinsimi bwakatikila kuzwa kumalengelo anyika, kuzwa kubulowa bwaAbbelo kuyosika kubulowa bwaZakkaliya, ooyo wakajayigwa akati kachipayililo abusena busalala. Iyi ndamwambila, kuti zyalani ndiyooyimikilila. ");
INSERT INTO dov_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Maawe kulindinywe nimulingulula mulawo, nkambo mwakagwisya chijulusyo chaluzibo; tamulinjili nubeni, alimwi mulakasya abo banjila. ");
INSERT INTO dov_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesu nakazwa awo, balembi bamulawu abaFalisi tebakamuswilila pe alimwi bakamukazya zintu zyiingi. Bakalikumuyubilila, ");
INSERT INTO dov_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kuti bakonzye kubweezya chimwi kuzwa kumulomo wake. ");
INSERT INTO dov_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Muleecho chiindi, zyuulu zyabantu zyiingi nizyakabungana, bakasyankana akulyatana, wakasanguna kuti kuli basikwiiya bakwe chakusanguna, “Amuchenjelele busweezyo bwaba Falisi, kakuli kuupawupa. ");
INSERT INTO dov_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pesi taakwe chivumbidwe, chitakabule kuyubununwa, alimwi taakwe chisisidwe, chitakabule kuzibinkana. ");
INSERT INTO dov_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aboobo zyoonse nzimuyowamba mumudima ziyoomvwigwa mumumuni, azeezyo nzimwakavwiyavwiya mumatwi kamuli mumaanda amukati ziyoompololwa atala atululi ");
INSERT INTO dov_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ndati kulindinywe bazolani bangu, tamubayoowi pe aabo bajaya mubili, musule azeezyo tabachikwe chimbi chakuchita. ");
INSERT INTO dov_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pesi ndilamwaambila aatala akuti ngwani ngumunga mulayoowa. Amuyoowe ooyo, uunga naajaya, ulaanguzu zyakuwaala mumulilo. Iyii, ndati kulindinye, amuyoowe nguwe ooyo. ");
INSERT INTO dov_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Teensi tuyuni tusanu tulawuzigwa atukobili tuniini tubili na? ");
INSERT INTO dov_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pesi tatulubwi pe kunembo lya Leza. Pesi nikuba masusu eenu alaamyeelwe woonse. Mutayoowi. Muli aabulemu kwiinda bayuni biingi. ");
INSERT INTO dov_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ndati kulindinywe, kufumbwa uundizumina kunembo lyabantu, Mwana wa Muntu uyoomuzumina kunembo lyabangelo ba Leza, ");
INSERT INTO dov_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","pesi ooyo uundikaka kunembo lyabantu, uyookakwa kunembo lyabangelo ba Leza. ");
INSERT INTO dov_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kufumbwa uyoowambula majwi mabi aatala a Mwana wa Muntu, uyoolekelelwa, pesi ooyo usampawula Miuuya Uusalala, taakwe natakalekelelwe pe. ");
INSERT INTO dov_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nibatakamweete kunembo lya Zikombelo, babetesi, abasimilawu, tamukalikataazyi kuti muyowaambuula biyeni mukuli lwanina, nakuti muyotyeni, ");
INSERT INTO dov_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","nkaambo Muuya Uusalala uyomuyiisya muli nchicheecho chiindi zyakwaamba.” ");
INSERT INTO dov_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mpawo umwi wakali munkamu yabantu wakoompolola wati, “Muyiisyi, ambila mwanakesu kuti andaabile ambeno lukono.” ");
INSERT INTO dov_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu wakasandula wati “Yoo mwalumi, ngwani wakandinanika kuba mubetesi na sing'enda akati kenu?” ");
INSERT INTO dov_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mpawo wakati kulimbabo, “Amulangisisye eezyo zintu nzimulibambila kuzwa kubulyabi, nkaambo buumi bwamuntu tabulangwi kwiinda muzintu nzyaleezyo.” ");
INSERT INTO dov_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Mpawo Jesu wakabaambila chikozyanisyo, kati, “Muunda wamuntu muvubi wakali abutebuuzi bwiingi, ");
INSERT INTO dov_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","wakayeeya mumoyo wakwe, wati, 'Ndilachita biyeni, nkaambo nsikwe katuula kakubambila zilyo zyangu?' ");
INSERT INTO dov_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wakati, 'Eezi nyesichite. Ndilakolomona tutuula twangu ndiyake tumbi tupati, oomo mwesizobambile zilyo zyangu azimwi zintu. ");
INSERT INTO dov_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mpawo ndiyoti kumuuya wangu, “Muuya waba aazintu zyiingi zibambidwe kwamyaaka myiingi. Lyookezye kabotu, lya, nywa, upakale.” ");
INSERT INTO dov_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pesi Leza wakati kuli nguwe, 'Yoomwaalumi mufubafuba, sunu muuya wako ulayandikana, zintu nzwabamba ziyooba zyani?' ");
INSERT INTO dov_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mbabede muntu uulibambila buvubi pesi katavubide kuli Leza.” ");
INSERT INTO dov_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesu wakati kuli basikwiiya bakwe, “Aboobo ntati kulindinywe, tamulikataazyi nkaambo kabuumi - kuti muyoolya nzi, na amubili wanu - kuti muyoozwaatayi. ");
INSERT INTO dov_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nkaambo buumi bwiinda kulya, alimwi mubili wiinda zizwaato. ");
INSERT INTO dov_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Amulange bayuni, tababyali na kutebula. Tabakwe tutuula, pesi Leza ulabapa chakulya. Mulekede bupati loko nywebo kwiinda bayuni! ");
INSERT INTO dov_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ngwani akati kenu uunga naalikataazya wayungizya mazuba akupona kubuumi bwakwe? ");
INSERT INTO dov_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na kotakonzyi kuchita eecho chitu chinini, nkaambo nzi nimulikataazya azimwi zyoonse? ");
INSERT INTO dov_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Amulange masokwe - alakomena. Taabeleki, na kulikataazya. Pesi nadti kulindinywe, nansya Solomoni mubulemu bwakwe boonse taakwe nakali wazwaata kwiinda aawa. ");
INSERT INTO dov_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na Leza kazwaatika masokwe aalimumuunda, aanga sunu mpaali, juunza asowelwa mumulilo, ulamuzwaatika bwiingi butanali nywebo, Nozyalane lyalusyomo luniini! ");
INSERT INTO dov_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tamulaanguuli nchimutalye na nchimutanywe, alimwi tamulikataazyi. ");
INSERT INTO dov_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nkaambo zisi zyoonsye zyaanyika zilanguula zintu eezi, alimwi Wuso ulizi kuti mulaziyanda zintu eezi. ");
INSERT INTO dov_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pesi amuyandule bwami bwakwe, mpawo eezi zintu ziyopegwa kulindinywe. ");
INSERT INTO dov_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mutayoowi, nkaambo Wuso uulikujulu ulabotelwa kumupa bwami. ");
INSERT INTO dov_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Amuuzye zyoonse zimulazyo mupe kubachete. Amulichitile nkomwe zitadeluki pe - buvubi bwakumajulu butamani, kutasiki basikubba afwiifwi, alimwi kutaligwi munanze. ");
INSERT INTO dov_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nkaambo ooko kuli buvubi bwako, moyo wako nkuubede. ");
INSERT INTO dov_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Amwaange zizwaato zyenu alukumba muchikungu, muyasye malampi eenu akkale kayaka, ");
INSERT INTO dov_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mube mbuli bantu bayandula mwami wabo, naboola kuzwa kupobwe lyalukwatano, kuchitila kuti nasika kakonkomona balafwambaana kumujulila. ");
INSERT INTO dov_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bali longezezegwe aabo belanda, bayojanika kaba bbwazwide naayosika mwami wabo. Nchobeni ndamwaambila kuti uyowanga nsasiko yakwe ndamfu muchikungu alukumba, mpawo uyobakkazika kukulya, mpawo uyoosika we azobakutawukile. ");
INSERT INTO dov_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Na mwami azosike mubusiku bwakulinda bwabili, na bwatatu, azobajane kabalindide, balilongezezegwe balanda aabo. ");
INSERT INTO dov_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aatala azeezi zyoonse, kansinga mwani ng'anda walizi buzuba mbwasika sikubba, taalikunoleka ng'anda yakwe kuti inyonyoonwe pe. ");
INSERT INTO dov_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Amulibambile anywebo, nkaambo tamulizi wola ndasika Mwana wa Muntu.” ");
INSERT INTO dov_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita wakati, “Mwami, ulikwaamba chikozyanisyo eechi kulindiswe atulike na kumuntu woonse?” ");
INSERT INTO dov_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Mwami wakati, “Ngwani mpo mweendelezi musongo awusyomekede ooyo mweendelezi wakwe ngwazobika kubalanda bakwe kuti abaabile chabo chimpanzi chakulyamuchiindi cheelede? ");
INSERT INTO dov_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ulilongezezegwe ooyo mulanda uyoojanika kachita oobo nayooboola mulanda wakwe. ");
INSERT INTO dov_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nchobeni ndamwaambila kuti uyoomupa bweendelezi kuzintu zyakwe zyoonse. ");
INSERT INTO dov_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pesi ooyo mulanda uti mumoyo wakwe, 'Mwani wangu wachedwa kuboola,' mpawo asangune kuuma balanda baalumi abanakazi, asangune kulya akunywa mpawo akolwe, ");
INSERT INTO dov_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mwami wayooyo mulanda uzoosika buzuba mbwatalangilide pe, amuwola ndyatayeeleli pe, uyoomugonkoola mpawo akamubikke kubusena bwabantu batasyomekede. ");
INSERT INTO dov_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ooyo mulanda, kali walimuzi mwami wakwe, alimwi katachitide na kumba mbuli mbayanda, uyoowumwa mfayindi nyiingi. ");
INSERT INTO dov_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pesi ooyo wakatezi, mpawo wachita zintu zyuumya, uyowumwa mfayindi nche. Woonse uupegwa zyiingi unolangilwa kupa zyiingi, ayooyo uusyomwa azyiingi, nzyiingi nzibayookumbila kuzwa kulinguwe. ");
INSERT INTO dov_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ndakasika kuzoowala mulilo aanyika, alimwi ndalikuyanda kut kansiinga zyachitika. ");
INSERT INTO dov_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pesi ndili aalubbabbatgizyo ndweelede ku bbabbatizigwa aalo, amachise ngelaawo mane kukamane! ");
INSERT INTO dov_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Muyeeya kuti ndakasika kuzoyeta luumuno na anyika? Pepe, ndamwaambila, pesi kwaanzana. ");
INSERT INTO dov_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nkaambo kuzwa lino kuyooba balimusanu mung'anda yomwe banzeene - batatu kabatamvwanani ababili, ababili kabatamvwanani abatatu. ");
INSERT INTO dov_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Banowanzeene, wisi katamvwanani amwana mulombe, amwana mulombe katamvwanani awisi; banyina kabatamvwanani amwana musimbi, amwana musimbi katamvwanani abanyina; banyianazyala kabatamvwanani amuka mwana, amukamwana katamvwanani abanyinazyala.” ");
INSERT INTO dov_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu wakaambula lubo kumakamu, “Na mwabona joba kalisimpa kububbila, mulafwaambana kwaamba kuti 'Yaamba kuwa mvula,' mpawo nga zyachitika. ");
INSERT INTO dov_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mpawo kwawunga guwo lizwida kumunsanza ngamwati sunu linoopya zuba,' mpawo zyachitika. ");
INSERT INTO dov_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Basikuupawupa, mulikwizi kumvwisisisya chiimo chanyika ajulu, pesi nkaambo nzi nimutakonzyi kumvwisisisya chiimo chachiindi chiliko lino? ");
INSERT INTO dov_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nkaambo nzi nimutakonzyi kulibonena zilikabotu amulike? ");
INSERT INTO dov_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nkaambo aawo nimuya kumutongi asinkondonyokwe, munzila amweezye kwaambula kabotu mumvwanane kuchitila kuti we tazokutoli kumubetesi, akuchitila kuti mubetesi atakakubiki mumaanza akapokola, mpawo kapokola atakakubiki muntolongo. ");
INSERT INTO dov_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ndati kulindinywe, taakwe notakazwe pe kuyosikila ukaman kubbadala mali yoonse iyandikana.” ");
INSERT INTO dov_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kuli eecho chiindi, bamwi bantu aawo bakamwaambila aatala abana Galilii aabo balaabulowa Payilate mbwakavwaangania azipayizyo zyabo. ");
INSERT INTO dov_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesu waskasandula wati kulimbabo, “Muyeeya kuti bana Galilii aaba mbibakali basizibi loko kwiinda kwiinda bamwi bana Galili na nkaambo kakupenzegwa kwabo ooku? Peepe, ndamwaambila. ");
INSERT INTO dov_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pesi kuti temwasanduka moonse muyofwidilila munzila njiyeeyo. ");
INSERT INTO dov_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nakuti aabo bantu balikumi lilamusanu abatatu baku Silowamu aabo bakawidwa bulambo bulamfu bwabajaya, muyeeya kuti bakali basizibi loko kwiinda bamwi baalumi mu Jelusalema? ");
INSERT INTO dov_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Peepe. Ndamwaambila. Pesi kuti temwasanduka, moonse muyoonyonyooka.” ");
INSERT INTO dov_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesu wakaluula chikozyanisyo eechi, “Umwi muntu wakaganka mukuyu muchilili chakwe chamasansa mpawo wakaboola kuzoolanga muchelo alinguwo pesi taakwe takawujana pe. ");
INSERT INTO dov_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mwaalumi wakati kuli sichilili, 'Langa, ndakasika minyaka iitatu nkelanga muchelo kumukuyu ooyu peesi taakwe nindakawujana pe. Ugonke. Nkaambo nzi kuuleka kunyonyoona nyika? ");
INSERT INTO dov_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sichilili wakasandula wati, 'Uleke uuno munyaka ndiwusyide mumbali ndiwubike mbolezi. ");
INSERT INTO dov_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kuti wazozyala muchelo mumnyaka uuboola sambubo, pesi kuti kuutazyede lubo, uzowugonka!” ");
INSERT INTO dov_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lino Jesu wakalikuyiisya kulichimwi chikombelo mubuzuba bwa Sabata. ");
INSERT INTO dov_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Amubone, kwali mwanakazi wakali amuuya mubi wakubula nguzu kwamyaaka kkumi lilamusanu ayitatu alimwi wakali vundeme nkaambo taakali kukonzya pe kwiimikila kabotu. ");
INSERT INTO dov_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aawo Jesu naakamubona, wakamwiita wati, “Yoomwanakazi, waponesegwa kuchilwazi chako chakubula nguzu.” ");
INSERT INTO dov_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Wakabikka maanza aakwe aalinguwe mpawaawo wakavundamuka akwiima kabotu mpawo wakalumbayi Leza. ");
INSERT INTO dov_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pesi mweendelezyi wachikombelo wakanyema nkaambo Jesu wakamuponia mubuzuba bwa Sabata. Mpawo mweendelezi wakasandula akwaambila nkau yabantu kuti, “Kuli mazuba musanu alimwi ayelede kubeleka mulingawo. Amusike musikwe mumazuba aayo pepe mubuzuba bwa Sabata.” ");
INSERT INTO dov_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mwami wakamusandula wati, “Nubawupuupi! Tawo na uunga waangununa donki na ng'ombe yakwe kuzwa mubbondo akwiitola kuyonywa maanzi mubuzuba bwa Sabata? ");
INSERT INTO dov_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ooyu alakwe mwana wa Abbulahamu, ooyo Satani ngwaakangide kwaminyaka iilikumi lilamusanu ayitatu, tayelede na kuti bwaange bwakwe bwaangununwe mubuzuba bwa Sabata ");
INSERT INTO dov_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Naakali kwaamba zintu eezi, boonse aabo bakali kukazyania aawe bakawusa, pesi nkamu yabantu yakabotela aatala azyoonse zibotu nzyakachita ");
INSERT INTO dov_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Mpawo Jesu wakati, “Bwami bwa Leza buli biyeni, alubo ndikonzya lkubukozyanisya anyamaanzi? ");
INSERT INTO dov_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bulimbuli nseke yamusitadi eeyo muntu njaakabweza wakwiiminza muchilili chakwe, yakakomena yaba musamu mupati, mpawo tuyuni twayaka zizubo zyato amitabi yawo.” ");
INSERT INTO dov_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Alubo wakati, “Niinzi nchindikonzya kukozyanisya bwami bwa Leza? ");
INSERT INTO dov_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bukozyenie aabusweezyo bwakabwezegwa amwanakazi wabuvwelengania mumyeelwe iitatu yabusu, mpawo bwafuta boonse.” ");
INSERT INTO dov_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mpawo Jesu waswayila madolopo amyuunzi akuyabubayiisya we kayabutozya ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Umwi wakati kulinguwe, “Mwami, mbache biyo na beelede kuyofutulwa?” Wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Muzumanane kuyoonjila mukalyango kamanikide, nkaambo ndamwaambila nywebo, biingi bayoyezya kunjila pesi tabakoyokonzya pe. ");
INSERT INTO dov_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Naakubuka akujala mulyango mwani ng'anda, aawo muyoyimikila aanze kamukonkomona mulyango kamuti, 'Mwami, Mwami, tujulile tunjile.' Uyoomusandula akatedi kulondinywe, 'Nsimwizi pe nakuti mwazwida kuli.' ");
INSERT INTO dov_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mpawo muyosandula kamuti, 'Twakalya akunywa kunembo lyako, mpawo wakayiisya mumigwagwa yesu.' ");
INSERT INTO dov_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pesi we uyoosandula kati, 'Ndati kulindinywe, nsimwizi pe nkumuzwa. Amuzwe kulindime nywebo nobasizibi!' ");
INSERT INTO dov_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kuyooba kulila akuluma ntwino aawo nimuyoobona Abbulahamu, Ayizeki, Jakobo abamwi boonse basinsimi mubwami bwa Leza, pesi nywe - muyosowelwa aanze. ");
INSERT INTO dov_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bayoozwa kumbo, kujwe, kumusanza akunyika bazokkale atafula mubwami bwa Leza. ");
INSERT INTO dov_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mpawo amuchizibe eechi, bakumamanino mbibayoba bakusanguna, mpawo bakusanguna bayooba bakumamanino.” ");
INSERT INTO dov_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Musule buniini achiindi eecho, bamwi ba Falisi bakasika bati kulinguwe, “Chija uzwe omuno uyende nkaambo Heloda uyanda kukujaya.” ");
INSERT INTO dov_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesu wakati, “Amukamwaambili ooyo mwaalumi kuti, 'Langa, ndiyabugwisya myuuya mibi akusilika bachiswa sunu ajuunza mpawo zoona ndinooli ndasisya makanze aangu.' ");
INSERT INTO dov_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amuliili nzila, kuleelede kuti ndiinkile kunembo sunu, juunza, azoona nkaambo tazitambuliki pe kujaya munsimi katamo mu Jelusalema. ");
INSERT INTO dov_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jelusalema, Jelusama, webo nojaya basinsimi akutulula aabo bakakutuma. Ndiyandisya loko kubungania bana bako mbuli nseke mbiifukatila bana bayo munsi lyamababa aayo, pesi webo tewakaziyanda pe eezi. ");
INSERT INTO dov_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Langa, ng'anda yako yasiigwa. Ndati kulinduwe, tokoyondibona pe mane ukatedi, “Ulaachoolwe ooyo uuza muzina lya Mwami.'” ");
INSERT INTO dov_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zyakachitika bumwi buzuba bwa Sabata aawo nakanjila mung'anda yawumwi mu Falisi kuti alye chinkwa, alimwi bakamulangisisya. ");
INSERT INTO dov_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Amulange, kunembo lyakwe kwakali mwaalumi wakalikuchiswa bulwazi bwaku zimba. ");
INSERT INTO dov_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu wakabuzya kulibasi busongo bamulawu waba Juda wakati, “Chilimumu lawu na kuponia mubuzuba bwa Sabata, nape? ");
INSERT INTO dov_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pesi bakawumuna. Aboobo Jesu wakamujata, wamuponia, mpawo wamuti ayende. Wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","“Ngwani aakati kenu ulaamwana mulombe na ng'ombe iinga kuti iyawida mudindi mubuzuba bwa Sabata takofwaambana kuyoyigwisya?” ");
INSERT INTO dov_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bakakachilwa kumusandula kulizeezi zintu. ");
INSERT INTO dov_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesu naakabona kuti nzila aabo bakatambidwe njibakali kusala aayo zyuuno zyabulemu, wakaambula chikozyanisyo, wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Na kotambidwe kupobwe lyalukwatano, utalikaziki kuchuuno chabulemu nkaambo kulakonzeka umwi mulemu kwiindwa nduwe ulitambidwe. ");
INSERT INTO dov_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Naayosika ooyo wamutamba mobile ulati, 'Nyampuka upe ooyu chuuno chako,' mpawo mubweeme uyoonyampuka ukakkale achuuno chitakwe bulemu. ");
INSERT INTO dov_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pesi nakuti watambwa, yinka ukakkale muchuuno chilaansi mubusena bulaansi, kuchitila kuti nasika sikukutamba akwaambile kuti, 'Mwenzuma yinka kujulu.' Aboobo ulapegwa bulemu mumenso aboonse mbokkede aabo aatafula. ");
INSERT INTO dov_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nkaammbo woonse uulisumpula uyoofwiinsigwa, ayooyo ulifwiinsya uyoomsumpulwa.” ");
INSERT INTO dov_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Alimwi Jesou wakati kuli ooyo wakamutabide, “Na wapa chisusulo na chilalilo, utatambi beenzinyokwe, nabanakwanu, na basimayakilane bako bavubide, nkaambo ayebo bazokutamba lubo mpayo uyoojana kubbadalwa. ");
INSERT INTO dov_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pesi kuti wachita pobwe, tamba bachete, batyokede, balemene aboofu, ");
INSERT INTO dov_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","mpawo uyoolongezegwa, nkaambo tabakonzyi kukubbadala pe. Uyoobbadalwa kububuke bwabalule.” ");
INSERT INTO dov_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aawo umwi wabaabo bakakkede anguwe aatafula naakamvwa zintu eezi, wakamwaambila kuti, “Ulilongezezegwe ooyo uutakalye chinkwa mu bwami bwa Leza!” ");
INSERT INTO dov_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pesi Jesu wakati kulinguwe, “Umwi mwaalumi wakabaambiila chilalilo mpawo wakatamba biingi. ");
INSERT INTO dov_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kuchiindi chachilalilo wakatuma mubelesi kuti akatedi kuli bakatambidwe, 'Amusike nkaambo zyoonse zyaba kabotu.' ");
INSERT INTO dov_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Alimwi boonse bakatalika bukozyenie kubikka zikumbizyo. Mutaanzi wakati, 'Nawula muunda, aboobo ndeelede kuyowubona, nche nsilibambilide pe.' ");
INSERT INTO dov_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Umbi wakati 'Ndakawula zipani zyabasune zilimusanu, aboobo ndiya kukubasa, nche nsilibambilide pe.' ");
INSERT INTO dov_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Uumbi alakwe wakati, 'Ndakakwata mwanakazi, ndaabwiinga aboobo nsikonzyi pe kusika.' ");
INSERT INTO dov_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mubelesi wakaboola akwaambila simalelo wakwe eezi zintu. Mpawo simalelo wang'anda wakanyema akwaambila mubelesi wakwe kuti, 'Yinka chakufwambaana aanze mumigwagwa amutuzila twamu dolopo, ukeete bafwaba, batyokede, boofu abalemene. ");
INSERT INTO dov_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mubelesi wakati 'Simalelo, nzuwalayilide zyachitwa, pesi mpubuchili busena.' ");
INSERT INTO dov_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Simalelo wakati kumubelesi, 'Koya mumazila mapati amumubaya ukabakombelezye kuti basike, amwi ng'anda yangu yalikunoozula. ");
INSERT INTO dov_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nkaambo ndati kulinduwe, tawo naba omwe wabaaba baalumi mbindatambide uyoolabila chakulya changu.'” ");
INSERT INTO dov_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lino makamu aabantu akayinka aawe, lino wakabachebuka wati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Na muntu waza kulindime, katasuli wisi, banyina, banakwe, bana bakwe banabakwabo abachizi bakwe, - iyii, abuumwi bwakwe - takonzyi pe kuba sikwiiya wangu. ");
INSERT INTO dov_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kufumbwa uutabwezi chiingano chakwe takonzyi pe kuba soikwiiya wangu. ");
INSERT INTO dov_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nkambo awumwi wenu ooyo uyeeya kuyaka bulambo, taakwe nanga wakkala aansi kuti abale nanka ulaazyo zyoonse ziyandikana kuti ayake? ");
INSERT INTO dov_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pesi na wasya ntalisyo yakwe mpawo wazokachilwa kumaninsya, woonse unoolanga unomuseka, ");
INSERT INTO dov_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kati, 'Ooyu mwaalumi wakasanguna kuyaka pesi wakakachilwa kumaninsya.' ");
INSERT INTO dov_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nakuti ngwani mwami, uunga nayanda kuyolwana awumbi mwami, takookkala aansi ayandule mizeezo yakumugwasya kuti ulakonzya kumulwana kali aabasikulwana zyuulu zilikumi ooyo ngwalwana aawe kali aabasikulwana zyuulu makumi aabili? ");
INSERT INTO dov_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Akuti nape, na imwi nkamu yabasinkondonyina kiichili kule, tatumi na sing'enda kuti akatule amjwi aluumuno. ");
INSERT INTO dov_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Aboobo woonse utatakati zyoonse nzyali aazyo takonzyi pe kuba sikwiiya wangu. ");
INSERT INTO dov_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mwinyo mubotu, pesi kuti mwinyo wamana kulweela nga ulabweedezegwa biyeni kuti ulweele lubo? ");
INSERT INTO dov_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tuuchikwe nchuuchibeleka naa akumuse naa manyowa. Ulasowegwa. Ooyo uulamatwi akumvwa, ngamvwe.” ");
INSERT INTO dov_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Loino boonse basimutelo abamwi basizibi bakalikuza kuzoswiilizya Jesu. ");
INSERT INTO dov_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bloonse baFalisi abalembi bakatongooka chabo chabo, kabaamba kuti, “Ooyu mwaalumi ulatambula basizibi, alimwi ulalya ambabo.” ");
INSERT INTO dov_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesu wakabaambila chikozyanisyo eechi, wakati, ");
INSERT INTO dov_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ngwani aakati kenu uunga ulaba aambelele zilimwaanda mpawo yomwe yasweekwa, aleke kusiya zili makumi musanu amakumi one alamusanu azine mulusaka, akuya kukuyanduula yomwe mane akayibone? ");
INSERT INTO dov_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Mpawo nayijana uyooyipika aamakuko akubotelwa ");
INSERT INTO dov_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Naaboola kumuunzi wiita benziinyina ambayakilene aabo, akubaambila kuti, 'Amubotelwe antoomwe andime, nkaambo ndayibona mbelele yangu yakasweekede.' ");
INSERT INTO dov_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ndiliikumwaambila kuti nikuba boobo, kuyooba lukondo kujulu aatala asizibi omwe wasanduka, kwiinda aabo balimakumi miusanu amakumi one alamusanu abane basandukide kale. ");
INSERT INTO dov_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nakuti ngwani wachikayintu ulangodo zya siliva zilikumi, kuti kwasweeka yomwe, uunga ulaleka kumunika, kuyiila ng'anda akuyanduula loko mane akiijane? ");
INSERT INTO dov_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nayijana ulayita beenzinyina ambayakilene aabo kaamba kuti, 'Amuboole tubotelwe nkaambo ndayibona nsiliva yandisweekede.' ");
INSERT INTO dov_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nikuba boobo ndikumwaambila kuti kuli kukondwa kunembo lyabangelo ba Leza aatala asizibi omwe uusanduka.” ");
INSERT INTO dov_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Mpawo Jesu wakati, “Kwakali mwaalumi wakali aabana balombe babili, ");
INSERT INTO dov_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","aawo mwana muniini wakati kuli wisi, “Ndeende, ndipe buvubi mumweelwe uulangene aandime.” Mpawo wakaaba buvubi aakati kabo. ");
INSERT INTO dov_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kakutanayiknda mazuba miingi, mwana muniini wakabungania buvubi bwakwe wiinka aabo kunyika iilikule ooko wakakunyonyoona buvubi bwakwe mukupana bunjaka. ");
INSERT INTO dov_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Lino nakamaninsya zyoonse kwakaba nzala mpati munyika yoonse, mpawo wakatalika kubula. ");
INSERT INTO dov_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wakayinka kuyolipeda kubelekela umwi wabantu bamuchisi eecho, wakakumutuma kusanina ngulube mumuunda wakwe. ");
INSERT INTO dov_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wakalikunoonga wajana kukondwa naalya tukuli twakali kuligwa ngulube nkaambo taakwe wakalikumupa chakulya. ");
INSERT INTO dov_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mpawo aawo mwana muniini ooyu nakaboola kumizeezo yakwe, wakati, 'Mbangane babelesi ba ndeende balikulya chakulya chizulila, mpawo me ndaano ndikufwa aanzala! ");
INSERT INTO dov_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ndilanyampuka aano ndiye kuli ndeende ndikatedi, “Ndeende ndakabisizya julu anduwe. ");
INSERT INTO dov_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nsichikwe bulemu bwakwiitwa kuti mndimwana wako; ndichite kuti ndibe uumwi wanbabelesi bako.'” ");
INSERT INTO dov_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mpawo mwana miniini ooyo wakazwa kunyika nkwaakabede waboola kuli wisi. Aawo naakachili kulele kule alimwi wisi wakamubona wabotelwa, walkachijaana, wakumumbungatila akumumyonta. ");
INSERT INTO dov_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Mwana wakati kuli nguwe, 'Ndeende, ndakabisizya julu anduwe, nsichikwe bulemu bwakwiitwa kuti ndili mwana wako.' ");
INSERT INTO dov_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wisi wakati kubabelesi bakwe, 'Mufwambaamne mwee te jansi bbotu kwiindilila, mumusasike, alimwi mubikke nweenwe kukuboko kwakwe, ansangu kumawulu aakwe. ");
INSERT INTO dov_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mpawo mweete mwana wan'gombe uneneede mumujaye. Atupobole tubotelwe! ");
INSERT INTO dov_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nkaambo mwana wangu wakalisweekede, lino waboneka.' Mpawo bakatalika kubotelwa ");
INSERT INTO dov_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Lino mwana wakwe mupati wakachili kumuunda. Aawo naakaboola akusika afwiifwi amuunzi, wakamvwa miimbo akuzyana. ");
INSERT INTO dov_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wakayita umwi mubelesi wabuzya kuti zyaambanzi eezi. ");
INSERT INTO dov_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mubelesi wakamwaambila kuti, 'Mwanike wako waboola kumuunzi alimwi wuso wajaya mwana wang'ombe uuneneede nkaambo waboola kali muumi.' ");
INSERT INTO dov_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mwana mupati wakanyema alimwi taakanjila pe mukati, wisi wakazwa aanze, kuzo mukombelezya. ");
INSERT INTO dov_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pesi mwana mupati wakasandula wisi wati, “Langa, eeyi minyaka myiingi yoonse ndakubelekela chabuzike, alimwi taakwe nindakatyola nuuba omwe mulawu wako, pesi taakwe nwakandipa mwana wampongo kuti ndibotelwe abeenzuma. ");
INSERT INTO dov_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pesi mbaboola, ooyo wakakulya lubono lwako abasi bwaamu, wamujiila mwana wangombe uneneede.' ");
INSERT INTO dov_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wisi wakamusandula kuti, “Mwanaangu ukkede koli aandime chiindi choonse, alimwi choonse changu nchichako. ");
INSERT INTO dov_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pesi chali chibotu kuti tubotelwe nkaambo mwanike wako ooyu wakalifwide; lino wapona; wakali sweekede alimwi waboneka.'” ");
INSERT INTO dov_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Alubo Jesu wakati kuli basikwiiya bakwe, “Kwalkali mwaalumi wakali muvubi, alimwi wakali aasilutwe wakwe, alimwi wakaambilwa kuti silutwe uli tatuula lwakwe. ");
INSERT INTO dov_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aboobo muvubi wakamwiita silutwe wakwe wati kulinguwe, 'Niinzi eezi nzindiikumvwa aatala anduwe? Pa bupanduluzi aatala abusilutwe bwako, nkaambo tocheelede pe kuba silutwe wangu.' ");
INSERT INTO dov_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pesi silutwe wakati mukaango kakwe, 'Ndichite biyeni, mbukunga simalelo wangu uyanda kunditolela buslutwe bwa mulimu wangu? Nsikwe manguzu pe aakusya alubo kulandipa nsoni kuyabukumbila. ");
INSERT INTO dov_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ndaziba kuti ndichite biuyeni, kuchitila kuti ndatandwa kuba siltwe bantu banditambule mumaanda aabo.' ");
INSERT INTO dov_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Mpawo silutwe wakiita bantu boonse bakali aazikwelete zyasimalelo wakwe, wakabuzya kuli wakusanguna wati, 'Ukweletede nzi kuli simalelo wangu?' ");
INSERT INTO dov_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wakati, 'Mwaanda wansazi zyamafuta aa oliva.' Mpawo wakati kulinguwe, 'Bwaza lugwalo lwako chakfwaambaana ulembe kuti makumi osanwe.' ");
INSERT INTO dov_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mpawo silutwe wakati kuli umbi, 'Niinzi nchokweletede?' Wakati, 'Mwaanda wazyeelelelo zyamayila.' Wakati, 'Bweza lugwalo lwako, ulembe kuti makumi musanu amakumi otatwe.' ");
INSERT INTO dov_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Simalelo wakabotelwa asilutwe ooyu nkaambo wakachita anzila iitaluleme. Nkaambo bana banyika iino tabaluleme pe mukubeleka abananyina kwiinda mbubali bana ba mumuni. ");
INSERT INTO dov_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ndati kulindinywe, amulipangile bazolwani amali iitaluleme, kuchitila kuti niyoomana, bakamutambule mubuumi butamani. ");
INSERT INTO dov_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ooyo uusyomekede muziniini ulizyomekede amuzipati, ayooyo uutasyomekede muziniini tasyomekede pe muzipati. ");
INSERT INTO dov_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Na tewasyomekede mukubelesya mali yabubi, ngwani uutakusyome abuvubi banchoonzyo? ");
INSERT INTO dov_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Alimwi na tewasyomekede mukubelesya mali yabamwi, ngwani uutakupe yako mali? ");
INSERT INTO dov_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Taakwe mulanda uunga ulabelekela basimalelo babili, nkaambo ulakonzya kuyanda umwi atayandi umwi, na kulipeda kuli umwi alangile aansi umwi. Tokonzyi pe kuyanda Leza abuvubi.” ");
INSERT INTO dov_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lino ba Falisi bakalikuyandisya mali nibakamvwa eezi zintu bakamunyanyansya. ");
INSERT INTO dov_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Mpawo wakati kulimbabo, “Mulalilulamika kunembo lyabantu, pesi Leza uliizi myoyo yenu. Eecho chisumpulwa loko aakati kabantu tachikbotezyi pe kunembo lya Leza. ");
INSERT INTO dov_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mulawu abasinsimi bakabeleka kuyoosika muchiindi chakusika kwa Joni. Kuzwa aawo, jwi lya bwami bwa Leza lilikukambawukwa, mpawo woonse muntu ulikweezya kunjila. ");
INSERT INTO dov_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pesi nchuuba kuti julu anyika zyiinde kwiinda kuti kamwi kabala kamulawu kakachale kakatakwe nguzu. ");
INSERT INTO dov_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Umwi awumwi uuleka mwanakazi wakwe akukwata umbi wachita mamambe, ayooyo ukwata mwanakazi wakalekwa wachita mamambe. ");
INSERT INTO dov_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Lino kwakali umwi mwaalumi muvubi wakali kukkala kazweete zizwaato zyamubala wantumbula zibotu alimwi wakalikubotelwa lubbe abuvubi bwakwe bupati. ");
INSERT INTO dov_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Umwi sikukumbila wakalikutegwa Lazalo wakali kubikwa kumulyango wakwe, wakazwide zilonda, ");
INSERT INTO dov_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","wakalikukumbila biyo chakulya eecho chakali kuloka aatafula yamuvubi - kunze kwazeezyo bankala bakalikusika kuzomyanguta zilonda zyakwe. ");
INSERT INTO dov_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Chakachitika kuti sikukumbila wakafwa mpawo wakabwezwa abangelo wakukkazikwa kubbazu lya Abbulahamu. Muvubi wakafwa alakwe mpawo wakavwikkwa, ");
INSERT INTO dov_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","mpawo kali mu Hadesi kali koomba, wakanyampula menso aakwe walanga kujulu wakabona Abbulahamu kali kule a Lazalo kali akaango kakwe. ");
INSERT INTO dov_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mpawo wakakwiila wati, 'Taata Abbulahamu, ndifwide nsoni utume Lazalo, kuti akanike gala lyakanwe kakwe mumaanzi azootontozye lulimi lwangu, nkaambo ndapengaana mumulilo ooyu. ");
INSERT INTO dov_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pesi Abbulahamu wakati, 'Mwanangu, yeeya kuti muchiindi chakupona kwako wakatambula zintu zyako zibotu, alakwe Lazalo zibi. Pesi lino pwajana kulyookezya ookuno iwe wanjila mumapenzi. ");
INSERT INTO dov_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Alimwi kunze kwazeezi, kulimugaano mupati uubikidwe aawa, chakuti ooyo uuyanda kutaaluka kazwa ookuno kaza ooko takokonzya pe, ayooyo uuyanda kutaluka kazwa ooko kaza ookuno takookonzya pe.' ");
INSERT INTO dov_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mwaalumi muvubi wakati, 'Ndakukumbila, Taata Abbulahamu, kuti umutume kung'anda yandeende - ");
INSERT INTO dov_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nkaambo ndili aabana bakwesu balimusanu - kuti akabaambile, nkaambo ndiyoowa kuti abalabo bazooza okuno kubusena bwakupengaana.' ");
INSERT INTO dov_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pesi Abbulahamu wakati, 'Bali a Mozesi abasinsimi; ababaswiilile.' ");
INSERT INTO dov_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Wakasandula mwaalumi muvubi wati, 'Pe, Taata Abbulahamu, pesi kuti kwayinka muntu wabka kubafu bayoosyoma, bayosanduka.' ");
INSERT INTO dov_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pesi Abbulahamu wakati, 'Na kabatamuswiilili Mozesi abasinsimi, taakwe nibanga balamuswiilila ayooyo unooli wabuka kubafu.'” ");
INSERT INTO dov_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesu wakati kulibasikwiiya bakwe, “Ninchobeni kuti kuloba zilebyo, pesi maawe kuliyoyo muzitakiinde mulinguwe! ");
INSERT INTO dov_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kuyoba mbubo kuti ziyo likaangwe munsingo yakwe alimwi akawaalwe mulwizi, kwiiknda kuti akeetelezya aaba banini kuti bakachite zibi. ");
INSERT INTO dov_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Amulilange nyweebo nobeni. Kuti mweenzinyokwe wabisya, amumukalalile, na wasanduka amumulekelele. ");
INSERT INTO dov_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na wakubisizya tuli musanu atubili abuzuba mpawo kalikuboola kulinduwe tulimusanu atubili, kaamba kuti, 'Ndasanduka,' weelede kumulekelela.” ");
INSERT INTO dov_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Batumwa bakati ku Mwami, “Koyungizya lusyomo lwesu.” ");
INSERT INTO dov_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mwami wakati, “Kansinga mwali aalusyomo luniini mbuli nseke yamusitada, mwalikunoti kulooyu musamu wamulubbeni, 'Konyukuka alimwi ukabyalwe mulwizi,' wali kunoomuswiilizya. ");
INSERT INTO dov_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Pesi ngwani wenu uulamulanda uulima na uyembela mbelele, uwamba kuti kulinguwe elyo kanoli wasika kuzwa kumuunda, 'Sika lino ukkale aansi ulye'? ");
INSERT INTO dov_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Takoowamba na kuti, 'Ndibambila chakulya ndily, uwange lukumba kuzizwaato zyako mpawo undikutawukile mane ndimane kulya akunya. Ndamaninsya notazoolye akunywa webo'? ");
INSERT INTO dov_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tamulumbi pe mulanda nkaambo wamuchitila nzyamutuma, ulamulumba na? ");
INSERT INTO dov_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Akulindinywe mbukubede, na mwachita zyoonse nzimwatumwa, mweelede kuti “Tuli balanda bateelede pe, twachita biyo nzitweelede kuchita.” ");
INSERT INTO dov_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kwakasika kuti kachiyobweenda kaya ku Jelusalema, wakalikuyabwiinda mumugaano wa Samaliya a Galili. ");
INSERT INTO dov_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naakanjila mulilimwi gunzi, ooko wakatambulwa abamwi baalumi balikumi bakali aachipele. Bakiimina kule anguwe ");
INSERT INTO dov_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mpawo bakasumpula majwi aabo, bakati, Jesu, Mwami ba aluse kulindiswe.” ");
INSERT INTO dov_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Naakababona, wakati kulimbabo, “Amwiinke mukalitondeezye kubapayizi.” Mpawo chakachitika kuti nibakali kuyabwiinka bakasalazigwa. ");
INSERT INTO dov_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Umwi wabo naakabona kuti wakali waponesegwa, wakabweeda musule, ajwi pati kayabulumbayizya Leza. ");
INSERT INTO dov_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wakafugama kumawulu aa Jesu akumupa kulumba. wakali mu Samaliya ");
INSERT INTO dov_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu naakasandula, wakati, “teensi balikumi na basalazigwa? Balikuli bamwi musanu abane? ");
INSERT INTO dov_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tekwalikwe na bamwi beelede kuboola kuzopa bulemu kuli Leza kwiinda ooyu muzwamasi?” ");
INSERT INTO dov_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wwakati kulinguwe, “Nyampuka weende. Lusyomo lwako lwakuponia.” ");
INSERT INTO dov_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Naakabuzigwa aba Falisi kuti bwami bwa Leza buyoosika lili, Jesu wakabasandula watgi, “Bwami bwa Leza tabusiki aakubulangisisya. ");
INSERT INTO dov_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nakuti nimuyoomvwa kakutgwa, 'Amulange mbobu!, na 'Amulange mbobuya!', nkaambo amulange bwami bwa Leza buli mulindinywe.” ");
INSERT INTO dov_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wakati kuli basikwiiya bakwe, “Ayoosika mazuba ngimuykoolombozya kubona buzuba bomwe bwaMwana wa Muntu pesi tamukoyoobubona pe. ");
INSERT INTO dov_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mpawo bayoti kulindinywe, 'Amulange, aano! Amulange, okuya!' Pesi tamukazwi pe kukuyobatobela, ");
INSERT INTO dov_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","mbuli kalabi mbukamweka chakumunika kuzwa kulilimwi bbazu lya julu kakaboneka kulilimbi bbazu, mbatakabe alakwe Mwana wa Muntu mubuzuba bwakwe. ");
INSERT INTO dov_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pesi weelede kusyonsegwa kuzintu zyhiingi akukakwa aleeli zyalane. ");
INSERT INTO dov_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mbuli muzyakachitika kumazuba aa Noah, ziyoochitika mumazuba aa Mwana wa Muntu. ");
INSERT INTO dov_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bakali kulya, bakali kunywa, bakali kukwata, bakali kukwatwa, kuyoosika buunsi Noah mbwakanjila mubwaato - mpawo zaambangulwe lyakasika akubanyonyoona boonse. ");
INSERT INTO dov_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ambubo mbuli mbuzyakachitika kumazuba aa Lot, bakali kulya, bakalikunywa, bakali kuula, bakali kuuzya, bakalikubyala akuyaka. ");
INSERT INTO dov_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pesi mubuzuba Lot mbwaakazwa mu Sodomu, kwakawa mulilo wa salufa kuzwa kujulu wabanyonyoona boonse. ");
INSERT INTO dov_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Munzila njiyeeyo mbukutakabe mubuzuba bwa Mwana wa Muntu nataka yubununwe. ");
INSERT INTO dov_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mubuzuba oobo tamukaleeki ooyo uli aakaluli kang'anda kuti akaselele akeezye kugwisizya aanze zintu zyakwe zili mung'anda. Alubo tamukamuleki ulikumunda akaboole. ");
INSERT INTO dov_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Amuyeye mukayintu wa Lot. ");
INSERT INTO dov_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ooyo weezya kutabilila buumi bwakwe bulamuswekela pesi ooyo usweekelwa buumi bwakwe ulabubamba. ");
INSERT INTO dov_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ndamwaambila, muli oobo buzuba kunooli bantu babili aabulo, umwi uyoobwezwa, mpawo umwi uyoochala. ");
INSERT INTO dov_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kunooli banakazi babili balikutwa antoomwe. Umwi uykoobwezwa, umwi uyoochaala. - Muli Luka 17: 36, Malembe mabotu aachiindi taakwe munchali 36 pe. ");
INSERT INTO dov_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kuyooba babili mumuunda, umwi uyoobwezwa umwi uyochaala. Bakamubuzya bati, “Ikuli, Mwami?” Mpawo wakati kulimbabo, “Aawo aanoli chidumbu, aawo makubi ayoobungana antoomwe.” ");
INSERT INTO dov_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bakamubuzya kuti, “Nkokuli Mwami?” Wakati kuli mbabo, “Oko kuli mutunta, nkonkuko kuyobungana makubi antomwe.” ");
INSERT INTO dov_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Lino nakabambila chikozyano chitondezya mbubeelede kunokomba akuti batatyoki myoyo, ");
INSERT INTO dov_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","wati, “Muli limwi dopolo kwakali mubetesi utakwe wakalikuyowa Leza nikuba kulemeka bantu. ");
INSERT INTO dov_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Lino kwakali mukamufu mudolopo eli, wakaliswini kaza kulinguwe, kati, 'Mundigwasizye makani angu asimulanduma'. ");
INSERT INTO dov_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lino wakaba achindi chilamfu katalikuyanda kumugasizya, pesi nikwakaba kayindi, wakalyambuuzya alikke wati, “Nikuba ngundilemeka, ");
INSERT INTO dov_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pesi mukamufu oyu wandikatazya, ndilamugwasizya kuti ajane lwangunuko kumakani akwe, kwiitila kuti atandisusubiki, kanoswini kandichindila”. ");
INSERT INTO dov_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mpawo Mwami wakati, “Muswilizye mbaamba mubetesi oyu siluuni”. ");
INSERT INTO dov_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Lino muyeeye kuti, Leza takonzyi na kubeteka chabululami kubsale bakwe, ibamulilila sikati amansiku? Ulachedwa na kubkutukila? ");
INSERT INTO dov_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","“Ndamwambila kuti, uyofwambana loko kulingula makani abo. Nikuba obo, nazobweda Mwana mulombe wa Muntu uzojana kakuchili lusyomo na munyika?” ");
INSERT INTO dov_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Elyo wakamba mukozyano oyu utobela kuli bamwi bakali kulisyom beni kuti baliluleme, abo bakali kunyansya bamwi, ");
INSERT INTO dov_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Baluumi babili bakaya mun'anda yaLeza kuyookomba- umwi wakali muFalisi oyu umwi kali Simutelo. ");
INSERT INTO dov_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","MuFalisi wakayimikila wakomba kaamba zintu ezi atala lyabuumi bwakwe wati, 'Leza, ndilakulumba nkambo kakuti tandili mbuli bamwi pe babbi, bantu bataluleme pe, basibwamu, na bali mbuli Simutelo oyu. ");
INSERT INTO dov_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ndilalyiimya tubili amviki. Ndilapa chipanzi chakkumi chazintu zyoonse nzindijana'. ");
INSERT INTO dov_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pesi Simutelo, kayimvwi kulekule, tewakakonzya pe nikuba kusompya meso akwe kujulu, pesi wakawuma akaango kakwe wati, 'Leza, ndifwide luzyalo, me ndisizibi'. ");
INSERT INTO dov_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ndamwambila kuti oyu mwalumi wakajoka kun'anda yakwe kali walulamikwa kwiinda olya mweenzinyina, nkambo kufumbwa muntu ulisumpula uzofwinsigwa, pesi woonse muntu ulijosya ansi uzosumpulwa”. ");
INSERT INTO dov_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bantu bakeeta bana banini kulinguwe kuti abaampe, pesi basikwiiya nibakababona bakabaambwiida. ");
INSERT INTO dov_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pesi Jesu wakabayita kulinguwe wati, “Muzumizye bana banini baze kuindime, alubo mutabakasyim pe. Nkambo bwami bwakujulu mbubwabo. ");
INSERT INTO dov_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kasimpe ndamwambila, utakonzyi kutambula bwami bwaLeza mbuli mwana munini takwe kuyobunjila”. ");
INSERT INTO dov_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Umwi mwendelezi wakamubuzya wati, “Muyisi mubotu, ngandilachita biyeni kuti ndikajane buumi butamani?” ");
INSERT INTO dov_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu wakati kulinguwe, “Nkamboonzinundaamba kuti ndilimubotu? Takwe muntu mubotu pe, kunze kwaLeza alikke. ");
INSERT INTO dov_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ulizi milawu yaamba kuti utachiti bwaamu, utajeyi, utabbi, utaambi manwa, lemeka uso abanyoko”. ");
INSERT INTO dov_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mweendelezi wakati, “Yoonse eyi ndakayilondola kuzwa kandichili mulombe”. ");
INSERT INTO dov_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Lino Jesu nakamvwa obo, wakati kulinguwe, “Kuli chinti chimwi nchubulide. Weelede kuzya zintu zyoonse nzulaazyo mpawo wabila bachete, elyo uyooba achiybwedo chalubono kujulu mpawo uze unditobele”. ");
INSERT INTO dov_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lino mweendelezi oyu nakamvwa makani aya, wakawusa, nkambo wakali alubono lwiingi. ");
INSERT INTO dov_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Elyo Jesu nakabona kuti wawusa loko wakati, “Nchiyumu loko kuli abo bajisi lubono lwiingi kunjila mubwami bwakujulu! ");
INSERT INTO dov_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nkambo chilakonzeka kuti nkamela yiinde mumpuli yansunda kwiinda kuti muntu muvubi anjile mubwami bwaLeza”. ");
INSERT INTO dov_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abo ibakamvwa makani aya bakati, “No mwati sa mpali unga uyofutulwa?” ");
INSERT INTO dov_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu wakamwambila wati,” Zintu ziyumu kubantu nzyuuba kuliLeza.” ");
INSERT INTO dov_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita wakati, “Langa twakasiya zintu zyesu zyoonse mpawo twatobela nduwe”. ");
INSERT INTO dov_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu wakati kulimbabo, “Ndamwambila kasimpe kuti takwe muntu naba umwi wakasiya n'anda yakwe, naba banakazi bakwe, na banike bakwe, na bazyali, na bana nkambo kabwami bwaLeza, ");
INSERT INTO dov_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","utakwe kuzojana zyindilide kuchiindi echino, amuchindi chibola, buumi butamani.” ");
INSERT INTO dov_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nakamaninsya kubunganizya bali kkumi ababili kulinguw, wakati kulimbabo, “Mulange tuya kuJelusalema, lino zyoonse zintu zyakalembwa abasinsimi atala a Mwana mulombe wa Muntu ziya kuyozuzikizigwa”. ");
INSERT INTO dov_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nkambo uyopenzegwa mumaboko Bamasi, mpawo bayomuwela, uyojatwa chamasampu, mpawo bakamuswide mate. ");
INSERT INTO dov_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nibayomaninsya kumuuma, bayomujeya, mpawo mubuzuba bwatatu uyobuka lubo.” ");
INSERT INTO dov_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Takwe nchibakamvwa pe kumakani aya, alubo eli lyakabasita, mpawo takwe nibakamvwisisisya pe zintu ezi zyakali kwaambwa. ");
INSERT INTO dov_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kwakaba kuti Jesu kaali waamba kusika muJelikko, umwi moofu wakalikkede kumbali aanzila, ulakumbila, ");
INSERT INTO dov_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","mpawo nakamvwa tyanga lyabantu bayabweenda, wakabuzya kuti chakali kuchitika niinzi. ");
INSERT INTO dov_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bakamambila kuti, “Ngu Jesu waNazaleta uyabweenda. ");
INSERT INTO dov_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Mpawo mwalumi oyu moofu wakasompezya wati, “Jesu Mwana a Davida, ndifwide luzyalo”. ");
INSERT INTO dov_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bakali kweenda kumpela bakamwambwiida moofu oyu, bati, “Umuna”. Pesi wakasompezya loko, “Mwana wa Davida, ndifwide luzyalo”. ");
INSERT INTO dov_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu wakayimikila nji mpawo walayilila kuti mwalumi oyu ayeetwe kuli nguwe. Lino mwalumi oyu moofu nakaba afwiifwi, Jesu wakabuzya wati, ");
INSERT INTO dov_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Uyanda kuti ndikuchitilenzi? Wakati, “Mwami ndiyanda kuti ndibone”. ");
INSERT INTO dov_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesu wakati kulinguwe, “Bona. Lusyomo lwako lwakuponesya”. ");
INSERT INTO dov_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mpawo awo wakabona, wamutobela, kalemya Leza. Bantu boonse nibakabona ezi bakalumbayizya Leza. ");
INSERT INTO dov_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu wakanjila alimwi wakali kwiinda mu Jeliko. ");
INSERT INTO dov_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Amulamnge kwakali mwaalumi wakalikutegwa Zekias wakali simutelo alimwi kali muvubi mupati ");
INSERT INTO dov_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wakali kweezya kubona kuti Jesu ngwa, pesi taakakonzya kumubona pe munkamu yabantu, nkaambo wakali mfwiifwi. ");
INSERT INTO dov_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nkinkaako wakachijaanina kunembo lyabantu waakutanta mumukuyu kuti amubone, nkaambo Jesu wakalikwiinda munzila eeyo ");
INSERT INTO dov_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lino Jesu naakasika aawo wakalanga mujulu mawo wati kulinguwe, “Zekiyasi, seluka chakufwambaana, nkaambo sunu ndiyookkala mung'anda yako.” ");
INSERT INTO dov_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aboobo wakaseluka chakufwambaana akumutambula chakubotelwa. ");
INSERT INTO dov_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lino bantu boonse nibazibona eezi, bakanyontooka, kabaamba kuti, “Waya kuyooswaya mwaalumi ulazibi.” ");
INSERT INTO dov_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lino Zekiyasi wakayima wati ku Mwami, “ Langa, Mwami, chisela chalubono lwangu ndilachipa bachete kuti na ndakeeneena kufumbwa muntu, ndilamujosezya kazipetedwe tume kumuulo.” ");
INSERT INTO dov_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesu wakati, “Sunu lufutuko lwasika kung'anda eeno, nkaambo alakwe ooyu mwana wa Abbulahamu. ");
INSERT INTO dov_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nkaambo Mwana wa Muntu wakasika kuzooyandula akufutula bantu basweekede.” ");
INSERT INTO dov_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nibakachiswiilide eezi zintu, wakasngua kubaambila chikozyanisyo, nkaambo wakali afwiifwi a Jelusalemu, alimwi bakayeeya kuti bwami bwa Leza bwamba kuboneka mpawaawo. ");
INSERT INTO dov_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aboobo wakati, “Umwi mwaalumi musongo wakayinka kunyika iilikule kuyotambula bwami mpawo akuyoboola ");
INSERT INTO dov_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wakayita balanda bakwe bali kumi, mpawo wakabapa mali aalikumi akuti kulimbabo, 'Amuchite mabbindawuko mane ndikaboole.' ");
INSERT INTO dov_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pesi basichisinyina bakalimusulide alomwi bakamutumina bantu bakamutobela, bakati, 'Tatuyandi pe kuti oyu waamlumi atutonge.' ");
INSERT INTO dov_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Zyakachitika naakaboola lubo, kali watambula bwaami, wakalayilila kuti bayitwe babelesi bakwe aabo mbakapede mali, kuti azibe kuti nimpindunzi njibakajana mukuchita kwabo makwebo. ");
INSERT INTO dov_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wakusanguna wakasika kunembo lyakwe wati, 'Mwami, mali yako yakazyala aambi mamali aalikumi.' ");
INSERT INTO dov_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mwaalumi wabusongo wakati kulinguwe, 'Wakachita kabotu, omubelesi mubotu. Nkaambo wakasyomeka muzintu ziniini lino ndakupa manguzu aatla amadolopo aalikumi.' ");
INSERT INTO dov_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Wabili wakasika, wati, 'Mali yako, mwami, yakapanga aambi mali alimusanu.' ");
INSERT INTO dov_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mwaalumi uulemekeka wakati kulinguwe, 'Iwe tola madolopo alimusanu.' ");
INSERT INTO dov_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Umwi alakwe wakasika, wati, 'Mwami, njeyi mali yako, ndakayibambide kabotu mumulembo, ");
INSERT INTO dov_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","nkaambo ndakakuyoowa, nkaambo ulasisa, ulabweza chuwatabikide akutebula mpuwatabyalide.' ");
INSERT INTO dov_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mwaalumi uulemekeka wakati kulinguwe, 'Amajwi aako ndilakubeteka, mubelesi mubi, wakalizi kuti ndilimuntu uusesa, ndilabweza nchindatabikide, akutebula nchindatabyalide. ");
INSERT INTO dov_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wakalumwayi nuwakatabikide mali yangu mubbanka, kuchitila kuti nindalikuyooboola ndalikuzoyijana kiili yaba aampindu?' ");
INSERT INTO dov_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mwaalumi uulemekeka wakati kuli aabo bakayimvwi kumbali, 'Amumunyanzye mali yomwe eeyo mupe ooyo uulamamali aalikumi.' ");
INSERT INTO dov_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bakati kulingwe, 'Mwami, ulamamali aalikumi kale.' ");
INSERT INTO dov_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Ndati kulindinywe, woonse uulazyo, uyoopegwa zimbi, pesi ooyo uutakwe, acheecho nchali aacho uyoonyanzigwa. ");
INSERT INTO dov_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pesi aaba basinkondoma, aabo bakatalikuyanda kuti ndibatonge, amubeete aano mubajaye kunembo lyangu.'” ");
INSERT INTO dov_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nakaamba zintu eezi, wakayinda kaya ku Jelusalemu. ");
INSERT INTO dov_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kwakachitika kuti naakasika afwiifwi abusena bwa Betipeji a Betani, kukalundu kakalikutegwa Oliveti, wakatuma basikwiiya bakwe babili, ");
INSERT INTO dov_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kati, “Amunjile mugunzi lilikunembo. Mwanjila biyo mulajana mwana wadonki uutana kutantwa. Mumwaangunune mumweete kulindime. ");
INSERT INTO dov_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na kwaba utamubuzye kuti, 'Nkaambo nzi nimumwaangununa?' mukatedi, 'Mwami ulamuyanda.'” ");
INSERT INTO dov_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aabo bakatumwa bakamujana mwana wa donki mbuli mbakabalayilide Jesu. ");
INSERT INTO dov_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nibakali kumwaangununa mwana wadonki, bani bawe bakati, “Nkaambo nzi nimwaangununa mwana wa donki ooyo?” ");
INSERT INTO dov_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bakati, “Mwami ulamuyanda.” ");
INSERT INTO dov_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mpawo bakamweeta kuli Jesu, mpawo bakawaala majansi aabo aatala amwana wa donki mpawo bakakkazika Jesu aataka. ");
INSERT INTO dov_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Naakalikuyabweenda bakalikuya buyala majansi aabo munzila. ");
INSERT INTO dov_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Naakali waamba kusika abusena aawo Kalundu kama Oliva mpuka nkunuka, mbunga yoonse yabasikwiiya yakasanguna kubotelwa akulumbayizya Leza ajwi pati nkaambo kamilimu mipati njibakali babona, ");
INSERT INTO dov_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","kabati, “Ulilongezezegwe mwami uuza muzina lya Mwami! Luumuno kujulu abulemu kumajulu!” ");
INSERT INTO dov_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bamwi ba Falisi bakali munkamu bakati kuli ngwe, “Muyiisyi bakkabule basikwiiya bako.” ");
INSERT INTO dov_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesu wakasandula wati, “Kanskinga aaba baluumwine, mabwe alikunoompolola.” ");
INSERT INTO dov_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesu naakasika mudolopo, wakalila aatala andilyo, ");
INSERT INTO dov_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kati, “Kansinga wali waziba mubuzuba oobu, ayebo, zintu zikweetela luumuno! Pesi lino zilisisidwe kulinduwe. ");
INSERT INTO dov_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nkaambo mazuba ayoosika alinduwe, aawo basinkondonyokwe nibayoyaka kaanda akukuzyunguluka akukusyanikizya kuzwa kumabazu woonse. ");
INSERT INTO dov_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bayooku wisizya aansi abana bako. Taakwe nobayoosiya niliba bbwe aatala alimwi, nkaambo taakwe nuwakachibona Leza naakalikweezya kukufutula.” ");
INSERT INTO dov_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesu wakanjila muchikombelo akutanda boonse nakali kuuzya, ");
INSERT INTO dov_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","wakati kulombabo, “Kulilembedwe kuti, 'Ng'anda kyangu iyoba ng'anda yakukombela,' pesi mwayisandula kba ng'anda yabasikubba.” ");
INSERT INTO dov_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aboobo Jesu wakalikuyiisya abuzuba muchikombelo. Bapayizi bapati abalembi bamulawu abazululi babanti bakali kuyanda kumujaya, ");
INSERT INTO dov_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","pesi taakwe nibakajana nzila yakuzichita, nkaambo bantu boonse bakali kumuswiilila loko. ");
INSERT INTO dov_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bumwi buzuba, Jesu naakali kuyiisya bantu mutempeli akoompolola majwi mabotu, bapayizi bapati abalembi bamulawu bakasika kulinguwe abapati. ");
INSERT INTO dov_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Bakaambula kabati, kabati kulinguwe, “Twaambile kuti mumanguzu aani mochita eezi zintu? Nakuti ngwani ukupa nguzu zyakuchita eezi zintu?” ");
INSERT INTO dov_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Wakabasandula wati, “Ambebo ndilamubuzya mubuzyo. Amundaambile aatala ");
INSERT INTO dov_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","alubbabbatizyko lwa Joni. Lwakali kuzwa kujulu na kumuntu?” ");
INSERT INTO dov_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bakaambula aakati kabo, kabati, “Twati, 'Kuzwa kujulu', ulati, 'Naambo nzi nimwakatamusyoma?' ");
INSERT INTO dov_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pesi twati, 'Luzwa kumuntu,' bantu balatutulula mabwe nkaambo bazi kuti Joni wakali musinsimi.” ");
INSERT INTO dov_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aboobo bakasandula kuti tabazi pe kuti lwakali kuzwa kulini. ");
INSERT INTO dov_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesu wakati kulimbabo, “Ambezo nsikomwaambila pe kuti ninguzu zyani nzyechita aazyo zintu eezi.” ");
INSERT INTO dov_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wakaambila bantu chikozyanisyo eechi, “Umwi mwaalumi wakabyala chiilili chama sansa, mpawo wakawubikka mumaboko anbaabo balima masansa waya kulimbi nyika kwachiindi chilamfu. ");
INSERT INTO dov_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Muchiindi chakasalwa, wakatuma mubelesi wakwe kulibasimuunda. Pesi basimuunda mbakamuuma akutanda katakwe chintu. ");
INSERT INTO dov_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Wakatuma lubo umbi mubelesi mpawo bakamuuma, akumunyansya akmutanda lubo katakwe chintu. ");
INSERT INTO dov_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wakatuma lubo uumbi watatu alimwi bakamuchisa, akumutandila aanze. ");
INSERT INTO dov_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aboobo mwami wachilili wakati, 'Ndilachita biyeni? Ndilatuma mwandu wangu ngweyandisya amwi balikuyomulemeka.' ");
INSERT INTO dov_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pesi nibakamubona, bakaambula aakato kabo, kabati, 'Ooyu ngosili lukono. Atumujaye kuchitila kuti lukono lube lwesu.' ");
INSERT INTO dov_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bakamusowela kunze kwalubaya, mpawo bamujaya. Niinzi lino nchabatachite mwani muunda? ");
INSERT INTO dov_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ulasika azobajaye boonse balimi nbamasansa, mpawo ape muunda kuli bamwi.” Nibakamvwa eezyo bakati, “Inche atazizumini pe Leza kuti zibe oobo!” ");
INSERT INTO dov_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pesi Jesu wakabalanga, wati, “Aambaanzi malembe aaya? 'Bbwe ndibakaka bayaki, lyakazoba ndilyo lyakazooba bbwe lya chooko'? ");
INSERT INTO dov_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Woonse uuwoda abbwe eelyo uyyotyoloolwa muzimpanzi. Pesi ooyo ngujliyoowida, liyoomu pwaya ");
INSERT INTO dov_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aboobo balembi bamulaw abapayizi bapatgi bakayanda kutgi bamujate muchiindi nchicheecho, nkaambo bakalizi kuti wakaambula chikozyanisyo eechi kaamba mbabo. Pesi bakayoowa bantu. ");
INSERT INTO dov_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nibakamulangisisya obotu obotu, bakamutumina bantu bakali kulyeeneenia mbuli basalali, kuti bamuyandwiide mpatabisye kwaambuula, kuchitila kuti bamupede kabotu kulibasimilawu akumulawu wamweendelezi. ");
INSERT INTO dov_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bakabuzya kulinguwe bati, “Muyiisyi, tulizi kuti wambuula akuyiisya choonzyo, alimwi toktobelezyi mizeezo yabantu pe, pesi uyiisya choonzyo aatala anzila ya Lez. ");
INSERT INTO dov_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chili mumulawu na kuti tubbadale mitelo kuli Siza nape?” ");
INSERT INTO dov_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pesi Jesu wakalumvwisisisya lweeno lwabo, mpawo wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Amunditomndeezye kobili. Mbusyu azina lyani lilembedwe mpawo?” Bakaamba kuti, 'Nzizya siza.” ");
INSERT INTO dov_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wakati kulimbabo, “Akboobo amupe kuli Siza zintu zya Siza, akuli Leza zointu zya Leza.” ");
INSERT INTO dov_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bakakachilwa nbulewusi muli nzyakaamba kunembo lyabantu. Bakayimikila akugamba aatala anandulo yakwe alimwi taakwe chimbi nchibakaamba. ");
INSERT INTO dov_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lino ma Sadiusi nibakasika kulinguwe, aabo baamba kuti takukwe bubuke kubafu, ");
INSERT INTO dov_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","bakamubuzya bati, “Muyisyi, Molzesi wakatulembela kuti na mukulana wamwaalumi wafwa, kali walikwete, pesi katakwe mwana, ooyo mwanike weelede kukwata bana mukulana azyalile mukulana mwana. ");
INSERT INTO dov_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kwakali bananyina bali kmusanu ababili, alimwi wakusanguna wakakwata, mpawo wakafwa katakwe mwana pe, ");
INSERT INTO dov_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","awabili lubo. ");
INSERT INTO dov_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Watatu wakanjila munda, aboobo boonse musanu ababili bakanjla mung'anda pesi boonse bakafwa taakwe wakasiya mwana pe. ");
INSERT INTO dov_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Musule wakazoofwa alakwe mwanakazi. ");
INSERT INTO dov_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lino kububuke, uyooba mwanakazi wanu? Nkaambo boonse kabali musanu ababili bakali mukwete.” ");
INSERT INTO dov_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu wakati kulimbabo, “Bana balombe banyika iino balakwata alimwi balapegwa mulukwatano. ");
INSERT INTO dov_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pesi aabo batakajane bulemu bwakutambula kubuka kubafu taakwe nibatakakwate na kupegwa mulukwatano. ");
INSERT INTO dov_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tabakoyoofwa alimbi, nkaambo banooli bakozyania abangelo alimwi mbana ba Leza nkaambo mbana babubuke. ");
INSERT INTO dov_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pesi abalabo bafwide bazobusigwa, alakwe Mozesi wakatondeezya kubusena bwalusaka, awo nayita kuti Leza wa Abbulahamu a Leza wa Ayizeki a Leza wa Jakobo. ");
INSERT INTO dov_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Lino tachili Leza wabafwide pe, pesi wabawumi, nkaambo boonse bapona kulinguwe. ");
INSERT INTO dov_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bamwi balembi bamulawu bakasandula bati, “Muyiisyi wasandula kabotu.” ");
INSERT INTO dov_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nkaambo taakwe nibakachilikuyanda kweezya kumubuzya lubo iimbi mibuzyo. ");
INSERT INTO dov_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesu wakatghji kulimbabo, “Baamba biyeni kuti Kkilisito mwana wa Davida? ");
INSERT INTO dov_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Nkaambo Davida lwakwe mu Bbjuku lya Ntembawuzyo waamba kuti, Mwami wakati ku Mwami wangu, 'Kkala kululyo lwangu, ");
INSERT INTO dov_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mane ndikachite basinkondo nyokwe bakabe kunsi aamawulu aako' ");
INSERT INTO dov_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Aboobo Davida wiita Kkilisito kuti 'Mwami', mpo mwana wa Davida biyeni?” ");
INSERT INTO dov_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kabamvwide bantu boonse wakati kulibasikwiiya bakwe, ");
INSERT INTO dov_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Amubaschenjelele balembi bamilawu, bayanisya kweenda kabazweete majansi malamfu, kabayanda kujuzigwa kulinsini muzisambalilo, azyuuno zipati muzikombelo azyuuno zisumpukide kumapobwe. ");
INSERT INTO dov_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Balatola maanda aabamukabafu, akweeneena kumchita nkombyo ndamfu. Aba bayotambula kunyonyoonwa kupati.” ");
INSERT INTO dov_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu wakalanga wabona balumi bavubi kabalokubikka zipo munkomo yakubikkila mali. ");
INSERT INTO dov_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wakabona umwi muka mufu ufwaba kalokubikka tunini tobile. ");
INSERT INTO dov_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lino wakati, “Kasimpe ndamba obu kulindunywe, oyu muchete mukamufu wapa kwinda boonse. ");
INSERT INTO dov_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Boonse bapa zipo mukwindilila mukuvula kwazyo. Pesi mukamufu, kwinda buchete bwakwe, wabikka toonse twayelede kupona ato”. ");
INSERT INTO dov_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Abamwi bakali kwambula achikombelo, yasamika mabwe mabotu azituuzyo, wakamba, ");
INSERT INTO dov_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“kulizezi zintu nzimubwene, izuba liyosika nikuyochala katachikwe bbwe lilatala abbwe nyina liyochala kalitawidide ansi.” ");
INSERT INTO dov_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bamumuzya bati, “Muyisi, ndilili niziyochitika zintu ezi?” Alubo nchiinzi chiyoba chitondezyo chakuti zintu ezi zyaamba kuchitika?” ");
INSERT INTO dov_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu wakasandula, “Amuchenjele kuti muteenwi. Nkambo bayosika muzina lyangu kabati 'ndime oyoo'a 'chindi chaba afwifwi' mutakabatobeli. ");
INSERT INTO dov_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mwakumvwa nkondo ampyompyongano mutakayowi, nkambo zintu ezi zyelede kuchitikana kusanguna, pele mamanino takayochitika kufwambana”. ");
INSERT INTO dov_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mpawo wakati kulimbabo, “Chisi chiyolwana achisi nyina. ");
INSERT INTO dov_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kuyooba mizuzumino mipati munyika, anzala mumasena asiyenesiyene azilwazi, kuyoba ziyosya azitondeezyo zipati zizwa kujulu. ");
INSERT INTO dov_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pesi kakutanachitika ezi zintu, bayobikka manza abo alindinywe akumupenzya, bamwabe muzikombelo amuntolongo, akumweeta kunembo lyabami abendelezi nkambo kazina lyangu. ");
INSERT INTO dov_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Kuyoba bukamboni kulindinywe. ");
INSERT INTO dov_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nkambo kako amukanze mumyoyo yanu kuteezeezya makani ngimuyowamba, ");
INSERT INTO dov_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","nkambo ndime usikamupe majwi abusongo kuti boonse basinkondo nyokwe bakachilwe kukaka akukazya. ");
INSERT INTO dov_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pele muyozipegwa atala abazyali, bakulana, nzubo, abenzuma alimwi bayobikwa bamwi bana mulufu. ");
INSERT INTO dov_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Muyosulwa moonse nkambo kazina lyangu. ");
INSERT INTO dov_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pele takukoyooba kasusu kakumitwe yanu kayooloba. ");
INSERT INTO dov_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kumakatazyo muyoobujana bumi bwanu. ");
INSERT INTO dov_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nimwakubona Jelusalema yazyungulukwa ampi, lino muyoziba kuti kusaalwa kwabo kwaba afwifwi. ");
INSERT INTO dov_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lino abo bali muJudiya abachijile mumalundu, alubo bali mudolopo abazwe, abo alabo bali anze achisi tabelede kunjila mudolopo. ");
INSERT INTO dov_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nkambo aya mazuba akubwedzya chibi, kuti zintu zyoonse zilembedwe ziyoozuzikizigwe. ");
INSERT INTO dov_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mawee kuli babo bamisi akulibabo banyonsya kumazuba ayo! Nkambo kuyoba mapenzi mapati munyika, ayendelana abantu aba. ");
INSERT INTO dov_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bayojegwa apanga, bayootolwa baange kuzisi zyoonse a Jelusalemu uyoozunganisigwa abamasi kusikila chindi chabamasi chizulile. ");
INSERT INTO dov_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kuyooba zitondeezyo kuzuba, akumwezi, amunyenyezi. Amunyika, nyika iyoba akakukatazigwa nkambo kakuvuuma kwamayuwe amulwizi. ");
INSERT INTO dov_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kuyoba bantu bayoomana nguzu akuyowa akuyeya zintu zitasikile nyika. Nkambo nguzu zyakujulu ziyozunganisigwa. ");
INSERT INTO dov_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mpawo bayomubona Mwana mulombe wa Muntu kaboola mujoba munguzu amubulemu bupati. ");
INSERT INTO dov_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pele zintu ezi zyakutalika kuchitika, amunyampuke akulungumika mitwe yanu, nkambo lwangunuko lwanu lwaba afwifwi”. ");
INSERT INTO dov_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesu wakabambila muzikozyano, “Mulange mukuyu amasamu onse. ");
INSERT INTO dov_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lino na asyuuka ndelema, anga mwabona lwanu akuziba mayinza aba afwifwi. ");
INSERT INTO dov_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lino aboobo, na mwabona zintu ezi kazichitika, muyoziba kuti bwami bwaLeza bwaba afwifwi. ");
INSERT INTO dov_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kasimpe ndamwambila obu nywe, olu lunyungu talukayindi mane zintu ezi zikachitike. ");
INSERT INTO dov_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ijulu anyika ziyoyinda, pele ijwi lyangu talikoyomana pe. ");
INSERT INTO dov_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pesi amuswilile lwanu, kuti myoyo yanu italemenwi akwindilizya kunywa akukolwa akulipenzya abuumi, azuba elyo talikoyomujana kufwambana pe ");
INSERT INTO dov_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","mbuli kakole. Nkambo chiyosikila kuli boonse bapona kubusyu bwanyika yoonse. ");
INSERT INTO dov_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pesi amulibambile chindi choonse, mukombe kuti mube anguzu akuchija zintu ezi zitachitike, akwiima kunembo lya Mwana mulombe wa Muntu”. ");
INSERT INTO dov_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Lino kuzwa kuseni kusikila goko wakali kuyiisya muzikombelo, munsi wakali kuzwa anze akuyokkala kutegwa Oliveti. ");
INSERT INTO dov_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bantu boonse balikusika kuseni kuzomuswilizya mutempele. ");
INSERT INTO dov_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lino pobwe lyachinkwa chitakwe bumena chakali chaamba kusika, litegwa Pasika. ");
INSERT INTO dov_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","BaPayizi bapati alimwi abalembi bakalikuyaandula mbubanga balabika Jesu kulufu, nkaambo bakalikuyoowa bantu. ");
INSERT INTO dov_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Lino Satani wakanjila muli Judasi Isikkaliyoti, ooyo wakali umwi wabalikkumi ababili. ");
INSERT INTO dov_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judasi wakayinka kubapayizi bapatki akubapati babasilumamba waakubaambila mbanga ulapeda Jesu kulimbabo. ");
INSERT INTO dov_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bakabotelwa alimwi bazuminana kuti bamupe mali. ");
INSERT INTO dov_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wakazumina alimwi wakayaandula mweenya wakubapa kule abantu. ");
INSERT INTO dov_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nibwakasika buzuba bwachinkwa chitakwe bumena, aawo nikwakeelede kupayigwa kabelele kakwiindilila. ");
INSERT INTO dov_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesu wakatuma Pita a Joni kaamba kuti, “Mweende mukatubambile chakulya cha Pasika kuchitila kuti tzolye.” ");
INSERT INTO dov_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bakabuzya kulinguwe bati, “Nkookuli nkoyanda kuti tukachite mabambe aaya?” ");
INSERT INTO dov_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wakabasandula kuti, “Amulange naa mwanjila mumuunzi, mulaswaana mwaalumi utukkide nongo yamanzi. Mukamutobele mung'anda eeyo njatakanjile. ");
INSERT INTO dov_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Amukatedi kuli muna ng'anda, “Muyiisi wati kulinduwe, ilikuli ng'anda yakulida, oomo munditalide Pasika abasikwiiya bangu?” ");
INSERT INTO dov_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Uyokutondezya n'anda mpati yakulala yakujulu iili aazyoonse. Kachite mabambe ooko.” ");
INSERT INTO dov_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aboobo bakiinka, alimwi bakujana zyoonse mbuli mbakali waamba kulimbabo. Mpawo bakabamba kulya kwa Pasika. ");
INSERT INTO dov_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eelyo chiindi nichakasika, wakakkala aansi abasikwiiya. ");
INSERT INTO dov_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mpawo wakati kulimbabo, “Ndalikuyandisya kapati kulya Pasika andinywe nkesinapenzegwa, ");
INSERT INTO dov_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nkaambo ndati kulindinywe, nsikoyoolya lubo kusikila zyazuzikizigwa mubwaami bwa Leza.” ");
INSERT INTO dov_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Mpawo Jesu wakabweza nkomeki, alimwi eelyo nakapa kulumba, wakati, “Mubweze eechi, alimwi mukachaabane aakati kanu. ");
INSERT INTO dov_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nkaambo ndati kulindinywe, nsikoyoonywa muchelo wa musaansa lubo kusikila bwaami bwa Leza bwasika.” ");
INSERT INTO dov_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mpawo wakabweza chinkwa, alimwi eelyo nakapa kulumba, wakachikwamuna, alimwi wakabapa, kati, “Ooyu mubili wangu, ooyo wapegwa akaambo kanu. Mukachite eechi mukuyeya ndime.” ");
INSERT INTO dov_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wakabweza nkomeki munzila yeeelene musule lya chilalilo, kalikuti, “Eeyi nkomeki nchizuminano changu chipya mu gazi lyangu, lyatilwa akaambo kanu. ");
INSERT INTO dov_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pesi muswiilile. Ooyo undiwuzya uli andime antafula. ");
INSERT INTO dov_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nkaambo Mwana mulombe wa Muntu nchobeni uliinka mbuli mbuzyakabambwa. Pesi mawe kuliwoyo muntu uyonduuzya!” ");
INSERT INTO dov_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bakatalika kuzuwisyania chabochabo kuti ngwani unga uyookonzya kuchita eechi. ");
INSERT INTO dov_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mpawo kwakaba kukazyania aakati kabo aatala akuti nguuli wabo wakalikubwezwa kali mupati. ");
INSERT INTO dov_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Wakati kulimbabo, “Baami ba bamaasi mbasimalelo aatala ambabo, alimwi aabo bali aabweendelezi aatala ambabo babonwa mbuli baabo bachita bubotu kubantu babo. ");
INSERT INTO dov_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pesi tazyeelede kuba boobu pe andinywe. Anikuti, muleke ooyo mupati aakati kanu abe mbuli muniini, alimwi muleke ooyo uli alugwasyo abe mbuli ooyo ubeleka. ");
INSERT INTO dov_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nkaambo ngwani mupati, ooyo uukkala antafula, na ooyo ubeleka? Nikubaboobo ndili aakati kanu mbuli woyo uubeleka. ");
INSERT INTO dov_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pesi ndinywe nimwakiinkilila kunembo andime mumasukukusyo aangu. ");
INSERT INTO dov_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ndapa kulindinywe bwaami, mbuli Taata wangu mbakapa bwaami kulindime, ");
INSERT INTO dov_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kuti mukonzye kulya akunywa aantafula lyangu mubwaami bwangu, alimwi uyookkala azyuuno kolikubeteka mikowa iilikkumi ayibili ya Izilayeli. ");
INSERT INTO dov_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sayimoni, Sayimoni, chenjela, Satani wakukumbila, kuti amwi walikukonzya kukupupulula mbuli witi. ");
INSERT INTO dov_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pesi ndakukombela, kuti lusyomo lwako lutakachilwi. Niwabweda msule lubo, simwa bakulana bako.” ");
INSERT INTO dov_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita wakati kulinguwe, “Mwaami, ndililibambilide kwiinka ayebo koonse kuntolongo alimwi a kulufu.” ");
INSERT INTO dov_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu wakamusandula, “Ndakwaambila, Pita, mukuku takoyookokolika buzuba obuno, iwebo kotanandikaka tutatu kuti tondizi pe.” ");
INSERT INTO dov_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mpawo Jesu wakati kulimbabo, “Eelyo nindakamutuma aanze kamutakwe chikkwama chemali, chikkwama chazyoonse, na nsangu, mwakakubula chintu na?” Bakasandula, “Takwe pe.” ");
INSERT INTO dov_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mpawo wakti kulimbabo, “Pesi lino, ooyo uli echikkwama, mumuleke achibweze, alimwi lubo chikkwama chazyoonse. Ooyo utakwe panga weelede kuzya chikobela chakwe alimwi awule limwi. ");
INSERT INTO dov_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nkaambo ndati kulindinywe, eezyo zilembedwe aatala andime zyeelede kuzuzikizigwa, 'Wakabalwa aantomwe abatakwe mulawu.' ");
INSERT INTO dov_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mpawo bakati, “Mwaami, langa! Ngaya mapanga obile.”wakati kulimba, kwakkwana.” ");
INSERT INTO dov_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesu wakiinka, mbuli mbakalikukkala kachita chiindi chiingi, ku Chilundu cha Olivi, alimwi basikwiiya bakamutobela. ");
INSERT INTO dov_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Eelyo nibakasika, wakati kulimbabo, “Mukombe kuti mutanjili mumasukusyo.” ");
INSERT INTO dov_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wakazwa aakati kabo afwifwi aasikila bbwe lyakuwala amaboko, alimwi wakafugama aansi alimwi wakakomba, ");
INSERT INTO dov_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","kati, “Taata, na kamuyanda, mugwisye nkomeki eeyi kuzwa kulindime. Nikubaboobo pe pe lwangu luyando, pesi lwanu ngalukachitwe.” ");
INSERT INTO dov_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Mpawo mungelo kuzwa kujulu wakaboneka kulinguwe, kalikumusimya. ");
INSERT INTO dov_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kali mukulila kupati, wakakombesya loko chanchobeni, alimwi nkasaalo yakwe yakaba mbuli malosi mapati agazi kayilikulokela anyika. ");
INSERT INTO dov_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Eelyo nakazwa kukukomba kwakwe, wakaya kui basikwiiya bakwe alimwi wakabajana kabalikoona akaambo kabuusu bwakwe ");
INSERT INTO dov_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","alimwi wakababuzya, “Nkaambonzi nimulikoona? Mubuke mukombe, kuti mutakanjili mumasukuusyo.” ");
INSERT INTO dov_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aawo nakachilikwaambula, bona, inkamu yakaboneka, aantomwe a Judasi, umwi wa bali kkumi ababili, kali kubazulwida. Wakaza afwifwi a Jesu kuzomumyonta, ");
INSERT INTO dov_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","pesi Jesu wakati kulinguwe, “Judasi ulikuuzya Mwana mulombe wa Muntu alumyonto?” ");
INSERT INTO dov_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eelyo bakazyungulukide Jesu nibakabona zyakali kuchitikana, bakati, “Mwaami, tuume na apanga?” ");
INSERT INTO dov_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mpawo umwi wabo wakawuma mulanda wa mupayizi mupati, alimwi wakakwapula kutwi kwakwe kwachilisyo. ");
INSERT INTO dov_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesu wakati, “Eezyo zyakkwana!” Wakaguma kutwi kwakwe, alimwi wakamuponia. ");
INSERT INTO dov_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesu wakati kuli silutwe wa bapayizi ba muchikombelo, alimwi akubapati bakamubukila, “Muza mbuli kumubbi, kamuli amapanga a nkoli? ");
INSERT INTO dov_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eelyo nindakali aandinywe mazuba oonse muchikombele, takwe nimwakabika maboko aanu alindime. Pesi eeli ndihola lyanu, alimwi bweendelezi bwamumudima.” ");
INSERT INTO dov_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kabamukwensa, bakamubweza alimwi bamutola kun'anda yamupayizi mupati. Pesi Pita wakalikutobela kulekule. ");
INSERT INTO dov_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Musule lyakudukula mulilo aakati kabbetekelo alimwi kabali bakkala aansi aantomwe, Pita wakakkala aakatai kabo. ");
INSERT INTO dov_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Umwi mulanda mwanakazi wakamubona aawo nakakkende mumumuni wamulilo alimwi wakalanga kulinguwe chakumudunamina alimwi wakati, “Ooyu mwaalumi alakwe wakali aanguwe.” ");
INSERT INTO dov_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pesi Pita wakakaka, kati, “Mwanakazi, nsimwizi pe.” ");
INSERT INTO dov_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Musule lyakayindi kaniini loko umwi wakamubona, alimwi wakati, “Nduwe umwi wabo.” Pesi Pita wakati, “Mwaalumi, tensi ndime.” ");
INSERT INTO dov_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nikwakiinda hola lyomwe uumbi mwaalumi wakasisimpizya alimwi wakati, “Nchobeni mwaalumi ooyu alakwe wakali aanguwe, nkaambo ngwaku Galili.” ");
INSERT INTO dov_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pesi Pita wakati, “Mwaalumi, nsizi pe eecho ncholikwaamba.” Chakufwambaana, nakachilikwaambula, mukuku wakakokolika. ");
INSERT INTO dov_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Wakachebuka, Mwaami wakalanga Pita, alimwi Pita wakayeya ijwi lya Mwaami, eelyo nakati kulinguwe, “Mukuku katanaakokolika sunu uyondikaka tutatu.” ");
INSERT INTO dov_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita wakiinka aanze alimwi wakakulila kapati. ");
INSERT INTO dov_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mpawo baalumi bakalindide Jesu bakamuseka alimwi bakamuuma. ");
INSERT INTO dov_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bakabika chivumbyo aatala lyakwe alimwi bakamubuzya, kabati, “Sinsima! Ngwani ooyo wakuuma?” ");
INSERT INTO dov_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bakaambula zimwi zyiingi zintu aatala a Jesu, kabalikumutuka. ");
INSERT INTO dov_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Chakufwambaana mbuli mbulyakali zuba, bapati babantu bakaswaanana aantomwe, bapayizi bapati alimwi abalembi. Bakamutola mu Nkuta ");
INSERT INTO dov_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","alimwi bakati, “Na koli Kkilisito, twaambile.” Pesi wakati kulimbabo, “Na ndamwaambila, tamukoyoondisyoma pe, ");
INSERT INTO dov_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","alimwi na ndamubuzya, tamukoyoosandula pe. ");
INSERT INTO dov_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pesi kuzwa lino kaziya kunembo, Mwana mulombe wa Muntu unoyokkede kuchilisyo chamanguzu aa Leza.” ");
INSERT INTO dov_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Boonse bakati, “Nkokwaamba kuti uli Mwana mulombe wa Leza?” Jesu wakati kulimbabo, “Mwaamba kuti ndime.” ");
INSERT INTO dov_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bakati, “Nkaambonzi nituchiyanda mukamboni? Nkaambo lwesu tobweni twalimvwida kuzwa kumulomo wakwe.” ");
INSERT INTO dov_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yoonse nkamu yabo yakanyampuka, mpawo bakeeta Jesu kunembo lya Payileti. ");
INSERT INTO dov_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bakasanguna kumupa milandu, kabati, “Twajana mwaalumi ooyu kali kunyongania chisi chesu, walikukaka kuti tulemeke Siza, alimwi walikwaamba kuti we ngo Kkilisito, mwai.” ");
INSERT INTO dov_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Payileti wakamubuzya wati, “Uli Mwami waba Juda na?” Mpawo Jesu wakamusandula wati, “Nduwe waamba oobo.” ");
INSERT INTO dov_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Payileti wakati kubapayizi bapati akunkamu yabantu, “Taakwe bubi pe mbundabona mumwaalumi ooyu.” ");
INSERT INTO dov_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pesi bakasungwaala kabaamba kuti, “Unyongania bantu, ulayiisya mu Judea lyoonse, kuzwa ku Galilii kuzosika okuno.” ");
INSERT INTO dov_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aboobo Payileti naakamvwa eezi, wakabuzya kuti ooyu mwaalumi muna Galilii na. ");
INSERT INTO dov_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Naakamvwa kutgi wakali munsi lyanguzu zya Helodi, wakamutumina kuli Helodi, ooyo alakwe wakali mu Jelusalemu muli aayho mazuba. ");
INSERT INTO dov_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helodi nakabona Jesu, wakabotelwa loko, nkaambo wakalikuyandisya kumubona kwachiindi chnilamfu. Wakalikmvwa aatala anguwe alimwi wakali kulipeekezya kubona malele ngachita. ");
INSERT INTO dov_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Helodi wakamubuzya makani miingi, pesi Jesu taakwe naakasandula pe. ");
INSERT INTO dov_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Bapayizi bapati abalembi bamulawu bakaliimvwi aawo kabamupa milandu. ");
INSERT INTO dov_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helodi abasilumamba bakwe bakamusampawula, akumuweela, bakamuzwaatika zisamo zibotu mpawo baka bweedezya Jesu kuli Payileti. ");
INSERT INTO dov_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Helodi a Payileti bakazwaaba bazolani buzuba mbuboobo (bakalibasinkondonyina chiindi choonse). ");
INSERT INTO dov_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mpawo Payileti wakiita antoomwe bapayizi bapati, batgongi antoomwe ankamu yabantu, ");
INSERT INTO dov_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","wakati kulimbabo, “Mwandeetela mwaalumi ooyu, mbuli muntu ulikupa kuti bantu babisye, pesi amulange, mebo, ndamubuzisisya kunembo lyenu, taakwe nindajana bubi pe kulinguwe aatala amilandu njimwamupa. ");
INSERT INTO dov_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Peepe, alakwe Helodi taakwe nchaajana, nkaambo wamuboozya kulindiswe, alimwi amulange, taakwe cheelede lufu pe nchakachita. ");
INSERT INTO dov_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ndilamusubula biyo mpawo ndimwaangunune. ");
INSERT INTO dov_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pesi boonse bakoompolola kabati, “Tatumuyandi pe swe ooyu mwaalumi, twaangunwide Bbarabbasi!” ");
INSERT INTO dov_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bbarabbasi wakali mwaalumi wakabikidwe muntolongo nkaambo kakutatgobelezya imwi milawu akujaya. ");
INSERT INTO dov_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Payileti wakaambula lubo, kulimbab kali achiyandisyo chakumwaangununa Jesu. ");
INSERT INTO dov_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pesi bakoompolola, bakati, “Abambulwe, abambulwe.” ");
INSERT INTO dov_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wakabaambila lwatatu, wakati, “Nkaambo nzi, ncheechili chibi nchaachita ooyu mwaalumi? Taakwe nchindajana pe chiyanda kuti apegwe chisubulo chalufu aalinguwe. Aboobo nindazwa kumusubula ndilamwaangununa.” ");
INSERT INTO dov_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pesi bakasungwaala amajwi mapati, kabayanda kuti abambulwe. Alimwi majwi aaya akamupa kuzumina Payilet. ");
INSERT INTO dov_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aboobo Payileti wakazumina kubapa chiyandisyo chabo. ");
INSERT INTO dov_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wakaangununa ooyo ngubakali bakumbila ooyo wakabikidwe muntolongo nkaambo kabupanduki akujaya. Pesi wakapeda Jesu kuluyando lwabo. ");
INSERT INTO dov_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nibakali kuya bumuzulwida, bakajata umwi mwaalumi utegwa Sayimoni waku Sayilini, walikuzwida munyika, bakamupikuzya chiingano kayobutobela Jesu. ");
INSERT INTO dov_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nkamu mpati yabantu, abanakazi bakalikuya bumulila, bakamutobela. ");
INSERT INTO dov_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pesi wakabacheba, Jesu wakati, “Nobana basimbi ba Jelusalema, tamulili ndime, pesi amulilile lwanu abana benu. ");
INSERT INTO dov_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nkambo amulanga, alasika mazuba aawo nibayoti, 'Zililongezezegwe ngomwa, ayaayo mala akatazyalwa, ankolo zyakatanyonkwa.' ");
INSERT INTO dov_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mpawo bayootalika kuti kutulundu, 'Tuwide,' akumwaala, 'Tuvumbe.' ");
INSERT INTO dov_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nkaambo nabachita oobu kumusamu mutete, bayochita biyeni kulooyo muyumu?” ");
INSERT INTO dov_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Bamwi baalumi, basimilandu babili, bakabingwa antoomwe anguwe kuti bakajiigwe. ");
INSERT INTO dov_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nibakasika kubusena butegwa “Chifuwa,” ooko bakaubambula abasimilandu babili, umwi kuulyo umwi kuchimweensi. ");
INSERT INTO dov_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesu wakati, “Ndeende, balekelele, nkaambo tabazizi nzibachita.” Mpawo bakawuma chisilo kabaabana zisamo zyakwe. ");
INSERT INTO dov_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bantu bakaliimvwi kabalangide alimwi batkongi bakali kumuweela, kabati, “Wafutula bamwi. Alifutule, na kali Kkilisito wa Leza uusalidwe.” ");
INSERT INTO dov_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Basilumamba abalabo bakamusyonsya kabamupa viniga kuti anywe, ");
INSERT INTO dov_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bakati, “Na koli Mwami waba Juda, lifutule.” ");
INSERT INTO dov_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kwakaliwo alimwi chitondeezyo kumutwe aakwe chakalembedwe kuti, “Ooyu Mwami waba Juda.” ");
INSERT INTO dov_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Umwi wabasimilandu wakali kulengelela kumbali aakwe wakamutukila watgi, “Teensi nduwe Kkilisito na? Lifutule utufutule aswebo.” ");
INSERT INTO dov_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pesi umwi wakamukalalila wati, “Tomuyoowi na Leza, nkaambo ulimunsi lyachisubulo chikozyenie na? ");
INSERT INTO dov_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Swebo tuli aano mukweelela, nkaambo tulikutambula zitweelede kunchito zyesu. Pesi ooyu mwaalumi taakwe chibi nchachita pe.” ");
INSERT INTO dov_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Alimwi wakayungizya wati, “Jesu, ukandiyeeye wakunjila kubwami bwako.” ");
INSERT INTO dov_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu wakati kulinguwe, “Nchobeni ndakwaambila, sunu uyoba andime mu paladiso.” ");
INSERT INTO dov_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Lino lyakali lyaba wola lyamusanu akamwi, kwakaba mudima nyika yoonse mane kwakusika wola lyamusanu atune ");
INSERT INTO dov_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","nkaambo zuba lyakakachilwa kumunika. Mulembo wamuchikombelo waka deluka akati kuzwa kujulu do aansi. ");
INSERT INTO dov_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Akukwiila ajwi pati, Jesu wakati, “Ndeende, mumaanza aako ndabikka muuya wangu.”Naakamana kwaamba oobo wakafwa. ");
INSERT INTO dov_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Silumamba wa mwaanda naakabona kazichitika eezi, wakalumbayizya Leza, wakati, “Nchobeni ooyu wali mwaalumi uusalala.” ");
INSERT INTO dov_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Lino bantu boonse bakabungene kuzobona zyakalikuchitika nibakabona zintu eezi zyakachitwa, bakabweeda kabafwide nsoni loko. ");
INSERT INTO dov_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pesi bazolani bakwe boonse abanakazi bakabatobede kuzwa ku Galilii bakayimikila kulekule, kabalikweeba zintu eezi. ");
INSERT INTO dov_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Amulange kwakali mwaalumi wakalikutegwa ngu Jozefu, wakali waNkuta, wakali mwaalumi mubotu uululeme ");
INSERT INTO dov_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(taakwe naakazuminene awo pe muzeezo wabo), wakalikuzwa kudolopo lyaku Judiya litegwa Arimathea alimwi wakalikulinda bwami bwa Leza ");
INSERT INTO dov_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ooyu mwaalumi wakayinka kuli Payileti, wakukumbila mutunta wa Jesu. ");
INSERT INTO dov_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Wakawuseluzya, akuvunga mumicheka mibotu, akulazika mukabanda kakali kabbwe libezedwe, alimwi taakwe muntu wakalina lazikwa oomo pe. ");
INSERT INTO dov_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Bwakali buzuba bwakubambila, alimwi buzuba bwa Sabata bwakali bwaswena. ");
INSERT INTO dov_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Banakazi bamukatobede kuzwa ku Galilii, bakatobela, bakakukabona kabanda ambaakavwikwa. ");
INSERT INTO dov_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bakaboola, bakabamba tununkilizyo amafuta. Mu Sabata bakalyookezya mbuli mumulawu ");
INSERT INTO dov_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Chifumofumo mubuzuba bwakusanguna bwamvwiki, bakasika kukabanda, kabeeta tununkilizyo tubakali babamba. ");
INSERT INTO dov_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bakajana bbwe lilitontedwe kuzwa kukabanda. ");
INSERT INTO dov_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bakanjila mukati, pesi tebakawujana pe mutunta wa Mwami Jesu ");
INSERT INTO dov_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Zyakachitika kuti, aawo kabachigambide aatala azeezi, mpawaawo, kwakiimikila baalumi babili kumbali lyabo kabazwete zisamo zibayima. ");
INSERT INTO dov_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aawo banakazi nibakazula kuyoowa bakafundamika busyu bwabo, bakati kubanakazi, “Muyandwiidanzi bapona kubafu.” ");
INSERT INTO dov_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tawo pe aano, pesi wabusigwa! Amuyeeye mbakaambula kulindinywe naakachili ku Galili, ");
INSERT INTO dov_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","kati Mwana wa Muntu weelede apedwe kumaanza abasizibi akabambulwe, mpawo mubuzuba bwatatu akabuke lubo.” ");
INSERT INTO dov_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Banakazi bakayeeya majwi aakwe, ");
INSERT INTO dov_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","bakeenda kuzwa kukabanda bakwaambila zyoonse eezi kulibalikumi awumwi abamwi boonse. ");
INSERT INTO dov_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Lino Meli Magadalena, Jowana, Meli banyina a Jemusi abamwi banakazi mbibakali aabo, bakakwaamba zintu eezi kubatumwa. ");
INSERT INTO dov_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pesi majwi aaya akabaanga ngakubeja nibakaamvwabatumwa, tebakabasyoma pe banakazi. ");
INSERT INTO dov_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mpawo Pita wakanyampkuka wachijaanina kuchuumbwe, wakakotama kalikuyuna mukati wakabona micheka kiili ayilikke, wakabula kuti niinzi chachitika. ");
INSERT INTO dov_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Amulange babili babo bakalikuyabweenda buzuba mbuboobo kabatozya kugunzi litegwa Emawusi, lyakali kasinzo kuzwa ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bakalikuyabuzuwa aatala azintu zyakachitika. ");
INSERT INTO dov_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Zyakachitika kuti, kabachiyabuzuwa akubuzisisyania, Jesu lwakwe wakabeezya weenda aabo. ");
INSERT INTO dov_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pesi menso aabo akaksigwa kuti bamuzibe. ");
INSERT INTO dov_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesu wakati kulimbabo, “Nobabili niinzi nchimuyobwaambula nimuyobweenda awa?” Bakayimikila kabali amawuse. ");
INSERT INTO dov_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Umwi wabo uutegwa Kiliyopasi, wakamusandula, “Te nduwe olike mu Jelusalem uutazi zintu zyalikuchitika mumo mazuba aaya?” ");
INSERT INTO dov_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu wakati kulimbabo, “Zintu nzi eezyo?” Bakamusandula bati, “Zintu zili aatala a Jesu muna Nazaleta, wakali musinsimi, wakali aanguzu kunchito akujwi kunembo lya Leza akubantu boonse. ");
INSERT INTO dov_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ambubakamupeda bapayizi bapati abatongi besu kuti apegwe mulandu wakujiigwa. ");
INSERT INTO dov_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pesi ytwakali twasyoma kuti nguwe uutakaangunune Izilayeli. Iyii, kunze kwazyo zyoonse eezi, kwaba mazuba aatatu zintu zyoonse eezi kazichitikide. ");
INSERT INTO dov_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pesi kakuliboobo, bamwi banakazi mbituyabweenda aabo batugambya, nibalikuchibuda chifumo. ");
INSERT INTO dov_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Nibakuubula mutunta wakwe, bakuboola, kabaamba kuti babona chilengano chabangelo babili balikubaambila kuti wabuka. ");
INSERT INTO dov_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bamwi lubo baalumi mbituli aabo bachijaanina kuchibunda bakujana mbubo mbuli mbubaamba banakazi. Pesi tabamubwene pe.” ");
INSERT INTO dov_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesu wakati kulimbabo, “Nywebo nobaalumi bafubafuba animuli aamyooyo iichedwa kusyoma kulizyoonse zyakaambwa abasinsimi! ");
INSERT INTO dov_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Teensi zyakaleelede na kuti Kkilisito aswaanane amapenzi woonse aya na, akuti anjile mubulemu bwakwe?” ");
INSERT INTO dov_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mpawo kusangunina kuli Mozesi akubasinsimi boonse, Jesu wakali kubapandulwida zyoonse zyakalangene aawe mumalembe woonse ");
INSERT INTO dov_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kabali baamba kusika kugunzi eelyo nkukbakali kuyabuya, Jesu wakachita aanga uyanda skwinda kaya kunemboo. ");
INSERT INTO dov_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pesi bakamukombelezya, bakati, “Kkala aswebo, nkaambo lyaamba kuba goko zuba lyaamba kubbila.” Aboobo Jesu wakanjila wakkala aabo. ");
INSERT INTO dov_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chakachitika kuti, naakakkala aansi ambabo kuti balye, wakabweza chinkwa, wakachilongezya, wakachikwamuna mpawo wakabapedekezya. ");
INSERT INTO dov_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mpawo menso aabo akajulika, mpawo bakamuziba, mpawo tebakachilikumubona pe. ");
INSERT INTO dov_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bakati aakati kabo, “Myoyo yesu niyatapya mukati kesu, nalikwaambuula kulindiswe munzila, aawo nalikutujulila magwalo?” ");
INSERT INTO dov_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bakanyampuka mu wola ndileelyo babweda ku Jelusalema. Bakajana balikumi awumwi kababungene antoomwe, antoomwe abaabo mbibakali aabo, ");
INSERT INTO dov_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","bakalikuti, “Mwami wabuka nchobeni, alimwi walibonia kuli Sayimoni.” ");
INSERT INTO dov_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aboobo bakabaambila zintu zyakachitika munzila, akuti Jesu wakayubununwa byeni kulimbabo naakali kukwamuna chinkwa. ");
INSERT INTO dov_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kabachaambula zintu eezi, Jesu lwalkwe wakayimikila aakati kabo, wakati kulimbabo, “Luumuno alube kulindinywe.” ");
INSERT INTO dov_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pesi bakateketa akuzula kuyoowa, bakayeeya kuti babona cheelo. ");
INSERT INTO dov_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesu wakati kulimbabo, “Nkaambo nzi nimulikataazya? Nkaambo nzi mibuzyo niyazula mumyoyo yenu? ");
INSERT INTO dov_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Amulange maboko aangu amawulu aangu, kuti ndime nchoonzyo. Amundigume mubone. Nkaambo cheelo tachikwe nyama amafuwa, mulindibwene me ndilaazyo.” ");
INSERT INTO dov_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Naakaamba eezi, wakabatondeezya maboko amawulu aakwe. ");
INSERT INTO dov_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nibakachizwide lukondo lwiingi, alimwi okambagambide, Jesu wakatgi kulmbabo, “Mujisi chakulya na?” ");
INSERT INTO dov_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bakamupa chimpanzi chamuswi wakabizizigwe. ");
INSERT INTO dov_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesu wakachibweza, alimwi wakalya kunembo lyabo. ");
INSERT INTO dov_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wakati kulmbabo, “Nindakachili aandinywe, ndakamwaambila kuti zyoonse zilembedwe mumulawu wa Mozesi abasinsimi amuntembawuzyho zyeelede kuzuzikizigwa.” ");
INSERT INTO dov_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mpawo wakajula menso aabo kuti bamvwisisisye malembe. ");
INSERT INTO dov_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wakati kuli mbabo, “Aboobo kulilembedwe, kuti Kkilisitu welede kupenzegwa, akabuke lubo kubafu mubuzuba bwatatu. ");
INSERT INTO dov_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Alimwi kusanduka akulekelelwa kwazibi kweelede kukakambawukwe muzina lyakwe, kunyika zyoonse, kutalikila mu Jelusalema. ");
INSERT INTO dov_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mulibakamboni bazeezi zintu. ");
INSERT INTO dov_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Amulange ndilikutumina kulindinywe eecho Ndeende nchakasyomezya. Pesi amukkale mudolopo kusikila mukajane nguzu kuzwa kujulu.” ");
INSERT INTO dov_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mpawo Jesu wakabazulwida kunze mane bakusika afwiifwi aku Bbetani. Wakanyampula maboko aakwe, wakabalongezya. ");
INSERT INTO dov_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Zyakachitika kuti, naakachili kubalongezya, wakabasiya alimwi wakanyampwidwa kujulu. ");
INSERT INTO dov_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aboobo bakamukomba, mpawo bakabweeda ku Jelusalemu mulukondo lupati. ");
INSERT INTO dov_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bakakkala kabali muchikombelo kabalongezya Leza ");
INSERT INTO dov_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kumatalikilo kwakali Ijwi, mpawo Ijwi wakali aaLeza, aboobo Ijwi wakali Leza. ");
INSERT INTO dov_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ooyu wakali aaLeza kumatalikilo. ");
INSERT INTO dov_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Zyoonse zintu zyakaanzwa kwiindila mulinguwe, alimwi naatali nguwe nekutakwe chomwe chakaanzwa. ");
INSERT INTO dov_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mulinguwe momwakali buumi, alimwi buumi oobo bwakali mumuni wabantu. ");
INSERT INTO dov_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Imumuni ulamunika mumudima, alimwi mudima tuuzundide pe. ");
INSERT INTO dov_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kwakali mwaalumi wakatumidwe kuzwa kuli Leza, zina lyakwe wakali Joni. ");
INSERT INTO dov_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wakazide mbuli kamboni kuzoolungulula aatala amumuni, kuti boonse basyome kwiinda mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Joni taakali mumuni pe, pesi wakazide kuzoopa bukamboni aatala amumuni. ");
INSERT INTO dov_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Imumuni wamasimpe, uumunikila bantu boonse, wakalikuyobuza munyika. ");
INSERT INTO dov_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wakali munyika, inyika yakaanzwa kwiinda mulinguwe, aboobo inyika teyakamuziba pe. ");
INSERT INTO dov_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wakaza kulibakwe mwini, alimwi ibakwe mwini tebakamutambula pe. ");
INSERT INTO dov_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pesi kuli boonse bakamutambula, ibakasyoma muzina lyakwe, wakabapa cheelelo chakuba bana ba Leza. ");
INSERT INTO dov_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Aaba tebakazyalwa ku bulowa, nanka kukuyanda kwanyama, nanka kukuyanda kwa mwaalumi, pesi kukuyanda kwa Leza. ");
INSERT INTO dov_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ijwi wakaba mubili akupona aakati kesu. Twakabona bulemu bwakwe, bulemu bubaanga mbubwayooyo omwe alimwi alike wakazwa kuli Taata, uuzwide luzyalo a bwini. ");
INSERT INTO dov_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Joni wakamupeda bukamboni akukwiila nkati, “Ooyu ngonguwe ngundakali kuti, 'Ooyo uuza musule lyaangu mupati kwiinda ndime, nkaambo mutaanzi kulindime.'” ");
INSERT INTO dov_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nkaambo kuzwa mukuzulila kwakwe toonse twakatambula luzyalo kuzwa ku luzyalo. ");
INSERT INTO dov_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nkaambo mulawu wakapegwa kwiinda kuli Musa. Luzyalo a bwini zyakaza muli Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tawo pe wakali wabona Leza. Leza uumwi alike, uulikubbazu lya Taata, wakachita kuti Leza azibikane. ");
INSERT INTO dov_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Oobu mbobukamboni bwa Joni eelyo ma Juda nibakatuma bapayizi a baLevi kulinguwe kuzwa ku Jelusalema kuyomubuzya kuti, “Nduweni?” ");
INSERT INTO dov_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Wakaamba - teensi wakakaka pe, pesi wakaamba - “Teensi ndime Kkilisito pe.” ");
INSERT INTO dov_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eelyo bakamubuzisisya, “Nduweni mpo? Nduwe Elayija na?” Wakati, “Nsilinguwe pe.” Bakati, “Ulimusinsimi na?” Wakasandula wati, “Pe.” ");
INSERT INTO dov_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Mpawo bakayi kulinguwe, “Nduweni, kuchitila kuti tukape nsandulo kulibabo bakatutuma? Ulityeni nomwini?” ");
INSERT INTO dov_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wakati, “Ndili jwi, lyoompolola munkanda: 'Mululamike inzila ya Mwaami; mbuli Isaya musinsimi mbwakaamba.” ");
INSERT INTO dov_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lino bamwi benkamu ya baFalisi bakatumwa, ");
INSERT INTO dov_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","mpawo bakabuzya kulinguwe nkabati, “Nkaambonzi nobbabbatizya na kotali Kkilisito na Elayija na musinsimi?” ");
INSERT INTO dov_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Joni wakabasandula, wati, “Ime ndibbabbatizya aamanzi. Pesi aakati kenu kwiimvwi uumwi ngomutazi. ");
INSERT INTO dov_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngonguwe uyoobuza musule lyangu, ngwesikonzyi kwaangununa ntambo yansangu zyakwe.” ");
INSERT INTO dov_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Eezi zintu zyakachitwa mu Bbetani mutal aa Jodani, ooko Joni nkwakali kubbabbatizya. ");
INSERT INTO dov_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nebwakacha Joni wakabona Jesu nkayobuza kulinguwe mpawo wamwaambila kuti, “Langa, ngoyu mwana wembelele wa Leza uuugwisya zibi zyanyika! Ooyu ngonguwe ngundakali kuti, ");
INSERT INTO dov_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Ooyo uuza musule lyangu mupati kwiinda ndime.' ");
INSERT INTO dov_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Teensi ndakalimwizi p, pesi kuti ayubununwe kuli Izilayeli nchenchicho nchendakaza nkebbabbatizya amanzi.” ");
INSERT INTO dov_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Joni wakapa bukamboni nkati, “Ndabona Muuya nkaseluka mbuli nziba kuzwa kujulu akukkala alinguwe. ");
INSERT INTO dov_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tendamwizi pe, pesi ooyo wakandituma kubbabbatizya mumaanzi wandibuzya kuti, “Ali yooyo ngotabone Muuya kaseluka akukkala aalinguwe, ngonguwe uubbabbatizya muMuuya Uusalala.' ");
INSERT INTO dov_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ndabona aantomwe akupa bukamboni kuti ooyu Mwaana waLeza.” ");
INSERT INTO dov_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Alubo, zuba lyakatobela, aawo Joni kayimvwi abasikwiiya bakwe babili, ");
INSERT INTO dov_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","bakabona Joni Jesu kayobweend, mpawo Joni wakati, “Amubone, Mbelele ya Leza!” ");
INSERT INTO dov_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Basikwiiya bakwe bobile bakamumvwa nkawamba oobu mpawo bakatobela Jesu. ");
INSERT INTO dov_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mpawo Jesu wakacheba wababona nkabayobumutobela eelyo wakabaambila kuti, “Muyandaayi?” Bakasandula, “Rabbi” (chitolekelwa kuti “Muyiisi”), “Ukkala kuli?” ");
INSERT INTO dov_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wakabaambila kuti, “Musike muzoobone.” Mpawo bakayinka akuyoobona aawo mpakali kukkala, bakakkala anguwe zuba eelyo, nkaambo lyakali hola lyakkumi. ");
INSERT INTO dov_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Umwi wababili aaba wakamvwa Joni nkawambuula mpawo akutobela Jesu wakali Endulo, ngubazyalwa kumwi a Sayimoni Pita. ");
INSERT INTO dov_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Wakasanguna kubonana amwana wakwabo Sayimoni akumwaambila kuti, “Twamubona Mesiya” (chitolekelwa kut, Kkilisito). ");
INSERT INTO dov_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wakamweeta kuli Jesu aboobo Jesu wakamulanga akwaamba kuti, “Nduwe Sayimoni mwana wa Joni. Uyooyitwa kuti Sifasi” (chitolekeledwe: Pita). ");
INSERT INTO dov_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nebwakacha, aawo Jesu nakali kuyanda kuya ku Galilaya, wakajana Filipi mpawo wakamwaambila kuti, “Nditobele.” ");
INSERT INTO dov_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Eelyo Filipi wakalikuzwa ku Bbetisayida, idolopo lyaba Endulo a Pita. ");
INSERT INTO dov_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi wakajana Nataniyeli mpawo wamwaambila kuti, “Ooyo Mozesi ngwakalemba mumulawu, aba Sinsimi, twamubona: Jesu mwana wa Josefa, uuzwa ku Nazaleta.” ");
INSERT INTO dov_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyeli wakati kulinguwe, “Kuli chintu chibotu na chikonzya kuzwa mu Nazaleta?” Filipi wakati kulinguwe, “Kweza alimwi ubone.” ");
INSERT INTO dov_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesu wakabona Nataniyeli kayobuza kulinguwe mpawo waamba kuti aatala anguwe, “Bona, mu Izilayeli wamasimpe, utakwe lweeno!” ");
INSERT INTO dov_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyeli wakati kulinguwe, “Wandiziba biyeni?” Jesu wakasandula akwaamba kuti kulinguwe, “Nkatanakukwiita Filipi, nkoli munsi aamukkuyu, ndalikubwene.” ");
INSERT INTO dov_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyeli wakasandula, “Rabbi, uli mwana wa Leza! Uli Mwaami wa Izilayeli!” ");
INSERT INTO dov_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu wakamusandula nkati, “Nkaambo kakuti ndati kulinduwe, 'Ndakubona koli munsi aamukkuyu; ulasyoma na? Uchizoobona zintu zipati kwiinda eezi.” ");
INSERT INTO dov_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mpawo wakati, “Nchobeni, ndakwaambila kasimpe, uyoobona julu nkali julikide, abangelo ba Leza nkabatanta akuseluka aatala aMwana wa Muntu. ");
INSERT INTO dov_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nkakutanayinda mazuba otatwe, kwakaba muchado kuKkana ku Galili, mpawo banyina a Jesu bakaliko. ");
INSERT INTO dov_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu a basikwiya bakwe bakalitambidwe kumuchado. ");
INSERT INTO dov_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Lino wayini nakamana, banyina a Jesu bakati kuli nguwe, “Tabachikwe wayini.” ");
INSERT INTO dov_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu wakati kuli mbabo, “yomwanakazi, nkambonzi noza kulindime? Ichiindi changu tachina sika.” ");
INSERT INTO dov_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Banyina bakati kubalanda, “kufumbwa nchata mwambile, muchichite.” ");
INSERT INTO dov_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lino kwakali musanu ayimwi mpoto zyamabwe zyakali kubelesegwa a ma Juda kuma pobwe akusanzya, achimwi nkachili abulamfu kusikila kututatu. ");
INSERT INTO dov_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu wakabaambila kuti, “Ngamuzuzye mpoto zyamanzi.” Aboobo bakazuzya kusikila kulumpimpito. Mpawo wakabambila babelesi, ");
INSERT INTO dov_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Mubweze lino aakupa mupati wakwaaba.” Bakachita mbubobo. ");
INSERT INTO dov_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mupati wakwaba wakalabila maanzi akaba wayini, Pesi takaziba kwakazwa manzi ( Pesi babelesi bakatekede manzi bakalizi). Mpawo wakazwa sibwinga. ");
INSERT INTO dov_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mpawo wakaya kuli nguwe, “woonse muntu uupa wayini mubotu lutanzi alimwi ulamuulo uselukide wayini nibakolwa. Pesi kabambala wayini mubotu kusikila lino.” ");
INSERT INTO dov_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Echi chitondezyo nchitanzi Jesu nchakachita mu Kkana ya Galili, alubo wakayubununa bulemu bwakwe, antomwe abasikwiya bakwe bakasyoma mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Musule lyazeezi Jesu, abanyina, abana bakwabo, mpawo abasikwiya bakaselukila ku Kapenawumu alimwi bakakukkala kwamazuba mache biyo. ");
INSERT INTO dov_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lino i Pasika lyaba Juda lyakali afwifwi, mpawo Jesu wakatanta akuya ku Jesu Jelusalemu. ");
INSERT INTO dov_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Wakajana basambali baaba sune ambelele abasambali benkwilimba muchikombelo, abasikula bakalikkede mumo. ");
INSERT INTO dov_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Lino wakachita chimboko chakoosa akubatanda boonse aanze kuzwa muchikombelo, kubika antomwe ambelele ang'ombe. Wakamwayusya makobili amali zyabawuli mpawo wasowa matafula. ");
INSERT INTO dov_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kubasambazyi bankwilimba wakati, “mubweze zintu zizwe awa. Muleke kuchita ing'anda ya Taata chisambalilo.” ");
INSERT INTO dov_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Basikwiya bakwe bakayeeya kuti zyakalilembedwe, “busungu bwakumaandenu bwandisyukuta.” ");
INSERT INTO dov_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Alimwi ba Juda bendelezi bakaziswilila mpawo bakati kuli nguwe, “Nchitondezyoyi nchotatutondezye?” ");
INSERT INTO dov_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu wakasandula, “Amumwayule chikombelo, mpawo mumazuba otatwe ndachimika lubo.” ");
INSERT INTO dov_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lino bendelezi baba Juda bakati, “Eechi chikombelo chakayakwa muminyaka ilimakkumi oone - amusanu - alimwi, mpawo ulibusya mumazuba otatwe?” ");
INSERT INTO dov_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nikuba kuti, wakalikwambula ataala achikombelo chamubili wakwe. ");
INSERT INTO dov_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kunembo akubusigwa kuzwa kulufu, basikwiya bakwe kabayeya kuti wakalambide, mpawo bakasyoma kumalembe akutwambo ntwaakamba Jesu. ");
INSERT INTO dov_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lino kali mu Jelusalemu kupobwe lya pasika, kali kupobwe, biingi bakasyoma muzina lyakwe nibakabona zitondezyo nzyakachiita. ");
INSERT INTO dov_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pesi Jesu takabasyoma nkambo wakalibezi boonse, ");
INSERT INTO dov_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","nkambo takayanda kuti naba omwe ape bukamboni atala a muntu, nkambo wakalizi chakali mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Lino kwakaliwo mu Falisi wakali kutegwa Nikkodimasi, muzululi wama Juda. ");
INSERT INTO dov_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ooyo mwaalumi wakaza kuli Jesu mansiku, mpawo wakati kulinguwe, “Muyiisyi kuti uli muyiisyi wakazwa kuli Leza, nkaambo tawope ukonzya kuchita zitondeezyo eezyo chita ado Leza ulaanguwe. ");
INSERT INTO dov_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu wakasandula kuli nguw, “Nkasimpe, kasimpe ado muntu wazyalwa bupya lubo takonzyi kubona bwami bwa Leza.” ");
INSERT INTO dov_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikkodemasi wakati kulinguwe, “Mbubuli muntu mbwakonzya kuzyalwa nkali wachembaala? Tachikonzyoi kunjila lwabili mutumbu lyabanyina mpawo akuzyalwa, ulakonzya na? ");
INSERT INTO dov_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu wakasandula, “Nkasimpe, nkasimpe ado muntu wazyalwa amaanzi amuuya, takonzyi kunjila mubwami bwa Leza. ");
INSERT INTO dov_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Eecho chizyalwa kunyama ninyama, mpawo eecho chizyalwa kumuuya muuya. ");
INSERT INTO dov_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Utagambi eecho nchindakwaambila, uyeelede kuzwalwa bupya. ");
INSERT INTO dov_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Luuwo luloonga kufumbwa nkuluyanda; ulamvwa muzuumo pesi tokonzyi kuziba nkulwazwa nekunba nkuluya. Nkikaako woonse muntu ooyo uzyalwa amuuya mbwabede. ");
INSERT INTO dov_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikkodemasi wakasandula kuti, “Mbubuli mbuzikonzya kuba zintu eezi?” ");
INSERT INTO dov_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu wakasandula wati kulinguwe, “ Uli mwiiyi wa Isiolayili na aboobo tomvwisyi zintu eezi? ");
INSERT INTO dov_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nkasimpe, nkasimpe ndakwaambila, twaambwa nzitwizi, mpawo tupa bumboni aatala anzitwakabona. Aboobo totambuli bumboni bwesu. ");
INSERT INTO dov_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Na ndakaambide aatala azintu zyanyika mpawo twasyoma, mbuli mbokonzya kusyoma na ndakwambila ataala azintu zyajulu? ");
INSERT INTO dov_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tawope wakaliinkide kujulu kunze kwayooyo wakaseluka kuzwa kujulu- Mwana aa Muntu. ");
INSERT INTO dov_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mbubonya mbuli Mozesi mbwakasumpula nzoka munkanda, mbobonya Mwana aa Muntu mbwayosumpulwa, ");
INSERT INTO dov_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kuti boonse basyoma bakabe abuumi butamani. ");
INSERT INTO dov_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mbuli Mozesi mbwakasumpula nzoka munkanda, mbombubo Mwana aa Muntu mbwazoosumpulwa, kuchitila boonse basyoma mulinguwe kuti babe aabuumi butani. ");
INSERT INTO dov_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Oobuya Leza mbwakayandisya nyika, eelyo wakiipa Mwana wakwe simuzyalwa aalike kuti kufumbwa uumusyoma mulinguwe atafwidilili pesi kuti aabe aabumi butamani. Obuya Leza takatuma Mwana munyika kuti azoobeteke nyoka, pesi kuti azoofutule nyika kwiinfa mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ooyo usyoma muli nguwe takoyoobetekwa, pesi ooyo utasyomi wabetekwa kale nkaambo taasyoma muzina lya Mwana alike wa Leza. ");
INSERT INTO dov_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Aaka nkikaambo kakutonga: Mumuni wasika munyika mpawo bantu bayanda mudima kwiinda mumuni nkaambo nchito zyabo nzyabubi. ");
INSERT INTO dov_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Woonse uuchita bubi wasula mumuni aboobo tasiki kumumuni, kuchitila nchito eezi kuti zitabonwi. ");
INSERT INTO dov_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nikuba kuti, ooyo uuchita kasimpe wasika kumumuni kuchitila zilaantanganana ziboneke eezyo nchito kuti zyachoitwa muli Leza. ");
INSERT INTO dov_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Musule acheechi, Jesu abasikwiiya bakwe bakayinka munyika ya Judiya. Ooko wakakukkala kkala antoomwe ambabo akubbabbatizya. ");
INSERT INTO dov_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lino Joni alakwe wakali kubbabbatizya mu Ayinoni afwiifwi ku Salimu nkaambo kwakali meenda mayingi nkuko. Bantu bakalikusika kulinguwe mpawo bakali ku bbabbatizigwa, ");
INSERT INTO dov_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","nkaambo Joni takalina waalwa muntolongo. ");
INSERT INTO dov_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Lino aawo kwakabuka lukazyano aakati kabasikwiiya ba Joni aba Juda aatala aapobwe lyakusanzyania. ");
INSERT INTO dov_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bayiinka kuli Joni mpawo bamwaambila kuti, “Labbi, ooyo wakali aanduwe kulimwi bbazu lyamulonga wa Jodani, aatala ayooyo ngwakalungulula, laanga, uliiku bbabbatizya mpawo boonse balikwiinka kulinguwe.” ");
INSERT INTO dov_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Joni wakasandiula, “Muntu takonzyi kutambula chintu na chapegwa kulinguwe kuzwa kujulu. ");
INSERT INTO dov_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Iwe lwako omwini ulanzya kupa bukamboni bwacheecho nchindakaamba, pesi kuti takatumwa kunembo lyakwe. ");
INSERT INTO dov_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mulumi ngwaasibwiinga. Lino muzolwani wasibwiinga, ooyo uyiimikila akuswiilila nguwe, ulabotelwa kapati nkkambo kajwi lyasibwiinga. Eechi lino, ndo0lukondo lwangu ngalwazulila. ");
INSERT INTO dov_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Weelela kuti kusumpulwa mebo ndifwiinsigwe. ");
INSERT INTO dov_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ooyo uzwa kujulu ulaajulu azyoonse. Ooyo uzwa aansi uzwa aansi mpawo wambuula aatala aansi. Ooyo uzwa kujulu uli aajulu azyoonse. ");
INSERT INTO dov_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ulungululua aatala acheecho nchakabona anchakamvwa, pesi taakwe uzumina bukamboni bwakwe. ");
INSERT INTO dov_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ooyo utambula bukamboni wazuminina kuti Leza nkasimpe. ");
INSERT INTO dov_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ooyo Leza ngwatuma wambuula majwi aa Leza. Pesi tapi mweelo wamuuya. ");
INSERT INTO dov_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Taata uyanda Mwana mpawo wakamupa zyoonse zintu mumaboko aakwe. ");
INSERT INTO dov_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ooyo usyoma ku Mwana uli aabuumi butamani, pesi ooyo ukaka Mwana takwe kuyoobona buumi, pesi bukali bwa Leza bulakkala aalinguwe.” ");
INSERT INTO dov_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Awo Jesu nakaziba kuti ba Falisi bakamvwa kuti wakalikuba abasikwiya biingi mbakali kubbabaatizya kwinda Joni ");
INSERT INTO dov_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(nekuba kuti welwakwe mwini tensi wakali kubbabbatizya pe, pesi basikwiya bakwe mbabo bakali kubbabbatizya), ");
INSERT INTO dov_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","wakazwa mu Judiya wabweda lubo ku Galilaya. ");
INSERT INTO dov_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pesi chakalelede kuti ayinde mu Samaliya. ");
INSERT INTO dov_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Elyo wakasika mumunzi wamu Samaliya utegwa Sychal afwifwi achipanzi chanyika eyo Jakobo njakali wapa mwanakwe Josefa. ");
INSERT INTO dov_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chikala cha Jakobo chakaliwo. Jesu wakali wakatala kuzwa mulwendo lwakwe mpawo wakakkala kumbali achikala. Lyakali sikati. ");
INSERT INTO dov_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Umwi mukayintu mu Samaliya wakaza kuzoteka manzi, elyo Jesu wakati kulinguwe, “Ndipe manzi nwe”. ");
INSERT INTO dov_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Nkambo basikwiya bakwe bakali banjila mumunzi kuyowula kulya. ");
INSERT INTO dov_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mpawo mukayintu mu Samaliya wakamwambila kuti, “Chikonzeka buti, kuti webo nomu Juda undikumbile chakunywa imebo ndemukayintu mu Samaliya”. nkambo ma Juda tabakwe bulidilano pe ama Samaliya. ");
INSERT INTO dov_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu wakasandula wati, “ anoli walizi chipo cha Leza, akuti ngwani ukukumbila manzi, wayinokumbila nduwe, nkekupa manzi mawumi”. ");
INSERT INTO dov_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mukayintu, wakati kulinguwe, “ Yomwalumi, tokwe chakutesya pe mpawo chikala nchilamfu. Ani mpo ulaajanayi ayo manzi abuumi? ");
INSERT INTO dov_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tooli mupati, mbubo na, kwinda taata Jakobo, wakatupa chikala akunwa kuli nchicho lwakwe mwini, abana bakwe ambono zyabo? ");
INSERT INTO dov_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu wakasandula wati kulinguwe, “woonse unywa manzi amuchikala echi uyoba anyota lubo. Kufumbwa unywa manzi nginjomupa takoyoba a nyota limbi. ");
INSERT INTO dov_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pesi, manzi ngesikamupe ayoba kasensa kamanzi mulinguwe, kakunka mane kukabekutamani”. ");
INSERT INTO dov_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mukayintu wakati kulinguwe, “ Mwami, ndipe manzi ayo kuchitilakuti nsikabi anyota akuti nsizoboli lubo kuzoteka manzi awa.” ");
INSERT INTO dov_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu wakati kulinguwe, “ koya, ukite mulumako, mpawo ubolano” ");
INSERT INTO dov_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mukayintu wakati kulinguwe, “nsikwe mulumi pe”. Jesu wakati, “waamba kasimpe kuti nsijisi mulumi pe”. ");
INSERT INTO dov_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nkambo wakala baalumi musanu, ooyo ngolawe lino temulumako pe. Nzwawamba zilisinizizye.” ");
INSERT INTO dov_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mukayintu wakati kulinguwe, “mwami ndabona kuti ulimusinsimi. ");
INSERT INTO dov_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mataata esu bakali kukomba muchilundu echi pesi muti Jelusalema mbobusena bantu nkubelede kukombela.” ");
INSERT INTO dov_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu wakati kuli nguwe, “yomukayintu ndisyome, chindi chilasika awo nemutakakombe Taata kutali muchilundu echi nabi mu Jelusalemu. ");
INSERT INTO dov_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mukomba nchomutazi. Swebo tukomba nchetuzi, nkambo lufutuko luzwa kuba Juda. ");
INSERT INTO dov_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nekubaboobo chindi chilasika, nchenchichechi, awo bakomba mukasimpe mpobayomukomba Taata mumuya amubwini, nkambo Taata mbembabo bantu mbayandula kuti babe basikumukomba. ");
INSERT INTO dov_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Leza ngumuya, aboobo bantu bamukomba belede kumukomba mumuya amubwini”. ");
INSERT INTO dov_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mukayintu wakamwambila kuti, “ndilizi kuti Mesiya uyobuza( ooyo utegwa Kilisito)”. Nazosika uzotupandulwida zyonse. ");
INSERT INTO dov_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesu wakamwambila kuti, “ndendime nguwe oyu uwambula ayebo”. ");
INSERT INTO dov_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aleecho chindi basikwiya bakwe bakaboola. Elyo bakagamba kuti nkamboyi nambula amukayintu, pesi taakwe wakamba kuti, “uyandayi?” na kuti “Nkamboyi nambula awe?” ");
INSERT INTO dov_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Awo mukayintu ooyu wakasiya noongo yakwe yamanzi, wabweda kumunzi, wakwambila bantu, ");
INSERT INTO dov_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“kamuza, muzobone mwalumi wandambila zintu zyonse nzendakachita. Oyu tekujana waba Kilisito na, nkujana waba nguwe?” ");
INSERT INTO dov_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bakazwa mumunzi baza kulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Achindi nchichecho, basikwiya bakwe bakali kumukombelezya kuti “Rabbi, lya” ");
INSERT INTO dov_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pesi wakati kulinguwe, “Ime ndakulya nkomutazi atala ankuko.” ");
INSERT INTO dov_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Awo basikwiya bakakazyania akati kabo, “Takwe muntu wamwetela kulya pe, mpali na?” ");
INSERT INTO dov_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu wakati kulimbabo, “kulya kwangu nkuchita luyando lwayoyo wakandituma akumaninsizya mulimu wakwe. ");
INSERT INTO dov_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Sa tamwambi kuti, 'kuchili myezi yoone nekutakabe goloka'? Ndokumwambila kuti, amunyampule meso anu mulange myunda, nkambo yabizwa kale yelela kutebulwa! ");
INSERT INTO dov_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oyo utebula utambula chakufola akubungika michelo yabumi butamani, kuchitila kuti oyo ubyala ayooyo utebula bakakondwe antomwe. ");
INSERT INTO dov_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mulichechi kalasinizya kambyo kati, “umwi ulabyala utebula ngumbi”. ");
INSERT INTO dov_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ndakamutuma kuyotebula nchemwakata lima. Bamwi bakalima, inywe mwakanjila mumilimu yabo. ");
INSERT INTO dov_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bantu biingi bamu Samaliya bamumunzi oyu bakamusyoma nkambo ka mbakalungulula mukayintu wakali kupa bukamboni, “wandambila zyonse nzendakachita”. ");
INSERT INTO dov_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bantu bamu Samaliya nibakasika kulinguwe, bakamu kumbila kuti akkale aboo, wakakkala mumunzi oyu kwamazuba aabili. ");
INSERT INTO dov_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kwakaba bambi biingibakamusyoma nkambo kajwi lyakwe. ");
INSERT INTO dov_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bakati kumukayintu ooyu, “Tatuchisyomi nkambo kanzwawamba pe, pesi nkambo swebo tobeni twalimvwida, mpawo twaziba kuti nsonzyo oyu mufutuli wanyika” ");
INSERT INTO dov_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nakiinda mazuba aya obile oko waya ku Galilaya. ");
INSERT INTO dov_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nkambo Jesu lwakwe mwini wakamba kuti musinsimi takwe bulemu muchisi mwazwa. ");
INSERT INTO dov_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nakasika mu Galilaya, bantu bamu Galilaya bakamutambula. Bakali bazibona zyonse nzyakali wachita mu Jelusalemu chindi chapobwe, nkambo abalabo bakaliko kupobwe ");
INSERT INTO dov_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Alimwi wakaboola lubo ku Kenani mu Galilaya, oko nkwaka sandula manzi kuba wayini. Elyo kwakali umwi sichuno ulemekwa wakala mwana wakali kuchiswa mu Kapenawume. ");
INSERT INTO dov_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nakamvwa kuti Jesu wasika mu Galilaya kuzwa mu Judiya, wakaya kuli Jesu akumukumbila kuti aakaponie mwana wakwe, wakali wamba kufwa. ");
INSERT INTO dov_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu mpawo wakati kuli kulinguwe, “Ado mubone zitondezyo azigambyo, tamukosyoma”. ");
INSERT INTO dov_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ooyu sichuno wakamwambila kuti, “Mwami, boola natana fwa mwanangu”. ");
INSERT INTO dov_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesu wakati kuli nguwe, “kooy. Mwanako ulapona”. Ooyu mwalumi wakasyoma majwi Jesu ngakamba kulinguwe, mpawo wakenda. ");
INSERT INTO dov_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nakachili kuyobwenda wakaswanana aabalanda bakwe, bakamwambila kuti, mwanakwe muponi. ");
INSERT INTO dov_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Elyo wakababuzya chindi mwanakwe nakatalika kumvwa kabotu. Bakamwambila kuti, “jilo sikati nakapona” ");
INSERT INTO dov_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mpawo wisi wakayibalukwa kuti nchechindi awo Jesu, “Mwana wako wapona.” Elyo we lwakwe mwini abanganda yakwe bakasyoma. ");
INSERT INTO dov_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Echi chakaba chitondezyo chabili echo Jesu nchakachita nakazwa mu Judiya kaya mu Galilay. ");
INSERT INTO dov_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nikwakamana aya kwakaba pobwe lya maJuda, alakwe Jesu wakayinka kuJelusalema. ");
INSERT INTO dov_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Elyo muJelusalema afwifwi amulyango wambelele kwakali kalambw, kitwa kuti muchi Alamayiki Betesida, kwakayakidwe nganda ilamanda alimusanu. ");
INSERT INTO dov_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ibantu bingi bakali kuchiswa, boofu, bateendi, abalebukide bakalikulinda mpawawo. ");
INSERT INTO dov_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nkambo mungelo wakali kuseluka akukopa manzi mulizimwi zyindi elyo kufumbwa walikunjila imanzi nkachikopegwa wakali kupona kuzwa kubulwazi fumbwa mbwali kuchiswa. ");
INSERT INTO dov_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Awo kwakali umwi mwalumi wakali kuchiswa kwaminyaka ilimakkumi otatwe amusanu ayitatu. Awo Jesu nakamubona nkalede ");
INSERT INTO dov_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","mpawaw, nkali waziba kuti waliwawo kwachindi chilamfu. Wakati kulinguwe, “ulayanda na kuponesegwa?” ");
INSERT INTO dov_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mulwazi wakati, “Mwami, nsikwe muntu wakundinjizya mudambwa awo manzi na kopanisigwa, awo nenti njile, umwi anga wandindila kunjila.” ");
INSERT INTO dov_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesu wakamwambila kuti, “Nyampuka, bweza buulo bwako, uyende.” ");
INSERT INTO dov_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mpawawo oyu mwalumi wakapona, mpawawo wakabweza buulo bwakwe elyo wakenda. Yino obo buzuba bwakali kutegwaSabata. ");
INSERT INTO dov_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Aboobo bamaJuda bakamwambila kuti oyu mwalumi wakaponesegwa, “ Sunu niSabata tozumizigwi pe kubweza buulo bwako.” ");
INSERT INTO dov_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wakati, “Oyo wandiponia wati kulindime, 'bweza buulo bwako wende.”' ");
INSERT INTO dov_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bakamubuzya kuti, 'ngwani mwalumi oyu mwalumi wakubuzya kuti, bweza buulo bwako uyende'?” ");
INSERT INTO dov_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nekuliboob, iwakasilikwa takamwizi pe kuti ngwani nkambo Jesu wakazwebeleka wanjila mubantu, mukuti kwakali bantu bingi abusena oobu. ");
INSERT INTO dov_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kuzwawo, Jesu wakamujana mutempele wamwambila kuti “boona, wapona! Utakabisyi limbi, kuchitila kuti zibi kwinda awa zitakakuchitikili.” ");
INSERT INTO dov_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Imwalumi oyu wakazwa waya kuyobuzya maJuda kuti nguJesu wamuponia. ");
INSERT INTO dov_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ino nkambo kazezi zintu maJuda bakapenzegwa Jesu, mukuti wakachita zintu ezi muzuba litegwa Sabata. ");
INSERT INTO dov_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesu wakati kulimbabo, “ Taata ulokubeleka ayin, aboobo ambebo, ndookubeleka.” ");
INSERT INTO dov_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nkambo kazez, maJuda bakayindilila kuyanda kumujaya mukuti takatyola Sabata biyo pe, pesi akuti lubo wakita Leza nkati nguwisi mwini, kulyelanisya aLeza. ");
INSERT INTO dov_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesu wakabasandula, “Nchobeni, imwana takonzyi kuchita chintu mwini, ado biyo zyabona Taata nkachita, nkambo kufumbwa Taata nchalokuchita, Imwana uchita munzila njiyo. ");
INSERT INTO dov_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nkambo Taata ulamuyanda Mwana aboobo ulamutondezya zyonse nzyachita mwini, akumutondezya zintu zipati kwinda ezi kuti mugambe. ");
INSERT INTO dov_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mbubo Taata mbabusya bafwide akubapa buumi, aboobo alakwe Mwana ulapa buumi kuli kufumbwa ngwasal. ");
INSERT INTO dov_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nkaambo Taata takwe ngwabeteka, pesi wakapa lubeta loonse kuMwami. ");
INSERT INTO dov_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kuchitila kuti bantu boonse bakalemye Mwana mbuli mbobalemya Taata. Oyo utalemyi Mwana talemyi Taata wakamutuma. ");
INSERT INTO dov_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nchobeni, nchobeni, Oyo umvwa ijwi lyangu akumusyoma wakandituma ulabuumi butamani mpawo tayopegwa mulandu, pesi winda kuzwa kulufu kuya kubuumi. ");
INSERT INTO dov_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nchobeni, nchobeni, ndamwambila chindi chiyobuza, ayino nchenchichechino, awo bafwide mpobayomvwa ijwi lyamwana Leza, abaabo bamvwa bayo pona. ");
INSERT INTO dov_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nkaambo mbuli Taata mbala buumi mulinguwe mbubo mbapede Mwana kuti abe abuumi muli nguw, ");
INSERT INTO dov_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mpawo Taata wakapa mwana bwendelezi bwakubeteka nkambo mwana wa muntu. ");
INSERT INTO dov_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mutagambi aatala azez, nkaambo kulichindi chiyobuza mulinchicho woonse muntu ulimuchumbwe mpayo limvwa ijwi lyakwe ");
INSERT INTO dov_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mpawo bayozwa aboobo bakachita kabotu kububuke bwamwami aabobo bakachita bubi kububuke bwalubeta. ");
INSERT INTO dov_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nsikonzyi kuchita chintu lwangu. Mbuli mbomvwa ndabeteka, mpawo kubeteka kwangu kuliluleme nkaambo nsiyobuyandula luyando lwangu pesi luyando lyayoyo wakanditum. ");
INSERT INTO dov_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ikuti ndalipeda bukamboni lwangu ndemwin, bukamboni bwangu tabunosinizyi pe. ");
INSERT INTO dov_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kuli umwi upeda bukamboni atala andime mpawo ndizizi kuti bukamboni mbwapa atala anduwe bulisinizizye. ");
INSERT INTO dov_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mwakatuma bantu kuli joni mpawo wakapa bukamboni businizizye. ");
INSERT INTO dov_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pesi bukamboni mbotambula tabuzwi kumuntu. Ngwamba zintu ezi kuti mukonzye kufutulwa. ");
INSERT INTO dov_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Joni wakali lampi lyakali kuyaka akumunik, mpawo mwakanda kukondwa mumumuni wakwe kwakindi. ");
INSERT INTO dov_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pesi ibukamboni mbondabo mbupati kwinda bwa Jon, nkaambo imilimu eyo ");
INSERT INTO dov_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taata njandipa kuti njimanisizy, njiyo milimo njechit, indipede bukamboni kuli Taata wakandituma. Taata wakandituma lwakwe mwini wakandipeda bukambon. ");
INSERT INTO dov_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tamuna kumumvwida jwi nanka kumubona chimo chakwe naba achili chind. Tamukwe ijwi likkalilide pe mulindinyw, nkaambo tamulikusyoma pe muliyooyo ngwakatum. ");
INSERT INTO dov_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mulayandula magwalo nkaambo muyeye kuti muli ngawo mulibuumi butaman, mpawo ngayaya magwalo apeda bukamboni aatala andime. ");
INSERT INTO dov_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Inywe tamukwe chiyandisyo chakuza kulindime kuti mukonzye kuba abuumi. ");
INSERT INTO dov_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nsitambuli mulema buzwa kumuntu, ");
INSERT INTO dov_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42",", pesi ndilizi kuti tamukwe luyando lwa Leza pe mulindinywe. ");
INSERT INTO dov_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ndasika muzina lya Taat, inywe inywe tamunditambuli pe. Ikuti umwi wasika muzina lyakw, mulakonzya kumutambul. ");
INSERT INTO dov_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mbobuli mbomunga mulasyom, inywe nomutambula bulemu kuzwa kulibamwi banu pesi tamuyanduli bulemu buzwa kuli Leza alike? ");
INSERT INTO dov_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mutayeyi kuti lwangu ndemwini njomupa mulanda kunembo lya Taata. Uyomupa mulanda ngu Musa, mulinguwe mumwakabikide bulangizi. ");
INSERT INTO dov_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ikuti mwakamusyoma Mus, mwayinondisyoma ambeb, nkambo wakalemba atala ambebo. ");
INSERT INTO dov_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ikuti kamutasyomi malembe akw, mbobuli mbomuyosyoma majwi angu?” ");
INSERT INTO dov_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nikwakayinda zintu ezi, Jesu wakayinka bubambene alwizi lwaku Galili, lwambwa kuti lwizi Tebeliyasi. ");
INSERT INTO dov_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Inkamu mpati yakamutobela nkaambo bakabona zitondezyo zyakali kuchita kuli bakachisidwe. ");
INSERT INTO dov_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","(Jesu wakaya kuchilundu oko wakaakukkala ansi abasikwiiya bakwe. ");
INSERT INTO dov_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lino Pasika, pobwe lyaba Juda, lyakali aafwifwi.) ");
INSERT INTO dov_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Elyo Jesu wakalanga kujulu wakabona makamu makamu aleza kuli nguwe, wakaamba kuti kuuli Filipo,” nkuukuuli nkutunga tulawula chinkwa kuti balye aaba?.” ");
INSERT INTO dov_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","( Pesi Jesu wakaamba ezi kuti asunke Filipo, wee wakalizi kuti niinzi nzyatachite.) ");
INSERT INTO dov_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo wakamusandula, “myaanda yobile yampondo tiikokwana pe kuti umwi awumwi ajane nikati kucheya.” ");
INSERT INTO dov_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Umwi wabasikwiiya, Andileya mukulana wa Simoni Pita, wakaamba kuti kuli Jesu, ");
INSERT INTO dov_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","kuli kalombe okiya kalaazinkwa zili musanu zinkwa zyabbali atuswi tubili, pesi niinzi ezi akati kabiingi?” ");
INSERT INTO dov_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesu wakati,” chita kuti bantu bakkale aansi, bakali mweelwe wazyuulu zili musanu. ");
INSERT INTO dov_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mpawo Jesu wakabweza zinkwa alimwi naakamana kupa kulumba wakapa abo bakakkede ansi. Wakachita bukozyeniye akunswi, kazili zyiingi mbuuli mbubakayandide. ");
INSERT INTO dov_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bantu nibakakkuta, wakati kuli basikwiiya bakwe,” amubunganiye bufwefwelenga bwachaala, mpawo kaatakwe buta bulike pe.” ");
INSERT INTO dov_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mpawo bakabunganiya bufwefwelenga bazuzya nsuwo zili kkumi azibili kuzwa bufwefwelenga bwazinkwa zili musanu zyabbali twachaala nibali kulya. ");
INSERT INTO dov_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mpawo, bantu nibakabona ezi zitondeezyo nzyaakachita, bakati, “Akakasimpe kuti musinsimi usikide munyika.” ");
INSERT INTO dov_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesu naakaziba kuti baamba kusika kukumujata changuzu akumuchita mwami, wakabweeda kuchilundu alikke. ");
INSERT INTO dov_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nilyakaba mansiku, basikwiiya bakwe bakaya munsi aalwizi. ");
INSERT INTO dov_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bakanjila mubwaato, bakaya bweenda atala alwizi lwaku Kkapenawumi. kwakali kwasikila kuli cheecho chiindi, alimwi Jesu takayinaasika pe kulimbabo. ");
INSERT INTO dov_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Iguwo lili anguzu lyakabawuma, elyo lwizi lwaka yuuntana. ");
INSERT INTO dov_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nibakakwasula mamayela asikabe makkumi abili amusanu naa makkumi atatu amamayeli bakabona Jesu Jesu uleenda atala alwizi alimwi kazabuza kubwaato, eelyo bakayoow. ");
INSERT INTO dov_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pesi wakaamba kuti kuli mbabo, “Ndime! mutayoow.” ");
INSERT INTO dov_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mpawo bakayandisya kumutambula mubwaat, aboobo bwaato bwakafwambana kuyosika anyika nkubakali kuya. ");
INSERT INTO dov_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Izuba litobela, inkamu yakayimvwi mumbali aalwizi yakabona kuti takuchikwe bwaato kunze kwabumwi, Jesu mbwatanjila abasikwiiya bakwe pesi basikwiiya bakwe bakayinka abalikke. ");
INSERT INTO dov_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nikuba boobo, kwakali aamwi maato akazwa kuli Tibbeliyasi kubambene abusena nkubakali kuula zinkwa naakamana kupa kulumba mwaami. ");
INSERT INTO dov_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nkamu niyakaziba kuti naa Jesu naa basikwiiya bakwe bakaliwo, abalabo bakanjila mubwaato elyo bakaya ku kkapenawume kuya bulanguula Jesu. ");
INSERT INTO dov_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nibakamujana kubbazu limwi lya lwizi bakaamba kuti kuli nguwe,” Muyiisi, wakasika lili okuno?” ");
INSERT INTO dov_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu wakabasandula, wati,” kasimpe, mulandilanguula, kutali kuti mwaba zitondeezyo pe, pesi nkaambo kakuti mwakalya zinkwa akukkuta zinkwa alimwi mwaka kkuta. ");
INSERT INTO dov_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mutabelekeli kulya kumana, pesi mubelekele kulya kutola kubuumi butamani buumi Mwana a Muntu mbwayomupa, aboobo Leza Taata uyodinda chidindo chakwe alimbabo. ");
INSERT INTO dov_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mpawo bakaamba kuti kulinguwe,” nchinyamaanzi nchitweelede kuchit, kuchitila kuti tuchite mulimu wa Leza?” ");
INSERT INTO dov_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu wakasandula akwaamba kuti kuli mbabo,” Oyu ngumulimu wa Leza: kuti musyome oyo ngwakatuma.” ");
INSERT INTO dov_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Mpawo bakaamba kuti kuli nguwe,” Nchichili chitondeezyo nchutachite, kuchitila kuti tubone akusyoma? Ulachita buyeni? ");
INSERT INTO dov_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","BamaTaata bakalya mana munkanda, mbuuli mbukulembedwe, 'wakapa zinkwa kuzwa kujulu kuti balye. ");
INSERT INTO dov_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Mpawo Jesu wakabasandula wat, “nkasimpe, nkasimpe, tali Mozesi pe wakamupa zinkwa kuzwa kujulu, pesi ngu Taata uumupa zinkwa zinkwa chini chini chizwa kujulu. ");
INSERT INTO dov_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aboobo chibunge cha Leza nheecho chisika aansi kuzwa kujulu akupa buumi kunyika.” ");
INSERT INTO dov_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Mpawo bakamwaambila kuti,” Mwaalumi, kotupa chinkwa echi lyoonse. ");
INSERT INTO dov_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesu wakabaambila kuti, “ndime chinkwa chabuumi; oyo uuza kulindime tachiyoobi anzala limbi, ayooyo uusyoma mulindime takoyobaa anyota limbi. ");
INSERT INTO dov_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pesi ndamwaambila obu kuti mulindibwene, alimwi tamusyom. ");
INSERT INTO dov_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Boonse mbaandipa Taata balasika kuli ndime abo baza kulindime, tandibasweeli aanzepe. ");
INSERT INTO dov_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ndakasika aansi kuzwa kujuli, pe kuchita luyando lwangu, pesi kuyanda kwayooyo wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Oku nkuyanda kwayooyo wakandituma, kuti nditasweekelwi omwe aabo mbakandipa, pesi ndiyoobabusya kubuzuba bwamamanino. ");
INSERT INTO dov_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Eno olu ndoluyando lwa Taata, ikuti umwi awumwi uubona Mwana akusyoma mulinguwe uyooba abumi butamanini alimwi ndiyomubusya mubuzuba bwamamanino. ");
INSERT INTO dov_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mpawa ba Juda bakatongawuka aatala anguwe nkambo wakamba kuti,” ndichinkwa chakazwa kujulu.” ");
INSERT INTO dov_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bakaamba kuti,” saa tali ooyu Jesu mwana wa Jozefu, wisi abanyina mbituzi, mpaali mpaambila obo, ' Ndaza aansi kuzwa kujulu?” ");
INSERT INTO dov_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu wakasandundulu akubaambila kuti,” amuleke kutongawuka akati kanu ");
INSERT INTO dov_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","tawope naba omwe uuza kulindime anukuti Taata wakandituma wamweeta, aboobo ndomubusya mubuzuba bwama maninino. ");
INSERT INTO dov_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kuli lembedwe mubasinsimi,” ikuti boonse balooyisigwa a Leza. Umwi awumwi wakamvwa akwiiya kuli Taata ulaza kulindime. ");
INSERT INTO dov_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Taakwe wakabona Taata kunze kwayooyo wakazwa kwa Leza wakabona Taata. ");
INSERT INTO dov_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nkasimpe, nkasimpe, ooyo usyoma ulaabumi butamani. ");
INSERT INTO dov_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ndichinkwa chabuumi. ");
INSERT INTO dov_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bamawuso bakalya mana munkanda, aboobo bakafwa. ");
INSERT INTO dov_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Echi chinkwa chizwa kujulu, lino kuti muntu wachilya tafwi. ");
INSERT INTO dov_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ndichinkwa chabuumi chakaza aansi kuzwa kujulu. Kuti naa umwi wachilya chinkwa eechi, uyoopona lyoonse. Chinkwa nchipa ngomubili wangu bube buumi bwanyika.” ");
INSERT INTO dov_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bajuda bakanyema akati kabo akukazyania kabaamba kuti,” anga mwaalumi oyu ulatupa buti mubili wakwe kuti tulye?” ");
INSERT INTO dov_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Mpawo Jesu wakabaambila kuti,” Nkasimpe, nkasimpe, kuti tewalya mubili wa Mwanaamuntu akunywa bulowa bwake, tamukoyooba aabumi pe. ");
INSERT INTO dov_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kufumbwa uulya mubili wangu akunywa bulowa bwangu uyooba aabumi butamani alimwi ndiyomubusya kubuzuba bwamamanino. ");
INSERT INTO dov_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nkaabo mubili wangu nkulya kwini abulabo bulowa bwachakunywa chinichin. ");
INSERT INTO dov_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Umwi awumwi uulya mubili wangu akunywa bulowa bwangu ulakkalilila mulindim, ambebo mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mbuli Taata mbwakandituma, ambuuli mbupona nkaambo ka Taata, aboobo uundilya me, uyoopona nkambo kandime. ");
INSERT INTO dov_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Echi nchinkwa chakaseluka aansi kuzwa kujulu, chitali eecho bamaTaata nchibakalya akufwa. Uulya chinkwa eechi uyopona lyoonse.” ");
INSERT INTO dov_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Pesi Jesu wakaamba zintu eezi muchikombelo naakachili kuyiisya mu Kkapenamu. ");
INSERT INTO dov_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mpawo biingi basikwiiya bakwe bakamvwa bakati,” okukwaamba nkuyumu; ngwani uukonzya kukumvwisya?” ");
INSERT INTO dov_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesu, nkaambo wakalizi lwakwe kuti basikwiiya bakwe kuti balokutongawuka azazi, wakabaambila kuti,” zyamukataazya na? ");
INSERT INTO dov_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mpawo muyochita buti mwaakubona Mwana a Muntu wayinka oko nkwakabede saansi? ");
INSERT INTO dov_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","muya uuchita buponi; inyama tiikwe mpindupe. Majwi ngindakamwaambila ngamuuya, alimwi alapona. ");
INSERT INTO dov_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nikuba oobo mpubali bamwi banu batasyomi,” nkaambo Jesu wakalizi kumatalikilo bamwi bakatali kusyoma alimwi bakali basikumwaaba. ");
INSERT INTO dov_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wakaamba kuti,” nkaambo kazezi nchindaamba kuti taakwe naba omwe uukonzya kusika kuli ndime kuti tapegwa aa Taata.” ");
INSERT INTO dov_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nkaambo kazeezi, basikwiiya bakwe biingi bakamwayika alimwi taakwe nibakachilikweenda awe. ");
INSERT INTO dov_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mpawo jesu wakaambila bali kkumi ababili,” tamundi na kwiinka anywebo, mulayandana?' ");
INSERT INTO dov_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","'Simoni Pita wakasandula kuti,” mwaami, tulaya kuliini? uuli amajwi aabumi butamani, ");
INSERT INTO dov_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","alimwi twakasyoma akuziba kuti nduwe uusalala wa Leza.” ");
INSERT INTO dov_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesu wakabaambila kuti,” teensi ndakamusalana, balikkumi ababili, akati kanu umwi ngu satani?” ");
INSERT INTO dov_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","lino wakali kwamba Judasi mwana wa Simoni Isikkaliyoti, wakalinguwe, omwe akati kabali kkumi ababili, uutamwabe Jesu. ");
INSERT INTO dov_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nikwakamana zintu ezi Jesu wakayinka ku Galili, nkambo talikuyanda kwinka ku Judiya nkambo ba Juda balikumulangula kuti bamujaye. ");
INSERT INTO dov_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lino ipobwe lyaba Juda lyamadumba lyakali afwifwi. ");
INSERT INTO dov_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bakulana bakwe bakati kuli nguwe, “zwa busena obu uyeku Judiya, kuchitila kuti basikwiya bakwe babone milimu njabeleka. ");
INSERT INTO dov_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Takwe chelede kuchitwa mukusisikizya kuti kayanda kuzibinkana antanganana. Kuti mwachita zintu ezi, litondezye kunyika. ");
INSERT INTO dov_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nkambo abalabo bakkulana bakwe tebakali kumusyoma. ");
INSERT INTO dov_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesu wakabambila kuti, “Chindi changu tachinasikape, pesi chindi chanu mpuchili kale. ");
INSERT INTO dov_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Inyika timuswilide pe nywebo, pesi mebo ilindiswilide nkambo ndamba kuti milimu yaayo mibi. ");
INSERT INTO dov_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kamuya mupobwe; mebo tandikoyinka pe kupobwe nkambo chiindi changu tachina zuzikizigwa pe.” ");
INSERT INTO dov_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nakamana kwamab zintu ezi kulimbabo, wakakkala mu Galili. ");
INSERT INTO dov_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","bakulana bakwe bakiinka kupobwe, alakwe wakinka, kutali kwantanganana pe pesi mukusisikizya. ");
INSERT INTO dov_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ba Juda bakali kumulangula kupobwe balamba kuti, “Ulikuli?” ");
INSERT INTO dov_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kwakali mizeezo myiingi akati kankamu yabantu atala anguwe. Bamwi bakati, “Mwalumi mubotu.” Bamwi bakati, “pe, ulokusowa makamu abantu.” ");
INSERT INTO dov_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Katakwe wakambula antanganana atala anguwe bakali kuyowa ba Juda. ");
INSERT INTO dov_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ipobwe nilyakaba akati kuti limane, Jesu wakanjila muntempele akutalisya kuyisya. ");
INSERT INTO dov_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mpawo ma Juda bakagamba, bati, “Nkamboyi nazi kwindilila? Takwe anakayiide pe.” ");
INSERT INTO dov_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesu wakabasandula kuti, “kuyiisya kwangu takuli kwangu, pesi nkukwayoyo wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kuti umwi wachita kuyanda kwakwe, ulaziba njiisyo eyii, kuti nansya yazwa kuli Lez, akuti na ndalyambwida lwangu. Ulyambwida lwangu. ");
INSERT INTO dov_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ulyambwida lwakwe ulilangwida bulemu bwakwe mwini, pesi oyo ulangula bulemu bwayoyo wakamutuma, ooyo muntu wakasimpe; alimwi takwe bululami mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mozesi takamupede mulawu na? Katakwe naba omwe wakubaamba. Niinzi nimulokulangula kuti mundijaye?” ");
INSERT INTO dov_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Inkamu yakasandula, “Uli aadimoni. Ngwani ulokulangula kuti akujaye?” ");
INSERT INTO dov_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu wakasandula kuti kulimbabo, “Ndakachita mulimo omwe, alimwi moonse mwakagamba nkambo kanguwo. ");
INSERT INTO dov_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mozesi wakamupa kupalulwa (pe kuzwa kuli Mozesi, pesi kuzwa kuli basikale) alimwi mubuzuba butegwa Sabata mwakapalula baluumi. ");
INSERT INTO dov_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kuti na muntu watambula kupalulwa mubuzuba bwesabata nkukuti mulawu wa Mozesi tewakatyolwa pe, Nkambo nzimwandinyemena me akambo kakuti ndachita kuti muntu amaninine kupona kubuzuba bwesabata.” ");
INSERT INTO dov_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mutabeteki achiimo, pesi amubeteke chakululama.” ");
INSERT INTO dov_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bamwi babo bazwa ku Jelusalema bakamba, “teensi yooyu na ngubali kulangula kuti bamujaye?” ");
INSERT INTO dov_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Amubone wamba antanganana, alimwi nchibamba anguwe. Tachikooba obo pe kuti bendelezi kuti oyu ngu Kkilisitu, tensi mbubo pe? ");
INSERT INTO dov_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Iswetuli oyu nkwazwa. Pesi Kkilisitu asik, takwe naba omwe uzoziba nkwazwa.” ");
INSERT INTO dov_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mpawo Jesu wakoompolola mutempele, kalookuyisya akwamba kuti, “moonse mulindizi ankundakazwa mulikwizi. Tendakalizidilide lwangu, pesi wakandituma ulakasimpe, alimwi tamumwizi pe. ");
INSERT INTO dov_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ndimwizi me nkambo ndakazwa kulinguwe alimwi wakandituma.” ");
INSERT INTO dov_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Bakali kwezya kumwanga, pesi takwe wakabika luboko alinguwe nkambo chindi chakwe techakalina sika pe. ");
INSERT INTO dov_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pesi bayingi munkamu bakasyoma mulinguwe, alimwi bakamba kuti, Kkilisitu nasika, uzochita zitondezyo zyingi na kwinda nzyachita oyu?” ");
INSERT INTO dov_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ba Falisi bakamvwa kabalo kuvwiya vwiya zintu ezi atala a Jesu, alimwi bapati babapayizi aba Falisi bakatuma bamapulisa kuti bamusunge. ");
INSERT INTO dov_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesu wakamba kuti, “ndichili andinywe, kuchindi chinini, alimwi ndizoyinka kuliyoyo wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Muyondiyandawula pesi tamukoyondijana pe mebo oko nkwenja, Tamukonzyipe pe kusika.” ");
INSERT INTO dov_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Abo ba Juda bakabuzyania akati kabo, “Nkukuli nkwaya mwalumi oyo nkotutakonzyi kuyomujana? Sena ulayinka kuli bamwayikide akati kaba Giliki akuyoyiisya baGiliki? ");
INSERT INTO dov_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Katyeni kambo aka nkaamba kakuti muyondiyandawula, pesi tamukoyondijana pe. Oko nkwenja, tamukonzyi kukusika?” ");
INSERT INTO dov_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lino mubuzuba bwakumaninsya, izuba pati lyepobwe, Jesu wakanyampuka akompolola, kati, “Na umwi wafwa inyota, abole kulindime anywe.” ");
INSERT INTO dov_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Umwi awumwi usyoma mulindime, mbuli melembe mbawamba, milonga yamanzi mawumi iyoyenda mwida lyakwe.” ");
INSERT INTO dov_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pesi wakamba ezi mumuuya, kulibabo basyoma mulinguwe bayotambula, Muuya tewakayinapegwa pe nkambo Jesu talina lemesegwa pe. ");
INSERT INTO dov_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bamwi benkamu, nibakamvwa ayamajwi, bakamba kuti, “Inchobeni oyu musinsimi.” ");
INSERT INTO dov_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bamwi bakati, “oyu nguKkilisitu.” Pesi bamwi bakati Kkilisitu inga ulazwa mu Galili? ");
INSERT INTO dov_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Malembe sa tawambi kuti Kkilisitu ulazwa kulunyungu lwa Davidi alimwi kuzwa ku Betelehema, kumunzi Davida nkwakali kuzwa?” ");
INSERT INTO dov_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aboobo kwakaba kwaanzana akati kankamu nkambo kanguwe. ");
INSERT INTO dov_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bamwi bakayandide kumwaanga, pesi takwe wakabikka manza alinguwe. ");
INSERT INTO dov_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mpawo bamapulisa bakabola kubapati babapayizi aba Falisi, bakati kulimbabo “kwabanzi nimwatamweta?” ");
INSERT INTO dov_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bamapulisa bakasandula kuti, “Takwe naba omwe wakali wambula abo.” ");
INSERT INTO dov_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Aboobo ba Falisi bakasandula, andinywe mwenwa na?. ");
INSERT INTO dov_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kulumwi na akati kabendelezi wasyoma mulinguwe, nikuba kuba Falisi? ");
INSERT INTO dov_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pesi eyi inkamu intaanzi mulawu, ulitukidwe.” ");
INSERT INTO dov_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikkodimasi (umwi wabaFalisi wakasika akufwambana) wakati kulimbabo. ");
INSERT INTO dov_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Mulawu wesu ulabeteka na muntu katutanaswilila na kulinguwe akuziba nzyachita?” ");
INSERT INTO dov_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bakamusandula bati kulinguwe, “ayebo uzwa ku Galili na? Langula ubone kuti takwe musinsimi uzwaku Galili.” ");
INSERT INTO dov_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mpawo umwi awumwi wakaya kung'anda yakwe. ");
INSERT INTO dov_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesu wakaya kuchilundu cha Oliva. ");
INSERT INTO dov_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chifumofumo wakaya ku tempele lubo, eelyo bantu boonse bakasika; wakakkala aansi akubayiisya. ");
INSERT INTO dov_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Balembi bamulawu abaFalisi bakeeta mukayintu wakajatwa nkalookuchita bumambe. Bakamubika aakati. ");
INSERT INTO dov_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mpawo bakati kulinguwe, “Muyiisi, ooyu mwanakaziwajatwa kalikuchita bumambe. ");
INSERT INTO dov_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lino mumulawu, Mozesi wakatulayilila kuti bantu baliboobu tubatulule mabwe; iwe utyeni aatala anguwe?” ");
INSERT INTO dov_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bakaamba eezi kuchitila kuti bamupe mulandu anzizyo, pesi Jesu wakakotama walemba aansi amunwe wakwe. ");
INSERT INTO dov_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nibakiinkilila aanembo akumubuzya mibuzyo, wakanyampuka akubaambila kuti, “Ooyo utakwe chibi aakati kenu, ngabe mutanzi kutulula mwanakazi ooyu ibbwe.” ");
INSERT INTO dov_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wakakotama aansi lubo, akulemba aanyika amunwe wakwe. ");
INSERT INTO dov_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nibakamvwa eezi bakeenda umwi awumwi, kutalika aamupati. Kumamanino Jesu wakasyaala aalike, nkali aamwanakazi ngubakabikide aakati. ");
INSERT INTO dov_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesu wakanyampuka akumwaambila kuti, “Yoo mwanakazi, mbali basikukupa mulandu? Takwe muntu wajana mulandu na mulinduwe?” ");
INSERT INTO dov_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wakati, “Takwe, nikuba womwe Mwaami.” Jesu wakati, “Ambebo nsikupi mulandu. Koya alimwi utakabisyi limbi.” ");
INSERT INTO dov_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Alimwi Jesu wakaambuula aabo nkati, “Ndili mumuni wanyika; ooyo unditobela takoyoyenda mumudima pesi uyooba aamumuni wabuumi.” ");
INSERT INTO dov_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ba Falisi bakati kulinguwe, “Ulipeda bukamboni nomwini, bukamboni bwako tabusinizizye pe.” ");
INSERT INTO dov_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu wakabasandula akwaamba kuti kulimbabo, “Nekuba kuti ndipa bukamboni bwangu ndemwini, bukamboni bwangu bulisinizizye. Ndilikwizi nkundakazwa ankwenjobuya. ");
INSERT INTO dov_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mubeteka chanyama; Ime nsibeteki muntu pe. ");
INSERT INTO dov_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nikuba kuti ndabeteka, kubeteka kwangu kulisinizizye nkaambo nsili aandike pe, pesi ndili aaTaata wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Iyii, alimwi mumulawu wenu kulilembedwe kuti bukamboni bwabantu babili bulisinizizye. ");
INSERT INTO dov_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ndili ooyo uulungulula bukamboni aatala alwangu, eelyo Taata wakandituma upeda bukamboni aatala andime.” ");
INSERT INTO dov_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bakati kulinguwe, “Ulikuli wuso?” Jesu wakasandula, “Takwe ngomuzi imebo na Taata; kansinga mwalindiz, mwalikunomuziba Taata alakwe.” ");
INSERT INTO dov_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Aaya majwi wakaamba muchibambalilo nkali kuyiisya mutempele pesi takwe muntu wakamusunga nkaambo chiindi chakwe techakalinaakkwana pe. ");
INSERT INTO dov_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aawo wakabaambila lubo kuti, “Ndiyobwiinka, muyondiyanduula eelyo muyofwa muzibi zyanu. Ooko nkweya, tamukonzyi kusika pe.” ");
INSERT INTO dov_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ba Juda bakati, “Mpo ulalijaya na? Nchenchicho na mpo nchati, 'Nkweya tamuyosika?” ");
INSERT INTO dov_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu wakati kulimbabo, “Muli baansi; Imebo ndiwakujulu. Muli banyika eeyi; Mebo nsili wenyika eeyi pe. ");
INSERT INTO dov_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Akaako ndakamwaambila kuti muyoofwa muzibi zyabo. Ado do mane musyome kuti NDIME, muyoofwa muzibi zyenu.” ");
INSERT INTO dov_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bakati kulinguwe, ikuti kuliboobo, “Nduweni?” Jesu wakabaambila kuti, “Nzindamwaambila kuzwa kumatalikilo. ");
INSERT INTO dov_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndili aazintu zyiingi zyakwaamba azyakubeteka aatala andinywe. Nikubaboobo, ooyo wakandituma ulisinizizye; mpawo zintu nzyemvwa kuzwa kulinguwe, nzyezintu nzyewamba kunyika.” ");
INSERT INTO dov_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tensi bakamvwisisisya pe kuti wakalikwaambula aatala aTaata. ");
INSERT INTO dov_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesu wakati, “Aawo mwayoonyampula Mwana waMuntu, mpempawo mpomuyooziba kuti NDIME, akuti nsichiti chintu alwangu. Mbubo Taata mbwakandiyiisya me, mbubo bewamba zintu eezi. ");
INSERT INTO dov_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ooyo wakandituma uli aandime, mpawo tandisiide andiike pe, nkaambo ndichita zintu zimukonda chiindi choonse. ");
INSERT INTO dov_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nkachaambula zintu eezi Jesu, bantu biingi bakasyoma mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesu wakati kuma Juda ibakali bamusyoma, “Na mwakkalilila mujwi lyangu, muyooba basikwiiya bangu basinizizye, ");
INSERT INTO dov_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","alimwi muyoziba kasimpe, eelyo kasimpe kayoomwaangununa.” ");
INSERT INTO dov_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bakamusandula, “Tulizyalane lya Abbulahamu mpawo tatunaaba bazike bamuntu pe; waambilaaaloi kuti, 'Muyowangununwa'?” ");
INSERT INTO dov_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu wakabasandula, “Nchobeni, nchobeni, ndamwaambila kuti, ooyo woonse uchita chibi muzike wachibi. ");
INSERT INTO dov_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Muzike takkalilili mun'anda kwalyoonse; mwana ulakkalilila chalyoonse. ");
INSERT INTO dov_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Akaako, na Mwana wakwaangununa, ulaangunuka cha nchobeni. ");
INSERT INTO dov_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ndilizizi kuti muli zyalane lya Abbulahamu; muyandula kundijaya nkaambo ijwi lyangu talikwe busena mulindinywe. ");
INSERT INTO dov_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ndiwamba nzindakabona kuli Taata, alimwi andinywe muchite nzimwakamvwa kuli wuso wanu.” ");
INSERT INTO dov_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bakamusandula alimwi bakati kulinguwe, “Taata wesu ngu Abbulahamu.” Jesu wakati kulimbabo, “Na mwali bana ba Abbulahamu, nimunga muchita milimu ya Abbulahamu. ");
INSERT INTO dov_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pesi, lino muyanduula kundijaya, muntu wamwaambila kasimpe nkendakamvwa kuli Leza. Abbulahamu takwe nakachita eechi. ");
INSERT INTO dov_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Muchita milimu yawuso wenu.” Bakati kulinguwe, “Tetwakazyalilwa mubwamu pe; tuli aaTaata omwe: Leza.” ");
INSERT INTO dov_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu wakabaambila wakati, “Kaansinga Leza ngu Wuso wenu, mwalikunondiyanda, nkaambo ndakazwa kuli Leza mpawo ndili aano; nkaambo nsilizidilide pe ndemwini, pesi wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nkaambonzi nimutamvwisisisyi majwi aangu? Kuli oobu nkaambo tamukonzyi kumvwa majwi aangu. ");
INSERT INTO dov_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Muli bawuso wenu, dyabbulosi, alimwi mukanza kuchita ziyandisyo zyawuso. Wakali mujayi kuzwa kumatangunino mpawo tayiimvwi muchisinizyo nkaambo takwe kusinizya mulinguwe. Aawo nawamba zyakubeja, uwamba kazizwa mubube bwakwe mwini nkaambo mubeji alimwi ngowisi wabubeji. ");
INSERT INTO dov_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eelyo, nkaambo ndiwamba lusinizyo, tamundisyomi pe. ");
INSERT INTO dov_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngwani aakati kenu uundipa mulandu wachibi? Kuti ndaamba lusinizyo, nkambooyi nimutandisyomi? ");
INSERT INTO dov_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Muntu waLeza woonse ulaamvwa majwi aa Leza; tamwaamvwi nkaambo tamuli ba Leza.” ");
INSERT INTO dov_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ba Juda bakamusandula alimwi bakati kulinguwe, “Nchoonzyo tatwaambi kuti uli mu Samaliya na akuti uli aadayimona?” ");
INSERT INTO dov_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu wakasandula, “Nsikwe dayimona pe, pesi ndilemya Taata wangu, alimwi inywe mulanduubawulusya. ");
INSERT INTO dov_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nsilanguuli bulemu bwangu ndemwini; kuli uumwi uuyandula akubeteka. ");
INSERT INTO dov_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chobeni, nchobeni, ndamwaambila, na umwi wabamba ijwi lyangu, takoyoobona lufu.” ");
INSERT INTO dov_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma Juda bakati kulinguwe, “Lino twaziba kuti uli aadayimona. Abbulahamu abasinsimi bakafwa; pesi wamba kuti, 'Na umwi wabamba ijwi lyangu, takoyoolabila lufu.' ");
INSERT INTO dov_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Toli mupati pe kwiinda taata Abbulahamu wakafwa, ulimupati na? Basinsimi abalabo bakafwa. Ulichita ani?” ");
INSERT INTO dov_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu wakasandula, “Kuti nkelipa bulemu ndemwini, bulemu bwangu mbwabuyo; ngu Taata undilemya - ooyo ngumuti ngu Leza wanu. ");
INSERT INTO dov_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tamunaamuziba pe, pesi ndilimwizi. Kuti ndati, 'Nsimwizi, ndilaba mbuli ndinyw, mubeji. Nikuba boobo, ndimwizi alimwi ndilabamba ijwi lyakwe. ");
INSERT INTO dov_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wuso wenu Abbulahamu wakabotelwa kubamba izuba lyangu; waklibona alimwi wakabotelwa.” ");
INSERT INTO dov_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","BamaJuda bakati kulinguwe, “Tonaakuba aaminyaka ili makkumi musanu pe, mpawo wakamubona Abbulahamu?” ");
INSERT INTO dov_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu wakati kulimbabo, “Nchobeni, nchobeni, ndamwaambila Abbulahamu nkatanaaba, NDIME.” ");
INSERT INTO dov_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mpawo bakabweza mabwe kuti bamutulule, pesi Jesu wakayuba akuzwa aanze kwe tempele. ");
INSERT INTO dov_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lino Jesu nakayinda, wakabona mwalumi moofu kuzwa kubuzyalwe bwakwe. ");
INSERT INTO dov_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Basikwiya bakwe bakamubuzya, “Muyisyi, ngwani wakabisya, ngooyu mwalumi nakuti mbazyali bakwe, kuti azyalwe kali moofu?” ");
INSERT INTO dov_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesu wakasandula kuti, “teensi nguwepe wakachita chibi, nikuba bazyali bakwe, pesi kuti milimu ya Leza iyubununwe mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tulelede kubeleka milimu ya oyo wakandituma nelichili isikati. Mansiku alasika nikuyochala katachikwe uyobeleka. ");
INSERT INTO dov_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ninchili munyika, ndime mumuni wenyika.” ");
INSERT INTO dov_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nakamaninsya Jesu kwamba ezi zintu, wakaswida anyika, wakakanda bulongo amate, akunanika bulongo kumeso akwe. ");
INSERT INTO dov_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Wakamba kuti kulinguwe, “Yinka, ukasambe mukalambwa kaku kaku Silawomi” (kupandululwa kuti “kutumwa”). Lino mwalumi wakayinka, wakusamba, wakubola wabbwazula. ");
INSERT INTO dov_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mpawo mbakayakilene aabo mwalumi abakamubonwene kali mukumbizi bakalikwamba kuti, “teensi nguwe na mwalumi oyu walimukumbizi?” ");
INSERT INTO dov_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bamwi bakamba kuti, “Nguwe.” bamwi bakati, “pe, pesi ukozyania awe biyo.” Pesi wakati, “Ndime.” ");
INSERT INTO dov_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bakamba kuti kulinguwe, “mpawo bakamubuzya kuti ajulika buti meso?” ");
INSERT INTO dov_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wakasandula, mwalumi utegwa Jesu wakakkanda bulongo akubunanika mumeso angu akwamba kuti kulindime, Ýinka ku Silawomi ukasamb. 'Lino ndakayinka akuyosamba, alimwi ndakatambula kubona kwangu. ");
INSERT INTO dov_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bakati kulinguwe, “Ulikuli?” wakasandula, “Tandizi pe.” ");
INSERT INTO dov_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bakeeta mwalumi wakali moofu kubaFalisi. ");
INSERT INTO dov_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Eno lyakali zuba lyakwe lyesabata. Jesu mpakakanda bulongo akumujula menso akwe. ");
INSERT INTO dov_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Aboobo ba Falisi bakamubuzya kuti watambula buti kubona kwako. Wakati kulimbabo, wabika bulongo mumenso angu, ndakakusamba, alimwi lino ndabona.” ");
INSERT INTO dov_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bamwi baFalisi bakati oyu mwalumi tazwi kuli Leza nkambo tabambi buzuba bwaSabata.” Bamwi bakati, “Anga wakonzya buti mwalumi sizibi kuchita zitondezyo zili boobu?” Lino kwakaba kwanzana akati kabo. ");
INSERT INTO dov_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bakamubuzya moofu alimwi kuti, uwamba buti anguwe, mbwakajula menso aako?” Mwalumi moofu wakati, “Musinsimi.” ");
INSERT INTO dov_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nkambo kako baJuda takwepe nibakasyoma kuti nguwakali moofu alimwi kuti watambula kubona. ");
INSERT INTO dov_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bakakubuzya bazyali, “Oyu ngumwana ngumwana wenu na ulokwamba kuti wakazyalwa kali moofu? ");
INSERT INTO dov_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lino wabona?” Bazyali bakwe bakasandula, “Tuzi biyo kuti oyu mwana wesu akuti wakazyalwa kali moofu. ");
INSERT INTO dov_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kuti wazobona buti tatuzipe, akuti ngwani wajula menso akwe, tatuzipe. Amumubuzye, mupati. Ulakonzya kulyambwida lwakwe.” ");
INSERT INTO dov_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Bazyali bakwe bakaamba ayamakani, nkambo bakali kuyowa ba Juda nkambo ma Juda bakali kuzumina kuti kufumbwa utazumine kuti ngu Kkilisitu, ulatandwa muchikombelo. ");
INSERT INTO dov_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nkambo kazezi, nchibakati, “Mupati, ulalyambwida.” ");
INSERT INTO dov_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lino bakamwita lwabili mwalumi wakali moofu akuti kuli nguwe, “kupa bulemu kuli Leza. Tulizi kuti oyu mwalumi ngu sizibi.” ");
INSERT INTO dov_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mpawo mwalumi wakasandula, “Tandizi pe kuti na ngu sizibi. Chintu chimwi nchinzi: Nkuti ndakali moofu, lino ndabona.” ");
INSERT INTO dov_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mpawo bakaamba kuti kulinguwe, “ninzi nchaachita kulinduwe? Waajula buti menso aako?” ");
INSERT INTO dov_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wakasandula, “ndamwambila kale, alimwi tamuswilizyi pe! Nkambonzi nimuyanda kumvwa lubo? Tamuyandi pe kuba basikwiiya bakwe, mulayandana? ");
INSERT INTO dov_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bakamutukila alimwi bakati, “Nduwe sikwiiya wakwe, pesi swebo tulibasikwiiya ba Mozesi. ");
INSERT INTO dov_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tulizi kuti Leza waambula kuli Mozesi, pesi tatwizi kuti ooyu uzwa kuli.” ");
INSERT INTO dov_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mwalumi wakasandula akuti kulimbabo, “Eechi chilayoosya, kuti tamumuwi nkwazwa, alimwi wajula menso angu. ");
INSERT INTO dov_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tulizi kuti Leza taswilizyi pe kuli basizibi, pesi umwi kuti walipeda akuchita luyando lwakwe, ulamuswilizya. ");
INSERT INTO dov_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kuzwa nyika niyakalengwa takuna mvwigwa pe kuti naba omwe wakajula menso amuntu wakazyalwa kali moofu. ");
INSERT INTO dov_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kuti mwalumi oyu katazwi kuli Leza, natakwe anchakonzya kuchita.” ");
INSERT INTO dov_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bakasandula akwamba kuti kuli nguwe, “Wakazyaligwa muchibi, alimwi ulokuyisya ndiswe?” Mpawo bakamutontela aanze. ");
INSERT INTO dov_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesu wakamvwa kuti bamutandila aanze achikombelo. Wakamujana alimwi wakati, “Ulasyoma na mu Mwana a Muntu?” ");
INSERT INTO dov_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wakasandula kuti, “Ngwani, Mwami, kuti ndimusyome. ");
INSERT INTO dov_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu wakamwambila kuti, “Wamubona, alimwi nguwe ngulokwambula awe. ");
INSERT INTO dov_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mwalumi wakati, “Mwami, ndasyoma, “alimwi wakamukomba. ");
INSERT INTO dov_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesu wakati, “Nkambo kakubeteka nchindasikamunyika ino kuti abo bataboni babone alimwi kuti babona babe boofu.” ");
INSERT INTO dov_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Bamwi ba Falisi bakali awe bakamvwa zintu eezi alimwi bakamubuzya kuti, “Tuliboofu na toonse?” ");
INSERT INTO dov_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu wakati kuli mbabo, “Naa mwakali boofu, munoli kamutakwe chibi, pesi mwamba kuti, 'Tulabona, Aboobo zibi zyanu zilakkalila. ");
INSERT INTO dov_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nkasimpe, nkasimpe, ndamwambila, utanjili akwinda amulyango wachaata chambelele, pele ulatanta mujulu ayimbi nzila, ooyo muntu mubbi asikunyanga. ");
INSERT INTO dov_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ooyo unjila akwinda amulyango ngusikwembela mbelele. ");
INSERT INTO dov_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Uubamba mulyango ulamujulila. Mbelele zilamvwa ijwi lyakwe, aboobo ulazyita mbelele zyakwe amazina azyo, akuzitola anze. ");
INSERT INTO dov_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chiindi nazigwisizya anze zyoonse zyakwe, ulinka kunembo lyazyo, abbobo mbelele ziyomutobela, nkambo zililizi ijwi lyakwe. ");
INSERT INTO dov_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tazikoyo tobela mwenzu nguzitazi pesi anukuti ziyomuchija, nkambo tazilizi pe ijwi lyamwenzu ngozitazi. ");
INSERT INTO dov_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu wakamba aya mambilambali kulimbabo, pesi takwe nibakamvwisisya kuti ezi zintu zyakali nzizyo nzyakali kubaambila. ");
INSERT INTO dov_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aboobo Jesu wakabambila lubo, “nchobeni, nchobeni ndamwambila, ndime, mulyango wambelele. ");
INSERT INTO dov_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Boonse bakasika nkesina sika mbabbi abasikunyanga, pesi mbelele tezyakabaswilila. ");
INSERT INTO dov_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ndime mulyango. Kuti umwii unjila akwiinda mulindime, uyoo futulwa, uyoo njila akuzwa akujana machelelo. ");
INSERT INTO dov_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mubbi tazi kupela pe kunze kwakubba, kujaya akunyonyona. Ndaza kuti babe abuumi akuti buvule. ");
INSERT INTO dov_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ndime sikwembela mubotu. Sikwembela mubotu ulapeda buumi bwakwe kumbelele. ");
INSERT INTO dov_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Oyoo mubelesi ubbadalwa tensi ngusikwembela pe aboobo tazilizyakwe mbelele. A bona wumpe ulaza aboobo ulazisiya mbelele akuchija, elyo wumpe uyoziluma akuzimwayisya. ");
INSERT INTO dov_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ulachija nkambo mubelesi sikubbadalwa aboobo talikatazyi ambelele. ");
INSERT INTO dov_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ndime sikwembela mubotu, aboobo zyangu zilindizi. ");
INSERT INTO dov_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Taata ulindizi, andime ndilimwizi Taata, aboobo ndilapeda buumi bwangu kumbelele. ");
INSERT INTO dov_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ndilijisi zimwi mbelele zitali zyamuchata chambelele echino. Aboobo ndilelede kuzyeta azilazyo, alimwi ziyolimvwa ijwi lyangu elyo ziyoba taanga lyomwe asikwembela omwe. ");
INSERT INTO dov_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Echi nchenchicho Taata nchandiyandila. Ndilapeda buumi bwangu elyo njobubweza lubo. ");
INSERT INTO dov_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Takwe naba omwe uyobubweza kuzwa kuli ndime, pesi ndabupeda ndemwini. Ndila chelelo chakubupeda ndemwini. Ndila chelelo chakubupeda, aboobo ndilachelelo chakubu bweza lubo. Ndakatambula malayilile aya kuzwa kuli Taata” ");
INSERT INTO dov_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kwanzana lubo kwaka akati kama Juda nkambo kamajwi aya. ");
INSERT INTO dov_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Biingi babo bakati “Ulijisi dimoni abobo ulisuwidwe. Nkambonzi nmumuswilila?” ");
INSERT INTO dov_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bamwi bakati, “Aya tensi majwi amuntu unjidwe dimoni. Sena dimoni lilakonzya kujula meso amoofu”? ");
INSERT INTO dov_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kwakali kuchindi chakusalazigwa mu Jelusalemu. Kwakali lya mpeyo, ");
INSERT INTO dov_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","aboobo Jesu wakali kuyowenda mu mutempele mu kota lya Solomon. ");
INSERT INTO dov_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pesi ba Juda bakamuzyunguluka akwamba kuti kuli nguwe, “Kukabe lili kojisi nkotwena? Kuti na nduwe Kilisito, twambile antanganana”. ");
INSERT INTO dov_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesu wakabasandula, “Ndakamwambila, pesi tamusyomi pe. Milimu eyo njenchita muzina lya Taata njindipandulula lwangu me. ");
INSERT INTO dov_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pesi tamusyomi nkambo tamuli mbelele zyangu. ");
INSERT INTO dov_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mbelele zyangu zilamvwa ijwi lyangu. Ndilizizi aboobo zilanditobela me. ");
INSERT INTO dov_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ndazipa buumi butamani. Tazikoyoofwa pe, aboobo takwe naba omwe uyozikwempya mujanza lyangu. ");
INSERT INTO dov_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taata wangu wakazipa ndime, mupati kwinda bamwi boonse takwe naba omwe uyokonzya kuzikwempya kuzwa mujanza lya Taata. ");
INSERT INTO dov_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ime a Taata tuli umwi”. ");
INSERT INTO dov_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nkabela ma Juda bakabweza mabwe lubo kuti bamutulule ");
INSERT INTO dov_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesu wakabasandula, “Ndamutondezya milimu myingi mibotu izwa kuli Taata. Pesi nguli wamilimu awa ngumunditulwida?” ");
INSERT INTO dov_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ba Juda bakamusandula, “Tetwakutulula nkambo kamilimu mibotu pe, pesi nkambo kakusampawula, nkambo webo, ulimuntu, ulichita Leza lwakwe”. ");
INSERT INTO dov_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu wakasandula “Sa tazilembedwe na mumulawu wanu, 'Ndati, “muli baleza”? ");
INSERT INTO dov_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kuti bategwa mbaleza, ooyo ngulyakazida ijwi lya Leza ( aboobo malembe takoyotyolwa), ");
INSERT INTO dov_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","uwamba kuli ooyo ngwakasala Taata akumutuma munyika, Muloku sampawula. nkambo ndamba kuti ndii mwana wa Leza? ");
INSERT INTO dov_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kuti na nsili kuchita milimu ya Taata, mutandisyomi. ");
INSERT INTO dov_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pesi na ndikuchita, nansya kuti temwandisyoma, musyome mumilimu kuchitila kuti mukazibe akumvwisisisya kuti Taata ulimulindime aboobo ambebo ndimuli Taata”. ");
INSERT INTO dov_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bakezya kumujata lubo, pesi wakapuzuka kuzwa kumanza abo. ");
INSERT INTO dov_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Wakabweda lubo mutaala Jodani kubusena oko Joni nkwakatalikila kubbabbatizya, aboobo wakakukkala nkukoko. ");
INSERT INTO dov_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bantu biingi bakasika kulinguwe alimwi bakati, “Joni nchobeni takwe nakachita zitondezyo, pesi zyonse zintu Joni nzyakamba atala ayoyu mwalumi nzyakasimpe”. ");
INSERT INTO dov_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bantu biingi bakamusyoma mpawawo. ");
INSERT INTO dov_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Lino umwi mwalumi walikutegwa Lazalo wakalikuchiswa. Wakali kuzwa ku Bbetani, igunzi mwakali kukkala Meli a amuchizi wakwe Maata. ");
INSERT INTO dov_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meli nguwe oyo iwakananika Mwami amuunde akumusinda mawulu akwe amasusu, ngula mukulana Lazalo wakachisidwe. ");
INSERT INTO dov_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bachizi bakananizya mulumbe kuli Jesu kabaamba kuti, 'Mwami, Langa, ooyo ngoyandisya wachiswa.” ");
INSERT INTO dov_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesu nakamvwa eezi, wakati, “Óku kuchiswa tekwakufwa pe, pesi nkwabulemu bwa Leza kuti akonzye kulemekwa kuli nzizyo.” ");
INSERT INTO dov_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Lino Jesu wakali kuyandisya Maata, mwanike wakwe, a Lazalo. ");
INSERT INTO dov_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nakamvwa kuti Lazalo wachiswa, Jesu wakakkala kwamazuba aabili lubo kubusena oobo nkwakabede. ");
INSERT INTO dov_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mpawo nikwakiinda eezi, wakati kuli basikwiiya bakwe, “Tubwede lubo ku Judiya.” ");
INSERT INTO dov_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Basikwiya bakati kuli nguwe, “Muyiisyi, lino lino bama Juda balokwezezya kuti bakutulule alimwi uyanda kubweda luubo?” ");
INSERT INTO dov_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu wakavwila, “Taakuli mahoola alikkumi aabili na amumuuni mubuzuba bumwi? Na umwi weenda izuba kaliliwo, takonzyi pe kuti aligubbule, nkambo unobona amumuni wenyika. ");
INSERT INTO dov_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nikuba boobo, kuti weenda mansiku, ulawaa nkambo mudima tuli anguwe.” ");
INSERT INTO dov_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Wakaamba zintu ezi, nakamana kwamba ezi, wakati kuli mbabo, imuzyalwama Lazalo ulookona, pesi njankuko kuchitila kuti nkamubusye kuzwa mukoona.” ");
INSERT INTO dov_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Basikwiya mpawo bakati kuli nguwe, “Mwaami na kali ulokoona, ulabuka.” ");
INSERT INTO dov_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lino Jesu wakalaambide akufwa kwakwe, pesi bakayeya aanga wakali kwambula akoona kwakulyokezya. ");
INSERT INTO dov_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mpawo Jesu wakabambila kanzambwenene kuti, “Lazalo wafwa. ");
INSERT INTO dov_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ndabotelwa, nkambo kandinywe, kuti tendaliwope pe kuchitila kuti musyome. Twende kulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi, ooyo walikwitwa kuti Didimasi, wakati kuli basikwiyanyina “Twiinke andiswe kuchitila kuti tukafwe a Jesu.” ");
INSERT INTO dov_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nakasika Jesu wakajana kuti Lazalo wakali mukabanda kwamazuba aane. ");
INSERT INTO dov_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lino Bbeteli yakali afwifwi a Jelusalema, mweelwe walikusika kumamayila obile. ");
INSERT INTO dov_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bama Juda biingi bakalizide kuli Maata a Meli, kuzobaambulizya atala amuchizi wabo. ");
INSERT INTO dov_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eelyo Maata, nakamvwa kuti Jesu wasika, wakayinka wakuswanana awe, pesi Meli wakali kkede mungánda. ");
INSERT INTO dov_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mpawo Maata wakati kuli Jesu, “Mwami, aanoli wakaliwo, mukulana wangu tayinofwa pe. ");
INSERT INTO dov_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nikuba lino, ndilizi kuti kufumbwa nchokumbila kuli Leza, ulakupa. ");
INSERT INTO dov_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu wakati kulinguwe, “Mukulana wako ulabuka lubo.” ");
INSERT INTO dov_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maata wakati kulinguwe, “Ndizi kuti ulabuka lubo kububuke muzuba lyakumamanino.” ");
INSERT INTO dov_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu wakati kulinguwe, “Ndendime bubuke abuumi, Ooyo uusyoma mulindime nikuba kuti wafwa, uyopona; ");
INSERT INTO dov_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","alimwi kufumbwa oyo upona akusyoma mulindime takoyofwa pe. Ulazisyoma na eezi?” ");
INSERT INTO dov_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wakati kulinguwe, “Iyii, Mwami, ndilasyoma kuli nduwe Kkilisito, Mwana wa Leza, ooyo utazosike munyika.” ");
INSERT INTO dov_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Naakamba ezi wakazwa waya kukwita Meli chakusisilikizya. Wakati, “Muyiisyi ulaano alubo ulokukwiita.” ");
INSERT INTO dov_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mpakamvwa ezi, wakanyampuka achakufwambana akwinka kulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Li no Jesu takalina kusika pe mumunzi pesi wakachili kubusena ooko Maata nkwakamuswene. ");
INSERT INTO dov_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mpawo awo ba Juda, bakalanguwe mungánda bakali kumumbulizya nibakabona Meli kanyampuka chakufwambana kaaya aanze bakamutobela kabayeeya aanga wakali kuya kuchuumbwe kukuyolila. ");
INSERT INTO dov_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meli nakasika abusena aawo Jesu mpakabede akumubona wakawida kundyato zyakwe akwamba kuti, “Mwami aanoli walaano, Mukulana wangu natafwide pe.” ");
INSERT INTO dov_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesu nakamubona kalila, abaJuda mbakazide aabo kabalila, wakeetelela, wakatazikana akujatwa mumoyo wakwe. ");
INSERT INTO dov_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wakati, “nkokuli nkumwakakumulazika?” Bakati kuli nguwe, “Mwami, boola uzobone.” ");
INSERT INTO dov_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu wakalila. ");
INSERT INTO dov_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mpawo ba Juda bakati, “Boona kuti Lazalo walikumuyanda biyeni!” ");
INSERT INTO dov_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pesi bamwi baabo bakaamba kuti, “Talikukonzya na ooyu mwalumi wakajula meso amuntu moofu, kuchitila kuti ooyu muntu atafwi?” ");
INSERT INTO dov_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Mpawo Jesu, kachizwide kukatazikana mulinguwe, wakayinka kuchuumbwe. Lino chumbwe yakali mpako, nkabela kwakasinkidwe ibbwe mpawo. ");
INSERT INTO dov_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu wakati, “Mugwisye ibbwe, “Maata muchizi wa Lazalo, ooyo iwakafwide wakati kuli Jesu, “Mwami, kuli eechi chiindi mubili unoli wabola, nkambo waba amazuba aane kafwide. ");
INSERT INTO dov_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesu wakati kulinguwe, “Tendakwambila na kuti, wasyoma ulabona bulemu bwa Leza?” ");
INSERT INTO dov_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mpawo bakagwisya ibbwe balibikka kumbali. Jesu wakalanga kujulu akwamba kuti, “Taata, ndakulumba kuti wandiswilizya. ");
INSERT INTO dov_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ndalizi kuti ulandiswilizya chiindi choonse, pesi nkambo kankamu yabantu bayimvwi akati kangu nchindamba eezi, kuchitila kuti basyome kuli nduwe nuwakandituma.” ");
INSERT INTO dov_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nakamana kwambula ezi, wakawompolola ajwi lilaajulu, “Lazalo, zwida aanze!” ");
INSERT INTO dov_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mwalumi wakafwide wakazwida aanze, mawulu akwe amaboko akali zambilidwe asila. Jesu wakati kuli mbabo, “Amumuzambanune mumuleke ayeende.” ");
INSERT INTO dov_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mpawo bamaJuda biingi bakazide kuli Meli akubona ezyo Jesu nzyakachita, bakasyoma mulinguwe; ");
INSERT INTO dov_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","pesi bamwi baabo bakaya kuba Falisi bakubabuzya izintu Jesu nzyakali wachita. ");
INSERT INTO dov_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mpawo bapati babapayizi abaFalisi bakabungania bwendelezi amwi akwamba kuti, “Niinzi nchitutachite? Ooyu mwalumi uchita zitondezyo zyiingi. ");
INSERT INTO dov_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kuti tumusiye alikke kali boobu, boonse balasyoma kuli nguwe; ma Loma balaza akututolela busena bwesu achisi chesu.” ");
INSERT INTO dov_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nikuba oobo, umwi mwalumi akati kabo, Kkeyifasi, wakali mupayizi mupati ooyo munyaka, wakati kuli mbabo, Taakwe nchimuzi pe. ");
INSERT INTO dov_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tamulangisisyi na kuti nchibotu kuli ndinywe kuti kufwe umwi muntu kafwida bantu kwinda kuti nyika yoonse ifwidilile.” ");
INSERT INTO dov_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Lino eechi wakachaamba kachitazwide mulinguwe anukuti wakali mupayizi mupati oyo munyaka, wakasinsima kuti Jesu welede kufwida nyika; ");
INSERT INTO dov_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kutali chisi luzutu, pesi kuchitila kuti baana baLeza abo basanseene babunganisigwe aamwi babe umwi. ");
INSERT INTO dov_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mpawo kuzwa eelyo izuba kaziya kunembo bakalangula inzila yakuti Jesu bamujaye. ");
INSERT INTO dov_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesu takachili kweenda antanganana pe akati kaba Juda, pesi wakeenda wazwa waya kuli imwi inyika afwifwi akunkaanda mudolopo litegwa Efulemu. Nkuko nkwakakkala abasikwiiya bakwe. ");
INSERT INTO dov_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lino ipasika lyabama Juda lyakali lyaba afwifwi, mpawo biingi bakaya ku Jelusalema kabazwa kuzisi bayinka kuti bakalisalazye beni. ");
INSERT INTO dov_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bakali kuyandula Jesu, kabalo kwambula umwi awumwi kabayimvwi muchikombelo, “Muyeyayi loko? kuti ulaleka kusika kupobwe?” ");
INSERT INTO dov_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Lino bapayizi bapati aba Falisi bakali bapa malayilile akuti kufumbwa muntu unoli ulizi ooko Jesu nkwanobede, uyelede kuzyamba kuchitila kuti bamujate. ");
INSERT INTO dov_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mazuba musanu alimwi, kakutanayinda Pasika Jesu wakasika Betani, aawo aakali Lazalasi, ooyo Jesu ngwakabusya kuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aabobo bakamubambila chilalilo nkuko, aMata wakali kubapa. Pesi lazalasi wakali umwi wababo wakalede munsi atafula kali aJesu. ");
INSERT INTO dov_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kuzwawo Mariya wakabweza kankuli kamafuta mabotu kwindilila, wakananika Jesu kumawulu angawo akupukuta kumawulu amasusu aakwe. Ngaanda yakazula bweema bubotu bwamafuta. ");
INSERT INTO dov_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Juda Sikaliyoti, umwi wabasikwiya bakwe oyo sikumuzya, wakati, ");
INSERT INTO dov_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nkambonzi mafuta aaya natakuzigwa amiyanda yotatwe akupegwa kubafwaba?” ");
INSERT INTO dov_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Wakamba ezi nkaambo takalikulangisisya kubafwaba, pesi nkaambo wakal, mubbi. Wakali ankomo yamali akukkonzya kubba zyakabikidwe mukati. ");
INSERT INTO dov_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesu wakati, “ Amumuzumizye kubaamba ezyo nzyalazyo kuzuba lyakuvwikwa kwangu. ");
INSERT INTO dov_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Munoli aabo bafwaba kwalyoonse. Pesi tamukoyoba andime lyoonse.” ");
INSERT INTO dov_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lino nkamu mpati yamaJuda yakaziba kuti Jesu mpali, mpo bakasika kabatazidi Jesu alike pe, akuzobona Lazalasi, ooyo Jesu ngwakabusya kuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ibapayizi bapati bakakkankayizya antomwe kuti bakonzye kujaya Lazalasi; ");
INSERT INTO dov_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nkaambo kanguwe kuti MaJuda biingi bakeenda akusyoma kuliJesu. ");
INSERT INTO dov_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Izuba litobela inkamu mpati yakasika kupobwe nibakamvwa kuti Jesu ulasika kuJelusalemu. ");
INSERT INTO dov_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bakabweeza mitabi yatukunka akwinka kuyoswananaawe akompolola kuti, wosana ulilongezegelwe, ooyo usika muzina lyaMwami, waIzilayeli. ");
INSERT INTO dov_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu wakajana kambongolo kanini wakkala alinkako; mbuli mbukwakalembedwe. ");
INSERT INTO dov_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ Mutayowi nobana basimbi baZiyoni, amubone Mwami wanu ulaz, kakkede amusana wambongolo.” ");
INSERT INTO dov_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Basikwiya bakwe tebakamvwisisya pe kuzintu eezi kumatalikilo, pesi, aawo Jesu nakalemekezegwa bakayeya kuti eezi zintu zyakalembedwe ataala anguwe akuti bakachita zintu eezi kulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lino nkamu yakazuzikizigwa kuti bakali anguwe nakayita Lazalasi kuzwa muchumbwe akumubusya kuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chakali nchicho chizato kuti inkamu inkamu yakaya kuyoswanana nkambo bakamvwa kuti wakachita chitondezyo. ");
INSERT INTO dov_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bafalisi mpawawo bakati lwabo lwabo, “Bona takwe nchokonzya kuchita: laang, nyika yinka kunembo aatala aakwe.” ");
INSERT INTO dov_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lino bamwi baGiliki bakali mulibaabo bakalikuya kukomba kupobwe. ");
INSERT INTO dov_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aabo bakaya kuliFilipo, oyoowakazwa KuBbetisyaida mu Galili mpo wakakumbila wati, “ Mwalumi tuyanda kubona Jesu.” ");
INSERT INTO dov_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo wakeenda akuyobuzya Andulo, Andulo wakeenda aFilipo, mpo wakabuzya Jesu. ");
INSERT INTO dov_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu wakabasandula mpo wati, chindi chasika chamwana amuntu, kuti alemekezegwe. ");
INSERT INTO dov_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nchobeni, nchobeni ndamwambila anukut, imbuto yabbale yakawida munyika mpo yafwa, iyosyala lwayo ayilike, pesi kuti yafwa, ilazyaala michelo myiingi. ");
INSERT INTO dov_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ooo uyandisya buumi bwakwe takoyobujana, pesi utayandisyi buumi bwakwe kulizyanyika eeyi uyobamba buumi butamani. ");
INSERT INTO dov_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kuti umwi undigwasya, akunditobela, ooko nkumbede, ooko nkokuko mulanda wangu nkwabede. Oyoo undimanina milimo, Taata uyakumulemeka. ");
INSERT INTO dov_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Lino muuya wangu wapengeleka. Mpo ngambeenzii? “ ");
INSERT INTO dov_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Taata, lemekezya zina lyako.” Aboobo ijwi lyakazwa kujulu kaliti, “Ndachilemekezya mpo nzochilemekezya lubo.” ");
INSERT INTO dov_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aabobo nkamu yakayimvwi kumbali niyakamumvwa yakamba kuti kwakamvwika muzuzumo. Bamwi bakamba kuti mungelo ulawambula anguwe.” ");
INSERT INTO dov_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesu wakasandula wati, “ Eeli jwi telyazida ndime pesi lyazida ndinywe. ");
INSERT INTO dov_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lino ndolu lubeta lwanyika eeyi: Lino muzululi wanyika eeyi uzosowelwa aanze.” ");
INSERT INTO dov_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aawo mpunjonyampulwa kuzwa munyika, ndiyoyobolola bantu boonse kulindime. ");
INSERT INTO dov_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wakamba bobu kutondezya lufu lwakwe mbolunobede. ");
INSERT INTO dov_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Makamu akamusandula, “ Twakamvwa kuzwa kumulawu kuti Kkilisito uzokkala ikutamani. Wamba buyeni ikuti, ' Mwana Muntu uyelede kusumpulwa? Nguli ooyo Mwana Muntu? ");
INSERT INTO dov_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesu wakabambila kuti, “ Mumuni unolandinywe kwachindi chifwifwi. Mwende nimuchili mumun, ikuti mudima tukamuvumbi. Ooyo wenda mumudima taazi ooko nkwaaya. ");
INSERT INTO dov_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nimuchilamumuni, amusyome mumumuni kuchitila kuti mube bana bamumuni.” Jesu wakaamba zintu eezi aboobo wakamba zintu eezi wakeenda akulisisa mulimbabo. ");
INSERT INTO dov_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nikuba kuti Jesu wakachita zitondezyo zyiingi kuli mbaabo, pele takwe nibakasyoma mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kuti ijwi Ayizaya musinsimi lizuzikizigwe, muli zyakamba: “ Mwami, ooyo wakasyoma kwaamba kwesu, akuli oyoo luboko lwaMwami nkulyakayubunizidwa?” ");
INSERT INTO dov_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nkaambo kayaaya tebakayosyom, mbuli Ayizaya akakwe mwamba, ");
INSERT INTO dov_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wakofwazigwa meso aabo, akuyumya myoyo yabo, muliyimwi nzila bazobona ameso aabo akumvwisisya amyoyo yabo, akusanduka alimwi njobaponia”. ");
INSERT INTO dov_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ayizaya wakaamba eezi zintu nkaambo wakabona bulemu bwajesu akwambula aatala anguwe. ");
INSERT INTO dov_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pesi nikuba boob, akube kuti bazulwidi basyome muliJesu; pesi nkaambo kabaFalisi, tebakakumbila kulekelelwa pe kuti bataka kasigwi kuya kuchikombelo. ");
INSERT INTO dov_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bakayanda bulemu bwakazwa kubantu kwiinda bulemu bwakazwa kuliLeza. ");
INSERT INTO dov_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesu wakompolola wati, “Ooyo usyoma mulindime tasyomi biyo mulindime, Pesi akuliwoyo wakandituma, ");
INSERT INTO dov_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","aawoyo wabona ndime wabona nguwe ooyo wakatuma ndime. ");
INSERT INTO dov_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ndasika mbuli mumuni munyika, kuti ooyo usyoma mulindime takasyali mumudima. ");
INSERT INTO dov_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kuti wamvwa majwi aangu, pesi katabambide, simubeteki pe, tee ndaza kuzotonga nyika, pesi kufutula nyika. ");
INSERT INTO dov_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ooyo undikaka akutatambula majwi aangu, ulasikumubeteka. Ijwi ndindambula liyomubeteka kuzuba lyamamanino. ");
INSERT INTO dov_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nkambo nsilyambwidi pe, pesi nguTaata wandituma, ooyo wapa ndime chelelo chakwaamb, azyakwamba. ");
INSERT INTO dov_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ndiizi kuti chelelo mbuumi butamani, mbubobu nzizezi zindawamba - mbuli Taata mbwakambula kuli ndime, mbubobu ndilamba.” ");
INSERT INTO dov_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lino kalitana kutalika ipobwe lya Pasika. Jesu wakaziba kuti chiindi chakwe chasika chakuti azwe munyika eyi ayinke kuli Taata. Mbalikubayanda bakwe bakali munyika, wakabayanda mane kusika kumamamanino. ");
INSERT INTO dov_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lino Satani wakali wazibika kale mumoyo wa Judasi Sikaliyoti mwana wa Sayimoni, kuti awuzye Jesu. Ndilyo achilalilo. ");
INSERT INTO dov_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu wakalizi kuti wisi wakalimupede zyoonse mumanza akwe alimwi kuti wakazwide kul Leza alimwi wakali kubweda k uli Leza. ");
INSERT INTO dov_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wakanyampuka achilalilo mpawo wagwisya chikobela chakwe chakujulu. ");
INSERT INTO dov_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mpawo wakabweza chisansamuzyo walyaanga. Mpawo wakatila maanzi mubbede watalika kusanzya basikwiiya kumawulu akubayumya achisansamuzyo nchakangide muchikungu chakwe. ");
INSERT INTO dov_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Mpawo wakasika kuli Sayimoni Pita wakati kulinguwe, “Mwami uyanda kundisanzya mawulu na?” ");
INSERT INTO dov_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu wakasandula akumubuzya zyakuti, “Eechi nchenchita tamukochimvwisisisya.” ");
INSERT INTO dov_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita wakati kulinguwe, “tokonzyi kundisanzya mawulu angu, “Jesu wakamusandula wati, “kuti tendakusanzya tokooba abulyidilane pe ambebo. ");
INSERT INTO dov_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Sayimoni Pita wakati kulinguwe, “Mwami, tondisanzyi kumawulu kupela pesi akumaboko angu akumutwe.” ");
INSERT INTO dov_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu wakati kulinguwe, Muntu wasamba tabuli, kutalisanzya mawulu biyokupela, pesi amubili woonse wasamba, wasalala, pesi temonse nimwasalala.” ");
INSERT INTO dov_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Nkambo Jesu wakalimwizi utakamuuzye; nchenchicho nchaakambila, “Moonse tamusalede pe.”) ");
INSERT INTO dov_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nakamana kubasanzya mawulu abo wakabweza zisamo zyakwe wakkala ansi lubo, mpawo wakati kuli mbabo, “mwazimvwisisisya na nzinda muchitila? ");
INSERT INTO dov_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mundiita kuti Muyiisyi a Mwami mwamba kabotu, nkambo ndime. ");
INSERT INTO dov_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","kuti nkendi Mwami a Muyiisy, wamusanzya mawulu, anywebo mwelede kusanzya mawulu awumwi awumwi. ");
INSERT INTO dov_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nkaambo ndamutondezya chikozyanisyo kuti anywebo kuti anywebo muchite mbuli mbundamuchitila. ");
INSERT INTO dov_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16",", Chamasimpe, ndamwambila kuti, muzike talimupati kumubelesi wakwe naakuti mutumwa tali mupati kuli wamutuma. ");
INSERT INTO dov_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kuti kamuzizi eezi zintu mulilongezezegelwe kuti mwaziba. ");
INSERT INTO dov_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nsilokwamba moonse pe, ndibazi mbindakasala. Pesi ndaamba kuti malembe azuzikizigwe; Ooyo uulya chinkwa wandilyata akasindi kakwe.' ");
INSERT INTO dov_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ndamwambila zyoonse ezi kazitana chitika pe, kuchitila kuti zyazochitika muzosyome KUTI NDIME. ");
INSERT INTO dov_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nkasimpe, nkasimpe, ndamwambila kuti, woonse utambula ngundakatuma, wanditambula, awunditambula, watambula wakandituma.” ");
INSERT INTO dov_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nakaamba boobu Jesu, wakapengeleka mumuuya. Wakapandulula wati, “Nkasimp, nkasimpe, ndamwambila umwi wanu uyoondaba. ");
INSERT INTO dov_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Basikwiiya bakwe bakalangana umwi awumwi kabagamba kuti ngwani ngwakali kwamba. ");
INSERT INTO dov_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Umwi wabasikwiiya ba Jesu ngwakali kuyanda wakalilede atafula kumbali lya Jesu. ");
INSERT INTO dov_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sayimoni Pita wakamwambila sikwiya muyandisi kuti, “buzya kulinguwe kuti uwambani.” ");
INSERT INTO dov_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Lino wakaseyama akaango ka Jesu akumwambila kuti, “Mwami, ngaulabani ngowamba?” ");
INSERT INTO dov_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Mpawo Jesu wakasandula, “Oyu ngwensisunsile chinkwa akumupa.” Lino nakasunsa, wakapa Judasi mwana wa Sayimoni Sikaliyoti. ");
INSERT INTO dov_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Mpawo nikwakiinda kulya chinkwa, satani wakanjila mulinguwe, kuzwawo Jesu wakamubuzya kuti “Eecho nchoyanda kuchita, chichite akufwambana. ");
INSERT INTO dov_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lino takwe naba omwe wabakalede atafula wakaziba kuti nkambozi nawambula oobo. ");
INSERT INTO dov_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bamwi bakayeeya kuti Judasi mbali sinkomo wamali, Jesu ambweni uyanda kuti akawule ziyandikana apobwe, “Naakuti ape zimwi kubantu bafwaba. ");
INSERT INTO dov_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Naakamana kutambula chinkwa, wakeenda chakufwambana. Kwakali mansiku. ");
INSERT INTO dov_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lino Judasi nakeenda, Jesu wakati, “Lino Mwana a Muntu walamekezegwa, alakwe Leza ulalemekezegwa mulinguwe. ");
INSERT INTO dov_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Leza ulalemezya mwana mulinguwe, alimwi ulamulemya lumwi chakufwambana. ");
INSERT INTO dov_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nobana banini, ndandinywe kwachiindi chifwifwi. Muyondiyandula mbuli mbundakabuzya ba Juda, “oko nkwenjobuya, tamukonzyi kusika. Lino ndamba eechi kulindinywe. ");
INSERT INTO dov_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ndamupa mulawu mupya, wakuti muyandane umwi awumwi. ");
INSERT INTO dov_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Acheechi bantu boonse bazooziba kuti ndinywe basikwiya bangu, kuti mwaba luyando kulumwi amwenzinyina.” ");
INSERT INTO dov_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sayimoni Pita wakati kulinguwe, “Mwami, nkokuli nkoya? Jesu wakasandula, “ooko nkwenja tokonzyi kunditobela kwaino, pesi uzonditobela chaba chiindi. ");
INSERT INTO dov_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita wakati kulinguwe 'Mwami nkamboonzi nentakkonzyi kukutobela? Ndatula buumi bwangu nkambo kako. ");
INSERT INTO dov_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesu wakasandula, “ulatuula buumi bwako na nkambo kangu? Nkasimpe, nkasimpe ndakwambila kuti mukombwe takolila kotana kunditama totatwe. ");
INSERT INTO dov_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Myoyo yenu kitapengi. Musyome muli Leza, musyome amulindime. ");
INSERT INTO dov_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mun'anda yaTaata mwaali makkalilo miingi. Nikutalibbobo tendalikunoomwaambila pe, lino ndiya kukumubambila busena. ");
INSERT INTO dov_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na ndiinka kuyomubambila busena ndiyoboola kuzomutola, kuti ooko nkwebede mukabeko anywebo. ");
INSERT INTO dov_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Muliizi inzila yakoko nkwenjobuya.” ");
INSERT INTO dov_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasi wakati kuli Jesu, “Mwaami, tatukwizi pe nkoyobuya, tuliiziba biyei nzila?” ");
INSERT INTO dov_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu wakati kulinguwe, “Ndime nzila, bwini, abuumi; tawo pe uuza kuli Taata natiinda mulindime. ");
INSERT INTO dov_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nansyo mulindizi, nimumwizi Taata alakwe. Kuzwa sunu mwamuziba alimwi mwamubona.” ");
INSERT INTO dov_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipi wakati kuli Jesu, “Mwaami, tutondeezya Taata, aawo kunoli kwazuzikizigwa kulindiswe.” ");
INSERT INTO dov_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu wakati kulinguwe, “Ndakali aandinywe kwachiindi chilamfu alimwi tamunaa kundiziba, Filipi? Ooyo wandibona wabona Taata. Kujana ulaamba biyeni kuti, “Tutondeezye Taata?' ");
INSERT INTO dov_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Tondisyomi na kuti ndili muli Taata alimwi Taata uli muli ndime? Majwi ngindamwaambila nywe nsyaawambi kuzwa munguzu zyangu, pesi Taata upona mulindime ulikuchita mulimu wakwe. ");
INSERT INTO dov_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mundisyome kuti ndili muli Taata, akuti Taata uli mulindime, nikuba kuti usyome akaambo kamilimu lwayo. ");
INSERT INTO dov_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nchobeni, nchobeni, ndamwaambila, ooyo uusyoma mulindime uyoochita milimu njechita, alimwi uyoochita milimu mipati kwiinda eeyi nkaambo ndiya kuli Taata. ");
INSERT INTO dov_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kufumbwa nchimuyookumbila muzina lyangu, ndiyomuchitila kuchitila kuti Taata akabe aabulemu mu Mwana. ");
INSERT INTO dov_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na mwakumbila kufumbwa muzina lyangu, ndiyomuchitila. ");
INSERT INTO dov_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Na mwandiyanda muyoobamba milawu yangu, ");
INSERT INTO dov_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","alimwi ndiyookomba kuli Taata alimwi uyomupa uumbi mugwasyi kuchitila kuti akabe aandinywe kusikila kukabe kutamani - ");
INSERT INTO dov_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Muuya wakasimpe. Ooyo nyika ngwitakabule kumutambula pe nkaambo timubwene pe na kumuziba. Pesi mulimwizi, alimwi ukkala andinywe alimwi uli mulindinywe. ");
INSERT INTO dov_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nsikoyoomusiya amulike, ndiyooboola kulindinywe. ");
INSERT INTO dov_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Biyo kwachiindi chifwifwialimwi nyika tikozondibona lubo me, pesi muzondibona. Akaambo kakuti ndilapona, andinywe munoyopona. ");
INSERT INTO dov_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mubuzuba oobo muyoziba kuti ndili muli Taata, akuti muli mulindime, akuti ndili mulindinywe. ");
INSERT INTO dov_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ooyo uli amilawu yangu akwiibamba nguwe undiyanda, alimwi ooyo undiyanda uyooyandwa aTaata wangu, alimwi ndiyomuyanda akulitondeezya kulinguwe.” ");
INSERT INTO dov_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (pe pe Sikkaliyoti) wakati kuli Jesu, “Mwaami, nkaambonzi noyolitondezya kulindiswe notayolitondeezyi kunyika?” ");
INSERT INTO dov_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu wakasandaula alimwi wati kulinguwe, “Na kuli uumwi undiyanda, uyoobamba majwi aangu. Taata ulamuyanda alimwi tuyosika kulinguwe alimwi tuyoyaka muunzi anguwe. ");
INSERT INTO dov_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ooyo utandiyandi mebo takwe nabamba majwi aangu. Ijwi ndimumvwa talizwi kulindime pesi kuli Taata wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ndaamba zintu eezi kulindinywe kuchiindi nkechipona andinywe. ");
INSERT INTO dov_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nekubaboobo, Mugwasyi - Muuya Uusalala ooyo Taata ngwayootuma kwiindila muzina lyangu - uyoomuyiisya zyoonse akumuyezya zyoonse nzindakamwaambila nywe. ");
INSERT INTO dov_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ndamusiila luumuno; ndamupa luumuno lwangu. Tendamupa pe mbuli nyika mbwiipa. Myoyo yanu itapengi, alimwi mutapengi. ");
INSERT INTO dov_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mwakamvwa eezyo nzindakaamba kulindinywe; Ndiyobweenda alimwi nzooboola lubo kulindinywe. 'Na mwalikundiyanda, mwalikubotelwa nkaambo ndiya kuli Taata, nkaambo Taata mupati kwiinda ndime. ");
INSERT INTO dov_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lino ndamwaambila kazitanaachitikana kuchitila kut, nizyazochitika, muzosyoma. ");
INSERT INTO dov_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nsikoyoowambula twiingi andinywe, nkaambommweendelezi wanyika eeyi uyobuza. Takwe manguzu pe aatala andime, ");
INSERT INTO dov_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pesi mukuti inyika izibe kuti ndilamuyanda Taata, ndilachita mbubo mbuli Taata mbaakandilayilila mebo. Ngatukanyampuke alimwi tukeende kuzwa aano.” ");
INSERT INTO dov_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ndimusamu wakasimpwa Taata ngomuka mwini muunda? ");
INSERT INTO dov_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Uyogwisya ntabi zyoonse mulindime zitazyali michelo, akukwezuula ntabi zitazyali michelo kuchitila kuti zikazyale michelo. ");
INSERT INTO dov_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ulasalala kale nkambo kamilumbe njindakawambula kulinduwe. ");
INSERT INTO dov_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kkalilila mulindime, andime mulinduwe, mbuli mutabi, utakonzyi kuzyala michelo lwayo, kunze kwakuti wayima kuchisiko, kuti amwi ulakonzya kuzyala, kunze kwakukkalilila mulindime. ");
INSERT INTO dov_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ndichisiko chamusamu, inywe muli mutabi. Oyo ukkalilila muli ndime, ambebo mulinguwe, ulazyalisya michelo, kotakwe ndime takwe nchokonzya kuchita. ");
INSERT INTO dov_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ooyo naba oomwe uutakkali mulindime, Uyosowegwa mbuli mutabi mpo uyoyuma, alubo iyobwezelelwa mitabi akuyowalilwa mumulilo, mpawo iyotentwa. ");
INSERT INTO dov_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kuti wakkalilila mulindime, akuti majwi angu akkala mulinduwe, kumbila kufumbwa nchoyanda, mpawo uyochitilwa mboyanda. ");
INSERT INTO dov_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Taata ulalemekezegwa azeezi, kuti wazyalisya michelo akulitondezya kuti nduwe sikwiiya wangu. ");
INSERT INTO dov_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mbuli Taata mbandiyandisya mebo, Ndakuyanda ambebo; mukkalilile mulindime. ");
INSERT INTO dov_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kuti wabamba milawu yangu, unokkalilide muluyando lwangu, mbundaka bambamilawu ya Taata akukkalilila muluyando lwakwe. ");
INSERT INTO dov_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ndambuula ezi zintu kulindinywe nkuchitila kuti lukondo lube muli nduwe, akuchitila kuti lukondo lumaninine. ");
INSERT INTO dov_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ooyu ngomulwu wangu, kuti muyandane mbuli mbondakamuyanda. ");
INSERT INTO dov_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Takwe naba omwe ulaluyando luli oobu-kuti umwi abambe buumi bwakwe mwenzinyina. ");
INSERT INTO dov_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Muli benzuma kuti mwachita zintu nzindakamulayilila. ");
INSERT INTO dov_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nsichiyomwiti kuti babelesi, nkambo mubelesi tazi kuti simalelo akwe anzyachita. Ndamwita kuti benzuma, mbuli zyoonse nzindakamvwa kuli Taata, ndachita kuti zizibinkane kulindinywe. ");
INSERT INTO dov_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Teensi mwakandisala mebo, pesi ndakamusala inywebo kumwimika nywe kuti mwelede kwenda akuzyala michelo, akuti michelo yanu ikkalilile. Eechi chamba kuti kufumbwa nchimuyokumbila kuli Taata kwinda muzina lyangu, uuyochipa kulindinywe. ");
INSERT INTO dov_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Eezi zintu nzindamu layilila, kuti mukonzye kuyandana umwi awumwi. ");
INSERT INTO dov_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kuti nyika yakusula, ziiba kuti yakalindisulide nkitana kukusula webo. ");
INSERT INTO dov_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kuti wali muntu wenyika, inyika ilakuyanda lwayo. Pesi nkambo kakuti taliwanyika akambo kakuti ndakakusala kuzwa munyika, nkiinkako inyika iyokusula we. ");
INSERT INTO dov_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Koyeeya ijwi ndindakakwambila we, Ímubelesi tali mupati kwinda simalelo.'Na bandipenzya mebo, bayomupenzya anywebo; Anukuti balondola majwi angu, bayowalondola amajwenu. ");
INSERT INTO dov_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Bayochita zyoonsezi zintu kuli nduwe nkambo kezina lyangu, nkambo tabamwizi pe wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Anoli tendakasika akwambuula kuli mbabo, teensi bayinobisya, pesi kwalino tabakwe nchebanga balatamizya kukubisya kwabo. ");
INSERT INTO dov_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ooyo wakkaka ndime ngonguwe wakkaka Taata. ");
INSERT INTO dov_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ikuti tendachita milimo takwe naaba oomwe ukazya akati kabo, takwe nibanola chibi pe, pesi lino bibona akusula ndime a Taata. ");
INSERT INTO dov_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pesi eezi zitondezya kuzuzikizya majwi alembedwe mumulawu, 'Bandisula nkenditakwe mulandu.' ");
INSERT INTO dov_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Eelyo mugwasyi nayosika - ooyo ngwenjotuma kuli ndinywe kuzwa kuli Taata, nguwe ooyo Muuya wakasimpe, ooyo iwakazwa kuli Taata - Uyoopa bukamboni atala andime. ");
INSERT INTO dov_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Uleelede ayebo kupa bukamboni, nkambo wakali andime kuzwa kumatalikilo. ");
INSERT INTO dov_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ndamwambila ezi zintu kulindinywe kuchitala kuti mutalebwi. ");
INSERT INTO dov_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bayomusowela anze achikombelo pesi chiindi chiyosika echo woonse oyo utakamujaye uyochitanga wamanina Leza mulimo. ");
INSERT INTO dov_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bayochita ezi zintu nkaambo tabana kumuziba Taata nekuba ndim. ");
INSERT INTO dov_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ndamwambila ezi zintu kulindinywe kuchitila kuti chiindi chazyo chakusik, muyoyeya kuti kakamwambila atala anzizy. Tendakamwambila atala azezi zintu kumasangunin, kambo ndakachili anywebo. ");
INSERT INTO dov_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pele lino ndayinka kuliyoyo iwakanditum, takukwe akati kanu undibuzya kut, uyakuli? ");
INSERT INTO dov_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'Pesi nkaambo ndamwambila ezi zintu kuli ndinyw, kubijilwa kwazula mumyoyo yanu ");
INSERT INTO dov_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pesi ndamwambila kasimp, chibotu kulindinywe kuti ndiink. Ukuti tendink, Mugwasyi takosika pe kulindinyw, pesi kuti ndayink, ndiyomutumina nguwe kuli ndinywe. ");
INSERT INTO dov_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Elyo asik, Mugwasyi uyotondezya nyika kuti iibisizye atala aziib, atala abululam, atala alubetek, ");
INSERT INTO dov_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","atala aziib, nkaambo tabandisyomi. ");
INSERT INTO dov_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ataala abululam, nkaambo ndilayinka kuli Taat, aboobo tamukachindiboni limbi, ");
INSERT INTO dov_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","alubeteko nkaambo nkaambo mweendelezi wanyika eyi wabetekwa kale. ");
INSERT INTO dov_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ndazyingi zintu zyakumwambil, pesi tamukomvwisisya lino. ");
INSERT INTO dov_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","pesi walo muuya wakasimp, asik, oyo umwenzya mukasimpe koonse, pesi takoyowamba izyakwe mwini. Pesi uyowamba ezyo zyatakamwvwe aboobo uyomwambila zintu izichiz. ");
INSERT INTO dov_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Uzondilumbayizy, nkaambo uzobweza zyali zyangu akuzyambila ndinywe. ");
INSERT INTO dov_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Zyoonse zyajisi Taata nzizyangu. Nchechich, nchindamba kuti Muuya ulabweza zyali zyangu akuzyambila ndinywe. ");
INSERT INTO dov_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","chaba chiindi chifwifwi tamuchikandiboni limb, aboobo kwakuyinda chiindi chifwifwi muyondibon.” ");
INSERT INTO dov_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Alimwi bamwi basikwiya bakwe kuli umwi aumw, “Chamba nzi echi nchatwambila sweb, 'chaba chindi chifwifwi tamukachindiboni limbi aboob, 'Nkaambo ndayinka kuli Taata'?” ");
INSERT INTO dov_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nchechicho nchibakamba kut, Çhamba nzi echi chawamb, 'chaba chindi chifwifwi '? Tatuzi kuti uwambula atala anyamayi”. ");
INSERT INTO dov_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu wakabona kuti bakali kuyanda kubuzya kulinguw, aboobo wakabambila kut, Ézi nzizyo na nzimwalikulibuzya lwanu, kuti ndiwamba nzi kandamb, kuti muchindi chifwifwi tamuyokondibona limbi, aboobo muchindi chifwifwi muyondibona? ");
INSERT INTO dov_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nkasimp, nkasimp, ndamwambila muyokwila akoomok, pesi nyika iyokondw. Alimwi muyozula kubijilw, pesi mapenzi anu ayosanduka akuba lukondo. ");
INSERT INTO dov_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mwanakazi chiindi nayanda kutumbuka ulabijilwa nkaambo chiindi chakwe chasik, pesi chindi natumbuka mwan, tachiyeyi limbi machise akwe nkaambo kakukondwa kuti muntu watumbukwa mukati kanyika. ");
INSERT INTO dov_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Anywebo mwabijilwa lin, pesi ndiyomubona lub, aboobo myoyo yanu iyo kondw, aboobo takwe naba omwe uyokonzya kumunyanga kukondwa kwanu. ");
INSERT INTO dov_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Mubuzuba obo takukwe uyondibuzya chint. Nkasimp, nkasimp, ndamwambila kut, na mwakumbila kufumbwa chintu kuli Taata muzina lyang, uyomupa nchich. ");
INSERT INTO dov_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ambuleno tamunakukumbila chintu mu zina lyang. Kumbila uyopegwa, kuchitila kuti kukondwa kwanu kuzuzikizigwe” ");
INSERT INTO dov_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ndamwambila ezi zintu kuli ndinywe mutulabik, pesi chiindi chilasika nchetachiyomwambili mutulabik, pesi anukuti ndiyomwambila antaanganana atala aTaata. ");
INSERT INTO dov_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Mubuzuba obo muyokumbila muzina lyangu aboobo nsikoyomwambila kuti ndiyomukombela kuli Taata, ");
INSERT INTO dov_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pesi Taata lwakwe ulamuyanda nkaambo mwakandiyanda andime aboobo nkaambo mwakasyoma kuti ndakazwa kuli Leza. ");
INSERT INTO dov_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ndakazwa kuli Taat, aboobo ndakaza munyik. Lubo ndiyozwa munyika aboobo ndilayinka kuli Taata.” ");
INSERT INTO dov_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Basikwiya bakwe bakati,' 'Bona, lino wambula antaanganana aboobo tolikubelesya tulabiko pe. ");
INSERT INTO dov_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lino twaziba kuti ulizi zintu zyoonse, aboobo toyandi naba omwe kuti akubuzye mibuzyo. Nkaambo kazezi, tulasyoma kuti wakazwa kuli Leza.” ");
INSERT INTO dov_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesu wakabasandula,” Mwasyoma na lino? ");
INSERT INTO dov_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bon, chiindi chilasik, iyii, aboobo nchechicho echino chimuyowazana aumwi aumwi kumunzi wakw, aboobo aboobo muyondisiya andikk. Nekuba boobo nsili andikke pe nkaambo Taata ula ndim. ");
INSERT INTO dov_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ndamwambila ezi zintu kuti mube alumuno mulindim. Munyika mube mapakasy, pesi amube akujatilila; Ndakizunda nyika. ");
INSERT INTO dov_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesu nakamana kwamba zintu eezi, wakatambya meso akwe kumajulu akwamba kuti, “Taata, chiindi chasika, mupe bulemu Mwanaako kuchitila kuti alakwe Mwana akupe bulemu - ");
INSERT INTO dov_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","mbuli mbwakamupa bwendelezi atala ailengwa zyoonse kuchitila kuti azope buumi butamani kuli woonse ooyo ngwakapa kuli nguwe. ");
INSERT INTO dov_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mbuli ibuumi butamani kuti bakuzibe, nduwe Leza wakasimpe, akuli nguwe ooyo ngwakatuma, Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ndakakupa bulemu anyika. Ndakamaninsya mulimo oyo nguwakandipa kuti nguuchite. ");
INSERT INTO dov_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Lino, Taata, kondilemya antomwe ayebo abulemu obo mbendali kujusi nkechili ayebo, inyika kitanaanzwa. ");
INSERT INTO dov_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ndakayubununa izina lyako kubantu aabo mbwakandipa kuzwa kunyika. Bakali bako, wakabapeda kuli ndime bakabamba ijwi lyako. ");
INSERT INTO dov_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lino bakaziba kuti zyoonse eezyo nzwakandipa zizwa kuli nduwe, ");
INSERT INTO dov_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nkambo ndakabapa woonse majwi ayo ngwakandipa. Bakaatambula mpawo akuziba bwini bwakuti ndakazwa kuli nduwe mpawo bakasyoma kuti wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ndabakombela. Nsikombeli banyika pe pesi aabo mbwakandipa nkambo mbibako. ");
INSERT INTO dov_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Choonse eecho changu nchichaako mpawo chako nchichangu mpawo mpegwa bulemu mulimbabo. ");
INSERT INTO dov_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nsichili munyika, pesi aaba bantu balimunyika, mpawo ndikuza kuli nduwe. Taata Uusalala, babambe muzina lyako elyo nduwe wakandipa kuchitila kuti babe bamwi mbuli mbutuli bamwi. ");
INSERT INTO dov_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nindakachili ambabo, ndakabambide kabotu muzina lyako, eelyo ndwakandipa. Ndakaba kwabilila, mpawo takwe nikuba umwi wakanyonyoka, kusiya mwana wabajayi, kuchitila malembe kuti azuzikizigwe. ");
INSERT INTO dov_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lino ndaboola kulinduwe, pesi ndikwamba zintu eezi munyika kuchitila kuti lukondo lwangu luzozuzikizigwe muli mbabo. ");
INSERT INTO dov_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ndakabapa ijwi lyako, mpwao nyika yakabasula nkambo tabali benyika eeyi, mbuuli mbuntali wenyika. ");
INSERT INTO dov_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nsilokukumbila kuli nduwe kuti ubagwisye munyika, pesi kuti babambwe kabotu kulibaabo batalomene. ");
INSERT INTO dov_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tembanyika pe mbuli mbentali wenyika ambebo. ");
INSERT INTO dov_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mubaanzanisye kwinda kukasimpe. Ijwi lyako ndayakasimpe. ");
INSERT INTO dov_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mbuli mbowakandituma munyika ndabatuma ambebo munyika. ");
INSERT INTO dov_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Akambo kambabo, ndalibamba lwangu kuchitila kuti abalabo babambwe mukasimpe. ");
INSERT INTO dov_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nsikombeli aaba luzutu pe, pesi abaabo batakasyome mulindime kwinda kujwi lyaako ");
INSERT INTO dov_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kuchitila kuti boonse bakabe umwi mbuli nduwe. Taata mbuli muli ndime, andime ndimuli nduwe. Aabalabo abaabe muli ndiswe kuchitila kuti inyika ikasyome kuti nduwe nuwakandituma. ");
INSERT INTO dov_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ibulemu oobo mbuwakandipa, ndakabupa kuli mbabo, kuchitila kuti babe uumwi, mbuli mbundi umwi. ");
INSERT INTO dov_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ime muli mbabo, mpawo iwe muli ndime - kuti mpobazulila mulukamantano, kuti inyika izibe kuti wakandituma akuti wakabayanda mbuli mbuwakayanda ndime. ");
INSERT INTO dov_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Taata, njanda aabo mbwakandipa kuti baabe andime ooko nkuumbede, mpawo akubona bulemu mbwakandipa nkambo wakandiyanda intalisyo yenyika kitana kubambwa. ");
INSERT INTO dov_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Taata ululeme, inyika teyaka kwizi pe, pesi mebo ndakali kwizi, mpawo aaba balizi kuti wakandituma. ");
INSERT INTO dov_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ndakachita kuti izina lyako lizibinkane kuli mbabo, nkabela ndichiyolizibya kuchitila kuti luyando ndwakandiyanda aalo lukabe muli mbabo, mpawo nooli muli mbabo.” ");
INSERT INTO dov_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu nakamana kwambula majwi aaya, wakainka kuli aanze abasikwiiya bakwe kuli bumwi busena mumusena wa Kkidiloni, oko kwakali chilili mwakakunjila abasikwiya bakwe. ");
INSERT INTO dov_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Lino Judasi ooyo wakali sikuyo mwaba, alakwe wakalibwizi busenobu nkambo Jesu wakali kuswanana absikwiya bakwe nkuko. ");
INSERT INTO dov_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Mpawo Judasi wakazulwida inkamu yabasilumamba abamwi bendelezi bazwa kubapayizi bapati akubaFalisi, abasizyuno, bakayinka nkukoko amalampi, azimunisyo, azilwanisyo. ");
INSERT INTO dov_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Mpawo Jesu, iwakazi zyoonse zintu ezyo zyakali kuyochitika kulinguwe, wakaya kunembo wababuzya kuti, “Ngwani ngomulokuyanduula?” ");
INSERT INTO dov_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bakamusandula, “Jesu waku Nazaleta.” Jesu wakati ndamwambila kuti, “Ndime.” Judasi ooyo wakamuzya wakaliimvwi abasiliumamba. ");
INSERT INTO dov_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nakaamba kuli mbabo kuti, “Ndime,” bakabwedela musule bawidaansi. ");
INSERT INTO dov_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wakababuzya lubo, “Ngwani ngomulokuyanduula?” Lubo bakindulula bati, “Jesu waku Nazaleta.” ");
INSERT INTO dov_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesu wakasandula, “Ndamubuzya kuti ndime. Na kamulokuyandula ndime, amubaleke aaba beende.” ");
INSERT INTO dov_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ezi zyakachitika kuti ijwi ndyakaamba lizuzikizigwe: “kuti kulibaabo mbwaakandipa takwe ngundakasowa pe.” ");
INSERT INTO dov_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Alimwi Sayimoni Pita, wakali akafulo, wakakasomona wagonka mulanda wamupayizi mupati wamugonka kutwi kwakuchilisyo. Lino izina lyamulanda oyu wakali Malukkasi. ");
INSERT INTO dov_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesu wakati kuli Pita, “Bweedezya ikafulo munkomo. Nsyelede kunywa muchinywido eecho Taata nchaakandipa mebo?” ");
INSERT INTO dov_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Awo inkamu yabasilumamba amupati wabo, ababelesi babaJuda, bakajata Jesu akumwaanga. ");
INSERT INTO dov_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kutanguna bakamutola kuli Aanasi, nkambo wakali yisizyala wa Kkefasi, wakali mupayizi mupati munyokoyo. ");
INSERT INTO dov_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Lino Kkefasi wakali nguwe wakapede lulayo kubaJuda kuti nichali chibotu kuti umwi muntu afwide bantu boonse. ");
INSERT INTO dov_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sayimoni Pita wakatobela Jesu, alimwi awumwi sikwiiya. Lino ooyu sikwiiya wakazibinkene kubapayizi bapati, aboobo wakanjila a Jesu munkuta yabapayizi bapati. ");
INSERT INTO dov_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pesi Pita wakaliimvwi amulyango kalaanze, mpawo umwi sikwiya, wakazibinkene kubapayizi bapati, wakazwa aanze kuyowambuula abalinda amulyango, mpawo wakanjizya Pita mukati. ");
INSERT INTO dov_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mpawo mulanda wachikayintu, wakalikubamba amulyango, wakabuzya Pita kuti, “Tooli umwi wabaabo basikwiiya bayooyu mwalumi na, wakasikuti, “teensi ndime pe.” ");
INSERT INTO dov_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Lino balanda abasikubeleka muwofesi bakalimvwi awo, nkabela bakali bakutilizya mulilo nkambo kwakali kutontola, bakali kuyota. Pita ambabo kayimvwi kalikuyota alakwe. ");
INSERT INTO dov_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mupayizi mupati wakabuzya Jesu aatala abasikwiiya bakwe anjiisyo yakwe. ");
INSERT INTO dov_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu wakamusandula, “Ndakambuula entanganana kunyika. Choonse chiindi ndakali kuyiisya muzitumba amuzikombelo akoko baJuda nkubakali kuswanana. Taakwe pe nchindakaamba mukusisikizya. ");
INSERT INTO dov_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nkambonzi nimundibuzya? Kabuzye kuli bakandimvwa ataala azezyo nzindakaamba. Boona, aaba bantu balizizi nzindakaamba.” ");
INSERT INTO dov_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesu nakamana kwamba eezi, umwi wababelesi wakayimvwi wakawuma Jesu wati, “Mbubo na mboyelede kusandula mupayizi mupati?” ");
INSERT INTO dov_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu wakatikuli nguwe, “kuti nkendi ndaambula bubi, paa bukamboni atala abubi, pesi kuti kakuli kabotu, unduuminayi? ");
INSERT INTO dov_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mpawo Aanasi wakamutola kaangidwe kuli Kkayifasi mupayizi mupati. ");
INSERT INTO dov_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Lino Sayimoni Pita wakalimvwi kayoota mulilo. Bantu bakati kulinguwe, “Sena tenduwe umwi wabasikwiiya bakwe na? Wakakaka akwamba kuti, “Tensindime pe.” ");
INSERT INTO dov_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Umwi wabalanda bamupayizi mupati, wakali munyina wamwalumi ulakutwi Pita nkwakagonkede, wakati, “Tooli nduwe na ngundakabwene muchilili anguwe?” ");
INSERT INTO dov_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mpawo Pita wakakaka lubo, mpawo mukuku wakakokolika. ");
INSERT INTO dov_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Eelyo bakatola Jesu kuzwa kuli Kkayifasi kuya kukubetekwa. Kwakachili kuseni loko, nkabela tebakanjila pe mubbetekelo kuchitila kuti tabasofwazigwi pe pesi bakakonzye kulya pasika. ");
INSERT INTO dov_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Awo Pilato wakazwa aanze waya kuli mbaboo wasikuti, “Nguuli mulandu ngumweeta ayoyu mwalumi?” ");
INSERT INTO dov_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bakasandula kabati kulinguwe, “Aanoli ooyu mwalumi tesimuchita zibi, Tetwayinomweeta kuli nduwe pe.” ");
INSERT INTO dov_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Mpawawo Pilato wakati kulimbabo, “mumutole ndinywe, akuyomubeteka kwinda mumulawu wanu.” MaJuda bakati kulinguwe, “Tachili mumulawu pe kulindiswe kubikka kufumbwa umwi muntu kulufu.” ");
INSERT INTO dov_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Bakaamba ezi kuchitila kuti ijwi lya Jesu lizuzikizigwe eelyo ndyakaamba kutoondezya atala amusyobo walufu ndwayizofwa. ");
INSERT INTO dov_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Mpawo Pilato wakanjila mungánda yakubetekela lubo wayita Jesu wamubuzya kuti, “Nduwe Mwami waba Juda na?” ");
INSERT INTO dov_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu wakasandula, “Ulokulyambwida na, nakuti kuli bamwi bakambula atala andime kuli nduwe?” ");
INSERT INTO dov_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato wakasandula, “Nsili muJuda pe me, ndinguwe na? Bantu bako abapayizi bapati bakupeda kuli ndime. Niinzi nchiwachita?” ");
INSERT INTO dov_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu wakasndula, “Bwami bwangu tabuli bweenyika eeyi pe. Aanoli bwami bwangu bwali bwachimwi chipanzi chenyika eeyi, balanda bangu bayinokulwana kuchitila kuti nkindeka kwabwa kuba Juda. Pesi lino bwami bwangu tabuzwidi aano pe. ");
INSERT INTO dov_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato wakati kulinguwe, “Uli mwami na?” Jesu wakamusandul, “wamba kuti ndimwami. Kuuli aya makanze ndakazyaligwa, akuli aya makanze ndakasika munyika, kuti ngaambe bukamboni mukasimpe. Woonse ooyo uuli mukasimpe ulaswilizya kujwi lyaangu.” ");
INSERT INTO dov_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato wakati kulinguwe, “niinzi kasimpe?” Ndakazwa kwaamba eezi, wakayinka kumaJuda wamba kuli mbabo, Takwe mulandu pe ngundajana mumwalumi ooyu. ");
INSERT INTO dov_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pesi mulachiyanza chakuti ndiwangunune umwi muntu kuli ndinywe apasika. Aabobo mulayandana kuti ndimulekezezye mwami waba Juda?” ");
INSERT INTO dov_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mpawo bakoompolola lubo akwamba kuti, pepe oyu mwalumi, pesi Bbalabbasi.” Lino oyu Bbalabbasi wakaali mubbi. ");
INSERT INTO dov_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mpawo Pilato wakatola Jesu akuyomunabba. ");
INSERT INTO dov_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Basilumamba bakalunda ingowani yamamvwa. Bakayibikka amutwe waJesu bamuzwatika asila lyamusyobo wantuumbula. ");
INSERT INTO dov_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bakasika kulinguwe basikuti, wabonwa, “Mwami waba Juda!” mpawo basikumuma. ");
INSERT INTO dov_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato wakabbuda aanze lubo wasikuti kulimbabo, “Mubone, ndikumweeta anze kulindinywe kuchitila kuti muzibe kuti nsijene mulandu pe aalinguwe.” ");
INSERT INTO dov_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Awo Jesu wakabbuda aanze, kazweete musini wamamvwa asiila lyachikobela chamusyobo wantumbula. Pilato wakati kulimbabo, “Mubone ngooyu mwalumi!” ");
INSERT INTO dov_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mpawo awo bapayizi bapati ababelesi nibakabona Jesu, bakoompololesya bati, “Aababmbulwe, abambulwe!” Pilato wakati kuli mbabo, “Mumutole ndinywe mukamubambule nkambo nsijene mulandu pe kulinguwe.” ");
INSERT INTO dov_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ba Juda bakamusandula, “Tulijisi mulawu, alubo kwinda mumulawu oyoo, welede kufwa nkambo wakali kulyaamba kuti Mwana waLeza.” ");
INSERT INTO dov_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aawo Pilato nakamvwa nkani eeyi, wakayoweesya loko. ");
INSERT INTO dov_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wakanjila mungánda yakubetekela lubo wati kuli Jesu, “Uuzwa kuli? Pesi Jesu takwakasandula pe. ");
INSERT INTO dov_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Mpawo Pilato wakati kulinguwe, “Towambuli na kulindime?” Toozi na kuti ndilenguzu zyakukwangununa aanguzu zyakukubambula? ");
INSERT INTO dov_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesu wakamusandula, “Tojisi pe kupanguzu alindime kusiya eecho nchiwakapegwa kuzwa kujulu, nikuba oobo, ooyo wandipedya kuli nduwe ulaachibi chipati.” ");
INSERT INTO dov_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kunsandulo eeyi, Pilato wakeezya kumwangununa pesi bama Juda bakawompoolola kabati, “kuti wangununa mwalumi ooyu, “Tooli muzolwani wa Siza. Woonse ulichita mwami uuwambula ataala a Siza. ");
INSERT INTO dov_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato nakamvwa makani aaya wakeeta Jesu aanze wakkala aachuno chakubetekela mubusena bwiitwa kuti “Ibbuwa lyamabwe,” pesi mumulaka wachi Hibbulu, ni “Gabbata.” ");
INSERT INTO dov_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lino lyakali izuba lyakubambililwa kwapasika, chiindi chamahola aali musanu alimwi. Pilato wakati kuba Juda, “Mulange ngoyu mwami wenu!” ");
INSERT INTO dov_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bakawompolola, “Kuule anguwe, kule anguwe, “Abambulwe!” Pilato wakati kuli mbabo, “Mubambule na mwami wenu?” Bapayizi bapati bakasandula, “Tatukwe mwami pe, pesi Siiza.” ");
INSERT INTO dov_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mpawo Pilato wakapedekezya Jesu kuli mbabo kuti abambuulwe. ");
INSERT INTO dov_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mpawo bakatola Jesu, bayinka aanze, kalibwezelede chiingano, kubusena butegwa “Kaanza,” chiitwa kuti “Gologota.” mumulaka wachi Giliki. ");
INSERT INTO dov_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bakamubambula Jesu nkuko, antomwe abamwi baalumi babili umwi kuli eeli bbazu, umwi kuli eeli, Jesu kali akati. ");
INSERT INTO dov_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato wakalemba chitondezyo wachibika achiingano. Chakalembedwe obu: JESU, MWAMI WABA JUDA. ");
INSERT INTO dov_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","BaJuda biingi bakalikuchibala chitondezyo eechi nkambo busena Jesu nkwakabambwidwe bwakali afwifwi adolopo. Chitondezyo chakalembedwe mumilaka eyi, chi Hibbulu, Latini, antomwe amuchi Giliki. ");
INSERT INTO dov_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Eelyo bapayizi bapati babaJuda bakati kuli Pilato, “Utalembi kuti, “Mwami wabaJuda, pesi utedi, “Ooyu uulyamba kut, “Ndimwami wabamaJuda.”” ");
INSERT INTO dov_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato wakasandula kuti nzindalemba, ndalemba.” ");
INSERT INTO dov_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Basilumamba nibakabambula Jesu, bakatola zisamo zyakwe, bazyabana akati kabo muzibeela zyoone, kuti baabane umwi awumwi, achilacho chibaki. Lino chibaki chakali abusumyo buumwi kuzwida ajulu. ");
INSERT INTO dov_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mpawo bakati kuli umwi awumwi, “Tatuchideluli pe, pesi aatusonde kuchitila kuti chilyaambe kuti chilaaba chani. Eechi chakachitika kuchitila kuti malembe azuzikizigwe awamba kuti, “Bakaabana zikobela zyangu akati kaabo akusonda zisamo zyangu. Eezi nzibakachita basilumamba.” ");
INSERT INTO dov_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lino ibakayimvwi afwifwi achiingano cha Jesu, kwakali banyina Jesu, kwakali mukulana wabanyina, Meli muka Kkilopasi, a Meli Magadalina. Aaba bamakayintu bakalimvwi afwifwi achiingano cha Jesu. ");
INSERT INTO dov_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu nakabona banyina asikwiiya ooyo ngwakali kuyandisya kabimvwi afwifwi, wakati kuli banyina, “Yomwanakazi, “Langa, mwanako!” ");
INSERT INTO dov_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mpawo wakati kuli sikwiiya, “Langa banyoko.” Kuzwa kuchiindi echo sikwiya wakabatola banyina kungánda yakwe. ");
INSERT INTO dov_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nikwakayinda ezi Jesu, nkambo wakaziba kuti zyonse lino zyakali zyamana, akuchitila kuti malembe ayelede kuzuzikizigwa, Jesu wakati, “Ndaaba enyota” ");
INSERT INTO dov_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chibikilo chakazwide wayini upanyuka chakaliwo, mpawo bakabika akasamu kakaangidwe chisana chakazwide wayini upanyuka bamutambikizya amulomo wakwe. ");
INSERT INTO dov_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesu nakanywa wayini upanyuka wakati “Kwamana.” wakalanzya mutwe aansi akupedya muuya wakwe. ");
INSERT INTO dov_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mpawo baJuda, akambo kakuti lyakali izuba lyakulibambila, akuti mibili teyakali kuchaala aachingano kuchindi chasabata ( elyo Sabata yakali mpati loko), bakakumbila Pilato kuti atyole mawulu aabo akubagwisya. ");
INSERT INTO dov_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mpawo basilumamba bakasika akutyola mawulu amwalumi wakutanguna awabili wabo bakabambwidwe a Jesu. ");
INSERT INTO dov_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nibakasika kuli Jesu, bakabona kuti wakali wafwa kale, aboobo tebakamutyola pe mawulu akwe. ");
INSERT INTO dov_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nikuba obo, umwi wabasilumamba wakamuyasa limwi bbazu esumu, mpawo kwakazwa iganzi amaanzi. ");
INSERT INTO dov_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ooyo wakabona eechi wakaamba bukamboni, abukamboni bwakwe mbwakasimpe. Ulizi kuti nzyawamba ninchobeni kuchitila kuti anduwe usyome. ");
INSERT INTO dov_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nkambo eezi zintu zyakachitika kuchitila kuzuzikizya malembe, “Takwe nikuba limwi fuwa lyakwe litakatyolwe.” ");
INSERT INTO dov_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Alubo, aamwi malembe aamba kuti, “Bayolanga kulinguwe ooyo ngubakayasa.” ");
INSERT INTO dov_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nikwakamana ezi zintu, Josefa waku Alimatiya mbuli kuti wakali sikwiiya ( pesi mukusisikizya akuyoowa baJuda) wakakukumbila kuli Pilato kuti atoole mubili waJesu, Pilato wakamuzumizya. Aboobo Josefa wakaboola akuutola mubili waJesu. ");
INSERT INTO dov_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikkodimasi alakwe wakasika, nguwe wakazide kutangna kuli Jesu mansiku. Wakeeta tununkilizyo tuvwelene twamuula atwatyati, mweelwe wamuyanda umwi wampondo. ");
INSERT INTO dov_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mpawo bakatola mubili wa Jesu bawuvungilizya zisani zituba atununkilizyo mbuli muchaanza chaba maJuda kukuvwikka mubili. ");
INSERT INTO dov_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lino mubusena mwakabambwidwe kwakali chilili, omu muchilili mwakali kabanda kakatalina kulazikwa muntu naba umwi pe. ");
INSERT INTO dov_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nkambo kakuti lyakali izuba lyakuli bambilila lyabama Juda alimwi akambo kakuti kabanda kakali afwifwi, bakamulazika mumo Jesu. ");
INSERT INTO dov_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lino chifumo mubuzuba butaanzi bwamviki, nkakuchisiya, Meli Magadalina wakaza kuchuumbwe alimwi wakabona ibbwe kalikkunkulisigilwe kuzwa kuchuumbwe. ");
INSERT INTO dov_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Akaako wakachijaana alimwi wasika kuli Sayimoni Pita a kuli bamwi basikwiiya aabo Jesu mbakali kuyanda, alimwi wabaambila wati, “Bamubweza Mwaami kuzwa muchuumbwe, alimwi tatuzi nkubamulazika.” ");
INSERT INTO dov_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mpawo Pita abamwi basikwiiya bakazwa, alimwi bakaya kuchuumbwe. ");
INSERT INTO dov_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Aantomwe bakachijaana, alimwi umwi sikwiiya wakachijaanisya kwiinda Pita akusika kuchuumbwe lutaanzi. ");
INSERT INTO dov_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Lino wakalangisisya aansi, wakabona mulembo wazizwaato zyakwe kazilede aawo, pesi takanjila pe mukati. ");
INSERT INTO dov_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Sayimoni Pita lino wakasika kunembo lyakwe alimwi wanjila muchuumbwe. Wakabona chilembo chachizwato kachiyalidwe awo, ");
INSERT INTO dov_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","achilembo chakali aatala amuutwe wakwe. Techakayalidwe aamwi azilembo zimwi pesi chakalivungidwe mubusena bwacho achilike. ");
INSERT INTO dov_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Lino umwi sikwiiya, ooyo wakatanguna kusika kuchuumbwe, alakwe wakasika wanjila muchuumbwe, alimwi wakabona aalimwi wasyoma. ");
INSERT INTO dov_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nkaambo kusikila kuchiindi eecho tebakalinaaziba malembe aamba kuti uzobuka kuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Akaako basikwiiya bakabweeda kumunzi lubo. ");
INSERT INTO dov_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pesi Meli wakaliimvwi aanze aachuumbwe. Nkachilila, wakalangisisya aansi muchuumbwe. ");
INSERT INTO dov_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Wakabona bobilwe bangelo muzituba balikkede, umwi kumutwe, alimwi umwi kumawulu aawo mubili wa Jesu mpuwakalede. ");
INSERT INTO dov_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bakati kulinguwe, “Yo mwanakazi, ulilaanzi?” Wakati kulimbabo, Nkaambo babweza Mwaami wangu, alimwi tandizi pe kuti bamubika kuli.” ");
INSERT INTO dov_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nakaamba eechi, wakachebuka alimwi wabona Jesu kayimvwi aawo, pesi takaziba pe kuti ngu Jesu. ");
INSERT INTO dov_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesu wakamwaambila, “Yo mwanakazi ulilaanzi? Ngwani ngolanguula?” Wakayeya kuti ngu sichilili. akaako wakati kulinguwe, “Yo mwaalumi, na wamubweza, ndaambile nkuwamubika, alimwi ndiyomubweza.” ");
INSERT INTO dov_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesu wakati kulinguwe, “Meli.” Wakachebuka, alimwi wati kulinguwe muchi Alamayiki, “Labboni,” (chitolekelwa kuti: “Muyiisi.”) ");
INSERT INTO dov_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu wakati kulinguwe, “Utandijati, nsinayinka kujulu kuli Taata, pesi inka kubakkulana bangu alimwi ubaambile kuti ndiyobwiinka kujulu kuli Taata wangu a Taata wenu, alimwi Leza wangu a Leza wenu.” ");
INSERT INTO dov_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Meli Magadalina wakasika alimwi waambila basikwiiy, 'Ndamubona Mwaami,” alimwi azintu nzyaakamwaambila. ");
INSERT INTO dov_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nikwakaba goko, mubuzuba oobo, izuba taanzi lya mviki, alimwi amakkoma aakooko basikwiiya nkubakabede, akalijalidwe mukuyoywa ba Juda, Jesu wakasika alimwi wiima aakati kabo wasikwaamba kuti, ”'Luumuno kulindinywe.” ");
INSERT INTO dov_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nakamana kwaamba eezi, wakabatondezya maboko aakwe a bbazu lyakwe. Mpawo basikwiiya nibakabona Mwaami, bakabotelwa. ");
INSERT INTO dov_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesu lino wakabaambila alubo, Luumuno kulindinywe. Mbuli Taata mbwakandituma, lino ndili kumutuma.” ");
INSERT INTO dov_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Aawo Jesu naakaamba eezi, wayoyela aalimbabo alimwi wasikuti kulimbabo, “Mutambule Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kufumbwa chibi chani nchimuyolekelela, ngachalekelelwa; kufumbwa ngumubweedezezya chibi, ngazyabweedezegwa.” ");
INSERT INTO dov_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomasi, umwi wenkamu yabalikkumi ababili, utegwa Didimasi, takali aantomwe pe abamwi aawo Jesu naakasika. ");
INSERT INTO dov_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bamwi basikwiiya nikwakiinda chiindi bakati kulinguwe, “Twamubona Mwaami.” Wakabaambila kuti, “Ado ndabona mumaboko aakwe impa zya zipikili, alimwi ndibike munwe mukati ke mpa zya zipikili, akubika luboko lwangu mubbazu lyakwe, nsikoyoosyoma.” ");
INSERT INTO dov_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nikwakayinda mazuba ali musani aatatu basikwiiya bakwe bakali mukati alubo, alimwi Tomasi wakali aakati kabo. Jesu wakanjila aawo makkoma kaajalidwe, alimwi wiimikila akati kabo, wati, “Luumuno kulindinywe.” ");
INSERT INTO dov_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lino wakati kuli Tomasi, “Seyomeka munwe wako, alimwi ubone maboko aangu, sikila amunwe wako, alimwi ubike mumampango aangu, utabi uutasyomi, pesi syoma.” ");
INSERT INTO dov_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasi wakasandula alimwi wakati kulinguwe, “Mwaami wangu a Leza wangu.” ");
INSERT INTO dov_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesu wakati kulinguwe, “Nkaambo wandibona, wasyoma. Balilongezegelwe batanaabona, alimwi basyoma.” ");
INSERT INTO dov_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Lino Jesu wakachita zitondezyo zyiingi kunembo lya basikwiiya, zitondezyo zyakatalembwa pe mumagwalo, ");
INSERT INTO dov_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","pesi eezi zyakalembwa kuti tusyome kuti Jesu ngu Kkilisito, Mwana wa Leza, alimwi mukusyoma, ube aabuumi muzina lyakwe. ");
INSERT INTO dov_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nikwakayinda eezi zintu Jesu wakaliyubununa lwakwe mwini alubo kuli basikwiiya bakwe ku lwizi lwa ku Tibbaliyasi. Oobu mbombubo mbwakaliyubununa lwakwe mwini. ");
INSERT INTO dov_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sayimoni Pita wakali aantomwe a Tomasi uutegwa Didimasi, Nataniel uuzwa ku Kkana mu Galili, ibana ba Zebbedi, alimwi ababili basikwiiya ba Jesu. ");
INSERT INTO dov_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sayimoni Pita wakati kulimbabo, “Ndiyobuya ku kuloba.” Bakati kulinguwe, “Aswebo, tuyobwiinka anduwe.” Bakiinka alimwi banjila mubwaato, pesi takwe nchibakajata busiku boonse. ");
INSERT INTO dov_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lino, nkakuli kwa chifumofumo, Jesu wakaliimvwi kunkomwe yalwizi, pesi basikwiiya tebakaziba pe kuti wakali Jesu. ");
INSERT INTO dov_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Akaako Jesu wakati kulimbabo, “Yo balombwana, muli aachakulya na?” Bakamusandula, “Tatukwe.” ");
INSERT INTO dov_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wakati kulimbabo, “Kamuwaala bunsabwe bwenu kubbazu lyalulyo lwa bwaato, alimwi muyoojana zimwi.” Akaako bakawaala bunsabwe bwabo, pesi tebakakonzya pe kubukwelela mukati akaambo kakuvulisya kwe nswi. ");
INSERT INTO dov_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Alimwi sikwiiya Jesu ngwakali kuyandisya kapati wakati kuli Pita, “Ngu Mwaami. “Aawo Sayimoni Pita naakamvwa kuti Mwaami, wakadelula chisamo chakwe chaanze (nkaambo wakali maya), alimwi waliwaalila mulwizi. ");
INSERT INTO dov_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bamwi basikwiiya bakaza mubwaato (tebakali kule pe kuzwa anyika, mbuli myaanda yobile yatukkokola kuzwa aawo), alimwi bakayobukkwela bunsabwe buzwide nswi. ");
INSERT INTO dov_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Aawo nibakazwa aanze aatala anyika, bakabona makkala aamulilo nkakulazikidwe muswi aatala lyawo achinkwa. ");
INSERT INTO dov_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesu wakati kulimbabo, “Mweete zimwi nswi nzimwajata.” ");
INSERT INTO dov_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sayimoni Pita wakayinka aajulu akukkwela bunsabwe aanyika, kakuzwide baswi ba pati, mwaanda omwe amakkumi musamu aatatu mbuzyakabede, pesi nikuba kuti zyakali nyingi, bunsabwe tebwakadeluka pe. ");
INSERT INTO dov_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesu wakati kulimbabo, “Kamuza akulya chilyo chachifumo.” Takwe aakati kabasikwiiya wakayanda kumubuzya kuti, “Nduweni?” Bakali zizi kuti ngu Mwaami. ");
INSERT INTO dov_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesu wakaza wabweza chinkwa, alimwi wachipa kulimbabo, a nswi azilazyo. ");
INSERT INTO dov_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Oolu lwakali lwatatu Jesu kali kuliyubununa mwini kuli basikwiiya musule aakubuka kwakwe kuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nebakamana kulya chilyo chachifumo, Jesu wakati kuli Sayimoni Pita, “Sayimoni mwana wa Joni, ulandiyanda na kwiinda eezi?” Pita wakati kulinguwe, “Iyi Mwaami wangu, ulizi kuti ndilakuyanda.” Jesu wakati kulinguwe, “Sanina mbelele zyangu.” ");
INSERT INTO dov_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Wakati kulinguwe lwabili, “Sayimoni mwana wa Joni, ulandiyanda na?” Pita wakati kulinguwe, “Iyi Mwaami wangu, ulizi kuti ndilakuyanda.” Jesu wakati kulinguwe, “Bamba mbelele zyangu.” ");
INSERT INTO dov_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Wakati kulinguwe lwatatu, “Sayimoni mwana wa Joni, ulandiyanda na?” Pita wakali wanyema nkaambo Jesu wakali wamubuzya lwatatu, “Ulandiyanda na?” Wakati kulinguwe, “Mwaami, ulizizi zyoonse eezi zintu, ulizi kuti ndakuyanda.” Jesu wakati kulinguwe, “Sanina mbelele zyangu. ");
INSERT INTO dov_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nchobeni, nchobeni, ndakwaambila, niwakachili muniini, wakalikulizwaatika akweenda kufumbwa nkuwakali kuyanda, pesi niwakkomena, uyootandabika maboko aako, alimwi umwi uyookuzwatika a kukubweza kukutola nkotayandi kwiinka.” ");
INSERT INTO dov_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Lino Jesu wakachaamba eechi kuchitila musyobo walufu Pita ngwatakalemeke Leza. Nakamana kwaamba eechi, wakati kuli Pita, “Nditobele.” ");
INSERT INTO dov_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita wakachebuka alimwi wabona sikwiiya ooyo Jesu ngwakali kuyandisya nkayoobubatobela, ooyo wakali aafwifwi kubbazu lya Jesu kuchiindi cha chilalilo alimwi wakati, “Mwaami, utakakuuzye?” ");
INSERT INTO dov_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita wakamubona akwaambila Jesu, “Ulachita biyeni mwaalumi ooyu?” ");
INSERT INTO dov_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu wakati kulinguwe, “Na ndayanda kuti akkale kusikila ndaboola, niinzi eecho kulinduwe? Nditobele.” ");
INSERT INTO dov_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lino aaka kaambo kakasaalila kuli babunyina, kuti ooyo sikwiiya takoyoofwa. Pesi Jesu teensi wakateedi kuli Pita kuti ooyo sikwiiya takoyoofw, pesi, “Na ndayanda kuti ukkale kusikila ndaboola, niinzi eecho kulinduwe?” ");
INSERT INTO dov_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ooyu ngonguwe sikwiiya uupa bukamboni aatala azint, alimwi iwakalemba zintu eezi, alimwi tulizi kuti bukamboni bwakwe mbwanchoonzyo. ");
INSERT INTO dov_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Kuli zintu zyiingi alubo Jesu nzyakachita. Na chimwi achimwi chakalembwa aansi, ndibona kuti niiba nyika lwayo teyalikunokonzya pe kubamba magwalo anoli alembwa. ");
INSERT INTO dov_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyofilasi, lugwalo lutanzi ndundakalemba, ndakaamba zyoonse eezyo Jesu nzyakatalika kuchita akwiisya, ");
INSERT INTO dov_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","mane kubuzuba mbwakatolwa kujulu, nakamana kupa mulalilo kwiinda mu Muuya Uusalala kuba tumwa mbakasalide. ");
INSERT INTO dov_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nakamana kupenga, wakalitondezya lwakwe muzitondezyo zyiingi zizundikizya. Wakaliyubununa kuli mbabo kwamazuba aali makumi aane, mpawo wakambula aatala aabwami bwa-Leza. ");
INSERT INTO dov_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Chindi nakali kubungana aamwi ambabo, wakabalayilila kuti batazwi mu Jelusalema, pesi bakalindile chisyomezyo cha Taata, Eecho nchaakamba kuti, “mwakamvwa kulindime ");
INSERT INTO dov_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","kuti choonzyo, Joni waka bbabbatizya a meenda, pesi nywebo mumazuba mache biyo muyo bbabbatizigwa muMuuya Uusalala.” ");
INSERT INTO dov_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aawo nibaka bungene aamwi bakabuzya kuti, “Mwami, sena echi nchechindi nchoyobusilizya Bwami ku Izilayeli?” ");
INSERT INTO dov_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wakabambila kuti, “tachili kulindinywe kuziba zyiindi eezyo Taata nzyakabamba munguzu zyakwe. ");
INSERT INTO dov_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pesi muyotambula nguzu aawo Muuya Uusalala nuyosika aalindinywe, mpawo muyooba bakamboni bangu mu Jelusalemu amu Judiya moonse amu Samaliya, akumamanino anyika.” ");
INSERT INTO dov_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chiindi Mwami Jesu nakaamba eezi zintu, mpawawo kabachilangide kujulu, wakanyamoulwa mujulu, mpawo ijoba lyakamusisa kuzwa kumeso aabo. ");
INSERT INTO dov_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mbubonya kabachilangisisya kujulu mbuli mbwakeenda, mpawo mpawo, baalumi babili bakayimikila kulubazu lwabo kabasamide zisamo zituba. ");
INSERT INTO dov_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Bakaamba kuti, “Yo balumi baku Galili, nkambonzi nomwimvwi aano akulanga mujulu? Jesu ooyu watansiikwa kuzwa kulindinywe kuya kujulu, mbubonya uuyobola muchiimo nchichonya nchomwamubona kayinka aacho kujulu. ");
INSERT INTO dov_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mpawo bakajokela ku Jelusalema kabazwa kuchilundu chitegwa Oliveti, eecho chili aafwifwi aku Jelusalemu, lweendo lwabuzuba bwa Sabata. ");
INSERT INTO dov_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mpawo nibakasika, bakatanta mung'anda yamujulu, oomo mubakali kukkala. Bakali Pita, Joni, Jemusi, Andulo, Filipu, Tomasi, Bbatolomyu, Mateyo, Jemusi mwana wa Alufiyasi, Sayimoni mu Ziloti, a Judasi mwana wa Jemusi. ");
INSERT INTO dov_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Boonse bakali peda kumulimo wakukomba antomwe abanakazi, a Meli banyina ba Jesu Kkilisito abanabakwabo. ");
INSERT INTO dov_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mumazubayo Pita wakiimikila akati kababakwabo, bakati kabe mwaanda amakkumi aabili, akwamba kuti, ");
INSERT INTO dov_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nobakwesu, chakalelede kuti magwalo azuzikizigwe kuti Muuya Uusalala wakamba lutanzi kumulomo wa Devidi azya Judasi, ooyo wakazulwida aabo bakaanga Jesu. ");
INSERT INTO dov_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nkaambo wakaluumwi wesu mpawo wakatambula chaabilo chamulimo ooyu.” ");
INSERT INTO dov_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Lino mwaalumi ooyu wakawula muunda a mpindu nzyakatambula mububi bwakwe, eelyo nkukonya wakawa watola mutwe lutaanzi amubili wakwe wakabbaluka alimwi mala aakwe akafwasukila kunze. ");
INSERT INTO dov_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Boonse bakkali bamu Jelusalemu bakamvwa ataala achechi, mpawo bakawulika muunda ooyo mumwaambo wabo “Akeludama, “nkukwamba kuti, “Muunda wa Bulowa.” ");
INSERT INTO dov_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Nkaambo kuli lembedwe mulugwalo lwa Ntembawuzyo, 'Muunda wakwe awuchitwe chisesemyo, alimwi kutabi naba omwe muntu ukkala nkuko; 'Akube umwi uumbi ubweza chuuno chakwe chabuzulwidi. ");
INSERT INTO dov_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nkinkako, kulelede, kuti umwi wabantu bakeenda aswe chiindi choonse Mwami Jesu nakanjila akuzwa aakati kesu, ");
INSERT INTO dov_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kutalikila kuzwa kulubbabbatizyo lwa Joni kulosika kubuzuba mbwakabwezegwa kuzwa kulindiswe, abe kamboni andiswe kububuke bwakwe.” ");
INSERT INTO dov_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mpawo bakabika baalumi babili kunembo, Jozefu uutegwa Bbasabbasi, ooyo wakawulikwa lubo izina lyakuti Jasitasi, a Matiyasi. ");
INSERT INTO dov_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Eelyo bakakomba akwamba kuti, “Mwami, webo, ulizi myoyo yabantu boonse, nkinkaako yubununa kuti nguuli wababili aaba; ooyo ngosalide ");
INSERT INTO dov_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","abweze busena mumulimo oyu abutumwa oobo mbwakasiya Judasi akuya kubusena bwakwe.” ");
INSERT INTO dov_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mpawo bakawuma chisolo, alimwi chisolo chakawida kuli Matiyasi, mpawo wakabalwa aamwi abatumwa bali kkumi awumwi. ");
INSERT INTO dov_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nibwakasika buzuba bwa Pentekosita, boonse bakali aantomwe aabusena bomwe. ");
INSERT INTO dov_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mpawaawo kwakasikka muzuzumo wakazwa kujulu ulimbuli kuunga waguwo pati, wakazuzya ng'anda yoonse mubakabede. ");
INSERT INTO dov_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mpawaawo kwakalibonia ndimi zilimbuli zyamulilo zyakabakkala, alimwi zyakabakkala umwi awumwi. ");
INSERT INTO dov_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Boonseni bakazula aMuuya Uusalala mpawo bakatalika kwaambuula mumilaka, mbuli mbubakazumininwa aMuuya. ");
INSERT INTO dov_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lino kwakali baJuda bakali kukkala mu Jelusalemu, bakalo aabuna leza, balikuzwa kumanyika woonse alimunsejulu. ");
INSERT INTO dov_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ooyu muzuzumo niwakamvwigwa, makamu makamu aabantu akaboola aamwi alubo bakagamba nkaambo bakabamvwa kabaambuula mumilaka yabo. ");
INSERT INTO dov_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bakayoowa akugamba; bakati sena aaba boonse balikwaambula tabali bamu Galilii na? ");
INSERT INTO dov_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nkamboonzi nitulikubamvwa, umwi awumwi mumilaka yabuzyalwe bwesu? ");
INSERT INTO dov_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Baku Patiya abaku Medesi abaku Elamiya, abaabo bakkala ku Mesopotamiya, mu Judiya abaku Kkapadokkiya, ku Pontasi aku Ezhia, ");
INSERT INTO dov_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ku Pirigiya aku Pamfiliya, ku Ejipiti aamwi mabazu a Libbiya aku Sayilini, abeenzu bakalikuzwa ku Roma, ");
INSERT INTO dov_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","baJuda abakasanduka baku Kkilete abana Arabiya, twabamvwa balaambuula mumilaka yesu aatala amilimu iigambya yaLeza.” ");
INSERT INTO dov_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Boonse bakakankama akuyoowa kupati, bakambuula umwi kuluumwi, “Eechi chaambaanzi?” ");
INSERT INTO dov_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pesi bamwi bakabaniaka bati, “Bakkuuta wayini mupya.” ");
INSERT INTO dov_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pesi Pita wakayimikila abalikumi awumwi, wakatola muju jwi lyakwe, wakabaambila kuti, “Nobaalumi bamu Judiya, antoomwe amoonse nimukkala mu Jelusalema, eechi achizibinkane kulindinywe; amuteelele loko kumajwi aangu. ");
INSERT INTO dov_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nkaambo aaba bantu tabakoledwe pe mboli mbumulikubayeyela, nkaambo lichili biyo wola lyatatu lyabuzuba. ");
INSERT INTO dov_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pesi eechi nchenchicho chakaambidwe kuzwa kumusinsimi Jowelu: ");
INSERT INTO dov_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Kuyooba kumazuba akumamanino,' Leza uwamba oobo, 'Ndiyotila muuya wangu aatala anyama yoonse, bana benu balombe abasimbi bayoosinsima, bakubusi bayoobona zilengaano, abamanene benu bayoolota ziloto. ");
INSERT INTO dov_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chanchoonzyo balanda bangu bachaalumi abalanda bachanakazi mumazuba aayo nindiyotila Muuya wangu, bayoosinsima. ");
INSERT INTO dov_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ndiyotondezya zigambyo kujulu azitondezyo aanyika, bulowa, mulilo, akawuntumusi kabusi. ");
INSERT INTO dov_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Zuba liyoosiya amweezi uyooba bulowa, kabutana kusika buzuba bupati bwakuboola kwa Mwami. ");
INSERT INTO dov_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kuyoba kuti boonse bayita muzina lya Mwami bayofutulwa. ");
INSERT INTO dov_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nobaalumi baku Izilayeli, amumvwe majwi aaya: Jesu muNazalata, wakali mwaalumi ngumwakasalilwa a Leza amanguzu mapati antoomwe azigambyo azitondezyo nzyakachita Leza kwiinda mulinguwe akaki kenu, mbubonya mbuli mbomuzi. ");
INSERT INTO dov_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ooyu mwaalumi mwakamupegwa kwiinda mumakanze amuluzibo; andinywe, kwiinda mumaanza aabatalemeki mulawu, mwakamubambula akumujeya; ");
INSERT INTO dov_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","pesi Leza wakamubusya, wakamwaangununa kumachise aalufu, nkaambo teensi chakalikukonzeka kuti akkalilile mulindulo. ");
INSERT INTO dov_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nkaambo Devidi waamba boobu aatala anguwe, 'Ndakabona Mwami lyoonse kubusyu bwangu, nkaambo uliko kulubazu lwakululyo kuti nsikasunzulusigwi. ");
INSERT INTO dov_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nkenkaako moyo wangu wakabotelwa alulimi lwangu lwakakondwa. Alubo, nyama yangu iyookkala mubusichaamba. ");
INSERT INTO dov_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nkaambo tokoyoolekela muuya wangu mu Hadesi, nikuba kuyozumina Musalali wako kuti akabone bubozi. ");
INSERT INTO dov_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wakachita kuti zizibwe kulindime nzila zyabuumi; uyondipa kuti ndikazule lukondo kubusyu bwako.' ");
INSERT INTO dov_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nobayandwa, eechi chililuleme kulindime kuti ngambuule aatala asikale Devidi, wakafwa akuvwikwa, kabanda kakwe mpukachili ambulisunu akati kesu. ");
INSERT INTO dov_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nekubaboobo, wakalimusinsimi alubo wakalizi kuti Leza wakali wasyomezya muchikonke kulinguwe kuti, uyoonanika umwi wamumazyalane aakwe uutakakkale aachuuno chakwe. ");
INSERT INTO dov_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wakabona zyakali kuyanda kuchitika muchiindi chiboola kwaamba aatala abubuke bwa Kkilisito, 'Taakwe pe anakalekelwa mu Hadesi, nuuba amubili wakwe taakwe niwakabola pe.' ");
INSERT INTO dov_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ooyu Jesu, Leza ngwaakabusya, uuli ngonguwe toonse ngotuli kaamboni. ");
INSERT INTO dov_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nkenkaako kwiinda mukusumpulwa akubikwa kujanza lyalulyo lwa Leza alubo amukutambula Muuya Uusalala wachisyomezyo kuzwa kuli Wisi, wakatila eechi, eecho nchimubona akumvwa. ");
INSERT INTO dov_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nkaambo Devidi taakwe pe naakatanta kuya kujulu, pesi uwamba kuti, 'Mwami wakati kuMwami wangu,'”Kokkala kujanza lyakuulyo lwangu ");
INSERT INTO dov_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mane ndikachite basinkondonyokwe chilyatilizyo chandyatyo zyamawulu aako.”' ");
INSERT INTO dov_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Aboobo, akube kuti yoonse ng'anda ya Izilayeli izibe kuti Leza nguwakamuchita kuba Mwami a Kkilisito, ooyu Jesu ngumwakabambula.” ");
INSERT INTO dov_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lino nibakamvwa eezi zyoonse, bakayaswa mumyoyo yabo, bakaambila Pita antoomwe abatumwa boonse bati, “Nobakwesu, tuchite biyeni?” ");
INSERT INTO dov_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Mpawo Pita wakabaambila kuti, “Amusanduke, alubo mubbabbatizigwe, umwi awumwi wenu muzina lya Jesu Kkilisito kuti mulekelelwe zibi zyenu, mpawo muyootambula chipo cha Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nkaambo chisyomezyo nchichanu abana banu aboonse bazwa kule, abuvule bwabantu boonse mbatanoli wiita Mwami Leza.” ");
INSERT INTO dov_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Aambi majwi miingi wakabapa bukamboni akubalayilila, akwaamba kuti, “Amulifutule kuzwa kuli eeli zyalane lyabubi.” ");
INSERT INTO dov_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mpawo bakatambula ijwi lyakwe, bakabbabbatizigwa, bakayungizigwa oobo buunsi bakasanduka kabayeyelwa kusika kuzyuulu zitatu. ");
INSERT INTO dov_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bakalipeda kunjiisyo zyabatumwa, akubulyidilano, mukukwamuna chinkwa amukukomba. ");
INSERT INTO dov_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kuyoowa kwakabawo kumuntu amuntu, antoomwe azigambyo azitondeezyo zyiingi zyakachitwa kwiinda mubatumwa. ");
INSERT INTO dov_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Boonse bakazumina bakali antoomwe kabali aazintu zyoose mukuba aamwi, ");
INSERT INTO dov_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","mpawo bakawuzya nzibakali aazyo ambono zyabo, akuzyaabana boonse akati kabo, umwi awumwi mbuli kubula kwabo. ");
INSERT INTO dov_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mubuzuba abuzuba bakalikulipeda lwabo amaboneno omwe muchikombelo, alimwi bakali kukwamuna chinkwa mumaanda aabo, kabaabana chakulya antoomwe chakukondwa amyoyo iwangunukide; ");
INSERT INTO dov_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","bakatembawula Leza akuba aaluzyalo kubantu boonse, alubo mazuba woonse Mwami wakayujngizya mweelwe wabaabo bakalikufutulwa. ");
INSERT INTO dov_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lino Pita a Jon bakalikuya muchikombelo muchiindi chakukomba, muwola lyamusanu atune. ");
INSERT INTO dov_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lino umwi mwaalumi wakalemene kuzwa mwida lyabanyina wakali kunoongwa wabwezwa wakutulwa aamulyango wachikombelo ooyo wakalikutegwa Mubotu. Bakalikumutula mpawaawo abuzuba kuchitila kuti kalikukumbila zipo kubantu banjila muchikolmbelo chazipo. ");
INSERT INTO dov_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Naakabona Pita a Joni kabalikwaamba kunjila muchikombelo, wakabakumbila zipo. ");
INSERT INTO dov_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita wakamulangisisya, kali a Joni, wakati “Tulange.” ");
INSERT INTO dov_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mwaalumi uulemene wakabalanga kalangila kutambula chimwi chintu kuzwa kulimbabo. ");
INSERT INTO dov_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pesi Pita wakati, “Nsiliva angolide nsikwe pe, pesi nchelaacho ndilakupa. Muzina lya Jesu Kkilisito waku Nazaleta, enda.” ");
INSERT INTO dov_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kamujisi akuboko kwakuchilisyo, Pita wakamunyampula, mpawo ingo amawulu aakwe akasima. ");
INSERT INTO dov_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wakasunkutila mujulu, mwaalumi mulema wakanyampuka wasanguna kweenda, mpawo wakanjila a Pita a Joni muchikombelo kayabweenda, kayabusunkuta akulumbayizya Leza. ");
INSERT INTO dov_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bantu boonse bakamubona kayabweenda akulumbayizya Leza. ");
INSERT INTO dov_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Bakabona kuti nguwe uulya mwaalumi wakali kukumbila zipo kubantu aaMulyango Mubotu wachikombelo; mpawo bakagamba chakwiindilila nkaambo kachakachitika kulinguwe. ");
INSERT INTO dov_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nakachijisilidi kuli Pita a Joni, bantu boonse bakachijanina kulimbabo kubbazu litegwa ndilya Solomoni, kambagambide loko. ");
INSERT INTO dov_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita nakazibona eezi wakabasandula bantu wati, “Inywe nombaalummi ba Izilayili nkamboonzi nimugamba? Nkamboonzi nimutulangisisya, aanga ndiswe twamuponia amangu eesu nakuti abu Leza bwesu? ");
INSERT INTO dov_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Leza wa Abbulahamu, awa Ayizeki, awa Jakobo, Leza wama taata eesu, wapa bulemu kumulanda wakwe Jesu. Nguwe ngumwakapeda mwamukaka kubusyu bwa Payileti, aawo we naakasalide kumwaangununa. ");
INSERT INTO dov_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mwakakaka Musalali a Mululami. Pesi mwakalikumbilila mujayi kuti awangununwe. ");
INSERT INTO dov_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mwakajaya Sikwaanza buumi, ooyo Leza ngwakabusya kubafu, tulibakamboni bazyo eezi. ");
INSERT INTO dov_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nkaambo kalusyomo muzina lyakwe, zina lyakwe lyapa kuti ooyu mwaalumi, ngumubwene akuziba, kuti asime. Lusyomo kwiinda muli Jesu lwamupa bulondozi bubotu kunembo lyanu. ");
INSERT INTO dov_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Lino nobakwesu ndilikwaamba kuti mwakachita mukutaziba, mbuli mbubakachita batongi benu. ");
INSERT INTO dov_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pesi zintu nzyakaamba Leza kwiinda mumilomo yaba sinsimi boonse, kuti Kkilisito wakwe uzopenzegwa, lino wazizuzikizya. ");
INSERT INTO dov_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Amusanduke, aboobo, muboole, nkokuti zibi zyenu zisalazigwe. Kuchitila kuti kwaba zyiindi zyakulyookezya ku Mwami; ");
INSERT INTO dov_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","mpawo ulamutumina Kkilisito ngumwakasalilwa Jesu. ");
INSERT INTO dov_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ngonguwe weelede kutambulwa ajulu mane zintu zyoonse zikabweedezegwe muchiimo chazyo, aatala aazintu Leza nzyakaambuula kwiinda mumilomo yaba sinsimi basalala. ");
INSERT INTO dov_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mozesi kampatila wakati, Mwami Leza uzoobusya musinsimi uulimbuli ndime kuzwa aakati kabakwenu. Muyooswiilila zyoonse nzyatakaambe kulindinywe. ");
INSERT INTO dov_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Chiyooba mbubo kuti muntu woonse uutakaleke kumuswiilila ooyo musinsimi uyoonyonyoonwa akati kabantu. ");
INSERT INTO dov_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Iyii, aboonse basinsimi kuzwa kuli Samuyele abaabo bakazoza musule lyakwe, bakaambula akuzibisya aatala amazuba aaya. ");
INSERT INTO dov_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mulibana babasinsimi abachizuminano nchakachita Leza abasikale benu, mbuli mbakaamba kuli Abbulahamu kuti, 'Mumbuto yako, azikkalongezegwe mpuli zyoonse zyaanyika.' ");
INSERT INTO dov_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Leza wakabusya mulanda wakwe wamutumina kulindinywe sansina, kuti amulongezye moonse akusandula umwi awumwi wenu kuzwa kuzibi zyakwe.” ");
INSERT INTO dov_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita a Joni nkabali kwambula kubantu, bapaizyi amuzulwidi wa tempele, aba Sadusi bakabasikila. ");
INSERT INTO dov_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Baka pengana kapati nkaambo Pita a Joni bakali kuyiisya bantu akubakambaukila Jesu akubuka kwakwe kubafu. ");
INSERT INTO dov_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bakabajata bababika muntolongo maane buzuba butobela, nkambo lyakali lyaba goko. ");
INSERT INTO dov_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pesi bantu biingi bakamvwa aya makani bakasyoma, imweelo wabalumi bakasyoma bakali zyuulu musanu ");
INSERT INTO dov_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nibwakaba buzuba butobela, bendelezi, bapati abalembi bakabungana aamwi mu Jelusalema. ");
INSERT INTO dov_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi mupayizyi mupati wakaliwo, Kefasi, Joni aa Alekizanda, abaabo boonse nzubo zyamupaizyi mupati. ");
INSERT INTO dov_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nibakabika bika Pita aa Johani akaati kabo, bakababuzya,” nzizyani nguzu, niliba zina ndimwachita aalyo eezi. ");
INSERT INTO dov_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pesi Pita, nkazwide Muuya Uusalala, wakati kulimbabo, ");
INSERT INTO dov_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Inywe nobendelezyi abapati, babantu, kuti mwatubeteka sunu atala amulimo mubotu ngutwakachita aliyoyu mwalumi uchiswa, akuti wapona buyeni.” ");
INSERT INTO dov_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ngakuzibinkane kulindinywe moonse akubantu bamu Izilayeli kuti oyu mwalumi uyimvwi kunembo lyanu nkaponede muzina lya Jesu Kilisito wa Nazaleta, Ooyo ngumwakabambula, ooyo Leza ngwakabusya kubafu. ");
INSERT INTO dov_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesu Kkilisito ndibbwe bayaki ndibaka kaaka lyakaba chooko ( chiswi) ");
INSERT INTO dov_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Takwe lufutuko mumuntu naba omwe, nkambo taakwe zina aansi ajulu lipedwe kubantu nditwelede kufutulwa.” ");
INSERT INTO dov_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Lino nibakalanga busichamba bwa Pita aa Joni, mpawo bakaziba kuti mbantu babuyo, batayiide, bakagamba, nkabazi kuti Pita aa Johani bakali a Jesu. ");
INSERT INTO dov_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nkaambo bakabona mwalumi wakaponesegwa nkayimvwi aambabo, bakabula zyakwamba ataala nzizyo. ");
INSERT INTO dov_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pesi nibakabalayilila batumwa kuti babbude munkuta yabechipala, bakiizya akati kabo. ");
INSERT INTO dov_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bakati, “tuchite buyeni ataala abalumi aaba? Nkambo kamasimpe alabukamboni bwachitwa ambabo bwazibinkana kubantu boonse bamu Jelusalema” tatukonzyi kuzikazya. ");
INSERT INTO dov_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pesi kuti zileke kuyakunembo akati kabantu, ngatubachenjezye ikuti batambili naba omwe muzina eeli.” ");
INSERT INTO dov_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lino bakabita Pita a Joni babalayilila kuti batambuli nekuba kuyiisya alimwi muzina lya Jesu. ");
INSERT INTO dov_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pesi Pita aa Joni bakavwiila bati kulimbabo, “Saa nchibotu kumeso a Leza kuswiilila ndinywe kwiinda nguwe, amuli beteke. ");
INSERT INTO dov_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tatukonzyi kuti tuleke kwambula atala azeezi zintu nzitwakamvwa akubona.” ");
INSERT INTO dov_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nibakaba sinizya Pita a Joni, bakabaleka beenda. Tebakajana mulandu uyanda chisubulo, nkaambo bantu boonse bakali kutembaula Leza azeezyo zyakachitwa. ");
INSERT INTO dov_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Oyo mwalumi wakajana oku kupona wakali aminyaka iyiinda kumakumi oone akuzyalwa. ");
INSERT INTO dov_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nibakangununwa, Pita aa Joni bakaza kulibamukowa wabo mpawo bakubambila zyoonse mupati wabapayiizyi abapati nzibakabambila. ");
INSERT INTO dov_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Lino nibakamvwa eezi, bakoompolola ajwi limwi kuli Leza mpawo bati, “Mwami, wakalenga majulu aanyika alwizi, azyoonse zilimuli nzizyo. ");
INSERT INTO dov_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","webo owakambula a Muuya Uusalala kwindila mumulomo wabalanda bakwe, taata wesu Davida, 'Nkambonzi, inyika zyabamasi nizyanyema, abantu bayeeya zintu zitanambene.” ");
INSERT INTO dov_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ibaami banyika bakakkala aansi aamwi, Ibendeelezi bakabungana aamwi kukulwania Mwami, alimwi a Kilisito wakwe.' ");
INSERT INTO dov_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ninchonzyo, aba babili Helodi aa Pontiyasi Payileti, antomwe abamaasi bakabungana aamwi muchisi cha Izilayeli, kukwimikilana amulanda Uusalala Jesu, munanike wako. ");
INSERT INTO dov_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bakabunganamwi kuti bachite zyoonse eezyo luboko amabambe aako nguwakakanzide kale kale achiindi chibola atachitike. ");
INSERT INTO dov_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Lino, Mwami, laanga inchenjezyo yabo alimwi ubape busichaamba balanda bako kuti bambule ijwi lyako. ");
INSERT INTO dov_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tandabika luboko lwako kuti uponie akubapa zitondezyo azigambyo kwindilila muzina lyamulanda wako Uusalala Jesu.” ");
INSERT INTO dov_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nibakamana kukomba, busena boonse bwakazula a Muuya Uusalala mpawo bakamba jwi lya Leza abusichaamba. ");
INSERT INTO dov_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mweelwe mupati wabaabo bakasyooma bakaba amoyo amuya woomwe. Takwe naba oomwe wakamba kuti nchakalacho nchichakwe, pesi bakalijisi zyelelne mubube bwabo. ");
INSERT INTO dov_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Munguzu mpati batumwa bakakambauka bukamboni atala abubuke bwa Mwami Jesu, aboobo luzyalo lupati lwakaba mulimbabo boonse. ");
INSERT INTO dov_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Akati kabo katakwe wakabula kufumbwa chiintu, nkambo boonse bakajisi nyiika amaanda bakaasambala mpawo beeta mali yanzezyo nzibakawuzya. ");
INSERT INTO dov_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Mpawo bakatula kumawulu abatumwa, mpawo yakabwa kulumwi awumwi mbuli mukubula kwakwe. ");
INSERT INTO dov_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jozefu, mu Levi, ooyo batumwa ngubakalikuti Bbanabbasi ( zina lilabupanduluzi ibuti mwana wabusungwazyi) mu-Levi, mwalumi waku Sayipulasi, ");
INSERT INTO dov_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","wakasambala muunda wakwe mpawo waketa mali witula kumawulu abatumwa. ");
INSERT INTO dov_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lino umwi mwalumi uutegwa Ananiyasi, nkali a Safila mwanakazi wakwe, bakawuzya chimpanzi chabuvubi, ");
INSERT INTO dov_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","alimwi wakabamba musule chimpanzi chamuulo wamali ( mwanakazi wakwe kabiyo wakalizizi ezi), alimwi wakeeta chimpanzi chazyo alimwi wakachibika kumawulu amu abatumwa. ");
INSERT INTO dov_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pesi Pita wakati, “Ananiyasi, nkambonzi satani naazuzya moyo wako kuti ubeje ku Muuya Uusalala alimwi kuti ubambe musule chimpanzi chamuulo wamuunda? ");
INSERT INTO dov_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Niwalikusyaala nkawutawuziziwwe, tensi wakayimvwi kawuli wako, alimwi akuzwa nkawuli wawuzigwa, saa wakali munsi lyanuzu zyako? Nwani oyo wabika eyi milimo mumoyo wako? Teensi wabejela muntu pesi kuli Leza.” ");
INSERT INTO dov_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Naakamvwa majwi aya, Ananiyasi wakawida aansi mpawo wayoya kwakumaninsizya, alimwi kuyoowa kupati kwakasika kuli boonse bakamvwa eezi. ");
INSERT INTO dov_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Balombe bakanyampuka alimwi bamuvunilizya, alimwi bakamubweza alimwi bakumuvwikka. ");
INSERT INTO dov_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nikwakiinda biyo otatwe mahoola, mwanakazi wakwe wakanjila, katezi kuti niinzi zyachitika. ");
INSERT INTO dov_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita wakati kulinuwe, “Ndibuzye naanka mwawuzya muunda azeezi, “wakati, “Iyii, azeezi.” ");
INSERT INTO dov_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mpawo Pita wakati kulinuwe, “Mbuubuli mbumwazuminana moonse kuti musunke muuya wa Leza? Bona mawulu abaalumi bavwikka mulumi wako ali amulyango, alimwi bayokubweza ayebo.” ");
INSERT INTO dov_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mpawo mpawo wakawida ansi kumawulu aakwe alimwi wakayoya kwakumaninsizya. Elyo baluumi nibakanjila, bakamujana nkafwide, alimwi bakamubweza alimwi bakumuvwikka kumbali lyamulumi. ");
INSERT INTO dov_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kuyoowa kupati kwakasika akkati kayoonse imbungano alimwi aakati kaboonse aabo bakamvwa eezi. ");
INSERT INTO dov_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Zyingi zitondezyo alimwi azigambyo zyakalikuchitika akati kabantu kwiinda mumaanza abatumwa. Bakali antoomwe kumulyango wa Solomoni. ");
INSERT INTO dov_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pesi takwe wabo wakaba aachiyandisyo chakuba antomwe ambabo; nikuba boobo bantu bakabalemeka. ");
INSERT INTO dov_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kabiyo biingi basyomi bakali kuyungizizigwa ku Mwami, bantu biingi bechalumi mpawo abanakazi, ");
INSERT INTO dov_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","nkokuti bakali kubweza bachiswa muchisi alimwi babalazika aabulo amuzitobo, kuchitila kuti awo Pita nayosika, muzuzumbwe wakwe wayino wida alibamwi babo. ");
INSERT INTO dov_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mpawo bakasika kabiyo antomwe bantu biingi bazwa muchisi chilafwifwi a Jelusalema, nkabeeta bachiswa alimwi abaabo bajiswi aa myuya yamatombe, alimwi balikuponesegwa boonse. ");
INSERT INTO dov_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pesi mupayizi mupati wakanyampuka, mpawo aboonse abo bakali anguwe ( aabo benkamu yama Sajusizi); alimwi bakazwa munyono ");
INSERT INTO dov_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","alimwi bakabika maanza aatala lyaba tumwa, mpawo babawala muntolongo yakazibinkene. ");
INSERT INTO dov_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Elyo muchindi chamansiku mungelo wa Leza wakajula mulyano wentolongo alimwi wakabagwisya aanze, mpawo wakati, ");
INSERT INTO dov_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mwiinke, mwime muntempele mpawo mwambule kubantu majwi woonse abuumi.” ");
INSERT INTO dov_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nibakamvwa eezi, bakanjila muntempele nkakuli kwamba kucha mpawo bayiisya. Pesi mupayizi mupati wakasika mpawo ababo bakali anguwe, alimwi bakayita mulubeta antomwe, boonse bapati babantu bamu Izilayeli, mpawo babatuma kuntolongo kuti bakeete batumwa. ");
INSERT INTO dov_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pesi bakapokola abo bakayinka tebakabajana pe muntolongo, mpawo bakaboola kukuzowamba, ");
INSERT INTO dov_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Twajana intolongo mbuli mbukwelede kazijalidwe kabiyo balindizi kabiimvwi amulyango, pesi nitwajula, twajana takwe pe ulimukati.” ");
INSERT INTO dov_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lino basilumamba bentempele antomwe abapayizi bapati nibakamvwa aya majwi, baka bulikilwa atala ambabo kuti mbobuli mbubanga balazwa kulinzizyo. ");
INSERT INTO dov_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Elyo umwi wakasika mpawo wabaambila, “Balumi aabo mbimwakabika mukkati kentolono balimvwi mukkati kantempele mpawo balikuyiisya bantu.” ");
INSERT INTO dov_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Eelyo silumamba wakiinka aamwi abakapokola, mpawo wababoozya musule, pesi kakutakwe kulwana, eelyo nkabayowede kuti balabatulula mabwe. ");
INSERT INTO dov_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nibaka beeta, baka bakkazika munsi ababetesi. Mupayizi mupati wakaba buzisisya, nkati, ");
INSERT INTO dov_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Twalayilila ndinywe a mulawu kuti mutayiisyi muzina eeli, mpawo lino mwazuzya Jelusalema enjiisyo achiyandisyo chenu alimwi mwayeya akweeta bulowa bwamwalumi oyu atala lyesu.” ");
INSERT INTO dov_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Alimwi Pita abatumwa bakasandula, “Twelede kulemeka Leza kwinda muntu. ");
INSERT INTO dov_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Leza wabamataata wakabusya Jesu, oyo numwakajaya akumwanzika mumusamu. ");
INSERT INTO dov_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Leza wakamunyampula kubbazu lyakuchilisyo kuti abe mwana wa Mwami mpawo amufutuli, kuti ape kusanduka ku Izilayeli, mpawo akulekelelwa kwazibi. ");
INSERT INTO dov_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ndiswe bakamboni bazeezi zintu, mpawo ngu Muuya Uusalala, oyo Leza ngwakapa kulibaabo bamulemeka.” ");
INSERT INTO dov_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Eelyo bazuluzi bamwi nibakamvwa eezi, bakanyema alimwi bakayanda kujaya batumwa. ");
INSERT INTO dov_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pesi mufalisi uutegwa Gamaliyeli, muyiisyi wamulawu oyo wakalikulemekwa aboonse bantu, wakanyampuka mubazuluzi mpawo wakalayilila batumwa kuti bagwisigwe kwakiindi kanini. ");
INSERT INTO dov_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mpawo wakati kulimbabo, “Nobaluumi bamu Izilayeli, amuswilizye loko kuli nzimwa zuminana kuti muchite kubantu aba. ");
INSERT INTO dov_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nkambo musule amazuba aya, Tewudasi wakanyampuka nkali kuyanda kuba uumwi, mpawo bantu biini, basika myaanda iine, bakaba antomwe anuwe. Wakajayigwa, eelyo boonse abo bakali kumulemeka baka mwayisiwampawo kwakamana. ");
INSERT INTO dov_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nikwakazwa ooyu mwalumi, Judasi waku Galili wakanyampuka mumazuba akubalwa kwabantu mpawo wakachunzya kule abantu kuzwa kulinuwe. Alakwe wakajayigwa, mpawo boonse abo bakali kumulemeka bakamwayika. ");
INSERT INTO dov_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lino ndamba kulindinywe, ikuti muye kule kuzwa kubantu aba mpawo ubayiisye abalikke, kjuti aya mabambe naa mulimo kuti nkazili zyamuntu, ziyosowegwa. ");
INSERT INTO dov_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pesi kuti nkazili zya Leza, tamukoyo kkonzya pe kuzimwaya; muyojana kuti munoyolwana a Leza.” Eelyo bakazumina. ");
INSERT INTO dov_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Eelyo bakayita batumwa mukkati alimwi babawuma mpawo babalayilila kuti taba nochambuli muzina lya Jesu, mpawo bakabaleka beenda. ");
INSERT INTO dov_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bakaya kule kuzwa musule abazuluzi nkaba boteledwe kuti bakali baswanana kabiyo akupenzegwa akuwisya bulemu bwezina. ");
INSERT INTO dov_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kuzwa wawo woonse mazuba, mukkati kentempele alimwi kuzwa kung'anda akung'anda, bakali kwinkilila anembo akuyobuyiisya alimwi akuyobumwaya milumbe mibotu kuti Jesu ngu Kkilisitu. ");
INSERT INTO dov_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lino kumazubayo nobakali kuyabuvula basikwiiya ba Giliki bakatalisya kutongawukila ba Hebbulayo, nkambo bamukabafu bakuli mbabo bakatongawuka amakani azyakulya nzibakali kupewa buzuba abuzuba zyakuliwasya. ");
INSERT INTO dov_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Balikkumi ababili bakayita basikwiiya boonse mubwiingi bwabo babambila kuti, “Tachili chibotu kuti iswebo tuleke ijwi lya Leza nkambo kamakani azyakulya. ");
INSERT INTO dov_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Aboobo bakwesu mulelede kusala balumi bali musanu ababili akati kanu. Balumi bali ampuwo mbotu, bazwide Muuya usalala antomwe awabusono, abo mbitutabike mumulimu oyu. ");
INSERT INTO dov_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kwalo iswebo, tulinkilila kunembo lyonse akukomba akukambawuka ijwi lya Leza.” ");
INSERT INTO dov_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Eno ijwi lyabo lyakabotezya nkamu yabantu boonse. Aboobo bakasala Sitivini mwalumi uzwide lusyomo alimwi a Muuya Uusalala, a Filipi, a Pulokkolasi, Nikkanoli, Tayimoni, Pamenasi, antomwe a Nikkolasi, mukombi wachi Juda wakali kuzwa ku Antiyokki. ");
INSERT INTO dov_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Basyomi bakabayimika balumi aba kumawulu abatumwa, mpawonya bakabakombela alimwi bakabikka manza alimbabo. ");
INSERT INTO dov_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Elyo ijwi lya Leza lyakayinkilila kunembo aboobo basikwiiya bakavulisya mu Jelusalemu ababo bapayizi bayingi bakali bombya akusyoma. ");
INSERT INTO dov_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Lino Sitivini kazwide luzyalo anguzu, wakali kuchita zigambyo zipati azitondezyo akati kabantu. ");
INSERT INTO dov_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pesi bakanyampuka bamwi bantu baku chikombelo chaambwa kuti nchikombelo cha Fulidimeni, wakuba Sayilini akuba Alekizandiliya, antomwe abamwi bazwaku Silisiya aku Eziya. Aba bantu bakali kukazyania a Sitivini. ");
INSERT INTO dov_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pesi tebakalikwe nguzu pe zyakukazyania abusongo a muuya walikwambula muli Sitivini. ");
INSERT INTO dov_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mpawo bakapa bamwi balumi masinkamulomo kabati, “Twakamumvwa ulamba majwi akusampawula Mozesi alimwi kambula bubi atala a Leza.” ");
INSERT INTO dov_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bakasungilizya bantu abapati, abalembi bayinka, bamujata Sitivini bamweta kulubeta. ");
INSERT INTO dov_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bakeeta bakamboni basikubeja, kabamba kabati, “Oyu mwalumi taleki pe kusampawula busena obu busalala amulawu. ");
INSERT INTO dov_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nkambo twakamumvwa kaamba kuti Jesu waku Nazaleta uyobumwaya busena obu, asandule ziyanza zyakatupa Mozesi. ");
INSERT INTO dov_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Boonse bakakkede mulubeta bakamulangisisya, babona busyu bwakwe bwasanduka bwaba mbuli busyu bwamungelo. ");
INSERT INTO dov_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mupayizi mupati wakati, “Makani aya ngakasimpe na?” ");
INSERT INTO dov_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitivini wakati, “Nobakwesu anomataata, mundiswilizye: Leza wabulemu wakalibonia kuli taata wesu Abbulahamu kali ku Mesopotamiya, katana kukkala mu Halani; ");
INSERT INTO dov_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","wakati kulinguwe, “Longa uzwe munyika yakulindinywe abantu bakulindinywe, mpawo uye kunyika njensikakutondezye.” ");
INSERT INTO dov_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Mpawo wakazwa wasiya inyika yaba Kkaludiya akuyokkala ku Halani, kali nkuko oku wisi nakafwa, Leza wakamweeta munyika omuno mumukkede lino. ");
INSERT INTO dov_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Takwe nakamupa kuti ibelukono lwakwe pe, nikuba mweenya wakuti alyate kulinjiyo. Pesi wakamusyomezya - kuti uzomupa nyika eyi kuti ibe lukono lwakwe amazyalani akwe, nikuba takalina kuba amwana pe - kuchindi echo mpakati uzomupa nyika eyi mbuli lukono kulinguwe akumazyalani ayotobela nguwe. ");
INSERT INTO dov_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Leza wakambula anguwe anzila eyi kuti bana bakwe bayokkala munyika yabwenzu, akuti bana banyika eyo bayobajata buzike akabapenzya kapati kwaminyaka ili myanda iine. Leza wakati, ");
INSERT INTO dov_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Pesi ndiyobeteka musyobo wabantu abo ibayobajata buzike, kuzwa awo bayozwa bazoze omuno bazondikombe mubusena obuno.' ");
INSERT INTO dov_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mpawo Leza wakapa Abbulahamu chizuminano chabupalule, elyo Abbulahamu wakazyala Ayizeki mpawo wamupalula mubuzuba bwamusanu aatatu; Ayizeki wakazyala Jakkobbu, mpawo Jakkobbu wakazyala ibalikkumi ababili. ");
INSERT INTO dov_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Lino nkambo kakuti Jozefu, bananyina bakamuchitila ibbivwe bakamuuzya ku Ijiputi, pesi Leza wakali anguwe ");
INSERT INTO dov_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","wakamuvuna kuzwa kumapenzi akwe. Wakapa Jozefu choolwe abusongo kunembo lya Falo, mwami waku Ijiputi, iwakamusala kuba mwendelezi mu Ijiputi aatala lyempuli yakwe. ");
INSERT INTO dov_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Lino kwakaba bbalanwe, amapenzi mapati mu Ijiputi yoonse amu Kkenani, mpawo bamataata bakabulikilwa chakulya. ");
INSERT INTO dov_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pesi Jakobbu nakamvwa kuti ku Ijiputi kuli chakulya, wakatuma bamataata kulwendo lutanzi. ");
INSERT INTO dov_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mulwendo lwabo lwabili Jozefu wakalitondezya kubakulana baklwe, mpawo wakabazibya kuli Falo. ");
INSERT INTO dov_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mpawo wakatuma bakulana bakwe kuti babwede bakaambile wisi kuti aze ku Ijiputi, antomwe abanzubo zyakwe bonse, kabali mweelwe wabantu bali makumi ali musanu aabili abantu bali musanu. ");
INSERT INTO dov_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Lino Jakobbu wakayinka wakukkala mu Ijiputi wakufwida mumo, welwakwe abamataata. ");
INSERT INTO dov_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bakabwezegwa batolwa ku Shekkemu bakubambwa mukabanda ka Abbulahamu nkakawula amuulo wansiliva kuzwa kubana ba Hamoli mu Shekkemu. ");
INSERT INTO dov_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Lino nichakamba kuzulila chiindi chachisyomezyo nchakali waamba kuli Abbulahamu, bantu bakakomena akuvula mu Ijiputi, ");
INSERT INTO dov_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","lumwi kwaba uumbi mwami wakeendelezya Ijiputi mwami utakwe anchakalizi pe azya Jozefu. ");
INSERT INTO dov_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wakeena bantu besu akubamanikizya kuti bazibye kuzyalwa kwabana bacheche kuchitila kuti abajaye. ");
INSERT INTO dov_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Muchiindi nchicho echo Mozesi wakazyalwa wakali kweebeka loko kubusyu bwa Leza, wakalondolwa kwamyezi iitatu mung'anda yawisi. ");
INSERT INTO dov_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Eelyo nakagwisigwa aanze, mwana musimbi wa Falo wakamutangila akumukomezya mbuli mwana wakwe mulombe. ");
INSERT INTO dov_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mozesi wakali yiide mulibonse busongo bwaba Ijiputi, mpawo wakabasinguzu mumajwi akwe amumilimu yakwe. ");
INSERT INTO dov_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pesi nakaamba kuzulizya minyaka ilimakumi aane wakayeeya mumoyo wakwe kuti aswaye babunyina ibazyalani lya Izilayeli. ");
INSERT INTO dov_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wakabona mu Izilayeli kalo kutamizigwa, Mozesi wakamuvuna mu Izilayeli nyina, wakali kupenzegwa mpawo wajaya mu Ijiputi: ");
INSERT INTO dov_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wakachita eezi kayeeyanga bantu bamukowa wakwe balaziba kuti Leza kwindila mukuboko kwakwe uyobapa lwangunuko pesi bo tebaka zimvwisisisya pe. ");
INSERT INTO dov_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Mubuzuba butobela wakabona balumi babili kabalo kulwana, wakeezya kubavuna chaluumuno wati, “Nobalumi, muli bantu bamwi biyo, nkambonzi nimulokuchisana lwanu lwanu?” ");
INSERT INTO dov_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pesi ulya umwi wakali wabisizya mwenzinyina wakamutontela kule mpawo wati, 'ngwani wakakusala kuti ube mwendelezi konotubeteka? ");
INSERT INTO dov_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Uyanda kundijaya na andime mbulimbwakajaya mu Ijiputi ulya ijilo? ");
INSERT INTO dov_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Lino Mozesi nakamvwa obu wakachija, wakakuba muzwakule munyika yaba Midiyani oko nkwakakuzyala bana balombe babili. ");
INSERT INTO dov_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Elyo nikwakinda minyaka ilimakumi aane angelo wakalibonia kuli nguwe munkanda yakuchilundu cha Sinayi mumabangabanga amulilo kali muchiteeyo. ");
INSERT INTO dov_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Lino Mozesi nakabona mulilo, zyakamuambya eezi, mpawo nakalikuya buswena afwifwi kuti abonesesye loko, kwakazwa ijwi lya Mwami lyakati, ");
INSERT INTO dov_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ndime Leza wabamawuso, Leza wa Abbulahamu awa Ayizeki a Jakobbu.' Mozesi wakayoowa takwe nakayanda kulanga lubo pe oko. ");
INSERT INTO dov_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lino Mwami Leza wakati kulinguwe, gwisya insangu kumawulu aako, nkambo abusena mpoyimvwi mbusena busalala. ");
INSERT INTO dov_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ndabona loko kupenzegwa kwabantu bangu balimu Ijiputi; Ndamvwa kukwila kwabo, alimwi Ndasika kuza kuzobavuna; kwalino kweza, Ndilakutuma ku Ijiputi.' ");
INSERT INTO dov_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Oyu Mozesi nguwe ngubakakkaka nibakamba kuti, “Ngwani wakakubikka buzuluzi amubetesi?” - nguwe ngwakatuma Leza kuti abe muzuluzi amuvuni. Leza wakamutuma kwinda mukuboko kwamungelo iwakalibonia kuli Mozesi muchiteyo. ");
INSERT INTO dov_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mozesi wakabazulwida wabagwisya mu Ijiputi, nakachita zigambyo azitondezyo mu Ijiputi akuLwizi lwa Matete, amunkanda muminyaka ili makumi aane. ");
INSERT INTO dov_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Oyu Mozesi ngonguwe wakaamba kuti kuba Izilayeli, 'Leza uyomupa musinsimi kazwa akati kababunyina, musinsimi uli mbuli ndime.' ");
INSERT INTO dov_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Oyu ngomwalumi wakali mukwiizya amungelo wakali kwambula awe atala achilundu cha Sinayi, iwakali aamwi abamataata, iwakatambula imajwi apona kuti atwambile iswebo. ");
INSERT INTO dov_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pesi bamataata bakakaka kumuswilizya; bakamutontela kule kuzwa kulimbabo, mpawo mumyoyo yabo bakabweda ku Ijiputi. ");
INSERT INTO dov_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Echo chindi bakambila Aaloni kuti tupangile baleza batatuzulwide. Oyu Mozesi, wakatugwisya mu Ijiputi tatuzi pe ichachitika kulinguwe.' ");
INSERT INTO dov_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lino bakapanga kanamani kumazuba ayo baleta chipayizyo kuli nkako, mpawo bakakondwa nkambo kamilimo yamaboko abo. ");
INSERT INTO dov_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Pesi Leza wakachengunuka mpawo wakapeda kukomba nyenyezi zyamulengalenga, mbuli mbukulembedwe mubbuku lyabasinsimi kuti, “Mwakandipana zipayizyo zyamitumba yabanyama kwaminyaka iili makumi aane munkanda, inywebo nobana ba Izilayeli? ");
INSERT INTO dov_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mwakatambula chikombelo cha Moleki antomwe anyenyeezi yaleza waLafani, azikozyanio nzimwakapanga kuti muzikombe: alimwi Ndiyomubweza nkamwiinzye mu Bbabbiloni.' ");
INSERT INTO dov_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bamataata bakalijisi idumba lyabukamboni munkanda, mbuli Leza mbwakalayilila nakaambula a Mozesi kuti welede kuchita mbuli mabambilo ngaakabona. ");
INSERT INTO dov_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Musule lyayaaya, bamataata, kabali ansi lyabuzuluzi bwa Johuwa, bakatambula idumba lyakubunanina baza alyo nibakakona bulono bwanyika. Leza wakabweza bulongo wanyanzya misyobo yabantu bakalikukkala mumo wabatanda kubusyu bwamataata. Elidumba lyakaliwo munyika omuno kusikila kuchindi cha Devidi, ");
INSERT INTO dov_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","oyu wakajana cholwe kubusyu bwa Leza, mpawo wakumbila kuti ajane busena bwakukkala bwang'anda ya Jakobbu. ");
INSERT INTO dov_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pesi ngu Solomoni wakayaka ing'anda ya Leza. ");
INSERT INTO dov_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nekuba obo, Sijulu lyamajulu takkali mung'anda iyakwa amaboko, mbuli mbwaamba musinsimi kuti, ");
INSERT INTO dov_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ijulu nipande lyangu mpawo inyika ngimalyatililo amawulu angu. Musyobo uli weng'anda unga ulandiyakila? Mbwamba Mwami, an, mbobuli busena bwakulyokezya kwangu? ");
INSERT INTO dov_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Temaboko angu na akachita zintu eezi zyoonse?' ");
INSERT INTO dov_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Inywebo nobasichizindwe, nobasyajumumoyo, noba nkunulumatwi, chindi chonse mulakaka Muuya Uusalala; mulijisi inchito zyabamawuso. ");
INSERT INTO dov_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nguuli wabasinsimi ngubatakwe nibakapenzya bamawuso? Bakajaya basinsimi bakalibonia katana kusika pe Ululeme, mpawo lino mwaba basikumwaba abasikumujaya, ");
INSERT INTO dov_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Inywebo nobantu ibakatambula mulawu oyo wakabikwa aba angelo, mpawo mwakachilwa kuulondola?” ");
INSERT INTO dov_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lino baalu bebboma nibakamvwa makani aya, bakanyongana mumyoyo bamulumina ntwino Sitivini. ");
INSERT INTO dov_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pesi welwakwe, kazwide Muuya Uusalala, wakalungumana kujulu mpawo awo wabona bulemu bwa Leza. Elyo wakabona Mwami Jesu kayiimvwi kululyo lwa Leza. ");
INSERT INTO dov_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sitivini wakati, “Mulange, ndabona majulu kajulidwe, a Mwana amuntu ulimvwi kululyo lwa Leza.” ");
INSERT INTO dov_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kuli ezi baalu bebboma bakasinka matwi aabo, bompoolola ajwi pati, bakachijana kuli nguwe amoyo umwi. ");
INSERT INTO dov_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Bakamugwisizya aanze changuzu batanguna kumutulula mabwe, Bakamboni bakabika zisamo zyabo kumawulu amulombe uutegwa Sawulo. ");
INSERT INTO dov_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lino nibakali kumutulula mabwe, wakali kusompezya kuli Leza kati, “Mwami Jesu tambula muuya wangu.” ");
INSERT INTO dov_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wakafugama wayita ajwi ipati wasikuti, “Mwami, mutabapi mulandu pe kuchibi eechi nchibahita.” Lino nakamaninsya kwamba makani aya, wakona mpawo. ");
INSERT INTO dov_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sawulo wakati muchizuminano chalufu lwakwe. Nkabela kwakatalika mubuzuba obo kupenzegwakupati ambungano zyakali mu Jelusalemu; mpawo basyomi bakamwayika kumasena woonse a Judiya a Samaliya, kusiya batumwa. ");
INSERT INTO dov_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Balumi basyomi bakamuzikka Sitefani akumulila kapati. ");
INSERT INTO dov_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Asi Sawulo wakeezya kunyoonyona mbungano. Wakali kunjila mumaanda, kasunga boonse baalumi abanakazi, akubabikka muntolongo. ");
INSERT INTO dov_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Echo chiindi bazumini bakali mumasena asiyene-siyene bakeenda kabaya bukambawuka makani a Leza. ");
INSERT INTO dov_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo wakeenda kuchisi cha Samaliya akukambawuka kulimbabo azya Kkilisito. ");
INSERT INTO dov_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Makamu abantu bakali kupa afwifwi kuswilila kuli zyakali kwaambwa a Filipo; kabali amuzeezo omwe ngubakamvwa kulinguwe, alimwi bakabona zitondezyo nzyakachita. ");
INSERT INTO dov_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Myuuya isofwede yakazwa abiingi bakali kkedwe, kulila kapati ajwi lyakoompolola, abiingi bakalebukide azilema bakasilikwa. ");
INSERT INTO dov_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eelyo kwakaba kubotelwa kupati muchisi eecho. ");
INSERT INTO dov_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Asi kwakali umwi mwalumi muchisi wakali kutegwa Sayimoni, wakali kuchita zyabusondi; wakali kugambya bantu bamu Samaliya kali kulyaamba kuti wakali mwalumi ulemekeka. ");
INSERT INTO dov_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Boonse ba-Samaliteni, kuzwa kubanini abapati, bakaliya kulinguwe; bakati, “Ooyu mwalumi sa ninguzu zya Leza nzyali kutegwa mupati.” ");
INSERT INTO dov_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bakaswilizya kulinguwe nkambo wakabagambya kwachiindi chipati abusondi bwakwe. ");
INSERT INTO dov_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Asi nibakasyoma Filipo kalungulula makani mapati mabotu atala aBwami bwa-Leza azina lya Jesu Kkilisito, bakabbabbatizigwa, boonse balumi abanakazi, ");
INSERT INTO dov_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","alakwe Sayimoni lwakwe wakasyoma, alimwi nakamana kubbabbatizigwa wakakkala kwachiindi kabalamwi a Filipo. Nakabona zitondezyo azigambyo zyakachitika abusena, wakagamba. ");
INSERT INTO dov_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Lino batumwa bamu Jelusalema nibakamvwa kuti baSamaliya batambula makani mabotu a Leza, bakatuma kuli mbabo Pita a Jowani. ");
INSERT INTO dov_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nibakasika, bakabakombela kuti batambule Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Muchindi echo, Muuya Uusalal twkalinaba ali umwi wabo; bakali kubbabbatizigwa kupela muzina lya-Mwami Jesu. ");
INSERT INTO dov_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mpawo Pita a Jowani bakabikka maanza abo amitwe, alimwi bakatambula Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lino Sayimoni nakabona kuti Muuya Uusalala wakapegwa akubikkwa maanza amitwe abatumwa, wakabapa mali. ");
INSERT INTO dov_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Wakati, “Amundipe andime inguzu ezi, kuti kufumbwa ngunditabikke maanza alinguwe atambule Muuya Uusalala.” ");
INSERT INTO dov_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Asi Pita wakati kulinguwe, “Insiliva yako ifwidilile antoomwe anduwe, nkambo wayeeya kujana chipego cha Leza amali. ");
INSERT INTO dov_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tojisi chabilo nebuba busena kumakani aya, nkambo moyo wako tululeme kunembo lya Leza. ");
INSERT INTO dov_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nkambo kaako, sanduka kububi bwako obu, ukumbile kuli-Leza, kuchitila kuti ambweni walikukulekelela kuyeeya kwamoyo wako. ");
INSERT INTO dov_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nkambo ndabona kuti uli mubuyoka bwamachise amubwange bwamililandu. ");
INSERT INTO dov_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sayimoni wakasandula wati, “Amundikombele ku-Mwami kuti kutabi nichiba chomwe chichitika kulindime aali nzimwamba.” ");
INSERT INTO dov_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Aboobo nibakasinizya akwamba makani a Mwami, Pita a Joni bakabweda ku-Jelusalema, baya bukambawuka makani mabotu mumyunzi myingi yaba Samaliteni. ");
INSERT INTO dov_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Lino angelo wa-Leza wakambila Filipo wati, “Nyampuka uye kumusanza, kumugwagwa uzwaku Jelusalema uyaku Gaza.” ( ooyu mugwagwa ulimunkanda.) ");
INSERT INTO dov_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Wakanyampuka akweenda. Lino kwakali mwalumi waku-Etiyopiya, muzibe wamwami mupati wa Kkandasi, namalelo waba Etiyopiya. Nguwakali mulangi walubono lwakwe loonse. Wakaza ku-Jelusalema kukukomba. ");
INSERT INTO dov_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wakali kubwed, kakkede munkalaki, nkayabubala mulugwalo lwa- musinsiimi Isaya. ");
INSERT INTO dov_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Muuya wakambila Filipo kuti, “Sweena ube afwifwi ankalaki eeyi.” ");
INSERT INTO dov_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nkabela Filipo wakachijana kaya kuli nguwe, alimwi wakamvwa kabala kuli-Isaya musinsimi, eeno wati, “Ulamvwisisisya na nzolokubala?” ");
INSERT INTO dov_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nkabela muzibe wakasandula Filipo kuti, “Ino ndilakonzya buti, kaatakwe muntu unditondezya?” Mpoonya aawo wakatamba Filipo kuti akkale anguwe munkalaki. ");
INSERT INTO dov_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lino chandano ncakali kubala ncheechi; wakeenzegwambuli kabelele kaya kukujayigwa, Ambuli kabelele kawumuna kunembo lya ugela, Nkabela awalo takambula, ");
INSERT INTO dov_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kukulyeetezya kwakwe takabetekedwe kabotu, Nguni oyu amba izyalani lyakwe? Nkambo buumi bwakwe bwagwisigwa ansi. ");
INSERT INTO dov_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nkabela muzibe wakamuvwila Filipo wakati, “Ndilokubuzya, ino nguni ngwaamba musinsimi kumakani aya sa ulyaamba lwakwe mwini, na uwamba umbi?” ");
INSERT INTO dov_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filipo wakatalika kwambula, wasanguna kulugwalo olu ndulonya kumukambawukila a-Jesu. ");
INSERT INTO dov_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nobakali kweenda mumugwagwa, bakasika kwakali meenda. Muzibe wakati, “Bona ngaya meenda, nchiinzi ino ichinga chilandikkachizya kubbabbatizigwa?'.” ");
INSERT INTO dov_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo wakati, “Na wasyoma amoyo wako woonse ulakonzya. Muzibe waksandula, “Ndasyoma kuti Jesu Kkilisito ngu-Mwana wa-Leza.” ");
INSERT INTO dov_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nkabela Muzibe wakalayilila kuti inkalaki iyimikile, bakaseluka akunjila mumaanzi, kabali babili Filipo amuzibe, wakamubbabbatizya. ");
INSERT INTO dov_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nibakazwa mumeenda amuzibe, Muuya wa-Mwami wakakwempa Filipo, muzibe takachili kumubona limbi, asi wakatozya munzila yakwe kaya bubotelwa. ");
INSERT INTO dov_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Asi Filipo wakabonwa ku-Azotusi. Akwinda mugundu, elyo lyoonse uyabukambawuka makani mabotu mane wasika ku- Sizaliya. ");
INSERT INTO dov_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Pesii, Sawulo mbwalikwambula ziyoosyo akujaya basikwiiya baMwami, ");
INSERT INTO dov_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","wakiinka kubapaizi bapati alimwi kuyokumbila magwalo amuzumizya kuya kuzikombelo zyabajuda zyaku Damasiko, kucitila kuti naswaana bazumini naba mwaalumi naba mwanakazi, akabange akubatola ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nakacili kuyabwinka, nakasika afwifwi a Damasiko, mpawompawo kwakaboneka mumuni konse konse uzwa kujulu; ");
INSERT INTO dov_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","alimwi wakawida aansi alimwi wakangwa ijwi lyakamwambila kuti, “Sawulo, Sawulo, undipenzenzyanazi me?” ");
INSERT INTO dov_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sawulo wakasandula, “Nduweni, Mwami?” Mwami wakati, “Ndime Jesu ngolikupenzya; ");
INSERT INTO dov_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","pesi buka, unjile mucisi, uyowambilwa zyakuchita,” ");
INSERT INTO dov_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Baalumi bakalikweenda a Sawulo bakayowa bakagamba, kumvwa ijwi, Asi kabatabwene muntu. ");
INSERT INTO dov_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawulo wakabuka kuzwa ansi, alimwi nakajula meso akwe, takwe nchakabona; mpawo bakamujata kuboko bamuzulwida akwinka awe ku Damasiko. ");
INSERT INTO dov_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kwamazuba otatwe takalikubona pe, nekuba kulya naanka kunywa. ");
INSERT INTO dov_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kwakaliko sikwiiya ku Damasiko walikutegwa Ananiyasi. Mwami wakamwambila mucilengano, “Ananiyasi.” Wakavuwa, “Bona, ndilano, Mwami.” Mwami wakati kulinguwe, ");
INSERT INTO dov_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Buka, uyinke kunzila iitegwa Sitileti, kung'anda ya Judasi ukabuzye muntu utegwa Sawulo waku Tasasi nkambo ulakomba. ");
INSERT INTO dov_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Wabona muchilengano mwalumi utegwa Ananiya ulanjila akubika maanza kuti abone alimwi.” ");
INSERT INTO dov_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Asi Ananiyasi wakasandula kuti, “Mwami ndakamvwa biingi loko amuntu oyu, abubi mbwakachitila basalali bako baku Jelusalemu. ");
INSERT INTO dov_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ulijisi bwami mbwakapegwa kubapayizi bapati bwakwaanga boonse abakomba kuzina lyako.” ");
INSERT INTO dov_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Asi Mwami wakati kulinguwe, “Yinka, nkambo ndamusala kuba chibelesyo changu; akubana ba Izilayeli; ");
INSERT INTO dov_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nkabela ndiyomutondezya zyiingi-zyiingi nzyayeelede kuyopengela zina lyangu. ");
INSERT INTO dov_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nkabela Ananiyasi wakiinka, wakunjila munganda. Wamubika maboko wati, “Sawulo mukwesu, Mwami Jesu, wakalibonya kulinduwe munzila njwakazeyo, wandituma kuti ubone alimwi uzule muuya Uusalala.” ");
INSERT INTO dov_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mpawo kwakazwa kumeso akwe aabanga mapapa, wabona; wakabuka akubbizigwa; ");
INSERT INTO dov_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","alimwi akulya wajana nguzu. Ino wakakkala mazuba amwi abasikwiiya bamu Damasiko kwamazuba. ");
INSERT INTO dov_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ndilyo wakakambauka muzikombelo zyaba Juda, kuti Jesu mwana wa-Leza. ");
INSERT INTO dov_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Boonse bakamuswilila bakagamba akwamba kuti, “Tensi nguwe wakajaya mu Jelusalema basikukomba muzina eli?. Akokuno wazida kubatola kabangidwe kubapayizi bapati.” ");
INSERT INTO dov_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Asi Sawulo wakali kuya bukomena munguzu, wakabayinda kunguzu akuleta lupyopyongano kuba Juda bakakkede mu Damasiko kusinizya kuti Jesu ngu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nakamana mazuba mingingi, ba Juda bakakanza kumujaya. ");
INSERT INTO dov_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pesi Sawulo wakaziba kukanza kwabo. Bakalikulindila milyango sikati amansiku kuti kuti bamujaye. ");
INSERT INTO dov_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pesi basikwiiya bakwe bakamutola mansiku akumuselusya abulambo muchisuwo. ");
INSERT INTO dov_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Lino Sawulo nakasika ku Jelusalema, wakayezya kuswanana abasikwiiya, pesi bakamuyoowa boonse, tebakali kusyoma ngusikwiiya. ");
INSERT INTO dov_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pesi Bbanabbasi wakamubweza wamutola kubaapositolo, waba lungulwida Sawulo mbakabona Mwami munzila akuti wakambula awe, ambwakali achaamba chakukkambawuka mu Damasiko muzina lya-Jesu. ");
INSERT INTO dov_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Elyo wakakuya buzelengana abo, mukati aanze a Jelusalema. Wakambawuka echamba muzina lya Mwami Jesu, ");
INSERT INTO dov_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","alimwi wakambula akukazyania abama Juda; pesi abalabo bakasoleka kumujaya. ");
INSERT INTO dov_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Elyo nebakamvwa obo babunyiina, bakamutola kuli Sizaliya akumutuma ku Tasasi. ");
INSERT INTO dov_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nkabela, ino mbungano yamu Judiya moonse, amu Galilaya, amu Samaliya yakaba aluumuno akuyakwa; akwenda chakuyowa Leza akutobela mumuuya Uusalala, mbungano yakayungizizigwa. ");
INSERT INTO dov_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Mukuya kwechiindi, Pita nakayenda kumasena oonse, wakasika alimwi kubasalali baLeza bakakkede mu Lida. ");
INSERT INTO dov_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Oko wakakujana mwalumi utegwa Eniyasi, wakalede aabulo bwakwe kwaminyaka ilimusanu ayitatu, kalebukide mubili. ");
INSERT INTO dov_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita wakamwambila kuti, “Eniyasi, Jesu Kkilisito wakuponia. Buka uyalule bulo bwako,” ndilyo wakabuka. ");
INSERT INTO dov_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nkabela bakamubona boonse abakkede mu Lida amu Shaloni, bakasandukila ku Mwami. ");
INSERT INTO dov_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ino mu Jopa kwakaliwo sikwiiya walikutegwa Tabita nkokuti “Dolika.” Oyo mwanakazi wakalizwide milimo mibotu ayaluzyalo ndwakali kuchitila bafwaba. ");
INSERT INTO dov_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kumazubayo wakachiswa akufwa; Nebakamusanzya, bakamuka munganda yamujulu. ");
INSERT INTO dov_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lino mbokuli kufwifwi ku Lida kuyaku Jopa, alimwi basikwiiya nobakamvwa kuti Pita wakaliko, bakamutumina baalumi bobile kuyomukombelezya kuti, “utachedwi kusika kulindiswe.” ");
INSERT INTO dov_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita wakanyampuka wakinka ambaaabo. Nkasika, bakamutola kunganda yamujulu, boonse bamukabafu bakayima kubbazu lyakwe akulila, akumutondezya zibaki ezyakusuma nzyakali kusuma Dolika nakachili abo. ");
INSERT INTO dov_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita wakabatandila anze boonse, wakasandukila kumutunta, wakati; “Tabita, buka.” Mpawo wakajula meso akwe, akubona Pita wakakkala. ");
INSERT INTO dov_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita wakamupeda janza akumwimika; nakaayita basalali abamukabafu, wakamubikka kalimuumi kunembo lyabo. ");
INSERT INTO dov_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ezi zyakamvwigwa moonse mu Jopa, lino bantu bingi loko bakasyoma ku Mwami. ");
INSERT INTO dov_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Lino Pita wakakkala mu Jopa mazuba miingi loko kuli Sayimoni musuki wazikumba. ");
INSERT INTO dov_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Lino kwakali umwi mwalumi wamuchisi chaku Sizaliya, wakali kutegwa Kkoneliyasi, mwendelezi wabasilumamba balimwaanda baku Itali. ");
INSERT INTO dov_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wakali mwalumi ulipede, akuyoowa Leza antomwe abang'anda yakwe, wakali kupa mali kulibabo bakali kubula, alimwi wakali kukomba God lyoonse. ");
INSERT INTO dov_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Achindi chamahola ali musanu aane kuseni, wakabona chilengano chamungelo wa Leza kaza kulinguwe. Mungelo wakati, “Kkoneliyasi!” ");
INSERT INTO dov_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kkoneliyasi wakalangisisya mungelo alimwi chakuyowa kapati wasikuti, “Uwambanzi, yomwalumi?” Mungelo wakati kulinguwe, “Inkombyo abwabi bwako kubafwaba zyasika kujulu mbuli chipo chaku yeeyegwa mubuliwo bwa Leza. ");
INSERT INTO dov_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Lino tuma balumi kuchisi chaku Jopa bakandetele mwalumi utegwa Sayimoni utegwa Pita. ");
INSERT INTO dov_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ukkala amusuki uwuzikidwe kuti Sayimoni, ulaang'anda ili afwifwi ankomwe yalwizi.” ");
INSERT INTO dov_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Eelyo mungelo wakaambula kulinguwe nakeenda, Kkoneliyasi wakayita babeleki bakwe bobile bamuunzi, alimwi asilumamba umwi wakali pedelede akati kabonse bakali kumubelekela. ");
INSERT INTO dov_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kkoneliyasi waka baambila zyoonse zyakachitika mpawo wabatuma kuti bayinke ku Jopa. ");
INSERT INTO dov_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lino mubuzuba bwakatobela achiindi chamahoola alimusanu alimwi, kabachili mulwendo lwabo alimwi kabali babafwifwi achisi, Pita wakatanta mung'anda yamujulu kuyokomba. ");
INSERT INTO dov_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mpawo wakaba enzala kayanda kulya chimwi nchanga ulalya, pesi bantu bakachili kujika chakulya, wakapegwa chilengano, ");
INSERT INTO dov_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","alimwi wakabona julu lijulikide mpawo achibikilo chakalibonia, chakali mbuli mucheka mupati kuyobuseluka kuuza enyika kuujisi mabazu awo aane. ");
INSERT INTO dov_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mulinguwo kwakali banyama bamisyobo yoonse bakali amawulu aane azinyama ziyavula anyika, alimwi abayuni bawuluka mujulu. ");
INSERT INTO dov_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Eelyo kwakasika ijwi kuli Pita lyasikuti, “Buka, ujaye alimwi ");
INSERT INTO dov_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","uulye.” Pesi Pita wakati, “Peepe, Mwami; nkambo takwe nindakalyide chintu chisofwede pe alimwi chitasalali.” ");
INSERT INTO dov_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pesi ijwi lyakamusikila lubo kachibili lyasikuti: “Echo Mwami Leza nchakasalazya, toyelede pe kuchaamba kuti chilisofwede.” ");
INSERT INTO dov_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Eezi zyakachitika tutatu; eelyo chibikilo chakabwedezegwa lubo kujulu. ");
INSERT INTO dov_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Eelyo Pita naka chili kuzilikila chilengano nchakabona kuti chakali kwambanzi, amubone, balumi aabo bakatumidwe a Kkoneliyasi bakalimvwi amulyango, kabali kubuzya inzila iya kung'anda. ");
INSERT INTO dov_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bakasompezya mpawo babuzya naa Sayimoni uutegwa Pita, wakali kukkala mpawo na. ");
INSERT INTO dov_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Awo Pita nakachili kuyeeya azyechilengano, Muuya wakamba kuti kulinguwe, “Langa, balumi batatu balikuyandula nduwe. ");
INSERT INTO dov_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Buka useluke uyende aabo. Uta doneki pe kweenda abo, nkambo ndili batumide.” ");
INSERT INTO dov_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Elyo Pita wakaseluka wayinka kubalumi wakubaambila kuti, “Ndendime oyo ngumulokuyandula. Mwazidaanzi?” ");
INSERT INTO dov_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bakati, “Mwendelezi wabasilumamba balimwaanda, utegwa Kkoneliyasi, mwalumi musalali oyo uyowa Leza, alimwi oyo wamba abubotu kunyika yoonse yama Juda, wakapegwa mulumbe kuzwa kuli Leza mukwinda mumungelo usalala oyo wakapa kuti tutumwe kuti webo ubole kung'anda yakwe, kuti akaswilile mulumbe kuzwa kulinduwe.” ");
INSERT INTO dov_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Lino Pita wakabayita kuti baze bazokkale amwi. Mubuzuba bwakatobela, wakabuka mpawo winka ambabo, alimwi bamwi babunyina bazwa ku Jopa bakamusindikila. ");
INSERT INTO dov_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Mubuzuba butobela bakasika ku Sizaliya. Kkoneliyasi wakali balindide; wakali watamba baluzubo lwakwe antoomwe abenzinyina baafwifwi. ");
INSERT INTO dov_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Awo Pita wakanjila, Kkoneliyasi wakamutambula mpawo wawida aansi amawulu akwe, wakomba. ");
INSERT INTO dov_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pesi Pita wakamubusya wamba kuti, “Buka! Ambebo ndili muntu biyo.” ");
INSERT INTO dov_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Eelyo Pita naakachili kwambula anguwe, wakanjila mpawo wajana bantu bakali bungene aamwi. ");
INSERT INTO dov_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wakabambila kuti, “Inywe lwanu mulizizi kuti takuzumininwi pe kuti mwalumi mu Juda ayenzyanie amwenzu nikuba kumuswaya. Pesi Mwami Leza wakanditondezya kuti nsyelede pe kwamba muntu naba umwi kuti uli sofweede nikuba kumwamba kuti ngu simatombe. ");
INSERT INTO dov_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nchenchicho nchindakaza kanditakazyi pe, nimwakandiita. Pesi ndibuzya nchimwakandiitila.” ");
INSERT INTO dov_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kkoneliyasi wakamba kuti, “Musule amazuba aane muhola ndilyo eli, ndakali kukomba muhola lyamusanu aane mung'anda yangu; Amubone, mwalumi wakayima kunembo lyangu kasamide chibaki chabayima. ");
INSERT INTO dov_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wakaamba kuti, “Kkoneliyasi, nkombyo yako yamvwigwa a Leza, abululami bwako bwayeeyezya Mwami Leza atala anduwe. ");
INSERT INTO dov_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Lino tuma umwi ayinke ku Jopa, akakwitile mwali utegwa Sayimoni ulezina litegwa Pita. Ukkala mung'anda yamusuki wazikwiiye wiitwa kuti Sayimoni, kumbali lyankomwe yalwizi.' mpawo mpawawo ndakakutumina bantu. Kulangunukide kuti uze. ");
INSERT INTO dov_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Lino obuno, toonse mpotuli ano kunembo lya Leza kuti tumvwe zyonse nzimwaka layililwa kuzwa ku Mwami.” ");
INSERT INTO dov_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mpawo Pita wakamba kuti, “Chakasimpe, Ndakabona kuti Leza talangi chiimo. ");
INSERT INTO dov_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Anukuti, Munyika imwi ayimwi kufumbwa umuyoowa akuchita bululami ulatambulika kuli nguwe. ");
INSERT INTO dov_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mulilizi ijwi ndyakatumizya kubantu baku Izilayeli, awo nakali kwambuula makani mabotu alumuuno mukwinda muli Jesu Kkilisito, Mwami wazyonse - ");
INSERT INTO dov_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","inywe ilwanu mulizizi zyakachitika, zyakaba munyika yoonse yamu Judiya, kazitangunina mu Galili, Joni nakazwa kwambula azyalubbizyo; ");
INSERT INTO dov_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ezyo zyakali atala a Jesu waku Nazaleta, kuti mbobuli Leza mbwakamunanika a Muuya Uusalala antomwe anguzu. Wakayita zintu zibotu akuponesya abo boonse bakali kutamizigwa aba siluuni a satani, nkambo Leza wakali anguwe. ");
INSERT INTO dov_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tuli bakamboni bazintu zyonse eezyo zyakachitwa a Jesu, munyika yama Juda alimwi amu Jelusalema. Bakamujaya mpawo bamulengelezya amusamu, ");
INSERT INTO dov_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","pesi Mwami Leza wakamubusya mubuzuba bwatatu akumuchita kuti abonwe, ");
INSERT INTO dov_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","pepe kubantu boonse, pesi kuti kubakamboni abo bakasalidwe kale a Mwami Leza - andiswe andiswe nitwakalya anguwe kali wabuka kuzwa kubafu ");
INSERT INTO dov_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wakatwambila kuti tukabambile bantu alimwi akwambisya kuti oyu ngonguwe wakasalidwe a Mwami Leza kuti abe mubetesi wabachipona abakafwa. ");
INSERT INTO dov_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nkulinguwe nkukwakaba kuti basinsimi bonse bambule majwi mayingi azyakwe, kuchitila kuti boonse bamusyobo ma bakatambule lulekelelo lwazibi zyabo mukwinda muzina lyakwe.” ");
INSERT INTO dov_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Eelyo Pita nakachili kwambuula zintu ezi zyonse, Muuya Uusalala wakaba selukila abo boonse bakali kuswilizya nzyakali kwambula. ");
INSERT INTO dov_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Abo bantu boonse bakali munkamu yabakali palwidwe abakali basyomi - boonse bakazide a Pita - bakagamba, nkambo Muuya Uusalala wakabasikila abalabo bamaasi mpawonya awo. ");
INSERT INTO dov_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nkambo bakamvwa bamaasi abalabo kabaambula mumilaka imbi kabalumbayizya Mwami Leza. Mpawo Pita wakasandula wasikuti, ");
INSERT INTO dov_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Mpalina muntu uunga ulakasya meenda kuti bantu batabbizigwi pe, aaba bantu batambula Muuya Uusalala antomwe andiswe?” ");
INSERT INTO dov_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Lino wakalayilila kuti babbizigwe muzina lya Jesu Kkilisito. Eelyo bakamukumbila kuti bakkale amwi kwamazuba mingi. ");
INSERT INTO dov_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lino batumwa ababunyina bakali mu Judiya nebakamvwa milumbe yakuti bamaasi batambula ijwi lya-Leza abalabo. ");
INSERT INTO dov_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita nakasika muchisi cha-Jelusalema, inkamu yabapalwidwe yakamupa mulandu. ");
INSERT INTO dov_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Yakamwambila kuti, “Walivwelengania akulya abantu batapalwiidwe!” ");
INSERT INTO dov_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pesi Pita wakabalungulwida mubunikide, “Kuti, ");
INSERT INTO dov_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","ndalikukomba mudolopo lya-Jopa, mpawo ndatondezegwa chilengano chachibikkilo kachiseluka aansi, mbuli mulembo uzwa kujulu ulampeto zyoone. Wakaselukila kulindime. ");
INSERT INTO dov_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ndakawulangisisya, Mpawo ndayeyesya aatala anguwo. Ndakabona banyama balamawulu oone baansi, banyama bamusokwe, bayavula ansi, abayuni bawuluka bakujulu. ");
INSERT INTO dov_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mpawo ndakamvwa ijwi kaliti nyampuka, Pita jaya mpawo ulye! ");
INSERT INTO dov_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ndakati, “tachelede pe, Mwami, tachiwope chisofwede kana chitasalali chakali chanjila mumulomo wangu.” ");
INSERT INTO dov_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pesi ijwi lyakavuwa lubo kuzwa kujulu, kaliti, eecho Leza nchasalazya, toyelede kuchaamba kuti chilisofwede; ");
INSERT INTO dov_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Eechi chakachitika tutatu mpawo zyoonse zyakabwedezegwa kujulu lubo. ");
INSERT INTO dov_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Mpawo aawo kwakali balumi botatwe bakiimvwi an'anda mputwakiimvwi, Bakatumwa kuzwa ku Sizaliya kabaza kulindime. ");
INSERT INTO dov_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Muuya wakandilayilila kuti yiinka ambabo, mpo nsyelede kulisiyanisya pe ambabo. Aba bakwesu balimusanu awumwi bakeenda andime, mpawo twakanjila munganda ya umwi mwalumi. ");
INSERT INTO dov_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wakatwambila mbakabona mungelo uyimvwi mukati kanganda yakwe mpawo kalokuti, “Tuma balumi ku Jopa mukaze a Sayimoni utegwa Pita. ");
INSERT INTO dov_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Uzokwambila makani ayo aazochitya kuti iwe abanganda yako mufutulwe. ");
INSERT INTO dov_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nindakatalika kwambulaabo, Muuya Uusalala wakaselukila alimbabo, mbubonya mbuli mbuwakachita alindiswe kumatalikilo. ");
INSERT INTO dov_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ndakayeeya majwi a Mwami, mbuli mbaakamba, Joni nchobeni wakababbabbatizya a meenda Pesi nywe ndamubbabbatizya a Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Aboobo na kakuli Leza wakabapa zipo mbubonya mbakapa ndiswe awo nitwakasyoma ku Mwami Jesu Kkilisito Ndakalini mpundanda kayinokazyania a Leza? ");
INSERT INTO dov_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nibakamvwa zintu, eezi, takwe nchibakakonzya kwamba nikuba nsandulo, pesi bakalumbaizya Leza bati, “Leza wabapa buumi bwakusanduka kwabamaasi aabazwakule.” ");
INSERT INTO dov_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lino bakamwayikide nkambo kamakatazyo akabukila akambo kazyakali zyachitika kule mbuliku Fonesiya, Sayipulasi aku-Antiyokki kabayo bukambawukila ba-Juda. ");
INSERT INTO dov_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pesi bamwi babo, balumi baku Sipulasi a Sayilini bakasika ku Antikkeya bakambawukila aba Giliki, kababambila makani mabotu aatala amwami Jesu. ");
INSERT INTO dov_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Akuboko kwa-Leza kwakalambabo; makamu makamu abantu akasyoma akuza ku-Mwami. ");
INSERT INTO dov_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Impuwo ataala ambaabo zyakasika kumatwi ambungano mu-Jelusalema, mpawo bakatumwa Bbanabbasi kuyosika ku - Antiyokkiya. ");
INSERT INTO dov_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nakasika wakabona luzyalo lwa-Leza, wakabotelwa alubo akubasungwazya boonse kuti bayiime mu-Mwami amyoyo yabo yoonse ");
INSERT INTO dov_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nkambo kakuti wakali mwalumi ululeme uzwide Muuya Uusalala alubo kalalusyomo abantu biingi bakayungizigwa ku-Mwami. ");
INSERT INTO dov_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mpawo Bbanabbasi wakaya ku Tasasi kukuyandula Sawulo, ");
INSERT INTO dov_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nakakumujana, wakamubozya ku Antiyokku. Zyakachita obo kwamunyaka wonse bakali kubungana amwi ambungano akuyisya bantu biingi. Basikwiya mpobakatalikila kwambwa kuti mbaKkilisito. ");
INSERT INTO dov_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lino muli ayo mazubabamwi basinsiimi bakakunuka kabazwa ku-Jelusalema kabaya ku Antiyokku. ");
INSERT INTO dov_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Umwi wabo, utegwa Agabbasi, wakimikila kali watondezegwa a Muuya Uusalala kuti kuzoba nzala mpati anyika yoonse. Eechi chakachitika kumazuba a Kkilawudiyasi. ");
INSERT INTO dov_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nkabela basikwiiya, umwi awumwi mbuli mbakakonzya kupa, bakatumizya banyiina baku Judiya. ");
INSERT INTO dov_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bakachita oobu, bakatumizya mali kubazululi bambungano kwindilila mumanza a Bbanabbasi a Sawulo. ");
INSERT INTO dov_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lino kuchindi echo Helodi mwami wakaanga bamwi babunyina mumbungano kuti abapenzye ");
INSERT INTO dov_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wakajaya Jemusi mwanaakwabo acheeba ");
INSERT INTO dov_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nakabona kuti echi chakabotezya bamaJuda, wakayinkilila kunembo akwaanga Pita alakwe. Ayo akali mazuba chibunge chitakwe bumena. ");
INSERT INTO dov_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nakazwa kukumwanga, wakamubikka muntolongo wamutula kuli basikulinda ntolongo bane kuti bamulinde, walikuyanda kumweeta kubantu kukumana kwa Pasika. ");
INSERT INTO dov_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Aboobo Pita wakalijiswi muntolongo, pesi inkombyo zyabasikumukombela kuli Leza, zyakendelela anembo muchikombelo. ");
INSERT INTO dov_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kumansiku ngawo Helodi katana mutola kukubetekwa Pita wakalilede akati kabasilumamba babili, kaangidwe amakketani aabili mbubonya basikumulinda kabali kunembo amulyango wentolongo, balikkede kabalinda intolongo. ");
INSERT INTO dov_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Amubone, mutumwa wa Leza wakalibonia kulinguwe, alimwi mumuni wakalibonia muntolongo. Wakawuma Pita kumwi kubbazu wamubusya akumwambila kuti, “Buka akufwambana nkabela makketani anzyakangidwe zyakazwa mumaboko. ");
INSERT INTO dov_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mungelo wakati kulinguwe, buka uliyabike, uzwate alimwi usame insangu zyako. Pita wakachita mbubo. Mungelo mbwakamba kuti zwata ijansi lyako unditobele. ");
INSERT INTO dov_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Aboobo Pita wakatobela mungelo akwinka awe aanze. Taakazibe pe kuti eecho chakachitwa amungelo chakali chakasimpe. Wakayeya anga ulikubona chilengano. ");
INSERT INTO dov_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nibakayinda amulindizi wantolongo mutanzi awabili, bakasika amulyango wabutale unjila mumunzi mpawo wakalijula awulikke. Bakabbuda aanze bakunuka amugwagwa nkabela mungelo wakamusiya mpawawo alikke. ");
INSERT INTO dov_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Awo Pita nakalibona lwakwe, wakabambila kuti, “Lino ndaziba kasimpe kuti mwami Leza watuma mungelo wakwe akundangununa kukuboko kwa Helodi akuli zyonse ba Juda nzibakali kulangilila. ");
INSERT INTO dov_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nakabona echi wakaya kung'anda ya Maliya banyina Johani uyitwa kutegwa Makki, oko bantu biingi nkubakabungene kabalo kukomba. ");
INSERT INTO dov_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nakakonkomona akkoma lyamulyango, musimbi, mulanda utegwa Loda wakasika kukuvwiila. ");
INSERT INTO dov_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nakaziba ijwi lya Pita, kwinda mukubotelwa, wakakachilwa kujula kkoma, kwinda kuti ajule mulyango, wakachijana kubweda mung'anda, wakwamba kuti Pita ulimvwi amulyango. ");
INSERT INTO dov_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mpawo bakati kulinguwe, “Wasuwigwa,” nikuba boobo wakakatila kuti mbubo mbundaamba. “Bakati mungelo wakwe.” ");
INSERT INTO dov_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pesi Pita wakinkilila anembo akukonkomona, alimwi nibakajula kkoma, bakamubona bakagamba. ");
INSERT INTO dov_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita wakatambika ijanza kukubawumuzya, mpawo wakatanguna kubalungunwida Mwami mbakamuwisya muntolongo. Wakati, “Amumwambile zintu ezi Jemusi abakwesu.” Mpawo wakazwa awo akuya kuli bumwi busena. ");
INSERT INTO dov_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lino nibwakacha, takwe nikuba kanini kakachizya akati kabasilumamba kuli zyakachitikene kuli Pita. ");
INSERT INTO dov_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helodi nakamana kumuyandula akutamubona, wakabuzya kuli basikulinda ntolongo akulayilila kuti bajayigwe. Wakakumuka kuzwa ku Judiya kaya ku Sizaliya mpawo wakakukkala nkuko. ");
INSERT INTO dov_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Lino Helodi wakanyemena loko bantu baku Taya a Sidoni. Bakayinka kulinguwe kabali amakanze omwe, nkabela kuzwa awo bakasungilizya Bbulasitasi, mugwasyi wamwami, kuti abagwasizye, bakakumbila lumuno nkambo inyika yabo chakulya cheyo chakali kuzwa kunyika yamwami. ");
INSERT INTO dov_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Mubuzuba bwakabambidwe Helodi wakasama chizwato chabwami mpawo wakakkala aachuno chabwami; wakamba achakubambila. ");
INSERT INTO dov_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bantu bakoompolola, “Eeli ndijwi lyakaleza pepe lyamuntu!” ");
INSERT INTO dov_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Achakufwambana munelo wamwami wakamuma, nkambo takapa bulemu pe kuli Leza; wakaligwa aziyokaansi elyo wakafwa. ");
INSERT INTO dov_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pesi ijwi lya Leza lyakayunizizigwa akuvula. ");
INSERT INTO dov_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Aboobo Bbanabbasi a Sawulu nibakamaninsya mulimu wabo bakabweda kuzwa ku Jelusalemu, amwi malembe achiindi awamba kuti bakabweeda ku Jelusalema bayinka a Joni uyitwa kuti Makki. ");
INSERT INTO dov_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Lino muchikombelo mu Antiyokki, kwakali bamwi basinsimi abayiisi,. Bakali Bbanabbasi, Simiyoni (utegwa Nayija), Lusiyasi waku Sayilini, Manayemi (mwananyina wa Helodi mu tetilaki) a Sawulo. ");
INSERT INTO dov_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nibakali kukomba Mwami Mwami akulyiimya kulya, Muuya Uusalala wakati, “Mundibambile bwanzeene Bbanabbasi a Sawulo, bachite mulimo oko nkundabayita.” ");
INSERT INTO dov_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nibakamana kulyiimya kulya, kukomba, akubika maboko aabalumi aaba, bakabatuma kuzwa. ");
INSERT INTO dov_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nkinkako Bbanabbasi a Sawulo, kabali batumwa kunze a Muuya Uusalala, bayinka aansi ku Selusiya; kuzwa oko bakayamba kuya ku Seyipulasi. ");
INSERT INTO dov_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nibakali mudolopo lya Salamasi, bakakambawuka ijwi Leza muzikombelo zyama Juuzi. Bakali a Joni Makki mbuli mugwasyi wabo. ");
INSERT INTO dov_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nibakamana kwenda kasuwa koonse kusikila ku Pafosi, bakajana umwi mwalumi simusamu, musinsimi mubeji wechi Juda, wakalezina lyakuti Bbaa Jizasi. ");
INSERT INTO dov_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Oyu siminsamu wakalijisini amwendelezi wachisi, Sejiyasi Pawulasi, oyo wakali mwalumi musongo loko. Oyu mwalumi wakapa mulandu kuli Bbanabbasi a Sawulo, nkambo wakali kuyanda kumvwa ijwi lya Leza. ");
INSERT INTO dov_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pesi Elimasi “simisamu” (obu mbombubo mbulyakali kutolelekelwa izina lyakwe) wakabakazya; wakeezya kusanduula nzila yabeendelezi bachisi kuzwa kululusyomo. ");
INSERT INTO dov_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pesi Sawulo, uutegwa Pawulo alimwi, kazwide Muuya Uusalala, wakamulangisisya kapati ");
INSERT INTO dov_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","akwamba kuti, “Iwee mwana satani, uzwide misyobo yoonse yalweno abulozi. Nduwe sinkondonyina wayoonse misyobo yabululami. Tokoyoleka pe kumonya inzila ziluleme zya Mwami, uyoleka na? ");
INSERT INTO dov_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kwaino boona, kuboko kwa Mwami kuli atala alinduwe, alimwi uyooba moofu. Tokoyobona izuba kwakayindi.” Mpawawo Elimasi wakawidwa sikunkwe amudima; nakatalika kwendeenda kuyanduula bantu kuti bamukwele kuboko. ");
INSERT INTO dov_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Musule akubona zyakachitika mweendelezi wachisi, wakasyoma, nkaambo wakagamba kukuyiisigwa aatala a Mwami. ");
INSERT INTO dov_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Lino Pawulo abeenzinyina bakatalika kuyamba kuzwa ku Pafosi akuza ku Pega mu Pamfuliya. Pesi Joni wakabasiya alimwi wabweeda ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pawulo abenzinyina bakeenda kuzwa ku Pega akusikila ku Antiyokki yaku Pisidiya. Oko bakanjila muchikombelo mubuzuba butegwa Sabata akukkala ansi. ");
INSERT INTO dov_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Musule akubalwa kwamulawu abasinsiimi, bazuluzi bechikombelo bakabatumina mulayizyo, kabati, “Nobakwesu, kuti kamujisi mulayiizyo wakusungwazya kubantu bali aano, amuwambe.” ");
INSERT INTO dov_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nkiinkako Pawulo wakimikila akuumuzya akuboko kwakwe; wakati, “Nobalumi bamu Izilayeli andinywe nimulemeka Leza, amumvwe. ");
INSERT INTO dov_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Leza wabantu aba ba Izilayeli wakasala bamataata akuchita bantu kuti bavule awo nibakakkede munyika ya Ijiputi, alimwi akuboko kunyampwidwe wakabazulwida kuzwa munyika njiyo. ");
INSERT INTO dov_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kwaminyaka ilimbuli makumi oone wakakkala ambabo munkanda mulusaka. Amwi malembe aansiku awamba boobu, kwamyaaka ilimbuli makumi one wakabalela mulusaka na loonde. ");
INSERT INTO dov_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Musule akujaya izisi zili musanu azibili munyika ya Kkenani, wakapa bantu besu inyika yabo kuti bakkone. ");
INSERT INTO dov_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Zyonse inchito ezi zyakachitika mumyaaka myanda yone amakumi musanu. Musule azintu zyonse ezi, Leza wakabapa babetesi mane kwazoba Samiyele musinsimi. ");
INSERT INTO dov_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mpawo bantu bakakumbila Mwami, alimwi Leza wakabapa Sawulo mwana wa Kkishi mulombe, mwalumi uzwa kumusyobo wa Bbenjamini, kuti aabe mwami kwamyaaka makumi one. ");
INSERT INTO dov_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Musule akuti Leza wamugwisya mubwami, wakanyampula Deviti kuti abe ngomwami wabo. Kwakali atala a Deviti mwana wa Jese mulombe kali mwalumi utobela moyo wangu, kuchita zyoonse nzyendiyanda kuti achite.' ");
INSERT INTO dov_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Kuzwa kulunyungu lwayooyu mwalumi Leza weeta mufutuli, Jesu, mbuli mbwakasyomezya kuyochita. ");
INSERT INTO dov_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kakutana kuba kuboola kwa Jesu, oyo Joni ngwakakambawuka atala alubbabbatizyo lwakulilesya kubantu boonse ba Izilayeli. ");
INSERT INTO dov_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Awo Joni nakali kumaninsya mulimo wakwe, wakati, 'Muyeeya kuti ndimeni? Teensi ndime oyo pe. Pesi muswilizye, nguumwi uza musule lyangu uuli aansapato zyakumawulu nzyesyeleli kumwangununa pe.' ");
INSERT INTO dov_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Nobakwesu, bana bamulongo wa Abbulahamu, abaabo bali mukati kenu balemeka Leza, zili kuli ndiswe kuti mulumbe walufutuko olu watumizigwa. ");
INSERT INTO dov_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nkaambo aabo bakkala mu Jelusalemu abazuluzi abasinsimi tebakamuziba pe, alimwi bakazuzikizya ayo majwi abasinsimi ayo abalwa mumasabata woonse akumuniaka. ");
INSERT INTO dov_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nikuba kuti tebakajana kaambo kamwelo wakujiigwa bakayita Pilato kuti amujaye. ");
INSERT INTO dov_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nibakamaninsya zyonse zintu zyakalembedwe atala anguwe, bakamuseluzya amunsamu akumulazika muchuumbwe. ");
INSERT INTO dov_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pesi Leza wakamubusya kuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Wakaboneka kwamazuba miingi ababo bakali baza awe kuzwa ku Galili kuya ku Jelusalemu. Aba bantu lino baba bakamboni bakwe kubantu. ");
INSERT INTO dov_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Nkiinkako tuli kumwambila makani mabotu, ichisyomezyo chakaza kumataata ");
INSERT INTO dov_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","watuzuzikizizya iswe, abana babo, mukubusya Jesu. Mbuli mbukulembedwe muli Ntembawuzyo: 'Uli mwana wangu mulombe, sunu ndaba Wuso.' ");
INSERT INTO dov_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Mukuti wakamubusya kuzwa kubafu tachibwedeli pe, Leza wakambuula muli eyi inzila: 'Ndiyomupa izisalala alimwi zyanchoonzyo zilongezyo zyakasyomezegwa kuli Deviti.' ");
INSERT INTO dov_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nkinkako nchawamba lubo muli imwi Intembawuzyo, 'Tokoyozumizya Musalalai wako pe kuti akabone kubola.' ");
INSERT INTO dov_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nkambo awo Daviti nakali wabelekela ziyandisyo zya Leza muzyalane lyakwe mwini, wakoona ing'onzi; wakalazikwa amwi awisi alimwi mubili wakwe wakamvwa kubola. ");
INSERT INTO dov_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pesi kuloyo ngwakabusya Leza takwepe nakamvwa kubola. ");
INSERT INTO dov_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nkinkako leka chizibinkane kuli ndinywe, bakwesu, kuti kwinda muli oyu mwalumi kuli kambawukidwe kuli ndinywe ilu lekelelo lwa zibi. ");
INSERT INTO dov_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kuli nguwe woonse muntu usyoma ulilulamikidwe kuzwa kuzintu zyonse ezyo mulawu wa Mozesi nziwakakachilwa kukululamika. ");
INSERT INTO dov_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Elyo nkinkaako mubone kuti chakaambwa abasinsimi tazichitiki pe kuli ndinywe. ");
INSERT INTO dov_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","'Amubone, nobadyamizi, alimwi mugambe alimwi mufwe mpawo: Nkambo ndili kweeta mulimo mumazuba eenu, imulimo ngomutakabule kusyoma pe, nikuba kuti umwi muntu wawambilizya kuli ndinywe.” ");
INSERT INTO dov_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Awo Pawulo a Bbanabbasi nibakeenda, bantu bakabakumbila kuti bazowambe lubo majwi nyayaayo musabata iitobela. ");
INSERT INTO dov_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Niwakamana muswangano wachikombelo, bwingi bwaba Juda abasikulipeda bakatobela Pawulo a Bbanabbasi, aabo bakambuula abo akubasungwazya kuti bayinkilile anumbo muluzyalo lwa Leza. ");
INSERT INTO dov_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Mubuzuba ibutegwa Sabata yakatobela, kubanga idolopo lyonse lyakali bungene antoomwe kuti bamvwe ijwi lya Mwami. ");
INSERT INTO dov_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Awo ba Juda nibakabona lubunga lwabantu, bakazula bbivwe akwambuula kabakazya zintu zyakaambwa a Pawulo akumutukila. ");
INSERT INTO dov_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pesi Pawulo a Bbanabbasi bakambuula chamanguzu kabti, “Kwakeelede kuti ijwi lya Leza kalyaambwa kusanguna kuli ndinywe. Mukubona kuti mula litabulula kuzwa kulindinywe akulibona kamuteeledwe buumi bulakujulu, amubone, tuyobweeda kuli basizibi. ");
INSERT INTO dov_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nkambo mbombubo mbatulayilila Mwami, wati, “Ndasala mbuli mumuni wabasizibi, kuti mweete lufutuko kumasena akunze anyika.” ");
INSERT INTO dov_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Awo basizibi nibakamvwa echi, bakabotelwa akusalazya ijwi lya Mwami. Mbuli biingi bakasalwa kubuumi bwakujulu bakasyoma. ");
INSERT INTO dov_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ijwi lya Mwami lyakendelezegwa muchengelelo choonse. ");
INSERT INTO dov_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pesi ba Juda bakeenena banakazi balipedelede kubwime bwajulu abalumi bazuluzi badolopo. Bakasungwaazya kusyonsegwa kwa Pawulo a Bbanabbasi akubagwisya muchenelelo chabo. ");
INSERT INTO dov_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pesi Pawulo a Bbanabbasi bakakunkumuna lusuko kuzwa kumawulu aabo mukukazyania ambabo. Mpawo bakaya kudolopo lyaku Ikkoniyamu. ");
INSERT INTO dov_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Alimwi basikwiiya bakazuzigwa alukondo alimwi a Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Izyakachitika mu Ikkkoniyamu Pawulu a Bbanabbasi bakanjila aamwi m uchikombelo chaba Juda bakambuula munzila eeyi yakuti makamu mapati aaba Juda aba Giliki bakasyoma. ");
INSERT INTO dov_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pesi ba Juda bakatalikuswilila bakanyongania mizeezo yamasi akubachita kuti banyemena bakwabo. ");
INSERT INTO dov_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Abobo bakakkala nkuko kwachindi chilamfu, kabawambula ijwi lya Lezaachaamba kabali anguzu zya Leza, kali kubapa bukamboni bwamakani aluzyalo lwakwe. Wakachita echi akubapa zitondezyo azigambyo mukwindila mumaboko a Pawulu a Bbanabbasi. ");
INSERT INTO dov_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pesi bantu bamunzi bakaanzana; bamwi bakayaama kuba Juda, pesi bamwi kuba tumwa. ");
INSERT INTO dov_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Antomwe bamasi aba Juda ( antomwe abazulwidi babo) bakeezya kutabajata obotu akubatulula mabwe, ");
INSERT INTO dov_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","pesi mbubakachibona eechi, bakachijila kumadolopo a Likkoniya amyunzi yaku Lisitiya a Debbe abusena buzyungulukide, ");
INSERT INTO dov_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","oko nkubakayinkilila anembo akukwambula makani mabotu. ");
INSERT INTO dov_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ku Lisitiya kwakali mwalumi wakakkede aansi, katakwe nguuzu kumawulu akwe, kali mulema kuzwa kukuzyalwa mwida lyabanyina, takwepe nakeendede. ");
INSERT INTO dov_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Oyu mwalumi wakamvwa Pawulu kawambula. Pawulu wakamulangisisya aboobo wakabona kuti uli aalusyomo lwakuti ukonzya kuponesegwa. ");
INSERT INTO dov_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Mpawo wakati kulinguwe ajwi pati, “yimikila amawulu ako.” Mpawo oyu mwalumi wakasotoka wendeenda. ");
INSERT INTO dov_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lino makamu makamu abantu nakabona Pawulu nzyakachita, bakoompolola, amajwi aabo, muchambuuzyo chaku Likkoniya, “Ba leza baza mbuli muntu mpawo baza kulindiswe.” ");
INSERT INTO dov_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Eelyo Bbanabbasi bakamuzika izina lyakuti ngu “Zewusi,” alimwi Pawulu bakamuti ngu “Hemesi,” nkambo nguwe wakali mukambawusi mupati. ");
INSERT INTO dov_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Mupayizi waku Zewusi, wakali aa chikombelo chakali aanze amunzi, wakayeta musune atununkilizyo kumilyango; lwakwe amakamu makamu balikuyanda kupayila. ");
INSERT INTO dov_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pesi kwaino batumwa ba Bbanabbasi a Pawulu, nibakazimvwa, bakadelula zizwato zyabo mpawo bakayinka chakufwambana mukati amakamu, bakakalala kuti, ");
INSERT INTO dov_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Nobantu, nkambonzi nimulikuchita eezi? Aswebo tulibantu bali achimo mbuli ndinywe. Tuli kumukambawukila makani mabotu kuti muzwe muzintu zitagwasyi muze kuli Leza upona, iwakalenga majulu, inyika, lwizi, azyonse zili mukati. ");
INSERT INTO dov_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Muzyiindi zyakayinda, wakazuminina zisi zyonse kwenda munzila zyabo. ");
INSERT INTO dov_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pesi mbubonya, we takaliside katakwe bukamboni, muzibotu zyonse nzyakamuchitila zibotu kumupa mvula kuzwa kujulu amichelo zyiindi zyonse, akuzuzya myoyo yanu azilyo, alukondo.” ");
INSERT INTO dov_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nikuba amajwi aya, Pawulu a Bbanabbasi bakakasya makamu abantu kuti kabachipayila kulimbabo. ");
INSERT INTO dov_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pesi bamwi baJuda baku Antiyokkiya aku Ikkoniya bakaza kuzosungilizya makamu makamu. Bakatulula Pawulu akumukwelela anze amunzi, bakayeeya anga wafwa. ");
INSERT INTO dov_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Aboobo basikwiya bakali muzyungulukide, wakabuka akunjila mumunzi. Izuba litobela, wakayinka ku Debbe aamwi a Bbanabbasi. ");
INSERT INTO dov_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Nibakamana kwambula makani mabotu kuli ooyo munzi akuchita abasikwiiya biingi, bakabweda ku Lisitila, aku Ikkoniyamu, alimwi aku Antiyokki. ");
INSERT INTO dov_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bakayinkilila kunembo akusimya myuuya yabasikwiya akubasungwazya kuti bayimikile mulusyomo, kabambakuti, “Twelede kunjila mubwami bwa Leza kwindila mumachise amakatazyo miingi.” ");
INSERT INTO dov_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nibakabasalila bapati mumbungano zyonse, akukomba akulyimya kulya antomwe ambabo, bakabasyoma ku Mwami oyo ngubakali kusyoma. ");
INSERT INTO dov_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mpawo bakayinda mu Pisidiya akuyosika ku Pamfuliya. ");
INSERT INTO dov_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nibakamba ijwi mu Pega, bakakunukila ku Ataliya. ");
INSERT INTO dov_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kuzwa oko bakazubukila ku Antiyokki oko nkubakapedekezedwe luzyalo lwa Leza nkambo kamulimu ngubakamaninsya. ");
INSERT INTO dov_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nibakasika ku Antiyokki bakasbungania imbungano antomwe, bakatalika kupandulula zintu zyonse Leza nzyakachita ambabo, ambwakajulila bamasi mulyango walusyomo. ");
INSERT INTO dov_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mpawo bakakkala chiindi chilamfu abasikwiiya. ");
INSERT INTO dov_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bamwi balumi bakakunuka kuzwa ku Judiya kabaya ku Antiyokki kabayiisya basyomi kabaamba kuti, “Na temwapalulwa mbuli mbuuwamba mulawu wa Mozesi tamukonzyi pe kufutulwa.” ");
INSERT INTO dov_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Echi chakachita kuti Pawulu a Bbanabbasi abalumi aaba bakazyanie kapati akubonesyania. Nkabela Pawulu a Bbanabbasi, antoomwe abamwi akati kabo, bakatumwa ku Jelusalema kuti bakaswanane aba Tumwa abaalu bambungano akubuzya atala ankani eeyi. ");
INSERT INTO dov_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nobakatumwa ambungano bakayinda ku Foyenisiya amu Samaliya kabaya bulungulula kusanduka kwabamaasi bakeeta lukoondo lupati. ");
INSERT INTO dov_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nibakasika mu Jelusalemu, bakatambulwa ambunga abatumwa antomwe abaalu bembungano, mpawo bakalungulula zintu zyoonse Leza nzyaakachita kwinda mulimbabo. ");
INSERT INTO dov_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pesi bamwi bakasyoma, kabali bankamu yaba Falisi, bakanyampuka bati, “Nchintu chipati loko kuti: tubapalule akubalayilila kuti babambe mulawu wa Mozesi,” ");
INSERT INTO dov_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nkinkaako batumwa aabalu bembungano bakabungana antomwe akuzilikila kuti ngakulachitwa biyeni ankani eeyi. ");
INSERT INTO dov_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nikwakayinda kayinda chindi chilamfuchakubonesyania atala enkani eeyi, Pita wakanyampuka wasikuti kulimbaabo, “Nobenzuma, mulizi kuti kuchiindi chainda Leza wakandisala akati kenu kuti akukambawuka kwangu bamaasi balimvwe ijwi lyamakani mabotu mpawo basyome ");
INSERT INTO dov_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Leza uuzi moyo, wakapa bukamboni kulimbabo mukubapa Muuya Uusalala, mbuli mbwakachita kulindiswe. ");
INSERT INTO dov_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tachitide musiyano pe akati kesu ambabo, mukusalazya myoyo yabo kwiinda mulusyomo. ");
INSERT INTO dov_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nkambonzi nimusunka Leza, akubika jokwe munsingo zyabasikwiiya eelyo bamatata nikuba ndiswe nditutakonzyi kulibweza. ");
INSERT INTO dov_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pesi tulasyoma kuti tuyofutulwa mukwinda muluzyalo lwa Mwami Jesu, mbuli mbubakafutulwa,” ");
INSERT INTO dov_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bantu boonse bakawumuna akuswilizya ba Bbanabbasi a Pawulu kabalokulungununa zitondezyo azigambyo Leza nzyakabeleka akati kabamaasi kwinda mulimbabo. ");
INSERT INTO dov_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nibakamaninsya kwambuula, Jemusi wakasandula kuti, “Nobenzuma, ngamundiswilizye. ");
INSERT INTO dov_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sayimoni walungulula Leza mbwakagwasya muluzyalo lwakwe bamaasi kuti alichitile bantu bakwe kuzina lyakwe; ");
INSERT INTO dov_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Majwi abasinsimi alazuminana anzizyo eezi, mbuuli mbukulembedwe, ");
INSERT INTO dov_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","'Kwainda zintu eezi Ndiyoobola, alimwi ndiyoyakulula chikombelo cha Devidi, eecho chakamwayika; ndiyoyakulula akubusya lubo matongo acho, ");
INSERT INTO dov_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","kuchitila kuti balobosi babantu bakonzye kulanguula Mwami, antoomwe abamaasi boonse bayitwa kuzina lyangu.” ");
INSERT INTO dov_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Mbuboobu Mwami mbwaamba, ooyo wakachita zintu ezi zyakazibinkana kuzwa muzyiindi zyakale. ( kuli magwalo aba Giliki achiindi alabupanduluzi busiyen, mubunini, mbubobu Mwami mbwaamba, aabo bazi zyoonse nzyakachita kuzwa kuchiindi chakale. ");
INSERT INTO dov_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nkiinkako, muyeyo wangu ngwakuti, tutabakatazyi pe bamaasi aba basandukila kuli Leza; ");
INSERT INTO dov_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Pesi tuyobalembela kuti beelede kusosoloka kuzwa kukulininania amituni, kuzwa kubusofwazi kulizyamalalane, akukulyanyama yabanyama bafwa akulidinwa, akuzwa bulowa. ");
INSERT INTO dov_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nkambo Mozesi wakakambawukwa mumadolopo mapati oonse: kuzwa kumazyalane akale nkabela uchikambawukwa amuzikombelo mazuba oonse ategwa Sabata. ");
INSERT INTO dov_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Aboobo batumwa, abalu bambungano, antomwe ambungano yoonse, bakabona kuti nchibotu kuti basale Judasi uutegwa Bbasabbasi a Sayilasi, abo bakali bazulwidi baabamwi, kuti babatume ku Antiyokki antomwe a Pawulu a Bbanabbasi, ");
INSERT INTO dov_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bakalemba eezi: “Ibatumwa, bazuluzi ababunyiina, kulibamaasi abalimu Antiyokki, Siliya akuSilisiya, Twamujuzya. ");
INSERT INTO dov_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nkambo twakamvwa kuti bamwi baalumi bakazwa akati kesu, kabatakwe malayilile kuzwa kuli ndiswe, aboobo bamunyongania amabala aayo atyola myuuya yanu, ");
INSERT INTO dov_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Zyakatubotela iswe, nitwakalanzyania akuzuminana, kusala balumi akubatuma kulindinywe antoomwe abayandwi kulindiswe ba Bbanabbasi a Pawulu, ");
INSERT INTO dov_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Baalumi bakaaba buumi bwabo kuntenda nkambo kazina lya-Mwami Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nkinkko twatuma Judasi a Sayilasi, abo batamwambile zintu nzizyo eezyo amajwi abo. ");
INSERT INTO dov_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nkaambo kwakabotela Muuya Uusalala andiswe, Kuti tutamulemezyi mukuli atala azintu zitakwe lugwasyo, ");
INSERT INTO dov_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kuti mulikasye kuzintu zipayilwa kumituni, bulowa, akuzintu zitanoli zyakafwa akusinwa akubusofwazi bwamalalano na mwalibamba kuzwa kuli zeezi zilamubotela muchale kabotu.” ");
INSERT INTO dov_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Lino nibakasungulwa, bakakunukila ku Antiyokki; nibakabunganisya makamu abantu boonse, bakasisya lugwalo. ");
INSERT INTO dov_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nibakamana kubala lugwalo bakabotelwa nkambo kakusungwazigwa. ");
INSERT INTO dov_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judasi a Sayilasi, alimwi abasinsiimi bakabasungwazya babunyina amajwi akubasimya. ");
INSERT INTO dov_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Eelyo nibakakkala chiindi chinini nkuko oko, baka bwedezegwa kuzwa kulibakwabo abo bakabatumide muluumuno. ");
INSERT INTO dov_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Magwalo mabotu achiindi takwe minchali pe awa 34. ( langa Nchito 15: 40) Pesi kwakaboneka kuti nchibotu kuti Sayilasi achaale nkuko. ");
INSERT INTO dov_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pesi Pawulu a Bbanabbasi bakakkala ku Antiyokki, kabalikuyiisya akukambawuka ( antomwe abamwi biingi) Ijwi lya Mwami. ");
INSERT INTO dov_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nikwakayinda mazuba Pawulu wakati kuli Bbanabbasi, “Ngatubweede lino tukaswaye bakwesu mumadolopo woonse omo mutwaakambilizya ijwi lya Mwami, akubona kuti balibiyeni. ");
INSERT INTO dov_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bbanabbasi wakalikuyanda kuti beende amwi a Joni wakalikutegwa ngu Makki. ");
INSERT INTO dov_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pesi Pawulu wakayeeya kuti takuli kubotu kuti babweze Makki, ooyo wakabalobokede mu Pamfuliya akuleka kwendelela kunembo ambabo amulimu. ");
INSERT INTO dov_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Lino mpawawo kwakaba kukazyania kupati, kwakachitika kutibapambukane kuzwa kuli umwi awumwi, mpawo Bbanabbasi wakabweza Makki, bayamba binkamwi mubwaato bayaku Sayipulasi. ");
INSERT INTO dov_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pesi Pawulu wakasala kupedekezegwa kuluzyalo lwaMwami ababunyiina. ");
INSERT INTO dov_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Mpawo wakeenda akwiinda mu Siliya aku Silisiya kabali kusimya mambungaano. ");
INSERT INTO dov_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pawulo wakasika alimwi ku Debbe aku Lisitila, aboobo, umwi mutobeli uutegwa Timoti wakaliwo, imwana wamukayintu muJuda iwakali musyomi, pesi wisi wakali muGiliki. ");
INSERT INTO dov_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Wakali ampuwo mbotu kulibakwabo ibakali ku Lisitila aku Ikkoniyamu. ");
INSERT INTO dov_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pawulo wakali kuyanda kweenda anguwe; nkinkaako wakamubweza wamupalula kaambo kaba Juda bakali mumasena aayo, nkambo kakuti boonse bakalizizi kuti wisi mu Giliki. ");
INSERT INTO dov_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Awo nibakayobweenda lwendo lwabo mumadolopo, bakayobupa imajwi kubatumwa abapati ibakali mu Jelusalema ikuti balilemeke. ");
INSERT INTO dov_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Awo imbungano zyakasimisigwa mu mweelwe ibuzuba abuzuba. ");
INSERT INTO dov_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pawulo abasindikizi bakwe bakayinda kumasena a Pilijiya a Galantiya, mbuli kuti bakali babindwa aMuuya Uusalala kuti bakambauke ijwi mubusena bwa Eziya. ");
INSERT INTO dov_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nibakasika afwifwi Misiya, bakeezya kunjila mu Bbitiniya, pesi imuuya wa Jesu wakabakasya. ");
INSERT INTO dov_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Awo nibakayinda Misiya, bakakusika kudolopo lya Tulowasi. ");
INSERT INTO dov_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ichilengano chakaboneka kuli Pawulo imansiku; imwalumi waku Mesodoniya wakalimvwi mpawawo, kalikumukkumbila akwamba kuti, “kweza ku Mesodoniya uzotugwasye,” ");
INSERT INTO dov_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","awo Pawulo nakabona chilengano, mpawawo twakabambilila kuyaku Mesodoniya, akuzumina kuti Leza nguwatwiita kuti tukakambauke ijwi kuli mbabo. ");
INSERT INTO dov_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Akutalika kuyamba kuzwa ku Trowasi, twakeendela limwi kululama ku Samotilasi, aboobo mubuzuba butobela twakasika ku Neyopolisi. ");
INSERT INTO dov_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kuzwaawo twakaya ku Filipi, kalili dolopo lyaku Mesodoniya, idolopo lyabulemu mubboma akubwendeleezi bwa Loma, aboobo twakakkala mazuba miingi mudolopo eeli. ");
INSERT INTO dov_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","mubuzuba bwamugibelo twakazwa aanze aakkoma lyakubbazu lyamulonga, oko nkutwakayeya kuti kuli busena bwakukombela. Twakakkala aansi twambuula abakaintu bakabungene. ");
INSERT INTO dov_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Umwi mwanakazi walikutegwa Lidiya, wakalikusambala zisamo zyamubala wantumbula, iwakali kukomba Mwami, wakatuswilila. Leza wakajula moyo wakwe kuti aswilizye loko nzyakali kwamba Pawulo. ");
INSERT INTO dov_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Aawo naka bbabbatizigwa antoomwe abempuli yakwe, wakatukombelazya, wakamba kuti, “kuti mwandibona kuti ndilasyoma kuli Leza, amuze mukakkale kunganda yangu.” Alimwi wakatukombelezya. ");
INSERT INTO dov_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mbuzyakaba, aawo nitwakali kuya kubusena bwakukukombela, umwi musimbi muzike iwakali aamuya wabusondi wakatuwondongania. Wakapa basimalelo bakwe impindu kuzwa kubusondi bwakwe. ");
INSERT INTO dov_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Oyu mukaintu wakatobelela Pawulo andiswe kali koompolola, wakati, “Aaba balumi mbabelesi ba Leza wabulemu. Bali kumukambawukila ijwi lyalufutuko.” ");
INSERT INTO dov_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wakachita mbuboobu kwamazuba miingi. Pesi Pawulo, nakamunyemya loko, wakacheba akwambila muuya oyu wakati, “Ndili kukwambila muzina lya Jesu Kilisito kuti uzwe mumukayintu oyu.” Aboobo imuuya wakazwa muchiindi nchichecho. ");
INSERT INTO dov_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Aawo basimalelo bakwe nibakabona kuti imweenya wabo wakujana mpindu wagola, bakajata Pawulo a Sayilasi akubakwelela kuli basimulawu muchisambalilo. ");
INSERT INTO dov_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nibakabeeta kuli Sikubeteka, bakati, “Aaba baalumi balikupenzya idolopo lyesu, mba Juda. ");
INSERT INTO dov_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bakambawuka milawu itazumininwi kuti ba Looma batambule akuchita mbubo.” ");
INSERT INTO dov_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Aawo iluundu loonse lwakanyampuka akutongooka aatala a Pawulo a Sayilasi, imubetesi wakadelula akubazwatununa zisamo akwambilizya kuti bawumwe amilamu. ");
INSERT INTO dov_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nibakamana kubabuduula, bakabawalila muntolongo akwambila simulinda ntolongo kuti abalinde tabazwi. ");
INSERT INTO dov_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Musule akapegwa mulawo oyu, simulinda ntolongo wakabajalila mukaanda kamukati loko kabasungidwe misungo kumawulu. ");
INSERT INTO dov_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Aakati kabusiku Pawulu a Sayilasi bakalikukomba akwimbila Leza, awo bamwi basungwa bakali kubaswilizya. ");
INSERT INTO dov_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Muchiindi chifwifwi kwakaba muzuzumo wanyika, ezi zyakazunganisya intolongo; mpawo imilyango yakajuka, alimwi imisungo yanketani yakanguunuka kuli umwi awumwi. ");
INSERT INTO dov_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Simulinda ntolongo wakasinsimuka akubona milyango yantolongo kayaseeme; wakabweza ipanga lyakwe (Ifulo) lyakwe akuyanda kulijaya, nkaambo wakayeeya kuti basungwa boonse bachija. ");
INSERT INTO dov_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pesi Pawulo wakatambwizya ajwi pati, wakati, “utalinyonyoni, nkambo toonse mputuli.” ");
INSERT INTO dov_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Simulinda ntolongo wakayasya malampi akunjila mukati, kateketa akuyowa, wakawidaansi kunembo lya Pawulo a Sayilasi. ");
INSERT INTO dov_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wakabeeta aanze akwamba kuti, “Nobapati, ndichite biyeni kuti ndifutulwe?” ");
INSERT INTO dov_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bakaamba kuti, “syoma kuMwami Jeso, ulafutulwa. iwebo ampuli yako.” ");
INSERT INTO dov_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bakamwambila ijwi lya Mwami, antoomwe aboonse bempuli yakwe. ");
INSERT INTO dov_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Awo simulinda ntolongo wakabweza boonse busiku oobo, wabasanzya zilonda, alimwi wakabbabbatizigwa aboonse bempuli yakwe mpawawo. ");
INSERT INTO dov_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Nakeeta Pawulo a Sayilasi munganda yakwe akubapa ichakulya, wakabotelwa kapati ampuli yakwe yoonse, nkambo wakali wasyoma kuli Leza. ");
INSERT INTO dov_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nibwakacha, imubetesi wakatuma ijwi kuli basikulinda, wakati, “Amubaleke baalumi abo bayinke.” ");
INSERT INTO dov_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Simulinda ntolongo wakambila Pawulo, wakati; imubetesi walayizya kuti ndimulekezye mwende nkokuti amuzwe lino, mweende mulumuuno.” ");
INSERT INTO dov_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pesi Pawulo wakabambila kuti; “Batuuma kunembo lyabantu kabatatubetekede, nikuba kuti tuzwa ku Looma - alimwi batubika muntolongo. Lino bayanda kutugwisya chakusisikizya na: Pepe. Aabaze mbabo bazotwaangunune. ");
INSERT INTO dov_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Basimulinda ntolongo bakasisya majwi ayaa kubabetesi, nibakamvwa kuti Pawulo a Sayilasi mba Loma bakayoowa. ");
INSERT INTO dov_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bakasika ibabetesi akukkumbila lulekelelo kuliba Pawulo a Sayilasi akubagwisya aanze, akubakumbila kuti bazwe mudolopo eeli. ");
INSERT INTO dov_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pawulo a Sayilasi bakazwa muntolongo akuya kunganda ya Lidiya. Aawo Pawulo a Sayilasi nibakabona babunyina, bakabasungwazya alimwi bakazwa mudolopo eeli. ");
INSERT INTO dov_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lino chiindi nobakiinda mumyuunzi yaku Amfipolisi a Apoloniya, bakasika kumunzi waku Tesalonika, ooko kwakali chikombelo chaba Juda. ");
INSERT INTO dov_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pawulu, mbubonya mbulichimbo chakwe, wakiinka kulimbabo alimwi kwamazuba aama Sabata aatatu wakambilaana aabo kuzwa mumalembe. ");
INSERT INTO dov_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Wakali kujula malembe akupandulula kuti chakalelede kuti Kkilisito aapenge akubuka lubo kuzwa kulufu. Wakwamba kuti, “Jesu ooyo ngundiluula kulindinywe ngu Kkilisito.” ");
INSERT INTO dov_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Bamwi babaJuda bakakombelezegwa eelyo bakajatana a Pawulu a Sayilasi kubikilizya mweelwe muunji waba Giliki balipeda, abuzuluzi bwabanakazi bayingi. ");
INSERT INTO dov_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pesi baJuda ibatasyomi, bakali abbivwe, bakabweza bamwi bantu bamineme kuzwa kuchisambalilo, bakabungania makamu aantomwe, akubika muunzi mumbukila. kubusizya kung'anda ya Jasoni, bakali kuyandula ikuhusya Pawulu a Sayilasi aanze kuti aaye kubantu. ");
INSERT INTO dov_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pesi awo nebatakwe nobakabajana, bakakwela Jasoni abamwi bakwabo kunembo lyaba singuzu bamumuunzi, bakalilila kuti aaba bantu bakasandamwida nyika aansi alubo basika ookuno lubo. ");
INSERT INTO dov_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Aaba baalumi Jasoni mbakatambula bakazyania aamulawo wa-Siza, bamba kuti, “Kulumbi Mwami Jesu.” ");
INSERT INTO dov_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Bakatazya makamu abasinguzu, bamuunzi bakamvwa zintu eezi. ");
INSERT INTO dov_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pesi mukwinda kwakujana kukwabililwa kuzwa kuli Jasoni akuliboonse, bakabazumizya kwiinka. ");
INSERT INTO dov_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Busiku oobo bakwabo bakatuma Pawulu a Sayilasi kuBbeliya. Nobakasika nkuko, bakayinka muchikombelo chaba Juda. ");
INSERT INTO dov_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Lino bantu aaba bakaliluleeme kwinda aabo bamu Tesalonika, nkambo bakatambula ijwi amizeezo ilipedelede, kulingulula malembe buzuba abuzuba kuti babone na zintu eezi zyakali mbubo. ");
INSERT INTO dov_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Nkinkaako biingi babo bakasyooma, kubikilizya abamwi banakazi bayuungi ba Giliki abalumi biingi. ");
INSERT INTO dov_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pesi chiindi ba Juda baku Tesalonika nibakaziba kuti alubo Pawulu wakali kuluula jwi lya Leza ku Bbeliya, bakiinka nkuko akunyongania akukataazya makamu. ");
INSERT INTO dov_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mpawawo, bakwabo bakatumina Pawulu kuya kulwizi, pesi Sayilasi a Timoti bakakkala nkuko. ");
INSERT INTO dov_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Aabo bakali kweenzya Pawulu bakamubweza bamutola kule kuluumbi munzi waku Atenisi. Mbubonya mbakamusiya Pawulu nkuko, bakatambula malayilile kuzwa kulinguwe kuti Sayilasi a Timoti basike chakufwambana mbuli mbubakonzya. ");
INSERT INTO dov_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Lino mbubonya Pawulu mbwakali kubalinda mu Atenisi, muuya wakwe wakanyemezegwa mukati kawke aawo nakabona muunzi uzwide zikozyano. ");
INSERT INTO dov_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Eelyo mazuba woonse wakambilaana abaJuda abamwi bakali kukomba Leza mbonya amuchisambalilo kuba nkuko. ");
INSERT INTO dov_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pesi abalabo bamwi baba Epikuliya abasongo ba Sitoyiki bakaswanana aawe. Bamwi bakaamba kuti, “Niinzi ooyu utakwe makani ncheezya kwaamba?” Bamwi bakati, “Ulangika aanga nguumwi ooyo wwiita bantu kuti batobela baleza benzu, nkambo wakali kuluula makani mabotu aatala a Jesu abubuke. ");
INSERT INTO dov_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Bakabweza Pawulu akumuleta ku Aliyopagasi, bakati, “Ngatulaziba eeyi njiisyo mpyaa eyo njowakali kwaamba? ");
INSERT INTO dov_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nkaambo ulikweta zintu zyeenzu kumatwi eesu. Nkinkaako, tuyanda kuziba kuti eezi zyambanzi.” ");
INSERT INTO dov_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Lino ba Atenisi aabenzu bakali kukkala nkuko bakamaninsya chiindi chabo kakutakwe anchibachita pesi kwambuula nikuba kuswilila atala achimwi chipya.) ");
INSERT INTO dov_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mpawo Pawulu wakima aakati kaba Aliyopagasi akwaamba kuti, “Yobalumi baku Atenisi, ndabona kuti muli basichizuminano munzila yoonse. ");
INSERT INTO dov_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nkambo mbubonya mbundayinda akulanga loko kuzintu zyabukombe bwanu, ndajana chipayililo chili abulemu oobu, “Kuli Leza utazibinkene.” kufumbwa nchimukomba mukutaziba, eechi ndachaambilizya kuli ndinywe. ");
INSERT INTO dov_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Leza wakachita nyika azyoonse zilimulinjiyo, mbwanga ngu Mwami wajulu anyika, takkali mumaanda ayaakwa amaboko. ");
INSERT INTO dov_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nikuba kubelekelwa amaboko abantu, mbuli kunga ubulide chintu, mbwaanga lwakwe nguupa bantu buumi akuyooya azimwi zyonse. ");
INSERT INTO dov_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kuzwa kumuntu uumwi wakachita misyobo yabantu kuti bapone aatala enyika kali wabamba kuzulila kwazyiindi amigano yamasena aabo mubakkede, ");
INSERT INTO dov_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Kuchitila kuti balanguule Leza akuti ambweni ngabalakonzya kuzuzya nzila yabo nkambo kanguwe akumujana pesi talikule pe kuzwa kuluumwi wesu. ");
INSERT INTO dov_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Nkaambo mulinguwe tulapona akweenda akujana buumi, mbubonya mbuli bamwi, simwanza ngano banu mbubakaamba, 'Nkambo alubo tuli lunyungu lwakwe.' ");
INSERT INTO dov_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nkinkaako, mbokunga tulilunyungu lwa Leza, tatwelede kuyeeya anga bubotu bwabulenge bulakozyanisigwa angolida niiba nsiliva, niliba bbwe, izikozyano zyakabezwa amiyeeyo yamuntu. ");
INSERT INTO dov_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nkinkaako Leza wakazileka zyiindi zyakutaziba, pesi lino ulayilila bantu boonse koonse koonse kuti basanduke. ");
INSERT INTO dov_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nkambo wakabamba buzuba nayobetaeka nyika mubululami kumuntu ngwakasala. Leza wakapa chisinizyo chamuntu ooyu kuli woonse akumubusya kuzwa kubafu.” ");
INSERT INTO dov_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Lino chiindi bantu baku Atenisi nobakamvwa azyabubuke wabafu, bamwi bakamuniaka Pawulu; pesi bamwi bakati, “Tuyokuswilila lubo aatala ankani eeyi.” ");
INSERT INTO dov_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kuzwa waawo, Pawulu wakabasiya. ");
INSERT INTO dov_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pesi bamwi bakasyoma, kubikilizya a Diyonisiyasi mu Aliyopegiti, mwanakazi utegwa Damalisi, abamwi bakalaambabo. ");
INSERT INTO dov_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Musule azeezi zintu Pawulu wakazwa mu Atenisi akuya ku Kkolinto. ");
INSERT INTO dov_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ooko wakakuswanana amu-Juda uutegwa Akkwila, wachisi cha Pontasi, ooyo wakachili kusika kuzwa ku Itali amukaintu wakwe Pulisila, nkambo Kkilawudiyasi wakali walayilila ba Juda boonse kuti bazwe mu Loma. Pawulu wakayinka kuli mbaabo, ");
INSERT INTO dov_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","alimwi nkambo kakuti wakali kubeleka nguyooyo mulimu, wakakkala ambaabo wabeleka, nkaambo bakali basimupanga mateente kuluzibo. ");
INSERT INTO dov_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Aboobo Pawulu wakayiizya muchikombelo ambaabo mazuba woonse ateegwa sabata, kayezya kukombelezya ba Juda aba Giliki. ");
INSERT INTO dov_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Lino Sayilasi a Timoti nibakasika sika saansi kuzwa ku Masedoniya, Pawulu wakalipeda kujwi, kapa bukamboni kuba Juda kuti Jesu ngonguwe Kkilisito. ");
INSERT INTO dov_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pesi aawo ba Juda nibakamusandukila akumutukila, Pawulu wakabangundumwida zisamo zyakwe akubaambila kuti, “Bulowa bwanu abube aatala amitwe yanu; ime ndasalala. Kuzwa lino ndilaya kulibamaasi.” ");
INSERT INTO dov_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mpawo wakanyampuka kuzwa ooko akuya kun'anda ya Tayitasi Jasitasi, mwalumi wali kukomba Leza. Ing'anda yakwe yakali afwifwi achikombelo. ");
INSERT INTO dov_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kkilisipasi, muzuluzi wachikombelo wakali kusyoma ku Mwami, antomwe ampuli yakwe bakasyoma mu Mwami. Abanamunji baku Kkolinto ibakamvwa ijwi bakasyoma alimwi bakabbabbatizigwa. ");
INSERT INTO dov_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mansiku Mwami wakati kuli Pawulu muchilengano, “Utayowi, pesi wambula utawumuni. ");
INSERT INTO dov_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nkambo ndili anduwe, aboobo takwe utakeezye kukunyonyona nkambo ndili abantu biingi mumunzi ooyu. ");
INSERT INTO dov_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pawulu wakakkala oono kwamwaaka amyeezi musanu awumwi, kayiisyanijwi lya-Leza mukati kabo. ");
INSERT INTO dov_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pesi aawo Galiyo naakaba mweendelezi mupati waku Akkayiya, ba Juda bakajatana amuzezo omwe wakusandukila Pawulu akumweeta kubbetekelo; ");
INSERT INTO dov_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","bakaamba kuti, “Ooyu mwalumi uli kukombelezya bantu kuti bakkombe Leza zitali mumulawu.” ");
INSERT INTO dov_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Anu aawo Pawulu nakasyambuule, Galiyo wakati kuba Juda, “Inywe noba Juda, aanoli nchoonzyo bwakali bulewusi na mulandu, chali kunooli kabotu kulangana andinywe. ");
INSERT INTO dov_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pesi mbuli kuti eeyi mibuzyo ilangene amabala amazina amilawu yenu nubeni, amuzibambe ndinywe lwenu. Tandilangilili kuba mubelesi wazyaambo ezi pe.” ");
INSERT INTO dov_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Galiyo wakachita kuti bazwe mubbetekelo. ");
INSERT INTO dov_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Aboobo boonse bakajata Sositenesi, mutongi wa chikkombelo, akumuuma kunembo lyachuno chabbetekelo. Pesi Galiyo taakwe mbakalimvwa kuli eezyo nzibakachita. ");
INSERT INTO dov_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pawulu, musule lyakukkala omo aambi mazuba, wakabasiya bakwabo akuyamba kuyaku Siliya a Pulisila a Akkwila. Katana kuzwa kujinkiilo, Senkiliya, wakali wagonkwa susu akaambo kachizuminano nchakali wachita. ");
INSERT INTO dov_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nibakasika ku Efesasi, Pawulu wakasiya Pulisila aa Akkwila nkukooko, pesi we lwakwe wakanjila muchikombelo akwambuzyania aba Juda. ");
INSERT INTO dov_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Aawo nibamukkumbila Pawulu kuti akkale chiindi chilamfu, wakakkaka. ");
INSERT INTO dov_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pesi nakazwa aalimbabo, wakati, “kuti kakuli kuyanda kwa Leza ndilaboola kuli ndinywe.” Mpawo wakayamba kuzwa ku Efeso. ");
INSERT INTO dov_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pawulu nakasika ku Sizaliya, wakatanta akuyojuzya imbungano yaku Jelusalema alimwi wakaselela waya ku Antiyokki. ");
INSERT INTO dov_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Musule lyakukkala kwechindi chilamfu lamfu nkukooko, Pawulu wakeenda kayinda mumasena aku Galantiya a Pilijiya akusimya basikwiiya boonse. ");
INSERT INTO dov_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Lino umwi mu Juda uutegwa Apolosi, imwana wa Alekizanda kukuzyalwa, wakasika ku Efeso. Wakali kumvwikka kabotu kukukwambuula alimwi kajisi luzibo lwiingi lupati kumalembe. ");
INSERT INTO dov_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apolosi wakali walayilwa kunjiisyo ya Mwaami. Mukubaanguzu zya Muuya, Wakaambuula akuyiisya chakululamika ezyo zintu zyakalangene a Jesu, pesi wakazi biyo ilubbabbatizyo lwa Joni. ");
INSERT INTO dov_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolosi wakatalika kwambuula changuzu muchikombelo. Pesi nibakamumvwa ba Pulisila a Akkwila, bakamutola kumbali akumupandulwida inzila ya Leza mubunike. ");
INSERT INTO dov_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nakayeeya kuyamu Akkayiya, ibakwabo bakamusungwazya alimwi bakalembela basikwiiya baku Akkayiya kuti bamutambule. Nakasika, wakabagwasya loko aabo bakasyoma muluzyalo. ");
INSERT INTO dov_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolosi wakabakazya changuzu ba Juda munkazyanio yaluundu, kali kutondeezya kwiindilila mumalembe kuti Jesu ngonguwe Kkilisito ");
INSERT INTO dov_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kwakaba kuti Apolosi nakali mu Kkolinto, Pawulo wakayinda kuchisi chakutala wakusika kudolopo lyaku Efeso, mpawo wakakujana bamwi basikwiiya. ");
INSERT INTO dov_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pawulu wakabambila kuti, “Mwakawutambula na Muuya Uusalala nimwakasyoma?” Bakamusandula kuti, “Pepe, tatukwe anchitwalina kumvwa pe atala azya Muuya Uusalala.” ");
INSERT INTO dov_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pawulu wakati, “Mpo mwakabbabbatizigwa buyeni? Bakati, “Mulubbabbatizyo lwa-Joni.” ");
INSERT INTO dov_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pawulo wakabasandula, “Joni wakabbabbatizya mulubbabbatizyo lwakusanduka. Wakabambila bantu kuti bayelede kusyoma kulooyo uzobuza musule lyakwe, kali, ngu Jesu.” ");
INSERT INTO dov_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Lino bantu nibakamvwa obu, bakabbabbatizigwa muzina lya-Mwami Jesu. ");
INSERT INTO dov_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pawulo nakabika maanza aakwe alimbabo, Muuya Uusalala wakaza alimbabo alimwi bakambuula muliimwi milaka akusinsiima. ");
INSERT INTO dov_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kumweelo bakali baalumi bali kkumi ababili. ");
INSERT INTO dov_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pawulo wakanjila muchikombelo akwambula changuzu kwamyezi yotatwe, kaambuzyania akubakombelezya atala abwami bwa-Leza. ");
INSERT INTO dov_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pesi aawo bamwi ba Juda nibakayuma myoyo akutalemeka, bakatalika kwambula bubi atala anzila ya Kkilisito kunembo lyabantu. Nkinkako Pawulu wakabasiya weenda abasikwiiya, akuyowambuzyania ambabo mazuba woonse munganda yazyiiyo yaku Tayilanasi. ");
INSERT INTO dov_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ezi zyakachitika kwaminyaka yobile, kuchitila kuti woonse wakakkede mu Esiya amvwe ijwi lyaMwami, boonse ba-Juda ama-Giliki. ");
INSERT INTO dov_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Leza wakalikuchita zigambyo zyiindilide kwindilila mumaboko a Pawulo, ");
INSERT INTO dov_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Kwakali kujanika kuti itudabba azisamo zyakukwabilila itombe zyakali kumuguma zyakali kutolwa kukusilisya bachiswa malwazi kaamana amyuuya mibi kayiizwa mulimbabo. ");
INSERT INTO dov_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pesi kwakali ba-Juda basikulipa bakayobweenda mubusena oobo. Bakalikwita izina lya Mwami Jesu kuchitila kuti bajane nguzu zyakuzunda myuuya mibi nibakali kuti, “Kwinda muli Jesu oyo Pawulo ngwakkambawuka, ndakulayilila kuti zwa,” ");
INSERT INTO dov_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Imupayizi mupati waba Juda, iwali kutegwa Sikkeva, wakali abana balombe bali musanu ababili bakali kuchita eezi. ");
INSERT INTO dov_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Imuuya mubi wakabasandula, “Jesu ndimwizi, Pawulu ndilimwizi, pesi iwe nduweeni?” ");
INSERT INTO dov_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Imuuya mubi wakali mumuntu wakabanyansya akubazunda basikulipa wabawuma. Aawo bakali kuchija kunganda oomo kabazwa maya azilonda zyakuumwa. ");
INSERT INTO dov_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Eezi zyakazibinkana kuli boonse, ba-Juda aba Giliki, aabo bakakkede ku Efeso. Bakayowa loko, Aabobo izina lya Mwami Jesu lyakalemekwa. ");
INSERT INTO dov_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Alubo, basyomi biingi bakaza akulibeteka kabapa bupanduluzi buzwide aatala azibi nzibakali kuchita. ");
INSERT INTO dov_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Basikwiiya biingi bakeeta mabbuku azibelesyo zyabo akwawumpa kunembo lyabantu boonse. anaibakaabala muulo wazyo, wakali makkumi musanu wazyuulu wazigodo zyansiliva. ");
INSERT INTO dov_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nkiinkako ijwi lya-Mwami lyakayendelela akusaalila changuzu mpati. ");
INSERT INTO dov_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Lino Pawulu nakamaninsya mulimo wakwe mu-Efeso, wakayeeya ichamumumuuya kuti ayinde ku Mesodoniya aku-Akkayiya kayobuya ku Jelusalema; wakati, “Mbuli mbundali kooku, kweelede ndikabone Loma,” ");
INSERT INTO dov_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pawulu wakazubula babili kuli bakali kumugwasya wabatuma ku Masedoniya, Timoti a Elasitasi. Pesi we lwakwe wakajana bukkala mu- Eziya kwakayindi. ");
INSERT INTO dov_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ikwachindi echo tekwakaba kuchelezeka nikuba kunini mu Efeso kulangene aanzila. ");
INSERT INTO dov_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Umwi simufula nsiliva utegwa Demetiliyasi, iwakali kubumba zikozyanisyo zyansiliva zya Diyana, ");
INSERT INTO dov_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","wakeeta makweebo miingi kuli basikubeza. Nkinkaako wakabungania aamwi babelesi bawoyo mulimo akwaamba kuti, “Nobantu, mulizi kuti mulooyu mulimo tujana mali inyingi. ");
INSERT INTO dov_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mulizibweene akuzimvwa eezi, teensi mu Efeso biyo pe, pesi kumasena miingi mu Eziya, Pawulu oyu wakombelezya akumwaya bantu biingi. Ulikwamba kuti baleza babumbwa amaboko teensi baleza. ");
INSERT INTO dov_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Takulikwamba biyo kuti ziletelezya kuti makwebo eesu abule bulemu, pesi akuti inganda yakukombela ya mukaleza Atenisi ikonzya kuba chintu chabuyo, abulemu bwakwe bunoli bwamana, we ooyo ukkombwa a Eziya yoonse akumanyika.” ");
INSERT INTO dov_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nibakazimvwa eezi, bakatulindila akunyema akukwiila, bakati, “Bulemu mbubwa Diyana waba Efeso,” ");
INSERT INTO dov_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Idolopo lyoonse lyakanyongana, alimwi bantu bakachijana amuzeezo womwe kabanjila muchibunganino. Bakajata basindikizi ba-Pawulu, Gayiyasi a Alisitachasi, aabo ibakazwa ku Mesodoniya. ");
INSERT INTO dov_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pawulu wakali kuyanda kunjila mumoomo mumpuumba yabantu, pesi basikwiiya bakamukasya. ");
INSERT INTO dov_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Alimwi, bamwi bapati bachilikiti cha Eziya ibakali beenzinyina bakatuma ijwi lyakumukombelezya kuti atanjili pe muchibunganino. ");
INSERT INTO dov_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bamwi bantu bakali kutambuzya limwi ijwi, abamwi kabatambuzya ilimbi, nkambo ilubunga olu lwakalinyongene, Ibiingi babo tebakazi biya pe akuti babunganina anzi. ");
INSERT INTO dov_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bamwi balubunga bakanyenyebwida Alekizanda, ooyo iwakali kutunziigwa kunembo aba-Juda. Mpawo Alekizanda wakatambika kuboko kwakwe, kayanda kukazya mumuswangano. ");
INSERT INTO dov_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pesi aawo nibakamuzida kuti mu Juda, boonse bakakwiila ajwi lyoomwe kwamahoola obile, kabamba kuti, “Ibulemu mbubwa Atenisi waba Efeso.” ");
INSERT INTO dov_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nakawumuzya luundu imulembi wadolopo, wakati, “Inywe nobantu baku Efeso, ngwani mwalumi uuliwo uutazi kuti idolopo lyaba Efeso mubambi wachikombelo cha mupati Atenisi achikozyanio ichakawida aansi kuzwa kujulu? ");
INSERT INTO dov_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nakabona lino kuti eezi zintu tazikakiki pe, ziyanda kuti walyumunizya kotachiti chamawiliwili. ");
INSERT INTO dov_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kaambo weeta baalumi aaba kulubeta kabatali babbi bazikombelo na basikusampawula izimuleza wesu. ");
INSERT INTO dov_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nkikaako, ikuti Demetiliyasi abasikubeza mbalabo kabali amuntu ngubapa mulandu, inkuta ilijulidwe ababeleka twambo mpobali. Ngabapane mulandu chabochabo. ");
INSERT INTO dov_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pesi kuti kakuli nzoyanduula aatala azimwi zyaambo, ziyobambwa mumuswangano uzibinkeene. ");
INSERT INTO dov_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kambo nchoonzyo tuli muntenda zyakupegwa mulandu aatala ankondo yasunu. Takwelede pe kuti kube kunyongana oku, alimwi tatukozokonzya pe kuzipandulula,” ");
INSERT INTO dov_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nakamana kwamba boobo, wakajala muswangano bakotoka. ");
INSERT INTO dov_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Niyakamana mbukila, Pawulo wakatuma basikwisya nakamana kubasungwazya. Wakati mwiinke obotu mpawo wakaya kuMakkedoniya. ");
INSERT INTO dov_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nakayabwenda bwenda akati kazisi ezyo wakambula makani mangi akubasungwazya, wakasika kuGilisi. ");
INSERT INTO dov_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Musule akukkala myezi itatu oko, baJuda bakamuvwiya kuchindi naakalikuyanda kuzubukila kuSiliya, aboobo wakayeya kubweda kayinda kuMakkedoniya. ");
INSERT INTO dov_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Kabaya bumusindikila kuya kusika kuAsiya oko Sopata mwana wa Payilasi waku Bbeliya; Alisitokkasi a Sekkundasi boonse bakazwa kubasyomi baku Tesalonikka; Gayo waku Debbe; Timoti aTikikkasi aTilofilasi waku aSiya. ");
INSERT INTO dov_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Pesi bantu aba bakasanguna kwinka kunembo eesu mpawo bakakutulinda kuTiloyasi. ");
INSERT INTO dov_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Twakayamba kuzwa kuFilipi kuzwa kumazuba achibunge chitakwe buswezyo, mukati kamazuba ali musanu twakasika muTiloyasi nkubakakkede. Oko twakakkala mazuba ali musanu aabili. ");
INSERT INTO dov_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Mubuzuba butanzi bwamviki, awo katubungene amwi mukukomona chibunge, Pawulo wakambula kubazumini. Walikubamba kuzwa mubuzuba butobela, wakabamba nkani yakwe kusikila akati kabusiku. ");
INSERT INTO dov_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mwakali malampi miingi mun'anda yakujulu mutwakabungene. ");
INSERT INTO dov_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mumpulunguzyo kwakkede mukubusi utegwa Utikkasi, oyo wakali mungonzi mpati. Awo Pawulo mbwakadonselela kwambula, oyu mukubusi wachili koona, wakawida ansi kuzwa kunganda yatatu kuzwa kujulu wakabwezwa ulifwide. ");
INSERT INTO dov_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pesi Pawulo wakaseluka ansi, wasika ali nguw walyolola akumubukata. Elyo wati, “Mutachinyemi limbi nkambo uchili muumi”. ");
INSERT INTO dov_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mpawo wakabweeda lubo kunganda yakujulu wakukomona chibunge mpawo walya. Musule akwambula chindi chilamfu kusikila kubuchedo, wakayinka. ");
INSERT INTO dov_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bakabozya mukubusi kali muumi bakawumbilizigwa kapati. ");
INSERT INTO dov_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Iswe lwesu twakayinka kunembo lya Pawulo abwato twazubukila kuAsosi, mputwali kuyeya kwenda amwi a Pawulo. Ezi nzyakayandide kuchita, nkambowakayelede kwenda amawulu. ");
INSERT INTO dov_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nakatuswania kuAsosi, twakamunjizya mubwato mpawo twayaMetileni. ");
INSERT INTO dov_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Mpawo twakayamba kuzwa ooko mpawo twakakusika buzuba butobela oko kubambene akasuwa kaKkiyosiizuba litobela twakasika aka suwa ka Samo, mpawo izuba litobela twakasika kumunzi waku Melitasi. ");
INSERT INTO dov_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Nkambo Pawulo wayeya kuyamba kayinda kuEfeso, kuti atakabi achindi chilamfu mu Eziya, nkambo wakali kufwambananina kuya ku Jelusalema kafwambanina buzuba bwapentekkositi niinga chakakonzeka kuti achite bobo. ");
INSERT INTO dov_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kuzwa ku Melitasi wakatuma bantu ku Efeso kuti bakamwitile baalu bambungano. ");
INSERT INTO dov_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nibakasika kulinguwe, wakati kuli mbabo, “Inywe lwanu mulizi, kuzwa kubuzuba buzuba butaanzi nindakalyata ino lyangu mu Eziya, ambunoli kali kukkala andinywe. ");
INSERT INTO dov_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ndakaya kunembo akubelekela mwami amoyo woonse, amisozi, mpawo amasunko akandibeda, nkambo kamanz abama Juda. ");
INSERT INTO dov_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mulizi mbundatakamusisila abunini kumwambila makani amwelede, ambundakamuyisya aakati kabantu mpawo akuzwa kunganda akunganda. ");
INSERT INTO dov_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ndakali kubalungunwida baJuda aba Heleni atala akusandukila kuli Leza mpawo akuba alusyomo muMwami wesu Jesu. ");
INSERT INTO dov_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Lino amubone, ndaya kuJelusalema ndangidwe mumuya, nsizi pe zintu zitakachitike kuli ndime oko, ");
INSERT INTO dov_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","kunze kwakuti Muuya Usalala undambile kuti mumyunzi yonse kuti insimbi yamapenzi zili ndilindilide. ");
INSERT INTO dov_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pesi nsikomezyi buumi bwangu kuli ndime ndimwini, kunze kwakukuti ndibeleke akumaninsya mulimu ngundakatumbula kuzwa kuMwami Jesu, kandilungununa makani mabotu aluzyalo lwaLeza. ");
INSERT INTO dov_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Lino amubone, ndilizi kuti nywe moonse, akati kanu mbindakendela kandamb bwami, tamuchikabuboni limbi busyu bwangu. ");
INSERT INTO dov_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nkikako ndipa bukamboni obuno buzuba, kuti nsikwe mulandu aganzi lyamuntu naba umwi. ");
INSERT INTO dov_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nkambo tendakaleka abuninikumwambila koonse kuyanda kwaLeza. ");
INSERT INTO dov_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nkikako amuchenjele lwanu, antoomwe abutanga obo Muuya Usalala mbwakamusalila kuba bendelezi. Amuchenjele mukwembela imbungano yaLeza, njakawula aganzi lyakwe. Kwindila muganzi lyamwanawakwe mwini. ");
INSERT INTO dov_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ndilizi kuti ndazwa biyo, bawumpe balasika akati kanu alimwi tabakobuleka butanga. ");
INSERT INTO dov_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ndilizi kuti nikuba kuzwa akati kanu bamwi bantu balabuka akwambula makani mabi kuti bagwisye basikwiya babo. ");
INSERT INTO dov_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nkikako amulinde. Muyeye kuti kwaminyaka itatu nsikalekede kumulaya umwi awumwi sikati amansiku amisozi. ");
INSERT INTO dov_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Lino ndamupeda kuliLeza akujwi lya luzyalo lwakwe, lukonzya kumuyaka akumupa lukono akati kababo bakasalazigwa. ");
INSERT INTO dov_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Takwe muntu ngundakanyeya nsiliva yakwe, ngolida, nikuba chizwaato. ");
INSERT INTO dov_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Inywe lwanu mulizi kuti aya maboko akabeleka zyakuliyanda ndime. Antoomwe azyababo bali antoomwe andime. ");
INSERT INTO dov_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Muzintu zyoonse ndakaba chitondezyo chambumukonzya kugwasya batajisi nguzu, zyakulibelekela, kuyeya makani amwami Jesu, makani ngakamba we lwakwe, “Kulilongezedwe kupa kwiinda kutambula”. ");
INSERT INTO dov_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nakamana kwambula munzila eeyi wakafugama wakomba ambabo boonse. ");
INSERT INTO dov_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kwakaba kulilisya mpawo bambundila Pawulo akumumyonta. ");
INSERT INTO dov_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Bakaba akuwusa boonse anzyakamba, kuti tabachizoboni busyu bwakwe ilubo. Mpawo bakamusindikila kubwaato. ");
INSERT INTO dov_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Eelyo nitwakeenda kuzwa kulimbabo kuti tukazubuke, twakatola inzila ilulama kudolopo lyaku Kkosi, mpawo muzuba litobela twakaya kudolopo lya Lodesi, kuzwawo twakaya kudolopo ilya Patala. ");
INSERT INTO dov_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Muchiindi nitwakajana bwaato buzubuka kuyaku Finisiya, twakazubuka twiinka. ");
INSERT INTO dov_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nitwaka kulangalanga mu Sayipulasi, katwisyiide kuchimweensi chabwaato, twakazubuka kuyaku Silisiya twaaku selukila a Taya, oko bwaato nkubwakali kuselezya zilongo. ");
INSERT INTO dov_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Eelyo nitwakajana basikwiiya, twakakkala mazuba musanu aabili. Kwindila muMuuya bakali kukasya Pawulu kuti atayinki ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nakamana mazuba esu, twakazwa mpawo twiinka muznzila yesu, abalabo boonse, abakayintu babo abana, bakatobela nitwakalikuzwa mudolopo. Twakafugama musele lyakumbali alwiizi twakomba, ");
INSERT INTO dov_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Mpawo twakawonekana twakaya kukutanta bwaato, bo bakabweeda kumyuunzi. ");
INSERT INTO dov_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Eelyo nitwakamaninsya lweendo lwakuzwa ku Taya, twakasika ku Putolemayisi. Oko twakajuzya bakwesu mpawo twakakkala kwazuba lyomwe. ");
INSERT INTO dov_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Mubuzuba butobela twakazwa twaya ku Sizaliya. Twakanjila munganda ya Filipo, muvangeli, oyo iwakali umwi wabalimusanu ababili, mpawo twakakkala awe ");
INSERT INTO dov_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","lino oyu mwalumi wakali abana banakalindu bone bakasinsima. ");
INSERT INTO dov_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Eelyo nitwakakkala kwamazuba, Awo kwakaselela uumwi musinsiimi kuzwa ku Lidiya uutegwa, Agabbasi. ");
INSERT INTO dov_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Wakaza kulindiswe kulindiswe mpwawo wakabweza ibbanti lya-Pawulu. Wakalyaanga andilyo kumawuluakwe akumaboko wasikuti, “Nzwalikwamba Muuya Uusalala, mbubatakamuchite bama Juda mu Jelusalema kwanga mwanibbanti eli mpawo akumupeda kumaanza abazwa maasi.” ");
INSERT INTO dov_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Aawo nitwakamvwa eezi zintu, toonse iswe abantu bakalikukkala mubusena oobo twakamukombelezya Pawulu kuti atayinki ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Elyo Pawulu wakasandula, “Uchitayi, kulila akukwamuna moyo wangu? Nkambo ndililibambilide, pepe kwangwa luzutu, pesi ikuti ndifwe mu Jelusalema mukambo kazina lya Mwami Jesu.” ");
INSERT INTO dov_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kaambo kakuti Pawulu takakombelezeka, twakawumuna mpwawo twakati, “Akuchitwe ikuyanda kwa Mwami. ");
INSERT INTO dov_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kuzwa amazuba aya, twakabweza izikwama zyesu twayinka ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Awo twakendaamwi abamwi basikwiiya bazwaku Sizaliya. Baketa mwaalumi uutegwa Munasoni, mwalumi uuzwaku Sayipulasi, sikwiiya mutanzi oyo ngutwakali kuzokkalaawe. ");
INSERT INTO dov_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Awo nitwakasika ku Jelusalemu, bakwesu baktutambula chakukondwa. ");
INSERT INTO dov_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Buzuba butobela Pawulu wakayinka andiswe kuli Jemusi, abaalu boonse bakaliwo. ");
INSERT INTO dov_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Awo nakabajuzya, wakabambila zintu chiimwi achimwi ezyo Leza nzyakali wachita akati kabamaasi kwindilila mumulimo wakwe. ");
INSERT INTO dov_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Elyo nibakazimvwa, bakalumbaizya Leza, mpawo bakati kulinguwe, “Wakubona, mukwesu, nzingana zyuulu zyakasyoma akati kaba Juda. Balilipedelede boonse kuti babambe mulawu. ");
INSERT INTO dov_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","bakabuzigwa aatala andime, ikuti uyiisya ba Juda boonse ibakkala akati kabamaasi kuti basule Mozesi, akuti mpawo ubabuzya kuti batakapaluuli ibana babo, akuteenda munzila yachiyanza chabo chakale. ");
INSERT INTO dov_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tuchiite kutyeni? nkaambo kasimpe bayomvwa kuti wasika. ");
INSERT INTO dov_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Lino chita ezi nzitukwambila: Tulabalumi bone bachita chikonke. ");
INSERT INTO dov_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bweza baalumi aba ulisalazye ambabo, ubbadale nzibelede kuti baliiye bo, kuti bakakulule mitwe yabo. Kuti muntu woonse akazibe kuti ezi zintu nzibakali babuzigwa ayeebo nzyabuyo. Bayoyiiya kuti ayebo upona kabotu mukubamba mulawu. ");
INSERT INTO dov_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pesi atala abamaasi ibakasyoma, twakalemba mizeezo yesu kuti bakaligwisye kuzintu zyapedwa kuzikozyanio, kubulowa akulizyadinwa, azyamalalane.” ");
INSERT INTO dov_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Elyo Pawulu wakabweza balumi, mpawo mubuzuba litobela wakalisalazya we antomwe ambabo. Elyo bakaya munganda ya Leza, akubona kuti mazuba akusalazigwa azuzikizigwa azipo ziketwe izya umwi wabo. ");
INSERT INTO dov_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Eno mazuba alimusanu aabili nakaaamba kumana, bamwi ba Juda baku Eziya, mukubona Pawulu mun'anda ya Leza, bakasungilizya makamu mpawo bamujata. ");
INSERT INTO dov_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Bakali kompoolola, Nobalumi ba Izilayeli, mutugwasye. Ngonguwe muntu uyiisya baluumi boonse koonse zintu zilwisyania abantu, amulawu, abusena obu. Kutali oobo, alubo, wakeeta baGiliki munganda ya Leza, mpawo wakasofwazya busena busalala. ");
INSERT INTO dov_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Mukuti bakali babona Tulofimasi waku Efeso nkalaawe mudolopo, mpawo bakayeeya kuti Pawulu wakali wamweeta mukati ka nganda ya Leza. ");
INSERT INTO dov_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Idolopo lyoonse lyakakondwa, abantu bakachiijana antomwe abakajata Pawulu. Bakamugwisya munganda ya Leza, imilyango mpawo yakajaligwa. ");
INSERT INTO dov_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Elyo nibakali kweezya kumujaya, makani akasika kuMwami wenkamu yechandaano yabalinda kuti yoonse Jelusalema yakali mukubotelwa. ");
INSERT INTO dov_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mpawo wakabweza abasilumamba abasilutwe babasilumamba bali mwaanda mpawo bakachijana buselela kuya kumakamu makamu Eelyo bantu nibakabona Mwami wachandano chaba Silumamba, bakimikila kumuma Pawulu. ");
INSERT INTO dov_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Elyo mupati wachandano wakasika wajata Pawulu, mpawo wakabambila kuti aangwe anketani zyobile. Elyo wakabuzya kuti wakaliini akuti wakaliini. ");
INSERT INTO dov_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Bamwi munkamu bakali koompolola chintu chomwe bamwi chimbi. Mukuti mupati wachandano takaziba bwini akambo kakuyowela kwakaliwo, elyo wakabambila kuti, Pawulu ayeetwe mukati kachikwabililo ");
INSERT INTO dov_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Chindi naakaza kumatantilo, wakanyampulwa abasilumamba nkambo kamakamu akali kumulwana. ");
INSERT INTO dov_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Awo makamu abantu akabotelwa akwimikila kunembo akoompolola, “mwiinkaawe!.” ");
INSERT INTO dov_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Awo Pawulu nakali kwetwa mukati kachikwabililo, wakati kumupati wachandano, “Zilazuminwa na kuti ime ngaambe chimwi chiintu kulinduwe?” Mupati wachandano wakati, “wambula chiGiliki na? ");
INSERT INTO dov_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Toli waku Ijipita na, wakindide chimwi chiindi chakinda wakatalika kupapapila mpawo akuzulwida zyuulu zyabalumi baku 'Asasinzi' kuya munkaanda?” ");
INSERT INTO dov_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pawulu wakati, “Ime ndimu Juda, uuzwa mudolopo ilyaku Tasasi mu Silisiya. Ime ndilichizyalwa chamudolopo lilemekwa. Ndakukumbila, ndizumizye kuti ngaambule abantu.” ");
INSERT INTO dov_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Elyo mupati wachandaano nakamuzumizya, Pawulu wakiima amatantilo mpawo wakawumuzya bantu akuboko. Elyo kwakaba kumuuna kunikide, wakaambula kuli mbabo mumulaka wachi Hiibbulu, We wati, ");
INSERT INTO dov_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Nobakwesu anomataata, amuswilile kulyambwida kwangu nkundiyanda kuchita lino kulindinywe.” ");
INSERT INTO dov_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Lino makamu makamu nakamvwa Pawulu kali kwambula mumulaka wachi Hebbulu, bakawumunisya. Wakati, ");
INSERT INTO dov_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Ímebo ndili mu Juda wakazyalilwa mu Tasasi waku Silisiya pesi ndakayiiya muchisi echino kunsi amawulu a Gamaliyeli. Ndakalayililwa mbuli mubwendelezi bwamilawu miyumu yaba mataata. Ndili musungusungu kuli Leza mbuli bamwi bangu boonse sunu. ");
INSERT INTO dov_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ndakapenzya inzila eyi kusikila kulufu, kandisunga akutola balumi abanakazi kumajele amuntolongo, ");
INSERT INTO dov_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","mbuli mupayizi mupati abazulwidi boonse blakonzya kuba bakamboni. Ndakatambula magwalo kuli mbabo, kuchitila kubakulana baku Damasiko alimwi ndakayinka kuyobaleta mubwange, kuti bakasubusigwe ku Jelusalema. ");
INSERT INTO dov_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Zyakachitika kandiyabwenda afwifwi a Damasiko, kuchindi chakuya kukalanga bwaseme mpawawo mumuni wakandimwekela kuzwa kujulu. ");
INSERT INTO dov_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ndakawida ansi mpawo ndakamvwa ijwi lyakati kuli ndime, 'Sawulu, Sawulu, nkambonzi nolikundipenzya? ");
INSERT INTO dov_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ndakasandula, 'Kuti nduweni, Mwami?' Wakati kulindime, 'Ndime Jesu waku Nazaleta, oyo ngoli mukupenzya.' ");
INSERT INTO dov_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Abo bonse mbindakalaabo bakawubona mumuuni, pesi tebakali kumvwisisisya ijwi lyayooyo wakali kwambula andime. ");
INSERT INTO dov_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ndakaamba kuti niinzi nchindeleede kuchita Mwami?' Mwami wakati kulindime, 'Buka uyiinke mu Damasikkas. Oko uyowambilwa zyonse nziwatondekelwa kuti ukachite. ");
INSERT INTO dov_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Tendakachili kubona pe nkambo kakutubisya kwamumuni ulya, kwinda mukuzulwidwa amaboko abaabo mbindakalabo, ndakanjila mu Damasikkasi. ");
INSERT INTO dov_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Nkukoko ndakaswanana amwalumi utegwa Ananiyasi, imwalumi wakalipedelede alubo kawuzi mulawu kajisi impuwo mbotu kuma Juda boonse bakali kukkala mumoomo. ");
INSERT INTO dov_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wakasika kuli ndime, wayimikila andime, alimwi wakati, “Mukwesu Sawulu, tambula kubona kwako.” Muchindi nchichecho ndakamubona. ");
INSERT INTO dov_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Elyo wakati kuli Leza waba mataata wakutondeka kuti uzibe kuyanda kwakwe, kuti ubone ulaleme ukamvwe ijwi lizwa mumulomo wakwe. ");
INSERT INTO dov_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Nkambo uyooba kamboni wakwe kubantu boonse kuli nziwabona akumvwa. ");
INSERT INTO dov_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Lino ulindaanzi? Buka, ubbabbatizigwe, alimwi usanziwe zibi zyako, akwiita kuzina lyakwe.' ");
INSERT INTO dov_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Nindakabweda ku Jelusalema amuchindi amuchindi nindakali kukomba mung'anda ya Leza, zyakandichitikila kuti ndakapegwa chilengano. ");
INSERT INTO dov_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ndakamubona kati kulindime, fwambana uzwe mu Jelusalema, chakufwambana nkambo tabakwe nibayo butambula bukamboni bwako atala andime.' ");
INSERT INTO dov_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ndakati, 'Mwami, bolwabo balizi kuti ndakali kwanga akuuma abo bakali kusyoma muli nduwe muzikombelozyonse. ");
INSERT INTO dov_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Alya bulowa bwa Sitivini kamboni wako nibwakatilwa, ndakali umwi wabo wakalimvwi kazuminana anzizyo, alimwi ndakali kulinda zyakusama zyababo bakamujaya. ");
INSERT INTO dov_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Pesi wakati kulindime, koya nkambo ndiyokutuma kule kuli bamaasi.” ");
INSERT INTO dov_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Bakamuswilila kusikila kujwi elyo. Mpawo bakompolola kabati nawandwe mukwesu oyo munyika nkambo tachilikabotu kuti apone.” ");
INSERT INTO dov_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nibakali kuya bompolola, kabasowa zisamo zyabo, alimwi kaba lundumuna lusuko mujulu. ");
INSERT INTO dov_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","awo silutwe mupati waba silumamba wakalayilila kuti Pawulu bamulele mukati alubaya. Wakapa malayilile akuti abuzisigwe chakuumwa achimboko kuti welwakwe akazibe kuti nkambonzi nibalikuya bompolola nkambo kakwe. ");
INSERT INTO dov_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Lino nibakamwanga lutambo Pawulu wakati kuli silumamba mupati walimwanda oyo wakalimvwi kumbali, “Chili mumawulu na kuti inywe muume mwalumi achimboko kalimu Loma alimwi kata toledwe kukwezegwa? ");
INSERT INTO dov_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Lino silumamba mupati walimwamda nakamvwa eezi, wakayinka kuli silutwe mupati wasilumamba wakamwambila kali kuti, “Niinzi ncholikuyanda kuchita? Nkambo oyu mwalumi oyu mu Loma mubuzyalwe bwakwe.” ");
INSERT INTO dov_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Silutwe mupati wabasilumamba wakasika kuli nguwe wati, ndambile uli mu Loma na? Pawulu wakati, “Iyii.” ");
INSERT INTO dov_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Silutwe mupati wabasilumamba wakati, zyakakonzeka biyo nkambo kamali nyiingi kuti ndikonzye kujana bukkalo bwamu Loma. Pesi Pawulu wakati, mebo ndakazyalwa kandili mu Loma. ");
INSERT INTO dov_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Mpawo bantu bakalelede kumubuzisisya bakamusiya mpawawo. Silutwe mupati waba silumamba wakali wayoowa, Nakayiiya kuti Pawulu wakali mu Loma, nkambo wakali wamwanga. ");
INSERT INTO dov_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mubuzuba butobela silutwe mupati wabasilutwe wakayanda kuziba nchoonzyo atala anchibakali kumutamikizya Pawulu muJuda. Mpawo waka mwangununa zyanzyo akulayilila Mupayizi mupati aboonse benkuta kuti baswanane. Mpawo wakamweeta Pawulu wamukkazika akati kabo. ");
INSERT INTO dov_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pawulo wakalangisisya basinkuta mpawo wakati, “Bakwesu, ime ndakapona kunembo lya Leza amoyo wangu woonse mubotu kuyoosikila sunu.” ");
INSERT INTO dov_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananiyasi mupayizi mupati wakalayilila aabo bakayimvwi kubbazu lyakwe kuti bamuume kumulomo. ");
INSERT INTO dov_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mpawo Pawulo wakati kulinguwe, “Leza ulawuma nduwe, iwe yobulambo butubulukide. Ukkalilide kundibeteka kumalawu na, pesi ulayilila kuti nduumwe, chitali mumulawu? ");
INSERT INTO dov_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Aabo bakayimvwi mpawo bakaamba kuti, “Mbomubo na mbotukila mupayizi mupati wa Leza?” ");
INSERT INTO dov_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pawulo wakaamba kuti, “Teendazi pe nobakwesu kuti ngomupayizi mupati. Nkaambo kulilembedwe, Tokoyoowambula bubi aatala amweendelei wabantu bako.” ");
INSERT INTO dov_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Aawo Pawulo naakabona kuti imwi nkamu yabantu bakali ba Sajusi mpawo bamwi bakali ba Falisi, wakaambuula ajwi pati nkali munkuta wati, “Bakwesu, mebo ndimu Falisii, ndimwana waba Falisii, nkaambo kakuti ndaabulangizi bwakubuka kubafu, nchenchicho nchendookubetekwa.” ");
INSERT INTO dov_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nakaamba oobo kwakaba kukazyania aakati kaba Falisi aba Sajusi, mpawo nkamu yakaanzaana. ");
INSERT INTO dov_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nkaambo ba Sajusi bati taakwe kubuka kubafu, taakwe bangelo alimwi taakwe myuuya, pesi ba Falisi balazizumina zyoonse eezyo. ");
INSERT INTO dov_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Mpawo kwakaba kuyooma kupati, bamwi balembi bamulawu balikubbazu lyaba Falisi, bakiimikila kabakazya kabati, “Taakwe bubi pe mbotujana mumwaalumi ooyu. Ani kuti muuya naakuti mungelo nguwaakambuula kuli nguwe?” ");
INSERT INTO dov_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Nikwakaba kuyooma kupati, mupati wabasilumamba wakayoowa kuti Pawulo balamukwamuma, aboobo wakalayilila basilumamba kuti bayinke aansi bakamubweze changuzu kuzwa kuli basinkuta amweete kusisikene. ");
INSERT INTO dov_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Busiku bwakatobela mwami wakiima kubbazu lyakwe mpawo wati, “Utayoowi, nkaambo mbuli mbwakandipeda bukamboni mu Jelusalema, mbubo mboyoondipeda bukamboni aku Loma.” ");
INSERT INTO dov_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nebwakacha, bamwi baJuda bakayungana balibika munsi lyachikonke, kabati tabakoolya na kunywa chikntu mane bamujaye Pawulo. ");
INSERT INTO dov_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bakalikwiinda makumi aane baalumi bakapanga jungwe eeli. ");
INSERT INTO dov_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bakayinka kubapayizi bapati akubaalu bembungano bakwaamba kuti, “Twaanga chikonke chipati kuti tutalyi chintu ado tumujaye Pawulo. ");
INSERT INTO dov_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Aboobo, lino basinkuta abakumbile zilimumulawu kuli silutwe wabasilumamba bamweete kulindiswe, kube aanga kuli nchoyanda kumvwisisisya kumulandu wakwe. Swebo tulilibambilide kumujaya katanasika aano. ");
INSERT INTO dov_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pesi mwana mulombe wamuchizi wa Pawulo wakamvwa kuti balimubawatilide, mpawo wakanjila mukati mwakabede Pawulo wakumwaambila. ");
INSERT INTO dov_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pawulo wakayita umwi wabasilumamba bamwaanda wati, “Bweza mulombe ooyo umutole kuli Silutwe wabasilumamba nkaambo uli aachakwaambwa. “ ");
INSERT INTO dov_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Eelyo Silutwe wabasilimamba bamwaanda wakabweza mulombe akumweeta kumupati wabasilumamba mpawo wamwaambila kuti, “Pawulo musungwa wandiita kulinguwe akundikumbila kuti njete mulombe ooyu kulinduwe. Ulachakwaamba kulinguwe. ");
INSERT INTO dov_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mupati wabasilumamba wakamujata wamutola kubusena busisikene mpawo wakamubuzya wati, “Niinzi nchoyanda kundaambila?” ");
INSERT INTO dov_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Mulombe wakati, “BaJuda bazuminana kuti kukukumbila kuti uyete Pawul ijuunza kunkuta, kakubanga bayanda kumvwisisisya obootu obootu mulandu wakwe. ");
INSERT INTO dov_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pesi utabazuminini nkaambo kuli baalumi biinda makumi one bamubwatilide munzila. Bakalimbika muchikonke chakuti tabakolya nanka kunywa chintu mane do bamujaye. Kwalino balindide biyo kuzumininwa anduwe.” ");
INSERT INTO dov_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mpawo mupati wabasilumamba wakamuleka mulombe ooyo weenda nakamana kumulayilila kuyi, “Utaambili muntu kuti wandaambila zintu eezi.” ");
INSERT INTO dov_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mpawo wakiita bapati babili babasilumamba bamwaanda wabaambila kuti, “Mubunganie mbasilumamba bali myaanda yobile balibambile kuyoosika ku Kkayisalia, abali makumi musanu aababili bama basimabbiza, abali myaanda yobile basimasumu. Mulanyampuka muwola lyatatu lyamansiku.” ");
INSERT INTO dov_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Wakambaambila alubo kuti babambe bamnyama mbatabelesye Pawulo akumutola katabililikide kuli elekisi mweendelezi wchilikiti. ");
INSERT INTO dov_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","“Mpawo wakalemba lugwalo luti: ");
INSERT INTO dov_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kkilawudiyasi Lisiyasi uyindila kulemekwa Mweendelezi Felekisi, ndajuzya. ");
INSERT INTO dov_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ooyu muntu wakasungwa abaJuda mpawo bakali kuyanda kumujaya nendakasika nkelabasilumamba akumuvuna nkaambo ndakamvwa kuti muna Loma ");
INSERT INTO dov_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ndakayanda kuziba kuti nkamboonzi nibamupa mulandu, aboobo ndakamutola kunkuta yabo. ");
INSERT INTO dov_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ndakaziba kuti wakalikupegwa mulandu uulangene aamilawu yabo, pesi taakwe kaambo nkaakachita pe nkapedwe keelela mulandu walufu na ntolongo. ");
INSERT INTO dov_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kuzwaawo ndakazibisigwa kuti kubambidwe mabambe aalangene amwaalumi ooyu, aboobo ndafwaambana kumutumizya kulinduwe akulayilila basikumupa mulandu kuti beete moilandu njibamupa kunembo lyako. Ndalumba.” ");
INSERT INTO dov_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Aboobo basilumamba bakatobele malayilile aabo, mpawo bakatgola Pawulo akumweeta kut Antipatilisi mansiku. ");
INSERT INTO dov_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Mubuzuba bwakatobela basilumamba biingi bakasiya basimabbiza kuti biinkaawe mpawo bo babweeda kulubaya. ");
INSERT INTO dov_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Aawo basimabbiza nibakasika ku Kkayisaliya akusisya lugwa kumweendelezi alimwi bakamutula Pawulo kulinguwe. ");
INSERT INTO dov_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Aawo nakabala lugwalo mweendelezi, wakabuzya Pawulo chilikiti nkwazwa; naakamvwa; kuti wakalikuzwa ku Silisiya, ");
INSERT INTO dov_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","wakati, “Nzokumvwisisisya basika basikukupa mulandu.” Mpawo wakalayilila kutgi abambwe kung'anda mpati yabwami bwa Helodi. ");
INSERT INTO dov_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nikwakayinda mazuba aali musanu, Ananiyasi mupayizi mupati abamwi bapati asimwiitilizya twaambo walikutegwa Tatalasi, bakayinka ooko. Lino baalumi aaba bakatamikizya Pawulo milandu kunembo lya mweendelezyi. ");
INSERT INTO dov_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Lino Pawulu nakayimikila kunembo lyamweendelezi, Tatalasi wakatalika kumuninaania wati kumweendelezi, “Nkaambo kako tuli aaluumuno lupati; alubo mubono wako upa kubumbululwa kubotu kwachisi chesu; ");
INSERT INTO dov_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","aboobo akulumba koonse talatambula zyoonse nzuchita, Felekisi, simunantya makani. ");
INSERT INTO dov_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Amukuti nditakujatili chiindi; ndakumbila kwiinda mubuuya bwako kuti utuswilizye mubufwifwi. ");
INSERT INTO dov_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Twajana mwaluumi oyu kali bulyi alubo kali sikusiblizya akusungilizya baJuda bali munyika zyoonse kuti babe basikubukila, Oyu muzulwidi wankamu yabaNazalini. ");
INSERT INTO dov_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Wakeezya kusampawula nganda yaLeza, ncitwamwanga. ");
INSERT INTO dov_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Pesi Lisiyasi, mupulisa waza wamubweza changuzu kuzwa mumaboko esu, wakalayilila basikumutamikizya kuti baze kulinduwe. Na mwamubuzya Pawulu atala amakani aya, mulakonzya kuziba zintu zyoonse kuti nkaambonzi nitunokumupa mulandu.” ");
INSERT INTO dov_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Abalabo bama Juda bakanjilila mukumutamikizya, kaba simatizya kuti twambo otu twamasimpe. ");
INSERT INTO dov_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Pesi mweendelizi nakapa Pawulu mweenya wakwaambuula, Pawulu wakavwiila wati, “Ndamvwisisisya kuti ujisi minyaka miingi kuli mubetesi wamusyobo wabantu aba nkikaako ndabotelwa kulipandulula kuli nduwe. ");
INSERT INTO dov_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ulakonzya kuziba lwako awulike kuti takuna kwiinda mazuba ali kkumi aabili pe kandli ndaya kukukomba ku Jelusalemu; ");
INSERT INTO dov_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","nibakandijana mu nganda ya Leza, takwe ngundakakazyanya awe pe, alubo takwe ambikakanyonyonganya pe, nikuba muzikombelo, na mudolopo; ");
INSERT INTO dov_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Tabakwe abukamboni pe mbubanga balapa atala lya makani ngibalokunditamikizya lino. ");
INSERT INTO dov_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Pesi ndiyanda kulyambilila kulinduwe makani aya, kuti kwiinda munzila njibaamba ayo kuti kabaamba kabunga kabukombi, mulinjiyo eyi nzila andime mundikubelekela Leza wabamataata. ");
INSERT INTO dov_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ndilasyoma zintu zyoonse zyeendelelana amulawu azilmbedwe mubasinsimi. Ndijisi bulangizi bumwi biyo muli Leza mbuli mbabo aba baluumi, bwakuti buzoba bubuke bwabafu bwa baluleme abasizibi. ");
INSERT INTO dov_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Nchiichicho nchindisungwala nchiindi choonse kuti ndibe amizeezo itakwe kampenda kunembo lya Leza akubantu. ");
INSERT INTO dov_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Lino nikwayinda minyaka miingi ndakaza kuzopa lugwasyo kubantu bakulindiswe akupa zipayizyo. ");
INSERT INTO dov_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nindakachita ezi, baJuda bamwi bazwa ku Eziya bakandijana kandilimulimu wakulisalazya munganda yaLez, kakutakwe bantu bayiingi niluba lupyopyongano. ");
INSERT INTO dov_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Aaba baluumi mbibeleede kuba kunembo lyako lino kabanditamikizya kuti kabala anchibanga balanditamikizya. ");
INSERT INTO dov_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Nakuti aba baluumi mbimbabo baleede kwamba bubi mbubakabona mulindime nindakayimikila kunembo lyaBbooma lyaba Juda; ");
INSERT INTO dov_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","kunze kwachintu chimwi echi nchindawompolola nindalimvwi kunembo lyabo,” chila achakuchita abubuke bwabafu nchindi mukubetekelwa kunembo lyako sunu. ");
INSERT INTO dov_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Lino nkambo Felikisi wakali wazibisigwa kabotu atala anzila eyi, wakayimikizya nkuta eyi. Wakati, “Kuti Lisiyasi muzuluzi wabasilumamba wasika kuzwa ku Jelusalemu, ndizobona zyakuchita amulandu wako oyu.” ");
INSERT INTO dov_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Mpawo wakalayilila mupati wankamu yabasilumamba mwaanda kuti Pawuli weleede kujalilwa kakuzilikila, pesi ajane lwangunuko lwaswayigwa abeenzunyina kuchitila kuti kabamugwasizya kulinzyabulide. ");
INSERT INTO dov_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Nikwayinda mazuba, Felikisi wakabweeda aDulisila mwanakazi wakwe, wakali muJuda, mpawo wakalayilila kuti Pawulu aletwe kulinguwe, elyo wakamvwisisisya azyalusyomo muli Jesu Kilisitu. ");
INSERT INTO dov_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pesi Pawulu nakamupalwida kabotu azyabululami, kulizyotola alubeta luboola. Felikisi wakatalika kuyoowa mpawo wati, “Zwa, bwalino kuya. Pesi ndazojana mweenya ndizokwita lubo.” ");
INSERT INTO dov_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Mpawo awo kalangilila kuti ambweni Pawuli walikunomupa mali, walikunga unokumwita kuti aambul aawe, kaniikumubwedezya.” ");
INSERT INTO dov_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Pesi nikwakayinda mimnyaka iibili, Pokkiyasi Fesitasi, wakaba mweendelezi mubusena bwa Felekisi, pesi Felekisi walikuyanda kuti baJuda bamuchijtgile buuya, eelyo wakasiya Pawulo kaangidwe. ");
INSERT INTO dov_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Lino Fesitasi wakanjila mubwami, alimwi musule lyamazuba otatwe wakazwa ku Kkayisalia kaya kuJelusalemu. ");
INSERT INTO dov_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bapayizi bapati abapati bama Juda bakeeta twaambo twakubejelezya Pawulo, alimwi bakabuzya Fesitasi changuzu. ");
INSERT INTO dov_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Bakakumbila Fesitasi kuti abape buuya aatala aPawulo kuti amwiite kuJelusalemu nkaambo bakakanza kumuyubilila kuti bamujaye. ");
INSERT INTO dov_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fesitasi wakasandula kuti, Pawulo wakalijiswi ku Kkayisalia, alimwi we lwakwe ulabweeda nkuko muchiindi chifwiifwi. ");
INSERT INTO dov_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Nkenkaako aabo bakonzya,” wakaamba “Balayinka andiswe nkuko, na kakuli chintu chitaluleme aatala ayooyu mwaalumi, muleleede kumupa mulandu.” ");
INSERT INTO dov_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesitasi naakakkala mazuba musanu aatatu kuyosika kukumi lyamzuba, wakayinka ku Kkayisalia, alimwi muzuba lyakatobela wakakkala achuuno chalubeta akulayilila kuti Pawulo aletwe kulinguwe. ");
INSERT INTO dov_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Naakasika, bama Juda baku Jelusalemu nibakayima afwiifwi, akuleta twaambo tuyumu ntobakali kukonzya kupeda bukamboni. ");
INSERT INTO dov_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pawulo wakalikwabilila akwaamba kuti, “Taakwe mulandu ngondakachita akukazyania aamulawu waba Juda nekuba uukazyania ang'anda yaLeza nekuba Kkayisala ");
INSERT INTO dov_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Pesi Fesitasoi wakalikuyanda kulumbwa kuba Juda, alimwi wakasandula Pawulo wati, “Ulayanda na kwiinka kuyobetekwa andime ku Jelusalemu aatala azeezi?” ");
INSERT INTO dov_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pawulo wakasandula skuti, “Ndilayima kunembo lyachuuno chalubeta cha Kkayisala ooko nkwenjele kubetekwa. Taakwe baJuda mbendakabisizya, mbuli mbomuzi kabotu kabotu. ");
INSERT INTO dov_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nakuti ndachita bubi akuti ndachita cheetelezya lufu tandikaki pe kufwa. Pesi kakuli kuti twwambo twabo katuli twabuyo, taakwe naba omwe uukonzya kundaaba kuli mbabo. Ndayi Kkayisala.” ");
INSERT INTO dov_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fesitasi naakambula ankamu yakwe wakavuwa wati, “Wakumbila kuyoobetekwa kuli Kkayisala, aboobo uliinka kuli Kkayisala.” ");
INSERT INTO dov_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Lino nikwakayinda mazuba, Mwami Agilipa a Bbenisi bakasika ku Kkayisaliya kuzoswayila Fesitasi. ");
INSERT INTO dov_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nikwakayinda mazuba miingbi kabali nkuko, Fesitasi wakatula kaambo ka Pawulo ku mwami, wakati, “Umwi mwaalumi wakasiigwa okuno aFelekisi kali mwaange. ");
INSERT INTO dov_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nindakali mu Jelusalemu bapayizi bapati abapati baba Juda bakeeta twaambo tukazyania ayooyu mwaalumi kulindime, akukumbila kuti apegwe mulandu. ");
INSERT INTO dov_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Ndakavwiila kuti tachili muchiyanza chaba Roma pe kwaaba muntu wabikwa kaambo, katanalangana aabo bakamubika kaambo, akujana chiindi chakulyaambilila mulandu ngobamupede. ");
INSERT INTO dov_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nkenkaako, nimbakabunga okuno, teendakachedwa pe, pesi nibwakacha ndakakkala achuuno chakubeteka akulayilila kui mwaalumi ooyo aletwe. ");
INSERT INTO dov_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nebanyampuka basikumupa mulandu, teebakamupa mulandu mboli mbundakali kulangilila pe. ");
INSERT INTO dov_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nekuba kuti bakali amibuzyo imwi yankombelo yabo beni, ayamuntu uutegwa Jesu wakafwa ngwasinizya Pawulo kuti muumi. ");
INSERT INTO dov_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Lino mbendakatalikwe bwiini akubuzisisya makani aliboobu, ndakabuzya kuti ulayanda na kuya kuJelusalemu akabetekwe aatala azeezi zintu. ");
INSERT INTO dov_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pesi Pawulo naakakumbila kuti asisigwe lwamwami mupati, ndakalayilila kuti alindwe mane nkamutimizye kuli Kkayisala.” ");
INSERT INTO dov_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agilipa wakati kuli Fesitasi, “Ambebo ndilayanda kumumvwa mwaalumi ooyu.” “Juunza,” wakasandula Fesitasi, “ulamumvwa.” ");
INSERT INTO dov_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Nkabela muzuba lyakatobela, Agilipa a Bbenisi bakasika abulemu bupati; bakasika mung'anda yakuswiilizya amntoomwe abasilumamba bapati abapati bamuchisi. Fesitasi nakalayilila, Pawulo wakeetwa kuli mbab. ");
INSERT INTO dov_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fesitasi wakati, “Omwami Agilipa, andinywe moonse nobaluumi nimuli aamwi andiswe aano, mwamubona mwaalumi ooyu, muntu ngundakakambilwa aba Juda ku jelusalemu akookuno alimwi bakoompolola kulindime kuti tacheelede pe kupona. ");
INSERT INTO dov_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ndakajana kuti taakwe chintu nchaakachita cheelede lufu; pesi nkaambo kakulikumbilila kumwami mupati, ndakakanza kumutumina. ");
INSERT INTO dov_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Pesi nsikwe majwi abukamboni akulembela mwami wangu. Nkaambo kaako nchindamweta kulindinywe, ikapati kunembo lyako Mwami Agilipa, kuti ndijane zyakulemba aatala amulandu ooyu. ");
INSERT INTO dov_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kwabaanga mbufubafuba kulindime kuti nditumine mwaange, alimwi kataambilidwe milandu njatamizizigwe.” ");
INSERT INTO dov_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Lino Agilipa wakambila Pawulu wati, “Ulakonzya kulyambwida lwako” Mpawo Pawulu wakanyampuka kuboko kwakwe walyambila. ");
INSERT INTO dov_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Ndabotelwa lwangu, Mwami Agilipa kwamba kumakani ngibandibejelezya oonse baJuda; ");
INSERT INTO dov_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","kapati nkambo we ulimusongo kuziyanza zyabaJuda akumibuzyo. Aboobo ndakumbila kuti indiswilizye mebo chamoyo mulamfu. ");
INSERT INTO dov_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kasimpe, bonse baJuda balikuzi kupona kwangu kuzwa kubwanikenike munyika yangu muJelusalema. ");
INSERT INTO dov_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Balizi atala andime kuzwa kumatalikil, kuti kabayanda kuzizumina, obo kuti ndakalikupona mbuli muFalisi, wamunkamu njumu loko yabukombi bwesu. ");
INSERT INTO dov_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ndayimikizigwa ano kuti ndibetekwe nkambo kabulangizi mbwakasyomezya Leza lwindila kulibamatata. ");
INSERT INTO dov_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Chisyomezyo chamikowa yesu ili kkumi ayibili nchituli abulangizi akutambula kuti twakomba Leza mansiku asikati, nkambo kabulangizi obo chembikilwa kaambo kubaJuda. ");
INSERT INTO dov_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nkambonzi mukuyeya kwanu, nimutazumini kuti Leza ulabusya bafu? ");
INSERT INTO dov_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Lino nchobeni, lwangu ndakali kuyeya kuchita zintu zizkazania azina lyJesu wakuNazaleta. ");
INSERT INTO dov_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ndakachita ezi muJelusalema bantu basalali bingi baLeza ndakabanjizya muntolongo mbundapegwa bwendelezi abapayizi bapati, anibakalikujegwa, ndakazumina kuti bajayigwe. ");
INSERT INTO dov_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ndakabapenzya kwachindi chilamfu muzikombelo zyoonse alimwi ndakezya kubajata changuzu kuti basampawulwe. Ndakanyema akubakalalila akubapenzya nikuba kuchisi chabwenzu. ");
INSERT INTO dov_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Nindakachili kuchita ezi ndakinka kuDamasikka munguzu amumalayilile a bapayizi bapati; ");
INSERT INTO dov_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nkiya buya oko, nilyakaba akalanga bweseme, mwami, ndakabona mumuni kuza kujulu wakali kubalama kwinda zuba wakatumwinikila watuzyunguluka ime abalumi mbindakali abo. ");
INSERT INTO dov_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Lino nitwakawida ansi, ndakamvwa ijwi kalyambula kulindime lyakuti mumulaka waHebbelu, 'Sawulo, Sawulo, undipenzezyanzi? Chiyumu kulindime kubbompa kasamu kalamfu kakubizya banyama.' ");
INSERT INTO dov_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mpawo ndakamba kuti, 'Nduweni, Mwami?' Mwami wakasandula kuti, 'Ndime Jesu ngulokpenzya. ");
INSERT INTO dov_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lino nyampuka uyimikile amawulu ako; Nkambo kamakanze nchindalibonia kulinduwe, ndikubikke kuti ube simulimu wangu asikulungununa wazezi zintu nzuzi atala andime azintu nzindakutondezya kunembo; ");
INSERT INTO dov_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ndiyokuvuna kubantu akuli bamasi oko nkundiyokutuma, ");
INSERT INTO dov_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Kuti ukabbanune meso akulekelelwa zibi akuti bakakone ezyo nzipa kuli babo basalazigwa alusyomo kwindila mulindime.' ");
INSERT INTO dov_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Aboobo, Mwami Agilipa, tendakaka kulemeka chilengano chakujulu; ");
INSERT INTO dov_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Pele kusanguna abaliku Damasikka mpawo amuJelusalema akwiinda muchisi chaJudiya, akuli bamaasi, ndakapa ijwi lyakuti bakonzye kusanduka akubola kuliLeza, bachite milimu iyelede kusanduka. ");
INSERT INTO dov_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Azezi baJuda bandanga mun'anda yaLeza kwezya kuyanda kundijeya me. ");
INSERT INTO dov_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Aboobo ndakatambula kuvunwa kuzwa kuliLeza kusikila sunu, ndimvwi akulungununa akati kabanini abapati katakwe chakuyungizya kunze kwazezi zyakaambwa abasinsimi aMozesi kuti zizochitika; ");
INSERT INTO dov_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Kuti Kilisito ulelede kupenzegwa, akuba mutanzi kubuka kubafu akupandulwida mumuni kubantu bakulindiswe akuli bamasi.” ");
INSERT INTO dov_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nkamaninsya kulyambila Pawulo, Fesitasi wakompolola ajwi pati wati, “Pawulo wasondoka; kwiiya kwako kupati kwasondosya. ");
INSERT INTO dov_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pele Pawulo wakati, “Nsisondokede pe, Fesitasi; simunantya makani uyindilide, ndikwamba biyo majwi akasimpe amvwika kunembo lyalubeta. ");
INSERT INTO dov_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nkambo mwami ulaza makani aya; lino ndambula achamba anguwe, ndakombelezya kuti kumakani aya oonse taakwe ngatabwene, nkambo echi techakachitwa kumbali pe. ");
INSERT INTO dov_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ulasyoma na basinsimi, mwami Agilipa? Ndilizi kuti ulasyoma”. ");
INSERT INTO dov_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agilipa wakamba kuti kuli Pawulo, “Kuchindi nchicho echo uyanda kundisandula na kuti mbemukilisitu na?” ");
INSERT INTO dov_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pawulo wakati, “Ndakomba kuli Leza, kuti nikuba kuchindi chilamfu, kutali ndiwe awulikke, aboobo bandimvwa sunu, bazoba mbuli ndime, kakutakwe nketani zyamuntolongo”. ");
INSERT INTO dov_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mpawo mwami wakanyampuka, amwendelezi a Benikke alakwe, aboonse mbibakakkede aboo; ");
INSERT INTO dov_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nibakazwa mun'anda, bakambula kuli umwi awumwi bati, “Oyu mwalumi tachitide chintu chelede lufu nikuba kwaangwa.” ");
INSERT INTO dov_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agilipa wati kuli Fesitasi, “Oyu mwalumi walede wangununwa anoli talina kumbila kuti atatongelwe a Kkayesa.” ");
INSERT INTO dov_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nikwakayeyegwa kuti twelede kuyaku Itali abwaato bakasala Pawulu abamwi baange kumwendelezi wabasilumamba utegwa Juliyasi wamunkamu. ");
INSERT INTO dov_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Twakanjila mubwato buzwa ku Adilamatiyamu oobo bwakali bwaba afwifwi kuti bunyampuke bwakali kuyoyinda kunkomwe ya Eziya. Mpawo twakayinka kulwizi. Alisitachasi uzwaku Tesalonika mu Masedoniya wakeenda andiswe. ");
INSERT INTO dov_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Mubuzuba butobela twakasika kuchisi cha Sidoni, oko Juliyasi nkwakakujata Pawulo cabuuya alimwi akumuzumizya kuti ayiinke kubenzinyina kuyotambula kubambwa. ");
INSERT INTO dov_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Kuzwa awo twakaya kulwizi twakuyamba muunsi ankoomwe yaku Sayipulasi, afwifwi akukasuwa, nkambo luuwo lwakalikututonta. ");
INSERT INTO dov_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nitwakeenda katutimbula lwizi nitwakazoinda ku Silisiya alimwi aku Pamfiliya, twakasika ku Mayila, chisi chaku Lusiya. ");
INSERT INTO dov_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nkuko ooko mwendelezi nkwakajana bwaato buzwa ku Alekizandiliya obo bwakalikuya ku Itali. Mpawo watubika mumo. ");
INSERT INTO dov_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nitwakali kweenda bunini abunini kwamazuba mayingi, twakazomaninsizya twasika mubuyumuyumu afwifwi a Sinidusi alimwi luuwo telwakazotuzumizya pe kuti twinde nzila eeyo, twakeenda katuyabuya alubazu lwankomwe yaku Kkilete, kumbali lya Salimone. ");
INSERT INTO dov_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Twakeenda mumo omo munkomwe mubuyumuyumu, mane twakusika kubusena bumwi butegwa Majulu mabotu, buli afwifwi achisi cha Laseya. ");
INSERT INTO dov_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Twakali twamana chiindi chilamfu, chiindi chakulyiimya kwama Juda achilacho chakali chayinda, alimwi kwakali kwatentuusya lino kweenda. Mpawo Pawulu wakabachenjezya, ");
INSERT INTO dov_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","wati, “nibaluumi, ndibwene kuti lweendo ndutuyanda kubweza lulakulichisa akuswekelwa kupati, pepe zinyampwidwe nikuba bwato luzutu, pesi abuumi bwesu.” ");
INSERT INTO dov_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Pesi mwendelezi wakaswilizya kapati kuli sikwenzya bwaato akulimuna bwaato kwinda eezyo zyaakambwa a Pawulu. ");
INSERT INTO dov_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nkambo chito techakali chuubila pe kuti bukkale mpawo chilinu choonse, bamwi bayiingi bakapa muzezo wakuti tweende kuzwa aawa, ambweni dozyakonzeka ngatuyosika kuchisi cha-Foyenikisi, kuti tukakkale chiindi chachilimo nkuko. Foyenikisi nchito cha Kkilete, chilangide koonse kumusaansa akububbila alimwi kumbo -akububbila. ");
INSERT INTO dov_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Eelyo luuwo lwakumusansa nilwakatanguna kuunga kwachumunizi, basibwato bakayeeya mbuli kuti bakali bachijana nchibakalikuyanda. Lino bakanyamuna bbwe lyakwimikizya bwato mpawo beenda kabatobezya Kkilete, afwifwi ankomwe. ");
INSERT INTO dov_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Pesi nikwakayinda kayindi kanini kwakaza muuwo mupati uutegwa Notisita, wakatanguna kuuma aansi kuzwa kusuwa. ");
INSERT INTO dov_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Eelyo bwaato nibwakajatwa amuuwo mupati zyakukachilwa kuyakunembo muluuwo, twakayinzizya muuwo mupati ooyu mwenya alimwi wakatuchuunda twatobelezya muuwo. ");
INSERT INTO dov_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Twakeenda munkomwe munsi akasuwa kanini kategwa Kkawunda, alimwi abuyumuyumu twakazokonzya kusika akaato kakuvunwa. ");
INSERT INTO dov_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Eelyo nibakaanga Kaato, bakabelesya minchinda yako mpawo bazojatanisya amwi kubulambo bwabwato. Bakalikuyowa kuti ngabayosisigwa kumuse waku Sayitisi, lino bakalosya minchinda wangidwe bbwe wabwato alimwi bakatontwa kabayabuya. ");
INSERT INTO dov_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Twakatamamizigwa mbubobu amuuwo mupati zyakuti buzuba bwakatobela bakatanguna kubwala mpasya mukati mulwizi. ");
INSERT INTO dov_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Mubuzuba bwachitaatu bantu bakalimubwato bakabwaala zintu zyakali mubwato amaboko aabo. ");
INSERT INTO dov_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Eelyo izuba anyenyezi nizyakatatumunikila kwamazuba mayingi, alimwi muuwo mupati kuchuuma alindiswe, bulangilizi boonse bwakuti twelede kufutulwa bwakamana. ");
INSERT INTO dov_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nibakeenda kwachiindi chilamfu kabatakwe chakulya pe, eelyo Pawulu wakayimikila akati kabantu wati, “Nobakwesu, mwalelede kunditelela, alimwi temwalelede kwenda kamuzida kuKkilete pe, eezi zyakuti mujane kulichisa alimwi kuswekelwa. ");
INSERT INTO dov_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Lino ndamusimya kuti nywebo mube abusungu, nkaambo takwe nikutabewo pe kuswekelwa buumi akati kanu, pesi biyo kuswekelwa kwabwaato. ");
INSERT INTO dov_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Busiku bwayinda mungeelo wa Leza ooyo ngundili kulinguwe, ooyo alimwi ngundikomba — mungelo wakwe wakaliimvwi aambali lyangu ");
INSERT INTO dov_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","alimwi wati, 'Utayoowi, Pawulu, weelede kuyoyimikila kunembo lyaKayisa, alimwi ukabone Leza mubuya mbwakapa kuli nduwe abo boonse balimulwendo anduwe.' ");
INSERT INTO dov_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Linobu mube abusungu, nobakwesu! Nkaambo ndisyoma Leza kuti chiyochitika mbuli mbuchakaambwa kulindime. ");
INSERT INTO dov_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Pesi twelede kuchijana munyika amutusuwa.' ");
INSERT INTO dov_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Eelyo busiku bwakkumi abwaane nibwakasika, mbuli mbutwali kuchundilwa kulubazu olu alimwi mukati kalwiizi lwa Adiliyatiki, kubanga mpakati kabusiku basilwendo bakayeeya kuti bamba kusika kunyika. ");
INSERT INTO dov_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bakabeza zipimyo alimwi bakajana kuti maboko ali kkumi amusanu. ");
INSERT INTO dov_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bakayoowa kuti ambweni anga tulawuminina amabwe, lino bakawaala mabwe akwimikizya bwaato aanze kuzwa munsi alimwi bakakomba kuti kucha ambweni kulafwambana kusika. ");
INSERT INTO dov_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bakali mubwaato bakalikulanga nzila yakusiya bwato alimwi bakalosya kaato kulwizi, alimwi bakabaanga balabwaala mabwe abwaato kuzwa kunembo. ");
INSERT INTO dov_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pesi Pawulu wakati kumwendelezi akuli basilumamba, “kunze akuti baalumi aaba bakkale mubwaato, takwe nimunga mulafutuka pe.” ");
INSERT INTO dov_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Eelyo basilumamba bakadunsuula minchiinda yakaato alimwi bakaleka kayabuya. ");
INSERT INTO dov_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nikwakaamba kucha, Pawulo wakabasungwazya boonse kuti babweze chakulya. Wakamba kuti, “Eli zuba ndyakkumi aane kamuswini kulindilizya kamutakwe chakulya pe — takwe nchimulide pe. ");
INSERT INTO dov_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Eelyo ndamukombelezya kuti mwabane chakulya, nkambo oolu ndulufutuka lwanu. Ko takukwe anaba umwi akati kanu utaswekelwe inzeeta imwi yasusu kuzwa kumutwe wakwe.” ");
INSERT INTO dov_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Naakamana kwaamba eezi, wakabweza chinkwa alimwi walumba Leza mumeso aboonse. Eelyo wakakwamuna chinkwa alimwi watalika kulya. ");
INSERT INTO dov_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Eelyo bakasungwazigwa boonse mpawo abalabo bakabweza chakulya. ");
INSERT INTO dov_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Twakali myaanda ibili ilamakkumi musanu aabili amusanu awumwi (276) myuuya yakali mubwaato. ");
INSERT INTO dov_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nibakalya achakwelela, bakachita kuti bwaato buubilwe akubwaala mayila mulwizi. ");
INSERT INTO dov_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nikwakaba buunsi, tebakibonape nyika, pesi bakabona tyebe lilankomwe, alimwi bakayowesya kuti anga balayinzya bwaato na ataala. ");
INSERT INTO dov_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mpawo bakanenga zyatendela zijazyo alimwi bakasiya mukati kalwizi. Muchindi chimwi biyo eecho bakangununa minchiinda yazitabilisyo kuluuwo; alimwi bakayinka kunkomwe. ");
INSERT INTO dov_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Pesi bwaato bwakajimpa aansi mpawo bweenda anyika. Chakumpela chabwato chakapatila alimwi chachaala kachitanyamuki pe, alimwi chaansi chakatyolwa anguzu zyamayuwe. ");
INSERT INTO dov_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mabaambe abasilumaamba akali kujaya baange kuchitila kuti kutabi naba omwe uunga ulayamba mpawo achije. ");
INSERT INTO dov_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Pesi mweendelezi wakalikuyanda kufutula Pawulo, mpawo wakayimikizya mabambe aabo; alimwi wakalayilila aabo bakalikukonzya kuyamba kuti basotokele kuunze alimwi basike anyika. ");
INSERT INTO dov_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Eelyo boonse baalumi beelede kutobela, bamwi ajulu azimwi zintu zyakali mubwato. Munzila eeyi zyakachitika kuti toonse tusike obotu anyika. ");
INSERT INTO dov_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nitwakazubusigwa kabotu twanjila mukati, twakaziba kuti ako kasuwa kategwa Malita. ");
INSERT INTO dov_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bantu bamumo bakatuchitila buuya bwindilide, pesi bakakunka mulilo, batutambula toonse, nkaambo kwakali muyooba alubo kakulokutontola. ");
INSERT INTO dov_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pesi Pawulu nakabwezelela bukunikuni wabuwaala mumulilo, muzoka wakazwa nkaambo kakuumpa kwamulilo. Mpawo wanamatila aluboko lwa Pawulu. ");
INSERT INTO dov_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Lino bakkali bamuchisi echi nibakabona munyama oyu ulalengelela aluboko lwa Pawulu, bakati kuli umwi awumwi, “Oyu mwalumi welede kuti mujayi wavunwa kulwizi. Lubeta talumuzumizyi pe kuti kachipona.” ");
INSERT INTO dov_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Pesi nakamusansila mumulilo muzoka ulya, katakwe anakamuchisa pe. ");
INSERT INTO dov_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bakalindila kabalangilila kuti ulachiswa ndulwe mukati na kuti kuwidaansi mpawawo. Pesi nibakamulangilizya kwachiindi chilamfu, babona takwe abubi bwakachitika alinguwe, bakasandula kuyeeya kwabo bati mwalumi oyu ngu Leza. ");
INSERT INTO dov_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Lino abusena buli afwifwi kwakali nyika yakali yamuzuluzi mupati wakasuwa aaka, mwalumi utegwa Pabbuliyasi. Wakatutambula watukutawukila kwamazuba ataatu. ");
INSERT INTO dov_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Lino kwakaba kuti wisi wa Pabbuliyasi wakalikuchiswa ndulwe akania bugwalaya. Lino Pawulu nakaya kulinguwe, wakakomba, wamubikka maboko, mpawo wamuponia. ");
INSERT INTO dov_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Kuzwa akuchitika kwazezi, bantu biingi bakalikuchiswa mukasuwa aaka bakaza mpawo bakaponesegwa. ");
INSERT INTO dov_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bantu bakatulemeka abulemo bwiingi. Elyo nitwakaamba kweenda, bakatupa zyoonse nzitwakabulide. ");
INSERT INTO dov_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kuuzwa amyeezi itaatu twakeenda abwaato bwakali bwamaninsya chilimu choonse kabuli akasuwa, bwaato bwa Alekkizandiliya bwakalijisi chikozyano chaba leza bamambile kachili chitondezyo, ");
INSERT INTO dov_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Kuzwa nitwakasika adolopo litegwa Silakkiyasi twakakkala mazuba ataatu. ");
INSERT INTO dov_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kuzwa mpawawo twakayamba mane twakusika kudolopo litegwa Legiyamu. Nikwakayinda zuba limwi kwakabuka moya wakumusanza, mpawo mukati kamazuba twakali twasika kudolopo lya-Pitiyoli. ");
INSERT INTO dov_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Awa twakajana babunyina bamwi, mpawo batutamba kuti tukkale ambabo kwamazuba aalimusanu aabili. Kwiinda munzila mbutwakasika ku Loma. ");
INSERT INTO dov_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kuzwa mpawawo bakwesu nibakamvwa kuti twasika bakaza kuzotutambula ku Masasmbalilo a Apiyasi, akumaanda ataatu nkutwakali twaba. ");
INSERT INTO dov_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nitwakanjila mu Loma, Pawulu wakangununwa kuti akkale alikke a silumamba sikumulinda. ");
INSERT INTO dov_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Elyo kwakaba kuti nikwakayinda mazuba ataatu Pawulu wakayita basilutwe bama Juda. Lino nibakabangununa, wakati kulimbabo; “Nobakwesu, nikuba kuti tandijisi mulandu pe kubantu akutunsiyansiya twamataata, Ndakeetwa mbuli mwaange kuzwa ku Jelusalema ndabikwa mumaboko aba Loma. ");
INSERT INTO dov_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nibakandibuzisisya, bakaba amoyo wakundangununa nkambo kwakabulika mulandu wakuti ndijiigwe. ");
INSERT INTO dov_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Pesi bama Juda nibakambuula mbuli mbubayanda, ndakamanikizigwa kuti ndizobetekwe kunkuta ya Siza, nikuba kuti takuli ndikupa bantu bakuli ndiswe mulandu. ");
INSERT INTO dov_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nkambo kanzizyo ezi, nchindamwiita kuti ndimubone mpawo ngaambule andinywe, mbuli kuti nkambo kabulangizi bwa Izilayeli nchindisamide nketani eezi lino. ");
INSERT INTO dov_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Mpawo bakati kulinguwe, “Takwe anitwakatambula magwalo aambula azyanduwe, naba umwi wabakwesu wakaza kuzotwambila azyako, nikuba kwamba chimwi chibi atala anduwe. ");
INSERT INTO dov_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Pesi tukumbila nduwe kuti uyeeya buti abukombi obu, nkaambo tulizi kuti bunowaambulwa azyambubo koonse koonse. ");
INSERT INTO dov_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nibakabamba buzuba bwakuyooma anguwe, bantu biingi bakali kusika kung'anda yakwe. Wakabaambila kaambo kakwe, alubo kalungulula azyabwami bwa Leza. Wakeezya kubakombelezya azya Jesu, kubikka aamwi kuzwa kumulawu wa Mozesi awaba sinsimi kuzwa kuseni kuyosika goko. ");
INSERT INTO dov_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Bamwi bakazumina aatala azintu ezi zyakali kwaambwa, pesi bamwi tebakazumina pe. ");
INSERT INTO dov_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nibakakkachilwa kuzuminana kumakani aya, bakazwa bamusiya Pawulu kali wamba ijwi eli: “Muuya Uusalala wakaambula kwiindilila muli Isaya musinsimi kuli bamawuso, ");
INSERT INTO dov_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“Wakati, koya kubantu aba ukaambe kuti, 'Akumvwa muyoomvwa pesi tamukwe nimuyomvwisisisya pe. akubona mulakubona pesi takwepe kunobenesesya loko. ");
INSERT INTO dov_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Nkambo moyo wabantu aba wasitikwa, amatwi abo takonomvwa pe, alubo bakafwinya meso aabo, mbokunga ngabalabona ameso abo mpawo bamvwe amatwi abo mpawo bamvwisisye amyoyo yabo mpawo basanduke lubo kuti ndibaponisye.” ");
INSERT INTO dov_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Nchinchicho, mwelede kuziba kuti olu lufutuko lwa Leza lwakatuminwa bamasi alubo bayoswilizya. ");
INSERT INTO dov_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Lino nakamba makani aya, bama Juda bakeenda alubo bakanyongana loko. ");
INSERT INTO dov_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pawulu wakakkala minyaka ibiili mung'anda yakwe mwini yakuula. ");
INSERT INTO dov_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Wakali kukambawuka bwami bwa Leza, alubo wakalikuyiisya azya Mwami Jesu Kkilisito abusichaamba buzulide kakutakwe achimugulungania pe. ");
INSERT INTO dov_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Pawulo, mulanda waJesu Kkilisito, wakayitwa kuti abe mu positoli, alimwi wakasalilwa kukuchita mulimu waLeza. ");
INSERT INTO dov_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Eli ndilyo vangeli ndyakasyomezya chiindi kwiinda mubasinsimi bakwe mumalembe aasalala. ");
INSERT INTO dov_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Zili aatala aMwana wakwe, wakazyalwa kuzwa kulunyungu lwaDeviti mukwiinda munyama. ");
INSERT INTO dov_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Akubuka kuzwa kubafu, wakaambwa kuti Mwana waLeza uli a manguzu mapati kwiinda muMuya wa busalali - Jesu Kkilisito Mwami wesu. ");
INSERT INTO dov_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kwiinda mulinguwe twakatambula luzyalo abutumwe akaambo kakuswiilila chalusyomo aakati kamanyika woonse, kuchitila zina lyakwe. ");
INSERT INTO dov_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Aakati kawaaya manyika, alubo mwakayitwa kuti muli bakuli Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Oolu lugwalo ndulwabaabo bali muLoma, bayandwi baLeza, bayitwa kuti bantu basalala. Luzyalo alube kulindinywe, alimwi luumuno luzwa kuli Leza Taata wesu alimwi Mwami Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Lutanzi, ndilumba Leza wangu kwiinda muli Jesu Kkilisito akaambo kenu moonse, akuti lusyomo lwenu lwaambilizigwa munyika yoonse. ");
INSERT INTO dov_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Leza ngu kamboni wangu, ngundibelekela mumuya wangu kumakani mabotu aMwana wakwe, aawo mpeyinkila kunembo nkewamba atala andinywe. ");
INSERT INTO dov_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Ndilakumbila lyoonse munkombyo zyangu kuti mubunini ndikonzye kuzwidilila lino akuyanda kwaLeza mukuza kulindinywe. ");
INSERT INTO dov_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nkaambo ndilayandisya kumubona, kuti ndimupe zimwi zilongezyo zyaMuya, kuti ndikonzye kumusimisya. ");
INSERT INTO dov_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nkokuti, ndilayanda kusungwazigwa akanu kenu, kwiinda mulusyomo lwawumwi awumwi, lwangu alimwi alwangu. ");
INSERT INTO dov_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Lino nsiyadi pe kuti mube batazi, bakwesu, kuti kiingi ndakalikuyanda kusika kulindinywe, pele ndakalikukachisigwa kusila lino. Ndakali kuyanda echi kuti nkonzye kuba amuchelo akati kenu alubo mbuli akati kabaMaasi. ");
INSERT INTO dov_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ndimesichikwelete kubili kubaGiliki alimwi akubazwakule, koonse kubasongo alimwi akubafubafuba. ");
INSERT INTO dov_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Nkaambo, mbuli ndime, ndililibambilide kwaambawula ivangeli alubo kulindinywe nimuli kuLoma. ");
INSERT INTO dov_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Nkaambo nsiwusigwi nsoni avangeli, nkaambo manguzu aLeza kulufutuko kuli woonse uusyoma, kubaJuda alimwi kuba Giliki. ");
INSERT INTO dov_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Mukuti mulindilyo bululami bwaLeza bwayubununwa kuzwa kulusyomo kuya kulusyomo, mbuli mbukwakalembwa, “Basalali bayoopona chalusyomo.” ");
INSERT INTO dov_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Nkaambo mukali bwaLeza bwayubununwa kuzwa kujulu aatala abusofwazi alimwi akutalulama kwabantu, aabo babwedezya musule isimpe akaambo kakutalulama. ");
INSERT INTO dov_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ezi nkukuti eecho chizibinkene aatala aLeza chilaboneka kulimbabo. Nkaambo Leza wabamunikila. ");
INSERT INTO dov_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Nkaambo bube bwakwe butaboneki bwakatondeezegwa aantanganan kuzwa kumatalikilo akulengwa zintu. Bube oobu ninguzu zyakwe zitamani alimwi abunajulu. Akaambo kaako, aaba bantu tabachikwe ntami pe. ");
INSERT INTO dov_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ezi nkukuti, nikuba bakalizi aatala aLeza, tebakamulemya mbuli Leza, nikuba kumupa bulumbu. Pesi, baka bafubafuba mumiyeeyo yabo, alimwi myoyo yabo itamvwisisisyi yakasizigwa. ");
INSERT INTO dov_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Bakali kulyaamba kuti bali abusongo, pele bakaba bafubafuba. ");
INSERT INTO dov_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Bakachinchanisya bulemu bwaLeza uutanyonyooki kucikkozyanyo chachitombe chamuntu uunyonyoka, cha bayuni, chabanyama bali amawulu one, alimwi chazintu ziyavula. ");
INSERT INTO dov_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Akaako Leza wakabaaba kunkosya yamyoyo yabo yabusofwazi, kuti mibili yabo ikabule kulemekwa aakati kabo. ");
INSERT INTO dov_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Mbimbabo bakachinchaanya kasimpe kaLeza kumabejo, alimwi bakakomba akulemya zilengwa kwiinda Mulengi, uyolumbayizigwa chakutamana. Amen. ");
INSERT INTO dov_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Akaambo kacheechi, Leza wakabapeda kumpeekezyo zitakwe bulemu, nkaambo banakazi babo bakachinchanya bubelesi bwabo mbubakalengwa aambubo kulizeezyo ziteendelani aabukkale. ");
INSERT INTO dov_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Mbuli munzila eeyi, baalumi abalabo bakasiya nzibakeelede kuchita abanakazi alimwi baba eenkosya yakuyanda umwi awumwi. Aaba mbaalumi bakachita a baalumi chiteelede pe, alimwi bakatambula mulilwabo lubeta lweendelana akutabotya kwabo. ");
INSERT INTO dov_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nkaambo tebakayeeya kubika Leza mukubonesya kwabo, wakabapa muzezo utali kabotu, kuchitila mbabo kuti bachite ezyo zintu zitali kabotu pe. ");
INSERT INTO dov_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Bakazuzigwa akutalulama koonse, busofwazi, butangazi, alimwi a mabejo. Balizwide bbivwe, bujayi, lukajyanyo, lweeno, alimwi amiyeyo mibi. ");
INSERT INTO dov_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Mbavwiyi, mbaasibupampu bwakubba, alimwi mbaasimusula-Leza. Balalupyopyongano, mbaachuundwe, alimwi balalisumpula. Mbaasimubamba zibi, alimwi tabaswiilili bazyali babo. ");
INSERT INTO dov_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Tabakwe kumvwisya; tabasyomekede pe, batamvwidi luzyalo alimwi batakwe luse ");
INSERT INTO dov_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Balamvwisya milawu yaLeza, kuti aabo bachita zintu ziliboobu baleelede kufwa. Pele pe pe kuti balachita biyo zintu ezi, balabotelwa abaabo bamwi bazichita ");
INSERT INTO dov_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Akaako tokwe chikachizyo, iwe muntu, iwe nuubeteka, nkaambo nchobeteka muli umwi mulinduwe ulalipa mulandu. ");
INSERT INTO dov_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Pele tulizi kuti lubeta lwaLeza lweendelana akasimpe na lwawida aali baabo bachita zintu zili boobu. ");
INSERT INTO dov_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Pelelangisisye eechi, iwe muntu, nuubeteka aabo bachita zintu zili boobu nikuba ulachita zili boobo ayebo. Uyoonzwenga na kulubeta lwaLeza? ");
INSERT INTO dov_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Na uyeeya buniini aatala abuvubi bwabubotu bwakwe, kuchedwa kwalubeta lwakwe, alimwi alukakatilo lwakwe? Tamuzi na kuti bubotu bwakwe buchitilidwe kuti bumuzulwide kukusanduka? ");
INSERT INTO dov_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Pele nkaambo kakuyuma akutasanduka kwamoyo nkoli kulilondweda bukali mubuzuba bwabukali, nkokuti, buzuba bwakuyubununwa kwalubeta lululeme lwaLeza. ");
INSERT INTO dov_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Uyooboozya kumuntu woonse mbuli mumachitlo aakwe: ");
INSERT INTO dov_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","kulibaabo bachita kabotu chabusungu akuyanduula bulumbu, kulemekwa, alimwi akutafwa, uyoopa buumi butamani. ");
INSERT INTO dov_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Pele aabo balichitila zyabo, bataswiilili simpe pesle balaswiilila kutalulama, lunyemo abukali bupati buyosika kulimbabo. ");
INSERT INTO dov_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Leza uyoyeta mapenzi amafwabi kumuuya wamuntu woonse wakachita bubi, kubaJuda lutaanzi, alimwi akubaGiliki. ");
INSERT INTO dov_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Pele bulumbu, bulemu, aluzyalo ziyoosika kuliwoonse uuchita kabotu, kumaJuda lutaanzi, akubaGiliki. ");
INSERT INTO dov_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Nkaambo takwe kusaluulana pe kwaLeza. ");
INSERT INTO dov_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Nkaambo mbuli biingi mbubakabisya kakutakwe mulawu bayoofwa alubo kakutakwe mulawu, alimwi mbuli biingi mbubakabisya mumulawu, bayoobetekwa mumulawu. ");
INSERT INTO dov_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Nkaambo tensi basikumvwa mulawu mbibaluleme kunembo lyaLeza, pele mbaasikuchita batakalulamikwe. ");
INSERT INTO dov_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Nkaambo aawo baMaasi, batakwe mulawu, bo, mulawu kulilwabo beni, nikuba tabakwe mulawu. ");
INSERT INTO dov_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Kulichechi batondeezya kuti nchito ziyandwa aamulawu zililembedwe mumyoyo yabo. Mayeyelo aabo alazuminana, alimwi miyeyo yabo tiibapi mulandu pe na kubalwanina lwabo beni ");
INSERT INTO dov_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","alimwi akuliLeza. Eezyo ziyochitikana mubuzuba aawo Leza natakabeteke nsiswa zyabantu boonse, mbuli muvangeli lyangu, kwiinda muli Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Na kolyaamba kuti uli muJuda, kala aatala aamulawu, botelwa chakulikankayizya muli Leza, ");
INSERT INTO dov_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ziba luyando lwakwe, mpawo sala zisiyene kkuyigwa mulawu, koli walayililwa amulawu. ");
INSERT INTO dov_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Alimwi koli aalusinizyo kuti nduwe sikuzulwida boofu, mumuni kuibaabo bali mumudima, ");
INSERT INTO dov_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","muzyotololi wabafubafuba, muyisi wabaniini, alimwi koli aaluzibo akaasimpe kamulawu. ");
INSERT INTO dov_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Iwe, lino, noomuyisi wabamwi, toliyiisyi na we nomwini? Nywebo nimukambawuka kuti mutaabbi, mulabba na? ");
INSERT INTO dov_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Nywebo nimwaamba kuti utachiti mamambi, mulachita mamambi na? Nywebo nimusesemwa mitumi, mulabbida matempele na? ");
INSERT INTO dov_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Nywebo nimulikankayizya mumulawu, mulamusampawula na Leza kwiinda mukusotoka mulawu? ");
INSERT INTO dov_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Nkaambo, “izina lya Leza liluubisigwa aakati kabaMaasi akaambo kenu,” mbuli mbuzyakalembwa. ");
INSERT INTO dov_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Nkaambo kupalulwa kuleempindu kulinduwe na waswiilizya mulawu, pele na koli sikusotoka mulawu, bupalulwe bwako ngabwaba kutapalulwa. ");
INSERT INTO dov_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Na, limo, muntu uutapalwidwe wabanya ziyandwa aamulawu, kutapalulwa kwakwe takukoyooboneka mbuli bupalulwe na? ");
INSERT INTO dov_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Alimwi ooyo uutapalwidwe takonzyi na kumubeteka na watobelezya mulawu? Oku nkukuti muli aamagwalo aalembedwe alimwi abupalulwe pele muchili basikusotoka mulawu! ");
INSERT INTO dov_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Nkaambo tensi uubanguwe mwinimwnini kuchiwa chaanze; nikuba bupalulwe oobo buli aanze buyo munyama. ");
INSERT INTO dov_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Pele muJuda ooyo uuli aabwamukati, alimwi abupalulwe bwamumoyo, mu Muya, pe pe mumalembe. Bulumbo bwamuntu uuliboobu tabuzwi kumuntu pe pesi kuliLeza. ");
INSERT INTO dov_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Alyobo mbobuli bubotu maJuda mbubalabo? Mpawo ninzi mpindu yakupalulwa? ");
INSERT INTO dov_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Nchipati munzila zyoonse kumatalikilo, baJuda bakasyomezegwa achiyubunuzyo kuzwa kuliLeza. ");
INSERT INTO dov_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ino kwalinolibiyeni ansinga bamwi baJuda te bakalalusyomo? Sena kutasyomeka kwabo kuyo lesya busyomesi bwaLeza na? ");
INSERT INTO dov_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Takwelede kuba akube kuti Leza ajanike kali kasimpe, nekuba kuti muntu woonse ulabeja. Mbuli mbukwakalembedwe, “ Ukonzya kuti kutondezya kululama kwindila kumajwi akwe, mpawo ukakonzye kuzunda muchindi niwakusika mulubeta.” ");
INSERT INTO dov_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Pesi kuti kutalulama kwesu kutondezya bululami bwaLeza, chinzi chitunga tulamba? Nga tulamba kuti Leza taluleme na weta bukali bwakwe alindiswe? Ndokubelesya muzezo wabuntu. ");
INSERT INTO dov_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Te mbukwelede pe! Mbubuli mpawo Leza mbwayobeteka nyika? ");
INSERT INTO dov_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Pesi kuti isimpe kuliLeza ikwinda mukubeja kwangu kuyungizizya bulemu, nkambonzi me nichili mukubetekwa mbuli sizibi. ");
INSERT INTO dov_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Nkambonzi nitutatedi mbuli mbutuli basikubisya mbulikwamba mbulibamwi mbubasinizya echo nchibamba, “atuchite zibi kuti bubotu busike?” Mpawo kubisya kwabo kuliluleme. ");
INSERT INTO dov_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Mpawo ninzi? Sena tulokulitantamuna na lwesu? Pe tembubo pe. Nkambo mbubonya mutwatamikizigwa kubaJuda abaGiliki boonse lwabo, ikuba ansi aachindi. ");
INSERT INTO dov_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Eechi chilimbuli mbukulembedwe, “Takwe umwi ululeme, nikuba umwi. ");
INSERT INTO dov_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Takwe naba umwi umvwisya. Takwe naaba umwi ulangulana aLeza. ");
INSERT INTO dov_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Boonse bapambuka, boonse bababatachikwe lugwasyo. Takwe naaba umwi uchita chibotu, pe naaba umwi.” ");
INSERT INTO dov_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Kameneno kabo nkabanda kajulikide. Indimi zyabo nzyenwa, ibusaki bwanzoka buli munsi amilomo yabo. ");
INSERT INTO dov_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Yabo milomo ilizwide intuko akunyema. ");
INSERT INTO dov_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Mawulu abo afwambanina kutila bulowa. ");
INSERT INTO dov_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Lunyonyoko amachise alimunzila zyabo. ");
INSERT INTO dov_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Aaba bantu tebakanaziba pe inzila yalumuno. ");
INSERT INTO dov_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Takwe pe buyofu bwaLeza mumeso abo.” ");
INSERT INTO dov_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Lino tulizi kuti kufumbwa mulawu nzuwamba wambula kuli baabo balansi amulawu. Echi chibambilidwe kuti yoonse milomo yelede kuti ijalwe ayoonse nyika mbiyopegwa kuli Leza. ");
INSERT INTO dov_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Echi nkambo kakuti takwe nyama niyolulamikwa akwinda milimo yamulawo akumenso akwe. Aboobo kwinda mumulawu kwaza luzibo lwachibi. ");
INSERT INTO dov_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Pesi lino kuzwa kumulawu wabululami bwaLeza bwayubununwa. Chakazuminwa kumulawu abansinsimi, ");
INSERT INTO dov_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","nkukuti bululami bwaLeza kwindila mulusyomo muli Jesu Kkilisito kuli boonse abo basyoma. Mbuli mbukutakwe musiyano. ");
INSERT INTO dov_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Nkambo boonse bakabisya akulelwa kusikila kubulemu bwaLeza. ");
INSERT INTO dov_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Alimwi bakalulamikwa chantanganana kuluzyalo lwakwe kwinda mulwangunuko luli muli Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Nkambo Leza mbakapa Kkilisto mbulichiswanisyo kwindila mulusyomo mubulowa bwakwe. Wakapa Kkilisito mbuli chitondezyo chabululami bwakwe. Nkambo kwakutayeya kwakwe zibi zyakinda. ");
INSERT INTO dov_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Mubulangilizi bwakwe ezi zyoonse zyakachitika kukutondezya bululami bwakwe kuchindi nchicho echino. Ezi zyakachitilwa kuti alibonye kuti ulisalede, akutondezya kuti ulalumbika kufumbwa muntu nkambo kalusyomo muliJesu. ");
INSERT INTO dov_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Mpo nkuli kulikankayizya. Tachimvwelene pe. Kwiinda kululi mulawu? Milimu ili? Pe, pesi kwiindilila mumulawu walusyomo. ");
INSERT INTO dov_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Swe tumanisizya kuti muntu ulalulamikwa alusyomo katakwe milimu yamumulawu. ");
INSERT INTO dov_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Sena kuti Leza nguLeza wabaJuda kupela na? Alubo tali nguwe na Leza wabaMasi? Iyii, ngwabaMasi lubo. ");
INSERT INTO dov_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Iyii chonzyo Leza ngumwi, uyolulamika bupalulwe alusyomo, abatapalwidwe kwiindila mulusyomo. ");
INSERT INTO dov_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Nga tulawukasya na mulawu kwindila mulusyomo? akube kuti kutachitiki obo, pesi atusumpule mulawu. ");
INSERT INTO dov_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tulatyeni kuti Abbulahamu, ndeende sikale wesu munyama, wakajanaanzi? ");
INSERT INTO dov_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Nkaambo na Abbulahamu wakatambulika amilimu, nikuli uli aachakulidundiizya aacho, pele pe pe kunembo lyaLeza. ");
INSERT INTO dov_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Lino malembe atyeni? “Abbulahamu wakasyoma Leza, aboobo chakatolwa mbuli bululami kulinguwe.” ");
INSERT INTO dov_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Lino kuli wooyo uubeleka, muholo wakwe tuubalwi mbuli chipo pe, pele mbuli chikwelete. ");
INSERT INTO dov_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Pele kuli wooyo uubeleka pele kasyoma muli wooyo uululamika batakwe bunaLeza, lusyomo lwakwe lubalwa mbuli bululami. ");
INSERT INTO dov_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Deviti alubo waamba chilongezyo kumuntu ooyo Leza ngwabalila bululami butakwe milimu. ");
INSERT INTO dov_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Wakati, “Balilongezegelwe aabo balekelelwa nchito zyabo zitali mumulawu, alimwi azibi zyabo zivumbidwe. ");
INSERT INTO dov_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ulilongezegelwe ooyo muntu Mwami ngwatabalili zibi.” ");
INSERT INTO dov_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Sa eechi chilongezyo chaambwa biyo kuli babo basibupalulwe, na kuti akuli babo batali basibupalulwe? Nkaambo twaamba kuti, “Lusyomo lwakabalilwa Abbulahamu mbuli bululami.” ");
INSERT INTO dov_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Wakalubalilwa biyeni? Aawo katana palulwa na, kana kuti musule akupalulwa, pesi katana palulwa. ");
INSERT INTO dov_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abbulahamu wakatambula chitondeezyo chabupalule. Echi chakali chisimyo chalusyomo ndwakalaabo katanapalulwa. Mpindu yachitondeezyo echi nkuti wakaba wisi wabaabo boonse basyoma, nikuba kabatanapalulwa. ");
INSERT INTO dov_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Echi chaamba kuti bululami bubalilwe kulinguwe. Alubo eechi chaamba kuti Abbulahamu wakaba wisi wabaabo bapalwide kulibaabombasike pe pe kuzwa kubapalulwe luzutu, pele alubo kulibaabo batobela nzila zya taata wesu Abbulahamu. Elyo oolu ndulo lusyomo ndwakalaalo katana palulwa. ");
INSERT INTO dov_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Nkaambo teensi kwiinda mumulawu pe chakapa kuti chisyomezyo chipegwe kuli Abbulahamu akulunyungu lwakwe, echi chisyomezyo kuti babe basimulyazina benyika. Pesi kwiinda mubululami bwalusyomo. ");
INSERT INTO dov_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Nkaambo na kuti aabo bapona mumulawu babambabo basimulyazina, lusyomo taluchaambi chintu, aboobo lusyom lwaba lwabuyo. ");
INSERT INTO dov_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Nkaambo mulawu weeta bukali, pele aawo atakwe mulawu, takwe bulewusi. ");
INSERT INTO dov_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Akambo kaaka echi chilachitika kwiinda mulusyomo, kuti chibe chaluzyalo. Akaako, chisyomezyo chibe chakasimpe kubana boonse. Alimwi boonse bana banoobikilizya pe pe luzutu bazi mulawu, pele alubo aabo bazwa kulusyomo lyaAbbulahamu. Nkaambo ngu taata wesu toonse, ");
INSERT INTO dov_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","mbulimbukulembedwe, “Ndakuchita wisi wamanyika miingi. “Abbulahamu wakali mubuliwo bwawooyo ngwakasyoma, nkokuti, Leza, uupa buumi kubafu alimwi wiita zintu zitawo kuti zibewo. ");
INSERT INTO dov_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nikuba wakasweenene azintu zilibuti, Abbulahamu wakasyoma Leza chakasimpe alyejunza. Akaako wakaba wisi wamanyika miingi, mbuli mbuzyakaambulwa, “Mazyalane aako mbayooba.” ");
INSERT INTO dov_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Takawizukide mulusyomo. Abbulahamu wakamvwisisisya kuti mubili wakwe tuchikonzyi kuchita mwana (nkaambo wakali waamba kusisya myaaka ili mwaanda). Alimwi wakazumina kuti bula bwaSala tabuchikonzyi kuzyala mwana. ");
INSERT INTO dov_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Pele akaambo kachisyomezyo chaLeza, Abbulahamu taakwe naakatazumbuuzya mukutasyoma. Pesi, wakasimisigwa mulusyomo alimwi wakapa bulemu kuliLeza. ");
INSERT INTO dov_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Wakakutisika loko kuti ezyo Leza nzyakasyomezya, ulakonzya kuzuzikizya. ");
INSERT INTO dov_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Akaako zyakabalilwa lubo kulinguwe mbuli bululami. ");
INSERT INTO dov_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Lino tezyakalilembedwe luzutu pe kukukutisya lwakwe mwini, zyakabalilidwe kulinguwe. ");
INSERT INTO dov_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Zyakalembelwa ndiswe alubo, nkuziyoobalilwa, iswe nitusyoma muliwooyo wakabusyaJesu Mwami wesukuzwa kubafu. ");
INSERT INTO dov_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Oyu nguwe wakaabwa akaambo kazibi zyesu alimwi wakabusigilwa kukululamikwa kwesu. ");
INSERT INTO dov_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Mukuti tululamikwa alusyomo, tuli aalumuno aLeza kwiindila muMwami wesu Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kwiindila mulinguwe tulanjana manjililo mulusyomo kunjila muluzyalo lwakwe oomo mutwiimvwi. Tulabotelwa mubusichaamba Leza mbwakatupa kuchitila lyejunza lyesu, busichaamba mbututakaabane mubulemu bwaLeza. ");
INSERT INTO dov_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Kakutali oobo luzutu, pele tulapakala alubo mukupenzegwa kwesu. Tulizi kuti kupenzegwa kweeta lukakatilo. ");
INSERT INTO dov_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Lukakatilo lweeta kutambulika, alimwi kutambulika kweeta musichaamba bwalyejunza. ");
INSERT INTO dov_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Busichaamba oobu tabufwisyi nsoni, nkaambo luyando lwaLeza lwakatulidwa mumyoyo yesu kwiinda muMuuya Uusalala, wakapegwa kulindiswe. ");
INSERT INTO dov_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Aawo nitwakatalikwe manguzu, muchiindi cheelede Kkilisito wakafwida batasalali. ");
INSERT INTO dov_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Nkaambo nchiyumu kufwida muntu uululeme. Kuti, amwi wumwi ulakonzya kufwida muntu uululeme. ");
INSERT INTO dov_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Pele Leza ulatondeezya luyando lwakwe kulindiswe, mukuti nitwakachili basizibi, Kkilisito wakatufwida. ");
INSERT INTO dov_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Mubwiingi, elyo, mukuti twakalulamikwa abulowa bwakwe, tuyofutulwa kubukali bwaLeza. ");
INSERT INTO dov_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Nkaambo na, nitwakachili basinkondonyina, twakabwedeezegwa kuliLeza kwiinda mulufu lwaMwana wakwe, mukuyungizya, nitwakabwedezegwa, tuyoofutulwa abuumi bwakwe. ");
INSERT INTO dov_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Nikutali boobu luzutu, pele tulabotelwa muliLeza alubo kwiinda muMwaami wesu Jesu Kkilisito, ooyo kwiinda mulinguwe mutwakatambula kuswaanizigwa. ");
INSERT INTO dov_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Eelyo, mbuli chibi mbuchakanjjila kwiinda mumuntu womwe munyika, munzila eeyi lufu lwakanjila kwiinda muchibi. Alimwi chibi chakeendelela kubantu boonse, nkaambo boonse bakabisya. ");
INSERT INTO dov_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Nkaambo kusikila ku mulawu, chibi chakali munyika, pele takwe kwaambwa kwachibi pe na kakutakwe mulawu. ");
INSERT INTO dov_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Akaako, lufu lwakeendelezya kuzwa kuli Adamu kusikila kuli Mozesi, nikuba aatala ababo bakatabisya pe mbuli kutaswilila kwa Adamu, wakali chitondezyo chawooyo uuchizoosika. ");
INSERT INTO dov_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Nikuba boobo, chipo tachili mbuli mulandu pe. Nkaambo na akubisya kwawumwi biingi bakafwa, mbombubo luzyalo lwaLeza mbulwakachita alimwi chipo chaluzyalo chamuntu womwe, Jesu Kkilisito, chakavulila biingi. ");
INSERT INTO dov_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nkaambo chipo tachili mbuli mpindu yawooyo wakabisya. Nkaambo kulilimwi bbazu, lubeta lwamulandu lwakaza akaambo kachibi chamuntu omwe. Pele kulilimwi bbazu, chipo chaangununa chakaza musule kwazibi zyiingi. ");
INSERT INTO dov_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Nkaambo na kuti, akubisya kwawumwi, lufu lwakeendelezya kwiinda kuliwumwi, elyo kuli baabo batambula bwiingi bwa luzyalo alimwi achipo chabululami beendelezegwa kwiinda mubuumi bwawumwi, Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Nkokuti, chibi chomwe mbuchakeetelezya kutatambulika kwabantu boonse, nkokuti alimwi kwiindila munzila yomwe yabululami kwakaza kululamikwa abuumi kubantu boonse. ");
INSERT INTO dov_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Nkaambo mbuli mukwiinda mubulewusi bwamuntu omwe mbiingi bakaba basizibi, mbombubo, alimwi kuti kwiindila mubululami bwamuntu omwe kuyoolulamikwa biingi. ");
INSERT INTO dov_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Pesi mulawu wakazida kuyungizya bulewusi, pesi aawo chibi mpuchakavula, luzyalo lwakavula kwiindilila. ");
INSERT INTO dov_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Eezi zyakachitilwa kuti, ichibi mbuchakeendelezya mulufu, mbombubo luzyalo mbuluyooyendelezya kwiindila mubululami bwabuumi butamani kwiindila muli Jesu KkilisitoMwaami wesu. ");
INSERT INTO dov_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Twambe buti? Tunochinkilila anembo na akubisya kuti luzyalo lukayindilile kuvula? ");
INSERT INTO dov_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Takwelede kuba obo pe. Iswe nitwakafwa kuchibi, tunochikonzya buti kuchinopona kulinchicho. ");
INSERT INTO dov_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Tamuzi na kuti mbuli bingi mbubakabbabbatizigwa muliKkilisto Jesu bakabbabbatisigwa mulufulwakwe. ");
INSERT INTO dov_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Twakavwikwa, alimwi, anguwe kwinda mulubbabbatizyo amulufu. Ezi zyakachitika nkambo kakuti Kkilisto wakabusigwa kuzwa kubafu mubulemu bwawisi, kuti aswebo tweende mubumi bupya. ");
INSERT INTO dov_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Kuti twaba abujatane muchikozyano chalufu lwakwe, aboobo tatukoyoba abujatane mububuke bwakwe kubafu. ");
INSERT INTO dov_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tulizi ezi, kuti muntu wesu mukulukulu wakabambulwa anguwe kuti mubiliwazibi ukonzye kulobesegwa. Ezi zyakachitika kuti tutachibi bazike bachibi. ");
INSERT INTO dov_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Oyoo wakafwa wakambwa kululama kumulandu wachibi. ");
INSERT INTO dov_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Pesi kuti twakafwa aKkilisito, tulasyoma kuti tuyokkala antomwe anguwe. ");
INSERT INTO dov_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Tulizi kuti Kkilisito mbakabusigwa kuzwa kubafu, takonzyi kufwa lubo pe; lufu taluchikwe bwami pe alinguwe. ");
INSERT INTO dov_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Nkabela mukujatikizya mulufu ndwakwafwa kamwi kwalyoonse. Nekuba boobo, buumi mbwapona uponena Leza. ");
INSERT INTO dov_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Munzila ikozyene, anywebo mweelede kulibweza mbuli bafwide kuchibi, pesi baponede kuli Leza muliJesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Aboobo mutalekeli chibi kuti chimwendelezye mumibili yanu ifwika mutakasiki nkumulemeka zisusi zyanyama. ");
INSERT INTO dov_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Mutaabili zizo zyaanu kuchibi, kuti zibe zibelesyo zyakuchita bubi. Pele amulitondezye kuli Leza mbuli aabo bakeetwa kuzwa kulufu kuya kubuumu, amutondezye zizo zyanu kuliLeza mbuli zibelesyo zyakuchitya bululami. ");
INSERT INTO dov_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Mutazumini chibi kuti chimwendelezye. Nkambo nywe tamuli munsi amulawu pe, pesi munsi aluzyalo. ");
INSERT INTO dov_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Twambe buti lino? Tulakonzya kubisya na nkambo tatulimunsi amulawu, pesi munsi aluzyalo? Kutakabi boobo pe. ");
INSERT INTO dov_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Sa tamuzi na kuti naa mwalitondezya mbuli bazike mulibazike kuliyooyo ngomulemeka? Mukonzya kuba bazike kuchibi, chitola kulufu, naanka bazike kululemeko lutola kubululami. ");
INSERT INTO dov_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Pesi kupa kulumba kuliLeza! Nkambo mwakalibazike bachibi, pesi mwakalemeka kuzwa kumyoyo inzila yanjisyo eyo njimwakapegwa. ");
INSERT INTO dov_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mwakangununwa kuzwa kuchibi akuchitwa balanda mubululami. ");
INSERT INTO dov_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ndambula mbuli muntu nkambo kabukompami bwanyama zyanu. Mbuli mbumwaka tondezya zizo zyanu mbulibazike kubusofwazi akubusendami kachizyala kubusendami kwindilililede, munzila imwi biyo, lino mutondezye zizo zyanu mbuli bazike kubululami akukusalazigwa. ");
INSERT INTO dov_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Nkambo nimwakachili bazike bachibi, mwakalangunukide kuzwa kubululami. ");
INSERT INTO dov_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Kuchindi echo njili michelo eyo njimwakali ayo kuzintu zikonzya kumufwisya bweeme? Nkambo mamanino azintu eezi ndufu. ");
INSERT INTO dov_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Pesi lino mbulimbumwakangununwa kuzwa kuchibi akuba bazike kuli Leza, mula michelo yanu yakusalazigwa. Impindu mbumi butamani. ");
INSERT INTO dov_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nkambo mpindu yazibi ndufu, pesi chipo chaLeza mbumi butamani muliKkilisto Jesu Mwami wesu. ");
INSERT INTO dov_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Nikuba bobo tamuzi na, nobakwesu ( nkambo ndokwambuula kubantu abo bazi mulawo), kuti mulawo ulatonga kumuntu kufumbwa chiindi nchapona? ");
INSERT INTO dov_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Nkambo mwanakazi ukwetwe ulangwa amulawu kumulumi chiindi napona, pesi kuti mwalumi wafwa, ulangununwa kuzwa kumulawo wakukwatwa. ");
INSERT INTO dov_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Alubo, chindi mwalumi wakwe nachipona, kuti wakukwatwa awumbi mwalumi, uyowambwa kuti ngusimamambe. Pesi kuti mwalumi wakwe wafwa, wangunuka kuzwa kumulawo, alubo tanoli simamambe pe, kuti wakwatwa awumbi mwalumi. ");
INSERT INTO dov_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nkiinkako, nobakwesu, mwakachitwa alimwi mwakafwa kumulawo kwinda mumubili wa Kkilisito. Ezi zilobo kuti mukaswanizigwe kuli umbi, nkukuti kuli oyo wakabusigwa kuzwa kubafu, kuchitila kuti tube amuchelo wa Leza. ");
INSERT INTO dov_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nkambo nitwakali munyama, chiyandisyo chazibi, chibusigwa a mulawo, chakali a mulimo muziizo zyesu kukuzyala muchelo walufu. ");
INSERT INTO dov_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Pesi lino twakangununwa kuzwa kumulawu. Twakafwa kuli echo nchitwakangidwe. Echi chilibobu kuti tukabelekele mubupya bwa Muuya alimwi kutali mubukulukulu bwalugwalo. ");
INSERT INTO dov_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Tulatyeni kabi? Mulawo imawo mubina? Kutabi bobo. Nikubabobo, tendali kunoziba chibi, nikwatanoli kwinda mumulawo. Nkambo ndanoli nkintazi ibbivwe kutali kuti mulawo wakamba, “Mutabi abbivwe.” ");
INSERT INTO dov_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Pesi chibi chakabweza mwenya mukwinda mumalayilile alimwi akweeta bbivwe mulindime. Kuti kakutakwe mulawo, chibi chilifwide. ");
INSERT INTO dov_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kuli chimwi chiindi ndakali kupona katakwe mulawo, pesi elyo malayile nakasika, chibi chakajana lubo buumi, alimwi ndakafwa. ");
INSERT INTO dov_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Malayilile ayo akayelede kweta buumi akasanduka aba lufu lwangu. ");
INSERT INTO dov_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Nkambo chibi chakabweza mwenya kwindila mumalayilile alimwi akandena. Kwindila mumalayilile chakandijeya. ");
INSERT INTO dov_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nkinkaako mulawo ulasalala, alimwi malayilile alasalala, bululami, alimwi bubotu. ");
INSERT INTO dov_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Nkinkako ezyo zibotu zyakabotu lufu na kulindime? Kutabi boobo. Pesi chibi, kuchitila kuti chikatondezegwe kuba chibi, chakazyala lufu muli ndime kwindila achecho chakali chibotu, alimwi kwindila amalayilile chibi chibe chibi loko kwinda mmwelo. ");
INSERT INTO dov_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nkambo tulizi kuti mulawo nguwa Muuya, pesi imebo ndimunyama. Ndakamuzigwa munsi abuzike kuchibi. ");
INSERT INTO dov_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ezyo nzindichita, tandizimvwisisisyi loko. nkambo nzinjanda kuchita, tandizichiti, alimwi ezyo nzizonda, ndachita. ");
INSERT INTO dov_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Pesi kuli ndachita nzitayandi, ndazuminana a mulawo kuti mulawo uliluleme. ");
INSERT INTO dov_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Pesi lino tokuchili ndime uzichita, pesi chibi echo chipona mulindime. ");
INSERT INTO dov_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Nkambo ndilizi kuti mulindime, echo chilimunyama, tamuponi chintu chabubotu pe. Nkambo chiyandisyo chabubotu buli mulandime, pesi tandikozichita pe. ");
INSERT INTO dov_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ezyo zibotu zindiyanda, tandizichiti, pesi ikuti mbuntayandi mbunchinta. ");
INSERT INTO dov_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Lino kuti ndachita nzintayandi kuchita, abobo takuchili ndime ulokuchita, pesi biyo chibi chikkala mulindime. ");
INSERT INTO dov_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Elyo, ndijana mulawu oyu, amo mpundiyanda kuchita kabotu, chibi mpuchili andime. ");
INSERT INTO dov_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Nkambo ndilakondwa mumulawo wa Leza amumuntu wangu wamukati. ");
INSERT INTO dov_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Pesi ndibona busiyene mulawo mumuzizo zyangu. Ulwisyanya a mulawo mupya mumiyeeyo yangu. Zindibweza ndibe muzike wamulawo muchibi muzizo zyangu. ");
INSERT INTO dov_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ndilimuntu umuside! Ngwani ulondinunula kuzwa kumubili wa lufu? ");
INSERT INTO dov_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Pesi kulumba ngakube kuli Leza kwinda muli Jesu Kkilisito Mwami wesu! Nkinkako, ime lwangu mbelekela mulawu wa Leza amwi a miyeyo yangu. Nikuba bobo, anyama yangu ndibelekela mulawo wachibi. ");
INSERT INTO dov_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Akaako lino takwe kupegwa mulandu kulibaabo bali muliKkilisito Jesu. ");
INSERT INTO dov_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Nkaambo mulawu wa Muuya wabumi muliKkilisito Jesu wamwangunununa kuzwa kumulawu wachibi a chalufu. ");
INSERT INTO dov_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Nakambo zyakatali kuchitwa amulawu mukuti wakalindizuzikide akaambo kanyama, Leza wakachita. Wakatuma Mwana wakwe mulombe muchikozyanyo chenyama yechibi kuzooba chipo chachibi, alimwi wakapa mulandu kunyama. ");
INSERT INTO dov_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Wakachita echi kuchitila kuti ziyanda mulawu zikonzye kuzuzikizigwa mulindiswe, iswe nitweenda pe pe munyama, pele mbuli mumuya. ");
INSERT INTO dov_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Aabo bapona chenyama babika miyeeyo yabo kuzintu zyenyama, pele aabo bapona mbuli muMuuya babika miyeyo yabo kuzintu zyaMuuya. ");
INSERT INTO dov_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Nkaambo miyeeyo iibikidwe kunyama ndufu, pele miyeyo iibikidwe kumuuya mbuumi a lumuuno. ");
INSERT INTO dov_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Miyeeyo iibikidwe kunyama ilakalala kunembo lyaLeza, nkambo tiilifwinsyi kumulawu waLeza, nikuba kukonzya kuchita oobo. ");
INSERT INTO dov_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Aabo balimunyama tabakonzyi kubotezya Leza. ");
INSERT INTO dov_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Nikubaboobo, tamuli munyama pe pele mu Muuya, na umwi katakwe muuya katakwe muuya wa Kkilisito tewakwe pe. ");
INSERT INTO dov_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Na Kkilisito ulimulindime, mubili ulifwide kukulemeka kuchibi, pele muuya uliponede ku mubululami. ");
INSERT INTO dov_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Na Muuya wawooyo wakabusya Jesu kuzwa kubafu ukala mulindinywe, ooyo wakabusya Kklsito kuzwa kubafu uyomupa buumi alimwi kumibili yenu iifwa kwiinda mu Muuya wakwe, uupona mulindinywe. ");
INSERT INTO dov_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Elyo lino, nobakwesu, ndiswe basikukweleta, pele pe pe kunyama kunyama kuti tupone kunyama. ");
INSERT INTO dov_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Akaako na mwapona chenyama, mwaambakufwa, pele na aMuuya mubika mubili kumilimu yalufu, muyopona. ");
INSERT INTO dov_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Nkambo mbuli biingi mbubazulwidwa aMuuya wa Leza, abambabo bana ba Leza. ");
INSERT INTO dov_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Temwakatambula muuya wabuzike kuti mupone mukuyowa limbi; pele mwakatambula Muuya wabwana, anguwo mulompolola kuti, “Abba, Taata!” ");
INSERT INTO dov_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Muuya wakwe wazuminana a Muuya wesu kuti tulibana ba Leza. ");
INSERT INTO dov_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Na kuli bana, banakukalya, banakukalya ba Leza. Alimwi tuliswanizigilwe a Kkilisito, na nchoonzyo tulafwabisigwa antomwe anguwe kuti tukakonzye kulemekwa antomwe anguwe. ");
INSERT INTO dov_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Nkambo ndayeya kuti machise achiindi achino tayelene abulemu buyotondezegwa kulindinywe. ");
INSERT INTO dov_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Nkambo bulangizi bupati bwazilengwa bulilindide kutondezegwa kwabana ba Leza. ");
INSERT INTO dov_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Nkambo bulengwa bwakasampawulwa, pepe mukuyanda kwabo, pele akambo kayoyo wakazichita, mubulangizi. ");
INSERT INTO dov_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","bwakuti bulengwe bwini buyogwisigwa kuzwa kubuzike kuya kukunyonyonyoka, alimwi kuti bayoyetwa mulwangunuko lwabulemu bwabana ba Leza. ");
INSERT INTO dov_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nkambo tulizi kuti zilengwa zyoonse zilalila kapati akubeleka mubuchise antomwe nikubalino. ");
INSERT INTO dov_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Kutali echo luzutu, pesi aswebo tobeni, nituli akabalwe balwe ka Muuya, tulalila kapati mukati kesu, awo nituyolinda chabulangizi kukuchitwa kwesu bwana, kwangununwa kwamibili yesu. ");
INSERT INTO dov_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Nkambo mubulangizioobu twakafutulwa. Nkambo ngwani uulangilila nchatabwene? ");
INSERT INTO dov_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Pele tulangilila eecho nchitutabwene pe, tulachilindila chakukazika moyo. ");
INSERT INTO dov_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Munzila iliboobo, eelyo Muuya ulatugwasizya munkompami zyesu. Nkambo tatuzi pe mbutweelede kukomba, pele Muuya mwini ulatukombelezezya amajwi atambiki. ");
INSERT INTO dov_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Oowo ulingula moyo ulizi miyeyo ya Muuya, mukuti ulatukombelezezya mukwiminina basalali ba Leza mbuli mukuyanda kwa Leza. ");
INSERT INTO dov_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tulizi kuti kulibabo bayanda Leza, ubeleka zintu zyoonse aantomwe kumubotu, kulibaabo bayitidwe kumakaanze akwe. ");
INSERT INTO dov_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Nkambo aabo mpakazi kale wakabambila kuti bakendelane abuboneke bwa Mwana wakwe, kuti akabe mwana mutanzi akati kabakkulana biingi. ");
INSERT INTO dov_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Aabo mbakakanzila, aba wakabayita alimwi. Aabo mbakayita, wakabasalazya. Aabo mbakasalazya wakabalemya. ");
INSERT INTO dov_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Lino tutyeni azintu eezi? Na Leza kaliwesu, ngwani uutukatazya? ");
INSERT INTO dov_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ooyo wakatakasya Mwana wakwe pele wakamwabila ndiswe toonse, uyoleka buti alubo kuti akatupe zintu zyoonse mulinguwe chakwangunuka. ");
INSERT INTO dov_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ngwani utakeete intuko aatala abasale ba Leza? Leza nguwe uululamika. ");
INSERT INTO dov_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ngwani uupa mulandu? Kkilisito Jesu nguwe wakafwa - kwinda oobo, wakabisgwa - uuli kuchilisyo cha Leza, alimwi uuli kutukombelezezya. ");
INSERT INTO dov_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ngwani utakatwanzanye kuluyando lwa Kkilisito? Nkupenzegwana? kubulikilwa na, kusukusigwa, na nzala, na kwenda maya, na ntenda, na nipanga? ");
INSERT INTO dov_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Mbuli mbukulembedwe, “Akambo kakujanina kwenu tulajayigwa buzuba boonse. Twakachitidwe mpuli mbelele iyanda kuyojayigwa.” ");
INSERT INTO dov_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kulizyonse ezi zintu tulibazundi kwiinda muliwoyo iwakatuyanda. ");
INSERT INTO dov_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Nkambo ndakazibisigwa kuti nikuba lufu, nikuba bunini, nikuba bangelo, nikuba basinsimi nikuba zintu ziliwo, nikuba zizosika, nikuba munguzu, ");
INSERT INTO dov_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","nikuba bulamfu, nikuba bunike, nikuba chintu chakalengwa, chiyokonzya kutwaanzanisya kuzwa kuluyando lwa Leza, luli muli Kkilisito Jesu Mwami wesu. ");
INSERT INTO dov_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ndamwambila kasimpe muliKkilisito. Nsilokubeja pe, amamvwido angu alazuminana andime muMuuya uSalala. ");
INSERT INTO dov_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Izyakuti mumoyo wangu mulikuusa kupati akuchisa kutamani. ");
INSERT INTO dov_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nkambo ndalikuyanda kwanzanisigwa aKkilisito kuti ndibe mutuke akambo kabakweu, anzubo nzyangu zyamunyama. ");
INSERT INTO dov_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Mba Izilayeli. Bakabweza, bulemu, zizuminano, achipo chamulawu, abukombi bwamung'anda yaLeza, azisyomezyo. ");
INSERT INTO dov_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Bamataata babo chiindi kwakazwa Kkilisto, kwiinda munyama - we kali Leza atala zyoonse. weelede kulumbayizigwa mane kutamani. Ameni. ");
INSERT INTO dov_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Pele twakamba kuti ijwi lyaleza lyakalewulula. Nkambo boonse balimuIzilayeli te mbanaIzilayeli nchobeni. ");
INSERT INTO dov_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Nekuba loonse lunyungu lwaAbbulamu teensi mbana bakwe pe. Pele, muli Ayizeki muyowambwa lunyungu lwakwe. ");
INSERT INTO dov_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Nchikwaambwa kuti, bana banyama teensi mbana baLeza. Pele, bana bachisyomezyo mbawambwa mbuli lunyungu. ");
INSERT INTO dov_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Nkaambo eli ndijwi lyachisyomezyo: “Mulinchichechi chiindi ndiyosika, elyo Sala uyopegwa mwana.” ");
INSERT INTO dov_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Teensi mbubo luzutu, Pele alakwe Lebeka wakaba abula bwa mwalumi umwi, taata wesu Ayizeki - ");
INSERT INTO dov_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","bana kabatana zyalwa akutana chita chimwi chintu chibotu na chibi, kuti makanze aLeza kwindila mukusala bwiime, kutali akaambo kanchito, pele akaambo kayoyo uyita - ");
INSERT INTO dov_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","kwakambwa kuli nguw, “Mupati uyosanina munini.” ");
INSERT INTO dov_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Mbuli mbukulembedwe: “Jakkobo ndakamuyanda, pele Isawu ndakamusula.” ");
INSERT INTO dov_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Lino twambe buti? Sa kuli kutalulama kwaLeza? Takwe ziliboobo. ");
INSERT INTO dov_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Mbubobu mbaamba kuli Mozesi, “ Njomvwida luse kufumbwa ngunjomvwida luse, njoyetelela kuliyoyo ngunjoyetelela.” ");
INSERT INTO dov_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Aboobo tensi akaambo kayoyo uyanda, nekuba akaambo kayoyo uchijan, pele akaambo kaLeza, waluse. ");
INSERT INTO dov_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Mbobu malembe mbawamba kuliFalo akuti, “nchichecho nchindakakubusizya mumakanze akutondezya nguzu zyangu mulinduwe”, kuchitila kuti zina lyangu likambwe munyika yoonse. ");
INSERT INTO dov_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Mbubo leza ulaluse kulingwayanda akulingwayand, ulamuyumya moyo. ");
INSERT INTO dov_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Uyowamba chakuti kulindime, “ Nkaambonzi nachitongawuka? Ngwani ukonzya kukaka makanze akwe?” ");
INSERT INTO dov_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Omwalumi nduweni ukuzyana aLeza? Kulichibumbwa na chaamba kuli sikuchibumba, “Wabonayi! Niwandibumba ayeyi nzila?” ");
INSERT INTO dov_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Anu kuti mubumbi tajisi nguzu kubulongo bwakubumba chimbi chilongo chibotu achimwi chilongo chibi? ");
INSERT INTO dov_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Ani kuti Leza, wayanda kutondezya bukali bwakwe akuti ngunzu zyakwe zizibwe, wakakkazikila zilongo moyo mulamfu kubukali bwakabambilidwe kunyonyona? ");
INSERT INTO dov_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Nkutyeni nayanda kuzubula buvubi bwabulemu bwakwe kuzilongo zyaluse, nzyakambilide kale bulemu bwakwe kuzilongo zyaluse, nzyakambilide kale bulemu? ");
INSERT INTO dov_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ani kuti wachita obu akulindiswe, mbakayita, akati kamaJuda abamasi? ");
INSERT INTO dov_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Mbubonya mbwaamba muiHosiya kuti: “ Njoyita bantu bangu bakatali bantu bangu pe, akuyanda wakatali kuyandwa. ");
INSERT INTO dov_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Mpawo oko nkubakambilwa kuti, ' tamwensi bantu bangu; oko nkubayoyitwa kuti mbana baLeza muumi.'” ");
INSERT INTO dov_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ayizaya ulalila atala a Izilayeli, “Nekuba kumweele wabana ba Isilayeli nkubali mbuli musele wamulwizi, kuyoba kabela kabache bayofutulwa. ");
INSERT INTO dov_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Nkaambo Mwami uyochita makanze ajwi lyakwe munyika chakumanisizya achakunonoka. ");
INSERT INTO dov_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Akwambwa kwa Ayizaya kuti, “Mwami wamakamu - makamu tatusila lunyungu, netwali kunoba mbuli Sodomu, akuba mbuliGomola.” ");
INSERT INTO dov_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Lino nkutyeni, Bamasi, bakatali kuyandula bululami, bakabujana bululami bwalusyomo. ");
INSERT INTO dov_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Pele Isilayeli, walikuyandula mulawu wabululami, takwe nebakasika kumulawu. ");
INSERT INTO dov_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Nkaambonzi? Nkaambo tebakayandula chalusyomo, pele kumilomo yabo. Bakalebwa kuzwa kubbwe lyakabalebya. ");
INSERT INTO dov_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Mbuli mbukulembedwe, “Amubone, ndasitikizya muZayoni ibbwe lilebya amwala wamilandu. Oyo umusyoma takoyowusigwa bweme” ");
INSERT INTO dov_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Bakwesu, nchindiyanda mumoyo wangu akumukombelezya kuli Leza, ndufutuko lwako. ");
INSERT INTO dov_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nkambo ndilabukamboni atala ambabo bwakuti baliabusungu kuli Leza, pesi butali bwakuluzibo. ");
INSERT INTO dov_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Nkambo nchibakachilwa kumvwisisya bululami buzwa kwa Leza pele balikuyandula kutuchitila bululami bwabo beni, aboobo bakachilwa kulifwinsya kubululami bwa Leza. ");
INSERT INTO dov_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Nkambo Kkilisito ngonguwe uzuzikizya mulawu wabalulami bwabo boonse basyoma. ");
INSERT INTO dov_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Nkambo Mozesi ulalemba atala abululami obo buzwa kumulawu: “mwalumi uchita bululami bwamulawu uyobuponena bululami obo.” ");
INSERT INTO dov_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Pele bululami obo buzwa kulusyomo mbwamba obo: “mutaambi mumyoyo yanu kuti ngwani uyotanta kujulu? (ikuti, akeete Kkilisitu aansi) ");
INSERT INTO dov_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","; aboobo utambi kuti ngwani uyoselukila kubusena busiya (nkokuti akeete Kkilisitu kuzwa kubafu). ");
INSERT INTO dov_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Pesi chambanzi? “ijwi lili afwifwi anduwe lilimumulomo wako amumoyo wako” eli ndijwi lyalusyomo, eli ndijwi lyalusyomo elyo nditukambawuka. ");
INSERT INTO dov_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Nkambo kumulomo wako kulazumina kuti Jesu ngu Mwami, akusyoma kumoyo wako kuti Leza wakakubusya kuzwa kubafu, uyofutulwa. ");
INSERT INTO dov_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Nkambo kumoyo omwe kulasyomwa kuti kube bululami alimwi kumulomo omwe kulazuminikwa kuti kube lufutuko. ");
INSERT INTO dov_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Nkambo malembe alamba kuti, “koonse kusyoma mulinguwe wonse tayowusigwa nsoni” ");
INSERT INTO dov_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Nkambo takw ekusiyana akati kama Juda ama Giliki nkambo Mwami wabo nguMwami waboonse alubo ulabuvubi kuli abo bamwita. ");
INSERT INTO dov_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Pele boonse bayita zina lyakwe Mwami bayofutulwa. ");
INSERT INTO dov_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Bamwi bamwiite biyeni oyo ngubatasyomi? Bamusyome biyeni oyo ngubatana kumvwa? Bamvwe biyeni katakwe katakwe sikukambawuka? Bakambawuke biyeni kuti tebatumwa? ");
INSERT INTO dov_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Mbubonya mbukulembedwe, “abota mawulu ababo bakambawuka makani mabotu! ");
INSERT INTO dov_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Pesi tensi boonse baswilila makani mabotu. Nkambo Isaya ulamba, “Mwami ngwani wakasyoma mulumbe wesu?” ");
INSERT INTO dov_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Aboobo lusyomo lulazwa kukumvwa, alimwi kumvwa ijwi lyaKkilisitu. ");
INSERT INTO dov_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Pesi ndamba, “tebakamvwa na?” Iyii, mbubonya bangelo lwabo bakanjila munyika yoonse, alimwi majwi abo kumagolelo anyika” ");
INSERT INTO dov_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Kukuyungizya ndaamba, “Izilayeli takazi na? “Lutanzi Mozesi wamba kuti, “njokusungilizya kubuzuba azitali chisi. Anzila yachisi chitakwe kumvwisisisya, alimwi njokukopakopa kusikila ukanyeme”. ");
INSERT INTO dov_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Alimwi Izaya ulamba chabukozu kuti, ndakajanwa ababo bakatandiyandula. “Ndakaboneka kuli abo batakandikumbila” ");
INSERT INTO dov_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Pesi kuli Izilayeli uwambakuti, “izuba lyoonse ndakatambika maanza angu kulibataswilili akubantu bataswilili”. ");
INSERT INTO dov_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ndamba kuti, ino Leza wakabakaka na bantu bakwe? Takukwe nichitabi boobo. Nkaambo ambe ndili munaIzilayeli, silunyungu lwaAbbulahamu, wamukowa waBenjamini. ");
INSERT INTO dov_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Leza tewakaka bantu bakwe, mbakaziba kale. Tamuzi na malembe kuti atyeni aElija, mbakakombelezya Leza kubana Izilayeli? ");
INSERT INTO dov_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Mwami, bakajeya basinsimi bako, bakapwayila ansi zipayililo zyabo. Imebo andike ndime wakachaala, alubo balikuyandula bwangu bumi.” ");
INSERT INTO dov_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Pesi Leza nsandulo yake ityeni kulinguwe? “Ndakalibambila musanu ababili zyulu zyabalumi batana kutyola zwi kuli Bbaala.” ");
INSERT INTO dov_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nikuba obo lino, kuli chechino chiindi chasunu kuli bacheede akambo kakusalwa kwaluzyalo. ");
INSERT INTO dov_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Pesi na nzyakuluzyalo, tazichili zyakumilimu. Ateni luzyalo taluchike kuyoba luzyalo. Amwi malembe alabalwa pesi na zyitwa amilimu, mpawo tazichili zyaluzyalo; akutali kuti mulimu tuchili mulimu. ");
INSERT INTO dov_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Niyi lino? Chintu bana Izilayeli nchibayandula, nchibakatajana, abayingi bakayumisigwa. ");
INSERT INTO dov_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Chili mbuli mbuchilembedwe: “Leza wakabapa Muuya wabufubafuba, meso kuchitila kuti bataboni, a matwi kuchitila kuti batamvwi, kusika muli obuno buzuba.” ");
INSERT INTO dov_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Mpawo Davida wamba kuti, “Muleke tafula lyabo libe kanyandi akakole, lyakubaleba akubabeda chumyo kulimbabo. ");
INSERT INTO dov_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Muleke menso abo asizigwe kuchitila kuti bataboni, akutyola misana yabo lyonse.” ");
INSERT INTO dov_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ndamba, “Bakalebwa na kusikila kukuwa?” Chitakabi obo. Pele, achibi chabo, lufutuko lwasika kuli baMasi, kuchitila kuti basungilizigwe kubuzuba. ");
INSERT INTO dov_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Lino na chibi chabo mbuvubi bwakunyika, na kuswekelwa kwabo mbuvubi bwabaMasi, buyoba bupati kukuzuzikizya kwabo? ");
INSERT INTO dov_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Pesi lino ndilikwambula kulindinywe nibaMasi, kufumbwa kuti kandili apositoli kuli baMasi, ndilalutangalo mumulimu wangu. ");
INSERT INTO dov_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Ateni ndilakusungilizya kubuzuba kulibabo bayangu nyama. Ateni twali kunofutuka bamwi babo. ");
INSERT INTO dov_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kuti kukaka kwabo kwamba kuyandana kwakunyika, kuyoba nzi kutambula kwabo pesi buumi kuzwa kubafwide? ");
INSERT INTO dov_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Kuti michelo mitanzi kayisalala, mbubede munsuma wachinkwa. Kuti muyanda kusalala, mbibede amitabi, ");
INSERT INTO dov_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Pesi na imwi mitabi yakakuzuka, na webo uli mutabi wamuOlifa wamusokwe, wakabikwa akati kabo, alubo na wakaabana ambabo mumuvubi bwamuyanda wamunsamu muOlifa, ");
INSERT INTO dov_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","mutakalikankayizyi atala amitabi. Pesi na mwalikaknkayizya, teensi ndinywe munyampula mayanda, pesi muyanda ngumunyampula. ");
INSERT INTO dov_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Muyowamba kuti, “Mitabi yakatyoka kuchitila kuti ndibike mukati.” ");
INSERT INTO dov_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Eyo ninchonzyo nkaambo kakutasyoma kwabo bakakuzuka, pesi muliima nji nkaambo kalusyomo lwanu. Mutayeyi loko atala andinywe, pesi akuyowa. ");
INSERT INTO dov_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Kuti na Leza takabika kulubazu mitabi yabube, takukwe mbayomu mbayobika kulubazu anywebo. ");
INSERT INTO dov_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Mulange, mpawo, zyiito zyabuya abuyumu bwaLeza: buyumu bwakasikila baJuda bakawa, pesi bubotu bwaLeza buza alindinywe na mwayendelela mubuya bwakwe. Atela anywebo muyogwisigwa. ");
INSERT INTO dov_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Alubo nikuba mbabo nikuba mbabo na tebendelela mukutasyoma kwabo, nkambo Leza ulakonzya kubabika alubo. ");
INSERT INTO dov_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Na mwakaligwisigilwe kuli zyabube bwamunsamu wamusokwe muOlifa, akukazyana abube bwakabikwa mumunsamu mubotu muOlifa, bayoba biyeni kuli eyi mitabi, bakabikwe lubo kumunyina muOlifa? ");
INSERT INTO dov_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Nkambo tandiyandi kuti mutabi batakwe luzibo, nibakwesu asinswa eyi, kuti mutakabi basongo mukuyeya kwanu. Kuyumya kumwi kwasikila Izilayeli kusikila mwelwe woonse wabamasi banjila. ");
INSERT INTO dov_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nkaako Izilayeli woonse uyokufutulwa, mbuli mbukulembedwe: “Kuzwa muZiyoni nkwayozwa munununi. Uyogwisya kubula Leza kuzwa kuli Jakobe, ");
INSERT INTO dov_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","alimwi eechi chiyoba chizuminano ambabo, nintakagwisye zibi zyabo.” ");
INSERT INTO dov_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Mbuli makani mabotu mbalangide, mbasinkondonyokwe kuchitila ndinywe. Pesi mbulilusalo mbolubede, baliyandidwe akaambo kaba similimu bakale. ");
INSERT INTO dov_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Nkaambo zipego akwiitwa kwaLeza tazisanduliki. ");
INSERT INTO dov_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Mbuli mbumwakali bataswilili kuli Leza, lino mwatambula luse akambo kakutaswilila kwabo. ");
INSERT INTO dov_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Munzila njiyonya eyo, lino aba baJuda bakaba bataswilili. Mpindu yakali yakuti aluse lutondezedwe kulindinywe bakatambula luse alubo. ");
INSERT INTO dov_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Nkaambo Leza wakazijalila zyoonse mukutaswilila kuchitila kuti atondezye luse kuli bonse. ");
INSERT INTO dov_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Aah, kunika kwakuvubi antomwe bwabusongo a luzibo lwaLeza! Taziyanduuliki biyeni mbeteko, anzila zyakwe zyiinda kubbutula! ");
INSERT INTO dov_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Nguni wakaziba miyeeyyo yaMwami na nguni wakaba sikumuchenjezya? ");
INSERT INTO dov_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Na nguni wakatalika kupa chintu kuliLeza, kuti Leza amubwedezye?” ");
INSERT INTO dov_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Nkaambo kuzwa mulinguwe alimwi akwiinda mulinguwe alimwi akuli nguwe zyoonse zintu nkuzibede. Kulinguwe abube bulemu bwalyoonse. Amen. ");
INSERT INTO dov_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Aboobo ndamusungwazya, nibakwesu, muluzyalo lwaLeza, mutule mibili yanu, ibe chipayizyo chuumi, chisalala, chitambulika kuli Leza. Eeyi njimilimo yabukombe bwanu itambulika. ");
INSERT INTO dov_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Mutakozyanisigwi anchito zyanyika, pesi musanduke kukuchitulula kwamizeezo yanu. Amukachite eechi kuti mukazibe chibotu. Awumwi mbuli mweelwe walusyomo Leza ndwamupede. ");
INSERT INTO dov_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","nkambo kuluzyalo oolu ndundakapegwa me ndambila boonse bali akati kanu, mutalibiliki ajulu kwinda mpumubede, pesi mbubo kuti, yeeya chakubeteka mubululami, umwi mbuli mweelwe walusyomo oolo Leza ndwamupede. ");
INSERT INTO dov_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Mbuli mbutujisi zizo zijisi mulimu ukozyene. ");
INSERT INTO dov_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Munzila ikozyene, iswebo tubayingi tuli mubili umwi muli Kkilisito, akuba zizo zilyimikilila kuli chimwi achimwi. ");
INSERT INTO dov_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Tulijisi zipego zisiyenesiyene kwiinda muluzyalo ndutwakapegwa. ");
INSERT INTO dov_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Na chipeego chawumwi nchabusinsimi, ngachichitwe mbuli mweelwe walusyomo wakwe. Na chipego chawumwi nchakuwutawuka, amuleke akutawuke. ");
INSERT INTO dov_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Na umwi ulachipego chakuyiisya, amuleke ayiisye. Na chipego chawumwi nchakusungwazya, amuleke asungwazye. Na chipego chawumwi nchakupa, amuleke achichite chabusungu. Na chipego chawumwi nchakutondezya nsoni, amuleke achichitwe chakubotelwa. ");
INSERT INTO dov_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Luyando lutali lwakupawupa. Amusesemwe kububi; Mukakatile kuli cheecho chibotu. ");
INSERT INTO dov_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Atala aluyando lwabunyina, amubotelwe umwi awumwi. Atala abulemu, mulemekane umwi awumwi. ");
INSERT INTO dov_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Atala abusongo, mutabi batolo. Atala amuuya, mube achiyandisyo. Atala aMwami, atumubelekele. ");
INSERT INTO dov_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Amukondwe chakulangizi, amuyume mumapenzi. Amusyomeke munkombyo. ");
INSERT INTO dov_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Amwabane mukubula kubantu boonse baLeza basalala. Amuyandule nzila zyiingi zyakutondezya buuya. ");
INSERT INTO dov_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Amubalongezye aabo bamupenzya; Mulongezye alimwi mutatuki pe. ");
INSERT INTO dov_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Amukondwe aboobo bakondwe; Mulile abalila. ");
INSERT INTO dov_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Amube amuzeezo umwi kuli umwi awumwi. Mutaliyeeyi munzila zyakulisumpula, pesi mubatambule bantu balangilwa ansi. Mutabi basongo mumiyeeyo yanu. ");
INSERT INTO dov_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Mutabweedezyi chibi kuchibi. Muchite zintu zibotu mumeso abantu boonse. ");
INSERT INTO dov_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Na kachikonzeka kuti azibe kuli nduwe, kupona chalumuno abantu boonse. ");
INSERT INTO dov_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Mutabi lwanini nobayandwa, pesi amupe mweenya kubukali bwaLeza. Nkambo kulilembedwe kuti, “Kubweendezya nkukwangu, ndiyobweedezya mbwamba Mwami Leza.” ");
INSERT INTO dov_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","“Pesi na sinkondonyokwe waba anzala, musanine. Na waba anyota, mupe anywe. Ikuti na wachita oobo, ulalundika makala amulilo amutwe wakwe.” ");
INSERT INTO dov_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Utazundwi abubi, pesi zunda bubi abubotu. ");
INSERT INTO dov_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Muleke myuuya yoonse ilibombye kubweendelezi bulajulu, nkaambo bwendelezi buliwo bwakatondekwa aLeza. ");
INSERT INTO dov_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Aboobo oyo upapila bweendelezi ukkazya mulawu waLeza, alimwi abo bawupapila bayotambula lubeta beni. ");
INSERT INTO dov_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Kaambo beendelezi tabensi kuyoosya kumilimu mibotu, asi kumilimu mibi. Mulayanda kutaba abuyofu kuloyo ulimubweendelezi? Chita bubotu alimwi ulatambula bulumbu bwakwe. ");
INSERT INTO dov_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Kaambo mubelesi waLeza kulindinywe kububotu. Asi kuti wachita bubi, yoowa; kaambo tabwezi panga chabuyo. Nkaambo mubelesi waLeza, nguukwichizya bukali kulaabo bataluleme. ");
INSERT INTO dov_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Aboobo weelede kulibombya, kutali kuti kubukali, asi kaambo manjezezya. ");
INSERT INTO dov_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Kaambo kazezi mulabbadala mutelo kaambo beendelezi mbabelesi baLeza, mbembabo balanga ezi zintu zyoonse. ");
INSERT INTO dov_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Pa muntu woonse eezyo zimweelede: mutelo kulooyo weelede mutelo, bulumbu kulooyo weelede bulumbu, kuyowa kulooyo uuyowegwa, bulemu kulooyo uulemekeka. ");
INSERT INTO dov_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Mutabi achikwelete kumuntu, kunze kwakuyandana umwi kumwenzinyina, kaambo ooyo uuyanda ngwayakilene aawe uzuzikizya mulawu. ");
INSERT INTO dov_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Malayilile, “Utachiti mamambe, utajayi, utabbi, utabi ebbivwe,” alimwi kuti kakuli uumbi mulawu uliswanizizigwe muliwooyu, “Yanda ngoyakilene aawe mbuli nduwe.” ");
INSERT INTO dov_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Luyando taluchiti bubi kuli ngoyakilene aawe. Aboobo, luyando luzuzikizya mulawu. ");
INSERT INTO dov_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Kaambo kacheechi, mulizi chiindi, kuti chaba chiindi chakusinsimuka kuzwa mun'onzi. Kaambo lufutuko lwesu lwabaafwifwi kwiinda nkatusanguna kufutuka. ");
INSERT INTO dov_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Busiku bwiinka, alimwi buzuba bwabaafwifwi. Atubike kumbali milimu yamudima, alimwi atuzwaate zilwanyo zyamumuni. ");
INSERT INTO dov_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Atweende mbukweelede, mbuli sikati, pe pe mukupobweda kukkolwa kana bukolwi; alimwi tuteendi mubwaamu na muzisusi zibi, alimwi kutali munkondo na mubuzuba. ");
INSERT INTO dov_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Asi amuzwaate Mwaami Jesu Kkilisito, alimwi mutapi mweenya kunyama, kutazuzikizya zisusi zyayo. ");
INSERT INTO dov_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Tambula kufumbwa muntu mutete kulusyomo, kamutapi lubeta ataa akukazanya. ");
INSERT INTO dov_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Umwi muntu ulalusyomo kukulya kufumbwa, awumwi mutete ulya chisyu kupela. ");
INSERT INTO dov_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Oyo ulya zintu zintu zyoonse atanyansyi oyo utalyi; alimwi alakwe utalyi zintu zyonse atabeteki oyo ulya zintu zyoonse. Nkambo leza wamutambula. ");
INSERT INTO dov_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Nduweni, iwe nobeteka mulanda wawumwi? Ezi zilikuli simalelo wakwe nkwayimvwi kana kuwida. Asi ulakonzya kwima, nkambo Mwami ulamukonzyezya kuti amwimike. ");
INSERT INTO dov_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Umwi muntu ulalemya limwi zuba kwinda limwi. Awumwi ulalemya mazuba oonse mukwelene umwi awumwi ngabe akasimpe mumiyeyo yakwe. ");
INSERT INTO dov_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Oyo ubamba buzuba, ulibambila Mwami; alimwi oyo ulya, ulyida Mwami, nkambo upabulumbu kuliLeza oyo utalyi, ulikachizizya kulya nkambo kaMwami, akulumbayizya Leza. ");
INSERT INTO dov_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Aboobo takwe wesu uliponena mwini, alimwi takwe ulifwida mwini. ");
INSERT INTO dov_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Anu kuti nkatupona tuponena Mwami, alimwi kuti twafwa, tufwida Mwami. Ninsya nkatupona kana kufwa, tuli baMwami. ");
INSERT INTO dov_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Akaambo kazezi Kkilisitu wakafwa alimwi wakapona lubo, kuti abe mwami wabo boonse bafwide alimwi abaabo bapona. ");
INSERT INTO dov_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Asi nywe, kambonzi nimubeteka munyokwe? Alimwi nywe kambonzi nimunyansya munyokwe? Kaambo swe tuyoyima kuchuuno chalubeta chaLeza. ");
INSERT INTO dov_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Nkambo kulilembedwe, “Mbuli mbepona,”mbawamba Mwami, “ kulindime mazwi ayofugama, alimwi ndimi zyoonse ziyowamba kuliLeza.” ");
INSERT INTO dov_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Aboobo, umwi awumwi wesu uyopa makkani alangene anguwe kuliLeza. ");
INSERT INTO dov_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Aboobo, katutachibetekani, asi tuyeye ezi, kutabi ubika chilebyo kana kakole kumwenzinyina. ");
INSERT INTO dov_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ndilizi alimwi me ndasungilizigwa muMwamiJesu, kuti takwe chintu chisalala achilike. Kupela kuloyo uyeya kuti nchibi, kuloyo nchibi. ");
INSERT INTO dov_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ikuti nkambo kakulya munakwanu kula mutyola, tochendi muluyando. Utamujayi akulya kwako nkambo Kkilisitu wakamufwida. ");
INSERT INTO dov_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Kamutazuminini echo nchimuti nchibi chambwe bubi. ");
INSERT INTO dov_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Nkambo bwami bwaLeza tabwensi bwakulya na kunywa, pesi mbwabululami, lulumuno, alimwi akubotelwa muMuuya uSalala. ");
INSERT INTO dov_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Aboobo oyo ubelekela Kkilisitu munzila eyi ulatambulika kuliLeza alimwi ulazumininwa abantu. ");
INSERT INTO dov_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Aboobo, atusungwalile zintu zyalumuno alimwi zintu ziyaka umwi awumwi. ");
INSERT INTO dov_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Mutajayi mulimu waLeza kumakkani akulya. Zyoonse zisalala, asi nchibi kumuntu ulya kufumbwa chintu chilebya mwenzinyina. ");
INSERT INTO dov_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Tachili kabotu kuti ulye nyama, kana kunywa wayini, kana kuchita chintu chileba munyokwe. ");
INSERT INTO dov_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Lusyomo ndomulalo, alubambwe akati kanu aLeza. Ulilongezegwe oyo utapi mulandu kulecho nchazumina. ");
INSERT INTO dov_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Oyo udoneka ulalibeteka kuti walya, nkambo tachizwi kulusyomo. Alimwi choonse chitali chalusyomo nchibi. ");
INSERT INTO dov_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Lino swebo tubayumu twelede kunyampula bukompami bwabakompeme, alimwi tatwelede kulibotezya tubeni. ");
INSERT INTO dov_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Akube kuti umwi wesu abotezye simayake nyina nkambo nchibotu kuchita oobo. mukuti akakonzye kumuyaka. ");
INSERT INTO dov_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Nkambo mbubonya oobo Kkilisito mbwakatalibotezya lwakwe mwini. kunze kwakuti kube mbuli mbukulembedwe, “zitusi zyabaabo bakamutukide zyakawida alindime.” ");
INSERT INTO dov_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Kulizyonse zyakalembedwe zyakalembwa kuti zitupe malayilile ikuti kwinda mukusungwazigwa kwamalembe kuti tukabe abulangizi. ");
INSERT INTO dov_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Lino Leza wabuuya abusungwazi amupe muzeezo umwi awumwi mbuli muli Kkilisito Jesu. ");
INSERT INTO dov_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Amuchite eezi kuchitila kuti amuzeezo umwi mukonzye kulumbaizya amulomo umwi wa Leza ataata wamwana wesu Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Aboobo amutambule umwi awumwi, mbuli Kkilisito mbwakamutambula, mukuti Leza apegwe bulemu. ");
INSERT INTO dov_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Nkambo ndaamba kuti Kkilisito wakandichitya muzike wabupalule muchibaka chalusinizyo lwa Leza, mukuti tuzuminane zisyomezyo zyakapegwa basikale, ");
INSERT INTO dov_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","akuti bamasi bakalumba izya Leza muluzyalo lwakwe. Mbuli mbukulembedwe, “aboobo ndiyokutembawula akati kabamasi akwiimba ntembawuzyo kuzina lyako.” ");
INSERT INTO dov_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Alubo lilaamba kuti, “mubotelwa, nywebo nobamaasi, antomwe abantu bakwe.” ");
INSERT INTO dov_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Alimwi, alumbayizigwe Leza, moonse nobamaasi; akube kuti bantu boonse bamulumbayizye.” ");
INSERT INTO dov_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Alubo Isaya waamba kuti, “muyanda waJese uyosika, ooyo unyampuka akweende bamaasi. mulinguwe bamaasi bayooba abulangizi. ");
INSERT INTO dov_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Lino Leza wabulangizi, amuzuzye lukondo alumuno mukusyoma, ikuti munguzu zya Muuya Uusalala mukakkalile mubulangizi. ");
INSERT INTO dov_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Mebo ndemwini ndazuzikizigwa atala andinywe, nubakwesu. Ndazundikizigwa akuti nywebo nubeni muzwide bubotu, akuzuzikizigwa aluzibo loonse. Ndazundikizigwa alubo, kuti mulakonzya kulayilila amwi awumwi. ");
INSERT INTO dov_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Pesi ndamulembela chakumusungwazya kapati atala azimwi zintu mukuti ndikamuyeezye lubo, nkambo kaluzyalo ndundipedwea Leza. ");
INSERT INTO dov_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Eechi chipo chakali chakuti ndibe mulanda wa Kkilisito Jesu uyootumwa kulibamaasi, kuti ndikabe mbuuli mupayizi wamakani mabotu a Leza, kuti chipego chabamaasi chitambulikike, akusalazigwa a Muuya Uusalala. ");
INSERT INTO dov_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Muli Kkilisito Jesu ndilaacha kulikankayizya amuli mulimu wangu wa Leza. ");
INSERT INTO dov_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Pesi nsikonzyi kulitakata kwamba atala achimwi chintu kunze kwazezyo Kkilisito nzyakazuzikizya mulindime mukuswilizya mukuswilizya kwabamaasi. Ezi zintu ziitwa ajwi anchito, ");
INSERT INTO dov_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Kwinda munguzu zyazitondezyo azigambyo, alimwi anguzu zya Muuya. Ezi zyakaba kuzwa ku Jelusalemu, akuzyunguluka kusika ku Ililikkamu, kuti ndubweze bukwene mulimo wa Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Munzila eyi: chiyandisyo changu chalichakuti ndikanane makani mabotu, pesi kuteensi ooko Kkilisitu nkwakazibinkene azina, mukuti nditakayaki atala antalisyo yawumwi muntu. ");
INSERT INTO dov_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Zili mbuli mbuzilembedwe: kulibaabo batakalina kumvwa ataala azyanguwe bayomubona, abaabo batana kumvwa bayomvwisisisya. ");
INSERT INTO dov_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Abobo ndakakachizigwa kwazyindi zyiingi lokokuti ndisike kulindinywe. ");
INSERT INTO dov_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Pesi lino, tandichikwe busena pe mumasena aaya, alimwi ndali achiyandisyo kwamwaaka miinji kuboola kulindinywe ");
INSERT INTO dov_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Ndilangila kuzomubona ndazoyinda oko kandiya ku Sipeyini, alimwi akugwasigwa andinywe mulweendo lwangu lwakuza ooko, alubo ndakondelwa kubandinywe kwachiindi chinini. ");
INSERT INTO dov_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Pesi lino ndilikuya ku Jelusalemu, kandikutawukila bantu ba Leza basalala. ");
INSERT INTO dov_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Nkambo kwakalikubotezya kuti Makkedoniya a Akkaya kuchita tumwi tusanngisangi twabachete akati kabamwi bantu ba Leza basalala bakkala mu Jelusalemu. ");
INSERT INTO dov_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Iyi, iwakali lukondo lwabo, alubo bali achikwelete eechi kulimbabo. Nkambo na bamaasi bapa zipo zyabo zyamumuuya, nchikwelete kuba Juda kuti babalongezye azintu zijatika. ");
INSERT INTO dov_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Aboobo, kuti ndamaninsya mulimu ooyu akupedekezya muchelo ooyu kulimbabo, ndizoza ku Sipeyini kandinda kulindinywe kumuswaya. ");
INSERT INTO dov_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ndilizi kuti ndiyoza kulindinywe ndiyoza mukuzulila kwazilongezyo zyoonse zya Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Lino ndamusungwazya nobakulana, mu Mwami wesu Jesu Kkilisito, amuluyando lwa Muuya, kuti mukakatile antomwe andime munkombyo zyanukuli Leza kundikombela. ");
INSERT INTO dov_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Mukombe kuti ndikavunwe kuzwa kulibaabo bataswilizyi mu Judiya, akuti kubelekela Jelusalemu kwangu kukatambulike kubantu basalala ba Leza. ");
INSERT INTO dov_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Mukombe kuti ndboole kulindinywe mulukondo kwinda mukuyanda kwa Leza, alubo ikuti ime, antoomwe andinywe, tukajane kulyokezya. ");
INSERT INTO dov_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Akube kuti Leza walumuno abe anywebo. Ameni. ");
INSERT INTO dov_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Ndamutumina Foyebbe muchizi wesu, mubeleki wa mbungano lili ku Sinkile, ");
INSERT INTO dov_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","kuti mumutambule muMwami. Uzicheezi munzila yelede bantu baLeza basalala, alubo mumupe loonse lugwasyo ndwayanda kuzwa kulindinywe nkmbo wakali mugwasyi mupati kubiingi akulindiswe awalo. ");
INSERT INTO dov_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Juuzya Pulisila a Akwiyila, mubelesima muli Kilisito Jesu ");
INSERT INTO dov_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","nkambo kabuumi bwangu bakapedekezya buumi bwabo. Ndipa kulumba kulibaabo, kutali andikke; pesi alubo ambungano zyoonse zyabamaasi. ");
INSERT INTO dov_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Juuzya imbungano ilimun'anda yabo. Juuzya Epanetasi uyandwa wangu ulingomuchelo mutanzi waEzyiya kuli Kkilisito. ");
INSERT INTO dov_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Juuzya Maliya, wakakubelekela changuzu. ");
INSERT INTO dov_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Juuzya Andilonikkasi a Juniya, wakuluzubo lwangu, alimwi musungwama. Bakalizibikene loko kubatumwa, alubo bakali muliKkilisito imw nkesina. ");
INSERT INTO dov_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Juuzya Ampuliyatasi, muyandwa wangu muMwami. ");
INSERT INTO dov_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Juuzya Ubbanasi, babelekima muli Kkilisito, a Sitakkisi, muyandwi wangu. ");
INSERT INTO dov_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Juuzya Afelesi, utambwidwe muna Kkilisito. Ujuuzye boonse ben'anda ya Alisitobbulasi. ");
INSERT INTO dov_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ujuuzye Helodiyeni, wakuluzubo lwangu. Ujuuzye boonse ben'anda ya Nakkisasi bali muMwami. ");
INSERT INTO dov_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ujuuzye Tayifana a Tayifosa, basimilo basungu muMwami. Ujuuzye Pesisa uyandwa, wakachita mulimo mupati muMwami. ");
INSERT INTO dov_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Ujuuzye Lufasi, usalidwe muMwami, abanyina abaama. ");
INSERT INTO dov_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Ujuuzye Asiyikkitasi, Filegoni, Hemesi, Patilobbasi, Hemasi, abanyina mbalabo. ");
INSERT INTO dov_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Ujuuzye Filologasi aJuliya, Nelewusa muchizi wakwe, Oliyimpasi, a boonse baLeza basalala balaambabo. ");
INSERT INTO dov_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Mujuuzye umwi waumwi alumyonto lusalala. Zyoonse mbungano zya Kkilisito zilamujuuzya. ");
INSERT INTO dov_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Lino ndamusungwazya, nibanama, kuti muyeye atala ababo balikwanzyana akaleba. Balikwindilila njiisyo njimwakayiisya. Amubafutatile. ");
INSERT INTO dov_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Nkambo bantu balimbulaaba tababelekili Mwana Kkilisito wesu, pesi matumbu aabo. Azyaambo zibungusene akuwupawupa beenena myooyo yabatakwe mulandu. ");
INSERT INTO dov_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Nkambo chitondezyo chakuteelela kwako kulasikila boonse. Ndilabotelwa, alubo anduwe, pesi ndiyanda kuti ube muchenjezi kulizeezyo zibotu, akutabaamulandu kulizeezyo zibi. ");
INSERT INTO dov_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Leza waluumuno wapwaya Satani nsi amawulu ako. Luzyalo lwaMwami Jesu Kkilisito alubaayebo. ");
INSERT INTO dov_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoti, ngutubelekaawe, ulakujuzya, aLusiyasi, Jasoni, aSosipata, sinzuboma. ");
INSERT INTO dov_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ime, Tetiyasi, iwakalemba lugwalo olu ansi, ndakujuuzya muMwami. ");
INSERT INTO dov_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Galiyasi, mubutawukili wangu ambungano yoonse, balamujuuzya. Elasitasi, sinkomwe wadolopo, ulajuuzya, aKwatasi mwananyina. ");
INSERT INTO dov_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Luzyalo lwaMwami wesu Jesu Kkilisito abe andinywe moonse. Ameni. ");
INSERT INTO dov_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Lino kuliyoyo ukonzya kukuchita usime mbuli makani angu mabotu akompolola kwaJesu Kkilisito, mbuli chiyubunizyo chensiiswa zyakasisikene kwachiindi chilamfu, ");
INSERT INTO dov_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","pesi lino lyakayubununwa lyachitwa kuti lizibikane kwiinda akulemba kwaba sinsimi kunyika zyoonse, akulayilila kwaLeza bwinibwini, mukweeta kuteelela kwalusyomo. ");
INSERT INTO dov_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Kuliyooyo uchenjede Leza kwindilila aJesu Kkilisito, abulemu kutamani. Ameni. ");
INSERT INTO dov_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Pawulo, wakayiitwa aKkilisito Jesu kuti abe Mutumwa kwiinda mukuyanda kwaLeza, aSositinesi mukwesu, ");
INSERT INTO dov_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","kumbungano yaLeza iliku Kkolinto, abo bakasalazigwa muliKkilisitu Jesu akwambwa kuti mbantu basalala, antoomwe aboonse bali mumasena oonse abayiita zina lya Mwami Jesu Kkilisito, ulingonguwe Mwami waboandiswe. ");
INSERT INTO dov_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Ngamube aluzyalo a lumunoluzwa kuli Leza Taata aMwami Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Ndilumba Leza nkambo kandinywe nkaambo kaluzyalo lwaLeza olo Kkilisito Jesu ndwakamupa. ");
INSERT INTO dov_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Wakamuchita bavubi munzila zyoonse, mukwambula koonse aluzibo loonse, ");
INSERT INTO dov_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","alimwi mbuli bukamboni atala aKkilisito mbubwa boneka kuti mbwamasimpe akati kanu. ");
INSERT INTO dov_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Aboobo tamubuli chipo chaMuuya mbumulindide chakulangila kuyubununwa kwaMwami wesu Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Uyoomuchita kuti mukasyome chakumaninina kusikila kumamanino, ikuti mutakabi amulandu mubuzuba bwaMwami wesu Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Leza ulisyomekede, wakamwita kuti mukabilane aMwana, Jesu Kkilisito Mwami wesu. ");
INSERT INTO dov_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Lino ndamukumbila, nibakwesu, kwiinda muzina lyaMwami wesu Jesu Kkilisito, kuti moonse mulazuminana, akuti takuyoobi kupambukana antoomwe kamulamuzeezo umwi amakanze amwi. ");
INSERT INTO dov_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Mbundakambilwa atala andinywe nobakwesu, kuzwa kubantu baKkuluzi ikuti kulikujatana akati kanu. ");
INSERT INTO dov_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ndilikwamba eechi: umwi awumwi waamba kuti, “Ime ndili wa Pawulo,” na kuti, “Ime ndili wa Apolosi,” na kuti “Ime ndili wa Sifasi,” na kuti “Ime ndili wa Kkilisito.” ");
INSERT INTO dov_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Ani sa Kkilisito ulipambukene na? Ani Pawulo wakagankamininwa ndinywe na? Ani mwaka bbabbatisigwa muzina lyaPawulo na? ");
INSERT INTO dov_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ndilumba Leza kuti takwe ngundakabbabbatizya pe, kunze kwa Kilisipasi aGayosi. ");
INSERT INTO dov_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Eechi chakachitwa kuti kutabi waamba kuti mwakabbabbatizigwa muzina lyangu. ");
INSERT INTO dov_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","( Alimwi ndakabbabbatizya bang'anda yaSitefano. Kwiinda awo, tandikonzyi kuyeeya kuti kulibambi na mbindakabbabbatizya.) ");
INSERT INTO dov_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Nkaambo Kkilisito takandituma kuti ndika bbabbatizye pesi ikuti ndikakambawuke makani mabotu kutaamba amajwi abuchenjezu, mukuti chingano chaKkilisito chitakawubulwi nguzu zyacho. ");
INSERT INTO dov_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Nkaambo makani achingano chaKkilisito mbufubafuba kulabo balimukunyonyoka. Pesi akati kabaabo bafutulwa, ninguzu zyaLeza. ");
INSERT INTO dov_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Nkaambo kulilembedwe kuti,”Ndiyomwayisya busongo bwabasongo. Ndiyokonga kumvwisisya kwabachenjede.” ");
INSERT INTO dov_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ulikuli muntu musongo? Ulikuli mulembi? Ulikuli sikukazya wanyika eeno? Sa Leza takasandula busongo bwanyika kubufubafuba? ");
INSERT INTO dov_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Nkaambo nyika mubusongo bwayo teyakamuziba Leza, Leza wakabotelwa kuti afutule abo basyoma kwiinda mubufubafuba bwakukambawuka. ");
INSERT INTO dov_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Nkaambo maJuda bakumbila zitondezyo zigambya baGiliki bayandula busongo. ");
INSERT INTO dov_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Pesi tukambawuka Kkilisto wakagankaminwa, Nchilebyo kumaJuda alimwi mbufubafuba kulibaMasi. ");
INSERT INTO dov_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Pesi kulaabo Leza mbakayita, aantomwe baJuda abaGiliki, tukambawuka Kkilisito mbuli nguzu abusongo bwaLeza. ");
INSERT INTO dov_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Nkaambo bufubafuba bwaLeza bulayinda busongo bwabantu, alimwi kukompama kwaLeza kulanguzu kwiinda bantu. ");
INSERT INTO dov_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Amulange kwiitwa kwanu, nobakwesu teeboonse banu bakali basongo mbuli kunyama. Teeboonse banu bakali basinguzu. Teeboonse banu bakalizyedwe kabali bana babaami. ");
INSERT INTO dov_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Pesi Leza wakasala zintu zifubafuba zyanyika kuti awusye nsoni basongo. Leza, wakasala echo chikompeme munyika kuti akawusye nsoni echo chilanguzu. ");
INSERT INTO dov_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Leza wakasala echo chilansi alimwi chawuubulwa munyika. Alimwi wakasala zintu zitegwa takwe mbuzibede pe, kuti akazijosye ansi ezyo, zilangilwa kuti zintu loko. ");
INSERT INTO dov_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Wakazichita ezi kuti kutakabi nyama ilikankayizya kunembo lyakwe. ");
INSERT INTO dov_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Nkaambo kacheechi Leza nchakachita, lino mwaba muliKkilisito Jesu oyo utubeda busongo buzwa kuli Leza. Wakaba bululami bwesu, busalali, alununuko lwesu. ");
INSERT INTO dov_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Kuti kukabe mbuli mbukulembedwe kuti, “ Na kuli ulikankayizya, alikankayizizye muMwami Leza.” ");
INSERT INTO dov_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Nindakaza kulindinywe, nobakwesu, tendakaza abunnone bwamulaka kana busongo awoo nindakompolola simpe lisisidwe ataala aLeza. ");
INSERT INTO dov_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Nkambo ndakasala kutaziba chintu awo nindakali andinywe kunze kwa Jesu Kkilisito, akugankaminwa kwakwe. ");
INSERT INTO dov_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Alimwi ndakali andinywe mukubula nguzu amukuyowa, amukukankama. ");
INSERT INTO dov_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Alimwi mulayizyo wangu akukambawuka kwangu tekwakali amajwi akukombelezya chabusongo. Pesi, akali achitondezyo chamuuya anguzu, ");
INSERT INTO dov_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","kuchitila kuti lusyomo lwenu talubi mubusongo bwabantu, pesi munguzu zyaLeza. ");
INSERT INTO dov_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Lino twambula busongo mukati kabantu bazyikitide, pesi butali busongo bwanyika eeyi, kana bwendelezi bwalino, aboo bayobwinda. ");
INSERT INTO dov_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Anukuti twambula abusongo bwaLeza musimpe lisisidwe, busongo busisidwe oobo Leza mbwakali wabikka kunembo lyamyaka yabulemu besu. ");
INSERT INTO dov_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Takwe naba omwe wabendelezi balino wakachimvwisisisya, nkambo anoli bakachimvwisissya, nikuli tebakamukankamina pe Mwami wabulemu. ");
INSERT INTO dov_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Pesi mbuli mbukulembedwe, “Takwe lisyo lyabona, takwe kutwi kwamvwa, takwe moyo wamuntu waziyandula eezyo Leza nzyabambila aboo bamuyandula.” ");
INSERT INTO dov_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Pesi Leza wayibununa zintu eezi kulindiswe kwiindila muMuuya. Nkambo Muuya ulayandula zintu zyoonse, nikuba zintu zyaLeza zinikide. ");
INSERT INTO dov_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Nkambo ngwani uzi mizeezo yamuntu ado woMuuya wamuntu nuuli anguwe? Nkokuli alimwi, takwe muntu uzi zintu zyaLeza zinikide ado wo Muuya waLeza. ");
INSERT INTO dov_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Pesi tetwakatambula Muuya wanyika pesi Muuya ooyo uzwa kuli Leza. ");
INSERT INTO dov_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Twambule atala azintu eezi mumajwi akatayisigwa abusongo bwamuntu pesi aMuuya, kawupandulula zintu zyaMuuya kubantu baMuuya. ");
INSERT INTO dov_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Muntu utakwe Muuya tazitambuli pe zintu zyaku Muuya waLeza, nkambo nzyabufubafuba kuli nguwe. Takonzyi pe kuzimvwisisisya nkambo ziselezegwa aMuuya. ");
INSERT INTO dov_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ooyo ulimuMuuya ngukonzya kweela zintu zyoonse, psi takonzeki kweelwa azimwi. ");
INSERT INTO dov_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“Nkambo ngwani ulikonzya kuziba kuyeya kwaMwami chakuti unga ulamulayilila? Pesi ulijisi muzeezo waKkilisito. ");
INSERT INTO dov_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Alimwi andime, bakwesu, tendalikunowambula kulindinywe mbuli bantu basimuuya, pesi biyo mbuli kubantu banyama, mbuli kubana baniini muliKkilisito. ");
INSERT INTO dov_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Ndakamusanina amakupa, pe pe chakulya chiyumu, nkambo temwalina libambila; nikuba lino tamuna kulibambila. ");
INSERT INTO dov_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Nkaambo inywebo muchili munyama. Kaambo aali buzuba akukazyanya akati kanu, tamulikupona mbuli basinyama, tamulikwenda mbuli kupona kwamubuntu na? ");
INSERT INTO dov_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Nkaambo umwi waamba kuti, “Nditobela Pawulo,” alubo umwi waamba kuti, “Nditobela Apolosi,” tamuli zilengwa zyabuntu biyo na? ");
INSERT INTO dov_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Ngwani mpo Apolosi? Ngwani Pawulo? Babelesi kwiinda mumulawu ngwakazumina, mbuli Mwaami mbakapa mulimu kuli umwi.” ");
INSERT INTO dov_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ndakabyala, alubo Apolosi wakatilila, pesi Leza nguupa kukomezya. ");
INSERT INTO dov_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Mpo lino, te ooyo uubyala na utilila uli mbabede. Pesi nguLeza uupa kukomena. ");
INSERT INTO dov_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Lino ooyo uubyala alubo uutilila mbamwi, alubo umwi uyootambula chaabilo chakwe mbuli kumulimu wakwe. ");
INSERT INTO dov_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Nkaambo tuli basimulimunyina aLeza. Mulimuunda waLeza, mayake aLeza. ");
INSERT INTO dov_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Mbuli kuluzyalo lwaLeza lwakapegwa ndime mbuli muyaki ukonzesya, ndakabika intalisyo alubo umwi ulayaka alinjiyo. Pesi muleke umwi uyeyesya Mbayaka alinjiyo. ");
INSERT INTO dov_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Nkaambo takukwe uunga ulabamba ntalisyo imbi itali eeyo yakabikwa, kiili, Jesu Kkilisito. ");
INSERT INTO dov_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Lino na umwi ulayaka aatala antalisyo a ngolide, nsiliva, mabwe ayandika, zisamu, makuba, matete, ");
INSERT INTO dov_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","mulimu wakwe ulakuyubununwa, nkaambo buzuba buyobuyubununa. Nkaambo uyooyubununwa mumulilo. Mulilo ulabweezya bube bwawumwi anzyakachita. ");
INSERT INTO dov_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Na mulimu wawumwi ukayimikile, ulakutambula chabilo; ");
INSERT INTO dov_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","pesi na mulimu wawumwi wapya, ulakujana kuswekelwa, pesi we lwakwe uyofutulwa, mbuli ufutuka kwiinda mumulilo. ");
INSERT INTO dov_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Tamuzi na kut