﻿USE sofia;
DROP TABLE IF EXISTS sofia.dop_vpl;
CREATE TABLE dop_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dop_vpl WRITE;
INSERT INTO dop_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Wɑɑtʋ wei Ɩsɔ cɑɑlɑ ɩsɔtɔnʋɣʋ nɑ tɛtʋ kɛ lɑpʋ tǝcǝcɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tɛtʋ ntɩ tɩɩ wɛ kpɛtɛ kɛ́ tǝ fɛɩ tɑpʋɣʋ tǝ fɛɩ nɔɣɔ, nɑ teŋku lumɑŋ nyǝŋ wɑɑsɑ pǝ tɔɔ nɑ sǝkpɛtʋɣʋ nyɑlɑɑ, nɑ pǝ́ kɑɑsɩ nɑ Ɩsɔ heelim nɑ́ɑ́ mɑkɩ lʋm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ntɛnɑ Ɩsɔ tɔ́ sɩ: Pǝ́ nɑɑkɩ, ɩlɛnɑ pǝ́ sʋʋ nɑʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ɩsɔ lɑŋlɛ hɛɛnɑ pǝ nɑɑkʋɣʋ mpʋ tɔ, ɩlɛnɑ ɩ́ fɑɣɑ-wɩ nɑ sǝkpɛtʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mpʋɣʋlɛ Ɩsɔ hɑ pǝ nɑɑkʋɣʋ mpʋ tɔɣɔ hǝtɛ sɩ ilim tɑɑ, nɑ ɩ́ hɑ sǝkpɛtʋɣʋ sɩ ɑhoo. Pǝ kpɑɣɑ tɑnɑŋ nɑ pǝ́ sɩɩnɑ tɑɑnɑɣɑ, nɑ pǝ́ kpɑɣɑ ɑhoo nɑ pǝ́ nyɑɑlɩ tɔ, pǝ kpɛntɑ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ɩlɛnɑ Ɩsɔ tɔ́ sɩ: Pɑtǝmɑ ɩ́ wɛɛ ɩsɔtɑɑ, ɩlɛnɑ pǝ́ fɑɣɑ ɩsɔtɔnʋɣʋ tɑɑ lʋm nɑ ɑtɛ nyǝm. ");
INSERT INTO dop_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ɩlɛnɑ pǝ́ lɑ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ntɛnɑ ɩ́ hɑ pɑtǝmɑ ɩnǝɣɩ hǝtɛ sɩ ɩsɔtɔnʋɣʋ. Pǝ kpɑɣɑ tɑnɑŋ nɑ pǝ́ sɩɩnɑ tɑɑnɑɣɑ, nɑ pǝ́ kpɑɣɑ ɑhoo nɑ pǝ́ nyɑɑlɩ tɔ, pǝ kpɛntɑ kʋyɑkʋ nɑɑlɛ nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ḿpʋ́ɣʋ́ Ɩsɔ tɔmɑ sɩ: Atɛ lʋm ɩ́ kpɛntɩ lonɑ pɑɣɑlɛ tɑɑ nɑ pǝ́ yele puɣulɑɣɑ tɛtʋ. Ɩlɛnɑ pǝ́ lɑ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kɛlɛnɑ Ɩsɔ hɑ-tǝɣɩ hǝtɛ sɩ tɛtʋ, nɑ ɩ́ yɑɑ lʋmnɑɑ mpɛ sɩ teŋkunɑɑ, nɑ ɩ lɑŋlɛ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ntɛnɑ Ɩsɔ tɔ́ sɩ: Tɛtʋ ɩ́ lʋlǝsɩ kʋnyɔnyɔm mpi pǝ wɛ tǝlɛkʋlɛkʋ tɔɣɔ wɑɑnɩ wɑɑnɩ ɩsɩɩ tɩɩŋ nɑ nyɩɩtʋ nɑ pǝ́ lʋlǝɣɩ pǝ pee nɑ ɑ́ wɛ nyɔʋ. Ɩlɛnɑ pǝ́ lɑ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ḿpʋ́ɣʋ́ tɛtʋ lʋlǝsɑ-wǝɣɩ wɑɑnɩ wɑɑnɩ, nɑ Ɩsɔ lɑŋlɛ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Pǝ kpɑɣɑ tɑnɑŋ nɑ pǝ́ sɩɩnɑ tɑɑnɑɣɑ, nɑ pǝ́ kpɑɣɑ ɑhoo nɑ pǝ́ nyɑɑlɩ tɔ, pǝ kpɛntɑ kʋyɑkʋ tooso nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mpʋɣʋlɛ Ɩsɔ tɔmɑ sɩ: Kɔkɔsɩ ɩ́ wɛɛ ɩsɔtɑɑ nɑ sɩ́ fɑɣɑ ilim nɑ ɑhoo, nɑ kʋyɛɛŋ nɑ pɩɩsɩ nɑ lʋŋlɛ nɑ yolumɑ, ");
INSERT INTO dop_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","nɑ sɩ́ nɑɑkɩ tɛtʋ, ɩlɛnɑ pǝ́ lɑ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kɔkɔsɩ sɔsɔɔnsɩ nɑɑlɛɣɛ ɩ lɑpɑ, nɑ kʋkǝlɑɣɑ tɔ́kɩ kɑwulɑɣɑ kɛ ilim nɑ nɑɑlɛ nyǝŋkɑ kɛ ɑhoo. Nɑ ɩ́ lɑ ɩsɔtʋlʋŋɑsɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ḿpʋ́ɣʋ́ Ɩsɔ tʋ́ sɩ tǝnɑɣɑ ɩsɔtɑɑ nɑ sɩ́ nɑɑkɩ tɛtʋ tɔɔ, ");
INSERT INTO dop_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","nɑ sɩ́ tɔkɩ kɑwulɑɣɑ kɛ ilim nɑ ɑhoo, nɑ sɩ́ fɑɣɑ ilim nɑ sǝkpɛtʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Pǝ kpɑɣɑ tɑnɑŋ nɑ pǝ́ sɩɩnɑ tɑɑnɑɣɑ, nɑ pǝ́ kpɑɣɑ ɑhoo nɑ pǝ́ nyɑɑlɩ tɔ, pǝ kpɛntɑ kʋyɑkʋ liɣiti nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ḿpʋ́ɣʋ́ Ɩsɔ tɔmɑ sɩ: Weesuɣu nyǝm ɩ́ sú lʋmnɑɑ tɑɑ nɑ sumɑsɩ nɑ́ɑ́ kʋlǝɣɩ ɩsɔtɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ɩlɛnɑ Ɩsɔ lɑ́ lʋm tɑɑ tɔɣɔlǝŋ nɑ pǝ tɑɑ weesuɣu nyǝmnɑɑ kɛ wɑɑnɩ wɑɑnɩ, nɑ sumɑsɩ tǝnɑ, nɑ ɩ lɑŋlɛ hɛɛ, ");
INSERT INTO dop_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","nɑ ɩ́ kooli-tǝɣɩ kʋpɑntʋ nɑ ɩ́ tɔ́ sɩ: Ɩ́ lʋlɩ nɑ ɩ́ huki nɑ ɩ́ sú teŋkunɑɑ, nɑ sumɑsɩ nɑ́ɑ́ huki tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Pǝ kpɑɣɑ tɑnɑŋ nɑ pǝ́ sɩɩnɑ tɑɑnɑɣɑ, nɑ pǝ́ kpɑɣɑ ɑhoo nɑ pǝ́ nyɑɑlɩ tɔ, pǝ kpɛntɑ kʋyɑkʋ kɑkpɑsɩ nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ḿpʋ́ɣʋ́ Ɩsɔ tɔmɑ sɩ: Tɛtʋ ɩ́ lʋlǝsɩ weesuɣu nyǝm tǝnɑɣɑ wɑɑnɩ wɑɑnɩ ɩsɩɩ tɔlɑ nɑ tɑɑlɛ wontu nɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ tǝnɑ, ɩlɛnɑ pǝ́ lɑ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Wontunɑɑ mpɛ pɑ tǝnɑɣɑ ɩ lɑpɑ, pɑɑ tɔlɑ pɑɑ tɑɑlɛ wontu pɑɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ, nɑ ɩ lɑŋlɛ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ḿpʋ́ɣʋ́ Ɩsɔ tɔmɑ sɩ: Tǝ́ ŋmɑ́ yʋlʋ nɑ ɩ́ wɛɛ ɩsɩɩ tɑ́ tǝtɛŋɛlɛŋ nɑ ɩ́ tɔɣɔ kɑwulɑɣɑ kɛ wontu tǝnɑ tɔɔ, pɑɑ tiinɑ pɑɑ sumɑsɩ pɑɑ nti. ");
INSERT INTO dop_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kɛlɛnɑ ɩ́ ŋmɑ́ yʋlʋ ɩsɩɩ ɩ mɑɣɑmɑɣɑ ɩ wɛɛ tɔ. Apɑlʋ nɑ ɑlʋ kɛ ɩ ŋmɑ́-wɛ ɩsɩɩ ɩ wɛʋ tɔ ");
INSERT INTO dop_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","nɑ ɩ́ kooli-wɛɣɛ kʋpɑntʋ. Ɩlɛnɑ ɩ́ heeli-wɛ sɩ: Ɩ́ lʋlɩ nɑ ɩ́ huki nɑ ɩ́ sú tɛtʋ nɑ ɩ́ pǝsɩ-tɩ nɑ ɩ́ tɔɣɔ kɑwulɑɣɑ kɛ tiinɑ nɑ sumɑsɩ nɑ ɑtɛ wontu tǝnɑ tɔɔ nɑ ɩ́ pɑɑsǝnɑ-tɩ. ");
INSERT INTO dop_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mǝ tɔɣɔnɑɣɑ ntɛ́ kʋnyɔnyɔm nɑ tɩɩŋ tǝnɑ pee. ");
INSERT INTO dop_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Wontu nɑ sumɑsɩ nɑ weesuɣu nyǝm tǝnɑ tɔɣɔnɑɣɑ ntɛ́ nyɩɩtʋ kʋlɛkǝlɛkǝtʋ tǝnɑ. Ɩlɛnɑ pǝ́ lɑ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mpʋɣʋlɛ Ɩsɔ nyǝnɑɑ nɑ ɩ lɑŋlɛ hɛɛ sɔsɔm. Pǝ kpɑɣɑ tɑnɑŋ nɑ pǝ́ sɩɩnɑ tɑɑnɑɣɑ, nɑ pǝ́ kpɑɣɑ ɑhoo nɑ pǝ́ nyɑɑlɩ tɔ, pǝ kpɛntɑ kʋyɑkʋ nɑɑtoso nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ɩsǝnɑ Ɩsɔ lɑpɑ ɩsɔtɑɑ nɑ ɑtɛ nɑ pǝ tɑɑ weesuɣu nyǝmnɑɑ tǝnɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kʋyɑkʋ nɑɑtoso nyǝŋkʋ wule kɛ Ɩsɔ tɛɛsɑ ɩ tǝmɑ, ɩlɛnɑ ɩ́ hɛɛsɩ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule. ");
INSERT INTO dop_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Pǝ tɔɔ kɛ́ Ɩsɔ koolɑ-kʋɣʋ kʋpɑntʋ nɑ ɩ́ fɑɣɑsɩ-kʋ nɑ kʋ mpɑɑ sɩ kʋ kɛ́ ɩ nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ɩsǝnɑ Ɩsɔ lɑpɑ ɩsɔtɔnʋɣʋ nɑ ɑtɛ tɔɣɔlɛ. Wɑɑtʋ wei Tɑcɑɑ Ɩsɔ lɑpɑ ɑtɛ nɑ ɩsɔtɔnʋɣʋ tɔ, ");
INSERT INTO dop_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","nyɩɩtʋ tɑɑ tiikɑ nɑkǝlɩ kɑ tɑɑ fɛɩ tɛtʋ tɔɔ, pǝ́cɔ́ nyiilɑɣɑ nɑkǝlɩ kɑ tɑɑ nyɔɔkɩ. Mpi tɔ, Tɑcɑɑ Ɩsɔ tɑ́ɑ́ yelǝtɑ sɩ tɛʋ ɩ́ nɩɩ. Pǝyele yʋlʋ nɔɣɔlʋ ɩ tɑɑ fɛɩ sɩ ɩ́ hɑlɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Amɑ nikɑɣɑ kpɑɑkɑɣɑnɑ nɑ pǝ́ niɣitiɣi tɛtʋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ḿpʋ́ɣʋ́ Tɑcɑɑ Ɩsɔ kpɑɣɑ tɛtʋ nɑ ɩ́ lɑ́ yʋlʋ, ɩlɛnɑ ɩ́ woso yʋlʋ mɩɩnɑ tɛɛ kɛ́ weesuɣu heelim. Tǝnɑɣɑlɛ yʋlʋ sʋʋ feesuɣu. ");
INSERT INTO dop_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ɩlɛnɑ ɩ́ lɑ́ tɩɩŋ tɑɑlɛ kɛ Ɩteni tɑɑ kɛ́ ilim tǝlɩɩlɛ tɔɔ, nɑ ɩ́ sɩɩ yʋlʋ ɩnǝɣɩ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ntɛnɑ Tɑcɑɑ Ɩsɔ yele nɑ tɩɩŋ kʋpɑŋ nyɔ Ɩteni tɑɑ tǝnɑɣɑ wɑɑnɩ wɑɑnɩ nɑ ɩ pee tɔɣɔʋ nɑ leleŋ. Nɑ tʋɣʋ ŋku kʋ pee hɑɑkɩ weesuɣu tɔ, nɑ kʋpɑntʋ nɑ ɩsɑɣɑtʋ pǝ cɛkǝnɑʋ nyǝŋkʋ kɑ sǝŋɑ hɛkʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Nɑ pɔɣɔ nɑkǝlɩ kɛlɛ kɑ́ fɑɣɑ Ɩteni tɑɑ nɑ kɑ́ niɣitiɣi tɩɩŋ tɑɑlɛ nɑ kɑ́ hɛlɑ pusi liɣiti kɛ Ɩteni wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Kɑncɑɑlɑɣɑ nyǝŋkɑ hǝtɛ ntɛ́ Pisɔŋ, kɛlɛ kɑ cɔɔnɑ Hɑfilɑ tɛtʋ nti tǝ tɑɑ wʋlɑ kʋpɑŋ nɑ tulɑɑlʋ kʋpɑŋ nɑ liɣitee pǝlɛ kʋkpɛɛtǝlɛ pǝ wɛɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Pɔɣɔ nɑɑlɛ nyǝŋkɑ hǝtɛ ntɛ́ Kihɔŋ nɑ kɛlɛ kɑ cɔɔnɑ Kusi tɛtʋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nɑ tooso nyǝŋkɑ hǝtɛ ntɛ́ Tikili, kɛlɛ kɑ kpeŋnɑ nɑ ilim tǝlɩɩlɛ tɔɔ kɛ́ Asilii tɛtʋ tɑɑ. Pɔɣɔ liɣiti nyǝŋkɑ hǝtɛ ntɛ́ Ɩfǝlɑtɩ. ");
INSERT INTO dop_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ḿpʋ́ɣʋ́ Tɑcɑɑ Ɩsɔ sɩɩ yʋlʋ kɛ Ɩteni tɑɑlɛ ńtɛ́ tǝ tɑɑ sɩ ɩ́ hɑlɑ nɑ ɩ́ pɑɑsǝɣǝnɑ-tɛ́. ");
INSERT INTO dop_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kɛlɛnɑ ɩ́ tɔ́ yʋlʋ sɩ: N pǝsǝɣɩ nɑ ń tɔɣɔ tɑɑlɛ tɩɩŋ tǝnɑ pee. ");
INSERT INTO dop_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Amɑ kʋpɑntʋ nɑ ɩsɑɣɑtʋ pǝ cɛkǝnɑʋ tʋɣʋ pee pɑɑsi kɛ́ n kɑɑ tǝŋ. Pɔpɔtʋ fɛɩ leleŋ, kʋyɑŋku ń tɔɣɔ-yɛ ɩsɩɩ n sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","20","Tɛtʋ kɛ Tɑcɑɑ Ɩsɔ kɑ lɑpɑ tɑɑlɛ wontu tǝnɑ, nɑ sumɑsɩ tǝnɑ, nɑ ɩ́ lɑ́ nɑ tǝ́ polo yʋlʋ kiŋ sɩ ɩ́ nyɩ hǝlɑ nnɑ ɩ kɑ́ hɑ-tɩ tɔ, nɑ ɑnǝɣɩ pɑ yɑɑkɩ-tɩ. Ḿpʋ́ɣʋ́ yʋlʋ hɑwɑ tɔlɑ tǝnɑɣɑ hǝlɑ, nɑ tɑɑlɛ wontu nɑ sumɑsɩ tǝnɑ. Amɑ ɩ tɑ hiki sǝnlʋ wei ɩ mʋnɑ-ɩ tɔ. Ḿpʋ́ɣʋ́ ɩ tɔmɑ sɩ: Pǝ fɛɩ sɩ yʋlʋ ɩ́ cɑɣɑ ɩ tike kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ɩlɛnɑ Tɑcɑɑ Ɩsɔ lɑ́ nɑ tom kpɑ yʋlʋ nɑ ɩ́ too ɩsɩɩ ɩ́ sǝpɑ, nɑ ɩ́ lǝsɩ ɩ sǝntɑɑɣɑ lɛŋkɑ nɑ ɩ́ wɑɑsɩ nɑntʋ kɛ kɑ lonte. ");
INSERT INTO dop_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ntɛnɑ ɩ́ mǝŋnɑ sǝntɑɑɣɑ ŋkɑ ɩ kɑ lǝsɑ ɑpɑlʋ tɑɑ tɔ nɑ ɩ́ ŋmɑnɑ ɑlʋ nɑ ɩ́ cɛlɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tǝnɑɣɑlɛ yʋlʋ tɔmɑ sɩ: Aŋhɑɑ, mɑ́ nɑ ɩnɛ tǝ kɑɑnɑ nɑntʋ nɑ mʋwɑ. Mpi tɔ, mɑ tɑɑ kɛ́ pɑ lǝsɑ-ɩ, ɩ́lɛ́ ɩ hǝtɛ ntɛ́ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Pǝ tɔɔ kɛ́ ɑpɑlʋ kɑ yele ɩ cɑɑ nɑ ɩ too nɑ ɩ́ nɑ ɩ ɑlʋ pɑ́ cɑɣɑ nɑ pɑ́ pǝsɩ yʋlʋ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Yʋlʋ nɑ ɩ ɑlʋ pɑ tɔŋɑɣɑ kpɛlɑ kɛ pɑ nɑɑlɛɣɛ, pǝ́cɔ́ fɛɛlɛ nɑtǝlɩ tǝ fɛɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Tɑɑlɛ wontu nti tǝ tǝnɑ Tɑcɑɑ Ɩsɔ lɑpɑ mpʋ tɔ, tʋm kǝlǝnɑ tǝ tǝnɑɣɑ ɑcilɑɣɑtʋ. Mpʋɣʋlɛ kʋyɑkʋ nɑkǝlɩ tʋm pɔɔsɑ ɑlʋ sɩ: Ɩlɛ tɑmpɑnɑ Ɩsɔ yɔɣɔtɑɑ sɩ ɩ́ tɑɑ tɔɣɔ tɑɑlɛ tɩɩŋ tǝnɑ pee yɑɑ? ");
INSERT INTO dop_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kɛlɛnɑ ɑlʋ nɑ́ɑ́ cɔ sɩ: Aɑɩ, tǝ tɔ́kɩ hɑlǝm tɩɩŋ tǝnɑ pee kɛ́. ");
INSERT INTO dop_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Amɑ pǝ kɑɑsʋɣʋ tʋɣʋ ŋku kʋ wɛ hɑlǝm hɛkʋ tɑɑ tɔ kʋ pee tɔ, Ɩsɔ tɔmɑ sɩ: Ɩ́ tɑɑ tǝŋ-yɛ, pǝ́cɔ́ ɩ́ tɑɑ tokinɑ-yɛ́ɣɛ́ tokinɑʋ mɑɣɑmɑɣɑ, pǝ́ tɑɑ kɔɔ nɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mpʋɣʋlɛ tʋm nɔɣɔ tǝkpɑʋ sɩ: Ɩɩ sǝkɩ se. ");
INSERT INTO dop_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Amɑ Ɩsɔ nyǝ́mɑ́ sɩ kʋyɑkʋ ŋku ɩ́ tǝŋɑ-yɛ, mǝ ɩsɛ kuliɣi kɛ́ ɩsɩɩ ɩnɩ ɩ wɛʋ tɔ, nɑ ɩ́ nyǝ́mɑ́ kʋpɑntʋ nɑ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Alʋ nɑwɑ sɩ tʋɣʋ ŋkʋ kʋ nyǝnʋɣʋ wɛ teu, pǝ́cɔ́ kʋ pee wɛ ɩsɛsɛɛmlɛ nɑ ɑ kuliɣi yǝlɑɑ ɩsɛ. Ntɛnɑ ɩ́ kooli-kʋ́ nɑ ɩ́ tɔɣɔ, nɑ ɩ́ kɑɑsɩ nɑ ɩ́ cɛlɑ ɩ pɑɑlʋ nɑ ɩ́lɛ́ ɩ́ tɔɣɔ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tǝnɑɣɑlɛ pǝ kulɑ pɑ nɑɑlɛɣɛ mpʋ pɑ ɩsɛ nɑ pɑ́ cɛkǝnɑ sɩ pɑ wɛ tɑpɑkpɛlɑ. Ɩlɛnɑ pɑ́ cɑɑ hɑtʋ kʋwɑlǝtʋ nɑtǝlɩ nɑ pɑ́ tɔɣɔlɩ. ");
INSERT INTO dop_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Pǝ kɛɛsɑ tɑɑnɑɣɑ ɩlɛ Ɩsɔ Tɑcɑɑ polɑ ɩ tɑɑlɛ tɔɔ kɛ́ cɔɔʋ ntɛ́ nɑ pɑ́ nɩɩ ɩ nɔɣɔ. Ɩlɛnɑ yʋlʋ nɑ ɩ ɑlʋ pɑ́ sé nɑ pɑ́ ŋmɛlɩ tɑɑlɛ tɩɩŋ hɛkʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Amɑ Ɩsɔ Tɑcɑɑ yɑ́ɑ́ yʋlʋ sɩ: Leɣe n wɛnɑ ye? ");
INSERT INTO dop_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ḿpʋ́ɣʋ́ ɩ cɔwɑ sɩ: Mɑ nɩɩ nyɑ́ nɔɣɔ kɛ tɑɑlɛ tɑɑ ɩlɛnɑ sɔɣɔntʋ kpɑ-m nɑ mɑ́ sé nɑ mɑ́ ŋmɛlɩ. Mpi tɔ, mɑ wɛ tɑpɑkpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tǝnɑɣɑlɛ Ɩsɔ Tɑcɑɑ nɔɣɔ tǝkpɑʋ sɩ: Awe heelinɑ-ŋ sɩ n wɛ kpɛtɛ? N tɔɣɔ tʋɣʋ ŋku ɩnɩ mɑɑ kisinɑ-ŋ tɔɣɔ? ");
INSERT INTO dop_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kɛlɛnɑ yʋlʋ sɩ: Mɑ tɔɣɑɑ yɑ́ɑ́, ɩlɛ ɑlʋ wei ɩnɩ n hɑ-m tɔ ɩnɩ ɩ cɛlǝnɑ-m nɑ mɑ́ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ntɛnɑ Ɩsɔ Tɑcɑɑ pɔɔsɩ ɑlʋ sɩ: Pepe tɔɔ kɛ́ nyɑ́ lɑpɑ mpʋ? Alʋ nɔɣɔ tǝkpɑʋ sɩ: Tʋm tʋsǝnɑ-m nɑ mɑ́ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ tʋm sɩ: Timpi n lɑpɑ mpʋ tɔ, pɩɩ kpɑtɩ nyɑ́ yule tɔɔ kɛ́ kpɑɑkpɑɑlɛ nɑ pǝ́ kǝlɩ wontu tǝnɑ, nyɑ́ lotu tɔɔ kɛ́ n kɑ́ tuuki nɔɔnɔɔ nɑ ń tɔ́kɩ tɛtʋ, hɑlǝnɑ nyɑ́ sǝm. ");
INSERT INTO dop_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mɑɑ tʋ́ pɑtɩɩlɛ kɛ nyɑ́ nɑ ɑlʋ mǝ hɛkʋ, nɑ nyɑ́ lʋlʋɣʋ nyǝ́mɑ nɑ ɩ lʋlʋɣʋ nyǝ́mɑ pɑ hɛkʋ, pɑɑ nɑŋtɩ nyɑ́ nyʋɣʋ nɑ nyɑ́ɑ́ ló pɛlɛ pɑ nɔɔkikite. ");
INSERT INTO dop_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ɩlɛnɑ Ɩsɔ tɔ́ ɑlʋ sɩ: Mɑɑ sɔɔsɩ-ŋ wʋsɑsɩ kɛ nyɑ́ ɑhontotʋ wɑɑtʋ, nɑ nsǝɣɩ n kɑ́ lʋlǝnɑ, nɑ n kɑ́ nyɩɩlǝɣɩ nyɑ́ pɑɑlʋ kɛ́ teu. Amɑ ɩ́lɛ́ ɩ kɑ́ lɑ nyɑ́ sɔsɔ. ");
INSERT INTO dop_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ɩlɛnɑ ɩ́ pǝsǝnɑ ɑpɑlʋ tɔɔ sɩ: Timpi n nɩɩnɑ nyɑ́ ɑlʋ nɑ ń tɔɣɔ tʋɣʋ ŋku mɑɑ kisinɑ-ŋ tɔ. Mɑ tǝŋsǝɣɩ tɛtʋ kɛ mpusi kɛ́ nyɑ́ mɑɣɑmɑɣɑ nyɑ́ tɔɔ. Wɑhɑlɑ nɑ wɑhɑlɑ kɛ́ nɑ pǝ́cɔ́ ń hiki nyɑ́ tɔɣɔnɑɣɑ hɑlǝnɑ nyɑ́ sǝm. ");
INSERT INTO dop_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nyɩɩtʋ ɩsɑɣɑtʋ kɛ n kɑ́ hɑlɑ nɑ pǝ́cɔ́ ń hiki nyɑ́ hɑtǝmʋtʋ. ");
INSERT INTO dop_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ye hɑŋɑɣɑ tɑ sɔ-ŋ, n kɑɑ hiki ɩcɑʋtɛ nɑ ń mʋlɩ. Hɑlǝnɑ kʋyɑkʋ ŋku pɑɑ pi-ŋ tɛtʋ nti pɑɑ ŋmɑnɑ-ŋ tɔ tǝ tɑɑ tɔ. Mpi tɔ, n kɛ́ tɛtʋ kɛ́, pǝ́cɔ́ n kɑ́ tɑɣɑnɩ kʋlʋmtʋ ntǝɣɩ pǝsʋɣʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mpʋɣʋlɛ Atɑm hɑ ɩ ɑlʋ sɩ Ɩfɑ. Mpi tɔ, ɩnǝɣǝlɛ yǝlɑɑ tǝnɑ too. ");
INSERT INTO dop_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ɩlɛnɑ Ɩsɔ Tɑcɑɑ kʋ wontu nɑtǝlɩ nɑ ɩ́ liti-tɩ nɑ ɩ́ tɔɣɔlɩ Atɑm nɑ ɩ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Tǝnɑɣɑ Ɩsɔ Tɑcɑɑ yɔɣɔtɑɑ sɩ: Nɔɔnɔɔ yʋlʋ pǝsɑ ɩsɩɩ tɑ́ tɑɑ nɔɣɔlʋɣʋlɛ kʋpɑntʋ nɑ ɩsɑɣɑtʋ pǝ nyǝm tɔm tɑɑ. Pǝ tɔɔ tɔ, tǝ́ tɑɑ yele nɑ ɩ́ tɔɣɔ weesuɣu tʋɣʋ pǝle nɑ ɩ́ wɛɛnɑ weesuɣu kɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ɩlɛnɑ Ɩsɔ tɔɣɔnɩ-ɩ Ɩteni tɑɑlɛ tɑɑ sɩ ɩ́ sʋʋ hɑlǝm kɛ tɛtʋ nti pɑ ŋmɑnɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mpʋ pǝ lɑpǝnɑ nɑ ɩ́ tɔɣɔnɩ Atɑm nɑ ɩ́ sɩɩ ɩsɔtɑɑ tɑŋlɑɑ nɑ pɑ́ tɑŋ tɑɑlɛ mpɑɑʋ nɑ pɑ́ ŋmɛlǝsǝɣɩ pɑ lɑɣɑlɛɛ nɑ ɑ́ mʋɣʋ kɔkɔsɩ kɛ ŋmɛlɛʋ ŋmɛlɛʋ sɩ nɔɣɔlʋ ɩ́ tɑɑ kpǝtǝnɑ weesuɣu tʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ḿpʋ́ɣʋ́ Atɑm nyǝmɑ́ ɩ ɑlʋ Ɩfɑ nɑ ɩ́lɛ́ ɩ́ lɑ́ teu nɑ ɩ́ lʋlɩ Kɑyini. Ɩlɛnɑ ɩ́ tɔ́ sɩ: Mɑ hikɑ ɑpɑlʋpǝyɑɣɑ nɑ Tɑcɑɑ toŋ. ");
INSERT INTO dop_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Pǝlɛ pǝ wɑɑlɩ kɛ́ ɩ lʋlɑ ɩ neu Apɛɛlɩ. Apɛɛlɩ kɑ kɛ́ tiikilu nɑ Kɑyini kɛ hɑ́tʋ́. ");
INSERT INTO dop_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ tɑɑlʋ lǝsɑ ɩ hɑtǝmʋtʋ tɑɑ nɑ ɩ́ lɑ́ Tɑcɑɑ kɛ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ɩlɛnɑ neu nɑ́ɑ́ kpɑ ɩ heeŋ tɑɑ kɛ́ kɑncɑɑlɑɣɑ kʋlʋlǝŋ nim nyǝŋ nɑ ɩ́ lɑ́ kɔtɑɣɑ tɔtɔ. Ɩlɛnɑ Tɑcɑɑ nyǝnɩ Apɛɛlɩ kɔtɑɣɑ nɑ pǝ́ kɛɛsǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Amɑ ɩ kisɑ Kɑyini nyǝŋkɑ. Tǝnɑɣɑlɛ pǝ hɑŋɑ-ɩ teu ɩsɩɩ nɔɔhǝlɛ tɑɑ kɔkɔ, nɑ ɩ ɩsɛntɑɑ sɔŋ. ");
INSERT INTO dop_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ɩlɛnɑ Tɑcɑɑ pɔɔsɩ-ɩ sɩ: Pepe tɔɔ kɛ́ nyɑ́ ɩsɛntɑɑ sɔŋɑɑ? ");
INSERT INTO dop_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ye kʋpɑntʋ kɛ n lɑkɩ, nyɑ́ ɩsɛntɑɑ ɩ́ hɛtɩ. Amɑ ye ɩsɑɣɑtʋ kɛ n lɑkɩ, kʋlʋmtʋ ntɩ tǝ pɑpǝnɑ ntɛɣɛ nyɑ́ nɔnɔɣɔ tɛɛ ɩsɩɩ tɔɣɔlʋɣʋ nɑ tǝ́ tɑŋɑ-ŋ, nɑ tǝ́ cɑɑ-ŋ kǝlʋɣʋ. Amɑ pǝsɩ-tɩ nɑ ń kǝlɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Tǝnɑɣɑ Kɑyini tɔmɑ ɩ neu sɩ: Tǝ́ kpɑ tɑɑlɛ, ɩlɛnɑ Kɑyini kʋlɩ ɩ tɔɔ kɛ́ tǝnɑ nɑ ɩ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mpʋɣʋlɛ Tɑcɑɑ pɔɔsɑ Kɑyini sɩ: Nyɑ́ neu Apɛɛlɩ wele? Ɩlɛnɑ ɩ́ cɔ sɩ: Mɑ nyǝmɑ́ timpi ɩ wɛɛ tɔ? Mɑ kɛ́ mɑ neu tɑŋlʋ nɑ? ");
INSERT INTO dop_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ɩlɛnɑ Tɑcɑɑ pɔɔsɩ-ɩ sɩ: Pepe lɑpɑ mpʋ? Mɑ nɑwɑ nyɑ́ neu cɑlǝm kɛ ɑtɛ, nɑ pǝ wɛɛ sɩ mɑ́ lɛɛtɩ-ŋ. ");
INSERT INTO dop_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nɔɔnɔɔ tɛtʋ kɑ́ tǝŋsɩ-ŋ mpusi kɛ́ timpi n yelɑɑ nɑ tǝ́ hɑɑ nɔɣɔ nɑ tǝ́ li nyɑ́ neu cɑlǝm kɛ nyɑ́ niŋ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Pɑɑ n kɑ́ hɑlɑ-tǝɣɩ ɩsǝnɑ, n kɑɑ wɑɑ pʋlʋ. N kɑ́ lɑ yem cɔɔlʋ, n kɑɑ wɛɛnɑ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Mpʋɣʋlɛ Kɑyini cɔwɑ Tɑcɑɑ sɩ: Mɑ sɑlǝkɑ kǝlɑ-m. ");
INSERT INTO dop_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nyǝnɩ, sɑŋɑ ń tɔɣɔnǝɣɩ-m tɛtʋ kʋpɑntʋ tǝnɛ tǝ tɑɑ kɛlɛ, mɑ kɑɑ tɑsɑ nyɑ́ ɩsǝpǝle tɑɑ kɛ́ loosuɣu. Mɑɑ pǝsɩ yem cɔɔlʋ, mɑ kɑɑ wɛɛnɑ tǝyɑɣɑ, nɑ wei ɩ́ hikɑ-m ɩ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tǝnɑɣɑlɛ Tɑcɑɑ nɔɣɔ tǝkpɑʋ sɩ: Aɑɩ, ye wei ɩ́ kʋwɑ Kɑyini, ɩsɩɩ mɑ fɛlɑ pʋntʋ kɛ pǝ tɔm nɑɑtosompɔɣɔlɑɣɑ. Ɩlɛnɑ Tɑcɑɑ yʋsɩ Kɑyini sɩ ye wei ɩ́ nɑ-ɩ ɩ́ tɑɑ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ntɛnɑ ɩ́ se Tɑcɑɑ nɑ ɩ́ polo ɩ cɑɣɑ timpi pɑ yɑɑ sɩ Yemcɔɔlɑɑtɛ tɔɣɔ Ɩteni ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ḿpʋ́ɣʋ́ Kɑyini nyǝmɑ́ ɩ ɑlʋ nɑ ɩ́ lɑ́ teu nɑ ɩ́ lʋlɩ Henɔkɩ. Ɩlɛnɑ ɩ́ ŋmɑ́ ɩcɑtɛ nɑ ɩ́ hɑ-tɛɣɛ ɩ pǝyɑlʋ hǝtɛ. ");
INSERT INTO dop_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ḿpʋ́ɣʋ́ Henɔkɩ lʋlɑ Ɩlɑɑtɩ nɑ Ɩlɑɑtɩ lʋlɩ Mehuyɑyɛɛlɩ nɑ Mehuyɑyɛɛlɩ lʋlɩ Metusɑyɛɛlɩ, ɩlɛnɑ Metusɑyɛɛlɩ lʋlɩ Lemɛkɩ. ");
INSERT INTO dop_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Alɑɑ nɑɑlɛ kɛ Lemɛkɩ kpɑɣɑɑ, kɑncɑɑlɑɣɑ nyǝŋ hǝtɛ ntɛ́ Atɑ, nɑɑlɛ nyǝŋ sɩ Silɑ. ");
INSERT INTO dop_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ḿpʋ́ɣʋ́ Atɑ lʋlɑ Yɑpɑɑlɩ. Yɑpɑɑlɩ ɩnɩ ɩ́lɛ́ ɩ piitim ntɛ́ mpɑ pɑ tiikiɣi kɑlǝkǝŋ nɑ pɑ́ sʋʋkɩ cokɑ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ɩ́lɛ́ ɩ neu hǝtɛ ntɛ́ Yupɑɑlɩ. Yupɑɑlɩ ɩnɩ ɩ piitim ntɛ́ mpɑ pɑ mɑkɩ sɑŋkʋnɑɑ nɑ pɑ́ hʋlǝɣɩ hǝsɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silɑ ɩ́lɛ́ ɩ lʋlǝnɑ ntɛɣɛ Tupɑɑlɩ-Kɑyini, wei ɩ luki nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ nɑ nyǝɣǝlʋɣʋ mɑɣɑmɑɣɑ wontu tɔ. Ɩ neu kɛ pɑ yɑɑkɑɣɑ sɩ Nɑɑmɑ. ");
INSERT INTO dop_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ḿpʋ́ɣʋ́ Lemɛkɩ tɔmɑ ɩ ɑlɑɑ Atɑ nɑ Silɑ sɩ: Mɑ ɑlɑɑ mɛ, ɩ́ nɩɩ mɑ tɔm yoo. Mǝ tɑɑ lɛlʋ pɑɑlʋ cǝtǝlɑ-m kɛ́ nɑ mɑ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Tɔm nɑɑtosompɔɣɔlɑɣɑ kɛ pɑɑ lɛɛtɩ Kɑyini kʋlʋ. Ɩlɛnɑ pɑ́ lɛɛtɩ mɑ kʋlʋ kɛ tɔm nɩɩtoso nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Atɑm pɑ tɑsɑ ɑpɑlʋpǝyɑɣɑ kɛ lʋlʋɣʋ ɩlɛnɑ Ɩfɑ hɑ-kɛɣɛ hǝtɛ sɩ Sɛɛtɩ, sɩ Tɑcɑɑ hɑ ɩnǝɣɩ ɑpɑlʋpǝyɑɣɑ lɛŋkɑ kɛ Apɛɛlɩ wei Kɑyini kʋwɑ tɔ ɩ lonte. ");
INSERT INTO dop_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sɛɛtɩ nɑ́ lɑpɑ yʋlʋ nɑ ɩ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ nɑ ɩ́ hɑ-kɛ sɩ Ɩnɔɔsɩ. Wɑɑtʋ ɩnǝɣɩ yǝlɑɑ cɑɑlɑ Ɩsɔ kɛ́ sɛɛʋ sɩ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Atɑm lʋlʋɣʋ nyǝ́mɑ hǝlɑ ntɔ cǝnɛ. Wɑɑtʋ wei Ɩsɔ ŋmɑ́ yʋlʋ tɔ, ɩ ŋmɑ-ɩ kɛ́ ɩsɩɩ ɩ wɛɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Apɑlʋ nɑ ɑlʋ kɛ ɩ ŋmɑwɑ nɑ ɩ́ hɑ-wɛ sɩ yǝlɑɑ nɑ ɩ́ kooli-wɛɣɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Atɑm pɩɩsɩ lɑpɑ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ (130) kɛ́ ɩlɛnɑ ɩ́ lʋlɩ pǝyɑɣɑ nɑ kɑ́ kpɑɣɑ-ɩ tǝtɛŋɛlɛŋ nɑ ɩ́ hɑ-kɛɣɛ hǝtɛ sɩ Sɛɛtɩ. ");
INSERT INTO dop_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛɛtɩ lʋlʋɣʋ wɑɑlɩ Atɑm tɔɣɔ pɩɩsɩ nɑsǝnɑɑsɑ (800) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Atɑm pɩɩsɩ tǝnɑ yoosɑ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ (930) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɛɛtɩ pɩɩsɩ lɑpɑ nɩɩnʋwɑ nɑ kɑkpɑsɩ (105) ɩlɛnɑ ɩ́ lʋlɩ Ɩnɔɔsɩ. ");
INSERT INTO dop_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ɩnɔɔsɩ lʋlʋɣʋ wɑɑlɩ Sɛɛtɩ tɔɣɔ pɩɩsɩ nɑsǝnɑɑsɑ nɑ nɑɑtosompɔɣɔlɑɣɑ (807) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛɛtɩ pɩɩsɩ tǝnɑ yoosɑ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ nɑ nɑɑnʋwɑ nɑ nɑɑlɛ (912) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ɩnɔɔsɩ pɩɩsɩ lɑpɑ nɩɩnɑɑsɑ nɑ nɑɑnʋwɑ ɩlɛnɑ ɩ́ lʋlɩ Kenɑŋ. ");
INSERT INTO dop_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenɑŋ lʋlʋɣʋ wɑɑlɩ Ɩnɔɔsɩ tɔɣɔ pɩɩsɩ nɑsǝnɑɑsɑ nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ (815) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ɩnɔɔsɩ pɩɩsɩ tǝnɑ yoosɑ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ nɑ kɑkpɑsɩ (905) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenɑŋ pɩɩsɩ lɑpɑ nɩɩtoso nɑ nɑɑnʋwɑ ɩlɛnɑ ɩ́ lʋlɩ Mɑlɑlɛlɩ. ");
INSERT INTO dop_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mɑlɑlɛlɩ lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ nɑsǝnɑɑsɑ nɑ nɩɩlɛ (840), nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenɑŋ pɩɩsɩ tǝnɑ yoosɑ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ nɑ nɑɑnʋwɑ (910) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mɑlɑlɛlɩ pɩɩsɩ lɑpɑ nɩɩtoso nɑ kɑkpɑsɩ ɩlɛnɑ ɩ́ lʋlɩ Yɛlɛtɩ. ");
INSERT INTO dop_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yɛlɛtɩ lʋlʋɣʋ wɑɑlɩ Mɑlɑlɛlɩ tɔɣɔ pɩɩsɩ nɑsǝnɑɑsɑ nɑ hiu nɑ nɑɑnʋwɑ (830), nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mɑlɑlɛlɩ pɩɩsɩ tǝnɑ yoosɑ nɑsǝnɑɑsɑ nɑ nɩɩnɑɑsɑ nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ (895) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yɛlɛtɩ pɩɩsɩ lɑpɑ nɩɩnʋwɑ nɑ nɩɩtoso nɑ nɑɑlɛ (162) ɩlɛnɑ ɩ́ lʋlɩ Henɔkɩ. ");
INSERT INTO dop_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Henɔkɩ lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ nɑsǝnɑɑsɑ (800), nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yɛlɛtɩ pɩɩsɩ tǝnɑ yoosɑ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ nɑ nɩɩtoso nɑ nɑɑlɛ (962) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henɔkɩ pɩɩsɩ lɑpɑ nɩɩtoso nɑ kɑkpɑsɩ ɩlɛnɑ ɩ́ lʋlɩ Metusɑlɛm. ");
INSERT INTO dop_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusɑlɛm lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (300), nɑ sɩ tɑɑ kɛ́ ɩ tǝŋɑ Ɩsɔ kɛ́ teu nɑ ɩ́lɛ́ ɩ́ wɛ ɩ wɑɑlɩ, nɑ ɩ́ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ɩ pɩɩsɩ tǝnɑ yoosɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ nɑ nɩɩtoso nɑ kɑkpɑsɩ (365). ");
INSERT INTO dop_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henɔkɩ kɑ tǝŋɑ Ɩsɔ kɛ́ teu kɛ́ nɑ Ɩsɔ wɛ ɩ wɑɑlɩ. Pǝ kɔmɑ nɑ pǝ kɛɛsɩ ɩlɛnɑ Ɩsɔ kpɑɣɑ-ɩ nɑ ɩ ɩsɛ, nɔɣɔlʋ tɑ tɑsɑ-ɩ nɑʋ. ");
INSERT INTO dop_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusɑlɛm pɩɩsɩ lɑpɑ nɩɩnʋwɑ nɑ nɩɩnɑɑsɑ nɑ nɑɑtosompɔɣɔlɑɣɑ (187) ɩlɛnɑ ɩ́ lʋlɩ Lemɛkɩ. ");
INSERT INTO dop_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemɛkɩ lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ nɑsǝtoso nɑ nɩɩnʋwɑ nɑ nɩɩnɑɑsɑ nɑ nɑɑlɛ (782), nɑ sɩ tɑɑ kɛ́ ɩ lʋlɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ. ");
INSERT INTO dop_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusɑlɛm pɩɩsɩ tǝnɑ yoosɑ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ nɑ pɔɣɔlɑɣɑfɛɩ nɩɩtoso nɑ nɑɑnʋwɑ (969) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemɛkɩ pɩɩsɩ lɑpɑ nɩɩnʋwɑ nɑ nɩɩnɑɑsɑ nɑ nɑɑlɛ (182) ɩlɛnɑ ɩ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ ");
INSERT INTO dop_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","nɑ ɩ́ hɑ-kɛ sɩ Nowee. Mpi tɔ, ɩ tɔmɑɣɑ sɩ ɩnɛ ɩnɩ ɩ kɑ́ hɛɛsǝnɑ tɑ́ lɑŋɑ kɛ tɑ ɩkɑɑlɛnɑɑ nɑ tɑ́ wɑhɑlɑ tǝmɑ tɑɑ kɛ́ tɛtʋ nti ɩnɩ Tɑcɑɑ tǝŋsɑ mpusi kɛ́ tɑ́ tɔɔ tɔ tǝ tɑɑ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nowee lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ nɑsǝlɛ nɑ nɩɩnʋwɑ nɑ nɩɩnɑɑsɑ nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ (595) nɑ sɩ tɑɑ kɛ́ ɩ lʋlɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ. ");
INSERT INTO dop_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemɛkɩ pɩɩsɩ tǝnɑ yoosɑ nɑsǝtoso nɑ nɩɩnʋwɑ nɑ nɩɩtoso nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ (777) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowee pɩɩsɩ lɑpɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (500) ɩlɛnɑ ɩ́ lʋlɩ Sem nɑ Kɑm nɑ Yɛfɛtɛ. ");
INSERT INTO dop_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Yǝlɑɑ kɔmɑ nɑ pɑ́ huki tɛtʋ tɔɔ nɑ pɑ́ lʋlɩ pɛɛlɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ḿpʋ́ɣʋ́ ɩsɔtɑɑ yǝlɑɑ nɑwɑ sɩ pɛɛlɑɑ mpɛ pɑ tewɑ, ɩlɛnɑ pɑ́ kpɑɣɑ pɑ tɑɑ mpɑ pɑ sɔɔlɑɑ tɔɣɔ ɑlɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ntɛnɑ ɩ́ tɔ́ sɩ: Mɑ feesuɣu kɑɑ cɑɣɑ yʋlʋ tɑɑ kɛ́ tɑm. Mpi tɔ, ɩ kɛ́ yʋlʋ kɛ́. Pǝ tɔɔ tɔ pǝ kpɑɣɑʋ pǝnɛntɛ tɔ ɩ weesuɣu tǝnɑ tɑɣɑlǝŋ ntɛ́ pɩɩsɩ nɩɩnʋwɑ nɑ hiu (120). ");
INSERT INTO dop_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Wɑɑtʋ wei pɑ lʋlɑ pɑ piyɑ mpɛ tɔ pɑ lɑpɑ tookonɑɑ kɛ́ nɑ pɑ́ kɔɔ nɑ pɑ́ tɑsɑ tookonɑɑ mpɛɣɛ lʋlʋɣʋ, nɑ mpɛ pɑ lɑpǝnɑ lɔŋtɑɑ ɑkɑnɑɑ nɑ pɑ hǝtɛ yɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ḿpʋ́ɣʋ́ Tɑcɑɑ nɑwɑ sɩ yǝlɑɑ ɩsɑɣɑtʋ tɛlǝsɑ mpǝle kɛ tɛtʋ tɑɑ, nɑ ɩsɑɣɑlǝmɑɣɑsǝlɛ tike kɛ pɑ wɛnɑ pɑɑ ɩfemle nte. ");
INSERT INTO dop_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ḿpʋ́ɣʋ́ Tɑcɑɑ lɑŋlɛ wɑkǝlɑɑ nɑ pǝ́ wɩɩ-ɩ sɔsɔm kɛ mpi pǝ tɔɔ ɩ ŋmɑ́ yʋlʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ntɛnɑ ɩ́ tɔ́ sɩ: Ɩsɩɩ mɑ kpiisɑ yǝlɑɑ mpɑ mɑ ŋmɑwɑ tɔɣɔ tɛtʋ tǝnɑ tɔɔ, pǝ kpɑɣɑʋ yʋlʋ nɑ pǝ́ polo tɔtɛ tɔ, nɑ sumɑsɩ, nɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ tǝnɑ tɔ. Mɑ lɑŋlɛ wɑkǝlǝnɑ pɑ ŋmɑʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Amɑ Nowee tike kɛ Tɑcɑɑ lɑŋlɛ hɛɛnɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Nowee nɑ ɩ nyǝ́mɑ pɑ tɔm ntɔ. Nowee kɑ wɛnɑ piyɑ tooso kɛ́, Sem, nɑ Kɑm, nɑ Yɛfɛtɛ. Ɩ kɑ kɛ́ kʋpɑŋ kɛ́ nɑ ɩ́ siɣisɑɑ nɑ ɩ́ tǝŋǝɣɩ Ɩsɔ kɛ́ teu kɛ ɩ wɑɑtʋ tɑɑ nɑ Ɩsɔ wɛ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Yǝlɑɑ kɑ wɑkǝlɑɑ kɛ́, nɑ pɑ́ lɑkɩ tǝmɑɣɑ mʋsʋŋ kɛ Ɩsɔ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ɩsɔ nyǝnɑ tɛtʋ ɩlɛnɑ ɩ́ nɑ́ sɩ yǝlɑɑ tǝnɑ wɑkǝlɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mpʋɣʋlɛ Tɑcɑɑ heelɑ Nowee sɩ: Mɑ tʋ́ mɑ tɑɑ sɩ mɑɑ wɑkǝlɩ yǝlɑɑ tǝnɑ, mpɛ pɑ suulinɑ ɩsɑɣɑtʋ kɛ ɑntulinyɑ tɑɑ. Pǝ tɔɔ tɔ mɑɑ kpiisi pɑ tǝnɑɣɑ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Cɑɑ tʋɣʋ kʋpɑŋkʋ nɑkʋlɩ nɑ ń sɑɑkɩ nyɑ́ tǝɣɩ ɑtɑkɑɑ pɔɣɔlʋɣʋ sɔsɔɔʋ nɑ ń tɑlɑ kʋ tɑɑ kɛ́ nɑŋsi nɑŋsi, nɑ ń tɑɑ-kʋɣʋ tʋɣʋ cǝlǝm kɛ kʋ tɑɑ nɑ kʋ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ɩsǝnɑ n kɑ́ lɑ-kʋ tɔɣɔlɔ, kʋ tɑɣɑlǝŋ kɑ́ wɛɛ mɛɛtǝlǝnɑɑ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (150) nɑ kʋ wɑŋ kɛ mɛɛtǝlǝnɑɑ hiu nɑ kɑkpɑsɩ nɑ kʋ kʋŋkʋlʋmǝŋ kɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Nɑ ń tʋlɩ-kʋɣʋ pǝtote kɛ mpiiŋ nɑɑlɛ kɛ lɔpʋtʋ luɣu tɛɛ nɑ nɔnɔɣɔ kɛ kʋ kɔŋkɔŋ tɑɑ. Nɑ ń lɑ-kʋɣʋ ɑtɛ nɑ ɩsɔ kutuluŋ kɛ tooso. ");
INSERT INTO dop_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ɩlɛnɑ mɑ́ɑ́ yele nɑ lʋm sɔsɔɔm wɑtɩ tɛtʋ tɔɔ, nɑ mɑ́ kʋ́ pǝ tǝnɑ mpi pǝ feesiɣi tɔ. Tɛtʋ tɔɔ nyǝm tǝnɑ kɑ́ sǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Amɑ mɑ́ nɑ nyɑ́ tɩɩ pɛɛlɩ nɔɣɔ sɩ mɑɑ wɑɑsɩ-ŋ. Nɑ nyɑnɑ nyɑ́ ɑlʋ nɑ nyɑ́ pǝyɑlɑɑ nɑ nyɑ́ poolɑɑ ɩ́ kɑ́ sʋʋ kʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Nɑ ń lǝsɩ wontu tǝnɑ tɑɑ kɛ́ ɑpɑlʋ nɑ ɑlʋ, nɑ sumɑsɩ tɑɑ kɛ́ mpʋ nɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ tɑɑ kɛ́ mpʋ tɔtɔ, nɑ tǝ́ sʋʋ nyɑ́ kiŋ kɛ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ nɑ pǝ́ yɑ tǝ piitim. ");
INSERT INTO dop_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kpɑɣɑ tɔɣɔnɑsɩ nsi nsi mǝ nɑ wontunɑɑ mpɛ ɩ́ kɑ́ tɔkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Mpʋ ɩnǝɣɩ Nowee tǝŋɑɑ nɑ ɩ́ lɑ́ pǝ tǝnɑ mpi Ɩsɔ tʋ́-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Nowee sɩ: Nyɑnɑ nyɑ́ tǝyɑɣɑ tǝnɑ ɩ́ sʋʋ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ. Mpi tɔ, nyɑ́ tike kɛ mɑ nɑwɑ wei ɩ nɩɩkǝnɑ-m tɔɣɔ yǝlɑɑ pɑnɛ pɑ hɛkʋ. ");
INSERT INTO dop_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Lǝsɩ wontu nti pɑ pǝsǝɣɩ pɑ́ lɑ́ kɔtɑɣɑ tɔɣɔ ɑpɑlʋ nɑ ɑlʋ kɛ́ tɔm nɑɑtosompɔɣɔlɑɣɑ. Ɩlɛnɑ ń lǝsɩ nti tǝ fɛɩ kɔtɑɣɑ lɑpǝnɑʋ tɔɣɔ ɑpɑlʋ nɑ ɑlʋ tike. ");
INSERT INTO dop_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nɑ ń lǝsɩ sumɑsɩ tɑɑ kɛ́ ɑpɑlʋ nɑ ɑlʋ kɛ́ tɔm nɑɑtosompɔɣɔlɑɣɑ, nɑ ń wɑɑsɩ sɩ piitim nɑ sɩ tɑɑ tɛ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pǝ tɑɣɑ pʋlʋ tɔɔ, pǝ kɑɑsɑ wɛɛ nɑɑtosompɔɣɔlɑɣɑ kɛ́ nɑ mɑ́ yele nɑ tɛʋ nɩɩ ilim nɑ ɑhoo kɛ kʋyɛɛŋ nɩɩlɛ tǝcu, nɑ lʋm kpiisi yǝlɑɑ nɑ wontu tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ɩlɛnɑ Nowee lɑ pǝ tǝnɑ ɩsɩɩ Tɑcɑɑ heelɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Pǝnɑɣɑ ŋkɑ lʋm wɑɑsɑ tɛtʋ tɔ Nowee wɛnɑ ɩsɩɩ pɩɩsɩ nɑsǝtoso (600). ");
INSERT INTO dop_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ɩlɛnɑ ɩ́ nɑ ɩ ɑlʋ nɑ ɩ pǝyɑlɑɑ nɑ ɩ poolɑɑ pɑ́ sʋʋ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ nɑ pɑ́ fiti lʋm kʋ́wɑ́ɑ́sǝm mpɩ. ");
INSERT INTO dop_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ḿpʋ́ɣʋ́ wontu nti pɑ pǝsǝɣɩ pɑ́ lɑ́ kɔtɑɣɑ tɔ nɑ nti tǝ fɛɩ kɔtɑɣɑ lɑpǝnɑʋ tɔ nɑ sumɑsɩ nɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ tǝnɑ ");
INSERT INTO dop_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","sʋʋ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ kɛ́ ɑpɑlʋ nɑ ɑlʋ ɩsɩɩ Tɑcɑɑ kɑ heeluɣu Nowee tɔ. ");
INSERT INTO dop_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ tɛɛwɑ ɩlɛnɑ lʋm wɑtɩ tɛtʋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","12","Nowee lʋlʋɣʋ pǝnɑɣɑ nɑsǝtoso nyǝŋkɑ ɩsɔtʋ nɑɑlɛ nyǝŋ kʋyɛɛŋ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule kɛ tɛʋ ɑnɑɑm nɔɣɔlʋ ɩ́ pǝlɑ ilim nɑ ɑhoo, hɑlǝnɑ kʋyɛɛŋ nɩɩlɛ tǝcu. Pǝ cɑɣɑ kɛ́ ɩsɩɩ ɩsɔtɔnʋɣʋ yɑwɑ nɑ ɑtɛ sɛɛlɑɑ nɑ́ɑ́ tʋlɩ ɩsɩɩ pɔɔŋ sɔsɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Kʋyɑkʋ ŋkʋ kʋ mɑɣɑmɑɣɑ kɛ Nowee nɑ ɩ ɑlʋ nɑ ɩ pǝyɑlɑɑ Sem nɑ Kɑm nɑ Yɛfɛtɛ nɑ ɩ poolɑɑ tooso pɑ sʋʋ ɑtɑkɑɑ pɔɣɔlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Pɑ́ nɑ wontu tǝnɑɣɑ piitim piitim. Pǝ kpɑɣɑʋ tɔlɑ, nɑ tɑɑlɛ wontu, nɑ sumɑsɩ, nɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Ḿpʋ́ɣʋ́ wontu tǝnɑ sʋ́ʋ́ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ kɛ́ ɑpɑlʋ nɑ ɑlʋ ɩsɩɩ Ɩsɔ kɑ heeluɣu Nowee tɔ. Ɩlɛnɑ Tɑcɑɑ tǝkɩ pɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kʋyɛɛŋ nɩɩlɛ tǝcu kɛ́ tɛʋ nɩɩwɑ, ɩlɛnɑ lʋm kpɑ nɑ pǝ́ kɛlɩ ɑtɑkɑɑ pɔɣɔlʋɣʋ, nɑ pǝ́ kpɑɑsɩ-kʋɣʋ ɩsɔtɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Lʋm tɔɔwɑ sɔsɔm nɑ pǝ́ sú tɛtʋ tɔɔ nɑ ɑtɑkɑɑ pɔɣɔlʋɣʋ nɑ́ɑ́ wɛ pǝ tɔɔ tǝhʋŋlɛɛ. ");
INSERT INTO dop_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Pǝ tɔŋnɑ suɣu nɑ pǝ́ puki hɑlǝnɑ pǝ́ wɑɑsɩ pɔɔŋ sɔsɔɔŋ ɩnɩ ɩ tǝnɑ kɛ ɑntulinyɑ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Lʋm kpɑwɑ nɑ pǝ́ tɛɛ pɔɔŋ kɛ kʋŋkʋlʋmǝŋ kɛ mɛɛtǝlǝnɑɑ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Antulinyɑ tɑɑ weesuɣu nyǝm tǝnɑ sǝpǝnɑ, pǝ kpɑɣɑʋ yǝlɑɑ nɑ wontunɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ḿpʋ́ɣʋ́ Tɑcɑɑ kpiisɑ weesuɣu nyǝm tǝnɑɣɑ tɛtʋ tɔɔ. Nowee nɑ ɩ nyǝ́mɑ mpɑ pɑɑ wɛ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ tɔ pɑ tike kɛ pǝ yelɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ḿpʋ́ɣʋ́ lʋm suwɑ tɛtʋ tɔɔ kɛ́ kʋyɛɛŋ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (150) tǝcu. ");
INSERT INTO dop_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ɩsɔ tɑ́ sɔɔ Nowee nɑ wontunɑɑ mpɑ pɑɑ wɛ ɩ kiŋ kɛ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ tɔ pɑ tɔɔ. Ɩlɛnɑ ɩ́ yele nɑ heelim mɑ́ nɑ lʋm nyɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nɑ ɑtɛ sɛɛlɑɑ tǝkɩ nɑ ɩsɔtɔnʋɣʋ nyɑlɑ nɑ tɛʋ fɛɛ kʋ tɑ tɑsɑ nɩɩʋ. ");
INSERT INTO dop_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ɩlɛnɑ lʋm nyɔɔ tɛtʋ tɔɔ. Kʋyɛɛŋ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (150) tɑɑ kɛ́ lʋm cɑɑlɑ pɑsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ḿpʋ́ɣʋ́ ɑtɑkɑɑ pɔɣɔlʋɣʋ polɑɑ nɑ kʋ́ cɑɣɑ Alɑlɑɑ pʋɣʋ nyʋɣʋ tɑɑ kɛ́ ɩsɔtʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋ kʋyɛɛŋ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule. ");
INSERT INTO dop_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nɑ lʋm pɑsǝɣɩ mpʋ, hɑlǝnɑ ɩsɔtʋ nɑɑnʋwɑ nyǝŋ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ wule nte pǝ nyɩɩ pɔɔŋ nyɔɔŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kʋyɛɛŋ nɩɩlɛ tɛɛwɑ ɩlɛnɑ Nowee tʋlɩ ɑtɑkɑɑ pɔɣɔlʋɣʋ pǝtote ");
INSERT INTO dop_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","nɑ ɩ́ lǝsɩ kɑtǝkɑtʋɣʋ nɑ kʋ́ cɔɔkɩ ɩsɔtɑɑ kɛ́ yem, hɑlǝnɑ lʋm nyɔɔ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ɩlɛnɑ ɩ́ lǝsɩ ɑlukuku sɩ ɩ nɑɑ sɩ lʋm pɑsɑ tɛtʋ tɔɔ yɑ́ɑ́ ɩsǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Amɑ ɑlukuku lɑŋɑ timpi ɩ́ tɩɩ sopi sopuɣu mɑɣɑmɑɣɑ tɔ, ɩlɛnɑ ɩ́ mǝlǝnɑ Nowee tɔɔ. Mpi tɔ, lʋm kɑ́ wɑɑsɑ tɛtʋ tǝnɑ tɔɔ kɛ́. Nɑ Nowee siisi nɑ ɩ́ kpɑ ɑlukuku nɑ ɩ́ mǝlǝnɑ-ɩ ɩ kiŋ. ");
INSERT INTO dop_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nowee tɑsɑ tɑŋʋɣʋ tɔtɔɣɔ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ ɩlɛnɑ ɩ́ lǝsɩ ɑlukuku kɛ tɔm nɑɑlɛ nyǝm. ");
INSERT INTO dop_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tɑɑnɑɣɑ tɑɑnɑɑ ɩlɛnɑ ɩ́lɛ́ ɩ mǝlǝnɑ Nowee tɔɔ nɑ tʋɣʋ hɑtʋ kʋnɛɣɛtǝtʋ tʋʋnɑ ɩ nɔɣɔ. Tǝnɑɣɑlɛ Nowee cɛkǝnɑɑ sɩ lʋm pɑsɑ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nowee tɑsɑ tɑŋʋɣʋ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ tɔtɔ, ɩlɛnɑ ɩ́ tɑsɑ ɑlukuku kɛ lǝsʋɣʋ kɛ tɔm tooso nyǝm. Amɑ ɑlukuku tɑ tɑsɑ mǝlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Pǝnɑɣɑ nɑsǝtoso nɑ kʋlʋmɑɣɑ nyǝŋkɑ ɩsɔtʋ kɑncɑɑlɑɣɑ nyǝŋ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ kɛ lʋm nyɔɔwɑ tɛtʋ tɔɔ. Nowee kɔɔlɑ ɑtɑkɑɑ pɔɣɔlʋɣʋ lɔpʋtʋ ɩlɛnɑ ɩ́ nɑ́ sɩ tɛtʋ wʋlɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ɩsɔtʋ nɑɑlɛ nyǝŋ kʋyɑkʋ hiu wule kɛ tɛtʋ tɔɔ wʋlɑɑ tǝwɑɣɑwɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Mpʋɣʋlɛ Ɩsɔ tɔmɑ Nowee sɩ: ");
INSERT INTO dop_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Nyɑnɑ nyɑ́ ɑlʋ nɑ nyɑ́ pǝyɑlɑɑ nɑ nyɑ́ poolɑɑ ɩ́ lɩɩ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nɑ ń kpɛnnɑ wontunɑɑ ntɩ tǝ tǝnɑ. Pǝ kpɑɣɑʋ tɔlɑ nɑ sumɑsɩ nɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ tǝnɑ tɔ, tǝ́ lʋlɩ nɑ tǝ́ huki nɑ tǝ́ yɑ́ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","19","Ɩlɛnɑ Nowee-wɛ nɑ wontu tǝnɑ pɑ́ lɩɩ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ḿpʋ́ɣʋ́ Nowee ŋmɑ́ Tɑcɑɑ kɛ kɔtɑɣɑ tǝlɑtɛ, ɩlɛnɑ ɩ́ lǝsɩ wontu tǝnɑ nti tǝ mʋnɑ kɔtɑɣɑ lɑpʋ tɔ nɑ sumɑsɩ nsi sɩ mʋnɑ kɔtɑɣɑ lɑpʋ tɔ sɩ tǝnɑ sɩ tɑɑ kɛ́ kʋlʋm kʋlʋm ɩsɩɩ tǝ piitimnɑɑ wɛɛ tɔ nɑ ɩ́ lɑ́ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Tɑcɑɑ nɩɩ kɔtɑɣɑ ŋkɛ kɑ sɔɔsʋŋ nɑ ɩ lɑŋlɛ hɛɛ nɑ ɩ́ tɔ́ sɩ: Mɑ kɑɑ tɑsɑ tɛtʋ kɛ mpusi tǝŋsʋɣʋ kɛ yʋlʋ ɩsɑɣɑtʋ tɔɔ ɩsɩɩ mɑɑ lɑpʋ tɔ, nɑ mɑ kɑɑ tɑsɑ weesuɣu nyǝm tǝnɑɣɑ wɑkǝlʋɣʋ. Mpi tɔ, yʋlʋ lǝmɑɣɑsǝlɛ kɛ́ ɩsɑɣɑlɛ kɛ hɑtoo ɩ hɔɔʋ tɛɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tuutu nɑ kʋmtʋ, wɑtʋ nɑ hɑŋɑɣɑ, lʋŋlɛ nɑ yolumɑ, ilim nɑ ɑhoo pǝ kɑɑ yele lɑpʋ hɑlǝnɑ ɑntulinyɑ polo nɑ ɩ́ kʋlɩ. ");
INSERT INTO dop_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ḿpʋ́ɣʋ́ Ɩsɔ koolɑ Nowee nɑ ɩ piyɑ kɛ kʋpɑntʋ sɩ: Ɩ́ lʋlɩ nɑ ɩ́ huki nɑ ɩ́ sú tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mɑ tʋ́ mǝ niŋ tɑɑ kɛ́ wontunɑɑ tǝnɑɣɑ, pɑɑ ɑtɛ nyǝntʋ, nɑ sumɑsɩ, nɑ tiinɑ, nɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ. Pǝ tɔɔ kɛ́ wontu ntɩ tɩɩ wɛɛnɑ mǝ sɔɣɔntʋ kɛ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ɩ́ pǝsǝɣɩ nɑ ɩ́ tɔɣɔ wontunɑɑ mpɛ ɩsɩɩ ɩ́ tɔkʋɣʋ kʋnyɔnyɔm tɔ. ");
INSERT INTO dop_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Amɑ kʋlʋmtʋ kɛ́ sɩ ye ɩ cɑɑ kpǝntɛ kɛ tɔɣɔʋ, ɩ́ lɛntɩ nɑ cɑlǝm lɩɩ nɑ pǝ́cɔ́. Mpi tɔ, cɑlǝm tɑɑ kɛ́ weesuɣu wɛɛ. ");
INSERT INTO dop_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ye wei ɩ́ kʋwɑ yʋlʋ, mɑɑ lɛɛtɩ pʋntʋ, pɑɑ yʋlʋ pɑɑ wontuɣu. ");
INSERT INTO dop_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ye nɔɣɔlʋ kʋwɑ ɩ tɔɣɔntǝlɛ, yʋlʋ tɔtɔ kɑ́ kʋnɑ pʋntʋ. Mpi tɔ, Ɩsɔ ŋmɑ́ yʋlʋ kɛ́ ɩsɩɩ ɩ mɑɣɑmɑɣɑ ɩ wɛɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Mɛ mɩɩ lʋlɩ nɑ ɩ́ huki nɑ ɩ́ yɑ́ tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ḿpʋ́ɣʋ́ Ɩsɔ tɑsɑ Nowee nɑ ɩ pǝyɑlɑɑ kɛ heeluɣu sɩ: ");
INSERT INTO dop_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Mɑ́ nɑ-mɛ tɩɩ pɛɛlɩ nɔɣɔ nɑ kɑ́ wɛɛ mpʋ hɑlǝnɑ mǝ lʋlʋɣʋ nyǝ́mɑ kɛ mǝ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Nɑ pǝ́ kpɛnnɑ wontu tǝnɑ nti tǝ lɩ́ɩ́ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mɑ sɩɩkɩ mɑ nɔɣɔ sɩ mɑ kɑɑ tɑsɑ weesuɣu nyǝm kpiisuɣu kɛ tɛtʋ tɔɔ nɑ lʋm. Pǝ́cɔ́ lʋm kʋ́wɑ́ɑ́sǝm mpɩ pǝ kɑɑ tɑsɑ kɔntɛ nɑ pǝ́ wɑkǝlɩ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ɩlɛnɑ Ɩsɔ tɑsɑ sɩ: Mɑ tʋɣɩ kɑɣɑlʋ nɑ ɩ́ hʋ́lǝ́ɣɩ́ tɑm tɔɔ kɛ́ nɔɣɔ ŋkɑ mɑ́ nɑ-mɛ nɑ weesuɣu nyǝm tǝnɑ nɑ mǝ wɑɑlɩ lʋlʋɣʋ nyǝ́mɑ tǝ pɛɛlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Mɑ́ kɔmɑ nɑ mɑ́ kpeɣelɑ ŋmʋntʋ kɛ ɩsɔtɑɑ, kɑɣɑlʋ kɑ kɑɣɑ kɛ́, ");
INSERT INTO dop_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ɩlɛnɑ pǝ́ tɔɔsɩ-m nɔɣɔ ŋkɑ mɑ sɩɩ mǝ nɑ weesuɣu nyǝm tǝnɑ sɩ lʋm kʋ́wɑ́ɑ́sǝm mpɩ pǝ kɑɑ tɑsɑ kɔntɛ nɑ pǝ́ kpiisi weesuɣu nyǝm. ");
INSERT INTO dop_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ɩsɔtɔnʋɣʋ tɑɑ kɛ́ kɑɣɑlʋ kɑ́ kɑɣɑ, nɑ mɑ́ nyǝnɑ-ɩ ɩlɛ pǝ tɔɔsɩ-m nɔɣɔ ŋkɑ mɑ sɩɩ weesuɣu nyǝm tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Mpi pǝ hʋlǝɣɩ nɔɣɔ ŋkɑ mɑ sɩɩ-wɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowee nɑ ɩ pǝyɑlɑɑ mpɑ pɑ lɩɩ ɑtɑkɑɑ pɔɣɔlʋɣʋ tɑɑ tɔɣɔlɛ Sem nɑ Kɑm nɑ Yɛfɛtɛ. Kɑm ɩ́lɛ́ ɩ́ lʋlǝnɑ Kɑnɑɑŋ. ");
INSERT INTO dop_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nowee piyɑ mpɛ pɑ piitim hukinɑ ɑntulinyɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ḿpʋ́ɣʋ́ Nowee nikɑ tɛtʋ hɑlǝm nɑ ɩ́ cɑɑlɩ lɛsɛŋnɑɑ sɔʋ. ");
INSERT INTO dop_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ɩlɛnɑ ɩ́ nyɔɔ pǝ sʋlʋm nɑ pǝ́ kʋ́-ɩ nɑ ɩ́ wɔɣɔsɩ ɩ wontu nɑ pǝ́ yele-ɩ tɑpɑkpɛtɛ kɛ cokǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mpʋɣʋlɛ Kɑnɑɑŋ cɑɑ Kɑm nɑwɑ ɩ cɑɑ tɑpɑkpɛtɛ, nɑ ɩ́ nyǝnɩ, ɩlɛnɑ ɩ́ polo nɑ ɩ́ tɑɣɑsɩ ɩ tɑɑlʋnɑɑ kɛ ɑwɑlɩ. ");
INSERT INTO dop_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ntɛnɑ Sem nɑ Yɛfɛtɛ pɑ́ kpɑɣɑ kpɑɩ nɑ pɑ́ hɔɣɔlɩ-ɩ nɑ pɑ́ tɔnɑ wɑɑlɩ wɑɑlɩ nɑ pɑ́ tɑkɩ pɑ cɑɑ. Ɩlɛ pɑ tɑ nɑ ɩ tɑpɑkpɛtɛ. Mpi tɔ, wɑɑlɩ wɑɑlɩ kɛ́ pɑ tɔmnɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nowee sʋlʋm kɔmɑ nɑ pǝ́ cɛ́ ɩ ɩsɛntɔɔ nɑ ɩ́ nɩɩ nti ɩ pǝyɑlʋ sǝkpelu nyǝŋ Kɑm lɑpɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ɩlɛnɑ ɩ́ tɔ́ sɩ: Mpusi ɩ́ tǝŋ Kɑm pǝyɑlʋ Kɑnɑɑŋ nɑ pǝ́ lɑpɩ-ɩ ɩ tɑɑlʋnɑɑ yom tǝkpɑpɑ. ");
INSERT INTO dop_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mɑ sɑmɑ Sem Ɩsɔ Tɑcɑɑ. Pǝ́ lɑ Kɑnɑɑŋ kɛ Sem-wɛ pɑ yom. ");
INSERT INTO dop_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ɩsɔ ɩ́ wɑlǝsɩ Yɛfɛtɛ tǝhikile, nɑ ɩ́ cɑɣɑ Sem tɛ́, nɑ pǝ́ lɑ́ Kɑnɑɑŋ kɛ pɑ yom. ");
INSERT INTO dop_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pɩɩsɩ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (350) kɛ́ Nowee tɑsɑ tɔɣɔʋ kɛ lʋm wɑɑsʋɣʋ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ɩ pɩɩsɩ tǝnɑ yoosɑ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (950) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nowee piyɑ Sem nɑ Kɑm nɑ Yɛfɛtɛ pɑ lʋlɑ piyɑ mpɑɣɑ lʋm wɑɑsʋɣʋ wɑɑlɩ tɔ pɑ hǝlɑ ntɔ. ");
INSERT INTO dop_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yɛfɛtɛ ɩ́lɛ́ ɩ́ piyɑ ntɔ. Komɛɛ, nɑ Mɑkɔkɩ, nɑ Mɑtɑyi, nɑ Yɑfɑŋ, nɑ Tupɑɑlɩ, nɑ Mesɛkɩ, nɑ Tilɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Komɛɛ ɩ́lɛ́ ɩ́ piyɑ ntɛ́ Asǝkǝnɑɑsɩ, nɑ Lifɑ, nɑ Tokɑɑmɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yɑfɑŋ piyɑ ntɛ́, Ɩlisɑ, nɑ Tɑɑsɩ, nɑ Kitim, nɑ Lutɑnim. ");
INSERT INTO dop_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Mpɛ ɩnɩ pɑ hukinɑ tɛtʋ nti lʋm cɔɔnɑɑ tɔ tǝ tɑɑ ɩsɩɩ tǝ nɑɑkʋɣʋ-wɛ nɑ pɑɑ wei nɑ ɩ nsǝmlɛ nɑ ɩ lʋlʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kɑm ɩ́lɛ́ ɩ́ piyɑ ntɛ́ Kusi, nɑ Misilɑyim, nɑ Puti nɑ Kɑnɑɑŋ. ");
INSERT INTO dop_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusi piyɑ ntɛ́ Sepɑ, nɑ Hɑfilɑ, nɑ Sɑpǝtɑ, nɑ Lɑkǝmɑ, nɑ Sɑpǝtekɑ. Lɑkǝmɑ piyɑ ntɛ́, Sɑpɑɑ, nɑ Tetɑŋ. ");
INSERT INTO dop_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusi lʋlǝnɑ tɔtɔɣɔ Nimloti, ɩnɩ ɩ cɑɑlǝnɑ tɛtʋnɑɑ kɛ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Tɑcɑɑ sǝnɑ-ɩ kɛ́ nɑ ɩ́ pǝsɩ yɛllɑɑ tɑɑ yɛllʋ. Pǝ tɔɔ kɛ́ pɑ tukɑɣɑ ɩtuule kɛ wɑɑtʋ ɩnɩ sɩ: Tɑcɑɑ ɩ́ yele nɑ ń pǝsɩ yɛllɑɑ tɑɑ yɛllʋ ɩsɩɩ Nimloti. ");
INSERT INTO dop_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Acɑlɛɛ wenɑ ɑ tɔɔ Nimloti tɔɣɔ kɑwulɑɣɑ tɔɣɔlɛ Pɑpɛɛlɩ, nɑ Ɩlɛkɩ, nɑ Akɑtɩ, nɑ Kɑlǝne kɛ Pɑpiloni tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Tɛtʋ ntɩ tǝ tɑɑ kɛ́ ɩ lɩɩwɑ nɑ ɩ́ polo Asilii nɑ ɩ́ ŋmɑ́ Ninifi, nɑ Lehopoti-Hiili, nɑ Kelɑ, ");
INSERT INTO dop_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","nɑ Lɛsɑŋ kɛ Ninifi nɑ Kelɑ ɩcɑtɛ sɔsɔɔlɛ pɑ hɛkʋ. ");
INSERT INTO dop_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misilɑyim nɑ́ lʋlǝnɑ ntɛɣɛ Lutɩ nyǝ́mɑ, nɑ Anem nyǝ́mɑ, nɑ Lehɑpɩ nyǝ́mɑ, nɑ Nɑfutu nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","nɑ Pɑtǝlɔsɩ nyǝ́mɑ, nɑ Kɑsulu nyǝ́mɑ, nɑ Kɑfǝtɔɔ nyǝ́mɑ. Tǝnɑɣɑ Filiisi nyǝ́mɑ nɑ́ lɩɩwɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kɑnɑɑŋ ɩ́lɛ́ ɩ́ kɑncɑɑlɑɣɑ pǝyɑɣɑ ntɛ́ Sitɔŋ nɑ nɑɑlɛ nyǝŋ ntɛ́ Hɛtɩ, ");
INSERT INTO dop_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","nɑ ɩ lʋlʋɣʋ nyǝ́mɑ tɔtɔɣɔlɛ Yepusi nyǝ́mɑ, nɑ Amolii nyǝ́mɑ, nɑ Kilikɑsɩ nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","nɑ Hifi nyǝ́mɑ, nɑ Alǝki nyǝ́mɑ nɑ Sini nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","nɑ Alǝfɑtɩ nyǝ́mɑ, nɑ Semɑlii nyǝ́mɑ, nɑ Hɑmɑtɩ nyǝ́mɑ. Pǝ wɑɑlɩ kɛ́ Kɑnɑɑŋ lʋlʋŋ nyǝ́mɑ nɑ́ yɑwɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Nɑ pɑ tɛtʋ toosi ntɛ́ pǝ kpɑɣɑʋ Sitɔŋ kɛ Keelɑɑ kɔŋkɔŋ tɑɑ nɑ pǝ́ polo Sɔtɔm nɑ Kɔmɔɔ nɑ Atǝmɑ nɑ Sepoyim hɑlǝnɑ Lesɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Kɑm ɩnɩ ɩ piyɑ ntɛ́, nɑ pǝ́ kɛɛsǝnɑ ɩsɩɩ pɑ lʋlʋŋ nɑ pɑ nsǝmɑ nɑ pɑ tɛtʋ nɑ pɑ piitimnɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yɛfɛtɛ pɑ tɑɑlʋ Sem ɩ́lɛ́ ɩ lʋlɑ piyɑ tɔtɔ nɑ kʋlʋm ɩnǝɣǝlɛ Ɩpɛɛ nɑ ɩ lʋlʋŋ nyǝ́mɑ cɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ɩ piyɑ mpɛɣɛlɛ Ɩlɑm, nɑ Asuu, nɑ Alǝpɑsɑtɩ, nɑ Lutɩ, nɑ Alɑm. ");
INSERT INTO dop_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alɑm ɩ́lɛ́ ɩ́ piyɑ ntɛ, Usi, nɑ Huuli, nɑ Ketɛɛ, nɑ Mɑcɩ. ");
INSERT INTO dop_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alǝpɑsɑtɩ nɑ́ lʋlɑ Selɑ nɑ ɩ́lɛ́ ɩ lʋlɩ Ɩpɛɛ. ");
INSERT INTO dop_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ɩpɛɛ nɑ́ lʋlɑ piyɑ nɑɑlɛɣɛ, kɑncɑɑlɑɣɑ nyǝŋkɑ hǝtɛ ntɛ́ Pelɛkɩ, yɑʋ kɛ pɑ yɑɑ mpʋ nɑ pɑ tɛ́ tɑɑ. Mpi tɔ, wɑɑtʋ ɩnǝɣɩ ɑntulinyɑ piitimnɑɑ yɑwɑ. Ɩ́lɛ́ ɩ́ neu hǝtɛ ntɛ́ Yɔkǝtɑŋ. ");
INSERT INTO dop_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yɔkǝtɑŋ nɑ́ lʋlǝnɑ Alǝmotɑtɩ, nɑ Selɛfɩ, nɑ Hɑsɑmɑfɛtɩ, nɑ Yelɑ, ");
INSERT INTO dop_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","nɑ Hɑtolɑm, nɑ Wusɑɑlɩ, nɑ Tikǝlɑ, ");
INSERT INTO dop_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","nɑ Opɑlɩ, nɑ Apimɑyɛlɩ, nɑ Sɑpɑ, ");
INSERT INTO dop_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","nɑ Ofii, nɑ Hɑfilɑ, nɑ Yopɑpɩ. Yɔkǝtɑŋ piyɑ ntɛ́ pɑ tǝnɑɣɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Pɑ tǝcɑɣɑlɛ ntɛ́ pǝ kpɑɣɑʋ Mesɑ nɑ pulɑsɩ hɔɣɔlʋɣʋ ŋku pɑ yɑɑ sɩ Sefɑɑ tɔ nɑ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sem ɩnɩ ɩ piyɑ ntɛ́ nɑ pǝ́ kɛɛsǝnɑ pɑ lʋlʋŋ nɑ pɑ nsǝmɑ nɑ pɑ tɛtʋ nɑ pɑ piitimnɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nowee piyɑ lʋlʋŋ ntɛ́ nɑ pǝ́ kɛɛsǝnɑ pɑ lʋlʋŋ loosi, nɑ pɑ piitim nɑ mpɛ ɩnɩ pɑ tɑɑ kɛ́ piitimnɑɑ lɩɩwɑ nɑ pɑ́ yɑ́ ɑntulinyɑ tɑɑ kɛ́ lʋm wɑɑ́sʋɣʋ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Wɑɑtʋ ɩnɩ ɩ tɑɑ yǝlɑɑ tǝnɑ yɔɣɔtɑɣɑ nsǝmlɛ kʋlʋmtǝlɛ. ");
INSERT INTO dop_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ɩlɛnɑ pɑ́ lɩɩ ilim tǝlɩɩlɛ tɔɔ nɑ pɑ́ tɑlɑ Pɑpiloni tɛtɛkǝlɛ sɔsɔɔlɛ tɑɑ nɑ pɑ́ siki tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Mpʋɣʋlɛ pɑ heelɑ tǝmɑ sɩ: Ɩ́ kɔɔ nɑ tǝ́ loo pilikinɑɑ nɑ tǝ́ wɔ-wɛɣɛ kɔkɔ. Ɩlɛnɑ pɑ́ lɑnɑ pilikinɑɑ kɛ pɛɛ lonte nɑ pɑ́ lɑnɑ kɑɑloo kɛ́ somtu lonte. ");
INSERT INTO dop_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Nɑ pɑ́ tɑsɑ yɔɣɔtʋɣʋ sɩ: Ɩ́ kɔɔ nɑ tǝ́ ŋmɑ́ ɑtɛ nɑ ɩsɔ kutuluɣu ɑnɑɑm nɑ kʋ́ yoosinɑ ɩsɔtɔnʋɣʋ nɑ tɑ́ hǝtɛ yɑɑ. Ɩlɛ tǝ kɑɑ tɑsɑ yɑʋ kɛ yem kɛ́ tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mpʋɣʋlɛ Tɑcɑɑ tiiwɑ sɩ ɩ nɑɑkɩ ɩcɑtɛ nɑ ɑtɛ nɑ ɩsɔ kutuluɣu ŋku yǝlɑɑ piyɑ ŋmɑwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ɩlɛnɑ Tɑcɑɑ tɔ́ sɩ: Ɩ́ nɑwɑ, pɑ tǝnɑ ɩsǝntɔ pɑ kɛ́ yǝlɑɑ kʋlʋmɑɑ kɛ́, nɑ pɑ kɑɑ nsǝmlɛ kʋlʋmtǝlɛ. Pɑ cɑɑlʋɣʋ ɩsǝntɔ tɔ pʋlʋpʋ kɑɑ kɑɣɑtɩ-wɛɣɛ mpi pɑɑ hɔkɔ sɩ pɑ lɑkɩ tɔ pǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ɩlɛ mɑɑ tii nɑ mɑ liɣiti pɑ nsǝmlɛ nɑ pɑ́ tɑɑ nɩɩkɩ tǝmɑ kʋyɔɣɔtʋtʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ntɛnɑ Tɑcɑɑ yɑsɩ-wɛɣɛ ɑntulinyɑ tǝnɑ tɑɑ nɑ pɑ́ yele pɑ ɩcɑtɛ ŋmɑʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Mpʋ pǝ yelinɑ nɑ pɑ́ hɑ ɩcɑtɛ ntɛɣɛ hǝtɛ sɩ Pɑpɛɛlɩ. Mpi tɔ, tǝnɑɣɑ Tɑcɑɑ liɣitɑ yǝlɑɑ nsǝmlɛ, nɑ ɩ́ yɑsɩ-wɛɣɛ ɑntulinyɑ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sem lʋlʋɣʋ nyǝ́mɑ hǝlɑ ntɔ cǝnɛ. Ɩ lʋlʋɣʋ pɩɩsɩ nɩɩnʋwɑ (100) nyǝŋkɑ tɑɑ, lʋm wɑɑsʋɣʋ wɑɑlɩ pǝnɑɣɑ nɑɑlɛ nyǝŋkɑ tɑɑ kɛ́ ɩ lʋlɑ Alǝpɑsɑtɩ. ");
INSERT INTO dop_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Alǝpɑsɑtɩ lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ nɑsǝlɛ nɑ nɩɩnʋwɑ (500) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alǝpɑsɑtɩ pɩɩsɩ lɑpɑ hiu nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ ɩlɛnɑ ɩ́ lʋlɩ Selɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Selɑ lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ nɑsǝlɛ nɑ tooso (403) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Selɑ pɩɩsɩ lɑpɑ hiu nɑ nɑɑnʋwɑ ɩlɛnɑ ɩ́ lʋlɩ Ɩpɛɛ. ");
INSERT INTO dop_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ɩpɛɛ lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ nɑsǝlɛ nɑ tooso (403) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ɩpɛɛ pɩɩsɩ lɑpɑ hiu nɑ nɑɑnʋwɑ nɑ liɣiti ɩlɛnɑ ɩ́ lʋlɩ Pelɛkɩ. ");
INSERT INTO dop_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelɛkɩ lʋlʋɣʋ wɑɑlɩ Ɩpɛɛ tɔɣɔ pɩɩsɩ nɑsǝlɛ nɑ hiu nɑ nɑɑnʋwɑ (430) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelɛkɩ pɩɩsɩ lɑpɑ hiu nɑ nɑɑnʋwɑ kɛ́ ɩlɛnɑ ɩ́ lʋlɩ Leu. ");
INSERT INTO dop_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Leu lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ pɔɣɔlɑɣɑfɛɩ ŋmʋnʋɣʋ nɑ nɑɑnʋwɑ (209) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leu pɩɩsɩ lɑpɑ hiu nɑ nɑɑnʋwɑ nɑ nɑɑlɛ kɛ́ ɩlɛnɑ ɩ́ lʋlɩ Selu. ");
INSERT INTO dop_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Selu lʋlʋɣʋ wɑɑlɩ Leu tɔɣɔ pɩɩsɩ ŋmʋnʋɣʋ nɑ nɑɑtosompɔɣɔlɑɣɑ (207) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selu pɩɩsɩ lɑpɑ hiu nɑ nɑɑnʋwɑ ɩlɛnɑ ɩ́ lʋlɩ Nɑhoo. ");
INSERT INTO dop_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nɑhoo lʋlʋɣʋ wɑɑlɩ ɩ tɔɣɔ pɩɩsɩ ŋmʋnʋɣʋ (200) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nɑhoo pɩɩsɩ lɑpɑ pɔɣɔlɑɣɑfɛɩ hiu nɑ nɑɑnʋwɑ kɛ́ ɩlɛnɑ ɩ́ lʋlɩ Telɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Telɑ lʋlʋɣʋ wɑɑlɩ Nɑhoo tɔɣɔ pɩɩsɩ pɔɣɔlɑɣɑfɛɩ nɩɩnʋwɑ nɑ hiu (119) nɑ sɩ tɑɑ kɛ́ ɩ tɑsɑ ɑpɑlʋpiyɑ nɑ ɑlʋpiyɑ kɛ lʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Telɑ pɩɩsɩ lɑpɑ nɩɩtoso nɑ nɑɑnʋwɑ kɛ́ ɩlɛnɑ ɩ́ lʋlɩ Apǝlɑm nɑ Nɑhoo nɑ Hɑlɑŋ. ");
INSERT INTO dop_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Telɑ lʋlʋɣʋ nyǝ́mɑ hǝlɑ ntɔ cǝnɛ. Ɩ lʋlɑ Apǝlɑm, nɑ Nɑhoo, nɑ Hɑlɑŋ. Ɩlɛnɑ Hɑlɑŋ nɑ́ɑ́ lʋlɩ Lɔɔtɩ. ");
INSERT INTO dop_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Amɑ Hɑlɑŋ nɑ́ sǝpɑ Uu ɩcɑtɛ tɑɑ timpi pɑ lʋlɑ-ɩ tɔɣɔ Pɑpiloni tɛtʋ tɑɑ nɑ ɩ cɑɑ Telɑ tɑ sǝtɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ɩlɛnɑ Apǝlɑm nɑ́ɑ́ kpɑɣɑ Sɑlɑɩ, nɑ Nɑhoo nɑ́ɑ́ kpɑɣɑ Ɩsikɑ cɑɑ Hɑlɑŋ pɛɛlɔ Milikɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sɑlɑɩ ɩ́lɛ́ ɩ́ kɑ kɛ́ kɑɑlʋlɑɣɑ kɛ́ ɩ fɛɩ pǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ḿpʋ́ɣʋ́ Telɑ kpɑɣɑ ɩ pǝyɑlʋ Apǝlɑm nɑ ɩ sɑɑlɩ Lɔɔtɩ nɑ ɩ poolu Sɑlɑɩ nɑ pɑ́ lɩɩ Uu kɛ Pɑpiloni sɩ pɑ puki Kɑnɑɑŋ tɛtʋ tɑɑ. Pɑ tɑlɑ Hɑlɑŋ ɩcɑtɛ tɑɑ ɩlɛnɑ pɑ́ cɑɣɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Telɑ pɩɩsɩ tǝnɑ yoosɑ ŋmʋnʋɣʋ nɑ kɑkpɑsɩ (205) ɩlɛnɑ ɩ́ sɩ́ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Tɑcɑɑ heelɑ Apǝlɑm sɩ: Lɩɩ nyɑ́ tɛtʋ tɑɑ kɛ́ nyɑ́ nyǝ́mɑ hɛkʋ kɛ nyɑ́ cɑɑ tǝyɑɣɑ tɑɑ, nɑ ń polo tɛtʋ nti mɑɑ hʋlɩ-ŋ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mɑɑ yele nɑ nyɑ́ piitim lɑ sɔsɔɔm nɑ mɑ́ kooli-ŋ kʋpɑntʋ, nɑ nyɑ́ hǝtɛ yɑɑ, nɑ ń pǝsɩ kʋpɑntʋ tiipiiu. ");
INSERT INTO dop_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mɑɑ kooli kʋpɑntʋ kɛ nyɑ́ kʋpɑntʋ koollɑɑ nɑ mɑ sʋkɩ mpusi kɛ́ mpɑ pɛlɛ pɑɑ sʋkɩ-ŋ mpusi tɔ. Nyɑ́ tɔɔ kɛ́ ɑtɛ piitimnɑɑ kɑ́ hiki nyʋleleŋ nɑ pǝ́ kooli-wɛɣɛ koolee kʋpɑnɑ. ");
INSERT INTO dop_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Mpʋɣʋlɛ Apǝlɑm kpɑɣɑ ɩ ɑlʋ Sɑlɑɩ nɑ ɩ tɑɑlʋ pǝyɑɣɑ Lɔɔtɩ nɑ ɩ wɛnɑʋ tǝnɑ nɑ ɩ tǝmlɛ nyǝ́mɑ mpɑ ɩ hikɑ Hɑlɑŋ tɔ nɑ ɩ́ lɩɩ tǝnɑ ɩsɩɩ Tɑcɑɑ kɑ heeluɣu-ɩ tɔ nɑ ɩ́ tɛɛ Kɑnɑɑŋ tɛtʋ tɑɑ. Wɑɑtʋ ɩnɩ ɩ pɩɩsɩ kɑ wɛ nɩɩtoso nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ. Ɩ tɑpɑ tɛtʋ ntɩ ɩlɛnɑ ");
INSERT INTO dop_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ɩ́ fɑɣɑ tǝ tɑɑ nɑ ɩ́ polo Molee tɩɩŋ sɔsɔɔŋ tɛɛ kɛ́ timpi pɑ yɑɑ sɩ Sikɛm tɔ. Wɑɑtʋ ɩnɩ Kɑnɑɑŋ nyǝ́mɑ kɑ́ wɛnnɑ hɔɣɔlʋɣʋ ŋkʋ kʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yɑkɔpʋ wei pɑ cuɣusɑɑ sɩ Ɩsɛɣɛlɩ tɔ, ɩ́ nɑ ɩ pǝyɑlɑɑ mpɑ pɑ polɑ Icipiti kɛ cɑɣɑlʋtʋ tɔ, pɑ lʋlʋŋ loosi nɑ pɑ hǝlɑ ntɔ. ");
INSERT INTO dop_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Lupɛŋ, nɑ Simiyɔŋ, nɑ Lefii, nɑ Yutɑ, nɑ ");
INSERT INTO dop_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Ɩsɑkɑɑ, nɑ Sɑpulɔŋ, nɑ Pɛncɑmɛɛ, ");
INSERT INTO dop_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","nɑ Tɑŋ, nɑ Nɛfǝtɑli, nɑ Kɑtɩ, nɑ Asɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yɑkɔpʋ pǝyɑlɑɑ nɑ ɩ sɑɑlǝnɑɑ mpɛ pɑ tǝnɑ pɑɑ wɛ yʋlʋnyɔɔŋ nɩɩtoso nɑ nɑɑnʋwɑ (70) kɛ́. Ɩlɛ ɩ pǝyɑlʋ lɛlʋ Yosɛɛfʋ nɑ́ lɑɑlɑ-wɛɣɛ Icipiti kɛ pote. ");
INSERT INTO dop_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Pǝ wɑɑlɩ kɛ́ Yosɛɛfʋ nɑ ɩ tɑɑlʋnɑɑ mpɑ pɑɑ polɑ Icipiti tɔ pɑ sǝpɑ pɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Pɑɑ nɑ mpʋ Ɩsɛɣɛlɩ nyǝ́mɑ mpɛ pɑ hukɑ teu tǝyomyom nɑ pɑ́ sú tɛtʋ nɑ pɑ toŋ fɛɩnɑ sɑɑlɑ. ");
INSERT INTO dop_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ḿpʋ́ɣʋ́ wulɑʋ kʋfɑlʋ nɔɣɔlʋ nɑ́ tɔɣɔ kɑwulɑɣɑ. Amɑ ɩ́lɛ́ ɩ tɑ nyɩ Yosɛɛfʋ. ");
INSERT INTO dop_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ntɛnɑ ɩ́ koti ɩ yǝlɑɑ nɑ ɩ́ tɔ-wɛ sɩ: Ɩ́ nyǝnɩ, Ɩsɛɣɛlɩ nyǝ́mɑ kǝlɑ-tʋɣʋ sɑmɑɑ nɑ toŋ, pɑ wɛ-tʋɣʋ ɑsolɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mpʋ tɔ, pǝ wɛɛ sɩ tǝ́ pɛɛkɩ yɑɑsi wei tɩɩ pɑsǝnɑ-wɛ tɔ. Pǝ́ tɑɑ kɔɔ nɑ pǝ́ yoosi tɑ́ nɑ tɑ́ kolontunɑɑ nɑ mpɛ pɑ́ sɛɛnɑ pɑ tɔɔ nɑ pɑ́ kǝlɩ-tʋ. Ɩlɛnɑ pɑ́ se nɑ pɑ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tǝnɑɣɑlɛ Icipiti nyǝ́mɑ tʋwɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ yomle tǝmɑ wɑhɑlɑ nyǝnɑ. Nɑ pɑ́ kpɑ ɑ feŋlɑɑ nɑ pɛlɛ pɑ́ tʋɣʋ-wɛɣɛ-yɛ. Hɑlɩ Ɩsɛɣɛlɩ nyǝ́mɑ mpɛ pɑ ŋmɑnɑ ɑcɑlɛɛ wenɑ pɑ yɑɑ sɩ Pitom nɑ Lɑmsɛsɩ tɔ. Tǝnɑɣɑ Icipiti wulɑʋ sɩɩkɩ ɩ wontu. ");
INSERT INTO dop_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pɑɑ nɑ pɑ tǝmɑ ɑnǝɣɩ mpʋ tɔ, pɑ tɔŋnɑ hukuɣu kɛ́ nɑ pɑ́ suɣi tɛtʋ. Ɩlɛnɑ Icipiti nyǝ́mɑ tɛɛ nɑ́ɑ́ sʋʋkǝnɑ-wɛɣɛ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Ḿpʋ́ɣʋ́ pɑ tʋ-wɛɣɛ yomle tǝmɑ. Ɩlɛnɑ pɛlɛ pɑ́ lɩɩ pɑ tǝɣɩ luɣu. Mpi tɔ, cʋɣʋ kɛ pɑ cɑsɑɣɑ nɑ pɑ́ ŋmɑɑkɩ pilikinɑɑ, nɑ pɑ́ lɑkɩ tɑwɑ tǝmɑ tǝnɑ. Pɑ tʋkɑɣɑ-wɛɣɛ-yɛɣɛ ḿpʋ́ɣʋ́ nɑ mʋsʋŋ. ");
INSERT INTO dop_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Hepǝlɑ nyǝ́mɑ kɑ wɛnɑ ɑlɑɑ lʋlǝsǝlɑɑ kɛ nɑɑlɛɣɛ. Pɑ yɑɑ lɛlʋ sɩ Sifǝlɑ nɑ lɛlʋ sɩ Puwɑ. Mpʋɣʋlɛ Icipiti wulɑʋ yɑɑ-wɛ nɑ ɩ́ heeli-wɛ sɩ: ");
INSERT INTO dop_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Ɩ́ feŋiɣi Hepǝlɑ ɑlɑɑ tǝlʋllɛ nɑ ɩ́ kʋɣɩ ɑpɑlʋpiyɑ kɛ sɑɑʋ tɑɑ kɛ́ kpɑkpɑɑ. Amɑ ɩ́ yeki ɑlʋpiyɑ. ");
INSERT INTO dop_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Lʋlǝsǝlɑɑ mpɛ pɛlɛ pɑ nyɑŋɑɣɑnɑ Ɩsɔ. Ɩlɛnɑ pɑ́ kisi wulɑʋ tɔm ntɩ. Ɩlɛ pɑ tɑ kʋ ɑpɑlʋpiyɑ. ");
INSERT INTO dop_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Tǝnɑɣɑlɛ wulɑʋ yɑɑ-wɛ nɑ ɩ́ pɔɔsɩ-wɛ sɩ: Pepe tɔɔ kɛ́ ɩɩ kʋɣɩ ɑpɑlʋpiyɑ mpɛ? ");
INSERT INTO dop_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ntɛnɑ lʋlǝsǝlɑɑ mpɛ sɩ: Hepǝlɑ ɑlɑɑ fɑɣɑnɑ Icipiti nyǝ́mɑ kɛ yoo. Pɑ ɑpɑlʋtʋ wɛ sɔɣɔntʋ. Pɑ lʋlǝɣɩ pɑ piyɑ kɛ́ nɑ pǝ́cɔ́ tɑ́ɑ́ tɑkɩ. ");
INSERT INTO dop_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Ḿpʋ́ɣʋ́ Ɩsɔ koolɑ lʋlǝsǝlɑɑ mpɛɣɛ kʋpɑntʋ, nɑ ɩ́ lɑ́ nɑ pɑ piitim tɑɣɑlɩ. Mpi tɔ, pɑ nyɑŋɑɣɑnɑ-ɩ tɔ pǝ tɔɔ. Ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ́ɑ́ hukiɣi nɑ pɑ́ nyɔɔkɩ toŋ. ");
INSERT INTO dop_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ḿpʋ́ɣʋ́ Icipiti wulɑʋ tʋwɑ Icipiti nyǝ́mɑ tǝnɑ sɩ: Ye Hepǝlɑ ɑlʋ lʋlɑ ɑpɑlʋpǝyɑɣɑ ɩ́ tǝŋsɩ-kɛɣɛ Nili pɔɣɔ lʋm. Amɑ ɩ́ yeki ɑlʋpiyɑ. ");
INSERT INTO dop_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ḿpʋ́ɣʋ́ Lefii tʋ nɔɣɔlʋ ɩ kpɑɣɑ Lefii ɑlʋ nɔɣɔlʋ. ");
INSERT INTO dop_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ɩlɛnɑ ɑlʋ ɩnɩ ɩ́ lɑ́ teu nɑ ɩ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ. Kɑ lɑpɑ-ɩ teu kɛ sɔsɔm. Ɩlɛnɑ ɩ́ mɑɣɑsɩ-kɛɣɛ ŋmɛsʋɣʋ kɛ ɩsɔtʋnɑɑ tooso. ");
INSERT INTO dop_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ɩ nɑwɑ sɩ ɩ kɑɑ pǝsɩ nɑ ɩ́ ŋmɛsɩ-kɛ, ɩlɛnɑ ɩ́ cɑɑ kowusɑɣɑ nɑ ɩ́ tɑɑ-kɛɣɛ kɑɑloo, nɑ tʋɣʋ nɑkʋlɩ kʋ cǝlǝm sɩ lʋm ɩ́ tɑɑ sʋʋ. Ḿpʋ́ɣʋ́ ɩ hɩɩsɑ pǝyɑɣɑ kɛ pǝ tɑɑ nɑ ɩ́ ponɑ kowusɑɣɑ ŋkɛ nɑ ɩ́ sɩɩ pɔɣɔ tɑɑ, kɛ́ kuteŋ luɣu tɛɛ, kɛ́ sǝsǝncɑɑsɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nɑ pǝyɑɣɑ ŋkɛ kɑ kɔɣɔ sǝŋɑ tɑ́ɑ́lǝ́ḿ tɔɔ sɩ ɩ nɑɑkɩ mpi ɩ neu kɑ́ tɛnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Pǝ pɑmnɑ Icipiti wulɑʋ pɛɛlɔ tii lʋm sɔʋ, nɑ ɩ tɑɑpɑlɑɑ sɩɩ-ɩ nɑ pɛlɛ pɑ́ mɑ́lǝ́ɣɩ́ kuteŋ. Ɩlɛ Icipiti wulɑʋ pɛɛlɔ loosɑ kowusɑɣɑ ntɛ́ sǝsǝncɑɑsɩ tɛɛ kɛ́ lʋm tɑɑ. Ɩlɛnɑ ɩ́ tili ɩ yomɑɑ tɑɑ lɛlʋ sɩ ɩ́ polo ɩ́ kpɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ɩ kulɑɑ ɩlɛ ɩ mɑɣɑnɑ ɑpɑlʋpǝyɑɣɑ ntɛ́ nɑ kɑ́ wiiki. Kɑ tɔm lɑpɑ-ɩ pǝtɔɔtǝlɛ ɩlɛnɑ ɩ́ pǝsǝnɑ sɩ: Cǝnɛ ɩnɩ, Hepǝlɑ nyǝ́mɑ pǝyɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kɑ kɔɣɔ kɑ sǝŋɑ tǝnɑ, tǝnɑɣɑ ɩ nɔɣɔ tǝkpɑʋ sɩ: N cɑɑ sɩ mɑ́ polo mɑ́ pɛɛkɩ-ŋ Hepǝlɑ ɑlʋ wei ɩ kɑ́ mʋsǝsɩ-kɛ́ tɔ? ");
INSERT INTO dop_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ntɛnɑ pɛɛlɔ ɩnɩ ɩ́ cɔ sɩ: Polo. Kɔɣɔ tɛɛwɑ ɩlɛnɑ ɩ́ kɔnɑ ɑhʋlʋm ɩnɩ ɩ too kʋlʋlʋ. ");
INSERT INTO dop_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ḿpʋ́ɣʋ́ Icipiti wulɑʋ pɛɛlɔ tɔmɑ ɑlʋ ɩnɩ sɩ: Kpɑɣɑ pǝyɑɣɑ kɑnɛ nɑ ń mʋsǝsɩ-m- kɛ, mɑɑ fɛlɩ-ŋ. Ɩlɛnɑ toto kpɑɣɑ-kɛ nɑ ɩ́ tɔɔ-kɛ. ");
INSERT INTO dop_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Pǝyɑɣɑ kɔmɑ nɑ kɑ́ cɛ́ hǝtɛ ɩlɛnɑ kɑ too ponɑ-kɛ nɑ ɩ́ cɛlɛ-kɛɣɛ Icipiti wulɑʋ pɛɛlɔ nɑ kɑ́ cɑɣɑ ɩ kiŋ ɩsɩɩ kɑ too kʋlʋlʋ. Ntɛnɑ ɩ́lɛ́ ɩ́ hɑ-kɛɣɛ hǝtɛ sɩ, Moisi. Lʋm ɑpɑlʋ kɛ pɑ yɑɑ mpʋ nɑ pɑ tɛ́ tɑɑ. Mpi tɔ, lʋm tɑɑ kɛ́ ɩ lǝsɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moisi lɑpɑ sɔsɔ ɩlɛnɑ kʋyɑkʋ nɑkʋlɩ ɩ́ polo sɩ ɩ nɑɑkɩ ɩ nyǝ́mɑ Hepǝlɑ nyǝ́mɑ. Nɑ ɩ nɑwɑ tɔtɔɣɔ wɑhɑlɑ tǝmɑ wenɑ Icipiti nyǝ́mɑ tʋkɑɣɑ-wɛ tɔ. Hɑlǝnɑ ɩ́ nɑ́ tɔtɔɣɔ Icipiti tʋ nɔɣɔlʋ ɩ kʋɣɩ Hepǝlɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ɩ cɑɑ ɩsɛ kɛ ɩ tɑɑ nɑ ɩ wɑɑlɩ ɩ tɑ nɑ nɔɣɔlʋ, ɩlɛnɑ ɩ́ kʋ́ Icipiti tʋ nɑ ɩ́ ŋmɛsɩ-ɩ kɑnyǝŋɑ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Tɛʋ femɑ nɑ ɩ́ mǝlɩ, ɩlɛnɑ ɩ́ mɑɣɑnɑ Hepǝlɑ nyǝ́mɑ nɑ pɑ́ mɑkɩ tǝmɑɣɑ pɑ tɑɑ pɑ tike. Ɩ lolɑ-wɛ ɩlɛnɑ ɩ́ pɔɔsɩ mʋsʋŋtʋ sɩ: Pepe tɔɔ kɛ́ n lɑkɩ nyɑ́ tɛɛtʋ kɛ nyǝmǝŋ kɛ mpʋ? ");
INSERT INTO dop_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mpʋɣʋlɛ ɩ́lɛ́ ɩ pǝsǝnɑ-ɩ sɩ: Awe kpɑ-ŋ tɑ́ wulɑʋ yɑɑ tɑ́ tɔm hʋʋlʋ ye? N cɑɑ sɩ n kʋ-m ɩsɩɩ n kʋɣʋ Icipiti tʋ tɔ yɛɛ? Moisi cɛkǝnɑɑ sɩ yǝlɑɑ nyǝmɑ́-tɩ ɩlɛnɑ sɔɣɔntʋ kpɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Icipiti wulɑʋ mɑɣɑmɑɣɑ nɑ́ nɩɩ mpʋ nɑ ɩ́lɛ́ ɩ tɔŋnɑ pɛɛkʋɣʋ sɩ ɩ lǝsǝɣɩ ɩ luɣu tɛɛ. Ntɛnɑ Moisi sʋʋ nyɩɩtʋ nɑ ɩ́ polo Mɑtiyɑŋ tɛtʋ tɑɑ kɛ́ cɔɔsʋɣʋ. Ɩ tɑlɑ tǝnɑ ɩlɛnɑ ɩ́ cɑɣɑ lɔkɔ nɔɣɔlʋ ɩ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Kɔtʋlʋ nɔɣɔlʋ ɩ kɑ wɛ tǝnɑ nɑ pɑ́ yɑɑkɩ-ɩ sɩ, Yetulo. Ɩ wɛnɑ pɛɛlɑɑ nɑɑtosompɔɣɔlɑɣɑ. Ḿpʋ́ɣʋ́ pɛɛlɑɑ mpɛ pɑ polɑ lʋm luɣu sɩ pɑ suuliɣi pǝlonɑ nɑ pɑ cɑɑ tɔlɑ nyɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Pǝ tɑsɑɑ ɩlɛ, tiikilɑɑ nɑpǝlɩ pɑ kɔmɑɣɑlɛ nɑ pɑ́ tɔɣɔnɩ-wɛ. Moisi nɑ́ mpʋ ɩlɛnɑ ɩ́ sɛɛnɑ pɛɛlɑɑ mpɛ pɑ tɔɔ, nɑ pɑ kɑlǝkʋ nyɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Pɑ mǝlɑ tǝyɑɣɑ ɩlɛnɑ pɑ cɑɑ pɔɔsɩ-wɛ sɩ: Ɩsǝnɑɣɑ pǝ lɑpɑ nɑ sɑŋɑ ɩ́ kɔɔ lɔŋ kɛ mpʋ? ");
INSERT INTO dop_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ntɛnɑ pɑ́ cɔ-ɩ sɩ: Icipiti tʋ nɔɣɔlʋ ɩ wɑɑsǝnɑ-tʋ. Hɑlǝnɑ ɩ́ lu tɑ́ kɑlǝkʋ kɛ lʋm nɑ kʋ́ nyɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kɛlɛnɑ pɑ cɑɑ nɔɣɔ tǝkpɑʋ sɩ: Nɑ ɑpɑlʋ ɩnɩ ɩ wɛ le? Ɩ́ tɑ́ sʋʋnɑ-ɩ tǝyɑɣɑ suwe? Tɔʋ, ɩ́ polo nɑ ɩ́ yɑɑ-ɩ nɑ ɩ́ kɔɔ nɑ tɑ́ nɑ-ɩ tǝ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ḿpʋ́ɣʋ́ Moisi tisɑɑ nɑ ɩ́ cɑɣɑ ɑpɑlʋ ɩnɩ ɩ tɛ. Hɑlǝnɑ ɩ́lɛ́ ɩ hɑ-ɩ ɩ pɛɛlɔ Sefolɑ nɑ ɩ́ lɑ́ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Alʋ ɩnɩ ɩ lɑpɑ teu, ɩlɛnɑ ɩ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ nɑ kɑ cɑɑ hɑ-kɛɣɛ hǝtɛ sɩ Kɛɛsɔm. Mɑcɔɔsɑɑ kɛ́ pɛlɛ pɑ yɑɑ mpʋ nɑ pɑ tɛ́ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ḿpʋ́ɣʋ́ pǝ tɑɑŋɑ sɔsɔm, ɩlɛnɑ Icipiti wulɑʋ sɩ́. Yomle nɩɩwɑ Ɩsɛɣɛlɩ nyǝ́mɑ ɩlɛnɑ pɑ́ wiiki nɑ pɑ́ tekiɣi Ɩsɔ sɩ ɩ́ wɑɑsɩ-wɛ nɑ ɩ́lɛ́ ɩ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nɑ ɩ́ tɔɔsɩ nɔɣɔ ŋkɑ ɩ kɑ sɩɩ pɑ cɑɑnɑɑ cɑɑnɑɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ tɔ kɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nɑ ɩ́ nyǝnɩ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ ɩ́ pɑɑsǝnɑ pɑ tɔm. ");
INSERT INTO dop_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Wɑɑtʋ ɩnɩ tɔ nɑ Moisi nɑ́ɑ́ tɔŋnɑ ɩ yǝtɩ Mɑtiyɑŋ kɔtʋlʋ Yetulo tɔlɑ tiikuɣu. Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ ɩ tiikɑɑ nɑ ɩ́ tɑlɑ Ɩsɔ pʋɣʋ ŋku pɑ yɑɑ sɩ Holɛpʋ tɔɣɔ wʋlɑɣɑ tɛtʋ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Tǝnɑɣɑ Tɑcɑɑ tillu lɩɩ ɩ tɔɔ kɛ́ tiikɑ kʋlɔpɑɣɑ ŋkɑ kɑ mʋɣɩ kɔkɔ tɔ kɑ tɑɑ. Ɩ pɑɑsǝnɑ teu, ɩlɛnɑ ɩ́ nɑ́ sɩ kɔkɔ mʋɣɩ yɑ́ɑ́. Amɑ tiikɑ mɑɣɑmɑɣɑ ɩɩ nyɑkɩ. ");
INSERT INTO dop_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ntɛnɑ ɩ́ tʋ́ ɩ tɑɑ sɩ ɩ kɑ́ kpǝtǝnɑ teu nɑ ɩ́ nɑ́ piti tɔm ntɩ sɩ ɩsǝnɑɣɑ pǝ lɑpɑ nɑ kɔkɔ mʋɣɩ tiikɑ nɑ kɑɑ nyɑkɩ. ");
INSERT INTO dop_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ɩsɔ nɑwɑ sɩ ɩ cɑɑ kpǝtǝnɑʋ, ɩlɛnɑ ɩ́ yɑɑ kɔkɔ ŋkɛ kɑ tɑɑ sɩ: Moisi Moisi. Nɑ Moisi cɔ sɩ: Mɑ nɩɩwɑ. ");
INSERT INTO dop_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mpʋɣʋlɛ Ɩsɔ tɔmɑ-ɩ sɩ: Tɑɑ kpǝtǝnɑ tiikɑ ŋkɛ yoo. Wɔɣɔsɩ nyɑ́ ntɑnkpɑlɑ. Mpi tɔ, Ɩsɔ tɛtʋ tɔɔ kɛ́ n sǝŋɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Mɑɣɑlɛ nyɑ́ cɑɑnɑɑ cɑɑnɑɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ pɑ Ɩsɔ. Sɔɣɔntʋ kpɑ Moisi, ɩlɛnɑ ɩ́ tɑkɩ ɩ ɩsɛntɔɔ sɩ ɩ́ tɑɑ nɑ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ntɛnɑ Ɩsɔ tɔ sɩ: Mɑ nɑwɑ ɩsǝnɑ mɑ yǝlɑɑ tɔkɩ kʋnyɔŋ kɛ Icipiti tɔ. Pǝyǝle mɑ nɩɩwɑ wulɑ nnɑ pɑ ŋmɑkǝllɑɑ tʋɣʋ-wɛ tɔ. Mɑ nyǝmɑ́ pɑ wɑhɑlɑnɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Pǝ tɔɔ kɛ́ mɑ tiiwɑ sɩ mɑ cɛkɩ-wɛɣɛ Icipiti nyǝ́mɑ niŋ tɑɑ, nɑ mɑ́ ponɑ-wɛɣɛ tɛtʋ kʋpɑntʋ nti tǝ wɑlɑɑ nɑ tɔɣɔnɑɣɑ nɑ kʋpɑntʋ tǝnɑ tɔlɑ yem tǝhɔ tɔ tǝ tɑɑ. Kɑnɑɑŋ nyǝ́mɑ, nɑ Hiti nyǝ́mɑ, nɑ Amolii nyǝ́mɑ, nɑ Filiisi nyǝ́mɑ, nɑ Hifi nyǝ́mɑ, nɑ Yepusi nyǝ́mɑ, pɑ cɑɣɑnɑ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Mɑ nɩɩwɑ Ɩsɛɣɛlɩ nyǝmɑ wulɑ, pǝyele mɑ nɑwɑ yɑɑsi wei Icipiti nyǝ́mɑ ŋmɑkǝlǝɣǝnɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Mpʋ tɔ, mɑ tiliɣi-ŋ Icipiti wulɑʋ tɛ́ sɩ ń polo nɑ ń lǝsɩ mɑ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Icipiti tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mpʋɣʋlɛ Moisi cɔwɑ Ɩsɔ sɩ: Mɑɣɑlɛ ɑwe nɑ hɑlɩ mɑ́ɑ́ puki Icipiti wulɑʋ kiŋ sɩ mɑ lǝsǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Icipiti tɑɑ? ");
INSERT INTO dop_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kɛlɛnɑ Ɩsɔ sɩ: Mɑɑ wɛɛ nyɑ́ wɑɑlɩ. Nɑ mpi n kɑ́ nyǝnɑ sɩ mɑ́ tiliɣinɑ-ŋ tɔɣɔlɛ sɩ, n kɑ́ lǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Icipiti nɑ nyɑnɑ-wɛ ɩ́ kɔɔ nɑ ɩ́ sɛɛ-m pʋɣʋ kʋnɛ kʋ tɔɔ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ntɛnɑ Moisi sɩ: Pǝ wɛ teu, ye mɑ polɑɑ nɑ mɑ́ mɑɣɑnɑ-wɛ, nɑ mɑ́ heeli-wɛ sɩ pɑ cɑɑnɑɑ Ɩsɔ tilinɑ-m pɑ wɑɑlɩ. Ɩlɛ pɑɑ pɔɔsɩ-m nyɑ́ hǝtɛ, ɩlɛnɑ mɑ́ cɔ-wɛ suwe? ");
INSERT INTO dop_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mpʋɣʋlɛ Ɩsɔ cɔ-ɩ sɩ: Mɑ hǝtɛ ntɛ́ Mɑwɛtɑm. Mpʋ tɔ, ń polɑɑ ɩlɛ n heeli-wɛ sɩ: Tɑmwɛɛlʋ tilinɑ-m mǝ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Nɑ ń cuɣusi sɩ: Mǝ cɑɑnɑɑ cɑɑnɑɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ pɑ Ɩsɔ Tɑcɑɑ tilinɑ-m mǝ wɑɑlɩ. Mɑ hǝtɛ ntɛ́, hɑlǝnɑ ɑntulinyɑ polo nɑ ɩ́ kʋlɩ. Hǝtɛ ntɛɣɛ yǝlɑɑ kɑ́ yɑɑkɩ-m pɑɑ wɑɑtʋ wei. ");
INSERT INTO dop_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Tɔʋ, polo pǝnɛntɑɑ nɑ ń koti Ɩsɛɣɛlɩ sɔsɑɑ nɑ ń heeli-wɛ sɩ: Mǝ cɑɑnɑɑ cɑɑnɑɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ pɑ Ɩsɔ Tɑcɑɑ lɩɩ mɑ tɔɔ nɑ ɩ́ heeli-m sɩ ɩ nɑ-mɛ nɑ ɩ nyǝ́mɑ ɩsǝnɑ pɑ ŋmɑkǝlǝɣɩ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Nɑ ɩ tʋ́ ɩ tɑɑ sɩ ɩ lǝsǝɣɩ-mɛɣɛ wɑhɑlɑ tɛtʋ tɑɑ cǝnɛ nɑ ɩ́ ponɑ-mɛɣɛ Kɑnɑɑŋ nyǝ́mɑ, nɑ Hiti nyǝ́mɑ, nɑ Amolii nyǝ́mɑ, nɑ Filiisi nyǝ́mɑ, nɑ Hifi nyǝ́mɑ, nɑ Yepusi nyǝ́mɑ pɑ tɛtʋ tɑɑ, timpi tɔɣɔnɑɣɑ nɑ kʋpɑntʋ tǝnɑ tɔlɑ yem tǝhɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ye pɑ nɩɩ mpʋ pɑɑ mʋ-tǝɣɩ. Ɩlɛnɑ ń kpɑɣɑ-wɛ nɑ ɩ́ polo ɩ́ mɑɣɑnɑ Icipiti wulɑʋ nɑ ɩ́ heeli-ɩ sɩ Hepǝlɑ nyǝ́mɑ tɑ́, tɑ́ Ɩsɔ Tɑcɑɑ lɩɩ tɑ́ tɔɔ. Mpʋ tɔ, hɑ-tʋɣʋ mpɑɑʋ nɑ tǝ́ polo wʋlɑɣɑ tɛtʋ tɑɑ nɑ tǝ́ lɑpɩ-ɩ kɔtɑsɩ. Pɩɩ mɑɣɑnɑ ɩsɩɩ kʋyɛɛŋ tooso tɔntɛ. ");
INSERT INTO dop_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Mɑ nyǝmɑ́ sɩ ye pǝ tɑ hɑŋ wulɑʋ ɩ kɑɑ yele-mɛ nɑ ɩ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Pǝ tɔɔ kɛ́ mɑɑ hɔ Icipiti nyǝ́mɑ ŋkpɑŋŋ nɑ yɑɑsinɑɑ mpɑ too pɑ tɑ nɑtɑ tɔ nɑ hɑlɩ wulɑʋ tɔɣɔnɩ-mɛɣɛ kʋtɔɣɔnʋ nɑ ɩ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Hɑlɩ mɑ́ yele nɑ Icipiti nyǝ́mɑ lɑ-mɛɣɛ kʋpɑntʋ nɑ ɩ́ tɑɑ lɩɩ niŋ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Pɑɑ Ɩsɛɣɛlɩ ɑlʋ wei ɩ kɑ́ sǝlǝmɩ Icipiti ɑlɑɑ mpɑ pɑ kɛ́ ɩ ɑsǝmɑɑ nɑ ɩ cɔlɔ nyǝ́mɑ tɔɣɔ nyǝɣǝtʋ kʋpɑntʋ wontu, nɑ wʋlɑ nyǝntʋ, nɑ wontu kʋsusuutu, nɑ ɩ́ tʋ́ mǝ piyɑ tɔɔ. Ḿpʋ́ɣʋ́ ɩ́ kɑ́ sʋsǝnɑ Icipiti nyǝ́mɑ kɛ kʋnyɔŋ. ");
INSERT INTO dop_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ḿpʋ́ɣʋ́ Moisi pɔɔsɑ Ɩsɔ Tɑcɑɑ sɩ: Nɑ ye ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɑ tʋnɑ mɑ tɔm nɑ pɑ́ kisi-m nɩɩnɑʋ nɑ pɑ́ tɔ-m sɩ Tɑcɑɑ tɑ lɩɩ mɑ tɔɔ kɛ́ tiili se? ");
INSERT INTO dop_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ntɛnɑ Tɑcɑɑ tɔmɩ-ɩ sɩ: Pepeɣe n tɔkɑ nyɑ́ niŋ tɑɑ? Mpʋɣʋlɛ sɩ: Kpɑ́tʋ́ɣʋ́. ");
INSERT INTO dop_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kɛlɛnɑ Ɩsɔ sɩ: Pɛtɩ-kʋɣʋ ɑtɛ. Moisi pɛtɑ-kʋ, ɩlɛnɑ kʋ́ pǝsɩ tʋm. Tǝnɑɣɑ ɩ ŋmɑɑwɑ tǝyɑɣɑʋ. ");
INSERT INTO dop_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ-ɩ sɩ: Siisi nɑ ń kpɑ ɩ sukɑ tɑɑ. Moisi siisɑɑ nɑ ɩ kpɑ tʋm ɩnɩ tǝcɑʋ, ɩlɛnɑ tʋm tɑɣɑnɩ kpɑ́tʋ́ɣʋ́ kɛ pǝsʋɣʋ kɛ ɩ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ɩlɛnɑ Ɩsɔ sɩ: Mpi n kɑ́ hʋlǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ pɑ cɑɑnɑɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ pɑ Ɩsɔ Tɑcɑɑ mɑ́ mɑ lɩɩ nyɑ́ tɔɔ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ḿpʋ́ɣʋ́ Ɩsɔ tɑsɑ Moisi kɛ heeluɣu sɩ: Nyǝkɩ nyɑ́ niŋ kɛ nyɑ́ lɑŋlɛ tɑɑ kɛ́ nyɑ́ toko tɛɛ. Moisi nyǝkɑ ɩ niŋ kɛ mpʋ nɑ ɩ́ kʋsɩ-ɩ, ɩlɛ ɩ tutɑ tɔnʋɣʋ tɔɔ ɑsilimɑ kʋtɔŋ wɑɑsɑ ɩ niŋ tǝnɑɣɑlɛ nɑ ɩ́ sɛɛwɑ tǝhɑii. ");
INSERT INTO dop_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kɛlɛnɑ Ɩsɔ sɩ: Mǝlǝnɑ nyɑ́ niŋ kɛ nyɑ́ lɑŋlɛ tɑɑ. Moisi kɔmɑ nɑ ɩ́ kʋsɩ ɩ niŋ ɩlɛ ɩ mǝlɑɑ kɛlɛ tǝmɑmmɑm ɩsɩɩ ɩ kɑ wɛʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mpʋɣʋlɛ Tɑcɑɑ tɔmɑ sɩ: Ye Ɩsɛɣɛlɩ nyǝ́mɑ tɑ tʋnɑ-ŋ, nɑ ń kisi nɑ ń lɑ piti tǝmlɛ kɑncɑɑlɑɣɑ nyǝntɛ nɑ pɑ́ tɑ́ mʋ nyɑ́ tɔm. Ń lɑpɑ nɑɑlɛ nyǝntɛ tǝnɛ ɩsɩɩ pɑ mʋ-tɩ. ");
INSERT INTO dop_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ye pǝ kpɛŋnɑ piti tǝmɑ ɑnɛ ɑ nɑɑlɛ nɑ pɑ́ kɑ́ nyʋɣʋ nɑ pɑ́ kisiɣi nyɑ́ tɔm nɑ pɑɑ nɩɩkǝnɑ-ŋ, ɩlɛ ń cosi Nili pɔɣɔ lʋm nɑ ń pǝlɩ-wǝɣɩ tɛtʋ tɔɔ nɑ pǝ́ pǝsɩ cɑlǝm. ");
INSERT INTO dop_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ḿpʋ́ɣʋ́ Moisi sɩ: Pǝ kɑɑ lɑ, mɑ tɑ nyɩ yɔɣɔtɑɣɑ. Pɑɑ hɑtoo n cɑɑlɑ-m yɔɣɔtǝnɑʋ tɔ mɑ tɑɑ nyɩ yɔɣɔtʋɣʋ. Pɑɑ nɑ nɔɔnɔɔ ɩsǝntɔ kʋlʋmtʋ ntǝɣɩ, pǝ tɑ lɑɣɑsɩ. ");
INSERT INTO dop_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Kɛlɛnɑ Ɩsɔ nɔɣɔ tǝkpɑʋ sɩ: Pǝ tɑɣɑ mɑ tʋnɑ yʋlʋ kɛ nɔɣɔ tɑɑ? Nɑ ye mɑ nɔkɑɑ mɑ lɑpɩ-ɩ kɑmumukɑ yɑɑ ntɑm. Pǝyele mɑ́ nɔkɑɑ mɑ yele nɑ ɩ́ nɑɑkɩ yɑɑ ɩ́ yʋlʋmɩ. ");
INSERT INTO dop_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Mpʋ tɔ, tɛɛ nɔɔnɔɔ. Mɑɑ wɛɛ nyɑ́ wɑɑlɩ nɑ mɑɑ tʋ́ nyɑ́ nɔɣɔ tɑɑ kɛ́ tɔm pee wenɑ n kɑ́ yɔɣɔtɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mpʋɣʋlɛ Moisi sɩ: Hɑɩ, Tɑcɑɑ, mɑ kpɑ nyɑ́ yule, tili wei n cɑɑ tɔ, yele mɑ tɔm. ");
INSERT INTO dop_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tǝnɑɣɑlɛ Moisi tɔm lɑpɑ Tɑcɑɑ kɛ pɑ́ɑ́nɑ́ nɑ ɩ́ tɔmɩ-ɩ sɩ: Nyɑ́ tɑɑlʋ Lefii tʋ Alɔŋ wɛɛ. Hɑlɩ ɩ́lɛ́ ɩ tɩɩ lɩɩnɑ ntɛɣɛ nyɑ́ sǝŋʋɣʋ, nɑ ɩ́ loosɑ-ŋ ɩ lɑŋhʋlʋmlɛ kɑ́ wɛɛ sɔɣɔntʋ. ");
INSERT INTO dop_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","N kɑ́ tɛlǝsɩ-ɩ nti nti ɩ kɑ́ yɔɣɔtǝɣɩ tɔ. Nɑ mɑ́ɑ́ wɛɛ mǝ wɑɑlɩ nɑ mɑ́ hʋ́lɩ́-mɛɣɛ mǝ kʋlɑpǝlɛ. ");
INSERT INTO dop_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Nyɑ́ pǝsɑ ɩsɩɩ Ɩsɔ kɛlɛ, nɑ ń tɛlǝsǝɣɩ-ɩ nti ɩ kɑ́ heeliɣi sɑmɑɑ nɑ nyɑ́ nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tɔkɩ nyɑ́ kpɑ́tʋ́ɣʋ́ kɛ nyɑ́ niŋ tɑɑ nɑ ń lɑkǝnɑ-kʋɣʋ piti tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ḿpʋ́ɣʋ́ Moisi mǝlɑ ɩ yǝtɩ Yetulo cɔlɔ nɑ ɩ́ heeli-ɩ sɩ: Mɑ mǝlǝɣɩ Icipiti nɑ mɑ́ nɑ́ Ɩsɛɣɛlɩ nyǝ́mɑ ɑlɑɑfǝyɑ. Ntɛnɑ ɩ́lɛ́ sɩ pǝ wɛ teu, polo. ");
INSERT INTO dop_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi kɛ Mɑtiyɑŋ tɛtʋ tɑɑ tǝnɑ sɩ: Tɑɑ nyɑnɑ Icipiti mǝlʋɣʋ. Mpi tɔ, mpɑ pɑ lʋkɑɣɑ-ŋ kʋɣʋ tɔ pɑ sǝpɑ pɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ɩlɛnɑ Moisi cɑɣɑsɩ ɩ ɑlʋ nɑ ɩ piyɑ kɛ kpɑŋɑsɩ nɑ pɑ́ tɛɛ Icipiti, nɑ ɩ́ tɔkɑ kpɑ́tʋ́ɣʋ́ ŋku Ɩsɔ kɑ heelɑ-ɩ sɩ ɩ́ kpɑɣɑ tɔɣɔ ɩ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ɩlɛnɑ Tɑcɑɑ tɑsɑ-ɩ heeluɣu sɩ: Mɑ hɑ-ŋ toŋ sɩ ye n tɑlɑ Icipiti, n lɑ piti tǝmɑ ɑnɩ ɑ tǝnɑ nɑ Icipiti wulɑʋ nɑ́. Amɑ mɑɑ tʋ-ɩ lɑŋkpɩɩsǝŋ nɑ ɩ kɑɑ yele Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Nɑ ń heeli-ɩ sɩ mɑɣɑ Ɩsɔ Tɑcɑɑ kɛ́. Ɩsɛɣɛlɩ nyǝ́mɑ wɛ kɛ́ ɩsɩɩ mɑ ɑpɑlʋ pǝyɑɣɑ kɑncɑɑlɑɣɑ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Timpi mɑ tɔmɑ sɩ ɩ́ yele mɑ kɑncɑɑlɑɣɑ pǝyɑɣɑ nɑ kɑ́ polo kɑ́ sɛɛ-m nɑ ɩ́ kisi tɔ, pǝ tɔɔ kɛ́ mɑɑ kʋ́ ɩnɩ ɩ ɑpɑlʋ pǝyɑɣɑ kɑncɑɑlɑɣɑ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ḿpʋ́ɣʋ́ Moisi pɑ sʋʋ tiiliɣi ɑhoo nɑɑlɩ. Ɩlɛnɑ Ɩsɔ kpipi-ɩ sɩ ɩ kʋɣɩ. ");
INSERT INTO dop_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Tǝnɑɣɑlɛ ɩ ɑlʋ Sefolɑ kpɑɣɑ kpɑntɑnyɑɑlʋɣʋ nɑ ɩ́ pɛlɩ pǝyɑɣɑ hǝnnɔɣɔ nɑ ɩ́ tokinɑ-kɛɣɛ Moisi tɛɛ nɑ ɩ́ tɔ sɩ: N kɛ-m cɑlǝm ɑpɑlʋ kɛ́. Pɛlʋɣʋ tɔm kɛ Sefolɑ yɔɣɔtǝnɑ mpʋ. Ɩlɛnɑ Ɩsɔ yele Moisi. ");
INSERT INTO dop_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ḿpʋ́ɣʋ́ Ɩsɔ heelɑ Alɔŋ sɩ ɩ́ sǝŋ Moisi kɛ wʋlɑɣɑ tɛtʋ tɑɑ. Alɔŋ tɛɛwɑ ɩlɛnɑ ɩ́ suli ɩ neu Moisi kɛ Ɩsɔ pʋɣʋ kiŋ, nɑ pɑ́ kpi tǝmɑ nɑ pɑ́ sɛɛ tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Nɑ Moisi nɑ́ɑ́ kɛɛsɩ-ɩ tɔm nti Ɩsɔ heelɑ-ɩ nɑ piti tǝmɑ nnɑ ɩ kɑ hʋlɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ntɛnɑ pɑ nɑɑlɛ pɑ́ tǝŋ tǝmɑ nɑ pɑ́ polo Icipiti nɑ pɑ́ koti Ɩsɛɣɛlɩ sɔsɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ḿpʋ́ɣʋ́ Alɔŋ kɛɛsɑ-wɛɣɛ nti nti Ɩsɔ kɑ heelɑ Moisi tɔ, nɑ pɑ́ lɑ́ piti tǝmɑ ɑnɩ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ́. ");
INSERT INTO dop_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Pɛlɛ pɑ nɑ́ mpʋ, ɩlɛnɑ pɑ́ tisi sɩ Ɩsɔ lɑkǝnɑ. Pɑ cɛkǝnɑɑ sɩ Ɩsɔ nɑwɑ pɑ kʋnyɔntɔɣɔlɛ kɛ́ nɑ ɩ́ kɔɔ sɩ ɩ́ wɑɑsɩ-wɛ. Ɩlɛnɑ pɑ́ hǝntɩ-ɩ ɑtɛ nɑ pɑ́ sɛɛ-ɩ. ");
INSERT INTO dop_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Pǝlɛ pǝ wɑɑlɩ kɛ́ Moisi nɑ Alɔŋ pɑ polɑ Icipiti wulɑʋ tɛ́ nɑ pɑ́ heeli-ɩ sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ tɑ, tɑ́ Ɩsɔ Tɑcɑɑ sɩ tǝ́ heeli-ŋ sɩ ń yele-tʋ nɑ tǝ́ polo pooluŋ nɑ tǝ́ lɑpɩ-ɩ tǝmlɛ pǝyɑɣɑ nɑkǝlɩ. ");
INSERT INTO dop_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Tǝnɑɣɑlɛ Icipiti wulɑʋ nɔɣɔ tǝkpɑʋ sɩ: Aweɣe Ɩsɔ Tɑcɑɑ ye? Mɑ tɑ nyɩ pʋntʋ. Ɩlɛ mɑ fɛɩ sɩ mɑ nɩɩkɩ ɩ tɔm nɑ mɑ́ yele Ɩsɛɣɛlɩ nyǝ́mɑ sɩ pɑ́ polo tiili. ");
INSERT INTO dop_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mpʋɣʋlɛ Moisi nɑ Alɔŋ pɑ cɔwɑ sɩ: Hepǝlɑ nyǝ́mɑ tɑ́, tɑ́ Ɩsɔ Tɑcɑɑ lɩɩnɑ tɑ́ tɔɔ nɑ ɩ́ heeli-tʋɣʋ mpʋ. Pǝ tɔɔ tɔ yele-tʋ nɑ tǝ́ tɔ́ kʋyɛɛŋ tooso nɑ tǝ́ polo pooluŋ nɑ tǝ́ lɑ́ kɔtɑsɩ. Ye pǝ tɑɣɑ mpʋ ɩ kɑ́ kʋ-tʋ nɑ kʋtɔŋ yɑɑ yoou. ");
INSERT INTO dop_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ḿpʋ́ɣʋ́ wulɑʋ holinɑ Moisi nɑ Alɔŋ sɩ: Mɛ, pepe tɔɔ kɛ́ ɩ́ tʋsǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ pɑ́ yele pɑ tǝmɑ ye? Mɩɩ mǝlɩ mǝ nyǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Nɔɔnɔɔ tɑɑ yǝlɑɑ pɑnɛ pɑ hukɑɑ kɛ́ ɩsɩɩ pɑ tǝmɑ kɑ polo ɩsɛntɑɑ, ɩlɛnɑ ɩ́ cɑɑkɩ sɩ ɩ́ mǝŋnɑ-yɛɣɛ wɑɑlɩ yɛɛ? ");
INSERT INTO dop_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Kʋyɑkʋ ŋkʋɣʋ Icipiti wulɑʋ heelɑ Icipiti nyǝ́mɑ mpɑ pɑ kɛ́ wɑhɑlɑ tǝmɑ feŋlɑɑ sɔsɑɑ tɔ, nɑ mpɑ pɑ kɛ́ feŋlɑɑ sǝkpemɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ tɔ ");
INSERT INTO dop_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","sɩ: Ɩ́ tɑɑ tɑsɑ-wɛɣɛ pilikinɑɑ kɑsɑɑlokɑ cɛlʋɣʋ kɛ fɑɑlɑɑ. Pɑ mɑɣɑmɑɣɑ pɑɑ pukinɑ nɑ pɑ́ kʋŋ. ");
INSERT INTO dop_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pǝ́cɔ́ pǝ fɛɩ sɩ pɑ pikilinɑɑ ɩ́ sɛkɩ ɩsɩɩ pɑ tɩɩ ŋmɑɑkɩ tɔ. Felentunɑɑ kɛ-wɛɣɛ. Pǝ tɔɔ kɛ́ pɑ kɔmɑ mɑ kiŋ sɩ mɑ́ hɑ-wɛɣɛ mpɑɑʋ nɑ pɑ́ polo pɑ́ lɑ́ pɑ Ɩsɔ kɛ́ kɔtɑsɩ. ");
INSERT INTO dop_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ɩ́ tʋ-wɛɣɛ tǝmɑ toŋ nyǝnɑ. Ɩlɛ pɑ kɑɑ hiki tɑpɑsopǝle sɩ pɑ́ pɑɑsǝɣǝnɑ pɑ pɔpɔtʋ tɔmnɑɑ mpɛ. ");
INSERT INTO dop_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ḿpʋ́ɣʋ́ feŋlɑɑ sɔsɑɑ nɑ sǝkpemɑ pɑ lɩɩ Icipiti wulɑʋ tɛ́ nɑ pɑ́ polo pɑ heeli Ɩsɛɣɛlɩ nyǝ́mɑ sɩ: Wulɑʋ sɩ, tǝ́ tɑɑ tɑsɑ-mɛɣɛ kɑsɑɑlokɑ cɛlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Sɩ mǝ mɑɣɑmɑɣɑ ɩ́ kɑ́ yɛlǝnɑ nɑ ɩ́ kʋ́. Pǝyele mǝ pilikinɑɑ kɑɑ sɛkɩ ɩsɩɩ ɩ́ tɩɩ ŋmɑɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Mpʋ pǝ yelinɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ yɑ Icipiti tɛtʋ tɑɑ sɩ pɑ́ kʋŋ kɑsɑɑlokɑ. ");
INSERT INTO dop_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Nɑ feŋlɑɑ sɔsɑɑ nɑ́ɑ́ cɑɑlǝɣɩ-wɛ nɑ toŋ sɩ pǝ wɛɛ sɩ pɑ́ tɛŋ pɑɑ ɩfemle nte tǝ pilikinɑɑ kɛ teitei, ɩsɩɩ too pɑɑ cɛlɑɣɑ-wɛɣɛ kɑsɑɑlokɑ kɛ kʋcɛlʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Hɑlǝnɑ feŋlɑɑ sɔsɑɑ mpɛ pɑ́ mɑkɩ sǝkpemɑ mpɑ pɑɑ kpɑwɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ tɔ. Sɩ pepe tɔɔ kɛ́ nɔɔnɔɔ sɑmɑɑ ɩɩ lɑkɩ pilikinɑɑ, nɑ pǝ́ tɑkɩ ɩsɩɩ too pɑɑ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ḿpʋ́ɣʋ́ feŋlɑɑ sǝkpemɑ mpɛ pɑ polɑ Icipiti wulɑʋ kiŋ sɩ pɑ hʋ́lǝ́ɣɩ́-ɩ pɑ wɑhɑlɑ nɑ pɑ́ wiinɑ-ɩ sɩ: Hɑɩ, tɑ́ cɑɑ, pepe tɔɔ kɛ́ n nɑɑsǝɣɩ-tʋɣʋ mpʋ? ");
INSERT INTO dop_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nyǝnɩ, ɑnɩ tɑ́ mɑɣɑmɑɣɑ tǝ kʋŋnɑ tɑ́ kɑsɑɑlokɑ. Pǝyele pɑ cɑɑlǝɣɩ-tʋ sɩ tɑ́ pilikinɑɑ ɩ́ tɑɑ sɛkɩ ɩsɩɩ tɩɩ ŋmɑɑkɑɣɑ tɔ. Pǝ́cɔ́ pɑ tɔŋnɑ-tʋɣʋ mɑpʋ ntɔ. Nyɑ́ yǝlɑɑ tɔm sǝpɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Tǝnɑɣɑlɛ Icipiti wulɑʋ nɔɣɔ tǝkpɑʋ sɩ: Ɩ́ kɛ́ felentunɑɑ kpitikpitinɑɑ kɛ́, pǝ mɑɣɑmɑɣɑ pǝ tɔɔ kɛ́ ɩ́ wɑɑkǝnɑ sɩ ɩ́ puki Ɩsɔ kɛ́ kɔtɑɣɑ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ɩ́ kʋlɩ nɑ ɩ́ tɛɛ mǝ tǝmɑ tɑɑ. Nɔɣɔlʋ kɑɑ cɛlɑ-mɛɣɛ kɑsɑɑlokɑ kɛ fɑɑlɑɑ. Pǝyele ɩ́ kɑ́ ŋmɑ́ pilikinɑɑ kɛ teitei kɛ́ ɩsɩɩ ɩ́ tɩɩ ŋmɑɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ḿpʋ́ɣʋ́ feŋlɑɑ mpɛ pɑ lɑŋɑ́ wɑkǝlɑɑ. Mpi tɔ, pɑ heelɑ-wɛ sɩ pɑɑ ŋmɑɑkɩ pilikinɑɑ kɛ pɑɑ ɩfemle nteɣe tǝcʋŋŋ ɩsɩɩ pɑɑ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Mpɛ pɑ lɩɩkɑɣɑ ɩlɛ pɑ mɑɣɑnɑ Moisi nɑ Alɔŋ pɑ tɑŋɑ-wɛɣɛlɛ. ");
INSERT INTO dop_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ɩlɛnɑ pɑ́ tʋʋ pɛlɛ sɩ: Ɩsɔ kɑ́ kpɑtɩ mǝ yule tɔɔ kɛ́ kpɑɑkpɑɑlɛ. Mpi tɔ, mǝ lɑpǝnɑ nɑ Icipiti wulɑʋ nɑ ɩ wɑɑlɩ nyǝ́mɑ pɑ luɣu lɩɩ-tʋ. Mǝ tekinɑ tɑ́ luɣu sɩ pɑ́ lɛntɩ. ");
INSERT INTO dop_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ḿpʋ́ɣʋ́ Moisi tɑsɑ Tɑcɑɑ kɛ sǝlǝmʋɣʋ tɔtɔ sɩ: Hɑɩ, Tɑcɑɑ, pepe tɔɔ kɛ́ n lɑkɩ nyɑ́ yǝlɑɑ tɑɣɑ ɩsɑɣɑtʋ? Nɑ pepe tɔɔ kɛ́ n tɩɩ tilɑ-m pɑ wɑɑlɩ? ");
INSERT INTO dop_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Hɑtoo kʋyɑŋku mɑ heelɑ Icipiti wulɑʋ kɛ nyɑ́ tɔm tɔ, ɩ sɔɔsɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ wɑhɑlɑ kɛ́. Pǝyele nyɑ́ sumɑ, nn lʋkɩ sɩ ń wɑɑsɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ cɔwɑ Moisi sɩ: N kɑ́ nɑ́ ɩsǝnɑ mɑɑ lɑ Icipiti wulɑʋ tɔ. Toŋ kɛ mɑɑ lɑnɑ-ɩ nɑ ɩ́ yele-mɛ nɑ ɩ́ tɛɛ. Hɑlɩ ɩ mɑɣɑmɑɣɑ ɩ kɑ́ tɩɩ tɔɣɔnnɑ-mɛɣɛ ɩ tɛtʋ tɑɑ sɩ ɩ́ tɛɛ lɔŋ nɑ ɩ́ wɛsɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ɩlɛnɑ Ɩsɔ tɑsɑ Moisi kɛ heeluɣu sɩ: Mɑ kɛ́ Tɑcɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Hɑlɩ mɑ hʋlɑ́ mɑ tǝɣɩ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ sɩ mɑɣɑlɛ Ɩsɔ Tomɑ tǝnɑ tʋ. Amɑ pɑ tɑ nyɩ sɩ mɑ hǝtɛ tɔtɔɣɔlɛ Mɑwɛtɑm. ");
INSERT INTO dop_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mɑ nɑ-wɛ tǝ pɛɛlɑ nɔɣɔ nɑ mɑ́ sɩɩ-wɛ sɩ mɑɑ hɑ-wɛɣɛ Kɑnɑɑŋ tɛtʋ nti tǝ tɑɑ pɑ cɑɣɑ cɑɣɑlʋtʋ kɛ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Pǝnɛntɛ mɑ nɩɩ yomle nte Icipiti nyǝ́mɑ tʋɣɩ-wɛ nɑ pɑ́ wiiki tɔ. Hɑlǝnɑ pǝ́ tɔɔsɩ-m nɔɣɔ ŋkɑ mɑ nɑ-wɛ tɩɩ pɛɛlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Pǝ tɔɔ kɛ́ mɑ tʋ Moisi sɩ ɩ́ heeli-mɛ sɩ mɑɣɑlɛ Tɑcɑɑ. Mɑɑ cɛ-mɛɣɛ mǝ yomle nɑ mǝ wɑhɑlɑ tǝmɑ tɑɑ nɑ mɑ́ wɑɑsɩ-mɛ. Nɑ mɑ hɔ́ Icipiti nyǝ́mɑ ŋkpɑŋʋɣʋ nɑ mɑ toŋ sɔsɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Mɑɑ nyǝnɩ-mɛɣɛ mɑ yǝlɑɑ nɑ mɩ́ɩ́ nyǝnɩ mɑɣɑ mǝ Ɩsɔ. Wɑɑtʋ ɩnǝɣɩ ɩ kɑ́ nyɩ sɩ mǝ Ɩsɔ Tɑcɑɑ mɑ́ mɑ hɛtǝɣǝnɑ-mɛɣɛ Icipiti nyǝ́mɑ wɑhɑlɑ tǝmɑ ɑnɩ ɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Pǝlɛ pǝ wɑɑlɩ mɑɑ ponɑ-mɛɣɛ tɛtʋ nti mɑɑ sɩɩ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ kɛ nɔɣɔ nɑ tuunɑʋ sɩ mɑɑ hɑ-mɛ nɑ tǝ́ pǝsɩ mǝ nyǝntʋ tɔ tǝ tɑɑ. Mpi tɔ, mɑɣɑ Tɑcɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ḿpʋ́ɣʋ́ Moisi kpɑɣɑ tɔm ntɩ nɑ ɩ́ tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩlɛnɑ pɑ́ kisi tǝ mʋɣʋ. Mpi tɔ, pɑ yomle tǝmɑ kǝlɑ-wɛɣɛ pɩɩʋ. ");
INSERT INTO dop_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ɩlɛnɑ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu sɩ: ");
INSERT INTO dop_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Polo Icipiti wulɑʋ kiŋ nɑ ń heeli-ɩ sɩ pǝ wɛɛ sɩ ń yele Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ lɩɩ nyɑ́ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ntɛnɑ Moisi nɔɣɔ tǝkpɑʋ sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ mɑɣɑmɑɣɑ nɑ́ tɑ́ nɩɩnɑ-m kɑcɑŋfɑnɑ Icipiti wulɑʋ? Hɑlɩ mɑɑ tɩɩ pǝsǝɣɩ yɔɣɔtɑɣɑ kɛ ɩsǝntɔ tɔ, pǝ tɩɩ tɛɛsɑɑ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Kɛlɛnɑ Tɑcɑɑ tʋ Moisi nɑ Alɔŋ sɩ: Ɩ́ polo mǝ nɑɑlɛ nɑ ɩ́ mɑɣɑnɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ Icipiti wulɑʋ nɑ ɩ́ heeli-wɛ sɩ, pǝ wɛɛ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ lɩɩ Icipiti tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ɩsɛɣɛlɩ nyǝ́mɑ lʋlʋŋ loosi nyǝ́mɑ cɔsɔnɑɑ hǝlɑ ntɔ. Yɑkɔpʋ pǝyɑlʋ kɑncɑɑlɑɣɑ nyǝŋ Lupɛŋ pǝyɑlɑɑ ntɛ́ Hɑnɔkɩ nɑ Pɑlu nɑ Hɛsǝlɔŋ nɑ Kɑɑmi, pɛlɛɣɛlɛ Lupɛŋ lʋlʋɣʋ loosi nyǝ́mɑ cɔsɔnɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simiyɔŋ ɩ́lɛ́ ɩ pǝyɑlɑɑ ntɛ́, Yemuwɛlɩ, nɑ Yɑmɛŋ, nɑ Ohɑtɩ, nɑ Yɑkɛŋ, nɑ Sohɑɑ, nɑ Sɑwuli. Ɩ ɑlʋ Kɑnɑɑŋ nyǝŋ lʋlǝnɑ-ɩ ɩ pǝyɑlʋ kɑntǝkɑɣɑ nyǝŋ ɩnɛ. Simiyɔŋ lʋlʋɣʋ loosi nyǝ́mɑ cɔsɔnɑɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lefii pǝyɑlɑɑ mpɑ pɑ kɛ́ ɩ lʋlʋɣʋ loosi nyǝ́mɑ cɔsɔnɑɑ tɔ pɑ wɛ yǝlɑɑ tooso kɛ́. Pɑ hǝlɑ ntɛ́ Kɛɛsɔŋ, nɑ Kehɑtɩ, nɑ Melɑli. Lefii ɩnɩ ɩ lʋlʋɣʋ pɩɩsɩ ntɛ́ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ (137). ");
INSERT INTO dop_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Kɛɛsɔŋ pǝyɑlɑɑ ntɛ́ Lipini nɑ Simeyi, pɛlɛɣɛlɛ Kɛɛsɔŋ lʋlʋɣʋ loosi nyǝ́mɑ cɔsɔnɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kehɑtɩ ɩ́lɛ́ ɩ pǝyɑlɑɑ ntɛ́, Amǝlɑm, nɑ Ɩsɑɑ, nɑ Hepǝlɔŋ, nɑ Usiyɛlɩ. Kehɑtɩ lʋlʋɣʋ pɩɩsɩ ntɛ́ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ nɑ tooso (133). ");
INSERT INTO dop_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Melɑli ɩ́lɛ́ ɩ pǝyɑlɑɑ ntɛ́ Mɑlii nɑ Musi. Pɛlɛɣɛlɛ Lefii nyǝ́mɑ lʋlʋŋ loosi nyǝ́mɑ cɔsɔnɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amǝlɑm ɩ́lɛ́ ɩ kpɑɣɑ ɩ cɑɑ neu Yɔkǝpɛtɩ kɛ́ nɑ ɩ́ lʋlɩ-ɩ ɑpɑlʋpiyɑ kɛ nɑɑlɛ, Alɔŋ nɑ Moisi. Amǝlɑm ɩnɩ ɩ lʋlʋɣʋ pɩɩsɩ ntɛ́ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ (137). ");
INSERT INTO dop_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ɩsɑkɑɑ ɩ́lɛ́ ɩ pǝyɑlɑɑ ntɛ́ Kolee, nɑ Nekɛfɩ, nɑ Sikǝli. ");
INSERT INTO dop_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usiyɛlɩ pǝyɑlɑɑ ntɛ́ Mikɑyɛɛlɩ, nɑ Ilisɑfɑŋ, nɑ Sitili. ");
INSERT INTO dop_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aminɑtɑpɩ pɛɛlɔ Ɩlisepɑ wei ɩ kɛ́ Nɑsɔŋ neu tɔɣɔ Alɔŋ kpɑɣɑɑ nɑ ɩ́ lʋlɩ Nɑtɑpɩ, nɑ Apihu, nɑ Ɩlɑsɑɑ, nɑ Itɑmɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kolee ɩ́lɛ́ ɩ pǝyɑlɑɑ ntɛ́ Asii, nɑ Ɩlikɑnɑ, nɑ Apiyɑsɑfɩ. Pɛlɛɣɛlɛ Kolee lʋlʋɣʋ loosi nyǝ́mɑ cɔsɔnɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Putiyɛlɩ pɛɛlɔ nɔɣɔlʋ kɛ Alɔŋ pǝyɑlʋ Ɩlɑsɑɑ nɑ́ kpɑɣɑɑ nɑ ɩ́lɛ́ ɩ́ lʋlɩ Pɛŋhɑsɩ. Lefii lʋlʋɣʋ nyǝ́mɑ loosi nyǝ́mɑ cɔsɔnɑɑ hǝlɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Nɑ Alɔŋ nɑ Moisi mpɛɣɛ Tɑcɑɑ tɔmɑ sɩ pɑ́ lǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Icipiti tɑɑ kɛ́ nɔɣɔ kʋlʋmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Mpɛ ɩnɩ pɑ tɛlǝsǝnɑ Icipiti wulɑʋ kɛ nti Ɩsɔ yɔɣɔtɑɑ sɩ ɩ́ yele Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ lɩɩ ɩ tɛtʋ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Ɩsɔ yɔɣɔtǝnɑ Moisi kɛ Icipiti tɛtʋ tɑɑ nɑ ɩ́ heeli-ɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Mɑ kɛ́ Tɑcɑɑ kɛ́, polo ń heeli Icipiti wulɑʋ kɛ tǝ tǝnɑ nti mɑ yɔɣɔtǝnɑ mɑ nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mpʋɣʋlɛ Moisi cɔ-ɩ sɩ: Icipiti wulɑʋ kɑɑ nɩɩnɑ-m. Mpi tɔ, mɑ tɑ nyɩ yɔɣɔtɑɣɑ kɛ pɑɑ pǝcɔ pǝcɔ. ");
INSERT INTO dop_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: Mɑɑ tʋ-ŋ toŋ sɔsɔɔŋ nɑ ń pǝsɩ ɩsɩɩ Ɩsɔ kɛ́ Icipiti wulɑʋ ɩsɛntɑɑ nɑ Alɔŋ nɑ́ɑ́ tɛlǝsǝɣɩ-ɩ nyɑ́ tɔm. ");
INSERT INTO dop_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","N kɑ́ kɛɛsɩ Alɔŋ kɛ tǝ tǝnɑ nti mɑ́ɑ́ heeli-ŋ tɔ, nɑ ɩ́lɛ́ ɩ́ tɛlǝsɩ-tǝɣɩ Icipiti wulɑʋ sɩ ɩ́ yele Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ lɩɩ ɩ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pɑɑ nɑ mpʋ tɔ, mɑɑ lɑ Icipiti wulɑʋ kɛ lɑŋkpɩɩsǝŋ. Pɑɑ nɑ piti tǝmɑ nɑ kʋhʋlʋm mpi pǝ tǝnɑ mɑɑ lɑ Icipiti tɑɑ tɔ, ");
INSERT INTO dop_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ɩ kɑɑ nɩɩnɑ-mɛ. Hɑlɩ wɑɑtʋ ɩnǝɣɩ mɑɑ nyǝŋsɩ Icipiti nyǝ́mɑ ɩsɛ kɛ teu kɛ ɩsǝnɑ pǝ wɛɛ tɔ. Ɩlɛnɑ mɑ́ lǝsɩ mɑ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ nɔɣɔ kʋlʋmɑɣɑ kɛ tɛtʋ tǝnɛ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Sɑɑ ɩnǝɣɩ pɩɩ cɛ Icipiti nyǝ́mɑ ɩsɛntɔɔ nɑ pɑ́ nyɩ́ sɩ mɑ kɛ́ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ḿpʋ́ɣʋ́ Moisi nɑ Alɔŋ pɑ lɑpɑ teitei ɩsɩɩ Tɑcɑɑ kɑ heeluɣu-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Wɑɑtʋ wei pɑ yɔɣɔtɑɣɑnɑ wulɑʋ kɛ mpʋ tɔ, Moisi pɩɩsɩ kɑ wɛ nɩɩnɑɑsɑ nɑ Alɔŋ nyǝnsɩ kɛ nɩɩnɑɑsɑ nɑ tooso. ");
INSERT INTO dop_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ḿpʋ́ɣʋ́ Ɩsɔ Tɑcɑɑ heelɑ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Ye Icipiti wulɑʋ tɔmɑ-mɛ sɩ ɩ́ lɑ piti tǝmlɛ nɑtǝlɩ, ɩlɛ Moisi heeli Alɔŋ sɩ ɩ́ pɛtɩ ɩ kpɑ́tʋ́ɣʋ́ kɛ ɑtɛɣɛ wulɑʋ ɩsɛntɑɑ, nɑ kɩɩ pǝsɩ tʋm. ");
INSERT INTO dop_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Tǝnɑɣɑ Moisi nɑ Alɔŋ pɑ tɛɛwɑ nɑ pɑ́ lɑ́ teitei ɩsɩɩ Ɩsɔ Tɑcɑɑ kɛɛsʋɣʋ-wɛ tɔ. Alɔŋ pɛtɑ ɩ kpɑ́tʋ́ɣʋ́ kɛ ɑtɛɣɛ Icipiti wulɑʋ nɑ ɩ wɑɑlɩ nyǝ́mɑ pɑ ɩsɛntɑɑ nɑ kʋ́ pǝsɩ tʋm. ");
INSERT INTO dop_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ḿpʋ́ɣʋ́ wulɑʋ kotɑ Icipiti tʋwɑɑ nɑ pǝ topotopo nyǝ́mɑ nɑ pɛlɛ pɑ́ lɑ́ mpʋ tɔtɔ, nɑ pɑ topotopotʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Pɑ tǝnɑ pɑ pɛtɑ pɑ kpɑtǝŋ kɛ ɑtɛ nɑ ɩ́ pǝsɩ tʋmɑɑ. Tǝnɑɣɑ Alɔŋ kpɑ́tʋ́ɣʋ́ tʋm kʋlɑɑ nɑ ɩ́ li pɑnɛ pɑ nyǝŋ tʋmɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pɑɑ nɑ mpʋ Icipiti wulɑʋ lɑpɑ lɑŋkpɩɩsǝŋ nɑ ɩ́ kisi nti Moisi nɑ Alɔŋ pɑ polɑ-ɩ sǝlǝmʋɣʋ tɔɣɔ teitei ɩsɩɩ Tɑcɑɑ kɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ḿpʋ́ɣʋ́ Ɩsɔ Tɑcɑɑ tɔmɑ Moisi sɩ: Ntɔŋ Icipiti wulɑʋ kɑmɑ nyʋɣʋ kɛ ɩ lɑŋkpɩɩsǝŋ tɑɑ nɑ ɩ́ kisi Ɩsɛɣɛlɩ nyǝ́mɑ kɛ yeluɣu sɩ pɑ́ tɛɛ yɛɛ? ");
INSERT INTO dop_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tɔʋ, cele kʋ femɑ n lɩɩ lɔŋ nɑ ń kpɑɣɑ nyɑ́ kpɑ́tʋ́ɣʋ́ ŋku kɩɩ pǝsɑ tʋm tɔ, nɑ ń polo ɩ tɛɣɛ sɑɑ wei ɩ tiiki pɔɣɔ tɔ, nɑ ń tɑŋɩ-ɩ kʋteŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ɩlɛnɑ ń heeli-ɩ sɩ: Hepǝlɑ nyǝ́mɑ tɑ́, tɑ́ Ɩsɔ Tɑcɑɑ tilinɑ-m sɩ mɑ́ heeli-ŋ sɩ ń yele ɩ yǝlɑɑ nɑ pɑ́ polo pooluŋ nɑ pɑ́ sɛɛ-ɩ, nɑ hɑlǝnɑ sɑŋɑ nyɑɑ sɑŋ. ");
INSERT INTO dop_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Pǝ tɔɔ kɛ́ Tɑcɑɑ sɩ mɑ́ tɛlǝsɩ-ŋ sɩ n tɔmɑ sɩ n tɑ nyǝmɩ-ɩ tɔ pǝnɛntɑɑ kɛ́ n kɑ́ nyǝmɩ-ɩ. Kpɑ́tʋ́ɣʋ́ kʋnɛɣɛ mɑɑ mɑ Nili pɔɣɔ lʋm tɔɔ, ɩlɛnɑ Ɩsɔ yele nɑ pǝ tǝnɑ pǝ́ pǝsɩ cɑlǝm, ");
INSERT INTO dop_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","nɑ tiinɑ sɩ́ nɑ lʋm sɔŋ nɑ hɑlɩ Icipiti nyǝ́mɑ kpisi pǝ nyɔɔʋ. ");
INSERT INTO dop_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu sɩ: Heeli Alɔŋ sɩ kpɑɣɑ nyɑ́ kpɑ́tʋ́ɣʋ́ nɑ ń hʋ́lɩ́-kʋɣʋ Icipiti nyǝ́mɑ lʋm tǝkpentenɑɑ nɑ pusi nɑ lɔɔŋ pǝ tɔɔ nɑ pǝ́ kpɛŋnɑ lʋcɑɣɑmnɑɑ nɑ tɩɩŋ nɑ kʋkpɑmǝŋ pǝ pɔɔŋ tɑɑ lʋmnɑɑ, nɑ pǝ́ pǝsɩ cɑlǝm. Wɑɑtʋ ɩnɩ cɑlǝm kɑ́ wɑɑsɩ tɛtʋ tǝnɑ tǝpɑɩ. ");
INSERT INTO dop_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ḿpʋ́ɣʋ́ Alɔŋ kʋsɑ kpɑ́tʋ́ɣʋ́ nɑ ɩ́ mɑ́ pɔɣɔ lʋm tɔɔ ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ-wɛ tɔɣɔ Icipiti wulɑʋ nɑ ɩ wɑɑlɩ nyǝ́mɑ pɑ ɩsɛntɑɑ, nɑ lʋm tǝnɑ pǝsɩ cɑlǝm. ");
INSERT INTO dop_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ɩlɛnɑ pɔɣɔ tǝnɑ tiinɑ sɩ́, nɑ kɑ lʋm sɔŋ hɑlǝnɑ Icipiti nyǝ́mɑ kpisi pǝ nyɔɔʋ. Nɑ pɑɑ timpiɣi n tɑlɑ tɛtʋ tǝnɑ tɑɑ cɑlǝm wɑɑsǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ḿpʋ́ɣʋ́ Icipiti tʋwɑɑ lɑpɑ teitei ɩsɩɩ Moisi-wɛ nɑ pɑ topotopotʋ tɑɑ. Ɩlɛnɑ Icipiti wulɑʋ lɑ lɑŋkpɩɩsǝŋ ɩsɩɩ Tɑcɑɑ kɑ tɛm yɔɣɔtʋɣʋ tɔ, nɑ ɩ́ kisi nɔɣɔ ŋkɑ pɑɑ sǝlǝmɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ɩ tɑ kpɑɣɑ-tɩ nɑ ɩ́ yɑɑ pʋlʋ. Ɩlɛnɑ ɩ́ hɑ lumɑɣɑ nɑ ɩ́ sʋʋ ɩ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tǝnɑɣɑ Icipiti nyǝ́mɑ tǝnɑ sʋʋ hilɑ lɑɑsʋɣʋ nɑ pɑ́ mɑlǝɣɩ pɔɣɔ sɩ pɑ́ hiki lʋm kʋnyɔnyɔɔm. Mpi tɔ, pɔɣɔ nyǝm tɑɑ fɛɩ nyɔɔʋ. ");
INSERT INTO dop_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ tǝcu kɛ́ lʋm pǝsɑ cɑlǝm. ");
INSERT INTO dop_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Pǝ wɑɑlɩ kɛ́ Tɑcɑɑ tɔmɑ Moisi sɩ: Polo Icipiti wulɑʋ kiŋ nɑ ń heeli-ɩ sɩ yele mɑ yǝlɑɑ nɑ pɑ́ polo pɑ́ lɑ-m tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Ye n kisɑ mpʋ mɑɑ yele nɑ sɑlɛɛ lɩɩ nyɑ́ tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","A kɑ́ huki tǝyomyom kɛ pɔɣɔ tɑɑ. Ɩlɛnɑ ɑ́ kpɑ nɑ ɑ́ sʋʋ wulɑʋ nyɑ́ nyɑ́ kɑwulɑɣɑ tǝyɑɣɑ tɑɑ, nɑ nyɑ́ nɑŋ kʋhǝntʋɣʋ tɑɑ. A kɑ́ kpɑ nyɑ́ kɑto tɔɔ mɑɣɑmɑɣɑ. A kɑ́ sʋʋ tɔtɔɣɔ nyɑ́ wɑɑlɩ nyǝ́mɑ tɛɛsɩ tɑɑ nɑ sɑmɑɑ nyǝnsɩ tɑɑ nɑ tǝtǝsǝlɛ nɑ mʋtʋ tiisi tɑɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Hɑlɩ ɑ kɑ́ kpɑ Icipiti wulɑʋ nyɑ́ nyɑ́ mɑɣɑmɑɣɑ nyɑ́ tɔɔ, nɑ sɑmɑɑ tǝnɑ tɔɔ, nɑ pǝ kpɛŋnɑ tǝmlɛ nyǝ́mɑ tɔɔ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu tɔtɔ sɩ heeli Alɔŋ sɩ: Hʋ́lɩ́ nyɑ́ kpɑ́tʋ́ɣʋ́ nɑ pusi nɑ lɔɔŋ nɑ lʋcɑɣɑmnɑɑ tɔɔ nɑ sɑlɛɛ lɩɩ Icipiti. ");
INSERT INTO dop_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Alɔŋ nɑ́ hʋ́lɑ́ ɩ kpɑ́tʋ́ɣʋ́ kɛ mpʋ, ɩlɛnɑ sɑlɛɛ lɩɩ Icipiti lʋmnɑɑ tɑɑ nɑ ɑ́ wɑɑsɩ tɛtʋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ḿpʋ́ɣʋ́ Icipiti tʋwɑɑ nɑ́ lɑpɑ mpʋ nɑ pɑ topotopotʋ tɑɑ tɔtɔ, nɑ sɑlɛɛ lɩɩ nɑ ɑ́ kpɑ tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ntɛnɑ Icipiti wulɑʋ yɑɑ Moisi nɑ Alɔŋ nɑ ɩ́ tɔ-wɛ sɩ: Ɩ́ wiinɑ Tɑcɑɑ nɑ ɩ́ hɑtǝlǝnɑ sɑlɛɛ ɑnǝɣɩ mɑ́ nɑ mɑ́ yǝlɑɑ. Pǝ wɑɑlɩ ɩlɛ mɑɑ yele Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ polo pɑ́ lɑ́ Ɩsɔ kɛ́ kɔtɑsɩ. ");
INSERT INTO dop_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Tǝnɑɣɑlɛ Moisi cɔ Icipiti wulɑʋ sɩ: Tɑ cɑɑ, lǝsɩ nyɑ́ mɑɣɑmɑɣɑ kɛ sɑɑ wei n sɔɔlɑɑ sɩ mɑ́ sǝlǝmɩ Ɩsɔ kɛ́ mǝ tɔɔ nɑ ɩ́ kʋ́ sɑlɛɛ kɛ nyɑnɑ nyɑ́ sɑmɑɑ nɑ nyɑ́ tǝmlɛ nyǝ́mɑ mǝ tɛɛsɩ tɑɑ nɑ ɑ́ mǝlɩ pɔɣɔ tɑɑ tike tɔ. ");
INSERT INTO dop_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kɛlɛnɑ wulɑʋ sɩ: Cele kɛ mɑ cɑɑkɩ sɩ ń sǝlǝmɩ Ɩsɔ. Ntɛnɑ Moisi sɩ: Tɔʋ, pǝ wɛ teu. Mɑɑ lɑ mpʋ, ɩlɛnɑ pǝ́cɔ́ ń cɛkǝnɑ sɩ tɑ́ Ɩsɔ Tɑcɑɑ fɛɩnɑ sɑɑlɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pɔpɔtʋ fɛɩ leleŋ, sɑlɛɛ kɑ́ lɩɩ nyɑnɑ nyɑ́ sɑmɑɑ nɑ nyɑ́ tǝmlɛ nyǝ́mɑ mǝ tɛɛsɩ tɑɑ nɑ ɑ́ mǝlɩ pɔɣɔ tɑɑ tike. ");
INSERT INTO dop_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ḿpʋ́ɣʋ́ Moisi nɑ Alɔŋ pɑ lɩɩ Icipiti wulɑʋ tɛ́. Ɩlɛnɑ Moisi sǝlǝmɩ Ɩsɔ kɛ́ sɑlɛɛ ɑnɩ ɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ɩlɛnɑ Tɑcɑɑ lɑ ɩsɩɩ ɩ sǝlǝmʋɣʋ tɔ, nɑ sɑlɛɛ sɩ tɛɛsɩ tɑɑ nɑ tɑɑsɩ tɔɔ nɑ tɑwɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ḿpʋ́ɣʋ́ pɑ kotɑ-yɛɣɛ huwɑ huwɑ. Ɩlɛnɑ ɩcɑtɛ tǝnɑ sɔŋ pǝ fɛɩ teu. ");
INSERT INTO dop_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Icipiti wulɑʋ nɑwɑ sɩ ɩ wɑhɑlɑ pɑsɑɑ, ɩlɛnɑ ɩ́ lɑ́ lɑŋkpɩɩsǝŋ nɑ ɩ́ kisi Moisi nɑ Alɔŋ kɛ nɩɩnɑʋ kɛ teitei ɩsɩɩ Tɑcɑɑ kɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ heeli Alɔŋ sɩ: Mɑ nyɑ́ kpɑ́tʋ́ɣʋ́ kɛ tɛtʋ tɔɔ, nɑ mʋsʋɣʋ pǝsɩ pɔtʋ nɑ tǝ́ kpɑ Icipiti tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ntɛnɑ Moisi nɑ Alɔŋ pɑ́ lɑ́ teitei ɩsɩɩ Tɑcɑɑ heelɑ-wɛ tɔ. Ɩlɛnɑ mʋsʋɣʋ pǝsɩ pɔtʋ nɑ tǝ́ wɑɑsɩ yǝlɑɑ nɑ tɔlɑ pɑ tɔɔ kɛ́ tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ɩlɛnɑ Icipiti tʋwɑɑ mɑɣɑsɩ ɩsɩɩ pɑɑ lɑ mpʋ nɑ pɑ topotopotʋ tɑɑ nɑ pɑ́ kpisi. Nɑ pɔtʋ nɑ́ɑ́ wɛ tɔlɑ nɑ yǝlɑɑ pɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tǝnɑɣɑlɛ tʋwɑɑ heelɑ Icipiti wulɑʋ sɩ: Ɩsɔ mpǝle kɛ cǝnɛ ɩnǝɣɩ yoo. Pɑɑ nɑ mpʋ Icipiti wulɑʋ tɔkɑ ɩ lɑŋkpɩɩsǝŋ nɑ ɩ́ kisi Moisi nɑ Alɔŋ kɛ nɩɩnɑʋ kɛ teitei ɩsɩɩ Tɑcɑɑ kɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: Cele kʋlɩ lɔŋ kɛ tɑnɑŋ kʋpɑŋkʋ tɛɛ, nɑ ń kɑtɩ Icipiti wulɑʋ kɛ wɑɑtʋ wei ɩ tiiki pɔɣɔ tɔ nɑ ń heeli-ɩ sɩ Tɑcɑɑ mɑ́, mɑ tɔmɑ sɩ yele mɑ yǝlɑɑ nɑ pɑ́ polo pɑ́ lɑ-m tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ye n kisɑɑ sɩ n kɑɑ yele-wɛ, ɩlɛ mɑ yele nɑ kɑcɔsɩ kʋnɑɑsɑsɩ nɑsǝlɩ sɩ lɩɩ nɑ sɩ́ sú Icipiti nyǝ́mɑ tɛɛsɩ tɑɑ kɛ́ tɛtʋ tǝnɑ tɑɑ, nɑ sɩ́ nyɑsǝɣɩ nyɑnɑ yǝlɑɑ nɑ nyɑ́ tǝmlɛ nyǝ́mɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Amɑ kɑcɔsɩ nsɩ sɩ kɑɑ wiili Kosɛŋ tɛtʋ tɑɑ timpi mɑ yǝlɑɑ wɛɛ tɔ. Tǝnɑɣɑ Icipiti wulɑʋ kɑ nyǝnɑ sɩ Tɑcɑɑ mɑ́, mɑ wɛ Icipiti tɑɑ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Mɑɑ kenti mǝ tɔɔ kɛ́ kpɑntɛ kɛ cele, nɑ ɩ́ kɑɑ nɑ wɑhɑlɑ ɩnɛ. ");
INSERT INTO dop_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ḿpʋ́ɣʋ́ Tɑcɑɑ yelɑɑ nɑ kɑcɔsɩ kʋnyɑsɑsɩ nɑsǝlɩ lɩɩ tuutuumɑ nɑ sɩ́ wɑtɩ Icipiti wulɑʋ nɑ ɩ tǝmlɛ nyǝ́mɑ pɑ tɛɛsɩ tɑɑ, nɑ sɩ́ wɑkǝlɩ tɛtʋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Tǝnɑɣɑlɛ Icipiti wulɑʋ yɑɑ Moisi nɑ Alɔŋ nɑ ɩ́ tɔ-wɛ sɩ: Ɩ́ polo ɩ́ lɑ́ mǝ Ɩsɔ kɛ́ kɔtɑsɩ. Ɩlɛ Icipiti tɛtʋ tɑɑ kɛ́ pǝ wɛɛ sɩ ɩ́ lɑ-sɩ. ");
INSERT INTO dop_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kɛlɛnɑ Moisi nɑ Alɔŋ pɑ cɔ sɩ: Tǝ kɑɑ lɑ-sǝɣɩ cǝnɛ. Mpi tɔ, Icipiti nyǝ́mɑ kɑ́ nyǝnɩ-sǝɣɩ ɑcɑɑlǝtʋ nɑ pɑ́ yɑɣɑ-tʋɣʋ pɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Pǝ wɛɛ kɛ́ sɩ tǝ́ tɔ kʋyɛɛŋ tooso nɑ tǝ́ polo pooluŋ. Ɩlɛnɑ tǝ́ lɑ́ tɑ́ Ɩsɔ Tɑcɑɑ kɛ kɔtɑsɩ ɩsɩɩ ɩ kɑ heeluɣu-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ntɛnɑ Icipiti wulɑʋ sɩ: Mɑɑ yele-mɛ nɑ ɩ́ polo. Ɩlɛ ɩ́ tɑɑ hɑtǝlɩ pooluŋ kɛ́. Aɑɩyee sɩ, ɩ́ sǝlǝmǝnɑ-m. ");
INSERT INTO dop_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mpʋɣʋlɛ Moisi nɔɣɔ tǝkpɑʋ sɩ: Ye mɑ lɩɩ cǝnɛ, mɑɑ sǝlǝmɩ Tɑcɑɑ nɑ cele ɩ kɑ́ hɑtǝlǝnɑ nyɑ́ nɑ nyɑ́ tǝmlɛ nyǝ́mɑ nɑ nyɑ́ yǝlɑɑ kɛ kɑcɔsɩ sǝnɛ. Amɑ kʋlʋmtʋ kɛ́ sɩ ń tɑɑ nɛɛtɩ-tʋ nɑ ń tɑɣɑnɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɣɑ tɑŋʋɣʋ sɩ tǝ tɑɑ polo nɑ tǝ lɑ́ Ɩsɔ kɛ́ kɔtɑsɩ. ");
INSERT INTO dop_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moisi lɩɩ Icipiti wulɑʋ tɛ́ ɩlɛnɑ ɩ́ sǝlǝmɩ Tɑcɑɑ, ");
INSERT INTO dop_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","nɑ ɩ́lɛ́ ɩ lǝsɩ kɑcɔsɩ tǝnɑ nɑ sɩ́ yele Icipiti wulɑʋ nɑ ɩ tǝmlɛ nyǝ́mɑ nɑ ɩ yǝlɑɑ, pǝ tɑ sɔɔ pɑɑ kʋlʋmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ḿpʋ́ɣʋ́ Icipiti wulɑʋ lɑpɑ lɑŋkpɩɩsǝŋ tɔtɔ nɑ ɩ́ kisi sɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ tɑɑ lɩɩ. ");
INSERT INTO dop_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: Polo Icipiti wulɑʋ kiŋ nɑ ń heeli-ɩ sɩ Hepǝlɑ nyǝ́mɑ Ɩsɔ Tɑcɑɑ mɑ́, mɑ tɔmɑ sɩ yele mɑ yǝlɑɑ nɑ pɑ́ polo pɑ́ lɑ-m tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ye n wɛɛ nɑ n kisiɣi nɑ n kɑŋ nyʋɣʋ nɑ ń tɑŋǝɣɩ-wɛɣɛ mpʋ, ");
INSERT INTO dop_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","mɑɑ yele nɑ kʋsǝkʋ ɩsɑɣɑʋ nɑkʋlɩ kʋ kpɑ Icipiti nyǝ́mɑ tɔlɑ, nɑ kʋ́ kʋ kpɑɣɑnǝŋ nɑ kpɑŋɑsɩ nɑ yooyoonɑɑ, nɑ nɑɑŋ, nɑ heeŋ, nɑ pǝ́ŋ. ");
INSERT INTO dop_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Amɑ Tɑcɑɑ kɑ́ fɑɣɑsɩ Ɩsɛɣɛlɩ nyǝ́mɑ nyǝnɑ nɑ ɑ tɑɑ nɑtǝlɩ nyʋɣʋ kɑɑ holi-tɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Pǝlɛ pǝ pɑɑsi ɩlɛnɑ Ɩsɔ Tɑcɑɑ sɩɩ sɩ cele kɛ ɩnɩ ɩ kɑ lɑ kɔkɔlɔ ɩnǝɣɩ Icipiti tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Tɛʋ femɑ ɩlɛnɑ Tɑcɑɑ yele nɑ kʋsǝkʋ nɑŋ Icipiti nyǝ́mɑ tɔlɑ tǝnɑɣɑ kʋpɑmpǝlɛ ɩsɩɩ ɩ kɑ yɔɣɔtʋɣʋ tɔ. Amɑ Ɩsɛɣɛlɩ nyǝ́mɑ nyǝnɑ tɑɑ nɑtǝlɩ tǝ nyʋɣʋ tɑ holi-tɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ḿpʋ́ɣʋ́ Icipiti wulɑʋ pɔɔsɑɑ nɑ ɩ́ nɩɩ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔlɑ tɑɑ nɑtǝlɩ tǝ tɑ sɩ́. Pɑɑ nɑ mpʋ pǝlɛ pǝ tɑ lɑpɩ-ɩ pʋlʋ. Ɩ kɑmɑ nyʋɣʋ kɛ ɩ lɑŋkpɩɩsǝŋ tɑɑ nɑ ɩ́ kisi Ɩsɔ yǝlɑɑ kɛ yeluɣu sɩ pɑ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Pǝ wɑɑlɩ kɛ Tɑcɑɑ tɑsɑ Moisi nɑ Alɔŋ kɛ heeluɣu tɔtɔ sɩ: Ɩ́ cosi mǝsɑɣɑ tɑɑ tɔlʋmɑ kɛ mǝ ŋkulee tɑɑ. Ɩlɛnɑ ɩ́ polo wulɑʋ tɛ́, nɑ Moisi ŋmɩɩsɩ-yɛɣɛ ɩsɔtɑɑ nɑ Icipiti wulɑʋ nyǝnǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","A kɑ́ yɑ́ tɛtʋ tǝnɑ tɑɑ nɑ ɑ́ lʋlɩ yǝlɑɑ nɑ tɔlɑ kɛ mʋlɑ nɑɑlɩ, nɑ ɑ́ pǝsɩ sǝmolɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mpʋɣʋlɛ Moisi nɑ Alɔŋ pɑ cosɑ tɔlʋmɑ, ɩlɛnɑ pɑ́ polo wulɑʋ tɛ nɑ Moisi ŋmɩɩsɩ-yɛɣɛ ɩsɔtɑɑ, nɑ ɑ́ lʋlɩ yǝlɑɑ nɑ tɔlɑ kɛ mʋlɑ nɑ ɑ́ pǝsɩ sǝmolɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Mʋlɑ ɑnɩ ɑ kpɛnnɑ Icipiti tʋwɑɑ tɔtɔɣɔ nɑ ɑ́ kpɑ-wɛɣɛ teitei ɩsɩɩ yǝlɑɑ tǝnɑ. Hɑlǝnɑ pɑ kpisi Moisi-wɛɣɛ kpǝtǝnɑʋ. ");
INSERT INTO dop_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ḿpʋ́ɣʋ́ Tɑcɑɑ yelɑɑ nɑ Icipiti wulɑʋ sɔɔsɩ nyʋɣʋ kɑm kɛ ɩ lɑŋkpɩɩsǝŋ tɑɑ nɑ ɩ́ kisi Moisi nɑ Alɔŋ kɛ nɩɩnɑʋ kɛ teitei ɩsɩɩ ɩ kɑ heeluɣu Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: Cele kʋlɩ lɔŋ kɛ tɑnɑŋ kʋpɑŋkʋ tɛɛ nɑ ń mɑɣɑnɑ Icipiti wulɑʋ nɑ ń heeli-ɩ sɩ Hepǝlɑ nyǝ́mɑ Ɩsɔ Tɑcɑɑ mɑ́, mɑ tɔmɑ sɩ: Yele mɑ yǝlɑɑ nɑ pɑ́ polo pɑ lɑ-m tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Amɑ pǝnɛntɑɑ mɑ tʋ mɑ tɑɑ kɛ́ sɩ mɑɑ lɑ wɑhɑlɑnɑɑ mpɛ pɑ tǝnɑɣɑ nyɑnɑ nyɑ́ tǝmlɛ nyǝ́mɑ nɑ nyɑ́ yǝlɑɑ. Ɩlɛnɑ pǝ́cɔ́ ń nyɩ́ sɩ nɔɣɔlʋ tɑ nǝɣǝsǝnɑ-m ɑntulinyɑ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ye mɑɑ sɔɔlɑɑ mɑɑ kʋwɑ nyɑnɑ nyɑ́ yǝlɑɑ nɑ yʋlʋkʋsǝkʋ nɑ ɩ́ sɑɑlɩ yem kɛ́ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Amɑ mɑ yelɑ-ŋ nɑ nyɑ́ ɩsɛ kɛ ḿpʋ́ɣʋ́ sɩ ń nyɩ́ sɩ mɑ wɛnɑ toŋ. Ɩlɛnɑ mɑ hǝtɛ sɔɔsɩ yɑɑʋ kɛ tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pɑɑ nɑ mpʋ, n wɛɛ nɑ ń hɔŋ nyɑ́ tɩ nɑ ń kisiɣi sɩ mɑ yǝlɑɑ ɩ́ tɑɑ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Pǝ tɔɔ kɛ́ cele ɩsǝntɔ wɑɑtʋ, mɑɑ yele nɑ tɔmpɛɛ tɛʋ ŋku too Icipiti tʋ nɔɣɔlʋ tɑ nɑtɑ tɔ kʋ́ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Mpʋ tɔ, kpeɣeli nyɑ́ tɔlɑ nɑ ń cɔɔsɩ-yɛɣɛ tiili. Ye yǝlɑɑ nɑ tɔlɑ pɑ cɑɣɑ tɑɑlɛ kɛ yem nɑ pɑ tɑ cɔɔsɩ, tɔmpɛɛ kɑ́ kʋ-wɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Wulɑʋ tǝmlɛ nyǝ́mɑ tɑɑ lɛlɑɑ mʋ Tɑcɑɑ tɔm ntǝɣɩ niŋ nɑɑlɛ, nɑ pɑ́ heeli pɑ tǝmlɛ nyǝ́mɑ sɩ pɑ nɑ tɔlɑ pɑ́ cɔɔsɩ timpi tɔmpɛɛ ɑnɩ ɑ kɑɑ nɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Amɑ lɛlɑɑ nɑ́ tɑ́ nyɑnɑ Tɑcɑɑ tɔm ntɩ nɑ pɑ́ yele pɑ tǝmlɛ nyǝ́mɑ nɑ pɑ tɔlɑ kɛ tɑwɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Pǝ wɑɑlɩ kɛ́ Tɑcɑɑ heelɑ Moisi sɩ: Hʋ́lɩ́ nyɑ́ kpɑ́tʋ́ɣʋ́ nɑ ɩsɔtɑɑ nɑ tɔmpɩɩŋ hoti Icipiti tɛtʋ yǝlɑɑ nɑ tɔlɑ tɔɔ nɑ pɑ tɑwɑ tɑɑ kʋhɑlǝm tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moisi kpɑɑsɑ ɩ kpɑ́tʋ́ɣʋ́ nɑ ɩsɔtɑɑ kɛ mpʋ, ɩlɛnɑ Tɑcɑɑ yele nɑ tɛʋ holiɣi nɑ kʋ́ nɑsǝɣɩ kpɑŋŋ kpɑŋŋ. Ɩlɛnɑ tɔmpɩɩŋ lɩɩkǝnɑ ɩsɔ nɑ ɩ́ hotiɣi tɛtʋ tǝnɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Hɑtoo pǝ cɑɑlʋɣʋ Icipiti tɛtʋ kɛ sɩɩʋ tɔ nɔɣɔlʋ tɑ nɑtɑ tɔmpɩɩŋ ɩnɩ ɩ tɑkɑ nɑ pǝ tɛʋ nyǝɣǝsʋɣʋ kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ḿpʋ́ɣʋ́ tɔmpɩɩŋ wɑkǝlɑ pǝ tǝnɑ mpi pɩɩ wɛ tɑwɑ tɑɑ tɔ, pɑɑ yǝlɑɑ pɑɑ tɔlɑ. Pǝ kɑɑsɩ nɑ ɑ́ pʋɣʋtɩ kʋhɑlǝm nɑ ɑ́ cɑɑtɩ tɩɩŋ kɛ yem yem. ");
INSERT INTO dop_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kʋsɛŋ timpi Ɩsɛɣɛlɩ nyǝ́mɑ wɛɛ tɔ tǝnɑ tike kɛ tɔmpɩɩŋ tɑ cǝtǝlɩ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Tǝnɑɣɑlɛ Icipiti wulɑʋ yɑ́ɑ́ Moisi nɑ Alɔŋ nɑ ɩ́ heeli-wɛ sɩ: Pǝnɛntɛ mɑ́ lɑpǝnɑ ɩsɑɣɑtʋ. Mɑ́ nɑ mɑ yǝlɑɑ ntɛ́ tɑsǝkǝlɛ nyǝ́mɑ. Ɩsɔ tike ntɛ́ tɑmpɑnɑ tǝŋlʋ. ");
INSERT INTO dop_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hɑɩ, ɩ́ wiinɑ Ɩsɔ nɑ tɔmpɛɛ hɛɛsɩ mpʋ. Mɑɑ yele-mɛ nɑ ɩ́ tɛɛ, mɑɑ tɑsǝɣɩ-mɛɣɛ tɑŋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Tǝnɑɣɑlɛ Moisi nɔɣɔ tǝkpɑʋ sɩ: Ye mɑ lɩɩwɑ ɩcɑtɛ wɑɑlɩ mɑɑ tɛɣɛ Ɩsɔ kɛ́ niŋ nɑ tɛʋ holɑ nɑ kʋ tɔmpɛɛ hɛɛsɩ. Ɩlɛnɑ pǝ́cɔ́ ń cɛkǝnɑ sɩ Tɑcɑɑ tǝnnɑ ɑntulinyɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pǝnɑ pǝ mpʋ tɔ, mɑ nɑɑ kɛ́ sɩ nyɑnɑ nyɑ́ yǝlɑɑ ɩ́ seeki Ɩsɔ kɛ́ ɑcɛsɑɑcɛsɑɑ sewɑ kɛ́, ɩ́ tɑ́ tɛ́ mǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Wɑɑtʋ wei tɔmpɛɛ kɔmɑ mpʋ tɔ ɑ sulinɑ pɑ tɛ́ kpoŋkpontu toŋ nyǝntʋ nti pɑ yɑɑ sɩ lɛŋ tɔ tǝ hɛtʋ tʋɣʋ, nɑ pɑ tɔɣɔnɑɣɑ pee nyǝŋkɑ tʋlʋɣʋ ntɛ́, nɑ ɑ́ wɑkǝlɩ-yɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Amɑ pǝ kɑɑsɑ pɑ tɔɣɔnɑsɩ lɛnsǝnɑɑ tɔ pǝ tɑ wɑkǝlɩ sǝlɛ. Mpi tɔ, sǝlɛ sɩ tɑɑ kʋlǝtɑ sɑɑ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisi lɩɩwɑ ɩcɑtɛ wɑɑlɩ ɩlɛnɑ ɩ́ tɛɣɛ Ɩsɔ kɛ́ niŋ nɑ ɩ́ wiinɑ-ɩ tɔmpɛɛ ɑnɩ ɑ tɔm. Ɩlɛnɑ tɛʋ nɑ kʋ holɑ nɑ tɔmpɛɛ pǝ́ tɛ́. ");
INSERT INTO dop_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Icipiti wulɑʋ pɑɑsǝnɑɑ sɩ pǝ tǝnɑ pǝ hɛɛwɑ ɩlɛnɑ ɩ́ nɑ ɩ tǝmlɛ nyǝ́mɑ pɑ́ mǝlɩ pɑ nyǝŋ ɩnɩ ɩ tɑɑ ɩsɩɩ too ɩlɛ. ");
INSERT INTO dop_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ḿpʋ́ɣʋ́ pɑ kisɑɑ tǝsɑɣɑsɑɣɑ sɩ mpɛ pɑ kɑɑ yele Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ lɩɩ tɛtʋ tɑɑ kɛ́ teitei ɩsɩɩ Tɑcɑɑ kɑ heeluɣu Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: Mǝlɩ Icipiti wulɑʋ tɛ́, mɑ́ yelinɑ sɩ ɩ́ nɑ ɩ tǝmlɛ nyǝ́mɑ pɑ́ lɑ lɑŋkpɩɩsǝŋ kɛ mpʋ nɑ mɑ́ lɑ́ kɔkɔlɔ nyǝm tǝnɑ nɑ pɑ́ nɑ́. ");
INSERT INTO dop_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Mɑ lɑpɑ ḿpʋ́ɣʋ́ sɩ n kɑ́ kɛɛsɩ nyɑ́ piyɑ nɑ nyɑ́ sɑɑlǝnɑɑ kɛ ɩsǝnɑ mɑ lɑpɑ Icipiti tɑɑ kɛ́ kɔkɔlɔ nyǝm tɔ. Tǝnɑɣɑ ɩ́ kɑ́ nyǝnɑ sɩ mɑ kɛ́ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ḿpʋ́ɣʋ́ Moisi nɑ Alɔŋ pɑ polɑ Icipiti wulɑʋ tɛ́ nɑ pɑ́ heeli-ɩ sɩ: Hepǝlɑ nyǝ́mɑ tɑ́, tɑ́ Ɩsɔ Tɑcɑɑ tɔmɑ-tʋ sɩ tǝ́ kɔɔ tǝ́ pɔɔsɩ-ŋ sɩ pǝlee kɛ́ n kɑ́ lɔ́ nyɑ́ lɑŋkpɩɩsǝŋ nɑ ń yele ɩ yǝlɑɑ nɑ pɑ́ polo pɑ́ lɑpɩ-ɩ tǝmlɛ? ");
INSERT INTO dop_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ye n kɑmɑ nyʋɣʋ kɛ pǝ tɑɑ, cele ɩ kɑ́ kɔnɑ kʋtoloŋ kɛ nyɑ́ tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Kɩɩ wɑ́ɑ́sɩ tɛtʋ tɔɔ tǝwisiwisi, nɑ kʋ́ kuɣuli kʋnyɔnyɔm nɑ tɩɩŋ wei tɔmpɛɛ kɑ fɛɛwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Kʋtoloŋ kɑ́ mɑɣɑlɩ nyɑnɑ nyɑ́ tǝmlɛ nyǝ́mɑ nɑ Icipiti nyǝ́mɑ tǝnɑ tɛɛsɩ tɑɑ tǝpɑmpɑm. Too tɔ, nyɑ́ cɑɑnɑɑ nɑ pɛlɛ pɑ cɑɑnɑɑ tɑ keesitɑ kɔkɔlɔ ɩnɩ ɩ tɑkɑ hɑlǝnɑ sɑŋɑ. Moisi tɛmɑ mpʋ ɩlɛnɑ ɩ́ lɩɩ Icipiti wulɑʋ tɛ́. ");
INSERT INTO dop_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Icipiti wulɑʋ tǝmlɛ nyǝ́mɑ kotɑɑ nɑ pɑ́ tɔmɩ-ɩ sɩ: Tɑ cɑɑ, yʋlʋ ɩnɛ ɩ kɑ cɔɔsɩ-tʋ yoo. Pǝ tɔɔ tɔ, yele-wɛ nɑ pɑ́ polo pɑ́ lɑ́ pɑ Ɩsɔ Tɑcɑɑ kɛ tǝmlɛ. Ye pǝ tɑɣɑ mpʋ Icipiti nyǝ́mɑ tǝnɑ kɑ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Tǝnɑɣɑlɛ pɑ tɑɣɑnɑ Moisi nɑ Alɔŋ kɛ yɑɑʋ kɛ Icipiti wulɑʋ tɛ́ nɑ ɩ́lɛ́ ɩ heeli-wɛ sɩ: Ɩ́ polo ɩ́ lɑ́ mǝ Ɩsɔ Tɑcɑɑ kɛ tǝmlɛ. Ɩ tɑɑ ɩ tɑɑ ɩlɛ sɩ: Awe nɑ ɑwe pɑɑ ponɑ? ");
INSERT INTO dop_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ntɛnɑ Moisi sɩ: Tɑ tǝnɑ tɩɩ ponɑ. Pǝ kpɑɣɑʋ ɩfepiyɑ nɑ tɑ́ kʋkpɑtǝlɑɑ nɑ tɑ́ pǝyɑlɑɑ nɑ tɑ́ pɛɛlɑɑ tɔ. Nɑ tǝ́ kpɛŋnɑ tɑ́ tɔlɑ tǝnɑ. Mpi tɔ, Tɑcɑɑ ɑcimɑ kɛ tǝ puki tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Mpʋɣʋlɛ Icipiti wulɑʋ pǝsǝnɑ-wɛ sɩ: Mǝ tɑɑ sɩ mɑɑ yele mǝ nɑ mǝ piyɑ nɑ ɩ́ tɛɛ yɛɛ? Ɩsɔ ɩ́ sɩɩ-mɛ yɑɑ. Mɑ nyǝmɑ́ mǝ tɑɑ lɑɣɑtʋ kɛ́ té. ");
INSERT INTO dop_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Pǝ kɑɑ lɑ mpʋ. Apɑlɑɑ mɛ, mǝ tike ɩ́ kɑ́ ponɑ nɑ ɩ́ lɑ́ mǝ Ɩsɔ kɛ́ tǝmlɛ. Mpi ɩ kɑ sǝlǝmɩ tɔɣɔlɛ. Ɩlɛnɑ pɑ́ tɔɣɔnɩ Moisi nɑ Alɔŋ kɛ Icipiti wulɑʋ tɛ, nɑ pɛlɛ pɑ́ lɩɩ. ");
INSERT INTO dop_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Tǝnɑɣɑ Tɑcɑɑ tɔmɑ Moisi sɩ: Hʋ́lɩ́ nyɑ́ kpɑ́tʋ́ɣʋ́ kɛ Icipiti tɛtʋ tɔɔ nɑ kʋtoloŋ lɩɩ nɑ kʋ wɑ́ɑ́sɩ-tɩ nɑ kʋ́ tɔɣɔ kʋnyɔnyɔm tǝnɑ mpi tɔmpɛɛ kɑ fɛɛwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ḿpʋ́ɣʋ́ Moisi hʋlɑ ɩ kpɑ́tʋ́ɣʋ́ kɛ Icipiti tɛtʋ tǝnɑ tɔɔ. Ɩlɛnɑ Tɑcɑɑ yele nɑ heelim lɩɩnɑ tɛʋ kite nɑ pǝ́ mɑ́ ilim mpɩ nɑ ɑhoo tǝnɑ. Pǝ kɔmɑ nɑ pǝ́ nyɑɑlɩ ɩlɛ kʋtoloŋ tɑpɑɣɑlɛ. ");
INSERT INTO dop_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Kʋ kɔmɑ tuutuumɑ kɛ́, nɑ kʋ wɑ́ɑ́sɩ tɛtʋ tǝnɑ tɔɔ. Too tɔ, pɑ tɑ nɑtɑ kʋtoloŋ ɩsɩɩ mpʋ pǝ tɑkɑ. Pǝ́cɔ́ pɑ kɑɑ tɑsɑ kʋ tɑkɑ kɛ́ nɑʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Kʋ wɑɑsɑ tɛtʋ tǝnɑɣɑ nɑ tǝ́ mǝlɩ piliŋ, nɑ kʋ́ tɔɣɔ nyɩɩtʋ nɑ tɩɩŋ wei tɔmpɛɛ kɑ yelɑɑ tɔ ɩ pee tǝnɑ. Pǝ tɑ sɔɔ tʋɣʋ nɑkʋlɩ kʋ hɑtʋ yɑɑ nyɩɩliyɑ. ");
INSERT INTO dop_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ḿpʋ́ɣʋ́ Icipiti wulɑʋ yɑɑ Moisi nɑ Alɔŋ kɛ lɔŋ nɑ ɩ́ heeli-wɛ sɩ: Mɑ wɑkǝlǝnɑ mǝ Ɩsɔ Tɑcɑɑ nɑ mǝ mɑɣɑmɑɣɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Hɑɩ, mɑ wiikinɑ-mɛ sɩ ɩ́ tɑsɑ-m suulu hʋlʋɣʋ kɛ tɔm kʋlʋm. Ɩ́ sǝlǝmɩ mǝ Ɩsɔ sɩ ɩ́ hɑtǝlǝnɑ-m sǝm pǝnɛ. ");
INSERT INTO dop_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisi lɩɩ Icipiti wulɑʋ tɛ́ ɩlɛnɑ ɩ́ wiinɑ Ɩsɔ kɛ́ kʋtoloŋ tɔm. ");
INSERT INTO dop_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ḿpʋ́ɣʋ́ Tɑcɑɑ kɛɛ heelim nɑ pǝ́ mɑkǝnɑ toŋ nɑ ilim tǝtʋlɛ tɔɔ nɑ pǝ́ pɑɑlɩ kʋtoloŋ nɑ pǝ́ pǝlɩ kʋ tǝnɑɣɑ sǝsǝncɑɑsɩ teŋku tɑɑ. Pǝ tɑ sɔɔ pɑɑ kʋlʋmʋɣʋ kɛ Icipiti tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ḿpʋ́ɣʋ́ Tɑcɑɑ tʋ Icipiti wulɑʋ kɛ lɑŋkpɩɩsǝŋ nɑ ɩ́ kisi sɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ tɑɑ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: Kʋsɩ nyɑ́ kpɑ́tʋ́ɣʋ́ nɑ ɩsɔtɑɑ nɑ sǝkpɛtʋɣʋ tɑɑ sǝkpɛtʋɣʋ nyɑlɑ Icipiti tɛtʋ tǝnɑ tɑɑ. Hɑlǝnɑ yǝlɑɑ tokiɣinɑ-kʋ. ");
INSERT INTO dop_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moisi kʋsɑ-kʋɣʋ mpʋ ɩlɛnɑ sǝkpɛtʋɣʋ yuŋ nyǝŋkʋ nɑkʋlɩ kʋ nyɑlɑ Icipiti tɛtʋ tǝnɑ tɔɔ kɛ́ kʋyɛɛŋ tooso tǝcu. ");
INSERT INTO dop_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kʋyɛɛŋ tooso ɩnɩ ɩ tɑɑ nɔɣɔlʋ tɑ keesi ɩ tɔɣɔntǝlɛ. Pǝyele nɔɣɔlʋ tɑ lɑɣɑsɩ lonte. Amɑ kʋ tɑɑ fɛɩ Ɩsɛɣɛlɩ nyǝ́mɑ hɔɣɔlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ḿpʋ́ɣʋ́ Icipiti wulɑʋ yɑ́ɑ́ Moisi nɑ ɩ́ heeli-ɩ sɩ: Mɑɑ yele-mɛ nɑ ɩ́ polo ɩ́ sɛɛ mǝ Ɩsɔ ɩsɩɩ ɩ sǝlǝmʋɣʋ tɔ. Nɑ ɩ́ tɩɩ nɔkɑɑ ɩ́ kpɛnnɑ mǝ ɑlɑɑ nɑ mǝ piyɑ. Amɑ mǝ tɔlɑ tike kɑɑ lɩɩnɑ hǝm. ");
INSERT INTO dop_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mpʋɣʋlɛ Moisi sɩ: Ɩlɛnɑ ń cɛlɛ-tʋɣʋ tɔlɑ nnɑ tɩɩ lɑ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ nɑ ciikuɣu nyǝnsɩ nɑ? ");
INSERT INTO dop_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Pǝ wɛɛ kɛ́ sɩ tǝ́ kpɑɣɑ tɑ tɔlɑ tǝnɑ, tǝ kɑɑ sɔɔ hʋntʋɣʋ. Tɩɩ tɑlɑ tǝnɑ tɔɣɔ tɩɩ nyɩ tɔlɑ ɩsǝnɑ, nɑ nnɑ ɑ́ tɑkɑ tɑ́ Ɩsɔ cɑɑ sɩ tǝ́ lɑpɩ-ɩ kɔtɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ɩlɛnɑ Tɑcɑɑ tɑsɑ Icipiti wulɑʋ kɛ lɑŋkpɩɩsǝŋ kɛ tʋɣʋ nɑ ɩ́ kisi sɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ tɑɑ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Hɑlǝnɑ ɩ́ tɔɣɔnɩ Moisi kɛ kʋtɔɣɔnʋ sɩ ɩ́ lɩɩ ɩnɩ ɩ tɛ. Nɑ ɩ́ tɔmɩ-ɩ sɩ: Lɑ lɑɑkɑlɩ, ye pǝ cǝpɑ-ŋ nɑ ń tɑsɑ cǝnɛɣɛ mǝlʋɣʋ mɑɑ kʋ-ŋ. ");
INSERT INTO dop_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mpʋɣʋlɛ Moisi sɩ: Awusɑ, n tɩɩ yɔɣɔtɑɑ kɛ́, mɑɑ tɑsǝɣɩ mǝlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Mpʋɣʋlɛ Tɑcɑɑ heelɑ Moisi sɩ: Pǝ kɑɑsɑ-m wɑhɑlɑ kɑntǝkɑɣɑ nyǝŋ. Pǝ wɑɑlɩ kɛ́ pɑɑ yele-mɛ nɑ ɩ́ tɛɛ. Hɑlɩ pɑɑ tɩɩ tɔɣɔnɩ-mɛɣɛ kʋtɔɣɔnʋ kɛ́ nɑ ɩ́ lɩɩ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Mpʋ tɔ heeli Ɩsɛɣɛlɩ nyǝ́mɑ ɑpɑlɑɑ nɑ ɑlɑɑ sɩ pɑ́ sǝlǝmɩ pɑ ɑsǝmɑɑ Icipiti nyǝ́mɑ kɛ wʋlɑ nɑ liɣitee nyǝɣǝtʋ pǝ wontu. ");
INSERT INTO dop_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ḿpʋ́ɣʋ́ Tɑcɑɑ lɑpɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ kpɑɣɑ Icipiti nyǝ́mɑ nɑ nyʋɣʋ. Pǝ́cɔ́ pǝlɛ pǝ pɑɑsi, Moisi mɑɣɑmɑɣɑ nyʋɣʋ kɑ kʋlɑɑ kɛ́, nɑ Icipiti wulɑʋ tǝmlɛ nyǝ́mɑ nɑ Icipiti yǝlɑɑ tǝnɑ tʋkɑɣɑnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moisi kɑ tɛmɑ Icipiti wulɑʋ kɛ heeluɣu sɩ Tɑcɑɑ tɔmɑ sɩ ɩ kɑ́ cɔɔ Icipiti tɛtʋ tɔɔ kɛ ɑhoo hɛkɑ ");
INSERT INTO dop_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","nɑ tɛtʋ tɑɑ kɑncɑɑlɑɣɑ piyɑ tǝnɑ kɑ́ sɩ. Pǝ kpɑɣɑʋ wulɑʋ nyɑ́, nyɑ́ pǝyɑɣɑ kɑncɑɑlɑɣɑ nyǝŋkɑ nɑ pǝ́ polo yom ɑlʋ nyǝŋ wei ɩ nɑŋǝɣɩ tɔ ɩ kɑncɑɑlɑɣɑ pǝyɑɣɑ, nɑ pǝ́ kpɛŋnɑ tɔlɑ nyǝnsɩ. ");
INSERT INTO dop_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Nɑ yǝlɑɑ kɑ wii lǝyɑɣɑ wulɑ wenɑ too nɔɣɔlʋ tɑ wiitɑ tɔ. Pǝyele nɔɣɔlʋ kɑɑ tɩɩ wii ɑ tɑkɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Amɑ pǝ kɑɑsʋɣʋ Ɩsɛɣɛlɩ nyǝ́mɑ hɔɣɔlʋɣʋ tɑɑ tɔ, hɑɣɑ mɑɣɑmɑɣɑ kɑɑ tɩɩ kpesi. Tǝnɑɣɑ ɩ́ kɑ́ nyǝnɑ sɩ Tɑcɑɑ mɑ́, mɑ fɑkɩ Icipiti nyǝ́mɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ɩlɛnɑ Moisi tɑsɑ sɩ: Wɑɑtʋ ɩnǝɣɩ Icipiti wulɑʋ tǝmlɛ nyǝ́mɑ pɑnɛ pɑ tǝnɑ pɑɑ kɔɔ nɑ pɑ́ luŋ mɑ tɛɛ kɛ́ ɑkulɑ sɩ mɑ́ nɑ mɑ yǝlɑɑ tǝ́ lɩɩ. Ɩlɛnɑ mɑ́ɑ́ lɩɩ kpɑkpɑɑ ɩnɩ. Pǝ wɑɑlɩ kɛ́ Moisi lɩɩnɑ pɑ́ɑ́nɑ́ sɔsɔɔnɑ kɛ Icipiti wulɑʋ tɛ. ");
INSERT INTO dop_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mpʋɣʋlɛ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu sɩ: Ye Icipiti wulɑʋ tɑ nɩɩnɑ-mɛ, ɩlɛ mɑɑ tɑsɑ kɔkɔlɔ nyǝm pɑɣɑlɛ lɑpʋ kɛ Icipiti tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Pǝyele Moisi nɑ Alɔŋ pɑɑ tɛmɑ-wǝɣɩ lɑpʋ kɛ tɔm pɑɣɑlɛ nɑ Icipiti wulɑʋ nɑ́. Pɑɑ nɑ mpʋ Ɩsɔ kɑ́ tʋ-ɩ lɑŋkpɩɩsǝŋ kɛ́, nɑ ɩ́ kisi sɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ tɑɑ lɩɩ. ");
INSERT INTO dop_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi nɑ Alɔŋ kɛ Icipiti tɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ɩsɔtʋ wei ɩ tɑɑ ɩ́ wɛ ɩsǝntɔ tɔ, ɩ kɑ́ wɛɛ-mɛɣɛ pǝnɑɣɑ tɑɑ ɩsɔtʋ kɑncɑɑlɑɣɑ nyǝŋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mpʋ tɔ, ɩ́ polo nɑ ɩ́ heeli Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ sɩ pɑɑ tǝyɑɣɑ yɑɑ pɑɑ wɑɑʋ ŋku kʋ́ cɑɑ ɩwǝyɑɣɑ yɑɑ pinɑɣɑ kɛ ɩsɔtʋ ɩnɛ ɩ kʋyɛɛŋ nɑɑnʋwɑ wule. ");
INSERT INTO dop_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ye wɑɑʋ nɑwɑ sɩ kʋ kɑɑ tɛ kpǝntɛ, ɩlɛ kʋ nɑ lɛŋkʋ pɑ kɑɑ nɑ pɑ́ nyɩ́ kpǝntɛ nte pɑɑ tɔɣɔ nɑ pɑ tɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ɩwǝyɑɣɑ yɑɑ pinɑɣɑ ŋkɑ pɑɑ cɑɑ tɔ, kɑɑ wɛɛ ɑpɑlʋ nyǝŋkɑ ŋkɑ kɑ sikɑ pǝnɑɣɑ kʋlʋmɑɣɑ tɔɣɔ, nɑ kɑ́ tewɑ, kɑ tiili tɑ́ cɑɑmɩ. ");
INSERT INTO dop_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nɑ pǝ́ tɑlɑ ɩsɔtʋ kʋyɛɛŋ nɑɑnʋwɑ nɑ liɣiti wule tɑɑnɑɣɑ, ɩlɛnɑ pɑɑ Ɩsɛɣɛlɩ tʋ wei ɩ́ lɛntɩ ɩ kpǝntɛ. ");
INSERT INTO dop_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ɩlɛnɑ pɑɑ mpɑ pɑ́ lii pɑ kpǝntɛ cɑlǝm nɑ pɑ́ tɑɑ tǝyɑɣɑ ŋkɑ kɑ tɑɑ pɑɑ tɔɣɔ tɔ kɑ nɔnɔkeelɑsɩ kɑmpʋ kpɑtǝŋ tɔɔ nɑ ɩsɔtɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","9","Pɑ wʋsǝɣɩ kpǝntɛ tǝnɑɣɑ. Pǝ kpɑɣɑʋ nyʋɣʋ nɑ nɔŋkpɑɑsɩ nɑ lotu tɔ. Pɑ́ tɑɑ tɔɣɔ-tɩ nɑ tǝ lɛŋ yɑɑ pɑ́ tǝsɩ-tɩ. Pɑ́ tɔɣɔ-tɩ nɑ potopotonɑɑ mpɑ pɑ tɑɑ kʋkʋsʋm fɛɩ tɔ, nɑ tuusi hɑtʋ nyɑŋ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ye pɑ tɔɣɑɑ nɑ pɑ́ kpisɑ mpi nɑ pǝ́ fe-wɩ pɑ wɔ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Wɑɑtʋ wei pɑ tɔkɩ pǝ tɔɣɔnɑɣɑ tɔ, nɑ pɑ́ suu pɑ mpɑɑʋ wontu kɛ́, nɑ pɑ ntɑŋkpɑlɑ kɛ pɑ nɔɔhɛɛ tɑɑ, nɑ pɑ kpɑtǝŋ kɛ pɑ niŋ tɑɑ, nɑ pɑ́ tɔɣɔ cɑʋcɑʋ. Mpi tɔ, pǝ kɛ́ Tɑcɑɑ Tɛɛʋ ɑcimɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ɩlɛnɑ Tɑcɑɑ tɑsɑ sɩ: Sɑŋɑ ɑhoo ɑnɛɣɛ mɑɑ cɔɔ Icipiti tɛtʋ tɔɔ nɑ mɑ́ kʋ́ tǝ kɑncɑɑlɑɣɑ piyɑ tǝnɑ. Pǝ kpɑɣɑʋ yǝlɑɑ piyɑ nɑ pǝ́ polo tɔlɑ nyǝŋsɩ tɔ. Pǝyele mɑɑ kʋ́ Icipiti nyǝ́mɑ tɩɩŋ tǝnɑ nyɔɔŋ tǝnɑŋnɑŋ. Ɩlɛnɑ pɑɑ wei ɩ́ nyɩ́ sɩ mɑ́ kɛnɑ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Pǝ kɑɑsʋɣʋ Ɩsɛɣɛlɩ nyǝ́mɑ mɛ tɔ, mǝ kɑmpʋnɑɑ tɔɔ cɑlǝm kɑ́ yʋsǝnɑ mǝ tɛɛsɩ. Ye mɑ nɑ-wɩ mɑ tɛɛ mǝ tɔɔ. Ɩsǝnɑ mɑɑ kenti mǝ tɔɔ nɑ mɑ kɑɑ wɑkǝlɩ-mɛ ɩsɩɩ Icipiti nyǝ́mɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑɑ sɩ: Ɩ́ kɑ tɔɔsǝɣɩ kʋyɑkʋ kʋnɛ kʋ tɔɔ kɛ́ pɑɑ pǝnɑɣɑ ŋkɑɣɑ, nɑ ɩ́ lɑkɩ-m ɑcimɑ sɔsɔɔnɑ nɑ ɩ nyǝnɩ-yɛɣɛ kɔtɑɣɑ kɛ mǝ wɑɑlɩ nyǝ́mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ tǝcu kɛ́ ɩ́ kɑ́ tɔɣɔ potopotonɑɑ mpɑ pɑ tɑɑ kʋkʋsʋm fɛɩ tɔ pǝ ɑcimɑ. Mpʋ tɔ, pǝ kpɑɣɑ kʋkʋsʋm fɛɩ potopotonɑɑ ɑcimɑ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ wule tɔ, pǝ fɛɩ sɩ kʋkʋsʋm ɩ́ wɛɛ mǝ tɑɑ nɔɣɔlʋ tǝyɑɣɑ tɑɑ. Ye nɔɣɔlʋ tɔɣɔ-wǝɣɩ kʋyɛɛŋ ɩnɩ ɩ tɑɑ, ɩsɩɩ pɑ kpiisɑ pʋntʋ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ɩ́ kɑ́ koti kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ nɑ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule kɛ́ nɑ ɩ́ sɛɛ-m. Kʋyɑŋku tɔ, pǝ fɛɩ sɩ ɩ́ lɑ tǝmlɛ nɑtǝlɩ. Ye pǝ tɑɣɑ mǝ tɔɣɔnɑsɩ sɑɑʋ pɑɑsi. ");
INSERT INTO dop_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Pɑɑ pǝnɑɣɑ ŋkɑɣɑ ɩ kɑ tɔkɩ kʋkʋsʋm fɛɩ potopotonɑɑ ɑcimɑ ɑnɛɣɛ mǝ wɑɑlɩ nyǝ́mɑ tɔɔ. Nɑ ɑ́ pǝsɩ-mɛɣɛ kɔtɑɣɑ ŋkɑ kɑɑ tɔɔsɩ-mɛɣɛ kʋyɑŋku mɑ lǝsɑ-mɛɣɛ Icipiti tɛtʋ tɑɑ kɛ nɔɣɔ kʋlʋmɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ɩ́ kɑ́ tɔkɩ kʋkʋsʋm fɛɩ potopotonɑɑ kɛ ɩsɔtʋ kɑncɑɑlɑɣɑ nyǝŋ ɩnɩ ɩ kʋyɑkʋ nɑɑnʋwɑ nɑ liɣiti nyǝŋkʋ wule tɑɑnɑɣɑ, nɑ pǝ́ polo kʋyɑkʋ hiu nɑ kʋlʋmʋɣʋ wule tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Ye pǝ tɑlɑ wɑɑtʋ ɩnɩ pǝ fɛɩ sɩ mǝ tɑɑ nɔɣɔlʋ ɩ́ tɔɣɔ kʋkʋsʋm tɔɣɔnɑɣɑ, yɑɑ pǝ́ tɩɩ wɛɛ pʋntʋ tǝyɑɣɑ tɑɑ. Pɑɑ Ɩsɛɣɛlɩ tʋ yɑɑ cɑɣɑlʋ, ɩsɩɩ pɑ kpiisɑ-ɩ mǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","22","Ḿpʋ́ɣʋ́ Moisi kotɑ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ nɑ ɩ́ heeli-wɛ sɩ: Ɩ́ polo ɩ́ cɑɑ Tɛɛʋ ɑcimɑ ɩwɛɛsɩ, yɑɑ pinɑsɩ nɑ ɩ́ lɛntɩ-sɩ nɑ ɩ́ tiɣisi cɑlǝm nɑ ɩ́ lii pǝ tɑɑ kɛ́ sɑŋ nɑ ɩ́ tɑɑ nɔnɔɣɔ kɑmpʋ kpɑtǝŋ tɔɔ nɑ ɩsɔtɑɑ tɔɔ. Ye pǝ tɛmɑ mpʋ, nɔɣɔlʋ ɩ́ tɑɑ tɑsɑ tǝyɑɣɑ ŋkɛ kɑ tɑɑ kɛ́ lɩɩʋ sɩ ɩ puki tiili, hɑlǝnɑ pǝ́ nyɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mpi pǝ tɔɔ tɔ, Tɑcɑɑ kɑ cɔɔ Icipiti nyǝ́mɑ wɑkǝlʋɣʋ. Ɩlɛ ye ɩ nɑwɑ cɑlǝm kɛ mǝ tɛɛsɩ kɑmpʋnɑɑ kpɑtǝŋ tɔɔ, ɩ kɑɑ yele sɩ wɑkǝllʋ ɩ́ sʋʋ sɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Mǝ nɑ mǝ wɑɑlɩ nyǝ́mɑ ɩ́ kɑ́ tɔ́kǝnɑ kɔtɑɣɑ kɑnɛɣɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Pɑɑ wɑɑtʋ wei ɩ́ kɑ́ sʋʋ tɛtʋ nti Tɑcɑɑ hɑ-mɛ tɔ tǝ tɑɑ tɔ, ɩ́ kɑ́ tɔ́kɩ-kɛɣɛ ḿpʋ́ɣʋ́. ");
INSERT INTO dop_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ye mǝ piyɑ ɩ́ pɔɔsɑ-mɛ sɩ pǝ nyʋɣʋ suwe, ɩlɛ ");
INSERT INTO dop_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ɩ́ kɑ́ cɔ-wɛ sɩ: Tɑcɑɑ Tɛɛʋ ɑcimɑ kɔtɑɣɑ ntɛ́. Ɩsɛɣɛlɩ nyǝ́mɑ tɑ́, tɩɩ wɛʋ Icipiti tɑɑ tɔɣɔ kʋyɑkʋ nɑkʋlɩ Ɩsɔ cɔɔ pɑ tɛtʋ tɑɑ nɑ ɩ́ wɑkǝlɩ-wɛ. Amɑ ɩ tɛɛ tɑ́ tɔɔ nɑ ɩ́ wɑɑsɩ-tʋ. Ɩsɛɣɛlɩ nyǝ́mɑ nɩɩ mpʋ, ɩlɛnɑ pɑ́ luŋ nɑ pɑ́ sɛɛ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Pɑ tɛmɑ mpʋ, ɩlɛnɑ pɑ́ tɛɛ nɑ pɑ́ niki nti Tɑcɑɑ kɑ heelɑ Moisi nɑ Alɔŋ tɔɣɔ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Pǝ kɔmɑ ɩsɩɩ ɑhoo hɛkɑ ɩlɛnɑ Ɩsɔ Tɑcɑɑ kʋ Icipiti tɑɑ ɑpɑlʋpiyɑ kɑncɑɑlɑɣɑ nyǝnsɩ tǝnɑ. Hɑlǝnɑ pǝ́ kpɛŋnɑ Icipiti wulɑʋ sɔsɔ ɑpɑlʋpǝyɑɣɑ kɑncɑɑlɑɣɑ nyǝŋkɑ ŋkɑ kɑɑ lɛɛtɩ ɩ kɑwulɑɣɑ kumte tɔɔ tɔ. Nɑ pǝ́ polo sɑlǝkɑ nyǝ́mɑ ɑpɑlʋpiyɑ kɑncɑɑlɑɣɑ nyǝnsɩ, nɑ tɔlɑ kɑncɑɑlɑɣɑ piyɑ ɑpɑlʋ nyǝnsɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ahoo ɑnɩ tɔ, Icipiti wulɑʋ nɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ Icipiti nyǝ́mɑ tǝnɑ femɑɣɑ nɑ pɑ́ cɑsǝɣɩ kɑpusi. Mpi tɔ, tǝyɑɣɑ fɛɩ nɑ kɑ tɑɑ lɑŋɑ sǝtʋ. ");
INSERT INTO dop_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tǝnɑɣɑ wulɑʋ yɑɑ Moisi nɑ Alɔŋ kɛ ɑhoo ɑnɩ nɑ ɩ́ tɔ-wɛ sɩ: Mǝ nɑ mǝ Ɩsɛɣɛlɩ yǝlɑɑ tǝnɑ ɩ́ lɩɩ lɔŋ kɛ mɑ tɛtʋ tɑɑ nɑ ɩ́ tɛɛ. Ɩ́ polo nɑ ɩ́ sɛɛ Tɑcɑɑ ɩsɩɩ ɩ́ kɑ sǝlǝmʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Pɑɑ mǝ tɔlɑ ɩ́ kpɑɣɑ pǝ tǝnɑ ɩsɩɩ ɩ́ kɑ yɔɣɔtʋɣʋ tɔ nɑ ɩ́ tɛɛ ɩ́ fɛɛ-m. Amɑ ɩ́ sǝlǝmɩ mǝ Ɩsɔ kɛ́ sɩ ɩ́ koolu-m kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Icipiti nyǝ́mɑ kɑ tɛmɑ pɑ tɑɑ kɛ́ sɩ pɑ tǝnɑ pɑɑ sǝnɑ. Ntɛnɑ pɑ́ tuli Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kʋtulu sɩ: Ɩ́ lɩɩ lɔŋ kɛ tɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Pǝ mɑɣɑmɑɣɑ pǝ tɔɔ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ kpɛŋnɑ pɑ potopotonɑɑ somtu nɑ tǝ́ tɑ nyǝŋtɑ nɑ pɑ́ hɔkɔ tɑɣɑlǝŋ wei ɩ tɑɑ pɑ huɣutiɣi-wɛ tɔɣɔ pɑ kpɑɩnɑɑ tɑɑ, nɑ pɑ́ sǝɣǝlɩ nɑ pɑ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ lɑpɑ teitei ɩsɩɩ Moisi kɑ heeluɣu-wɛ tɔ. Pɑ sǝlǝmɑ Icipiti nyǝ́mɑ kɛ wontu nti pɑ lupinɑ wʋlɑ nɑ liɣitee nyǝɣǝtʋ tɔ, nɑ wontu kususuutu. ");
INSERT INTO dop_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ḿpʋ́ɣʋ́ Tɑcɑɑ lɑpɑ nɑ pɑ nyʋɣʋ tenɑ Icipiti nyǝ́mɑ nɑ pɛlɛ pɑ́ cɛlɛ-wɛɣɛ mpi mpi pɑɑ sǝlǝmɑ-wɛ tɔ. Timpi Ɩsɛɣɛlɩ nyǝ́mɑ kuunɑ Icipiti nyǝ́mɑ wɛnɑʋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Ɩsɛɣɛlɩ nyǝ́mɑ kʋlɑ Lɑmsɛsɩ, ɩlɛnɑ pɑ́ tɛɛ Sukɔtɩ, nɑ pɑ tɑɑ ɑpɑlɑɑ kɑ wɛ ɩsɩɩ yǝlɑɑ iyisi nɑsǝtoso (600000) kɛ mpʋ. Alɑɑ nɑ kʋkpɑtǝlɑɑ nɑ piyɑ pɑɑsi. ");
INSERT INTO dop_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Pɑ lɩɩʋ mpʋ tɔ pǝ kpɛŋnɑ yǝlɑɑ mpɑ pɑ tɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɣɔ tuutuumɑ kɛ́ nɑ pɑ́ tǝŋ-wɛ. Pǝ kɑɑsɩ heeŋ nɑ pǝ́ŋ nɑ nɑɑŋ kɑlǝkǝŋ tɑɑ fɛɩ nyǝnʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pɑ lɩɩ mpɑɑʋ ɩlɛnɑ pɑ́ tʋ́ pɛtɛpɛtɑsɩ kɛ pɑ somtu nti pɑɑ kpɑɣɑnɑ Icipiti nɑ tǝ́ tɑ kpɑtɑ tɔ. Mpi tɔ, Icipiti nyǝ́mɑ kɑ tɔɣɔnɑ-wɛɣɛ kʋtɔɣɔnʋ kɛ́. Pɑ tɑɑ yele sɩ pɑ somtu ɩ́ kpɑ. Pǝyele pɑ tɑɑ kpɑɣɑ mpɑɑʋ tɔɣɔnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Pɩɩsɩ nɑsǝlɛ nɑ hiu nɑ nɑɑnʋwɑ (430) kɛ Ɩsɛɣɛlɩ nyǝ́mɑ cɑɣɑ Icipiti tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Pǝ wɑɑlɩ kɛ́ pɑ lɩɩwɑ nɔɣɔ kʋlʋmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Teitei ɩsɩɩ Tɑcɑɑ keeluɣu ɩ tom kɛ ɑhoo ɑnɩ nɑ ɩ́ lǝsɩ-wɛ tɔ. Mpʋ tɔtɔɣɔ mpɛ nɑ pɑ lʋlʋŋ pɑɑ keeliɣi pɑ tom kɛ ɩ tɔɔ kɛ́ tɑm kɛ́ pɑɑ pǝnɑɣɑ ŋkɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi nɑ Alɔŋ sɩ: Tɛɛʋ ɑcimɑ kʋsǝsɩɩtʋ ntɔ, pǝ fɛɩ sɩ cɑɣɑlʋ wei ɩ tɑ kɛ Ɩsɛɣɛlɩ tʋ tɔ ɩ́ tɔɣɔ Tɛɛʋ ɑcimɑ tɔɣɔnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ye ɩsɩɩ Ɩsɛɣɛlɩ tʋ yɑpɑ piitim lɛmpɩ tʋ kɛ yom nɑ ɩ́ pɛlɩ-ɩ ɩ pǝsǝɣɩ nɑ ɩ́ tɔɣɔ pǝ tɔɣɔnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Pǝ fɛɩ sɩ piitim lɛmpɩ mʋʋlʋ yɑɑ ɑpɑɑ tʋ ɩ́ tɔɣɔ pǝ tɔɣɔnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Pǝ kɑɑsɩ ɩlɛ, tǝyɑɣɑ ŋkɑ kɑ tɑɑ pɑ wʋsɑ nɑntʋ ntɩ tɔɣɔ pɑɑ tɔɣɔ-tɩ, pɑ kɑɑ lɩɩnɑ-tǝɣɩ ɑwɑlɩ. Pǝyele pǝ fɛɩ sɩ pɑ́ yɔkɩ kpǝntɛ nte pɑ kʋwɑ mpʋ tɔ tǝ mʋwɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Pǝ wɛɛ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tǝpɑɩ kɑ́ tɔɣɔnɑ Tɛɛʋ ɑcimɑ ɑnɩ. ");
INSERT INTO dop_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ye ɩsɩɩ cɑɣɑlʋ nyɩɩlǝnɑ sɩ ɩ kɑ tɔɣɔ Tɑcɑɑ Tɛɛʋ ɑcimɑ ɑnɩ, pǝ wɛɛ kɛ́ sɩ pɑ́ pɛlɩ ɩ́ nɑ ɩ tǝyɑɣɑ tɑɑ ɑpɑlʋpiyɑ tǝnɑ nɑ pǝ́cɔ́. Ɩlɛ ɩ pǝsɑ ɩsɩɩ Ɩsɛɣɛlɩ tʋ ntɛ́, ɩ pǝsǝɣɩ nɑ ɩ́ tɔɣɔ-ɩ. Tɔfɔ ye pɑ tɑ pɛlɩ wei, pǝ fɛɩ sɩ ɩ́ kpǝtǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ɩsɛɣɛlɩ tʋ ɩ́ tɑ pɛlɩ, ɩ́ nɑ cɑɣɑlʋ pɑ kiiu kʋlʋmʋɣʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ lɑpɑ teitei ɩsɩɩ Tɑcɑɑ kɑ heeluɣu Moisi nɑ Alɔŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Kʋyɑkʋ ŋkʋ kʋ mɑɣɑmɑɣɑ kɛ Tɑcɑɑ lǝsɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Icipiti tɑɑ kɛ́ nɔɣɔ kʋlʋmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ yɑ́ɑ́ Moisi nɑ ɩ́ tɔmɩ-ɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Ɩsɛɣɛlɩ tɑɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ tǝnɑ kɛ́ mɑ nyǝnsɩ kɛ́. Pǝ kpɑɣɑʋ yǝlɑɑ piyɑ nɑ pǝ́ polo tɔlɑ nyǝnsɩ tɔ, mɑ́ tǝnnɑ-sɩ. Ɩ́ nyǝnǝɣɩ-sǝɣɩ mɑ nyǝm. ");
INSERT INTO dop_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ntɛnɑ Moisi heeli sɑmɑɑ sɩ: Pǝ fɛɩ sɩ ɩ́ sɔɔ kʋyɑkʋ kʋnɛ ɩnɩ kʋ tɔɔ yoo. Mpi tɔ, kʋ wule kɛ Tɑcɑɑ lǝsɑ-tʋ nɑ toŋ sɔsɔɔŋ kɛ tɑ́ yomle tɑɑ kɛ́ Icipiti tɛtʋ tɑɑ. Mpʋ tɔ, ye ɩ́ tɔɔsǝɣɩ kʋyɑkʋ kʋnɛ ɩnɩ kʋ tɔɔ ɩ́ tɑɑ tɔɣɔ potopoto wei ɩ tɑɑ wɛ kʋkʋsʋm tɔ. ");
INSERT INTO dop_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ɩsɔtʋ wei pɑ yɑɑ sɩ Apiipi tɔ, ɩ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ wule kɛ ɩ́ lɩɩwɑ. ");
INSERT INTO dop_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Wɑɑtʋ wei ɩ́ kɑ́ sʋʋ Kɑnɑɑŋ, nɑ Hiti, nɑ Amolii, nɑ Hifi, nɑ Yepusi pǝ nyǝ́mɑ tɛtʋ nti tǝ tɑɑ tɔɣɔnɑɣɑ tɔlɑ tǝhɔ tɔ. Tɛtʋ ntǝɣɩ Tɑcɑɑ kɑ yɔɣɔtǝnɑ tuunɑʋ sɩ ɩ kɑ́ hɑ mǝnɑ mǝ cɑɑnɑɑ. Ɩlɛ pɑɑ pǝnɑɣɑ ŋkɑɣɑ ɩ́ kɑ́ tɔkɩ Tɛɛʋ ɑcimɑ kɛ ɩsɔtʋ ɩnɛ ɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ kɛ ɩ́ kɑ́ tɔɣɔ kʋkʋsʋm fɛɩ potopotonɑɑ. Nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule ɩlɛnɑ ɩ́ sɛɛ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Pǝ fɛɩ sɩ pɑ́ tɩɩ keesi kʋkʋsʋm kɛ mǝ tɑɑ nɔɣɔlʋ ɩ tɛɣɛ kʋyɛɛŋ ɩnɩ ɩ tɑɑ kɛ́ mǝ tɛtʋ tǝnɑ tɑɑ. Hɑlɩ ḿpʋ́ɣʋ́ pɩɩ lɑ pǝ potopoto. ");
INSERT INTO dop_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ye ɩ́ kɔmɑ nɑ ɩ́ tɔkɩ ɑcimɑ ɑnɩ, ɩ́ kɛɛsɩ mǝ piyɑ sɩ mpi Tɑcɑɑ lɑpɑ-mɛɣɛ kʋyɑŋku ɩ́ lɩɩ Icipiti tɔ, pǝ tɔɔ kɛ́ ɩ́ tɔkɩ-yɛ. ");
INSERT INTO dop_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ɩ́ kɑ́ tɔkɩ Tɛɛʋ ɑcimɑ ɑnǝɣɩ sɩ pǝ́ tɔɔsǝɣɩ-mɛɣɛ kʋyɑkʋ kʋnɛ ɩnɩ kʋ tɔɔ kɛ́ teitei ɩsɩɩ kʋyʋsʋm mpi ɩ́ teŋ mǝ tokuŋ nɑ ɩ́ tɑmsǝɣɩ mǝ ŋkpɑlɑsɩ tɑɑ, sɩ pǝ́ tɔɔsǝɣɩ-mɛ, nɑ ɩ́ kɑlǝɣɩ Tɑcɑɑ kʋsǝsɩɩtʋ kɛ tɑm nɑ ɩ́ nyɩ-tɩ tɔ. Tɛɛʋ ɑcimɑ tɔɣɔʋ mpɩ pɩɩ tɔɔsǝɣǝnɑ-mɛ sɩ Tɑcɑɑ lǝsǝnɑ-mɛɣɛ Icipiti tɑɑ nɑ ɩ toŋ sɔsɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Pɑɑ pǝnɑɣɑ ŋkɑ, ye pǝ ɩsɔtʋ ɩ́ lɩɩwɑ, ɩ́ lɑkɩ nti ɩnɩ mɑ tʋ-mɛɣɛ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ḿpʋ́ɣʋ́ Moisi tɑsɑɑ tɔtɔ sɩ: Ye pǝ kɔmɑ nɑ Tɑcɑɑ tɑnɑ-tʋɣʋ Kɑnɑɑŋ tɛtʋ nti ɩ kɑ yɔɣɔtǝnɑ tuunɑʋ sɩ ɩ kɑ́ hɑ tɑ́ nɑ tɑ́ cɑɑnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Ɩlɛ tɩɩ hɑ-ɩ ɑpɑlʋpiyɑ kɑncɑɑlɑɣɑ nyǝnsɩ tǝnɑ. Pɑɑ tɔlɑ kɑncɑɑlɑɣɑ piyɑ ɑpɑlʋ nyǝnsɩ tǝnɑ, ɩnɩ ɩ tǝnnɑ-sɩ. ");
INSERT INTO dop_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ye kpɑŋɑɣɑ kɑncɑɑlɑɣɑ pǝyɑɣɑ ɑpɑlʋnyǝŋkɑ, ɩlɛ ɩ́ lɑɣɑsɩ-kɛ nɑ ɩwǝyɑɣɑ yɑɑ pinɑɣɑ, yɑɑ ɩ́ mǝlǝntɩ kɑ luɣu nɑ kɑ́ sɩ. Ye pǝ kɑɑsɑ yʋlʋ kɑncɑɑlɑɣɑ pǝyɑɣɑ ɑpɑlʋnyǝŋkɑ ɩlɛ ɩ́ lɑɣɑsɩ-kɛ nɑ ɩwǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ye kʋyɑkʋ nɑkʋlɩ mǝ piyɑ pɔɔsɑ-mɛ sɩ pepe tɔɔ kɛ́ ɩ́ lɑkɩ mpʋ. Ɩlɛ ɩ cɔ-wɛ sɩ: Tɩɩ wɛ ɩsɩɩ yomɑɑ kɛ Icipiti kɛ́, ɩlɛnɑ Ɩsɔ lǝsɩ-tʋ nɑ ɩ toŋ sɔsɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Hɑlɩ pǝ tɔm tɑɑ, Icipiti wulɑʋ kisɑɑ kɛ́ tǝsɑɣɑsɑɣɑ sɩ tǝ́ tɑɑ nyǝɣǝlǝnɑ tiili. Ɩlɛnɑ Ɩsɔ nɑ́ɑ́ kʋ́ Icipiti nyǝ́mɑ ɑpɑlʋpiyɑ kɑncɑɑlɑɣɑ nyǝnsɩ tǝnɑ, nɑ pǝ́ kpɛnnɑ tɔlɑ nyǝnsɩ tǝnɑ. Pǝ tɔɔ mɑɣɑmɑɣɑ kɛ pǝ wɛɛ sɩ tǝ́ lɑkɩ kɔtɑsɩ kɛ kɑncɑɑlɑɣɑ piyɑ ɑpɑlʋ nyǝnsɩ tǝnɑ. Amɑ ye yǝlɑɑ nyǝnsɩ ɩlɛ, tɔlɑ kɛ tǝ lɑɣɑsǝɣǝnɑ. ");
INSERT INTO dop_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Kɔtɑsɩ nsɩ sɩɩ tɔɔsǝɣǝnɑ-tʋɣʋ nti ɩnɩ Tɑcɑɑ tʋ-tʋɣʋ ɩsǝntɔ tɔɣɔ teitei ɩsɩɩ kʋyʋsʋm mpi tɩɩ teŋ tɑ́ tokuŋ nɑ tǝ́ tɑmsǝɣɩ tɑ́ ŋkpɑlɑsɩ tɑɑ tɔ. Pǝ tǝnɑɣɑ mpʋ pɩɩ tɔɔsǝɣǝnɑ-tʋ sɩ Tɑcɑɑ lǝsǝnɑ-tʋɣʋ Icipiti tɑɑ nɑ ɩ toŋ sɔsɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Wɑɑtʋ wei Icipiti wulɑʋ yelɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ tʋ mpɑɑʋ tɔ, Ɩsɔ tɑ́ tisi sɩ pɑ́ tǝŋ Metitelɑnee teŋku mpɑɑʋ, nɑ pɑ́ fɑɣɑnɑ Filiisi nyǝ́mɑ tɛtʋ tɑɑ. Pɑɑ nɑ kɩɩ topilɑɑ tɔ. Ɩ lɑpɑ ḿpʋ́ɣʋ́ sɩ pǝ́ tɑɑ kɔɔ nɑ Filiisi nyǝ́mɑ lɩɩ pɑ tɔɔ nɑ sɔɣɔntʋ kpɑ-wɛ nɑ pɑ́ cʋkɩ pɑ tɑɑ nɑ pɑ́ mǝlɩ Icipiti. ");
INSERT INTO dop_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Pǝ tɔɔ kɛ́ Ɩsɔ yelɑɑ nɑ pɑ́ kɛɛ nɑ pɑ́ fɑɣɑnɑ wʋlɑɣɑ tɛtʋ tɑɑ nɑ pɑ́ polo pɑ́ lɩɩ sǝsǝncɑɑsɩ teŋku. Ɩsɛɣɛlɩ nyǝ́mɑ mpɛ pɑ tɑ lɩɩ yem yem. Pɑ lɩɩ nɔɣɔ kʋlʋmɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Pɑ lɩɩkɑɣɑ mpʋ ɩlɛnɑ Moisi kuu Yosɛɛfʋ mʋwɑ nɑ ɩ́ kpɛnnɑ. Mpi tɔ, ɩ kɑ heelɑ ɩ tɛɛtʋnɑɑ kɛ́ nɑ ɩsǝlɛ kʋsɛɛmlɛ sɩ Ɩsɔ ɩ́ lǝsɑ-wɛɣɛ Icipiti tɑɑ pɑ́ kpɛnnɑ ɩ mʋwɑ. ");
INSERT INTO dop_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩ Sukɔtɩ nɑ pɑ́ polo Ɩtɑm kɛ wʋlɑɣɑ tɛtʋ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ Ɩsɔ yɑɑ Moisi nɑ cokǝle nte pɑ lɑpǝnɑ pɔɔŋ, nɑ Ɩsɔ nɑ ɩ yǝlɑɑ pɑ́ suliɣi tǝ tɑɑ tɔ. Ɩlɛnɑ ɩ́ tɔmɩ-ɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, ye pɑ tɑɑ nɔɣɔlʋ cɑɑ-m kʋhɑʋ kɛ kɔnɑʋ, ɩ pǝsǝɣɩ nɑ ɩ́ kɔnɑ nɑʋ yɑɑ heu yɑɑ pǝ́ŋ́. ");
INSERT INTO dop_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ye nɑʋ kɛ yʋlʋ cɑɑ lɑpʋ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Ɩlɛ ɑpɑlʋ nyǝŋ wei ɩ tiili tɑ́ cɑɑmɩ tɔɣɔ ɩ kɑ́ hɑ nɑ Tɑcɑɑ mʋ. Cokǝle nte tǝ tɑɑ Ɩsɔ nɑ yǝlɑɑ pɑ suliɣi tɔ tǝ nɔnɔɣɔ kɛ ɩ kɑ́ ponɑ. ");
INSERT INTO dop_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ɩlɛnɑ ɩ́ tǝnɩ ɩ niŋ kɛ kpǝntɛ nte kɔkɔ lusiɣi mpʋ tɔ tǝ nyʋɣʋ tɔɔ. Tɑcɑɑ kɑ mʋ ɩ kɔtɑɣɑ nɑ ɩ́ hɩɩsɩ ɩ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ɩlɛnɑ pʋntʋ lɛntɩ kpǝntɛ kɛ tǝsulle cokǝle kiŋ tǝnɑ. Alɔŋ lʋlʋɣʋ nyǝ́mɑ kɔtǝlɑɑ tɑɑ nɔɣɔlʋ kɑ́ hʋlɩ kpǝntɛ cɑlǝm kɛ Tɑcɑɑ. Ɩlɛnɑ ɩ́ ŋmɩɩsɩ-wǝɣɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ kɛ́ cokǝle nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Sɑɑ wei kɔtɑɣɑ lɑtʋ litiɣi kpǝntɛ nɑ ɩ́ fɑkɩ-tɛɣɛ piliŋɑsɩ ");
INSERT INTO dop_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","tɔɣɔ kɔtǝlɑɑ nɑ́ tɑɣɑnǝɣɩ kɔkɔ kɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ɩlɛnɑ pɑ́ tǝnɩ nɑntʋ cǝkǝŋ kɛ kɔkɔ tɔɔ tǝtetete, nɑ nyʋɣʋ nɑ nim cɔlɔ nim cɔlɔ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Kpǝntɛ lotu nɑ tǝ nɔŋkpɑɑsɩ tɛŋ nyɑɑlʋɣʋ, ɩlɛnɑ kɔtʋlʋ nyɑɣɑsɩ pǝ tǝnɑɣɑ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔlɛ. Kɑ sɔɔsʋŋ kɛ Tɑcɑɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Ye ɩsɩɩ heu yɑɑ pǝ́ŋ kɛ yʋlʋ cɑɑkɩ lɑpʋ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Ɩlɛ ɑpɑlʋnyǝŋ wei ɩ tiili tɑ́ cɑɑmɩ tɔɣɔ ɩ kɑ́ kɔnɑ. ");
INSERT INTO dop_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ɩlɛnɑ ɩ́ lɛntɩ-ɩ Ɩsɔ cokǝle kɔŋkɔŋ tɑɑ, kɛ kɔtɑɣɑ tǝlɑtɛ ilim ntɔɣɔŋ tɔɔ. Ɩlɛnɑ Alɔŋ lʋlʋɣʋ nyǝ́mɑ kɔtǝlɑɑ tɑɑ nɔɣɔlʋ ŋmɩɩsɩ cɑlǝm kɛ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ɩlɛnɑ kɔtɑɣɑ lɑtʋ fɑɣɑ nɑntʋ kɛ tilimɑ. Nɑ ɩ́ sɛtɩ nyʋɣʋ, nɑ ɩ́ lǝsɩ nim cɔlɔ nim cɔlɔ. Ɩlɛnɑ kɔtʋlʋ tǝnɩ nɑntʋ ntǝɣɩ kɔtɑɣɑ tǝlɑtɛ kɔkɔ ŋkɛ kɑ tɔɔ tǝtetete. ");
INSERT INTO dop_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Kpǝntɛ lotu nɑ tǝ nɔŋkpɑɑsɩ tɛŋ nyɑɑlʋɣʋ, ɩlɛnɑ kɔtʋlʋ hʋlɩ kɔtɑɣɑ ŋkɛɣɛ Tɑcɑɑ, nɑ ɩ́ nyɑɣɑsɩ pǝ tǝnɑɣɑ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔlɛ. Kɑ sɔɔsʋŋ kɛ Tɑcɑɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Ye sumɑɣɑ kɛ yʋlʋ cɑɑkɩ lɑpʋ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, ɩhokɑɣɑ yɑɑ ɑlukuku kɛ ɩ kɑ́ kɔnɑ. ");
INSERT INTO dop_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Ɩlɛnɑ kɔtʋlʋ ponɑ sumɑɣɑ ŋkɛɣɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kiŋ, nɑ ɩ́ cɛ kɑ nyʋɣʋ nɑ ɩ́ nyɑɣɑsɩ-kʋɣʋ kɔtɑɣɑ kɔkɔ tɑɑ. Ɩlɛnɑ ɩ́ nyɑɑsɩ ɑlukuku cɑlǝm nɑ ɩ́ tɑɑnɑ-wǝɣɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Ɩlɛnɑ ɩ́ lǝsɩ luɣuticɛcɛkʋ nɑ kʋ tɔɣɔnɑɣɑ, nɑ ɩ́ pɛtɩ-kʋɣʋ tɔlʋmɑ nim nyǝnɑ tǝlɔlɛ, kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔŋ tɑɑ, nɑ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ɩlɛnɑ ɩ́ tɔkɩ ɑlukuku keŋ tɑɑ nɑ ɩ́ hɔ nɑ ɩ́ cǝlɩ. Ɩlɛ pǝ tɑɑ yɑɑlɩ. Ɩlɛnɑ ɩ́ nyɑɣɑsɩ-ɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔkɔ tɑɑ. Kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔlɛ. Kɑ sɔɔsʋŋ kɛ Tɑcɑɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Ye ɩsɩɩ yʋlʋ cɑɑ ɩ kɔnɑ Tɑcɑɑ kɛ tɔɣɔnɑɣɑ kʋhɑʋ, mʋlʋm kʋpɑm kɛ ɩ cɑɑkɩ. Ɩ pǝlǝɣɩ pǝ tɔɔ kɛ́ nim, nɑ ɩ́ tǝnɩ tulɑɑlʋ. ");
INSERT INTO dop_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Ɩlɛnɑ ɩ́ ponɑ Alɔŋ lʋlʋɣʋ nyǝ́mɑ kɔtǝlɑɑ. Pɑ tɑɑ nɔɣɔlʋ cosiɣi nim mʋlʋm mpǝɣɩ ŋkute nɑ ɩ́ nyɑɣɑsɩ pǝ nɑ tulɑɑlʋ tǝnɑɣɑ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Mpɩ pǝ kɛnɑ kʋtɔɔsǝm sɩ Tɑcɑɑ tǝnnɑ pǝ tǝnɑ. Kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔlɛ. Kɑ sɔɔsʋŋ kɛ Tɑcɑɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Kʋhɑʋ ŋkʋ kʋ kɑkɑɑsɑɣɑ pǝsǝɣɩ kɔtǝlɑɑ nyǝm kɛ́. Mpi tɔ, pǝ kɛ́ kɑtɛ tɑɑ kɑtɛ pʋlʋpʋɣʋ. Pǝ tɑɣɑ pʋlʋ, pǝ kɛ́ kɔtɑɣɑ ŋkɑ pɑ lɑpɑ Tɑcɑɑ tɔ, kɑ kɑkɑɑsɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Ye pǝ kɛ́ ɩsɩɩ potopotonɑɑ looŋɑ tɑɑ kʋkʋsʋm fɛɩ tɔɣɔnɑɣɑ nɑkǝlɩ, ɩlɛ pɑ cɑɑ mʋlʋm kʋpɑm nɑ pɑ́ nuɣutinɑ nim, nɑ pɑ́ tʋ kɑkɑlɑsɩ yɑɑ pɛtɛpɛtɑsɩ tɑkɑ, nsi sɩ tɔɔ pɑ yɔɣɔlɑ nim tɔ. ");
INSERT INTO dop_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ye ɩsɩɩ pɛtɛpɛtɑɣɑ mɑɣɑmɑɣɑ, ŋkɑ pɑ tʋɣɩ nyǝɣǝlʋɣʋ kʋwɑlʋɣʋ tɔɔ tɔ. Ɩlɛ mʋlʋm mpi pɑ nuɣutinɑ nim, nɑ pǝ tɑɑ fɛɩ kʋkʋsʋm tɔɣɔlɛ pɑ tʋɣɩ. ");
INSERT INTO dop_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Pɑ pʋtʋtǝɣɩ pɛtɛpɛtɑɣɑ ŋkɛ, ɩlɛnɑ pɑ́ sɔɔsɩ pǝ tɑɑ kɛ́ nim tɔtɔ. Ḿpʋ́ɣʋ́ pǝ wɛɛ sɩ, pɑ́ lɑ tɔɣɔnɑɣɑ kʋhɑʋ tɔm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ye ɩsɩɩ tɔɣɔnɑɣɑ ŋkɑ pɑ toŋɑɑ tɔ kɑ kʋhɑʋ ɩlɛ, mʋlʋm mpi pɑ nuɣutinɑ nim tɔɣɔlɛ pɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Pɑ tɑɣɑnǝɣɩ-kɛɣɛ, ɩsɩɩ pɑ kɛɛsʋɣʋ tɔ. Ɩlɛnɑ pɑ́ ponɑ tǝsulle cokǝle tɑɑ. Pɑ cɛlǝɣɩ kɔtʋlʋ, nɑ ɩ́lɛ́ ɩ ponɑ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Ɩlɛnɑ ɩ́ cosi nɑ ɩ́ nyɑɣɑsɩ tǝ tɔɔ sɩ, pǝ́ lɑ kʋtɔɔsǝm sɩ, Tɑcɑɑ tǝnnɑ pǝ tǝnɑ. Kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔlɛ, kɑ sɔɔsʋŋ kɛ Tɑcɑɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kʋhɑʋ ŋkʋ kʋ kɑkɑɑsɑɣɑ pǝsǝɣɩ kɔtǝlɑɑ nyǝm kɛ́. Mpi tɔ, pǝ kɛ́ kɑtɛ tɑɑ kɑtɛ pʋlʋpʋɣʋ. Pǝ tɑɣɑ pʋlʋ, pǝ kɛ́ kʋhɑʋ ŋku pɑ hɑ Tɑcɑɑ tɔ kʋ kɑkɑɑsɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Ye pɑ tɑɣɑnǝɣɩ Tɑcɑɑ mɑɣɑ tɔɣɔnɑɣɑ kʋhɑʋ sɩ, pɑ nyɑɣɑsɩ-kʋɣʋ kɔkɔ kɛ mɑ hǝtɛ tɑɑ, pǝ fɛɩ sɩ pɑ́ tʋ pǝ tɑɑ kɛ́ kʋkʋsʋm yɑɑ tɩɩŋ. ");
INSERT INTO dop_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Pɑ pǝsǝɣɩ nɑ pɑ́ hɑ-m tɩɩŋ nɑ kʋkʋsʋm kɛ wɑɑtʋ wei pɑ pukinɑ-m tɔɣɔnɑɣɑ kɑlɑɑlɑɣɑ tɔ. Amɑ tɩɩŋ nɑ kʋkʋsʋm mpǝɣɩ pǝ fɛɩ sɩ, pɑ́ nyɑɣɑsɩ kɔtɑɣɑ tǝlɑtɛ tɔɔ sɩ, Tɑcɑɑ mɑ́, mɑ́ nɩɩ pǝ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ye pɑ hɑɑkɩ Tɑcɑɑ mɑɣɑ tɔɣɔnɑɣɑ kʋhɑʋ, pǝ wɛɛ sɩ pɑ́ tʋ́ tɔm kɛ́. Mpi tɔ, mpɩ pǝ hʋlǝɣǝnɑ sɩ nɔɣɔ ŋkɑ mɑ nɑ-mɛ tǝ pɛɛlɑɑ tɔ, kɑ wɛ tɑm tɔɔ. Pǝ tɔɔ kɛ́ pǝ wɛɛ sɩ pɑ́ tʋɣɩ tɔm kɛ pɑɑ tɔɣɔnɑɣɑ kʋhɑʋ ŋku kʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ye yʋlʋ lǝsǝɣɩ ɩ tɑwɑ kɑncɑɑlɑɣɑ kʋlʋlʋm kʋhɑʋ, ɩ wɔkɩ pǝ́ nɑ pǝ lɔɔtʋ kɛ́, nɑ ɩ́ yɔtɩ. ");
INSERT INTO dop_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Pǝ wɑɑlɩ, ɩlɛnɑ ɩ́ pǝlɩ pǝ tɔɔ kɛ́ nim nɑ ɩ́ tǝnɩ tulɑɑlʋ. Ḿpʋ́ɣʋ́ pǝ wɛɛ sɩ pɑ lɑ́ tɔɣɔnɑɣɑ kʋhɑʋ tɔm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ɩlɛnɑ kɔtʋlʋ nɑ́ɑ́ cosi pee kʋyɔtɛɛ ɑnɩ, nɑ ɩ́ nyɑɣɑsɩ pǝ nɑ tulɑɑlʋ tǝnɑ. Mpɩ pǝ kɛnɑ kʋtɔɔsǝm sɩ Tɑcɑɑ tǝnnɑ pǝ tǝnɑ. Tɔɣɔnɑɣɑ kʋhɑʋ ŋku pɑ nyɑɣɑsɑ Tɑcɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑɑ sɩ: Ye nɔɣɔlʋ cɑɑ ɩ lɑ-m nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ kɛ nɑʋ. Pǝ wɛɛ sɩ, ɑpɑlʋnyǝŋ yɑɑ ɑlʋ nyǝŋ wei ɩ tiili tɑ́ cɑɑmɩ tɔɣɔ ɩ kɑ́ kɔnɑ. ");
INSERT INTO dop_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ɩlɛnɑ ɩ́ tǝnɩ ɩ niŋ kɛ kpǝntɛ nyʋɣʋ tɑɑ, nɑ ɩ́ lɛntɩ-tɛɣɛ tǝsulle cokǝle nɔnɔɣɔ. Ɩlɛnɑ Alɔŋ lʋlʋɣʋ nyǝ́mɑ kɔtǝlɑɑ tɑɑ nɔɣɔlʋ ŋmɩɩsɩ tǝ cɑlǝm kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Ɩlɛnɑ pɑ́ nyɑɣɑsɩ Tɑcɑɑ kɛ nim tǝnɑ, mpi pǝ pɑmɑ lotu tɔɔ tɔ, ");
INSERT INTO dop_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","nɑ timpee nɑɑlɛ nɑ ɑ nim, nɑ kɔŋkɔmǝŋ tɑɑ nyǝm. Ɩsɩɩ pɑ lǝsʋɣʋ hɔɔlɛ, nɑ pǝ́ kpɛnnɑ timpee tɔ. ");
INSERT INTO dop_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ɩlɛnɑ kɔtǝlɑɑ tǝnɩ nɑntʋ ntǝɣɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔkɔ tɔɔ. Nɑ pɑ́ nyɑɣɑsɩ-tɩ nɑ kʋhɑʋ ŋku kɔkɔ lusɑɑ tɔ. Kɔtɑɣɑ ŋkɑ pɑ nyɑɣɑsɑ Tɑcɑɑ tɔɣɔlɛ. Kɑ sɔɔsʋŋ kɛ ɩ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Ye ɩsɩɩ heu yɑɑ pǝ́ŋ́ kɛ yʋlʋ lɑkɩ Tɑcɑɑ kɛ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ. Apɑlʋ yɑɑ ɑlʋ nyǝŋ wei ɩ tiili tɑ́ cɑɑmɩ tɔɣɔ ɩ kɑ́ kɔnɑ. ");
INSERT INTO dop_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ye ɩsɩɩ heu, ɩlɛ ɩ ponɑ-ɩ tǝsulle cokǝle kiŋ, ");
INSERT INTO dop_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","nɑ ɩ́ tǝnɩ ɩ niŋ kɛ heu nyʋɣʋ tɑɑ, nɑ ɩ́ lɛntɩ-ɩ tǝ kiŋ tǝnɑ. Ɩlɛnɑ kɔtǝlɑɑ tɑɑ nɔɣɔlʋ ŋmɩɩsɩ heu cɑlǝm kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","10","Ɩlɛnɑ pɑ́ nyɑɣɑsɩ Tɑcɑɑ kɛ nim tǝnɑ mpi pǝ pɑmɑ lotu tɔɔ tɔ. Nɑ timpee nɑɑlɛ nɑ ɑ nim nɑ kɔŋkɔmǝŋ tɔɔ nyǝm. Ɩsɩɩ pɑ lǝsʋɣʋ hɔɔlɛ nɑ pɑ́ kpɛnnɑ timpee tɔ, nɑ sukɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Ɩlɛnɑ kɔtʋlʋ nyɑɣɑsɩ pǝ tǝnɑɣɑ kɔkɔ kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Tɔɣɔnɑɣɑ kɔtɑɣɑ ŋkɑ pɑ nyɑɣɑsɑ Tɑcɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Ye pǝ́ŋ́ kɛ yʋlʋ lɑkɩ kɔtɑɣɑ, ɩlɛ ɩ ponɑ-ɩ tǝsulle cokǝle kiŋ, ");
INSERT INTO dop_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","nɑ ɩ́ tǝnɩ ɩ niŋ kɛ ɩ nyʋɣʋ tɔɔ, nɑ ɩ́ lɛntɩ-ɩ tǝnɑ. Ɩlɛnɑ kɔtǝlɑɑ ŋmɩɩsɩ ɩ cɑlǝm kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Ɩlɛnɑ pɑ́ nyɑɣɑsɩ Tɑcɑɑ kɛ nim tǝnɑ mpi pǝ pɑmɑ lotu tɔɔ tɔ, ");
INSERT INTO dop_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","nɑ timpee nɑɑlɛ nɑ ɑ nim, nɑ kɔŋkɔmǝŋ tɔɔ nyɩm. Ɩsɩɩ pɑ lǝsʋɣʋ hɔɔlɛ nɑ pɑ́ kpɛnnɑ timpee tɔ. ");
INSERT INTO dop_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Ɩlɛnɑ kɔtʋlʋ nyɑɣɑsɩ pǝ tǝnɑɣɑ kɔkɔ kɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Tɔɣɔnɑɣɑ kɔtɑɣɑ ŋkɑ pɑ nyɑɣɑsɑ Tɑcɑɑ tɔɣɔlɛ. Kɑ sɔɔsʋŋ kɛ ɩ cɑɑkɩ. Tɑcɑɑ tǝnnɑ nim cɔlɔ nim cɔlɔ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Pǝ tɔɔ kɛ́ pɑɑ timpiɣi Ɩsɛɣɛlɩ nyǝ́mɑ kɑ́ wɛɛ, pɑɑ wɑɑtʋ wei te, pǝ wɛɛ sɩ pɑ́ tɔkɩ kʋsǝsɩɩtʋ tǝnɛɣɛ. Pǝ fɛɩ sɩ pɑ́ tɔɣɔ kpǝntɛ nɑntʋ nim, yɑɑ tǝ cɑlǝm. ");
INSERT INTO dop_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, ye pǝ yʋkǝnɑ nɔɣɔlʋ nɑ ɩ́ lɑ́ mpi Tɑcɑɑ kisɑɑ tɔ, nɑ ɩ́ yɔkɩ kiiu. Ɩsǝnɑ pʋntʋ kɑ́ lɑ tɔɣɔlɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ye kɔtʋlʋ sɔsɔ pǝntǝnɑ, ɩlɛnɑ ɩ tɑsǝkǝlɛ tɑɑnɑ yǝlɑɑ tǝnɑ. Pǝ wɛɛ sɩ ɩ́ lɑ Tɑcɑɑ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kɛ nɑʋ ɑpɑlʋ nyǝŋ wei ɩ tiili tɑ cɑɑmɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ɩ pukinɑ nɑʋ ɩnǝɣɩ tǝsulle cokǝle nɔnɔɣɔ. Ɩlɛnɑ ɩ́ tǝnɩ ɩ niŋ kɛ ɩ nyʋɣʋ tɑɑ, nɑ ɩ́ lɛntɩ-ɩ Tɑcɑɑ kiŋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ɩlɛnɑ kɔtʋlʋ sɔsɔ kpɑɣɑ kpǝntɛ cɑlǝm nɑ nyǝnɑɣɑ nɑ ɩ́ sʋʋnɑ cokǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ɩ liiki pǝ tɑɑ kɛ́ mpǝle, ɩlɛnɑ ɩ́ ŋmɩɩsɩ tɔm nɑɑtosompɔɣɔlɑɣɑ, kɛ Tɑcɑɑ kiŋ tǝnɑɣɑ cokǝle pʋʋɣʋ kʋkɑɣɑʋ tɔɔ, nɑ pǝ tɔɔ pǝ tɔɔ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ɩlɛnɑ ɩ́ tɑɑ cɑlǝm mpɩ tɔtɔɣɔ tulɑɑlʋ tǝwɔtɛ hǝlǝŋɑsɩ tɔɔ kɛ́ cokǝle tɑɑ tǝnɑ. Pǝ wɑɑlɩ, ɩlɛnɑ ɩ́ pǝlɩ cɑlǝm kʋkɑɑsǝm kɛ kɔtɑɣɑ tǝlɑtɛ nte tǝ wɛ cokǝle nɔnɔɣɔ tɔ tǝ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ɩlɛnɑ ɩ́ kɔɔlɩ kpǝntɛ nim cɔlɔ nim cɔlɔ tǝnɑ. Pǝ kpɑɣɑʋ pǝ tǝnɑ mpi pǝ pɑmɑ pǝ tɑɑ lotu tɔɔ tɔ, ");
INSERT INTO dop_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","nɑ timpee nɑɑlɛ nɑ ɑ nim, nɑ kɔŋkɔmǝŋ tɑɑ nyǝm. Ɩsɩɩ pɑ lǝsʋɣʋ hɔɔlɛ nɑ pɑ́ kpɛnnɑ timpee tɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Lonɑ kʋlʋmɛɛ ɑnǝɣɩ pɑ sɛtǝɣɩ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ kpǝntɛ tɔɔ. Ɩlɛnɑ kɔtʋlʋ sɔsɔ nyɑɣɑsɩ nɑntʋ ntǝɣɩ kɔtɑɣɑ tǝlɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","Pǝ kɑɑsǝɣɩ nɑntʋ lɛntɩ, nɑ tɔnʋɣʋ nɑ nyʋɣʋ, nɑ nɔŋkpɑɑsɩ, nɑ lotu nɑ pǝ tɑɑ nyǝm tǝnɑ. Ɩlɛnɑ pɑ́ lɩɩnɑ tǝsikile wɑɑlɩ, kɛ lonte nte pɑ lǝsǝnɑ tǝ mpɑɑ nɑ pɑ́ lɔɔkɩ tɔlʋmɑ nim nyǝnɑ tɔ. Nɑ pɑ́ nyɑɣɑsɩ-tǝɣɩ kɔkɔ kɛ tɔlʋmɑ huɣule tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ye ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tǝpɑɩ kɛ́ pǝ yʋkǝnɑɑ, nɑ pɑ́ lɑ mpi Tɑcɑɑ kisɑɑ tɔ, nɑ pɑ́ yɔkɩ ɩ kiiu nɑ pɑ tǝnɑ pɑ tɔm sɩ. ");
INSERT INTO dop_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ɩlɛnɑ pǝ́ kɔɔ nɑ pɑ́ cɛkǝnɑ. Pǝ wɛɛ sɩ pɑ́ lǝsɩ nɑʋ ɑpɑlʋ nyǝŋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kɛ́. Pɑ pukinɑ-ɩ tǝsulle cokǝle nɔnɔɣɔ, ");
INSERT INTO dop_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ɩlɛnɑ pɑ nyʋɣʋ nyǝ́mɑ tǝnɩ pɑ niŋ kɛ kpǝntɛ nyʋɣʋ tɑɑ. Nɑ pɑ́ lɛntɩ-tɛɣɛ cokǝle nɔnɔɣɔ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ɩlɛnɑ kɔtʋlʋ sɔsɔ cosi tǝ cɑlǝm nɑ ɩ́ sʋʋnɑ tǝsulle cokǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Ɩ liiki pǝ tɑɑ kɛ́ mpǝle, ɩlɛnɑ ɩ́ ŋmɩɩsɩ tɔm nɑɑtosompɔɣɔlɑɣɑ, kɛ Tɑcɑɑ kiŋ tǝnɑɣɑ cokǝle pʋʋɣʋ kʋkɑɣɑʋ nɑ pǝ tɔɔ pǝ tɔɔ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Ɩlɛnɑ ɩ́ tɑɑ cɑlǝm mpɩ tɔtɔɣɔ tulɑɑlʋ tǝwɔtɛ hǝlǝŋɑsɩ tɔɔ kɛ́ cokǝle tɑɑ tǝnɑ. Pǝ wɑɑlɩ, ɩlɛnɑ ɩ́ pǝlɩ cɑlǝm kʋkɑɑsǝm kɛ kɔtɑɣɑ tǝlɑtɛ nte tǝ wɛ cokǝle nɔnɔɣɔ tɔ tǝ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Ɩlɛnɑ ɩ́ sɛtɩ nim cɔlɔ nim cɔlɔ nɑ ɩ́ wɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Teitei ɩsɩɩ ɩ kɑ lɑpʋ ɩ mɑɣɑmɑɣɑ ɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ nɑʋ tɔɣɔ ɩ kɑ́ lɑnɑ ɩnɛ. Ɩlɛnɑ ɩ́ lɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑɣɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ Ɩsɔ tɑɣɑnɩ-wɛɣɛ-tɩ. ");
INSERT INTO dop_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Pǝ wɑɑlɩ ɩlɛnɑ ɩ́ ponɑ kpǝntɛ kɑkɑɑsɑɣɑ kɛ tǝsikile wɑɑlɩ, nɑ ɩ́ nyɑɣɑsɩ-tɛɣɛ kɔkɔ, ɩsɩɩ ɩ kɑ lɑpʋ ɩ mɑɣɑmɑɣɑ ɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ kpǝntɛ kɔtɑɣɑ tɔ. Kɔtɑɣɑ ŋkɑ kɑ hɩɩsǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ɩsɑɣɑtʋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ye ɩsɩɩ nyʋɣʋ tʋ nɔɣɔlʋɣʋ pǝ yʋkǝnɑɑ, nɑ ɩ́ lɑ mpi ɩ Cɑɑ Ɩsɔ kisɑɑ tɔ. Ɩsɩɩ ɩ yɔkɑ ɩ kiiu nɑ ɩ tɔm sɩ́. ");
INSERT INTO dop_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ɩlɛnɑ pǝ́ kɔɔ nɑ ɩ́ cɛkǝnɑ ɩ ɩsɑɣɑtʋ. Pǝ wɛɛ sɩ, ɩ́ lɑ pǝŋtʋlʋɣʋ ŋku kʋ tiili tɑ́ cɑɑmɩ tɔɣɔ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ɩ tǝnǝɣɩ ɩ niŋ kɛ kpǝntɛ nyʋɣʋ tɑɑ kɛ́. Ɩlɛnɑ ɩ́ lɛntɩ-tɛɣɛ tǝsulle cokǝle kiŋ, kɛ timpi pɑ lɛntǝɣɩ kɔtɑsɩ nsi kɔkɔ lusɑɑ tɔ sɩ tɔlɑ tɔ. Kɔtɑɣɑ ŋkɑ kɑ hɩɩsǝɣɩ ɩsɑɣɑtʋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ɩlɛnɑ kɔtʋlʋ lii ɩ mpǝle kɛ cɑlǝm tɑɑ, nɑ ɩ́ tɑɑ-wǝɣɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ hǝlǝŋɑsɩ tɔɔ, nɑ ɩ́ pǝlɩ kʋkɑɑsǝm kɛ tǝ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ɩlɛnɑ ɩ́ wɔ nim cɔlɔ nim cɔlɔɣɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Ɩsɩɩ pɑ lɑkʋɣʋ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ kpǝntɛ tɔ. Ɩlɛnɑ ɩ́ lɑ nyʋɣʋ tʋ ɩnǝɣɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ nɑ Ɩsɔ tɑɣɑnɩ-ɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ye ɩsɩɩ yʋlʋ kɛ yem kɛ́ pǝ yʋkǝnɑɑ, nɑ ɩ́ lɑ mpi Tɑcɑɑ kisɑɑ tɔ. Ɩsɩɩ ɩ yɔkɑ ɩ kiiŋ tɑɑ nɑkʋlɩ, nɑ ɩ tɔm sɩ́. ");
INSERT INTO dop_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ɩlɛnɑ pǝ́ kɔɔ nɑ ɩ́ cɛkǝnɑ, pǝ wɛɛ sɩ ɩ́ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kɛ pǝ́ŋ́ ɑlʋ nyǝŋ wei ɩ tiili tɑ́ cɑɑmɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Ɩ tǝnǝɣɩ ɩ niŋ kɛ kpǝntɛ nyʋɣʋ tɑɑ kɛ́, ɩlɛnɑ ɩ́ lɛntɩ-tɛɣɛ timpi pɑ lɛntǝɣɩ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔ kɑ tɔlɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ɩlɛnɑ kɔtʋlʋ lii ɩ mpǝle kɛ cɑlǝm tɑɑ, nɑ ɩ tɑɑ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ hǝlǝŋɑsɩ tɔɔ. Ɩlɛnɑ ɩ́ pǝlɩ kʋkɑɑsǝm kɛ tǝ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Ɩlɛnɑ pɑ́ sɛtɩ kpǝntɛ nim cɔlɔ nim cɔlɔ. Ɩsɩɩ pɑ lɑkʋɣʋ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ tɔtɛ tɔ, nɑ kɔtʋlʋ nyɑɣɑsɩ nɑntʋ ntǝɣɩ kɔkɔ, nɑ Tɑcɑɑ nɩɩ pǝ sɔɔsʋŋ. Ɩlɛnɑ ɩ́ lɑ́ pǝntʋlʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ nɑ Ɩsɔ tɑɣɑnɩ-ɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Ye heu kɛ ɩ sɔɔlɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ lɑpʋ ɩlɛ ɩ kɔnɑ ɑlʋnyǝŋ wei ɩ tiili tɑ́ cɑɑmɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ɩ tǝnǝɣɩ ɩ niŋ kɛ kpǝntɛ nyʋɣʋ tɑɑ ɩlɛnɑ ɩ lɛntɩ-tɛɣɛ timpi pɑ lɛntǝɣɩ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔ kɑ tɔlɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Ɩlɛnɑ kɔtʋlʋ lii ɩ mpǝle kɛ cɑlǝm tɑɑ, nɑ ɩ́ tɑɑ kɔtɑɣɑ tǝlɑtɛ hǝlǝŋɑsɩ tɔɔ. Nɑ ɩ́ pǝlɩ kʋkɑɑsǝm kɛ tǝ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ɩlɛnɑ pɑ́ sɛtɩ kpǝntɛ nim cɔlɔ nim cɔlɔ. Ɩsɩɩ pɑ lɑkʋɣʋ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ heu tɔ. Ɩlɛnɑ kɔtʋlʋ nyɑɣɑsɩ-tǝɣɩ kɔkɔ nɑ kɔtɑɣɑ nyǝntʋ lɛntɩ. Ɩlɛnɑ ɩ́ lɑ́ pǝntʋlʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ nɑ Ɩsɔ tɑɣɑnɩ-ɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Sɑɑ wei pǝ wɛɛ sɩ pɑ́ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ sɔɔsɩ tɔɣɔlɔ: Ye ɩsɩɩ yʋlʋ nɩɩwɑ pɑ yɔɣɔtǝnɑ tuunɑʋ sɩ, ɩ́ lǝsɩ ɑseetɑ kɛ tɔm nti ɩ nɑwɑ nɑ ɩ nyǝmɑ tɔ. Ɩlɛnɑ ɩ́ kisi tǝ yɔɣɔtʋɣʋ, pǝ ɩsɑɣɑtʋ wɛ ɩ nyʋɣʋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Lɛntɩ ɩlɛ, ye ɩsɩɩ pǝ yʋkǝnɑ yʋlʋ, nɑ ɩ́ tokinɑ ɑsilimɑ pʋlʋpʋ. Pɑɑ kpǝntɛ kʋsǝpǝlɛ. Tǝyɑɣɑ nyǝntɛ, yɑɑ tɑɑlɛ nyǝntɛ, yɑɑ nyɑmɑnyɑmɑ nɔɣɔlʋ, ɩ tɔm sǝpɑɣɑ, nɑ ɩ́ pǝsɩ ɑsilimɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ye ɩsɩɩ pǝ yʋkǝnɑ nɔɣɔlʋ, nɑ ɩ́ tokinɑ yʋlʋ ɑsilimɑ nɑɑlɩ, nɑ pǝ́ pilisi-ɩ. Ɩlɛnɑ ɩ́ kɔɔ ɩ́ cɛkǝnɑ, ɩ tɔm sǝpɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Yɑɑ pǝ yʋkǝnɑ nɔɣɔlʋɣʋ tɑnɑɑʋ tɑɑ, nɑ ɩ́ tuunɑ kʋpɑntʋ yɑɑ ɩsɑɣɑtʋ. Ɩlɛnɑ ɩ́ kɔɔ ɩ́ cɛkǝnɑ, ɩ tɔm sǝpɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Ye wei ɩ lɑpɑ ɩsɑɣɑtʋ nti pɑ kɛɛsɑ ɩsǝntɔ tɔ tǝ tɑɑ nɑtǝlɩ, pǝ wɛɛ sɩ pʋntʋ ɩ́ hʋlɩ-tǝɣɩ kɔtʋlʋ, nɑ ɩ́ tisi sɩ ɩ tɔm sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Nɑ ɩ́ kɔnɑ heu yɑɑ pǝ́ŋ́ nɑ ɩ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Ɩlɛnɑ kɔtʋlʋ lɑpɩ-ɩ pǝ sɔɔsɩ. ");
INSERT INTO dop_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ye yʋlʋ wɩɩ heu yɑɑ pǝ́ŋ́ sɩ ɩ́ lɑnɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Ɩ pǝsǝɣɩ nɑ ɩ́ cɑɑ ɩhokɑsɩ nɑɑlɛ yɑɑ ɑlukukunɑɑ nɑɑlɛ, nɑ ɩ́ ponɑ Tɑcɑɑ tǝyɑɣɑ tɑɑ. Ɩlɛnɑ ɩ́ lɑ́ lɛlʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ lɛlʋ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Ɩ cɛlǝɣɩ kɔtʋlʋ kɛ pɑ nɑɑlɛ, nɑ ɩ́lɛ́ ɩ́ hʋ́lɩ́ Ɩsɔ kɛ́ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋ nɑ ɩ́ yɔkɩ ɩ lumɑɣɑ. Amɑ ɩɩ cɛkɩ nyʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ɩlɛnɑ ɩ́ cosi cɑlǝm nɑ ɩ́ ŋmɩɩsɩ-wǝɣɩ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. Ɩlɛnɑ ɩ́ pǝlɩ kʋkɑɑsǝm kɛ tǝ tɛɛ. Ḿpʋ́ɣʋ́ pǝ wɛɛ sɩ ɩ́ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ tɔm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Pǝ wɑɑlɩ kɛ́ kɔtʋlʋ lɑkɩ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔ ɑlukuku nɑɑlɛ nyǝŋ, ɩsɩɩ pɑ sɩɩʋ tɔ. Ɩlɛnɑ ɩ́ lɑ́ pǝntʋlʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ Ɩsɔ hɩɩsɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Ye yʋlʋ fɛɩnɑ ɑlukukunɑɑ nɑɑlɛ, yɑɑ ɩhokɑsɩ nɑɑlɛ. Ɩ pǝsǝɣɩ nɑ ɩ́ ponɑ mʋlʋm kiloonɑɑ tooso nɑ ɩ́ lɑ́ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Amɑ pǝ fɛɩ sɩ ɩ́ siti nim, yɑɑ ɩ́ tǝnɩ pǝ tɔɔ kɛ́ tulɑɑlʋ kɛ́. Mpi tɔ, pǝ kɛ́ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kɛ́, pǝ tɑɣɑ tɔɣɔnɑɣɑ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Ɩ pukinɑ mʋlʋm mpǝɣɩ kɔtʋlʋ, ɩlɛnɑ ɩ́lɛ́ ɩ́ cosi-wǝɣɩ ŋkute. Ńtɛ́ tǝ kɛnɑ kʋtɔɔsǝm sɩ Tɑcɑɑ tǝnnɑ pǝ tǝnɑ. Ɩlɛnɑ ɩ́ nyɑɣɑsɩ pǝ nɑ kɔtɑsɩ lɛnsɩ nsi sɩ wɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ tɔɣɔ Tɑcɑɑ. Ḿpʋ́ɣʋ́ pǝ wɛɛ sɩ pɑ́ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ sɔɔsɩ. ");
INSERT INTO dop_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ɩlɛnɑ kɔtʋlʋ lɑ pʋntʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ nɑ Ɩsɔ hɩɩsɩ-ɩ-tɩ. Ɩlɛnɑ kʋkɑɑsǝm pǝsɩ kɔtʋlʋ nyǝm, ɩsɩɩ tɔɣɔnɑɣɑ kʋhɑʋ sɔɔsɩ tɔm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Ye pǝ yʋkǝnɑ yʋlʋ, nɑ ɩ́ sɔɔ Tɑcɑɑ kɛ cɛlʋɣʋ kɛ ɩ nyǝm, pǝ wɛɛ sɩ ɩ́ kɔnɑ ɩwɑɑʋ ŋku kʋ tiili tɑ́ cɑɑmɩ tɔ, nɑ ɩ́ lɑ́ tɑɣɑnʋɣʋ kɔtɑɣɑ. Ɩ lǝsǝɣɩ-kʋɣʋ kɑlǝkʋ tɑɑ kɛ́, nɑ ɩ́ mɑɣɑsɩ nɑ ɩ́ nɑ́ sɩ kʋ liɣitee tɑlɑ ɩsɩɩ pɑ sɩɩwɑ tǝsulle cokǝle tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Ɩlɛnɑ ɩ́ fɛlɩ Ɩsɔ kɛ́ kǝmlɛ, nɑ ɩ́ sɔɔsɩ pɑɑ kɑkpɑsɩ wei ɩ́ tɔɔ kɛ́ kʋlʋm. Mpi tɔ, ɩ wɑkǝlǝnɑ Ɩsɔ tǝyɑɣɑ, ɩlɛnɑ ɩ́ cɛlɑ pǝ tǝnɑɣɑ kɔtʋlʋ. Ɩlɛnɑ ɩ́lɛ́ ɩ lɛntɩ kpǝntɛ, nɑ ɩ́ lɑ pǝntʋlʋ kɛ ɩsɑɣɑtʋ tɑɣɑnʋɣʋ kɔtɑɣɑ, nɑ Ɩsɔ hɩɩsɩ-ɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Pɑɑ pǝ yʋkǝnɑ yʋlʋ kɛ́ nɑ ɩ́ yɔkɩ Tɑcɑɑ kʋsǝsɩɩtʋ, ɩ sǝɣǝlɑɑ tɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Pǝ wɛɛ sɩ ɩ́ lǝsɩ kɑlǝkʋ tɑɑ kɛ́ ɩwɑɑʋ ŋku kʋ tiili tɑ́ cɑɑmɩ tɔɣɔ. Ɩ́ mɑɣɑsɩ nɑ ɩ́ nɑ́ sɩ kʋ liɣitee tɑlɑ ɩsɩɩ pɑ sɩɩwɑ tɔ. Ɩlɛnɑ kɔtʋlʋ lɑpɩ-ɩ ɩsɑɣɑtʋ nti pǝ yʋkǝnɑ-ɩ nɑ ɩ lɑ tɔ, tǝ tɑɣɑnʋɣʋ kɔtɑɣɑ, nɑ Ɩsɔ hɩɩsɩ-ɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Tɑsǝkǝlɛ tɑɣɑnʋɣʋ kɔtɑɣɑ ntɛ́. Mpi tɔ, yʋlʋ ɩnɩ ɩ kɑ wɑkǝlǝnɑ Tɑcɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","22","Ye ɩsɩɩ pɑ cɛlɑ yʋlʋ kɛ pʋlʋpʋ sɩɩʋ, yɑɑ ɩ kǝntɑ-wɩ, yɑɑ ɩ ŋmɩɩlɑ-wɩ, yɑɑ ɩ muɣulɑɑ kɛ́ nɑ ɩ́ hiki-wɩ, yɑɑ ɩ tɩɩ hii-wɩ nɑ ɩ́ kpɛɛsɩ. Ɩlɛnɑ ɩ́ looli nɑ ɩ́ tuu, nɑ ɩ́ tɑkɩ ɩsɑɣɑtʋ ɩsɩɩ mpʋ pǝ tɑkɑ, ɩ wɑkǝlǝnɑ Tɑcɑɑ kɛ́, nɑ ɩ tɔm sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","24","Ye kʋyɑkʋ ŋku pǝ kulɑ ɩ wɑɑlɩ, pǝ wɛɛ sɩ ɩ́ mǝŋnɑ, yɑɑ ɩ́ fɛlɩ kpǝntɛ tʋ kɛ́. Hɑlǝnɑ ɩ́ sɔɔsɩ pɑɑ kɑkpɑsɩ wei ɩ tɔɔ kɛ́ kʋlʋm, nɑ ɩ́ kpɛntɩ nɑ ɩ́ cɛlɛ-ɩ. ");
INSERT INTO dop_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Pǝlɛ pǝ wɑɑlɩ, pǝ wɛɛ sɩ ɩ́ ponɑ kɔtʋlʋ kɛ ɩsɑɣɑtʋ tɑɣɑnʋɣʋ kɔtɑɣɑ ɩwɑɑʋ ŋku kʋ tiili tɑ́ cɑɑmɩ tɔ. Ɩ mɑɣɑsɩ nɑ ɩ́ nɑ́ sɩ kʋ liɣitee tɑlɑ ɩsɩɩ pɑ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Ɩlɛnɑ kɔtʋlʋ lɑ pʋntʋ ɩnǝɣɩ ɩsɑɣɑtʋ tɑɣɑnʋɣʋ kɔtɑɣɑ kɛ Tɑcɑɑ kiŋ. Nɑ ɩ́lɛ́ ɩ́ hɩɩsɩ-ɩ-tɩ, pɑɑ tǝ kɛ́ nti. ");
INSERT INTO dop_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Tɛlǝsɩ Alɔŋ nɑ ɩ lʋlʋɣʋ nyǝ́mɑ kɛ kɔtɑsɩ nsi kɔkɔ lusɑɑ tɔ, sɩ tɔɔ kʋsǝsɩɩtʋ. Pǝ wɛɛ sɩ, kɔtɑɣɑ ŋkɑ mɑ kɔkɔ lusɑ mpʋ tɔ, kɑ́ wɛɛ kɔtɑɣɑ tǝlɑtɛ tɑɑ kɛ́ ɑhoo tǝnɑɣɑ, kɔkɔ ɩ tɑɑ te. ");
INSERT INTO dop_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Tɛʋ feŋ tɑnɑŋ ɩlɛnɑ kɔtʋlʋ tɔɣɔlɩ kponkpontu toŋ nyǝntʋ kɔmsɑ, nɑ ɩ́ suu pǝ cɑpɑ, nɑ ɩ́ kuu kɔtɑɣɑ ŋkɛ kɑ tɔlʋmɑ nim nyǝnɑ nɑ ɩ́ huti-yɛɣɛ kɔŋkɔŋ tɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Ɩlɛnɑ ɩ́ lɑɣɑsɩ wontu nɑ ɩ́ lɩɩnɑ tɔlʋmɑ ɑnǝɣɩ tǝsikile wɑɑlɩ. Lonte ntɛɣɛ pɑ lǝsǝnɑ tǝ mpɑɑ nɑ pɑ́ lɔɔkɩ tɔlʋmɑ nim nyǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","6","Pǝ fɛɩ sɩ kɔtɑɣɑ tǝlɑtɛ kɔkɔ ɩ́ te. Pɑɑ ɩfemle nteɣe kɔtʋlʋ kɑ nyɔtǝɣɩ tɑɑsɩ kʋfɑsɩ. Ɩlɛnɑ pǝ́cɔ́ ɩ́ tǝnɩ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔ kɑ nɑntʋ, nɑ nɔɣɔ kʋlʋmɑɣɑ kɔtɑɣɑ kpǝntɛ nim cɔlɔ nim cɔlɔ kɛ pǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ye tɔɣɔnɑɣɑ kʋhɑʋ tɔm tɑɑ, ɩlɛ pǝ kʋsǝsɩɩtʋ ntɔ. Pǝ wɛɛ sɩ Alɔŋ lʋlʋɣʋ nyǝ́mɑ tɑɑ kɔtʋlʋ nɔɣɔlʋ, kɑ́ ponnɑ-kɛɣɛ Tɑcɑɑ kɛ kɔtɑɣɑ tǝlɑtɛ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ɩlɛnɑ ɩ́ cosi mʋlʋm mpi pɑ sitɑ nim tɔɣɔ ŋkute nɑ tulɑɑlʋ tǝnɑ, nɑ ɩ́ nyɑɣɑsɩ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Mpʋ pǝ kɛnɑ kʋtɔɔsǝm sɩ Tɑcɑɑ tǝnnɑ pǝ tǝnɑ, nɑ ɩ cɑɑkɩ pǝ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Kɔtǝlɑɑ kɑ́ tɔɣɔnɑ pǝ kʋkɑɑsǝm mpǝɣɩ Ɩsɔ lonte tɑɑ kɛ tǝsulle cokǝle kɑtɑɣɑ tɑɑ tǝnɑ. Amɑ pǝ fɛɩ sɩ pɑ́ tǝsɩ pǝ tɔɣɔnɑɣɑ nɑ kʋkʋsʋm kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Mpi tɔ, kʋhɑʋ ŋku pɑ hɑ Ɩsɔ mɑ tɔ, kʋ tɑɑ kɛ́ mɑ cɛlɑ-wɛɣɛ pɑ pɑɑ tete. Pǝ kɛ́ kɑtɛ tɑɑ kɑtɛ pʋlʋɣʋ, ɩsɩɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ, yɑɑ tɑɣɑnʋɣʋ kɔtɑsɩ nɑntʋ. ");
INSERT INTO dop_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ɩlɛ Alɔŋ lʋlʋɣʋ nyǝ́mɑ ɑpɑlʋ nyǝ́mɑ tike kɑ́ tɔkǝnɑ pǝ tɔɣɔnɑɣɑ ŋkɛ. Mpi tɔ, kɔtɑɣɑ ŋkɑ pɑ kɔnɑ Tɑcɑɑ kɛ mpʋ tɔ, kɑ hɔɣɔlʋɣʋ kɛ́ pɑ nyǝm kɛ tɑm tɔɔ kɛ́. Pǝ tɔɔ kɛ́ ye yʋlʋ kpɑɩ tʋ wei ɩ tɑ kɛ Alɔŋ lʋlʋɣʋ tʋ tɔ, ɩ tokinɑɑ, ɩsɩɩ ɩ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ye pɑ kpɑwɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ kɛ kɔtǝlɑɑ, nɑ pɑ́ pǝlɩ-wɛɣɛ nim, pǝ wɛɛ sɩ pɑ́ kɔŋnɑ-m kʋhɑʋ kɛ mʋlʋm kiloonɑɑ toosoɣo pɑɑ kʋyɑkʋ ŋku. Hɔɣɔlʋɣʋ kɛ tɑnɑŋ nɑ lɛŋkʋ kɛ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Pɑɑ nuɣuti mʋlʋm mpǝɣɩ nɑ nim, nɑ pɑ́ tʋ́ pǝ pɛtɛpɛtɑɣɑ kɛ nyǝɣǝlʋɣʋ kʋwɑlʋɣʋ tɔɔ. Pǝ wɑɑlɩ ɩlɛnɑ pɑ́ pʋtǝtɩ-kɛ nɑ pɑ́ ponɑ kɔtɑɣɑ tǝlɑtɛ tɔɔ, nɑ Tɑcɑɑ lɑŋlɛ hɛɛnɑ kɔtɑɣɑ ŋkɛ kɑ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Ye wɑɑtʋ nɔɣɔlʋ pɑ kpɑ Alɔŋ lʋlʋɣʋ nyǝ́mɑ tɑɑ nɔɣɔlʋɣʋ kɔtʋlʋ sɔsɔ sɩ, ɩ́ lɛɛtɩ kʋpǝŋ lonte. Kʋhɑʋ kʋlʋmʋɣʋ ŋkʋɣʋ ɩ kɑ́ kɔnɑ, nɑ ɩ́ nyɑɣɑsɩ pǝ tǝnɑɣɑ Tɑcɑɑ mɑ́. Pǝ kɛ́ mɑ kiiu tɑm tɔɔ nyǝŋkʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ye kɔtʋlʋ kɔnnɑ ɩ mɑɣɑmɑɣɑ ɩ tɔɣɔnɑɣɑ kʋhɑʋ, pǝ wɛɛ sɩ pɑ́ nyɑɣɑsɩ pǝ tǝnɑɣɑ, pǝ tɑɑ pʋlʋ fɛɩ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Tɛlǝsɩ Alɔŋ nɑ ɩ pǝyɑlɑɑ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑsɩ kʋsǝsɩɩtʋ. Lonte nte tǝ tɑɑ pɑ lɛntǝɣɩ kɔtɑsɩ nsi kɔkɔ lusɑɑ tɔ, sɩ tɔlɑ tɔɣɔ pɑɑ lɛntɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝntɛ tɔtɔ. Pǝ nɑntʋ kɛ kɑtɛ tɑɑ kɑtɛ pʋlʋpʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Kɔtʋlʋ wei ɩ lɑpɑ pǝ tǝmlɛ tɔ, tǝsulle cokǝle kɑtɑɣɑ tɑɑ kɛ́ pǝ wɛɛ sɩ ɩ́ tɔɣɔ-tǝɣɩ lonte nte tǝ wɛnɑ tǝ mpɑɑ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Ye yʋlʋ kɛ yem ɩ́ tokinɑɑ, ɩ lepɑ. Tǝ cɑlǝm ɩ yɑwɑ pʋʋɣʋ tɔɔ, lonte kʋlʋmtǝlɛ ńtɛ́ tǝ tɑɑ kɛ́ pɑɑ nyɑɑlɩ-wɩ. ");
INSERT INTO dop_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ye cʋɣʋ tiipile tɑɑ kɛ́ pɑ tǝsɑ pǝ nɑntʋ, ye pɑ tɛmɑ pǝ wɛɛ sɩ pɑ́ yɔkɩ-tɛɣɛ. Amɑ ye nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ nyǝntɛ tɑɑ, ɩlɛ pɑ́ nyɑɑlɩ-tɛɣɛ teu, nɑ pɑ́ kilisinɑ lʋm kɛ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Kɔtǝlɑɑ nɑ pɑ tɛɛsɩ tɑɑ ɑpɑlɑɑ tike kɑ́ tɔɣɔnɑ nɑntʋ ntɩ. Pǝ tɑɣɑ pʋlʋ, tǝ kɛ́ kɑtɛ tɑɑ kɑtɛ pʋlʋpʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Amɑ ye pɑ sʋʋnɑ kpǝntɛ ntɛ tǝ cɑlǝm kɛ tǝsulle cokǝle tɑɑ, nɑ pɑ́ lɑnɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kɛ Ɩsɔ tǝyɑɣɑ tɑɑ, tǝ nɑntʋ fɛɩ tɔɣɔʋ tɔtɔ. Pǝ wɛɛ sɩ pɑ́ nyɑɣɑsɩ-tǝɣɩ kɔkɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑɑ sɩ: Tɑɣɑnʋɣʋ sɔɔsɩ kʋsǝsɩɩtʋ ntɔ. Tǝ kɛ́ kɑtɛ tɑɑ kɑtɛ pʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Lonte nte tǝ tɑɑ pɑ lɛntǝɣɩ kɔtɑsɩ nsi kɔkɔ lusɑɑ tɔ, sɩ tɔlɑ tɔɣɔ pɑɑ lɛntɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ sɔɔsɩ nyǝntɛ tɔtɔ. Ɩlɛnɑ kɔtʋlʋ ŋmɩɩsɩ tǝ cɑlǝm kɛ́ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ɩlɛnɑ pɑ́ kɔɔlɩ kpǝntɛ nim cɔlɔ nim cɔlɔ tǝnɑ. Pǝ kpɑɣɑʋ pǝ tǝnɑ mpi pǝ pɑmɑ pǝ tɑɑ lotu tɔɔ tɔ, ");
INSERT INTO dop_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","nɑ timpee nɑɑlɛ nɑ ɑ nim, nɑ kɔŋkɔmǝŋ tɑɑ nyǝm. Ɩsɩɩ pɑ lǝsʋɣʋ hɔɔlɛ nɑ pǝ́ kpɛnnɑ timpee tɔ. ");
INSERT INTO dop_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Ɩlɛnɑ kɔtʋlʋ nyɑɣɑsɩ pǝ tǝnɑɣɑ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Tɑɣɑnʋɣʋ kɔtɑɣɑ ntɛ. ");
INSERT INTO dop_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Kɔtǝlɑɑ tɛɛsɩ tɑɑ ɑpɑlɑɑ tike kɑ́ tɔɣɔnɑ nɑntʋ ntǝɣɩ lonte nte tǝ wɛnɑ tǝ mpɑɑ tɔ tǝ tɑɑ. Mpi tɔ, tǝ kɛ́ kɑtɛ tɑɑ kɑtɛ pʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Tɑɣɑnʋɣʋ kɔtɑɣɑ nɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋkɑ pǝ kʋsǝsɩɩtʋ wɛ kʋlʋmtʋ kɛ́. Kɔtʋlʋ wei ɩ lɑpɑ pǝ tǝmlɛ tɔ, ɩnɩ ɩ tǝnnɑ pǝ nɑntʋ kʋkɑɑsǝtʋ. ");
INSERT INTO dop_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ye ɩsɩɩ nɔɣɔlʋ kɔnɑ kpǝntɛ sɩ ɩ lɑkɩ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔ. Kɔtʋlʋ wei ɩ lɑpɑ pǝ tǝmlɛ tɔ, ɩnɩ ɩ tǝnnɑ tɔnʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Ye pɑ kɔnɑ Ɩsɔ kɛ tɔɣɔnɑɣɑ kʋhɑʋ, ɩsɩɩ potopoto, yɑɑ kɑkɑlɑsɩ, yɑɑ pɛtɛpɛtɑɣɑ, yɑɑ kʋtoŋǝm, ɩlɛ kɔtʋlʋ wei ɩ lɑpɑ pǝ tǝmlɛ tɔ, ɩnɩ ɩ tǝnnɑ. ");
INSERT INTO dop_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Amɑ pǝ kɑɑsɑ tɔɣɔnɑɣɑ kʋhɑɑŋ lɛlǝŋ tɔ. Pɑɑ nim kʋsitɑɣɑ yɑɑ kpɛtɛ nyǝŋkɑ, kɔtǝlɑɑ tɑlǝɣǝnɑ pǝ tǝnɑɣɑ teitei. ");
INSERT INTO dop_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑsɩ nsi pɑ lɑkɩ Tɑcɑɑ tɔ sɩ kʋsǝsɩɩtʋ ntɔ. ");
INSERT INTO dop_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ye sɛɛtʋ kɔtɑɣɑ kɛ pɑ lɑpɑ, pɑ pukinɑ tɔtɔɣɔ kʋkʋsʋm fɛɩ kɑkɑlɑsɩ nsi pɑ sitɑ nim tɔ, pǝ pɛtɛpɛtɑsɩ nsi sɩ tɔɔ pɑ tɑɑ-wɩ tɔ, nɑ mʋlʋm kʋpɑm mpi pɑ nuɣutinɑ-wɩ tɔ pǝ kɑkɑlɑsɩ. ");
INSERT INTO dop_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pǝlɛ pǝ pɑɑsi, pɑ sɔɔsǝɣɩ kʋkʋsʋm potopoto kɛ sɛɛtʋ kɔtɑɣɑ ŋkɛ kɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ɩlɛnɑ pɑ́ lǝsɩ kɑkɑlɑsɩ nsɩ sɩ tɔm tooso tɔɔ kɛ́ kʋlʋmɑɣɑ kʋlʋmɑɣɑ, nɑ pɑ́ kpɑɑsɩ ɩsɔtɑɑ kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kiŋ. Ɩlɛnɑ kɔtʋlʋ wei ɩ ŋmɩɩsɑ kpǝntɛ cɑlǝm kɛ tǝ kɔŋkɔmǝŋ tɔɔ tɔ, ɩ́ kpɑɣɑ sǝlɛ. ");
INSERT INTO dop_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ye sɛɛtʋ kɔtɑɣɑ kpǝntɛ nɑntʋ ɩlɛ, pǝ wɛɛ sɩ kʋyɑkʋ ŋkʋ kʋ mɑɣɑmɑɣɑ kɛ pɑɑ tɔɣɔ-tɩ, pǝ fɛɩ sɩ tǝ́ fe tɛʋ. ");
INSERT INTO dop_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Ye ɩsɩɩ nɔɣɔlʋ lɑpɑ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ sɔɔsɩ, yɑɑ ɩ kɑ sɩɩ nɔɣɔ, ɩlɛnɑ ɩ lɑ pǝ sɔɔsɩ, pɑ pǝsǝɣɩ nɑ pɑ́ tɔɣɔ pǝ nɑntʋ kɛ kʋyɑkʋ ŋkʋ, nɑ pɑ́ tɔɣɔ pǝ kʋkɑɑsǝtʋ kɛ pǝ tɛʋ kʋfemuɣu. ");
INSERT INTO dop_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ye tǝ tɑlɑ kʋyɑkʋ tooso nyǝŋkʋ wule, ɩlɛ pǝ wɛɛ sɩ pɑ́ wɔ-tǝɣɩ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Wei ɩ́ tɔɣɔ pǝ nɑntʋ kɛ kʋyɑkʋ tooso nyǝŋkʋ wule, Tɑcɑɑ kɑɑ mʋ ɩ kɔtɑɣɑ. Pǝyele ɩ kɔtɑɣɑ kɑɑ wɑɑsɩ tɔtɔ. Pǝ pǝsɑ kʋsɔɣɔtʋ pʋlʋpʋ kɛ́. Ye wei ɩ tɔɣɑɑ pǝ mǝlɩ ɩ nyʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Ye pǝ nɑntʋ ɩ́ tokinɑ ɑsilimɑ pʋlʋpʋ, tǝ fɛɩ tɔɣɔʋ tɔtɔ. Kɔkɔ kɛ pɑɑ nyɑɣɑsɩ-tɩ. Pǝ wɛɛ sɩ mpɑ pɑ fɛɩnɑ ɑsilimɑ tɔ, pɑ tike pɑɑ tɔɣɔnɑ pǝ nɑntʋ. ");
INSERT INTO dop_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ye ɩsɩɩ nɔɣɔlʋ wɛ ɑsilimɑ tɑɑ, nɑ pɑ́ lɑ Tɑcɑɑ kɛ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ nɑ pʋntʋ tɔɣɔ, pǝ wɛɛ sɩ pɑ́ lǝsɩ-ɩ Ɩsɛɣɛlɩ kpekǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Mpʋ tɔtɔɣɔ ye nɔɣɔlʋ tokinɑ ɑsilimɑ tʋ, pɑɑ yʋlʋ, pɑɑ kpǝntɛ. Ɩlɛnɑ pʋntʋ tɔɣɔ kɔtɑɣɑ ŋkɛ kɑ nɑntʋ. Pɑɑ lǝsɩ-ɩ tɔtɔɣɔ Ɩsɛɣɛlɩ kpekǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ: Pǝ fɛɩ sɩ ɩ́ tɔɣɔ pʋlʋpʋ nɑntʋ nim. Pɑɑ nɑʋ yɑɑ heu yɑɑ pǝ́ŋ́. ");
INSERT INTO dop_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Kpǝntɛ kʋsǝpǝlɛ, yɑɑ nte pǝ kpɑwɑ nɑ pǝ cǝlɩ tɔ, tǝ nim fɛɩ tɔɣɔʋ. Amɑ ɩ́ pǝsǝɣɩ nɑ ɩ́ lɑnɑ-wǝɣɩ pɑɑ mpi. ");
INSERT INTO dop_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ye nɔɣɔlʋ tɔɣɔ tɔlɑ nnɑ pɑ lɑkɩ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔ kɑ nɑntʋ cǝkɑ nim nyǝŋkɑ, pǝ wɛɛ sɩ pɑ́ lǝsɩ-ɩ Ɩsɛɣɛlɩ kpekǝle tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Mpʋ tɔtɔɣɔ pɑɑ timpiɣi ɩ́ kɑ́ cɑɣɑ, pǝ fɛɩ sɩ ɩ́ tɔɣɔ sumɑɣɑ yɑɑ wontuɣu nɑkʋlɩ kʋ cɑlǝm. ");
INSERT INTO dop_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ye wei ɩ tɔɣɔ cɑlǝm pǝ wɛɛ sɩ pɑ́ lǝsɩ-ɩ Ɩsɛɣɛlɩ kpekǝle tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kʋsǝsɩɩtʋnɑɑ pɑnɛ sɩ: Ye yʋlʋ lɑpɑ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ, pǝ wɛɛ sɩ, ɩ́ lǝsɩ Tɑcɑɑ pɑɑ tete kɛ́, nɑ ɩ́ cɛlɛ-ɩ. ");
INSERT INTO dop_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ɩ mɑɣɑmɑɣɑ ɩ niŋ kɑ́ tɔkǝnɑ nɑ ɩ́ ponɑ Tɑcɑɑ kɛ nɑntʋ nim cɔlɔ nim cɔlɔ, nɑ lɑŋlɛ sɩ pɑ́ nyɑɣɑsɩ kɔkɔ. Ɩlɛnɑ ɩ́ hɑ lɑŋlɛ ntɛɣɛ Tɑcɑɑ kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ tǝtɔɣɔlɛ ntɛ́. Ɩlɛnɑ kɔtʋlʋ nyɑɣɑsɩ nɑntʋ nim nyǝntʋ kɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Pǝ wɛɛ sɩ pɑ́ lǝsɩ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ yule ntɔɣɔŋ nyǝntɛ nɑ pɑ́ cɛlɑ kɔtʋlʋ. ");
INSERT INTO dop_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Kɔtǝlɑɑ tɑɑ wei ɩ pukinɑ kpǝntɛ cɑlǝm nɑ tǝ nim kɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ tɔ ɩ pɑɑ tete ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Tɑcɑɑ mɑɣɑmɑɣɑ heelinɑ Ɩsɛɣɛlɩ nyǝ́mɑ mɛ sɩ, ɩ́ lǝsɩ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ kpǝntɛ yule, nɑ pǝ lɑŋlɛ nɑ ɩ́ cɛlɑ kɔtʋlʋ Alɔŋ nɑ ɩ lʋlʋɣʋ nyǝ́mɑ. Mpi tɔ, nɑntʋ ntɩ tǝ kɛ́ pɑ pɑɑ nyǝm kɛ tɑm tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Mpi mpi pɑ kɔɔlɑ Tɑcɑɑ kɔtɑsɩ tɔɔ tɔ, pǝ pǝsǝɣɩ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ nyǝm kɛ kʋyɑŋku pɑ kpɑ-wɛɣɛ Tɑcɑɑ kɔtʋɣʋ tǝmlɛ tɑɑ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Tɑcɑɑ tʋnɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, pɑ́ cɛlɑ-wɛɣɛ kʋyɑŋku pɑ kpɑɑ-wɛɣɛ kɔtǝlɑɑ nɑ pɑ́ pǝlɩ pɑ nyɔɔŋ tɑɑ kɛ́ nim tɔ. Pǝ wɛɛ sɩ ɩ́ tɔkɩ kʋsǝsɩɩtʋ tǝnɛɣɛ tɑm tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, nɑ tɔɣɔnɑɣɑ nyǝŋkɑ, nɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋkɑ, nɑ tɑsǝkǝlɛ tɑɣɑnʋɣʋ nyǝŋkɑ, nɑ kɔtǝlɑɑ tǝmlɛ tɑɑ sʋʋʋ nyǝŋkɑ, nɑ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ pǝ kɔtɑsɩ kiiŋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Tɑcɑɑ sɩɩnɑ kiiŋ ɩnǝɣɩ Moisi kɛ pʋɣʋ ŋku pɑ yɑɑ sɩ Holɛpʋ tɔ kʋ tɑɑ. Kʋyɑkʋ ŋkʋ tɔtɔɣɔ ɩ tʋwɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ wʋlɑɣɑ tɛtʋ tɑɑ sɩ, pɑ́ lɑkɩ-ɩ kɔtɑsɩ nsɩ. ");
INSERT INTO dop_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Yɑɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ kɛ tǝsulle cokǝle nɔnɔɣɔ. Ɩlɛnɑ ń yele nɑ pɑ́ kɔnɑ kɔtɑɣɑ wontu kususuutu, nɑ pǝ nim mpi pɑ pǝlǝɣɩ nyʋɣʋ tɑɑ tɔ. Nɑ pɑ́ kɔnɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ nɑʋ ɑpɑlʋ nyǝŋ, nɑ ɩwɑɑŋ nɑɑlɛ, nɑ potopotonɑɑ mpɑ pɑ tɑɑ kʋkʋsʋm fɛɩ tɔɣɔ cɛkǝlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Ɩlɛnɑ ń koti Ɩsɛɣɛlɩ nyǝ́mɑ kpekǝle tǝnɑ tɔtɔɣɔ lonte ńtɛ́ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Ḿpʋ́ɣʋ́ Moisi lɑpɑ ɩsɩɩ Tɑcɑɑ tʋɣʋ-ɩ tɔ, nɑ Ɩsɛɣɛlɩ nyǝ́mɑ kpekǝle koti tǝsulle cokǝle nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ɩlɛnɑ ɩ́ heeli-wɛ sɩ nti Tɑcɑɑ sɩɩwɑ tɔɣɔlɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ntɛnɑ Moisi yele nɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ́ kɔɔ nɑ ɩ́ sɔ-wɛɣɛ kɔtɑɣɑ lʋm. ");
INSERT INTO dop_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Ɩlɛnɑ ɩ́ suu Alɔŋ kɛ pǝtɛɛ toko, nɑ ɩ́ lǝlɩ-ɩ tɑmpɑlɑ, nɑ ɩ́ suu-ɩ cɑpɑ. Ɩlɛnɑ ɩ́ pɑɑ-ɩ kɔtɑɣɑ pɛntɛ tɑkɑ, nɑ ɩ́ tɑmsɩ ɩ ŋmɩɩsɩ kɛ ɩ siɣile tɑɑ. nɔɣɔlʋɣʋ, nɑ pɑ́ pɑɑkɩ pɑ lɑŋɑ tɑɑ ɩsɩɩ kukunɑɑ pɑɑkɩ sɑɑlɑɣɑ ŋkɑ tɔ pǝ tɑkɑ. ");
INSERT INTO dop_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Ɩlɛnɑ ɩ́ pɑɑ-ɩ lɑŋlɛ huluɣu, nɑ ɩ́ tʋ́ kʋ tɑɑ kɛ́ wɑlɑ pee tɑkɑ kɛ nɑɑlɛ. Anǝɣɩ pɑ mɑɣɑsɑɣɑnɑ nɑ pɑ́ nyǝŋ Ɩsɔ kʋyɔɣɔtʋtʋ. ");
INSERT INTO dop_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ntɛnɑ ɩ́ temɩ-ɩ nyʋɣʋ sɑɑlɑɣɑ, nɑ ɩ́ mɑtɩ kɑ tɔɔ kɛ́ Ɩsɔ kʋyʋsʋɣʋ. Kʋlɛ kʋ kɛ́ wʋlɑ kɛ́, nɑ kʋ wɛ ɩsɩɩ tʋɣʋ hɛtʋɣʋ. Ɩ ɩsɛntɑɑ tɔɔ kɛ́ ɩ mɑtǝnɑ kʋyʋsʋɣʋ ŋkʋ, ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ḿpʋ́ɣʋ́ Moisi kpɑɣɑ kɔtɑɣɑ nim, nɑ ɩ́ fɛɛnɩ tǝsulle cokǝle, nɑ tǝ tɑɑ wontu tǝnɑ, nɑ tǝ́ pǝsɩ Ɩsɔ nyǝm. ");
INSERT INTO dop_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ɩlɛnɑ ɩ́ ŋmɩɩsɩ kɔtɑɣɑ nim kɛ tɔm nɑɑtosompɔɣɔlɑɣɑ kɛ kɔtɑɣɑ tǝlɑtɛ nɑ tǝ wontunɑɑ tɔɔ. Lʋm kʋsɑŋǝm cɛmsɛ sɔsɔ nɑ pǝ kpete tɔɔ kɛ́ ɩ ŋmɩɩsɑ nim mpɩ sɩ wontu ntɩ tǝ́ pǝsɩ Ɩsɔ nyǝm. ");
INSERT INTO dop_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Nɑ ɩ́ pǝlɩ Alɔŋ nyʋɣʋ tɑɑ kɛ́ kɔtɑɣɑ nim, nɑ ɩ́ pǝsɩ Ɩsɔ nyǝŋ. ");
INSERT INTO dop_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Pǝlɛ pǝ wɑɑlɩ kɛ́ ɩ yelɑɑ nɑ Alɔŋ pǝyɑlɑɑ kpǝtǝnɑ, nɑ ɩ́ suu-wɛɣɛ pɑ cɑpɑnɑɑ, nɑ ɩ́ lǝlɩ-wɛɣɛ pɑ tɑmpɑlɑnɑɑ. Ɩlɛnɑ ɩ́ pɑ-wɛɣɛ pɑ kɑhusi kɛ teitei ɩsɩɩ Tɑcɑɑ kɑ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ḿpʋ́ɣʋ́ Moisi yelɑɑ nɑ pɑ́ kɔnɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ nɑʋ ɑpɑlʋnyǝŋ. Ɩlɛnɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ́ tǝnɩ niŋ kɛ ɩ nyʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ḿpʋ́ɣʋ́ Moisi lɛntɑ-ɩ, nɑ ɩ́ lii mpǝle kɛ ɩ cɑlǝm tɑɑ, nɑ ɩ́ nyɔtɔ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ ŋkuluŋɑsɩ tɑɑ hǝlǝŋɑsɩ tɔɔ, nɑ pǝ́ tɑɣɑnɩ-tɛ. Ɩlɛnɑ ɩ́ pǝlɩ cɑlǝm kʋkɑɑsǝm kɛ kɔtɑɣɑ tǝlɑtɛ tɛɛ. Ɩsǝnɑ ɩ lɑpɑ nɑ kɔtɑɣɑ tǝlɑtɛ pǝsɩ Ɩsɔ nyǝntɛ nɑ pɑ́ lɑkǝnɑ-tɛɣɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑsɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ḿpʋ́ɣʋ́ Moisi kɔɔlɑ nim tǝnɑ, mpi pǝ pɑmɑ kpǝntɛ lotu tɔɔ tɔ. Pɑɑ timpee nɑɑlɛ nɑ ɑ nim, nɑ ɩ́ sɛtɩ hɔɔlɛ nɔɣɔ, nɑ ɩ́ nyɑɣɑsɩ pǝ tǝnɑɣɑ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Pǝ kɑɑsǝɣɩ nɑʋ ɩnɩ ɩ tɔnʋɣʋ nɑ ɩ nɑntʋ nɑ pǝ tɑɑ lotu, ɩlɛnɑ pɑ́ lɩɩnɑ pǝ tǝnɑɣɑ tesikile wɑɑlɩ, nɑ pɑ́ nyɑɣɑsɩ kɔkɔ, ɩsɩɩ Tɑcɑɑ kɑ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ḿpʋ́ɣʋ́ pɑ kɔnɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ kɑ ɩwɑɑʋ, nɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ́ tǝnɩ pɑ niŋ kɛ kʋ nyʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moisi lɛntɑ-kʋ, ɩlɛnɑ ɩ ŋmɩɩsɩ kʋ cɑlǝm kɛ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Ɩlɛnɑ ɩ fɑɣɑ-kʋɣʋ piliŋɑsɩ, nɑ ɩ́ nyɑɣɑsɩ pǝ nɑ pǝ nyʋɣʋ nɑ pǝ nim. ");
INSERT INTO dop_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Ɩlɛnɑ ɩ́ nyɑɑlɩ lotu nɑ nɔŋkpɑɑsɩ kɛ lʋm, nɑ ɩ́ nyɑɣɑsɩ pǝ nɑ nɑntʋ nti tǝ kɑɑsɑɑ tɔɣɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔɣɔlɛ. Kɑ sɔɔsʋŋ kɛ Tɑcɑɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ḿpʋ́ɣʋ́ Moisi yelɑɑ nɑ pɑ́ kɔnɑ ɩwɑɑʋ nɑɑlɛ nyǝŋkʋ ŋku pɑɑ lɑ kɔtɑɣɑ nɑ pǝ́ sʋsɩ Alɔŋ nɑ ɩ pǝyɑlɑɑ kɛ kɔtǝlɑɑ tǝmlɛ tɑɑ tɔ. Ɩlɛnɑ pɑ́ tǝnɩ pɑ niŋ kɛ kʋ nyʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ḿpʋ́ɣʋ́ Moisi lɛntɑ ɩwɑɑʋ ŋkʋ, ɩlɛnɑ ɩ́ lii kʋ cɑlǝm nɑ ɩ́ tɑɑ-wǝɣɩ Alɔŋ ŋkpɑŋʋɣʋ ntɔɣɔŋ nyǝŋkʋ nɔɣɔ tɑɑ. Ɩ tɑɑ-wɩ tɔtɔɣɔ ɩ ɑpɑlʋmpǝle ntɔɣɔŋ nyǝntɛ tɔɔ, nɑ ɩ ɑpɑlʋnɔmpǝle ntɔɣɔŋ nyǝntɛ tɔɔ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ɩlɛnɑ ɩ́ yele nɑ Alɔŋ pǝyɑlɑɑ kɔɔ nɑ ɩ́ tɑɑ cɑlǝm tɔtɔɣɔ pɑ ntɔɣɔŋ ŋkpɑŋŋ nɔɔsɩ tɑɑ, nɑ pɑ ntɔɣɔŋ ɑpɑlʋmpee nɑ ɑpɑlʋnɔmpee tɔɔ. Ɩlɛnɑ ɩ́ ŋmɩɩsɩ cɑlǝm kʋkɑɑsǝm kɛ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ḿpʋ́ɣʋ́ Moisi kpɑɣɑ ɩwɑɑʋ nɑntʋ nim nyǝntʋ. Ɩsɩɩ sukɑ, nɑ lotu tɑɑ nim, nɑ hɔɔlɛ nɔɣɔ, nɑ timpee nɑɑlɛ nɑ ɑ nim, nɑ yule ntɔɣɔŋ nyǝntɛ. ");
INSERT INTO dop_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ɩlɛnɑ ɩ́ lǝsɩ kʋkʋsʋm fɛɩ potopotonɑɑ mpɑ pɑ hɑ Ɩsɔ tɔ, pɑ tɔkʋ tɑɑ kɛ́ pǝ kɑkɑlɑɣɑ kʋlʋmɑɣɑ, nɑ nim nyǝŋkɑ, nɑ tinte pɑɣɑlɛ, nɑ ɩ́ sɩɩ nɑntʋ nim nyǝntʋ nɑ ntɔɣɔŋ yule pǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Ɩlɛnɑ ɩ́ tʋ́ pǝ tǝnɑɣɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ niŋ tɑɑ, nɑ ɩ́ heeli-wɛ sɩ pɑ́ hɑ-tǝɣɩ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Pǝ wɑɑlɩ kɛ́ Moisi mʋ kʋhɑɑŋ ɩnǝɣɩ pɑ niŋ tɑɑ nɑ ɩ́ nyɑɣɑsɩ-ɩ kɔtɑɣɑ tǝlɑtɛ tɔɔ kɛ́ kɔtɑsɩ nsi kɔkɔ lusɑɑ tɔ sɩ tɔɔ. Kɔtǝlɑɑ tǝmlɛ tɑɑ sʋʋʋ kɔtɑɣɑ ntɛ. Pǝ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔlɛ. Pǝ sɔɔsʋŋ kɛ Tɑcɑɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ḿpʋ́ɣʋ́ Moisi kpɑɣɑ kɔtǝlɑɑ tǝmlɛ tɑɑ sʋʋʋ kɔtɑɣɑ kpǝntɛ lɑŋlɛ, nɑ ɩ́ hɑ Tɑcɑɑ kɛ kɔtɑɣɑ tǝlɑtɛ kiŋ. Ɩlɛnɑ nɑntʋɣʋ ŋkʋ kʋ pǝsɩ Moisi nyǝŋkʋ ɩsɩɩ Tɑcɑɑ kɑ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Pǝ wɑɑlɩ kɛ́ ɩ kpɑɣɑ kɔtɑɣɑ nim, nɑ cɑlǝm mpi pɩɩ wɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ tɔɣɔ pǝcɔ, nɑ ɩ́ ŋmɩɩsɩ Alɔŋ nɑ ɩ wontu tɔɔ. Nɑ ɩ pǝyɑlɑɑ nɑ pɛlɛ pɑ nyǝntʋ tɔɔ tɔtɔ. Ɩlɛnɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ nɑ pɑ wontu kʋsusuutu pɑ pǝsɩ Ɩsɔ nyǝm. ");
INSERT INTO dop_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ḿpʋ́ɣʋ́ Moisi heelɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ sɩ: Ɩ́ tǝsɩ heu ɑpɑlʋ nɑɑlɛ nyǝŋ nɑntʋ kɛ tǝsulle cokǝle nɔnɔɣɔ. Ɩlɛnɑ ɩ́ tɔɣɔ-tǝɣɩ tǝnɑɣɑ mǝ mɑɣɑmɑɣɑ, nɑ potopotonɑɑ mpɑ pɑ lɑpɑ kɔtɑɣɑ tɔɔ tɔ. Ɩsɩɩ mɑ kɛɛsʋɣʋ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ye pǝ kɑɑsɑ nɑntʋ yɑɑ potopoto, pǝ wɛɛ sɩ ɩ́ kɑ́ wɔ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ɩ́ kɑ́ cɑɣɑ tǝsulle cokǝle nɔnɔɣɔ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. Pǝ fɛɩ sɩ ɩ́ lɩɩ tǝnɑ. Hɑlǝnɑ mǝ tǝmlɛ tɑɑ sʋʋʋ kɔtɑɣɑ kʋyɑkʋ kɑncɑɑlɑɣɑ nɑ kɑntǝkɑɣɑ nyǝŋkʋ wule. ");
INSERT INTO dop_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Tɑcɑɑ mɑɣɑmɑɣɑ sɩɩnɑ sɩ pǝ́ lɑ ɩsɩɩ pǝ lɑpʋ sɑŋɑ ɩsǝntɔ tɔ. Ɩlɛnɑ pǝ́cɔ́ pǝ́ hɩɩsɩ mǝ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ɩ́ cɑɣɑ tǝsulle cokǝle nɔnɔɣɔ kɛ ilim nɑ ɑhoo kɛ wɛɛ nɑɑtosompɔɣɔlɑɣɑ ɩnɩ nɑ ɩ́ tɔkɩ Tɑcɑɑ kʋsǝsɩɩtʋ. Ɩlɛ ɩ́ kɑɑ sɩ́. Moisi sɩ: Nti Ɩsɔ heelɑ-m tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ḿpʋ́ɣʋ́ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ lɑpɑ nti Tɑcɑɑ kɑ heelɑ Moisi nɑ ɩ́ tɛlǝsɩ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ wule, Moisi yɑɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ nɑ Ɩsɛɣɛlɩ sɔsɑɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Ɩlɛnɑ ɩ́ heeli Alɔŋ sɩ: Cɑɑ nɑʋle nte tǝ tiili tɑ́ cɑɑmɩ nɑ pɑɑ lɑ-tɛɣɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ tɔ. Nɑ heu ɑpɑlʋ wei ɩ tiili tɑ́ cɑɑmɩ nɑ pɑɑ lɑpɩ-ɩ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, nɑ ń kɔnɑ pǝ nɑɑlɛɣɛ Tɑcɑɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Pǝ wɑɑlɩ, ɩlɛnɑ ń tʋ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ kɔnɑ pǝŋtʋlʋɣʋ ŋku pɑɑ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ tɔ. Nɑ pǝnɑɣɑ kʋlʋmɑɣɑ nɑʋle nɑ pǝ ɩwǝyɑɣɑ mpɑ pɑ tiili tɑ́ cɑɑmɩ, nɑ pɑɑ lɑ-wɛɣɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Nɑ nɑʋ nɑ heu ɑpɑlʋ nyǝŋ wei pɑɑ lɑ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ tɔ. Nɑ tɔɣɔnɑɣɑ kʋhɑʋ ŋku pɑ nuɣutinɑ nim tɔ. Mpi tɔ, sɑŋɑ mɑɣɑmɑɣɑ kɛ Tɑcɑɑ kɑ́ hʋlɩ-mɛɣɛ ɩ tɩ. ");
INSERT INTO dop_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Wɑɑtʋ wei pɑ kɔnɑ tǝsulle cokǝle nɔnɔɣɔ kɛ mpi mpi pǝ hǝlɑ Moisi yɑɑwɑ tɔ ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ kpǝtǝnɑ cokǝle ńtɛ́ nɑ pɑ́ sǝŋ Ɩsɔ tǝyɑɣɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ɩlɛnɑ Moisi tɔ sɩ: Nti Tɑcɑɑ tʋ-mɛ tɔɣɔlɛ. Ɩ́ lɑ-tɩ, nɑ Ɩsɔ teeli wɛɛ mǝ hɛkʋ. ");
INSERT INTO dop_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ḿpʋ́ɣʋ́ Moisi tɔmɑ Alɔŋ sɩ: Kpǝtǝnɑ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ nɑ ń lǝsɩ tǝ tɔɔ kɛ́ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Ɩlɛnɑ ń lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kɛ ɩ nɑ yǝlɑɑ pɑ nyɔɔŋ tɔɔ. Pǝ wɑɑlɩ, ɩlɛnɑ ń lɑ yǝlɑɑ nyɔɔŋ tɔɔ kɛ́ kɔtɑɣɑ, nɑ ń lɑ-wɛɣɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋkɑ, ɩsɩɩ Tɑcɑɑ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ḿpʋ́ɣʋ́ Alɔŋ kpǝtǝnɑ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ, nɑ ɩ́ lɛntɩ nɑʋle nɑ ɩ́ lɑ-tɛɣɛ ɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ɩlɛnɑ ɩ pǝyɑlɑɑ ponɑ-ɩ tǝ cɑlǝm nɑ ɩ́ lii pǝ tɑɑ kɛ́ mpǝle. Ɩlɛnɑ ɩ́ tɑɑ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ hǝlǝŋɑsɩ tɔɔ, nɑ ɩ́ pǝlɩ-wǝɣɩ tǝ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Kɛlɛnɑ ɩ́ nyɑɣɑsɩ tǝ tɔɔ kɛ́ kpǝntɛ nim cɔlɔ nim cɔlɔ. Nɑ timpee nɑ hɔɔlɛ, ɩsɩɩ Tɑcɑɑ tʋɣʋ Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Pǝ yelɑ nɑntʋ nɑ tɔnʋɣʋ, ɩlɛnɑ pɑ́ lɩɩnɑ tǝsikile wɑɑlɩ nɑ pɑ́ nyɑɣɑsɩ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ḿpʋ́ɣʋ́ Alɔŋ lɛntɑ heu ɑpɑlʋ nyǝŋ wei kɔkɔ lusiɣi ɩ tǝnɑ tɔ. Ɩlɛnɑ ɩ pǝyɑlɑɑ cɛlɛ-ɩ kpǝntɛ cɑlǝm nɑ ɩ́ ŋmɩɩsɩ-wǝɣɩ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Nɑ pɑ́ cɛlɛ-ɩ tɔtɔɣɔ tǝ nyʋɣʋ nɑ tǝ nɑntʋ nɑ pɑ́ sɛtɑ-tǝɣɩ tilimɑ, nɑ ɩ́ nyɑɣɑsɩ-tǝɣɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ɩlɛnɑ ɩ́ nyɑɑlɩ pǝ tɑɑ lotu nɑ nɔŋkpɑɑsɩ nɑ ɩ́ nyɑɣɑsɩ-tǝɣɩ nɑntʋ lɛntɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Pǝ wɑɑlɩ kɛ́ Alɔŋ lɑpɑ Tɑcɑɑ kɛ yǝlɑɑ kɔtɑsɩ. Ɩ kpɑɣɑ pǝŋtʋlʋɣʋ ŋku yǝlɑɑ kɑ kɔnɑ pɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ tɔɔ tɔ. Ɩlɛnɑ ɩ́ lɛntɩ-kʋ, nɑ ɩ́ lɑ́-kʋɣʋ kɔtɑɣɑ ɩsɩɩ ɩ kɑ lɑpʋ nɑʋle tɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ḿpʋ́ɣʋ́ ɩ lɑpɑ kpǝnɑ nɑɑlɛ ɩnǝɣɩ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, ɩsɩɩ pɑ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ɩlɛnɑ ɩ́ ponɑ tɔɣɔnɑɣɑ kʋhɑʋ, nɑ ɩ́ cosi ŋkute nɑ ɩ́ nyɑɣɑsɩ-tɛɣɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ, nɑ ɩ́ kpɛnnɑ pɑɑ kʋyɑkʋ ŋku kʋ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ḿpʋ́ɣʋ́ ɩ lɛntɑ nɑʋ nɑ heu ɑpɑlʋ wei yǝlɑɑ kɑ kɔnɑɑ sɩ pɑ lɑkɩ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ tɔ. Ɩlɛnɑ ɩ pǝyɑlɑɑ cɛlɛ-ɩ kpǝnɑ ɑnɩ ɑ cɑlǝm nɑ ɩ́ ŋmɩɩsɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kɔŋkɔmǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Nɑ pɑ́ cɛlɛ-ɩ tɔtɔɣɔ nɑʋ ɑpɑlʋ nyǝŋ nɑntʋ nim nyǝntʋ, nɑ heu ɑpɑlʋ nyǝŋ sukɑ, nɑ pǝ tɑɑ lotu tɔɔ nim nɑ timpee nɑ hɔɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Ɩlɛnɑ ɩ́ tǝnɩ nim cɔlɔ nim cɔlɔ nɑntʋnɑɑ mpɛɣɛ kpǝnɑ ɑnɩ ɑ nɑɑlɛ ɑ lɑŋɑ tɔɔ. Ɩlɛnɑ Alɔŋ nyɑɣɑsɩ nɑntʋ nim nyǝntʋ ntǝɣɩ kɔkɔ kɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Nɑ ɩ́ hɑ Tɑcɑɑ kɛ lɑŋɑ ɑnɩ nɑ ntɔɣɔŋ yule kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kiŋ kɛ teitei ɩsɩɩ Moisi kɑ kɛɛsʋɣʋ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Wɑɑtʋ wei Alɔŋ tɛmɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑsɩ nɑ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔ nɑ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ nyǝŋsɩ kɛ lɑpʋ, ɩlɛnɑ ɩ́ kpɑɑsɩ ɩ niŋ nɑ yǝlɑɑ tɔɔ nɑ ɩ́ tǝŋsɩ-wɛɣɛ nɔɣɔ kʋpɑŋkɑ. Ɩlɛnɑ ɩ́ lɩɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ nɑ ɩ́ tii. ");
INSERT INTO dop_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Ḿpʋ́ɣʋ́ Moisi nɑ Alɔŋ pɑ sʋʋʋ tǝsulle cokǝle tɑɑ. Wɑɑtʋ wei pɑ lɩɩwɑ, ɩlɛnɑ pɑ́ tǝŋsɩ yǝlɑɑ kɛ nɔɔsɩ kʋpɑŋsɩ. Ɩlɛnɑ Tɑcɑɑ teeli nɑ yǝlɑɑ tǝnɑ hɛkʋ. ");
INSERT INTO dop_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Tǝnɑɣɑ kɔkɔ kʋlɑɑ nɑ kɑ́ nyɑɣɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, nɑ nɑntʋ nim nyǝntʋ. Yǝlɑɑ tǝnɑ nɑ́ mpʋ, ɩlɛnɑ pɑ́ yɑɣɑ lɑŋhʋlʋmlɛ kɑkiisɑsɩ nɑ pɑ́ hoti pɑ ɩsɛntɔɔ kɛ́ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ḿpʋ́ɣʋ́ Alɔŋ pǝyɑlɑɑ nɑɑlɛ, Nɑtɑpɩ nɑ Apihu, pɑ kpɑɣɑ pɑ tulɑɑlʋ cofolonɑɑ nɑ pɑ́ hee kɔkɔ nɑ pɑ́ tʋ́ tulɑɑlʋ kɛ́ kɑ tɔɔ. Ɩlɛnɑ pɑ́ lɑ́ Tɑcɑɑ kɛ tulɑɑlʋ kɔtɑɣɑ kpɑɩ nyǝŋkɑ. Pɑ tɑ tǝŋ ɩsǝnɑ Ɩsɔ kɑ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Tǝnɑɣɑ kɔkɔ nɑkǝlɩ lɩɩnɑ cokǝle tɑɑ, nɑ kɑ́ nyɑɣɑ-wɛɣɛ kpɑkpɑɑ nɑ pɑ ɩsɛ. ");
INSERT INTO dop_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mpʋɣʋlɛ Moisi tɔmɑ Alɔŋ sɩ: Tɑcɑɑ tɛmɑ-mɛɣɛ-tǝɣɩ kpɑɑlʋɣʋ kɛ sɑɑ wei ɩ tɔŋɑɣɑ sɩ: Mɑ cɑɑkɩ kɛ́ sɩ mpɑ pɑ kpǝtǝɣǝnɑ-m tɔ, pɑ́ nyɑnɑ mɑ tǝnɑŋŋ wɛɛtʋ, nɑ pɑ́ tʋ-m teeli kɛ yǝlɑɑ tǝnɑ kiŋ. Ɩlɛnɑ sɔɣɔntʋ ɑnɑɑm pɩɩ Alɔŋ nɑ ɩ su tǝkulum. ");
INSERT INTO dop_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ḿpʋ́ɣʋ́ Moisi yɑɑ Alɔŋ cɑɑ tɑɑlʋ Wusiyɛlɩ pǝyɑlɑɑ, Mikɑyɛɛlɩ nɑ Ɩlisɑfɑŋ sɩ: Ɩ́ polo ɩ́ kpɑɣɑ mǝ tɛɛtʋnɑɑ mpɑ pɑ sǝpɑ tɔɣɔ cokǝle kiŋ, nɑ ɩ́ lɩɩnɑ nɑ ɩ́ hɑtǝlǝnɑ tǝsikile. ");
INSERT INTO dop_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ɩlɛnɑ pɑ́ polo pɑ lǝsɩ sǝtɑɑ mpɛ, nɑ pɑ cɑpɑnɑɑ kɛ tesikile wɑɑlɩ, ɩsɩɩ Moisi yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ḿpʋ́ɣʋ́ Moisi heelɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ lɛlɑɑ nɑɑlɛ, Ɩlɑsɑɑ nɑ Ɩtɑmɑɑ sɩ: Ɩ́ tɑɑ yele mǝ nyɔɔsɩ sɛɣɛlʋɣʋ, yɑɑ ɩ́ cǝlɩ mǝ wontu kɛ lǝ́yɑ́ɣɑ tɔɔ. Pǝ́ tɑɑ kɔɔ nɑ ɩ́ kɔnɑ mǝ tɔɔ kɛ́ sǝm, nɑ Tɑcɑɑ mʋ Ɩsɛɣɛlɩ kpekǝle tǝnɑ nɑ pɑ́ɑ́nɑ́. Ɩ́ yele mǝ tɛɛtʋnɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ cɑɣɑ mpɑ Ɩsɔ kʋnɑ kɔkɔ tɔ pɑ lǝ́yɑ́ɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Alɔŋ pɑ mɑɣɑmɑɣɑ pɑ́ tɑɑ hɑtǝlǝnɑ tǝsulle cokǝle nɔnɔɣɔ tǝnɑ. Pǝ́ tɑɑ kɔɔ nɑ pɑ́ sɩ́. Pǝ tɑɣɑ pʋlʋ, kɔtɑɣɑ nim mpi pɑ pǝlɑ-mɛ tɔ, pǝ pǝsɑ-mɛɣɛ Tɑcɑɑ tǝmlɛ nyǝ́mɑ kɛ́. Ḿpʋ́ɣʋ́ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ mʋwɑ Moisi tɔm ntɩ. ");
INSERT INTO dop_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Pǝ fɛɩ sɩ nyɑnɑ nyɑ́ pǝyɑlɑɑ mǝ tɑɑ nɔɣɔlʋ ɩ́ nyɔɔ sʋlʋm, yɑɑ kʋkʋkʋm nɑpǝlɩ, nɑ pǝ́cɔ́ ɩ́ sʋʋ tǝsulle cokǝle tɑɑ. Ye ɩ́ lɑpɑ mpʋ, ɩ́ kɑ́ sɩ. Kiiu ŋku pǝ wɛɛ sɩ mǝ nɑ mǝ lʋlʋɣʋ nyǝ́mɑ ɩ́ kɑ́ tɔkɩ tɑm tɔɔ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ɩlɛnɑ pǝ́cɔ́ ɩ́ pǝsɩ nɑ ɩ́ fɑɣɑsɩ Ɩsɔ nyǝm nɑ kpɑɩ nyǝm, nɑ ɑsilimɑ nɑ kʋpɑm. ");
INSERT INTO dop_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ɩ́ tɑɑ nyɔɔ-wɩ tɔtɔɣɔ wɑɑtʋ wei ɩ sɛɣɛsǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kiiŋ wei ɩ tǝnɑ Tɑcɑɑ kɑ hʋlɑ Moisi nɑ ɩ́ tɛlǝsɩ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ḿpʋ́ɣʋ́ Moisi heelɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ nɑɑlɛ, Ɩlɑsɑɑ nɑ Ɩtɑmɑɑ mpɑ pǝ kɑɑsɑ-ɩ tɔ sɩ: Ɩ́ kpɑɣɑ Tɑcɑɑ tɔɣɔnɑɣɑ kʋhɑʋ ŋku kɔkɔ nyɑɣɑɑ nɑ kʋ́ kɑɑsɩ tɔ. Ɩlɛnɑ ɩ́ tʋ́ kʋkʋsʋm fɛɩ kɑkɑlɑsɩ, nɑ ɩ́ tɔɣɔ-sǝɣɩ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kiŋ. Mpi tɔ, pǝ kɛ́ kɑtɛ tɑɑ kɑtɛ tɔɣɔnɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ɩsɔ lonte kɑtɛ nyǝntɛ tɑɑ kɛ́ ɩ́ kɑ́ tɔɣɔ-kɛ́. Tɑcɑɑ tɔɣɔnɑɣɑ kʋhɑʋ ŋku ɩ hɑ Alɔŋ nɑ ɩ piyɑ kɛ pɑ pɑɑ tete ɩsɩɩ ɩ kɑ heeluɣu-m tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Tɔlɑ wenɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɑkɩ nɔɣɔ kʋlʋmɑɣɑ kpɛntʋɣʋ kɔtɑɣɑ, nɑ pɑ́ hɑ lɑŋlɛ nɑ yule kɛ Tɑcɑɑ kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ kiŋ tɔ, tǝ pǝsɑ mǝ pɑɑ nyǝm kɛ́. Ɩlɛ nyɑnɑ nyɑ́ pǝyɑlɑɑ nɑ mǝ ɑlɑɑ nyǝ́mɑ ɩ́ kɑ́ tɔɣɔnɑ-tǝɣɩ lonte nɑŋŋ nyǝntɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Pǝ wɛɛ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ kɔnɑ yule nɑ lɑŋlɛ, nɑ pǝ́ sɔɔsǝnɑ nim cɔlɔ nim cɔlɔ nɑntʋ. Tǝlɛɣɛ kɔtǝlɑɑ wɔkɩ kɔkɔ kɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ kɛ́ wɑɑtʋ wei pɑ tɛmɑ-tǝɣɩ Tɑcɑɑ kɛ hɑʋ kɛ kɔtɑɣɑ tǝlɑtɛ kiŋ tɔ. Ɩlɛnɑ tǝ́ pǝsɩ nyɑnɑ nyɑ́ pǝyɑlɑɑ mǝ nyǝntʋ kɛ tɑm tɔɔ ɩsɩɩ Tɑcɑɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Ḿpʋ́ɣʋ́ Moisi pɛɛkɑ pǝŋtʋlʋɣʋ ŋku pɑ lɑpɑ kɔtɑɣɑ kɛ yǝlɑɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ tɔɔ tɔ kʋ tɔm. Ɩlɛnɑ ɩ́ nɩɩ sɩ pɑ nyɑɣɑsɑ-kʋɣʋ kɔkɔ. Ntɛnɑ ɩ́ mʋ pɑ́ɑ́nɑ́ nɑ Alɔŋ pǝyɑlɑɑ Ɩlɑsɑɑ nɑ Ɩtɑmɑɑ. Ḿpʋ́ɣʋ́ ɩ́ pɔɔsɑ-wɛ sɩ: ");
INSERT INTO dop_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Pepe tɔɔ kɛ́ ɩ́ tɑ́ tɔɣɔ kɔtɑɣɑ ŋkɛ kɑ nɑntʋ kɛ lonte kɑtɛ nyǝntɛ tɑɑ? Mpi pǝ tɔɔ tɔ, pǝ kɛ́ kɑtɛ tɑɑ kɑtɛ tɔɣɔnɑɣɑ kɛ́. Tɑcɑɑ kɑ hɑnɑ-mɛɣɛ kpǝntɛ ńtɛ́ sɩ ɩ́ wɑɑsɩ Ɩsɛɣɛlɩ kpekǝle kɛ pɑ kɑwɑlɑɣɑ. Ɩlɛnɑ ɩ́ lɑ́ pɑ nyɔɔŋ tɔɔ kɛ́ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ɩ kpǝntɛ cɑlǝm tɑ polo Ɩsɔ tǝyɑɣɑ tɑɑ, pɩɩ wɛɛ kɛ́ sɩ ɩ́ tɔɣɔ tǝ nɑntʋ kɛ lonte kɑtɛ nyǝntɛ tɑɑ, ɩsɩɩ mɑɑ heeluɣu-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Mpʋɣʋlɛ Alɔŋ cɔwɑ Moisi sɩ: Nyǝnɩ, sɑŋɑ kɛ mɑ pǝyɑlɑɑ lɑpɑ pɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Pǝcɔ n nyǝmɑ lɑŋwɑkǝllɛ nte tǝ mɑɣɑnɑ-m tɔ. Mɑɑ pǝsɩ nɑ mɑ́ tɔɣɔ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kpǝntɛ nɑntʋ nɑ? Tɑcɑɑ lɑŋlɛ kɑ́ hɛɛnɑ-m? ");
INSERT INTO dop_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Moisi nɩɩwɑ tɔm ntɩ, ɩlɛnɑ ɩ mʋ-tɩ. ");
INSERT INTO dop_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Ɩ́ tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, ɑtɛ tɔlɑ tɑɑ, nnɑ nnɑ ɩ́ kɑ́ tɔɣɔ tɔɣɔlɛ, ");
INSERT INTO dop_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","nnɑ ɑ ɑcʋwɑ fɑɣɑɑ, nɑ ɑ́ wɛnɑ tɑlɑsɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Amɑ pǝ fɛɩ sɩ ɩ́ tɔɣɔ yooyoo, nɑ pʋɣʋ nɑmɑɣɑ, nɑ kpɑcɑ. Tɔlɑ ɑnɩ ɑ wɛnɑ tɑlɑsɩ yɑɑ, ɩlɛ ɑ ɑcʋwɑ tɑ fɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Pǝ fɛɩ sɩ ɩ́ tɔɣɔ ɑfɑ tɔtɔ. Mpi tɔ, pɑɑ ɩ ɑcʋwɑ fɑɣɑɑ tɔ, ɩ fɛɩnɑ tɑlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Pǝ wɛɛ sɩ ɩ́ nyǝnɩ tɔlɑ ɑnǝɣɩ ɑsilimɑ nyǝnɑ kɛ́. Ɩ́ tɑɑ tɔɣɔ-yɛ. Pǝ́cɔ́ ɩ́ tɑɑ tokinɑ ɑ kʋsǝpɛɛ kɛ tokinɑʋ mɑɣɑmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ye pǝ kɑɑsɑ lʋm tɑɑ wontu ɩlɛ, ɩ́ tɔɣɔ tiinɑ wenɑ ɑ wɛnɑ lʋm yɑɑlǝŋ nɑ sɛtʋ tɔ. Ɩ́ kii wenɑ ɑ fɛɩnɑ mpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Pǝ kɑɑsʋɣʋ lʋm tǝnɑ tɑɑ wontu lɛntɩ, yɑɑ pǝ nyɑmɑnyɑmɑnɑɑ mpɑ pɑ fɛɩnɑ lʋm yɑɑlǝŋ nɑ sɛtʋ tɔ, pǝ kɛ́-mɛɣɛ ɑcɑɑlǝtʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ɩ́ nyǝnɩ-tǝɣɩ ɑsilimɑ, ɩ́ tɑɑ tɔɣɔ-tɩ, yɑɑ ɩ́ tokinɑ tǝ kʋsǝpǝtʋ. ");
INSERT INTO dop_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ɩ́ kii lʋm tɑɑ wontu tǝnɑ nti tǝ fɛɩnɑ lʋm yɑɑlǝŋ nɑ sɛtʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Sumɑsɩ nsi pǝ wɛɛ sɩ ɩ́ nyǝnɩ ɑsilimɑ nɑ ɩ́ kii sɩ tɔɣɔʋ tɔɣɔlɛ: Yepeleku, nɑ kpimle, nɑ hɛkǝlɛ, nɑ kɑtǝkɑtʋɣʋ, nɑ tɑɑtɑɑ, nɑ tɔɣɔnɑkpeluɣu, nɑ kʋlɑɑlʋɣʋ, nɑ tintɔkǝlɑɣɑ, nɑ sɛmʋɣʋ, nɑ sɩ piitimnɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Pǝ wɛɛ sɩ ɩ́ nyǝnɩ ɑsilimɑ kɛ nyɑmɑnyɑmɑnɑɑ mpɑ pɑ tǝnɑ pɑ wɛnɑ keŋ nɑ nɔɔhɛɛ liɣiti tɔ. ");
INSERT INTO dop_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Amɑ ɩ́ tɔɣɔ pɑ tɑɑ mpɑ pɑ wɛnɑ keŋ nɑ nɔɔhɛɛ liɣiti nɑ nɔŋkpɑɑsɩ nɑ pɑ́ ŋmɑɑkɩ tɛtʋ tɔɔ tɔ pɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Pɑ tɑɑ mpɑ ɩ́ kɑ́ tɔɣɔ tɔɣɔlɛ cǝlǝŋ nɑ ɩ looŋɑ tǝnɑ, nɑ kʋtoloŋ nɑ kʋ looŋɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Pǝ kɑɑsɑ lɛntɩ nti tǝ wɛnɑ keŋ nɑ nɔɔhɛɛ liɣiti tɔ, ɩ́ nyǝnɩ-tǝɣɩ ɑsilimɑ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","25","Wontu lɛntɩ wɛɛ, ye yʋlʋ ɩ́ kpɑɣɑ tǝ kʋsǝpǝtʋ, yɑɑ ɩ tɩɩ tokinɑ-tɩ, pǝ pilisɑ-ɩ kɛ́. Pǝ wɛɛ sɩ ɩ́ cɔtɔ ɩ wontu kʋsusuutu, nɑ ɩ́ cɑɣɑ ḿpʋ́ɣʋ́ ɑsilimɑ tɑɑ, hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","28","Nti nti pǝ wɛɛ sɩ ɩ́ nyǝnɩ ɑsilimɑ tɔɣɔlɛ nti tǝ ɑcʋwɑ tɑ fɑɣɑ, nɑ tǝ fɛɩnɑ tɑlɑsɩ tɔ. Nɑ nɔɔhɛɛ liɣiti nyǝntʋ tǝnɑ nti tǝ wɛnɑ sǝkpɑŋ tɔ. Ye wei ɩ́ kpɑɣɑ tǝ kʋsǝpǝtʋ pǝ wɛɛ sɩ ɩ́ cɔtɔ ɩ wontu nɑ ɩ́ cɑɣɑ ɑsilimɑ tɑɑ, hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Wontunɑɑ mpɑ ɩ́ kɑ́ nyǝnɩ ɑsilimɑ kɛ nti nti tǝ tɔŋ tǝ lotu tɔɔ tɔɣɔlɛ kʋtʋntʋlʋkpɑnɑɑ cɑmnɑ, nɑ mpiiu, nɑ cimlee, nɑ ɑ piitimnɑɑ, nɑ cɑŋɑsɩ. ");
INSERT INTO dop_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Wontu sǝkpetu ntɩ tǝ tɑɑ nti ɩ́ kɑ́ nyǝnɩ ɑsilimɑ tɔɣɔlɛ. Ye wei ɩ tokinɑ tǝ tɑɑ kʋsǝpʋɣʋ, ɩ kɑ́ wɛɛ ɑsilimɑ tɑɑ kɛ́, hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Ye tǝ kʋsǝpʋɣʋ hotɑ wontu nti pɑ lɑkǝnɑ tɔ tǝ tɑɑ nɑkʋlɩ tɑɑ, kʋlɛ kʋ pǝsɑ ɑsilimɑ kɛ́. Pɑɑ kʋsɑɑkǝm, pɑɑ wontu kʋsusuutu, yɑɑ tɔnʋɣʋ pʋlʋpʋ, yɑɑ huluɣu. Pɑɑ wontuɣu ŋku te, pǝ wɛɛ sɩ pɑ́ nyɑɑlɩ-kʋɣʋ nɑ lʋm nɑ kʋ cɑɣɑ ɑsilimɑ tɑɑ, hɑlǝnɑ tɑɑnɑɣɑ. Pǝ wɑɑlɩ kɛ pɑɑ nyǝnɩ-kʋɣʋ kʋpɑŋkʋ. ");
INSERT INTO dop_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ye cʋɣʋ tiyɑɣɑ tɑɑ kɛ́ tǝ tɑɑ nɑkʋlɩ hotɑɑ. Tiyɑɣɑ nɑ kɑ tɑɑ nyǝm tǝnɑ, pǝsǝɣɩ ɑsilimɑ kɛ́. Pǝ wɛɛ sɩ pɑ yɔkɩ-kɛ. ");
INSERT INTO dop_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ye pɑ pǝlɑ tiyɑɣɑ ŋkɛ kɑ tɑɑ lʋm kɛ tɔɣɔnɑɣɑ kʋpɑŋkɑ tɔɔ, kɛlɛ kɑ pǝsǝɣɩ ɑsilimɑ kɛ́. Yɑɑ pɩɩ kɛ kʋnyɔnyɔɔm kʋpɑm, pǝ pǝsǝɣɩ ɑsilimɑ tɔtɔɣɔ. Pɑɑ tiyɑɣɑ kɑ kɛ́ ŋkɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Pɑɑ mpi pǝ tɔɔ kɛ́ wontu tǝnɛ tǝ tɑɑ kʋsǝpʋɣʋ hotɑɑ, pɩɩ pǝsɩ ɑsilimɑ kɛ́. Ye pǝ kɛ́ potopotonɑɑ mǝsɑɣɑ, yɑɑ mǝsɑɣɑ kʋtǝsɑɣɑ tɑɑ kɛ kʋ hotɑɑ, pǝ wɛɛ sɩ pɑ́ yɔkɩ-kɛɣɛ. Mpi tɔ, pǝ kɛ-mɛɣɛ ɑsilimɑ kɛ́, nɑ ɩ́ kɑ́ nyǝnɩ-wǝɣɩ ɑsilimɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Amɑ ye ɩsɩɩ hite yɑɑ lɔkɔ tɑɑ kɛ́ wontuɣu kʋsǝpʋɣʋ hotɑɑ, lʋm kɑɑ pilisi. Ɩlɛ wei ɩ kɑ tokinɑ-kʋ tɔɣɔlɛ ɑsilimɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ye ɩsɩɩ pee wenɑ pɑ sɩɩwɑ sɩ pɑ tuuki tɔ, ɑ tɔɔ kɛ́ wontuɣu ŋkʋ kʋ kʋsǝpʋɣʋ hotɑɑ, ɑ kɑɑ pilisi. ");
INSERT INTO dop_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Amɑ ye kʋtɔtɔɣɔnɑ kɛ pɑ wʋsɑ lʋm, nɑ wontu ntɩ tǝ tɑɑ nɑkʋlɩ kʋsǝpʋɣʋ hoti pǝ tɑɑ, ɩlɛ ɑ pilisɑɑ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Ye ɩsɩɩ kpǝntɛ nte pɑ hɑ-mɛɣɛ mpɑɑ sɩ ɩ́ tɔɣɔ tɔ, tǝ sǝpɑ, nɑ nɔɣɔlʋ tokinɑ-tɛ, ɩ kɑ́ wɛɛ ɑsilimɑ tɑɑ kɛ́, hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Wei ɩ sǝɣǝlɑ kpǝntɛ ntɛ́, yɑɑ ɩ tɩɩ tɔɣɔ-tɛ, ɩ kɑ́ cɔtɔ ɩ wontu kɛ́, nɑ ɩ́ wɛɛ ɑsilimɑ tɑɑ, hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Pǝ wɛɛ sɩ ɩ́ kii nyɑmɑnyɑmɑnɑɑ mpɑ pɑ tɔŋ tɛtʋ tɔɔ tɔɣɔ, nɑ ɩ́ nyǝnɩ-wɛɣɛ ɑcɑɑlǝtʋ. ");
INSERT INTO dop_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Pɑɑ mpɑ pɑ tuuki, yɑɑ pɑ tɔŋ nɔɔhɛɛ liɣiti, yɑɑ nɔɔhɛɛ pɑɣɑlɛ tɔ. Pɑ kɛ-mɛɣɛ ɑcɑɑlǝtʋ kɛ́, pɑ fɛɩ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ɩ́ tɑɑ pilisi mǝ tɩ nɑ nyɑmɑnyɑmɑnɑɑ mpɛ pɑ tǝnɑ. Ɩ́ tɑɑ tɛlǝsɩ mǝ tǝɣɩ pɑ ɑsilimɑ. Pǝyele ɩ́ tɑɑ yele nɑ pɑ ɑsilimɑ tɛɛ-mɛ. ");
INSERT INTO dop_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mpi pǝ tɔɔ tɔ, mɑɣɑlɛ Tɑcɑɑ mǝ Ɩsɔ. Pǝ wɛɛ sɩ ɩ́ fɑɣɑsɩ mǝ tɩ nɑ ɩ́ wɛɛ tǝnɑŋŋ. Pǝ tɑɣɑ pʋlʋ, mɑ wɛɛ kɛ́ tǝnɑŋŋ. Ɩ́ tɑɑ pilisi mǝ tɩ nɑ nyɑmɑnyɑmɑnɑɑ mpɑ pɑ tɔŋ tɛtʋ tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Mɑɣɑlɛ Tɑcɑɑ, mɑ́ lǝsǝnɑ-mɛɣɛ Icipiti tɛtʋ tɑɑ sɩ ɩ nyǝnǝɣɩ-m mǝ Ɩsɔ. Mpʋ tɔ, ɩ́ wɛɛ tǝnɑŋŋ. Mpi tɔ, mɑ wɛɛ kɛ́ tǝnɑŋŋ. ");
INSERT INTO dop_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Kʋsǝsɩɩtʋ nti ɩ́ kɑ tɔkɩ tɔlɑ nɑ sumɑsɩ nɑ lʋm tɑɑ wontu nɑ tɛtʋ tɔɔ nyɑmɑnyɑmɑnɑɑ tɔm tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ntɩ tɩɩ fɑɣɑsǝnɑ-mɛɣɛ wontu kʋpɑntʋ nɑ ɑsilimɑ nyǝntʋ, nɑ nti tǝ wɛ tɔɣɔʋ nɑ nti tǝ fɛɩ tɔɣɔʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Heeli Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, ye ɑlʋ lɑpɑ teu, nɑ ɩ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ. Ɩ ɑsilimɑ kʋyɛɛŋ ntɛ́ nɑɑtosompɔɣɔlɑɣɑ, kɛ teitei ɩsɩɩ ɩ ɩsɔtʋ nɑʋ kʋyɛɛŋ. ");
INSERT INTO dop_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ɩlɛnɑ pɑ́ pɛlɩ pǝyɑɣɑ kɛ kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ wule. ");
INSERT INTO dop_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Pǝ wɑɑlɩ, ɩlɛnɑ ɑlʋ cɑɣɑ kʋyɛɛŋ hiu nɑ nɑɑnʋwɑ nɑ tooso, nɑ ɩ́ tɑɣɑnǝɣɩ ɩ cɑlǝm ɑsilimɑ. Pǝ fɛɩ sɩ ɩ́ wiili tǝsulle tɑɑ, yɑɑ ɩ́ tokinɑ Ɩsɔ pʋlʋpʋ. Hɑlǝnɑ ɩ ɑsilimɑ kʋyɛɛŋ tɛm. ");
INSERT INTO dop_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ye ɑlʋpǝyɑɣɑ kɛ ɑlʋ lʋlɑɑ, ɩlɛ ɩ cɑɣɑ ɑsilimɑ tɑɑ kɛ́ cimɑɑsǝnɑɑ nɑɑlɛ, ɩsɩɩ ɩ ɩsɔtʋ nɑʋ wɑɑtʋ. Pǝ wɑɑlɩ, ɩlɛnɑ ɩ́ lɑ kʋyɛɛŋ nɩɩtoso nɑ nɑɑtoso tɔtɔ nɑ ɩ́ tɑɣɑnǝɣɩ ɩ cɑlǝm ɑsilimɑ. ");
INSERT INTO dop_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Pɑɑ ɑpɑlʋpǝyɑɣɑ, yɑɑ ɑlʋpǝyɑɣɑ kɛ ɑlʋ lʋlɑɑ. Ɩ ɑsilimɑ kʋyɛɛŋ tɛŋ mpʋ, ɩlɛnɑ ɩ́ cɑɑ pǝ́nɑ́ɣɑ́ kʋlʋmɑɣɑ ɩwǝyɑɣɑ sɩ pɑ́ lɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Yɑɑ ɑlukuku, yɑɑ ɩhokɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kɔtʋlʋ tɛŋ kɔtɑsɩ nsǝɣɩ Tɑcɑɑ kɛ lɑpʋ ɩlɛnɑ ɩ́ lɑ ɑlʋ kɛ ɑsilimɑ hɩɩsʋɣʋ kɔtɑɣɑ. Ɩlɛnɑ Ɩsɔ tɑɣɑnɩ ɩ cɑlǝm ɑsilimɑ. Pɑɑ ɑlʋ lʋlɑ ɑpɑlʋpǝyɑɣɑ yɑɑ ɑlʋpǝyɑɣɑ kʋsǝsɩɩtʋ nti pɑɑ tɔkɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ye ɑsɔnʋɣʋ kɑɑ pǝsɩ nɑ kʋ hiki ɩwǝyɑɣɑ ɩlɛ, kʋ cɑɑ ɩhokɑsɩ nɑɑlɛ yɑɑ ɑlukukunɑɑ nɑɑlɛ. Ɩlɛnɑ pɑ́ lɑ sumɑɣɑ lɛŋkɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, nɑ lɛŋkɑ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋkɑ. Nɑ kɔtʋlʋ lɑpɩ-ɩ ɑsilimɑ kɛɛlʋɣʋ sɔɔsɩ, ɩlɛ pǝ tɑɣɑnɑ-ɩ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Ye mʋlɑɣɑ, yɑɑ kɑɑʋ, yɑɑ tʋlʋŋɑ lɩɩ yʋlʋ tɔnʋɣʋ tɔɔ, nɑ pǝ́ pǝsɩ tɔnʋɣʋ tɔɔ ɑsilimɑ kʋtɔŋ. Ɩlɛ pɑ ponɑ pʋntʋ kɛ kɔtʋlʋ Alɔŋ, yɑɑ ɩ pǝyɑlɑɑ tɑɑ nɔɣɔlʋ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Nɑ ɩ́lɛ́ ɩ́ wiilɑ-ɩ nɑ ɩ́ nɑ́ tǝwɩɩlɛ ńtɛ́ tǝ tɑɑ limɑɑ nɑ nyɔɔsɩ hʋlʋmɩ, ɩlɛ kʋtɔŋ ɑsilimɑ nyǝŋkʋ ntɛ́. Ɩlɛ kɔtʋlʋ kpɑɑlɩ kpɑkpɑɑ sɩ ɩ kɛ́ ɑsilimɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ye pǝ kɛ́ tʋlʋŋɑ yɑɑ tɑɣɑŋmɑtɛ, nɑ tǝwɩɩlɛ tɑ lim nɑ nyɔɔlɑɣɑ kʋhʋlʋmɑɣɑ fɛɩ, ɩlɛ kɔtʋlʋ sɩɩ kʋtɔntʋ nɑ ɩ mpɑɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ sikiɣi ɩlɛnɑ ɩ́ tɑsɑ kʋtɔntʋ kɛ wiiluɣu, ye ɩ nɑwɑ sɩ tǝwɩɩlɛ ńtɛ́ tǝ wɛ mpʋ tǝ tɑ lɑɣɑsɩ, ɩlɛ ɩ tɑsɑ-ɩ sɩɩʋ nɑ ɩ mpɑɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Kʋyɛɛŋ ɩnɩ ɩ́ tɛɛwɑ ɩlɛ kɔtʋlʋ tɑsɑ-ɩ wiiluɣu kɛ tɔm nɑɑlɛ nyǝm, ye tǝwɩɩlɛ ńtɛ́ tǝ sɑlɑ yem tǝ tɑ sɔɔsɩ ɩlɛ ɩ hʋlɩ sɩ pǝ tɑɣɑ kʋtɔŋ, pǝ kɛ́ lɩɩtʋ kɛ́, pǝ tɔɔ tɔ ɩ fɛɩ ɑsilimɑ. Ɩlɛnɑ ɩ́ cɔtɔ ɩ wontu nɑ ɩ́ pǝsɩ kʋpɑŋ. ");
INSERT INTO dop_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Amɑ ye kʋtɔntʋ tǝwɩɩlɛ ńtɛ́ tǝ sʋʋ wɑŋ kɛ pǝlɛ pǝ wɑɑlɩ ɩlɛ ɩ tɑɣɑnɩ mǝlʋɣʋ kɛ kɔtʋlʋ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ye ɩ́lɛ́ ɩ tɑsɑ-ɩ wiiluɣu nɑ ɩ́ nɑ́ sɩ tǝwɩɩlɛ wɑlɑɑ ɩlɛ ɩ hʋlɩ sɩ ɑsilimɑ kʋtɔŋ wɛnnɑ-ɩ. Ɩlɛ ɩ kɛ́ ɑsilimɑ tʋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ye kʋtɔŋ kʋsɛɛmʋɣʋ tɑkɑ kpɑ yʋlʋ, pɑ pukinɑ-ɩ kɔtʋlʋ tɛɣɛ. ");
INSERT INTO dop_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Ye ɩ wiilɑ-ɩ nɑ ɩ́ mɑɣɑnɑ tute kɛ ɩhʋlʋmɑʋ nɑ tǝ tɔɔ nɑ hiŋ nɑ tǝ nyɔɔsɩ hʋlʋmɑɑ ");
INSERT INTO dop_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ɩlɛ ɑsilimɑ kʋtɔŋ mɑɣɑmɑɣɑ kɛlɛ, pǝ fɛɩ sɩ pɑ́ tɑsɑ-ɩ sɩɩʋ kɛ kpeeŋɑ sɩ pɑ nɑɑkɩ tɔtɔ. Kɔtʋlʋ kɑ́ kpɑɑlɩ kɛ́ sɩ ɑsilimɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Amɑ ye ɑsilimɑ kʋtɔŋ lʋlɑ pee kɛ yʋlʋ tɔnʋɣʋ tǝnɑ kɛ pǝ kpɑɣɑʋ ɩ nyʋɣʋ nɑ pǝ́ polo ɩ nɔɔhɛɛ tɔ, ");
INSERT INTO dop_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ɩlɛ kɔtʋlʋ wiili kʋtɔntʋ kɛ teu, ye ɩ nɑwɑ sɩ kʋ wɑɑsɑ ɩ tɔnʋɣʋ tǝnɑ ɩlɛ ɩ hʋlɩ sɩ pǝ tɑ kɛ ɑsilimɑ. Mpi tɔ, ɩ tɔnʋɣʋ tǝnɑ hʋlʋmɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Amɑ kʋyɑkʋ ŋku pɑ́ nɑwɑ ɩ tɔɔ kɛ́ hiŋ ɩlɛ ɩ pǝsɑ ɑsilimɑ tʋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kɔtʋlʋ kɑ́ wiilinɑ-ɩ nɑ ɩ́ kpɑɑlɩ sɩ ɩ kɛ́ ɑsilimɑ tʋ. Mpi tɔ, ɩnɩ ɩ hʋlǝɣǝnɑ sɩ ɩ wɛnɑ ɑsilimɑ kʋtɔŋ, nɑ pǝ kɛ́ ɑsilimɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ye hiŋ mǝlǝɣɩ hʋlʋmǝŋ ɩlɛ kʋtɔntʋ mǝlɩ kɔtʋlʋ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ɩ́lɛ́ ɩ wiiliɣi-ɩ nɑ ɩ́ nɑ́ sɩ hiŋ hʋlʋmɑ tɑmpɑnɑ ɩlɛnɑ ɩ́ hʋlɩ sɩ ɩ tɑ kɛ ɑsilimɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Ye mʋtɛ kpɑ yʋlʋ nɑ tǝ́ wɑɑ ");
INSERT INTO dop_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","nɑ pǝ́ yele tǝwɩɩlɛ nɑ tǝ́ wɛ ɩhʋlʋmɑʋ yɑɑ ɩsɛɛʋ, pǝ wɛɛ sɩ ɩ́ nɑ́ kɔtʋlʋ. ");
INSERT INTO dop_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ɩ́lɛ́ ɩ kɑ́ wiili-ɩ nɑ ye ɩ mɑɣɑnɑ pǝ lɑpɑ tǝwɩɩlɛ kɛ lonte nɑ pǝ nyɔɔsɩ hʋlʋmɑɑ, ɩlɛ ɑsilimɑ kʋtɔŋ lɩɩkǝnɑ ntɛɣɛ mʋtɛ tɑɑ. Kɔtʋlʋ kɑ́ hʋlɩ sɩ ɩ kɛ́ ɑsilimɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Amɑ ye kɔtʋlʋ ɩ́ wiilɑ-ɩ nɑ ɩ́ nɑ́ sɩ tǝwɩɩlɛ mʋkɑɑ nɑ pǝ́ mǝlɩ hʋlʋmǝŋ nɑ nyɔɔsɩ kʋhʋlʋmɑsɩ fɛɩ ɩlɛ ɩ sɩɩ kʋtɔntʋ nɑ ɩ mpɑɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ye pǝ sɔɔsɑɑ ɩlɛ kɔtʋlʋ hʋlɩ sɩ ɩ wɛ ɑsilimɑ, sɑɑ ɩnɩ ɩlɛ ɑsilimɑ kʋtɔŋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ye tǝwɩɩlɛ ntɛ́ tǝ tɑ sɔɔsɩ ɩlɛ pǝ kɛ́ mʋtɛ tɔntɔɔlʋɣʋ ntɛ́. Pǝ wɛɛ sɩ kɔtʋlʋ ɩ́ hʋlɩ sɩ ɩ tɑ kɛ́ ɑsilimɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ye kɔkɔ nyɑɣɑ yʋlʋ nɑ pǝ lonte tɑɑ wɛɛ ɩhʋlʋmɑʋ yɑɑ ɩsɛɛʋ, ");
INSERT INTO dop_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","pǝ wɛɛ sɩ kɔtʋlʋ kɑ wiili-ɩ, ye ɩ nɑwɑ sɩ tǝwɩɩlɛ limɑɑ nɑ pǝ nyɔɔsɩ hʋlʋmɩ ɩlɛ ɑsilimɑ kʋtɔŋ sʋʋnɑ ntɛɣɛ kɔkɔ tǝnyɑɣɑlɛ tǝnɑ. Kɔtʋlʋ kɑ́ hʋlɩ sɩ ɩ kɛ́ ɑsilimɑ tʋ. Asilimɑ Kʋtɔŋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Amɑ ye kɔtʋlʋ wiilɑ-ɩ nɑ ɩ́ tɑ́ nɑ́ nyɔɔsɩ kʋhʋlʋmɑsɩ kɛ pǝ lonte tɑɑ. Pǝ́cɔ́ lonte tɑ lim sɩ pǝ tɔŋnɑ tɛm ɩlɛ kɔtʋlʋ sɩɩ-ɩ nɑ ɩ mpɑɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Kɔtʋlʋ kɑ wiili-ɩ kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule ye ɩ nɑwɑ sɩ tǝwɩɩlɛ wɑlɑ ɩ tɔnʋɣʋ tɔɔ, ɩlɛ ɩ hʋlɩ sɩ ɩ kɛ́ ɑsilimɑ tʋ. Asilimɑ kʋtɔŋ kʋsɛɛmʋɣʋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Amɑ ye tǝwɩɩlɛ ntɛ́ tǝ sɑɑlɑ mpʋ tǝ tɑ wɑlɩ tɔnʋɣʋ tɔɔ, tǝ pɑsɑ kʋpɑsʋ, ɩlɛ kɔkɔ hiŋ tɔntɔɔlʋɣʋ ntɛ́. Kɔtʋlʋ kɑ́ hʋlɩ sɩ ɩ tɑ kɛ ɑsilimɑ tʋ. Mpi tɔ, pǝ kɛ́ tɔntɔɔlʋɣʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Ye ɩsɩɩ kɑɑʋ yɑɑ lɩɩtʋ kpɑwɑ ɑpɑlʋ yɑɑ ɑlʋ nyʋɣʋ yɑɑ ɩ tɑmɑɣɑ, ");
INSERT INTO dop_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","kɔtʋlʋ kɑ wiili hiŋ ɩnɩ nɑ ye ɩ nɑwɑ sɩ tǝwɩɩlɛ limɑɑ nɑ pǝ nyɔɔsɩ sɛɛwɑ ɑtɑllɑ, nɑ sɩ́ tɑ́ yɑsǝlɩ ɩlɛ ɩ hʋlɩ sɩ kʋtɔntʋ kɛ́ ɑsilimɑ tʋ. Kɑɑʋ ntɛ́. Ḿpʋ́ɣʋ́ pɑ yɑɑ sɩ nyʋɣʋ yɑɑ tɑmɑɣɑ pǝ ɑsilimɑ kʋtɔŋ. ");
INSERT INTO dop_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ye kɔtʋlʋ nɑwɑ sɩ kɑɑʋ hiŋ tɑ lim pǝ́cɔ́ nyɔɔsɩ pilɑɑ ɩlɛ ɩ sɩɩ kʋtɔntʋ nɑ ɩ mpɑɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Kɔtʋlʋ kɑ wiili-ɩ kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule ye ɩ nɑwɑ sɩ kɑɑʋ tɑ sɔɔsɩ, pǝyele nyɔɔsɩ kʋsɛɛmɑsɩ fɛɩ nɑ hiŋ tɑ lim ");
INSERT INTO dop_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ɩlɛ kʋtɔntʋ looli ɩ nyʋɣʋ nɑ ɩ́ sɛkɩ timpi tɑɑ kʋtɔŋ wɛɛ tɔ nɑ kɔtʋlʋ tɑsɑ-ɩ sɩɩʋ kɛ tɔm nɑɑlɛ nyǝm nɑ ɩ mpɑɑ tɔtɔɣɔ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Kʋyɛɛŋ ɩnɩ ɩ tɛŋ ɩlɛnɑ ɩ́ tɑsɑ-ɩ wiiluɣu tɔtɔ. Ye pǝ tɑ sɔɔsɩ ɩlɛ ɩ hʋlɩ sɩ kʋtɔntʋ fɛɩ ɑsilimɑ. Ɩ wontu tike kɛ ɩ kɑ́ cɔtɔ ɩlɛnɑ ɩ pǝsɩ ɑsilimɑ fɛɩ tʋ. ");
INSERT INTO dop_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Amɑ ye pǝlɛ pǝ wɑɑlɩ kɛ kɑɑʋ sʋʋ wɑlʋɣʋ ");
INSERT INTO dop_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ɩlɛ ɩ tɑsɑ-ɩ wiiluɣu nɑ ye ɩ nɑwɑ sɩ kɑɑʋ tɔŋnɑ wɑlʋɣʋ kɛ tɑmpɑnɑ, ɩlɛ kʋtɔntʋ kɛ́ ɑsilimɑ tʋ ntɛ́ pǝ fɛɩ sɩ ɩ́ nɔkɩ pɛɛkʋɣʋ kɛ nyɔɔsɩ kʋsɛɛmɑsɩ. ");
INSERT INTO dop_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ye tǝwɩɩlɛ ntɛ́ tǝ tɑɑ tɑ́ sɔɔsɩ nɑ nyɔɔsɩ kʋkpɛɛtɑsɩ wɛɛ, ɩlɛ kʋtɔŋ tɛmɑɣɑlɛ, pʋntʋ fɛɩ ɑsilimɑ tɔtɔ. Pǝ wɛɛ kɛ́ sɩ kɔtʋlʋ ɩ́ hʋlɩ sɩ ɩ fɛɩ ɑsilimɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Ye ɑpɑlʋ yɑɑ ɑlʋ nɑwɑ ɩ tɔnʋɣʋ tɔɔ kɛ́ tʋlʋŋɑsɩ kʋhʋlʋmɑsɩ ");
INSERT INTO dop_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ɩlɛ kɔtʋlʋ wiili-ɩ, ye sɩ tɑ sɛɛ teu ɩlɛ pǝ tɑɣɑ kʋtɔŋ ɩsɑɣɑʋ ntɛ. Pʋntʋ tɑ kɛ ɑsilimɑ tʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Ye yʋlʋ nyʋɣʋ lɛɛsɑɑ, pɑɑ kʋ tɑɑ yɑɑ ɩ tokuɣu tɑɑ, ɩ tɑ kɛ ɑsilimɑ tʋ nyʋŋlɛɛsʋɣʋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Amɑ ye tǝlɛɛsǝlɛ tɑɑ tǝnɑɣɑ pǝ lɑpɑ mʋlɑɣɑ nɑ kɑ hʋlʋmɩ ɩsɛɛʋ ɩlɛ ɑsilimɑ kʋtɔŋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ye kɔtʋlʋ wiilɑ mʋlɑɣɑ ŋkɛ nɑ ɩ́ nɑ́ kɑ hʋlʋmɑ ɩsɛɛʋ kɛ tɑmpɑnɑ ɩsɩɩ ɑsilimɑ kʋtɔŋ ");
INSERT INTO dop_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ɩlɛ yʋlʋ ɩnɩ ɩ wɛnɑ ɑsilimɑ kʋtɔŋ ntɛ́, ɩ kɛ́ ɑsilimɑ tʋ nɑ pǝ wɛɛ sɩ kɔtʋlʋ ɩ́ hʋlɩ mpʋ. Ɩ nyʋɣʋ tɑɑ kɛ́ kʋtɔŋ ŋkʋ kʋ kpɑwɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Wontu kʋcǝlǝtʋ kɛ pǝ wɛɛ sɩ ɑsilimɑ kʋtɔŋ tʋ ɩ́ suu nɑ ɩ́ yele ɩ nyʋɣʋ kɛ tɑɣɑnʋɣʋ, nɑ ɩ́ tɑkɩ ɩ tɑntǝŋ tɔɔ nɑ ɩ́ kpɑɑlǝɣɩ sɩ: Asilimɑ yoo, ɑsilimɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ye ɑsilimɑ kʋtɔŋ ɩ́ wɛnɑ wei ɩ pǝsɑ ɑsilimɑ tʋ kɛ́, nɑ pǝ wɛɛ sɩ ɩ́ hɑtǝlǝnɑ yǝlɑɑ nɑ ɩ́ cɑɣɑ tesikile wɑɑlɩ kɛ ɩ tike. ");
INSERT INTO dop_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ye hʋŋkpʋsʋlɑɣɑ yɑɣɑ tʋlʋŋɑsɩ kɛ heeŋ hʋntʋ wontu kʋsusuutu yɑɑ kpoŋkpontu toŋ nyǝntʋ tɔɔ, ");
INSERT INTO dop_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","yɑɑ pǝ pɔɔŋ yɑɑ pǝ kuntunɑɑ yɑɑ kɔŋɑ yɑɑ tɔnǝŋ wontu tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Ɩlɛnɑ tʋlʋŋɑsɩ nsɩ sɩ wɛ ɑtɔntɔɔtɛ tɑkɑ yɑɑ ɩsɛɛʋ, ɩlɛ pǝ wɛɛ sɩ kɔtʋlʋ ɩ́ wiili-sɩ. ");
INSERT INTO dop_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ɩ tɛŋ sɩ wiiluɣu ɩlɛnɑ ɩ́ sɩɩ hʋŋkpʋsʋlɑɣɑ tʋlʋŋɑ wontuɣu ŋkʋ nɑ kʋ mpɑɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ye kɔtʋlʋ tɑsɑ wiiluɣu kɛ kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule nɑ ɩ́ nɑ́ sɩ tʋlʋŋɑ sɔɔsɑ wɑŋ ɩlɛ pǝ kɛ́ hʋŋkpʋsʋlɑɣɑ ŋkɑ pɑ kɑɑ pǝsɩ nɑ pɑ́ lɑ́ nɑ kɑ́ tɛ́ tɔɣɔlɛ. Wontuɣu ŋkʋ kʋ pǝsɑ ɑsilimɑ pʋlʋpʋɣʋlɛ. ");
INSERT INTO dop_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Pǝ wɛɛ sɩ kɔtʋlʋ ɩ́ nyɑɣɑsɩ kɔkɔ kɛ wontuɣu ŋku ɩnɩ kʋ tɔɔ wɛ hʋŋkpʋsʋlɑɣɑ tɔɣɔ. Mpi tɔ, pɑ kɑɑ pǝsɩ nɑ pɑ́ lɑ nɑ kɑ́ tɛ́. Pǝ tɔɔ tɔ pǝ wɛɛ sɩ pɑ́ nyɑɣɑsɩ-kʋɣʋ kɔkɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Amɑ ye kɔtʋlʋ wiilɑɑ nɑ ɩ́ mɑɣɑnɑ sɩ tʋlʋŋɑ tɑ sɔɔsɩ wɑŋ kɛ wontuɣu ŋkʋ kʋ tɔɔ, ");
INSERT INTO dop_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ɩlɛ ɩ yele nɑ pɑ́ cɔtɔ-kʋ nɑ pɑ́ sɩɩ-kʋ nɑ kʋ mpɑɑ kɛ tɔm nɑɑlɛ nyǝm tɔtɔɣɔ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ye ɩ tɑsɑ-kʋɣʋ wiiluɣu kɛ kʋ cɔtʋɣʋ wɑɑlɩ nɑ ɩ́ nɑ́ sɩ tʋlʋŋɑ tɑ lɑɣɑsɩ yɑɑsi, pɑɑ kɑ tɑ wɑlɩ, pɑɑ nyǝnɩ-kʋɣʋ ɑsilimɑ kɛ́ nɑ pɑ́ nyɑɣɑsɩ-kʋɣʋ kɔkɔ. Mpi tɔ, lonte kʋlʋmtǝlɛ kɛ pǝ tɔɣɔ wontuɣu tɑɑ nɑ kʋ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ye wɑɑtʋ wei kɔtʋlʋ wiilɑɑ tɔ ɩ nɑwɑ sɩ kʋ cɔtʋɣʋ wɑɑlɩ tʋlʋŋɑ sɑlɑɑ ɩlɛ ɩ kɛɛsǝnɑ kɑ lonte tɑɑ nɑ ɩ́ sɛtɩ. ");
INSERT INTO dop_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Amɑ ye tʋlʋŋɑ tɑɣɑnɑ lɩɩʋ kɛ wontuɣu ŋkʋ kʋ tɔɔ, pǝ wɛɛ sɩ kʋtɔŋ tɔŋnɑ pɩɩʋ ntɛ́. Mpʋ tɔ, wontuɣu ŋkʋɣʋ pɑɑ nyɑɣɑsɩ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ye pɑ cɔtɑ tʋlʋŋɑ wontuɣu nɑ kɑ́ hɩɩsɩ, pǝ wɛɛ sɩ pɑ́ tɑsɑ kʋ cɔtʋɣʋ kɛ tɔm nɑɑlɛ nyǝm kɛ́ nɑ pǝ́cɔ́ kʋ ɑsilimɑ tɛ́. ");
INSERT INTO dop_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ye hʋŋkpʋsʋlɑɣɑ yɑɣɑ tʋlʋŋɑsɩ kɛ heeŋ hʋntʋ wontu kʋsusuutu yɑɑ kponkpontu toŋ nyǝntʋ yɑɑ pǝ pɔɔŋ yɑɑ pǝ kuntunɑɑ yɑɑ kɔŋɑ yɑɑ tɔnǝŋ wontu tɔɔ. Kʋsǝsɩɩtʋ nti pɑɑ tǝŋ nɑ pɑ́ hʋlǝnɑ sɩ tǝ kɛ́ ɑsilimɑ nyǝntʋ yɑɑ kʋpɑntʋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Kʋsǝsɩɩtʋ nti ɩ́ kɑ́ tɔkɩ kʋyɑkʋ ŋku ɩ́ lɑkɩ polom kɛ ɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ tɔɣɔlɔ. Ɩ́ pukinɑ-ɩ kɔtʋlʋ, ");
INSERT INTO dop_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ɩlɛnɑ ɩ́lɛ́ ɩ lɩɩ tǝsikile tɑɑ nɑ ɩ́ wiili-ɩ, ye ɩ mɑɣɑnɑɑ sɩ pǝ tɛmɑ kʋtɔntʋ, ");
INSERT INTO dop_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ɩlɛ ɩ tʋ-ɩ nɑ ɩ́ cɑɑ sumɑsɩ nsi sɩ wɛnɑ sɩ ɩsɛ nɑ sɩ́ fɛɩnɑ ɑsilimɑ tɔɣɔ nɑɑlɛ nɑ tʋɣʋ sɔsɔɔʋ nɑkʋlɩ kʋ tɑɑsɩ nɑ heeŋ hʋntʋ nti pɑ lii ɑkpɑɑyɑlɑ kʋsɛɛm tɔ nɑ nyɩɩlʋɣʋ ŋku pɑ yɑɑ sɩ hisɔpʋ tɔ kʋ piliŋɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Pǝ wɑɑlɩ ɩlɛnɑ ɩ́ yele nɑ pɑ́ lɛntɩ sumɑsɩ nsɩ sɩ tɑɑ lɛŋkɑ kɛ sɛɛlʋ lʋm hɛɛʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ye pǝ kɑɑsɑ sumɑɣɑ ɩsɛ nyǝŋkɑ ɩlɛ ɩ kpɑɣɑ kɛlɛ nɑ tʋɣʋ sɔsɔɔʋ nɑkʋlɩ kʋ tɑɑsɩ, nɑ heeŋ hʋntʋ nti pɑ lii ɑkpɑɑyɑlɑ kʋsɛɛm tɔ nɑ hisɔpʋ piliŋɑ nɑ ɩ́ ŋmilisi pǝ tǝnɑɣɑ sumɑɣɑ ŋkɑ pɑ kʋwɑ sɛɛlʋ lʋm hɛɛʋ tɔɔ tɔ kɑ cɑlǝm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ɩlɛnɑ ɩ́ ŋmɩɩsɩ wei ɩnɩ ɩ kʋtɔŋ tɛmɑ mpʋ tɔ ɩ tɔɔ kɛ́ tɔm nɑɑtosompɔɣɔlɑɣɑ. Ɩ tɛŋ hʋlʋɣʋ sɩ ɩ fɛɩnɑ ɑsilimɑ ɩlɛnɑ ɩ́ yele sumɑɣɑ ɩsɛ nyǝŋkɑ nɑ kɑ́ sʋʋ nyɩɩtʋ. ");
INSERT INTO dop_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ɩlɛnɑ ɩnɩ ɩ́ cɔtɔ ɩ wontu nɑ ɩ́ hʋ ɩ tɔnʋɣʋ tɔɔ nyɔɔsɩ, nɑ ɩ́ sɔ lʋm ɩlɛnɑ ɩ ɑsilimɑ tɛ́. Pǝ wɑɑlɩ kɛ́ ɩ sʋʋkɩ tǝsikile. Amɑ ɩ kɑɑ sʋʋ ɩ cokǝle tɑɑ kɛ́, hɑlǝnɑ kʋyɑkʋ siki. ");
INSERT INTO dop_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule kɛ ɩ looliɣi ɩ nyʋɣʋ nɑ ɩ tɑntʋɣʋ nɑ ɩ ɩsǝhutu nɑ ɩ nyɔɔsɩ tǝnɑ, nɑ ɩ́ cɔtɔ ɩ wontu nɑ ɩ́ sɔ lʋm. Ɩlɛ ɩ ɑsilimɑ kɛɛlɑɑ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Pǝ tɑkɩ kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ wule ɩlɛnɑ kʋtɔntʋ wei pǝ wɑɑwɑ mpʋ tɔ ɩ́ cɑɑ ɩwɛɛsɩ ɑpɑlʋ nyǝŋsɩ nsi sɩ tiili tɑ́ cɑɑmɩ tɔɣɔ nɑɑlɛ nɑ ɑlʋnyǝŋkɑ ŋkɑ kɑ tiili tɑ cɑɑmɩ tɔɣɔ kʋlʋmɑɣɑ, nɑ kʋhɑʋ mʋlʋm mpi pɑ nuɣutinɑ nim tɔɣɔ kiloonɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ, nɑ nim liitili titite. ");
INSERT INTO dop_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kɔtʋlʋ wei ɩnɩ ɩ lɑkɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ tɔ ɩ kɑ́ sɩɩ yʋlʋ ɩnɩ nɑ kʋhɑɑŋ kɛ tǝsulle cokǝle nɔnɔɣɔ kɛ Tɑcɑɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ɩlɛnɑ ɩ́ kpɑɣɑ ɩwɛɛsɩ nsɩ sɩ tɑɑ lɛŋkɑ nɑ ɩ́ lɑnɑ-kɛɣɛ tɑɣɑnʋɣʋ kɔtɑɣɑ nɑ nim liitili titite. Ɩlɛnɑ ɩ́ hɑ Tɑcɑɑ kɛ pǝ nɑɑlɛɣɛ ḿpʋ́ɣʋ́ kɔtɑɣɑ tǝlɑtɛ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ɩlɛnɑ ɩ́ kʋ ɩwǝyɑɣɑ kɛ Ɩsɔ lonte tɑɑ timpi pɑ kʋɣɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ yɑɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ kɑ kpǝntɛ tɔ. Kɔtʋlʋ tǝnnɑ tɑɣɑnʋɣʋ kɔtɑɣɑ kpǝntɛ ɩsɩɩ pǝ wɛʋ ɩsɑɣɑtʋ tɑɣɑnʋɣʋ kɔtɑɣɑ tɔm tɑɑ tɔ. Pǝ kɛ́ kɑtɛ tɑɑ kɑtɛ pʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Ɩlɛnɑ kɔtʋlʋ lii kpǝntɛ cɑlǝm tɑɑ nɑ ɩ́ tɑɑ wei ɩ tɑɣɑnǝɣɩ ɩ tɩ tɔ ɩ ŋkpɑŋʋɣʋ ntɔɣɔŋ nyǝŋkʋ nɔɣɔ tɑɑ, nɑ ɩ niŋ ntɔɣɔŋ ɑpɑlʋmpǝle nɑ ɩ ɑpɑlʋnɔmpǝle ntɔɣɔŋ nyǝntɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Ɩlɛnɑ ɩ́ kpɑɣɑ nim liitili titite ńtɛ́ nɑ ɩ́ pǝlɩ ɩ niŋ mpǝtǝŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Nɑ ɩ́ lii ɩ ntɑntɑkʋ tɑɑ nim mpɩ pǝ tɑɑ kɛ́ mpǝle ntɔɣɔŋ nyǝntɛ nɑ ɩ́ ŋmɩɩsɩ tɔm nɑɑtosompɔɣɔlɑɣɑ kɛ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Ɩlɛnɑ ɩ́ tɑɑ nim mpi pǝ kɑɑsɑ ɩ niŋ mpǝtǝŋ tɑɑ tɔɣɔ wei ɩnɩ ɩ tɑɣɑnǝɣɩ ɩ tɩ tɔ ɩ ŋkpɑŋʋɣʋ ntɔɣɔŋ nyǝŋkʋ, nɑ ɩ ntɔɣɔŋ ɑpɑlʋmpǝle, nɑ ɩ ɑpɑlʋnɔmpǝle tɔɔ timpi pɑɑ tɛmɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kpǝntɛ cɑlǝm kɛ tɑɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ɩlɛnɑ ɩ́ pǝle ɩ niŋ tɑɑ nim kʋkɑɑsǝm kɛ wei ɩ tɑɣɑnǝɣɩ ɩ tɩ tɔ ɩ nyʋɣʋ tɑɑ nɑ ɩ́ lɑpɩ-ɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ kɛ Ɩsɔ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Ɩlɛnɑ kɔtʋlʋ lǝsɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ kʋcɔɔʋ nɑ ɩ́ lɑ́ pǝ kɔtɑɣɑ kɛ wei ɩ tɑɣɑnǝɣɩ ɩ tɩ tɔ ɩ tɔɔ. Pǝ wɑɑlɩ ɩlɛnɑ ɩ́ kʋ́ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ kɑ kpǝntɛ. ");
INSERT INTO dop_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ɩlɛnɑ kɔtʋlʋ lɑ Ɩsɔ kɔtɑɣɑ tǝlɑtɛ tɔɔ kɛ́ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ nɑ kʋhɑʋ nyǝŋkɑ. Pǝ wɑɑlɩ ɩlɛnɑ ɩ́ lɑ́ yʋlʋ ɩnǝɣɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ nɑ ɩ ɑsilimɑ tɛ́. ");
INSERT INTO dop_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ yɔɣɔtʋɣʋ sɩ: Ye polom kɛ́ kʋnyɔntʋ nɑ ɩ́ fɛɩnɑ sɔsɔm, ɩlɛ ɩ cɑɑ ɑsilimɑ kɛɛlʋɣʋ ɩwǝyɑɣɑ kʋlʋmɑɣɑ ŋkɑ pɑɑ hɑ Tɑcɑɑ mɑ́ nɑ pǝ́ kɛɛlɩ kʋtɔntʋ ɑsilimɑ tɔ. Nɑ ɩ́ cɑɑ mʋlʋm kʋpɑm mpi pɑ nuɣutinɑ nim tɔɣɔ kiloonɑɑ tooso nɑ nim liitili titite, ");
INSERT INTO dop_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","nɑ ɩhokɑsɩ nɑɑlɛ yɑɑ ɑlukukunɑɑ nɑɑlɛ. Pǝ tɑɑ mpi ɩ kɑ hiki tɔ. Nɑ pɑ́ lɑnɑ lɛlʋ kɛ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ, nɑ lɛlʋ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Pǝ tɑkɩ kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ ɩlɛnɑ ɩ́ ponɑ kʋhɑɑŋ ɩnǝɣɩ kɔtʋlʋ kɛ tǝsulle cokǝle nɔnɔɣɔ kɛ Tɑcɑɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Ɩlɛnɑ kɔtʋlʋ kpɑɣɑ ɩwǝyɑɣɑ nɑ nim nɑ ɩ́ hɑ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Kɔtʋlʋ tɛŋ ɑsilimɑ kɛɛlʋɣʋ ɩwǝyɑɣɑ kɛ lɛntʋɣʋ ɩlɛnɑ ɩ́ lii cɑlǝm tɑɑ nɑ ɩ́ tɑɑ ɑsilimɑ tʋ ŋkpɑŋʋɣʋ ntɔɣɔŋ nyǝŋkʋ nɔɣɔ tɑɑ, nɑ ɩ́ tɑɑ tɔtɔɣɔ ɩ niŋ ntɔɣɔŋ ɑpɑlʋmpǝle nɑ ɩ ɑpɑlʋnɔmpǝle ntɔɣɔŋ nyǝntɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ɩlɛnɑ kɔtʋlʋ pǝlɩ nim kɛ ɩ ntɑntɑkʋ mpǝtǝŋ nyǝŋkʋ tɑɑ, ");
INSERT INTO dop_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","nɑ ɩ́ lii pǝ tɑɑ kɛ́ ɩ ntɔɣɔŋ mpǝle nɑ ɩ́ ŋmɩɩsɩ kɔtɑɣɑ tǝlɑtɛ tɔɔ kɛ́ tɔm nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ɩlɛnɑ ɩ́ tɑɑ ɩ niŋ tɑɑ nim mpǝɣɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ lɑtʋ ntɔɣɔŋ ŋkpɑŋʋɣʋ nɔɣɔ tɑɑ, nɑ ɩ́ tɑɑ-wɩ tɔtɔɣɔ ɩ ɑpɑlʋmpǝle ntɔɣɔŋ nyǝntɛ nɑ ɩ ɑpɑlʋnɔmpǝle ntɔɣɔŋ nyǝntɛ pǝ tɔɔ kɛ lonɑ nnɑ ɑ tɑɑ pɑɑ tɑɑwɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kpǝntɛ cɑlǝm tɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ɩlɛnɑ kɔtʋlʋ pǝlɩ ɩ niŋ tɑɑ nim kʋkɑɑsǝm kɛ yʋlʋ ɩnɩ ɩ nyʋɣʋ tɑɑ, nɑ ɩ́ lɑpɩ-ɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ kɛ Tɑcɑɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Pǝ wɑɑlɩ ɩlɛnɑ kɔtʋlʋ kpɑɣɑ ɩhokɑsɩ yɑɑ ɑlukukunɑɑ mpɑ kʋtɔntʋ pǝsɑɑ nɑ ɩ́ kɔnɑ tɔ pɑ tɑɑ kɛ́ kʋlʋm ");
INSERT INTO dop_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","nɑ ɩ́ lɑpɩ-ɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ nɑ lɛŋkɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ nɑ pǝ tɔɣɔnɑɣɑ kʋhɑʋ. Ɩlɛnɑ kɔtʋlʋ lɑ yʋlʋ ɩnǝɣɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ kɛ Tɑcɑɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Kʋsǝsɩɩtʋ nti pǝ wɛɛ sɩ polom kʋnyɔntʋ ɩ́ tɔkɩ ɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ lɑpʋ tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Ye ɩ́ kɔmɑ nɑ ɩ́ sʋʋ Kɑnɑɑŋ tɛtʋ nti mɑ hɑ-mɛ tɔ tǝ tɑɑ, ɩlɛnɑ kʋyɑkʋ nɑkʋlɩ ɩ́ nɑ́ mɑ yelɑɑ nɑ hʋŋkpʋsʋlɑɣɑ tʋlʋŋɑ yɑɣɑ mǝ kutuluɣu nɑkʋlɩ kʋ koluŋɑ tɔɔ kɛ́ tɛtʋ nti ɩnɩ tɩɩ pǝsɩ mǝ nyǝntʋ kɛ mpʋ tɔ tǝ tɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Ɩlɛ tǝyɑɣɑ tʋ polo nɑ ɩ́ heeli kɔtʋlʋ sɩ ɩ nɑwɑ pʋlʋɣʋ ɩ tǝyɑɣɑ tɑɑ nɑ pǝ́ nǝɣǝsǝnɑ ɩsɩɩ ɑsilimɑ kʋtɔŋ tʋlʋŋɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ɩlɛnɑ kɔtʋlʋ yɔɣɔtɩ nɑ pɑ́ lɑɑsɩ kutuluɣu ŋkʋ kʋ tɑɑ wontu tǝnɑ nɑ pǝ́cɔ́ ɩ polo tʋlʋŋɑ ŋkɛɣɛ mɑɣɑsʋɣʋ. Ɩlɛ kutuluɣu ŋkʋ kʋ tɑɑ wontu tǝnɑ kɑɑ pǝsɩ ɑsilimɑ pʋlʋpʋ. Pǝ wɑɑlɩ kɛ́ kɔtʋlʋ mǝlǝɣɩ nɑ ɩ́ tɑsɑ kutuluɣu ŋkʋ kʋ tʋlʋŋɑ kɛ mɑɣɑsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ye kɑ wɛ ɑtɔntɔɔtɛ yɑɑ ɩsɛɛʋ nɑ kɑ́ tɑwɑ kutuluɣu kɛ lonte, ");
INSERT INTO dop_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ɩlɛ kɔtʋlʋ lɩɩnɑ kutuluɣu ŋkʋ kʋ nɔnɔɣɔ nɑ ɩ́ tǝkɩ-kɛɣɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ sikiɣi ɩlɛnɑ kɔtʋlʋ mǝlɩ nɑ ɩ́ tɑsɑ mɑɣɑsʋɣʋ, ye ɩ nɑwɑ sɩ tʋlʋŋɑ ŋkɛ kɑ sɔɔsɑ wɑŋ kɛ kutuluɣu koluŋɑ tɔɔ ");
INSERT INTO dop_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ɩlɛ kɔtʋlʋ yele nɑ pɑ́ lǝsɩ pɛɛ wenɑ tʋlʋŋɑ ŋkɛ kɑ hikɑɑ tɔ nɑ pɑ́ lɔ-yɛɣɛ ɩcɑtɛ wɑɑlɩ kɛ hute tɑɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Ɩlɛnɑ kɔtʋlʋ yele nɑ pɑ́ kɑɑlɩ pǝ tɑɑ tɔɔ kɛ timpi pɑɑ tɑɑwɑ tɔ nɑ pɑ lɔ pǝ tɛtʋ kɛ hute tɑɑ kɛ́ ɩcɑtɛ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Pǝ wɑɑlɩ ɩlɛnɑ pɑ́ cɑɑ pɛɛ kʋfɑnɑ nɑ pɑ́ lɛɛtɩ kɑncɑɑlɑɣɑ nyǝnɑ lonɑ, nɑ pɑ́ lɑ́ tɛtʋ nɑ pɑ́ tɑɣɑnɩ kutuluɣu kɛ tɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ye kutuluɣu tɑɣɑnʋɣʋ wɑɑlɩ kɛ tʋlʋŋɑ tɑsɑ lɩɩʋ, ");
INSERT INTO dop_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ɩlɛ kɔtʋlʋ kɑ́ mǝlɩ nɑ ɩ́ tɑsɑ mɑɣɑsʋɣʋ, ye ɩ nɑwɑ sɩ tʋlʋŋɑ ŋkɛ kɑ sɔɔsɑɑ ɩlɛ ɑsilimɑ kʋtɔŋ kʋtɛtɛɛʋ ntɛ́. Pɑ́ nyǝnɩ kutuluɣu ŋkʋɣʋ ɑsilimɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Pǝ wɛɛ sɩ pɑ́ yɔkɩ kutuluɣu ŋkʋ, nɑ kʋ pɛɛ nɑ kʋ lɔpʋtʋ, nɑ tɛtʋ nti pɑɑ tɑɑwɑ-kʋ tɔ nɑ pɑ́ kuu nɑ pɑ́ ponɑ ɩcɑtɛ wɑɑlɩ kɛ hute tɑɑ nɑ pɑ́ lɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Ye wei ɩ́ sʋʋ kutuluɣu ŋkʋ kʋ tɑɑ kɛ́ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ wei ɩ tɑɑ pɑ tǝkɑ-kʋɣʋ mpʋ tɔ, pʋntʋ kɛ́ ɑsilimɑ tʋ kɛ́ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Wei ɩ́ hǝntɑ kʋ tɑɑ, yɑɑ ɩ cɑɣɑɑ nɑ ɩ́ tɔɣɔ pʋlʋ, pǝ wɛɛ sɩ ɩ́ cɔtɔ ɩ wontu kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ye kɔtʋlʋ mǝlɑ kutuluɣu ŋkʋ kʋ tɑɑ kɛ́ kʋtɔŋ mɑɣɑsʋɣʋ nɑ ɩ́ nɑ́ sɩ pǝ kpɑɣɑʋ sɑɑ wei pɑ tɑɑ-kʋ tɔ tʋlʋŋɑ tɑ tɑsɑ lɩɩʋ, ɩlɛ kɔtʋlʋ hʋlɩ sɩ kutuluɣu fɛɩ ɑsilimɑ. Mpi tɔ, kʋtɔŋ tɛmɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Tǝyɑɣɑ tɑɣɑnʋɣʋ tɔm tɑɑ ɩlɛ, kɔtʋlʋ kɑ́ cɑɑ sumɑsɩ nɑɑlɛ, nɑ tʋɣʋ sɔsɔɔʋ nɑkʋlɩ kʋ tɑɑsɩ, nɑ heeŋ hʋntʋ nti pɑ lii ɑkpɑɑyɑlɑ kʋsɛɛm tɔ, nɑ tʋɣʋ ŋku pɑ yɑɑ hisɔpʋ tɔ kʋ piliŋɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Pǝ wɑɑlɩ ɩlɛnɑ ɩ́ yele nɑ pɑ́ lɛntɩ sumɑsɩ nsɩ sɩ tɑɑ lɛŋkɑ kɛ sɛɛlʋ lʋm hɛɛʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Pǝ wɑɑlɩ ɩlɛnɑ ɩ́ kpɑɣɑ tʋɣʋ sɔsɔɔʋ tɑɑsɩ nɑ hisɔpʋ piliŋɑ, nɑ heeŋ hʋntʋ nti pɑ lii ɑkpɑɑyɑlɑ kʋsɛɛm tɔ, nɑ sumɑɣɑ lɛŋkɑ, nɑ ɩ́ lii pǝ tǝnɑɣɑ sumɑɣɑ ŋkɑ pɑ kʋwɑ tɔ kɑ cɑlǝm tɑɑ nɑ sɛɛlʋ lʋm tɑɑ, nɑ ɩ́ ŋmɩɩsɩ kutuluɣu ŋkʋ kʋ tɔɔ kɛ tɔm nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ɩlɛ ɩ kpiisɑ kutuluɣu ŋkʋ kʋ ɑsilimɑ ntɛ́ nɑ wontunɑɑ mpɛ. ");
INSERT INTO dop_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ɩlɛnɑ ɩ́ yele sumɑɣɑ ɩsɛ nyǝŋkɑ kɛ ɩcɑtɛ wɑɑlɩ nɑ kɑ sʋʋ nyɩɩtʋ. Ɩlɛnɑ ɩ́ lɑ́ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ kɛ kutuluɣu tɔɔ, ɩlɛ kʋ pǝsɑ ŋku kʋ fɛɩnɑ ɑsilimɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Kʋsǝsɩɩtʋ nti pɑɑ tɔkɩ ɑsilimɑ kʋtɔŋ nɑ kɑɑʋ nɑ pǝ looŋɑ tɑɑ nyǝŋ tǝnɑ ");
INSERT INTO dop_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","nɑ hiŋ nɑ lɩɩtʋ nɑ tʋlʋŋɑsɩ nsi sɩ teeki kɔkɔ tɔ, yɑɑ hʋŋkpʋsʋlɑɣɑ tʋlʋŋɑsɩ nsi sɩ lɩɩkɩ wontu kʋsusuutu nɑ kutuluŋ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Asilimɑ kʋtɔŋ kʋsǝsɩɩtʋnɑɑ ntɛ́, ntɩ tɩɩ hʋlǝnɑ sɑɑ wei ɑsilimɑ wɛɛ nɑ sɑɑ wei ɑ fɛɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Ɩ́ tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ ye cɑsɑɣɑ kpɑ ɑpɑlʋ, lʋm mpi pǝ kpeŋnɑ-ɩ tɔ pǝ kɛ́ ɑsilimɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Kɑ́ tɩɩ lɑɑlɑɑ nɑ kɑ́ kpɑ-ɩ te, pɑɑ pǝ kpeŋnɑ-ɩ yɑɑ pɩɩ kpeŋnɑ-ɩ ɩ kɛ́ ɑsilimɑ tʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kʋhǝntǝŋ wei ɩ tǝnɑ ɩ tɔɔ ɑpɑlʋ ɩnɩ ɩ kɑ́ hǝntɩ yɑɑ kʋcɑcɑɣɑm tǝnɑ mpi pǝ tɔɔ ɩ kɑ́ cɑɣɑ tɔ pǝ pilisɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","6","Ye wei ɩ́ tokinɑ ɩ kʋhǝntʋɣʋ ŋkʋ yɑɑ ɩ cɑɣɑ ɩ tǝcɑɣɑlɛ, pǝ wɛɛ sɩ ɩ́ cɔtɔ ɩ wontu kɛ́ nɑ ɩ́ sɔ lʋm nɑ ɩ́ cɑɣɑ ɑsilimɑ tɑɑ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","11","Ye wei ɩ tokinɑ kʋtɔntʋ ɩnɩ yɑɑ ɩ́lɛ́ ɩ tokinɑ-ɩ nɑ ɩ́ tɑ sɑŋ, yɑɑ ɩ tɔ́ nɔɣɔlʋ tɔɔ kɛ́ ntɑɣɑmɑ yɑɑ pʋntʋ tokinɑ pʋlʋ mpi pǝ tɔɔ kʋtɔntʋ cɑɣɑɑ tɔ yɑɑ ɩ tɩɩ sǝɣǝlɑ-wɩ, pǝ wɛɛ sɩ ɩ́ cɔtɔ ɩ wontu kɛ́ nɑ ɩ́ sɔ lʋm nɑ ɩ́ cɑɣɑ ɑsilimɑ tɑɑ hɑlǝnɑ tɑɑnɑɣɑ. Pɑɑ kpɑɣɑnʋkpete nte tǝ tɔɔ kɛ́ ɩ cɑɣɑɑ nɑ ɩ́ polo ɩcɑtɛ tǝ pǝsɑ ɑsilimɑ pʋlʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ye cʋɣʋ wontuɣu kɛ kʋtɔntʋ ɩnɩ ɩ tokinɑɑ pǝ wɛɛ sɩ pɑ́ yɔkɩ-kʋɣʋ. Amɑ ye tʋɣʋ nyǝŋkʋ ɩlɛ pɑ nyɑɑlɩ-kʋɣʋ lʋm kɛ teu. ");
INSERT INTO dop_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ye pǝ tɛmɑ kʋtɔntʋ ɩnɩ, ɩlɛ ɩ tɑŋ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ nɑ ɩ́ cɔtɔ ɩ wontu nɑ ɩ́ sɔ sɛɛlʋ lʋm, ɩlɛ ɩ kɛɛlɑ ɑsilimɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ tɑkɩ ɩlɛnɑ ɩ́ cɑɑ ɩhokɑsɩ nɑɑlɛ yɑɑ ɑlukukunɑɑ nɑɑlɛ nɑ ɩ́ ponɑ tǝsulle cokǝle nɔnɔɣɔ nɑ ɩ́ cɛlɑ kɔtʋlʋ. ");
INSERT INTO dop_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Nɑ ɩ́lɛ́ ɩ lǝsɩ sumɑɣɑ lɛŋkɑ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ lɛŋkɑ kɛ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Ɩlɛnɑ ɩ́ lɑpɩ-ɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ kɛ ɩ kʋtɔŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Ye yʋlʋ ɑpɑlʋtʋ kpemɑ pǝ wɛɛ sɩ ɩ́ sɔ lʋm kɛ́ nɑ ɩ́ nyǝnɩ ɩ tǝɣɩ ɑsilimɑ tʋ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ye pǝ tɑɑnɑ ɩ wontu kʋsusuutu yɑɑ ɩ tɔnʋɣʋ tɔɔ pʋlʋ, pǝ wɛɛ sɩ ɩ́ cɔtɔ kɛ́ nɑ ɩ́ nyǝnɩ ɩ tǝɣɩ ɑsilimɑ tʋ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ye ɑpɑlʋ nɑ ɑlʋ pɑ kpɛntɑɑ pǝ wɛɛ sɩ pɑ́ sɔ lʋm kɛ́, nɑ pɑ́ nyǝnɩ pɑ tǝɣɩ ɑsilimɑ nyǝ́mɑ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Ye ɑlʋ nɑɑkɩ ɩsɔtʋ ɩ pǝsɑ ɑsilimɑ tʋ kɛ́ hɑlǝnɑ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. Ye wei ɩ tokinɑ-ɩ wɑɑtʋ ɩnɩ pʋntʋ pǝsɑ ɑsilimɑ tʋ tɔtɔɣɔ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Pɑɑ nyɑɑlʋɣʋ kɛ ɩ hǝntɑɑ yɑɑ kpete tɔɔ kɛ́ ɩ cɑɣɑɑ, tǝ pǝsǝɣɩ ɑsilimɑ nyǝntɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","22","Ye wei ɩ tokinɑ nyɑɑlʋɣʋ ŋkʋ yɑɑ kpete ntɛ́ ɩ kɑ cɔtɔ ɩ wontu kɛ́ nɑ ɩ́ sɔ lʋm nɑ ɩ́ nyǝnɩ ɩ tǝɣɩ ɑsilimɑ tʋ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ye pʋlʋpʋ tokinɑ kʋhǝntʋɣʋ ŋkʋ yɑɑ kpete ntɛ́, ɩlɛnɑ nɔɣɔlʋ nɑ́ɑ́ tokinɑ-wɩ ɩ pǝsɑ ɑsilimɑ tʋ kɛ́ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ye yʋlʋ hǝntǝɣǝnɑ ɩ ɑlʋ nɑ pǝ́ pɑnɑ sɩ ɩ́lɛ́ ɩ ɩsɔtʋ nɑʋ kʋyɑkʋ ntɛ́, nɑ pǝ́ lɩɩ nɑ pǝ́ tokǝnɑ ɑpɑlʋ, pǝ wɛɛ sɩ ɑpɑlʋ ɩnɩ ɩ́ nyǝnɩ ɩ tǝɣɩ ɑsilimɑ tʋ tɔtɔɣɔ, hɑlǝnɑ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. Pɑɑ kʋhǝntʋɣʋ ŋku kʋ tɔɔ kɛ́ pɑɑ wɛɛ, kʋlɛ kʋ pǝsɑ ɑsilimɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Ye ɑlʋ ɩsɔtʋ nɑʋ kʋyɛɛŋ kǝlɑ ɩsɩɩ ɩ tɩɩ nɑɑkɩ tɔ, yɑɑ cɑlǝm kpeŋnɑ-ɩ yem nɑ pǝ́ tɑ́ kɛ́ ɩ ɩsɔtʋ nɑʋ kʋyɛɛŋ, ɩ kɛ́ ɑsilimɑ tʋ tɔtɔɣɔ wɛɛ ɑnɩ ɑ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kʋhǝntǝŋ wei ɩ tǝnɑ ɩ tɔɔ ɑlʋ ɩnɩ ɩ kɑ́ hǝntɩ yɑɑ kʋcɑcɑɣɑm tǝnɑ mpi pǝ tɔɔ ɩ kɑ́ cɑɣɑ tɔ pǝ pilisɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ye wei ɩ tokinɑ nyɑɑlʋɣʋ ŋkʋ yɑɑ kʋcɑcɑɣɑm mpɩ, pǝ wɛɛ sɩ ɩ́ cɔtɔ ɩ wontu kɛ́ nɑ ɩ́ sɔ lʋm nɑ ɩ́ nyǝnɩ ɩ tǝɣɩ ɑsilimɑ tʋ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ye cɑlǝm lɩɩʋ sǝŋɑɑ ɩlɛ, ɩ tɑŋ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ, ɩlɛ ɩ ɑsilimɑ tɛmɑɣɑlɛ. ");
INSERT INTO dop_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ tɑkɩ ɩlɛnɑ ɩ́ ponɑ kɔtʋlʋ kɛ ɩhokɑsɩ nɑɑlɛ yɑɑ ɑlukukunɑɑ nɑɑlɛɣɛ tǝsulle cokǝle nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Ɩlɛnɑ kɔtʋlʋ lǝsɩ sɩ tɑɑ lɛŋkɑ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ lɛŋkɑ kɛ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Pǝ wɑɑlɩ ɩlɛnɑ ɩ́ lɑ ɑlʋ kɛ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ kɛ Tɑcɑɑ kiŋ tǝnɑ nɑ pǝ́ kɛɛlɩ ɩ ɑsilimɑ. ");
INSERT INTO dop_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Moisi nɑ Alɔŋ kɛ heeluɣu sɩ: Ɩ́ tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ ɩ́ tɑɑ kpǝtǝnɑ tǝsulle cokǝle kɛ mǝ ɑsilimɑ wɑɑtʋnɑɑ. Pǝ́ tɑɑ kɔɔ nɑ mɑ́ kʋ-mɛ sɩ ɩ́ pilisɑ mɑ tǝcɑɣɑlɛ nte tǝ wɛ mǝ hɛkʋ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","33","Ye kʋtɔŋ kpɑnɑ ɑpɑlʋ nɑ lʋm kpeŋnɑ-ɩ, yɑɑ ɩ ɑpɑlʋtʋ kpemnɑ, yɑɑ ɑlʋ nɑɑkɩ ɩsɔtʋ yɑɑ kʋtɔŋ kpɑ-ɩ nɑ cɑlǝm kpeŋnɑ-ɩ, yɑɑ ɩ́ nɑ ɑpɑlʋ pɑ kpɛntɑ ɩ sɑŋʋɣʋ wɑɑtʋ. Kʋsǝsɩɩtʋnɑɑ mpɑ ɩ́ kɑ́ tɔkɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Wɑɑtʋ wei Alɔŋ pǝyɑlɑɑ nɑɑlɛ kɔnɑ kɔtɑɣɑ tulɑɑlʋ kpɑɩ nyǝŋ nɑ pɑ́ sɩ́ tɔ, pǝ wɑɑlɩ kɛ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Heeli nyɑ́ tɑɑlʋ Alɔŋ sɩ ɩ́ tɑɑ sʋʋkɩ yem yem kɛ́ pʋʋɣʋ kʋkɑkɑɣɑʋ wɑɑlɩ kɛ́ kɑtɛ tɑɑ kɑtɛ tǝcɑɣɑlɛ tɑɑ kɛ́ timpi Ɩsɔ ɑtɑkɑɑ wɛɛ tɔ. Pǝ́ tɑɑ kɔɔ nɑ ɩ́ sɩ́ sɑɑ wei Ɩsɔ tiiki ɑtɑkɑɑ pǝle tɔɔ kɛ́ ɩsɔŋmʋntʋ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Pǝ tɔɔ tɔ, ye ɩ cɑɑkɩ kɑtɛ tǝcɑɣɑlɛ tɑɑ kɛ́ sʋʋʋ pǝ wɛɛ sɩ ɩ́ cɑɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ lɑtǝcɛ kʋfɑlʋ nɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ pǝ ɩwɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ɩlɛnɑ ɩ́ sɔ lʋm nɑ ɩ́ suu kɔtɑɣɑ wontu. Ɩsɩɩ kponkpontu toŋ nyǝntʋ kɔmsɑ, nɑ pǝ toko, nɑ pǝ tɑmpɑlɑ, nɑ pǝ nyʋɣʋ sɑɑlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Ɩsɛɣɛlɩ kpekǝle nyǝ́mɑ kɑ cɛlɛ-ɩ tɔtɔɣɔ ɩsɑɣɑtʋ hɩɩsʋɣʋ pǝŋtʋlʋŋ kɛ nɑɑlɛ, nɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusiɣi kɑ tǝnɑ tɔ kɑ ɩwɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ɩlɛnɑ Alɔŋ kɔnɑ lɑtǝcɛ nɑ ɩ́ lɑ kɔtɑɣɑ kɛ ɩ mɑɣɑmɑɣɑ ɩ ɩsɑɣɑtʋ tɔɔ. Ɩ tɛŋ mpʋ ɩlɛnɑ ɩ́ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kɛ ɩ nyʋɣʋ tɔɔ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ nyɔɔŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Pǝ wɑɑlɩ ɩlɛnɑ Alɔŋ ponɑ pǝŋtʋlʋŋ ɩnɩ ɩ nɑɑlɛ nɑ ɩ́ sɩɩ-ɩ Tɑcɑɑ ɩsɛntɑɑ kɛ tǝsulle cokǝle nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Ɩlɛnɑ Alɔŋ tɔ tɛtɛ kɛ́ pǝŋtʋlʋŋ ɩnɩ ɩ nɑɑlɛ ɩ tɔɔ nɑ pǝ́ hʋlɩ-ɩ Tɑcɑɑ nyǝŋkʋ nɑ ɩlɔɣɔʋ Asɑsɛɛlɩ nyǝŋkʋ. lɛlɑɑ sɩ lonte wʋlɑɣɑ nyǝntɛ tǝlǝɣɩ pɑ yɑɑ mpʋ. Lɛlɑɑ sɩ ɩlɔɣɔʋ ɩsɑɣɑʋ nɔɣɔlʋ wei ɩ cɑkɩ timpi pǝ wɛ sɔɣɔntʋ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ɩlɛnɑ ɩ́ lǝsɩ pǝŋtʋlʋɣʋ ŋku tɛtɛ tɔɣɑɑ sɩ kʋ kɛ́ Tɑcɑɑ nyǝŋkʋ tɔɣɔ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pǝ kɑɑsǝɣɩ pǝŋtʋlʋɣʋ ŋku tɛtɛ tɔɣɑɑ sɩ ɩlɔɣɔʋ nyǝŋkʋ ɩlɛnɑ ɩ́ lɑ́ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ ɩ́ sɩɩ-kʋɣʋ Tɑcɑɑ kiŋ nɑ kʋ ɩsɛ nɑ sɑmɑɑ ɩsɑɣɑtʋ mǝlɩ kʋ nyʋɣʋ tɑɑ, ɩlɛnɑ pɑ́ ponɑ-kʋɣʋ wʋlɑɣɑ tɛtʋ tɑɑ nɑ pɑ́ tisi-kʋɣʋ ɩlɔɣɔʋ Asɑsɛɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Wɑɑtʋ wei Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩ Icipiti tɑɑ, ɩlɛnɑ pǝnɑɣɑ siki. Pǝ tɑlɑ nɑɑlɛ nyǝŋkɑ ɩsɔtʋ nɑɑlɛ nyǝŋ, kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ wule, ɩlɛnɑ Tɑcɑɑ heeli Moisi kɛ Ɩsɔ nɑ ɩ yǝlɑɑ pɑ tǝsulle cokǝle nte pɑ lɔpǝnɑ pɔɔŋ tɔ tǝ tɑɑ kɛ́ Sinɑyi wʋlɑɣɑ tɛtʋ tɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Nyɑ́ nɑ Alɔŋ ɩ́ kɑlɑ Ɩsɛɣɛlɩ yǝlɑɑ, nɑ ɩ́ tʋ́ pɑ hǝlɑ kɛ tɑkǝlɑsɩ tɑɑ. Nɑ pǝ́ kɛɛsǝnɑ pɑ lʋlʋŋ nɑ pɑ tɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Pǝ kpɑɣɑʋ ɩfepiyɑ mpɑ pɑ wɛnɑ pɩɩsɩ hiu nɑ wɑɑlɩ, nɑ pɑ́ mʋnɑ pɑ polo yoou tɔ. Nɑ pǝ́ kɛɛsǝnɑ Ɩsɛɣɛlɩ yoolɑɑ tintikɑ. ");
INSERT INTO dop_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Pɑɑ kpekǝle nte tǝ lʋlʋŋ nyʋɣʋ tʋ ɩ́ sɔɔsɩ mǝ tɔɔ nɑ pɑ́ sǝnɑ-mɛ. ");
INSERT INTO dop_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Mpɛ ɩnɩ pɑ hǝlɑ ntɔ: Lupɛŋ kpekǝle tɑɑ nyǝŋ ntɛ́ Setewu pǝyɑlʋ Ilisuu. ");
INSERT INTO dop_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simiyɔŋ nyǝntɛ tɑɑ kɛ́ Sulisɑtɑɩ pǝyɑlʋ Selumǝyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Yutɑ nyǝntɛ tɑɑ kɛ́ Aminɑtɑpɩ pǝyɑlʋ Nɑsɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Ɩsɑkɑɑ nyǝntɛ tɑɑ kɛ́ Suwɑɑ pǝyɑlʋ Netɑneyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Sɑpulɔŋ nyǝntɛ tɑɑ kɛ́ Helɔŋ pǝyɑlʋ Ɩliyɑpɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yosɛɛfʋ pǝyɑlʋ Ɩfǝlɑyim nyǝntɛ tɑɑ kɛ́ Amihuti pǝyɑlʋ Ɩlisɑmɑ. Yosɛɛfʋ pǝyɑlʋ nɑɑlɛ nyǝŋ Mɑnɑsee nyǝntɛ tɑɑ kɛ́ Petɑsuu pǝyɑlʋ Kɑmliyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Pɛncɑmɛɛ nyǝntɛ tɑɑ kɛ́ Kitoni pǝyɑlʋ Apitɑŋ. ");
INSERT INTO dop_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Tɑŋ nyǝntɛ tɑɑ kɛ́ Amisɑtɑɩ pǝyɑlʋ Ahiyesɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asɛɛ nyǝntɛ tɑɑ kɛ́ Okǝlɑŋ pǝyɑlʋ Pɑkiyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Kɑtɩ nyǝntɛ tɑɑ kɛ́ Teuwɛlɩ pǝyɑlʋ Ɩliyɑsɑfɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nɛfǝtɑli nyǝntɛ tɑɑ kɛ́ Ɩnɑŋ pǝyɑlʋ Ahilɑ. ");
INSERT INTO dop_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ɩsɛɣɛlɩ lʋlʋŋ nyʋɣʋ nyǝ́mɑ mpɑ pɑ lǝsɑ mpʋ tɔɣɔlɛ yoolɑɑ nyʋɣʋ nyǝ́mɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Ḿpʋ́ɣʋ́ Moisi nɑ Alɔŋ pɑ sɔɔsɑ ɑpɑlɑɑ nɑɑnʋwɑ nɑ nɑɑlɛ ɩnǝɣɩ pɑ tɔɔ sɩ pɑ́ sǝnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Pɑ́ koti yǝlɑɑ tǝnɑɣɑ ɩsɔtʋ nɑɑlɛ nyǝŋ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ. Pɑ́ tʋ́ ɑpɑlɑɑ mpɑ pɑ wɛnɑ pɩɩsɩ hiu nɑ wɑɑlɩ tɔ pɑ hǝlɑ kɛ tɑkǝlɑɣɑ tɑɑ, nɑ pǝ́ kɛɛsǝnɑ pɑ lʋlʋŋ nɑ pɑ tɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Holɛpʋ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ Moisi kɑlɑ kʋkɑlʋɣʋ ŋkʋ, ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Ḿpʋ́ɣʋ́ pɑ kɑlɑ pɑɑ Ɩsɛɣɛlɩ kpekǝle nte tǝ lʋlʋɣʋ, nɑ tǝ tɛɛsɩ nyǝ́mɑ. Nɑ pɑ́ tʋ́ ɑpɑlɑɑ mpɑ pɑ tɑlɑ pɩɩsɩ hiu nɑ wɑɑlɩ, nɑ pɑ́ mʋnɑ yoou pote tɔ pɑ hǝlɑ kɛ tɑkǝlɑɣɑ tɑɑ. Yɑkɔpʋ pǝyɑlʋ sɔsɔ Lupɛŋ kpekǝle kɛ pɑ cɑɑlǝnɑɑ. Pɑ nyʋɣʋ ntɔ: Lupɛŋ kpekǝle nyǝ́mɑ wɛ iyisi nɩɩlɛ nɑ nɑɑtoso nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (46500). Simiyɔŋ nyǝ́mɑ nyǝntɛ kɛ iyisi pɔɣɔlɑɣɑfɛɩ nɩɩtoso nɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (59300). Kɑtɩ nyǝ́mɑ nyǝntɛ kɛ iyisi nɩɩlɛ nɑ kɑkpɑsɩ nɑ nɑsǝtoso nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (45650). Yutɑ nyǝ́mɑ nyǝntɛ kɛ iyisi nɩɩtoso nɑ nɑɑnʋwɑ nɑ liɣiti nɑ nɑsǝtoso (74600). Ɩsɑkɑɑ nyǝ́mɑ nyǝntɛ kɛ iyisi nɩɩlɛ nɑ nɑɑnʋwɑ nɑ liɣiti nɑ nɑsǝlɛ (54400). Sɑpulɔŋ nyǝ́mɑ nyǝntɛ kɛ iyisi nɩɩlɛ nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ nɑ nɑsǝlɛ (57400). Yosɛɛfʋ pǝyɑlʋ Ɩfǝlɑyim nyǝ́mɑ nyǝntɛ kɛ iyisi nɩɩlɛ nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (40500). Yosɛɛfʋ pǝyɑlʋ lɛlʋ Mɑnɑsee nyǝ́mɑ nyǝntɛ kɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ nɑɑlɛ nɑ ŋmʋnʋɣʋ (32200). Pɛncɑmɛɛ nyǝ́mɑ nyǝntɛ kɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ nɑ nɑsǝlɛ (35400). Tɑŋ nyǝ́mɑ nyǝntɛ kɛ iyisi nɩɩtoso nɑ nɑɑlɛ nɑ nɑsǝtoso nɑ nɩɩnʋwɑ (62700). Asɛɛ nyǝ́mɑ nyǝntɛ kɛ iyisi nɩɩlɛ nɑ kʋlʋm nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (41500). Nɛfǝtɑli nyǝ́mɑ nyǝntɛ kɛ iyisi nɩɩlɛ nɑ nɑɑnʋwɑ nɑ tooso nɑ nɑsǝlɛ (53400). ");
INSERT INTO dop_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Moisi nɑ Alɔŋ, nɑ Ɩsɛɣɛlɩ kpekɑ nɑɑnʋwɑ nɑ nɑɑlɛ lʋlʋŋ nyʋɣʋ nyǝ́mɑ, pɑ kɑlɑ yǝlɑɑ nɑ pǝ́ lɩɩ ɩsǝnɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ɩsɛɣɛlɩ ɑpɑlɑɑ mpɑ pɑ wɛnɑ pɩɩsɩ hiu nɑ wɑɑlɩ, nɑ pɑ́ mʋnɑ yoou pote tɔ, ");
INSERT INTO dop_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","pɑ kpɛntɑ iyisi nɑsǝtoso nɑ tooso nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (603550). ");
INSERT INTO dop_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Pɑ tɑɑ kpɛnnɑ Lefii kpekǝle nyǝ́mɑ nɑ pɑ́ kɑlɑ. ");
INSERT INTO dop_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Tɑcɑɑ kɑ kisinɑ Moisi kɛ́ sɩ, ");
INSERT INTO dop_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","ɩ́ tɑɑ kpɛntɩ-wɛɣɛ Ɩsɛɣɛlɩ yoolɑɑ tɔɔ nɑ ɩ́ kɑlɑ. ");
INSERT INTO dop_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Amɑ ɩ́ yelinɑ-wɛɣɛ Ɩsɔ cokǝle nɑ tǝ tɑɑ wontu tǝnɑ nɑ pɑ́ pɑɑsǝɣǝnɑ. Mpɛ pɑɑ kpɑkǝɣǝnɑ cokǝle nɑ tǝ tɑɑ wontu nɑ pɑ́ lɑɣɑsǝɣɩ lonɑ, nɑ pɑ́ sikiɣi nɑ pɑ́ cɔɔkǝnɑ-tɛ. ");
INSERT INTO dop_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Ye Ɩsɛɣɛlɩ nyǝ́mɑ lɑɣɑsǝɣɩ lonte, Lefii nyǝ́mɑ mpɛ pɑɑ hɛtǝnɑ-tɛ, nɑ pɑ́ ponɑ timpi pɑɑ siki tɔ. Kpɑɩ tʋ ɩ́ kpǝtǝnɑɑ ɩsɩɩ pɑ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Pɑɑ Ɩsɛɣɛlɩ tʋ wei, ɩ yoolɑɑ kpekǝle cɔlɔɣɔ ɩ kɑ siki ɩ tuutɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Amɑ Lefii nyǝ́mɑ tike kɑ́ sikinɑ nɑ pɑ́ cɔɔ cokǝle. Nɑ pɑ́ feŋiɣi tǝ tɔɔ, Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ tɑɑ kpǝtǝnɑ-tɛɣɛ sɔsɔm, nɑ mɑ́ mʋnɑ-wɛ nɑ pɑ́ɑ́nɑ́. ");
INSERT INTO dop_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ḿpʋ́ɣʋ́ pɑ lɑpɑ teitei ɩsɩɩ Tɑcɑɑ kɑ tʋɣʋ Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Pǝ wɛɛ sɩ pɑɑ Ɩsɛɣɛlɩ tʋ wei nɑ ɩ yoolɑɑ pɑ́ siki pɑ kpekǝle tuutɑ kiŋ, nɑ pɑ́ cɔɔnɑ Ɩsɔ cokǝle nɑ pǝ́ hɑtǝlǝnɑ-tɛɣɛ mɑɣɑnɑ. ");
INSERT INTO dop_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","Yutɑ yoolɑɑ tintiɣile kɑ́ wɛɛnɑ ilim tǝlɩɩlɛ tɔɔ kɛ́ pɑ tuutɑ kite. Mpɑ pɑ mʋnɑ yoou pote tɔ, pɑ sɔsɔ ntɛ́ pɑ kpekǝle nyʋɣʋ tʋ Aminɑtɑpɩ pǝyɑlʋ Nɑsɔŋ. Nɑ ɩ yoolɑɑ kɛ iyisi nɩɩtoso nɑ nɑɑnʋwɑ nɑ liɣiti nɑ nɑsǝtoso (74600). Ɩsɑkɑɑ nyǝ́mɑ yoolɑɑ nyʋɣʋ tʋ ntɛ́ Suwɑɑ pǝyɑlʋ Netɑneyɛlɩ. Ɩ yoolɑɑ wɛ iyisi nɩɩlɛ nɑ nɑɑnʋwɑ nɑ liɣiti nɑ nɑsǝlɛ (54400). Sɑpulɔŋ nyǝ́mɑ yoolɑɑ tintiɣile nyʋɣʋ tʋ ntɛ́ Helɔŋ pǝyɑlʋ Ɩliyɑpɩ. Ɩ yoolɑɑ wɛ iyisi nɩɩlɛ nɑ nɑɑnʋwɑ nɑ nɑɑtosomopɔɣɔlɑɣɑ nɑ nɑsǝlɛ (57400). ");
INSERT INTO dop_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Yutɑ yoolɑɑ tintiɣile tǝnɑ kpɛntɑ iyisi nɩɩnʋwɑ nɑ nɩɩnɑɑsɑ nɑ nɑɑtoso nɑ nɑsǝlɛ (186400). Ɩsɛɣɛlɩ yoolɑɑ looŋɑ kɑncɑɑlɑɣɑ nyǝŋkɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","15","Lupɛŋ nyǝ́mɑ yoolɑɑ tintiɣile kɑ́ wɛɛnɑ ilim mpǝtǝŋ tɔɔ kɛ́ pɑ tuutɑ kite. Mpɑ pɑ mʋnɑ yoou pote tɔ, pɑ sɔsɔ ntɛ́ pɑ kpekǝle nyʋɣʋ tʋ Setewu pǝyɑlʋ Ɩlisuu. Ɩ yoolɑɑ wɛ iyisi nɩɩlɛ nɑ nɑɑtoso nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (46500). Simiyɔŋ nyǝ́mɑ yoolɑɑ tintiɣile nyʋɣʋ tʋ ntɛ́ Sulisɑtɑɩ pǝyɑlʋ Selumǝyɛlɩ. Ɩ yoolɑɑ wɛ iyisi pɔɣɔlɑɣɑfɛɩ nɩɩtoso nɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (59300). Kɑtɩ nyǝ́mɑ yoolɑɑ tintiɣile nyʋɣʋ tʋ ntɛ́ Teuwɛlɩ pǝyɑlʋ Ɩliyɑsɑfɩ. Ɩ yoolɑɑ wɛ iyisi nɩɩlɛ nɑ kɑkpɑsɩ nɑ nɑsǝtoso nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (45650). ");
INSERT INTO dop_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Lupɛŋ nyǝ́mɑ yoolɑɑ tintiɣile tǝnɑ kpɛntɑ iyisi nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ nɑ kʋlʋm nɑ nɑsǝlɛ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (151450). Ɩsɛɣɛlɩ yoolɑɑ looŋɑ nɑɑlɛ nyǝŋkɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Pǝlɛ pǝ wɑɑlɩ kɛ́ Lefii nyǝ́mɑ nɑ́ tǝŋǝɣǝnɑ Ɩsɔ cokǝle kɛ lɔlɔ loosi nɑɑlɛ, nɑ wɑɑlɩ nyǝnsɩ nɑɑlɛ hɛkʋ tɑɑ. Mpɛ pɑ mɑɣɑmɑɣɑ pɑɑ tɔ nɔɣɔ kʋlʋmɑɣɑ kɛ́. Pɑɑ wei kɛ́ ɩ lonte tɑɑ. Nɑ ɩ́ tǝŋǝɣɩ ɩ lʋlʋɣʋ nyǝ́mɑ tuutɑ. ");
INSERT INTO dop_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","23","Ɩfǝlɑyim yoolɑɑ tintiɣile kɑ́ wɛɛnɑ ilim tǝtʋlɛ tɔɔ kɛ́ pɑ tuutɑ kite. Mpɑ pɑ mʋnɑ yoou pote tɔ pɑ sɔsɔ ntɛ́ pɑ kpekǝle nyʋɣʋ tʋ Amihuti pǝyɑlʋ Ɩlisɑmɑ. Ɩ yoolɑɑ wɛ iyisi nɩɩlɛ nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (40500). Mɑnɑsee yoolɑɑ tintiɣile nyʋɣʋ tʋ ntɛ́ Petɑsuu pǝyɑlʋ Kɑmliyɛlɩ. Yoolɑɑ wɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ nɑɑlɛ nɑ ŋmʋnʋɣʋ (32200). Pɛncɑmɛɛ yoolɑɑ tintiɣile nyʋɣʋ tʋ ntɛ́ Kitoni pǝyɑlʋ Apitɑŋ. Ɩ yoolɑɑ wɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ nɑ nɑsǝlɛ (35400). ");
INSERT INTO dop_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ɩfǝlɑyim nyǝ́mɑ yoolɑɑ tintiɣile tǝnɑ kpɛntɑ iyisi pǝlefɛɩ nɩɩnʋwɑ nɑ nɑɑnʋwɑ nɑ yʋlʋpee nɩɩnʋwɑ (108100). Looŋɑ tooso nyǝŋkɑ kɑnɛ kɑɑ tǝŋnɑ ntɛɣɛ Lefii kpekǝle. ");
INSERT INTO dop_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","30","Tɑŋ nyǝ́mɑ yoolɑɑ tintiɣile kɑ́ wɛɛnɑ ilim tǝlɩɩlɛ mpǝtǝŋ tɔɔ kɛ́ pɑ tuutɑ kite. Mpɑ pɑ mʋnɑ yoou pote tɔ, pɑ sɔsɔ ntɛ́ pɑ kpekǝle nyʋɣʋ tʋ Amisɑtɑɩ pǝyɑlʋ Ahiyesɛɛ. Ɩ yoolɑɑ wɛ iyisi nɩɩtoso nɑ nɑɑlɛ nɑ nɑsǝtoso nɑ nɩɩnʋwɑ (62700). Asɛɛ nyǝ́mɑ yoolɑɑ tintiɣile nyʋɣʋ tʋ ntɛ́ Okǝlɑŋ pǝyɑlʋ Pɑkiyɛlɩ. Ɩ yoolɑɑ wɛ iyisi nɩɩlɛ nɑ kʋlʋm nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (41500). Nɛfǝtɑli nyǝ́mɑ yoolɑɑ tintiɣile nyʋɣʋ tʋ ntɛ́ Ɩnɑŋ pǝyɑlʋ Ahilɑ. Ɩ yoolɑɑ wɛ iyisi nɩɩlɛ nɑ nɑɑnʋwɑ nɑ tooso nɑ nɑsǝlɛ (53400). ");
INSERT INTO dop_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Tɑŋ nyǝ́mɑ yoolɑɑ tintiɣile tǝnɑ kpɛntɑ iyisi nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ nɑ nɑsǝtoso (157600). Ɩsɛɣɛlɩ yoolɑɑ looŋɑ kɑntǝkɑɣɑ nyǝŋkɑ ntɛ́. Pɑɑ kpekǝle nte tɩɩ wɛɛ tǝ tuutɑ wɑɑlɩ kɛ́ nɑ tǝ́ tɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ɩsɛɣɛlɩ kpekɑ nɑ pɑ yoolɑɑ mpɑ pɑ kɑlɑɑ tɔ, pɑ kpɛntɑ iyisi nɑsǝtoso nɑ tooso nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (603550). ");
INSERT INTO dop_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Pɑ tɑ kpɛŋnɑ Lefii nyǝ́mɑ nɑ pɑ́ kɑlɑ. Teitei ɩsɩɩ Tɑcɑɑ kɑ heeluɣu Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Ɩsɛɣɛlɩ nyǝ́mɑ lɑkɑɣɑ teitei kɛ́ ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ Moisi tɔ. Pɑɑ mpɑ pɑ sikɑɣɑ pɑ tuutɑ cɔlɔɣɔ. Nɑ pɑ́ tɔŋ ɩsɩɩ pɑ kɛɛsʋɣʋ pɑ kpekɑ nɑ pɑ lʋlʋŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Wɑɑtʋ wei Tɑcɑɑ yɔɣɔtǝnɑ Moisi kɛ Holɛpʋ pʋɣʋ tɑɑ tɔ, ɩ nɑ ɩ tɑɑlʋ Alɔŋ pɑɑ wɛnɑ piyɑ mpɑ tɔɣɔlɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Alɔŋ pǝyɑlɑɑ kɑ wɛ liɣiti kɛ́. Pɑ sɔsɔ ntɛ́ Nɑtɑpɩ, nɑ pǝ́ fɛɛ Apihu, nɑ Ɩlɑsɑɑ, nɑ Ɩtɑmɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Pɑɑ tɛmɑ-wɛɣɛ kɔtǝlɑɑ kpɑʋ kɛ́. Hɑlǝnɑ pɑ́ pǝlɩ-wɛɣɛ kɔtɑɣɑ nim kɛ pɑ nyɔɔŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Amɑ Nɑtɑpɩ nɑ Apihu pɑ sǝpɑ cokǝle kiŋ kɛ Holɛpʋ wʋlɑɣɑ tɛtʋ tɑɑ. Wɑɑtʋ ɩnǝɣɩ pɑ kɔnɑ kɔkɔ kpɑɩ nyǝŋkɑ kɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Ɩlɛ pɑ tɑɑ wɛɛnɑ ɑpɑlʋpiyɑ. Ɩlɑsɑɑ nɑ Ɩtɑmɑɑ pɑɑ wɛnnɑ pɑ cɑɑ Alɔŋ kiŋ nɑ pɑ́ lɑkɩ kɔtʋɣʋ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Yɑɑ Lefii nyǝ́mɑ nɑ ń sɔɔsɩ-wɛɣɛ kɔtʋlʋ Alɔŋ tɔɔ, nɑ pɑ́ sǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Pɑɑ lɑkɩ pɑ tǝmɑ nnɑ pǝ tʋ pɑ́ nɑ sɑmɑɑ tɔɣɔ tɑm kɛ́ cokǝle kiŋ, nɑ pɑ́ lɑkɩ tǝ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Nɑ pɑ́ tɑɣɑnǝɣɩ tǝ tɑɑ wontunɑɑ. Pɑ́ lɑkɩ tǝ tǝmɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","N kɑ́ cɛlɑ Lefii nyǝ́mɑ kɛ Alɔŋ nɑ ɩ pǝyɑlɑɑ kɛ́. Nɑ pɑ́ pǝsɩ ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ tillɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Nɑ ń feŋ nɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ tike pɑ́ lɑkɩ kɔtʋɣʋ tǝmlɛ. Ye wei ɩ́ sʋʋ pǝ tɑɑ, nɑ ɩ́ tɑ́ kɛ́ kɔtʋlʋ ɩsɩɩ pɑ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu sɩ: ");
INSERT INTO dop_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Mɑ mɑɣɑmɑɣɑ mɑ lǝsǝnɑ Lefii nyǝ́mɑ kɛ Ɩsɛɣɛlɩ yǝlɑɑ lɛlɑɑ tǝnɑ tɑɑ sɩ, pɑ́ pǝsɩ mɑ tǝmlɛ nyǝ́mɑ. Nɑ pɑ́ lɛɛtɩ Ɩsɛɣɛlɩ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ lonte. ");
INSERT INTO dop_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Kʋyɑŋku mɑ kʋ́ Icipiti nyǝ́mɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ tǝnɑ tɔ, mɑ sɩɩ mɑ tǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ tɔlɑ kɑncɑɑlɑɣɑ ɑpɑlʋ nyǝnsɩ kɛ́. Mɑɣɑlɛ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi kɛ Holɛpʋ wʋlɑɣɑ tɛtʋ tɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Kɑlɑ Lefii nyǝ́mɑ nɑ ń kɛɛsǝnɑ pɑ lʋlʋŋ nɑ pɑ tɛɛsɩ. Pǝ kpɑɣɑʋ ɑpɑlʋpiyɑ nsi sɩ wɛnɑ ɩsɔtʋ kʋlʋm nɑ wɑɑlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ɩlɛnɑ Moisi lɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Lefii pǝyɑlɑɑ hǝlɑ ntɛ́ Kɛɛsɔŋ, nɑ Kehɑtɩ, nɑ Melɑli. ");
INSERT INTO dop_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Kɛɛsɔŋ nyǝ́mɑ ntɛ́ Lipini nɑ Simeyi. Mpɛ ɩnɩ pɑ pǝsǝnɑ pɑ lʋlʋŋ nyɔɔŋ nyǝ́mɑ nɑ pɑ́ yɑɑkɩ-wɛɣɛ pɑ hǝlɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kehɑtɩ nyǝ́mɑ ntɛ́ Amǝlɑm nɑ Ɩsɑɑ nɑ Hepǝlɔŋ nɑ Wusiyɛlɩ. Mpɛ ɩnɩ pɑ pǝsǝnɑ pɑ lʋlʋŋ nyɔɔŋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Melɑli nyǝ́mɑ ntɛ́ Mɑlii nɑ Musi. Mpɛ ɩnǝɣǝlɛ pɑ lʋlʋŋ nyɔɔŋ nyǝ́mɑ. Mpɛ pɑ kɛnɑ Lefii kpekɑ nyǝ́mɑ nɑ pǝ́ kɛɛsǝnɑ pɑ lʋlʋŋ. ");
INSERT INTO dop_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Kɛɛsɔŋ lʋlʋŋ nyǝ́mɑ fɑɣɑ tɔm nɑɑlɛɣɛ. Lipini nyǝŋkʋ nɑ Simeyi nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Kʋkɑlʋɣʋ wɑɑtʋ, pɑ hikɑ ɑpɑlɑɑ nɑ ɑpɑlʋpiyɑ mpɑ pɑ wɛnɑ ɩsɔtʋ kʋlʋm nɑ wɑɑlɩ tɔɣɔ, iyisi nɑɑtosompɔɣɔlɑɣɑ nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (7500). ");
INSERT INTO dop_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Mpɛ ɩnɩ pɑ sikɑɣɑnɑ cokǝle wɑɑlɩ nɑ ilim tǝtʋlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Lɑyɛlɩ pǝyɑlʋ Ɩliyɑsɑfɩ kɛlɛ pɑ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Kʋlʋmɑɑ mpɛ pɑ pɑɑsɑɣɑnɑ cokǝle tɑɑ nɑ tǝ wɑɑlɩ tɔɔ. Nɑ tǝ tɔɔ kʋtɑkʋɣʋ, nɑ tǝ nɔnɔɣɔ pʋʋɣʋ kʋkɑkɑɣɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Nɑ kɑlɑɑ wei ɩ cɔɔnɑ cokǝle nɑ kɔtɑɣɑ tǝlɑtɛ tɔ ɩ pɔɔŋ nɑ ɩ nɔnɔɣɔ nyǝŋ nɑ pǝ ŋmɩɩsɩ. Mpɛ pɑ pɑɑsɑɣɑnɑ pǝ tǝnɑɣɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kehɑtɩ lʋlʋŋ nyǝ́mɑ fɑɣɑ tɔm liɣiti kɛ́. Amǝlɑm nyǝ́mɑ, nɑ Ɩsɑɑ nyǝ́mɑ, nɑ Hepǝlɔŋ nyǝ́mɑ, nɑ Wusiyɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Pɑ kɑlɑ pǝ kpɑɣɑʋ ɑpɑlɑɑ, nɑ ɑpɑlʋpiyɑ mpɑ pɑ wɛnɑ ɩsɔtʋ kʋlʋm nɑ wɑɑlɩ tɔ. Pɑ wɛ iyisi pǝlefɛɩ nɑ nɑsǝtoso (8600). Pɑ nyǝntɛ ntɛ́ Ɩsɔ cokǝle tɑɑ wontunɑɑ pɑɑsǝnɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Cokǝle ilim mpǝtǝŋ tɔɔ kɛ́ pɑ sikɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Pɑ nyʋɣʋ tʋ ntɛ́ Wusiyɛlɩ pǝyɑlʋ Ɩlisɑfɑŋ. ");
INSERT INTO dop_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Pɛlɛ pɑ pɑɑsǝɣǝnɑnɑ Ɩsɔ ɑtɑkɑɑ, nɑ tɑɑpǝlɩ, nɑ fǝtǝlɑnɑɑ tǝsɩɩlɛ, nɑ kɔtɑɣɑ tǝlɑtɛnɑɑ. Nɑ cokǝle tɑɑ wontunɑɑ mpɑ pɑ lɑkǝnɑ tɔ. Nɑ pǝ tɑɑ pʋʋɣʋ kʋkɑkɑɣɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Lefii nyʋɣʋ nyǝ́mɑ tɑɑ sɔsɔ ntɛ́ kɔtʋlʋ Alɔŋ pǝyɑlʋ Ɩlɑsɑɑ. Ɩnɩ ɩ feŋiɣinɑ cokǝle pɑɑsǝnlɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Melɑli lʋlʋŋ nyǝ́mɑ fɑɣɑ tɔm nɑɑlɛɣɛ: Mɑlii nyǝ́mɑ, nɑ Musi nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Pɑ kɑlɑ pǝ kpɑɣɑʋ ɑpɑlɑɑ nɑ ɑpɑlʋpiyɑ, mpɑ pɑ wɛnɑ ɩsɔtʋ kʋlʋm nɑ wɑɑlɩ tɔ. Nɑ pɑ kpɛntɩ iyisi nɑɑtoso nɑ ŋmʋnʋɣʋ (6200). ");
INSERT INTO dop_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Pɑ nyʋɣʋ tʋ ntɛ́ Apihɑyili pǝyɑlʋ Suluyɛlɩ. Nɑ mpɛ ɩnɩ pɑ sikɑɣɑnɑ cokǝle ilim ntɔɣɔŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Melɑli nyǝ́mɑ tǝmlɛ ntɛ́ sɩ pɑ́ pɑɑsǝnɑ cokǝle kpɑtǝŋ kʋwɑlǝŋ, nɑ kʋkɑɣɑŋ nɑ tesikɑsɩ, nɑ sɩ tɑpǝŋ tɛɛ nyǝɣǝtʋ kʋtemtu, nɑ pǝ wontu. Nɑ pǝ tǝnɑ mpi pɑ lɑkǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Nɑ kɑlɑɑ tesikɑsɩ, nɑ sɩ tɑpǝŋ tɛɛ nyǝɣǝtʋ kʋtemtu, nɑ pǝ kɑŋkɑnɑsɩ nɑ pǝ ŋmɩɩsɩ. ");
INSERT INTO dop_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Cokǝle ilim tǝlɩɩlɛ tɔɔ kɛ́ Moisi nɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑɑ sikɑɑ. Mpɛ pɑ pɑɑsɑɣɑnɑ cokǝle nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɔɣɔ. Ye kpɑɩ tʋ ɩ kpǝtǝnɑɑ ɩsɩɩ pɑ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lefii nyǝ́mɑ tǝnɑ, pǝ kpɑɣɑʋ ɑpɑlɑɑ nɑ ɑpɑlʋpiyɑ mpɑ pɑ wɛnɑ ɩsɔtʋ kʋlʋm nɑ wɑɑlɩ tɔ. Pɑ kpɛntɑ ɩsɩɩ iyisi hiu nɑ nɑɑlɛ (22000). Ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ Moisi nɑ Alɔŋ tɔ. Ḿpʋ́ɣʋ́ pɑ kɑlɑ-wɛ nɑ pǝ́ kɛɛsǝnɑ pɑ lʋlʋŋ. ");
INSERT INTO dop_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: Kɑlɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ tǝnɑ. Pǝ kpɑɣɑʋ mpɑ pɑ wɛnɑ ɩsɔtʋ kʋlʋm nɑ wɑɑlɩ tɔ. Ɩlɛnɑ ń tʋ́ pɑ hǝlɑ kɛ tɑkǝlɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Sɩɩ Lefii nyǝ́mɑ nɑ pɑ mpɑɑ kɛ Ɩsɛɣɛlɩ ɑpɑlʋpiyɑ kɑncɑɑlɑɣɑ nyǝnsɩ lonte tɑɑ. Nɑ ń sɩɩ Lefii nyǝ́mɑ tɔlɑ nɑ ɑ mpɑɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɔlɑ kɑncɑɑlɑɣɑ ɑpɑlʋ nyǝnɑ lonɑ tɑɑ. Tɑcɑɑ mɑ́ mɑ nyǝm ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ḿpʋ́ɣʋ́ Moisi kɑlɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ tǝnɑ, ɩsɩɩ Tɑcɑɑ tʋɣɩ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Pǝ kpɑɣɑʋ mpɑ pɑ wɛnɑ ɩsɔtʋ kʋlʋm nɑ wɑɑlɩ tɔ, nɑ pɑ́ tʋ́ pɑ hǝlɑ kɛ tɑkǝlɑɣɑ tɑɑ. Pɑ wɛ iyisi hiu nɑ nɑɑlɛ nɑ ŋmʋnʋɣʋ nɑ nɩɩtoso nɑ nɑɑnʋwɑ nɑ tooso (22273). ");
INSERT INTO dop_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ɩlɛnɑ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu sɩ: ");
INSERT INTO dop_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Sɩɩ Lefii nyǝ́mɑ nɑ pɑ mpɑɑ, nɑ pɑ́ pǝsɩ mɑ nyǝ́mɑ kɛ Ɩsɛɣɛlɩ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ lonte tɑɑ. Nɑ ń lɑ mpʋ tɔtɔɣɔ Lefii nyǝ́mɑ tɔlɑ, kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɔlɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ lonte tɑɑ. Mɑɣɑlɛ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ɩsɛɣɛlɩ ɑpɑlʋpiyɑ ŋmʋnʋɣʋ nɑ nɩɩtoso nɑ nɑɑnʋwɑ nɑ tooso (273) pɑɣɑtǝnɑ ntɛɣɛ Lefii nyǝ́mɑ. Nɑ mpɛ ɩnǝɣɩ pǝ wɛɛ sɩ pɑ́ yɑ pɑ nyɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Nɑ pɑ́ tʋ́ pɑɑ wei ɩ nyʋɣʋ tɔɔ kɛ́ liɣitee nyǝɣǝtʋ kɑkpɑsɩ. Nɑ pǝ́ kɛɛsǝnɑ Ɩsɔ cokǝle tɑɑ liɣitee mɑɣɑsʋɣʋ. Pɑɑ nyǝɣǝlʋɣʋ ŋku kʋ yuŋ kɑ wɛ cɑcɑɑsɩ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ɩlɛnɑ pɑ cɛlɑ-yɛɣɛ Alɔŋ nɑ ɩ pǝyɑlɑɑ, nɑ pɑ́ yɑnɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ kʋpɑɣɑtɑsɩ nyɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","50","Ḿpʋ́ɣʋ́ Moisi mʋ Ɩsɛɣɛlɩ nyǝ́mɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ mpɑ pɑ pɑɣɑtɑ mpʋ tɔ. Pɑ liɣitee wenɑ pɑ yɑpǝnɑ-wɛ, ɩsɩɩ pɑ mɑɣɑsʋɣʋ Ɩsɔ cokǝle tɑɑ tɔ, ɑ lɩɩ nyǝɣǝtʋ iyɑɣɑ nɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ nɑ nɩɩtoso nɑ kɑkpɑsɩ (1365). ");
INSERT INTO dop_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Ḿpʋ́ɣʋ́ pɑ cɛlɑ-yɛɣɛ Alɔŋ nɑ ɩ pǝyɑlɑɑ ɩsɩɩ Tɑcɑɑ kɑ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","3","Ɩ́ ŋmɑɑ Lefii kpekǝle tʋ Kehɑtɩ lʋlʋɣʋ nyǝ́mɑ mpɑ pɑ pɩɩsɩ tɑlɑ hiu nɑ nɑɑnʋwɑ, nɑ pǝ́ polo nɩɩlɛ nɑ nɑɑnʋwɑ tɔ pɑ hǝlɑ. Pɑ́ kpɑ mpɑ pɑ pǝsǝɣɩ nɑ pɑ́ lɑ tǝmlɛ kɛ Ɩsɔ cokǝle tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Nɑ pɑ́ pɑɑsǝɣǝnɑ kɑtɛ tɑɑ kɑtɛ wontu. ");
INSERT INTO dop_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ye pɑ cɑɑ tǝsikile kɛ lɑɣɑsʋɣʋ, ɩlɛ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ kɔɔ nɑ pɑ́ tisi pʋʋɣʋ kʋkɑɣɑʋ nɑ pɑ́ tɑkɩ Ɩsɔ ɑtɑkɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ɩlɛnɑ pɑ́ tǝnɩ pǝ tɔɔ kɛ́ tɔnʋɣʋ tɛɛlǝŋ nyǝŋkʋ nɑkʋlɩ. Nɑ pɑ́ wɑɑsɩ-ɩ heeŋ hʋntʋ pʋʋɣʋ ŋku pɑ lii ɑkpɑɑyɑlɑ tɔ, nɑ pɑ́ sʋsɩ ɩ kpɑtǝŋ kʋtɔkǝŋ. ");
INSERT INTO dop_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Nɑ pɑ́ tɑkɩ heeŋ hʋntʋ pʋʋɣʋ ŋku pɑ lii ɑkpɑɑyɑlɑ tɔɣɔ Ɩsɔ potopotonɑɑ tɑɑpǝlɩ tɔɔ. Nɑ pɑ́ sɩɩ nyǝnɑsɩ, nɑ kɔpʋnɑɑ, nɑ poosiyɑnɑɑ, nɑ fusi nsi pɑ liisiɣinɑ sʋlʋm tɔ. Nɑ pɑ́ sɩɩ tɔtɔɣɔ potopotonɑɑ mpɑ pɑ hɑɑkɩ Ɩsɔ kɛ́ tɑm tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ɩlɛnɑ pɑ́ wɑɑsɩ-ɩ heeŋ hʋntʋ pʋʋɣʋ ŋku pɑ lii ɑkpɑɑyɑlɑ tɔ nɑ pɑ́ tǝnɩ pǝ tɔɔ kɛ́ tɔnʋɣʋ tɛɛlǝŋ nyǝŋkʋ nɑkʋlɩ. Ɩlɛnɑ pɑ́ lɛɛ tɑɑpǝlɩ kɛ kpɑtǝŋ wei pɑ kpɑkǝɣǝnɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Nɑ pɑ́ wɑɑsɩ pʋʋɣʋ pooku kɛ fǝtǝlɑnɑɑ tǝsɩɩlɛ nɑ tǝ fǝtǝlɑnɑɑ. Nɑ wontu tǝnɑ tɔɔ, ɩsɩɩ kpǝtǝlɑsɩ nɑ tɔlʋmɑ nyǝnɑsɩ nɑ nim fusi. ");
INSERT INTO dop_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ɩlɛnɑ pɑ́ tʋ́ pǝ tǝnɑɣɑ tɔnʋɣʋ tɛɛlǝŋ nyǝŋkʋ nɑkʋlɩ kʋ tɑɑ, nɑ pɑ́ sɩɩ kpɑtǝlɛ nte pɑ kpɑkǝɣǝnɑ wontu tɔ tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Nɑ pɑ́ tɑkɩ ɑkpɑɑyɑlɑ pʋʋɣʋ kɛ wʋlɑ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Nɑ pɑ́ wɑɑsɩ-tɛɣɛ tɔnʋɣʋ tɛɛlǝŋ nyǝŋkʋ, nɑ pɑ́ sʋsɩ kpɑtǝŋ wei pɑ kpɑkǝɣǝnɑ-tɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ɩlɛnɑ pɑ koti ɩsɔ sɛɛʋ wontu tǝnɑ, nti pɑ lɑkǝnɑ cokǝle tɑɑ tɔɣɔ ɑkpɑɑyɑlɑ pʋʋɣʋ tɑɑ. Nɑ pɑ́ wɑɑsɩ tɔnʋɣʋ tɛɛlǝŋ nyǝŋkʋ nɑ pɑ́ tǝnɩ kpɑtǝlɛ nte pɑ kpɑkǝɣǝnɑ-tɩ tɔ tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Nɑ pɑ́ hɑsɑ kɔtɑɣɑ tǝlɑtɛ tɔɔ tɔlʋmɑ, nɑ pɑ́ pɔ pʋʋɣʋ kʋsɛɛmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Nɑ pɑ́ tǝnɩ pǝ tɔɔ kɛ́ wontunɑɑ mpɑ pɑ lɑkǝnɑ kɔtɑɣɑ tǝlɑtɛ tɔ. Ɩsɩɩ cofolonɑɑ kelɑ lɔɣɔlɑsɩ, nɑ sɔsɔɔnsɩ nsi pɑ kuukinɑ tɔlʋmɑ tɔ. Nɑ poosiyɑnɑɑ nɑ wontu kʋlɑpǝnɑtʋ tǝnɑ. Nɑ pɑ́ tɑkɩ tɔnʋɣʋ tɛɛlǝŋ nyǝŋkʋ kɛ pǝ tɔɔ. Ɩlɛnɑ pɑ́ sʋsɩ kpɑtǝŋ wei pɑ kpɑkǝɣǝnɑ-tɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Ye pǝ tɑlɑ tɛɛʋ, pǝ wɛɛ sɩ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ́ tɛ pǝ tǝnɑɣɑ tɑkʋɣʋ. Ɩlɛnɑ Kehɑtɩ nyǝ́mɑ kɔɔ nɑ pɑ́ kpɑɣɑ. Mpi tɔ, pǝ fɛɩ sɩ pɑ́ tokinɑ Ɩsɔ wontuɣu nɑkʋlɩ nɑ pǝ́ kɔɔ nɑ pɑ́ sɩ. Pɛlɛ pɑ tǝmlɛ ntɛ́ cokǝle wontu kpɑɣɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Kɔtʋlʋ Alɔŋ pǝyɑlʋ Ɩlɑsɑɑ tǝmlɛ ntɛ́ fǝtǝlɑ sɔsɔ nim nɑ tulɑɑlʋ wɔpʋ. Nɑ pɑɑ ɩfemle nte tǝ tɔɣɔnɑɣɑ kʋhɑʋ nɑ kɔtɑɣɑ nim, nɑ Ɩsɔ cokǝle tɑɑ wontu tǝnɑ pɑɑsǝnɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Moisi nɑ Alɔŋ kɛ heeluɣu sɩ: ");
INSERT INTO dop_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","19","Ɩ́ feŋ Kehɑtɩ nyǝ́mɑ kɛ teu, kɛ wɑɑtʋ wei pɑ pɑɑsǝɣǝnɑ Ɩsɔ wontu tɔ. Pǝ tɑɑ kɔɔ nɑ pǝ́ kpiisi-wɛɣɛ Lefii nyǝ́mɑ hɛkʋ. Mpi tɔ, pǝ wɛɛ sɩ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ́ sʋʋnɑ-wɛɣɛ cokǝle tɑɑ, nɑ pɑ́ hʋlǝɣɩ pɑɑ wei kɛ wontu nti ɩ kɑ́ kpɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ye pɑ sʋʋwɑ, nɑ pɑ́ loosi loosuɣu mɑɣɑmɑɣɑ kɛ Ɩsɔ wontu, nɑ pɑ́ tɑ hɔkǝtɑ-tɩ pɑɑ sɩ. ");
INSERT INTO dop_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Kɑlɑ Kɛɛsɔŋ lʋlʋɣʋ nyǝ́mɑ nɑ pɑ tɛɛsɩ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ɩlɛnɑ ń ŋmɑɑ ɑpɑlɑɑ mpɑ pɑ pɩɩsɩ tɑlɑ hiu nɑ nɑɑnʋwɑ nɑ pǝ́ polo nɩɩlɛ nɑ nɑɑnʋwɑ nɑ pɑ́ pǝsǝɣɩ nɑ pɑ́ lɑ Ɩsɔ cokǝle tɑɑ kɛ tǝmlɛ tɔ pɑ hǝlɑ. ");
INSERT INTO dop_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Tǝmɑ wenɑ pɑɑ tʋ-wɛ nɑ pɑ́ lɑkɩ tɔɣɔlɛ, ");
INSERT INTO dop_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","pɔɔŋ wei pɑ tɑkǝɣɩ Ɩsɔ cokǝle tɔɔ tɔ. Nɑ ɩwɑɑŋ tɔnǝŋ, nɑ tɔnʋɣʋ tɛɛlǝŋ nyǝŋkʋ ŋku kʋ wɑɑsɑ pǝ tǝnɑ pǝ tɔɔ tɔ. Nɑ cokǝle nɔnɔɣɔ pʋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Nɑ kɑlɑɑ pʋʋɣʋ nɑ ɩ nɔnɔɣɔ nyǝŋkʋ nɑ pǝ ŋmɩɩsɩ, nɑ pɑ́ lɑkɩ pǝ tɑɑ wontu tǝnɑ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ hʋlǝɣǝnɑ Kɛɛsɔŋ nyǝ́mɑ kɛ pɑ kʋlɑpǝm nɑ pɑ kʋkpɑɣɑm tǝnɑ nɑ pɑ pɑɑsǝɣǝnɑ-wɩ. ");
INSERT INTO dop_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Kɛɛsɔŋ nyǝ́mɑ tǝmɑ ntɛ́ Ɩsɔ cokǝle tɑɑ. Kɔtʋlʋ Alɔŋ pǝyɑlʋ Ɩtɑmɑɑ kɑ feŋiɣinɑ pɑ tǝmlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu sɩ: Kɑlɑ tɔtɔɣɔ Melɑli lʋlʋɣʋ nyǝ́mɑ nɑ pɑ tɛɛsɩ nyǝ́mɑ kɛ ");
INSERT INTO dop_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","pǝ kpɑɣɑʋ ɑpɑlɑɑ mpɑ pɑ pɩɩsɩ tɑlɑ hiu nɑ nɑɑnʋwɑ nɑ pǝ́ polo nɩɩlɛ nɑ nɑɑnʋwɑ tɔ pɑ hǝlɑ nɑ ń kpɑ mpɑ pɑ pǝsǝɣɩ nɑ pɑ́ lɑ tǝmlɛ kɛ Ɩsɔ cokǝle tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Pɑ tǝmɑ kʋlɑpɛɛ ntɛ́ cokǝle kpɑtǝŋ kʋwɑlǝŋ, nɑ kʋkɑɣɑŋ, nɑ tesikɑsɩ, nɑ sɩ tɑpǝŋ tɛɛ nyǝɣǝtʋ kʋtemtu, ");
INSERT INTO dop_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","nɑ kɑlɑɑ tesikɑsɩ nɑ sɩ tɑpǝŋ tɛɛ nyǝɣǝtʋ kʋtemtu, nɑ kɑŋkɑnɑsɩ, nɑ pǝ ŋmɩɩsɩ nɑ pǝ wontunɑɑ tǝnɑ. Kɔtǝlɑɑ kɑ́ ŋmɑɑnɑ wontuɣu ŋku pɑɑ wei ɩ kɑ sǝɣǝlɩ tɔɣɔ tɑkǝlɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tǝmɑ wenɑ pǝ tʋ Melɑli lʋlʋɣʋ nyǝ́mɑ kɛ Ɩsɔ cokǝle tɑɑ tɔɣɔlɛ, nɑ kɔtʋlʋ Alɔŋ pǝyɑlʋ Ɩtɑmɑɑ nɑ́ɑ́ feŋiɣi pɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","49","Ḿpʋ́ɣʋ́ Moisi nɑ Alɔŋ nɑ Ɩsɛɣɛlɩ kpekǝle nyʋɣʋ nyǝ́mɑ kɑlɑ Lefii kpekǝle nyǝ́mɑ Kehɑtɩ, nɑ Kɛɛsɔŋ, nɑ Melɑli, pɑ lʋlʋŋ, nɑ pɑ tɛɛsɩ ɑpɑlɑɑ mpɑ pɑ tɑlɑ pɩɩsɩ hiu nɑ nɑɑnʋwɑ, nɑ pǝ́ polo nɩɩlɛ nɑ nɑɑnʋwɑ tɔ pɑ hǝlɑ. Nɑ pɑ́ tʋ pɑɑ wei kɛ tǝmlɛ kɛ Ɩsɔ cokǝle tɑɑ. Ḿpʋ́ɣʋ́ Moisi kɑlɑ-wɛ ɩsɩɩ Tɑcɑɑ tʋɣɩ-ɩ tɔ. Ɩlɛnɑ Kehɑtɩ nyǝ́mɑ kpɛntɩ iyisi nɑɑlɛ nɑ nɑsǝtoso nɑ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (2750). Kɛɛsɔŋ nyǝ́mɑ kɛ iyisi nɑɑlɛ nɑ nɑsǝtoso nɑ hiu nɑ nɑɑnʋwɑ (2630). Melɑli nyǝ́mɑ kɛ iyisi tooso nɑ ŋmʋnʋɣʋ (3200). Ɩlɛnɑ pɑ tǝnɑ pɑ kpɛntɩ iyisi pǝlefɛɩ nɑɑnʋwɑ nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ nɑ nɩɩnɑɑsɑ (8580). Ḿpʋ́ɣʋ́ pɑ hʋlɑ pɑɑ Lefii tʋ wei kɛ́ ɩ tǝmɑ kʋlɑpɛɛ, nɑ ɩ kʋsǝɣǝlǝm kɛ teitei, ɩsɩɩ nti Tɑcɑɑ kɑ tʋ Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Heeli Ɩsɛɣɛlɩ nyǝ́mɑ sɩ ye kʋtɔŋ ŋku kʋ pilisiɣi yʋlʋ tɔ kʋ kpɑ nɔɣɔlʋ yɑɑ pǝ wɩɩkɩ yʋlʋ ɑpɑlʋtʋ yɑɑ ɩ ɑlʋtʋ nɑ lʋm kpeŋnɑ-ɩ. Yɑɑ pʋntʋ tokinɑ sǝtʋ, pǝ wɛɛ sɩ pɑ́ lǝsɩ-ɩ tǝsikile kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Pɑɑ ɩ kɛ́ ɑpɑlʋ yɑɑ ɑlʋ. Pǝ́ tɑɑ kɔɔ nɑ ɩ́ pilisi Ɩsɔ tesikile. ");
INSERT INTO dop_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ nɩɩ Moisi tɔm ntɩ nɑ pɑ́ tɔɣɔnɩ ɑsilimɑ nyǝ́mɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Tɛlǝsɩ Ɩsɛɣɛlɩ yǝlɑɑ sɩ, ye yʋlʋ pǝntǝnɑ ɩ tɔɣɔntǝlɛ ɩ wɑkǝlǝnɑ Tɑcɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Pǝ wɛɛ sɩ ɩ́ tisi ɩsɑɣɑtʋ nti ɩ lɑpɑ mpʋ tɔ. Nɑ ɩ́ tɑɣɑnɩ mpi ɩ wɑkǝlɑɑ tɔɣɔ kɑncɑɑlɑɣɑ, pǝ wɑɑlɩ ɩlɛnɑ ɩ́ sɔɔsɩ pǝ tɔm kɑkpɑsɩ tɑɑ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ye kpǝntɛ tʋ sǝpɑ nɑ ɩ́ fɛɩnɑ kɔɣɔpu, ɩlɛ pɑ cɛlɑ-tɛɣɛ kɔtʋlʋ nɑ ɩ́lɛ́ ɩ cɛlɑ Tɑcɑɑ. Ɩlɛnɑ pǝntʋlʋ cɑɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ ɩwɑɑʋ nɑ kɔtʋlʋ lɑ pǝ sɔɔsɩ. ");
INSERT INTO dop_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ye Ɩsɛɣɛlɩ nyǝ́mɑ kɔnɑ Tɑcɑɑ kɛ kʋhɑʋ ŋku nɑ pɑ́ cɛlɑ kɔtʋlʋ wei, ɩnɩ ɩ tǝnnɑ. ");
INSERT INTO dop_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Yʋlʋ ɩ́ hɑ mpiɣi Tɑcɑɑ, pɑ cɛlǝɣɩ kɔtʋlʋ kɛ́. Nɑ ye pɑ cɛlɑ kɔtʋlʋ kɛ mpi, ɩ pǝsǝɣɩ nɑ ɩ́ sɩɩnɑ ɩ tɩ. ");
INSERT INTO dop_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, ye ɩsɩɩ ɑlʋ lɑkɩ yem yem. ");
INSERT INTO dop_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Ɩsɩɩ ɩ́ nɑ ɑpɑlʋ nɔɣɔlʋ pɑ ŋmɛlǝɣɩ nɑ pɑ́ hǝntǝɣɩ. Ɩlɛ nɔɣɔlʋ tɑ kpǝlɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Ye ɑpɑlʋ lɑkǝnɑ ɩ ɑlʋ kɛ ɩsɛsɛɛmlɛ, nɑ ɩ kpekiɣi ɩ tɔɔ sɩ ɩ lɑpɑ wɑsɑŋkɑlǝtʋ, nɑ pǝyele ɩ́lɛ́ ɩ fɛɩ pǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Ɩlɛ ɑpɑlʋ kɑ ponɑ ɩ ɑlʋ kɛ kɔtʋlʋ, nɑ ɩ́ kpɛnnɑ mʋlʋm kiloonɑɑ tooso. Mʋlʋm mpi pǝ tɑɑ pɑ tɑ yɔɣɔlɩ nim yɑɑ tulɑɑlʋ tɔ. Mpi tɔ, pǝ kɛ́ ɩsɛsɛɛmlɛ kɔtɑɣɑ ŋkɑ kɑ tɔɔsǝɣɩ ɩsɑɣɑtʋ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Ɩlɛnɑ kɔtʋlʋ yɑɑ ɑlʋ ɩnɩ nɑ ɩ́ sǝŋ Tɑcɑɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Nɑ ɩ́ cosi Ɩsɔ lʋm kɛ nyǝnɑɣɑ tɑɑ, nɑ ɩ cosi cokǝle tɑɑ tɛtʋ nɑ ɩ́ tʋ́ pǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ɩlɛnɑ ɩ́ kɔɔlɩ ɑlʋ sɑɑlɑɣɑ kɛ ɩ nyʋɣʋ tɑɑ. Ɩlɛnɑ ɩ́ tʋ́ ɩ niŋ tɑɑ kɛ́ ɩsɛsɛɛmlɛ kɔtɑɣɑ mʋlʋm mpi ɩ pɑɑlʋ kɔnɑɑ tɔ. Nɑ kɔtʋlʋ tɔkɑ lʋm nyɑŋ nyǝm mpi pǝ kɔŋnɑ mpusi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ɩlɛnɑ ɩ́ yele nɑ ɑlʋ tuunɑ. Ɩlɛnɑ kɔtʋlʋ tɔmɩ-ɩ sɩ: Ye nyɑnɑ nɔɣɔlʋ ɩ́ tɑ́ hǝntɩ, nɑ ń pilisi nyɑ́ tɩ. Ɩlɛ lʋm nyɑŋ nyǝm pǝnɛ pǝ mpusi ɩ́ tɑɑ tii nyɑ́ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Amɑ ye n puɣusɑ nyɑ́ pɑɑlʋ nɑ n lɑ wɑsɑŋkɑlǝtʋ. ");
INSERT INTO dop_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Ɩlɛ mpusi lʋm pǝnɛ, pǝ́ sʋʋ nyɑ́ tɑɑ nɑ pǝ́ hɑɣɑsɩ nyɑ́ lotu nɑ pǝ́ ŋmǝlǝsɩ nyɑ́ ɑlʋtʋ nɑ ń pǝsɩ kɑɑlʋlɑɣɑ. Nɑ nyɑ́ tɑɑpɑlɑɑ tukuɣunɑ-ŋ nɑ ɩtuule. ");
INSERT INTO dop_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Ɩlɛnɑ ɑlʋ nɑ́ɑ́ cɔ sɩ: Pǝ́ lɑ ɩsɩɩ n yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Ɩlɛnɑ kɔtʋlʋ ŋmɑɑ mpusi tɔm ntɩ, nɑ ɩ́ nyɑɑlɩ ŋmɑɑtʋ nɑ lʋm nyɑŋ nyǝm mpɩ. ");
INSERT INTO dop_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Ɩlɛnɑ ɩ́ cɛlɑ ɑlʋ kɛ lʋm nyɑŋ nyǝm mpi pǝ kɔŋnɑ mpusi tɔ nɑ ɩ nyɔɔ. Nɑ lʋm mpɩ pǝ́ tʋ ɩ tɑɑ kɛ́ lɑŋwɑkǝllɛ. ");
INSERT INTO dop_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Amɑ kɔtʋlʋ mʋɣɩ ɑlʋ niŋ tɑɑ kɛ́ ɩsɛsɛɛmlɛ kɔtɑɣɑ, nɑ pǝ́cɔ́ ɩ́ pɑɣɑlɩ-kɛɣɛ Tɑcɑɑ, ɩsɩɩ kɔtǝlɑɑ lɑkɩ tɔ. Nɑ ɩ́ sɩɩ kɔtɑɣɑ tǝlɑtɛ. Nɑ ɩ́ cosi ŋkute nte tǝ hʋlǝɣɩ sɩ Tɑcɑɑ tǝnnɑ pǝ tǝnɑ tɔ, nɑ ɩ́ wɔ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Pǝlɛ pǝ wɑɑlɩ kɛ́ ɩ yeki nɑ ɑlʋ nyɔɔ lʋm mpɩ. ");
INSERT INTO dop_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ye tɑmpɑnɑ sɩ ɩ nɑwɑɣɑ nɑ ɩ́ nyɔɔ-wɩ, pǝ hɑɣɑsǝɣɩ ɩ lotu kɛ́ nɑ pǝ́ ŋmǝlǝsɩ ɩ ɑlʋtʋ nɑ ɩ́ pǝsɩ kɑɑlʋlɑɣɑ. Nɑ ye nɔɣɔlʋ cɑɑ sɩ ɩ tǝŋsɩ yǝlɑɑ kɛ mpusi, ɑlʋ ɩnɩ ɩ tɔm kɛ ɩ kɑ́ yɔɣɔtɩ. ");
INSERT INTO dop_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Amɑ ye ɩ́ tɑ nɑ́, pɩɩ lɑkɩ-ɩ pʋlʋ. Ɩ pǝsǝɣɩ nɑ ɩ́ lʋlɩ piyɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","Ye ɑpɑlʋ kpekiɣi ɩ ɑlʋ tɔɔ kɛ́ yem yem lɑkɑsɩ tɑɑ, pǝ kɔtɑɣɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Wɑɑtʋ ɩnɩ ɑpɑlʋ kiŋ kɑɑ wɛɛ nɑtǝlɩ. Ye ɑlʋ wɑkǝlɑɑ, ɩnɩ ɩ kɑ nɑnɑ pǝ nɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Tɛlǝsɩ Ɩsɛɣɛlɩ yǝlɑɑ sɩ, ye ɑpɑlʋ yɑɑ ɑlʋ ɩ́ sɩɩ nɔɣɔ sɩ ɩ hɑɑkɩ ɩ tǝɣɩ Ɩsɔ tǝmlɛ nɑtǝlɩ tǝ tɑɑ, ");
INSERT INTO dop_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","pǝ wɛɛ sɩ ɩ́ kii sʋlʋm. Pɑɑ lɛsɛŋ sʋlʋm toŋ nyǝm. Pǝyele ɩ́ tɑɑ tɩɩ tǝŋ lɛsɛŋ pee lʋm nyǝnɑ yɑɑ kʋwʋlɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Pǝ tɩɩ fɛɩ sɩ ɩ́ tɩɩ tǝŋ lɛsɛŋ pʋlʋpʋ. ");
INSERT INTO dop_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Pǝ́cɔ́ hʋnʋɣʋ kɑɑ kpɑ ɩ nyʋɣʋ tɑɑ, yɑɑ ɩ tɑntʋɣʋ tɔɔ. Pǝ tǝnɑ pɩɩ su ḿpʋ́ɣʋ́, hɑlǝnɑ pǝ kʋyɛɛŋ sɩɩ tǝnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Pǝ fɛɩ sɩ ɩ́ kpǝtǝnɑ sǝtʋ nɔɣɔlʋɣʋ wɑɑtʋ ɩnɩ ɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Pɑɑ ɩ cɑɑ, yɑɑ ɩ too, yɑɑ ɩ tɑɑlʋ. Mpi tɔ, ɩ tɛmɑ ɩ tǝɣɩ Tɑcɑɑ tǝmlɛ tɑɑ kɛ́ hɑʋ kɛ́. Nɑ ḿpʋ́ɣʋ́ ɩ nyɔɔsɩ kʋtɑɣɑlɑsɩ hʋlǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ɩ pǝsɑ Ɩsɔ nyǝŋ kɛ ɩ nɔɣɔ sɩɩʋ wɑɑtʋ tǝnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ye sǝm tutɑ nɔɣɔlʋɣʋ ɩ kɔŋkɔŋ tɑɑ, nɑ pǝ́ pilisi ɩ nyɔɔsɩ yeluɣu mpɩ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ kɛ ɩ cɑkɩ, ɩlɛnɑ ɩ́ looli ɩ nyʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Tɛʋ feŋ ɩlɛnɑ, ɩ́ kɔnɑ kɔtʋlʋ kɛ ɩhokɑsɩ, yɑɑ ɑlukukunɑɑ nɑɑlɛɣɛ Ɩsɔ cokǝle nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Ɩlɛnɑ kɔtʋlʋ lɑ lɛlʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ lɛlʋ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Nɑ ɩ́ lɑpɩ-ɩ pǝ kɔtɑɣɑ nɑ pǝ́ hɩɩsɩ ɩ tɔɔ kɛ́ sǝtʋ ɑsilimɑ. Ɩlɛ ɩ ɑsilimɑ tɛmɑɣɑlɛ kʋyɑŋku. ");
INSERT INTO dop_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ɩlɛnɑ pʋntʋ tɑsɑ ɩ nɔɣɔ sɩɩʋ, nɑ ɩ́ lɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwǝyɑɣɑ kɛ tɑsǝkǝlɛ tɑɣɑnʋɣʋ kɔtɑɣɑ. Pǝ fɛɩ sɩ ɩ́ kɑlǝnɑ kɑncɑɑlɑɣɑ kʋyɛɛŋ kɛ ɩ́lɛ́ ɩ kɑ pilisɑɑ tɔ pǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Wei ɩ sɩɩ ḿpʋ́ɣʋ́ nɔɣɔ tɔ, ye kʋyɑŋku ɩ kʋyɛɛŋ tɛmɑ, ɩ puki Ɩsɔ cokǝle nɔnɔɣɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Nɑ ɩ́ lɑ Tɑcɑɑ kɛ kɔtɑɣɑ kɛ ɩwɑɑʋ kʋlʋmʋɣʋ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ nsi sɩ tiili tɑ cɑɑmɩ tɔɣɔ nɑɑlɛ. Apɑlʋ nyǝŋkɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, nɑ ɑlʋ nyǝŋkɑ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Nɑ ɩwɑɑʋ ŋku kʋ tiili tɑ cɑɑmɩ tɔɣɔ ciikuɣu nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Nɑ ɩ́ kɔnɑ kʋkʋsʋm fɛɩ kɑkɑlɑsɩ nsi sɩ somtu pɑ nuɣutinɑ nim, nɑ pɑ́ tʋ tɔ. Nɑ nsi sɩ tɔɔ pɑ yɔɣɔlɑ nim tɔɣɔ tɔkʋ. Nɑ tɔɣɔnɑɣɑ kʋhɑʋ nɑ pǝ sʋlʋm mpi pɑɑ liisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Ɩlɛnɑ kɔtʋlʋ ponɑ pǝ tǝnɑɣɑ ḿpʋ́ɣʋ́ Tɑcɑɑ, nɑ ɩ́ lɑ́ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Nɑ ɩwɑɑʋ kɛ ciikuɣu nyǝŋkɑ, nɑ pǝ kʋkʋsʋm fɛɩ kɑkɑlɑsɩ tɔkʋ. Pǝ wɑɑlɩ kɛ́ tɔɣɔnɑɣɑ kɔtɑɣɑ nɑ sʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Ɩlɛnɑ nɔɣɔ sɩɩlʋ looli ɩ nyʋɣʋ kɛ cokǝle nɔnɔɣɔ tǝnɑ, nɑ ɩ́ tʋ́ ɩ nyɔɔsɩ kɛ ciikuɣu kɔtɑɣɑ kɔkɔ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Pǝ wɑɑlɩ ɩlɛnɑ kɔtʋlʋ kpɑɣɑ ɩwɑɑʋ hɑmʋɣʋ ŋku pɑ tǝsɑɑ tɔ. Nɑ kʋkʋsʋm fɛɩ kɑkɑlɑsɩ wɑɑnɩ wɑɑnɩ kɛ tɔm nɑɑlɛ, nɑ ɩ́ tʋ́ nɔɣɔ sɩɩlʋ niŋ tɑɑ kɛ wɑɑtʋ wei ɩ tɛmɑ ɩ nyʋɣʋ looluɣu tɔ. ");
INSERT INTO dop_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ɩlɛnɑ kɔtʋlʋ tɑɣɑnɩ-tǝɣɩ Ɩsɔ kɛ́ pɑɣɑlʋɣʋ ɩsɩɩ kɔtǝlɑɑ lɑkɩ tɔ. Nɑ tɔɣɔnɑsɩ nsɩ sɩ pǝsɩ ɩ nyǝnsɩ. Nɑ pǝ́ sɔɔsǝnɑ lɑŋlɛ nɑ yule. ");
INSERT INTO dop_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Yʋlʋ wei ɩ sɩɩkɩ nɔɣɔ sɩ ɩ hɑɑkɩ ɩ tǝɣɩ Ɩsɔ tɔ pǝ sɔɔsɩ ntɛ́. Ɩ́ nɔkɑɑ ɩ sɔɔsɩ pǝ tɔɔ. Amɑ pǝ wɛɛ kɛ́ sɩ ɩ́ lɑ mpi pǝ tǝnɑ ɩ kɑ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Kɛɛsɩ Alɔŋ nɑ ɩ pǝyɑlɑɑ sɩ, koolee nnɑ pɑɑ kooliɣi Ɩsɛɣɛlɩ nyǝ́mɑ tɔɣɔlɛ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Tɑcɑɑ ɩ́ kooli-mɛɣɛ kʋpɑntʋ nɑ ɩ́ kenti mǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Nɑ ɩ́ nyǝnɩ-mɛɣɛ teu nɑ ɩ́ lɑkɩ-mɛɣɛ pɛɛlɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Nɑ ɩ́ wɛɛ mǝ wɑɑlɩ nɑ pǝ́ cɑɣɑnɑ-mɛ. ");
INSERT INTO dop_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ḿpʋ́ɣʋ́ pɑɑ yɑɑkɩ mɑ hǝtɛ kɛ Ɩsɛɣɛlɩ yǝlɑɑ tɔɔ. Ɩlɛnɑ mɑ́ɑ́ kooliɣi-mɛɣɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Kʋyɑŋku Moisi tɛmɑ Ɩsɔ cokǝle sikuɣu, ɩlɛnɑ ɩ́ fɛɛnɩ tǝ́ nɑ tǝ tɑɑ wontu kɛ kɔtɑɣɑ nim, nɑ kɔtɑɣɑ tǝlɑtɛ nɑ tǝ wontu. ");
INSERT INTO dop_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ kpekɑ nyʋɣʋ nyǝ́mɑ mpɑ pɑɑ sǝnɑ kʋkɑlʋɣʋ wɑɑtʋ tɔ, pɑ kɔnɑ pɑ kʋhɑɑŋ ");
INSERT INTO dop_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","kɛ nɑɑŋ nɑɑnʋwɑ nɑ nɑɑlɛ nɑ kɛɛkɛnɑɑ nɑɑtoso. Nɑ pɑ́ wɑɑsɑ pɑ tɔɔ. Pǝ lɩɩwɑ sɩ nyɔɔŋ nyǝ́mɑ nɑɑlɛ cɑɑwɑ nɑɑŋ nɑɑlɛ nɑ kɛɛkɛ kʋlʋm ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Mʋ pɑ kʋhɑɑŋ ɩnɩ, nɑ ń cɛlɑ Lefii nyǝ́mɑ, nɑ pǝ́ kɛɛsǝnɑ pɑɑ mpɑ pɑ tǝmlɛ, nɑ pɑ́ kpɑkǝɣǝnɑ cokǝle wontu. ");
INSERT INTO dop_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ɩlɛnɑ Moisi mʋ nɑɑŋ nɑ kɛɛkɛnɑɑ mpɛ nɑ ɩ́ cɛlɑ Lefii kpekǝle nyǝ́mɑ ");
INSERT INTO dop_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Kɛɛsɔŋ lʋlʋɣʋ nyǝ́mɑ kɛ kɛɛkɛnɑɑ nɑɑlɛ, nɑ nɑɑŋ liɣiti. Nɑ pǝ́ kɛɛsǝnɑ pɑɑ wei ɩ tǝmlɛ, ");
INSERT INTO dop_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","nɑ Melɑli nyǝ́mɑ kɛ kɛɛkɛnɑɑ liɣiti nɑ nɑɑŋ pǝlefɛɩ nɑɑnʋwɑ. Ɩ cɛlɑ-wɛɣɛ, nɑ ɩ́ kɛɛsǝnɑ pɑ tǝmɑ. Alɔŋ pǝyɑlʋ Ɩtɑmɑɑ pɑɑsǝɣǝnɑnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Kehɑtɩ nyǝ́mɑ nɑ́ pɑɑsɑɣɑnɑ kɔtɑɣɑ wontunɑɑ kɛ́. Ɩlɛ ɩ tɑ cɛlɑ-wɛɣɛ kɛɛkɛ, yɑɑ nɑʋ. Mpi tɔ, pɩɩ wɛɛ sɩ pɑ́ hɔɣɔlǝɣɩ-tǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kʋyɑŋku pɑ fɛɛnɑɣɑ kɔtɑɣɑ tǝlɑtɛ, ɩlɛnɑ lʋlʋŋ nyɔɔŋ nyǝ́mɑ kɔnɑ tɔtɔɣɔ pɑ kʋcɔɔŋ sɩ pɑ tʋlǝɣǝnɑ-tɛ. ");
INSERT INTO dop_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: Nyʋɣʋ nyǝ́mɑ kɑ́ kɔɔ kʋlʋm kʋlʋm kɛ́ kʋyɑkʋ kʋyɑkʋ nɑ pɑ́ hɑ pɑ kʋcɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Ɩsǝnɑ pɑ tǝŋɑ tǝmɑ nɑ pɑ́ kɔɔ tɔɣɔlɔ: Yutɑ kpekǝle tʋ Aminɑtɑpɩ pǝyɑlʋ Nɑsɔŋ kɛlɛ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ. Ɩsɑkɑɑ nyǝntɛ tʋ Suwɑɑ pǝyɑlʋ Netɑneyɛlɩ kɛ kʋyɑkʋ nɑɑlɛ nyǝŋkʋ. Sɑpulɔŋ nyǝntɛ tʋ Helɔŋ pǝyɑlʋ Ɩliyɑpɩ kɛ kʋyɑkʋ tooso nyǝŋkʋ. Lupɛŋ nyǝntɛ tʋ Setewu pǝyɑlʋ Ɩlisuu kɛ kʋyɑkʋ liɣiti nyǝŋkʋ. Simiyɔŋ nyǝntɛ tʋ Sulisɑtɑɩ pǝyɑlʋ Selumǝyɛlɩ kɛ kʋyɑkʋ kɑkpɑsɩ nyǝŋkʋ. Kɑtɩ nyǝntɛ tʋ Teuwɛlɩ pǝyɑlʋ Ɩliyɑsɑfɩ kɛ kʋyɑkʋ nɑɑtoso nyǝŋkʋ. Ɩfǝlɑyim nyǝntɛ tʋ Amihuti pǝyɑlʋ Ɩlisɑmɑ kɛ kʋyɑkʋ nɑɑtosomopɔɣɔlɑɣɑ nyǝŋkʋ. Mɑnɑsee nyǝntɛ tʋ Petɑsuu pǝyɑlʋ Kɑmliyɛlɩ kɛ kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ. Pɛncɑmɛɛ nyǝntɛ tʋ Kitoni pǝyɑlʋ Apitɑŋ kɛ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ nyǝŋkʋ. Tɑŋ nyǝntɛ tʋ Amisɑtɑɩ pǝyɑlʋ Ahiyesɛɛ kɛ nɑɑnʋwɑ nyǝŋkʋ. Asɛɛ nyǝntɛ tʋ Okǝlɑŋ pǝyɑlʋ Pɑkiyɛlɩ kɛ nɑɑnʋwɑ nɑ kʋlʋmʋɣʋ nyǝŋkʋ. Nɛfǝtɑli nyǝntɛ tʋ Ɩnɑŋ pǝyɑlʋ Ahilɑ kɛ nɑɑnʋwɑ nɑ nɑɑlɛ nyǝŋkʋ. Mpi mpi pɑ kɔnɑɑ tɔɣɔlɔ: Liɣitee nyǝɣǝlʋɣʋ nyǝnɑɣɑ ŋkɑ kɑ yuŋ wɛ kiloo kʋlʋm nɑ cɑcɑɑsɩ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ tɔ (1300). Nɑ pǝ poosiyɑ wei pɑ ŋmɩɩsǝɣǝnɑ cɑlǝm tɔ. Ɩ́lɛ́ ɩ cɑcɑɑsɩ wɛ nɑsǝtoso nɑ nɩɩnʋwɑ (700). Ɩsǝnɑ pɑ mɑɣɑsɑɣɑ Ɩsɔ cokǝle tɑɑ kɛ́ liɣitee tɔɣɔ pɑ kɛɛsǝnɑɑ. Nɑ pɑ́ suuli nyǝnɑsɩ nsɩ sɩ nɑɑlɛɣɛ tɔɣɔnɑɣɑ kɔtɑɣɑ mʋlʋm mpi pɑ nuɣutinɑ nim tɔ. Wʋlɑ kɔpʋ, kɛ cɑcɑɑsɩ nɩɩnʋwɑ (100). Nɑ tulɑɑlʋ kʋwɔpʋ kɛ kɔpʋ ɩnɩ ɩ lǝpɑm. Nɑ lɑtǝcɛ, nɑ ɩwɑɑʋ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwǝyɑɣɑ sɩ, pɑ lɑkǝnɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Nɑ pǝŋtʋlʋɣʋ sɩ pɑ lɑkɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋkɑ. Nɑɑŋ nɑɑlɛ nɑ ɩwɑɑŋ kɛ kɑkpɑsɩ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ kɑkpɑsɩ sɩ pɑ lɑkǝnɑ ciikuɣu kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Ɩsɛɣɛlɩ kpekɑ nyɔɔŋ nyǝ́mɑ hɑwɑ kʋcɔɔŋ wei kɛ kɔtɑɣɑ tǝlɑtɛ tʋlʋɣʋ wule tɔɣɔlɛ. Liɣitee nyǝɣǝtʋ nyǝnɑsɩ kɛ nɑɑnʋwɑ nɑ nɑɑlɛ. Nɑ poosiyɑnɑɑ mpɑ pɑ ŋmɩɩsǝɣǝnɑ cɑlǝm tɔɣɔ nɑɑnʋwɑ nɑ nɑɑlɛ. Nɑ wʋlɑ kɔpʋnɑɑ kɛ nɑɑnʋwɑ nɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Pɑɑ nyǝnɑɣɑ ŋkɑ kɑ yuŋ wɛ kiloo kʋlʋm nɑ cɑcɑɑsɩ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (1300). Nɑ pɑɑ poosiyɑ wei kɛ́ cɑcɑɑsɩ nɑsǝtoso nɑ nɩɩnʋwɑ (700). Pǝ kpɛntɑ liɣitee nyǝɣǝtʋ kiloonɑɑ hiu nɑ liɣiti. Ɩsɩɩ pɑ mɑɣɑsʋɣʋ Ɩsɔ cokǝle tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Pɑɑ wʋlɑ kɔpʋ wei ɩ kɑ wɛ cɑcɑɑsɩ nɩɩnʋwɑ (100) kɛ́. Pǝ kpɛntɑ kiloo kʋlʋm nɑ cɑcɑɑsɩ ŋmʋnʋɣʋ (1200). Kɔpʋnɑɑ mpɛ pɑɑ sunɑ tulɑɑlʋ kʋwɔpʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Pǝ kɑɑsɩ lɑtǝcɛnɑɑ nɑɑnʋwɑ nɑ nɑɑlɛ, nɑ ɩwɑɑŋ kɛ mpʋ. Nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ mpʋ tɔtɔ. Sɩ pɑ lɑkǝnɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ nɑ pǝ́ sɔɔsǝnɑ tɔɣɔnɑɣɑ kɔtɑɣɑ, nɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ pǝŋtʋlʋŋ kɛ nɑɑnʋwɑ nɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Nɑ lɑtǝcɛnɑɑ kɛ hiu nɑ liɣiti. Ɩwɑɑŋ kɛ nɩɩtoso, pǝŋtʋlʋŋ kɛ mpʋ. Nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ mpʋ tɔtɔ. Sɩ pɑ lɑkɩ ciikuɣu kɔtɑsɩ. Kʋcɔɔŋ wei pɑ hɑwɑ kɔtɑɣɑ tǝlɑtɛ tʋlʋɣʋ tɔɔ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Wɑɑtʋ wei Moisi sʋʋ cokǝle tɑɑ kɛ́ Ɩsɔ yɔɣɔtǝnɑʋ tɔ, ɩ nɩɩkɑɣɑ Ɩsɔ nɔɣɔ kɛ ɩsɔtɑɑ tɑŋlɑɑ mpɑ pɑ wɛ Ɩsɔ ɑtɑkɑɑ pile tɔɔ tɔ pɑ hɛkʋ kɛ́. Nɑ ɩ́ yɔɣɔtǝɣǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Tɛlǝsɩ Alɔŋ sɩ wɑɑtʋ wei n sɩɩkɩ fǝtǝlɑ sɔsɔ kɔkɔsɩ nɑɑtosompɔɣɔlɑɣɑ ɩnɩ tɔ, pɑɑsǝnɑ nɑ pǝ́ nɑɑkɩ fǝtǝlɑ sɔsɔ ɩnɩ ɩ lɔlɔ. ");
INSERT INTO dop_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ɩlɛnɑ Alɔŋ lɑ́ ɩsɩɩ Tɑcɑɑ kɛɛsʋɣʋ Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Wʋlɑ tike kɛ Moisi lɑpɑ nɑ pɑ́ lu fǝtǝlɑnɑɑ tǝsɩɩlɛ tǝnɑ. Pǝ kpɑɣɑʋ tǝ tɑpʋɣʋ, hɑlǝnɑ tǝ tomle nte tǝ nǝɣǝsǝnɑ ɩsɩɩ tʋɣʋ hɛtʋ tɔ. Ɩsɩɩ Tɑcɑɑ kɑ hʋlɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Fɑɣɑ Lefii nyǝ́mɑ nɑ pɑ mpɑɑ. Lɑ-wɛɣɛ nyɔɔŋ tɔɔ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Nmɩɩsɩ pɑ tɔɔ kɛ́ kɔtɑɣɑ lʋm, nɑ pɑ́ hʋ pɑ tɔɔ hʋntʋ tǝnɑ. Nɑ pɑ́ cɔtɔ pɑ wontu, ɩlɛnɑ pǝ́ kɛɛlɩ pɑ nyɔɔŋ tɔɔ ɑsilimɑ. ");
INSERT INTO dop_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ɩlɛnɑ pɑ́ kpɑɣɑ lɑtǝcɛ nɑ kɔtɑɣɑ mʋlʋm mpi pɑ nuɣutinɑ nim tɔ. Nɑ Moisi nɑ́ɑ́ kpɑɣɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ lɑtǝcɛ nɑɑlɛ nyǝŋ. ");
INSERT INTO dop_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","10","Nɑ ɩ́ koti Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɑ Lefii nyǝ́mɑ kpǝtǝnɑ Ɩsɔ cokǝle nɔnɔɣɔ. Nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɩ pɑ tɔɔ kɛ́ niŋ. ");
INSERT INTO dop_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Ɩlɛnɑ Alɔŋ hʋlɩ Lefii nyǝ́mɑ kɛ Ɩsɔ nɑ hɔɣɔlǝŋ tǝnɑ, ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ lɑkʋɣʋ Ɩsɔ nyǝm tɔ. Ɩlɛnɑ pɛlɛ pɑ lɑkɩ Ɩsɔ kɛ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Pǝ wɑɑlɩ ɩlɛnɑ Lefii nyǝ́mɑ tǝnɩ pɑ niŋ kɛ lɑtǝcɛnɑɑ nɑɑlɛ tɔɔ nɑ Alɔŋ lɑ-m lɛlʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ lɛlʋ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Ɩlɛ Lefii nyǝ́mɑ ɩsɑɣɑtʋ hɩɩsɑɑ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ɩlɛnɑ ń sɩɩ Lefii nyǝ́mɑ kɛ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ ɩsɛntɑɑ. Nɑ ń hʋlɩ-wɛ nɑ hɔɣɔlǝŋ tǝnɑ ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ lɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Nɑ Lefii nyǝ́mɑ pǝsɩ Ɩsɔ nyǝ́mɑ nɑ pǝ́ fɑɣɑ pɑ nɑ pɑ tɛɛtʋnɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Pǝlɛ pǝ wɑɑlɩ kɛ́ pɑɑ cɑɑlɩ pɑ tǝmlɛ kɛ cokǝle tɑɑ. Ɩsǝnɑ ɩ́ kɑ́ lɑ Lefii nyǝ́mɑ kɛ nyɔɔŋ tɔɔ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ, nɑ ɩ́ hʋlɩ-wɛ nɑ hɔɣɔlǝŋ tǝnɑ ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ lɑkɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑɑ sɩ: Mǝ kɛnɑ mɑ nyǝm. Mpi tɔ, mɑ lɛɛtɑ-mɛɣɛ Ɩsɛɣɛlɩ nyǝ́mɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ lonɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Kʋyɑkʋ ŋku mɑ kʋwɑ Icipiti tɑɑ yǝlɑɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ tɔ, pǝ kpɑɣɑʋ wɑɑtʋ ɩnɩ tɔ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ tǝnɑ pǝsɑ mɑ nyǝm kɛ́. Pɑɑ yǝlɑɑ nyǝnsɩ, pɑɑ tɔlɑ nyǝnsɩ. ");
INSERT INTO dop_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Lefii nyǝ́mɑ kɛ mɑ lɛɛtɑ Ɩsɛɣɛlɩ kɑncɑɑlɑɣɑ ɑpɑlʋnyǝnsɩ lonte. ");
INSERT INTO dop_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Nɑ sɑmɑɑ tilinɑ-wɛɣɛ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ kiŋ nɑ pɑ́ lɑkɩ tǝmɑ nɑ pɑ nɔɣɔ kɛ cokǝle tɑɑ, nɑ Tɑcɑɑ hɩɩsɩ sɑmɑɑ ɩsɑɣɑtʋ. Pǝ́ tɑɑ kɔɔ nɑ pɑ́ kpǝtǝnɑ Ɩsɔ cokǝle nɑ ɩ́ wɑkǝlɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ḿpʋ́ɣʋ́ Moisi nɑ Alɔŋ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ, pɑ lɑpɑ teitei ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ-wɛɣɛ Lefii nyǝ́mɑ tɔm tɔ. ");
INSERT INTO dop_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Pɑ cɔtɑ pɑ wontu nɑ pɑ́ sɔ lʋm. Nɑ Alɔŋ hʋlɩ-wɛɣɛ Ɩsɔ nɑ hɔɣɔlǝŋ tǝnɑ ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ lɑkɩ tɔ. Nɑ ɩ́ lɑ-wɛɣɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ ɑsilimɑ kɛɛlʋɣʋ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Pǝ wɑɑlɩ kɛ́ Lefii nyǝ́mɑ cɑɑlɑ pɑ tǝmlɛ kɛ Ɩsɔ cokǝle tɑɑ. Nɑ Alɔŋ nɑ ɩ pǝyɑlɑɑ pɑ́ feŋiɣi-wɛ. Ɩsǝnɑ pɑ lɑpɑ nti Tɑcɑɑ kɑ heelɑ Moisi tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu sɩ: ");
INSERT INTO dop_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Mpi pǝ kɛ́ Lefii nyǝ́mɑ nyǝntʋ tɔɣɔlɔ. Pɑɑ Lefii tʋ wei, ye ɩ wɛnɑ pɩɩsɩ hiu nɑ kɑkpɑsɩ nɑ wɑɑlɩ kɛ mpʋ, wɑɑtʋ ɩnǝɣɩ ɩ kɑ cɑɑlɩ Ɩsɔ cokǝle tɑɑ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ɩlɛnɑ pɑ́ cɛpɩ-ɩ ɩ pɩɩsɩ nɩɩlɛ nɑ nɑɑnʋwɑ nyǝŋkɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ye pɑ cɛpɑ wei, ɩ pǝsǝɣɩ nɑ ɩ́ sǝnɑ ɩ tɛɛtʋnɑɑ kɛ Ɩsɔ cokǝle tǝmlɛ yɑɑ. Amɑ pɑ kɑɑ tʋ-ɩ ɩ mɑɣɑmɑɣɑ ɩ nyǝntɛ kɛ́. Ɩsǝnɑ Moisi kɑ́ lɑkɩ Lefii nyǝ́mɑ tǝmlɛ tɔm tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ɩsɛɣɛlɩ nyǝ́mɑ Icipiti tɑɑ lɩɩʋ pǝnɑɣɑ nɑɑlɛ nyǝŋkɑ ɩsɔtʋ kɑncɑɑlɑɣɑ nyǝŋ tɑɑ, Tɑcɑɑ tɔmɑ Moisi kɛ Holɛpʋ wʋlɑɣɑ tɛtʋ tɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Pǝ wɛɛ sɩ, Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ tɔɣɔ Tɛɛʋ ɑcimɑ kɛ kʋyɑkʋ ŋku mɑ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ɩsɔtʋ ɩnɛ ɩ kʋyɑkʋ nɑɑnʋwɑ nɑ liɣiti nyǝŋkʋ wule tɑɑnɑɣɑ kɛ ɩ́ kɑ́ tɔɣɔ-yɛ, ɩsɩɩ pɑ sɩɩʋ pǝ kiiŋ nɑ pǝ kʋsǝsɩɩtʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ɩlɛnɑ Moisi tɛlǝsɩ tɔm ntǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ḿpʋ́ɣʋ́ pɑ tɔɣɔ Tɛɛʋ ɑcimɑ kɛ kʋyɑkʋ ŋkʋɣʋ Holɛpʋ wʋlɑɣɑ tɛtʋ tɑɑ kɛ teitei ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Amɑ nɑpǝlɩ pɑ tokinɑ sǝtʋ nɑ pǝ́ pilisi-wɛɣɛ kʋyɑkʋ ŋkʋ. Ɩlɛ pɑ tɑ pǝsɩ nɑ pɑ́ tɔɣɔ Tɛɛʋ ɑcimɑ, nɑ pɑ́ polo nɑ pɑ́ kɛɛsɩ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Tǝ pilisɑ tɑ tɩ nɑ sǝtʋ tɔ, pɩɩ kɑɣɑtɩ-tʋ sɩ tǝ ponɑ Tɑcɑɑ kɛ kʋhɑʋ, ɩsɩɩ lɛlɑɑ kɛ kʋyɑkʋ ŋku pɑ sɩɩwɑ tɔ, kʋ wule nɑ? ");
INSERT INTO dop_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Ntɛnɑ Moisi sɩ: Ɩ́ yele nɑ Tɑcɑɑ hʋlɩ-m ɩsǝnɑ pǝ wɛɛ sɩ ɩ́ lɑ tɔ nɑ pǝ́cɔ́. ");
INSERT INTO dop_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, pǝ kpɑɣɑʋ sɑŋɑ nɑ pǝ́ puki tɔ, ye nɔɣɔlʋ tokinɑ sǝtʋ nɑ pǝ pilisi-ɩ, yɑɑ ɩ polɑ mpɑɑʋ kɛ ɑcimɑ wule, ");
INSERT INTO dop_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ɩlɛ ɩ tɔɣɔ-yɛɣɛ ɩsɔtʋ nɑɑlɛ nyǝŋ kʋyɑkʋ nɑɑnʋwɑ nɑ liɣiti wule tɑɑnɑɣɑ, nɑ kɔtɑɣɑ ɩwǝyɑɣɑ nɑ kʋkʋsʋm fɛɩ kɑkɑlɑsɩ nɑ tuusi nyɑŋ nyǝnsɩ. ");
INSERT INTO dop_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Pǝ tɔɣɔnɑɣɑ ɩ́ tɑɑ fe tɛʋ. Pǝyele ɩ́ tɑɑ yɔkɩ kpǝntɛ mʋɣʋlɛ. Pǝ wɛɛ sɩ ɩ́ tǝŋ Tɛɛʋ ɑcimɑ kɔtɑsɩ kɛ teitei kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Amɑ ye nɔɣɔlʋ lɑpɑ Tɛɛʋ ɑcimɑ kʋyɑkʋ ŋkʋɣʋ ɑwusɑ, nɑ pǝ́ tɑ́ kɛ́ sɩ ɑsilimɑ nɑɑlɩ, yɑɑ ɩ tɔŋ mpɑɑʋ ɩ tɔm sǝpɑɣɑ. Pɑɑ lǝsɩ-ɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ kɛ́ mpi pǝ tɔɔ ɩ tɑ kɔnɑ ɩ kʋhɑʋ kɛ pǝ kʋyɑkʋ wule tɔ. ");
INSERT INTO dop_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ye mǝ ɩcɑtɛ tɑɑ cɑɣɑlʋ tɔkɩ, ɩ kɑ́ tǝŋ ɑ kiiŋ kɛ́ nɑ ɑ kʋsǝsɩɩtʋ. Kʋlʋmtʋ ntǝɣɩ Ɩsɛɣɛlɩ tʋ nɑ cɑɣɑlʋ pɑɑ tɔkɩ. ");
INSERT INTO dop_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Kʋyɑkʋ ŋku pɑ sikɑ nɔɣɔ pɛɛlʋɣʋ wontu cokǝle tɔɣɔ ɩsɔŋmʋntʋ sʋʋ wɑɑsʋɣʋ kɛ tǝ tɔɔ kɛ tɑm. Nɑ tǝ́ mʋɣɩ kɔkɔ kɛ pɑɑ ɑhoo nnɑ, hɑlǝnɑ pǝ nyɑɑlǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ye ɩ́ cɑɑkɩ lonte lɑɣɑsʋɣʋ ɩlɛ ɩsɔŋmʋntʋ kɛɛlɩ Ɩsɔ cokǝle tɔɔ nɑ ɩ́ tɛmɑ ɩlɛ tǝ mǝlɩ. ");
INSERT INTO dop_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","19","Tɑcɑɑ hʋlǝɣǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ mɛɣɛ wɑɑtʋ wei ɩ́ kɑ́ kpɛsɩ tɔ, nɑ wɑɑtʋ wei ɩ́ kɑ siki tɔ. Ye ɩsɔŋmʋntʋ leelɑ Ɩsɔ cokǝle tɔɔ, Ɩsɛɣɛlɩ nyǝ́mɑ nɩɩkǝnɑ Ɩsɔ kɛ́. Pɑɑ lɑɣɑsǝɣɩ lonte. ");
INSERT INTO dop_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Pɑɑ pǝ kɑɑsɑ-tǝɣɩ kʋyɛɛŋ kɛ pǝ́cɔ́ pɑ wɛ ḿpʋ́ɣʋ́. Tɑcɑɑ kɑ kɛɛlɩ-tǝɣɩ nɑ pǝ́cɔ́ pɑ́ kpɛsɩ. ");
INSERT INTO dop_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Wulee wulee ɩlɛnɑ ɩsɔŋmʋntʋ cɑɣɑ lonte kʋlʋmtǝlɛ kɛ tɑɑnɑɣɑ, hɑlǝnɑ pǝ nyɑɑlɩ. Yɑɑ kʋyɑkʋ kʋlʋmʋɣʋ nɑ ɑhoo kʋlʋmɛɛ. Ye tǝ kɛɛlɑ kpɑkpɑɑ ɩlɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Amɑ ye tǝ nyɑlɑ ḿpʋ́ɣʋ́ Ɩsɔ cokǝle tɔɔ kɛ́ kʋyɛɛŋ nɑɑlɛ, yɑɑ ɩsɔtʋ, yɑɑ pǝ tɛɛ mpʋ. Ɩsɛɣɛlɩ nyǝ́mɑ wɛ ḿpʋ́ɣʋ́, hɑlǝnɑ tǝ́ kɛɛlɩ nɑ pǝ́cɔ́. ");
INSERT INTO dop_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ye pɑ sikɑɑ nɑ Tɑcɑɑ tɑ tɔ́ sɩ pɑ́ kʋlɩ, pɑɑ kʋlǝɣɩ. Ḿpʋ́ɣʋ́ pɑ lɑkɑɣɑ pɑ tǝmɑ nnɑ Tɑcɑɑ tʋ-wɛ nɑ Moisi nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Lu liɣitee nyǝɣǝtʋ kɛ ɑkɑntɛɛ nɑɑlɛ. Anǝɣɩ pɑɑ hʋlɩ nɑ sɑmɑɑ kpeɣeli, yɑɑ kpekɑ tʋ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Wɑɑtʋ wei pɑ́ hʋlɑ ɑ nɑɑlɛ, ɩlɛ Ɩsɛɣɛlɩ sɑmɑɑ koti ɩ cɔlɔɣɔ cokǝle nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ye kʋlʋmtǝlɛ kɛ pɑ hʋlɑɑ, ɩlɛ nyʋɣʋ nyǝ́mɑ tike koti. ");
INSERT INTO dop_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","6","Ye pɑ hʋlɑ ɑkɑntǝlɛ nɑ kɑkiisɑsɩ, ɩlɛ tɛɛʋ ntɛ́. Pɑ hʋlǝɣɩ tɔm kɑncɑɑlɑɣɑ nyǝm, ɩlɛnɑ Ɩsɛɣɛlɩ kpekǝle nte tɩɩ sikinɑ cokǝle ilim tǝlɩɩlɛ tɔɔ tɔ, tǝ́ tʋ́ mpɑɑʋ. Pɑ tɑsǝɣɩ nɑɑlɛ nyǝm, ɩlɛnɑ ilim mpǝtǝŋ nyǝntɛ nɑ́ɑ́ tǝŋ. ");
INSERT INTO dop_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ye pǝ kɛ́ sɩ yǝlɑɑ kotuɣu, pɑ kɑɑ hʋlǝnɑ kɑkiisɑsɩ. ");
INSERT INTO dop_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Alɔŋ pǝyɑlɑɑ kɔtǝlɑɑ tike kɑ hʋlǝɣǝnɑ ɑkɑntɛɛ ɑnɩ. Pǝ wɛɛ sɩ mǝ nɑ mǝ piyɑ piyɑ, ɩ́ kɑ́ tɔkɩ kʋsǝsɩɩtʋ tǝnɛɣɛ tɑm tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ye ɩ polɑ mǝ kolontunɑɑ kɛ yoonɑʋ nɑ pɑ kʋlǝɣɩ mǝ tɔɔ, ɩlɛ ɩ́ hʋlɩ ɑkɑntɛɛ nɑ kɑkiisɑsɩ ɩlɛnɑ Tɑcɑɑ mǝ Ɩsɔ mɑ́, mɑ tɔɔsɩ mǝ tɔɔ nɑ mɑ́ wɑɑsɩ-mɛ. ");
INSERT INTO dop_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Mpʋ tɔtɔɣɔ ɩ́ kɑ hʋlǝɣɩ-yɛɣɛ mǝ ɑyɔɔlɑ kʋyɛɛŋ, nɑ mǝ ɑcimɑ nyǝŋ, nɑ mǝ ɩsɔtʋnɑɑ kɑncɑɑlɑɣɑ kʋyɛɛŋ, kɛ wɑɑtʋ wei ɩ lɑkɩ kɔtɑsɩ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔ nɑ ciikuɣu nyǝnsɩ. Ɩlɛnɑ mɑ́ tɔɔsɩ mǝ tɔɔ. Mɑɣɑlɛ Tɑcɑɑ mǝ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ɩsɛɣɛlɩ nyǝ́mɑ Icipiti lɩɩʋ pǝnɑɣɑ nɑɑlɛ nyǝŋkɑ, ɩsɔtʋ nɑɑlɛ nyǝŋ kʋyɑkʋ hiu nyǝŋkʋ kɛ ɩsɔŋmʋntʋ kɛɛlɑ Ɩsɔ cokǝle tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ kʋlɑ Holɛpʋ wʋlɑɣɑ tɛtʋ tɑɑ. Ɩlɛnɑ ɩsɔŋmʋntʋ tii Pɑlɑŋ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ɩsɛɣɛlɩ nyǝ́mɑ kʋlɑ tɔm kɑncɑɑlɑɣɑ nyǝm pǝnɛɣɛ, ɩsɩɩ Tɑcɑɑ kɛɛsʋɣʋ Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yutɑ yoolɑɑ tintiɣile nɑ pɑ tuutɑ kɛlɛ nɔɣɔ tɔɔ. Aminɑtɑpɩ pǝyɑlʋ Nɑsɔŋ kɛlɛ pɑ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ɩsɑkɑɑ nyǝ́mɑ nyʋɣʋ tʋ ntɛ́ Suwɑɑ pǝyɑlʋ Netɑneyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Sɑpulɔŋ nyǝ́mɑ nyǝŋ ntɛ́ Helɔŋ pǝyɑlʋ Ɩliyɑpɩ. ");
INSERT INTO dop_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ḿpʋ́ɣʋ́ pɑ hɛtɑ cokǝle, nɑ Kɛɛsɔŋ nɑ Melɑli pɑ pǝyɑlɑɑ kpɑɣɑ-tɛ. ");
INSERT INTO dop_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ɩlɛnɑ Lupɛŋ yoolɑɑ tintiɣile, nɑ pɑ tuutɑ pɑ́ tʋ́ pɑ wɑɑlɩ. Pɛlɛ pɑ nyʋɣʋ tʋ ntɛ́ Setewu pǝyɑlʋ Ɩlisuu. ");
INSERT INTO dop_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simiyɔŋ nyǝ́mɑ nyʋɣʋ tʋ ntɛ́ Sulisɑtɑɩ pǝyɑlʋ Selumǝyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Kɑtɩ nyǝ́mɑ nyǝŋ ntɛ́ Teuwɛlɩ pǝyɑlʋ Ɩliyɑsɑfɩ. ");
INSERT INTO dop_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ɩlɛnɑ Lefii tʋ Kehɑtɩ lʋlʋɣʋ nyǝ́mɑ mpɑ pɑ sǝɣǝlɑ ɩsɔ sɛɛʋ wontu tɔ pɑ́ tǝŋ. Nɑ Lefii nyǝ́mɑ lɛlɑɑ nɑ́ɑ́ tɔŋɑ cokǝle sikuɣu nɑ pɑ́ tɑŋɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ɩlɛnɑ Ɩfǝlɑyim yoolɑɑ tintiɣile nɑ pɑ tuutɑ pɑ́ tʋ́ pɑ wɑɑlɩ. Pɛlɛ pɑ nyʋɣʋ tʋ ntɛ́ Amihuti pǝyɑlʋ Ɩlisɑmɑ. ");
INSERT INTO dop_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Mɑnɑsee nyǝ́mɑ nyǝŋ ntɛ́ Petɑsuu pǝyɑlʋ Kɑmliyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Pɛncɑmɛɛ nyǝ́mɑ nyǝŋ ntɛ́ Kitoni pǝyɑlʋ Apitɑŋ. ");
INSERT INTO dop_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Pǝ wɑɑlɩ kɛ́ Tɑŋ yoolɑɑ tintiɣile nte tǝ kɛ́ wɑɑlɩ tɑŋlɑɑ tɔ, tǝ́ nɑ tǝ tuutɑ tǝ tʋ́ mpɑɑʋ. Amisɑtɑɩ pǝyɑlʋ Ahiyesɛɛ kɛlɛ pɑ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Asɛɛ nyǝ́mɑ nyǝŋ ntɛ́ Okǝlɑŋ pǝyɑlʋ Pɑkiyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Nefǝtɑli nyǝ́mɑ nyǝŋ ntɛ́ Ɩnɑŋ pǝyɑlʋ Ahilɑ. ");
INSERT INTO dop_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ɩsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kpɛsɑ pɑ tǝsikile nɑ pɑ́ tʋ́ mpɑɑʋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ḿpʋ́ɣʋ́ Moisi tɔmɑ ɩ yǝtɩ Mɑtiyɑŋ tʋ Lewɛlɩ pǝyɑlʋ Hopɑpɩ sɩ: Tɛtʋ nti Tɑcɑɑ sɩɩ nɔɣɔ sɩ ɩ hɑɑkɩ-tʋ tɔ, tǝ tɑɑ kɛ́ tǝ puki. Ɩlɛ tǝŋ-tʋ nɑ tɩɩ tɑlǝnɑ-ŋ kʋpɑntʋ nti ɩ lɑkɩ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ntɛnɑ ɩ́lɛ́ ɩ kisi sɩ ɩ mǝlǝɣɩ ɩ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mpʋɣʋlɛ Moisi sɩ: Tɑɑ lɔ-tʋ. Mpi tɔ, nyɑ́ nyǝmnɑ wʋlɑɣɑ tɛtʋ tɑɑ timpi timpi tɩɩ siki tɔ, tǝŋ-tʋ nɑ ń hʋlɩ-tʋ. ");
INSERT INTO dop_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ye n tǝŋɑ-tʋ, tɩɩ tɑlǝnɑ-ŋ kʋpɑntʋ nti Tɑcɑɑ kɑ lɑ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ḿpʋ́ɣʋ́ tǝ kʋlɑ Tɑcɑɑ pʋɣʋ cɔlɔ, nɑ tǝ́ tɔ́ kʋyɛɛŋ tooso. Nɑ Ɩsɔ ɑtɑkɑɑ kɛ́ tɑ nɔɣɔ tɔɔ sɩ ɩ pɛɛkǝɣɩ-tʋɣʋ timpi tɩɩ siki nɑ tǝ́ hɛɛsɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ilim tɑɑ kɛ tǝ kʋlɑɑ, nɑ ɩsɔŋmʋntʋ wɛ tɑ nyɔɔŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tǝ tɛɛkɑɣɑnɑ Ɩsɔ ɑtɑkɑɑ ɩlɛnɑ Moisi yɔɣɔtǝnɑ nɔɣɔ sɔsɑɣɑ sɩ: Tɑcɑɑ sǝŋ nyɑ́ nɑɑsɩ tɑɑ, nɑ nyɑ́ kolontunɑɑ nɑ mpɑ pɑɑ cɑɑ-ŋ tɔ pɑ́ yɑ́. ");
INSERT INTO dop_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Wɑɑtʋ wei pɑ sɩɩkɑɣɑ Ɩsɔ ɑtɑkɑɑ, ɩlɛnɑ Moisi tɑsɑ sɩ: Tɑcɑɑ kɔɔ, nɑ ń cɑɣɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɑ tɑ hɛkʋ. Mpi tɔ, tǝ wɛ pɑɣɑlɛ kɛ́, tǝ fɛɩ kɑlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Ɩsɛɣɛlɩ nyǝ́mɑ kʋntǝnɑ Tɑcɑɑ, nɑ pɑ́ɑ́nɑ́ kpɑ-ɩ. Nɑ ɩ́ tisi kɔkɔ nɑ kɑ́ nyɑɣɑ tisikile kɛ pǝcɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ntɛnɑ sɑmɑɑ wiinɑ Moisi tǝkpɛɛ, nɑ ɩ́lɛ́ ɩ sǝlǝmǝnɑ-wɛɣɛ Tɑcɑɑ nɑ kɔkɔ te. ");
INSERT INTO dop_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ɩlɛnɑ pɑ́ hɑ lonte ntɛɣɛ hǝtɛ sɩ Tɑpelɑ. Nyɑɣɑʋ kɛ pɑ yɑɑ mpʋ nɑ pɑ tɛ tɑɑ. Mpi tɔ, tǝnɑɣɑ Tɑcɑɑ kɑ nyɑɣɑsɑ pɑ tǝsikile. ");
INSERT INTO dop_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ luluɣu kpɑwɑ cɑɣɑlɑɑ. Ɩlɛnɑ pǝ kpɛnnɑ Ɩsɛɣɛlɩ nyǝ́mɑ mɑɣɑmɑɣɑ nɑ pɑ́ tɑɣɑnǝɣɩ kʋntʋɣʋ sɩ: Tɩɩ hiki nɑntʋ ntɛ́ nɑ tǝ́ tɔɣɔ? ");
INSERT INTO dop_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Aɑ kɑɩ, yǝlɑɑ tɔɣɔ Icipiti tɑɑ kɛ́ tiinɑ kɛ fɑɑlɑɑ. Nɑ kɑɑmɑ mɑɣɑmɑɣɑ nɑ ɑ nǝɣǝsǝlɛnɑɑ mpɑ pɑ tɔkǝnɑ lɛŋ tɔ, nɑ kɑɑpǝnɑɑ kɛ wɑɑnɩ wɑɑnɩ. ");
INSERT INTO dop_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Amɑ pǝ tɑɑ pʋlʋ fɛɩ cǝnɛ. Mɑnnɑ ɩnǝɣǝlɛ Mɑnnɑ, nɑ tǝ́ tɛŋ tɑɑsɩ. ");
INSERT INTO dop_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mɑnnɑ ɩnɩ ɩ kɑ nǝɣǝsǝnɑ kɛ́ ɩsɩɩ pee kʋhʋlʋmɛɛ nɑɑlɩ, ɩ wɛ ɩsɩɩ tʋɣʋ nɑkʋlɩ kʋ cǝlǝm. ");
INSERT INTO dop_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Ahoo kɛ cɔlɔʋ kpɑɑkɩ tǝsikile, ɩlɛnɑ Mɑnnɑ hoti. Pǝ nyɑɑlǝɣɩ, ɩlɛnɑ sɑmɑɑ cɔɔ nɑ pɑ́ kuuki, nɑ pɑ́ nɑŋǝɣɩ yɑɑ pɑ́ sɔkɩ, nɑ pɑ́ tǝsǝɣɩ, yɑɑ pɑ́ tʋɣɩ kɑkɑlɑsɩ. Ɩ leleŋ wɛ kɛ ɩsɩɩ nim kɑkɑlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mpʋɣʋlɛ Ɩsɛɣɛlɩ nyǝ́mɑ kotɑ pɑ tɛɛsɩ nɔnɔɔɔsɩ nɑ pɑ́ kʋntǝɣɩ, nɑ Moisi nɩɩ. Ɩlɛnɑ Tɑcɑɑ pɑ́ɑ́nɑ́ huu. ");
INSERT INTO dop_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Nɑ Moisi lɑŋlɛ wɑkǝlɩ, nɑ ɩ́ pɔɔsɩ Ɩsɔ sɩ: Pepe tɔɔ kɛ́ mɑ nyʋɣʋ sǝpǝnɑ-ŋ, nɑ ń tʋ-m yǝlɑɑ pɑnɛ pɑ pɑɑsǝnɑʋ nɑ ń cɔɔsǝɣɩ-m mpʋ? ");
INSERT INTO dop_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Anɩ pǝ tɑɣɑ mɑ lʋlǝnɑ-wɛ. Nɑ ń tɔŋ sɩ mɑ́ nʋkɩ-wɛ ɩsɩɩ ɑsɔnʋɣʋ nɑ mɑ́ ponɑ-wɛɣɛ tɛtʋ nti n kɑ sɩɩ pɑ cɑɑnɑɑ kɛ nɔɣɔ nɑ tuunɑʋ sɩ, n kɑ́ hɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Yɑɑ leɣe mɑ kpǝlǝɣɩ nɑntʋ nɑ mɑ́ cɛlɑ sɑmɑɑ ɩnɛ nɑ ɩ́ tɔɣɔ? Mpi tɔ, pɑ wiikinɑ-m sɩ mɑ́ cɛlɑ-wɛɣɛ nɑntʋ nɑ pɑ́ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mɑ tike mɑ kɑɑ pǝsɩ pɑ sǝɣǝlɑ, ɑ tɛɛ-m. ");
INSERT INTO dop_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ye tɑmpɑnɑ sɩ n cɑɑ ń lɑ-m kʋpɑntʋ, pǝ kǝlɑ teu sɩ ń kʋ-m nɑ mpi n kɑ lɑkɩ-m ɩsǝntɔ tɔ. Mɑ́ tɑɑ nɑ mɑ kʋnyɔntɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ntɛnɑ Tɑcɑɑ cɔ Moisi sɩ: Koti yǝlɑɑ mpɑ lɛlɑɑ tʋɣʋnɑ nɑ pɑ́ kɛ́ nyʋɣʋ nyǝ́mɑ tɔɣɔ nɩɩtoso nɑ nɑɑnʋwɑ. Ɩlɛnɑ nyɑnɑ-wɛ ɩ́ kɔɔ ɩ sǝŋ Ɩsɔ cokǝle nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ɩlɛ mɑɑ tii nɑ mɑ́ nɑ-ŋ tǝ́ yɔɣɔtɩ tǝnɑ, nɑ mɑ́ tʋ-wɛɣɛ nyɑ́ lǝmɑɣɑsǝlɛ. Ɩlɛnɑ pɑ́ sǝnɑ-ŋ nɑ ń tɑɑ sǝɣǝlɩ sɑmɑɑ sǝɣǝlɑ kɛ nyɑ́ tike. ");
INSERT INTO dop_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ɩlɛnɑ ń tɛlǝsɩ yǝlɑɑ sɩ, ɩ́ tɑɣɑnɩ mǝ tǝɣɩ cele tɔɔ. Mɑɑ hɑ-mɛɣɛ nɑntʋ nɑ ɩ́ tɔɣɔ. Mpi tɔ, mɑ nɩɩ ɩsǝnɑ luluŋ pɩɩ-mɛ, nɑ ɩ́ kʋntǝɣɩ, nɑ ɩ́ tɔŋ sɩ mǝ nɩɩkɑɣɑ leleŋ kɛ Icipiti tɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Pǝ tɑɣɑ kʋyɑkʋ kʋlʋmʋɣʋ yɑɑ nɑɑlɛ yɑɑ kɑkpɑsɩ yɑɑ nɑɑnʋwɑ tike kɛ ɩ́ kɑ́ tɔɣɔ-tɩ. ");
INSERT INTO dop_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Amɑ ɩsɔtʋ tǝcu kɛ́, hɑlǝnɑ tǝ lɩɩ-mɛɣɛ sɔŋ. Mpi pǝ tɔɔ ɩ́ lɔwɑ Tɑcɑɑ mɑ wei mɑ wɛ mǝ hɛkʋ, nɑ ɩ́ kʋntǝɣɩ mǝ Icipiti tɑɑ lɩɩʋ tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Tǝnɑɣɑlɛ Moisi nɔɣɔ tǝkpɑʋ sɩ: Yoolɑɑ pɑnɛ pɑ tɑ sɛkɩ iyisi nɑsǝtoso (600.000). Nɑ ń mɑɣɑsǝɣɩ sɩ n kɑ́ cɛlɑ-wɛɣɛ nɑntʋ kɛ ɩsɔtʋ nɑ? ");
INSERT INTO dop_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Pɑɑ tǝ kʋwɑ tɑ nɑɑŋ, nɑ tɑ heeŋ, nɑ tɑ pǝ́ŋ tǝnɑ. Yɑɑ tǝ kpɑwɑ teŋku tɑɑ tiinɑ tǝnɑ pɩɩ hɑŋǝɣǝnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ntɛnɑ Tɑcɑɑ sɩ: Mɑ tomɑ tɑ tɔɔ? N kɑ́ nɑnɑ nyɑ́ ɩsǝpǝle kɛ nɔɔnɔɔ sɩ, pɩɩ lɑ mpʋ yɑɑ pǝ kɑɑ lɑ? ");
INSERT INTO dop_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ḿpʋ́ɣʋ́ Moisi lɩɩwɑ nɑ ɩ́ tɛlǝsɩ Ɩsɛɣɛlɩ sɑmɑɑ kɛ Tɑcɑɑ kʋyɔɣɔtʋtʋ. Pǝ wɑɑlɩ kɛ́ ɩ kotɑ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ nɩɩtoso nɑ nɑɑnʋwɑ, nɑ ɩ́ pɩɩlɩ-wɛ nɑ ɩ cɔɔnɑ Ɩsɔ cokǝle. ");
INSERT INTO dop_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ɩlɛnɑ Tɑcɑɑ tii ɩsɔŋmʋntʋɣʋ tɑɑ, nɑ ɩ́ yɔɣɔtǝnɑ Moisi, nɑ ɩ́ tʋ́ nyʋɣʋ nyǝ́mɑ mpɛ pɑ tɑɑ kɛ́ Moisi lǝmɑɣɑsǝlɛ. Nɑ pɑ́ sʋʋ yɔɣɔtʋɣʋ ɩsɩɩ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ. Ɩlɛ pǝ tɑ leeli kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Amɑ nyʋɣʋ nyǝ́mɑ mpɛ pɑ tɑɑ nɑɑlɛ, Ɩlǝtɑ nɑ Metɑ pɑ tɑ polo Ɩsɔ cokǝle kiŋ. Amɑ tǝsikile tɑɑ kɛ́ pɑ sɑɑlɑɑ. Nɑ Ɩsɔ tʋ́ ɩ lǝmɑɣɑsǝlɛ kɛ pɑ tɑɑ nɑ pɑ́ yɔɣɔtǝɣɩ, ɩsɩɩ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ntɛnɑ ɩfepu nɔɣɔlʋ ɩ́ kpɑɣɑ ɑsewɑ nɑ ɩ́ polo ɩ́ heeli Moisi kɛ nti Ɩlǝtɑ nɑ Metɑ pɑ lɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Mpʋɣʋlɛ Nuŋ pǝyɑlʋ Yosuwee wei ɩ lɑkɑɣɑ Moisi tǝmlɛ kɛ tuu ɩ pǝcɑɑtʋ tɔ, ɩ tɔmɑ sɩ: Mɑ cɛ heeli-wɛ sɩ pɑ́ su. ");
INSERT INTO dop_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ntɛnɑ Moisi sɩ: N lɑkɩ-m ɩsɛsɛɛmlɛ kɛ́? Hɑlɩ pǝ cɑɣɑ mɑɣɑ ɩsɩɩ Tɑcɑɑ ɩ́ tʋ́ ɩ lǝmɑɣɑsǝlɛ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tɑɑ, nɑ pɑ́ lɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ɩlɛnɑ Moisi nɑ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ mpɛ pɑ́ mǝlɩ tǝsikile. ");
INSERT INTO dop_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ḿpʋ́ɣʋ́ Tɑcɑɑ kʋsɑ heelimuɣu nɑ teŋku tɔɔ. Nɑ pǝ́ kɔnɑ lɛɛsɩ tuutuumɑ kɛ tǝsikile hɔɣɔlʋɣʋ, nɑ pǝ́ polo ɩsɩɩ kʋyɑkʋ kʋlʋmʋɣʋ tɔntɛ, nɑ pǝ́ cɔɔ tǝsikile. Nɑ sɩ́ kɑɑ huɣule ɩsɩɩ mɛɛtǝlɩ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ntɛnɑ sɑmɑɑ kuu-sǝɣɩ kʋyɑkʋ ŋkʋ, nɑ pǝ ɑhoo nɑ pǝ tɛʋ kʋfemuɣu. Pɑɑ wei ɩ kɑ tɔɔsɑ pǝcɔ tɔ, pǝ lɩɩkɩ-ɩ kiloonɑɑ iyisi iyisi kɛ́. Ḿpʋ́ɣʋ́ pɑ lemɑ-sǝɣɩ ilim nɑ pǝ cɔɔnɑ tǝsikile. ");
INSERT INTO dop_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Amɑ Tɑcɑɑ mʋ pɑ́ɑ́nɑ́ nɑ ɩ́ kʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ ɩsɑɣɑkʋɣʋ, kɛ wɑɑtʋ wei pɑ suukɑɣɑ nɑntʋ kɛ pɑ nɔɔsɩ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ntɛnɑ pɑ́ hɑ lonte ntɛɣɛ hǝtɛ sɩ Kipǝloti-Tɑɑfɑ. Pǝ hʋwɛɛ ntɛ́ sɩ luluɣu pǝlɑɑʋ nɑ pɑ tɛ tɑɑ. Mpi tɔ, tǝnɑɣɑ pɑ pimɑ yǝlɑɑ mpɑ luluɣu kʋwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩ Kipǝloti-Tɑɑfɑ ɩlɛnɑ pɑ́ tɛɛ Hɑselɔtɩ nɑ pɑ́ siki. ");
INSERT INTO dop_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moisi kɑ kpɑɣɑ Kusi ɑlʋ nɔɣɔlʋɣʋ. Ɩlɛnɑ Mɑlǝyɑm nɑ Alɔŋ pɑ́ cɑɣɑnɑ-ɩ ɑkpɑɣɑlɛ ntɛ́ tǝ tɔm. ");
INSERT INTO dop_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Hɑlǝnɑ pɑ́ tɔ́ sɩ: Tɑcɑɑ yɔɣɔtǝɣǝnɑ tɑ́ tɔtɔɣɔ. Pǝ tɑɣɑ Moisi tike kɛ ɩ yɔɣɔtǝɣǝnɑ. Ɩlɛnɑ Ɩsɔ nɑ́ɑ́ nɩɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Amɑ Moisi nɑ́ tɑ́ cɔ nɑtǝlɩ. Mpi tɔ, ɩ kɑ tɛɛwɑ ɑtɛ yǝlɑɑ tǝnɑɣɑ suulu kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ḿpʋ́ɣʋ́ Tɑcɑɑ yɑɑ ɩ́ nɑ Alɔŋ nɑ Mɑlǝyɑm, nɑ pɑ́ suli cokǝle kiŋ. ");
INSERT INTO dop_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Nɑ ɩ́ tii ɩsɔŋmʋntʋɣʋ tɑɑ kɛ́ cokǝle nɔɣɔ. Nɑ ɩ́ yɑɑ Alɔŋ nɑ Mɑlǝyɑm nɑ pɑ nɑɑlɛ pɑ polo. ");
INSERT INTO dop_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Nɑ Tɑcɑɑ tɔ-wɛ sɩ: Ɩ́ nɩɩ mɑ kʋyɔɣɔtʋtʋ kɛ teu yoo. Ye mɑ kʋyɔɣɔtʋtʋ tɛlǝsǝlʋ ɩ́ wɛ mǝ hɛkʋ mɑ hʋlǝɣɩ-ɩ mɑ tǝɣɩ. Nɑ mɑ́ lɩɩkɩ ɩ tɔɔ nɑ mɑ yɔɣɔtǝɣǝnɑ-ɩ toosee tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Amɑ mɑ yʋlʋ Moisi nɑ́ nɩɩnɑ-m teu kɛ́, nɑ ɩ́ lɑkɩ ɩ tǝmlɛ kɛ mɑ tǝyɑɣɑ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mɑ nɑ-ɩ tǝ yɔɣɔtǝɣǝnɑ tǝmɑɣɑ tǝcɛɩcɛɩ. Mɑ hʋlǝɣɩ-ɩ mɑ tɩ nɑ ɩ́ nɑɑkɩ mɑ wɛɛtʋ. Ɩlɛ pepe tɔɔ kɛ́ mǝ tɑ́ nyɑnɑ-ɩ, nɑ hɑlǝnɑ ɩ́ cɑɣɑnɑ-ɩ? ");
INSERT INTO dop_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ḿpʋ́ɣʋ́ Tɑcɑɑ mʋ pɑ́ɑ́nɑ́ nɑ ɩ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Wɑɑtʋ wei ɩsɔŋmʋntʋɣʋ kɛɛlɑ cokǝle tɔɔ ɩlɛ, kʋtɔŋ ŋku kʋ pilisiɣi yʋlʋ tɔ kʋ wɑɑsɑ Mɑlǝyɑm tɔɔ kɛlɛ, nɑ ɩ́ hʋlʋmɑɑ tǝloiloi ɩsɩɩ kponkpomʋlʋm. Ḿpʋ́ɣʋ́ Alɔŋ nɑ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Ɩlɛnɑ ɩ́ tɔ Moisi sɩ: Hɑɩ, suulu Tɑcɑɑ, tɑ́ tɔm sǝpɑɣɑ. Ɩlɛ tɑɑ lɛɛtɩ-tʋɣʋ tɑ́ kʋmɛlɛntʋ sɑlǝkɑ. ");
INSERT INTO dop_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mɑlǝyɑm ɩ́ tɑɑ wɛɛ ɩsɩɩ pǝyɑɣɑ sǝkʋɣʋ kɑ too lotu tɑɑ, nɑ pɑ́ lʋlɩ-kɛ nɑ kɑ tɔnʋɣʋ fetiliɣi ɩsǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Tǝnɑɣɑlɛ Moisi wiinɑ Tɑcɑɑ sɩ: Hɑɩ, Tɑcɑɑ, Suulu, wɑɑsɩ. ");
INSERT INTO dop_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ntɛnɑ Ɩsɔ sɩ: Ye ɩsɩɩ ɩ cɑɑ kɑ tɔwɑ ɩ ɩsɛntɑɑ kɛ́ ntɑɣɑmɑ, pǝ tɑɣɑ kʋyɑkʋ nɑ kʋ ɩsikile kɛ ɩ cɑkɩ fɛɛlɛ tɑɑ? Mpʋ tɔ, pǝ wɛɛ sɩ pɑ́ lǝsɩ-ɩ tǝsikile kɛ kʋyɑkʋ nɑ kʋ ɩsikile kɛ́. Pǝ wɑɑlɩ ɩlɛnɑ pɑ́ tɑɣɑnɩ-ɩ yɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ḿpʋ́ɣʋ́ pɑ lǝsɑ Mɑlǝyɑm kɛ tǝsikile tɑɑ kɛ́ kʋyɑkʋ nɑ kʋ ɩsikile. Pɑ mǝlǝnɑ-ɩ tɔɣɔ Ɩsɛɣɛlɩ nyǝ́mɑ tʋ́ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Nɑ pɑ́ polo pɑ siki Pɑlɑŋ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Lǝsɩ Ɩsɛɣɛlɩ kpekɑ nyʋɣʋ nyǝ́mɑ tɑɑ kɛ́ yʋlʋ yʋlʋ. Nɑ n tili-wɛ nɑ pɑ́ feŋ Kɑnɑɑŋ tɛtʋ nti mɑ hɑɑkɩ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ɩlɛnɑ Moisi kʋsɩ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ kɛ Pɑlɑŋ wʋlɑɣɑ tɛtʋ tɑɑ, ɩsɩɩ Tɑcɑɑ kɛɛsʋɣʋ-ɩ tɔ. Nɑ pɑ́ polo Kɑnɑɑŋ tɛtʋ feŋuɣu. ");
INSERT INTO dop_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Feŋlɑɑ mpɛ pɑ kpekɑ nɑ pɑ hǝlɑ ntɔ: Lupɛŋ kpekǝle tɑɑ nyǝŋ ntɛ́ Sɑkuu pǝyɑlʋ Sɑmuwɑ. ");
INSERT INTO dop_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simiyɔŋ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Holi pǝyɑlʋ Sɑfɑtɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yutɑ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Yefune pǝyɑlʋ Kɑlɛpʋ. ");
INSERT INTO dop_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Ɩsɑkɑɑ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Yosɛɛfʋ pǝyɑlʋ Ɩkɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Ɩfǝlɑyim nyǝntɛ tɑɑ nyǝŋ ntɛ́ Nuŋ pǝyɑlʋ Hosee. ");
INSERT INTO dop_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Pɛncɑmɛɛ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Lɑfu pǝyɑlʋ Pɑlǝti. ");
INSERT INTO dop_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sɑpulɔŋ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Soti pǝyɑlʋ Kɑtǝyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yosɛɛfʋ pǝyɑlʋ Mɑnɑsee nyǝntɛ tɑɑ nyǝŋ ntɛ́ Susi pǝyɑlʋ Kɑtɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Tɑŋ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Kemɑli pǝyɑlʋ Amiyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asɛɛ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Mikɑyɛɛlɩ pǝyɑlʋ Setuu. ");
INSERT INTO dop_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nɛfǝtɑli nyǝntɛ tɑɑ nyǝŋ ntɛ́ Fofǝsi pǝyɑlʋ Nɑpi. ");
INSERT INTO dop_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kɑtɩ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Mɑki pǝyɑlʋ Kuwɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Mpɑ Moisi tilɑ Kɑnɑɑŋ tɔ pɑ hǝlɑ ntɛ́. Nuŋ pǝyɑlʋ Hosee kɛ Moisi cuɣusɑ hǝtɛ sɩ Yosuwee. ");
INSERT INTO dop_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Ḿpʋ́ɣʋ́ Moisi kʋsɑ-wɛ nɑ ɩ́ heeli-wɛ sɩ: Ɩ́ kpɑɣɑ ilim ntɔɣɔŋ tɔɔ mpɑɑʋ, nɑ ɩ sʋʋ pulɑsɩ hɔɣɔlʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Nɑ ɩ feŋ tɛtʋ ntɩ nɑ tǝ yǝlɑɑ kɛ teu, nɑ ɩ́ nɑ pɑ pɑɣɑlɛ nɑ pɑ toŋ tǝnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Nɑ ɩ́ nɑ sɩ pɑ wɛnɑ koloosi ɑcɑlɛɛ yɑɑ pɑ fɛɩnɑ. Nɑ tɛtʋ wɛ mʋsʋŋ yɑɑ tǝ sǝpɑ. Nɑ hɔtʋ wɛɛ yɑɑ tǝ fɛɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ɩ́ ponɑ ɑpɑlʋtʋ nɑ ɩ́ kɔnɑ pɑ tɛtʋ kʋlʋlʋm. Wɑɑtʋ ɩnǝɣɩ tɛtʋ ntɩ tǝ tɩɩŋ wei pɑ yɑɑ sɩ lɛsɛŋnɑɑ tɔ ɩ kɑncɑɑlɑɣɑ nyǝ́mɑ pɩɩkɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ḿpʋ́ɣʋ́ ɑpɑlɑɑ mpɛ pɑ tɛɛwɑ nɑ pɑ́ feŋ tɛtʋ kɛ pǝ kpɑɣɑʋ Siŋ wʋlɑɣɑ tɛtʋ, hɑlǝnɑ Lehopɩ, kɛ Lepo-Hɑmɑtɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ɩlɛnɑ pɑ́ sʋʋ tɛtʋ ntɩ tǝ tɑɑ, nɑ ilim mpǝtǝŋ tɔɔ. Nɑ pɑ́ tɑlɑ Hepǝlɔŋ kɛ Anɑkɩ lʋlʋɣʋ nyǝ́mɑ tookonɑɑ tɛ. Pɑ hǝlɑ ntɛ́, Ahimɑŋ nɑ Sesɑɩ nɑ Tɑlǝmɑyi. Pɑɑ ŋmɑwɑ Hepǝlɔŋ ɩcɑtɛ kɛ́, nɑ pɩɩsɩ nɑɑtosompɔɣɔlɑɣɑ siki, ɩlɛnɑ pɑ́ ŋmɑ́ Sowɑŋ nyǝntɛ kɛ Icipiti tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Pɑ tɑlɑ lɛsɛŋ tɛtɛkǝlɛ tɑɑ, ɩlɛnɑ pɑ́ sɛtɩ pǝ tuku, nɑ piliŋɑ, nɑ pɑ́ hɔɣɔlɩ yǝlɑɑ nɑɑlɛ. Nɑ pɑ́ kooli tɩɩŋ wei pɑ yɑɑ sɩ fiki nɑ kǝlenɑɑtɩ tɔ ɩ pee tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ḿpʋ́ɣʋ́ pɑ hɑ tǝnɑ ɩnǝɣɩ hǝtɛ sɩ, lɛsɛŋ tɛtɛkǝlɛ kɛ tuku ŋku Ɩsɛɣɛlɩ nyǝ́mɑ kɑ sɛtɑɑ tɔ kʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Kʋyɛɛŋ sikɑ nɩɩlɛ, ɩlɛ feŋlɑɑ tɛmɑɣɑlɛ, nɑ pɑ́ mǝlɩ. ");
INSERT INTO dop_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Moisi nɑ Alɔŋ nɑ Ɩsɛɣɛlɩ sɑmɑɑ kiŋ kɛ pɑ mǝlɑ Kɑtɛɛsɩ kɛ Pɑlɑŋ wʋlɑɣɑ tɛtʋ tɑɑ. Nɑ pɑ́ kɛɛsɩ-wɛɣɛ pǝ tǝnɑ mpi pɑ nɑwɑ tɔ pǝ tɔm. Nɑ pɑ́ hʋlɩ-wɛɣɛ tɛtʋ kʋlʋlʋm nɑ pɑ heeli-wɛ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kʋpɑntʋ nɑ tɔɣɔnɑɣɑ tǝnɑ tɔlɑ tǝ tɑɑ kɛ́ tǝhɔ. Hɑlǝnɑ pɑ́ hʋlɩ-wɛɣɛ tǝ kʋlʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Amɑ kʋlʋmtʋ kɛ́ sɩ tǝ yǝlɑɑ kɛ́ toŋtʋnɑɑ kɛ́. Nɑ pɑ ŋmɑwɑ koloosi ɑcɑlɛɛ sɔsɔɔnɑ. Hɑlɩ tǝ nɑwɑ tǝ tɑɑ kɛ́ tooko Anɑkɩ lʋlʋɣʋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amɑleke nyǝ́mɑ nɑ́ cɑɣɑnɑ ntɛɣɛ ilim mpǝtǝŋ tɔɔ, nɑ Hiti nyǝ́mɑ nɑ Yepusi nyǝ́mɑ nɑ Amolii nyǝ́mɑ kɛ pulɑsɩ hɔɣɔlʋɣʋ. Nɑ Kɑnɑɑŋ nyǝ́mɑ kɛ Metitelɑnee teŋku nɑ Yɑɑtɑnɩ pɔɣɔ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ɩsɛɣɛlɩ nyǝ́mɑ cɑɑkɑɣɑ Moisi kɛ kʋntǝnɑʋ. Ɩlɛnɑ Kɑlɛpʋ sumsi-wɛ, nɑ ɩ́ yɔɣɔtǝnɑ tomɑ sɩ: Tǝ́ polo tǝ mʋ tɛtʋ ntɩ, tǝ wɛnɑ pǝ tomɑ. ");
INSERT INTO dop_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Amɑ ɩ tɑɑpɑlɑɑ nɑ́ tɔmɑ sɩ: Tǝ kɑɑ pǝsɩ nɑ tǝ́ kpɑ yǝlɑɑ mpɛ pɑ tɔɔ, pɑ tɛɛ-tʋɣʋ toŋ. ");
INSERT INTO dop_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Tǝnɑɣɑlɛ pɑ sʋʋ kɛɛsʋɣʋ kɛ mpi pɑ nɑwɑ tɛtʋ ntɩ tǝ tɑɑ nɑ pǝ́ lɑ-wɛɣɛ sɔɣɔntʋ tɔ pǝ tɔm sɩ: Tɛtʋ ntɩ tǝ kɛ́ nti tǝ kʋɣɩ tǝ yǝlɑɑ tɔɣɔ. Tǝ tɑɑ yǝlɑɑ kɛ́ tookonɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ɩlɛnɑ pǝ́ tɩɩ kǝlǝnɑ Anɑkɩ lʋlʋɣʋ nyǝ́mɑ. Tɑ́ wɛ ɩsɩɩ tɔɔlɑɑ kɛ pɑ kiŋ kɛ́, nɑ pɛlɛ pɑ́ nyǝnǝɣɩ-tʋɣʋ mpʋ. ");
INSERT INTO dop_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ mɑpɑ kɑpusi kɛ ɑhoo tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Nɑ pɑ́ kʋntǝnɑ Moisi nɑ Alɔŋ, nɑ pɑ́ tɔŋ sɩ: Ye tɩɩ sǝpɑ Icipiti tɛtʋ tɑɑ tǝnɑ, pɩɩ lɑpɑ sɑnɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Pepe tɔɔ kɛ́ Tɑcɑɑ kɑ́ ponɑ-tʋɣʋ tɛtʋ ntɩ tǝ tɑɑ, nɑ tǝ sɩ yoou tɑɑ. Nɑ kolontunɑɑ kuu tɑ ɑlɑɑ nɑ tɑ piyɑ. Pǝ kǝlɑ teu sɩ tǝ́ mǝlɩ Icipiti. ");
INSERT INTO dop_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Hɑlǝnɑ pɑ́ mɑɣɑsɩ sɩ pɑ kpɑɑkɩ wulɑʋ, nɑ pɑ́ mǝlɩ Icipiti. ");
INSERT INTO dop_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Tǝnɑɣɑlɛ Moisi nɑ Alɔŋ, pɑ hotɑ pɑ nɔɔsɩ tɔɔ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ḿpʋ́ɣʋ́ feŋlɑɑ tɑɑ nɑɑlɛ, Nuŋ pǝyɑlʋ Yosuwee, nɑ Yefune nyǝŋ Kɑlɛpʋ, pɑ cǝlɑ pɑ wontu nɑ lɑŋwɑkǝllɛ. ");
INSERT INTO dop_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Nɑ pɑ́ tɔ́ sɑmɑɑ sɩ tɛtʋ ntɩ tǝ teu wɛ sɔɣɔntʋ. ");
INSERT INTO dop_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kʋpɑntʋ nɑ tɔɣɔnɑɣɑ tɔlɑ tǝ tɑɑ kɛ́ tǝhɔ. Ye Tɑcɑɑ lɑŋlɛ hɛɛnɑ-tʋ, ɩ kɑ́ sʋsɩ-tʋɣʋ tǝ tɑɑ kɛ́ nɑ ɩ́ hɑ-tʋɣʋ-tɩ. ");
INSERT INTO dop_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Pǝ tɔɔ tɔ, ɩ́ tɑɑ kpɑ Tɑcɑɑ tɔɔ. Yɑɑ ɩ́ wɛɛnɑ tɛtʋ ntɩ tǝ yǝlɑɑ sɔɣɔntʋ. Pɑ tɩɩŋ kɑ́ lɔ-wɛɣɛ, nɑ tɑ́ɑ́ tǝlǝkɩ-wɛɣɛ tɔm kʋlʋm tɔɔ. Mpi tɔ, tɑ Ɩsɔ wɛ tɑ́ wɑɑlɩ kɛ́. Mpʋ tɔ, tǝ tɑɑ nyɑnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ḿpʋ́ɣʋ́ sɑmɑɑ yɔɣɔtɑɑ sɩ pɑ́ kʋ-wɛ nɑ pɛɛ. Tǝnɑɣɑ Tɑcɑɑ teeli nɑ́ pɑ ɩsɛntɑɑ kɛ́ kpɑkpɑɑ kɛ cokǝle tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: Mɑ hʋlɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ yɑɑsinɑɑ pɑɣɑlɛ ntɛ́ mɑ toŋ. Pɑɑ nɑ mpʋ pɑ tɔŋnɑ-m kisuɣu. Pɑɑ lɑkɩ-m nɑɑni. Ɩlɛ pɑɑ lɑɣɑsɩ? ");
INSERT INTO dop_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mɑɑ kpiisi-wɛ nɑ yʋlʋkʋsʋkʋ. Ɩlɛnɑ mɑ́ lɑ́ nɑ Moisi lʋlɩ nɑ ɩ́ pǝsɩ piitim sɔsɔɔm nɑ toŋ nyǝm, nɑ pǝ́ kǝlɩ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ntɛnɑ Moisi sɩ Icipiti nyǝ́mɑ cɛkǝnɑɑ sɩ, nyɑ́ toŋ kɛ n lǝsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Pɑ kɑɑ lɑŋ-tǝɣɩ tɑɣɑsʋɣʋ kɛ tɛtʋ tǝnɛ tǝ nyǝ́mɑ. Pɛlɛ pɑ nyǝ́mɑ sɩ n wɛ tɑ́ wɑɑlɩ kɛ́, nɑ ń hʋlǝɣɩ-tʋɣʋ nyɑ́ tɩ. Nɑ tǝ́ nɑɑkɩ nyɑ́ tǝmɑ nɑ ń kentiɣi tɑ́ tɔɔ. Mpi tɔ, n wɛ tɑ́ nɔɣɔ tɔɔ kɛ́ ɩsɔŋmʋntʋɣʋ tɑɑ kɛ́, nɑ ɑhoo ɩlɛnɑ ń wɛɛ ɩsɔŋmʋntʋɣʋ ŋku kʋ mʋɣɩ kɔkɔ tɔ kʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ye nɔɔnɔɔ n kpiisɑ-tʋɣʋ tɔm kʋlʋm, piitimnɑɑ mpɑ pɑ nɩɩwɑ pǝ tǝnɑ mpi n lɑpɑ tɔ, pɑɑ tɔ sɩ, ");
INSERT INTO dop_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","n kpisɑ nyɑ́ yǝlɑɑ ponɑʋ kɛ tɛtʋ kʋpɑntʋ tɑɑ, ɩsɩɩ n kɑ sɩɩʋ tɔ. Pǝ tɔɔ kɛ́ n kʋ-wɛɣɛ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ɩlɛ hɑɩ, Tɑcɑɑ, mɑ wiikinɑ-ŋ sɩ ń hʋlɩ nyɑ́ toŋ nɑ ń lɑ́ ɩsɩɩ n kɑ yɔɣɔtʋɣʋ tɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Mɑɣɑlɛ Tɑcɑɑ, mɑ wɛnɑ suulu kɛ́ nɑ mɑ kʋpɑntʋ fɛɩ tǝnɑɣɑ. Mɑ wiiki ɩsɑɣɑlɑtɑɑ nɑ kpɛɛnlɑɑ. Amɑ mɑɑ hɑɑkɩ tɑsǝkǝlɛ tʋ kɛ tɑmpɑnɑ. Mɑ hɔŋ ɑsɑɣɑɑ ŋkpɑŋŋ kɛ́ nɑ mɑ́ kpɛnnɑ pɑ lʋlʋŋ loosi tooso yɑɑ liɣiti nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Tɑcɑɑ nyɑ́ kʋpɑntʋ tɔɔwɑ sɔsɔm. Wii nyɑ́ yǝlɑɑ, ɩsɩɩ too n lǝsʋɣʋ-tʋɣʋ Icipiti nɑ n lɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mpʋɣʋlɛ Ɩsɔ nɔɣɔ tǝkpɑʋ sɩ: Mɑɑ wii-mɛ, ɩsɩɩ n sǝlǝmʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Pɑɑ nɑ mpʋ timpi mɑ kɛ́ weesuɣu tʋ, nɑ mɑ teeli su tɛtʋ tǝnɑ tɔ, mɑ tuukinɑ mɑ tɩ sɩ, ");
INSERT INTO dop_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","mǝ tɑɑ nɔɣɔlʋ kɑɑ sʋʋ tɛtʋ ntɩ tǝ tɑɑ. Pǝ tɑɣɑ pʋlʋ, ɩ́ nɑwɑ mɑ teeli nɑ mɑ tǝmɑ sɔsɔɔnɑ nnɑ mɑ lɑpɑ Icipiti nɑ wʋlɑɣɑ tɛtʋ tɑɑ cǝnɛ tɔ. Pɑɑ nɑ mpʋ ɩ́ tɔŋɑ-m mɑɣɑsʋɣʋ sɩ, ɩ́ nɑɑkɩ mɑ wɑɑlɩ. Pǝyele ɩ́ɩ́ nɩɩkǝnɑ-m. Pǝ tɔɔ kɛ́ mǝ tɑɑ nɔɣɔlʋ kɑɑ keesi tɛtʋ nti mɑɑ sɩɩwɑ sɩ mɑɑ hɑ mǝ cɑɑnɑɑ tɔ. Mpi tɔ, mǝ tǝnɑ ɩ́ lɔnɑ-m. ");
INSERT INTO dop_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Amɑ mɑ tǝmlɛ tʋ Kɑlɛpʋ nɑ́ wɛnɑ lǝmɑɣɑsǝlɛ kʋpɑntɛ. Ɩ tɑ lɔ mɑ tɔm. Ɩ kɑ́ sʋʋ tɛtʋ nti ɩ feŋɑɑ tɔ tǝ tɑɑ. Mɑɑ hɑ-tǝɣɩ ɩ lʋlʋɣʋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Amɑleke nɑ Kɑnɑɑŋ nyǝ́mɑ wɛnnɑ tɛtɛkǝlɛ tɑɑ. Pǝ tɔɔ tɔ, cele ɩ́ mǝlɩ mǝ nɔɔhɛɛ tɔɔ nɑ ɩ́ fɑɣɑnɑ wʋlɑɣɑ tɛtʋ tɑɑ kɛ sǝsǝncɑɑsɩ teŋku tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Moisi nɑ Alɔŋ kɛ heeluɣu tɔtɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Mɑ nɩɩwɑ Ɩsɛɣɛlɩ nyǝ́mɑ kʋntǝɣǝnɑ-m. Yǝlɑɑ kɑtɛ nyǝ́mɑ mɛ ɩ́ kɑɑ hɛɛsɩ pǝ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ɩ́ tɛlǝsɩ-wɛ sɩ, mɑ kɛ́ weesuɣu tʋ kɛ́. Mɑ tuukinɑ mɑ tɩ sɩ mɑɑ lɑ-mɛ ɩsɩɩ ɩ́ yɔɣɔtɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Amɑ mǝ tǝnɑ mpɑ pɑ kɑlɑɑ nɑ ɩ́ wɛnɑ ɩsɩɩ pɩɩsɩ hiu nɑ wɑɑlɩ tɔ, ɩ́ kɑ́ sɩ. Mpi pǝ tɔɔ ɩ́ kʋntǝɣǝnɑ-m tɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Kɑlɛpʋ nɑ Yosuwee pɑ pɑɑsi, nɔɣɔlʋ kɑɑ sʋʋ tɛtʋ nti mɑɑ tuuwɑ sɩ mɑɑ hɑ mǝ cɑɑnɑɑ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ye pǝ kɑɑsɑ mǝ piyɑ mpɑ ɩ tɔŋɑɣɑ sɩ kolontunɑɑ kɑ́ kuu tɔ. Pɛlɛ pɑɑ tɔɣɔnɑ tɛtʋ nti ɩ footɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","33","Pɩɩsɩ nɩɩlɛ tǝcu kɛ́ mǝ pǝyɑlɑɑ kɑ́ pɑɑsǝnɑ pɑ kɑlǝkǝŋ. Nɑ pɑ́ tɔɣɔ mǝ kɑɑnɩɩtʋ sɑlǝkɑ tɔtɔ. Amɑ wʋlɑɣɑ tɛtʋ tɑɑ cǝnɛɣɛ mǝ looŋɑ tǝnɑ kɑ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Kʋyɛɛŋ nɩɩlɛ kɛ ɩ́ feŋɑ tɛtʋ. Ɩlɛ pɩɩsɩ nɩɩlɛ kɛ ɩ́ kɑ́ tɔɣɔ mǝ ɩsɑɣɑtʋ sɑlǝkɑ. Pǝ lɩɩwɑ ɩsɩɩ kʋyɑkʋ kʋlʋmʋɣʋ pǝnɑɣɑ kʋlʋmɑɣɑ ntɛ́. Wɑɑtʋ ɩnǝɣɩ ɩ́ kɑ́ cɛkǝnɑ mpi mɑ tɔɔ kʋlʋɣʋ hʋlǝɣɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ɩsǝnɑ mɑ yɔɣɔtɑɑ tɔ, ḿpʋ́ɣʋ́ mɑɑ lɑ lɑŋkpɩɩsǝŋ nyǝ́mɑ mɛ. Mpi tɔ ɩ́ kʋlɑ mɑ tɔɔ. Ɩsɩɩ mǝ nɔɣɔ nɑ mǝ sukɑ ɩ sǝpɑ wʋlɑɣɑ tɛtʋ tɑɑ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Mpɑ ɩnɩ Moisi kɑ tilɑ tɛtʋ feŋuɣu nɑ pɑ́ footi-tɩ, nɑ pɑ́ yele nɑ sɑmɑɑ kʋntǝɣǝnɑ-m tɔ, ");
INSERT INTO dop_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Tɑcɑɑ kʋ-wɛɣɛ kpɑkpɑɑ nɑ wɑhɑlɑ kɛ pǝ tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Yosuwee nɑ Kɑlɛpʋ pɑ tike pɑ tɑ sǝnɑ yǝlɑɑ mpɑ pɑ polɑ tɛtʋ feŋuɣu tɔ pɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ḿpʋ́ɣʋ́ Moisi kɛɛsɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ tɔm ntɩ. Nɑ pɑ lɑŋɑ wɑkǝlɩ tǝtɔɣɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Pǝ tɔɔ kɛ́ pǝ femɑ tɑnɑŋ tǝhulu, nɑ pɑ́ pukinɑ pulɑsɩ hɔɣɔlʋɣʋ, nɑ pɑ́ tɔŋ sɩ: Tɑ́ tɔm sǝpɑ. Ɩlɛ pǝnɛntɛ tɑ́ sɔɔlʋ pɩɩwɑ sɩ tǝ polo timpi Tɑcɑɑ hʋlɑ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ntɛnɑ Moisi sɩ: Pepe tɔɔ kɛ́ ɩ́ kisiɣi Tɑcɑɑ kʋsǝsɩɩtʋ, ɩ́ kɑɑ wɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ɩ fɛɩ mǝ wɑɑlɩ yoo. Ɩlɛ ɩ tɑɑ nɔkɩ pote sɩ ɩ́ yookinɑ mǝ kolontunɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amɑleke nɑ Kɑnɑɑŋ yoolɑɑ ntɛ́ mǝ nɔɣɔ tɔɔ tǝnɑ. Pɛlɛ pɑɑ kpiisi-mɛɣɛ. Timpi ɩ kisɑ Tɑcɑɑ tɔ, ɩ́lɛ́ ɩ kɑɑ wɛɛ mǝ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ḿpʋ́ɣʋ́ pɑ lɑpɑ kɑŋkɑnɑ sɩ pɑ kpɑɑkɩ pʋɣʋ hɔɣɔlʋɣʋ. Amɑ Moisi nɑ Tɑcɑɑ nɔɣɔ pɛɛlʋɣʋ ɑtɑkɑɑ pɑ sɑɑlɑ tǝsikile. ");
INSERT INTO dop_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tǝnɑɣɑ Amɑleke nɑ Kɑnɑɑŋ yoolɑɑ mpɑ pɑɑ wɛ pɔɔŋ tɑɑ tǝnɑ tɔ, pɑ tiiwɑ nɑ pɑ́ tɔɣɔnɩ-wɛ nɑ pɑ́ kʋ-wɛ, hɑlǝnɑ Hoomɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, wɑɑtʋ wei ɩ́ kɑ́ sʋʋ tɛtʋ nti mɑ hɑɑkɩ-mɛ tɔ, tǝ tɑɑ sɩ ɩ́ cɑkɩ tɔ, ");
INSERT INTO dop_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ye ɩ́ lɑkɩ kɔtɑsɩ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔ yɑɑ ciikuɣu nyǝnsɩ yɑɑ nɔɣɔ sɩɩʋ nyǝnsɩ. Yɑɑ luɣu kʋlʋmʋɣʋ nyǝnsɩ yɑɑ ɑcimɑ nyǝnsɩ. Nɑʋ yɑɑ heu yɑɑ pǝ́ŋ́ kɛ ɩ́ kɑ́ lɑnɑ pǝ kɔtɑɣɑ. Nɑ mɑ lɑŋlɛ hɛɛnɑ pǝ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Ye wei ɩ kɔnɑ ɩ kpǝntɛ, ɩ kɑ́ tǝnɩ tǝ tɔɔ kɛ́ tɔɣɔnɑɣɑ kɔtɑɣɑ. Ɩsɩɩ mʋlʋm mpi pɑ nuɣutinɑ nim liitili kʋlʋm nɑ titite tɔɣɔ kiloonɑɑ tooso. ");
INSERT INTO dop_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Nɑ ɩ́ liisi sʋlʋm kɛ liitili kʋlʋm nɑ titite kɛ pɑɑ ɩwǝyɑɣɑ ŋkɑ kɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, yɑɑ ciikuɣu nyǝŋkɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ye pǝ kɛ́ ɩwɑɑʋ, ɩlɛ ɩ́ sɔɔsɩ mʋlʋm mpi pɑ nuɣutinɑ nim liitilinɑɑ nɑɑlɛ tɔɣɔ kiloonɑɑ nɑɑtoso. ");
INSERT INTO dop_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Nɑ sʋlʋm kɛ liitilinɑɑ nɑɑlɛ, nɑ Tɑcɑɑ lɑŋlɛ hɛɛnɑ pǝ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ye ɩsɩɩ nɑʋ kɛ ɩ́ lɑkɩ-m kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, yɑɑ ciikuɣu nyǝŋkɑ, yɑɑ nɔɣɔ sɩɩʋ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Ɩ́ tǝnɩ kpǝntɛ tɔɔ kɛ́ mʋlʋm mpi pɑ nuɣutinɑ nim liitilinɑɑ tooso, tɔɣɔ kiloonɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Nɑ sʋlʋm kɛ liitilinɑɑ tooso, nɑ Tɑcɑɑ lɑŋlɛ hɛɛnɑ pǝ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ye ɩ́ lɑkɩ nɑʋ yɑɑ ɩwɑɑʋ yɑɑ ɩwǝyɑɣɑ yɑɑ pinɑɣɑ kɛ kɔtɑɣɑ, ḿpʋ́ɣʋ́ ɩ́ kɑ́ lɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Pɑɑ tɔlɑ ɩsǝnɑɣɑ ɩ́ kɑ́ lɑ kɔtɑɣɑ. Ɩ́ kɑ́ tǝnɩ pɑɑ nte tǝ tɔɔ kɛ́ ḿpʋ́ɣʋ́. ");
INSERT INTO dop_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","14","Yɑɑsi ɩnǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ mɛ ɩ́ kɑ́ tǝŋ nɑ ɩ́ lɑkɩ kɔtɑsɩ sɔɔsʋŋ nyǝnsɩ. Nɑ pǝ́ kpɛnnɑ mǝ tɛtʋ tɑɑ cɑɣɑlɑɑ tǝnɑ. Mpɑ pɑ leelɑɑ nɑ mpɑ pɑ tɑ leeli tɔ. ");
INSERT INTO dop_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","16","Kʋsǝsɩɩtʋ kʋlʋmtʋ ntǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ cɑɣɑlɑɑ ɩ́ kɑ tɔkɩ teitei, nɑ pǝ́ polo mǝ piyɑ piyɑ. Tɑcɑɑ mɑ́ mɑɑ fɑɣɑsǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, ye wɑɑtʋ wei ɩ́ tɑlɑ tɛtʋ nti tǝ tɑɑ mɑ pukinɑ-mɛ tɔ, ");
INSERT INTO dop_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ɩlɛ ɩ́ kpɑɣɑ tǝ tɔɣɔnɑɣɑ nɑ ɩ́ lɑ-m kɔtɑɣɑ. Ɩlɛnɑ pǝ́cɔ́ ɩ́ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ɩlɛnɑ ɩ́ cosi mǝ kɑncɑɑlɑɣɑ somtu tɑɑ nɑ ɩ́ tʋ́ kɑkɑlɑɣɑ. Nɑ ɩ́ kpɑɑsɩ-m-kɛ nɑ ɩsɔ, ɩsɩɩ pɑ lɑkʋɣʋ kɑncɑɑlɑɣɑ pee wenɑ pɑ mɑpɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Nɑ ɩ́ lɑ-m kɔtɑɣɑ kɛ pǝ kɑkɑlɑɣɑ kɑncɑɑlɑɣɑ nyǝŋkɑ. Ɩ́ kɑ́ tɔkɩ kʋsǝsɩɩtʋ tǝnɛɣɛ tɑm tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","Ḿpʋ́ɣʋ́ Moisi tɔmɑ sɩ: Ye kʋyɑkʋ nɑkʋlɩ pǝ yʋkǝnɑ mɛ, yɑɑ mǝ piyɑ piyɑ kɛ wɑɑtʋ nɔɣɔlʋ, ɩlɛnɑ pʋntʋ yɔkɩ kʋsǝsɩɩtʋ nti mɑ tɛlǝsɑ-mɛ ɩsǝntɔ tɔ tǝ tɑɑ nɑtǝlɩ, ɩlɛ ɩ́ tɑɣɑnɩ-tɩ nɑ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Ye pǝ kɛ́ ɩsɑɣɑtʋ nti tǝ yʋkǝnɑ yʋlʋ tɔ nɑ sɑmɑɑ tɑ nyɩ pǝ tɔm, ɩlɛ ɩ́ cɑɑ lɑtǝcɛ nɑ ɩ́ lɑ-m kɔtɑɣɑ sɔɔsʋŋ nyǝŋkɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Nɑ ɩ́ tǝnɩ kɑ tɔɔ kɛ́ mʋlʋm, nɑ sʋlʋm, nɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ pǝŋtʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kɔtʋlʋ kɑ́ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ, nɑ pǝ́ hɩɩsɩ mǝ ɩsɑɣɑtʋ. Mpi tɔ, pǝ kɛ́ ɩsɑɣɑtʋ nti tǝ yʋkǝnɑ-mɛ tɔɣɔ. Nɑ pǝ tɔɔ kɛ́ ɩ́ kɔnɑ-m kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. Nɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Pɩɩ hɩɩsɩ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ɩsɑɣɑtʋ kɛ. Nɑ cɑɣɑlɑɑ mpɑ pɑ wɛ mǝ hɛkʋ tɔ pɛlɛ pɑ nyǝntʋ. Mpi tɔ, pǝ kɛ ɩsɑɣɑtʋ nti tǝ yʋkǝnɑ-mɛ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ye yʋlʋ kʋlʋm kɛ pǝ yʋkǝnɑɑ nɑ ɩ́ lɑ ɩsɑɣɑtʋ, ɩlɛ pǝnɑɣɑ kʋlʋmɑɣɑ pǝ́ŋ́ kɛ ɩ kɑ́ kɔtǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Ɩlɛnɑ kɔtʋlʋ lɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, kɛ wei ɩnɩ pǝ yʋkǝnɑɑ nɑ ɩ́ lɑ́ ɩsɑɣɑtʋ kɛ mpʋ tɔ. Ɩ tɛŋ mpʋ ɩlɛnɑ ɩ ɩsɑɣɑtʋ hɩɩsɩ. ");
INSERT INTO dop_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Pɑɑ Ɩsɛɣɛlɩ tʋ yɑɑ cɑɣɑlʋ kɛ pǝ yʋkǝnɑɑ nɑ ɩ́ pǝntɩ, kʋsǝsɩɩtʋ kʋlʋmtʋ tǝnɛ ɩnǝɣɩ ɩ́ kɑ́ tɔ́kɩ. ");
INSERT INTO dop_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Amɑ ye Ɩsɛɣɛlɩ tʋ yɑɑ cɑɣɑlʋ pǝntǝnɑ tǝfɑɑ, ɩsɩɩ pɑ kpiisɑ-ɩ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ɩ nyʋɣʋ tɑɑ kɛ́ ɩ kpiisuɣu kɑ́ mǝlɩ. Mpi tɔ, ɩ footɑ Tɑcɑɑ tɔm, nɑ ɩ́ wɑkǝlɩ ɩ kʋtʋtʋtʋ. ");
INSERT INTO dop_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ḿpʋ́ɣʋ́ wɑɑtʋ wei Ɩsɛɣɛlɩ nyǝ́mɑ tɑlɑ wʋlɑɣɑ tɛtʋ tɑɑ, ɩlɛnɑ kʋyɑkʋ nɑkʋlɩ pɑ́ kpǝlɩ pɑ tɑɑ nɔɣɔlʋ nɑ ɩ́ cɑɑkɩ tɑɑsɩ kɛ kʋyɑkʋ kʋhɛɛsʋɣʋ wule. ");
INSERT INTO dop_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ɩlɛnɑ pɑ́ ponɑ-ɩ Moisi nɑ Alɔŋ nɑ sɑmɑɑ tǝnɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Nɑ pɑ́ sɩɩ-ɩ nɑ pɑ́ tɑŋɑ nti Ɩsɔ kɑ heeli-wɛ sɩ pɑ́ lɑnɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ntɛnɑ Tɑcɑɑ heeli Moisi sɩ: Pǝ wɛɛ sɩ sɑmɑɑ tǝnɑ ɩ́ kʋ́ pʋntʋ ɩnǝɣɩ nɑ pɛɛ, kɛ tǝsikile wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kɛlɛnɑ pɑ́ lɩɩnɑ-ɩ nɑ pɑ́ kʋ-ɩ nɑ pɛɛ, ɩsɩɩ Tɑcɑɑ kɑ heeluɣu Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, mǝ nɑ mǝ lʋlʋŋ nyǝ́mɑ ɩ́ kɑ́ kɔɔkɩ mǝ tokonɑɑ sɔsɑɑ ntompee kɛ ɑtʋɣʋsɑ kɛ́, nɑ ɩ tɑmsǝɣɩ-yɛɣɛ ɑkpɑɑyɑlɑ kponkpontu. ");
INSERT INTO dop_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","40","Ntǝɣɩ ɩ́ kɑ́ nyǝnǝɣɩ nɑ ɩ́ tɔɔsǝɣɩ mɑ kʋsǝsɩɩtʋ tɔɔ, nɑ ɩ tɔkǝɣɩ-tɩ. Ɩlɛ ɩ kɑɑ nyɩɩlɩ tɩɩŋ wɑɑnɩ wɑɑnɩ lɑɑʋ kɛ mǝ hʋwɛɛ w tɑɑ. Tǝnɑɣɑ ɩ́ kɑ́ hʋlǝnɑ sɩ ɩ́ kɛ́ mɑ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mɑɣɑlɛ Tɑcɑɑ mǝ Ɩsɔ, mɑ lǝsǝnɑ-mɛɣɛ Icipiti tɛtʋ tɑɑ sɩ mɑ́ wɛɛ mǝ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Ḿpʋ́ɣʋ́ Lefii kpekǝle tʋ Kehɑtɩ lʋlʋɣʋ tʋ Ɩsɑɑ pǝyɑlʋ Kolee tʋsɑ Lupɛŋ nyǝ́mɑ tooso. Ɩliyɑpɩ pǝyɑlɑɑ Tɑtɑŋ, nɑ Apilɑm, nɑ Pelee pǝyɑlʋ Oŋ nɑ pǝ́ sɔɔsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kʋpɑɣɑlɑɑ mpɑ pɑ hǝlɑ yɑɑwɑ nɑ pɑ́ kotiɣi kotuŋ tɔɣɔ ŋmʋnʋɣʋ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (250) nɑ pɑ́ kʋlɩ Moisi tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ɩlɛnɑ pɑ kotinɑ Moisi nɑ Alɔŋ nɑ pɑ koo-wɛ sɩ: Wooo, mǝ nyǝntʋ nɑ́ wɔpɑ. Sɑmɑɑ tǝnɑ kɛ́ Tɑcɑɑ nyǝ́mɑ kɛ́, nɑ ɩ́ wɛ pɑ wɑɑlɩ. Ɩlɛ pepe tɔɔ kɛ́ mǝ hɔŋ mǝ tɩ sɩ ɩ́ tɛɛ lɛlɑɑ? ");
INSERT INTO dop_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Moisi nɩɩ mpʋ, ɩlɛnɑ ɩ́ hoti ɩ ɩsɛntɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Nɑ ɩ́ tɔ́ Kolee nɑ ɩ wɑɑlɩ nyǝ́mɑ sɩ: Cele tɑnɑŋ Tɑcɑɑ kɑ́ hʋ́lɩ́ mpɑ pɑ kɛ́ ɩ nyǝ́mɑ tɔ. Nɑ ɩ́ yele nɑ ɩ kʋlǝsɑɑ kpǝtǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Mpʋ tɔ, Kolee, nyɑnɑ nyɑ́ wɑɑlɩ nyǝ́mɑ ɩ́ kpɑɣɑ cofolonɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Ɩ́ tʋ́ pɑ tɑɑ kɛ́ mɑmɑlɑ nɑ ɩ́ wɔ Tɑcɑɑ kɛ tulɑɑlʋ. Ɩlɛ tɩɩ nɑ́ wei ɩ́ kɑ́ lǝsɩ sɩ ɩ kɛ́ ɩ nyǝŋ tɔ. Amɑ Lefii piyɑ mɛ mǝ nyǝntʋ wɔpǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Ḿpʋ́ɣʋ́ Moisi heelɑ Kolee tɔtɔ sɩ: Lefii nyǝ́mɑ mɛ ɩ́ nɩɩ yoo. ");
INSERT INTO dop_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ɩsǝnɑ Tɑcɑɑ lǝsɑ-mɛɣɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ sɩ, ɩ́ kpǝtǝnɑ-ɩ, nɑ ɩ́ pɑɑsǝnɑ ɩ tǝcɑɣɑlɛ nɑŋŋ nyǝntɛ, nɑ ɩ́ sɛɛkǝnɑ-wɛɣɛ Ɩsɔ tɔ, pǝ tɑ tɔɔ mɛ? ");
INSERT INTO dop_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kolee, Tɑcɑɑ tʋnɑ nyɑnɑ nyɑ́ tɛɛtʋnɑɑ kɛ tǝmlɛ. Ɩlɛnɑ mɩɩ pɛɛkǝɣɩ sɩ pɑ́ sɔɔsɩ-mɛɣɛ kɔtǝlɑɑ nyǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ɩlɛ Tɑcɑɑ tɔɔ kɛ́ ɩ́ kʋlǝɣɩ, pǝ tɑɣɑ Alɔŋ. Ɩ́lɛ́ ɩ tɑ kɛ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Ḿpʋ́ɣʋ́ Moisi tilɑɑ sɩ pɑ́ yɑɑ Tɑtɑŋ nɑ Apilɑm. Ɩlɛnɑ pɑ́ kisi pote nɑ pɑ́ tɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","N lǝsɑ-tʋɣʋ tɛtʋ nti tǝ tɑɑ kʋpɑntʋ nɑ tɔɣɔnɑɣɑ tɔlɑ yem tǝhɔ tɔ, nɑ ń kɔnɑ-tʋɣʋ wʋlɑɣɑ tɛtʋ tɑɑ. Pɑɑ nɑ mpʋ, pǝ tɑ tɔɔ-ŋ nɑ ń cɑɑ sɩ tǝ́ nyǝnǝɣɩ-ŋ tɑ́ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Anɩ kʋpɑntʋ nɑ tɔɣɔnɑɣɑ tɑ tɔlɩ cǝnɛ. Pǝ́cɔ́ n tɑ tɑlɑ-tʋɣʋ pɑɑ wei nɑ ɩ tɛtʋ, nɑ lɛsɛŋ tɑwɑ. Tɑɑ nyǝnɩ-tʋɣʋ yʋlʋmɑɑ, tɩɩ puki. ");
INSERT INTO dop_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Ḿpʋ́ɣʋ́ pɑ́ɑ́nɑ́ huu Moisi tɑɑ, nɑ pɑ tɔm ntɩ. Ɩlɛnɑ ɩ́ heeli Tɑcɑɑ sɩ: Tɑɑ tɑsɑ pɑ kɔtɑsɩ kɛ mʋɣʋ. Mɑ tɑ ŋmɑkǝlǝtɑ pɑ tɑɑ nɔɣɔlʋ. Pǝyele mɑ tɑ mʋtɑ pɑ tɑɑ nɔɣɔlʋ kpɑŋɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ḿpʋ́ɣʋ́ Moisi tɔmɑ Kolee sɩ: Cele tɑnɑŋ, nyɑnɑ nyɑ́ wɑɑlɩ nyǝ́mɑ ɩ kɔɔ Tɑcɑɑ ɩsɛntɑɑ, nɑ Alɔŋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ɩlɛnɑ ɩ́ nɑ pɑ ŋmʋnʋɣʋ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (250) pɑ́ kpɑɣɑ cofolonɑɑ, nɑ pɑ́ wɔ Tɑcɑɑ kɛ tulɑɑlʋ. ");
INSERT INTO dop_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Kolee nɑ ɩ nyǝ́mɑ pɑ́ tɛŋ mpʋ, ɩlɛnɑ pɑ́ tuusi nɑ pɑ́ sǝŋ Ɩsɔ cokǝle nɔnɔɣɔ. Nɑ Moisi nɑ Alɔŋ pɛlɛ pɑ́ polo tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Ntɛnɑ Kolee sɔɔsɩ Ɩsɛɣɛlɩ sɑmɑɑ tǝnɑɣɑ ɩ tɔɔ kɛ́ Ɩsɔ cokǝle nɔnɔɣɔ. Ḿpʋ́ɣʋ́ Tɑcɑɑ teeli nɑ́ pɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ɩlɛnɑ Ɩsɔ tɔ́ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Ɩ́ hɑtǝlǝnɑ-wɛ, mɑ cɑɑ-wɛɣɛ kpiisuɣu kɛ tɔm kʋlʋm tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Tǝnɑɣɑlɛ Moisi nɑ Alɔŋ pɑ hotɑ pɑ nɔɔsɩ tɔɔ kɛ́ kpɑkpɑɑ. Nɑ pɑ́ mɑ́ kɑpukɑ sɩ: Hɑɩ, yǝlɑɑ tǝnɑ ŋmɑlʋ Ɩsɔ. Kʋlʋm wɑkǝlɑɑ, ɩlɛnɑ ń mʋɣɩ sɑmɑɑ tǝnɑ nɑ pɑ́ɑ́nɑ́ nɑ? ");
INSERT INTO dop_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ntɛnɑ Tɑcɑɑ cɔ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Heeli sɑmɑɑ nɑ pɑ́ hɑtǝlǝnɑ Kolee nɑ Tɑtɑŋ nɑ Apilɑm pɑ tǝcɑɣɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ḿpʋ́ɣʋ́ Moisi polɑ Tɑtɑŋ nɑ Apilɑm pɑ cɔlɔ. Nɑ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ kɛ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Nɑ ɩ́ heeli sɑmɑɑ sɩ: Ɩ́ hɑtǝlǝnɑ ɑsɑɣɑɑ mpɛ pɑ cokɑ. Ye wei ɩ́ tokinɑ pɑ pʋlʋpʋ pɑ ɩsɑɣɑtʋ kɑ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ntɛnɑ sɑmɑɑ hɑtǝlǝnɑ Kolee pɑ cokɑ. Wɑɑtʋ ɩnɩ Tɑtɑŋ nɑ Apilɑm pɑ ɑlɑɑ, nɑ pɑ lʋlʋɣʋ nyǝ́mɑ lɛlɑɑ pɑɑ tɛmɑ lɩɩʋ, nɑ pɑ́ sǝŋ pɑ nɔnɔɔsɩ. ");
INSERT INTO dop_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mpʋɣʋlɛ Moisi tɔmɑ sɩ: Ɩ́ kɑ́ cɛkǝnɑ teu sɩ mɑɑ lɑkɩ pʋlʋ nɑ mɑ mɑɣɑmɑɣɑ mɑ toŋ. Amɑ Tɑcɑɑ tilinɑ-m. ");
INSERT INTO dop_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ye yǝlɑɑ pɑnɛ pɑ sǝpɑ pɑ mɑɣɑmɑɣɑ pɑ sǝm, ɩlɛ pǝ tɑɣɑ Tɑcɑɑ tilinɑ-m. ");
INSERT INTO dop_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Amɑ ye ɩ lɑpɑ piti tǝmlɛ nɑ tɛtʋ hɑɑ nɔɣɔ, nɑ tǝ́ li pɑ́ nɑ pɑ nyǝm tǝnɑ, nɑ pɑ́ tii ɑtɛtǝlɛ tɑɑ nɑ pɑ ɩsɛ, ɩlɛ pǝlɛɣɛlɛ ɩ́ kɑ́ tʋnɑ sɩ pɑ woŋɑ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Moisi nɔɣɔ tɑ tɩɩ tiitɑ ɑtɛɣɛ, nɑ tɛtʋ fɑɣɑ yem kɛ pɑ nɔɔhɛɛ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Nɑ tǝ́ li pɑ́ nɑ pɑ ɑlɑɑ, nɑ pɑ piyɑ. Nɑ Kolee wɑɑlɩ nyǝ́mɑ nɑ pɑ nyǝm tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Nɑ pɑ́ tii ɑtɛtǝlɛ tɑɑ. Ɩsɛɣɛlɩ nyǝ́mɑ tɑ tɑsɑ-wɛɣɛ nɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Lɛlɑɑ mpɑ pɑ kpǝtǝnɑ-wɛ tɔ, pɑ nɩɩ pɑ kɑkiisɑsɩ ɩlɛnɑ pɑ se. Mpi tɔ, pɑ nyɑŋɑɣɑ sɩ tɛtʋ ɩ́ tɑɑ kɔɔ nɑ tǝ́ li mpɛ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ḿpʋ́ɣʋ́ Ɩsɔ tisɑ kɔkɔ nɑ kɑ́ nyɑɣɑ yǝlɑɑ ŋmʋnʋɣʋ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (250) wei ɩ lɑkɑɣɑ tulɑɑlʋ kɔtɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Tɛlǝsɩ Alɔŋ pǝyɑlʋ kɔtʋlʋ Ɩlɑsɑɑ sɩ, lǝsɩ cofolonɑɑ kɛ kɔkɔ tɑɑ nɑ ń yɑsɩ mɑmɑlɑ. Pɑ kɛ́ mɑ nyǝm kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Cofolonɑɑ mpɛ pɑ kɛ́ Ɩsɔ nyǝ́mɑ kɛ́. Mpi tɔ, pɑ tɛmɑ-m-wɛɣɛ kɔtɑɣɑ lɑpǝnɑʋ. Amɑ mpɑ pɑ tɩ-wɛ tɔ pɑ sǝpɑ pɑ ɩsɑɣɑtʋ tɔɔ. Pǝ tɔɔ tɔ, pǝ wɛɛ sɩ pɑ́ hɛɛ-wɛ nɑ pɑ́ wɑɑsɩ kɔtɑɣɑ tǝlɑtɛ tɔɔ. Ɩlɛnɑ pɑ́ pǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pʋlʋ kʋyʋsʋm. ");
INSERT INTO dop_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Ḿpʋ́ɣʋ́ kɔtʋlʋ Ɩlɑsɑɑ kpɑɣɑ yǝlɑɑ mpɑ kɔkɔ nyɑɣɑ mpʋ tɔ, pɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ cofolonɑɑ. Nɑ ɩ́ lu-wɛ nɑ ɩ́ wɑɑsɩ kɔtɑɣɑ tǝlɑtɛ. ");
INSERT INTO dop_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Mpʋ pǝ hʋlǝɣǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, Alɔŋ lʋlʋɣʋ nyǝmɑ pɑɑsi kpɑɩ tʋ nɔɣɔlʋ ɩ fɛɩnɑ mpɑɑʋ sɩ ɩ́ tɑsɑ Tɑcɑɑ kɛ tulɑɑlʋ wɔpʋ. Ye wei ɩ́ lɑpɑ mpʋ, sǝm mpi Kolee nɑ ɩ wɑɑlɩ nyǝ́mɑ pɑ sǝpɑ tɔ, mpɩ pɩɩ kʋnɑ-ɩ. Ɩsɩɩ Tɑcɑɑ kɑ kpɑɑlʋɣʋ Alɔŋ nɑ Moisi nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Tɛʋ femɑ ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɑɑlɩ Alɔŋ nɑ Moisi kɛ cɑɣɑnɑʋ sɩ: Ɩ́ kʋwɑ Tɑcɑɑ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ḿpʋ́ɣʋ́ sɑmɑɑ kotinɑ Moisi nɑ Alɔŋ. Sɑɑ wei pɑ nyǝnnɑ Ɩsɔ cokǝle tɔɔ, ɩlɛnɑ pɑ́ nɑ́ nyɔɔsɩ nyɑlɑ timpi Tɑcɑɑ teeli nɑɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Ɩlɛnɑ Moisi nɑ Alɔŋ pɑ́ polo tǝ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ɩlɛnɑ Tɑcɑɑ tɔ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Hɑtǝlǝnɑ yǝlɑɑ mpɛ, nɑ mɑ́ kpiisi-wɛɣɛ tɔm kʋlʋm. Tǝnɑɣɑ Moisi nɑ Alɔŋ pɑ hotɑ pɑ ɩsɛntɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Nɑ Moisi tɔ ɩ tɑɑlʋ sɩ: Polo tǝcɑʋ nɑ ń kpɑɣɑ nyɑ́ cofolo nɑ ń hee kɔtɑɣɑ tǝlɑtɛ tɔɔ kɔkɔ. Tʋ́ tulɑɑlʋ kɛ́ pǝ tɔɔ, nɑ ń lɑ sɑmɑɑ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Mpi tɔ, Tɑcɑɑ mʋ pɑ́ɑ́nɑ́ kɛ́ hɑlɩ ɩ tɛmɑ niŋ tʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Ḿpʋ́ɣʋ́ Alɔŋ kpɑɣɑ cofolo, ɩsɩɩ Moisi heeluɣu-ɩ tɔ. Ɩlɛnɑ ɩ́ cɔɔ sɑmɑɑ tɑɑ, nɑ ɩ́ nɑ́ sɩ pɑ tɔŋnɑ sǝpʋ. Ɩlɛnɑ ɩ́ wɔ tulɑɑlʋ, nɑ ɩ́ lɑ-wɛɣɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ḿpʋ́ɣʋ́ ɩ sǝŋɑ mpɑ pɑ tɛmɑ sǝpʋ tɔ, nɑ ɩsɛ nyǝ́mɑ pɑ hɛkʋ tɑɑ. Ɩlɛnɑ sǝm hɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Kolee wɑɑlɩ nyǝ́mɑ mpɑ pɑ sǝpɑ lɔŋ tɔ pɑ pɑɑsi yǝlɑɑ iyisi nɑɑnʋwɑ nɑ liɣiti nɑ nɑsǝtoso nɑ nɩɩnʋwɑ (14.700) sǝpǝnɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Ntɛnɑ Alɔŋ mǝlɩ Moisi kiŋ kɛ Ɩsɔ cokǝle nɔnɔɣɔ kɛ sɑɑ wei sǝm hɛɛwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","Heeli Ɩsɛɣɛlɩ kpekɑ nyɔɔŋ nyǝ́mɑ sɩ pɑɑ wei ɩ́ kɔnɑ kpɑ́tʋ́ɣʋ́. Pǝ kpɛntǝɣɩ kpɑtǝŋ nɑɑnʋwɑ nɑ nɑɑlɛ kɛlɛ. Ɩlɛnɑ ɩ́ ŋmɑɑ pɑɑ mpɑ pɑ kpekǝle hǝtɛ kɛ pɑ nyǝŋkʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Amɑ Alɔŋ hǝtɛ kɛ ɩ́ kɑ́ ŋmɑɑ Lefii nyǝ́mɑ nyǝŋkʋ tɔɔ. Ɩlɛnɑ pɑɑ kpekǝle tʋ wei ɩ́ wɛɛnɑ ɩ nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Ɩlɛnɑ Tɑcɑɑ sɩ: Moisi sɩɩ kpɑtǝŋ ɩnǝɣɩ Ɩsɔ cokǝle tɑɑ kɛ́ ɑtɑkɑɑ kiŋ, kɛ timpi mɑ́ nɑ-mɛ tǝ suliɣi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Nɑ mɑ́ lǝsɑ wei, ɩ́lɛ́ ɩ kpɑ́tʋ́ɣʋ́ nɛɣɛtǝɣǝnɑ ntɛ́. Ɩlɛnɑ mɑ́ sɩɩ tǝnɑɣɑ kɛ kʋntǝnɑʋ mpi Ɩsɛɣɛlɩ nyǝ́mɑ kʋntǝɣǝnɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Mpʋɣʋlɛ Moisi tɛlǝsɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ tɔm ntɩ. Nɑ kpekɑ nyɔɔŋ nyǝ́mɑ kɔnɑ-ɩ pɑ kpɑtǝŋ nɑ Alɔŋ nyǝŋkʋ kɑ wɛ hɛkʋ tɑɑ. Ɩlɛnɑ pǝ́ lɩɩ kpɑtǝŋ nɑɑnʋwɑ nɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Ɩlɛnɑ Moisi sɩɩ kpɑtǝŋ ɩnǝɣɩ Ɩsɔ cokǝle tɑɑ kɛ́ ɑtɑkɑɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Tɛʋ femɑ, nɑ Moisi sʋʋ tǝ tɑɑ, ɩlɛ ɩ mɑɣɑnɑ Lefii kpekǝle tʋ Alɔŋ kpɑ́tʋ́ɣʋ́ nɛɣɛtɑɑ kɛlɛ. Nɑ kʋ́ tʋ́ hɛtʋ. Hɑlǝnɑ kʋ́ lʋlɩ pee nɑ ɑ́ pɩɩwɑ. ");
INSERT INTO dop_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Ḿpʋ́ɣʋ́ Moisi kuu kpɑtǝŋ tǝnɑ, nɑ ɩ́ ponɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑɑ wei ɩ́ nɑ. Ɩlɛnɑ pɑɑ nyʋɣʋ tʋ wei ɩ́ kpɑɣɑ ɩ nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Ntɛnɑ Tɑcɑɑ tɑsɑ Moisi kɛ heeluɣu sɩ: Polo ń sɩɩ Alɔŋ kpɑ́tʋ́ɣʋ́ kɛ ɑtɑkɑɑ kiŋ, nɑ pǝ́ tɔɔsɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɑ kɑɑnɩɩtʋ. Ɩlɛnɑ pɑ kʋntʋɣʋ sɩɩ tǝnɑɣɑ. Ɩlɛ pɑ kɑɑ tɑsɑ sǝm. ");
INSERT INTO dop_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Ḿpʋ́ɣʋ́ Moisi lɑpɑ teitei kɛ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɔmɑ Moisi sɩ: Nyǝnɩ ɩsǝnɑ tɑ tǝnɑ tǝ sǝkɩ nɑ tǝ́ tɛŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Tɑ́ tɑɑ wei ɩ́ kpǝtǝnɑ Ɩsɔ tǝcɑɣɑlɛ, ɩ́lɛ́ ɩ sɩ. Tɑ́ tǝnɑ tɩɩ sǝnɑ ntɛ́? ");
INSERT INTO dop_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Alɔŋ sɩ: Ye nyɑnɑ nyɑ́ lʋlʋɣʋ nyǝ́mɑ nɑ nyɑ́ tɛɛtʋnɑɑ Lefii nyǝ́mɑ lɛlɑɑ, ɩ́ wɑkǝlɑ Ɩsɔ cokǝle tɑɑ tǝmlɛ nɑ mǝ kɔtʋɣʋ nyǝntɛ, mǝ nyɔɔŋ tɑɑ kɛ́ pɩɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Wɑɑtʋ wei ɩ́ sʋʋkɩ tǝ tɑɑ kɛ́ tǝmlɛ, ɩlɛnɑ ɩ́ yɑɑ mǝ tɛɛtʋnɑɑ Lefii nyǝ́mɑ nɑ pɑ́ wɛɛ mǝ wɑɑlɩ nyǝ́mɑ, nɑ pɑ́ sǝŋnɑ-mɛ. ");
INSERT INTO dop_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Pɑɑ lɑ pǝ tǝnɑ mpi n kɑ́ kɛɛsɩ-wɛɣɛ cokǝle pɑɑsǝnɑʋ tɔm tɑɑ tɔ. Amɑ pǝ fɛɩ sɩ pɑ́ tokinɑ Ɩsɔ pʋlʋpʋ yɑɑ kɔtɑɣɑ tǝlɑtɛ. Pǝ́ tɑɑ kɔɔ nɑ mpɛ yɑɑ mǝ tɑɑ nɔɣɔlʋ sɩ. ");
INSERT INTO dop_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Pɑ tike pɑɑ sǝŋnɑ-mɛɣɛ Ɩsɔ cokǝle tǝmlɛ tɑɑ. Cɑɣɑlʋ nɔɣɔlʋ ɩ kɑɑ kpǝtǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Ɩlɛnɑ mɩɩ pɑɑsǝnɑ tǝ nɑ kɔtɑɣɑ tǝlɑtɛ. Ɩlɛ mɑ pɑ́ɑ́nɑ́ kɑɑ tɑsɑ huuu kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mɑ lǝsɑ mǝ tɑɑ kɛ́ mǝ tɛɛtʋnɑɑ Lefii nyǝ́mɑ. Ɩlɛnɑ mɑ tɑɣɑnɩ-mɛɣɛ wɛɣɛ hɑʋ sɩ, pɑ́ lɑ tǝmlɛ kɛ Ɩsɔ cokǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Amɑ Alɔŋ, nyɑnɑ nyɑ́ lʋlʋɣʋ nyǝ́mɑ mɩɩ lɑ mǝ kɔtʋɣʋ tǝmlɛ kɛ kɑtɛ tɑɑ kɑtɛ tǝcɑɣɑlɛ tɑɑ, kɛ́ pʋʋɣʋ kʋkɑɣɑʋ wɑɑlɩ. Mɑ́ hɑɑkǝnɑ-mɛɣɛ lonte ntɛ́. Ye yʋlʋ kɛ yem kpǝtǝnɑ tǝnɑ, ɩsɩɩ pɑ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Alɔŋ sɩ: Nyɑnɑ nyɑ́ lʋlʋɣʋ nyǝ́mɑ ɩ́ tǝnnɑ kɔtɑsɩ nsi Ɩsɛɣɛlɩ nyǝ́mɑ hʋlɑɑ sɩ sɩ kɛ́ mɑ nyǝnsɩ tɔɣɔ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kɑtɛ tɑɑ kɑtɛ nyǝm mpi pɑ tɑ nyɑɣɑsɩ kɔkɔ, nɑ pɩɩ pǝsɩ mǝ nyǝm kɛ Ɩsɛɣɛlɩ nyǝ́mɑ kʋcɔɔʋ, nɑ pɑ kʋhɑʋ, nɑ pɑ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ pɑ tɑsǝkǝlɛ tɑɣɑnʋɣʋ nyǝŋkɑ tǝnɑ ŋkɑ pɑɑ lɑ-m tɔɣɔlɔ. Wontu kɑtɛ nyǝntʋ ntɩ tǝ pǝsǝɣɩ mǝ nɑ mǝ piyɑ mǝ nyǝm kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ɩlɛ mǝ tɑɑ ɑpɑlɑɑ nyǝ́mɑ tike kɑ́ tɔɣɔnɑ kɔtɑɣɑ tɔɣɔnɑɣɑ ŋkɛɣɛ Ɩsɔ lonte tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","13","Nɑ pǝ́ sɔɔsǝnɑ kʋcɔɔŋ wei Ɩsɛɣɛlɩ nyǝ́mɑ pɑɣɑlɑ-m, nɑ pɑ́ kpɑɑsɩ-m nɑ ɩsɔ nɑ pɑ́ hɑ-m tɔ. Pɑɑ nim kʋpɑm, pɑɑ sʋlʋm kʋpɑm, pɑɑ tɔɣɔnɑɣɑ pee kʋpɑnɑ nnɑ ɑ kɛ́ tɛtʋ kʋlʋlʋm kɑncɑɑlɑɣɑ nyǝm tɔ. Nyɑnɑ nyɑ́ piyɑ piyɑ mǝ nyǝm ntɛ́ tɑm tɔɔ. Nɑ mǝ tɑɑ ɑpɑlɑɑ, nɑ ɑlɑɑ mpɑ pɑ wɛ tǝnɑŋŋ tɔ, pɑ pǝsǝɣɩ nɑ pɑ́ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Nɑ pǝ tǝnɑ mpi pǝ kɛ́ mɑ nyǝm tɔ, pǝ tɑɣɑnǝɣɩ mǝ nyǝm kɛ pǝsʋɣʋ tɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Yǝlɑɑ nɑ tɔlɑ kɑncɑɑlɑɣɑ ɑpɑlʋpiyɑ nsi pɑ hɑ-m tɔ sɩ pǝsɑ mɑ nyǝnsɩ kɛ́. Ɩlɛ ɩ́ kɑ́ tɑɣɑnɩ yɑpʋ kɛ yǝlɑɑ nyǝnsɩ nɑ tɔlɑ nnɑ ɑ tɑ mʋnɑ kɔtɑɣɑ tɔ ɑ nyǝnsɩ. ");
INSERT INTO dop_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Apɑlʋpǝyɑɣɑ ŋkɑ kɑ wɛnɑ ɩsɔtʋ kʋlʋm tɔ, kɑ liɣitee kɑ́ wɛɛ nyǝɣǝtʋ kɑkpɑsɩ kɛ́ nɑ pǝ́ kɛɛsǝnɑ ɩsǝnɑ pɑ mɑɣɑsʋɣʋ Ɩsɔ cokǝle tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Pǝ fɛɩ sɩ, ɩ́ tɑɣɑnɩ yɑpʋ kɛ nɑʋ yɑɑ heu yɑɑ pǝŋ́ kɑncɑɑlɑɣɑ ɑpɑlʋpǝyɑɣɑ. Tɔlɑ ɑnɩ ɑ kɛ́ mɑ nyǝm kɛ́ tǝsiɣisiɣi. Ɩ́ kɑ́ ŋmɩɩsɩ ɑ cɑlǝm kɛ kɔtɑɣɑ tǝlɑtɛ tɔɔ kɛ́. Nɑ ɩ́ wɔ nim cɔlɔ nim cɔlɔɣɔ kɔkɔ. Nɑ mɑ lɑŋlɛ hɛɛnɑ pǝ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ɩlɛnɑ ɑ nɑntʋ pǝsɩ mǝ nyǝntʋ. Teitei ɩsɩɩ pɑ lɑkʋɣʋ ciikuɣu kɔtɑɣɑ, nɑ pɑ́ hʋlǝɣɩ-m lɑŋlɛ nɑ yule ntɔɣɔŋ nyǝntɛ, nɑ hɔɣɔlǝŋ tǝnɑ ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ lɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Pǝ tǝnɑ mpi Ɩsɛɣɛlɩ nyǝ́mɑ hʋlǝɣɩ-m nɑ hɔɣɔlǝŋ tǝnɑ sɩ kʋcɔɔʋ nɑŋŋ nyǝŋkʋ tɔ. Kʋ pǝsɑ nyɑnɑ nyɑ́ pǝyɑlɑɑ nɑ nyɑ́ pɛɛlɑɑ mǝ nyǝŋkʋ kɛ́. Pǝ kɛ́ tɑm tɔɔ nyǝntʋ kɛ mǝ nɑ mǝ lʋlʋɣʋ nyǝ́mɑ kɛ́, tǝ fɛɩ lɑɣɑsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Alɔŋ kɛ heeluɣu tɔtɔ sɩ: N kɑɑ hiki tɛtʋ ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ lɛlɑɑ. Amɑ mɑɣɑlɛ nyɑ́ tɑɑlɛ nɑ nyɑ́ wɛnɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Hɔɣɔlǝŋ nɑɑnʋwɑ tɑɑ kʋlʋmʋɣʋ ŋku Ɩsɛɣɛlɩ nyǝ́mɑ kɔŋnɑ Tɑcɑɑ tɔɣɔ mɑɑ cɛlɑ Lefii nyǝ́mɑ mpɑ pɑ lɑpɑ Ɩsɔ cokǝle tɑɑ kɛ́ tǝmlɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Sɑmɑɑ kɑɑ kpǝtǝnɑ cokǝle. Pǝ́ tɑɑ kɔɔ nɑ pɑ́ pǝntɩ nɑ pɑ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lefii nyǝ́mɑ tike kɑ lɑkǝnɑ cokǝle tɑɑ tǝmlɛ. Ye pɑ pǝntɑɑ pǝ́ wɛɛ pɑ nyɔɔŋ tɑɑ. Pɑ kɑɑ wɛɛnɑ tɛtʋ ɩsɩɩ kpekɑ lɛnnɑ. Ɩ́ tɔkɩ kʋsǝsɩɩtʋ tǝnɛɣɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Amɑ mɑɑ cɛlɑ-mɛɣɛ hɑtǝmʋtʋ hɔɣɔlǝŋ nɑɑnʋwɑ tɑɑ kʋlʋmʋɣʋ, ŋku Ɩsɛɣɛlɩ nyǝ́mɑ lɑpɑ-m kɔtɑɣɑ nɑ pɑ́ kpɑɑsɩ-m nɑ ɩsɔ tɔ. Pǝ tɔɔ kɛ́ mɑ heelɑ-mɛ sɩ, ɩ́ kɑɑ hiki tɛtʋ ɩsɩɩ kpekɑ lɛnnɑ. ");
INSERT INTO dop_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Tɛlǝsɩ Lefii nyǝ́mɑ sɩ, ye Ɩsɛɣɛlɩ nyǝ́mɑ kɔnɑ-mɛɣɛ pɑ hɑtǝmʋtʋ hɔɣɔlǝŋ nɑɑnʋwɑ tɑɑ kʋlʋmʋɣʋ ŋku mɑ hɑ-wɛ tɔ, ɩlɛ mɩɩ lǝsɩ pǝ tɑɑ kɛ́ hɔɣɔlǝŋ nɑɑnʋwɑ tɑɑ kʋlʋmʋɣʋ tɔtɔ nɑ ɩ́ cɛlɛ-m. ");
INSERT INTO dop_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Nɑ pǝ́ wɛɛ ɩsɩɩ mǝ tɛɛtʋnɑɑ lǝsʋɣʋ pɑ hɑtǝmʋtʋ nɑ pɑ lɛsɛŋnɑɑ tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Tǝnɑɣɑ mǝ hikiɣinɑ mǝ kʋhɑʋ nɑ ɩ́ kɔnɑ-m nɑ ɩ́ cɛlǝɣɩ Alɔŋ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kʋcɔɔŋ wei ɩ tǝnɑ ɩ́ hikiɣi tɔ, ɩ tɑɑ kɛ́ ɩ́ kɑ́ lǝsɩ tǝpɑntɛ nɑ ɩ́ cɛlɛ-m. ");
INSERT INTO dop_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Ye ɩ́ tɛmɑ lǝsʋɣʋ kɛ mɑ nyǝm, ɩlɛ ɩ́ sɩɩ mǝ tǝɣɩ kʋkɑɑsǝm. Ɩsɩɩ mǝ tɛɛtʋnɑɑ kɑɑsʋɣʋ pɑ tǝɣɩ hɑtǝmʋtʋ nɑ lɛsɛŋnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Tǝmlɛ nte ɩ lɑkɩ cokǝle tɑɑ tɔ tǝ kʋfɛlʋɣʋ ntɛ́. Ɩlɛ pɑɑ timpiɣi mǝ nɔkɑɑ mǝnɑ mǝ tɛɛsɩ nyǝ́mɑ ɩ́ pǝsǝɣɩ nɑ ɩ́ tɔɣɔ pǝ tɔɣɔnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Ye ɩ́ tɑ́ lǝsɩ-m tǝpɑntɛ, ɩlɛnɑ pǝ́cɔ́ ɩ́ tɔɣɔ kʋkɑɑsǝm, ɩ́ pilisɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɔtɑɣɑ kɛ́. Mǝ tɔm kɑ́ sɩ nɑ pǝ́ ponɑ-mɛɣɛ sǝm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi nɑ Alɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Ɩ́ tɛlǝsɩ sɑmɑɑ kɛ kʋsǝsɩɩtʋ tǝnɛ sɩ, ɩ́ cɑɑ nɑʋ kʋsɛɛm wei ɩ tiili tɑ́ cɑɑmɩ, pǝ́cɔ́ pɑ tɑ tʋtɑ-ɩ kpɑ́tʋ́ɣʋ́ kʋhɑlʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Nɑ ɩ́ cɛlɑ kɔtʋlʋ Ɩlɑsɑɑ, nɑ ɩ́lɛ́ ɩ́ lɩɩnɑ-ɩ tǝsikile wɑɑlɩ nɑ pɑ́ lɛntɩ-ɩ mɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ɩlɛnɑ kɔtʋlʋ lii cɑlǝm tɑɑ kɛ́ mpǝle kɛ tɔm nɑɑtosompɔɣɔlɑɣɑ nɑ ɩ́ ŋmɩɩsǝɣǝnɑ cokǝle nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Nɑ pɑ́ wɔ nɑʋ tǝnɑɣɑ kɔtʋlʋ ɩsɛntɑɑ. Pǝ kpɑɣɑʋ kɔŋlɛ, nɑ nɑntʋ, nɑ cɑlǝm, nɑ pǝ tɑɑ lotu tɔ. ");
INSERT INTO dop_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Nɑ kɔtʋlʋ kpɑɣɑ tʋɣʋ ŋku pɑ yɑɑ sɩ sɛɛtǝlɩ tɔ kʋ tɑɑsɩ, nɑ tʋɣʋ ŋku pɑ yɑɑ sɩ hisɔpʋ tɔ kʋ piliŋɑ, nɑ heeŋ hʋntʋ nti pɑ lii ɑkpɑɑyɑlɑ tɔ, nɑ ɩ́ pɛtɩ timpi nɑʋ tɔŋɑ nyɑɣɑʋ kɛ mpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Pǝ wɑɑlɩ ɩlɛnɑ, ɩ́ cɔtɔ ɩ wontu nɑ ɩ́ sɔ lʋm nɑ pǝ́cɔ́ ɩ́ sʋʋ tǝsikile tɑɑ. Nɑ ɩ́ wɛɛ ɑsilimɑ tɑɑ, hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Nɑʋ wɔtʋ kɑ́ cɔtɔ ɩ wontu nɑ ɩ́ sɔ lʋm nɑ ɩ́ cɑɣɑ ɑsilimɑ tɑɑ tɔtɔ, hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Ɩlɛnɑ yʋlʋ wei ɩ fɛɩ ɑsilimɑ tɑɑ tɔ, ɩ́ kuu nɑʋ tɔlʋmɑ nɑ ɩ́ ponɑ lonte kʋpɑntɛ tɑɑ kɛ́ tǝsikile wɑɑlɩ. Nɑ ɩ́ sɩɩ-yɛ nɑ pɑ́ lɑ́ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ lʋm. Kɔtɑɣɑ ŋkɛ kɑ wɛ ɩsɩɩ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋkɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Pǝ wɛɛ sɩ tɔlʋmɑ kuulu ɩ́ cɔtɔ ɩ wontu tɔtɔɣɔ. Ɩlɛnɑ ɩ́ wɛɛ ɑsilimɑ tɑɑ, hɑlǝnɑ tɑɑnɑɣɑ. Ɩsɛɣɛlɩ nyǝ́mɑ nɑ cɑɣɑlɑɑ pɑɑ tɔkǝnɑ kɔtɑɣɑ kɑnɛɣɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ye wei ɩ́ tokinɑ sǝtʋ, ɩ kɑ́ cɑɣɑ ɑsilimɑ tɑɑ kɛ́. Hɑlǝnɑ kʋyɑkʋ nɑ kʋ ɩsikile. ");
INSERT INTO dop_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ɩlɛnɑ ɩ́ ŋmɩɩsɩ ɩ tǝɣɩ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ lʋm mpǝɣɩ kʋyɑkʋ tooso nyǝŋkʋ, nɑ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ. Ɩlɛnɑ ɩ́ wɛɛ tǝnɑŋŋ. Ye ɩ tɑ lɑ mpʋ, ɩ wɛ ɑsilimɑ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Pǝyele ɩ pilisɑ Tɑcɑɑ tǝyɑɣɑ kɛ́. Nɑ ɩ ɑsilimɑ wɛ tɑm kɛ́ ɩ tɑ ŋmɩɩsɩ ɩ tǝɣɩ kɔtɑɣɑ lʋm tɔ pǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ye yʋlʋ sǝpɑ kutuluɣu tɑɑ, nɑ nɔɣɔlʋ sʋʋ ɩ kiŋ. Yɑɑ pʋntʋ kɑ tɩɩ wɛ tǝnɑ. Ɩ pǝsɑ ɑsilimɑ tʋ kɛ́ hɑlǝnɑ kʋyɑkʋ nɑ kʋ ɩsikile. ");
INSERT INTO dop_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Pɑɑ fulɑɣɑ, yɑɑ pʋlʋpʋ wɛ tǝnɑ nɑ pǝ́ tɑ́ pɑ́ teu. Pǝ tɑɑ nyǝm pilisɑɑ tɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ye pɑ kʋ yʋlʋ, yɑɑ ɩ sǝpɑ ɩ sǝm kɛ nyɩɩtʋ tɑɑ. Ɩlɛnɑ nɔɣɔlʋ tokinɑ pɑɑ ɩ mʋwɑ yɑɑ ɩ pǝlɑɑʋ. Pʋntʋ pǝsɑ ɑsilimɑ tʋ kɛ́, hɑlǝnɑ kʋyɑkʋ nɑ kʋ isikile. ");
INSERT INTO dop_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Ye pɑ cɑɑkɩ ɑsilimɑ tʋ kɛ nyɑɑlʋɣʋ, nɑʋ ɩnɩ ɩ tɔlʋmɑ kɛ pɑ cosiɣi. Nɑ pɑ́ tʋ́ pʋlʋpʋ tɑɑ nɑ pɑ́ pǝlɩ lʋm kʋpɑm. ");
INSERT INTO dop_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ɩlɛnɑ wei ɩ fɛɩ ɑsilimɑ tɔ, ɩ cɑɑ tʋɣʋ ŋku pɑ yɑɑ sɩ hisɔpʋ tɔ kʋ piliŋɑ nɑ ɩ́ lii lʋm mpɩ pǝ tɑɑ. Nɑ ɩ́ ŋmɩɩsɩ cokǝle nte tǝ tɑɑ yʋlʋ sǝpɑ mpʋ tɔ. Nɑ pǝ́ kpɛnnɑ tǝ yǝlɑɑ, nɑ pǝ wontu, nɑ wei ɩ tokinɑ sǝtʋ, yɑɑ ɩ mʋwɑ, yɑɑ ɩ pǝlɑɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Kʋyɑkʋ tooso nyǝŋkʋ, nɑ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ kɛ pɑɑ lɑpɩ-ɩ mpʋ. Pǝ wɑɑlɩ ɩlɛnɑ, ɩ́ cɔtɔ ɩ wontu nɑ ɩ́ sɔ lʋm. Tɑɑnɑɣɑ ntɛ́ ɩ ɑsilimɑ tɛŋ. ");
INSERT INTO dop_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ye ɑsilimɑ tʋ tɑ lɑ mpʋ, pɑɑ lǝsɩ-ɩ Ɩsɛɣɛlɩ kpekǝle tɑɑ. Mpi tɔ, ɩ pilisɑ Tɑcɑɑ cokǝle kɛ́. Pǝ́cɔ́ ɩ pǝsɑ ɑsilimɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ɩsɛɣɛlɩ nyǝ́mɑ kɑ́ tɔkɩ kɔtɑɣɑ kɑnɛɣɛ tɑm tɔɔ kɛ́. Ye wei ɩ ŋmɩɩsɑ kɔtɑɣɑ lʋm, pǝ wɛɛ sɩ ɩ́ cɔtɔ ɩ wontu kɛ́. Nɑ wei ɩ́lɛ́ ɩ́ tokinɑ-wɩ, ɩ́ wɛɛkɩ ɑsilimɑ tɑɑ kɛ́ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Ye ɑsilimɑ tʋ ɩ́ tokinɑ mpi, ɩ pilisɑ-wǝɣɩ. Nɑ wei ɩ́lɛ́ ɩ́ tɩɩ tokinɑ ɑsilimɑ tʋ, pʋntʋ pǝsɑ ɑsilimɑ tʋ kɛ́, hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɑlɑ Siŋ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ ɩsɔtʋ kɑncɑɑlɑɣɑ nyǝŋ tɑɑ, nɑ pɑ́ siki Kɑtɛɛsɩ. Tǝnɑɣɑ Mɑlǝyɑm sǝpɑ nɑ pɑ́ pimi-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Wɑɑtʋ wei sɑmɑɑ lɑŋɑ lʋm, ɩlɛnɑ pɑ́ kotinɑ Moisi nɑ Alɔŋ ");
INSERT INTO dop_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","nɑ pɑ́ kuuki Moisi nɔɣɔ sɩ: Ye Ɩsɔ kɑ kpɛntɑ tɑ nɑ tɑ tɛɛtʋnɑɑ kɛ kʋɣʋ, pɩɩ kǝlɑ teu. ");
INSERT INTO dop_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Pepe tɔɔ kɛ́ ɩ kɔnɑ Ɩsɔ yǝlɑɑ tɑɣɑ wʋlɑɣɑ tɛtʋ tǝnɛ tǝ tɑɑ cǝnɛ sɩ, tɑ́ nɑ tɑ́ kɑlǝkǝŋ tǝ sɩ? ");
INSERT INTO dop_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Ɩ tɩɩ lǝsɑ-tʋɣʋ Icipiti, nɑ ɩ́ kɔnɑ-tʋɣʋ lonte ɩsɑɣɑlɛ tǝnɛ tǝ tɑɑ suwe? Pǝ fɛɩ hɑlǝm, pǝ́cɔ́ yʋlʋ kɑɑ hiki tɩɩŋ kʋlʋlǝŋ, ɩsɩɩ fikinɑɑ yɑɑ lɛsɛŋnɑɑ, yɑɑ tʋɣʋ nɑkʋlɩ. Anɩ lʋm kʋnyɔnyɔɔm mɑɣɑmɑɣɑ nɑ́ tɩɩ fɛɩ kɔlɔ. ");
INSERT INTO dop_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Ḿpʋ́ɣʋ́ Moisi nɑ Alɔŋ pɑ hɑtǝlǝnɑ sɑmɑɑ, nɑ pɑ́ polo Ɩsɔ cokǝle nɔnɔɣɔ. Nɑ pɑ́ hoti pɑ ɩsɛntɔɔ kɛ ɑtɛ, nɑ Ɩsɔ teu nɑ pɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ɩlɛnɑ Tɑcɑɑ tɔ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Kpɑɣɑ nyɑ́ kpɑ́tʋ́ɣʋ́, nɑ nyɑnɑ Alɔŋ ɩ́ koti sɑmɑɑ. Ɩlɛnɑ n yɔɣɔtǝnɑ kʋkpɑmʋɣʋ kʋnɛɣɛ pɑ ɩsɛntɑɑ, nɑ lʋm lɩɩ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ kɑlǝkǝŋ pɑ́ nyɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Ntɛnɑ Moisi polo nɑ ɩ́ kpɑɣɑ ɩ kpɑ́tʋ́ɣʋ́ ɩsɩɩ Tɑcɑɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Nɑ ɩ́ nɑ Alɔŋ pɑ́ koti sɑmɑɑ kɛ kʋkpɑmʋɣʋ ŋku Ɩsɔ hʋlɑɑ tɔ kʋ kiŋ, nɑ pɑ́ tɔ sɩ: Yǝlɑɑ tɔɔ kʋllɑɑ mɛ, ɩ́ tʋ ŋkpɑŋŋ. Tɩɩ pǝsɩ nɑ tǝ́ lǝsɩ kʋkpɑmʋɣʋ tɑɑ kɛ́ lʋm nɑ? ");
INSERT INTO dop_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Ɩlɛnɑ Moisi kʋsɩ kpɑ́tʋ́ɣʋ́ nɑ ɩ́ mɑ kʋkpɑmʋɣʋ kɛ tɔm nɑɑlɛ nɑ lʋm kpe sɔsɔm. Nɑ pɑ nɑ pɑ kɑlǝkǝŋ pɑ́ nyɔɔ nɑ pɑ́ nyǝɣǝsɩ. ");
INSERT INTO dop_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Tǝnɑɣɑlɛ Tɑcɑɑ kɑlǝnɑ Moisi nɑ Alɔŋ sɩ: Timpi ɩ́ tɑ́ tɛ-m nɑ mǝ tɑɑ, nɑ ɩ́ fɑɣɑsɩ-m nɑ mɑ mpɑɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ tɔ, ɩ kɑɑ sʋsɩ sɑmɑɑ ɩnɛɣɛ tɛtʋ nti mɑ hɑɑ-mɛ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Yɑɑsi ɩnɛ ɩ kɔnnɑ ntɛɣɛ Melipɑ lʋm tɔm. Yoou kɛ pɑ yɑɑ mpʋ nɑ pɑ tɛ tɑɑ. Mpi tɔ, Ɩsɛɣɛlɩ nyǝ́mɑ kɑ pɛɛkɑ Tɑcɑɑ nɑ yoou kɛ́. Ɩlɛnɑ ɩ́ fɑɣɑsɩ ɩ tɩ nɑ ɩ mpɑɑ kɛ pɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Ḿpʋ́ɣʋ́ Moisi kʋsɑ tillɑɑ kɛ Kɑtɛɛsɩ, nɑ ɩ́ tili-wɛɣɛ Ɩtɔm wulɑʋ kiŋ. Sɩ pɑ́ heeli-ɩ sɩ: N nyǝmɑ́ wɑhɑlɑnɑɑ mpɑ nyɑ́ kɔɣɔpiyɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɑ́ tǝ tɔɣɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Tɑ cɔsɔnɑɑ kɑ polǝnɑ Icipiti nɑ pɑ́ leeli tǝnɑ. Nɑ pɛlɛ pɑ́ tʋ-wɛɣɛ wɑhɑlɑ. ");
INSERT INTO dop_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ɩlɛnɑ tǝ wiinɑ Tɑcɑɑ sɩ ɩ́ wɑɑsɩ-tʋ. Ɩlɛnɑ Ɩsɔ tili ɩsɔtɑɑ tillu nɑ ɩ́ lǝsɩ-tʋɣʋ tǝnɑ. Sɑŋɑ tǝ tɑlɑ nyɑ́ tɛtʋ toŋɑ tɔɔ kɛlɛ Kɑtɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ɩlɛ hɑ-tʋɣʋ mpɑɑʋ nɑ tǝ́ fɑɣɑnɑ nyɑ́ tɛtʋ tɑɑ. Tǝ kɑɑ hɛlɩ nyɑ́ hɑlǝm yɑɑ nyɑ́ lɛsɛŋnɑɑ tɑɑ. Pǝ́cɔ́ tǝ kɑɑ nyɔɔ nyɑ́ lɔkɔnɑɑ lʋm. Tɩɩ siɣisi hɑpǝlɛ kɛ ḿpʋ́ɣʋ́, hɑlǝnɑ tǝ́ tɛsɩ nyɑ́ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ntɛnɑ Ɩtɔm wulɑʋ sɩ: Ye ɩ́ sʋʋ mɑ tɛtʋ tɑɑ, mɑɑ lɩɩ mǝ yoonɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɑsɑɑ sɩ: Hɑɩ, hɑpǝlɛ kɛ tɩɩ tǝŋ. Ye tɑ́ yɑɑ tɑ́ kɑlǝkǝŋ luɣu wɛ lʋm, tɩɩ yɑ-wǝɣɩ. Mpɑɑʋ tike kɛ tǝ wiikinɑ-ŋ sɩ ń hɑ-tʋ nɑ tǝ́ fɑɣɑnɑ nyɑ́ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Amɑ Ɩtɔm wulɑʋ tɑ tisi. Hɑlǝnɑ yoolɑɑ tuutuumɑ lɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ, nɑ pɑ yoou wontu sɔsɔɔntʋ. ");
INSERT INTO dop_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ɩlɛnɑ Ɩtɔm nyǝmɑ kisinɑ Ɩsɛɣɛlɩ nyǝmɑ sɩ pɑ́ tɑɑ fɑɣɑnɑ pɑ tɛ. Ɩlɛnɑ pɛlɛ pɑ́ kɛɛnɑ hɔɣɔlʋɣʋ lɛŋkʋ. ");
INSERT INTO dop_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ kʋlɑ pɑ tǝnɑ nɑ pɑ́ polo Hoo pʋɣʋ luɣu, ");
INSERT INTO dop_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","kɛ Ɩtɔm tɛtʋ toŋɑ tɔɔ. Tǝnɑɣɑ Tɑcɑɑ heelɑ Alɔŋ nɑ ɩ neu sɩ: ");
INSERT INTO dop_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Alɔŋ nyɑ́ sǝm wʋsɑɑ. N kɑɑ tɑlɑ tɛtʋ nti mɑ hɑɑkɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔ tǝ tɑɑ. Mpi tɔ, n tɑ nɩɩnɑ-m Melipɑ lʋm cɔlɔ. ");
INSERT INTO dop_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Ɩlɛnɑ ɩ́ tɔ́ Moisi sɩ: Kpɑɣɑ Alɔŋ nɑ ɩ pǝyɑlʋ Ɩlɑsɑɑ nɑ ń kpɑɑnɑ-wɛɣɛ Hoo pʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","N kɑ́ wɔɣɔsɩ Alɔŋ kɔtʋɣʋ wontu nɑ ń suu-tǝɣɩ ɩ pǝyɑlʋ Ɩlɑsɑɑ. Tǝnɑɣɑ Alɔŋ kɑ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ḿpʋ́ɣʋ́ Moisi lɑpɑ ɩsɩɩ Tɑcɑɑ yɔɣɔtʋɣʋ tɔ. Ɩlɛnɑ pɑ́ tǝŋ tǝmɑɣɑ pɑ tooso nɑ pɑ́ kpɑ́ pʋɣʋ ŋkʋ kʋ tɔɔ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ɩlɛnɑ Moisi wɔɣɔsɩ Alɔŋ wontu, nɑ ɩ́ suu-tǝɣɩ ɩ pǝyɑlʋ. Ḿpʋ́ɣʋ́ Alɔŋ sǝpɑ, nɑ Moisi nɑ Ɩlɑsɑɑ pɑ́ mǝlɩ tiiu. ");
INSERT INTO dop_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ɩsɛɣɛlɩ nyǝ́mɑ nɩɩwɑ sɩ Alɔŋ sǝpɑ, ɩlɛnɑ pɑ́ cɑɣɑ ɩ lǝyɑɣɑ kɛ kʋyɛɛŋ hiu nɑ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ḿpʋ́ɣʋ́ Kɑnɑɑŋ nyǝ́mɑ ɑwulɑɑ tɑɑ lɛlʋ, wei ɩ wɛ Alɑtɩ kɛ ilim mpǝtǝŋ tɔɔ tɔ, ɩ nɩɩwɑ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔŋɑ kɔntɛ nɑ Atɑlim mpɑɑʋ. Ɩlɛnɑ pɑ́ tii pɑ tɔɔ nɑ pɑ́ kpɑ́ pɑ tɑɑ lɛlɑɑ kɛ sɑlǝkɑ nyǝmɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Ntɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩɩ Tɑcɑɑ kɛ nɔɔsɩ sɩ: Ye n tʋ-wɛɣɛ tɑ niŋ tɑɑ, tɩɩ kpiisi pɑ ɑcɑlɛɛ tǝnɑŋnɑŋ. ");
INSERT INTO dop_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ɩlɛnɑ Tɑcɑɑ mʋ pɑ kʋsǝlǝmʋtʋ, nɑ pɑ́ kpiisi pɑ ɑcɑlɛɛ ɑnɩ ɑ tǝnɑ. Ɩlɛnɑ pɑ́ hɑ hɔɣɔlʋɣʋ ŋkʋɣʋ hǝtɛ sɩ Hoomɑ. Ncɑɑlɛ kɛ pɑ yɑɑ mpʋ nɑ pɑ tɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ kʋlɑ Hoo pʋɣʋ, nɑ pɑ́ kpɑɣɑnɑ sǝsǝncɑɑsɩ teŋku hɔɣɔlʋɣʋ mpɑɑʋ sɩ pɑ cɔlǝɣɩ Ɩtɔm tɛtʋ. Amɑ pɑ kpisɑ kɑntǝlʋɣʋ kɛ mpɑɑʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ɩlɛnɑ pɑ́ niki Ɩsɔ nɑ Moisi kɛ kʋntǝnɑʋ sɩ pepe tɔɔ kɛ́ pɛlɛ pɑ lǝsɑ-wɛɣɛ Icipiti tɑɑ sɩ, pɑ́ sɩ wʋlɑɣɑ tɛtʋ tɑɑ? Tɔɣɔnɑɣɑ yɑɑ lʋm fɛɩ, pǝyele wɑhɑlɑ kʋtɔɣɔʋ Mɑnnɑ nɑ́ lɩɩ-wɛɣɛ sɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ḿpʋ́ɣʋ́ Tɑcɑɑ tʋwɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ tʋmɑɑ ɑsɑɣɑɑ, nɑ pǝ́ nyɑsɑ pɑ pɑɣɑlɛ nɑ pɑ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Tǝnɑɣɑlɛ yǝlɑɑ lɛlɑɑ polɑɑ nɑ pɑ́ tɔ Moisi sɩ: Tǝ pǝntǝnɑ nyɑnɑ Tɑcɑɑ kɛ timpi tǝ kʋntǝnɑ-mɛ tɔ. Mpʋ tɔ, wiinɑ-ɩ nɑ ɩ́ hɑtǝlǝnɑ-tʋɣʋ tʋmɑɑ mpɛ. Ɩlɛnɑ Moisi nɑɑ sʋʋ-wɛɣɛ sǝlǝmǝnɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ntɛnɑ Tɑcɑɑ sɩ: Ɩ́ lu tʋm lɛɛsʋɣʋ kɛ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ, nɑ ɩ́ siki kpɑ́tʋ́ɣʋ́ kʋtɑɣɑlʋɣʋ nyʋɣʋ tɑɑ. Ye pǝ nyɑsɑ wei nɑ ɩ́ kʋsɩ ɩsɛ nɑ ɩ́ nyǝnɩ-kʋ, pɩɩ wɑɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ḿpʋ́ɣʋ́ Moisi lɑpɑ ɩsɩɩ Tɑcɑɑ yɔɣɔtʋɣʋ tɔ. Nɑ pǝ́ nyɑsɑ wei nɑ ɩ́ nyǝnɑ-kʋ pǝ wɑɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tʋ mpɑɑʋ hɑlǝnɑ Opoti. ");
INSERT INTO dop_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Pɑ kʋlɑ tǝnɑ, ɩlɛnɑ pɑ́ polo Yɛ-Apɑlim kɛ Mowɑpʋ ilim tǝlɩɩlɛ tɔɔ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Pɑ lɩɩ tǝnɑɣɑ nɑ pɑ́ polo Selɛtɩ lɔɔʋ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Pɑ kʋlɑ tǝnɑɣɑ nɑ pɑ́ polo Alǝnɔŋ pɔɣɔ ŋkɑ kɑ nyʋɣʋ wɛ Amoni nyǝ́mɑ tɛ, nɑ kɑ́ fɑkɩ wʋlɑɣɑ tɛtʋ hɔɣɔlʋɣʋ, nɑ pǝ́cɔ́ kɑ́ tɑkɩ Mowɑpʋ nyǝ́mɑ nɑ Amolii nyǝ́mɑ pɑ toŋɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Pǝ tɔɔ kɛ́ pɑ yɔɣɔtɑ Tɑcɑɑ yoou tɑkǝlɑɣɑ tɑɑ sɩ: Fɑhɛpɩ kɛ Sufɑ tɛtʋ tɑɑ, nɑ Alǝnɔŋ lɔɔŋ ");
INSERT INTO dop_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","nɑ lɔɔŋ wei ɩ wɛ Alǝnɔŋ hɔɣɔlʋɣʋ tɔɔ kɛ́ Mowɑpʋ toŋɑ tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Pɑ lɩɩ tǝnɑɣɑ ɩlɛnɑ pɑ́ polo Lɔkɔ cɔlɔɣɔ timpi Tɑcɑɑ tɔmɑ Moisi sɩ: Kpeɣeli sɑmɑɑ, nɑ mɑ́ hɑ-wɛɣɛ lʋm tɔ. ");
INSERT INTO dop_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Wɑɑtʋ ɩnǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ mɑpɑ kɑwǝyɑɣɑ sɩ: Lɔkɔ lʋm ɩ́ lɩɩnɑ kɑwilitɑsɩ. ");
INSERT INTO dop_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Awulɑɑ nɑ kɑsɑɣɑmpiyɑ hulinɑ-ɩ nɑ pɑ kɑwulɑɣɑ kpɑtǝŋ. Pɑ lɩɩ wʋlɑɣɑ tɛtʋ tɑɑ, ɩlɛnɑ pɑ́ tɑlɑ Mɑtɑnɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Pɑ lɩɩ tǝnɑ nɑ pɑ́ polo Nɑhɑliyɛlɩ, tǝnɑ wɑɑlɩ kɛ́ Pɑmɔtɩ. ");
INSERT INTO dop_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Pɑ lɩɩ tǝnɑ, ɩlɛnɑ pɑ́ polo Mowɑpʋ tɛtʋ tɛtɛkǝlɛ kɛ Pisikɑ pʋɣʋ nyʋɣʋ tɑɑ nɑ wʋlɑɣɑ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tilɑɑ nɑ pɑ́ heeli Amolii nyǝ́mɑ wulɑʋ Sihoŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Yele nɑ tǝ fɑɣɑnɑ nyɑ́ tɛtʋ tɑɑ. Hɑpǝlɛ kɛ tɩɩ siɣisi, hɑlǝnɑ tǝ́ tɛsɩ nyɑ́ tɛtʋ. Tǝ kɑɑ hɛlɩ hɑlǝm yɑɑ lɛsɛŋnɑɑ tɑɑ, yɑɑ tǝ́ nyɔɔ lʋm. ");
INSERT INTO dop_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Amɑ Sihoŋ tɑ tisi. Ḿpʋ́ɣʋ́ ɩ́ kuu ɩ yoolɑɑ tǝnɑ, nɑ ɩ́ kɑtɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Yɑhɑsɩ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ yoonɑ-ɩ. Nɑ pɑ́ lɛɛkɩ ɩ tɛtʋ tǝnɑɣɑ pǝ kpɑɣɑʋ Alǝnɔŋ nɑ pǝtɛɛ tɔɔ, nɑ Yɑpɔkɩ nɑ ɩsɔtɑɑ tɔɔ, kɛ́ Amoni nyǝ́mɑ toŋɑ koluŋɑ nɑ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Nɑ pɑ́ lɛɛkɩ Hɛsǝpɔŋ ɩcɑtɛ, nɑ pǝ cɔlɔ nyǝnɑ sǝkpenɑ nɑ pɑ́ cɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hɛsǝpɔŋ tǝnɑɣɑ Amolii nyǝ́mɑ wulɑʋ Sihoŋ kɑ wɛɛ. Ɩ kɑ yoonɑ Mowɑpʋ wulɑʋ kʋpǝŋ kɛ́, nɑ ɩ́ lɛɛkɩ ɩ tɛtʋ tǝnɑ. Hɑlǝnɑ pǝ yoosinɑ Alǝnɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Hɑlɩ yonyoolɑɑ tʋ-tɛ nɑ yontu sɩ: Ɩ́ kɔɔ Hɛsǝpɔŋ nɑ ɩ́ ŋmɑ́ Sihoŋ ɩcɑtɛ nɑ tǝ koluŋɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Kɔkɔ yɑwɑ Hɛsǝpɔŋ. Kɑ tʋlɑ Sihoŋ ɩcɑtɛ tɑɑ. Kɑ nyɑɣɑ Aɑ kɛ Mowɑpʋ tɛtʋ tɑɑ. Kɑ kpɛnnɑ Alǝnɔŋ ɩsɔtɑɑ sɔsɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mowɑpʋ, nyɑ́ tɔm wɛ wɑɩyo. Tʋɣʋ Kemɔsɩ lɑɑlɑɑ mɛ, mǝ lepɑ. Mǝ pǝyɑlɑɑ sewɑ, nɑ Amolii wulɑʋ Sihoŋ nɑ́ɑ́ kpɑ mǝ ɑlɑɑ kɛ yomle. ");
INSERT INTO dop_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Tǝ tɔwɑ Amolii nyǝ́mɑ kɛ nyǝmɑ́. Tǝ wɑkǝlɑ Hɛsǝpɔŋ tɛtʋ tǝnɑ, hɑlǝnɑ Tipɔŋ. Hɑlǝnɑ pǝ́ polo Nofɑ nɑ Mɛtǝpɑ tɔ, tǝ kpiisɑ pɑ tǝnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɣɔ Amolii nyǝ́mɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Nɑ Moisi kʋsɩ feŋlɑɑ nɑ pɑ́ cɔɔ Yɑsɛɛ ɩcɑtɛ. Yoolɑɑ lɛɛkɑ-tɛ nɑ tǝ ɑcɑlɛɛ sǝkpenɑ. Pɑ tɔɣɔnɑ Amolii nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Pǝ wɑɑlɩ kɛ́ pɑ lɑɣɑsɑ mpɑɑʋ nɑ pɑ́ mǝŋnɑ Pɑsɑŋ tɔɔ. Ḿpʋ́ɣʋ́ tǝnɑ wulɑʋ Oki nɑ́ lǝsɑ ɩ yoolɑɑ tǝnɑ nɑ pɑ́ polo Ɩsɛɣɛlɩ nyǝ́mɑ yoonɑʋ kɛ Ɩtǝlei. ");
INSERT INTO dop_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Moisi sɩ: Tɑɑ nyɑnɑ-ɩ. Mɑɑ tʋ ɩ́ nɑ ɩ yoolɑɑ nɑ ɩ tɛtʋ tǝnɑɣɑ nyɑ́ niŋ tɑɑ, nɑ ń lɑnɑ-ɩ ɩsɩɩ n lɑpǝnɑ Amolii nyǝ́mɑ wulɑʋ Sihoŋ wei ɩ kɑ wɛ Hɛsǝpɔŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Nɑ Ɩsɛɣɛlɩ nyǝ́mɑ kʋ Oki nɑ ɩ pǝyɑlɑɑ, nɑ ɩ yoolɑɑ tǝnɑ. Ɩ tɑ yele pɑɑ kʋlʋm nɑ ɩ weesuɣu. Ɩlɛnɑ pɑ́ lɛɛkɩ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɛɛwɑ nɑ pɑ́ siki Yɑɑtɑnɩ kʋtɛsʋɣʋ tɔɔ kɛ́ Mowɑpʋ tɛtɛkǝlɛ tɑɑ kɛ́ Yeliko ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","4","Tǝnɑɣɑ Sipɔɔ pǝyɑlʋ Pɑlɑkɩ wei ɩ tɔkɑɣɑ kɑwulɑɣɑ kɛ Mowɑpʋ kɛ wɑɑtʋ ɩnɩ tɔ, ɩ nɩɩwɑ ɩsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɑpɑ Amolii nyǝ́mɑ tɔ. Ɩlɛnɑ sɔɣɔntʋ kpɑ ɩ́ nɑ ɩ sɑmɑɑ nɑ pɑ́ seliɣi sɩ, Ɩsɛɣɛlɩ nyǝ́mɑ kǝlɑ pɑɣɑlɛ. Mpʋɣʋlɛ Mowɑpʋ nyǝ́mɑ tɔmɑ Mɑtiyɑŋ nyǝ́mɑ kʋpɑɣɑlɑɑ sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ cɑɑ pǝ tǝnɑɣɑ kpiisuɣu kɛ́, nɑ pɑ́ cɔɔnɑ-mɛ, ɩsɩɩ nɑɑŋ kuntuɣu nyɩɩtʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ɩlɛnɑ wulɑʋ tili ɩ yǝlɑɑ kɛ Peyɔɔ pǝyɑlʋ Pɑlɑɑm wei ɩ kɑ wɛ Petɔɔ kɛ Ɩfǝlɑtɩ pɔɣɔ tɔɔ tɔ ɩ kiŋ sɩ, pɑ́ heeli-ɩ sɩ: Yǝlɑɑ nɑpǝlɩ pɑ lɩɩnɑ Icipiti nɑ pɑ́ kɔɔ nɑ pɑ́ wɑɑsɩ mɑ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Hɑɩ, kɔɔ nɑ ń tǝŋsɩ-wɛɣɛ mpusi. Pɑ kǝlɑ-m toŋ. Ntɑnyɩ n kɑ́ pǝsɩ nɑ ń tɔɣɔnɩ-wɛɣɛ mɑ tɛtʋ tɑɑ. Mpi tɔ, mɑ nyǝmɑ sɩ, ye n tǝŋsɑ yʋlʋ kɛ mpusi, yɑɑ n koolɑ-ɩ kʋpɑntʋ, pǝ lɑkɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ḿpʋ́ɣʋ́ Mowɑpʋ nɑ Mɑtiyɑŋ kʋpɑɣɑlɑɑ kpɛnnɑ mpi pɑɑ fɛlɩ pee nɑlʋ Pɑlɑɑm tɔ. Nɑ pɑ́ polo ɩ tɛ nɑ pɑ́ heeli-ɩ Pɑlɑkɩ kʋsǝlǝmʋtʋ. ");
INSERT INTO dop_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ntɛnɑ Pɑlɑɑm sɩ: Ɩ́ sʋʋ mɑ tɛ, nɑ kʋ femɑ, ɩlɛ mɑ tɛlǝsɩ-mɛɣɛ nti Tɑcɑɑ heelɑ-m tɔ. ");
INSERT INTO dop_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ɩlɛnɑ Tɑcɑɑ pɔɔsɩ-ɩ sɩ: Mʋʋlɑɑ mpɑ pɑ wɛnnɑ nyɑ́ tɛ? ");
INSERT INTO dop_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ntɛnɑ Pɑlɑɑm cɔ-ɩ sɩ: Mowɑpʋ wulɑʋ Pɑlɑkɩ tilinɑ yǝlɑɑ sɩ pɑ́ heeli-m sɩ ");
INSERT INTO dop_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","nɑpǝlɩ pɑ lɩɩnɑ Icipiti nɑ pɑ́ wɑtɩ-m. Ɩlɛ kɔɔ nɑ ń tǝŋsɩ-wɛɣɛ mpusi, nɑ mɑ pǝsɩ-wɛ nɑ mɑ́ tɔɣɔnɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mpʋɣʋlɛ Ɩsɔ tɔmɑ Pɑlɑɑm sɩ: Tɑɑ tǝŋ-wɛ sɩ n tǝŋsǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ mpusi yoo. Mpi tɔ, mɑ tɛmɑ-wɛɣɛ kʋpɑntʋ kooluɣu. ");
INSERT INTO dop_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Tɛʋ femɑ ɩlɛnɑ Pɑlɑɑm tɔ Pɑlɑkɩ tillɑɑ sɩ: Ɩ́ kpe mǝ tɛ. Tɑcɑɑ kisɑɑ sɩ mɑ́ tɑɑ tǝŋ-mɛ. ");
INSERT INTO dop_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ɩlɛnɑ Mowɑpʋ kʋpɑɣɑlɑɑ mpɛ pɑ́ mǝlɩ nɑ pɑ́ heeli Pɑlɑkɩ sɩ: Pɑlɑɑm kisɑ-tʋɣʋ tǝŋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ḿpʋ́ɣʋ́ Pɑlɑkɩ kʋsɑ tillɑɑ kʋfɑmɑ nɑ pɑ tɑɑ kɛ́ ɩ wɑɑlɩ nyǝ́mɑ. Pɛlɛ pɑ kǝlɑ kɑncɑɑlɑɣɑ nyǝ́mɑ kɛ pɑɣɑlɛ nɑ sɔsɔɔntʋ. ");
INSERT INTO dop_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Nɑ pɑ́ polo pɑ heeli Pɑlɑɑm sɩ wulɑʋ tɔmɑ sɩ: Mɑ kpɑ nyɑ́ yule. Pɑɑ pǝ cɑɑlɑ-ŋ ɩsǝnɑ, polo nɑ nyɑnɑ-ɩ ɩ́ nɑ́. ");
INSERT INTO dop_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Pǝyele ye n tǝŋsɑ mpɛ ɩnǝɣɩ mpusi, mɑɑ kʋsɩ nyɑ́ nyʋɣʋ nɑ mɑ́ hɑ-ŋ pǝ tǝnɑ mpi n sɔɔlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ntɛnɑ Pɑlɑɑm cɔ tillɑɑ mpɛ sɩ: Pɑɑ ɩ kɑ́ hɑ-m ɩ liɣitee nɑ pǝ wʋlɑnɑɑ tǝnɑ, pǝ fɛɩ sɩ mɑ́ lɩɩ hǝm, nɑ mɑ́ pǝntǝnɑ mɑ Ɩsɔ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ɩlɛ pɑɑ nɑ mpʋ, ɩ́ sʋʋ cǝnɛɣɛ ɑhoo ɑnɛ nɑ mɑ́ nɑ́ nti Ɩsɔ kɑ́ tɑsɑ-m heeluɣu tɔ. ");
INSERT INTO dop_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Pɑlɑɑm kɛ ɑhoo tɑɑ sɩ: Ntɔŋ nyɑ́ wɑɑlɩ kɛ́ yǝlɑɑ mpɛ pɑ kɔmɑ? Tǝŋ-wɛ, ɩlɛ nti mɑɑ hʋlɩ-ŋ tɔ, tǝ tike kɛ n kɑ́ lɑ. ");
INSERT INTO dop_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Tɛʋ femɑ tɑnɑŋ, ɩlɛnɑ Pɑlɑɑm kpɛɛlɩ ɩ kpɑŋɑɣɑ nɑ ɩ́ tǝŋ Mowɑpʋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Tɛʋ femɑ tɑnɑŋ, ɩlɛnɑ Pɑlɑɑm kpɛɛlɩ ɩ kpɑŋɑɣɑ ɑlʋnyǝŋkɑ. Nɑ ɩ tǝmlɛ nyǝ́mɑ kɛ nɑɑlɛ, nɑ pɑ́ tǝŋ Mowɑpʋ nyǝ́mɑ. Amɑ Tɑcɑɑ mʋ pɑ́ɑ́nɑ́ nɑ ɩ tɛɛʋ mpɩ. Ɩlɛnɑ ɩsɔtɑɑ tillu tɑŋɩ-ɩ mpɑɑʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kpɑŋɑɣɑ nɑwɑ ɩsɔtɑɑ tillu kɛ mpɑɑʋ hɛkʋ tɑɑ nɑ ɩ́ kpɛɛwɑ ɩ lɑɣɑtɛ nɑ ɩ́ tɔkɑ ɩ niŋ tɑɑ, ɩlɛnɑ kɑ́ hɛlɩ. Nɑ Pɑlɑɑm mɑ-kɛ nɑ ɩ́ mǝlǝnɑ mpɑɑʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ḿpʋ́ɣʋ́ ɩsɔtɑɑ tillu tuusɑ lɔlɔ, nɑ ɩ́ sǝŋ mpɑɑʋ tɑɑ kɛ́ lɛsɛŋ tɑwɑ koloosi hɛkʋ. ");
INSERT INTO dop_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kpɑŋɑɣɑ nɑ-ɩ ɩlɛnɑ kɑ́ tiili kɑ tɩ nɑ koluŋɑ nɑ pǝ́ kʋ́ Pɑlɑɑm nɔɔhǝlɛ. Ɩlɛnɑ ɩ́ sʋʋ-kɛɣɛ mɑpʋ. ");
INSERT INTO dop_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ḿpʋ́ɣʋ́ ɩsɔtɑɑ tillu tɑsɑ pote nɑ ɩ́ sǝŋ timpi koloosi kpɩɩlɑ teu nɑ pǝ́ fɛɩ hɛlʋɣʋ nɑ ntɔɣɔŋ yɑɑ mpǝtǝŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kpɑŋɑɣɑ nɑ-ɩ, ɩlɛnɑ kɑ́ hǝntɩ. Tǝnɑɣɑ pɑ́ɑ́nɑ́ kpɑ Pɑlɑɑm nɑ ɩ́ hɔɔkɩ-kɛɣɛ kpɑ́tʋ́ɣʋ́. ");
INSERT INTO dop_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Mpʋɣʋlɛ Tɑcɑɑ kulɑ kpɑŋɑɣɑ nɔɣɔ nɑ kɑ́ tɔ́ Pɑlɑɑm sɩ: Pepeɣe mɑ lɑpɑ-ŋ nɑ ń mɑ-m hɑlɩ tɔm tooso tǝnɑ? ");
INSERT INTO dop_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ntɛnɑ Pɑlɑɑm cɔ sɩ: N nyǝnɑ-m yem kɛ́ te. Ye mɑɑ tɔkɑ lɑɣɑtɛ ɩsǝntɔ mɑɑ tɛmɑ-ŋ kʋɣʋ kɛ kpɑkpɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Kɛlɛnɑ kpɑŋɑɣɑ sɩ: Anɩ mɑ kɛ́ nyɑ́ kpɑŋɑɣɑ kɛ́, nɑ ń cɑkɩ-m tɑm. Too tɔ, mɑ tɛmɑ-ŋ ḿpʋ́ɣʋ́ lɑpʋ nɑ? Pɑɑlɑm sɩ: Aɑɩ yoo. ");
INSERT INTO dop_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ḿpʋ́ɣʋ́ Tɑcɑɑ kulɑ Pɑlɑɑm ɩsɛ nɑ ɩ́ nɑ́ ɩsɔtɑɑ tillu sǝŋɑ mpɑɑʋ hɛkʋ tɑɑ, nɑ ɩ lɑɣɑtɛ kɛ ɩ niŋ tɑɑ. Tǝnɑɣɑlɛ ɩ hotɑ ɩ lotu tɔɔ kɛ́ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ntɛnɑ ɩsɔtɑɑ tillu pɔɔsɩ-ɩ sɩ: N mɑpɑ nyɑ́ kpɑŋɑɣɑ kɛ tɔm tooso suwe? Mɑ kɔmɑɣɑ sɩ mɑ kɑkɩ-ŋ mpɑɑʋ. Mpi tɔ, mɑ nyǝmɑ́ sɩ n puki tǝlete kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Amɑ nyɑ́ kpɑŋɑɣɑ nɑ-m nɑ kɑ́ hɛlɩ-m tɔm tooso. Ye pǝ tɑɣɑ mpʋ mɑɑ kʋ-ŋ nɑ mɑ yele-kɛ nɑ kɑ weesuɣu. ");
INSERT INTO dop_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ḿpʋ́ɣʋ́ Pɑlɑɑm tɔmɑ ɩsɔtɑɑ tillu sɩ: Mɑ tɑɑ nyɩ sɩ n tɑŋɑ-m mpɑɑʋ tɑɑ sɩ mɑ́ tɑɑ polo. Mɑ tɔm sǝpɑ. Ye nyɑ́ lɑŋlɛ tɑ hɛɛnɑ mɑ pote ńtɛ́ mɑ mǝlǝɣɩ nɔɔnɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ɩlɛnɑ ɩsɔtɑɑ tillu sɩ: Tǝŋ-wɛ. Amɑ nti mɑ heeliɣi-ŋ tɔ, tǝ tike kɛ ń kɑ́ yɔɣɔtɩ. Ntɛnɑ Pɑlɑɑm tǝŋ tillɑɑ mpɛ. ");
INSERT INTO dop_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Wɑɑtʋ wei Pɑlɑkɩ nɩɩwɑ Pɑlɑɑm kɔntɛ ɩlɛnɑ ɩ́ polo ɩ sǝŋʋɣʋ kɛ Mowɑpʋ ɩcɑtɛ nte tǝ wɛ tɛtʋ toŋɑ kɛ Alǝnɔŋ lɔɔʋ nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Nɑ Pɑlɑkɩ pɔɔsɩ-ɩ sɩ: Pepe tɔɔ kɛ́ n tɑ kɔɔ kpɑkpɑɑ kɛ wɑɑtʋ wei mɑ tilɑ tɔm kɑncɑɑlɑɣɑ nyǝm tɔ? Yɑɑ n hʋʋkɩ sɩ mɑ kpisiɣi nyɑ́ nyʋɣʋ kʋsʋɣʋ? ");
INSERT INTO dop_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ḿpʋ́ɣʋ́ Pɑlɑɑm cɔwɑ sɩ: Tɔʋ pǝnɛntɛ mɑ kɔmɑ yɑɑ. Amɑ mɑɑ lɑkɩ mɑ luɣu nyǝntʋ kɛ́. Nti Ɩsɔ kɑ́ tʋ-m tɔ tǝ tike kɛ mɑɑ yɔɣɔtɩ. ");
INSERT INTO dop_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ḿpʋ́ɣʋ́ pɑ nɑɑlɛ pɑ polɑ Kiliyɑtɩ-Husoti. ");
INSERT INTO dop_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Nɑ Pɑlɑkɩ lɑɑ nɑɑŋ nɑ heeŋ nɑ ɩ́ hɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ Pɑlɑɑm. ");
INSERT INTO dop_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Tɛʋ femɑ ɩlɛnɑ Pɑlɑkɩ nɑ Pɑlɑɑm pɑ́ kpɑ Pɑmɔtɩ-Pɑɑlɩ timpi pǝ loosiɣi ɩsɛɣɛlɩ tǝsikile hɔɣɔlʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ḿpʋ́ɣʋ́ Pɑlɑɑm tɔmɑ Pɑlɑkɩ sɩ: Nmɑ-m tǝfɛɛnlɛ kɛ tɔm nɑɑtosompɔɣɔlɑɣɑ. Nɑ ń cɛlɛ-m lɑtǝcɛnɑɑ nɑ ɩwɑɑŋ kɛ nɑɑtosompɔɣɔlɑɣɑ mpɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Ɩlɛnɑ Pɑlɑkɩ lɑ mpʋ, nɑ pɑ nɑɑlɛ pɑ́ lɑɑ lɑtǝcɛ nɑ ɩwɑɑʋ kɛ pɑɑ lonte nte tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Nɑ Pɑlɑɑm tɔ Pɑlɑkɩ sɩ: Sǝŋ tǝfɛɛnlɛ cǝnɛ nɑ mɑ́ hɑtǝlɩ. Ntɑnyɩ Tɑcɑɑ kɑ́ lɩɩ mɑ tɔɔ nɑ ɩ́ heeli-m nɑtǝlɩ nɑ mɑ tɛlǝsɩ-ŋ. Ɩlɛnɑ ɩ́ kpɑ tontoŋlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Tǝnɑɣɑ Tɑcɑɑ lɩɩ ɩ tɔɔ, nɑ Pɑlɑɑm tɔ sɩ: Mɑ ŋmɑwɑ tǝfɛɛnlɛ kɛ tɔm nɑɑtosompɔɣɔlɑɣɑ, nɑ mɑ́ lɑɑ lɑtǝcɛ nɑ ɩwɑɑʋ kɛ pɑɑ tǝfɛɛnlɛ nte tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ɩlɛnɑ Tɑcɑɑ hʋlɩ Pɑlɑɑm kɛ tɔm nti ɩ kɑ yɔɣɔtɩ tɔ. Nɑ ɩ́ tɔmɩ-ɩ sɩ: Mǝlɩ Pɑlɑkɩ kiŋ. ");
INSERT INTO dop_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ḿpʋ́ɣʋ́ ɩ mǝlɑ Pɑlɑkɩ nɑ ɩ wɑɑlɩ nyǝ́mɑ pɑ cɔlɔ nɑ pɑ́ sǝŋ tǝfɛɛnlɛ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Kɑwǝyɑɣɑ ŋkɑ Pɑlɑɑm mɑpɑ tɔɣɔlɔ: Mowɑpʋ wulɑʋ Pɑlɑkɩ yɑɑnɑ-m ilim tǝlɩɩlɛ pɔɔŋ tɑɑ kɛ Silii, sɩ mɑ́ nyɑɑsɩ Ɩsɛɣɛlɩ nyǝ́mɑ. Nɑ mɑ́ tǝŋsɩ Yɑkɔpʋ lʋlʋɣʋ nyǝ́mɑ kɛ mpusi. ");
INSERT INTO dop_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ɩlɛ ɩsǝnɑɣɑ mɑɑ tǝŋsɩ mpusi kɛ wei Tɑcɑɑ tɑ tǝŋsɩ mpusi tɔ? Yɑɑ ɩsǝnɑɣɑ mɑɑ nyɑɑsɩ yǝlɑɑ mpɑ ɩ tɑ nyɑɑsɩ tɔ? ");
INSERT INTO dop_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Pɔɔŋ tɔɔ kɛ́ mɑ wɛɛ, nɑ mɑ́ loosiɣi yǝlɑɑ mpɛ. Pulɑsɩ tɔɔ kɛ́ mɑ wɛɛ nɑ mɑ́ nyǝnǝɣɩ-wɛ. Pɑ fɑɣɑnɑ piitimnɑɑ lɛmpɑ kɛ, nɑ pɑ tǝcɑɣɑlɛ wɛnɑ tǝ mpɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Aweɣelɛ Ɩsɛɣɛlɩ sɑmɑɑ kɑllʋ? Yɑɑ ɩ cɛkǝnɑ ɩ lʋlʋɣʋ nyǝ́mɑ nyʋɣʋ? Mɑ sɔɔlɑ mɑ́ nɑ siɣisilɑɑ mpɛ tǝ́ kpɛntɩ sǝm kɛ́, nɑ pǝ́ lɑ-m ɩsɩɩ mpɛ. ");
INSERT INTO dop_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Mpʋɣʋlɛ Pɑlɑkɩ pɔɔsɑ Pɑlɑɑm nɑ piti sɩ: Wetiɣilɛ n lɑpɑ-m mpʋ? Mɑ kɔnɑ-ŋ kɛ́ sɩ ń tǝŋsɩ mɑ kolontunɑɑ kɛ mpusi ɩlɛnɑ nyɑɑ mǝlɩ nɑ ń kooliɣi-wɛɣɛ kʋpɑntʋ nɑ? ");
INSERT INTO dop_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ntɛnɑ Pɑlɑɑm cɔ sɩ: Tǝlɑsɩ kɛ́ sɩ mɑ yɔɣɔtɩ nti Tɑcɑɑ tʋ mɑ nɔɣɔ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Mpʋɣʋlɛ Pɑlɑkɩ tɔmɑ Pɑlɑɑm sɩ: Kɔɔ nɑ tǝ́ lɑɣɑsɩ timpi n kɑ́ nɑ́ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tɔ. Pǝ tɑɣɑ pʋlʋ, pǝcɔ tike kɛ n nɑɑkɩ. Tǝnɑɣɑ n kɑ́ tǝŋsɩ-m-wɛɣɛ mpusi. ");
INSERT INTO dop_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ɩlɛnɑ ɩ́ ponɑ Pɑlɑɑm kɛ Pisikɑ pʋɣʋ luɣu tǝfeŋle, nɑ ɩ́ ŋmɑ tǝfɛɛnlɛnɑɑ tɔtɔɣɔ nɑɑtosompɔɣɔlɑɣɑ. Nɑ ɩ́ lɑɑ lɑtǝcɛ nɑ ɩwɑɑʋ kɛ pɑɑ tǝfɛɛnlɛ nte tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Nɑ ɩ́ tɔ́ Pɑlɑkɩ sɩ: Sǝŋ tǝnɑ nɑ mɑ́ polo nɑ mɑ́ nɑ Ɩsɔ tǝ́ suli. ");
INSERT INTO dop_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ɩlɛnɑ Tɑcɑɑ tʋ Pɑlɑɑm nɔɣɔ tɑɑ kɛ́ tɔm sɩ ɩ́ mǝlɩ nɑ ɩ́ heeli Pɑlɑkɩ. ");
INSERT INTO dop_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Pɑlɑɑm mǝlɑ wulɑʋ nɑ ɩ wɑɑlɩ nyǝ́mɑ pɑ kiŋ, ɩlɛnɑ ɩ́lɛ́ ɩ pɔɔsɩ-ɩ sɩ: Wentiɣilɛ Tɑcɑɑ heelɑ-ŋ? ");
INSERT INTO dop_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ḿpʋ́ɣʋ́ Pɑlɑɑm kpɑɣɑ kɑwǝyɑɣɑ sɩ: Sipɔɔ pǝyɑlʋ Pɑlɑkɩ kʋlɩ nɑ n ke ŋkpɑŋŋ. ");
INSERT INTO dop_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ɩsɔ tɑ́ kɛ́ yʋlʋ sɩ ɩ looliɣi, yɑɑ ɩ́ lɑɣɑsɩ ɩ kʋsǝsɩɩtʋ. Nti ɩ sɩɩwɑ tɔɣɔ ɩ lɑkɩ tǝtetete. ");
INSERT INTO dop_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Tɑcɑɑ koolinɑ yǝlɑɑ mpɛɣɛ kʋpɑntʋ, nɑ mɑ́ɑ́ tɛɛsǝɣɩ, ");
INSERT INTO dop_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","mɑɑ pǝsǝɣɩ nɑ mɑ́ lɑɣɑsɩ pʋlʋ. Ɩ wɛ pɑ wɑɑlɩ kɛ́ ɩ tɑ nɑ pɑ ɩsɑɣɑtʋ, yɑɑ pɑ tɑsǝkǝlɛ. Ɩ kɛ́ pɑ wulɑʋ kɛ́ nɑ pɑ́ wilitiɣi-ɩ nɑ lɑŋhʋlʋmlɛ. ");
INSERT INTO dop_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ɩnɩ ɩ lǝsǝnɑ-wɛɣɛ Icipiti tɑɑ nɑ tomiŋ ɩsɩɩ tɑɑlɛ nɑʋ. ");
INSERT INTO dop_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Tɩɩtʋ nɑ pee pɔɔsʋɣʋ ɩɩ lɑkɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pʋlʋ. Pǝ tɔɔ kɛ́ pɑ nyǝnǝɣɩ Ɩsɛɣɛlɩ nɑ pɑ tɔŋ sɩ: Ɩɩ nɑɑkɩ mpi Ɩsɔ lɑpɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Yǝlɑɑ mpɛ pɑ wɛ toŋ kɛ́ ɩsɩɩ tɔɣɔlɑɣɑ ŋkɑ kɑ cǝlǝɣɩ kɑ tɔɣɔnɑɣɑ, nɑ kɑ́ nyɔɔkɩ kɑ kʋkʋkʋm cɑlǝm, nɑ pǝ́cɔ́ kɑ́ hǝntǝɣɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ntɛnɑ Pɑlɑkɩ tɔ Pɑlɑɑm sɩ: Ye n kɑɑ tǝŋsɩ-wɛɣɛ mpusi, ɩlɛ tɑɑ kooli-wɛɣɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Kɛlɛnɑ Pɑlɑɑm sɩ: Anɩ mɑ tɛmɑ-ŋ heeluɣu sɩ nti Tɑcɑɑ tʋɣʋ mɑ nɔɣɔ tɑɑ tɔɣɔ mɑ yɔɣɔtǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ḿpʋ́ɣʋ́ Pɑlɑkɩ yɑɑ pɑlɑɑm sɩ: Tǝ́ lɑɣɑsɩ lonte lɛntɛ. Ntɑnyɩ Ɩsɔ kɑ́ tisi nɑ ń tǝŋsɩ-m yǝlɑɑ mpɛɣɛ mpusi. ");
INSERT INTO dop_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ɩlɛnɑ ɩ́ kpɑɑnɑ-ɩ Peyɔɔ pʋɣʋ tɔɔ timpi yǝlɑɑ nɑɑkɩ wʋlɑɣɑ tɛtʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Nɑ Pɑlɑɑm tɔ Pɑlɑkɩ sɩ: Nmɑ-m tǝfɛɛnlɛnɑɑ kɛ nɑɑtosompɔɣɔlɑɣɑ, nɑ ń cɑɑ-m lɑtǝcɛnɑɑ kɛ nɑɑtosompɔɣɔlɑɣɑ nɑ heeŋ kɛ mpʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ɩlɛnɑ Pɑlɑkɩ lɑ mpʋ nɑ ɩ́ lɑɑ lɑtǝcɛ nɑ ɩwɑɑʋ kɛ pɑɑ tǝfɛɛnlɛ nte tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ḿpʋ́ɣʋ́ Pɑlɑɑm cɛkǝnɑɑ sɩ Tɑcɑɑ sɩɩwɑɣɑ sɩ ɩ kooliɣi Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kʋpɑntʋ. Ɩlɛ ɩ tɑ tɑsɑ pɛɛkʋɣʋ sɩ ɩ suliɣi Ɩsɔ ɩsɩɩ ɩ tɩɩ lɑkɩ tɔ. Ntɛnɑ ɩ kɛɛsɩ kpɑkpɑɑ nɑ wʋlɑɣɑ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ɩ kʋsɑ ɩsɛ nɑ ɩ́ nɑ́ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɑ tǝsikile, ɩlɛnɑ Ɩsɔ Feesuɣu tii ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Nɑ ɩ́ mɑ kɑwǝyɑɣɑ sɩ: Peyɔɔ pǝyɑlʋ Pɑlɑɑm mɑ́, mɑ kʋkpɑɑlǝtʋ ntɔ. Pǝ kulɑ mɑ ɩsɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Mɑ nɩɩkɩ Ɩsɔ kʋyɔɣɔtʋtʋ kɛ́, nɑ mɑ́ pɑɑsǝɣǝnɑ nti Tomɑ tǝnɑ tʋ hʋlǝɣɩ-m tɔ. Ye mɑ sɛɛkɩ-ɩ ɩ hʋlǝɣɩ-m ɩ tǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ɩsɛɣɛlɩ yǝlɑɑ Yɑkɔpʋ lʋlʋɣʋ nyǝ́mɑ mɛ, mǝ cokɑ tewɑɣɑ pǝ tɩɩ fɛɩ. ");
INSERT INTO dop_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Pǝ cɑɣɑ kɛ́ ɩsɩɩ lɔɔŋ wei ɩ kpeŋ tɔ, yɑɑ pɔɣɔ kʋtemiŋ tɔɔ hɑlǝm. Yɑɑ tɩɩŋ kʋpɑŋ wei Tɑcɑɑ tuuwɑ pɔɣɔ nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Pǝ cɑɣɑ ɩsɩɩ lʋm sukuɣu nɑ pǝ wɑtǝɣɩ tɩɩŋ tɛɛ tɔ. Pɑ wulɑʋ kɑ́ kǝlɩ Akɑkɩ nɑ pɑ kɑwulɑɣɑ tɛɛ toŋ. ");
INSERT INTO dop_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Ɩsɔ lǝsǝnɑ-wɛɣɛ Icipiti tɑɑ, nɑ tomiŋ ɩsɩɩ tɑɑlɛ nɑʋ. Nɑ pɑ́ yɔkǝɣɩ pɑ kolontunɑɑ mʋwɑ nɑ pɑ́ cʋtǝtǝɣɩ-wɛɣɛ nyǝmɑ́. ");
INSERT INTO dop_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Pɑ luŋiɣi kɛ́ ɩlɛnɑ pɑ hǝntɩ ɩsɩɩ tɔɣɔlɑsɩ. Awe pǝsǝɣɩ nɑ ɩ́ kʋsɩ-wɛ nɑ toŋ? Ɩsɛɣɛlɩ, pǝ́ kooli kʋpɑntʋ kɛ nyɑ́ kʋpɑntʋ koollu. Pǝ́ tǝŋsɩ mpusi kɛ nyɑ́ mpusi tǝŋsǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Tǝnɑɣɑlɛ pɑ́ɑ́nɑ́ kpɑ Pɑlɑkɩ nɑ ɩ́ kɑlǝɣɩ nɑ ɩ́ fiisiɣi niŋ nɑ ɩ́ tɔŋ sɩ: Mɑ kɔnɑ-ŋ kɛ́ sɩ ń tǝŋsɩ mɑ kolontunɑɑ kɛ mpusi. Tɔm tooso nyǝm ntɔ n kooliɣi-wɛɣɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Polo ń kpe. Mɑɑ sɩɩwɑ sɩ mɑɑ kʋsɩ nyɑ́ nyʋɣʋ kɛ́. Amɑ Tɑcɑɑ kisɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ḿpʋ́ɣʋ́ Pɑlɑɑm cɔwɑ Pɑlɑkɩ sɩ: Anɩ mɑɑ tɛmɑ nyɑ́ tillɑɑ kɛ heeluɣu sɩ, ");
INSERT INTO dop_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","pɑɑ n kɑ́ cɛlɛ-m nyɑ́ kɑwulɑɣɑ tɑɑ liɣitee nɑ wʋlɑ tǝnɑ, pǝ fɛɩ sɩ mɑ́ kpɛɛsǝnɑ Tɑcɑɑ. Nti tǝ tike ɩ́ kɑ́ tʋ mɑ nɔɣɔ tɑɑ tɔɣɔ mɑɑ yɔɣɔtɩ. ");
INSERT INTO dop_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Tɔʋ, nɔɔnɔɔ mɑɑ mǝlɩ mɑ yǝlɑɑ kiŋ. Ɩlɛ kɔɔ nɑ mɑ́ hʋlɩ-ŋ mpi Ɩsɛɣɛlɩ nyǝ́mɑ kɑ́ wɑkǝlɩ nyɑ́ yǝlɑɑ kɛ kʋyɑkʋ nɑkʋlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ntɛnɑ ɩ́ mɑ́ kɑwǝyɑɣɑ sɩ: Peyɔɔ pǝyɑlʋ Pɑlɑɑm mɑ́, mɑ kʋkpɑɑlǝtʋ ntɔ. Pǝ kulɑ mɑ ɩsɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Mɑ nɩɩkɩ Ɩsɔ nyɑ́ kʋyɔɣɔtʋtʋ kɛ́, nɑ mɑ́ pɑɑsǝɣǝnɑ nti n hʋlǝɣɩ-m tɔ. Ye mɑ sɛɛkɩ-ŋ n hʋlǝɣɩ-m nyɑ́ tǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Mɑ loosiɣi mpi pɩɩ tɛ nɑ pǝ́ lɑ́ tɔ, nɑ mɑ́ nyǝnǝɣɩ-wɩ. Ɩsɔtʋlʋŋɑ kɑ́ lɩɩ Yɑkɔpʋ lʋlʋɣʋ tɑɑ. Wulɑʋ kɑ lɩɩ Ɩsɛɣɛlɩ tɑɑ nɑ ɩ́ mɑ́ Mowɑpʋ nyǝ́mɑ lǝkpɑɣɑsɑɣɑ nɑ Sɛɛtɩ lʋlʋɣʋ nyǝ́mɑ nyɔɔŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ɩsɛɣɛlɩ nyǝ́mɑ kɑ́ lɛɛkɩ pɑ kolontunɑɑ Ɩtɔm nyǝ́mɑ tɛtʋ Seyii nɑ pɑ́ pǝsɩ ɑkɑnɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yɑkɔpʋ lʋlʋɣʋ nyǝ́mɑ kpilɑ pɑ kolontunɑɑ. Pɑ kpiisiɣi mpɑ pǝ kɑɑsɑɑ tɔɣɔ pɑ ɑcɑlɛɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ḿpʋ́ɣʋ́ Pɑlɑɑm nɑwɑ Amɑleke nyǝ́mɑ, nɑ ɩ́ tɔ sɩ: Amɑleke nyǝ́mɑ kɛ piitim sɔsɔɔm kɛ́. Amɑ ncɑɑlɛ tǝkpɑtɑɑ kɛ pɑɑ tɛɛsǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ɩ nɑwɑ Keni nyǝ́mɑ, ɩlɛnɑ ɩ tɔ sɩ: Pǝ cɑɣɑnɑ-mɛɣɛ mǝ tɛtʋ tɑɑ kɛ́ ɩsɩɩ Tɑntɛ pusuɣunɑ kʋkpɑmʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Pɑɑ nɑ mpʋ kɔkɔ kɑ́ niisinɑ mǝ tǝcɑɣɑlɛ, nɑ Asilii nyǝ́mɑ nɑ́ɑ́ kuu-mɛɣɛ yomle. ");
INSERT INTO dop_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ḿpʋ́ɣʋ́ Pɑlɑɑm tɑsɑɑ sɩ: Ye Ɩsɔ tʋ niŋ, ɑwe wɛɛnɑ weesuɣu? ");
INSERT INTO dop_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Sipili kʋteŋ kɛ Asilii ŋmɑkǝllɑɑ lɩɩkǝnɑ, nɑ pɑ́ wɑkǝlɩ-wɛ nɑ pǝ́ kpɛŋnɑ Hepɛɛ lʋlʋɣʋ nyǝ́mɑ. Amɑ pɛlɛ pɑ tɛɛsǝɣǝnɑ ncɑɑlɛ tɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Pɑlɑɑm tɛmɑ tɔmnɑɑ mpɛɣɛ yɔɣɔtʋɣʋ kɛ́, ɩlɛnɑ ɩ́ kpɑɣɑ mpɑɑʋ nɑ ɩ́ mǝlɩ ɩ tɛtʋ tɑɑ, nɑ Pɑlɑkɩ nɑ́ɑ́ mǝlɩ ɩ́lɛ́ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ cɑɣɑ Sitim nɑ pɑ́ nɑ Mowɑpʋ ɑlɑɑ pɑ́ sʋʋ yem yem lɑkɑsɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Nɑ pɛlɛ pɑ́ sʋsɩ-wɛɣɛ tɩɩŋ lɑɑʋ tɑɑ, nɑ hɑlɩ pɑ́ tɔkɩ pǝ tɔɣɔnɑɣɑ nɑ pɑ luŋiɣi ");
INSERT INTO dop_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","tʋɣʋ Pɑɑlɩ kɛ Peyɔɔ pʋɣʋ tɑɑ. Ɩlɛnɑ Tɑcɑɑ pɑ́ɑ́nɑ́ nɑ́ɑ́ huunɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ntɛnɑ Ɩsɔ tɔ Moisi sɩ: Koti Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ tǝnɑ, nɑ ń pusi tɑsǝkǝlɛ nyǝ́mɑ nɑ tɩɩŋ kɛ mɑ ɩsɛntɑɑ kɛ ilim tɑɑ, nɑ pǝ́cɔ́ mɑ́ kʋ́ mɑ pɑ́ɑ́nɑ́ kɛ pɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ḿpʋ́ɣʋ́ Moisi tɔmɑ Ɩsɛɣɛlɩ hʋʋlɑɑ sɩ: Pɑɑ wei ɩ́ kʋ́ Peyɔɔ pʋɣʋ tɑɑ tʋɣʋ Pɑɑlɩ luŋlɑɑ mpɛ. ");
INSERT INTO dop_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Wɑɑtʋ wei Moisi nɑ lɛlɑɑ pɑ kotɑ Ɩsɔ cokǝle nɔnɔɣɔ nɑ pɑ́ wiiki, ɩlɛ Ɩsɛɣɛlɩ tʋ nɔɣɔlʋ ɩ kɔnɑ Mɑtiyɑŋ ɑlʋ ńtɛ́ pɑ ɩsɛntɑɑ tǝnɑ, nɑ ɩ́ ponɑ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ḿpʋ́ɣʋ́ Ɩlɑsɑɑ pǝyɑlʋ kɔtʋlʋ Pɛŋhɑsɩ wei ɩ kɛ́ Alɔŋ sɑɑlɩ tɔ, ɩ kʋlɑ sɑmɑɑ tɑɑ tǝnɑ nɑ ɩ́ co ŋmɑntɑɑɣɑ, ");
INSERT INTO dop_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","nɑ ɩ́ tǝŋ ɑpɑlʋ nɑ ɑlʋ ɩnɩ pɑ wɑɑlǝɣɩ cokǝle tɑɑ, nɑ ɩ́ sɔ pɑ nɑɑlɛ pɑ lotu tɑɑ kɛ ŋmɑntɑɑɣɑ nɑ pɑ́ sɩ́. Ɩlɛnɑ yʋlʋkʋsʋkʋ kɛɛlɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ɩlɛ sǝtɑɑ tɛmɑ iyisi hiu nɑ liɣiti (24.000) kɛ yoosuɣu. ");
INSERT INTO dop_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mpʋɣʋlɛ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Ɩlɑsɑɑ pǝyɑlʋ kɔtʋlʋ Pɛŋhɑsɩ wei ɩ kɛ́ Alɔŋ sɑɑlɩ tɔ, ɩ kɛɛlɑ mɑ pɑ́ɑ́nɑ́ kɛ timpi ɩ sɛɛsɑ ɩsǝlɛ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ ɩsɩɩ mɑ́ tɔ. Pǝ tɔɔ kɛ́ mɑ tɑ kpiisi-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Mpʋ tɔ, heeli-ɩ sɩ, mɑ́ nɑ-ɩ tɩɩ pɛɛlɩ hɛɛsʋɣʋ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Nɑ kɑ́ wɛɛ ɩ́ nɑ ɩ piyɑ piyɑ pɑ tɔɔ, nɑ pɑ́ pǝsɩ kɔtǝlɑɑ kɛ tɑm. Mpi tɔ, ɩ sɛɛsɑ ɩsǝlɛ nɑ mɑ tǝmlɛ, nɑ ɩ́ hɩɩsɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ɩsɛɣɛlɩ tʋ wei nɑ ɩ ɑlʋ Mɑtiyɑŋ tʋ pɑ kʋwɑ mpʋ tɔ, ɩ kɑ kɛ́ Sɑlu pǝyɑlʋ Simili kɛ́. Simiyɔŋ kpekǝle tɑɑ nyʋɣʋ tʋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Nɑ pɑ́ yɑɑkɩ ɩ ɑlʋ sɩ Kosipi, nɑ ɑlʋ ɩnɩ ɩ cɑɑ sɩ Suuu. Ɩlɛ ɩ kɑ kɛ́ Mɑtiyɑŋ lʋlʋŋ pɑɣɑlɛ nyʋɣʋ tʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Tii Mɑtiyɑŋ nyǝ́mɑ tɔɔ, nɑ ń kpiisi-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Pɑ pǝsɑ mǝ kolontunɑɑ kɛ. Mpi tɔ, pɑ tʋsɑ-mɛ nɑ ɑcilɑɣɑtʋ kɛ Pɑɑlɩ, nɑ pɑ nyʋɣʋ tʋ lɛlʋ pɛɛlɔ Kosipi tɔm tɑɑ. Ɩnǝɣɩ pɑ kʋwɑ yʋlʋkʋsǝkʋ wɑɑtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Wɑɑtʋ wei yʋlʋkʋsǝkʋ ŋkʋ kʋ tɛɛwɑ, ɩlɛnɑ Tɑcɑɑ tɔ Alɔŋ pǝyɑlʋ kɔtʋlʋ Ɩlɑsɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Kɑlɑ Ɩsɛɣɛlɩ yǝlɑɑ nɑ pǝ́ kɛɛsǝnɑ pɑ lʋlʋŋ, kɛ pǝ kpɑɣɑʋ ɑpɑlɑɑ mpɑ pɑ tɑlɑ pɩɩsɩ hiu nɑ pɑ́ mʋnɑ yoou pote tɔ. ");
INSERT INTO dop_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ḿpʋ́ɣʋ́ Moisi nɑ Ɩlɑsɑɑ pɑ heelɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Mowɑpʋ tɛtɛkɑ tɑɑ kɛ́ Yɑɑtɑnɩ nɔɣɔ kɛ Yeliko ɩsɛntɑɑ ");
INSERT INTO dop_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","sɩ: Tɑcɑɑ tʋwɑ Moisi sɩ ɩ́ kɑlɑ yǝlɑɑ mpɑ pɑ tǝnɑ pɑ wɛnɑ pɩɩsɩ hiu nɑ wɑɑlɩ tɔ. Ɩsɛɣɛlɩ kpekɑ nnɑ ɑ lɩɩwɑ Icipiti tɑɑ tɔ ɑ hǝlɑ ntɔ: ");
INSERT INTO dop_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Yɑkɔpʋ pǝyɑlʋ kɑncɑɑlɑɣɑ nyǝŋ Lupɛŋ kpekǝle, nɑ ɩ́lɛ́ ɩ lʋlʋɣʋ nyǝ́mɑ ntɛ́ Hɑnɔkɩ nyǝ́mɑ nɑ Pulɑ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Nɑ Hɛsǝlɔŋ nyǝ́mɑ nɑ Kɑɑmi nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Lupɛŋ kpekǝle nyǝ́mɑ ntɛ́, nɑ pɑ tɑɑ kɛ́ ɑpɑlɑɑ iyisi nɩɩlɛ nɑ tooso nɑ nɑsǝtoso nɑ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ (43.730). ");
INSERT INTO dop_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pɑlu pǝyɑlʋ Ɩliyɑpɩ, ");
INSERT INTO dop_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","pǝyɑlɑɑ ntɛ́ Nemuwɛlɩ nɑ Tɑtɑŋ nɑ Apilɑm. Nɑ Tɑtɑŋ nɑ Apilɑm pɑɑ kɛnɑ nyʋɣʋ nyǝ́mɑ, kɛ sɑmɑɑ wei ɩ kʋlɑ Moisi nɑ Alɔŋ pɑ tɔɔ tɔ. Kolee wɑɑlɩ nyǝ́mɑ ntɛ́ mpɛ ɩnɩ. Wɑɑtʋ ɩnǝɣɩ pɛlɛ pɑ kʋlɑ Tɑcɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ḿpʋ́ɣʋ́ tɛtʋ hɑɑ nɔɣɔ nɑ tǝ́ li-wɛ nɑ tǝ́ kpɛnnɑ Kolee. Kɔkɔ nyɑɣɑ lɛlɑɑ nɑ pɑ ɩsɛ kɛ ŋmʋnʋɣʋ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (250). Mpʋ ɩnɩ pǝ hʋlɑ lɛlɑɑ mpɑ pǝ kɑɑsɑɑ tɔɣɔ lɔŋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Pɑɑ nɑ mpʋ Kolee pǝyɑlɑɑ tɑ sɩ. ");
INSERT INTO dop_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simiyɔŋ kpekǝle nyǝ́mɑ lʋlʋŋ hǝlɑ ntɔ: Nemuwɛlɩ nyǝ́mɑ, nɑ Yɑmɛŋ nyǝ́mɑ, nɑ Yɑkɛŋ nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","nɑ Selɑ nyǝ́mɑ, nɑ Sɑwuli nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Pɑ tɑɑ ɑpɑlɑɑ wɛ yǝlɑɑ iyisi hiu nɑ nɑɑlɛ nɑ ŋmʋnʋɣʋ (22.200). ");
INSERT INTO dop_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Kɑtɩ kpekǝle nyǝ́mɑ lʋlʋŋ hǝlɑ ntɔ: Sefoŋ nyǝ́mɑ nɑ Hɑki nyǝ́mɑ nɑ Suni nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","nɑ Osini nyǝ́mɑ nɑ Ɩli nyǝ́mɑ ");
INSERT INTO dop_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","nɑ Aloti nyǝ́mɑ nɑ Aleli nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Pɑ tɑɑ ɑpɑlɑɑ wɛ yǝlɑɑ iyisi nɩɩlɛ nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (40.500). ");
INSERT INTO dop_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","Yutɑ kpekǝle nyǝ́mɑ lʋlʋŋ ntɔ: Selɑ nyǝ́mɑ nɑ Pɛlɛsɩ nyǝ́mɑ nɑ Selɑɩ nyǝ́mɑ. Pɛlɛsɩ nyǝ́mɑ ntɛ́ nɑ Hɛsǝlɔŋ nyǝ́mɑ nɑ Hɑmuli nyǝ́mɑ. Yutɑ pǝyɑlɑɑ nɑɑlɛ Ɩlɩ nɑ Onɑŋ pɑɑ sǝpɑ Kɑnɑɑŋ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Pɑ tɑɑ ɑpɑlɑɑ wɛ iyisi nɩɩtoso nɑ nɑɑnʋwɑ nɑ nɑɑtoso nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (76500). ");
INSERT INTO dop_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ɩsɑkɑɑ kpekǝle nyǝ́mɑ lʋlʋŋ ntɔ: Tolɑ nyǝ́mɑ nɑ Pufɑ nyǝ́mɑ ");
INSERT INTO dop_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","nɑ Yepusi nyǝ́mɑ nɑ Similoŋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Nɑ pɑ tɑɑ ɑpɑlɑɑ kɛ iyisi nɩɩtoso nɑ liɣiti nɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (64300). ");
INSERT INTO dop_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sɑpulɔŋ kpekǝle lʋlʋŋ nyǝ́mɑ ntɔ: Selɛtɩ nyǝ́mɑ nɑ Ɩloŋ nyǝ́mɑ nɑ Yɑleyɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Nɑ pɛlɛ pɑ tɑɑ ɑpɑlɑɑ kɛ iyisi nɩɩtoso nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (60500). ");
INSERT INTO dop_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Mɑnɑsee nɑ Ɩfǝlɑyim pɑ kpekɑ nyǝ́mɑ ntɛ́ Yosɛɛfʋ lʋlʋŋ nyǝ́mɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Mɑnɑsee kpekǝle nyǝ́mɑ lʋlʋŋ ntɔ: Mɑkii nyǝ́mɑ nɑ ɩ́lɛ́ ɩ pǝyɑlʋ Kɑlɑɑtɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Kɑlɑɑtɩ lʋlʋŋ nyǝ́mɑ ntɛ́ nɑ Yesɛɛ nyǝ́mɑ nɑ Helɛkɩ nyǝ́mɑ ");
INSERT INTO dop_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","nɑ Asǝliyɛlɩ nyǝ́mɑ nɑ Sekem nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","nɑ Semitɑ nyǝ́mɑ, nɑ Hefɛɛ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hefɛɛ pǝyɑlʋ Selofɑtɩ nɑ́ lʋlɑ ɑlʋpiyɑ tike kɛ́. Mpɛɣɛlɛ Mɑlɑ nɑ Nowɑ nɑ Hokǝlɑ nɑ Milikɑ nɑ Tiisɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Nɑ pɑ tɑɑ ɑpɑlɑɑ kɛ iyisi nɩɩlɛ nɑ nɑɑnʋwɑ nɑ nɑɑlɛ nɑ nɑsǝtoso nɑ nɩɩnʋwɑ (52700). ");
INSERT INTO dop_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ɩfǝlɑyim kpekǝle lʋlʋŋ nyǝ́mɑ ntɔ: Sutelɑ nyǝ́mɑ nɑ Pekɛɛ nyǝ́mɑ nɑ Tɑhɑŋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutelɑ pǝyɑlʋ Ɩlɑŋ lʋlʋɣʋ nyǝ́mɑ ntɛ ɩlɑŋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Pɑ tɑɑ ɑpɑlɑɑ wɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ nɑɑlɛ nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (32500). Yosɛɛfʋ lʋlʋɣʋ nyǝ́mɑ ntɛ́ kpekɑ ɑnɩ ɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Pɛncɑmɛɛ kpekǝle lʋlʋŋ nyǝ́mɑ ntɔ: Pelɑ nyǝ́mɑ, nɑ Asepɛlɩ nyǝ́mɑ nɑ Ahilɑm nyǝ́mɑ ");
INSERT INTO dop_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","nɑ Sufɑm nyǝ́mɑ nɑ Hufɑm nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Pelɑ lʋlʋɣʋ nyǝ́mɑ ntɛ́ nɑ Aɑtɩ nyǝ́mɑ nɑ Nɑɑmɑŋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Pɑ tɑɑ ɑpɑlɑɑ wɛ iyisi nɩɩlɛ nɑ kɑkpɑsɩ nɑ nɑsǝtoso (45600). ");
INSERT INTO dop_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Tɑŋ kpekǝle lʋlʋɣʋ nyǝ́mɑ ntɛ́ Suhɑm nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Pɛlɛ pɑ tɑɑ ɑpɑlɑɑ wɛ iyisi nɩɩtoso nɑ liɣiti nɑ nɑsǝlɛ (64400). ");
INSERT INTO dop_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asɛɛ kpekǝle lʋlʋɣʋ nyǝ́mɑ ntɛ́: Ɩmǝnɑ nyǝ́mɑ nɑ Ɩsefi nyǝ́mɑ nɑ Peliyɑ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Peliyɑ lʋlʋɣʋ nyǝ́mɑ ntɛ́ nɑ Hepɛɛ nyǝ́mɑ nɑ Mɑlǝkǝyɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asɛɛ kɑ wɛnɑ pɛɛlɔ nɑ pɑ́ yɑɑkɩ-ɩ sɩ Selɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Pɛlɛ pɑ tɑɑ ɑpɑlɑɑ wɛ iyisi nɩɩlɛ nɑ nɑɑnʋwɑ nɑ tooso nɑ nɑsǝlɛ (53400). ");
INSERT INTO dop_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nɛfǝtɑli kpekǝle lʋlʋɣʋ nyǝ́mɑ ntɛ́: Yɑsiyɛlɩ nyǝ́mɑ nɑ Kuni nyǝ́mɑ ");
INSERT INTO dop_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","nɑ Yesɛɛ nyǝ́mɑ nɑ Sikɛm nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Pɑ tɑɑ ɑpɑlɑɑ kɑ wɛ iyisi nɩɩlɛ nɑ kɑkpɑsɩ nɑ nɑsǝlɛ (45400). ");
INSERT INTO dop_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ɩsɛɣɛlɩ ɑpɑlɑɑ tǝnɑ mpɑ pɑ kɑlɑɑ tɔ, pɑ kpɛntɑ iyisi nɑsǝtoso nɑ kʋlʋmɑɣɑ nɑ nɑsǝtoso nɑ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ (601730). ");
INSERT INTO dop_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Pǝ wɛɛ sɩ ń tɑlɑ tɛtʋ kɛ Ɩsɛɣɛlɩ kpekɑ nɑ pǝ́ kɛɛsǝnɑ ɑ sɑmɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","56","Tɛtɛ kɛ pɑɑ tɔ nɑ pɑ́ tɑlǝnɑ pɑɑ kpekǝle nteɣe tǝ tɛtʋ. Ɩlɛnɑ pɑ́ cɛlɑ kpekɑ sɔsɔɔnɑ kɛ tɛtʋ sɔsɔɔntʋ nɑ sǝkpenɑ kɛ sǝkpetu. ");
INSERT INTO dop_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Lefii kpekǝle tɑɑ lʋlʋŋ wei wei pɑ kɑlɑɑ tɔɣɔlɛ Kɛɛsɔŋ nyǝ́mɑ nɑ Kehɑtɩ nyǝ́mɑ nɑ Melɑli nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Pɑ lʋlʋŋ tɑɑ sǝkpeŋ ntɛ́ Lipini nyǝ́mɑ nɑ Hepǝlɔŋ nyǝ́mɑ nɑ Mɑlii nyǝ́mɑ nɑ Musi nyǝ́mɑ nɑ Kolee nyǝ́mɑ. Amǝlɑm cɑɑ kɛlɛ Kehɑtɩ. ");
INSERT INTO dop_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amǝlɑm kpɑɣɑnɑ Lefii pɛɛlɔ Yɔkǝpɛtɩ wei pɑ lʋlɑ Icipiti tɔ. Nɑ ɩ́lɛ́ ɩ lʋlɩ-ɩ Alɔŋ nɑ Moisi nɑ Mɑlǝyɑm pɑ tooso. ");
INSERT INTO dop_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Alɔŋ piyɑ ntɛ́ Nɑtɑpɩ, nɑ Apihu, nɑ Ɩlɑsɑɑ, nɑ Ɩtɑmɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Amɑ Tɑcɑɑ kʋwɑ Nɑtɑpɩ nɑ Apihu kɛ wɑɑtʋ wei pɑ ponɑ-ɩ kɔtɑɣɑ tǝlɑtɛ tɔɔ kɛ tulɑɑlʋ kpɑɩ nyǝŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Pɑ tɑɑ ɑpɑlɑɑ nɑ ɑlʋpiyɑ mpɑ pɑ tɑlɑ ɩsɔtʋnɑɑ nɑɑlɛ tɔ pɑ wɛ iyisi hiu nɑ tooso (23000). Pɑ tɑɑ kɑlǝnɑ-wɛ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɛlɑɑ. Mpi tɔ, pǝ fɛɩ sɩ pɑ́ tɑlǝnɑ-wɛɣɛ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ɩsǝnɑ Moisi nɑ kɔtʋlʋ Ɩlɑsɑɑ pɑ kɑlɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Mowɑpʋ tɛtɛkǝlɛ tɑɑ kɛ́ Yɑɑtɑnɩ nɔɣɔ kɛ Yeliko ɩsɛntɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mpɑ Moisi nɑ kɔtʋlʋ Alɔŋ pɑɑ kɑlɑ tɔm kɑncɑɑlɑɣɑ nyǝm kɛ Holɛpʋ wʋlɑɣɑ tɛtʋ tɑɑ tɔ pɑ fɛɩ nɔɔnɔɔ nyǝ́mɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Tɑcɑɑ kɑ tɛmɑ-wɛɣɛ heeluɣu sɩ pɑ tǝnɑ pɑɑ sɩ wʋlɑɣɑ tɛtʋ tɑɑ. Ye pǝ tɑɣɑ Yefune pǝyɑlʋ Kɑlɛpʋ nɑ Nuŋ pǝyɑlʋ Yosuwee pɑ tike kɛ pǝ kɑɑsɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ḿpʋ́ɣʋ́ Yosɛɛfʋ pǝyɑlʋ Mɑnɑsee, nɑ Mɑnɑsee pǝyɑlʋ Mɑkii, nɑ Mɑkii pǝyɑlʋ Kɑlɑɑtɩ nɑ Kɑlɑɑtɩ pǝyɑlʋ Hefɛɛ, nɑ Hefɛɛ pǝyɑlʋ Selofɑtɩ. Selofɑtɩ ɩnɩ ɩ pɛɛlɑɑ Mɑlɑ nɑ Nowɑ nɑ Hokǝlɑ nɑ Milikɑ nɑ Tiisɑ pɑ polǝnɑ ");
INSERT INTO dop_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Moisi nɑ kɔtʋlʋ Ɩlɑsɑɑ nɑ Ɩsɛɣɛlɩ kʋpɑɣɑlɑɑ tǝnɑ kiŋ kɛ Ɩsɔ cokǝle nɔnɔɣɔ nɑ pɑ́ tɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Tɑ́ cɑɑ sǝpɑ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ ɩ ɩsɑɣɑtʋ tɔɔ, ɩ tɑ yele ɑpɑlʋpǝyɑɣɑ. Amɑ ɩ fɛɩ Kolee nɑ ɩ wɑɑlɩ nyǝ́mɑ mpɑ pɑ kʋlɑ Tɑcɑɑ tɔɔ kɛ́ wʋlɑɣɑ tɛtʋ tɑɑ tɔ pɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Mpʋ tɔ, ɩ́ hɑ tɑ́ nɑ tɑ́ cɑɑ yǝlɑɑ kɛ tɛtʋ. Pǝ́ tɑɑ kɔɔ nɑ ɩ hǝtɛ sɑɑlɩ yem. Mpi tɔ, ɑlʋpiyɑ tike kɛ ɩ lʋlɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Ḿpʋ́ɣʋ́ Moisi hʋlɑ Tɑcɑɑ kɛ pɑ kʋsǝlǝmʋtʋ ntɩ. ");
INSERT INTO dop_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Nɑ ɩ́lɛ́ ɩ tɔ́ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Pɛɛlɑɑ mpɛ pɑ kʋsǝlǝmʋtʋ wɛ teu. Ɩ́ cɛlɛ-wɛɣɛ pɑ cɑɑ tɛtʋ kɛ ɩ́lɛ́ ɩ lʋlʋɣʋ nyǝ́mɑ nyǝntʋ kiŋ. ");
INSERT INTO dop_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Pǝ wɛɛ sɩ ń tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ ye ɑlʋpiyɑ tike kɛ yʋlʋ lʋlɑɑ nɑ ɩ́ sɩ, pɑ́ cɛlɛ-sǝɣɩ ɩ kpɑncoou. ");
INSERT INTO dop_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ye ɩ fɛɩnɑ ɑlʋpǝyɑɣɑ, ɩlɛ pɑ cɛlɑ ɩ kpɑncoou kɛ ɩ neu yɑɑ ɩ tɑɑlʋ. ");
INSERT INTO dop_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Yɑɑ ye ɩ fɛɩnɑ neu yɑɑ tɑɑlʋ, ɩlɛ pɑ cɛlɑ ɩ kpɑncoou kɛ ɩ cɑɑ tɑɑlʋ yɑɑ ɩ neu. ");
INSERT INTO dop_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Yɑɑ ye ɩ cɑɑ fɛɩnɑ tɑɑlʋ yɑɑ neu, ɩlɛ pɑ cɛlɑ ɩ kpɑncoou kɛ ɩ lʋlʋɣʋ nyǝ́mɑ tɑɑ wei ɩ kǝlɑ-ɩ kpǝtǝnɑʋ tɔ. Pǝ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kʋsǝsɩɩtʋ kɛ́ ɩsɩɩ mɑ kɛɛsʋɣʋ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: Kpɑ Apɑlim pʋɣʋ tɔɔ nɑ ń loosi tɛtʋ nti mɑ hɑɑkɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","N kɑ́ nɑ-tɩ yɑɑ. Amɑ n kɑ́ sɩ teitei kɛ́ ɩsɩɩ nyɑ́ tɑɑlʋ Alɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Pǝ tɑɣɑ pʋlʋ, ɩ́ tɑ́ tɔkɩ mɑ tɔm kɛ Siŋ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ wɑɑtʋ wei sɑmɑɑ yookɑɣɑnɑ-m tɔ. Ɩ́ tɑ́ fɑɣɑsɩ-m nɑ mɑ mpɑɑ kɛ wɑɑtʋ wei ɩ́ sǝlǝmɑɣɑ lʋm tɔ. Yoou lʋm mpi pɑ yɑɑnɑ pɑ tɛ tɑɑ sɩ, Melipɑ kɛ Siŋ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ Kɑtɛɛsɩ tɔ pǝ tɔm kɛ ɩ yɔɣɔtǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mpʋɣʋlɛ Moisi cɔwɑ Tɑcɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Hɑɩ, Ɩsɔ Tɑcɑɑ nyɑ́ wei n hɑɑkɩ weesuɣu tɔ, kpɑ yǝlɑɑ pɑnɛ pɑ nyʋɣʋ tʋ, ");
INSERT INTO dop_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","wei ɩ kɑ pǝsɩ nɑ ɩ́ pɑɑsǝnɑ-wɛɣɛ pɑɑ wɑɑtʋ wei tɔ, nɑ pɑ́ tɑɑ wɛɛ ɩsɩɩ kɑlǝkʋ ŋku kʋ lɑŋɑ tiikilu tɔ. ");
INSERT INTO dop_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Mpʋɣʋlɛ Tɑcɑɑ tɔmɑ Moisi sɩ: Nuŋ pǝyɑlʋ Yosuwee kɛ́ yʋlʋ wei ɩ tɑɑ mɑ Feesuɣu hɑɣɑɑ tɔɣɔ. Yɑɑ-ɩ nɑ ń tʋ-ɩ tǝmlɛ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ponɑ-ɩ kɔtʋlʋ Ɩlɑsɑɑ kiŋ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ɩsɛntɑɑ, nɑ ń lɑpɩ-ɩ wei ɩ kɑ lɛɛtɩ nyɑ́ lonte tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Pɑsɑ-ɩ nyɑ́ sɔsɔɔntʋ hɔɣɔlʋɣʋ. Ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ nyɑnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Kɔtʋlʋ Ɩlɑsɑɑ kɑ́ pɛɛkǝɣǝnɑ-ɩ Tɑcɑɑ luɣu nyǝntʋ nɑ kɔtɑɣɑ wontu nti pɑ yɑɑ sɩ wulim nɑ tumim tɔ. Ɩlɛnɑ ɩnɩ nɑ Ɩsɛɣɛlɩ sɑmɑɑ pɑ́ tǝŋǝɣɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ḿpʋ́ɣʋ́ Moisi mʋwɑ Tɑcɑɑ tɔm, nɑ ɩ́ yɑɑ Yosuwee kɛ kɔtʋlʋ Ɩlɑsɑɑ kiŋ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Nɑ Moisi tǝnɩ niŋ kɛ Yosuwee tɔɔ, nɑ ɩ́ lɑpɩ-ɩ ɩ lonte tɑɑ lɛɛtʋlʋ ɩsɩɩ Tɑcɑɑ kɛɛsʋɣʋ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ ɩ́ pɑɑsǝnɑ nɑ ɩ́ wɔkɩ-m tɔɣɔnɑɣɑ kɔtɑsɩ nsi sɩ sɔɔsʋŋ mɑ cɑɑkɩ tɔɣɔ pǝ wɑɑtʋnɑɑ mpɑ mɑ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Pɑɑ ɩfemle nte ɩ́ kɑ́ lɑ Tɑcɑɑ mɑɣɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔ. Ɩlɛ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ nsi sɩ tiili tɑ cɑɑmɩ tɔɣɔ ɩ́ kɑ́ lɑ-m kɔtɑɣɑ ŋkɛ. Nɑ pǝ́ wɛɛ ḿpʋ́ɣʋ́ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Lɛŋkɑ kɛ tɑnɑŋ, nɑ lɛŋkɑ kɛ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Nɑ pǝ́ sɔɔsǝnɑ mʋlʋm kiloonɑɑ tooso, wei pɑ nuɣutinɑ Olifi nim liitili kʋlʋm nɑ titite tɔ. ");
INSERT INTO dop_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Kɔtɑɣɑ ŋkɛɣɛ ɩ́ kɑ́ tɛmɑ-m lɑpʋ kɛ Holɛpʋ pʋɣʋ tɔɔ. Kɑ sɔɔsʋŋ kɛ mɑ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Ɩlɛnɑ ɩ́ tǝnɩ tɑnɑŋ kɔtɑɣɑ ɩwǝyɑɣɑ tɔɔ kɛ sʋlʋm liitili kʋlʋm nɑ titite, nɑ ɩ́ liisi pǝlɛɣɛ cokǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ɩlɛnɑ ɩ́ lɑ tɑɑnɑɣɑ nyǝŋkɑ kɛ teitei ɩsɩɩ tɑnɑŋ tɛɛ nyǝŋkɑ. Sɔɔsʋŋ wei mɑ cɑɑkɩ tɔ ɩ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","10","Pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ nɑɑlɛ nsi sɩ tiili tɑ́ cɑɑmɩ tɔɣɔ ɩ́ kɑ́ lɑ kɔtɑɣɑ ŋkɛɣɛ kʋyɑkʋ kʋhɛɛsʋɣʋ wule, nɑ pǝ sʋlʋm nɑ mʋlʋm kiloonɑɑ nɑɑtoso, wei pɑ nuɣutinɑ nim tɔ. Nɑ pǝ́ sɔɔsǝnɑ pɑɑ kʋyɑkʋ ŋku kʋ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Pɑɑ ɩsɔtʋ wei ɩ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ ŋku, ɩ́ kɑ́ lɑ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔ lɑtǝcɛnɑɑ kʋfɑmɑ nɑɑlɛɣɛ, nɑ ɩwɑɑʋ kʋlʋmʋɣʋ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ nɑɑtosompɔɣɔlɑɣɑ nsi sɩ tilli tɑ́ cɑɑmɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Ɩ́ kɑ́ sɔɔsɩ pɑɑ lɑtǝcɛ wei ɩ tɔɔ kɛ́ mʋlʋm mpi pɑ nuɣutinɑ nim tɔɣɔ kiloonɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ. Nɑ kiloonɑɑ nɑɑtoso kɛ pɑɑ ɩwɑɑʋ ŋku kʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Nɑ kiloonɑɑ toosoɣo pɑɑ ɩwǝyɑɣɑ ŋkɑ kɑ tɔɔ. Kɔtɑɣɑ ŋkɑ kɑ sɔɔsʋŋ mɑ cɑɑkɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Pɑɑ lɑtǝcɛ wei ɩ tɔɔ kɛ́ sʋlʋm liitilinɑɑ tooso, nɑ pɑɑ ɩwɑɑʋ ŋku kʋ tɔɔ kɛ sʋlʋm liitilinɑɑ nɑɑlɛ, nɑ pɑɑ ɩwǝyɑɣɑ ŋkɑ kɑ tɔɔ kɛ́ liitili kʋlʋm nɑ titite. Kɔtɑsɩ nsi ɩ́ kɑ́ lɑ pɑɑ pǝnɑɣɑ ŋkɑɣɑ ɩsɔtʋ kɑncɑɑlɑɣɑ kʋyɛɛŋ tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ɩlɛnɑ ɩ́ lɑ́ pǝŋtʋlʋɣʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Nɑ pǝ́ sɔɔsǝnɑ pɑɑ kʋyɑkʋ ŋku kʋ kɔtɑɣɑ nɑ pǝ sʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑɑ sɩ: Pɑɑ pǝnɑɣɑ kʋfɑlɑɣɑ ŋkɑ kɑ ɩsɔtʋ kɑncɑɑlɑɣɑ nyǝŋ, kʋyɛɛŋ nɑɑnʋwɑ nɑ liɣiti wule ɩ́ kɑ́ tɔɣɔ Tɛɛʋ ɑcimɑ nɑ mɑ hǝtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ɩlɛnɑ ɩsɔtʋ kʋlʋm ɩnɩ ɩ kʋyɛɛŋ nɑɑnʋwɑ nɑ kɑkpɑsɩ wule ɩ́ tɔɣɔ kʋkʋsʋm fɛɩ kɑkɑlɑsɩ ɑcimɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Acimɑ ɑnɩ ɑ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ wule, Ɩsɔ sɛɛtʋ kɛ ɩ́ kɑ́ koti. Ɩ́ kɑɑ lɑ tǝmlɛ nɑtǝlɩ. ");
INSERT INTO dop_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Ɩ́ kɑ́ lɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔ tɔlɑ wenɑ ɑ tiili tɑ́ cɑɑmɩ tɔ. Ɩsɩɩ lɑtǝcɛnɑɑ kʋfɑmɑ nɑɑlɛ, nɑ ɩwɑɑʋ nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Ɩ́ kɑ́ tǝnɩ pɑɑ kpǝntɛ nte tǝ tɔɔ kɛ́ kɔtɑɣɑ mʋlʋm mpi pɑ nuɣutinɑ nim tɔ, pɑɑ lɑtǝcɛ kʋfɑlʋ wei ɩ tɔɔ kɛ́ kiloonɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ, nɑ kiloonɑɑ tooso kɛ́ pɑɑ ɩwɑɑʋ ŋku kʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Nɑ ɩ́ tǝnɩ pɑɑ ɩwǝyɑɣɑ ŋkɑ kɑ tɔɔ kɛ́ kiloonɑɑ tooso. ");
INSERT INTO dop_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Ɩlɛnɑ ɩ́ lɑ́ pǝŋtʋlʋɣʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Nɑ kɔtʋlʋ lɑ-mɛɣɛ pǝ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Kɔtɑsɩ nsɩ sɩ tǝnɑ sɩ sɔɔsǝɣǝnɑ pɑɑ tɑnɑŋ ŋku kʋ nyǝŋsɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Acimɑ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ tǝcu kɛ́ mɑɑ nɩɩ pɑɑ kʋyɑkʋ ŋku kʋ tɔɣɔnɑɣɑ nɑ sʋlʋm nɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ kɑ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Mɑ sɛɛtʋ tike kɛ ɩ́ kɑ́ koti kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ ŋkʋ kʋ wule. Ɩ́ kɑɑ lɑ tǝmlɛ nɑtǝlɩ. ");
INSERT INTO dop_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Ḿpʋ́ɣʋ́ Moisi tɔmɑ sɩ: Pǝ tɑkɩ kʋmtʋ ɑcimɑ wule, ɩlɛnɑ ɩ́ kɔnɑ Tɑcɑɑ kɛ tɔɣɔnɑɣɑ kʋfɑlɑɣɑ kɔtɑsɩ. Ɩ sɛɛtʋ tike kɛ ɩ́ kɑ́ koti kʋyɑkʋ ŋkʋ kʋ wule. Ɩ́ kɑɑ lɑ tǝmlɛ nɑtǝlɩ. ");
INSERT INTO dop_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Ɩ́ kɑ́ lɑ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ nɑ ɩ́ cɑɑkɩ kɑ sɔɔsʋŋ tɔɣɔ lɑtǝcɛnɑɑ kʋfɑmɑ nɑɑlɛ, nɑ ɩwɑɑʋ nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","29","Nɑ ɩ́ tǝnɩ pɑɑ kɔtɑɣɑ ŋkɑ kɑ tɔɔ kɛ́ tɔɣɔnɑɣɑ kɔtɑɣɑ, ɩsɩɩ pɑɑ ɩsɔtʋ wei ɩ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Ɩlɛnɑ ɩ́ lɑ́ pǝŋtʋlʋɣʋ kɛ kɔtɑɣɑ, nɑ pɑ́ lɑ-mɛɣɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Kɔtɑsɩ sǝnɛ sɩ tǝnɑɣɑ ɩ́ sɔɔsǝɣɩ pɑɑ kʋyɑkʋ ŋku kʋ nyǝŋkɑ tɔɔ, nɑ pǝ tɔɣɔnɑɣɑ, nɑ pǝ sʋlʋm. Pǝ wɛɛ sɩ tɔlɑ nnɑ ɑ tiili tɑ́ cɑɑmɩ tɔɣɔ ɩ́ lɑkɩ kɔtɑsɩ. ");
INSERT INTO dop_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Ḿpʋ́ɣʋ́ Moisi tɔmɑ sɩ: Tɑcɑɑ sɛɛtʋ tike kɛ ɩ́ kɑ́ koti ɩsɔtʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ wule. Ɩ́ kɑɑ lɑ tǝmlɛ nɑtǝlɩ. Nɑ pɩɩ lɑ-mɛɣɛ kɑwilitɑsɩ ɑcimɑ. ");
INSERT INTO dop_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ɩlɛnɑ ɩ́ lɑ́ Tɑcɑɑ kɛ kɔtɑsɩ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔ, sɩ sɔɔsʋŋ nyǝnsɩ kɛ tɔlɑ wenɑ ɑ tiili tɑ́ cɑɑmɩ tɔ. Ɩsɩɩ lɑtǝcɛ kʋfɑlʋ kʋlʋm, nɑ ɩwɑɑʋ kʋlʋmʋɣʋ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Ɩ́ kɑ́ sɔɔsɩ pɑɑ kpǝntɛ nte tǝ tɔɔ kɛ́ kɔtɑɣɑ mʋlʋm mpi pɑ nuɣutinɑ nim tɔ. Pɑɑ lɑtǝcɛ kʋfɑlʋ wei ɩ tɔɔ kɛ́ kiloonɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ, nɑ ɩwɑɑʋ tɔɔ kɛ́ kiloonɑɑ nɑɑtoso. ");
INSERT INTO dop_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Nɑ ɩ́ tǝnɩ pɑɑ ɩwǝyɑɣɑ ŋkɑ kɑ tɔɔ kɛ́ kiloonɑɑ nɑɑtoso. ");
INSERT INTO dop_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Nɑ ɩ́ lɑ́ Tɑcɑɑ kɛ pǝŋtʋlʋɣʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ, nɑ pɑ́ lɑ-mɛɣɛ pǝ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Ɩ́ kɑ́ sɔɔsɩ kɔtɑsɩ sǝnɛ sɩ tǝnɑɣɑ pɑɑ kʋyɑkʋ ŋku kʋ kɔtɑsɩ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔ. Nɑ pɑɑ ɩsɔtʋ wei ɩ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ nyǝnsɩ nɑ pǝ sʋlʋm nɑ pǝ tɔɣɔnɑɣɑ nyǝnsɩ tɔɔ, ɩsɩɩ Tɑcɑɑ kɑ sɩɩʋ tɔ. Kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ nɑ Tɑcɑɑ cɑɑkɩ kɑ sɔɔsʋŋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Ḿpʋ́ɣʋ́ Moisi tɑsɑɑ sɩ: Ɩsɔ sɛɛtʋ tike kɛ ɩ́ kɑ́ koti ɩsɔtʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋ kʋyɑkʋ nɑɑnʋwɑ nyǝŋkʋ wule, nɑ nɔhɔkʋtʋ. Tǝmlɛ nɑtǝlɩ tǝ fɛɩ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Nɑ ɩ́ lɑ́ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ nɑ kɑ́ wɛnɑ sɔɔsʋŋ tɔɣɔ tɔlɑ wenɑ ɑ tiili tɑ́ cɑɑmɩ tɔ. Ɩsɩɩ lɑtǝcɛ kʋfɑlʋ nɑ ɩwɑɑʋ nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","10","Nɑ ɩ́ tǝnɩ pɑɑ kɔtɑɣɑ ŋkɑ kɑ tɔɔ kɛ́ tɔɣɔnɑɣɑ nyǝŋkɑ. Ɩsɩɩ pɑɑ ɩsɔtʋ wei ɩ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ɩlɛnɑ ɩ́ lɑ́ pǝŋtʋlʋɣʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ. Nɑ ɩ́ sɔɔsɩ lɛŋkʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ kʋyɑkʋ sɔsɔɔŋkʋ nyǝŋkɑ. Nɑ pǝ́ kɑɑsɩ pɑɑ kʋyɑkʋ ŋku kʋ kɔkɔ nyǝnsɩ nɑ pǝ tɔɣɔnɑɣɑ nɑ pǝ sʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Ḿpʋ́ɣʋ́ Moisi tɑsɑɑ sɩ: Ɩsɔ sɛɛtʋ tike kɛ ɩ́ kɑ́ koti ɩsɔtʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋ kʋyɑkʋ nɑɑnʋwɑ nɑ kɑkpɑsɩ nyǝŋkʋ wule. Tǝmlɛ nɑtǝlɩ tǝ fɛɩ lɑpʋ. Nɑ ɩ́ tɔɣɔ Tɑcɑɑ ɑcimɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Ɩlɛnɑ ɩ́ lɑpɩ-ɩ tɔlɑ wenɑ pǝ tɑ cɑɑmɩ tɔɣɔ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ nɑ kɑ wɛ sɔɔsʋŋ tɔɣɔ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ wule. Ɩsɩɩ lɑtǝcɛnɑɑ kʋfɑmɑ nɑɑnʋwɑ nɑ tooso, nɑ ɩwɑɑŋ nɑɑlɛ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑnʋwɑ nɑ liɣiti. ");
INSERT INTO dop_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","15","Nɑ ɩ́ tǝnɩ pɑɑ kɔtɑɣɑ ŋkɑ kɑ tɔɔ kɛ́ tɔɣɔnɑɣɑ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Ɩlɛnɑ ɩ́ lɑ́ pǝŋtʋlʋɣʋ kɛ ɩsɑɣɑtʋ hɩɩsʋɣʋ nyǝŋkɑ. Nɑ pǝ́ sɔɔsǝnɑ pɑɑ kʋyɑkʋ ŋku kʋ kɔkɔ nyǝnsɩ nɑ pǝ tɔɣɔnɑɣɑ nɑ pǝ sʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","34","Pǝ kpɑɣɑʋ kʋyɑkʋ nɑɑlɛ nyǝŋkʋ nɑ pǝ́ polo nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ tɔ. Ɩ́ kɑ́ lɑ pɑɑ kʋyɑkʋ ŋku kʋ kɔtɑɣɑ kɛ tɔlɑ wenɑ ɑ tiili tɑ́ cɑɑmɩ tɔɣɔ. Nɑ pǝ́ sɔɔsǝnɑ pǝ tɔɣɔnɑɣɑ nɑ pǝ sʋlʋm. Mpi ɩ́ kɑ́ lɑ kɔtɑsɩ kɛ kʋyɑkʋ nɑɑlɛ nyǝŋkʋ tɔɣɔlɛ, lɑtǝcɛnɑɑ nɑɑnʋwɑ nɑ nɑɑlɛ, nɑ ɩwɑɑŋ nɑɑlɛ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑnʋwɑ nɑ liɣiti, nɑ pǝŋtʋlʋɣʋ kʋlʋmʋɣʋ. Kʋyɑkʋ tooso nyǝŋkʋ wule kɛ lɑtǝcɛnɑɑ nɑɑnʋwɑ nɑ kʋlʋm, nɑ ɩwɑɑŋ nɑɑlɛ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑnʋwɑ nɑ liɣiti nɑ pǝŋtʋlʋɣʋ kʋlʋmʋɣʋ. Kʋyɑkʋ liɣiti nyǝŋkʋ wule kɛ lɑtǝcɛnɑɑ nɑɑnʋwɑ, nɑ ɩwɑɑŋ nɑɑlɛ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑnʋwɑ nɑ liɣiti, nɑ pǝŋtʋlʋɣʋ kʋlʋmʋɣʋ. Kʋyɑkʋ kɑkpɑsɩ nyǝŋkʋ wule kɛ lɑtǝcɛnɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ, nɑ ɩwɑɑŋ nɑɑlɛ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑnʋwɑ nɑ liɣiti, nɑ pǝŋtʋlʋɣʋ kʋlʋmʋɣʋ. Kʋyɑkʋ nɑɑtoso nyǝŋkʋ wule kɛ lɑtǝcɛnɑɑ pǝlefɛɩ nɑɑnʋwɑ, nɑ ɩwɑɑŋ nɑɑlɛ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑnʋwɑ nɑ liɣiti, nɑ pǝŋtʋlʋɣʋ kʋlʋmʋɣʋ. Kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ kɛ lɑtǝcɛnɑɑ nɑɑtosompɔɣɔlɑɣɑ, nɑ ɩwɑɑŋ nɑɑlɛ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑnʋwɑ nɑ liɣiti, nɑ pǝŋtʋlʋɣʋ kʋlʋmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Acimɑ sɔsɔɔnɑ kɛ ɩ́ kɑ́ koti nɑ ɩ́ tɔɣɔ kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ wule. Tǝmlɛ nɑtǝlɩ tǝ fɛɩ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Ɩ́ kɑ́ lɑ Tɑcɑɑ kɛ kɔtɑɣɑ sɔɔsʋŋ nyǝŋkɑ kɛ lɑtǝcɛ, nɑ ɩwɑɑʋ, nɑ pǝnɑɣɑ kʋlʋmɑɣɑ ɩwɛɛsɩ kɛ nɑɑtosompɔɣɔlɑɣɑ. Pǝ fɛɩ sɩ tɔlɑ ɑnɩ ɑ tiili ɩ́ cɑɑmɩ. ");
INSERT INTO dop_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Nɑ ɩ́ tǝnɩ pɑɑ tɔtɛ nte tǝ tɔɔ kɛ́ kɔtɑɣɑ tɔɣɔnɑɣɑ, nɑ pǝ sʋlʋm mpi pɑ lɑkǝnɑ tɑm tɔ. ");
INSERT INTO dop_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Nɑ ɩ́ lɑ tɔtɔɣɔ ɩsɑɣɑtʋ hɩɩsʋɣʋ kɔtɑɣɑ nɑ ɩ́ sɔɔsɩ pǝ tǝnɑɣɑ pɑɑ kʋyɑkʋ ŋku kʋ kɔkɔ kɔtɑsɩ tɔɔ, nɑ pǝ tɔɣɔnɑɣɑ nɑ pǝ sʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Kɔtɑsɩ nsi pǝ wɛɛ sɩ ɩ́ sɔɔsɩ kɔkɔ nɑ tɔɣɔnɑɣɑ nɑ sʋlʋm nɑ ciikuɣu nɑ luɣu kʋlʋmʋɣʋ pǝ nyǝnsɩ tɔɔ kɛ́ Tɑcɑɑ ɑcimɑ kʋyɑkʋ wule tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Ḿpʋ́ɣʋ́ Moisi tɛlǝsɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ tǝ tǝnɑ nti Tɑcɑɑ tʋ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Pǝ wɑɑlɩ kɛ́ ɩ tɑsɑ kpekɑ nyɔɔŋ nyǝ́mɑ kɛ tɛlǝsʋɣʋ kɛ Tɑcɑɑ kʋyɔɣɔtʋtʋ lɛntǝnɑɑ tɔtɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Ye yʋlʋ sɩɩ nɔɣɔ sɩ ɩ lɑkɩ Tɑcɑɑ kɛ kɔtɑɣɑ. Yɑɑ ɩ kisiɣi pʋlʋpʋɣʋ Ɩsɔ tɔɔ. Pǝ fɛɩ sɩ ɩ́ sɛkɩ pǝ lɑpʋ. Pǝ wɛɛ sɩ ɩ́ lɑ pǝ tǝnɑ mpi pǝ lɩɩnɑ ɩ nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Ye ɩsɩɩ pɛɛlɔ wɛ ɩ cɑɑ tǝyɑɣɑ tɑɑ, nɑ ɩ́ sɩɩ ɩ nɔɣɔ kɛ Ɩsɔ ɩsɛntɑɑ sɩ, ɩ kɑ́ lɑ pʋlʋ, ");
INSERT INTO dop_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","nɑ cɛcɛ nɩɩ, nɑ ɩ́ tɑ́ kisinɑ-ɩ. Pǝ wɛɛ kɛ́ sɩ ɩ́ tǝŋ teitei ɩsɩɩ ɩ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Amɑ ye ɩ kisinɑ-ɩ kʋyɑkʋ ŋkʋɣʋ kpɑkpɑɑ, ɩlɛ ɩ yele pǝ tɔm. Tɑcɑɑ kɑɑ pɔɔsɩ-ɩ. Mpi tɔ, ɩ cɑɑ kisinɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Ye ɩsɩɩ pɛɛlɔ hulinɑ nɔɣɔ sɩɩʋ nɑ pǝ́cɔ́ ɩ sɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ɩlɛnɑ ɩ pɑɑlʋ nɩɩ-tɩ nɑ ɩ́ tɑ́ kisinɑ-ɩ pǝ wɛɛ sɩ ɩ lɑ ɩsɩɩ ɩ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Amɑ ye ɩ kisinɑ-ɩ kʋyɑkʋ ŋkʋɣʋ kpɑkpɑɑ, ɩlɛ ɩ yele pǝ tɔm. Tɑcɑɑ kɑɑ pɔɔsɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Ye ɩsɩɩ ɑlʋ leelu, yɑɑ wei nɑ ɩ pɑɑlʋ pɑ yɑwɑ tɔ, ɩ sɩɩ nɔɣɔ. Pǝ wɛɛ sɩ ɩ́ lɑ-kɛɣɛ. ");
INSERT INTO dop_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Mpʋ tɔ, ye ɩsɩɩ ɑlʋ wei ɩ wɛnɑ pɑɑlʋ tɔ ɩ sɩɩ nɔɣɔ sɩ ɩ́ kɑ́ lɑ pʋlʋ, ");
INSERT INTO dop_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","nɑ ɩ pɑɑlʋ tɑ́ kisinɑ-ɩ. Ɩsɩɩ ɩ lɑpɑ ɩsǝnɑ ɩ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ye ɩ pɑɑlʋ kisinɑ-ɩ kʋyɑkʋ ŋkʋɣʋ kpɑkpɑɑ, ɩlɛ ɩ yele pǝ tɔm. Tɑcɑɑ kɑɑ pɔɔsɩ-ɩ. Mpi tɔ, ɑpɑlʋ kisinɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mpʋ tɔ, ye ɩsɩɩ ɑlʋ cɑɑ ɩ sɩɩ nɔɣɔ sɩ ɩ lɑkɩ pʋlʋpʋ, ɩ pɑɑlʋ wɛnɑ mpɑɑʋ sɩ ɩ́ tisinɑ-ɩ, yɑɑ ɩ́ kisinɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Amɑ ye ɩ nɩɩwɑ nɑ ɩ́ tɑ́ kisinɑ-ɩ kʋyɑkʋ ŋkʋɣʋ kpɑkpɑɑ. Ɩlɛ ɩ hʋlǝnɑ ɩ sum ntɛ́ sɩ ɩ tisɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Amɑ ye wɑɑlɩ wɑɑlɩ kɛ́ ɩ lɑŋlɛ tɑ hɛɛnɑ ɩ ɑlʋ sɩ ɩ́ tɑɑ lɑ ɩsɩɩ ɩ sɩɩwɑ tɔ. Ɩlɛ Tɑcɑɑ kɑɑ pɔɔsɩ ɑlʋ, ɩ pɑɑlʋ nyʋɣʋ tɑɑ kɛ́ pɩɩ mǝlɩ. ");
INSERT INTO dop_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Kʋsǝsɩɩtʋ nti Tɑcɑɑ sɩɩwɑ ɑlɑɑ nɑ pɛɛlɑɑ pɑ nɔɔsɩ sɩɩʋ tɔm tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Polo nɑ ń hɔ Mɑtiyɑŋ nyǝ́mɑ ŋkpɑŋʋɣʋ kɛ ɩsɑɣɑtʋ nti pɑ lɑpɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔ tǝ tɔɔ. Pǝ wɑɑlɩ kɛ́ n kɑ́ kpe nyɑ́ nyǝ́mɑ cɔlɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mpʋɣʋlɛ Moisi tɔmɑ sɑmɑɑ sɩ: Mǝ tɑɑ lɛlɑɑ ɩ́ suu pɑ yoou wontu nɑ pɑ́ polo nɑ pɑ yoonɑ Mɑtiyɑŋ nyǝ́mɑ, nɑ pɑ́ lɛɛtɩ-wɛ ɩsɩɩ Tɑcɑɑ sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Mpʋ tɔ, ɩ́ lǝsɩ pɑɑ kpekǝle nte tǝ tɑɑ kɛ́ yoolɑɑ iyɑɣɑ (1000). ");
INSERT INTO dop_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ḿpʋ́ɣʋ́ pɑ lǝsɑ pɑɑ Ɩsɛɣɛlɩ kpekǝle nte tǝ tɑɑ kɛ́ yoolɑɑ iyɑɣɑ (1000). Ɩlɛnɑ pǝ́ kpɛntɩ iyisi nɑɑnʋwɑ nɑ nɑɑlɛ (12000). ");
INSERT INTO dop_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Nɑ pɑ́ tilinɑ pɑ tǝnɑɣɑ yoou. Ɩlɛnɑ kɔtʋlʋ Ɩlɑsɑɑ pǝyɑlʋ Pɛŋhɑsɩ kpɛnnɑ Ɩsɔ wontu nɑ tutuuŋ wei pɑɑ hʋlɩ nɑ pɑ́ cɑɑlɩ yoou tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ḿpʋ́ɣʋ́ pɑ tii Mɑtiyɑŋ nyǝ́mɑ tɛtʋ tɔɔ, ɩsɩɩ Tɑcɑɑ kɑ heeluɣu Moisi nɑ ɩ́ tɛlǝsɩ-wɛ tɔ, nɑ pɑ́ kpiisi ɑpɑlɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Pɑ kʋwɑ tɔtɔɣɔ Mɑtiyɑŋ ɑwulɑɑ kɑkpɑsɩ: Ɩfi, nɑ Lekem, nɑ Suuu, nɑ Huuu, nɑ Lepɑ, nɑ pǝ kpɛnnɑ Peyɔɔ pǝyɑlʋ Pɑlɑɑm. ");
INSERT INTO dop_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Nɑ pɑ́ kpɑ sɑlǝkɑ kɛ pɑ ɑlɑɑ, nɑ pɑ piyɑ, nɑ pɑ́ kuu pɑ tɔlɑ nɑ pɑ kɑlǝkǝŋ nɑ pɑ wɛnɑʋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Nɑ pɑ́ sɔ pɑ ɑcɑlɛɛ nɑ pɑ cɑcɑkǝŋ kɛ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ḿpʋ́ɣʋ́ pɑ tɛɛnɑ wontu nɑ yǝlɑɑ nɑ tɔlɑ nnɑ pɑ kuuwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Ɩlɛnɑ pɑ́ ponɑ pǝ tǝnɑɣɑ pɑ tǝsikile kɛ Mowɑpʋ tɛtɛkǝlɛ tɑɑ, kɛ Yɑɑtɑnɩ pɔɣɔ nɔɣɔ, kɛ Yeliko ɩsɛntɑɑ. Nɑ pɑ́ hʋ́lɩ́ Moisi nɑ kɔtʋlʋ Ɩlɑsɑɑ nɑ Ɩsɛɣɛlɩ kpekǝle tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Ḿpʋ́ɣʋ́ Moisi nɑ Ɩlɑsɑɑ, nɑ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ lɛlɑɑ pɑ lɩɩwɑ tǝsikile nɑ pɑ́ suli-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Tǝnɑɣɑlɛ Moisi mʋ pɑ́ɑ́nɑ́ nɑ yoolɑɑ nyɔɔŋ nyǝ́mɑ. Ɩsɩɩ iyisi iyɑɣɑ (1000) nyɔɔŋ nyǝ́mɑ, nɑ nɩɩnʋwɑ (100) nyɔɔŋ nyǝ́mɑ mpɑ pɑ lɩɩnɑ yoou tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Nɑ ɩ́ pɔɔsɩ-wɛ sɩ: Pepe tɔɔ kɛ́ ɩ́ tɑ́ kʋ́ ɑlɑɑ? ");
INSERT INTO dop_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Pǝyele ɩ́ nyǝ́mɑ teu sɩ, Mɑtiyɑŋ ɑlɑɑ mpɛɣɛ Pɑlɑɑm puɣusɑɑ, nɑ pɑ́ sʋsɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ ɩsɑɣɑtʋ sɔsɔɔntʋ tɑɑ, nɑ pɑ́ wɑkǝlǝnɑ Tɑcɑɑ kɛ Peyɔɔ tɔm tɑɑ. Mpʋ pǝ kɔnnɑ yʋlʋkʋsǝkʋ kɛ Ɩsɔ yǝlɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Pǝ tɔɔ tɔ, ɩ́ kʋ́ ɑpɑlʋpiyɑ nɑ ɑlɑɑ mpɑ pɑ tɛmɑ sɑɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Ye ɩ́ nɔkɑɑ, ɩlɛ ɩ́ sɩɩ mǝ tǝɣɩ yomɑɑ kɛ pɛɛlɑɑ mpɑ pɑ tɑ nyǝntɑ ɑpɑlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Pǝ kɑɑsɑ mǝ tɑɑ mpɑ pɑ kʋwɑ yǝlɑɑ, yɑɑ pɑ tokinɑ sǝtɑɑ tɔ, pɑɑ cɑɣɑ tǝsikile wɑɑlǝɣɩ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ kɛ́. Ɩlɛnɑ pɑ́ lɑ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ kɛ kʋyɑkʋ tooso nyǝŋkʋ wule. Nɑ pǝ́ kpɛŋnɑ pɑ yomɑɑ mpɑ pɑ sɩɩ pɑ tɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Nɑ pɑ́ lɑ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ tɔtɔɣɔ wontu kususuutu nɑ tɔnǝŋ nyǝntʋ, nɑ pǝ́ŋ hʋntʋ nyǝntʋ, yɑɑ nti pɑ sɑɑkɑ tɑɑsɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Pǝ wɑɑlɩ kɛ́ kɔtʋlʋ Ɩlɑsɑɑ tɔmɑ ɑpɑlɑɑ mpɑ pɑ polɑ yoou tɔ sɩ kʋsǝsɩɩtʋ nti Tɑcɑɑ tɛlǝsɑ Moisi tɔɣɔlɛ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","Pǝ kpɑɣɑʋ wontu nti tɩɩ nyɑkɩ kɔkɔ tɔ, ɩsɩɩ wʋlɑ nɑ liɣitee nyǝɣǝtʋ, nɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ, nɑ nyǝɣǝlʋɣʋ mɑɣɑmɑɣɑ, nɑ nyǝɣǝtʋ lɛntɩ. Nɑ wontu nti tǝ yɔkǝɣɩ, ɩsɩɩ somtu tɔ. Ɩ́ kɑ́ nyɑɑlɩ-tɩ nɑ kɔkɔ kɛ́ nɑ ɩ́ lii-tǝɣɩ kɔtɑɣɑ lʋm tɑɑ. Ye kɔkɔ kʋnyɑɣɑtʋ, ɩlɛ ɩ́ lii tǝlɛɣɛ kɔtɑɣɑ lʋm tɑɑ tike. ");
INSERT INTO dop_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Ye ɩ́ cɔtɑ mǝ wontu kɛ kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ wule, ɩlɛ mǝ ɑsilimɑ kɛɛlɑɑ kɛlɛ. Ɩ́ sʋʋ tǝsikile tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Nyɑnɑ Ɩlɑsɑɑ, nɑ Ɩsɛɣɛlɩ nyɔɔŋ nyǝ́mɑ, ɩ́ kɑlɑ pǝ tǝnɑ mpi ɩ́ kpɑwɑ yoou tɑɑ tɔ. Pǝ kpɑɣɑʋ yǝlɑɑ nɑ pǝ tɔlɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Ɩlɛnɑ ɩ́ tɑlɑ pǝ tɑɑ kɛ́ cɑlɩ. Yoou potɑɑ kɛ hɔɣɔlʋɣʋ, nɑ lɛlɑɑ kɛ lɛŋkʋ. ");
INSERT INTO dop_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Nɑ ɩ́ lǝsɩ yoolɑɑ nyǝm tɔɔ kɛ́ mpi pǝ kɛ́ mɑ tǝtɔɣɔlɛ tɔɣɔ yʋlʋ kʋlʋm kɛ yǝlɑɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (500) tɔɔ, nɑ tɔlɑ kɛ mpʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Nɑ ɩ́ cɛlɑ kɔtʋlʋ Ɩlɑsɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ye pǝ kɑɑsɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɛlɑɑ nyǝm, ɩlɛ ɩ́ lǝsɩ mpi pǝ wɛɛ sɩ, pɛlɛ pɑ́ lǝsɩ tɔɣɔ yǝlɑɑ nɩɩlɛ nɑ nɑɑnʋwɑ tɔɔ kɛ́ yʋlʋ kʋlʋm. Nɑ tɔlɑ kɛ mpʋ tɔtɔ, nɑ ɩ́ cɛlɑ pǝ tǝnɑɣɑ Lefii nyǝ́mɑ mpɑ pɑ pɑɑsǝɣǝnɑ Ɩsɔ cokǝle tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Ḿpʋ́ɣʋ́ Moisi nɑ Ɩlɑsɑɑ pɑ lɑpɑ teitei ɩsɩɩ Tɑcɑɑ heeluɣu-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Tɔlɑ wenɑ pɑ kuuwɑ kolontunɑɑ tɛ́ tɔ, ɑ kɑɑsɑ heeŋ nɑ pǝ́ŋ kɛ iyisi nɑsǝtoso nɑ nɩɩtoso nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ (675000) ");
INSERT INTO dop_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","nɑ nɑɑŋ kɛ iyisi nɩɩtoso nɑ nɑɑnʋwɑ nɑ nɑɑlɛ (72000) ");
INSERT INTO dop_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","nɑ kpɑŋɑsɩ kɛ iyisi nɩɩtoso nɑ kʋlʋm (61000) ");
INSERT INTO dop_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","nɑ pɛɛlɑɑ mpɑ pɑ tɑ nyǝntɑ ɑpɑlɑɑ tɔɣɔ iyisi hiu nɑ nɑɑnʋwɑ nɑ nɑɑlɛ (32000). ");
INSERT INTO dop_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Heeŋ nɑ pǝ́ŋ wei pɑ cɛlɑ yoolɑɑ tɔ, ɩ kpɛntɑ iyisi ŋmʋnʋɣʋ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ nɑ nɑsǝlɛ nɩɩnʋwɑ (337500). ");
INSERT INTO dop_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Nɑ pɑ́ lǝsɩ Tɑcɑɑ nyǝnɑ kɛ nɑsǝtoso nɑ nɩɩtoso nɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ (675). ");
INSERT INTO dop_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Nɑɑŋ kɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ nɑɑtoso (36000) nɑ Tɑcɑɑ nyǝŋ kɛ nɩɩtoso nɑ nɑɑnʋwɑ nɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Kpɑŋɑsɩ kɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ nɑsǝlɛ nɩɩnʋwɑ (30500). Tɑcɑɑ nyǝnsɩ kɛ nɩɩtoso nɑ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Yǝlɑɑ kɛ iyisi nɑɑnʋwɑ nɑ nɑɑtoso (16000). Tɑcɑɑ nyǝ́mɑ kɛ hiu nɑ nɑɑnʋwɑ nɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Ḿpʋ́ɣʋ́ Moisi cɛlɑ Ɩsɔ nyǝm kɛ kɔtʋlʋ Ɩlɑsɑɑ, ɩsɩɩ Tɑcɑɑ kɑ heeluɣu-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","43","Mpi pɑ cɛlɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɛlɑɑ tɔ, pǝ nɑ yoolɑɑ nyǝm pǝ kʋlʋm kɛ́. Heeŋ nɑ pǝ́ŋ kɑ wɛ iyisi ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ nɑ hiu nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (337500). ");
INSERT INTO dop_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Nɑɑŋ kɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ nɑɑtoso (36000). ");
INSERT INTO dop_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Kpɑŋɑsɩ kɛ iyisi hiu nɑ nɑɑnʋwɑ nɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (30500), ");
INSERT INTO dop_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","nɑ pɛɛlɑɑ kɛ iyisi nɑɑnʋwɑ nɑ nɑɑtoso (16000). ");
INSERT INTO dop_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Ḿpʋ́ɣʋ́ Moisi lǝsɑ pɛɛlɑɑ tɔɔ kɛ́ yʋlʋ kʋlʋm kɛ nɩɩlɛ nɑ nɑɑnʋwɑ tɔɔ, nɑ tɔlɑ kɛ mpʋ tɔtɔ, ɩsɩɩ Tɑcɑɑ kɑ heeluɣu-ɩ tɔ, nɑ ɩ́ cɛlɑ Lefii nyǝ́mɑ mpɑ pɑ pɑɑsɑɣɑnɑ Ɩsɔ cokǝle tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Ḿpʋ́ɣʋ́ yoolɑɑ iyisi iyɑɣɑ (1000) nyɔɔŋ nyǝ́mɑ, nɑ nɩɩnʋwɑ (100) nyɔɔŋ nyǝ́mɑ, pɑ kotɑ Moisi kiŋ, ");
INSERT INTO dop_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","nɑ pɑ́ heeli-ɩ sɩ: Tǝ kɑlɑ yoolɑɑ sǝkpemɑ, pɑ wɛ pɑ nɔɣɔ tɑɑ, nɔɣɔlʋ tɑ lɑ ɑsɑɑlɑ. ");
INSERT INTO dop_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Pǝ tɔɔ kɛ́ tǝ kɔŋnɑ Tɑcɑɑ kɛ kʋhɑɑŋ kɛ wʋlɑ ɑlukpɑlisi, nɑ pǝ kpɑsɩ, nɑ kukuwee, nɑ ŋkpɑnyɑpǝlɑsɩ, nɑ lɩɩtʋ, nti tǝ hikɑɑ tɔ sɩ pǝ́ hɩɩsɩ tɑ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Ɩlɛnɑ Moisi nɑ kɔtʋlʋ Ɩlɑsɑɑ pɑ́ mʋ wʋlɑ wontu nti pɑ kɔnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Wontu nti yoolɑɑ mpɛ pɑ kɔnɑɑ tɔ, tǝ kpɛntɑ kiloonɑɑ nɩɩnʋwɑ nɑ nɩɩtoso nɑ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Pǝ kɑɑsɑ yoolɑɑ sǝkpemɑ, ɩlɛnɑ pɑɑ wei ɩ́ sɩɩnɑ ɩ tǝɣɩ wontu nti ɩ kuuwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Ḿpʋ́ɣʋ́ Moisi nɑ Ɩlɑsɑɑ pɑ sɩɩ wʋlɑ wontu nti yoolɑɑ hɑwɑ tɔɣɔ Ɩsɔ cokǝle tɑɑ sɩ, Tɑcɑɑ ɩ́ tɑɑ sɔɔ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Lupɛŋ nɑ Kɑtɩ pǝ yǝlɑɑ kɑ wɛnɑ kɑlǝkǝŋ sɔsɔɔŋ kɛ tuutuumɑ kɛ́. Ɩlɛnɑ pɑ́ cɛkǝnɑ sɩ Yɑsɛɛ tɛtʋ hɔɣɔlʋɣʋ, nɑ Kɑlɑɑtɩ tɛtʋ kɑ mʋnɑ tɔlɑ tɔɔʋ. ");
INSERT INTO dop_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Pǝ tɔɔ kɛ́ pɑ polɑɑ nɑ pɑ́ mɑɣɑnɑ Moisi nɑ kɔtʋlʋ Ɩlɑsɑɑ nɑ kpekɑ nyɔɔŋ nyǝ́mɑ nɑ pɑ́ heeli-wɛ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atɑlɔtɩ, nɑ Tipɔŋ, nɑ Yɑsɛɛ, nɑ Nimlɑ, nɑ Hɛsǝpɔŋ, nɑ Ɩlɑle, nɑ Sepɑm, nɑ Nepo, nɑ Peyoŋ pǝ ɑcɑlɛɛ kɛ́ ");
INSERT INTO dop_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","Tɑcɑɑ sǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ mʋ tɛtʋ nti tɔ, tǝ nyǝ́mɑ kɛ́. Tɛtʋ ntɩ tǝ mʋnɑ tɔlɑ tǝtɔɔlɛ. Pǝ́cɔ́ tɑ́ mɑɣɑmɑɣɑ tǝ wɛnɑ kɑlǝkǝŋ. ");
INSERT INTO dop_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ɩlɛnɑ pɑ́ sǝlǝmɩ Moisi sɩ ɩ hɑ-wɛɣɛ tɛtʋ ntɩ. Ɩ́ tɑɑ tɛsǝnɑ-wɛɣɛ Yɑɑtɑnɩ wɑɑlɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mpʋɣʋlɛ Moisi pɔɔsɑ-wɛ sɩ: Ɩsǝnɑɣɑlɛ mpʋ? Mǝ tɛɛtʋnɑɑ nɑ́ puki yoou ntɛ́ nɑ mɩɩ cɑɣɑ cǝnɛ tǝpɑmm nɑ? ");
INSERT INTO dop_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ye mɩɩ cɑɣɑnɑ cǝnɛ pɩɩ yɔɔlɩ pɛlɛ pɑ ɑpɑlʋtʋ, pɑ kɑɑ polo tɛtʋ nti Tɑcɑɑ hɑ-wɛ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Yɑɑsi kʋlʋm ɩnǝɣɩ mǝ cɑɑnɑɑ tɛmɑ lɑpʋ kɛ wɑɑtʋ wei mɑ kʋsɑ-wɛɣɛ Kɑtɛɛsɩ-Pɑɑneyɑ sɩ, pɑ́ polo pɑ feŋ Kɑnɑɑŋ tɛtʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Pɑ polɑ Ɩsǝkɔɔlɩ tɛtɛkǝlɛ tɑɑ nɑ pɑ́ cɔɔ-tɛ, nɑ pɑ́ mǝlɩ. Ɩlɛnɑ pɑ́ yɔɔlɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɑpɑlʋtʋ sɩ, pɑ́ tɑɑ sʋʋ tɛtʋ nti Tɑcɑɑ kɑ hɑ-mɛɣɛ hɑtoo lɔŋ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Hɑlɩ Tɑcɑɑ mʋ pɑ́ɑ́nɑ́ kɛ kʋyɑkʋ ŋkʋ nɑ ɩ́ tuu sɩ: ");
INSERT INTO dop_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Mǝ tǝnɑ mpɑ ɩ́ lɩɩ Icipiti nɑ ɩ́ wɛnɑ pɩɩsɩ hiu nɑ wɑɑlɩ tɔ, ɩ́ kɑɑ nɑ tɛtʋ nti mɑ sɩɩwɑ sɩ mɑ hɑɑkɩ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ tɔ. Mpi tɔ, ɩ́ tɑ́ nɩɩnɑ-m teu. ");
INSERT INTO dop_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Ye pǝ tɑɣɑ Kenɑsɩ lʋlʋɣʋ tʋ Yefune pǝyɑlʋ Kɑlɛpʋ, nɑ Nuŋ pǝyɑlʋ Yosuwee pɑ tike pɑɑ sʋʋnɑ. Pǝ tɑɣɑ pʋlʋ, mpɛ ɩnɩ pɑ nɩɩnɑ-m teu kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Pǝ tɔɔ kɛ́ Tɑcɑɑ mʋ pɑ́ɑ́nɑ́ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ tɔɣɔ pɩɩsɩ nɩɩlɛ tǝcu kɛ wʋlɑɣɑ tɛtʋ tɑɑ. Hɑlǝnɑ mpɑ ɩnɩ Ɩsɔ tɑɑ kpɑnɑ mpʋ tɔ, pɑ́ sɑɑlɩ yem kɛ́ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Ɩlɛnɑ ɑsɑɣɑɑ mɛ, ɩ́ cɑɑ sɩ ɩ́ tǝŋ mǝ cɑɑnɑɑ ɩkpɑtɛ nɑ ɩ́ kʋsɩ Tɑcɑɑ pɑ́ɑ́nɑ́ kɛ mǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ye Lupɛŋ nɑ Kɑtɩ nyǝ́mɑ mɛ, ɩ́ tɑ́ nɩɩnɑ Tɑcɑɑ, ɩ́lɛ́ ɩ yeki kɛ́ nɑ mǝ kʋyɛɛŋ tɑɣɑlɩ wʋlɑɣɑ tɛtʋ tɑɑ. Ɩlɛ ɩ́ wɑkǝlɑ Ɩsɛɣɛlɩ nyǝ́mɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Mpʋɣʋlɛ ɑpɑlɑɑ mpɛ pɑ kpǝtǝnɑ Moisi nɑ pɑ́ tɔ sɩ: Aɑɩ yoo, tɩɩ ŋmɑ́ tɑ́ kɑlǝkǝŋ kɛ tǝcɑɣɑlɛ, nɑ tɑ́ tɛɛsɩ nyǝ́mɑ kɛ koloosi ɑcɑlɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Ɩlɛnɑ tɑ́ yǝlɑɑ cɔɔsɩ tǝnɑ. Tɛtʋ nyǝ́mɑ ɩ́ tɑɑ pǝsɩ-wɛ. Pǝ wɑɑlɩ ɩlɛnɑ tǝ́ co tɑ́ yoou wontu tǝcɑʋ nɑ tǝ́ tɛɛ tɑ́ tɛɛtʋnɑɑ kɛ nɔɣɔ nɑ tǝ́ ponɑ-wɛɣɛ tɛtʋ nti pɑ hɑ-wɛ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Pɑɑ Ɩsɛɣɛlɩ tʋ wei ɩ kɑ́ cɑɣɑ ɩ tɛtʋ tɔɔ kɛ́ nɑ pǝ́cɔ́ tǝ mǝlɩ tɑ́ tɛ́. ");
INSERT INTO dop_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Ye tǝ hikɑ tɛtʋ nɑ pɔɣɔ nɑ cǝnɛ tɔɔ, pɑ́ tɑɑ tɑsɑ-tʋɣʋ tɛtʋ hɑʋ nɑ pɔɣɔ nɑ wɑɑlɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Ntɛnɑ Moisi sɩ: Ye ɩ tɔkɑ ɩsɩɩ ɩ yɔɣɔtʋɣʋ tɔ, nɑ ɩ́ suu mǝ yoou wontu, nɑ ɩ́ tɛsɩ Yɑɑtɑnɩ nɑ ɩ́ polo mǝ kolontunɑɑ tɔɔ, nɑ Tɑcɑɑ tʋ-wɛɣɛ mǝ niŋ tɑɑ, ");
INSERT INTO dop_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","22","ɩlɛ tɛtʋ tǝnɑ pǝsɩ mǝ nyǝntʋ. Wɑɑtʋ ɩnɩ Tɑcɑɑ yɑɑ mǝ tɛɛtʋnɑɑ tɑɑ kɑɑ kpɑnɑ-mɛ. Pǝyele Ɩsɔ kɑ́ yelinɑ-mɛɣɛ mǝ tɛtʋ tǝnɛ nɑ pɔɣɔ nɑ cǝnɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Amɑ ye ɩ́ tɑ́ lɑ́ mpʋ, ɩ́ kɑ́ pǝntǝnɑ Tɑcɑɑ, nɑ pǝ́ mǝlɩ mǝ nyɔɔŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Pǝ wɛ teu, ɩ́ ŋmɑ́ mǝ nyǝ́mɑ kɛ tɛɛsɩ nɑ mǝ tɔlɑ tǝtǝkǝlɛ. Amɑ ɩ́ tɑɑ sɔɔ nti mɑ yɔɣɔtɑɑ nɑ mɑ́ sɩɩ tɔɣɔ tɔkʋɣʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Mpʋɣʋlɛ Lupɛŋ nɑ Kɑtɩ pǝ nyǝ́mɑ cɔwɑ Moisi sɩ: Tɩɩ lɑ ɩsɩɩ n sɩɩʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Tɩɩ yele tɑ́ ɑlɑɑ nɑ tɑ́ piyɑ nɑ tɑ́ kɑlǝkǝŋ kɛ Kɑlɑɑtɩ ɑcɑlɛɛ tɑɑ, ");
INSERT INTO dop_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","nɑ tǝ́ kpɑɣɑ tɑ́ wontu nɑ tǝ́ polo Tɑcɑɑ yoou, ɩsɩɩ n yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Ḿpʋ́ɣʋ́ Moisi heelɑ pɑ tɔm kɛ kɔtʋlʋ Ɩlɑsɑɑ, nɑ Nuŋ pǝyɑlʋ Yosuwee, nɑ Ɩsɛɣɛlɩ kpekɑ nyɔɔŋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Ɩlɛnɑ ɩ́ tɔ-wɛ sɩ: Ye Kɑtɩ nɑ Lupɛŋ nyǝ́mɑ kpɑɣɑ yoou wontu, nɑ mǝ nɑ-wɛ ɩ́ tɛsɩ mǝ kolontunɑɑ wɑɑlɩ, ɩsɩɩ Tɑcɑɑ yɔɣɔtʋɣʋ tɔ, nɑ ɩ́ kǝlɩ-wɛ, ɩlɛ mɩɩ cɛlɛ-wɛɣɛ Kɑlɑɑtɩ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Amɑ ye pɑ kisɑ mpʋ ɩlɛ Kɑnɑɑŋ tɛtʋ kɛ mǝ tǝnɑ ɩ́ kɑ́ tɑlɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Ḿpʋ́ɣʋ́ Kɑtɩ nɑ Lupɛŋ pǝ nyǝ́mɑ tɑsɑ yɔɣɔtʋɣʋ sɩ: Tɩɩ lɑ nti Tɑcɑɑ heelɑ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Tɩɩ kpɑɣɑ tɑ́ wontu nɑ tǝ́ polo Tɑcɑɑ yoou, nɑ pɑ́ cɛlɛ-tʋɣʋ tɑ́ tɛtʋ nɑ Yɑɑtɑnɩ nɑ cǝnɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Ḿpʋ́ɣʋ́ Moisi cɛlɑ Kɑtɩ nɑ Lupɛŋ pɑ kpekɑ nɑ Yosɛɛfʋ pǝyɑlʋ Mɑnɑsee nyǝntɛ hɔɣɔlʋɣʋ kɛ Amolii wulɑʋ Sihoŋ, nɑ Pɑsɑŋ nyǝŋ Oki pɑ tɛtʋ nɑ pɑ ɑcɑlɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Ḿpʋ́ɣʋ́ Kɑtɩ nyǝ́mɑ ŋmɑwɑ koloosi kɛ Tipɔŋ nɑ Atɑlɔtɩ nɑ Alowɛɛ ");
INSERT INTO dop_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","nɑ Atǝlɔtɩ-Sofɑŋ nɑ Yɑsɛɛ nɑ Yokpɑhɑ ");
INSERT INTO dop_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","nɑ Pɛtɩ-Nimlɑ nɑ Pɛtɩ-Hɑlɑŋ pǝ ɑcɑlɛɛ. Nɑ pɑ́ ŋmɑ́ tɔtɔɣɔ pɑ tɔlɑ tǝtǝkǝlɛ. ");
INSERT INTO dop_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Ɩlɛnɑ Lupɛŋ nyǝ́mɑ ŋmɑ Hɛsǝpɔŋ nɑ Ɩlɑle nɑ Kiliyɑtɑyim ");
INSERT INTO dop_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","nɑ Nepo nɑ Pɑɑlɩ-Meyɔŋ nɑ Sipǝmɑ nɑ pɑ́ hɑ-yɛɣɛ hǝlɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Ḿpʋ́ɣʋ́ Mɑnɑsee pǝyɑlʋ Mɑkii nyǝ́mɑ nɑ́ yoonɑ Kɑlɑɑtɩ nyǝ́mɑ, nɑ pɑ́ tɔɣɔnɩ Amolii nyǝ́mɑ nɑ pɑ́ cɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Pǝ tɔɔ kɛ́ Moisi nɑ́ yelinɑ-wɛɣɛ-tɩ. ");
INSERT INTO dop_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Ɩlɛnɑ Mɑnɑsee pǝyɑlʋ Yɑyii nyǝ́mɑ nɑ́ɑ́ lɛɛkɩ Amolii nyǝ́mɑ ɑcɑlɛɛ lɛnnɑ, nɑ pɑ́ hɑ-yɛ sɩ Yɑyii ɑcɑlɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Pǝ wɑɑlɩ kɛ́ Nopɑ nɑ́ lɛɛkɑ Kenɑ ɩcɑtɛ nɑ pǝcɔlɔ nyǝnɑ, nɑ ɩ́ hɑ-yɛɣɛ ɩ hǝtɛ sɩ Nopɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Wɑɑtʋ wei Moisi nɑ Alɔŋ pɑ lǝsɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ cɑɑsɩ cɑɑsɩ tɔ, ɩsǝnɑ pɑ tɔmɑ tɔɣɔlɔ: ");
INSERT INTO dop_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Tɑcɑɑ kɑ heelɑ Moisi kɛ́ sɩ ŋmɑɑ timpi timpi ɩ́ sǝŋɑɑ tɔ, hɑlɩ lonɑ ɑnɩ ɑ hǝlɑ ntɔ. ");
INSERT INTO dop_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Pǝnɑɣɑ ɩsɔtʋ kɑncɑɑlɑɣɑ nyǝŋ kʋyɑkʋ nɑɑnʋwɑ nɑ kɑkpɑsɩ wule, kɛ Ɩsɛɣɛlɩ nyǝ́mɑ kʋlɑ Tɛɛʋ ɑcimɑ tɛʋ kʋfemuɣu kɛ Lɑmsɛsɩ nɑ pɑ́ tɛɛkɩ Icipiti nyǝ́mɑ ɩsɛntɑɑ tǝkɑɑ sɩ, pǝ cɛpɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Nɑ pɛlɛ pɑ́ tɔŋɑ pɑ kɑncɑɑlɑɣɑ piyɑ mpɑ Tɑcɑɑ kʋwɑ tɔɣɔ pim. Ɩ lɑpɑ ḿpʋ́ɣʋ́ sɩ pɑ nyɩ sɩ ɩ kǝlɑ pɑ tɩɩŋ kɛ toŋ. ");
INSERT INTO dop_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Pɑ kʋlɑ Lɑmsɛsɩ, ɩlɛnɑ pɑ́ siki Sukɔtɩ. ");
INSERT INTO dop_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Pɑ kʋlɑ Sukɔtɩ, ɩlɛnɑ pɑ́ siki Ɩtɑm kɛ wʋlɑɣɑ tɛtʋ nɔɣɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Pɑ kʋlɑ Ɩtɑm, ɩlɛnɑ pɑ́ polo Pi-Hɑhilotɩ kɛ Pɑɑlɩ-Sɛfʋŋ ɩsɛntɑɑ, nɑ pɑ́ siki Mikitɔɔlɩ pǝtɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Pɑ kʋlɑ Mikitɔɔlɩ, ɩlɛnɑ pɑ́ tɛsɩ teŋku nɑ pɑ́ sʋʋ wʋlɑɣɑ tɛtʋ nɑ pɑ́ tɔ́ kʋyɛɛŋ toosoɣo Ɩtɑm wʋlɑɣɑ tɛtʋ tɑɑ, nɑ pɑ́ tɑlɑ Mɑlɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Mɑlɑ kɛ pɑ kʋlɑɑ, nɑ pɑ́ polo Iliim, timpi hilɑ nɑɑnʋwɑ nɑ nɑɑlɛ, nɑ pɑɑŋ nɩɩtoso nɑ nɑɑnʋwɑ kɑ wɛɛ tɔ nɑ pɑ́ siki. ");
INSERT INTO dop_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Pɑ kʋlɑ Iliim, ɩlɛnɑ pɑ́ siki teŋku kʋsɛɛm nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Pɑ kʋlɑ teŋku nɔɣɔ, ɩlɛnɑ pɑ́ siki Siŋ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Pɑ kʋlɑ wʋlɑɣɑ tɛtʋ tɑɑ, ɩlɛnɑ pɑ́ siki Tɔfǝkɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Pɑ kʋlɑ Tɔfǝkɑ, ɩlɛnɑ pɑ siki Alusi. ");
INSERT INTO dop_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Pɑ kʋlɑ Alusi, ɩlɛnɑ pɑ́ siki Lefitim timpi pɑ lɑŋɑ lʋm kʋnyɔnyɔɔm tɔ. ");
INSERT INTO dop_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Pɑ kʋlɑ Lefitim, ɩlɛnɑ pɑ́ siki Holɛpʋ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Pɑ kʋlɑ Holɛpʋ, ɩlɛnɑ pɑ́ siki Kipǝloti-Tɑɑfɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Pɑ kʋlɑ Kipǝloti-Tɑɑfɑ, ɩlɛnɑ pɑ́ siki Hɑselɔtɩ. ");
INSERT INTO dop_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Pɑ kʋlɑ Hɑselɔtɩ, ɩlɛnɑ pɑ́ siki Litimɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Pɑ kʋlɑ Litimɑ, ɩlɛnɑ pɑ́ siki Limɔŋ-Pɛlɛsɩ. ");
INSERT INTO dop_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Pɑ kʋlɑ Limɔŋ-Pɛlɛsɩ, ɩlɛnɑ pɑ́ siki Lipinɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Pɑ kʋlɑ Lipinɑ, ɩlɛnɑ pɑ́ siki Lisɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Pɑ kʋlɑ Lisɑ, ɩlɛnɑ pɑ́ siki Kehɑlɑtɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Pɑ kʋlɑ Kehɑlɑtɑ, ɩlɛnɑ pɑ́ siki Sefɛɛ pʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Pɑ kʋlɑ Sefɛɛ pʋɣʋ, ɩlɛnɑ pɑ́ siki Hɑlɑtɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Pɑ kʋlɑ Hɑlɑtɑ, ɩlɛnɑ pɑ́ siki Mɑkelo. ");
INSERT INTO dop_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Pɑ kʋlɑ Mɑkelo, ɩlɛnɑ pɑ́ siki Tɑhɑtɩ. ");
INSERT INTO dop_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Pɑ kʋlɑ Tɑhɑtɩ, ɩlɛnɑ pɑ́ siki Telɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Pɑ kʋlɑ Telɑ, ɩlɛnɑ pɑ́ siki Mitikɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Pɑ kʋlɑ Mitikɑ, ɩlɛnɑ pɑ́ siki Hɑsemonɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Pɑ kʋlɑ Hɑsemonɑ, ɩlɛnɑ pɑ́ siki Moseloti. ");
INSERT INTO dop_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Pɑ kʋlɑ Moseloti, ɩlɛnɑ pɑ́ siki Pene-Yɑkɑŋ. ");
INSERT INTO dop_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Pɑ kʋlɑ Pene-Yɑkɑŋ, ɩlɛnɑ pɑ́ siki Hoo-Kitǝkɑtɩ. ");
INSERT INTO dop_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Pɑ kʋlɑ Hoo-Kitǝkɑtɩ, ɩlɛnɑ pɑ́ siki Yotǝpɑtɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Pɑ kulɑ Yotǝpɑtɑ, ɩlɛnɑ pɑ́ siki Apǝlonɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Pɑ kʋlɑ Apǝlonɑ, ɩlɛnɑ pɑ́ siki Ɩsiyoŋ-Kepɛɛ. ");
INSERT INTO dop_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Pɑ kʋlɑ Ɩsiyoŋ-Kepɛɛ, ɩlɛnɑ pɑ́ siki Kɑtɛɛsɩ kɛ Siŋ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Pɑ kʋlɑ Kɑtɛɛsɩ, ɩlɛnɑ pɑ́ siki Hoo pʋɣʋ, kɛ Ɩtɔm tɛtʋ toŋɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","39","Ḿpʋ́ɣʋ́ Tɑcɑɑ yelɑɑ nɑ kɔtʋlʋ Alɔŋ kpɑ Hoo pʋɣʋ tɑɑ. Ɩlɛnɑ ɩ́ sɩ́ tǝnɑɣɑ ɩsɔtʋ kɑkpɑsɩ nyǝŋ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ wule, kɛ ɩ pǝnɑɣɑ nɩɩnʋwɑ nɑ hiu nɑ tooso (123) nyǝŋkɑ tɑɑ. Pɑ Icipiti tɑɑ lɩɩʋ pǝnɑɣɑ nɩɩlɛ nyǝŋkɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Wɑɑtʋ ɩnǝɣɩ Kɑnɑɑŋ wulɑʋ wei pɑ yɑɑ sɩ, Alɑ nɑ ɩ kɑ wɛ ilim tǝlɩɩlɛ mpǝtǝŋ tɔɔ tɔ, ɩ nɩɩwɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɑtɛ. ");
INSERT INTO dop_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Ɩsɛɣɛlɩ nyǝ́mɑ kʋlɑ Hoo pʋɣʋ ɩlɛnɑ pɑ́ siki Sɑlǝmonɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Pɑ kʋlɑ Sɑlǝmonɑ, ɩlɛnɑ pɑ́ siki Punoŋ. ");
INSERT INTO dop_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Pɑ kʋlɑ Punoŋ, ɩlɛnɑ pɑ́ siki Opoti. ");
INSERT INTO dop_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Pɑ kʋlɑ Opoti, ɩlɛnɑ pɑ́ siki Ye-Apɑlim kɛ Mowɑpʋ toŋɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Pɑ kʋlɑ Ye-Apɑlim, ɩlɛnɑ pɑ́ siki Tipoŋ-Kɑtɩ. ");
INSERT INTO dop_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Pɑ kʋlɑ Tipoŋ-Kɑtɩ, ɩlɛnɑ pɑ́ siki Alǝmoŋ-Tipǝlɑtɑyim ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Pɑ kʋlɑ Alǝmoŋ-Tipǝlɑtɑyim, ɩlɛnɑ pɑ́ siki Apɑlim pulɑsɩ tɑɑ kɛ́ Nepo pʋɣʋ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Pɑ kʋlɑ Apɑlim pulɑsɩ, ɩlɛnɑ pɑ́ siki Mowɑpʋ tɛtɛkɑ tɑɑ kɛ́ Yɑɑtɑnɩ kiŋ kɛ Yeliko ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Tǝnɑɣɑ pɑ sikɑ pɑ cokɑ kɛ Pɛtɩ-Yesimɔtɩ nɑ Apɛɛlɩ-Sitim pǝ hɛkʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Ḿpʋ́ɣʋ́ Tɑcɑɑ tʋwɑ Moisi kɛ Mowɑpʋ tɛtɛkɑ tɑɑ kɛ́ Yɑɑtɑnɩ pɔɣɔ nɔɣɔ kɛ Yeliko ɩsɛntɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ ye ɩ́ tɛsɑ Yɑɑtɑnɩ nɑ ɩ́ sʋʋ Kɑnɑɑŋ nyǝ́mɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","Pǝ wɛɛ sɩ ɩ́ tɔɣɔnɩ tɛtʋ nyǝ́mɑ tǝnɑ nɑ ɩ́ yɔkɩ pɛɛ yɑɑ nyǝɣǝtʋ lɛɛsǝŋ wei ɩ́ lɑɑkɩ tɔ, nɑ pǝ tǝkɔtǝlɛnɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Nɑ ɩ́ lɛɛkɩ pɑ tɛtʋ ntɩ nɑ ɩ́ cɑɣɑ. Mpi tɔ, mɑ hɑ-mɛɣɛ tǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Tɛtɛ kɛ́ ɩ́ kɑ́ tɔ nɑ ɩ́ tɑlǝnɑ tɛtʋ ntǝɣɩ mǝ kpekɑ nɑ mǝ lʋlʋŋ, nɑ ɩ́ kɛɛsǝnɑ mǝ pɑɣɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Pǝ wɛɛ sɩ ɩ́ tɔɣɔnɩ tɛtʋ nyǝ́mɑ tǝnɑɣɑ. Tɔfɔ kʋkɑɑsɑɑ mǝlǝɣɩ mǝ kolontunɑɑ kɛ́ nɑ pɑ́ nɑɑsǝɣɩ-mɛ, ɩsɩɩ sɔwɑ kɛ ɩsǝpee tɑɑ, nɑ nyǝmɑ́ tǝpilɑ kɛ mǝ kɔŋkɔmǝŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ɩlɛ mɛɣɛ mɑɑ lɑnɑ, ɩsɩɩ mɑɑ sɩɩʋ sɩ mɑɑ lɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, wɑɑtʋ wei ɩ́ kɑ́ sʋʋ Kɑnɑɑŋ tɛtʋ nti mɑ hɑɑkɩ-mɛ tɔ tǝ tɑɑ tɔ, tǝ toosi ntɛ́ ");
INSERT INTO dop_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Siŋ wʋlɑɣɑ tɛtʋ nɑ Ɩtɔm nyǝntʋ nɑ pǝtɛɛ tɔɔ. Nɑ kɑ́ kpɑɣɑ teŋku kʋsǝpʋ, ");
INSERT INTO dop_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","nɑ kɑ́ mǝlǝnɑ pǝcɛsɩ pulɑsɩ tontoŋle pǝtɛɛ tɔɔ. Ɩlɛnɑ kɑ́ polo Siŋ, nɑ kɑ́ tiinɑ Kɑtɛɛsɩ-Pɑɑneyɑ pǝtɛɛ tɔɔ. Nɑ kɑ́ mǝlɩ Hɑsɑɑ-Atɑɑ nɑ Asǝmɔŋ. ");
INSERT INTO dop_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Nɑ kɑ́ kɛɛ nɑ kɑ́ yoosinɑ Icipiti lɔɔʋ, nɑ kɑ́ lɩɩ Metitelɑnee teŋku. ");
INSERT INTO dop_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Ilim tǝtʋlɛ tɔɔ toŋɑ ntɛ́ Metitelɑnee teŋku ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Ilim tǝlɩɩlɛ mpǝtǝŋ tɔɔ nyǝŋkɑ ntɛ́ teŋku kʋlʋm ɩnɩ, nɑ Hoo pʋɣʋ pǝ hɛkʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Ɩlɛnɑ kɑ́ lɩɩ Lepo-Hɑmɑtɩ nɑ Setɑ, ");
INSERT INTO dop_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","nɑ kɑ́ polo Sifǝloŋ, nɑ kɑ́ lɩɩ Hɑsɑɑ-Ɩnɑŋ. ");
INSERT INTO dop_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Ilim tǝlɩɩlɛ tɔɔ nyǝŋkɑ ntɛ́ pǝ kpɑɣɑʋ Hɑsɑɑ-Ɩnɑŋ nɑ Sefɑm tɛtʋ hɔɣɔlʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Ɩlɛnɑ kɑ́ mǝlǝnɑ Lipǝlɑ kɛ Ayiŋ ilim tǝlɩɩlɛ tɔɔ, nɑ kɑ́ tɛɛ pooluŋ nɑ kɑ́ polo kɑ yoosinɑ Kenɑsɑlɛtɩ kʋteŋ, ");
INSERT INTO dop_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","nɑ kɑ́ polo kɑ lɩɩ Yɑɑtɑnɩ lɔɔŋ, nɑ teŋku kʋsǝpʋ. Mǝ tɛtʋ tǝnɑsɩ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Ḿpʋ́ɣʋ́ Moisi tɛlǝsɑ tǝ tǝnɑɣɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ ɩ́ tɑsɑ-wɛɣɛ heeluɣu sɩ: Tɛtʋnɑɑ mpɑ Tɑcɑɑ tɔmɑ sɩ ɩ́ tɔ́ tɛtɛ nɑ ɩ́ tɑlɑ Ɩsɛɣɛlɩ kpekɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ nɑ hɔɣɔlʋɣʋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","15","Mpi tɔ, Lupɛŋ nɑ Kɑtɩ pɑ lʋlʋɣʋ nyǝ́mɑ nɑ Mɑnɑsee kpekǝle hɔɣɔlʋɣʋ lɛŋkʋ nɑ́ tɛmɑ pɛlɛ pɑ nyǝntʋ hikuɣu kɛ Yeliko ɩsɛntɑɑ kɛ Yɑɑtɑnɩ wɑɑlɩ nɑ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Kɔtʋlʋ Ɩlɑsɑɑ nɑ Nuŋ pǝyɑlʋ Yosuwee pɑɑ pɑɑsǝnɑ tɛtʋ tɑlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Pɑ́ kpɑ pɑɑ kpekǝle nte tǝ tɑɑ kɛ́ nyʋɣʋ tʋ wei ɩ kɑ́ pɑɑsǝnɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Mpɑ mpɑ pɑɑ kpɑ mpʋ tɔ pɑ hǝlɑ ntɔ: Yutɑ kpekǝle tɑɑ nyǝŋ ntɛ́ Yefune pǝyɑlʋ Kɑlɛpʋ. ");
INSERT INTO dop_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simiyɔŋ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Amihuti pǝyɑlʋ Semuwɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Pɛncɑmɛɛ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Kisiloŋ pǝyɑlʋ Ɩlitɑtɩ. ");
INSERT INTO dop_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Tɑŋ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Yokili pǝyɑlʋ Puki. ");
INSERT INTO dop_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yosɛɛfʋ pǝyɑlʋ Mɑnɑsee nyǝntɛ tɑɑ nyǝŋ ntɛ́ Ɩfoti pǝyɑlʋ Hɑnǝyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Yosɛɛfʋ pǝyɑlʋ nɑɑlɛ nyǝŋ Ɩfǝlɑyim nyǝntɛ tɑɑ nyǝŋ ntɛ́ Sifitɑŋ pǝyɑlʋ Kemuwɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Sɑpulɔŋ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Pɑɑnɑkɩ pǝyɑlʋ Ɩlisɑfɑŋ. ");
INSERT INTO dop_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Ɩsɑkɑɑ kpekǝle tɑɑ nyǝŋ ntɛ́ Asɑŋ pǝyɑlʋ Pɑlǝtǝyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Asɛɛ nyǝntɛ tɑɑ nyǝŋ ntɛ́ Selomitɩ pǝyɑlʋ Ahihuti. ");
INSERT INTO dop_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Nefǝtɑli nyǝntɛ tɑɑ nyǝŋ ntɛ́ Amihuti pǝyɑlʋ Petɑyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Mpɑ Tɑcɑɑ lǝsɑɑ sɩ pɑ́ tɑlɑ Kɑnɑɑŋ tɛtʋ kɛ Ɩsɛɣɛlɩ kpekɑ nyǝ́mɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ yɔɣɔtɑ Moisi kɛ Mowɑpʋ tɛtɛkǝlɛ tɑɑ, kɛ Yɑɑtɑnɩ pɔɣɔ nɔɣɔ kɛ Yeliko ɩsɛntɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","3","Tʋ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ pɑ́ cɛlɑ Lefii nyǝ́mɑ kɛ ɑcɑlɛɛ nnɑ pɑ lǝsɑ pɑ tɛtʋnɑɑ tɑɑ tɔ, nɑ pǝ nɔnɔkilɑ. Nɑ pɑ́ cɑɣɑ ɑcɑlɛɛ tɑɑ nɑ pɑ́ tiikiɣi pɑ tɔlɑ kɛ hɑlǝmnɑɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","5","Ɩsǝnɑ ɩ́ kɑ́ mɑɣɑsɩ nɔnɔkilɑ ɑnɩ ɑ wɑŋ tɔɣɔlɔ: Pǝ sɩɩnɑʋ ɩcɑtɛ koloosi nɑ pǝ́ pukinɑ ilim tǝlɩɩlɛ tɔɔ tɔɣɔ mɛɛtǝlǝnɑɑ nɑsǝlɛ nɑ nɩɩnʋwɑ (500), nɑ ilim tǝtʋlɛ tɔɔ kɛ́ mpʋ. Pǝ mpǝtǝŋ nɑ pǝ ntɔɣɔŋ tɔɔ tɔtɔɣɔ mpʋ. Ɩlɛnɑ ɩ́ mɑɣɑsɩ pɑɑ hɔɣɔlʋɣʋ ŋku kʋ tɔɔ kɛ́ mɛɛtǝlǝnɑɑ iyɑɣɑ (1000) ɩyɑɣɑ (1000) kɛ tɔm liɣiti nɑ pǝ́ cɔɔ ɩcɑtɛ nɑ pǝ́ tɑ. ");
INSERT INTO dop_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Nɑ pɑ́ cɛlɑ Lefii nyǝ́mɑ kɛ ɑcɑlɛɛ nɑɑtoso. A tɑɑ kɛ́ ye pǝ yʋkǝnɑ yʋlʋ nɑ ɩ́ kʋ ɩ tɔɣɔntǝlɛ ɩ kɑ́ tʋ kpʋlʋɣʋ. Nɑ pǝ́ sɔɔsɩ ɑcɑlɛɛ nɩɩlɛ nɑ nɑɑlɛ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Pǝ kpɛntɑ ɑcɑlɛɛ pǝlefɛɩ nɑɑnʋwɑ nɑ pǝ nɔnɔkilɑ. ");
INSERT INTO dop_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Pɑɑ kpekǝle nte tɩɩ hɑ Lefii nyǝ́mɑ kɛ́ nɑ pǝ́ kɛɛsǝnɑ tǝ tɛtʋ tɔɔʋ. ");
INSERT INTO dop_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Moisi sɩ: ");
INSERT INTO dop_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ, ye ɩ́ tɛsɑ Yɑɑtɑnɩ nɑ ɩ́ sʋʋ Kɑnɑɑŋ tɛtʋ tɑɑ, ");
INSERT INTO dop_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ɩlɛ ɩ́ lǝsɩ ɑcɑlɛɛ wenɑ ɩ́ kɑ́ lɑ yʋlʋkʋlɑɑ mpɑ pǝ yʋkǝnɑɑ tɔ pɑ kpʋlʋɣʋ tǝtʋlɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Nɑ pɛlɛ pɑ yǝlɑɑ ɩ tɑɑ lɛɛtɩ-wɛ nɑ pɑ́ tɑ́ hʋʋtɑ pɑ tɔm. ");
INSERT INTO dop_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Acɑlɛɛ nɑɑtoso kɛ ɩ́ kɑ́ lǝsɩ. ");
INSERT INTO dop_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Tooso nɑ Yɑɑtɑnɩ ilim tǝlɩɩlɛ tɔɔ, nɑ tooso kɛ Kɑnɑɑŋ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ye Ɩsɛɣɛlɩ tʋ yɑɑ cɑɣɑlʋ kɛ pǝ yʋkǝnɑɑ nɑ ɩ́ kʋ́ yʋlʋ, ɩlɛ pʋntʋ se nɑ ɩ́ polo ɑ tɑɑ nɑtǝlɩ tǝ tɑɑ, nɑ ɩ́ tʋ́ kpʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","Ye nɔɣɔlʋ mɑpɑ ɩ tɔɣɔntǝlɛ kɛ nyǝɣǝlʋɣʋ yɑɑ kpɑ́tʋ́ɣʋ́, yɑɑ ɩ yɑɣɑ-ɩ pǝlɛ nɑ ɩ́ sɩ. Ɩ kɛ́ yʋlʋkʋlʋ kɛ́, pǝ wɛɛ sɩ pɑ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Sǝtʋ yʋlʋ siɣisiɣi kɑ́ pɛɛkǝnɑ kʋlʋ nɑ ɩ́ lɛɛtɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","21","Ye kʋlʋ kɑ tɔkǝnɑ-ɩ nɑ nɑtǝlɩ kɛ ɩ tɑɑ, yɑɑ pɑ wɛnɑ tǝmɑ nɑ koluŋɑ, ɩlɛnɑ ɩ́ mɑpɩ-ɩ ŋkumle, yɑɑ ɩ́ tusi-ɩ, yɑɑ ɩ́ yɑɣɑ-ɩ pʋlʋ nɑ ɩ́ sɩ́. Ɩ kɛ́ yʋlʋkʋlʋ kɛ́, pǝ wɛɛ sɩ lɛɛtǝlʋ ɩ́ hikɑ-ɩ ɩ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","23","Ntɑnyɩ pǝ yʋkǝɣǝnɑ yʋlʋ nɑ ɩ́ tusi lɛlʋ, yɑɑ pǝlɛ, yɑɑ pʋlʋ fiti ɩ niŋ tɑɑ nɑ pǝ́ yɑɣɑ-ɩ. Pǝ́cɔ́ pɑ tɑɑ yoo, yɑɑ ɩ tɔkɑ-ɩ nɑ ɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","Ɩlɛ hʋʋlɑɑ kɑ tǝŋ pǝ kʋsǝsɩɩtʋ kɛ́, nɑ pɑ́ hʋʋ pɑ tɔm ntɩ. ");
INSERT INTO dop_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Nɑ pɑ́ kenti kʋlʋ tɔɔ nɑ pɑ́ mǝŋnɑ-ɩ ɩ kpǝlʋɣʋ tǝtʋlɛ, nɑ ɩ́ sɑɑlɩ tǝnɑ. Hɑlǝnɑ kɔtʋlʋ sɔsɔ wei ɩ lɑkɩ tǝmlɛ kɛ wɑɑtʋ ɩnɩ tɔ ɩ sǝm. ");
INSERT INTO dop_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Amɑ ye ɩ lɩɩwɑ ɩcɑtɛ ntɛ tǝ tɑɑ nɑ ɩ́ tɛsɩ tǝ toŋɑ ");
INSERT INTO dop_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","nɑ lɛɛtʋlʋ hiki-ɩ, ɩ́ nɔkɑɑ ɩ kʋɣʋ-ɩ kɛ́ nɑ ɩ tɔm tɑ sɩ. ");
INSERT INTO dop_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Pǝ nyʋɣʋ ntɛ́ sɩ kʋlʋ ɩ cɑɣɑ kpʋlʋɣʋ tǝtʋlɛ tǝnɑ, hɑlǝnɑ kɔtʋlʋ sɔsɔ sǝm. Pǝlɛ pǝ wɑɑlɩ kɛ́ ɩ pǝsǝɣɩ nɑ ɩ́ lɩɩ nɑ ɩ́ mǝlɩ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Pɑɑ leɣe ɩ́ wɛɛ, yɑɑsi ɩnǝɣɩ mǝnɑ mǝ piyɑ piyɑ ɩ́ kɑ́ tɔkɩ. ");
INSERT INTO dop_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ɩ́ kɑɑ mʋ yʋlʋ kʋlʋm ɑseetɑ nɑ ɩ́ kʋnɑ yʋlʋkʋlʋ tɔm. Pǝ wɛɛ sɩ pɑ́ tɑlɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Pǝ fɛɩ sɩ ɩ́ mʋ kʋhɑʋ nɑ ɩ́ yele yʋlʋkʋlʋ kɛ kʋɣʋ. Pǝ wɛɛ sɩ ɩ́ kʋ-ɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Pǝ fɛɩ tɔtɔ sɩ ɩ́ mʋ kʋhɑʋ nɑ ɩ́ tʋ́ yʋlʋkʋlʋ kɛ kpʋlʋɣʋ tǝtʋlɛ nɑ kɔtʋlʋ sɔsɔ sɩ́, ɩlɛnɑ ɩ́ mǝlǝnɑ-ɩ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Yʋlʋkʋlɛ pilisiɣi tɛtʋ kɛ́. Ɩlɛ pǝ fɛɩ sɩ ɩ́ pilisi tɛtʋ nti tǝ tɑɑ ɩ́ wɛɛ tɔ. Ye yʋlʋ kʋwɑ ɩ tɔɣɔntǝlɛ, pǝ wɛɛ sɩ pɑ́ kʋ́ ɩnǝɣɩ nɑ pǝ́cɔ́ pǝ́ kpiisi pǝ ɑsilimɑ. ");
INSERT INTO dop_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Pǝ fɛɩ sɩ ɩ́ pilisi mǝ tɛtʋ. Mpi tɔ, Tɑcɑɑ mɑ́, mɑ wɛ mǝ hɛkʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Ḿpʋ́ɣʋ́ Yosɛɛfʋ pǝyɑlʋ Mɑnɑsee, nɑ Mɑnɑsee pǝyɑlʋ Mɑkii, nɑ Mɑkii pǝyɑlʋ Kɑlɑɑtɩ lʋlʋɣʋ nyɔɔŋ nyǝ́mɑ polɑ Moisi nɑ Ɩsɛɣɛlɩ kpekɑ nyɔɔŋ nyǝ́mɑ kiŋ ");
INSERT INTO dop_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","nɑ pɑ́ tɔ sɩ: Wɑɑtʋ wei Tɑcɑɑ tʋwɑ Moisi sɩ ɩ́ tɔ tɛtɛ nɑ ɩ́ tɑlɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ tɛtʋ tɔ, ɩ sɩɩwɑ tɔtɔ sɩ, ɩ́ cɛlɑ tɑ́ tɛɛtʋ Selofɑtɩ tɛtʋ kɛ ɩ pɛɛlɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Amɑ ye pɑ sɑɑwɑ kpekǝle lɛntɛ tɑɑ, pɑ tɛtʋ pɑsǝɣɩ tɑ́ kpekǝle nyǝntʋ tɔɔ kɛ́ nɑ pǝ́ sɔɔsɩ lɛntɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Nɑ pǝ́ kɔmɑ nɑ pǝ́ tɑlɑ cɛpʋ pǝnɑɣɑ, pɑ nyǝntʋ lɩɩ tǝkpɑtɑɑ kɛ́ tɑ́ kpekǝle tɔɔ nɑ pǝ́ sɔɔsɩ pɑ nyǝntɛ kʋfɑtɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Mpʋɣʋlɛ Tɑcɑɑ heelɑ Moisi sɩ: Tɛlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ Yosɛɛfʋ lʋlʋɣʋ nyǝ́mɑ wɛnɑ tɑmpɑnɑ. ");
INSERT INTO dop_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ye pɑ sɔɔlɑ wei pɑ sɑɑ-ɩ. Amɑ pɩɩ wɛɛ pɑ kpekǝle tɑɑ tʋ́ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","9","Ɩlɛ pɑɑ kpekǝle nte tǝ tɛtʋ kɑ́ cɑɣɑ tǝ tǝcɑɣɑlɛ, tǝ kɑɑ sɔɔsɩ lɛntɛ nyǝntʋ tɔɔ. Mpʋ tɔtɔɣɔ ye kpekǝle nɑtǝlɩ tǝ ɑlʋ nɔɣɔlʋ ɩ wɛnɑ tɛtʋ pǝ wɛɛ sɩ ɩ́ sɑɑ ɩ cɑɑ kpekǝle lʋlʋɣʋ tʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","11","Ḿpʋ́ɣʋ́ Selofɑtɩ pɛɛlɑɑ Mɑlɑ nɑ Tiisɑ nɑ Hokǝlɑ nɑ Milikɑ nɑ Nowɑ pɑ sɑɑwɑ pɑ cɑɑ tɑɑlʋnɑɑ pǝyɑlɑɑ kɛ pɑ kpekǝle tɑɑ, ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Yosɛɛfʋ pǝyɑlʋ Mɑnɑsee lʋlʋɣʋ nyǝ́mɑ ntɛ́. Ɩlɛnɑ pɑ tɛtʋnɑɑ nti pɑ hikɑɑ tɔ tǝ́ sɑɑlɩ pɑ cɑɑ kpekǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Kiiŋ nɑ kʋsǝsɩɩtʋ nti Tɑcɑɑ tɛlǝsɑ Ɩsɛɣɛlɩ nyǝ́mɑ, nɑ Moisi nɔɣɔ kɛ Mowɑpʋ tɛtɛkǝlɛ tɑɑ, kɛ́ Yɑɑtɑnɩ nɔɣɔ kɛ Yeliko ɩsɛntɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Tɔmnɑɑ mpɑ mpɑ Moisi heelɑ Ɩsɛɣɛlɩ yǝlɑɑ tǝnɑɣɑ wʋlɑɣɑ tɛtʋ tɑɑ, nɑ pǝ́cɔ́ pɑ́ tɛsǝɣɩ Yɑɑtɑnɩ pɔɣɔ kɛ Sufɩ ɩsɛntɑɑ, nɑ Pɑlɑŋ nɑ Tofɛlɩ nɑ Lɑpɑŋ nɑ Hɑsɑlɔti nɑ Ti-Sɑhɑpɩ pɑ hɛkʋ tɑɑ tɔɣɔlɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Pɑ lɩɩʋ Holɛpʋ nɑ pɑ́ kpɑɣɑ Ɩtɔm pʋɣʋ mpɑɑʋ tɔ, kʋyɛɛŋ nɑɑnʋwɑ nɑ kʋlʋmʋɣʋ kɛ pɑ lɑpɑ, hɑlǝnɑ Kɑtɛɛsɩ-Pɑɑneyɑ. ");
INSERT INTO dop_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Pɑ Icipiti lɩɩʋ pǝnɑɣɑ nɩɩlɛ nyǝŋkɑ, ɩsɔtʋ nɑɑnʋwɑ nɑ kʋlʋm nyǝŋ kʋyɑkʋ kɑncɑɑlɑɣɑ nyǝŋkʋ tɑɑ kɛ́ Moisi heelɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ nti Tɑcɑɑ kɑ tʋ-ɩ sɩ ɩ́ tɛlǝsɩ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Wɑɑtʋ wei ɩ yoowɑ nɑ ɩ́ kǝlɩ Amolii nyǝ́mɑ wulɑʋ Sihoŋ wei ɩ kɑ wɛ Hɛsǝpɔŋ ɩcɑtɛ tɑɑ tɔ, nɑ Pɑsɑŋ nyǝŋ Oki wei ɩ tɔkɑɣɑ kɑwulɑɣɑ kɛ Asetɑloti nɑ Ɩtǝlei pɑ ɑcɑlɛɛ tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Sɑɑ wei pɑ wɛ Mowɑpʋ tɛtʋ tɑɑ, nɑ pɑ́ tɑ tɛsǝtɑ Yɑɑtɑnɩ pɔɣɔ tɔɣɔ Moisi cɑɑlɑ kʋsǝsɩɩtʋ tǝnɛ tǝ tɔm kɛ sɛɣɛsʋɣʋ sɩ: ");
INSERT INTO dop_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Wɑɑtʋ wei tɩɩ wɛ Holɛpʋ pʋɣʋ kiŋ tǝnɑ tɔɣɔ Tɑcɑɑ yɔɣɔtɑɑ sɩ, tǝ tɑɑŋɑ tǝnɑ tǝcɑm. ");
INSERT INTO dop_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Pǝ tɔɔ tɔ, tǝ́ kpɛsɩ nɑ tǝ́ polo pulɑsɩ hɔɣɔlǝŋ tɑɑ timpi Amolii nyǝ́mɑ wɛɛ tɔ. Nɑ pǝ cɔlɔ Kɑnɑɑŋ nyǝ́mɑ tɛtʋnɑɑ tɑɑ kɛ́ pǝ kpɑɣɑʋ Yɑɑtɑnɩ kɑcǝkɑ, nɑ pulɑsɩ hɔɣɔlʋɣʋ, nɑ tɛtɛkǝlɛ, nɑ Nekɛfɩ, nɑ teŋku Metitelɑnee ɩmɑlɑʋ kɛ Kɑnɑɑŋ nyǝ́mɑ tɛtʋ tɑɑ tɔ. Nɑ Lipɑŋ, hɑlǝnɑ pɔɣɔ sɔsɑɣɑ Ɩfǝlɑtɩ. ");
INSERT INTO dop_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ɩ́ nɑwɑɑ, mǝ niŋ tɑɑ kɛ́ mɑ tʋ́ tɛtʋ tǝnɑ. Mpʋ tɔ, ɩ́ polo nɑ ɩ́ mʋ-tɩ. Tɑcɑɑ kɑ yɔɣɔtǝnɑ tuunɑʋ kɛ́ sɩ ɩ kɑ́ hɑ-tǝɣɩ mǝ cɑɑnɑɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ, nɑ pɛlɛ pɑ lʋlʋɣʋ nyǝ́mɑ tǝnɑɣɑ pɑ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Ḿpʋ́ɣʋ́ Moisi tɔmɑ sɩ: Mɑɑ heelɑ-mɛɣɛ Holɛpʋ pʋɣʋ kiŋ sɩ mɑɑ pǝsǝɣɩ nɑ mɑ́ pɑɑsǝnɑ-mɛɣɛ mɑ tike. ");
INSERT INTO dop_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Mpi tɔ, Tɑcɑɑ mǝ Ɩsɔ lɑpɑɣɑ nɑ ɩ́ huki, nɑ sɑŋɑ tɑɑ ɩ́ wɛ pɑɣɑlɛ ɩsɩɩ ɩsɔtʋlʋŋɑsɩ. ");
INSERT INTO dop_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Mǝ cɑɑnɑɑ Ɩsɔ Tɑcɑɑ ɩ́ yele nɑ ɩ́ sɔɔsɩ hukuɣu kɛ tɔm iyɑɣɑ (1000). Nɑ ɩ́ kooli-mɛɣɛ kʋpɑntʋ ɩsɩɩ ɩ kɑ sɩɩʋ nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Ɩsǝnɑɣɑ mɑɑ pǝsɩ mɑ tike nɑ mɑ́ sǝɣǝlɩ mǝ sǝɣǝlɑ nɑ mǝ wɑhɑlɑnɑɑ nɑ mǝ yooŋ? ");
INSERT INTO dop_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Ɩ́ lǝsɩ mǝ kpekɑ tɑɑ kɛ́ lǝmɑɣɑsɛɛ nyǝ́mɑ nɑ mpɑ pɑ nyǝ́mɑ yɑɑsi nɑ pɑ hǝtɛ yɑɑwɑ tɔ, nɑ mɑ́ kpɑ-wɛɣɛ mǝ nyʋɣʋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Hɑlɩ ɩ́ cɔ-m sɩ mɑ kʋmɑɣɑsǝtʋ ntɩ tǝ wɛ teu. ");
INSERT INTO dop_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Ḿpʋ́ɣʋ́ mɑ kpɑ mpɛ ɩnɩ pɑ tɑɑ lǝmɑɣɑsɛɛ nyǝ́mɑ mpɑ pɑ hǝlɑ yɑɑwɑ tɔɣɔ yǝlɑɑ iyɑɣɑ (1000) nyʋɣʋ nyǝ́mɑ, nɑ nɩɩnʋwɑ (100) nyʋɣʋ nyǝ́mɑ, nɑ nɩɩlɛ nɑ nɑɑnʋwɑ nyʋɣʋ nyǝ́mɑ, nɑ nɑɑnʋwɑ nyʋɣʋ nyǝ́mɑ. Nɑ mɑ́ kpɑ mpɑ pǝ kɑɑsɑɑ tɔ pɑ tɑɑ kɛ́ pɑɑ kpekǝle nte tǝ ɑkewenɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Ɩlɛnɑ mɑ́ tʋ́ mǝ tɔm hʋʋlɑɑ sɩ ye tɔm mɑɣɑnɑ mǝ tɛɛtʋnɑɑ kɛ pɑ tɑɑ pɑ tike, yɑɑ mǝ nɑ cɑɣɑlɑɑ, ɩ́ welisi tǝ tɑɑ kɛ́ teu nɑ ɩ́ tǝŋ ɩsǝnɑ tɑmpɑnɑ sǝŋɑɑ tɔ, nɑ ɩ́ hʋʋ-tɩ. ");
INSERT INTO dop_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ɩ́ tɑɑ fɑɣɑsɩ yǝlɑɑ kɛ mǝ hʋʋlɛnɑɑ tɑɑ. Pɑɑ toŋtʋ pɑɑ kʋnyɔntʋ, pǝ wɛɛ sɩ ɩ́ nɩɩnɑ-wɛɣɛ. Ɩ́ tɑɑ see yǝlɑɑ. Mpi tɔ, Ɩsɔ hǝtɛ tɑɑ kɛ́ ɩ́ hʋʋkǝnɑ. Nti tǝ́ wɛ-mɛɣɛ kɑtɛ ɩlɛ ɩ́ kɔnɑ-tɩ nɑ mɑ́ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Wɑɑtʋ ɩnǝɣɩ mɑ tʋ-mɛɣɛ nti nti ɩ́ kɑ́ lɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Pǝ wɑɑlɩ kɛ́ tǝ kʋlɑ Holɛpʋ pʋɣʋ ɩsɩɩ Tɑcɑɑ kɑ́ heeluɣu-tʋ tɔ, nɑ tǝ́ fɑɣɑ wʋlɑɣɑ tɛtʋ ɑnɑɑm ɑsolɑ nyǝntʋ ntɩ, ɩsɩɩ ɩ́ nyǝm tɔ. Amolii nyǝ́mɑ pʋɣʋ mpɑɑʋ kɛ tǝ kpɑɣɑɑ nɑ tǝ́ tɑlɑ Kɑtɛɛsɩ-Pɑɑneyɑ. ");
INSERT INTO dop_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Hɑlɩ mɑ heelɑ-mɛ sɩ ɩ́ tɑpɑ Amolii nyǝ́mɑ pʋɣʋ ŋku tɑ́ Ɩsɔ Tɑcɑɑ hɑ-tʋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Ɩsɔ tʋwɑ tɛtʋ tǝnɑɣɑ mǝ niŋ tɑɑ kɛ́. Ɩ́ kʋlɩ nɑ ɩ́ mʋ-tɩ nɑ tǝ́ pǝsɩ mǝ nyǝntʋ, ɩsɩɩ mǝ cɑɑnɑɑ Ɩsɔ Tɑcɑɑ kɑ heeluɣu-mɛ tɔ. Ɩ́ tɑɑ nyɑ́. Pǝyele mǝ lɑŋɑ ɩ́ tɑɑ ŋmɑɑ pɑɑ pǝcɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Tǝnɑɣɑ mǝ tǝnɑ ɩ́ kɔmɑ mɑ kiŋ nɑ ɩ́ tɔŋ sɩ: Tǝ́ tili ɑpɑlɑɑ kɛ tɑ́ nɔɣɔ tɔɔ, nɑ pɑ́ feŋ tɛtʋ ntɩ nɑ pɑ́ hʋ́lɩ́-tʋɣʋ mpɑɑʋ ŋku tɩɩ kpɑɣɑ tɔ. Nɑ ɑcɑlɛɛ nnɑ nnɑ tɩɩ tɑlɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Ḿpʋ́ɣʋ́ mɑ sɑmɑ mǝ lǝmɑɣɑsɛɛ ɑnɩ. Ɩlɛnɑ mɑ́ lǝsɩ mǝ kpekɑ tɑɑ kɛ́ yʋlʋ yʋlʋ kɛ́ yǝlɑɑ nɑɑnʋwɑ nɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Mpɛ ɩnɩ pɑ tɛɛnɑ nɑ pɑ́ fɑɣɑnɑ pʋɣʋ tɑɑ. Hɑlǝnɑ Ɩsǝkɔɔlɩ tɛtɛkǝlɛ nɑ pɑ́ feŋ-tɩ. ");
INSERT INTO dop_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Ḿpʋ́ɣʋ́ pɑ koolɑ tɛtʋ ntɩ tǝ tɑɑ kʋlʋlʋm nɑ pɑ́ kpɛŋnɑ. Nɑ pɑ́ kɛɛsɩ-tʋ sɩ tɛtʋ kʋpɑntʋ kɛ tɑ́ Ɩsɔ Tɑcɑɑ hɑɑkɩ-tʋ. ");
INSERT INTO dop_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Pɑɑ nɑ mpʋ tɔ, ɩ́ lɑpɑ lɑŋkpɩɩsǝŋ nɑ ɩ́ kisi tǝ tɑɑ kɛ́ pote ɩsɩɩ mǝ Ɩsɔ Tɑcɑɑ kɑ heeluɣu-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Hɑlǝnɑ ɩ́ sʋʋ kʋntʋɣʋ kɛ mǝ cokɑ tɑɑ sɩ: Tɑcɑɑ ɩɩ cɑɑkɩ-tʋ tɔɣɔ ɩ lǝsɑ-tʋɣʋ Icipiti nɑ ɩ́ kɔnɑ-tʋɣʋ Amolii nyǝ́mɑ tɛtʋ tɑɑ sɩ pɛlɛ pɑ́ wɑkǝlɩ-tʋ. ");
INSERT INTO dop_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Ɩlɛnɑ ɩ́ tɑsǝɣɩ sɩ tǝ polo le? Mǝ tɛɛtʋnɑɑ nɑ́ yɔɔlɑ mǝ ɑpɑlʋtʋ sɩ: Tɛtʋ ntɩ tǝ yǝlɑɑ tɑɣɑlɑɑ kɛ́. Pǝyele pɑ kǝlɑ-tʋ, nɑ pɑ ɑcɑlɛɛ kɛ́ sɔsɔɔnɑ nɑ ɑ koloosi kɑlǝsǝnɑ ɩsɔtɔnʋɣʋ. Hɑlɩ tǝ tɩɩ nɑ́ ɑ tɑɑ kɛ́ Anɑkɩ tooko lʋlʋɣʋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Mɑ heeliɣi-mɛ sɩ ɩ́ tɑɑ seliɣinɑ-wɛ. Pɑ tɔm ɩ́ tɑɑ kpɑ-mɛɣɛ sɔɣɔntʋ. ");
INSERT INTO dop_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Tɑcɑɑ mǝ Ɩsɔ wei ɩ wɛ mǝ nɔɣɔ tɔɔ tɔ, ɩ mɑɣɑmɑɣɑ ɩ kɑ́ yoonɑ mǝ nɔɣɔ. Ɩsɩɩ ɩ tɛm lɑpʋ nɑ ɩ́ nɑnɑ mǝ ɩsɛ kɛ Icipiti ");
INSERT INTO dop_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","nɑ wʋlɑɣɑ tɛtʋ tɑɑ tɔ. Tǝnɑɣɑ ɩ pɑɑsǝnɑ-mɛ ɩsɩɩ yʋlʋ nʋkʋɣʋ ɩ pu tɔɣɔ mǝ mpɑɑʋ tǝnɑ tɑɑ. Hɑlǝnɑ mǝ tɑtɛ kɛ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Pɑɑ nɑ mpʋ tɔ, ɩ́ tɑ́ tʋ́ nɑɑni kɛ́ Tɑcɑɑ mǝ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Pǝyele ɩnɩ ɩ kɑ tɔŋɑɣɑnɑ mǝ nɔɣɔ tɔɔ. Nɑ ɩ pɛɛkǝɣɩ-mɛɣɛ tǝsʋʋlɛnɑɑ kɛ mǝ tɔntɛ wɑɑtʋ. Nɑ ɩ́ hʋlǝɣɩ-mɛɣɛ kɔkɔ kɛ ɑhoo, nɑ ɩ́ nɑɑkɩ mpɑɑʋ. Ilim ɩlɛnɑ ɩ́ wɛɛ ŋmʋntʋɣʋ tɑɑ nɑ mɩ́ɩ́ tǝŋǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Tɑcɑɑ nɩ́ɩ́ mǝ kʋntʋɣʋ, ɩlɛnɑ pɑ́ɑ́nɑ́ kpɑ-ɩ nɑ ɩ́ yɔɣɔtɩ nɑ ɩ́ tuu sɩ: ");
INSERT INTO dop_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Yǝlɑɑ mɛ ɩ́ kǝlɑ ɩsɑɣɑtʋ. Pǝ tɔɔ kɛ́ pɑ lʋlʋɣʋ looŋɑ kɑnɛ, kɑ tɑɑ nɔɣɔlʋ kɑɑ sʋʋ tɛtʋ kʋpɑntʋ nti mɑ tuuwɑ sɩ mɑɑ hɑ mǝ cɑɑnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Ye pǝ tɑɣɑ Yefune pǝyɑlʋ Kɑlɛpʋ pɑɑsi. Ɩ́ nɑ ɩ lʋlʋɣʋ nyǝ́mɑ kɛ mɑ́ɑ́ hɑ tɛtʋ nti ɩ́ feŋɑ mpʋ tɔɣɔ timpi ɩ nɩɩnɑ-m teu tɔ. ");
INSERT INTO dop_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Tɑcɑɑ mʋnɑ Moisi mɑɣɑ pɑ́ɑ́nɑ́ kɛ mǝ tɔɔ, hɑlǝnɑ ɩ́ tɔ sɩ mɑ kɑɑ fɛlɩ nɔɔhǝlɛ kɛ tɛtʋ ntɩ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Amɑ Nuŋ pǝyɑlʋ Yosuwee wei ɩ kɛ́ mɑ tǝmlɛ tʋ tɔ ɩ tike ɩ kɑ́ ponɑ. Mɑɑ sɔɔsɩ-ɩ ɑpɑlʋtʋ. Mpi tɔ ɩnɩ ɩ kɑ́ yelinɑ nɑ tɛtʋ ntɩ tǝ́ pǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Mǝ piyɑ mpɑ pɑ ɩsɛ tɑ nyɑɑlǝtɑ ɩsǝntɔ, nɑ ɩ́ tɔŋ sɩ kolontunɑɑ kɑ́ pɑ́ɑ́nɑ́ tɔ, mpɛ pɑ́ɑ́ sʋʋnɑ tǝ tɑɑ. Mpi tɔ, mpɛɣɛ mɑ́ɑ́ hɑ-tɩ, nɑ tǝ́ pǝsɩ pɑ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Amɑ mɩ́ɩ́ kɛɛsɩ ɩsɛ nɑ ɩ́ fɑɣɑnɑ wʋlɑɣɑ tɛtʋ tɑɑ, nɑ ɩ́ polo teŋku kʋsɛɛm. ");
INSERT INTO dop_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Tǝnɑɣɑ ɩ́ cɔwɑ sɩ: Hɑɩ, tɑ́ tɔm sǝpǝnɑ Tɑcɑɑ. Pǝnɛntɛ tɩɩ kpɑ pɑ tɔɔ nɑ tǝ́ yoonɑ-wɛ ɩsɩɩ tɑ́ Ɩsɔ yɔɣɔtʋɣʋ tɔ. Mpʋɣʋlɛ pɑɑ mǝ tɑɑ wei ɩ kpɑɣɑ ɩ yoou wontu nɑ ɩ́ lǝlɩ nɑ ɩ́ mɑɣɑsɩ mǝ tɑɑ sɩ ɩ́ kɑ́ kpɑ pulɑɣɑ tǝlɛʋ. ");
INSERT INTO dop_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Kɛnɑ Tɑcɑɑ sɩ mɑ́ heeli-mɛ sɩ: Ɩ́ tɑɑ kpɑ mǝ kolontunɑɑ tɔɔ sɩ ɩ́ yookinɑ-wɛ. Mpi tɔ, mɑ fɛɩ mǝ hɛkʋ. Ɩ́ tɑɑ yele nɑ pɛlɛ pɑ́ kʋ-mɛ. ");
INSERT INTO dop_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Mɑɑ tɛmɑ-mɛɣɛ-tǝɣɩ heeluɣu. Amɑ ɩ́ tɑ́ ké ŋkpɑŋʋɣʋ, nɑ ɩ́ kisi Tɑcɑɑ tɔm nɑ ɩ́ kpɑ pʋɣʋ nyʋɣʋ tɑɑ tǝkɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Kɛnɑ Amolii nyǝ́mɑ mpɑ ɩnɩ pɑɑ wɛ pʋɣʋ tɑɑ tǝnɑ tɔ pɑ́ lɩɩ mǝ tɔɔ, nɑ pɑ́ tʋ́ mǝ wɑɑlɩ ɩsɩɩ tɩɩŋ. Nɑ pɑ́ kʋ-mɛɣɛ pǝ kpɑɣɑʋ Ɩtɔm tɔ, hɑlǝnɑ Hoomɑ. ");
INSERT INTO dop_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ɩ́ kɔmɑ nɑ ɩ́ mǝlɩ nɑ ɩ́ wiinɑ Tɑcɑɑ ɩlɛnɑ, ɩ́lɛ́ ɩ kisi nɩɩʋ. ");
INSERT INTO dop_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Mpʋ pǝ́ yelinɑ nɑ ɩ́ cɑɣɑ Kɑtɛɛsɩ-Pɑɑneyɑ nɑ pǝ́ tɑɑŋɩ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Ḿpʋ́ɣʋ́ tǝ mǝlɑɑ nɑ tǝ́ kpɑɣɑ teŋku kʋsɛɛm mpɑɑʋ ŋku kʋ pukinɑ wʋlɑɣɑ tɛtʋ tɑɑ tɔ, ɩsɩɩ Tɑcɑɑ kɑ yɔɣɔtʋɣʋ tɔ. Nɑ tǝ́ cɔɔ Ɩtɔm pʋɣʋ tɑɑ nɑ pǝ́ tɑɑŋɩ. ");
INSERT INTO dop_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Kɛlɛnɑ kʋyɑkʋ nɑkʋlɩ Tɑcɑɑ tɔ-m sɩ: ");
INSERT INTO dop_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Amɑ ɩ́ tɩɩ cɔɔwɑ pʋɣʋ kʋnɛ tǝcɑm. Pǝ tɔɔ tɔ, ɩ́ hɑ mǝ ɩsɛ nɑ ilim ntɔɣɔŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Ɩ́ heeli yǝlɑɑ sɩ ɩ́ tǝŋnɑ mǝ kɔɣɔpiyɑ Ɩsɑʋ nyǝ́mɑ mpɑ pɑ wɛ Ɩtɔm tɔ pɑ tɛtʋ toŋɑ tɔɔ. Pɛlɛ pɑ tɛɛ kɑ́ sʋʋnɑ-mɛ yɑ́ɑ́. Amɑ ɩ́ lɑ-wɛ nɑ lɑɑkɑlɩ, ");
INSERT INTO dop_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ɩ́ tɑɑ kpɑ pɑ tɔɔ. Mɑ kɑɑ hɑ-mɛɣɛ tɛtʋ ntǝɣɩ pɑɑ hɔɣɔliim sɩ ɩ́ fɛlɩ nɔɔhǝlɛ mɑɣɑmɑɣɑ. Mpi tɔ, mɑ tɛmɑ Ɩtɔm pʋɣʋ ŋkʋɣʋ Ɩsɑʋ kɛ hɑʋ sɩ kʋ́ pǝsɩ ɩ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Pǝ wɛɛ sɩ ɩ́ yɑnɑ mǝ liɣitee kɛ tɔɣɔnɑɣɑ nɑ lʋm mpi ɩ́ kɑ́ tɔɣɔ nɑ ɩ́ nyɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Mpi tɔ, Tɑcɑɑ mǝ Ɩsɔ koolɑ-mɛɣɛ kʋpɑntʋ kɛ mǝ niŋ tǝmɑ tǝnɑ tɑɑ kɛ́. Pǝyele ɩ nyǝ́mɑ tɔntɛ nte ɩ́ tɔŋ wʋlɑɣɑ tɛtʋ ɑnɑɑm ɩnɛ ɩ tɑɑ tɔ tǝ tɔɔ. Pǝntɔ tɑɑ, pɩɩsɩ nɩɩlɛ kɛlɛ mǝ Ɩsɔ Tɑcɑɑ ɩnɩ ɩ wɛ mǝ wɑɑlɩ, nɑ ɩ́ tɑ́ lɑ-ŋ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Ḿpʋ́ɣʋ́ tǝ cɔlɑ Ɩsɑʋ nyǝ́mɑ mpɛɣɛ Ɩtɔm nɑ tɛtɛkǝlɛ mpɑɑʋ nɑ Ɩlɑtɩ nɑ Ɩsǝyɔŋ-Kepɛɛ nyǝŋkʋ tɔtɔ. Ɩlɛnɑ tǝ́ tɛɛ nɑ tǝ́ tǝŋnɑ Mowɑpʋ wʋlɑɣɑ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ-m sɩ: Ɩ́ tɑɑ kpɑ Mowɑpʋ nyǝ́mɑ tɔɔ sɩ mǝnɑ-wɛ ɩ́ yoo. Mpi tɔ, mɑ kɑɑ hɑ-mɛɣɛ pʋlʋɣʋ pɑ tɛtʋ tɑɑ. Lɔɔtɩ lʋlʋɣʋ nyǝ́mɑ Mowɑpʋ nyǝ́mɑ kɛ mɑ hɑwɑ Aɑ ɩcɑtɛ sɩ pɑ́ nyǝnǝɣɩ pɑ pʋlʋpʋ. ");
INSERT INTO dop_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Ɩmim nyǝ́mɑ kɑ cɑɣɑnɑ ɩcɑtɛ ńtɛ́ tǝ tɑɑ kɛ́ hɑtoo lɔŋ. Pɑɑ wɛ pɑɣɑlɛ kɛ́ nɑ pɑ́ kɛ́ tookonɑɑ ɩsɩɩ Anɑkɩ nyǝ́mɑ, nɑ pɑ́ wɛ toŋ. ");
INSERT INTO dop_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Lɛlɑɑ nɑ́ nyǝnɑɣɑ-wɛɣɛ Lefɑyi nyǝ́mɑ kɛ́ ɩsɩɩ Anɑkɩ nyǝ́mɑ. Amɑ Mowɑpʋ nyǝ́mɑ nɑ́ yɑɑkɑɣɑ-wɛɣɛ Ɩmim nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Holi nyǝ́mɑ kɑ cɑɣɑnɑ Ɩtɔm ɩcɑtɛ tɑɑ kɛ́ hɑtoo lɔŋ tɑɑ. Ɩlɛnɑ Ɩsɑʋ nyǝ́mɑ nɑ́ɑ́ kpiisi-wɛ nɑ pɑ́ mʋ pɑ tɛtʋ, ɩsɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɑ mʋɣʋ pɑ nyǝntʋ nti Tɑcɑɑ hɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Pǝnɛntɛ ɩ́ kʋlɩ nɑ tǝ́ tɛsɩ Selɛtɩ lɔɔʋ ɩsɩɩ Tɑcɑɑ kɑ́ heeluɣu-tʋ tɔ. Ɩlɛnɑ tǝ tɛsɩ Selɛtɩ lɔɔʋ. ");
INSERT INTO dop_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Tǝ kʋlʋɣʋ Kɑtɛɛsɩ-Pɑɑneyɑ tɔ pɩɩsɩ pǝlefɛɩ nɩɩlɛ kɛ tǝ tʋwɑ, nɑ pǝ́cɔ́ tǝ́ tɛsɩ Selɛtɩ lɔɔʋ ŋkʋ. Pǝ lɑpɑ ḿpʋ́ɣʋ́ sɩ pɑ tǝnɑ mpɑ pɑ kɛ́ yoolɑɑ kɛ wɑɑtʋ ɩnɩ tɔ, pǝ́ lǝsɩ pɑ looŋɑ tǝnɑ nɑ pɑ́ sɩ́ ɩsɩɩ Tɑcɑɑ kɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Ḿpʋ́ɣʋ́ Tɑcɑɑ tʋ yoolɑɑ mpɛɣɛ niŋ nɑ ɩ́ kʋ-wɛ. Hɑlǝnɑ pɑ kpekǝle tǝnɑ tɛ. ");
INSERT INTO dop_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Yoolɑɑ mpɛ pɑ sǝpɑ pɑ tǝnɑɣɑ pɑ kpekǝle tɑɑ, ");
INSERT INTO dop_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ɩlɛnɑ Tɑcɑɑ heeli-m sɩ: ");
INSERT INTO dop_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Nɔɔnɔɔ kɛ́ ɩ́ kɑ́ tɛsɩ Mowɑpʋ tɛtʋ toŋɑ, nɑ ɩ́ tǝŋnɑ Aɑ ɩcɑtɛ, ");
INSERT INTO dop_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","nɑ ɩ́ kpǝtǝnɑ Amoni nyǝ́mɑ tɛtʋ. Amɑ ɩ́ tɑɑ kpɑ Mowɑpʋ nyǝ́mɑ tɔɔ sɩ mǝ nɑ-wɛ ɩ́ yoo. Mpi tɔ, mɑ kɑɑ hɑ-mɛɣɛ pʋlʋɣʋ pɑ tɛtʋ tɑɑ. Lɔɔtɩ lʋlʋɣʋ nyǝ́mɑ Amoni nyǝ́mɑ kɛ mɑ hɑ-tɩ sɩ pɑ́ nyǝnǝɣɩ pɑ pʋlʋpʋ. ");
INSERT INTO dop_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Yǝlɑɑ nyǝnɑɣɑ tɛtʋ ntǝɣɩ Lefɑyi nyǝ́mɑ nyǝntʋ kɛ́. Mpi tɔ, mpɛ ɩnɩ pɑɑ wɛnnɑ tǝ tɑɑ kɛ́ hɑtoo lɔŋ nɑ Amoni nyǝ́mɑ yɑɑkɩ-wɛɣɛ Sɑmsumi nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Pɑɑ wɛ pɑɣɑlɛ kɛ́ nɑ pɑ́ kɛ́ tookonɑɑ, ɩsɩɩ Anɑkɩ nyǝ́mɑ, nɑ pɑ́ wɛ toŋ. Ḿpʋ́ɣʋ́ Tɑcɑɑ kpiisɑ-wɛ nɑ Amoni nyǝ́mɑ nɔɣɔ nɑ pɑ́ lɛɛtɩ pɑ lonte. ");
INSERT INTO dop_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Ḿpʋ́ɣʋ́ Tɑcɑɑ kɑ lɑpɑ Ɩsɑʋ lʋlʋɣʋ Ɩtɔm nyǝ́mɑ mpɑ pɑɑ wɛ Seyii tɔ. Wɑɑtʋ ɩnǝɣɩ ɩ kpiisɑ Holi nyǝ́mɑ nɑ pɑ nɔɣɔ nɑ ɩ́ tɔɣɔnɩ-wɛ nɑ ɩ́ sɩɩ Ɩtɔm nyǝ́mɑ kɛ pɑ lonte kɛ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Ḿpʋ́ɣʋ́ Kɑfǝtɔɔ Filiisi nyǝ́mɑ nɑ́ lɩɩwɑ nɑ pɑ́ tɔɣɔnɩ Afi nyǝ́mɑ mpɑ pɑɑ cɑɣɑ ɑcɑlisi tɑɑ hɑlǝnɑ Kɑsɑ kɛ Metitelɑnee teŋku nɔɣɔ tɔ, nɑ pɑ́ lɛɛtɩ pɑ lonɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Pǝ wɑɑlɩ kɛ́ Tɑcɑɑ tɔmɑ sɩ: Ɩ́ kʋlɩ nɑ ɩ́ tɛsɩ Alǝnɔŋ lɔɔʋ. Mɑ tʋɣɩ Amolii tʋ Sihoŋ wei ɩ kɛ́ Hɛsǝpɔŋ nyǝ́mɑ wulɑʋ tɔ, nɑ ɩ tɛtʋ kɛ mǝ niŋ tɑɑ. Ɩ́ yoonɑ-ɩ nɑ ɩ́ lɛɛkɩ ɩ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Pǝ kpɑɣɑʋ sɑŋɑ tɔ, mɑɑ yele nɑ ɑntulinyɑ piitimnɑɑ nɩɩkɩ mǝ sɔɣɔntʋ nɑ pɑ́ nyɑŋnɑ-mɛ. Ye pɑ nɩɩ mǝ tɑŋ pɑ sʋʋ seluɣu nɑ lɑŋwɑkǝllɛ. ");
INSERT INTO dop_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Ketemɔtɩ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ mɑ tilɑ Hɛsǝpɔŋ wulɑʋ Sihoŋ kiŋ nɑ ɑyɛɛnɛɛ tɔm sɩ: ");
INSERT INTO dop_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Hɑ-tʋɣʋ nɔɣɔ nɑ tǝ́ tǝŋ mpɑɑʋ kʋlʋmʋɣʋ nɑ tǝ́ fɑɣɑnɑ nyɑ́ tɛtʋ tɑɑ, tǝ kɑɑ hɛlɩ tiili. ");
INSERT INTO dop_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Tɑ liɣitee kɛ tɩɩ yɑnɑ tɔɣɔnɑɣɑ nɑ lʋm mpi tɩɩ nyɔɔ tǝnɑ tɔ nɑ tǝ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Ɩsɑʋ nyǝ́mɑ mpɑ pɑ wɛ Ɩtɔm hɔɣɔlʋɣʋ tɑɑ tɔ nɑ Mowɑpʋ nyǝ́mɑ mpɑ pɑ wɛ Aɑ nyǝŋkʋ tɑɑ tɔ pɑ hɑ-tʋɣʋ mpɑɑʋ nɑ tǝ́ fɑɣɑnɑ pɑ tɛtʋ tɑɑ. Pǝ wɑɑlɩ kɛ́ tɩɩ tɛsɩ Yɑɑtɑnɩ pɔɣɔ nɑ tǝ́ polo tɛtʋ nti Tɑcɑɑ tɑ Ɩsɔ hɑɑkɩ-tʋ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Amɑ Tɑcɑɑ lɑpɑ wulɑʋ Sihoŋ kɛ lɑŋkpɩɩsǝŋ nɑ ɩ́ kisi sɩ tǝ́ tɑɑ tǝŋnɑ ɩ tɛ. Ɩsɔ lɑpɑ-ɩ ḿpʋ́ɣʋ́ sɩ ɩ́ tʋ-ɩ tɑ́ niŋ tɑɑ nɑ tǝ́ tɔɣɔ ɩ tɛtʋ ɩsɩɩ pǝ wɛʋ sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Ḿpʋ́ɣʋ́ Ɩsɔ heelɑ-m sɩ: Sɑŋɑ wɑɑlɩ mɑ tʋwɑ wulɑʋ Sihoŋ nɑ ɩ tɛtʋ kɛ mǝ niŋ tɑɑ kɛ́, ɩ́ lɛɛkɩ-tɩ́. ");
INSERT INTO dop_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Ɩlɛnɑ Sihoŋ nɑ ɩ yoolɑɑ tǝnɑ pɑ́ lɩɩ sɩ pɑ yookinɑ-tʋɣʋ Yɑhɑsɩ. ");
INSERT INTO dop_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Amɑ Tɑcɑɑ tɑ́ Ɩsɔ tʋ-ɩ tɑ́ niŋ tɑɑ nɑ tǝ́ kʋ́ ɩ nɑ ɩ piyɑ nɑ ɩ yǝlɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Ɩlɛnɑ tǝ́ lɛɛkɩ ɩ ɑcɑlɛɛ tǝnɑ, nɑ tǝ́ kpiisi ɑpɑlɑɑ nɑ ɑlɑɑ nɑ piyɑ. Mpi tɔ, Tɑcɑɑ tǝŋsɑ-wɛɣɛ mpusi kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Amɑ tɔlɑ nɑ ɑcɑlɛɛ nnɑ tǝ lɛɛkɑ mpʋ tɔ ɑ tɑɑ wontunɑɑ kɛ tɑ́ kpɑɣɑɑ nɑ tǝ́ sɩɩnɑ tɑ́ tɩ. ");
INSERT INTO dop_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Pǝ kpɑɣɑʋ Alʋwɛɛ kɛ Alǝnɔŋ lɔɔʋ nɔɣɔ nɑ ɩcɑtɛ nte tǝ wɛ tɛtɛkǝlɛ tɑɑ tɔ, hɑlǝnɑ Kɑlɑɑtɩ tɔ, tǝ tɑ kpisi koluŋɑ ɩcɑtɛ nɑtǝlɩ. Tɑcɑɑ tɑ́ Ɩsɔ tʋ ɑ tǝnɑɣɑ tɑ́ niŋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Amɑ tǝ tɑ tokinɑ Amoni nyǝ́mɑ tɛtʋ kɛ́. Pɑɑ nti tǝ mɑlɑ Yɑpɔkɩ lɔɔʋ nɑ pʋɣʋ tɑɑ ɑcɑlɛɛ, nɑ lonɑ nnɑ ɑ tǝnɑ tɑ Ɩsɔ Tɑcɑɑ kisinɑ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Ḿpʋ́ɣʋ́ tǝ kpɑɣɑ mpɑɑʋ nɑ tǝ́ kpɑnɑ Pɑsɑŋ tɔɔ. Ɩlɛnɑ tǝnɑ wulɑʋ Oki nɑ ɩ yǝlɑɑ tǝnɑ pɑ lɩɩ tɑ tɔɔ sɩ pɑ yookinɑ-tʋɣʋ Ɩtǝlei. ");
INSERT INTO dop_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Ntɛnɑ Tɑcɑɑ heeli-m sɩ: Ɩ́ tɑɑ nyɑnɑ-ɩ. Mɑ tʋɣɩ ɩ́ nɑ ɩ yǝlɑɑ nɑ ɩ tɛtʋ tǝnɑɣɑ mǝ niŋ tɑɑ. Ɩ́ lɑnɑ-ɩ ɩsɩɩ ɩ́ lɑpǝnɑ Amolii nyǝ́mɑ wulɑʋ Sihoŋ wei ɩ kɑ wɛ Hɛsǝpɔŋ ɩcɑtɛ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Tɑmpɑm pǝlɛ nɑ tɑ́ Ɩsɔ Tɑcɑɑ tɑsɑ wulɑʋ Oki nɑ ɩ yǝlɑɑ tǝnɑɣɑ tɑ́ niŋ tɑɑ kɛ́ tʋɣʋ, nɑ tǝ́ kʋ-wɛ. Pɑ tɑɑ nɔɣɔlʋ tɑ fiti. ");
INSERT INTO dop_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Ḿpʋ́ɣʋ́ tǝ lɛɛkɑ pɑ ɑcɑlɛɛ tǝnɑ, pɑɑ kʋlʋmtǝlɛ tǝ tɑ fiti. A kɑ wɛ ɑcɑlɛɛ nɩɩtoso kɛ́. Pǝ kpɑɣɑʋ Alǝkɔpɩ hɔɣɔlʋɣʋ tǝnɑ tɔ nɑ Pɑsɑŋ tɛtʋ tɑɑ timpi Oki tɔkɑɣɑ kɑwulɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Pɑɑ ŋmɑwɑ ɑcɑlɛɛ ɑnǝɣɩ teu kɛ́, nɑ ɑ koloosi kʋlɑɑ nɑ ɑ Kɑmpʋnɑɑ kɛ nyǝɣǝtʋ. Pǝ́ kɑɑsɑ lɛnnɑ tɔtɔɣɔ tuutuumɑ, ɑ fɛɩ koloosi. ");
INSERT INTO dop_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Ḿpʋ́ɣʋ́ tǝ kpiisɑ pɑ tǝnɑ ɩsɩɩ tǝ lɑpʋ Hɛsǝpɔŋ wulɑʋ Sihoŋ ɑcɑlɛɛ tɑɑ tɔ. Nɑ tǝ́ kʋ́ ɑpɑlɑɑ nɑ ɑlɑɑ nɑ piyɑ. Mpi tɔ, Tɑcɑɑ kɑ tǝŋsɑ-wɛɣɛ mpusi kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Amɑ pǝ yelɑ tɔlɑ nɑ ɑcɑlɛɛ tɑɑ wontu ɩlɛnɑ tɑ́ɑ́ kpɑɣɑ nɑ tǝ́ sɩɩnɑ tɑ́ tɩ. ");
INSERT INTO dop_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Ḿpʋ́ɣʋ́ pǝ lɑpɑ wɑɑtʋ ɩnɩ ɩ tɑɑ, nɑ tǝ́ lɛɛkɩ Amolii ɑwulɑɑ nɑɑlɛ tɛtʋ. Mpɛ ɩnɩ pɑɑ wɛnɑ Yɑɑtɑnɩ ilim tǝlɩɩlɛ tɔɔ kɛ́. Pɑ tɛtʋ ntɛ́ pǝ kpɑɣɑʋ Alǝnɔŋ lɔɔʋ tɔ, hɑlǝnɑ Hɛɛmɔŋ pʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sitɔŋ nyǝ́mɑ nɑ́ yɑɑkɑɣɑ-kʋɣʋ sɩ Siliyoŋ. Nɑ Amolii nyǝ́mɑ nɑ́ɑ́ yɑɑkɩ-kʋ sɩ Senii. ");
INSERT INTO dop_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Oki kɑwulɑɣɑ ɑcɑlɛɛ nnɑ tǝ lɛɛkɑɑ tɔɣɔlɛ pulɑsɩ tɑɑ tɛtɛkǝlɛ ɑcɑlɛɛ tǝnɑ. Nɑ Kɑlɑɑtɩ nɑ Pɑsɑŋ tɛtʋ tǝnɑ hɑlǝnɑ Sɑlǝkɑ nɑ Ɩtǝlei pǝ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Wulɑʋ Oki tike kɑ kɛnɑ Lefɑyi nyǝ́mɑ kɑkɑɑsɑɣɑ. Ɩ sǝtʋ ɑtɑkɑɑ kɛ́ nyǝɣǝlʋɣʋ kɛ́, nɑ ɩ tɑɣɑlǝŋ wɛ mɛɛtǝlǝnɑɑ liɣiti nɑ hɔɣɔlʋɣʋ, nɑ ɩ wɑŋ kɛ mɛɛtǝlǝnɑɑ nɑɑlɛ. Hɑlɩ ɩ wɛ Amoni nyǝ́mɑ ɩcɑtɛ sɔsɔɔlɛ Lɑpɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Wɑɑtʋ wei tǝ lɛɛkɑ tɛtʋ ntɩ ɩlɛnɑ mɑ́ hɑ Lupɛŋ nɑ Kɑtɩ nyǝ́mɑ kɛ pǝ́ kpɑɣɑʋ Alʋwɛɛ tɛtʋ, nɑ pǝ́ cɔɔ Alǝnɔŋ lɔɔʋ tɔ, nɑ pǝ́ kpɛŋnɑ Kɑlɑɑtɩ pʋɣʋ hɔɣɔlʋɣʋ ɑcɑlɛɛ. ");
INSERT INTO dop_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Ɩlɛnɑ mɑ́ cɛlɑ Mɑnɑsee kpekǝle hɔɣɔlʋɣʋ lɛŋkʋ kɛ Kɑlɑɑtɩ tɛtʋ kʋkɑɑsǝtʋ nɑ Oki kɑwulɑɣɑ nyǝntʋ tǝnɑ kɛ Pɑsɑŋ tɛtʋ tɑɑ. Pɑ́ yɑɑkɑɣɑ Alǝkɔpɩ nyǝntʋ nɑ Pɑsɑŋ nyǝntʋ kɛ Lefɑyi nyǝ́mɑ tɛtʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Ḿpʋ́ɣʋ́ Mɑnɑsee kpekǝle tɑɑ tʋ Yɑyii lɛɛkɑ Alǝkɔpɩ tɛtʋ kɛ Pɑsɑŋ tɑɑ. Hɑlǝnɑ Kesuli nyǝ́mɑ nɑ Mɑɑkɑtɩ nyǝ́mɑ pɑ tɛtʋ toŋɑ. Ɩlɛnɑ pɑ́ lɑɣɑsɩ-yɛɣɛ hǝtɛ sɩ Yɑyii ɑcɑlɛɛ, nɑ pɑ́ yɑɑkɩ-yɛɣɛ ḿpʋ́ɣʋ́ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Ntɛnɑ mɑ́ hɑ́ Mɑnɑsee kpekǝle tʋ Mɑkii lʋlʋɣʋ nyǝ́mɑ kɛ Kɑlɑɑtɩ hɔɣɔlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Nɑ Lupɛŋ nɑ Kɑtɩ pǝ nyǝ́mɑ kɛ Alǝnɔŋ nɑ Kɑlɑɑtɩ pǝ hɛkʋ hɔɣɔlʋɣʋ. Tǝ toŋɑ ntɛ́ Alǝnɔŋ lɔɔʋ nɑ pǝ tɛɛ tɔɔ. Tǝ nɑ Amoni nyǝ́mɑ pɑ nyǝŋkɑ ntɛ́ Yɑpɔkɩ lɔɔʋ. ");
INSERT INTO dop_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Ilim tǝtʋlɛ tɔɔ toŋɑ nɑ́ mɑlɑ Yɑɑtɑnɩ tɛtɛkǝlɛ kɛ Kenesɑlɛtɩ lʋcɑɣɑm nɑ teŋku kʋsǝpʋ pǝ hɛkʋ tɑɑ kɛ́. Hɑlǝnɑ ilim tǝlɩɩlɛ tɔɔ kɛ́ Pisikɑ pʋɣʋ luɣu. ");
INSERT INTO dop_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Wɑɑtʋ ɩnɩ ɩ tɑɑ kɛ́ Moisi heelɑ-wɛ sɩ: Mǝ Ɩsɔ Tɑcɑɑ tʋ mǝ niŋ tɑɑ kɛ́ Yɑɑtɑnɩ ilim tǝlɩɩlɛ tɛtʋ sɩ tǝ́ pǝsɩ mǝ nyǝntʋ. Ɩlɛ mǝ tɑɑ yoolɑɑ tǝnɑ ɩ́ kpɑɣɑ mǝ yoou wontu nɑ ɩ́ tɛɛ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Mǝ ɑlɑɑ nɑ mǝ piyɑ nɑ mǝ kɑlǝkǝŋ tike kɑ́ cɑɣɑnɑ ɑcɑlɛɛ nnɑ mɑ hɑ-mɛ ɩsǝntɔ tɔ ɑ tɑɑ. Mpi tɔ, mǝ nyǝ́mɑ sɩ ɩ́ wɛnɑ kɑlǝkǝŋ tuutuumɑ. ");
INSERT INTO dop_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Pǝ wɛɛ sɩ ɩ́ sǝnɑ mǝ tɛɛtʋnɑɑ kɛ ḿpʋ́ɣʋ́. Hɑlǝnɑ Ɩsɔ yele nɑ pɛlɛ pɑ́ hiki pɑ tɛtʋ ɩsɩɩ mǝ hikuɣu mǝ nyǝntʋ kɛ Yɑɑtɑnɩ pɔɣɔ nɑ wɑɑlɩ cǝnɛ tɔ. Wɑɑtʋ ɩnǝɣɩ pɑɑ mǝ tɑɑ wei ɩ kɑ́ mǝlɩ ɩ mɑɣɑmɑɣɑ ɩ tɛtʋ nti Tɑcɑɑ hɑ-ɩ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Ḿpʋ́ɣʋ́ Moisi tɔmɑ Yosuwee sɩ: N nɑnɑ nyɑ́ ɩsǝpee kɛ pǝ tǝnɑ mpi Tɑcɑɑ mǝ Ɩsɔ lɑpǝnɑ Amolii ɑwulɑɑ nɑɑlɛ ɩnɩ tɔ. Mpʋ ɩnɩ tɔtɔɣɔ Tɑcɑɑ kɑ lɑnɑ ɑwulɑɑ mpɑ pɑ tǝnɑ n kɑ yoonɑ pɔɣɔ wɑɑlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ɩ́ tɑɑ nyɑnɑ-wɛ. Mpi tɔ, Tɑcɑɑ mǝ Ɩsɔ kɑ́ yoonɑ nɑ mǝ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Wɑɑtʋ ɩnɩ ɩ tɑɑ kɛ́ mɑ wiikɑɣɑnɑ Tɑcɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Ɩsɔ Tɑcɑɑ, nyɑ́ toŋ nɑ nyɑ́ sɔsɔɔntʋ kɛ n hʋlɑ nyɑ́ tǝmlɛ tʋ mɑ́. Mpi tɔ, pɑɑ ɩsɔtɑɑ yɑɑ ɑtɛ, nyɑ́ sɑɑlɑ nɔɣɔlʋ ɩ fɛɩ sɩ ɩ kɛɛkǝnɑ nyɑ́ tǝmɑ sɔsɔɔnɑ, yɑɑ nyɑ́ kɔkɔlɔ nyǝmnɑɑ pɑnɛ. ");
INSERT INTO dop_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Ɩlɛ hɑɩ Ɩsɔ, mɑ kpɑ nyɑ́ yule. Yele nɑ mɑ́ tɛsɩ Yɑɑtɑnɩ nɑ mɑ́ nɑ tɛtʋ kʋpɑntʋ ntɩ, nɑ tǝ pulɑsɩ nɑ Lipɑŋ pɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑɑ kpɑnɑ-m mǝ mɑɣɑmɑɣɑ mǝ nyʋɣʋ tɔɔ, nɑ ɩ́ kisi-m nɩɩnɑʋ. Hɑlǝnɑ ɩ́ tɔ-m sɩ: Mɑ kɑwɑ. Tɑɑ tɑsɑ-m yɔɣɔtǝnɑʋ kɛ tɔm ntɩ. ");
INSERT INTO dop_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Kʋlɩ nɑ ń kpɑ Pisikɑ pʋɣʋ nyʋɣʋ tɑɑ nɑ ń kʋsɩ ɩsɛ nɑ ń nyǝnɩ nɑ ń cɔɔ. Amɑ mɑ kɑɑ yele nɑ ń tɛsɩ Yɑɑtɑnɩ kɛ tɛsʋɣʋ mɑɣɑmɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Amɑ tɛlǝsɩ Yosuwee kɛ mɑ kʋlɑpǝlɛ nɑ ń sɔɔsɩ-ɩ ɑpɑlʋtʋ. Mpi tɔ, ɩnɩ ɩ kɑ́ tʋnɑ yǝlɑɑ pɑnɛɣɛ nɔɣɔ nɑ ɩ́ tɑnɑ-wɛɣɛ tɛtʋ nti n kɑ nɑwɑ mpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Pǝ kpɑɣɑʋ wɑɑtʋ ɩnɩ tɔɣɔ tǝ cɑɣɑ tɛtɛkǝlɛ tɑɑ tǝnɑɣɑ Pɛtɩ-Peyɔɔ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Ḿpʋ́ɣʋ́ Moisi tɑsɑɑ sɩ: Pǝnɛntɛ Ɩsɛɣɛlɩ nyǝ́mɑ mɛ ɩ́ nɩɩ kʋsǝsɩɩtʋ nɑ kʋtʋtʋtʋ nti mɑ sɛɣɛsǝɣɩ-mɛ tɔ. Ɩ́ lɑkɩ-tɩ nɑ pǝ́ hɑ-mɛɣɛ weesuɣu. Ɩlɛnɑ ɩ́ mʋ tɛtʋ nti mǝ cɑɑnɑɑ Ɩsɔ Tɑcɑɑ hɑɑkɩ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Amɑ pǝ wɛɛ kɛ́ sɩ ɩ́ tɔ́kɩ Tɑcɑɑ mǝ Ɩsɔ kʋsǝsɩɩtʋ ɩsɩɩ mɑ kɛɛsʋɣʋ-mɛɣɛ-tɩ tɔ. Ɩ́ tɑɑ sɔɔsɩ yɑɑ ɩ́ pɑsɑ pʋlʋɣʋ tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Ɩ́ nɑnɑ mǝ ɩsǝpee kɛ mpi Tɑcɑɑ lɑpɑ yǝlɑɑ mpɑ pɑ luŋɑ tʋɣʋ ŋku pɑ yɑɑ sɩ Pɑɑlɩ-Peyɔɔ tɔ. Ɩ tɑ yele-wɛ nɑ pɑ weesiŋ. ");
INSERT INTO dop_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Amɑ mǝ nyɔkǝlǝnɑ Tɑcɑɑ mǝ Ɩsɔ, ɩlɛnɑ ɩ́ yele-mɛ nɑ mǝ weesiŋ kɛ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Mɑ sɛɣɛsɑ-mɛɣɛ kʋsǝsɩɩtʋ nɑ kʋtʋtʋtʋ ɩsɩɩ Tɑcɑɑ Ɩsɔ tʋ-m tɔ sɩ, ɩ́ tɔkɩ-tɩ nɑ ɩ́ lɑkɩ tɛtʋ nti ɩ́ puki mʋɣʋ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ye ɩ́ tɔkɑ-tɩ nɑ ɩ́ lɑkɩ-tɩ, piitimnɑɑ lɛlɑɑ mpɑ pɑɑ nɩɩ tǝ tɔm tɔ pɑ́ɑ́ nyǝnɩ-mɛɣɛ lǝmɑɣɑsɛɛ nyǝ́mɑ nɑ lɑɣɑtʋnɑɑ nɑ pɑ́ tɔŋ-mɛ sɩ: Amɑ piitim sɔsɔɔm pǝnɛ pǝ wɛnɑ lǝmɑɣɑsɛɛ nɑ lɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Pɔpɔtʋ fɛɩ leleŋ piitim sɔsɔɔm nɑpǝlɩ pǝ fɛɩ nɑ pǝ́ wɛnɑ tʋɣʋ nɑ kʋ́ nɩɩkǝnɑ-wɛ ɩsɩɩ tɑ́ Ɩsɔ Tɑcɑɑ nɩɩkʋɣʋnɑ tɑɣɑ sɑɑ wei tǝ wiikinɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Yɑɑ piitim sɔsɔɔm mpi pǝ wɛnɑ kʋtʋtʋtʋ nɑ kʋsǝsɩɩtʋ nɑ tǝ tǝŋɑ teu ɩsɩɩ nti mɑ tɔŋnɑ-mɛɣɛ tɛlǝsʋɣʋ kɛ sɑŋɑ ɩsǝntɔ tɔ? ");
INSERT INTO dop_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Amɑ kʋlʋmtʋ kɛ́ sɩ ɩ́ feŋ teu nɑ ɩ́ tɔ́kɩ pǝ tǝnɑ mpi ɩ́ nɑnɑ mǝ ɩsǝpee tɔ. Ɩ́ tɑɑ sɔɔ tǝ tɑɑ kʋlʋmʋɣʋ. Amɑ ɩ́ kɛɛsɩ-tǝɣɩ mǝ piyɑ nɑ mǝ sɑɑlǝnɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Ɩ́ tɔɔsɩ kʋyɑkʋ ŋku ɩ́ sǝŋɑ mǝ Ɩsɔ Tɑcɑɑ ɩsɛntɑɑ kɛ́ Holɛpʋ pʋɣʋ kiŋ nɑ ɩ́lɛ́ ɩ heeli-m sɩ mɑ́ koti mǝ tǝnɑ, nɑ ɩ́lɛ́ ɩ́ tɛlǝsɩ-mɛɣɛ ɩ tɔm nɑ ɩ́ kpɛlǝmɩ ɩ nyɑmnɑʋ nɑ ɩ́ sɛɣɛsɩ ḿpʋ́ɣʋ́ mǝ lʋlʋɣʋ nyǝ́mɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Ḿpʋ́ɣʋ́ ɩ́ tuusɑɑ nɑ ɩ́ kpǝtǝnɑ pʋɣʋ luɣu, nɑ kʋlɛ kʋ́ tɔŋnɑ kɔkɔ mʋɣʋ kɛ kemkem. Nɑ ɩsɔŋmʋntʋ susɑɑ nɑ sǝkpɛtʋɣʋ nyɑlɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Tɑcɑɑ yɔɣɔtɑɣɑnɑ-mɛɣɛ kɔkɔ ŋkɛ kɑ tɑɑ kɛ́, nɑ ɩ́ nɩɩkɩ ɩ nɔɣɔ. Amɑ ɩɩ nɑɑkɩ-ɩ, ɩ nɔɣɔ tike kɛ ɩ́ nɩɩkɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Ḿpʋ́ɣʋ́ ɩ hʋlɑ-mɛɣɛ mǝ nɑ-ɩ mǝ nɔɣɔ pɛɛlʋɣʋ nɑ ɩ́ tʋ-mɛ sɩ ɩ́ tɔkɩ ɩ kʋsǝsɩɩtʋ nɑɑnʋwɑ. Nɑ ɩ́ ŋmɑɑ-tǝɣɩ pɛɛ kpɑɑtɑnɑɑ nɑɑlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Wɑɑtʋ ɩnɩ ɩ́ tɑɑ kɛ́ Tɑcɑɑ tʋ-m sɩ mɑ́ hʋlɩ-mɛɣɛ kʋsǝsɩɩtʋ nɑ kʋtʋtʋtʋ, nɑ ɩ́ tɔkǝɣɩ-tǝɣɩ teu kɛ tɛtʋ nti tǝ tɑɑ ɩ́ sʋʋkɩ sɩ tǝ́ pǝsɩ mǝ nyǝntʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Ɩ́ tɑɑ sɔɔ sɩ kʋyɑŋku Tɑcɑɑ yɔɣɔtɑɣɑnɑ-mɛɣɛ Holɛpʋ pʋɣʋ tɔɔ tɔ ɩ nɔɣɔ tike kɛ ɩ́ nɩɩwɑ, ɩ́ tɑ nɑ ɩ mɑɣɑmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Ɩlɛ pǝ tɑɑ kɔɔ nɑ ɩ́ wɑkǝlɩ mǝ tɩ nɑ tʋɣʋ nɑkʋlɩ kʋ lupu, pɑɑ ɑpɑlʋ yɑɑ ɑlʋ lɛɛsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","Pɑɑ ɑtɛ kpǝntɛ nɑtǝlɩ, yɑɑ sumɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","Pɑɑ tɛtɛ wontu, yɑɑ tinte nɑtǝlɩ tǝ lɛɛsʋɣʋ sɩ ɩ́ sɛɛkɩ. ");
INSERT INTO dop_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ɩ́ feŋ teu, pǝ́ tɑɑ kɔɔ nɑ ɩ́ kʋsɩ mǝ ɩsɛ sɩ ɩ́ tekiɣi ilim, yɑɑ ɩsɔtʋ, yɑɑ ɩsɔtʋlʋŋɑsɩ pǝ tɑɑ pʋlʋ, yɑɑ ɩ́ lɑɑ-wɩ. Antulinyɑ yǝlɑɑ lɛlɑɑ kɛ mǝ Ɩsɔ Tɑcɑɑ yelɑ tǝlɛ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Amɑ mɛ ɩlɛ, ɩnɩ ɩ lǝsǝnɑ-mɛɣɛ Icipiti mɑmɑlɑ tɑɑ sɩ, ɩ́ pǝsɩ ɩ yǝlɑɑ tǝsiɣisiɣi ɩsɩɩ ɩ́ wɛʋ sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ɩlɛnɑ ɩ́ mʋnɑ mɑɣɑ pɑ́ɑ́nɑ́ kɛ mǝ nyʋɣʋ tɔɔ. Hɑlǝnɑ ɩ́ tuu sɩ mɑ kɑɑ tɛsɩ Yɑɑtɑnɩ nɑ mɑ́ fɛlɩ nɔɔhǝlɛ kɛ tɛtʋ kʋpɑntʋ nti ɩ hɑɑkɩ-mɛ sɩ tǝ́ pǝsɩ mǝ́ nyǝntʋ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ye mɑ ɩlɛ Yɑɑtɑnɩ pɔɣɔ nɑ cǝnɛ tɔɔ kɛ́ mɑɑ sɩ mɑ kɑɑ tɛsɩ-kɛ. Amɑ mɩɩ tɛsɩ nɑ tɛtʋ kʋpɑntʋ ntɩ tǝ́ pǝsɩ mǝ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Mpʋ tɔ, ɩ́ feŋ mǝ tǝɣɩ teu nɑ ɩ́ tɑɑ kɔɔ nɑ ɩ́ sɔɔ nɔɣɔ ŋkɑ mǝ nɑ mǝ Ɩsɔ Tɑcɑɑ ɩ́ pɛɛlɑɑ tɔ. Nɑ pǝ́ kɔɔ nɑ nɔɣɔlʋ lu tʋɣʋ nɑ ɩ́ lɑɣɑsɩ Ɩsɔ lonte sɩ ɩ́ luŋiɣi. Mpi tɔ, Ɩsɔ kisinɑ-mɛɣɛ pǝ tǝnɑɣɑ ḿpʋ́ɣʋ́. ");
INSERT INTO dop_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Tɑcɑɑ mǝ Ɩsɔ wɛ kɛ́ ɩsɩɩ kɔkɔ ŋkɑ kɑ nyɑkɩ pǝ tǝnɑ tǝmɛlɛmɛlɛ tɔ. Pǝ́cɔ́ ɩ kisɑ pɑ kpɩ ɩ nɑ tʋɣʋ nɑkʋlɩ. ");
INSERT INTO dop_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Ye ɩ́ tɑɑŋɑ tɛtʋ ntɩ tǝ tɑɑ nɑ ɩ́ lʋlɩ piyɑ nɑ sɑɑlǝnɑɑ, ɩ tɑɑ wɑkǝlɩ mǝ tɩ nɑ tɩɩŋ lupu yɑɑ mpi Tɑcɑɑ kisɑɑ tɔɣɔ lɑpʋ, nɑ pǝ́ kpɑɑsɩ ɩ pɑ́ɑ́nɑ́. ");
INSERT INTO dop_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Ɩsɔtɔnʋɣʋ nɑ tɛtʋ ntɛ́ mɑ ɑseetɑ nyǝ́mɑ. Ye ɩ́ lɑpɑ mpʋ, ɩsɩɩ sǝm kpiisɑ-mɛɣɛ lɔŋ kɛ tɛtʋ nti tǝ tɑɑ ɩ́ puki cɑɣɑlɛ kɛ Yɑɑtɑnɩ wɑɑlɩ tɔ, ɩ́ kɑɑ tɑɑŋɩ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Tɑcɑɑ kɑ́ yɑsɩ-mɛɣɛ piitimnɑɑ tɑɑ kɛ́, nɑ pǝ́ kɑɑsɩ-mɛɣɛ pǝciiu tike kɛ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Tǝnɑɣɑ ɩ́ kɑ́ luŋiɣi yǝlɑɑ sɑɑkɑ tɑɑsɩ nɑ pɛɛ wenɑɣɑ tɩɩŋ tɔ. Pǝ́cɔ́ tɩɩŋ ɩnɩ ɩɩ nɑɑkɩ, ɩɩ nɩɩkɩ, ɩɩ tɔkɩ, ɩɩ nɩɩ pʋlʋpʋ sɔɔsʋŋ. ");
INSERT INTO dop_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Tǝnɑ tɔtɔɣɔ ɩ́ kɑ́ pɛɛkɩ Tɑcɑɑ mǝ Ɩsɔ. Amɑ ye ɩ́ pɛɛkǝnɑ-ɩ nɑ ɩsǝlɛ kʋsɛɛmlɛ nɑ mǝ lǝsɑɣɑ sʋʋ-ɩ tǝmɑmɑm ɩ́ kɑ́ nɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Pǝ tǝnɑ mpi mɑ kɛɛsɑ-mɛ ɩsǝntɔ tɔ, ye pǝ mɑɣɑnɑ-mɛ nɑ ɩ́ sʋʋ lɑŋwɑkǝllɛ tɑɑ, ɩlɛ ɩ tɑɣɑnɩ Tɑcɑɑ mǝ Ɩsɔ kɛ́ nɩɩnɑʋ. ");
INSERT INTO dop_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Mpi tɔ, ɩ kɛ́ pǝtɔɔtǝlɛ tʋ kɛ́. Ɩ kɑɑ lɔ-mɛ yɑɑ ɩ́ wɑkǝlɩ-mɛ, yɑɑ ɩ sɔɔ nɔɔsɩ nsi ɩ kɑ sɩɩ mǝ cɑɑnɑɑ nɑ tuunɑʋ tɔ sɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ɩ́ mɑɣɑsɩ mǝ tɑɑ nɑ ɩ́ nɑ sɩ, too Ɩsɔ lɑpʋ yʋlʋ kɛ tɛtʋ tɔɔ nɑ pǝ́ sɩɩnɑ sɑŋɑ tɔ, ɩ́ pɛɛkɩ ɑntulinyɑ tǝnɑ tɑɑ nɑ ɩ́ nɑ sɩ, kɔkɔlɔ nɔɣɔlʋ ɩ tɛmɑ lɑpʋ ɩsɩɩ ɩnɛ ɩ tɑkɑ nɑ nɔɣɔlʋ nɩɩ? ");
INSERT INTO dop_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Yǝlɑɑ nɑpǝlɩ pɑ tɛmɑ Ɩsɔ nɔɣɔ nɩɩʋ kɛ kɔkɔ tɑɑ ɩsɩɩ mǝ nɩɩkʋɣʋ ɩsǝntɔ tɔ, nɑ pʋntʋnɑɑ wɛnɑ weesiŋ nɑ? ");
INSERT INTO dop_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Too tɔ, tʋɣʋ nɑkʋlɩ kʋ tɛmɑ piitim nɑpǝlǝɣɩ lǝsʋɣʋ kɛ lɛmpɩ hɛkʋ nɑ mɑɣɑsǝŋ nɑ kɔkɔlɔ tǝmɑ nɑ piti nyǝnɑ nɑ sɔɣɔntʋ nyǝnɑ nɑ yoou ɩsɩɩ Tɑcɑɑ mǝ Ɩsɔ lɑpʋ-mɛɣɛ Icipiti tɛtʋ tɑɑ nɑ ɩ́ nɑnɑ mǝ ɩsǝpee tɔ? ");
INSERT INTO dop_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Mǝ tɩɩ kɛnɑ pǝ tǝnɑɣɑ mpʋ pǝ ɑseetɑ nyǝ́mɑ. Mpi tɔ, ɩ́ cɛkǝnɑɑ sɩ Tɑcɑɑ tike kɛnɑ mǝ Ɩsɔ pǝ tɑ kɑɑsɩ nɔɣɔlʋ. ");
INSERT INTO dop_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Hɑtoo ɩsɔtɑɑ kɛ́ ɩ́ sɛɣɛsǝnɑ-mɛ sɩ ɩ́ nyɩ. Ɩlɛnɑ ɩ́ hʋ́lɩ́-mɛɣɛ ɩ kɔkɔ sɔsɑɣɑ kɛ tɛtʋ tɔɔ nɑ ɩ́ nɩɩ ɩ nɔɣɔ kɛ kɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Ɩ sɔɔlɑ mǝ cɑɑnɑɑ kɛ́ nɑ ɩ́ lǝsɩ pɑ lʋlʋɣʋ nyǝ́mɑ kɛ pɑ wɑɑlɩ nɑ ɩ́ lǝsɩ-mɛɣɛ ɩ mɑɣɑmɑɣɑ kɛ Icipiti tɑɑ nɑ ɩ toŋ sɔsɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Ɩ tɔɣɔnǝnɑ mǝ nɔɣɔ kɛ piitimnɑɑ mpɑ pɑ kǝlɑ-mɛɣɛ pɑɣɑlɛ nɑ tomɑ tɔ. Nɑ ɩ́ kpɑ-mɛ nɑ ɩ́ lɛɛtɩ pɛlɛ pɑ lonɑ tɑɑ, sɩ pɑ tɛtʋ ɩ́ pǝsɩ mǝ nyǝntʋ ɩsɩɩ ɩ́ nɑɑkʋɣʋ sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Ɩ́ nyɩ sɑŋɑ kʋyɑkʋ kʋnɛ nɑ ɩ́ tɔkɩ mǝ tɑɑ sɩ Tɑcɑɑ tike ntɛ́ Ɩsɔ kɛ́ ɩsɔtɑɑ nɑ ɑtɛ, nɔɣɔlʋ ɩ fɛɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Nɑ ɩ́ tǝŋǝɣɩ ɩ kʋsǝsɩɩtʋ nɑ ɩ kʋtʋtʋtʋ ɩsɩɩ mɑ hʋlʋɣʋ-mɛɣɛ sɑŋɑ ɩsǝntɔ tɔ. Ɩlɛnɑ pǝ́cɔ́ mǝnɑ mǝ piyɑ ɩ́ nɩɩ leleŋ nɑ mǝ weesuɣu tɑɣɑlɩ teu kɛ́ tɛtʋ nti ɩ hɑɑkɩ-mɛɣɛ ɩsǝntɔ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Ḿpʋ́ɣʋ́ Moisi lǝsɑ ɑcɑlɛɛ tooso nɑ Yɑɑtɑnɩ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Ɩlɛnɑ pɑ́ pǝsɩ-yɛɣɛ yǝlɑɑ mpɑ pǝ yʋkǝɣǝnɑ nɑ pɑ́ kʋɣɩ pɑ tɔɣɔntǝlɛnɑɑ tɔ pɑ kpǝlʋɣʋ tǝtʋlɛ. ");
INSERT INTO dop_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Lupɛŋ nyǝ́mɑ kpǝlʋɣʋ tǝtʋlɛ ntɛ́ Pesɛɛ ɩcɑtɛ kɛ wʋlɑɣɑ tɛtʋ tontoŋlɛ tɔɔ. Kɑtɩ nyǝ́mɑ nyǝntɛ ntɛ́ Lɑmɔtɩ kɛ Kɑlɑɑtɩ tɛtʋ tɑɑ. Mɑnɑsee nyǝ́mɑ nyǝntɛ ntɛ́ Kolɑŋ kɛ Pɑsɑŋ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","45","Kiiŋ nɑ kʋtʋtʋtʋ nɑ kʋsǝsɩɩtʋnɑɑ mpɑ Moisi tɛlǝsɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɑ Icipiti tɑɑ lɩɩʋ wɑɑlɩ tɔɣɔlɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Yɑɑtɑnɩ pɔɣɔ nɑ ilim tǝlɩɩlɛ tɔɔ kɛ́ tɛtɛkǝlɛ tɑɑ kɛ́ Pɛtɩ-Peyɔɔ ɩsɛntɑɑ kɛ́ pǝ tǝnɑɣɑ mpʋ pǝ lɑpɑ. Amolii nyǝ́mɑ wulɑʋ Sihoŋ wei Moisi-wɛ pɑ ŋmɑkǝlɑɑ tɔ ɩ tɛtʋ tɑɑ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Ɩlɛnɑ pɑ́ lɛɛkɩ ɩ tɛtʋ nɑ pɑ́ kpɛŋnɑ Pɑsɑŋ wulɑʋ Oki nyǝntʋ. Awulɑɑ mpɛ pɑ nɑɑlɛ pɑɑ wɛnnɑ Yɑɑtɑnɩ pɔɣɔ wɑɑlɩ nɑ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Pɑ tɛtʋ kɑ pɔnɑ ḿpʋ́ɣʋ́ pǝ kpɑɣɑʋ Alʋwɛɛ kɛ Alǝnɔŋ lɔɔʋ nɔɣɔ tɔ. Hɑlǝnɑ Siyɔŋ pʋɣʋ ŋku pɑ yɑ́ɑ́ sɩ Hɛɛmɔŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Ntǝɣǝlɛ mpʋ nɑ Yɑɑtɑnɩ pɔɣɔ nɑ ilim tǝlɩɩlɛ tɔɔ. Hɑlǝnɑ teŋku kʋsǝpʋ, nɑ pǝ́ polo pʋɣʋ Pisikɑ luɣu. ");
INSERT INTO dop_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Ḿpʋ́ɣʋ́ Moisi kotɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɑ ɩ́ tɔ-wɛ sɩ: Ɩ́ nɩɩ kʋsǝsɩɩtʋ nɑ kʋtʋtʋtʋ nti mɑ tɛlǝsǝɣɩ-mɛɣɛ sɑŋɑ ɩsǝntɔ tɔ. Ɩ́ kpɛlǝmɩ-tɩ nɑ ɩ́ tɔ́kɩ-tǝɣɩ teu nɑ ɩ́ lɑkɩ. ");
INSERT INTO dop_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Tɑ́ nɑ Tɑcɑɑ tɑ́ Ɩsɔ tǝ pɛɛlɑ nɔɣɔ kɛ́ hɑtoo Holɛpʋ pʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Nɑ kɑ tɑ kɛ tɑ́ cɑɑnɑɑ mpɑ pɑ tɛmɑ sǝpʋ tɔ pɑ tike pɑ tɔm. Amɑ nɑ tɑ́ mpɑ tǝ wɛnɑ tɑ́ ɩsɛ kɛ sɑŋɑ ɩsǝntɔ tɔ tɑ́ nyǝntʋ tɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Tǝnɑɣɑ kɔkɔ mʋkɑɣɑ pʋɣʋ, nɑ Tɑcɑɑ yɔɣɔtǝnɑ-mɛɣɛ kɑ tɑɑ nɑ ɩ́ nɩɩkɩ ɩ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Hɑlǝnɑ ɩ́ nɑ-kɛ nɑ sɔɣɔntʋ kpɑ-mɛ nɑ ɩ́ kpisi kʋ tɔɔ kɛ́ kpɑʋ. Ɩlɛnɑ mɑ́ sǝŋ mǝ nɑ Tɑcɑɑ mǝ hɛkʋ, nɑ mɑ́ tɛlǝsɩ-mɛɣɛ nti Tɑcɑɑ yɔɣɔtɑɑ tɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Mɑɣɑlɛ mǝ Ɩsɔ Tɑcɑɑ, mɑ́ lǝsǝnɑ-mɛɣɛ Icipiti tɛtʋ tɑɑ kɛ́ mǝ yomle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Ɩ́ tɑɑ nyǝnɩ nɔɣɔlʋɣʋ Ɩsɔ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Pǝ́cɔ́ ɩ́ tɑɑ lu pʋlʋ lɛɛsʋɣʋ sɩ ɩ́ lɑɑkɩ. Pɑɑ mpi pǝ wɛ hɑtoo ɩsɔtɑɑ yɑɑ ɑtɛ cǝnɛ yɑɑ lʋm tɛɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ɩ́ tɑɑ luŋ tɩɩŋ ɩnɩ, yɑɑ ɩ́ lɑpɩ-ɩ tǝmlɛ nɑtǝlɩ. Mpi pǝ tɔɔ tɔ, mɑɣɑlɛ mǝ Ɩsɔ Tɑcɑɑ. Mɑ kisɑɑ sɩ ɩ́ tɑɑ kpɩ mɑ́ nɑ tʋɣʋ nɑkʋlɩ. Ye wei ɩ́ kisɑ-m, mɑ lɛɛtǝɣɩ-ɩ nɑ mɑ́ kpɛŋnɑ ɩ piyɑ, nɑ pɑ sɑɑlǝnɑɑ. Nɑ pǝ́ polo pɑ lʋlǝŋ loosi ɩsɩɩ tooso yɑɑ liɣiti. ");
INSERT INTO dop_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Amɑ wei ɩ cɑɑkɩ-m nɑ ɩ́ tɔkǝɣɩ mɑ tɔm tɔ, mɑ kooliɣi ɩlɛɣɛ kʋpɑntʋ kɛ́ nɑ pǝ́ polo ɩ lʋlʋŋ loosi iyisi iyisi. ");
INSERT INTO dop_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Ɩ́ tɑɑ yɑɑkɩ mǝ Ɩsɔ Tɑcɑɑ mɑ́ mɑ hǝtɛ kɛ yem yem. Mpi tɔ, mɑ kɑɑ yele wei ɩ yɑɑkɩ mɑ hǝtɛ kɛ yem yem tɔɣɔ sɑlǝkɑ tʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Ɩ́ pɑɑsǝnɑ kʋyɑkʋ kʋhɛɛsʋɣʋ kɛ teu nɑ ɩ́ nyǝnɩ-kʋɣʋ mɑ nyǝŋkʋ ɩsɩɩ mɑ heelɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Mǝ tǝmlɛ kʋyɛɛŋ ntɛ́ nɑɑtoso, nɑ ɩ tɑɑ kɛ́ ɩ́ kɑ́ lɑ mǝ tǝmɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Amɑ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ kɛnɑ mǝ Ɩsɔ Tɑcɑɑ kʋyɑkʋ kʋhɛɛsʋɣʋ. Tǝmlɛ nɑtǝlɩ tǝ fɛɩ lɑpʋ kɛ kʋ wule. Pɑɑ mǝ mɑɣɑmɑɣɑ, yɑɑ mǝ pǝyɑlɑɑ yɑɑ mǝ pɛɛlɑɑ, yɑɑ mǝ yomɑɑ, yɑɑ mǝ mʋʋlɑɑ mɑɣɑmɑɣɑ. Pɑɑ mǝ nɑɑŋ yɑɑ mǝ kpɑŋɑsɩ, yɑɑ mǝ tɔlɑ tɑɑ nɑtǝlɩ. Pǝ wɛɛ sɩ mǝ yomɑɑ ɩ́ hɛɛsɩ kʋyɑkʋ ŋkʋɣʋ ɩsɩɩ mɛ. ");
INSERT INTO dop_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Ɩ́ tɔɔsɩ sɩ mǝ mɑɣɑmɑɣɑ ɩ́ kɑ kɛ́ yomɑɑ kɛ Icipiti tɛtʋ tɑɑ kɛ́ ḿpʋ́ɣʋ́, nɑ mǝ Ɩsɔ Tɑcɑɑ ɩnɩ ɩ́ lǝsɩ-mɛ nɑ ɩ toŋ sɔsɔɔŋ. Pǝ tɔɔ kɛ́ mɑ tʋ-mɛ sɩ ɩ́ tɔkɩ kʋyɑkʋ Kʋhɛɛsʋɣʋ ŋkʋ. ");
INSERT INTO dop_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Ɩ́ seeki mǝ cɑɑnɑɑ nɑ mǝ toonɑɑ ɩsɩɩ mǝ Ɩsɔ Tɑcɑɑ tʋ-mɛ tɔ. Ɩlɛnɑ mǝ weesuɣu tɑɣɑlɩ nɑ ɩ́ cɑɣɑnɑ mǝ tǝɣɩ tɛtʋ nti ɩ hɑ-mɛ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Ɩ́ tɑɑ kʋ yʋlʋ. ");
INSERT INTO dop_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Ɩ́ tɑɑ lɑ wɑsɑŋkɑlǝtʋ. ");
INSERT INTO dop_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Ɩ́ tɑɑ ŋmɩɩlɩ. ");
INSERT INTO dop_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Ɩ́ tɑɑ yɔɣɔtɩ nti ɩ́ tɑ́ nɑ́ tɔɣɔ nɔɣɔlʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Ɩ́ tɑɑ nyɩɩlɩ mǝ tɔɣɔntǝlɛ ɑlʋ, yɑɑ ɩ tǝyɑɣɑ, yɑɑ ɩ tɑɑlɛ, yɑɑ ɩ yom yɑɑ ɩ nɑʋ yɑɑ ɩ kpɑŋɑɣɑ, yɑɑ ɩ pʋlʋpʋ. ");
INSERT INTO dop_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Sɑɑ wei pʋɣʋ mʋkɑɣɑ kɔkɔ, nɑ ɩsɔŋmʋntʋ nɑ sǝkpɛtʋɣʋ nyɑlɑɑ tɔ, kʋsǝsɩɩtʋ tǝnɛɣɛ Tɑcɑɑ sɩɩkɑɣɑnɑ nɔɣɔ sɔsɑɣɑ kɛ kɑ tɑɑ, nɑ mǝ sɑmɑɑ tǝnɑ nɩɩ, ɩ tɑ sɔɔsɩ nɑtǝlɩ. Ɩlɛnɑ ɩ́ ŋmɑɑ-tǝɣɩ pɛɛ kpɑɑtɑnɑɑ nɑɑlɛ tɔɔ, nɑ ɩ́ cɛlɛ-m. ");
INSERT INTO dop_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Wɑɑtʋ wei ɩ́ nɩɩ Ɩsɔ nɔɣɔ ŋkɛɣɛ sǝkpɛtʋɣʋ tɛɛ, nɑ pʋɣʋ nɑ́ɑ́ tɔŋnɑ kɔkɔ kɛ mʋɣʋ tɔ, mǝ lʋlʋŋ nyɔɔŋ nyǝ́mɑ nɑ mǝ tɑɑ sɔsɑɑ tǝnɑ kpǝtǝnɑ-m, nɑ pɑ́ yɔɣɔtɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Tɑ Ɩsɔ Tɑcɑɑ hʋlɑ́-tʋɣʋ ɩ teeli nɑ ɩ sɔsɔɔntʋ nɑ tǝ nɩɩ ɩ nɔɣɔ kɛ kɔkɔ tɑɑ. Sɑŋɑ ntɛ́ tǝ nɑwɑ sɩ Ɩsɔ yɔɣɔtǝɣǝnɑ yʋlʋ nɑ ɩ́ tɑ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Ɩlɛ nɔɔnɔɔ pepe tɔɔ kɛ́ pǝ wɛɛ sɩ tǝ́ sɩ? Mpi tɔ, kɔkɔ sɔsɑɣɑ kɑnɛ kɑɑ nyɑɣɑ-tʋɣʋ, ye tɑ Ɩsɔ tɔŋnɑ-tʋɣʋ yɔɣɔtǝnɑʋ ɩsɩɩ tǝ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Tɑmpɑnɑ tɔɔ, yʋlʋ wei kɛ́ Ɩsɔ weesuɣu tʋ tɛmɑ yɔɣɔtǝnɑʋ kɛ kɔkɔ tɑɑ ɩsɩɩ tɑ nɩɩkʋɣʋ ɩsǝntɔ tɔ nɑ pʋntʋ wɛnɑ weesuɣu? ");
INSERT INTO dop_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Pǝ tɔɔ tɔ, Moisi, kpǝtǝnɑ Tɑcɑɑ nɑ ń nɩɩ ɩ kʋyɔɣɔtʋtʋ, nɑ ń tɛlǝsɩ-tʋ nɑ tǝ́ mʋ́ nɑ tǝ́ lɑ́. ");
INSERT INTO dop_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Ḿpʋ́ɣʋ́ Tɑcɑɑ cɔwɑ sɩ: Mɑ nɩɩwɑ yǝlɑɑ mpɛ pɑ kʋsǝlǝmʋtʋ. Pɑ wɛnɑ tɑmpɑnɑ. ");
INSERT INTO dop_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Ɩlɛ ye pɑ́ɑ́ wɛ́ɛ́nɑ́ lǝmɑɣɑsǝlɛ tǝnɛ ɩnǝɣɩ tɑm nɑ pɑ́ nyɑŋnɑ-m nɑ pɑ́ tɔkǝɣɩ mɑ kʋsǝsɩɩtʋ, hɑlɩ pɑ́ nɑ pɑ piyɑ pɑɑ hɛɛsɑ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Mpʋ tɔ, Moisi polo nɑ ń heeli-wɛ sɩ: Pɑɑ wei ɩ́ mǝlɩ ɩ́ cɑcɑkʋ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Amɑ Moisi nyɑɑ cɑɣɑ mɑ kiŋ nɑ mɑ́ kɛɛsɩ-ŋ tǝ tǝnɑ nti mɑ cɑɑ sɩ ń tʋ-wɛ tɔ, nɑ kʋtʋtʋtʋ nɑ kʋsǝsɩɩtʋ nti n kɑ́ sɛɣɛsɩ-wɛ tɔ, nɑ pɑ́ tɔkɩ-tǝɣɩ tɛtʋ nti mɑ hɑ-wɛ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Ḿpʋ́ɣʋ́ Moisi tɔmɑ sɩ: Ɩ́ pɑɑsǝnɑ teu nɑ ɩ́ lɑkɩ nti nti pǝ sɩɩ-mɛɣɛ mpʋ tɔ. Ɩ́ tɑɑ hɛlǝnɑ ŋwɑɑŋ yɑɑ mpǝlɛ. ");
INSERT INTO dop_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Mpɑɑʋ ŋku Tɑcɑɑ mǝ Ɩsɔ hʋ́lɑ́-mɛ tɔ kʋ tɑɑ kɛ́ ɩ́ kɑ́ tɔŋ teitei. Ɩlɛnɑ mǝ weesiŋ tɑɣɑlɩ nɑ ɩ́ hɛɛsɩ tɛtʋ nti ɩ hɑɑkɩ-mɛ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Mǝ Ɩsɔ Tɑcɑɑ kiiŋ nɑ kʋsǝsɩɩtʋ nɑ kʋtʋtʋtʋ nti ɩ tɔmɑ sɩ mɑ́ sɛɣɛsɩ-mɛ tɔɣɔlɔ. Ntǝɣɩ ɩ́ kɑ́ tɔkɩ tɛtʋ nti pǝ hɑ-mɛ tɔ tǝ tɑɑ nɑ ɩ́ lɑkɩ. ");
INSERT INTO dop_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Mpʋ pɩɩ yelinɑ nɑ ɩ́ nyɑŋnɑ-ɩ nɑ mǝ nɑ mǝ piyɑ nɑ mǝ sɑɑlǝnɑɑ ɩ́ tɔkɩ ɩ kʋsǝsɩɩtʋ nɑ ɩ kʋtʋtʋtʋ tǝnɑ nɑ mǝ weesiŋ tɑɣɑlɩ. ");
INSERT INTO dop_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Mpʋ tɔ, Ɩsɛɣɛlɩ nyǝ́mɑ mɛ ɩ́ nɩɩ-tɩ nɑ ɩ́ lɑkɩ-tɩ. Ɩ́ kɑ́ cɑɣɑnɑ mǝ tɩ nɑ ɩ́ lʋlɩ nɑ ɩ́ huki sɔsɔm ɩsɩɩ mǝ cɑɑnɑɑ Ɩsɔ Tɑcɑɑ kɑ heeluɣu-mɛ tɔ. Sɑɑ ɩnǝɣɩ ɩ tɔmɑ sɩ ɩ́ kɑ́ hɑ-mɛɣɛ tɛtʋ nti tǝ tɑɑ tɔɣɔnɑɣɑ nɑ kʋpɑntʋ tǝnɑ tɔlɑɑ tǝhɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Ɩsɛɣɛlɩ nyǝ́mɑ mɛ ɩ́ nɩɩ. Tɑcɑɑ tike ntɛ́ tɑ́ Ɩsɔ, nɔɣɔlʋ fɛɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Ɩ́ kɑ́ sɔɔlɩ-ɩ kɛ́ nɑ luɣu kʋlʋmʋɣʋ, nɑ mǝ lǝsɑsɩ sʋʋ-ɩ tǝmɑmmɑm, nɑ mǝ tomɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Ɩ́ tɑɑ sɔɔ ɩ kʋsǝsɩɩtʋ nti mɑ tʋɣʋ-mɛɣɛ sɑŋɑ ɩsǝntɔ tɔ, tǝ tɑɑ kʋlʋmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Ɩ́ hʋlǝɣɩ-tǝɣɩ mǝ piyɑ, pǝ́cɔ́ pɑɑ ɩ́ wɛ tǝyɑɣɑ, yɑɑ ɩ́ tɔŋ mpɑɑʋ, yɑɑ ɩ́ hǝntɑɑ, yɑɑ ɩ́ kʋlɑɑ, ɩ́ kpɛlǝmǝɣɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Ɩ́ tɑmsɩ-tǝɣɩ mǝ niŋ tɑɑ nɑ mǝ tokuŋ tɑɑ, nɑ ɩ tɑɑ sɔɔ-tɩ. ");
INSERT INTO dop_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Ɩ́ ŋmɑɑ-tǝɣɩ mǝ kutuluŋ kɑmpʋnɑɑ nɑ mǝ ɑcɑlɛɛ nɔnɔɔsɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Tɑcɑɑ mǝ Ɩsɔ kɑ́ sʋsɩ-mɛɣɛ nɔɔnɔɔ kɛ́ tɛtʋ nti ɩ kɑ heelɑ mǝ cɑɑnɑɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ sɩ ɩ kɑ hɑ-wɛ tɔ. Nɑ ɩ́ tɔɣɔ ɑcɑlɛɛ sɔsɔɔnɑ kɛ fɑɑlɑɑ, ");
INSERT INTO dop_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","nɑ ɑ tɑɑ tɛɛsɩ nɑ sɩ tɑɑ suwɑ wontunɑɑ kʋpɑmɑ mpɑ ɩ́ tɑ́ suuli tɔ. Nɑ lɔkɔnɑɑ mpɑ ɩ́ tɑ́ huli tɔ, nɑ lɛsɛŋ nɑ Olifi tɩɩŋ wei ɩ́ tɑ́ tuu tɔ ɩ tɑwɑ. ");
INSERT INTO dop_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","Wɑɑtʋ wei ɩ́ kɑ́ tɔɣɔ nɑ ɩ́ hɑɣɑ tɔ ɩ́ lɑ lɑɑkɑlɩ nɑ ɩ́ tɑɑ sɔɔ Tɑcɑɑ wei ɩ lǝsɑ-mɛɣɛ Icipiti tɛtʋ tɑɑ kɛ yomle tɑɑ tɔ ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Tɑcɑɑ mǝ Ɩsɔ kɛ́ ɩ́ kɑ́ nyɑŋnɑ, ɩnǝɣɩ ɩ́ kɑ́ lɑkɩ tǝmlɛ nɑ ɩ́ tuukinɑ ɩ hǝtɛ. ");
INSERT INTO dop_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Pǝ fɛɩ sɩ ɩ́ tǝŋ yǝlɑɑ mpɑ pɑ hɛkʋ tɑɑ ɩ́ wɛ mpʋ tɔ pɑ tɩɩŋ. ");
INSERT INTO dop_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Mpi tɔ, mǝ Ɩsɔ Tɑcɑɑ kisɑ kpǝpʋ. Ɩ pɑ́ɑ́nɑ́ kɑ́ huunɑ-mɛ nɑ ɩ́ kpiisi-mɛɣɛ tɛtʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Ɩ́ tɑɑ mɑɣɑsɩ Tɑcɑɑ mǝ Ɩsɔ sɩ ɩ́ nɑɑkɩ ɩ wɑɑlɩ ɩsɩɩ ɩ́ kɑ́ lɑpʋ Mɑsɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Ɩ́ tǝŋ ɩ kiiŋ nɑ ɩ kʋsǝsɩɩtʋ nɑ ɩ kʋtʋtʋtʋ nti ɩ tʋ-mɛ tɔ ");
INSERT INTO dop_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","nɑ tɑmpɑnɑ nɑ ɩ́ lɑkɩ mpi pǝ wɛ-ɩ teu tɔ. Ɩlɛnɑ ɩ nɩɩ leleŋ nɑ ɩ tɔɣɔ tɛtʋ kʋpɑmpɑntʋ nti ɩ heelinɑ mǝ cɑɑnɑɑ nɑ tuunɑʋ sɩ ɩ kɑ hɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Hɑlǝnɑ ɩ́ tɔɣɔnɩ mǝ kolontunɑɑ tǝnɑ kɛ mǝ nɔɣɔ tɔɔ ɩsɩɩ ɩ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Ye kʋyɑkʋ nɑkʋlɩ mǝ piyɑ pɔɔsɑ-mɛ sɩ: Pepe tɔɔ kɛ́ tɑ Ɩsɔ Tɑcɑɑ sɩɩ-mɛɣɛ kiiŋ nɑ kʋsǝsɩɩtʋ nɑ kʋtʋtʋtʋ tǝnɛ? ");
INSERT INTO dop_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Ɩlɛ ɩ́ kɑ́ cɔ-wɛ sɩ: Icipiti wulɑʋ kɑ tɔkǝnɑ-tʋɣʋ yomɑɑ kɛ ɩ tɛtʋ tɑɑ, ɩlɛnɑ Tɑcɑɑ cɛ-tʋ nɑ ɩ toŋ. ");
INSERT INTO dop_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Tǝ nɑwɑ piti tǝmɑ sɔsɔɔnɑ nɑ kɔkɔlɔ nyǝnɑ sɔɣɔntʋ nyǝnɑ nnɑ ɩ cɔɔsǝnɑ Icipiti nyǝ́mɑ nɑ Icipiti wulɑʋ nɑ ɩ yǝlɑɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Ɩlɛnɑ ɩ́ lǝsɩ-tʋɣʋ tǝnɑ nɑ ɩ́ ponɑ tɛtʋ nti tǝ tɑɑ ɩ kɑ heelɑ tɑ́ cɑɑnɑɑ nɑ tuunɑʋ sɩ ɩ kɑ́ hɑ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Ḿpʋ́ɣʋ́ ɩ tʋ-tʋ sɩ tǝ́ tɔkɩ ɩ kʋsǝsɩɩtʋ tǝnɑ nɑ tǝ́ nyɑŋnɑ-ɩ nɑ tǝ́ nɩɩkɩ leleŋ kɛ tɑm. Ɩlɛnɑ ɩ́ sɩɩ tɑ́ weesiŋ ɩsɩɩ ɩ lɑpʋ sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Ye tǝ tǝŋǝɣɩ ɩ kʋsǝsɩɩtʋ tǝnɑɣɑ teu ɩsɩɩ ɩ sɩɩʋ tɔ, ɩ lɑŋlɛ kɑ́ hɛɛnɑ tɑ tɔntɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Ḿpʋ́ɣʋ́ Moisi tɑsɑɑ sɩ: Wɑɑtʋ wei Tɑcɑɑ kɑ́ tɔɣɔnɩ piitimnɑɑ sɔsɔɔm toŋ nyǝm nɑɑtosompɔɣɔlɑɣɑ, ɩlɛnɑ ɩ́ cɛlɛ-mɛɣɛ pɑ tɛtʋ. Ntǝɣǝlɛ Hiti nɑ Kilikɑsɩ nɑ Amolii nɑ Kɑnɑɑŋ nɑ Peliisi nɑ Hifi nɑ Yepusi pǝ tɛtʋnɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Ɩ kɑ́ tʋ́ piitimnɑɑ mpɛɣɛ mǝ niŋ tɑɑ nɑ ɩ́ kǝlɩ-wɛ, nɑ ɩ́ kpiisi-wɛ. Pǝ fɛɩ sɩ ɩ́ wɛɛnɑ pɑ pǝtɔɔtǝlɛ nɑ mǝ nɑ-wɛ ɩ́ pɛɛlɩ nɔɣɔ nɑkǝlɩ. ");
INSERT INTO dop_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Mǝ nɑ-wɛ ɩ́ tɑɑ kpɛntɩ ɑkpɑɣɑlɛ tɑɑ. Ɩ́ tɑɑ hɑ mǝ pɛɛlɑɑ kɛ pɑ pǝyɑlɑɑ, yɑɑ ɩ́ cɑɑ pɑ pɛɛlɑɑ kɛ mǝ pǝyɑlɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Mpi tɔ, ye ɩ lɑpɑ mpʋ, ɩsɩɩ pɑ tolisɑ mǝ piyɑ nɑ pɛlɛ pɑ́ tǝŋ tɩɩŋ. Ɩlɛnɑ Tɑcɑɑ mʋ-mɛ nɑ pɑ́ɑ́nɑ́ nɑ ɩ kʋ-mɛɣɛ kpɑkpɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Amɑ pǝ wɛɛ kɛ́ sɩ ɩ́ wɑkǝlɩ pɑ tǝlɑɑlɛnɑɑ, nɑ ɩ́ yɔkɩ pɛɛ kʋlɑlɑɑnɑ, nɑ ɩ́ sɛtɩ pɑ tesikɑsɩ nɑ ɩ́ nyɑɣɑsɩ pɑ tɩɩŋ kɛ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Mǝ Ɩsɔ Tɑcɑɑ nyǝnǝɣɩ-mɛɣɛ ɩ nyǝ́mɑ kɛ́. Ɩnɩ ɩ lǝsǝnɑ-mɛ sɩ ɩ́ pǝsɩ ɩ yǝlɑɑ kɛ ɑntulinyɑ piitimnɑɑ hɛkʋ. ");
INSERT INTO dop_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Pǝ tɑɣɑ ɩsɩɩ ɩ́ tɛɛ piitimnɑɑ tǝnɑɣɑ pɑɣɑlɛ tɔɣɔ Tɑcɑɑ luɣu sʋʋ-mɛ nɑ ɩ́ lǝsɩ-mɛ. Hɑlɩ mɛɣɛlɛ piitim sǝkpem kɛ lɛmpɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Amɑ ɩ luɣu wɛ-mɛɣɛ nɑ ɩ́ sɔɔlɩ sɩ ɩ́ tɔkɩ nɔɣɔ ŋkɑ ɩ kɑ sɩɩ mǝ cɑɑnɑɑ tɔ. Nɑ ɩ́ cɛ-mɛɣɛ Icipiti wulɑʋ yomle tɑɑ nɑ ɩ toŋ sɔsɔɔŋ nɑ ɩ́ lǝsɩ-mɛ. ");
INSERT INTO dop_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Pǝ wɛɛ sɩ ɩ́ nyɩ sɩ Tɑcɑɑ tike ntɛ́ Ɩsɔ. Ɩ tɔkɑ ɩ nɔɣɔ sɩɩʋ kɛ́ nɑ ɩ́ pɑɑsǝɣǝnɑ mpɑ pɑ sɔɔlǝɣɩ-ɩ nɑ pɑ́ tɔkǝɣɩ ɩ kʋsǝsɩɩtʋ tɔ hɑlǝnɑ pɑ lʋlʋŋ loosi iyɑɣɑ (1000). ");
INSERT INTO dop_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Amɑ ɩ hɔŋ mpɑ pɑɑ cɑɑ-ɩ tɔ pɑ ŋkpɑŋŋ kɛ kpɑkpɑɑ, nɑ ɩ́ kpiisiɣi-wɛ. ");
INSERT INTO dop_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Mpʋ tɔ, ɩ́ tɔkɩ kiiŋ nɑ kʋsǝsɩɩtʋ nɑ kʋtʋtʋtʋ nti mɑ tʋ-mɛɣɛ sɑŋɑ ɩsǝntɔ tɔ nɑ ɩ́ lɑkɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Ye ɩ́ nɩɩkɩ Tɑcɑɑ kʋtʋtʋtʋ nɑ ɩ tɔkǝɣɩ-tɩ nɑ ɩ́ lɑkɩ-tɩ Tɑcɑɑ mǝ Ɩsɔ kɑ́ tɔkɩ nɔɣɔ pɛɛlʋɣʋ nɑ kʋpɑntʋ nti ɩ kɑ sɩɩ mǝ cɑɑnɑɑ nɑ tuunɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Ɩ kɑ́ sɔɔlɩ-mɛ nɑ ɩ́ kooli-mɛɣɛ kʋpɑntʋ kɛ tɛtʋ nti ɩ kɑ heelinɑ mǝ cɑɑnɑɑ nɑ tuunɑʋ sɩ ɩ kɑ́ hɑ-mɛ tɔ tǝ tɑɑ. Ɩlɛnɑ mǝ nɑ mǝ tɔlɑ ɩ́ huki. Nɑ tǝ́ lʋlɩ-mɛɣɛ tɔɣɔnɑɣɑ pee nɑ nim nɑ sʋlʋm. ");
INSERT INTO dop_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Ɩsɔ kɑ́ kooli-mɛɣɛ kʋpɑntʋ nɑ pǝ́ kǝlɩ piitimnɑɑ tǝnɑ. Pɑ kɑɑ nɑ mǝ tɛɣɛ kɑɑlʋlɑɣɑ, pɑɑ ɑpɑlʋ yɑɑ ɑlʋ yɑɑ tɔtɛ. ");
INSERT INTO dop_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Tɑcɑɑ kɑ́ hɑtǝlǝnɑ-mɛɣɛ Icipiti tɑɑ kʋtɔmǝŋ ɩsɑɣɑŋ ɩnɩ ɩ tǝnɑ. Amɑ ɩ kɑ́ tʋ-ɩ mpɑ pɑɑ cɑɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Ɩ́ kɑ́ kpiisi piitimnɑɑ tǝnɑ mpɑ Tɑcɑɑ kɑ́ tʋ́ mǝ niŋ tɑɑ tɔɣɔ, ɩ́ tɑɑ wɛɛnɑ pɑ pǝtɔɔtǝlɛ. Pǝ́cɔ́ pǝ fɛɩ sɩ ɩ́ tǝŋ pɑ tɩɩŋ, tɔfɔ pǝ kpɑɑ-mɛ ɩsɩɩ kɑtɔkɑ nɑ pǝ́ kʋ-mɛ. ");
INSERT INTO dop_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Ntɑnyɩ ɩ́ kɑ́ mɑɣɑsɩ mǝ tɑɑ sɩ piitimnɑɑ mpɛ pɑ tɛɛ-mɛɣɛ pɑɣɑlɛ. Ɩ́ kɑɑ nyɩ ɩsǝnɑ ɩ́ kɑ́ lɑ nɑ ɩ́ tɔɣɔnɩ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Ɩ́ tɑɑ nyɑnɑ-wɛ. Ɩ́ tɔɔsɩ pǝ tǝnɑ mpi mǝ Ɩsɔ Tɑcɑɑ lɑpɑ Icipiti wulɑʋ nɑ Icipiti tɛtʋ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Ɩ́ nɑ́nɑ mǝ ɩsǝpǝle kɛ wɑhɑlɑnɑɑ mpɑ ɩ tʋ-wɛ tɔ, nɑ piti tǝmɑ nɑ kɔkɔlɔ nyǝnɑ wenɑ ɩ lɑpɑ nɑ ɩ́ lǝsɩ-mɛɣɛ Icipiti tɛtʋ tɑɑ nɑ tomɑ tɔ. Mpʋ ɩnɩ tɔtɔɣɔ ɩ kɑ́ lɑnɑ piitimnɑɑ mpɑ pɑ sɔɣɔntʋ ɩ wɛnɑ mpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Tɑcɑɑ mǝ Ɩsɔ kɑ́ tʋ-wɛɣɛ tʋntʋnyɑmǝŋ, nɑ pɑɑ pɑ tɑɑ lɛlɑɑ kɑ́ fiti nɑ pɑ́ ŋmɛlɩ, ɩ kɑ́ kʋ pɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Pǝ tɔɔ ɩlɛ, ɩ́ tɑɑ nyɑ-wɛ, mǝ Ɩsɔ sɔsɔ wei pɑ nyɑŋnɑ tɔ ɩ wɛ mǝ wɑɑlɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Ɩ kɑ tɔɣɔnɩ piitimnɑɑ mpɛɣɛ pǝcɔ pǝcɔɣɔ. Ɩ kɑɑ kpiisi-wɛɣɛ nɔɣɔ kʋlʋmɑɣɑ. Pǝ́ tɑɑ kɔɔ nɑ tɑɑlɛ wontu huki tɛtʋ tɑɑ nɑ tǝ́ kʋlɩ mǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","24","Mǝ Ɩsɔ kɑ́ tʋ́ pɑ nɑ pɑ ɑwulɑɑ kɛ mǝ niŋ tɑɑ, nɑ pɑ tɛɛ sʋʋkǝnɑ-mɛ, hɑlǝnɑ ɩ́ kpiisi-wɛ. Pɑ kɑɑ kpɑɣɑ mǝ tɔɔ kɛ́ nyɩɩlʋɣʋ. Pǝyele nɔɣɔlʋ kɑɑ tɑsɑ pɑ ɑwulɑɑ mpɛ pɑ hǝlɑ kɛ tɔɔsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Ɩ́ kɑ́ wɔ pɑ tɩɩŋ kʋsɑɑkǝŋ kɛ kɔkɔ. Amɑ ɩ́ tɑɑ nyɩɩlɩ pǝ tɔɔ wʋlɑ nɑ liɣitee kɛ kɔɔlʋɣʋ. Mpi tɔ, pǝ kɛ́ mǝ Ɩsɔ Tɑcɑɑ kɛ mpusi kɛ́. Pɩɩ kpɑ-mɛɣɛ ɩsɩɩ kɑtɔkɑ nɑ pǝ́ kʋ-mɛ. ");
INSERT INTO dop_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Pǝ fɛɩ sɩ ɩ́ sʋʋnɑ mpusi nyǝm mpɩ pǝ tɑɑ pʋlʋɣʋ mǝ tɛɛsɩ tɑɑ, nɑ pǝ́ pǝsɩ-mɛɣɛ mpusi nyǝ́mɑ. Pǝ wɛɛ sɩ ɩ́ nyǝnɩ-wǝɣɩ ɑcɑɑlǝtʋ kɛ́ nɑ ɩ́ kisi-wɩ nɑ ɩ́ wɑkǝlɩ-wɩ. ");
INSERT INTO dop_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑɑ sɩ: Pǝ wɛɛ sɩ ɩ́ tɔkɩ mɑ kʋsǝsɩɩtʋ nti mɑ sɩɩ-mɛɣɛ sɑŋɑ ɩsǝntɔ tɔ nɑ ɩ́ lɑkɩ-tɩ́. Mpʋ pɩ́ɩ́ lɑnɑ nɑ ɩ́ wɛɛnɑ weesuɣu nɑ ɩ́ huki. Nɑ ɩ́ tɔɣɔ tɛtʋ nti mɑ heelɑ mǝ cɑɑnɑɑ nɑ tuunɑʋ sɩ mɑɑ hɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Ɩ́ tɔɔsɩ tɔntɛ nte mǝ Ɩsɔ Tɑcɑɑ mɑ mɑ tʋ-mɛɣɛ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ pɩɩsɩ nɩɩlɛ tǝcu tɔ tǝ tɔɔ. Mɑ tʋ-mɛɣɛ kʋnyɔŋ ŋkʋɣʋ sɩ mɑ nɑɑkɩ sɩ ɩ́ cɑɑkɩ mɑ kʋsǝsɩɩtʋ tɔkʋɣʋ yɑ́ɑ́ ɩɩ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Kʋnyɔŋ ŋkʋ kʋ wɑɑlɩ kɛ́ nyɔɣɔsɩ lɩ́ɩ́-mɛ, hɑlǝnɑ mɑ tɔɔ-mɛ nɑ mɑnnɑ. Mǝ cɑɑnɑɑ yɑɑ mǝ tɑɑ nɔɣɔlʋ tɑɑ nyɩ tɔɣɔnɑɣɑ ŋkɛ. Mɑ lɑpɑ ḿpʋ́ɣʋ́ sɩ ɩ́ cɛkǝnɑ sɩ pǝ tɑɣɑ tɔɣɔnɑɣɑ tike kɛ yʋlʋ kɑ hikinɑ weesuɣu. Amɑ nɑ tɔm nti tǝ lɩɩkǝnɑ Ɩsɔ nɔɣɔ tɑɑ tɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Nɑ mǝ tɔntɛ kɑtɑtǝlɑɣɑ ŋkɛɣɛ pɩɩsɩ nɩɩlɛ ɩnɩ, mǝ wontu kʋsusuutu tɑ cǝlɩ. Pǝ́cɔ́ mǝ nɔɔhɛɛ tɑ mʋlɩ. ");
INSERT INTO dop_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Pǝ wɛɛ kɛ́ sɩ ɩ́ cɛkǝnɑ kɛ́ sɩ mǝ Ɩsɔ Tɑcɑɑ mɑ mɑ hɔŋ mǝ ŋkpɑŋʋɣʋ kɛ́ ɩsɩɩ yʋlʋ sɛɣɛsʋɣʋ ɩ pǝyɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Ɩ́ tɔ́kɩ mɑ kʋsǝsɩɩtʋ nɑ ɩ́ tɔŋ ɩsɩɩ mɑ cɑɑkɩ tɔ, nɑ ɩ́ nyɑŋnɑ-m. ");
INSERT INTO dop_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Mpi tɔ, mǝ Ɩsɔ Tɑcɑɑ mɑ mɑɑ yele nɑ ɩ́ sʋʋ tɛtʋ kʋpɑntʋ tɑɑ. Pusi kpeŋ tǝ tɑɑ kɛ́ nɑ lʋm sɛɛlɑɑ hɩɩkɩ yem kɛ́ tɛtɛkɑ nɑ pulɑsɩ tɑɑ. Nɑ lɩɩnɑ kɛ pɑɑ timpi. ");
INSERT INTO dop_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Nɑ tǝ tɑɑ tɔtɔɣɔ tɔɣɔnɑɣɑ nɑ tɩɩŋ kʋlʋlʋŋ ɩsɩɩ wei pɑ yɑɑ sɩ lɛsɛŋnɑɑ nɑ fikinɑɑ nɑ kǝlenɑtiyee nɑ olifinɑɑ tɔ pǝ tɑwɑ nɑ tɩɩŋ nim. ");
INSERT INTO dop_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Tǝnɑɣɑ ɩ́ kɑ́ tɔɣɔ nɑ ɩ́ hɑɣɑ. Ɩ́ kɑɑ lɑŋ pʋlʋpʋ. Nɑ ɩ́ lǝsǝɣɩ nyǝɣǝtʋ kɛ pɛɛ tɑɑ, nɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɛ pulɑsɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ɩ́ wɛɛkǝnɑ tɔɣɔnɑɣɑ kɛ ḿpʋ́ɣʋ́ ɑtɔlǝfɔ, ɩlɛnɑ ɩ́ sɛɛkɩ mǝ Ɩsɔ Tɑcɑɑ kɛ ɩ́ nɑ tǝmlɛ kɛ tɛtʋ kʋpɑntʋ nti ɩ hɑ-mɛɣɛ mpʋ tɔ tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Ɩ́ lɑ lɑɑkɑlɩ pǝ tɑɑ kɔɔ nɑ ɩ́ sɔɔ Tɑcɑɑ mǝ Ɩsɔ mɑ mɑ tɔɔ, nɑ ɩ́ yele mɑ kiiŋ nɑ mɑ kʋsǝsɩɩtʋ nɑ mɑ kʋtʋtʋtʋ nti mɑ hʋlɑ-mɛɣɛ sɑŋɑ ɩsǝntɔ tɔɣɔ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Ɩ́ kɑ́ kɔɔ nɑ ɩ́ wɛɛnɑ mǝ tɩ nɑ ɩ́ tɔ́kɩ nɑ ɩ́ hɑkɩ. Hɑlǝnɑ ɩ́ ŋmɑ́ tɛɛsɩ kʋpɑŋsɩ nɑ ɩ́ cɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","Mǝ tɔlɑ tǝnɑ kɑ́ huki nɑ ɩ́ wɛɛnɑ liɣitee, nɑ wʋlɑnɑɑ, nɑ mǝ wɛnɑʋ tǝnɑ sɔɔsǝɣɩ tɑm. ");
INSERT INTO dop_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Ɩ́ kpɑ mǝ tɩ, nɑ pǝ́ tɑɑ kɔɔ nɑ ɩ́ lɑ́ kɑlɑmpɑɑnɩ nɑ ɩ́ sɔɔ Tɑcɑɑ mɑ mɑ tɔɔ. Pǝ́cɔ́ mɑ cɛpǝnɑ-mɛ nɑ mɑ lǝsɩ-mɛɣɛ Icipiti yomle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Mɑ́ tiikinɑ-mɛɣɛ wʋlɑɣɑ tɛtʋ ɑnɑɑm ɩsɑɣɑʋ ɩnɛ ɩ tɑɑ kɛ́ pǝcɛŋnɑɑ nɑ pǝcɛsɩ hɛkʋ tɑɑ. Ɩ́ kɔmɑ nɑ ɩ́ tɑlɑ wʋlɑɣɑ tɑɑ nɑ lʋm fɛɩ tɔ, mɑ́ tʋlǝnɑ sɛɛlʋ tɔɔ kɛ́ kʋkpɑmʋɣʋ toŋ nyǝŋkʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Mɑ cɑlǝnɑ-mɛɣɛ mɑnnɑ wei mǝ cɑɑnɑɑ tɑɑ nyɩ tɔ. Mɑ tʋ-mɛɣɛ kʋnyɔŋ ŋkʋɣʋ sɩ mɑ nɑɑkɩ mǝ wɑɑlɩ. Ɩlɛnɑ mɑ lɑ-mɛɣɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Pǝ fɛɩ sɩ ɩ́ mɑɣɑsɩ mǝ tɑɑ sɩ mǝ toŋ nɑ mǝ niŋ kɛ ɩ́ lɑpǝnɑɑ nɑ ɩ hiki wɛnɑʋ mpɩ. ");
INSERT INTO dop_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Ɩ́ tɔɔsɩ sɩ mǝ Ɩsɔ Tɑcɑɑ hɑnɑ-mɛɣɛ toŋ nɑ ɩ́ hiki pǝ tǝnɑ. Nɑ nti ɩ lɑkɩ-mɛɣɛ sɑŋɑ ɩsǝntɔ tɔ ntɩ tǝ sɔɔsǝɣǝnɑ toŋ kɛ nɔɣɔ ŋkɑ ɩ nɑ mǝ cɑɑnɑɑ pɑɑ pɛɛlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ye ɩ́ sɔɔwɑ Tɑcɑɑ Ɩsɔ mɑ́ mɑ tɔɔ nɑ ɩ́ tǝŋǝɣɩ tɩɩŋ nɑ ɩ́ lɑkɩ-ɩ tǝmlɛ nɑ ɩ́ luŋiɣi-ɩ, mɑ heeliɣi-mɛ tǝfoo kɛ sɑŋɑ sɩ ɩ́ lepɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Pɔpɔtʋ fɛɩ leleŋ ye ɩ́ kisɑ mǝ Ɩsɔ Tɑcɑɑ kɛ nɩɩnɑʋ, ɩ́ leki kɛ́ ɩsɩɩ piitimnɑɑ mpɑ ɩ tɔŋɑ kʋɣʋ kɛ mǝ ɩsɛntɑɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Ḿpʋ́ɣʋ́ Moisi tɔmɑ sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ mɛ, ɩ́ ke nkpɑŋŋ. Sɑŋɑ ɩ́ tɛsǝɣɩ Yɑɑtɑnɩ kɛ́ sɩ ɩ́ tɔɣɔnɩ piitimnɑɑ mpɑ pɑ kǝlɑ-mɛɣɛ pɑɣɑlɛ nɑ toŋ tɔ. Ɩlɛnɑ ɩ́ tɔɣɔ pɑ ɑcɑlɛɛ sɔsɔɔnɑ wenɑ ɑ koloosi kɑlǝsǝnɑ ɩsɔtɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Tɛtʋ ntɩ tǝ yǝlɑɑ kiiwɑɣɑ nɑ pɑ kɛ́ tookonɑɑ. Mpɛɣɛlɛ Anɑkɩ nyǝ́mɑ mpɑ pɑ pʋɣʋlǝɣɩ sɩ nɔɣɔlʋ tɑ tɑlɑ ɩ́ yoonɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Amɑ ɩ́ cɛkǝnɑ teu sɩ mǝ Ɩsɔ Tɑcɑɑ kɑ́ tɛɛnɑ-mɛɣɛ nɔɣɔ kɛ ɩ mɑɣɑmɑɣɑ, ɩsɩɩ kɔkɔ mʋkʋɣʋ nyɩɩʋ tɔ. Nɑ ɩ́ wɑkǝlɩ-wɛ nɑ pɑ́ hʋʋ. Ɩlɛnɑ mɩ́ɩ́ ŋmili pɑ tɔɔ nɑ ɩ́ tɔɣɔnɩ-wɛ nɑ ɩ́ kʋ-wɛɣɛ kpɑkpɑɑ ɩsɩɩ ɩ kɑ heeluɣu-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Wɑɑtʋ wei mǝ Ɩsɔ Tɑcɑɑ kɑ́ tɔɣɔnɩ piitimnɑɑ mpɛɣɛ mǝ nɔɣɔ tɔɔ tɔ, ɩ́ tɑɑ mɑɣɑsɩ mǝ tɑɑ sɩ mǝ siɣisuɣu tɔɔ kɛ́ Ɩsɔ hɑɑkɩ-mɛɣɛ tɛtʋ tǝnɛ. Mpi tɔ, piitimnɑɑ mpɛ pɑ ɩsɑɣɑtʋ tɔɔ kɛ́ Ɩsɔ tɔɣɔnǝɣɩ-wɛɣɛ mǝ nɔɣɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Pǝ tɑɣɑ mǝ siɣisuɣu nɑ mǝ tɑmpɑnɑ tǝŋʋɣʋ tɔɔ kɛ ɩ́ mʋɣɩ pɑ tɛtʋ. Amɑ piitimnɑɑ mpɛ pɑ ɩsɑɣɑtʋ tɔɔ kɛ́ Tɑcɑɑ tɔɣɔnǝɣɩ-wɛɣɛ mǝ nɔɣɔ tɔɔ. Ɩsɔ lɑpɑ ḿpʋ́ɣʋ́ sɩ pǝ́ lɑ ɩsɩɩ ɩ kɑ heeluɣu nɑ tuunɑʋ kɛ mǝ cɔsɔnɑɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Ɩ́ nyɩ teu sɩ, pǝ tɑɣɑ mǝ tɑmpɑnɑ tǝŋʋɣʋ tɔɔ kɛ́ ɩ hɑ-mɛɣɛ tɛtʋ kʋpɑntʋ tǝnɛ sɩ tǝ́ pǝsɩ mǝ nyǝntʋ. Mpi tɔ, mǝ mɑɣɑmɑɣɑ ɩ́ wɛ kɑŋkɑnɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Ɩ́ tɔɔsɩ teu kɛ ɩsǝnɑ ɩ́ kpɑɑsɑ Tɑcɑɑ pɑ́ɑ́nɑ́ kɛ wʋlɑɣɑ tɛtʋ tɑɑ tɔ. Hɑtoo mǝ lɩɩʋ kɛ Icipiti hɑlǝnɑ mǝ tɑtɛ kɛ cǝnɛ tɔ, ɩ́ kʋlǝɣɩ Tɑcɑɑ tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Holɛpʋ pʋɣʋ luɣu kɛ ɩ́ kpɑɑsɑ Tɑcɑɑ pɑ́ɑ́nɑ́ nɑ ɩ́lɛ́ ɩ tɑɑ huunɑ-mɛ nɑ ɩ́ mɑɣɑsɩ sɩ ɩ kʋɣɩ-mɛ́. ");
INSERT INTO dop_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Wɑɑtʋ ɩnǝɣɩ mɑ kpɑ pʋɣʋ tɑɑ sɩ Tɑcɑɑ cɛlǝɣɩ-m pɛɛ kpɑɑtɑnɑɑ mpɑ pɑ tɔɔ ɩ́ ŋmɑɑ nɔɔsɩ nsi mǝ nɑ-ɩ ɩ pɛɛlɑɑ tɔ pǝ tɔm tɔ. Hɑlǝnɑ mɑ́ sɑɑlɩ tǝnɑɣɑ kʋyɛɛŋ nɩɩlɛ tǝcu mɑ tɑ tɔɣɔ mɑ tɑ nyɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Ḿpʋ́ɣʋ́ Tɑcɑɑ cɛlɑ-m pɛɛ kpɑɑtɑnɑɑ nɑɑlɛ mpɑ pɑ tɔɔ ɩ mɑɣɑmɑɣɑ ɩ kɑ ŋmɑɑwɑ kʋsǝsɩɩtʋ tǝnɑ nti ɩ heelɑ-mɛɣɛ kɔkɔ tɑɑ kɛ́ kʋyɑkʋ ŋku ɩ́ kotɑ pʋɣʋ luɣu tɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Kʋyɛɛŋ nɩɩlɛ wɑɑlɩ kɛ́ Tɑcɑɑ cɛlɑ-m nɔɣɔ pɛɛlʋɣʋ pɛɛ kpɑɑtɑnɑɑ mpɛ pɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Ɩlɛnɑ ɩ́ tɔ-m sɩ: Kʋlɩ tǝwɑkɑ nɑ ń tii lɔŋ. Mpi tɔ, mɑ yǝlɑɑ mpɑ mɑ lǝsɑ Icipiti tɑɑ tɔ pɑ wɑkǝlɑɑ. Pɑ tɑ tɑɑŋɩ mpɑɑʋ ŋku mɑ hʋlɑ-wɛ tɔ kʋ tɑɑ. Hɑlǝnɑ pɑ lu nyǝɣǝlʋɣʋ kɛ tʋɣʋ nɑ pɑ́ tɔŋnɑ lɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ yɔɣɔtʋɣʋ sɩ: Mɑ nɑɑkɩ sɩ yǝlɑɑ pɑnɛ pɑ kɛ́ kɑŋkɑnɑ nyǝ́mɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Yele nɑ mɑ́ kʋ-wɛ nɑ mɑ hɩɩsɩ pɑ hǝtɛ kɛ tɛtʋ tɑɑ. Nɑ mɑ́ lɑ́ nɑ ń huki nɑ ń pǝsɩ piitim sɔsɔɔm nɑ ń kǝlɩ-wɛɣɛ pɑɣɑlɛ nɑ toŋ. ");
INSERT INTO dop_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Ḿpʋ́ɣʋ́ mɑ mǝlɑ tiiu nɑ pʋɣʋ mʋɣɩ kɔkɔ kɛ mpʋ, nɑ nɔɣɔ pɛɛlʋɣʋ kpɑɑtɑnɑɑ mpɛɣɛ mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Mɑ kʋsɑ ɩsɛ, ɩlɛnɑ mɑ́ nɑ́ sɩ tɑmpɑnɑ ɩ́ pǝntǝnɑ mǝ Ɩsɔ Tɑcɑɑ. Ɩ́ tɑ́ leeli mpɑɑʋ ŋku ɩnɩ mɑ hʋlɑ-mɛ tɔ kʋ tɑɑ. Hɑlǝnɑ ɩ́ lu nyǝɣǝlʋɣʋ kɛ nɑʋle nɑ ɩ́ luŋiɣi. ");
INSERT INTO dop_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Tǝnɑɣɑ mɑ pɛtɑ pɛɛ kpɑɑtɑnɑɑ mpɛɣɛ ɑtɛ nɑ pɑ́ yɔkɩ mǝ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Ḿpʋ́ɣʋ́ mɑ hotɑ Tɑcɑɑ tɛɛ nɑ mɑ́ sɑɑlɩ tǝnɑɣɑ kʋyɛɛŋ nɩɩlɛ. Mɑ tɑ tɔɣɔ mɑ tɑ nyɔɔ, kɛ ɩsɑɣɑtʋ tǝnɑ nti Ɩsɛɣɛlɩ nyǝ́mɑ lɑpɑ Ɩsɔ nɑ pǝ́ kpɑɑsɩ ɩ pɑ́ɑ́nɑ́ tɔ tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Pǝ tɑɣɑ pʋlʋ, wɑɑtʋ wei mɑ́ nɑwɑ Tɑcɑɑ pɑɑnɑ huu mǝ tɔɔ, hɑlǝnɑ mɑ́ mɑɣɑsɩ sɩ mɑ kʋɣɩ-mɛ tɔ sɔɣɔntʋ kpɑ-m. Amɑ Tɑcɑɑ nɩɩ mɑ kʋsǝlǝmʋtʋ tɔtɔ nɑ ɩ́ lɑ́ ɩsɩɩ mɑ sǝlǝmɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Tɑcɑɑ mʋ Alɔŋ nɑ pɑ́ɑ́nɑ́ tɔtɔɣɔ, hɑlɩ ɩ cɑɑkɑɣɑ ɩ kʋ-ɩ. Ɩlɛnɑ mɑ́ wiinɑ-ɩ ɩ́lɛ́ ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Ḿpʋ́ɣʋ́ mɑ pɛtɑ mǝ ɩsɑɣɑtʋ kʋlʋlʋm nɑʋle ntɛɣɛ kɔkɔ tɑɑ, nɑ mɑ́ nɑŋ-tɛ nɑ mɑ́ pǝlɩ tǝ mʋlʋm kɛ lɔɔʋ ŋku kʋ kpeŋ pʋɣʋ tɑɑ tɔ kʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Mpʋ tɔtɔɣɔ ɩ́ kɑ kpɑɑsɑ Tɑcɑɑ pɑ́ɑ́nɑ́ kɛ Tɑpeelɑ nɑ Mɑsɑ nɑ Kipǝloti-Tɑɑfɑ. ");
INSERT INTO dop_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Pǝ kɔmɑ nɑ ɩ́ kʋsɩ-mɛ sɩ ɩ́ polo Kɑtɛɛsɩ-Pɑɑneyɑ nɑ ɩ́ tɔɣɔ tɛtʋ nti ɩ hɑ-mɛ tɔ. Ɩlɛnɑ ɩ́ kʋlɩ ɩ tɔɔ nɑ ɩ́ kisi ɩ nɔɣɔ kɛ nɩɩʋ. Pǝ́cɔ́ ɩ́ tɑ́ tʋ-ɩ nɑɑni. ");
INSERT INTO dop_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Hɑtoo sɑɑ wei mɑ nyǝmɑ-mɛ tɔ, ɩ́ kʋlǝɣɩ Tɑcɑɑ tɔɔ kɛ́, ɩɩ nɩɩkǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Tɑcɑɑ cɑɑkɑɣɑ-mɛɣɛ kpiisuɣu, ɩlɛnɑ mɑ́ hoti ɩ nɔɔhɛɛ tɛɛ kɛ́ kpɑkpɑɑ kɛ kʋyɛɛŋ nɩɩlɛ tǝcu. ");
INSERT INTO dop_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Nɑ mɑ́ wiinɑ-ɩ sɩ: Hɑɩ Tɑcɑɑ Ɩsɔ, tɑɑ kʋ-wɛ. Pɑ kɛ́ nyɑ́ yǝlɑɑ mpɑ n yɑpǝnɑ nyɑ́ toŋ sɔsɔɔŋ nɑ ń lǝsɩ-wɛɣɛ Icipiti tɑɑ nɑ nyɑ́ niŋ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Tɔɔsɩ nyɑ́ tǝmlɛ nyǝ́mɑ Apǝlɑhɑm nɑ Ɩsɑɑkɑ nɑ Yɑkɔpʋ pɑ tɔɔ. Tɑɑ nyǝnɩ yǝlɑɑ pɑnɛ pɑ kɑɑnɩɩtʋ nɑ pɑ nyɑŋ nɑ pɑ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Pǝ́cɔ́ pǝ tɑɑ kɔɔ nɑ Icipiti nyǝ́mɑ tɔ́ sɩ: Tɑcɑɑ ɩɩ pǝsǝɣɩ sɩ ɩ́ tɑnɑ-wɛɣɛ tɛtʋ nti ɩ kɑ sɩ́ɩ́ ɩ nɔɣɔ sɩ ɩ kɑ́ hɑ-wɛ tɔ tǝ tɑɑ. Yɑɑ ɩ tɑɑ cɑɑkɩ-wɛ tɔɣɔ ɩ lǝsɑ-wɛ sɩ ɩ pukinɑ wʋlɑɣɑ tɛtʋ tɑɑ nɑ ɩ́ kʋ́. ");
INSERT INTO dop_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Pǝ́cɔ́ pɑ kɛ́ nyɑ́ yǝlɑɑ mpɑ n lǝsɑ Icipiti tɛtʋ tɑɑ nɑ nyɑ́ toŋ sɔsɔɔŋ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ-m sɩ: Sɑɑkɩ pɛɛ kpɑɑtɑnɑɑ kɛ nɑɑlɛ, ɩsɩɩ kɑncɑɑlɑɣɑ nyǝ́mɑ, nɑ mɑ́ kpɑɑnɑ pʋɣʋ tɑɑ kɛ́ ɩ kiŋ, nɑ mɑ́ kɑ́ pǝ ɑtɑkɑɑ kɛ́ tɑɑsɩ. ");
INSERT INTO dop_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Tɛlǝsɩ kɑncɑɑlɑɣɑ nyǝ́mɑ mpɑ mɑ yɔkɑɑ tɔ pɑ tɔɔ tɔm kɛ kʋfɑmɑ tɔɔ ɩlɛnɑ mɑ́ sɩɩ-wɛɣɛ ɑtɑkɑɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Ḿpʋ́ɣʋ́ mɑ cɑɑ kpeŋkpelɑsɩ toŋ nyǝnsɩ nɑ mɑ́ kɑ́ ɑtɑkɑɑ, nɑ mɑ́ sɑɑkɩ pɛɛ kpɑɑtɑnɑɑ, nɑ mɑ́ kpɑɑnɑ-wɛɣɛ pʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Ɩlɛnɑ Tɑcɑɑ tɛlǝsɩ pɑ tɔɔ kɛ́ kʋsǝsɩɩtʋ nɑɑnʋwɑ wei ɩ kɑ kɛɛsɑ kɔkɔ tɑɑ kɛ́ kʋyɑŋku mǝ tǝnɑ ɩ́ kotɑ pʋɣʋ luɣu tɛɛ tɔ, nɑ ɩ́ cɛlɛ-m. ");
INSERT INTO dop_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Ɩlɛnɑ mɑ́ tii nɑ mɑ́ tʋ́ pɛɛ kpɑɑtɑnɑɑ mpɛɣɛ ɑtɑkɑɑ wei mɑ sɑɑkɑ mpʋ tɔ ɩ tɑɑ. Nɑ ɑ́ wɛ tǝnɑ ɩsɩɩ Tɑcɑɑ kɑ heelɑ-m tɔ. ");
INSERT INTO dop_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ kʋlɑ Pene-Yɑkɑŋ lɔkɔnɑɑ cɔlɔ nɑ pɑ́ tɛɛ Moselɑ. Tǝnɑɣɑ Alɔŋ sǝpɑ nɑ pɑ́ pimi-ɩ nɑ ɩ pǝyɑlʋ Ɩliyɑsɑɑ kpɑɣɑ ɩ kɔtʋɣʋ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Pɑ kʋlɑ tǝnɑ, ɩlɛnɑ pɑ́ tɛɛ Kukotɑ. Pɑ lɩ́ɩ́ tǝnɑ nɑ pɑ́ polo Yopǝtɑ. Tɛtʋ ntɩ tǝ tɑɑ kɑ wɛ lʋm kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Wɑɑtʋ ɩnǝɣɩ Tɑcɑɑ fɑɣɑ Lefii lʋlʋɣʋ nyǝ́mɑ nɑ pɑ mpɑɑ, nɑ ɩ́ tʋ́-wɛ sɩ pɑ́ sǝɣǝlǝɣɩ Ɩsɔ ɑtɑkɑɑ nɑ pɑ́ sʋʋkɩ ɩ cokǝle tɑɑ nɑ pɑ́ lɑkɩ-ɩ tǝmlɛ nɑ pɑ́ kooliɣi yǝlɑɑ kɛ kʋpɑntʋ nɑ ɩ hǝtɛ kɛ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Mpʋ pǝ yelinɑ nɑ Lefii nyǝ́mɑ fɛɩnɑ hɑlǝm ɩsɩɩ pɑ tɛɛtʋnɑɑ. Ɩlɛ Tɑcɑɑ kɑ heelɑ-wɛɣɛ sɩ ɩnǝɣǝlɛ pɑ nyǝm. ");
INSERT INTO dop_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Ḿpʋ́ɣʋ́ mɑ cɑɣɑ pʋɣʋ tɑɑ tɔtɔɣɔ kʋyɛɛŋ nɩɩlɛ, nɑ Tɑcɑɑ tɑsɑ mʋɣʋ kɛ nti mɑ sǝlǝmɑ-ɩ tɔ, nɑ ɩ́ lɔ mǝ kʋɣʋ tɔm. ");
INSERT INTO dop_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Hɑlǝnɑ ɩ́ tɔ-m sɩ mɑ́ polo nɑ mɑ́ tɛɛ sɑmɑɑ kɛ nɔɣɔ nɑ pɑ́ tɔɣɔ tɛtʋ nti ɩ kɑ heelɑ pɑ cɑɑnɑɑ nɑ tuunɑʋ sɩ ɩ kɑ́ hɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Ɩsɛɣɛlɩ nyǝ́mɑ mɛ, mpi Tɑcɑɑ cɑɑkɩ tɔɣɔlɛ sɩ ɩ́ nyɑnɑ-ɩ nɑ ɩ́ tǝŋ ɩ mpɑɑŋ tǝnɑ tɑɑ kɛ́ teitei nɑ ɩ́ sɔɔlɩ-ɩ nɑ ɩ́ lɑpɩ-ɩ tǝmlɛ nɑ mǝ lotu tǝnɑ nɑ mǝ lǝsɑɣɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","Tɑcɑɑ cɑɑ kɛ́ sɩ ɩ́ tɔ́kɩ ɩ kʋsǝsɩɩtʋ nɑ ɩ kiiŋ wei mɑ hʋlɑ-mɛɣɛ sɑŋɑ ɩsǝntɔ tɔ. Nɑ pǝ́ yele nɑ ɩ́ cɑɣɑnɑ mǝ tɩ tǝpɛlɛkɛtɛɛ. ");
INSERT INTO dop_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Ɩnɩ ɩ tǝnnɑ ɩsɔtɔnǝŋ ɩnɩ ɩ tǝnɑ, nɑ tɛtʋ nɑ pǝ tǝnɑ mpi pǝ wɛ tǝ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Pǝ́cɔ́ mǝ cɑɑnɑɑ tike kɛ Tɑcɑɑ luɣu sʋʋwɑ. Pǝ wɑɑlɩ kɛ́ pɑ piyɑ mɛ, ɩlɛnɑ ɩ́ lǝsɩ-mɛɣɛ piitimnɑɑ tǝnɑ tɑɑ, ɩsɩɩ ɩ́ nɑɑkʋɣʋ sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Mpʋ tɔ, ɩ́ lɑɣɑsɩ hɑtoo mǝ nyɑmɑ tɑɑ tǝkpɑtɑɑ, ɩ́ tɑɑ tɑsɑ lɑŋkpɩɩsǝŋ. ");
INSERT INTO dop_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Mpi tɔ, Tɑcɑɑ kɛlɛ sɔsɑɑ tɑɑ sɔsɔ, nɑ ɩ tike ntɛ́ Ɩsɔ. Ɩ kɛ́ toŋtʋ wei pɑ nyɔkǝɣɩ tɔɣɔ. Ɩɩ fɑɣɑsǝɣɩ yǝlɑɑ. Pǝyele ɩ pɑɑ fɛɩnɑ kʋhɑʋ ɩsɩɩ yʋlʋ nɑ pǝ́cɔ́ ɩ hɑ tɑmpɑnɑ. ");
INSERT INTO dop_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ɩnɩ ɩ tɑɣɑnǝɣǝnɑ sulɑʋ nɑ leelu pɑ tɔm. Pǝyele ɩ sɔɔlɑ mʋʋlʋ kɛ́ nɑ ɩ́ cɑlǝɣɩ-ɩ nɑ ɩ́ suuki-ɩ wontu. ");
INSERT INTO dop_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Pǝ tɔɔ kɛ́ pǝ wɛɛ sɩ mɛ tɔtɔ mɩ́ɩ́ sɔɔlɩ mʋʋlɑɑ. Mpi tɔ, mǝ mɑɣɑmɑɣɑ ɩ́ kɑ kɛ́ mʋʋlɑɑ kɛ Icipiti tɛtʋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Tɑcɑɑ mǝ Ɩsɔ kɛ́ ɩ́ kɑ́ nyɑnɑ, nɑ ɩ tike kɛ ɩ́ kɑ́ sɛɛ nɑ mǝ lǝsɑɣɑ sʋʋ-ɩ, nɑ ɩ́ sɩɩkɩ mǝ nɔɔsɩ nɑ ɩ hǝtɛ. ");
INSERT INTO dop_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Ɩ tike ntɛ́ mǝ Ɩsɔ, ɩnǝɣɩ ɩ́ kɑ́ sɑŋ. Pǝ́cɔ́ ɩnɩ ɩ lɑpǝnɑ-mɛɣɛ tǝmɑ sɔsɔɔnɑ sɔɣɔntʋ nyǝnɑ wenɑ ɩ nɑnɑ mǝ ɩsǝpee tɔ. ");
INSERT INTO dop_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Mǝ cɔsɔnɑɑ tiiwɑ Icipiti tɔ pɑ wɛ yʋlʋnyɔɔŋ nɩɩtoso nɑ nɑɑnʋwɑ tike kɛ́. Amɑ Tɑcɑɑ lɑpɑ nɑ ɩ́ huki. ");
INSERT INTO dop_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Ɩsɔ tǝmlɛ tʋ Moisi sǝpɑ. Tǝnɑɣɑ Tɑcɑɑ tɔmɑ Moisi wɑɑlɩ tʋ Yosuwee, wei ɩ kɛ́ Nuŋ pǝyɑlʋ tɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Nyǝnɩ, Moisi sǝpɑ. Ɩlɛ pǝnɛntɛ nyɑɑ kʋlɩ, nɑ ń tʋ́ yǝlɑɑ pɑnɛɣɛ nɔɣɔ, nɑ ɩ́ tɛsɩ Yɑɑtɑnɩ pɔɣɔ kɑnɛ. Nɑ ɩ́ sʋʋ tɛtʋ nti mɑ hɑ Ɩsɛɣɛlɩ nyǝ́mɑ mɛ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Ɩsɩɩ mɑɑ sɩɩʋ Moisi kɛ nɔɣɔ tɔ, ye mǝ nɔɔhǝlɛ ɩ́ fɛlɑ timpi mǝ tɛtʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Mǝ tɛtʋ ntɛ́ pǝ sɩɩnɑʋ wʋlɑɣɑ tɛtʋ, nɑ pǝ́ polo Lipɑŋ pɔɔŋ tɔ. Nɑ pǝ́ kpɑɣɑ Ɩfǝlɑtɩ pɔɣɔ sɔsɑɣɑ, nɑ pǝ́ kpɛŋnɑ Hiti nyǝ́mɑ tɛtʋ tǝnɑ tɔ. Nɑ pǝ́ yoosinɑ Metitelɑnee teŋku. ");
INSERT INTO dop_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Kolontunɑɑ tǝnɑ kɑ seeki-ŋ kɛ́, hɑlǝnɑ ń sʋʋ pʋ́ʋ́ɣʋ́. Mpi tɔ, mɑɑ wɛɛ nyɑ́ wɑɑlɩ kɛ́, ɩsɩɩ mɑɑ wɛ Moisi kiŋ tɔ. Mɑ kɑɑ lɔ-ŋ, pǝyele mɑ kɑɑ hɑtǝlǝnɑ-ŋ pɑɑ pǝcɔ. ");
INSERT INTO dop_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Mpʋ tɔ, tɔɣɔ ɑpɑlʋtʋ, nɑ ń nyɔɔ toŋ. Pǝ tɑɣɑ pʋlʋ, nyɑɑ yelinɑ nɑ yǝlɑɑ pɑnɛ pɑ́ tɔɣɔ tɛtʋ nti mɑɑ heelɑ mǝ cɑɑnɑɑ nɑ tuunɑʋ sɩ mɑɑ hɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Amɑ kʋlʋmtʋ kɛ́ sɩ, nyɑɑ tɔɣɔ ɑpɑlʋtʋ, nɑ ń nyɔɔ toŋ te. Tɔkɩ mɑ kʋsǝsɩɩtʋ tǝnɑ nti mɑ tǝmlɛ tʋ Moisi tɛlǝsɑ-ŋ tɔɣɔ teu tǝcʋŋŋ, nɑ ń lɑkɩ-tɩ tǝtetete. Tɑɑ nyǝnnɑ ŋwɑɑŋ yɑɑ mpǝlɛ. Wɑɑtʋ ɩnǝɣɩ n kɑ́ wɑɑ nyɑ́ kʋlɑpǝm tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Kʋsǝsɩɩtʋ tɑkǝlɑɣɑ kɑnɛ kɑ́ tɑɑ fɛtɛ nyɑ́ nɔɣɔ tɔɔ. Kɑlǝɣɩ kɑ tɑɑ tɔm kɛ ilim nɑ ɑhoo, nɑ ń tǝŋ-tǝɣɩ teu. Wɑɑtʋ ɩnǝɣɩ pɩɩ lɑnɑ-ŋ. Pǝ́cɔ́ n kɑ́ wɑɑ pǝ tǝnɑ mpi n lɑkɩ tɔ pǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Mɑtɔŋ mɑ heelɑ-ŋ sɩ ń tɔɣɔ ɑpɑlʋtʋ nɑ ń nyɔɔ toŋ nɑ? Mpʋ tɔ, tɑɑ nyɑ́. Pǝyele tɑɑ sele pɑɑ pǝcɔ tɔtɔ. Pǝ tɑɣɑ pʋlʋ, nyɑ́ Ɩsɔ mɑ́, mɑɑ wɛɛ nyɑ́ wɑɑlɩ kɛ́ pɑɑ timpiɣi. ");
INSERT INTO dop_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Ḿpʋ́ɣʋ́ Yosuwee tɔmɑ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","Ɩ́ sʋʋ tǝsikile tɑɑ, nɑ ɩ́ heeli sɑmɑɑ sɩ pɑ́ cɑɑ mpɑɑʋ tɔɣɔnɑsɩ. Mpi tɔ, kʋyɛɛŋ tooso ɩ́ tɛɛwɑ tɩɩ tɛsɩ Yɑɑtɑnɩ, nɑ tǝ́ polo nɑ tǝ́ lɛɛkɩ tɛtʋ nti Tɑcɑɑ tɑ Ɩsɔ hɑ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Mpʋɣʋlɛ Yosuwee heelɑ Lupɛŋ nyǝ́mɑ, nɑ Kɑtɩ nyǝ́mɑ, nɑ Mɑnɑsee yǝlɑɑ hɔɣɔlʋɣʋ lɛŋkʋ nyǝ́mɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","Ɩ́ tɔɔsɩ nti Moisi kɑ heelɑ-mɛ tɔ sɩ, hɛɛsʋɣʋ kɛ Tɑcɑɑ cɑɑkǝnɑ-mɛ, nɑ ɩ́ hɑ-mɛɣɛ tɛtʋ tǝnɛ. ");
INSERT INTO dop_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Ɩlɛ mǝ ɑlɑɑ, nɑ mǝ piyɑ, nɑ mǝ tɔlɑ tike kɑ́ cɑɣɑnɑ pɔɣɔ nɑ cǝnɛ tɔɔ. Amɑ pǝ kɑɑsʋɣʋ ɑpɑlɑɑ yoolɑɑ mɛ tɔ, pǝ wɛɛ sɩ mɩɩ tɛsɩ mǝ tɛɛtʋnɑɑ cɔlɔɣɔ nɑ ɩ́ tɛɛ-wɛɣɛ nɔɣɔ nɑ ɩ́ sǝnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Hɑlǝnɑ wɑɑtʋ wei mǝ Ɩsɔ Tɑcɑɑ kɑ́ yele nɑ pɛlɛ pɑ́ hɛɛsɩ ɩsɩɩ mɛ nɑ tɛtʋ tǝnɛ ɩnɩ tǝ́ pǝsɩ mǝ tǝnɑ mǝ nyǝntʋ tɔ. Pǝ wɑɑlɩ kɛ́ ɩ́ kɑ́ mǝlɩ mǝ tɛtʋ nti Tɑcɑɑ tǝmlɛ tʋ Moisi hɑ-mɛ ɩsǝntɔ tɔ tǝ tɑɑ kɛ́ Yɑɑtɑnɩ ilim tǝlɩɩlɛ tɔɔ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Ḿpʋ́ɣʋ́ pɑ cɔwɑ Yosuwee sɩ: Tɩɩ lɑ teitei ɩsɩɩ n tʋɣʋ-tʋ tɔ. Pɑɑ timpiɣi n tilɑ-tʋ, tɩɩ polo kɛ́. ");
INSERT INTO dop_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Pǝyele tɩɩ nɩɩnɑ-ŋ teu kɛ́, ɩsɩɩ tɩɩ nɩɩkɑɣɑnɑ Moisi tɔ. Ɩsɔ ɩ́ wɛɛ nyɑ́ wɑɑlɩ, ɩsɩɩ ɩ kɑ wɛʋ Moisi wɑɑlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Ye pǝ cǝpɑ wei nɑ ɩ́ lɑ́ kɑŋkɑntɛ, nɑ ɩ́ tɔ sɩ ɩ kɑɑ tǝŋ nti n tʋ-tʋ tɔ ɩsɩɩ pɑ kʋ-ɩ. Amɑ nyɑɑ nyɔɔ toŋ kɛ́ nɑ ń tɔɣɔ ɑpɑlʋtʋ. ");
INSERT INTO dop_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Ḿpʋ́ɣʋ́ Yosuwee kʋsɑ feŋlɑɑ nɑɑlɛɣɛ mukɑɣɑ kɛ Sitim timpi pɑɑ sikɑɑ tɔ sɩ: Ɩ́ polo nɑ ɩ́ feŋ Kɑnɑɑŋ tɛtʋ ntɩ nɑ Yeliko ɩcɑtɛ. Pɑ tɑlɑ ɩcɑtɛ ntɛ́, ɩlɛnɑ pɑ́ sʋʋ ɑpɑlɑɑ tǝnɑ ɑlʋ nɔɣɔlʋ ɩ tɛɣɛ ɑhoo. Pɑ yɑɑ ɑlʋ ɩnɩ sɩ Lɑhɑpɩ. ");
INSERT INTO dop_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Mpʋɣʋlɛ yǝlɑɑ tɑɣɑsɑ Yeliko wulɑʋ sɩ: Ɩsɛɣɛlɩ yǝlɑɑ kɔmnɑ ntɛɣɛ tɛtʋ feŋuɣu. Hɑlǝnɑ pɑ́ sʋʋ cǝnɛɣɛ ɑhoo ɑnɛ. ");
INSERT INTO dop_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Tǝnɑɣɑ, wulɑʋ tilɑɑ nɑ ɩ́ heeli Lɑhɑpɩ sɩ: Yǝlɑɑ mpɑ ɩnɩ pɑ wɛ nyɑ́ tɛɣɛ mpʋ tɔ, pɑ kɛ́ tɛtʋ feŋlɑɑ kɛ́. Mpʋ tɔ, lǝsɩ-wɛɣɛ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Mpʋɣʋlɛ ɑlʋ ɩnɩ ɩ́ ŋmɛsɑ ɑpɑlɑɑ mpɛ pɑ tɔɔ, nɑ ɩ́ cɔ wulɑʋ tillɑɑ sɩ: Tɑmpɑnɑ yɑɑ, yǝlɑɑ mpɛ pɑ tɑlɑ mɑ tɛ. Amɑ mɑ tɑ nyɩ-wɛ sɩ le nyǝ́mɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Ahoo yuwɑ nɑ pɑ́ tǝkǝɣɩ ɩcɑtɛ nɔnɔɣɔ, ɩlɛnɑ pɑ́ lɩɩ. Mɑ tɑ nyɩ ŋku pɑ tǝŋɑɑ tɔ. Ye ɩ́ tǝŋɑ pɑ wɑɑlɩ kɛ lɔŋlɔŋ, ɩ́ kɑ́ hiki-wɛ. ");
INSERT INTO dop_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","Pǝyele Lɑhɑpɩ kɑ kpɑɑsɑ feŋlɑɑ mpɛɣɛ ɩ kutuluɣu pɑtɑ tɔɔ kɛ́, nɑ ɩ́ ŋmɛsɩ-wɛɣɛ ŋmʋntʋ nti pɑ yɑɑ sɩ lɛŋ tɔ tǝ tɛɛ. yɑɑ sɩ lɛŋ. Pɑ lʋʋkɩ-tǝɣɩ pɔɔŋ kɛ́ Ɩsɩɩ kponkpontu, nɑ pǝ pɔɔŋ nɑ pǝ tokonɑɑ kɛ́ liɣitee wontu kɛ́. ");
INSERT INTO dop_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Mpʋɣʋlɛ wulɑʋ tillɑɑ kpɑɣɑ mpɑɑʋ ŋku pɑ tɛsǝɣǝnɑ Yɑɑtɑnɩ pɔɣɔ tɔ, nɑ pɑ́ se feŋlɑɑ wɑɑlɩ. Ɩlɛnɑ tɑŋlɑɑ tɑɣɑnɩ ɩcɑtɛ nɔnɔɣɔ kɛ tǝkʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Pǝ wɑɑlɩ kɛ́ Lɑhɑpɩ kpɑ feŋlɑɑ cɔlɔ nɑ pǝ́cɔ́ pɑ́ too, nɑ ɩ́ tɔ-wɛ sɩ: ");
INSERT INTO dop_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","Mɑ nyǝmɑ́ sɩ Tɑcɑɑ tʋwɑ tɛtʋ tǝnɛɣɛ mǝ niŋ tɑɑ. Mǝ sɔɣɔntʋ sʋʋ ɩcɑtɛ tǝnɛ tǝ nyǝ́mɑ kɛ́ nɑ pɑ́ seliɣi. ");
INSERT INTO dop_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Tǝ nɩɩwɑ ɩsǝnɑ, wɑɑtʋ wei ɩ́ lɩɩ Icipiti tɑɑ tɔ, Ɩsɔ fɑɣɑ Sǝsǝncɑɑsɩ teŋku lʋm tɑɑ, nɑ mɩɩ tɛɛ puɣulɑɣɑ tɔɔ tɔ. Tǝ nɩɩwɑ tɔtɔɣɔ, ɩsǝnɑ ɩ́ kʋwɑ Amolii nyǝ́mɑ ɑwulɑɑ sɔsɑɑ Sihoŋ nɑ Oki, nɑ ɩ́ wɑkǝlɩ pɑ nyǝm tǝnɑɣɑ pɔɣɔ wɑɑlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Tǝ nɩɩ-tɩ, ɩlɛnɑ tɑ ɑpɑlʋtʋ le-tʋ, nɑ tɑ́ tɛɛ sʋʋkǝnɑ-mɛ. Mpi tɔ, mǝ Ɩsɔ Tɑcɑɑ tike ntɛ́ ɩsɔtɑɑ nɑ ɑtɛ pǝ tʋ. ");
INSERT INTO dop_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Pǝnɛntɛ mɑ wiikinɑ-mɛ sɩ, ɩ́ tuunɑ Tɑcɑɑ sɩ ɩ́ kɑ́ hʋ́lɩ́ mɑ cɑɑ tǝyɑɣɑ kɛ suulu ɩsɩɩ mɑ hʋlʋɣʋ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Ɩ́ lɑ mpi pɩɩ tʋ-m nɑɑni sɩ ɩ kɑɑ kʋ mɑ cɑɑ, nɑ mɑ too, nɑ mɑ tɑɑlʋnɑɑ, nɑ mɑ kɔɣɔnɑɑ, nɑ mɑ newɑɑ nɑ pɑ nyǝmɑnɑɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Mpʋɣʋlɛ ɑpɑlɑɑ mpɛ pɑ cɔ-ɩ sɩ: Ye n tɑ tɑɣɑsɩ tɑ́ tɔm tɑ́ sɔɔlʋ pɩɩwɑɣɑ sɩ tǝ́ sɩ mǝ sǝm, nɑ pǝ́ kɔmɑ nɑ Tɑcɑɑ tʋ tɑ́ niŋ tɑɑ kɛ́ tɛtʋ tǝnɛ tɩɩ lɑ-ŋ kʋpɑntʋ kɛ́, tǝ kɑɑ kpɑlɩ nyɑ́ kʋcɔɔʋ. ");
INSERT INTO dop_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","Mpʋɣʋlɛ Lɑhɑpɩ tisɑ ɑpɑlɑɑ mpɛ nɑ ŋmǝnɑɣɑ nɑ ɩ kutuluɣu pǝtote. Mpi pǝ tɔɔ tɔ, kɩɩ wɛ ɩcɑtɛ koluŋɑ tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","Ɩlɛnɑ ɩ́ heeli-wɛ sɩ: Ɩ́ tǝŋ pʋɣʋ mpɑɑʋ, pǝ́ tɑɑ kɔɔ nɑ mpɑ pɑ sewɑ mǝ wɑɑlɩ tɔ pɑ́ suli-mɛ. Ɩ́ ŋmɛlɩ pʋɣʋ tɑɑ tǝnɑɣɑ kʋyɛɛŋ tooso nɑ mǝ wɑɑlɩ selɑɑ tǝnɑ tɛ mǝlʋɣʋ. Pǝlɛ pǝ wɑɑlɩ, ɩlɛ ɩ́ kɑ́ tʋ́ mǝ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","Ntɛnɑ ɑpɑlɑɑ mpɛ pɑ tɔmɩ-ɩ sɩ: Nyǝnɩ, ɩsǝnɑ n kɑ́ lɑ nɑ tǝ́ tɔkǝnɑ tuunɑʋ mpi n yelɑɑ nɑ tǝ́ tuunɑ tɔɣɔlɔ. ");
INSERT INTO dop_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","Wɑɑtʋ wei tɩɩ sʋʋ tɛtʋ tǝnɛ tǝ tɑɑ tɔ, tǝ́ mɑɣɑnɑ n tʋwɑ ŋmǝnɑɣɑ kʋsɛɛmɑɣɑ nɑ nyɑ́ pǝtote nte n tisinɑ-tʋ ɩsǝntɔ tɔ. Nɑ ń kotɑ nyɑ́ cɑɑ, nɑ nyɑ́ too, nɑ nyɑ́ tɑɑlʋnɑɑ nɑ nyɑ́ newɑɑ, nɑ nyɑ́ cɑɑ lʋlʋɣʋ nyǝ́mɑ tǝnɑɣɑ nyɑ́ tǝyɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Amɑ ye pǝ cǝpɑ pɑ tɑɑ wei nɑ ɩ́ lɩɩ nyɑ́ tǝyɑɣɑ tɑɑ, pʋntʋ sǝm kɑ́ wɛɛ ɩ nyʋɣʋ tɔm kɛ́, pǝ tɑɣɑ tɑ́ nyǝntʋ. Tɔfɔ, ye mpɛ ɩnɩ pɑ tɑɑ nɔɣɔlʋ nyʋɣʋ holɑ-ɩ, ɩlɛ pǝ kɛ́ tɑ tɔm. ");
INSERT INTO dop_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","Amɑ ye n tɑɣɑsɑ tɑ tɔm, ɩlɛ tɑ kɑɑ tɔkɩ tɑ́ nɔɣɔ sɩɩʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Ɩlɛnɑ ɑlʋ ɩnɩ ɩ cɔ sɩ: Pǝ lɑ ɩsɩɩ ɩ́ yɔɣɔtʋɣʋ tɔ. Ɩlɛnɑ ɑlʋ yele feŋlɑɑ nɑ pɑ́ tɛɛ. Ḿpʋ́ɣʋ́ ɩ tʋ ŋmǝnɑɣɑ kʋsɛɛmɑɣɑ nɑ ɩ pǝtote. ");
INSERT INTO dop_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Apɑlɑɑ mpɛ pɑ tɑlɑ pɔɔŋ tɑɑ, ɩlɛnɑ pɑ́ ŋmɛlɩ tǝnɑɣɑ kʋyɛɛŋ tooso. Hɑlǝnɑ mpɑ pɑɑ sewɑ pɑ wɑɑlɩ tɔ, pɑ́ pɛɛkɩ-wɛɣɛ hɔɣɔlʋɣʋ ŋkʋ kʋ tǝnɑ kʋ tɑɑ, pɑ tɑ nɑ-wɛ. Ɩlɛnɑ pɑ́ mǝlɩ kpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Ḿpʋ́ɣʋ́ feŋlɑɑ mpɛ pɑ mǝlɑɑ nɑ pɑ́ tii pʋɣʋ, nɑ pɑ́ tɛsɩ Yɑɑtɑnɩ. Ɩlɛnɑ pɑ́ kpe nɑ pɑ́ kɛɛsɩ Yosuwee kɛ pǝ tǝnɑ mpi pǝ mɑɣɑnɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Nɑ pɑ́ yɔɣɔtɩ tɔtɔ sɩ, pɔpɔtʋ fɛɩ leleŋ, Tɑcɑɑ tʋwɑ tɛtʋ tǝnɑɣɑ tɑ niŋ tɑɑ kɛ́. Hɑlǝnɑ tǝ yǝlɑɑ tǝnɑ tɛɛ sʋʋkǝnɑ-tʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Tɛʋ femɑ tɑnɑŋ tǝhulu, ɩlɛnɑ Yosuwee nɑ Ɩsɛɣɛlɩ nyǝ́mɑ pɑ́ kʋlɩ Sitim, nɑ pɑ́ tii Yɑɑtɑnɩ nɔɣɔ, nɑ pɑ́ cɑɣɑ tǝnɑ nɑ pɑ́ tɑŋ sɑɑ wei pɑɑ tɛsɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Kʋyɛɛŋ tooso tɛɛwɑ, ɩlɛnɑ Yosuwee tɔ nyʋɣʋ nyǝ́mɑ sɩ: Ɩ́ cɔɔ tǝsikile, ");
INSERT INTO dop_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","nɑ ɩ́ heeli sɑmɑɑ sɩ ye pǝ kɔmɑ nɑ ɩ́ nɑ́ kɔtǝlɑɑ sǝɣǝlɑ Ɩsɔ Tɑcɑɑ nɔɣɔ pɛɛlʋɣʋ ɑtɑkɑɑ, ɩlɛ pɑɑ wei ɩ́ lɩɩ nɑ ɩ́ hu ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Amɑ ɩ́ tɑɑ suli-ɩ kpǝtǝnɑʋ kɛ́, mǝ nɑ-ɩ ɩ́ hɑtǝlǝnɑ tǝmɑ ɩsɩɩ kilomɛɛtǝlɩ kʋlʋm. Ɩnɩ ɩ́ kɑ́ hʋlǝɣǝnɑ-mɛɣɛ mpɑɑʋ. Mpi tɔ, ɩ́ tɑ tǝŋtɑ-kʋ. ");
INSERT INTO dop_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Mpʋɣʋlɛ Yosuwee heelɑ yǝlɑɑ sɩ: Ɩ́ lɑ nyɔɔŋ tɔɔ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ kɛ cele tɔɔ. Mpi tɔ, Tɑcɑɑ kɑ lɑ-mɛɣɛ piti tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Tɛʋ femɑ, ɩlɛnɑ Yosuwee heeli kɔtǝlɑɑ sɩ: Ɩ́ sǝɣǝlɩ Ɩsɔ ɑtɑkɑɑ nɑ ɩ́ tɛɛ sɑmɑɑ kɛ nɔɣɔ. Ɩlɛnɑ pɛlɛ pɑ́ lɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Yosuwee sɩ: Sɑŋɑ kɛ mɑɑ cɑɑlɩ nyɑ́ nyʋɣʋ kʋsʋɣʋ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ ɩsɛntɑɑ. Ɩlɛnɑ pǝ́cɔ́ pɑ́ nyɩ sɩ mɑɑ wɛɛ nyɑ́ wɑɑlɩ, ɩsɩɩ mɑɑ wɛʋ Moisi wɑɑlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ɩlɛ heeli kɔtǝlɑɑ mpɑ pɑ sǝɣǝlɑ Ɩsɔ ɑtɑkɑɑ tɔ sɩ: Ye ɩ́ tɑlɑ Yɑɑtɑnɩ, ɩlɛ ɩ́ tisi mǝ nɔɔhɛɛ kɛ lʋm tɑɑ nɑ ɩ́ sǝŋ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Tǝnɑɣɑ Yosuwee tɔmɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ: Ɩ́ tuusi nɑ ɩ́ kɔɔ nɑ ɩ́ nɩɩ Tɑcɑɑ tɔm. ");
INSERT INTO dop_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Ḿpʋ́ɣʋ́ ɩ́ kɑ́ nyǝnɑ sɩ Weesuɣu tʋ Ɩsɔ wɛ mǝ hɛkʋ tɑɑ, nɑ ɩnɩ ɩ kɑ́ tɔɣɔnǝɣǝnɑ Kɑnɑɑŋ nyǝ́mɑ, nɑ Hiti nyǝ́mɑ, nɑ Hifi nyǝ́mɑ, nɑ Peliisi nyǝ́mɑ, nɑ Kilikɑɑ nyǝ́mɑ, nɑ Amolii nyǝ́mɑ, nɑ Yepusi nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ɩ nyǝnɩ, tɛtʋ tǝnɑ tʋ Tɑcɑɑ Ɩsɔ nɔɣɔ pɛɛlʋɣʋ ɑtɑkɑɑ kɑ́ tɛɛ mǝ nɔɣɔ tɔɔ, nɑ ɩ́ tɛsɩ Yɑɑtɑnɩ pɔɣɔ kɛ mǝ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Ɩ́ lǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ kpekɑ nɑɑnʋwɑ nɑ nɑɑlɛ tɑɑ kɛ́ yʋlʋ yʋlʋ. ");
INSERT INTO dop_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Pǝ́ kɔmɑ nɑ kɔtǝlɑɑ mpɑ pɑ sǝɣǝlɑ tɛtʋ tǝnɑ tʋ Tɑcɑɑ ɑtɑkɑɑ tɔ pɑ́ lii pɑ nɔɔhɛɛ kɛ lʋm tɑɑ, pɩɩ fɑɣɑ, nɑ pǝ́ yele kpente. Nɑ ɩsɔtɑɑ tɔɔ nyǝm kɔɔ nɑ pǝ́ su sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Ḿpʋ́ɣʋ́ yǝlɑɑ lɩɩ tǝsikile sɩ, pɑ tɛsǝɣɩ pɔɣɔ. Nɑ kɔtǝlɑɑ mpɑ pɑɑ sǝɣǝlɑ Ɩsɔ ɑtɑkɑɑ tɔ pɛlɛ pɑ wɛ lɔlɔ. ");
INSERT INTO dop_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Pɑɑ pǝnɑɣɑ ŋkɑ kʋmtʋ wɑɑtʋ tǝnɑɣɑ pɔɣɔ suɣi nɑ kɑ́ wɑtǝɣɩ kʋtemiŋ. Pǝ kɔmɑ nɑ kɔtǝlɑɑ mpɑ ɩnɩ pɑ sǝɣǝlɑ Ɩsɔ ɑtɑkɑɑ tɔ pɑ nɔɔhɛɛ tii lʋm tɑɑ, ");
INSERT INTO dop_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ɩlɛnɑ pǝ́ cɛ́. Nɑ mpi pǝ lɩɩkɑɣɑnɑ ɩsɔtɑɑ tɔɔ tɔ pǝ́ sǝŋ, nɑ pǝ́ su sɔsɔm kɛ Atɑm tɛ timpi pɑ yɑɑ sɩ Sɑɑtɑŋ tɔ pǝ kɔŋkɔŋ tɑɑ. Ɩlɛnɑ lʋm mpi pǝlɛ pǝ kpeŋɑɣɑnɑ teŋku kʋsǝpʋ tɔɔ tɔ, pǝlɛ pǝ cɛ. Nɑ yǝlɑɑ tɛsǝnɑ Yeliko tɔɔ tɔɔ. nɑɑlɩ ɑ hǝlɑ kɛ́. Ɩlɛ nɔɔnɔɔ ɑ lonɑ cɛkǝnɑʋ wɛ kɑtɛ. ");
INSERT INTO dop_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Ɩsɛɣɛlɩ nyǝ́mɑ tɔŋnɑ tɛsʋɣʋ kɛ ḿpʋ́ɣʋ́ wʋlɑɣɑ tɔ, nɑ ɑtɑkɑɑ sǝɣǝllɑɑ nɑ́ɑ́ sǝŋɑ ḿpʋ́ɣʋ́ tɛtʋ puɣulɑɣɑ nyǝntʋ tɔɔ kɛ́ pɔɣɔ pǝle tɑɑ. Hɑlǝnɑ pɑ tǝnɑ pɑ́ tɛ́ tɛsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tɛmɑ Yɑɑtɑnɩ kɛ tɛsʋɣʋ kɛ mpʋ, ɩlɛnɑ Tɑcɑɑ tɔ Yosuwee sɩ: ");
INSERT INTO dop_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","Lǝsɩ pɑ kpekɑ loosi tɑɑ kɛ́ yʋlʋ yʋlʋ. ");
INSERT INTO dop_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Ɩlɛnɑ ń heeli-wɛ sɩ: Ɩ́ kuli pǝlɛ pǝlɛ kɛ timpi ɩnɩ kɔtǝlɑɑ sǝŋɑ ɩsǝntɔ tǝcɑ tɔ. Nɑ ɩ́ kpɛŋnɑ timpi ɩ́ kɑ sʋʋ sɑŋɑ ɑhoo ɑnɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Mpʋɣʋlɛ Yosuwee yɑɑwɑ yǝlɑɑ nɑɑnʋwɑ nɑ nɑɑlɛ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Ɩlɛnɑ ɩ́ tɔ-wɛ sɩ: Ɩ́ polo Ɩsɔ Tɑcɑɑ ɑtɑkɑɑ nɔɣɔ tɔɔ kɛ́ pɔɣɔ tɑɑ, nɑ ɩ́ kuli pǝlɛ pǝlɛ kɛ mǝ nyɔɔŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","Pɛɛ ɑnɩ ɑ kɑ́ tɔɔsǝɣǝnɑ-mɛɣɛ mpi Ɩsɔ lɑpɑ-mɛɣɛ ɩsǝntɔ tɔ. Ye pǝ kɔmɑ nɑ mǝ piyɑ pɔɔsɩ-mɛ sɩ pɛɛ ɑnɛ ɑ lɑkɩ we? ");
INSERT INTO dop_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","Ɩ́ kɑ́ cɔ-wɛ sɩ wɑɑtʋ nɔɣɔlʋ kɔtǝlɑɑ tɛsɑɣɑnɑ Ɩsɔ ɑtɑkɑɑ kɛ́ Yɑɑtɑnɩ nɑ Tɑcɑɑ yele nɑ lʋm cɛ nɑ pɑ́ tɛsɩ. Ɩlɛ pɛɛ ɑnɛ ɑ kɑ tɔɔsǝɣǝnɑ-mɛɣɛ pǝ tɔm kɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","Mpʋɣʋlɛ ɑpɑlɑɑ nɑɑnʋwɑ nɑ nɑɑlɛ ɩnɩ ɩ lɑpɑ teitei ɩsɩɩ Yosuwee kɑ kɛɛsʋɣʋ-wɛ tɔ. Pɑ kulɑ pǝlɛ pǝlɛ kɛ pɑ kpekɑ nyɔɔŋ tɔɔ, ɩsɩɩ Tɑcɑɑ kɑ heeluɣu-wɛ tɔ. Ɩlɛnɑ pɑ́ kpɛŋnɑ-yɛ nɑ pɑ́ sɩɩ timpi pɑɑ siki ɑhoo ɑnɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","Ḿpʋ́ɣʋ́ Yosuwee cɑɑ pɛɛ nɑɑnʋwɑ nɑ nɑɑlɛ tɔtɔ, nɑ ɩ́ kɑɑ kɑŋmɑɑɣɑ kɛ pɔɣɔ pile tɑɑ, timpi kɔtǝlɑɑ kɑ sǝɣǝlɑ Ɩsɔ ɑtɑkɑɑ nɑ pɑ́ sǝŋɑɑ tɔ. Nɑ ɑ wɛ tǝnɑɣɑ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","Ḿpʋ́ɣʋ́ Ɩsɔ ɑtɑkɑɑ sǝɣǝllɑɑ sǝŋɑ pɔɣɔ tɑɑ kɛ́ mpʋ. Hɑlǝnɑ yǝlɑɑ tɛ nti Ɩsɔ Tɑcɑɑ kɑ heelɑ Yosuwee sɩ ɩ́ tɛlǝsɩ-wɛ tɔ tǝ lɑpʋ, ɩsɩɩ Moisi kɑ kɛɛsʋɣʋ-ɩ tɔ. Pǝ tɛmɑ mpʋ, ɩlɛnɑ sɑmɑɑ tɛsɩ lɔŋlɔŋ. ");
INSERT INTO dop_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","Pǝ kɔmɑ nɑ sɑmɑɑ tǝnɑ tɛ tɛsʋɣʋ, ɩlɛnɑ Ɩsɔ ɑtɑkɑɑ sǝɣǝllɑɑ ŋmɑɑ pɑ nɔɣɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","Ḿpʋ́ɣʋ́ Lupɛŋ nɑ Kɑtɩ nyǝ́mɑ, nɑ Mɑnɑsee kpekǝle hɔɣɔlʋɣʋ nyǝ́mɑ, tɛɛ sɑmɑɑ nɔɣɔ tɔɔ nɑ pɑ́ tɔkɑ pɑ yoou wontu, ɩsɩɩ Moisi kɑ heeluɣu-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ yoolɑɑ lɩɩwɑ Tɑcɑɑ ɩsɛntɑɑ, ɩsɩɩ yǝlɑɑ iyisi nɩɩlɛ (40000) nɑ pɑ́ suuwɑ yoou wontu. Nɑ pɑ́ pukinɑ Yeliko tɔɔ kɛ́ timpi tɛtʋ wɛ ɩhǝntɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","Kʋyɑkʋ ŋkʋɣʋ Tɑcɑɑ tʋwɑ Yosuwee kɛ teeli kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ɩsɛntɑɑ. Ɩlɛnɑ pɑ́ nyɑŋnɑ-ɩ, hɑlǝnɑ ɩ sǝm. Ɩsɩɩ pɑ nyɑŋɑɣɑnɑ Moisi tɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Yosuwee sɩ: ");
INSERT INTO dop_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","Heeli kɔtǝlɑɑ mpɑ pɑ sǝɣǝlɑ Ɩsɔ ɑtɑkɑɑ tɔ sɩ pɑ́ lɩɩ pɔɣɔ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","Ɩlɛnɑ Yosuwee nɑ́ɑ́ heeli-wɛɣɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","Too ɩsɩɩ Ɩsɔ ɑtɑkɑɑ sǝɣǝllɑɑ kpɛsʋɣʋ pɑ nɔɔhɛɛ kɛ pɔɣɔ pǝle tɑɑ nɑ pɑ́ sɩɩ kʋteŋ tɔɔ, ɩlɛnɑ lʋm mǝlɩ kpɑkpɑɑ nɑ pǝ́ su nɑ pǝ́ wɑtɩ pɔɣɔ kʋtemiŋ, ɩsɩɩ pɩɩ wɛʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Pɑ ɩsɔtʋ kɑncɑɑlɑɣɑ nyǝŋ kʋyɛɛŋ nɑɑnʋwɑ wule kɛ Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩ pɔɣɔ tɑɑ, nɑ pɑ́ polo pɑ́ siki timpi pɑ yɑɑ sɩ Kilikɑɑ tɔɣɔ Yeliko ɩcɑtɛ nɑ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Kilikɑɑ tǝnɑɣɑ Yosuwee ŋmɑwɑ pɛɛ nɑɑnʋwɑ nɑ nɑɑlɛ wei pɑɑ kulɑ pɔɣɔ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","Mpʋɣʋlɛ ɩ heelɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ: Ye kʋyɑkʋ ŋku mǝ piyɑ pɔɔsɑ-mɛ sɩ pɛɛ ɑnɛ ɑ nyʋɣʋ suwe? ");
INSERT INTO dop_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","Ɩlɛ ɩ́ kɑ́ kɛɛsɩ-wɛ sɩ tɩɩ tɛsɑ Yɑɑtɑnɩ kɛ wʋlɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Pɔpɔtʋ fɛɩ leleŋ, kʋyɑkʋ nɑkʋlǝɣɩ Tɑcɑɑ tɑ Ɩsɔ lɑpɑ nɑ Yɑɑtɑnɩ nyɔɔ nɑ tǝ́ tɛsɩ, ɩsɩɩ ɩ kɑ tɛm lɑpʋ kɛ Sǝsǝncɑɑsɩ teŋku tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Tɑcɑɑ lɑpɑ ḿpʋ́ɣʋ́ sɩ ɑtɛ yǝlɑɑ tǝnɑ ɩ́ nyɩ sɩ ɩ wɛnɑ tomɑ. Ɩlɛnɑ tɑɑ nyɑŋnɑ-ɩ tɑm. ");
INSERT INTO dop_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Tɛtʋ nti pɑ yɑɑkɩ sɩ Amolii tɔ, tǝ ɑwulɑɑ tǝnɑ mpɑ pɑ wɛnɑ Yɑɑtɑnɩ ilim tǝtʋlɛ tɔɔ tɔ, nɑ Kɑnɑɑŋ ɑwulɑɑ mpɑ pɑ kpǝtǝnɑ Metitelɑnee teŋku tɔ. Pɑ tǝnɑ pɑ kɔmɑ nɑ pɑ́ nɩɩ sɩ Tɑcɑɑ lɑpɑ nɑ pɔɣɔ nyɔɔ nɑ pɑ́ tɛsɩ. Ɩlɛnɑ pɑ ɑpɑlʋtʋ yɔɔlɩ-wɛ, nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔm lɑ-wɛɣɛ sɔɣɔntʋ kɛ kɑtɑtǝlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Mpʋɣʋlɛ Tɑcɑɑ tɔmɑ Yosuwee kɛ wɑɑtʋ ɩnɩ ɩ tɑɑ sɩ: Cɑɑ pɛɛ sɛɛsɩ nɑ ń pɛlɩ Ɩsɛɣɛlɩ piitim kʋfɑm pǝnɛ. ");
INSERT INTO dop_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Ntɛnɑ Yosuwee pɛlɩ-wɛɣɛ teitei, ɩsɩɩ Tɑcɑɑ kɑ yɔɣɔtʋɣʋ tɔɣɔ pulɑɣɑ ŋkɑ pɑ yɑɑ sɩ: Pɛlʋɣʋ pulɑɣɑ tɔ kɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","5","Wɑɑtʋ wei Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩwɑ Icipiti tɔ pɑ pɛlɑ ɑpɑlʋpiyɑ tǝnɑ mpɑ pɑ tɑlɑ yoou pote tɔ. Amɑ pɛlɛ pɑ tǝnɑɣɑ mpʋ pɑ sǝpɑ wʋlɑɣɑ tɛtʋ tɑɑ. Pǝlɛ pǝ wɑɑlɩ pɑ tɑsɑ ɑpɑlʋpiyɑ mpɑɣɑ lʋlʋɣʋ tɔ pɑ tɑ pɛlɩ pɛlɛ. Mpi pǝ tɔɔ Yosuwee pɛlɑ-wɛ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","Mpi tɔ, Ɩsɛɣɛlɩ nyǝ́mɑ kisɑ Ɩsɔ kɛ́ nɩɩnɑʋ kɛ́, ɩlɛnɑ pɑ́ cɔɔ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ pɩɩsɩ nɩɩlɛ tǝcu, nɑ pɑ tɑɑ ɑpɑlʋpiyɑ mpɑ pɑɑ tɑlɑ yoou pote kɛ pɑ Icipiti lɩɩʋ wɑɑtʋ tɔ pɑ́ sɩ́ pɑ tǝnɑ. Mpʋ ɩnǝɣɩ Tɑcɑɑ kɑ yɔɣɔtǝnɑ tuunɑʋ sɩ pɑ tɑɑ nɔɣɔlʋ kɑɑ keesi tɛtʋ kʋpɑntʋ nti tǝ tɑɑ tɔɣɔnɑɣɑ tɔlɑ yem tǝhɔ tɔ. Tǝnɑɣɑ ɩ kɑ sɩɩwɑ pɑ cɑɑnɑɑ kɛ nɔɣɔ sɩ ɩ kɑ́ hɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Ɩlɛ pɑ piyɑ kɛ Ɩsɔ lɛɛtɑ pɑ lonte. Pǝ tɔɔ kɛ́ Yosuwee pɛlɑ-wɛ. Mpi tɔ, pɑ tɑɑ pɛlɩ-wɛɣɛ mpɑɑʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Pɑ tɛmɑ pɑ looŋɑ tǝnɑɣɑ pɛlʋɣʋ, ɩlɛnɑ pɑ́ cɑɣɑ pɑ tǝcɑɣɑlɛ, hɑlǝnɑ pǝ́ wɑɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Ntɛnɑ Tɑcɑɑ tɔ Yosuwee sɩ: Sɑŋɑ ntɛ́ mɑ kɛɛlɑ mǝ nyɔɔŋ tɔɔ kɛ́ mǝ Icipiti fɛɛlɛ. Ɩlɛnɑ pɑ́ hɑ tǝnɛ ɩnǝɣɩ hǝtɛ sɩ Kilikɑɑ (Pɑkɛɛlɑɑ). Nɑ pɑ́ yɑɑkɩ-tɛɣɛ ḿpʋ́ɣʋ́ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Mpʋɣʋlɛ Ɩsɛɣɛlɩ nyǝ́mɑ sikɑ Kilikɑɑ kɛ timpi tɛtʋ wɛ ɩhǝntɑʋ tɔɣɔ Yeliko kiŋ. Ɩlɛnɑ pɑ́ tɔɣɔ Tɛɛʋ ɑcimɑ kɛ tǝnɑɣɑ ɩsɔtʋ kʋyɛɛŋ nɑɑnʋwɑ nɑ liɣiti wule tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Tɛɛʋ ɑcimɑ tɛʋ kʋfemuɣu kɛ pɑ cɑɑlɑ tɛtʋ tɔɣɔnɑɣɑ kɛ tɔɣɔʋ, nɑ potopotonɑɑ mpɑ pɑ tɑɑ kʋkʋsʋm fɛɩ tɔ. Ɩlɛnɑ pɑ́ wɔ tɔɣɔnɑɣɑ pee nɑ pɑ́ sɑlɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Kʋyɑŋkuɣu mɑnnɑ yelɑ hotuɣu pɑ tɑ tɑsɑ-ɩ nɑʋ. Pǝ kpɑɣɑʋ wɑɑtʋ ɩnɩ tɔɣɔ Ɩsɛɣɛlɩ nyǝ́mɑ sʋʋ tɛtʋ tɔɣɔnɑɣɑ kɛ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Kʋyɑkʋ nɑkʋlɩ Yosuwee wɛ Yeliko cɔlɔ, nɑ ɩ́ kʋsɩ ɩsɛ, ɩlɛ ɩ nɑ́ ɑpɑlʋ nɔɣɔlʋɣʋlɛ nɑ ɩ niŋ tɑɑ kɛ́ lɑɣɑtɛ. Ḿpʋ́ɣʋ́ ɩ polɑ ɩ kiŋ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: N kɛ́ tɑ́ nyǝŋ yɑɑ tɑ́ kolontu? ");
INSERT INTO dop_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Mpʋɣʋlɛ ɑpɑlʋ ɩnɩ ɩ nɔɣɔ tǝkpɑʋ sɩ: Aɑɩ, mɑ kɛ́ Tɑcɑɑ yoolɑɑ nyʋɣʋ tʋ kɛ́, nɔɔnɔɔ kɛ́ mɑ kɔmɑ. Tǝnɑɣɑlɛ Yosuwee hotɑ ɩ tɛɛ, nɑ ɩ́ sɛɛ-ɩ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Nɑ wentiɣilɛ n kɔmnɑɑ? ");
INSERT INTO dop_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Kɛlɛnɑ Tɑcɑɑ yoolɑɑ nyʋɣʋ tʋ tɔ Yosuwee sɩ: Wɔɣɔsɩ nyɑ́ ntɑŋkpɑlɑ. Mpi tɔ, timpi tɑɑ n sǝŋɑ mpʋ tɔ, pǝ wɛ kɑtɛ kɛ́. Ɩlɛnɑ Yosuwee lɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Yeliko nyǝ́mɑ kɑ tǝkɑ pɑ ɩcɑtɛ kɛ́ nɑ pɑ́ kɑlǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ. Nɔɣɔlʋ ɩɩ sʋʋkɩ, pǝ́cɔ́ nɔɣɔlʋ ɩɩ lɩɩkɩ. ");
INSERT INTO dop_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Yosuwee sɩ: Mɑ tʋɣɩ ɩcɑtɛ tǝnɛ tǝ wulɑʋ nɑ tǝ yoolɑɑ ɑpɑlɑɑ tǝnɑɣɑ nyɑ́ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Mpʋ tɔ, yoolɑɑ mɛ, ɩ́ tɔ nɑ ɩ́ cɔɔnɑ ɩcɑtɛ ntɛɣɛ tɔm kʋlʋm. Ɩlɛnɑ ɩ́ lɑkɩ ḿpʋ́ɣʋ́ pɑɑ kʋyɑkʋ ŋku. Hɑlǝnɑ kʋyɛɛŋ nɑɑtoso tǝcu. ");
INSERT INTO dop_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Kɔtǝlɑɑ nɑɑtosompɔɣɔlɑɣɑ kɑ́ tɛɛ Ɩsɔ ɑtɑkɑɑ sǝɣǝllɑɑ nɔɣɔ tɔɔ. Nɑ pɑɑ wei nɑ ɩ tutuɣu. Pǝ tɑkɩ kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule, ɩlɛnɑ ɩ́ cɔɔ ɩcɑtɛ kɛ tɔm nɑɑtosompɔɣɔlɑɣɑ. Nɑ kɔtǝlɑɑ nɑ́ɑ́ tɔŋnɑ pɑ tutuuŋ hʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Pǝ́ kɔmɑ nɑ ɩ́ nɩɩ tutuuŋ wiiwɑ nɑ ɩ́ cuɣusi, ɩlɛ yǝlɑɑ tǝnɑ kpɛntɩ nɑ pɑ́ yɑɣɑ ɑpɑlʋkɑkiisɑsɩ nɑ ɩcɑtɛ koluŋɑ ti. Ɩlɛnɑ pɑɑ Ɩsɛɣɛlɩ tʋ wei ɩ́ tii pɑ tɔɔ kɛ́ kpɑkpɑɑ. ");
INSERT INTO dop_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Mpʋɣʋlɛ Yosuwee kotɑ kɔtǝlɑɑ nɑ ɩ́ heeli-wɛ sɩ: Ɩ́ kpɑɣɑ Ɩsɔ ɑtɑkɑɑ nɑ mǝ tɑɑ yǝlɑɑ nɑɑtosompɔɣɔlɑɣɑ nɑ́ɑ́ tɔkɩ pɑɑ wei nɑ ɩ tutuɣu nɑ ɩ́ tɛɛ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Ɩlɛnɑ Yosuwee heeli sɑmɑɑ sɩ: Ɩ́ tɔ nɑ ɩ́ cɔɔ ɩcɑtɛ. Nɑ yoou wontu tɔkǝlɑɑ kɛ Ɩsɔ ɑtɑkɑɑ nɔɣɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Yosuwee tɛmɑ yǝlɑɑ kɛ ḿpʋ́ɣʋ́ heeluɣu, ɩlɛnɑ kɔtǝlɑɑ nɑɑtosompɔɣɔlɑɣɑ ɩnɩ ɩ́ nɑɑlɩ tɔntɛ, nɑ pɑ́ hʋlǝɣɩ pɑ tutuuŋ. Nɑ Ɩsɔ ɑtɑkɑɑ kɛ́ pɑ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Ɩlɛnɑ yoou wontu tɔkǝlɑɑ kɛ tutuuŋ hʋllɑɑ nɔɣɔ tɔɔ. Nɑ wɑɑlɩ nyǝ́mɑ tǝŋǝɣɩ Ɩsɔ ɑtɑkɑɑ nɑ pǝ́ hɑŋɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Ɩlɛnɑ Yosuwee heeli sɑmɑɑ sɩ: Ɩ́ tɑɑ kiisi, pǝ́cɔ́ mǝ tɑɑ nɔɣɔlʋ nɔɣɔ tɑɑ ɩ́ tɑɑ lɩɩ pɑɑ fǝŋ mɑɣɑmɑɣɑ. Hɑlǝnɑ kʋyɑŋku mɑɑ heeli-mɛ sɩ ɩ́ kiisi tɔ. ");
INSERT INTO dop_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Mǝ nɑ Ɩsɔ ɑtɑkɑɑ ɩ kɑ́ cɔɔ ɩcɑtɛ kɛ tɔm kʋlʋm. Ɩlɛnɑ ɩ́ mǝlɩ tesikile nɑ ɩ́ hǝntɩ. ");
INSERT INTO dop_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Yosuwee sǝm wɑɑlɩ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ pɔɔsɑ Tɑcɑɑ sɩ pɑ nyǝŋ pɑ kpekɑ tɑɑ nte tɩɩ yoonnɑ Kɑnɑɑŋ nyǝ́mɑ kɛ kɑncɑɑlɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Ntɛnɑ Tɑcɑɑ sɩ: Yutɑ nyǝntɛ kɛ́. Mpi tɔ, pɛlɛ pɑ niŋ tɑɑ kɛ́ mɑ tʋ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Mpʋɣʋlɛ Yutɑ kpekǝle nyǝ́mɑ tɔmɑ Simiyɔŋ kpekǝle nyǝ́mɑ sɩ: Ɩ́ kɔɔ nɑ ɩ́ sǝnɑ-tʋ nɑ tǝ́ yoonɑ Kɑnɑɑŋ nyǝ́mɑ nɑ tǝ́ lɛɛkɩ tɛtʋ nti Tɑcɑɑ kɑ́ hɑ-tʋ tɔ. Ye tǝ tɛmɑ tǝnɑ, ɩlɛ tɑ́ɑ́ kɔɔ nɑ tǝ́ sǝnɑ-mɛ nɑ tǝ́ lɛɛkɩ mǝ nyǝntʋ. Mpʋɣʋlɛ Simiyɔŋ nyǝ́mɑ polɑɑ nɑ pɑ́ sɔɔsɩ Yutɑ nyǝ́mɑ tɔɔ, ");
INSERT INTO dop_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","nɑ pɑ́ tɛɛ yoou. Ɩlɛnɑ Tɑcɑɑ tʋ Kɑnɑɑŋ nyǝ́mɑ nɑ Peliisi nyǝ́mɑ kɛ pɑ niŋ tɑɑ, nɑ pɑ́ kʋ́ yǝlɑɑ iyisi nɑɑnʋwɑ (10000) kɛ́ Peseke ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","Ḿpʋ́ɣʋ́ pɑ mɑɣɑnɑ wulɑʋ Atoni-Peseke kɛ Peseke ɩcɑtɛ tɑɑ, nɑ pɑ́ yoonɑ-ɩ. Ɩsǝnɑ pɑ kǝlǝnɑ Kɑnɑɑŋ nyǝ́mɑ nɑ Peliisi nyǝ́mɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","Ɩlɛnɑ wulɑʋ se nɑ pɑ́ tɔɣɔnɩ-ɩ nɑ pɑ́ kpɑ-ɩ nɑ pɑ́ sɛtɩ ɩ ɑpɑlʋmpee nɑ ɩ ɑpɑlʋnɔmpee. ");
INSERT INTO dop_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","Mpʋɣʋlɛ wulɑʋ ɩnɩ ɩ tɔmɑ sɩ: Mɑ mɑɣɑmɑɣɑ mɑɑ sɛtɑ yǝlɑɑ nɩɩtoso nɑ nɑɑnʋwɑ ɑpɑlʋmpee nɑ pɑ ɑpɑlʋnɔmpee kɛ ḿpʋ́ɣʋ́, nɑ mɑ́ tɔkɩ nɑ cǝɣǝlɑsɩ hotiɣi nɑ pɑ́ cɑlǝsǝɣɩ. Mpi mɑɑ lɑpɑ tɔɣɔ pǝ fɛlǝɣɩ-m. Ɩlɛnɑ pɑ́ ponɑ Atoni-Peseke kɛ Yosɑlɛm nɑ ɩ́ cɑŋ nɑ ɩ́ sɩ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Ḿpʋ́ɣʋ́ Yutɑ nyǝ́mɑ yoonɑ Yosɑlɛm nyǝ́mɑ, nɑ pɑ́ kʋ-wɛ nɑ pɑ́ sɔ ɩcɑtɛ kɛ kɔkɔ nɑ pɑ́ lɛɛkɩ-tɛ. ");
INSERT INTO dop_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Pǝ wɑɑlɩ kɛ́ pɑ polɑɑ nɑ pɑ́ yoonɑ Kɑnɑɑŋ nyǝ́mɑ mpɑ pɑɑ wɛ pulɑsɩ tɑɑ, nɑ ilim mpǝtǝŋ tɔɔ kɛ́ tɛtɛkǝlɛ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Ɩlɛnɑ pɑ́ polo nɑ pɑ́ yoonɑ Kɑnɑɑŋ nyǝ́mɑ mpɑ pɑ wɛ Hepǝlɔŋ timpi pɑ yɑɑkɑɣɑ sɩ Alɑpɑ tɛ tɔ. Nɑ pɑ́ kʋ Sesɑyi nyǝ́mɑ, nɑ Ahimɑŋ nyǝ́mɑ, nɑ Tɑlǝmɑyi nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","Pɑ tɛmɑ tǝnɑ, ɩlɛnɑ pɑ́ polo pɑ́ yoonɑ Tepii timpi pɑ yɑɑkɑɣɑ sɩ Kiliyɑtɩ-Sefɛɛ tɔ pǝ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","Ḿpʋ́ɣʋ́ Kɑlɛpʋ tɔmɑ sɩ: Ye wei ɩ yoonɑ Kiliyɑtɩ-Sefɛɛ nyǝ́mɑ nɑ ɩ́ kǝlɩ-wɛ mɑɑ hɑ-ɩ mɑ pɛɛlɔ Akǝsɑ nɑ ɩ́ lɑ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","Tǝnɑɣɑlɛ Kɑlɛpʋ neu tǝnʋɣʋ nyǝŋ Kenɑsɩ pǝyɑlʋ wei pɑ yɑɑ sɩ Otiniyɛɛ tɔ, ɩ yoonɑ ɩcɑtɛ ntɛ́ tǝ nyǝ́mɑ nɑ Kɑlɛpʋ hɑ-ɩ ɩ pɛɛlɔ Akǝsɑ nɑ ɩ́ lɑ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","Akǝsɑ sɑɑwɑ, ɩlɛnɑ ɩ́ tɔ ɩ pɑɑlʋ sɩ: Mɑɑ sǝlǝmɩ mɑ cɑɑ kɛ tɛtʋ nɑtǝlɩ. Alʋ ɩnɩ ɩ tiinɑ ɩ kpɑŋɑɣɑ tɔɔ, ɩlɛnɑ ɩ cɑɑ pɔɔsɩ-ɩ sɩ: Alɑɑfǝyɑ kɛlɛ? ");
INSERT INTO dop_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","Mpʋɣʋlɛ ɑlʋ nɔɣɔ tǝkpɑʋ sɩ: Hɑɩ, lɑ-m kʋpɑntʋ nɑ ń hɑ-m hilɑ. Mpi tɔ, tɛtʋ nti n hɑ-m ḿpʋ́ɣʋ́ ilim mpǝtǝŋ tɔɔ tɔ tǝ fɛɩ lʋm. Ɩlɛnɑ ɩ cɑɑ Kɑlɛpʋ nɑ́ɑ́ hɑ-ɩ hilɑ wenɑ ɑ wɛ pǝ tɛɛ tɔ, nɑ ɩsɔtɑɑ nyǝnɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","Ḿpʋ́ɣʋ́ Moisi yǝtɩ lʋlʋɣʋ nyǝ́mɑ Keni nyǝ́mɑ nɑ Yutɑ nyǝ́mɑ pɑ lɩɩwɑ Yeliko, nɑ pɑ́ polo pɑ́ cɑɣɑ Yutɑ Alɑɑtɩ ilim mpǝtǝŋ tɔɔ kɛ́ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ Amɑleke nyǝ́mɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","Mpʋɣʋlɛ Yutɑ nyǝ́mɑ, nɑ Simiyɔŋ nyǝ́mɑ pɑ polɑɑ nɑ pɑ́ yoonɑ Kɑnɑɑŋ nyǝ́mɑ mpɑ pɑ wɛ Sefɑtɩ tɔ nɑ pɑ́ tɔɣɔ pɑ tɛtʋ, nɑ pɑ́ yɔkɩ ɩcɑtɛ tǝnɑŋnɑŋ. Nɑ pɑ́ hɑ-tɛ sɩ Hoomɑ. Ncɑɑlɛ kɛ pɑ yɑɑ mpʋ nɑ pɑ tɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","Pǝlɛ pǝ wɑɑlɩ kɛ́ Yutɑ nyǝ́mɑ mpɛ pɑ tɑsɑ Kɑsɑ, nɑ Asǝkɑlɔŋ, nɑ Ɩkoloŋ ɑcɑlɛɛ kɛ lɛɛkʋɣʋ, nɑ pɑ́ kpɛnnɑ wenɑ ɑ cɔɔnɑ-yɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","Tɑcɑɑ kɑ wɛ pɑ wɑɑlɩ kɛ́ hɑlǝnɑ pɑ́ lɛɛkɩ pulɑsɩ tɛtʋ tǝnɑ. Amɑ tɛtʋ ɩhǝntɑʋ tɑɑ nyǝ́mɑ kɛ pɑ tɑ pǝsɩ. Mpi tɔ, pɛlɛ pɑɑ wɛnɑ yoou kɛɛkɛnɑɑ nyǝɣǝtʋ nyǝ́mɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","Ɩlɛnɑ pɑ́ hɑ Kɑlɛpʋ kɛ Hepǝlɔŋ ɩcɑtɛ, ɩsɩɩ Moisi kɑ yɔɣɔtʋɣʋ tɔ. Mpi tɔ, ɩnɩ ɩ tɔɣɔnnɑ Anɑkɩ lʋlʋŋ nyǝ́mɑ tooso wei ɩ kɑ wɛ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","Pɛncɑmɛɛ nyǝ́mɑ tɑ pǝsɩ nɑ pɑ́ tɔɣɔnɩ Yepusi nyǝ́mɑ mpɑ pɑɑ wɛ Yosɑlɛm tɔ, pɑ́ nɑ-wɛ pɑ wɛnnɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","23","Ḿpʋ́ɣʋ́ Ɩfǝlɑyim kpekǝle nɑ Mɑnɑsee nyǝntɛ pɑ polɑɑ nɑ pɑ́ yoonɑ Petɛɛlɩ timpi pɑ yɑɑkɑɣɑ Lusi tɔ, nɑ Tɑcɑɑ sǝnɑ-wɛ. Feŋlɑɑ kɛ pɑɑ cɑɑlǝnɑ tiluɣu kɛ Petɛɛlɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","Pɛlɛ pɑ tɑlɑɑ nɑ pɑ́ sulinɑ ɑpɑlʋ nɔɣɔlʋ, ɩlɛnɑ pɑ́ tɔmɩ-ɩ sɩ: Hʋlɩ-tʋɣʋ timpi tɔɔ ɩcɑtɛ koloosi topilinɑɑ tɔ, tɩɩ nyɩ nyɑ́ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Ḿpʋ́ɣʋ́ ɑpɑlʋ ɩnɩ ɩ hʋlɑ-wɛɣɛ tǝsʋʋlɛ. Ɩlɛnɑ pɑ́ sʋʋ nɑ pɑ́ kʋ́ ɩcɑtɛ yǝlɑɑ tǝnɑ. Amɑ pɑ yelɑ ɑpɑlʋ ɩnɩ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","Pǝ wɑɑlɩ kɛ́ ɑpɑlʋ ɩnɩ ɩ polɑ Hiti nyǝ́mɑ tɛtʋ tɑɑ, nɑ ɩ́ ŋmɑ́ ɩcɑtɛ nɑ ɩ́ yɑɑ-tɛ sɩ Lusi, nɑ pɑ́ yɑɑkɩ-tɛɣɛ ḿpʋ́ɣʋ́ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Mɑnɑsee nyǝ́mɑ nɑ́ tɑ́ pǝsɩ nɑ pɑ́ tɔɣɔnɩ Pɛtɩ-Seyɑŋ nyǝ́mɑ, nɑ Tɑɑnɑkɩ nyǝ́mɑ, nɑ Tɔɔɔ nyǝ́mɑ, nɑ Ɩpeleyɑm nyǝ́mɑ, nɑ Mekito nyǝ́mɑ, nɑ pǝ ɑcɑlɛɛ wenɑ ɑ cɔɔnɑ-yɛ tɔ. Kɑnɑɑŋ nyǝ́mɑ kɑ wɛ tǝnɑɣɑ tɑm kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","Pɑɑ nɑ wɑɑtʋ wei Ɩsɛɣɛlɩ nyǝ́mɑ kɔmɑ nɑ pɑ́ yoo toŋ kɛ teu tɔ pɑ tɑ pǝsɩ nɑ pɑ́ lɛɛkɩ pɑ koloosi ɑcɑlɛɛ. Ye pǝ tɑɣɑ sǝkpenɑ pɑɑsi. ");
INSERT INTO dop_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","Ɩfǝlɑyim nyǝ́mɑ nɑ́ tɑ́ pǝsɩ nɑ pɑ́ tɔɣɔnɩ Kɑnɑɑŋ nyǝ́mɑ mpɑ pɑ wɛ Kesɛɛ tɔ, pɑ nɑ-wɛ pɑ wɛnnɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","Sɑpulɔŋ nyǝ́mɑ nɑ́ tɑ́ pǝsɩ nɑ pɑ́ tɔɣɔnɩ Kɑnɑɑŋ nyǝ́mɑ mpɑ pɑ wɛ Kitǝlɔŋ nɑ Nɑhɑlɑlɩ tɔ. Amɑ tǝmɑ kɛ́ pɑ tʋ-wɛ nɑ pɑ́ nɑ-wɛ pɑ wɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","Asɛɛ nyǝ́mɑ nɑ́ tɑ́ pǝsɩ nɑ pɑ́ tɔɣɔnɩ Ako nyǝ́mɑ, nɑ Sitɔŋ nyǝ́mɑ, nɑ Alɑpʋ nyǝ́mɑ, nɑ Akǝsipɩ nyǝ́mɑ, nɑ Helǝpɑ nyǝ́mɑ, nɑ Afikɩ nyǝ́mɑ, nɑ Lehopɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","Pǝ tɔɔ kɛ́ pɑ́ nɑ Kɑnɑɑŋ nyǝ́mɑ pɑ cɑɣɑ pɛlɛ pɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Nɛfǝtɑli nyǝ́mɑ tɑ pǝsɩ nɑ pɑ́ tɔɣɔnɩ Kɑnɑɑŋ nyǝ́mɑ mpɑ pɑ wɛ Pɛtɩ-Sɛmɛsɩ nɑ Pɛtɩ-Anɑtɩ tɔ. Amɑ tǝmɑ kɛ pɑ tʋ-wɛ nɑ pɑ́ nɑ-wɛ pɑ́ wɛɛ. ");
INSERT INTO dop_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","Ḿpʋ́ɣʋ́ Amolii nyǝ́mɑ tɔɣɔnɑ Tɑŋ nyǝ́mɑ, nɑ pɑ́ kpɑ pulɑsɩ tɑɑ. Pɑ tɑ yele-wɛ nɑ pɑ́ cɑɣɑ tɛtʋ ɩhǝntɑʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","Ɩlɛnɑ Amolii nyǝ́mɑ sɑɑlɩ Hɑɑ-Hɛlɛsɩ pʋɣʋ tɑɑ nɑ Ayɑlɔŋ nɑ Sɑɑlǝpim. Amɑ wɑɑlɩ wɑɑlɩ kɛ́ Ɩfǝlɑyim nyǝ́mɑ, nɑ Mɑnɑsee nyǝ́mɑ ŋmɑkǝlɑ-wɛ nɑ pɑ́ tʋ-wɛɣɛ tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","Ɩtɔm nyǝ́mɑ tɛtʋ toŋɑ fɑɣɑnɑ Pǝcɛsɩ tontoŋle tɔɔ kɛ́ Selɑ nɑ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Tɑcɑɑ ɩsɔtɑɑ tillu lɩɩnɑ Kilikɑɑ, nɑ ɩ́ polo timpi pɑ yɑɑ sɩ Pokim tɔ. Nɑ ɩ́ tɔ́ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ: Mɑ lǝsɑ-mɛɣɛ Icipiti nɑ mɑ́ ponɑ-mɛɣɛ tɛtʋ nti tǝ tɑɑ mɑɑ heelɑ mǝ cɑɑnɑɑ nɑ tuunɑʋ sɩ mɑɑ hɑ-mɛ tɔ. Hɑlɩ mɑ́ yɔɣɔtɩ nɑ mɑ́ sɩɩ sɩ mɑ kɑɑ yɔkɩ mɑ́ nɑ mɛ tɑ nɔɣɔ pɛɛlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","Nɑ mɑ heelɑ-mɛ sɩ mǝ nɑ tɛtʋ tǝnɛ tǝ nyǝ́mɑ ɩ́ tɑɑ pɛɛlɩ nɔɣɔ nɑkǝlɩ. Pǝ wɛɛ kɛ́ sɩ ɩ́ yɔkɩ pɑ tɩɩŋ. Pɑɑ nɑ mpʋ tɔ, ɩ́ tɑ́ nɩɩ mɑ tɔm. Ɩlɛ pepe tɔɔ kɛ́ ɩ́ lɑpɑ mpʋ? ");
INSERT INTO dop_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","Pǝ mɑɣɑmɑɣɑ pǝ tɔɔ kɛ́ mɑ heeliɣi-mɛ tǝfoo sɩ mɑ kɑɑ tɔɣɔnǝɣɩ tɛtʋ tǝnɛ tǝ yǝlɑɑ nɑ mɩɩ tǝŋǝɣɩ. Amɑ mǝ nɑ-wɛ ɩ́ kɑ́ wɛɛnɑ mpʋ, nɑ pɑ tɩɩŋ pǝsɩ-mɛɣɛ kɑtɔsɩ. ");
INSERT INTO dop_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","Wɑɑtʋ wei Tɑcɑɑ ɩsɔtɑɑ tillu tɛmɑ tɔm ntǝɣɩ yɔɣɔtʋɣʋ, ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tʋlɩ nɔɔsɩ nɑ pɑ́ wiiki. ");
INSERT INTO dop_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","Pǝ tɔɔ kɛ́ pɑ hɑ lonte ntɛɣɛ hǝtɛ sɩ Pokim. Wiilɑɑ tɛɣɛ pɑ yɑɑ mpʋ nɑ pɑ tɛ tɑɑ. Ḿpʋ́ɣʋ́ pɑ lɑpɑ Tɑcɑɑ kɛ kɔtɑsɩ. ");
INSERT INTO dop_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Wɑɑtʋ wei Yosuwee tɑɑ sǝtɑ tɔ, ḿpʋ́ɣʋ́ ɩ yelɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Sikɛm, ɩlɛnɑ pɑɑ wei ɩ́ mǝlɩ ɩ tɛtʋ nti ɩ hikɑɑ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Ɩsɛɣɛlɩ nyǝ́mɑ lɑpɑ Tɑcɑɑ tǝmlɛ kɛ́, hɑlǝnɑ Yosuwee sǝm. Nɑ pɑ́ sɛɛsɩ ɩsǝlɛ kɛ mpʋ, nɑ nyʋɣʋ nyǝ́mɑ mpɑ pɑ nɑnɑ pɑ ɩsǝpǝle kɛ tǝmɑ sɔsɔɔnɑ wenɑ Tɑcɑɑ lɑpɑ-wɛ tɔ, pɛlɛ pɑ polo pɑ sɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Tɑcɑɑ tǝmlɛ tʋ Yosuwee pɩɩsɩ yoosɑ nɩɩnʋwɑ nɑ nɑɑnʋwɑ (110) ɩlɛnɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","Ɩlɛnɑ pɑ́ pimi-ɩ tɛtʋ nti pɑ hɑ-ɩ tɔ, tǝ tɑɑ kɛ́ Timnɑtɩ-Helɛsɩ kɛ Ɩfǝlɑyim pulɑsɩ tɑɑ kɛ́ Kɑɑsɩ pʋɣʋ tɑɑ kɛ́ ilim ntɔɣɔŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Ḿpʋ́ɣʋ́ Yosuwee pɔɔlɛ nyǝ́mɑ tǝnɑ sǝpɑ tɔtɔ. Amɑ kʋfɑlɑŋ yǝlɑɑ nɑ́ tɑ́ɑ́ cɛkǝnɑ Tɑcɑɑ, nɑ tǝmɑ sɔsɔɔnɑ wenɑ ɩ kɑ lɑpɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ lɑpɑ mpi pǝ tɑ mɑɣɑ Tɑcɑɑ tɔ. Pɑ lɑɑkɑɣɑ tɩɩŋ wei pɑ yɑɑ sɩ Pɑɑlǝnɑɑ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Pɑ lɔwɑ pɑ cɑɑnɑɑ Ɩsɔ Tɑcɑɑ wei ɩ lǝsɑ-wɛɣɛ Icipiti tɔ. Ɩlɛnɑ pɑ lɑɑkɑlɩ mǝlɩ piitimnɑɑ mpɑ pɑ hɛkʋ pɑ wɛ mpʋ tɔ pɑ tɩɩŋ tɔɔ, nɑ pɑ́ luŋiɣi-ɩ. Tǝnɑɣɑ pɑ kʋsǝnɑ Tɑcɑɑ pɑ́ɑ́nɑ́. ");
INSERT INTO dop_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Pɑ lɔ-ɩ kɛ́ nɑ pɑ́ lɑɑkɩ tɩɩŋ ɑpɑlʋ nyǝŋ wei pɑ yɑɑkɩ sɩ Pɑɑlǝnɑɑ tɔ, nɑ ɑlʋ nyǝŋ wei pɑ yɑɑ sɩ Asǝtɑtǝnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑɑ huunɑ Ɩsɛɣɛlɩ nyǝ́mɑ, nɑ ɩ́ yele-wɛ nɑ lɛɛkǝlɑɑ lɛɛkɩ pɑ nyǝm tǝnɑ. Nɑ ɩ́ tʋ-wɛɣɛ pɑ kolontunɑɑ niŋ tɑɑ nɑ pɑ́ kǝlɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Pɑɑ wɑɑtʋ wei kɛ́ pɑ sulɑ yoou Tɑcɑɑ yeki kɛ́ nɑ pɛlɛ pɑ́ tɔɣɔnɩ-wɛ. Ɩsɩɩ ɩ kɑ tɛm-wɛɣɛ heeluɣu nɑ tuunɑʋ tɔ. Tǝnɑɣɑlɛ pɑ lɑŋɑ wɑkǝlɑɑ tǝtɔɣɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Kɛnɑ Tɑcɑɑ nɑ́ɑ́ kpɑɑkɩ pɑ tɑɑ kɛ́ pɑɑsǝnlɑɑ sɩ pɛlɛ pɑ́ wɑɑsɩ-wɛɣɛ lɛɛkǝlɑɑ mpɛ pɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Amɑ Ɩsɛɣɛlɩ nyǝ́mɑ kisɑ pɛlɛɣɛ nɩɩnɑʋ nɑ pɑ́ lɑɑkɩ tɩɩŋ nɑ pɑ́ luŋiɣi-ɩ. Tǝnɑɣɑ pɑ yelinɑ pɑ cɑɑnɑɑ mpɑ pɑ tǝŋɑɣɑ Ɩsɔ kʋsǝsɩɩtʋ tɔ pɑ mpɑɑʋ kɛ lɔŋ, nɑ pɑ́ kisi-wɛɣɛ kɛɛnɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Pɑɑ wɑɑtʋ wei kɛ́ Tɑcɑɑ kpɑ-wɛɣɛ pɑɑsǝnlʋ, ɩ wɛ pʋntʋ ɩnɩ ɩ wɑɑlɩ kɛ́ nɑ ɩ́ yɑkɩ-wɛɣɛ pɑ kolontunɑɑ niŋ tɑɑ, hɑlǝnɑ ɩ sǝm. Pɔpɔtʋ fɛɩ leleŋ, ye pǝ kɔmɑ nɑ pɑ ŋmɑkǝllɑɑ nyǝŋsǝɣɩ pɑ ɩsɛ nɑ pɑ́ sɑlǝmǝɣɩ, pɑ pǝtɔɔtǝlɛ kpɑɑkɩ Tɑcɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Amɑ pǝ kɔŋ nɑ pɑɑsǝnlʋ sɩ, ɩlɛnɑ pɑ́ tɑɣɑnɩ ɩsɑɣɑtʋ tɑɑ kɛ́ mǝlʋɣʋ, nɑ pǝ́ kǝlɩ pɑ cɑɑnɑɑ. Nɑ pɑ́ lɑɑkɩ tɩɩŋ nɑ pɑ luŋiɣi-ɩ. Nɑ pɑ́ tɔkɑ tɑm kɛ́ pɑ kɑŋkɑntɛ, nɑ pɑ yɑɑsi ɩsɑɣɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Tɑcɑɑ tɑɑ huunɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ ɩ́ tɔ́ sɩ: Yǝlɑɑ pɑnɛ pɑ yɔkɑ mɑ nɔɣɔ ŋkɑ mɑ nɑ pɑ cɑɑnɑɑ tɩɩ pɛɛlɑɑ tɔ, nɑ pɑ́ kisi-m nɩɩnɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","Mpʋ tɔ, mɑ kɑɑ tɔɣɔnɩ piitimnɑɑ mpɑ Yosuwee tɑɑ tɛ́ tɔɣɔnʋɣʋ nɑ pǝ́cɔ́ ɩ́ sǝkɩ tɔ, pɑ tɑɑ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Piitimnɑɑ mpɛɣɛ mɑɑ nɑnɑ Ɩsɛɣɛlɩ nyǝ́mɑ wɑɑlɩ sɩ pɑɑ nɩɩnɑ-m nɑ pɑ́ tǝŋ mɑ luɣu nyǝntʋ ɩsɩɩ pɑ cɑɑnɑɑ lɑpʋ tɔ yɑɑ ɩsǝnɑ. ");
INSERT INTO dop_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Ḿpʋ́ɣʋ́ Tɑcɑɑ yelɑ piitimnɑɑ mpɑ ɩ tɑɑ tʋ Yosuwee niŋ tɑɑ sɩ ɩ́ tɔɣɔnɩ tɔ nɑ pɑ́ hɛɛsɩ. Ɩ tɑ hulinɑ pɑ tɔɣɔnʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ yelɑ piitimnɑɑ mpɛɣɛ tɔɣɔnʋɣʋ sɩ ɩ mɑɣɑsǝɣǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ mpɑ pɑ tɑɑ nyɩ pɑ́ nɑ Kɑnɑɑŋ nyǝ́mɑ pɑ yooŋ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","Tɑcɑɑ cɑɑkɑɣɑ kɛ́ sɩ mpɑ ɩnɩ pɑ tɑɑ nyɩ yoou kɛ mpʋ tɔ, pɑ́ nyɩ-kʋ. ");
INSERT INTO dop_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","Piitimnɑɑ mpɑ pɩɩ kɑɑsɑ tɔɣɔnʋɣʋ tɔɣɔlɛ Filiisi nyǝ́mɑ ɑcɑlɛɛ kɑkpɑsɩ, nɑ Kɑnɑɑŋ nyǝ́mɑ tǝnɑ, nɑ Sitɔŋ nyǝ́mɑ, nɑ Hifi nyǝ́mɑ mpɑ pɑ wɛ Lipɑŋ pʋɣʋ tɑɑ kɛ́ pǝ kpɑɣɑʋ Pɑɑlɩ-Hɛɛmɔŋ pʋɣʋ nɑ pǝ́ polo Lepo-Hɑmɑtɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","Mpɛ ɩnǝɣɩ Tɑcɑɑ cɑɑkɑɣɑ sɩ ɩ nɑɑkǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ wɑɑlɩ sɩ pɑɑ tɔkɩ kʋsǝsɩɩtʋ nti ɩ kɑ yelɑɑ nɑ Moisi tʋ pɑ cɑɑnɑɑ tɔ yɑɑ pɑ kɑɑ tɔkɩ. ");
INSERT INTO dop_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","Mpʋ pǝ yelinɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ wɛ Kɑnɑɑŋ nyǝ́mɑ nɑ Hiti nyǝ́mɑ nɑ Amolii nyǝ́mɑ nɑ Peliisi nyǝ́mɑ nɑ Hifi nyǝ́mɑ nɑ Yepusi nyǝ́mɑ pɑ hɛkʋ. ");
INSERT INTO dop_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","Pɛlɛ pɑ hɑɑkɑɣɑnɑ-wɛɣɛ pɑ pɛɛlɑɑ nɑ pɑ́ lɑkɩ ɑlɑɑ, nɑ mpɛ pɑ́ hɑɑkɩ pɛlɛɣɛ pɑ nyǝ́mɑ, nɑ pɑ́ lɑɑkɩ pɑ tɩɩŋ. ");
INSERT INTO dop_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ lɑpɑ mpi pǝ tɑ mɑɣɑ Tɑcɑɑ tɔ. Pɑ kisɑ Ɩsɔ kɛ́ sɛɛʋ nɑ pɑ́ lɑɑkɩ tɩɩŋ wei pɑ yɑɑkɩ sɩ Pɑɑlǝnɑɑ nɑ Aselɑnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Mpʋɣʋlɛ Tɑcɑɑ tɑɑ huunɑ-wɛ nɑ ɩ́ tʋ-wɛɣɛ Mesopotɑmi wulɑʋ Kusɑŋ-Lisɑtɑyim niŋ tɑɑ. Nɑ ɩ́lɛ́ ɩ ŋmɑkǝlɩ-wɛɣɛ pɩɩsɩ pǝlefɛɩ tǝcu. ");
INSERT INTO dop_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Kɛlɛnɑ pɑ́ wiinɑ Tɑcɑɑ sɩ ɩ́ yɑ-wɛ. Ɩlɛnɑ ɩ́lɛ́ ɩ lǝsɩ Kɑlɛpʋ neu tǝnʋɣʋ nyǝŋ Kenɑsɩ pǝyɑlʋ Otiniyɛɛ sɩ ɩ́ wɑɑsɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Ḿpʋ́ɣʋ́ Tɑcɑɑ Feesuɣu tii ɩ tɔɔ, nɑ ɩ́ polo ɩ́ yoonɑ wulɑʋ Kusɑŋ-Lisɑtɑyim nɑ ɩ́ kǝlɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ hɛɛsɩ pɩɩsɩ nɩɩlɛ tǝcu. Pǝ wɑɑlɩ kɛ́ Otiniyɛɛ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɑsɑ lɑpʋ kɛ mpi pǝ tɑ mɑɣɑ Tɑcɑɑ tɔ. Ntɛnɑ ɩ́lɛ́ ɩ yele nɑ Mowɑpʋ wulɑʋ Ɩkoloŋ kʋlɩ pɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Ɩ polɑɑ kɛ́ nɑ ɩ́ sɔɔsɩ Amoni nyǝ́mɑ nɑ Amɑleke nyǝ́mɑ pɑ tɔɔ, nɑ pɑ́ yoonɑ-wɛ nɑ pɑ́ lɛɛkɩ Yeliko ɩcɑtɛ. ");
INSERT INTO dop_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Pɩɩsɩ pǝlefɛɩ hiu tǝcu kɛ́ Mowɑpʋ wulɑʋ ŋmɑkǝlɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Pɑ wiinɑ Tɑcɑɑ, ɩlɛnɑ ɩ́ kpɑ Pɛncɑmɛɛ kpekǝle tɑɑ tʋ Kelɑɑ pǝyɑlʋ mpʋtʋ Ɩhuti sɩ ɩ́ wɑɑsɩ-wɛ. Kɛlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ cɛlɑ Ɩhuti kɛ kʋcɔɔʋ sɩ ɩ́ ponɑ Mowɑpʋ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Ntɛnɑ Ɩhuti cɑɑ lɑɣɑtɛ nte tǝ wɛ lɔŋ kɛ tɑɑ nɑ wɑɑlɩ, nɑ tǝ́ tɑɣɑlɑ ɩsɩɩ mpiiŋ nɑɑlɛ tɔ, nɑ ɩ́ sʋsɩ-tɛɣɛ ɩ tokonɑɑ tɛɛ nɑ ɩ ntɔɣɔŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","Mpʋɣʋlɛ ɩ cɛlɑ wulɑʋ kɛ ɩ kʋcɔɔʋ. Apɑlʋ ɩnɩ ɩ kɑ kɛ kʋyɑsʋlʋ kɛ tǝmɑm. ");
INSERT INTO dop_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Ɩ tɛmɑ-ɩ cɛlʋɣʋ kɛ mpʋ, ɩlɛnɑ ɩ́ nɑ yǝlɑɑ mpɑ pɑɑ kɔnɑ kʋcɔɔʋ ŋkʋ tɔ pɑ́ lɩɩ. ");
INSERT INTO dop_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Pɑ kɔmɑ nɑ pɑ́ tɑlɑ pɛɛ wenɑ pɑ sikɑ Kilikɑɑ cɔlɔ nɑ pɑ́ lɑɑkɩ tɔ, ɩlɛnɑ Ɩhuti mǝlǝnɑ ɩ wɑɑlɩ, nɑ ɩ́ polo wulɑʋ kiŋ sɩ: Hɑɩ, tɑ́ cɑɑ, mɑɑ wɛnɑ fɑɑciyɑ nɑkǝlɩ sɩ mɑ nɑɑkɩ-ŋ mɑ́ nɑ-ŋ tɑ́ tike. Ɩlɛnɑ wulɑʋ lǝsɩ tǝmlɛ nyǝ́mɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Atɛ nɑ ɩsɔ nɑŋ ŋku kʋ niɣitɑ teu tɔ kʋ tɑɑ kɛ́ ɩ kɑ wɛɛ. Ntɛnɑ Ɩhuti kpǝtǝnɑ-ɩ nɑ ɩ́ tɔmɩ-ɩ sɩ: Tɑcɑɑ heelɑ-m tɔm sɩ mɑ́ heeli-ŋ. Tǝnɑɣɑlɛ wulɑʋ kʋlɑ ɩ tǝcɑɣɑlɛ. ");
INSERT INTO dop_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","Ɩlɛnɑ Ɩhuti kpɛɛ ɩ lɑɣɑtɛ nɑ mpʋtʋ nɑ ɩ́ sɔ wulɑʋ lotu tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","Nɑ tǝ́ sʋʋ tǝ tǝnɑ, nɑ pǝ́ kpɛŋnɑ kpɑ́tʋ́ɣʋ́, nɑ ɩ́ yele-tɛɣɛ mpʋ nɑ nim wɑɑsɩ tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Ɩ tɛmɑ mpʋ, ɩlɛnɑ ɩ́ lɩɩnɑ wɑɑlɩ tɔɔ, nɑ ɩ́ tǝkɩ nɑ ɩ́ kɑlǝsɩ. ");
INSERT INTO dop_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","Ɩ tɛɛwɑ ɩlɛnɑ tǝmlɛ nyǝ́mɑ polo pɑ mɑɣɑnɑ pǝ kɑlǝsɑ mpʋ. Ɩlɛnɑ pɑ́ tʋ pɑ tɑɑ sɩ wulɑʋ lɩɩkɩ ɩ ɑwɑlɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Ḿpʋ́ɣʋ́ pɑ tɑŋɑɑ nɑ pɑ́ kɑ́ ɩ fɛɩ tʋlʋɣʋ. Ɩlɛnɑ pɑ́ polo pɑ́ tʋlɩ pɑ mɑɣɑmɑɣɑ nɑ pɑ́ mɑɣɑnɑ pɑ cɑɑ hǝntɑ ɑtɛ nɑ ɩ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Wɑɑtʋ wei pɑ tɑŋɑ mpʋ tɔɣɔ Ɩhuti sewɑ nɑ ɩ́ tɛɛ pɛɛ tǝyɔkǝlɛ, nɑ ɩ́ polo ɩ́ ŋmɛlɩ Seyilɑ. ");
INSERT INTO dop_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Ɩ tɑlɑ Ɩfǝlɑyim pɔɔŋ tɑɑ, ɩlɛnɑ ɩ́ yɑɣɑ ɑpɑlʋ tutuɣu, nɑ ɩ́ koti Ɩsɛɣɛlɩ nyǝ́mɑ nɑ ɩ́ tʋ-wɛɣɛ nɔɣɔ nɑ pɑ́ tii pulɑsɩ. ");
INSERT INTO dop_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","Ɩlɛnɑ ɩ́ tɔ-wɛ sɩ: Ɩ́ tǝŋ mɑ wɑɑlɩ. Mpi tɔ, Tɑcɑɑ tʋ mǝ niŋ tɑɑ kɛ́ mǝ kolontunɑɑ Mowɑpʋ nyǝ́mɑ kɛ́. Ɩlɛnɑ pɑ́ polo nɑ pɑ́ nyɑlɑ-wɛɣɛ Yɑɑtɑnɩ tǝtɛsǝlɛ, nɔɣɔlʋ tɑ fiti. ");
INSERT INTO dop_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","Kʋyɑŋku pɑ kʋ Mowɑpʋ yoolɑɑ tɑɑ yoolɑɑ kɛ yǝlɑɑ iyisi nɑɑnʋwɑ (10000) kɛ́ nɔɣɔlʋ tɑ tʋlɩ. ");
INSERT INTO dop_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","Pǝ kpɑɣɑʋ wɑɑtʋ ɩnɩ tɔɣɔ Ɩsɛɣɛlɩ nyǝ́mɑ ŋmɑkǝlɑ Mowɑpʋ nyǝ́mɑ nɑ tɛtʋ hɛɛsɩ pɩɩsɩ nɩɩnɑɑsɑ tǝcu. ");
INSERT INTO dop_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Anɑtɩ pǝyɑlʋ Sɑmkɑɑ lɛɛtǝnɑ Ɩhuti lonte tɑɑ. Ɩnɩ ɩ kʋnɑ Filiisi nyǝ́mɑ kɛ yǝlɑɑ nɑsǝtoso (600) nɑ nɑʋ kpɑ́tʋ́ɣʋ́. Ɩ́lɛ́ ɩ wɑɑsɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","Ɩhuti sǝpɑ, ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɑsɑ lɑpʋ kɛ mpi pǝ tɑ mɑɣɑ Tɑcɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","Ḿpʋ́ɣʋ́ Tɑcɑɑ tʋ-wɛɣɛ Kɑnɑɑŋ nyǝ́mɑ wulɑʋ Yɑpɛŋ wei ɩ tɔkɑɣɑ kɑwulɑɣɑ kɛ Hɑsɔɔ tɔ ɩ niŋ tɑɑ. Ɩ yoou wulɑʋ kɛ pɑ yɑɑkɑɣɑ Siselɑ nɑ ɩ́ wɛ Hɑlose-Koyim. ");
INSERT INTO dop_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","Yɑpɛŋ ɩnɩ ɩ yoou kɛɛkɛnɑɑ kɑ wɛ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ (900) kɛ́. Ḿpʋ́ɣʋ́ ɩ nyǝŋsɑ Ɩsɛɣɛlɩ nyǝ́mɑ ɩsɛ kɛ pɩɩsɩ hiu tǝcu. Ɩlɛnɑ pɛlɛ pɑ́ wiinɑ Tɑcɑɑ sɩ ɩ́ wɑɑsɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","Lɑpitɔtɩ ɑlʋ Tepolɑ kɑ kɛnɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ nɑ ɩ́ hʋʋkɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɑ tɔmnɑɑ kɛ wɑɑtʋ ɩnɩ ɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","Petɛɛlɩ nɑ Lɑmɑ pɑ hɛkʋ tɑɑ timpi pɑ yɑɑ sɩ Tepolɑ Pɑɑʋ kɛ Ɩfǝlɑyim pʋɣʋ tɑɑ tɔɣɔ ɑlʋ ɩnɩ ɩ pukɑɣɑ nɑ ɩ́ cɑkɩ, nɑ ɩ́ tɑɣɑnǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔmnɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Tepolɑ ɩnɩ ɩ tilɑ Apinowɑm pǝyɑlʋ Pɑlɑkɩ kiŋ kɛ Ketɛɛsɩ kɛ Nɛfǝtɑli tɛtʋ tɑɑ, nɑ ɩ́ heeli-ɩ sɩ: Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ tɔmɑ sɩ ń lǝsɩ Nɛfǝtɑli nɑ Sɑpulɔŋ pǝ nyǝ́mɑ tɑɑ kɛ́ ɑpɑlɑɑ iyisi nɑɑnʋwɑ (10000) nɑ ń ponɑ-wɛɣɛ Tɑpɔɔ pʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","Mɑɑ yele nɑ Yɑpɛŋ yoolɑɑ wulɑʋ Siselɑ kuu ɩ yoolɑɑ nɑ ɩ kɛɛkɛnɑɑ nyǝɣǝtʋ nyǝ́mɑ nɑ pɑ́ lɩɩ Kisɔŋ lɔɔʋ tɑɑ sɩ pɑ yookinɑ-ŋ, ɩlɛnɑ mɑ́ tʋ-wɛɣɛ nyɑ́ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","Tǝnɑɣɑlɛ Pɑlɑkɩ cɔwɑ Tepolɑ sɩ: Ye mɑ nɑ-ŋ tɩɩ ponɑ, ɩlɛ mɑɑ polo. Amɑ ye n kɑɑ polo, ɩlɛ mɑɑ puki. ");
INSERT INTO dop_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","Mpʋɣʋlɛ Tepolɑ sɩ: Mɑ nɑ-ŋ tɩɩ polo yɑɑ. Amɑ pɑɑ n tɑlɑ timpi nɔɣɔlʋ kɑɑ sɑ-ŋ kɛ́. Mpi tɔ, ɑlʋ niŋ tɑɑ kɛ́ Tɑcɑɑ kɑ́ tʋ Siselɑ. Ɩlɛnɑ Tepolɑ kʋlɩ nɑ ɩ́ nɑ Pɑlɑkɩ pɑ́ tɛɛ Ketɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","Ḿpʋ́ɣʋ́ Pɑlɑkɩ kpeɣelɑ Nɛfǝtɑli nɑ Sɑpulɔŋ nyǝ́mɑ, nɑ yǝlɑɑ iyisi nɑɑnʋwɑ (10000) tisi sɩ pɑɑ tǝŋɩ-ɩ, nɑ Tepolɑ mɑɣɑmɑɣɑ nɑ́ɑ́ polo tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","Keni tʋ Hepɛɛ kɑ fɑɣɑnɑ Keni nyǝ́mɑ lɛlɑɑ mpɑ pɑ kɛ́ Moisi yǝtɩ Hopɑpɩ pǝyɑlɑɑ tɔɣɔ. Ɩlɛnɑ ɩ́ polo ɩ́ siki Sɑɑnɑnim tɩɩŋ sɔsɔɔŋ tɛɛ kɛ́ Ketɛɛsɩ kiŋ. ");
INSERT INTO dop_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","Ḿpʋ́ɣʋ́ Siselɑ nɩɩwɑ sɩ Apinowɑm pǝyɑlʋ kpɑwɑ Tɑpɔɔ pʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","Ɩlɛnɑ ɩ́ koti ɩ yoolɑɑ nɑsǝnɑɑsɑ nɑ nɩɩnʋwɑ (900) kɛ́ Hɑlose nɑ pɑ́ tɛɛ Kisɔŋ lɔɔʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","Ntɛnɑ Tepolɑ tɔ Pɑlɑkɩ sɩ: Polo pɑ tɔɔ, sɑŋɑ kɛ Tɑcɑɑ tʋɣɩ Siselɑ kɛ nyɑ́ niŋ tɑɑ, nɑ ɩ mɑɣɑmɑɣɑ ɩ kɑ́ wɛɛnɑ nyɑ́ wɑɑlɩ. Ḿpʋ́ɣʋ́ Pɑlɑkɩ tiiwɑ Tɑpɔɔ pʋɣʋ nɑ ɩ wɑɑlɩ kɛ́ yoolɑɑ iyisi nɑɑnʋwɑ (10000). ");
INSERT INTO dop_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","Pɑ nikɑ yoou, ɩlɛnɑ Tɑcɑɑ yele nɑ Siselɑ yoolɑɑ nɑ ɩ kɛɛkɛnɑɑ pɑ́ kuu-tɛ. Hɑlǝnɑ Siselɑ lɩɩ ɩ kɛɛkɛ tɑɑ, nɑ ɩ́ se nɔɔhɛɛ. ");
INSERT INTO dop_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","Ɩlɛnɑ Pɑlɑkɩ tʋ ɩ kolontunɑɑ nɑ pɑ kɛɛkɛnɑɑ wɑɑlɩ, nɑ ɩ́ tɑnɑ-wɛɣɛ Hɑlose. Nɑ ɩ́ hɛɛlɩ pɑ yoolɑɑ tǝnɑ pǝ tɑ sɔɔ pɑɑ ɩlɔɣɔʋ pǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","Ḿpʋ́ɣʋ́ Siselɑ sewɑ nɑ ɩ́ polo Keni tʋ Hepɛɛ ɑlʋ Yɑyɛɛ tɛ. Mpi tɔ, wulɑʋ Yɑpɛŋ yǝlɑɑ nɑ Hepɛɛ nyǝ́mɑ pɑɑ wɛ tǝmɑ nɑ leleŋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","Ɩlɛnɑ Yɑyɛɛ lɩɩ nɑ ɩ́ sǝŋ Siselɑ nɑ ɩ́ tɔmɩ-ɩ sɩ: Tɑ cɑɑ, sʋʋ mɑ tɛ cǝnɛ, tɑɑ nyɑnɑ pʋlʋ. Siselɑ sʋʋwɑ Yɑyɛɛ cokǝle tɑɑ, ɩlɛnɑ ɩ́ hǝntɩ nɑ ɑlʋ ɩnɩ ɩ́ wɑɑsɩ ɩ tɔɔ kɛ́ pʋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","Ḿpʋ́ɣʋ́ ɑpɑlʋ ɩnɩ ɩ tɔmɑ-ɩ sɩ: Lʋkɔtʋ tɔkɑ-m kɛ́, hɑ-m lʋmɑɣɑ nɑ mɑ́ nyɔɔ. Ɩlɛnɑ ɑlʋ cosi nɑɑlǝm kɛ huluɣu tɑɑ nɑ ɩ́ hɑ-ɩ nɑ ɩ nyɔɔ, nɑ ɩ́ tɑɣɑnɩ-ɩ pʋʋɣʋ wɑɑsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","Mpʋɣʋlɛ Siselɑ tɔmɑ ɑlʋ ɩnɩ sɩ: Sǝŋ cokǝle nɔnɔɣɔ, nɑ wei ɩ́ pɔɔsɑ-ŋ sɩ nɔɣɔlʋ wɛ cǝnɛ? Ɩlɛ n cɔ sɩ, ɑɑɩ. ");
INSERT INTO dop_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","Siselɑ kɑ kɑwɑɣɑ tǝtɔɣɔtɔɣɔ, ɩlɛnɑ ɩ́ too ɩsɩɩ ɩ sǝpɑ. Ḿpʋ́ɣʋ́ Yɑyɛɛ kpɑɣɑ pɔɔŋ cokǝle kɑŋkɑnɑɣɑ nɑ kɑŋkɑnʋɣʋ, nɑ ɩ́ kpǝtǝnɑ-ɩ tǝhɛɛ nɑ ɩ́ kɛɛsǝnɑ ɩ lǝkpɑɣɑsɑɣɑ tɔɔ nɑ ɩ́ kɑ́ nɑ ɩ́ kpǝnɑ tɛtʋ nɑ Siselɑ sɩ. ");
INSERT INTO dop_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","Pǝ wɑɑlɩ kɛ́ Pɑlɑkɩ sewɑ Siselɑ wɑɑlɩ nɑ ɩ́ tɑlɑ Yɑyɛɛ tɛ nɑ Yɑyɛɛ lɩɩ nɑ ɩ́ tɔmɩ-ɩ sɩ. Kɔɔ, mɑɑ hʋlɩ-ŋ yʋlʋ wei n pɛɛkǝɣɩ tɔ. Pɑlɑkɩ sʋʋ cokǝle tɑɑ, ɩlɛnɑ ɩ́ mɑɣɑnɑ ɩ hǝntɑ ɑtɛ tǝcɔmm, nɑ kpɑ́tʋ́ɣʋ́ tʋʋ ɩ lǝkpɑɣɑsɑɣɑ tɑɑ nɑ ɩ́ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","Kʋyɑkʋ ŋkʋɣʋ Ɩsɔ yelɑɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ kǝlɩ Kɑnɑɑŋ wulɑʋ Yɑpɛŋ. ");
INSERT INTO dop_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ kɑɑsɑ pɑ tǝɣɩ teu nɑ tǝhɛɛ tǝhɛɛ pɑ́ kɔɔ pɑ́ tɛɛsǝnɑ Kɑnɑɑŋ wulɑʋ kɛ kʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","Kʋyɑkʋ ŋku Tepolɑ nɑ Apinowɑm pǝyɑlʋ Pɑlɑkɩ pɑ kǝlɑ Siselɑ tɔɣɔ pɑ mɑpɑ kɑwǝyɑɣɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ ponɑ sɑmɑɑ kɛ yoou. Ɩ́ sɑ Tɑcɑɑ. Sɑmɑɑ yoonɑ luɣu kʋlʋmʋɣʋ. Ɩ́ sɑ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","Awulɑɑ sɔsɑɑ mɛ, ɩ́ nɩɩ yoo. Awulumpiyɑ mɛ, mɩɩ welisi yoo. Mɑ sɑŋ Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","Tɑcɑɑ lɩɩnɑ Seyii pʋɣʋ, ɩlɛnɑ tɛtʋ sʋʋ seluɣu. Ɩ́ lɩɩ Ɩtɔm tɛtʋ tɑɑ, ɩlɛnɑ tɛʋ nɑ́ɑ́ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","Sinɑyi pʋɣʋ selɑ sɔsɔm kɛ Tɑcɑɑ ɩsɛntɑɑ, pɔɔŋ selɑɑ tǝpǝŋŋ kɛ Tɑcɑɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","Anɑtɩ pǝyɑlʋ Sɑmkɑɑ pɔɔlɛ tɑɑ yǝlɑɑ cɑɑsɩ yɑ yem kɛ́ tɛtʋ tɑɑ kɛ́. Yɑyɛɛ pɔɔlɛ tɑɑ, tɔntɑɑ tǝŋɑɣɑ mpɑɑŋ kpɑɩ nyǝŋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ fɛɩnɑ nyʋɣʋ tʋ, kɛnɑ Tepolɑ kʋlɩ ɩ nɑɑsɩ tɑɑ. Pɑ tɑɑ fɛɩnɑ ɑkɑ nɔɣɔlʋ ɩlɛnɑ pɑ too Tepolɑ kʋlɩ. ");
INSERT INTO dop_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","Tɩɩŋ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ lǝsɑɑ ɩlɛnɑ yoou nɑ́ɑ́ tii tǝkpili. Yoolɑɑ tuutuumɑ mɛ, kpɑ́lʋ́ɣʋ́ fɛɩ. Yoolɑɑ sɑmɑɑ mɛ, ŋmɑntɑɑɣɑ fɛɩ. ");
INSERT INTO dop_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ mɛ, mɑ sɑmɑ. Luɣu kʋlʋmʋɣʋ yoolɑɑ mɛ, mɑ sɑmɑ. Ɩ́ sɑ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","Awulɑɑ sɔsɑɑ mɛ, ɩ́ pǝsǝnɑ lɑɑkɑlɩ. Apilɑ mɛ, ɩ́ pǝsǝnɑ lɑɑkɑlɩ. Kʋnyɔntʋnɑɑ mɩɩ pǝsǝnɑ lɑɑkɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","Lʋm lulɑɑ ɩ́ sɑ Ɩsɔ kɛ́ ɩ kʋpɑntʋ tɔɔ. Ɩ́ sɑmɩ-ɩ kʋpɑntʋ nti ɩ lɑpɑ Ɩsɛɣɛlɩ tɔ tǝ tɔɔ. Ɩsɛɣɛlɩ cɑɣɑ tǝpɑmm tɔ ɩ́ sɑmɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","Tepolɑ, Tepolɑ kʋlɩ nɑ ń wɑɑsɩ. Kʋlɩ nɑ ń mɑ kɑwǝyɑɣɑ. Apinowɑm pǝyɑlʋ Pɑlɑkɩ kʋlɩ. Kʋlɩ, nɑ ń cɛ Ɩsɛɣɛlɩ sɑlǝkɑtʋnɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","Kɑɑsǝlɑɑ nɑ́ kǝlɑ ɑkɑnɑɑ. Tɑcɑɑ yelɑɑ nɑ mɑ́ kǝlɩ ɑkɑnɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","Ɩfǝlɑyim nyǝ́mɑ polɑ tɛtɛkǝlɛ tɑɑ. Pɛncɑmɛɛ nyǝ́mɑ polɑ tɛtɛkǝlɛ tɑɑ. Awulɑɑ sɔsɑɑ lɩɩnɑ Mɑkii. Yoolɑɑ ɑkewenɑɑ nɑ́ lɩɩnɑ Sɑpulɔŋ. ");
INSERT INTO dop_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","Ɩsɑkɑɑ nyʋɣʋ nyǝ́mɑ tǝŋɑ Tepolɑ nɑ Pɑlɑkɩ. Ɩsɑkɑɑ yoolɑɑ sɔɔsɑ Tepolɑ pɑ tɔɔ, pɑ kpɛntɑ tɔntɛ nɑ pɑ́ polo tɛtɛkǝlɛ tɑɑ. Pǝ nɑ pǝ mpʋ tɔ, Lupɛŋ nyǝ́mɑ nɑ́ pɑɑsǝnɑ tɔmnɑɑ hɔm kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","Lupɛŋ nyǝ́mɑ pɑɑsǝnɑ kɑlǝkǝŋ wulɑ nɩɩʋ suwe? Pɑ pɑɑsǝnɑ tɔmnɑɑ hɔm kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","Kɑtɩ nyǝ́mɑ tɑ kɔɔ, pɑ sɑɑlɑ Yɑɑtɑnɩ wɑɑlɩ. Tɑŋ nyǝ́mɑ tɑ kɔɔ, pɑ sɑɑlɑ kpɩɩlǝŋ tɑɑ. Asɛɛ nyǝ́mɑ tɑ kɔɔ, pɑ sɑɑlɑ teŋku nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","Sɑpulɔŋ nyǝ́mɑ nɑ́ tisɑɑ nɑ pɑ́ mʋ sǝm. Nɛfǝtɑli nyǝ́mɑ nɑ́ tisɑɑ nɑ pɑ́ polo tǝyoole. ");
INSERT INTO dop_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","Awulɑɑ sɔsɑɑ lɩɩ yoou. Kɑnɑɑŋ ɑwulɑɑ lɩɩ yoou. Pɑ lɩɩwɑ sɩ pɑ yookinɑ Tɑnɑkɩ. Pɑ yookinɑ Tɑnɑkɩ kɛ Mekito lʋm nɔɣɔ. Pɑ lɑŋɑ wontu. Pɑ wɩɩ liɣitee. ");
INSERT INTO dop_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","Ɩsɔtʋlʋŋɑsɩ mɑɣɑmɑɣɑ nɑ́ yoowɑ, hɑtoo sɩ mpɑɑŋ tɑɑ kɛ́ sɩ yoonɑ Siselɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","Kisɔŋ lɔɔʋ tɔɣɔ kolontunɑɑ. Lɔŋtɑɑ Kisɔŋ lɔɔʋ kpiisɑ-wɛ. Tǝ kɑɑsɩ tɑ tɩ nɑ tǝ́ nyɔɔ toŋ. ");
INSERT INTO dop_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","Selɑɑ tʋwɑ cɑsǝlɛ. Pɑ kpɑɣɑnǝŋ ɑcʋwɑ wiinɑ ntɛɣɛ kpɑkɑtɑm kpɑkɑtɑm. ");
INSERT INTO dop_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","Tɑcɑɑ ɩsɔtɑɑ tillu sɩ pɑ́ tǝŋsɩ Melosi ɩcɑtɛ kɛ mpusi. Sɩ pɑ́ tǝŋsɩ tǝ yǝlɑɑ kɛ mpusi, pɑ tɑ lɩɩ Tɑcɑɑ yoou. Pɑ tɑ kɔɔ sɩ pɑ sǝŋnɑ Tɑcɑɑ yoolɑɑ tɑɑ yoolɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","Pɑ́ kooli Yɑyɛɛ kɛ kʋpɑntʋ. Pɑ́ kooli Keni tʋ Hepɛɛ ɑlʋ kɛ kʋpɑntʋ. Pɑ́ kooli-ɩ kʋpɑntʋ kɛ cokɑ tɑɑ ɑlɑɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","Siselɑ sǝlǝmɑ Yɑyɛɛ kɛ lʋm nɑ ɩ́lɛ́ ɩ cɛlɛ-ɩ nɑɑlǝm. Tete nɑɑlǝm kɛ ɩ hɑ-ɩ kɑlɑʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","Yɑyɛɛ kpɑɣɑ kɑŋkɑnɑɣɑ nɑ mpǝlɛ, nɑ ɩ́ co kɑŋkɑnʋɣʋ nɑ ŋwɑɑŋ, nɑ ɩ́ kɑ Siselɑ nyʋɣʋ nɑ ɩ́ tʋlɩ pʋ́ʋ́ɣʋ́. Ɩ kɑmɑɣɑ nɑ ɩ́ yɔkɩ nyʋmpɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","Siselɑ yelɑ ɩ tɩ nɑ ɩ hoti ɑlʋ tɛɛ tǝmɑɑi. Ɩ hǝntɑ ɑtɛ tǝcɔmm nɑ ɩ́ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","Siselɑ too tɑŋɑɑ nɑ ɩ́ nyǝnǝɣǝnɑ pǝtote. Nɑ ɩ́ nǝɣǝsǝɣɩ sɩ: Pepe tɔɔ kɛ́ Siselɑ kɛɛkɛ tɑ tɑlɑ lɔŋ? ");
INSERT INTO dop_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","Alɑɑ lǝmɑɣɑsɛɛ nyǝ́mɑ nɑ́ cɔ-ɩ. Ɩnɩ ɩ lɛlɑ pɑ kʋcɔcʋtʋ ntɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","Ɩsǝntɔ yoolɑɑ kuu wontuŋ kɛ́, nɑ pɑ́ tɑlǝɣɩ, ɩnɛɣɛ pɛɛlɔ yɑɑ pɛɛlɑɑ nɑɑlɛ. Siselɑ kɛ pʋʋɣʋ kʋpɑŋkʋ yɑɑ pɔɔŋ nɑɑlɛ. Nɑ mɑ́ɑ́ pɑɑ pʋʋɣʋ kʋsɔpʋɣʋ yɑɑ pɔɔŋ nɑɑlɛɣɛ mɑ luɣu tɛɛ. ");
INSERT INTO dop_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","Tɑcɑɑ kolontunɑɑ ɩ́ sǝkɩ mpʋ. Ɩ tɑɑpɑlɑɑ nɑ́ɑ́ teeki kɔkɔ ɩsɩɩ ilim lɩɩkʋɣʋ tɔ. Pǝlɛ pǝ wɑɑlɩ Ɩsɛɣɛlɩ tɛtʋ hɛɛsɑ pɩɩsɩ nɩɩlɛ tǝcu. ");
INSERT INTO dop_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɑsɑ lɑpʋ kɛ mpi pǝ tɑ mɑɣɑ Tɑcɑɑ tɔ. Ɩlɛnɑ ɩ́lɛ́ ɩ tʋ-wɛɣɛ Mɑtiyɑŋ nyǝ́mɑ niŋ tɑɑ kɛ́ pɩɩsɩ nɩɩlɛ tǝcu. ");
INSERT INTO dop_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","Mɑtiyɑŋ nyǝ́mɑ cɔɔsɑ-wɛɣɛ sɔsɔm kɛ́. Ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ se nɑ pɑ́ cɔɔsɩ pulɑsɩ tɑɑ, nɑ kʋkpɑmǝŋ pɔɔŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","Ye Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ tuuki pɑ tɑwɑ, ɩlɛ Mɑtiyɑŋ nyǝ́mɑ, nɑ Amɑleke nyǝ́mɑ, nɑ ilim tǝlɩɩlɛ tɔɔ tɔntɑɑ pɑ kpɛntɩ nɑ ");
INSERT INTO dop_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","pɑ́ wɑtɩ-wɛ, nɑ pɑ́ wɑkǝlǝɣɩ pɑ kʋhɑlǝm, hɑlǝnɑ pɑ́ tɑlɑ timpi pɑ yɑɑ sɩ Kɑsɑ tɔ. Pɑɑ kɑɑsǝɣɩ pʋlʋ sɩ pɛlɛ pɑ́ tɔɣɔ. Nɑ pɑ́ kpɛŋnɑ pɑ tɔlɑ nɑ pɑ́ kpɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","Pɑ kɔŋɑɣɑnɑ pɑ kɑlǝkǝŋ nɑ pɑ cokɑ kɛ́. Pɑ nɑ pɑ yooyoonɑɑ pɑɑ wɛ pɑɣɑlɛ kɛ́ ɩsɩɩ kʋtoloŋ, pɑ fɛɩ kɑlʋɣʋ. Pɑ wɑtǝɣɩ Ɩsɛɣɛlɩ tɛtʋ kɛ́ nɑ pɑ́ wɑkǝlǝɣɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","7","Ɩsɛɣɛlɩ nyǝ́mɑ tɔɣɔnɑ pɑ tǝɣɩ teu kɛ Mɑtiyɑŋ nyǝ́mɑ niŋ tɑɑ kɛ́. Ɩlɛnɑ pɑ́ wiinɑ Tɑcɑɑ sɩ ɩ́ wɑɑsɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","Ntɛnɑ Tɑcɑɑ kpɑ-wɛɣɛ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ, nɑ ɩ́lɛ́ ɩ heeli-wɛ sɩ: Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ yɔɣɔtɑɑ sɩ mɑ lǝsǝnɑ-mɛɣɛ Icipiti yomle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","Mɑ́ wɑɑsǝnɑ-mɛɣɛ Icipiti nyǝ́mɑ niŋ tɑɑ, nɑ mɑ́ tɔɣɔnɩ mpɑ pɑ cɔɔsɑɣɑ-mɛ tɔ, nɑ mɑ́ hɑ-mɛɣɛ pɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","Hɑlǝnɑ mɑ́ heeli-mɛ sɩ, mɑɣɑlɛ mǝ Ɩsɔ Tɑcɑɑ. Ɩlɛ ɩ́ tɑɑ nyɑnɑ Amolii nyǝ́mɑ mpɑ pɑ tɛtʋ tɑɑ ɩ́ wɛ ɩsǝntɔ tɔ pɑ tɩɩŋ. Amɑ ɩ́ tɑ nɩɩnɑ-m. ");
INSERT INTO dop_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","Ḿpʋ́ɣʋ́ Tɑcɑɑ ɩsɔtɑɑ tillu kɔmɑ Ofǝlɑ nɑ ɩ́ cɑɣɑ Apiyesɛɛ lʋlʋɣʋ tʋ Yowɑsɩ hɑlǝm tɑɑ kɛ́ tʋɣʋ nɑkʋlɩ kʋ tɛɛ. Nɑ Yowɑsɩ pǝyɑlʋ Ketiyɔŋ ŋmɛlɑ lɛsɛŋ tǝnyɑɑsǝlɛ, nɑ ɩ́ mɑkɩ tɔɣɔnɑɣɑ sɩ Mɑtiyɑŋ nyǝ́mɑ ɩ́ tɑɑ nɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","Tǝnɑɣɑlɛ ɩsɔtɑɑ tillu lɩɩ ɩ tɔɔ nɑ ɩ́ tɔmɩ-ɩ sɩ: Yoolɑɑ tɑɑ ɑkɑ nyɑ́, Tɑcɑɑ wɛ nyɑ́ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","Kɛlɛnɑ Ketiyɔŋ nɔɣɔ tǝkpɑʋ sɩ: Aɑɩ, mɑ cɛ, ye Tɑcɑɑ kɑ wɛ tɑ́ wɑɑlɩ, pepe tɔɔ kɛ́ tǝ tɔkɩ wɑhɑlɑnɑɑ pɑnɛ? Nɑ leɣe piti tǝmɑ nnɑ ɑ tɔm tɑ́ cɑɑnɑɑ kɛɛsɑ-tʋ sɩ ɩ lɑpɑ-wɛɣɛ wɑɑtʋ wei ɩ lǝsɑ-wɛɣɛ Icipiti tɔ ɑ wɛɛ? Pɔpɔtʋ fɛɩ leleŋ, Tɑcɑɑ lɔ-tʋɣʋ, nɑ ɩ́ tʋ-tʋɣʋ Mɑtiyɑŋ nyǝ́mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","Mpʋɣʋlɛ Tɑcɑɑ pǝsǝnɑ Ketiyɔŋ tɔɔ nɑ ɩ́ tɔmɩ-ɩ sɩ: Ponɑ tomɑ wenɑ n wɛnɑ mpʋ tɔ, nɑ ń wɑɑsɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Mɑtiyɑŋ nyǝ́mɑ niŋ tɑɑ. Mɑ mɑɣɑmɑɣɑ mɑ tiliɣinɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","Ntɛnɑ Ketiyɔŋ sɩ: Hɑɩ, Tɑcɑɑ, mɑɑ wɑɑsɩ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ mɑ we? Mpi tɔ, tɑ́ tǝyɑɣɑ tɑ kɛ pʋlʋɣʋ Mɑnɑsee lʋlʋɣʋ nyǝ́mɑ tɑɑ. Pǝ́cɔ́ mɑ tɩɩ kɛ́ pǝyɑɣɑ ntɔ. ");
INSERT INTO dop_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","Mpʋɣʋlɛ Tɑcɑɑ sɩ: Mɑɑ wɛɛ nyɑ́ wɑɑlɩ kɛ́, nɑ ń tǝlǝkɩ Mɑtiyɑŋ nyǝ́mɑ ɩsɩɩ yʋlʋ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","Ɩlɛnɑ Ketiyɔŋ sɩ: Ye mpʋ lɑ nɑ mɑ́ nyɩ tǝkelekele sɩ Tɑcɑɑ nyɑ́, nyɑ́ yɔɣɔtǝɣǝnɑnɑ-m. ");
INSERT INTO dop_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","Sǝŋ nɑ mɑ́ kɔnɑ-ŋ kʋcɔɔʋ nɑ pǝ́cɔ́ ń tɛɛ. Tɑcɑɑ sɩ: Polo nɑ ń kɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","Ketiyɔŋ polɑɑ, ɩlɛnɑ ɩ́ kʋ́ pǝfɑtɛ nɑ ɩ́ tǝsɩ nɑ ɩ́ tʋ potopotonɑɑ mpɑ pɑ tɑɑ kʋkʋsʋm fɛɩ tɔɣɔ sɔsɔm. Ɩlɛnɑ ɩ́ kuuli nɑntʋ kɛ tokiyɑ tɑɑ, nɑ yom kɛ nyɑnɑɣɑ tɑɑ nɑ ɩ́ ponɑ Ɩsɔ ɩsɔtɑɑ tillu kɛ tʋɣʋ sɔsɔɔŋkʋ ŋkʋ kʋ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","Ɩlɛnɑ ɩsɔtɑɑ tillu tɔmɩ-ɩ sɩ: Polo nɑ ń sɩɩ nɑntʋ nɑ potopotonɑɑ kɛ kʋkpɑmʋɣʋ kʋnɛ kʋ tɔɔ nɑ ń pɔ yom. Ɩlɛnɑ Ketiyɔŋ lɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","Ḿpʋ́ɣʋ́ Tɑcɑɑ ɩsɔtɑɑ tillu tokinɑ nɑntʋ nɑ potopotonɑɑ mpɛ nɑ ɩ kpɑ́tʋ́ɣʋ́. Ɩlɛnɑ kɔkɔ lɩɩ kʋkpɑmʋɣʋ tɑɑ nɑ kɑ́ nyɑɣɑ pǝ tǝnɑ. Nɑ ɩsɔtɑɑ tillu nɑ́ɑ́ mʋkɩ yem. ");
INSERT INTO dop_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","Tǝnɑɣɑlɛ Ketiyɔŋ cɛkǝnɑɑ sɩ Tɑcɑɑ ɩsɔtɑɑ tillu kɛ́. Ɩlɛnɑ ɩ́ yɑɣɑ kɑpukɑ sɩ: Hɑɩ, mɑ tɔm tɛmɑ. Mɑ nɑwɑ Ɩsɔ ɩsɔtɑɑ tillu ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","Amɑ Tɑcɑɑ nɑ́ tɔmɑ-ɩ sɩ: Nyɑ́ lɑŋlɛ ɩ́ tɑɑ wɑkǝlɩ, n kɑɑ sɩ́ se. ");
INSERT INTO dop_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","Mpʋɣʋlɛ Ketiyɔŋ ŋmɑwɑ Tɑcɑɑ kɛ kɔtɑɣɑ tǝlɑtɛ, nɑ ɩ́ hɑ-tɛɣɛ hǝtɛ sɩ Tɑcɑɑ hɛɛsǝɣǝnɑ lɑŋɑ. Kɔtɑɣɑ tǝlɑtɛ ntɛ́ tǝ wɛ hɑlǝnɑ sɑŋɑ kɛ Apiyesɛɛ nyǝ́mɑ ɩcɑtɛ Ofǝlɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Ketiyɔŋ kɛ ɑhoo ɑnɩ sɩ: Kpɑ nyɑ́ cɑɑ lɑtǝcɛ kʋfɑlʋ, nɑ ń tɑsɑ nɑɑlɛ nyǝŋ wei ɩ wɛnɑ pɩɩsɩ nɑɑtosompɔɣɔlɑɣɑ tɔ. Ɩlɛnɑ ń yɔkɩ nyɑ́ cɑɑ tǝlɑɑlɛ nɑ ń kpɛsɩ tesikɑ ŋkɑ pɑ lɑɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","Ɩlɛnɑ ń ŋmɑ-m kɔtɑɣɑ tǝlɑtɛ kɛ pʋɣʋ kʋnɛ kʋ nyʋɣʋ tɑɑ nɑ ń kpɑɣɑ tesikɑ ŋkɛ kɑ tɑɑsɩ nɑ ń lɑnɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ nɑ lɑtǝcɛ nɑɑlɛ nyǝŋ. ");
INSERT INTO dop_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","Ɩlɛnɑ Ketiyɔŋ lǝsɩ ɩ tǝmlɛ nyǝ́mɑ kɛ nɑɑnʋwɑ, nɑ ɩ́ lɑ́ ɩsɩɩ Tɑcɑɑ kɛɛsɑ-ɩ tɔɣɔ ɑhoo. Mpi tɔ, ɩ nyɑŋɑɣɑnɑ ɩ cɑɑ tǝyɑɣɑ nyǝ́mɑ nɑ ɩcɑtɛ yǝlɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","Pǝ femɑ nɑ ɩcɑtɛ nyǝ́mɑ kʋlɩ tɑnɑŋ tɛɛ tǝhulu, ɩlɛnɑ pɑ́ mɑɣɑnɑ pɑ yɔkɑ tʋɣʋ nɑ pɑ́ kpɛsɩ tesikɑ. Nɑ pɑ́ lɑ́ lɑtǝcɛ nɑɑlɛ nyǝŋ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔɣɔ kɔtɑɣɑ tǝlɑtɛ nte pɑ ŋmɑwɑ tɔ tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","Mpʋɣʋlɛ pɑ pɔɔsɑ tǝmɑ sɩ: Awe mɑɣɑmɑɣɑ lɑpǝnɑ mpʋ? Ɩcɑtɛ nyǝ́mɑ cɛkǝnɑɑ sɩ Ketiyɔŋ lɑpǝnɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","Ɩlɛnɑ pɑ́ tɔ́ ɩ cɑɑ Yowɑsɩ sɩ: Lǝsɩ nyɑ́ pǝyɑlʋ nɑ tǝ́ kʋ-ɩ. Mpi tɔ, ɩ yɔkɑ tǝlɑɑlɛ, nɑ ɩ́ kpɛsɩ pǝcɔlɔ tesikɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","Mpʋɣʋlɛ ɑpɑlʋ ɩnɩ ɩ cɔwɑ mpɛ ɩnɩ sɩ: Mǝ nyǝntʋ suweɣe tʋɣʋ ŋkʋ kʋ tɔm tɑɑ? Ye pǝ cǝpɑ wei sɩ ɩ sɛɛkǝnɑ kʋ tɔɔ, ɩsɩɩ pʋntʋ sǝpɑ nɑ pǝ́cɔ́ pǝ nyɑɑlɩ. Ye kʋ kɛ tʋɣʋ, kʋ yoo kʋ mɑɣɑmɑɣɑ kʋ yoou. Mpi tɔ, kʋ tǝlɑɑlɛ kɛ pɑ yɔkɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","Kʋyɑkʋ ŋkʋɣʋ pɑ hɑ Ketiyɔŋ kɛ hǝtɛ sɩ: Yelupɑɑlɩ. Pǝ nyʋɣʋ ntɛ́ sɩ: Pɑɑlɩ ɩ́ yoo ɩ tɩ yoou. Ɩ tǝlɑɑlɛ kɛ pɑ yɔkɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Mɑtiyɑŋ nyǝ́mɑ, nɑ Amɑleke nyǝ́mɑ, nɑ ilim tǝlɩɩlɛ tɔɔ tɔntɑɑ kotɑɑ, nɑ pɑ́ tɛsɩ Yɑɑtɑnɩ nɑ pɑ́ polo pɑ́ pɩɩlɩ Sisilee tɛtɛkǝlɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","Ɩlɛnɑ Ɩsɔ Feesuɣu tii Ketiyɔŋ tɔɔ nɑ ɩ́ yɑɣɑ ɑpɑlʋ tutuɣu sɩ Apiyesɛɛ lʋlʋɣʋ nyǝ́mɑ ɩ́ tʋ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","Nɑ ɩ́ tili tɔtɔɣɔ Mɑnɑsee nyǝ́mɑ kiŋ sɩ ɑpɑlɑɑ ɩ́ lɩɩ nɑ pɑ́ tʋ ɩ wɑɑlɩ, nɑ ɩ́ yɑɑ Asɛɛ nyǝ́mɑ, nɑ Sɑpulɔŋ nyǝ́mɑ, nɑ Nɛfǝtɑli nyǝ́mɑ, nɑ pɑ tǝnɑ pɑ́ sɔɔsɩ ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","Mpʋɣʋlɛ Ketiyɔŋ tɔmɑ Ɩsɔ sɩ: Ye tɑmpɑnɑ sɩ nyɑ́ toŋ kɛ mɑɑ wɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ ɩsɩɩ n kɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","Tɔʋ, mɑɑ pɔ heu kɔŋlɛ kɛ Kɑtɑɣɑ tɑɑ. Ye cɔlɔʋ kpɑ-tɛɣɛ ɑhoo nɑ ɑtɛ nɑ́ɑ́ wʋlɑɑ, ɩlɛ tǝnɑɣɑ mɑɑ nyǝnɑ sɩ nyɑ́ toŋ kɛ mɑɑ wɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","Ɩlɛnɑ pǝ́ lɑ ḿpʋ́ɣʋ́ teitei. Tɛʋ femɑ tɑnɑŋ nɑ Ketiyɔŋ nyɑɑsɩ kɔŋlɛ ńtɛ́, ɩlɛnɑ lʋm lɩɩ nɑ pǝ́ su poosiyɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","Ntɛnɑ ɩ́ tɔ Ɩsɔ sɩ: Hɑɩ, yele mɑ́ tɑsɑ-ŋ nɑtǝlǝɣɩ pɔɔsʋɣʋ. Tɑɑ mʋ-m nɑ pɑ́ɑ́nɑ́. Mɑ cɑɑ sɩ ń tɑsɑ-m pʋlʋɣʋ hʋlʋɣʋ kɛ tɔm kʋlʋm. Pǝnɛntɛ cɔlɔʋ ɩ́ kpɑ tɛtʋ tɔɔ tike, nɑ kɔŋlɛ nɑ́ɑ́ wʋlɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","Ɩlɛnɑ Ɩsɔ mʋ Ketiyɔŋ nɔɣɔ kɛ ɑhoo ɑnɩ nɑ kɔŋlɛ nɑ́ɑ́ wʋlɩ nɑ cɔlɔʋ kpɑ tɛtʋ tɔɔ tike. ");
INSERT INTO dop_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","Ḿpʋ́ɣʋ́ Ketiyɔŋ nɑ ɩ yoolɑɑ pɑ kʋlɑ lɔŋ kɛ tɑnɑŋ nɑkʋlɩ nɑ pɑ́ polo pɑ́ pɩɩlɩ Hɑlotɩ hite nɔɣɔ, nɑ Mɑtiyɑŋ nyǝ́mɑ nɑ́ɑ́ pɩɩlǝnɑ ilim ntɔɣɔŋ tɔɔ kɛ́ Molee pulɑɣɑ cɔlɔ. ");
INSERT INTO dop_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","Ɩlɛnɑ Tɑcɑɑ tɔ Ketiyɔŋ sɩ: Nyɑ́ yoolɑɑ kǝlɑ tɔɔʋ, mɑ kɑɑ tʋ Mɑtiyɑŋ nyǝ́mɑ kɛ nyɑ́ niŋ tɑɑ, nɑ pǝ́ kɔɔ nɑ ń sɑ nyɑ́ tɩ sɩ nyɑ́ toŋ kɛ́ n lɑpǝnɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","Mpʋ tɔ, heeli-wɛ sɩ, sɔɣɔntʋnɑɑ ɩ́ mǝlɩ tǝyɑɣɑ. Mpʋɣʋlɛ yǝlɑɑ iyisi hiu nɑ nɑɑlɛ (22000) mǝlɑɑ, nɑ pǝ́ kɑɑsɩ yǝlɑɑ iyisi nɑɑnʋwɑ (10000) tike. ");
INSERT INTO dop_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Ketiyɔŋ sɩ: Nyɑ́ yoolɑɑ kǝlɑ tɔɔʋ tɔtɔ. Tiinɑ-wɛɣɛ lɔɔʋ nɔɣɔ, nɑ mɑ mɑɣɑmɑɣɑ mɑ́ tɔɔsɩ potɑɑ nɑ cɑɣɑlɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","Yoolɑɑ tii tǝnɑ, ɩlɛnɑ Tɑcɑɑ heeli-ɩ sɩ: Fɑɣɑ mpɑ pɑɑ tí lʋm nɑ niŋ ɩsɩɩ hɑsɩ tɔ, nɑ pɑ mpɑɑ. Nɑ mpɑ pɑɑ luŋ ɑkulɑ nɑ pɑ́ nyɔɔ tɔ nɑ pɑ mpɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","Ḿpʋ́ɣʋ́ pɑ tɑɑ yǝlɑɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (300) tiwɑ lʋm ɩsɩɩ hɑsɩ. Pǝ kɑɑsɑ mpɑ ɩlɛnɑ pɛlɛ pɑ́ luŋ ɑkulɑ nɑ pɑ́ nyɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","Ntɛnɑ Tɑcɑɑ heeli Ketiyɔŋ sɩ: Yoolɑɑ ŋmʋnʋɣʋ nɩɩnʋwɑ wei ɩ tiwɑ lʋm tɔ mpɛ pɑ niŋ tɑɑ kɛ́ mɑɑ tʋ Mɑtiyɑŋ nyǝ́mɑ nɑ pɑ́ wɑɑsɩ Ɩsɛɣɛlɩ nyǝ́mɑ. Pǝ kɑɑsɑ mpɑ tɔ, pɑɑ wei ɩ́ mǝlɩ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","Ḿpʋ́ɣʋ́ Ketiyɔŋ sɩɩwɑ yǝlɑɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (300) ɩnɩ nɑ ɩ́ mʋ kpentɑɑ tɔɣɔnɑsɩ, nɑ pɑ tutuuŋ nɑ pɛlɛ pɑ́ mǝlɩ tǝyɑɣɑ. Nɑ Mɑtiyɑŋ nyǝ́mɑ nɑ́ɑ́ sikɑ tɛtɛkǝlɛ tɑɑ kɛ́ mpɛ pɑ pǝtɛɛ. ");
INSERT INTO dop_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Ketiyɔŋ kɛ ɑhoo ɑnɩ sɩ: Kʋlɩ nɑ ń tii Mɑtiyɑŋ nyǝ́mɑ tesikile tɑɑ. Mpi tɔ, mɑ tʋ-wɛɣɛ nyɑ́ niŋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","Ye sɔɣɔntʋ wɛ-ŋ nɑ tiiu, ɩlɛ n kpɛnnɑ nyɑ́ tǝmlɛ tʋ Pulɑ. ");
INSERT INTO dop_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","N kɑ́ nɩɩ pɑ kʋyɔɣɔtʋtʋ, ɩlɛnɑ pǝ́ sɔɔsɩ-ŋ ɑpɑlʋtʋ. Ntɛnɑ ɩ́ nɑ Pulɑ pɑ́ cɛŋ nɑ pɑ́ polo pɑ́ tɑlɑ tǝtɑŋlɛ kɑncɑɑlɑɣɑ nyǝntɛ. ");
INSERT INTO dop_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","Nɑ Mɑtiyɑŋ nyǝ́mɑ, nɑ Amɑleke nyǝ́mɑ, nɑ ilim tǝlɩɩlɛ tɔɔ tɔntɑɑ pilinɑ tɛtɛkǝlɛ tǝnɑ ɩsɩɩ kʋtoloŋ, nɑ pɑ yooyoonɑɑ nɑ́ɑ́ wɛ ɩsɩɩ lʋm nɔɣɔ kɑnyǝŋɑ, pɑ fɛɩ kɑlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","Ketiyɔŋ pɑ tɑlɑ mpʋ, ɩlɛ nɔɣɔlʋ kɛɛsǝɣɩ ɩ tɑɑpɑlʋ ntɛ́ toosee sɩ: Mɑ toosɑɑ kɛlɛ sɩ mɑ nɑ́ potopoto nɔɣɔlʋ nɑ ɩ́ pilimiɣi tɑ́ tesikile nɑ ɩ́ yoonɑ cokǝle nɑ ɩ́ pǝsɩ-tɛɣɛ kpɛntǝlɑsɩ. ");
INSERT INTO dop_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","Mpʋɣʋlɛ ɩ tɑɑpɑlʋ nɔɣɔ tǝkpɑʋ sɩ: Ɩsǝnɑ Ɩsɛɣɛlɩ tʋ Ketiyɔŋ kɑ́ kǝlɩ-tʋ tɔɣɔ n nɑ mpʋ. Ɩsɔ tɛmɑ ɩ tɑɑ kɛ́ sɩ ɩ tʋɣɩ tɑ́ tǝnɑɣɑ ɩ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","Ketiyɔŋ nɩɩ toosee ɑnɩ ɑ kʋsɛɣɛsǝtʋ, ɩlɛnɑ ɩ́ hǝntɩ ɑtɛ nɑ ɩ́ sɛɛ Ɩsɔ. Ɩlɛnɑ ɩ́ mǝlɩ ɩ yoolɑɑ kiŋ nɑ ɩ́ tɔ sɩ: Ɩ́ nyǝkɩ nɑ ɩ́ kʋlɩ. Tɑcɑɑ tʋwɑ Mɑtiyɑŋ nyǝ́mɑ kɛ mǝ niŋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","Ḿpʋ́ɣʋ́ Ketiyɔŋ fɑɣɑ yoolɑɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (300) ɩnǝɣɩ kpekɑ tooso, nɑ ɩ́ cɛlɑ-wɛɣɛ tutuuŋ nɑ hɛɛŋ sɩ pɑ́ pɑ kɑhulɑsɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","Ɩlɛnɑ ɩ́ tɔ-wɛ sɩ: Ɩ́ nyǝnǝɣǝnɑ-m yoo. Ye tǝ tɑlɑ pɑ tǝsikile nɑ mɑ́ lɑpɑ ɩsǝnɑ mpi ɩlɛ ɩ́ lɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","Ye ɩ́ nɩɩwɑ mɑ́ nɑ mɑ hɔɣɔlʋɣʋ nyǝ́mɑ tǝ hʋlɑ tɑ́ tutuuŋ, ɩlɛ mɩɩ hʋlɩ mǝ nyǝŋ tɔtɔ nɑ pǝ́ cɔɔ nɑ pǝ́ tɑ. Nɑ ɩ́ kpɛntɩ nɑ ɩ yɔɣɔtǝnɑ nɔɣɔ sɔsɑɣɑ sɩ: Tɑcɑɑ nɑ Ketiyɔŋ pɑ nyǝ́mɑ ntɛ́ tɑ́. ");
INSERT INTO dop_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","Pǝ tɑpɑ ɑhoo hɛkɑ kɛ wɑɑtʋ wei tɑŋlɑɑ lɑɣɑsǝɣɩ tǝmɑ ɩlɛ Ketiyɔŋ nɑ ɩ yoolɑɑ nɩɩnʋwɑ (100) kpekǝle, pɑ tɑlɑ kolontunɑɑ tǝsikile tǝnɑɣɑ tɔɔ kɛlɛ. Ɩlɛnɑ pɑ́ hʋlɩ pɑ tutuuŋ nɑ pɑ́ yɔkɩ pɑ hɛɛŋ. ");
INSERT INTO dop_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","Ḿpʋ́ɣʋ́ kpekɑ nɑɑlɛ wei pǝ kɑɑsɑɑ tɔ, ɩ́lɛ́ ɩ lɑpɑ mpʋ tɔtɔ, nɑ pɑ́ tɔkɩ kɑhulɑsɩ nɑ niŋ mpǝtǝŋ nɑ tutuuŋ kɛ niŋ ntɔɣɔŋ tɑɑ, nɑ pɑ́ yɔɣɔtǝnɑ nɔɣɔ sɔsɑɣɑ sɩ: Tɑcɑɑ nɑ Ketiyɔŋ pɑɑ tɔɣɔnɑ. ");
INSERT INTO dop_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","22","Ḿpʋ́ɣʋ́ pɑ tǝnɑ pɑ tɑmɑ kolontunɑɑ tǝsikile nɑ pɑ́ sǝŋɑ pɑ tǝsǝŋlɛnɑɑ kɛ mpʋ, nɑ pɑ́ tɔŋnɑ tutuuŋ hʋlʋɣʋ. Ɩlɛnɑ Tɑcɑɑ lɑ́ nɑ ɑcufu sʋʋ Mɑtiyɑŋ nyǝ́mɑ yoolɑɑ tɑɑ, nɑ pɑ́ sʋʋ kiisuɣu, nɑ pɑ́ kʋɣɩ tǝmɑɣɑ pɑ tɑɑ pɑ tike. Ḿpʋ́ɣʋ́ pɑ yɑwɑ nɑ pɑ́ se nɑ lɛlɑɑ mǝlǝnɑ Pɛtɩ-Sitɑ kɛ Seletɑ tɔɔ. Hɑlǝnɑ pɑ́ tɑlɑ timpi pɑ yɑɑ sɩ Apɛɛlɩ-Meholɑ kɛ Tɑpɑɑ cɔlɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","Ɩlɛnɑ pɑ́ yɑɑ Ɩsɛɣɛlɩ kpekɑ lɛnnɑ, Nɛfǝtɑli nyǝ́mɑ, nɑ Asɛɛ nyǝ́mɑ, nɑ Mɑnɑsee nyǝ́mɑ tǝnɑ nɑ pɑ́ tɔɣɔnɩ Mɑtiyɑŋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","Ḿpʋ́ɣʋ́ Ketiyɔŋ tilɑɑ nɑ pɑ́ heeli Ɩfǝlɑyim nyǝ́mɑ kɛ pɔɔŋ tɑɑ sɩ: Ɩ́ tii lɔŋ nɑ ɩ́ cɛ Mɑtiyɑŋ nyǝ́mɑ nɑ ɩ́ tɑŋ-wɛɣɛ Yɑɑtɑnɩ tǝtɛsǝlɛ hɑlǝnɑ Pɛtɩ-Pɑlɑ. Ɩlɛnɑ Ɩfǝlɑyim nyǝ́mɑ nɑ́ɑ́ lɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","Ɩlɛnɑ pɑ́ kpɑ Mɑtiyɑŋ ɑwulɑɑ nɑɑlɛ Olɛpɩ nɑ Sɛpɩ. Nɑ pɑ́ kʋ Olɛpɩ kɛ Olɛpɩ kʋkpɑmʋɣʋ tɔɔ, nɑ pɑ́ kʋ Sɛpɩ ɩlɛɣɛ Sɛpɩ tǝnyɑɑsǝlɛ. Ɩlɛnɑ pɑ́ tɑɣɑnɩ kolontunɑɑ wɑɑlɩ kɛ tʋɣʋ. Ḿpʋ́ɣʋ́ pɑ ponɑ Ketiyɔŋ kɛ ɑwulɑɑ mpɛ pɑ nyɔɔŋ kɛ Yɑɑtɑnɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","Ḿpʋ́ɣʋ́ Ɩfǝlɑyim nyǝ́mɑ pɔɔsɑ Ketiyɔŋ nɑ pɑ́ɑ́nɑ́ sɩ: Wɑɑtʋ wei n pukɑɣɑ Mɑtiyɑŋ nyǝ́mɑ yoonɑʋ tɔ pǝ lɑpɑ ɩsǝnɑ nɑ ń tɑ yɑɑ-tʋ? Hɑlǝnɑ pɑ́ nɑ-ɩ pɑ́ yoo tǝ tɔɔ kɛ́ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","Mpʋɣʋlɛ ɩ pɔɔsɑ-wɛ sɩ: Pepe tɑɑ kɛ́ mɑ́ nɑ-mɛ tǝ kɛɛsǝɣɩ? Tʋɣʋ pee kɑncɑɑlɑɣɑ nyǝnɑ ɩɩ tɑkɩ leleŋ kɛ kɑntǝkɑɣɑ nyǝnɑ. Pǝ tɑpʋɣʋ ntɛ́ sɩ: Mpi mɩɩ lɑpɑ tɔ, pǝ tɛɛ mpi tɑ́ lɑpɑ tɔ tǝcɑɣɑcɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","Ɩsɔ yelɑɑ nɑ ɩ́ kʋ Mɑtiyɑŋ ɑwulɑɑ Olɛpɩ nɑ Sɛpɩ. Mpʋ tɔ, pepe tɑɑ kɛ́ mɑ́ nɑ-mɛ tǝ kɛɛsǝɣɩ? Ketiyɔŋ yɔɣɔtɑ mpʋ, ɩlɛnɑ Ɩfǝlɑyim nyǝ́mɑ pɑ́ɑ́nɑ́ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","Ḿpʋ́ɣʋ́ Ketiyɔŋ pɑ tɛsɑ Yɑɑtɑnɩ nɑ pɑ́ kɑwɑ tǝtɔɣɔtɔɣɔ. Pɑɑ nɑ mpʋ nɑ pɑ́ tɑɣɑnɩ pɑ kolontunɑɑ wɑɑlɩ kɛ tʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","Pɑ tɑlɑ Sukɔtɩ, ɩlɛnɑ Ketiyɔŋ tɔ ɩcɑtɛ nyǝ́mɑ sɩ: Ɩ́ hɑ mɑ yoolɑɑ kɛ tɔɣɔnɑɣɑ, pǝ nɩɩ-wɛɣɛ. Mpi tɔ, tǝ tɔŋnɑ Mɑtiyɑŋ ɑwulɑɑ Sepɑ nɑ Sɑlǝmunɑ kɛ tɔɣɔnʋɣʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","Mpʋɣʋlɛ ɩcɑtɛ nyʋɣʋ nyǝ́mɑ pɔɔsɑ-ɩ sɩ: Pepe tɔɔ kɛ́ n cɑɑ sɩ tǝ́ cɛlɛ-ŋ tɔɣɔnɑɣɑ nɑ ń tɑ kpɑtɑ Sepɑ nɑ Sɑlǝmunɑ? ");
INSERT INTO dop_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","Tǝnɑɣɑlɛ Ketiyɔŋ nɔɣɔ tǝkpɑʋ sɩ: Tɑcɑɑ ɩ́ tʋwɑ Sepɑ nɑ Sɑlǝmunɑ kɛ mɑ niŋ tɑɑ, mɑɑ cǝlɩ-mɛ nɑ wʋlɑɣɑ tɛtʋ tɑɑ sɔwɑ nɑ sɔsɔʋnɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","Ɩlɛnɑ pɑ́ tɛɛnɑ Penuwɛlɩ, nɑ Ketiyɔŋ sǝlǝmɩ kʋlʋmtʋ ntǝɣɩ ɩcɑtɛ nyǝ́mɑ, nɑ pɛlɛ pɑ́ cɔ-ɩ teitei ɩsɩɩ Sukɔtɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","Ḿpʋ́ɣʋ́ Ketiyɔŋ heelɑ-wɛ sɩ: Ye mɑ lɑpɑ ɑkɑ nɑ mɑ́ mǝlɑɑ, mɑɑ yɔkɩ mǝ ɩcɑtɛ tɑɑ ɑtɛ nɑ ɩsɔ kutuluɣu sɔsɔɔʋ. ");
INSERT INTO dop_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","Sepɑ nɑ Sɑlǝmunɑ pɑ yoolɑɑ pɑɑ wɛ Kɑlǝkɔɔ, nɑ pǝ́ kɑɑsɑ-wɛɣɛ iyisi nɑɑnʋwɑ nɑ kɑkpɑsɩ (15000). Ɩsǝnɑ pɩɩ kɑɑsɑ ilim tǝlɩɩlɛ tɔntɑɑ tɔɣɔlɛ. Mpi tɔ, Ketiyɔŋwɛ pɑ tɛmɑ yǝlɑɑ iyisi nɩɩnʋwɑ nɑ hiu (120000) kɛ kʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","Ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛlɩ mpɑɑʋ ŋku ilim tǝlɩɩlɛ tɔntɑɑ tǝŋǝɣɩ tɔɣɔ Nopɑ nɑ Yopowɑ pǝ ilim tǝlɩɩlɛ tɔɔ, nɑ pɑ́ kpǝlɩ pɑ kolontunɑɑ. Pǝ́cɔ́ pɛlɛ pɑɑ nyǝ́mɑ sɩ pɑ lɩɩ-tǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","Ɩlɛnɑ Mɑtiyɑŋ ɑwulɑɑ Sepɑ nɑ Sɑlǝmunɑ pɑ́ se. Amɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɣɔnɑ-wɛ nɑ pɑ́ kpɑ-wɛ nɑ kolontunɑɑ kpekǝle tǝnɑ lɑŋɑ pǝsɩ. ");
INSERT INTO dop_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","Ketiyɔŋ pɑ lɩɩnɑ yoou nɑ pɑ́ kpeŋ, ɩlɛnɑ pɑ́ kpɑɣɑ Hɛlɛsɩ ɩkpɑkpɑʋ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","Ḿpʋ́ɣʋ́ ɩ kpɑ Sukɔtɩ ɩfepu nɔɣɔlʋ nɑ ɩ́ pɔɔsɩ-ɩ, ɩlɛnɑ ɩ́lɛ́ ɩ́ ŋmɑɑ-ɩ ɩcɑtɛ ńtɛ́ tǝ nyʋɣʋ nyǝ́mɑ hǝlɑ. Pɑ wɛ yǝlɑɑ nɩɩtoso nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","Pǝ wɑɑlɩ kɛ́ Ketiyɔŋ polɑɑ nɑ ɩ́ mɑɣɑnɑ Sukɔtɩ nyǝ́mɑ nɑ ɩ́ tɔ-wɛ sɩ: Ɩ́ tɔɔsɩ nti ɩ́ kɑ tʋʋ-m sɩ pɑɑ pǝ nɩɩ mɑ yoolɑɑ ɩ́ kɑɑ hɑ-wɛɣɛ tɔɣɔnɑɣɑ sɩ mɑ tɑ kpɑtɑ Sepɑ nɑ Sɑlǝmunɑ tɔ. Tɔʋ, mpɛɣɛlɔ mɑ kpɑ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","Ɩlɛnɑ ɩ́ cɑɑ wʋlɑɣɑ tɛtʋ tɑɑ sɔwɑ nɑ sɔsɔʋnɑɑ nɑ ɩ́ hɔnɑ Sukɔtɩ nyʋɣʋ nyǝ́mɑ ŋkpɑŋŋ. ");
INSERT INTO dop_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","Ɩlɛnɑ ɩ́ yɔkɩ Penuwɛlɩ ɩcɑtɛ tɑɑ ɑtɛ nɑ ɩsɔ kutuluɣu nɑ ɩ́ kʋ́ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","Pǝ wɑɑlɩ kɛ́ Ketiyɔŋ pɔɔsɑ Sepɑ nɑ Sɑlǝmunɑ sɩ: Yǝlɑɑ mpɑ pɑ kʋwɑ Nɑpɔɔ tɔ pɑ wɛ ɩsǝnɑ tɔɔ? Ɩlɛnɑ pɑ́ cɔ sɩ: Pɑ nǝɣǝsǝnɑ-ŋ kɛ́. Pɑ cɑɣɑ kɛ́ ɩsɩɩ wulɑʋ piyɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","Mpʋɣʋlɛ Ketiyɔŋ sɩ: Mɑ tɑɑlʋnɑɑ kɛ́, mɑ nɑ-wɛ tɑ too kʋlʋm. Mɑ tuukinɑ Tɑcɑɑ sɩ ye ɩ́ tɑɑ kʋ́ mpɛ ɩnɩ, mɑ mɑɣɑmɑɣɑ mɑ tɑɑ kʋ-mɛ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","Ɩlɛnɑ ɩ́ tɔ ɩ pǝyɑlʋ kɑncɑɑlɑɣɑ nyǝŋ Yetɛɛ sɩ: Polo ń kʋ-wɛ. Amɑ pǝyɑɣɑ tɑ pǝsɩ nɑ kɑ́ kʋsɩ kɑ lɑɣɑtɛ. Mpi tɔ, kɑɑ kǝlɑ kɔɔsʋɣʋ, ɩlɛnɑ sɔɣɔntʋ wɛ-kɛ. ");
INSERT INTO dop_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","Ntɛnɑ Sepɑ nɑ Sɑlǝmunɑ pɑ́ tɔ Ketiyɔŋ sɩ: Kʋ-tʋɣʋ nyɑ́ mɑɣɑmɑɣɑ, yʋlʋkpɑsʋ tǝmlɛ kɛ́. Ḿpʋ́ɣʋ́ Ketiyɔŋ kʋwɑ ɑwulɑɑ mpɛ pɑ nɑɑlɛ, nɑ ɩ́ wɔɣɔsɩ pɑ yooyoonɑɑ luuŋ tɛɛ kɑwulɑɣɑ wʋlɑ tǝlɑnɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɔmɑ Ketiyɔŋ sɩ: Tɔɣɔ tɑ́ tɔɔ kɛ́ kɑwulɑɣɑ, nyɑ́ wɑɑlɩ kɛ́ nyɑ́ piyɑ nɑ pɛlɛ pɑ piyɑ. Mpi tɔ, nyɑ́ yɑpǝnɑ-tʋɣʋ Mɑtiyɑŋ nyǝ́mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","Ntɛnɑ Ketiyɔŋ sɩ: Aɑɩ, pǝ tɑɣɑ mɑ́ yɑɑ mɑ pǝyɑɣɑ nɑkǝlɩ kɑɑ tɔɣɔnɑ mǝ tɔɔ kɛ́ kɑwulɑɣɑ. Amɑ Tɑcɑɑ kɛlɛ mǝ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","Ɩlɛ nti mɑ sǝlǝmǝɣɩ-mɛ tɔɣɔlɛ sɩ pɑɑ mǝ tɑɑ wei ɩ́ hɑ-m kukuule nte ɩ hikɑ kolontunɑɑ tɛ tɔ. Mɑtiyɑŋ nyǝ́mɑ kɑ kɛ́ Ɩsǝmɑyɛlɩ nyǝ́mɑ, ɩlɛ pɑɑ wɛnɑ kukuwee kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","Ɩlɛnɑ pɑ́ tisi sɩ pɑɑ cɛlɛ-ɩ nɑ luɣu kʋlʋmʋɣʋ. Ḿpʋ́ɣʋ́ Ketiyɔŋ pɔwɑ toko nɑ pɑ́ pɛtǝɣɩ pɑ ŋkpɑŋyɑpǝlɑsɩ nsǝɣɩ pǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","Nɑ kukuwee ɑnɩ ɑ́ lɩɩ ɩsɩɩ kiloonɑɑ hiu. Nɑ pǝ́cɔ́ pǝ́ kɑɑsɩ kɑcɔkɑ kukuwee ɩsɩɩ ŋkpɑŋyɑpǝlɑsɩ, nɑ tokonɑɑ kʋsɛɛmɑɑ kʋpɑmɑ mpɑ Mɑtiyɑŋ ɑwulɑɑ suukɑɣɑ tɔ, nɑ pɑ yooyoonɑɑ tǝlɑnɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","Ɩlɛnɑ Ketiyɔŋ lʋʋ kɔtǝlɑɑ toko wei pɑ pɔɔsǝɣǝnɑ Tɑcɑɑ kɛ tɔm tɔ nɑ ɩ́ tʋ́ wʋlɑnɑɑ mpɛɣɛ ɩ tɔɔ, nɑ ɩ́ sɩɩ Ofǝlɑ ɩcɑtɛ tɑɑ. Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ sʋʋ toko ɩnǝɣɩ lɑɑʋ nɑ ɩ́ pǝsɩ Ketiyɔŋ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ kɛ kɑtɔkɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","Pǝ kpɑɣɑʋ wɑɑtʋ ɩnɩ tɔɣɔ Ɩsɛɣɛlɩ nyǝ́mɑ ŋmɑkǝlɑ Mɑtiyɑŋ nyǝ́mɑ, pɑ tɑ tɑsɑ pɑ tǝɣɩ hikuɣu. Ɩlɛnɑ tɛtʋ hɛɛsɩ pɩɩsɩ nɩɩlɛ tǝcu. Hɑlǝnɑ Ketiyɔŋ nɑ ɩ sǝm. ");
INSERT INTO dop_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","Ḿpʋ́ɣʋ́ Ketiyɔŋ mǝlɑ ɩ tɛ nɑ ɩ́ cɑɣɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","Ɩ pǝyɑlɑɑ kɑ wɛ nɩɩtoso nɑ nɑɑnʋwɑ kɛ́. Mpi tɔ, ɩ kɑ wɛnɑ ɑlɑɑ pɑɣɑlɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","Ɩ ɑlʋ sǝkpelu nyǝŋ wei ɩ kɑ wɛ Sikɛm tɔ ɩ lʋlɑ-ɩ ɑpɑlʋpǝyɑɣɑ, pɑ yɑɑ-kɛ sɩ Apimelɛkɩ. ");
INSERT INTO dop_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","Kpɑtǝlɑɣɑ kʋpɑŋkɑ kɛ Ketiyɔŋ sǝpǝnɑɑ nɑ pɑ́ pimi-ɩ ɩ cɔsɔ sɔsɔ Apiyesɛɛ pǝlɑɑʋ tɑɑ kɛ timpi pɑɑ pimɑ ɩ cɑɑ Yowɑsɩ tɔɣɔ Ofǝlɑ ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","Ketiyɔŋ sǝpɑ mpʋ, ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɣɑnɩ tɩɩŋ lɑɑʋ tɑɑ kɛ́ mǝlʋɣʋ, nɑ pɑ́ lɑɑkɩ pɑ tʋɣʋ ŋku pɑ yɑɑ sɩ Pɑɑlɩ-Poli tɔ. ");
INSERT INTO dop_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","Pɑ tɑ tɔɔsɩ pɑ Ɩsɔ wei ɩ yɑpɑ-wɛɣɛ kolontunɑɑ mpɑ pɑ cɔɔnɑ-wɛ tɔ pɑ niŋ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","Pɑɑ nɑ Ketiyɔŋ kɑ lʋpɑ pɑ tɔɔ kɛ́ teu tɔ, pɑ tɑɑ nɔɣɔlʋ tɑ tɔɔsɩ ɩ tǝyɑɣɑ nyǝ́mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","Ḿpʋ́ɣʋ́ Ketiyɔŋ pǝyɑlʋ Apimelɛkɩ polɑ ɩ ɩkpenɑɑ kɛ Sikɛm nɑ ɩ́ tɔ pɑ́ nɑ ɩ too lʋlʋɣʋ nyǝ́mɑ tǝnɑ sɩ, ");
INSERT INTO dop_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","pɑ́ pɔɔsɩ ɩcɑtɛ nyǝ́mɑ sɩ: Ɩ́ cɑɑ sɩ Ketiyɔŋ piyɑ nɩɩtoso nɑ nɑɑnʋwɑ ɩ́ tɔɣɔnɑ mǝ tɔɔ kɛ́ kɑwulɑɣɑ yɑɑ yʋlʋ kʋlʋm? Ɩlɛ ɩ́ tɔɔsɩ sɩ mɑɣɑlɛ mǝ kɔɣɔpu. ");
INSERT INTO dop_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","Ntɛnɑ ɩ ɩkpenɑɑ polo nɑ pɑ́ heeli tɔm ntǝɣɩ Sikɛm ɩcɑtɛ nyʋɣʋ nyǝ́mɑ. Ɩlɛnɑ pɛlɛ pɑ́ tʋ pɑ tɑɑ sɩ pɑɑ sɛɛnɑ ɩ tɔɔ. Mpi tɔ, ɩ kɛ́ pɑ yʋlʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","Ɩlɛnɑ pɑ́ lǝsɩ pɑ tʋɣʋ ŋku pɑ yɑɑ sɩ Pɑɑlɩ-Peli tɔ kʋ kutuluɣu tɑɑ kɛ́ liɣitee nyǝɣǝtʋ nɩɩtoso nɑ nɑɑnʋwɑ nɑ pɑ́ hɑ-ɩ. Anǝɣɩ ɩ fɛlɑ tɛtɛlɑtɑɑ, nɑ mʋsʋŋtʋnɑɑ, nɑ pɑ́ tʋ́ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","Ɩlɛnɑ pɑ́ polo ɩ cɑɑ tɛɣɛ Ofǝlɑ, nɑ ɩ́ kʋ́ ɩ tɛɛtʋnɑɑ nɩɩtoso nɑ nɑɑnʋwɑ ɩnɩ ɩ tǝnɑɣɑ kʋkpɑmʋɣʋ kʋlʋmʋɣʋ tɔɔ. Pɑ tɑɑ sǝkpelu kʋlʋm Yotɑm tike senɑ nɑ ɩ́ ŋmɛlɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","Ɩlɛnɑ Sikɛm nɑ yoolɑɑ tɛ yǝlɑɑ tǝnɑ koti nɑ pɑ́ polo ɩcɑtɛ tʋɣʋ kʋlɑlɑɑʋ tɛɛ, nɑ pɑ́ kpɑɑlɩ sɩ Apimelɛkɩ pǝsɑ wulɑʋ yoo. ");
INSERT INTO dop_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","Yotɑm nɩɩ mpʋ, ɩlɛnɑ ɩ́ kpɑ pʋɣʋ Kɑlisim nyʋɣʋ tɑɑ nɑ ɩ́ kiisi sɩ: Sikɛm nyǝ́mɑ mɛ, ye ɩ́ cɑɑkɩ sɩ Ɩsɔ ɩ́ nɩɩnɑ-mɛ, ɩlɛ ɩ́ ke ŋkpɑŋŋ. ");
INSERT INTO dop_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","Kʋyɑkʋ nɑkʋlǝɣɩ tɩɩŋ tʋwɑ sɩ ɩ kpɑɑkɩ wulɑʋ. Ɩlɛnɑ ɩ́ tɔ tʋɣʋ ŋku pɑ yɑɑ sɩ Olifi tɔ sɩ: Tɩɩ kpɑ-ŋ tɑ́ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","Tǝnɑɣɑlɛ Olifi tɔmɑ ɩ tɑɑpɑlɑɑ sɩ: Mɑ yeki nim mʋlʋɣʋ ntɛ́ nɑ Ɩsɔ nɑ yǝlɑɑ pɑ lɑŋɑ hɛɛnɑ-m ɩlɛnɑ mɑ́ kʋɣɩ mɑ tɩ sɩ mɑ tɔkɩ tɩɩŋ tɔɔ kɛ́ kɑwulɑɣɑ nɑ? ");
INSERT INTO dop_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","Mpʋɣʋlɛ tɩɩŋ yɑɑ ŋku pɑ yɑɑ sɩ fiki tɔ sɩ: Kɔɔ nɑ tǝ́ kpɑ-ŋ tɑ́ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","Tǝnɑɣɑlɛ fiki sɩ: Mɑ yeki mɑ pee leleŋ nyǝnɑ ɑnǝɣɩ lʋlʋɣʋ ntɛnɑ mɑ́ kʋɣʋ mɑ tɩ sɩ mɑ tɔkɩ tɩɩŋ tɔɔ kɛ́ kɑwulɑɣɑ nɑ? ");
INSERT INTO dop_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","Ɩlɛnɑ ɩ́ yɑɑ tʋɣʋ ŋku pɑ yɑɑ sɩ lɛsɛŋ tɔ sɩ: Nyɑɑ kɔɔ nɑ tǝ́ kpɑ-ŋ tɑ́ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","Ntɛnɑ kʋlɛ kʋ cɔ sɩ: Mɑ yeki sʋlʋm puuu ntɛ́ sɩ Ɩsɔ nɑ yǝlɑɑ pɑ́ yɔɔlǝnɑ-m, ɩlɛnɑ mɑ́ kʋɣʋ mɑ tǝɣɩ yem sɩ mɑ tɔkɩ tɩɩŋ tɔɔ kɛ́ kɑwulɑɣɑ nɑ? ");
INSERT INTO dop_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","Pǝ wɑɑlɩ kɛ́ tɩɩŋ tǝnɑ kpɛntɑɑ nɑ ɩ́ mɑɣɑnɑ sɔwɑ hotiyɑ nɑ ɩ́ tɔ́-kɛ́ sɩ: Kɔɔ nɑ tǝ́ kpɑ-ŋ tɑ́ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","Ntɛnɑ sɔwɑ hotiyɑ tɔ-wɛ sɩ: Ye tɑmpɑnɑ sɩ ɩ́ cɑɑ mɑ́ lɑ mǝ wulɑʋ, ɩ́ kɔɔ nɑ ɩ́ cɔɔsɩ mǝ tǝnɑɣɑ mɑ ɩsotom tɑɑ. Ye pǝ tɑɣɑ mpʋ kɔkɔ kɑ́ lɩɩnɑ mɑ sɔwɑ tɑɑ, nɑ kɑ́ nyɑɣɑ nɑ kɑ́ kpɛntǝnɑ Lipɑŋ tɩɩŋ sɔsɔɔŋ. ");
INSERT INTO dop_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","Ḿpʋ́ɣʋ́ Yotɑm tɑsɑɑ sɩ: Ɩsɩɩ mǝ kpɑɑlʋɣʋ sɩ Apimelɛkɩ kɛlɛ mǝ wulɑʋ tɔ tɑmpɑnɑ ntɛ́? Ketiyɔŋ lɑpɑ-mɛɣɛ tǝmɑ sɔsɔɔnɑ wenɑ tɔ ɩ́ tɔɔsɑ ɑ tɔɔ nɑ ɩ́ lɑ ɩ́ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ kɛ kʋpɑntʋ nɑ? ");
INSERT INTO dop_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","Mɑ cɑɑ yoo mǝ yoou nɑ ɩ́ sɩ mǝ sǝm nɑ ɩ́ wɑɑsɩ-mɛɣɛ Mɑtiyɑŋ nyǝ́mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","Ɩlɛnɑ sɑŋɑ mɩɩ lɩɩ ɩ nyǝ́mɑ wɑɑlɩ, hɑlǝnɑ ɩ́ kʋ́ ɩ piyɑ nɩɩtoso nɑ nɑɑnʋwɑ kɛ kʋkpɑmʋɣʋ kʋlʋmʋɣʋ tɔɔ. Ɩlɛnɑ ɩ́ kpɑ Apimelɛkɩ kɛ Sikɛm wulɑʋ sɩ ɩ́lɛ́ ɩ kɛ́ mǝ kɔɣɔpu. Pǝ́cɔ́ Ketiyɔŋ yom ɑlʋ nyǝŋ pǝyɑɣɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","Amɑ ye kʋpɑntʋ kɛ ɩ lɑpɑ Ketiyɔŋ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ, ɩlɛ Apimelɛkɩ ɩ́ hɛɛsɩ mǝ lɑŋɑ nɑ mɩɩ hɛɛsɩ ɩ nyǝntɛ. ");
INSERT INTO dop_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","Ye pǝ tɑɣɑ mpʋ kɔkɔ ɩ́ lɩɩnɑ Apimelɛkɩ tɑɑ nɑ kɑ́ nyɑɣɑ Sikɛm nɑ yoolɑɑ tɛ yǝlɑɑ, nɑ kɔkɔ lɩɩ pɛlɛ pɑ kiŋ nɑ kɑ́ nyɑɣɑ Apimelɛkɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","Yotɑm tɛmɑ mpʋ, ɩlɛnɑ ɩ́ se ɩ tɛɛtʋ Apimelɛkɩ nɑ ɩ́ polo ɩ́ ŋmɛlɩ Peelɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","Apimelɛkɩ tɔɣɔ kɑwulɑɣɑ kɛ Ɩsɛɣɛlɩ kɛ pɩɩsɩ tooso. ");
INSERT INTO dop_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","Pǝ wɑɑlɩ kɛ́ Ɩsɔ yelɑɑ nɑ Sikɛm nyǝ́mɑ tɑɑ kpɛntǝnɑ tǝmɑ. Ɩlɛnɑ Sikɛm nyǝ́mɑ kʋlɩ Apimelɛkɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","Pǝ lɑpɑ ḿpʋ́ɣʋ́ sɩ ɩ tɛɛtʋnɑɑ mpɑ Sikɛm nyǝ́mɑ kɑ sǝnɑ-ɩ nɑ pɑ́ kʋ tɔ, pɑ sǝm ɩ́ mǝlɩ ɩ́ nɑ-wɛ pɑ nyɔɔŋ tɑɑ, nɑ pǝ́ lɛɛtɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_25","008_9_25","JDG","9","25","25","Pɑ cɑɑkɑɣɑ sɩ pɑ́ hiki Apimelɛkɩ, ɩlɛnɑ pɑ́ ponɑ yǝlɑɑ kɛ pulɑsɩ tɑɑ nɑ pɑ́ pɑpɩ tǝnɑ, nɑ mpɑɑʋ tɔntʋ wei ɩ́ tɛɛkɩ, ɩlɛ pɑ lɛɛkɩ ɩ wontu. Ḿpʋ́ɣʋ́ wulɑʋ nɩɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_26","008_9_26","JDG","9","26","26","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Ɩpɛtɩ pǝyɑlʋ Kɑɑlɩ nɑ ɩ tɛɛtʋnɑɑ pɑ polɑ Sikɛm, nɑ ɩcɑtɛ nyǝ́mɑ lɑ-wɛɣɛ nɑɑni. ");
INSERT INTO dop_vpl VALUES ("JG9_27","008_9_27","JDG","9","27","27","Ɩlɛnɑ pɑ́ polo pɑ́ kóólí tɩɩŋ wei pɑ yɑɑ sɩ lɛsɛŋnɑɑ tɔ nɑ pɑ́ lɑ́ pǝ sʋlʋm nɑ pɑ́ nyɔɔ, nɑ pɑ́ ŋmɑɑlɩ. Nɑ pɑ́ sʋʋ pɑ tʋɣʋ kutuluɣu tɑɑ, nɑ pɑ́ tɔɣɔ nɑ pɑ́ nyɔɔ tɔtɔ. Ɩlɛnɑ pɑ́ tʋʋ Apimelɛkɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_28","008_9_28","JDG","9","28","28","Hɑlǝnɑ Kɑɑlɩ tɔ sɩ mpɑɣɑ Sikɛm nyǝ́mɑ? Nɑ pepe tɔɔ kɛ́ tɩɩ nyɑnɑ Apimelɛkɩ? Awe nyǝmɑ-ɩ? Ntɔŋ Ketiyɔŋ pǝyɑlʋ kɛlɛ? Sepuli kɛlɛ ɩcɑtɛ nyʋɣʋ tʋ, tɑ kɑɑ nɩɩnɑ-ɩ. Mǝ cɔsɔ Hɑmoo wei ɩ kɛ́ mǝ kpekǝle nyʋɣʋ tʋ tɔɣɔ pǝ wɛɛ sɩ ɩ́ se. ");
INSERT INTO dop_vpl VALUES ("JG9_29","008_9_29","JDG","9","29","29","Ye mɑɑ kɛnɑ ɩcɑtɛ nyʋɣʋ tʋ, mɑɑ tɔɣɔnɑ Apimelɛkɩ kɛ́. Apimelɛkɩ ɩ́ tɑɣɑnɩ ɩ yoolɑɑ nɑ ɩ́ kɔnɑ nɑ mɑ nɑ-wɛ tǝ yoo. ");
INSERT INTO dop_vpl VALUES ("JG9_30","008_9_30","JDG","9","30","30","Ɩcɑtɛ nyʋɣʋ tʋ Sepuli nɩɩ Kɑɑlɩ tɔm ntɩ, ɩlɛnɑ ɩ pɑ́ɑ́nɑ́ huu. ");
INSERT INTO dop_vpl VALUES ("JG9_31","008_9_31","JDG","9","31","31","Nɑ ɩ́ tili mukɑɣɑ nɑ ɩ́ heeli Apimelɛkɩ sɩ: Kɑɑlɩ nɑ ɩ tɛɛtʋnɑɑ pɑ kɔmɑ Sikɛm nɑ pɑ́ yoosiɣi nyɑ́ nɑ ɩcɑtɛ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_32","008_9_32","JDG","9","32","32","Mpʋ tɔ, pǝ wɛɛ sɩ nyɑ́ nɑ nyɑ́ yǝlɑɑ ɩ́ polo ɑhoo nɑ ɩ́ pɑpɩ-ɩ tɑwɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_33","008_9_33","JDG","9","33","33","Nɑ cele tɑnɑŋ ɩ́ tii ɩcɑtɛ tɔɔ kɛ́ ilim lɩɩʋ wɑɑtʋ, nɑ ɩ́ nɑ ɩ nyǝ́mɑ pɑ́ lɩɩkɩ nyɑ́ tɔɔ, ɩlɛnɑ ń nyɩ ɩsǝnɑ ń kɑ́ lɑnɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG9_34","008_9_34","JDG","9","34","34","Ḿpʋ́ɣʋ́ Apimelɛkɩ fɑɣɑ ɩ yǝlɑɑ kɛ tɔm liɣiti nɑ pɑ́ polo pɑ́ pɑpɩ Sikɛm ɩcɑtɛ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_35","008_9_35","JDG","9","35","35","Wɑɑtʋ wei Kɑɑlɩ lɩɩwɑ nɑ ɩ́ sǝŋ ɩcɑtɛ nɔnɔɣɔ, ɩlɛnɑ Apimelɛkɩ nɑ ɩ yǝlɑɑ pɑ́ lɩɩ tǝŋmɛllɛ. ");
INSERT INTO dop_vpl VALUES ("JG9_36","008_9_36","JDG","9","36","36","Kɑɑlɩ nɑ-wɛ, ɩlɛnɑ ɩ́ heeli Sepuli sɩ: Nyǝnɩ, yǝlɑɑ wɑtʋɣʋ pulɑɣɑ nɑ pɑ́ tiiki yee. Ntɛnɑ Sepuli nɔɣɔ tǝkpɑʋ sɩ: Pulɑɣɑ ɩsotom kɛ n yɑɑ sɩ yǝlɑɑ nɑ? ");
INSERT INTO dop_vpl VALUES ("JG9_37","008_9_37","JDG","9","37","37","Kɑɑlɩ tɑ tisi, ɩlɛnɑ ɩ́ tɔ sɩ: Nyǝnɩ, yǝlɑɑ tiikinɑ nɑ hɛkʋ tɑɑ pulɑɣɑ tɔɔ. Nɑ tintiɣile lɛntɛ nɑ́ tɛsǝɣɩ pee pɔɔsǝlɑɑ tʋɣʋ kʋlɑlɑɑʋ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG9_38","008_9_38","JDG","9","38","38","Ɩlɛnɑ Sepuli tɔ sɩ: Tɑsɑ kpesuɣu ɩlɛ. Mɑtɔŋ n tɔŋɑɣɑ cǝnɛ sɩ: Aweɣe pɑ yɑɑ Apimelɛkɩ nɑ tɑ́ɑ́ nɩɩkǝnɑ-ɩ? Tɔʋ, ɩ nɑ ɩ yǝlɑɑ mpɑ n tʋʋkɑɣɑ tɔ pɑ kɔŋnɑ ntɛ́. Polo nyɑ́ nɑ-ɩ ɩ́ yoo ɩlɛ. ");
INSERT INTO dop_vpl VALUES ("JG9_39","008_9_39","JDG","9","39","39","Mpʋɣʋlɛ Kɑɑlɩ tɛɛwɑ Sikɛm nyǝ́mɑ kɛ nɔɣɔ nɑ pɑ́ nɑ Apimelɛkɩ pɑ́ nɑɑlɩ yoou. ");
INSERT INTO dop_vpl VALUES ("JG9_40","008_9_40","JDG","9","40","40","Apimelɛkɩ sʋʋ ɩ tɛɛ, ɩlɛnɑ ɩnɩ ɩ́ kuu-tɛ nɑ pɑ́ tʋ tǝmɑ wɑɑlɩ, nɑ pǝ́ kʋ yǝlɑɑ kɛ sɔsɔm nɑ pǝ́cɔ́ pɑ́ tɑkɩ ɩcɑtɛ nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("JG9_41","008_9_41","JDG","9","41","41","Ɩlɛnɑ Apimelɛkɩ polo nɑ ɩ́ cɑɣɑ Alumɑ nɑ Sepuli nɑ́ɑ́ tɔɣɔnɩ Kɑɑlɩ nɑ ɩ tɛɛtʋnɑɑ sɩ pɑ́ tɑɑ mǝlɩ Sikɛm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_42","008_9_42","JDG","9","42","42","Tɛʋ femɑ, ɩlɛnɑ Sikɛm nyǝ́mɑ tɑɣɑnɩ pɑ tɩ sɩ pɑ puki tɑwɑ tɑɑ nɑ pɑ́ tɑɣɑsɩ-tǝɣɩ Apimelɛkɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_43","008_9_43","JDG","9","43","43","Ɩlɛnɑ ɩ́ fɑɣɑ ɩ yoolɑɑ kɛ kpekɑ tooso, nɑ pɑ́ pɑpɩ tǝnɑ. Wɑɑtʋ wei ɩ nɑ́ Sikɛm nyǝ́mɑ lɩɩ ɩcɑtɛ nɔnɔɣɔ, ɩlɛnɑ ɩ́ tii pɑ tɔɔ kɛ́ kpɑkpɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_44","008_9_44","JDG","9","44","44","Ntɛnɑ Apimelɛkɩ nɑ kpekǝle lɛntɛ pɑ́ polo nɑ pɑ́ tɑŋ ɩcɑtɛ nɔnɔɣɔ sɩ kolontunɑɑ ɩ́ mǝlɩ ɩcɑtɛ tɑɑ, nɑ kpekǝle nɑɑlɛ nyǝntɛ nɑ́ɑ́ nyɑlɑ yǝlɑɑ kɛ tɑwɑ tɑɑ, nɑ pɑ́ kʋ-wɛɣɛ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("JG9_45","008_9_45","JDG","9","45","45","Nɑ Apimelɛkɩ yoonɑ ɩcɑtɛ kɛ ilim nɑ pǝ tɛm, nɑ ɩ́ kʋ tǝ yǝlɑɑ, nɑ ɩ́ wɑkǝlɩ-tɛ nɑ ɩ́ lɛɛkɩ-tɛ. Ɩlɛnɑ ɩ́ ŋmɩɩsɩ tǝ tɑɑ kɛ́ tɔm. ");
INSERT INTO dop_vpl VALUES ("JG9_46","008_9_46","JDG","9","46","46","Wɑɑtʋ wei Sikɛm ɑtɛ nɑ ɩsɔ kutuluɣu yǝlɑɑ nɑ́ mpʋ, ɩlɛnɑ pɑ́ polo pɑ tǝnɑ nɑ pɑ́ sʋʋ tʋɣʋ Pɑɑlɩ-Peli koloŋɑ kutuluɣu tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_47","008_9_47","JDG","9","47","47","Ɩlɛnɑ Apimelɛkɩ nɩɩ sɩ pɑ polɑɑ nɑ pɑ́ ŋmɛlɩ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_48","008_9_48","JDG","9","48","48","Ḿpʋ́ɣʋ́ ɩ ponɑ ɩ yoolɑɑ kɛ Sɑlʋmɔŋ pulɑɣɑ tɔɔ, nɑ ɩ́ kpɑɣɑ lɑɑlɛ nɑ ɩ́ sɛtɩ tʋɣʋ piliŋɑ nɑ ɩ́ hɔɣɔlɩ-kɛ. Ɩlɛnɑ ɩ́ heeli-wɛ sɩ: Ɩ́ lɑ ɩsɩɩ mɑ lɑpʋ tɔɣɔ lɔŋ. ");
INSERT INTO dop_vpl VALUES ("JG9_49","008_9_49","JDG","9","49","49","Ɩlɛnɑ pɑɑ wei ɩ́ sɛtɩ ɩ piliŋɑ nɑ pɑ́ tʋ ɩ wɑɑlɩ nɑ pɑ́ ponɑ tɑɑsɩ nɑ pɑ́ kɑɑ tʋɣʋ kutuluɣu nɔɣɔ, nɑ pɑ́ tʋ kɔkɔ. Ɩsǝnɑ Sikɛm ɑtɛ nɑ ɩsɔ kutuluɣu yǝlɑɑ sǝpɑ tɔɣɔlɛ. Apɑlɑɑ nɑ ɑlɑɑ mpɑ pɑ sǝpɑ tǝnɑ tɔ pɑ tɑlɑ ɩsɩɩ yǝlɑɑ iyɑɣɑ (1000) kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("JG9_50","008_9_50","JDG","9","50","50","Apimelɛkɩ lɩɩ tǝnɑ, ɩlɛnɑ ɩ́ polo Tɛpɛɛsɩ ɩcɑtɛ nɑ ɩ́ nyɑlɑ-tɛ nɑ ɩ́ lɛɛkɩ-tɛ. ");
INSERT INTO dop_vpl VALUES ("JG9_51","008_9_51","JDG","9","51","51","Tǝ tɑɑ kɑ wɛ ɑtɛ nɑ ɩsɔ kutuluɣu toŋ nyǝŋkʋ nɑkʋlɩ. Ɩlɛnɑ ɩcɑtɛ ɑpɑlɑɑ nɑ ɑlɑɑ nɑ nyʋɣʋ nyǝ́mɑ polo nɑ pɑ́ sʋʋ kʋ tɑɑ nɑ pɑ́ tǝkɩ nɔnɔɣɔ, nɑ pɑ́ kpɑ nyʋɣʋ tɑɑ nɑ pɑ́ cɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JG9_52","008_9_52","JDG","9","52","52","Ḿpʋ́ɣʋ́ Apimelɛkɩ kpǝtǝnɑ kutuluɣu ŋkʋ kʋ nɔnɔɣɔ sɩ ɩ tʋɣʋ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("JG9_53","008_9_53","JDG","9","53","53","Ɩlɛnɑ ɑlʋ nɔɣɔlʋ ɩ yɑɣɑ ɩ nyʋɣʋ tɑɑ kɛ́ nem nɑ kʋ́ tʋlɩ. ");
INSERT INTO dop_vpl VALUES ("JG9_54","008_9_54","JDG","9","54","54","Mpʋɣʋlɛ ɩ tɔmɑ ɩ yoou wontu tɔkʋlʋ sɩ: Kpɛɛ nyɑ́ lɑɣɑtɛ nɑ ń tɛɛsɩ-m. Pɑ́ tɑɑ kɔɔ nɑ pɑ́ yɔɣɔtɩ sɩ ɑlʋ kʋnɑ-m. Ɩlɛnɑ ɩfepu ɩnɩ ɩ́lɛ́ ɩ sɔ Apimelɛkɩ kɛ lɑɣɑtɛ nɑ ɩ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("JG9_55","008_9_55","JDG","9","55","55","Ɩsɛɣɛlɩ nyǝ́mɑ nɑwɑ sɩ ɩ sǝpɑ. Ɩlɛnɑ pɑɑ wei ɩ́ mǝlɩ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("JG9_56","008_9_56","JDG","9","56","56","Ɩsǝnɑ Ɩsɔ fɛlǝnɑ Apimelɛkɩ kɛ ɩsɑɣɑtʋ nti ɩ lɑpɑ ɩ cɑɑ, nɑ ɩ́ kʋ ɩ tɛɛtʋnɑɑ nɩɩtoso nɑ nɑɑnʋwɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("JG9_57","008_9_57","JDG","9","57","57","Pǝyele Ɩsɔ yelɑɑ nɑ pǝ́ fɛlɩ Sikɛm nyǝ́mɑ kɛ pɑ ɩsɑɣɑtʋ kɛ teitei ɩsɩɩ Yotɑm kɑ tǝŋsʋɣʋ-wɛɣɛ mpusi tɔ. ");
INSERT INTO dop_vpl VALUES ("JG10_1","008_10_1","JDG","10","1","1","Apimelɛkɩ sǝpɑ, ɩlɛnɑ Ɩsɑkɑɑ kpekǝle tɑɑ tʋ Puwɑ pǝyɑlʋ Tolɑ nɑ́ɑ́ kʋlɩ. Toto sɑɑlɩ kɛlɛ. Tolɑ ɩnɩ ɩ wɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ. Sɑmii ɩcɑtɛ tɑɑ kɛ́ ɩ kɑ wɛ Ɩfǝlɑyim pɔɔŋ nyɔɔŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG10_2","008_10_2","JDG","10","2","2","Pɩɩsɩ hiu nɑ tooso tǝcu kɛ́ Tolɑ pɑɑsǝnɑ-wɛ. Ɩ sǝpɑ, ɩlɛnɑ pɑ́ pimi-ɩ Sɑmii ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG10_3","008_10_3","JDG","10","3","3","Ḿpʋ́ɣʋ́ Kɑlɑɑtɩ tʋ Yɑyii nɑ́ lɛɛtɑ Tolɑ lonte nɑ ɩ́ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɩɩsɩ hiu nɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("JG10_4","008_10_4","JDG","10","4","4","Ɩ pǝyɑlɑɑ kɑ wɛ yʋlʋ nyɔɔŋ hiu nɑ nɑɑnʋwɑ kɛ́. Pɑɑ wei nɑ ɩ kpɑŋɑɣɑ nɑ ɩ ɩcɑtɛ kɛ Kɑlɑɑtɩ hɔɣɔlʋɣʋ tɑɑ. Hɑlɩ pɑ tɔŋnɑ tǝnɑ-wɛɣɛ yɑɑʋ sɩ Yɑyii ɑcɑlɛɛ. ");
INSERT INTO dop_vpl VALUES ("JG10_5","008_10_5","JDG","10","5","5","Ɩ sǝpɑ ɩlɛnɑ pɑ́ pimi-ɩ Kɑmɔŋ ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG10_6","008_10_6","JDG","10","6","6","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɑsɑ lɑpʋ kɛ mpi pǝ tɑ mɑɣɑ Tɑcɑɑ tɔ. Pɑ sʋʋ Pɑɑlǝnɑɑ nɑ Asǝtɑtǝnɑɑ kɛ lɑɑʋ. Pɑ lɑɑ tɔtɔɣɔ Silii nyǝ́mɑ, nɑ Sitɔŋ nyǝ́mɑ, nɑ Mowɑpʋ nyǝ́mɑ, nɑ Amoni nyǝ́mɑ, nɑ Filiisi nyǝ́mɑ pɑ tɩɩŋ. Pɑ lɔwɑ Tɑcɑɑ kɛ́ tǝkpɑtɑɑ, pɑɑ tɑsǝɣɩ-ɩ seu. ");
INSERT INTO dop_vpl VALUES ("JG10_7","008_10_7","JDG","10","7","7","Ntɛnɑ Tɑcɑɑ mʋ-wɛ nɑ pɑ́ɑ́nɑ́ nɑ ɩ́ tʋ-wɛɣɛ Filiisi nyǝ́mɑ nɑ Amoni nyǝ́mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG10_8","008_10_8","JDG","10","8","8","Pǝ kpɑɣɑʋ wɑɑtʋ ɩnɩ tɔɣɔ pɑ sʋʋ Ɩsɛɣɛlɩ nyǝ́mɑ mpɑ pɑ wɛ tɛtʋ nti tǝ tɑɑ Amolii nyǝ́mɑ kɑ wɛ Kɑlɑɑtɩ kɛ Yɑɑtɑnɩ wɑɑlɩ tɔɣɔ nuɣutuɣu, nɑ pɑ́ tʋɣʋ-wɛɣɛ wɑhɑlɑ. ");
INSERT INTO dop_vpl VALUES ("JG10_9","008_10_9","JDG","10","9","9","Hɑlɩ Amoni nyǝ́mɑ tɛsɩ Yɑɑtɑnɩ nɑ pɑ́ yoonɑ Yutɑ nyǝ́mɑ nɑ Pɛncɑmɛɛ nyǝ́mɑ nɑ Ɩfǝlɑyim nyǝ́mɑ. Ntɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɑŋlɛ wɑkǝlɩ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("JG10_10","008_10_10","JDG","10","10","10","Ḿpʋ́ɣʋ́ pɑ wiinɑ Tɑcɑɑ sɩ: Tɑ Ɩsɔ, tǝ wɑkǝlǝnɑ-ŋ kɛ́. Mpi tɔ, tǝ yelɑ-ŋ nɑ tǝ́ lɑɑkɩ Pɑɑlǝnɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG10_11","008_10_11","JDG","10","11","11","Ɩlɛnɑ Tɑcɑɑ nɑ́ɑ́ pɔɔsɩ-wɛ sɩ: Wɑɑtʋ wei Icipiti nyǝ́mɑ, nɑ Amolii nyǝ́mɑ, nɑ Amoni nyǝ́mɑ, nɑ Filiisi nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("JG10_12","008_10_12","JDG","10","12","12","nɑ Sitɔŋ nyǝ́mɑ, nɑ Amɑleke nyǝ́mɑ, nɑ Mɑwɔŋ nyǝ́mɑ, pɑ tʋ-mɛɣɛ wɑhɑlɑ nɑ ɩ́ wiinɑ-m tɔ, mɑ tɑ wɑɑsɩ-mɛ? ");
INSERT INTO dop_vpl VALUES ("JG10_13","008_10_13","JDG","10","13","13","Pɑɑ nɑ mpʋ mǝ lɔ-m nɑ ɩ́ lɑɑkɩ tɩɩŋ pǝ tɔɔ kɛ́ mɑ kisɑɑ sɩ mɑɑ tɑsǝɣɩ-mɛɣɛ wɑɑsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("JG10_14","008_10_14","JDG","10","14","14","Ɩ́ polo nɑ ɩ́ yɑɑ tɩɩŋ wei ɩ́ lǝsɑɑ nɑ ɩ́ lɑɑkɩ tɔ, nɑ ɩ́lɛ́ ɩ́ wɑɑsɩ-mɛɣɛ mǝ lɑŋwɑkǝllɛ wɑɑtʋ. ");
INSERT INTO dop_vpl VALUES ("JG10_15","008_10_15","JDG","10","15","15","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɑsɑɑ sɩ: Hɑɩ, Tɑcɑɑ, tǝ wɑkǝlǝnɑ-ŋ kɛ́. Lɑnɑ-tʋɣʋ ɩsǝnɑ n sɔɔlɑɑ tɔ. Amɑ wɑɑsɩ-tʋɣʋ sɑŋɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JG10_16","008_10_16","JDG","10","16","16","Mpʋɣʋlɛ pɑ lɔwɑ pɑ tɩɩŋ wei pɑɑ lɑɑkɑɣɑ tɔ, nɑ pɑ́ mǝlɩ pɑ Ɩsɔ sɛɛʋ tɑɑ. Ɩlɛnɑ pɑ wɑhɑlɑnɑɑ tɔm lɑ Ɩsɔ kɛ́ pǝtɔɔtǝlɛ. ");
INSERT INTO dop_vpl VALUES ("JG10_17","008_10_17","JDG","10","17","17","Ḿpʋ́ɣʋ́ Amoni nyǝ́mɑ polɑɑ nɑ pɑ́ pɩɩlɩ Kɑlɑɑtɩ nyǝ́mɑ hɔɣɔlʋɣʋ tɑɑ. Nɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ́ɑ́ tɔŋnɑ ḿpʋ́ɣʋ́ lɑpʋ kɛ Misipɑ. ");
INSERT INTO dop_vpl VALUES ("JG10_18","008_10_18","JDG","10","18","18","Ɩlɛnɑ kpekɑ yǝlɑɑnɑɑ nɑ pɑ nyʋɣʋ nyǝ́mɑ mpɑ pɑ wɛ Kɑlɑɑtɩ tɔ pɑ́ pɔɔsɩ tǝmɑ sɩ: Tɑ́ tɑɑ ɑwe kɑ́ tɛ́ɛ́nɑ́-tʋɣʋ nɔɣɔ, nɑ ɩ́ yoonɑ Amoni nyǝ́mɑ? Wei ɩ́ polɑɑ pʋntʋ kɑ́ pǝsɩ Kɑlɑɑtɩ nyǝ́mɑ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("JG11_1","008_11_1","JDG","11","1","1","Yoolɑɑ tɑɑ yoolu nɔɣɔlʋ ɩ kɑ wɛnnɑ Kɑlɑɑtɩ, pɑ yɑɑ-ɩ sɩ Yɛfɛtɛ, nɑ ɩ cɑɑ sɩ Kɑlɑɑtɩ, ɩ too kɛ ɑpɑlɑɑ tǝnɑ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("JG11_2","008_11_2","JDG","11","2","2","Ɩ cɑɑ ɩnɩ ɩ ɑlʋ lɛlʋ kɑ lʋlɑ-ɩ ɑpɑlʋpiyɑ tɔtɔɣɔ. Sǝlɛ sɩ kɔmɑ nɑ sɩ́ lɑ́ yǝlɑɑ ɩlɛnɑ sɩ́ tɔɣɔnɩ Yɛfɛtɛ sɩ: N kɑɑ nɑ tɑ cɑɑ kpɑncoou. Mpi tɔ, n kɛ́ tɑ cɑɑ nyɩɩtʋ tɑɑ pǝyɑɣɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG11_3","008_11_3","JDG","11","3","3","Ḿpʋ́ɣʋ́ Yɛfɛtɛ sewɑ ɩ newɑɑ mpɛ nɑ ɩ́ polo nɑ ɩ́ cɑɣɑ Tɔpʋ tɛtʋ tɑɑ. Ɩlɛnɑ yǝlɑɑ mpɑ pɑ wɛ ɩsɩɩ ɩnɩ tɔ pɑ́ koti ɩ kiŋ nɑ ɩ́ nɑ-wɛ pɑ́ lɩɩkɩ kʋlɩɩʋ. ");
INSERT INTO dop_vpl VALUES ("JG11_4","008_11_4","JDG","11","4","4","Pǝ tɑɑŋɑɑ, ɩlɛnɑ Amoni nyǝ́mɑ kɔɔ nɑ pɑ́ yookinɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_5","008_11_5","JDG","11","5","5","Yoou kɔmɑ nɑ kʋ́ hɑŋ ɩlɛnɑ Kɑlɑɑtɩ sɔsɑɑ polo Yɛfɛtɛ wɑɑlɩ kɛ́ Tɔpʋ tɛtʋ tɑɑ ");
INSERT INTO dop_vpl VALUES ("JG11_6","008_11_6","JDG","11","6","6","sɩ: Kɔɔ nɑ ń tɛɛ-tʋɣʋ nɔɣɔ nɑ tǝ́ polo tǝ yoonɑ Amoni nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_7","008_11_7","JDG","11","7","7","Tǝnɑɣɑlɛ Yɛfɛtɛ sɩ: Mɑtɔŋ mǝ tɑɑ kpɑnɑ-m nɑ ɩ́ tɔɣɔnɩ-m mɑ tɛ? Ɩlɛnɑ lɑŋwɑkǝllɛ mɑɣɑnɑ-mɛ nɑ ɩ́ kɔŋ mɑ wɑɑlɩ suwe? ");
INSERT INTO dop_vpl VALUES ("JG11_8","008_11_8","JDG","11","8","8","Ntɛnɑ sɔsɑɑ sɩ: Tǝ kɔmɑɣɑ sɩ ń kɔɔ nɑ ń tɛɛ-tʋɣʋ nɔɣɔ nɑ tǝ́ yoonɑ Amoni nyǝ́mɑ nɑ ń lɑ tɑ́ nɑ Kɑlɑɑtɩ nyǝ́mɑ tɑ́ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("JG11_9","008_11_9","JDG","11","9","9","Kɛlɛnɑ ɩ́ cɔ-wɛ sɩ: Ɩ́ mǝlǝnɑ-m sɩ tǝ́ yoonɑ Amoni nyǝ́mɑ nɑ Tɑcɑɑ ɩ́ tʋ-wɛɣɛ mɑ niŋ tɑɑ, mɑɑ lɑ mǝ nyʋɣʋ tʋ nɑ? ");
INSERT INTO dop_vpl VALUES ("JG11_10","008_11_10","JDG","11","10","10","Mpʋɣʋlɛ sɔsɑɑ sɩ: Yɛɛ, tɩɩ lɑ mpʋ. Tɑcɑɑ kɛlɛ tɑ́ ɑseetɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("JG11_11","008_11_11","JDG","11","11","11","Ḿpʋ́ɣʋ́ Yɛfɛtɛ tǝŋɑ Kɑlɑɑtɩ sɔsɑɑ nɑ yǝlɑɑ kpɑ-ɩ pɑ nyʋɣʋ tʋ, nɑ pɑ́ tʋ yoolɑɑ tǝnɑɣɑ ɩ niŋ tɑɑ. Ɩlɛnɑ Yɛfɛtɛ lɛlɩ tǝ tǝnɑ nti ɩ nɑ sɔsɑɑ pɑ yɔɣɔtɑɑ nɑ pɑ́ sɩɩ tɔɣɔ Tɑcɑɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_12","008_11_12","JDG","11","12","12","Ḿpʋ́ɣʋ́ Yɛfɛtɛ tilɑɑ nɑ ɩ́ pɔɔsɩ Amoni wulɑʋ sɩ: Mɑ nɑ-ŋ suwe nɑ ń kɔɔ nɑ ń yookinɑ mɑ yǝlɑɑ? ");
INSERT INTO dop_vpl VALUES ("JG11_13","008_11_13","JDG","11","13","13","Ntɛnɑ ɩ́lɛ́ ɩ́ cɔ sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩʋ Icipiti tɔ pɑ lɛɛkɑ mɑ tɛtʋ kɛ pǝ kpɑɣɑʋ Alǝnɔŋ tɔ. Hɑlǝnɑ pǝ́ polo Yɑpɔkɩ nɑ Yɑɑtɑnɩ. ");
INSERT INTO dop_vpl VALUES ("JG11_14","008_11_14","JDG","11","14","14","Ḿpʋ́ɣʋ́ Yɛfɛtɛ tɑsɑ tiluɣu nɑ pɑ́ heeli Amoni nyǝ́mɑ wulɑʋ sɩ: ");
INSERT INTO dop_vpl VALUES ("JG11_15","008_11_15","JDG","11","15","15","Pǝ tɑɣɑ Mowɑpʋ nyǝ́mɑ nɑ Amoni nyǝ́mɑ tɛtʋ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ lɛɛkɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_16","008_11_16","JDG","11","16","16","Mpi tɔ, Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩʋ Icipiti tɔ, wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ pɑ tɔmɑ, hɑlǝnɑ pɑ́ tɑlɑ Sǝsǝncɑɑsɩ Teŋku. Pǝ wɑɑlɩ kɛ́ pɑ mǝlǝnɑ Kɑtɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("JG11_17","008_11_17","JDG","11","17","17","Tǝnɑɣɑ pɑ tilɑɑ nɑ pɑ́ sǝlǝmɩ Ɩtɔm wulɑʋ sɩ: Hɑ-tʋɣʋ mpɑɑʋ nɑ tǝ fɑɣɑnɑ nyɑ́ tɛtʋ tɑɑ. Amɑ ɩ́lɛ́ ɩ kisɑɑ. Ɩlɛnɑ pɑ́ sǝlǝmɩ Mowɑpʋ nyǝ́mɑ nɑ pɛlɛ pɑ́ kisi mpʋ tɔtɔ. Ɩlɛnɑ pɑ́ sɑɑlɩ Kɑtɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("JG11_18","008_11_18","JDG","11","18","18","Pǝlɛ pǝ wɑɑlɩ kɛ́ pɑ kpɑɣɑ wʋlɑɣɑ tɛtʋ mpɑɑʋ nɑ pɑ́ cɔɔlɩ Mowɑpʋ nɑ Ɩtɔm pɑ tɛtʋ nɑ pɑ́ lɩɩ Mowɑpʋ ilim tǝlɩɩlɛ tɔɔ. Ɩlɛnɑ pɑ́ siki Alǝnɔŋ lɔɔʋ nɔɣɔ tǝnɑ, pɑ tɑ sʋʋ Mowɑpʋ tɛtʋ tɑɑ. Mpi tɔ, pɛlɛ pɑ tɛtʋ toŋɑ ntɛ́ pɔɣɔ ŋkɛ. ");
INSERT INTO dop_vpl VALUES ("JG11_19","008_11_19","JDG","11","19","19","Ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tili nɑ pɑ́ heeli Amolii wulɑʋ Sihoŋ wei ɩ tɔkɑɣɑ kɑwulɑɣɑ kɛ Hɛsǝpɔŋ tɔtɔ tɔ sɩ ɩ́ yele-wɛ nɑ pɑ́ fɑɣɑnɑ ɩ tɛtʋ tɑɑ nɑ pɑ́ tɛɛ timpi pɑ puki tɔ. ");
INSERT INTO dop_vpl VALUES ("JG11_20","008_11_20","JDG","11","20","20","Sihoŋ nɑ́ tɑ́ lɑ́ Ɩsɛɣɛlɩ kɛ nɑɑni sɩ ɩ́ yele-wɛ nɑ pɑ́ fɑɣɑnɑ ɩ tɛ́. Ɩlɛnɑ ɩ́ koti ɩ yoolɑɑ nɑ pɑ́ yoonɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JG11_21","008_11_21","JDG","11","21","21","Ɩlɛnɑ Ɩsɔ Tɑcɑɑ tʋ-wɛɣɛ Ɩsɛɣɛlɩ nyǝ́mɑ niŋ tɑɑ nɑ pɛlɛ pɑ́ kǝlɩ-wɛ nɑ pɑ́ lɛɛkɩ pɑ tɛtʋ tǝnɑɣɑ hɔɣɔlʋɣʋ ŋkʋ kʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_22","008_11_22","JDG","11","22","22","Pǝ kpɑɣɑʋ Alǝnɔŋ tɛtɛkǝlɛ nɑ pǝ́ polo Yɑpɔkɩ lɔɔʋ tɔ, nɑ pǝ́ kɛlɩ ilim tǝlɩɩlɛ tɔɔ wʋlɑɣɑ tɛtʋ hɑlǝnɑ pǝ́ polo Yɑɑtɑnɩ. ");
INSERT INTO dop_vpl VALUES ("JG11_23","008_11_23","JDG","11","23","23","Ɩsɛɣɛlɩ nyǝ́mɑ Ɩsɔ Tɑcɑɑ hɑnɑ ɩ yǝlɑɑ tɑɣɑ nɔɣɔ sɩ tǝ́ lɛɛkɩ Amolii nyǝ́mɑ tɛtʋ. Ɩlɛnɑ nyɑɑ cɑɑkɩ sɩ n tɑɣɑnɩ-tǝɣɩ lɛɛkʋɣʋ nɑ? ");
INSERT INTO dop_vpl VALUES ("JG11_24","008_11_24","JDG","11","24","24","Tɛtʋ nti nyɑ́ tʋɣʋ Kɛmɔsɩ hɑ-ŋ tɔ nyɑ́ kisɑ-tɩ? Mpʋ tɔtɔɣɔ tɑ́ wɛnɑ mpɑɑʋ sɩ tǝ́ tɔɣɔ tɛtʋ nti tɑ Ɩsɔ Tɑcɑɑ hɑ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG11_25","008_11_25","JDG","11","25","25","Sipɔɔ pǝyɑlʋ Pɑlɑkɩ wei ɩ kɛ́ Mowɑpʋ nyǝ́mɑ wulɑʋ sɔsɔ tɔ, ɩ́lɛ́ ɩ wɛnnɑ toŋ. Pǝyele ɩ tɑ yoonɑ Ɩsɛɣɛlɩ nyǝ́mɑ. Nɑ ɑweɣe nyɑɣɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_26","008_11_26","JDG","11","26","26","Pɩɩsɩ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (300) kɛlɛ Ɩsɛɣɛlɩ nyǝ́mɑ cɑɣɑ Hɛsǝpɔŋ nɑ Alowɛɛ nɑ pǝcɔlɔ ɑcɑlɛɛ tɑɑ nɑ ɑcɑlɛɛ nnɑ ɑ wɛ Alǝnɔŋ lɔɔʋ nɔɣɔ tɔ ɑ tɑɑ. Ɩlɛ pepe tɔɔ kɛ́ ɩ́ tɑɑ lɛɛkɩ-wɛɣɛ tɛtʋ ntǝɣɩ wɑɑtʋ ɩnɩ ɩ tɑɑ? ");
INSERT INTO dop_vpl VALUES ("JG11_27","008_11_27","JDG","11","27","27","Pǝ tɑɣɑ mɑ́ pǝntǝnɑnɑ-ŋ. Amɑ nyɑ́ wɑkǝlǝnɑ nɑ mɑ́, hɑlǝnɑ ń yookinɑ-m. Tɑcɑɑ wei ɩ hʋʋkǝnɑ yǝlɑɑ kɛ tɔm tɔ, ɩ́ hʋʋ tɑ nɑ-mɛ tɑ tɔm kɛ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_28","008_11_28","JDG","11","28","28","Pɑɑ nɑ mpʋ Amoni wulɑʋ tɑ yɑɑ Yɛfɛtɛ tɔm ntǝɣɩ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("JG11_29","008_11_29","JDG","11","29","29","Ḿpʋ́ɣʋ́ Tɑcɑɑ Feesuɣu tii Yɛfɛtɛ tɔɔ, nɑ ɩ́ cɔɔ Kɑlɑɑtɩ nɑ Mɑnɑsee tɛtʋ. Pǝ wɑɑlɩ kɛ́ ɩ polɑ Misipɑ kɛ Ɩsɔ kiŋ kɛ Kɑlɑɑtɩ tɛtʋ tɑɑ, nɑ ɩ́ tɛɛ Amoni nyǝ́mɑ kɛ yoonɑʋ. ");
INSERT INTO dop_vpl VALUES ("JG11_30","008_11_30","JDG","11","30","30","Ɩlɛnɑ ɩ́ sɩɩ Tɑcɑɑ kɛ nɔɣɔ sɩ: Ye n tʋ Amoni nyǝ́mɑ kɛ mɑ niŋ tɑɑ, ");
INSERT INTO dop_vpl VALUES ("JG11_31","008_11_31","JDG","11","31","31","kɑncɑɑlɑɣɑ yʋlʋ wei ɩ kɑ́ lɩɩ mɑ sǝŋʋɣʋ tɔɣɔ mɑɑ lɑ-ŋ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG11_32","008_11_32","JDG","11","32","32","Ḿpʋ́ɣʋ́ Yɛfɛtɛ ŋmɑɑ Amoni nyǝ́mɑ toŋɑ nɑ ɩ́ yoonɑ-wɛ nɑ Tɑcɑɑ tʋ-wɛɣɛ ɩ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_33","008_11_33","JDG","11","33","33","Ɩlɛnɑ ɩ́ kǝlɩ-wɛ nɑ ɩ́ lɛɛkɩ ɑcɑlɛɛ hiu kɛ pǝ kpɑɣɑʋ Alowɛɛ, nɑ pǝ́ cɔɔ Mini tɔ. Hɑlǝnɑ Apɛɛlɩ-Kǝlɑnim. Ɩsɛɣɛlɩ nyǝ́mɑ kʋ-wɛɣɛ sɔsɔm kɛ́, ɩlɛnɑ pɑ́ tii tǝfɛ. ");
INSERT INTO dop_vpl VALUES ("JG11_34","008_11_34","JDG","11","34","34","Wɑɑtʋ wei Yɛfɛtɛ mǝlɑɣɑ ɩ tɛ Misipɑ, ɩlɛnɑ ɩ pɛɛlɔ lɩɩ ɩ sǝŋʋɣʋ nɑ ɩ́ mɑkɩ ɑkilimɑ nɑ ɩ́ pɑɑkɩ. Ɩ tike kɛ ɩ kɑ lʋlɑɑ, ɩ fɛɩnɑ ɑpɑlʋpiyɑ yɑɑ ɑlʋpiyɑ lɛnsɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JG11_35","008_11_35","JDG","11","35","35","Ɩ loosɑ-ɩ, ɩlɛnɑ ɩ lɑŋlɛ wɑkǝlɩ. Hɑlǝnɑ ɩ́ cǝlɩ ɩ wontu nɑ ɩ tɔ sɩ: Hɑɩ, mɑ pu, n kɔŋnɑ mɑ nyʋɣʋ tɑɑ kɛ́ mpusi nɑ ń pǝsǝɣɩ mɑ lɑɑkɑlɩ suwe? Mɑ tɛmɑ mɑ nɔɣɔ sɩɩʋ kɛ Tɑcɑɑ, pǝ fɛɩ sɩ mɑɑ tuli tɑpǝŋ. ");
INSERT INTO dop_vpl VALUES ("JG11_36","008_11_36","JDG","11","36","36","Mpʋɣʋlɛ ɩ pɛɛlɔ cɔwɑ sɩ: Ye n kɑ sɩɩ Tɑcɑɑ kɛ nɔɣɔ, lɑnɑ-m ɩsɩɩ n kɑ sɩɩʋ tɔ. Mpi tɔ, Ɩsɔ nɑ́ lɑpɑ ɩ́lɛ́ ɩ nyǝntʋ nɑ ɩ́ lɛɛtɩ nyɑ́ kolontunɑɑ Amoni nyǝ́mɑ nɑ nyɑ́ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("JG11_37","008_11_37","JDG","11","37","37","Ɩlɛnɑ ɩ́ sǝlǝmɩ ɩ cɑɑ sɩ: Yele nɑ mɑ́ nɑ mɑ tɑɑpɑlɑɑ tǝ́ kpɑ́ pulɑɣɑ tɑɑ kɛ́ ɩsɔtʋnɑɑ nɑɑlɛ nɑ mɑ́ wii. Mpi tɔ, mɑ sǝkɩ nɑ mɑ́ tɑ sɑɑtɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_38","008_11_38","JDG","11","38","38","Ɩlɛnɑ Yɛfɛtɛ tisi sɩ ɩ́ polo nɑ ɩ́ lɑ ɩsɔtʋnɑɑ nɑɑlɛ. Ḿpʋ́ɣʋ́ ɩ́ nɑ ɩ tɑɑpɑlɑɑ pɑ kpɑ pulɑsɩ tɑɑ nɑ ɩ́ wii. Mpi tɔ, ɩ sǝkɩ nɑ ɩ́ tɑ sɑɑtɑ. ");
INSERT INTO dop_vpl VALUES ("JG11_39","008_11_39","JDG","11","39","39","Ɩsɔtʋnɑɑ nɑɑlɛ tɛmɑ, ɩlɛnɑ ɩ́ mǝlɩ ɩ cɑɑ kiŋ nɑ ɩ́lɛ́ ɩ lɑnɑ-ɩ ɩsɩɩ ɩ́ kɑ́ sɩɩʋ nɔɣɔ tɔ, nɑ ɩ́ sɩ́ nɑ ɩ́ tɑ nyǝntɑ ɑpɑlʋ. Pǝ kpɑɣɑʋ wɑɑtʋ ɩnɩ tɔɣɔ Ɩsɛɣɛlɩ ɑlɑɑ sʋʋ wulɑ kɛ ");
INSERT INTO dop_vpl VALUES ("JG11_40","008_11_40","JDG","11","40","40","pɑɑ pǝnɑɣɑ ŋkɑɣɑ kʋyɛɛŋ liɣiti liɣiti kɛ́ Kɑlɑɑtɩ tʋ Yɛfɛtɛ pɛɛlɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG12_1","008_12_1","JDG","12","1","1","Ḿpʋ́ɣʋ́ Ɩfǝlɑyim nyǝ́mɑ kʋlɑɑ nɑ pɑ́ tɛsɩ Yɑɑtɑnɩ nɑ pɑ́ polo Sɑfɔŋ, nɑ pɑ́ tɔ́ Yɛfɛtɛ sɩ: Pepe tɔɔ kɛ́ n polɑɑ nɑ ń yoonɑ Amoni nyǝ́mɑ kɛ nyɑ́ tike nɑ ń tɑ́ yɑɑ-tʋ sɩ tǝ́ tʋ-ŋ niŋ? Mpʋ tɔ, tɩɩ sɔ nyɑ́ tǝyɑɣɑ kɛ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("JG12_2","008_12_2","JDG","12","2","2","Ɩlɛnɑ Yɛfɛtɛ cɔ-wɛ sɩ: Amoni nyǝ́mɑ cɑɑkɑɣɑ mɑ nɑ mɑ yǝlɑɑ nɑ yoou kɛ́. Hɑlǝnɑ tǝ́ yɑɑ-mɛ sɩ ɩ́ kɔɔ nɑ ɩ́ sǝnɑ-tʋ nɑ ɩ́ kisi. ");
INSERT INTO dop_vpl VALUES ("JG12_3","008_12_3","JDG","12","3","3","Ɩ́ kisɑ mpʋ, ɩlɛnɑ mɑ sɩ ye sǝm sǝm. Ɩlɛnɑ mɑ́ tɛsɩ toŋɑ nɑ mɑ́ yoonɑ Amoni nyǝ́mɑ nɑ Tɑcɑɑ tʋ-wɛɣɛ mɑ niŋ tɑɑ. Tɔʋ, pepe tɔɔ kɛ́ ɩ́ kɔmɑ-m yoonɑʋ kɛ pǝnɛntɛ? ");
INSERT INTO dop_vpl VALUES ("JG12_4","008_12_4","JDG","12","4","4","Ɩfǝlɑyim nyǝ́mɑ kɑ tʋʋ Yɛfɛtɛ-wɛɣɛ sɩ: Ɩ́ sewɑ tɑ́ tɛɣɛ nɑ ɩ́ cɔɔsɩ Mɑnɑsee nyǝ́mɑ kiŋ. Tǝnɑɣɑlɛ Yɛfɛtɛ kpeɣelɑ Kɑlɑɑtɩ nyǝ́mɑ nɑ pɑ́ polo pɑ́ yoonɑ-wɛ nɑ pɑ́ kǝlɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("JG12_5","008_12_5","JDG","12","5","5","Ɩlɛnɑ Kɑlɑɑtɩ nyǝ́mɑ cɛ-wɛɣɛ timpi timpi pɑ tɛsǝɣǝnɑ Yɑɑtɑnɩ tɔ. Ye nɔɣɔlʋ kɔmɑ nɑ ɩ́ nǝɣǝsǝnɑ Ɩfǝlɑyim tʋ, ɩlɛ pɑ pɔɔsɩ-ɩ sɩ: N kɛ́ Ɩfǝlɑyim tʋ kɛ? Ye ɩ cɔwɑ sɩ ɑɑɩ. ");
INSERT INTO dop_vpl VALUES ("JG12_6","008_12_6","JDG","12","6","6","Ɩlɛ pɑ tɔmɩ-ɩ sɩ: Mpʋ tɔ, yɔɣɔtɩ sɩ cipolɛtɩ. Ɩlɛnɑ ɩ́lɛ́ ɩ́ pǝntɩ sɩ sipolɛtɩ. Mpi tɔ, pɛlɛ pɑɑ pǝsǝɣɩ hǝtɛ ntɛ tǝ yɑɑʋ kɛ teitei. Ɩ pǝntǝɣɩ mpʋ, ɩlɛnɑ pɑ́ kʋ-ɩ kpɑkpɑɑ kɛ Yɑɑtɑnɩ tǝtɛsǝlɛ tǝnɑ. Ɩfǝlɑyim yǝlɑɑ iyisi nɩɩlɛ nɑ nɑɑlɛ (42000) sǝpǝnɑ tǝnɑɣɑ wɑɑtʋ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("JG12_7","008_12_7","JDG","12","7","7","Ḿpʋ́ɣʋ́ Yɛfɛtɛ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɩɩsɩ nɑɑtoso. Ɩlɛnɑ ɩ́ sɩ́ nɑ pɑ́ pimi-ɩ ɩ ɩcɑtɛ kʋlʋllɛ Kɑlɑɑtɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG12_8","008_12_8","JDG","12","8","8","Yɛfɛtɛ wɑɑlɩ kɛ́ Pɛtǝlɛhɛm tʋ Ɩpǝsɑŋ nɑ́ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG12_9","008_12_9","JDG","12","9","9","Ɩ lʋlɑ ɑpɑlʋpiyɑ kɛ hiu nɑ nɑɑnʋwɑ nɑ ɑlʋpiyɑ kɛ hiu nɑ nɑɑnʋwɑ. Ḿpʋ́ɣʋ́ ɩ hɑwɑ ɩ pɛɛlɑɑ kɛ kpekɑ lɛnnɑ nyǝ́mɑ nɑ ɩ́ cɑɑ ɩ pǝyɑlɑɑ kɛ ɑlɑɑ kɛ kpekɑ lɛnnɑ nyǝ́mɑ tɔtɔ. Pɩɩsɩ nɑɑtosompɔɣɔlɑɣɑ kɛ ɩ tiikɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("JG12_10","008_12_10","JDG","12","10","10","Pǝ wɑɑlɩ kɛ́ ɩ sǝpɑ nɑ pɑ́ pimi-ɩ Pɛtǝlɛhɛm. ");
INSERT INTO dop_vpl VALUES ("JG12_11","008_12_11","JDG","12","11","11","Ɩpǝsɑŋ wɑɑlɩ kɛ́ Sɑpulɔŋ tʋ Ɩlɔŋ nɑ́ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɩɩsɩ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("JG12_12","008_12_12","JDG","12","12","12","Ɩ sǝpɑ, ɩlɛnɑ pɑ́ pimi-ɩ Ayɑlɔŋ kɛ Sɑpulɔŋ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG12_13","008_12_13","JDG","12","13","13","Ɩlɔŋ wɑɑlɩ kɛ Pilɑtɔŋ tʋ Hilili pǝyɑlʋ Apǝtɔŋ nɑ́ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JG12_14","008_12_14","JDG","12","14","14","Ɩ lʋlɑ ɑpɑlʋpiyɑ nɩɩlɛ nɑ ɩ sɑɑlǝnɑɑ kɛ hiu nɑ nɑɑnʋwɑ nɑ pɑ́ cɑkɩ kpɑŋɑsɩ nɩɩtoso nɑ nɑɑnʋwɑ. Ɩlɛnɑ Apǝtɔŋ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɩɩsɩ pǝlefɛɩ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("JG12_15","008_12_15","JDG","12","15","15","Ɩ kɔmɑ nɑ ɩ́ sɩ́, ɩlɛnɑ pɑ́ pimi-ɩ Pilɑtɔŋ ɩcɑtɛ tɑɑ kɛ Ɩfǝlɑyim hɔɣɔlʋɣʋ tɑɑ kɛ́ Amɑleke nyǝ́mɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","1","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɑsɑ lɑpʋ kɛ mpi pǝ tɑ mɑɣɑ Tɑcɑɑ tɔ. Pǝ tɔɔ kɛ́ ɩ́lɛ́ ɩ tʋ-wɛɣɛ Filiisi nyǝ́mɑ niŋ tɑɑ kɛ́ pɩɩsɩ nɩɩlɛ tǝcu. ");
INSERT INTO dop_vpl VALUES ("JG13_2","008_13_2","JDG","13","2","2","Tɑŋ lʋlʋɣʋ tɑɑ tʋ nɔɣɔlʋ ɩ kɑ wɛnnɑ Solɑ, nɑ pɑ́ yɑɑkɩ-ɩ sɩ Mɑnʋwɑ. Ɩ ɑlʋ kɑ kɛ́ kɑɑlʋlɑɣɑ kɛ́ ɩ fɛɩ pǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JG13_3","008_13_3","JDG","13","3","3","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Tɑcɑɑ ɩsɔtɑɑ tillu lɩɩ ɑlʋ ɩnɩ ɩ tɔɔ, nɑ ɩ́ tɔmɩ-ɩ sɩ: Mɑ nyǝ́mɑ sɩ n kɛ́ kɑɑlʋlɑɣɑ, ɩlɛ n fɛɩ pǝyɑɣɑ. Pɑɑ nɑ mpʋ tɔ, n kɑ́ lɑ teu nɑ ń lʋlɩ ɑpɑlʋpǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JG13_4","008_13_4","JDG","13","4","4","Mpʋ tɔ, pǝ kpɑɣɑʋ pǝnɛntɛ tɔ, tɑɑ nyɔɔ sʋlʋm yɑɑ kʋnyɔnyɔɔm kʋkʋkʋm nɑpǝlɩ. Pǝyele tɑɑ tɔɣɔ mpi Ɩsɔ kisinɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG13_5","008_13_5","JDG","13","5","5","Mpi tɔ, n kɑ lɑ teu nɑ ń lʋlɩ ɑpɑlʋpǝyɑɣɑ. Hʋnʋɣʋ kɑɑ kpɑ kɑ nyʋɣʋ tɑɑ. Pǝ tɑɣɑ pʋlʋ, hɑtoo kɑ too lotu tɑɑ kɛ́ kɑ kɛ́ Ɩsɔ nyǝŋkɑ, nɑ ŋkɛ kɑɑ cɑɑlǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ hɛtʋɣʋ kɛ Filiisi nyǝ́mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG13_6","008_13_6","JDG","13","6","6","Ɩlɛnɑ ɑlʋ polo nɑ ɩ́ kɛɛsɩ ɩ pɑɑlʋ sɩ: Ɩsɔ yʋlʋ nɔɣɔlʋ ɩ lɩɩnɑ ntɛɣɛ mɑ tɔɔ, ɩ nyǝnʋɣʋ wɛ sɔɣɔntʋ kɛ́ ɩsɩɩ Ɩsɔ ɩsɔtɑɑ tillu. Mɑ tɑ pɔɔsɩ-ɩ timpi ɩ lɩɩnɑɑ tɔ. Pǝ́cɔ́ ɩ́lɛ́ ɩ tɑ tɩɩ heeli-m ɩ hǝtɛ. ");
INSERT INTO dop_vpl VALUES ("JG13_7","008_13_7","JDG","13","7","7","Hɑlɩ ɩ heelɑ-m sɩ mɑɑ lɑ teu, nɑ mɑ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ. Ɩlɛ pǝ kpɑɣɑʋ pǝnɛntɛ tɔ, mɑ́ tɑɑ tɑsɑ sʋlʋm kɛ nyɔɔʋ, yɑɑ kʋnyɔnyɔɔm kʋkʋkʋm nɑpǝlɩ. Pǝ́cɔ́ mɑ́ tɑɑ tɔɣɔ mpi Ɩsɔ kisinɑ-tʋ tɔ. Mpi tɔ, pǝyɑɣɑ ŋkɛ kɑ kɛ́ Ɩsɔ nyǝŋkɑ kɛ hɑtoo kɑ too lotu tɑɑ kɛ́, hɑlǝnɑ kɑ sǝm. ");
INSERT INTO dop_vpl VALUES ("JG13_8","008_13_8","JDG","13","8","8","Mpʋɣʋlɛ Mɑnʋwɑ sǝlǝmɑ Tɑcɑɑ sɩ: Hɑɩ, Tɑcɑɑ, mɑ wiinɑ-ŋ sɩ ń mǝlǝnɑ nyɑ́ yʋlʋ wei n tilɑ tɑ́ kiŋ tɔ nɑ ɩ́ sɛɣɛsɩ-tʋɣʋ nti nti tɩɩ tǝŋ pǝyɑɣɑ ŋkɑ ɩnɩ tɩɩ lʋlɩ tɔ kɑ tɔm tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG13_9","008_13_9","JDG","13","9","9","Ɩlɛnɑ Ɩsɔ mʋ Mɑnʋwɑ kʋsǝlǝmʋtʋ, nɑ ɩ́ mǝlǝnɑ ɩsɔtɑɑ tillu kɛ ɑlʋ ɩnɩ ɩ kiŋ, nɑ pǝ́ pɑnɑ ɩ wɛ ɩ tike kɛ tɑɑlɛ, ɩ pɑɑlʋ fɛɩ. ");
INSERT INTO dop_vpl VALUES ("JG13_10","008_13_10","JDG","13","10","10","Ɩlɛnɑ ɩ́ lɔɣɔ ɩ tǝɣɩ ɩ pɑɑlʋ kiŋ nɑ ɩ́ yɑɑ-ɩ sɩ: Kɔɔ lɔŋ, yʋlʋ wei ɩnɩ ɩ kɑ lɩɩwɑ mɑ tɔɔ kɛ́ kʋyɑkʋ nɑkʋlɩ tɔ, ɩ tɑɣɑnɑ mǝlʋɣʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JG13_11","008_13_11","JDG","13","11","11","Ɩlɛnɑ Mɑnʋwɑ tǝŋ ɩ ɑlʋ nɑ pɑ́ polo yʋlʋ ɩnɩ ɩ kiŋ nɑ ɩ́ tɔmɩ-ɩ sɩ: Tete wɑɑlɩ nyɑ́ yɔɣɔtǝnɑ nɑ mɑ tɛ ɑlʋ nɑ? Ɩlɛnɑ ɩ́lɛ́ sɩ: Nn mɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("JG13_12","008_13_12","JDG","13","12","12","Ntɛnɑ Mɑnʋwɑ sɩ: Ye pǝ kɔmɑ nɑ pǝ́ lɑ mpʋ, pepe nɑ pepeɣe tɩɩ lɑ pǝyɑɣɑ ŋkɛ kɑ tɔm tɑɑ, nɑ tǝ yele we? ");
INSERT INTO dop_vpl VALUES ("JG13_13","008_13_13","JDG","13","13","13","Kɛlɛnɑ Tɑcɑɑ ɩsɔtɑɑ tillu sɩ: Pǝ wɛɛ kɛ́ sɩ nyɑ́ ɑlʋ ɩ́ kii mpi nɑ mpi mɑ kisinɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG13_14","008_13_14","JDG","13","14","14","Pǝ fɛɩ sɩ ɩ́ tɔɣɔ lɛsɛŋ pʋlʋ. Pǝ́cɔ́ ɩ́ tɑɑ nyɔɔ sʋlʋm yɑɑ kʋnyɔnyɔɔm kʋkʋkʋm nɑpǝlɩ. Pǝyele ɩ́ tɑɑ tɔɣɔ mpi Ɩsɔ kisinɑ-mɛ tɔ. Ɩ́ tǝŋ pǝ tǝnɑ mpi mɑ tʋ-ɩ mpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG13_15","008_13_15","JDG","13","15","16","Mɑnʋwɑ tɑɑ cɛkǝnɑ sɩ Tɑcɑɑ ɩsɔtɑɑ tillu, ɩlɛnɑ ɩ́ tɔmɩ-ɩ sɩ: Cɑɣɑ nɑ tǝ́ lɑ-ŋ pǝfɑtɛ kɛ mʋʋllɛ. Ntɛnɑ ɩ́lɛ́ sɩ: Pɑɑ mɑ cɑɣɑɑ mɑ kɑɑ tɔɣɔ tɔɣɔnɑɣɑ. Ɩlɛ ye n sɔɔlɑɑ n lɑ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG13_17","008_13_17","JDG","13","17","17","Ɩlɛnɑ Mɑnʋwɑ tɔmɩ-ɩ sɩ: Heeli-tʋɣʋ nyɑ́ hǝtɛ, nɑ pǝ́ kɔmɑ nɑ tɔm nti n heelɑ-tʋ tɔ tǝ́ lɑ, ɩlɛ tɩɩ sɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("JG13_18","008_13_18","JDG","13","18","18","Kɛlɛnɑ ɩsɔtɑɑ tillu sɩ: Mɑ hǝtɛ wɛ piti kɛ́. Pepe tɔɔ kɛ́ n cɑɑ tǝ nyǝm? ");
INSERT INTO dop_vpl VALUES ("JG13_19","008_13_19","JDG","13","19","19","Ḿpʋ́ɣʋ́ Mɑnʋwɑ kpɑwɑ pǝfɑtɛ nɑ ɩ kʋhɑʋ nɑ ɩ́ lɑ́ Tɑcɑɑ wei ɩ lɑkɩ piti tǝmɑ tɔɣɔ kɔtɑɣɑ kɛ kʋkpɑmʋɣʋ tɔɔ. Ɩ́ nɑ ɩ ɑlʋ pɑ tɔŋnɑ nyǝnʋɣʋ kɛ mpʋ, nɑ ");
INSERT INTO dop_vpl VALUES ("JG13_20","008_13_20","JDG","13","20","20","kɔkɔ nɑ́ɑ́ mʋɣɩ kɔtɑɣɑ tǝlɑtɛ, ɩlɛ pɑ nɑ́ Tɑcɑɑ ɩsɔtɑɑ tillu ntɛ́ nɑ ɩ́ tǝŋǝɣɩ kɔkɔ ŋkɛ nɑ ɩ́ kpɑɑkɩ. Ɩlɛnɑ pɑ́ hoti ɑtɛɣɛ pɑ ɩsɛntɔɔ. ");
INSERT INTO dop_vpl VALUES ("JG13_21","008_13_21","JDG","13","21","21","Wɑɑtʋ ɩnǝɣǝlɛ Mɑnʋwɑ nɑ ɩ ɑlʋ pɑ cɛkǝnɑɑ sɩ Tɑcɑɑ ɩsɔtɑɑ tillu. Ɩlɛ ɩ tɑ tɑsɑ pɑ tɔɔ kɛ́ lɩɩʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("JG13_22","008_13_22","JDG","13","22","22","Ntɛnɑ Mɑnʋwɑ heeli ɩ ɑlʋ sɩ: Hei, Ɩsɔ kɛ́ tǝ nɑwɑ yoo, ɩsɩɩ tǝ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("JG13_23","008_13_23","JDG","13","23","23","Mpʋɣʋlɛ ɩ ɑlʋ cɔ-ɩ sɩ: Ye Tɑcɑɑ kɑ cɑɑkɑɣɑ-tʋɣʋ kʋɣʋ, ɩ tɑɑ mʋ tɑ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑɑ tɔ nɑ tɔɣɔnɑɣɑ nyǝŋkɑ. Pǝyele ɩ tɑɑ hʋlɩ-tʋɣʋ pʋlʋ nɑ ɩ́ heeli-tʋɣʋ nɑtǝlɩ. ");
INSERT INTO dop_vpl VALUES ("JG13_24","008_13_24","JDG","13","24","24","Ḿpʋ́ɣʋ́ Mɑnʋwɑ ɑlʋ lʋlɑ ɑpɑlʋpǝyɑɣɑ, nɑ ɩ́ hɑ-kɛɣɛ hǝtɛ sɩ: Sɑmsɔŋ. Pǝyɑɣɑ tɔŋnɑ pɩɩʋ nɑ Tɑcɑɑ kooliɣi-kɛɣɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("JG13_25","008_13_25","JDG","13","25","25","Ḿpʋ́ɣʋ́ Tɑcɑɑ Feesuɣu tiiwɑ ɩ tɔɔ kɛ́ tɔm kɑncɑɑlɑɣɑ nyǝm kɛ wɑɑtʋ wei ɩ kɑ wɛ Tɑŋ tǝsikile kɛ Solɑ nɑ Ɩsǝtɑwɔlɩ pɑ hɛkʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG14_1","008_14_1","JDG","14","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Sɑmsɔŋ polɑ Timnɑ, nɑ ɩ́ nɑ́ Filiisi pɛɛlɔ nɔɣɔlʋ nɑ ɩ luɣu sʋʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_2","008_14_2","JDG","14","2","2","Ɩ kpemɑ, ɩlɛnɑ ɩ́ heeli ɩ nyǝ́mɑ kɛ ɩ tɔm sɩ: Mɑ nɑwɑ Filiisi pɛɛlɔ nɔɣɔlʋɣʋ Timnɑ, mɑ cɑɑ sɩ ɩ́ cɑɑmɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_3","008_14_3","JDG","14","3","3","Mpʋɣʋlɛ ɩ nyǝ́mɑ cɔ-ɩ sɩ: Ɩsɩɩ n tɑ nɑ pɛɛlɔ ntɛ́ nyɑ́ piitim nyǝ́mɑ tɑɑ nɑ nyɑ́ yǝlɑɑ tɑɑ, nɑ ń puki sɩ n cɑɑkɩ Filiisi nyǝ́mɑ mpɑ pɑ tɑ nyɩ Ɩsɔ tɔ? Tǝnɑɣɑlɛ Sɑmsɔŋ sɩ: Ɩnɩ ɩ wɛnnɑ-m teu. Mɩɩ cɑɑmɩ-ɩ te. ");
INSERT INTO dop_vpl VALUES ("JG14_4","008_14_4","JDG","14","4","4","Amɑ ɩ nyǝ́mɑ nɑ́ tɑ́ nyɩ sɩ Tɑcɑɑ niŋ wɛ pǝ tɑɑ sɩ pɑ pǝyɑɣɑ ɩ́ hikinɑ Filiisi nyǝ́mɑ nɑ tǝnɑ. Mpi tɔ, pɛlɛ pɑɑ ŋmɑkǝlɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ wɑɑtʋ ɩnǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","5","Ḿpʋ́ɣʋ́ Sɑmsɔŋ nɑ ɩ nyǝ́mɑ pɑ polɑ Timnɑ, pɑ kɔmɑ nɑ pɑ́ tɑlɑ ɩcɑtɛ nyǝ́mɑ lɛsɛŋ tɩɩŋ tɑwɑ, ɩlɛ tɔɣɔlɑɣɑ kʋfɑlɑɣɑ nyɩɩsɑɑ kɛlɛ nɑ ɩ́ hɛlɩ sɩ ɩ nɑɑkɩ. Ɩlɛnɑ kɑ́ tili ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_6","008_14_6","JDG","14","6","6","Ḿpʋ́ɣʋ́ Tɑcɑɑ Feesuɣu tii Sɑmsɔŋ tɔɔ nɑ ɩ́ kpɑ-kɛ, nɑ ɩ́ cǝlɩ tǝkpɩɩ ɩsɩɩ pinɑɣɑ. Pǝ́cɔ́ ɩ tɔŋɑɣɑ niŋ kpɛtɛ kɛ́. Ɩ tɑ heeli ɩ nyǝ́mɑ kɛ mpi ɩ lɑpɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG14_7","008_14_7","JDG","14","7","7","Ɩlɛnɑ ɩ́ polo nɑ ɩ́ nɑ pɛɛlɔ pɑ́ lɑ́ fɑɑci. Pɛɛlɔ ɩnɩ ɩ kɑ wɛ-ɩ teu kɛ́. ");
INSERT INTO dop_vpl VALUES ("JG14_8","008_14_8","JDG","14","8","8","Pǝ lɑpɑ wɛɛ nɑɑlɛ, ɩlɛnɑ Sɑmsɔŋ mǝlǝɣɩ Timnɑ sɩ ɩ kpɑkǝɣɩ ɩ tɑŋ, nɑ ɩ́ hɛlɩ sɩ ɩ nɑɑkɩ tɔɣɔlɑɣɑ ŋkɑ ɩ kɑ kʋwɑ tɔ. Ɩlɛnɑ ɩ́ mɑɣɑnɑ tɩɩŋ sɛsɛkʋ kɛ tɔɣɔlɑɣɑ ŋkɛ kɑ tɑɑ nɑ sɛtɑsɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_9","008_14_9","JDG","14","9","9","Ɩlɛnɑ ɩ́ cosi sɛtɑɣɑ kɛ ɩ niŋ tɑɑ nɑ ɩ́ tɔkɩ nɑ ɩ́ tɛɛkɩ nɑ ɩ́ kɑtɩ ɩ nyǝ́mɑ nɑ ɩ́ hɑ-wɛ nɑ pɑ́ tɔɣɔ. Amɑ ɩ tɑ heeli-wɛ sɩ tɔɣɔlɑɣɑ kʋsǝpɑɣɑ tɑɑ kɛ́ ɩ hikɑ tɩɩŋ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_10","008_14_10","JDG","14","10","10","Ḿpʋ́ɣʋ́ cɛcɛ polɑ pɛɛlɔ tɛ, nɑ Sɑmsɔŋ lɑ ɑkpɑɣɑlɛ ɑcimɑ kɛ tǝnɑ, ɩsɩɩ ɩfepiyɑ lɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG14_11","008_14_11","JDG","14","11","11","Filiisi nyǝ́mɑ nɑ-ɩ, ɩlɛnɑ pɑ́ yɑɑ ɩfepiyɑ kɛ hiu nɑ nɑɑnʋwɑ sɩ pɑ́ nɑ-ɩ pɑ cɑkɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_12","008_14_12","JDG","14","12","12","Mpʋɣʋlɛ Sɑmsɔŋ sɩ: Mɑ sɩɩkɩ-mɛɣɛ ɩsǝsɩɩlɛ. Ye ɩ́ pǝsɑɑ nɑ ɩ́ kpeɣe-tɛɣɛ ɑcimɑ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ ɩnɛ ɩ tɑɑ, mɑɑ hɑ pɑɑ wei kɛ toko kʋcɑcɑɣɑnɑʋ nɑ ɑcimɑ nyǝŋ. ");
INSERT INTO dop_vpl VALUES ("JG14_13","008_14_13","JDG","14","13","13","Ye pǝ tɑɣɑ mpʋ pɑɑ mǝ tɑɑ wei ɩ kɑ hɑnɑ mɑɣɑ toko kʋcɑcɑɣɑnɑʋ nɑ ɑcimɑ nyǝŋ. Ntɛnɑ pɛlɛ pɑ́ cɔ-ɩ sɩ: Sɩɩ nyɑ́ ɩsǝsɩɩlɛ nɑ tǝ́ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_14","008_14_14","JDG","14","14","14","Ɩlɛnɑ Sɑmsɔŋ sɩ: Kʋtɔtɔɣɔm lɩɩnɑ tɔɣɔlʋ tɑɑ. Nɑ leleŋ nyǝm lɩɩnɑ toŋ tʋ tɑɑ. Pepeɣelɛ? Hɑlǝnɑ kʋyɛɛŋ tooso siki ɩfepiyɑ tɑ nyǝntɑ kʋcɔcɔtʋ. ");
INSERT INTO dop_vpl VALUES ("JG14_15","008_14_15","JDG","14","15","15","Ḿpʋ́ɣʋ́ pɑ tɔmɑ Sɑmsɔŋ ɑlʋ kɛ kʋyɑkʋ liɣiti nyǝŋkʋ wule sɩ: Puɣusi nyɑ́ pɑɑlʋ nɑ ɩ́ heeli-tʋɣʋ kʋkpekpeɣetʋ, tɔfɔ tɩɩ sɔ nyɑ́ nɑ nyɑ́ cɑɑ tǝyɑɣɑ nyǝ́mɑ kɛ kɔkɔ. Pǝ tɑɣɑ ɩ́ yɑɑ-tʋɣʋ sɩ ɩ́ hʋlǝsǝɣɩ-tʋ. ");
INSERT INTO dop_vpl VALUES ("JG14_16","008_14_16","JDG","14","16","16","Kɛlɛnɑ Sɑmsɔŋ ɑlʋ polo ɩ kiŋ nɑ wulɑ nɑ ɩ́ tɔmɩ-ɩ sɩ: Nyɑ́ luɣu tɑ sʋʋ-m. Pǝ́cɔ́ nn tɩɩ cɑɑkɩ-m. Pǝ tɔɔ kɛ́ n sɩɩ mɑ nyǝ́mɑ kɛ ɩsǝsɩɩlɛ nɑ ń tɑ́ heeli-m kʋkpekpeɣetʋ. Mpʋɣʋlɛ Sɑmsɔŋ sɩ: Hɑɩ, pɑɑ mɑ nyǝ́mɑ mɑɣɑmɑɣɑ mɑ tɑ heeli pɛlɛ, kɑcɑŋfɑnɑ nyɑ́ nɑ? ");
INSERT INTO dop_vpl VALUES ("JG14_17","008_14_17","JDG","14","17","17","Mpʋɣʋlɛ ɑlʋ mɩɩsǝnɑ-ɩ nɑ ɩsǝlʋm kɛ ḿpʋ́ɣʋ́ ɑcimɑ kʋyɛɛŋ tǝnɑ. Pǝ nɩɩ-ɩ, ɩlɛnɑ ɩ́ heeli-ɩ kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule. Ɩlɛnɑ ɑlʋ nɑ́ɑ́ tɑɣɑsɩ ɩ tɛ ɩfepiyɑ kɛ kpɑkpɑɑ. ");
INSERT INTO dop_vpl VALUES ("JG14_18","008_14_18","JDG","14","18","18","Mpʋɣʋlɛ ɩfepiyɑ polɑɑ nɑ pɑ́ heeli Sɑmsɔŋ kɛ kʋkpekpeɣetʋ nɑ pǝ́cɔ́ ilim tʋ sɩ: Pepe kǝlɑ tɩɩŋ nim kɛ leleŋ? Nɑ pepe kǝlɑ tɔɣɔlɑɣɑ kɛ toŋ? Ɩlɛnɑ ɩ cɔ sɩ: Ye ɩ́ tɑɑ hɑlǝnɑ mɑ ɑlʋ kɛ nɑʋ nyǝm, ɩ́ tɑɑ nyɩ kʋkpekpeɣetʋ ntɩ. ");
INSERT INTO dop_vpl VALUES ("JG14_19","008_14_19","JDG","14","19","19","Tǝnɑɣɑlɛ Tɑcɑɑ Feesuɣu tii Sɑmsɔŋ tɔɔ nɑ ɩ́ tɛɛ Asǝkɑlɔŋ nɑ ɩ́ kʋ ɑpɑlɑɑ hiu nɑ nɑɑnʋwɑ nɑ ɩ́ wɔɣɔsɩ pɑ tokonɑɑ, nɑ pɑ ɑcimɑ wontu, nɑ ɩ́ cɛlɑ mpɑ pɑ kpeɣɑ ɩsǝsɩɩlɛ tɔ. Ɩlɛnɑ ɩ́ mǝlɩ ɩ cɑɑ tɛ nɑ pɑ́ɑ́nɑ́. ");
INSERT INTO dop_vpl VALUES ("JG14_20","008_14_20","JDG","14","20","20","Mpʋɣʋlɛ pɑ hɑ Sɑmsɔŋ ɑlʋ kɛ ɩfepu wei ɩ sǝnɑ Sɑmsɔŋ kɛ ɩ ɑkpɑɣɑlɛ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","1","Pǝlɛ pǝ wɑɑlɩ kɛ́ Sɑmsɔŋ polɑ ɩ ɑlʋ nɑʋ kɛ kʋmtʋ wɑɑtʋ, nɑ ɩ́ kpɛnnɑ-ɩ pǝfɑtɛ. Ɩlɛnɑ ɩ́ tɔ sɩ: Mɑ sʋʋkɩ mɑ ɑlʋ nɑŋ tɑɑ. Amɑ ɩ yǝtɩ kisinɑ-ɩ, ");
INSERT INTO dop_vpl VALUES ("JG15_2","008_15_2","JDG","15","2","2","nɑ ɩ́ tɔ sɩ: Mɑ hʋʋwɑ sɩ nyɑ́ tɑɑ kpɑnɑ-ɩ kɛ́. Ɩlɛnɑ mɑ́ hɑ-ɩ nyɑ́ tɑɑpɑlʋ. Ɩlɛ ɩ neu tɑ kǝlɩ-ɩ teu? Kpɑɣɑ ɩlɛɣɛ kɔɣɔ lonte. ");
INSERT INTO dop_vpl VALUES ("JG15_3","008_15_3","JDG","15","3","3","Tǝnɑɣɑlɛ Sɑmsɔŋ pǝsǝnɑɑ sɩ: Ye mɑ lɛɛtɑ Filiisi nyǝ́mɑ kɛ ɩsɑɣɑtʋ kɛ pǝnɛntɑɑ pɑ́ tɑɑ tɔ sɩ mɑ cɑɑlɑ-wɛ yoo. ");
INSERT INTO dop_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Ḿpʋ́ɣʋ́ nyɔɣɔsɩ ɑnɑɑm nɔɣɔlʋ ɩ lɩɩwɑ Ɩsɛɣɛlɩ tɛtʋ tɑɑ kɛ́ wɑɑtʋ wei Pɑɑsǝnlɑɑ nyǝnɑɣɑ yǝlɑɑ tɔɔ tɔ. Mpʋ pǝ lɑpǝnɑ nɑ Yutɑ tɛtʋ ɩcɑtɛ Pɛtǝlɛhɛm ɑpɑlʋ nɔɣɔlʋ nɑ ɩ ɑlʋ nɑ ɩ pǝyɑlɑɑ nɑɑlɛ pɑ polo Mowɑpʋ tɛtʋ tɑɑ nɑ pɑ́ cɔɔsɩ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Pɑ yɑɑkɑɣɑ ɑpɑlʋ ɩnɩ sɩ Ilimɛlɛkɩ nɑ ɩ ɑlʋ sɩ Noyomii, nɑ ɩ pǝyɑlʋ kɑncɑɑlɑɣɑ nyǝŋ sɩ Mɑlɔŋ nɑ nɑɑlɛ nyǝŋ sɩ Kiliyoŋ. Pɑɑ kɛ́ Ɩfǝlɑtɑ lʋlʋɣʋ nyǝ́mɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Tǝnɑɣɑ Noyomii pɑɑlʋ Ilimɛlɛkɩ sǝpɑ nɑ pǝ́ yele ɩ nɑ ɩ pǝyɑlɑɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ḿpʋ́ɣʋ́ pɛlɛ pɑ kpɑɣɑ Mowɑpʋ ɑlɑɑ. Pɑ yɑɑ lɛlʋ sɩ Opɑ, nɑ lɛlʋ sɩ Luuti. Pɑ cɑɣɑ tǝnɑ ɩsɩɩ pɩɩsɩ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ɩlɛnɑ Mɑlɔŋ nɑ Kiliyoŋ pɛlɛ pɑ sɩ tɔtɔ, nɑ pǝ́ yele Noyomii kɛ ɩ tike. ");
INSERT INTO dop_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","7","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Noyomii nɩɩwɑ Mowɑpʋ tɑɑ sɩ Tɑcɑɑ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ ɩ́ hɑ-wɛɣɛ tɔɣɔnɑɣɑ. Ɩlɛnɑ ɩ́ kʋlɩ sɩ ɩ kpeŋ. Ɩ́ nɑ ɩ poolɑɑ nɑɑlɛ pɑ tʋ mpɑɑʋ sɩ pɑ mǝlǝɣǝnɑ Yutɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Ntɛnɑ Noyomii tɔ ɩ poolɑɑ mpɛ sɩ: Pɑɑ wei ɩ́ kpe ɩ cɑlɑɣɑ. Tɑcɑɑ ɩ́ lɑ-mɛɣɛ kʋpɑntʋ ɩsɩɩ mǝ lɑpʋ mɑ nɑ mɑ sɔlʋnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Ɩsɔ ɩ́ hɑ-mɛɣɛ ɑpɑlɑɑ nɑ ɩ́ hɛɛsɩ pɑ tɛɛsɩ tɑɑ. Ɩlɛnɑ Noyomii lɑ-wɛɣɛ pǝlɑpɑ wulee nɑ pɛlɛ pɑ́ tʋlɩ nɔɔsɩ nɑ pɑ́ wii tǝkpoo. ");
INSERT INTO dop_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ḿpʋ́ɣʋ́ pɑ tɔmɑ pɑ pɑŋ sɩ: Aɑɩ yoo, tɩɩ tǝŋɩ-ŋ kɛ́ nɑ tǝ́ polo nyɑ́ nyǝ́mɑ tɛ. ");
INSERT INTO dop_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Tǝnɑɣɑ Noyomii cɔwɑ sɩ: Ɩ́ mǝlɩ mɑ pɛɛlɑɑ. Pepe tɔɔ kɛ́ ɩ́ tǝŋǝɣɩ-m? Piyɑ tɑ kɑɑsɩ mɑ tɑɑ sɩ ɩ́ kɑ́ sɑɑ-sɩ. ");
INSERT INTO dop_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Mpʋ tɔ, ɩ́ mǝlɩ. Mɑ sulɑ pɩɩʋ, mɑ kɑɑ tɑsɑ sɑɑʋ. Nɑ ye mɑ tɩɩ tɛɛlǝɣɩ pǝyɑɣɑ ntɛnɑ mɑ́ kpǝtǝnɑ ɑpɑlʋ kɛ ɑhoo ɑnɛ ɑ mɑɣɑmɑɣɑ, nɑ mɑ́ lʋlɩ ɑpɑlʋpiyɑ, ");
INSERT INTO dop_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","ɩlɛ ɩ́ yele ɑpɑlɑɑ sɑɑʋ ntɛ́ nɑ ɩ́ tɑŋ mpɛ ɩnɩ nɑ pɑ́ lɑ yǝlɑɑ nɑ ɩ́ sɑɑ-wɛ? Aɑɩ, mɑ pɛɛlɑɑ, mɑ lɑŋlɛ wɑkǝlǝnɑ-mɛɣɛ. Mpi pǝ tɔɔ tɔ Tɑcɑɑ hʋlɑ-m mpǝle kɛ́. ");
INSERT INTO dop_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Ɩlɛnɑ Noyomii poolɑɑ mpɛ pɑ tɑsɑ nɔɔsɩ tʋlʋɣʋ tɔtɔ nɑ pɑ́ wii sɔsɔm. Ḿpʋ́ɣʋ́ wei pɑ yɑɑ sɩ Opɑ tɔ ɩ lɑpɑ ɩ pɑŋ kɛ́ pǝ lɑpɑ wulee nɑ ɩ́ mǝlɩ kpente. Amɑ Luuti nɑ́ nyɔkǝlǝnɑ Noyomii. ");
INSERT INTO dop_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Tǝnɑɣɑlɛ Noyomii tɔmɑ Luuti sɩ: Nyǝnɩ, nyɑ́ tɑɑpɑlʋ mǝlɑ ɩ nyǝ́mɑ nɑ ɩ ɑtɛtʋnɑɑ pɑ cɔlɔ, nyɑɑ mǝlɩ mpʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ntɛnɑ Luuti cɔ-ɩ sɩ: Tɑɑ cɑɑlɩ-m sɩ mɑ́ yele-ŋ nɑ mɑ́ mǝlɩ. Nyɑ́ tǝpote mɑ tǝpote, nyɑ́ tǝcɑɣɑlɛ mɑ nyǝntɛ, nyɑ́ piitim kɑ́ wɛɛ mɑ nyǝm, nyɑ́ Ɩsɔ kɑ́ wɛɛ mɑ nyǝŋ. ");
INSERT INTO dop_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Timpi n kɑ sɩ tɔ tǝnɑɣɑ mɑɑ sɩ nɑ pɑ́ pi-m. Ye mɑ nɑ-ŋ tǝ yɑwɑ nɑ pǝ́ tɑ́ kɛnɑ sǝm pɑɑsi. Tɑcɑɑ ɩ́ lɑnɑ-m ɩsǝnɑ ɩ sɔɔlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Noyomii nɑwɑ sɩ Luuti sɛɛsɑ ɩsǝlɛ sɩ ɩ kɑ́ tǝŋɩ-ɩ kɛ́ ɩ kɑ́ tǝŋɩ-ɩ, ɩlɛnɑ ɩ́ yele-ɩ cɑɑlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ɩlɛnɑ pɑ́ kpɛntɩ nɑ pɑ́ tɛɛ Pɛtǝlɛhɛm. Noyomii pɑ tɑlɑɑ ɩlɛnɑ ɩcɑtɛ tǝnɑ ɑlɑɑ yǝpǝlǝɣɩ ɩ tɔm sɩ: Ɩsɩɩ Noyomii kɛlɛ? ");
INSERT INTO dop_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ntɛnɑ ɩ nɔɣɔ tǝkpɑʋ sɩ: Ɩ́ tɑɑ yɑɑ-m Noyomii, ɩ́ yɑɑ-m Mɑlɑ. Mpi tɔ, Tomɑ tǝnɑ tʋ wɑkǝlɑ mɑ lɑŋlɛ kɛ sɔsɔm kɛ́. ");
INSERT INTO dop_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Mɑ tɛɛkɑɣɑ wɑɑtʋ wei tɔ pǝ cɑɣɑnɑ-m kɛ́. Ɩlɛnɑ Tɑcɑɑ mǝlǝɣǝnɑ-m mɑ niŋ kɑkpɑsɩ, ɩ lɑŋlɛ tɑ hɛɛnɑ-m. Tomɑ tǝnɑ tʋ mɑpɑ-m kpɑ́tʋ́ɣʋ́, ɩlɛ pepe tɔɔ kɛ́ ɩ́ tɑsǝɣɩ-m Noyomii kɛ yɑɑʋ? ");
INSERT INTO dop_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ɩsǝnɑ Noyomii nɑ ɩ poolu Mowɑpʋ tʋ Luuti pɑ mǝlʋɣʋ lɑpɑ tɔɣɔlɛ. Pɑ tɑlɑ Pɛtǝlɛhɛm tɑɑ ɩlɛ pɑ cɑɑlǝɣɩ kʋmtʋ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Noyomii pɑɑlʋ yʋlʋ nɔɣɔlʋ ɩ kɑ wɛnnɑ. Apɑlʋ ɩnɩ ɩ sʋʋ toŋ kɛ́ nɑ ɩ́ wɛnɑ nyʋɣʋ. Pɑ yɑɑkɑɣɑ-ɩ sɩ: Poosi nɑ ɩ kɛ́ Ilimɛlɛkɩ lʋlʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Luuti tɔmɑ Noyomii sɩ: Mɑɑ kpɑ tɑɑlɛ nɑ mɑ́ cɑlǝsɩ kumkum kɛ́ kʋpɑŋ nɔɣɔlʋ ɩ hɑlǝm tɑɑ. Ntɛnɑ ɩ́ cɔ-ɩ sɩ: Polo, mɑ pɛɛlɔ. ");
INSERT INTO dop_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ɩlɛnɑ Luuti kpɑ tɑɑlɛ nɑtǝlɩ tǝ tɑɑ nɑ ɩ́ tǝŋǝɣɩ kʋntɑɑ nɑ ɩ́ cɑlǝsǝɣɩ. Sɛsɛ ɩlɛ Poosi tɑɑlɛ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ḿpʋ́ɣʋ́ kʋyɑkʋ ŋkʋ Poosi kpɑ tɑɑlɛ kɛ kʋntɑɑ cɔlɔ nɑ ɩ́ sɛɛ-wɛ sɩ: Tɑcɑɑ ɩ́ wɛɛ mǝ wɑɑlɩ. Nɑ pɛlɛ pɑ́ tisi sɩ: Ɩsɔ ɩ́ kooli-ŋ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Mpʋɣʋlɛ Poosi pɔɔsɑ tǝmlɛ tʋ wei ɩ feŋiɣi kʋntɑɑ tɔɔ tɔ sɩ: Le tʋ kɛ ɑsɑɑlʋ ɩnɛ? ");
INSERT INTO dop_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Kɛlɛnɑ tǝmlɛ tʋ cɔ-ɩ sɩ: Mowɑpʋ tʋ kɛ́, ɩ́ nɑ Noyomii pɑ kɔmnɑ. ");
INSERT INTO dop_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ɩ sǝlǝmɑ-tʋɣʋ sɩ ɩ tǝŋǝɣɩ kʋntɑɑ nɑ ɩ́ cɑlǝsɩ nɑ ɩ́ tɔɔsǝɣɩ lɔɔtʋ nti nti pǝ sɔɔwɑ tɔ. Hɑtoo tɑnɑŋ tɛɛ ɩ kɔm nɑ ɩ́ luŋ tɔ nɔɔnɔɔ tike ntɛ́ ɩ hɛɛsɑ tɔm kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Ɩlɛnɑ Poosi tɑsɑ Luuti kɛ lɑɣɑtʋ sɩ: Tɑɑ kʋlɩ sɩ ń puki nɔɣɔlʋ tɑɑlɛ tɑɑ kɛ cɑlǝsʋɣʋ. Cɑɣɑ mɑ tǝmlɛ nyǝ́mɑ ɑlʋnyǝmɑ kiŋ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Nyǝnǝɣɩ timpi pɑ kʋŋ tɔ nɑ ń tǝŋ pɑ wɑɑlɩ. Mɑ heelɑ mɑ tǝmlɛ nyǝ́mɑ ɑpɑlʋnyǝmɑ sɩ pɑ́ tɑɑ kɑɣɑtɩ-ŋ. Ye lʋkɔtʋ ɩ́ kpɑ-ŋ n polo hǝyɑɣɑ tɑɑ nɑ ń nyɔɔ lʋm mpi pɑ́ luwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Tǝnɑɣɑlɛ Luuti hǝntɑ Poosi kɛ ɑtɛ nɑ ɩ́ tɔ sɩ: Ɩsǝnɑɣɑ pǝ lɑpɑ nɑ ń pɑɑsǝɣǝnɑ-m nɑ ń lɑkɩ-m kʋpɑntʋ, ɑnɩ mɑɣɑ mʋʋlʋ? ");
INSERT INTO dop_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Kɛlɛnɑ Poosi cɔ-ɩ sɩ: Pɑ kɛɛsɑ-m pǝ tǝnɑ mpi n lɑpɑ nyɑ́ pɑŋ kɛ́ nyɑ́ pɑɑlʋ sǝm wɑɑlɩ tɔ. Nɑ ɩsǝnɑ n yelɑ nyɑ́ cɑɑ nɑ nyɑ́ too nɑ nyɑ́ tɛtʋ nti tǝ tɑɑ pɑ lʋlɑ-ŋ tɔ, nɑ ń polo yǝlɑɑ mpɑ n tɑɑ nyɩ tɔ pɑ tɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ wei n kɔmɑ sɩ n tʋɣɩ kpʋlʋɣʋ tɔ ɩ́ lɛɛtɩ-ŋ mpi n lɑpɑ tɔ tǝcɩʋcɩʋ. ");
INSERT INTO dop_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ɩlɛnɑ Luuti cɔ sɩ: Hɑɩ, mɑ cɛ n pɑɑsǝnɑ-m teu kɛ́. Mpi tɔ, nyɑ́ hɛɛsǝnɑ mɑ lɑŋlɛ nɑ ń yɔɣɔtǝnɑ-m ɩsɩɩ n kɑ nyǝmɑ-m. Pɑɑ nɑ mpʋ tɔ, mɑ tɑ hɑŋnɑ nyɑ́ tǝmlɛ tʋ nɔɣɔlʋ. ");
INSERT INTO dop_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Pǝ kɔmɑ nɑ pǝ́ tɑlɑ tɔɣɔʋ ɩlɛnɑ Poosi tɔ Luuti sɩ: Kɔɔ tǝ tɔɣɔ. Cosiɣi tɔɣɔnɑɣɑ nɑ ń liiki tuusi tɑɑ. Ɩlɛnɑ Luuti cɑɣɑ kʋntɑɑ cɔlɔ, nɑ pɑ́ cosi-ɩ pee wenɑ pɑ toŋɑɑ tɔ nɑ ɩ́ tɔɣɔ nɑ ɩ́ hɑɣɑ nɑ pǝ́ kɑɑsɩ nɑ ɩ́ sɩɩ. ");
INSERT INTO dop_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ɩlɛnɑ ɩ́ kʋlɩ cɑlǝsʋɣʋ, nɑ Poosi heeli ɩ tǝmlɛ nyǝ́mɑ sɩ: Ɩ́ yele nɑ Luuti cɑlǝsɩ cɑmnɑɑ kilɑ tɔtɔ, ɩ́ tɑɑ tɑŋɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ɩ́ yeki lɔɔtʋ lɛntɩ nɑ ɩ́ tɔɔsǝɣɩ, ɩ́ tɑɑ kɑlǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ḿpʋ́ɣʋ́ Luuti cɑlǝsɑ tɑɑlɛ ńtɛ́ tǝ tɑɑ hɑlǝnɑ tɑɑnɑɣɑ. Ɩlɛnɑ ɩ́ mɑ́ nɑ pee mɑɣɑnɑ ɩsɩɩ kiloonɑɑ hiu nɑ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Nɑ ɩ́ kpɑɣɑ nɑ ɩ́ kpeenɑ nɑ ɩ́ hʋlɩ ɩ pɑŋ. Ɩlɛnɑ ɩ́ lǝsɩ tɔɣɔnɑɣɑ ŋkɑ kɑɑ kɑɑsɑɑ tɔ nɑ ɩ́ cɛlɛ-ɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ḿpʋ́ɣʋ́ Noyomii pɔɔsɑ-ɩ sɩ: Leɣe n cɑlǝsɑ sɑŋɑ? Awe tɑɑlɛ kɛ n kpɑwɑ? Ɩsɔ ɩ́ kooli kʋpɑntʋ kɛ wei ɩnɩ ɩ pɑɑsǝnɑ-ŋ tɔ. Ɩlɛnɑ Luuti sɩ: Pɑ yɑɑ-ɩ sɩ Poosi. ");
INSERT INTO dop_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ḿpʋ́ɣʋ́ Noyomii tɔmɑ sɩ: Mɑ nyǝ́mɑ sɩ Tɑcɑɑ lɑpɑ weesiŋ nyǝ́mɑ tɑɣɑ kʋpɑntʋ nɑ tɑ sǝtɑɑ tɔtɔ. Ɩsɔ ɩ́ kooli ɑpɑlʋ ɩnǝɣɩ kʋpɑntʋ. Apɑlʋ ɩnɩ ɩ kɛ́ tɑ́ lʋlʋɣʋ nyǝ́mɑ tɑɑ lɛlʋ wei ɩ pǝsǝɣɩ nɑ ɩ́ pɑɑsǝnɑ-tʋ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Kɛlɛnɑ Luuti sɩ: Hɑlɩ ɑpɑlʋ ɩnɩ ɩ heelɑ-m kɛ́ sɩ mɑ́ tǝŋǝɣɩ ɩ tǝmlɛ nyǝ́mɑ nɑ mɑ́ cɑlǝsǝɣɩ, hɑlǝnɑ ɩ kʋmtʋ nɑ tǝ tɛm. ");
INSERT INTO dop_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ntɛnɑ Noyomii sɩ: Pǝ wɛ teu mɑ pɛɛlɔ, tǝŋ mpɛ. Ye nɔɣɔlʋ tɑɑlɛ tɑɑ pɑ tɔɣɔnǝɣɩ-ŋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ḿpʋ́ɣʋ́ Luuti sɑɑlɑ Poosi tǝmlɛ nyǝ́mɑ kiŋ kɛ mpʋ nɑ ɩ́ cɑlǝsǝɣɩ, hɑlǝnɑ kʋmtʋ tɛ́. Nɑ ɩ́ nɑ ɩ pɑŋ pɑ́ wɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ḿpʋ́ɣʋ́ Noyomii tɔmɑ ɩ poolu sɩ: Mɑ pɛɛlɔ, mɑ cɑɑ kɛ́ sɩ ń hiki tǝcɑɣɑlɛ nɑ ń hɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ntɔŋ ń nyǝmɑ́ sɩ nyɑnɑ Poosi wei ɩnɩ ɩ tǝmlɛ nyǝ́mɑ ɩ́ kʋmɑ tɔ ɩ kɛ́ tɑ́ yʋlʋ kɛ́. Tɑɑnɑɣɑ kɑnɛ pɑ mɑkɩ ɩ tɔɣɔnɑɣɑ kɛ kɑtɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Mpʋ tɔ, sɔ lʋm, tʋ tulɑɑlʋ, suu nyɑ́ wontu kʋpɑntʋ. Ɩlɛnɑ ń tii kɑtɑɣɑ tɑɑ. Amɑ yele nɑ ɩ́ tɛ tɔɣɔʋ ɩlɛnɑ ɩ́ nɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Pǝlɛ pǝ wɑɑlɩ ɩlɛnɑ ń feŋ nɑ ń nɑ́ ɩ tǝhǝntǝlɛ, ɩlɛnɑ ń kɛɛlɩ ɩ nɔɔhɛɛ tɔɔ nɑ ń hǝntɩ. Ɩ mɑɣɑmɑɣɑ ɩ kɑ́ heelinɑ-ŋ nti ń kɑ lɑ tɔ. cɑɑkɩ sɩ Poosi ɩ́ hɔmɩ-ɩ leelu. ");
INSERT INTO dop_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","6","Ḿpʋ́ɣʋ́ Luuti cɔwɑ sɩ: Mɑɑ lɑ ɩsɩɩ n heeluɣu-m tɔ. Ɩlɛnɑ ɩ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Poosi tɔɣɑɑ nɑ ɩ́ nyɔɔ nɑ ɩ lɑŋlɛ hʋlʋmɩ, ɩlɛnɑ ɩ́ polo ɩ́ hǝntɩ tɔɣɔnɑɣɑ huɣule kite. Ntɛnɑ Luuti polo tǝhɛɛ kɛ wɑɑtʋ wei ɩ toowɑ tɔ nɑ ɩ́ kɛɛlɩ ɩ nɔɔhɛɛ tɔɔ nɑ ɩ́ hǝntɩ. ");
INSERT INTO dop_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Apɑlʋ ɩnɩ ɩ nyɑmɑ nɑ ɩ́ fe ɑhoo hɛkɑ nɑ ɩ́ nyǝnɩ ɩlɛnɑ ɩ́ mɑɣɑnɑ ɑlʋ hǝntɑ ɩ nɔɔhɛɛ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Ɩlɛnɑ ɩ́ pɔɔsɩ sɩ: Aweɣe-ɩ? Ntɛnɑ Luuti cɔ sɩ: Mɑɣɑ nyɑ́ pɛɛlɔ Luuti kɛ́. Hɑɩ, wɑɑsɩ-m. Mpi tɔ, nyɑ́ wɛnnɑ mpɑɑʋ sɩ ń yɑ-m. ");
INSERT INTO dop_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ɩlɛnɑ Poosi tɔmɩ-ɩ sɩ: Tɑcɑɑ ɩ́ kooli-ŋ kʋpɑntʋ, mɑ pɛɛlɔ. Nyɑ́ yɑɑsi kɑntǝkɑɣɑ nyǝŋ ɩnɛ ɩ hʋlǝɣǝnɑ ɩsǝnɑ n mɑtǝnɑ nyɑ́ pɑŋ yǝlɑɑ tɔ nɑ pǝ́ kǝlɩ kɑncɑɑlɑɣɑ nyǝŋ. Mpi tɔ, n tɑ pɛɛkɩ ɩfepiyɑ liɣitee nyǝ́mɑ yɑɑ kʋnyɔntʋnɑɑ. ");
INSERT INTO dop_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Mpʋ tɔ, mɑ pɛɛlɔ tɑɑ nǝɣǝsɩ. Mpi n cɑɑkɩ tɔ mpǝɣɩ mɑɑ lɑ-ŋ. Mpi tɔ, ɩcɑtɛ yǝlɑɑ tǝnɑ nyǝ́mɑ sɩ n kɛ́ ɑlʋ kʋpɑŋ. ");
INSERT INTO dop_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Tɑmpɑnɑ pǝ wɛɛ sɩ mɑ́ yɑ-ŋ yɑɑ, ɩlɛ nɔɣɔlʋ nɑ nyɑ́ pɑŋ pɑ lʋlʋɣʋ kǝlɑ kɑɑʋ kɛ mɑ. ");
INSERT INTO dop_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Sʋʋ cǝnɛ, ye pǝ femɑ mɑɑ pɔɔsɩ-ɩ nɑ mɑ́ nɑ́ sɩ ɩ kɑ́ yɑ-ŋ yɑɑ ɩsǝnɑ? Ye ɩ luɣu fɛɩ ɩlɛ, mɑ tuukinɑ Tɑcɑɑ sɩ mɑɑ yɑ-ŋ. Hǝntɩ mpʋ nɑ pǝ nyɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ɩlɛnɑ Luuti hǝntɩ ḿpʋ́ɣʋ́ Poosi nɔɔhɛɛ tɛɛ. Poosi tɑɑ cɑɑkɩ sɩ nɔɣɔlʋ ɩ́ nyɩ sɩ Luuti kɔmɑ kɑtɑɣɑ tɑɑ. Pǝ tɔɔ kɛ́ ɩ kʋsɑ-ɩ sɑɑ wei pǝ wɛ tǝŋmɛntɛŋmɛntɛ tɔ sɩ nɔɣɔlʋ ɩ́ tɑɑ nyǝmɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ɩlɛnɑ Poosi tɔmɩ-ɩ sɩ: Hɛtɩ nyɑ́ tɛkɛntɛ nɑ ń tɔkɩ-ɩ teu. Ɩlɛnɑ ɩ́ mɑɣɑsɩ tɔɣɔnɑɣɑ pee ɩsɩɩ kiloonɑɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ nɑ ɩ́ sʋkɩ-ɩ. Ɩlɛnɑ ɩnɩ ɩ kpɑ ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Luuti mǝlɑ ɩ pɑŋ cɔlɔ ɩlɛnɑ ɩ́ pɔɔsɩ-ɩ ɩ mpɑɑʋ ɑlɑɑfǝyɑ tɔɔ. Ḿpʋ́ɣʋ́ Luuti kɛɛsɑ-ɩ ɩsǝnɑ ɑpɑlʋ ɩnɩ ɩ pɑɑsǝnɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Nɑ ɩ́ tɑsɑ sɩ: Hɑlɩ ɩnɩ ɩ hɑnɑ-m tɔɣɔnɑɣɑ pee ɑnɛ ɑ tǝnɑ sɩ pǝ fɛɩ sɩ mɑ́ mǝlɩ nyɑ́ kiŋ kɛ niŋ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Tǝnɑɣɑlɛ Noyomii sɩ: Mɑ pɛɛlɔ cɑɣɑ tǝpɑmm, nɑ ń nɑ́ ɩsǝnɑ pɩɩ tɛɛsǝnɑ tɔ. Mpi tɔ, ye ɑpɑlʋ ɩnɛ ɩ tɑ nɑ tɔm tǝnɛ tǝ tǝnɑɣɑ kɛ sɑŋɑ ɩɩ hɛɛsǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ḿpʋ́ɣʋ́ Poosi lɩɩ nɔnɔɣɔ timpi pɑ hʋʋkɩ tɔm tɔ nɑ ɩ́ cɑɣɑ. Ɩlɛ Ilimɛlɛkɩ lʋlʋɣʋ tʋ wei ɩ tɔm ɩ kɑ yɔɣɔtɑɑ sɩ pɩɩ wɛɛ sɩ ɩ́ wɑɑsɩ sǝtʋ tǝyɑɣɑ yǝlɑɑ tɔ ɩ tɛɛ kɛlɛ. Ɩlɛnɑ ɩ́ yɑɑ-ɩ sɩ: Apɑŋ nyɑ́, kɔɔ ń cɑɣɑ. Ɩlɛnɑ ɑpɑlʋ ɩnɩ ɩ polo. ");
INSERT INTO dop_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Ḿpʋ́ɣʋ́ Poosi sǝŋsɑ ɩcɑtɛ sɔsɑɑ kɛ nɑɑnʋwɑ. Pɑ kɔmɑ nɑ pɑ́ cɑɣɑ ");
INSERT INTO dop_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","ɩlɛnɑ ɩ́ tɔ wei ɩnɩ pɩɩ wɛɛ sɩ ɩ wɑɑsɩ sǝtʋ tǝyɑɣɑ yǝlɑɑ tɔ sɩ: Noyomii wei ɩ lɩɩnɑ Mowɑpʋ tɔ ɩ pɛɛtǝɣɩ tɑ́ yʋlʋ Ilimɛlɛkɩ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ɩlɛ mɑ heeliɣi-ŋ sɩ, ń yɑ-tǝɣɩ ɩcɑtɛ nyǝ́mɑ nɑ sɔsɑɑ pɑ ɩsɛntɑɑ. Ye n kɑ yɑ-tɩ ɩlɛ n yɑ-tɩ. Ye nyɑ́ luɣu fɛɩ ɩlɛ n heeli-m nɑ mɑ́ cɛkǝnɑ. Mpi pǝ tɔɔ tɔ, nyɑɣɑlɛ nɔɣɔ tʋ, nyɑ́ wɑɑlɩ kɛ́ mɑ́. Ntɛnɑ ɩ́lɛ́ ɩ cɔ-ɩ sɩ: Tɔʋ, mɑ nɩɩwɑ. ");
INSERT INTO dop_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Kɛlɛnɑ Poosi sɩ ye n kɑ yɑ-tǝɣɩ Noyomii niŋ tɑɑ ɩlɛ n kpɛnnɑ sɔlʋ ɩnɩ ɩ leelu Mowɑpʋ tʋ Luuti nɑ ń hɔ. Pǝ́ tɑɑ kɔɔ nɑ sǝtʋ hǝtɛ sɑɑlɩ nɑ ɩ tɛtʋ pǝsɩ nɔɣɔlʋ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Mpʋɣʋlɛ ɑpɑlʋ ɩnɩ sɩ: Ye mpʋ mɑ mɑɣɑmɑɣɑ mɑ kɑɑ pǝsɩ nɑ mɑ́ yɑ-tɩ. Pǝ́ tɑɑ kɔɔ nɑ mɑ wɛnɑʋ sɑɑlɩ. Mpʋ tɔ, yɑ-tɩ nɑ mɑ nɔɣɔ, mɑ kɑɑ pǝsɩ. ");
INSERT INTO dop_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","Ɩlɛnɑ ɩ́ wɔɣɔsɩ ɩ ntɑŋkpɑtɛ nɑ ɩ́ cɛlɑ Poosi. Pɩɩ wɛ lɔŋtɑɑ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ kiŋ tɔ, ye pɑ yɑpɑ pʋlʋ yɑɑ pɑ lɑɣɑsɑ tɛtʋ ḿpʋ́ɣʋ́ pɑ lɑkɑɣɑ sɩ pǝ́ hʋ́lɩ́ sɩ pǝ tɛmɑ. ");
INSERT INTO dop_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ntɛnɑ Poosi tɔ sɔsɑɑ nɑ sɑmɑɑ sɩ: Mɛɣɛlɛ mɑ ɑseetɑ nyǝ́mɑ kɛ sɑŋɑ sɩ mɑ yɑpɑ Noyomii niŋ tɑɑ kɛ́ pǝ tǝnɑ mpi pǝ kɛ́ Ilimɛlɛkɩ nɑ ɩ pǝyɑlɑɑ Kiliyoŋ nɑ Mɑlɔŋ pɑ nyǝm tɔ, ");
INSERT INTO dop_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","nɑ mɑ́ kpɛnnɑ Mɑlɔŋ leelu Mowɑpʋ tʋ Luuti nɑ mɑ́ hɔ nɑ mɑ́ kʋsɩ sǝtʋ hǝtɛ. Pǝ́ tɑɑ kɔɔ nɑ tǝ́ sɑɑlɩ yem kɛ́ ɩ ɩcɑtɛ kʋlʋllɛ nɑ ɩ yǝlɑɑ tɑɑ. Mɛɣɛlɛ ɑseetɑ nyǝ́mɑ kɛ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Mpʋɣʋlɛ nɔnɔɣɔ yǝlɑɑ nɑ sɔsɑɑ pɑ tɔmɑ sɩ: Tǝ kɛ́ ɑseetɑ nyǝ́mɑ. Tɑcɑɑ ɩ́ kooli kʋpɑntʋ kɛ ɑlʋ wei ɩ sʋʋkɩ nyɑ́ tǝyɑɣɑ kɛ ɩsǝntɔ tɔ, nɑ ɩ́ nǝɣǝsǝnɑ ɩsɩɩ Lɑsɛɛlɩ nɑ Leyɑɑ mpɑ pɑ lʋlɑ Ɩsɛɣɛlɩ piitim yǝlɑɑ tɔ. Hʋ́lɩ́ nyɑ́ toŋ kɛ nyɑ́ lʋlʋɣʋ tɑɑ nɑ ń lɑ nɑ nyɑ́ hǝtɛ yɑɑ Pɛtǝlɛhɛm. ");
INSERT INTO dop_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Piitim mpi Tɑcɑɑ kɑ́ hɑnɑ-ŋ nɑ ɑsɑɑlʋ ɩnɛ tɔ, pǝ huki nɑ pǝ́ nǝɣǝsǝnɑ ɩsɩɩ Yutɑ nɑ ɩ ɑlʋ Tɑmɑɑ pɑ pǝyɑlʋ Pɛlɛsɩ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ḿpʋ́ɣʋ́ Poosi kpɑɣɑ Luuti nɑ ɩ́ nɑ-ɩ pɑ́ kpǝtɩ nɑ Tɑcɑɑ yele nɑ ɩ́ lɑ teu nɑ ɩ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ḿpʋ́ɣʋ́ Pɛtǝlɛhɛm ɩcɑtɛ ɑlɑɑ sɛɛ Noyomii nɑ pɑ́ tɔŋ sɩ: Tǝ sɑmɑ Ɩsɔ ɩsɩɩ ɩ hɑ-ŋ yʋlʋ wei ɩ kɑ wɑɑsɩ-ŋ tɔ. Pǝyele ɩ hǝtɛ kɑ́ yɑɑ Ɩsɛɣɛlɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Pǝyɑɣɑ kɑnɛ kɑɑ kpɑɑsǝnɑ nyɑ́ toŋ nɑ kɑ́ te-ŋ nyɑ́ kpɑtǝlɑɣɑ wɑɑtʋ. Pǝ tɑɣɑ pʋlʋ, nyɑ́ poolu wei ɩ sɔɔlɑ-ŋ teu nɑ ɩ́ tɛɛ-ŋ ɑpɑlʋpiyɑ nɑɑtosompɔɣɔlɑɣɑ tɔ ɩnɩ ɩ lʋlʋnɑ-kɛ. ");
INSERT INTO dop_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ɩlɛnɑ Noyomii mʋ-kɛ nɑ ɩ́ nʋkɩ-kɛ nɑ ɩ́ pɑɑsǝnɑ-kɛ ɩsɩɩ ɩ kʋlʋlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Mpʋɣʋlɛ pɑ cɔlɔ ɑlɑɑ hɑ-kɛɣɛ hǝtɛ sɩ: Opɛtɩ, nɑ pɑ́ tɔŋ sɩ pɑ lʋlɑ Noyomii kɛ ɑpɑlʋpǝyɑɣɑ. Tɑfiiti cɑɑ Sesee cɑɑ kɛlɛ Opɛtɩ. ");
INSERT INTO dop_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Tɑfiiti cɑɑnɑɑ lʋlʋɣʋ nyǝ́mɑ ntɔ, pǝ kpɑɣɑʋ Pɛlɛsɩ tɔ. Pɛlɛsɩ lʋlʋnɑ Hɛsǝlɔŋ, ");
INSERT INTO dop_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","nɑ Hɛsǝlɔŋ lʋlɩ Lɑm, nɑ Lɑm lʋlɩ Aminɑtɑpɩ, ");
INSERT INTO dop_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","nɑ Aminɑtɑpɩ lʋlɩ Nɑsɔŋ, nɑ Nɑsɔŋ lʋlɩ Sɑlǝmɑ, ");
INSERT INTO dop_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","nɑ Sɑlǝmɑ lʋlɩ Poosi, nɑ Poosi lʋlɩ Opɛtɩ, ");
INSERT INTO dop_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","nɑ Opɛtɩ lʋlɩ Sesee, nɑ Sesee lʋlɩ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Apɑlʋ nɔɣɔlʋ ɩ kɑ wɛnnɑ Sufɩ tɛtʋ tɑɑ kɛ́ Ɩfǝlɑyim pʋɣʋ tɑɑ, nɑ pɑ́ yɑɑkɩ-ɩ sɩ Ɩlǝkɑnɑ. Pɑ yɑɑ Ɩlǝkɑnɑ cɑɑ sɩ Yelowɑm, nɑ Yelowɑm cɑɑ sɩ Ilihu, nɑ Ɩlihu cɑɑ sɩ Tohu, nɑ Tohu cɑɑ sɩ Sufɩ. Ɩlɛɣɛ Ɩfǝlɑyim tʋ. ");
INSERT INTO dop_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Ɩlǝkɑnɑ ɩnɩ ɩ ɑlɑɑ kɑ wɛ nɑɑlɛɣɛ. Pɑ yɑɑkɩ lɛlʋ sɩ Anɑ nɑ lɛlʋ sɩ Peninɑ. Peninɑ kɑ wɛnɑ piyɑ. Amɑ Anɑ nɑ́ fɛɩnɑ. ");
INSERT INTO dop_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Apɑlʋ ɩnɩ ɩ kpɑɑkɑɣɑ Ɩsɔ sɛɛʋ kɛ Silo kɛ pɑɑ pǝnɑɣɑ ŋkɑɣɑ, nɑ ɩ́ hɑɑkɩ Tomɑ tǝnɑ tʋ Tɑcɑɑ kɛ kʋhɑɑŋ. Nɑ Ilii pǝyɑlɑɑ Hofini nɑ Pɛnhɑsɩ pɑɑ kɛnɑ Tɑcɑɑ kɔtǝlɑɑ kɛ wɑɑtʋ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Ye kʋyɑŋku Ɩlǝkɑnɑ ɩ́ lɑpɑ kɔtɑɣɑ, ɩ hɑɑkɩ ɩ ɑlʋ Peninɑ nɑ ɩ pǝyɑlɑɑ nɑ ɩ pɛɛlɑɑ kɛ cǝkɑ cǝkɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Ɩlɛnɑ ɩ́ hɑ Anɑ ɩlɛɣɛ cǝkɑsɩ nɑɑlɛ. Mpi tɔ, pɑɑ nɑ Tɑcɑɑ lɑpɑ-ɩ kɑɑlʋlɑɣɑ tɔ, ɩ luɣu kɑ sʋʋ-ɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Ɩ yɔtɔŋ nɑ́ tʋʋkɑɣɑ-ɩ kɛ́ sɩ pǝ́ hɑŋɩ-ɩ sɩ Tɑcɑɑ lɑpɑ-ɩ kɑɑlʋlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Ḿpʋ́ɣʋ́ pɩɩ wɛ pɑɑ pǝnɑɣɑ ŋkɑ. Pɑɑ wɑɑtʋ wei kɛ́ pɑ kpɑɑkɩ Tɑcɑɑ tǝyɑɣɑ tɑɑ te, Peninɑ tʋʋkɑɣɑ-ɩ ḿpʋ́ɣʋ́. Ɩlɛnɑ ɩ́ wiiki nɑ ɩɩ sɑŋ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Nɑ ɩ pɑɑlʋ Ɩlǝkɑnɑ nɑ́ɑ́ tɔmɩ-ɩ sɩ: Pepe tɔɔ kɛ́ nyɑ́ lɑŋlɛ wɑkǝlǝɣɩ, nɑ ń wiiki nɑ ń kisiɣi tɔɣɔnɑɣɑ kɛ mpʋ? Mɑ tɑ kǝlɩ-ŋ piyɑ nɑɑnʋwɑ? ");
INSERT INTO dop_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Pɑ tɛmɑ tɔɣɔʋ nɑ nyɔɔʋ kɛ Silo, ɩlɛnɑ Anɑ kʋlɩ nɑ ɩ́ kpǝtǝnɑ kɔtʋlʋ Ilii. Ɩ́lɛ́ ɩ kɑ́ cɑɣɑ kpelɑɣɑ tɔɔ kɛ́ Ɩsɔ tǝyɑɣɑ nɔnɔkpete kɛ́. ");
INSERT INTO dop_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Anɑ lɑŋlɛ kɑ wɑkǝlɑ sɔsɔm kɛ́ tǝtɔɣɔtɔɣɔ. Ɩlɛnɑ ɩ́ sǝlǝmɩ Tɑcɑɑ nɑ wulɑ, ");
INSERT INTO dop_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","nɑ ɩ́ sɩɩ nɔɣɔ sɩ: Tomɑ tǝnɑ tʋ Tɑcɑɑ, ye n nyǝnɑ nyɑ́ tǝmlɛ tʋ mɑ́, mɑ wɑhɑlɑ, nɑ ń tɔɔsɩ mɑ tɔɔ nɑ ń hɑ-m ɑpɑlʋpǝyɑɣɑ, mɑɑ hɑ-ŋ-kɛɣɛ hɑlǝnɑ kɑ sǝm. Hʋnʋɣʋ kɑɑ kpɑ kɑ nyʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Ɩ tɑɑŋɑ ḿpʋ́ɣʋ́ Ɩsɔ tǝsǝlǝmǝlɛ, ɩlɛnɑ Ilii nyǝnɩ ɩ nɔɣɔ tǝpiŋŋ. ");
INSERT INTO dop_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Anɑ sǝlǝmɑɣɑ ɩ luɣu tɛɛ kɛ́, nɑ ɩ ntompee nyǝpǝtǝɣɩ, ɩlɛ ɩ nɔɣɔ ɩɩ nɩɩkɩ. Ilii nyǝ́mɑ sɩ sʋlʋm kʋɣʋnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Ɩlɛnɑ ɩ́ tɔmɩ-ɩ sɩ: Pǝlee kɛ́ nyɑ́ sʋlʋm kɑ́ cɛ nyɑ́ tɔɔ? Lɑ nɑ nyɑ́ sʋlʋm cɛ nyɑ́ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Ntɛnɑ Anɑ sɩ: Hɑɩ, mɑ cɛ, mɑ tɑ nyɔɔ sʋlʋm nɑpǝlɩ. Amɑ mɑ lɑŋlɛ wɑkǝlǝnɑ sɔsɔm nɑ mɑ́ hʋ́lǝ́ɣɩ́ Tɑcɑɑ kɛ mɑ lotu. ");
INSERT INTO dop_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Tɑɑ nyǝnɩ nyɑ́ pɛɛlɔ mɑɣɑ tɛtɛlɑtʋ. Mɑ nǝɣǝsɛɛ nɑ mɑ wɑhɑlɑ tɛlǝsǝnɑ mpǝle, nɑ mɑ́ yɔɣɔtǝɣɩ ḿpʋ́ɣʋ́ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Ntɛnɑ Ilii sɩ: Ɩsɔ ɩ́ hɛɛsɩ nyɑ́ lɑŋlɛ nɑ ɩ́ mʋ nyɑ́ sǝlǝmʋtʋ. ");
INSERT INTO dop_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Ɩlɛnɑ Anɑ sɩ: Nɑ nyɑ́ toŋ tɑɑ. Ntɛnɑ Anɑ polo nɑ ɩ́ tɔɣɔ nɑ ɩ ɩsɛntɑɑ hɛtɩ. ");
INSERT INTO dop_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Tɛʋ femɑ, ɩlɛnɑ Ɩlǝkɑnɑ pɑ́ kʋlɩ lɔŋ nɑ pɑ́ sɛɛ Ɩsɔ, ɩlɛnɑ pɑ́ kpe Lɑmɑ. Ḿpʋ́ɣʋ́ Ɩlǝkɑnɑ nyǝmɑ́ ɩ ɑlʋ Anɑ nɑ Tɑcɑɑ mʋ ɩ sǝlǝmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Ɩlɛnɑ Anɑ lɑ teu nɑ ɩ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ, nɑ ɩ́ hɑ-kɛɣɛ hǝtɛ sɩ Sɑmiyɛɛlɩ. Sɩ Tɑcɑɑ kɛ ɩnɩ ɩ sǝlǝmɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Pǝnɑɣɑ sikɑɑ, ɩlɛnɑ Ɩlǝkɑnɑ nɑ ɩ nyǝ́mɑ tǝnɑ pɑ́ polo Silo sɩ, ɩ lɑkɩ pɑɑ pǝnɑɣɑ ŋkɑ kɑ kɔtɑɣɑ nɑ ɩ́ lɑ ɩsɩɩ ɩ kɑ sɩɩʋ ɩ nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Anɑ kisɑ pote nɑ ɩ́ tɔ ɩ pɑɑlʋ sɩ: Ye pǝyɑɣɑ cɛpɑ hǝtɛ, ɩlɛ mɑɑ ponɑ-kɛ nɑ mɑ́ hʋlɩ-kɛɣɛ Tɑcɑɑ nɑ kɑ́ sɑɑlɩ tǝnɑɣɑ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Mpʋɣʋlɛ ɩ pɑɑlʋ cɔ-ɩ sɩ: Pǝ wɛ teu. Lɑ ɩsǝnɑ pǝ hɑ-ŋ tɔ. Yele nɑ kɑ́ cɛ hǝtɛ nɑ pǝ́cɔ́. Amɑ Tɑcɑɑ ɩ́ lɑ ɩsǝnɑ ɩ kɑ sɩɩwɑ tɔ. Ɩlɛnɑ ɑlʋ cɑɣɑ nɑ ɩ́ pɑɑsǝnɑ ɩ pǝyɑɣɑ nɑ kɑ́ kɔɔ nɑ kɑ́ cɛ hǝtɛ. ");
INSERT INTO dop_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Pǝ wɑɑlɩ kɛ́ ɩ kpɑɣɑ-kɛ nɑ ɩ́ cɑɑ lɑtǝcɛ wei ɩ wɛnɑ pɩɩsɩ tooso tɔ, nɑ mʋlʋm cɛmsɛ, nɑ sʋlʋm huluɣu, nɑ ɩ́ ponɑ Silo kɛ Tɑcɑɑ tǝyɑɣɑ tɑɑ. Wɑɑtʋ ɩnɩ tɔ pǝyɑɣɑ kɔɔsɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Ḿpʋ́ɣʋ́ pɑ kʋ lɑtǝcɛ nɑ pɑ́ ponɑ Ilii kɛ pǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Ɩlɛnɑ Anɑ sɩ: Kɑɑfɑlɑ mɑ cɛ, n tɔɔsɑ mɑ tɔɔ? Mɑɑ kɔmɑ nyɑ́ kiŋ cǝnɛ nɑ mɑ́ sǝlǝmɩ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Pǝyɑɣɑ kɑnɛɣɛ mɑ sǝlǝmɑɣɑ nɑ Tɑcɑɑ mʋ mɑ kʋsǝlǝmʋtʋ. ");
INSERT INTO dop_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Tɔʋ, mɑ cɑɑ mɑɑ cɛlɛ-ɩ Tɑcɑɑ kɛ hɑlǝnɑ ɩ sǝm. Ɩlɛnɑ Ɩlǝkɑnɑ tǝyɑɣɑ nyǝ́mɑ tǝnɑ hǝntɩ Ɩsɔ kɛ ɑtɛ nɑ pɑ́ sɛɛ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S12_1","010_2_1","1SA","2","1","1","Ḿpʋ́ɣʋ́ Anɑ sɑmɑ Ɩsɔ sɩ: Mɑ yɔɔlǝɣǝnɑ Tɑcɑɑ wei ɩ wɑɑsɑ-m tɔ. Ɩ hʋlǝsɑ mɑ lɑŋlɛ. Ɩ kʋsɑ mɑ nyʋɣʋ, nɑ ɩ́ hɑ-m tomɑ. Nɑ mɑ nɔɣɔ kuliɣinɑ mɑ kolontunɑɑ. ");
INSERT INTO dop_vpl VALUES ("S12_2","010_2_2","1SA","2","2","2","Tɑcɑɑ tike wɛnnɑ tǝnɑŋŋ. Ɩ tike ntɛ́ kentulu ɩ pɑɑsi Ɩsɔ nɔɣɔlʋ ɩ fɛɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S12_3","010_2_3","1SA","2","3","3","Ɩ́ yele kɑlɑmpɑɑnɩ, nɑ ɩ́ yele ɩsǝcɑʋ tɔm. Tɑcɑɑ nyǝmɑ́ pǝ tǝnɑɣɑ. Ɩɩ yeki ɩsɑɣɑtʋ nɑtǝlɩ. ");
INSERT INTO dop_vpl VALUES ("S12_4","010_2_4","1SA","2","4","4","Tɑcɑɑ cɛpɑ toŋtʋnɑɑ tɔɔŋ. Amɑ ɑcɑmɑɑ nɑ́ nyɔɔ toŋ. ");
INSERT INTO dop_vpl VALUES ("S12_5","010_2_5","1SA","2","5","5","Ɩ tʋ hɑɣɑlɑɑ sɩ pɑ́ pɛɛkɩ mpi pɑɑ yɑnɑ tɔɣɔnɑɣɑ tɔ, nɑ ɩ́ sʋsɩ kʋnyɔntʋnɑɑ kɛ toŋ. Ɩ lɑpɑ nɑ kɑɑlʋlɑɣɑ lʋlɩ tɔm nɑɑtosompɔɣɔlɑɣɑ. Ɩlɛnɑ ɑlʋllʋ nɑ́ɑ́ lɑŋ. ");
INSERT INTO dop_vpl VALUES ("S12_6","010_2_6","1SA","2","6","6","Tɑcɑɑ kʋɣʋnɑ, ɩnɩ ɩ feesiɣinɑ. Ɩnɩ ɩ tisiɣinɑ ɑtɛtǝlɛ tɑɑ, nɑ ɩ́ lǝsǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("S12_7","010_2_7","1SA","2","7","7","Ɩnɩ ɩ́ tʋɣʋnɑ kʋnyɔntʋtʋ yɑɑ toŋ. Ɩnɩ ɩ́ tisiɣinɑ lɛlɑɑ nɑ ɩ́ kʋsǝɣɩ lɛmpɑ. ");
INSERT INTO dop_vpl VALUES ("S12_8","010_2_8","1SA","2","8","8","Tɑcɑɑ kʋsǝɣɩ lɑŋlʋ kɛ ɑtɛ mʋsʋɣʋ tɑɑ, nɑ ɩ́ kʋsɩ kʋnyɔntʋ kɛ hute tɑɑ, nɑ ɩ́ cɑɣɑsɩ pɑ́ nɑ sɔsɑɑ, nɑ pɑ́ kɑɑ teeli kumte. Ɩnɩ ɩ tǝnnɑ tɛtʋ kite, nɑ tǝ tɔɔ kɛ́ ɩ sɩɩwɑ ɑntulinyɑ. ");
INSERT INTO dop_vpl VALUES ("S12_9","010_2_9","1SA","2","9","9","Ɩ tiikiɣi ɩ yǝlɑɑ nɑ ɩ́ kentiɣi pɑ tɔɔ. Amɑ ɩ yeki nɑ ɑsɑɣɑɑ leki sǝkpɛtʋɣʋ tɛɛ. Ɩsɔ ɑkɑɩtʋ pɑɑ fɛɩnɑ tɔnʋɣʋ tɑɑ ɑlɑɑfǝyɑ. ");
INSERT INTO dop_vpl VALUES ("S12_10","010_2_10","1SA","2","10","10","Tɑcɑɑ kɑ tisi ɩ kolontunɑɑ tɔɔ kɛ́ cɑlɑnɑɑ, pɑ kɔŋ sɑɑlʋɣʋ kɛ yem kɛ́. Ɩnǝɣǝlɛ kɑteŋɑ tǝnɑ hʋʋlʋ sɔsɔ. Ɩ kɑ́ kpɑ wei ɩ lǝsɑɑ tɔɣɔ wulɑʋ, nɑ ɩ́ tʋ-ɩ toŋ. ");
INSERT INTO dop_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Ḿpʋ́ɣʋ́ Ɩlǝkɑnɑ pɑ mǝlɑ kpente, nɑ pǝyɑɣɑ nɑ́ɑ́ sɑɑlɩ Tɑcɑɑ tǝmlɛ tɑɑ kɛ́ kɔtʋlʋ Ilii kiŋ. ");
INSERT INTO dop_vpl VALUES ("S12_12","010_2_12","1SA","2","12","12","Ilii pǝyɑlɑɑ kɑ kɛ́ tɛtɛlɑtɑɑ kɛ́, pɑ tɑ pɑɑsǝnɑ Ɩsɔ kɛ́ pɑɑ pǝcɔ. ");
INSERT INTO dop_vpl VALUES ("S12_13","010_2_13","1SA","2","13","13","Nti nti pɑ lɑkɑɣɑ sɑmɑɑ tɔɣɔlɔ: Ye nɔɣɔlʋ hɑ Ɩsɔ kɛ́ kʋhɑʋ, kɔtʋlʋ tǝmlɛ tʋ puki sɑɑ wei pɑ tǝsɑ kʋhɑʋ nɑntʋ tɔɣɔ, nɑ ɩ́ tɔkɑ kelɑ tooso lɔɣɔlɑɣɑ sɔsɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S12_14","010_2_14","1SA","2","14","14","Ɩ tɑkɩ ɩlɛnɑ ɩ́ sɔ tiipee tɑɑ, nɑ pǝ sɔpɑ nɑntʋ kɛ ɩsǝnɑ, ɩ lǝsǝɣɩ kɛ́ nɑ ɩ́ ponɑ kɔtʋlʋ. Ḿpʋ́ɣʋ́ pɑ lɑkɑɣɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ mpɑ pɑ pukɑɣɑ Silo tɔ. ");
INSERT INTO dop_vpl VALUES ("S12_15","010_2_15","1SA","2","15","15","Hɑlɩ tǝmlɛ tʋ puki kɛnɑ pǝ́cɔ́ pɑ́ wɔ tɔtɛ nim, nɑ ɩ́ tɔ́ wei ɩ lɑpɑ kɔtɑɣɑ tɔ sɩ: Cɛlɑ kɔtʋlʋ kɛ ɩ nɑntʋ nɑ ɩ toŋ ɩ tɩ. Ɩɩ cɑɑ kʋtǝsǝtʋ. Lɛŋ kɛ ɩ cɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("S12_16","010_2_16","1SA","2","16","16","Ye kɔtɑɣɑ lɑtʋ tɔmɑ sɩ: Yele nɑ pɑ́ wɔ kpǝntɛ nim ɩlɛnɑ ń cosi timpi n cɑɑkɩ tɔ. Ɩlɛ tǝmlɛ tʋ cɔ sɩ: Aɑɩ, ye n tɑ cɛlɛ-m nɔɔnɔɔ, mɑɑ lɛɛkǝnɑ toŋ. ");
INSERT INTO dop_vpl VALUES ("S12_17","010_2_17","1SA","2","17","17","Ɩsɑɣɑtʋ sɔsɔɔntʋ ntǝɣɩ Ilii pǝyɑlɑɑ kʋkɑɣɑnɑ pɑ tɩ tɔm kɛ Ɩsɔ ɩsɛntɑɑ. Mpi tɔ, pɑ nyǝnɑɣɑ Tɑcɑɑ kɔtɑɣɑ kɛ yem kɛ́. ");
INSERT INTO dop_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Pɑɑ nɑ Sɑmiyɛɛlɩ kɑ kɔɔsɑɑ tɔ, ɩ lɑkɑɣɑ Ɩsɔ tǝmlɛ kɛ́ nɑ ɩ́ suuwɑ kɔtǝlɑɑ tokiyɑ tɑkɑ ŋkɑ pɑ lʋʋwɑ kponkpontu toŋ nyǝntʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Ye pǝnɑɣɑ sikɑɑ nɑ Anɑ pɑ puki kɔtɑɣɑ lɑpʋ, ɩ nyɑlǝɣɩ toko kɛ́ nɑ ɩ́ kpɛŋnɑ Sɑmiyɛɛlɩ. ");
INSERT INTO dop_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Hɑlǝnɑ Ilii kooliɣi Anɑ nɑ ɩ pɑɑlʋ kɛ kʋpɑntʋ sɩ: Tɑcɑɑ ɩ́ lɑ nɑ ń hiki piyɑ nɑ sɩ́ lɛɛtɩ ŋkɑ n hɑ-ɩ ɩsǝntɔ tɔ kɑ lonte. Ɩlɛnɑ pɑ́ mǝlɩ pɑ tɛ. ");
INSERT INTO dop_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Tɑcɑɑ wɛ Anɑ wɑɑlɩ, ɩlɛnɑ ɩ́ lɑ teu nɑ ɩ́ lʋlɩ ɑpɑlʋpiyɑ kɛ tooso, nɑ ɑlʋpiyɑ kɛ nɑɑlɛ. Nɑ pǝyɑɣɑ Sɑmiyɛɛlɩ nɑ́ɑ́ tɔŋnɑ pɩɩʋ kɛ Ɩsɔ tǝmlɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S12_22","010_2_22","1SA","2","22","22","Ilii kɑ kpɑtǝlɑɑ kɛ́ tǝkuŋkuŋku. Nɑ ɩ́ nɩɩkɩ mpi mpi ɩ pǝyɑlɑɑ lɑkɑɣɑnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tɔ. Nɑ ɩsǝnɑ pɑ hǝntɑɣɑnɑ ɑlɑɑ mpɑ pɑ lɑkɑɣɑ tǝmlɛ kɛ Ɩsɔ tǝyɑɣɑ nɔnɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("S12_23","010_2_23","1SA","2","23","23","Ɩlɛnɑ ɩ́ tɔ-wɛ sɩ: Pepe tɔɔ kɛ́ ɩ lɑkɩ yɑɑsinɑɑ mpɛ pɑ tɑkɑnɑɑ? Yǝlɑɑ tɑɣɑsǝɣɩ-m mǝ ɩsɑɣɑtʋnɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S12_24","010_2_24","1SA","2","24","24","Aɑɩ, mɑ pǝyɑlɑɑ, ɩ́ yele mpʋ, mǝ tɔmnɑɑ mpɑ Ɩsɛɣɛlɩ yǝlɑɑ heeliɣi-m mpʋ tɔ pɑ fɛɩ teu. ");
INSERT INTO dop_vpl VALUES ("S12_25","010_2_25","1SA","2","25","25","Ye yʋlʋ pǝntǝnɑ ɩ tɔɣɔntǝlɛ, ntɑnyɩ Ɩsɔ kɑ wii pʋntʋ. Amɑ ye Tɑcɑɑ kɛ pʋntʋ pǝntǝnɑɑ, ɩlɛ ɑwe sɛɛnɑ ɩ tɔɔ? Amɑ pɑ tɑ nɩɩnɑ pɑ cɑɑ nɔɣɔ. Mpi tɔ, Tɑcɑɑ kɑ sɔɔlɑɑ sɩ ɩ kʋɣɩ-wɛɣɛ. ");
INSERT INTO dop_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Nɑ pǝyɑɣɑ Sɑmiyɛɛlɩ nɑ́ɑ́ tɔŋnɑ pɩɩʋ, nɑ ɩ wɛ yǝlɑɑ nɑ Ɩsɔ kɛ́ teu. ");
INSERT INTO dop_vpl VALUES ("S12_27","010_2_27","1SA","2","27","27","Ḿpʋ́ɣʋ́ Ɩsɔ yʋlʋ nɔɣɔlʋ ɩ polɑ Ilii kiŋ nɑ ɩ́ heeli-ɩ sɩ: Tɑcɑɑ yɔɣɔtɑɑ sɩ mɑ hʋlɑ mɑ tǝɣɩ mǝ cɔsɔ Alɔŋ, kɛ wɑɑtʋ wei ɩ́ nɑ ɩ nyǝ́mɑ pɑɑ wɛ Icipiti wulɑʋ tɛɣɛ yomle tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S12_28","010_2_28","1SA","2","28","28","Ɩ́ nɑ ɩ lʋlʋɣʋ nyǝ́mɑ kɛ mɑ lǝsɑ Ɩsɛɣɛlɩ kpekɑ tǝnɑ tɑɑ sɩ, pɑ́ lɑ mɑ kɔtǝlɑɑ, nɑ pɑ́ suuki kɔtǝlɑɑ toko nɑ pɑ́ kpɑɑkɩ mɑ kɔtɑɣɑ tǝlɑtɛ tɔɔ nɑ pɑ́ wɔkɩ tulɑɑlʋnɑɑ. Hɑlǝnɑ mɑ́ hʋlɩ-ɩ timpi ɩ kɑ́ cosi kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ kɑ kpǝntɛ tɔɔ nɑ ɩ́ tɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("S12_29","010_2_29","1SA","2","29","29","Pepe tɔɔ kɛ́ ɩ́ nyǝnǝɣɩ yem kɛ mɑ kɔtɑsɩ nɑ mɑ kʋhɑʋ ŋku mɑ sɩɩwɑ sɩ pɑ́ lɑkǝnɑ mɑ tǝyɑɣɑ tɑɑ tɔ? Ɩlɛ ɩsǝnɑɣɑ pǝ lɑpɑ sɩ Ilii ń seeki nyɑ́ piyɑ nɑ pǝ́ kǝlɩ mɑ? Nɑ ɩ́ tɔkɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɣɔnɑsɩ kʋpɑŋsɩ nsi pɑ lɑpɑ kɔtɑsɩ tɔ, nɑ ɩ́ yooki cǝncǝmǝŋ? ");
INSERT INTO dop_vpl VALUES ("S12_30","010_2_30","1SA","2","30","30","Nyǝnɩ Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ mɑ, mɑɑ sɩɩwɑ sɩ, nyɑ́ cɑɑ tǝyɑɣɑ nɑ nyɑ́ lʋlʋɣʋ nyǝ́mɑ tǝnɑ kɑ́ lɑkǝnɑ mɑ kɔtʋɣʋ tǝmlɛ kɛ tɑm tɔɔ. Amɑ pǝnɛntɛ mɑ kʋ́ tǝlɛ. Mpi tɔ, wei ɩ tʋɣʋ-m teeli tɔɣɔ mɑɑ tʋ teeli, nɑ mɑ́ nyǝnɩ yem kɛ́ wei ɩ kpɛɛnɑ-m tɔ. ");
INSERT INTO dop_vpl VALUES ("S12_31","010_2_31","1SA","2","31","31","Nn nɑɑkɩ kʋyɛɛŋ tɔŋnɑ kɔntɛ, wei ɩ tɑɑ mɑɑ kpiisi nyɑ́ ɩfepiyɑ nɑ nyɑ́ lʋlʋɣʋ tɑɑ nyǝ́mɑ. Hɑlɩ ɑkpɑtʋlʋ kɑɑ wɛɛ nyɑ́ tǝyɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S12_32","010_2_32","1SA","2","32","32","N kɑ́ nɑ́ kolontu kɔmɑ nɑ ɩ́ cɑɣɑ mɑ tǝcɑɣɑlɛ, nɑ ɩ́ pɑɑlǝnɑ kʋpɑntʋnɑɑ mpɑ Tɑcɑɑ lɑpɑ Ɩsɛɣɛlɩ tɔ. Nyɑ́ tǝyɑɣɑ kɑ́ tɑɑŋǝnɑ ɑkpɑtʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S12_33","010_2_33","1SA","2","33","33","Pɑɑ nɑ mpʋ mɑɑ yele nyɑ́ nyǝ́mɑ tɑɑ nɔɣɔlʋ nɑ ɩ ɩsɛ kɛ mɑ kɔtɑɣɑ tǝlɑtɛ, nɑ ɩ́ tɔɣɔ nyɑ́ ɩsɛ nɑ ɩ́ wɑkǝlɩ nyɑ́ lɑŋlɛ. Amɑ nyɑ́ tǝyɑɣɑ nyǝ́mɑ tǝnɑ kɑ́ sǝkǝnɑ pɑ toŋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S12_34","010_2_34","1SA","2","34","34","Kʋyɑkʋ kʋlʋmʋɣʋ kɛ nyɑ́ pǝyɑlɑɑ Hofini nɑ Pɛnhɑsɩ pɑɑ sɩ. Ɩlɛ tǝnɑɣɑ ń kɑ́ nyǝnɑ sɩ tɑmpɑnɑ kɛ mɑ yɔɣɔtǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("S12_35","010_2_35","1SA","2","35","35","Mɑɑ kpɑ mɑ tǝɣɩ kɔtʋlʋ kʋpɑŋ, wei ɩ tǝŋǝɣɩ mɑ luɣu tɛɛ nyǝntʋ kɛ teitei tɔ, nɑ mɑ́ hɑ-ɩ lʋlʋɣʋ kʋpɑŋkʋ, nɑ ɩ́ lɑkɩ wulɑʋ wei mɑ lǝsɑɑ tɔɣɔ tǝmlɛ kɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S12_36","010_2_36","1SA","2","36","36","Ye pǝ tɩɩ kɑɑsɑ wei kɛ́ nyɑ́ lʋlʋɣʋ tɑɑ, pʋntʋ kɑ́ hǝntɩ kɔtʋlʋ ɩnǝɣɩ ɑtɛɣɛ sɩ: Hɑ-m liɣitee nɑ tɔɣɔnɑɣɑ. Hɑlɩ ɩ́ sǝlǝmɩ-ɩ tɔtɔ sɩ: Tʋ-m kɔtʋɣʋ tǝmlɛ nɑtǝlɩ tǝ tɑɑ, nɑ mɑ́ hikinɑ mɑ tɔɣɔnɑɣɑ nɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","Pǝyɑɣɑ Sɑmiyɛɛlɩ kɑ wɛ kɔtʋɣʋ tǝmlɛ tɑɑ kɛ́ Ilii kiŋ kɛ́. Wɑɑtʋ ɩnɩ Tɑcɑɑ tɑɑ yɔɣɔtǝɣǝnɑ yǝlɑɑ kɛ teitei. Pǝyele ɩ tɑɑ hʋ́lǝ́ɣɩ́ yǝlɑɑ kɛ mpi pɩɩ tɛ nɑ pǝ́ lɑ́ tɔɣɔ kotokoto. ");
INSERT INTO dop_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Wɑɑtʋ ɩnɩ tɔ, Ilii ɩsɛ cɑɑkɑɣɑ yʋlʋmʋɣʋ ntɛ́, ɩɩ nɑɑkɩ teitei. Ḿpʋ́ɣʋ́ ɩ hǝntɑ ɩ tǝhǝntǝlɛ kɛ ɑhoo nɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Nɑ Sɑmiyɛɛlɩ hǝntɑ Ɩsɔ ɑtɑkɑɑ cɔlɔ, nɑ pɑ́ tɑ teesitɑ fǝtǝlɑnɑɑ kɛ tefemle. ");
INSERT INTO dop_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","Ḿpʋ́ɣʋ́ Tɑcɑɑ yɑɑwɑ sɩ: Sɑmiyɛɛlɩ, nɑ Sɑmiyɛɛlɩ cɔ sɩ: Mɑɣɑlɔ. ");
INSERT INTO dop_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Ɩlɛnɑ ɩ́ kpɑɣɑ ɑsewɑ nɑ ɩ́ polo Ilii kiŋ, nɑ ɩ́ tɔ sɩ: N yɑɑ-m tɔ mɑɣɑlɔ. Ntɛnɑ Ilii sɩ: Mɑ tɑ yɑɑ-ŋ se. Polo ń hǝntɩ. Ɩlɛnɑ Sɑmiyɛɛlɩ mǝlɩ nɑ ɩ́ hǝntɩ. ");
INSERT INTO dop_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ-ɩ yɑɑʋ sɩ: Sɑmiyɛɛlɩ. Ɩlɛnɑ ɩ́ polo Ilii kiŋ nɑ ɩ́ tɔ sɩ: N yɑɑ-m tɔ, mɑɣɑlɔ. Ntɛnɑ Ilii sɩ: Mɑ tɑ yɑɑ-ŋ se. Mɑ pǝyɑlʋ, polo ń hǝntɩ. ");
INSERT INTO dop_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Sɑmiyɛɛlɩ tɑ nyɩ sɩ Tɑcɑɑ yɑɑkǝnɑ-ɩ. Mpi tɔ, ɩ́lɛ́ ɩ tɑ yɔɣɔtǝtɑnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑ Sɑmiyɛɛlɩ kɛ yɑɑʋ kɛ tɔm tooso nyǝm. Ɩlɛnɑ Sɑmiyɛɛlɩ polo Ilii kiŋ sɩ: N yɑɑ-m tɔ mɑɣɑlɔ. Tǝnɑɣɑlɛ Ilii cɛkǝnɑɑ sɩ Tɑcɑɑ yɑɑkǝnɑ pǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Ɩlɛnɑ ɩ́ heeli-ɩ sɩ: Polo nɑ n hǝntɩ. Ye pǝ tɑsɑ-ŋ yɑɑʋ, ɩlɛ n tɔ sɩ: Tɑcɑɑ, yɔɣɔtɩ, nyɑ́ pǝyɑɣɑ mɑ́, mɑ nɩɩkɩ. Ɩlɛnɑ Sɑmiyɛɛlɩ mǝlɩ nɑ ɩ́ hǝntɩ. ");
INSERT INTO dop_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Mpʋɣʋlɛ Tɑcɑɑ polɑɑ nɑ ɩ́ yɑɑ-ɩ ɩsɩɩ ɩ tɩɩ yɑɑkɩ tɔ sɩ: Sɑmiyɛɛlɩ, kɛlɛnɑ ɩ́ cɔ sɩ: Tɑcɑɑ, yɔɣɔtɩ, nyɑ́ pǝyɑɣɑ mɑ́, mɑ nɩɩkɩ. ");
INSERT INTO dop_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Ɩlɛnɑ Tɑcɑɑ tɔ sɩ: Mɑɑ kɔnɑ wɑkǝlʋɣʋ nɑkʋlǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ, nɑ pɑɑ wei ɩ́ nɩɩ-tɩ pɩɩ sʋsɩ-ɩ wɑtʋ. ");
INSERT INTO dop_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","Kʋyɑŋkuɣu mɑɑ cɑɑlɩ Ilii tǝyɑɣɑ nyǝ́mɑ ɩsɛ kɛ nyǝŋsʋɣʋ. Hɑlǝnɑ mɑ́ tʋ́ nyʋɣʋ kɛ teitei ɩsɩɩ mɑɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Mɑ heelɑ-ɩ tǝfoo sɩ mɑɑ tʋ ɩ tǝyɑɣɑ kɛ tɑm tɔɔ sɑlǝkɑ, kɛ timpi ɩ piyɑ wɑkǝlɑ mɑ hǝtɛ, nɑ ɩ́ nyǝ́mɑ pǝ tɔɔ nɑ ɩ́ tɑ́ kisinɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Pǝ tɔɔ kɛ́ mɑ yɔɣɔtǝɣǝnɑ tuunɑʋ sɩ, pɑɑ pɑ lɑpɑ kɔtɑsɩ nɑ pɑ́ hɑ kʋcɔɔŋ, mɑ kɑɑ hɩɩsɩ pɑ tǝyɑɣɑ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Ɩlɛnɑ Sɑmiyɛɛlɩ hǝntɩ nɑ pǝ́ nyɑɑlɩ, nɑ ɩ́ tʋlɩ Tɑcɑɑ tǝyɑɣɑ nɔnɔɔsɩ. Amɑ ɩ nyɑŋɑɣɑnɑ mpi ɩ nɑwɑ mpʋ tɔ pǝ tɔm heeluɣu kɛ Ilii. ");
INSERT INTO dop_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Ḿpʋ́ɣʋ́ Ilii yɑɑ-ɩ sɩ: Mɑ pu Sɑmiyɛɛlɩ. Nɑ ɩ́ cɔ sɩ: Mɑɣɑlɔ. ");
INSERT INTO dop_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Ɩlɛnɑ ɩ́ pɔɔsɩ sɩ: Tɔm ntiɣi Tɑcɑɑ heelɑ-ŋ? Ye n ŋmɛsɑ-m tǝ tɑɑ nɑtǝlɩ, Tɑcɑɑ ɩ́ lɑ-ŋ nɑ ń tɔɣɔ nɑ ń hɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Ntɛnɑ Sɑmiyɛɛlɩ kɛɛsɩ-ɩ tǝ tǝnɑ, ɩ tɑ ŋmɛsɩ-ɩ nɑtǝlɩ. Kɛlɛnɑ Ilii sɩ: Tɑcɑɑ kɛ́, ɩ́ lɑ ɩsǝnɑ pǝ mɑɣɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Sɑmiyɛɛlɩ tɔŋnɑ pɩɩʋ nɑ Tɑcɑɑ wɛ ɩ wɑɑlɩ, ɩ tɑ yele nɑ ɩ tɔm nɑtǝlɩ tǝ́ tii ɑtɛɣɛ yem. ");
INSERT INTO dop_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ mpɑ pɑɑ wɛ pǝ kpɑɣɑʋ Tɑŋ nɑ pǝ́ polo Pɛɛsepɑ tɔ, pɑ nyǝ́mɑ sɩ Tɑcɑɑ kpɑ Sɑmiyɛɛlɩ kɛ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlʋ. ");
INSERT INTO dop_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Ɩ lɩɩkɑɣɑ Sɑmiyɛɛlɩ tɔɔ kɛ́ Silo kɛ́, nɑ ɩ́ heeliɣi-ɩ tɔmnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S14_1","010_4_1","1SA","4","1","1","Nɑ ɩ́ tɛlǝsǝɣɩ-tǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ nɩɩkǝnɑ-ɩ. Wɑɑtʋ ɩnɩ ɩ tɑɑ kɛ́ Filiisi nyǝ́mɑ kotɑɑ sɩ, pɑ yookinɑ Ɩsɛɣɛlɩ nyǝ́mɑ, ɩlɛnɑ pɑ́ pɩɩlɩ Afekɑ. Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ́ lɩɩwɑ nɑ pɑ́ pɩɩlɩ Ɩpene-Ɩsɛɛ. ");
INSERT INTO dop_vpl VALUES ("S14_2","010_4_2","1SA","4","2","2","Tǝnɑɣɑ Filiisi nyǝ́mɑ kʋlɑ pɑ tɔɔ nɑ pɑ́ yoo nɑ pɑ́ kǝlɩ Ɩsɛɣɛlɩ nyǝ́mɑ, nɑ pɑ́ kʋ-wɛ ɩsɩɩ yǝlɑɑ iyisi liɣiti (4000). ");
INSERT INTO dop_vpl VALUES ("S14_3","010_4_3","1SA","4","3","3","Ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ mǝlɩ pɑ tǝsikile nɑ nyʋɣʋ nyǝ́mɑ tɔ sɩ: Pepe tɔɔ kɛ́ Tɑcɑɑ yelɑɑ nɑ Filiisi nyǝ́mɑ kʋ-tʋɣʋ sɑŋɑ? Tǝ́ polo tǝ́ kɔnɑ Ɩsɔ ɑtɑkɑɑ nɑ Tɑcɑɑ wɛɛ tɑ wɑɑlɩ, nɑ ɩ́ wɑɑsɩ-tʋɣʋ tɑ kolontunɑɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S14_4","010_4_4","1SA","4","4","4","Ḿpʋ́ɣʋ́ pɑ tilɑ Silo nɑ pɑ́ kɔnɑ Tɑcɑɑ Tomɑ tǝnɑ tʋ ɑtɑkɑɑ wei ɩ tɔɔ Ɩsɔ wɛ ɩŋmɛlɑʋ kɛ ɩsɔtɑɑ tɑŋlɑɑ nɑɑlɛ hɛkʋ tɑɑ tɔ. Ilii pǝyɑlɑɑ nɑɑlɛ, Hofini nɑ Pɛnhɑsɩ pɑ kɔnnɑ ɑtɑkɑɑ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("S14_5","010_4_5","1SA","4","5","5","Wɑɑtʋ wei pɑ sʋsɑ Ɩsɔ ɑtɑkɑɑ kɛ tǝsikile, ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ yɑɣɑ lɑŋhʋlʋmlɛ ɑpɑlʋkɑkiisɑsɩ, hɑlǝnɑ tɛtʋ sele. ");
INSERT INTO dop_vpl VALUES ("S14_6","010_4_6","1SA","4","6","6","Filiisi nyǝ́mɑ nɩɩ pɑ kɑkiisɑsɩ nsɩ sɩ tɑŋ, ɩlɛnɑ pɑ́ tɔ sɩ: Hepǝlɑ nyǝ́mɑ tǝsikile tɑɑ kɑkiisɑsɩ nsɩ sɩ hʋwɛɛ suwe? Filiisi nyǝ́mɑ nɩɩwɑ sɩ Tɑcɑɑ ɑtɑkɑɑ kɛ́ pɑ kɔnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝsikile. ");
INSERT INTO dop_vpl VALUES ("S14_7","010_4_7","1SA","4","7","7","Ɩlɛnɑ sɔɣɔntʋ kpɑ-wɛ nɑ pɑ́ tɔ sɩ: Pɑ Ɩsɔ kɔmnɑ pɑ tǝsikile. Ye mpʋ tɑ́ tɔm tɛmɑɣɑ. Too tɔ, yɑɑsi ɩnɛ ɩ tɑkɑ tɑ lɑtɑ. ");
INSERT INTO dop_vpl VALUES ("S14_8","010_4_8","1SA","4","8","8","Awe kɑ yɑ-tʋɣʋ tɩɩŋ sɔsɔɔŋ ɩnɛ ɩ niŋ tɑɑ? Pɑ tɩɩŋ ɩnɩ ɩ kʋnɑ Icipiti nyǝ́mɑ tǝsɔɣɔsɔɣɔ kɛ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S14_9","010_4_9","1SA","4","9","9","Filiisi nyǝ́mɑ mɛ, ɩ́ nyɔɔ toŋ nɑ ɩ́ lɑ ɑpɑlɑɑ. Pǝ́ tɑɑ kɔɔ nɑ Hepǝlɑ nyǝ́mɑ ŋmɑkǝlɩ-mɛ ɩsɩɩ tɩɩ lɑpʋ-wɛ tɔ. Ɩ́ lɑ ɑpɑlɑɑ nɑ ɩ́ yoo. ");
INSERT INTO dop_vpl VALUES ("S14_10","010_4_10","1SA","4","10","10","Ḿpʋ́ɣʋ́ pɑ kʋlɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ nɑ pɑ́ kǝlɩ-wɛ. Nɑ pɑɑ wei ɩ́ se nɑ ɩ́ kpe ɩ tɛ. Pɑ kǝlɑ-wɛɣɛ tǝnɑŋnɑŋ, nɑ pɑ́ hɛɛlɩ pɑ tɑɑ yoolɑɑ kɛ yǝlɑɑ iyisi hiu nɑ nɑɑnʋwɑ (30000). ");
INSERT INTO dop_vpl VALUES ("S14_11","010_4_11","1SA","4","11","11","Nɑ pɑ́ lɛɛkɩ Ɩsɔ ɑtɑkɑɑ, nɑ pɑ́ kʋ Ilii pǝyɑlɑɑ nɑɑlɛ Hofini nɑ Pɛnhɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S14_12","010_4_12","1SA","4","12","12","Ḿpʋ́ɣʋ́ Pɛncɑmɛɛ tʋ nɔɣɔlʋ ɩ lɩɩ tǝyoole kɛ kʋyɑkʋ ŋkʋ, nɑ ɩ́ se nɑ ɩ́ polo Silo nɑ lɑŋwɑkǝllɛ nɑ ɩ́ cǝlɑ ɩ wontu, nɑ ɩ́ pǝlɑ ɩ nyʋɣʋ tɑɑ kɛ́ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("S14_13","010_4_13","1SA","4","13","13","Wɑɑtʋ ɩnɩ tɔ nɑ Ilii cɑɣɑ kpelɑɣɑ tɔɔ, nɑ ɩ́ tɑŋɑɑ nɑ ɩ́ nǝɣǝsǝɣɩ Ɩsɔ ɑtɑkɑɑ tɔm. Ɩlɛ ɑpɑlʋ ɩnɩ ɩ tɑnɑ tɔm ntǝɣǝlɛ nɑ ɩcɑtɛ tǝnɑ mɑ kɑpusi. ");
INSERT INTO dop_vpl VALUES ("S14_14","010_4_14","1SA","4","14","14","Ilii nɩɩ kɑpusi nsɩ, ɩlɛnɑ ɩ́ pɔɔsɩ sɩ: Pepe kɔkɔtɛ ntɛ́ mpʋ? Ɩlɛnɑ ɑpɑlʋ ɩnɩ ɩ́ kpɑɣɑ ɑsewɑ nɑ ɩ́ polo ɩ́ heeli-ɩ tɔm ntɩ. ");
INSERT INTO dop_vpl VALUES ("S14_15","010_4_15","1SA","4","15","15","Wɑɑtʋ ɩnɩ Ilii pɩɩsɩ kɑ wɛ pǝlefɛɩ nɩɩnʋwɑ kɛ́. Nɑ ɩ ɩsɛ nyǝnǝɣɩ yem tǝhelele, ɑɑ nɑɑkɩ teu. ");
INSERT INTO dop_vpl VALUES ("S14_16","010_4_16","1SA","4","16","16","Mpʋɣʋlɛ ɑpɑlʋ ɩnɩ ɩ heelɑ Ilii sɩ: Tǝyoole kɛ mɑ sewɑ nɑ mɑ́ kɔɔ sɑŋɑ. Ntɛnɑ Ilii sɩ: Pepe lɑpɑ mɑ pǝyɑlʋ? ");
INSERT INTO dop_vpl VALUES ("S14_17","010_4_17","1SA","4","17","17","Ntɛnɑ ɑpɑlʋ ɩnɩ sɩ: Filiisi nyǝ́mɑ hɛɛlɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ sɔsɔm nɑ Ɩsɛɣɛlɩ nyǝ́mɑ se. Hɑlɩ nyɑ́ pǝyɑlɑɑ nɑɑlɛ Hofini nɑ Pɛnhɑsɩ pɑ sǝpɑ. Pǝyele pɑ lɛɛkɑ Ɩsɔ ɑtɑkɑɑ. ");
INSERT INTO dop_vpl VALUES ("S14_18","010_4_18","1SA","4","18","18","Mpi sɩ ɑpɑlʋ ɩnɩ ɩ kɑ kɛɛsǝɣɩ-ɩ Ɩsɔ ɑtɑkɑɑ tɔm, ɩlɛ Ilii pǝsɑ nyɑɣɑɩ kɛlɛ nɑ kpelɑɣɑ kɛ nɔnɔɣɔ tǝnɑ, nɑ ɩ luɣu pɛlɩ nɑ ɩ́ sɩ. Mpi tɔ, ɩ kɑ kpɑtǝlɑɑ kɛ́ nɑ ɩ́ yɑsǝlɑɑ. Pɩɩsɩ nɩɩlɛ tǝcu kɛ ɩ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S14_19","010_4_19","1SA","4","19","19","Ilii pǝyɑlʋ Pɛnhɑsɩ ɑlʋ kɑ wɛ hɔɣɔ kɛ́, nɑ ɩ́ pɩɩwɑ tǝtoɣotoɣo. Wɑɑtʋ wei ɩ nɩɩwɑ Ɩsɔ ɑtɑkɑɑ lɛɛkʋɣʋ tɔm, nɑ ɩ pɑŋ nɑ ɩ pɑɑlʋ pɑ sǝm, ɩlɛnɑ lʋlʋɣʋ wʋsɑsɩ tuti-ɩ kpɑkpɑɑ nɑ ɩ́ sopi nɑ ɩ́ lʋlɩ. ");
INSERT INTO dop_vpl VALUES ("S14_20","010_4_20","1SA","4","20","20","Ɩ cɑɑkɑɣɑ tɔnʋɣʋ kpisuɣu ɩlɛnɑ ɩ kiŋ ɑlɑɑ tɔmɩ-ɩ sɩ: Tɔkɩ nyɑ́ tɩ, ɑpɑlʋpu kɛ n lʋlɑɑ. Amɑ ɑlʋ tɑ cɔ, pǝcɔ ɩ tɑ tɩɩ pɑɑsǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S14_21","010_4_21","1SA","4","21","21","Pǝ wɑɑlɩ kɛ́ ɩ hɑ-kɛɣɛ hǝtɛ sɩ: Ɩkɑpɔtɩ. Hǝtɛ ntɛ tǝ hʋwɛɛ ntɛ sɩ: Ɩsɔ teu kʋlɑ Ɩsɛɣɛlɩ. Mpi tɔ, pɑ lɛɛkɑ Ɩsɔ ɑtɑkɑɑ, pǝ́cɔ́ ɩ pɑŋ nɑ ɩ pɑɑlʋ pɑ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("S14_22","010_4_22","1SA","4","22","22","Mpʋɣʋlɛ sɩ: Pɑ lɛɛkɑ Ɩsɔ ɑtɑkɑɑ tɔ Ɩsɔ teu kʋlɑ Ɩsɛɣɛlɩ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S15_1","010_5_1","1SA","5","1","1","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ kpɑɣɑ Ɩsɔ ɑtɑkɑɑ kɛ Ɩpene-Ɩsɛɛ, nɑ pɑ́ ponɑ-ɩ Asǝtɔtɩ. ");
INSERT INTO dop_vpl VALUES ("S15_2","010_5_2","1SA","5","2","2","Pɑ kpɑɣɑ-ɩ mpʋ, ɩlɛnɑ pɑ́ sɩɩ-ɩ pɑ tʋɣʋ Tɑkɔŋ kɔŋkɔŋ tɑɑ kɛ́ kʋ kutuluɣu tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S15_3","010_5_3","1SA","5","3","3","Tɛʋ femɑ tɑnɑŋ tǝhulu, ɩlɛ Asǝtɔtɩ nyǝ́mɑ mɑɣɑnɑ pɑ tʋɣʋ Tɑkɔŋ hotɑ ɩ ɩsɛntɔɔ kɛlɛ Ɩsɔ ɑtɑkɑɑ kite, nɑ pɑ́ kpɑɣɑ-ɩ nɑ pɑ́ mǝlǝnɑ-ɩ ɩ tǝcɑɣɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S15_4","010_5_4","1SA","5","4","4","Tɛʋ femɑ tɔtɔ, ɩlɛnɑ pɑ́ mɑɣɑnɑ Tɑkɔŋ tɑsɑ hotuɣu kɛ ɩ ɩsɛntɔɔ kɛ́ Ɩsɔ ɑtɑkɑɑ kite nɑ ɩ nyʋɣʋ nɑ ɩ niŋ pǝ pɛlɑɑ, nɑ pǝ́ wɛ nɔnɔkpete, nɑ pǝ́ kɑɑsɩ ɩ pilimile. ");
INSERT INTO dop_vpl VALUES ("S15_5","010_5_5","1SA","5","5","5","Pǝ tɔɔ kɛ́ hɑlǝnɑ sɑŋɑ Tɑkɔŋ kɔtǝlɑɑ, nɑ kʋ lɑɑlɑɑ tǝnɑ mpɑ pɑ wɛ Asǝtɔtɩ tɔ, ye pɑ sʋʋkɩ tʋɣʋ kutuluɣu ŋkʋ kʋ tɑɑ, pɑɑ fɛlǝɣɩ nɔnɔkpete. ");
INSERT INTO dop_vpl VALUES ("S15_6","010_5_6","1SA","5","6","6","Ḿpʋ́ɣʋ́ Tɑcɑɑ tʋwɑ Asǝtɔtɩ nyǝ́mɑ kɛ niŋ nɑ ɩ́ wɑkǝlɩ-wɛ nɑ cɑlǝmpɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S15_7","010_5_7","1SA","5","7","7","Pɑ nɑwɑ mpʋ, ɩlɛnɑ pɑ́ tɔ sɩ: Ɩsɛɣɛlɩ Ɩsɔ ɑtɑkɑɑ kɑɑ cɑɣɑ tɑ́ tɛ. Mpi tɔ, ɩnɩ ɩ tʋnɑ tɑ nɑ tɑ tʋɣʋ kɛ niŋ. ");
INSERT INTO dop_vpl VALUES ("S15_8","010_5_8","1SA","5","8","8","Ḿpʋ́ɣʋ́ Asǝtɔtɩ nyǝ́mɑ tilɑɑ nɑ pɑ́ yɑɑ Filiisi nyǝ́mɑ ɑwulɑɑ kɑkpɑsɩ nɑ pɑ́ pɔɔsɩ-wɛ sɩ: Ɩsǝnɑɣɑ tɩɩ lɑnɑ Ɩsɛɣɛlɩ Ɩsɔ ɑtɑkɑɑ? Ntɛnɑ pɛlɛ sɩ: Ɩ́ ponɑ-ɩ Kɑtɩ. Ɩlɛnɑ Asǝtɔtɩ nyǝ́mɑ ponɑ Ɩsɔ ɑtɑkɑɑ kɛ Kɑtɩ. ");
INSERT INTO dop_vpl VALUES ("S15_9","010_5_9","1SA","5","9","9","Pɑ tɛmɑ Ɩsɔ ɑtɑkɑɑ kɛ ponɑʋ kɛ Kɑtɩ, ɩlɛnɑ Tɑcɑɑ tʋ ɩcɑtɛ tǝnɑ tɔɔ kɛ́ niŋ, nɑ sɔɣɔntʋ sɔsɔɔntʋ kpɑ-wɛ. Ɩ wɑkǝlɑ ɩcɑtɛ yǝlɑɑ tǝnɑ nɑ cɑlǝmpɑɣɑ. Pǝ kpɑɣɑʋ sɔsɑɑ nɑ pǝ́ polo piyɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S15_10","010_5_10","1SA","5","10","10","Ḿpʋ́ɣʋ́ pɑ ponɑ Ɩsɔ ɑtɑkɑɑ kɛ́ Ɩkoloŋ, ɩlɛnɑ pɛlɛ pɑ́ sʋʋ kɑpusi mɑpʋ sɩ: Pɑ kɔnɑ Ɩsɛɣɛlɩ Ɩsɔ ɑtɑkɑɑ kɛ́ tɑ́ tɛ́ sɩ ɩ́ kʋ tɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S15_11","010_5_11","1SA","5","11","11","Ḿpʋ́ɣʋ́ Ɩkoloŋ nyǝ́mɑ nɑ tɑsɑ tiluɣu nɑ pɑ́ koti Filiisi ɑwulɑɑ tǝnɑ nɑ pɑ́ tɔ-wɛ sɩ: Ɩ́ mǝŋnɑ Ɩsɛɣɛlɩ Ɩsɔ ɑtɑkɑɑ kɛ ɩ tǝcɑɣɑlɛ. Ɩ́ tɑɑ kʋ tɑ́ nɑ tɑ yǝlɑɑ. Mpi tɔ, Tɑcɑɑ kɑ tʋwɑ Ɩkoloŋ nyǝ́mɑ kɛ niŋ nɑ toŋ kɛ́, nɑ sǝm sɔɣɔntʋ pɩɩ ɩcɑtɛ tǝnɑ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S15_12","010_5_12","1SA","5","12","12","Lɛlɑɑ tɑ sɩ yɑɑ, ɩlɛ cɑlǝmpɑɣɑ tɔkɑ-wɛɣɛ. Ɩlɛnɑ ɩcɑtɛ tǝnɑ tʋlɩ nɔɣɔ, nɑ tǝ́ wii tǝkpoo nɑ pǝ́ kpɑ ɩsɔtɑɑ. ");
INSERT INTO dop_vpl VALUES ("S16_1","010_6_1","1SA","6","1","1","Ɩsɔtʋnɑɑ nɑɑtosompɔɣɔlɑɣɑ kɛ Ɩsɔ ɑtɑkɑɑ cɑɣɑ Filiisi nyǝ́mɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S16_2","010_6_2","1SA","6","2","2","Ɩlɛnɑ pɑ́ yɑɑ pɑ kɔtǝlɑɑ, nɑ pɑ nɑlɑɑ nɑ pɑ́ pɔɔsɩ-wɛ sɩ: Ɩsǝnɑɣɑ tɩɩ lɑnɑ Tɑcɑɑ ɑtɑkɑɑ? Pepeɣe tɩɩ kpeennɑ-ɩ? ");
INSERT INTO dop_vpl VALUES ("S16_3","010_6_3","1SA","6","3","3","Ntɛnɑ pɑ kɔtǝlɑɑ nɑ pɑ nɑlɑɑ tɔ sɩ: Ye ɩ́ mǝlǝɣǝnɑ Ɩsɛɣɛlɩ Ɩsɔ ɑtɑkɑɑ, ɩ́ tɑɑ mǝŋnɑ-ɩ kpɛtɛ. Amɑ ɩ́ hɑ Ɩsɔ kɛ́ ɩsɑɣɑtʋ hɩɩsʋɣʋ kʋcɔɔʋ. Ɩlɛ wɑɑtʋ ɩnǝɣɩ ɩ́ kɑ́ nyɩ mpi pǝ tɔɔ ɩ tɑ kʋsǝtɑ ɩ niŋ kɛ mǝ tɔɔ tɔ, nɑ ɩ́ wɑɑsɩ-mɛ. ");
INSERT INTO dop_vpl VALUES ("S16_4","010_6_4","1SA","6","4","4","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ pɔɔsɑɑ sɩ: Pepenɑɑ kɛ tɩɩ hɑ-ɩ? Ɩlɛnɑ pɑ kɔtǝlɑɑ nɑ nɑlɑɑ sɩ: Wʋlɑ pɑɣɑ kɑkpɑsɩ, nɑ wʋlɑ mpiyɑɑ kɑkpɑsɩ nɑ pǝ́ kɛɛsǝnɑ Filiisi ɑwulɑɑ kɑkpɑsɩ. Mpi tɔ, kʋtɔŋ kʋlʋmʋɣʋ kpɑnɑ mǝ nɑ mǝ ɑwulɑɑ. ");
INSERT INTO dop_vpl VALUES ("S16_5","010_6_5","1SA","6","5","5","Pǝ wɛɛ sɩ, ɩ́ lɑ cɑlǝmpɑɣɑ lɛɛsǝŋ, nɑ mpiyɑɑ mpɑ pɑ tɔkɩ mǝ tɑwɑ tɔ pɑ lɛɛsǝŋ, nɑ pǝ́ nɑ́ sɩ ɩ́ cɛkǝnɑ Ɩsɔ toŋ. Ntɑnyɩ ɩ kɑɑ tɑsɑ mǝ nɑ mǝ tɩɩŋ nɑ mǝ tɛtʋ kɛ niŋ tʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S16_6","010_6_6","1SA","6","6","6","Pepe tɔɔ kɛ́ mǝ́ cɑɑ sɩ ɩ́ lɑ kɑŋkɑnɑ, ɩsɩɩ Icipiti wulɑʋ nɑ Icipiti nyǝ́mɑ pɑɑ lɑpʋ tɔ? Tɑcɑɑ tʋ-wɛɣɛ wɑhɑlɑ kɛ́. Hɑlǝnɑ pɑ́ yele Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S16_7","010_6_7","1SA","6","7","7","Tɔʋ, pǝnɛntɛ ɩ́ sɑɑkɩ kɛɛkɛ kʋfɑlʋ, nɑ ɩ́ cɑɑ nɑɑŋ totonɑɑ nɑɑlɛ wei ɩ wɛnɑ piyɑ tɔ. Pǝ́ wɛɛ nɑɑŋ wei pɑ tɑ hɑlǝnɑ tɔ. Ɩ́ tʋ-ɩ kɛɛkɛ ɩnɩ, nɑ ɩ́ kpeenɑ ɩ nɑwee kɛ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S16_8","010_6_8","1SA","6","8","8","Ɩlɛnɑ ɩ́ kpɑɣɑ Tɑcɑɑ ɑtɑkɑɑ nɑ ɩ́ tʋ kɛɛkɛ tɑɑ. Ɩlɛnɑ pǝ́ kɑɑsɩ nɑ ɩ́ tʋ ɑtɑkiyɑ nɑkǝlɩ kɑ tɑɑ kɛ́ wontunɑɑ mpɑ ɩ́ lɑpɑ sɩ ɩ́ lɑkɩ Ɩsɔ kɛ́ kʋcɔɔʋ kɛ mǝ ɩsɑɣɑtʋ tɔɔ tɔ. Ɩlɛnɑ ɩ́ sɩɩ Ɩsɔ ɑtɑkɑɑ kɔŋkɔŋ tɑɑ, nɑ ɩ́ yele nɑɑŋ nɑ ɩ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S16_9","010_6_9","1SA","6","9","9","Ɩlɛnɑ ɩ́ nyǝnǝɣǝnɑ-ɩ, ye ɩ kpɑɣɑ toŋɑ mpɑɑʋ nɑ Pɛtɩ-Sɛmɛsɩ tɔɔ, ɩlɛ Tɑcɑɑ lɑpǝnɑ ntɛɣɛ-tʋɣʋ ɩsɑɣɑtʋ ntɩ. Ye pǝ tɑɣɑ mpʋ, ɩlɛ tǝ nyǝmɑɣɑlɛ sɩ pǝ mɑɣɑnɑ-tʋɣʋ yem kɛlɛ, pǝ tɑɣɑ Ɩsɔ lɑpǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S16_10","010_6_10","1SA","6","10","10","Mpʋɣʋlɛ pɑ cɑɑ nɑɑŋ totonɑɑ nɑ pɑ́ tʋ kɛɛkɛ. Ɩlɛnɑ pɑ́ tǝkɩ ɩ nɑwee kɛ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S16_11","010_6_11","1SA","6","11","11","Ɩlɛnɑ pɑ́ tʋ́ Ɩsɔ ɑtɑkɑɑ kɛ kɛɛkɛ tɑɑ, nɑ pɑ́ tʋ́ ɑtɑkiyɑ tɑɑ kɛ́ wʋlɑ mpiyɑɑ, nɑ pǝ pɑɣɑ, nɑ pɑ́ sɩɩ ɑtɑkɑɑ kɔŋkɔŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S16_12","010_6_12","1SA","6","12","12","Tǝnɑɣɑlɛ nɑɑŋ kpɑɣɑ Pɛtɩ-Sɛmɛsɩ mpɑɑʋ kɛ kpɑkpɑɑ, nɑ ɩ́ tɔŋ nɑ ɩ́ wiiki ɩ tɑ hɛlǝnɑ ntɔɣɔŋ yɑɑ mpǝtǝŋ. Ɩlɛnɑ Filiisi ɑwulɑɑ tǝŋ ɩ wɑɑlɩ hɑlǝnɑ Pɛtɩ-Sɛmɛsɩ toŋɑ. ");
INSERT INTO dop_vpl VALUES ("S16_13","010_6_13","1SA","6","13","13","Pɛtɩ-Sɛmɛsɩ nyǝ́mɑ kɑ wɛ tɛtɛkǝlɛ tɑɑ nɑ pɑ́ kʋŋ. Pɑ loosɑ Ɩsɔ ɑtɑkɑɑ, ɩlɛnɑ pɑ lɑŋɑ hʋlʋmɩ. ");
INSERT INTO dop_vpl VALUES ("S16_14","010_6_14","1SA","6","14","15","Kɛɛkɛ tɑlɑ Yosuwee hɑlǝm kɛ Pɛtɩ-Sɛmɛsɩ, ɩlɛnɑ ɩ́ sǝŋ kʋkpɑmʋɣʋ nɑkʋlɩ kʋ kiŋ kɛ tǝnɑ. Ɩlɛnɑ Lefii nyǝ́mɑ tisi Tɑcɑɑ ɑtɑkɑɑ nɑ ɑtɑkiyɑ ŋkɑ kɑ tɑɑ kɑ wɛ wʋlɑ wontu tɔ, nɑ pɑ́ sɩɩ pǝ tǝnɑɣɑ kʋkpɑmʋɣʋ ŋkʋ kʋ tɔɔ. Ḿpʋ́ɣʋ́ pɑ fɑɣɑ kɛɛkɛ kpɑtǝŋ nɑ pɑ́ lɑ́ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ nɑ nɑɑŋ ɩnɩ. Ɩlɛnɑ Pɛtɩ-Sɛmɛsɩ nyǝ́mɑ lɑ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ nɑ kɔtɑsɩ lɛnsɩ. ");
INSERT INTO dop_vpl VALUES ("S16_16","010_6_16","1SA","6","16","16","Filiisi ɑwulɑɑ kɑkpɑsɩ nɑ́ mpʋ, ɩlɛnɑ pɑ́ mǝlɩ Ɩkoloŋ kɛ kʋyɑkʋ ŋkʋ kʋ mɑɣɑmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S16_17","010_6_17","1SA","6","17","18","Wʋlɑ pɑɣɑ kɑkpɑsɩ kɛ pɑ hɑ Tɑcɑɑ kɛ kʋcɔɔʋ kɛ pɑ ɩsɑɣɑtʋ tɔɔ, nɑ pǝ́ kɛɛsǝnɑ pɑ ɑcɑlɛɛ nyʋɣʋ. Pɑɑ koloŋɑ ɑcɑlɛɛ, pɑɑ nnɑ ɑ fɛɩnɑ koloosi tɔ. Asǝtɔtɩ kɛ kʋlʋmtǝlɛ, nɑ Kɑsɑ kɛ kʋlʋmtǝlɛ, nɑ Asǝkɑlɔŋ kɛ kʋlʋmtǝlɛ, nɑ Kɑtɩ kɛ kʋlʋmtǝlɛ, nɑ Ɩkoloŋ kɛ kʋlʋmtǝlɛ. Kʋkpɑmʋɣʋ ŋku kʋ tɔɔ pɑ sɩɩ Tɑcɑɑ ɑtɑkɑɑ kɛ mpʋ tɔɣɔlɛ pǝ tǝnɑ mpi pǝ lɑpɑ tɔ pǝ ɑseetɑ tʋ. Kʋ wɛ Yosuwee hɑlǝm tɑɑ kɛ́ hɑlǝnɑ sɑŋɑ kɛ Pɛtɩ-Sɛmɛsɩ. ");
INSERT INTO dop_vpl VALUES ("S16_19","010_6_19","1SA","6","19","19","Ḿpʋ́ɣʋ́ Tɑcɑɑ kʋwɑ Pɛtɩ-Sɛmɛsɩ nyǝ́mɑ kɛ yǝlɑɑ nɩɩtoso nɑ nɑɑnʋwɑ. Mpi pǝ tɔɔ tɔ, pɑ nyǝnɑ Ɩsɔ ɑtɑkɑɑ tɑɑ. Ɩlɛnɑ pǝ́ wɑkǝlɩ ɩcɑtɛ nyǝ́mɑ lɑŋɑ kɛ sɔsɔm, nɑ pɑ́ cɑɣɑ lǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S16_20","010_6_20","1SA","6","20","20","Tǝnɑɣɑlɛ Pɛtɩ-Sɛmɛsɩ nyǝ́mɑ tɔmɑ sɩ: Awe pǝsǝɣǝnɑ nɑ ɩ́ sǝŋ Tɑcɑɑ Ɩsɔ nɑŋŋtʋ ɩnɩ ɩsɛntɑɑ? Leɣe tɩɩ ponɑ ɑtɑkɑɑ ɩnɩ nɑ ɩ́ hɑtǝlǝnɑ-tʋ? ");
INSERT INTO dop_vpl VALUES ("S16_21","010_6_21","1SA","6","21","21","Ḿpʋ́ɣʋ́ pɑ tilɑɑ nɑ pɑ́ heeli Kiliyɑtɩ-Yeyɑlim nyǝ́mɑ sɩ: Filiisi nyǝ́mɑ kɔnɑ Tɑcɑɑ ɑtɑkɑɑ. Ɩ́ kɔɔ nɑ ɩ́ kpɑɣɑ-ɩ nɑ ɩ́ ponɑ mǝ tɛ. ");
INSERT INTO dop_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Ḿpʋ́ɣʋ́ Kiliyɑtɩ-Yeyɑlim nyǝ́mɑ polɑɑ nɑ pɑ́ kpɑɣɑ Tɑcɑɑ ɑtɑkɑɑ nɑ pɑ́ ponɑ-ɩ nɑ pɑ́ sɩɩ Apinɑtɑpɩ tǝyɑɣɑ tɑɑ kɛ́ pulɑɣɑ tɔɔ. Nɑ ɩ́ kɔtɩ ɩ pǝyɑlʋ Ɩlɑsɑɑ sɩ ɩ́ pɑɑsǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S17_2","010_7_2","1SA","7","2","2","Hɑtoo kʋyɑŋku pɑ sɩɩʋ Tɑcɑɑ ɑtɑkɑɑ kɛ Kiliyɑtɩ-Yeyɑlim tɔ, pǝ leelɑɑ kɛ́. Pɩɩsɩ hiu tǝcu sikinɑ. Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ wiinɑ Tɑcɑɑ kɛ pɩɩsɩ nsɩ sɩ tɑɑ sɩ ɩ́ wɑɑsɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S17_3","010_7_3","1SA","7","3","3","Mpʋɣʋlɛ Sɑmiyɛɛlɩ tɔmɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ sɩ: Ye lotu kʋlʋmtʋ kɛ ɩ́ mǝlǝnɑ Tɑcɑɑ kiŋ, ɩlɛ ɩ yele tʋɣʋ Asǝtɑtɩ lɑɑʋ nɑ ɩ́ lɔ tɩɩŋ wei ɩnɩ ɩ́ ceelɑ mpʋ tɔ. Ɩlɛnɑ ɩ́ ponɑ mǝ lǝmɑɣɑsɛɛ kɛ Tɑcɑɑ tɔɔ nɑ lotu kʋlʋmtʋ, nɑ ɩ́ lɑ ɩ tike kɛ tǝmlɛ. Ɩlɛ ɩ kɑ́ hɛtɩ-mɛɣɛ Filiisi nyǝ́mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S17_4","010_7_4","1SA","7","4","4","Ntɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɔ tɩɩŋ kʋceeliŋ Pɑɑlǝnɑɑ nɑ Asǝtɑtɩ wei pɑ lɑɑkɑɣɑ tɔ nɑ pɑ́ sɛɛ Tɑcɑɑ tike. ");
INSERT INTO dop_vpl VALUES ("S17_5","010_7_5","1SA","7","5","5","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ yɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ: Ɩ́ koti Misipɑ nɑ mɑ́ sǝlǝmǝnɑ-mɛɣɛ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("S17_6","010_7_6","1SA","7","6","6","Ntɛnɑ pɑ́ koti Misipɑ tǝnɑ kɛ kʋyɑkʋ ŋkʋ. Ɩlɛnɑ pɑ́ hɔkɔ nɔɔsɩ nɑ pɑ́ tɔ sɩ: Tǝ wɑkǝlǝnɑ Tɑcɑɑ. Ḿpʋ́ɣʋ́ pɑ lu lʋm nɑ pɑ́ pǝlɩ-wǝɣɩ Tɑcɑɑ ɩsɛntɑɑ sɩ pǝ́ hʋlɩ sɩ Ɩsɔ kɑ hɩɩsɩ pɑ ɩsɑɣɑtʋ. Ɩlɛnɑ Sɑmiyɛɛlɩ tɑɣɑnɩ pɑ tɔmnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S17_7","010_7_7","1SA","7","7","7","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ nɩɩwɑ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ kotɑ Misipɑ, ɩlɛnɑ pɑ ɑwulɑɑ kɑkpɑsɩ kpeɣeli pɑ yoolɑɑ nɑ pɑ́ polo-wɛɣɛ yoonɑʋ. Ɩsɛɣɛlɩ nyǝ́mɑ nɩɩ mpʋ, ɩlɛnɑ sɔɣɔntʋ kpɑ-wɛ nɑ pɑ́ tɔ Sɑmiyɛɛlɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("S17_8","010_7_8","1SA","7","8","8","Tɑɑ hɛɛsɩ Tɑcɑɑ sǝlǝmʋɣʋ kɛ tɑ tɔɔ, hɑlǝnɑ ɩ́ yɑ-tʋɣʋ Filiisi nyǝ́mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S17_9","010_7_9","1SA","7","9","9","Ɩlɛnɑ Sɑmiyɛɛlɩ kpɑ heu ɩfɑtɛ nɑ ɩ́ lɑ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ, nɑ ɩ́ sǝlǝmɩ-ɩ sɩ ɩ́ wɑɑsɩ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ ɩ́lɛ́ ɩ mʋ. ");
INSERT INTO dop_vpl VALUES ("S17_10","010_7_10","1SA","7","10","10","Sɑɑ wei Sɑmiyɛɛlɩ lɑkɑɣɑ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ ɩlɛnɑ Filiisi nyǝ́mɑ polo nɑ pɑ́ niki-wɛɣɛ yoonɑʋ. Tǝnɑɣɑ Tɑcɑɑ yelɑɑ nɑ tɛʋ nɑsɩ-wɛ nɑ pɑ́ se yem yem. Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ kǝlɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S17_11","010_7_11","1SA","7","11","11","Ḿpʋ́ɣʋ́ pɑ lɩɩ Misipɑ nɑ pɑ́ tɔɣɔnɩ Filiisi nyǝ́mɑ nɑ pɑ́ kʋ-wɛ. Hɑlǝnɑ Pɛtɩ-Kɑɑ pǝ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S17_12","010_7_12","1SA","7","12","12","Ɩlɛnɑ Sɑmiyɛɛlɩ sɩɩ pǝlɛ kɛ Misipɑ nɑ Seŋ pɑ hɛkʋ tɑɑ, nɑ ɩ́ tɔ sɩ: Tɑcɑɑ tɔŋnɑ-tʋɣʋ wɑɑsʋɣʋ kɛ hɑlǝnɑ sɑŋɑ. Ɩlɛnɑ ɩ́ yɑɑ-tɛ sɩ Ɩpene-Ɩsɛɛ. Pǝlɛ kʋwɑɑsǝlɛ kɛ pɑ yɑɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S17_13","010_7_13","1SA","7","13","13","Tǝnɑɣɑ Ɩsɔ tisinɑ Filiisi nyǝ́mɑ tǝfɛ. Tɑcɑɑ kɑɣɑtɑɣɑ-wɛɣɛ, pɑ tɑ tɑsɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ kɛ́ kpɑʋ hɑlǝnɑ Sɑmiyɛɛlɩ sǝm. ");
INSERT INTO dop_vpl VALUES ("S17_14","010_7_14","1SA","7","14","14","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ lɛɛkɑ pɑ ɑcɑlɛɛ nnɑ Filiisi nyǝ́mɑ kɑ tɔɣɑɑ tɔ. Pǝ kpɑɣɑʋ Ɩkoloŋ nɑ pǝ́ sɩɩnɑ Kɑtɩ tɔ, nɑ pǝ tɛtʋnɑɑ tǝnɑ. Ɩlɛnɑ hɛɛsʋɣʋ sʋʋ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ Amolii nyǝ́mɑ pɑ hɛkʋ. ");
INSERT INTO dop_vpl VALUES ("S17_15","010_7_15","1SA","7","15","15","Sɑmiyɛɛlɩ pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ ḿpʋ́ɣʋ́ hɑlǝnɑ ɩ sǝm. ");
INSERT INTO dop_vpl VALUES ("S17_16","010_7_16","1SA","7","16","16","Ɩ cɔɔkɑɣɑ pɑɑ pǝnɑɣɑ ŋkɑɣɑ Petɛɛlɩ nɑ Kilikɑɑ nɑ Misipɑ kɛ́ nɑ ɩ́ hʋʋkɩ pɑ tɔmnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S17_17","010_7_17","1SA","7","17","17","Ɩlɛnɑ ɩ́ mǝlǝɣɩ ɩ tɛ Lɑmɑ timpi ɩ ŋmɑ Tɑcɑɑ kɛ kɔtɑɣɑ tǝlɑtɛ tɔ, nɑ ɩ́ pɑɑsǝɣǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɛlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Wɑɑtʋ wei Sɑmiyɛɛlɩ kpɑtǝlɑɑ, ɩlɛnɑ ɩ́ kpɑ ɩ pǝyɑlɑɑ kɛ Ɩsɛɣɛlɩ pɑɑsǝnlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Sɑmiyɛɛlɩ pǝyɑlʋ kɑncɑɑlɑɣɑ nyǝŋ hǝtɛ ntɛ́ Sowɛɛlɩ, nɑ nɑɑlɛ nyǝŋ sɩ Apiyɑ. Pɛɛsepɑ kɛ pɑɑ wɛɛ nɑ pɑ́ lɑkɩ pɑ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Pɔɣɔlɑɣɑ ɩsǝlɛ tɑɑ kɛ́ Sɑmiyɛɛlɩ pǝyɑlɑɑ mpɛ pɑ nyǝnɑɣɑ. Pɑ tɑ tǝŋ ɩ ɩkpɑtɛ. Nɑ pɑ́ mʋɣɩ kʋcɔɔŋ nɑ pɑ́ kɛɛkɩ tɑmpɑnɑ. ");
INSERT INTO dop_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ kotɑɑ nɑ pɑ́ polo Sɑmiyɛɛlɩ kiŋ kɛ Lɑmɑ. ");
INSERT INTO dop_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Nɑ pɑ́ tɔmɩ-ɩ sɩ: Nyǝnɩ, n kpɑtǝlɑɑ. Pǝyele nyɑ́ pǝyɑlɑɑ ɩɩ tǝŋǝɣɩ nyɑ́ ɩkpɑtɛ. Pǝ tɔɔ tɔ, pǝnɛntɑɑ kpɑ-tʋɣʋ wulɑʋ, nɑ ɩ́ hʋʋkɩ tɑ́ tɔm ɩsɩɩ piitimnɑɑ pɑɣɑlɛ wɛnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Ɩsɩɩ pɑ yɔɣɔtʋɣʋ sɩ: Kpɑ-tʋɣʋ wulɑʋ nɑ ɩ́ hʋʋkɩ tɑ tɔm tɔ, Sɑmiyɛɛlɩ lɑŋlɛ tɑ hɛɛnɑ-tɩ. Ɩlɛnɑ ɩ́ sǝlǝmɩ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Mpʋɣʋlɛ Tɑcɑɑ cɔ-ɩ sɩ: Nɩɩnɑ yǝlɑɑ kɛ tǝ tǝnɑ nti pɑ yɔɣɔtǝɣɩ tɔ. Mpi tɔ, pǝ tɑɣɑ nyɑɣɑ pɑ lɔɔkɩ. Amɑ mɑɣɑ pɑ lɔɔkɩ sɩ mɑ́ tɑɑ tɔɣɔ pɑ tɔɔ kɛ́ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Ɩsɩɩ pɑ lɑkʋɣʋ-m hɑtoo kʋyɑŋku mɑ lǝsɑ-wɛɣɛ Icipiti nɑ pǝ́ sɩɩnɑ sɑŋɑ tɔ. Ḿpʋ́ɣʋ́ pɑ lɑkɩ nyɑ́ tɔtɔ. Pɑ lɔ-m kɛ́, nɑ pɑ́ lɑɑkɩ tɩɩŋ. ");
INSERT INTO dop_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Mʋ pɑ kʋsǝlǝmʋtʋ. Amɑ kpɑɑlɩ-wɛɣɛ teu nɑ ń lɑ nɑ pɑ́ cɛkǝnɑ mpi pǝ wɛɛ sɩ pɑɑ lɑ pɑ wulɑʋ nɑ mpi ɩ́lɛ́ ɩ kɑ lɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Mpʋɣʋlɛ Sɑmiyɛɛlɩ lɑpɑ ɩsɩɩ Tɑcɑɑ kɛɛsʋɣʋ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ heelɑ sɑmɑɑ sɩ: Wulɑʋ ɩnɩ ɩ kɑ lɑ-mɛɣɛ mpi mpi tɔɣɔlɔ. Ɩ kɑ́ kpɑɣɑ mǝ pǝyɑlɑɑ nɑ ɩ́ lɑ-wɛɣɛ ɩ yoolɑɑ, nɑ pɑ́ pɑɑsǝɣǝnɑ ɩ yoou kɛɛkɛnɑɑ. Ɩlɛnɑ lɛlɑɑ kɛ kpɑɣɑnǝŋ cɑɣɑlɑɑ, nɑ lɛlɑɑ kpɑkǝɣɩ ɑsewɑ kɛ ɩ nɔɣɔ tɔɔ kɛ́ wɑɑtʋ wei ɩ lɩɩkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Ɩ kɑ́ kpɑ lɛlɑɑ kɛ yoolɑɑ iyɑɣɑ (1000) nyʋɣʋ nyǝ́mɑ, nɑ lɛlɑɑ kɛ nɩɩlɛ nɑ nɑɑnʋwɑ nyʋɣʋ nyǝ́mɑ. Lɛlɑɑ kɑ hɑlǝɣɩ ɩ tɑwɑ nɑ pɑ́ kʋŋ, nɑ lɛlɑɑ nɑ́ɑ́ luki yoou wontu nɑ pǝ kɛɛkɛnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Ɩ kɑ́ lɑ mǝ pɛɛlɑɑ kɛ mʋtʋ sɑɑlɑɑ, nɑ potopotonɑɑ tʋlɑɑ, nɑ tulɑɑlʋnɑɑ lɑtɑɑ. ");
INSERT INTO dop_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Ɩ kɑ kpɑɣɑ mǝ tɑwɑ kʋpɑnɑ nɑ ɩ́ cɛlɑ ɩ tǝmlɛ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Nɑ ɩ́ kpɑɣɑ mǝ kʋhɑlǝm nɑ mǝ lɛsɛŋ tɩɩŋ kʋlʋlʋm hɔɣɔlǝŋ nɑɑnʋwɑ tɑɑ kʋlʋmʋɣʋ, nɑ ɩ́ cɛlɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ ɩ tǝmlɛ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Ɩ kɑ́ kpɑɣɑ mǝ tǝmlɛ nyǝ́mɑ ɑpɑlʋ nyǝ́mɑ, nɑ ɑlʋ nyǝ́mɑ, nɑ mǝ tɔlɑ wenɑ ɩ́ lɑkǝnɑ tǝmɑ tɔ nɑ ɩ́ lɑkǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Ɩnɩ ɩ kɑ kpɑɣɑnɑ mǝ hʋntʋ wontu hɔɣɔlǝŋ nɑɑnʋwɑ tɑɑ kʋlʋmʋɣʋ, nɑ mɩɩ pǝsɩ ɩ yomɑɑ. ");
INSERT INTO dop_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Wɑɑtʋ ɩnǝɣɩ ɩ́ kɑ́ wiikinɑ Tɑcɑɑ kɛ mǝ wulɑʋ ɩnɩ ɩ tɔm. Amɑ ɩ́lɛ́ ɩ kɑɑ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Ḿpʋ́ɣʋ́ sɑmɑɑ kisɑ Sɑmiyɛɛlɩ tɔm ntɩ nɑ pɑ́ tɔ sɩ: Aɑɩ, pǝ wɛɛ sɩ tǝ́ wɛɛnɑ wulɑʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Nɑ tǝ́ wɛɛ ɩsɩɩ piitimnɑɑ lɛlɑɑ. Ɩ kɑ hʋʋkɩ tɑ́ tɔm nɑ ɩ́ tɛɛkɩ-tʋɣʋ nɔɣɔ nɑ ɩ́ lɑ tɑ́ yoolɑɑ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Ɩlɛnɑ Sɑmiyɛɛlɩ tɛlǝsɩ tɔm ntǝɣɩ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Ntɛnɑ Tɑcɑɑ sɩ: Nɩɩnɑ-wɛ nɑ ń kpɑ-wɛɣɛ wulɑʋ. Pǝlɛ pǝ wɑɑlɩ kɛ́ Sɑmiyɛɛlɩ tɔmɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ pɑɑ wei ɩ́ kpe. ");
INSERT INTO dop_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Pɛncɑmɛɛ tʋ nɔɣɔlʋ ɩ kɑ wɛnnɑ, nɑ pɑ́ yɑɑ-ɩ sɩ, Kisi, nɑ ɩ cɑɑ sɩ Apiyɛlɩ. Ɩ́lɛ́ ɩ cɔsɔnɑɑ ntɛ́ Selo nɑ Pekolɑtɩ nɑ Afiyɑ. Apɑlʋ ɩnɩ ɩ kɑ wɛnɑ ɑlɑɑfǝyɑ kɛ́ nɑ kpelikpekɑ. ");
INSERT INTO dop_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Ɩ kɑ wɛnɑ pǝyɑlʋ nɑ pɑ́ yɑɑ-ɩ sɩ Sɑyuli. Ɩ sǝŋɑ ɩfepu kɛ́, nɑ ɩ tɛɛ Ɩsɛɣɛlɩ ɩfepiyɑ tǝnɑɣɑ teu. Pǝ́cɔ́ ɩ tɛɛ-wɛɣɛ nyʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Kisi kpɑŋɑsɩ ɑlʋnyǝnsɩ toolɑɑ. Ɩlɛnɑ ɩ́ tɔ ɩ pǝyɑlʋ Sɑyuli sɩ: Kpɑɣɑ tǝmlɛ tʋ nɔɣɔlʋ nɑ nyɑ́ nɑ-ɩ ɩ́ pɛɛkɩ kpɑŋɑsɩ nsɩ. ");
INSERT INTO dop_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Ḿpʋ́ɣʋ́ pɑ fɑɣɑnɑ Ɩfǝlɑyim pʋɣʋ tɑɑ, nɑ pɑ́ tɛsɩ Sɑlisɑ tɛtʋ, pɑ tɑ nɑ-sɩ. Ɩlɛnɑ pɑ́ polo Sɑɑlim tɛtʋ tɑɑ, sɩ fɛɩ tǝnɑ. Nɑ pɑ́ cɔɔ Pɛncɑmɛɛ tɛtʋ, kpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Pɑ kɔmɑ nɑ pɑ́ tɑlɑ Sufɩ tɛtʋ tɑɑ, ɩlɛnɑ Sɑyuli tɔ ɩ tǝmlɛ tʋ sɩ: Kɔɔ tǝ́ mǝlɩ, pǝ tɑɑ kɔɔ nɑ mɑ cɑɑ sɔɔ kpɑŋɑsɩ tɔm nɑ ɩ́ nǝɣǝsǝɣɩ tɑ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Kɛlɛnɑ tǝmlɛ tʋ tɔ Sɑyuli sɩ: Ɩsɔ yʋlʋ nɔɣɔlʋ ɩ wɛ ɩcɑtɛ tǝnɛ tǝ tɑɑ cǝnɛ. Ɩ nyʋɣʋ kʋlɑɑ kɛ́, nɑ tǝ tǝnɑ nti ɩ yɔɣɔtǝɣɩ tɔ tǝ lɑkɩ ḿpʋ́ɣʋ́. Tǝ́ polo nɑ tǝ́ nɑ-ɩ. Ntɑnyɩ ɩ kɑ́ hʋlɩ-tʋɣʋ mpɑɑʋ ŋku tɩɩ tǝŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Ntɛnɑ Sɑyuli pɔɔsɩ-ɩ sɩ: Nɑ ye tǝ puki, pepeɣe tɩɩ kpɛŋnɑ nɑ tǝ́ hɑ Ɩsɔ yʋlʋ ɩnɩ? Mpi tɔ, kʋtɔɣɔʋ tɛmɑ tɑ huluŋ tɑɑ. Pǝyele tǝ fɛɩnɑ kʋhɑʋ nɑkʋlɩ sɩ tɩɩ cɛlɛ-ɩ. Yɑɑwe? ");
INSERT INTO dop_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Ḿpʋ́ɣʋ́ tǝmlɛ tʋ cɔwɑ sɩ: Mɑ tɔkɑ mɑ tɔɔ cǝnɛɣɛ liɣitee nyǝɣǝliyɑ. Mɑɑ hɑ-kɛɣɛ Ɩsɔ yʋlʋ nɑ ɩ́ hʋlɩ-tʋɣʋ tɑ́ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("S19_9","010_9_9","1SA","9","9","11","Ḿpʋ́ɣʋ́ Sɑyuli nɔɣɔ tǝkpɑʋ sɩ: Kʋpɑm kɛ́, tǝ polo. Ɩlɛnɑ pɑ́ tɛɛ ɩcɑtɛ nte tǝ tɑɑ Ɩsɔ yʋlʋ kɑ wɛɛ tɔ. Pɑ kpɑɑkɑɣɑ ɩcɑtɛ tɔɔ, ɩlɛ pɑ sulɑ pɛɛlɑɑ ntɛ́ nɑ pɑ́ tiiki pɔɣɔ. Ntɛnɑ pɑ́ pɔɔsɩ pɛlɛ sɩ: Nɑlʋ wɛ ɩcɑtɛ tɑɑ? (Pɩɩ wɛ lɔŋtɑɑ tɔ, pɑ yɑɑkɑɣɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ kɛ́ sɩ nɑlʋ. Nɑ pɑɑ wɑɑtʋ wei kɛ́ nɔɣɔlʋ cɑɑ Ɩsɔ kɛ́ pɔɔsʋɣʋ kɛ nɑtǝlɩ, pɑ tɔŋ kɛ́ sɩ, tǝ́ polo nɑlʋ tɛ). ");
INSERT INTO dop_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Ɩlɛnɑ pɛɛlɑɑ mpɛ sɩ: Ɛɛ, ɩ wɛ ɩcɑtɛ tɑɑ. Mpi tɔ, sɑŋɑ kɛ ɩ kɔmɑ sɩ yǝlɑɑ lɑkɩ kɔtɑɣɑ kɛ tontoŋle tɔɔ. Ɩ́ polo lɔŋ. ");
INSERT INTO dop_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Ɩ́ kɑ́ mɑɣɑnɑ-ɩ nɑ pǝ́cɔ́ ɩ́ kpɑ tɔɣɔʋ. Pǝ tɑɣɑ pʋlʋ, pɑ tɑŋɑ-ɩ kɛ́ sɩ ɩ́ tǝŋsɩ kɔtɑɣɑ kɛ nɔɣɔ kʋpɑŋkɑ. Ɩlɛnɑ pǝ́cɔ́ mpɑ pɑ yɑɑwɑ tɔ pɑ́ tɔɣɔ. Ɩ́ polo tǝkpɩɩ, ɩ́ kɑ́ mɑɣɑnɑ-ɩ nɑ pǝ́cɔ́ ɩ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Ɩlɛnɑ Sɑyuli pɑ́ tɛɛ. Pɑ sʋʋ ɩcɑtɛ tɑɑ, ɩlɛ Sɑmiyɛɛlɩ lɩɩwɑɣɑlɛ sɩ ɩ kpɑɑkɩ tǝkɔtǝlɛ kɛ tontoŋle tɔɔ, nɑ pɑ́ sulinɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Kʋyɑkʋ ŋku kʋ yɑkɑɣɑ nɑ pǝ feŋ nɑ Sɑyuli tɑkɩ tɔ, Tɑcɑɑ kɑ cǝpɑ Sɑmiyɛɛlɩ kɛ sǝkpɑlʋɣʋ sɩ: ");
INSERT INTO dop_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","Cele wɑɑtʋ ɩnɛɣɛ mɑɑ yele nɑ Pɛncɑmɛɛ tʋ nɔɣɔlʋ ɩ́ kɔɔ, nɑ ń kpɑ-ɩ mɑ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ nɑ ń pǝlɩ-ɩ nim, nɑ ɩ́ wɑɑsɩ-wɛɣɛ Filiisi nyǝ́mɑ niŋ tɑɑ. Mpi tɔ, mɑ nɩɩ pɑ kɑpusi, ɩlɛnɑ mɑ́ nyǝnnɑ pɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Pǝ kɔmɑ nɑ Sɑmiyɛɛlɩ loosi Sɑyuli kɛ kpɑkpɑɑ, ɩlɛnɑ Tɑcɑɑ heeli-ɩ sɩ: Wei ɩnɩ ɩ tɔm mɑɑ heelɑ-ŋ sɩ ɩ kɑ́ tɔɣɔ mɑ yǝlɑɑ tɔɔ kɛ́ kɑwulɑɣɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Ḿpʋ́ɣʋ́ Sɑyuli kpǝtǝnɑ Sɑmiyɛɛlɩ kɛ nɔnɔɣɔ nɑ ɩ́ tɔmɩ-ɩ sɩ: Hɑɩ, lɑ suulu nɑ ń hʋlɩ-m nɑlʋ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Mpʋɣʋlɛ Sɑmiyɛɛlɩ sɩ: Mɑɣɑlɛ nɑlʋ. Tɛɛ-m nɔɣɔ nɑ tǝ́ kpɑ tǝkɔtǝlɛ kɛ tontoŋle tɔɔ, nɑ mɑ́ nɑ-mɛ tǝ́ tɔɣɔ. Kʋ femɑ, ɩlɛ mɑ cɔ-ŋ nyɑ́ kʋpɔɔsʋtʋnɑɑ, ɩlɛnɑ ɩ́ kpe. ");
INSERT INTO dop_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Sɑŋɑ kʋyɛɛŋ tooso kɔlɔ nyɑ́ kpɑŋɑsɩ lepɑ tɔ. Tɑɑ nǝɣǝsɩ sɩ tɔm, pɑ hii-sɩ. Amɑ sɔsɔɔntʋ ntɛ́ sɩ nyɑ́ nɑ nyɑ́ cɑɑ tǝyɑɣɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tɛɛlǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Ntɛnɑ Sɑyuli cɔ sɩ: Mɑ kpekǝle kɛnɑ sǝkpete kɛ Ɩsɛɣɛlɩ tɑɑ. Pǝ́cɔ́ mɑ lʋlʋɣʋ nyǝ́mɑ tɑ niinɑ ɩsǝlɛ kɛ Pɛncɑmɛɛ kpekǝle tɑɑ. Ɩlɛ pepe tɔɔ kɛ́ n heeliɣi-m mpʋ? ");
INSERT INTO dop_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Mpʋɣʋlɛ Sɑmiyɛɛlɩ kpɑɣɑ Sɑyuli nɑ ɩ tǝmlɛ tʋ nɑ ɩ́ sʋʋnɑ-wɛɣɛ kutuluɣu tɑɑ, nɑ ɩ́ sɩɩ-wɛɣɛ tǝcɑɣɑlɛ kʋpɑntɛ kɛ tɔɣɔlɑɑ hɛkʋ tɑɑ. Pɛlɛ pɑɑ wɛ ɩsɩɩ yǝlɑɑ hiu nɑ nɑɑnʋwɑ kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Ɩlɛnɑ Sɑmiyɛɛlɩ tɔ mʋtʋ sɑɑlʋ sɩ: Kɔnɑ cǝkɑ ŋkɑ mɑɑ heelɑ-ŋ sɩ ń sɩɩnɑ kɑ mpɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Mpʋɣʋlɛ mʋtʋ sɑɑlʋ lǝsɑ yule tǝcu nɑ ɩ́ tʋ Sɑyuli. Ntɛnɑ Sɑmiyɛɛlɩ tɔ sɩ: Tɔɣɔ-tɩ, nyɑɣɑ pɑ sɩɩwɑ sɑɑ wei mɑ yɑɑ sɑmɑɑ tɔ. Ɩlɛnɑ pɑ́ kpɛntɩ nɑ pɑ́ tɔɣɔ kʋyɑkʋ ŋkʋ. ");
INSERT INTO dop_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Pɑ lɩɩ tǝkɔtǝlɛ kɛ tontoŋle tɔɔ nɑ pɑ́ tii ɩcɑtɛ tɑɑ, ɩlɛnɑ pɑ́ lɑ́ fɑɑci kɛ kutuluɣu pɑtɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Kʋ femɑ, ɩlɛnɑ Sɑmiyɛɛlɩ kʋlɩ tɑnɑŋ tɛɛ kɛ́ sɑɑ wei hɑɣɑ yʋɣɩ kɑ tʋ tɔ, nɑ ɩ́ yɑɑ Sɑyuli sɩ: Kʋlɩ nɑ mɑ́ lǝsɩ-ŋ mpɑɑʋ. Ɩlɛnɑ pɑ́ tʋ́ mpɑɑʋ kɛ pɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Pɑ lɩɩkɑɣɑ ɩcɑtɛ, ɩlɛnɑ ɩ́ tɔmɩ-ɩ sɩ: Heeli nyɑ́ tǝmlɛ tʋ sɩ ɩ́ tɛɛ-tʋɣʋ nɔɣɔ. Tǝmlɛ tʋ tɛɛwɑ, ɩlɛnɑ Sɑmiyɛɛlɩ tɔ Sɑyuli sɩ: Pǝnɛntɑɑ sǝŋ nɑ mɑ́ heeli-ŋ Tɑcɑɑ tɔm ɩlɛ. ");
INSERT INTO dop_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Mpʋɣʋlɛ Sɑmiyɛɛlɩ lǝsɑ nim nɑ kpɑlipiyɑ, nɑ ɩ́ pǝlɩ Sɑyuli nyʋɣʋ tɑɑ, nɑ ɩ́ wɑɣɑlɩ-ɩ nɑ ɩ́ tɔ sɩ: Tɑcɑɑ lǝsǝnɑ-ŋ sɩ ń lɑ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("S110_2","010_10_2","1SA","10","2","2","N yekuɣu-m sɑŋɑ ɩsǝntɔ tɔ, n kɑ́ mɑɣɑnɑ ɑpɑlɑɑ nɑɑlɛ kɛ Lɑsɛɛlɩ pǝlɑɑʋ kiŋ kɛ Pɛncɑmɛɛ nyǝ́mɑ toŋɑ tɔɔ kɛ Sɛlǝsɑ. Pɑɑ heeli-ŋ sɩ pɑ nɑwɑ kpɑŋɑsɩ nsi n pɛɛkɑɣɑ tɔ. Hɑlɩ nyɑ́ cɑɑ yelɑ kpɑŋɑsɩ tɔm nɑ ɩ nǝɣǝsɩ mǝ tɔm nɑ ɩ́ tɔŋ sɩ: Ɩsǝnɑɣɑ mɑɑ lɑ mɑ pǝyɑlʋ tɔm? ");
INSERT INTO dop_vpl VALUES ("S110_3","010_10_3","1SA","10","3","3","Ɩ́ lɩɩkɩ tǝnɑ nɑ ɩ́ tɑlɑ Tɑpɔɔ tʋɣʋ sɔsɔɔʋ tɛɛ, ɩlɛnɑ ɩ́ sulinɑ ɑpɑlɑɑ tooso nɑ pɑ́ puki kɔtɑɣɑ lɑpʋ kɛ Petɛɛlɩ. Lɛlʋ tɔkɑ pinɑsɩ tooso, nɑ lɛlʋ kɛ potopoto kɑkɑlɑsɩ tooso, nɑ lɛlʋ nɑ́ɑ́ tɔkɑ sʋlʋm huluɣu. ");
INSERT INTO dop_vpl VALUES ("S110_4","010_10_4","1SA","10","4","4","Pɑɑ pɔɔsɩ nyɑ́ ɑlɑɑfǝyɑ tɔɔ, nɑ pɑ́ hɑ-ŋ potopotonɑɑ nɑɑlɛ, nɑ ń mʋ pɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S110_5","010_10_5","1SA","10","5","5","N lɩɩkɩ tǝnɑ nɑ n tɑlɑ Ɩsɔ pulɑɣɑ, kɛ timpi Filiisi nyǝ́mɑ yoolɑɑ tǝsikile wɛɛ tɔ, ɩsɩɩ n sʋʋkɩ ɩcɑtɛ tɔ, n kɑ́ sulinɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ kpekǝle nɑ pɑ́ lɩɩnɑ tǝkɔtǝlɛ kɛ tontoŋle tɔɔ, nɑ pɑ́ mɑkɩ cǝmǝŋ nɑ ɑkilimɑ nɑ pɑ́ hʋlǝɣɩ hǝsɩ nɑ pɑ́ pɑɑkɩ nɑ pɑ́ sɑŋ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("S110_6","010_10_6","1SA","10","6","6","Tɑcɑɑ Feesuɣu kɑ tii nyɑ́ tɔɔ, nɑ nyɑ́ nɑ-wɛ ɩ́ kpɛntɩ nɑ ɩ́ pɑɑ nɑ ɩ́ sɑ Ɩsɔ, nɑ pǝ́ lɑɣɑsɩ-ŋ nɑ ń wɛɛ ɩsɩɩ yʋlʋ kʋfɑlʋ. ");
INSERT INTO dop_vpl VALUES ("S110_7","010_10_7","1SA","10","7","7","Ye yɑɑsinɑɑ pɑnɛ pɑ tɛɛ nyɑ́ tɔɔ, ɩlɛ ń lɑ nti tǝ wɛ lɑpʋ tɔ. Mpi tɔ, Tɑcɑɑ wɛ nyɑ́ wɑɑlɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S110_8","010_10_8","1SA","10","8","8","Pǝlɛ pǝ wɑɑlɩ, ɩlɛnɑ ń tɛɛ-m nɔɣɔ nɑ ń polo Kilikɑɑ nɑ mɑ́ sǝŋ nyɑ́ wɑɑlɩ nɑ mɑ́ lɑ́ kɔtɑsɩ nsi kɔkɔ nyɑɣɑ sɩ tǝnɑ tɔ nɑ ciikuɣu nyǝŋkɑ. Ɩlɛnɑ ń tɑŋ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ nɑ mɑ́ kɔɔ nɑ mɑ́ hʋlɩ-ŋ nti n kɑ́ lɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S110_9","010_10_9","1SA","10","9","9","Too ɩsɩɩ Sɑyuli hɑʋ siɣile sɩ ɩ tɛɛkɩ tɔ, Ɩsɔ Feesuɣu lɑɣɑsɑ-ɩ kɛlɛ, nɑ ɩ́ nɑ́ pǝ tǝnɑɣɑ kʋyɑkʋ ŋkʋ, ɩsɩɩ Sɑmiyɛɛlɩ kɑ kɛɛsʋɣʋ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S110_10","010_10_10","1SA","10","10","10","Pɑ tɑlɑ Kipeyɑ, ɩlɛ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ cɑŋɑ lɩɩ ɩ sǝŋʋɣʋ ntɛ́, nɑ Ɩsɔ Feesuɣu tii ɩ́ tɔɔ nɑ ɩ́ sʋʋ pɑɑlɛ kɛ pɑ hɛkʋ tǝnɑ nɑ ɩ́ sɑŋ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("S110_11","010_10_11","1SA","10","11","11","Yǝlɑɑ mpɑ pɑɑ nyǝ́mɑ-ɩ hɑtoo lɔŋ tɔ, pɑ nɑ́ ɩ́ nɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ pɑ lɑkɩ mpʋ, ɩlɛnɑ pɑ́ pɔɔsǝɣɩ tǝmɑɣɑ yǝlɑɑ tɑɑ sɩ: Pepe mɑɣɑnɑ Kisi pǝyɑlʋ Sɑyuli ye? Ɩ́lɛ́ ɩ́ pɑɑkɩ nɑ ɩ́ sɑŋ Ɩsɔ tɔtɔɣɔ? ");
INSERT INTO dop_vpl VALUES ("S110_12","010_10_12","1SA","10","12","12","Mpʋɣʋlɛ Kipeyɑ tʋ nɔɣɔlʋ nɔɣɔ tǝkpɑʋ sɩ: Nɑ ɑweɣelɛ pɑ cɑɑ? Ɩlɛnɑ pǝ́ pǝsɩ yǝlɑɑ kɛ ɩtuule sɩ: Sɑyuli nɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ pɑ pɑɑkǝnɑ nɑ pɑ́ sɑŋ Ɩsɔ? ");
INSERT INTO dop_vpl VALUES ("S110_13","010_10_13","1SA","10","13","13","Sɑyuli tɛmɑ pɑɑlɛ nɑ Ɩsɔ sɑm kɛ mpʋ, ɩlɛnɑ ɩ́ kpɑ tǝkɔtǝlɛ kɛ tontoŋle tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S110_14","010_10_14","1SA","10","14","14","Ḿpʋ́ɣʋ́ ɩ cɑɑ sǝkpelu nɔɣɔlʋ ɩ pɔɔsɑ ɩ nɑ tǝmlɛ tʋ sɩ: Leɣe ɩ́ kɑ polɑɑ ye? ");
INSERT INTO dop_vpl VALUES ("S110_15","010_10_15","1SA","10","15","15","Kɛlɛnɑ ɩ́ cɔ sɩ: Tǝ polɑ kpɑŋɑsɩ pɛɛkʋɣʋ tǝ tɑ keesi-sɩ, ɩlɛnɑ tǝ́ polo Sɑmiyɛɛlɩ kiŋ. Ntɛnɑ ɩ́lɛ́ sɩ: Kɛɛsɩ-m nti Sɑmiyɛɛlɩ heelɑ-ŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S110_16","010_10_16","1SA","10","16","16","Mpʋɣʋlɛ sɩ: Ɩ heelɑ-tʋɣʋ tǝfoo sɩ pɑ nɑwɑ kpɑŋɑsɩ. Amɑ ɩ tɑ heeli ɩ cɑɑ sǝkpelu kɛ nti Sɑmiyɛɛlɩ kɑ heelɑ-ɩ sɩ ɩ kɑ́ tɔɣɔ kɑwulɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ kotɑ Ɩsɛɣɛlɩ nyǝmɑ kɛ Ɩsɔ tǝyɑɣɑ tɑɑ kɛ́ Misipɑ. ");
INSERT INTO dop_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Nɑ ɩ́ heeli-wɛ sɩ Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ yɔɣɔtɑɑ sɩ: Mɑ́ lǝsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ mɛɣɛ Icipiti, nɑ mɑ́ yɑ-mɛɣɛ pɑ nɑ piitimnɑɑ mpɑ pɑ ŋmɑkǝlɑ-mɛ tɔ, pɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Nɑ sɑŋɑ mǝ lɔɔkɩ mǝ Ɩsɔ mɑ wei, mɑ yɑpɑ-mɛɣɛ mǝ cɔɔsɛɛnɑɑ nɑ mǝ wɑhɑlɑnɑɑ tɑɑ tɔ. Hɑlǝnɑ ɩ́ tɔŋɩ-m sɩ mɑ́ kpɑ-mɛɣɛ wulɑʋ. Tɔʋ, pǝnɛntɛ ɩ́ lɩɩ Tɑcɑɑ ɩsɛntɑɑ ɩsɩɩ mǝ kpekɑ nɑ mǝ lʋlʋŋ wɛɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Mpʋɣʋlɛ Sɑmiyɛɛlɩ yɑɑ Ɩsɛɣɛlɩ kpekɑ tǝnɑɣɑ kʋlʋm kʋlʋm. Ɩlɛnɑ pǝ́ kpɑ Pɛncɑmɛɛ nyǝntɛ. ");
INSERT INTO dop_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Ntɛnɑ ɩ́ yɑɑ Pɛncɑmɛɛ kpekǝle kɛ lʋlʋɣʋ lʋlʋɣʋ, nɑ pǝ́ kpɑ Mɑtili nyǝŋkʋ. Pǝ wɑɑlɩ kɛ́ ɩ yɑɑ yʋlʋ yʋlʋ, nɑ pǝ́ kpɑ Kisi pǝyɑlʋ Sɑyuli, nɑ pɑ́ pɛɛkɩ-ɩ pɑ tɑ nɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Ḿpʋ́ɣʋ́ pɑ tɑsɑ Tɑcɑɑ kɛ pɔɔsʋɣʋ sɩ: Nɑ pʋntʋ ɩnɩ ɩ kɔmɑ cǝnɛ? Ɩlɛnɑ Tɑcɑɑ sɩ: Ɩnɩ ɩ ŋmɛlǝnɑ ntɛɣɛ wontu huɣule wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Ḿpʋ́ɣʋ́ yǝlɑɑ kpɑɣɑ sewɑ nɑ pɑ́ polo pɑ́ kpɛɛ Sɑyuli tǝnɑ. Pɑ tɑnɑ-ɩ sɑmɑɑ tɑɑ tɔ, ɩ tɛɛ pɑ tǝnɑɣɑ nyʋɣʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Mpʋɣʋlɛ Sɑmiyɛɛlɩ heelɑ yǝlɑɑ tǝnɑ sɩ: Ɩɩ nɑɑkɩ wei ɩnɩ Tɑcɑɑ lǝsɑɑ tɔɣɔlɔ. Ɩ nɑ nɔɣɔlʋ pɑ tɑ nǝɣǝsɩ tɑ tɑɑ cǝnɛ. Ɩlɛnɑ yǝlɑɑ tǝnɑ wiliti sɩ: Mǝ nɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("S110_25","010_10_25","1SA","10","25","25","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ kɛɛsɑ sɑmɑɑ kɛ pɑ nɑ wulɑʋ pɑ tǝmɑ, hɑlǝnɑ ɩ́ ŋmɑɑ-tǝɣɩ tɑkǝlɑɣɑ tɑɑ, nɑ ɩ́ sɩɩ-tǝɣɩ Ɩsɔ ɑtɑkɑɑ kiŋ. Pǝ wɑɑlɩ, ɩlɛnɑ ɩ́ yɑsɩ yǝlɑɑ nɑ pɑɑ ɑwe kpe ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("S110_26","010_10_26","1SA","10","26","26","Ḿpʋ́ɣʋ́ Ɩsɔ tʋ yoolɑɑ kpelikpekɑ nyǝ́mɑ nɑpǝlɩ pɑ tɑɑ, nɑ pɑ́ wɛɛ Sɑyuli wɑɑlɩ nɑ ɩ́ kpe ɩ tɛ Kipeyɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S110_27","010_10_27","1SA","10","27","27","Pɑɑ nɑ mpʋ tɛtɛlɑtɑɑ kɑ wɛɛ nɑ pɑ́ tɔŋ sɩ: Ɩsǝnɑɣɑ ɩnɛ ɩ́lɛ́ ɩ kɑ́ lɑ nɑ ɩ́ wɑɑsɩ-tʋ? Nɑ pɑ́ footiɣi-ɩ. Pǝ́cɔ́ pɑ tɑ hɑ-ɩ kʋcɔɔʋ nɑkʋlɩ. Amɑ Sɑyuli nɑ́ tɑ́ kpɑɣɑ-tɩ nɑ ɩ́ yɑɑ sɩ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S111_1","010_11_1","1SA","11","1","1","Ḿpʋ́ɣʋ́ wɑɑtʋ nɔɣɔlʋ Amoni wulɑʋ Nɑhɑsɩ nɑ ɩ yoolɑɑ, pɑ polɑɑ nɑ pɑ́ siki Yɑpɛɛsɩ kɛ Kɑlɑɑtɩ. Mpʋɣʋlɛ Yɑpɛɛsɩ nyǝ́mɑ tǝnɑ tɔmɑ-ɩ sɩ: Tɑ́ nɑ-ŋ tǝ́ pɛɛlɩ nɔɣɔ nɑ tǝ́ lɑkɩ-ŋ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("S111_2","010_11_2","1SA","11","2","2","Tǝnɑɣɑlɛ Nɑhɑsɩ tɔmɑ sɩ: Ye ɩ́ tisɑɑ nɑ mɑ́ wɔɣɔsɩ mǝ tǝnɑ mǝ ntɔɣɔŋ ɩsɛ nɑ pǝ́ tʋ Ɩsɛɣɛlɩ tǝnɑɣɑ fɛɛlɛ, ɩlɛ mɑ́ nɑ-mɛ tǝ pɛɛlɩ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S111_3","010_11_3","1SA","11","3","3","Kɛlɛnɑ Yɑpɛɛsɩ nyʋɣʋ nyǝ́mɑ tɔ sɩ: Hɑ-tʋɣʋ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ nɑ tǝ́ tili Ɩsɛɣɛlɩ tɛtʋ tǝnɑ tɑɑ. Ye nɔɣɔlʋ fɛɩ sɩ ɩ́ wɑɑsɩ-tʋ, ɩlɛ tǝ hɑ-ŋ tɑ́ tɩ. ");
INSERT INTO dop_vpl VALUES ("S111_4","010_11_4","1SA","11","4","4","Ḿpʋ́ɣʋ́ tillɑɑ polɑ Sɑyuli tɛɣɛ Kipeyɑ nɑ pɑ́ heeli-tǝɣɩ yǝlɑɑ. Ɩlɛnɑ pɑ́ tʋlɩ nɔɔsɩ nɑ pɑ́ wii tǝkpoo. ");
INSERT INTO dop_vpl VALUES ("S111_5","010_11_5","1SA","11","5","5","Ɩlɛ Sɑyuli lɩɩnɑ tɑɑlɛ ntɛ́ nɑ ɩ́ wɛ ɩ nɑɑŋ wɑɑlɩ, nɑ ɩ́ pɔɔsɩ sɩ: Pepe lɑpɑ nɑ yǝlɑɑ wiiki mpʋ? Ɩlɛnɑ pɑ́ kɛɛsɩ-ɩ nti Yɑpɛɛsɩ tillɑɑ yɔɣɔtɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S111_6","010_11_6","1SA","11","6","6","Ɩ nɩɩwɑ mpʋ, ɩlɛnɑ Ɩsɔ Feesuɣu tii ɩ tɔɔ nɑ ɩ pɑ́ɑ́nɑ́ huu sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("S111_7","010_11_7","1SA","11","7","7","Tǝnɑɣɑ ɩ kpɑ nɑɑŋ nɑɑlɛ nɑ ɩ́ sɛtɩ-ɩ tilimɑ, nɑ ɩ tilinɑ Ɩsɛɣɛlɩ tɛtʋ tǝnɑ tɑɑ sɩ: Ye pǝ cǝpɑ wei nɑ ɩ́ tɑ́ tǝŋ Sɑyuli nɑ Sɑmiyɛɛlɩ pɑ wɑɑlɩ kɛ yoou tɑɑ, ḿpʋ́ɣʋ́ pɑɑ lɑnɑ pʋntʋ nɑɑŋ. Ɩlɛnɑ Tɑcɑɑ sɔɣɔntʋ kpɑ yǝlɑɑ, nɑ pɑ tǝnɑ pɑ́ tɛɛ yoou kɛ nɔɣɔ kʋlʋmɑɣɑ, ɩsɩɩ yʋlʋ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("S111_8","010_11_8","1SA","11","8","8","Ḿpʋ́ɣʋ́ Sɑyuli kɑlɑ ɩ yoolɑɑ kɛ Peseke, nɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩ iyisi ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (300000) nɑ Yutɑ nyǝ́mɑ kɛ iyisi hiu nɑ nɑɑnʋwɑ (30000). ");
INSERT INTO dop_vpl VALUES ("S111_9","010_11_9","1SA","11","9","9","Ḿpʋ́ɣʋ́ ɩ tilɑɑ sɩ pɑ́ heeli Yɑpɛɛsɩ nyǝ́mɑ sɩ, cele ilim sikuɣu kɛ pɑɑ nɑ nyʋɣʋ. Tillɑɑ heelɑ tɔm ntǝɣɩ Yɑpɛɛsɩ nyǝ́mɑ, ɩlɛnɑ pɛlɛ pɑ lɑŋɑ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("S111_10","010_11_10","1SA","11","10","10","Nɑ pɑ́ heeli Amoni nyǝ́mɑ sɩ: Cele tɩɩ pɛtɩ-mɛɣɛ tɑ́ tɩ nɑ ɩ́ lɑnɑ-tʋɣʋ ɩsǝnɑ pǝ hɑ-mɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S111_11","010_11_11","1SA","11","11","11","Ḿpʋ́ɣʋ́ Sɑyuli fɑɣɑ ɩ yoolɑɑ kɛ tɔm toosoɣo tefemle, nɑ pɑ́ wɑtɩ Amoni nyǝ́mɑ tǝsikile kɛ wɑɑtʋ wei hɑɣɑ yʋɣɩ kɑ tʋ tɔ, nɑ pɑ́ kʋ-wɛɣɛ ḿpʋ́ɣʋ́ hɑlǝnɑ ilim sikuɣu. Pǝ sɔɔ mpɑ mpɑ ɩlɛnɑ pɛlɛ pɑ́ yɑ yem yem. ");
INSERT INTO dop_vpl VALUES ("S111_12","010_11_12","1SA","11","12","12","Pɑ tɔɣɔ ɑkɑɩtʋ kɛ mpʋ, ɩlɛnɑ yǝlɑɑ pɔɔsɩ Sɑmiyɛɛlɩ sɩ: Awe tɔŋɑɣɑ sɩ Sɑyuli kɑɑ tɔɣɔ tɑ́ tɔɔ kɛ́ kɑwulɑɣɑ ye? Ɩ́ lǝsɩ yǝlɑɑ mpɛ nɑ tǝ́ kʋ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S111_13","010_11_13","1SA","11","13","13","Ntɛnɑ Sɑyuli sɩ pɑ́ tɑɑ kʋ nɔɣɔlʋɣʋ sɑŋɑ. Mpi tɔ, kʋyɑkʋ kʋnɛɣɛ Tɑcɑɑ wɑɑsɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ yɑɑ-wɛ sɩ: Ɩ́ kɔɔ nɑ tǝ́ polo Kilikɑɑ nɑ tǝ́ sɩɩ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Ɩlɛnɑ pɑ tǝnɑ pɑ́ polo tǝnɑ, nɑ pɑ́ kpɑ Sɑyuli kɛ wulɑʋ kɛ Ɩsɔ ɑtɑkɑɑ kiŋ, nɑ pɑ́ lɑ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ nɑ ciikuɣu kɔtɑɣɑ. Ɩlɛnɑ Sɑyuli nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ pɑ lɑ ɑcimɑ sɔsɔɔnɑ. ");
INSERT INTO dop_vpl VALUES ("S112_1","010_12_1","1SA","12","1","1","Mpʋɣʋlɛ Sɑmiyɛɛlɩ tɔmɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ: Mɑ nɩɩwɑ mǝ kʋsǝlǝmʋtʋ nɑ mɑ́ kpɑ-mɛɣɛ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("S112_2","010_12_2","1SA","12","2","2","Pǝnɛntɛ ɩɩ nɑɑkɩ mǝ wulɑʋ wei ɩ kɑ tɛɛkɩ-mɛɣɛ nɔɣɔ tɔɣɔlɛ. Mɑ ɩlɛ mɑ kpɑtǝlɑɑ, mɑ hʋlʋsɑ nyɔɔsɩ, mɑ pǝyɑlɑɑ lɑpɑ sɔsɑɑ. Hɑtoo mɑ ɩwɑɑsǝtʋ kɛ mɑ lɑpɑ mǝ nyʋɣʋ tʋ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S112_3","010_12_3","1SA","12","3","3","Mɑ́ sǝŋnɑ ntɛɣɛ cǝnɛ, ye mɑ wɑkǝlǝnɑ nɔɣɔlʋ, yɑɑ mɑ lɛɛkɑ pʋntʋ nɑʋ, yɑɑ ɩ kpɑŋɑɣɑ. Ɩ yɔɣɔtɩ-tǝɣɩ Tɑcɑɑ nɑ wulɑʋ wei ɩ lǝsɑɑ tɔ pɑ ɩsɛntɑɑ cǝnɛ. Mǝ tɑɑ ɑweɣe mɑ muɣulɑɑ, yɑɑ mǝ tɑɑ ɑweɣe mɑ ŋmɑkǝlɑɑ? Awe cɛlǝnɑ-m kʋhɑʋ nɑ mɑ́ tɑkɩ ɩ wɑɑlɩ? Pʋntʋ ɩ́ yɔɣɔtɩ nɑ mɑ́ fɛlɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S112_4","010_12_4","1SA","12","4","4","Ɩlɛnɑ yǝlɑɑ cɔ Sɑmiyɛɛlɩ sɩ: Aɑɩ, n tɑ muɣuli-tʋ, n tɑ ŋmɑkǝlɩ-tʋ. Pǝ́cɔ́ n tɑ mʋ nɔɣɔlʋ kʋhɑʋ nɑ ń tɑkɩ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S112_5","010_12_5","1SA","12","5","5","Ɩlɛnɑ Sɑmiyɛɛlɩ tɑsɑ sɩ: Tɑcɑɑ nɑ wei ɩ lǝsɑɑ sɩ ɩ kpɑɑ-mɛɣɛ wulɑʋ tɔɣɔlɛ tɑ́ ɑseetɑ nyǝ́mɑ kɛ sɑŋɑ, sɩ mɑ tɑ tɔɣɔ mǝ tɑɑ nɔɣɔlʋ pʋlʋ cǝcǝkɑ. Ɩlɛnɑ pɑ́ cɔ-ɩ sɩ: Ɛɛ, mpɛɣɛlɛ tɑ ɑseetɑ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S112_6","010_12_6","1SA","12","6","6","Ɩlɛnɑ Sɑmiyɛɛlɩ sɩ: Tɑcɑɑ wei ɩ yelɑɑ nɑ Moisi nɑ Alɔŋ pɑ́ lǝsɩ mǝ cɑɑnɑɑ kɛ Icipiti tɑɑ tɔɣɔlɛ ɑseetɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("S112_7","010_12_7","1SA","12","7","7","Tɔʋ, pǝnɛntɛ ɩ́ kɔɔ nɑ mɑ́ kɛɛsɩ-mɛɣɛ kʋpɑntʋnɑɑ mpɑ ɩ lɑpɑ mǝ cɑɑnɑɑ tɔ, nɑ mɑ́ tɑɣɑnɩ mǝ tɔm. ");
INSERT INTO dop_vpl VALUES ("S112_8","010_12_8","1SA","12","8","8","Yɑkɔpʋ nɑ ɩ nyǝ́mɑ pɑ polɑ Icipiti tɔ, pǝ wɑɑlɩ kɛ́ tǝnɑ nyǝ́mɑ ŋmɑkǝlɑ-wɛ. Ɩlɛnɑ mǝ cɑɑnɑɑ mpɛ pɑ́ wiinɑ Tɑcɑɑ sɩ ɩ́ wɑɑsɩ-wɛ. Ntɛnɑ ɩ́lɛ́ ɩ lǝsɩ Moisi nɑ Alɔŋ nɑ ɩ́ tili-wɛ nɑ pɑ́ yɑ-wɛɣɛ Icipiti tɑɑ, nɑ pɑ́ kɔnɑ-wɛɣɛ tɛtʋ tǝnɛ tǝ tɑɑ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("S112_9","010_12_9","1SA","12","9","9","Pǝlɛ pǝ wɑɑlɩ kɛ́ mǝ cɑɑnɑɑ mpɛ pɑ sɔɔ Tɑcɑɑ tɔɔ, nɑ ɩ́lɛ́ ɩ tʋ-wɛɣɛ Filiisi nyǝ́mɑ nɑ Hɑsɔɔ yoolɑɑ wulɑʋ Siselɑ, nɑ Mowɑpʋ wulɑʋ pɑ niŋ tɑɑ nɑ pɑ́ yoonɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S112_10","010_12_10","1SA","12","10","10","Ḿpʋ́ɣʋ́ pɑ wiinɑ Tɑcɑɑ tɔtɔ sɩ: Tǝ wɑkǝlǝnɑ-ŋ. Mpi tɔ, tǝ́ lɔ-ŋ nɑ tǝ́ lɑɑkɩ Pɑɑlǝnɑɑ nɑ Asǝtɑtǝnɑɑ. Yɑ-tʋɣʋ tɑ kolontunɑɑ niŋ tɑɑ, nɑ tǝ́ lɑ-ŋ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("S112_11","010_12_11","1SA","12","11","11","Ɩlɛnɑ Tɑcɑɑ lǝsɩ Ketiyɔŋ nɑ Petɑŋ nɑ Yɛfɛtɛ, nɑ mɑɣɑ wɑɑlɩ wɑɑlɩ, nɑ tǝ́ yɑ-mɛɣɛ mǝ kolontunɑɑ niŋ tɑɑ nɑ ɩ́ cɑɣɑ tǝpɑmm nɑ hɛɛsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S112_12","010_12_12","1SA","12","12","12","Wɑɑtʋ wei Amoni wulɑʋ Nɑhɑsɩ yookɑɣɑnɑ-mɛ tɔɣɔ ɩ́ tɔmɑ-m sɩ mɑ́ kpɑ-mɛɣɛ wulɑʋ. Pǝyele Tɑcɑɑ mǝ Ɩsɔ kɛlɛ mǝ wulɑʋ kɛ wɑɑtʋ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("S112_13","010_12_13","1SA","12","13","13","Ɩɩ nɑɑkɩ mǝ wulɑʋ wei ɩ́ pɛɛkɑɑ nɑ ɩ́ lǝsɩ tɔɣɔlɛ Tɑcɑɑ kpɑ-mɛ. ");
INSERT INTO dop_vpl VALUES ("S112_14","010_12_14","1SA","12","14","14","Ye ɩ́ nyɑŋnɑ Tɑcɑɑ nɑ ɩ́ lɑkɩ-ɩ tǝmlɛ nɑ ɩ́ nɩɩkǝnɑ-ɩ, nɑ ɩ́ tɑ kpɛɛsǝnɑ nti ɩ tʋ-mɛ tɔ, nɑ mǝ nɑ mǝ wulɑʋ ɩ́ tǝŋǝɣɩ-ɩ mǝ lɑŋɑ kɑ́ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("S112_15","010_12_15","1SA","12","15","15","Amɑ ye ɩɩ nɩɩkǝnɑ-ɩ nɑ ɩ́ kpɛɛsɑ ɩ tɔm ɩ kɑ́ tʋ-mɛɣɛ niŋ ɩsɩɩ ɩ kɑ́ tʋɣʋ mǝ cɑɑnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S112_16","010_12_16","1SA","12","16","16","Tɔʋ, pǝnɛntɛ ɩ́ sǝŋ mpʋ, nɑ ɩ́ nɑ́ piti tǝmlɛ nte Tɑcɑɑ kɑ́ lɑ mǝ hɛkʋ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S112_17","010_12_17","1SA","12","17","17","Pǝ tɑɣɑ lʋŋlɛ tɑɑ kɛ́ tǝ wɛ ɩsǝntɔ? Mpʋ tɔ, mɑɑ sǝlǝmɩ Tɑcɑɑ nɑ ɩ́ yele nɑ tɛʋ holi nɑ kʋ nɩɩ. Wɑɑtʋ ɩnǝɣɩ ɩ́ kɑ́ nyɩ sɩ timpi ɩ sǝlǝmɑ wulɑʋ tɔ, mǝ tɔm sǝpǝnɑ Tɑcɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S112_18","010_12_18","1SA","12","18","18","Tǝnɑɣɑlɛ Sɑmiyɛɛlɩ sǝlǝmɑ Tɑcɑɑ nɑ tɛʋ holi nɑ kʋ nɩɩ kʋyɑkʋ ŋkʋ kʋ mɑɣɑmɑɣɑ. Ɩlɛnɑ Tɑcɑɑ nɑ Sɑmiyɛɛlɩ pɑ tɔm lɑ sɑmɑɑ kɛ sɔɣɔntʋ. ");
INSERT INTO dop_vpl VALUES ("S112_19","010_12_19","1SA","12","19","19","Mpʋɣʋlɛ sɑmɑɑ tɔmɑ-ɩ sɩ: Sǝlǝmɩ nyɑ́ Ɩsɔ Tɑcɑɑ kɛ tɑ tɔɔ nɑ pǝ́ tɑɑ kɔɔ nɑ tǝ́ sɩ. Mpi tɔ, tǝ nɑwɑ sɩ tǝ sɔɔsɑ tɑsǝkǝlɛ kɛ tɑ ɩsɑɣɑtʋ tɔɔ kɛ́ timpi tǝ sǝlǝmɑ wulɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S112_20","010_12_20","1SA","12","20","20","Ntɛnɑ Sɑmiyɛɛlɩ sɩ: Ɩ́ tɑɑ nyɑ́, pɑɑ nɑ ɩ́ lɑpɑ ɩsɑɣɑtʋ ntɩ tɔ, pǝ tɑɑ cɩ-mɛ sɩ ɩ́ kisiɣi Tɑcɑɑ kɛ́. Ɩ́ lɑpɩ-ɩ tǝmlɛ nɑ mǝ lotu tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S112_21","010_12_21","1SA","12","21","21","Ɩ́ tɑɑ tǝŋ tɩɩŋ. Mpi tɔ, ɩ́lɛ́ ɩ kɑɑ pǝsɩ nɑ ɩ́ wɑɑsɩ-mɛ yɑɑ ɩ́ tɩɩ sǝnɑ-mɛ. Pǝ tɑɣɑ pʋlʋ, ɩ fɛɩnɑ ɩ tɩ. ");
INSERT INTO dop_vpl VALUES ("S112_22","010_12_22","1SA","12","22","22","Tɑcɑɑ nɑ́ kɑɑ lɔ-mɛ. Mpi tɔ, ɩ hǝtɛ kɛ sɔsɔɔlɛ kɛ́, ɩ tʋ ɩ tɑɑ kɛ́ sɩ ɩ pǝsǝɣɩ-mɛɣɛ ɩ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S112_23","010_12_23","1SA","12","23","23","Ye mɑ yelɑ mǝ tɔɔ kɛ sǝlǝmʋɣʋ mpusi ɩ́ tǝŋɩ-m. Mɑɑ sɛɣɛsɩ-mɛɣɛ mpi pǝ wɛ teu nɑ pǝ́ siɣisɑɑ tɔ nɑ ɩ́ lɑ. ");
INSERT INTO dop_vpl VALUES ("S112_24","010_12_24","1SA","12","24","24","Ɩ́ nyɑŋnɑ Tɑcɑɑ, nɑ ɩ́ lɑpɩ-ɩ tǝmlɛ kɛ teu nɑ lotu kʋlʋmtʋ. Mǝ mɑɣɑmɑɣɑ ɩ́ nɑwɑ tomɑ wenɑ ɩ hʋlǝɣɩ mǝ hɛkʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S112_25","010_12_25","1SA","12","25","25","Amɑ ye ɩ́ tɔkɑ mǝ ɩsɑɣɑtʋ, mǝ nɑ mǝ wulɑʋ ɩ́ kɑ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Wɑɑtʋ wei Sɑyuli tɔɣɔ kɑwulɑɣɑ tɔ ɩ pɩɩsɩ kɑ wɛ... Pǝyele ɩ kɑ tɛmɑ kɑwulɑɣɑ tɔɣɔʋ kɛ pɩɩsɩ nɑɑlɛɣɛ Ɩsɛɣɛlɩ tɑɑ. tɔm. Amɑ Piipilinɑɑ lɛlɑɑ nɑ́ tʋwɑ sɩ Sɑyuli pɩɩsɩ kɑ wɛ nɩɩlɛ. ");
INSERT INTO dop_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","Ḿpʋ́ɣʋ́ Sɑyuli lǝsɑ yoolɑɑ iyisi toosoɣo (3000) Ɩsɛɣɛlɩ tɑɑ. Ɩlɛnɑ ɩ́ sɩɩ ɩ kiŋ kɛ pɑ tɑɑ yǝlɑɑ iyisi nɑɑlɛɣɛ (2000) Mikimɑsɩ nɑ Petɛɛlɩ pʋɣʋ tɑɑ. Ɩlɛnɑ ɩ́ cɛlɑ yǝlɑɑ iyɑɣɑ (1000) kɛ ɩ pǝyɑlʋ Sonɑtɑŋ kɛ Kipeyɑ kɛ Pɛncɑmɛɛ tɑɑ. Pǝ kɑɑsɑ mpɑ ɩlɛnɑ ɩ́ yɑsɩ pɛlɛ nɑ pɑɑ wei ɩ́ mǝlɩ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Ḿpʋ́ɣʋ́ Sonɑtɑŋ yɔkɑ Filiisi yoolɑɑ tǝsikile kɛ Kipeyɑ, ɩlɛnɑ pɛlɛ pɑ́ nɩɩ. Ntɛnɑ Sɑyuli tili nɑ pɑ́ hʋlɩ tutuuŋ kɛ Ɩsɛɣɛlɩ tǝnɑ tɑɑ sɩ Hepǝlɑ nyǝ́mɑ ɩ́ lɩɩ yoou. ");
INSERT INTO dop_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɩɩwɑ sɩ Sɑyuli yɔkɑ Filiisi yoolɑɑ tǝsikile. Ɩlɛnɑ Filiisi nyǝ́mɑ tɑɑ kpɑɑkǝnɑ-wɛ. Ɩlɛnɑ yǝlɑɑ lɩɩ yoou nɑ pɑ́ koti Sɑyuli kiŋ kɛ Kilikɑɑ. ");
INSERT INTO dop_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ kotɑɑ sɩ pɑ yookinɑ Ɩsɛɣɛlɩ nyǝ́mɑ, nɑ pɑ yoou kɛɛkɛnɑɑ kɛ iyisi hiu nɑ nɑɑnʋwɑ (30000) nɑ pɑ kpɑɣɑnǝŋ cɑɣɑlɑɑ kɛ iyisi nɑɑtoso (6000). Pɑ yoolɑɑ kɑ wɛ pɑɣɑlɛ kɛ́ ɩsɩɩ lʋm nɔɣɔ kɑnyǝŋɑ, pɑ fɛɩ kɑlʋɣʋ. Ḿpʋ́ɣʋ́ pɑ polɑɑ nɑ pɑ́ pɩɩlɩ Mikimɑsɩ kɛ Pɛtɩ-Afɛŋ ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ lɑŋɑ wɑkǝlɑɑ tǝtɔɣɔtɔɣɔ. Mpi tɔ, pɑ kolontunɑɑ tɛɛ-wɛɣɛ pɑɣɑlɛ tǝyɑmyɑm. Ɩlɛnɑ pɑ tɑɑ lɛlɑɑ ŋmɛlɩ kʋkpɑmǝŋ pɔɔŋ tɑɑ, nɑ lɛlɑɑ kɛ lɔkɔnɑɑ tɑɑ, nɑ lɛlɑɑ kɛ pulɑsɩ tɑɑ, nɑ lɛlɑɑ kɛ hɔtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Ɩlɛnɑ lɛlɑɑ nɑ́ɑ́ tɛsɩ Yɑɑtɑnɩ nɑ pɑ́ polo Kɑtɩ nɑ Kɑlɑɑtɩ. Wɑɑtʋ ɩnɩ tɔ nɑ Sɑyuli nɑ́ɑ́ wɛ Kilikɑɑ, nɑ yǝlɑɑ mpɑ pɑɑ wɛ ɩ kiŋ tɔ pɑ seliɣi. ");
INSERT INTO dop_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Ḿpʋ́ɣʋ́ Sɑyuli tɑŋɑ wɛɛ kɛ nɑɑtosompɔɣɔlɑɣɑ, ɩsɩɩ Sɑmiyɛɛlɩ kɑ heeluɣu-ɩ tɔ. Pɑɑ nɑ mpʋ Sɑmiyɛɛlɩ tɑ kɔɔ lɔŋ. Ɩlɛnɑ yǝlɑɑ sʋʋ yɑʋ. ");
INSERT INTO dop_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Tǝnɑɣɑlɛ Sɑyuli tɔmɑ sɩ: Ɩ́ kɔnɑ-m kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ nɑ ciikuɣu nyǝŋkɑ wontu. Ɩlɛnɑ ɩ́ lɑ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Ɩ kɔmɑ ɩsɩɩ ɩ tɛɛsǝɣɩ, ɩlɛ Sɑmiyɛɛlɩ tɑpɑɣɑlɛ. Nɑ Sɑyuli polo ɩ sǝŋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Mpʋɣʋlɛ Sɑmiyɛɛlɩ pɔɔsɑ-ɩ sɩ: Pepeɣe n lɑpɑ ye? Ɩlɛnɑ Sɑyuli cɔ sɩ: Mɑ nɑwɑ sɩ sɑmɑɑ tɔŋɑ yɑʋ. Pǝ́cɔ́ n tɑ kɔɔ ɩsɩɩ n kɑ sɩɩwɑ tɔ. Pǝyele Filiisi nyǝ́mɑ nɑ́ sikɑ Mikimɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Kɛlɛnɑ mɑ́ mɑɣɑsɩ mɑ tɑɑ sɩ, Filiisi nyǝ́mɑ kɑ tii mɑ tɔɔ kɛ Kilikɑɑ cǝnɛ, nɑ mɑ́ tɑ sǝlǝmǝtɑ Tɑcɑɑ. Pǝ tɔɔ kɛ́ pǝ cɑɑlɑ-m sɩ mɑ́ lɑ kɔtɑɣɑ ŋkɑ kɔkɔ nyɑɣɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Tǝnɑɣɑ Sɑmiyɛɛlɩ tɔmɑ Sɑyuli sɩ: N lɑpɑ kʋmɛlɛntʋ kɛ́. N tɑ tɔkɩ nti Tɑcɑɑ nyɑ́ Ɩsɔ sɩɩ-ŋ tɔ. Tɔfɔ, Tɑcɑɑ kɑ nyǝmɑɣɑ sɩ nyɑ́ kɑwulɑɣɑ kɑ́ wɛɛ tɑm tɔɔ kɛ́ Ɩsɛɣɛlɩ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Amɑ pǝnɛntɛ kɑ kɑɑ tɑsɑ leeluɣu. Tɑcɑɑ lǝsɑ ɩ luɣu tɛɛ nyǝŋ nɑ ɩ́ kpɑ-ɩ wulɑʋ kɛ ɩ yǝlɑɑ tɔɔ. Mpi tɔ, n tɑ tɔkɩ mpi ɩ kɑ tʋ-ŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Pǝ wɑɑlɩ kɛ Sɑmiyɛɛlɩ kʋlɑ Kilikɑɑ, nɑ ɩ́ polo Kipeyɑ kɛ Pɛncɑmɛɛ tɛtʋ tɑɑ. Ḿpʋ́ɣʋ́ Sɑyuli kɑlɑ yǝlɑɑ mpɑ pɑɑ wɛ ɩ kiŋ tɔ, nɑ pɑ́ lɩɩ yǝlɑɑ nɑsǝtoso (600). ");
INSERT INTO dop_vpl VALUES ("S113_16","010_13_16","1SA","13","16","16","Ɩ nɑ ɩ pǝyɑlʋ Sonɑtɑŋ nɑ pɑ cɔlɔ yǝlɑɑ pɑɑ sikɑ Kepɑ kɛ Pɛncɑmɛɛ tɛtʋ tɑɑ kɛ́. Ɩlɛnɑ Filiisi nyǝ́mɑ nɑ́ɑ́ siki Mikimɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S113_17","010_13_17","1SA","13","17","17","Ḿpʋ́ɣʋ́ Filiisi yoolɑɑ mpɑ pɑ wɑkǝlǝɣɩ lɛlɑɑ wontu tɔ, pɑ lɩɩ tintikɑ tooso. Ḿpʋ́ɣʋ́ kɑncɑɑlɑɣɑ nyǝntɛ mǝlǝnɑ Ofǝlɑ tɔɔ kɛ́ Suwɑɑlɩ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S113_18","010_13_18","1SA","13","18","18","Ɩlɛnɑ nɑɑlɛ nyǝntɛ nɑ́ɑ́ mǝlǝnɑ Pɛtɩ-Holoŋ tɔɔ, nɑ tooso nyǝntɛ nɑ́ɑ́ kpɑɣɑ toŋɑ mpɑɑʋ ŋku kʋ tiiki Sʋnsʋmǝŋ tɛtɛkǝlɛ tɑɑ kɛ wʋlɑɣɑ tɛtʋ tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("S113_19","010_13_19","1SA","13","19","19","Wɑɑtʋ ɩnɩ tɔ, koolu fɛɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɛ. Mpi tɔ, Filiisi nyǝ́mɑ tɑɑ tisiɣi sɩ Hepǝlɑ nyǝ́mɑ ɩ́ lu lɑɣɑlɛɛ nɑ ŋmɑntɑɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S113_20","010_13_20","1SA","13","20","20","Filiisi nyǝ́mɑ tɛɣɛ pɑ pukɑɣɑ nɑ pɑ́ kpɑlǝɣɩ ɑkuŋ, nɑ pɑ cikɑnɑɑ, nɑ pɑ lɑwɑ, nɑ pɑ tɛtʋ kʋcɑsǝŋ ");
INSERT INTO dop_vpl VALUES ("S113_21","010_13_21","1SA","13","21","21","kɛ wɑɑtʋ wei wontunɑɑ mpɛ pɑ lɔŋ sǝkɩ tɔ. Pɑ kpɑlɑɣɑ kɛ́ nɑ pɑ́ fɛlǝɣɩ liɣitee nyǝɣǝlʋɣʋ kʋlʋmʋɣʋ kɛ wontu sǝkpetu tɔɔ, nɑ nyǝɣǝlǝŋ nɑɑlɛɣɛ sɔsɔɔntʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S113_22","010_13_22","1SA","13","22","22","Kʋyɑkʋ ŋku yoou tiiwɑ tɔ, Sɑyuli nɑ ɩ pǝyɑlʋ Sonɑtɑŋ pɑ tike pɑɑ wɛnnɑ yoou wontu. Pǝ kɑɑsɑ yǝlɑɑ mpɑ pɑɑ wɛ pɑ kiŋ tɔ, pɛlɛ pɑ tɑɑ nɔɣɔlʋ fɛɩnɑ ŋmɑntɑɑɣɑ yɑɑ lɑɣɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S113_23","010_13_23","1SA","13","23","23","Ḿpʋ́ɣʋ́ Filiisi yoolɑɑ polɑɑ sɩ pɑ tɑŋǝɣɩ Mikimɑsɩ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("S114_1","010_14_1","1SA","14","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Sonɑtɑŋ tɔmɑ ɩfepu wei ɩ tɔkǝɣɩ ɩ yoou wontu tɔ sɩ: Kɔɔ nɑ tǝ́ tɛsɩ Filiisi yoolɑɑ tǝsikile nte tǝ wɛnnɑ too cǝnɛ tɔɔ tɔ. Amɑ Sonɑtɑŋ tɑ yele nɑ ɩ cɑɑ nɩɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("S114_2","010_14_2","1SA","14","2","2","Nɑ Sɑyuli nɑ́ɑ́ cɑɣɑ Kipeyɑ toŋɑ tɔɔ kɛ́ tʋɣʋ nɑkʋlɩ kʋ tɛɛ kɛ́ Mikǝlɔŋ. Nɑ yoolɑɑ mpɑ pɑɑ wɛ ɩ kiŋ tɔ, pɑ tɑlɑ ɩsɩɩ yǝlɑɑ nɑsǝtoso (600) kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S114_3","010_14_3","1SA","14","3","3","Ahitupi pǝyɑlʋ Ahiyɑ kɑ kɛnɑ kɔtʋlʋ kɛ wɑɑtʋ ɩnɩ. Nɑ ɩ́ suu kɔtǝlɑɑ toko wei pɑ pɔɔsǝɣǝnɑ Tɑcɑɑ kɛ tɔm tɔ. Tɑcɑɑ kɔtʋlʋ Ilii wei ɩ kɑ wɛ Silo tɔ ɩ pǝyɑlʋ kɛlɛ Pɛnhɑsɩ, nɑ ɩ́lɛ́ ɩ lʋlǝnɑ Ɩkɑpɔtɩ. Ɩkɑpɔtɩ neu ntɛ́ Ahitupi. Ɩlɛ yǝlɑɑ tɑ nyɩ sɩ Sonɑtɑŋ polɑ tiili. ");
INSERT INTO dop_vpl VALUES ("S114_4","010_14_4","1SA","14","4","5","Mpɑɑʋ ŋku Sonɑtɑŋ tǝŋɑɣɑ sɩ ɩ́ puki Filiisi nyǝ́mɑ yoolɑɑ tǝsikile tɔ, kʋ wɛ kʋkpɑmǝŋ nɑɑlɛ hɛkʋ kɛ́. Lɛŋkʋ nɔɣɔ kɛɛsǝnɑ ilim ntɔɣɔŋ tɔɔ kɛ́ Mikimɑsɩ ɩsɛntɑɑ. Pɑ yɑɑkɩ-kʋ sɩ Posee. Lɛŋkʋ nɔɣɔ nɑ́ɑ́ kɛɛsǝnɑ ilim mpǝtǝŋ tɔɔ kɛ́ Kepɑ ɩsɛntɑɑ, nɑ pɑ́ yɑɑkɩ kʋlɛ sɩ Sene. ");
INSERT INTO dop_vpl VALUES ("S114_6","010_14_6","1SA","14","6","6","Ḿpʋ́ɣʋ́ Sonɑtɑŋ tɔmɑ ɩ yoou wontu tɔkʋlʋ sɩ: Kɔɔ nɑ tǝ́ tɛsɩ Filiisi nyǝ́mɑ mɑ tɑ nyɩ ɩsɔnɑɑ mpɛ pɑ tǝsikile. Ntɑnyɩ Tɑcɑɑ kɑ́ yoonɑ tɑ́ nɔɣɔ. Mpi tɔ, pǝ fɛɩ Tɑcɑɑ kɛ kɑtɛ sɩ ɩ́ yoonɑ sɑmɑɑ tuutuumɑ nɔɣɔ, yɑɑ yǝlɑɑ pǝcɔ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S114_7","010_14_7","1SA","14","7","7","Kɛlɛnɑ Sonɑtɑŋ yoou wontu tɔkʋlʋ tɔ sɩ: Lɑ ɩsǝnɑ pǝ mɑɣɑ-ŋ tɔ. Polo tǝ polo, mɑ wɛ nyɑ́ wɑɑlɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S114_8","010_14_8","1SA","14","8","8","Mpʋɣʋlɛ sɩ: Tɔʋ, tǝ pukuɣunɑ pɑ tɔɔ ɩsǝntɔ tɔ pɑɑ nɑ-tʋ. ");
INSERT INTO dop_vpl VALUES ("S114_9","010_14_9","1SA","14","9","9","Ɩlɛ ye pɑ tɔmɑ sɩ: Ɩ́ cɑɣɑ tǝnɑ nɑ tǝ́ kɔɔ. Ɩlɛ tǝ sǝŋ tɑ́ tǝsǝŋlɛ tǝkpi. ");
INSERT INTO dop_vpl VALUES ("S114_10","010_14_10","1SA","14","10","10","Amɑ ye pɑ tɔmɑ-tʋ sɩ: Ɩ́ tɔ nɑ ɩ́ kɔɔ. Ɩlɛ tɑ́ɑ́ kpɑ pɑ tɔɔ. Mpi tɩɩ nyǝnɑ sɩ Tɑcɑɑ tʋ-wɛɣɛ tɑ́ niŋ tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S114_11","010_14_11","1SA","14","11","11","Ɩlɛnɑ pɑ́ yele nɑ Filiisi nyǝ́mɑ nɑ-wɛ nɑ pɑ́ tɔ sɩ: Ɩ nyǝnɩ, Hepǝlɑ nyǝ́mɑ lɩɩnɑ ntɛɣɛ pʋ́ʋ́ɣʋ́ ŋku kʋ tɑɑ pɑɑ ŋmɛlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S114_12","010_14_12","1SA","14","12","12","Mpʋɣʋlɛ pɑ tɑsɑɑ sɩ: Ɩ́ kɔɔ cǝnɛ nɑ tǝ́ lɑ-mɛ nɑ ɩ́ tɔɣɔ nɑ ɩ́ hɑɣɑ. Ntɛnɑ Sonɑtɑŋ tɔ ɩ yoou wontu tɔkʋlʋ sɩ: Tǝŋ mɑ wɑɑlɩ. Mpi tɔ, Tɑcɑɑ tʋ-wɛɣɛ Ɩsɛɣɛlɩ nyǝ́mɑ niŋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S114_13","010_14_13","1SA","14","13","13","Ɩlɛnɑ pɑ́ tɔ pɑ niŋ tɔɔ nɑ pɑ́ kpɑ. Ḿpʋ́ɣʋ́ Sonɑtɑŋ nɑ kpiitɑ-wɛ nɑ ɩ́ pɛtǝɣɩ. Ɩlɛnɑ yoou wontu tɔkʋlʋ nɑ́ɑ́ tɛɛsǝɣɩ nɑ ɩ́ tǝŋǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("S114_14","010_14_14","1SA","14","14","14","Yǝlɑɑ hiu kɛ Sonɑtɑŋ pɑ kʋwɑ pɑ kɑncɑɑlɑɣɑ yoou ŋkʋ kʋ tɑɑ kɛ́ pǝlɛ nyʋɣʋ tɑɑ tǝnɑɣɑ kelikiyɑ kʋlʋmɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S114_15","010_14_15","1SA","14","15","15","Ḿpʋ́ɣʋ́ sɔɣɔntʋ kpɑ Filiisi nyǝ́mɑ mpɑ pɑɑ wɛ tɑwɑ tɑɑ tɔ. Ɩlɛnɑ tǝsikile tɑɑ yoolɑɑ nɑ mpɑ pɑ wɑkǝlǝɣɩ lɛlɑɑ wontu tɔ, pɑ́ sʋʋ seluɣu. Ḿpʋ́ɣʋ́ tɛtʋ selɑɑ, nɑ kɑniŋɑ kpɑ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S114_16","010_14_16","1SA","14","16","16","Ḿpʋ́ɣʋ́ Sɑyuli feŋlɑɑ mpɑ pɑɑ wɛ Kipeyɑ kɛ Pɛncɑmɛɛ tɛtʋ tɑɑ tɔ, pɑ nɑ ɑcufu tiiwɑ Filiisi nyǝ́mɑ tɑɑ, nɑ pɑ́ seeki yem yem. ");
INSERT INTO dop_vpl VALUES ("S114_17","010_14_17","1SA","14","17","17","Tǝnɑɣɑ Sɑyuli tɔmɑ ɩ yoolɑɑ mpɑ pɑɑ wɛ ɩ kiŋ tɔ sɩ: Ɩ́ kɑlɑ yǝlɑɑ nɑ tǝ́ nɑ́ sɩ ɑwe fɛɩnɑ tɑ́ tɑɑ. Pɑ kɑlɑ yǝlɑɑ ɩlɛnɑ pɑ́ mɑɣɑnɑ sɩ Sonɑtɑŋ nɑ ɩ yoou wontu tɔkʋlʋ pɑ fɛɩnɑ. ");
INSERT INTO dop_vpl VALUES ("S114_18","010_14_18","1SA","14","18","18","Ntɛnɑ Sɑyuli tɔ kɔtʋlʋ Ahiyɑ sɩ: Heeli nɑ pɑ́ kɔnɑ Ɩsɔ ɑtɑkɑɑ. (Mpi tɔ, ɩ́lɛ́ ɩ kɑ wɛ kʋyɑkʋ ŋkʋɣʋ Ɩsɛɣɛlɩ nyǝ́mɑ kiŋ kɛ́). ");
INSERT INTO dop_vpl VALUES ("S114_19","010_14_19","1SA","14","19","19","Sɑyuli tɔŋnɑ yɔɣɔtʋɣʋ kɛ mpʋ tɔ nɑ ɑcufu kɔkɔtɛ tɔŋnɑ sɔɔsʋɣʋ kɛ́. Ɩlɛnɑ ɩ́ tɔ kɔtʋlʋ sɩ: Sǝŋ nɑ pǝ́cɔ́. ");
INSERT INTO dop_vpl VALUES ("S114_20","010_14_20","1SA","14","20","20","Ḿpʋ́ɣʋ́ Sɑyuli nɑ yoolɑɑ pɑ kpeɣelɑɑ nɑ pɑ́ polo tǝyoole. Ɩlɛnɑ pɑ́ mɑɣɑnɑ ɑcufu tiiwɑ Filiisi nyǝ́mɑ tɑɑ, nɑ pɑ́ loŋ tǝmɑɣɑ lɑɣɑlɛɛ. ");
INSERT INTO dop_vpl VALUES ("S114_21","010_14_21","1SA","14","21","21","Tǝnɑɣɑ Hepǝlɑ nyǝ́mɑ mpɑ pɑɑ wɛ Filiisi yoolɑɑ tɑɑ nɑ pɑ sǝŋnɑ-wɛ tɔ, pɑ sewɑ nɑ pɑ́ mǝlɩ Sɑyuli nɑ Sonɑtɑŋ pɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("S114_22","010_14_22","1SA","14","22","22","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ mpɑ pɑ ŋmɛlɑ Ɩfǝlɑyim pʋɣʋ tɑɑ tɔ, pɛlɛ pɑ nɩɩwɑ Filiisi nyǝ́mɑ sewɑ tɔm. Ɩlɛnɑ pɑ tʋ pɑ wɑɑlɩ kɛ́ tǝyoole tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S114_23","010_14_23","1SA","14","23","23","Ɩsǝnɑ Tɑcɑɑ yelɑɑ nɑ Ɩsɛɣɛlɩ nyǝmɑ lɑ ɑkɑnɑɑ kɛ kʋyɑkʋ ŋkʋ tɔɣɔlɛ. Ayuli pɑ yoowɑ ḿpʋ́ɣʋ́ hɑlǝnɑ Pɛtɩ-Afɛŋ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S114_24","010_14_24","1SA","14","24","24","Ḿpʋ́ɣʋ́ nyɔɣɔsɩ pɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kʋyɑkʋ ŋkʋ. Mpi tɔ, Sɑyuli kɑ yɔɣɔtɑɑ kɛ́ nɑ ɩ́ tuu sɩ: Ye wei ɩ tɔɣɔ pʋlʋ kɛ sɑŋɑ, nɑ mɑ tɑ lɛɛtǝtɑ mɑ kolontunɑɑ, mpusi kɑ́ tǝŋ pʋntʋ. Pǝ tɔɔ kɛ́ pɑ tɑɑ nɔɣɔlʋ tɑ tǝŋ pʋlʋɣʋ ilim nɑ pǝ tɛm. ");
INSERT INTO dop_vpl VALUES ("S114_25","010_14_25","1SA","14","25","25","Ḿpʋ́ɣʋ́ yǝlɑɑ tǝnɑ tɑlɑ hɔtʋɣʋ ŋku kʋ tɑɑ tɩɩŋ nim wɛ ɑtɛɣɛ yem tɔ. ");
INSERT INTO dop_vpl VALUES ("S114_26","010_14_26","1SA","14","26","26","Tɩɩŋ kɑ tʋwɑ sɛtɑsɩ kɛ hɔtʋɣʋ ŋkʋ kʋ tɑɑ kɛ́ nɑ nim kpeŋ. Amɑ nɔɣɔlʋ tɑ kpɑɑsǝnɑ ɩ nɔɣɔ kiŋ. Mpi tɔ, yǝlɑɑ seekɑɣɑ nɔɣɔ ŋkɑ pɑ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S114_27","010_14_27","1SA","14","27","27","Amɑ Sonɑtɑŋ nɑ́ tɑ́ɑ́ nyɩ sɩ ɩ cɑɑ kisinɑ yǝlɑɑ, nɑ tuunɑʋ sɩ nɔɣɔlʋ ɩ́ tɑɑ tǝŋ pʋlʋ. Ḿpʋ́ɣʋ́ ɩ lii ɩ kpɑ́tʋ́ɣʋ́ kɛ tɩɩŋ nim tɑɑ nɑ ɩ́ niisi nɑ pǝ́ cɛ ɩsɛntɔɔ. ");
INSERT INTO dop_vpl VALUES ("S114_28","010_14_28","1SA","14","28","28","Mpʋɣʋlɛ sɑmɑɑ tɑɑ nɔɣɔlʋ tɔmɑ-ɩ sɩ: Hei, nyɑ́ cɑɑ yɔɣɔtɑɑ nɑ ɩ́ tuu sɩ: Ye pǝ cǝpɑ wei nɑ ɩ́ tɔɣɔ sɑŋɑ mpusi wɛ ɩ tɔɔ kɛ́. Pǝ́cɔ́ nyɔɣɔsɩ tɩɩ nɩɩ tɑ́ tǝnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S114_29","010_14_29","1SA","14","29","29","Sonɑtɑŋ nɩɩwɑ mpʋ, ɩlɛnɑ ɩ́ cɔ sɩ: Mɑ cɑɑ wɑkǝlɑ yǝlɑɑ kɛ́. Ɩ́ nyǝnɩ mɑ tǝŋʋɣʋ tɩɩŋ nɑ pǝ́ cɛ mɑ ɩsɛntɔɔ tǝkelekele tɔ. ");
INSERT INTO dop_vpl VALUES ("S114_30","010_14_30","1SA","14","30","30","Ye ɩsɩɩ sɑŋɑ yǝlɑɑ kɑ tɔɣɔ mpi pɑ lɛɛkɑ pɑ kolontunɑɑ niŋ tɑɑ tɔ, pɑ tɑ́ɑ́ kʋ Filiisi nyǝ́mɑ nɑ pǝ́ kǝlɩ ɩsǝntɔ? ");
INSERT INTO dop_vpl VALUES ("S114_31","010_14_31","1SA","14","31","31","Ḿpʋ́ɣʋ́ pɑ kʋ-wɛɣɛ kʋyɑkʋ ŋkʋɣʋ pǝ kpɑɣɑʋ Mikimɑsɩ nɑ pǝ́ polo Ayɑlɔŋ tɔ. Nɑ nyɔɣɔsɩ pɩɩ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("S114_32","010_14_32","1SA","14","32","32","Ɩlɛnɑ pɑ́ tii kolontunɑɑ tɔlɑ tɔɔ, nɑ pɑ́ lɛntɩ-yɛ nɑ pɑ́ sǝŋ ɑ cɑlǝm tɔɔ nɑ pɑ́ tɔɣɔ ɑ nɑntʋ. ");
INSERT INTO dop_vpl VALUES ("S114_33","010_14_33","1SA","14","33","33","Ḿpʋ́ɣʋ́ pɑ tɑɣɑsɑ-tǝɣɩ Sɑyuli sɩ: N nɑwɑ yǝlɑɑ wɑkǝlǝnɑ Tɑcɑɑ tɔ. Pɑ tɔɣɔ nɑntʋ nɑ tǝ cɑlǝm. Ntɛnɑ ɩ́ tɔ sɩ: Ɩ́ lɑpɑ kʋtɑkɛɛsǝtʋ kɛ́. Mpʋ tɔ, ɩ́ pilimi pɩɩʋ nɑ mɑ tɔɔ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("S114_34","010_14_34","1SA","14","34","34","Ḿpʋ́ɣʋ́ ɩ tɑsɑɑ sɩ pɑ́ cɔɔ pɑ heeli sɑmɑɑ sɩ: Pɑɑ wei ɩ́ kɔnɑ ɩ nɑʋ yɑɑ ɩ heu nɑ ɩ́ kʋ́ cǝnɛ nɑ ɩ́ tɔɣɔ. Tɔfɔ ɩ tɑɑ tɔɣɔ nɑntʋ nɑ tǝ cɑlǝm kɛ mpʋ nɑ ɩ́ wɑkǝlǝnɑ Tɑcɑɑ. Ḿpʋ́ɣʋ́ pɑɑ wei ɩ lɑpɑ ḿpʋ́ɣʋ́ ɑhoo ɑnɩ. ");
INSERT INTO dop_vpl VALUES ("S114_35","010_14_35","1SA","14","35","35","Ɩlɛnɑ Sɑyuli ŋmɑ Tɑcɑɑ kɛ ɩ kɑncɑɑlɑɣɑ kɔtɑɣɑ tǝlɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S114_36","010_14_36","1SA","14","36","36","Mpʋɣʋlɛ ɩ tɔmɑ yǝlɑɑ sɩ: Tǝ́ polo Filiisi nyǝ́mɑ wɑɑlɩ nɑ ɑhoo nɑ tǝ́ kʋ́ pɑ tǝnɑ nɑ tǝ́ kuu pɑ wontu hɑlǝnɑ pǝ nyɑɑlɩ. Tǝ́ tɑɑ sɔɔ pɑɑ kʋlʋm. Ɩlɛnɑ pɛlɛ pɑ cɔ sɩ: Lɑ ɩsǝnɑ pǝ mɑɣɑ-ŋ tɔ. Ntɛnɑ kɔtʋlʋ sɩ: Tǝ́ sǝlǝmɩ Ɩsɔ kɛ́ cǝnɛ nɑ pǝ́cɔ́. ");
INSERT INTO dop_vpl VALUES ("S114_37","010_14_37","1SA","14","37","37","Ḿpʋ́ɣʋ́ Sɑyuli pɔɔsɑ Ɩsɔ sɩ: Ye tǝ tǝŋɑ Filiisi nyǝ́mɑ wɑɑlɩ n kɑ́ tʋ-wɛɣɛ tɑ́ niŋ tɑɑ? Amɑ Tɑcɑɑ tɑ cɔ wɑɑtʋ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("S114_38","010_14_38","1SA","14","38","38","Ɩlɛnɑ Sɑyuli tɔ nyʋɣʋ nyǝ́mɑ sɩ: Mǝ tǝnɑ ɩ́ koti cǝnɛ nɑ tǝ́ pɛɛkɩ nɑ tǝ́ nɑ́ wei ɩ lɑpɑ ɩsɑɣɑtʋ tǝnɛɣɛ sɑŋɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S114_39","010_14_39","1SA","14","39","39","Mɑ tuunɑ Tɑcɑɑ wei ɩ wɑɑsǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔ sɩ, pɑɑ mɑ pǝyɑlʋ wɑkǝlǝnɑ. Ɩsɩɩ ɩ sǝpɑ. Amɑ nɔɣɔlʋ tɑ cɔ-ɩ sɩ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S114_40","010_14_40","1SA","14","40","40","Ɩlɛnɑ ɩ́ tɔ sɑmɑɑ sɩ: Mǝ tǝnɑ ɩ́ mǝlǝnɑ hɔɣɔlʋɣʋ kʋnɛ nɑ pǝ́ kɑɑsɩ mɑ́ nɑ Sonɑtɑŋ nɑ cǝnɛ tɔɔ. Ɩlɛnɑ pɛlɛ pɑ cɔ sɩ: Lɑ mpi pǝ mɑɣɑ-ŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S114_41","010_14_41","1SA","14","41","41","Ḿpʋ́ɣʋ́ Sɑyuli sǝlǝmɑ Tɑcɑɑ sɩ: Ɩsɛɣɛlɩ Ɩsɔ, hʋlɩ-tʋɣʋ tɑmpɑnɑ. Ɩlɛnɑ pɑ́ tɔ tɛtɛ nɑ pǝ́ kpɑ ɩ́ nɑ ɩ pǝyɑlʋ. ");
INSERT INTO dop_vpl VALUES ("S114_42","010_14_42","1SA","14","42","42","Mpʋɣʋlɛ sɩ: Ɩ́ tɔ mɑ́ nɑ mɑ pǝyɑlʋ tɑ́ tɔɔ kɛ́ tɛtɛ. Ɩlɛnɑ pǝ́ kpɑ ɩ pǝyɑlʋ. ");
INSERT INTO dop_vpl VALUES ("S114_43","010_14_43","1SA","14","43","43","Ntɛnɑ Sɑyuli sɩ: Heeli-m mpi n lɑpɑ tɔ. Ntɛnɑ Sonɑtɑŋ cɔ sɩ: Mɑ tǝŋɑ tɩɩŋ nim kɛ pǝcɔ. Mɑɣɑlɔ, mɑ sɔɔlʋ pɩɩwɑ sɩ mɑ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("S114_44","010_14_44","1SA","14","44","44","Kɛlɛnɑ Sɑyuli tɔ sɩ: Sonɑtɑŋ, ye n tɑ sɩ Tɑcɑɑ ɩ́ lɑnɑ-m ɩsǝnɑ ɩ sɔɔlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S114_45","010_14_45","1SA","14","45","45","Ntɛnɑ sɑmɑɑ tɔ Sɑyuli sɩ: Pepee, Sonɑtɑŋ kɑ́ sɩ yɑɑ? Aɑɩ yoo, mpusi ɩ polo pooluŋ. Pǝ fɛɩ sɩ ɩ nyʋɣʋ tɑɑ nyɔɔlɑɣɑ kʋlʋmɑɣɑ mɑɣɑmɑɣɑ ɩ́ le. Mpi tɔ, ɩ nɔɣɔ kɛ Tɑcɑɑ wɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ sɑŋɑ. Ɩsǝnɑ sɑmɑɑ yɑpɑ Sonɑtɑŋ nɑ ɩ́ tɑ́ sɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S114_46","010_14_46","1SA","14","46","46","Ɩlɛnɑ Sɑyuli yele Filiisi nyǝ́mɑ kɛ tɔɣɔnʋɣʋ, nɑ pɛlɛ pɑ́ mǝlɩ pɑ tɛ. ");
INSERT INTO dop_vpl VALUES ("S114_47","010_14_47","1SA","14","47","47","Sɑyuli tɔɣɔ kɑwulɑɣɑ kɛ Ɩsɛɣɛlɩ tɑɑ. Ɩlɛnɑ ɩ́ yoonɑ ɩ kolontunɑɑ tǝnɑɣɑ hɔɣɔlǝŋ tǝnɑ tɑɑ. Pɑɑ Mowɑpʋ nyǝ́mɑ, pɑɑ Amoni nyǝ́mɑ, pɑɑ Ɩtɔm nyǝ́mɑ, nɑ Sopɑ ɑwulɑɑ, nɑ Filiisi nyǝ́mɑ. Pɑɑ timpiɣi ɩ tɑlɑɑ te, ɩnɩ ɩ tɔkǝnɑ ɑkɑɩtʋ. ");
INSERT INTO dop_vpl VALUES ("S114_48","010_14_48","1SA","14","48","48","Ɩ hʋlɑ toŋ nɑ ɩ́ yoonɑ Amɑleke nyǝ́mɑ. Ɩ fitɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ mpɑ pɑ wɑkǝlɑɣɑ-wɛ tɔ pɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S114_49","010_14_49","1SA","14","49","49","Sɑyuli pǝyɑlɑɑ ntɛ́ Sonɑtɑŋ nɑ Ɩsefi nɑ Mɑlǝkisuwɑ. Ɩ pɛɛlɑɑ wɛ nɑɑlɛ, kɑncɑɑlɑɣɑ nyǝŋ ntɛ́ Melɑpɩ nɑ sǝkpelu sɩ Mikɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S114_50","010_14_50","1SA","14","50","50","Ɩ ɑlʋ ntɛ́ Ahimɑɑsɩ pɛɛlɔ Ahinowɑm. Ɩ yoolɑɑ sɔsɔ ntɛ́ ɩ cɑɑ sǝkpelu Nɛɛ pǝyɑlʋ Apǝnɛɛ. ");
INSERT INTO dop_vpl VALUES ("S114_51","010_14_51","1SA","14","51","51","Sɑyuli cɑɑ Kisi nɑ Nɛɛ cɑɑ Apǝnɛɛ pɛlɛ pɑ cɑɑ kɛlɛ Apǝyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("S114_52","010_14_52","1SA","14","52","52","Sɑyuli yoonɑ Filiisi nyǝ́mɑ kɛ ḿpʋ́ɣʋ́ nɑ toŋ nɑ toŋ, hɑlǝnɑ ɩ sǝm. Ye ɩ loosɑ yʋlʋ toŋ tʋ yɑɑ kpelikpekɑ tʋ, ɩ tʋɣʋ-ɩ ɩ yoolɑɑ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ tɔmɑ Sɑyuli sɩ: Mɑɣɑ Tɑcɑɑ tilɑɑ, nɑ mɑ́ kpɑ-ŋ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ nɑ mɑ́ pǝlɩ-ŋ nim. Mpʋ tɔ, ke ŋkpɑŋŋ nɑ ń nɩɩ. ");
INSERT INTO dop_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Tɑcɑɑ Tomɑ tǝnɑ tʋ yɔɣɔtɑɑ sɩ ɩnɩ ɩ kɑ́ lɛɛtɩ Amɑleke nyǝ́mɑ kɛ pɑ cɑɑnɑɑ ɩsɑɣɑtʋ. Mpi tɔ, pɑɑ tǝkɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ mpɑɑʋ kɛ wɑɑtʋ wei pɛlɛ pɑ lɩɩnɑ Icipiti tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Pǝ tɔɔ tɔ, polo nɑ ń kʋ́ Amɑleke nyǝ́mɑ nɑ ń kpiisi pɑ nyǝm tǝnɑ. Tɑɑ sɔɔ pɑ pʋlʋpʋ cǝcǝkɑ. Pɑɑ ɑpɑlɑɑ, pɑɑ ɑlɑɑ, pɑɑ piyɑ, nɑ ɑhʋlʋmnɑɑ nɑ tɔlɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Mpʋɣʋlɛ Sɑyuli kotɑ ɩ yǝlɑɑ nɑ ɩ́ kɑlɑ-wɛɣɛ Telɑyim. Ɩlɛnɑ Ɩsɛɣɛlɩ yoolɑɑ nɔɔhɛɛ tɔntɑɑ lɩɩ yǝlɑɑ iyisi ŋmʋnʋɣʋ (200000) nɑ Yutɑ nyǝ́mɑ kɛ iyisi nɑɑnʋwɑ (10000). ");
INSERT INTO dop_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Ɩlɛnɑ pɑ́ polo Amɑleke nyǝ́mɑ ɩcɑtɛ nɑ pɑ́ pɑpɩ-wɛɣɛ tɛtɛkǝlɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Ḿpʋ́ɣʋ́ pɑ tilɑɑ nɑ pɑ́ heeli Keni nyǝ́mɑ sɩ pɑ́ lɩɩ Amɑleke nyǝ́mɑ tɛ. Pǝ́ tɑɑ kɔɔ nɑ pɑ́ kʋ nɑ pɑ́ kpɛŋnɑ-wɛ. Mpi tɔ, pɑ cɑɑnɑɑ nyʋɣʋ kɑ tenɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ wɑɑtʋ wei pɛlɛ pɑ lɩɩnɑ Icipiti tɔɣɔ. Ɩlɛnɑ Keni nyǝ́mɑ lɩɩ. ");
INSERT INTO dop_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Ḿpʋ́ɣʋ́ Sɑyuli yoonɑ Amɑleke nyǝ́mɑ kɛ pǝ kpɑɣɑʋ Hɑfilɑ tɔ, nɑ pǝ́ polo Suuu kɛ Icipiti ilim tǝlɩɩlɛ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Ɩlɛnɑ ɩ́ kpɑ pɑ wulɑʋ Akɑkɩ nɑ ɩ ɩsɛ nɑ ɩ́ kʋ yǝlɑɑ tǝnɑ tǝcɑɣɑcɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Ḿpʋ́ɣʋ́ Sɑyuli nɑ ɩ yoolɑɑ pɑ yelɑ wulɑʋ nɑ ɩ ɩsɛ, nɑ tɔlɑ kʋpɑmpɑnɑ, nɑ wontu kʋpɑntʋnɑɑ. Amɑ mpi pǝ tɑɑ fɛɩ teu nɑ tɔlɑ ɑcɑmisi tike kɛ pɑ kʋwɑ. ");
INSERT INTO dop_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Sɑmiyɛɛlɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","Mɑ lɑŋlɛ wɑkǝlǝnɑ Sɑyuli kɑwulɑɣɑ kpɑʋ kɛ́. Mpi tɔ, ɩ lɔ-m nɑ ɩ́ kisi mɑ tɔm kɛ tɔkʋɣʋ. Kɛlɛnɑ Sɑmiyɛɛlɩ lɑŋlɛ wɑkǝlɩ tǝtɔɣɔtɔɣɔ, nɑ ɩ́ wiinɑ Tɑcɑɑ kɛ ɑhoo tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Tɛʋ femɑ tɑnɑŋ, ɩlɛnɑ Sɑmiyɛɛlɩ kʋlɩ sɩ ɩ puki Sɑyuli kɛ sǝŋʋɣʋ. Ntɛnɑ pɑ́ heelɩ-ɩ sɩ: Sɑyuli polɑ Kɑmɛɛlɩ nɑ ɩ́ ŋmɑ ɑkele nɔɣɔlʋ sɩ pǝ́ tɔɔsǝɣɩ-ɩ ɩ ɑkɑɩtʋ tɔɔ. Pǝ wɑɑlɩ, ɩlɛnɑ ɩ́ tɛɛnɑ Kilikɑɑ. ");
INSERT INTO dop_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Sɑmiyɛɛlɩ tǝŋɑ ɩ wɑɑlɩ kɛ́ tǝnɑ, ɩlɛnɑ Sɑyuli sɛɛ-ɩ sɩ: Tɑcɑɑ ɩ́ koolɩ-ŋ kʋpɑntʋ. Nɑ ɩ́ tɑsɑ sɩ: Mɑ lɑpɑ teitei kɛ́ ɩsɩɩ Ɩsɔ kɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Mpʋɣʋlɛ Sɑmiyɛɛlɩ pɔɔsɑ-ɩ sɩ: Nɑ nɑɑŋ nɑ heeŋ wulɑ nnɑ mɑ nɩɩkɩ ɩsǝntɔ tɔ, leɣe ɑlɛ ɑ lɩɩnɑɑ? ");
INSERT INTO dop_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Ntɛnɑ Sɑyuli sɩ: Yǝlɑɑ tɔɔsǝnɑ Amɑleke nyǝ́mɑ tɔlɑ kʋpɑnɑ tɑɑ sɩ pɑ lɑkɩ nyɑ́ Ɩsɔ Tɑcɑɑ kɛ kʋcɔɔʋ. Pǝ kɑɑsɑ mpi tɔ, tǝ kpiisɑ pǝlɛ pǝ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ tɔmɑ sɩ: Su, nɑ mɑ heeli-ŋ nti Tɑcɑɑ heelɑ-m ɑhoo ɑnɛ tɔ. Ɩlɛnɑ Sɑyuli sɩ: Yɔɣɔtɩ. ");
INSERT INTO dop_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Mpʋɣʋlɛ Sɑmiyɛɛlɩ sɩ: Pɑɑ nɑ n kɑ nyǝnɑɣɑ nyɑ́ tǝɣɩ pǝyɑɣɑ tɔ, Tɑcɑɑ lǝsɑ-ŋ nɑ ɩ́ kpɑ-ŋ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ nɑ ɩ́ pǝlɩ-ŋ nim. ");
INSERT INTO dop_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Tɑcɑɑ tɔmnɑ-ŋ sɩ, ń polo nɑ ń yoonɑ Amɑleke ɑsɑɣɑɑ mpɛ, nɑ ń kpiisi-wɛ. ");
INSERT INTO dop_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","Ɩlɛ pepe tɔɔ kɛ́ n tɑ nɩɩnɑ ɩ nɔɣɔ, nɑ ń kpɑɣɑ pɑ wontunɑɑ tǝkɛʋ nɑ ń pǝsɩ ɩsɑɣɑʋ kɛ ɩ ɩsɛntɑɑ? ");
INSERT INTO dop_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Ntɛnɑ Sɑyuli cɔ sɩ: Mɑ nɩɩnɑ ɩ nɔɣɔ kɛ teu kɛ, nɑ mɑ́ yoonɑ Amɑleke nyǝ́mɑ ɩsɩɩ ɩ kɑ yɔɣɔtɑɑ tɔ. Mɑ kpiisɑ-wɛ nɑ mɑ́ kɔnɑ pɑ wulɑʋ nɑ ɩ́ ɩsɛ. ");
INSERT INTO dop_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Amɑ yǝlɑɑ tɔɔsǝnɑ pɑ tɔlɑ tɑɑ kɛ́ kʋpɑnɑ sɩ, pɑ lɑkɩ Tɑcɑɑ nyɑ́ Ɩsɔ kɛ́ kɔtɑɣɑ kɛ Kilikɑɑ. ");
INSERT INTO dop_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Ntɛnɑ Sɑmiyɛɛlɩ sɩ: Tɑcɑɑ tɑ sɔɔlɩ kɔtɑsɩ nsi kɔkɔ nyɑɣɑ sɩ tǝnɑ tɔ ɩsɩɩ ɩ sɔɔlʋɣʋ sɩ yʋlʋ ɩ́ nɩɩnɑ-ɩ tɔ se. Ɩ tɔm nɩɩnɑʋ kǝlɑ-ɩ teu kɛ ɩwɑɑŋ kʋpɑŋ kɔtɑsɩ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Mpi tɔ, kpɛɛnɑʋ kɛ́ Ɩsɔ kɛ́ ɩsɑɣɑtʋ kɛ teitei kɛ́ ɩsɩɩ tɩɩtʋ. Ɩ nyǝnǝɣɩ kɑŋkɑntɛ kɛ teitei ɩsɩɩ tɩɩŋ lɑɑʋ. Timpi nyɑ́ lɔ Ɩsɔ Tɔm tɔ, ɩ́lɛ́ ɩ kɑ lɔ-ŋ tɔtɔɣɔ nɑ ń lɑŋ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Mpʋɣʋlɛ Sɑyuli cɔwɑ sɩ: Tɑmpɑnɑ mɑ wɑkǝlǝnɑ Ɩsɔ. Mpi tɔ, mɑ wɑkǝlɑ nti ɩ tʋ-m tɔ. Pǝ́cɔ́ mɑ tɑ nɩɩnɑ nyɑ́ tɔm. Ɩlɛ yǝlɑɑ kɛ mɑ sewɑ nɑ mɑ́ nɩɩnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Hɑɩ, pǝnɛntɛ mɑ wiinɑ-ŋ sɩ ń tɑɣɑnɩ mɑ ɩsɑɣɑtʋ nɑ ń mǝlɩ nɑ mɑ́ hǝntɩ Tɑcɑɑ kɛ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Ntɛnɑ Sɑmiyɛɛlɩ sɩ: Mɑɑ mǝlǝɣɩ. Mpi tɔ, ń lɔ Tɑcɑɑ tɔm. Ɩ́lɛ́ ɩ lɔ nyɑɣɑ, n tɑ kɛ Ɩsɛɣɛlɩ wulɑʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Sɑmiyɛɛlɩ hɑ siɣile sɩ ɩ tɛɛkɩ, ɩlɛnɑ Sɑyuli kpɑ ɩ cɑpɑ ntompǝle nɑ tǝ́ cɛ. ");
INSERT INTO dop_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Kɛlɛnɑ Sɑmiyɛɛlɩ sɩ: Aŋhɑ, ḿpʋ́ɣʋ́ Tɑcɑɑ lɑpɑ nyɑ́ kɑwulɑɣɑ kɛ sɑŋɑ, nɑ ɩ́ hɑ wei ɩ kǝlɑ-ŋ teu tɔ. ");
INSERT INTO dop_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Tɑcɑɑ kɛlɛ Ɩsɛɣɛlɩ toŋ. Ɩ tɑ kɛ yʋlʋ sɩ ɩ looliɣi, yɑɑ ɩ lɑɣɑsǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Ntɛnɑ Sɑyuli tɑsɑ sɩ: Mɑ wɑkǝlɑɑ yɑɑ, ɩlɛ hɑɩ, mɑ wiikinɑ-ŋ sɩ ń kʋsɩ mɑ nyʋɣʋ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ sɔsɑɑ pɑ ɩsɛntɑɑ. Hɑɩ, mǝlɩ nɑ mɑ́ hǝntɩ nyɑ́ Ɩsɔ Tɑcɑɑ kɛ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Mpʋɣʋlɛ Sɑmiyɛɛlɩ mǝlɑɑ nɑ Sɑyuli hǝntɩ Tɑcɑɑ kɛ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Ɩlɛnɑ Sɑmiyɛɛlɩ tɔ sɩ: Ɩ́ kɔnɑ-m Amɑleke nyǝ́mɑ wulɑʋ Akɑkɩ. Akɑkɩ tɔŋnɑ pote nɑ lɑŋhʋlʋmlɛ, nɑ ɩ́ mɑɣɑsǝɣɩ ɩ tɑɑ sɩ: Pɔpɔtʋ fɛɩ leleŋ, sǝm sɔɣɔntʋ yɑwɑ. ");
INSERT INTO dop_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Mpʋɣʋlɛ Sɑmiyɛɛlɩ tɔmɑ sɩ: Ɩsɩɩ nyɑ́ lɑɣɑtɛ pɛm ɑlɑɑ kɛ piyɑ tɔ. Mpʋ ɩnɩ tɔtɔɣɔ nyɑ́ too kɑ́ lɑŋ pǝyɑɣɑ kɛ ɑlɑɑ tɑɑ. Ɩlɛnɑ Sɑmiyɛɛlɩ sɛtɩ-ɩ tǝpʋtʋpʋtʋ kɛ kɔtɑɣɑ tǝlɑtɛ ɩsɛntɑɑ kɛ́ Kilikɑɑ. ");
INSERT INTO dop_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ mǝlɑ ɩ tɛɣɛ Lɑmɑ, nɑ Sɑyuli nɑ́ɑ́ kpe Kipeyɑ. ");
INSERT INTO dop_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Sɑmiyɛɛlɩ nɑ ɩ sǝm ɩ tɑ tɑsɑ mǝlʋɣʋ sɩ ɩ nɑɑkɩ Sɑyuli. Mpi tɔ, ɩ wiikɑɣɑ ɩ tɔɔ kɛ́ timpi Tɑcɑɑ lɑŋlɛ wɑkǝlǝnɑ ɩ kɑwulɑɣɑ kpɑʋ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Sɑmiyɛɛlɩ sɩ: N kɑɑ yele Sɑyuli tɔɔ kɛ́ wulɑ kɛ mpʋ? Mɑ lɔ-ɩ kɛ́. Ɩ tɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ tɔtɔ. Suuli nyɑ́ hǝlʋɣʋ kɛ nim, nɑ mɑ́ tili-ŋ Pɛtǝlɛhɛm tʋ Sesee tɛ. Mɑ nɑwɑ ɩ pǝyɑlɑɑ tɑɑ kɛ́ wei mɑɑ kpɑ wulɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Ntɛnɑ Sɑmiyɛɛlɩ sɩ: Ɩsǝnɑɣɑlɛ mɑɑ lɑ nɑ mɑ́ polo mpʋ? Sɑyuli ɩ́ nɩɩwɑ ɩ kɑ́ kʋ-m. Kɛnɑ Tɑcɑɑ sɩ: Kpɛŋnɑ nɑʋ ɩfɑtɛ, ń tɑlɑɑ, ɩlɛ n tɔ sɩ: Mɑ kɔmɑɣɑ sɩ mɑ lɑkɩ Tɑcɑɑ kɛ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Yɑɑ Sesee kɛ kɔtɑɣɑ tǝlɑtɛ. Ɩlɛ mɑɑ hʋlɩ-ŋ wei n kɑ kpɑ wulɑʋ nɑ ń pǝlɩ nim tɔ. ");
INSERT INTO dop_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ tɛɛ Pɛtǝlɛhɛm ɩsɩɩ Tɑcɑɑ kɑ kɛɛsʋɣʋ tɔ. Ɩcɑtɛ sɔsɑɑ nɑ-ɩ nɑ sɔɣɔntʋ kpɑ-wɛ. Ɩlɛnɑ pɑ́ kpɑɣɑ ɑsewɑ nɑ pɑ́ sǝŋɩ-ɩ nɑ pɑ́ pɔɔsɩ-ɩ sɩ: Alɑɑfǝyɑ kɛlɛ n kɔmɑ? ");
INSERT INTO dop_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Ɩlɛnɑ ɩ́ cɔ sɩ: Ɛɛ ɑlɑɑfǝyɑ kɛ́. Mɑ kɔmɑɣɑ sɩ mɑ lɑkɩ Tɑcɑɑ kɛ kɔtɑɣɑ. Ɩ́ tɑɣɑnɩ mǝ tɩ nɑ ɩ́ kɔɔ kɔtɑɣɑ tǝlɑtɛ. Ḿpʋ́ɣʋ́ ɩ yɑɑ Sesee nɑ ɩ pǝyɑlɑɑ sɩ pɑ́ tɑɣɑnɩ pɑ tɩ nɑ pɑ́ kɔɔ kɔtɑɣɑ tǝlɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Apɑlʋ ɩnɩ ɩ tǝyɑɣɑ nyǝ́mɑ sʋʋ kpɑkpɑɑ, nɑ Sɑmiyɛɛlɩ nɑ ɩ pǝyɑlʋ Iliyɑpɩ, ɩlɛnɑ ɩ́ mɑɣɑsɩ ɩ tɑɑ sɩ: Ɩsǝntɔ wei Tɑcɑɑ lǝsɑɑ tɔɣɔlɔ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Kɛlɛnɑ Tɑcɑɑ tɔ Sɑmiyɛɛlɩ sɩ: Tɑɑ nyǝnɩ tɔɔ, nɑ tɑɣɑlǝŋ. Pǝ tɑɣɑ ɩnǝɣɩ mɑ lǝsɑɑ, mɑɑ pɑɑsǝɣǝnɑ tɔɔ ɩsɩɩ yʋlʋ. Amɑ lotu tɑɑ kɛ́ mɑ nyǝnǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Ḿpʋ́ɣʋ́ Sesee yɑɑ Apinɑtɑpɩ nɑ ɩ́ kɔɔ. Ɩlɛnɑ Sɑmiyɛɛlɩ tɔ sɩ: Pǝ tɑɣɑ ɩnǝɣɩ Tɑcɑɑ lǝsɑɑ. ");
INSERT INTO dop_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Nɑ Sesee yɑɑ Sɑmmɑ, ɩlɛnɑ Sɑmiyɛɛlɩ tɑsɑ sɩ: Tɑcɑɑ tɑ lǝsɩ ɩnɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Ḿpʋ́ɣʋ́ ɩ yɑɑ ɩ pǝyɑlɑɑ nɑɑtosompɔɣɔlɑɣɑ ɩnɩ ɩ tǝnɑ, nɑ Sɑmiyɛɛlɩ tɔ sɩ: Tɑcɑɑ tɑ lǝsɩ pɑ tɑɑ nɔɣɔlʋ. ");
INSERT INTO dop_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Ɩlɛnɑ Sɑmiyɛɛlɩ pɔɔsɩ Sesee sɩ: Nyɑ́ pǝyɑlɑɑ tǝnɑ ntɛ́? Ḿpʋ́ɣʋ́ sɩ pǝ kɑɑsɑ tǝnʋɣʋ, kʋlɛ kʋ polɑ ntiɣile kɛ́. Ntɛnɑ Sɑmiyɛɛlɩ sɩ: Tili ɩ wɑɑlɩ. Mpi tɔ, tǝ kɑɑ cɑɑlɩ kɔtɑɣɑ tɔɣɔnɑɣɑ tɔɣɔʋ nɑ ɩ́ tɑ kɔntɑ. ");
INSERT INTO dop_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Ntɛnɑ pɑ́ tili ɩ wɑɑlɩ. Ɩ ɩsɛntɑɑ kɑ hɛtɑɑ kɛ́ nɑ pǝ́ lɩɩwɑ, nɑ ɩ wɛnɑ ɑlɑɑfǝyɑ. Ntɛnɑ Tɑcɑɑ tɔ Sɑmiyɛɛlɩ sɩ: Ɩnǝɣǝlɛ, kʋlɩ nɑ ń pǝlɩ-ɩ nim ɩlɛ. ");
INSERT INTO dop_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ kpɑɣɑ nim nɑ hǝlʋɣʋ nɑ ɩ́ pǝlɩ-ɩ ɩ tɑɑlʋnɑɑ ɩsɛntɑɑ. Tǝnɑɣɑ Tɑcɑɑ Feesuɣu tii Tɑfiiti tɔɔ kɛ́ pǝ kpɑɣɑʋ kʋyɑŋku tɔ nɑ pǝ́ puki. Ɩlɛnɑ Sɑmiyɛɛlɩ nɑ́ɑ́ kʋlɩ nɑ ɩ́ mǝlɩ ɩ tɛ Lɑmɑ. ");
INSERT INTO dop_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Ḿpʋ́ɣʋ́ Tɑcɑɑ lǝsɑ ɩ Feesuɣu kɛ Sɑyuli tɑɑ, nɑ ɩ́ tʋ-ɩ lǝmɑɣɑsǝlɛ ɩsɑɣɑlɛ nɑ tǝ́ cɔɔsǝɣɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Ntɛnɑ ɩ tǝmlɛ nyǝ́mɑ tɔmɩ-ɩ sɩ: Nyǝnɩ, Tɑcɑɑ tʋ nyɑ́ tɑɑ kɛ́ lǝmɑɣɑsǝlɛ ɩsɑɣɑlɛ nɑ tǝ́ cɔɔsǝɣɩ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Mpʋ tɔ, wulɑʋ, yele nɑ tǝ́ pɛɛkɩ-ŋ yʋlʋ wei ɩ nyǝmɑ́ cǝmʋɣʋ mɑpʋ kɛ teu tɔ. Ye lǝmɑɣɑsǝlɛ ɩsɑɣɑlɛ ɩ́ kʋlɑ nyɑ́ tɔɔ, ɩlɛ ɩ mɑ-ŋ cǝmʋɣʋ nɑ pǝ́ hɛɛsɩ nyɑ́ lɑŋlɛ. ");
INSERT INTO dop_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Mpʋɣʋlɛ Sɑyuli sɩ: Pǝ wɛ teu. Ɩ́ pɛɛkɩ-m kʋpɑŋ nɑ ɩ́ kɔnɑ. ");
INSERT INTO dop_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Tǝnɑɣɑlɛ tǝmlɛ nyǝ́mɑ tɑɑ nɔɣɔlʋ tɔmɑ sɩ: Mɑ nɑwɑ Pɛtǝlɛhɛm tʋ Sesee pǝyɑlɑɑ tɑɑ nɔɣɔlʋ, nɑ ɩ́ nyǝ́mɑ́ cǝmʋɣʋ mɑpʋ kɛ teu. Pǝ́cɔ́ ɩ kii ɩfepu kɛ́ nɑ ɩ́ wɛ kpelikpekɑ, nɑ ɩ nyǝmɑ́ yoou tɔm. Pǝyele ɩ nyǝmɑ́ tɔm yɔɣɔtʋɣʋ kɛ́. Ɩɩ yɔɣɔtǝɣɩ yem yem, nɑ ɩ ɩsɛntɑɑ lɩɩwɑ, nɑ Tɑcɑɑ wɛ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Mpʋɣʋlɛ Sɑyuli tilɑɑ nɑ ɩ heeli Sesee sɩ: Kɔnɑ-m nyɑ́ pǝyɑlʋ Tɑfiiti wei ɩ tiikiɣi heeŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Ntɛnɑ Sesee cɑɑ kpɑŋɑɣɑ, nɑ ɩ́ sʋkɩ-kɛɣɛ tɔɣɔnɑɣɑ, nɑ sʋlʋm huluŋ, nɑ pǝfɑtɛ nɑ ɩ́ tilinɑ Tɑfiiti sɩ ɩ́ ponɑ Sɑyuli. ");
INSERT INTO dop_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Tɑfiiti tɑlɑɑ nɑ ɩ́ sʋʋ Sɑyuli tǝmlɛ tɑɑ, ɩlɛnɑ ɩ́lɛ́ ɩ luɣu lɑpɩ-ɩ nɑ ɩ́ kpɑ-ɩ ɩ yoou wontu tɔkʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Ntɛnɑ Sɑyuli tili nɑ pɑ́ heeli Sesee sɩ: Mɑ luɣu lɑpɑ nyɑ́ pǝyɑlʋ ɩnɩ, yelinɑ-m-ɩ. ");
INSERT INTO dop_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Wɑɑtʋ wei lǝmɑɣɑsǝlɛ ɩsɑɣɑlɛ ɩ́ kɔmɑ Sɑyuli tɑɑ, ɩlɛ Tɑfiiti kpɑɣɑ cǝmʋɣʋ nɑ ɩ́ mɑpɩ-ɩ nɑ pǝ́ cɛ ɩ tɔɔ nɑ ɩ lɑŋlɛ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Ḿpʋ́ɣʋ́ Filiisi yoolɑɑ kotɑɑ, nɑ pɑ́ pɩɩlɩ Soko kɛ Yutɑ tɛtʋ tɑɑ, nɑ Asekɑ pɑ hɛkʋ tɑɑ kɛ́ Ɩfɛsɩ-Tɑmim sɩ, pɑ yookinɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Nɑ Ɩsɛɣɛlɩ yoolɑɑ nɑ pɑ cɑɑ Sɑyuli, pɑ́ koti nɑ pɑ́ pɩɩlɩ Ɩlɑ tɛtɛkǝlɛ tɑɑ sɩ, pɑ yookinɑ pɑ kolontunɑɑ. ");
INSERT INTO dop_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Pʋɣʋ luɣu kɛ Filiisi nyǝ́mɑ kɑ pɩɩlɑɑ, nɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pʋɣʋ lɛŋkʋ luɣu nɑ tɛtɛkǝlɛ kɛ pɑ hɛkʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Ḿpʋ́ɣʋ́ Filiisi yoolɑɑ tɑɑ yoolu nɔɣɔlʋ ɩ lɩɩwɑ nɑ ɩ́ sǝŋ hɛkʋ tɑɑ. Ɩ tɛɣɛlɛ Kɑtɩ nɑ pɑ́ yɑɑkɩ-ɩ sɩ Koliyɑtɩ. Ɩ tɑɣɑlǝŋ wɛ ɩsɩɩ mɛɛtǝlǝnɑɑ tooso kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ yoou kɑhukɑ kɛ ɩ pɑmɑ, nɑ ɩ́ suu kʋ toko. Toko ɩnɩ ɩ yuŋ wɛ ɩsɩɩ kiloonɑɑ nɩɩtoso kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Pǝ kɑɑsɩ nɑ ɩ́ suu-kʋɣʋ ɩ nɔɔhɛɛ tɔɔ, nɑ ɩ́ hɔɣɔlɑ pǝ ŋmɑntɑɑɣɑ sǝkpelɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Nɑ ɩ ŋmɑntɑɑɣɑ sɔsɑɣɑ kpɑ́tʋ́ɣʋ́ yuŋ wɛ ɩsɩɩ sɑɣɑtɑ kpɑtǝlɛ. Nɑ ŋmɑntɑɑɣɑ kɑkpɑŋɑ yuŋ ɩsɩɩ kiloonɑɑ nɑɑtosompɔɣɔlɑɣɑ. Nɑ ɩ kpɑlʋɣʋ tɔkʋlʋ nɑ́ɑ́ tɔŋ ɩ nɔɣɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Mpʋɣʋlɛ ɩ sǝŋɑɑ nɑ ɩ́ holiɣinɑ Ɩsɛɣɛlɩ yoolɑɑ tintikɑ sɩ: Pepe tɔɔ kɛ́ ɩ́ lɩɩwɑ nɑ ɩ́ pɩɩlɩ yoou? Ɩ tɑ nyɩ tɑɑ sɩ, mɑɣɑ Filiisi tʋ, nɑ mɛɣɛ Sɑyuli yomɑɑ? Ɩ́ lǝsɩ ɑpɑlʋ nɑ mɑ́ nɑ-ɩ tǝ́ suli. ");
INSERT INTO dop_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Ye ɩ́ pǝsɑɑ nɑ ɩ́ kʋ-m, tǝ pǝsɩ mǝ yomɑɑ. Amɑ ye mɑ pǝsɑ-ɩ nɑ mɑ́ kʋ-ɩ, ɩ́ kɑ́ lɑ tɑ́ yomɑɑ. ");
INSERT INTO dop_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Nɑ ɩ tɑsɑ sɩ: Sɑŋɑ kɛ mɑɑ tʋʋ Ɩsɛɣɛlɩ nyǝ́mɑ. Ɩ́ lǝsɩ yʋlʋ nɑ mɑ́ nɑ-ɩ tǝ́ yoo. ");
INSERT INTO dop_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Sɑyuli nɑ ɩ yoolɑɑ pɑ nɩɩ mpʋ, ɩlɛnɑ pɑ́ nyɑ́ nɑ sɔɣɔntʋ ɑnɑɑm nɔɣɔlʋ ɩ́ kpɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S117_12","010_17_12","1SA","17","12","14","Yutɑ Pɛtǝlɛhɛm Ɩfǝlɑyim kpekǝle tʋ wei pɑ yɑɑ sɩ Sesee tɔ, ɩ kpɑtǝlɑ teu kɛ Sɑyuli wɑɑtʋ tɑɑ kɛ́. Ɩ kɑ wɛnɑ pǝyɑlɑɑ pǝlefɛɩ nɑɑnʋwɑ nɑ pɑ tɑɑ sɔsɑɑ tooso. Iliyɑpɩ nɑ Apinɑtɑpɩ nɑ Sɑmmɑ pɑɑ tǝŋɑ Sɑyuli kɛ yoou. Pɑ yɑɑkɑɣɑ pɑ tǝnʋɣʋ sɩ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Ɩ lɩɩkɑɣɑ Sɑyuli tɛɣɛ nɑ ɩ́ puki Pɛtǝlɛhɛm nɑ ɩ́ tiikiɣi ɩ cɑɑ heeŋ. ");
INSERT INTO dop_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Koliyɑtɩ sǝŋɑɣɑ hɛkʋ tɑɑ kɛ́ tɑnɑŋ nɑ tɑɑnɑɣɑ kɛ́, kʋyɛɛŋ nɩɩlɛ tǝcu nɑ ɩ́ holiɣinɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ pɑ́ lǝsɩ ɑpɑlʋ nɑ ɩ́ nɑ-ɩ pɑ́ yoo. ");
INSERT INTO dop_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Sesee tɔmɑ Tɑfiiti sɩ: Mʋ pee kʋtoŋee mɑɣɑsǝlɑɣɑ kɑnɛ, nɑ potopotonɑɑ nɑɑnʋwɑ ɩnɛ, nɑ ń ponɑ nyɑ́ tɑɑlʋnɑɑ kɛ tǝyoole tǝcɑʋ. ");
INSERT INTO dop_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Ye pǝ kɑɑsɑ wɑɑkɑsǝnɑɑ nɑɑnʋwɑ ɩnɛ, ɩlɛ n cɛlɑ yoolɑɑ iyɑɣɑ (1000) nyʋɣʋ tʋ. Nɑ ń nɑ́ nyɑ́ tɑɑlʋnɑɑ nɑ pɑ́ cɛlɑ-ŋ pʋlʋ mpi mɑɑ lɑnɑ nɑɑni sɩ pɑ wɛnɑ pɑ weesiŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Pɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɛlɑɑ nɑ Sɑyuli pɑ wɛnnɑ Ɩlɑ tɛtɛkǝlɛ tɑɑ, sɩ pɑ yookinɑ Filiisi nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Ḿpʋ́ɣʋ́ Tɑfiiti yelinɑ ɩ heeŋ kɑlǝkʋ kɛ tɑŋlʋ. Ɩlɛnɑ ɩ́ kʋlɩ tɑnɑŋ kʋpɑŋkʋ tɛɛ nɑ ɩ́ kpɑɣɑ ɩ sǝɣǝlɑ nɑ ɩ́ tɛɛ, ɩsɩɩ ɩ cɑɑ kɑ kɛɛsʋɣʋ-ɩ tɔ. Ɩ tɑlɑ tǝyoole, ɩlɛ yoolɑɑ lɩɩwɑɣɑlɛ sɩ pɑ pɩɩlǝɣɩ nɑ pɑ́ yoo, nɑ pɑ kiisi yoou kɑkiisɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Mpʋɣʋlɛ Filiisi nyǝ́mɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ pɑ pɩɩlɑɑ nɑ pɑ́ nyǝnǝɣɩ tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Ɩlɛnɑ Tɑfiiti nyɔtɔ mpi ɩ kɑ kɔnɑɑ tɔɣɔ wontu feŋlu. Ɩlɛnɑ ɩ́ kpɑɣɑ ɑsewɑ nɑ ɩ́ sʋʋ yoolɑɑ loosi tɑɑ nɑ ɩ́ sɛɛ ɩ tɑɑlʋnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Ɩ tɔŋnɑ-wɛɣɛ yɔɣɔtǝnɑʋ kɛ mpʋ, ɩlɛ yoolɑɑ tɑɑ yoolu Koliyɑtɩ lɩɩwɑɣɑlɛ nɑ ɩ́ holiɣinɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kʋlʋmtʋ ntɩ nɑ Tɑfiiti nɩɩ. ");
INSERT INTO dop_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɑ-ɩ, ɩlɛnɑ sɔɣɔntʋ kpɑ-wɛ nɑ pɑ́ tuliɣi tɑpǝŋ. ");
INSERT INTO dop_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Ḿpʋ́ɣʋ́ yǝlɑɑ yɔɣɔtɑɑ sɩ: Ɩ́ nɑwɑ ɑpɑlʋ ɩnɩ ɩ lɩɩkʋɣʋ ɩsǝntɔ tɔ, Ɩsɛɣɛlɩ nyǝ́mɑ tɑɣɑ ɩ kɔŋ kʋtʋɣʋ. Ye wei ɩ́ pǝsɑ-ɩ nɑ ɩ́ kʋ-ɩ, wulɑʋ kɑ́ sʋsɩ pʋntʋ kɛ toŋ. Ɩ kɑ hɑ-ɩ ɩ pɛɛlɔ. Pǝyele ɩ kɑ́ cɛ ɩ tǝyɑɣɑ tǝnɑɣɑ lɑmpuu. ");
INSERT INTO dop_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Ḿpʋ́ɣʋ́ Tɑfiiti pɔɔsɑ ɩ cɔlɔ nyǝ́mɑ sɩ: Ye wei ɩ kʋwɑ Filiisi tʋ ɩnɩ nɑ ɩ́ kɛɛlɩ Ɩsɛɣɛlɩ nyǝ́mɑ fɛɛlɛ pepeɣe pɑɑ lɑpɩ-ɩ yee? Ɩlɛ Filiisi mɑ tɑ nyɩ ɩsɔ ɩnɩ ɩ kɛ we nɑ ɩ́ tʋʋkɩ Ɩsɔ weesuɣu tʋ yoolɑɑ tintikɑ kɛ mpʋ? ");
INSERT INTO dop_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Ḿpʋ́ɣʋ́ yǝlɑɑ lɛlɑ tɔm kʋlʋmtʋ ntɩ. ");
INSERT INTO dop_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Ɩ tɑɑlʋ sɔsɔ Iliyɑpɩ nɩɩ ɩ yɔɣɔtǝɣǝnɑ yǝlɑɑ. Ɩlɛnɑ ɩ tɑɑ huu kpɑkpɑɑ nɑ ɩ́ tɔmɩ-ɩ sɩ: N cɑɑ weɣe cǝnɛ ye? Aweɣe n yelinɑ nyɑ́ kɑlǝkiyɑ kɛ nyɩɩtʋ tɑɑ? N kɛ́ tɛtɛlɑtʋ nɑ kɑlɑmpɑɑnɩ tʋ kɛ́. Ntɔŋ yoou kɛ n kɔmɑ feŋuɣu yɑɑ? ");
INSERT INTO dop_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Kɛlɛnɑ Tɑfiiti sɩ: Hɑ, mɑ lɑpɑ we? Pǝ tɑ mʋnɑ sɩ mɑ́ pɔɔsɩ mpʋ? ");
INSERT INTO dop_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Ɩlɛnɑ ɩ yele ɩ́lɛ́, nɑ ɩ́ ŋmɑɑ lɛlʋ, nɑ pɑ́ cɔ-ɩ teitei ɩsɩɩ tɔm kɑncɑɑlɑɣɑ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Mpʋɣʋlɛ pɑ tɛlǝsɑ Tɑfiiti kʋyɔɣɔtʋtʋ kɛ Sɑyuli, nɑ ɩ́lɛ́ ɩ tili nɑ pɑ́ yɑɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Ntɛnɑ Tɑfiiti tɔ sɩ: Tɑ cɑɑ, nɔɣɔlʋ lɑŋlɛ ɩ́ tɑɑ tɔnɑ Filiisi tʋ ɩnɩ. Mɑɑ polo nɑ mɑ́ nɑ-ɩ tǝ́ yoo. ");
INSERT INTO dop_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Kɛlɛnɑ Sɑyuli tɔ sɩ: Aɑɩ, n kɔɔsɑ pǝyɑɣɑ, n kɑɑ pǝsɩ nɑ ń yoonɑ Filiisi tʋ ɩnɩ. Mpi tɔ, ɩ́lɛ́ ɩ tǝmlɛ ntɛ́ yoou kɛ too ɩ kʋlʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Tɑfiiti sɩ: Tɑ cɑɑ, wɑɑtʋ wei mɑ tiikɑɣɑ mɑ heeŋ tɔ, ye tɔɣɔlɑɣɑ yɑɑ wontuɣu nɑkʋlɩ kʋ lɩɩwɑ nɑ kʋ́ kpɑ heeŋ, ");
INSERT INTO dop_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","mɑ tɔɣɔnǝɣɩ-kʋɣʋ, nɑ mɑ́ kpɑ-kʋ, nɑ mɑ́ mɑ-kʋ, nɑ mɑ́ lɛɛkɩ heu kɛ kʋ nɔɣɔ tɑɑ. Ye kʋ tilɑ mɑ wɑɑlɩ, ɩlɛ mɑ lǝlɩ kʋ luɣu tɛɛ nɑ mɑ́ kʋ́. ");
INSERT INTO dop_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Ḿpʋ́ɣʋ́ mɑ kʋkɑɣɑ tɔɣɔlɑsɩ nɑ wontunɑɑ lɛntɩ. Mpʋ ɩnɩ tɔtɔɣɔ mɑɑ lɑ Filiisi mɑ tɑ nyɩ ɩsɔ ɩnɛɣɛ timpi ɩ tʋʋ Ɩsɔ weesuɣu tʋ yoolɑɑ tintiɣile tɔ. ");
INSERT INTO dop_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Ɩlɛnɑ Tɑfiiti tɑsɑ sɩ: Tɑcɑɑ wei ɩ yɑpɑ-m tɑɑlɛ wontu sǝkpɑŋ tɑɑ tɔ, ɩ kɑ yɑ-m tɔtɔɣɔ Filiisi tʋ ɩnɛ ɩ niŋ tɑɑ. Kɛlɛnɑ Sɑyuli tɔ sɩ: Tɔʋ, polo, Tɑcɑɑ ɩ́ wɛɛ nyɑ́ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Ḿpʋ́ɣʋ́ Sɑyuli suu Tɑfiiti kɛ ɩ yoou wontu, nɑ ɩ́ pɑmɩ-ɩ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɑhukɑ. ");
INSERT INTO dop_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Ɩlɛnɑ ɩ́ kpɑɣɑ Sɑyuli lɑɣɑtɛ nɑ ɩ́ lǝlɩ nɑ ɩ́ mɑɣɑsɩ tɔntɛ. Mpi tɔ, too tɔ ɩ tɑ suutɑ wontu ntɩ. Ḿpʋ́ɣʋ́ ɩ tɔmɑ sɩ: Tɑ cɑɑ, mɑɑ pǝsǝɣɩ wontu tǝnɛ. Mɑ tɑ mɑlǝnɑ-tɩ. Ɩlɛnɑ ɩ́ wɔɣɔsɩ. ");
INSERT INTO dop_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Ɩlɛnɑ ɩ́ kpɑɣɑ ɩ kpɑ́tʋ́ɣʋ́, nɑ ɩ pǝntɔlʋɣʋ, nɑ ɩ́ tɔɔsɩ pɛɛ kʋsotee kɑkpɑsɩ kɛ lɔɔʋ tɑɑ, nɑ ɩ́ tʋ ɩ ntiɣile huluɣu tɑɑ. Ɩlɛnɑ ɩ́ tɛɛ Koliyɑtɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Mpʋɣʋlɛ Koliyɑtɩ kpǝtǝnɑ Tɑfiiti kɛ pǝcɔ pǝcɔ. Nɑ ɩ kpɑlʋɣʋ tɔkʋlʋ kɛ ɩ nɔɣɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Ɩ nɑ́ Tɑfiiti kɛ teu, ɩlɛnɑ ɩ́ kpɛɛnɑ-ɩ ɩ tɑɑ ɩsɩɩ pǝyɑɣɑ ŋkɑ kɑ sǝŋɑ teu nɑ kɑ ɩsɛntɑɑ lɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Ḿpʋ́ɣʋ́ ɩ kpɛɛsɑ-ɩ sɩ: Mɑ kɛ́ hɑɣɑ yɑɑ we nɑ ń kɔŋ mɑ kiŋ nɑ kpɑtǝŋ? Ɩ tɛmɑ ɩ tɩɩŋ kɛ yɑɑʋ, nɑ ɩ tǝŋsɩ Tɑfiiti kɛ mpusinɑɑ, ɩlɛnɑ ");
INSERT INTO dop_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","ɩ́ tɔmɩ-ɩ sɩ: Kɔɔ cǝnɛ nɑ mɑ́ tʋ nyɑ́ nɑntʋ kɛ kpeliŋ nɑ tɑɑlɛ wontu. ");
INSERT INTO dop_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Ḿpʋ́ɣʋ́ Tɑfiiti cɔ-ɩ sɩ: Lɑɣɑtɛ nɑ ŋmɑntɑɑsɩ kɛ nyɑ́ tɔkɑɑ nɑ ń kɔŋnɑ mɑ wɑɑlɩ. Amɑ mɑ kɔŋ nyɑ́ wɑɑlɩ nɑ Tɑcɑɑ Tomɑ tǝnɑ tʋ Ɩsɛɣɛlɩ yoolɑɑ Ɩsɔ wei n tʋʋwɑ tɔ ɩ toŋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Sɑŋɑ, ɩ kɑ́ tʋ-ŋ mɑ niŋ tɑɑ, nɑ mɑ́ kʋ-ŋ, nɑ mɑ sɛtɩ nyɑ́ nyʋɣʋ. Nɑ mɑ́ tʋ Filiisi yoolɑɑ nɑntʋ kɛ kpeliŋ nɑ tɑɑlɛ wontu. Ɩlɛnɑ tɛtʋ tǝnɑ nyɩ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ wɛnɑ Ɩsɔ nɑ ɩ́ wɑɑsǝɣɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Nɑ sɑmɑɑ ɩnɛ ɩ tǝnɑ ɩ cɛkǝnɑ tɔtɔ sɩ pǝ tɑɣɑ lɑɣɑtɛ yɑɑ ŋmɑntɑɑɣɑ tike kɛ Tɑcɑɑ yɑkǝnɑ. Mpi tɔ, ɩnǝɣǝlɛ ɑkɑnɑɑ cɑɑ. Ɩ kɑ tʋ-mɛɣɛ tɑ́ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Koliyɑtɩ hɔmɑ ɩ tɩ sɩ ɩ sʋʋkɩ Tɑfiiti tɛɛ, ɩlɛnɑ ɩ́lɛ́ ɩ́ kpɑɣɑ ɑsewɑ kɛ lɔŋ nɑ ɩ́ sǝŋɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Nɑ Tɑfiiti lǝsɩ pǝlɛ kɛ huluɣu tɑɑ, nɑ ɩ́ tʋ pǝntɔlʋɣʋ tɑɑ nɑ ɩ́ tɔ́. Ḿpʋ́ɣʋ́ ɩ yɑɣɑ Koliyɑtɩ tokuɣu tɑɑ, nɑ tǝ́ cɑŋ nɑ ɩ fɑlɑ ɩ nɔɣɔ tɔɔ tǝmʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Pǝ lɑpɑ Tɑfiiti kǝlɑ Koliyɑtɩ nɑ pǝntɔlʋpǝlɛ ntɛ́ nɑ ɩ́ kʋ-ɩ. Pǝyele ɩ tɑ tɔkɩ lɑɣɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Ḿpʋ́ɣʋ́ Tɑfiiti kpɑɣɑ ɑsewɑ nɑ ɩ́ polo Koliyɑtɩ kiŋ. Ɩ kpɛɛ ɩ lɑɣɑtɛ ɩlɛnɑ ɩ́ tɛɛsɩ-ɩ, nɑ ɩ́ sɛtɩ ɩ nyʋɣʋ. Filiisi nyǝ́mɑ nɑwɑ sɩ pɑ ɑkɑ sǝpɑ, ɩlɛnɑ pɑ́ kuu-tɛ. ");
INSERT INTO dop_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Ḿpʋ́ɣʋ́ Yutɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ yɑɣɑ yoou kɑkiisɑsɩ, nɑ pɑ́ tɔɣɔnɩ-wɛ nɑ pɑ́ tiinɑ-wɛɣɛ tɛtɛkǝlɛ tɑɑ. Hɑlǝnɑ pɑ́ sʋʋ Ɩkoloŋ nyǝ́mɑ nɔnɔɔsɩ tɛɛ. Nɑ pɑ́ kʋ-wɛɣɛ mpʋ nɑ Sɑlɑyim mpɑɑʋ, hɑlǝnɑ Ɩkoloŋ nɑ Kɑtɩ pǝ ɑcɑlɛɛ. ");
INSERT INTO dop_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Kɛlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ mǝlɩ Filiisi nyǝ́mɑ tǝsikile nɑ pɑ́ kuu wontunɑɑ. ");
INSERT INTO dop_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Ḿpʋ́ɣʋ́ Tɑfiiti ponɑ Koliyɑtɩ nyʋɣʋ kɛ Yosɑlɛm. Ɩlɛnɑ ɩ́ sɩɩ ɩ tǝɣɩ ɩ yoou wontu. ");
INSERT INTO dop_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Wɑɑtʋ wei Tɑfiiti pukɑɣɑ Koliyɑtɩ yoonɑʋ tɔ, Sɑyuli pɔɔsɑ ɩ yoolɑɑ wulɑʋ Apǝnɛɛ sɩ: Awe pǝyɑlʋ kɛ ɩfepu ɩnɛ ɩnɩ ye? Ntɛnɑ ɩ́lɛ́ sɩ: Hɑɩ, tɑ cɑɑ, nɑ mɑ́ sǝŋnɑ ntɛɣɛ cǝnɛ, mɑ tɑ nyɩ. ");
INSERT INTO dop_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Mpʋɣʋlɛ Sɑyuli sɩ: Pɔɔsɩ nɑ ń nyɩ ɩ cɑɑ. ");
INSERT INTO dop_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Tɑfiiti tɛmɑ Koliyɑtɩ kɛ kʋɣʋ nɑ ɩ́ kpɑɣɑ nyʋɣʋ nɑ ɩ́ mǝlɩ. Ɩlɛnɑ Apǝnɛɛ kpɑɣɑ-ɩ nɑ ɩ́ ponɑ Sɑyuli kiŋ. ");
INSERT INTO dop_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Ɩlɛnɑ ɩ pɔɔsɩ-ɩ sɩ: Ɩfepu nyɑ́, ɑwe pǝyɑlʋ kɛ-ŋ? Mpʋɣʋlɛ Tɑfiiti sɩ: Mɑ cɑɑ kɛlɛ nyɑ́ pǝyɑlʋ Pɛtǝlɛhɛm tʋ Sesee. ");
INSERT INTO dop_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Too ɩsɩɩ Tɑfiiti tɛmɑ Sɑyuli kɛ yɔɣɔtǝnɑʋ kɛ mpʋ tɔ, Sonɑtɑŋ luɣu sʋʋ-ɩ kɛlɛ ɩsɩɩ yem nɑ kpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Kʋyɑkʋ ŋkʋ kʋ mɑɣɑmɑɣɑ kɛ Sɑyuli sɩɩ Tɑfiiti kɛ ɩ tǝyɑɣɑ tɑɑ. Tɑfiiti tɑ tɑsɑ ɩ cɑɑ tɛɣɛ mǝlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Ḿpʋ́ɣʋ́ Tɑfiiti nɑ Sonɑtɑŋ pɑ pɛɛlɑ nɔɣɔ sɩ pɑ tɑɑpɑllɛ ɩ wɛɛ tɑm tɔɔ. Mpi tɔ, Sonɑtɑŋ luɣu kɑ sʋʋ Tɑfiiti kɛ teu kɛ́. ");
INSERT INTO dop_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Ḿpʋ́ɣʋ́ Sonɑtɑŋ hɑ Tɑfiiti kɛ ɩ kpɑɩ, nɑ ɩ tokonɑɑ. Nɑ ɩ́ hɑ-ɩ tɔtɔɣɔ ɩ lɑɣɑtɛ nɑ ɩ tɔɔʋ nɑ ɩ tɑmpɑlɑ. ");
INSERT INTO dop_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Ḿpʋ́ɣʋ́ Sɑyuli kpɑ Tɑfiiti kɛ yoolɑɑ nyʋɣʋ tʋ. Mpi tɔ, pɑɑ timpiɣi ɩ tilɑ-ɩ yoou, ɩ lɑkɩ ɑkɑ kɛ́. Ɩlɛnɑ yǝlɑɑ tǝnɑ nɑ wulɑʋ wɑɑlɩ nyǝ́mɑ luɣu lɑ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Wɑɑtʋ wei Tɑfiiti kɑ kʋwɑ Koliyɑtɩ tɔ, ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ lɩɩnɑ yoou, ɩlɛnɑ pɑ ɑcɑlɛɛ tǝnɑ tɑɑ ɑlɑɑ lɩɩ Sɑyuli sǝŋʋɣʋ. Ɩlɛnɑ pɑ́ mɑkɩ wontu, nɑ pɑ́ yooki yontu nɑ pɑ́ pɑɑkɩ, nɑ pɑ́ wilitiɣi. ");
INSERT INTO dop_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Ḿpʋ́ɣʋ́ pɑ tʋ kɑwǝyɑɣɑ sɩ: Sɑyuli kʋwɑ yǝlɑɑ iyɑɣɑ (1000) kɛ huɣule. Tɑfiiti kɛ iyisi nɑɑnʋwɑ (10000) kɛ huɣule. ");
INSERT INTO dop_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Ḿpʋ́ɣʋ́ yontu ntɩ tǝ tɑ mɑɣɑ Sɑyuli nɑ pɑ́ɑ́nɑ́ kpɑ-ɩ sɔsɔm. Mpi pǝ tɔɔ tɔ pɑ yooki sɩ, Tɑfiiti kʋwɑ nɑ pǝ tɛɛ-ɩ. Ye mpʋ kɑwulɑɣɑ kpɑ́tʋ́ɣʋ́ tike ntɛ́ pǝ kɑɑsɑ-ɩ mʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Pǝ kpɑɣɑʋ hɑtoo kʋyɑkʋ ŋkʋ nɑ pǝ puki tɔ, Sɑyuli sʋʋ Tɑfiiti kɛlɛ ɩsɛ cɩɩlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Tɛʋ femɑ ɩlɛ, lǝmɑɣɑsǝlɛ ɩsɑɣɑlɛ nte Tɑcɑɑ tʋ Sɑyuli tɔ, tǝ kʋlǝnɑ-ɩ kɛlɛ. Ɩlɛnɑ ɩ́ yɔɣɔtǝɣɩ yem yem kɛ tǝyɑɣɑ tɑɑ ɩsɩɩ kpɑŋtʋ, nɑ ɩ ŋmɑntɑɑɣɑ kɛ ɩ niŋ tɑɑ. Tɑfiiti nɑ́ mɑkɑɣɑ cǝmʋɣʋ ɩsɩɩ ɩ tɩɩ lɑkɩ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Ḿpʋ́ɣʋ́ Sɑyuli mɑɣɑsɑ ɩ tɑɑ sɩ: Ɩsɩɩ mɑ kɑmɑ-ɩ ŋmɑntɑɑɣɑ nɑ kutuluɣu. Ɩlɛnɑ ɩ́ lɔɣɔ-ɩ-kɛɣɛ tɔm nɑɑlɛ, nɑ Tɑfiiti nɑ́ɑ́ fɛɛkɩ-kɛɣɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Ɩlɛnɑ Sɑyuli sʋʋ Tɑfiiti kɛ nyɑmnɑʋ. Mpi tɔ, Tɑcɑɑ kɑ yelɑ Sɑyuli kɛ́ nɑ ɩ́ wɛɛ Tɑfiiti wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Ntɛnɑ Sɑyuli lǝsɩ Tɑfiiti kɛ ɩ tǝyɑɣɑ tɑɑ nɑ ɩ́ kpɑ-ɩ yoolɑɑ iyɑɣɑ (1000) nyʋɣʋ tʋ, nɑ ɩ pukinɑ-wɛɣɛ yoou. ");
INSERT INTO dop_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Nɑ Tɑcɑɑ wɛ Tɑfiiti wɑɑlɩ nɑ ɩ́ wɑɑkɩ ɩ yoou tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Sɑyuli nɑ́ mpʋ, ɩlɛnɑ sɔɣɔntʋ sɔɔsɩ-ɩ kpɑʋ. ");
INSERT INTO dop_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Amɑ Ɩsɛɣɛlɩ nɑ Yutɑ pǝ nyǝ́mɑ luɣu kɑ wɛ Tɑfiiti kɛ teu. Mpi tɔ, ɩnɩ ɩ kɑ kɛnɑ pɑ nyʋɣʋ tʋ, nɑ ɩ́ pukinɑ-wɛɣɛ yoou nɑ ɩ́ lɑkɩ ɑkɑ. ");
INSERT INTO dop_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Ḿpʋ́ɣʋ́ Sɑyuli tɔmɑ Tɑfiiti sɩ: Ye n lɑpɑ mɑ tǝmlɛ kɛ teu nɑ kpelikpekɑ nɑ ń yooki Tɑcɑɑ yoou. Mɑɑ hɑ-ŋ mɑ pɛɛlɔ kɑncɑɑlɑɣɑ nyǝŋ Melɑpɩ nɑ ń lɑ ɑlʋ. Nɑ Sɑyuli yɔɣɔtǝɣɩ ɩ tɑɑ sɩ: Tǝnɑɣɑ Filiisi nyǝ́mɑ kɑ́ kʋnɑ-ɩ. Mɑ niŋ kɑɑ kpɑ ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Tǝnɑɣɑlɛ Tɑfiiti cɔwɑ sɩ: Mɑɣɑlɛ ɑwe? Nɑ mɑ cɑɑ tǝyɑɣɑ ntɛ́ ŋkɑɣɑ Ɩsɛɣɛlɩ tɑɑ? Nɑ hɑlɩ mɑ́ɑ́ lɑkɩ wulɑʋ yǝtɩ? ");
INSERT INTO dop_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Pǝ tɑlɑ wɑɑtʋ wei sɩ Tɑfiiti kpɑkǝɣɩ Melɑpɩ, ɩlɛnɑ pɑ́ hɑ-ɩ Apɛɛlɩ-Meholɑ tʋ Atǝlǝyɛlɩ. ");
INSERT INTO dop_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Mpʋɣʋlɛ Sɑyuli pɛɛlɔ nɑɑlɛ nyǝŋ Mikɑɑlɩ luɣu sʋʋ Tɑfiiti. Ɩlɛnɑ pɑ́ tɑɣɑsɩ wulɑʋ nɑ pǝ́ mɑɣɑ-ɩ teu. ");
INSERT INTO dop_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Ḿpʋ́ɣʋ́ ɩ tʋ ɩ tɑɑ sɩ: Mɑ hɑɑkɩ-ɩ Mikɑɑlɩ kɛ́. Ɩ kiŋ kɛ pɩɩ kpɑnɑ-ɩ kɑtɔkɑ nyǝm, nɑ Filiisi nyǝ́mɑ hiki-ɩ nɑ pɑ́ kʋ-ɩ. Ḿpʋ́ɣʋ́ Sɑyuli tɑsɑ Tɑfiiti kɛ heeluɣu kɛ tɔm nɑɑlɛ nyǝm sɩ: Sɑŋɑ n kɑ́ pǝsɩ mɑ yǝtɩ. ");
INSERT INTO dop_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Nɑ ɩ́ sɔsɩ ɩ wɑɑlɩ nyǝ́mɑ sɩ: Ɩ́ heeli Tɑfiiti kɛ mukɑɣɑ sɩ, wulɑʋ lɑŋlɛ hɛɛnɑ-ŋ teu kɛ́. Pǝ́cɔ́ ɩ wɑɑlɩ nyǝ́mɑ luɣu sʋʋ-ŋ. Pǝ tɔɔ tɔ, kpɑɣɑ ɩ pɛɛlɔ ɩnǝɣɩ pǝnɛntɛ. ");
INSERT INTO dop_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Pɑ heelɑ Tɑfiiti kɛ mpʋ, ɩlɛnɑ ɩ́lɛ́ ɩ tɔ sɩ: Sɩ yʋlʋ ɩ́ lɑ wulɑʋ yǝtɩ tɔ, pǝ wɛ nyʋɣʋ kɛ́. Amɑ mɑ tɑ tɑlɑ pʋlʋ, pǝ́cɔ́ mɑ kɛ kʋnyɔntʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Ḿpʋ́ɣʋ́ pɑ kɛɛsɑ wulɑʋ kɛ nti Tɑfiiti cɔwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Ntɛnɑ ɩ́ tɔ sɩ: Mpi mɑ cɑɑ sɩ Tɑfiiti ɩ́ suu mɑ pɛɛlɔ tɔɔ tɔɣɔlɛ sɩ, ɩ́ kʋ́ Filiisi nyǝ́mɑ kɛ nɩɩnʋwɑ (100). Ɩlɛnɑ ɩ́ kɔnɑ-m pɑ hǝnnɔɔsɩ, nɑ pǝ́ lɛɛtɩ mɑ kolontunɑɑ. Nɑ Sɑyuli lʋkɩ kɛlɛ sɩ ntɑnyɩ pɑ hiki Tɑfiiti nɑ tǝnɑ nɑ pɑ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S118_26","010_18_26","1SA","18","26","26","Wulɑʋ wɑɑlɩ nyǝ́mɑ heelɑ Tɑfiiti kɛ mpʋ, ɩlɛnɑ ɩ́lɛ́ ɩ tisi sɩ ɩ kɑ́ lɑ wulɑʋ yǝtɩ. ");
INSERT INTO dop_vpl VALUES ("S118_27","010_18_27","1SA","18","27","27","Ḿpʋ́ɣʋ́ Tɑfiiti kpɑɣɑ ɩ yoolɑɑ nɑ ɩ́ polo nɑ ɩ́ kʋ Filiisi nyǝ́mɑ kɛ yǝlɑɑ ŋmʋnʋɣʋ (200), nɑ kʋyɑkʋ ŋku pɑ sɩɩwɑ tɔ kʋ tɑ tɑtɑ. Nɑ ɩ́ ponɑ pɑ hǝnnɔɔsɩ nɑ ɩ́ kɑlɑ-sɩ tǝcʋŋŋ nɑ ɩ́ cɛlɑ wulɑʋ kɛ teitei ɩsɩɩ ɩlɛ ɩ cɑɑkɑɣɑ tɔ, nɑ ɩ́ pǝsɩ ɩ yǝtɩ. Ɩlɛnɑ wulɑʋ hɑ-ɩ ɩ pɛɛlɔ Mikɑɑlɩ nɑ tǝlɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Ḿpʋ́ɣʋ́ Sɑyuli cɛkǝnɑɑ tǝfoo sɩ Tɑcɑɑ wɛ Tɑfiiti wɑɑlɩ. Pǝ kɑɑsɩ Mikɑɑlɩ nɑ́ sɔɔlɑ-ɩ teu. ");
INSERT INTO dop_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","Ɩlɛnɑ ɩ́ nyɑŋnɑ Tɑfiiti, nɑ ɩ́ pǝsɩ ɩ kolontu kɛ hɑlǝnɑ ɩ sǝm. ");
INSERT INTO dop_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Filiisi ɑwulɑɑ lɩɩkɑɣɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kʋlɩɩʋ kɛ́, nɑ Tɑfiiti kɑ kʋkɑɣɑnɑ-wɛ nɑ pǝ́ kǝlɩ Sɑyuli yoolɑɑ nyʋɣʋ nyǝ́mɑ lɛlɑɑ. Ɩlɛnɑ ɩ hǝtɛ tɔŋnɑ yɑɑʋ nɑ pǝ́ puki. ");
INSERT INTO dop_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Ḿpʋ́ɣʋ́ Sɑyuli tɔmɑ ɩ wɑɑlɩ nyǝ́mɑ tǝnɑ, nɑ ɩ pǝyɑlʋ Sonɑtɑŋ sɩ pɑ́ kʋ́ Tɑfiiti. Amɑ Sonɑtɑŋ luɣu nɑ́ sʋʋ Tɑfiiti kɛ teu, ɩlɛnɑ ɩ tɑɣɑsɩ-ɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","Mɑ cɑɑ lʋkɩ sɩ ɩ́ kʋ-ŋ yoo. Mpʋ tɔ, cele tɑnɑŋ lɑ lɑɑkɑlɩ, kpɑ tɑɑlɛ nɑ ń ŋmɛlɩ. ");
INSERT INTO dop_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Mɑ́ lɩɩwɑ mɑɑ polo mɑ cɑɑ kiŋ kɛ tɑɑlɛ nte tǝ tɑɑ n wɛ mpʋ tɔ, nɑ mɑ́ yɔɣɔtǝnɑ-ɩ nyɑ́ tɔm, ɩ́ yɔɣɔtɑɑ suwe ɩlɛ mɑ kɛɛsɩ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S119_4","010_19_4","1SA","19","4","5","Ḿpʋ́ɣʋ́ Sonɑtɑŋ sɑmɑ Tɑfiiti kɛ ɩ cɑɑ Sɑyuli kiŋ sɩ: Pɑɑpɑ, nyɑ́ kʋlʋkʋ kɛ Tɑfiiti ɩnɩ ɩ lʋkɑɣɑ. Hɑlǝnɑ ɩ́ lɑ ɩ weesuɣu kɛ ɑwusɑ nɑ ɩ́ kʋ Koliyɑtɩ. Ɩ lɑpɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ kǝlɩ pɑ kolontunɑɑ tǝcɑɣɑcɑɣɑ, nɑ nyɑ́ mɑɣɑmɑɣɑ n nɑ mpʋ nɑ nyɑ́ lɑŋlɛ hʋlʋmɩ. Mpʋ tɔ, pepe tɔɔ kɛ́ n kɑ kʋ-ɩ mʋsʋŋ kɛ yem kɛ mpʋ? Tɑɑ wɑkǝlǝnɑ-ɩ. Mpi tɔ, ɩ́lɛ́ ɩ tɑ wɑkǝlǝnɑ nyɑ́. ");
INSERT INTO dop_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Mpʋɣʋlɛ Sɑyuli nɩɩnɑ ɩ pǝyɑlʋ nɑ ɩ́ yɔɣɔtɩ nɑ ɩ́ tuunɑ Tɑcɑɑ sɩ: Mɑ kɑɑ kʋ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Ɩlɛnɑ Sonɑtɑŋ yɑɑ Tɑfiiti nɑ ɩ́ kɛɛsɩ-ɩ pǝ tǝnɑ. Ɩlɛnɑ ɩ́ mǝŋnɑ-ɩ Sɑyuli kiŋ nɑ ɩ́ lɑkɩ tǝmɑ nnɑ tuu ɩ lɑkɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Ḿpʋ́ɣʋ́ yoou tɑsɑ kʋlʋɣʋ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ Filiisi nyǝ́mɑ hɛkʋ tɑɑ. Ntɛnɑ Tɑfiiti yoonɑ-wɛ nɑ ɩ́ kǝlɩ-wɛ tǝcɑɣɑcɑɣɑ, nɑ ɩ́ tɔɣɔnɩ. ");
INSERT INTO dop_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Ɩlɛnɑ Tɑcɑɑ tʋ Sɑyuli kɛ lǝmɑɣɑsǝlɛ ɩsɑɣɑlɛ nɑ ɩ́ cɑɣɑ ɩ tǝyɑɣɑ tɑɑ. Nɑ ɩ́ tɔkɑ ŋmɑntɑɑɣɑ kɛ ɩ niŋ tɑɑ, ");
INSERT INTO dop_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","nɑ Tɑfiiti nɑ́ɑ́ tɔŋnɑ-ɩ cǝmʋɣʋ mɑpʋ. Ḿpʋ́ɣʋ́ ɩ mɑɣɑsɑɑ sɩ ɩ yɑkɩ Tɑfiiti kɛ ŋmɑntɑɑɣɑ nɑ ɩ́ kpǝnɑ kutuluɣu. Amɑ ɩ́lɛ́ ɩ fɛɛ-kɛ. Ɩlɛnɑ kɑ́ yɑɣɑ kutuluɣu, nɑ Tɑfiiti se ɑhoo ɑnɩ. ");
INSERT INTO dop_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Mpʋɣʋlɛ Sɑyuli tilɑ yǝlɑɑ sɩ pɑ́ feŋ Tɑfiiti tǝyɑɣɑ. Ye kʋ femɑ tɑnɑŋ, ɩlɛ pɑ kʋ-ɩ. Kɛnɑ ɩ ɑlʋ Mikɑɑlɩ heeli-ɩ sɩ: Ye n tɑ se ɑhoo ɑnɛ, cele ɩsǝntɔ n sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Ɩlɛnɑ Mikɑɑlɩ lǝsɩ Tɑfiiti nɑ pǝtote nɑ ɩ́ se. Pǝ lɑpɑ ɩ tʋlɑɑ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Pǝ wɑɑlɩ kɛ́ Mikɑɑlɩ kpɑɣɑ yʋlʋ lɛɛsʋɣʋ ŋku pɑ sɑɑkɑɑ tɔ, nɑ ɩ́ hɩɩsɩ kɑto tɔɔ nɑ ɩ́ tʋ pǝ́ŋ́ tɔnʋɣʋ kɛ nyʋɣʋ cɔlɔ, nɑ ɩ́ tɑkɩ pʋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Pǝ kɔmɑ nɑ Sɑyuli tili sɩ pɑ́ kpɑ-ɩ, ɩlɛnɑ Mikɑɑlɩ heeli-wɛ sɩ pǝ wɩɩkɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Mpʋɣʋlɛ Sɑyuli mǝlǝnɑ tillɑɑ sɩ pɑ́ polo pɑ́ nɑ-ɩ, nɑ pɑ́ kɔnɑ-ɩ nɑ ɩ kʋhǝntʋɣʋ nɑ ɩnɩ ɩ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Yǝlɑɑ mpɛ pɑ mǝlɑɑ ɩlɛ sɛsɛ yʋlʋ lɛɛsʋɣʋ ntɛ́, nɑ pɑ́ tʋ pǝ́ŋ́ hʋntʋ kɛ kʋ nyʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Ntɛnɑ Sɑyuli tɔ Mikɑɑlɩ sɩ: Pepe tɔɔ kɛ́ n puɣusɑ-m nɑ ń yele nɑ mɑ kolontu fiti? Kɛnɑ Mikɑɑlɩ nɔɣɔ tǝkpɑʋ sɩ: Tɑfiiti tɔmɑ-m kɛ́ sɩ ye mɑ tɑ yele-ɩ ɩ kɑ́ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Mpʋ pǝ lɑpǝnɑ nɑ Tɑfiiti se nɑ ɩ́ polo Sɑmiyɛɛlɩ kiŋ kɛ Lɑmɑ nɑ ɩ́ kɛɛsɩ-ɩ pǝ tǝnɑ mpi Sɑyuli lɑpɑ-ɩ tɔ. Ɩlɛnɑ ɩ́ tǝŋ Sɑmiyɛɛlɩ kɛ Nɑyɔtɩ nɑ ɩ́ cɑɣɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Mpʋɣʋlɛ pɑ tɑɣɑsɑ Sɑyuli sɩ: Tɑfiiti wɛ Nɑyɔtɩ kɛ Lɑmɑ cɔlɔ. ");
INSERT INTO dop_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Ɩlɛnɑ ɩ́ tili sɩ pɑ́ kpɑ-ɩ. Ḿpʋ́ɣʋ́ tillɑɑ mɑɣɑnɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ kpekǝle kɛ tǝnɑ nɑ Sɑmiyɛɛlɩ kɛ pɑ nyʋɣʋ tʋ. Tǝnɑɣɑ Ɩsɔ Feesuɣu tii tillɑɑ mpɛ pɑ tɔɔ, nɑ pɑ́ sʋʋ pɑɑlɛ nɑ Ɩsɔ sɑm. ");
INSERT INTO dop_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Ḿpʋ́ɣʋ́ pɑ tɑɣɑsɑ Sɑyuli kɛ tɔm ntɩ. Ɩlɛnɑ ɩ́ tili kʋfɑmɑ, nɑ pɛlɛ pɑ́ pɑɑkɩ nɑ pɑ́ sɑŋ Ɩsɔ. Nɑ ɩ́ tɑsɑ lɛlɑɑ kɛ tiluɣu kɛ tɔm tooso nyǝm, nɑ pɛlɛ pɑ́ pɑɑkɩ nɑ pɑ́ sɑŋ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Ḿpʋ́ɣʋ́ Sɑyuli kpɛsɑ ɩ mɑɣɑmɑɣɑ nɑ ɩ́ polo Lɑmɑ. Ɩ tɑlɑ lɔkɔ sɔsɔ wei ɩ wɛ Seku cɔlɔ tɔ ɩlɛnɑ ɩ́ pɔɔsɩ sɩ: Leɣe Sɑmiyɛɛlɩ nɑ Tɑfiiti pɑ wɛɛ? Ntɛnɑ pɑ́ cɔ-ɩ sɩ: Pɑ wɛ Nɑyɔtɩ. ");
INSERT INTO dop_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Sɑyuli kpɑɣɑ Nɑyɔtɩ mpɑɑʋ, ɩlɛnɑ Ɩsɔ Feesuɣu tii ɩ tɔɔ, nɑ ɩ́ tɔŋ nɑ ɩ́ pɑɑkɩ nɑ ɩ́ sɑŋ Ɩsɔ, hɑlǝnɑ ɩ́ tɑlɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Ɩ tɑlɑ Sɑmiyɛɛlɩ pɑ kiŋ, ɩlɛnɑ ɩ́ wɔɣɔsɩ wontu nɑ ɩ́ pɑɑkɩ nɑ ɩ́ sɑŋ Ɩsɔ kɛ mpʋ. Hɑlǝnɑ ɩ́ hǝntɩ ɑtɛɣɛ ilim nɑ pǝ tɛm nɑ ɑhoo tǝnɑ. Pǝ tɔɔ kɛ́ yǝlɑɑ pɔɔsǝɣɩ tǝmɑ sɩ: Sɑyuli nɑ́ wɛ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ tɑɑ tɔtɔɣɔ? ");
INSERT INTO dop_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti sewɑ Nɑyɔtɩ kɛ Lɑmɑ kiŋ nɑ ɩ́ polo ɩ́ mɑɣɑnɑ Sonɑtɑŋ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Mɑ lɑpɑ we? Pepeɣe mɑ wɑkǝlɑɑ? Ɩsɑɣɑtʋ ntiɣi mɑ lɑpɑ nyɑ́ cɑɑ nɑ ɩ́ pɛɛkǝɣɩ mɑ weesuɣu? ");
INSERT INTO dop_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Tǝnɑɣɑlɛ Sonɑtɑŋ cɔwɑ sɩ: Ɩsɔ ɩ́ ponɑ pooluŋ. Pɔpɔtʋ kɛ́, n kɑɑ sɩ. Mɑ cɑɑ ɩɩ lɑkɩ pʋlʋ cǝcǝkɑ nɑ ɩ́ ŋmɛsɩ-m. Ɩlɛ pǝ fɛɩ sɩ ɩ́ lɑ mpʋ nɑ mɑ́ tɑ́ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Mpʋɣʋlɛ Tɑfiiti cɔwɑ sɩ: Nyɑ́ cɑɑ cɛkǝnɑɑ sɩ n cɑɑkɩ mɑ tɔm kɛ teu. Ntɑnyɩ ɩ mɑɣɑsɑ ɩ tɑɑ kɛ́ sɩ ń tɑɑ nɩɩ-tɩ nɑ pǝ́ kɔɔ nɑ nyɑ́ lɑŋlɛ wɑkǝlɩ. Mpʋ tɔ, mɑ tuukinɑ Tɑcɑɑ nɑ nyɑ́ mɑɣɑmɑɣɑ sɩ pǝ kɑɑsɑ-m pǝcɔɣɔ nɑ mɑ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Ḿpʋ́ɣʋ́ Sonɑtɑŋ tɔmɑ-ɩ sɩ: Mɑɑ lɑ-ŋ pǝ tǝnɑ mpi n sɔɔlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Ntɛnɑ Tɑfiiti sɩ: Cele ntɛ́ ɩsɔtʋ kʋfɑlʋ ɑcimɑ. Pɩɩ wɛɛ sɩ mɑ nɑ wulɑʋ tǝ́ tɔɣɔnɑ. Pɑɑ nɑ mpʋ tɔ, yele mɑ kpɑ tɑɑlɛ nɑ mɑ́ ŋmɛlɩ. Hɑlǝnɑ kʋyɑkʋ tooso nyǝŋkʋ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Ye nyɑ́ cɑɑ pɔɔsɑ mɑ tɔɔ, ɩlɛ n heeli-ɩ sɩ: Tɑfiiti wiinɑ-m sɩ mɑ́ yele-ɩ nɑ ɩ́ lɔɣɔ ɩ tǝɣɩ ɩ tɛ Pɛtǝlɛhɛm. Pɑ lɑkɩ ɩ tǝyɑɣɑ tɑɑ kɛ́ pǝnɑɣɑ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Ye ɩ tɔmɑ sɩ pǝ wɛ teu, ɩlɛ nyɑ́ pǝyɑlʋ mɑ́, mɑ kɑɑ nyɑnɑ pʋlʋ tɔtɔ. Amɑ ye ɩ pɑ́ɑ́nɑ́ huuwɑ, ɩlɛ nyɩ kpɑkpɑɑ sɩ nyɑ́ cɑɑ tɛmɑ ɩ tɑɑ kɛlɛ sɩ ɩ lɑkɩ-m ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","Mpʋ tɔ, lɑ-m kʋpɑntʋ kɛ teitei ɩsɩɩ n kɑ sɩɩʋ nyɑ́ nɔɣɔ kɛ Tɑcɑɑ ɩsɛntɑɑ tɔ. Nɑ ye mɑ tɩɩ lɑpɑ ɩsɑɣɑtʋ nɑtǝlɩ, kʋ-m nyɑ́ mɑɣɑmɑɣɑ. Pepe tɔɔ kɛ́ n kɑ́ nɔkɩ-m nyɑ́ cɑɑ kiŋ kɛ ponɑʋ? ");
INSERT INTO dop_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Kɛlɛnɑ Sonɑtɑŋ sɩ: Mpusi ɩ́ polo pooluŋ, nɑ mpi mɑɑ nɩɩ sɩ mɑ cɑɑ lʋkɩ nyɑ́ weesuɣu lǝsʋɣʋ nɑ mɑ́ ŋmɛsɩ-ŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Ḿpʋ́ɣʋ́ Tɑfiiti pɔɔsɑ-ɩ sɩ: Ye nyɑ́ cɑɑ lɑŋlɛ tɑ hɛɛ ɑwe kɑ heeli-m? ");
INSERT INTO dop_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Ntɛnɑ Sonɑtɑŋ yɑɑ-ɩ sɩ: Kɔɔ nɑ tǝ́ lɩɩ nɑ tǝ́ kpɑ tɑɑlɛ. Ɩlɛnɑ pɑ nɑɑlɛ pɑ kpɑ tɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Ḿpʋ́ɣʋ́ Sonɑtɑŋ tɔmɑ Tɑfiiti sɩ: Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ kɛlɛ mɑ ɑseetɑ tʋ. Ɩlɛ mɑɑ nɑ mɑ cɑɑ kɛ cele, yɑɑ celeŋkufe. Ye ɩ lɑŋlɛ hɛɛnɑ-ŋ nɑ mɑ́ tɑ́ tili nɑ pɑ́ heeli-ŋ, ");
INSERT INTO dop_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Tɑcɑɑ ɩ́ kʋ-m. Pɑɑ ɩ tʋ ɩ tɑɑ sɩ ɩ kɑ́ tɩɩ lɑ-ŋ ɩsɑɣɑtʋ mɑɑ heeli-ŋ. Pǝ́cɔ́ mɑɑ yele-ŋ tɔtɔ, nɑ ń tɛɛnɑ ɑlɑɑfǝyɑ. Tɑcɑɑ ɩ́ wɛɛ nyɑ́ wɑɑlɩ, ɩsɩɩ ɩ kɑ wɛʋ mɑ cɑɑ wɑɑlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S120_14","010_20_14","1SA","20","14","14","Nɑ ye mɑɑ wɛɛnɑ weesuɣu, ɩlɛ n lɑ-m kʋpɑntʋ nti Ɩsɔ lɑpɑ-ŋ tɔ nɑ pɑɑ mɑ tɩɩ sǝpɑ, ");
INSERT INTO dop_vpl VALUES ("S120_15","010_20_15","1SA","20","15","15","nɑ pǝ́ kɔɔ nɑ Tɑcɑɑ kpiisi nyɑ́ kolontunɑɑ tǝnɑɣɑ kʋlʋm kʋlʋm, tɑɑ yele mɑ tǝyɑɣɑ kɛ kʋpɑntʋ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Pǝ tɑɣɑ pʋlʋ, Sonɑtɑŋ nɑ Tɑfiiti pɑɑ sɩɩ nɔɣɔ kɛ́ nɑ ye Tɑfiiti nɑ ɩ tǝyɑɣɑ nyǝ́mɑ pɑ yɔkɑ-kɛ Tɑcɑɑ kɑ́ yele nɑ ɩ kolontunɑɑ lɛɛtɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Ḿpʋ́ɣʋ́ pɑ tɑsɑ tǝmɑɣɑ nɔɔsɩ sɩɩʋ. Mpi tɔ, Sonɑtɑŋ kɑ sɔɔlɑ-ɩ kɛ́ ɩsɩɩ yem nɑ kpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Nɑ Sonɑtɑŋ tɔmɩ-ɩ sɩ: Cele ntɛ́ ɩsɔtʋ kʋfɑlʋ ɑcimɑ. Pɩɩ nɑ́ sɩ n fɛɩ. Mpi tɔ, nyɑ́ tǝcɑɣɑlɛ kɑ́ wɛɛ kpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","N kɑ́ polo kʋyɑkʋ tooso nyǝŋkʋ wule nɑ ń ŋmɛlɩ kɑŋmɑɑɣɑ ŋkɑ kɑ kiŋ n kɑ tɛmɑ ŋmɛlʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Mɑɑ tɔ nyǝ́mɑ tooso, nɑ pǝlɛ ntɛ́ tǝ kiŋ tɔɔ, ɩsɩɩ mɑ nɑ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Ɩlɛnɑ mɑ́ tili ɩwɑɑsǝlɛ nɑtǝlɩ sɩ tǝ́ pɛɛkɩ-yɛ. Ye mɑ heelɑ-tɛ sɩ nyǝmɑ́ ntɛ́ mɑ tɔɔ mɑ tɔɔ cǝnɛ. Kpɑɣɑ-yɛ nɑ ń kɔnɑ. Ɩlɛ n kɔɔ, tɑɑ nyɑ́, nɑtǝlɩ tǝ fɛɩ kɛlɛ. Nɑ Ɩsɔ, mɑɑ looliɣi. ");
INSERT INTO dop_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Amɑ ye mɑ tɔmɑ ɩwɑɑsǝlɛ sɩ nyǝmɑ́ ntɛ́ nyɑ́ nɔɣɔ tɔɔ, ɩlɛ n tɛɛ. Tɑcɑɑ tɔɣɔnǝɣɩ-ŋ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Tɑcɑɑ kɛlɛ mɑ́ nɑ-ŋ tɑ́ ɑseetɑ tʋ kɛ tɑm tɔɔ, kɛ tɔm nti tǝ yɔɣɔtɑ ɩsǝntɔ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S120_24","010_20_24","1SA","20","24","25","Ḿpʋ́ɣʋ́ Tɑfiiti sewɑ nɑ ɩ́ ŋmɛlɩ tɑɑlɛ. Pǝ tɑlɑ ɩsɔtʋ kʋfɑlʋ ɑcimɑ tɑɑnɑɣɑ ɩlɛnɑ wulɑʋ cɑɣɑ ɩ tǝcɑɣɑlɛ kɛ koluŋɑ kite kɛ tɔɣɔʋ. Apǝnɛɛ nɑ́ cɑɣɑ ɩ kɔŋkɔŋ tɑɑ, nɑ Sonɑtɑŋ kɛ ɩsɛntɑɑ, nɑ Tɑfiiti tǝcɑɣɑlɛ kɛ kpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Wulɑʋ tɑ yɔɣɔtɩ sɩ pʋlʋɣʋ kʋyɑkʋ ŋkʋ. Mpi tɔ, ɩ hʋʋkɑɣɑ sɩ ntɑnyɩ ɩsɑɣɑtʋ nɑtǝlɩ tǝ mɑɣɑnɑ-ɩ kɛ́ nɑ ɩ kɑɑ kɔɔ ɑcimɑ. ");
INSERT INTO dop_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Tɛʋ femɑ ɩsɔtʋ kʋfɑlʋ kʋyɑkʋ nɑɑlɛ nyǝŋkʋ wule nɑ Tɑfiiti fɛɩ tɔtɔ. Ɩlɛnɑ Sɑyuli pɔɔsɩ ɩ pǝyɑlʋ sɩ: Pepe tɔɔ kɛ́ Sesee pǝyɑlʋ ɩnɩ ɩ tɑ kɔɔ tɔɣɔʋ kɛ tete nɑ sɑŋɑ? ");
INSERT INTO dop_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Ntɛnɑ Sonɑtɑŋ sɩ: Ɩ sǝlǝmɑ-m sɩ yele-m nɑ mɑ́ polo Pɛtǝlɛhɛm. ");
INSERT INTO dop_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Mɑ tɑɑlʋ heelɑ-m sɩ mɑ nyǝ́mɑ lɑkɩ kɔtɑɣɑ kɛ tɑ tɛ. Ye n kɛ́ mɑ tɑɑpɑlʋ yele-m nɑ mɑ́ lɔɣɔ mɑ tɩ nɑ mɑ́ nɑ́ mɑ tɑɑlʋnɑɑ. Pǝ tɔɔ kɛ́ ɩ fɛɩ tǝtɔɣɔlɛ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Tǝnɑɣɑlɛ Sɑyuli pɑ́ɑ́nɑ́ huuwɑ nɑ ɩ́ tɔ sɩ: Alʋ tɛtɛlɑtʋ pǝyɑɣɑ nyɑ́. Mɑ tɑ nyɩ tɑɑ sɩ nyɑ́ cɑmnɑ kɛlɛ Sesee pǝyɑlʋ? Nyɑ́ nɑ nyɑ́ too mǝ fɛɛlɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Nyɩ sɩ ye Tɑfiiti wɛnɑ ɩ weesuɣu, ɑsolɑ tɑɑ kɛ́ nyɑ́ nɑ nyɑ́ kɑwulɑɣɑ ɩ́ wɛɛ. Mpʋ tɔ, tili nɑ pɑ́ kɔnɑ-mɩ-ɩ, pǝ wɛɛ sɩ ɩ́ sɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Mpʋɣʋlɛ Sonɑtɑŋ pɔɔsɑ ɩ cɑɑ sɩ: Ɩ lɑpɑ we nɑ pɑ́ kʋɣʋ-ɩ? ");
INSERT INTO dop_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Ɩlɛnɑ Sɑyuli lɔɣɔ Sonɑtɑŋ kɛ ŋmɑntɑɑɣɑ. Tǝnɑɣɑlɛ Sonɑtɑŋ cɛkǝnɑɑ sɩ ɩ cɑɑ tɛmɑ ɩ tɑɑ sɩ ɩ kʋɣɩ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Ḿpʋ́ɣʋ́ ɩ yelɑ tɔɣɔʋ kɛ ɩsɔtʋ kʋfɑlʋ kʋyɑkʋ nɑɑlɛ nyǝŋkʋ ŋkʋ nɑ ɩ́ kʋlǝnɑ pɑ́ɑ́nɑ́. Mpi tɔ, ɩ lɑŋlɛ wɑkǝlǝnɑ Tɑfiiti kɛ sɔsɔm kɛ mpi pǝ tɔɔ ɩ cɑɑ tʋʋ-ɩ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Tɛʋ femɑ tɑnɑŋ, ɩlɛnɑ Sonɑtɑŋ nɑ ɩwɑɑsǝlɛ nɑtǝlɩ pɑ́ polo timpi ɩ nɑ Tɑfiiti pɑɑ yɔɣɔtɑɑ nɑ pɑ sɩɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Ɩlɛnɑ ɩ́ heeli ɩwɑɑsǝlɛ sɩ: Polo nɑ ń tɔɔsɩ nyǝmɑ́ nnɑ mɑɑ tɔ́ tɔ. Ɩwɑɑsǝlɛ tɛɛwɑ, ɩlɛnɑ Sonɑtɑŋ tɔ nyǝmɑ́ kɛ tǝ nɔɣɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Ɩwɑɑsǝlɛ tɔmɑ ɩsɩɩ tǝ tɑkɩ nyǝmlɛ cɔlɔ, ɩlɛnɑ Sonɑtɑŋ kpɛɛsɩ-tɛ sɩ: Ɩsɩɩ hɑtoo nyɑ́ nɔɣɔ tɔɔ kɛ́ nyǝmlɛ wɛɛ? ");
INSERT INTO dop_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Lɑ lɔŋ tɑɑ sǝŋ. Ḿpʋ́ɣʋ́ ɩwɑɑsǝlɛ tɔɔsɑ nyǝmɑ́ nɑ tǝ́ kɔnɑ. ");
INSERT INTO dop_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Sonɑtɑŋ nɑ Tɑfiiti pɑ nɑɑlɛ pɑ nyǝmnɑ mpi pǝ lɑkɩ tɔ, ɩwɑɑsǝlɛ nɑ́ tɑ́ nyɩ. ");
INSERT INTO dop_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Ɩlɛnɑ Sonɑtɑŋ cɛlɑ ɩwɑɑsǝlɛ kɛ ɩ yoou wontu sɩ tǝ́ kpeenɑ. ");
INSERT INTO dop_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Ɩwɑɑsǝlɛ tɛɛwɑ, ɩlɛnɑ Tɑfiiti lɩɩ ɩ tǝŋmɛllɛ kɛ kɑŋmɑɑɣɑ wɑɑlɩ, nɑ ɩ́ hǝntɩ Sonɑtɑŋ kɛ ɑtɛɣɛ tɔm tooso. Ḿpʋ́ɣʋ́ pɑ kpipɑ tǝmɑ nɑ pɑ́ wii tǝkpoo, nɑ Tɑfiiti wulɑ wɔ. ");
INSERT INTO dop_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Ɩlɛnɑ Sonɑtɑŋ tɔmɩ-ɩ sɩ: Polo, Ɩsɔ ɩ́ wɛɛ nyɑ́ wɑɑlɩ. Ɩlɛnɑ ɩ́ yele nɑ mɑ́ nɑ-ŋ nɑ tɑ lʋlʋɣʋ nyǝ́mɑ tǝ́ tɔkɩ nɔɣɔ ŋkɑ tǝ́ sɩɩwɑ tɔɣɔ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti kʋlɑɑ nɑ ɩ́ tɛɛ nɑ Sonɑtɑŋ nɑ́ɑ́ mǝlɩ ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Ḿpʋ́ɣʋ́ Tɑfiiti polɑ Nopɩ kɛ kɔtʋlʋ Ahimelɛkɩ tɛ. Ɩ́lɛ́ ɩ loosɑ-ɩ, ɩlɛnɑ ɩ́ kpɑɣɑ ɑsewɑ nɑ sɔɣɔntʋ nɑ ɩ́ sǝŋɩ-ɩ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Alɑɑfǝyɑ kɛlɛ nɑ ń tɔ nyɑ́ tike kɛ mpʋ, nɑ nɔɣɔlʋ fɛɩ nyɑ́ wɑɑlɩ? ");
INSERT INTO dop_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Ntɛnɑ Tɑfiiti sɩ: Wulɑʋ kʋsǝnɑ-m nɑ tɔm kʋŋmɛsǝtʋ nɑtǝlɩ. Ye pǝ kɑɑsɑ mɑ yǝlɑɑ ɩlɛ, mɑ́ nɑ pɛlɛ tǝ nyǝmɑ́ tɑ́ suluɣu wɑɑtʋ. ");
INSERT INTO dop_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Kʋtɔtɔɣɔm nɑpǝlɩ pǝ fɛɩ? Hɑ-m potopotonɑɑ kɑkpɑsɩ, yɑɑ tɔɣɔnɑɣɑ ŋkɑ n wɛnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Ntɛnɑ kɔtʋlʋ sɩ: Mɑ fɛɩnɑ potopotonɑɑ nɑpǝlǝɣɩ yem. Ɩsɔ nyǝ́mɑ wɛnnɑ. Ye nyɑ́ yǝlɑɑ ɩ tɑ tokinɑ ɑlɑɑ, ɩlɛ mɑ cɛlɛ-ŋ pɛlɛ. ");
INSERT INTO dop_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Ntɛnɑ Tɑfiiti nɔɣɔ tǝkpɑʋ sɩ: Pɑɑ tǝ lɩɩkɩ tɑ lɩɩʋ mɑ yǝlɑɑ wɛ tǝnɑŋŋ kɛ́. Hɑlɩ sɑŋɑ tɑ́ lɩɩʋ pǝnɛ pǝ tɑ kɛ sǝkpem ɩsǝntɔ tɔ pǝ tɛɛsɑɑ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Ɩlɛnɑ kɔtʋlʋ hɑ Tɑfiiti kɛ potopotonɑɑ. Mpi tɔ, pɑ tike pɑ wɛnnɑ nɑ mpɛɣɛ pɑ lǝsɑɑ sɩ pɑ lɑɣɑsǝɣɩ kʋfɑmɑ. ");
INSERT INTO dop_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Pǝ pɑmnɑ Sɑyuli tiikilɑɑ nyʋɣʋ tʋ nɔɣɔlʋ ɩ kɑ wɛ tǝnɑ. Pɑ yɑɑkɩ ɑpɑlʋ ɩnɩ sɩ Towɛkɩ. Ɩ kɛ́ Ɩtɔm tʋ, nɑ pɑ tǝkɑ ɩ tɔɔ sɩ ɩ́ lɑ Ɩsɔ sɛɛʋ kɔtɑɣɑ nɑkǝlɩ. ");
INSERT INTO dop_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Ḿpʋ́ɣʋ́ Tɑfiiti pɔɔsɑ Ahimelɛkɩ sɩ n wɛnɑ ŋmɑntɑɑɣɑ yɑɑ lɑɣɑtɛ nɑ ń cɛlɛ-m? Mpi tɔ, wulɑʋ tilitu tɔm kpɛtǝlɑ-m, ɩlɛ mɑ tɑ kpɑɣɑ lɑɣɑtɛ yɑɑ yoou wontuɣu nɑkʋlɩ. ");
INSERT INTO dop_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Ntɛnɑ kɔtʋlʋ sɩ: Filiisi tʋ Koliyɑtɩ wei n kʋwɑ Ɩlɑ tɛtɛkǝlɛ tɑɑ tɔ, ɩ lɑɣɑtɛ kɛ pɑ mɛɛlɑ sɑɑlɑɣɑ, nɑ pɑ́ sɩɩ kɔtʋlʋ toko wɑɑlɩ. Ye n cɑɑ n kpɑɣɑ-tɛ, tǝ tike tǝ wɛnɑ cǝnɛ. Ntɛnɑ Tɑfiiti sɩ: Cɛlɛ-m-tɛ tǝ fɛɩnɑ sɑɑlɑ. ");
INSERT INTO dop_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Ḿpʋ́ɣʋ́ Tɑfiiti tɑɣɑnɑ sewɑ kɛ kʋyɑkʋ ŋkʋ, nɑ ɩ́ polo wulɑʋ Akisi tɛɣɛ Kɑtɩ. ");
INSERT INTO dop_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Ntɛnɑ Akisi wɑɑlɩ nyǝ́mɑ tɔ sɩ: Ɩsɩɩ tɛtʋ wulɑʋ Tɑfiiti kɛlɛ ɩnɛ ɩnɩ? Pǝ tɑɣɑ ɩ nɑ Sɑyuli kɛ pɑ tʋnɑ yontu nɑ pɑ́ pɑɑkɩ sɩ: Sɑyuli kʋwɑ yǝlɑɑ iyɑɣɑ (1000) kɛ huɣule, nɑ Tɑfiiti nɑ́ɑ́ kʋ iyisi nɑɑnʋwɑ (10000) kɛ huɣule. ");
INSERT INTO dop_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Tɑfiiti mɑɣɑsɑ tɔm ntǝɣɩ ɩ tɑɑ. Ɩlɛnɑ wulɑʋ Akisi tɔm lɑpɩ-ɩ sɔɣɔntʋ kɛ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Ḿpʋ́ɣʋ́ ɩ pǝsɑ ɩsɩɩ kpɑŋtʋ, nɑ ɩ́ lɑkɩ yem yem kɛ́ pɑ ɩsɛntɑɑ, nɑ ɩ́ ŋmɑɑkɩ kɑmpʋnɑɑ tɔɔ nɑ ɩ́ yele nɑ ɩ ntɑɣɑmɑ kpeŋ ɩ tɑntʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Kɛlɛnɑ Akisi tɔ ɩ wɑɑlɩ nyǝ́mɑ sɩ: Ɩ́ nɑwɑɣɑ sɩ pǝ lɑkɩ yʋlʋ ɩnǝɣɩ yɛlɛyɛlɛ. Ɩlɛ pepe tɔɔ kɛ́ ɩ́ kpɑɣɑ-ɩ nɑ ɩ́ kɔŋnɑ-m? ");
INSERT INTO dop_vpl VALUES ("S121_16","010_21_16","1SA","21","16","16","Ɩsɩɩ mɑ lɑŋɑ kpɑŋtʋnɑɑ ntɛ́ nɑ ɩ́ kɔŋnɑ-m ɩnɛ ɩnɩ sɩ ɩ́ lɑkɩ yem yem nɑ mɑ́ nɑɑkɩ-ɩ? Ɩ tɑ mʋnɑ ɩ́ sʋʋ mɑ tǝyɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti sewɑ Kɑtɩ, nɑ ɩ́ polo nɑ ɩ́ ŋmɛlɩ Atulɑm kʋkpɑmʋɣʋ pʋ́ʋ́ɣʋ́ tɑɑ. Mpʋɣʋlɛ ɩ tɛɛtʋnɑɑ nɑ ɩ tǝyɑɣɑ yǝlɑɑ tǝnɑ nɩɩwɑ. Ɩlɛnɑ pɑ́ polo ɩ kiŋ. ");
INSERT INTO dop_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Pǝ kpɑɣɑʋ mpɑ pɑ lɑŋɑ wɑkǝlɑɑ tɔ, nɑ kǝmɑ nyǝ́mɑ, nɑ nǝɣǝsɛɛ nyǝ́mɑ, pɑ kotinɑ ɩ kiŋ, ɩsɩɩ yǝlɑɑ nɑsǝlɛ (400) kɛ mpʋ, nɑ ɩ́ pǝsɩ pɑ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Tǝnɑɣɑ Tɑfiiti lɩɩwɑ nɑ ɩ́ polo Misipɑ kɛ Mowɑpʋ tɛtʋ tɑɑ, nɑ ɩ́ sǝlǝmɩ tǝnɑ wulɑʋ sɩ: Yele nɑ mɑ cɑɑ nɑ mɑ too pɑ́ kɔɔ nɑ pɑ́ cɔɔsɩ nyɑ́ tɛ. Hɑlǝnɑ mɑ́ cɛkǝnɑ mpi Tɑcɑɑ kɑ́ lɑ-m tɔ. ");
INSERT INTO dop_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Ḿpʋ́ɣʋ́ Tɑfiiti ponɑ ɩ nyǝ́mɑ mpɛɣɛ Mowɑpʋ wulɑʋ kiŋ. Ɩlɛnɑ pɑ́ cɑɣɑ tǝnɑɣɑ wɑɑtʋ wei ɩnɩ ɩ tɔŋnɑ cɔɔsʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Ḿpʋ́ɣʋ́ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Kɑtɩ heelɑ Tɑfiiti sɩ: Lɩɩ tǝcɔɔsǝlɛ tǝnɑ nɑ ń polo Yutɑ tɛtʋ tɑɑ. Ɩlɛnɑ ɩ́ se nɑ ɩ́ polo Hɛlɛtɩ hɔtʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Sɑyuli cɑɣɑ Kipeyɑ tontoŋle tɔɔ kɛ́ tʋɣʋ nɑkʋlɩ kʋ tɛɛ. Ɩ ŋmɑntɑɑɣɑ kɛ ɩ niŋ tɑɑ, nɑ ɩ wɑɑlɩ nyǝ́mɑ tǝnɑɣɑ ɩ kiŋ. ");
INSERT INTO dop_vpl VALUES ("S122_7","010_22_7","1SA","22","7","7","Tǝnɑɣɑ ɩ tɔmɑ-wɛ sɩ: Ntɔŋ Pɛncɑmɛɛ nyǝ́mɑ mɛ, ɩ́ tɛŋ mǝ tɑɑ sɩ Sesee pǝyɑlʋ Tɑfiiti kɑ́ hɑ mǝ tǝnɑɣɑ tɩɩŋ tɑwɑ, nɑ ɩ́ kpɑ mǝ tǝnɑɣɑ nyʋɣʋ nyǝ́mɑ yɛɛ? ");
INSERT INTO dop_vpl VALUES ("S122_8","010_22_8","1SA","22","8","8","Ye pǝ tɑɣɑ mpʋ, pepe tɔɔ kɛ́ mǝ tǝnɑ tǝpɑɩ ɩ́ kpɛntɑ nɔɣɔ kɛ mɑ tɔɔ. Mǝ tɑɑ nɔɣɔlʋ ɩɩ tɩɩ cǝkɩ-m sǝkpɑlʋɣʋ kɛ mɑ pǝyɑlʋ nɑ Tɑfiiti pɑ nɔɣɔ pɛɛlʋɣʋ tɔm? Pepe tɔɔ kɛ́ mǝ tɑɑ nɔɣɔlʋ kɑɑ tɩɩ tɔɣɔ mɑ wɑhɑlɑ. Nɑ ɩ́ kɛɛsɩ-m ɩsǝnɑ mɑ pǝyɑlʋ yoosiɣi mɑ nɑ mɑ tǝmlɛ tʋ tɔ. Hɑlɩ ɩ́lɛ́ ɩ́ nyǝkɩ-m kɑtɔsɩ ɩsɩɩ ɩ tɔŋnɑ lɑpʋ kɛ hɑlǝnɑ sɑŋɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Pǝ pɑmnɑ Towɛkɩ Ɩtɔm tʋ kɑ wɛ Sɑyuli wɑɑlɩ nyǝ́mɑ tɑɑ. Mpʋɣʋlɛ ɩ cɔwɑ sɩ: Mɑ nɑwɑ Tɑfiiti polɑ Nopɩ kɛ Ahitupi pǝyɑlʋ Ahimelɛkɩ kiŋ. ");
INSERT INTO dop_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Hɑlɩ ɩ́lɛ́ ɩ pɔɔsɩ Tɑcɑɑ sɩ, pepeɣe Tɑfiiti kɑ́ lɑ. Nɑ Ahimelɛkɩ hɑ Tɑfiiti kɛ tɔɣɔnɑɣɑ nɑ ɩ́ cɛlɛ-ɩ Koliyɑtɩ lɑɣɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Ḿpʋ́ɣʋ́ Sɑyuli tilɑ Nopɩ nɑ pɑ́ yɑɑ kɔtʋlʋ Ahimelɛkɩ, nɑ ɩ tǝyɑɣɑ kɔtǝlɑɑ tǝnɑ nɑ pɑ́ polo. ");
INSERT INTO dop_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Ɩlɛnɑ ɩ́ tɔ Ahimelɛkɩ sɩ: Ke ŋkpɑŋŋ. Nɑ ɩ́lɛ́ ɩ tɔ sɩ: Mɑ nɩɩwɑ, tɑ cɑɑ. ");
INSERT INTO dop_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Ḿpʋ́ɣʋ́ ɩ tɔmɑ sɩ: Pepe tɔɔ kɛ́ nyɑ́ nɑ Tɑfiiti ɩ́ kpɛntɑ nɔɣɔ kɛ mɑ tɔɔ? Hɑlǝnɑ ń hɑ-ɩ tɔɣɔnɑɣɑ, nɑ lɑɣɑtɛ. Nɑ ń yɔɣɔtǝnɑ Tɑcɑɑ kɛ ɩ tɔm, nɑ ɩ́ kʋlɩ mɑ tɔɔ nɑ ɩ́ nyǝkɩ-m kɑtɔsɩ, ɩsɩɩ ɩ́ tɔŋnɑ lɑpʋ kɛ sɑŋɑ ɩsǝntɔ tɔ? ");
INSERT INTO dop_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Ntɛnɑ kɔtʋlʋ cɔ sɩ: Nyɑ́ wɑɑlɩ nyǝ́mɑ tɑɑ ɑwe kɑ́ kɛɛsǝnɑ ɩ tǝɣɩ nyɑ́ yǝtɩ Tɑfiiti. Ɩ nɩɩkǝnɑ-ŋ nɑ ɩ nyʋɣʋ kʋlɑ nyɑ́ tǝyɑɣɑ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Pǝ tɑɣɑ sɑŋɑ kɛ mɑ cɑɑlɑ Tɑcɑɑ kɛ yɔɣɔtǝnɑʋ kɛ ɩ tɔm. Ye mɑ nɑ-ɩ tɑ́ nɔɣɔ pɛɛlʋɣʋ tɔm, tɑɑ sʋkɩ tǝlɛɣɛ mɑ́ nɑ mɑ tǝyɑɣɑ nyǝ́mɑ tɑ́ tɑɑ nɔɣɔlʋ ɩ nyʋɣʋ tɑɑ. Mɑ tɑ nyɩ-tǝɣɩ pɑɑ pǝcɔ. ");
INSERT INTO dop_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Ḿpʋ́ɣʋ́ Sɑyuli tɔmɑ Ahimelɛkɩ sɩ: Ɩsɩɩ mɑ kʋwɑ nyɑ́ nɑ nyɑ́ cɑɑ tǝyɑɣɑ nyǝ́mɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Ɩlɛnɑ Sɑyuli tɔ ɩ yoolɑɑ mpɑ pɑɑ sǝŋɑ ɩ kiŋ tɔ sɩ: Ɩ́ kʋ Tɑcɑɑ kɔtǝlɑɑ. Mpi tɔ, pɑ nyǝ́mɑ teu sɩ Tɑfiiti seekɑɣɑ kɛ́. Ɩlɛnɑ pɑ́ nɑ-ɩ pɑ́ lɑ́ nɔɣɔ kʋlʋmɑɣɑ nɑ pɑ́ kisi-m heeluɣu. Amɑ pɛlɛ pɑ kisɑ Tɑcɑɑ kɔtǝlɑɑ kɛ kʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Ntɛnɑ Sɑyuli tɔ Towɛkɩ Ɩtɔm tʋ sɩ: Nyɑɑ kʋ-wɛ. Ɩlɛnɑ Towɛkɩ kʋ kɔtǝlɑɑ mpɛ pɑ nɩɩnɑɑsɑ nɑ kɑkpɑsɩ, nɑ pɑ́ suuwɑ kɔtɑɣɑ wontu. ");
INSERT INTO dop_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Ḿpʋ́ɣʋ́ Sɑyuli kʋwɑ tɔtɔɣɔ Nopɩ ɩcɑtɛ yǝlɑɑ tǝnɑ. Pǝ kpɑɣɑʋ ɑpɑlɑɑ, nɑ ɑlɑɑ, nɑ piyɑ tǝnɑ, nɑ ɑhʋlʋmnɑɑ nɑ tɔlɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Amɑ Ahitupi pǝyɑlʋ Ahimelɛkɩ pǝyɑlʋ Apiyɑtɑɑ ŋmɛlɑɑ nɑ ɩ́ se nɑ ɩ́ polo Tɑfiiti kiŋ. ");
INSERT INTO dop_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Ḿpʋ́ɣʋ́ ɩ tɑɣɑsɑ-ɩ sɩ: Sɑyuli kʋwɑ Tɑcɑɑ kɔtǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Ḿpʋ́ɣʋ́ Tɑfiiti tɔmɑ sɩ: Kʋyɑŋku mɑ nɑwɑ Towɛkɩ kɛ tǝnɑ tɔ, mɑɑ nyǝmɑ mpʋ sɩ ɩ kɑɑ lɑŋ Sɑyuli kɛ tɑɣɑsʋɣʋ. Mɑ́ yelinɑ ntɛɣɛ pɑ kʋ nyɑ́ cɑɑ tǝyɑɣɑ nyǝ́mɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Cɑɣɑ mɑ kiŋ cǝnɛ, tɑɑ nyɑ́. Ye wei ɩ pɛɛkǝɣɩ nyɑ́ weesuɣu pǝ wɛ ɩsɩɩ mɑ nyǝŋkʋ kɛ pʋntʋ pɛɛkǝɣɩ, mɑɑ pɑɑsǝnɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Ḿpʋ́ɣʋ́ pɑ tɑɣɑsɑ Tɑfiiti sɩ: Filiisi nyǝ́mɑ yoonɑ Keilɑ nyǝ́mɑ nɑ pɑ́ kuu tɔɣɔnɑɣɑ kɛ kpeeŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Mpʋɣʋlɛ Tɑfiiti sǝlǝmɑ Tɑcɑɑ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Pǝ wɛɛ sɩ mɑ́ polo mɑ́ yoonɑ Filiisi nyǝ́mɑ mpɛ? Ntɛnɑ Tɑcɑɑ sɩ: Ɛɛ, polo nɑ ń yoonɑ-wɛ, nɑ ń wɑɑsɩ Keilɑ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Mpʋɣʋlɛ Tɑfiiti yǝlɑɑ pɔɔsɑ-ɩ sɩ: Yutɑ cǝnɛɣɛlɛ tǝ wɛɛ tǝ tɑ kisi cɑɣɑʋ nɑ sɔɣɔntʋ. Hɑlɩ ḿpʋ́ɣʋ́ tɩɩ puki Keilɑ kɛ Filiisi nyǝ́mɑ suluɣu nɑ? ");
INSERT INTO dop_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Tɑfiiti tɑsɑ Tɑcɑɑ kɛ yɔɣɔtǝnɑʋ, ɩlɛnɑ Tɑcɑɑ cɔ sɩ: Kʋlɩ nɑ ń tɛɛ Keilɑ. Mpi tɔ, mɑ tʋ Filiisi nyǝ́mɑ kɛ nyɑ́ niŋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Ḿpʋ́ɣʋ́ ɩ kpɑɣɑ ɩ yǝlɑɑ nɑ ɩ́ polo Keilɑ nɑ ɩ́ yoonɑ Filiisi nyǝ́mɑ. Ɩ kʋ-wɛɣɛ sɔsɔm nɑ ɩ́ kǝlɩ-wɛ, nɑ ɩ́ lɛɛkɩ pɑ tɔlɑ. Pǝ lɑpɑ Tɑfiiti wɑɑsɑ-wɛɣɛlɛ. ");
INSERT INTO dop_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","Pǝ́cɔ́ wɑɑtʋ wei Ahimelɛkɩ pǝyɑlʋ Apiyɑtɑɑ kɑ sewɑ nɑ ɩ́ mɑɣɑnɑ Tɑfiiti tɔ, nɑ ɩ́ tɔkɑ kɔtǝlɑɑ toko wei pɑ pɔɔsǝɣǝnɑ Tɑcɑɑ kɛ tɔm tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Sɑyuli nɩɩwɑ sɩ Tɑfiiti polɑ Keilɑ, ɩlɛnɑ ɩ́ tɔ sɩ: Ɩsɔ cɑɑ ɩ tʋ-ɩ mɑ niŋ tɑɑ kɛ́. Mpi tɔ, ɩ kɔmɑ nɑ ɩ́ tǝkɩ ɩ tǝɣɩ ɩcɑtɛ nte tǝ wɛnɑ koluŋɑ nɑ kɑmpʋnɑɑ nɑ kʋkɑlǝsǝŋ kʋpɑŋ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Ntɛnɑ Sɑyuli koti ɩ yoolɑɑ tǝnɑ nɑ pɑ́ polo Keilɑ sɩ pɑ nyɑlɑ Tɑfiiti nɑ ɩ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Tɑfiiti nɩɩ ɩsɑɣɑtʋ nti Sɑyuli tɔŋnɑ mɑɣɑsʋɣʋ kɛ ɩ tɑɑ kɛ́ mpʋ, ɩlɛnɑ ɩ́ tɔ kɔtʋlʋ Apiyɑtɑɑ sɩ: Kɔnɑ toko wei pɑ pɔɔsǝɣǝnɑ Tɑcɑɑ kɛ tɔm tɔ. ");
INSERT INTO dop_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Ɩlɛnɑ Tɑfiiti sǝlǝmɩ Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Mɑ nɩɩwɑ sɩ Sɑyuli kɔŋ ɩcɑtɛ yɔkʋɣʋ kɛ mɑ mɑɣɑmɑɣɑ mɑ nyʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S123_11","010_23_11","1SA","23","11","11","Ɩ kɑ́ kɔɔ tɑmpɑnɑ ɩsɩɩ mɑ nɩɩʋ tɔ? Ye ɩ kɔmɑ Keilɑ nyǝ́mɑ kɑ́ tʋ-m ɩ niŋ tɑɑ? Hɑɩ, Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ, lɑ suulu nɑ ń heeli-m. Ntɛnɑ Tɑcɑɑ sɩ: Ɛɛ, ɩ kɑ́ kɔɔ. ");
INSERT INTO dop_vpl VALUES ("S123_12","010_23_12","1SA","23","12","12","Ɩlɛnɑ Tɑfiiti sɩ: Ɩlɛ Keilɑ nyǝ́mɑ kɑ́ tʋ mɑ nɑ mɑ yǝlɑɑ kɛ ɩ niŋ tɑɑ? Tɑcɑɑ sɩ: Ɛɛ, pɑɑ tʋ-mɛ. ");
INSERT INTO dop_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Ḿpʋ́ɣʋ́ Tɑfiiti nɑ ɩ yǝlɑɑ pɑ lɩɩ Keilɑ kɛ kpɑkpɑɑ nɑ pɑ́ tɛɛ tiili. Pɑ wɛ ɩsɩɩ yʋlʋnyɔɔŋ nɑsǝtoso (600) kɛ mpʋ. Sɑyuli nɩɩwɑ sɩ Tɑfiiti sewɑ, ɩlɛ ɩ tɑ tɑsɑ pote tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Ɩlɛnɑ Tɑfiiti sɑɑlɩ pʋɣʋ tɑɑ kɛ́ kʋkpɑmʋɣʋ pʋ́ʋ́ɣʋ́ tɑɑ nɑ Sifɩ wʋlɑɣɑ tɛtʋ tɔɔ. Sɑyuli pɛɛkɑɣɑ-ɩ tɑm kɛ́. Amɑ Ɩsɔ tɑ tʋ-ɩ ɩ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Ḿpʋ́ɣʋ́ Tɑfiiti nɑwɑ sɩ Sɑyuli pɛɛkǝɣɩ sɩ ɩ́ kʋ-ɩ. Ɩlɛnɑ ɩ́ sɑɑlɩ Sifɩ wʋlɑɣɑ tɛtʋ hɔtʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S123_16","010_23_16","1SA","23","16","17","Wɑɑtʋ ɩnǝɣɩ Sonɑtɑŋ polɑ Tɑfiiti kiŋ kɛ tǝnɑ nɑ ɩ́ sɔɔsɩ-ɩ ɑpɑlʋtʋ sɩ: Tɑɑ nyɑnɑ pʋlʋ, Ɩsɔ wɛ nyɑ́ wɑɑlɩ, nɑ mɑ cɑɑ kɑɑ tokinɑ-ŋ. Ɩ nyǝmɑ́ teu tɔtɔ sɩ nyɑɑ tɔɣɔnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ kɛ́ kɑwulɑɣɑ, nɑ mɑɣɑlɛ nyɑ́ wɑɑlɩ nyǝŋ. ");
INSERT INTO dop_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Ɩlɛnɑ pɑ nɑɑlɛ pɑ́ kpɛntɩ nɑ pɑ́ pɛɛlɩ nɔɣɔ kɛ Tɑcɑɑ ɩsɛntɑɑ. Ḿpʋ́ɣʋ́ Tɑfiiti sɑɑlɑ hɔtʋɣʋ tɑɑ, nɑ Sonɑtɑŋ nɑ́ɑ́ kpe ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Mpʋɣʋlɛ Sifɩ nyǝ́mɑ polɑ Sɑyuli kiŋ kɛ Kipeyɑ nɑ pɑ́ heeli-ɩ sɩ: Tɑfiiti ŋmɛlɑ tɑ tɛɣɛ Hɑkilɑ pʋɣʋ hɔtʋɣʋ tɑɑ, kɛ́ kʋkpɑmǝŋ tɑɑ kɛ́ wʋlɑɣɑ tɛtʋ ilim mpǝtǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Tǝ nyǝmɑ́ sɩ n cɑɑ n kpɑ-ɩ. Mpʋ tɔ, kɔɔ tǝ́ kpɑ-ɩ nɑ tǝ́ cɛlɛ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Tǝnɑɣɑlɛ Sɑyuli tɔmɑ sɩ: Timpi ɩ́ wɛnɑ mɑ pǝtɔɔtǝlɛ kɛ ɩsǝntɔ tɔ, Tɑcɑɑ ɩ́ kooli-mɛɣɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","Mpʋ tɔ, ɩ́ polo nɑ ɩ́ tɑsɑ pɛɛkʋɣʋ kɛ timpi ɩ wɛɛ tɔ, nɑ wei ɩ mɑɣɑmɑɣɑ ɩ nɑ-ɩ tɔ. Mpi tɔ, pɑ heelɑ-m sɩ ɩ ɑcilɑɣɑtʋ wɛ sɔɣɔntʋ. ");
INSERT INTO dop_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","Ɩ́ pɛɛkɩ teu nɑ ɩ́ cɛkǝnɑ lonɑ nnɑ nnɑ ɑ tɑɑ ɩ ŋmɛlǝɣɩ tɔ. Ɩ́ wɛɛnɑ nɑɑni, ɩlɛnɑ ɩ́ kɔɔ nɑ mɑ́ nɑ-mɛ tǝ́ polo. Ye tɛtʋ tɑɑ cǝnɛɣɛ ɩ wɛɛ, mɑɑ pɛɛkɩ Yutɑ nyǝ́mɑ tǝnɑ tɑɑ nɑ mɑ́ nɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Ɩlɛnɑ pɑ́ tɛɛ Sɑyuli kɛ nɔɣɔ nɑ pɑ́ polo Sifɩ. Amɑ Tɑfiiti nɑ ɩ́lɛ́ ɩ nyǝ́mɑ pɑ wɛ Mɑwɔŋ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́ tɛtɛkǝlɛ tɑɑ kɛ́ Yutɑ wʋlɑɣɑ tɛtʋ ilim mpǝtǝŋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Ḿpʋ́ɣʋ́ Sɑyuli nɑ ɩ yǝlɑɑ pɑ polɑ Tɑfiiti pɛɛkʋɣʋ. Ɩlɛnɑ nɔɣɔlʋ tɑɣɑsɩ-tǝɣɩ Tɑfiiti nɑ ɩ́ tii pʋɣʋ nɑ ɩ́ polo ɩ́ cɑɣɑ Mɑwɔŋ wʋlɑɣɑ tɛtʋ tɑɑ. Sɑyuli nɩɩ mpʋ, ɩlɛnɑ ɩ́ tǝŋ ɩ wɑɑlɩ kɛ́ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Nɑ ɩ́ nɑ ɩ nyǝ́mɑ pɑ wɛ pʋɣʋ hɔɣɔlʋɣʋ tɔɔ, nɑ Tɑfiiti nɑ ɩ nyǝ́mɑ nɑ lɛŋkʋ tɔɔ. Ḿpʋ́ɣʋ́ pɑ sewɑ kpɑkpɑɑ sɩ pɑ fitiɣi Sɑyuli. Amɑ ɩ́lɛ́ nɑ ɩ yǝlɑɑ pɑɑ tɛmɑ Tɑfiiti-wɛɣɛlɛ tɑm sɩ pɑ kpɑɑkɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","Tǝnɑɣɑ tillu kɔmɑ nɑ ɩ́ heeli Sɑyuli sɩ: Kɔɔ lɔŋ, Filiisi nyǝ́mɑ wɑtɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Ntɛnɑ ɩ́ mǝlɩ Filiisi nyǝ́mɑ wɑɑlɩ. Pǝ tɔɔ kɛ́ pɑ hɑ tǝnɑɣɑ hǝtɛ sɩ pɑ yɑ tǝmɑ kʋkpɑmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti kʋlɑ tǝnɑ nɑ ɩ́ polo Aŋ-Ketii kʋkpɑmʋɣʋ pʋ́ʋ́ɣʋ́ tɑɑ nɑ ɩ́ cɑɣɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Sɑyuli lɩɩnɑ Filiisi nyǝ́mɑ tǝtɔɣɔnlɛ, ɩlɛnɑ pɑ́ tɑɣɑsɩ-ɩ sɩ Tɑfiiti wɛ Aŋ-Ketii wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Ḿpʋ́ɣʋ́ Sɑyuli tɔɔsɑ yoolɑɑ tɑɑ yoolɑɑ kɛ iyisi tooso (3000) kɛ Ɩsɛɣɛlɩ tɛtʋ tǝnɑ tɑɑ, nɑ ɩ́ polo Tɑfiiti pɛɛkʋɣʋ. Hɑlǝnɑ ɩ́ tɑlɑ tɑɑlɛ pǝŋtʋlʋŋ kʋkpɑmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Ḿpʋ́ɣʋ́ pɑ tɑlɑ heeŋ tǝtǝkǝlɛ nte tǝ wɛ mpɑɑʋ nɔɣɔ tɔ. Kʋkpɑmʋɣʋ pʋ́ʋ́ɣʋ́ nɑkʋlɩ kɩɩ wɛ tǝnɑ. Ntɛnɑ Sɑyuli sʋʋ kʋ tɑɑ sɩ ɩ lɩɩkɩ hǝm, nɑ Tɑfiiti nɑ ɩ yǝlɑɑ pɑ ŋmɛlɑ lɔlɔ kɛ pʋ́ʋ́ɣʋ́ kʋlʋmʋɣʋ ŋkʋ kʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Tǝnɑɣɑlɛ Tɑfiiti yǝlɑɑ wɛlǝtɑ-ɩ sɩ: Nyʋleleŋ ntɛ́ yɑɑ, Tɑcɑɑ kɑ tɛmɑ-ŋ heeluɣu sɩ ɩ kɑ́ tʋ nyɑ́ kolontunɑɑ kɛ nyɑ́ niŋ tɑɑ. Tɔʋ, lɑnɑ-ɩ ɩsǝnɑ n cɑɑ tɔ. Ɩlɛnɑ Tɑfiiti kʋlɩ tǝhɛɛ nɑ ɩ́ cooli Sɑyuli cɑpɑ ntompǝle. ");
INSERT INTO dop_vpl VALUES ("S124_6","010_24_6","1SA","24","6","6","Ḿpʋ́ɣʋ́ ɩ lɑŋlɛ ŋmɑɑwɑ mpi pǝ tɔɔ ɩ lɑpɑ mpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S124_7","010_24_7","1SA","24","7","7","Ɩlɛnɑ Tɑfiiti tɔ ɩ yǝlɑɑ sɩ: Ɩsɔ ɩ́ tɑɑ yele nɑ mɑ́ tokinɑ mɑ sɔsɔ. Mpi tɔ, Tɑcɑɑ lǝsǝnɑ-ɩ nɑ ɩ́ kpɑ-ɩ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Tɔm ntǝɣɩ Tɑfiiti tɑŋnɑ ɩ yǝlɑɑ sɩ pɑ́ tɑɑ kʋ Sɑyuli. Pǝ wɑɑlɩ kɛ́ Sɑyuli lɩɩwɑ nɑ ɩ́ tʋ ɩ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Ḿpʋ́ɣʋ́ Tɑfiiti pɛlɛ pɑ lɩɩwɑ tɔtɔ, nɑ pɑ́ kpɛɛsɩ Sɑyuli sɩ: Hɑɩ, mɑ cɑɑ wulɑʋ. Sɑyuli pǝsɑ ɩ wɑɑlɩ, ɩlɛnɑ Tɑfiiti hǝntɩ-ɩ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Pepe tɔɔ kɛ́ n nɩɩkɩ nti yǝlɑɑ looliɣi sɩ mɑ cɑɑkɩ nyɑ́ wɑkǝlʋɣʋ tɔ ye? ");
INSERT INTO dop_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","Pǝ tɑɣɑ mpʋ se. Mpi tɔ, sɑŋɑ n nɑnɑ nyɑ́ ɩsǝpǝle ntɛ́ ɩsǝnɑ Tɑcɑɑ tʋ-ŋ mɑ niŋ tɑɑ tɔ. Yǝlɑɑ sɔsɑ-m sɩ mɑ́ kʋ-ŋ. Amɑ mɑ́ kisinɑ sɩ pǝ fɛɩ sɩ mɑ́ tʋ mɑ sɔsɔ tɔɔ kɛ́ niŋ. Mpi tɔ, Tɑcɑɑ lǝsǝnɑ-ŋ nɑ ɩ́ kpɑ-ŋ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","Tɔʋ, mɑ cɑɑ, nn nɑɑkɩ nyɑ́ toko ntompǝle ntɛ́ mɑ niŋ tɑɑ, ye mɑɑ nɔkɑɑ mɑɑ kʋ-ŋ. Amɑ timpi mɑ coolɑ nyɑ́ toko tike nɑ mɑ́ tɑ́ kʋ-ŋ tɔ, nyɩ sɩ mɑ tɑɑ ɩɩ kpɑɑkǝnɑ-ŋ. Pǝyele mɑ tɑ sɔɔlǝnɑ-ŋ ɩsɑɣɑtʋ. Amɑ nyɑ́ nyǝkǝnɑ-m kɑtɔsɩ sɩ n cɑɑ ń lǝsɩ mɑ luɣu tɛɛ. Pǝyele mɑ tɑ wɑkǝlǝnɑ-ŋ nɑtǝlɩ. ");
INSERT INTO dop_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Tɑcɑɑ kɑ́ hʋʋnɑ mɑ́ nɑ-ŋ tɑ tɔm nɑ ɩ́ lɛɛtɩ-ŋ. Amɑ mɑ kɑɑ kpɑɑsɩ nyɑ́ tɔɔ kɛ́ niŋ. ");
INSERT INTO dop_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","Pɑ tukɑ ɩtuule sɩ: Ɩsɑɣɑlɑtɑɑ lɑkǝnɑ ɩsɑɣɑtʋ. Mpʋ ɩnɩ, tɔtɔɣɔ mɑ kɑɑ tokinɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Mɑ tɑ tɩɩ tɑlʋ hɑɣɑ kʋsǝpɑɣɑ, yɑɑ ɩpɛɛlɑʋ, nɑ hɑlɩ Ɩsɛɣɛlɩ wulɑʋ tɑkɑ tɔɣɔnǝɣɩ-m mpʋ. ");
INSERT INTO dop_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Tɑcɑɑ kɑ́ hʋʋnɑ mɑ́ nɑ-ŋ tɑ́ tɔm nɑ ɩ́ sɛɛnɑ mɑ tɔɔ. Ɩ kɑ́ hɑ-m tɑmpɑnɑ, nɑ ɩ́ yɑ-m nyɑ́ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Tɑfiiti tɛmɑ yɔɣɔtʋɣʋ kɛ mpʋ, ɩlɛnɑ Sɑyuli pɔɔsɩ sɩ: Ɩlɛ mɑ pǝyɑlʋ Tɑfiiti nɔɣɔ kɛ mɑ nɩɩkɩ mpʋ? Ɩlɛnɑ Sɑyuli tʋlɩ nɔɣɔ nɑ ɩ́ wii tǝkpoo. ");
INSERT INTO dop_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Nɑ ɩ́ tɔ sɩ: Nyɑɣɑlɛ tɑmpɑnɑ tʋ, mɑ tɔm sǝpǝnɑ. Mpi tɔ, mɑ́ lɑpǝnɑ-ŋ ɩsɑɣɑtʋ nɑ ń lɛɛtɩ-m kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Kʋpɑntʋ nti n lɑpɑ-m tɔɣɔ n kɛɛsɑ sɑŋɑ ɩsǝntɔ. Mpi tɔ, Tɑcɑɑ tʋ-m nyɑ́ niŋ tɑɑ nɑ ń kisi-m kʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","Ye yʋlʋ sulɑ ɩ kolontu ɩ kʋɣʋ-ɩ kɛ́, ɩɩ yeki-ɩ. Tɑcɑɑ ɩ́ lɛɛtɩ-ŋ kʋpɑntʋ nti n lɑpɑ-m sɑŋɑ kʋyɑkʋ kʋnɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Pǝnɛntɛ mɑ nyǝ́mɑ sɩ nyɑɣɑlɛ wulɑʋ. Ɩsɛɣɛlɩ kɑwulɑɣɑ tǝnɑ kɑ́ wɛɛ nyɑ́ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Mpʋ tɔ, yɔɣɔtɩ nɑ ń tuunɑ Tɑcɑɑ sɩ, n kɑɑ kʋ mɑ lʋlʋɣʋ nyǝ́mɑ kɛ mɑ sǝm wɑɑlɩ. Pǝyele n kɑɑ kpiisi mɑ hǝtɛ kɛ mɑ cɑɑ tǝyɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S124_23","010_24_23","1SA","24","23","23","Ɩlɛnɑ Tɑfiiti tuunɑ mpʋ. Mpʋɣʋlɛ Sɑyuli mǝlɑ kpente. Ɩlɛnɑ Tɑfiiti nɑ́ɑ́ mǝlɩ ɩ kʋkpɑmʋɣʋ pʋ́ʋ́ɣʋ́ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Sɑmiyɛɛlɩ sǝpɑ. Ɩlɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ koti nɑ pɑ́ cɑɣɑ ɩ lǝyɑɣɑ, nɑ pɑ́ pimi-ɩ ɩ tɛ Lɑmɑ. Wɑɑtʋ ɩnǝɣɩ Tɑfiiti kʋlɑɑ nɑ ɩ́ polo Pɑlɑŋ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S125_2","010_25_2","1SA","25","2","3","Kɑlɛpʋ lʋlʋɣʋ tɑɑ ɑpɑlʋ toŋ tʋ nɔɣɔlʋ ɩ kɑ wɛnnɑ Mɑwɔŋ. Ɩlɛnɑ ɩ tǝmlɛ nyǝ́mɑ nɑ́ɑ́ wɛ Kɑmɛɛlɩ nɑ pɑ́ lɑkɩ ɩ tǝmlɛ. Ɩ heeŋ kɑ wɛ iyisi tooso (3000) nɑ pǝ́ŋ́ kɛ iyɑɣɑ (1000). Apɑlʋ ɩnɩ ɩ hǝtɛ ntɛ́ Nɑpɑɑlɩ, nɑ ɩ ɑlʋ sɩ Apikɑɑlɩ. Alʋ ɩnɩ ɩ kɑ wɛ lǝmɑɣɑsɛɛ kɛ́ nɑ ɩ ɩsɛntɑɑ lɩɩwɑ. Amɑ ɩ pɑɑlʋ nɑ́ kɛ́ yʋlʋ nyǝmǝŋ tʋ nɑ ɩsɑɣɑʋ. Kɑmɛɛlɩ kɛ pɑɑ wɛ wɑɑtʋ ɩnɩ nɑ pɑ́ kɔɔkɩ pɑ heeŋ hʋntʋ. ");
INSERT INTO dop_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Tɑfiiti pɛlɛ pɑɑ wɛ wʋlɑɣɑ tɛtʋ tɑɑ. Ɩlɛnɑ Tɑfiiti nɩɩ sɩ Nɑpɑɑlɩ kɔɔkɩ ɩ heeŋ hʋntʋ. ");
INSERT INTO dop_vpl VALUES ("S125_5","010_25_5","1SA","25","5","5","Ɩlɛnɑ ɩ́ kʋsɩ ɩfepiyɑ nɑɑnʋwɑ sɩ, pɑ́ polo Kɑmɛɛlɩ kɛ Nɑpɑɑlɩ tɛ, nɑ pɑ́ sɛɛ-ɩ sɩ: Mɑ sɛɛ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S125_6","010_25_6","1SA","25","6","6","Ɩsɔ ɩ́ hɑ nyɑ́ tǝyɑɣɑ nɑ nyɑ́ nyǝm tǝnɑɣɑ ɑlɑɑfǝyɑ. ");
INSERT INTO dop_vpl VALUES ("S125_7","010_25_7","1SA","25","7","8","Ɩ heeli-ɩ tɔtɔ sɩ: Tɑ nɑ nyɑ́ tiikilɑɑ tɩɩ wɛnnɑ Kɑmɛɛlɩ. Tǝ tɑ lɑ-wɛɣɛ ɩsɑɣɑtʋ nɑtǝlɩ. Pǝ́cɔ́ pɑ tɔlɑ tɑɑ nɑtǝlɩ tǝ tɑ le. Ye n cɑɑ, n pɔɔsɩ-tǝɣɩ nyɑ́ tǝmlɛ nyǝ́mɑ nɑ ń nɑ. Tɔʋ, mɑ nɩɩwɑ sɩ pɑ tɔŋnɑ nyɑ́ heeŋ hʋntʋ kɔʋ tɔ, lɑŋhʋlʋmlɛ kʋyɑkʋ kɛ mɑ nyǝ́mɑ polɑ nyɑ́ tɛ. Mɑ wiikinɑ-ŋ sɩ ń hɑ mɑ́ nɑ mɑ nyǝ́mɑ kɛ mpi n wɛnɑ sɩ n hɑɑkɩ-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Ɩfepiyɑ mpɛ pɑ tɑlɑ Nɑpɑɑlɩ tɛ, ɩlɛnɑ pɑ́ kɛɛsɩ-ɩ Tɑfiiti tɔmnɑɑ mpɛ nɑ pɑ́ tɑŋɑ ɩ kʋcɔcɔtʋ. ");
INSERT INTO dop_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Tǝnɑɣɑlɛ Nɑpɑɑlɩ holɑɑ sɩ: Tɑfiiti yɑɑ. Mɑ tɑ nyɩ wei pɑ yɑɑ mpʋ tɔ. Kɑɣɑnɑ yomɑɑ mpɑ pɑ seeki pɑ cɑɑnɑɑ nɑ pɑ́ cɔɔkɩ yem tɔ pɑ wiisɑ pɑɣɑlɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Ɩlɛ mɑ kɑɑ kpɑɣɑ tɔɣɔnɑɣɑ nɑ lʋm nɑ nɑntʋ nti mɑ lɑpɑ tǝkpɛtɛkpɛtɛ kɛ mɑ tǝmlɛ nyǝ́mɑ tɔ, nɑ mɑ́ cɛlǝɣɩ yem cɔɔlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Tǝnɑɣɑlɛ Tɑfiiti pǝyɑlɑɑ pǝsǝnɑ pɑ wɑɑlɩ. Pɑ kpemɑ ɩlɛnɑ pɑ́ kɛɛsɩ-ɩ tɔmnɑɑ mpɛ pɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Ntɛnɑ Tɑfiiti sɩ: Pɑɑ wei ɩ́ lǝlɩ ɩ lɑɣɑtɛ kɛ ɩ tǝnɑɣɑ tɑɑ. Ɩlɛnɑ Tɑfiiti pǝyɑlɑɑ lǝlɩ pɑ lɑɣɑlɛɛ nɑ ɩ mɑɣɑmɑɣɑ ɩ́ co ɩ lɑɣɑtɛ tɔtɔ. Yǝlɑɑ ɩsɩɩ nɑsǝlɛ (400) tʋnɑ ɩ wɑɑlɩ, nɑ pǝ kɑɑsɩ yǝlɑɑ ŋmʋnʋɣʋ (200) nɑ pɛlɛ pɑ tɑŋɑ wontu. ");
INSERT INTO dop_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Ḿpʋ́ɣʋ́ Nɑpɑɑlɩ pǝyɑlɑɑ tɑɑ nɔɣɔlʋ cǝpɑ ɩ ɑlʋ Apikɑɑlɩ kɛ sǝkpɑlʋɣʋ sɩ: Tɑfiiti kʋsǝnɑ ntɛɣɛ ɩ pǝyɑlɑɑ kɛ wʋlɑɣɑ tɛtʋ tɑɑ sɩ pɑ́ kɔɔ pɑ́ sɛɛ tɑ cɑɑ. Ntɛnɑ ɩ́ nyɑɑsɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Pǝ́cɔ́ wɑɑtʋ wei tɑnɑ yǝlɑɑ mpɛ tɩɩ wɛ wʋlɑɣɑ tɛtʋ tɑɑ tɔ, pɑ lɑpɑ-tʋɣʋ kʋpɑntʋ kɛ teu kɛ́. Pɑ tɑ lɑ-tʋɣʋ ɩsɑɣɑtʋ nɑtǝlɩ. Pǝ́cɔ́ tɑ pʋlʋpʋ tɑ le. ");
INSERT INTO dop_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Mpɛ pɑ kentinɑ tɑ tɔɔ kɛ́ tɑm nɑ tǝ́ tiikiɣi tɑ kɑlǝkǝŋ. ");
INSERT INTO dop_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Mpʋ tɔ, nyɩ ɩsǝnɑ n kɑ́ lɑ tɔ. Mpi tɔ, pɑ tɛmɑ tɑ cɑɑ nɑ ɩ nyǝm tǝnɑ pǝ tomle tɑm kɛ́. Pǝyele ɩ nyǝmǝŋ kɑtɑtǝlɑɣɑ tɔɔ, pɑɑ tɑ tɑɑ nɔɣɔlʋ yɔɣɔtǝnɑ-ɩ ɩ kɑɑ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Tǝnɑɣɑlɛ Apikɑɑlɩ kpɑɣɑ potopotonɑɑ kɛ ŋmʋnʋɣʋ (200). Ɩlɛnɑ ɩ kpɑɣɑ sʋlʋm huluŋ nɑɑlɛ, nɑ heeŋ wei pɑ tɛmɑ tǝsʋɣʋ tɔɣɔ kɑkpɑsɩ. Ɩ kpɑɣɑ tɔtɔɣɔ pee kʋtoŋee ɩsɩɩ sɑɑkɩ, nɑ lɛsɛŋ pɑɣɑ kɛ nɩɩnʋwɑ (100), nɑ fikinɑɑ pɑɣɑ kɛ ŋmʋnʋɣʋ (200), nɑ ɩ́ hɔkɔ kpɑŋɑsɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Ɩlɛnɑ ɩ́ tɔ ɩ tǝmlɛ nyǝ́mɑ sɩ: Ɩ́ tɛɛ-m nɔɣɔ nɑ mɑ́ tǝŋ mǝ wɑɑlɩ. Amɑ Apikɑɑlɩ tɑ heeli ɩ pɑɑlʋ kɛ́ nɑtǝlɩ. ");
INSERT INTO dop_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Ḿpʋ́ɣʋ́ ɩ kpɑ ɩ kpɑŋɑɣɑ tɔɔ nɑ ɩ́ kpɑɣɑ pulɑsɩ mpɑɑʋ. Ɩlɛnɑ ɩ nɑ Tɑfiiti nɑ ɩ́lɛ́ ɩ nyǝ́mɑ pɑ́ suli kpɑkpɑɑ. ");
INSERT INTO dop_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Nɑ pɑ́ɑ́nɑ́ kpɑ Tɑfiiti nɑ ɩ́ mɑɣɑsɩ ɩ tɑɑ sɩ: Ɩsɩɩ mɑ tɑŋʋɣʋ ɑpɑlʋ ɩnɛ ɩ nyǝm tǝnɑɣɑ wʋlɑɣɑ tɛtʋ tɑɑ tɔ, mɑ ɩwɩɩlɛ tǝnɑ tʋ-m lʋm ntɛ́ yem. Pǝyele ɩ nyǝm tɑɑ pʋlʋ tɑ le. Ɩlɛnɑ ɩ́ fɛlɩ-m ɩsɑɣɑtʋ kɛ mɑ kʋpɑntʋ lonte. ");
INSERT INTO dop_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Ye pǝ nyɑɑlɑɑ nɑ mɑ́ tɑ kpiisitɑ ɩ nɑ ɩ yǝlɑɑ tǝnɑ Ɩsɔ ɩ́ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Apikɑɑlɩ loosɑ Tɑfiiti, ɩlɛnɑ ɩ́ tii ɩ kpɑŋɑɣɑ tɔɔ kɛ lɔŋ, nɑ ɩ́ hǝntɩ-ɩ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Ɩlɛnɑ ɩ́ tɑsɑ ɩ nɔɔhɛɛ tɛɛ kɛ́ hotuɣu nɑ ɩ́ tɔ sɩ: Hɑɩ, mɑ cɛ, mɑ́ wɑkǝlǝnɑ. Ɩlɛ yele nɑ nyɑ́ pɛɛlɔ mɑ́, mɑ́ yɔɣɔtɩ nɑ ń nɩɩ. ");
INSERT INTO dop_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Tɑɑ kpɑɣɑ mɑ pɑɑlʋ ɩnɩ ɩ tɔm nɑ n yɑɑ-tɩ sɩ pʋlʋ. Pɑ yɑɑkʋɣʋ-ɩ sɩ Nɑpɑɑlɩ tɔ, pǝ nyʋɣʋ ntɛ́ sɩ kpɑŋtʋ. Ḿpʋ́ɣʋ́ ɩ tɩɩ wɛ teitei. Mɑ́ tɑ́ nɑnɑ mpɑ n tilɑɑ tɔ nɑ pǝ́ lɑ́ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S125_26","010_25_26","1SA","25","26","26","Mɑ cɛ, Tɑcɑɑ kpɑnɑ nyɑ́ niŋ sɩ ń tɑɑ lɛɛtɩ nyɑ́ kolontunɑɑ. Mɑ tuunɑ nyɑ́ nɑ Tɑcɑɑ sɩ Ɩsɔ kɑ́ wɑkǝlɩ nyɑ́ kolontunɑɑ nɑ nyɑ́ ɩsɑɣɑlɑtɑɑ kɛ ɩsɩɩ Nɑpɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S125_27","010_25_27","1SA","25","27","27","Hɑɩ, mɑ cɛ, mʋ kʋcɔɔʋ ŋku mɑ kɔnɑ-ŋ ɩsǝntɔ tɔ nɑ ń tɑlɑ nyɑ́ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","Tɑɑ nyǝnɩ mɑ ɩsɑɣɑtʋ, Tɑcɑɑ kɑ́ tʋ-ŋ kɑwulɑɣɑ nɑ kɑ́ wɛɛ tɑm. Mpi tɔ, nyɑ́ pɑɑsǝɣǝnɑ nɑ Tɑcɑɑ yoou. Pǝ́cɔ́ nɔɣɔlʋ kɑɑ kʋ nyɑ́ tɔm. ");
INSERT INTO dop_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Ɩsɔ kɑ́ ŋmɛsɩ nyɑ́ weesuɣu kɛ tǝkulɑkulɑ. Ye nɔɣɔlʋ kʋlɑ nyɑ́ tɔɔ sɩ ɩ kʋɣʋ-ŋ ɩ kɑɑ nɑ-kʋ. Amɑ ɩ kɑ́ lɔ nyɑ́ kolontunɑɑ kɛ́ ɩsɩɩ pɑ tɔɔkʋɣʋ pǝntɔlʋpɛɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S125_30","010_25_30","1SA","25","30","30","Ye pǝ kɔmɑ nɑ Tɑcɑɑ lɑ-ŋ kʋpɑntʋ nti ɩ kɑ sɩɩ-ŋ tɔ, nɑ ɩ́ kpɑ-ŋ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ, ");
INSERT INTO dop_vpl VALUES ("S125_31","010_25_31","1SA","25","31","31","ɩlɛ n kɑɑ wii nyɑ́ tɩ sɩ n kʋwɑ tulum, yɑɑ n lɛɛtɑ nyɑ́ tǝɣɩ nyɑ́ kolontunɑɑ. Hɑɩ, mɑ cɛ, ye pǝ kɔmɑ nɑ Ɩsɔ lɑ-ŋ kʋpɑntʋ, ɩlɛ n tɔɔsɩ mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Mpʋɣʋlɛ Tɑfiiti tɔmɑ Apikɑɑlɩ sɩ: Mɑ sɑmɑ Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ wei ɩ kʋsɑ-ŋ nɑ ń sǝŋɩ-m sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Nɑ mɑ́ sɛɛ nyɑ́ tɔtɔɣɔ ɩsǝnɑ n lɑpɑ lǝmɑɣɑsɛɛ, nɑ ń kpɑ mɑ niŋ nɑ mɑ́ tɑ́ kʋ nɑ mɑ́ lɛɛtɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Mɑ tuukinɑ Tɑcɑɑ wei ɩ kpɑ mɑ niŋ sɩ mɑ́ tɑɑ lɑ-mɛɣɛ ɩsɑɣɑtʋ tɔ sɩ, ye n tɑɑ sǝŋɩ-m lɔŋ, mpi sɩ pɩɩ nyɑɑlɑɣɑ tɔ, pǝ tɑɑ kɑɑsɩ Nɑpɑɑlɩ nɑ ɩ yǝlɑɑ tɑɑ nɔɣɔlʋ. ");
INSERT INTO dop_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Ɩlɛnɑ Tɑfiiti mʋ Apikɑɑlɩ niŋ tɑɑ kɛ́ mpi ɩ kɑ hɑ-ɩ tɔ. Ɩlɛnɑ ɩ́ tɔmɩ-ɩ sɩ: Tɑɑ nyɑ́, mǝlɩ nyɑ́ tɛ, mɑ nɩɩ nyɑ́ tɔm, mɑ hʋlɑ-ŋ suulu. ");
INSERT INTO dop_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Apikɑɑlɩ mǝlɑ tǝyɑɣɑ, ɩlɛ ɩ mɑɣɑnɑ ɩ pɑɑlʋ tɔkɩ kɛlɛ nɑ ɩ́ nyɔɔkɩ ɩsɩɩ wulɑʋ, nɑ sʋlʋm kʋ-ɩ nɑ ɩ́ ŋmɑɑlǝɣɩ. Ɩlɛ ɩ tɑ heeli-ɩ nɑtǝlɩ tǝfɩ, hɑlǝnɑ pǝ fe tɑnɑŋ. ");
INSERT INTO dop_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Tɛʋ femɑ nɑ ɩ sʋlʋm cɛ ɩ tɔɔ, ɩlɛnɑ ɩ ɑlʋ kɛɛsɩ-ɩ pǝ tǝnɑ. Ḿpʋ́ɣʋ́ ɩ lɑŋlɛ cɛpɑ kɑtɑtǝlɑɣɑ, nɑ pǝ́ mǝlɩ-ɩ tʋʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Kʋyɛɛŋ lɑpɑ ɩsɩɩ nɑɑnʋwɑ, ɩlɛnɑ Tɑcɑɑ yele nɑ ɩ́ tɛɛsɩ sǝpʋ. ");
INSERT INTO dop_vpl VALUES ("S125_39","010_25_39","1SA","25","39","39","Ḿpʋ́ɣʋ́ Tɑfiiti nɩɩwɑ sɩ Nɑpɑɑlɩ sǝpɑ. Ɩlɛnɑ ɩ́ tɔ sɩ: Mɑ sɛɛ Tɑcɑɑ wei ɩ sɛɛnɑ mɑ tɔɔ kɛ́ ɩsɑɣɑtʋ nti Nɑpɑɑlɩ lɑpɑ-m tɔ tǝ tɑɑ tɔ. Ɩsɔ ɩnɩ ɩ kpɑnɑ mɑ niŋ sɩ mɑ́ tɑɑ wɑkǝlɩ, nɑ ɩ́ lɛɛtɩ Nɑpɑɑlɩ kɛ ɩ mɑɣɑmɑɣɑ. Pǝ wɑɑlɩ kɛ́ Tɑfiiti tilɑɑ sɩ ɩ hɔŋ Apikɑɑlɩ kɛ leelu. ");
INSERT INTO dop_vpl VALUES ("S125_40","010_25_40","1SA","25","40","40","Tillɑɑ tɑlɑ ɑlʋ ɩnɩ ɩ tɛɣɛ Kɑmɛɛlɩ, ɩlɛnɑ pɑ́ heeli-ɩ sɩ: Tɑfiiti tilinɑ-tʋɣʋ nyɑ́ kiŋ sɩ ɩ hɔŋɩ-ŋ leelu. ");
INSERT INTO dop_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","Mpʋɣʋlɛ Apikɑɑlɩ hǝntɑ-wɛɣɛ ɑtɛ nɑ ɩ́ tɔ sɩ: Mɑɑ pǝsɩ tɑ cɑɑ yom, nɑ mɑ́ kɔɔkɩ ɩ tǝmlɛ nyǝ́mɑ nɔɔhɛɛ kɛ lʋm. ");
INSERT INTO dop_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Ɩlɛnɑ Apikɑɑlɩ kʋlɩ kpɑkpɑɑ nɑ ɩ́ kpɑ ɩ kpɑŋɑɣɑ tɔɔ. Nɑ ɩ pɛɛlɑɑ kɑkpɑsɩ wei ɩ lɑkɑɣɑ-ɩ tǝmlɛ tɔɣɔ ɩ wɑɑlɩ, nɑ ɩ tǝŋ Tɑfiiti tǝmlɛ nyǝ́mɑ nɑ ɩ́ pǝsɩ Tɑfiiti ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","Tɑfiiti kɑ tɛmɑ Sisilee tʋ Ahinowɑm kɛ kpɑɣɑʋ kɛ ɑlʋ. Ɩ ɑlɑɑ lɑpɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","Pǝ kɑɑsɑ ɩ kɑncɑɑlɑɣɑ ɑlʋ Mikɑɑlɩ tɔ, ɩ́lɛ́ ɩ cɑɑ Sɑyuli kɑ lɛɛkɑ-ɩ kɛ́ nɑ ɩ́ hɑ Kɑlim tʋ Lɑyisi pǝyɑlʋ Pɑlǝti. ");
INSERT INTO dop_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Sifɩ nyǝ́mɑ polɑ Sɑyuli kiŋ kɛ Kipeyɑ nɑ pɑ́ heeli-ɩ sɩ: Tɑfiiti polɑɑ nɑ ɩ́ ŋmɛlɩ Hɑkilɑ pulɑɣɑ tɔɔ kɛ́ wʋlɑɣɑ tɛtʋ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Tǝnɑɣɑlɛ Sɑyuli kʋlɑɑ, nɑ ɩ́ kpɑɣɑ Ɩsɛɣɛlɩ yoolɑɑ tɑɑ yoolɑɑ kɛ iyisi tooso (3000) nɑ pɑ́ polo Tɑfiiti pɛɛkʋɣʋ kɛ Sifɩ wʋlɑɣɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Pɑ tɑlɑɑ, ɩlɛnɑ pɑ́ siki Hɑkilɑ pulɑɣɑ tɔɔ kɛ́ mpɑɑʋ nɔɣɔ. Ḿpʋ́ɣʋ́ Tɑfiiti nɩɩwɑ sɩ Sɑyuli tǝŋɑ ɩ wɑɑlɩ kɛ́ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","Ɩlɛnɑ ɩ́ tili feŋlɑɑ nɑ pɑ́ mɑɣɑnɑ sɩ tɑmpɑnɑ. ");
INSERT INTO dop_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Ḿpʋ́ɣʋ́ Tɑfiiti polɑ pɑ tǝsikile tǝnɑɣɑ kpɑkpɑɑ. Ɩlɛnɑ ɩ́ nɑ́ Sɑyuli nɑ ɩ yoou wulɑʋ Apǝnɛɛ pɑ tǝhǝntǝlɛ. Sɑyuli nɑ hǝntɑɣɑ hɛkʋ tɑɑ kɛ́, nɑ yoolɑɑ nɑ́ɑ́ hǝntɑɑ nɑ pɑ́ cɔɔnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Ḿpʋ́ɣʋ́ Tɑfiiti pɔɔsɑ Hiti tʋ Ahimelɛkɩ, nɑ Seluyɑ pǝyɑlʋ Sowɑpɩ neu Apǝsɑyi sɩ: Mǝ tɑɑ ɑwe cɑɑ sɩ mɑ nɑ-ɩ tǝ́ polo Sɑyuli pɑ tǝsikile? Ntɛnɑ Apǝsɑyi cɔ-ɩ sɩ: Mɑɑ tǝŋɩ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Mpʋɣʋlɛ pɑ kʋlɑ ɑhoo ɑnɩ nɑ pɑ́ polo pɑ mɑɣɑnɑ Sɑyuli hǝntɑ hɛkʋ tɑɑ nɑ ɩ́ tooki. Ɩ ŋmɑntɑɑɣɑ kɑ sikɑ ɩ nyʋɣʋ tɔɔ kɛ́, nɑ Apǝnɛɛ nɑ yoolɑɑ pɑ hǝntɑɑ nɑ pɑ́ tɑmɩ-ɩ kotɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Tǝnɑɣɑlɛ Apǝsɑyi tɔmɑ Tɑfiiti sɩ: Sɑŋɑ ntɛ́ Tɑcɑɑ tʋwɑ nyɑ́ kolontu kɛ nyɑ́ niŋ tɑɑ. Lɑ suulu nɑ ń yele nɑ mɑ́ kɑmɩ-ɩ ŋmɑntɑɑɣɑ kɛ tɔm kʋlʋm tike tǝkoŋ nɑ mɑ́ kpǝnɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Ntɛnɑ Tɑfiiti sɩ: Tɑɑ kʋ-ɩ yoo. Ye yʋlʋ kʋwɑ Tɑcɑɑ kʋlǝsʋ, Ɩsɔ ɩɩ yeki pʋntʋ. ");
INSERT INTO dop_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Mɑ tuukinɑ sɩ, Tɑcɑɑ tike wɛnnɑ mpɑɑʋ sɩ ɩ́ kʋ-ɩ. Ntɑnyɩ ɩ kʋyɑkʋ kɑ́ tɑlɑ nɑ ɩ́ sɩ́ ɩ sǝm, yɑɑ pɑ́ kʋ-ɩ tǝyoole. ");
INSERT INTO dop_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Sɩ mɑ́ tʋ́ niŋ kɛ Tɑcɑɑ kʋlǝsʋ tɔɔ tɔ, Ɩsɔ ɩ́ ponɑ mpusi kɛ pooluŋ. Ɩlɛ kpɑɣɑ ɩ ŋmɑntɑɑɣɑ nɑ ɩ lʋm fulɑɣɑ nɑ tǝ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Tɑfiiti pɑ kpɑɣɑ wontu ntɩ nɑ pɑ́ tɛɛ tɔ, nɔɣɔlʋ tɑ fe nɑ ɩ́ nɩɩ pɑ tɑŋ yɑɑ ɩ́ nɑ-wɛ. Mpi tɔ, Tɑcɑɑ lɑpɑɣɑ nɑ pɑ́ too ɩsɩɩ pɑ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Ḿpʋ́ɣʋ́ Tɑfiiti pɑ polɑ pooluŋ nɑ pɑ́ kpɑ pulɑɣɑ lɛŋkɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Ɩlɛnɑ ɩ́ kpɛɛsɩ Apǝnɛɛ nɑ yoolɑɑ lɛmpɑ sɩ: He hee, ɩɩ nɩɩ tɑɑ? Ntɛnɑ Apǝnɛɛ sɩ: Nyɑɣɑ ɑweɣe nɑ ń holiɣi wulɑʋ tɔɔ kɛ́ mpʋ ye? ");
INSERT INTO dop_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Kɛlɛnɑ Tɑfiiti cɔ-ɩ sɩ: Nyɑnɑ ɑwe ɩ́ mɑɣɑ ɑpɑlʋtʋ kɛ Ɩsɛɣɛlɩ tɑɑ? Pepe tɔɔ kɛ́ n tɑ feŋ nyɑ́ cɑɑ wulɑʋ tɔɔ kɛ́ teu? Tɔʋ, nɔɣɔlʋ polɑɑ sɩ ɩ́ kʋɣɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Amɑ nti n lɑpɑ mpʋ tɔ tǝ tɑ kɛɛsɩ yoo. Mɑ tuukinɑ Tɑcɑɑ sɩ timpi ɩ́ tɑ́ feŋ mǝ cɑɑ wei Tɑcɑɑ lǝsɑɑ tɔ ɩ tɔɔ tɔ, ɩ́ mʋnɑ sǝm kɛ mǝ tǝnɑɣɑ. Nyǝnɩ, wulɑʋ ŋmɑntɑɑɣɑ nɑ ɩ lʋm fulɑɣɑ ŋkɑ kɑɑ wɛ ɩ nyʋɣʋ tɔɔ tɔɣɔlɔ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Ḿpʋ́ɣʋ́ Sɑyuli nyǝmɑ́ Tɑfiiti nɔɣɔ nɑ ɩ́ pɔɔsɩ sɩ: Mɑ pǝyɑlʋ Tɑfiiti nɔɣɔ kɛ mɑ nɩɩkɩ mpʋ? Ɩlɛnɑ ɩ́ cɔ sɩ: Hɑɩ, mɑ cɑɑ wulɑʋ, mɑ nɔɣɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Tɑ cɑɑ, pepe tɔɔ kɛ́ n tɔɣɔnǝɣɩ-m mpʋ? Mɑ lɑpɑ-ŋ we? Ntiɣi mɑ pǝntǝnɑ-ŋ? ");
INSERT INTO dop_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","Hɑɩ, tɑ cɑɑ, ke ŋkpɑŋŋ nɑ ń nɩɩ mɑ tɔm. Ye Tɑcɑɑ tʋnɑ-ŋ sɩ ń tɔɣɔnɩ-m, ɩlɛ kʋhɑʋ kɑ hɛɛsɩ ɩ lɑŋlɛ. Amɑ ye yǝlɑɑ sɔsǝɣǝnɑ-ŋ, Tɑcɑɑ ɩ́ tǝŋsɩ-wɛɣɛ mpusi. Mpi tɔ, pɑ tɔɣɔnǝɣɩ-m kɛ́ sɩ mɑ́ lɩɩ Ɩsɔ tɛtʋ tɑɑ, nɑ mɑ́ polo tɩɩŋ tǝlɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Amɑ mɑɑ cɑɑkɩ sɩ mɑ sɩ lɛlɑɑ tɛ́. Pepe tɔɔ kɛ́ n pɛɛkǝɣɩ-m ɩsɩɩ ɩsɛsǝlɑʋ, yɑɑ ɩsɩɩ pɑ tɔɣɔnʋɣʋ lǝyɑɣɑ kɛ pulɑsɩ tɑɑ tɔ? ");
INSERT INTO dop_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Mpʋɣʋlɛ Sɑyuli cɔwɑ sɩ: Mɑ wɑkǝlɑɑ kɛ́. Mǝlɩ mɑ pǝyɑlʋ. Mɑ kɑɑ tɑsɑ-ŋ ɩsɑɣɑtʋ kɛ lɑpʋ. Mpi tɔ, n tɑ kʋ-m. Mɑ́ lɑpǝnɑ ɩsɑɣɑtʋ sɔsɔɔntʋ ɩsɩɩ kʋmɛlǝmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","Kɛlɛnɑ Tɑfiiti sɩ: Tɑ cɑɑ, nyɑ́ ŋmɑntɑɑɣɑ ntɔ cǝnɛ. Nyɑ́ yǝlɑɑ tɑɑ nɔɣɔlʋ ɩ́ kɔɔ ɩ́ mʋ. ");
INSERT INTO dop_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Tɑcɑɑ ɩ́ fɛlɩ mpɑ pɑ tǝŋɑ siɣisuɣu nɑ pɑ́ lɑ́ kʋpɑntʋ tɔ. Mpi tɔ, sɑŋɑ ɩ tʋ-ŋ mɑ niŋ tɑɑ kɛ́. Ɩlɛnɑ mɑ́ kisi sɩ mɑ tɑɑ tokinɑ wulɑʋ wei Tɑcɑɑ lǝsɑɑ nɑ ɩ́ kpɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Ɩsɩɩ sɑŋɑ mɑ yelɑ-ŋ kʋɣʋ tɔ, Tɑcɑɑ ɩ́ lɑ mɑɣɑ mpʋ tɔtɔ, nɑ ɩ́ fiti-m wɑhɑlɑnɑɑ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Ntɛnɑ Sɑyuli sɩ: Mɑ pǝyɑlʋ, Ɩsɔ ɩ́ kooli-ŋ kʋpɑntʋ nɑ ń wɑɑ pǝ tǝnɑ pǝ tɑɑ. Ḿpʋ́ɣʋ́ Sɑyuli mǝlɑ kpente nɑ Tɑfiiti nɑ́ɑ́ tɛɛ ɩ nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti mɑɣɑsɑ ɩ tɑɑ sɩ: Kʋyɑkʋ nɑkʋlɩ Sɑyuli tɛŋ nɑ ɩ́ kʋ-m yoo. Ɩlɛ sɑnɑ kɛlɛ sɩ mɑ́ polo mɑ́ tʋ kpʋlʋɣʋ kɛ Filiisi nyǝ́mɑ tɛtʋ tɑɑ. Wɑɑtʋ ɩnǝɣɩ ɩ kɑ́ yele-m pɛɛkʋɣʋ kɛ Ɩsɛɣɛlɩ tɛtʋ tɑɑ cǝnɛ. Ɩlɛ mɑ fitɑ ɩ niŋ tɑɑ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("S127_2","010_27_2","1SA","27","2","2","Pǝ tɔɔ kɛ́ ɩ nɑ ɩ yǝlɑɑ nɑsǝtoso (600), pɑ kʋlɑɑ. Ḿpʋ́ɣʋ́ pɑ tǝŋnɑ Mɑwɔkɩ pǝyɑlʋ Akisi wei ɩ kɛ́ Kɑtɩ nyǝ́mɑ wulɑʋ tɔ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("S127_3","010_27_3","1SA","27","3","3","Ɩlɛnɑ pɑ́ kpɑɣɑ pɑ ɑlɑɑ, nɑ pɑ piyɑ, nɑ pɑ́ polo pɑ́ cɑɣɑ tǝnɑ. Pɑɑ nɑ Tɑfiiti nɑ ɩ́lɛ́ ɩ ɑlɑɑ nɑɑlɛ, Sisilee tʋ Ahinowɑm, nɑ Kɑmɛɛlɩ tʋ Apikɑɑlɩ wei ɩ kɛ́ Nɑpɑɑlɩ leelu tɔ. ");
INSERT INTO dop_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Sɑyuli nɩɩwɑ sɩ Tɑfiiti tʋ kpʋlʋɣʋ kɛ Kɑtɩ, ɩlɛnɑ ɩ́ yele-ɩ pɛɛkʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Tɑfiiti tɔmɑ wulɑʋ Akisi sɩ: Hɑɩ, tɑ cɑɑ, ye n lɑpɑ-m nɑɑni, ɩlɛ n nyǝnɩ ɩcɑliyɑ nɑkǝlǝɣɩ nyɑ́ tɛtʋ tɑɑ cǝnɛ nɑ mɑ́ cɑɣɑ tǝnɑ. Tɔfɔ pǝ fɛɩ sɩ mɑ́ nɑ-ŋ tǝ́ cɑɣɑ nyɑ́ kɑwulɑɣɑ ɩcɑtɛ tɑɑ kɛ́ mpʋ? ");
INSERT INTO dop_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Ɩlɛnɑ Akisi hʋlɩ-ɩ ɩcɑtɛ nte pɑ yɑɑ sɩ, Sikǝlɑkɩ tɔɣɔ kʋyɑkʋ ŋkʋ kʋ mɑɣɑmɑɣɑ. Pǝ tɔɔ kɛ́ ɩcɑtɛ ntɛ́ tǝ pǝsɑ Yutɑ nyǝ́mɑ wulɑʋ nyǝntɛ kɛ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","Pǝnɑɣɑ nɑ ɩsɔtʋnɑɑ liɣiti tǝcu kɛ Tɑfiiti cɑɣɑ Filiisi nyǝ́mɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Tɑfiiti pɑ lɩɩkɑɣɑ kʋlɩɩʋ kɛ Kesuli nyǝ́mɑ, nɑ Kiiisi nyǝ́mɑ, nɑ Amɑleke nyǝ́mɑ kɛ́. Mpi tɔ, piitimnɑɑ mpɛ pɑɑ cɑɣɑnɑ hɑtoo lɔŋ tɑɑ kɛ́ Suli kɔŋkɔŋ tɑɑ. Hɑlǝnɑ pǝ́ polo Icipiti tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Pɑ kʋkɑɣɑ yǝlɑɑ tǝnɑɣɑ hɔɣɔlʋɣʋ ŋkʋ kʋ tɑɑ kɛ́. Pǝ kpɑɣɑʋ ɑpɑlɑɑ nɑ ɑlɑɑ tɔ. Ɩlɛnɑ pɑ́ kpɑkǝɣɩ pɑ tɔlɑ nɑ pɑ nyǝm nɑ pɑ́ pukinɑ Akisi. ");
INSERT INTO dop_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Ye ɩ́lɛ́ ɩ pɔɔsɑ-ɩ sɩ: Leɣe ɩ polɑ mǝ kʋlɩɩʋ kɛ sɑŋɑ? Ɩlɛ ntɑnyɩ ɩ looli sɩ Yutɑ tɛtʋ ilim mpǝtǝŋ tɔɔ. Yɑɑ ɩ tɔ sɩ Yelɑmeli tɛtʋ tɑɑ, yɑɑ Keni tɛtʋ tɑɑ kɛ́ tǝ polɑɑ. ");
INSERT INTO dop_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","Tɑfiiti ɩɩ yeki ɑpɑlʋ yɑɑ ɑlʋ nɑ ɩ weesuɣu, sɩ pǝ́ tɑɑ kɔɔ nɑ pɑ́ tɑɣɑsɩ Akisi kɛ nti ɩ lɑkɩ tɔ. Ɩsǝnɑ Tɑfiiti lɑkɑɣɑ sɑɑ wei ɩ kɑ wɛ Filiisi nyǝ́mɑ tɛtʋ tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Akisi kɑ lɑpɑ Tɑfiiti kɛ nɑɑni kɛ́ teu kɛ́ nɑ ɩ́ tɔŋ sɩ: Nɔɔnɔɔ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ kpɑɑnɑ Tɑfiiti. Mpʋ tɔ, tǝlɑsɩ ɩ kɑ́ pǝsɩ mɑ tǝmlɛ tʋ kɛ tɑm tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S128_1","010_28_1","1SA","28","1","1","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ kotɑ pɑ yoolɑɑ tintikɑ sɩ pɑ yookinɑ Ɩsɛɣɛlɩ nyǝ́mɑ. Ɩlɛnɑ Akisi pɔɔsɩ Tɑfiiti sɩ: Ntɔŋ n nyǝ́mɑ sɩ nyɑnɑ nyɑ́ yǝlɑɑ ɩ kɑ sǝnɑ-m nɑ tǝ́ yoonɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ? ");
INSERT INTO dop_vpl VALUES ("S128_2","010_28_2","1SA","28","2","2","Ntɛnɑ Tɑfiiti cɔ-ɩ sɩ: N kɑ́ nɑnɑ nyɑ́ ɩsǝpǝle kɛ nti mɑɑ lɑ tɔ. Kɛlɛnɑ Akisi sɩ: Wɑɑtʋ ɩnǝɣɩ mɑɑ yele nɑ ń tɑŋǝɣɩ mɑ mɑɣɑmɑɣɑ kɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Sɑmiyɛɛlɩ kɑ tɛmɑ sǝpʋ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ pimi-ɩ ɩ tɛ Lɑmɑ. Hɑlɩ pɑ́ cɑɣɑ ɩ lǝyɑɣɑ. Pǝyele Sɑyuli kɑ tɔɣɔnɑ kɔɣɔnɑmǝŋ sʋsǝlɑɑ, nɑ pee pɔɔsǝlɑɑ tǝnɑɣɑ ɩ tɛtʋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Ḿpʋ́ɣʋ́ Filiisi yoolɑɑ kotɑɑ nɑ pɑ́ siki Sunem, nɑ Sɑyuli nɑ́ɑ́ koti Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɑ pɑ́ siki Kilipʋwɑ. ");
INSERT INTO dop_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Sɑyuli nɑwɑ kolontunɑɑ yoolɑɑ pɑɣɑlɛ, ɩlɛnɑ sɔɣɔntʋ kpɑ-ɩ nɑ ɩ́ seliɣi ɩsɩɩ lʋm tɑɑ kpɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Ɩlɛnɑ ɩ́ yɔɣɔtǝnɑ Tɑcɑɑ. Amɑ ɩ́lɛ́ ɩ tɑ cɔ-ɩ. Pɑɑ toosee tɑɑ, pɑɑ kɔtǝlɑɑ mɑɣɑsʋɣʋ tɑɑ. Pǝyele Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ nɔɣɔlʋ ɩ tɑ heeli-ɩ sɩ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Ntɛnɑ ɩ́ tʋ́ nɔɣɔ sɩ pɑ́ pɛɛkɩ-ɩ ɑlʋ wei ɩ sʋsǝɣɩ kɔɣɔnɑmǝŋ tɔ nɑ ɩnɩ ɩ polo ɩ kiŋ. Ɩlɛnɑ ɩ wɑɑlɩ nyǝ́mɑ heeli-ɩ sɩ: Alʋ nɔɣɔlʋ ɩ wɛ An-Tɔɔɔ nɑ ɩ́ sʋsǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Ahoo yuwɑ ɩlɛnɑ Sɑyuli lɑɣɑsɩ wontu, nɑ ɩ́ kpɑɣɑ ɑpɑlɑɑ nɑɑlɛ nɑ pɑ́ polo ɑlʋ ɩnɩ ɩ kiŋ. Ḿpʋ́ɣʋ́ Sɑyuli tɔmɑ-ɩ sɩ: Mɑ cɑɑ sɩ ń yɑɑ-m ɑtɛtʋ wei mɑɑ kɛɛsɩ-ŋ tɔ nɑ ɩ́ heeli-m mɑ nyʋɣʋ tɔm. ");
INSERT INTO dop_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Ḿpʋ́ɣʋ́ ɑlʋ pɔɔsɑ-ɩ sɩ: Ntɔŋ n nyǝmɑ́ sɩ Sɑyuli tɔɣɔnɑ kɔɣɔnɑmǝŋ sʋsǝlɑɑ, nɑ pee pɔɔsǝlɑɑ tǝnɑɣɑ ɩ tɛtʋ tɑɑ? Ɩlɛ pepe tɔɔ kɛ́ n nyǝkɩ-m kɑtɔkɑ sɩ ń kpɑ-m nɑ pɑ́ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Ntɛnɑ Sɑyuli yɔɣɔtɩ nɑ ɩ tuu sɩ: Nɑ Ɩsɔ, pʋlʋ kɑɑ lɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Ntɛnɑ ɑlʋ pɔɔsɩ-ɩ sɩ: Aweɣe n cɑɑ sɩ mɑ́ yɑɑ? Sɑyuli sɩ yɑɑ Sɑmiyɛɛlɩ. ");
INSERT INTO dop_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Wɑɑtʋ wei ɑlʋ nɑwɑ Sɑmiyɛɛlɩ, ɩlɛnɑ ɩ́ mɑ́ kɑpukɑ nɑ ɩ́ tɔ́ Sɑyuli sɩ: Hei, sɛsɛ nyɑɣɑlɛ Sɑyuli nɑ ń puɣusu-m mpʋ? ");
INSERT INTO dop_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Ntɛnɑ wulɑʋ nɔɣɔ tǝkpɑʋ sɩ: Nyɑ́ lɑŋlɛ ɩ́ tɑɑ tɔ. N nɑ pʋlʋɣʋ? Ntɛnɑ ɑlʋ sɩ: Atɛtʋ nɔɣɔlʋɣʋ mɑ nɑɑkɩ nɑ ɩ́ lɩɩkǝnɑ tɛtʋ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Ɩlɛnɑ ɩ́ pɔɔsɩ-ɩ sɩ: Ɩ ɩsɛntɑɑ wɛ ɩsǝnɑ tɔɔ? Alʋ sɩ: Kʋkpɑtʋlʋ kɛ́, nɑ ɩ́ suu cɑpɑ. Tǝnɑɣɑ Sɑyuli cɛkǝnɑɑ sɩ Sɑmiyɛɛlɩ, nɑ ɩ́ hǝntɩ-ɩ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Mpʋɣʋlɛ Sɑmiyɛɛlɩ pɔɔsɑ Sɑyuli sɩ: Pepe tɔɔ kɛ́ n cɑɑlǝɣɩ-m mpʋ? Ntɛnɑ Sɑyuli sɩ: Mɑ tɔm tɛmɑɣɑ. Mpi tɔ, Filiisi nyǝ́mɑ kɔmɑ-m yoonɑʋ. Pǝyele Ɩsɔ ɩɩ tɑsǝɣɩ-m yɔɣɔtǝnɑʋ. Pɑɑ toosee tɑɑ, pɑɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsǝlɑɑ ɩɩ heeliɣi-wɛɣɛ mɑ tɔm. Pǝ tɔɔ kɛ́ mɑ yɑɑ-ŋ sɩ ń heeli-m nti pǝ wɛɛ sɩ mɑɑ lɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Ntɛnɑ Sɑmiyɛɛlɩ pɔɔsɩ-ɩ sɩ: Tɑcɑɑ lɔ-ŋ nɑ ɩ́ pǝsɩ nyɑ́ kolontu, ɩlɛnɑ ń yɑɑkɩ mɑ́ suwe? ");
INSERT INTO dop_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Ɩsɩɩ Tɑcɑɑ kɑ heelɑ-ŋ nɑ mɑ kɛɛsɩ-ŋ tɔɣɔ ɩ lɑkɩ-ŋ. Ɩ lɛɛkɑ nyɑ́ kɑwulɑɣɑ nɑ ɩ́ hɑ-kɛɣɛ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","N tɑ tɔkɩ Tɑcɑɑ tɔm nɑ ń kpiisi Amɑleke nyǝ́mɑ. Mpʋ pǝ tɔɔ kɛ́ Tɑcɑɑ lɑkɩ-ŋ ḿpʋ́ɣʋ́ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Cele ɩ kɑ́ tʋ nyɑnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ kɛ Filiisi nyǝ́mɑ niŋ tɑɑ, nɑ nyɑnɑ nyɑ́ piyɑ ɩ kɑ́ lɑ sɔlʋnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Ḿpʋ́ɣʋ́ Sɑmiyɛɛlɩ tɔm ntɩ tǝ sʋsɑ Sɑyuli kɛ wɑtʋ nɑ ɩ́ yele ɩ tɩ nɑ ɩ́ fɑlɑ ɑtɛ tǝmʋlʋ ɩsɩɩ tɑɑʋ. Mpi tɔ, ɩ tɑɑ tɔɣɔ pʋlʋɣʋ kʋyɑkʋ ŋkʋ nɑ ɑhoo tǝnɑ, ɩlɛ ɩ tɔnʋɣʋ kɑ hoowɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Mpʋɣʋlɛ ɑlʋ ɩnɩ ɩ polɑ Sɑyuli kiŋ nɑ ɩ́ mɑɣɑnɑ-ɩ nɑ sɔɣɔntʋ pɩɩ-ɩ ḿpʋ́ɣʋ́ kɑtɑtǝlɑɣɑ. Ɩlɛnɑ ɩ́ tɔmɩ-ɩ sɩ: Tɑ cɑɑ, nyɑ́ pɛɛlɔ mɑ́, mɑ nɩɩnɑ-ŋ teu nɑ mɑ́ mʋ sǝm nɑ mɑ́ lɑ́ nti n heelɑ-m tɔ. ");
INSERT INTO dop_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Mpʋ tɔ, yele mɑ́ hɑ-ŋ tɔɣɔnɑɣɑ kɛ pǝcɔ nɑ ń tɔɣɔ, nɑ pǝ́ cɛ nyɑ́ ɩsɛntɔɔ nɑ ń tʋ́ nyɑ́ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Ɩlɛnɑ Sɑyuli kisi sɩ ɩ kɑɑ tǝŋ pʋlʋ. Ḿpʋ́ɣʋ́ Sɑyuli wɑɑlɩ nyǝ́mɑ nɑ ɑlʋ ɩnɩ pɑ kɑɑnɑ-ɩ, hɑlǝnɑ ɩ́ kɔɔ ɩ kʋlɩ ɑtɛ nɑ ɩ́ cɑɣɑ kʋhǝntʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Ḿpʋ́ɣʋ́ ɑlʋ kpɑ nɑʋ ɩfɑtɛ nte tǝ yɑsǝlɑ teu tǝlǝpǝlǝpɩ tɔɣɔ lɔŋ, nɑ ɩ́ kʋ nɑ ɩ́ tʋ pɛtɛpɛtɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Ɩlɛnɑ ɩ́ cɛlɑ Sɑyuli nɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ pɑ́ tɔɣɔ. Ḿpʋ́ɣʋ́ pɑ kʋlɑ ɑhoo ɑnɩ nɑ pɑ́ kpe. ");
INSERT INTO dop_vpl VALUES ("S129_1","010_29_1","1SA","29","1","1","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ kotɑ pɑ yoolɑɑ kɛ timpi pɑ yɑɑkɩ sɩ, Afekɑ tɔ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ́ɑ́ koti pɑ nyǝ́mɑ kɛ Sisilee hite nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S129_2","010_29_2","1SA","29","2","2","Ɩlɛnɑ Filiisi ɑwulɑɑ nɑ yoolɑɑ nɩɩnʋwɑ (100) kpekǝle, nɑ iyɑɣɑ (1000) kpekǝle pɑ tɔ́ nɑ pɑ́ tɛɛ. Pǝ kɑɑsɑ Tɑfiiti nɑ ɩ́lɛ́ ɩ nyǝ́mɑ nɑ Akisi kɛ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Ntɛnɑ Filiisi yoolɑɑ sɔsɑɑ pɔɔsɩ Akisi sɩ: Hepǝlɑ nyǝ́mɑ mpɛ pɑ cɑɑ weɣe cǝnɛ? Kɛlɛnɑ Akisi sɩ: Ɩsɛɣɛlɩ wulɑʋ tǝmlɛ tʋ Tɑfiiti kɛ́ té. Ɩ wɛʋ mɑ kiŋ tɔ pǝ tɑɑŋɑɑ kɛ́. Pǝ́cɔ́ mɑ tɑ keesi-ɩ nɑ ɩsɑɣɑtiyɑ nɑkǝlǝɣɩ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Tǝnɑɣɑ pɑ mʋ Akisi nɑ pɑ́ɑ́nɑ́ nɑ pɑ́ tɔmɩ-ɩ sɩ: Mǝlǝnɑ-ɩ lonte nte tǝ tɑɑ n kɑ hʋlɑ-ɩ sɩ ɩ́ cɑɣɑ tɔ. Ɩ́ tɑɑ tǝŋ tɑ́ wɑɑlɩ kɛ tǝyoole, nɑ pǝ́ kɔɔ nɑ yoou hɑŋ ɩlɛnɑ ɩ́ pǝsɩ tɑ kolontu. N tɑ nyɩ tɑɑ sɩ tɑ yǝlɑɑ pɑnɛɣɛ ɩ kɑ́ kʋ, ɩlɛnɑ pǝ́ ciiki ɩ́ nɑ ɩ cɑɑ? ");
INSERT INTO dop_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Mɑtɔŋ Tɑfiiti ɩnǝɣɩ pɑɑ yookɑɣɑnɑ yontu nɑ pɑɑlɛ sɩ: Sɑyuli kʋwɑ yǝlɑɑ iyɑɣɑ (1000) kɛ huɣule. Tɑfiiti nɑ́ɑ́ kʋ iyisi nɑɑnʋwɑ (10000) kɛ huɣule. ");
INSERT INTO dop_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Mpʋɣʋlɛ Akisi yɑɑ Tɑfiiti nɑ ɩ tɔmɩ-ɩ sɩ: Mɑ tuunɑ Tɑcɑɑ sɩ n kɛ́ tɑmpɑnɑ tǝŋlʋ kɛ́, nɑ mɑ nyɩɩlǝɣɩ sɩ mɑ́ nɑ-ŋ tǝ́ puki yoou. Mpi tɔ, hɑtoo n kɔm mɑ kiŋ nɑ pǝ́ sɩɩnɑ sɑŋɑ tɔ, mɑ tɑ nɑtɑ ɩsɑɣɑtiyɑ nɑkǝlǝɣɩ nyɑ́ kiŋ. Amɑ Filiisi ɑwulɑɑ lɛlɑɑ ɩɩ cɑɑkǝnɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Mpʋ tɔ, mǝlɩ tǝhɛɛ, pǝ tɑɑ kɔɔ nɑ ń lɑ mpi pǝ tɑ mɑɣɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","Ntɛnɑ Tɑfiiti sɩ: Tɑ cɑɑ, wulɑʋ, ɩlɛ pepeɣe mɑ lɑpɑ? Tuu mɑ kɔm nyɑ́ kiŋ cǝnɛ nɑ pǝ́ sɩɩnɑ sɑŋɑ tɔ, ɩsɑɣɑtʋ ntiɣi n nɑwɑ mɑ kiŋ nɑ pǝ fɛɩ sɩ mɑ́ nɑ-ŋ tǝ́ polo yoou? ");
INSERT INTO dop_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Mpʋɣʋlɛ Akisi sɩ: Nɑtǝlɩ tǝ fɛɩ mɑ kiŋ, hɑlɩ n tɩɩ wɛ mɑɣɑ teu kɛ́ ɩsɩɩ Ɩsɔ tillu. Amɑ ɑwulɑɑ sǝkpemɑ mpɛ pɑ tɔmnɑ sɩ pǝ fɛɩ sɩ tɑ́ nɑ-ŋ tǝ́ polo yoou. ");
INSERT INTO dop_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Mpʋ tɔ, nyɑ́ nɑ mpɑ ɩ́ lɩɩ Sɑyuli kiŋ nɑ ɩ́ kɔɔ tɔ, cele tɑnɑŋ ye pǝ nyɑɑlɑɑ ɩ́ kʋlɩ lɔŋ nɑ ɩ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Tɛʋ femɑ, ɩlɛnɑ Tɑfiiti-wɛ pɑ́ kʋlɩ lɔŋ nɑ pɑ́ mǝlɩ timpi pɑɑ wɛɛ tɔ. Ɩlɛnɑ Filiisi nyǝ́mɑ nɑ́ɑ́ polo Sisilee. ");
INSERT INTO dop_vpl VALUES ("S130_1","010_30_1","1SA","30","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti nɑ ɩ yǝlɑɑ pɑ tɑlɑ pɑ tǝcɑɣɑlɛ kɛ kʋyɑkʋ tooso nyǝŋkʋ wule. Ɩlɛnɑ pɑ́ mɑɣɑnɑ Amɑleke nyǝmɑ wɑtɑ Yutɑ nɑ ilim mpǝtǝŋ tɔɔ, nɑ pɑ́ sɔ Sikǝlɑkɩ ɩcɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S130_2","010_30_2","1SA","30","2","2","Ɩlɛnɑ pɑ́ kpɑ ɑlɑɑ nɑ sɔsɑɑ nɑ piyɑ mpɑ pɑɑ wɛ tǝ tɑɑ tɔ. Pɑ kuu pɑ tǝnɑɣɑ nɑ pɑ́ tʋnɑ mpɑɑʋ. Amɑ pɑ tɑ kʋ pɑ tɑɑ nɔɣɔlʋ. ");
INSERT INTO dop_vpl VALUES ("S130_3","010_30_3","1SA","30","3","3","Tɑfiiti nɑ ɩ yǝlɑɑ pɑ tɑlɑ ɩcɑtɛ tɑɑ, ɩlɛnɑ pɑ́ mɑɣɑnɑ pɑ sɔpɑ-tɛɣɛ kɔkɔ. Ḿpʋ́ɣʋ́ pɑ kpɑ pɑ ɑlɑɑ nɑ pɑ ɑlʋpiyɑ nɑ pɑ ɑpɑlʋpiyɑ kɛ yomle. ");
INSERT INTO dop_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Ḿpʋ́ɣʋ́ pɑ tʋlɑ nɔɔsɩ nɑ pɑ́ wii tǝkpoo ɩsɩɩ pɑ sǝkɩ pɑ sǝkɩ. ");
INSERT INTO dop_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","Pɑ kpɛŋnɑ Tɑfiiti ɑlɑɑ nɑɑlɛɣɛ nɑ pɑ́ kpɑɣɑ. Sisilee tʋ Ahinowɑm nɑ Kɑmɛɛlɩ tʋ Apikɑɑlɩ wei ɩ kɛ́ Nɑpɑɑlɩ leelu tɔ. ");
INSERT INTO dop_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Mpʋɣʋlɛ Tɑfiiti lɑŋlɛ pǝsɑ kɑtɑtǝlɑɣɑ. Mpi tɔ, ɩ yǝlɑɑ kɑ wɛnɑ-ɩ nɑ hʋwɛɛ nyɑŋ nyǝnɑ kɛ pɑ piyɑ tɔɔ kɛ́. Hɑlɩ pɑ́ kʋlɩ sɩ pɑ yɑkɩ-ɩ pɛɛ. Ɩlɛnɑ Tɑcɑɑ sɔɔsɩ-ɩ ɑpɑlʋtʋ. ");
INSERT INTO dop_vpl VALUES ("S130_7","010_30_7","1SA","30","7","7","Ɩlɛnɑ Tɑfiiti tɔ Ahimelɛkɩ pǝyɑlʋ Apiyɑtɑɑ wei ɩ kɛ́ kɔtʋlʋ tɔ sɩ: Kɔnɑ-m kɔtǝlɑɑ toko wei pɑ pɔɔsǝɣǝnɑ Tɑcɑɑ kɛ tɔm tɔ. Apiyɑtɑɑ ponɑ-ɩ, ");
INSERT INTO dop_vpl VALUES ("S130_8","010_30_8","1SA","30","8","8","ɩlɛnɑ ɩ́ pɔɔsɩ Tɑcɑɑ sɩ: Ye mɑ tǝŋɑ kolontunɑɑ mpɛ mɑɑ hiki-wɛ? Tɑcɑɑ sɩ: Tɔɣɔnɩ-wɛ n kɑ́ hiki-wɛ nɑ ń wɑɑsɩ yǝlɑɑ mpɛ. ");
INSERT INTO dop_vpl VALUES ("S130_9","010_30_9","1SA","30","9","9","Ɩlɛnɑ Tɑfiiti nɑ ɩ yǝlɑɑ nɑsǝtoso (600) pɑ́ tʋ pɑ wɑɑlɩ. Pɑ tɑlɑ Pesɔɔ lɔɔʋ ");
INSERT INTO dop_vpl VALUES ("S130_10","010_30_10","1SA","30","10","10","ɩlɛnɑ yǝlɑɑ ŋmʋnʋɣʋ (200) sɑɑlɩ tǝnɑ. Mpi tɔ, pɑ sulɑ kɑʋ. Pǝ kɑɑsɑ nɑsǝlɛ (400), ɩlɛnɑ pɛlɛ nɑ Tɑfiiti pɑ́ tʋɣʋtɩ. ");
INSERT INTO dop_vpl VALUES ("S130_11","010_30_11","1SA","30","11","11","Ḿpʋ́ɣʋ́ pɑ sulɑ Icipiti tʋ nɔɣɔlʋ, nɑ pɑ́ ponɑ-ɩ Tɑfiiti kiŋ nɑ pɑ́ hɑ-ɩ tɔɣɔnɑɣɑ nɑ lʋm. ");
INSERT INTO dop_vpl VALUES ("S130_12","010_30_12","1SA","30","12","12","Pɑ hɑ-ɩ tɔtɔɣɔ fiki pee kʋwʋlɛɛ pɑɣɑlɛ, nɑ lɛsɛŋ kʋwʋlʋ pɑɣɑ kɛ nɑɑlɛ, nɑ ɩ́ tɔɣɔ nɑ ɩ́ lɑ́ ɑlɑɑfǝyɑ. Mpi tɔ, kʋyɛɛŋ tooso kɛ ɩ tɑ tɔɣɔ ɩ tɑ nyɔɔ. ");
INSERT INTO dop_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Ntɛnɑ Tɑfiiti pɔɔsɩ-ɩ sɩ: Awe tǝnɑ-ŋ nɑ leɣe n lɩɩnɑɑ? Kɛlɛnɑ ɩ́lɛ́ sɩ: Mɑ kɛ́ Icipiti tʋ kɛ́, Amɑleke tʋ nɔɣɔlʋ ɩ kɑ tɔkǝnɑ-m yomle. Sɑŋɑ tɑɑ kʋyɛɛŋ tooso kɔlɔ pǝ wɩɩkɑɣɑ-m nɑ ɩ́ lɔ-m tɔ. ");
INSERT INTO dop_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","Tɑ wɑtǝnɑ Kǝletɩ nyǝ́mɑ tɛtʋ ilim mpǝtǝŋ hɔɣɔlʋɣʋ tɔɔ kɛ́ Yutɑ tɛtʋ tɑɑ, nɑ Kɑlɛpʋ tɛtʋ, nɑ tǝ́ sɔ Sikǝlɑkɩ ɩcɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","Ntɛnɑ Tɑfiiti sɩ: N kɑ ponɑ-m yoolɑɑ mpɛ ɩnɩ pɑ kiŋ nɑ? Kɛlɛnɑ yom cɔ sɩ: Tuunɑ Ɩsɔ hǝtɛ sɩ n kɑɑ kʋ-m. Pǝyele n kɑɑ cɛlɛ-m mɑ cɑɑ, ɩlɛnɑ pǝ́cɔ́ mɑ́ ponɑ-ŋ pɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Apɑlʋ ɩnɩ ɩ kpɑɣɑ Tɑfiiti nɑ ɩ́ ponɑ-ɩ nɑ pɑ́ mɑɣɑnɑ Amɑleke nyǝ́mɑ kɛ sɔsɔm kɛ tǝnɑ, nɑ pɑ́ tɔkɩ nɑ pɑ́ nyɔɔkɩ nɑ pɑ́ pɑɑkɩ. Wontu nti pɑɑ lɛɛkɑ Filiisi nyǝ́mɑ nɑ Yutɑ nyǝ́mɑ tɔ tǝ tɔɔ kɛ́ pɑ lɑkɑɣɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Ḿpʋ́ɣʋ́ Tɑfiiti kʋ-wɛɣɛ tɑnɑŋ ŋkʋ. Hɑlǝnɑ tɛʋ kʋfemuɣu tɑɑnɑɣɑ, pɑ tɑɑ nɔɣɔlʋ tɑ fiti. Ye pǝ tɑɣɑ ɩfepiyɑ nɑsǝlɛ (400) wei ɩ cɑɣɑ yooyoonɑɑ nɑ ɩ́ se tɔ. ");
INSERT INTO dop_vpl VALUES ("S130_18","010_30_18","1SA","30","18","18","Ḿpʋ́ɣʋ́ ɩ lɛɛkɑ pɑ tǝnɑ mpɑ Amɑleke nyǝ́mɑ kɑ kpɑwɑ tɔ, nɑ ɩ ɑlɑɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S130_19","010_30_19","1SA","30","19","19","Tɑfiiti lɛɛkɑ pɑ piyɑ tǝnɑɣɑ tǝcɛɩcɛɩ, nɑ pɑ wontunɑɑ mpɑ kolontunɑɑ kɑ kuuwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","Nɑ ɩ́ lɛɛkɩ Amɑleke nyǝ́mɑ tɔlɑ tǝnɑ nɑ ɑ tiikilɑɑ yɔɣɔtǝɣɩ sɩ: Tɑfiiti tɔlɑ ntɔ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Pɑ kɔmɑ pɑ tɑlɑ yǝlɑɑ ŋmʋnʋɣʋ (200) ŋku kɩɩ kɑwɑ nɑ kʋ́ sɑɑlɩ Pesɔɔ lɔɔʋ nɔɣɔ tɔ, ɩlɛnɑ pɛlɛ pɑ́ polo-wɛɣɛ sǝŋʋɣʋ, nɑ Tɑfiiti kpǝtǝnɑ-wɛ nɑ ɩ́ sɛɛ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","Mpʋɣʋlɛ mpɑ pɑɑ tǝŋɑ Tɑfiiti tɔ, pɑ tɑɑ tɛtɛlɑtɑɑ nɑ ɑsɑɣɑɑ pɑ tɔmɑ sɩ: Timpi pɑnɛ pɑ tɑ pǝsɩ nɑ pɑ́ polo kolontunɑɑ tǝkʋlɛ tɔ, tɑ kɑɑ hɑ-wɛɣɛ mpi tǝ hikɑ tǝnɑ tɔ pǝ tɑɑ pʋlʋ. Amɑ pɑ ɑlɑɑ nɑ pɑ piyɑ tike kɛ pɑɑ kɛlɩ nɑ pɑ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Ntɛnɑ Tɑfiiti sɩ: Apɑlɑɑ mɛ, ɩ́ tɑɑ lɑ mpʋ. Mpi tɔ, Tɑcɑɑ yɑpǝnɑ-tʋ nɑ ɩ́ tʋ́ tɑ́ niŋ tɑɑ kɛ́ tɑ kolontunɑɑ nɑ ɩ́ hɑ-tʋɣʋ pǝ tǝnɑ ɩsǝntɔ. ");
INSERT INTO dop_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Nɔɣɔlʋ kɑɑ mʋ mǝ tɔm ntɩ. Ɩlɛ pǝ wɛɛ kɛ́ sɩ mpɑ pɑ polɑ tǝyoole tɔ, nɑ mpɑ pɑ tɑŋɑ wontu tɔ pɑ́ tɑlɑ wontunɑɑ mpɛɣɛ teitei. ");
INSERT INTO dop_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Pǝ kpɑɣɑʋ kʋyɑkʋ ŋkʋ nɑ pǝ́ puki tɔɣɔ Ɩsɛɣɛlɩ nyǝ́mɑ sʋʋ ḿpʋ́ɣʋ́ lɑpʋ, nɑ pǝ́ pǝsɩ ɩsɩɩ kiiu. ");
INSERT INTO dop_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Pɑ mǝlɑ Sikǝlɑkɩ, ɩlɛnɑ Tɑfiiti cosi kolontunɑɑ wontu nti pɑ hikɑ mpʋ tɔ tǝ tɑɑ, nɑ ɩ́ hɑ Yutɑ nyʋɣʋ nyǝ́mɑ nɑ ɩ tɑɑpɑlɑɑ sɩ: Tɑcɑɑ kolontunɑɑ kɛ tǝ lɛɛkɑɑ nɑ tǝ́ cosi nɑ tǝ́ hɑ-mɛ. ");
INSERT INTO dop_vpl VALUES ("S130_27","010_30_27","1SA","30","27","27","Mpɑ mpɑ ɩ hɑwɑ tɔɣɔlɛ, Petɛɛlɩ nyǝ́mɑ, nɑ Lɑmɑ nyǝ́mɑ kɛ Nekɛfɩ wʋlɑɣɑ tɛtʋ tɑɑ, nɑ Yɑtii nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("S130_28","010_30_28","1SA","30","28","28","nɑ Alʋwɛɛ nyǝ́mɑ, nɑ Sifimɔtɩ nyǝ́mɑ nɑ Ɩsǝtemʋwɑ nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("S130_29","010_30_29","1SA","30","29","29","nɑ Lɑkɑɑlɩ nɑ Yelɑmeli ɑcɑlɛɛ nyǝ́mɑ nɑ Keni nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("S130_30","010_30_30","1SA","30","30","30","nɑ Hoomɑ nyǝ́mɑ nɑ Pɔɔ-Asɑŋ nyǝ́mɑ nɑ Atɑkɩ nɑ Hepǝlɔŋ nyǝ́mɑ, ");
INSERT INTO dop_vpl VALUES ("S130_31","010_30_31","1SA","30","31","31","nɑ timpi timpi Tɑfiiti nɑ ɩ yǝlɑɑ pɑɑ cɔɔsɑɑ tɔ pǝ nyǝ́mɑnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Wɑɑtʋ ɩnɩ ɩ tɑɑ kɛ́ kʋyɑkʋ nɑkʋlɩ, Filiisi nyǝ́mɑ yoonɑ Ɩsɛɣɛlɩ nyǝ́mɑ, nɑ pɑ́ tɔɣɔnɩ-wɛ nɑ pɑ́ kʋ-wɛɣɛ Kilipʋwɑ pʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Ɩlɛnɑ pɑ́ tʋ́ Sɑyuli pɑ wɑɑlɩ nɑ pɑ́ kʋ ɩ pǝyɑlɑɑ Sonɑtɑŋ nɑ Apinɑtɑpɩ nɑ Mɑlǝkisuwɑ. ");
INSERT INTO dop_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Ḿpʋ́ɣʋ́ pǝ wiisinɑ Sɑyuli nɑ pɑ́ yɑɣɑ-ɩ nyǝ́mɑ kɛ teu. ");
INSERT INTO dop_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Ɩlɛnɑ ɩ́ tɔ ɩ yoou wontu tɔkʋlʋ sɩ: Kpɛɛ nyɑ́ lɑɣɑtɛ nɑ ń tɛɛsɩ-m. Pǝ́ tɑɑ kɔɔ nɑ Filiisi mɑ tɑ nyɩ ɩsɔnɑɑ mpɛ pɑ́ kɔɔ pɑ́ tɛɛsɩ-m nɑ pɑ́ pɑɑnɑ-m. Amɑ sɔɣɔntʋ kpɑ yoou wontu tɔkʋlʋ nɑ ɩ́ kisi. Tǝnɑɣɑlɛ Sɑyuli sikɑ ɩ lɑɣɑtɛ nɑ ɩ́ yele ɩ tɩ nɑ ɩ́ hoti tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Yoou wontu tɔkʋlʋ nɑ́ mpʋ, ɩlɛnɑ ɩ́lɛ́ ɩ́ hoti ɩ nyǝntɛ tɔɔ kɛ́ mpʋ tɔtɔ nɑ ɩ́ sɩ. ");
INSERT INTO dop_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Sɑyuli nɑ ɩ pǝyɑlɑɑ tooso, nɑ ɩ yoou wontu tɔkʋlʋ, nɑ ɩ yǝlɑɑ tǝnɑ pɑ sǝpǝnɑ kʋyɑkʋ ŋkʋ. ");
INSERT INTO dop_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ mpɑ pɑɑ wɛ Sisilee lɔɔʋ wɑɑlɩ, nɑ Yɑɑtɑnɩ pɔɣɔ wɑɑlɩ tɔ, pɑ nɩɩwɑ sɩ Sɑyuli nɑ ɩ pǝyɑlɑɑ pɑ sǝpɑ nɑ Ɩsɛɣɛlɩ yoolɑɑ seeki. Tǝnɑɣɑ pɛlɛ pɑ lɩɩ pɑ ɑcɑlɛɛ tɑɑ nɑ pɑ́ se tɔtɔ. Ɩlɛnɑ Filiisi nyǝ́mɑ polo nɑ pɑ́ cɑɣɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Tɛʋ femɑ, ɩlɛnɑ Filiisi nyǝ́mɑ polo sɩ pɑ kpɑkǝɣɩ sǝtɑɑ wontu. Ḿpʋ́ɣʋ́ pɑ mɑɣɑnɑ Sɑyuli nɑ ɩ pǝyɑlɑɑ tooso pɑ sǝpɑ Kilipʋwɑ pʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S131_9","010_31_9","1SA","31","9","9","Ɩlɛnɑ pɑ́ sɛtɩ Sɑyuli nyʋɣʋ nɑ pɑ́ wɔɣɔsɩ ɩ yoou wontu. Pǝ wɑɑlɩ kɛ́ pɑ yɑsɑ tɔm kʋpɑntʋ ntǝɣɩ Filiisi nyǝ́mɑ tɛtʋ tɑɑ, nɑ pɑ tɩɩŋ kutuluŋ tɑɑ nɑ yǝlɑɑ tǝnɑ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("S131_10","010_31_10","1SA","31","10","10","Ɩlɛnɑ pɑ́ sɩɩ Sɑyuli wontu kɛ tʋɣʋ Asǝtɑtɩ kutuluɣu tɑɑ. Ḿpʋ́ɣʋ́ pɑ kɑmɑ Sɑyuli mɑɣɑmɑɣɑ kɛ ɩcɑtɛ nte pɑ yɑɑ sɩ Pɛtɩ-Seyɑŋ tɔ tǝ koluŋɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Wɑɑtʋ wei Yɑpɛɛsɩ nyǝ́mɑ nɩɩwɑ ɩsǝnɑ Filiisi nyǝ́mɑ lɑpɑ Sɑyuli tɔ. ");
INSERT INTO dop_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","Ḿpʋ́ɣʋ́ ɑpɑlɑɑ tɑɑ ɑpɑlɑɑ kotɑɑ, nɑ pɑ́ tɔ ɑhoo tǝnɑ nɑ pɑ́ polo Pɛtɩ-Seyɑŋ nɑ pɑ́ lǝsɩ Sɑyuli nɑ ɩ pǝyɑlɑɑ, nɑ pɑ́ ponɑ-wɛɣɛ Yɑpɛɛsɩ nɑ pɑ́ wɔ-wɛɣɛ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Ɩlɛnɑ pɑ́ lǝsɩ pɑ mʋwɑ nɑ pɑ́ pi tʋɣʋ nɑkʋlɩ kʋ tɛɛ. Ɩlɛnɑ pɑ́ hɔkɔ nɔɔsɩ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S21_1","011_1_1","2SA","1","1","1","Sɑyuli sǝm wɑɑlɩ kɛ́ Tɑfiiti lɩɩnɑ Amɑleke nyǝ́mɑ tǝkʋlɛ nɑ ɩ́ mǝlɩ Sikǝlɑkɩ nɑ ɩ́ cɑɣɑ tǝnɑɣɑ kʋyɛɛŋ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S21_2","011_1_2","2SA","1","2","2","Kʋyɑkʋ tooso nyǝŋkʋ wule kɛ nɔɣɔlʋ sewɑ Sɑyuli pɑ tǝsikile nɑ ɩ́ cǝlɑ ɩ wontu nɑ lɑŋwɑkǝllɛ, nɑ ɩ́ pǝlɑ ɩ nyʋɣʋ tɑɑ kɛ́ tɛtʋ. Ɩ tɑlɑ Tɑfiiti, ɩlɛnɑ ɩ́ hǝntɩ-ɩ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S21_3","011_1_3","2SA","1","3","3","Mpʋɣʋlɛ Tɑfiiti pɔɔsɑ-ɩ sɩ: N lɩɩnɑ le? Ɩlɛnɑ Selu cɔ sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ tǝsikile kɛ mɑ sewɑ. ");
INSERT INTO dop_vpl VALUES ("S21_4","011_1_4","2SA","1","4","4","Ntɛnɑ Tɑfiiti sɩ: Heeli-m mpi pǝ lɑpɑ tɔ. Kɛlɛnɑ Selu sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ sewɑ pɑ kolontunɑɑ nɑ pɑ tɑɑ pɑɣɑlɛ sǝpɑ. Hɑlɩ Sɑyuli nɑ ɩ pǝyɑlʋ Sonɑtɑŋ pɛlɛ pɑ sǝpɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S21_5","011_1_5","2SA","1","5","5","Mpʋɣʋlɛ Tɑfiiti pɔɔsɑ ɩfepu wei ɩnɩ ɩ kɔnɑ-ɩ tɔm ntɩ tɔ sɩ: Sɑyuli nɑ Sonɑtɑŋ pɑ sǝpɑ yɑɑ, ɑwe heelɑ-ŋ? ");
INSERT INTO dop_vpl VALUES ("S21_6","011_1_6","2SA","1","6","6","Ntɛnɑ ɩfepu ɩnɩ sɩ: Mɑ mɑɣɑnɑ Sɑyuli sǝŋnɑ ɩ ŋmɑntɑɑɣɑ kɛ Kilipʋwɑ pʋɣʋ tɑɑ kɛ́ nɑ kolontunɑɑ yoou kɛɛkɛnɑɑ kpɛɣɛtǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S21_7","011_1_7","2SA","1","7","7","Ɩ pǝsɑ ɩ wɑɑlɩ nɑ ɩ́ nɑ-m ɩlɛnɑ ɩ́ yɑɑ-m nɑ mɑ́ polo. ");
INSERT INTO dop_vpl VALUES ("S21_8","011_1_8","2SA","1","8","8","Ntɛnɑ ɩ́ pɔɔsɩ-m sɩ: N kɛ́ le tʋ? Mɑ sɩ: Mɑ kɛ́ Amɑleke tʋ. ");
INSERT INTO dop_vpl VALUES ("S21_9","011_1_9","2SA","1","9","9","Kɛlɛnɑ ɩ́ tɔ-m sɩ: Pɑɑ nɑ mɑ tɔŋnɑ feesuɣu tɔ kɔɔ ń tɛɛsɩ-m. Mɑ ɩsɛntɔɔ tɔŋnɑ piluɣu kɛ́. ");
INSERT INTO dop_vpl VALUES ("S21_10","011_1_10","2SA","1","10","10","Tɔʋ, tɑ cɑɑ, mɑ nɑwɑ sɩ pɑɑ mɑ yelɑ-ɩ ɩ kɑɑ lɑ weesuɣu, ɩlɛnɑ mɑɑ kʋ-ɩ. Kɛnɑ mɑ́ wɔɣɔsɩ ɩ ntenuɣu nɑ ɩ kpɑlɑɣɑ nɑ mɑ́ kɔnɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S21_11","011_1_11","2SA","1","11","11","Tǝnɑɣɑlɛ Tɑfiiti kpɑ ɩ tɔɔ wontu kʋsusuutu nɑ ɩ́ cǝlǝnɑ lɑŋwɑkǝllɛ nɑ ɩ cɔlɔ nyǝ́mɑ nɑ́ɑ́ lɑ mpʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S21_12","011_1_12","2SA","1","12","12","Ḿpʋ́ɣʋ́ pɑ wii Sɑyuli nɑ Sonɑtɑŋ, nɑ Ɩsɛɣɛlɩ nyǝ́mɑ cɑɣɑ pɑ lǝyɑɣɑ nɑ pɑ́ hɔkɔ nɔɔsɩ hɑlǝnɑ tɑɑnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S21_13","011_1_13","2SA","1","13","13","Mpʋɣʋlɛ Tɑfiiti tɑsɑ ɩfepu wei ɩ kɔnɑ-ɩ tɔm ntɩ tɔɣɔ pɔɔsʋɣʋ sɩ: Nyɑ́ sɩ n kɛ́ le tʋ yee? Ɩ́lɛ́ sɩ: Mɑ cɑɑ kɛ́ Amɑleke tʋ kɛ́ nɑ ɩ́ cɑɣɑ cɑɣɑlǝtʋ kɛ Ɩsɛɣɛlɩ. ");
INSERT INTO dop_vpl VALUES ("S21_14","011_1_14","2SA","1","14","14","Kɛlɛnɑ Tɑfiiti sɩ: Ɩsǝnɑɣɑ pǝ lɑpɑ nɑ ń mɑ kɑŋkɑntɛ nɑ ń kʋ́ Ɩsɔ kʋlǝsʋ. ");
INSERT INTO dop_vpl VALUES ("S21_15","011_1_15","2SA","1","15","15","Ḿpʋ́ɣʋ́ ɩ yɑɑ ɩ yǝlɑɑ tɑɑ nɔɣɔlʋ nɑ ɩ́ heeli-ɩ sɩ: Kʋ Amɑleke tʋ ɩnɩ. Ɩlɛnɑ ɩ́lɛ́ ɩ kʋlɩ nɑ ɩ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S21_16","011_1_16","2SA","1","16","16","Mpʋɣʋlɛ Tɑfiiti sɩ: Nyɑ́ sǝm ɩ́ wɛɛ nyɑ́ tɔm. Mpi tɔ, nyɑ́ nɔɣɔ pɛɛtǝnɑ-ŋ, timpi n yɔɣɔtɑɑ sɩ n kʋ́ Tɑcɑɑ kʋlǝsʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S21_17","011_1_17","2SA","1","17","18","Lǝyɑɣɑ wulɑ nnɑ Tɑfiiti wiiwɑ Sɑyuli nɑ ɩ pǝyɑlʋ Sonɑtɑŋ pɑ tɔɔ nɑ pɑ́ ŋmɑɑ-yɛɣɛ Siɣisuɣu Tǝŋlʋ tɑkǝlɑɣɑ tɑɑ tɔɣɔlɔ. Tɑfiiti cɑɑkɩ sɩ pɑɑ Yutɑ tʋ wei ɩ́ nyɩ-yɛ. ");
INSERT INTO dop_vpl VALUES ("S21_19","011_1_19","2SA","1","19","19","Ɩsɛɣɛlɩ yoolɑɑ tɑɑ yoolɑɑ kpisɑ nɑntʋ kɛ pulɑsɩ tɑɑ. Hɑlɩ ɑkɑnɑɑ tɑɑ ɑkɑnɑɑ hotinɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("S21_20","011_1_20","2SA","1","20","20","Ɩ́ tɑɑ heeli-tǝɣɩ Kɑtɩ nyǝ́mɑ. Pǝyele ɩ́ tɑɑ yɔɣɔtɩ-tǝɣɩ Asǝkɑlɔŋ mpɑɑŋ tɑɑ. Pǝ fɛɩ sɩ Filiisi mɑ tɑ nyɩ ɩsɔnɑɑ ɑlɑɑ nɑ pɑ pɛɛlɑɑ ɩ́ ŋmɑɑlǝnɑ-tɩ. ");
INSERT INTO dop_vpl VALUES ("S21_21","011_1_21","2SA","1","21","21","Kilipʋwɑ pulɑsɩ kɑɑ tɑsɑ ɩhunte kɛ nɑʋ. Pǝyele sɩ kɑɑ nɑ tɛʋ tɔtɔ. Sɩ tɛtʋ tǝnɑ ɩ́ sɩ. Tǝnɑɣɑ ɑkɑnɑɑ kpɑlǝŋ wɑkǝlɑɑ. Pɑ kɑɑ tɑsɑ Sɑyuli kpɑlʋɣʋ kɛ nim sɑlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S21_22","011_1_22","2SA","1","22","22","Sonɑtɑŋ ɩɩ tɔɔkɩ nyǝmlɛ nɑ ɩ́ tii ɑtɛ. Pǝyele Sɑyuli nɑ́ɑ́ kpɛɛkɩ lɑɣɑtɛ nɑ tǝ́ mǝlɩ yem. Pɑ kʋwɑ kolontunɑɑ tuutuumɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S21_23","011_1_23","2SA","1","23","23","Sɑyuli nɑ Sonɑtɑŋ pɑ luuŋ kɑ sʋʋ tǝmɑɣɑ. Pɑ kpɛntɑ kʋlʋm kɛ ḿpʋ́ɣʋ́ hɑlǝnɑ pɑ sǝm. Pɑ lɔŋlɔŋ lɑpʋ tɛɛ ŋmɑkǝlɛ. Pǝyele pɑ kǝlɑ tɔɣɔlɑsɩ kɛ toŋ. ");
INSERT INTO dop_vpl VALUES ("S21_24","011_1_24","2SA","1","24","24","Ɩsɛɣɛlɩ ɑlɑɑ mɛ, ɩ́ wii Sɑyuli. Ɩnɩ ɩ suukɑɣɑnɑ-mɛɣɛ wontu kʋpɑntʋ, nɑ ɩ tʋɣɩ mǝ tɔɔ kɛ́ kɑcɔkɑ nyǝmnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S21_25","011_1_25","2SA","1","25","25","Akɑnɑɑ tɑɑ ɑkɑnɑɑ hotɑ tǝyoole. Sonɑtɑŋ kpisɑ tɔnʋɣʋ kɛ pulɑsɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S21_26","011_1_26","2SA","1","26","26","Mɑ ceu Sonɑtɑŋ, nyɑ́ sǝm tɔm wɩɩ-m kɛ́. N kɑ sɔɔlɑ-m kɛ́ nɑ pǝ kǝlɩ ɩsɩɩ ɑlʋ, nɑ n hɛɛsǝɣɩ mɑ lɑŋlɛ. ");
INSERT INTO dop_vpl VALUES ("S21_27","011_1_27","2SA","1","27","27","Yoolɑɑ tɑɑ yoolɑɑ sǝpɑ. Akɑnɑɑ lepɑ yem. ");
INSERT INTO dop_vpl VALUES ("S22_1","011_2_1","2SA","2","1","1","Pǝlɛ pǝ wɑɑlɩ kɛ́ Tɑfiiti pɔɔsɑ Tɑcɑɑ sɩ: Mɑ́ mǝlɩ Yutɑ? Tɑcɑɑ sɩ: Ɛɛ, mǝlɩ. Nɑ ɩcɑtɛ nte tǝ tɑɑ kɛ́ mɑɑ cɑɣɑ? Ntɛnɑ Tɑcɑɑ sɩ: Polo Hepǝlɔŋ. ");
INSERT INTO dop_vpl VALUES ("S22_2","011_2_2","2SA","2","2","2","Ḿpʋ́ɣʋ́ Tɑfiiti kpɑɣɑ ɩ ɑlɑɑ nɑɑlɛ, Sisilee tʋ Ahinowɑm nɑ Kɑmɛɛlɩ tʋ Apikɑɑlɩ wei ɩ kɛ́ Nɑpɑɑlɩ leelu tɔ nɑ ɩ́ kpɛŋnɑ. ");
INSERT INTO dop_vpl VALUES ("S22_3","011_2_3","2SA","2","3","3","Nɑ ɩ yǝlɑɑ mpɑ pɑɑ wɛ ɩ kiŋ tɔ, nɑ pɑ ɑlɑɑ nɑ pɑ piyɑ nɑ pɑ́ polo pɑ́ cɑɣɑ Hepǝlɔŋ. ");
INSERT INTO dop_vpl VALUES ("S22_4","011_2_4","2SA","2","4","4","Ɩlɛnɑ Yutɑ nyǝ́mɑ polo nɑ pɑ́ kpɑ Tɑfiiti kɛ wulɑʋ kɛ Yutɑ tɑɑ. Ḿpʋ́ɣʋ́ pɑ heelɑ Tɑfiiti sɩ Yɑpɛɛsɩ Kɑlɑɑtɩ nyǝ́mɑ pimnɑ Sɑyuli. ");
INSERT INTO dop_vpl VALUES ("S22_5","011_2_5","2SA","2","5","6","Ntɛnɑ ɩ́ tili sɩ pɑ́ heeli-wɛ sɩ: Tɑcɑɑ ɩ́ kooli-mɛɣɛ kʋpɑntʋ nɑ ɩ́ fɛlɩ-mɛɣɛ timpi ɩ́ pimɑ mǝ cɑɑ Sɑyuli tɔ. Ɩlɛ mɑɑ sɔɔsɩ-mɛɣɛ kʋpɑntʋ lɑpʋ. ");
INSERT INTO dop_vpl VALUES ("S22_7","011_2_7","2SA","2","7","7","Mpʋ tɔ, Yɑpɛɛsɩ nyǝ́mɑ ɩ́ kɑɑsɩ mǝ tɩ nɑ ɩ́ nyɔɔ toŋ. Mpi tɔ, mǝ cɑɑ Sɑyuli sǝpɑ tɔ mɑɣɑ Yutɑ nyǝ́mɑ sɩɩ ɩ lonte kɛ Yutɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S22_8","011_2_8","2SA","2","8","8","Amɑ Nɛɛ pǝyɑlʋ Apǝnɛɛ wei ɩ kɛ́ Sɑyuli yoolɑɑ nyʋɣʋ tʋ tɔ ɩ seenɑ Sɑyuli pǝyɑlʋ Ɩsǝpɑɑlɩ nɑ ɩ́ ponɑ-ɩ Mɑhɑnɑyim, ");
INSERT INTO dop_vpl VALUES ("S22_9","011_2_9","2SA","2","9","9","nɑ ɩ́ kpɑ-ɩ wulɑʋ kɛ Kɑlɑɑtɩ nyǝ́mɑ nɑ Asɛɛ nyǝ́mɑ nɑ Sisilee nyǝ́mɑ nɑ Ɩfǝlɑyim nyǝ́mɑ nɑ Pɛncɑmɛɛ nyǝ́mɑ tɔɔ. Ɩsɛɣɛlɩ tɛtʋ tǝnɑ wulɑʋ kɛ ɩ́ kpɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S22_10","011_2_10","2SA","2","10","10","Wɑɑtʋ wei pɑ kpɑ Ɩsǝpɑɑlɩ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ tɔ ɩ pɩɩsɩ kɑ wɛ nɩɩlɛ. Ɩlɛnɑ ɩ́ tɔɣɔ kɑwulɑɣɑ kɛ pɩɩsɩ nɑɑlɛ. Yutɑ kpekǝle nyǝ́mɑ tike kɑ wɛnnɑ Tɑfiiti wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S22_11","011_2_11","2SA","2","11","11","Pɩɩsɩ nɑɑtosompɔɣɔlɑɣɑ nɑ ɩsɔtʋnɑɑ nɑɑtoso tǝcu kɛ Tɑfiiti tɔɣɔ kɑwulɑɣɑ kɛ Yutɑ kpekǝle nyǝ́mɑ tɔɔ kɛ́ Hepǝlɔŋ ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S22_12","011_2_12","2SA","2","12","12","Ḿpʋ́ɣʋ́ Nɛɛ pǝyɑlʋ Apǝnɛɛ nɑ Ɩsǝpɑɑlɩ pɑ yǝlɑɑ lɩɩ timpi pɑ yɑɑ sɩ Mɑhɑnɑyim tɔ nɑ pɑ́ polo Kɑpɑwɔŋ nyǝ́mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S22_13","011_2_13","2SA","2","13","13","Mpʋɣʋlɛ Seluyɑ pǝyɑlʋ Sowɑpɩ nɑ Tɑfiiti yǝlɑɑ pɑ tʋ mpɑɑʋ, nɑ pɑ́ polo pɑ́ suli Kɑpɑwɔŋ lɩɩlɛ nɔɣɔ, lɛlɑɑ nɑ kʋteŋ kʋnɛ lɛlɑɑ nɑ kʋnɛ. ");
INSERT INTO dop_vpl VALUES ("S22_14","011_2_14","2SA","2","14","14","Ntɛnɑ Apǝnɛɛ tɔ Sowɑpɩ sɩ: Tɑ ɩfepiyɑ tɑɑ nɑpǝlɩ pɑ́ suli nɑ pɑ́ yoo nɑ tǝ́ nyǝnɩ. Sowɑpɩ sɩ: Ɛɛ, pɑ́ polo. ");
INSERT INTO dop_vpl VALUES ("S22_15","011_2_15","2SA","2","15","15","Ɩlɛnɑ Pɛncɑmɛɛ ɩfepiyɑ nɑɑnʋwɑ nɑ nɑɑlɛ lɩɩ Ɩsǝpɑɑlɩ yǝlɑɑ tɑɑ, nɑ nɑɑnʋwɑ nɑ nɑɑlɛɣɛ Tɑfiiti nyǝ́mɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S22_16","011_2_16","2SA","2","16","16","Ɩlɛnɑ pɑ́ suli nɑɑlɛ nɑɑlɛ nɑ pɑɑ ɑwe tɔkɩ ɩ tɔɣɔntǝlɛ nyʋɣʋ nɑ pɑ́ sɔ tǝmɑ kɔŋkɔmǝŋ tɑɑ kɛ́ lɑɣɑlɛɛ nɑ pɑ́ hoti nɑ pɑ́ sɩ. Mpʋɣʋlɛ pɑ hɑ Kɑpɑwɔŋ cɔlɔ tǝnɛ ɩnǝɣɩ hǝtɛ sɩ: Lɑɣɑlɛɛ kʋsɛŋtɛɛ tɛ́. ");
INSERT INTO dop_vpl VALUES ("S22_17","011_2_17","2SA","2","17","17","Pǝlɛ pǝ wɑɑlɩ kɛ́ ɑcufu tiiwɑ nɑ hɑlɩ Tɑfiiti yǝlɑɑ kʋ Apǝnɛɛ pɑ yǝlɑɑ kɛ teu. ");
INSERT INTO dop_vpl VALUES ("S22_18","011_2_18","2SA","2","18","18","Sowɑpɩ nɑ ɩ newɑɑ Apǝsɑyi nɑ Asɑyɛɛlɩ pɑɑ wɛ pɑ tǝnɑ, nɑ Asɑyɛɛlɩ kɑ pǝsɑ sewɑ kɛ́ ɩsɩɩ nɑm. ");
INSERT INTO dop_vpl VALUES ("S22_19","011_2_19","2SA","2","19","19","Ḿpʋ́ɣʋ́ ɩ tʋ Apǝnɛɛ wɑɑlɩ sɩ ɩ kʋɣɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S22_20","011_2_20","2SA","2","20","20","Ntɛnɑ Apǝnɛɛ pǝsɩ nɑ ɩ́ pɔɔsɩ sɩ: Asɑyɛɛlɩ tɔɣɔnǝɣǝnɑ-m mpʋ? Ɩlɛnɑ ɩ́ cɔ sɩ: Ɛɛ, mɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S22_21","011_2_21","2SA","2","21","21","Mpʋɣʋlɛ Apǝnɛɛ sɩ: Tʋ́ nyɑ́ ntɔɣɔŋ yɑɑ nyɑ́ mpǝtǝŋ tɔɔ ɩfepiyɑ tɑɑ nɔɣɔlʋ wɑɑlɩ nɑ ń kpɑ-ɩ nɑ ń lɛɛkɩ ɩ wontu. Amɑ Asɑyɛɛlɩ tɑ tisi mpʋ. ");
INSERT INTO dop_vpl VALUES ("S22_22","011_2_22","2SA","2","22","22","Ɩlɛnɑ Apǝnɛɛ tɑsɑ-ɩ yɔɣɔtʋɣʋ sɩ: Mǝlɩ mɑ wɑɑlɩ yoo. Tɔfɔ, ye mɑ kʋ-ŋ mɑɑ heeli nyɑ́ tɑɑlʋ Sowɑpɩ suwe? ");
INSERT INTO dop_vpl VALUES ("S22_23","011_2_23","2SA","2","23","23","Pɑɑ nɑ mpʋ tɔ Asɑyɛɛlɩ tɑ nɩɩ. Tǝnɑɣɑlɛ Apǝnɛɛ culɑ-ɩ ŋmɑntɑɑɣɑ kɛ ɩ lotu tɑɑ, nɑ wɑɑlɩ tɔɔ nɑ kɑ́ lɩɩ nɑ ɩ́ sɩ́ kpɑkpɑɑ. Ḿpʋ́ɣʋ́ pɑ tǝnɑ mpɑ pɑ tɑlɑ Asɑyɛɛlɩ tǝsǝtɛ tǝnɑ tɔ pɑ sǝŋɑɑ. ");
INSERT INTO dop_vpl VALUES ("S22_24","011_2_24","2SA","2","24","24","Ɩlɛnɑ Sowɑpɩ nɑ Apǝsɑyi pɑ́ tʋ́ Apǝnɛɛ wɑɑlɩ, pǝ kɔmɑ ɩsɩɩ ilim tʋɣɩ ɩlɛ pɑ tɑlɑ Kipeyɑ-Ammɑ tontoŋle nte tǝ wɛ Kiyɑ ɩsɛntɑɑ kɛ Kɑpɑwɔŋ wʋlɑɣɑ tɛtʋ mpɑɑʋ tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S22_25","011_2_25","2SA","2","25","25","Mpʋɣʋlɛ Pɛncɑmɛɛ nyǝ́mɑ tɑsɑ kotuɣu kɛ Apǝnɛɛ kiŋ kɛ pulɑɣɑ nɑkǝlɩ kɑ nyʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S22_26","011_2_26","2SA","2","26","26","Ntɛnɑ Apǝnɛɛ kpɛɛsɩ Sowɑpɩ sɩ: Kʋɣʋ kɑɑ sɩɩ tǝnɑɣɑ kɛ mpʋ? N tɑ nyɩ tɑɑ sɩ pǝ kɑɑ tɛɛsǝnɑ kʋpɑntʋ? Heeli nyɑ́ yǝlɑɑ kɛ lɔŋ sɩ pɑ́ yele pɑ tɛɛtʋnɑɑ kʋɣʋ kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S22_27","011_2_27","2SA","2","27","27","Kɛlɛnɑ Sowɑpɩ tuunɑ Tɑcɑɑ nɑ ɩ́ yɔɣɔtɩ sɩ: Ye n tɑɑ yɔɣɔtɩ ɩsǝntɔ, yǝlɑɑ kɑ tɔɣɔnɑ-mɛɣɛ ḿpʋ́ɣʋ́ hɑlǝnɑ pǝ fe. ");
INSERT INTO dop_vpl VALUES ("S22_28","011_2_28","2SA","2","28","28","Ḿpʋ́ɣʋ́ Sowɑpɩ hʋlɑ tutuɣu nɑ yoolɑɑ sǝŋ nɑ pɑ́ yele Ɩsɛɣɛlɩ nyǝ́mɑ kɛ tɔɣɔnʋɣʋ nɑ yoonɑʋ. ");
INSERT INTO dop_vpl VALUES ("S22_29","011_2_29","2SA","2","29","29","Ɩlɛnɑ Apǝnɛɛ nɑ ɩ yǝlɑɑ pɑ́ tɔ ḿpʋ́ɣʋ́ ɑhoo tǝnɑɣɑ tɛtɛkǝlɛ tɑɑ nɑ pɑ́ tɛsɩ Yɑɑtɑnɩ nɑ pɑ́ fɑɣɑnɑ Pitǝlɔŋ tɑɑ hɑlǝnɑ pɑ́ tɑlɑ Mɑhɑnɑyim. ");
INSERT INTO dop_vpl VALUES ("S22_30","011_2_30","2SA","2","30","30","Sowɑpɩ lɩɩnɑ Apǝnɛɛ tǝtɔɣɔnlɛ nɑ ɩ́ kɑlɑ yoolɑɑ ɩlɛnɑ ɩ́ mɑɣɑnɑ yǝlɑɑ pɔɣɔlɑɣɑfɛɩ hiu fɛɩ Tɑfiiti yǝlɑɑ tɑɑ nɑ pǝ́ sɔɔsǝnɑ Asɑyɛɛlɩ. ");
INSERT INTO dop_vpl VALUES ("S22_31","011_2_31","2SA","2","31","31","Amɑ Tɑfiiti nyǝ́mɑ kɑ kʋwɑ yǝlɑɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ nɑ nɩɩtoso (360) kɛ Pɛncɑmɛɛ nɑ Apǝnɛɛ pɑ yoolɑɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S22_32","011_2_32","2SA","2","32","32","Ḿpʋ́ɣʋ́ Sowɑpɩ-wɛ pɑ kpɑɣɑ Asɑyɛɛlɩ nɑ pɑ́ pimi-ɩ ɩ cɑɑ pǝlɑɑʋ tɑɑ kɛ́ Pɛtǝlɛhɛm. Ɩlɛnɑ pɑ́ tɔ ɑhoo tǝnɑ, pǝ kɔmɑ ɩsɩɩ pǝ nyɑɑlǝɣɩ ɩlɛ pɑ tɑlɑ Hepǝlɔŋ. ");
INSERT INTO dop_vpl VALUES ("S23_1","011_3_1","2SA","3","1","1","Tɑfiiti yǝlɑɑ nɑ Sɑyuli nyǝ́mɑ pɑ yoou tɑɑŋɑ sɔsɔm kɛ́, nɑ Tɑfiiti nɑ ɩ nyǝ́mɑ pɑ toŋ sɔɔsǝɣɩ nɑ Sɑyuli yǝlɑɑ toŋ nɑ́ɑ́ sǝkɩ. ");
INSERT INTO dop_vpl VALUES ("S23_2","011_3_2","2SA","3","2","2","Piyɑ mpɑ Tɑfiiti ɑlɑɑ lʋlɑ-ɩ Hepǝlɔŋ tɑɑ tɔ pɑ hǝlɑ ntɔ, pɑ yɑɑ kɑncɑɑlɑɣɑ nyǝŋ sɩ Amǝnɔŋ ɩ too kɛlɛ Tɑfiiti ɑlʋ Sisilee nyǝŋ wei pɑ yɑɑ sɩ Ahinowɑm tɔ. ");
INSERT INTO dop_vpl VALUES ("S23_3","011_3_3","2SA","3","3","3","Nɑɑlɛ nyǝŋ sɩ Kiliyɑpɩ, ɩ́lɛ́ ɩ too kɛlɛ Kɑmɛɛlɩ tʋ Nɑpɑɑlɩ leelu Apikɑɑlɩ. Tooso nyǝŋ sɩ Apǝsɑlɔm, ɩ́lɛ́ ɩ too kɛlɛ Kesuli wulɑʋ Tɑlǝmɑyi pɛɛlɔ Mɑɑkɑ. ");
INSERT INTO dop_vpl VALUES ("S23_4","011_3_4","2SA","3","4","4","Liɣiti nyǝŋ sɩ Atoniyɑ, ɩ́lɛ́ ɩ too kɛlɛ Hɑkiti. Kɑkpɑsɩ nyǝŋ sɩ Sefɑtiyɑ, ɩ́lɛ́ ɩ too kɛlɛ Apitɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S23_5","011_3_5","2SA","3","5","5","Nɑɑtoso nyǝŋ sɩ Ɩtǝleyɑm, ɩ́lɛ́ ɩ too kɛlɛ Ɩkǝlɑ. Ɩ piyɑ nsi ɩ lʋlɑ Hepǝlɔŋ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S23_6","011_3_6","2SA","3","6","6","Tɑfiiti yǝlɑɑ nɑ Sɑyuli nyǝ́mɑ pɑ yoou tɑɑ kɛ́ Apǝnɛɛ nɑ́ tɑɣɑnɑ ɩ tǝɣɩ teu kɛ Sɑyuli tǝyɑɣɑ tɑɑ nɑ ɩ́ nyɔɔ toŋ. ");
INSERT INTO dop_vpl VALUES ("S23_7","011_3_7","2SA","3","7","7","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Ɩsǝpɑɑlɩ kɑlǝnɑ Apǝnɛɛ sɩ: Pepe tɔɔ kɛ́ n sʋʋnɑ Ayɑ pɛɛlɔ Lisipɑ wei mɑ cɑɑ Sɑyuli kɑ kpɑɣɑɑ tɔ? ");
INSERT INTO dop_vpl VALUES ("S23_8","011_3_8","2SA","3","8","8","Tǝnɑɣɑlɛ pɑ́ɑ́nɑ́ kpɑ Apǝnɛɛ kɛ sɔsɔm nɑ ɩ́ tɔ sɩ: Mɑ tɑ kɛ mǝnɑɑfiki tʋ sɩ mɑ lɩɩkɩ Sɑyuli yǝlɑɑ wɑɑlɩ se. Mɑ tɔŋnɑ kʋpɑntʋ lɑpʋ kɛ nyɑ́ cɑɑ Sɑyuli nyǝ́mɑ nɑ ɩ tɑɑpɑlɑɑ. Mɑ tɑ tʋ-ŋ Tɑfiiti niŋ tɑɑ. Ɩlɛnɑ sɑŋɑ ń kɑlǝɣǝnɑ-m sɩ mɑ lɑpɑ ɩsɑɣɑtʋ kɛ ɑlʋ tɔm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S23_9","011_3_9","2SA","3","9","10","Mɑ tuukinɑ Ɩsɔ sɩ ɩsɩɩ mɑ lɑpɑ teitei ɩsɩɩ Tɑcɑɑ kɑ heeluɣu Tɑfiiti nɑ tuunɑʋ sɩ ɩ kɑ́ cɛlɛ-ɩ Sɑyuli kɑwulɑɣɑ nɑ ɩ́ kpɑ-ɩ Ɩsɛɣɛlɩ nɑ Yutɑ pǝ wulɑʋ kɛ pǝ kpɑɣɑʋ Tɑŋ nɑ pǝ́ sɩɩnɑ Pɛɛsepɑ tɔ. Ye pǝ tɑɣɑ mpʋ Ɩsɔ ɩ́ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("S23_11","011_3_11","2SA","3","11","11","Ɩsǝpɑɑlɩ tɑ cɔ Apǝnɛɛ kɛ pɑɑ tɔmʋɣʋ kʋlʋmʋɣʋ. Mpi tɔ, ɩ nyɑŋɑɣɑnɑ-ɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S23_12","011_3_12","2SA","3","12","12","Ḿpʋ́ɣʋ́ Apǝnɛɛ tilɑɑ nɑ pɑ heeli Tɑfiiti sɩ: Nyɑ́ niŋ tɑɑ kɛ́ pǝ tʋ tɛtʋ. Mpʋ tɔ, tǝ́ pɛɛlɩ nɔɣɔ. Mɑɑ sǝnɑ-ŋ nɑ tǝ́ kɛɛsɩ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ɩsɛ nɑ nyɑ́ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S23_13","011_3_13","2SA","3","13","13","Mpʋɣʋlɛ Tɑfiiti sɩ: Pǝ wɛ teu, mɑ nɑ-ŋ tɩɩ pɛɛlɩ nɔɣɔ yɑɑ. Amɑ kʋlʋmtʋ kɛ́ sɩ ye n tɑ kɔnɑ mɑ ɑlʋ Mikɑɑlɩ n kɑɑ keesi mɑ ɩsǝlɛ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S23_14","011_3_14","2SA","3","14","14","Ɩlɛnɑ Tɑfiiti tili nɑ pɑ́ heeli Ɩsǝpɑɑlɩ sɩ ɩ́ cɛlɛ-ɩ ɩ ɑlʋ Mikɑɑlɩ wei ɩ tɔɔ ɩ suu Filiisi nyǝ́mɑ hǝnnɔɔsɩ nɩɩnʋwɑ (100) tɔ. ");
INSERT INTO dop_vpl VALUES ("S23_15","011_3_15","2SA","3","15","15","Ntɛnɑ Ɩsǝpɑɑlɩ tili nɑ pɑ́ mʋ ɑlʋ kɛ ɩ pɑɑlʋ Lɑyisi pǝyɑlʋ Pɑtiyɛɛlɩ kiŋ. ");
INSERT INTO dop_vpl VALUES ("S23_16","011_3_16","2SA","3","16","16","Nɑ ɩ pɑɑlʋ tǝŋǝɣɩ ɩ ɑlʋ wɑɑlɩ nɑ wulɑ, hɑlǝnɑ timpi pɑ yɑɑ sɩ Pɑhulim tɔ. Kɛlɛnɑ Apǝnɛɛ tɔɣɔnɩ-ɩ sɩ: Polo ń mǝlɩ. Ɩ́lɛnɑ ɩ́ mǝlɩ. ");
INSERT INTO dop_vpl VALUES ("S23_17","011_3_17","2SA","3","17","17","Mpʋɣʋlɛ Apǝnɛɛ nɑ Ɩsɛɣɛlɩ nyʋɣʋ nyǝ́mɑ pɑ cɑɣɑɑ nɑ ɩ́ tɔ-wɛ sɩ: Hɑtoo lɔŋ Tɑfiiti kɛ ɩ́ cɑɑkɑɣɑ sɩ ɩ́ kpɑ mǝ wulɑʋ, ");
INSERT INTO dop_vpl VALUES ("S23_18","011_3_18","2SA","3","18","18","pǝ tɑlɑ ɩ kpɑʋ ntɛ́. Mpi tɔ, Tɑcɑɑ yɔɣɔtɑɑ sɩ: Mɑ tǝmlɛ tʋ Tɑfiiti niŋ kɛ mɑɑ fitinɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ pɑ kolontunɑɑ nɑ Filiisi nyǝ́mɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S23_19","011_3_19","2SA","3","19","19","Ɩlɛnɑ Apǝnɛɛ heeli-tǝɣɩ Pɛncɑmɛɛ nyǝ́mɑ nɑ ɩ́ tɛlǝsɩ Tɑfiiti kɛ nti nti Ɩsɛɣɛlɩ nyǝ́mɑ nɑ Pɛncɑmɛɛ kpekǝle tǝnɑ pɑ cɑɣɑɑ nɑ pɑ́ mɑɣɑsɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S23_20","011_3_20","2SA","3","20","20","Apǝnɛɛ tɑlɑ Tɑfiiti tɛ tɔ nɑ yǝlɑɑ hiu kɛ ɩ wɑɑlɩ kɛ́, nɑ ɩ́lɛ́ ɩ́ lɑ-wɛɣɛ mʋʋllɛ kɛ teu. ");
INSERT INTO dop_vpl VALUES ("S23_21","011_3_21","2SA","3","21","21","Mpʋɣʋlɛ Apǝnɛɛ tɔmɑ Tɑfiiti sɩ: Hɑɩ, tɑ cɑɑ, mɑɑ polo nɑ mɑ́ kpeɣeli Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɑ mɑ́ kɔnɑ nɑ nyɑ́ nɑ-wɛ ɩ́ pɛɛlɩ nɔɣɔ, ɩlɛnɑ ń tɔɣɔ kɑwulɑɣɑ kɛ tɛtʋ tǝnɑ tɔɔ ɩsɩɩ n cɑɑkɩ tɔ. Ɩlɛnɑ Tɑfiiti cɛ Apǝnɛɛ nɑ ɩ kpeenɑ lɑŋhʋlʋmlɛ. ");
INSERT INTO dop_vpl VALUES ("S23_22","011_3_22","2SA","3","22","22","Ḿpʋ́ɣʋ́ Sowɑpɩ nɑ Tɑfiiti yoolɑɑ pɑ lɩɩnɑ kʋlɩɩʋ nɑ pɑ́ kuuwɑ kolontunɑɑ wontu kɛ sɔsɔm. Ɩlɛ pɑ tɑ mɑɣɑnɑ Apǝnɛɛ kɛ Hepǝlɔŋ. Tɑfiiti tɛmɑ-ɩ yeluɣu nɑ ɩ́ tɛɛnɑ lɑŋhʋlʋmlɛ. ");
INSERT INTO dop_vpl VALUES ("S23_23","011_3_23","2SA","3","23","23","Sowɑpɩ nɑ yoolɑɑ pɑ tɑlɑɑ, ɩlɛnɑ pɑ tɑɣɑsɩ-ɩ sɩ: Apǝnɛɛ kɔmɑ wulɑʋ kiŋ nɑ wulɑʋ yele-ɩ nɑ ɩ́ kpenɑ lɑŋhʋlʋmlɛ. ");
INSERT INTO dop_vpl VALUES ("S23_24","011_3_24","2SA","3","24","24","Kɛlɛnɑ Sowɑpɩ polo wulɑʋ kiŋ nɑ ɩ́ pɔɔsǝɣɩ-ɩ sɩ: Tɑ cɑɑ, Apǝnɛɛ kɔmɑ nyɑ́ kiŋ nɑ ń yele-ɩ nɑ ɩ́ kpe yɑɑ? ");
INSERT INTO dop_vpl VALUES ("S23_25","011_3_25","2SA","3","25","25","Anɩ n nyǝ́mɑ ɩ tɔɔ, ɩ kɔmɑ-ŋ feŋuɣu kɛ́ sɩ ɩ nyǝŋ nyɑ́ lɑɣɑtʋ nɑ pǝ tǝnɑ mpi n lɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S23_26","011_3_26","2SA","3","26","26","Sowɑpɩ lɩɩ Tɑfiiti tɛ, ɩlɛnɑ ɩ́ tili Apǝnɛɛ wɑɑlɩ kɛ kpɑkpɑɑ nɑ pɑ́ hiki-ɩ Silɑ lɔkɔ kiŋ nɑ pɑ́ mǝŋnɑ-ɩ, Tɑfiiti nɑ́ tɑ́ nyɩ pǝ tɑɑ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S23_27","011_3_27","2SA","3","27","27","Apǝnɛɛ tɑlɑɑ ɩlɛnɑ Sowɑpɩ hɔmɩ-ɩ nɑ ɩ́ lɩɩnɑ kpeeŋɑ ɩsɩɩ ɩ wɛlǝtǝɣɩ-ɩ tɔm, nɑ ɩ́ sɔ ɩ lotu tɑɑ kɛ́ sǝyɑɣɑ nɑ ɩ́ sɩ. Ɩ lɛɛtɑ-ɩ kʋɣʋ mpi ɩ kɑ kʋ ɩ neu Asɑyɛɛlɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S23_28","011_3_28","2SA","3","28","28","Tɑfiiti nɩɩ-tɩ ɩlɛnɑ ɩ́ tɔ sɩ: Tɑcɑɑ nyǝ́mɑ sɩ Nɛɛ pǝyɑlʋ Apǝnɛɛ sǝm tɔm fɛɩ mɑ́ nɑ mɑ kɑwulɑɣɑ tɑ́ tɔɔ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S23_29","011_3_29","2SA","3","29","29","Ɩ sǝm tɔm ɩ́ wɛɛ Sowɑpɩ nɑ ɩ cɑɑ tǝyɑɣɑ nyǝ́mɑ pɑ tɔm. Pǝ tɔɔ tɔ Sowɑpɩ lʋlʋɣʋ tɑɑ kɑɑ lɑŋ cɑsɑɣɑ tʋ, yɑɑ tɔnʋɣʋ tɔɔ ɑsilimɑ kʋtɔŋ tʋ, yɑɑ ɩcɑm, yɑɑ wei ɩ sǝpǝnɑ lɑɣɑtɛ tɔ, yɑɑ nyɔɣɔtʋ. ");
INSERT INTO dop_vpl VALUES ("S23_30","011_3_30","2SA","3","30","30","Apǝnɛɛ kɑ kʋwɑ Sowɑpɩ nɑ Apǝsɑyi pɑ neu Asɑyɛɛlɩ kɛ Kɑpɑwɔŋ kɛ yoou tɑɑ tɔɣɔ pɛlɛ pɑ lɛɛtɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S23_31","011_3_31","2SA","3","31","31","Tǝnɑɣɑlɛ Tɑfiiti tɔmɑ Sowɑpɩ nɑ ɩ wɑɑlɩ yǝlɑɑ tǝnɑ sɩ: Ɩ́ cǝlɩ mǝ wontu nɑ lɑŋwɑkǝllɛ nɑ ɩ́ suu fɔlǝtɔnɑɑ tɑkɑ nɑ ɩ wii Apǝnɛɛ sǝm. Pɑ pukɑɣɑnɑ-ɩ pim, ɩlɛnɑ Tɑfiiti tǝŋ nɑ ɩ́ polo pǝlɑɑʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S23_32","011_3_32","2SA","3","32","32","Pɑ pimɑ Apǝnɛɛ kɛ Hepǝlɔŋ, ɩlɛnɑ wulɑʋ Tɑfiiti tʋlɩ nɔɣɔ nɑ ɩ́ wii ɩ pǝlɑɑʋ tɔɔ tǝkpoo, nɑ yǝlɑɑ tǝnɑ wii mpʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S23_33","011_3_33","2SA","3","33","33","Mpʋɣʋlɛ wulɑʋ tɑsɑ-ɩ wulɑ sɩ: Apǝnɛɛ n sǝpɑ mpʋ ɩsɩɩ kʋmɛlɛŋ suwe? ");
INSERT INTO dop_vpl VALUES ("S23_34","011_3_34","2SA","3","34","34","Anɩ pɑ tɑ hɔkɔ nyɑ́ niŋ kɛ ŋmɩɩsɩ. Pǝyele pɑ tɑ hɔkɔ nyɑ́ nɔɔhɛɛ kɛ ɑlukpɑlɑ. Pǝ́cɔ́ n hotɑɑ ɩsɩɩ ɩsɑɣɑʋ. Mpʋ́ɣʋ́ yǝlɑɑ tǝnɑ tɑsɑ-ɩ wulɑ ");
INSERT INTO dop_vpl VALUES ("S23_35","011_3_35","2SA","3","35","35","nɑ pɑ́ ponɑ Tɑfiiti kɛ tɔɣɔnɑɣɑ kɛ ilim tɑɑ. Tǝnɑɣɑlɛ Tɑfiiti tuuwɑ sɩ: Ye mɑ tǝŋɑ pʋlʋ nɑ ilim tɑ tʋtɑ Ɩsɔ ɩ́ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("S23_36","011_3_36","2SA","3","36","36","Yǝlɑɑ nɩɩ wulɑʋ kʋlɑpʋtʋ ntɩ ɩlɛnɑ pɑ lɑŋɑ hɛɛnɑ-tɩ. ");
INSERT INTO dop_vpl VALUES ("S23_37","011_3_37","2SA","3","37","37","Ɩlɛnɑ Ɩsɛɣɛlɩ yǝlɑɑ cɛkǝnɑ kʋyɑkʋ ŋkʋ sɩ pǝ tɑɣɑ wulɑʋ yelinɑ nɑ pɑ́ kʋ́ Apǝnɛɛ. ");
INSERT INTO dop_vpl VALUES ("S23_38","011_3_38","2SA","3","38","38","Mpʋɣʋlɛ Tɑfiiti heelɑ yǝlɑɑ sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ yoolɑɑ wulɑʋ sɔsɔ hotinɑ sɑŋɑ ɩsǝntɔ. ");
INSERT INTO dop_vpl VALUES ("S23_39","011_3_39","2SA","3","39","39","Pɑɑ nɑ Ɩsɔ lǝsɑ-m sɩ mɑ́ lɑ wulɑʋ tɔ, mɑ kɛ́ ɩcɑm kɛ́, nɑ Seluyɑ pǝyɑlɑɑ mpɛ pɑ kǝlɑ ɩsɑɣɑtʋ. Ɩsɔ ɩ́ fɛlɩ-wɛ nɑ pǝ́ kɛɛsǝnɑ pɑ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("S24_1","011_4_1","2SA","4","1","1","Sɑyuli pǝyɑlʋ Ɩsǝpɑɑlɩ nɩɩwɑ sɩ Apǝnɛɛ sǝpɑ Hepǝlɔŋ, ɩlɛnɑ pǝ́ yɔɔlɩ-ɩ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ lɑŋɑ pǝsɩ kɑtɑtǝlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S24_2","011_4_2","2SA","4","2","2","Ɩsǝpɑɑlɩ kɑ wɛnɑ ɩ kʋlɩɩʋ nyʋɣʋ nyǝ́mɑ kɛ nɑɑlɛ kɛ́. Pɑ yɑɑ lɛlʋ sɩ Pɑɑnɑ nɑ lɛlʋ sɩ Lekɑpii pɑ cɑɑ kɛlɛ Pɛncɑmɛɛ tʋ Limɔŋ wei ɩ wɛ Pelɔtɩ tɔ. Mpi tɔ, ɩcɑtɛ ntɛ́ pɑ nyǝnɑɣɑ-tɛɣɛ Pɛncɑmɛɛ nyǝ́mɑ nyǝntɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S24_3","011_4_3","2SA","4","3","3","Pelɔtɩ nyǝ́mɑ kɑ sewɑ nɑ pɑ́ cɔɔsɩ Kitɑyim nɑ pɑ́ pǝsɩ tǝnɑ nyǝ́mɑ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S24_4","011_4_4","2SA","4","4","4","Sɑyuli pǝyɑlʋ Sonɑtɑŋ kɑ wɛnɑ ɑpɑlʋpǝyɑɣɑ nɑ pɑ yɑɑ-kɛ sɩ Mefipɑɑlɩ. Kʋyɑkʋ ŋku kɑ cɑɑ Sonɑtɑŋ nɑ Sɑyuli pɑ sǝpɑ tɔɣɔ kɑ nʋkʋlʋ seekɑɣɑnɑ-kɛ nɑ kɑ́ hoti kɑ nɔɔhɛɛ tɔɔ nɑ pǝ́ kɑɑnɩ-kɛ́. Wɑɑtʋ ɩnɩ tɔ, kɑɑ wɛnɑ pɩɩsɩ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S24_5","011_4_5","2SA","4","5","5","Ḿpʋ́ɣʋ́ Lekɑpii nɑ Pɑɑnɑ pɑ polɑ Ɩsǝpɑɑlɩ tǝyɑɣɑ kɛ ilim tɑɑ kɛ́ wɑɑtʋ wei Ɩsǝpɑɑlɩ nɑ́ hǝntɑɑ sɩ ɩ hɛɛsǝɣɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S24_6","011_4_6","2SA","4","6","7","Pɑ kɛɛsǝnɑ ilim hɛkɑ kɛ́ nɑ pɑ́ cɛsɩ nɑ pɑ́ sʋʋ tǝyɑɣɑ ɩsɩɩ pɑ polɑ tɔɣɔnɑɣɑ pee kpɑɣɑʋ, nɑ Ɩsǝpɑɑlɩ hǝntɑ nɑŋ tɑɑ nɑ ɩ́ hɛɛsǝɣɩ. Ɩlɛnɑ pɑ́ kʋ-ɩ nɑ pɑ́ sɛtɩ ɩ nyʋɣʋ nɑ pɑ́ kpɑɣɑ-kʋ nɑ pɑ́ fɑɣɑnɑ Yɑɑtɑnɩ tɛtɛkǝlɛ tɑɑ kɛ́ ɑhoo tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S24_8","011_4_8","2SA","4","8","8","Ḿpʋ́ɣʋ́ pɑ ponɑ-kʋɣʋ Tɑfiiti kɛ Hepǝlɔŋ nɑ pɑ́ heeli-ɩ sɩ: N nɑɑkɩ nyɑ́ kolontu Sɑyuli wei ɩ pɛɛkɑɣɑ-ŋ kʋɣʋ tɔ ɩ pǝyɑlʋ Ɩsǝpɑɑlɩ nyʋɣʋ ntɔ? Hɑɩ, tɑ cɑɑ wulɑʋ, Ɩsɔ lɛɛtǝɣǝnɑ Sɑyuli nɑ ɩ lʋlʋɣʋ nyǝ́mɑ nɑ nyɑ́ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S24_9","011_4_9","2SA","4","9","9","Mpʋɣʋlɛ Tɑfiiti cɔwɑ sɩ: Mɑ tuunɑ Tɑcɑɑ wei ɩ yɑpɑ-m ɑsolɑ ɑnɩ ɑ nɔɣɔ tɑɑ tɔ sɩ, ");
INSERT INTO dop_vpl VALUES ("S24_10","011_4_10","2SA","4","10","10","yʋlʋ wei ɩ kɑ kɔmɑ nɑ ɩ́ heeli-m Sɑyuli sǝm, nɑ ɩ́lɛ́ ɩ mɑɣɑsǝɣɩ ɩ tɑɑ sɩ mɑ lɑŋlɛ kɑ́ hɛɛnɑ-tɩ tɔ, mɑ yelɑɑ kɛ́ nɑ pɑ́ kpɑ-ɩ nɑ pɑ́ kʋ-ɩ. Mɑ sɩ ɩ tɔm heeluɣu kɑsǝyɑɣɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("S24_11","011_4_11","2SA","4","11","11","Hɑlɩ ḿpʋ́ɣʋ́ ɑsɑɣɑɑ kɑ polo nɑ pɑ́ mɑɣɑnɑ yʋlʋ kɛ ɩ tǝyɑɣɑ tɑɑ kɛ́ ɩ tǝhǝntǝlɛ nɑ pɑ́ kʋ-ɩ tulum nɑ? Ɩsǝnɑɣɑ pɩɩ lɑ nɑ mɑ́ kɑɑ lɛɛtɩ-wɛ nɑ mɑ́ kpiisi-wɛɣɛ tɛtʋ tɔɔ? ");
INSERT INTO dop_vpl VALUES ("S24_12","011_4_12","2SA","4","12","12","Ntɛnɑ Tɑfiiti tɔ ɩ yǝlɑɑ sɩ: Ɩ́ kʋ-wɛ. Ɩlɛnɑ pɑ́ sɛtɩ pɑ niŋ nɑ pɑ nɔɔhɛɛ nɑ pɑ́ pusi-wɛɣɛ tɩɩŋ tɔɔ kɛ́ Hepǝlɔŋ lɩɩlɛ nɔɣɔ. Nɑ pɑ́ pi Ɩsǝpɑɑlɩ nyʋɣʋ kɛ Apǝnɛɛ pǝlɑɑʋ tɑɑ kɛ́ Hepǝlɔŋ. ");
INSERT INTO dop_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ kpekɑ tǝnɑ kotɑ Tɑfiiti kiŋ kɛ Hepǝlɔŋ nɑ pɑ́ tɔmɩ-ɩ sɩ: Tɑ nɑ-ŋ tɑ cɑlǝm kʋlʋmǝm kɛ́. ");
INSERT INTO dop_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Pɑɑ hɑtoo wɑɑtʋ wei Sɑyuli kɑ kɛ́ tɑ wulɑʋ tɔ, kʋlʋm nyɑ́ ɩnɩ n pɑɑsɑɣɑnɑ Ɩsɛɣɛlɩ yoolɑɑ. Tɑcɑɑ kɑ tɛmɑ-ŋ heeluɣu kɛ ḿpʋ́ɣʋ́ sɩ ń pɑɑsǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ ń lɑ́ pɑ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ sɔsɑɑ kotɑ Tɑfiiti kiŋ kɛ Hepǝlɔŋ nɑ pɑ́ nɑ-ɩ pɑ́ pɛɛlɩ nɔɣɔ kɛ Tɑcɑɑ ɩsɛntɑɑ nɑ pɛlɛ pɑ́ pǝlɩ-ɩ nim nɑ ɩ́ pǝsɩ Ɩsɛɣɛlɩ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Tɑfiiti pɩɩsɩ kɑ wɛ hiu nɑ nɑɑnʋwɑ kɛ wɑɑtʋ wei pɑ kpɑ-ɩ wulɑʋ tɔ. Ḿpʋ́ɣʋ́ ɩ tɔɣɔ kɑwulɑɣɑ kɛ pɩɩsɩ nɩɩlɛ. ");
INSERT INTO dop_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Ɩ tɔɣɔ kɑwulɑɣɑ kɛ Hepǝlɔŋ kɛ Yutɑ nyǝ́mɑ tɔɔ kɛ́ pɩɩsɩ nɑɑtosompɔɣɔlɑɣɑ nɑ ɩsɔtʋnɑɑ nɑɑtoso, nɑ Yosɑlɛm kɛ Yutɑ nɑ Ɩsɛɣɛlɩ pɑ́ kʋkpɛntʋɣʋ tɔɔ kɛ́ pɩɩsɩ hiu nɑ nɑɑnʋwɑ nɑ tooso. ");
INSERT INTO dop_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Ḿpʋ́ɣʋ́ wɑɑtʋ nɔɣɔlʋ Tɑfiiti nɑ ɩ yoolɑɑ pɑ polɑ Yosɑlɛm kɛ Yepusi nyǝ́mɑ mpɑ pɑ kɛ́ tɛtʋ nyǝ́mɑ tɔ pɑ yoonɑʋ. Tǝnɑɣɑlɛ pɛlɛ pɑ tɔmɑ-ɩ sɩ: N kɑɑ pǝsɩ nɑ ń sʋʋ tɑ ɩcɑtɛ tɑɑ. Pɑɑ yʋlʋmɑɑ nɑ kɑɑkɑlɑsɩ pɑɑ pǝsɩ nɑ pɑ́ tɑŋ-mɛ. Pǝ nyʋɣʋ ntɛ́ sɩ ɩcɑtɛ wɛ toŋ, Tɑfiiti kɑɑ pǝsɩ nɑ ɩ́ sʋʋ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S25_7","011_5_7","2SA","5","7","7","Amɑ Tɑfiiti lɛɛkɑ koloŋɑ sɔsɑɣɑ ɩcɑtɛ nɑ ɩ́ kɑntɑ nɑ pɑ́ hɑ-tɛɣɛ hǝtɛ sɩ Tɑfiiti tɛ. ");
INSERT INTO dop_vpl VALUES ("S25_8","011_5_8","2SA","5","8","8","Kʋyɑkʋ ŋkʋɣʋ Tɑfiiti tɔmɑ ɩ yoolɑɑ sɩ: Ye wei ɩ cɑɑ sɩ ɩ́ yoonɑ Yepusi nyǝ́mɑ pʋntʋ ɩ́ tǝŋ lʋm sɩɩlʋɣʋ nɑ ɩ́ kʋ́ mɑ kolontunɑɑ kɑɑkɑlɑsɩ nɑ yʋlʋmɑɑ mpɑ pɑ woŋɑɣɑ-m tɔ. Pǝ tɔɔ kɛ́ pǝ pǝsɑ ɩtuule sɩ: Kɑɑkɑlɑɣɑ yɑɑ yʋlʋm kɑɑ sʋʋ Tɑfiiti tǝyɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Ḿpʋ́ɣʋ́ Tɑfiiti lɛɛkɑ koluŋɑ sɔsɑɣɑ ɩcɑtɛ ntɛ́ nɑ ɩ́ cɑɣɑ tǝ tɑɑ nɑ ɩ́ hɑ-tɛ sɩ: Tɑfiiti tɛ. Ɩlɛnɑ ɩ́ ŋmɑ́ koluŋɑ nɑ Milo nɑ ɩ́ sɔɔsɩ kutuluŋ nɑ pǝ tɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Ɩlɛnɑ Tɑfiiti toŋ sɔɔsǝɣɩ nɑ pǝ́ puki nɑ Tɑcɑɑ Ɩsɔ Tomɑ tǝnɑ tʋ wɛ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S25_11","011_5_11","2SA","5","11","11","Ḿpʋ́ɣʋ́ Tiii wulɑʋ Hilɑm ponɑ Tɑfiiti kɛ tǝmlɛ nyǝ́mɑ nɑ kpoŋkpolonɑɑ kʋpɑmɑ nɑ kɑɑfǝntɑnɑɑ nɑ pɛɛ sɑɑkǝlɑɑ nɑ pɑ́ ŋmɑ́ Tɑfiiti kɛ kɑwulɑɣɑ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S25_12","011_5_12","2SA","5","12","12","Tǝnɑɣɑ ɩ cɛkǝnɑɑ sɩ Tɑcɑɑ kpɑ-ɩ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ. Pǝyele ɩ kʋsɑ ɩ kɑwulɑɣɑ nyʋɣʋ kɛ ɩ kɑ sɔɔlɑ ɩ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔ pǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S25_13","011_5_13","2SA","5","13","13","Tɑfiiti tɑlɑ Yosɑlɛm ɩlɛnɑ ɩ́ kpɑɣɑ ɑlɑɑ nɑ pɛlɛ pɑ́ lʋlɩ-ɩ piyɑ kɛ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S25_14","011_5_14","2SA","5","14","14","Pɑ hǝlɑ ntɛ́ Sɑmʋwɑ nɑ Sopɑpɩ nɑ Nɑtɑŋ nɑ Sɑlʋmɔŋ ");
INSERT INTO dop_vpl VALUES ("S25_15","011_5_15","2SA","5","15","15","nɑ Ɩpɑɑlɩ nɑ Ɩlisuwɑ nɑ Nefɛkɩ nɑ Yɑfiyɑ ");
INSERT INTO dop_vpl VALUES ("S25_16","011_5_16","2SA","5","16","16","nɑ Ɩlisɑmɑ nɑ Ɩliyɑtɑ nɑ Ɩlifɛlɛtɩ. ");
INSERT INTO dop_vpl VALUES ("S25_17","011_5_17","2SA","5","17","17","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ nɩɩwɑ sɩ pɑ kpɑ Tɑfiiti kɛ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ. Ɩlɛnɑ pɑ́ polo pɑ tǝnɑɣɑ ɩ wɑɑlɩ. Tɑfiiti nɩɩ mpʋ, ɩlɛnɑ ɩ́ sʋʋ koloŋɑ ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S25_18","011_5_18","2SA","5","18","18","Filiisi nyǝ́mɑ tɑlɑɑ, ɩlɛnɑ pɑ́ wɑtɩ Lefɑyim tɛtɛkǝlɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S25_19","011_5_19","2SA","5","19","19","Ɩlɛnɑ Tɑfiiti pɔɔsɩ Tɑcɑɑ sɩ: Mɑ́ polo Filiisi nyǝ́mɑ wɑɑlɩ? N kɑ́ tʋ-wɛɣɛ mɑ niŋ tɑɑ? Tɑcɑɑ sɩ: Ɛɛ, polo, mɑɑ tʋ-wɛɣɛ nyɑ́ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S25_20","011_5_20","2SA","5","20","20","Ḿpʋ́ɣʋ́ Tɑfiiti polɑ Filiisi nyǝ́mɑ kiŋ kɛ timpi pɑ yɑɑ sɩ Pɑɑlɩ-Pelɑsim tɔ nɑ ɩ́ kʋ-wɛ. Ɩlɛnɑ ɩ́ tɔ sɩ: Tɑcɑɑ hɛɛ-m mpɑɑʋ kɛ mɑ kolontunɑɑ cɑŋɑ tɑɑ ɩsɩɩ lʋm fɑkʋɣʋ ɑkʋlɑ sɔsɔɔnɑ tɔ. Pǝ tɔɔ kɛ́ ɩ hɑ lonte ntɛɣɛ hǝtɛ sɩ Ɩsɔ mpɑɑʋ tǝfɑɣɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S25_21","011_5_21","2SA","5","21","21","Filiisi nyǝ́mɑ sewɑ nɑ pɑ yele pɑ tɩɩŋ ɩlɛnɑ Tɑfiiti nɑ ɩ yǝlɑɑ pɑ kpɑɣɑ nɑ pɑ́ wɔ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("S25_22","011_5_22","2SA","5","22","22","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ tɑsɑ wɑtʋɣʋ kɛ Lefɑyim tɛtɛkǝlɛ sɩ pɑ yookinɑ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S25_23","011_5_23","2SA","5","23","23","Tɑfiiti pɔɔsɑ Tɑcɑɑ, ɩlɛnɑ Tɑcɑɑ heeli-ɩ sɩ: Tɑɑ ponɑ pɑ ɩsɛntɑɑ tɔɔ. Cɛ nɑ ń lɩɩnɑ pɑ wɑɑlɩ tɔɔ kɛ́ tuluŋɑ kɛ tɩɩŋ tɑɑlɛ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("S25_24","011_5_24","2SA","5","24","24","Ye n kɔmɑ nɑ ń nɩɩ yǝlɑɑ nɔɔhɛɛ kɛ tɩɩŋ ɩnɩ ɩ tɑɑ ɩsɩɩ yoolɑɑ nɔɔhɛɛ, ɩlɛ n tii pɑ tɔɔ kɛ́ kpɑkpɑɑ. Mpi tɔ, Tɑcɑɑ tɛɛnɑ-ŋ nɔɣɔ sɩ ɩ yookinɑ Filiisi nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S25_25","011_5_25","2SA","5","25","25","Ḿpʋ́ɣʋ́ Tɑfiiti lɑpɑ ɩsɩɩ Tɑcɑɑ heelɑ-ɩ tɔ, nɑ ɩ́ kʋ́ ɩ kolontunɑɑ kɛ pǝ kpɑɣɑʋ Kepɑ tɔ hɑlǝnɑ Kesɛɛ. ");
INSERT INTO dop_vpl VALUES ("S26_1","011_6_1","2SA","6","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti tɑsɑ Ɩsɛɣɛlɩ yoolɑɑ tɑɑ yoolɑɑ kɛ kpeɣeluɣu kɛ yǝlɑɑ ɩsɩɩ iyisi hiu nɑ nɑɑnʋwɑ (30000). ");
INSERT INTO dop_vpl VALUES ("S26_2","011_6_2","2SA","6","2","2","Ɩlɛnɑ pɑ́ tɛɛ timpi pɑ yɑɑ sɩ Pɑɑlɑ tɔɣɔ Yutɑ sɩ pɑ kpɑkǝɣɩ Ɩsɔ ɑtɑkɑɑ. Tɑcɑɑ Tomɑ tǝnɑ tʋ tǝnnɑ ɑtɑkɑɑ ɩnɩ nɑ ɩ tɔkɩ kɑwulɑɣɑ kɛ ɩsɔtɑɑ tɑŋlɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S26_3","011_6_3","2SA","6","3","4","Ḿpʋ́ɣʋ́ pɑ kpɑɣɑ Ɩsɔ ɑtɑkɑɑ kɛ́ Apinɑtɑpɩ tɛɣɛ pulɑɣɑ tɔɔ nɑ pɑ́ tʋ-ɩ kɛɛkɛ kʋfɑlʋ tɑɑ, nɑ Apinɑtɑpɩ pǝyɑlɑɑ Ahiyo kɛ lɔlɔ nɑ Yusɑ kɛ kɔŋkɔŋ tɔɔ nɑ pɑ́ pɑɑsǝɣǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S26_5","011_6_5","2SA","6","5","5","Nɑ pɑ́ mɑkɩ wontu nɑ hǝsɩ nɑ Tɑfiiti nɑ ɩ nyǝ́mɑ pɑ́ pɑɑkɩ. ");
INSERT INTO dop_vpl VALUES ("S26_6","011_6_6","2SA","6","6","6","Pɑ tɑlɑ tǝfɑllɛ nte tǝ wɛ timpi pɑ yɑɑ sɩ Nɑkɔŋ tɔ, ɩlɛnɑ nɑɑŋ kpilisi kɛɛkɛ nɑ Ɩsɔ ɑtɑkɑɑ tɑŋ hotuɣu nɑ Yusɑ temi-ɩ. ");
INSERT INTO dop_vpl VALUES ("S26_7","011_6_7","2SA","6","7","7","Tǝnɑɣɑlɛ Tɑcɑɑ mʋ-ɩ nɑ pɑ́ɑ́nɑ́ nɑ ɩ́ kʋ-ɩ tǝnɑɣɑ ɑtɑkɑɑ kite kɛ mpi pǝ tɔɔ ɩ tɑ nyɑnɑ Ɩsɔ ɑtɑkɑɑ tokinɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S26_8","011_6_8","2SA","6","8","8","Amɑ Tɑfiiti lɑŋlɛ tɑ hɛɛnɑ Yusɑ kʋɣʋ mpɩ, nɑ pɑ́ hɑ lonte ntɛɣɛ hǝtɛ sɩ Yusɑ tǝkʋlɛ. Nɑ pɑ́ yɑɑkɩ-tɛɣɛ ḿpʋ́ɣʋ́ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S26_9","011_6_9","2SA","6","9","9","Ḿpʋ́ɣʋ́ sɔɣɔntʋ kpɑ wulɑʋ nɑ ɩ́ tɔ sɩ: Ye mpʋ mɑɑ pǝsɩ mɑ ponɑ Ɩsɔ ɑtɑkɑɑ kɛ mɑ tɛɣɛlɛ? ");
INSERT INTO dop_vpl VALUES ("S26_10","011_6_10","2SA","6","10","10","Ɩlɛnɑ Tɑfiiti kisi Ɩsɔ ɑtɑkɑɑ ponɑʋ kɛ ɩ tɛ nɑ ɩ́ ponɑ-ɩ Kɑtɩ tʋ wei pɑ yɑɑ sɩ Opɛtɩ-Ɩtɔm tɔ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("S26_11","011_6_11","2SA","6","11","11","Nɑ ɑtɑkɑɑ cɑɣɑ ɑpɑlʋ ɩnɩ ɩ tɛɣɛ ɩsɔtʋnɑɑ tooso. Ɩlɛnɑ Tɑcɑɑ nɑ́ɑ́ kooli ɩ́lɛ́ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ tǝnɑɣɑ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("S26_12","011_6_12","2SA","6","12","12","Ɩlɛnɑ pɑ́ tɑɣɑsɩ Tɑfiiti sɩ Tɑcɑɑ koolɑ Opɛtɩ-Ɩtɔm nɑ ɩ nyǝ́mɑ tǝnɑɣɑ kʋpɑntʋ kɛ Ɩsɔ ɑtɑkɑɑ tɔɔ. Ntɛnɑ wulɑʋ polo Opɛtɩ-Ɩtɔm tɛ nɑ ɩ kpɑɣɑ Ɩsɔ ɑtɑkɑɑ nɑ pɑ́ ponɑ ɩ tɛ nɑ ɑŋmɑɑlɑ. ");
INSERT INTO dop_vpl VALUES ("S26_13","011_6_13","2SA","6","13","13","Atɑkɑɑ sǝɣǝllɑɑ ɩ́ kpɛsɑ nɔɔhɛɛ nɑɑtoso nɑ ɑlɑɑfǝyɑ, ɩlɛ kɔtǝlɑɑ lɑ nɑʋ nɑ nɑʋle nim nyǝntɛ kɛ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S26_14","011_6_14","2SA","6","14","14","Ɩlɛnɑ Tɑfiiti fɛlɩ pɑɑlɛ kɛ teu kɛ ɑtɑkɑɑ ɩsɛntɑɑ nɑ ɩ́ suuwɑ kɔtǝlɑɑ toko tike. ");
INSERT INTO dop_vpl VALUES ("S26_15","011_6_15","2SA","6","15","15","Ḿpʋ́ɣʋ́ ɩ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ pɑ ponɑ Tɑcɑɑ ɑtɑkɑɑ kɛ Yosɑlɛm nɑ ɑkɑntɛɛ nɑ lɑŋhʋlʋmlɛ kɑkiisɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S26_16","011_6_16","2SA","6","16","16","Pɑ tɔŋnɑ Ɩsɔ ɑtɑkɑɑ sʋʋnɑʋ kɛ wulɑʋ ɩcɑtɛ tɑɑ, ɩlɛ Tɑfiiti ɑlʋ Mikɑɑlɩ Sɑyuli pɛɛlɔ sǝŋnɑ pǝtote ntɛ́ nɑ ɩ́ nɑ́ ɩ pɑɑkɩ nɑ ɩ́ ŋmɑɑkɩ ɑtɑkɑɑ ɩsɛntɑɑ. Ḿpʋ́ɣʋ́ Mikɑɑlɩ tʋʋ Tɑfiiti kɛ ɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S26_17","011_6_17","2SA","6","17","17","Pɑ tɑnɑ Ɩsɔ ɑtɑkɑɑ ɩlɛnɑ pɑ́ sɩɩ-ɩ ɩ lonte tɑɑ kɛ́ cokǝle nte Tɑfiiti kɑ lɑpɑ tɔ tǝ tɑɑ, nɑ pɑ́ lɑ́ kɔtɑsɩ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔ nɑ ciikuɣu nyǝnsɩ. ");
INSERT INTO dop_vpl VALUES ("S26_18","011_6_18","2SA","6","18","18","Pɑ tɛmɑ kɔtɑsɩ nsǝɣɩ lɑpʋ ɩlɛnɑ Tɑfiiti kooli yǝlɑɑ tǝnɑɣɑ kʋpɑntʋ kɛ Tomɑ tǝnɑ tʋ Tɑcɑɑ hǝtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S26_19","011_6_19","2SA","6","19","19","Ɩlɛnɑ Tɑfiiti tɑlɑ ɑpɑlɑɑ nɑ ɑlɑɑ mpɑ pɑɑ kotɑ tǝnɑ tɔɣɔ tɔɣɔnɑɣɑ. Pɑɑ wei kɛ potopoto, nɑ nɑntʋɣʋ, nɑ sʋlʋm, nɑ pɑ́ kpe. ");
INSERT INTO dop_vpl VALUES ("S26_20","011_6_20","2SA","6","20","20","Tɑfiiti mǝlɑ tǝyɑɣɑ sɩ ɩ kooliɣi ɩ nyǝ́mɑ kɛ kʋpɑntʋ, ɩlɛnɑ Mikɑɑlɩ lɩɩ nɑ ɩ́ sǝŋɩ-ɩ nɑ ɩ́ tɔmɩ-ɩ sɩ: Amɑ Ɩsɛɣɛlɩ wulɑʋ teeli ɩnɛɣɛ sɑŋɑ pɔpɔtʋ kɛ́. N wɔɣɔsɑ nyɑ́ kɑwulɑɣɑ wontu nɑ ń pɑɑkɩ nyɑ́ wɑɑlɩ nyǝ́mɑ yomɑɑ ɑlʋ nyǝ́mɑ ɩsɛntɑɑ ɩsɩɩ yʋlʋ kɛ yem. ");
INSERT INTO dop_vpl VALUES ("S26_21","011_6_21","2SA","6","21","21","Ntɛnɑ Tɑfiiti cɔ-ɩ sɩ: Tɑcɑɑ wei ɩ kisɑ nyɑ́ cɑɑ nɑ ɩ́ lǝsɩ-m sɩ mɑ́ lɑ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ tɔ ɩ ɩsɛntɑɑ kɛ́ mɑ pɑɑwɑ. ");
INSERT INTO dop_vpl VALUES ("S26_22","011_6_22","2SA","6","22","22","Mɑ cɑɑ mɑ pɑsɑ mɑ tɩ nɑ mɑ́ pǝsɩ kpɛtɛ nɑ pǝ́ kǝlɩ mpʋ. Pɑɑ nɑ mpʋ tɔ, mɑ nyʋɣʋ kɑ́ kʋlɩ yomɑɑ ɑlʋ nyǝ́mɑ mpɑ n yɔɣɔtǝɣɩ tɔ pɑ ɩsɛntɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S26_23","011_6_23","2SA","6","23","23","Sɑyuli pɛɛlɔ Mikɑɑlɩ nɑ ɩ sǝm tɔ ɩ tɑ lʋlɩ pǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Tɑcɑɑ yɑpɑ wulɑʋ kɛ ɩ kolontunɑɑ niŋ tɑɑ, ɩlɛnɑ ɩ́ mǝlɩ ɩ kɑwulɑɣɑ tǝyɑɣɑ kʋfɑlɑɣɑ tɑɑ nɑ hɛɛsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ ɩ tɔmɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ sɩ: Pǝ tɑ mʋnɑ sɩ mɑ́ɑ́ wɛɛ kutuluɣu kʋpɑŋkʋ tɑɑ nɑ Ɩsɔ ɑtɑkɑɑ nɑ́ɑ́ wɛ cokǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Ntɛnɑ Nɑtɑŋ cɔ wulɑʋ sɩ: Polo nɑ ń lɑ pǝ tǝnɑ mpi n mɑɣɑsǝɣɩ nyɑ́ tɑɑ tɔ. Mpi tɔ, Tɑcɑɑ wɛ nyɑ́ wɑɑlɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Ahoo yuwɑ ɩlɛnɑ Tɑcɑɑ tɔ Nɑtɑŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","Polo nɑ ń heeli mɑ pǝyɑlʋ Tɑfiiti sɩ pǝ tɑɣɑ ɩnɩ ɩ kɑ ŋmɑnɑ-m tǝyɑɣɑ ŋkɑ kɑ tɑɑ mɑɑ cɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Hɑtoo mɑ lǝsʋɣʋ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Icipiti tɑɑ nɑ pǝ́ sɩɩnɑ sɑŋɑ tɔ mɑ tɑ sʋʋtɑ kutuluɣu tɑɑ. Cokǝle tɑɑ kɛ́ mɑ wɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Too mɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝ lɩɩʋ tɔ, mɑ tɑ pɔɔsǝtɑ pɑ nyʋɣʋ nyǝ́mɑ mpɑ mɑ lǝsɑɑ tɔ pɑ tɑɑ nɔɣɔlʋ sɩ pepe tɔɔ kɛ́ pɑ tɑ ŋmɑ-m kutuluɣu kʋpɑŋkʋ. ");
INSERT INTO dop_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Mpʋ tɔ, heeli mɑ pǝyɑlʋ Tɑfiiti sɩ Tomɑ tǝnɑ tʋ Tɑcɑɑ mɑ́, mɑ yɔɣɔtɑɑ sɩ ntiɣile tɑɑ kɛ́ mɑ kpɑɣɑ-ɩ heeŋ wɑɑlɩ sɩ ɩ́ lɑ mɑ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ ");
INSERT INTO dop_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","nɑ mɑ́ɑ́ wɛ ɩ wɑɑlɩ kɛ́ ɩ tɔntɛ tǝnɑ tɑɑ. Ɩlɛnɑ mɑ́ kpiisi ɩ kolontunɑɑ tǝnɑ nɑ mɑ́ kʋsɩ ɩ nyʋɣʋ ɩsɩɩ ɑtɛ sɔsɑɑ lɛlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Ɩlɛnɑ mɑ́ hɑ mɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ tǝcɑɣɑlɛ sɩ pɑ́ cɑɣɑ teu nɑ pʋlʋ ɩ́ tɑɑ peɣeli-wɛ. Yǝlɑɑ ɑsɑɣɑɑ ɩ́ tɑɑ tɔɣɔ pɑ ɩsɛ, ");
INSERT INTO dop_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","ɩsɩɩ sɑɑ wei mɑɑ kpɑ pɑɑsǝnlɑɑ kɛ mɑ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ tɔ. Pǝyele mɑ yɑpɑ-ɩ ɩ kolontunɑɑ tǝnɑ niŋ tɑɑ sɩ ɩ́ hɛɛsɩ. Tɑcɑɑ sɩ: Pʋntʋ ɩnɩ ɩ kɑ sɩɩnɑ-m tǝyɑɣɑ, pǝ tɑɣɑ Tɑfiiti kɑ́ ŋmɑnɑ-kɛ. ");
INSERT INTO dop_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Ye pǝ tɑlɑ nyɑ́ kʋyɑkʋ nɑ n sǝpɑ ɩlɛ mɑɑ lǝsɩ nyɑ́ piyɑ mpɑ n lʋlǝnɑ nyɑ́ tɑpʋɣʋ tɔ pɑ tɑɑ nɔɣɔlʋ nɑ mɑ́ kpɑ-ɩ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Ɩnɩ ɩ kɑ́ ŋmɑnɑ-m tǝyɑɣɑ nɑ mɑɑ yele nɑ ɩ kɑwulɑɣɑ kumte wɛɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Ɩ kɑ́ nyǝnǝɣɩ-m ɩ cɑɑ nɑ mɑɑ nyǝnǝɣɩ-ɩ mɑ pǝyɑɣɑ. Ye ɩ pǝntǝnɑ-m mɑɑ hɔ ɩ kpɑŋʋɣʋ ɩsɩɩ pɑ lɑkʋɣʋ pǝyɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Amɑ mɑ kɑɑ yele-ɩ pɛɛlɛɛ hʋlʋɣʋ ɩsɩɩ mɑ lɑpʋ Sɑyuli nɑ mɑ́ lɔ-ɩ nɑ mɑ́ lɛɛtɩ-ŋ ɩ lonte tɔ. ");
INSERT INTO dop_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Nyɑ́ kɑwulɑɣɑ nɑ nyɑ́ kumte nɑ nyɑ́ piitim pɩɩ wɛɛ tɑm tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Nti nti Ɩsɔ heelɑ Tɑfiiti nɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ nɔɣɔ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S27_18","011_7_18","2SA","7","18","18","Mpʋɣʋlɛ Tɑfiiti polɑ Ɩsɔ cokǝle tɑɑ nɑ ɩ́ yɔɣɔtǝnɑ Ɩsɔ sɩ: Hɑɩ, Tɑcɑɑ tɑ Ɩsɔ, mɑ́ nɑ mɑ tǝyɑɣɑ tǝ kɛ́ we nɑ ń kɔŋnɑ-m timpi tɑɑ mɑ wɛ ɩsǝntɔ tɔ? ");
INSERT INTO dop_vpl VALUES ("S27_19","011_7_19","2SA","7","19","19","Pǝlɛ pǝ pɑɑsi nɑ ń tɑsǝɣɩ mɑ tǝyɑɣɑ sɩɩʋ tɔm nɑ? Ye pǝ tɑɣɑ Ɩsɔ, yʋlʋ kɑɑ pǝsɩ nɑ ɩ́ yɔɣɔtɩ mpʋ pǝ tɑkɑ. ");
INSERT INTO dop_vpl VALUES ("S27_20","011_7_20","2SA","7","20","20","Wentiɣi mɑ tɑkɑ mɑ wɛnɑ sɩ mɑ heeliɣi-ŋ? N nyǝmɑ-m kɛ́. ");
INSERT INTO dop_vpl VALUES ("S27_21","011_7_21","2SA","7","21","21","Nyɑ́ mɑɣɑmɑɣɑ n sɔɔlǝnɑ nɑ ń lɑ tǝmɑ sɔsɔɔnɑ ɑnɛ, nɑ ń kuli-m tɔm tǝnɛ tǝ tɔɔ ɩsɩɩ n kɑ yɔɣɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S27_22","011_7_22","2SA","7","22","22","Tɑcɑɑ Ɩsɔ n kɛ́ Sɔsɔ kɛ́. Mpi tɔ, nɔɣɔlʋ tɑ nǝɣǝsǝnɑ-ŋ. Ye tǝ kɛɛsǝnɑ nti ɩnɩ tǝ nɩɩnɑ tɑ ŋkpɑŋŋ tɔ nɔɣɔlʋ ɩ fɛɩ ɩsɩɩ nyɑ́. ");
INSERT INTO dop_vpl VALUES ("S27_23","011_7_23","2SA","7","23","23","Piitim nɑpǝlɩ pǝ fɛɩ nɑ pǝ́ nǝɣǝsǝnɑ nyɑ́ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ mpɑ n kɔmɑ nɑ ń yɑ sɩ tǝ pǝsɩ nyɑ́ nyǝ́mɑ nɑ nyɑ́ hǝtɛ yɑɑ nɑ ń lɑ-tʋɣʋ piti tǝmɑ nɑ kɔkɔlɔ nyǝm nɑ ń yɑ-tʋɣʋ Icipiti tɑɑ nɑ ń tɔɣɔnɩ piitimnɑɑ lɛlɑɑ nɑ pɑ tɩɩŋ. ");
INSERT INTO dop_vpl VALUES ("S27_24","011_7_24","2SA","7","24","24","Nɑ tǝ pǝsɩ nyɑ́ nyǝ́mɑ kɛ tɑm tɔɔ, nɑ nyɑɑ pǝsɩ tɑ Ɩsɔ. ");
INSERT INTO dop_vpl VALUES ("S27_25","011_7_25","2SA","7","25","25","Mpʋ tɔ, Tɑcɑɑ Ɩsɔ yele nɑ tɔm nti n yɔɣɔtɑ mɑ nɑ mɑ tǝyɑɣɑ tɑ́ tɔɔ tɔ tǝ́ lɑ nɑ tǝ́ wɛɛ ḿpʋ́ɣʋ́ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S27_26","011_7_26","2SA","7","26","26","Nyɑ́ hǝtɛ ɩ́ wɛɛ sɔsɔɔlɛ nɑ yǝlɑɑ pʋɣʋlǝɣɩ tɑm sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ Ɩsɔ kɛlɛ Tomɑ tǝnɑ tʋ Tɑcɑɑ nɑ ń pɑɑsǝɣǝnɑ mɑ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S27_27","011_7_27","2SA","7","27","27","Mpi tɔ, Tɑcɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ Ɩsɔ, nyɑ́ tʋnɑ nyɑ́ tɔm kɛ mɑ ŋkpɑŋŋ tɑɑ sɩ n kɑ́ sɩɩ mɑ tǝyɑɣɑ. Pǝ tɔɔ kɛ́ mɑ kɑɑsɑ mɑ tɩ nɑ mɑ́ sǝlǝmɩ-ŋ sǝlǝmʋɣʋ kʋnɛ. ");
INSERT INTO dop_vpl VALUES ("S27_28","011_7_28","2SA","7","28","28","Tɑcɑɑ Ɩsɔ, n kɛ́ Ɩsɔ kɛ́. Nɑ ń yɔɣɔtɑ nti n lɑkɩ-tǝɣɩ. Nyɑ́ kɛɛsǝnɑ-m nyɑ́ kʋpɑntʋ tǝnɛ tǝ tɔm. ");
INSERT INTO dop_vpl VALUES ("S27_29","011_7_29","2SA","7","29","29","Kooli mɑ tǝyɑɣɑ kɛ kʋpɑntʋ nɑ kɑ́ wɛɛ tɑm tɔɔ ɩsɩɩ n yɔɣɔtʋɣʋ tɔ, nɑ kʋpɑntʋ ntɩ tǝ́ wɛɛ kɑ tɔɔ kɛ́ tɑm. ");
INSERT INTO dop_vpl VALUES ("S28_1","011_8_1","2SA","8","1","1","Pǝlɛ pǝ wɑɑlɩ kɛ́ Tɑfiiti tɑsɑ Filiisi nyǝ́mɑ kɛ yoonɑʋ nɑ ɩ́ ŋmɑkǝlɩ-wɛ nɑ ɩ́ lɛɛkɩ pɑ ɩcɑtɛ sɔsɔɔlɛ nte pɛlɛ pɑɑ tɔɣɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S28_2","011_8_2","2SA","8","2","2","Ḿpʋ́ɣʋ́ Tɑfiiti yoonɑ Mowɑpʋ nyǝ́mɑ nɑ ɩ́ kpɑ-wɛɣɛ yomle. Ɩlɛnɑ ɩ́ hɩɩsɩ-wɛɣɛ ɑtɛ, nɑ pɑ́ kɑlɑ yǝlɑɑ tooso, ɩlɛ pɑ kʋ nɑɑlɛ. Pɑ́ kɑlɑ yǝlɑɑ tooso, pɑ kʋ nɑɑlɛ. Pǝ kɑɑsɑ mpɑ ɩlɛnɑ pɛlɛ pɑ́ lɑkɩ Tɑfiiti kɛ tǝmlɛ nɑ pɑ́ fɛlǝɣɩ-ɩ lɑmpuu. ");
INSERT INTO dop_vpl VALUES ("S28_3","011_8_3","2SA","8","3","3","Ḿpʋ́ɣʋ́ Tɑfiiti yoonɑ Lehopɩ pǝyɑlʋ Hɑtǝsɛɛ wei ɩ kɛ́ Sopɑ wulɑʋ tɔ nɑ ɩ́ kǝlɩ-ɩ wɑɑtʋ wei ɩ́lɛ́ ɩ kʋlɑɑ sɩ ɩ mʋɣɩ Ɩfǝlɑtɩ pɔɣɔ nɔɣɔ tɛtʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S28_4","011_8_4","2SA","8","4","4","Ɩlɛnɑ Tɑfiiti lɛɛkɩ ɩ kpɑɣɑnǝŋ cɑɣɑlɑɑ iyɑɣɑ nɑ nɑsǝtoso nɑ nɩɩnʋwɑ (1700) nɑ yoolɑɑ nɔɔhɛɛ tɔntɑɑ kɛ iyisi hiu (20000), nɑ ɩ́ sɛtɩ kpɑɣɑnǝŋ tǝnɑ nɔɔhɛɛ holɑ nɑ pǝ́ kɑɑsɩ ɩsɩɩ yoou kɛɛkɛnɑɑ nɩɩnʋwɑ (100) kpɑɣɑnǝŋ tike. ");
INSERT INTO dop_vpl VALUES ("S28_5","011_8_5","2SA","8","5","5","Ḿpʋ́ɣʋ́ Tɑmɑsɩ Silii nyǝ́mɑ polɑ wulɑʋ kɛ sǝnɑʋ, ɩlɛnɑ Tɑfiiti kʋ pɛlɛɣɛ yoolɑɑ iyisi hiu nɑ nɑɑlɛ (22000). ");
INSERT INTO dop_vpl VALUES ("S28_6","011_8_6","2SA","8","6","6","Nɑ ɩ́ ponɑ yoolɑɑ kɛ Tɑmɑsɩ Silii tɑɑ, nɑ ɩcɑtɛ nyǝ́mɑ lɑkɩ-ɩ tǝmlɛ nɑ pɑ́ fɛlǝɣɩ-ɩ lɑmpuu. Pɑɑ timpiɣi Tɑfiiti polɑɑ, Tɑcɑɑ kentɑɣɑɑ ɩ tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S28_7","011_8_7","2SA","8","7","7","Ɩlɛnɑ Tɑfiiti kpɑɣɑ Hɑtǝsɛɛ yoolɑɑ kpɑlǝŋ wʋlɑ nyǝŋ nɑ ɩ́ ponɑ Yosɑlɛm. ");
INSERT INTO dop_vpl VALUES ("S28_8","011_8_8","2SA","8","8","8","Ḿpʋ́ɣʋ́ Tɑfiiti kuu nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ nyǝɣǝtʋ kɛ sɔsɔm kɛ Hɑtǝsɛɛ ɑcɑlɛɛ nnɑ pɑ yɑɑ sɩ Petɑ nɑ Pelotɑyi tɔ ɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S28_9","011_8_9","2SA","8","9","9","Mpʋɣʋlɛ Hɑmɑtɩ wulɑʋ Tou nɩɩwɑ sɩ Tɑfiiti kʋwɑ Hɑtǝsɛɛ yoolɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S28_10","011_8_10","2SA","8","10","10","Ntɛnɑ ɩ́ tili ɩ pǝyɑlʋ Yolɑm kɛ Tɑfiiti tɛ sɩ: Polo nɑ ń sɛɛ-ɩ nɑ ń sɑmɩ-ɩ timpi ɩ pǝsɑɑ nɑ ɩ́ kpili Hɑtǝsɛɛ nɑ ɩ nyǝ́mɑ nɑ ɩ́ kʋ-wɛ tɔ. Mpi tɔ, Tou yookɑɣɑnɑ Hɑtǝsɛɛ kɛ́. Ɩlɛnɑ Solɑm ponɑ liɣitee nyǝɣǝtʋ nɑ wʋlɑ nɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɛ hɛɛsɩ hɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("S28_11","011_8_11","2SA","8","11","11","Ḿpʋ́ɣʋ́ Tɑfiiti sɩɩ nyǝɣǝtʋ ntǝɣɩ Tɑcɑɑ ɩsɩɩ ɩ kɑ sɩɩʋ liɣitee nyǝɣǝtʋ nɑ wʋlɑnɑɑ mpɑ ɩ lɛɛkɑ piitimnɑɑ mpɑ ɩ yoonɑɑ nɑ ɩ́ kǝlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S28_12","011_8_12","2SA","8","12","12","Ɩsɩɩ Silii nyǝ́mɑ nɑ Mowɑpʋ nyǝ́mɑ nɑ Amoni nyǝ́mɑ nɑ Filiisi nyǝ́mɑ nɑ Amɑleke nyǝ́mɑ nɑ Sopɑ wulɑʋ Hɑtǝsɛɛ nɑ ɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S28_13","011_8_13","2SA","8","13","13","Ɩsǝnɑ Tɑfiiti lɑpɑ nɑ ɩ nyʋɣʋ kʋlɩ tɔɣɔlɛ. Tɑfiiti kǝlɑ Silii nyǝ́mɑ nɑ ɩ́ mǝlǝɣɩ kpente, ɩlɛnɑ ɩ́ kʋ Ɩtɔm nyǝ́mɑ kɛ yǝlɑɑ iyisi pǝlefɛɩ hiu (18000) kɛ timpi pɑ yɑɑ sɩ Tɔm tɛtɛkǝlɛ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S28_14","011_8_14","2SA","8","14","14","Ɩ kǝlɑ Ɩtɔm nyǝ́mɑ ɩlɛnɑ ɩ́ sɩɩ yoolɑɑ kɛ pɑ tɛtʋ tǝnɑ tɑɑ nɑ ɩcɑtɛ nyǝ́mɑ lɑkɩ-ɩ tǝmlɛ. Pɑɑ timpiɣi Tɑfiiti polɑɑ, Tɑcɑɑ kentɑɣɑɑ ɩ tɔɔ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S28_15","011_8_15","2SA","8","15","15","Tɑfiiti tɔɣɔ kɑwulɑɣɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tɔɔ kɛ́ nɑ ɩ́ tǝŋǝɣɩ tɑmpɑnɑ nɑ ɩ́ pɑɑsǝɣǝnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S28_16","011_8_16","2SA","8","16","16","Seluyɑ pǝyɑlʋ Sowɑpɩ kɛlɛ yoolɑɑ nyʋɣʋ tʋ, nɑ Ahiluti pǝyɑlʋ Yosɑfɑtɩ kɛlɛ tɑkǝlɑsɩ sɩɩlʋ. ");
INSERT INTO dop_vpl VALUES ("S28_17","011_8_17","2SA","8","17","17","Ahitupi pǝyɑlʋ Sɑtɔkɩ nɑ Apiyɑtɑɑ pǝyɑlʋ Ahimelɛkɩ kɛlɛ kɔtǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S28_18","011_8_18","2SA","8","18","18","Selɑyɑ kɛlɛ tɑkǝlɑsɩ ŋmɑɑlʋ nɑ Yoyɑtɑ pǝyɑlʋ Penɑyɑ kɛlɛ yoolɑɑ mpɑ pɑ tɑŋɑɣɑ wulɑʋ tɔ pɑ nyʋɣʋ tʋ. Tɑfiiti pǝyɑlɑɑ ntɛ́ sɔpɑɑpǝnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S29_1","011_9_1","2SA","9","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Tɑfiiti pɔɔsɑɑ sɩ pǝ tɑ kɑɑsɩ Sɑyuli tǝyɑɣɑ tʋ nɔɣɔlʋ nɑ mɑ́ lɑpɩ-ɩ kʋpɑntʋ kɛ Sonɑtɑŋ tɔɔ? ");
INSERT INTO dop_vpl VALUES ("S29_2","011_9_2","2SA","9","2","2","Sɑyuli tǝyɑɣɑ tǝmlɛ tʋ nɔɣɔlʋ ɩ kɑ wɛ tǝnɑ nɑ pɑ́ yɑɑkɩ-ɩ sɩ Sipɑ. Mpʋɣʋlɛ pɑ kpɑɣɑ ɑpɑlʋ ɩnɩ nɑ pɑ́ ponɑ-ɩ Tɑfiiti kiŋ. Ɩlɛnɑ wulɑʋ pɔɔsɩ-ɩ sɩ: Nyɑɣɑ pɑ yɑɑkɩ sɩ Sipɑ? Apɑlʋ ɩnɩ ɩ tisɑɑ, ");
INSERT INTO dop_vpl VALUES ("S29_3","011_9_3","2SA","9","3","3","ɩlɛnɑ wulɑʋ pɔɔsɩ-ɩ sɩ: Pǝ tɑ kɑɑsɩ Sɑyuli tǝyɑɣɑ tʋ nɔɣɔlʋ nɑ mɑ́ lɑpɩ-ɩ kʋpɑntʋ kɛ Ɩsɔ tɔɔ? Ntɛnɑ ɑpɑlʋ ɩnɩ sɩ Sonɑtɑŋ pǝyɑlʋ wɛɛ nɑ pǝ́ kɑɑnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S29_4","011_9_4","2SA","9","4","4","Ntɛnɑ wulɑʋ sɩ: Ɩ wɛ le? Sipɑ sɩ: Ɩ wɛ Amiyɛlɩ pǝyɑlʋ Mɑkii tɛɣɛ timpi pɑ yɑɑ sɩ Lo-Tɑpɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S29_5","011_9_5","2SA","9","5","5","Ɩlɛnɑ wulɑʋ tili nɑ pɑ́ kɔnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S29_6","011_9_6","2SA","9","6","6","Sonɑtɑŋ pǝyɑlʋ Mefipɑɑlɩ tɑlɑ Tɑfiiti tɛ ɩlɛnɑ ɩ́ hǝntɩ-ɩ ɑtɛ. Ḿpʋ́ɣʋ́ ɩ yɑɑ ɩ hǝtɛ ɩlɛnɑ ɩ sɛɛ sɩ: Mɑɣɑlɔ tɑ cɑɑ. ");
INSERT INTO dop_vpl VALUES ("S29_7","011_9_7","2SA","9","7","7","Ntɛnɑ wulɑʋ sɩ: Tɑɑ nyɑ́, mɑ cɑɑ mɑ lɑ-ŋ kʋpɑntʋ kɛ nyɑ́ cɑɑ Sonɑtɑŋ tɔɔ. Mɑɑ cɛlɛ-ŋ nyɑ́ cɔsɔ Sɑyuli tɛtʋnɑɑ tǝnɑ nɑ mɑ́ nɑ-ŋ tɩɩ tɔkǝnɑ tǝntǝmlɛ kɛ tɑm. ");
INSERT INTO dop_vpl VALUES ("S29_8","011_9_8","2SA","9","8","8","Ḿpʋ́ɣʋ́ Mefipɑɑlɩ tɑsɑ hǝntʋɣʋ kɛ ɑtɛ nɑ ɩ́ tɔ sɩ: Hɑɩ, tɑ cɑɑ, mɑɣɑlɛ ɑwe, mɑ wɛ ɩsɩɩ hɑɣɑ kʋsǝpɑɣɑ kɛ́ nɑ ń pɑɑsǝɣǝnɑ-m mpʋ ɩnɩ? ");
INSERT INTO dop_vpl VALUES ("S29_9","011_9_9","2SA","9","9","9","Kɛlɛnɑ wulɑʋ yɑɑ Sipɑ nɑ ɩ́ heeli-ɩ sɩ: Mɑ cɛlǝɣɩ nyɑ́ cɑɑ Sɑyuli nɑ ɩ tǝyɑɣɑ nyǝ́mɑ nyǝm tǝnɑɣɑ Mefipɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S29_10","011_9_10","2SA","9","10","10","Nyɑ́ nɑ nyɑ́ piyɑ nɑ nyɑ́ tǝmlɛ nyǝ́mɑ ɩ kɑ́ hɑlǝɣɩ-ɩ kɛ́ nɑ ɩ́ tɑɑ lɑŋ kʋhɑlǝm. Ɩlɛ mɑ nɑ-ɩ tɩɩ tɔkǝnɑ tǝntǝmlɛ kɛ tɑm. Pǝyele Sipɑ kɑ wɛnɑ piyɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ kɛ́, nɑ tǝmlɛ nyǝ́mɑ kɛ hiu. ");
INSERT INTO dop_vpl VALUES ("S29_11","011_9_11","2SA","9","11","11","Ntɛnɑ Sipɑ cɔ wulɑʋ sɩ: Tɑ cɑɑ, mɑɑ lɑ teitei kɛ́ ɩsɩɩ n heelɑ-m tɔ. Ɩlɛnɑ Mefipɑɑlɩ sʋʋ wulɑʋ kiŋ kɛ tɔɣɔʋ ɩsɩɩ ɩ mɑɣɑmɑɣɑ ɩ kʋlʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S29_12","011_9_12","2SA","9","12","12","Mefipɑɑlɩ kɑ wɛnɑ pǝyɑɣɑ sǝkpelɑɣɑ nɑkǝlɩ nɑ pɑ́ yɑɑ-kɛ sɩ Mikɑ. Ḿpʋ́ɣʋ́ Sipɑ tǝyɑɣɑ nyǝ́mɑ tǝnɑ pǝsɑ ɩ tǝmlɛ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S29_13","011_9_13","2SA","9","13","13","Yosɑlɛm kɛ ɩ kɑ wɛɛ. Mpi tɔ, ɩ nɑ wulɑʋ pɑ tɔkɑɣɑnɑ. Pǝyele pɩɩ kɑɑnɑ Mefipɑɑlɩ nɔɔhɛɛ nɑɑlɛɣɛ. ");
INSERT INTO dop_vpl VALUES ("S210_1","011_10_1","2SA","10","1","1","Pǝlɛ pǝ wɑɑlɩ kɛ́ Amoni wulɑʋ Nɑhɑsɩ sǝpɑ nɑ ɩ pǝyɑlʋ Hɑnuŋ lɛɛtɩ ɩ lonte tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S210_2","011_10_2","2SA","10","2","2","Mpʋɣʋlɛ Tɑfiiti tɔmɑ sɩ: Mɑɑ lɛɛtɩ Hɑnuŋ kɛ kʋpɑntʋ kɛ nti ɩ cɑɑ kɑ lɑpɑ-m tɔ. Ɩlɛnɑ ɩ́ tili sɩ pɑ́ sɛɛ-ɩ ɩ cɑɑ lǝyɑɣɑ. Tǝmlɛ nyǝ́mɑ tɑlɑ Amoni nyǝ́mɑ tɛtʋ tɑɑ, ");
INSERT INTO dop_vpl VALUES ("S210_3","011_10_3","2SA","10","3","3","ɩlɛnɑ tɛtʋ ntɩ tǝ ɑwulɑɑ sǝkpemɑ tɔ pɑ wulɑʋ Hɑnuŋ sɩ: N nyǝ́mɑ sɩ lǝyɑɣɑ sɛɛʋ tɔɔ kɛ́ Tɑfiiti tilɑ ɩ yǝlɑɑ nɑ? Ɩ tilɑ-wɛɣɛ sɩ pɑ́ feŋ tɑ ɩcɑtɛ nɑ pɑ́ nyɩ-tɛ nɑ pɑ́ wɑkǝlɩ-tɛ. ");
INSERT INTO dop_vpl VALUES ("S210_4","011_10_4","2SA","10","4","4","Tǝnɑɣɑlɛ Hɑnuŋ kpɑ Tɑfiiti tillɑɑ mpɛ nɑ ɩ́ hʋ pɑ tɑntǝŋ kɛ nnyɛnyɛkǝŋ, nɑ ɩ́ sɛtɩ pɑ tokonɑɑ nɑ pǝ́ kpɑ pɑ tɑpɑnɔɔsɩ. Ɩlɛnɑ ɩ yele-wɛ. ");
INSERT INTO dop_vpl VALUES ("S210_5","011_10_5","2SA","10","5","5","Ḿpʋ́ɣʋ́ fɛɛlɛ kpɑ-wɛɣɛ sɔsɔm. Tɑfiiti nɩɩ mpi pɑ lɑpɑ-wɛ tɔ, ɩlɛnɑ ɩ́ tili sɩ pɑ́ sɑɑlɩ Yeliko hɑlǝnɑ pɑ tɑntǝŋ nyɔ, ɩlɛnɑ pǝ́cɔ́ pɑ́ kpe. ");
INSERT INTO dop_vpl VALUES ("S210_6","011_10_6","2SA","10","6","6","Ḿpʋ́ɣʋ́ Amoni nyǝ́mɑ cɛkǝnɑɑ sɩ Tɑfiiti hɑɣɑ-wɛ nɑ pɑ́ɑ́nɑ́ kɛ pɑ ɩsɑɣɑtʋ ntɩ tǝ tɔɔ. Ɩlɛnɑ pɑ́ polo Pɛtɩ-Lehopɩ nɑ Sopɑ Silii nyǝ́mɑ kiŋ nɑ pɑ́ kpɑɣɑ yoolɑɑ ɑpɑɑ nyǝ́mɑ kɛ iyisi hiu (20000), nɑ Mɑɑkɑ wulɑʋ tɛɣɛ yoolɑɑ iyɑɣɑ (1000), nɑ Topi nyǝ́mɑ tɛɣɛ yoolɑɑ iyisi nɑɑnʋwɑ nɑ nɑɑlɛ (12000). ");
INSERT INTO dop_vpl VALUES ("S210_7","011_10_7","2SA","10","7","7","Tɑfiiti nɩɩ mpʋ, ɩlɛnɑ ɩ́ tili ɩ yoolɑɑ nyʋɣʋ tʋ Sowɑpɩ nɑ yoolɑɑ ɑpɑlɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S210_8","011_10_8","2SA","10","8","8","Mpʋɣʋlɛ Amoni nyǝ́mɑ lɩɩwɑ nɑ pɑ́ pɩɩlɩ pɑ ɩcɑtɛ nɔnɔɣɔ, nɑ Sopɑ nɑ Pɛtɩ-Lehopɩ Silii nyǝ́mɑ nɑ Topi nɑ Mɑɑkɑ pǝ yǝlɑɑ nɑ́ɑ́ wɛ tɑwɑ tɑɑ nɑ pɑ mpɑɑ. ");
INSERT INTO dop_vpl VALUES ("S210_9","011_10_9","2SA","10","9","9","Ɩlɛnɑ Sowɑpɩ cɛkǝnɑ sɩ ɩ kɑ́ yoo tɑɑ nɑ wɑɑlɩ. Ḿpʋ́ɣʋ́ ɩ lǝsɑ Ɩsɛɣɛlɩ yoolɑɑ tɑɑ yoolɑɑ nɑ pɛlɛ pɑ́ yookinɑ Silii nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S210_10","011_10_10","2SA","10","10","10","Pǝ kɑɑsɑ mpɑ ɩlɛnɑ ɩ́ yelinɑ pɛlɛɣɛ ɩ neu Apisɑyi sɩ pɛlɛ pɑ́ yoonɑ Amoni nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S210_11","011_10_11","2SA","10","11","11","Nɑ ɩ́ heeli-ɩ sɩ: Ye Silii nyǝ́mɑ ɩ́ kpilɑ-m, ɩlɛ n kɔɔ nɑ ń sǝnɑ-m, yɑɑ ye Amoni nyǝ́mɑ kpilinɑ nyɑ́, ɩlɛ mɑ́ɑ́ kɔɔ nɑ mɑ́ sǝnɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S210_12","011_10_12","2SA","10","12","12","Tɔɣɔ ɑpɑlʋtʋ nɑ tǝ́ kɑɑsɩ tɑ tǝɣɩ tɑ yǝlɑɑ nɑ tɑ Ɩsɔ ɑcɑlɛɛ tɔɔ. Ɩlɛ Tɑcɑɑ ɩ́ lɑ ɩ luɣu nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("S210_13","011_10_13","2SA","10","13","13","Ḿpʋ́ɣʋ́ Sowɑpɩ nɑ ɩ yǝlɑɑ pɑ sʋʋ Silii nyǝ́mɑ tɛɛ sɩ pɑ́ yookinɑ-wɛ nɑ pɛlɛ pɑ́ tʋ cɑsǝlɛ. ");
INSERT INTO dop_vpl VALUES ("S210_14","011_10_14","2SA","10","14","14","Amoni nyǝ́mɑ nɑ́ nɑwɑ sɩ Silii nyǝ́mɑ sewɑ, ɩlɛnɑ pɛlɛ pɑ́ tʋ-tɛ nɑ pɑ́ sʋʋ ɩcɑtɛ. Ɩlɛnɑ Sowɑpɩ mǝlɩ nɑ ɩ́ kpe Yosɑlɛm. ");
INSERT INTO dop_vpl VALUES ("S210_15","011_10_15","2SA","10","15","15","Silii nyǝ́mɑ nɑwɑ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ kǝlɑ-wɛ, ɩlɛnɑ pɑ́ koti pɑ yoolɑɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S210_16","011_10_16","2SA","10","16","16","Ḿpʋ́ɣʋ́ wulɑʋ Hɑtǝsɛɛ tilɑɑ nɑ pɑ́ yɑɑ Ɩfǝlɑtɩ pɔɣɔ wɑɑlɩ Silii nyǝ́mɑ lɛlɑɑ nɑ ɩ yoolɑɑ wulɑʋ Sopɑkɩ kpɑɣɑ-wɛ nɑ pɑ́ tɛɛ Helɑm. ");
INSERT INTO dop_vpl VALUES ("S210_17","011_10_17","2SA","10","17","17","Pɑ heelɑ-tǝɣɩ Tɑfiiti, ɩlɛnɑ ɩ́ koti Ɩsɛɣɛlɩ yoolɑɑ tǝnɑ nɑ pɑ́ tɛsɩ Yɑɑtɑnɩ nɑ pɑ́ polo Helɑm. Ḿpʋ́ɣʋ́ Silii nyǝ́mɑ tɑɣɑnɑ pɑ tɩ nɑ pɑ́ nɑ Tɑfiiti pɑ́ suli nɑ pɑ́ yoo. ");
INSERT INTO dop_vpl VALUES ("S210_18","011_10_18","2SA","10","18","18","Amɑ pɑ kuu-tɛɣɛ Ɩsɛɣɛlɩ nyǝ́mɑ ɩsɛntɑɑ, nɑ Tɑfiiti kʋ yoou kɛɛkɛnɑɑ nɑsǝtoso nɑ nɩɩnʋwɑ (700) pɑɑsǝnlɑɑ nɑ kpɑɣɑnǝŋ cɑɣɑlɑɑ kɛ iyisi nɩɩlɛ (40000) nɑ ɩ́ kʋ pɑ yoou wulɑʋ Sopɑkɩ. ");
INSERT INTO dop_vpl VALUES ("S210_19","011_10_19","2SA","10","19","19","Ḿpʋ́ɣʋ́ Hɑtǝsɛɛ wɑɑlɩ ɑwulɑɑ sǝkpemɑ nɑwɑ sɩ Ɩsɛɣɛlɩ nyǝ́mɑ kʋ pɑ yǝlɑɑ kɛ sɔsɔm, ɩlɛnɑ pɑ́ polo nɑ pɑ́ nɑ-wɛ pɑ́ ciiki nɑ pɑ́ lɑkɩ-wɛɣɛ tǝmlɛ. Silii nyǝ́mɑ tɑ pǝsɩ tɔtɔ sɩ pɑ́ sǝnɑ Amoni nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Pǝnɑɣɑ sikɑɑ nɑ pǝ́ tɑlɑ wɑɑtʋ wei ɑwulɑɑ tɛɛkɩ yoou tɔ, ɩlɛnɑ Tɑfiiti kʋsɩ ɩ yoolɑɑ wulɑʋ Sowɑpɩ nɑ Ɩsɛɣɛlɩ yoolɑɑ tǝnɑ sɩ pɑ́ polo pɑ́ kʋ Amoni nyǝ́mɑ tǝnɑ nɑ pɑ́ lɛɛkɩ Lɑpɑ ɩcɑtɛ. Amɑ Tɑfiiti mɑɣɑmɑɣɑ tɑ polo. ");
INSERT INTO dop_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Tɑfiiti lɩɩnɑ tǝhǝntǝlɛ kɛ tɑɑnɑɣɑ, nɑ ɩ́ cɔɔkɩ kutuluɣu pɑtɑ tɔɔ. Ɩlɛ ɩ loosɑ ɑlʋ nɔɣɔlʋ ɩ sɔɔkɩ lʋm ntɛ, nɑ ɩ ɩsɛntɑɑ lɩɩwɑ pǝ tɩɩ fɛɩ. ");
INSERT INTO dop_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Ḿpʋ́ɣʋ́ ɩ tilɑɑ nɑ pɑ́ pɔɔsɩ ɩ tɔɔ. Ɩlɛnɑ pɑ́ cɔ-ɩ sɩ Ɩliyɑm pɛɛlɔ Pɑsepɑ kɛ́. Ɩ pɑɑlʋ kɛlɛ Hiti tʋ Yulii. ");
INSERT INTO dop_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Ntɛnɑ ɩ́ tili nɑ pɑ́ ponɑ-ɩ ɑlʋ ɩnɩ nɑ ɩ́ sʋʋnɑ-ɩ nɑ ɩ́lɛ́ ɩ́ mǝlɩ ɩ tɛ. Pǝyele ɩ kɑ tɛmɑ ɩsɔtʋ nɑʋ ntɛ́ kpɑkpɑɑ nɑ ɩ́ lɑ ɑsilimɑ kɛɛlʋɣʋ kɔtɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Alʋ nɑwɑ ɩ tɩ nɑ teu ɩlɛnɑ ɩ́ tili nɑ ɩ́ heeli Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Mpʋɣʋlɛ Tɑfiiti tilɑɑ nɑ ɩ́ heeli Sowɑpɩ sɩ ɩ́ yele Hiti tʋ Yulii nɑ ɩ́ kɔɔ. Ɩlɛnɑ Sowɑpɩ nɑ́ɑ́ yele Yulii. ");
INSERT INTO dop_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Yulii kɔmɑ ɩlɛnɑ Tɑfiiti pɔɔsɩ-ɩ Sowɑpɩ nɑ yoolɑɑ nɑ yoou pɑ ɑlɑɑfǝyɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Ḿpʋ́ɣʋ́ Tɑfiiti heelɑ Yulii sɩ: Polo nyɑ́ tɛ nɑ ń hɛɛsɩ. Yulii lɩɩwɑ ɩlɛnɑ wulɑʋ lɑpɩ-ɩ kʋcɔɔʋ nɑ pɑ́ ponɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Amɑ ɩ́lɛ́ ɩ tɑ sʋʋ ɩ tɛ. Ɩ nɑ wulɑʋ tɑŋlɑɑ pɑ hǝntǝnɑ nɔnɔɣɔ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Ḿpʋ́ɣʋ́ pɑ tɑɣɑsɑ-tǝɣɩ wulɑʋ nɑ ɩ́lɛ́ ɩ pɔɔsɩ-ɩ sɩ: Anɩ n lɩɩnɑ mpɑɑʋ kɛ́. Ɩlɛ pepe tɔɔ kɛ́ n tɑ sʋʋ tǝyɑɣɑ? ");
INSERT INTO dop_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Ḿpʋ́ɣʋ́ Yulii cɔ-ɩ sɩ: Ɩsɔ ɑtɑkɑɑ nɑ Yutɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ hǝntǝɣɩ cokɑ tɑɑ kɛ́. Mɑ cɑɑ Sowɑpɩ nɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ́ wɛ nyɩɩtʋ tɑɑ. Ɩlɛnɑ mɑ́ɑ́ sʋʋ mɑ tǝyɑɣɑ tɑɑ nɑ mɑ́ tɔɣɔ nɑ mɑ́ nyɔɔ, nɑ mɑ́ hǝntǝnɑ mɑ ɑlʋ nɑ? Mɑ tuunɑ-ŋ sɩ mɑ kɑɑ lɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Ntɛnɑ Tɑfiiti heeli-ɩ sɩ: Tɔʋ, hɛɛsɩ sɑŋɑ, cele ɩlɛ mɑɑ yele nɑ ń mǝlɩ. Ɩlɛnɑ Yulii cɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Ḿpʋ́ɣʋ́ Tɑfiiti yɑɑ-ɩ ɩ tɛ nɑ ɩ́ tɔɣɔ nɑ ɩ́ nyɔɔ nɑ pǝ́ kʋ-ɩ. Pɑɑ nɑ mpʋ, ɑhoo yuwɑ tɔ, ɩ tɑ polo ɩ tɛ, ɩ́ nɑ tɑŋlɑɑ pɑ hǝntǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Tɛʋ femɑ ɩlɛnɑ Tɑfiiti ŋmɑɑ Sowɑpɩ kɛ tɑkǝlɑɣɑ nɑ ɩ́ tilinɑ-kɛɣɛ Yulii mɑɣɑmɑɣɑ ");
INSERT INTO dop_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","sɩ pɑ́ tɛlǝsɩ-ɩ timpi yoou hɑŋɑ teu tɔ nɑ pɑ́ yele-ɩ nɑ pɑ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Sowɑpɩ nyɑlɑ ɩcɑtɛ, ɩlɛnɑ ɩ́ ponɑ Yulii kɛ timpi yoolɑɑ tɑɑ yoolɑɑ tɑŋɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Ḿpʋ́ɣʋ́ ɩcɑtɛ nyǝ́mɑ lɩɩwɑ nɑ pɑ́ yoonɑ Sowɑpɩ nɑ ɩ nyǝ́mɑ nɑ pɑ́ kʋ Tɑfiiti yoolɑɑ pɑɣɑlɛ nɑ pɑ́ kpɛŋnɑ Yulii nɑ pɑ́ kʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Ɩlɛnɑ Sowɑpɩ ŋmɑɑ Tɑfiiti kɛ tɑkǝlɑɣɑ nɑ ɩ́ kɛɛsɩ-ɩ pǝ tǝnɑ mpi pǝ lɑpɑ tǝyoole tɔ. ");
INSERT INTO dop_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","Ḿpʋ́ɣʋ́ Tɑfiiti lɛlɑ tillu kɛ heeluɣu sɩ: Ye ń kɛɛsɑ wulɑʋ kɛ tɑ cɑkǝlɛ tɔm kɛ cǝnɛ, ");
INSERT INTO dop_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","ntɑnyɩ pɑ́ɑ́nɑ́ kɑ kpɑ-ɩ nɑ ɩ́ yɔɣɔtɩ sɩ pepe tɔɔ kɛ́ tǝ sʋʋ ɩcɑtɛ tɛɛ sɩ tǝ yookinɑ-tɛ. Anɩ tǝ nyǝmɑɣɑ sɩ ɩcɑtɛ nyǝ́mɑ tɔɔkɩ nyǝ́mɑ́. ");
INSERT INTO dop_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","Ḿpʋ́ɣʋ́ ɑlʋ kɑ kʋnɑ Ketiyɔŋ pǝyɑlʋ Apimelɛkɩ. Tɛpɛɛsɩ ɩcɑtɛ tɛɛ kɛ́ ɩ kɑ sʋʋ mpʋ nɑ ɑlʋ yɑɣɑ-ɩ nɑmlɛ hɔɣɔlʋɣʋ nɑ koluŋɑ nyʋɣʋ tɑɑ. Ɩlɛ pepe tɔɔ kɛ́ tɑ́ kpǝtǝnɑ koluŋɑ kɛ mpʋ? Ɩlɛ n cɔ-ɩ sɩ nyɑ́ pǝyɑlʋ Yulii nɑ́ sǝpɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Ḿpʋ́ɣʋ́ tillu kɛɛsɑ Tɑfiiti kɛ nti Sowɑpɩ kɛɛsɑ-ɩ tɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","Kolontunɑɑ mpɛ pɑ kpilɑ-tʋɣʋ. Pɑ lɩɩ-tʋɣʋ kʋlɩɩʋ kɛ tɑwɑ tɑɑ nɑ tɑɑ tɔɣɔnɩ-wɛ nɑ tǝ́ tɑnɑ-wɛɣɛ pɑ ɩcɑtɛ nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Ɩlɛnɑ koluŋɑ tɔɔ sǝŋlɑɑ nɑ́ɑ́ tɔ-tʋɣʋ nyǝ́mɑ́ nɑ pɑ́ kʋ tɑ tɑɑ pɑɣɑlɛ. Hɑlɩ nyɑ́ pǝyɑlʋ Yulii nɑ́ sǝpɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Tǝnɑɣɑlɛ Tɑfiiti cɔwɑ tillu sɩ: Polo nɑ ń heeli Sowɑpɩ sɩ, pɑɑ pǝ kʋwɑ ɩ yǝlɑɑ tɔ pǝ tɑɑ kǝlɩ-ɩ cɑɑlʋɣʋ. Pǝ wɛɛ kɛ́ sɩ ɩ́ polo ɩcɑtɛ tɔɔ nɑ toŋ nɑ ɩ́ kǝlɩ-tɛ. Nyɑɑ polɑɑ ń tɑsɑ-ɩ ḿpʋ́ɣʋ́ ɑpɑlʋtʋ. ");
INSERT INTO dop_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Yulii ɑlʋ nɩɩwɑ sɩ ɩ pɑɑlʋ sǝpɑ, ɩlɛnɑ ɩ́ wii-ɩ. ");
INSERT INTO dop_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Lǝyɑɣɑ tɛmɑ, ɩlɛnɑ Tɑfiiti tili nɑ ɩ́ kpɑɣɑ ɑlʋ nɑ ɩ́ lʋlɩ-ɩ ɑpɑlʋ pǝyɑɣɑ. Ḿpʋ́ɣʋ́ Tɑfiiti kʋlɑpǝtʋ ntɩ tǝ tɑ mɑɣɑ Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ tilɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ kɛ Tɑfiiti kiŋ nɑ ɩ́ heeli-ɩ sɩ: Apɑlɑɑ nɑpǝlɩ pɑɑ wɛnɑ nɑɑlɛ kɛ ɩcɑtɛ kʋlʋmtǝlɛ tɑɑ, lɛlʋ kɛ toŋ tʋ nɑ lɛlʋ kɛ kʋnyɔntʋ. ");
INSERT INTO dop_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Toŋ tʋ ɩnɩ ɩ kɑ wɛnɑ nɑɑŋ nɑ heeŋ kɛ sɔsɔm pǝ fɛɩ nyǝnʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Hewɑɣɑ kʋlʋmɑɣɑ kɛ kʋnyɔntʋ nɑ́ɑ́ wɛnɑ nɑ ɩ́ tɔɔkɩ, nɑ kɑ́ nɑ ɩ piyɑ pɑ wɛɛ nɑ pɑ́ tɔkɩ nɑ pɑ́ nyɔɔkɩ tǝntǝmlɛ, nɑ kɑ́ hǝntǝɣɩ ɩ tɑtɛ tɑɑ nɑ ɩ́ nyǝnǝɣɩ-kɛ ɩsɩɩ ɩ pɛɛlɔ. ");
INSERT INTO dop_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ ɩkɔm kɔmɑ toŋ tʋ ɩnɩ nɑ ɩ́ lɑ ɩ tɔlɑ pǝtɔɔtǝlɛ, nɑ ɩ́ kisi ɑ tɑɑ kɛ́ lǝsʋɣʋ sɩ ɩ lɑkǝnɑ ɩkɔm ɩnǝɣɩ mʋʋllɛ. Nɑ ɩ́ kpɑ kʋnyɔntʋ hewɑɣɑ ŋkɛ nɑ ɩ́ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S212_5","011_12_5","2SA","12","5","6","Tǝnɑɣɑlɛ Tɑfiiti pɑ́ɑ́nɑ́ huuwɑ kpɑkpɑɑ tǝfɑɑ nɑ ɩ́ tɔ sɩ: Mɑ tuunɑ Tɑcɑɑ sɩ yʋlʋ wei ɩnɩ ɩ lɑpɑ mpʋ tɔ pǝ wɛɛ sɩ ɩ́ fɛlɩ heeŋ liɣiti kɛ yɑɑsi wei ɩ lɑpɑ mpʋ nɑ ɩ́ fɛɩnɑ pǝtɔɔtǝlɛ tɔ. Pǝyele pǝ tɩɩ mʋnɑ pɑ́ kʋ-ɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Ntɛnɑ Nɑtɑŋ sɩ: Nyɑɣɑlɛ yʋlʋ ɩnɩ. Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ yɔɣɔtɑɑ sɩ ɩnɩ ɩ kpɑnɑ-ŋ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ nɑ ɩ́ yɑ-ŋ Sɑyuli niŋ tɑɑ ");
INSERT INTO dop_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","nɑ ɩ́ hɑ-ŋ tǝyɑɣɑ nɑ ɑlɑɑ nɑ ɩ́ tʋ nyɑ́ niŋ tɑɑ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ Yutɑ nyǝ́mɑ. Ye n kɑ heelɑ-ɩ sɩ pǝlɛ pǝ tɑ tɔɔ-ŋ ɩ kɑ sɔɔsɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","Pepe tɔɔ kɛ́ n nyǝnɑ Tɑcɑɑ tɔm kɛ yem nɑ ń lɑ mpi pǝ tɑ mɑɣɑ-ɩ tɔ? N kʋ Yulii nɑ Amoni nyǝ́mɑ lɑɣɑtɛ, nɑ ń kpɑɣɑ ɩ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Timpi n nyǝnɑ-ɩ yem kɛ mpʋ nɑ ń kpɑɣɑ Yulii ɑlʋ tɔ, yoou kɑɑ hɑtǝlǝnɑ nyɑ́ tǝyɑɣɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑɑ sɩ: Mɑɑ yele nɑ nyɑ́ piyɑ tɑɑ nɔɣɔlʋ wɑkǝlɩ nyɑ́ lɑŋlɛ. Mɑɑ hɑ nɔɣɔlʋɣʋ nyɑ́ ɑlɑɑ kɛ nyɑ́ ɩsɛntɑɑ nɑ ɩ́lɛ́ ɩ sʋʋnɑ-wɛ nɑ ilim nɑ pǝ ɩsǝlɛ. ");
INSERT INTO dop_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Nyɑ́ ŋmɛlɑɑ kɛ́ nɑ n lɑ nɔɣɔlʋ tɑ nɑ. Amɑ ilim tɑɑ kɛ́ mɑɑ lɑ mɑ nyǝntʋ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɑ. ");
INSERT INTO dop_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Tǝnɑɣɑ Tɑfiiti tɔmɑ sɩ: Mɑ wɑkǝlǝnɑ Tɑcɑɑ kɛ́. Ɩlɛnɑ Nɑtɑŋ nɑ́ɑ́ tɔmɩ-ɩ sɩ: Tɑcɑɑ hɩɩsɑ nyɑ́ ɩsɑɣɑtʋ, n kɑɑ tɑsɑ sǝm. ");
INSERT INTO dop_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Amɑ timpi n yelɑɑ nɑ Tɑcɑɑ kolontunɑɑ kpɑ ɩ tɔɔ nɑ pɑ́ nɩ pʋntʋ tɔ, pǝyɑɣɑ ŋkɑ pǝ lʋlɑ-ŋ tɔ ŋkɛ kɑɑ sǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Ḿpʋ́ɣʋ́ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ kpemɑ ɩ tɛ. Ḿpʋ́ɣʋ́ Tɑcɑɑ yelɑɑ nɑ kʋtɔŋ sɔsɔɔʋ nɑkʋlɩ kʋ kpɑ Yulii leelu pǝyɑɣɑ ŋkɛ. ");
INSERT INTO dop_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Ḿpʋ́ɣʋ́ Tɑfiiti hɔkɑ nɔɣɔ nɑ ɩ́ sǝlǝmɩ Tɑcɑɑ kɛ pǝyɑɣɑ ŋkɛ kɑ tɔɔ. Atɛɣɛ ɩ hǝntɑɣɑ pɑɑ ɑhoo nnɑ, nyɑɑlʋɣʋ fɛɩ. ");
INSERT INTO dop_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Ɩlɛnɑ ɩ tǝyɑɣɑ sɔsɑɑ kɑɑnɑ-ɩ sɩ ɩ́ kʋlɩ ɑtɛ ɩ tɑ tisi. Pǝ́cɔ́ ɩ kisɑ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Ɩlɛnɑ pǝyɑɣɑ sɩ kʋyɑkʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋkʋ wule. Amɑ Tɑfiiti wɑɑlɩ nyǝ́mɑ nyɑmnɑ-ɩ kɑ sǝm tɔm kɛ heeluɣu. Mpi tɔ, pɑ mɑɣɑsɑɣɑ pɑ tɑɑ kɛ́ sɩ, wʋsɑsɩ tɑɑ kɛlɛ tǝ yɔɣɔtɑɣɑnɑ-ɩ ɩ tɑ cɔ, kɑ lɑɑlɑɑ nɑ kɑ́ sɩ́ ɩsǝntɔ tɔ ye tǝ heelɑ-ɩ ɩ lɑŋlɛ kɑ́ tɛɛsɩ wɑkǝlʋɣʋ tǝtɔɣɔtɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Ɩlɛ Tɑfiiti nɩɩwɑ pɑ wɛlǝtǝɣɩ tǝmɑɣɑlɛ, ɩlɛnɑ ɩ́ cɛkǝnɑ sɩ pǝyɑɣɑ sǝpɑ. Ntɛnɑ ɩ́ pɔɔsɩ-wɛ sɩ: Kɑ sǝpɑɣɑ? Pɛlɛ sɩ: Ɛɛ. ");
INSERT INTO dop_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Tǝnɑɣɑlɛ Tɑfiiti kʋlɑ ɑtɛ nɑ ɩ́ sɔ lʋm nɑ ɩ́ lɑɣɑsɩ wontu. Ɩlɛnɑ ɩ́ sʋʋ Tɑcɑɑ tǝyɑɣɑ tɑɑ nɑ ɩ́ hǝntɩ-ɩ ɑtɛ. Ɩ mǝlɑ tǝyɑɣɑ ɩlɛnɑ ɩ́ yɔɣɔtɩ nɑ pɑ́ kɔnɑ-ɩ tɔɣɔnɑɣɑ nɑ ɩ́ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Mpʋɣʋlɛ ɩ wɑɑlɩ nyǝ́mɑ pɔɔsɑ-ɩ sɩ: Wenti n lɑpɑ mpʋ tɔ, tǝ tɑpʋɣʋ suweɣelɛ? Pǝ tɔkɑ pǝyɑɣɑ kɛ kʋtɔkʋ kɑ tɑ sǝtɑ ɩlɛnɑ ń mǝlɩ n wiiki nɑ ń kisiɣi tɔɣɔʋ. Pǝ mǝlɑɑ nɑ pǝyɑɣɑ sɩ ɩlɛnɑ ń kʋlɩ nɑ ń nɑɑlɩ tɔɣɔʋ nɑ? ");
INSERT INTO dop_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Ntɛnɑ Tɑfiiti cɔ-wɛ sɩ: Mɑ wiikɑɣɑ nɑ mɑ́ hɔkǝɣɩ nɔɣɔ kɛ mpʋ tɔ nɑ mɑ́ tɛɛlǝɣɩ kɛ́ sɩ ntɑnyɩ Tɑcɑɑ kɑ́ nɑ́ mɑ pǝtɔɔtǝlɛ nɑ ɩ́ wɑɑ-kɛ. ");
INSERT INTO dop_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Tɔʋ, nɔɔnɔɔ kɑ sǝpɑ tɔ, pepe tɔɔ kɛ́ mɑɑ tɑsɑ nɔɣɔ hɔkʋɣʋ? Anɩ mɑ kɑɑ pǝsɩ nɑ mɑ́ tɑɣɑnɩ-kɛɣɛ kʋsʋɣʋ. Amɑ mɑ́ɑ́ tɛnɑ nɑ mɑ́ polo kɑ kiŋ. Tɔfɔ kɑ fɛɩ sɩ kɑ tɑsǝɣɩ mǝlʋɣʋ kɛ mɑ kiŋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Ḿpʋ́ɣʋ́ Tɑfiiti hɛɛsɑ ɩ ɑlʋ Pɑsepɑ lɑŋlɛ nɑ ɩ́ kpǝtǝnɑ-ɩ nɑ ɩ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ nɑ ɩ́ hɑ-kɛɣɛ hǝtɛ sɩ Sɑlʋmɔŋ, nɑ Tɑcɑɑ luɣu sʋʋ-kɛɣɛ teu. ");
INSERT INTO dop_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Ɩlɛnɑ Tɑfiiti cɛlɛ-kɛɣɛ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ nɑ ɩ́lɛ́ ɩ hɑ-kɛɣɛ hǝtɛ sɩ Tɑcɑɑ sɔɔlɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S212_26","011_12_26","2SA","12","26","26","Tɑfiiti yoolɑɑ wulɑʋ Sowɑpɩ kɑ tɑmɑ Amoni nyǝ́mɑ ɩcɑtɛ sɔsɔɔlɛ Lɑpɑ. Wɑɑtʋ wei ɩ lɛɛkɑ-tɛ ");
INSERT INTO dop_vpl VALUES ("S212_27","011_12_27","2SA","12","27","27","ɩlɛnɑ ɩ́ tili nɑ pɑ́ heeli Tɑfiiti sɩ: Mɑ tɛɛsɑ lʋm hɔɣɔlʋɣʋ ɩcɑtɛ kɛ lɛɛkʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S212_28","011_12_28","2SA","12","28","28","Mpʋ tɔ, kpeɣeli yoolɑɑ mpɑ pǝ kɑɑsɑɑ tɔ nɑ ŋ́ kɔɔ nɑ ŋ́ mʋ-tɛ. Pǝ tɑɑ kɔɔ nɑ mɑ́ sʋʋ tǝ tɑɑ nɑ pɑ́ mǝlɩ-m sɑm. ");
INSERT INTO dop_vpl VALUES ("S212_29","011_12_29","2SA","12","29","29","Ḿpʋ́ɣʋ́ Tɑfiiti kpeɣelɑ yoolɑɑ nɑ pɑ́ kpɑ Lɑpɑ tɔɔ nɑ pɑ́ lɛɛkɩ-tɛ. ");
INSERT INTO dop_vpl VALUES ("S212_30","011_12_30","2SA","12","30","30","Ɩlɛnɑ Tɑfiiti kuli tǝ wulɑʋ kɑwulɑɣɑ ntenuɣu. Wʋlɑ kɛ pɑ lupɑ-kʋ, kʋ yuŋ wɛ ɩsɩɩ kiloonɑɑ hiu nɑ nɑɑnʋwɑ nɑ liɣiti kɛ mpʋ, nɑ pɑ́ tʋ kʋ tɔɔ kɛ́ liɣitee pɛɛ. Ḿpʋ́ɣʋ́ pɑ temɑ-kʋɣʋ Tɑfiiti nyʋɣʋ nɑ ɩ́ kuu ɩcɑtɛ tɑɑ kɛ́ wontu tuutuumɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S212_31","011_12_31","2SA","12","31","31","Pǝ kɑɑsɑ ɩcɑtɛ yǝlɑɑ ɩlɛnɑ ɩ́ tʋ lɛlɑɑ kɛ kɑɑfǝntɑnɑɑ tǝmlɛ nɑ lɛlɑɑ kɛ nyǝɣǝtʋ hɑlǝnɑʋ nɑ lɛlɑɑ kɛ tɑwɑ tǝmɑ nɑ lɛlɑɑ kɛ pilikinɑɑ wɔpʋ. Ḿpʋ́ɣʋ́ Tɑfiiti lɑpǝnɑ Amoni ɩcɑtɛ tǝnɑ. Ɩlɛnɑ ɩ́ nɑ ɩ yǝlɑɑ pɑ́ mǝlɩ Yosɑlɛm. ");
INSERT INTO dop_vpl VALUES ("S213_1","011_13_1","2SA","13","1","1","Pǝlɛ pǝ wɑɑlɩ ɑcɑɑlǝtʋ lɑpɑ wulɑʋ tɛ. Tɑfiiti pǝyɑlʋ Apǝsɑlɔm kɑ wɛnɑ neu ɑlʋ nyǝŋ nɔɣɔlʋ nɑ pɑ́ yɑɑkɩ-ɩ sɩ Tɑmɑɑ nɑ ɩ ɩsɛntɑɑ lɩɩwɑ teu. Mpʋɣʋlɛ Apǝsɑlɔm neu yɔtɔtɛ nyǝŋ wei pɑ yɑɑ sɩ Amǝnɔŋ tɔ ɩ luɣu sʋʋ Tɑmɑɑ ɩnɩ. ");
INSERT INTO dop_vpl VALUES ("S213_2","011_13_2","2SA","13","2","2","Amǝnɔŋ kɑ sɔɔlɑ ɩ neu ɩnǝɣɩ hɑlǝnɑ ɩ́ cɑŋ ɩ́ tʋ ɩ tǝɣɩ kʋtɔŋ kɛ ɩ tɔm tɑɑ. Mpi tɔ, pɛɛlɔ ɩnɩ ɩ tɑɑ nyɩ ɑpɑlʋ, ɩlɛ pɩɩ wɛ Amǝnɔŋ kɛ kɑtɛ sɩ ɩ́ tokinɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S213_3","011_13_3","2SA","13","3","3","Amǝnɔŋ tɑɑpɑlʋ ntɛ́ Tɑfiiti tɑɑlʋ Sɑmmɑ pǝyɑlʋ Yonɑtɑpɩ. Ɩ́lɛ́ ɩ kɑ kɛ́ yʋlʋ lɑɣɑtʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S213_4","011_13_4","2SA","13","4","4","Ḿpʋ́ɣʋ́ ɩ́lɛ́ ɩ pɔɔsɑ-ɩ sɩ: Pepe tɔɔ kɛ́ hɑlɩ nyɑɣɑ wulɑʋ pǝyɑlʋ tɑkɑ nɑ pɑɑ tɑnɑŋ ŋku ń tɛŋ tɑɑsɩ kɛ mpʋ? Mpʋɣʋlɛ sɩ: Mɑ sɔɔlɑ mɑ tɑɑlʋ Apǝsɑlɔm neu Tɑmɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S213_5","011_13_5","2SA","13","5","5","Ntɛnɑ Yonɑtɑpɩ sɩ: Cɛsɩ ɩsɩɩ pǝ wɩɩkɩ-ŋ, nɑ nyɑ́ cɑɑ ɩ́ kɔmɑ-ŋ wiiluɣu, ɩlɛ n tɔmɩ-ɩ sɩ ɩ́ yele nɑ nyɑ́ neu Tɑmɑɑ kɔɔ nɑ ɩ́ lɑ́ tɔɣɔnɑɣɑ kɛ nyɑ́ ɩsɛntɑɑ nɑ ɩ́ tʋ-ŋ nɑ ń tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S213_6","011_13_6","2SA","13","6","6","Ḿpʋ́ɣʋ́ Amǝnɔŋ cɛsɑɑ sɩ pǝ wɩɩkɩ-ɩ nɑ ɩ́ hǝntɩ nɑ wulɑʋ polo-ɩ wiiluɣu. Ɩlɛnɑ Amǝnɔŋ sǝlǝmɩ wulɑʋ sɩ: Hɑɩ, mɑ cɑɑ sɩ mɑ neu Tɑmɑɑ ɩ́ kɔɔ cǝnɛ nɑ ɩ́ tʋ-m kɑkɑlɑsɩ nɑɑlɛ nɑ ɩ́ cɛlɛ-m nɑ mɑ́ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S213_7","011_13_7","2SA","13","7","7","Ntɛnɑ Tɑfiiti tili nɑ pɑ́ heeli Tɑmɑɑ sɩ ɩ́ polo ɩ tɑɑlʋ Amǝnɔŋ nɑŋ tɑɑ nɑ ɩ́ lɑpɩ-ɩ tɔɣɔnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S213_8","011_13_8","2SA","13","8","8","Ḿpʋ́ɣʋ́ Tɑmɑɑ polɑ Amǝnɔŋ nɑŋ tɑɑ nɑ ɩ́ mɑɣɑnɑ Amǝnɔŋ hǝntɑɑ, nɑ Tɑmɑɑ lɑ somtu nɑ ɩ́ huɣuti nɑ ɩ́ tʋ kɑkɑlɑsɩ, ");
INSERT INTO dop_vpl VALUES ("S213_9","011_13_9","2SA","13","9","9","kɛ tǝnɛ ɩnɩ nɑ ɩ́ kuuli nɑ ɩ́ sɩɩ Amǝnɔŋ nɑ ɩ́ kisi tɔɣɔʋ. Ɩlɛnɑ Amǝnɔŋ tɔ Tɑmɑɑ sɩ: Lǝsɩ yǝlɑɑ tǝnɑ, nɑ pɑ tǝnɑ pɑ́ lɩɩ. ");
INSERT INTO dop_vpl VALUES ("S213_10","011_13_10","2SA","13","10","10","Mpʋɣʋlɛ Amǝnɔŋ tɔmɑ Tɑmɑɑ sɩ: Kɔnɑ-m tɔɣɔnɑɣɑ ŋkɛɣɛ nɑŋ tɑɑ nɑ mɑ́ tɔɣɔ ɩlɛ. Ɩlɛnɑ Tɑmɑɑ kpɑɣɑ kɑkɑlɑsɩ nsɩ nɑ ɩ́ ponɑ Amǝnɔŋ nɑŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S213_11","011_13_11","2SA","13","11","11","Pɛɛlɔ sɩɩ-ɩ tɔɣɔnɑɣɑ, ɩlɛnɑ Amǝnɔŋ tɔkɩ ɩ niŋ tɑɑ nɑ ɩ́ tɔmɩ-ɩ sɩ: Mɑ neu, kɔɔ tǝ sʋʋ. ");
INSERT INTO dop_vpl VALUES ("S213_12","011_13_12","2SA","13","12","12","Ntɛnɑ pɛɛlɔ sɩ: Aɑɩ, tɑɑ wɑkǝlɩ-m mɑ tɑɑlʋ. Ɩsɛɣɛlɩ nyǝ́mɑ ɩɩ lɑkɩ mpʋ. Ɩlɛ tɑɑ lɑ ɑcɑɑlǝtʋ ntɩ. ");
INSERT INTO dop_vpl VALUES ("S213_13","011_13_13","2SA","13","13","13","Ye n lɑpɑ mpʋ leɣe mɑɑ sɩɩ mɑ fɛɛlɛ? Pǝyele nyɑ́ɑ́ pǝsɩ Ɩsɛɣɛlɩ tɑɑ ɑcɑɑlǝŋ tɑɑ lɛŋkʋ. Polo ń sǝlǝmɩ wulɑʋ, pɑɑ pǝ lɑ ɩsǝnɑ ɩ kɑ tisi nɑ mɑ́ sɑɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S213_14","011_13_14","2SA","13","14","14","Amɑ Amǝnɔŋ tɑ nɩɩnɑ-ɩ. Ḿpʋ́ɣʋ́ ɩ kpipɑ Tɑmɑɑ nɑ toŋ nɑ ɩ́ wɑkǝlɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S213_15","011_13_15","2SA","13","15","15","Tǝnɑɣɑ Amǝnɔŋ luɣu lɩɩ-ɩ nɑ ɩ tɑɑ kpɑnɑ-ɩ nɑ pǝ́ kǝlɩ ɩsɩɩ ɩ kɑ sɔɔlɑ-ɩ tɔ, nɑ ɩ́ tɔɣɔnɩ-ɩ sɩ ɩ́ lɩɩ. ");
INSERT INTO dop_vpl VALUES ("S213_16","011_13_16","2SA","13","16","16","Ntɛnɑ pɛɛlɔ mɑ kɑpukɑ sɩ: Hɑ, n tɔɣɔnǝɣɩ-m mpʋ tɔ n sɔɔsǝɣɩ ɩsɑɣɑtʋ kɛ nti n tɛmɑ-m lɑpʋ tɔ tǝ tɔɔ kɛ́. Amɑ Amǝnɔŋ tɑ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("S213_17","011_13_17","2SA","13","17","17","Ḿpʋ́ɣʋ́ ɩ yɑɑ tǝmlɛ tʋ nɑ ɩ́ heeli-ɩ sɩ: Tɔɣɔnɩ ɑlʋ ɩnɛ nɑ ɩ́ lɩɩ nɑ ń kɑlǝsɩ nɔnɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S213_18","011_13_18","2SA","13","18","18","Ɩlɛnɑ tǝmlɛ tʋ lǝsɩ-ɩ ɑwɑlɩ nɑ ɩ́ tǝkɩ nɑ ɩ́ kɑlǝsɩ. Pɛɛlɔ ɩnɩ ɩ kɑ suu ŋkpɑlɑsɩ cɑpɑ kʋcɔɔcɔlʋ kɛ́ ɩsɩɩ ɑwulɑɑ pɛɛlɑɑ mpɑ pɑ tɑ sɑɑtɑ tɔ pɑ suuki tɔ. ");
INSERT INTO dop_vpl VALUES ("S213_19","011_13_19","2SA","13","19","19","Tǝnɑɣɑlɛ Tɑmɑɑ cǝlɑ ɩ cɑpɑ nɑ ɩ́ tʋ ɩ nyʋɣʋ tɑɑ kɛ́ tɔlʋmɑ nɑ ɩ́ te nyʋɣʋ nɑ ɩ́ mɑkɩ kɑpusi nɑ ɩ́ tɛɛkɩ. ");
INSERT INTO dop_vpl VALUES ("S213_20","011_13_20","2SA","13","20","20","Tɑmɑɑ tɑɑlʋ Apǝsɑlɔm nɑ-ɩ, ɩlɛnɑ ɩ́ pɔɔsɩ-ɩ sɩ: Nyɑ́ tɑɑlʋ Amǝnɔŋ wɑkǝlɑ-ŋ kɛ? Mɑ neu, su. Tɑɑ suli tɔm ntǝɣɩ kpɑɣɑʋ nɑ ń yɑɑ-tǝɣɩ pʋlʋ, nyɑ́ tɑɑlʋ kɛ́. Ɩlɛnɑ Tɑmɑɑ sɑɑlɩ Apǝsɑlɔm tǝyɑɣɑ tɑɑ ɩsɩɩ kɑtɑyǝlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S213_21","011_13_21","2SA","13","21","21","Ḿpʋ́ɣʋ́ wulɑʋ nɩɩ pǝ tǝnɑɣɑ mpʋ nɑ pɑ́ɑ́nɑ́ kpɑ-ɩ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("S213_22","011_13_22","2SA","13","22","22","Ɩlɛnɑ Apǝsɑlɔm hɑɣɑ Amǝnɔŋ nɑ ɩ tɑɑ. Ɩɩ tɑsǝɣɩ-ɩ yɔɣɔtǝnɑʋ kɛ mpi pǝ tɔɔ ɩ wɑkǝlɑ ɩ neu tɔ. ");
INSERT INTO dop_vpl VALUES ("S213_23","011_13_23","2SA","13","23","23","Pɩɩsɩ nɑɑlɛ sikɑɑ ɩlɛ pɑ kɔɔkɩ Apǝsɑlɔm heeŋ hʋntʋ ntɛ́ timpi pɑ yɑɑ sɩ Pɑɑlɩ-Hɑsɔɔ tɔɣɔ Ɩfǝlɑyim. Ɩlɛnɑ Apǝsɑlɔm yɑɑ wulɑʋ pǝyɑlɑɑ tǝnɑɣɑ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("S213_24","011_13_24","2SA","13","24","24","Ḿpʋ́ɣʋ́ ɩ polɑɑ nɑ ɩ́ heeli wulɑʋ sɩ: Tɑ cɑɑ, pɑ kɔɔkɩ mɑ heeŋ hʋntʋ. Ɩlɛ mɑ cɑɑkɩ sɩ nyɑnɑ nyɑ́ wɑɑlɩ nyǝ́mɑ tǝnɑ ɩ́ kɔɔ nɑ tǝ́ tɔɣɔ pǝ ɑcimɑ. ");
INSERT INTO dop_vpl VALUES ("S213_25","011_13_25","2SA","13","25","25","Ɩlɛnɑ wulɑʋ tɔ sɩ: Aɑɩ, mɑ pǝyɑlʋ, tɑ tǝnɑ tǝ kɑɑ polo, pǝ tɑɑ kɔɔ nɑ tǝ́ sʋkɩ-ŋ sǝɣǝlɑ kɛ yem. Ḿpʋ́ɣʋ́ Apǝsɑlɔm cɑɑlɑ-ɩ, ɩlɛnɑ wulɑʋ kisi tǝsɑɣɑsɑɣɑ nɑ ɩ́ lɑpɩ-ɩ pǝ lɑpɑ wulee. ");
INSERT INTO dop_vpl VALUES ("S213_26","011_13_26","2SA","13","26","26","Ntɛnɑ Apǝsɑlɔm sɩ: Ɩlɛ yele nɑ mɑ neu Amǝnɔŋ tǝŋ-tʋ. Wulɑʋ sɩ: Pepe tɔɔ kɛ́ n cɑɑ sɩ ɩ́ polo nyɑ́ tɛ? ");
INSERT INTO dop_vpl VALUES ("S213_27","011_13_27","2SA","13","27","27","Ɩ cɑɑlɑ wulɑʋ kɛ teu, ɩlɛnɑ ɩ́lɛ́ ɩ yele nɑ ɩ pǝyɑlɑɑ tǝnɑ polo. Hɑlǝnɑ pǝ́ kpɛŋnɑ Amǝnɔŋ mɑɣɑmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S213_28","011_13_28","2SA","13","28","28","Ḿpʋ́ɣʋ́ Apǝsɑlɔm heelɑ ɩ tǝmlɛ nyǝ́mɑ sɩ ɩ́ pɑɑsǝnɑ teu, nɑ pǝ́ kɔmɑ nɑ Amǝnɔŋ hɑɣɑ sʋlʋm nɑ mɑ́ heeli-mɛ sɩ ɩ́ kʋ-ɩ, ɩlɛ ɩ́ kʋ-ɩ, ɩ́ tɑɑ nyɑ́, mɑ heelinɑ-mɛ. Mpʋ tɔ, ɩ́ kɑɑsɩ mǝ tɩ nɑ ɩ́ tɔɣɔ ɑpɑlʋtʋ. ");
INSERT INTO dop_vpl VALUES ("S213_29","011_13_29","2SA","13","29","29","Wɑɑtʋ wei Amǝnɔŋ hɑɣɑ sʋlʋm, ɩlɛnɑ Apǝsɑlɔm tǝmlɛ nyǝ́mɑ lɑ teitei ɩsɩɩ ɩ kɑ heeluɣu-wɛ tɔ. Nɑ wulɑʋ pǝyɑlɑɑ tǝnɑ kʋlɩ nɑ pɑɑ wei ɩ́ kpɑ ɩ kpɑŋɑɣɑ tɔɔ nɑ ɩ́ se. ");
INSERT INTO dop_vpl VALUES ("S213_30","011_13_30","2SA","13","30","30","Ḿpʋ́ɣʋ́ pɑ tɑɣɑsɑ wulɑʋ kɛ kpɑkpɑɑ sɩ Apǝsɑlɔm kʋwɑ ɩ pǝyɑlɑɑ tǝnɑ pǝ tɑ kɑɑsɩ pɑɑ kʋlʋm. Pǝyele pɛlɛ pɑ wɛ mpɑɑʋ nɑ pɑ́ tɔŋɑ kpente. ");
INSERT INTO dop_vpl VALUES ("S213_31","011_13_31","2SA","13","31","31","Tǝnɑɣɑlɛ wulɑʋ kʋlɑ kpɑkpɑɑ nɑ lɑŋwɑkǝllɛ nɑ ɩ́ cǝlɩ ɩ wontu nɑ ɩ́ hǝntɩ ɑtɛ nɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ́ɑ́ cǝlɩ pɛlɛ pɑ nyǝntʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S213_32","011_13_32","2SA","13","32","32","Ḿpʋ́ɣʋ́ Tɑfiiti tɑɑlʋ Sɑmmɑ pǝyɑlʋ Yonɑtɑpɩ tɔmɑ sɩ: Tɑ cɑɑ, Amǝnɔŋ tike kɛ pɑ kʋwɑ, pǝ tɑɣɑ nyɑ́ pǝyɑlɑɑ tǝnɑ. Apǝsɑlɔm kɑ hɑɣɑ-ɩ nɑ ɩ tɑɑ kɛ́ timpi ɩ kɑ wɑkǝlɑ ɩ́lɛ́ ɩ neu tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S213_33","011_13_33","2SA","13","33","33","Ɩlɛ wulɑʋ, tɑɑ huɣuti lotu sɩ nyɑ́ pǝyɑlɑɑ tǝnɑ sǝpǝnɑ, Amǝnɔŋ tike kɛ́. ");
INSERT INTO dop_vpl VALUES ("S213_34","011_13_34","2SA","13","34","34","Ḿpʋ́ɣʋ́ Apǝsɑlɔm sewɑ. Wulɑʋ tɑŋlʋ kʋsɑ ɩsɛ kɛ kpɑkpɑɑ, ɩlɛ ɩ nɑ sɑmɑɑ nɑ ɩ wɑɑlɩ tɔɔ kɛlɛ pʋɣʋ cɔlɔ mpɑɑʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S213_35","011_13_35","2SA","13","35","35","Tǝnɑɣɑlɛ Yonɑtɑpɩ tɔmɑ sɩ: Aŋhɑ, wulɑʋ, nyɑ́ pǝyɑlɑɑ tɑpǝnɑ ntɛ́ ɩsɩɩ mɑ heeluɣu-ŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S213_36","011_13_36","2SA","13","36","36","Yonɑtɑpɩ nɔɣɔ tɑ tiitɑ ɑtɛ, ɩlɛ wulɑʋ pǝyɑlɑɑ tɑpɑɣɑlɛ, nɑ pɑ́ tʋlɩ nɔɔsɩ nɑ pɑ́ wii tǝkpoo nɑ wulɑʋ nɑ ɩ wɑɑlɩ nyǝ́mɑ pɛlɛ pɑ luki ɩsǝlʋm. ");
INSERT INTO dop_vpl VALUES ("S213_37","011_13_37","2SA","13","37","38","Apǝsɑlɔm kɑ sewɑ tɔ Amihuti pǝyɑlʋ Tɑlǝmɑyi wei ɩ kɑ kɛ́ Kesuli wulɑʋ tɔ ɩ tɛɣɛ ɩ kɑ polɑɑ nɑ ɩ́ cɑɣɑ pɩɩsɩ tooso. Nɑ Tɑfiiti nɑ́ɑ́ wiiki ɩ pǝyɑlʋ Amǝnɔŋ tɔɔ kɛ́ tɑm. ");
INSERT INTO dop_vpl VALUES ("S213_39","011_13_39","2SA","13","39","39","Wulɑʋ kɔmɑ nɑ ɩ́ hɛɛsɩ ɩ tɩ lɑŋlɛ kɛ Amǝnɔŋ sǝm tɔɔ, ɩlɛnɑ ɩ́ yele Apǝsɑlɔm kʋɣʋ tɔm kɛ pɛɛkʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S214_1","011_14_1","2SA","14","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti yoolɑɑ nyʋɣʋ tʋ Sowɑpɩ cɛkǝnɑɑ sɩ wulɑʋ hɑɣɑ Apǝsɑlɔm nɑ pɑ́ɑ́nɑ́. ");
INSERT INTO dop_vpl VALUES ("S214_2","011_14_2","2SA","14","2","2","Ɩlɛnɑ ɩ́ tili timpi pɑ yɑɑ sɩ Tɛkʋwɑ tɔ nɑ pɑ́ kɔnɑ-ɩ ɑlʋ lɑɣɑtʋ nɔɣɔlʋ nɑ ɩ́ heeli-ɩ sɩ: Cɛsɩ ɩsɩɩ nyɑ́ lɑŋlɛ wɑkǝlɑɑ nɑ ń suu lǝyɑɣɑ wontu ɩsɩɩ yʋlʋ cɑkʋɣʋ lǝyɑɣɑ nɑ pǝ́ tɑɑŋɩ tɔ, ɩlɛ tɑɑ sɑɣɑlɩ nim. ");
INSERT INTO dop_vpl VALUES ("S214_3","011_14_3","2SA","14","3","3","Nɑ ɩ́ kɛɛsɩ-ɩ tɔm nti ɩ kɑ yɔɣɔtɩ wulɑʋ kiŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S214_4","011_14_4","2SA","14","4","4","Ḿpʋ́ɣʋ́ ɑlʋ ɩnɩ ɩ polɑ wulɑʋ tɛ nɑ ɩ́ hoti ɩ tɛɛ nɑ ɩ́ tɔ sɩ: Hɑɩ, tɑ cɑɑ, yɑ-m. ");
INSERT INTO dop_vpl VALUES ("S214_5","011_14_5","2SA","14","5","5","Ntɛnɑ wulɑʋ sɩ: Pepe lɑpɑ ye? Ntɛnɑ ɑlʋ sɩ: Hɑɩ, tɑ cɑɑ, mɑ pɑɑlʋ sǝpɑɣɑ nɑ pǝ́ yele-m leelu. ");
INSERT INTO dop_vpl VALUES ("S214_6","011_14_6","2SA","14","6","6","Pǝyele mɑɑ wɛnɑ ɑpɑlʋpiyɑ kɛ nɑɑlɛ. Ḿpʋ́ɣʋ́ sɩ yoo tɑɑlɛ, nɔɣɔlʋ fɛɩ sɩ ɩ́ loli-sɩ. Ɩlɛnɑ lɛlʋ kʋ ɩ tɑɑpɑlʋ. ");
INSERT INTO dop_vpl VALUES ("S214_7","011_14_7","2SA","14","7","7","Tǝnɑɣɑlɛ mɑ nyǝ́mɑ tǝnɑ kʋlɑɑ nɑ pɑ́ sǝŋ mɑ tɔɔ sɩ mɑ́ yele nɑ pɑ́ kʋ kʋlʋ. Sɩ pɑɑ kʋlʋ ɩnɩ ɩ kɑ kpɑɣɑnɑ ɩ cɑɑ wɛnɑʋ, ɩsɩɩ pɑ kʋ-ɩ. Ɩsǝlɛ kʋlʋmtǝlɛ nte tɩɩ kɑɑsɑ-m tɔɣɔlɛ pɑ tɛɛsǝɣɩ nɑŋtʋɣʋ. Pǝ kɑɑ kɑɑsɩ mɑ pɑɑlʋ kɛ́ pǝyɑɣɑ ŋkɑ pɑɑ yɑɑkǝnɑ ɩ hǝtɛ tɔɣɔ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S214_8","011_14_8","2SA","14","8","8","Ntɛnɑ wulɑʋ sɩ: Kpe nyɑ́ tɛ nɑ mɑ́ pɑɑsǝnɑ nyɑ́ tɔm. ");
INSERT INTO dop_vpl VALUES ("S214_9","011_14_9","2SA","14","9","9","Mpʋɣʋlɛ ɑlʋ cɔ-ɩ sɩ: Pɑɑ mpi pǝ lɑpɑ pǝ́ wɛɛ mɑ nɑ mɑ cɑɑ tǝyɑɣɑ tɑ tɔm pǝ tɑɑ wɛɛ nyɑ́ nɑ nyɑ́ tǝyɑɣɑ mǝ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("S214_10","011_14_10","2SA","14","10","10","Mpʋɣʋlɛ wulɑʋ tɔmɑ sɩ: Ye nɔɣɔlʋ lɑkɩ nyɑ́ tɔm kɛ tɔm ntɩ tǝ tɑɑ, ɩlɛ n kɔnɑ-ɩ mɑ kiŋ, ɩ kɑɑ tɑsɑ-ŋ tokinɑʋ. ");
INSERT INTO dop_vpl VALUES ("S214_11","011_14_11","2SA","14","11","11","Ntɛnɑ ɑlʋ tɑsɑ sɩ: Tɑ cɑɑ wulɑʋ, tuunɑ nyɑ́ Ɩsɔ Tɑcɑɑ sɩ yʋlʋ lɛɛtʋlʋ ɩnɩ ɩ kɑɑ kʋ mɑ pǝyɑɣɑ nɑ pǝ́ yele ncɑɑlɛ. Ḿpʋ́ɣʋ́ wulɑʋ nɑ́ tuuwɑ sɩ: Nɑ Ɩsɔ, nɔɣɔlʋ kɑɑ kpɑɣɑ nyɑ́ pǝyɑlʋ tɔɔ kɛ́ nyɩɩlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S214_12","011_14_12","2SA","14","12","12","Mpʋɣʋlɛ ɑlʋ sɩ: Hɑɩ, Tɑcɑɑ, yele nɑ mɑ́ tɑsɑ tɔmʋɣʋ kʋlʋmʋɣʋ kɛ yɔɣɔtʋɣʋ. Ɩlɛnɑ wulɑʋ sɩ: Yɔɣɔtɩ. ");
INSERT INTO dop_vpl VALUES ("S214_13","011_14_13","2SA","14","13","13","Kɛlɛnɑ ɑlʋ tɔ sɩ: Nɑ pepe tɔɔ kɛ́ n cɑɑ n wɑkǝlɩ Ɩsɔ yǝlɑɑ kɛ mpʋ? Mpi tɔ, nyɑ́ kʋnɑ nyɑ́ tɩ tɔm kɛ timpi nn cɑɑkɩ sɩ ń mǝlǝnɑ nyɑ́ pǝyɑɣɑ ŋkɑ n tɔɣɔnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S214_14","011_14_14","2SA","14","14","14","Tɑ tǝnɑ tɩɩ sɩ teitei kɛ́ ɩsɩɩ pɑ pǝlʋɣʋ lʋm kɛ ɑtɛ nɑ pǝ́ fɛɩ kpɑʋ tɔ. Amɑ Ɩsɔ nɑɑ kʋɣɩ, ɩ́lɛ́ ɩ cɑɑkɩ kɛ́ sɩ pɑ́ hʋ́lɩ́ suulu kɛ wei pɑ lɔwɑ tɔ nɑ pɑ́ mǝlǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S214_15","011_14_15","2SA","14","15","15","Tɑcɑɑ, nɔɔnɔɔ mɑ kɔm ɩsǝntɔ tɔ, mɑ tɑ kɔɔ yem, nyɑ́ yǝlɑɑ nyɑɑsǝnɑ-m. Pǝ tɔɔ kɛ́ mɑ kɔmɑ sɩ mɑ́ yɔɣɔtǝɣǝnɑ-ŋ nɑ ntɑnyɩ n kɑ tisi. ");
INSERT INTO dop_vpl VALUES ("S214_16","011_14_16","2SA","14","16","16","N kɑ́ mʋ mɑ tɔm nɑ ń yɑ-m mpɑ pɑ lʋkɩ sɩ pɑ́ kpiisi mɑ nɑ mɑ pǝyɑɣɑ sɩ tǝ tɑɑ nɑ Ɩsɔ kpɑncoou tɔ pɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S214_17","011_14_17","2SA","14","17","17","Mɑ tʋ mɑ tɑɑ sɩ nyɑ́ tɔm kɑ yele nɑ mɑ́ hɛɛsɩ. Mpi tɔ, Tɑcɑɑ, n wɛɛ kɛ́ ɩsɩɩ Ɩsɔ ɩsɔtɑɑ tillu. N fɑkɩ kʋpɑntʋ nɑ ɩsɑɣɑtʋ. Nyɑ́ Ɩsɔ Tɑcɑɑ ɩ́ wɛɛ nyɑ́ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S214_18","011_14_18","2SA","14","18","18","Ḿpʋ́ɣʋ́ wulɑʋ tɔmɑ ɑlʋ sɩ: Tɑɑ ŋmɛsɩ-m nti mɑ pɔɔsǝɣɩ-ŋ ɩsǝntɔ tɔ. Alʋ sɩ: Yɛɛ, yɔɣɔtɩ mɑ cɛ. ");
INSERT INTO dop_vpl VALUES ("S214_19","011_14_19","2SA","14","19","19","Ɩlɛnɑ wulɑʋ sɩ: Ɩsǝntɔ Sowɑpɩ nɔɣɔ fɛɩ tɔm tǝnɛ tǝ tɑɑ? Ntɛnɑ ɑlʋ sɩ: Hɑɩ tɑ cɑɑ wulɑʋ, mɑ tuukinɑ-ŋ sɩ ntɔŋkpɛɛsɑɣɑ fɛɩ. Tɑmpɑnɑ yɑɑ, nyɑ́ tǝmlɛ tʋ Sowɑpɩ tʋnɑ-m tǝmlɛ tǝnɛ nɑ ɩ́ heeli-m tǝ tǝnɑ nti mɑ yɔɣɔtǝɣɩ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("S214_20","011_14_20","2SA","14","20","20","Sowɑpɩ tukɑ ɩtuule kɛ ḿpʋ́ɣʋ́ sɩ n kɑ́ cɛkǝnɑ nɑ ń mǝlǝnɑ Apǝsɑlɔm. Mpi tɔ, n kɛ́ lǝmɑɣɑsǝlɛ tʋ kɛ́ nɑ ń nyǝmɑ́ pǝ tǝnɑ mpi pǝ lɑkɩ tɔ ɩsɩɩ Ɩsɔ ɩsɔtɑɑ tillu. ");
INSERT INTO dop_vpl VALUES ("S214_21","011_14_21","2SA","14","21","21","Pǝlɛ pǝ wɑɑlɩ kɛ́ wulɑʋ tɔmɑ Sowɑpɩ sɩ: Tɔm ntɩ tǝ tɛmɑ, polo nɑ ń kɔnɑ Apǝsɑlɔm. ");
INSERT INTO dop_vpl VALUES ("S214_22","011_14_22","2SA","14","22","22","Tǝnɑɣɑlɛ Sowɑpɩ hotɑ wulɑʋ nɔɔhɛɛ tɛɛ kɛ́ kpɑkpɑɑ nɑ ɩ́ kooli-ɩ kʋpɑntʋ. Ɩlɛnɑ ɩ́ tɔ sɩ: Hɑɩ, Tɑcɑɑ, sɑŋɑ ntɛ́ mɑ nɑwɑ sɩ n hʋlɑ-m suulu kɛ timpi n tisuɣu mɑ tɔm tǝnɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S214_23","011_14_23","2SA","14","23","23","Mpʋɣʋlɛ Sowɑpɩ tɛɛ Kesuu nɑ ɩ́ kɔnɑ Apǝsɑlɔm kɛ Yosɑlɛm. ");
INSERT INTO dop_vpl VALUES ("S214_24","011_14_24","2SA","14","24","24","Kɛlɛnɑ wulɑʋ sɩ: Apǝsɑlɔm ɩ́ cɑɣɑ ɩ tǝyɑɣɑ tɑɑ, mɑ́ nɑ-ɩ tɑ ɩsɛ ɩ́ tɑɑ suli. Ɩlɛnɑ Apǝsɑlɔm mǝlɩ ɩ tǝyɑɣɑ, ɩ nɑ wulɑʋ pɑɑ nɑɑkɩ tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("S214_25","011_14_25","2SA","14","25","25","Nɔɣɔlʋ tɑ hɑŋnɑ Apǝsɑlɔm kɛ teu kɛ Ɩsɛɣɛlɩ tǝnɑ tɑɑ. Ɩ ŋmɑtʋ tǝnɑ kɑ tewɑɣɑ, ɩ tiili fɛɩ pɑɑ kpǝtiyɑ mɑɣɑmɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S214_26","011_14_26","2SA","14","26","26","Ɩ kɑ wɛnɑ nyɔɔsɩ kɛ sɔsɔm kɛ́, nɑ pɩɩ wɛɛ sɩ pɑ́ hʋmɩ-ɩ pɑɑ pǝnɑɣɑ ŋkɑ. Mpi tɔ, ɩ nyɔɔsɩ ɩ́ kɔmɑ sɩ wɛ yuŋ kɛ́. Ye pɑ hʋmɑ-ɩ sɩ yuŋ wɛɛkɩ kiloonɑɑ nɑɑlɛ nɑ hɔɣɔlʋɣʋ ɩsɩɩ wulɑʋ mɑɣɑsǝlɑɣɑ wɛʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S214_27","011_14_27","2SA","14","27","27","Apǝsɑlɔm lʋlɑ ɑpɑlʋpiyɑ tooso nɑ ɑlʋpǝyɑɣɑ kʋlʋmɑɣɑ. Pɑ yɑɑ-kɛ sɩ Tɑmɑɑ, kɑ ɩsɛntɑɑ kɑ lɩɩwɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S214_28","011_14_28","2SA","14","28","28","Ḿpʋ́ɣʋ́ Apǝsɑlɔm cɑɣɑ pɩɩsɩ nɑɑlɛɣɛ Yosɑlɛm. Ɩlɛ ɩ́ nɑ wulɑʋ pɑɑ keesiɣi tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("S214_29","011_14_29","2SA","14","29","29","Ɩlɛnɑ ɩ́ yɑɑ Sowɑpɩ sɩ ɩ tiliɣi-ɩ wulɑʋ kiŋ nɑ ɩ́lɛ́ ɩ kisi, nɑ ɩ́ tɑsɑ-ɩ yɑɑʋ kɛ tɔm nɑɑlɛ nyǝm nɑ ɩ́lɛ́ ɩ kisi tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S214_30","011_14_30","2SA","14","30","30","Ntɛnɑ Apǝsɑlɔm tɔ ɩ tǝmlɛ nyǝ́mɑ sɩ: Sowɑpɩ tɑɑlɛ ntɛ́ mɑ nyǝntɛ kɔŋkɔŋ tɑɑ, ɩ́ polo nɑ ɩ́ sɔ-tɛɣɛ kɔkɔ. Ɩlɛnɑ pɛlɛ pɑ polo nɑ pɑ́ sɔ-tɛɣɛ kɔkɔ. ");
INSERT INTO dop_vpl VALUES ("S214_31","011_14_31","2SA","14","31","31","Mpʋɣʋlɛ Sowɑpɩ polɑ Apǝsɑlɔm tǝyɑɣɑ tɑɑ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Pepe tɔɔ kɛ́ nyɑ́ tǝmlɛ nyǝ́mɑ sɔpɑ mɑ tɑɑlɛ kɛ kɔkɔ? ");
INSERT INTO dop_vpl VALUES ("S214_32","011_14_32","2SA","14","32","32","Kɛlɛnɑ Apǝsɑlɔm sɩ: Mɑ tilɑ nyɑ́ wɑɑlɩ kɛ́ tɔm pɑɣɑlɛ sɩ ń kɔɔ nɑ mɑ́ tili-ŋ wulɑʋ kiŋ nɑ ń pɔɔsɩ-ɩ sɩ pepe tɔɔ kɛ́ ɩ tilɑ mɑ wɑɑlɩ kɛ Kesuu? Pɩɩ kǝlɑ teu sɩ mɑ́ sɑɑlɩ tǝnɑ. Mɑ cɑɑ sɩ mɑ nɑ wulɑʋ tǝ́ nɑ́ nɑ ye mɑ lɑpɑ-ɩ ɩsɑɣɑtʋ nti ɩ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("S214_33","011_14_33","2SA","14","33","33","Ḿpʋ́ɣʋ́ Sowɑpɩ nɑ́ polɑɑ nɑ ɩ́ heeli-tǝɣɩ wulɑʋ. Ɩlɛnɑ wulɑʋ yɑɑ Apǝsɑlɔm nɑ ɩ́ kɔɔ nɑ ɩ́ hǝntɩ wulɑʋ kɛ ɑtɛ nɑ ɩ́lɛ́ ɩ wɑɣɑlɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S215_1","011_15_1","2SA","15","1","1","Pǝlɛ pǝ wɑɑlɩ kɛ́ Apǝsɑlɔm hikɑ yoou kɛɛkɛ nɑ kpɑɣɑnǝŋ nɑ tɑŋlɑɑ kɛ nɩɩlɛ nɑ nɑɑnʋwɑ (50). ");
INSERT INTO dop_vpl VALUES ("S215_2","011_15_2","2SA","15","2","2","Tɑnɑŋ tɑnɑŋ kɛ Apǝsɑlɔm lɩɩkɑɣɑ lɔŋ nɑ ɩ́ puki ɩcɑtɛ nɔnɔɣɔ sɔsɑɣɑ mpɑɑʋ kpeeŋɑ, ye nɔɣɔlʋ hikɑ tɔm sɩ ɩ puki wulɑʋ tɛɣɛ hʋʋlɛ, ɩlɛ ɩ yɑɑ-ɩ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Ɩcɑtɛ nteɣe n lɩɩnɑ? Ye ɩ́lɛ́ ɩ cɔ-ɩ sɩ: Mɑ kɛ́ Ɩsɛɣɛlɩ kpekǝle tǝnɛ tǝ tʋ ");
INSERT INTO dop_vpl VALUES ("S215_3","011_15_3","2SA","15","3","3","ɩlɛ ɩ tɔmɩ-ɩ sɩ: Nyǝnɩ, n wɛnɑ tɑmpɑnɑ kɛ́. Pǝ́cɔ́ ye n polɑ wulɑʋ tɛ nɔɣɔlʋ kɑɑ pɑɑsǝnɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S215_4","011_15_4","2SA","15","4","4","Kɑsɑ, ye mɑɑ kɛnɑ hʋʋlʋ ntɔ, mɑ kiŋ ntɛ́ tɔm nyǝ́mɑ kɑ kɔŋɑɣɑ nɑ mɑ tɑɣɑnǝɣɩ pɑ tɔmnɑɑ. ");
INSERT INTO dop_vpl VALUES ("S215_5","011_15_5","2SA","15","5","5","Ye yʋlʋ ɩ́ kpǝtǝɣǝnɑ-ɩ sɩ ɩ hǝntǝɣɩ ɑtɛ ɩlɛ ɩ kpipi-ɩ nɑ ɩ́ wɑɣɑlɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S215_6","011_15_6","2SA","15","6","6","Ḿpʋ́ɣʋ́ Apǝsɑlɔm lɑkɑɣɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ mpɑ pɑ pukɑɣɑnɑ tɔmnɑɑ kɛ wulɑʋ tɛ tɔ. Nɑ Ɩsɛɣɛlɩ nyǝ́mɑ lɑŋɑ hɛɛkɑɣɑnɑ-ɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S215_7","011_15_7","2SA","15","7","7","Pǝnɑɣɑ liɣiti nyǝŋkɑ tɑɑ kɛ́ Apǝsɑlɔm tɔmɑ wulɑʋ sɩ: Tɑcɑɑ, yele nɑ mɑ́ polo Hepǝlɔŋ nɑ mɑ́ lɑ́ kɔtɑɣɑ ŋkɑ mɑɑ sɩɩ Tɑcɑɑ kɛ nɔɣɔ sɩ mɑɑ lɑpɩ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S215_8","011_15_8","2SA","15","8","8","Mpi tɔ, wɑɑtʋ wei mɑɑ wɛ Kesuu tɔɣɔ mɑ sɩɩ Tɑcɑɑ kɛ nɔɣɔ sɩ ye ɩ yelɑɑ nɑ mɑ́ mǝlɩ Yosɑlɛm, ɩnǝɣɩ mɑɑ lɑ tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("S215_9","011_15_9","2SA","15","9","9","Ntɛnɑ wulɑʋ sɩ: Polo. Ɩlɛnɑ Apǝsɑlɔm kʋlɩ nɑ ɩ́ tɛɛ Hepǝlɔŋ. ");
INSERT INTO dop_vpl VALUES ("S215_10","011_15_10","2SA","15","10","10","Mpʋɣʋlɛ Apǝsɑlɔm tilɑ tillɑɑ kɛ mukɑɣɑ kɛ Ɩsɛɣɛlɩ tɛtʋ tǝnɑ tɑɑ sɩ ye pɑ nɩɩ tutuɣu ɩlɛ pɑ yɔɣɔtɩ sɩ: Apǝsɑlɔm kɛlɛ wulɑʋ nɑ ɩ́ wɛ Hepǝlɔŋ. ");
INSERT INTO dop_vpl VALUES ("S215_11","011_15_11","2SA","15","11","11","Yosɑlɛm nyǝ́mɑ kɑ sɩɩ-ɩ yǝlɑɑ ŋmʋnʋɣʋ (200) pɛlɛ pɑ nɩɩnɑ-ɩ teu kɛ́, pɑ tɑ cɛkǝnɑ nti ɩ hɔkɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S215_12","011_15_12","2SA","15","12","12","Wɑɑtʋ wei Apǝsɑlɔm lɑkɑɣɑ kɔtɑsɩ, ɩlɛnɑ ɩ́ tili nɑ pɑ́ yɑɑ Kilo tʋ Ahitofɛlɩ wei ɩ kɑ kɛ́ Tɑfiiti sɔpɑɑpɩ tɔ. Ḿpʋ́ɣʋ́ sɑmɑɑ hukɑ sɔsɔm kɛ ɩ kiŋ nɑ pɑ́ tɔŋnɑ wulɑʋ ɑcɑɣɑ kɛ cɑɣɑʋ. ");
INSERT INTO dop_vpl VALUES ("S215_13","011_15_13","2SA","15","13","13","Ḿpʋ́ɣʋ́ nɔɣɔlʋ kɔmɑ nɑ ɩ́ cɩ Tɑfiiti kɛ sǝkpɑlʋɣʋ sɩ: Ɩsɛɣɛlɩ yǝlɑɑ kɛɛsɑ ɩsɛ nɑ Apǝsɑlɔm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S215_14","011_15_14","2SA","15","14","14","Ɩlɛnɑ Tɑfiiti yɔɣɔtɩ ɩ wɑɑlɩ nyǝ́mɑ tǝnɑ mpɑ pɑɑ wɛ ɩ kiŋ kɛ Yosɑlɛm tɔ sɩ: Ɩ́ kʋlɩ nɑ tǝ́ se, tɔfɔ Apǝsɑlɔm ɩɩ yeki-tʋ. Ɩ́ lɑ tǝcɑʋ, ye pǝ tɑɣɑ mpʋ ɩ kɑ́ tuti-tʋ nɑ ɩ́ kʋ ɩcɑtɛ nyǝ́mɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S215_15","011_15_15","2SA","15","15","15","Ntɛnɑ wulɑʋ wɑɑlɩ nyǝ́mɑ tɔ sɩ: Ɛɛ, Tɑcɑɑ tɩɩ lɑ tǝ tǝnɑ nti n heeliɣi-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S215_16","011_15_16","2SA","15","16","16","Ḿpʋ́ɣʋ́ wulɑʋ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ tǝnɑ pɑ lɩɩwɑ, nɑ ɩ́ kɑɑsɩ ɑlɑɑ nɑɑnʋwɑ sɩ pɛlɛ pɑ́ tɑŋ tǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S215_17","011_15_17","2SA","15","17","17","Wulɑʋ lɩɩ mpʋ ɩlɛnɑ ɩ yǝlɑɑ tǝnɑ tʋ ɩ wɑɑlɩ nɑ pɑ́ sǝŋ tǝyɑɣɑ kɑntǝkɑɣɑ nyǝŋkɑ kiŋ. ");
INSERT INTO dop_vpl VALUES ("S215_18","011_15_18","2SA","15","18","18","Ḿpʋ́ɣʋ́ ɩ tǝmlɛ nyǝ́mɑ tǝnɑ nɑ ɩ tɑŋlɑɑ tǝnɑ tʋ-ɩ hɛkʋ, nɑ Kɑtɩ yoolɑɑ nɑ́ɑ́ kɔɔ yǝlɑɑ nɑsǝtoso (600) nɑ pɑ́ tɛɛ-ɩ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S215_19","011_15_19","2SA","15","19","19","Ḿpʋ́ɣʋ́ wulɑʋ pɔɔsɑ Kɑtɩ yoolɑɑ nyʋɣʋ tʋ Ɩtɑyi sɩ: Pepe tɔɔ kɛ́ mǝ kɔmɑ tɑ kiŋ tɔtɔ? Ɩ mǝlɩ Apǝsɑlɔm cɔlɔ. Mpi tɔ, mǝ kɛ́ cɔɔsǝlɑɑ kɛ́ ɩ tɑ kɛ́ tɛtʋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S215_20","011_15_20","2SA","15","20","20","Anɩ nɔɔnɔɔ kɛlɛ ɩ tɑpɑ, ɩlɛnɑ mɑ́ɑ́ kpɑkǝɣɩ-mɛɣɛ kpɑkpɑɑ nɑ mɑ́ cɔɔkǝnɑ. Pǝ́cɔ́ mɑ mɑɣɑmɑɣɑ mɑ tɑ nyɩ mɑ tǝpote. Mpʋ tɔ, ɩ́ mǝlɩ. Tɑcɑɑ ɩ́ pɑɑsǝnɑ-mɛ nɑ ɩ́ lɑ-mɛɣɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("S215_21","011_15_21","2SA","15","21","21","Tǝnɑɣɑlɛ Ɩtɑyi cɔ wulɑʋ sɩ: Mɑ tuunɑ Ɩsɔ nɑ nyɑ́ sɩ: Timpi n kɑ polo tɔ tǝnɑɣɑ tɩɩ polo, pɑɑ sǝm mɑɣɑmɑɣɑ tɩɩ sɩ. ");
INSERT INTO dop_vpl VALUES ("S215_22","011_15_22","2SA","15","22","22","Ntɛnɑ wulɑʋ tɔ Ɩtɑyi sɩ: Ye mpʋ tɛɛ nɔɣɔ. Ɩlɛnɑ Ɩtɑyi nɑ ɩ yǝlɑɑ tǝnɑ nɑ ɩ piyɑ tǝnɑ pɑ́ tɛɛ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S215_23","011_15_23","2SA","15","23","23","Ḿpʋ́ɣʋ́ wulɑʋ nɑ ɩ yǝlɑɑ pɑ tʋ mpɑɑʋ nɑ pɑ́ tɛɛkɩ. Ye ɩ tɑlɑ ɩcɑtɛ nte, tǝlɛ tǝ yǝlɑɑ pǝlɩ ɩsǝlʋm nɑ pɑ́ mɑkɩ kɑpusi. Ɩlɛnɑ wulɑʋ nɑ́ɑ́ tɛɛ Setǝlɔŋ lɔɔʋ nɑ ɩ yǝlɑɑ nɑ́ɑ́ tǝŋnɑ wʋlɑɣɑ tɛtʋ tɔɔ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S215_24","011_15_24","2SA","15","24","24","Kɔtʋlʋ Sɑtɔkɩ nɑ Lefii nyǝ́mɑ mpɑ pɑ sǝɣǝlɑɣɑ Ɩsɔ ɑtɑkɑɑ tɔ pɑɑ wɛ tǝnɛ ɩnɩ tɔtɔ. Ḿpʋ́ɣʋ́ pɑ sɩɩ Ɩsɔ ɑtɑkɑɑ nɑ Apiyɑtɑɑ sǝŋɑɑ nɑ yǝlɑɑ tɔŋɑ lɩɩʋ kɛ ɩcɑtɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S215_25","011_15_25","2SA","15","25","25","Ɩlɛnɑ wulɑʋ tɔ Sɑtɔkɩ sɩ: Mǝŋnɑ Ɩsɔ ɑtɑkɑɑ kɛ ɩcɑtɛ tɑɑ. Ye Tɑcɑɑ kɑ́ hʋlɩ-m suulu, ɩ kɑ́ mǝlǝnɑ-m nɑ mɑɑ tɑsɑ-ɩ nɑʋ kɛ ɩ lonte tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S215_26","011_15_26","2SA","15","26","26","Amɑ ye ɩ kɑ tɔ sɩ: Aɑɩ, mɑɑ cɑɑkɩ-ŋ, ɩlɛ ɩ́ lɑ-m ɩsǝnɑ ɩ cɑɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S215_27","011_15_27","2SA","15","27","27","Ḿpʋ́ɣʋ́ wulɑʋ tɑsɑ Sɑtɔkɩ kɛ heeluɣu sɩ: Nyɑnɑ nyɑ́ pǝyɑlʋ Ahimɑɑsɩ nɑ Apiyɑtɑɑ pǝyɑlʋ Yonɑtɑŋ ɩ́ mǝlǝnɑ lɑŋhʋlʋmlɛ kɛ ɩcɑtɛ tɑɑ nɑ ɩ́ feŋiɣi. ");
INSERT INTO dop_vpl VALUES ("S215_28","011_15_28","2SA","15","28","28","Tɩɩ tɑŋ wʋlɑɣɑ tɛtʋ pɔɣɔ tǝtɛsǝlɛnɑɑ, nɑ mɑ́ nɩɩ ɩcɑtɛ ɑlɑɑfǝyɑ tɔm. ");
INSERT INTO dop_vpl VALUES ("S215_29","011_15_29","2SA","15","29","29","Ḿpʋ́ɣʋ́ Sɑtɔkɩ nɑ Apiyɑtɑɑ pɑ mǝlǝnɑ Ɩsɔ ɑtɑkɑɑ kɛ Yosɑlɛm nɑ pɑ́ cɑɣɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S215_30","011_15_30","2SA","15","30","30","Ḿpʋ́ɣʋ́ Tɑfiiti tɑkɑ ɩ ɩsɛntɔɔ kɛ sɑɑlɑɣɑ nɑ ɩ́ wiiki nɑ ɩ́ kpɑɑkɩ Olifinɑɑ pulɑɣɑ tɔɔ kɛ́ nɔɔhɛɛ kpɛtɛ. Nɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ́ɑ́ tɑkɩ pɛlɛ pɑ ɩsɛntɔɔ nɑ pɑ́ wiiki mpʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S215_31","011_15_31","2SA","15","31","31","Ɩlɛnɑ pɑ́ kɔɔ pɑ́ heeli wulɑʋ sɩ Ahitofɛlɩ tǝŋɑ Apǝsɑlɔm. Ntɛnɑ Tɑfiiti sɩ: Hɑɩ, Tɑcɑɑ, wɑkǝlɩ Ahitofɛlɩ lɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("S215_32","011_15_32","2SA","15","32","32","Wɑɑtʋ wei Tɑfiiti tɑlɑ pulɑɣɑ nyʋɣʋ tɑɑ timpi pɑ sɛɛkɩ Ɩsɔ tɔ, ɩlɛ ɩ tɑɑpɑlʋ nɑ ɩ lɑɣɑtʋ tɑsʋlʋ Akii tʋ Husɑyi kɔmɑɣɑlɛ nɑ lɑŋwɑkǝllɛ nɑ ɩ cɑpɑ cǝlɑɑ nɑ ɩ nyʋɣʋ nɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("S215_33","011_15_33","2SA","15","33","33","Ntɛnɑ Tɑfiiti sɩ: Ye n tǝŋǝɣɩ-m pǝ kɑɑ wɑɑsɩ-m. ");
INSERT INTO dop_vpl VALUES ("S215_34","011_15_34","2SA","15","34","34","Mǝlɩ ɩcɑtɛ tɑɑ nɑ ń heeli Apǝsɑlɔm sɩ n kɑ kɛ́ mɑ tǝmlɛ tʋ kɛ lɔŋ kɛ́, ɩlɛ nɔɔnɔɔ n cɑɑ sɩ ń nyǝnǝɣɩ ɩnǝɣɩ nyɑ́ cɑɑ. Wɑɑtʋ ɩnǝɣɩ n kɑ wɑkǝlɩ lɑɣɑtʋ nti Ahitofɛlɩ tɑsǝɣɩ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S215_35","011_15_35","2SA","15","35","35","Pǝlɛ pǝ pɑɑsi kɔtǝlɑɑ Sɑtɔkɩ nɑ Apiyɑtɑɑ pɑ wɛ tǝnɑɣɑ. Ye n nɩɩ ntiɣi Apǝsɑlɔm pɑ tɔɔ n polo ń heeli-wɛ. ");
INSERT INTO dop_vpl VALUES ("S215_36","011_15_36","2SA","15","36","36","Pɑ pǝyɑlɑɑ Ahimɑɑsɩ nɑ Yonɑtɑŋ pɑ wɛ tǝnɑɣɑ, n kɑ tili-wɛ nɑ pɑ́ kɔɔ pɑ heeli-m. ");
INSERT INTO dop_vpl VALUES ("S215_37","011_15_37","2SA","15","37","37","Ḿpʋ́ɣʋ́ Tɑfiiti tɑɑpɑlʋ Husɑyi mǝlɑ ɩcɑtɛ tɑɑ kɛ́ wɑɑtʋ wei Apǝsɑlɔm kɔmɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S216_1","011_16_1","2SA","16","1","1","Wɑɑtʋ wei Tɑfiiti tɛɛ Olifinɑɑ pulɑɣɑ nyʋɣʋ tɑɑ kɛ́ pǝcɔ, ɩlɛ Mefipɑɑlɩ tǝmlɛ tʋ wei pɑ yɑɑ sɩ Sipɑ tɔ ɩ kɑtɑ-ɩ kɛlɛ nɑ ɩ kpɑŋɑsɩ nɑɑlɛ. Nɑ pɑ́ hɔkɑ sɩ tɔɔ kɛ́ potopotonɑɑ ŋmʋnʋɣʋ (200) nɑ lɛsɛŋ kʋwʋlʋ pɑɣɑ kɛ nɩɩnʋwɑ (100) nɑ tɩɩŋ pee lʋm nyǝnɑ kɛ tukuŋ nɩɩnʋwɑ (100) nɑ sʋlʋm huluɣu. ");
INSERT INTO dop_vpl VALUES ("S216_2","011_16_2","2SA","16","2","2","Ḿpʋ́ɣʋ́ wulɑʋ pɔɔsɑ-ɩ sɩ: Pepeɣe n lɑkǝnɑ? Ntɛnɑ Sipɑ sɩ: Nyɑ́ tǝyɑɣɑ nyǝ́mɑ kɑ cɑkɩ kpɑŋɑsɩ. Ɩfepiyɑ tɔɣɔnɑɣɑ ntɛ́ potopotonɑɑ nɑ tɩɩŋ pee ɑnɛ. Mpɑ pɑ́ kɑwɑ wʋlɑɣɑ tɛtʋ tɑɑ, ɩlɛ pɑ kʋnɑ sʋlʋm pǝnɛɣɛ lʋkɔtʋ. ");
INSERT INTO dop_vpl VALUES ("S216_3","011_16_3","2SA","16","3","3","Ḿpʋ́ɣʋ́ Tɑfiiti pɔɔsɑ-ɩ sɩ: Leɣe Mefipɑɑlɩ wɛɛ? Mpʋɣʋlɛ sɩ: Mefipɑɑlɩ polɑ Yosɑlɛm sɩ Ɩsɛɣɛlɩ nyǝ́mɑ ɩ́ cɛlɛ-ɩ ɩ cɔsɔ Sɑyuli kɑwulɑɣɑ kɛ pǝnɛntɛ. ");
INSERT INTO dop_vpl VALUES ("S216_4","011_16_4","2SA","16","4","4","Ntɛnɑ wulɑʋ tɔmɩ-ɩ sɩ: Mefipɑɑlɩ nyǝm tǝnɑ pǝsɑ nyɑ́ nyǝm. Mpʋɣʋlɛ Sipɑ hǝntɑ Tɑfiiti kɛ ɑtɛ nɑ ɩ tɔ sɩ: Hɑɩ, tɑ́ cɑɑ wulɑʋ, mɑ sɑmɑ, hʋlʋ-m suulu kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S216_5","011_16_5","2SA","16","5","5","Tɑfiiti tɑlɑ Pɑhulim ɩlɛ Sɑyuli lʋlʋɣʋ tʋ wei pɑ yɑɑ sɩ Kelɑɑ tɔ ɩ pǝyɑlʋ Simeyi lɩɩwɑɣɑlɛ nɑ ɩ́ tǝŋsǝɣɩ-ɩ mpusi. ");
INSERT INTO dop_vpl VALUES ("S216_6","011_16_6","2SA","16","6","6","Ɩlɛnɑ ɩ́ lɔɣɔ ɩ́ nɑ ɩ wɑɑlɩ nyǝ́mɑ tǝnɑɣɑ pɛɛ. Pǝyele ɩ́lɛ́ ɩ yǝlɑɑ nɑ ɩ yoolɑɑ kɑ tʋ-ɩ hɛkʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S216_7","011_16_7","2SA","16","7","7","Simeyi nyɑɑsɑɣɑ Tɑfiiti kɛ́ sɩ: Polo polo ń tɛɛ, yʋlʋkʋlʋ nɑ ɩsɑɣɑʋ nyɑ́. ");
INSERT INTO dop_vpl VALUES ("S216_8","011_16_8","2SA","16","8","8","Tɑcɑɑ ɩ́ mǝŋnɑ Sɑyuli wei ɩ kɑwulɑɣɑ n lɛɛkɑɑ tɔ ɩ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ pɑ sǝm tɔm kɛ nyɑ́ nyʋɣʋ tɑɑ. Pǝ tɔɔ kɛ́ Ɩsɔ lɛɛkɑ nyɑ́ kɑwulɑɣɑ nɑ ɩ́ cɛlɑ-kɛɣɛ nyɑ́ pǝyɑɣɑ. N pǝsʋɣʋ yem kɛ́ ɩsǝntɔ nɑ ń cɔɔkɩ tɔ nyɑ́ ɩsɑɣɑtʋ fɛlǝɣǝnɑ-ŋ. Mpi tɔ, n kɛ́ yʋlʋkʋlʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S216_9","011_16_9","2SA","16","9","9","Ḿpʋ́ɣʋ́ Seluyɑ pǝyɑlʋ Apisɑyi tɔmɑ wulɑʋ sɩ: Pepe tɔɔ kɛ́ hɑɣɑ kɑnɛ kɑ tʋʋkɩ tɑ́ cɑɑ wulɑʋ kɛ mpʋ? Lɑ suulu nɑ ń yele nɑ mɑ́ sɛtɩ ɩ nyʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S216_10","011_16_10","2SA","16","10","10","Ntɛnɑ wulɑʋ sɩ: Sowɑpɩ nɑ ɩ neu Apisɑyi mǝ tɔm suwe? Ye ɩ tʋʋkɩ-m Ɩsɔ heelinɑ-ɩ sɩ ɩ́ tʋʋ-m. Ɩlɛ ɑwe kɑ́ kpɛɛsǝnɑ-ɩ sɩ pepe tɔɔ? ");
INSERT INTO dop_vpl VALUES ("S216_11","011_16_11","2SA","16","11","11","Mpʋɣʋlɛ Tɑfiiti tɔmɑ ɩ wɑɑlɩ nyǝ́mɑ tǝnɑ nɑ Apisɑyi sɩ: Mɑ tɑpʋɣʋ tɛɛ pǝyɑɣɑ nɑ́ tɑ́ kisi mɑ weesuɣu kɛ pɛɛkʋɣʋ, hɑlɩ ḿpʋ́ɣʋ́ Pɛncɑmɛɛ tʋ nɑ? Ɩ́ yele-ɩ nɑ ɩ́ tʋʋ-m. Tɑcɑɑ hɑnɑ-ɩ pǝ mpɑɑʋ. ");
INSERT INTO dop_vpl VALUES ("S216_12","011_16_12","2SA","16","12","12","Ntɑnyɩ Tɑcɑɑ kɑ́ nɑ́ mɑ wɑhɑlɑ nɑ ɩ́ lɛɛtɩ-m kʋpɑntʋ kɛ mpusi ɩnɛ ɩ lonte. ");
INSERT INTO dop_vpl VALUES ("S216_13","011_16_13","2SA","16","13","13","Ḿpʋ́ɣʋ́ Tɑfiiti nɑ ɩ yǝlɑɑ pɑ tʋɣʋtɑ pɑ mpɑɑʋ nɑ Simeyi nɑ́ɑ́ wɛ pʋɣʋ kɔŋkɔŋ tɔɔ nɑ ɩ́ tɔŋnɑ wulɑʋ mpusi tǝŋsʋɣʋ nɑ ɩ́ lɔkɩ-ɩ pɛɛ nɑ ɩ́ kʋsǝɣɩ mʋsʋɣʋ nɑ ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S216_14","011_16_14","2SA","16","14","14","Wulɑʋ nɑ ɩ yǝlɑɑ pɑ tɑlɑ Yɑɑtɑnɩ nɔɣɔ ɩlɛnɑ pɑ́ hɛɛsɩ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S216_15","011_16_15","2SA","16","15","15","Ḿpʋ́ɣʋ́ Apǝsɑlɔm nɑ Ɩsɛɣɛlɩ sɑmɑɑ tǝnɑ pɑ sʋʋ Yosɑlɛm tɑɑ nɑ Ahitofɛlɩ kɛ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S216_16","011_16_16","2SA","16","16","16","Wɑɑtʋ wei Tɑfiiti tɑɑpɑlʋ Husɑyi tɑlɑ Apǝsɑlɔm ɩlɛnɑ ɩ́ sɛɛ-ɩ sɩ: Mǝ nɑ tɛtʋ, mǝ nɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("S216_17","011_16_17","2SA","16","17","17","Ntɛnɑ Apǝsɑlɔm pɔɔsɩ-ɩ sɩ: Anɩ nyɑ́ tɑɑpɑlʋ ntɛ́ mɑ cɑɑ. Pepe tɔɔ kɛ́ n tɑ tǝŋ ɩ́lɛ́? ");
INSERT INTO dop_vpl VALUES ("S216_18","011_16_18","2SA","16","18","18","Ntɛnɑ Husɑyi cɔ sɩ: Wei Tɑcɑɑ nɑ yǝlɑɑ pɑnɛ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ lǝsɑɑ tɔɣɔ mɑ cɑɑ tǝŋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S216_19","011_16_19","2SA","16","19","19","Pǝ tɩɩ wɛɛ sɩ ɩ pǝyɑlʋ nyɑɣɑ mɑɑ lɑ tǝmlɛ kɛ teitei ɩsɩɩ mɑɑ lɑpʋ nyɑ́ cɑɑ kɛ tǝmlɛ tɔ. Ḿpʋ́ɣʋ́ mɑɑ lɑ nyɑ́. ");
INSERT INTO dop_vpl VALUES ("S216_20","011_16_20","2SA","16","20","20","Ḿpʋ́ɣʋ́ Apǝsɑlɔm tɔmɑ Ahitofɛlɩ sɩ: Ɩ́ mɑɣɑsɩ nɑ tǝ́ nɑ́ mpi pǝ wɛ lɑpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S216_21","011_16_21","2SA","16","21","21","Kɛlɛnɑ Ahitofɛlɩ sɩ: Sʋʋnɑ nyɑ́ cɑɑ ɑlɑɑ mpɑ ɩ yelɑɑ sɩ pɑ́ tɑŋ tǝyɑɣɑ tɔ. Wɑɑtʋ ɩnǝɣɩ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ kɑ́ nɑ́ sɩ n pǝsɑ nyɑ́ tǝɣɩ nyɑ́ cɑɑ kolontu. Ɩlɛnɑ nyɑ́ wɑɑlɩ nyǝ́mɑ nɑ́ɑ́ nyɔɔ toŋ. ");
INSERT INTO dop_vpl VALUES ("S216_22","011_16_22","2SA","16","22","22","Ḿpʋ́ɣʋ́ pɑ sikɑ Apǝsɑlɔm kɛ cokǝle kɛ kɑwulɑɣɑ tǝyɑɣɑ pɑtɑ tɔɔ. Nɑ ɩ́ nɑ ɩ cɑɑ ɑlɑɑ pɑ́ sʋʋ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("S216_23","011_16_23","2SA","16","23","23","Lɑɣɑtʋ nti Ahitofɛlɩ tɑsɑɣɑ Apǝsɑlɔm kɛ wɑɑtʋ ɩnɩ tɔ tɩɩ wɛ teitei kɛ́ ɩsɩɩ Ɩsɔ yɔɣɔtǝɣǝnɑ. Pɑɑ Tɑfiiti mɑɣɑmɑɣɑ ḿpʋ́ɣʋ́ pɩɩ wɛɛ. ");
INSERT INTO dop_vpl VALUES ("S217_1","011_17_1","2SA","17","1","1","Ḿpʋ́ɣʋ́ Ahitofɛlɩ tɔmɑ Apǝsɑlɔm sɩ: Yele nɑ mɑ́ lǝsɩ yoolɑɑ kɛ yǝlɑɑ iyisi nɑɑnʋwɑ nɑ nɑɑlɛ (12000) nɑ mɑ́ tʋ Tɑfiiti wɑɑlɩ kɛ ɑhoo ɑnɛ. ");
INSERT INTO dop_vpl VALUES ("S217_2","011_17_2","2SA","17","2","2","Ntɑnyɩ mɑɑ kpǝlɩ-ɩ tiili nɑ ɩ́ kɑwɑ nɑ ɩ yǝlɑɑ yɑ, ɩlɛnɑ mɑ́ kʋ-ɩ ɩ tike. ");
INSERT INTO dop_vpl VALUES ("S217_3","011_17_3","2SA","17","3","3","Ɩlɛnɑ mɑ́ kuu yǝlɑɑ tǝnɑ nɑ mɑ́ kɔnɑ-ŋ. Nyɑ́ kolontu ɩ́ sǝpɑ, pɑ tǝnɑ pɑ mǝlǝɣɩ nyɑ́ kiŋ kɛ́ nɑ yǝlɑɑ hɛɛsɩ. ");
INSERT INTO dop_vpl VALUES ("S217_4","011_17_4","2SA","17","4","4","Ḿpʋ́ɣʋ́ Apǝsɑlɔm nɑ Ɩsɛɣɛlɩ sɔsɑɑ tǝnɑ pɑ lɑŋɑ hɛɛnɑ tɔm ntɩ. ");
INSERT INTO dop_vpl VALUES ("S217_5","011_17_5","2SA","17","5","5","Amɑ Apǝsɑlɔm sisɑ tǝ tɑɑ, ɩlɛnɑ ɩ́ tɔ sɩ: Ɩ́ yɑɑ Husɑyi nɑ tǝ nɩɩ ɩ́lɛ́ ɩ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("S217_6","011_17_6","2SA","17","6","6","Husɑyi kɔmɑ, ɩlɛnɑ ɩ́ heeli-ɩ Ahitofɛlɩ kʋyɔɣɔtʋtʋ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Tɩɩ lɑ mpʋ yɑɑ ɩsǝnɑ? Nyɑ́ɑ́ yɔɣɔtɩ nyɑ́ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("S217_7","011_17_7","2SA","17","7","7","Ntɛnɑ Husɑyi sɩ: Ahitofɛlɩ kʋyɔɣɔtʋtʋ tǝnɛ tǝ tɑ tǝŋ pǝnɛntɛ. ");
INSERT INTO dop_vpl VALUES ("S217_8","011_17_8","2SA","17","8","8","Nyɑ́ mɑɣɑmɑɣɑ n nyǝ́mɑ sɩ nyɑ́ cɑɑ nɑ ɩ yǝlɑɑ pɑ kɛ́ ɑpɑlɑɑ kɛ́. Pǝ́cɔ́ pɑ wɛ pɑ́ɑ́nɑ́ kɛ́ ɩsɩɩ yʋlʋ kpɑkʋɣʋʋ tɔɣɔlɑɣɑ pǝyɑɣɑ nɑ kɑ́ wɛ ɩsǝnɑ tɔ. Nyɑ́ cɑɑ kɛ́ yoolu kɛ́. Ɩɩ hǝntǝɣɩ yem kɛ́ ɑhoo. ");
INSERT INTO dop_vpl VALUES ("S217_9","011_17_9","2SA","17","9","9","Pǝ nɔkɑɑ ɩsǝntɔ ɩ ŋmɛlɑ lɔɔʋ yɑɑ tiili tɑɑ kɛ́, nɑ ye pɑ kʋ tɑ́ tɑɑ lɛlɑɑ, yǝlɑɑ ɩ́ nɩɩwɑ pɑɑ tɔ sɩ Apǝsɑlɔm wɑɑlɩ nyǝ́mɑ kpisɑɑ. ");
INSERT INTO dop_vpl VALUES ("S217_10","011_17_10","2SA","17","10","10","Hɑlɩ sɔɣɔntʋ kpɑ tɑ́ tɑɑ ɑpɑlɑɑ mpɑ pɑ wɛ ɑpɑlʋtʋ ɩsɩɩ tɔɣɔlɑsɩ tɔ. Mpi tɔ, Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nyǝ́mɑ sɩ nyɑ́ cɑɑ kɛ́ ɑkɑ. Pǝyele ɩ wɛnɑ yoolɑɑ tɑɑ yoolɑɑ. ");
INSERT INTO dop_vpl VALUES ("S217_11","011_17_11","2SA","17","11","11","Mpʋ tɔ, mɑ tɑsǝɣɩ-ŋ lɑɣɑtʋ sɩ ń koti Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑɣɑ tuutuumɑ. Pǝ kpɑɣɑʋ Tɑŋ nɑ pǝ́ polo Pɛɛsepɑ tɔ. Ɩlɛnɑ nyɑnɑ wɛ ɩ́ polo nyɑ́ cɑɑ kɛ yoonɑʋ. ");
INSERT INTO dop_vpl VALUES ("S217_12","011_17_12","2SA","17","12","12","Tɩɩ mɑɣɑnɑ-ɩ tiili nɑ tǝ́ hoti ɩ tɔɔ ɩsɩɩ tɛʋ. Ɩlɛ ɩ́ nɑ ɩ yǝlɑɑ pɑ tɑɑ nɔɣɔlʋ kɑɑ fiti. ");
INSERT INTO dop_vpl VALUES ("S217_13","011_17_13","2SA","17","13","13","Ye pɑ sewɑ, nɑ pɑ́ sʋʋ ɩcɑtɛ nɑtǝlɩ tǝ tɑɑ, ɩlɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ ponɑ ŋmɩɩsɩ nɑ pɑ́ tuu ɩcɑtɛ ntɛ́ nɑ pɑ́ tiinɑ lɔɔʋ. Hɑlɩ pǝ kɑɑ kɑɑsɩ koloŋiyɑ. ");
INSERT INTO dop_vpl VALUES ("S217_14","011_17_14","2SA","17","14","14","Ḿpʋ́ɣʋ́ Apǝsɑlɔm nɑ Ɩsɛɣɛlɩ yǝlɑɑ tǝnɑ tɔmɑ sɩ: Husɑyi nyǝntʋ lɑpɑ sɑnɑ nɑ Ahitofɛlɩ nyǝntʋ. Pǝyele Tɑcɑɑ nɑ́ tʋ ɩ tɑɑ kɛ́ sɩ ɩ wɑkǝlǝɣɩ Ahitofɛlɩ lɑɣɑtʋ tɑsʋɣʋ mpǝɣɩ nɑ pǝ kɔnɑ mpusi kɛ Apǝsɑlɔm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S217_15","011_17_15","2SA","17","15","15","Ḿpʋ́ɣʋ́ Husɑyi polɑɑ nɑ ɩ́ heeli kɔtǝlɑɑ Sɑtɔkɩ nɑ Apiyɑtɑɑ kɛ lɑɣɑtʋ nti Ahitofɛlɩ tɑsɑ Apǝsɑlɔm nɑ Ɩsɛɣɛlɩ sɔsɑɑ tɔ, nɑ lɑɣɑtʋ nti ɩnɩ ɩ tɑsɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S217_16","011_17_16","2SA","17","16","16","Sɩ pɑ́ tili lɔŋ nɑ pɑ́ heeli Tɑfiiti sɩ ɩ́ tɑɑ sʋʋ ɑhoo ɑnɛɣɛ Yɑɑtɑnɩ tɛtɛkǝlɛ tɑɑ tǝnɑ. Pǝ́ tɑɑ kɔɔ nɑ ɩ nɑ ɩ wɑɑlɩ nyǝ́mɑ tǝnɑ pɑ́ wɛɛ ɑsolɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S217_17","011_17_17","2SA","17","17","17","Yonɑtɑŋ nɑ Ahimɑɑsɩ pɛlɛ pɑ wɛ hite nɔɣɔ kɛ ɩcɑtɛ wɑɑlɩ sɩ nɔɣɔlʋ ɩ́ tɑɑ nɑ-wɛ. Ḿpʋ́ɣʋ́ tǝmlɛ tʋ ɑlʋ nyǝŋ nɔɣɔlʋ ɩ polɑɑ nɑ ɩ́ heeli-wɛ sɩ: Ɩ́ polo mǝ mɑɣɑmɑɣɑ nɑ ɩ́ heeli-tǝɣɩ wulɑʋ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("S217_18","011_17_18","2SA","17","18","18","Amɑ ɩfepu nɔɣɔlʋ nɑ́ nɑ-wɛ nɑ ɩ́ polo ɩ tɑɣɑsɩ Apǝsɑlɔm. Mpɛ pɑ cɛkǝnɑɑ sɩ pɑ nɑ-wɛ, ɩlɛnɑ pɑ́ se lɔŋ nɑ pɑ́ polo Pɑhulim ɩcɑtɛ kɛ ɑpɑlʋ nɔɣɔlʋ ɩ tɛ nɑ pɑ́ ŋmɛlɩ ɩ lɔkɔ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S217_19","011_17_19","2SA","17","19","19","Ḿpʋ́ɣʋ́ ɑlʋ nɔɣɔlʋ kpɑɣɑ pʋʋɣʋ nɑ ɩ́ tɑkɩ lɔkɔ tɔɔ nɑ ɩ́ le kʋtɔɣɔʋ pee, sɩ nɔɣɔlʋ ɩ́ tɑɑ cɛkǝnɑ sɩ pʋlʋpʋ wɛ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S217_20","011_17_20","2SA","17","20","20","Ntɛnɑ Apǝsɑlɔm tǝmlɛ nyǝ́mɑ sʋʋ tǝyɑɣɑ ŋkɛ kɑ tɑɑ nɑ pɑ́ pɔɔsɩ ɑlʋ kɛ Ahimɑɑsɩ nɑ Yonɑtɑŋ pɑ tɔɔ. Alʋ sɩ: Pɑ tɛsɑ lɔɔʋ. Tǝmlɛ nyǝ́mɑ pɛɛkɑɑ pɑ tɑ nɑ pʋlʋ, ɩlɛnɑ pɑ́ mǝlɩ Yosɑlɛm. ");
INSERT INTO dop_vpl VALUES ("S217_21","011_17_21","2SA","17","21","21","Pɑ tɛɛwɑ, ɩlɛnɑ Ahimɑɑsɩ nɑ Yonɑtɑŋ pɑ́ lɩɩ lɔkɔ tɑɑ nɑ pɑ́ polo pɑ́ heeli Tɑfiiti sɩ: Kʋlɩ nɑ ń tɛsɩ pɔɣɔ kɛ lɔŋ, nɑ pɑ́ kɛɛsɩ-ɩ nti Ahitofɛlɩ kɛɛsɑ Apǝsɑlɔm sɩ pɑ́ lɑ Tɑfiiti-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S217_22","011_17_22","2SA","17","22","22","Tǝnɑɣɑ Tɑfiiti nɑ ɩ yǝlɑɑ pɑ kʋlɑ kpɑkpɑɑ nɑ pɑ́ tɛsɩ Yɑɑtɑnɩ. Pǝ kɔmɑ sɩ pǝ nyɑɑlǝɣɩ tɔ pǝ tɑ kɑɑsɩ nɔɣɔlʋ. Pɑ tɛsɑ pɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S217_23","011_17_23","2SA","17","23","23","Ahitofɛlɩ nɑwɑ sɩ pɑ tɑ mʋ ɩ tɔm, ɩlɛnɑ ɩ́ kʋlɩ nɑ ɩ́ kpɛɛlɩ ɩ kpɑŋɑɣɑ nɑ ɩ́ kpe ɩ tɛ. Ɩ heelɑ ɩ tǝyɑɣɑ nyǝ́mɑ kɛ nti tǝ wɛ lɑpʋ tɔ, ɩlɛnɑ ɩ́ tʋ́ ɩ tǝɣɩ ŋmǝnɑɣɑ nɑ ɩ́ sɩ́ nɑ pɑ́ pimi-ɩ ɩ cɑɑ pǝlɑɑʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S217_24","011_17_24","2SA","17","24","24","Tɑfiiti pɑ tɑlɑ Mɑhɑnɑyim, ɩlɛ Apǝsɑlɔm nɑ Ɩsɛɣɛlɩ yǝlɑɑ mpɑ pɑ tǝŋɑɣɑ ɩ wɑɑlɩ tɔ pɑ tɛsɑ Yɑɑtɑnɩ kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("S217_25","011_17_25","2SA","17","25","25","Apɑlʋ wei pɑ yɑɑ sɩ Amɑsɑ tɔɣɔ Apǝsɑlɔm lɛɛtɑ yoolɑɑ wulɑʋ Sowɑpɩ lonte. Amɑsɑ ɩnɩ ɩ cɑɑ kɛ́ Ɩsɛɣɛlɩ tʋ kɛ́ nɑ pɑ́ yɑɑ-ɩ sɩ Yetɛɛ. Ɩ too kɛlɛ Nɑhɑsɩ pɛɛlɔ Apikɑɑlɩ, ɩ́lɛ́ ɩ neu ntɛ́ Sowɑpɩ pɑ too Seluyɑ. ");
INSERT INTO dop_vpl VALUES ("S217_26","011_17_26","2SA","17","26","26","Ḿpʋ́ɣʋ́ Apǝsɑlɔm-wɛ pɑ sikɑ Kɑlɑɑtɩ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S217_27","011_17_27","2SA","17","27","27","Tɑfiiti pɑ tɑlɑ Mɑhɑnɑyim, ɩlɛnɑ Amoni tɛtʋ ɩcɑtɛ Lɑpɑ tʋ Nɑhɑsɩ pǝyɑlʋ Sopi, nɑ Lo-Tɑpɑɑ tʋ Amiyɛlɩ pǝyɑlʋ Mɑkii, nɑ Kɑlɑɑtɩ tɛtʋ ɩcɑtɛ Lokelim tʋ Pɑɑsilɑyi ");
INSERT INTO dop_vpl VALUES ("S217_28","011_17_28","2SA","17","28","28","pɑ ponɑ Tɑfiiti-wɛɣɛ kʋhǝntǝŋ nɑ cɛmsɛnɑɑ nɑ hɛɛsɩ, nɑ tɔɣɔnɑɣɑ pee, nɑ mʋlʋm, nɑ pee kʋtoŋee, nɑ soonɑ kɛ loosi nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("S217_29","011_17_29","2SA","17","29","29","Nɑ tɩɩŋ nim nɑ nɑɑnim nɑ heeŋ, nɑ wɑɑkɑsǝnɑɑ. Mpi tɔ, pɑ tɔŋɑɣɑ kɛ́ sɩ ɩkɑɑlɛ nɑ nyɔɣɔsɩ nɑ lʋkɔtʋ pǝ pɩɩ-wɛɣɛ wʋlɑɣɑ tɛtʋ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S218_1","011_18_1","2SA","18","1","1","Ḿpʋ́ɣʋ́ Tɑfiiti kotɑ ɩ yoolɑɑ nɑ ɩ́ kpɑ pɑ tɑɑ kɛ́ yoolɑɑ iyɑɣɑ (1000) nyʋɣʋ nyǝ́mɑ nɑ nɩɩnʋwɑ (100) nyʋɣʋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S218_2","011_18_2","2SA","18","2","2","Ɩlɛnɑ ɩ́ cɛlɑ Sowɑpɩ kɛ tintiɣile, nɑ Sowɑpɩ neu kɛ tintiɣile, nɑ Kɑtɩ tʋ Ɩtɑyi kɛ tintiɣile nɑ ɩ́ tɔ sɩ: Mɑ́ nɑ-mɛ tɩɩ ponɑ yoou. ");
INSERT INTO dop_vpl VALUES ("S218_3","011_18_3","2SA","18","3","3","Tǝnɑɣɑlɛ sɑmɑɑ tɔmɑ-ɩ sɩ: Aɑɩ, pǝ fɛɩ sɩ ń lɩɩ. Mpi tɔ, pɑɑ pǝ kǝlɑ-tʋ nɑ tǝ́ se nɔɣɔlʋ ɩɩ pɑɑsǝɣǝnɑ-tʋ. Pɑɑ tɑ tɑɑ yǝlɑɑ hɔɣɔlʋɣʋ sǝpǝnɑ ɑwusɑ. Amɑ nyɑ́ wɛ kɛ́ ɩsɩɩ tɑ tɑɑ yǝlɑɑ iyisi nɑɑnʋwɑ (10000). Mpʋ tɔ, pǝ kǝlɑ teu sɩ ń sɑɑlɩ ɩcɑtɛ tɑɑ nɑ pǝ́ kǝlɑ-tʋ ɩlɛ n sǝnɑ-tʋ. ");
INSERT INTO dop_vpl VALUES ("S218_4","011_18_4","2SA","18","4","4","Ntɛnɑ wulɑʋ sɩ: Tɔʋ, mɑɑ lɑ nti tǝ mɑɣɑ-mɛɣɛ teu tɔ. Ɩlɛnɑ wulɑʋ sǝŋ nɔnɔɣɔ nɑ yǝlɑɑ lɩɩkɩ iyisi iyisi nɑ nɩɩnʋwɑ nɩɩnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("S218_5","011_18_5","2SA","18","5","5","Ḿpʋ́ɣʋ́ wulɑʋ tɔmɑ Sowɑpɩ nɑ Apisɑyi nɑ Ɩtɑyi sɩ: Ɩ́ nyǝnɩ mɑ ɩsɛntɑɑ nɑ ɩ́ lɑ mɑ pu Apǝsɑlɔm tǝpɑmm. Ɩlɛnɑ yǝlɑɑ tǝnɑ nɩɩ mpʋ. ");
INSERT INTO dop_vpl VALUES ("S218_6","011_18_6","2SA","18","6","6","Ḿpʋ́ɣʋ́ Tɑfiiti yǝlɑɑ polɑɑ sɩ pɑ yookinɑ Apǝsɑlɔm-wɛɣɛ Ɩfǝlɑyim hɔtʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S218_7","011_18_7","2SA","18","7","7","Yǝlɑɑ iyisi hiu (20000) tǝcu kɛ Tɑfiiti nyǝ́mɑ kʋwɑ Apǝsɑlɔm nyǝ́mɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S218_8","011_18_8","2SA","18","8","8","Ḿpʋ́ɣʋ́ yoou yɑwɑ tɛtʋ tǝnɑ tɑɑ. Hɔtʋɣʋ tɔɣɔ yǝlɑɑ mpɑɣɑ kʋyɑkʋ ŋkʋ tɔ pǝ kǝlɑ mpɑ lɑɣɑtɛ tɔɣɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S218_9","011_18_9","2SA","18","9","9","Ḿpʋ́ɣʋ́ Apǝsɑlɔm tutɑ ɩ tǝɣɩ Tɑfiiti yǝlɑɑ tɑɑ nɑ ɩ́ cɑɣɑ kpɑɣɑnʋ. Ɩlɛnɑ kpɑɣɑnʋ seenɑ-ɩ nɑ ɩ́ sʋsɩ-ɩ tʋɣʋ sɔsɔɔʋ nɑkʋlɩ kʋ piliŋɑsɩ tɑɑ, nɑ ɩ nyɔɔsɩ hɔkǝnɑ-sɩ nɑ ɩ́ susi nɑ kpɑɣɑnʋ nɑ́ɑ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S218_10","011_18_10","2SA","18","10","10","Nɔɣɔlʋ nɑ́ mpʋ, ɩlɛnɑ ɩ́ heeli Sowɑpɩ sɩ: Tɑ cɑɑ, mɑ nɑwɑ Apǝsɑlɔm nɑ ɩ́ susinɑ tʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S218_11","011_18_11","2SA","18","11","11","Ntɛnɑ ɩ́ tɔmɩ-ɩ sɩ: N nɑ-ɩ ɩlɛ pepe tɔɔ kɛ́ n tɑ kʋ-ɩ tǝnɑɣɑ kpɑkpɑɑ. Hɑlɩ mɑɑ hɑ-ŋ liɣitee nyǝɣǝtʋ nɑɑnʋwɑ kɛlɛ nɑ tɑmpɑlɑ. ");
INSERT INTO dop_vpl VALUES ("S218_12","011_18_12","2SA","18","12","12","Ḿpʋ́ɣʋ́ ɑpɑlʋ ɩnɩ ɩ cɔwɑ sɩ: Pɑɑ liɣitee nyǝɣǝtʋ iyɑɣɑ (1000) kɛ n tɩɩ hɑ-m mɑ niŋ kɑɑ kpɑ wulɑʋ pǝyɑlʋ tɔɔ. Mpi tɔ, tǝ nɩɩwɑ nti wulɑʋ heelɑ nyɑ́ nɑ Apisɑyi nɑ Ɩtɑyi sɩ ɩ́ lɑ lɑɑkɑlɩ nɑ ɩnɩ ɩ pǝyɑlʋ Apǝsɑlɔm tɔ. ");
INSERT INTO dop_vpl VALUES ("S218_13","011_18_13","2SA","18","13","13","Pɑɑ mɑɑ lɑpɑ kɑɑnɩɩtʋ nɑ mɑ́ kʋ-ɩ, wulɑʋ kɑ nɩɩ-tǝɣɩ. Nyɑ́ mɑɣɑmɑɣɑ n tɑɑ wɑɑsɩ-m. ");
INSERT INTO dop_vpl VALUES ("S218_14","011_18_14","2SA","18","14","14","Ntɛnɑ Sowɑpɩ sɩ: Mɑɑ sǝŋǝɣɩ nyɑ́ kiŋ kɛ yem. Ɩlɛnɑ ɩ́ kpɑɣɑ ŋmɑntɑɑsɩ tooso nɑ ɩ́ polo ɩ́ yɑɣɑ-sǝɣɩ Apǝsɑlɔm fulɑɣɑ tɔɔ. Mpi tɔ, ɩ́lɛ́ ɩ tɑɑ sǝtɑ. ");
INSERT INTO dop_vpl VALUES ("S218_15","011_18_15","2SA","18","15","15","Ḿpʋ́ɣʋ́ yoolɑɑ nɑɑnʋwɑ wei ɩ tɔkɑɣɑ Sowɑpɩ yoou wontu tɔ pɑ tɑmɑ Apǝsɑlɔm nɑ pɑ́ tɛɛsɩ-ɩ kʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S218_16","011_18_16","2SA","18","16","16","Ḿpʋ́ɣʋ́ Sowɑpɩ hʋlɑ tutuɣu nɑ yǝlɑɑ koti nɑ pɑ́ hɛɛsɩ pɑ kolontunɑɑ tɔɣɔnʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S218_17","011_18_17","2SA","18","17","17","Ɩlɛnɑ pɑ́ kpɑɣɑ sǝtʋ nɑ pɑ́ pɛtɩ pʋ́ʋ́ɣʋ́ nɑkʋlɩ kʋ tɑɑ kɛ́ hɔtʋɣʋ tɑɑ nɑ pɑ́ kɑɑ ɩ tɔɔ kɛ́ kɑŋmɑɑɣɑ tǝkelem, nɑ Apǝsɑlɔm yoolɑɑ tǝnɑ se nɑ pɑɑ wei ɩ́ mǝlɩ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("S218_18","011_18_18","2SA","18","18","18","Wɑɑtʋ wei Apǝsɑlɔm kɑ wɛnɑ ɩ ɩsɛ tɔɣɔ ɩ yelɑɑ nɑ pɑ́ ŋmɑ-ɩ ɑkele kɛ wulɑʋ tɛtɛkǝlɛ tɑɑ kɛ́ Yosɑlɛm kiŋ, nɑ ɩ́ yɑɑ-ɩ sɩ Apǝsɑlɔm ɑkele, sɩ ɩnɩ ɩ fɛɩ ɑpɑlʋpǝyɑɣɑ tɔ pɑɑ yɑɑkǝnɑ ɩ hǝtɛ. Nɑ pɑ́ yɑɑkɩ-ɩ ḿpʋ́ɣʋ́ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S218_19","011_18_19","2SA","18","19","19","Ḿpʋ́ɣʋ́ Sɑtɔkɩ pǝyɑlʋ Ahimɑɑsɩ tɔmɑ sɩ: Ɩ́ yele nɑ mɑ́ lɔɣɔ mɑ tɩ nɑ mɑ́ ponɑ wulɑʋ kɛ tɔm kʋpɑntʋ sɩ Tɑcɑɑ hɑ-ɩ tɑmpɑnɑ nɑ ɩ́ yɑpɩ-ɩ ɩ kolontunɑɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S218_20","011_18_20","2SA","18","20","20","Ntɛnɑ Sowɑpɩ tɔ sɩ: Pǝ tɑɣɑ nyɑɑ heelinɑ wulɑʋ kɛ tɔm kʋpɑntʋ kɛ sɑŋɑ. Mpi tɔ, ɩ pǝyɑɣɑ sǝpǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S218_21","011_18_21","2SA","18","21","21","Ɩlɛnɑ Sowɑpɩ tɔ Ɩtiyopii tʋ sɩ: Polo nɑ ń heeli wulɑʋ kɛ mpi n nɑwɑ tɔ. Ntɛnɑ Ɩtiyopii tʋ hǝntɩ-ɩ ɑtɛ nɑ ɩ́ tʋ́ cɑsǝlɛ. ");
INSERT INTO dop_vpl VALUES ("S218_22","011_18_22","2SA","18","22","22","Ḿpʋ́ɣʋ́ Ahimɑɑsɩ tɑsɑ Sowɑpɩ kɛ tɔm sɩ: Pɑɑ pɩɩ lɑ ɩsǝnɑ yele nɑ mɑ́ se Ɩtiyopii tʋ wɑɑlɩ. Sowɑpɩ sɩ: Mɑ pǝyɑlʋ, pepe nyʋɣʋ tɔɔ kɛ́ n cɑɑ pote? N kɑɑ wɑɑ pǝ tɑɑ se. ");
INSERT INTO dop_vpl VALUES ("S218_23","011_18_23","2SA","18","23","23","Ahimɑɑsɩ sɩ: Pɑɑ pɩɩ lɑ ɩsǝnɑ pǝ wɛɛ sɩ mɑ́ polo kɛ́. Ɩlɛnɑ Sowɑpɩ sɩ: Tɔʋ, polo. Ḿpʋ́ɣʋ́ Ahimɑɑsɩ kpɑɣɑ tɛtɛkǝlɛ mpɑɑʋ nɑ ɩ́ polo ɩ́ lɑɑlɩ Ɩtiyopii tʋ. ");
INSERT INTO dop_vpl VALUES ("S218_24","011_18_24","2SA","18","24","24","Wɑɑtʋ ɩnɩ Tɑfiiti kɑ cɑɣɑ nɔnɔɔsɩ nɑɑlɛ hɛkʋ nɑ ɩ́ tɑŋɑɑ. Ḿpʋ́ɣʋ́ tɑŋlʋ kpɑ nɔnɔɣɔ nyʋɣʋ tɑɑ, ɩlɛnɑ ɩ loosi nɔɣɔlʋ ɩ seeki ɩ tike nɑ ɩ́ kɔŋ. ");
INSERT INTO dop_vpl VALUES ("S218_25","011_18_25","2SA","18","25","25","Ɩlɛnɑ ɩ́ mɑ́ kɑpukɑ nɑ ɩ́ heeli wulɑʋ, nɑ ɑpɑlʋ ɩnɩ ɩ tɔŋnɑ sewɑ nɑ ɩ́ kɔŋ. Ntɛnɑ wulɑʋ sɩ: Ye ɩ tike ɩ seekinɑ tɔm kʋpɑntʋ kɛ ɩ kɔŋnɑ. ");
INSERT INTO dop_vpl VALUES ("S218_26","011_18_26","2SA","18","26","26","Ḿpʋ́ɣʋ́ tɑŋlʋ tɑsɑ lɛlʋ kɛ nɑʋ nɑ ɩ́ seeki nɑ ɩ́ kɔŋ. Ɩlɛnɑ ɩ́ mɑ́ kɑpukɑ nɑ ɩ́ heeli nɔnɔɣɔ tɑŋlʋ sɩ: Nɔɣɔlʋ nɑ́ kɔŋnɑ ntɛɣɛ ɩ tike tǝkoŋ tɔtɔ. Wulɑʋ sɩ: Tɔm kʋpɑntʋ tɔtɔɣɔ ɩ́lɛ́ ɩ kɔŋnɑ. ");
INSERT INTO dop_vpl VALUES ("S218_27","011_18_27","2SA","18","27","27","Mpʋɣʋlɛ tɑŋlʋ sɩ: Kɑncɑɑlɑɣɑ nyǝŋ sewɑ nǝɣǝsǝnɑ Ahimɑɑsɩ sewɑ kɛ́. Ntɛnɑ wulɑʋ sɩ: Yʋlʋ kʋpɑŋ kɛ́, nɑ tɔm kʋpɑntʋ kɛ ɩ kɔŋnɑ. ");
INSERT INTO dop_vpl VALUES ("S218_28","011_18_28","2SA","18","28","28","Ahimɑɑsɩ tɑlɑɑ, ɩlɛnɑ ɩ́ mɑ́ kɑpukɑ sɩ: Alɑɑfǝyɑ kɛ́ yoo, tɑ cɑɑ. Ɩlɛnɑ Ahimɑɑsɩ hǝntɩ wulɑʋ kɛ ɑtɛ nɑ ɩ́ tɔmɩ-ɩ sɩ: Nyɑ́ Ɩsɔ Tɑcɑɑ wei ɩ yɑpɑ-ŋ nyɑ́ kolontunɑɑ mpɑ pɑ kʋlɑɣɑɑ nyɑ́ tɔɔ tɔɣɔlɛ teeli tʋ. ");
INSERT INTO dop_vpl VALUES ("S218_29","011_18_29","2SA","18","29","29","Ntɛnɑ wulɑʋ pɔɔsɩ-ɩ sɩ: Apǝsɑlɔm wɛnɑ ɑlɑɑfǝyɑ? Ahimɑɑsɩ sɩ: Mɑ nɑwɑ sɑmɑɑ tuutuumɑ kɛ wɑɑtʋ wei Sowɑpɩ tilɑ-tʋ tɔ, ɩlɛ mɑ tɑ nyɩ mpi pɑ lɑkɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S218_30","011_18_30","2SA","18","30","30","Wulɑʋ sɩ: Nyɑ́ɑ́ sǝŋnɑ kpeeŋɑ tɔɔ cǝnɛ. Ɩlɛnɑ Ahimɑɑsɩ kɛɛ nɑ ɩ́ sǝŋ. ");
INSERT INTO dop_vpl VALUES ("S218_31","011_18_31","2SA","18","31","31","Ɩtiyopii tʋ tɑlɑ kpɑkpɑɑ, ɩlɛnɑ ɩ́ tɔ sɩ: Tɑ cɑɑ, tɔm kʋpɑntʋ kɛ mɑ kɔŋnɑ-ŋ. Sɑŋɑ Tɑcɑɑ hɑ-ŋ tɑmpɑnɑ nɑ ɩ́ yɑ-ŋ mpɑ pɑ kʋlɑɣɑɑ nyɑ́ tɔɔ tɔ pɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S218_32","011_18_32","2SA","18","32","32","Ntɛnɑ wulɑʋ pɔɔsɩ-ɩ sɩ: Nɑ Apǝsɑlɔm wɛnɑ ɑlɑɑfǝyɑ? Ɩlɛnɑ ɩ́ tɔ sɩ: Tɑ cɑɑ, nyɑ́ kolontunɑɑ tǝnɑ nɑ mpɑ pɑ lʋkǝnɑ-ŋ ɑsɑlɑʋ tɔ pɑ́ wɛɛ ɩsɩɩ Apǝsɑlɔm. ");
INSERT INTO dop_vpl VALUES ("S219_1","011_19_1","2SA","19","1","1","Ḿpʋ́ɣʋ́ wulɑʋ lɑɑkɑlɩ pǝsɑɑ nɑ ɩ́ kpɑɑkɩ ɑtɛ nɑ ɩsɔtɑɑ kutuluɣu tɑɑ nɑ ɩ́ wiiki nɑ ɩ́ yɔɣɔtǝɣɩ sɩ: Hɑɩ, mɑ pu Apǝsɑlɔm, mɑ pu Apǝsɑlɔm. Ye mɑɑ sǝpǝnɑ nyɑ́ lonte pǝ tɑɑ kǝlɩ teu? Mɑ pu Apǝsɑlɔm, hɑɩ, mɑ pu. ");
INSERT INTO dop_vpl VALUES ("S219_2","011_19_2","2SA","19","2","2","Ḿpʋ́ɣʋ́ pɑ polɑɑ nɑ pɑ́ heeli Sowɑpɩ sɩ wulɑʋ wiikinɑ ntɛ́ nɑ ɩ́ huɣutiɣi lotu kɛ Apǝsɑlɔm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S219_3","011_19_3","2SA","19","3","3","Ɩlɛnɑ kʋyɑkʋ ŋkʋ kʋ lɑŋhʋlʋmlɛ pǝsɩ lǝyɑɣɑ kɛ yǝlɑɑ tɑɑ. Mpi tɔ, yǝlɑɑ nɩɩkɑɣɑ pɑ yɔɣɔtǝɣɩ sɩ wulɑʋ cɑɣɑ ɩ pǝyɑɣɑ lǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S219_4","011_19_4","2SA","19","4","4","Fɛɛlɛ lɑpɑ yǝlɑɑ nɑ yoou ŋku pɑ yoowɑ tɔɣɔ, ɩlɛnɑ pɑ́ sʋʋ ɩcɑtɛ tɑɑ tǝhɛɛ. ");
INSERT INTO dop_vpl VALUES ("S219_5","011_19_5","2SA","19","5","5","Nɑ wulɑʋ nɑ́ɑ́ hɔkɑ ɩ ɩsɛntɔɔ kɛ́ sɑɑlɑɣɑ nɑ ɩ́ kiisiɣinɑ nɔɣɔ sɔsɑɣɑ sɩ: Hɑɩ, mɑ pu Apǝsɑlɔm, hɑɩ, mɑ pu, hɑɩ, mɑ pu. ");
INSERT INTO dop_vpl VALUES ("S219_6","011_19_6","2SA","19","6","6","Ḿpʋ́ɣʋ́ Sowɑpɩ sʋʋ wulɑʋ kiŋ kɛ nɑŋ tɑɑ nɑ ɩ́ tɔmɩ-ɩ sɩ: Sɑŋɑ n tʋɣɩ fɛɛlɛ kɛ nyɑ́ tǝmlɛ nyǝ́mɑ mpɑ pɑ yɑpɑ nyɑ́ nɑ nyɑ́ pǝyɑlɑɑ nɑ nyɑ́ pɛɛlɑɑ nɑ nyɑ́ ɑlɑɑ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S219_7","011_19_7","2SA","19","7","7","Mpɑ pɑɑ cɑɑkɩ-ŋ tɔɣɔ n sɔɔlɑɑ nɑ nyɑ́ tɑɑ kpɑɑkǝnɑ mpɑ pɑ cɑɑkɩ-ŋ tɔ. N lɑkʋɣʋ ɩsǝntɔ tɔ pǝ hʋlǝɣɩ kɛ́ sɩ n nyǝnǝɣɩ nyɑ́ yoolɑɑ nɑ pɑ nyʋɣʋ nyǝ́mɑ kɛ yem. Pǝ lɑkɩ-m ɩsɩɩ ye tɑɑ sǝpǝnɑ nɑ Apǝsɑlɔm wɛnɑ ɩ weesuɣu pɩɩ kǝlɑ-ŋ teu. ");
INSERT INTO dop_vpl VALUES ("S219_8","011_19_8","2SA","19","8","8","Mpʋ tɔ, kʋlɩ nɑ ń lɩɩ nɑ ń yɔɣɔtǝnɑ yǝlɑɑ nɑ pɑ lɑŋɑ hɛɛ. Mɑ tuukinɑ Tɑcɑɑ sɩ ye n tɑ lɩɩ pǝ kɑɑ kɑɑsɩ pɑɑ yʋlʋ kʋlʋm kɛ nyɑ́ kiŋ kɛ ɑhoo ɑnɛ. Nɑ mpi pǝ tɛmɑ-ŋ mɑɣɑnɑʋ kɛ hɑtoo nyɑ́ pǝcɑɑtʋ tɔ pɩɩ lɑ sɑnɑ nɑ nɔɔnɔɔ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("S219_9","011_19_9","2SA","19","9","9","Ḿpʋ́ɣʋ́ wulɑʋ kʋlɑɑ nɑ ɩ́ cɑɣɑ nɔnɔɣɔ. Nɑ pɑ́ heeli yǝlɑɑ sɩ ɩ lɩɩwɑ nɑ ɩ́ cɑɣɑ nɔnɔɣɔ. Ɩlɛnɑ pɑ tǝnɑ pɑ́ polo ɩ kiŋ. Wɑɑtʋ ɩnɩ ɩ tɑɑ Apǝsɑlɔm nyǝ́mɑ kɑ tɛmɑ sewɑ nɑ pɑɑ wei ɩ́ mǝlɩ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("S219_10","011_19_10","2SA","19","10","10","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ tɛtʋ yǝlɑɑ kpekɑ tǝnɑ lɑŋɑ tɑ hɛɛ nɑ pɑ́ tɔŋ sɩ: Wulɑʋ yɑpɑ-tʋɣʋ tɑ́ kolontunɑɑ nɑ Filiisi nyǝ́mɑ niŋ tɑɑ nɑ nɔɔnɔɔ ɩ́ seeki ɩcɑtɛ kɛ Apǝsɑlɔm tɔɔ? ");
INSERT INTO dop_vpl VALUES ("S219_11","011_19_11","2SA","19","11","11","Apǝsɑlɔm wei tǝ lǝsɑɑ nɑ tǝ kpɑ wulɑʋ tɔ, ɩ́lɛ́ ɩ sǝpɑ yoou tɑɑ, ɩlɛ pepe tɔɔ kɛ́ tǝ kɑɑ mǝlǝnɑ Tɑfiiti? ");
INSERT INTO dop_vpl VALUES ("S219_12","011_19_12","2SA","19","12","12","Ḿpʋ́ɣʋ́ wulɑʋ Tɑfiiti nɩɩ tǝ tǝnɑ nti Ɩsɛɣɛlɩ nyǝ́mɑ yɔɣɔtǝɣɩ tɔ. Ɩlɛnɑ ɩ́ tili kɔtǝlɑɑ Sɑtɔkɩ nɑ Apiyɑtɑɑ sɩ pɑ́ pɔɔsɩ Yutɑ nyʋɣʋ nyǝ́mɑ sɩ: Pepe tɔɔ kɛ́ pɑ wɛɛ nɑ pɑ́ niɣitiɣi mɑ mǝlǝnɑʋ tɔm tɑɑ? ");
INSERT INTO dop_vpl VALUES ("S219_13","011_19_13","2SA","19","13","13","Anɩ mɛɣɛlɛ mɑ yǝlɑɑ nɑ mɑ́ nɑ-mɛ tǝ́ kɑɑ cɑlǝm. Ɩlɛ pepe tɔɔ kɛ́ lɛlɑɑ ŋmɑɑkɩ tɑ tɔɔ? ");
INSERT INTO dop_vpl VALUES ("S219_14","011_19_14","2SA","19","14","14","Ɩ́ heeli Amɑsɑ tɔtɔ sɩ mɑ́ nɑ-ɩ tǝ kɑɑnɑ cɑlǝm, nɑ ɩnɩ ɩ kɑ lɛɛtǝnɑ Sowɑpɩ lonte tɑɑ nɑ ɩ́ pǝsɩ yoolɑɑ wulɑʋ. Ye pǝ tɑ lɑ mpʋ Ɩsɔ ɩ́ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("S219_15","011_19_15","2SA","19","15","15","Ḿpʋ́ɣʋ́ Tɑfiiti pǝsɑ Yutɑ nyǝ́mɑ tǝnɑ nɑ pɑ́ wɛɛ ɩsɩɩ yʋlʋ kʋlʋm. Ɩlɛnɑ pɛlɛ pɑ́ tili nɑ pɑ́ heelɩ-ɩ sɩ ɩ́ nɑ ɩ nyǝ́mɑ pɑ́ mǝlɩ. ");
INSERT INTO dop_vpl VALUES ("S219_16","011_19_16","2SA","19","16","16","Ḿpʋ́ɣʋ́ wulɑʋ mǝlɑɑ nɑ ɩ́ tɑlɑ Yɑɑtɑnɩ pɔɣɔ. Ɩlɛnɑ Yutɑ nyǝ́mɑ polo Kilikɑɑ nɑ pɑ́ sǝŋɩ-ɩ nɑ pɑ́ tɛsǝnɑ-ɩ Yɑɑtɑnɩ pɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S219_17","011_19_17","2SA","19","17","17","Ḿpʋ́ɣʋ́ Pɛncɑmɛɛ tʋ Simeyi wei ɩ kɑ́ tʋʋ wulɑʋ nɑ ɩ́ wɛ timpi pɑ yɑɑ sɩ Pɑhulim tɔ, ɩ lɔɣɔ ɩ tɩ nɑ ɩ́ nɑ Yutɑ nyǝ́mɑ pɑ́ polo wulɑʋ Tɑfiiti sǝŋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S219_18","011_19_18","2SA","19","18","18","Ɩ wɑɑlɩ kɑ wɛ Pɛncɑmɛɛ nyǝ́mɑ kɛ yǝlɑɑ iyɑɣɑ (1000) nɑ Sɑyuli tǝmlɛ tʋ Sipɑ, nɑ ɩ pǝyɑlɑɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ, nɑ ɩ tǝmlɛ nyǝ́mɑ kɛ hiu, nɑ pɑ́ tɛsɩ Yɑɑtɑnɩ kɛ wulɑʋ ɩsɛntɑɑ. ");
INSERT INTO dop_vpl VALUES ("S219_19","011_19_19","2SA","19","19","19","Kpɩɩlʋɣʋ ŋku pɑɑ cɛlɑ wulɑʋ sɩ ɩ tɛsǝnɑ tɔ kʋlɛ kʋ tɔŋnɑ ɩ tǝyɑɣɑ nyǝ́mɑ kɛ tɛsǝnɑʋ. Wɑɑtʋ wei Tɑfiiti cɑɑkɑɣɑ tɛsʋɣʋ, ɩlɛ Simeyi kɔmɑɣɑlɛ nɑ ɩ́ hǝntɩ-ɩ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S219_20","011_19_20","2SA","19","20","20","Nɑ ɩ́ tɔ sɩ: Hɑɩ, tɑ́ cɑɑ wulɑʋ, tɑɑ tɔkɩ ɩsɑɣɑtʋ nti mɑɑ lɑpɑ-ŋ kʋyɑkʋ ŋku n lɩɩkɑɣɑ Yosɑlɛm tɑɑ tɔ. Hɑɩ, kʋ-tǝɣɩ nyɑ́ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S219_21","011_19_21","2SA","19","21","21","Mɑ nyǝ́mɑ sɩ mɑ wɑkǝlɑ-ŋ. Pǝ tɔɔ kɛ́ mɑ cɑɑlɑ lɩɩʋ kɛ Yosɛɛfʋ kpekɑ tɑɑ nɑ mɑ́ kɔɔ-ŋ sǝŋʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S219_22","011_19_22","2SA","19","22","22","Ntɛnɑ Apisɑyi cɛ Tɑfiiti nɔɣɔ tɔɔ sɩ: Pǝ wɛɛ sɩ pɑ́ kʋ Simeyi kɛ́. Mpi tɔ, ɩ kɑ tǝŋsɑ Tɑcɑɑ kʋlǝsʋ kɛ mpusi. ");
INSERT INTO dop_vpl VALUES ("S219_23","011_19_23","2SA","19","23","23","Ḿpʋ́ɣʋ́ Tɑfiiti pɔɔsɑ Apisɑyi nɑ ɩ tɑɑlʋ Sowɑpɩ sɩ: Mǝ tɔm suwe? Pepe tɔɔ kɛ́ ɩ cɑɑlǝɣɩ-m mpʋ? Mɑ tɑɣɑnɑ Ɩsɛɣɛlɩ kɑwulɑɣɑ tɑɑ kɛ́ mǝlʋɣʋ kɛ́. Ɩlɛ pǝ fɛɩ sɩ pɑ́ kʋ nɔɣɔlʋɣʋ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("S219_24","011_19_24","2SA","19","24","24","Ɩlɛnɑ wulɑʋ heeli Simeyi nɑ tuunɑʋ sɩ: N kɑɑ sɩ. ");
INSERT INTO dop_vpl VALUES ("S219_25","011_19_25","2SA","19","25","25","Ḿpʋ́ɣʋ́ Sɑyuli sɑɑlɩ Mefipɑɑlɩ polɑ wulɑʋ sǝŋʋɣʋ tɔtɔ. Ɩ lɑŋlɛ kɑ wɑkǝlɑ Tɑfiiti sewɑ tɔɔ kɛ́, ɩlɛ ɩ tɑ pɑɑsǝnɑ ɩ nɔɔhɛɛ yɑɑ ɩ tɑntʋɣʋ. Pǝyele ɩ tɑ cɔtɔ ɩ wontu kɛ pǝ kpɑɣɑʋ kʋyɑkʋ ŋku wulɑʋ lɩɩ Yosɑlɛm ɩcɑtɛ tɑɑ nɑ pǝ sɩɩnɑ kʋyɑkʋ ŋku ɩ mǝlɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S219_26","011_19_26","2SA","19","26","26","Wulɑʋ kɔmɑ, ɩlɛnɑ ɩ́ pɔɔsɩ-ɩ sɩ: Mefipɑɑlɩ, pepe tɔɔ kɛ́ n tɑɑ tǝŋɩ-m? ");
INSERT INTO dop_vpl VALUES ("S219_27","011_19_27","2SA","19","27","27","Ɩlɛnɑ ɩ́ tɔ sɩ: Hɑɩ, tɑ cɑɑ, mɑ tǝmlɛ tʋ pǝntǝnɑ-m. Mɑ sɩ ɩ́ kpɛɛlɩ-m mɑ kpɑŋɑɣɑ sɩ mɑ kɛ́ ɩcɑm, nɑ mɑ́ cɑɣɑ-kɛ nɑ mɑ́ tǝŋɩ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S219_28","011_19_28","2SA","19","28","28","Ɩlɛnɑ ɩ́ lɑ-m kɔlǝmɔtɔ kɛ nyɑ́ kiŋ. Nyɑ́ tɩɩ wɛ ɩsɩɩ Ɩsɔ ɩsɔtɑɑ tillu kɛ́, lɑ mpi pǝ wɛ-ŋ teu tɔ. ");
INSERT INTO dop_vpl VALUES ("S219_29","011_19_29","2SA","19","29","29","Pɔpɔtʋ fɛɩ leleŋ, mɑ cɑɑ tǝyɑɣɑ tǝnɑ mʋnɑ sǝm kɛ́. Pɑɑ nɑ mpʋ n yelɑɑ nɑ mɑ́ wɛɛ nyɑ́ nɑ mpɑ ɩ́ tɔkɩ tɔ pɑ hɛkʋ. Mɑ fɛɩnɑ mpɑɑʋ sɩ mɑ́ pɔɔsɩ nɑtǝlɩ se. ");
INSERT INTO dop_vpl VALUES ("S219_30","011_19_30","2SA","19","30","30","Mpʋɣʋlɛ wulɑʋ sɩ: N kǝlǝɣɩ yɔɣɔtʋɣʋ. Mɑ tɛmɑ sɩɩʋ sɩ nyɑ́ nɑ Sipɑ ɩ́ kɑ́ tɑlɑ tɛtʋ ɩlɛ. ");
INSERT INTO dop_vpl VALUES ("S219_31","011_19_31","2SA","19","31","31","Ntɛnɑ Mefipɑɑlɩ sɩ: Sipɑ ɩ tɩɩ kpɑɣɑ pǝ tǝnɑ. Mɑ cɑɑ wulɑʋ n mǝlǝɣɩ nyɑ́ tǝyɑɣɑ tɑɑ ɩlɛ mɑ pɑɑ ye. ");
INSERT INTO dop_vpl VALUES ("S219_32","011_19_32","2SA","19","32","32","Ḿpʋ́ɣʋ́ Kɑlɑɑtɩ tʋ Pɑɑsilɑyi kɔmnɑ Lokelim nɑ ɩ́ sɩɩ wulɑʋ nɑ pɑ́ tɛsɩ Yɑɑtɑnɩ. ");
INSERT INTO dop_vpl VALUES ("S219_33","011_19_33","2SA","19","33","33","Pɑɑsilɑyi ɩnɩ ɩ pɩɩsɩ kɑ wɛ nɩɩnɑɑsɑ kɛ́. Ɩ kɑ sǝnɑ wulɑʋ kɛ wɑɑtʋ wei ɩ kɑ wɛ Mɑhɑnɑyim tɔɣɔ nɑ tɔɣɔnɑɣɑ. Mpi tɔ, ɩ kɑ wɛnɑ liɣitee kɛ sɔsɔm kɛ́. ");
INSERT INTO dop_vpl VALUES ("S219_34","011_19_34","2SA","19","34","34","Mpʋɣʋlɛ wulɑʋ tɔmɑ Pɑɑsilɑyi sɩ: Mɑ nɑ-ŋ tǝ polo Yosɑlɛm nɑ mɑ́ tɔɔ-ŋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S219_35","011_19_35","2SA","19","35","35","Tǝnɑɣɑlɛ Pɑɑsilɑyi pɔɔsɑ wulɑʋ sɩ: Pǝ kɑɑsɑ-m pɩɩsɩ ɩsǝnɑ nɑ mɑ́ sɩ́ nɑ mɑ́ tǝŋǝɣɩ-ŋ Yosɑlɛm? ");
INSERT INTO dop_vpl VALUES ("S219_36","011_19_36","2SA","19","36","36","Sɑŋɑ tɑɑ, mɑ pɩɩsɩ wɛ nɩɩnɑɑsɑ kɛ́. Mɑɑ pǝsǝɣɩ nɑ mɑ́ nyɩ tɔɣɔnɑɣɑ yɑɑ kʋnyɔnyɔɔm leleŋ. Pǝyele mɑɑ nyǝŋ yonyoolɑɑ ɑpɑlɑɑ nɑ ɑlɑɑ pɑ yontu fɑɣɑʋ. Ɩlɛ pepe tɔɔ kɛ́ mɑɑ kɔɔ nɑ pǝ́ tʋɣʋ-ŋ sǝɣǝlɑ kɛ yem. ");
INSERT INTO dop_vpl VALUES ("S219_37","011_19_37","2SA","19","37","37","Pepe tɔɔ kɛ́ n lɑkɩ-m kʋpɑntʋ ntɩ tǝ tɑkɑ? Mɑɑ tɑsɑ-ŋ sɩɩʋ nɑ mɑ́ tɛsǝnɑ Yɑɑtɑnɩ. ");
INSERT INTO dop_vpl VALUES ("S219_38","011_19_38","2SA","19","38","38","Mpi mɑ cɑɑ sɩ ń lɑ-m tɔɣɔlɛ sɩ mɑ́ mǝlɩ nɑ mɑ́ sɩ mɑ ɩcɑtɛ tɑɑ timpi pɑ pimɑ mɑ cɑɑ nɑ mɑ too tɔ. Amɑ kpɑɣɑ mɑ pǝyɑlʋ Kimhɑm nɑ ɩ́ pǝsɩ nyɑ́ nyǝŋ nɑ ń lɑpɩ-ɩ kʋpɑntʋ nti n cɑɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S219_39","011_19_39","2SA","19","39","39","Ntɛnɑ wulɑʋ sɩ: Pǝ wɛ teu, Kimhɑm ɩ́ tǝŋɩ-m nɑ ń heeli-m pǝ tǝnɑ mpi n cɑɑnɑ-ɩ tɔ nɑ mɑ́ lɑpɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S219_40","011_19_40","2SA","19","40","40","Tɑfiiti yǝlɑɑ tǝnɑ tɛsɑ Yɑɑtɑnɩ pɔɣɔ, ɩlɛnɑ wulɑʋ nɑ́ɑ́ tɛsɩ nɑ ɩ́ wɑɣɑlɩ Pɑɑsilɑyi nɑ ɩ́ kooli-ɩ kʋpɑntʋ, nɑ ɩ́lɛ́ ɩ mǝlɩ ɩ tɛ. ");
INSERT INTO dop_vpl VALUES ("S219_41","011_19_41","2SA","19","41","41","Ḿpʋ́ɣʋ́ Yutɑ nyǝ́mɑ nɑ Ɩsɛɣɛlɩ hɔɣɔlʋɣʋ sɩɩ wulɑʋ nɑ ɩ́ nɑ ɩ yǝlɑɑ nɑ Kimhɑm pɑ́ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S219_42","011_19_42","2SA","19","42","42","Ntɛnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ kotinɑ wulɑʋ nɑ pɑ́ pɔɔsɩ-ɩ sɩ: Pepe tɔɔ kɛ́ tɑ́ tɛɛtʋnɑɑ Yutɑ nyǝ́mɑ ŋmɩɩlɑ nyɑ́ nɑ nyɑ́ yǝlɑɑ nɑ pɑ́ mǝlǝnɑ-mɛ? ");
INSERT INTO dop_vpl VALUES ("S219_43","011_19_43","2SA","19","43","43","Mpʋɣʋlɛ Yutɑ nyǝ́mɑ tǝnɑ nɑ́ cɔwɑ sɩ: Mpi tɔ, tɑ yʋlʋ kɛ́. Ɩlɛ pepe mɑɣɑmɑɣɑ hɑŋǝɣǝnɑ-mɛɣɛ pǝ tɑɑ? Wulɑʋ tɑ tɔɔ-tʋ. Pǝyele ɩ tɑ hɑ-tʋɣʋ pʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S219_44","011_19_44","2SA","19","44","44","Tǝnɑɣɑlɛ Ɩsɛɣɛlɩ nyǝ́mɑ cɔwɑ sɩ: Pɑɑ ɩ kɛ́ mǝ nyǝŋ tɔ, tǝ kǝlɑ-mɛɣɛ tɔm nɑɑnʋwɑ. Mpi tɔ, tɑ́ cɑɑlǝnɑ mɑɣɑsʋɣʋ sɩ tɑ́ wulɑʋ ɩ́ mǝlɩ. Ɩlɛ pepe tɔɔ kɛ́ ɩ nyǝnɑ-tʋɣʋ yem kɛ́ mpʋ? Amɑ Yutɑ nyǝ́mɑ nɑ́ holɑɑ nɑ pǝ́ kǝlɩ Ɩsɛɣɛlɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S220_1","011_20_1","2SA","20","1","1","Wɑɑtʋ ɩnɩ ɩ tɑɑ kɛ́ Pɛncɑmɛɛ ɑpɑlʋ tɛtɛlɑtʋ nɔɣɔlʋ ɩ kɑ wɛnnɑ Kilikɑɑ nɑ pɑ́ yɑɑ-ɩ sɩ Sepɑ, nɑ ɩ cɑɑ sɩ Pikili. Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ ɩ hʋlɑ ɑpɑlʋtutuɣu nɑ ɩ́ tɔ sɩ: Tɑ́ nɑ Tɑfiiti tǝ tɑ kɑɑ. Pǝ́cɔ́ ɩ kɑɑ hɑ-tʋɣʋ pʋlʋ. Pɑɑ Ɩsɛɣɛlɩ tʋ wei ɩ́ mǝlɩ ɩ cokǝle tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S220_2","011_20_2","2SA","20","2","2","Mpʋɣʋlɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ sewɑ Tɑfiiti nɑ pɑ́ tʋ Sepɑ wɑɑlɩ. Amɑ Yutɑ nyǝ́mɑ nɑ́ tɑ́ lɩɩ pɑ wulɑʋ wɑɑlɩ. Pɑ nɑ-ɩ pɑ tɔmnɑ ḿpʋ́ɣʋ́ hɑtoo Yɑɑtɑnɩ, hɑlǝnɑ Yosɑlɛm. ");
INSERT INTO dop_vpl VALUES ("S220_3","011_20_3","2SA","20","3","3","Ḿpʋ́ɣʋ́ wulɑʋ mǝlɑ ɩ tǝyɑɣɑ tɑɑ kɛ́ Yosɑlɛm, nɑ ɩ́ kuu ɑlɑɑ mpɑ ɩ kɑ́ yelɑɑ sɩ pɑ́ tɑŋ tǝyɑɣɑ tɔ nɑ ɩ́ tǝkɩ-wɛɣɛ kutuluɣu nɑkʋlɩ kʋ tɑɑ nɑ pɑ́ tɑŋ-wɛ, nɑ pɑ́ pɑɑsǝnɑ-wɛ. Amɑ ɩɩ kpǝtǝɣǝnɑ-wɛ. Pɑ tǝkɑ-wɛɣɛ ḿpʋ́ɣʋ́ nɑ pɑ́ wɛɛ ɩsɩɩ leelɑɑ hɑlǝnɑ pɑ sǝm. ");
INSERT INTO dop_vpl VALUES ("S220_4","011_20_4","2SA","20","4","4","Ḿpʋ́ɣʋ́ wulɑʋ tɔmɑ Amɑsɑ sɩ: Pɩɩ lɑkɩ kʋyɛɛŋ tooso tɔ, yɑɑ-m Yutɑ nyǝ́mɑ nɑ nyɑ́ nɑ-wɛ ɩ́ kɔɔ. ");
INSERT INTO dop_vpl VALUES ("S220_5","011_20_5","2SA","20","5","5","Ɩlɛnɑ Amɑsɑ tɛɛ. Amɑ kʋyɛɛŋ wei wulɑʋ kɑ tʋ-ɩ tɔ ɩ tɛɛwɑ nɑ pǝ́cɔ́ ɩ́ mǝlɩ. ");
INSERT INTO dop_vpl VALUES ("S220_6","011_20_6","2SA","20","6","6","Tǝnɑɣɑlɛ wulɑʋ tɔmɑ Apisɑyi sɩ: Sepɑ kɑ lɑ-tʋɣʋ ɩsɑɣɑtʋ nɑ pǝ́ kǝlɩ Apǝsɑlɔm. Pǝ tɔɔ tɔ kpɑɣɑ mɑ yǝlɑɑ nɑ ń tǝŋ ɩ wɑɑlɩ. Pǝ tɑɑ kɔɔ nɑ ɩ́ tɑlɑ ɑcɑlɛɛ toŋ nyǝnɑ nɑ ɩ́ fiti-tʋ. ");
INSERT INTO dop_vpl VALUES ("S220_7","011_20_7","2SA","20","7","7","Ḿpʋ́ɣʋ́ Apisɑyi kpɑɣɑ Sowɑpɩ yoolɑɑ nɑ wulɑʋ tɑŋlɑɑ nɑ yoolɑɑ tɑɑ yoolɑɑ tǝnɑ nɑ pɑ́ tʋ Sepɑ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S220_8","011_20_8","2SA","20","8","8","Pɑ kɔmɑ nɑ pɑ́ kpɛɣɛtǝnɑ Kɑpɑwɔŋ pɩɩʋ ɩlɛ Amɑsɑ sǝŋɑ-wɛɣɛlɛ. Nɑ Sowɑpɩ lǝlɑ ɩ lɑɣɑtɛ kɛ ɩ tokonɑɑ tɔɔ nɑ tǝ́ wɛ tǝ suɣute tɑɑ. Ɩ tɔŋɑɣɑ mpʋ ɩlɛnɑ lɑɣɑtɛ hoti*fɑ*. kpɛɛ lɑɣɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S220_9","011_20_9","2SA","20","9","9","Ḿpʋ́ɣʋ́ Sowɑpɩ sɛɛ-ɩ sɩ: N wɛ ɑlɑɑfǝyɑ ɑpɑŋnyɑ? Ɩlɛnɑ Sowɑpɩ kpɑ Amɑsɑ tɑntʋɣʋ nɑ ɩ niŋ ntɔɣɔŋ sɩ ɩ wɑɣɑlǝɣɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S220_10","011_20_10","2SA","20","10","10","Amɑsɑ tɑ pɑɑsǝnɑ lɑɣɑtɛ nte tɩɩ wɛ ɩ niŋ lɛlǝŋ tɑɑ tɔ. Ɩlɛnɑ Sowɑpɩ sɔ-tɛɣɛ ɩ lotu tɑɑ kɛ́ tɔm kʋlʋm nɑ ɩ tɑɑ pʋntʋ luli ɑtɛ nɑ ɩ́ sɩ kpɑkpɑɑ. Ḿpʋ́ɣʋ́ Sowɑpɩ nɑ ɩ neu Apisɑyi pɑ tʋ Sepɑ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S220_11","011_20_11","2SA","20","11","11","Ɩlɛnɑ Sowɑpɩ yoolɑɑ tɑɑ nɔɣɔlʋ cɑɣɑ Amɑsɑ kiŋ tǝnɑ nɑ ɩ́ tɔŋ sɩ: Mpɑ pɑ wɛ Sowɑpɩ nɑ Tɑfiiti pɑ tɔɔ tɔ pʋntʋnɑɑ ɩ́ tǝŋ Sowɑpɩ. ");
INSERT INTO dop_vpl VALUES ("S220_12","011_20_12","2SA","20","12","12","Nɑ Amɑsɑ nɑ́ɑ́ tɔŋnɑ ɩ cɑlǝm tɑɑ kɛ pilimuɣu kɛ hɑpǝlɛ tɔɔ. Yoolu ɩnɩ ɩ nɑwɑ sɩ yǝlɑɑ tǝnɑ kɔŋ nɑ pɑ́ sǝŋǝɣɩ ɩlɛnɑ ɩ́ tuli Amɑsɑ nɑ ɩ́ ponɑ hɑpǝlɛ kpeeŋɑ nɑ ɩ́ tɑkɩ-ɩ pǝcɛkǝlɛ. ");
INSERT INTO dop_vpl VALUES ("S220_13","011_20_13","2SA","20","13","13","Ɩ lǝsɑ-ɩ mpɑɑʋ tɑɑ tǝnɑ ɩlɛnɑ pɑ tǝnɑ pɑ́ tǝŋ Sowɑpɩ nɑ pɑ́ tɔɣɔnɩ Sepɑ. ");
INSERT INTO dop_vpl VALUES ("S220_14","011_20_14","2SA","20","14","14","Ɩlɛnɑ Sowɑpɩ fɑɣɑnɑ Ɩsɛɣɛlɩ kpekɑ tǝnɑ tɑɑ nɑ ɩ́ mǝlǝɣǝnɑ timpi pɑ yɑɑ sɩ Apɛɛlɩ-Pɛtɩ-Mɑɑkɑ nɑ ɩ cɑɑ lʋlʋɣʋ nyǝ́mɑ tǝnɑ koti nɑ pɑ́ tʋ́ ɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S220_15","011_20_15","2SA","20","15","15","Ḿpʋ́ɣʋ́ Sowɑpɩ-wɛ pɑ tɑmɑ Sepɑ kɛ ɩcɑtɛ ntɛ́ tǝ tɑɑ nɑ pɑ́ ŋmɑ́ pʋlʋ nɑ pǝ́ kʋlɩ ɩsɩɩ koluŋɑ. Ɩlɛnɑ yǝlɑɑ tǝnɑ cɑsɑ ɩcɑtɛ koluŋɑ kite tɛɛ sɩ pɑ pɛtǝɣɩ-kɛ. ");
INSERT INTO dop_vpl VALUES ("S220_16","011_20_16","2SA","20","16","16","Mpʋɣʋlɛ ɑlʋ kpelikpekɑ tʋ nɔɣɔlʋ mɑpɑ kɑpukɑ nɑ koluŋɑ tɑɑ sɩ: Hɑɩ, hɑɩ, mɑ wiikinɑ-mɛ sɩ ɩ́ heeli Sowɑpɩ sɩ mɑ cɑɑ mɑ heeli-ɩ tɔm. ");
INSERT INTO dop_vpl VALUES ("S220_17","011_20_17","2SA","20","17","17","Sowɑpɩ kpǝtǝnɑ-ɩ ɩlɛnɑ ɑlʋ pɔɔsɩ-ɩ sɩ: Nyɑɣɑ pɑ yɑɑ Sowɑpɩ? Sɩ yɛɛ mɑɣɑ. Alʋ sɩ: Hɑɩ, nɩɩ mɑ tɔm. Sowɑpɩ sɩ: Yɔɣɔtɩ. ");
INSERT INTO dop_vpl VALUES ("S220_18","011_20_18","2SA","20","18","18","Ntɛnɑ ɑlʋ sɩ: Pǝ tɩɩ wɛ lɔŋtɑɑ ɩlɛ ye nɔɣɔlʋ wɛnɑ tɔm ɩ kɔŋ Apɛɛlɩ ɩcɑtɛ tɑɑ cǝnɛɣɛ nɑ ɩcɑtɛ nyǝ́mɑ tɑsɑ-ɩ lɑɣɑtʋ ɩlɛ pǝ tɛmɑ. ");
INSERT INTO dop_vpl VALUES ("S220_19","011_20_19","2SA","20","19","19","Mpi tɔ, tɑ́ ɩcɑtɛ wɛ teu kɛ́ nɑ tǝ tɑɑ wɛ tǝpɑmm kɛ Ɩsɛɣɛlɩ tǝnɑ tɑɑ. Ɩlɛnɑ nyɑɑ cɑɑkɩ sɩ n wɑkǝlɩ Ɩsɛɣɛlɩ tɑɑ ɑcɑlɛɛ too? Pepe tɔɔ kɛ́ n cɑɑ sɩ n wɑkǝlɩ kpɑncoou ŋku Tɑcɑɑ hɑ-tʋ tɔ? ");
INSERT INTO dop_vpl VALUES ("S220_20","011_20_20","2SA","20","20","20","Ntɛnɑ Sowɑpɩ sɩ: Mpusi ɩ́ polo pooluŋ, mɑɑ pɛɛkǝɣɩ ɩcɑtɛ tǝnɛ tǝ wɑkǝlʋɣʋ se. ");
INSERT INTO dop_vpl VALUES ("S220_21","011_20_21","2SA","20","21","21","Aɑɩ, pǝ fɛɩ mpʋ. Amɑ Ɩfǝlɑyim pʋɣʋ tɑɑ tʋ wei pɑ yɑɑ sɩ Sepɑ tɔ ɩnɩ ɩ kʋlǝnɑ wulɑʋ Tɑfiiti tɔɔ. Ɩ́ cɛlɛ-m ɩnɩɩnɩ ɩ tike ɩlɛnɑ mɑ́ yele mǝ ɩcɑtɛ nɑ mɑ́ tɛɛ. Ntɛnɑ ɑlʋ ɩnɩ sɩ: Pɑɑ lɔɣɔ-ŋ ɩ nyʋɣʋ nɑ koluŋɑ. ");
INSERT INTO dop_vpl VALUES ("S220_22","011_20_22","2SA","20","22","22","Mpʋɣʋlɛ ɑlʋ polɑ ɩcɑtɛ nyǝ́mɑ kiŋ nɑ lɑɣɑtʋ nɑ pɑ́ sɛtɩ Sepɑ nyʋɣʋ nɑ pɑ́ lɔɣɔ-kʋɣʋ Sowɑpɩ nɑ koluŋɑ. Tǝnɑɣɑlɛ Sowɑpɩ hʋlɑ tutuɣu nɑ ɩ́ yɑsɩ yǝlɑɑ nɑ pɑɑ ɑwe kpe ɩ tɛ nɑ ɩnɩ ɩ mǝlɩ Yosɑlɛm kɛ wulɑʋ kiŋ. ");
INSERT INTO dop_vpl VALUES ("S220_23","011_20_23","2SA","20","23","23","Sowɑpɩ kɛlɛ Ɩsɛɣɛlɩ yoolɑɑ tǝnɑ nyʋɣʋ tʋ. Yoyɑtɑ pǝyɑlʋ Penɑyɑ kɛlɛ wulɑʋ tɑŋlɑɑ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("S220_24","011_20_24","2SA","20","24","24","Atolɑm kɛlɛ lɑmpuu mʋlɑɑ nyʋɣʋ tʋ, nɑ Ahiluti pǝyɑlʋ Yosɑfɑtɩ kɛlɛ Tɑkǝlɑsɩ sɩɩlʋ, ");
INSERT INTO dop_vpl VALUES ("S220_25","011_20_25","2SA","20","25","25","nɑ Sefɑ kɛlɛ sɩ ŋmɑɑlʋ. Sɑtɔkɩ nɑ Apiyɑtɑɑ kɛlɛ kɔtǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S220_26","011_20_26","2SA","20","26","26","Nɑ Yɑyii tʋ Ɩlɑ kɛlɛ Tɑfiiti Sɔpɑɑpɩ. ");
INSERT INTO dop_vpl VALUES ("S221_1","011_21_1","2SA","21","1","1","Ḿpʋ́ɣʋ́ nyɔɣɔsɩ lɩɩwɑ pɩɩsɩ tooso kɛ Tɑfiiti wɑɑtʋ tɑɑ. Ɩlɛnɑ Tɑfiiti pɔɔsɩ Tɑcɑɑ ɩlɛnɑ Tɑcɑɑ tɔ sɩ: Sɑyuli nɑ ɩ tǝyɑɣɑ nyǝ́mɑ pɑ yʋlʋkʋlɛ tɔɔ kɛ́. Mpi tɔ, pɑ kʋwɑ Kɑpɑwɔŋ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S221_2","011_21_2","2SA","21","2","2","Ḿpʋ́ɣʋ́ wulɑʋ yɑɑ Kɑpɑwɔŋ nyǝ́mɑ sɩ ɩ yɔɣɔtǝɣǝnɑ-wɛ. Pɑ tɑɑ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ, Amolii nyǝ́mɑ kɑkɑɑsɑɣɑ kɛ́. Ɩlɛ Ɩsɛɣɛlɩ nyǝ́mɑ kɑ sɩɩwɑ pɑ nɔɣɔ kɛ́ sɩ pɑ kɑɑ kʋ-wɛ. Pɑɑ nɑ mpʋ Sɑyuli kɑ nyɑŋɑɣɑ kɛ́ sɩ pɑ́ tɑɑ kɔɔ nɑ pɑ́ pǝsɩ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ Yutɑ nyǝ́mɑ pɑ kolontunɑɑ. Ɩlɛnɑ ɩ́ lʋ sɩ ɩ kʋɣɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S221_3","011_21_3","2SA","21","3","3","Ḿpʋ́ɣʋ́ Tɑfiiti pɔɔsɑ Kɑpɑwɔŋ nyǝ́mɑ sɩ: Ɩsǝnɑɣɑ pǝ wɛɛ sɩ mɑ́ tɑɣɑnɩ nɑ pǝ́cɔ́ ɩ́ kooli Tɑcɑɑ yǝlɑɑ kɛ kʋpɑntʋ? ");
INSERT INTO dop_vpl VALUES ("S221_4","011_21_4","2SA","21","4","4","Mpʋɣʋlɛ Kɑpɑwɔŋ nyǝ́mɑ cɔwɑ sɩ: Liɣitee yɑɑ wʋlɑ kɑɑ tɑɣɑnɩ tɑ́ nɑ Sɑyuli nɑ ɩ tǝyɑɣɑ nyǝ́mɑ tɑ tɔm. Pǝyele tɑɑ cɑɑkɩ sɩ ń kʋ́ Ɩsɛɣɛlɩ tʋ nɔɣɔlʋ. Ntɛnɑ wulɑʋ sɩ: Ɩlɛ pepe mɑɣɑmɑɣɑ kɛ ɩ́ tɩɩ cɑɑkɩ mɑ́ lɑ-mɛ tǝkpem? ");
INSERT INTO dop_vpl VALUES ("S221_5","011_21_5","2SA","21","5","5","Ɩlɛnɑ pɑ́ cɔ sɩ: Timpi Sɑyuli wɑkǝlɑ-tʋɣʋ sɔsɔm nɑ ɩ́ tʋ́ ɩ tɑɑ sɩ ɩ kpiisiɣi-tʋ tǝkpɑtɑɑ kɛ Ɩsɛɣɛlɩ tɛtʋ tɑɑ tɔ, ");
INSERT INTO dop_vpl VALUES ("S221_6","011_21_6","2SA","21","6","6","mpʋ tɔ, pɑ́ cɛlɑ-tʋɣʋ ɩ piyɑ tɑɑ kɛ́ yǝlɑɑ nɑɑtosompɔɣɔlɑɣɑ nɑ tǝ́ pusi-wɛ nɑ tɩɩŋ kɛ Tɑcɑɑ ɩsɛntɑɑ kɛ Sɑyuli ɩcɑtɛ tɑɑ. Ntɛnɑ wulɑʋ sɩ: Mɑɑ cɛlɛ-mɛɣɛ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S221_7","011_21_7","2SA","21","7","7","Ḿpʋ́ɣʋ́ wulɑʋ kisɑ Sɑyuli sɑɑlɩ Mefipɑɑlɩ tɔɔ kɛ́ nɔɔsɩ nsi ɩ́ nɑ ɩ́lɛ́ ɩ cɑɑ Sonɑtɑŋ pɑɑ pɛɛlɑ Tɑcɑɑ ɩsɛntɑɑ tɔ sɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S221_8","011_21_8","2SA","21","8","8","Ɩlɛnɑ wulɑʋ kpɑ Ayɑ pɛɛlɔ Lisipɑ kɑ lʋlɑ piyɑ nsiɣi Sɑyuli tɔ. Pɑ yɑɑ lɛlʋ sɩ Alǝmoni nɑ lɛlʋ sɩ Mefiposɛtɩ, nɑ pǝ́ sɔɔsǝnɑ piyɑ kɑkpɑsɩ wei Sɑyuli pɛɛlɔ Mikɑɑlɩ kɑ lʋlɑ Apɛɛlɩ-Meholɑ tʋ Pɑɑsilɑyi pǝyɑlʋ Atiliyɛɛlɩ tɔ, ");
INSERT INTO dop_vpl VALUES ("S221_9","011_21_9","2SA","21","9","9","nɑ ɩ́ cɛlɛ-wɛɣɛ Kɑpɑwɔŋ nyǝ́mɑ nɑ pɑ́ pusi-wɛɣɛ tɩɩŋ tɔɔ kɛ́ Tɑcɑɑ ɩsɛntɑɑ kɛ́ pulɑɣɑ tɔɔ, nɑ pɑ́ sɩ́ pɑ nɑɑtosompɔɣɔlɑɣɑ ɩnǝɣɩ sɑɑ wei pɑ cɑɑlǝɣɩ kʋmtʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S221_10","011_21_10","2SA","21","10","10","Ḿpʋ́ɣʋ́ Sɑyuli leelu Lisipɑ kpɑɣɑ fɔlǝtɔ tɑkɑ nɑ lɑŋwɑkǝllɛ nɑ ɩ́ pɔ kʋkpɑmʋɣʋ tɔɔ kɛ́ sǝtɑɑ cɔlɔ kɛ kʋmtʋ cɑɑlʋɣʋ wɑɑtʋ hɑlǝnɑ tɛʋ nɩɩʋ, nɑ ɩ́ tɔɣɔnǝɣɩ sumɑsɩ kɛ ilim sɩ sɩ́ tɑɑ tɔɣɔ-wɛ. Nɑ ɩ́ tɔɣɔnǝɣɩ ḿpʋ́ɣʋ́ tɑɑlɛ wontu kɛ ɑhoo. ");
INSERT INTO dop_vpl VALUES ("S221_11","011_21_11","2SA","21","11","11","Ḿpʋ́ɣʋ́ pɑ heelɑ Tɑfiiti kɛ mpi Lisipɑ lɑpɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S221_12","011_21_12","2SA","21","12","12","Ntɛnɑ Tɑfiiti tili Yɑpɛɛsɩ nyǝ́mɑ tɛɣɛ Kɑlɑɑtɩ tɛtʋ tɑɑ nɑ pɑ́ cɛlɛ-ɩ Sɑyuli nɑ ɩ pǝyɑlʋ Sonɑtɑŋ pɑ mʋwɑ. Mpɛ ɩnɩ pɑɑ ŋmɩɩlǝnɑ-yɛɣɛ Pɛtɩ-Seyɑŋ nyǝ́mɑ kɑtɑɣɑ tɑɑ timpi Filiisi nyǝ́mɑ kɑ kʋ-wɛɣɛ Kilipʋwɑ nɑ pɑ́ pusi tɔ. ");
INSERT INTO dop_vpl VALUES ("S221_13","011_21_13","2SA","21","13","13","Pɑ kpɑɣɑ Sɑyuli nɑ Sonɑtɑŋ pɑ mʋwɑ kɛ tǝnɑ ɩlɛnɑ pɑ́ kuu yǝlɑɑ nɑɑtosompɔɣɔlɑɣɑ ɩnɩ ɩ nyǝnɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("S221_14","011_21_14","2SA","21","14","14","Ɩlɛnɑ pɑ́ pi Sɑyuli nɑ ɩ pǝyɑlʋ pɑ mʋwɑ kɛ Selɑ ɩcɑtɛ tɑɑ kɛ́ Pɛncɑmɛɛ tɛtʋ tɑɑ kɛ́ Sɑyuli cɑɑ Kisi pǝlɑɑʋ tɑɑ. Ḿpʋ́ɣʋ́ yǝlɑɑ lɑpɑ pǝ tǝnɑ mpi wulɑʋ tʋ-wɛ sɩ pɑ́ lɑ tɔ. Pǝlɛ pǝ wɑɑlɩ kɛ́ Ɩsɔ pɑ́ɑ́nɑ́ hɛɛwɑ tɛtʋ nyǝ́mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S221_15","011_21_15","2SA","21","15","15","Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ yoonɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔtɔ. Ɩlɛnɑ Tɑfiiti nɑ ɩ yoolɑɑ pɑ́ polo nɑ pɑ́ yoonɑ-wɛ nɑ ɩkɑɑlɛ kpɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S221_16","011_21_16","2SA","21","16","16","Ntɛnɑ tooko wei pɑ yɑɑkɑɣɑ Isipi-Penɔpɩ tɔ ɩ́ mɑɣɑsɩ ɩ tɑɑ sɩ ɩ́ kʋ́ Tɑfiiti. Pɑɑ lupɑ ɩ ŋmɑntɑɑɣɑ kɛ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɛ́ nɑ kɑ yuŋ sɛkɑ kiloonɑɑ liɣiti kɛ́ pǝcɔ, nɑ ɩ́ lǝlɑ ɩ tǝnɑɣɑ tɑɑ kɛ́ lɑɣɑtɛ kʋfɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S221_17","011_21_17","2SA","21","17","17","Ḿpʋ́ɣʋ́ Seluyɑ pǝyɑlʋ Apisɑyi polɑ Tɑfiiti wɑɑsʋɣʋ nɑ ɩ́ kʋ Filiisi tʋ. Tǝnɑɣɑlɛ Tɑfiiti yǝlɑɑ kisinɑ-ɩ nɑ tuunɑʋ sɩ: Pǝ fɛɩ sɩ ń tɑsɑ-tʋɣʋ tǝŋʋɣʋ kɛ yoou. Pǝ tɑɑ kɔɔ nɑ pɑ́ kʋ Ɩsɛɣɛlɩ nyǝ́mɑ nɔɣɔ tɔɔ tʋ. ");
INSERT INTO dop_vpl VALUES ("S221_18","011_21_18","2SA","21","18","18","Pǝ wɑɑlɩ kɛ́ pɑ nɑ Filiisi nyǝ́mɑ pɑ tɑsɑ yoou kɛ Kɔpɩ. Tǝnɑɣɑ Hosɑ tʋ Sipekɑɑ kʋwɑ tooko Sɑfi. ");
INSERT INTO dop_vpl VALUES ("S221_19","011_21_19","2SA","21","19","19","Ḿpʋ́ɣʋ́ pɑ nɑ Filiisi nyǝ́mɑ pɑ tɑsɑ yoou tɔtɔɣɔ kɔpɩ nɑ Pɛtǝlɛhɛm tʋ Yɑlii pǝyɑlʋ Ɩlɑnɑŋ kʋ Kɑtɩ tʋ Koliyɑtɩ wei ɩ ŋmɑntɑɑɣɑ kɑ wɛ ɩsɩɩ sɑɣɑtɑ kpɑtǝlɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("S221_20","011_21_20","2SA","21","20","20","Pɑ tɑsɑ yoou kɛ Kɑtɩ nɑ tooko nɔɣɔlʋ ɩ kɑ wɛ tǝnɑ nɑ ɩ mpee nɑ ɩ nɔmpee wɛ nɑɑtoso nɑɑtoso, pǝ kpɛntɑ hiu nɑ liɣiti. ");
INSERT INTO dop_vpl VALUES ("S221_21","011_21_21","2SA","21","21","21","Ḿpʋ́ɣʋ́ ɩ tʋʋ Ɩsɛɣɛlɩ nyǝ́mɑ, ɩlɛnɑ Tɑfiiti tɑɑlʋ Sɑmmɑ pǝyɑlʋ Sonɑtɑŋ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S221_22","011_21_22","2SA","21","22","22","Apɑlɑɑ mpɛ pɑɑ kɛ́ Kɑtɩ tookonɑɑ kɛ́. Tɑfiiti nɑ ɩ yoolɑɑ pɑ kʋnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("S222_1","011_22_1","2SA","22","1","1","Wɑɑtʋ wei Tɑcɑɑ yɑpɑ Tɑfiiti kɛ Sɑyuli nɑ ɩ kolontunɑɑ lɛlɑɑ niŋ tɑɑ tɔɣɔ Tɑfiiti sɑmɑ Ɩsɔ nɑ yontu sɩ: ");
INSERT INTO dop_vpl VALUES ("S222_2","011_22_2","2SA","22","2","2","Tɑcɑɑ kɛlɛ mɑ kʋkpɑmʋɣʋ nɑ mɑ tǝcɔɔsǝlɛ toŋ nyǝntɛ, nyɑ́ wɑɑsǝɣǝnɑ-m. ");
INSERT INTO dop_vpl VALUES ("S222_3","011_22_3","2SA","22","3","3","Nyɑɣɑlɛ mɑ Ɩsɔ nɑ mɑ́ cɔɔsǝɣǝnɑ-ŋ. Nyɑɣɑlɛ mɑ kpɑlʋɣʋ nɑ toŋ wei ɩ wɑɑsǝɣɩ-m tɔ. Nɑ mɑ tǝcɔɔsǝlɛ nte tǝ wɛ pʋɣʋ tɑɑ tɔ, nɑ mɑ kpʋlʋɣʋ tǝtʋlɛ. N kɛ́ mɑ wɑɑsʋlʋ, n yɑkɩ-m mʋsʋntʋnɑɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S222_4","011_22_4","2SA","22","4","4","Mɑ sɑmɑ Tɑcɑɑ nɑ kɑwilitɑɣɑ. Nyɑ́ yɑpǝnɑ-m kolontunɑɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S222_5","011_22_5","2SA","22","5","5","Sǝm tɑmɑ-m kɛ́ ɩsɩɩ lʋm sɔsɔɔm holɑ, nɑ pǝ́ nyɑɑsǝɣɩ-m ɩsɩɩ pusi sɔsɔɔnsɩ. ");
INSERT INTO dop_vpl VALUES ("S222_6","011_22_6","2SA","22","6","6","Atɛtǝlɛ kɑ hɔkɑ-m tǝ ŋmɩɩsɩ kɛ́. Nɑ sǝm nɑ́ɑ́ tuti-m nɑ pǝ puluɣu. ");
INSERT INTO dop_vpl VALUES ("S222_7","011_22_7","2SA","22","7","7","Mɑ yɑɑ Tɑcɑɑ kɛ mɑ lɑŋwɑkǝllɛ wɑɑtʋ sɩ ń wɑɑsɩ-m. Mɑ kiisɑɑ nɑ ń nɩɩ mɑ nɔɣɔ kɛ nyɑ́ tǝyɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S222_8","011_22_8","2SA","22","8","8","Pɑ́ɑ́nɑ́ kpɑ Ɩsɔ nɑ tɛtʋ sele, nɑ ɩsɔtɔnʋɣʋ kite ciɣiti, nɑ pɔɔŋ nɑ́ɑ́ sele ɩ kilɑ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S222_9","011_22_9","2SA","22","9","9","Kɔkɔ nyɔɔsɩ lɩɩnɑ Ɩsɔ nyɑ́ mɩɩnɑ tɛɛ, nɑ ń tɔ kɔkɔ mɑmɑlɑ nɑ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S222_10","011_22_10","2SA","22","10","10","N lumsɑ ɩsɔtɔnʋɣʋ nɑ ń tii, nɑ nyɑ́ nɔɔhɛɛ tɛɛ kɛ́ ɩsɔŋmʋntʋɣʋ kpɩɩsǝŋ nyǝŋkʋ. ");
INSERT INTO dop_vpl VALUES ("S222_11","011_22_11","2SA","22","11","11","Ɩsɔtɑɑ tɑŋlʋ kpɑɣɑnɑ-ŋ nɑ ń kʋlǝɣɩ hʋntʋ, nɑ heelim tɛɛkǝnɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S222_12","011_22_12","2SA","22","12","12","N tɑkɑ nyɑ́ tǝɣɩ sǝkpɛtʋɣʋ, nɑ ŋ wɛ tɛʋ ŋmʋntʋɣʋ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S222_13","011_22_13","2SA","22","13","13","Nyɑ́ nyɑlɑmǝlɛ tɛɛ-ŋ nɔɣɔ nɑ tǝ tɔɔkɩ mɑmɑcǝɣǝlɑsɩ. ");
INSERT INTO dop_vpl VALUES ("S222_14","011_22_14","2SA","22","14","14","Ɩsɔtɑɑ Ɩsɔ Sɔsɔ nɔɣɔ nɩɩ ɩsɔtɑɑ kɛ́ ɩsɩɩ tɛʋ holɑ. ");
INSERT INTO dop_vpl VALUES ("S222_15","011_22_15","2SA","22","15","15","N tɔ mɑ kolontunɑɑ kɛ nyǝmɑ́ nɑ ń yɑsɩ-wɛ. N tisɑ pɑ tɔɔ kɛ́ cɑlɑnɑɑ nɑ pɑ́ se yem yem. ");
INSERT INTO dop_vpl VALUES ("S222_16","011_22_16","2SA","22","16","16","Tɑcɑɑ ń mʋ pɑ́ɑ́nɑ́ nɑ ń woso nyɑ́ mɩɩnɑ tɛɛ, nɑ teŋku tɛtʋ nyɩɩ nɑ pǝ́ nɑ́ ɑntulinyɑ kite. ");
INSERT INTO dop_vpl VALUES ("S222_17","011_22_17","2SA","22","17","17","Ɩlɛnɑ ń tisi nyɑ́ niŋ nɑ ɩsɔtɑɑ nɑ ń lǝsɩ-m lʋm sɔsɔɔm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S222_18","011_22_18","2SA","22","18","18","Nɑ ń yɑ-m kolontunɑɑ toŋ nyǝ́mɑ mpɑ ɩnɩ pɑ tɛɛ-m tɔ pɑ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S222_19","011_22_19","2SA","22","19","19","Mɑ wɑhɑlɑ wule kɛ pɑ tutɑ-m. Ɩlɛnɑ Tɑcɑɑ wɑɑsɩ-m. ");
INSERT INTO dop_vpl VALUES ("S222_20","011_22_20","2SA","22","20","20","N sɔɔlɑ-m tɔɣɔ n wɑɑsɑ-m sɩ mɑ́ cɑɣɑnɑ mɑ tɩ. ");
INSERT INTO dop_vpl VALUES ("S222_21","011_22_21","2SA","22","21","21","Mɑ tǝŋɑ tɑmpɑnɑ tɔɣɔ n lɑpɑ-m mpʋ, mɑ kʋsiɣisim lɑpʋ kɑsǝyɑɣɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("S222_22","011_22_22","2SA","22","22","22","Mɑ tǝŋɑ Tɑcɑɑ tɔm kɛ́, mɑ tɑ wɑkǝlǝnɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("S222_23","011_22_23","2SA","22","23","23","Mɑ tǝŋɑ nyɑ́ kʋsǝsɩɩtʋ tɔɣɔ. Mɑ tɑ yɔkɩ nyɑ́ kiiu nɑkʋlɩ. ");
INSERT INTO dop_vpl VALUES ("S222_24","011_22_24","2SA","22","24","24","Mɑ luɣu fɛɩ tɑɑlɩ nɔɣɔlʋ, tɔɣɔ mɑ kpɑ mɑ tǝɣɩ ɩsɑɣɑtʋ tǝlɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S222_25","011_22_25","2SA","22","25","25","Ɩlɛnɑ Tɑcɑɑ fɛlɩ-m mɑ tɑmpɑnɑ tǝŋʋɣʋ tɔɔ. Mɑ kʋsiɣisim lɑpʋ kɑsǝyɑɣɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("S222_26","011_22_26","2SA","22","26","26","Kʋpɑntʋ kɛ Tɑcɑɑ n fɛlǝɣɩ tǝ lɑtʋ, nɑ ń tǝŋ tɑmpɑnɑ nɑ ń lɑnɑ ɑ tǝŋlʋ. ");
INSERT INTO dop_vpl VALUES ("S222_27","011_22_27","2SA","22","27","27","Yʋlʋ ɩ́ wɛ tǝnɑŋŋ ḿpʋ́ɣʋ́ n lɑkɩ-ɩ, ɩlɛnɑ ń kisi ɩsɑɣɑʋ. ");
INSERT INTO dop_vpl VALUES ("S222_28","011_22_28","2SA","22","28","28","N wɑɑsǝɣɩ tǝpɑsǝlɑɑ, ɩlɛnɑ ń tisiɣi kɑlɑmpɑɑnɩ nyǝ́mɑ nɑ ɩsɛ cɩɩlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S222_29","011_22_29","2SA","22","29","29","Tɑcɑɑ kɛlɛ mɑ nyɑɑlǝm, nɑ ń kɛɛlǝɣɩ mɑ sǝkpɛtʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S222_30","011_22_30","2SA","22","30","30","Nyɑ́ toŋ kɛ mɑ ŋmɑɑkǝnɑ kolontunɑɑ koloosi nɑ mɑ́ sʋʋkɩ. ");
INSERT INTO dop_vpl VALUES ("S222_31","011_22_31","2SA","22","31","31","Tɑcɑɑ nyɑ́ kʋlɑpʋtʋ wɛ kɛ́ tǝcʋŋŋ, nɑ nyɑ́ kʋyɔɣɔtʋtʋ fɛɩ sikɑ. N kentiɣi mpɑ pɑ cɔɔsǝɣǝnɑ-ŋ tɔ ɩsɩɩ kpɑ́lʋ́ɣʋ́. ");
INSERT INTO dop_vpl VALUES ("S222_32","011_22_32","2SA","22","32","32","Tɑcɑɑ nyɑ́ tike tǝkoŋ ntɛ́ Ɩsɔ. Tɑ Ɩsɔ tike tǝkoŋ ntɛ́ kʋkpɑmʋɣʋ ŋku kʋ kentiɣi-tʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("S222_33","011_22_33","2SA","22","33","33","Nyɑɣɑlɛ mɑ koluŋɑ ɩcɑtɛ toŋ nyǝŋkɑ. Nɑ ń tiikiɣi-m mpɑɑʋ kʋsiɣisuɣu tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S222_34","011_22_34","2SA","22","34","34","Nɑ ń yeki nɑ mɑ́ pǝsǝɣɩ sewɑ kɛ pulɑsɩ tɔɔ ɩsɩɩ nɑm nɑ nɑɑni. ");
INSERT INTO dop_vpl VALUES ("S222_35","011_22_35","2SA","22","35","35","N fɑlǝsɑ mɑ niŋ nɑ yoou, nɑ mɑ́ nyɩ tɔɔʋ toŋ nyǝŋkʋ tɔʋ. ");
INSERT INTO dop_vpl VALUES ("S222_36","011_22_36","2SA","22","36","36","N yɑpɑ mɑ nyʋɣʋ nɑ pǝ́ wɛɛ ɩsɩɩ kʋkentuɣu. Nɑ mɑ pǝsɩ sɔsɔ kɛ nyɑ́ kʋpɑntʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S222_37","011_22_37","2SA","22","37","37","Nyɑ́ hɑsǝɣǝnɑ mɑ nɔɔhɛɛ tɛɛ. Pʋlʋpʋ ɩɩ tuuliɣi-m. ");
INSERT INTO dop_vpl VALUES ("S222_38","011_22_38","2SA","22","38","38","Mɑ tɔɣɔnǝɣɩ mɑ kolontunɑɑ nɑ mɑ́ wɑkǝlǝɣɩ-wɛ. Ye mɑ tɑ kpiisi-wɛ mɑɑ mǝlǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("S222_39","011_22_39","2SA","22","39","39","Mɑ wɑkǝlǝɣɩ-wɛɣɛ nɑ mɑ́ kpiisi-wɛ, nɑ pɑ́ wɛɛ mɑ nɔɔhɛɛ tɛɛ, pɑɑ tɑsǝɣɩ kʋlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S222_40","011_22_40","2SA","22","40","40","Nyɑ́ hɑɑkǝnɑ-m yoou toŋ, nɑ ń yeki nɑ mɑ kolontunɑɑ hǝntǝɣɩ-m ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S222_41","011_22_41","2SA","22","41","41","N yeki nɑ pɑ́ seeki-m, nɑ mɑ́ wɑkǝlǝɣɩ-wɛ tǝnɑŋnɑŋ. ");
INSERT INTO dop_vpl VALUES ("S222_42","011_22_42","2SA","22","42","42","Pɑ cɑɑkɩ pɑ tɑɑ nɑ pɑ wɑɑlɩ pɑɑ nɑɑ wɑɑsʋlʋ. Ɩlɛnɑ pɑ wiinɑ Tɑcɑɑ nɑ ɩ́lɛ́ ɩ kisi cɔʋ. ");
INSERT INTO dop_vpl VALUES ("S222_43","011_22_43","2SA","22","43","43","Mɑ nuɣutiɣi-wɛ nɑ pɑ́ pǝsɩ mʋsʋɣʋ. Nɑ mɑ́ fɛlɩ-wɛ nɑ pɑ́ pǝsɩ ɩsɩɩ mpɑɑʋ ɑfǝlɑ. ");
INSERT INTO dop_vpl VALUES ("S222_44","011_22_44","2SA","22","44","44","N yɑpɑ-m mɑ yǝlɑɑ nɔɔhɔntɛ tɑɑ, nɑ ń sɩɩ-m kɑteŋɑsɩ yǝlɑɑ nyʋɣʋ tʋ. Yǝlɑɑ mpɑ mɑ tɑɑ nyɩ tɔ pɑ lɑpɑ-m tǝmlɛ. ");
INSERT INTO dop_vpl VALUES ("S222_45","011_22_45","2SA","22","45","45","Kpɑɩ nyǝ́mɑ piyɑ seekinɑ-m, nɑ mɑ́ nyǝnɑ-wɛɣɛ ɩsǝlɛ pɑ nɩɩkɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S222_46","011_22_46","2SA","22","46","46","Pɑ nɑntʋ tiliɣi kɛ́, nɑ pɑ́ lɩɩkǝnɑ pɑ tǝŋmɛllɛ nɑ seluɣu. ");
INSERT INTO dop_vpl VALUES ("S222_47","011_22_47","2SA","22","47","47","Tɑcɑɑ wɛnnɑ. Nyɑɣɑlɛ mɑ kʋkpɑmʋɣʋ ŋku kʋ kentiɣi-m tɔ mɑɑ sɑ-ŋ. Mɑ tɑlɑ mɑ Ɩsɔ mɑ wɑɑsʋlʋ. ");
INSERT INTO dop_vpl VALUES ("S222_48","011_22_48","2SA","22","48","48","Nyɑ́ lɛɛtǝɣǝnɑ nɑ mɑ nɔɣɔ. Nɑ ń tisiɣi piitimnɑɑ kɛ mɑ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("S222_49","011_22_49","2SA","22","49","49","Nyɑ́ fitiɣinɑ-m mɑ kolontunɑɑ niŋ tɑɑ, nɑ ń lɑkɩ nɑ mɑ́ kǝlǝɣɩ-wɛ, nɑ ń yɑkɩ-m mʋsʋŋtʋ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S222_50","011_22_50","2SA","22","50","50","Pǝ tɔɔ kɛ́ mɑɑ sɑ-ŋ piitimnɑɑ tɑɑ nɑ mɑ́ pʋɣʋlɩ nyɑ́ hǝtɛ. ");
INSERT INTO dop_vpl VALUES ("S222_51","011_22_51","2SA","22","51","51","N tʋɣɩ nyɑ́ wulɑʋ kɛ ɑkɑɩtʋ sɔsɔɔntʋ. Nɑ ń lɑ kʋpɑntʋ kɛ nyɑ́ kʋlǝsʋ nɑ Tɑfiiti, nɑ ɩ́lɛ́ ɩ piitim nyǝ́mɑ kɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S223_1","011_23_1","2SA","23","1","1","Yontu nti Tɑfiiti tǝkǝnɑ yoou tɔɣɔlɔ: Ɩ́ nɩɩ Sesee pǝyɑlʋ Tɑfiiti nɔɣɔ. Tɑcɑɑ kʋsǝnɑ mɑ nyʋɣʋ. Yɑkɔpʋ Ɩsɔ lǝsǝnɑ-m nɑ ɩ́ kpɑ-m wulɑʋ. Mɑɣɑlɛ Ɩsɛɣɛlɩ yǝlɑɑ yonyoolu kʋpɑŋ. ");
INSERT INTO dop_vpl VALUES ("S223_2","011_23_2","2SA","23","2","2","Tɑcɑɑ Feesuɣu tʋwɑ kʋ tɔm kɛ mɑ tɑɑ nɑ mɑ yɔɣɔtǝnɑ kʋ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("S223_3","011_23_3","2SA","23","3","3","Ɩsɛɣɛlɩ Ɩsɔ yɔɣɔtɑɑ. Ɩsɛɣɛlɩ nyǝ́mɑ kentulu nyɑ́ nyɑ́ heelinɑ sɩ: Wulɑʋ wei ɩ tǝŋǝɣɩ tɑmpɑnɑ nɑ ɩ́ tɔkɩ yǝlɑɑ tɔɔ kɛ́ kɑwulɑɣɑ nɑ Ɩsɔ sɔɣɔntʋ tɔ, ");
INSERT INTO dop_vpl VALUES ("S223_4","011_23_4","2SA","23","4","4","ɩ wɛ teitei kɛ ɩsɩɩ ɩsɔtɔnʋɣʋ cɛkʋɣʋ tɑnɑŋ nɑ ilim lɩɩ tǝyɛɩyɛɩ tɔ. Nɑ pǝ́ lɑkɩ nɑ kʋnyɔnyɔm nyɔɔkɩ tɛʋ nɩɩʋ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("S223_5","011_23_5","2SA","23","5","5","Ḿpʋ́ɣʋ́ Ɩsɔ n koolɑ mɑ tǝyɑɣɑ kɛ kʋpɑntʋ. Mɑ nɑ-ŋ tǝ pɛɛlɑ tɑm tɔɔ nɔɣɔ kɛ́, nɑ ń tɑɣɑnɩ-kɛɣɛ teu nɑ ń nyǝ́mɑ́ kɑ tɔɔ. N kɑ yɑ mɑ nyʋɣʋ nɑ ń lɑ-m kʋpɑntʋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("S223_6","011_23_6","2SA","23","6","6","Amɑ Ɩsɔ nyɑ́ footilɑɑ nɑ́ wɛ ɩsɩɩ sɔwɑ kʋlɔlɔnɑ kɛ́. Pɑɑ tokiɣinɑ-yɛɣɛ niŋ kpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("S223_7","011_23_7","2SA","23","7","7","Kpɑ́tʋ́ɣʋ́ yɑɑ ŋmɑntɑɑɣɑ kɛ pɑ kpɑkǝɣǝnɑ-yɛ nɑ pɑ́ wɔ-yɛɣɛ kɔkɔ kɛ ɑ lonte tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S223_8","011_23_8","2SA","23","8","8","Tɑfiiti yoolɑɑ sɔsɑɑ mpɑ pɑ lɑkɑɣɑ ɩ tǝmlɛ tɔ pɑ hǝlɑ ntɔ. Ɩ yoolɑɑ sɔsɑɑ tooso tɑɑ sɔsɔ ntɛ́ Hɑkǝmoni tʋ Ɩsǝpɑɑlɩ. Ɩnɩ ɩ kʋnɑ yoou kʋlʋmʋɣʋ tɑɑ kɛ́ yoolɑɑ nɑsǝnɑɑsɑ (800). ");
INSERT INTO dop_vpl VALUES ("S223_9","011_23_9","2SA","23","9","9","Ɩsǝpɑɑlɩ wɑɑlɩ kɛ́ Tooto pǝyɑlʋ Ahowɑ sɑɑlɩ Ɩliyɑsɑɑ. Ɩsɛɣɛlɩ yǝlɑɑ tooso wei nɑ Tɑfiiti pɑɑ tɑmɑ Filiisi nyǝ́mɑ nɑ pɑ́ yoonɑ-wɛ nɑ Ɩsɛɣɛlɩ yoolɑɑ nɑ́ɑ́ seeki kʋlʋm kʋlʋm tɔ pɑ tɑɑ lɛlʋ. ");
INSERT INTO dop_vpl VALUES ("S223_10","011_23_10","2SA","23","10","10","Ɩliyɑsɑɑ kʋ Filiisi nyǝ́mɑ kɛ kʋyɑkʋ nɑkʋlǝɣɩ kɑtɑtǝlɑɣɑ kɛ́, hɑlǝnɑ ɩ niŋ nyɔkǝlǝnɑ lɑɣɑtɛ. Kʋyɑkʋ ŋkʋɣʋ Tɑcɑɑ yɑpɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ teu nɑ ɑpɑlʋ ɩnɩ ɩ nɔɣɔ. Hɑlǝnɑ Ɩsɛɣɛlɩ yoolɑɑ tǝŋǝɣɩ ɩ wɑɑlɩ nɑ pɑ́ tɔɔsǝɣɩ sǝtɑɑ yoou wontu. ");
INSERT INTO dop_vpl VALUES ("S223_11","011_23_11","2SA","23","11","11","Ɩliyɑsɑɑ wɑɑlɩ kɛ́ Hɑlɑɑ tʋ Akee pǝyɑlʋ Sɑmmɑ. Ḿpʋ́ɣʋ́ Filiisi nyǝ́mɑ kotɑ timpi pɑ yɑɑ sɩ Lehii tɔ sɩ pɑ yoonɑ Ɩsɛɣɛlɩ nyǝ́mɑ, ɩlɛnɑ pɛlɛ pɑ se. ");
INSERT INTO dop_vpl VALUES ("S223_12","011_23_12","2SA","23","12","12","Amɑ Sɑmmɑ sʋʋ soonɑ nɑɑlɩ ɑ tɑɑlɛ tɑɑ kɛ́ tǝnɑ nɑ ɩ́ yoonɑ Filiisi nyǝ́mɑ nɑ ɩ́ kʋ-wɛ nɑ Tɑcɑɑ yɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ teu. ");
INSERT INTO dop_vpl VALUES ("S223_13","011_23_13","2SA","23","13","13","Ḿpʋ́ɣʋ́ yoolɑɑ hiu nɑ nɑɑnʋwɑ wei ɩ tǝŋɑɣɑ Tɑfiiti tɔ pɑ tɑɑ tooso polɑ ɩ kiŋ kɛ Atulɑm kʋkpɑmʋɣʋ pʋ́ʋ́ɣʋ́ tɑɑ kɛ kʋmtʋ wɑɑtʋ. Nɑ Filiisi yoolɑɑ nɑ́ɑ́ sikɑ Lefɑyi nyǝ́mɑ tɛtɛkǝlɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("S223_14","011_23_14","2SA","23","14","14","Nɑ Tɑfiiti nɑ́ɑ́ wɛ koluŋɑ ɩcɑtɛ tɑɑ nɑ Filiisi yoolɑɑ nɑ́ɑ́ sikɑ Pɛtǝlɛhɛm. ");
INSERT INTO dop_vpl VALUES ("S223_15","011_23_15","2SA","23","15","15","Mpʋɣʋlɛ Tɑfiiti tɔmɑ sɩ: Mɑ nyɩɩlɑ Pɛtǝlɛhɛm ɩcɑtɛ nɔnɔɣɔ hite tɑɑ lʋm kɛ́ ɩsɩɩ yem nɑ kpɛtɛ. ");
INSERT INTO dop_vpl VALUES ("S223_16","011_23_16","2SA","23","16","16","Tǝnɑɣɑlɛ yoolɑɑ sɔsɑɑ tooso ɩnɩ pɑ fɑɣɑnɑ Filiisi nyǝ́mɑ tǝsikile nɑ pɑ́ lu Pɛtǝlɛhɛm hite ńtɛ́ tǝ tɑɑ lʋm nɑ pɑ́ ponɑ Tɑfiiti. Amɑ ɩ kisɑ pǝ nyɔɔʋ nɑ ɩ́ mǝlǝnɑ-wɩ nɑ ɩ́ liisi Tɑcɑɑ. ");
INSERT INTO dop_vpl VALUES ("S223_17","011_23_17","2SA","23","17","17","Ɩlɛnɑ ɩ́ tɔ sɩ: Hɑɩ, Tɑcɑɑ, pǝ fɛɩ sɩ mɑ́ nyɔɔ lʋm pǝnɛ. Mpi tɔ, pǝ wɛ ɩsɩɩ yoolɑɑ pɑnɛ pɑ cɑlǝm kɛ́. Pɑ weesiŋ kɛ pɑ lɑpɑ ɑwusɑ. Ɩlɛnɑ Tɑfiiti kisi lʋm mpɩ pǝ nyɔɔʋ. Tǝmlɛ sɔsɔɔlɛ nte yoolɑɑ tooso ɩnɩ ɩ lɑpɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S223_18","011_23_18","2SA","23","18","18","Sowɑpɩ neu Apisɑyi kɛlɛ yoolɑɑ hiu nɑ nɑɑnʋwɑ ɩnɩ ɩ tɑɑ nyʋɣʋ tʋ. Ɩnɩ ɩ kʋnɑ kolontunɑɑ ŋmʋnʋɣʋ nɩɩnʋwɑ (300) nɑ ŋmɑntɑɑɣɑ, ɩlɛnɑ ɩ nyʋɣʋ kʋlɩ. ");
INSERT INTO dop_vpl VALUES ("S223_19","011_23_19","2SA","23","19","19","Ɩnɩ ɩ kɑ tɛɛnɑ pɑ hiu nɑ nɑɑnʋwɑ tɑɑ hɑlɩ ɩ lɑ pɑ nyʋɣʋ tʋ. Pɑɑ nɑ mpʋ ɩ tɑ tɑlɑ kɑncɑɑlɑɣɑ yoolɑɑ tooso. ");
INSERT INTO dop_vpl VALUES ("S223_20","011_23_20","2SA","23","20","20","Ḿpʋ́ɣʋ́ Kɑpǝseli tʋ Yoyɑtɑ pǝyɑlʋ Penɑyɑ, ɑpɑlʋ ɩnɩ ɩ nyʋɣʋ kɑ kʋlɑ ɩ kookɑlǝnɑɑ tɔɔ kɛ́. Ɩnɩ ɩ kɑ kʋnɑ Mowɑpʋ yoolɑɑ sɔsɑɑ nɑɑlɛ. Kʋyɑkʋ lɛŋkʋ ɩ tii hite tɑɑ nɑ ɩ́ kʋ tɔɣɔlɑɣɑ kɛ wɑtʋ wɑɑtʋ. ");
INSERT INTO dop_vpl VALUES ("S223_21","011_23_21","2SA","23","21","21","Kʋyɑkʋ nɑkʋlɩ ɩ nɑ Icipiti yoolu tooko nɔɣɔlʋ pɑ sulinɑ nɑ ɩnɩ ɩ́ tɔkɑ kpɑ́tʋ́ɣʋ́ nɑ ɩlɛɣɛ ŋmɑntɑɑɣɑ. Ḿpʋ́ɣʋ́ ɩ lɛɛkɑ tooko ɩnɩ ɩ ŋmɑntɑɑɣɑ nɑ ɩ́ kʋnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("S223_22","011_23_22","2SA","23","22","22","Mpi Penɑyɑ lɑpɑ nɑ ɩ nyʋɣʋ kʋlɩ yǝlɑɑ tooso ɩnɩ ɩ tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("S223_23","011_23_23","2SA","23","23","23","Ɩnɩ ɩ tɛɛnɑ pɑ hiu nɑ nɑɑnʋwɑ ɩnɩ. Amɑ ɩ tɑ tɑlɑ tooso kɑncɑɑlɑɣɑ nyǝŋ kɛ́. Ḿpʋ́ɣʋ́ Tɑfiiti kpɑ-ɩ ɩ tɑŋlɑɑ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("S223_24","011_23_24","2SA","23","24","24","Yoolɑɑ sɔsɑɑ hiu nɑ nɑɑnʋwɑ tɑɑ lɛlɑɑ ntɛ́ Sowɑpɩ neu Asɑyɛɛlɩ, nɑ Pɛtǝlɛhɛm tʋ Tooto pǝyɑlʋ Ɩlɑnɑŋ, ");
INSERT INTO dop_vpl VALUES ("S223_25","011_23_25","2SA","23","25","25","nɑ Hɑlotɩ nyǝ́mɑ Sɑmmɑ nɑ Ɩlikɑ, ");
INSERT INTO dop_vpl VALUES ("S223_26","011_23_26","2SA","23","26","26","nɑ Pelɛtɩ tʋ Helɛsɩ, nɑ Tekʋwɑ tʋ Ɩkɛsɩ pǝyɑlʋ Ɩlɑ, ");
INSERT INTO dop_vpl VALUES ("S223_27","011_23_27","2SA","23","27","27","nɑ Anɑtɔtɩ tʋ Apiyesɛɛ, nɑ Husɑ tʋ Mepunɑyi, ");
INSERT INTO dop_vpl VALUES ("S223_28","011_23_28","2SA","23","28","28","nɑ Ahowɑ tʋ Sɑlʋmɔŋ, nɑ Netofɑ tʋ Mɑlɑyi, ");
INSERT INTO dop_vpl VALUES ("S223_29","011_23_29","2SA","23","29","29","nɑ Netofɑ tʋ Pɑɑnɑ pǝyɑlʋ Helɛpɩ, nɑ Pɛncɑmɛɛ tʋ Lipɑyi pǝyɑlʋ Ɩtɑyi kɛ Kipeyɑ, ");
INSERT INTO dop_vpl VALUES ("S223_30","011_23_30","2SA","23","30","30","nɑ Pilɑtɔŋ tʋ Penɑyɑ, nɑ Hitɑyi kɛ Kɑɑsɩ lɔɔʋ nɔɣɔ ");
INSERT INTO dop_vpl VALUES ("S223_31","011_23_31","2SA","23","31","31","nɑ Pɛtɩ-Alɑpɑ tʋ Apiyɑlǝpɔŋ, nɑ Pɑhulim tʋ Asǝmɑfɛtɩ, ");
INSERT INTO dop_vpl VALUES ("S223_32","011_23_32","2SA","23","32","32","nɑ Sɑɑlǝpɔŋ tʋ Ɩliyɑpɑ, nɑ Yɑsɛɛ pǝyɑlʋ lɛlʋ Yonɑtɑŋ, ");
INSERT INTO dop_vpl VALUES ("S223_33","011_23_33","2SA","23","33","33","nɑ Hɑlɑɑ tʋ Sɑmmɑ nɑ Hɑlɑɑ tʋ Sɑlɑɑ pǝyɑlʋ Ahiyɑm, ");
INSERT INTO dop_vpl VALUES ("S223_34","011_23_34","2SA","23","34","34","nɑ Mɑkɑtɩ tʋ Ahɑsǝpɑyi pǝyɑlʋ Ɩlifɛlɛtɩ, nɑ Kilo tʋ Ahitofɛlɩ pǝyɑlʋ Ɩliyɑm, ");
INSERT INTO dop_vpl VALUES ("S223_35","011_23_35","2SA","23","35","35","nɑ Kɑmɛɛlɩ tʋ Hɛsǝlɑyi, nɑ Alɑpʋ tʋ Pɑɑlɑyi, ");
INSERT INTO dop_vpl VALUES ("S223_36","011_23_36","2SA","23","36","36","nɑ Sopɑ tʋ Nɑtɑŋ pǝyɑlʋ Ikɑɑlɩ, nɑ Kɑtɩ tʋ Pɑni, ");
INSERT INTO dop_vpl VALUES ("S223_37","011_23_37","2SA","23","37","37","nɑ Amoni tʋ Selɛkɩ, nɑ Pelɔtɩ tʋ Nɑlɑyi mpɑ pɑ tɔkɑɣɑ Sowɑpɩ yoou wontu tɔ, ");
INSERT INTO dop_vpl VALUES ("S223_38","011_23_38","2SA","23","38","38","nɑ Yetɛɛ nyǝ́mɑ Ɩlɑ nɑ Kɑlɛpʋ, ");
INSERT INTO dop_vpl VALUES ("S223_39","011_23_39","2SA","23","39","39","nɑ Hiti tʋ Yulii. Tɑfiiti yoolɑɑ sɔsɑɑ tǝnɑ kpɛntɑ yǝlɑɑ hiu nɑ nɑɑnʋwɑ nɑ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S224_1","011_24_1","2SA","24","1","1","Ḿpʋ́ɣʋ́ Tɑcɑɑ pɑ́ɑ́nɑ́ tɑsɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ huunɑʋ, nɑ ɩ́ tʋ́ Tɑfiiti tɑɑ sɩ ɩ́ kɑlɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ Yutɑ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S224_2","011_24_2","2SA","24","2","2","Ɩlɛnɑ Tɑfiiti tɔ ɩ yoou wulɑʋ Sowɑpɩ sɩ: Cɔɔ Ɩsɛɣɛlɩ kpekɑ tǝnɑ kɛ pǝ kpɑɣɑʋ Tɑŋ nɑ pǝ́ polo Pɛɛsepɑ tɔ nɑ ń kɑlɑ yǝlɑɑ nɑ mɑ́ nyɩ pɑ nyʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S224_3","011_24_3","2SA","24","3","3","Mpʋɣʋlɛ Sowɑpɩ sɩ: Tɑcɑɑ ɩ́ lɑ nɑ Ɩsɛɣɛlɩ yǝlɑɑ huki tɔm nɩɩnʋwɑ (100) nɑ ń nɑ́. Ɩlɛ pepe tɔɔ kɛ́ n tɩɩ kɑlǝɣɩ yǝlɑɑ? ");
INSERT INTO dop_vpl VALUES ("S224_4","011_24_4","2SA","24","4","4","Ntɛnɑ wulɑʋ sɩ: Sowɑpɩ ɩ́ kɑlɑ kɛ ɩ́ kɑlɑ. Ɩlɛnɑ Sowɑpɩ polo nɑ ɩ́ kɑlɑ Ɩsɛɣɛlɩ yǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("S224_5","011_24_5","2SA","24","5","5","Ḿpʋ́ɣʋ́ ɩ tɛsɑ Yɑɑtɑnɩ nɑ ɩ́ polo ɩ siki timpi pɑ yɑɑ sɩ Alʋwɛɛ tɔɣɔ ɩcɑtɛ nte tǝ wɛ Kɑtɩ tɛtɛkǝlɛ tɑɑ tɔ tǝ ntɔɣɔŋ tɔɔ kɛ Yɑsɛɛ cɔlɔ. ");
INSERT INTO dop_vpl VALUES ("S224_6","011_24_6","2SA","24","6","6","Ḿpʋ́ɣʋ́ pɑ polɑ Kɑlɑɑtɩ tɛtʋ tɑɑ nɑ pɑ́ polo Hiti nyǝ́mɑ tɛtʋ tɑɑ nɑ Kɑtɛɛsɩ nɑ Tɑŋ-Yɑɑŋ kɛ Sitɔŋ cɔlɔ, ");
INSERT INTO dop_vpl VALUES ("S224_7","011_24_7","2SA","24","7","7","nɑ pɑ́ polo Tiii koluŋɑ ɩcɑtɛ tɑɑ nɑ Hifi nyǝ́mɑ nɑ Kɑnɑɑŋ nyǝ́mɑ pɑ ɑcɑlɛɛ tɑɑ nɑ pɑ́ tɛɛsǝnɑ Yutɑ ilim tǝtʋlɛ ntɔɣɔŋ tɔɔ kɛ́ Pɛɛsepɑ. ");
INSERT INTO dop_vpl VALUES ("S224_8","011_24_8","2SA","24","8","8","Ḿpʋ́ɣʋ́ pɑ cɔɔ tɛtʋ tǝnɑ nɑ pɑ́ mǝlɩ Yosɑlɛm. Ɩlɛ pǝ yoosɑ ɩsɔtʋnɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ, nɑ kʋyɛɛŋ hiu. ");
INSERT INTO dop_vpl VALUES ("S224_9","011_24_9","2SA","24","9","9","Ɩlɛnɑ Sowɑpɩ heeli wulɑʋ sɩ: Ɩsɛɣɛlɩ yoolɑɑ wɛ yǝlɑɑ iyisi nɑsǝnɑɑsɑ (800000) nɑ Yutɑ nyǝ́mɑ kɛ yoolɑɑ iyisi nɑsǝlɛ nɑ nɩɩnʋwɑ (500000). ");
INSERT INTO dop_vpl VALUES ("S224_10","011_24_10","2SA","24","10","10","Tɑfiiti tɛmɑ kʋkɑlʋɣʋ ŋkʋ ɩlɛ ɩ lɑŋlɛ wɑkǝlɑɑ kɛlɛ nɑ ɩ́ tɔ sɩ: Tɑcɑɑ, mɑ lɑpɑ mpʋ tɔ mɑ wɑkǝlɑɑ kɛ́, ɩlɛ wii-m mɑ ɩsɑɣɑtʋ ntɩ. Mɑ lɑpɑ kʋmɛlɛntʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("S224_11","011_24_11","2SA","24","11","11","Ḿpʋ́ɣʋ́ Tɑcɑɑ heelɑ Tɑfiiti lɑɣɑtʋ tɑsǝlʋ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Kɑtɩ sɩ: ");
INSERT INTO dop_vpl VALUES ("S224_12","011_24_12","2SA","24","12","13","Polo ń heeli Tɑfiiti sɩ mɑ sɩɩ wɑhɑlɑnɑɑ tooso sɩ ɩ́ lǝsɩ wei ɩ sɔɔlɑɑ tɔ. Nyɔɣɔsɩ ɩ́ lɩɩ-ɩ pɩɩsɩ nɑɑtosompɔɣɔlɑɣɑ, yɑɑ ɩ́ se ɩ kolontunɑɑ kɛ ɩsɔtʋnɑɑ tooso, yɑɑ yʋlʋkʋsǝkʋ ɩ́ lɩɩnɑ kʋyɛɛŋ tooso? Wulɑʋ ɩ́ cɔ-m nɑ mɑ́ heeli Tɑcɑɑ. Tɑfiiti femɑ tɑnɑŋ tɛɛ ɩlɛnɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ kɔɔ. ");
INSERT INTO dop_vpl VALUES ("S224_14","011_24_14","2SA","24","14","14","Ntɛnɑ Tɑfiiti cɔ-ɩ sɩ: Mɑ lɑŋlɛ pǝsɑɑ kɛ́. Ɩlɛ Tɑcɑɑ kɛ tǝ pɛtɑ tɑ tɩ. Sɑnɑ ɩnɩ ɩ́ hɔ tɑ ŋkpɑŋŋ nɑ mpi yʋlʋ kɑ hɔmɩ-ɩ tɔ. Mpi tɔ, Tɑcɑɑ pǝtɔɔtǝlɛ tɔɔwɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("S224_15","011_24_15","2SA","24","15","15","Ḿpʋ́ɣʋ́ Tɑcɑɑ yelɑɑ nɑ yʋlʋkʋsǝkʋ sʋʋ Ɩsɛɣɛlɩ tɑɑ kɛ́ hɑtoo tɑnɑŋ tɛɛ nɑ pǝ́ polo wɑɑtʋ wei ɩ sɩɩwɑ tɔɣɔ pǝ kpɑɣɑʋ Tɑŋ nɑ pǝ́ polo Pɛɛsepɑ tɔ, nɑ yǝlɑɑ iyisi nɩɩtoso nɑ nɑɑnʋwɑ (70000) sɩ. ");
INSERT INTO dop_vpl VALUES ("S224_16","011_24_16","2SA","24","16","16","Ɩsɔtɑɑ tillu tiikɑɣɑ Yosɑlɛm ɩcɑtɛ tɔɔ sɩ ɩ wɑkǝlǝɣɩ-tɛ, ɩlɛnɑ Tɑcɑɑ yele ɩ pɑ́ɑ́nɑ́ nɑ ɩ́ heeli-ɩ sɩ: Yele mpʋ, pǝ mɑɣɑnɑɑ. Wɑɑtʋ ɩnɩ tɔ nɑ ɩsɔtɑɑ tillu wɛ Yepusi tʋ Alɑfǝnɑ tǝfɑllɛ. ");
INSERT INTO dop_vpl VALUES ("S224_17","011_24_17","2SA","24","17","17","Tɑfiiti nɑwɑ ɩsɔtɑɑ tillu nɑ ɩ́ kʋɣɩ yǝlɑɑ ɩlɛnɑ ɩ́ tɔ Tɑcɑɑ sɩ: Hɑɩ, mɑ́ wɑkǝlǝnɑ, yǝlɑɑ mpɛ pɑ tɑ lɑ pʋlʋ. Kʋ mɑ́ nɑ mɑ cɑɑ tǝyɑɣɑ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("S224_18","011_24_18","2SA","24","18","18","Ḿpʋ́ɣʋ́ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ polɑ Tɑfiiti kiŋ kɛ kʋyɑkʋ ŋkʋ nɑ ɩ́ tɔmɩ-ɩ sɩ: Polo Alɑfǝnɑ tǝfɑllɛ nɑ ń ŋmɑ́ Tɑcɑɑ kɛ kɔtɑɣɑ tǝlɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S224_19","011_24_19","2SA","24","19","19","Ɩlɛnɑ Tɑfiiti polo ɩsɩɩ Tɑcɑɑ heeluɣu-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("S224_20","011_24_20","2SA","24","20","20","Ḿpʋ́ɣʋ́ Alɑfǝnɑ lɩɩwɑ nɑ ɩ́ loosi wulɑʋ nɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ pɑ́ puki ɩ tɛ, ɩlɛnɑ ɩ́ polo nɑ ɩ́ hǝntɩ-ɩ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("S224_21","011_24_21","2SA","24","21","21","Ɩlɛnɑ ɩ́ pɔɔsɩ wulɑʋ sɩ: Hɑɩ, tɑ́ cɑɑ, ɑlɑɑfǝyɑ kɛlɛ? Kɛlɛnɑ wulɑʋ sɩ: Mɑ kɔŋ kɛ́ sɩ mɑ yɑkɩ nyɑ́ tǝfɑllɛ nɑ mɑ́ ŋmɑ́ Tɑcɑɑ kɛ kɔtɑɣɑ tǝlɑtɛ nɑ mpusi ɩnɛ ɩ́ kɛɛlɩ yǝlɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("S224_22","011_24_22","2SA","24","22","22","Ntɛnɑ Alɑfǝnɑ sɩ: Tɑ cɑɑ, kpɑɣɑ-tɛ nɑ ń lɑ kɔtɑsɩ nsi n nɔkɑɑ tɔ. Kpɑɣɑ nɑɑŋ ɩnɛ nɑ ń hɛtɩ ɑkuɣu kpɑtǝŋ nɑ ń lɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("S224_23","011_24_23","2SA","24","23","23","Pǝ tǝnɑɣɑ ɩ hɑ wulɑʋ nɑ ɩ́ tɔmɩ-ɩ sɩ: Nyɑ́ Ɩsɔ Tɑcɑɑ ɩ́ mʋ nyɑ́ sǝlǝmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("S224_24","011_24_24","2SA","24","24","24","Tǝnɑɣɑlɛ wulɑʋ cɔ-ɩ sɩ: Aɑɩ, mɑɑ yɑnɑ liɣitee kɛ́, mɑ kɑɑ hɑ Tɑcɑɑ kɛ mpi pǝ tɔɔ mɑ tɑ wɩɩ tɔ. Ɩlɛnɑ Tɑfiiti fɛlɩ tǝfɑllɛ nɑ nɑɑŋ pǝ tɔɔ kɛ́ liɣitee nyǝɣǝtʋ nɩɩlɛ nɑ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("S224_25","011_24_25","2SA","24","25","25","Ḿpʋ́ɣʋ́ ɩ ŋmɑwɑ kɔtɑɣɑ tǝlɑtɛ nɑ ɩ́ lɑ Tɑcɑɑ kɛ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑɑ tɔ nɑ ciikuɣu nyǝnsɩ. Ɩlɛnɑ Tɑcɑɑ pɑ́ɑ́nɑ́ hɛɛ nɑ mpusi kɛɛlɩ Ɩsɛɣɛlɩ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ wulɑʋ Tɑfiiti kpɑtǝlɑɑ tǝkuŋkuŋku, nɑ pɑ́ tɑkǝɣɩ-ɩ pɔɔŋ pɩɩ hɑŋǝɣɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","Ntɛnɑ wulɑʋ wɑɑlɩ nyǝ́mɑ tɔ sɩ: Tɑ́ cɑɑ wulɑʋ, tɩɩ cɑɑ-ŋ pɛɛlɔ wei ɩ tɑ nyǝntɑ ɑpɑlʋ tɔ nɑ ɩ́ pɑɑsǝnɑ-ŋ, nɑ ɩ́ hǝntǝɣɩ nyɑ́ kɔŋkɔŋ tɑɑ. Pɩɩ hɑŋɩ-ŋ. ");
INSERT INTO dop_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","Ɩlɛnɑ pɑ́ pɛɛkɩ Ɩsɛɣɛlɩ tɛtʋ tǝnɑ tɑɑ kɛ́ pɛɛlɔ telu, nɑ pɑ́ hiki Sunem tʋ nɔɣɔlʋ. Pɑ yɑɑ-ɩ sɩ Apisɑkɩ. Ɩlɛnɑ pɑ́ ponɑ-ɩ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","Pɛɛlɔ ɩnɩ ɩ ɩsɛntɑɑ kɑ lɩɩwɑɣɑ tǝkpɑpɑ. Ḿpʋ́ɣʋ́ ɩ pɑɑsǝnɑ wulɑʋ. Amɑ wulɑʋ tɑ nyǝmɩ-ɩ ɑpɑlʋ nɑ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("K11_5","012_1_5","1KI","1","5","6","Ḿpʋ́ɣʋ́ Hɑkii pǝyɑlʋ Atoniyɑ, Apǝsɑlɔm neu yɔtɔtɛ nyǝŋ lɑpɑ kɑlɑmpɑɑnɩ, sɩ ɩnɩ ɩ kɑ́ tɔɣɔnɑ kɑwulɑɣɑ. Ɩ ɩsɛntɑɑ kɑ lɩɩwɑɣɑ. Pǝ́cɔ́ too ɩ kʋlʋɣʋ tɔ, ɩ cɑɑ tɑ kɑlǝnɑ-ɩ pɑɑ tɔm kʋlʋm sɩ pʋlʋ. Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ ɩ cɑɑ yoou kɛɛkɛnɑɑ, nɑ kpɑɣɑnǝŋ cɑɣɑlɑɑ, nɑ ɩ tɑŋlɑɑ kɛ nɩɩlɛ nɑ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("K11_7","012_1_7","1KI","1","7","7","Ḿpʋ́ɣʋ́ ɩ nɑwɑ Sowɑpɩ, nɑ kɔtʋlʋ Apiyɑtɑɑ, nɑ pɛlɛ pɑ lɑŋɑ hɛɛnɑ ɩ tɔm ntɩ. ");
INSERT INTO dop_vpl VALUES ("K11_8","012_1_8","1KI","1","8","8","Amɑ kɔtʋlʋ Sɑtɔkɩ, nɑ Yoyɑtɑ pǝyɑlʋ Penɑyɑ nɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ, nɑ Simeyi, nɑ Leyi, nɑ Tɑfiiti tɑŋlɑɑ fɛɩ Atoniyɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K11_9","012_1_9","1KI","1","9","9","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Atoniyɑ yelɑɑ nɑ pɑ́ kʋ heeŋ, nɑ nɑɑŋ kʋfɑŋ nim nyǝŋ kɛ Solɛɛtɩ pǝlɛ nte tǝ wɛ hite kɔŋkɔŋ tɑɑ tɔ tǝ tɔɔ. Nɑ ɩ́ lɑ́ ɑcimɑ. Ɩlɛnɑ ɩ́ yɑɑ ɩ newɑɑ nɑ Yutɑ nyǝ́mɑ mpɑ pɑ lɑkɩ wulɑʋ kɛ tǝmlɛ tɔɣɔ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("K11_10","012_1_10","1KI","1","10","10","Amɑ Atoniyɑ tɑ yɑɑ ɩ neu yɔtɔtɛ nyǝŋ Sɑlʋmɔŋ, nɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ nɑ Penɑyɑ nɑ wulɑʋ tɑŋlɑɑ. ");
INSERT INTO dop_vpl VALUES ("K11_11","012_1_11","1KI","1","11","11","Mpʋɣʋlɛ Nɑtɑŋ polɑɑ nɑ ɩ́ pɔɔsɩ Sɑlʋmɔŋ too Pɑsepɑ sɩ: N nɩɩwɑ sɩ Hɑkii pǝyɑlʋ Atoniyɑ pǝsɑ wulɑʋ nɑ? Pǝyele tɑ́ cɑɑ Tɑfiiti nɑ́ tɑ́ nyɩ-tɩ. ");
INSERT INTO dop_vpl VALUES ("K11_12","012_1_12","1KI","1","12","12","Mpʋ tɔ, yele mɑ tɑsɑ-ŋ lɑɣɑtʋ kɛ ɩsǝnɑ n kɑ́ yɑ nyɑnɑ nyɑ́ pǝyɑlʋ Sɑlʋmɔŋ mǝ nyɔɔŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K11_13","012_1_13","1KI","1","13","13","Polo ń nɑ́ wulɑʋ kɛ lɔŋ, nɑ ń pɔɔsɩ-ɩ sɩ: Hɑɩ, tɑ́ cɑɑ wulɑʋ, ɩsɩɩ n heelɑ-m nɑ tuunɑʋ sɩ, nyɑ́ pǝyɑlʋ Sɑlʋmɔŋ kɑ́ tɔɣɔnɑ kɑwulɑɣɑ, nɑ ɩ́ lɛɛtɩ nyɑ́ kumte tɔɔ? Ɩlɛ pepe tɔɔ kɛ́ Atoniyɑ tɔkɩ kɑwulɑɣɑ? ");
INSERT INTO dop_vpl VALUES ("K11_14","012_1_14","1KI","1","14","14","Ɩlɛ mɑ mɑɣɑmɑɣɑ mɑɑ kɔɔ wɑɑtʋ ɩnǝɣɩ mǝ kiŋ, nɑ mɑ́ sɔɔsɩ nyɑ́ tɔm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K11_15","012_1_15","1KI","1","15","15","Mpʋɣʋlɛ Pɑsepɑ sʋʋ wulɑʋ nɑŋ tɑɑ. Wulɑʋ kɑ kpɑtǝlɑ sɔsɔm kɛ́, nɑ Sunem tʋ Apisɑkɩ pɑɑsǝɣǝnɑ-ɩ. ");
INSERT INTO dop_vpl VALUES ("K11_16","012_1_16","1KI","1","16","16","Ɩlɛnɑ Pɑsepɑ hǝntɩ wulɑʋ kɛ ɑtɛ. Nɑ wulɑʋ pɔɔsɩ-ɩ sɩ: Alɑɑfǝyɑ kɛlɛ? ");
INSERT INTO dop_vpl VALUES ("K11_17","012_1_17","1KI","1","17","17","Ntɛnɑ Pɑsepɑ cɔ sɩ: Ɛɛ ɑlɑɑfǝyɑ kɛ́. Hɑɩ, tɑ́ cɑɑ, n kɑ heelɑ-m nɑ ń tuunɑ nyɑ́ Ɩsɔ Tɑcɑɑ sɩ, mɑ pǝyɑlʋ Sɑlʋmɔŋ kɑ́ tɔɣɔnɑ kɑwulɑɣɑ, nɑ ɩ́ lɛɛtɩ nyɑ́ kumte tɔɔ ɩlɛ? ");
INSERT INTO dop_vpl VALUES ("K11_18","012_1_18","1KI","1","18","18","Tɔʋ, nɔɔnɔɔ Atoniyɑ tɔkǝnɑ ntɛ́, pǝ́cɔ́ n tɑ nɩɩ. ");
INSERT INTO dop_vpl VALUES ("K11_19","012_1_19","1KI","1","19","19","Ɩ lɑpɑ kɔtɑɣɑ kɛ nɑɑŋ, nɑ heeŋ, nɑ nɑɑŋ kʋfɑŋ nim nyǝŋ kɛ sɔsɔm. Nɑ ɩ́ lɑ́ ɑcimɑ, nɑ ɩ́ yɑɑ nyɑ́ pǝyɑlɑɑ tǝnɑ, nɑ kɔtʋlʋ Apiyɑtɑɑ, nɑ yoolɑɑ wulɑʋ Sowɑpɩ. Amɑ ɩ tɑ yɑɑ nyɑ́ pǝyɑlʋ Sɑlʋmɔŋ. ");
INSERT INTO dop_vpl VALUES ("K11_20","012_1_20","1KI","1","20","20","Hɑɩ, tɑ́ cɑɑ, nyɑɣɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nyǝnǝɣɩ sɩ ń hʋlɩ-wɛɣɛ wei ɩ kɑ́ lɛɛtɩ nyɑ́ kumte tɔɔ kɛ́ nyɑ́ sǝm wɑɑlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("K11_21","012_1_21","1KI","1","21","21","Ye pǝ tɑɣɑ mpʋ, wɑɑtʋ wei n kɔŋ n sɩ tɔ, yǝlɑɑ kɑ́ lɩɩ mɑ nɑ mɑ pǝyɑlʋ Sɑlʋmɔŋ kɛ koloŋɑ. ");
INSERT INTO dop_vpl VALUES ("K11_22","012_1_22","1KI","1","22","23","Wɑɑtʋ wei ɑlʋ ɩnɩ ɩ tɔŋɑ ḿpʋ́ɣʋ́ yɔɣɔtʋɣʋ tɔɣɔ pɑ heelɑ wulɑʋ sɩ Nɑtɑŋ kɔmɑ. Ɩlɛnɑ Nɑtɑŋ sʋʋ nɑ ɩ́ hǝntɩ wulɑʋ kɛ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("K11_24","012_1_24","1KI","1","24","24","Nɑ Nɑtɑŋ pɔɔsɩ wulɑʋ sɩ: Tɑ́ cɑɑ, nyɑ́ heelinɑ Atoniyɑ sɩ ɩ́ tɔɣɔ kɑwulɑɣɑ nɑ ɩ́ cɑɣɑ nyɑ́ kumte tɔɔ? ");
INSERT INTO dop_vpl VALUES ("K11_25","012_1_25","1KI","1","25","25","Mpi tɔ, sɑŋɑ ɩ kɔmɑ nɑ ɩ́ lɑ́ kɔtɑɣɑ kɛ nɑɑŋ, nɑ heeŋ, nɑ nɑɑŋ kʋfɑŋ nim nyǝŋ kɛ sɔsɔm. Ɩ yɑɑ nyɑ́ pǝyɑlɑɑ tǝnɑ, nɑ yoolɑɑ nyʋɣʋ nyǝ́mɑ nɑ kɔtʋlʋ Apiyɑtɑɑ, nɑ pɑ́ nɑ-ɩ pɑ́ tɔɣɔ nɑ pɑ́ nyɔɔ nɑ pɑ́ wilitiɣi sɩ: Atoniyɑ nyɑnɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("K11_26","012_1_26","1KI","1","26","26","Amɑ ɩ tɑ yɑɑ kɔtʋlʋ Sɑtɔkɩ, yɑɑ Yoyɑtɑ pǝyɑlʋ Penɑyɑ, yɑɑ nyɑ́ pǝyɑlʋ Sɑlʋmɔŋ. ");
INSERT INTO dop_vpl VALUES ("K11_27","012_1_27","1KI","1","27","27","Ɩlɛ, tɑ́ cɑɑ nyɑ́ heelinɑ-ɩ sɩ ɩ kɑ́ tɔɣɔ kɑwulɑɣɑ kɛ nyɑ́ sǝm wɑɑlɩ nɑ ń ŋmɛsɩ-tʋ? ");
INSERT INTO dop_vpl VALUES ("K11_28","012_1_28","1KI","1","28","28","Ntɛnɑ wulɑʋ tɔ sɩ: Ɩ́ yɑɑ-m Pɑsepɑ. Ɩlɛnɑ Pɑseyɑ mǝlɩ. ");
INSERT INTO dop_vpl VALUES ("K11_29","012_1_29","1KI","1","29","29","Ḿpʋ́ɣʋ́ wulɑʋ tɔmɑ sɩ: Mɑ tuukinɑ Tɑcɑɑ wei ɩ wɑɑsɑ-m mɑ lɑŋwɑkǝllɛ tǝnɑ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K11_30","012_1_30","1KI","1","30","30","Sɑŋɑ mɑɣɑmɑɣɑ mɑɑ lɑ nti mɑɑ tɛmɑ yɔɣɔtʋɣʋ nɑ mɑ́ sɩɩ Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ ɩsɛntɑɑ sɩ, nyɑ́ pǝyɑlʋ Sɑlʋmɔŋ kɑ́ tɔɣɔnɑ kɑwulɑɣɑ, nɑ ɩ́ cɑɣɑ mɑ kumte tɔɔ kɛ́ mɑ sǝm wɑɑlɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("K11_31","012_1_31","1KI","1","31","31","Ɩlɛnɑ Pɑsepɑ hǝntɩ wulɑʋ kɛ ɑtɛ nɑ ɩ́ tɔ́ sɩ: Hɑɩ, tɑ́ cɑɑ, nyɑnɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","Mpʋɣʋlɛ wulɑʋ Tɑfiiti tilɑɑ nɑ pɑ́ yɑɑ-ɩ kɔtʋlʋ Sɑtɔkɩ, nɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ, nɑ Yoyɑtɑ pǝyɑlʋ Penɑyɑ nɑ pɑ́ kɔɔ. ");
INSERT INTO dop_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","Nɑ wulɑʋ tɔ-wɛ sɩ: Ɩ́ koti yoolɑɑ mpɑ pɑ lɑpɑ-m nɑɑni tɔ nɑ ɩ́ cɑɣɑsɩ Sɑlʋmɔŋ kɛ mɑ kɑwulɑɣɑ kpɑŋɑɣɑ tɔɔ nɑ ɩ́ ponɑ-ɩ Kihɔŋ hite. ");
INSERT INTO dop_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","Tǝnɑɣɑ kɔtʋlʋ Sɑtɔkɩ nɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Nɑtɑŋ pɑɑ pǝlɩ-ɩ nim, nɑ pɑ́ kpɑ-ɩ Ɩsɛɣɛlɩ nyǝ́mɑ wulɑʋ. Ɩlɛnɑ pɑ́ hʋ́lɩ tutuɣu nɑ pɑ́ wiliti sɩ: Sɑlʋmɔŋ, mǝ nɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","Ɩlɛnɑ mɩɩ tǝŋ ɩ wɑɑlɩ, nɑ Sɑlʋmɔŋ kɔɔ ɩ́ cɑɣɑ mɑ kɑwulɑɣɑ kumte tɔɔ, nɑ ɩ́ tɔɣɔ kɑwulɑɣɑ kɛ mɑ lonte. Ɩnǝɣɩ mɑ kpɑwɑ Ɩsɛɣɛlɩ nɑ Yutɑ pǝ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","Tǝnɑɣɑlɛ Penɑyɑ cɔwɑ sɩ: Ɩsɔ ɩ́ kɔnɑ mpʋ. Nyɑ́ Cɑɑ Ɩsɔ yɔɣɔtǝnɑ-tɩ nɑ nyɑ́ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","Ɩlɛ Ɩsɔ ɩ́ wɛɛ Sɑlʋmɔŋ wɑɑlɩ, ɩsɩɩ ɩ kɑ wɛʋ nyɑ́ wɑɑlɩ tɔ. Nɑ ɩ́ kʋsɩ Sɑlʋmɔŋ nyʋɣʋ nɑ pǝ́ kǝlɩ-ŋ. ");
INSERT INTO dop_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","Ḿpʋ́ɣʋ́ Sɑtɔkɩ nɑ Nɑtɑŋ nɑ Penɑyɑ nɑ wulɑʋ tɑŋlɑɑ pɑ cɑɣɑsɑ Sɑlʋmɔŋ kɛ kɑwulɑɣɑ kpɑŋɑɣɑ tɔɔ, nɑ pɑ́ ponɑ-ɩ Kihɔŋ hite. ");
INSERT INTO dop_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","Ɩlɛnɑ Sɑtɔkɩ kpɑɣɑ nim nɑ hǝlʋɣʋ kɛ Ɩsɔ cokǝle tɑɑ, nɑ ɩ́ pǝlɩ-wǝɣɩ Sɑlʋmɔŋ, nɑ ɩ́ kpɑ-ɩ wulɑʋ. Ḿpʋ́ɣʋ́ pɑ hʋlɑ tutuɣu, ɩlɛnɑ yǝlɑɑ tǝnɑ wiliti sɩ: Sɑlʋmɔŋ nyɑnɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("K11_40","012_1_40","1KI","1","40","40","Ɩlɛnɑ yǝlɑɑ tǝnɑ tʋ ɩ wɑɑlɩ nɑ pɑ́ kpeenɑ-ɩ nɑ hǝsɩ, nɑ pɑ́ kiisiɣinɑ lɑŋhʋlʋmlɛ. Hɑlǝnɑ tɛtʋ nyɑmsǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("K11_41","012_1_41","1KI","1","41","41","Atoniyɑ nɑ ɩ nyǝ́mɑ pɛlɛ pɑ tɛɛsɑɣɑ tɔɣɔʋ, ɩlɛ pɑ nɩɩ Sɑlʋmɔŋ pɑ kɔkɔtɛ ntɛ́. Nɑ Sowɑpɩ nɩɩ tutuɣu, nɑ ɩ́ pɔɔsɩ sɩ: Pepe tɔɔ kɛ́ ɩcɑtɛ cʋkɑɑ nɑ kɔkɔtɛ nyɑlɑ mpʋ? ");
INSERT INTO dop_vpl VALUES ("K11_42","012_1_42","1KI","1","42","42","Pɑ tɔŋnɑ yɔɣɔtɑɣɑ kɛ mpʋ, ɩlɛ Apiyɑtɑɑ pǝyɑlʋ Yonɑtɑŋ tɑpɑɣɑlɛ. Ɩlɛnɑ Atoniyɑ tɔmɩ-ɩ sɩ: Sʋʋ, mpi tɔ, n kɛ yʋlʋ wei ɩ wɛnɑ nyʋɣʋ tɔɣɔ. Ɩsǝntɔ tɔm kʋpɑntʋ kɛ n kɔnɑɑ. ");
INSERT INTO dop_vpl VALUES ("K11_43","012_1_43","1KI","1","43","43","Kɛlɛnɑ Yonɑtɑŋ sɩ: Aɑɩ yoo, tɑ́ cɑɑ wulɑʋ tʋnɑ Sɑlʋmɔŋ kɛ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K11_44","012_1_44","1KI","1","44","44","Ɩ tɔmɑ Sɑtɔkɩ, nɑ Nɑtɑŋ, nɑ Penɑyɑ, nɑ tɑŋlɑɑ sɩ, pɑ́ cɑɣɑsɩ Sɑlʋmɔŋ kɛ kɑwulɑɣɑ kpɑŋɑɣɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K11_45","012_1_45","1KI","1","45","45","Nɑ Sɑtɔkɩ nɑ Nɑtɑŋ pɑ́ pǝlɩ Sɑlʋmɔŋ kɛ nim kɛ Kihɔŋ hite, nɑ pɑ́ kpɑ-ɩ wulɑʋ. Tǝnɑɣɑ ɩcɑtɛ yǝlɑɑ lɩɩnɑɑ, nɑ pɑ́ kiisiɣinɑ lɑŋhʋlʋmlɛ. Mpi pǝ cʋkɑ ɩcɑtɛ tɑɑ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("K11_46","012_1_46","1KI","1","46","46","Hɑlɩ Sɑlʋmɔŋ nɑ́ tɛmɑ kɑwulɑɣɑ kumte tɔɔ kɛ́ cɑɣɑlɛ kɛ́. ");
INSERT INTO dop_vpl VALUES ("K11_47","012_1_47","1KI","1","47","47","Ɩlɛnɑ wulɑʋ Tɑfiiti wɑɑlɩ nyǝ́mɑ polo nɑ pɑ́ sɛɛ-ɩ, nɑ pɑ́ tɔ sɩ: Tɑ́ cɑɑ, nyɑ́ Ɩsɔ ɩ́ kʋsɩ Sɑlʋmɔŋ nyʋɣʋ nɑ pǝ́ kǝlɩ ɩsɩɩ nyɑ́. Ɩ kɑwulɑɣɑ ɩ́ kǝlɩ nyɑ́ nyǝŋkɑ. Ɩlɛnɑ wulɑʋ hǝntɩ Ɩsɔ kɛ́ ɑtɛɣɛ ɩ kɑto tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K11_48","012_1_48","1KI","1","48","48","Nɑ ɩ́ tɔ́ sɩ: Mɑ sɛɛ Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ, wei ɩ yelɑɑ sɩ mɑ́ nɑ́ mɑ lonte tɑɑ lɛɛtǝlʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K11_49","012_1_49","1KI","1","49","49","Tǝnɑɣɑlɛ sɔɣɔntʋ kpɑ Atoniyɑ yǝlɑɑ tǝnɑ, nɑ pɑ́ kʋlɩ nɑ pɑ́ yɑ yemyem. ");
INSERT INTO dop_vpl VALUES ("K11_50","012_1_50","1KI","1","50","50","Ɩlɛnɑ Sɑlʋmɔŋ tɔm kpɑ Atoniyɑ kɛ sɔɣɔntʋ, nɑ ɩ́ polo nɑ ɩ́ tʋ kɔtɑɣɑ tǝlɑtɛ kɛ kpʋlʋɣʋ sɩ, pɑ́ tɑɑ lɛɛtɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("K11_51","012_1_51","1KI","1","51","51","Ḿpʋ́ɣʋ́ pɑ polɑɑ nɑ pɑ́ heeli Sɑlʋmɔŋ sɩ: Nyɑ́ tɔm kpɑ Atoniyɑ kɛ sɔɣɔntʋ kɛ sɔsɔm, nɑ ɩ́ polo ɩ́ tʋ kɔtɑɣɑ tǝlɑtɛ kɛ kpʋlʋɣʋ. Ɩ tɔmɑ sɩ: Ye Sɑlʋmɔŋ tɑ tuunɑ sɩ ɩ kɑɑ kʋ-m, mɑ kɑɑ lɩɩ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("K11_52","012_1_52","1KI","1","52","52","Ntɛnɑ Sɑlʋmɔŋ sɩ: Ye ɩɩ hɔŋ ɩ tɩ, pʋlʋpʋ kɑɑ tokinɑ-ɩ pɑɑ pǝcɔ. Amɑ ye ɩ lɑkɩ kɑlɑmpɑɑnɩ, ɩsɩɩ ɩ sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("K11_53","012_1_53","1KI","1","53","53","Ḿpʋ́ɣʋ́ wulɑʋ Sɑlʋmɔŋ tilɑ yǝlɑɑ nɑ pɑ́ lǝsɩ-ɩ tǝnɑ. Ɩlɛnɑ Atoniyɑ polo ɩ́ hǝntɩ Sɑlʋmɔŋ kɛ ɑtɛ, ɩlɛnɑ wulɑʋ tɔmɩ-ɩ sɩ: Kpe nyɑ́ tɛ. ");
INSERT INTO dop_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","Pǝ kpɛɣɛtǝnɑ wulɑʋ Tɑfiiti sǝm, ɩlɛnɑ ɩ́ heeli ɩ pǝyɑlʋ Sɑlʋmɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","Mɑ wʋlɛ pʋwɑ. Mpʋ tɔ, kɑɑsɩ nyɑ́ tɩ nɑ ń lɑ́ ɩsɩɩ yʋlʋ. ");
INSERT INTO dop_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","Tɔkɩ Tɑcɑɑ nyɑ́ Ɩsɔ tɔm kɛ teu. Lɑkɩ ɩ luɣu nyǝntʋ kɛ tɑm, nɑ ń tǝŋǝɣɩ ɩ kʋsǝsɩɩtʋ, nɑ ɩ kʋtʋtʋtʋ, ɩsɩɩ pɑ ŋmɑɑʋ Moisi kiiŋ tɑkǝlɑɣɑ tɑɑ tɔ. Wɑɑtʋ ɩnǝɣɩ n kɑ́ wɑɑ pǝ tǝnɑ mpi n lɑkɩ tɔ pǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","Ɩlɛnɑ Tɑcɑɑ lɑ́ ɩsɩɩ ɩ kɑ sɩɩ-m tɔ sɩ, ye mɑ piyɑ tɔŋnɑ lɑɑkɑlɩ, nɑ pɑ́ tǝŋǝɣɩ mɑ kʋsǝsɩɩtʋ nɑ lotu kʋlʋmtʋ, nɑ pɑ lǝsɑɣɑ sʋʋ-ɩ teu, mpɛ pɑɑ tɔkǝnɑ mɑ kɑwulɑɣɑ kɛ tɑm kɛ́ mɑ sǝm wɑɑlɩ kɛ́ Ɩsɛɣɛlɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K12_5","012_2_5","1KI","2","5","5","Pǝlɛ pǝ pɑɑsi, n nyǝmɑ́ nti Seluyɑ pǝyɑlʋ Sowɑpɩ lɑpɑ-m tɔ. Ɩsǝnɑ ɩ kʋwɑ Ɩsɛɣɛlɩ yoou nyʋɣʋ nyǝ́mɑ Nɛɛ pǝyɑlʋ Apǝnɛɛ, nɑ Yetɛɛ pǝyɑlʋ Amɑsɑ tɔ. Yoou hɛɛʋ wɑɑtʋ kɛ ɩ kʋwɑ yǝlɑɑ mpɛ, nɑ pǝ́ kʋ́ ɩ yoou nyʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K12_6","012_2_6","1KI","2","6","6","Mpʋ tɔ, lɑnɑ nyɑ́ lɑɣɑtʋ. Tɑɑ yele-ɩ nɑ ɩ́ sɩ́ sǝm kʋpɑm. ");
INSERT INTO dop_vpl VALUES ("K12_7","012_2_7","1KI","2","7","7","Pǝ kɑɑsɑ Kɑlɑɑtɩ tʋ Pɑɑsilɑyi pǝyɑlʋ tɔ, tɔkɩ pɛlɛɣɛ teu, nɑ ń cɑlǝsǝɣɩ-wɛ. Ḿpʋ́ɣʋ́ pɛlɛ pɑ pɑɑsɑɣɑnɑ mɑɣɑ wɑɑtʋ wei nyɑ́ tɑɑlʋ Apǝsɑlɔm tɔɣɔnɑɣɑ-m tɔ. ");
INSERT INTO dop_vpl VALUES ("K12_8","012_2_8","1KI","2","8","8","Kelɑɑ pǝyɑlʋ Simeyi wei ɩ wɛ Pɑhulim kɛ Pɛncɑmɛɛ tɛtʋ tɑɑ tɔ, ɩ́lɛ́ ɩ tǝŋsɑ-m mpusi kɛ́ teu kɛ kʋyɑkʋ ŋku mɑ pukɑɣɑ Mɑhɑnɑyim tɔɣɔ. Pǝ wɑɑlɩ kɛ́ ɩ sǝŋɑ-m Yɑɑtɑnɩ nɔɣɔ kɛ mɑ mǝlɑɣɑ tɔ, nɑ mɑ́ tuunɑ Tɑcɑɑ sɩ mɑ kɑɑ kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("K12_9","012_2_9","1KI","2","9","9","Pǝnɛntɛ tɑɑ hʋlɩ-ɩ suulu. N kɛ́ yʋlʋ lɑɣɑtʋ kɛ́. N nyǝmɑ́ ɩsǝnɑ n kɑ́ lɑ́ nɑ pɑɑ ɩ kpɑtǝlɑɑ tɔ, ɩ́ sɩ́ sǝm ɩsɑɣɑm tɔ. ");
INSERT INTO dop_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Pǝ wɑɑlɩ kɛ́ wulɑʋ Tɑfiiti sǝpɑ, nɑ pɑ́ pimi-ɩ timpi pɑ yɑɑ sɩ, Tɑfiiti tɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Pɩɩsɩ nɩɩlɛ tǝcu kɛ́ Tɑfiiti tɔɣɔ kɑwulɑɣɑ kɛ Ɩsɛɣɛlɩ tǝnɑ tɔɔ. Ɩ tɔɣɔ pɩɩsɩ nɑɑtosompɔɣɔlɑɣɑ kɛ Hepǝlɔŋ, nɑ Yosɑlɛm kɛ pɩɩsɩ hiu nɑ nɑɑnʋwɑ nɑ tooso. ");
INSERT INTO dop_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ lɛɛtɑ ɩ cɑɑ Tɑfiiti lonte nɑ ɩ kɑwulɑɣɑ lɑ teu pǝ tɩɩ fɛɩ. ");
INSERT INTO dop_vpl VALUES ("K12_13","012_2_13","1KI","2","13","13","Ḿpʋ́ɣʋ́ Hɑkii tʋ pǝyɑlʋ Atoniyɑ polɑ Sɑlʋmɔŋ too Pɑsepɑ kiŋ, nɑ Pɑsepɑ pɔɔsɩ-ɩ sɩ: Alɑɑfǝyɑ kɛlɛ? Nɑ ɩ́ cɔ sɩ: Ɛɛ. ");
INSERT INTO dop_vpl VALUES ("K12_14","012_2_14","1KI","2","14","14","Nɑ ɩ́ tɑsɑ sɩ: Fɑɑci nɔɣɔlʋɣʋ mɑ kɔmnɑɑ. Ntɛnɑ ɑlʋ sɩ: Yɔɣɔtɩ. ");
INSERT INTO dop_vpl VALUES ("K12_15","012_2_15","1KI","2","15","15","Ɩlɛnɑ Atoniyɑ tɔ́ sɩ: Ntɔŋ n nyǝmɑ́ sɩ mɑ́ tǝnnɑ kɑwulɑɣɑ ŋkɛ, nɑ mɑɣɑ Ɩsɛɣɛlɩ tǝnɑ kpɑɑkɑɣɑ wulɑʋ. Amɑ mɑ lɑŋɑɑ nɑ pǝ́ mǝlɩ mɑ neu tɔɔ. Mpi tɔ, Tɑcɑɑ cɛlǝnɑ-ɩ kɛ́. ");
INSERT INTO dop_vpl VALUES ("K12_16","012_2_16","1KI","2","16","16","Pǝnɛntɑɑ mɑ sǝlǝmǝɣɩ-ŋ pʋlʋ. Ɩlɛ tɑɑ pɛ-m-wɩ. Alʋ sɩ yɔɣɔtɩ. ");
INSERT INTO dop_vpl VALUES ("K12_17","012_2_17","1KI","2","17","17","Mpʋɣʋlɛ sɩ: Heeli wulɑʋ Sɑlʋmɔŋ sɩ ɩ́ hɑ-m Sunem tʋ Apisɑkɩ nɑ mɑ́ lɑ́ ɑlʋ. Ye nyɑɑ yɔɣɔtǝnɑ ɩ kɑɑ kisi. ");
INSERT INTO dop_vpl VALUES ("K12_18","012_2_18","1KI","2","18","18","Ɩlɛnɑ Pɑsepɑ tɔ́ sɩ: Pǝ wɛ teu, mɑɑ heeli-ɩ. ");
INSERT INTO dop_vpl VALUES ("K12_19","012_2_19","1KI","2","19","19","Ḿpʋ́ɣʋ́ Pɑsepɑ polɑ wulɑʋ kiŋ sɩ ɩ heeliɣi-ɩ Atoniyɑ tɔm. Wulɑʋ nɑ-ɩ, ɩlɛnɑ ɩ́ kʋlɩ nɑ ɩ́ sǝŋɩ-ɩ, nɑ ɩ́ hǝntɩ-ɩ ɑtɛ. Ɩlɛnɑ ɩ́ mǝlɩ ɩ kumte tɔɔ. Nɑ pɑ́ sɩɩ toto kɛ́ kɑwulɑɣɑ kpelɑɣɑ, nɑ wulɑʋ ntɔɣɔŋ tɔɔ nɑ toto cɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K12_20","012_2_20","1KI","2","20","20","Ntɛnɑ toto sɩ: Mɑ kɔmɑ-ŋ nɑtǝlǝɣɩ sǝlǝmʋɣʋ kɛ pǝcɔɣɔ, tɑɑ kisinɑ-m. Sɑlʋmɔŋ sɩ: Hɑɩ, nyɑɑ sǝlǝmɩ, mɑ kɑɑ kisi. ");
INSERT INTO dop_vpl VALUES ("K12_21","012_2_21","1KI","2","21","21","Mpʋɣʋlɛ sɩ: Yele nɑ nyɑ́ tɑɑlʋ Atoniyɑ kpɑɣɑ Sunem tʋ Apisɑkɩ. ");
INSERT INTO dop_vpl VALUES ("K12_22","012_2_22","1KI","2","22","22","Mpʋɣʋlɛ Sɑlʋmɔŋ sɩ: Pepee? Pepe tɔɔ kɛ nyɑ́ cɑɑ sɩ ɩ́ kpɑɣɑ-ɩ? Aŋhɑ, ɩlɛ sɑnɑ n kɑ sǝlǝmɑɑ sɩ mɑ́ cɛlɛ-ɩ kɑwulɑɣɑ. Ɩ kɛ́ mɑ tɑɑlʋ kɛ te. Mpi Apiyɑtɑɑ nɑ Sowɑpɩ pɑ kooliɣi tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("K12_23","012_2_23","1KI","2","23","23","Tǝnɑɣɑlɛ wulɑʋ Sɑlʋmɔŋ yɔɣɔtɑɑ nɑ ɩ tuu sɩ: Ye mɑ tɑ kʋ Atoniyɑ kɛ tɔm tǝnɛ tǝ tɔɔ, Tɑcɑɑ ɩ́ kʋ-m. ");
INSERT INTO dop_vpl VALUES ("K12_24","012_2_24","1KI","2","24","24","Mɑ tuunɑ Tɑcɑɑ wei ɩ tʋ mɑ́ nɑ mɑ tǝyɑɣɑ nyǝ́mɑ kɛ kɑwulɑɣɑ, nɑ ɩ́ lɛɛtɩ-m mɑ cɑɑ lonte tɔ sɩ, ɩsɩɩ sɑŋɑ mɑ kʋwɑ Atoniyɑ. ");
INSERT INTO dop_vpl VALUES ("K12_25","012_2_25","1KI","2","25","25","Ɩlɛnɑ Sɑlʋmɔŋ tili Yoyɑtɑ pǝyɑlʋ Penɑyɑ nɑ ɩ́ kʋ Atoniyɑ. ");
INSERT INTO dop_vpl VALUES ("K12_26","012_2_26","1KI","2","26","26","Ye Apiyɑtɑɑ, wulɑʋ heelɑ ɩlɛɣɛ sɩ: Kpe nyɑ́ tɛ Anɑtɔtɩ. N mʋnɑ sǝm yɑɑ, ɩlɛ mɑ kɑɑ kʋ-ŋ sɑŋɑ kɛ́. Mpi tɔ, n pɑɑsǝnɑ Ɩsɔ ɑtɑkɑɑ kɛ́ mɑ cɑɑ Tɑfiiti wɑɑtʋ tɑɑ. Hɑlɩ nyɑ́ nɑ mɑ cɑɑ Tɑfiiti ɩ́ tɔɣɔnɑ pǝ wɑhɑlɑ. ");
INSERT INTO dop_vpl VALUES ("K12_27","012_2_27","1KI","2","27","27","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ lǝsɑ Apiyɑtɑɑ kɛ kɔtʋɣʋ tǝmlɛ tɑɑ. Ɩlɛnɑ pǝ lɑ ɩsɩɩ Tɑcɑɑ kɑ yɔɣɔtʋɣʋ Ɩlii tǝyɑɣɑ nyǝ́mɑ tɔɔ kɛ́ Silo tɔ. ");
INSERT INTO dop_vpl VALUES ("K12_28","012_2_28","1KI","2","28","28","Wɑɑtʋ wei Sowɑpɩ nɩɩwɑ Atoniyɑ sǝm nɑ Apiyɑtɑɑ tɔɣɔnʋɣʋ, ɩlɛnɑ ɩ́ se nɑ ɩ́ sʋʋ Ɩsɔ cokǝle tɑɑ, nɑ ɩ́ tʋ́ kpʋlʋɣʋ kɛ kɔtɑɣɑ tǝlɑtɛ kiŋ. Mpi tɔ, ɩ kɑ wɛ Atoniyɑ tɔɔ kɛ́. Amɑ ɩ tɑɑ tǝŋ Apǝsɑlɔm kɛ́. ");
INSERT INTO dop_vpl VALUES ("K12_29","012_2_29","1KI","2","29","29","Ɩlɛnɑ pɑ́ tɑɣɑsɩ wulɑʋ sɩ Sowɑpɩ sʋʋ Ɩsɔ cokǝle tɑɑ, nɑ ɩ́ tʋ́ kpʋlʋɣʋ kɛ kɔtɑɣɑ tǝlɑtɛ. Ntɛnɑ wulɑʋ tili Yoyɑtɑ pǝyɑlʋ Penɑyɑ sɩ: Polo nɑ ń kʋ-ɩ. ");
INSERT INTO dop_vpl VALUES ("K12_30","012_2_30","1KI","2","30","30","Penɑyɑ polɑɑ, ɩlɛnɑ ɩ́ tɔ́ Sowɑpɩ sɩ: Wulɑʋ tɔmɑ sɩ ń lɩɩ. Ntɛnɑ Sowɑpɩ sɩ: Hɑɩ, cǝnɛɣɛ mɑ cɑɑ sɩ mɑ́ sɩ. Ḿpʋ́ɣʋ́ Penɑyɑ mǝlɑɑ nɑ ɩ́ heeli wulɑʋ kɛ nti Sowɑpɩ yɔɣɔtɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K12_31","012_2_31","1KI","2","31","31","Kɛlɛnɑ wulɑʋ sɩ: Polo nɑ ń kʋ-ɩ tǝnɑ ɩsɩɩ ɩ yɔɣɔtʋɣʋ tɔ, nɑ ń pimi-ɩ. Ɩlɛ n kɛɛlɑ mɑ́ nɑ mɑ cɑɑ tǝyɑɣɑ tɑ nyʋɣʋ tɔɔ kɛ́ yǝlɑɑ mpɑ ɩ kʋwɑ mʋsʋŋ tɔ, pɑ mpusi kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("K12_32","012_2_32","1KI","2","32","32","Ɩ nyʋɣʋ tɑɑ kɛ́ Tɑcɑɑ kɑ́ mǝŋnɑ yǝlɑɑ kʋpɑmɑ nɑɑlɛ wei ɩ kʋwɑ tɔ pɑ sǝm tɔm. Pɑɑ Ɩsɛɣɛlɩ yoolɑɑ wulɑʋ Apǝnɛɛ, nɑ Yutɑ yoolɑɑ wulɑʋ Amɑsɑ. ");
INSERT INTO dop_vpl VALUES ("K12_33","012_2_33","1KI","2","33","33","Mpɛ ɩnɩ pɑ sǝm tɔm kɑ́ mǝlɩ Sowɑpɩ nɑ ɩ piitim nyǝ́mɑ pɑ nyɔɔŋ tɑɑ kɛ́ tɑm tɔɔ kɛ́. Amɑ Tɑcɑɑ kɑ́ yele nɑ Tɑfiiti lʋlʋɣʋ nyǝ́mɑ, nɑ ɩ tǝyɑɣɑ nyǝ́mɑ mpɑ pɑɑ lɛɛtǝɣɩ ɩ kɑwulɑɣɑ tɑɑ tɔ, pɑ́ hɛɛsɩ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K12_34","012_2_34","1KI","2","34","34","Ḿpʋ́ɣʋ́ Penɑyɑ kʋwɑ Sowɑpɩ nɑ ɩ́ kpeenɑ-ɩ ɩ cɑcɑkʋ tɛɛ, nɑ ɩ́ pimi-ɩ. ");
INSERT INTO dop_vpl VALUES ("K12_35","012_2_35","1KI","2","35","35","Ɩlɛnɑ wulɑʋ kpɑ Penɑyɑ kɛ yoolɑɑ wulɑʋ kɛ Sowɑpɩ lonte. Nɑ ɩ́ kpɑ Sɑtɔkɩ kɛ kɔtʋlʋ kɛ Apiyɑtɑɑ lonte. ");
INSERT INTO dop_vpl VALUES ("K12_36","012_2_36","1KI","2","36","36","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ wulɑʋ yɑɑ Simeyi nɑ ɩ́ tɔmɩ-ɩ sɩ: Nmɑ tǝyɑɣɑ kɛ Yosɑlɛm tɑɑ nɑ ń cɑɣɑ. Pǝ fɛɩ sɩ ń lɩɩ sɩ ń puki tiili. ");
INSERT INTO dop_vpl VALUES ("K12_37","012_2_37","1KI","2","37","37","Ye kʋyɑkʋ ŋku pǝ cǝpɑ-ŋ nɑ ń lɩɩ, nɑ ń tɛsɩ Setǝlɔŋ lɔɔʋ, nɑ ń hikɑ mpi, n yɑpɑ. ");
INSERT INTO dop_vpl VALUES ("K12_38","012_2_38","1KI","2","38","38","Ntɛnɑ Simeyi sɩ: Hɑɩ, tɑ́ cɑɑ wulɑʋ, mɑɑ lɑ ɩsɩɩ n yɔɣɔtʋɣʋ tɔ. Ɩlɛnɑ Simeyi cɑɣɑ Yosɑlɛm tɑɑ nɑ pǝ́ leeli. ");
INSERT INTO dop_vpl VALUES ("K12_39","012_2_39","1KI","2","39","39","Pɩɩsɩ tooso sikɑɑ, ɩlɛnɑ Simeyi tǝmlɛ nyǝ́mɑ nɑɑlɛ se nɑ pɑ́ polo Kɑtɩ wulɑʋ Mɑɑkɑ pǝyɑlʋ Akisi tɛ́. ");
INSERT INTO dop_vpl VALUES ("K12_40","012_2_40","1KI","2","40","40","Wɑɑtʋ wei Simeyi nɩɩwɑ sɩ ɩ tǝmlɛ nyǝ́mɑ wɛ Kɑtɩ, ɩlɛnɑ ɩ́ kpɛɛlɩ ɩ kpɑŋɑɣɑ nɑ ɩ́ polo ɩ tǝmlɛ nyǝ́mɑ wɑɑlɩ nɑ ɩ́ kɔnɑ-wɛ. ");
INSERT INTO dop_vpl VALUES ("K12_41","012_2_41","1KI","2","41","41","Ḿpʋ́ɣʋ́ pɑ tɑɣɑsɑ Sɑlʋmɔŋ sɩ Simeyi polɑ Kɑtɩ nɑ ɩ́ kɔɔ. ");
INSERT INTO dop_vpl VALUES ("K12_42","012_2_42","1KI","2","42","42","Ntɛnɑ wulɑʋ yɑɑ-ɩ nɑ ɩ́ pɔɔsɩ-ɩ sɩ: Ɩsɩɩ mɑ́ kisinɑ-ŋ tǝsɑɣɑsɑɣɑ, nɑ mɑ́ yele nɑ ń tuunɑ Tɑcɑɑ sɩ, ye kʋyɑŋku ń lɩɩwɑ nɑ ń polo tiili n kɑ́ sɩ nɑ? Hɑlǝnɑ ń cɔ-m sɩ, pǝ wɛ teu n nɩɩwɑ? ");
INSERT INTO dop_vpl VALUES ("K12_43","012_2_43","1KI","2","43","43","Pepe tɔɔ kɛ́ n tɑ tɔkɩ nyɑ́ tuunɑʋ nɑ ń kpɛɛnɑ nti mɑ́ kisinɑ-ŋ tɔ? ");
INSERT INTO dop_vpl VALUES ("K12_44","012_2_44","1KI","2","44","44","N nyǝmɑ́ nyɑ́ tɑɑ kɛ́ ɩsɑɣɑtʋ nti n lɑpɑ mɑ cɑɑ Tɑfiiti tɔ, Tɑcɑɑ kɑ́ lɛɛtǝnɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("K12_45","012_2_45","1KI","2","45","45","Ɩlɛnɑ ɩ́ kooli mɑɣɑ kʋpɑntʋ nɑ ɩ́ sɩɩ Tɑfiiti tǝyɑɣɑ kɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K12_46","012_2_46","1KI","2","46","46","Ḿpʋ́ɣʋ́ wulɑʋ kʋsɑ Penɑyɑ nɑ ɩ́ kʋ́ Simeyi. Ɩlɛnɑ kɑwulɑɣɑ nɑ́ɑ́ sʋʋ toŋ sɔɔsʋɣʋ kɛ Sɑlʋmɔŋ niŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K13_1","012_3_1","1KI","3","1","1","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ kpɑɣɑ Icipiti wulɑʋ pɛɛlɔ. Ɩlɛnɑ ɑkpɑɣɑlɛ ntɛ́ tǝ́ kpɛntɩ ɑwulɑɑ mpɛ pɑ nɑɑlɛ. Ntɛnɑ Sɑlʋmɔŋ ponɑ ɑlʋ ɩnɩ nɑ ɩ́ sɩɩ-ɩ Tɑfiiti tɛɣɛ Yosɑlɛm. Hɑlǝnɑ ɩ́ tɛɛsɩ kɑwulɑɣɑ tǝyɑɣɑ, nɑ Ɩsɔ tǝsɛɛlɛ nɑ ɩcɑtɛ koluŋɑ kɛ ŋmɑʋ. ");
INSERT INTO dop_vpl VALUES ("K13_2","012_3_2","1KI","3","2","3","Sɑlʋmɔŋ kɑ sɔɔlɑ Tɑcɑɑ kɛ́ nɑ ɩ́ tǝŋǝɣɩ ɩ cɑɑ Tɑfiiti ɩkpɑtɛ. Pɑɑ nɑ mpʋ tɔ, lonɑ pɑɣɑlɛ tɑɑ kɛ́ ɩ nɑ yǝlɑɑ pɑ lɑkɑɣɑ pɑ kɔtɑsɩ kɛ wɑɑtʋ ɩnɩ. Mpi tɔ, pɑ tɑ ŋmɑtɑ Tɑcɑɑ kɛ ɩ tǝsɛɛlɛ. ");
INSERT INTO dop_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ Sɑlʋmɔŋ polɑ Kɑpɑwɔŋ kɛ kɔtɑɣɑ lɑpʋ. Tɛtʋ tǝnɑ tɑɑ kɔtɑɣɑ tǝlɑtɛ sɔsɔɔlɛ ntɛ́ tǝnɑ. Hɑlɩ Sɑlʋmɔŋ lɑpɑ tǝnɑɣɑ kɔtɑɣɑ ŋkɑ kɔkɔ lusɑ kɑ tǝnɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Kɑpɑwɔŋ tǝnɑɣɑ Tɑcɑɑ lɩɩ Sɑlʋmɔŋ tɔɔ kɛ́ ɑhoo kɛ toosee tɑɑ, nɑ ɩ tɔmɩ-ɩ sɩ: Sǝlǝmɩ-m mpi n cɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","Ntɛnɑ Sɑlʋmɔŋ sɩ: Kʋpɑntʋ sɔsɔɔntʋ kɛ n lɑpɑ mɑ cɑɑ Tɑfiiti, kɛ timpi ɩ tǝŋɑ tɑmpɑnɑ nɑ lotu kʋlʋmtʋ, nɑ ɩ́ lɑkɩ kʋpɑntʋ tɔ. Hɑlɩ n hɑ-ɩ ɑpɑlʋpǝyɑɣɑ, nɑ kɛlɛ kɑ́ lɛɛtɩ ɩ lonte tɑɑ, ɩsɩɩ pǝ wɛʋ sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","Hɑɩ mɑ Ɩsɔ Tɑcɑɑ, mɑɣɑlɛ n kpɑɣɑɑ nɑ ń lɛɛtɩ mɑ cɑɑ lonte tɑɑ. Anɩ mɑ kɛ́ pǝyɑɣɑ kɛ́ nɑ hǝlǝm nɑ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Pǝyele nyɑ́ yǝlɑɑ kʋlǝsɑɑ mpɑ pɑ tɔɔ mɑ tɔkɩ kɑwulɑɣɑ tɔ, pɑ́ wɛ tuutuumɑ kɛ́ pɑ fɛɩ kɑlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Mpʋ tɔ, hɑ-m lɑɣɑtʋ, nɑ kʋpɑntʋ nɑ ɩsɑɣɑtʋ pǝ cɛkǝnɑʋ. Ɩlɛnɑ mɑ́ pǝsɩ nɑ mɑ́ pɑɑsǝnɑ nyɑ́ yǝlɑɑ sɑmɑɑ tuutuumɑ ɩnɛ. ");
INSERT INTO dop_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Ḿpʋ́ɣʋ́ Tɑcɑɑ lɑŋlɛ hɛɛnɑ Sɑlʋmɔŋ sǝlǝmʋɣʋ ŋkʋ. ");
INSERT INTO dop_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Ntɛnɑ ɩ́ tɔ́ sɩ: Timpi n sǝlǝmɑ lɑɣɑtʋ sɩ n tǝŋǝɣǝnɑ tɑmpɑnɑ, n tɑ sǝlǝmɩ weesuɣu kʋtɑɣɑlʋɣʋ, yɑɑ wɛnɑʋ, yɑɑ nyɑ́ kolontunɑɑ ɩ́ sɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","Mɑɑ tʋ-ŋ lɑɣɑtʋ nɑ nyǝm mpi too nɔɣɔlʋ tɑ hikitɑ tɔ. Pǝ́cɔ́ nɔɣɔlʋ kɑɑ tɑsɑ-wǝɣɩ hikuɣu tɔ. ");
INSERT INTO dop_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Pǝlɛ pǝ pɑɑsi, mɑɑ hɑ-ŋ mpi n tɑ sǝlǝmɩ tɔ. Wɛnɑʋ nɑ teeli, wulɑʋ nɔɣɔlʋ ɩ kɑɑ nǝɣǝsǝnɑ-ŋ, hɑlǝnɑ nyɑ́ sǝm. ");
INSERT INTO dop_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Ye n tɔŋ mɑ mpɑɑŋ tɑɑ, nɑ n tɔkɑ mɑ kʋtʋtʋtʋ nɑ mɑ kʋsǝsɩɩtʋ, ɩsɩɩ nyɑ́ cɑɑ Tɑfiiti, ɩlɛ mɑɑ yele nɑ nyɑ́ weesuɣu tɑɣɑlɩ. ");
INSERT INTO dop_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","Sɑlʋmɔŋ femɑ, ɩlɛ sɛsɛ toosee ntɛ. Ɩlɛnɑ ɩ́ mǝlɩ Yosɑlɛm, nɑ ɩ́ lɑ́ ɩ wɑɑlɩ nyǝ́mɑ tǝnɑɣɑ ɑcimɑ. ");
INSERT INTO dop_vpl VALUES ("K13_16","012_3_16","1KI","3","16","16","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ ɑpɑlɑɑ tǝnɑ ɑlɑɑ nɑpǝlɩ pɑ polɑ wulɑʋ tɛɣɛ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("K13_17","012_3_17","1KI","3","17","17","Ɩlɛnɑ pɑ tɑɑ lɛlʋ tɔ sɩ: Hɑɩ, mɑ́ lɑ-ŋ kɑɑfɑlɑ tɑ́ cɑɑ. Mɑ nɑ ɑlʋ ɩnɛ tǝ wɛnnɑ tǝyɑɣɑ kʋlʋmɑɣɑ tɑɑ, nɑ mɑ́ lʋlɩ ɑpɑlʋpǝyɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K13_18","012_3_18","1KI","3","18","18","Kʋyɛɛŋ nɑɑlɛ tɛɛwɑ, ɩlɛnɑ ɩnɩ ɩ́ lʋlɩ ɑpɑlʋ tɔtɔ. Nɑ tɑ nɑɑlɛ tǝ́ wɛɛ mpʋ. Kpɑɩ tʋ nɔɣɔlʋ tɑ sɔɔsɩ tɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K13_19","012_3_19","1KI","3","19","19","Ḿpʋ́ɣʋ́ ɩ hǝntɑ ɩ pǝyɑɣɑ tɔɔ kɛ́ ɑhoo nɑ kɑ́ sɩ́. ");
INSERT INTO dop_vpl VALUES ("K13_20","012_3_20","1KI","3","20","20","Ɩlɛnɑ ɩ́ kpɑɣɑ mɑ pǝyɑɣɑ nɑ ɩ́ hɩɩsɩ ɩ kɔŋkɔŋ tɑɑ, nɑ ɩ́ hɩɩsɩ kʋsǝpɑɣɑ kɛ mɑ kɔŋkɔŋ tɑɑ, nɑ mɑ́ɑ́ tɔŋnɑ tom. ");
INSERT INTO dop_vpl VALUES ("K13_21","012_3_21","1KI","3","21","21","Pǝ nyɑɑlɑɑ sɩ mɑ́ cɛlǝɣɩ pǝyɑɣɑ kɛ hǝtɛ, ɩlɛnɑ mɑ́ mɑɣɑnɑ sǝtʋ. Mɑ nyǝnɑ-kɛɣɛ teu, ɩlɛnɑ mɑ́ cɛkǝnɑ sɩ pǝ tɑɣɑ mɑ nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("K13_22","012_3_22","1KI","3","22","22","Tǝnɑɣɑlɛ ɑlʋ lɛlʋ sɩ: Aɑɩ yoo, mɑ pǝyɑɣɑ ntɛ́ weesuɣu nyǝŋkɑ, nyɑ́ nyǝŋkɑ ntɛ́ kʋsǝpɑɣɑ. Ntɛnɑ kɑncɑɑlɑɣɑ nyǝŋ sɩ: Pɔpɔtʋ kɛ́. Nyɑ́ pǝyɑɣɑ sǝpǝnɑ, mɑ nyǝŋkɑ ntɛ́ weesuɣu nyǝŋkɑ. Ɩlɛnɑ pɑ́ nɑɑlɩ ḿpʋ́ɣʋ́ hɔm kɛ wulɑʋ ɩsɛntɑɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("K13_23","012_3_23","1KI","3","23","23","Ntɛnɑ wulɑʋ tɔ́ sɩ: Lɛlʋ nɑ́ tɔŋ sɩ, mɑ pǝyɑɣɑ ntɛ́ weesuɣu nyǝŋkɑ, nyɑ́ nyǝŋkɑ ntɛ́ kʋsǝpɑɣɑ. Ɩnɛ ɩ́lɛ́ sɩ, pɔpɔtʋ kɛ́, nyɑ́ pǝyɑɣɑ ntɛ́ kʋsǝpɑɣɑ, mɑ nyǝŋkɑ ntɛ́ weesuɣu nyǝŋkɑ. ");
INSERT INTO dop_vpl VALUES ("K13_24","012_3_24","1KI","3","24","24","Tɔʋ, ye mpʋ ɩ́ kɔnɑ-m lɑɣɑtɛ. Pɑ ponɑ wulɑʋ kɛ lɑɣɑtɛ, ");
INSERT INTO dop_vpl VALUES ("K13_25","012_3_25","1KI","3","25","25","ɩlɛnɑ ɩ́ tɔ sɩ: Ɩ́ fɑɣɑ weesuɣu nyǝŋkɑ kɛ cɑlɩ nɑ ɩ́ tɑlɑ-wɛɣɛ hɔɣɔlʋɣʋ hɔɣɔlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K13_26","012_3_26","1KI","3","26","26","Tǝnɑɣɑlɛ pǝ lɑpɑ weesuɣu pǝyɑɣɑ too tɑɑ kɛ́ pʋlʋɣʋ ɩ pǝyɑɣɑ tɔm, nɑ ɩ́ tɔ sɩ: Hɑɩ, wulɑʋ cɛlɛ-ɩ pǝyɑɣɑ ŋkɛ, tɑɑ kʋ-kɛ. Ntɛnɑ ɑlʋ lɛlʋ sɩ: Yɛɛ, sɛtɩ-kɛ, nɑ tɑ nɑɑlɛ tǝ lɑŋ. ");
INSERT INTO dop_vpl VALUES ("K13_27","012_3_27","1KI","3","27","27","Ḿpʋ́ɣʋ́ wulɑʋ sɩ: Ɩ́ cɛlɑ kɑncɑɑlɑɣɑ nyǝŋ kɛ pǝyɑɣɑ, ɩ́ tɑɑ kʋ-kɛ, kɑ too kɛlɛ. ");
INSERT INTO dop_vpl VALUES ("K13_28","012_3_28","1KI","3","28","28","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ nɩɩ wulɑʋ hʋʋlɛ ntɛ́, nɑ pɑ́ nɑ́ sɩ, Tɑcɑɑ tʋ-ɩ lɑɣɑtʋ, nɑ ɩ́ tǝŋǝɣɩ tɑmpɑnɑ nɑ ɩ́ hʋʋkǝnɑ. Ɩlɛnɑ pɑ́ nyɑŋnɑ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("K14_1","012_4_1","1KI","4","1","1","Ɩsɛɣɛlɩ tǝnɑ tɔɔ kɛ́ wulɑʋ Sɑlʋmɔŋ tɔkɑɣɑ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K14_2","012_4_2","1KI","4","2","2","Ɩ wɑɑlɩ nyǝ́mɑ hǝlɑ nɑ pɑ tǝmɑ ntɔ. Sɑtɔkɩ pǝyɑlʋ Asɑliyɑ kɛlɛ kɔtʋlʋ. ");
INSERT INTO dop_vpl VALUES ("K14_3","012_4_3","1KI","4","3","3","Sisɑ pǝyɑlʋ Ɩliholɛfɩ nɑ Ahiyɑ pɛlɛɣɛlɛ tɑkǝlɑsɩ ŋmɑɑlɑɑ. Ahiluti pǝyɑlʋ Yosɑfɑtɩ kɛlɛ tɑkǝlɑsɩ sɩɩlʋ. ");
INSERT INTO dop_vpl VALUES ("K14_4","012_4_4","1KI","4","4","4","Yoyɑtɑ pǝyɑlʋ Penɑyɑ kɛlɛ yoolɑɑ wulɑʋ. Sɑtɔkɩ nɑ Apiyɑtɑɑ kɛlɛ kɔtǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("K14_5","012_4_5","1KI","4","5","5","Nɑtɑŋ pǝyɑlʋ kɑncɑɑlɑɣɑ nyǝŋ Asɑliyɑ kɛlɛ kʋmɑtɑŋnɑɑ nyʋɣʋ tʋ. Nɑɑlɛ nyǝŋ Sɑpu kɛlɛ wulɑʋ kʋpɑɣɑlʋ. ");
INSERT INTO dop_vpl VALUES ("K14_6","012_4_6","1KI","4","6","6","Ahisɑɑ kɛlɛ kɑwulɑɣɑ tǝyɑɣɑ nyʋɣʋ tʋ. Apitɑ pǝyɑlʋ Atonilɑm kɛlɛ tǝlɑsɩ tǝmɑ nyʋɣʋ tʋ. ");
INSERT INTO dop_vpl VALUES ("K14_7","012_4_7","1KI","4","7","7","Sɑlʋmɔŋ kɑ wɛnɑ kʋmɑtɑŋnɑɑ nyʋɣʋ nyǝ́mɑ kɛ nɑɑnʋwɑ nɑ nɑɑlɛɣɛ Ɩsɛɣɛlɩ tɛtʋ tǝnɑ tɑɑ kɛ́. Pǝ wɛɛ sɩ pɑɑ wei ɩ́ cɛlɑ wulɑʋ nɑ ɩ kɑwulɑɣɑ tǝyɑɣɑ nyǝ́mɑ pɑ ɩsɔtʋ kʋlʋm tɔɣɔnɑɣɑ kɛ pǝnɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K14_8","012_4_8","1KI","4","8","8","Hɑlɩ pɑ hǝlɑ nɑ pɑ tɛtʋnɑɑ hǝlɑ ntɔ. Huuu pǝyɑlʋ kɛ́ Ɩfǝlɑyim pɔɔŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K14_9","012_4_9","1KI","4","9","9","Teke pǝyɑlʋ kɛ́ Mɑkɑtɩ, nɑ Sɑɑlǝpim, nɑ Pɛtɩ-Sɛmɛsɩ, nɑ Ɩlɔŋ-Pɛtɩ-Hɑnɑŋ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K14_10","012_4_10","1KI","4","10","10","Hɛsɛtɩ pǝyɑlʋ kɛ́ Alupotɩ ɩcɑtɛ tɑɑ. Ɩ́lɛ́ ɩ kɑ tǝnnɑ Soko nɑ Hefɛɛ tɛtʋ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("K14_11","012_4_11","1KI","4","11","11","Apinɑtɑpɩ pǝyɑlʋ kɑ tǝnnɑ ntɛɣɛ Tɔɔɔ pɔɔŋ hɔɣɔlʋɣʋ tǝnɑ. Ɩ́lɛ́ ɩ kɑ kpɑɣɑnɑ Sɑlʋmɔŋ pɛɛlɔ Tɑfɑ. ");
INSERT INTO dop_vpl VALUES ("K14_12","012_4_12","1KI","4","12","12","Ahiluti pǝyɑlʋ Pɑɑnɑ kɑ tǝnnɑ Tɑɑnɑkɩ, nɑ Mekito, nɑ Pɛtɩ-Seyɑŋ tɛtʋ tǝnɑ. Hɔɣɔlʋɣʋ ŋkʋ kʋ kpǝtǝnɑ Sɑɑtɑŋ kɛ Sisilee tɑpʋɣʋ tɛɛ kɛ́ pǝ kpɑɣɑʋ Pɛtɩ-Seyɑŋ tɔ, nɑ pǝ́ polo Apɛɛlɩ-Meholɑ, hɑlǝnɑ Yɔkǝneyɑm. ");
INSERT INTO dop_vpl VALUES ("K14_13","012_4_13","1KI","4","13","13","Lɑmɔtɩ tʋ Kepɛɛ pǝyɑlʋ kɑ tǝnnɑ Kɑlɑɑtɩ tɛtʋ tǝnɑ, nɑ Mɑnɑsee pǝyɑlʋ Yɑyii ɑcɑlisi tǝnɑɣɑ Kɑlɑɑtɩ tɛtʋ tɑɑ, nɑ Alǝkɔpɩ hɔɣɔlʋɣʋ kɛ Pɑsɑŋ, nɑ pǝ koloosi ɑcɑlɛɛ sɔsɔɔnɑ nɩɩtoso, wenɑ pɑ tǝkɑ nyǝɣǝtʋ kʋsɛɛmtʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K14_14","012_4_14","1KI","4","14","14","Itoo pǝyɑlʋ Ahinɑtɑpɩ tǝnnɑ Mɑhɑnɑyim tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("K14_15","012_4_15","1KI","4","15","15","Asimɑɑtɩ tǝnnɑ ntɛɣɛ Nɛfǝtɑli tɛtʋ, ɩ́lɛ́ ɩ kpɑɣɑ tɔtɔɣɔ Sɑlʋmɔŋ pɛɛlɔ lɛlʋ Pɑsǝmɑtɩ. ");
INSERT INTO dop_vpl VALUES ("K14_16","012_4_16","1KI","4","16","16","Husɑyi pǝyɑlʋ Pɑɑnɑ tǝnnɑ Asɛɛ nɑ Peyɑlɔtɩ pǝ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("K14_17","012_4_17","1KI","4","17","17","Pɑluyɑ pǝyɑlʋ Yosɑfɑtɩ tǝnnɑ ntɛɣɛ Ɩsɑkɑɑ tɛtʋ. ");
INSERT INTO dop_vpl VALUES ("K14_18","012_4_18","1KI","4","18","18","Ɩlɑ pǝyɑlʋ Simeyi kɛlɛ Pɛncɑmɛɛ nyǝntʋ. ");
INSERT INTO dop_vpl VALUES ("K14_19","012_4_19","1KI","4","19","19","Ulii pǝyɑlʋ Kepɛɛ kɛlɛ Kɑlɑɑtɩ tɛtʋ nɑ pǝ́ kpɛnnɑ Amolii nyǝ́mɑ wulɑʋ Sihoŋ, nɑ Pɑsɑŋ wulɑʋ Oki pɑ tɛtʋ. Pǝ́cɔ́ pǝ́ kɑɑsɩ kʋmɑtɑŋnɑɑ nyʋɣʋ tʋ lɛlʋ kɛ Yutɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","Yutɑ nɑ Ɩsɛɣɛlɩ pǝ yǝlɑɑ kɑ wɛ pɑɣɑlɛ kɛ́ ɩsɩɩ kɑnyǝŋɑ, nɑ pɑ́ tɔkɩ nɑ pɑ́ nyɔɔkɩ nɑ pɑ lɑŋɑ hɛɛwɑ. ");
INSERT INTO dop_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Sɑlʋmɔŋ kɑ ŋmɑkǝlǝnɑ tɛtʋ tǝnɑɣɑ wɑɑtʋ ɩnɩ. Pǝ kpɑɣɑʋ Ɩfǝlɑtɩ pɔɣɔ, nɑ pǝ́ yoosinɑ Filiisi nyǝ́mɑ tɛtʋ, hɑlǝnɑ Icipiti tɛtʋ toŋɑ tɔ. Nɑ tɛtʋ ntɩ tǝ nyǝ́mɑ fɛlǝɣɩ Sɑlʋmɔŋ kɛ lɑmpuunɑɑ, hɑlǝnɑ ɩ sǝm. ");
INSERT INTO dop_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Pɑɑ ɩfemle nte tɔɣɔnɑɣɑ ŋkɑ Sɑlʋmɔŋ nɑ ɩ tǝyɑɣɑ nyǝ́mɑ pɑ́ tɔkɩ tɔɣɔlɔ. Mʋlʋm kʋnyɑɑlǝm tɔɔnǝnɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ, nɑ mʋlʋm kʋkpǝsǝm kɛ tɔɔnǝnɑɑ pǝlefɛɩ hiu. ");
INSERT INTO dop_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","Nɑ nɑɑŋ wei pɑ tʋ tɔɣɔnɑɣɑ kʋpɑŋkɑ nɑ ɩ́ lɑ́ nim tɔɣɔ nɑɑnʋwɑ, nɑ nɑɑŋ wei pɑ lǝsɑ ntiɣile tɑɑ tɔɣɔ hiu, nɑ heeŋ kɛ nɩɩnʋwɑ (100). Pǝ́cɔ́ pǝ́ kɑɑsɩ nɑmǝŋ wɑɑnɩ wɑɑnɩ kɛ tɔm tooso, nɑ kɑmpee kʋpɑnɑ. ");
INSERT INTO dop_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Sɑlʋmɔŋ ŋmɑkǝlɑɣɑnɑ pɔɣɔ Ɩfǝlɑtɩ ilim tǝtʋlɛ tɛtʋ tǝnɑ. Pǝ kpɑɣɑʋ Tifǝsɑ nɑ pǝ́ polo Kɑsɑ tɔ, nɑ pɑ ɑwulɑɑ tǝnɑ. Ɩlɛnɑ ɩ́ cɑɣɑnɑ ɩ tǝɣɩ tɛtʋnɑɑ mpɑ pɑ cɔɔnɑ-ɩ tɔ pɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Yutɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ kɑ cɑɣɑnɑ pɑ tǝɣɩ, nɑ pɑɑ wei ɩ́ hɑlǝɣɩ tɩɩŋ wei pɑ yɑɑ sɩ lɛsɛŋnɑɑ nɑ fikinɑɑ tɔɣɔ ɩsǝnɑ ɩ cɑɑkɩ tɔ, hɑlǝnɑ Sɑlʋmɔŋ sǝm. ");
INSERT INTO dop_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","Sɑlʋmɔŋ kɑ wɛnɑ yoou kɛɛkɛnɑɑ kpɑɣɑnǝŋ kɛ iyisi nɩɩlɛ (40000) nɑ kpɑɣɑnǝŋ kʋcɑcɑɣɑŋ kɛ iyisi nɑɑnʋwɑ nɑ nɑɑlɛ (12000). ");
INSERT INTO dop_vpl VALUES ("K15_7","012_5_7","1KI","5","7","7","Kʋmɑtɑŋnɑɑ nyʋɣʋ nyǝ́mɑ nɑɑnʋwɑ nɑ nɑɑlɛ kɑ pɑɑsɑɣɑnɑnɑ wulɑʋ tǝyɑɣɑ tɔɣɔnɑɣɑ tɔm. Pɑɑ wei nɑ ɩ ɩsɔtʋ, pʋlʋ tɑɑ lɑŋǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("K15_8","012_5_8","1KI","5","8","8","Pɑ kɔŋɑɣɑnɑ tɔɣɔnɑɣɑ pee, nɑ cɑmtʋ kɛ kpɑɣɑnǝŋ, nɑ tɔlɑ wenɑ ɑ lɑkɩ tǝmɑ tɔɣɔ timpi wulɑʋ kɑ wɛɛ tɔɣɔ teitei kɛ́ ɩsɩɩ pɑɑ kɛɛsɑ-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("K15_9","012_5_9","1KI","5","9","9","Ḿpʋ́ɣʋ́ Ɩsɔ hɑ Sɑlʋmɔŋ kɛ nyǝm nɑ lɑɣɑtʋ sɔsɔɔntʋ nɑ ɩ́ nyɩ yɑɑsinɑɑ kɛ wɑɑnɩ wɑɑnɩ, pǝ fɛɩ kɑlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K15_10","012_5_10","1KI","5","10","10","Ɩ kɑ́ kǝlɑ ilim tǝlɩɩlɛ tɔɔ lɑɑlupunɑɑ nɑ Icipiti nyǝ́mɑ tǝnɑɣɑ nyǝm kɛ́. ");
INSERT INTO dop_vpl VALUES ("K15_11","012_5_11","1KI","5","11","11","Ɩ́ nɑ yʋlʋ nɔɣɔlʋ pɑ tɑɑ kɛɛsǝɣɩ nyǝm. Hɑlɩ ɩ tɛɛ Ɩsǝlɑhi tʋ Ɩtɑŋ nɑ Mɑhɔɔlɩ pǝyɑlɑɑ Hemɑŋ nɑ Kɑlǝkɔlɩ nɑ Tɑɑtɑ. Ɩ hǝtɛ yɑɑwɑ piitimnɑɑ mpɑ pɑ cɔɔnɑ-ɩ tɔ pɑ tɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("K15_12","012_5_12","1KI","5","12","12","Atuwɑ iyisi toosoɣo (3000) Sɑlʋmɔŋ tukɑɑ nɑ ɩ́ lu yontunɑɑ iyɑɣɑ (1000). ");
INSERT INTO dop_vpl VALUES ("K15_13","012_5_13","1KI","5","13","13","Sɑlʋmɔŋ yɔɣɔtɑ tɩɩŋ sɔsɔɔŋ kʋpɑmpɑŋ tɔm, nɑ ɩ́ kpɛnnɑ nyɩɩlisi nsi sɩ nyɔɔkɩ kutuluŋ kilɑ tɔ sɩ tɔm nɑ ɩ́ yɔɣɔtɩ. Nɑ ɩ́ yɔɣɔtɩ tɔlɑ, nɑ tɑɑlɛ wontu, nɑ sumɑsɩ nɑ ɑtɛ nyɑmɑnyɑmɑnɑɑ nɑ tiinɑ pǝ tɔm. ");
INSERT INTO dop_vpl VALUES ("K15_14","012_5_14","1KI","5","14","14","Antulinyɑ ɑwulɑɑ yǝlɑɑ tǝnɑ kɔŋɑɣɑ kɛ́ nɑ pɑ́ nɩɩkɩ Sɑlʋmɔŋ nyǝm tɔm. ");
INSERT INTO dop_vpl VALUES ("K15_15","012_5_15","1KI","5","15","15","Tiii wulɑʋ Hilɑm nɩɩwɑ sɩ Sɑlʋmɔŋ kɛ pɑ kpɑ kɑwulɑɣɑ, nɑ pɑ́ lɛɛtɩ ɩ cɑɑ Tɑfiiti lonte, ɩlɛnɑ Hilɑm tili ɩ wɑɑlɩ nyǝ́mɑ sɩ pɑ́ sɛɛ-ɩ. Mpi tɔ, ɩ ceu ntɛ́ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("K15_16","012_5_16","1KI","5","16","16","Mpʋɣʋlɛ Sɑlʋmɔŋ tilɑɑ nɑ pɑ heeli Hilɑm sɩ: ");
INSERT INTO dop_vpl VALUES ("K15_17","012_5_17","1KI","5","17","17","Mɑ cɑɑ Tɑfiiti tɑ pǝsɩ nɑ ɩ́ ŋmɑ́ Ɩsɔ Tɑcɑɑ kɛ tǝsɛɛlɛ. Mpi tɔ, ɩ kolontunɑɑ kɑ tɑmɑ-ɩ kɛ́, nɑ pɑ́ yookinɑ-ɩ tɑm. Hɑlǝnɑ Ɩsɔ yele nɑ ɩ́ kǝlɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("K15_18","012_5_18","1KI","5","18","18","Amɑ pǝnɛntɛ mɑ Ɩsɔ Tɑcɑɑ yelɑɑ nɑ mɑ hɛɛsɩ pǝ tǝnɑ pǝ tɑɑ. Mɑ fɛɩ kolontu, pǝ́cɔ́ mpusi nɔɣɔlʋ ɩ fɛɩ. ");
INSERT INTO dop_vpl VALUES ("K15_19","012_5_19","1KI","5","19","19","Hɑlɩ mɑ́ mɑɣɑsɩ mɑ tɑɑ sɩ mɑɑ ŋmɑ́ Ɩsɔ Tɑcɑɑ kɛ tǝsɛɛlɛ. Ḿpʋ́ɣʋ́ Ɩsɔ kɑ heelɑ mɑ cɑɑ sɩ: Nyɑ́ pǝyɑɣɑ ŋkɑ kɑɑ lɛɛtɩ nyɑ́ lonte tɔ ŋkɛ kɑɑ ŋmɑnɑ-tɛ. ");
INSERT INTO dop_vpl VALUES ("K15_20","012_5_20","1KI","5","20","20","Mpʋ tɔ, yele nɑ mɑ tǝmlɛ nyǝ́mɑ mɑɣɑnɑ nyɑ́ nyǝ́mɑ, nɑ pɑ́ sɛtɩ-m tɩɩŋ sɔsɔɔŋ wei ɩ wɛ Lipɑŋ tɔ. Ɩlɛnɑ n heeli-m ɩsǝnɑ mɑɑ fɛlɩ nyɑ́ tǝmlɛ nyǝ́mɑ tɔ. Mpi tɔ, nɔɣɔlʋ tɑ nyɩ tɩɩŋ sɛtʋɣʋ, ɩsɩɩ Fenisii nyǝ́mɑ mpɛ. ");
INSERT INTO dop_vpl VALUES ("K15_21","012_5_21","1KI","5","21","21","Hilɑm nɩɩ mpʋ, ɩlɛnɑ ɩ lɑŋlɛ hʋlʋmɩ sɔsɔm nɑ ɩ́ sɑ Ɩsɔ sɩ: Tɑcɑɑ kɛlɛ teeli tʋ. Ɩnɩ ɩ hɑnɑ Tɑfiiti kɛ pǝyɑɣɑ nyǝntʋ ɩnɛ sɩ, ɩ́ tɔɣɔ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K15_22","012_5_22","1KI","5","22","22","Ɩlɛnɑ ɩ́ tili nɑ ɩ́ heeli Sɑlʋmɔŋ sɩ: Mɑ nɩɩwɑ nti n tilɑɑ sɩ pɑ́ heeli-m tɔ. Mɑɑ lɑ teitei ɩsɩɩ n cɑɑ tɔɣɔ tɩɩŋ sɔsɔɔŋ ɩnɩ ɩ tɔm tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K15_23","012_5_23","1KI","5","23","23","Mɑ tǝmlɛ nyǝ́mɑ kɑ́ kpɑɣɑ-ɩ nɑ pɑ́ tiinɑ teŋku nɔɣɔ. Ɩlɛ kɛɛsɩ-m timpi n cɑɑ-ɩ tɔ. Nɑ mɑ́ tʋ-ɩ lʋm tɑɑ, nɑ ɩ́ tɑlɑ tǝnɑ, ɩlɛnɑ ń kpɑɣɑ. Mpi mɑ cɑɑ sɩ ń fɛlɩ-m tɔɣɔlɛ mɑ kɑwulɑɣɑ tǝyɑɣɑ nyǝ́mɑ tɔɣɔnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K15_24","012_5_24","1KI","5","24","24","Ḿpʋ́ɣʋ́ Hilɑm hɑwɑ Sɑlʋmɔŋ kɛ tɩɩŋ sɔsɔɔŋ kʋpɑŋ ɩnǝɣɩ ɩsǝnɑ Sɑlʋmɔŋ cɑɑkɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("K15_25","012_5_25","1KI","5","25","25","Ɩlɛnɑ Sɑlʋmɔŋ nɑ́ɑ́ hɑɑkɩ-ɩ pɑɑ pǝnɑɣɑ ŋkɑɣɑ tɔɣɔnɑɣɑ pee kɛ tɔɔnǝnɑɑ kɛ iyisi nɑɑtoso (6000) nɑ olifinɑɑ nim kʋpɑm kɛ liitilinɑɑ iyisi pǝlefɛɩ nɑɑnʋwɑ (8000). ");
INSERT INTO dop_vpl VALUES ("K15_26","012_5_26","1KI","5","26","26","Tɑcɑɑ kɑ hɑwɑ Sɑlʋmɔŋ kɛ nyǝm kɛ́ ɩsɩɩ ɩ kɑ heeluɣu-ɩ tɔ. Ɩlɛnɑ hɛɛsʋɣʋ kɔɔ ɩ́ nɑ Hilɑm pɑ hɛkʋ nɑ pɑ́ pɛɛlɩ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("K15_27","012_5_27","1KI","5","27","27","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ lǝsɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tɑɑ kɛ́ tǝmlɛ lɑtɑɑ kɛ yǝlɑɑ iyisi hiu nɑ nɑɑnʋwɑ (30000). ");
INSERT INTO dop_vpl VALUES ("K15_28","012_5_28","1KI","5","28","28","Nɑ pɑ́ puki Lipɑŋ kɛ yǝlɑɑ iyisi nɑɑnʋwɑ nɑɑnʋwɑ (10000) kɛ́ ɩsɔtʋ ɩsɔtʋ, nɑ pɑ́ lɑkɩ tǝmlɛ kɛ pɑ nyʋɣʋ tʋ Atonilɑm kiŋ. Ɩlɛnɑ pɑ́ kpeŋ pɑ tɛɣɛ ɩsɔtʋnɑɑ nɑɑlɛ nɑɑlɛ nɑ pɑ́ hɛɛsǝɣɩ. ");
INSERT INTO dop_vpl VALUES ("K15_29","012_5_29","1KI","5","29","29","Pǝ kɑɑsɑ sǝɣǝllɑɑ kɛ yǝlɑɑ iyisi nɩɩtoso nɑ nɑɑnʋwɑ (70000) nɑ pɛɛ sɑɑkǝlɑɑ kɛ yǝlɑɑ iyisi nɩɩnɑɑsɑ (80000) kɛ́ pʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K15_30","012_5_30","1KI","5","30","30","Pǝ́cɔ́ pǝ́ kɑɑsɩ kʋmɑtɑŋnɑɑ sɔsɑɑ wɑɑlɩ nyǝ́mɑ kɛ iyisi tooso nɑ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (3300). Sɑlʋmɔŋ kɑ sɩɩnɑ-wɛ sɩ pɑ́ feŋiɣi tǝmlɛ nyǝ́mɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K15_31","012_5_31","1KI","5","31","31","Ḿpʋ́ɣʋ́ wulɑʋ tɔmɑ sɩ pɑ́ lǝsɩ pɛɛ sɔsɔɔnɑ kʋpɑnɑ nnɑ pɑ sɑɑkɑɑ tɔ, nɑ pɑ́ sɩɩnɑ Ɩsɔ tǝsɛɛlɛ kite. ");
INSERT INTO dop_vpl VALUES ("K15_32","012_5_32","1KI","5","32","32","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ tǝmlɛ nyǝ́mɑ, nɑ Hilɑm tǝmlɛ nyǝ́mɑ, nɑ Pipǝlɔsɩ ɩcɑtɛ nyǝ́mɑ pɑ́ sɑɑkɑ pɛɛ ɑnɩ nɑ kpoŋkpolonɑɑ mpɑ pɑɑ ŋmɑnɑ Ɩsɔ tǝsɛɛlɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ cɑɑlɑ Ɩsɔ tǝsɛɛlɛ ŋmɑʋ tǝmlɛ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ Icipiti tɑɑ lɩɩʋ pǝnɑɣɑ nɑsǝlɛ nɑ nɩɩnɑɑsɑ (480) nyǝŋkɑ tɑɑ. Sɑlʋmɔŋ kɑwulɑɣɑ pǝnɑɣɑ liɣiti nyǝŋkɑ ntɛ́ nɑ ɩsɔtʋnɑɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("K16_2","012_6_2","1KI","6","2","2","Kutuluɣu ŋku Sɑlʋmɔŋ ŋmɑ́ Tɑcɑɑ tɔ kʋ tɑɣɑlǝŋ wɛ mɛɛtǝlǝnɑɑ hiu nɑ nɑɑnʋwɑ, nɑ kʋ wɑŋ kɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ, nɑ kʋ kʋŋkʋlʋmǝŋ kɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("K16_3","012_6_3","1KI","6","3","3","Nɑŋ sǝkpeluɣu ŋku n tɑkɩ nɑ pǝ́cɔ́ ń tɛɛ Ɩsɔ tǝsɛɛlɛ mɑɣɑmɑɣɑ tɑɑ tɔ, kʋlɛ kʋ tɑɣɑlǝŋ wɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ kɛ́ teitei ɩsɩɩ Ɩsɔ tǝsɛɛlɛ wɑŋ wɛʋ tɔ. Nɑ kʋ wɑŋ tɔɔ kɛ́ mɛɛtǝlǝnɑɑ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("K16_4","012_6_4","1KI","6","4","4","Nɑ pɑ́ tʋ́ kʋ pǝtolee kɛ nyǝɣǝtʋ. ");
INSERT INTO dop_vpl VALUES ("K16_5","012_6_5","1KI","6","5","5","Ḿpʋ́ɣʋ́ ɩ mɑlǝsǝnɑ Ɩsɔ tǝsɛɛlɛ, nɑ ɩ nɑŋ lɔlɔ nyǝŋkʋ koloosi nɑ ɑwɑlɩ tɔɔ kɛ́ ɑtɛ nɑ ɩsɔ kutuluɣu nɑ pǝ́ cɔɔ. Kʋ kutuluŋ wɛ nɑɑlɛ, ɑtɛ nyǝŋkʋ pɑɑsi. ");
INSERT INTO dop_vpl VALUES ("K16_6","012_6_6","1KI","6","6","6","Atɛ nɑ ɩsɔ kutuluɣu ɑtɛ nyǝŋkʋ wɑŋ wɛ mɛɛtǝlǝnɑɑ nɑɑlɛ nɑ hɔɣɔlʋɣʋ. Kɑncɑɑlɑɣɑ nyǝŋkʋ kɛ mɛɛtǝlǝnɑɑ tooso. Pǝ tɔɔ nyǝŋkʋ kɛ mɛɛtǝlǝnɑɑ tooso nɑ hɔɣɔlʋɣʋ. Ɩsɔ tǝsɛɛlɛ koluŋɑ yɑsǝlɑɣɑ fɛɩ kʋlʋmɑɣɑ. Kɑ yɑsǝlɑ pǝ tɛɛ kɛ́ nɑ kɑ́ ŋmɩɩkǝnɑ ɩsɔ. Pɑ ŋmɑ-kɛɣɛ ḿpʋ́ɣʋ́ nɑ pɑ́ sɛkǝɣɩ sɩ pɑ́ hiki lonɑ wenɑ ɑ tɑɑ pɑɑ tǝnɩ ɑtɛ nɑ ɩsɔ kutuluŋ pɑtɑnɑɑ kpɑtǝŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K16_7","012_6_7","1KI","6","7","7","Pɑɑ tɛmɑ pɛɛ wenɑ pɑ ŋmɑɑkɑɣɑnɑ Ɩsɔ tǝsɛɛlɛ kɛ mpʋ tɔɣɔ sɑɑkʋɣʋ kɛ́. Pǝ tɔɔ kɛ́ pɑ tɑ lɑnɑ lɑɑlɛ, yɑɑ mɑɑlǝtoo, yɑɑ nyǝɣǝlʋɣʋ nɑkʋlǝɣɩ ŋmɑʋ wɑɑtʋ. ");
INSERT INTO dop_vpl VALUES ("K16_8","012_6_8","1KI","6","8","8","Ɩsɔ tǝsɛɛlɛ ilim mpǝtǝŋ tɔɔ kɛ́ ɑtɛ nɑ ɩsɔ kutuluɣu ɑtɛ nyǝŋkʋ nɔnɔɔsɩ kɑ wɛnnɑɑ. Nɑ tǝnɑɣɑ pɑ lɑpɑ ɑtɛ nɑ ɩsɔ kutuluŋ ɩnɩ ɩ tǝkpɑlɛ nte yʋlʋ kpɑɑkɩ nɑ ɩ́ cɔɔkɩ kilikite tɔ. ");
INSERT INTO dop_vpl VALUES ("K16_9","012_6_9","1KI","6","9","9","Pɑ tɛmɑ-ɩ ŋmɑʋ, ɩlɛnɑ pɑ́ tʋ́ ɩ pɑtɑnɑɑ kɛ tɩɩŋ kʋpɑŋ kpeŋkpelɑsɩ. ");
INSERT INTO dop_vpl VALUES ("K16_10","012_6_10","1KI","6","10","10","Atɛ nɑ ɩsɔ kutuluɣu ŋku pɑ mɑlǝsǝnɑ Ɩsɔ tǝsɛɛlɛ koloosi kɛ mpʋ, nɑ pǝ́ cɔɔ tɔ, kʋ kʋŋkʋlʋmǝŋ kɑ wɛ mɛɛtǝlǝnɑɑ nɑɑlɛ nɑ hɔɣɔlʋɣʋ hɔɣɔlʋɣʋ. Ḿpʋ́ɣʋ́ pɑ tǝnɑ pɑtɑnɑɑ kpɑtǝŋ kɛ Ɩsɔ tǝsɛɛlɛ koluŋɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɔmɑ Sɑlʋmɔŋ sɩ: ");
INSERT INTO dop_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","Ɩsɩɩ n ŋmɑɑkʋɣʋ-m Ɩsɔ tǝsɛɛlɛ tǝnɛ ɩsǝntɔ tɔ, ye n tǝŋɑ mɑ kiiŋ, nɑ ń tɔkǝɣɩ mɑ kʋtʋtʋtʋ, nɑ mɑ kʋsǝsɩɩtʋ, mɑɑ lɑ-ŋ nti mɑɑ sɩɩ nyɑ́ cɑɑ Tɑfiiti tɔ. ");
INSERT INTO dop_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Mɑɑ kɔɔ nɑ mɑ́ cɑɣɑ mɑ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ hɛkʋ, mɑ kɑɑ lɔ-wɛ. ");
INSERT INTO dop_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Pɑ tɛmɑ Ɩsɔ tǝsɛɛlɛ ŋmɑʋ, ɩsɩɩ Sɑlʋmɔŋ kɑ́ kɛɛsʋɣʋ-wɛ tɔ. Ɩlɛnɑ ");
INSERT INTO dop_vpl VALUES ("K16_15","012_6_15","1KI","6","15","15","pɑ́ mɑtɩ kpeŋkpelɑsɩ toŋ nyǝnsɩ kɛ kutuluɣu koloosi tɔɔ nɑ pǝ tɑɑ tɔɔ kɛ́ pǝ kpɑɣɑʋ ɑtɛ nɑ pǝ́ yoosinɑ pɑtɑ tɔ, nɑ pɑ́ pɔ-sɩ tɔtɔɣɔ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("K16_16","012_6_16","1KI","6","16","16","Ɩlɛnɑ pɑ́ cosi Ɩsɔ tǝsɛɛlɛ kɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ nɑ pɑ́ kɑɣɑ kpeŋkpelɑsɩ toŋ nyǝnsɩ sɩ pɑ sɩɩkɩ Ɩsɔ ɑtɑkɑɑ. Ɩlɛnɑ pɑ́ hɑ tǝnɑɣɑ hǝtɛ sɩ tǝcɑɣɑlɛ kɑtɛ tɑɑ kɑtɛ nyǝntɛ. ");
INSERT INTO dop_vpl VALUES ("K16_17","012_6_17","1KI","6","17","17","Ɩlɛnɑ pǝ́ kɑɑsɩ Ɩsɔ tǝsɛɛlɛ mɑɣɑmɑɣɑ kɛ mɛɛtǝlǝnɑɑ hiu. ");
INSERT INTO dop_vpl VALUES ("K16_18","012_6_18","1KI","6","18","18","Kpeŋkpelɑsɩ toŋ nyǝnsɩ tike wɑɑsǝnɑ Ɩsɔ tǝsɛɛlɛ tɑɑ tɔɔ. Pɩɩ nɑɑkɩ pɛɛ wenɑ pɑ́ ŋmɑnɑ-tɛ tɔ. Ɩlɛnɑ pɑ́ lǝsɩ kpeŋkpelɑsɩ tɔɔ kɛ́ yɑɑyenɑɑ nɑ tɩɩŋ nɩɩlɩ ɩ pee fotoonɑɑ. ");
INSERT INTO dop_vpl VALUES ("K16_19","012_6_19","1KI","6","19","19","Ɩlɛnɑ pɑ́ tɑɣɑnɩ kɑtɛ tɑɑ kɑtɛ tǝcɑɣɑlɛ ńtɛ́ sɩ pɑ sɩɩkɩ Ɩsɔ ɑtɑkɑɑ. ");
INSERT INTO dop_vpl VALUES ("K16_20","012_6_20","1KI","6","20","21","Kutuluɣu ŋkʋ kʋ tɑɣɑlǝŋ nɑ kʋ wɑŋ kɑ wɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ nɑɑnʋwɑ kɛ́. Nɑ pɑ́ pɔ wʋlɑ kɛ kʋ tɑɑ, nɑ Ɩsɔ tǝsɛɛlɛ tɑɑ tɔtɔ. Ɩlɛnɑ pɑ́ kɑɣɑ wʋlɑ ɑlukpɑlɑ kɛ kʋ nɔɣɔ. Nɑ pɑ́ sɩɩ tǝnɑ tɔtɔɣɔ kɔtɑɣɑ tǝlɑtɛ nte pɑ kɑmɑ tɑɑsɩ nɑ pɑ́ wɑɑsɩ-tɛɣɛ wʋlɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K16_22","012_6_22","1KI","6","22","22","Ɩsɔ tǝsɛɛlɛ tǝnɑ nɑ kɔtɑɣɑ tǝlɑtɛ kɛ pɑ pɔwɑ wʋlɑ. ");
INSERT INTO dop_vpl VALUES ("K16_23","012_6_23","1KI","6","23","26","Ḿpʋ́ɣʋ́ pɑ sɑɑkɑ tʋɣʋ ŋku pɑ yɑɑ sɩ Olifi tɔɣɔ ɩsɔtɑɑ tɑŋlɑɑ mpɑ pɑ yɑɑ sɩ Selupɛŋnɑɑ tɔ pɑ lɛɛsǝŋ nɑɑlɛ nɑ pǝ kʋŋkʋlʋmǝŋ kɛ mɛɛtǝlǝnɑɑ kɑkpɑsɩ sɩ pɑ sɩɩkɩ Ɩsɔ ɑtɑkɑɑ cɔlɔ. Pɑɑ wei ɩ keŋ nɑɑlɛ tɑɣɑlǝŋ kpɛntǝɣɩ mɛɛtǝlǝnɑɑ kɑkpɑsɩ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("K16_27","012_6_27","1KI","6","27","27","Ḿpʋ́ɣʋ́ pɑ sɩɩ-wɛɣɛ kɑtɛ tɑɑ kɑtɛ kutuluɣu hɛkʋ tɑɑ, nɑ pɑ́ hɛtɩ pɑ keŋ nɑ pɑ kenɔɔsɩ nɑɑlɛ suli hɛkʋ tɑɑ. Nɑ ɩnɛ ɩ nyǝŋkɑ yoosinɑ kutuluɣu nɑ cǝnɛ, nɑ ɩnɛ nɑ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("K16_28","012_6_28","1KI","6","28","28","Ɩlɛnɑ pɑ́ wɑɑsɩ-wɛɣɛ wʋlɑ. ");
INSERT INTO dop_vpl VALUES ("K16_29","012_6_29","1KI","6","29","29","Ḿpʋ́ɣʋ́ pɑ lǝsɑ ɩsɔtɑɑ tɑŋlɑɑ, nɑ pɑɑŋ fotoonɑɑ nɑ yɑɑyenɑɑ kɛ kutuluɣu koloosi tǝnɑ tɑɑ nɑ sɩ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("K16_30","012_6_30","1KI","6","30","30","Nɑ pɑ́ wɑɑsɩ wʋlɑ kɛ Ɩsɔ tǝsɛɛlɛ nɑ kɑtɛ tɑɑ kɑtɛ tǝcɑɣɑlɛ pǝ ɑtɛ. ");
INSERT INTO dop_vpl VALUES ("K16_31","012_6_31","1KI","6","31","31","Ɩlɛnɑ pɑ́ sɑɑkɩ Olifi tʋɣʋ kɛ Ɩsɔ ɑtɑkɑɑ kutuluɣu nɔnɔɣɔ kɑmpʋ kɛ kʋtǝkǝŋ nɑɑlɛ. Pɑɑ sɑɑkɑ-ɩ tuusolɑ kɑkpɑsɩ kɛ́, nɑ ɩ́ wɛ ɩsɛntɑɑ nɑ ɩsɔtɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K16_32","012_6_32","1KI","6","32","32","Ḿpʋ́ɣʋ́ pɑ lǝsɑ ɩ tɔɔ kɛ́ ɩsɔtɑɑ tɑŋlɑɑ, nɑ pɑɑŋ fotoonɑɑ, nɑ yɑɑyenɑɑ, nɑ pɑ́ wɑɑsɩ ɩsɔtɑɑ tɑŋlɑɑ nɑ pɑɑŋ kɛ wʋlɑ. ");
INSERT INTO dop_vpl VALUES ("K16_33","012_6_33","1KI","6","33","33","Tʋɣʋ ŋkʋ ɩnɩ tɔtɔɣɔ pɑ sɑɑkɑ Ɩsɔ tǝsɛɛlɛ kɑmpʋ. Ɩlɛ tuusolɑ liɣiti tike kɛ pɑ tʋ́ ɩ́lɛ́. ");
INSERT INTO dop_vpl VALUES ("K16_34","012_6_34","1KI","6","34","34","Kʋtǝkǝŋ nɑɑlɛɣɛ pɑ sɑɑkɑ-ɩ. Pɑɑ kʋtǝkʋɣʋ ŋku kʋ kpiliɣi tɔm nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("K16_35","012_6_35","1KI","6","35","35","Ɩlɛnɑ pɑ́ lǝsɩ pǝ tɔɔ kɛ́ ɩsɔtɑɑ tɑŋlɑɑ, nɑ pɑɑŋ fotoonɑɑ nɑ yɑɑyenɑɑ, nɑ pɑ́ wɑɑsɩ pɑ tɔɔ kɛ́ wʋlɑ. ");
INSERT INTO dop_vpl VALUES ("K16_36","012_6_36","1KI","6","36","36","Pǝ wɑɑlɩ kɛ́ pɑ ŋmɑ́ Ɩsɔ tǝsɛɛlɛ tɑɣɑ koluŋɑ nɑ pɛɛ kʋsɑɑkɛɛ loosi tooso, nɑ kpeŋkpelɑsɩ toŋ nyǝnsɩ kɛ looŋɑ kʋlʋmɑɣɑ nɑ pǝ cɔɔ nɑ pǝ tɑ́. ");
INSERT INTO dop_vpl VALUES ("K16_37","012_6_37","1KI","6","37","37","Sɑlʋmɔŋ kɑwulɑɣɑ pǝnɑɣɑ liɣiti nyǝŋkɑ kɛ pɑ ɩsɔtʋ nɑɑlɛ nyǝŋ tɑɑ kɛ́ pɑ sɩɩ Tɑcɑɑ Ɩsɔ tǝsɛɛlɛ kite. ");
INSERT INTO dop_vpl VALUES ("K16_38","012_6_38","1KI","6","38","38","Sɑlʋmɔŋ kɑwulɑɣɑ pǝnɑɣɑ nɑɑnʋwɑ nɑ kʋlʋmɑɣɑ nyǝŋkɑ ɩsɔtʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋ tɑɑ kɛ́ pɑ́ tɛɛsɑ Ɩsɔ tǝsɛɛlɛ ŋmɑʋ. Nɑ tǝ wɛ teitei ɩsɩɩ pɑɑ kɛɛsɑ-wɛɣɛ tǝ tɔm tɔ. Ɩsɔ tǝsɛɛlɛ ŋmɑʋ pɩɩsɩ kpɛntɑ nɑɑtosompɔɣɔlɑɣɑ ntɛ́. ");
INSERT INTO dop_vpl VALUES ("K17_1","012_7_1","1KI","7","1","1","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ ŋmɑwɑ ɩ mɑɣɑmɑɣɑ ɩ tǝyɑɣɑ. Pɩɩsɩ sikɑ nɑɑnʋwɑ nɑ tooso, ɩlɛ ɩ tɛmɑ-kɛɣɛlɛ. ");
INSERT INTO dop_vpl VALUES ("K17_2","012_7_2","1KI","7","2","2","Kutuluɣu ŋku pɑ yɑɑkɑɣɑ sɩ, Lipɑŋ hɔtʋɣʋ tɔɣɔ Sɑlʋmɔŋ cɑɑlǝnɑ ŋmɑʋ. Kʋ tɑɣɑlǝŋ wɛ mɛɛtǝlǝnɑɑ nɩɩlɛ nɑ nɑɑnʋwɑ nɑ kʋ wɑŋ kɛ mɛɛtǝlǝnɑɑ hiu nɑ kɑkpɑsɩ. Kʋ kʋŋkʋlʋmǝŋ kɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ. Pɑɑ temɑ kʋ pɑtɑ kpeŋkpelɑsɩ toŋ nyǝnsɩ nɑ tesikɑsɩ kʋpɑŋsɩ kɛ loosi liɣiti tɔɣɔ pɑ yɑɑkɑɣɑ-kʋɣʋ mpʋ. ");
INSERT INTO dop_vpl VALUES ("K17_3","012_7_3","1KI","7","3","3","Kpeŋkpelɑsɩ toŋ nyǝnsɩ nɩɩlɛ nɑ kɑkpɑsɩ kɛ pɑ kɑɣɑɑ, ɩlɛnɑ pɑ́ tǝnɩ pɑtɑ kpɑtǝŋ. Pɑɑ looŋɑ ŋkɑɣɑ kpeŋkpelɑsɩ nɑɑnʋwɑ nɑ kɑkpɑsɩ, nɑ sɩ́ lɩɩ loosi tooso nɑ sɩ́ tǝnɑ tesikɑsɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K17_4","012_7_4","1KI","7","4","4","Pǝ kɑɑsɩ nɑ pɑ́ tʋlɩ pǝtolee loosi tooso tooso kɛ́ kutuluɣu ŋkʋ kʋ kɔŋkɔmǝŋ nɑɑlɛ tɔɔ, nɑ ɑ́ nyǝnǝɣɩ tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("K17_5","012_7_5","1KI","7","5","5","Ɩlɛnɑ pɑ́ tʋ́lɩ́ kʋ kɔŋkɔmǝŋ nɑɑlɛ tɔɔ kɛ́ nɔɔnɔɔsɩ kootɑnɑɑ nyǝnsɩ kɛ tooso tooso nɑ sɩ́ nyǝnǝɣɩ tǝmɑ. ");
INSERT INTO dop_vpl VALUES ("K17_6","012_7_6","1KI","7","6","6","Ɩlɛnɑ pɑ́ ŋmɑ́ ɑkelenɑɑ kutuluɣu nɑ kʋ tɑɣɑlǝŋ kɛ mɛɛtǝlǝnɑɑ hiu nɑ kɑkpɑsɩ, nɑ kʋ wɑŋ kɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ. Kʋ nɑ kʋ ɑkelenɑɑ nɑ kʋ sɑkɑɣɑ. Kʋ wɛ kɛ́ ɩsɩɩ kutuluɣu ŋku pɑ yɑɑ sɩ Lipɑŋ hɔtʋɣʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K17_7","012_7_7","1KI","7","7","7","Ḿpʋ́ɣʋ́ pɑ ŋmɑwɑ kɑwulɑɣɑ kpɑɑŋ tɔtɔ. Tǝnɑɣɑ Sɑlʋmɔŋ hʋʋkɑɣɑ tɔm nɑ ɩ́ hʋ́lǝ́ɣɩ́ tɑmpɑnɑ. Ɩlɛnɑ pɑ́ pɔ kʋ tǝnɑɣɑ kpeŋkpelɑsɩ toŋ nyǝnsɩ, kɛ pǝ kpɑɣɑʋ ɑtɛ tɔ, nɑ pǝ́ yoosinɑ pɑtɑ. ");
INSERT INTO dop_vpl VALUES ("K17_8","012_7_8","1KI","7","8","8","Pɑ ŋmɑwɑ ɩ kutuluɣu kʋsʋsʋʋʋ kɛ ḿpʋ́ɣʋ́ teitei kɛ́ Lipɑŋ hɔtʋɣʋ kutuluɣu wɑɑlɩ nɑ wɑɑʋ lɛŋkʋ tɑɑ. Ɩlɛnɑ Sɑlʋmɔŋ ŋmɑ́ kutuluɣu lɛŋkʋ kɛ ḿpʋ́ɣʋ́ teitei kɛ́ ɩ ɑlʋ Icipiti wulɑʋ pɛɛlɔ. ");
INSERT INTO dop_vpl VALUES ("K17_9","012_7_9","1KI","7","9","9","Pɛɛ kʋsɑɑkɛɛ kʋpɑmpɑnɑ kɛ pɑ ŋmɑwɑ pǝ tǝnɑɣɑ mpʋ, nɑ pǝ koloosi kɛ too kite tɛɛ hɑlǝnɑ kʋ ɩmɑɑlɛ. Pɑ sɑɑkɑ-yɛɣɛ ɑ tɑɑ nɑ ɑ wɑɑlɩ kɛ́ teitei kɛ́ ɩsɩɩ pɑɑ kɛɛsɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K17_10","012_7_10","1KI","7","10","10","Kʋkpɑmǝŋ kʋpɑŋ wei ɩ tɑɣɑlǝŋ wɛ mɛɛtǝlǝnɑɑ kɑkpɑsɩ kɑkpɑsɩ nɑ liɣiti liɣiti tɔɣɔ pɑ sɩɩnɑ kite. ");
INSERT INTO dop_vpl VALUES ("K17_11","012_7_11","1KI","7","11","11","Ɩlɛnɑ pɑ́ ŋmɑnɑ pɛɛ kʋsɑɑkɛɛ nɑ kpeŋkpelɑsɩ toŋ nyǝnsɩ. ");
INSERT INTO dop_vpl VALUES ("K17_12","012_7_12","1KI","7","12","12","Ɩlɛnɑ pɑ́ ŋmɑ́ koluŋɑ sɔsɑɣɑ nɑ pɛɛ loosi tooso, nɑ kpeŋkpelɑsɩ looŋɑ kɛ teitei ɩsɩɩ pɑ ŋmɑʋ tɑɣɑ ŋkɑ n tɑkɩ nɑ ń tɛlǝsɩ Ɩsɔ tǝsɛɛlɛ tɑɑ tɔ, nɑ pǝ tɑɑ tɔɔ koluŋɑ. ");
INSERT INTO dop_vpl VALUES ("K17_13","012_7_13","1KI","7","13","14","Koolu nɔɣɔlʋ ɩ kɑ wɛnnɑ nɑ pɑ́ yɑɑkɩ-ɩ sɩ Hilɑm, ɩ cɑɑ kɛ Tiii tʋ, nɑ ɩ too kɛ Nɛfǝtɑli kpekǝle tɑɑ tʋ, ɩlɛ ɩ too ɩnɩ ɩ kɑ kɛ́ leelu. Apɑlʋ ɩnɩ ɩ kɑ nyǝmɑ́ nyǝɣǝtʋ kʋsɛɛmtʋ lupu kɛ teu kɛ́. Pǝ tɔɔ kɛ́ wulɑʋ Sɑlʋmɔŋ tilɑɑ sɩ ɩ́ kɔɔ nɑ ɩ́ lupi-ɩ wontunɑɑ. ");
INSERT INTO dop_vpl VALUES ("K17_15","012_7_15","1KI","7","15","15","Hilɑm lupǝnɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ ɑkelenɑɑ kɛ nɑɑlɛ. Pɑ kʋŋkʋlʋmǝŋ wɛ mɛɛtǝlǝnɑɑ pɔɣɔlɑɣɑfɛɩ nɑɑnʋwɑ. Pɑ yɑsǝlɑɣɑ kɛ mɛɛtǝlǝnɑɑ nɑɑtoso. ");
INSERT INTO dop_vpl VALUES ("K17_16","012_7_16","1KI","7","16","16","Ɩlɛnɑ ɩ́ lu kɑhusi tɑkɑ kɛ́ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ ŋkʋ nɑ ɩ́ tǝnɩ ɑkelenɑɑ mpɛ pɑ nyɔɔŋ tɑɑ. Pɑɑ ŋku kʋ wɛnɑ mɛɛtǝlǝnɑɑ nɑɑlɛ nɑ hɔɣɔlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K17_17","012_7_17","1KI","7","17","17","Nɑ Hilɑm lu cɑŋǝm wontu kɛ tɔm nɑɑlɛ. Lɛntɩ wɛ ɩsɩɩ puluɣu, lɛntɩ ɩsɩɩ yɔm nɑ ɑtʋɣʋsɑ, nɑ ɩ́ tʋ́ pɑɑ ɑkele wei ɩ kɑhukɑ tɔɔ kɛ́ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K17_18","012_7_18","1KI","7","18","18","Ɩlɛnɑ ɩ́ lu cɑŋǝm wontu, ɩsɩɩ tʋɣʋ nɑkʋlɩ kʋ pee tɑkɑ, nɑ ɩ́ tʋ-yɛɣɛ ɑkelenɑɑ kɑhusi puluŋ ɩnɩ ɩ tɔɔ kɛ́ loosi nɑɑlɛ nɑ pǝ́ tɑkɩ. ");
INSERT INTO dop_vpl VALUES ("K17_19","012_7_19","1KI","7","19","19","Nɑ pɑ́ tɑsɑ cɑŋǝm wontu nɑɑlɛɣɛ lupu, tǝ nǝɣǝsǝnɑ ɩsɩɩ yɑɑyenɑɑ, nɑ tǝ tɑɣɑlǝŋ wɛ mɛɛtǝlǝnɑɑ nɑɑlɛ nɑɑlɛ, nɑ pɑ́ tǝnɩ pɑɑ ɑkele wei ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K17_20","012_7_20","1KI","7","20","20","Pɑɑ lɑpɑ cɑŋǝm pʋlʋpʋnɑɑ kɛ kpɑɣɑmɑ kpɑɣɑmɑ kɛ ɑkele kɑhukɑ tɔɔ kɛ́ puluɣu nɑ tɩɩŋ pee lɛɛsǝŋ ŋmʋnʋɣʋ (200) loosi nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("K17_21","012_7_21","1KI","7","21","21","Ḿpʋ́ɣʋ́ pɑ sikɑ ɑkelenɑɑ mpɛɣɛ Ɩsɔ tǝsɛɛlɛ nɔnɔɣɔ. Lɛlʋ nɑ ntɔɣɔŋ tɔɔ, nɑ pɑ́ hɑ-ɩ hǝtɛ sɩ Yɑkɛŋ. (Pǝ nyʋɣʋ ntɛ́ sɩ Ɩsɔ nyɔɔsǝɣɩ nɑ pɑ tɛ tɑɑ). Nɑ pɑ́ hɑ mpǝtǝŋ tɔɔ nyǝŋ kɛ hǝtɛ sɩ Poosi. (Pǝ nyʋɣʋ ntɛ́ sɩ ɩnǝɣǝlɛ toŋ tʋ, nɑ pɑ tɛ tɑɑ). ");
INSERT INTO dop_vpl VALUES ("K17_22","012_7_22","1KI","7","22","22","Ɩlɛ Hilɑm tɛmɑ ɑkelenɑɑ mpɛ pɑ lupu ntɛ́. ");
INSERT INTO dop_vpl VALUES ("K17_23","012_7_23","1KI","7","23","23","Ḿpʋ́ɣʋ́ pɑ lupɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɛ nyɑmpɑɑni ɑnɑɑm tɑkɑ kɛ́ ɩkulutɑʋ, nɑ pɑ́ pǝlǝɣɩ lʋm, ɩsɩɩ lɩɩlɛ. Nyɑmpɑɑni ɩnɩ ɩ wɑŋ wɛ mɛɛtǝlǝnɑɑ kɑkpɑsɩ nɑ ɩ kʋŋkʋlʋmǝŋ kɛ mɛɛtǝlǝnɑɑ nɑɑlɛ nɑ titite. Nɑ ɩ ɩkulutɑʋ tɔɔ wɛ mɛɛtǝlǝnɑɑ nɑɑnʋwɑ nɑ kɑkpɑsɩ. ");
INSERT INTO dop_vpl VALUES ("K17_24","012_7_24","1KI","7","24","24","Nɑ pɑ́ lǝsɩ nyɩɩtʋ nɑtǝlɩ tǝ pee fotoonɑɑ kɛ nyɑmpɑɑni tɔɔ kɛ́ ɩ lupu wɑɑtʋ, nɑ pǝ́ cɔɔ nɑ pǝ́ tɑ́. Pɑɑ mɛɛtǝlɩ wei kɛ́ pee hiu. ");
INSERT INTO dop_vpl VALUES ("K17_25","012_7_25","1KI","7","25","25","Ɩlɛnɑ pɑ́ lu nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɛ nɑɑŋ lɛɛsǝŋ nɑɑnʋwɑ nɑ nɑɑlɛ, nɑ pɑ́ pɩɩlɩ-ɩ tooso tooso kɛ tɔm liɣiti. Lɛlǝŋ nyǝnǝɣǝnɑ ilim tǝlɩɩlɛ, lɛlǝŋ nɑ pǝ tǝtʋlɛ, lɛlǝŋ nɑ pǝ ntɔɣɔŋ nɑ lɛlǝŋ nɑ pǝ mpǝtǝŋ. Ɩlɛnɑ pɑ́ tǝnɩ nyɑmpɑɑni ɩnǝɣɩ nɑɑŋ lɛɛsǝŋ ɩnɩ ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K17_26","012_7_26","1KI","7","26","26","Nyɑmpɑɑni ɩnɩ ɩ kpɩɩsǝŋ wɛ kɛ́ ɩsɩɩ yʋlʋ ntɑntɑkʋ wɑŋ. Nɑ ɩ ntompee ɩsɩɩ poosiyɑ, nɑ ɑ́ nǝɣǝsǝnɑ ɩsɩɩ yɑɑyenɑɑ. Nyɑmpɑɑni ɩnɩ ɩ tɔkɩ ɩsɩɩ lʋm liitilinɑɑ iyisi nɩɩnɑɑsɑ (80000). ");
INSERT INTO dop_vpl VALUES ("K17_27","012_7_27","1KI","7","27","27","Ḿpʋ́ɣʋ́ pɑ lupɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɛ lʋm kɛɛkɛnɑɑ kɛ nɑɑnʋwɑ. Pɑ tɑɣɑlǝŋ nɑ pɑ wɑŋ kɛ mɛɛtǝlǝnɑɑ nɑɑlɛ nɑɑlɛ. Pɑ kʋŋkʋlʋmǝŋ kɛ mɛɛtǝlɩ kʋlʋm nɑ hɔɣɔlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K17_28","012_7_28","1KI","7","28","28","Pɑ lupɑ nyǝɣǝtʋ kɛ́, ɩlɛnɑ pɑ́ tǝnɩ tǝ tɔɔ kɛ́ lɛntɩ. ");
INSERT INTO dop_vpl VALUES ("K17_29","012_7_29","1KI","7","29","29","Nɑ pɑ́ lǝsɩ tǝlɛ tǝ tɔɔ kɛ́ tɔɣɔlɑsɩ nɑ lɑtǝcɛnɑɑ nɑ ɩsɔtɑɑ tɑŋlɑɑ fotoonɑɑ. Nɑ pɑ́ lɑ mpʋ tɔtɔɣɔ lɛntɩ tɔɔ, nɑ pɑ́ susi cɑŋǝm ɑtʋɣʋsɑ tɑkɑ kɛ́ fotoonɑɑ mpɛ pɑ pǝtɛɛ nɑ pɑ ɩsɔtɑɑ. ");
INSERT INTO dop_vpl VALUES ("K17_30","012_7_30","1KI","7","30","30","Pɑɑ kɛɛkɛ wei ɩ kɑ wɛnɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kpɑtǝŋ nɑɑlɛɣɛ, nɑ tǝ tɔɔ kɛ́ pɔpɔlɛɛ liɣiti. Nɑ pɑ tɑmsǝnɑ kpɑtǝŋ ɩnǝɣɩ nyǝɣǝtʋ liɣiti ɩsɩɩ nɔɔhɛɛ tɑkɑ kɛ́ ŋkuluŋɑsɩ tɑɑ. Ɩlɛ nɔɔhɛɛ ɑnɩ nɑ kɛɛkɛ pɩɩ kɛ́ nyǝɣǝlʋɣʋ kʋlʋmʋɣʋ kɛ́. Amɑ ɑ tɑ tɛɛ ɑtʋɣʋsɑ kɛ tɑɣɑlǝŋ. ");
INSERT INTO dop_vpl VALUES ("K17_31","012_7_31","1KI","7","31","31","Ɩlɛnɑ pɑ́ lɑ́ pʋlʋpʋ ɩsɩɩ pɔpɔtɛ tɑkɑ nɑ tǝ tɑpʋɣʋ kɛ kootɑ nɑ tǝ́ kʋlɑɑ nɑ pɑ́ tǝnɩ nyɑmpɑɑni. Tǝ wɑŋ sɛkɑ pǝcɔ sɩ pǝ́ lɑ mɛɛtǝlɩ kʋlʋm. Ɩlɛnɑ pɑ́ lǝsɩ tǝ tɔɔ kɛ́ fotoonɑɑ. ");
INSERT INTO dop_vpl VALUES ("K17_32","012_7_32","1KI","7","32","32","Kɛɛkɛ tɛɛ kɛ́ ɩ pɔpɔlɛɛ liɣiti wɛɛ. A kʋŋkʋlʋmǝŋ kɛ mpiiŋ tooso, nɑ ɑ nyǝɣǝtʋ kpɑtǝŋ nɑ kɛɛkɛ pǝ tɑmsɑ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("K17_33","012_7_33","1KI","7","33","33","Pɑɑ lupɑ kɛɛkɛ ɩnɩ ɩ pɔpɔlɛɛ kɛ teitei kɛ́ ɩsɩɩ yoou kɛɛkɛ nyǝnɑ. Pǝ́ kpɑɣɑʋ ɑ mɑɣɑmɑɣɑ nɑ ɑkpɑtǝŋ, nɑ ɑ nyǝɣǝlʋkpɑtɑsɩ, nɑ ɑ tiipee tɔ, nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɛ pɑ lupɑ. ");
INSERT INTO dop_vpl VALUES ("K17_34","012_7_34","1KI","7","34","34","Nyǝɣǝtʋ nti tǝ wɛ ɩsɩɩ kɛɛkɛ nɔɔhɛɛ tɑkɑ kɛ́ ɩ ŋkuluŋɑsɩ tɑɑ tɔ, pǝ kpɛntɑ nyǝɣǝlʋɣʋ kʋlʋmʋɣʋ kɛ́. ");
INSERT INTO dop_vpl VALUES ("K17_35","012_7_35","1KI","7","35","35","Pɑɑ kɛɛkɛ wei ɩ tɔɔ kɑ wɛ pɔpɔtɛ tɑkɑ, nɑ tǝ wɑŋ kɛ mpiiu kʋlʋmʋɣʋ. Nɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kʋkʋtʋŋ nɑ kʋ hɔɣɔlɑsɩ tɔkɑ-tɛ. Nyǝɣǝtʋ ntɩ nɑ kɛɛkɛ mɑɣɑmɑɣɑ pǝ kpɛntɑ kʋlʋm. ");
INSERT INTO dop_vpl VALUES ("K17_36","012_7_36","1KI","7","36","36","Ɩlɛnɑ pɑ́ lǝsɩ ɩsɔtɑɑ tɑŋlɑɑ, nɑ tɔɣɔlɑsɩ, nɑ pɑɑŋ fotoonɑɑ kɛ kʋkʋtʋŋ nɑ nyǝɣǝtʋ hɔɣɔlɑsɩ nsɩ sɩ tɔɔ. Nɑ pɑ́ lǝsɩ ɑtʋɣʋsɑ fotoonɑɑ nɑ pǝ́ cɔɔ nɑ pǝ́ tɑ́. ");
INSERT INTO dop_vpl VALUES ("K17_37","012_7_37","1KI","7","37","37","Pɑ lupɑ kɛɛkɛnɑɑ mpɛ pɑ nɑɑnʋwɑ kɛ́ teitei kɛ́. Pɑɑ wei kɛ́ nyǝɣǝlʋɣʋ kʋlʋmʋɣʋ ɩtɑmsɑʋ, nɑ pɑ wɑŋ nɑ pɑ tɑɣɑlǝŋ nɑ pɑ wɛɛtʋ wɛ teitei. ");
INSERT INTO dop_vpl VALUES ("K17_38","012_7_38","1KI","7","38","38","Ḿpʋ́ɣʋ́ pɑ lupɑ cɛmsɛnɑɑ sɔsɑɑ kɛ nɑɑnʋwɑ nɑ pɑ́ tǝnɩ kɛɛkɛnɑɑ mpɛ pɑ tɔɔ. Pɑɑ cɛmsɛ wei ɩ kʋŋkʋlʋmǝŋ wɛ mɛɛtǝlǝnɑɑ nɑɑlɛ, nɑ pɑɑ wei ɩ tɔkɩ lʋm tonoonɑɑ pǝlefɛɩ nɑɑnʋwɑ. ");
INSERT INTO dop_vpl VALUES ("K17_39","012_7_39","1KI","7","39","39","Ɩlɛnɑ pɑ́ sɩɩ lʋm kɛɛkɛnɑɑ kɑkpɑsɩ kɛ Ɩsɔ tǝsɛɛlɛ nɑ ilim mpǝtǝŋ ŋkuluŋɑ hɔɣɔlʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K17_40","012_7_40","1KI","7","40","40","Ḿpʋ́ɣʋ́ Hilɑm tɛmɑ cɛmsɛnɑɑ nɑ cɛmsisi nsi pɑ ŋmɩɩsǝɣǝnɑ cɑlǝm tɔ, nɑ tɔlʋmɑ lɔɣɔlɑsɩ, nɑ pǝ tǝnɑ mpi Sɑlʋmɔŋ kɑ́ tʋ-ɩ sɩ, ɩ́ lɑ Ɩsɔ tǝsɛɛlɛ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K17_41","012_7_41","1KI","7","41","42","Pǝ kpɑɣɑʋ ɑkelenɑɑ nɑɑlɛ, nɑ pɑ kɑhusi nɑ sɩ cɑŋǝm wontu, ɩsɩɩ sɩ tɔɔ puluŋ tɔm nɑɑlɛ, nɑ puluŋ ɩnɩ ɩ tɔɔ tʋɣʋ pee nɑsǝlɛ (400). Pɑɑ ɑkele wei kɛ́ loosi nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("K17_43","012_7_43","1KI","7","43","43","Nɑ lʋm kɛɛkɛnɑɑ nɑɑnʋwɑ, nɑ pɑ tɔɔ cɛmsɛnɑɑ nɑɑnʋwɑ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("K17_44","012_7_44","1KI","7","44","44","Nɑ nyɑmpɑɑni ɑnɑɑm wei pɑ tǝnɑ lɑtǝcɛnɑɑ nɑɑnʋwɑ nɑ nɑɑlɛ tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("K17_45","012_7_45","1KI","7","45","47","Nɑ wontu nti pɑ kuukinɑ tɔlʋmɑ tɔ, nɑ pǝ lɔɣɔlɑsɩ nɑ poosiyɑnɑɑ mpɑ pɑ ŋmɩɩsǝɣǝnɑ cɑlǝm tɔ. Nɔɣɔlʋ tɑ nyɩ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ tuutuumɑ wei Hilɑm lupɑ Ɩsɔ tǝsɛɛlɛ wontunɑɑ mpɛ nɑ ɩ́ sotiti tɔ, tǝ nyʋɣʋ. Ɩ lɑpɑ-tǝɣɩ teitei kɛ́ ɩsɩɩ Sɑlʋmɔŋ kɛɛsɑ-ɩ tɔ. Yɑɑtɑnɩ tɛtɛkǝlɛ tɑɑ ɑcɑlɛɛ nnɑ pɑ yɑɑ sɩ Sukɔtɩ nɑ Sɑɑtɑŋ tɔ ɑ hɛkʋ tɑɑ kɛ́ pɑ lupɑ-tɩ, nɑ pɑ́ tʋ́-tǝɣɩ Tɑcɑɑ tǝsɛɛlɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K17_48","012_7_48","1KI","7","48","48","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ lɑpɑ nɑ pɑ́ lu wʋlɑ nyǝmnɑɑ nɑ pɑ́ tʋ́ Tɑcɑɑ tǝsɛɛlɛ tɑɑ: Ɩsɩɩ tulɑɑlʋnɑɑ tǝwɔtɛ, nɑ tɑɑpǝlɩ wei ɩ tɔɔ pɑ sɩɩkɩ Ɩsɔ potopotonɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K17_49","012_7_49","1KI","7","49","50","Nɑ fǝtǝlɑnɑɑ kpelee nɑɑnʋwɑ, nɑ pɑ́ sɩɩ-wɛɣɛ kɑtɛ tɑɑ kɑtɛ kutuluɣu ɩsɛntɑɑ. Kɑkpɑsɩ nɑ ntɔɣɔŋ tɔɔ, kɑkpɑsɩ nɑ mpǝtǝŋ tɔɔ. Nɑ pɑ́ lu fǝtǝlɑnɑɑ mɑɣɑmɑɣɑ nɑ pɑ tɔɔ cɑŋǝm nɑ pɑ kpǝtǝlǝŋ tɔm nɑɑlɛ. Nɑ pɑ́ lu cɛmsɛnɑɑ nɑ poosiyɑnɑɑ mpɑ pɑ ŋmɩɩsǝɣǝnɑ cɑlǝm tɔ, nɑ kɔpʋnɑɑ, nɑ cofolonɑɑ, nɑ kɑmpʋnɑɑ mpɑ pɑ tǝkɑ tǝcɑɣɑlɛ kɑtɛ tɑɑ kɑtɛ nɔnɔɣɔ tɔ, pɑ nyǝɣǝtʋ nɑ Ɩsɔ tǝsɛɛlɛ kɑmpʋnɑɑ nyǝntʋ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("K17_51","012_7_51","1KI","7","51","51","Wɑɑtʋ wei Sɑlʋmɔŋ tɛmɑ Tɑcɑɑ tǝsɛɛlɛ ŋmɑʋ, ɩlɛnɑ ɩ́ kpɑɣɑ mpi ɩ cɑɑ Tɑfiiti kɑ sɩɩwɑ Tɑcɑɑ tɔ nɑ ɩ́ tʋ pǝ tǝnɑɣɑ Ɩsɔ tǝsɛɛlɛ kpɑncoou kutuluɣu tɑɑ. Pǝ kpɑɣɑʋ wʋlɑ, nɑ liɣitee nyǝɣǝtʋ, nɑ wontu lɛntǝnɑɑ kɛ mpʋ. ");
INSERT INTO dop_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Wɑɑtʋ wei Sɑlʋmɔŋ tɛmɑ Ɩsɔ tǝsɛɛlɛ kɛ ŋmɑʋ, ɩlɛnɑ ɩ́ koti Ɩsɛɣɛlɩ kʋpɑɣɑlɑɑ, nɑ pɑ kpekɑ, nɑ pɑ lʋlʋŋ nyʋɣʋ nyǝ́mɑ kɛ Yosɑlɛm sɩ, pɑ́ kpɑɣɑ Ɩsɔ ɑtɑkɑɑ kɛ Tɑfiiti tɛ, timpi pɑ yɑɑ sɩ Siyɔŋ tɔ, nɑ pɑ́ ponɑ Ɩsɔ tǝsɛɛlɛ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K18_2","012_8_2","1KI","8","2","2","Ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ kotɑ wulɑʋ tɛɣɛ pɑ ɩsɔtʋ nɑɑtosompɔɣɔlɑɣɑ nyǝŋ kɛ cokɑ ɑcimɑ tɔɣɔʋ. ");
INSERT INTO dop_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Ɩlɛnɑ Ɩsɛɣɛlɩ kʋpɑɣɑlɑɑ sɩɩ kɔtǝlɑɑ mpɑ pɑ sǝɣǝlɑ Ɩsɔ ɑtɑkɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","Ḿpʋ́ɣʋ́ kɔtǝlɑɑ nɑ Lefii nyǝ́mɑ pɑ kpɑɣɑ Ɩsɔ ɑtɑkɑɑ, nɑ pǝ cokǝle, nɑ pǝ wontu. ");
INSERT INTO dop_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Ɩlɛnɑ wulɑʋ Sɑlʋmɔŋ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ mpɑ pɑɑ kotinɑ Ɩsɔ ɑtɑkɑɑ tɔ, pɑ́ lɑ́ kɔtɑɣɑ kɛ heeŋ nɑ nɑɑŋ tuutuumɑ pǝ fɛɩ kɑlʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K18_6","012_8_6","1KI","8","6","7","Pǝ wɑɑlɩ kɛ́ kɔtǝlɑɑ sʋʋnɑ-ɩ kɑtɛ tɑɑ kɑtɛ tǝcɑɣɑlɛ kɛ ɩ lonte kɛ ɩsɔtɑɑ tɑŋlɑɑ keŋ tɛɛ, nɑ pǝ́ kenti ɩ nɑ ɩ kpɑtǝŋ wei pɑ kpɑkǝɣǝnɑ-ɩ tɔ ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K18_8","012_8_8","1KI","8","8","8","Kpɑtǝŋ ɩnɩ ɩ kɑ tɑɣɑlɑɑ kɛ́. Hɑlǝnɑ ye n wɛ Ɩsɔ tǝsɛɛlɛ tɑɑ, n nɑɑkɩ-ɩ kɛ́. Amɑ ye ɑwɑlɩ tɔɔ, ɩlɛ nn nɑɑkɩ-ɩ. Ḿpʋ́ɣʋ́ pǝ wɛ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("K18_9","012_8_9","1KI","8","9","9","Moisi kʋsǝsɩɩtʋ pɛɛ kpɑɑtɑnɑɑ nɑɑlɛ wei Ɩsɔ kɑ cɛlɑ-ɩ Holɛpʋ pʋɣʋ tɔɔ tɔ, pɑ tike pɑ wɛnnɑ pǝ tɑɑ. Wɑɑtʋ ɩnǝɣɩ ɩ́ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ pɑɑ pɛɛlɑ nɔɣɔ kɛ pɑ Icipiti lɩɩʋ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Wɑɑtʋ wei kɔtǝlɑɑ lɩɩnɑ Tɑcɑɑ tǝsɛɛlɛ tɑɑ, ɩlɛnɑ ɩsɔŋmʋntʋ hɑɣɑ kutuluɣu tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","Hɑlɩ kɔtǝlɑɑ tɑ pǝsɩ kɔtʋɣʋ tǝmlɛ. Mpi tɔ, Tɑcɑɑ teu kɑ sunɑ Ɩsɔ tǝsɛɛlɛ. ");
INSERT INTO dop_vpl VALUES ("K18_12","012_8_12","1KI","8","12","12","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ mɑpɑ kɑpukɑ sɩ: Hɑlɩ Tɑcɑɑ nyɑɑ tɔmnɑ sɩ, sǝkpɛtʋɣʋ tɑɑ kɛ́ n kɑ́ cɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K18_13","012_8_13","1KI","8","13","13","Amɑ mɑ ŋmɑ-ŋ Ɩsɔ tǝsɛɛlɛ nte tǝ tɑɑ n kɑ́ cɑɣɑ tɑm tɔɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_14","012_8_14","1KI","8","14","14","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ kɛɛsǝnɑ kotilɑɑ tɔɔ nɑ ɩ́ sɛɛ-wɛ. ");
INSERT INTO dop_vpl VALUES ("K18_15","012_8_15","1KI","8","15","15","Ɩlɛnɑ ɩ́ tɔ́ sɩ: Mɑ sɛɛ Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ. Mpi tɔ, n lɑpɑ teitei kɛ́ ɩsɩɩ n kɑ sɩɩʋ mɑ cɑɑ Tɑfiiti kɛ nɔɣɔ tɔ sɩ, ");
INSERT INTO dop_vpl VALUES ("K18_16","012_8_16","1KI","8","16","16","hɑtoo kʋyɑkʋ ŋku ɩnɩ n lǝsʋɣʋ nyɑ́ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ Icipiti tɑɑ tɔ, n tɑ lǝsǝtɑ pɑ ɑcɑlɛɛ tɑɑ nɑtǝlɩ sɩ pɑ́ ŋmɑ-ŋ nyɑ́ tǝsɛɛlɛ nɑ ń cɑɣɑ. Amɑ Tɑfiiti kɛ n lǝsɑɑ sɩ ɩ́ lɑ pɑ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("K18_17","012_8_17","1KI","8","17","17","Hɑlɩ ɩ́lɛ́ ɩ mɑɣɑsɑɣɑ sɩ ɩ ŋmɑɑkɩ-ŋ tǝsɛɛlɛ. ");
INSERT INTO dop_vpl VALUES ("K18_18","012_8_18","1KI","8","18","18","Amɑ Ɩsɔ nyɑ́ n tɔmɑ-ɩ sɩ: N mɑɣɑsʋɣʋ mpʋ tɔ, pǝ wɛ teu yɑɑ, ");
INSERT INTO dop_vpl VALUES ("K18_19","012_8_19","1KI","8","19","19","ɩlɛ nyɑ́ pǝyɑɣɑ mɑɣɑmɑɣɑ kɑ́ ŋmɑnɑ-m, pǝ tɑɣɑ nyɑ́. ");
INSERT INTO dop_vpl VALUES ("K18_20","012_8_20","1KI","8","20","20","Mpʋɣʋlɛ Tɑcɑɑ tɔkɑ ɩsǝnɑ ɩ kɑ sɩɩwɑ tɔ, nɑ mɑ́ lɛɛtɩ mɑ cɑɑ lonte tɑɑ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ kɑwulɑɣɑ kumte tɔɔ, nɑ mɑ́ ŋmɑ́ Ɩsɔ tǝsɛɛlɛ tǝnɛ. ");
INSERT INTO dop_vpl VALUES ("K18_21","012_8_21","1KI","8","21","21","Hɑlǝnɑ mɑ́ lɑ nyɑ́ ɑtɑkɑɑ tǝcɑɣɑlɛ. Ɩ tɑɑ kɛ́ nɔɣɔ ŋkɑ nyɑ́ nɑ tɑ cɑɑnɑɑ ɩ́ pɛɛlɑ pɑ Icipiti tɑɑ lǝsʋɣʋ wɑɑtʋ tɔ, kɑ pɛɛ kpɑɑtɑnɑɑ wɛɛ. ");
INSERT INTO dop_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Pǝ wɑɑlɩ kɛ́ Sɑlʋmɔŋ sǝŋɑ kɔtɑɣɑ tǝlɑtɛ kite kɛ Ɩsɛɣɛlɩ sɑmɑɑ ɩsɛntɑɑ nɑ ɩ́ kpɑɑsɩ ɩ niŋ nɑ ɩ́ sǝlǝmɩ Ɩsɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","Hɑɩ, Tɑcɑɑ, Ɩsɛɣɛlɩ Ɩsɔ. Ɩsɔ nɔɣɔlʋ ɩ fɛɩ ɩsɩɩ nyɑ́. Pɑɑ ɩsɔtɔnʋɣʋ tɑɑ kɛ́ hɑtoo ɩsɔtɑɑ, pɑɑ tɛtʋ tɔɔ kɛ́ ɑtɛ cǝnɛ. N sɔɔlɑ mpɑ pɑ lɑkɩ nyɑ́ tǝmlɛ nɑ lotu kʋlʋmtʋ tɔɣɔ, nɑ ń lɑkɩ-wɛɣɛ ɩsǝnɑ n kɑ sɩɩwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_24","012_8_24","1KI","8","24","24","Mpʋ ɩnǝɣɩ n lɑpɑ mpi n kɑ sɩɩ mɑ cɑɑ Tɑfiiti tɔɣɔ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("K18_25","012_8_25","1KI","8","25","25","Hɑɩ Tɑcɑɑ Ɩsɛɣɛlɩ Ɩsɔ, lɑ tɔtɔɣɔ nɔɣɔ ŋkɑ n kɑ sɩɩ-ɩ tɔ sɩ, ye ɩ lʋlʋɣʋ nyǝ́mɑ tɔmɑ teu ɩsɩɩ ɩnɩ ɩ tɔm tɔ, mpɛ pɑɑ tɔkǝnɑ kɑwulɑɣɑ kɛ ɩ wɑɑlɩ kɛ́ tɑm nɑ pɑ́ kɑɑsǝɣɩ tǝmɑɣɑ Ɩsɛɣɛlɩ yǝlɑɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K18_26","012_8_26","1KI","8","26","26","Hɑɩ, mɑ wiikinɑ-ŋ sɩ ń lɑ nɔɣɔ ŋkɑ n kɑ sɩɩ mɑ cɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","Ɩlɛ tɑmpɑnɑ Ɩsɔ pǝsǝɣɩ nɑ ɩ́ cɑɣɑ ɑtɛɣɛlɛ? Mpi tɔ, pɑɑ ɩsɔtɔnʋɣʋ nɑ kʋ tɔɔmǝŋ tɔ, ɩ tɑ mɑɣɑ kʋ tɑɑ. Pǝyele Ɩsɔ tǝsɛɛlɛ nte mɑ ŋmɑ-ŋ tɔ, tǝ tɑ hɑŋnɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","Hɑɩ, Tɑcɑɑ, pɑɑ nɑ mpʋ kɛɛsɩ nyɑ́ ɩsɛ nɑ mɑ tɔɔ, nɑ ń nɩɩ mɑ wiinɑʋ nɑ mɑ yɑɑʋ mpi mɑ yɑɑkɩ-ŋ sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","Kuli nyɑ́ ɩsɛ nɑ ń pɑɑsǝnɑ kutuluɣu kʋnɛɣɛ ilim nɑ ɑhoo. Mpi tɔ, tǝnɑɣɑ n tɔmɑ sɩ n kɑ́ cɑɣɑ. Ɩlɛ nɩɩ mɑ kʋsǝlǝmʋtʋ. ");
INSERT INTO dop_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","Nɩɩ yɑɑʋ mpi mɑ nɑ nyɑ́ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝ yɑɑkɩ-ŋ cǝnɛ tɔ. Hɑɩ, nɩɩ tɑ kʋsǝlǝmʋtʋ kɛ ɩsɔtɑɑ timpi n wɛɛ tɔ, nɑ ń hɩɩsɩ tɑ́ ɩsɑɣɑtʋ. ");
INSERT INTO dop_vpl VALUES ("K18_31","012_8_31","1KI","8","31","31","Ye nɔɣɔlʋ pǝntǝnɑ ɩ tɔɣɔntǝlɛ, ɩlɛnɑ pɑ yɑɑ-ɩ sɩ ɩ́ kɔɔ Ɩsɔ tǝsɛɛlɛ tǝnɛ tǝ tɑɑ nɑ ɩ́ tuunɑ kɔtɑɣɑ tǝlɑtɛ ɩsɛntɑɑ sɩ ɩ tɑ nɑ. ");
INSERT INTO dop_vpl VALUES ("K18_32","012_8_32","1KI","8","32","32","Hɑɩ, Tɑcɑɑ, nɩɩ pɑ tɔm kɛ hɑtoo ɩsɔtɑɑ, nɑ ń fɑɣɑsɩ-wɛ, nɑ ń kʋ tɑsǝkǝlɛ tʋ tɔm, nɑ ń hʋ́lɩ́ tɑmpɑnɑ tʋ. ");
INSERT INTO dop_vpl VALUES ("K18_33","012_8_33","1KI","8","33","33","Yɑɑ ye pǝ kɔmɑ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ wɑkǝlǝnɑ-ŋ, ɩlɛnɑ pɑ kolontunɑɑ kǝlɩ-wɛ, nɑ pɑ́ kɔɔ Ɩsɔ tǝsɛɛlɛ tɑɑ cǝnɛ sɩ, ń tɑɣɑnɩ-wɛ, nɑ pɑ́ sɛɛ-ŋ nɑ pɑ́ wiinɑ-ŋ. ");
INSERT INTO dop_vpl VALUES ("K18_34","012_8_34","1KI","8","34","34","Ɩlɛ hɑɩ, Tɑcɑɑ, nɩɩ pɑ tɔm kɛ hɑtoo ɩsɔtɑɑ, nɑ ń tɑɣɑnɩ pɑ ɩsɑɣɑtʋ, nɑ ń mǝŋnɑ-wɛɣɛ pɑ tɛtʋnɑɑ mpɑ ń kɑ hɑ pɑ cɑɑnɑɑ tɔ. Mpi tɔ, pɑ kɛ́ nyɑ́ yǝlɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("K18_35","012_8_35","1KI","8","35","35","Yɑɑ ye pɑ wɑkǝlǝnɑ-ŋ nɑ ń yele nɑ tɛʋ wʋlɩ-wɛ nɑ pɑ́ cɛkǝnɑ mpʋ. Ɩlɛnɑ pɑ́ kɛɛsǝnɑ Ɩsɔ tǝsɛɛlɛ tǝnɛ tǝ tɔɔ, nɑ pɑ́ sǝlǝmɩ-ŋ, nɑ pɑ́ sɛɛ-ŋ, nɑ pɑ́ pɑsɑ pɑ tɩ, nɑ pɑ́ tɑɣɑnɩ timpi pɑ wɑkǝlǝnɑ-ŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_36","012_8_36","1KI","8","36","36","Ɩlɛ Tɑcɑɑ, nɩɩ pɑ tɔm kɛ hɑtoo ɩsɔtɑɑ, nɑ ń hɩɩsɩ pɑ ɩsɑɣɑtʋ. Mpi tɔ, pɑ kɛ́ nyɑ́ yǝlɑɑ kɛ́, nɑ nyɑ́ tǝmlɛ nyǝ́mɑ. Pǝ wɑɑlɩ, ɩlɛ hʋlɩ-wɛɣɛ ɩsǝnɑ pɑɑ tɔ teu tɔ. Ɩlɛnɑ ń yele nɑ tɛʋ nɩɩ tɛtʋ nti n hɑ-wɛ sɩ tǝ́ pǝsɩ pɑ nyǝntʋ tɔ tǝ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K18_37","012_8_37","1KI","8","37","37","Yɑɑ ye yʋlʋkʋsǝkʋ lɩɩnɑ, yɑɑ kʋtɔɣɔʋ mɔɔnɑɑ, yɑɑ kʋ sǝpɑ, yɑɑ kʋtoloŋ yɑɑ nyɔɣɔsɩ lɩɩnɑ, yɑɑ kolontunɑɑ sʋʋnɑ Ɩsɛɣɛlɩ nyǝ́mɑ koloosi ɑcɑlɛɛ tɑɑ nɑ pɑ́ ŋmɑkǝlǝɣɩ-wɛ. Pɑɑ wɑhɑlɑ nɔɣɔlʋ, yɑɑ kʋtɔŋ nɑkʋlɩ kʋ tɩɩ kɔmnɑ, ");
INSERT INTO dop_vpl VALUES ("K18_38","012_8_38","1KI","8","38","38","nɑ pǝ́ hɑŋ nyɑ́ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ, nɑ pɑ tɑɑ nɔɣɔlʋ nɩɩ ɩ ɩsɑɣɑtʋ sɔŋ nɑ ɩ́ kɛɛsǝnɑ nyɑ́ tǝsɛɛlɛ tǝnɛ tǝ tɔɔ nɑ ɩ́ wiinɑ-ŋ, nɑ ɩ́ tɛɣɛ-ŋ niŋ. ");
INSERT INTO dop_vpl VALUES ("K18_39","012_8_39","1KI","8","39","39","Ɩlɛ hɑɩ, Tɑcɑɑ, nɩɩ ɩ tɔm kɛ nyɑ́ tǝcɑɣɑlɛ kɛ hɑtoo ɩsɔtɑɑ, nɑ ń tɑɣɑnɩ pɑɑ wei ɩ tǝwɑkǝllɛ nɑ ń kɛɛsǝnɑ ɩ tɔntɛ. Mpi tɔ, nyɑ́ nyǝmnɑ pɑɑ wei ɩ lotu. ");
INSERT INTO dop_vpl VALUES ("K18_40","012_8_40","1KI","8","40","40","Lɑkɩ-wɛɣɛ mpʋ, ɩlɛnɑ pɛlɛ pɑ́ seekɩ-ŋ tɑm kɛ́ tɛtʋ nti n hɑ pɑ cɑɑnɑɑ tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K18_41","012_8_41","1KI","8","41","42","Yɑɑ ye kpɑɩ nyǝ́mɑ nɩɩ nyɑ́ hǝtɛ teu tɔm, nɑ tomɑ sɔsɔɔnɑ wenɑ n lɑkǝnɑ tɔ, nɑ pɑ́ lɩɩ pɑ tɛ nɑ pɑ́ sɔɔsɩ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ, nɑ pɑ́ kɔɔ Ɩsɔ tǝsɛɛlɛ tɑɑ cǝnɛ nɑ pɑ́ sǝlǝmɩ-ŋ. ");
INSERT INTO dop_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","Ɩlɛ Tɑcɑɑ, nɩɩ pɑ tɔm kɛ nyɑ́ tǝcɑɣɑlɛ kɛ hɑtoo ɩsɔtɑɑ, nɑ ń lɑ-wɛɣɛ pɑ kʋsǝlǝmǝm. Mpʋ pɩɩ yelinɑ nɑ ɑtɛ yǝlɑɑ tǝnɑ nyɩ-ŋ, nɑ pɑ́ seekɩ-ŋ ɩsɩɩ nyɑ́ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ seekuɣu-ŋ tɔ. Pɑɑ nyɩ tɔtɔ sɩ Ɩsɔ tǝsɛɛlɛ nte mɑ ŋmɑ-ŋ tɔ, tǝ kɛ́ nyɑ́ nyǝntɛ tǝkpɑtɑɑ. ");
INSERT INTO dop_vpl VALUES ("K18_44","012_8_44","1KI","8","44","44","Yɑɑ ye ń tʋ nyɑ́ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ sɩ pɑ́ yoonɑ pɑ kolontunɑɑ, nɑ pɑ́ kɛɛsǝnɑ nyɑ́ ɩcɑtɛ kʋlǝsǝlɛ tǝnɛ nɑ Ɩsɔ tǝsɛɛlɛ nte mɑ ŋmɑ-ŋ ɩsǝntɔ tɔ, pɑ tɔɔ nɑ pɑ́ sǝlǝmɩ-ŋ. Ɩlɛ hɑɩ, Tɑcɑɑ ");
INSERT INTO dop_vpl VALUES ("K18_45","012_8_45","1KI","8","45","45","nɩɩ pɑ wiinɑʋ kɛ hɑtoo ɩsɔtɑɑ nɑ ń wɑɑsɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("K18_46","012_8_46","1KI","8","46","46","Yɑɑ ye pǝ kɔmɑ nɑ pɑ́ wɑkǝlǝnɑ-ŋ. Mpi tɔ, yʋlʋ nɔɣɔlʋ ɩ fɛɩ sɩ ɩɩ wɑkǝlǝɣɩ. Ntɑnyɩ n kɑ́ mʋ-wɛ nɑ pɑ́ɑ́nɑ́, nɑ ń yele nɑ pɑ kolontunɑɑ kǝlɩ-wɛ, nɑ pɑ́ kpɑ-wɛɣɛ yomle, nɑ pɑ́ ponɑ-wɛɣɛ pɑ ɑcɑlɛɛ tɑɑ kɛ́ pǝcɔlɔ pǝcɔlɔ yɑɑ pooluŋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K18_47","012_8_47","1KI","8","47","47","Ɩlɛnɑ pɑ́ pǝsǝnɑ lɑɑkɑlɩ kɛ tǝnɑ sɩ pɑ wɑkǝlǝnɑ-ŋ, pɑ lɑpɑ ɩsɑɣɑtʋ, pɑ tɔm sǝpɑ. ");
INSERT INTO dop_vpl VALUES ("K18_48","012_8_48","1KI","8","48","48","Ɩlɛnɑ pɑ́ sǝlǝmɩ-ŋ nɑ pɑ lotu tǝnɑɣɑ timpi ɩnɩ pɑ wɛ mpʋ tɔ. Nɑ pɑ́ kɛɛsɩ pɑ lǝmɑɣɑsɛɛ nɑ nyɑ́ ɩcɑtɛ tǝnɛ nɑ Ɩsɔ tǝsɛɛlɛ nte mɑ ŋmɑ-ŋ ɩsǝntɔ tɔ pɑ tɔɔ, kɛ tɛtʋ nti n hɑ pɑ cɑɑnɑɑ tɔ tǝ tɑɑ cǝnɛ. ");
INSERT INTO dop_vpl VALUES ("K18_49","012_8_49","1KI","8","49","49","Ɩlɛ hɑɩ, Tɑcɑɑ, nɩɩ pɑ wiinɑʋ kɛ nyɑ́ tǝcɑɣɑlɛ kɛ hɑtoo ɩsɔtɑɑ, nɑ ń wɑɑsɩ-wɛ. ");
INSERT INTO dop_vpl VALUES ("K18_50","012_8_50","1KI","8","50","50","Ɩlɛnɑ ń tɑɣɑnɩ timpi pɑ wɑkǝlǝnɑ-ŋ tɔ, nɑ ń yele nɑ pɑ kolontunɑɑ nɑ pɑ pǝtɔɔtǝlɛ. ");
INSERT INTO dop_vpl VALUES ("K18_51","012_8_51","1KI","8","51","51","Pɔpɔtʋ fɛɩ, pɑ kɛ́ nyɑ́ piyɑ kɛ hɑtoo kʋyɑŋku n lǝsɑ-wɛɣɛ Icipiti wɑhɑlɑ sɔsɔ tɑɑ tɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("K18_52","012_8_52","1KI","8","52","52","Hɑɩ, Tɑcɑɑ Ɩsɔ, nɩɩkɩ sǝlǝmǝŋ wei mɑ́ nɑ nyɑ́ yǝlɑɑ tɩɩ sǝlǝmǝɣɩ-ŋ pɑɑ wɑɑtʋ wei tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_53","012_8_53","1KI","8","53","53","Mpi tɔ, nyɑ́ lǝsǝnɑ-tʋɣʋ piitimnɑɑ tǝnɑ hɛkʋ sɩ tǝ́ pǝsɩ nyɑ́ nyǝ́mɑ ɩsɩɩ n yeluɣu nɑ nyɑ́ tǝmlɛ tʋ Moisi heeli-wɛɣɛ sɑɑ wei n lǝsɑ tɑ cɑɑnɑɑ kɛ Icipiti tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_54","012_8_54","1KI","8","54","54","Kɔtɑɣɑ tǝlɑtɛ kite kɛ Sɑlʋmɔŋ kɑ luŋɑɑ, nɑ ɩ́ kpɑɑsɩ ɩ niŋ nɑ ɩsɔtɑɑ, nɑ ɩ́ wiikinɑ Tɑcɑɑ. Ɩ tɛmɑ, ɩlɛnɑ ɩ́ kʋlɩ ");
INSERT INTO dop_vpl VALUES ("K18_55","012_8_55","1KI","8","55","55","nɑ ɩ́ kooli sɑmɑɑ wei ɩ kɑ kotɑ tǝnɑ tɔɣɔ kʋpɑntʋ sɩ: ");
INSERT INTO dop_vpl VALUES ("K18_56","012_8_56","1KI","8","56","56","Mɑ sɛɛ Tɑcɑɑ nyɑ́ wei n yelɑɑ nɑ nyɑ́ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ hɛɛsɩ, ɩsɩɩ n kɑ yɔɣɔtʋɣʋ tɔ. Pɔpɔtʋ fɛɩ leleŋ, n lɑpɑ teitei kɛ́ ɩsɩɩ n kɑ́ sɩɩʋ nyɑ́ nɔɣɔ kʋpɑŋkɑ nɑ nyɑ́ tǝmlɛ tʋ Moisi nɔɣɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_57","012_8_57","1KI","8","57","57","Tɑ Ɩsɔ Tɑcɑɑ wɛɛ tɑ wɑɑlɩ, ɩsɩɩ n kɑ wɛʋ tɑ cɑɑnɑɑ cɑɑnɑɑ wɑɑlɩ tɔ. Tɑɑ lɔ-tʋ. Pǝ́cɔ́ tɑɑ yele-tʋɣʋ wɑɑsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K18_58","012_8_58","1KI","8","58","58","Yele nɑ tǝ́ nɩɩkǝnɑ-ŋ tɑm, nɑ tǝ́ tɔŋ nyɑ́ mpɑɑŋ tɑɑ ɩsɩɩ n cɑɑkɩ tɔ, nɑ tǝ́ tɔkɩ nyɑ́ kiiŋ, nɑ nyɑ́ kʋsǝsɩɩtʋ, nɑ nyɑ́ kʋtʋtʋtʋ nti n kɑ tʋ tɑ cɑɑnɑɑ cɑɑnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_59","012_8_59","1KI","8","59","59","Tɑcɑɑ Ɩsɔ tɔɔsǝɣɩ mɑ wiinɑʋ pǝnɛ pǝ tɔɔ kɛ́ ilim nɑ ɑhoo, nɑ n sǝŋnɑ nyɑ́ yǝlɑɑ tɑɣɑ pɑɑ kʋyɑkʋ ŋku. ");
INSERT INTO dop_vpl VALUES ("K18_60","012_8_60","1KI","8","60","60","Ḿpʋ́ɣʋ́ ɑtɛ yǝlɑɑ tǝnɑ kɑ́ nyǝnɑ sɩ, Tɑcɑɑ tike ntɛ́ Ɩsɔ, nɔɣɔlʋ fɛɩ tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("K18_61","012_8_61","1KI","8","61","61","Nɑ mǝ lǝsɑsɩ nɑ́ɑ́ sʋʋ-ɩ teu tǝmɑmmɑm nɑ ɩ́ tɔkǝɣɩ ɩ kiiŋ, nɑ ɩ kʋsǝsɩɩtʋ, ɩsɩɩ ɩ́ lɑkʋɣʋ sɑŋɑ ɩsǝntɔ tɔ. ");
INSERT INTO dop_vpl VALUES ("K18_62","012_8_62","1KI","8","62","62","Ḿpʋ́ɣʋ́ wulɑʋ Sɑlʋmɔŋ nɑ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ mpɑ pɑɑ kotɑ tǝnɑ tɔ, pɑ lɑpɑ Tɑcɑɑ kɛ ");
INSERT INTO dop_vpl VALUES ("K18_63","012_8_63","1KI","8","63","63","ciikuɣu kɔtɑsɩ kɛ nɑɑŋ iyisi hiu nɑ nɑɑlɛ (22000) nɑ heeŋ nɑ pǝ́ŋ kɛ iyisi nɩɩnʋwɑ nɑ hiu (120000) kɛ Tɑcɑɑ tǝsɛɛlɛ tʋlʋɣʋ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K18_64","012_8_64","1KI","8","64","64","Kɔtɑsɩ tɑ mɑɣɑ nyǝɣǝlʋɣʋ kʋsɛɛmʋɣʋ kɔtɑɣɑ tǝlɑtɛ tɔɔ kɛ́ kʋyɑkʋ ŋkʋ. Ɩlɛnɑ Sɑlʋmɔŋ yele nɑ pɑ́ lɑ́ kɔtɑsɩ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔ nɑ tɔɣɔnɑɣɑ nyǝnsɩ nɑ ciikuɣu nyǝnsɩ nim cɔlɔ nim cɔlɔ kɛ Ɩsɔ tǝsɛɛlɛ tɑɣɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K18_65","012_8_65","1KI","8","65","65","Wɑɑtʋ ɩnɩ ɩ tɑɑ kɛ́ Sɑlʋmɔŋ nɑ Ɩsɛɣɛlɩ sɑmɑɑ tuutuumɑ wei ɩ lɩɩnɑ tɛtʋ tǝnɑ tɑɑ tɔ. Pǝ kpɑɣɑʋ Lepo-Hɑmɑtɩ hɑlǝnɑ pǝ́ sɩɩnɑ Icipiti lɔɔʋ tɔ, pɑ tɔɣɔ cokɑ ɑcimɑ kɛ kʋyɛɛŋ nɑɑtosompɔɣɔlɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K18_66","012_8_66","1KI","8","66","66","Kʋyɑkʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋkʋ wule kɛ wulɑʋ yɑsɑ Ɩsɛɣɛlɩ nyǝ́mɑ. Ɩlɛnɑ pɑ́ polo pɑ́ sɛɛ-ɩ, nɑ pɑɑ wei ɩ́ kpe ɩ tɛ nɑ lɑŋhɛɛlɛ. Mpi tɔ, Tɑcɑɑ lɑpɑ ɩ tǝmlɛ tʋ Tɑfiiti nɑ ɩ yǝlɑɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kʋpɑntʋ. ");
INSERT INTO dop_vpl VALUES ("K19_1","012_9_1","1KI","9","1","1","Wɑɑtʋ wei wulɑʋ Sɑlʋmɔŋ tɛmɑ Ɩsɔ tǝsɛɛlɛ nɑ ɩ kɑwulɑɣɑ tǝyɑɣɑ nɑ pǝ tǝnɑ mpi ɩ cɑɑkɑɣɑ tɔɣɔ ŋmɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K19_2","012_9_2","1KI","9","2","2","Ɩlɛnɑ, Tɑcɑɑ lɩɩ ɩ tɔɔ kɛ́ tɔm nɑɑlɛ nyǝm kɛ teitei ɩsɩɩ ɩ kɑ lɩɩʋ ɩ tɔɔ kɛ́ Kɑpɑwɔŋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K19_3","012_9_3","1KI","9","3","3","Nɑ ɩ́ yɔɣɔtɩ sɩ: Mɑ nɩɩwɑ nyɑ́ wiinɑʋ, ɩlɛ Ɩsɔ tǝsɛɛlɛ nte n ŋmɑ́ ɩsǝntɔ tɔ tǝ pǝsɑ mɑ nyǝntɛ. Mɑɑ wɛɛ tǝ tɑɑ kɛ́ tɑm nɑ mɑ́ pɑɑsǝnɑ-tɛ, nɑ mɑ́ lɑkɩ-mɛɣɛ kʋpɑntʋ kɛ tɑm. ");
INSERT INTO dop_vpl VALUES ("K19_4","012_9_4","1KI","9","4","4","Ye nyɑɑ tɔmɑ teu nɑ lotu kʋlʋmtʋ, ɩsɩɩ nyɑ́ cɑɑ Tɑfiiti, nɑ ń tǝŋǝɣɩ mɑ kiiŋ nɑ ń tɔkǝɣɩ mɑ kʋtʋtʋtʋ nti mɑ tʋ-ŋ tɔ, ");
INSERT INTO dop_vpl VALUES ("K19_5","012_9_5","1KI","9","5","5","ɩlɛ mɑɑ yele nɑ nyɑ́ kɑwulɑɣɑ nyɔɔ toŋ kɛ tɑm tɔɔ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ. Ḿpʋ́ɣʋ́ mɑɑ sɩɩ nɔɣɔ kɛ nyɑ́ cɑɑ Tɑfiiti sɩ, ɩ lʋlʋɣʋ tɑɑ nyǝ́mɑ kɑ́ tɔkǝnɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔɔ kɛ́ kɑwulɑɣɑ kɛ ɩ sǝm wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("K19_6","012_9_6","1KI","9","6","6","Amɑ ye nyɑnɑ nyɑ́ yǝlɑɑ nɑ nyɑ́ lʋlʋɣʋ nyǝ́mɑ ɩ́ lɔ-m, nɑ ɩ́ kisi mɑ kʋsǝsɩɩtʋ nɑ mɑ kiiŋ wei mɑ tʋ-mɛ tɔ, nɑ ɩ́ mǝlǝnɑ tɩɩŋ tɔɔ nɑ ɩ́ lɑɑkɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("K19_7","012_9_7","1KI","9","7","7","Ɩlɛ mɑɑ kpiisi-mɛɣɛ tɛtʋ nti mɑ hɑ-mɛ ɩsǝntɔ tɔ tǝ tɔɔ, nɑ mɑ́ lɔ́ Ɩsɔ tǝsɛɛlɛ nte mɑ pǝsɑ mɑ nyǝntɛ ɩsǝntɔ tɔ, nɑ yǝlɑɑ tǝnɑ woŋ-mɛ nɑ pɑ́ pɑɑnɑ-mɛ. ");
INSERT INTO dop_vpl VALUES ("K19_8","012_9_8","1KI","9","8","8","Wɑɑtʋ ɩnǝɣɩ yǝlɑɑ kɑ tǝŋǝɣǝnɑ Ɩsɔ tǝsɛɛlɛ nte tɩɩ te teu kɛ mpʋ tɔ tǝ kiŋ, nɑ sɔɣɔntʋ kpɑ-wɛ nɑ pǝ́ lɑ-wɛɣɛ piti, nɑ pɑ́ pɔɔsǝɣɩ pɑ tɩ sɩ: Ɩlɛ pepe tɔɔ kɛ́ Tɑcɑɑ lɑpɑ tɛtʋ tǝnɛ nɑ Ɩsɔ tǝsɛɛlɛ tǝnɛɣɛ mpʋ? ");
INSERT INTO dop_vpl VALUES ("K19_9","012_9_9","1KI","9","9","9","Ɩlɛnɑ pɑ́ cɔ-wɛ sɩ: Ɩsɛɣɛlɩ nyǝ́mɑ lɔwɑ pɑ Ɩsɔ Tɑcɑɑ. Ɩnɩ ɩ lǝsǝnɑ pɑ cɑɑnɑɑ kɛ Icipiti tɛtʋ tɑɑ. Ɩlɛnɑ pɑ́ tǝŋǝɣɩ tɩɩŋ. Pǝ tɔɔ kɛ́ Ɩsɔ tǝŋsɑ-wɛɣɛ mpusinɑɑ mpɛ pɑ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("K19_10","012_9_10","1KI","9","10","11","Tiii wulɑʋ Hilɑm kɑ hɑnɑ wulɑʋ Sɑlʋmɔŋ kɛ tɑɑsɩ kʋpɑŋsɩ tǝnɑ, nɑ wʋlɑnɑɑ tǝnɑ mpɑ ɩ nyɩɩlɑɣɑ sɩ ɩ ŋmɑɑkǝnɑ tɔ. Pɩɩsɩ sikɑ hiu nɑ Sɑlʋmɔŋ tɛ Ɩsɔ tǝsɛɛlɛ nɑ ɩ kɑwulɑɣɑ tǝyɑɣɑ kɛ ŋmɑʋ. Ɩlɛnɑ ɩ́ hɑ Hilɑm kɛ ɑcɑlɛɛ hiu kɛ Kɑlilee tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K19_12","012_9_12","1KI","9","12","12","Ḿpʋ́ɣʋ́ ɩ lɩɩ Tiii nɑ ɩ́ kɔɔ ɑcɑlɛɛ ɑnǝɣɩ nɑʋ. Amɑ ɩ lɑŋlɛ tɑ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("K19_13","012_9_13","1KI","9","13","13","Ntɛnɑ ɩ́ tɔ sɩ: Mɑ tɑɑpɑlʋ Sɑlʋmɔŋ, ɑcɑlɛɛ nnɑ n hɑ-m ɩsǝntɔ tɔ ɑ tɑ nii ɩsǝlɛ. Pǝ tɔɔ kɛ́ hɑlǝnɑ sɑŋɑ pɑ sʋʋ hɔɣɔlʋɣʋ ŋkʋɣʋ yɑɑʋ sɩ: Tɛtʋ tɑ nii ɩsǝlɛ. ");
INSERT INTO dop_vpl VALUES ("K19_14","012_9_14","1KI","9","14","14","Pǝyele wʋlɑ tɔɔnǝnɑɑ tooso nɑ hɔɣɔlʋɣʋ kɛ Hilɑm kɑ tilinɑ Sɑlʋmɔŋ. ");
INSERT INTO dop_vpl VALUES ("K19_15","012_9_15","1KI","9","15","15","Tǝlɑsɩ tǝmɑ kɛ wulɑʋ Sɑlʋmɔŋ kɑ tʋwɑ yǝlɑɑ nɑ pɑ́ ŋmɑ́ Ɩsɔ tǝsɛɛlɛ nɑ ɩ kɑwulɑɣɑ tǝyɑɣɑ, nɑ Milo, nɑ Yosɑlɛm koloosi. Ɩlɛnɑ pɑ́ ŋmɑ́ Hɑsɔɔ nɑ Mekito nɑ Kesɛɛ pǝ ɑcɑlɛɛ. ");
INSERT INTO dop_vpl VALUES ("K19_16","012_9_16","1KI","9","16","16","Icipiti wulɑʋ kɑ yoonɑ Kesɛɛ ɩcɑtɛ kɛ́, nɑ ɩ́ kʋ́ Kɑnɑɑŋ nyǝ́mɑ mpɑ pɑɑ wɛ tǝ tɑɑ tɔ nɑ ɩ́ sɔ-tɛɣɛ kɔkɔ. Pǝ wɑɑlɩ kɛ́ Icipiti wulɑʋ pɛɛlɔ sɑɑ wulɑʋ Sɑlʋmɔŋ ɩlɛnɑ Icipiti wulɑʋ hɑ Sɑlʋmɔŋ kɛ ɩcɑtɛ ntɛ. ");
INSERT INTO dop_vpl VALUES ("K19_17","012_9_17","1KI","9","17","17","Pǝ tɔɔ kɛ́ Sɑlʋmɔŋ tɑɣɑnɑ-tɛɣɛ ŋmɑʋ, nɑ ɩ́ ŋmɑ́ tɔtɔɣɔ Pɛtɩ-Holoŋ-Pǝtɛɛ nyǝŋ, ");
INSERT INTO dop_vpl VALUES ("K19_18","012_9_18","1KI","9","18","18","nɑ Pɑɑlɑ nɑ Tɑmɑɑ kɛ wʋlɑɣɑ tɛtʋ hɔɣɔlʋɣʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K19_19","012_9_19","1KI","9","19","19","Nɑ ɑcɑlɛɛ wenɑ ɑ tɑɑ ɩ sɩɩkɑɣɑ ɩ tɔɣɔnɑsɩ tɔ. Nɑ wenɑ ɑ tɑɑ ɩ sɩɩkɑɣɑ yoou kɛɛkɛnɑɑ, nɑ kpɑɣɑnǝŋ tɔ. Nɑ Sɑlʋmɔŋ ŋmɑ́ pǝ tǝnɑ mpi ɩ cɑɑ tɔɣɔ Yosɑlɛm ɩcɑtɛ tɑɑ mɑɣɑmɑɣɑ, nɑ Lipɑŋ pʋɣʋ tɑɑ nɑ ɩ tɛtʋ tǝnɑ tɑɑ. Ɩsǝnɑ Sɑlʋmɔŋ kɑ tɑɣɑnɑ tǝlɑsɩ tǝmɑ ɑnɩ tɔɣɔlɔ. ");
INSERT INTO dop_vpl VALUES ("K19_20","012_9_20","1KI","9","20","20","Wɑɑtʋ ɩnɩ ɩ tɑɑ, yǝlɑɑ mpɑ pɑ tɑɑ kɛ́ Ɩsɛɣɛlɩ nyǝ́mɑ tɔ pɑ wɛ tɛtʋ tɑɑ kɛ́. Ɩsɩɩ Amolii nyǝ́mɑ, nɑ Hiti nyǝ́mɑ, nɑ Peliisi nyǝ́mɑ, nɑ Hifi nyǝ́mɑ, nɑ Yepusi nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("K19_21","012_9_21","1KI","9","21","21","Ɩsɛɣɛlɩ nyǝ́mɑ tɑɑ pǝsɩ nɑ pɑ́ kʋ-wɛ tɔɣɔ pɑ kɑɑsɑɑ. Mpɛɣɛ Sɑlʋmɔŋ tʋwɑ tǝlɑsɩ tǝmɑ, nɑ pɑ́ lɑkɩ ḿpʋ́ɣʋ́ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("K19_22","012_9_22","1KI","9","22","22","Amɑ pǝ kɑɑsɑ Ɩsɛɣɛlɩ nyǝ́mɑ tɔ, wulɑʋ tɑ tʋ pɛlɛɣɛ tǝmɑ kɛ mpʋ. Pɛlɛɣɛlɛ ɩ wɑɑlɩ nyǝ́mɑ, nɑ ɩ yoolɑɑ sɔsɑɑ, nɑ sǝkpemɑ, nɑ yoou kɛɛkɛnɑɑ nɑ kpɑɣɑnǝŋ pɑɑsǝnlɑɑ. ");
INSERT INTO dop_vpl VALUES ("K19_23","012_9_23","1KI","9","23","23","Ḿpʋ́ɣʋ́ tǝmlɛ pɑɑsǝnlɑɑ kpɑ tǝmɑ lɑtɑɑ kpekɑ nyʋɣʋ nyǝ́mɑ kɛ nɑsǝlɛ nɑ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (550) nɑ pɑ́ feŋiɣi Sɑlʋmɔŋ tǝmlɛ lɑtɑɑ. ");
INSERT INTO dop_vpl VALUES ("K19_24","012_9_24","1KI","9","24","24","Wɑɑtʋ wei Sɑlʋmɔŋ ɑlʋ Icipiti nyǝŋ lɩɩ Tɑfiiti tɛ, nɑ ɩ́ sʋʋ tǝyɑɣɑ ŋkɑ ɩ pɑɑlʋ ŋmɑ-ɩ tɔ kɑ tɑɑ, ɩlɛnɑ wulɑʋ tɑɣɑnɩ lonte ntɛ́ nɑ ɩ́ ŋmɑ́ tɑɣɑ ŋkɑ pɑ yɑɑnɑ pɑ tɛ tɑɑ sɩ Milo tɔ. ");
INSERT INTO dop_vpl VALUES ("K19_25","012_9_25","1KI","9","25","25","Pɑɑ pǝnɑɣɑ ŋkɑ tɔm toosoɣo Sɑlʋmɔŋ lɑkɑɣɑ Tɑcɑɑ kɛ kɔtɑsɩ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔ, nɑ ciikuɣu nyǝnsɩ kɛ kɔtɑɣɑ tǝlɑtɛ nte ɩ ŋmɑ-ɩ tɔ tǝ tɔɔ. Ḿpʋ́ɣʋ́ ɩ lɑkɑɣɑ tǝmɑ wenɑ ɑ tɔɔ pɑ́ ŋmɑ́ Ɩsɔ tǝsɛɛlɛ ntɛ́ tɔ. ");
INSERT INTO dop_vpl VALUES ("K19_26","012_9_26","1KI","9","26","26","Ɩlɛnɑ Sɑlʋmɔŋ yele, nɑ pɑ́ sɑɑkɩ kpɩɩlǝŋ kɛ Ɩsǝyɔŋ-Kepɛɛ, kɛ Ɩlɑ cɔlɔɣɔ teŋku kʋsɛɛm nɔɣɔ kɛ Ɩtɔm tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K19_27","012_9_27","1KI","9","27","27","Ḿpʋ́ɣʋ́ Hilɑm ponɑ Sɑlʋmɔŋ kɛ kpɩɩlǝŋ sɑɑlɑɑ kʋpɑmɑ, nɑ pɑ́ sǝŋnɑ ɩ nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("K19_28","012_9_28","1KI","9","28","28","Ɩlɛnɑ pɑ tǝnɑ pɑ́ polo Ofii tɛtʋ tɑɑ nɑ pɑ́ kpɑɣɑ wʋlɑ kɛ kiloonɑɑ iyisi nɑɑnʋwɑ nɑ nɑɑlɛ (12000) nɑ pɑ́ ponɑ Sɑlʋmɔŋ. ");
INSERT INTO dop_vpl VALUES ("K110_1","012_10_1","1KI","10","1","1","Ḿpʋ́ɣʋ́ Sɑpɑ tɛtʋ wulɑʋ ɑlʋ nyǝŋ nɩɩwɑ Sɑlʋmɔŋ hǝtɛ yɑɑʋ. Ɩlɛnɑ ɩ́ polo sɩ ɩ pɔɔsǝɣɩ-ɩ tɔmnɑɑ kɑtɛ nyǝntʋ, nɑ ɩ́ nɑ́ ɩ nyǝm tǝnɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K110_2","012_10_2","1KI","10","2","2","Alʋ ɩnɩ ɩ tɑlɑ Yosɑlɛm tɑɑ tɔ, nɑ ɩ yomɑɑ kɛ tuutuumɑ, nɑ yooyoonɑɑ nɑ́ɑ́ sǝɣǝlɑ tulɑɑlʋnɑɑ, nɑ wʋlɑnɑɑ, nɑ liɣitee pɛɛ kɛ tuutuumɑ. Ɩlɛnɑ ɩ́ pɔɔsɩ Sɑlʋmɔŋ kɛ tɔmnɑɑ mpɑ pɑ tǝnɑ ɩ kɑ tɑɣɑnɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K110_3","012_10_3","1KI","10","3","3","Nɑ Sɑlʋmɔŋ cɔ tǝ tǝnɑ, ɩ tɑ sɔɔ kʋlʋmʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K110_4","012_10_4","1KI","10","4","4","Ḿpʋ́ɣʋ́ ɑlʋ ɩnɩ ɩ nɩɩnɑ ɩ ŋkpɑŋʋɣʋ kɛ sɑlʋmɔŋ nyǝm tɔm, nɑ ɩ́ sɑ ɩ kɑwulɑɣɑ tǝyɑɣɑ ŋkɑ ɩ ŋmɑwɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K110_5","012_10_5","1KI","10","5","5","Nɑ tɔɣɔnɑɣɑ ŋkɑ pɑ sɑɑkɑɣɑ tɔ. Nɑ yɑɑsi wei Sɑlʋmɔŋ kɑ tɑɣɑnnɑ ɩ wɑɑlɩ nyǝ́mɑ nɑ pɑ́ lɑkɩ tǝmɑ tɔ. Nɑ kʋtɔɣɔʋ nɑ kʋnyɔnyɔɔm tɑllɑɑ wontu. Nɑ kɔtɑsɩ nsi pɑ lɑkɑɣɑ Tɑcɑɑ kɛ Ɩsɔ tǝsɛɛlɛ tɑɑ tɔ, nɑ pǝ́ lɑ Sɑpɑ wulɑʋ ɩnǝɣɩ piti nɑ pǝ́ mɔtɩ ɩ nɔɣɔ. ");
INSERT INTO dop_vpl VALUES ("K110_6","012_10_6","1KI","10","6","7","Ntɛnɑ wulɑʋ ɑlʋ nyǝŋ ɩnɩ ɩ tɔ sɩ: Pɑ kɛɛsɑ-m nyɑ́ nyǝm tɔm kɛ hɑtoo mɑ tɛ. Amɑ mɑ ɩsɛ tɑɑ nɑtɑ, ɩlɛ mɑ tɑ mʋ-tɩ. Amɑ nɔɔnɔɔ mɑ nɑwɑ sɩ tɑmpɑnɑ kɛ pɑ heelɑ-m tǝcʋŋŋ. Nyɑ́ nyʋɣʋ kʋlʋɣʋ nɑ nyɑ́ nyǝm tɛɛwɑ ɩsɩɩ pɑɑ kɛɛsɑ-m tɔ tǝyɑmyɑm. ");
INSERT INTO dop_vpl VALUES ("K110_8","012_10_8","1KI","10","8","8","Nyɑ́ wɑɑlɩ nyǝ́mɑ nɑ nyɑ́ tǝyɑɣɑ tɑɑ yǝlɑɑ tǝnɑ lɑpɑ nyʋleleŋ kɛ́. Mpi tɔ, pɑ wɛ nyɑ́ kiŋ nɑ pɑ́ nɩɩkɩ nyǝm tɔm kɛ tɑm. ");
INSERT INTO dop_vpl VALUES ("K110_9","012_10_9","1KI","10","9","9","Mɑ sɑmɑ nyɑ́ Ɩsɔ Tɑcɑɑ wei ɩ lǝsɑ-ŋ sɩ ń tɔɣɔ kɑwulɑɣɑ kɛ Ɩsɛɣɛlɩ tɑɑ tɔ. Ɩsɔ sɔɔlɑ ɩ yǝlɑɑ kɛ tɑm tɔɔ tɔɣɔ ɩ kpɑ-ŋ pɑ wulɑʋ, nɑ ɩ́ tʋ-ŋ sɩ ń tǝŋ tɑmpɑnɑ nɑ ń lɑkɩ kʋsiɣisim. ");
INSERT INTO dop_vpl VALUES ("K110_10","012_10_10","1KI","10","10","10","Pǝlɛ pǝ wɑɑlɩ kɛ́ Sɑpɑ wulɑʋ ɩnɩ ɩ hɑwɑ Sɑlʋmɔŋ kɛ wʋlɑ tɔɔnǝnɑɑ tooso nɑ hɔɔlʋɣʋ nɑ tulɑɑlʋ kɛ sɔsɔm, nɑ liɣitee pɛɛ tɔtɔ. Too tɔ, nɔɣɔlʋ tɑ nɑtɑ tulɑɑlʋ ɩsɩɩ ḿpʋ́ɣʋ́ Ɩsɛɣɛlɩ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K110_11","012_10_11","1KI","10","11","11","Ḿpʋ́ɣʋ́ wulɑʋ Hilɑm kpɩɩlǝŋ polɑ Ofii tɛtʋ tɑɑ nɑ pɑ́ kɔnɑ wʋlɑ, nɑ kpeŋkpelɑsɩ kʋpɑŋsɩ nɑsǝlɩ nɑ liɣitee pɛɛ. ");
INSERT INTO dop_vpl VALUES ("K110_12","012_10_12","1KI","10","12","12","Kpeŋkpelɑsɩ nsǝɣɩ Sɑlʋmɔŋ yelɑɑ nɑ pɑ́ kɑɣɑ Ɩsɔ tǝsɛɛlɛ tɑɑ nɑ ɩ kɑwulɑɣɑ tǝyɑɣɑ tɑɑ tɔtɔ. Ɩlɛnɑ pǝ́ kɑɑsɩ nɑ pɑ́ sɑɑkɩ yonyoolɑɑ kɛ sɑŋkʋnɑɑ. Too tɔ, nɔɣɔlʋ tɑ nɑtɑ Ɩsɛɣɛlɩ tɑɑ kɛ́ kpeŋkpelɑsɩ nɑ sɩ tɔɔʋ tɑlɑ mpʋ pǝ tɑkɑ. ");
INSERT INTO dop_vpl VALUES ("K110_13","012_10_13","1KI","10","13","13","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ hɑwɑ ɑlʋ ɩnǝɣɩ pǝ tǝnɑ mpi ɩ nɑwɑ nɑ ɩ́ sǝlǝmɩ tɔ. Nɑ ɩ́ lɑpɩ-ɩ kʋcɔɔŋ tɔtɔɣɔ ɩsǝnɑ ɩ pǝsɑɑ tɔ. Ɩlɛnɑ wulɑʋ ɑlʋ nyǝŋ ɩnɩ nɑ ɩ wɑɑlɩ nyǝ́mɑ pɑ́ mǝlɩ pɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K110_14","012_10_14","1KI","10","14","14","Pɑɑ pǝnɑɣɑ ŋkɑ wʋlɑ kiloonɑɑ iyisi hiu (20000) kɛ pɑ kɔŋnɑ wulɑʋ Sɑlʋmɔŋ. ");
INSERT INTO dop_vpl VALUES ("K110_15","012_10_15","1KI","10","15","15","Ɩlɛnɑ pǝ́cɔ́ pǝ́ kɑɑsɩ mpi mpi tɑɑtǝlɑɑ fɛlɑɣɑ-ɩ wontunɑɑ tɔɔ tɔ, nɑ lɑmpuunɑɑ mpɑ ɩ kʋmɑtɑŋnɑɑ sɔsɑɑ, nɑ Lɑɑlupunɑɑ ɑwulɑɑ fɛlɑɣɑ-ɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("K110_16","012_10_16","1KI","10","16","16","Ḿpʋ́ɣʋ́ wulɑʋ Sɑlʋmɔŋ yelɑɑ nɑ pɑ́ lu wʋlɑ kpɑlǝŋ kɛ ŋmʋnʋɣʋ (200). Pɑɑ ŋku kʋ tɔɣɔ wʋlɑ kiloonɑɑ nɑɑtoso. ");
INSERT INTO dop_vpl VALUES ("K110_17","012_10_17","1KI","10","17","17","Kpɑlǝŋ sǝkpeŋ kɛ ŋmʋnʋɣʋ nɩɩnʋwɑ (300). Pɑɑ ŋku kʋ tɔɣɔ wʋlɑ kiloo kʋlʋm nɑ titite. Nɑ pɑ́ sɩɩ kutuluɣu ŋku pɑ yɑɑ sɩ Lipɑŋ hɔtʋɣʋ tɔ kʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K110_18","012_10_18","1KI","10","18","18","Nɑ wulɑʋ yele nɑ pɑ́ sɑɑkɩ kɑwulɑɣɑ kpelɑɣɑ nɑ tuu kelɑ, nɑ pɑ́ tʋ́ kɑ tɔɔ kɛ́ wʋlɑ. ");
INSERT INTO dop_vpl VALUES ("K110_19","012_10_19","1KI","10","19","19","Ḿpʋ́ɣʋ́ pɑ lɑpɑ tǝkpɑlɛ kɛ kumlee nɑɑtoso kɛ tǝmɑ tɔɔ, nɑ pɑ́ sɩɩ kpelɑɣɑ ŋkɛ́. Pɑɑ sɑɑkɑ-kɛɣɛ nɑ pɑ́ tʋ tǝteesile kukulukulle, nɑ pɑ́ tʋ́ tɔɣɔlɑsɩ lɛɛsǝŋ kɛ ŋkpɑlɑsɩ tǝsɩɩlɛ. ");
INSERT INTO dop_vpl VALUES ("K110_20","012_10_20","1KI","10","20","20","Nɑ tɔɣɔlɑsɩ lɛɛsǝŋ nɑɑnʋwɑ nɑ nɑɑlɛɣɛ kumlee ɑnɩ ɑ tɔɔ. Nɑɑtoso kɛ ntɔɣɔŋ tɔɔ, nɑ nɑɑtoso kɛ mpǝtǝŋ tɔɔ. Wulɑʋ nɔɣɔlʋ ɩ tɑ sɑɑkǝtɑ kɑwulɑɣɑ kpelɑɣɑ ŋkɛ kɑ tɑkɑ. ");
INSERT INTO dop_vpl VALUES ("K110_21","012_10_21","1KI","10","21","21","Wʋlɑ kɛ pɑɑ lupɑ Sɑlʋmɔŋ tǝyɑɣɑ tɑɑ lʋm poosiyɑnɑɑ tǝnɑ, nɑ Lipɑŋ hɔtʋɣʋ kutuluɣu tɑɑ wontunɑɑ kʋtǝsǝtʋ. ");
INSERT INTO dop_vpl VALUES ("K110_22","012_10_22","1KI","10","22","22","Wulɑʋ kɑ wɛnɑ ɩ mɑɣɑmɑɣɑ ɩ kpɩɩlǝŋ kɛ́. Nɑ ɩ nɑ Hilɑm nyǝŋ pɑ́ puki pooluŋ. Pɑɑ pɩɩsɩ tooso wei, pɑ kɔŋnɑ wʋlɑ nɑ liɣitee nyǝɣǝtʋ, nɑ tuu kelɑ, nɑ tǝkpɑɑlǝŋ nɑ kɑcɔkɑ sumɑsɩ sɔsɔɔnsɩ nɑsǝlɩ. ");
INSERT INTO dop_vpl VALUES ("K110_23","012_10_23","1KI","10","23","23","Sɑlʋmɔŋ kɑ tɛɛ ɑntulinyɑ tǝnɑ ɑwulɑɑ tǝnɑɣɑ toŋ kɛ́ nɑ nyǝm. ");
INSERT INTO dop_vpl VALUES ("K110_24","012_10_24","1KI","10","24","24","Pɔpɔtʋ fɛɩ leleŋ, Ɩsɔ kɑ hɑ-ɩ nyǝm kɛ́ nɑ yǝlɑɑ lɩɩkǝnɑ pɑɑ timpi nɑ pɑ́ kɔŋɩ-ɩ tɔmnɑɑ pɔɔsʋɣʋ. ");
INSERT INTO dop_vpl VALUES ("K110_25","012_10_25","1KI","10","25","25","Pɑɑ pǝnɑɣɑ ŋkɑ, yǝlɑɑ mpɛ pɑ kɔŋɑɣɑnɑ-ɩ kʋcɔɔŋ kɛ liɣitee wontu, nɑ wʋlɑ, nɑ wontu kʋsusuutu, nɑ yoou wontu, nɑ tulɑɑlʋnɑɑ, nɑ kpɑɣɑnǝŋ, nɑ kpɑŋɑsɩ. ");
INSERT INTO dop_vpl VALUES ("K110_26","012_10_26","1KI","10","26","26","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ kpeɣelɑ ɩ yoou kɛɛkɛnɑɑ, nɑ pǝ kpɑɣɑnǝŋ, nɑ pǝ́ lɩɩ kɛɛkɛnɑɑ iyɑɣɑ nɑ nɑsǝlɛ (1400), nɑ kpɑɣɑnǝŋ iyisi nɑɑnʋwɑ nɑ nɑɑlɛ (12000). Ɩlɛnɑ Sɑlʋmɔŋ cosi pǝ tɑɑ nɑ ɩ́ sɩɩ ɩ kiŋ kɛ Yosɑlɛm. Pǝ kɑɑsɑ nti ɩlɛnɑ pɑ́ sɩɩ tǝlɛɣɛ timpi timpi pɑɑ tɑɣɑnɑɑ sɩ pɑɑ sɩɩ-tɩ tɔ. ");
INSERT INTO dop_vpl VALUES ("K110_27","012_10_27","1KI","10","27","27","Sɑlʋmɔŋ kɑwulɑɣɑ wɑɑtʋ, liɣitee kɑ wɛ Yosɑlɛm tɑɑ kɛ́ ɩsɩɩ pɛɛ. Nɑ pǝ́ kɑɑsɩ nɑ kpeŋkpelɑsɩ kʋpɑŋsɩ nɑ́ɑ́ tɔlɩ yem ɩsɩɩ tɩɩŋ kpɑɩ nyǝŋ wei ɩ nyɔɔkɩ tɛtɛkǝlɛ tɑɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K110_28","012_10_28","1KI","10","28","28","Icipiti nɑ Silisii pǝ ɑcɑlɛɛ tɑɑ kɛ́ pɑɣɑtǝlɑɑ pukɑɣɑ nɑ pɑ́ yɑkɩ wulɑʋ kɛ kpɑɣɑnǝŋ nɑ pɑ́ kɔŋnɑ. ");
INSERT INTO dop_vpl VALUES ("K110_29","012_10_29","1KI","10","29","29","Liɣitee nyǝɣǝtʋ nɑsǝtoso (600) kɛ pɑ yɑkɑɣɑ Icipiti yoou kɛɛkɛnɑɑ. Ɩlɛnɑ pɑ́ yɑ kpɑɣɑnǝŋ kɛ nyǝɣǝtʋ nɩɩnʋwɑ nɑ nɩɩlɛ nɑ nɑɑnʋwɑ (150). Pɑɣɑtǝlɑɑ kʋlʋmɑɑ mpɛ pɑ́ yɑkɑɣɑnɑ nɑ pɑ́ pukinɑ Hiti ɑwulɑɑ nɑ Silii nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Icipiti wulɑʋ pɛɛlɔ pɑɑsi, Sɑlʋmɔŋ tɑsɑ piitimnɑɑ kpɑɩ nyǝm pɑɣɑlɛ ɑlɑɑ kɛlʋɣʋ kɛ́. Pɑɑ Mowɑpʋ nyǝ́mɑ, pɑɑ Amoni nyǝ́mɑ, pɑɑ Ɩtɔm nyǝ́mɑ, pɑɑ Sitɔŋ nyǝ́mɑ, pɑɑ Hiti nyǝ́mɑ. ");
INSERT INTO dop_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Pǝyele Tɑcɑɑ kɑ tɛmɑ Ɩsɛɣɛlɩ nyǝ́mɑ kɛ kisinɑʋ kɛ piitim kpɑɩ nyǝmnɑɑ mpɛ pɑ tɔm kɛ́ sɩ, pɑ́ nɑ wɛ pɑ́ tɑɑ kpɑɣɑ tǝmɑ pǝ́cɔ́ pɑ tɑɑ sɑɑ tǝmɑ. Pǝ tɑɑ kɔɔ nɑ pɛlɛ pɑ́ sʋsɩ-wɛɣɛ pɑ tɩɩŋ lɑɑʋ tɑɑ. Amɑ Sɑlʋmɔŋ luɣu nɑ́ sʋʋ piitim kpɑɩ nyǝm mpɩ pǝ ɑlɑɑ kɛ́. ");
INSERT INTO dop_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Hɑlǝnɑ ɩ́ kpɑɣɑ ɑwulumpiyɑ ɑlɑɑ kɛ nɑsǝtoso nɑ nɩɩnʋwɑ (700), nɑ ɑlɑɑ lɛlɑɑ kɛ ŋmʋnʋɣʋ nɑ nɩɩnʋwɑ (300). Mpɛ ɩnɩ pɑ tolisinɑ-ɩ sɔsɔm. ");
INSERT INTO dop_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Tɑmpɑnɑ tɔɔ pǝ kɔmɑ nɑ Sɑlʋmɔŋ kpɑtǝlɩ, ɩlɛnɑ ɩ ɑlɑɑ mpɛ pɑ́ sʋsɩ-ɩ tɩɩŋ lɑɑʋ tɑɑ. Hɑlǝnɑ ɩ́ yele ɩ Ɩsɔ Tɑcɑɑ kɛ sɔɔlʋɣʋ nɑ lotu kʋlʋmtʋ ɩsɩɩ ɩ cɑɑ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ lɑɑ Sitɔŋ nyǝ́mɑ tʋɣʋ ɑlʋ nyǝŋkʋ Asǝtɑtɩ nɑ Amoni nyǝ́mɑ tʋɣʋ ɩsɑɣɑʋ Milikom. ");
INSERT INTO dop_vpl VALUES ("K111_6","012_11_6","1KI","11","6","6","Tǝnɑɣɑ ɩ lɑpǝnɑ mpi pǝ tɑ mɑɣɑ Tɑcɑɑ tɔ. Mpi tɔ, ɩɩ tɑsǝɣɩ-ɩ nɩɩnɑʋ kɛ teu ɩsɩɩ ɩ cɑɑ Tɑfiiti. ");
INSERT INTO dop_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Wɑɑtʋ ɩnɩ ɩ tɑɑ kɛ́ Sɑlʋmɔŋ ŋmɑ́ Mowɑpʋ nyǝ́mɑ tʋɣʋ ɩsɑɣɑʋ Kɛmɔsɩ kɛ kutuluɣu kɛ pulɑɣɑ tɔɔ kɛ́ Yosɑlɛm ɩsɛntɑɑ, nɑ ɩ́ ŋmɑ́ Amoni nyǝ́mɑ tʋɣʋ ɩsɑɣɑʋ Milikom kutuluɣu tɔtɔ. ");
INSERT INTO dop_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Nɑ ɩ́ ŋmɑ́ mpʋ tɔtɔɣɔ ɩ ɑlɑɑ mpɑ pɑ tɑ nyɩ Ɩsɔ tɔ pɑ tɩɩŋ sɩ pɑ́ wɔkɩ-ɩ tulɑɑlʋnɑɑ, nɑ pɑ́ lɑɑkɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("K111_9","012_11_9","1KI","11","9","10","Tɔm nɑɑlɛɣɛ Tɑcɑɑ Ɩsɛɣɛlɩ Ɩsɔ kɑ́ lɩɩ Sɑlʋmɔŋ tɔɔ, nɑ ɩ́ heeli-ɩ tǝsiɣisiɣi sɩ: Tɑɑ luŋ tɩɩŋ. Amɑ Sɑlʋmɔŋ tɑ́ nɩɩnɑ Tɑcɑɑ, ɩlɛnɑ Tɑcɑɑ nɑ́ɑ́ mʋ-ɩ nɑ pɑ́ɑ́nɑ́. ");
INSERT INTO dop_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Nɑ ɩ́ yɔɣɔtɩ-ɩ sɩ: Timpi ń tɔmɑ mpʋ pǝ tɑkɑ nɑ ń kisi mɑ kʋsǝsɩɩtʋ nɑ ń yɔkɩ mɑ nɑ-ŋ tɑ nɔɣɔ pɛɛlʋɣʋ tǝfɑɑ tɔ, mɑɑ lɛɛkɩ nyɑ́ kɑwulɑɣɑ nɑ mɑ́ cɛlɑ-kɛɣɛ nyɑ́ wɑɑlɩ nyǝ́mɑ tɑɑ nɔɣɔlʋ. ");
INSERT INTO dop_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Pɑɑ nɑ mpʋ nyɑ́ cɑɑ Tɑfiiti tɔɔ mɑ kɑɑ lɑ-ŋ mpʋ, hɑlǝnɑ nyɑ́ sǝm. Amɑ nyɑ́ pǝyɑɣɑ kɛ mɑɑ lɛɛkɩ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","Tɑfiiti kʋlʋm ɩnɩ nɑ Yosɑlɛm ɩcɑtɛ nte mɑ́ lǝsɑɑ tɔ, pɑ tɔɔ tɔtɔɣɔ mɑɑ kɑɑsɩ-ɩ kpekǝle kʋlʋmtǝlɛ. ");
INSERT INTO dop_vpl VALUES ("K111_14","012_11_14","1KI","11","14","14","Ḿpʋ́ɣʋ́ Tɑcɑɑ lɑpɑ nɑ Ɩtɔm ɑwulumpu Hɑtɑtɩ lɩɩ Sɑlʋmɔŋ kɛ koloŋɑ. ");
INSERT INTO dop_vpl VALUES ("K111_15","012_11_15","1KI","11","15","16","Wɑɑtʋ nɔɣɔlʋ Tɑfiiti kɑ́ yoonɑ Ɩtɔm nyǝ́mɑ nɑ ɩ́ kǝlɩ-wɛ. Ɩlɛnɑ ɩ yoolɑɑ wulɑʋ Sowɑpɩ nɑ ɩ yoolɑɑ pɑ́ polo Ɩsɛɣɛlɩ nyǝ́mɑ mpɑ pɑ́ sǝpɑ tǝyoole tɔɣɔ pim. Ḿpʋ́ɣʋ́ pɑ́ cɑɣɑ tǝnɑɣɑ ɩsɔtʋnɑɑ nɑɑtosompɔɣɔlɑɣɑ, nɑ pɑ́ kʋ Ɩtɔm ɑpɑlɑɑ nɑ pɑ́ kpɛnnɑ ɑpɑlʋpiyɑ. ");
INSERT INTO dop_vpl VALUES ("K111_17","012_11_17","1KI","11","17","17","Wɑɑtʋ ɩnɩ Hɑtɑtɩ kɑ kɛ́ pǝyɑɣɑ. Ḿpʋ́ɣʋ́ ɩ nɑ ɩ cɑɑ tǝmlɛ nyǝ́mɑ Ɩtɔm nyǝ́mɑ nɑpǝlɩ pɑ́ sewɑ nɑ pɑ́ polo Icipiti. ");
INSERT INTO dop_vpl VALUES ("K111_18","012_11_18","1KI","11","18","18","Pɑ kʋlɑ Mɑtiyɑŋ, ɩlɛnɑ pɑ́ fɑɣɑnɑ Pɑlɑŋ wʋlɑɣɑ tɛtʋ tɑɑ. Pɑ kpɛŋnɑ ɑpɑlɑɑ nɑpǝlɩ nɑ pɑ́ ponɑ Icipiti. Ntɛnɑ Icipiti wulɑʋ hɑ Hɑtɑtɩ kɛ tǝyɑɣɑ nɑ tɛtʋ, nɑ ɩ́ heeli-ɩ sɩ: Mɑɑ tɔɔ-ŋ. ");
INSERT INTO dop_vpl VALUES ("K111_19","012_11_19","1KI","11","19","19","Icipiti wulɑʋ lɑpɑ Hɑtɑtɩ kɛ kʋpɑntʋ kɛ́. Ɩ hɑ-ɩ ɩ ɑlʋ Tɑpǝnɛsɩ neu nɑ ɩ́ lɑ ɑlʋ. ");
INSERT INTO dop_vpl VALUES ("K111_20","012_11_20","1KI","11","20","20","Ḿpʋ́ɣʋ́ ɑlʋ ɩnɩ ɩ lʋlɑ ɑpɑlʋpǝyɑɣɑ nɑ Hɑtɑtɩ hɑ-kɛɣɛ hǝtɛ sɩ Kenupɑ. Kɑ cɛpɑ hǝtɛ, ɩlɛnɑ Tɑpǝnɛsɩ mʋ-kɛ nɑ ɩ́ tɔɔ-kɛɣɛ wulɑʋ tǝyɑɣɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K111_21","012_11_21","1KI","11","21","21","Wɑɑtʋ wei Hɑtɑtɩ nɩɩwɑ sɩ Tɑfiiti nɑ ɩ yoolɑɑ wulɑʋ Sowɑpɩ pɑ́ sǝpɑ, ɩlɛnɑ ɩ́ sǝlǝmɩ Icipiti wulɑʋ sɩ: Yele nɑ mɑ́ mǝlɩ mɑ tɛtʋ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K111_22","012_11_22","1KI","11","22","22","Ntɛnɑ Icipiti wulɑʋ pɔɔsɩ Hɑtɑtɩ sɩ: Pepeɣe ń lɑŋɑ mɑ kiŋ nɑ ń nyɩɩlǝɣɩ kpente? Mpʋɣʋlɛ sɩ: Mɑ tɑ lɑŋ pʋlʋ yɑɑ. Ɩlɛ yele-m nɑ mɑ́ mǝlɩ te. ");
INSERT INTO dop_vpl VALUES ("K111_23","012_11_23","1KI","11","23","23","Ḿpʋ́ɣʋ́ Ɩsɔ yelɑɑ nɑ Sɑlʋmɔŋ wɛɛnɑ kolontu lɛlʋ. Ɩlɛɣɛlɛ Iliyɑtɑ pǝyɑlʋ Lesɔŋ wei ɩ kɑ sewɑ ɩ cɑɑ Hɑtɑtǝsɛɛ wei ɩ kɛ Sopɑ wulɑʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K111_24","012_11_24","1KI","11","24","24","Wɑɑtʋ wei Tɑfiiti kɑ kʋwɑ Hɑtɑtǝsɛɛ yoolɑɑ tɔɣɔ Lesɔŋ kotɑ tɛtɛlɑtɑɑ kɛ ɩ kiŋ, nɑ ɩ́ pǝsɩ pɑ nyʋɣʋ tʋ nɑ pɑ́ polo Tɑmɑsɩ nɑ pɑ́ cɑɣɑ tǝnɑ, nɑ ɩ́ cɑŋ ɩ tɔkɩ kɑwulɑɣɑ ");
INSERT INTO dop_vpl VALUES ("K111_25","012_11_25","1KI","11","25","25","kɛ Silii tɛtʋ tɑɑ. Ɩ lɑpɑ Ɩsɛɣɛlɩ nyǝ́mɑ kolontu kɛ Sɑlʋmɔŋ kɑwulɑɣɑ pɩɩsɩ tǝnɑɣɑ, nɑ ɩ́ footiɣi-wɛ nɑ ɩ́ lɑkɩ-wɛɣɛ ɩsɑɣɑtʋ ɩsɩɩ Hɑtɑtɩ. ");
INSERT INTO dop_vpl VALUES ("K111_26","012_11_26","1KI","11","26","27","Sɑlʋmɔŋ kɑ wɛnɑ tǝmlɛ tʋ nɔɣɔlʋ nɑ pɑ́ yɑɑkɩ-ɩ sɩ Solopʋwɑm. Ɩ tɛɣɛlɛ Seletɑ kɛ Ɩfǝlɑyim tɛtʋ tɑɑ. Pɑ yɑɑ ɩ cɑɑ sɩ Nepɑ, nɑ ɩ too sɩ Seluyɑ, ɩ too ɩnɩ ɩ kɛ́ leelu. Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ, Solopʋwɑm kʋlɑ Sɑlʋmɔŋ tɔɔ. Wɑɑtʋ wei Sɑlʋmɔŋ ŋmɑɑkɑɣɑ Milo*fɑ* nɑ Tɑfiiti tɛ koluŋɑ tɔ, sɔɔsɩ tɔɣɔ pɑ yɑɑ mpʋ. ");
INSERT INTO dop_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Solopʋwɑm kɑ kɛ́ ɩfepu kʋpɑŋ kɛ́. Wulɑʋ pɑɑsǝnɑ mpʋ sɩ ɩ lɑkɩ ɩ tǝmlɛ kɛ teu, ɩlɛnɑ ɩ́ kpɑ-ɩ Ɩfǝlɑyim nɑ Mɑnɑsee pɑ kpekɑ tǝlɑsɩ tǝmlɛ nyǝ́mɑ feŋlu. ");
INSERT INTO dop_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ, Solopʋwɑm lɩɩnɑ Yosɑlɛm, nɑ ɩ́ nɑ Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ wei ɩ wɛ Silo nɑ pɑ́ yɑɑkɩ-ɩ sɩ Ahiyɑ tɔ pɑ́ suli mpɑɑʋ tɑɑ kɛ́ pɑ nɑɑlɛɣɛ nyɩɩtʋ tɑɑ, nɑ Ahiyɑ suu kpɑɩ kʋfɑlʋ. ");
INSERT INTO dop_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Tǝnɑɣɑlɛ Ahiyɑ cǝlɑ ɩ kpɑɩ kɛ hɔɣɔlɑsɩ nɑɑnʋwɑ nɑ nɑɑlɛ. ");
INSERT INTO dop_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Pǝ wɑɑlɩ kɛ́ ɩ́ tɔmɑ Solopʋwɑm sɩ: Mʋ hɔɣɔlɑsɩ nɑɑnʋwɑ. Mpi tɔ, Ɩsɛɣɛlɩ Ɩsɔ Tɑcɑɑ yɔɣɔtɑɑ sɩ: Mɑ tɔŋnɑ Sɑlʋmɔŋ kɑwulɑɣɑ lɛɛkʋɣʋ sɩ, mɑ cɛlǝɣɩ-ŋ nɑ ń tɔɣɔ kɑwulɑɣɑ kɛ Ɩsɛɣɛlɩ kpekɑ nɑɑnʋwɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K111_32","012_11_32","1KI","11","32","32","Kpekǝle kʋlʋmtǝlɛ kɛ mɑɑ kɑɑsɩ-ɩ mɑ tǝmlɛ tʋ Tɑfiiti nɑ Yosɑlɛm ɩcɑtɛ pɑ tɔɔ. Mpi tɔ, tǝ tike kɛ mɑ lǝsɑ Ɩsɛɣɛlɩ tɛtʋ tǝnɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K111_33","012_11_33","1KI","11","33","33","Mpi pǝ tɔɔ mɑ lɑkɩ mpʋ tɔ, Ɩsɛɣɛlɩ nyǝ́mɑ lɔ-m nɑ pɑ́ luŋ Sitɔŋ nyǝ́mɑ tʋɣʋ ɑlʋ nyǝŋkʋ Asǝtɑtɩ, nɑ Mowɑpʋ nyǝ́mɑ tʋɣʋ Kɛmɔsɩ, nɑ Amoni nyǝ́mɑ tʋɣʋ Milikom. Ɩsɛɣɛlɩ nyǝ́mɑ kisɑ mpɑɑʋ ŋku mɑɑ hʋlɑ-wɛ tɔɣɔ tǝŋʋɣʋ. Pɑ tɑ lɑ nti tǝ kɛɛsǝnɑ-m tɔ. Pǝyele pɑ tɑ tɔkɩ kʋsǝsɩɩtʋ nɑ nti nti mɑ tʋ-wɛ tɔ, ɩsɩɩ Tɑfiiti lɑkɑɣɑ tɔ. ");
INSERT INTO dop_vpl VALUES ("K111_34","012_11_34","1KI","11","34","34","Pɑɑ nɑ mpʋ mɑ kɑɑ lɛɛkɩ Sɑlʋmɔŋ niŋ tɑɑ kɛ́ kɑwulɑɣɑ. Mɑɑ nyǝnǝɣɩ-ɩ ɩ yǝlɑɑ wulɑʋ kɛ tɑm kɛ́, hɑlǝnɑ ɩ sǝm. Mɑɑ lɑ ḿpʋ́ɣʋ́ mɑ tǝmlɛ tʋ Tɑfiiti wei mɑ lǝsɑɑ, nɑ ɩ́ tɔkɩ mɑ kiiŋ nɑ mɑ kʋtʋtʋtʋ tɔ ɩ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","Amɑ Sɑlʋmɔŋ pǝyɑlʋ kɛ́ mɑɑ lɛɛkɩ ɑwulumpiitu, nɑ mɑ́ cɛlɑ nyɑ́, nɑ ń tɔɣɔ Ɩsɛɣɛlɩ kpekɑ nɑɑnʋwɑ tɔɔ kɛ́ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K111_36","012_11_36","1KI","11","36","36","Pɑɑ nɑ mpʋ mɑɑ yelinɑ ɩ pǝyɑlʋ kɛ́ kpekǝle kʋlʋmtǝlɛ. Ɩlɛ pɩɩ lɑ nɑ Tɑfiiti tǝyɑɣɑ tʋ wɛɛ kɑwulɑɣɑ tɑɑ kɛ́ Yosɑlɛm ɩcɑtɛ nte mɑ lǝsɑɑ sɩ pɑ́ sɛɛ-m tɔ tǝ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K111_37","012_11_37","1KI","11","37","37","Ḿpʋ́ɣʋ́ Tɑcɑɑ tɑsɑɑ sɩ: Solopʋwɑm, mɑɑ cɛlɛ-ŋ kɑwulɑɣɑ ɩsɩɩ n sɔɔlɑɑ tɔ, nɑ ń tɔɣɔ Ɩsɛɣɛlɩ kpekɑ nɑɑnʋwɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K111_38","012_11_38","1KI","11","38","38","Ye ń tɔkǝɣɩ mɑ kʋyɔɣɔtʋtʋ, nɑ ń tǝŋǝɣɩ mpɑɑʋ ŋku mɑ hʋlǝɣɩ-ŋ tɔ, nɑ ń lɑkɩ mpi pǝ kɛɛsǝnɑ-m tɔ, nɑ ń tǝŋǝɣɩ mɑ kiiŋ nɑ mɑ kʋtʋtʋtʋ, ɩsɩɩ mɑ tǝmlɛ tʋ Tɑfiiti. Ɩlɛ mɑɑ wɛɛ nyɑ́ wɑɑlǝɣɩ tɑm nɑ nyɑ́ lʋlʋɣʋ nyǝ́mɑ kɑ́ tɔkɩ kɑwulɑɣɑ kɛ tɑm, ɩsɩɩ Tɑfiiti nyǝ́mɑ. Mɑɑ cɛlɛ-ŋ Ɩsɛɣɛlɩ kpekɑ nɑɑnʋwɑ nɑ nɑɑlɛ, ");
INSERT INTO dop_vpl VALUES ("K111_39","012_11_39","1KI","11","39","39","nɑ pɑ́ nɑ́ nɑ pǝ́ wɩɩ-wɛ. Amɑ pǝ kɑɑ wɛɛ ḿpʋ́ɣʋ́ tɑm. ");
INSERT INTO dop_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Ḿpʋ́ɣʋ́ Sɑlʋmɔŋ pɛɛkɑɑ sɩ ɩ kʋɣʋ Solopʋwɑm. Ɩlɛnɑ Solopʋwɑm se nɑ ɩ́ polo Icipiti wulɑʋ Sisɑkɩ tɛ nɑ ɩ́ tʋ-ɩ kpʋlʋɣʋ. Hɑlǝnɑ Sɑlʋmɔŋ sǝm. ");
INSERT INTO dop_vpl VALUES ("K111_41","012_11_41","1KI","11","41","41","Pɑ kɛɛsɑ Sɑlʋmɔŋ tɔm lɛntǝnɑɑ nɑ ɩ kʋlɑpǝm tǝnɑ, nɑ ɩ nyǝm tǝnɑɣɑ tɑkǝlɑɣɑ ŋkɑ pɑ́ yɑɑ sɩ, Sɑlʋmɔŋ Tɔm tɑkǝlɑɣɑ tɔ kɑ tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Pɩɩsɩ nɩɩlɛ tǝcu kɛ́ Sɑlʋmɔŋ tɔɣɔ kɑwulɑɣɑ kɛ Ɩsɛɣɛlɩ nyǝ́mɑ tǝnɑ tɔɔ kɛ Yosɑlɛm. ");
INSERT INTO dop_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Sɑlʋmɔŋ kɔmɑ nɑ ɩ́ sɩ́, ɩlɛnɑ ɩ pǝyɑlʋ Lʋpʋwɑm lɛɛtɩ ɩ lonte tɑɑ. ");
INSERT INTO dop_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Ḿpʋ́ɣʋ́ kʋyɑkʋ nɑkʋlɩ, Ɩsɛɣɛlɩ ilim ntɔɣɔŋ tɔɔ kpekɑ kotɑ Sikɛm, ɩlɛnɑ Lʋpʋwɑm polo, sɩ pɑ́ kpɑɑkɩ-ɩ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Wɑɑtʋ ɩnɩ tɔ, Nepɑ pǝyɑlʋ Solopʋwɑm wei ɩ́ kɑ́ sewɑ wulɑʋ Sɑlʋmɔŋ nɑ ɩ́ cɔɔsɩ Icipiti tɔ, ɩ wɛ tǝnɑɣɑ tɑm. Ɩ nɩɩwɑ Sikɛm kotuɣu ŋkʋ kʋ tɔm, ɩlɛnɑ ɩ́ tʋ́ ɩ tɑɑ sɩ, ɩ kɑ́ sɑɑlɩ tǝnɑ. ");
INSERT INTO dop_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Amɑ pɑ tilɑ ɩ wɑɑlɩ, nɑ ɩ́ kɔɔ nɑ ɩ́ nɑ ilim ntɔɣɔŋ tɔɔ kpekɑ pɑ́ yɔɣɔtɩ Lʋpʋwɑm sɩ: ");
INSERT INTO dop_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","Nyɑ́ cɑɑ kɑ tʋ-tʋɣʋ tǝlɑsɩ tǝmɑ kɛ́, nɑ tǝ́ fɛlǝɣɩ-ɩ lɑmpuunɑɑ. Ɩlɛ ye nyɑɑ wɑɑsɩ-tʋ nɑ ń sʋkɩ-tʋɣʋ tɑ́ sǝɣǝlɑ ɑnɩ, tɑ́ sɔɔlʋ pɩɩwɑ sɩ tǝ́ nyǝnɩ-ŋ tɑ́ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Mpʋɣʋlɛ Lʋpʋwɑm sɩ: Ɩ́ yele mɑ́ mɑɣɑsɩ mɑ tɑɑ, nɑ cele nɑ kʋ fe ɩ́ kɔɔ nɑ mɑ́ nɑ-mɛ tǝ́ nɑ́. Ɩlɛnɑ ilim ntɔɣɔŋ tɔɔ kpekɑ nyǝ́mɑ tɛɛ. ");
INSERT INTO dop_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Ntɛnɑ Lʋpʋwɑm pɔɔsɩ sɔsɑɑ mpɑ pɑɑ wɛ ɩ cɑɑ cɔlɔɣɔ wɑɑtʋ wei ɩ́lɛ́ ɩ́ kɑ́ wɛnɑ ɩ weesuɣu tɔ sɩ: Suweɣe mɑ́ cɔ yǝlɑɑ mpɛ? ");
INSERT INTO dop_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Sɔsɑɑ sɩ: Ye n hʋlɑ-wɛ sɩ nyɑ́ sɔɔlʋ pɩɩwɑ sɩ n kɑ́ pɑɑsǝnɑ-wɛ, nɑ ń yɔɣɔtǝnɑ-wɛɣɛ tɔm kʋpɑntʋ, nyɑɣɑ pɑɑ nyǝnɩ pɑ wulɑʋ kɛ tɑm tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Amɑ Lʋpʋwɑm tɑ mʋ sɔsɑɑ tɔm ntɩ. Ɩlɛnɑ Lʋpʋwɑm polo ɩ́ pɔɔsɩ ɩ mɑlɑnɑɑ ɩfepiyɑ mpɑ pɑ wɛ ɩnɩ ɩ kiŋ tɔ sɩ: ");
INSERT INTO dop_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Yǝlɑɑ mpɛ sɩ mɑ́ pɑsɑ-wɛɣɛ sǝɣǝlɑ nnɑ mɑ cɑɑ kɑ sʋkɑ-wɛ tɔ. Ɩlɛ mɑ́ cɔ-wɛ suwe? ");
INSERT INTO dop_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Mpʋɣʋlɛ ɩ ɩfepu tɔɣɔntǝlɛnɑɑ mpɛ pɑ́ tɔmɑ sɩ: Cɔ-wɛ sɩ, mpɑlʋm tɑ kisi-wɛɣɛ tɔɣɔʋ, kɑcɑŋfɑnɑ pɔɣɔ nɑ? ");
INSERT INTO dop_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Sǝɣǝlɑ wenɑ mɑɑ sʋkɩ-mɛ tɔ, ɑ kɑ́ kǝlɩ mɑ cɑɑ nyǝnɑ. Pǝ́cɔ́ tǝpilɑ kɛ mɑ cɑɑ kɑ cɑsɑ-mɛ. Amɑ ɑlukpɑlɑ kɛ mɑɑ cɑsɑ-mɛ. ");
INSERT INTO dop_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Ḿpʋ́ɣʋ́ Solopʋwɑm nɑ yǝlɑɑ pɑ mǝlɑ Lʋpʋwɑm kiŋ kɛ kʋyɛɛŋ tooso wule, ɩsɩɩ ɩ kɑ heeluɣu-wɛ tɔ. ");
INSERT INTO dop_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Mpʋɣʋlɛ wulɑʋ kisɑ lɑɣɑtʋ nti sɔsɑɑ kɑ tɑsɑ-ɩ tɔ. Ɩlɛnɑ ɩ́ holinɑ ");
INSERT INTO dop_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","sɑmɑɑ, ɩsɩɩ ɩ ɩfepu tɔɣɔntǝlɛnɑɑ kɑ́ sɛɣɛsɑ-ɩ tɔ sɩ: Ɛɛ, mɑ cɑɑ kɑ́ sʋkɑ-mɛɣɛ sǝɣǝlɑ yuŋ nyǝnɑ. Amɑ mɑɑ sʋkɩ-mɛɣɛ wenɑ ɑ tɛɛ mpʋ tɔ. Pǝ́cɔ́ tǝpilɑ kɛ mɑ cɑɑ kɑ cɑsɑ-mɛ. Amɑ ɑlukpɑlɑ kɛ mɑ́ɑ́ cɑsɑ-mɛ. ");
INSERT INTO dop_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Ɩlɛnɑ Lʋpʋwɑm kisi sɑmɑɑ kɛ nɩɩnɑʋ. Ɩlɛ Tɑcɑɑ kɑ lɑpǝnɑ mpʋ sɩ pǝ́ lɑ teitei ɩsɩɩ ɩ kɑ́ heeluɣu Ɩsɔ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Ahiyɑ kɛ Silo sɩ ɩ́ tɛlǝsɩ Solopʋwɑm tɔ. ");
INSERT INTO dop_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Wɑɑtʋ wei Ɩsɛɣɛlɩ nyǝ́mɑ cɛkǝnɑɑ sɩ wulɑʋ kisɑ pɑ tɔm kɛ mʋɣʋ, ɩlɛnɑ pɑ́ tɔmɩ-ɩ sɩ: Tɑnɑ Tɑfiiti tǝ fɛɩnɑ nɑtǝlɩ. Tɑnɑ-ɩ tǝ kɑɑ we? Ɩsɛɣɛlɩ nyǝ́mɑ mɛ, mɩ́ɩ́ kɔɔ tɑɑ mǝlɩ tɑ́ tɛ́. Tɑfiiti lʋlʋɣʋ tʋ nyɑ́, nyɑɑ tɔɣɔ nyɑ́ kɑwulɑɣɑ. Ɩlɛnɑ pɑ́ yɑ́. ");
INSERT INTO dop_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Yutɑ tɛtʋ yǝlɑɑ tike nyǝnɑɣɑnɑ Lʋpʋwɑm kɛ pɑ wulɑʋ. ");
INSERT INTO dop_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Pɑɑ nɑ mpʋ, nɑ ɩ́ tili tǝlɑsɩ tǝmɑ nyʋɣʋ tʋ Atolɑm kɛ Ɩsɛɣɛlɩ nyǝ́mɑ mpɑ pɑ wɛ ilim ntɔɣɔŋ tɔɔ tɔ pɑ kiŋ. Ɩlɛnɑ pɛlɛ pɑ́ yɑɣɑ Atolɑm kɛ pɛɛ nɑ pɑ́ kʋ́. Ḿpʋ́ɣʋ́ Lʋpʋwɑm kpɑ ɩ kɛɛkɛ tɑɑ kɛ́ kpɑkpɑɑ nɑ ɩ́ se nɑ ɩ́ polo Yosɑlɛm. ");
INSERT INTO dop_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Ɩsǝnɑ ilim ntɔɣɔŋ tɔɔ Ɩsɛɣɛlɩ nyǝ́mɑ kisinɑ Tɑfiiti lʋlʋɣʋ nyǝ́mɑ kɑwulɑɣɑ tɔɣɔlɛ. Nɑ ḿpʋ́ɣʋ́ pǝ wɛ hɑlǝnɑ sɑŋɑ. ");
INSERT INTO dop_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Wɑɑtʋ wei pɑ nɩɩwɑ sɩ Solopʋwɑm mǝlɑɑ, ɩlɛnɑ pɑ́ koti pɑ tɑɑ pɑ tike. Nɑ pɑ́ yɑɑ-ɩ nɑ pɑ́ kpɑ-ɩ Ɩsɛɣɛlɩ kpekɑ tǝnɑ wulɑʋ. Yutɑ kpekǝle tike tɑ lɩɩnɑ Tɑfiiti tǝyɑɣɑ nyǝ́mɑ wɑɑlɩ. ");
INSERT INTO dop_vpl VALUES ("K112_21","012_12_21","1KI","12","21","21","Wɑɑtʋ wei Lʋpʋwɑm tɑlɑ Yosɑlɛm, ɩlɛnɑ ɩ́ koti Yutɑ nɑ Pɛncɑmɛɛ pǝ yoolɑɑ tɑɑ yoolɑɑ kɛ iyisi nɩɩnʋwɑ nɑ nɩɩnɑɑsɑ (180000) sɩ: Ɩ́ polo nɑ ɩ́ yoonɑ Ɩsɛɣɛlɩ nyǝ́mɑ nɑ pɑ́ mǝŋnɑ-m mɑ kɑwulɑɣɑ. ");
INSERT INTO dop_vpl VALUES ("K112_22","012_12_22","1KI","12","22","22","Amɑ Ɩsɔ heelɑ ɩ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ Semɑyɑ sɩ: Polo ń heeli ");
INSERT INTO dop_vpl VALUES ("K112_23","012_12_23","1KI","12","23","23","Lʋpʋwɑm nɑ Yutɑ nɑ Pɛncɑmɛɛ pǝ yǝlɑɑ sɩ: ");
INSERT INTO dop_vpl VALUES ("K112_24","012_12_24","1KI","12","24","24","Tɑcɑɑ yɔɣɔtɑɑ sɩ: Ɩ́ tɑɑ polo Ɩsɛɣɛlɩ nyǝ́mɑ yoonɑʋ. Mpi tɔ, pɑ kɛ́ mǝ tɛɛtʋnɑɑ kɛ́. Mɑ́ yelinɑ sɩ pǝ́ lɑ ɩsɩɩ pǝ lɑpʋ tɔ. Pɑɑ wei ɩ́ mǝlɩ ɩ tɛ. Pɑ nɩɩ Ɩsɔ Tɔm ntɩ, ɩlɛnɑ pɑ́ hɛɛ. ");
INSERT INTO dop_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Ḿpʋ́ɣʋ́ Solopʋwɑm ŋmɑ́ koloosi nɑ ɩ́ cɔɔnɑ Ɩfǝlɑyim pulɑsɩ tɑɑ ɩcɑtɛ Sikɛm nɑ ɩ́ cɑɣɑ. Pǝlɛ pǝ wɑɑlɩ kɛ́ ɩ kʋlɑ Sikɛm nɑ ɩ́ ŋmɑ́ koloosi nɑ ɩ́ cɔɔnɑ Penuwɛlɩ ɩcɑtɛ. ");
INSERT INTO dop_vpl VALUES ("K112_26","012_12_26","1KI","12","26","27","Ḿpʋ́ɣʋ́ Solopʋwɑm mɑɣɑsɑ ɩ tɑɑ sɩ: Ye Yosɑlɛm kɛ yǝlɑɑ tǝnɑ kɑ́ puki nɑ pɑ́ lɑkɩ kɔtɑsɩ kɛ Tɑcɑɑ tǝsɛɛlɛ tɑɑ, pǝ kɔŋ nɑ mɑ kɑwulɑɣɑ yǝlɑɑ luuŋ sʋʋ pɑ cɑɑ kʋpǝŋ Yutɑ wulɑʋ Lʋpʋwɑm. Ɩlɛnɑ pɑ kʋ-m nɑ pɑ́ tǝŋɩ-ɩ. ");
INSERT INTO dop_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Ḿpʋ́ɣʋ́ ɩ yelɑɑ nɑ pɑ́ lupi-ɩ wʋlɑ nɑwee lɛɛsǝŋ nɑɑlɛ, nɑ ɩ́ hʋlɩ ɩ yǝlɑɑ sɩ: Hɑtoo ɩ́ poluɣu Yosɑlɛm kɛ Ɩsɔ sɛɛʋ tɔ pǝ tɑɑŋɑɑ tǝcɑm. Ɩlɛ ɩɩ nɑɑkɩ mǝ Ɩsɔ wei ɩ lǝsɑ-mɛɣɛ Icipiti tɛtʋ tɑɑ tɔɣɔlɔ. ");
INSERT INTO dop_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Ɩlɛnɑ pɑ́ siki lɛɛsʋɣʋ lɛŋkʋ kɛ Petɛɛlɩ, nɑ lɛŋkʋ kɛ Tɑŋ. ");
INSERT INTO dop_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Ɩsǝnɑ Solopʋwɑm tolisɑ yǝlɑɑ nɑ pɑ́ lɑ ɩsɑɣɑtʋ tɔɣɔlɛ. Nɑ yǝlɑɑ tuutuumɑ nɑ́ɑ́ ponɑ lɛɛsʋɣʋ nɑɑlɛ nyǝŋkʋ kɛ Tɑŋ. ");
INSERT INTO dop_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Ɩlɛnɑ Solopʋwɑm yele nɑ pɑ́ ŋmɑ́ tɩɩŋ kutuluŋ, nɑ ɩ́ kpɑ yǝlɑɑ kpɑɩ nyǝ́mɑ mpɑ pɑ tɑ kɛ Lefii nyǝ́mɑ tɔɣɔ kɔtǝlɑɑ. ");
INSERT INTO dop_vpl VALUES ("K112_32","012_12_32","1KI","12","32","32","Nɑ pɑ́ sɩɩ ɑcimɑ kɛ pɑ ɩsɔtʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋ kʋyɛɛŋ nɑɑnʋwɑ nɑ kɑkpɑsɩ wule, ɩsɩɩ ɑcimɑ wenɑ pɑ tɔkɑɣɑ Yutɑ tɔ. Nɑ ɩ mɑɣɑmɑɣɑ ɩ́ lɑ́ kɔtɑsɩ kɛ wʋlɑ nɑwee lɛɛsǝŋ wei ɩ yepɑ nɑ pɑ́ lu tɔ ɩ tɔɔ. Nɑ ɩ́ tʋ́ kɔtǝlɑɑ mpɑ ɩ kpɑwɑ tɔɣɔ tǝkɔtǝlɛnɑɑ. Mpi ɩ lɑpɑ Petɛɛlɩ tɔɣɔlɛ. ");
INSERT INTO dop_vpl VALUES ("K112_33","012_12_33","1KI","12","33","33","Ḿpʋ́ɣʋ́ wɑɑtʋ nɔɣɔlʋ Solopʋwɑm lǝsɑ ɩsɔtʋ pǝlefɛɩ nɑɑnʋwɑ nyǝŋ kʋyɛɛŋ nɑɑnʋwɑ nɑ kɑkpɑsɩ nyǝŋkʋ wule, nɑ ɩ́ lɑ́ Ɩsɛɣɛlɩ yǝlɑɑ kɛ ɑcimɑ kɛ Petɛɛlɩ. Nɑ ɩ́ lɑ́ kɔtɑsɩ kɛ ɩ mɑɣɑmɑɣɑ kɛ ɑcimɑ ɑnɩ ɑ tɔɔ. ");
INSERT INTO dop_vpl VALUES ("K113_1","012_13_1","1KI","13","1","1","Ḿpʋ́ɣʋ́ Ɩsɔ kʋsɑ ɩ kʋyɔɣɔtʋtʋ tɛlǝsʋlʋ nɔɣɔlʋ kɛ Yutɑ tɛtʋ tɑɑ, nɑ ɩ́ tɑlɑ Petɛɛlɩ kɛ wɑɑtʋ wei Solopʋwɑm ɩsǝlɛ sɛɛnɑ kɔtɑsɩ nsi kɔkɔ lusɑ sɩ tǝnɑ tɔɣɔ lɑpʋ tɔ. ");
INSERT INTO dop_vpl VALUES ("K113_2","012_13_2","1KI","13","2","2