﻿USE sofia;
DROP TABLE IF EXISTS sofia.dob_vpl;
CREATE TABLE dob_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dob_vpl WRITE;
INSERT INTO dob_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ꞌEtoladi gete Toꞌetoseyana Yesu gimi tubunao manudi. Yesu tubuna auwauna Debida, ta gimi tubuna Ebelaamo. ");
INSERT INTO dob_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Manuna gete nadigega: Ebelaamo nina natuna Aisake, ta Aisake natuna Yekobe, ta Yekobe natunao Yuda matasinao. ");
INSERT INTO dob_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda nina natunao Pelesi be Dela ta sinadiya Temali, Pelesi natuna Esiloni, ta Esiloni natuna Elama, ");
INSERT INTO dob_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ta Elama natuna Aminadaba, ta Aminadaba natuna Nasoni, ta Nasoni natuna Salimoni, ");
INSERT INTO dob_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ta Salimoni mwanena Leabi ta natudi Boasa, ta Boasa mwanena Ludi, ta Boasa be Ludi natudiya Obedi, ta Obedi natuna Yese. ");
INSERT INTO dob_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese natuna Debida, tauna kini, ta Debida nina Ulaya mwanena ꞌiagina ga ꞌiaina, ta natudiya Solomoni. ");
INSERT INTO dob_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoni natuna Leobouma, ta Leobouma natuna Ebaya, ta Ebaya natuna Esa. ");
INSERT INTO dob_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa natuna Yosepata, ta Yosepata natuna Yolama, ta Yolama natuna Usaya. ");
INSERT INTO dob_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya natuna Yotama, ta Yotama natuna Easi, ta Easi natuna Esekaya. ");
INSERT INTO dob_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaya natuna Manase, ta Manase natuna Amoni, ta Amoni natuna Yosaya. ");
INSERT INTO dob_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya natunao Yekonaya matasinao, ta ꞌidi tutaya me Babiloni simai ga me Yudia sigiyaidi ga siꞌauꞌewedi ꞌidi sena Babiloni ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tuta nina Babiloni ꞌena simiyamiya, Yekonaya natuna Sialitieli, ta Sialitieli natuna Selubabela. ");
INSERT INTO dob_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabela natuna Ebiyuda, ta Ebiyuda natuna Ilayakimi, ta Ilayakimi natuna Esoli. ");
INSERT INTO dob_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esoli natuna Sadoka, ta Sadoka natuna Ekimi, ta Ekimi natuna Eliyuda. ");
INSERT INTO dob_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda natuna Eliyesa, ta Eliyesa natuna Madani, ta Madani natuna Yekobe. ");
INSERT INTO dob_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekobe natuna Yosepa, tauna Meli mwanena, ta Meli natuna Yesu, ta Yesu nina sieesena Toꞌetoseyana. ");
INSERT INTO dob_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yesu tubunao nidi ꞌadi esanao ꞌadi yau potitu. Manuna Ebelaamo ꞌabo ꞌenega tasasawa be Debida ꞌenaya nate ꞌadi yau potini. Ta ꞌenega ꞌeguma Debida ꞌenega tasasawa ga tuta nina me Babiloni me Yudia sitauyedi Babiloni ꞌenaya, nate ꞌadi yau potini. Ta ꞌidi tuta Babiloni ꞌenaya ꞌenega be Yesu ꞌina tuta ꞌenaya ꞌadi yau wate potini. ");
INSERT INTO dob_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Gete nadigega Toꞌetoseyana Yesu ꞌina tubuwa. Yesu sinana Meli sisawa eyaiyena Yosepa ꞌenaya, ta maꞌetamo nigeya simiyamiya luwa ta Meli ꞌiꞌeuwana ta ꞌina ꞌeuwana nina Yaluyaluwa Tabuna ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ꞌEnega Yosepa nina ꞌinuwamwau Meli ꞌina ꞌeuwana manuna. Ta Yosepa tai boboꞌana, ꞌenega geya nuwana be Meli ꞌigie omayamayae, ta nuwanuwa kwaiyega ꞌaene esi ꞌida eꞌidiꞌidiye. ");
INSERT INTO dob_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ta Yosepa ꞌina nuwanuwa maꞌetamo ꞌipaipaisewa, ꞌenega ꞌina tuta ꞌenoya madawalega Yaubada ꞌina anilose ꞌebweu ꞌieonena, ꞌigwae, “Yosepa, ꞌoyo Debida tubuna, geyaꞌabo ꞌunuwanuwa mwau Meli ꞌina ꞌeuwana manuna, nate Yaluyaluwa Tabuna ꞌenega, ꞌenega tuwa tuga ꞌuda ꞌauꞌewa mwaneyo. ");
INSERT INTO dob_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Be maꞌetamo natuna meꞌolotona ꞌienatune, be ꞌana esana ꞌueese Yesu, manuna tauna ꞌina tomotaiyao ꞌidi loegesiyao ꞌediyega ꞌida ꞌetoseyedi.” ");
INSERT INTO dob_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Yage getedi niꞌatu siapwesa manuna lowaenei palopita ꞌebweu Yaubada ꞌina ona ꞌigimisimanena ga Buki Tabu ꞌena ꞌiꞌetoladina, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Gomagweine nuwenuwebolana ꞌida ꞌeuwana be natuna meꞌolotona ꞌienatune, ta ꞌana esana sida eese Imanueli.” (Ta esana nina ꞌana gibui “Yaubada maꞌedai.”) ");
INSERT INTO dob_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ꞌEnega Yosepa ꞌenoꞌenoega ꞌitoolo ga anilose nina ꞌina ona ꞌiematamatanena, ga Meli ꞌiaina, ");
INSERT INTO dob_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ta nigeya bwalana ꞌigitogitoo ga ꞌana laba ꞌienatuna ga Yosepa gwama nina ꞌieesena Yesu. ");
INSERT INTO dob_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tuta nina Yesu ꞌitubuwa Bedileema ꞌenaya, Elodi tauna ꞌiloiloina Yudia solanaya. Ta tuta nina ꞌenaya ꞌaidi tosinasinapuyao sena bomatuyega simai ga me Yelusalema ꞌediya sienaida, ");
INSERT INTO dob_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sigwae, “Mwaꞌo me Yudia ꞌidi kini auwauna nina? ꞌAmwalatonina niꞌatu ꞌitubuwa, manuna ꞌina kwadima ꞌaꞌitenaya sena bomatuyega ꞌisaetuꞌema, ꞌenega ꞌamai sabi bwagobwago ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ꞌIdi ona gete Kini Elodi ꞌinonona ga ꞌiꞌatesaꞌala ta wate me Yelusalema yaudi siꞌatesaꞌala ona gete manuna. ");
INSERT INTO dob_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ꞌEnega Elodi me Yudia ꞌidi totaliyao sinabwadi be loina ꞌana toeꞌitao ꞌibwau egogonedima ga ꞌediya ꞌienaida, ꞌigwae, “Mane ꞌena Toꞌetoseyana nina ꞌitubuwa?” ");
INSERT INTO dob_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ga sigwae, “Bedileema ꞌenaya, nate Yudia solanaya. Nadigega palopita ꞌina simana Buki Tabu solanaya, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bedileema solanega maꞌetamo me Isileli ꞌidi toloina ꞌida apwesama. Gete manuna Bedileema ꞌasa esaesa ta sinabwana Yudia ꞌasanao maiboꞌadi ꞌediyega.’” ");
INSERT INTO dob_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ꞌEnega Elodi tosinasinapuyao nidi ꞌibwau maꞌuledi, ga ꞌenega ꞌienaidedi to tutaya kwadima nina ꞌiapwesaꞌunu. ");
INSERT INTO dob_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ꞌEnega Elodi ꞌidi eꞌisa ꞌinonona ga ꞌiloinedi, ꞌigwae, “Watauya Bedileema ꞌenaya be gwama nina waꞌebesa ꞌaiꞌaili, be ꞌenega ꞌabo walobenaya wailama be waemataluwegu, be ꞌenega ꞌaboꞌagu wate yada tauya be yada bwagobwago ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Gote ꞌenega siapwesa ga sitauya, ta kwadima nina lowa sena bomatu ꞌena siꞌiteꞌitena matadiya ꞌisaeya, tauna simuliyena ga sena nina kwadima ꞌisaemasinaya ꞌena sitauya ga gwama nina silobena ꞌimiyami, ");
INSERT INTO dob_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ta kwadima nina manuna sigwausowala sinabwa wawasae. ");
INSERT INTO dob_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ꞌEnega silugu anuwaya ga gwama sinana Meli maꞌiyana siꞌitedi, ta sibwagobwago gwama nina ꞌenaya. ꞌEnega oboboma nidi simeꞌediya siꞌewedi gace gwama nina ꞌena sisaꞌudi, nate goula be inisenisi be wate mulo. ");
INSERT INTO dob_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ta muliyega madawalega Yaubada ꞌiemataluwedi be ꞌaene geyaꞌabo Elodi ꞌenaya siilaila, ꞌenega sitoolo ga mali ꞌedega sitauya ꞌidi ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tuta muliyega ꞌebweu anilose madawalega Yosepa ꞌenaya ꞌiapwesa ga ꞌiemataluwena, ꞌigwae, “ꞌUtoolo be gwama masinana ꞌuꞌauꞌewadi be wadedena sena Itipita ꞌena be nada wamimi be ꞌana laba yaemataluweyo, ta ꞌenega waila limanama. ꞌImi dena gete ꞌalena, manuna Elodi ꞌiabe gwama nate ꞌiꞌebese be ꞌaene ꞌiloemwawasi.” ");
INSERT INTO dob_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ꞌEnega boiboi nina ꞌenaya Yosepa ꞌitoolo ga gwama masinana ꞌiꞌauꞌewedi ga sitauya Itipita. ");
INSERT INTO dob_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ta ꞌenega Itipita ꞌena simiyami ga ꞌana laba Elodi ꞌimwawasa. ꞌIdi miya sugalagala nina be ꞌaene Yaubada ꞌina ona ꞌida apwesa, tauna ꞌebweu palopita ꞌigimisimanena, ꞌigwae, “Itipita ꞌenega natugu yabwauyenama.” ");
INSERT INTO dob_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ta tuta nina Elodi tosinasinapuyao ꞌiyamwa yogenediya, manuna nigeya siilailama. ꞌIdi kabo manuna ꞌigamwasowala sinabwana, ꞌenega ꞌina loina ꞌisaꞌuna be tolosaiyao ꞌietunedi Bedileema be ꞌasanao ꞌediya, be ꞌaene gogama meꞌolotodi taudi ꞌadi yakwala ꞌeluwa ꞌenega ꞌimwaꞌutama sida loemwawasidi. Gogama nidi gete nadigega ꞌadi loina Elodi ꞌisaꞌuna, manuna tosinasinapuyao ꞌidi ona ꞌenega niꞌatu ꞌisinapuna to tutaya gwama nina ꞌitutubuwa. ");
INSERT INTO dob_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ꞌEnega tuta nina ꞌiapwesa toꞌase palopita Yelemaiya lowa ꞌigimisimanena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Doonaona Lamaꞌa ꞌenega tanonono. ꞌElouya ta mataselu sidoonaonaedi. Letiyeli ma ina susuyao sidedoi, ta ꞌidi dedoi ꞌenega geyaꞌabo sigwaugwausowala, natudiyao ꞌidi mwawasa manuna.” ");
INSERT INTO dob_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ꞌEnega Elodi ꞌina mwawasa mulinaya Yaubada ꞌina anilose ꞌiapwesa Yosepa ꞌena, tuta nina Itipita ꞌena maꞌetamo ꞌimiyami, ta madawalega ꞌieonena, ");
INSERT INTO dob_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ꞌigwae, “Yosepa ꞌutoolo be gwama masinana ꞌuꞌauꞌewadi be waila Isileli ꞌenaya, manuna gwama ꞌana talauwala niꞌatu ꞌimwawasa.” ");
INSERT INTO dob_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ꞌEnega Yosepa ꞌitoolo ga gwama masinana ꞌiꞌauꞌewedi ga siila Isileli. ");
INSERT INTO dob_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ta tuta nina siilama ga Yosepa ale ꞌinonona ꞌaene Elodi natuna Alekeleo ꞌielopaꞌeluna ga ꞌietoloina sena Yudia ꞌenaya, ꞌenega Yosepa ꞌimatauta ga geya nuwana be ꞌitatauya Yudia ꞌenaya, ta madawalega mwalatoi Yaubada ꞌiꞌebwaꞌena ga ꞌisakowasi ga ꞌitauya sena Galili ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ꞌEnega Nasaleta ꞌena ꞌiloꞌasa. Gete ꞌenega palopitao ꞌidi gimisimana ꞌiapwesa, sigwae, “Tauna sida eese goma Nasaleta.” ");
INSERT INTO dob_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tuta gote ꞌenaya Yoni togiebapitaiso ꞌiapwesa sena mitawa daitaya sena Yudia solanaya ga ꞌiloguguya, ꞌigwaegwae, ");
INSERT INTO dob_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“ꞌImi bubuna toꞌumalina ꞌediyega wada nuwaꞌebuni manuna Yaubada ꞌiabe be ꞌedaya ꞌietoloina.” ");
INSERT INTO dob_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Palopita Aisea lowaenei gete Yoni nina manuna ꞌisimana, ꞌigwae, “Tobwau ꞌebweu sena mitawa daitaya ꞌenana sinabwana ꞌenega ꞌida simana apwesa be ꞌida gwae, ‘ꞌInapwana ꞌina eda wada kakali ta wagiepaepalu.’” ");
INSERT INTO dob_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ta Yoni ꞌana ꞌoama yobai kameli unuununa tuga, ta ꞌana gadiwana kameli bwalana, ta ꞌana masulao bilolo be muꞌawa tuga. ");
INSERT INTO dob_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ta Yoni nina sena mitawa daitaya ꞌiloguloguguya ta me Yelusalema be Yudia ꞌana tomiyanao be bwasi Yolidani tupitupinega ꞌana tomiyanao yauyaudi sidelima Yoni ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ga ꞌidi bubuna toꞌumalina sisimanedi, ta ꞌenega ꞌigiebapitaisoedi bwasi Yolidani ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ta Palisiyao be Sadusiyao yaudi wate simai sabi bapitaiso, ga Yoni ꞌiꞌitedi ga ꞌieonedi, ꞌigwae, “Tokabo ꞌomi nadigega mwata! Ta wanuwena ꞌaene ꞌiabe Yaubada ꞌina gamwasowala ꞌenega wadedena, aga? ");
INSERT INTO dob_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ꞌEnega ꞌilobwenemi be ꞌimi nuwaꞌebuni ꞌaiꞌaila wada eꞌitaedi ꞌimi guinuwa boboꞌadi ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ta geyaꞌabo wanuwanuwa laga manuna ꞌaene ꞌomi Ebelaamo tubunao, ꞌenega Yaubada ꞌida ꞌatenuwa ꞌoleꞌoleyemi. Nigeya saꞌi! Ta waꞌita Yaubada sawesawenaya be gulewa getedi ꞌediyega Ebelaamo tubunao ꞌimweluluidi. ");
INSERT INTO dob_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ta ꞌabo ꞌimi bubuna nigeya boboꞌadi ꞌiabe Yaubada ꞌibwaꞌomatami, nadigega kaiwe, ꞌabo nigeya uwana boboꞌana tomota sitala yauledi be ꞌawesabelulu ꞌena siuledi be sigabudi. ");
INSERT INTO dob_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“ꞌEguma wanuwaꞌebuni ꞌaboꞌagu bwasiyega yada giebapitaisoemi, ta saꞌi maꞌetamo ꞌebweu tai muliguyega ꞌimeemai, tauna ꞌisinabwa sinegu, ta nigeya ꞌilobwelobwenegu be manuna ꞌana ꞌaelawa yaꞌaali. Ta tai nina ꞌiabe ꞌimama be Yaluyaluwa Tabuna, nadigega ꞌawesabelulu, ꞌenega ꞌida giebapitaisoemi. ");
INSERT INTO dob_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ta tai gete ꞌina inawega ꞌiabe witi ꞌida sabutudi be uwana sisasagu be muliyega uwana boboꞌadi ꞌiedodo ꞌina anuwa masulaya, ta sumwasumwa nidi ꞌawesabelulu ataya ꞌena ꞌigabudi.” ");
INSERT INTO dob_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tuta gote ꞌenaya Yesu sena Galili ꞌipilisinena ga ꞌimai Yolidani, Yoni ꞌenaya, sabi bapitaiso. ");
INSERT INTO dob_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ꞌEnega Yoni nuwanuwana Yesu maꞌiyana sida saꞌugelasa, ga ꞌigwae, “ꞌIlobwenena be ꞌoyo ꞌugie bapitaisoegu, ta mwaꞌadega ga ꞌenega ꞌumai be ꞌaene ꞌaboꞌagu yada giebapitaisoeyo?” ");
INSERT INTO dob_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ta Yesu Yoni ꞌina ona ꞌieꞌisena, ꞌigwae, “Nigeya. Esi gete nadigega. ꞌOyo ꞌuda giebapitaisoegu. Manuna gete ꞌenega loina maiboꞌadi boboꞌadi tada muliyedi.” ");
INSERT INTO dob_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ꞌEnega Yoni ꞌitagwala ga Yesu ꞌigiebapitaisoena. Ta ꞌenega Yesu bwasiyega ꞌigayoꞌoyaꞌama, ta galewa ꞌiꞌegegena ta Yesu Yaubada Yaluyaluwana ꞌiꞌitena ꞌana ꞌita ꞌatuwa bunebune ꞌimwaꞌutama ga ꞌena ꞌitowa. ");
INSERT INTO dob_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ta saꞌi ꞌebweu ꞌenana galewega ꞌionama ꞌigwae, “Nate natuꞌaiꞌailigu. Tauna manuna yagwausowala sinabwana.” ");
INSERT INTO dob_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Gete ꞌenega Yaubada Yaluyaluwana Yesu ꞌiꞌauꞌewena ga ꞌitauyena sena mitawa daitaya be ꞌenega ꞌana toona Seitani ꞌenega ꞌida loba. ");
INSERT INTO dob_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ga ꞌasiyata poti solanaya nigeya ꞌiꞌeꞌai, ga ꞌenega ꞌibotana sinabwana. ");
INSERT INTO dob_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ta totoona nina ꞌiapwesama ga ꞌigwae, “ꞌEguma ꞌoyo Yaubada natuna, gulewa getedi ꞌuloinedi be sida emasula.” ");
INSERT INTO dob_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ta Yesu ꞌigwae, “Buki Tabu solanaya loina ꞌimiyami ꞌaene, ‘Tomota yawasidi nigeya masula namo ꞌenega, ta esi Yaubada ꞌina onao maiboꞌadi ꞌediyega.’” ");
INSERT INTO dob_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ꞌEnega Seitani Yesu ꞌiꞌauꞌewena ga ꞌitauyena Yelusalema, ga Anuwa Tabu tabwana ꞌaiꞌailaya ꞌituꞌeyena, ");
INSERT INTO dob_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ga ꞌena ꞌieonena, ꞌigwae, “ꞌEguma ꞌoyo Yaubada Natuna, gete ꞌenega ꞌusosobu, ta geyaꞌabo ꞌuesiesilae. Manuna Buki Tabu niꞌatu ꞌisimana, ꞌigwae, ‘Yaubada ꞌina aniloseyao ꞌida loinedi be siꞌitaꞌiꞌisiyo’, be wate ꞌigwae, ‘Nimadiyega sida ꞌaaliyo, be ꞌenega geyaꞌabo ꞌaeyo siesiesilae gulewa ꞌediya.’” ");
INSERT INTO dob_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ga Yesu wate ꞌigwae, “ꞌEbweu wate ona Buki Tabu ꞌena ꞌimiyami, ꞌigwae, ‘Geyaꞌabo ꞌimu ꞌInapwana Yaubada ꞌutootoo.’” ");
INSERT INTO dob_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ta Seitani Yesu ꞌiꞌauꞌewena ꞌoya sinabwana etaninaya ga gote ꞌena ꞌebeloina esaesa baleꞌuya maiboꞌadi Yesu ꞌieꞌitena ");
INSERT INTO dob_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ta wate ꞌitoo limena, ꞌigwae, “Sena gote maiboꞌadi yada ꞌebwaꞌeyo. ꞌEguma ꞌubeꞌu sanamwaꞌuta be ꞌeguya ꞌubwabwago, ꞌenega ꞌebeloina nidi yada ꞌebwaꞌeyo.” ");
INSERT INTO dob_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ꞌEnega Yesu ꞌiꞌenapaꞌalina, ꞌigwae, “Seitani, ꞌupilisinegu! Buki Tabu solanaya loina ꞌimiyami ꞌaene, ‘ꞌImu ꞌInapwana Yaubada namo ꞌena ꞌuda bwagobwago be taunamo ꞌina ona ꞌuda ematamatanedi.’” ");
INSERT INTO dob_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ꞌEnega Seitani Yesu ꞌipilisinena, ga muliyega aniloseyao siapwesa ga silemena. ");
INSERT INTO dob_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ta muliyega Yesu ale ꞌinonona ꞌaene Yoni deliya sisaꞌuna, ꞌenega ꞌiila ga ꞌitauya Galili ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ꞌEnega Nasaleta ꞌipilisinena ga ꞌiloꞌasa Kapaneumi leꞌawinaya, nate susu Sebuloni be Napitalai ꞌidi bwaꞌa. ");
INSERT INTO dob_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yage gete manuna palopita Aisea lowaenei ꞌigimisimana ga Buki Tabu ꞌena ꞌiꞌetoladina, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebuloni be Napitalai ꞌidi ꞌasao nate ola be bwasi Yolidani gamwagamwanidiya, taudi nigeya me Yudia ꞌidi sena, ꞌana esana Galili. ");
INSERT INTO dob_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Taudi guguyoi ꞌina sena ꞌena simiyami, ta esi gete tuga maedana sinabwana niꞌatu siꞌitena. Manuna lowa mwawasa ꞌina sena toꞌumalina ꞌena simiyana, ta gete tuga maedana niꞌatu ꞌediya ꞌisae.” ");
INSERT INTO dob_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tuta gote ꞌenega Yesu ꞌina guguya ꞌieꞌale ga ꞌigwae, “ꞌImi guinuwa toꞌumalidi ꞌediyega wada nuwaꞌebuni, manuna ꞌiabe be Yaubada ꞌietoloina ꞌedaya.” ");
INSERT INTO dob_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ꞌEnega ꞌebweu tuta Yesu ola Galili leꞌawinaya ꞌiwadawadaꞌe ga togomana siteluwa matasina ꞌiꞌitedi ꞌidi gomana siyauyauye, ꞌebweu Saimoni, tauna watece sieesena Pita, ta tasina ꞌana esana Anidulu. ");
INSERT INTO dob_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ꞌEnega ꞌibwauyedi, ga ꞌigwae, “Wamuliyegu be tomota wada ꞌonadi.” ");
INSERT INTO dob_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Gote ꞌena ꞌidi gomana sipilisinena ga Yesu simuliyena. ");
INSERT INTO dob_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ꞌEnega wate ꞌiawadawadaꞌe ga togomana sitetoi wagaya ꞌidi gomana sigibugibubudi ꞌiꞌita lobedi, taudi Yemesa be Yoni be tamadiya, tauna ꞌana esana Sebedi. ꞌEnega Yesu Yemesa nina matasina ꞌibwauyedima, ");
INSERT INTO dob_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ta sitoolo ga waga be tamadiya sipilisinena, ta Yesu simuliyena. ");
INSERT INTO dob_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu Galili maiboꞌana ꞌiasakowasiyena, ta ꞌidi anuwa tapwalolo ꞌediya ꞌiloguguya, ta tetela boboꞌana Yaubada ꞌina loina manuna ꞌisimasimane, ta wate tomota ꞌadi leꞌoasao ꞌediyega ꞌigieboboꞌanedi maiboꞌadi. ");
INSERT INTO dob_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ꞌEnega Yesu tetelina ꞌiꞌelelewana Silia ꞌasanao maiboꞌadi ꞌediya, ꞌenega toleꞌoasao yaudi simeꞌemeꞌedi ꞌenaya, taudi sileꞌoasa sinabwana ta oodi siꞌeloꞌelouya, be taudi yaluyaluwa biꞌi sigie kabaleyedi be taudi ꞌadi leꞌoasa lobwebwai, be wate tokweno, ga Yesu ꞌigieboboꞌanedi maiboꞌadi. ");
INSERT INTO dob_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Gete manuna boda sinabwana Yesu simuliyena. Galiliyega be Dekapoliyega be Yelusalemega be Yudiaega be wate Yolidani mali esenega. ");
INSERT INTO dob_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu pwalu sinabwana ꞌiꞌitedi, ꞌenega ꞌipilisinedi ga ꞌituꞌe ꞌoyaya ga gote ꞌena ꞌimiyatowa, ta ꞌina tononoyao wate situꞌema, ");
INSERT INTO dob_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ꞌenega Yesu ꞌieꞌale ga ꞌieꞌita ꞌediya, ꞌigwaegwae: ");
INSERT INTO dob_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ꞌOmi ma imi nuwamwaꞌuta wagwausowala, manuna Yaubada nimanaya wamiyami. ");
INSERT INTO dob_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ꞌOmi todedoi wate wada gwausowala, manuna Yaubada ꞌida giegwausowalimi. ");
INSERT INTO dob_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ꞌOmi ꞌimi bubuna nuwana wada gwausowala manuna maꞌetamo Yaubada baleꞌu maiboꞌana ꞌiꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ta ꞌabo ꞌomi bubuna boboꞌana nuwanuwami sinabwana, wada gwausowala, manuna bubuna boboꞌana ꞌatemiya ꞌida sinabwa. ");
INSERT INTO dob_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ta ꞌomi toꞌatenuwa ꞌoleꞌole wada gwausowala, manuna Yaubada wate ꞌida ꞌatenuwa ꞌoleꞌoleyemi. ");
INSERT INTO dob_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ꞌOmi toꞌateꞌesasa wada gwausowala, manuna maꞌetamo Yaubada waꞌita. ");
INSERT INTO dob_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ꞌOmi togienuwa siwalowao wada gwausowala, manuna Yaubada ꞌida ꞌawanatunemi. ");
INSERT INTO dob_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ꞌEguma ꞌomi ꞌimi guinuwa boboꞌana manudi tomota sietalauwalemi, wada gwausowala manuna Yaubada nimanaya wamiyami. ");
INSERT INTO dob_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ta ꞌeguma manugu tomota siloꞌaegilemi be sietalauwalemi be ꞌidi kaboega siꞌawaꞌawa toꞌumaliyemi, wada gwausowala tuga. ");
INSERT INTO dob_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Onaꞌaiꞌaila ꞌilobwenemi be wada gwausowala sinabwana, manuna maꞌetamo ꞌami pali boboꞌana galewaya wada loba. Ta ꞌomi nadigega Yaubada ꞌina palopitao lowaenei. Manuna taudi wate ꞌidi miyamwau silobena tomota ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ꞌOmi nadigega ola me baleꞌu manudi. Ta wanuwaꞌiꞌisi ꞌeguma ola ꞌina waiwai ꞌigugumwala nigeya sawesawenaya be ꞌiboboꞌana limana, ꞌenega taguitoyasei be tasiwayaule ꞌeda ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","15","Ta wate ꞌomi ꞌatuwa mayale me baleꞌu manudi. ꞌEguma mayale taloeꞌabiya geyaꞌabo ꞌule ꞌenega taꞌauꞌaukabobo, ta esi ꞌebesaꞌu etaninaya tasaꞌu be anuwa maiboꞌana ꞌida maedana. Wate nadigega ꞌeguma ꞌoya debanaya taloꞌasa, nigeya kapekapeyana be ꞌasa nina takwaiye. ");
INSERT INTO dob_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ꞌOmi wate nadigega, ꞌilobwenemi be ꞌimi maedana wada giesae tomota ꞌediya, be ꞌenega ꞌimi guinuwa boboꞌana sida ꞌita, ta Tamami galewaya sida tupui. ");
INSERT INTO dob_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Geyaꞌabo wanuwanuwa ꞌaene ꞌaboꞌagu yamai be Mosese ꞌina loinao nai palopitao ꞌidi eꞌitao yaꞌewa yauledi. Ta esi yamai be ꞌaene loina nidi yagieapwesa ꞌaiꞌailidi. ");
INSERT INTO dob_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Onaꞌaiꞌaila loina getedi maꞌetamo sida apwesa ta geyaꞌabo ꞌebweu toꞌase gidala kwakwayona ꞌisawasawala be ꞌana laba galewa ta baleꞌu sisasawala. ");
INSERT INTO dob_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ta ꞌeguma yaita loina nidi ꞌebweuna ꞌediyega gidala kwakwayona ꞌiguitoyase be tomota wate nadigega ꞌieꞌitadi, tauna Yaubada ꞌina ꞌebeloina solanaya toloꞌubuna ꞌaiꞌaila, ta esi ꞌeguma loina nidi ꞌuematamatanedi be ꞌueꞌitaedi, ꞌamu esana ꞌida sinabwa Yaubada ꞌina ꞌebeloina solanaya. ");
INSERT INTO dob_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Wate yaeonami ꞌaene ꞌilobwenemi be ꞌimi bubuna taudi Palisiyao be loina ꞌana toeꞌitao ꞌidi bubuna ꞌida boboꞌana sinedi. Ta ꞌeguma nigeya, geyaꞌabo Yaubada ꞌina ꞌebeloina ꞌena walugulugu. ");
INSERT INTO dob_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Gimiloina tubudao ꞌediya wamwalamwalatoni, ꞌigwae: “Geyaꞌabo loemwawasa, be ꞌeguma yaita ꞌiloemwawasa loina ꞌida loba.” ");
INSERT INTO dob_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ta ꞌaboꞌagu yaloinemi ꞌabo yaita tasina ꞌigamwasowale, loina ꞌida loba. Ta ꞌeguma ꞌiꞌawa toꞌumaliye, loina ꞌida loba toloinao ꞌediyega. Ta wate ꞌeguma ꞌiꞌawa uwauwae, maꞌetamo ꞌilulugu ꞌasagabugabu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ꞌEnega ꞌeguma ꞌimu oboboma ꞌumeꞌemeꞌei be ꞌaene ꞌuda taliya Yaubada ꞌena ta ꞌabo bada ꞌunuwena ꞌaene ꞌebweu tasiyo ma ina nuwamwau ꞌoyo ꞌimu bubuna manuna, ");
INSERT INTO dob_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ꞌilobweneyo be ꞌimu oboboma ꞌusaꞌu ꞌebe taliya selabenaya be ꞌuila tasiyo ꞌenaya, be ꞌutoo be maꞌiyayo waegosigosiyana limana, ta muliyega ꞌuilama be ꞌimu oboboma nina Yaubada ꞌenaya ꞌutaliyae. ");
INSERT INTO dob_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ta ꞌeguma ꞌebweu tai ꞌieꞌewayo be ꞌitauyeyo sabi etalaeyo, ꞌilobweneyo be nugana loegesi nina ꞌugiepaepalu maniniye maꞌiyayo. Ta ꞌeguma nigeya, ꞌamu toeꞌewa nina ꞌida tauyeyo toloina ꞌenaya be ꞌamu loina ꞌuloba, nate sisaꞌuyo deliya, ");
INSERT INTO dob_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ta geyaꞌabo saꞌi ꞌuapweapwesa be ꞌana laba ꞌimu lowaga maiboꞌana ꞌuyotula egumwalidi! ");
INSERT INTO dob_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Gimiloina niꞌatu wamwalamwalatoni, ꞌigwae, “Geyaꞌabo loelata.” ");
INSERT INTO dob_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ta ꞌaboꞌagu yaloinemi ꞌaene ꞌeguma to tai waine ꞌena ꞌiyalakwaiya, tauna ꞌatenaya niꞌatu ꞌiloegesi. ");
INSERT INTO dob_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ꞌEnega ꞌeguma mataꞌataiyo ꞌina duneyega ꞌigiebeꞌuyeyo, ꞌilobwenena be ꞌuiwa yaule. ꞌElouya nigeya sinabwana ꞌeguma welawelaꞌayo ꞌebweuna namo ꞌuloseye, ta esi ꞌelouya sinabwana ꞌeguma matayo manuna Yaubada ooyo maiboꞌana ꞌiula mwaꞌute ꞌasagabugabu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nadigega wate ꞌeguma nimaꞌataiyo ꞌina guinuwega ꞌigiebeꞌuyeyo, ꞌilobwenena be ꞌuꞌupwa yaule. ꞌElouya nigeya sinabwana ꞌeguma welawelaꞌayo ꞌebweuna namo ꞌuloseye, ta esi ꞌelouya sinabwana ꞌeguma nimayo manuna Yaubada ooyo maiboꞌana ꞌiula mwaꞌute ꞌasagabugabu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Gimiloina wate ꞌigwae, “ꞌEguma tai ꞌebweu nuwanuwana be mwanena ꞌisaꞌilei, ꞌina leta tai nina ꞌida ꞌetoladi be mwanenana ꞌiꞌebwaꞌe ta ꞌenega ꞌisasaꞌila.” ");
INSERT INTO dob_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ta ꞌaboꞌagu yaloinemi ꞌaene, “ꞌEguma tai mwanena nigeya ꞌiloeloegesi, ta tai tuga ꞌisasaꞌila be ꞌiaibala mali waine ꞌena, tai nina gimimwanena ꞌigieloelatena ꞌabo waine nina ꞌiaibala mali tai ꞌenaya, ta gete tai nina ꞌeguma ꞌiai waine saꞌisaꞌilina ꞌenaya, tai nina wate toloelata. ");
INSERT INTO dob_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Wate gimiloina wamwalamwalatoni ꞌigwae, “ꞌEguma wasawa tamatamana, geyaꞌabo ꞌimi ona nidi waleꞌoaleꞌoadi, ta esi Yaubada manuna waguinuwedi.” ");
INSERT INTO dob_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ta ꞌaboꞌagu ꞌimi sawatamatamana maiboꞌadi yaꞌetobodedi. ꞌEnega geyaꞌabo galewa manuna wasawasawa tamatamana, manuna Yaubada ꞌina ꞌebemiya. ");
INSERT INTO dob_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Wate geyaꞌabo baleꞌu manuna wasawasawa tamatamana, manuna ꞌaena ꞌana ꞌebesaꞌu. Wate geyaꞌabo Yelusalema manuna wasawasawa tamatamana, manuna toloina sinabwana ꞌina ꞌasa. ");
INSERT INTO dob_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Wate geyaꞌabo debayo manuna ꞌusawasawa tamatamana, manuna nigeya sawesawemuya be ꞌuyaꞌuyayo ꞌebweuna ꞌuloine be ꞌiwakeke nai ꞌigai, aga? ");
INSERT INTO dob_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ta esi ꞌeguma ona ꞌaiꞌaila, ꞌugwae, “Tamo”, ta ꞌeguma nigeya ona ꞌaiꞌaila, ꞌugwae, “Nigeya.” Manuna ꞌeguma ona yauna, nate Seitani ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Gimiloina niꞌatu wamwalamwalatoni, ꞌigwae, “Mata ꞌebweu ꞌana eꞌisa mata ꞌebweuna, ta sala ꞌana eꞌisa wate sala ꞌebweuna.” ");
INSERT INTO dob_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ta ꞌaboꞌagu yaloinemi ꞌaene geyaꞌabo eꞌisa, ta esi ꞌeguma yaita ꞌaseꞌase ꞌataiyo ꞌisapi, geyaꞌabo nimana ꞌueꞌisaile, ta esi gegeumiyo wate ꞌutagwale be ꞌisapi. ");
INSERT INTO dob_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ta wate ꞌeguma yaita etala ꞌenega ꞌamu ꞌoama ꞌiꞌewa, ꞌimu sita wate ꞌuꞌebwaꞌe. ");
INSERT INTO dob_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wate ꞌeguma yaita ꞌiloineyo be ꞌina gwegwe ꞌuꞌaali ꞌebweu ꞌasa ꞌenega be ꞌebweu ꞌasa ꞌenaya, ꞌilobweneyo be ꞌuda pasima be ꞌasa ꞌeluwena wate ꞌena ꞌuda tauye. ");
INSERT INTO dob_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ta wate ꞌabo yaita ꞌemuya ꞌisisida ꞌebweu yage manuna, yage nina ꞌuda ꞌebwaꞌe, ta geyaꞌabo ꞌimu gwegwe ꞌuegaegagale. ");
INSERT INTO dob_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Gimiloina niꞌatu wamwalamwalatoni ꞌigwae: “Gosemiyao waobobomedi, ta esi ꞌami saiyao waetalauwaledi.” ");
INSERT INTO dob_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ta ꞌaboꞌagu yaloinemi ꞌami talauwalao waobobomedi, be taudi sigie ꞌelouyaemi manudi wasisida be Yaubada ꞌida lemedi. ");
INSERT INTO dob_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Gete ꞌenega tamada galewaya ꞌida ꞌawanatunemi, manuna tauna oboboma ꞌalena, be tauna ꞌina sinala ꞌisaesae totoꞌumalidi be wate toboboꞌadi ꞌediya, ta wate ꞌina ꞌusana ꞌitagwatagwale topalupaludi be wate taudi nigeya topalupaludi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ta ꞌeguma gosemiyao dimo waobobomedi, nigeya sawesawenaya be pali Yaubada ꞌenega waloba, manuna totoꞌumalidi, nadigega takisi ꞌana toꞌewao, ꞌidi oboboma nadigega ꞌomi ꞌimi oboboma, gosediyao dimo siobobomedi. ");
INSERT INTO dob_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Wate ꞌeguma tasimiyao dimo waegosigosiyanedi nigeya ꞌimi bubuna mali tomota ꞌidi bubuna ꞌida boboꞌana sinedi, manuna taudi nigeya me Yudia gosediyao dimo siegosigosiyanedi, ꞌenega taudi be ꞌomi tuga ꞌimi bubuna leleleya. ");
INSERT INTO dob_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ta ꞌomi ꞌilobwenemi be adelimi boboꞌana maiboꞌana, nadigega Tamami galewaya. ");
INSERT INTO dob_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesu wate ꞌigwae: ꞌAbo tuta nina nuwanuwami be waꞌebwayadaita taudi gomagomabesodi ꞌediya, geyaꞌabo tomota matadiya waguiguinuwe. ꞌEguma nadigega waguiguinuwaꞌesa, geyaꞌabo tupu nai eꞌisa walobaloba Tamami galewaya ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ꞌEnega tuta nina waꞌebwayadaita gomagomabesodi ꞌediya, geyaꞌabo yoguli wamuꞌemuꞌe, nadigega tokaboyao taudi anuwa tapwalolo nai ꞌasa ꞌediya ꞌidi ꞌebwayadaita mulinaya yoguli simuꞌedi be ꞌaene tomota sida tupudi. Onaꞌaiꞌaila ꞌadi eꞌisa tuta gete namo ꞌenaya silobaloba, ta esi tuta ꞌimeemai geyaꞌabo eꞌisa silobaloba. ");
INSERT INTO dob_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ta ꞌomi saꞌi tuta nina waꞌebwaꞌebwaya daita wada ꞌebwaya kwaiya, ");
INSERT INTO dob_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","be ꞌenega geyaꞌabo tomota siꞌitaꞌita, ta Tamami namo ꞌimi ꞌebwayadaita kwaiya ꞌiꞌita be muliyega eꞌisa boboꞌana ꞌiꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ꞌImi sidasida wate nadigega, ꞌeguma wasisida Yaubada ꞌenaya geyaꞌabo tokabokabo nadigega wasidasida, manuna taudi nuwanuwadi be tomota matadiya tapwalolo solanaya nai ꞌasa ꞌediya sitoolo be sisidasida. Onaꞌaiꞌaila ꞌadi tupu tuta gete namo silobaloba, ta tuta ꞌimeemai nigeya. ");
INSERT INTO dob_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ta ꞌoyo ꞌeguma ꞌusisida, ꞌulugu nugana ꞌimu anuwa solanaya be ꞌawa ꞌugibode ta ꞌenega ꞌusidasida kwaiya Tamayo ꞌenaya, be taunamo ꞌiꞌitayo be muliyega eꞌisa boboꞌana ꞌida ꞌebwaꞌeyo. ");
INSERT INTO dob_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ta wate ꞌimi sidasida ꞌediyega geyaꞌabo waonaona limalimana nadigega taudi tomiya guguyoi siꞌobaꞌoba. Taudi ꞌidi emisa ꞌaene ona yauna ꞌediyega eꞌisa boboꞌana sida loba. ");
INSERT INTO dob_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Geyaꞌabo ꞌomi taudi nadigega, manuna ꞌomi Tamami ꞌimiyami, ta tauna ꞌami mwauyao ꞌigimi mwalatonidi ta muliyega manudi wasidasida. ");
INSERT INTO dob_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ꞌEnega tuta sidasida ꞌediya gete nadigega wada sidasida: “Tamama galewaya ꞌamu esana ꞌaꞌamayabei, ta ꞌasideyo be ꞌoyo ꞌuda loinema, ");
INSERT INTO dob_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","be ꞌenega ꞌimu nuwena ꞌada guinuwe nadigega taudi me galewa siguiguinuwaꞌesa. ");
INSERT INTO dob_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ꞌAma masula ꞌasiyata ꞌebweuna ꞌebweuna ꞌenaya ꞌuda ꞌebwaꞌema. ");
INSERT INTO dob_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ta ꞌima bubuna toꞌumalina ꞌuda nuwataudi, nadigega ꞌaboꞌama wate gosemao ꞌidi bubuna toꞌumalina ꞌemaya ꞌanuwataudi. ");
INSERT INTO dob_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ta geyaꞌabo ꞌutootooma, ta esi tauna totoꞌumalina nina ꞌenega ꞌuda ꞌetoseyema.” ");
INSERT INTO dob_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ꞌEguma ꞌomi gosemiyao ꞌidi loegesiyao ꞌemiya wanuwataudi, Tamami galewaya wate ꞌimi loegesiyao ꞌinuwataudi. ");
INSERT INTO dob_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ta esi ꞌeguma gosemiyao ꞌidi loegesiyao ꞌemiya geyaꞌabo wanuwanuwataudi, Tamami wate ꞌomi ꞌimi loegesiyao geyaꞌabo ꞌinuwanuwataudi. ");
INSERT INTO dob_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wate ꞌabo tuta nina ꞌena tapwalolo manuna ꞌeꞌai ꞌenega waedidigula, geyaꞌabo maninimi watuetue goegowa ꞌatuwa tonuwamwau. Gete tokabo ꞌidi guinuwa nadigega, manuna taudi ꞌadi ꞌita sigie toꞌumaliyedi be ꞌaene ꞌidi edidigula tomota sida mwalatoni. Onaꞌaiꞌaila ꞌadi tupu tuta gete namo silobaloba, ta maꞌetamo nigeya. ");
INSERT INTO dob_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ta ꞌomi tuta nina ꞌeꞌai ꞌenega waedidigula tapwalolo manuna, waꞌatu maninisa be wasinate, ");
INSERT INTO dob_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ꞌenega tomota ꞌimi edidigula geyaꞌabo simwalamwalatoni, ta Tamami namo toꞌase ꞌatemiya ꞌimiyami ꞌimwalamwalatoni, be ꞌana eꞌisa boboꞌana ꞌiꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Geyaꞌabo ꞌimi esaesa baleꞌuya waegoegogonedi, manuna manumanuwa be mwaulu esaesa baleꞌuya sigie toꞌumaliyedi ta wate toꞌipwala silugulugu ꞌimi anuwa ꞌediya sabi ꞌipwalidi, ");
INSERT INTO dob_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ta esi ꞌilobwenemi be ꞌimi esaesa galewaya manuna waetapewa. Manuna galewaya nigeya wate manumanuwa nai mwaulu be ꞌida gwegwe sigie toꞌumaliyedi ta wate nigeya toꞌipwala. ");
INSERT INTO dob_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ta to sena ꞌenaya ꞌimi esaesa ꞌimiyami, nate sena nina ꞌena ꞌimi nuwanuwa sida pili. ");
INSERT INTO dob_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Matada ꞌatuwa ooda ꞌana mayale. ꞌEnega ꞌeguma matada ꞌesasedi ooda maiboꞌana maemaedanina, ");
INSERT INTO dob_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ta ꞌabo matada sitoꞌumali ooda wate maiboꞌana siguguyoi, ta ꞌabo mayale nina ꞌedaya ꞌikweu, ꞌetamo guguyoi ꞌubwaꞌubwa ꞌiꞌali sakowasiyeda. ");
INSERT INTO dob_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Toguinuwa nigeya sawesawenaya be ꞌietopaisewa ꞌenaꞌiyao ꞌeluwa ꞌediya, ta ꞌebweuna ꞌida guitoyasei ta esi ꞌebweuna namo manuna ꞌida paisewa, be ꞌenega ꞌebweuna ꞌiꞌawaboboꞌane ta ꞌebweuna ꞌiꞌawatoꞌumaliye. ꞌEnega nigeya sawesawenaya be Yaubada ꞌina guinuwa be esaesa baleꞌu tagiluwedi. ");
INSERT INTO dob_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ꞌEnega yaeonami ꞌaene geyaꞌabo ꞌimi miya baleꞌu manuna wanuwanuwa sinabwana, ꞌami ꞌeꞌai be ꞌami bwasi be ꞌami ꞌoama manudi. Manuna yawasida yage sinabwana ꞌedaya, ta gwegwe nidi bwala manudi nigeya yage sinabwana. ");
INSERT INTO dob_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gete ꞌebweu ꞌebeꞌita yaꞌebwaꞌemi manuwao ꞌediya, tuta yauna nigeya sida dauna, nai sida sesoi, ta wate nigeya ꞌidi anuwa masulamo. Manuwao nidi yage gidalidi ta tuwa tuga Tamadai galewaya tuta yauna ꞌadi masula ꞌiꞌebwaꞌebwaꞌedi. Ta esi wada nuwaꞌiꞌisi ꞌaene ꞌomi sinabwami Yaubada ꞌenaya, ꞌenega sawesawenaya be ꞌieꞌenimi. ");
INSERT INTO dob_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ta ꞌeisa ꞌemiyega ꞌina nuwenuwega ꞌina tuta baleꞌuya ꞌigieduduli? Nigeya, aga? ");
INSERT INTO dob_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ꞌEnega toꞌase manuna wanuwanuwa sinabwana ꞌami ꞌoama manudi? Ta ꞌebweuna wate gete ꞌebeꞌita, seninao ꞌidi tabwa ꞌasaya manuna wada nuwaedaedadami. Tuta yauna nigeya sida paisewa, ta wate nigeya ꞌadi ꞌoama sida guinuwedi. ");
INSERT INTO dob_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ta onaꞌaiꞌaila, Solomoni ꞌana ꞌoamao be ꞌana iyaiyalao ꞌadi ꞌita boboꞌadi, ta senina ꞌadi ꞌita esi boboꞌana wawasae. ");
INSERT INTO dob_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ꞌEnega wanuwanuwa Yaubada ꞌina ꞌitaꞌiꞌita ꞌemiya manuna. Tauna pwatula ꞌieiyalidi senina boboꞌadi ꞌediyega; batuwa sisenina ta gibwaꞌi siꞌoapelu be sigabudi, ta ꞌomi pwatula waboboꞌana sinedi, ꞌenega onaꞌaiꞌaila, ꞌami ꞌoamao ꞌida ꞌebwaꞌemi. ꞌEnega geyaꞌabo ꞌimi emisa Yaubada ꞌena ꞌineeneta. ");
INSERT INTO dob_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ꞌEnega geyaꞌabo wanuwanuwa sinabwana be ꞌaene wagwaegwae, “Toꞌase ꞌada ꞌani?” nai “Toꞌase ꞌada numa?” nai “Toꞌase ꞌada ꞌote?” ");
INSERT INTO dob_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ona getedi nadigega taudi ꞌetamo guguyoi ꞌenaya simiyami ꞌidi ona. Ta toꞌase ꞌimi nuwanuwa Tamami galewaya niꞌatu ꞌisinapudi, nadigega ꞌami masula be ꞌami bwasi be wate ꞌami ꞌoama, be ꞌiꞌebwaꞌemi tuga. ");
INSERT INTO dob_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ꞌEnega ꞌilobwenemi be nugana Yaubada ꞌina loina ta ꞌina ꞌeda palupaluna wada ꞌebese be wada muliye, be ꞌenega ꞌami masula ta ꞌami ꞌoama wate ꞌiꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ꞌEnega geyaꞌabo wanuwanuwa sinabwana gibwaꞌi manuna. Nate namo batuwa namo manuna wada nuwanuwa. ꞌEnega ꞌasiyata simeema ꞌadi mwau geyaꞌabo ꞌasiyata batuwa ꞌana mwau maꞌiyana taloeloepopoe, ta esi ꞌasiyata ꞌebweuna ꞌebweuna taudi saꞌi ꞌadi mwau manudi tada nuwanuwa ꞌadi ꞌasiyata nidi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Geyaꞌabo tomota waꞌawaꞌawa toꞌumaliyedi ꞌabona nai Yaubada wate ꞌiꞌawa toꞌumaliyemi. ");
INSERT INTO dob_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Manuna to yage ꞌediyega tomota waꞌawa toꞌumaliyedi ꞌiabe ꞌediyega Yaubada ꞌiꞌawa toꞌumaliyemi, ta wate mwaꞌadega wabubunaꞌesa tomota ꞌediya Yaubada nadigega ꞌida bubuna ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ta nigeya ꞌilobwelobweneyo be tasiyo manuna ꞌuona ꞌaene matanaya kaiwe senasenamina ꞌimiyami, manuna ꞌoyo wate matamuya kegabugabu ꞌimiyami, ta nigeya ꞌuꞌitaꞌita. ");
INSERT INTO dob_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ꞌEnega geyaꞌabo tasiyo ꞌueonai ꞌaene kaiwe senasenamina matanega ꞌuda ꞌewayaule, manuna ꞌoyo wate matamuya kegabugabu ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Onaꞌaiꞌaila ꞌoyo ꞌebweu tokabo, aga? Ta esi kegabugabu matamuyega ꞌuda gimiꞌewa yaule, be ꞌenega ꞌudune ꞌaiꞌaila ta muliyega tasimuna matanega kaiwe senasenamina ꞌuꞌewayaule. ");
INSERT INTO dob_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Geyaꞌabo Yaubada ꞌina yageyao ꞌuꞌebwaꞌebwaya kedewa ꞌediya, ꞌabona nai siguitoyasedi ta sigoꞌiyo. Nigeya sawesawenaya be wate ꞌimi bagi bawe waꞌebwaꞌebwaꞌedi ꞌabona nai siabaibailidi. ");
INSERT INTO dob_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Wada sidasida, be Yaubada ꞌida ꞌebwaꞌemi. Wate wada ꞌebesa be ꞌenega wada loba. Ta wada ꞌaukeke be ꞌenega ꞌali ꞌida gigege. ");
INSERT INTO dob_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Onaꞌaiꞌaila ꞌeguma tasisida, Yaubada ꞌiꞌebwaya ꞌedaya, be ꞌeguma taꞌebesa maꞌetamo taloloba, ta wate ꞌeguma taꞌaukeke ꞌenega ꞌali ꞌida gigege manuda. ");
INSERT INTO dob_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ta mwaꞌadega ꞌomi gogama tamadiyao, ꞌeguma natumiyao masula manuna sisisida, gulewa waꞌebwaꞌedi? ");
INSERT INTO dob_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nai ꞌabo iyana manuna sisisida mwata waꞌebwaꞌedi? Nigeya saꞌi! ");
INSERT INTO dob_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Onaꞌaiꞌaila ꞌomi totoꞌumalimi, ta ꞌimi ꞌebwaya natumiyao ꞌediya niꞌatu wamwalamwalatoni, ꞌaene yage boboꞌadimo waꞌebwaꞌebwaꞌedi. Nadigega wate Tamami galewaya, ꞌabo wasisida ꞌenaya, ꞌimwalatonina toꞌase boboꞌana ꞌilobwenemi be ꞌida ꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ta ꞌabo toꞌase nuwanuwami be tomota ꞌemiya siguinuwei ꞌomi wate nadigega ꞌediya wada guinuwaꞌesa, manuna getei Mosese be palopitao ꞌidi loina ꞌana bwagila. ");
INSERT INTO dob_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ꞌAwa gidalina ꞌenega walulugu ta geyaꞌabo ꞌawa sinabwana ꞌenega, nate ꞌebe esilae ꞌana ꞌeda. ꞌEda nina sinabwana ga ꞌana tauya kapekapeyana, ta ꞌenega tomota yaudi ꞌena sitautauya. ");
INSERT INTO dob_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ta yawasi boboꞌana ꞌana ꞌeda ꞌana tauya mwauna ta ꞌana ꞌawa gidalina tuga, ꞌenega tomota puꞌepuꞌedimo silugu. ");
INSERT INTO dob_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tosimana kabokabodi ꞌediyega waꞌitaꞌiꞌisimi. Manuna ꞌaidi maꞌetamo ꞌemiya simamai, ꞌadi ꞌita ꞌatuwa sipi panapanaisidi, ta soladiya esiya ꞌatuwa kedewa bosasa. ");
INSERT INTO dob_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ta ꞌidi guinuwao ꞌediyega maꞌetamo wamwalatonidi, manuna kwakwakwala nigeya sawesawenaya be uwana ꞌiesibweya. Buyubuyuwa wate nadigega nigeya sawesawenaya be uwana ꞌiedamaya. ");
INSERT INTO dob_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Manuna kaiwe boboꞌadi uwadi boboꞌana, ta kaiwe toꞌumalidi uwadi wate toꞌumalidi. ");
INSERT INTO dob_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Onaꞌaiꞌaila, kaiwe boboꞌadi nigeya sawesawediya be uwadi toꞌumalina siuwaedi. Kaiwe toꞌumalidi wate nadigega nigeya sawesawediya be uwadi boboꞌana siuwaedi. ");
INSERT INTO dob_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ꞌEnega ꞌabo kaiwe nigeya sida uwa boboꞌana tatala yauledi be tagabudi. ");
INSERT INTO dob_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nadigega wate tosimana kabokabodi ꞌidi guinuwa ꞌediyega sawesawenaya wamwalatonidi. ");
INSERT INTO dob_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yaudi ꞌeguya siꞌawaꞌawa ꞌinapwana ta maꞌetamo geyaꞌabo silugulugu Yaubada ꞌina ꞌebeloina ꞌenaya, nate namo taudi Tamagu galewaya ꞌana toematamatanao. ");
INSERT INTO dob_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tuta ꞌimeemai ꞌenaya tomota yaudi ꞌetamo ꞌeguya sida gwae, “ꞌInapwana, ꞌapaisewa manuyo ta ꞌamu esanega ꞌaloguloguguya ta yaluyaluwa biꞌi tomota ꞌediyega ꞌaula apwesedi, ta wate guinuwa ꞌebe nuwaowanao ꞌaguinuwedi.” ");
INSERT INTO dob_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ꞌEnega ꞌediya yada ona, “Nigeya yamwalamwalatonimi yaisigedi ꞌomi. Waila ta geyaꞌabo waluguluguma, manuna ꞌomi totoꞌumalimi.” ");
INSERT INTO dob_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","ꞌIgu ona getedi ꞌabo yaita ꞌinonodi be ꞌiematamatanedi tauna ꞌatuwa ꞌebweu toꞌabi anuwa sinasinapuna, ꞌina ꞌautui gulewa ꞌena ꞌiꞌabina, ");
INSERT INTO dob_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ga muliyega ꞌusana ꞌimwaꞌuta ga muluwa ꞌidau ta wate yagila sinabwana ꞌitowa ga ꞌina anuwa nina nigeya ꞌibeꞌubeꞌu, manuna ꞌina ꞌautui gulewa ꞌena ꞌiꞌabina. ");
INSERT INTO dob_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ta ꞌabo yaita ꞌigu ona getedi ꞌinonodiya ta geyaꞌabo ꞌiematamatanedi, tauna ꞌatuwa toꞌabi anuwa uwauwana ꞌina anuwa kaukau ꞌena ꞌiꞌabina, ");
INSERT INTO dob_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ꞌenega ꞌusana sinabwana ꞌimwaꞌuta ga muluwa ꞌidau ta wate yagila sinabwana ꞌitowa ga anuwa nina ꞌiebuiyena ta ꞌieligeya toilina. ");
INSERT INTO dob_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tuta nina eꞌita getedi Yesu ꞌilosalonidi ga boda nidi nuwadi ꞌiowana, ");
INSERT INTO dob_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ta sigwae, “Eꞌita gete palupaluna ta waiwaina, ta ꞌida loina ꞌana toeꞌitao ꞌidi eꞌita nenetana.” ");
INSERT INTO dob_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ꞌEnega ꞌoyega ꞌimwaꞌutama ga boda sinabwana simuliyena. ");
INSERT INTO dob_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ta ꞌebweu ꞌediyega ma ꞌana lepelo ꞌimai Yesu ꞌenaya ga ꞌiꞌaetulasa, ta ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌeguma ꞌimu nuwanuwa nadigega, kapekapeyana be ꞌugie boboꞌanegu?” ");
INSERT INTO dob_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ꞌEnega Yesu nimanega tai bwalana ꞌigitoona, ta ꞌigwae, “O, boboꞌana! ꞌUda ꞌesasa.” Ga tai nina ꞌana lepelo ꞌigumwala manini, ga ꞌiꞌesasena. ");
INSERT INTO dob_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ꞌEnega Yesu ꞌieonena, “ꞌUtatauya ta geyaꞌabo ꞌebweu yaita wate ꞌenaya ꞌusimasimanegu, ta esi palupaluna ꞌutatauya totaliya ꞌenaya be ꞌiꞌitayo be ꞌenega ꞌutaliya Yaubada ꞌenaya toꞌase nadigega ꞌada loina Mosese ꞌenega, be ꞌenega tomota simwalatoniyo ꞌaene niꞌatu ꞌuꞌesasemu.” ");
INSERT INTO dob_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ꞌEnega Yesu ꞌimai ꞌasa Kapaneumi ꞌena, ta tolosaiyao taudi me Loma ꞌadi toanugana ꞌebweu ꞌimai ga ꞌisida Yesu ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ꞌigwae, “ꞌInapwana, ꞌigu ꞌaliꞌei ꞌebweu ꞌileꞌoasa ga anuwaya ma ina ꞌelouya sinabwana ꞌiꞌenoꞌeno, ta nigeya sawesawenaya be ꞌiloniu.” ");
INSERT INTO dob_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ꞌEnega Yesu ꞌigwae, “ꞌIabe yawawa be yagieboboꞌane.” ");
INSERT INTO dob_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ta tai nina Yesu ꞌina ona ꞌieꞌisena, ꞌigwae, “ꞌInapwana, nigeya ꞌilobwelobweneyo be ꞌigu anuwaya ꞌululugu, ta esi ꞌuda onamo be ꞌenega ꞌigu ꞌaliꞌei ꞌida boboꞌana. ");
INSERT INTO dob_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Manuna ꞌaboꞌagu loina yamwalamwalatoni, ta ꞌagu toloinao ꞌidi ona ꞌana toematamatana, ta wate ꞌigu tolosaiyao yaloiloinedi, ta ꞌabo ꞌebweu ꞌenaya yagwae, ‘ꞌUtauya,’ ꞌitatauya tuga; ta ꞌabo ꞌebweu wate ꞌena yagwae, ‘ꞌUmai,’ wate ꞌimama; ta ꞌabo ꞌigu topaisewa ꞌebweu yaeona be yagwae, ‘Gete ꞌuguinuwe,’ ꞌida guinuwa tuga.” ");
INSERT INTO dob_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ꞌIna simana gete ꞌenega Yesu ꞌigwausowala sinabwana, ꞌenega ꞌiasakowasi ga boda nidi simulimuliye ꞌieonedi, ꞌigwae, “Onaꞌaiꞌaila, nigeya ꞌebweu yaita yalobaloba me Isileli ꞌemiyega ꞌina emisa tai gete nadigega, ");
INSERT INTO dob_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ta yasimana ꞌemiya ꞌaene yau wawasae maꞌetamo sena yaalata be bomatu ꞌediyega sidelima be Ebelaamo be Aisake be Yekobe maꞌediyao siꞌeꞌai egogona Yaubada ꞌina ꞌebeloina solanaya, ");
INSERT INTO dob_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ta esiya ꞌomi ꞌaene Yaubada natunao ꞌiula apwesemi guguyoi solanaya be nada wadedoi be waesalaꞌiꞌita ꞌelouya ꞌenega.” ");
INSERT INTO dob_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ꞌEnega Yesu tolosaiya ꞌadi toanugana nina ꞌieonena, “Boboꞌana, ꞌuila. ꞌImu ꞌaliꞌei ꞌiabe ꞌiboboꞌana, nadigega ꞌimu emisa.” Tuta gote ꞌenaya toleꞌoasa nina ꞌina waiwai ꞌilobena. ");
INSERT INTO dob_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ꞌEnega Yesu Pita ꞌina anuwaya ꞌilugu, ga Pita lawana ꞌiꞌitena ꞌileꞌoasa, bwalana ꞌiyaiyai, ");
INSERT INTO dob_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ꞌenega ꞌinao ga nimanaya ꞌiꞌabi, ta ꞌina leꞌoasa ꞌisaligogo, ga ꞌitoolo ga ꞌeꞌai ꞌigibubuna Yesu manuna. ");
INSERT INTO dob_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ꞌEnega boiꞌunuya toniꞌasao ꞌaina tomota simeꞌedi, taudi yaluyaluwa biꞌi ꞌediya simiyami, ꞌenega Yesu yaluyaluwa nidi ꞌina onega ꞌiula apwesedi ta wate toleꞌoasao maiboꞌadi ꞌigieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yage getedi niꞌatu siapwesa ga ꞌenega palopita Aisea ꞌina gimisimana ꞌiapwesa, nadigega Buki Tabu ꞌena ꞌisimana, ꞌigwae, “Tauna ꞌida ꞌelouya ta ꞌada leꞌoasao ꞌana toꞌewayaula.” ");
INSERT INTO dob_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tuta gote ꞌenaya Yesu niꞌatu pwalu sinabwana ꞌiꞌitedi simiya sakowasiyena, ꞌenega ꞌina tononoyao ꞌiloinedi be ꞌaene wagega sida abala mali senaya. ");
INSERT INTO dob_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ꞌEnega ꞌebweu loina ꞌana toeꞌita ꞌimai ga Yesu ꞌieonena, ꞌigwae, “Toeꞌita, nuwanuwagu be yamuliyeyo. To sena ꞌena ꞌutautauya ꞌaboꞌagu yada muliyeyo.” ");
INSERT INTO dob_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ta Yesu tai nina ꞌieonena, ꞌigwae, “Kedewa mitawa ma idi gaula, ta wate manuwa ma idi newa, ta ꞌaboꞌagu Tomota Natuna nigeya ꞌigu ꞌebe ꞌenomo.” ");
INSERT INTO dob_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ꞌEnega ꞌebweu wate tomuliya ꞌimai ga Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌuda tagwalegu be nugana yaila be tamagu yayamwa ꞌina mwawasa manuna, be yada saꞌuꞌaliꞌaliye, ta muliyega yamuliyeyo.” ");
INSERT INTO dob_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ta Yesu ꞌigwae, “Tuwa! Nada tamayo, ta esi ꞌumuliyegu, ta taudi tomwawasa ꞌidi tomwawasao sida saꞌu ꞌaliꞌaliyedi.” ");
INSERT INTO dob_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ꞌEnega Yesu ma ina tononoyao sigelu wagaya, ");
INSERT INTO dob_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ga tuta nina siabaabala mali esenaya ta Yesu waga ꞌawaꞌawainaya ꞌiꞌeno mwataya, ta muliyega wediliya sinabwana ꞌitowama ga lisu ꞌisiwasiwa taonama wagaya ga selabenaya be sidadamana. ");
INSERT INTO dob_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ꞌEnega Yesu silowanowanona ga sigwae, “ꞌInapwana, ꞌuꞌetoseyeda ꞌabona nai tadadamana.” ");
INSERT INTO dob_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ta ꞌieonedi, “Toꞌase manuna wamatauta? Mwaꞌadega nigeya ꞌimi emisamo, aga?” ꞌEnega ꞌitoolo ga yagila be lisu ꞌibaꞌedi, ꞌigwae, “Walosaꞌu!”, ga bwagabwaga maiboꞌana ꞌisiwalowa. ");
INSERT INTO dob_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ꞌEnega tomotai nidi sinuwa owana ga sigwae, “To tai sana gete, ga yagila be lisu ꞌenana siematamatanena?” ");
INSERT INTO dob_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ꞌEnega niꞌatu siabala ga silugu me Gadala ꞌidi senaya, ga tai ꞌeluwa yaluyaluwa biꞌi sigie kabaleyaediya, ga ꞌaliꞌali duluina ꞌenega siapwesama. Ta ꞌidi bubuna gadilulu ꞌenega nigeya sawesawenaya be ꞌebweu yaita ꞌidi sena nina ꞌenega ꞌitatauya. ");
INSERT INTO dob_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Siteluwa nidi Yesu siꞌitena ga simagana, sigwae, “Ee! ꞌOyo Yaubada Natuna, toꞌase ꞌutootoo be ꞌaene ꞌuguinuwe ꞌemaya? ꞌAene gete tuga ꞌumai sabi gieꞌelouyaema ta muliyega be bwaꞌomatana?” ");
INSERT INTO dob_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ta selabediya bawe yaudi siduwaduwala, ta ꞌadi toꞌitaꞌiꞌitao siꞌitaꞌiꞌisidi. ");
INSERT INTO dob_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ꞌEnega yaluyaluwa biꞌi nidi Yesu ꞌena sisida, sigwae, “ꞌAbo ꞌuula apwesema, kapekapeyana be bawe nidi gotedi ꞌediya ꞌuda etunema?” ");
INSERT INTO dob_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ꞌEnega ꞌieonedi, “Waapwesa.” Ga tai nidi ꞌeluwa ꞌediyega yaluyaluwa biꞌi nidi silosuya apwesedi ga sitauya manini ga bawe ꞌediya silugu, ga ꞌenega bawe nidi maiboꞌadi sipili bulibuliyasu ga babagega sibeꞌu ta olaya sidamana. ");
INSERT INTO dob_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ꞌEnega bawe ꞌadi toꞌitaꞌiꞌitao nidi ꞌidi matauta manuna sidena ga sitauya ꞌidi ꞌasaya, ga yage nidi siꞌitedi maiboꞌana sisimanedi toniꞌasao ꞌediya, toꞌase nadigega toekabaleya ꞌediya ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ꞌEnega toniꞌasao maiboꞌadi siapwesama Yesu sabi ꞌitana, ga tuta nina silobena sieꞌidiꞌidiyena be ꞌaene ꞌidi sena ꞌida pilisine. ");
INSERT INTO dob_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ꞌEnega Yesu wagaya ꞌigelu ga siabala limana ꞌina ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ꞌEnega ꞌebweu tokweno boda siꞌaalina ꞌina ꞌebeꞌeno ꞌenega ga simeꞌena Yesu ꞌenaya. Boda nidi ꞌidi emisa Yesu ꞌimwalatonina ga tokweno nina ꞌieonena, ꞌigwae, “Natugu, ꞌuda gwausowala, ꞌimu bubuna toꞌumalidi ꞌadi nuwatau niꞌatu ꞌulobedi.” ");
INSERT INTO dob_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ta ꞌaina loina ꞌana toeꞌitao Yesu ꞌina ona sinonona ga taudimo ꞌediya sieonaona, sigwae, “Yesu gete ꞌionaona oopaꞌala Yaubada ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ꞌIdi nuwanuwa Yesu niꞌatu ꞌimwalatonina ga ꞌieonedi, ꞌigwae, “Toꞌase manuna ꞌatemiyega wanuwanuwa toꞌumalina? ");
INSERT INTO dob_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ta toꞌase wanuwena yada onae tai gete ꞌenaya be ꞌaene yada gwae, ‘ꞌImu bubuna toꞌumalina niꞌatu yanuwataudi’, nai yada gwae, ‘ꞌUtoolo be ꞌutatauya’? ");
INSERT INTO dob_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ta wada mwalatoni ꞌaene ꞌaboꞌagu Tomota Natuna ma igu loina baleꞌuya be tomota ꞌidi bubuna toꞌumalina yanuwataudi.” ꞌEnega tokweno nina ꞌieonena, ꞌigwae, “ꞌUtoolo be ꞌimu ꞌebeꞌeno ꞌuꞌaala be ꞌutatauya ꞌimu ꞌasaya.” ");
INSERT INTO dob_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ꞌEnega tokweno nina ꞌitoolo ga ꞌitauya ꞌina ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ta boda nidi guinuwa gete siꞌitena ga ma idi ꞌamayaba Yaubada situpuna, manuna sana tauna Yesu ꞌana Togiewaiwai. ");
INSERT INTO dob_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ꞌEnega Yesu sena gete ꞌipilisinena ga ꞌitauya, ga tai ꞌebweuna ꞌiꞌitena, ꞌana esana Madiu, takisi ꞌana anuwa ꞌebe paisewa solanaya ꞌimiyami, ꞌenega ꞌieonena, ꞌigwae, “Madiu, ꞌumuliyegu.” ꞌEnega Madiu ꞌitoolo ga Yesu ꞌimuliyena. ");
INSERT INTO dob_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Muliyega anuwa ꞌebweu ꞌena Yesu ꞌilugu sabi ꞌeꞌai, ga takisi ꞌana toꞌewao be wate ꞌaidi totoꞌumalidi simai, ga Yesu ma ina tononoyao maꞌediyao simiyatowa. ");
INSERT INTO dob_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ꞌEnega ꞌaidi Palisiyao siꞌitena ga Yesu ꞌina tononoyao ꞌediya sienaida, sigwae, “Toꞌase manuna ꞌimi toeꞌita takisi ꞌana toꞌewao ta wate totoꞌumalidi ꞌaina maꞌenao siꞌeꞌai egogona?” ");
INSERT INTO dob_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ta Yesu ona gete ꞌinonona ga ꞌieonedi, “Taudi boboꞌadi geya nuwadi togileꞌoasa, ta toleꞌoasao esiya nuwanuwadi togileꞌoasa. ");
INSERT INTO dob_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ꞌEnega ꞌilobwenemi be Yaubada ꞌina ona wanuwa sabwaleni Buki Tabu ꞌena ꞌigwae: ‘Nuwanuwagu ꞌatenuwaꞌoleꞌole, ta geya nuwagu taliya.’ Gete yamaiya nigeya topalupaludi manudi, ta esi totoꞌumalidi sabi lemedi.” ");
INSERT INTO dob_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ꞌEnega Yoni ꞌina tononoyao simai ga Yesu sieonena, sigwae, “ꞌAboꞌama ta Palisiyao ꞌima tapwalolo manudi ꞌeꞌai ꞌenega ꞌaedidigula, ta mwaꞌadega ga ꞌenega ꞌoyo ꞌimu tononoyao nigeya siediedidigula?” ");
INSERT INTO dob_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ꞌEnega Yesu onasemalimali ꞌiꞌebwaꞌedi, ꞌigwae, “Mwaꞌadega, kapekapeyana be ai ꞌana toyoꞌoyao sinuwamwau ꞌabo toai meꞌolotona maꞌediya sigwaugwausowala? Nai nigeya aga? Ta wanuwaꞌiꞌisi ꞌaene tuta ꞌimeemai be toai nina ꞌipilisinedi ꞌenega esi sinuwamwau be siedidigula, ta siꞌebotana.” ");
INSERT INTO dob_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ta ꞌebweu wate onasemalimali ꞌieonedi, ꞌigwae, “Nigeya sawesawenaya be kaleko auwauna senasenaminega ꞌoama kadekadelina tabwabwada, ꞌabona nai esabu nina ꞌiesabu toili. ");
INSERT INTO dob_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ta nigeya wate sawesawenaya be bwasi auwauna ta waiwaina tasiwa bwala ꞌebesiwa kadekadelina ꞌenaya. ꞌAbo gete nadigega taguinuwaꞌesei, bwasi ꞌina seseya ꞌenega bwala nina ꞌiesabu be bwasi ꞌitasiwa, ta ꞌenega ꞌebesiwa nina ꞌitoꞌumali. Ta ꞌilobwenena be bwasi auwauna ta waiwaina tasiwa ꞌebesiwa auwauna solanaya, be ꞌenega maiboꞌana boboꞌana.” ");
INSERT INTO dob_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ꞌEtamo Yesu ꞌionaona ta ꞌebweu toloina ꞌimai ga Yesu matanaya ꞌiꞌaetulasa, ta ꞌigwae, “ꞌInapwana, natugu mewainena niꞌa ꞌimwawasa, ta nuwanuwagu ꞌumama be oona ꞌuda gitoo be ꞌida toolo limana.” ");
INSERT INTO dob_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ta Yesu ꞌitoolo ga ma ina tononoyao toloina nina simuliyena, ");
INSERT INTO dob_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ta sitautauya, ga waine ꞌebweu lalana ꞌidaudau yakwala tuwelo ꞌediya mulidiyega ꞌimai ga Yesu ꞌana ꞌoama tupitupina ꞌigitoona, ");
INSERT INTO dob_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","manuna ꞌina nuwanuwa ꞌatenaya ꞌigwae, “ꞌEguma tuga Yesu ꞌana ꞌoama namo yagitoo yada boboꞌana.” ");
INSERT INTO dob_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ta Yesu ꞌisanaila ga waine nina ꞌiꞌitena, ta ꞌigwae, “Kagutoki natugu, ꞌimu emisa ꞌenega niꞌatu ꞌuboboꞌana.” Ta tuta gote ꞌenaya waine nina ꞌiboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ꞌEnega Yesu ꞌitauya ga toloina nina ꞌina anuwaya ꞌiapwesa ga ꞌiꞌitena todedoi sidedoi ta lololi ꞌana tomuꞌeyao lololi simuꞌemuꞌe, ga ꞌenadi ꞌisinabwa wawasae. ");
INSERT INTO dob_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Waapwesa! Gwama gete nigeya ꞌimwawamwawasa ta ꞌiꞌeno mwataya tuga.” Ta siedagiyena. ");
INSERT INTO dob_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ꞌEnega boda nidi siapwesa ga Yesu ꞌilugu ga gwama nina nimanaya ꞌigiyaina ga mayawasina ꞌitoolo. ");
INSERT INTO dob_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Muliyega ale gete ꞌiꞌelelewana sena maiboꞌana ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sena gote ꞌenega Yesu ꞌitautauya ta tomata kebokebo ꞌeluwa simulimuliyei ta sibwaubwau ꞌenadi sinabwana ꞌenega sigwaegwae, “Debida tubuna ye, ꞌuda ꞌatenuwa ꞌoleꞌoleyema!” ");
INSERT INTO dob_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ꞌEnega anuwaya ꞌilugu ga tomata kebokebo nidi simai ꞌenaya ga Yesu ꞌieonedi, “Mwaꞌadega waemisegu ꞌaene sawesaweguya matami yagieꞌesasedi?” Ga taudi sigwae, “ꞌInapwana, sawesawemuya.” ");
INSERT INTO dob_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ꞌEnega matadi ꞌigitoodi ta ꞌieonedi, “ꞌImi emisa ꞌediyega matami sida ꞌesasa”, ");
INSERT INTO dob_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ga matadi siꞌesasena. Ta Yesu loina paꞌalina ꞌiꞌebwaꞌedi, ꞌigwae, “Geyaꞌabo yaita ꞌena wasimasimanegu.” ");
INSERT INTO dob_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ꞌEnega sitauya ga Yesu ꞌina loina sileꞌoena ta ꞌina guinuwa ꞌediya sisimana dadanena sena yauyauna ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ta Yesu ma ina tononoyao niꞌatu sitautauya ta, ꞌebweu tai yaluyaluwa biꞌiyao meyana sigibuninaya siꞌauꞌewenama Yesu ꞌena. ");
INSERT INTO dob_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ta ꞌenega Yesu yaluyaluwa biꞌi ꞌiula apwesena, ga tai nina ꞌiboboꞌana ga ꞌionaona. Ta pwalu ma idi gwausowala Yesu siꞌawa boboꞌanena, ta sigwae, “Nigeya ꞌebweu yaita ꞌina guinuwa gete nadigega tada ꞌitena Isileli solanaya.” ");
INSERT INTO dob_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ta saꞌi Palisiyao silolagata ga sigwae, “Yaluyaluwa biꞌi ꞌidi ꞌinapwana ꞌina waiwaiyega Yesu yaluyaluwa biꞌi ꞌiulaula apwesedi, ta nigeya Yaubada ꞌina waiwaiyega.” ");
INSERT INTO dob_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ꞌEnega Yesu ꞌasa sinabwadi be gidalidi ꞌediya ꞌisakowasi, ta ꞌidi anuwa tapwaloloyao ꞌediya ꞌieꞌita ta ꞌiloguguya Yaubada ꞌina loina tetelina manuna, ta wate leꞌoasa yaudi ꞌediyega tomota ꞌigieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ta pwalu ꞌiꞌitedi ga ꞌiꞌatenuwa ꞌoleꞌoleyedi, manuna ꞌadi mwauyao ꞌediyega nigeya ꞌadi tolemamo, ꞌatuwa sipi kwanikwanidi nigeya ꞌadi toꞌitaꞌiꞌitamo. ");
INSERT INTO dob_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ga ꞌina tononoyao ꞌieonedi, “Sesoi boboꞌana ta tosesoi ꞌomi puꞌepuꞌemimo, ");
INSERT INTO dob_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ꞌenega Tonibagula ꞌenaya wasisida be topaisewao ꞌida etunedi ꞌina bagulaya sabi sesoi.” ");
INSERT INTO dob_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ꞌina tononoyao site tuwelo ꞌibwauyedi ga loina be waiwai ꞌiꞌebwaꞌedi be ꞌenega sawesawediya yaluyaluwa biꞌi tomota ꞌediyega sida ula apwesedi be leꞌoasa be neneta tomota ꞌediyega sida gieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Tonono nidi ꞌadi esanao getedi: Nugana Saimoni, tauna sieesena Pita, ta tasina Anidulu, be Yemesa ta tasina Yoni, taudi tamadiya Sebedi, ");
INSERT INTO dob_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","be Pilipi be Batolomiu be Tomasi be Madiu, tauna takisi ꞌana toꞌewa, ta wate mali Yemesa tauna Alipio natuna, be Tadiasi, ");
INSERT INTO dob_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ta wate mali Saimoni, tauna togewana sinabwana ꞌebeloina manuna, be Yudasa Isikaliota, tauna maꞌetamo Yesu ꞌida sipupuye. ");
INSERT INTO dob_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu site tuwelo nidi ꞌiloinedi ga ꞌietunedi, ꞌigwae, “Geyaꞌabo taudi nigeya me Yudia ꞌediya watautauya, ta wate geyaꞌabo Samelia ꞌasanao ꞌediya walugulugu, ");
INSERT INTO dob_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ta esi sipi kwanikwanidi ꞌediya watatauya, taudi nate ꞌida bodao me Isileli, ");
INSERT INTO dob_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","be ꞌediya wasimana apwesa ꞌaene Yaubada ꞌina loina niꞌatu ꞌimai saba. ");
INSERT INTO dob_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Toleꞌoasao wagieboboꞌanedi be tomwawasa wagietoolodi be tolepeloyao wagieꞌesasedi, ta wate yaluyaluwa biꞌi tomota ꞌediyega waula apwesedi. Yaubada ꞌina oboboma niꞌatu ꞌiꞌebwaya daisimi, ꞌenega ꞌomi wate ꞌilobwenemi be wada ꞌebwayadaita tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ta ꞌimi sakowasi ꞌenaya geyaꞌabo ꞌeisa mani ꞌimi tana ꞌediya wausausa ꞌabwaga manuna. ");
INSERT INTO dob_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Geyaꞌabo wate tana waꞌewaꞌewa. Geyaꞌabo watei ꞌami ꞌoama ꞌeluwena, nai ꞌami ꞌaelawa ꞌeluwena, nai ꞌimi ꞌetoguna ꞌeluwena waꞌewaꞌewadi, manuna topaisewa ꞌana masula sawesawenaya be ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ta ꞌeguma ꞌasa sinabwana nai gidalina ꞌena walulugu, waꞌebesa nugana yaita ꞌina bubuna boboꞌana, ꞌenega ꞌenaya waeꞌowaga ꞌana laba sena nina wapilisine. ");
INSERT INTO dob_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ta ꞌabo ꞌebweu anuwa ꞌena walulugu, nugana wada lokagutoki ꞌediya, ");
INSERT INTO dob_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ta ꞌabo susu nidi ꞌidi bubuna boboꞌana waenima lotunedi be waona obobomedi, ta ꞌabo ꞌidi bubuna toꞌumalina geyaꞌabo ꞌimi enimalotuna be ꞌimi onaoboboma ꞌediya wamudamudali. ");
INSERT INTO dob_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Ta ꞌabo nigeya ꞌebweu yaita ꞌiꞌauꞌauꞌewami ꞌina anuwaya, nai ꞌimi ona nigeya ꞌinoonoi, ꞌasa nina ꞌenega waapwesa be ꞌaemiyega nedila waloutuutu yauledi ꞌidi senaya, nate ꞌebeꞌita toniꞌasao ꞌediya, be muliyega ꞌasa nina wapilisine. ");
INSERT INTO dob_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Onaꞌaiꞌaila, maꞌetamo bwaꞌomatana ꞌana tuta ꞌenaya, taudi ꞌasa nidi siguitoyasemi loina sinabwa wawasae siloba, ta nigeya nadigega me Sodoma be me Gomola ꞌadi loina. ");
INSERT INTO dob_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Wanuwaꞌiꞌisi ꞌaene ꞌaboꞌagu yaetuetunemi ꞌomi nadigega sipi panapanaisimi watautauya kedewa bosasa gamwagamwanidiya, ꞌenega ꞌilobwenemi be wada nuwasinapu mwata ꞌatuwa, ta esi wada bubuna nuwana bunebune ꞌatuwa. ");
INSERT INTO dob_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“ꞌEnega waꞌitaꞌiꞌisimi, manuna tomota ꞌetamo sitauyemi etala manuna, be anuwa tapwalolo ꞌediya ꞌetamo sisapisapimi, ");
INSERT INTO dob_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","be siꞌauꞌewami be sitauyemi toloinao ta kiniyao matadiya be sieꞌewami manuna ꞌomi ꞌaene ꞌigu bodao, ta teteligu ꞌediya wada simane, be wate sena apwesa tomoteninao ꞌimi simana sida nono. ");
INSERT INTO dob_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Ta ꞌabo matadiya sietoolomi geyaꞌabo waꞌateꞌatesaꞌala be ꞌaene mwaꞌadega wada onaꞌesa, manuna ꞌetamo tuta nina ꞌena Yaubada ꞌimi ona ꞌiꞌebwaꞌemi, ");
INSERT INTO dob_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ta nigeya ꞌaene ꞌomi waonaona ta Yaubada yaluyaluwana ꞌemiyega ꞌionaona. ");
INSERT INTO dob_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ta wate tuta simeemai ꞌediya tomota ꞌidi susu solanaya losaiya ꞌida apwesa manugu, nate tai tasina ꞌisipupuyei be siloemwawasi. Nadigega wate tamana natuna ꞌida sipupuyei be siloemwawasi. Wate gogama sinadiyao be tamadiyao sida etalauwaledi be siloemwawasidi. ");
INSERT INTO dob_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta tomota maiboꞌadi sida etalauwalemi manuna ꞌomi ꞌaene ꞌagu toemisao. Ta ꞌabo yaisigedi sieꞌalamaꞌiꞌita be sitoolopaꞌala ga ꞌana laba tuta ꞌana ꞌebe losalowa ꞌenaya, gwausowala ataya sida loba. ");
INSERT INTO dob_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Ta ꞌeguma ꞌebweu sena ꞌena siunuunumi wadedena mali ꞌasa ꞌenaya. Onaꞌaiꞌaila, maꞌetamo geyaꞌabo ꞌasa maiboꞌana Isileli solanaya waguiguinuwa egumwali ta ꞌaboꞌagu Tomota Natuna yailama. ");
INSERT INTO dob_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Tomuliya nigeya sawesawenaya be ꞌina toeꞌita ꞌisinabwasine. Nadigega wate topaisewa nigeya sawesawenaya be ꞌina ꞌinapwana ꞌiloine. ");
INSERT INTO dob_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ta esi boboꞌana ꞌeguma ꞌaene ꞌomi ꞌagu tomuliyao ta ꞌaboꞌagu taeleleleya. Manuna ꞌaboꞌagu tonianuwa, ta ꞌabo niꞌatu sieesegu Bielisibubi, ꞌomi ꞌigu bodao ꞌetamo siꞌawatoꞌumali wawasaemi. ");
INSERT INTO dob_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ꞌEnega geyaꞌabo wamatamatautedi, manuna yage nidi kwaikwaiyidi maꞌetamo Yaubada ꞌigieapwesedi be sida lomatanaꞌi. ");
INSERT INTO dob_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ꞌEnega toꞌase guguyoi ꞌena yasimanedi ꞌemiya, ꞌasiyataya wada simanedi tomota yaudi ꞌediya ta toꞌase yaeꞌawa sayasayaena ꞌemiya wada simana apwesedi ꞌimi bwaima etanidiyega. ");
INSERT INTO dob_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Ta taudi oomi siloeloemwawasi geyaꞌabo wamatamatautedi, manuna taudi oomi namo sawesawenaya be siloemwawasi, ta yaluyaluwami geyaꞌabo. Ta esi Yaubada wada mataute, manuna tauna sawesawenaya be ꞌasagabugabu ꞌenaya oomi ta yaluyaluwami ꞌiloemwawasa luwedi. ");
INSERT INTO dob_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“ꞌEbeꞌita gete, ꞌabo bedinegwa ꞌeluwa tagimwanedi ꞌadi maisa toea ꞌebweuna namo, ta esi Yaubada ꞌiꞌitaꞌiꞌisidi, be ꞌabo ꞌebweuna ꞌimwamwawasa nate Tamamina ꞌina nuwanuwa ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ta ꞌanabwaꞌayoi nigeya sawesawenaya be ꞌuyaꞌuya wasawa ꞌebweu deba ꞌenaya, Yaubada ꞌadi yau ꞌimwalamwalatonidi. ");
INSERT INTO dob_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ꞌEnega geyaꞌabo waꞌateꞌate saꞌala, manuna ꞌomi Yaubada ꞌina yage sinabwana, ta bedinegwa nigeya yage sinabwana. ");
INSERT INTO dob_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ꞌAbo yaisigedi manugu sisisimana tomota matadiya, ꞌetamo galewaya ꞌaboꞌagu wate manudi yada simana Tamagu matanaya. ");
INSERT INTO dob_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ta ꞌabo yaisigedi sieyaseyaseyegu tomota matadiya, ꞌaboꞌagu wate maꞌetamo galewaya Tamagu matanaya yaeyaseyaseyedi. ");
INSERT INTO dob_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Geyaꞌabo wanuwena ꞌaene ꞌigu mai baleꞌuya ꞌenega nuwasiwalowa waloba. Nigeya saꞌi, ta losaiya esiya. ");
INSERT INTO dob_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ꞌIgu mai manuna tai tamana ꞌida etalauwale, ta wate waine sinana ꞌida etalauwale, ta waine lawana ꞌida etalauwale, ");
INSERT INTO dob_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ta tai ꞌina susu sida etalauwale. ");
INSERT INTO dob_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ta ꞌabo yaita tamana be sinana ꞌiobobomedi sinabwana ta ꞌaboꞌagu gidalina, tauna nigeya sawesawenaya be ꞌimuliyegu. Ta ꞌabo yaita wate natuna meꞌolotona nai mewainena ꞌiobobome sinabwana ta ꞌaboꞌagu gidalina, tauna nigeya sawesawenaya be ꞌimuliyegu. ");
INSERT INTO dob_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ta ꞌabo yaita yawasina nigeya ꞌitagwatagwalei be ꞌimwamwawasa kelose ꞌenaya, nadigega ꞌaboꞌagu, tauna nigeya sawesawenaya be ꞌimuliyegu. ");
INSERT INTO dob_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ta ꞌabo yaita tauna yawasina manuna ꞌiguiguinuwa, maꞌetamo ꞌida loseye; ta ꞌabo yaita yawasina ꞌiloseye manugu, maꞌetamo yawasi boboꞌana ꞌilobalima. ");
INSERT INTO dob_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ta ꞌomi ꞌabo yaita ꞌiꞌauꞌewami, ꞌaboꞌagu be ꞌagu Toetune wate ꞌiꞌauꞌewema. ");
INSERT INTO dob_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Be ꞌabo ꞌoyo palopita ꞌuꞌauꞌewa ꞌina epalopita manuna, maꞌetamo palopita ꞌana pali ꞌuda loba. Ta ꞌabo ꞌoyo tai boboꞌana ꞌuꞌauꞌewa ꞌina etai boboꞌana manuna, maꞌetamo tai boboꞌana ꞌana pali ꞌuda loba. ");
INSERT INTO dob_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ta ꞌabo ꞌoyo bwasi gonitu ꞌagu toemisa auwauna ꞌebweu ꞌena ꞌuꞌebwaya, yaeonayo maꞌetamo ꞌamu pali boboꞌana ꞌuloba.” ");
INSERT INTO dob_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu ꞌina loguguya ꞌina tononoyao site tuwelo ꞌediya ꞌilosaloninaya ta ꞌenega sena nina ꞌipilisinena ga ꞌisakowasi ꞌasa nidi ꞌebweuna ꞌebweuna ꞌediya, ꞌieꞌieꞌita ta ꞌiloguloguguya. ");
INSERT INTO dob_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tuta gote ꞌenaya Yoni togiebapitaiso niꞌatu deliya sisaꞌuna ga Toꞌetoseyana nina ꞌina guinuwa tetelina ꞌinonona ga ꞌenega ꞌaina ꞌana tomuliyao ꞌietunedi ga sitauya Yesu ꞌenaya ");
INSERT INTO dob_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ga sienaidena, sigwae, “Mwaꞌadega ꞌoyo Toꞌetoseyana nina manuyo ꞌayamwayamwa nai mali tai wate ꞌada yamwa?” ");
INSERT INTO dob_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ꞌEnega ꞌidi ona Yesu ꞌieꞌisena, ꞌigwae, “Waila be Yoni ꞌena waemwasala yage nidi ꞌeguyega niꞌatu wanonodiya ta waꞌitedi, nate, ");
INSERT INTO dob_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","tomata kebokebo matadi niꞌatu siꞌesasediya, tolopegoi niꞌatu siboboꞌana ga sitautauya, tolepelo bwaladi siboboꞌana limana, totenatui niꞌatu ona sinoono, tomwawasa sitoolo limana, ta wate togomabeso tetela boboꞌana niꞌatu sinonona. ");
INSERT INTO dob_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ꞌEnega watauya be Yoni waeona be geyaꞌabo manugu ꞌienuenuwanaluwa, manuna ꞌabo yaita ꞌina emisa manugu nigeya ꞌineeneta, tauna ꞌida gwausowala.” ");
INSERT INTO dob_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ꞌEnega Yoni ꞌana tomuliyao nidi siila ta Yesu ꞌilolagata ga boda ꞌediya Yoni manuna ꞌisimana, ꞌigwae, “Lowa maiboꞌami sena mwatui daitaya watauya Yoni sabi nonona, ta toꞌase nuwanuwami be ꞌaene waꞌita? Nai nuwanuwami ꞌaene ꞌebweu pwatula sinabwana yagila ꞌiniuniuye waꞌita? ");
INSERT INTO dob_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nai ꞌebweu tai ma ꞌana ꞌoama esaesa sabi ꞌitana? Nai nigeya, manuna taudi ma ꞌadi ꞌoama esaesa toloina sinabwadi ꞌidi senaya simiyami. ");
INSERT INTO dob_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“Ta toꞌase sana manuna ga watauya sena mwatui daitaya? Nai wanuwena ꞌaene ꞌiabe palopita ꞌebweu waꞌita, aga? Onaꞌaiꞌaila, tai nina waꞌitenaya palopitao ꞌisinabwa sinedi. ");
INSERT INTO dob_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yoni nina manuna lowa Yaubada ꞌina ona Buki Tabu ꞌena gete nadigega ꞌigimisimanena, ꞌigwae, ‘Gete ꞌigu toepilialeale yada etune matamuya ꞌitatauya be ꞌimu ꞌeda ꞌikakali.’ ”. ");
INSERT INTO dob_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ꞌEnega Yesu wate ꞌiona ga ꞌigwae, “Onaꞌaiꞌaila, Yoni togiebapitaiso tauna me baleꞌu maiboꞌadi ꞌisinabwa sinedi, ta maiboꞌadi taudi Yaubada ꞌina ꞌebeloina solanaya Yoni sisinabwa sinena. ");
INSERT INTO dob_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Tuta Yoni ꞌina giebapitaiso ꞌenega ga batuwa, tomota sitootoo waiwai be ꞌaene Yaubada ꞌina ꞌebeloina ꞌenaya silulugu ta toewaiwai nidi taudi ꞌidi waiwaiyega silugu. ");
INSERT INTO dob_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lowa palopitao maiboꞌadi ꞌidi onao be Mosese ꞌina loinao ꞌediyega onaupaupa siapweapwesa ga ꞌana laba Yoni ꞌimai. ");
INSERT INTO dob_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ta ꞌabo nuwanuwami be wanuwa sabwalena Yoni manuna, wada mwalatoni ꞌaene tauna Ilaitiya tuga manuna wayamwayamwa. ");
INSERT INTO dob_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ꞌEnega ꞌabo yaita matenana ona getedi ꞌida nonodi. ");
INSERT INTO dob_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ꞌOmi ꞌepata gete mwaꞌadega yada loesawaꞌiꞌiꞌesa manumi? Nai yada gwae ꞌomi ꞌatuwa nadigega gogama ꞌebe gimwane solanaya siesaesasala ta gosediyao ꞌediya sibwaubwau, sigwaegwae, ");
INSERT INTO dob_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Gosemao mwaꞌadega saꞌi ꞌaꞌabiꞌabi sinaa, ta nigeya wada lausa! Ta wate ꞌaꞌewaꞌewabamu, ta nigeya wada dedoi!’ ” ");
INSERT INTO dob_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Loesawaꞌiꞌi gete ꞌana mwalatoi ꞌaene Yoni ꞌimai ga nigeya ꞌiꞌeꞌai ta nigeya ꞌinumanuma, ta ꞌenega waona ꞌaene ‘Yaluyaluwa biꞌi Yoni ꞌigie kabaleyena.’ ");
INSERT INTO dob_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ta ꞌaboꞌagu Tomota Natuna yamai be yaꞌeꞌai ta yanumanuma ta wate manugu walomugi, wagwaegwae, ‘Tai getei toꞌai ta tonuma diidiga, ta wate takisi ꞌana toꞌewao be ꞌaidi wate totoꞌumalidi ꞌiegosigosiyanedi.’ “Ta taudi tomwalatoi ꞌaiꞌaila maꞌetamo ꞌidi guinuwa boboꞌadi ꞌediyega mwalatoi ꞌaiꞌaila ꞌiapweapwesa.” ");
INSERT INTO dob_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ꞌEnega Yesu ꞌasa nidi ꞌina guinuwa waiwaidi siꞌitediya ta nigeya sinuwanuwa ꞌebuni ꞌidi loegesiyao ꞌediyega, taudi manudi ꞌilolagata ga ꞌibaꞌedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ꞌOmi me Kolesini be me Beteseida nuwaꞌoleꞌolemi saꞌi. Manuna ꞌebe nuwaowana nidi niꞌatu yaguinuwedi ꞌemiya, ta esi nigeya wanuwanuwa ꞌebuni, ta esi ꞌeguma me Taiya be me Saidoni ꞌediya yada guinuwenaya, nai lowaenei sida nuwaꞌebuni, be kumata ꞌadi ꞌoamao sida ꞌotedi be kwausa ꞌediyega sida kwausidi, be sieꞌitaedi ꞌaene ꞌidi bubuna toꞌumalina ꞌediyega niꞌatu sinuwaꞌebuni. ");
INSERT INTO dob_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ta esi ꞌomi nigeya ꞌaiꞌaila, ꞌenega bwaꞌomatana ꞌana ꞌasiyata ꞌenaya Yaubada ꞌiabe me Taiya be me Saidoni ꞌiꞌatenuwa ꞌoleꞌoleyedi, ta ꞌomi geyaꞌabo. ");
INSERT INTO dob_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ta me Kapaneumi ꞌomi mwaꞌadega? ꞌAene taumi wagituꞌeyemi galewaya, aga? Geyaꞌabo saꞌi! Ta esi ꞌiabe tomwawasa ꞌidi ꞌasa ꞌubuninaya sida ulamwaꞌutemi. Manuna ꞌebe nuwaowana nidi niꞌatu yaguinuwedi ꞌemiya ta saꞌi nigeya wanuwanuwa ꞌebuni, ta esi ꞌeguma me Sodoma ꞌediya yada guinuwenaya, nai lowaenei sida nuwaꞌebuni, ꞌenega Yaubada geyaꞌabo ꞌida peꞌupeꞌudi, ta batuwa ꞌidi ꞌasa ꞌida miyami. ");
INSERT INTO dob_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ꞌEnega bwaꞌomatana ꞌana ꞌasiyata ꞌenaya Yaubada ꞌiabe me Sodoma ꞌiꞌatenuwa ꞌoleꞌoleyedi, ta ꞌomi geyaꞌabo.” ");
INSERT INTO dob_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tuta gote ꞌenaya Yesu ꞌigwae, “Kagutoki Tamagu, ꞌoyo galewa ta baleꞌu ꞌadi toloina, mwalatoi gete ꞌukwaiyena tosinasinapuyao be tomwalatoiyao ꞌediyega, ta esi gogama gidalidi ꞌediya ꞌueꞌitaena. ");
INSERT INTO dob_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Onaꞌaiꞌaila Tamagu, ꞌimu nuwanuwa gete boboꞌana.” ");
INSERT INTO dob_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ta wate ꞌigwae, “Yage yauyauna niꞌatu Tamagu nimaguya ꞌisaꞌudi, ta Tamaguna tebweuna ꞌimwalatonigu, ta ꞌaboꞌagu wate Tamagu tebweugu yamwalatonina, ta wate yaisigedi taudi ꞌabo nuwanuwagu be Tamagu yaeꞌitae ꞌediya, taudi wate sida mwalatoni. ");
INSERT INTO dob_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ta ꞌenega ꞌomi ꞌimi paisewa mwauna, wada mai ꞌeguya, be yada gieyawaiꞌatemi. ");
INSERT INTO dob_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ta ꞌomi wada etotowanegu be maꞌegwao tada paisewa, be ꞌenega yaluyaluwami ꞌidi eyawaiꞌata sida loba, manuna ꞌaboꞌagu ꞌigu bubuna menuna ta tonuwamwaꞌuta. ");
INSERT INTO dob_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ꞌEnega paisewa nidi be ꞌaaꞌaala nidi yaꞌebwaꞌemi, kapekapeyadi.” ");
INSERT INTO dob_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabateya Yesu ma ina tononoyao bagula solanega sitauya, ga tonono nidi sibotana, ꞌenega witi atuna siꞌegitagedi, ga siꞌenidi. ");
INSERT INTO dob_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ta tuta nina Palisiyao siꞌitediya, Yesu sieonena, sigwae, “ꞌInapwana, mwaꞌadega ga ꞌenega ꞌimu tononoyao Sabate ꞌana loina sileꞌoaleꞌoa?” ");
INSERT INTO dob_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ꞌEnega Yesu ꞌidi ona ꞌieꞌisena, ꞌigwae, “Buki Tabu ꞌena siꞌetoladina Debida manuna be ꞌeguma wasawai, wada mwalatoni ꞌaene tauna magosenao sibotana, ");
INSERT INTO dob_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ga Yaubada ꞌina anuwaya ꞌilugu ga beledi etaetabuna ꞌiꞌewena ga siꞌenina. Beledi nina ma ꞌana loina, ꞌaene totaliya dimo ꞌadi tagwala be sida ꞌeꞌani. Ta nigeya sawesawenaya be Debida magosenao beledi nina siꞌaꞌani, ta sibotana ꞌenega tuwa tuga siꞌenina. ");
INSERT INTO dob_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Buki Tabu solanaya loina wate ꞌimiyami ꞌaene Anuwa Tabu ꞌana totaliyao Sabate ꞌana loina sida leꞌoa, ta nate nigeya loegesi. ");
INSERT INTO dob_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Onaꞌaiꞌaila Anuwa Tabu yage sinabwana, ta esi ꞌebweu yage sinabwa wawasae gete, ");
INSERT INTO dob_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yaubada ꞌina ona ꞌaene ‘Taliya geya nuwagu ta ꞌatenuwaꞌoleꞌole esiya.’ ꞌEguma ona gete ꞌana mwalatoi wamwalamwalatoni, geyaꞌabo ꞌigu tononoyao waꞌawaꞌawa toꞌumaliyedi, manuna nigeya siloeloegesi. ");
INSERT INTO dob_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Manuna ꞌaboꞌagu Tomota Natuna ta Sabate ꞌana ꞌinapwana.” ");
INSERT INTO dob_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Gote ꞌenega Yesu ꞌitauya ga ꞌidi Anuwa Tapwalolo ꞌena ꞌilugu. ");
INSERT INTO dob_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ga nada ꞌebweu tai manima meyomeyona ꞌilobena. ꞌEnega Palisiyao Yesu ꞌena sienaida, sigwae, “ꞌInapwana, mwaꞌadega, kapekapeyana be Sabate ꞌenaya toleꞌoasa tagie boboꞌanedi?” Ta ꞌidi enaida gete ꞌalena be ꞌaene Yesu ꞌeguma ꞌionagesi, maꞌetamo ꞌenega sida eꞌewa toloina matanaya. ");
INSERT INTO dob_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ta ꞌidi ona Yesu ꞌieꞌisena, ꞌigwae, “Mwaꞌadega ꞌomi ꞌabo ꞌebweu ma ina sipi ꞌebweuna namo, ta ꞌasiyata Sabate ꞌena gaula solanaya ꞌibebeꞌu, ꞌilobwenena be ꞌilisi tuꞌeyei? ");
INSERT INTO dob_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Onaꞌaiꞌaila sipi yage gidalina, ta tomota esiya yage sinabwana. ꞌEnega kapekapeyana be guinuwa boboꞌadi Sabateya taguinuwedi.” ");
INSERT INTO dob_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ꞌEnega Yesu tai nina ꞌieonena, ꞌigwae, “Nimayo ꞌuyasitoto.” Ga tai nina nimana ꞌiyasitotona ga ꞌiboboꞌana limana, nadigega mali nimana. ");
INSERT INTO dob_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ꞌEnega Palisiyao ma idi gamwasowala siapwesa ga taudimo siloina mwaꞌadega Yesu sida loemwawasaꞌese. ");
INSERT INTO dob_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ta ꞌidi loinakwaiya nina Yesu niꞌatu ꞌimwalatonina, ꞌenega sena gote ꞌipilisinena ga ꞌitauya mali senaya, ta tomota yaudi simuliyena, ga gote ꞌena toleꞌoasa maiboꞌadi ꞌigieboboꞌanedi, ");
INSERT INTO dob_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ta wate ꞌiloinedi be ꞌaene geyaꞌabo sisimasimana dadane tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ꞌIna guinuwa nina gete lowa palopita Aisea Yaubada ꞌina ona ꞌigimisimanena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Waꞌita ꞌigu toguinuwa gete esiesinuwana ta ꞌateguyega yaobobomena ma igu gwausowala. Yaluyaluwagu yada saꞌu ꞌenaya be loina palupaludi ꞌida simanedi taudi nigeya me Yudia ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tauna ꞌiabe geyaꞌabo ꞌiegewagewana nai ꞌiebwaubwau, nai ꞌasa solanaya ꞌionaona toila. ");
INSERT INTO dob_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Guna lasalasana geyaꞌabo ꞌiguiguitoyase. Ta wate wenukwa butabutana geyaꞌabo ꞌiuleule, ga ꞌana laba tauna ꞌenega loina palupaluna ꞌiewaiwai, ");
INSERT INTO dob_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","be wate tauna ꞌana esanega taudi nigeya me Yudia sida emisa.” ");
INSERT INTO dob_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ꞌEbweuna tai, lowa yaluyaluwa biꞌi ꞌidi guinuwega matana sikebona, ta wate meyana ꞌilido, ꞌenega simeꞌena Yesu ꞌena ga ꞌigieboboꞌanena, ga muliyega tai nina ꞌieꞌale be ꞌiona ta ꞌiꞌita. ");
INSERT INTO dob_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ꞌEnega tomota yaudi nuwadi ꞌiowana ga sigwae, “Tai gete Toꞌetoseyana, Debida ꞌina susuyega, nai?” ");
INSERT INTO dob_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ta saꞌi Palisiyao guinuwa gete alena sinonona ga sigwae, “Nigeya, ta esi yaluyaluwa biꞌi ꞌidi ꞌinapwana ꞌana esana Bielisibubi ꞌina waiwaiyega yaluyaluwa biꞌi ꞌiula apwesedi.” ");
INSERT INTO dob_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ta Yesu ꞌidi nuwanuwa niꞌatu ꞌimwalatonina ga ꞌieonedi, ꞌigwae, “Bielisibubi tauna gosenao geyaꞌabo ꞌiulaula apwesedi.” Ta wate ꞌigwae, “ꞌEguma ꞌebweu ꞌebeloina ꞌenaya tomotai siweweyala be taudimo silosalosaiya, maꞌetamo ꞌebeloina nina ꞌineneta be ꞌibebeꞌu. ꞌAsa nai susu wate nadigega, ꞌabo soladiya weyala ꞌiapwesa, maꞌetamo sineneta be sibebeꞌu. ");
INSERT INTO dob_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Seitani wate nadigega, ꞌabo ma ina bodao taudimo silosaiya ꞌiabe ꞌina ꞌebeloina nina ꞌibebeꞌu. ");
INSERT INTO dob_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Niꞌatu waona ꞌaene ꞌaboꞌagu Bielisibubi ꞌina waiwaiyega yaluyaluwa biꞌi yaula apwesedi, ta yaita sana ꞌina waiwaiyega ꞌomi waulaula apwesedi? Bielisibubi ꞌenega, nai Yaubada ꞌenega? Gete manuna wanuwanuwa be wada mwalatoni ꞌaene yaita ꞌaboꞌagu. ");
INSERT INTO dob_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Ta ꞌaboꞌagu esi Yaubada Yaluyaluwana ꞌina waiwaiyega yaluyaluwa biꞌi yaulaula apwesedi, ꞌenega wada mwalatoni ꞌaene Yaubada ꞌina loina niꞌatu ꞌiapwesama ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ꞌEbeꞌita gete tai waiwaina nadigega Seitani ꞌina anuwaya. Nigeya sawesawenaya ꞌebweu yaita ꞌilulugu be ꞌina gwegwe ꞌiloꞌewadi, ta esi ꞌeguma ꞌebweu tai balaeyega toewaiwai nina nimana be ꞌaena ꞌiyona nuganedi ta ꞌenega muliyega sawesawenaya ꞌilulugu ꞌina anuwaya be gwegwe nidi ꞌiloꞌewadi. ");
INSERT INTO dob_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ꞌEguma yaisigedi taudi nigeya ꞌagu tolemao, taudi ꞌagu talauwalao. Ta wate yaisigedi taudi nigeya maꞌegwao ꞌada paisewa egogonaya, taudi ꞌigu paisewa sigiegie toꞌumaliye. ");
INSERT INTO dob_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ꞌEnega gete yaeona ꞌaiꞌailimi ꞌaene tomota ꞌidi loegesiyao be ꞌidi ona toꞌumalina maiboꞌana Yaubada ꞌida nuwataudi. Nate namo ꞌeguma Yaluyaluwa Tabuna siꞌawa toꞌumaliyei, geyaꞌabo saꞌi Yaubada ꞌinuwanuwatau. ");
INSERT INTO dob_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“ꞌAboꞌagu Tomota Natuna be ꞌeguma yaita ꞌiꞌawa toꞌumaliyegu Yaubada ꞌiabe ona nina ꞌida nuwatau, ta ꞌabo yaita Yaluyaluwa Tabuna ꞌiꞌawa toꞌumaliyei geyaꞌabo saꞌi Yaubada ꞌinuwanuwatau tuta gete ꞌenaya be tuta simeemai ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesu wate ꞌieonedi, “Kaiwe ꞌeguma boboꞌana, uwana wate boboꞌana. Ta ꞌeguma kaiwe toꞌumalina, uwana wate toꞌumalina. Manuna kaiwe ꞌebweuna ꞌebweuna uwadi ꞌediyega tamwalamwalatonidi ꞌaene kaiwe nidi boboꞌadi nai toꞌumalidi. ");
INSERT INTO dob_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“ꞌOmi saꞌi mwata natunao, ꞌenega nigeya sawesawenaya be ona boboꞌadi waꞌinanadi, manuna maiboꞌami totoꞌumalimi, ta wate ꞌimi nuwanuwao toꞌase nadigega ꞌatemiya simiyami, tuta yauyauna ꞌawamiyega siapweapwesa. ");
INSERT INTO dob_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Manuna tai boboꞌana ꞌatenega yage boboꞌadi ꞌibubu, ta esi tai toꞌumalina ꞌatenega yage toꞌumalidi ꞌibubudi. ");
INSERT INTO dob_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ꞌEnega yaeonami ꞌaene ꞌasiyata bwaꞌomatana ꞌenaya ꞌomi ꞌimi ona besobeso maiboꞌadi manudi Yaubada ꞌida enaidemi be ꞌalena wada simana apwesedi. ");
INSERT INTO dob_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ꞌImu onao tuga ꞌediyega Yaubada ꞌida ꞌawa boboꞌaneyo nai ꞌida ꞌawa toꞌumaliyeyo.” ");
INSERT INTO dob_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ꞌEnega loina ꞌana toeꞌitao be ꞌaina Palisiyao Yesu sieonena, sigwae, “Toeꞌita, nuwanuwama be weꞌiweꞌiyaya ꞌebweuna ꞌuguinuwe be ꞌaꞌita.” ");
INSERT INTO dob_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ta Yesu ꞌieonedi, “ꞌEpata gete ꞌomi toꞌumalimi ta sogala ꞌalemi, nate ꞌalena weꞌiweꞌiyaya waꞌebeꞌebese be ꞌaene ꞌediyega wada mwalatoi ꞌaiꞌailigu ꞌaene Yaubada ꞌenega yamai, ta geyaꞌabo saꞌi weꞌiweꞌiyaya nidi waꞌitaꞌita. Nate namo palopita Yona manuna wanuwaꞌiꞌisi, tauna tuga weꞌiweꞌiyaya manumi, ");
INSERT INTO dob_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","manuna tauna Yona nina ꞌasiyata ꞌetoi be boiboi ꞌetoi ꞌediya iyana sinabwana gamwanaya ꞌimiyami, ta ꞌaboꞌagu Tomota Natuna wate nadigega ꞌasiyata ꞌetoi be boiboi ꞌetoi ꞌediya baleꞌu solanaya yada miyami. ");
INSERT INTO dob_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Maꞌetamo ꞌasiyata bwaꞌomatana ꞌenaya ꞌiabe me Ninibe sida toolo be ꞌepata nimi gete sida eꞌewami, manuna Yona ꞌediya ꞌiloguguyaya ga ꞌidi bubuna toꞌumalina ꞌediyega sisanaila, ta ꞌomi gete tuga loguguya boboꞌana wawasae niꞌatu wanonodi ta nigeya wada sanaila. ");
INSERT INTO dob_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wate nadigega kuwini nina yalasi ꞌenega ꞌimai Solomoni ꞌina ona sinasinapudi sabi nonodi, ta ꞌasiyata bwaꞌomatana ꞌenaya ꞌida toolo be ꞌomi ꞌepata nimi gete ꞌida eꞌewami, manuna tauna ꞌedasolega ꞌimai Solomoni ꞌina ona sinasinapu sabi nonona. Ta gete tuga ona sinasinapu wawasae wanonodi ta ꞌomi geya nuwami wanonodi. ");
INSERT INTO dob_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ꞌEguma yaluyaluwa biꞌi tai ꞌebweuna ꞌenega ꞌiapwesa, tai ꞌida boboꞌana, ta yaluyaluwa biꞌi nina ꞌiabe tuga ꞌatamanaya ꞌiadadana besobeso be ꞌina ꞌebe eyawaiꞌata ꞌiꞌebeꞌebese ta geyaꞌabo ꞌilobaloba. ");
INSERT INTO dob_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ꞌEnega yaluyaluwa nina taunamo ꞌena ꞌigwae, ‘Nai ꞌana ꞌita yaila limana ꞌigu gimiꞌebemiya ꞌena.’ ꞌEnega ꞌiila ga ꞌebemiya nina ꞌilobena kakaena ta siyasiyayonina ta gibugibubuna. ");
INSERT INTO dob_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ꞌEnega ꞌitauya ga yaluyaluwa site sebeni totoꞌumali ꞌaiꞌailidi wate ꞌiꞌauꞌewedima ga maꞌenao silugu ꞌebemiya nina ꞌenaya, ga nada maꞌenao simiyana. ꞌEnega tai nina ꞌina miya sigietoꞌumali ꞌaiꞌailena, lowa nigeya nadigega. ꞌOmi ꞌepata gete wate nadigega toꞌumalimi ta ꞌimi ꞌebe losalowa ꞌida toꞌumali wawasae.” ");
INSERT INTO dob_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu ꞌetamo boda ꞌediya ꞌionaona ta sinana be tasinao simai ga ꞌatamanaya sitoolo ta siꞌebeꞌebesa mwaꞌadega be ꞌena sida ona. ");
INSERT INTO dob_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ꞌEnega ꞌebweu tai aledi ꞌimeꞌena Yesu ꞌena. ");
INSERT INTO dob_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ga Yesu tai nina ꞌina ona ꞌieꞌisena, ꞌigwae, “Yaita sana sinagu ta yaisigedi tasigwao?” ");
INSERT INTO dob_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ꞌEnega ꞌana tomuliyao ꞌediya ꞌienimasusuya ta ꞌigwae, “Gete taudi sinagu be tasigwao. ");
INSERT INTO dob_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Manuna ꞌeguma yaisigedi Tamagu galewaya ꞌina nuwanuwa simulimuliye, taudi tasigwao nai nuugwao nai sinagwao.” ");
INSERT INTO dob_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Gote ꞌasiyata nina ꞌenaya Yesu anuwa nina ꞌenega ꞌiapwesa ga ꞌidolo leꞌawaya ga ꞌimiyatowa. ");
INSERT INTO dob_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ꞌEnega boda sinabwana siegogonama ꞌenaya, ga ꞌebweu waga ꞌidoedoe ꞌenaya ꞌigelu ga ꞌimiyatowa, ta pwalu leꞌawaya sitootoolo. ");
INSERT INTO dob_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ga eꞌita yaudi ꞌiꞌebwaꞌedi onasemalimaliyega, ꞌigwae, “Tobagula ꞌebweu ꞌina bagulaya ꞌitauya, ga witi atuna ꞌilelewanedi, ");
INSERT INTO dob_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ga ꞌaina atuna ꞌedaya sibeꞌu, ꞌenega manuwa siꞌitedi, ga simwaꞌuta ga siꞌenidi. ");
INSERT INTO dob_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ta ꞌaina atuna bwaꞌa logulegulewana ꞌenaya sibeꞌu, ta muliyega sitabwa manini, manuna bwaꞌa gidalina tuga, ");
INSERT INTO dob_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ꞌenega ala ꞌitudimwedi ga siꞌoapelu, manuna lamudi nigeya bwaꞌa gonituna silobaloba. ");
INSERT INTO dob_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Ta ꞌaina atuna kwakwakwala ꞌediya sibeꞌu ga sitabwa enoenowa, ta kwakwakwala ꞌiewaiwai ga ꞌididi emwawasidi. ");
INSERT INTO dob_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ta ꞌaina atuna bwaꞌa boboꞌana ꞌenaya sibeꞌu, ga sitabwama ga sisinabwa ga siuwa, ꞌenega ꞌaina atuna uwadi ꞌadi yau analedi, ta ꞌaina sikisiti, be wate ꞌaina teti. ");
INSERT INTO dob_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“ꞌEguma matenami ona gete wada nono.” ");
INSERT INTO dob_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ꞌEnega ꞌina tononoyao siapwesama ga Yesu sieonena, sigwae, “Toꞌase manuna onasemalimaliyega boda nidi ꞌediya ꞌueꞌieꞌita?” ");
INSERT INTO dob_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ꞌEnega Yesu ꞌigwae, “ꞌOmi niꞌatu Yaubada ꞌemiya ꞌitagwala be ꞌina loina solaꞌaiꞌailidi ꞌana tomwalatoiyao, ta boda getedi nigeya. ");
INSERT INTO dob_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ꞌEguma yaisigedi nadigega ma idi mwalatoi, ꞌiabe loeposeyana sinabwa wawasae siloba, ta esi ꞌeguma yaisigedi nigeya ꞌidi mwalatoimo ta toꞌase nai ꞌediya simiyami ꞌiabe maiboꞌana siloseyedi. ");
INSERT INTO dob_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gete ꞌalena ꞌenega onasemalimaliyega yaeꞌieꞌita ꞌediya, manuna ꞌidi dune ꞌediyega nigeya sida ꞌita ꞌaiꞌaila, ta wate ꞌidi nono ꞌediyega nigeya sida nuwasabwalena. ");
INSERT INTO dob_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tomota getedi manudi lowa Aisea ꞌigimisimana, ꞌigwae, ‘Maꞌetamo waenoenono ta geyaꞌabo nuwami ꞌisabwasabwalena. Be wate wadunedune tuga, ta geyaꞌabo saꞌi waꞌitaꞌita. ");
INSERT INTO dob_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Manuna tomota getedi ꞌidi nuwanuwao siꞌelokwani, ga tenadi ꞌitui, ta wate matadi ꞌikebo. ꞌAbona nai matadiyega siꞌita, ta tenadiyega sinono be sinuwa sabwalena, be ꞌeguya sida sanaila, be yagie boboꞌanedi.’ ");
INSERT INTO dob_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ta ꞌomi ma imi gwausowala, manuna matamiyega waꞌitaꞌita ta tenamiyega wanonono. ");
INSERT INTO dob_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Onaꞌaiꞌaila, yage getedi waꞌitaꞌitadi ta wanononodi lowa palopitao be topalupaluyao nuwanuwadi sinabwana be sida ꞌitadi nai sida nonodi, ta nigeya silobalobadi. ");
INSERT INTO dob_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ꞌEnega atu ꞌana ꞌelelewana ꞌana mwalatoi wada nono. ");
INSERT INTO dob_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ꞌEguma yaita Yaubada ꞌina loina tetelina ꞌinono namo, ta nigeya ꞌinuwanuwa sabwaleni, maꞌetamo togietoꞌumali nina ꞌimamai be ona nidi tai ꞌatenega ꞌiꞌewayauledi. Nate atu nidi sibeꞌubeꞌu ꞌedaya ꞌadi mwalatoi. ");
INSERT INTO dob_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Ta wate atu nidi bwaꞌa logulegulewana ꞌenaya sibeꞌubeꞌu taudi tetela boboꞌana sinonoi ta ma idi gwausowala sitatagwala, ");
INSERT INTO dob_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ta nigeya lamudi ꞌipaꞌapaꞌala, ꞌenega tuta gidalina namo ꞌenaya sida miyami, be ꞌabo to tuta ꞌenaya tetela boboꞌana ꞌana emisa manuna mwau nai etalauwala silobai, sibeꞌu manini. ");
INSERT INTO dob_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Ta atu nidi kwakwakwala ꞌediya sibeꞌuya taudi tetela boboꞌana sinonona, ta ꞌidi nuwanuwa baleꞌu be esaesa ꞌana nuwanuwao ꞌediyega tetela boboꞌana siloemwawasina, ꞌenega nigeya sawesawenaya be siuuwa. ");
INSERT INTO dob_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Ta atuna nidi bwaꞌa boboꞌana ꞌenaya sibeꞌuya taudi tetela boboꞌana sinonona ga ꞌana mwalatoi ꞌediya ꞌimiyami ga uwadi boboꞌadi sisaꞌudi. ꞌAina uwadiyao analedi, ta ꞌaina sikisiti, ta ꞌaina teti.” ");
INSERT INTO dob_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ꞌEnega onasemalimali ꞌebweu wate Yesu ꞌiꞌebwaꞌedi, ꞌigwae, “Yaubada ꞌina loina ꞌatuwa nadigega ꞌebweu tai witi atuna boboꞌadi ꞌina bagulaya ꞌilelewanedi. ");
INSERT INTO dob_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ꞌEnega boiboiya siꞌeno mwataya, ta ꞌana talauwala ꞌebweu ꞌimai bagulaya ga pwatula ꞌana ꞌita ꞌatuwa witi wate ꞌilelewanedi witi ꞌaiꞌaila soladiya, ga muliyega ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ꞌEnega maiboꞌadi sitabwama ga siuwa ga pwatula nidi topaisewao siꞌita lobedi. ");
INSERT INTO dob_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ꞌEnega ꞌinapwana nina ꞌina topaisewao simai ga sieonena, ‘ꞌInapwana, atuna boboꞌana ꞌimu bagulaya lowa ꞌulelewanedi, ta mwaꞌadega ga ꞌenega pwatula maꞌediyao sitabwa leleleyama?’ ");
INSERT INTO dob_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ta tonibagula ꞌigwae, ‘Nai ꞌagu talauwala ꞌebweu ꞌilelewanedi.’ “ꞌEnega ꞌina toguinuwao siona, ‘Mwaꞌadega? Kapekapeyana be pwatula nidi ꞌadabu yauledi?’ ");
INSERT INTO dob_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ta ꞌinapwana nina ꞌigwae, ‘Tuwa! Wasaꞌu be sitabwa leleleyama, manuna ꞌeguma watoo be pwatula wadabu yauledi, nai ꞌaina witi wate maꞌediyao wadabu egogonedi. ");
INSERT INTO dob_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ta tuta sesoi esiya ꞌenaya topaisewao yada eonadi be pwatula siegogone nuganedi be sibwagilidi ta ꞌenega sigabu yauledi, ta witi siegogonedi be ꞌigu anuwa masulaya siedododi.” ");
INSERT INTO dob_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ꞌEbweu wate onasemalimali ꞌiꞌebwaꞌedi, ꞌigwae, “Yaubada ꞌina etoloina ꞌatuwa nadigega beno atuna ꞌebweuna tai ꞌiꞌewena ga bagulaya ꞌiasona. ");
INSERT INTO dob_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Beno atuna gidalina tuga ta ꞌina tabwa mulinaya ꞌiekaiwe be ꞌenega manuwao simama be nalinao ꞌediya ꞌidi newa siꞌabidi.” ");
INSERT INTO dob_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ꞌEbweu wate onasemalimali ꞌiꞌebwaꞌedi, ꞌigwae, “Yaubada ꞌina etoloina ꞌatuwa nadigega pwalawa ꞌana ꞌebe gieseseya. Gidalina tuga waine ꞌiꞌewena ga pwalawa sinabwana maꞌiyana ꞌiꞌeinisina, ꞌenega maiboꞌana ꞌiseseya.” ");
INSERT INTO dob_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ꞌina ona getedi maiboꞌadi onasemalimali ꞌediyega pwalu ꞌieꞌitedi, manuna tauna tuta yauna onasemalimaliyega ꞌieꞌieꞌita tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Gete ꞌenega palopita ꞌina onaupaupa ꞌiapwesa, nate lowaenei ꞌigimisimanena, ꞌigwae, “Onasemalimaliyega yada simana be toꞌase Yaubada ꞌikwaiyena baleꞌu ꞌana mweluluwaꞌunu ꞌenega yada onaei.” ");
INSERT INTO dob_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ꞌEnega Yesu pwalu ꞌipilisinedi ga ꞌilugu anuwaya, ta ꞌina tononoyao simai ga ꞌena sigwae, “Onasemalimali pwatula bagulaya ꞌana mwalatoi ꞌuda liꞌami be ꞌada nuwa sabwaleni.” ");
INSERT INTO dob_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ꞌEnega Yesu ꞌigwae, “Witi atuna ꞌana tolelewana nate Tomota Natuna, ");
INSERT INTO dob_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ta bagula nate baleꞌu maiboꞌana, ta witi nate taudi Yaubada ꞌina loina ꞌana tomuliyao, ta pwatula nate taudi toꞌumalina ꞌana toguinuwao, ");
INSERT INTO dob_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ta pwatula ꞌana tolelewana nate tauna Seitani, ta tuta sesoi nate tuta ꞌana ꞌebe losalowa, ta tosesoi taudi aniloseyao, ");
INSERT INTO dob_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","be tuta ꞌana ꞌebe losalowa ꞌenaya totoꞌumalidi taudi ꞌatuwa pwatula sida egogonedi be sida gabu yauledi. ");
INSERT INTO dob_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ta Tomota Natuna ꞌina aniloseyao ꞌida etunedi be toꞌumalina ꞌana toeꞌitao be ꞌana toguinuwao sida egogonedima be ꞌina ꞌebeloina ꞌenega ");
INSERT INTO dob_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","sida ula apwesedi kaiwe ꞌalaꞌalasina solanaya, nate sena nina ꞌenaya tomota sida dedoi be sida esalaꞌiꞌita ꞌelouya ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","“Be muliyega topalupaluyao Tamadi ꞌina ꞌebeloina solanaya sida tuyayala, sinala nadigega. “ꞌEguma yaita matenana ꞌida nono. ");
INSERT INTO dob_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Yaubada ꞌina loina ꞌatuwa nadigega esaesa sinabwana, lowa ꞌebweu bwaꞌa ꞌenaya sikwaiyena ta ꞌebweu tai ꞌilobena, ga ꞌikwaiya limena, ꞌenega ma ina gwausowala ꞌitauya ga ꞌina gwegweyao maiboꞌadi ꞌiegimwaneyedi, ga ꞌadi maisa ꞌiꞌewena ga bwaꞌa nina ꞌigimwanena. ");
INSERT INTO dob_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ta wate Yaubada ꞌina loina ꞌatuwa nadigega toꞌune ꞌebweuna mwali boboꞌana nuwanuwana. ");
INSERT INTO dob_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ꞌEnega ꞌebweu mwali boboꞌana wawasae ꞌilobena ga ꞌenega tauna ꞌina bagi maiboꞌadi ꞌipeledi be ꞌaene mwali nina boboꞌana wawasae ꞌida ꞌewa. ");
INSERT INTO dob_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ta wate Yaubada ꞌina loina ꞌatuwa nadigega gomana tomota siyauyena olaya, ga mali iyana be mali iyana siꞌonedi, ");
INSERT INTO dob_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ga gomana nina ꞌimaa geyogeyoi ta silisina dabalaya, ga simiyatowa, ta iyana maiboꞌadi siweyalidi, be iyana boboꞌadi gaeba ꞌediya sisaꞌudi ta iyana toꞌumalidi siuledi. ");
INSERT INTO dob_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nadigega wate, tuta ꞌana ꞌebe losalowa ꞌenaya, aniloseyao sida ma be totoꞌumalidi sida weyalidi toboboꞌadi ꞌediyega, ");
INSERT INTO dob_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","be sida ula apwesedi kaiwe ꞌalaꞌalasina solanaya, be ꞌena sida dedoi ta siesalaꞌiꞌita ꞌelouya ꞌenega.” ");
INSERT INTO dob_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ꞌEnega Yesu ꞌienaidedi, ꞌigwae, “Mwaꞌadega onasemalimali getedi maiboꞌadi wamwalatonidiya?” Ta sinono ga silotamo, sigwae, “O!” ");
INSERT INTO dob_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ꞌEnega ꞌieonedi, “Gete tuga wada mwalatoni ꞌaene loina ꞌana toeꞌitao ꞌeguma niꞌatu Yaubada ꞌina loina sipanaita ꞌaiꞌailena, taudi ꞌatuwa nadigega ꞌebweu tonianuwa ꞌina gwegwe kadekadelidi ta auwaudi soladiya esaesa ꞌimiyami.” ");
INSERT INTO dob_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu ꞌina onasemalimali getedi ꞌilosalonidi, ga sena gote ꞌipilisinena, ");
INSERT INTO dob_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ga ꞌiila ꞌina ꞌasaya, ta ꞌidi Anuwa Tapwalolo ꞌena ꞌilugu ga ꞌieꞌitedi, ta tomota nuwadi ꞌiowana ga sigwae, “Tai gete mane ꞌenega ꞌina sinasinapu be ꞌina guinuwa waiwaidi ꞌiꞌewaꞌewa?” ");
INSERT INTO dob_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ta wate sigwae, “Nai tai gete toꞌabiꞌabi tuga natuna? Ta sinana Meli, ta tasinao Yemesa be Yosepa be Saimoni be Yudasa, ");
INSERT INTO dob_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ta wate nuunao maꞌedao tamiyami. Ta mwaꞌadega sana ga tai gete nadigega ꞌisinasinapuꞌesa?” ");
INSERT INTO dob_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ꞌEnega siguitoyasena. Ta Yesu ꞌieonedi, ꞌigwae, “Palopitao ꞌadi ꞌamayaba silobaloba mali ꞌasa ꞌediya. Ta taudi ꞌidi ꞌasaya nai ꞌidi anuwaya nigeya ꞌadi ꞌamayabamo.” ");
INSERT INTO dob_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ꞌEnega Yesu nada ꞌina guinuwa waiwaidi nigeya yaudi ꞌiguiguinuwedi, manuna nigeya sida emisena. ");
INSERT INTO dob_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tuta gote ꞌenaya Elodi, tauna Galili ꞌana toloina, Yesu ꞌina guinuwa alena ꞌinonona, ");
INSERT INTO dob_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ga ꞌina toguinuwao ꞌieonedi, ꞌigwae, “Nate tai nina tauna Yoni togiebapitaiso, niꞌatu ꞌaene mwawasega ꞌitoolo limana ga ꞌenega ma ina waiwai ꞌiguiguinuwa.” ");
INSERT INTO dob_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Manuna lowa Elodi Yoni ꞌigiyaina ga ꞌiyonina ta deliya ꞌisaꞌuna. Ta Yoni ꞌana giyai ꞌalena nate ꞌebweu waine ꞌana esana Elodiasa, nate Elodi tasina Pilipi mwanena, ");
INSERT INTO dob_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ta Elodi ꞌiagina ga ꞌiaina, ta Yoni Elodi ꞌieonena, ꞌigwae, “Gote nigeya bubuna boboꞌana manuna tasiyo mwanena ꞌuaina.” ");
INSERT INTO dob_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nate ꞌalena ꞌenega Elodi nuwanuwana be Yoni ꞌiloemwawasi, ta esi tomota yaudi Yoni siꞌawa palopitaena, ꞌenega Elodi ꞌimatauta ga nigeya Yoni ꞌiloeloemwawasi. ");
INSERT INTO dob_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Muliyega Elodi ꞌina ꞌasiyata tubuwa ꞌana ꞌebe nuwaꞌiꞌita sagalina ꞌenaya boda siegogona, ga Elodiasa natuna mewainena boda matadiya ꞌilausa ga Elodi ꞌigiegwausowalina. ");
INSERT INTO dob_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ꞌEnega Elodi gomagweine nina ꞌena ꞌiona oboboma be ꞌaene ꞌabo toꞌase nuwanuwana ꞌida ꞌebwaꞌe tuga, ta wate ꞌisawa tamatamana. ");
INSERT INTO dob_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ꞌEnega sinana ꞌiona gomagweine ꞌenaya ga ꞌenega gomagweine nina Elodi ꞌieonena, ꞌigwae, “Nuwanuwagu Yoni togiebapitaiso bulubuluna gaeba ꞌenaya ꞌusaꞌu be ꞌuꞌebwaꞌegu.” ");
INSERT INTO dob_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ꞌEnega Elodi ꞌinuwamwau sinabwana, ta tuwa tuga ꞌina sawatamatamana ꞌinuwaꞌiꞌisina, ta boda niꞌatu ꞌina ona sinonona, ꞌenega ꞌitagwala, ");
INSERT INTO dob_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ta ꞌina toguinuwao deliya ꞌietunedi, ga Yoni ꞌotona siꞌupwena, ");
INSERT INTO dob_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ta bulubuluna gaebaya siusena ga simeꞌena, ga gomagweine siꞌebwaꞌena. Ta gomagweine nina ꞌiꞌewena ga ꞌitauyena sinana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ta Yoni ꞌana tomuliyao simai ga Yoni kokowana siꞌewena, ga sisaꞌu ꞌaliꞌaliyena, ta muliyega sitauya Yesu ꞌena, ga yage gete sisimanena. ");
INSERT INTO dob_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ta Yesu yage gete ꞌinonona, ꞌenega ꞌiapwesa ga waga ꞌigeluna ga ꞌitauya sena mwatui daitaya. Ta boda Yesu ꞌina tauya alena sinonona, ꞌenega ꞌidi ꞌasa ꞌediyega siapwesa ga ꞌedega sitauya Yesu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ta tuta nina Yesu wagega ꞌisuya dabalaya pwalu sinabwana ꞌiꞌitedi, ga ꞌina nuwaꞌoleꞌoleyega toleꞌoasao ꞌigieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ta ꞌasuinuwanuwaya ꞌina tononoyao simai ga Yesu sieonena, sigwae, “ꞌInapwana, sena gete mwatui daita ta ꞌiabe ꞌiguguyoi. ꞌEnega boda getedi ꞌuda etunedi be sida ila, be ꞌadi masula sida gimwane ꞌasa selabediya ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ta Yesu ꞌigwae, “Geyaꞌabo sitautauya, ta ꞌomi esi masula waꞌebwaꞌedi be siꞌaꞌa.” ");
INSERT INTO dob_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ꞌEnega sigwae, “Ya! ꞌAma masula nigeya yauna, nate namo beledi nima ta iyana ꞌeluwa.” ");
INSERT INTO dob_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ta Yesu ꞌigwae, “Beledi be iyana nidi waꞌebwaꞌegu.” ");
INSERT INTO dob_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ꞌEnega pwalu ꞌiloinedi ga pwatulaya simiyatowa, ga beledi nima ta iyana ꞌeluwa ꞌiꞌewedi, ta ꞌiꞌitatuꞌe galewaya, ga masula nidi manudi ꞌiona oboboma, ga muliyega beledi ꞌigitomwedi, ga ꞌina tononoyao ꞌiꞌebwaꞌedi ga taudi tomota ꞌediya sieguyaiyedi. ");
INSERT INTO dob_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ꞌEnega maiboꞌadi siꞌai ga gamwadi ꞌipawa, ta masula tupwatupwadi siegogonedi, ga kodo tuwelo siloemaedi. ");
INSERT INTO dob_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Toꞌeꞌai nidi tai dimo ꞌadi yau paibi tausani nadigega, ta wate iine be gogama yaudi nigeya sisawasawadi. ");
INSERT INTO dob_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ꞌEnega ꞌina tononoyao ꞌiloinedi be wagaya sigelu be ꞌaene sinugana mali esenaya, ta tauna ꞌaene tomota maiboꞌadi ꞌiemataluwedi be siila ꞌidi ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ꞌEnega sigelu, ta Yesu pwalu ꞌietunediya, ta muliyega tauna tebweuna ꞌoyaya ꞌituꞌe sabi sidasida Yaubada ꞌena. ꞌEnega niꞌatu ꞌiboi, ta Yesu tebweuna namo ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ta tonono nidi ꞌidi waga niꞌatu sineyena ga sidolo bwagabwagaya, ga lisu sinabwana silobena ga ꞌidi waga ꞌilobunibuni, ta wate yagila matadiyega ꞌimeema. ");
INSERT INTO dob_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ta tomwa uliulitaya Yesu ola debanega ꞌitauyama, ga ꞌina tononoyao nidi selabediya ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Gote ꞌena ꞌina tononoyao Yesu siꞌitena ola debanega ꞌimeemai, ga simatauta sinabwana, ꞌenega sinanala, ꞌidi nuwanuwa ꞌaene welabana siꞌitena. ");
INSERT INTO dob_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ta Yesu ꞌieonedi, “Geyaꞌabo wamatamatauta. ꞌAboꞌagu tuga, ꞌimi ꞌinapwana.” ");
INSERT INTO dob_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ꞌEnega Pita ꞌiona, ꞌigwae, “ꞌInapwana, ꞌeguma onaꞌaiꞌaila ꞌoyo, ꞌueonagu be ola debanega yawawa ꞌemuya.” ");
INSERT INTO dob_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ta Yesu ꞌigwae, “ꞌUmai.” ꞌEnega Pita wagega ꞌimwaꞌuta ga ola debanaya ꞌitautauya Yesu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tuta nina ꞌitautauya yagila sinabwana ꞌiꞌitena, ga ꞌimatauta, ta olaya ꞌidalala, ga ꞌibwau, “ꞌInapwana, ꞌulemegu!” ");
INSERT INTO dob_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ta Yesu ꞌilomanini ga Pita ꞌigiyaina ta ꞌigwae, “Toemisa gidaliyo, toꞌase manuna ꞌuenuwanaluwa?” ");
INSERT INTO dob_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ꞌEnega siteluwa wagaya sigelu, ta yagila ꞌipela. ");
INSERT INTO dob_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ga taudi waga ꞌana tomiyanao sibwagobwago Yesu ꞌena, ta sigwae, “Onaꞌaiꞌaila, ꞌoyo Yaubada Natuna.” ");
INSERT INTO dob_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ꞌEnega siabala sena Genesaleta ꞌenaya ga sisuya dabalaya. ");
INSERT INTO dob_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ta sena nina ꞌana tomiyanao Yesu siꞌinanena, ꞌenega ale silelewanena ꞌidi ꞌasa maiboꞌana ꞌediya ga ꞌidi toleꞌoasao maiboꞌadi simeꞌedi Yesu ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ta sisidena, sigwae, “ꞌInapwana, kapekapeyana be toleꞌoasao getedi ꞌamu ꞌoama tupitupinamo sida gitoo?” Ga Yesu ꞌitagwala. ꞌEnega taudi ꞌana ꞌoama sigitoona siboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Muliyega Palisiyao be loina ꞌana toeꞌitao Yelusalemega simai Yesu ꞌena, ga sieonena, sigwae, ");
INSERT INTO dob_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Toꞌase manuna ꞌimu tononoyao ꞌabo ꞌeꞌai mulinaya nigeya nimadi sida ꞌutudi, nate tubudao ꞌidi loina sileꞌoaleꞌoa?” ");
INSERT INTO dob_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ta ꞌieonedi, “ꞌOmi wate Yaubada ꞌina loina waleꞌoaleꞌoa, manuna tubumiyao ꞌidi bubuna wamulimuliyedi. ");
INSERT INTO dob_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yaubada ꞌina loina ꞌeluwa getedi: ꞌebweuna ꞌigwae, ‘Tamayo be sinayo ꞌuda ꞌamayabedi’, ta ꞌeluwena wate ꞌigwae, ‘ꞌEguma yaita tamana nai sinana ꞌiꞌawa toꞌumaliyedi, ꞌilobwenena be waloemwawasi.’ ");
INSERT INTO dob_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ta ꞌomi ꞌimi eꞌita kabokabo, wagwae, ‘ꞌEguma yaita tamana be sinana ꞌieonadi, ꞌigwae, “ꞌIgu gwegweyao niꞌatu yatagwaledi Yaubada ꞌenaya, ꞌenega nigeya sawesaweguya be yalememi” ’, ꞌenega ꞌimi nuwanuwa ꞌaene tai nina ꞌina lema nai ꞌina ꞌamayaba tamana ꞌenaya nigeya yage sinabwana. ");
INSERT INTO dob_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tubumiyao ꞌidi loina gete ꞌenega Yaubada ꞌina loina waeyage besobesoena. ");
INSERT INTO dob_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Onaꞌaiꞌaila ꞌomi tokabokabo. Lowaenei Aisea palopita manumi ꞌionaupaupa ꞌaiꞌaila, tuta nina Yaubada ꞌina ona ꞌisimanena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tomota getedi ꞌawadiyega siꞌamaꞌamayabegu ta ꞌatediyega nigeya, ");
INSERT INTO dob_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ta wate ꞌeguya sitapwalolo besobeso, manuna ꞌidi eꞌitao ꞌaboꞌagu nigeya ꞌeguyega, ta esi tomota tuga ꞌidi nuwenuwega.’” ");
INSERT INTO dob_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ꞌEnega tomota ꞌibwauyedima ga ꞌieonedi, “Ona gete wanono be wada mwalatoni ꞌaene ");
INSERT INTO dob_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","masula nidi ꞌawadega silugulugu nigeya sawesawenaya be sigiegie bailida ta esi ona nidi ꞌawadega siapweapwesama taudi esiya sigiebailida.” ");
INSERT INTO dob_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ꞌEnega ꞌina tononoyao Yesu ꞌena simai ga sieonena, “ꞌInapwana, ꞌunonona ꞌaene Palisiyao ꞌimu ona gete manuna niꞌatu sinuwa mwau.” ");
INSERT INTO dob_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ta Yesu ꞌigwae, “Kaiwe nidi Tamagu nigeya ꞌiasoasodi, maꞌetamo ꞌidabu yauledi. ");
INSERT INTO dob_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ta tuwa tuga, Palisiyao nidi sida miyami ꞌana laba sibebeꞌu, manuna taudi toanuganao matakebokebodi, be ꞌeguma gosediyao matakebokebodi sianuganedi, ꞌiabe maiboꞌadi gaulaya sibebeꞌu.” ");
INSERT INTO dob_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ꞌEnega Pita ꞌilolagata ga ꞌigwae, “Onasemalimali gete ꞌana mwalatoi ꞌuda liꞌami ꞌemaya.” ");
INSERT INTO dob_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ta Yesu ꞌigwae, “Nai ꞌomi wate ꞌetamo nuwami nigeya ꞌisabwasabwalena, ");
INSERT INTO dob_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ꞌenega nigeya wamwalamwalatoni ꞌaene toꞌase ꞌawadega ꞌilugulugu gamwadaya ꞌitatauya, be muliyega ꞌitatauya sumwana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ta esi toꞌase tomota ꞌawadiyega siapweapwesama nate ꞌatediyega simeema ta sigiegie bailidi, ");
INSERT INTO dob_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","nate nuwanuwa toꞌumalidi be loemwawasa be loelata be sogala be ꞌipwala be onakabokabo be sinala be. ");
INSERT INTO dob_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yage getedi ꞌediyega tomota ꞌigiegie bailidi, ta ꞌabo nimada geyaꞌabo taꞌutuꞌutudi tuta ꞌeꞌai ꞌenaya, nate yaluyaluwada geyaꞌabo ꞌigiegie baili.” ");
INSERT INTO dob_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ꞌEnega Yesu sena nina ꞌipilisinena ga ꞌitauya Taiya be Saidoni senadiyao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ta sena nina ꞌenega Kenani wainena ꞌebweu ꞌiapwesa ga Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌoyo Debida ꞌina susu, ꞌuda ꞌatenuwa ꞌoleꞌoleyegu, manuna natugu mewainena niꞌatu yaluyaluwa biꞌi ꞌigiekabaleyena,” ");
INSERT INTO dob_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ta Yesu waine nina ꞌina bwau nigeya ꞌieꞌieꞌisa, ꞌenega ꞌina tononoyao simai ga Yesu sisidena, sigwae, “Waine nina ꞌueꞌidiꞌidiye be ꞌitatauya, manuna ꞌibwaubwau wawasae.” ");
INSERT INTO dob_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ta Yesu ꞌigwae, “ꞌAboꞌagu yamai sipi kwanikwanidi Isileli namo ꞌina ꞌebeloina solanaya manudi.” ");
INSERT INTO dob_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ta esi waine nina ꞌimai ga Yesu matanaya ꞌiꞌaetulasa, ta ꞌigwae, “ꞌInapwana ꞌuda lemegu.” ");
INSERT INTO dob_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ta Yesu ꞌiona, “Nigeya sawesawenaya be gogama ꞌadi masula yaꞌebwaya kedewa ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ta waine nina ꞌigwae, “ꞌInapwana, nate onaꞌaiꞌaila. Ta mwaꞌadega masula mugumuguna ꞌabo sibebeꞌu ꞌinapwana ꞌina ꞌebe ꞌeꞌai ꞌenega, sawesawenaya be ꞌina kedewao siꞌaꞌani?” ");
INSERT INTO dob_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ꞌEnega Yesu waine ꞌina ona nina ꞌieꞌisena, ꞌigwae, “Waine, ꞌoyo saꞌi toemisa ꞌaiꞌaila. ꞌEnega gete tuga ꞌimu emisa nina uwana ꞌida apwesa.” Ta tuta gote ꞌenaya waine nina natuna ꞌiboboꞌana limana. ");
INSERT INTO dob_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ꞌEnega Yesu sena nina ꞌipilisinena ga ꞌiawadawadaꞌe Galili olana leꞌawinega, ga ꞌoyaya ꞌituꞌe, ga nada ꞌimiyatowa. ");
INSERT INTO dob_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ta boda sinabwana silagama ga ꞌidi toleꞌoasao simeꞌedi, taudi tolopegoi be, taudi esilae ꞌediyega sinenetaya be, tomata kebokeboyao be, toekabaleyao be ꞌaidi toleꞌoasao wate Yesu selabenaya sisaꞌudi ga ꞌigieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ꞌEnega pwalu nidi siꞌitedi toekabaleya sionaona be sinonono, be taudi esilae ꞌediyega sinenetaya siboboꞌana limana, be tolopegoi sitautauya palupalu, be tomata kebokebo matadi siꞌesasedi. ꞌEnega boda nidi sinuwa owana, ga me Isileli ꞌidi Yaubada nina situpuna. ");
INSERT INTO dob_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ꞌEnega Yesu ꞌina tononoyao ꞌibwauyedima ga ꞌieonedi, “Boda getedi yaꞌatenuwa ꞌoleꞌoleyedi, manuna niꞌatu ꞌasiyata ꞌetoi bada maꞌegwao ꞌamiyami ta nigeya ꞌadi masulamo, ta geya nuwagu be mabotanidi yaetune iledi ꞌabona nai ꞌedaya sitatai.” ");
INSERT INTO dob_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ta ꞌina tononoyao sieonena, sigwae, “Sena getei mwatui daita, ta mwaꞌadega pwalu sinabwana getei ꞌadi masula talobaꞌese?” ");
INSERT INTO dob_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ꞌEnega Yesu ꞌienaidedi, ꞌigwae, “ꞌEisa ꞌami belediyao simiyami?” Ga sigwae, “Beledi sebeni ta ꞌaina iyana gidalidi.” ");
INSERT INTO dob_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ꞌEnega boda ꞌiloinedi ga baleꞌuya simiyatowa. ");
INSERT INTO dob_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ga beledi sebeni be iyana nidi ꞌiꞌewedi ga manudi ꞌiona lokagutoki Yaubada ꞌena ga ꞌigitomwedi, ta ꞌiꞌebwaꞌedi ꞌina tononoyao ꞌediya, ga taudi sieguyaiyedi boda nidi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ta maiboꞌadi siꞌai ga gamwadi ꞌipawa, ga muliyega masula tupwatupwadi siegogonedi ga kodo sebeni siloemaedi. ");
INSERT INTO dob_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Toꞌeꞌai nidi tai dimo ꞌadi yau powa tausani, ta wate iine be gogama yaudi nigeya sisawasawadi. ");
INSERT INTO dob_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Muliyega pwalu ꞌietunedi ga siila limana, ta Yesu wagaya ꞌigelu, ga Magadani senanaya ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ꞌEbweu tuta ꞌenaya ꞌaidi Palisiyao be Sadusiyao simai ga Yesu sienaidena, sabi toona, ga sieonena, “Kapekapeyana be weꞌiweꞌiyaya ꞌebweu ꞌuda guinuwe be ꞌada ꞌawaꞌaiꞌaile ꞌaene ꞌimu waiwai Yaubada ꞌenega ꞌimai?” ");
INSERT INTO dob_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ga Yesu ꞌiona, “ꞌOmi ꞌabo sinala waꞌita ꞌisugusuguwa be galewa ꞌebwaga ꞌenega ꞌibweyalina, niꞌatu wamwalatonina ꞌaene ꞌiabe mali ꞌasiyata ꞌenaya ꞌoelaa boboꞌana. ");
INSERT INTO dob_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ta ꞌabo gonagonaya galewa bweyabweyalina ta gaigaina waꞌitai, nate wasinapu ꞌaene kwau ꞌimeema. Ga nate onaꞌaiꞌaila weꞌiweꞌiyaya nidi ꞌoelaa manudi ꞌadi mwalatoi niꞌatu wamwalamwalatonidi, ta esi weꞌiweꞌiyaya gete tuta nidi manudi nigeya wamwalamwalatonidi. ");
INSERT INTO dob_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ꞌEpata gete ꞌomi toꞌumalimi ta sogala ꞌalemi, nate ꞌalena weꞌiweꞌiyaya waꞌebeꞌebese be ꞌaene ꞌediyega wada mwalatoi ꞌaiꞌailigu ꞌaene Yaubada ꞌenega yamai, ta geyaꞌabo saꞌi weꞌiweꞌiyaya nidi waꞌitaꞌita. Nate namo Yona manuna wanuwaꞌiꞌisi, tauna tuga weꞌiweꞌiyaya manumi.” ꞌEnega Yesu ꞌipilisinedi ga ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ꞌEnega mali esenaya siabala, ta ꞌina tonono nidi ꞌadi ꞌabwaga nigeya siꞌewaꞌewadi, manuna sinuwa pupuledi. ");
INSERT INTO dob_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ga nada Yesu ꞌieonedi, “Palisiyao be Sadusiyao ꞌadi beledi ꞌana ꞌebe gieseseya ꞌenega waꞌitaꞌiꞌisimi.” ");
INSERT INTO dob_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ꞌEnega tonono nidi taudimo ꞌediya sigwae, “Nai Yesu ꞌina ona ꞌalena getei manuna ꞌada ꞌabwaga tanuwa pupulena.” ");
INSERT INTO dob_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ta Yesu ꞌidi nuwanuwa niꞌatu ꞌimwalatonina, ꞌenega ꞌieonedi, “Toꞌase manuna waonaona ꞌaene nigeya ꞌami ꞌabwagamo? Nate nigeya manuna yaonaona. Nigeya waemiemisa ꞌaiꞌaila, aga? ");
INSERT INTO dob_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nigeya sana wanuwa sabwalena tuta nina beledi nima ꞌediyega tomota paibi tausani yaeꞌenidiya, ta masula ꞌana tupwa maiboꞌana waegogonedi, ");
INSERT INTO dob_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ga ꞌenega kodo yaudi waloemaedi? Tomota wate powa tausani beledi sebeni ꞌediyega yaeꞌenidiya ta ꞌana tupwa maiboꞌana waegogonedi ga kodo yauna ꞌediyega waloemaedi? ");
INSERT INTO dob_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ꞌEnega toꞌase manuna ga nigeya wanuwanuwa sabwalena ꞌaene nigeya masula manuna yaonaona? Ta esi Palisiyao be Sadusiyao ꞌidi ꞌebe gieseseya ꞌenega waꞌitaꞌiꞌisimi.” ");
INSERT INTO dob_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gote ꞌena nuwadi ꞌisabwalena ꞌaene nigeya beledi ꞌaiꞌaila ꞌana ꞌebe gieseseya manuna ꞌionaona, ta esi Palisiyao be Sadusiyao ꞌidi eꞌitao ꞌediyega sida ꞌitaꞌiꞌisidi. ");
INSERT INTO dob_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ꞌEnega Yesu ꞌimai Sisalia Pilipai senanaya ga ꞌienaida ꞌina tononoyao ꞌediya, ꞌigwae, “Mwaꞌadega tomota ꞌidi ona ꞌaboꞌagu Tomota Natuna manugu, ꞌaene ꞌaboꞌagu yaita?” ");
INSERT INTO dob_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ꞌEnega sigwae, “ꞌAina tomota siona ꞌaene ꞌoyo Yoni togiebapitaiso, ta ꞌaina tomota siona ꞌaene ꞌoyo Ilaitiya, ta ꞌaina siona ꞌaene ꞌoyo Yelemaiya nai gimipalopita ꞌebweu tuga.” ");
INSERT INTO dob_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ga Yesu ꞌienaidedi, ꞌigwae, “Ta ꞌomi mwaꞌadega ꞌimi nuwanuwa ꞌaene ꞌaboꞌagu yaita?” ");
INSERT INTO dob_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ꞌEnega Saimoni Pita ꞌilolagata ga ꞌigwae, “ꞌOyo Toꞌetoseyana Yaubada mayawasina natuna.” ");
INSERT INTO dob_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ta Yesu Pita ꞌieonena, ꞌigwae, “Saimoni, Yona natuna, ꞌoyo onaꞌaiꞌaila togwausowala ꞌebweu, manuna ꞌimu mwalatoi gete nigeya tomota ꞌediyega, ta esi Tamagu galewaya ꞌina mwalatoiyega ꞌiꞌebwaꞌemu. ");
INSERT INTO dob_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta wate yaeonayo ꞌaene ꞌamu esana Pita, ta ꞌoyo gulewa, be ꞌemuya ꞌigu ekalesiya yada ꞌabi, be ꞌenega geyaꞌabo bubuna toꞌumalina ꞌiewaiwai ꞌigu ekalesiya nina ꞌena. ");
INSERT INTO dob_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ta wate ꞌebeloina galewaya ꞌana ꞌebe gigege yaꞌebwaꞌeyo, be toꞌase baleꞌuya ꞌugibode, galewaya wate sigibode, ta wate ꞌabo toꞌase baleꞌuya ꞌugigege, galewaya wate sigigege.” ");
INSERT INTO dob_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Gote ꞌena Yesu ꞌina tononoyao ꞌiloina paꞌaledi, ꞌigwae, “Geyaꞌabo ꞌebweu yaita ꞌena wasimasimanegu ꞌaene ꞌaboꞌagu Toꞌetoseyana nina.” ");
INSERT INTO dob_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tuta gote ꞌenaya Yesu ꞌieꞌale ga ꞌina tononoyao ꞌieꞌitedi, ꞌigwae, “ꞌIlobwenena be yatatauya Yelusalema be nada ꞌelouya yaudi yada lobadi, ꞌinapwanao be totaliyao sinabwadi be loina ꞌana toeꞌitao ꞌediyega, be gote ꞌena siloemwawasigu, ta ꞌasiyata ꞌetonina ꞌenaya Yaubada ꞌida gietoolo limagu.” ");
INSERT INTO dob_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ꞌEnega Pita Yesu maꞌalenaya ꞌitauyena, ga ꞌiꞌenapaꞌalina, ꞌigwae, “ꞌInapwana, yage gete geyaꞌabo ꞌemuya ꞌiapweapwesa!” ");
INSERT INTO dob_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ta Yesu ꞌiasakowasi ga ꞌiona Pita ꞌenaya, ꞌigwae, “ꞌOyo Seitani, gete tuga ꞌupilisinegu! Geyaꞌabo ꞌuꞌetoꞌetobodegu! ꞌImu nuwanuwa tomota ꞌidi nuwanuwa, ta nigeya Yaubada ꞌina nuwanuwa nadigega.” ");
INSERT INTO dob_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Muliyega Yesu ꞌina tononoyao ꞌieonedi, ꞌigwae, “Yaita ꞌeguma nuwanuwana be ꞌimuliyegu, ꞌilobwenena be tauna ꞌina nuwanuwa ꞌida guitoyase, be tauna ꞌana kelose ꞌiꞌaali, be ꞌenega ꞌimwamwawasa, nate nadigega ꞌagu muliya nina ꞌana ꞌeda. ");
INSERT INTO dob_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Ta ꞌeguma yaita yawasina ꞌiegagale, maꞌetamo yawasi nina ꞌiloseye. Ta ꞌeguma yaita yawasina manugu ꞌitagwale be ꞌimwamwawasa, tauna ꞌiabe yawasina boboꞌana ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“ꞌEguma ꞌida esaesao baleꞌuya sinabwa wawasae talobadi, nate yage besobeso, ta esi yage sinabwana nate yawasida boboꞌana. Manuna ꞌeguma yawasida boboꞌana taloseyedi, nigeya ꞌebweu wate ꞌana lopaꞌelu ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Maꞌetamo ꞌaboꞌagu Tomota Natuna yaila limanama, be Tamagu ꞌina esaesa tuyatuyayalina ꞌenega yailama, ta wate aniloseyao maꞌegwao, be tomota ꞌidi guinuwao ꞌadi eꞌisa yaꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Yaona ꞌaiꞌaila ꞌemiya ꞌaene tomota ꞌaimi geyaꞌabo wamwawamwawasa ꞌana laba ꞌaboꞌagu, Tomota Natuna, yailama sabi loina be ꞌena waꞌita limagu.” ");
INSERT INTO dob_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ꞌAsiyata sikisi mulinaya Yesu ꞌina tononoyao ꞌetoi ꞌiꞌauꞌewedi, ga maꞌenao situꞌe ꞌoya ꞌebweu kesolana ꞌena. Tonono nidi taudi Pita be Yemesa matasina Yoni. ");
INSERT INTO dob_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tuta nina ꞌidi miya ꞌoyaya Yesu maninina siꞌitena tuyayalina ꞌatuwa sinala ꞌana ꞌita, ta ꞌana ꞌoama ꞌiwakeke ꞌatuwa maedana ꞌisaesae. ");
INSERT INTO dob_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ta wate Mosese be Ilaitiya siapwesama ga Yesu nina maꞌedi siꞌawaꞌawagwae. ");
INSERT INTO dob_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ꞌEnega Pita ꞌilolagata ga Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌida miya gete nadigega boboꞌana, ꞌenega ꞌilobwenena be ꞌeguma ꞌutatagwala yoeyoe ꞌetoi yaꞌabidi be ꞌebweu ꞌoyo manuyo, ta ꞌebweu Mosese manuna, ta ꞌebweu Ilaitiya manuna.” ");
INSERT INTO dob_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita ꞌina ona maꞌetamo nigeya ꞌilosalosaloni ta pwana maedanina ꞌitalaekabobodi, ta pwana ꞌenega ꞌenana ꞌebweu sinonona, ꞌigwae, “Gete natugu boboꞌaiꞌailina, tauna manuna yagwausowala sinabwana, ꞌenega ꞌina onao wada nonodi.” ");
INSERT INTO dob_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ta tonono nidi ona nina sinonona ga ma idi matauta sibeꞌu sanamwaꞌuta, ");
INSERT INTO dob_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ga Yesu ꞌimai ga ꞌigitoodi, ꞌigwae, “Watoolo. Geyaꞌabo wamatamatauta.” ");
INSERT INTO dob_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ꞌEnega sisanatuꞌe ga Yesu tebweuna namo ꞌitootoolo siꞌitena. ");
INSERT INTO dob_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ꞌEnega ꞌoyega siebuebusima ga Yesu ꞌiloinedi, ꞌigwae, “Yage nidi niꞌa waꞌitedi geyaꞌabo tomota ꞌediya wasimasimanedi ga ꞌana laba ꞌaboꞌagu Tomota Natuna mwawasega yatoolo limana.” ");
INSERT INTO dob_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ga Yesu ꞌina tononoyao ꞌena sienaida, sigwae, “Toꞌase manuna loina ꞌana toeꞌitao siona ꞌaene Ilaitiya ꞌigimi nuganama, be muliyega Toꞌetoseyana nina ꞌimama?” ");
INSERT INTO dob_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ta Yesu ꞌigwae, “O nadigega, Ilaitiya ꞌaene ꞌida giminuganama be ꞌenega yage maiboꞌadi ꞌida giepaepaludi. ");
INSERT INTO dob_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ta saꞌi Ilaitiya nina niꞌatu ꞌimai saba, ta tomota nigeya siꞌinaꞌinana ta esi siguinuwa besobeso ꞌenaya toꞌase ꞌidi nuwena nadigega, ꞌiabe wate ꞌaboꞌagu Tomota Natuna nadigega ꞌeguya sibubunaꞌesa.” ");
INSERT INTO dob_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ꞌEnega tonono nidi gote ꞌena sinuwena ꞌaene Yesu Yoni togiebapitaiso manuna ꞌionaona. ");
INSERT INTO dob_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ꞌEnega Yesu ma ina tononoyao simwaꞌuta boda ꞌediya, ta ꞌebweu tai ꞌimai ga ꞌiꞌaetulasa Yesu matanaya, ");
INSERT INTO dob_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ta ꞌigwae, “ꞌInapwana, natugu ꞌuda ꞌatenuwa ꞌoleꞌoleyei be ꞌuda gieboboꞌane, manuna tuta yauna ꞌana lobwebwai manuna ꞌitaitai, ta bwalana siuyauya sinabwana, ta ꞌaina tuta ꞌediya ꞌawesabelulu ꞌenaya ꞌibeꞌubeꞌu, ta ꞌaina tuta bwasi niꞌu ꞌediya ꞌibeꞌubeꞌu. ");
INSERT INTO dob_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ta ꞌimu tononoyao ꞌediya yameꞌena, ta nigeya sawesawediya be sigieboboꞌane.” ");
INSERT INTO dob_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ꞌEnega Yesu ꞌieonedi, “ꞌOmi sana mwaꞌadega? Ga debami paꞌala yaita! Nai nigeya waemiemisegu, aga? Niꞌatu ꞌimi debapaꞌala ꞌenega yaloꞌameꞌame. Baga, gwama nina wameꞌe ꞌeguya be yaꞌita.” ");
INSERT INTO dob_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ꞌEnega Yesu yaluyaluwa biꞌi ꞌiloinena ga lobwebwai gwama nina ꞌenega ꞌiapwesa ga ꞌiboboꞌana limana. ");
INSERT INTO dob_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Muliyega Yesu ꞌina tononoyao simai ga taudimo Yesu maꞌenao, ta sieonena, sigwae, “ꞌInapwana, mwaꞌadega ꞌaboꞌama ga nigeya sawesawemaya be yaluyaluwa biꞌi ꞌaula apwese.” ");
INSERT INTO dob_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ga Yesu ꞌigwae, “Manuna ꞌimi emisa nenetana. Yaonaꞌaiꞌaila ꞌeguma ꞌimi emisa ꞌana waiwai beno atuna nadigega, maꞌetamo ꞌoya gote ꞌena wagwae, ‘Gete ꞌenega ꞌumiya dolo’, ꞌiabe ꞌida ematamatana tuga. Nadigega wate yage maiboꞌana sawesawemiya be waguinuwedi.” ");
INSERT INTO dob_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(-) ");
INSERT INTO dob_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Muliyega Galili ꞌena simiyami, ga Yesu ꞌiemataluwedi, ꞌigwae, “ꞌAboꞌagu Tomota Natuna, ta maꞌetamo ꞌagu tosipupu ꞌida ꞌebwayaegu ꞌagu talauwalao ꞌediya ");
INSERT INTO dob_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","be siloemwawasigu, be ꞌasiyata ꞌetonina ꞌenaya Yaubada ꞌigietoolo limagu.” Yesu ꞌina simana gete manuna sinuwamwau ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Muliyega sitauya Kapaneumi ꞌenaya, ta takisi Anuwa Tabu manuna ꞌana toegogonao simai ga Pita ꞌena sigwae, “Mwaꞌadega, sawesawenaya be ꞌimu toeꞌita nina ꞌitakisi, nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ta Pita ꞌigwae, “O, ꞌiabe ꞌina takisi ꞌisaꞌu.” ꞌEnega Pita ꞌiilama anuwaya, ta Yesu Pita ꞌieonena, ꞌigwae, “Saimoni, toꞌase ꞌimu nuwena toloinao baleꞌuya manudi, yaisigedi ꞌediyega takisi siꞌewaꞌewa? taudi natudiyao ꞌediyega? nai mali tomota ꞌediyega?” ");
INSERT INTO dob_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ꞌEnega Pita ꞌigwae, “Mali tomota ꞌediyega.” Ga Yesu wate ꞌiona limana, ꞌigwae, “Onaꞌaiꞌaila! Ta esi taudi natudiyao nigeya ꞌadi mwaumo. ");
INSERT INTO dob_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ta geyaꞌabo taloogwautoyasa, ꞌabona nai ꞌedaya sinuwamwau. ꞌEnega gete tuga bani ꞌuꞌewa be ꞌudolo leꞌawaya be ꞌabo gimiiyana ꞌulisi, ꞌawana ꞌugigege be solanega mani ꞌuꞌewenama be ꞌuꞌebwaꞌedi, nate ꞌoyo be ꞌaboꞌagu ꞌida takisi, sawesawedaya.” ");
INSERT INTO dob_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tuta gete ꞌenaya Yesu ꞌina tononoyao simai ga sieonena, sigwae, “ꞌInapwana, yaita toloetana Yaubada ꞌina loina solanaya?” ");
INSERT INTO dob_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ꞌEnega Yesu gwama ꞌebweuna ꞌibwauyenama, ga gwama nina gamwagamwanidiya ꞌietoolona, ");
INSERT INTO dob_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","4","ta ꞌieonedi, “Yaonaꞌaiꞌaila yaisigedi ꞌomi ꞌeguma ꞌimi nuwamwaꞌuta gwama gete nadigega, ꞌomi toloetana Yaubada ꞌina loina solanaya, ta ꞌabo nigeya wanuwanuwaꞌebuni be gogama gidalidi nadigega, geyaꞌabo saꞌi walugulugu ꞌina ꞌebeloina ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“ꞌEnega ꞌeguma ꞌebweu tomota gwama gete nadigega ꞌiꞌauꞌewa manugu, tauna ꞌaboꞌagu wate ꞌiꞌauꞌewegu. ");
INSERT INTO dob_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ta esi ꞌeguma yaita ꞌitoo be ꞌagu toemisao gogama getedi ꞌediyega ꞌebweuna ꞌigie beꞌuyei, tai nina nai waine nina ꞌilobwenena be gulewa sinabwana ꞌotonaya silosipwa be magulewana siula mwaꞌute niꞌuya be ꞌidalala. ");
INSERT INTO dob_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“ꞌOmi me baleꞌu nuwaꞌoleꞌolemi saꞌi, manuna ꞌebe beꞌu yaudi simiyami. Onaꞌaiꞌaila ꞌilobwenena be ꞌebe beꞌuyao baleꞌuya sida miyami, ta esi ꞌeguma tai ꞌitoo be gosenao ꞌigie beꞌuyedi, maꞌetamo tai nina ꞌitoꞌumali ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ta ꞌeguma nimayo nai ꞌaeyo ꞌigie beꞌuyeyo ꞌilobwenena be ꞌuꞌupwa yauledi. Nigeya ꞌana toꞌumalinamo ꞌeguma manima ꞌupwaꞌupwayo nai ma imu lopegoi ta yawasiyo boboꞌana ꞌuloba. Ta esi toꞌumali wawasae ꞌemuya ꞌeguma manima luwaluwayo be maꞌae luwaluwayo siula mwaꞌuteyo kaiwe ꞌalaꞌalata atayana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Matayo wate nadigega ꞌeguma ꞌigie beꞌuyeyo ꞌuꞌiwa yaule tuga, manuna nigeya ꞌana toꞌumalinamo ꞌeguma mamata ꞌebweꞌebweuyo ta yawasiyo boboꞌana ꞌuloba. Ta esi toꞌumali wawasae ꞌemuya ꞌeguma mamata luwaluwayo siula mwaꞌuteyo ꞌasagabugabu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Gogama gete nadigega geyaꞌabo ꞌebweuna ꞌediyega waeꞌidiꞌidiye. Onaꞌaiꞌaila, gogama nidi ꞌidi aniloseyao tuta maiboꞌana galewaya Tamagu matanaya simiyami, ta siduneduneye. ");
INSERT INTO dob_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(-) ");
INSERT INTO dob_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ta mwaꞌadega ꞌeguma tai ꞌina sipiyao ꞌadi yau analedi, ta ꞌebweuna ꞌediyega ꞌitauyagesi be ꞌikwakwani, ꞌiabe nainiti naini nidi ꞌoyaya ꞌiasaꞌudi be kwanikwanina nina ꞌiꞌebesei, aga? ");
INSERT INTO dob_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ta ꞌabo ꞌiloba limai, onaꞌaiꞌaila ꞌiabe ꞌina gwausowala sinabwa wawasae. Ta esi site nainiti naini nidi boboꞌadi nigeya manudi ꞌigwaugwausowala wawasae. ");
INSERT INTO dob_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ꞌEnega gete tugai wada mwalatoni ꞌaene Tamagu galewaya geya nuwana be gogama getedi ꞌediyega ꞌebweu yaita ꞌiesiesilae. ");
INSERT INTO dob_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ta ꞌeguma tasiyo toꞌumalina ꞌiguinuwe ꞌemuya, ꞌutoo be wateluwa namo ꞌina toꞌumalina nina wagiepaepalu, be ꞌeguma ꞌenayo ꞌinono, boboꞌana, nate niꞌatu waegosigosiyana limana. ");
INSERT INTO dob_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ta ꞌeguma geya nuwana be ꞌenayo ꞌinonoi, tomota ꞌebweuna nai ꞌeluwa wate ꞌuꞌewadi be maꞌemiyao tasimuna ꞌenaya waona be ꞌina toꞌumalina ꞌana ꞌaiꞌaila ꞌida nuwasabwaleni. ");
INSERT INTO dob_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ta ꞌeguma tuga geya nuwana be ꞌinonomi waona apwesa toekalesiyao ꞌediya, be ꞌeguma geya nuwana wate toekalesiyao ꞌidi ona ꞌinonodi, wada guitoyase tuga be ꞌimiya apwesa nadigega takisi ꞌana toegogonao. ");
INSERT INTO dob_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Yaonaꞌaiꞌaila toꞌase ꞌabo baleꞌuya wayonidi, yage nidi galewaya ꞌiabe wate siyonidi. Ta wate toꞌase ꞌabo baleꞌuya waliꞌamidi ꞌiabe yage nidi wate galewaya siliꞌamidi. ");
INSERT INTO dob_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Gete tuga yaeonami ꞌaene ꞌeguma yaisigedi siteluwa ꞌemiyega baleꞌuya sitatagwala ꞌebweu yage manuna be manuna sisidasida Tamagu galewaya ꞌenaya, ꞌida guinuwa tuga. ");
INSERT INTO dob_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Manuna ꞌeguma ꞌebweu sena ꞌenaya ꞌeluwa nai ꞌetoi tomota ꞌagu esanega simiya egogona, ꞌaboꞌagu wate gamwagamwanidiya yamiyami.” ");
INSERT INTO dob_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ꞌEnega Pita ꞌimai ga Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌeguma tasigu tuta yauna ꞌeguya toꞌumalina ꞌiguiguinuwei, maꞌeisa sawesawenaya be ꞌina toꞌumalina nina yanuwataudi, masebeni, nai ꞌeisa?” ");
INSERT INTO dob_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ga Yesu ꞌiona, “Nigeya masebeni namo, ta esi tomoyauyau. ");
INSERT INTO dob_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Manuna Yaubada ꞌina loina ꞌatuwa kini ꞌebweuna, tauna nuwanuwana be ꞌina toguinuwao ꞌidi lowaga siyotuli ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ꞌEnega ꞌieꞌale ga tai ꞌebweuna simeꞌena ꞌina lowaga teni tausani kina, ");
INSERT INTO dob_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ta nigeya sawesawenaya ꞌiyotuli, ꞌenega ꞌinapwana nina ꞌiloina be ꞌaene tai nina mwanena be natudiyao be ꞌidi gwegweyao maiboꞌadi siegimwanedi, be ꞌadi maisa toloina nina ꞌida ꞌewa toguinuwa nina ꞌina lowaga manuna. ");
INSERT INTO dob_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ta toguinuwa nina ma ina nuwamwau ꞌiꞌaetulasa ga ꞌisidasida ꞌenaya, ꞌigwae, ‘ꞌInapwana ꞌuda ꞌatenuwa ꞌoleꞌoleyegu be maꞌetamo ꞌigu lowaga maiboꞌana yada yotuli.’ ");
INSERT INTO dob_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ꞌEnega ꞌinapwana ꞌiꞌatenuwa ꞌoleꞌoleyena ga ꞌina lowaga maiboꞌana ꞌinuwatauna, ta ꞌenega toguinuwa nina ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ꞌIapwesa ga gosiyana ꞌebweuna ꞌilobena, ta gosiyanana ꞌina lowaga toea analedi namo, ga gosiyana ꞌotonaya ꞌigiyaina ga ꞌididigena, ꞌigwae, ‘Gete tuga ꞌimu lowaga ꞌeguya ꞌuyotuli!’ ");
INSERT INTO dob_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ꞌEnega gosiyanana ꞌiꞌaetulasa ga ꞌenaya ꞌisida, ꞌigwae, ‘ꞌUda ꞌatenuwa ꞌoleꞌoleyegu tuga be maꞌetamo ꞌimu lowaga maiboꞌana yada yotuli.’ ");
INSERT INTO dob_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ta gosiyana ꞌenana nigeya ꞌinoono ta deliya ꞌisaꞌuna be ꞌaene nada ꞌida miyami be ꞌana laba ꞌina lowaga maiboꞌana ꞌiyotuli. ");
INSERT INTO dob_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ta toguinuwao nidi gosediyao yage nina siꞌitena, ꞌenega sinuwamwau sinabwana, ꞌenega sitauya ꞌidi ꞌinapwana ꞌenaya ga siteluwa nidi sisimanedi. ");
INSERT INTO dob_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ꞌEnega ꞌinapwana nina ꞌina toguinuwa ꞌibwauyenama ga ꞌieonena, ꞌigwae, ‘ꞌOyo toguinuwa toꞌumaliyo, manuna ꞌimu sida ꞌatenuwa ꞌoleꞌoleyega ꞌimu lowaga maiboꞌana yanuwataudi, ");
INSERT INTO dob_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ꞌenega ꞌoyo wate ꞌilobwenemu be gosiyamuna ꞌuda ꞌatenuwa ꞌoleꞌoleye be ꞌina lowaga wate ꞌuda nuwatau.’ ");
INSERT INTO dob_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“ꞌEnega ꞌinapwana nina ꞌigamwasowala ꞌaiꞌaila ga deli ꞌana toꞌitaꞌiꞌitao ꞌiloinedi ga toguinuwa nina deliya sisaꞌuna be ꞌaene nada ꞌida miyami be ꞌana laba ꞌina lowaga maiboꞌana ꞌida yotula egumwalidi.” ");
INSERT INTO dob_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ꞌEnega Yesu ꞌina ona ꞌilosalonina, ꞌigwae, “Tamagu galewaya wate ꞌemiya ꞌida guinuwa nadigega, ꞌeguma tasimiyao geyaꞌabo waꞌateꞌatenuwa ꞌoleꞌoleyedi be ꞌidi loegesiyao wanuwanuwataudi.” ");
INSERT INTO dob_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu ꞌina eꞌita nidi ꞌilosalonidi ga sena Galili ꞌipilisinena ga Yudia ꞌina senaya ꞌilugu, nate bwasi Yolidani mali esenaya. ");
INSERT INTO dob_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ta boda wate sinabwana Yesu simuliyena ga nada ꞌidi toleꞌoasao ꞌigieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ꞌEnega Palisiyao simai ga nuwanuwadi be Yesu sitoo, ꞌenega ꞌena sienaida, sigwae, “ꞌInapwana, kapekapeyana be ꞌaina loegesi manudi tai mwanena ꞌisaꞌilei?” ");
INSERT INTO dob_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ta Yesu ꞌigwae, “Buki Tabu ꞌena ꞌetoꞌetoladina niꞌatu wamwalatonina ꞌaene tuta ꞌana ꞌebe eꞌale ꞌenaya Tomweluluwa nina tomota ꞌeluwa ꞌimweluluidi, meꞌolotona ta mewainena, ");
INSERT INTO dob_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ga ꞌigwae, ‘Gete ꞌalena ꞌenega tai tamana be sinana ꞌida pilisinedi be mwanena maꞌiyana simiyaluwa, be siteluwa nidi oodi ꞌebweuna tuga.’ ");
INSERT INTO dob_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Lowa siteluwa nidi simiya dumaduma ta gete tuga niꞌatu sieꞌebweu. Yaubada niꞌatu ꞌiemiya luwedi ꞌenega geyaꞌabo ꞌebweu yaita ꞌiemiya dumedumedi.” ");
INSERT INTO dob_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ꞌEnega siona, sigwae, “Toꞌase manuna Mosese ꞌiloina ꞌaene tai sawesawenaya be pwepwai ꞌena ꞌina guitoyasa ꞌisimane be mwanena ꞌiꞌebwaꞌe be ꞌenega ꞌisaꞌile?” ");
INSERT INTO dob_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ta Yesu ꞌigwae, “Nate ꞌimi debapaꞌala ꞌenega Mosese ꞌitagwala ꞌemiya be mwanemiyao nadigega wasaꞌilaꞌesedi, ta esi gimi tutaya nigeya wate tagwala saꞌila manuna ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ta yaeonami ꞌaene ꞌeguma tai ꞌebweu mwanena nigeya ꞌiloeloegesi ta tai tuga ꞌisasaꞌila be ꞌiaibala mali waine ꞌena, nate ꞌina loelata.” ");
INSERT INTO dob_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ꞌEnega ꞌina tononoyao sieonena, sigwae, “ꞌEguma tai mamwanena ꞌadi loina gete nadigega ꞌilobwenena be geyaꞌabo tai be waine siaiai.” ");
INSERT INTO dob_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ta Yesu ꞌigwae, “Eꞌita gete nigeya tomota maiboꞌadi manudi, ta ꞌeguma Yaubada mwalatoi ꞌiꞌebwaya ꞌaina tomota namo ꞌediya sida mwalatoni ");
INSERT INTO dob_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ꞌaene ꞌaina ꞌoloto ꞌidi tubuwaꞌunu ꞌenega nigeya sawesawenaya be siai, ta ꞌaina ꞌoloto siꞌewedi ꞌenega nigeya sawesawediya be siai, ta wate ꞌaidi ꞌoloto Yaubada ꞌina loina manuna taudimo siꞌetobodedi be geyaꞌabo siaiai. ꞌEguma yaita ona gete sawesawenaya be ꞌimwalatoni, ma ina mwalatoi ꞌida nuwasabwaleni.” ");
INSERT INTO dob_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ꞌEnega tomota gogama simeꞌedi Yesu ꞌenaya be ꞌaene ꞌida gitoodi be manudi ꞌida sidasida Yaubada ꞌena. Ta ꞌina tononoyao esi gogama nidi siꞌetobodedi. ");
INSERT INTO dob_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ta Yesu ꞌigwae, “Geyaꞌabo gogama waꞌetoꞌetobodedi ta esi wada tagwaledi be ꞌeguya sida mai, manuna gogama getedi nadigega Yaubada ꞌina ꞌebeloina ꞌilobwene ꞌaiꞌailedi.” ");
INSERT INTO dob_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ꞌEnega Yesu gogama nidi ꞌigitoodi ga muliyega ꞌipilisinedi. ");
INSERT INTO dob_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Muliyega ꞌebweu tai Yesu ꞌena ꞌimai ga ꞌigwae, “Toeꞌita, to guinuwa boboꞌana yada guinuwe be ꞌenega yawasigu ataya yada loba?” ");
INSERT INTO dob_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ta Yesu ꞌigwae, “Toꞌase manuna guinuwa boboꞌadi manuna ꞌuenaida ꞌeguya? Manuna ꞌebweuna namo toboboꞌana ꞌimiyami, ꞌenega ꞌabo nuwanuwayo be yawasiyo ataya ꞌuloba ꞌilobweneyo be tauna ꞌina loinao ꞌumuliyedi.” ");
INSERT INTO dob_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ga tai nina ꞌienaida, ꞌigwae, “To loina?” Ta Yesu ꞌigwae, “Geyaꞌabo loemwawasa; geyaꞌabo loelata; geyaꞌabo ꞌipwala; geyaꞌabo simana kabokabo; ");
INSERT INTO dob_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ta tamayo be sinayo ꞌuda ꞌamayabedi; be wate gosemwao ꞌuda obobomedi nadigega tauyo ꞌamu oboboma.” ");
INSERT INTO dob_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ga tubuwao nina ꞌigwae, “Loina getedi maiboꞌadi yamuliya ꞌaiꞌailedi, ta toꞌase wate yada guinuwe?” ");
INSERT INTO dob_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta Yesu ꞌigwae, “ꞌEguma nuwanuwayo be adeliyo maiboꞌana boboꞌana, ꞌuila ꞌimu ꞌasaya be ꞌimu gwegwe maiboꞌadi ꞌuegimwaneyedi be ꞌadi maisa ꞌueguyaiyedi togomabeso ꞌediya, ta ꞌenega ꞌumama be ꞌumuliyegu, be ꞌenega maꞌetamo esaesa galewaya ꞌuloba.” ");
INSERT INTO dob_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tai nina Yesu ꞌina ona gete ꞌinonona ga ma ina nuwamwau ꞌiila. Tauna ꞌana yakwala nigeya yauna ta ꞌina gwegwe yau wawasae ꞌiegagaledi. ");
INSERT INTO dob_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ꞌEnega Yesu ꞌina tononoyao ꞌieonedi, “Onaꞌaiꞌaila, toesaesao ꞌidi lugu Yaubada ꞌina ꞌebeloina solanaya mwauna. ");
INSERT INTO dob_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ta wate yaeonami ꞌaene yobai kameli ꞌina lugu siyaluma ꞌana lobwalena ꞌenega mwauna, ta esi toesaesao ꞌidi lugu Yaubada ꞌina ꞌebeloina ꞌenaya mwau wawasae.” ");
INSERT INTO dob_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu ꞌina tononoyao ꞌina ona gete sinonona ga nuwadi ꞌiowana wawasae, ta sigwae, “ꞌEguma gete nadigega, yaita sana sawesawenaya be ꞌebe gwausowala ꞌiloba?” ");
INSERT INTO dob_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ga Yesu ꞌiduneyedi ta ꞌigwae, “Yage gete mwau wawasae tomota ꞌediya, ta esi Yaubada ꞌenaya yage maiboꞌana kapekapeyadi.” ");
INSERT INTO dob_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ꞌEnega Pita ꞌilolagata ga ꞌigwae, “ꞌInapwana, ꞌaboꞌama mwaꞌadega? Manuna ꞌima gwegweyao maiboꞌadi niꞌatu ꞌapilisinedi ta ꞌamuliyemu.” ");
INSERT INTO dob_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ta Yesu ꞌieonedi, “Onaꞌaiꞌaila, maꞌetamo baleꞌu ꞌana gieauwau ꞌenaya ꞌaboꞌagu Tomota Natuna ꞌigu ꞌebemi esaesa ꞌena yada miyatowa, ta wate ꞌomi ꞌigu tononoyao wate tuwelo ꞌimi ꞌebemiya tuwelo ꞌediya wate wamiyatowa be me Isileli ꞌidi susuyao tuwelo wada loinedi. ");
INSERT INTO dob_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Be ꞌeguma yaisigedi ꞌomi ꞌimi anuwao nai tasimiyao nai nuumiyao nai tamamiyao be sinamiyao nai natumiyao nai ꞌimi tanowayao wapilisinedi, maꞌetamo yage nidi wapilisinediya ꞌadi lopaꞌelu ma ꞌadi loeposeyana analedi wada lobadi, yawasimi ataya maꞌiyana. ");
INSERT INTO dob_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ta gete tuga tonuganao yaudi maꞌetamo sida muliya, ta taudi simulimuliya maꞌetamo sida nugana. ");
INSERT INTO dob_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Yaubada ꞌina loina ꞌatuwa tai ꞌebweuna ma ina bagula. Tai nina gonamapumapuya ꞌitoolo ga ꞌitauya ꞌasaya ga ꞌaina toguinuwao ꞌibwauyedima sabi paisewa ꞌina bagulaya. ");
INSERT INTO dob_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ꞌEnega loina ꞌisaꞌuna be ꞌaene ꞌasiyata ꞌebweuna paisewa ꞌana maisa kina ꞌebweuna, ga sitagwala. ꞌEnega ꞌietunediya ga sitauya ꞌina bagulaya sabi paisewa. ");
INSERT INTO dob_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ga sinala ꞌisaetuꞌema ga tai nina ꞌitauya limana ꞌasa nina ꞌena, ga tomota ꞌaidi wate ꞌilobedi simiyamiya daidaita. ");
INSERT INTO dob_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ꞌEnega ꞌibwauyedima ga ꞌigwae, ‘ꞌOmi wate watauya ꞌigu bagulaya be wapaisewa, be ꞌimi paisewa ꞌana maisa palupaluna yada ꞌebwaꞌemi.’ ꞌEnega sitauya bagulaya. ");
INSERT INTO dob_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“ꞌEnega ꞌasuoleoleya ta ꞌasuinuwanuwaya wate ꞌitauya limana ꞌasa nina ꞌena, ga nada tomota ꞌaidi ꞌilobedi ga ꞌibwauyedi ga wate ꞌietunedi ga sitauya ꞌina bagulaya. ");
INSERT INTO dob_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ta ꞌasuinuwanuwa ꞌaiꞌailaya wate ꞌiapwesa limana ga ꞌitauya ꞌasaya ga tomota wate ꞌaidi ꞌilobedi ga ꞌienaidedi, ꞌigwae, ‘Toꞌase manuna ꞌasiyata maiboꞌana wamiyamiya daidaita?’ ");
INSERT INTO dob_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ta sigwae, ‘Manuna nigeya ꞌebweu yaita ꞌibwaubwauyema sabi paisewa.’ Ga tai nina ꞌigwae, ‘ꞌOmi wate watauya ꞌigu bagulaya be wapaisewa.’ ");
INSERT INTO dob_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ꞌEnega boiꞌunu ꞌenaya toni bagula nina ꞌina paisewa ꞌana toꞌitaꞌiꞌita ꞌieonena, ꞌigwae, ‘Toguinuwao maiboꞌadi ꞌubwauyedima be ꞌadi maisa ꞌuꞌebwaꞌedi, taudi tomai auwau ꞌediyega ꞌueꞌale be ꞌadi maisa ꞌuꞌebwaꞌedi be ꞌana laba taudi ꞌasiyata maiboꞌana ꞌena sipaisewaya ꞌadi maisa ꞌebe losalowa ꞌenaya ꞌuꞌebwaꞌedi.’ ");
INSERT INTO dob_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ꞌEnega taudi ꞌasuinuwanuwa namo ꞌenaya sipaisewaya simai ga ꞌadi maisa kina ꞌebweuna ꞌebweuna siꞌewa. ");
INSERT INTO dob_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Muliyega maiboꞌadi wate topaisewa nidi simai ga ꞌadi maisa kina ꞌebweuna ꞌebweuna siꞌewena. Ta togimi paisewa wate, taudi ꞌasiyata maiboꞌana ꞌena sipaisewaya simai ga sinuwena ꞌaene ꞌiabe maisa ma ꞌana loeposeyana siꞌeꞌewa, ta nigeya, taudi wate kina ꞌebweuna namo siꞌewena. ");
INSERT INTO dob_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ꞌEnega ꞌidi kina siꞌewedi ta tonibagula ꞌena silomugi, ");
INSERT INTO dob_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ga sigwae, ‘Tomota tomai auwau ꞌidi paisewa tuta kukupana namo, ta ꞌaboꞌama ꞌasiyata maiboꞌana ala solanaya ꞌapaisewa, ta ꞌana maisa ꞌatuwa maiboꞌama ꞌima paisewa leleleya.’ ");
INSERT INTO dob_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ta ꞌInapwana ꞌebweuna ꞌediyega ꞌieonena, ꞌigwae, ‘Gosiyagu, nigeya wate yaloina gesi ꞌemuya, manuna ꞌida gimiloina ꞌaene kina ꞌebweuna namo ꞌuꞌewa. ");
INSERT INTO dob_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ꞌImu kina gete ꞌuꞌewa be ꞌutatauya. Ta ꞌaboꞌagu ꞌigu loina ꞌaene tomota tomai auwau ꞌadi maisa yaꞌebwaꞌedi ꞌoyo nadigega ꞌamu maisa. ");
INSERT INTO dob_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Maisa gete ꞌaboꞌagu ꞌigu ꞌebeloina. Geyaꞌabo ꞌomi waloiloina. Geyaꞌabo ꞌigu oboboma tomota ꞌediya manuna waeꞌipiꞌipi.’ ");
INSERT INTO dob_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ꞌEnega taudi simulimuliya maꞌetamo sida nugana ta taudi sinuganugana maꞌetamo simuliya.” ");
INSERT INTO dob_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ꞌEtamo Yesu Yelusalema manuna ꞌituꞌetuꞌe ga ꞌina tononoyao site tuwelo ꞌiꞌauꞌewedi ꞌeda tupitupinaya ga taudimo, ta ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ꞌigwae, “Gete tuga tatuꞌetuꞌe Yelusalema. ꞌAboꞌagu Tomota Natuna ta ꞌagu tosipupu nina ꞌida telesipupuyegu totaliyao sinabwadi be loina ꞌana toeꞌitao ꞌediya be ꞌigu mwawasa manuna sida loina, ");
INSERT INTO dob_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","be muliyega sida ꞌebwayaegu taudi nigeya me Yudia ꞌediya be sida tuyeyegu be balaeyega sisapigu, be kelose ꞌenaya situtu epaꞌiyegu, be ꞌasiyata ꞌetonina ꞌenaya Yaubada ꞌida gietoolo limagu.” ");
INSERT INTO dob_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Muliyega Sebedi mwanena manatunao simai ga sinadina Yesu ꞌenaya ꞌiꞌaetulasaya ta ꞌisida ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ga Yesu ꞌigwae, “Toꞌase nuwanuwayo?” Ta waine nina ꞌigwae, “Nuwanuwagu be natugwao ꞌediya ꞌuda tagwala be ꞌabo tuta nina ꞌuetoloina, sawesawenaya be selabemuya sida miyatowa, ꞌebweuna ꞌataimuya ta ꞌebweuna gegeumimuya.” ");
INSERT INTO dob_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ꞌEnega Yesu tai nidi ꞌieonedi, “ꞌOmi ꞌimi sida gete ꞌana mwalatoi nigeya wamwalamwalatoni. Mwaꞌadega, ꞌelouya keigana ꞌenega yanunuma kapekapeyana be ꞌomi wate ꞌenega wanunuma?” Ta sigwae, “Sawesawemaya.” ");
INSERT INTO dob_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ta Yesu ꞌigwae, “Onaꞌaiꞌaila, keiga nina ꞌenega yanunuma ꞌomi wate ꞌenega wanunuma, ta esi nigeya sawesaweguya be yaesinuwa yaisigedi maꞌetamo ꞌigu etoloina ꞌenaya ꞌataiguya be gegeumiguya sida miyatowa, manuna gete Tamagu tauna saꞌi ꞌina ꞌebeloina be ꞌiesinuwa.” ");
INSERT INTO dob_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ta tononoyao site sanau Yemesa be Yoni ꞌidi sida sinonona ga sigamwasowaledi. ");
INSERT INTO dob_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ꞌEnega Yesu maiboꞌadi ꞌibwau egogonedima ga ꞌieonedi, “ꞌOmi wamwalatonina ꞌaene ꞌinapwanao baleꞌuya ꞌidi tomotaiyao siloiloina paꞌaledi, ");
INSERT INTO dob_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ta ꞌomi geyaꞌabo wate nadigega taudi waguiguinuwaꞌesa. Ta ꞌeguma yaita ꞌoyo nuwanuwayo be ꞌemiyega ꞌuetoloina ꞌilobweneyo be gosemwao manudi ꞌuda etoguinuwa. ");
INSERT INTO dob_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","“Ta wate ꞌeguma yaita ꞌoyo nuwanuwayo be ꞌemiyega ꞌuetoanugana ꞌilobweneyo be gosemwao manudi ꞌuda etopaisewa. ");
INSERT INTO dob_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wate nadigega ꞌaboꞌagu Tomota Natuna yamai baleꞌuya nigeya ꞌaene tomota manugu siguinuwa, ta esi sabi guinuwa tomota manudi, ta wate yatagwalegu be yamwamwawasa tomota maiboꞌami ꞌami etoliꞌama manuna.” ");
INSERT INTO dob_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ꞌEnega Yeliko sipilisinena ta boda sinabwana Yesu simuliyena. ");
INSERT INTO dob_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ta tomata kebokebo siteluwa ꞌeda tupitupinaya simiyatowaya Yesu ꞌina sakowasi alena sinonona, ꞌenega Yesu ꞌena sibwau, “Debida tubuna ye, ꞌuda ꞌatenuwa ꞌoleꞌoleyema.” ");
INSERT INTO dob_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ta pwalu siteluwa nidi ꞌenadi sinonona ga siꞌetobodedi, sigwae, “Walosaꞌu! Tuwa bwau!” Ta ꞌenega siteluwa nidi sibwau toitoila, sigwae, “ꞌInapwana, Debida tubuna ye, ꞌuda ꞌatenuwa ꞌoleꞌoleyema.” ");
INSERT INTO dob_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ꞌEnega Yesu ꞌitoolo ga ꞌibwauyedima ta ꞌigwae, “Toꞌase nuwanuwami be manumi yada guinuwe?” ");
INSERT INTO dob_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta sigwae, “ꞌInapwana, kapekapeyana be matama ꞌuda gieꞌesasedi?” ");
INSERT INTO dob_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ta Yesu ꞌiꞌatenuwa ꞌoleꞌeleyedi ga matadi ꞌigitoodi, ga siꞌesasedi, ta ꞌenega Yesu wate simuliyena. ");
INSERT INTO dob_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ꞌEnega situꞌetuꞌe Yelusalema manuna ga Betipegi selabenaya silogelogedo, nate ꞌoya Olibe ꞌagalaunaya, ta Yelusalema nuganidiya tupwana ꞌedasola. ꞌEnega Yesu ꞌina tononoyao ꞌeluwa ꞌietune nuganedi, ");
INSERT INTO dob_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ꞌigwae, “Watauya ꞌasa gote matamiya ꞌenaya be yobai ase waꞌitaloba, kaiwe ꞌena silosipwena, ta natuna meꞌolotona maꞌiyana simiyami, waliꞌamidi be wameꞌedi ꞌeguya. ");
INSERT INTO dob_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ꞌEguma yaita ꞌienaidemi ꞌimi guinuwa nina manuna, wagwae, ‘ꞌInapwana nuwanuwana,’ be ꞌenega ꞌitagwaledi ꞌemiya.” ");
INSERT INTO dob_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yage getedi ꞌiapwesa manuna lowa palopita ꞌigimisimanena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sayoni tomoteninao waeonadi, wagwae, ‘Waꞌita ꞌimi toloina sinabwana ꞌimeemai ꞌemiya, Tauna tonuwamwaꞌuta sana, ta ase ꞌigeluna, Ta ase nina meꞌolotona ta mwaneyauna.’” ");
INSERT INTO dob_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ꞌEnega Yesu ꞌina ona ꞌina tonono nidi simuliyena ga sitauya, ");
INSERT INTO dob_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ga ase manatuna silobedi ga simeꞌedi, ga ꞌadi ꞌoamao ase gwaudiya siloesodi, ta Yesu ꞌigelutuꞌe. ");
INSERT INTO dob_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ta boda yaudi wate ꞌadi ꞌoamao ꞌedaya siesodi, ta ꞌaidi kaiwe nalidi mayawadi siguledi, ꞌeda ꞌana eiyala manuna. ");
INSERT INTO dob_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ta ꞌaina boda Yesu sianuganena, ta ꞌaina boda siamuliya, ga maiboꞌadi silotuputupu ta sibwaubwau, sigwae, “Kamatoki Debida tubuna ye, ꞌInapwana ꞌana esanega ꞌumai sabi ꞌetoseyema, ꞌenega tauna Toloetana sana ꞌatuputupu.” ");
INSERT INTO dob_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ꞌEnega Yelusalema ꞌena silugu ga tomota maiboꞌadi ꞌigieloniuyedi, ta sigwae, “Yaita sana gote?” ");
INSERT INTO dob_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ta ꞌana ꞌoayabuyao tomota nidi ꞌidi ona sieꞌisena, sigwae, “Gete palopita, goma Nasaleta, ꞌana esana Yesu, ta Galili ꞌina ꞌebeloina ꞌenega ꞌimai.” ");
INSERT INTO dob_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ꞌEnega Yesu Yaubada ꞌina Anuwa Tabu ꞌena ꞌilugu ga togimwaneyao be toegimwaneyao maiboꞌadi ꞌipaꞌi apwesedi, ta mani ꞌana toesaꞌu gelasao ꞌidi tebeli ꞌiꞌaubuiyedi, ta bunebune ꞌadi toegimwaneyao ꞌidi ꞌebemiya wate ꞌiꞌaubuiyedi, ");
INSERT INTO dob_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ta ꞌieonedi, ꞌigwae, “Buki Tabu ꞌenaya Yaubada ꞌina ona siꞌetoladina, ꞌigwae, ‘ꞌIgu anuwa sida eese anuwa ꞌebe sidasida,’ ta ꞌomi wagibunina ga ꞌaene ꞌimi ꞌebe ꞌipwala.” ");
INSERT INTO dob_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ꞌEnega tomata kebokebo be tolopegoi Yesu ꞌena simai Anuwa Tabu solanaya ga maiboꞌadi ꞌigieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ta totaliya sinabwadi be loina ꞌana toeꞌitao Yesu ꞌina guinuwa waiwaidi siꞌitedi, ta wate gogama sinonodi Anuwa Tabu solanaya sibwaubwau, sigwaegwae, “Debida tubuna ye, ꞌuꞌetoseyema.” ");
INSERT INTO dob_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ꞌEnega ꞌinapwanao nidi Yesu sigamwasowalena ta sigwae, “Gogama getedi ꞌidi ona ꞌunononaya?” Ta Yesu ꞌigwae, “O, niꞌatu yanonona. Ta mwaꞌadega Buki Tabu ꞌena wasawena, ꞌigwae, ‘Gogama gidalidi ꞌawadiyega ꞌamu tupu ꞌaiꞌaila ꞌuloba.’” ");
INSERT INTO dob_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ꞌEnega Yesu ꞌipilisinedi ga Yelusalemega ꞌiapwesa ta Betani ꞌena ꞌilugu ga nada ꞌiꞌeno. ");
INSERT INTO dob_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tomwa ꞌiulisina ga Yesu ꞌitoolo ga ꞌiilaila limana Yelusalema, ga ma ꞌana botana, ");
INSERT INTO dob_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ta ꞌedaya kaiwe ꞌana ꞌita ꞌatuwa damaya ꞌiꞌita lobena, ꞌenega ꞌinao selabenaya ta nigeya ꞌebweu uwana ꞌiꞌitaꞌita loba, manuna yawa daisinamo. ꞌEnega Yesu kaiwe nina ꞌibaꞌena, ꞌigwae, “Maꞌetamo geyaꞌabo wate ꞌuuwauwa limana.” Ta ꞌenega kaiwe nina ꞌiꞌoapelu manini. ");
INSERT INTO dob_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ta Yesu ꞌina tononoyao siꞌitena ga nuwadi ꞌiowana, ta sigwae, “Mwaꞌadega ga ꞌenega kaiwe nina ꞌiꞌoapelu manini?” ");
INSERT INTO dob_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta Yesu ꞌieonedi, “Yaona ꞌaiꞌaila ꞌemiya, ꞌeguma ma imi emisa ta nigeya ma imi enuwanaluwa, yage gete kaiwe ꞌena yaguinuwenaya ꞌomi wate nadigega wada guinuwaꞌesa, be ꞌabo ꞌoya gote waloine be wagwae, ‘ꞌUmiya dolo olaya’, ꞌida guinuwa nadigega. ");
INSERT INTO dob_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Be ꞌabo ma imi emisa Yaubada ꞌena wasisida, maꞌetamo waloloba.” ");
INSERT INTO dob_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ꞌEnega Anuwa Tabu ꞌena ꞌilugu ga ꞌieꞌieꞌita, ta totaliyao sinabwadi be ꞌinapwanao simai ga Yesu sienaidena, sigwae, “Tai, yaita ꞌina loinega ga gete nadigega ꞌuguiguinuwaꞌesa?” ");
INSERT INTO dob_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ta Yesu ꞌieonedi, ꞌigwae, “Nugana yagimi enaida ꞌemiya, be ꞌeguma waeꞌisa, ꞌaboꞌagu wate yaeonami ꞌagu loina manuna. ");
INSERT INTO dob_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ꞌIgu enaida gete: Yaita ꞌina loinega ga Yoni togiebapitaiso ꞌiguiguinuwa? Yaubada, nai ꞌebweu tomota?” ꞌEnega taudimo ꞌediya siegewagewana, sigwae, “ꞌIna ona mwaꞌadega taeꞌisaꞌese? Manuna ꞌabo tagwae, ‘Yaubada ꞌenega’ ꞌiabe ꞌieona limada be ꞌigwae, ‘Ta! Toꞌase sana manuna ga Yoni nigeya waemiemise?’ ");
INSERT INTO dob_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ta ꞌeguma tagwae, ‘Tomota ꞌenega’, nate be boda sigamwasowaleda manuna maiboꞌadi Yoni siꞌawa palopitaena.” ");
INSERT INTO dob_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ꞌEnega Yesu ꞌina enaida nigeya sieꞌieꞌisa ꞌaiꞌaili, ta esi sigwae, “Nigeya ꞌamwalamwalatoni.” Ta Yesu wate ꞌieonedi, ꞌigwae, “ꞌAboꞌagu geyaꞌabo wate ꞌemiya yasimasimana apwesa yaita ꞌina loinega ga gete nadigega yaguiguinuwa.” ");
INSERT INTO dob_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ꞌEnega Yesu wate ꞌieonedi, “Mwaꞌadega ꞌeguma tai natunao meꞌolotodi ꞌeluwa be tamadina tomatuwa ꞌenaya ꞌiona, ꞌigwae, ‘Natugu batuwa ꞌutatauya bagulaya be ꞌupaisewa,’ ");
INSERT INTO dob_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ga ꞌiguitoyasa, ta muliyega ꞌinuwaꞌebuni ga ꞌitauya ga ꞌipaisewa. ");
INSERT INTO dob_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tai nina natuna megwamana wate nadigega ꞌieonena, ꞌigwae, ‘Natugu batuwa ꞌutatauya bagulaya be ꞌupaisewa’, ga natunana ꞌigwae, ‘O, boboꞌana, ꞌiabe yatatauya’, ta esi nigeya ꞌida tauya. ");
INSERT INTO dob_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ꞌEnega siteluwa nidi getedi ꞌediyega yaita tamana ꞌina ona ꞌimuliyena?” Ta sigwae, “Tomatuwa.” ꞌEnega Yesu ꞌieonedi, ꞌigwae, “O, onaꞌaiꞌaila totoꞌumalidi taudi takisi ꞌana toꞌewao be tosogalao wate nadigega sida gimilugu Yaubada ꞌina ꞌebeloina ꞌenaya, ta ꞌomi mulidiyega. ");
INSERT INTO dob_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Manuna lowa Yoni ꞌeda palupaluna ꞌieꞌitemi ta ꞌomi nigeya waemiemise, ta esi takisi ꞌana toꞌewao siemisena. Ta matamiyega wate waꞌitena sinuwanuwa ꞌebuni, ta ꞌomi saꞌi nigeya wada nuwaꞌebuni nai wada emisena, aga?” ");
INSERT INTO dob_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ta Yesu wate ꞌieonedi, ꞌigwae, “ꞌEbweu onasemalimali wate wada nono tobagula manuna. Tobagula nina oine daisinamo ꞌiasodi ꞌina bagulaya ta ꞌali ꞌiguinuwena ta oine ꞌana ꞌebe bibi wate ꞌiguinuwena, ga anuwa bagula solanaya ꞌiꞌabina, ꞌenega ꞌina toguinuwao ꞌiloinedi be siꞌitaꞌiꞌisi, ta tauna ꞌitauya mali esenaya. ");
INSERT INTO dob_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Ta sesoi ꞌana tutaya ꞌinapwana nina ꞌina ꞌaliꞌeiyao ꞌaina wate ꞌietune iledi ꞌina bagulaya oine uwana sabi ꞌewadi bagula ꞌana toꞌitaꞌiꞌitao ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ga tuta nina sitauyaya toꞌitaꞌiꞌitao ꞌaliꞌeiyao nidi sigiyaidi ga ꞌebweuna sisapina ta ꞌeluwena siloemwawasina ta ꞌetonina gulewega siloibweibwena. ");
INSERT INTO dob_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Muliyega tobagula nina ꞌaina wate ꞌina ꞌaliꞌeiyao tupwana yaudi ꞌietunedi, ta taudi wate nadigega siguinuwaꞌesedi. ");
INSERT INTO dob_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ta ꞌebe losalowa ꞌenaya natuna meꞌolotona ꞌietunena ꞌediya ta ꞌigwae, ‘Tauna sana natugu ꞌenega sida ꞌamayabe.’ ");
INSERT INTO dob_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ta natunana ꞌiapwesa ꞌediya ga toꞌitaꞌiꞌitao nidi taudimo ꞌediya sigwae, ‘Gosemao, tai gote ꞌimeema, tauna ꞌinapwana nina natuna ꞌebweuna namo tuga, ꞌenega batuwa nina taloemwawasi be ꞌaboꞌada bagula taloine.’ ");
INSERT INTO dob_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ꞌEnega sigiyaina ga bagulega siula apwesena ꞌetauluya ga siloemwawasina. ");
INSERT INTO dob_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ꞌEnega ꞌabo tuta nina tonibagula ꞌiilama, toꞌase ꞌina toꞌitaꞌiꞌitao nidi ꞌediya ꞌida guinuwe?” ");
INSERT INTO dob_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta sigwae, “Toloemwawasa nidi ꞌiabe ꞌigietoꞌumali ꞌaiꞌailedi, be bagula ꞌida tagwale toꞌitaꞌiꞌtao boboꞌadi ꞌediya, be taudi bagula uwana sida ꞌebwaya tonibagula nina ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ꞌEnega Yesu wate onasemalimali Buki Tabu ꞌenega ꞌisimanena, ꞌigwae, “Nai Buki Tabu ꞌina simana nigeya wanuwanuwaꞌiꞌisi, ꞌigwae, ‘ꞌOla nina lowa toꞌabi anuwa siguitoyasena, ta gete tugai niꞌatu sietoolona be ꞌieꞌola nugana, be ꞌola maiboꞌadi ꞌiloinedi. Nate ꞌInapwana ꞌina guinuwa ꞌebe nuwaowana ꞌedaya.’ ");
INSERT INTO dob_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ꞌEnega yaeonami ꞌaene Yaubada ꞌina loina ꞌemiyega ꞌida ꞌewayaule, ta ꞌida ꞌebwaya mali boda ꞌediya, be taudi ꞌediyega uwana boboꞌana ꞌida apwesa. ");
INSERT INTO dob_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ꞌEguma yaita ꞌibebeꞌu ꞌola gete ꞌena, ꞌiabe luluna ꞌilasadi, ta ꞌeguma ꞌola nina ꞌibebeꞌu ꞌebweu yaita etaninaya ꞌiabe oona ꞌiꞌauideide namo.” ");
INSERT INTO dob_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yesu ꞌina onasemalimali getedi totaliyao sinabwadi be Palisiyao sinonodi ga simwalatonina ꞌaene taudi manudi ꞌionaona semalimali, ");
INSERT INTO dob_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ꞌenega ꞌaina ꞌedaꞌeda siꞌebesena be ꞌaene Yesu sida giyai, ta esi nigeya kapekapeyana be sigiyai, manuna pwalu ꞌediya simatauta, manuna boda nidi Yesu siꞌawa palopitaena. ");
INSERT INTO dob_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ꞌEbweu wate onasemalimali Yesu ꞌiꞌebwaꞌedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yaubada ꞌina loina ꞌatuwa kini ꞌebweuna ꞌemasula ꞌiguinuwena natuna meꞌolotona ꞌina ai manuna. ");
INSERT INTO dob_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ꞌEnega ꞌina toguinuwao ꞌietunedi be yaisigedi taudi ꞌiemataluwediya sida bwauyedima ꞌemasula ꞌenaya, ga sitauya sabi bwauyedima ta tomotai nidi kini ꞌina bwau siguitoyasena. ");
INSERT INTO dob_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“ꞌEnega ꞌaina wate ꞌina toguinuwao ꞌietunedi be taudi ꞌiemataluwediya sida eonadi wate ꞌaene ‘ꞌInapwana ꞌina ꞌemasula niꞌatu ꞌigibubuna. ꞌIna bulumakau sinabwadi ta ꞌina bulumakau mwaneyaudi niꞌatu ꞌiunudi be masula maiboꞌana ꞌigibubuna. Wada ma be tatatauya natunana ꞌina ai masulina wada ꞌani.’ ");
INSERT INTO dob_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ta taudi nigeya simeema, ꞌenega ꞌaidi sipili kwaiya ga mali sena be mali sena ꞌediya sitauya. ꞌEbweu tai ꞌina bagulaya ꞌitauya, ꞌebweu tai ꞌina paisewa ꞌena ꞌitauya, ");
INSERT INTO dob_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ta ꞌaidi wate ꞌinapwana ꞌina toguinuwao sigiyaidi ga sigie omayamayaedi ta siloemwawasidi. ");
INSERT INTO dob_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“ꞌEnega kini nina ꞌigamwasowala ꞌaiꞌaila ga ꞌina tolosaiyao ꞌietunedi ga toloemwawasa nidi simutudi ta ꞌidi ꞌasa sigabuna. ");
INSERT INTO dob_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ta kini nina ꞌina toguinuwao ꞌediya ꞌigwae, ‘Ai masulina niꞌatu gibugibubuna ta esi taudi yaemataluwediya nigeya sawesawenaya be simama. ");
INSERT INTO dob_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ꞌEnega ꞌeda ꞌediya wasakowasi be yaisigedi walobadi waꞌauꞌewedima be ai masulina siꞌaꞌani.’ ");
INSERT INTO dob_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ꞌEnega siapwesa ꞌedaya ga tomota yauyaudi siegogonedima, ꞌaidi totoꞌumalidi be ꞌaidi toboboꞌadi ga ꞌenega ai ꞌana anuwa nina siloemaena. ");
INSERT INTO dob_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Tuta nina kini ꞌimai ꞌowagao sabi ꞌitadi ga tai ꞌebweuna ꞌiꞌita lobena, tauna nigeya ai ꞌoamana ꞌiꞌoteꞌote, ");
INSERT INTO dob_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ꞌenega ꞌienaidena, ꞌigwae, ‘Gosiyagu, mwaꞌadega ai ꞌoamana nigeya ꞌuꞌoteꞌote, ta toꞌesega ꞌuluguma?’ Ta tai nina nigeya sawesawenaya be enaida gete ꞌieꞌisa. ");
INSERT INTO dob_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ꞌEnega kini nina ꞌina toguinuwao ꞌieonedi, ‘Tai gote wagiyai be nimana be ꞌaena wayonidi be waula apwese sena guguyoi ꞌenaya, be gote ꞌena tomota sidedoi ta siesalaꞌiꞌita ꞌelouya ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Manuna tomota yaudi Yaubada ꞌina emataluwa silobena, ta puꞌepuꞌedimo ꞌiesinuwedi.” ");
INSERT INTO dob_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ta Palisiyao taudimo sideli egogonama ga siloina mwaꞌadega be enaidega sikaboe be Yesu ꞌina loegesi siloba. ");
INSERT INTO dob_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ꞌEnega loina silobena, ta ꞌadi tomuliyayao be Elodi ꞌina bodao maꞌediyao sietunedi Yesu ꞌena ga sigwae, “ꞌInapwana niꞌatu ꞌamwalatonimu ꞌaene ꞌoyo toeꞌita ꞌaiꞌaila be Yaubada ꞌina nuwanuwa ꞌueꞌita ꞌaiꞌaila, ta wate tomota ꞌidi waiwai manuna nigeya ꞌumatamatauta, ta tuga ona ꞌaiꞌaila ꞌusimana leleleya tomota maiboꞌadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ꞌEnega gete tuga ꞌuda eonama, mwaꞌadega sawesawenaya be Kini Sisa manuna takisi tasaꞌu, nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ta Yesu ꞌidi nuwanuwa toꞌumalina ꞌimwalatonina, ꞌenega ꞌiona, igwae, “ꞌOmi tokabo! Toꞌase manuna watootoogu? ");
INSERT INTO dob_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ta baga mani nina takisi manuna waeꞌitagu.” ꞌEnega mani ꞌebweuna siꞌebwaꞌena. ");
INSERT INTO dob_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ga Yesu ꞌieonedi, ꞌigwae, “Wada eonagu, mani gete ꞌena yaita ꞌana maꞌamaꞌayau ta ꞌana esana?” ");
INSERT INTO dob_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta sigwae, “Kini Sisa.” ꞌEnega Yesu ꞌieonedi, “O, nadigega. ꞌEnega ꞌeguma Kini ꞌina yage waꞌebwaya Kini ꞌenaya, ta ꞌeguma Yaubada ꞌina yage Yaubada waꞌebwaꞌe.” ");
INSERT INTO dob_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yesu ꞌina ona sinasinapu wawasae sinonona ga nigeya ꞌidi ꞌebe onamo, ꞌenega sipilisinena ga sitauya. ");
INSERT INTO dob_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gote ꞌasiyata nina ꞌenaya ꞌaina Sadusiyao, taudi nigeya siemiemisa tomwawasa ꞌidi toololimana manuna, simai ga Yesu ꞌena sienaida, ");
INSERT INTO dob_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","sigwae, “ꞌInapwana, Mosese ꞌina loina ꞌigwae, ‘ꞌEguma tai mamwanena ta nigeya natudimo be tai nina ꞌimwamwawasa, tai nina tasina kwabulinana maꞌiyana sida ai, be ꞌenega ꞌabo waine ꞌienatuna, natunao tokwaiya nina ꞌana lopaꞌeluyao.’ ");
INSERT INTO dob_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ꞌEbweu tai matasinao sikisi maꞌemao ꞌamiyami, ta tai nina ꞌiai ga ꞌimwawasa, ta nigeya natunamo, ta tokwaiya nina tasina selabenega kwabulina maꞌiyana siai, ");
INSERT INTO dob_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ta tasinana wate ꞌimwawasa, ta tauna wate nigeya natunamo. Ta nadigega tuga tasinao maiboꞌadi kwabula nina siaiai, ");
INSERT INTO dob_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ta mulidiyega waine wate ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ꞌEnega toololimana ꞌana tutaya waine nina to tai batu mwaneꞌaiꞌailina? Manuna maiboꞌadi niꞌatu siaina.” ");
INSERT INTO dob_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ta Yesu enaida gete ꞌieꞌisena, ꞌigwae, “Gete ꞌimi loegesi, manuna Buki Tabu nigeya wamwalamwalatoni, ta wate Yaubada ꞌina waiwai nigeya wamwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Toololimana ꞌana tutaya tomota geyaꞌabo siaiai ta esi ꞌidi miya aniloseyao galewaya nadigega. ");
INSERT INTO dob_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ta Yaubada ꞌina ona ꞌemiya toololimana manuna Buki Tabu ꞌena ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ꞌAboꞌagu Ebelaamo ꞌina Yaubada ta Aisake ꞌina Yaubada ta Yekobe ꞌina Yaubada.’ Yaubada nigeya tomota mwawamwawasidi ꞌidi Yaubada, ta esi tomota mayawasidi ꞌidi Yaubada, ꞌenega ꞌinapwanao nidi mayawasidi gete tuga simiyami.” ");
INSERT INTO dob_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesu ꞌina ona gete tomota yaudi sinonona ma idi gwausowala ꞌina eꞌita waiwaina manuna. ");
INSERT INTO dob_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ꞌEnega Palisiyao niꞌatu sinonona ꞌaene Yesu Sadusiyao ꞌidi enaida ꞌieꞌisena ta nigeya ꞌebweu wate ꞌidi ꞌebe onamo, ꞌenega Palisiyao nidi Yesu ꞌenaya simai, ");
INSERT INTO dob_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ga ꞌediyega ꞌebweu loina ꞌana tosinasinapu Yesu ꞌena ꞌienaida sabi toona, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Toeꞌita, loina maiboꞌadi ꞌediyega to loina sinabwana?” ");
INSERT INTO dob_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ta Yesu ꞌigwae, “ꞌImu ꞌInapwana Yaubada ꞌuda obobome ꞌateyo be yaluyaluwayo be ꞌimu nuwanuwa maiboꞌadi ꞌediyega.’ ");
INSERT INTO dob_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gete gimiloina ta sinabwana. ");
INSERT INTO dob_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ta ꞌebweu wate loina sinabwana gete nadigega ꞌigwae, ‘Gosemwao ꞌuda obobomedi, nadigega tauyo ꞌamu oboboma.’ ");
INSERT INTO dob_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“Loina ꞌeluwa getedi, loina maiboꞌadi be palopitao ꞌidi ona maiboꞌadi ꞌadi ꞌautui.” ");
INSERT INTO dob_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tuta nina Palisiyao sideli egogonama ga Yesu ꞌieonedi, ꞌigwae, “Mwaꞌadega Toꞌetoseyana nina Keliso, yaita ꞌina susuyega ꞌiapwesa?” ");
INSERT INTO dob_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ta sigwae, “Debida.” ");
INSERT INTO dob_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ꞌEnega Yesu ꞌigwae, “Mwaꞌadega ga ꞌenega lowa Yaluyaluwa Tabuna Debida ꞌigiesinapuna ga Debida Toꞌetoseyana nina ꞌiꞌawa ꞌinapwanaena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yaubada ꞌiona ꞌigu ꞌInapwana ꞌenaya, ꞌigwae: ꞌAtaiguya ꞌumiyatowa be ꞌana laba ꞌamu talauwalao yasaꞌu mwaꞌutedi ꞌaeyo ꞌubuninaya.’ ");
INSERT INTO dob_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ꞌEguma Debida ꞌina ꞌinapwana Toꞌetoseyana nina, mwaꞌadega sana ga Debida ꞌina susuyega muliyega Toꞌetoseyana ꞌiapwesama?” ");
INSERT INTO dob_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yesu ꞌina enaida gete nigeya ꞌebweu wate yaita sawesawenaya be ꞌieꞌisa, ga tuta muliyega Yesu simatautena ꞌenega, nigeya ꞌebweu yaita ꞌitootoo be ꞌienaida limana Yesu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ꞌEnega Yesu boda be ꞌina tononoyao ꞌediya ꞌiona, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Lowaenei Mosese me Isileli ꞌiloiloinedi ta batuwa loina ꞌana toeꞌitao be Palisiyao nadigega siloiloinaꞌesemi. ");
INSERT INTO dob_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ꞌEnega toꞌase nadigega sieꞌitami wada muliyedi, ta esi ꞌidi guinuwao geyaꞌabo waetoetotowanedi, manuna taudi sieꞌitamo ta nigeya ꞌidi eꞌita nidi sida guinuwedi. ");
INSERT INTO dob_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","“Taudi ꞌaaꞌaala mwaudi tomota siꞌebwaꞌebwaꞌedi, ta taudi nigeya saꞌi sida tagwala be ꞌaaꞌaala nidi ꞌediyega sida lemedi. ");
INSERT INTO dob_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“ꞌIdi guinuwa maiboꞌana siguiguinuwedi be ꞌaene tomota siꞌitadi be situpudi, nate onao Buki Tabu ꞌenega ꞌetoꞌetoladidi debadiya be nimadiya sigiepaꞌiyedi, ta ꞌadi ꞌoamao duduladi siꞌoteꞌotedi, ");
INSERT INTO dob_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ta sagali ꞌadi tutaya nuwanuwadi be bwaimaya sida miyatowa, be wate anuwa tapwalolo ꞌediya ꞌebemiya boboꞌadi nuwanuwadi, ");
INSERT INTO dob_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","be ꞌeguma ꞌebe gimwane ꞌena sitatauya, nuwanuwadi be tomota yaudi sida lokagutokiyedi nai sida ꞌawa toeꞌitaedi. ");
INSERT INTO dob_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ta ꞌomi ꞌetamo geyaꞌabo tomota siꞌawaꞌawa toeꞌitaemi, manuna ꞌimi toeꞌita ꞌebweuna namo, ta maiboꞌami waeleleleya. ");
INSERT INTO dob_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","“Wate geyaꞌabo ꞌebweu yaita baleꞌuya ꞌena waꞌawaꞌawa tamana, manuna Tamami ꞌebweuna namo galewaya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Geyaꞌabo wate tomota siꞌawaꞌawa ꞌinapwanaemi, manuna Keliso tauna tebweunamo ꞌimi ꞌInapwana. ");
INSERT INTO dob_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ta ꞌabo yaita ꞌemiyega ꞌietoanugana ꞌida eꞌaliꞌei ꞌemiya; ");
INSERT INTO dob_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","be ꞌabo yaita ꞌemiyega ꞌinuwatuꞌe ꞌiabe ꞌiebusi, ta ꞌabo yaita ꞌinuwamwaꞌuta ꞌiabe ꞌitutuꞌe. ");
INSERT INTO dob_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ꞌOmi loina ꞌana toeꞌitao be Palisiyao nuwaꞌoleꞌolemi saꞌi, manuna ꞌimi kaboega tomota waꞌetobodedi be ꞌenega Yaubada ꞌina ꞌebeloina ꞌena geyaꞌabo silugulugu. ꞌOmi geyaꞌabo walugulugu, ta tomota wate yaisigedi nuwanuwadi be silulugu waegagaledi. ");
INSERT INTO dob_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(-) ");
INSERT INTO dob_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ꞌOmi loina ꞌana toeꞌitao be Palisiyao nuwaꞌoleꞌolemi saꞌi, manuna ꞌebweu wate gete ꞌimi loegesi. Tuta yauna waꞌadaꞌadau sakowasi ꞌasa yaudi ꞌediya be ꞌaene ꞌami tomuliya ꞌebweu wada loba, be muliyega tomotai nina waeꞌita be nadigega ꞌomi waguiguinuwa Seitani ꞌenaya, tauna nadigega ꞌida guinuwa, ta ꞌida guinuwa wawasae. ");
INSERT INTO dob_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nuwaꞌoleꞌolemi saꞌi, manuna ꞌomi toanuganao matakebokebomi, wagwae, ‘ꞌEguma yaita Anuwa Tabu ꞌana esanega ꞌisawa tamatamana nate nigeya ꞌebweu toꞌase, ta esi ꞌeguma yaita goula nidi Anuwa Tabu solanaya ꞌediyega ꞌisawa tamatamana nate yage sinabwana, ꞌenega ꞌilobwenena be yage nina ꞌida guinuwe.’ ");
INSERT INTO dob_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Onaꞌaiꞌaila, ꞌomi uwauwami ta matakebokebomi! Toꞌase ꞌiloetana sana? Anuwa Tabu ꞌana goula? nai Anuwa Tabu? tauna ꞌenega goula ꞌietabuna. ");
INSERT INTO dob_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ta wate wagwae ꞌaene ‘ꞌEguma yaita ꞌebe taliya ꞌana esanega ꞌisawa tamatamana, nate nigeya ꞌebweu toꞌase, ta esi ꞌeguma ꞌisawa tamatamana ꞌebwayadaita nina ꞌebe taliya ꞌenaya nate yage sinabwana, ꞌenega toꞌase ꞌiona upaupaena ꞌilobwenena be ꞌida guinuwe.’ ");
INSERT INTO dob_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ꞌOmi uwauwami! Toꞌase sinabwana? ꞌEbwayadaita nina? nai ꞌebe taliya? tauna ꞌenega ꞌebwayadaita ꞌigietabuna. ");
INSERT INTO dob_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“ꞌEnega ꞌabo yaita ꞌebe taliya ꞌana esanega ꞌisawa tamatamana, tauna wate yage maiboꞌana ꞌebe taliya ꞌenaya ꞌediyega ꞌisawa tamatamana. ");
INSERT INTO dob_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ta wate ꞌabo yaita Anuwa Tabu ꞌana esanega ꞌisawa tamatamana, tauna wate Anuwa Tabu ꞌana tomiya ꞌana esanega ꞌisawa tamatamana. ");
INSERT INTO dob_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ta ꞌabo yaita galewa ꞌana esanega ꞌisawa tamatamana, tauna Yaubada be wate ꞌina ꞌebemiya ꞌadi esanega ꞌisawa tamatamana. ");
INSERT INTO dob_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ꞌOmi loina ꞌana toeꞌitao be Palisiyao nuwaꞌoleꞌolemi saꞌi, manuna ꞌomi tokabo. Onaꞌaiꞌaila ꞌimi ꞌebwayadaita boboꞌana, manuna ꞌimi ꞌebwayadaitao nidi ꞌimi yage maiboꞌadi ꞌediyega, gwegwe sinabwadi ta wate yage gidalidi nadigega mali pai be mali pai ꞌediyega, ta esi loina ꞌetoi sinabwadi wanuwa pupuledi, nate bubuna palupaluna be nuwaꞌoleꞌole be emisa. ꞌIlobwenemi be yage gete sinabwadi wada guinuwedi, ta wate geyaꞌabo yage gidalidi wanuwanuwa pupuledi. ");
INSERT INTO dob_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ta ꞌomi toanuganao matakebokebomi, ꞌami kwayai ꞌenega manumanuwa waꞌewaꞌewa yauledi, ta esi yobai sinabwana, kameli ꞌatuwa, watonetonedi. ");
INSERT INTO dob_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ꞌOmi loina ꞌana toeꞌitao be Palisiyao nuwaꞌoleꞌolemi saꞌi, manuna ꞌimi kaboega keiga be gaeba apwesaya wagieꞌesasedi ta esi soladi baibailidi, nate ꞌipwala be bubuna toꞌumalidi siloemaedi. ");
INSERT INTO dob_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ꞌOmi Palisiyao matakebokebomi, ꞌimi keiga be ꞌimi gaeba soladi wagieꞌesasa nuganedi, ta ꞌenega apwesaya wate siꞌesasadi. ");
INSERT INTO dob_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ꞌOmi loina ꞌana toeꞌitao be Palisiyao nuwaꞌoleꞌolemi manuna ꞌomi tokabo, ꞌatuwa nadigega ꞌaliꞌali wakewakekedi ta ꞌesasedi, etanaya ꞌadi ꞌita kausala wawasae, ta esi soladiya tomota luludi ta yage baibailidi simiyami. ");
INSERT INTO dob_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ꞌOmi ꞌami ꞌita tomota matadiya ꞌaene toanuganao boboꞌami, ta solamiya kabo be toꞌumalina yauna simiyami. ");
INSERT INTO dob_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ꞌOmi loina ꞌana toeꞌitao be Palisiyao nuwaꞌoleꞌolemi ta tokabo, manuna gimi palopitao ꞌadi ꞌaliꞌali ꞌediya ꞌadi ꞌebe nuwaꞌiꞌita waꞌabidi ta wate topalupaludi lowaenei ꞌadi ꞌebe nuwaꞌiꞌitao wagibubudi, ");
INSERT INTO dob_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ta wagwae, ‘ꞌEguma lowaenei tamiyami tubudao ꞌidi tutaya, geyaꞌabo talemelemedi palopitao ꞌadi loemwawasa manuna.’ ");
INSERT INTO dob_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ꞌImi ona gete ꞌenega wasimana ꞌaene palopitao ꞌadi toloemwawasao tubudiyao ꞌomi. ");
INSERT INTO dob_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ꞌEnega taudi ꞌidi guinuwa nidi ꞌiabe walosaloni. ");
INSERT INTO dob_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ꞌOmi mwata natunao, ta nigeya sawesawenaya be ꞌasagabugabu ꞌenega wadedena. ");
INSERT INTO dob_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ꞌEnega palopitao be tomwalatoiyao be loina ꞌana toeꞌitao yaetunediwa be ꞌenega ꞌaidi wada loemwawasidi, nai kelose ꞌediya wada tutu epaꞌiyedi, be ꞌaidi ꞌimi anuwa tapwalolo ꞌediya balaeyega wada unudi, be ꞌasa ꞌebweuna ꞌebweuna ꞌediyega wada paꞌidi. ");
INSERT INTO dob_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ta ꞌana ꞌebe losalowa ꞌenaya topalupaludi ꞌadi loemwawasa ꞌana eꞌisa maiboꞌana ꞌomi wada loba. Gimi tai Ebeli tauna topalupaluna siloemwawasina ga ꞌenega siloeloemwawasa ga ꞌana laba Balakaya natuna Sakalaya wate siloemwawasina Anuwa Tabu ta ꞌebe taliya gamwagamwanidiya. ");
INSERT INTO dob_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Onaꞌaiꞌaila, loemwawasa nidi maiboꞌadi ꞌadi eꞌisa ꞌepata getemi waloba. ");
INSERT INTO dob_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yelusalema ye! Mwaꞌadega ga palopitao ꞌuloemwawasidi ta wate Yaubada ꞌina toepilialealeyao gulewega ꞌuloibweibwedi. Tuta yauna nuwanuwagu be ꞌimu tomotaiyao yabwau egogonedima ꞌatuwa kakaleko natunao papenega ꞌiꞌaubodebodedi, ta saꞌi siguitoyasegu. ");
INSERT INTO dob_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ꞌEnega Yaubada ꞌiabe ꞌipilisineyo be ma imu toꞌumalina tuga ꞌuda miyami. ");
INSERT INTO dob_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ta yaeonayo ꞌaene geyaꞌabo wate ꞌuꞌitaꞌita limagu be ꞌana laba ꞌimu tomotaiyao sitatagwala ꞌeguya be sida gwae, ‘Tauna Yaubada ꞌana esanega ꞌimeemai tada tupu.’” ");
INSERT INTO dob_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ꞌEnega Yesu Anuwa Tabu selabenaya be ꞌipilisinei ta ꞌina tononoyao simai ga Anuwa Tabu ꞌana anuwao Yesu ꞌena sieꞌitena. ");
INSERT INTO dob_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ta Yesu ꞌigwae, “Anuwa nidi maiboꞌadi waꞌitaꞌitadi, yaonaꞌaiꞌaila maꞌetamo maiboꞌadi siligeya yauledi be geyaꞌabo wate ꞌebweu tupwa waꞌitaꞌita lima.” ");
INSERT INTO dob_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Muliyega ꞌitauya Olibe ꞌoyana ꞌena ga ꞌimiyatowaya, ta ꞌina tononoyao ꞌena simai ga taudimo simiyamiya ta ꞌenega sienaidena, sigwae, “ꞌInapwana, ꞌueonama to tuta ꞌena Anuwa Tabu nidi siligeidi, be ꞌimu tuta ilama, be tuta ꞌana ꞌebe losalowa manuna ꞌadi weꞌiweꞌiyaya ꞌueꞌitama be ꞌada mwalatoni.” ");
INSERT INTO dob_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Waꞌitaꞌiꞌisimi ꞌabona nai tomota ꞌaidi sikaboemi. ");
INSERT INTO dob_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Manuna maꞌetamo tomota yaudi ꞌagu esanega simama be ꞌaene sianugana gesiyemi be ꞌebweuna ꞌebweuna ꞌida gwae, ‘ꞌAboꞌagu Toꞌetoseyana nina’, be tomota yaudi sida muliyedi. ");
INSERT INTO dob_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wate ale ꞌetamo wanonodi saiyao selabemiya ta ꞌedasolaya manudi, ta geyaꞌabo waꞌateꞌate saꞌala, manuna yage getedi sida apwesa nugana ta esi baleꞌu ꞌana ꞌebe losalowa ꞌana tuta maꞌetamo. ");
INSERT INTO dob_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Manuna ꞌetamo mali boda mali boda ꞌediya sida losaiya, ta wate mali ꞌebeloina mali ꞌebeloina ꞌediya sida losaiya, be botana sinabwadi ta mwaniꞌiniꞌi siapwesa sena yaudi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ta yage getedi tuta mwaudi ꞌadi ꞌebe eꞌale tuga. ");
INSERT INTO dob_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ꞌOmi ꞌiabe tomota sigiyaimi be sigieꞌelouyami nai siloemwawasimi, be sena maiboꞌadi tomoteninao sida etalauwalemi manuna ꞌomi ꞌaene ꞌagu toemisao; ");
INSERT INTO dob_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","be mwau nidi manudi ꞌetamo yaumi waneeneta be taumimo gosemiyao wasipupuyedi nai waetalauwalaedi. ");
INSERT INTO dob_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wate palopita kabokaboyao sida apwesama be yaumi sida anugana gesiyemi. ");
INSERT INTO dob_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Be wate bubuna toꞌumalina ꞌina sinabwa ꞌenega tomota yaudi ꞌidi oboboma ꞌatediyega ꞌida neneta. ");
INSERT INTO dob_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ta ꞌabo yaita ꞌieꞌalamaꞌiꞌita be ꞌitoolopaꞌala be ꞌana laba tuta ꞌana ꞌebe losalowa ꞌenaya gwausowala ataya ꞌida loba. ");
INSERT INTO dob_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“Ta Yaubada ꞌina loina tetelina ꞌida ꞌelelewana nugana sena maiboꞌana ꞌediya, be muliyega tuta ꞌana ꞌebe losalowa ꞌida apwesa. ");
INSERT INTO dob_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Maꞌetamo weꞌiweꞌiyaya nina palopita Daniela niꞌatu ꞌigimisimanena ꞌida apwesa, nate yage toꞌumali wawasae ta gadilulu sena tabu ꞌena ꞌida toolo. (ꞌAbo yaita ona gete ꞌisawai ꞌida nuwasabwalena.) ");
INSERT INTO dob_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Tuta gote ꞌenaya Yudia ꞌana tomiyanao ꞌilobwenedi be ꞌoya ꞌediya sidedena. ");
INSERT INTO dob_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Be ꞌeguma yaita bwaimaya ꞌimiyami ꞌida dena manini, ta geyaꞌabo ꞌilugulugu limana ꞌina anuwaya ꞌina gwegwe sabi ꞌewadi. ");
INSERT INTO dob_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ta ꞌabo yaita bagulaya ꞌipaipaisewa geyaꞌabo ꞌiilaila ꞌana ꞌoama mali esenaya ꞌisaꞌunaya manuna. ");
INSERT INTO dob_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“Ta tuta gote ꞌenaya toꞌeuwanao be toesusuyao sienuwaꞌoleꞌole. ");
INSERT INTO dob_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ꞌEnega wada sidasida be tuta boboꞌana Yaubada ꞌida ꞌebwaꞌemi ꞌimi tuta dena ꞌenaya, ta geyaꞌabo gogai ꞌana tutaya, nai Sabate ꞌena. ");
INSERT INTO dob_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","“Onaꞌaiꞌaila tuta gote mwau wawasae, manuna baleꞌu ꞌana mweluluwaꞌunu ꞌenega ga batuwa nigeya ꞌebweu wate mwau gete nadigega, ta muliyega mwau gete geyaꞌabo wate ꞌiapweapwesa limana. ");
INSERT INTO dob_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mwau gote ꞌana ꞌasiyatao ꞌeguma Yaubada geyaꞌabo ꞌigiegie kukupai, ꞌiabe tomota maiboꞌadi simwamwawasa, ta esi Yaubada ꞌasiyata nidi ꞌida giekukupa, nate ꞌina boda esiesinuwadi manudi. ");
INSERT INTO dob_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ꞌEnega ꞌabo yaita ꞌieonami be ꞌigwae, ‘Keliso gete’, nai ‘Gote’, geyaꞌabo waeemisedi. ");
INSERT INTO dob_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Manuna Keliso kabokabo be palopitao kabokabo ꞌiabe siapwesa be weꞌiweꞌiyaya waiwaidi tomota ꞌediya sida eꞌitaedi be ꞌediyega ꞌabo sawesawediya Yaubada ꞌina bodao esiesinuwadi wate sikwakwani. ");
INSERT INTO dob_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ta ꞌomi yage gete manuna niꞌatu yagimisimana ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ꞌEnega ꞌeguma sieonami, sigwae, ‘Keliso sena mwatui daitaya ꞌimiyami’, geyaꞌabo mitawa gote ꞌena watautauya. Be ꞌeguma sigwae, ‘Keliso anuwa solaꞌaiꞌailinaya ꞌimiyami’, geyaꞌabo waeemisedi. ");
INSERT INTO dob_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ꞌAboꞌagu Tomota Natuna, be ꞌigu mai limana ꞌana ꞌita ꞌatuwa namala sinabwana bomatuyega ꞌituyayala ga ꞌana laba ꞌebwagaya. ");
INSERT INTO dob_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Mane ꞌena kokowa ꞌimiyami nate ꞌena kaokao sida egogonama. ");
INSERT INTO dob_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ta tuta mwau nina ꞌigugumwala be muliyega sinala ꞌiguguyoi, be wate nawalae ꞌina maedana ꞌikwekweu, be kwadimao galewega sibebeꞌu, be yage yauyaudi galewaya simiyami ꞌidi waiwai sida neneta. ");
INSERT INTO dob_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ꞌAboꞌagu Tomota Natuna, be tuta gote ꞌena ꞌigu weꞌiweꞌiyaya galewaya ꞌiapwesama, ta boda maiboꞌadi baleꞌuya siꞌitagu pwana debanega ma igu waiwai ta ma igu esaesa sinabwana yameema, be sida doonaona. ");
INSERT INTO dob_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta wate yoguli sida muꞌe be ꞌigu aniloseyao yaetunedi be ꞌigu boda esiesinuwadi siegogonedima baleꞌu maiboꞌana ta yagila maiboꞌadi ꞌidi sena ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ꞌEbeꞌita saido ꞌenega yada eꞌitami ꞌaene ꞌeguma saido yawadi auwaudi ꞌigalugalu wamwalatonina ꞌaene losiye ꞌana tuta ꞌiloseloselabe. ");
INSERT INTO dob_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ta wate ꞌabo weꞌiweꞌiyaya nidi getedi waꞌita lobadi niꞌatu wamwalamwalatoni ꞌaene ꞌigu tuta ila limanama niꞌatu ꞌiloseloselabena. ");
INSERT INTO dob_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Onaꞌaiꞌaila, ꞌepata gete geyaꞌabo wagumwagumwala be ꞌana laba yage nidi maiboꞌadi sida apwesa. ");
INSERT INTO dob_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maꞌetamo galewa ta baleꞌu sisasawala, ta ꞌigu onao geyaꞌabo saꞌi sisawasawala. ");
INSERT INTO dob_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nigeya ꞌebweu yaita ꞌimwalamwalatoni to tuta, nai to ꞌasiyata ꞌena yaila limanama, ta wate aniloseyao galewaya nigeya simwalamwalatoni. ꞌAboꞌagu wate nigeya yamwalamwalatoni. Ta tamagu tebweuna namo ꞌimwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tuta gete, Noa ꞌina tuta nadigega. ");
INSERT INTO dob_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Manuna Noa ꞌina tutaya tomota siꞌeꞌai ta sinumanuma ta sisawasawaeyai, ta wate siaiai, ga ꞌana laba Noa ꞌina wagaya ꞌigelu; ");
INSERT INTO dob_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ta muluwa ꞌiloesalutuidi, ga ꞌenega tomota maiboꞌadi sidalala; ta ꞌaboꞌagu Tomota Natuna ꞌigu ila limanama nadigega. ");
INSERT INTO dob_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Tuta gote ꞌena ꞌeguma tai ꞌeluwa bagulaya, ꞌebweu yaꞌauꞌewa ta ꞌebweuna ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wate ꞌabo iine siteluwa siꞌetaꞌetagowa, ꞌebweu yaꞌauꞌewa ta ꞌebweuna ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ꞌEnega walomataꞌiꞌita ꞌaiꞌaila, manuna ꞌigu ila limanama ꞌana tuta nigeya wamwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ta wanuwaꞌiꞌisi ꞌaene ꞌabo yaita tonianuwa ꞌida mwalatonina to tuta boiboi solanaya toꞌipwala ꞌilugulugu ꞌina anuwaya, ꞌida gibubuna ꞌaiꞌaila ta ꞌida yaweyawe be geyaꞌabo ꞌina anuwa ꞌibwalebwale. ");
INSERT INTO dob_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ꞌEnega ꞌomi wate wada gibubuna ꞌaiꞌaila be ꞌigu tuta ilama manuna wada yamwagu, manuna ꞌaboꞌagu Tomota Natuna ꞌigu ilama ꞌana tuta nigeya wamwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Toguinuwa boboꞌadi ta sinasinapudi ꞌidi bubuna gete nadigega: ꞌAbo yaita tauna ꞌina ꞌinapwana ꞌiesinuwena be anuwa ꞌida ꞌitaꞌiꞌisi be gosenao ꞌadi masula ꞌiꞌebwaꞌedi ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya, ");
INSERT INTO dob_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","maꞌetamo ꞌabo ꞌinapwana nina ꞌiila limanama be ꞌina toguinuwa nina ꞌilobai ꞌiguiguinuwa palupaluna, ꞌiabe manuna ꞌigwausowala be ꞌena ꞌida gwae, ");
INSERT INTO dob_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","‘ꞌImu guinuwa boboꞌana manudi yagwausowala, ꞌenega yage maiboꞌadi ꞌadi loina yaꞌebwaꞌeyo be ꞌuloine.’ ");
INSERT INTO dob_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Ta esi ꞌeguma toguinuwa ꞌibubuna toꞌumalina be taunamo ꞌena ꞌiona, ‘ꞌIgu ꞌinapwana ꞌetamo ꞌisoꞌisoꞌi,’ ");
INSERT INTO dob_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ta ꞌieꞌale be gosenao ꞌisapi dadanedi, be ꞌiꞌeꞌai diidiga, nai ꞌinumanuma diidiga toekabaleyao maꞌenao, ");
INSERT INTO dob_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","be ꞌenega ꞌina ꞌinapwana ꞌabo ꞌiaesalutuinama be ꞌina guinuwa toꞌumalina ꞌiꞌitalobai, ");
INSERT INTO dob_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ꞌiabe anuwega ꞌipaꞌi be eꞌisa toꞌumalina ꞌiꞌebwaꞌe tokaboyao ꞌidi senaya, sena gote ꞌena sidedoi be siesalaꞌiꞌita ꞌelouya ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ta Yesu ꞌieonedi wate, ꞌigwae, “Yaubada ꞌina loina gete nadigega: Gomagweine site sanau ꞌidi mayale siꞌewedi ga sitauya toai meꞌolotona sabi aesotena ꞌina ai sagalina ꞌina mai ꞌena manuna. ");
INSERT INTO dob_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ꞌEdiyega site nima uwauwadi ta site nima sinasinapudi. ");
INSERT INTO dob_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Touwauwao nidi ꞌidi mayale nigeya ꞌana bwasi ꞌana loeposeyana siꞌewaꞌewa, ");
INSERT INTO dob_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ta esi taudi tosinasinapu nidi ma idi bwasi ꞌana loeposeyana siꞌewedi ꞌidi mayaleyao maꞌediyao. ");
INSERT INTO dob_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Ta toai meꞌolotona ꞌisoꞌisoꞌi, ꞌenega maiboꞌadi siyamwayamwana ga siꞌeno mwataya. ");
INSERT INTO dob_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ꞌEnega niuniuwanaya ꞌebweu tomota ꞌibwau, ꞌigwae, ‘Toai nina niꞌatu gete ꞌimeema. Watoolo be taaesota.’ ");
INSERT INTO dob_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ꞌEnega gomagweine nidi maiboꞌadi sitoolo ga ꞌidi mayale sigibubudi. ");
INSERT INTO dob_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ꞌEnega gomagweine nidi uwauwadi gosediyao ꞌediya sisida, sigwae, ‘Gosemao, mayale ꞌana bwasi tupwana wada ꞌebwaꞌema, manuna ꞌima mayale niꞌatu be sikwekweu.’ ");
INSERT INTO dob_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ta tosinasinapu nidi sigwae, ‘Nai nigeya ꞌima bwasi sawesawenaya be tupwana ꞌaꞌebwaꞌemi, ꞌenega ꞌomi watatauya toegimwaneyao ꞌediya be ꞌimi mayale ꞌadi bwasi wagimwanedi.’ ");
INSERT INTO dob_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“ꞌEnega sitauya sabi gimwane, ta toai ꞌiapwesama ga taudi niꞌatu sigibubunaya maꞌenao silugu ai masulina manuna, ga ꞌawa sigibodena. ");
INSERT INTO dob_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Muliyega gosediyao gimwaneyega siilama ga sigwae, ‘ꞌInapwana, ꞌawa ꞌugigege be ꞌada luguwa.’ ");
INSERT INTO dob_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ta ꞌidi ona ꞌieꞌisena, ꞌigwae, ‘ꞌOmi mali boda, nigeya yamwalamwalatonimi.’ ");
INSERT INTO dob_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“ꞌEnega ꞌilobwenemi be walomataꞌiꞌita, manuna ꞌasiyata nina, nai tuta nina yailailama nigeya wamwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Yaubada ꞌina loina wate nadigega ꞌeguma ꞌebweu ꞌinapwana ꞌiabe ꞌitatauya mali esenaya, ta ꞌina toguinuwao ꞌibwauyedima ta ꞌiloinedi be ꞌaene ꞌina ꞌebeloina sida ꞌitaꞌiꞌisi. ");
INSERT INTO dob_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ga ꞌebweu ꞌina mani ꞌina toguinuwa ꞌiꞌebwaꞌena ꞌana yau paibi analedi kina, ta tai ꞌeluwena tu analedi kina, ta tai ꞌetonina analedi kina, manuna ꞌina ꞌebwaya ꞌediya taudi ꞌebweuna ꞌebweuna ꞌidi waiwai nadigega, ga muliyega ꞌinapwana nina ꞌipilisinedi ga ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“ꞌEnega tai nina tauna ma ina paibi analedi kina ꞌina ꞌinapwana ꞌina mani nina ꞌiꞌewedi ga ꞌediyega ꞌiepaisewaedi ga ꞌadi loeposeyana paibi analedi wate ꞌilobedi. ");
INSERT INTO dob_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tai ꞌeluwena wate nadigega ꞌina tu analedi kina nidi ꞌiepaisewaedi ga ꞌediyega ꞌina ꞌinapwana ꞌina mani ꞌana loeposeyana tu analedi wate ꞌilobena. ");
INSERT INTO dob_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ta tai ꞌetonina, tauna ma ina analedi kina, ꞌiꞌewedi ga baleꞌu ꞌitaina ga ꞌina ꞌinapwana ꞌina mani nina ꞌikwaiyena baleꞌu solanaya. ");
INSERT INTO dob_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ꞌEnega tuta dudulana mulinaya ꞌidi ꞌinapwana ꞌiilama ga ꞌienaidedi ꞌidi guinuwa ꞌadi eꞌisa manudi. ");
INSERT INTO dob_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ꞌEnega tai nina ma ina paibi analedi kina ꞌimai ga ꞌana loeposeyana paibi analedi kina wate ꞌimeꞌedi ga ꞌigwae, ‘ꞌInapwana, paibi analedi kina ꞌuꞌebwaꞌeguya ga ꞌana loeposeyana paibi analedi kina wate yalobena, ga gete.’ ");
INSERT INTO dob_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ta ꞌinapwana nina ꞌigwae, ‘Boboꞌana, ꞌoyo togwaunuwa ꞌaiꞌaila ta palupaluna. Niꞌatu ꞌuetapewa yage gidalidi ꞌediyega, ꞌenega ꞌamu loina yage sinabwadi manudi yaꞌebwaꞌeyo, be wate ꞌigu ꞌebe gwausowala gete ꞌena ꞌuda miyami.’ ");
INSERT INTO dob_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Muliyega tai ꞌeluwena ma ina tu analedi kina ꞌiapwesama ga ꞌana loeposeyana tu analedi kina wate ꞌimeꞌedi ta ꞌigwae, ‘ꞌInapwana, tu analedi kina ꞌuꞌebwaꞌeguya ga ꞌana loeposeyana tu analedi kina wate yalobena, ga gete.’ ");
INSERT INTO dob_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“ꞌEnega ꞌinapwana nina ꞌigwae, ‘Boboꞌana, ꞌoyo togwaunuwa ꞌaiꞌaila ta palupaluna. Niꞌatu ꞌuetapewa yage gidalidi ꞌediyega, ꞌenega ꞌamu loina yage sinabwadi manudi yaꞌebwaꞌeyo be ꞌoyo wate ꞌigu ꞌebe gwausowala gete ꞌena ꞌuda miyami.’ ");
INSERT INTO dob_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ꞌEnega tai ꞌetonina ma ina analedi kina ꞌimai ta ꞌigwae, ‘ꞌInapwana, yamwalatonimuya ꞌaene ꞌoyo tai paꞌaliyo ta ꞌimu esaesa ꞌuꞌewaꞌewa mali tomota ꞌidi paisewa ꞌediyega, ");
INSERT INTO dob_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ꞌenega yamatautemu ga ꞌimu analedi kina nina baleꞌu solanaya yakwaiyena, ga ꞌimu mani gete.’ ");
INSERT INTO dob_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ta ꞌinapwana ꞌiꞌenapaꞌalina, ꞌigwae, ‘Toguinuwa toꞌumaliyo ta logwautoyasa ꞌaleyo, ꞌumwalatonigu ꞌaene ꞌigu esaesa yaꞌewaꞌewa mali tomota ꞌidi paisewa ꞌediyega, ");
INSERT INTO dob_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ꞌenega ꞌilobwenemu be ꞌigu mani nina banika ꞌena ꞌusaꞌu, be ꞌenega tuta nina yailama ma ꞌana loeposeyana yalobai!’ ");
INSERT INTO dob_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ga ꞌina ꞌaliꞌeiyao ꞌediya ꞌigwae, ‘ꞌIgu analedi kina ꞌenega waꞌewadi be tai nina tauna loeposeyana sinabwana ꞌilobena ꞌenaya waꞌebwaꞌe.’ ");
INSERT INTO dob_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Manuna ꞌabo yaita ꞌana egueguyai ꞌiloeposeyanei, ꞌana loeposeyana wate ꞌida loba, be ꞌida sinabwa; ta ꞌeguma yaita nigeya ꞌiloeloeposeyane, toꞌase ꞌenaya ꞌimiyami ꞌenega maꞌetamo sida ꞌewayaule. ");
INSERT INTO dob_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ꞌEnega ꞌina ꞌaliꞌeiyao ꞌiloinedi be toguinuwa toꞌumalina nina siula apwese ꞌatamanaya sena guguyoi ꞌenaya, be nada tomota ma idi ꞌelouya sidedoi ta siesalaꞌiꞌita maꞌenao. ");
INSERT INTO dob_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ꞌAboꞌagu Tomota Natuna, be maꞌetamo ma igu esaesa tuyayalina be ma igu aniloseyao ꞌamama be ꞌenega ꞌigu ꞌebemi esaesa ꞌena yamiyatowa sabi loina, ");
INSERT INTO dob_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","be ꞌebeloina baleꞌuya maiboꞌadi mataguya sida egogonedima be yaweyalidi ꞌatuwa sipi ꞌadi toꞌitaꞌiꞌita ꞌiweyalidi gota ꞌediyega, ");
INSERT INTO dob_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","be sipi yasaꞌu dumedumedi ꞌataiguya ta gota gegeumiguya, ");
INSERT INTO dob_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","be ꞌenega toloina ꞌaboꞌagu taudi ꞌataiguya yada eonadi be yada gwae, ‘ꞌOmi Tamagu ꞌina obobomega wada gwausowala, wamai be ꞌimi ꞌebeloina nina baleꞌu ꞌana mweluluwaꞌunu ꞌenega ꞌigibubunaya manumi wada ꞌewa. ");
INSERT INTO dob_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Manuna ꞌomi lowa yabotanaya ta waeꞌenigu, ta wate tonaꞌagu ꞌiyapasaya ta bwasi waꞌebwaꞌegu, wate yaetoꞌuꞌumala ꞌimi ꞌasaya ta wabwauyeguya ꞌimi anuwaya, ");
INSERT INTO dob_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ta wate nigeya ꞌagu ꞌoamamo ta waeꞌoamegu, ta wate yaleꞌoasaya ta waayausigu, wate deliya yamiyamiya ta waayausigu.’ ");
INSERT INTO dob_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ꞌEnega topalupalu nidi ꞌeguya sida gwae, ‘ꞌInapwana, to tuta sana ꞌaꞌitemu ma ꞌamu botana ta ꞌaeꞌenimu? nai tonaꞌayo ꞌiyapasa ta bwasi ꞌaꞌebwaꞌemu? ");
INSERT INTO dob_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","nai ꞌuetoꞌuꞌumala ꞌima ꞌasaya ta ꞌabwauyemu ꞌima anuwaya? nai nigeya ꞌamu ꞌoamamo ta ꞌaeꞌoamemu? ");
INSERT INTO dob_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","nai ma ꞌamu leꞌoasa nai deliya ꞌumiyamiya ta ꞌaayausimu?’ ");
INSERT INTO dob_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“ꞌEnega yada ona ꞌediya be yada gwae, ‘Onaꞌaiꞌaila, ꞌeguma yaita ꞌoyo gosegwao gidalidi ꞌebweuna ꞌulemei, nate ꞌena ꞌaboꞌagu wate ꞌulemegu.’ ");
INSERT INTO dob_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ta taudi gegeumiguya simiyami yaeonadi, ‘ꞌOmi totoꞌumalimi wapilisinegu be watatauya kaiwe sabesabelulu atayana ꞌenaya, tauna Yaubada ꞌigibubuna Seitani ma ina bodao manudi, ");
INSERT INTO dob_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","manuna lowa ma ꞌagu botana ta nigeya wada eꞌenigu, wate tonaꞌagu ꞌiyapasaya ta nigeya ꞌebweu wate bwasi wada ꞌebwaꞌegu, ");
INSERT INTO dob_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ta yamiya toꞌuꞌumala ꞌimi ꞌasaya ta nigeya wada bwauyegu ꞌimi anuwaya, be nigeya ꞌagu ꞌoamamo ta nigeya wada eꞌoamegu, wate yaleꞌoasaya ta wate deliya yamiyami ta nigeya wada ayausigu.’ ");
INSERT INTO dob_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Muliyega taudi ona gete sida eꞌisa be sida gwae, ‘ꞌInapwana, to tuta ꞌaꞌitemu ma ꞌamu botana, nai tonaꞌayo ꞌiyapasa, nai ꞌuetoꞌuꞌumala, nai nigeya ꞌamu ꞌoamamo, nai ꞌuleꞌoasa, nai deliya ꞌumiyami, ta nigeya ꞌalemelemeyo?’ ");
INSERT INTO dob_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Be yada eonadi, ‘Onaꞌaiꞌaila, tuta nidi ꞌediya ꞌabo tomota gidalidi getedi ꞌebweuna nigeya walemelemei, nate ꞌena nigeya walemelemegu.’ ");
INSERT INTO dob_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ꞌEnega taudi sida tauya ꞌelouya ataya ꞌenaya, ta topalupaludi esi yawasi ataya sida loba.” ");
INSERT INTO dob_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu ꞌina ona getedi ꞌilosalonidi, ga ꞌina tononoyao ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ꞌigwae, “Wamwalatonina ꞌasiyata ꞌeluwa be Ataona Sagalina taguinuwe, be ꞌenega ꞌagu tosipupu ꞌida ꞌebwayaegu ꞌagu talauwalao ꞌediya, be kelose ꞌena sida loemwawasigu, Tomota Natuna ꞌaboꞌagu.” ");
INSERT INTO dob_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ꞌEnega totaliyao sinabwadi be me Isileli ꞌidi ꞌinapwanao sideli egogonama Kaiyapa ꞌina anuwa sinabwana ꞌenaya, tauna totaliyao ꞌidi ꞌinapwana sinabwana. ");
INSERT INTO dob_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ꞌEnega ꞌinapwanao nidi taudimo siloina be ꞌaene kaboega Yesu sida giyai be sida loemwawasi, ");
INSERT INTO dob_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ta sigwae, “Geyaꞌabo sagali solanaya Yesu tagiyagiyai, ꞌabona nai tomota sigamwasowaleda be silosaiya ꞌedaya.” ");
INSERT INTO dob_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tuta nina Yesu Betani ꞌena ꞌimiyami, Saimoni ꞌina anuwaya. Tauna lowa tolepelo ꞌebweu. ");
INSERT INTO dob_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ꞌEnega ꞌebweu waine ma ina bunama ꞌimai, ta bunama nina ꞌana maisa sinabwana, ta botolo boboꞌana wawasae ꞌenaya ꞌisiwena. Yesu ꞌetamo anuwaya ꞌiꞌeꞌai, ta waine nina ꞌimai ga bunama nina Yesu debanaya ꞌisiwena. ");
INSERT INTO dob_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ta Yesu ꞌina tononoyao siꞌitena ga waine silomugiyena, sigwae, “Toꞌase manuna bunama ꞌimudalina? ");
INSERT INTO dob_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ꞌIlobwenena be bunama nina ꞌigimwaneye be maisa sinabwana ꞌiꞌewa be ꞌieguyaiye togomabeso ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ta Yesu ꞌidi ona nina ꞌimwalatonina ga ꞌieonedi, ꞌigwae, “Geyaꞌabo waine gete walomulomugiyei, manuna ꞌina lema gete ꞌeguya boboꞌana wawasae. ");
INSERT INTO dob_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Togomabeso nidi waoneonediya tuta maiboꞌana selabemiya simiyami, ta ꞌaboꞌagu esi nigeya tuta dudulana maꞌemi tamiyami. ");
INSERT INTO dob_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Waine gete niꞌatu ꞌieoloigu bwalagu ꞌana saꞌuꞌaliꞌali manuna. ");
INSERT INTO dob_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ta onaꞌaiꞌaila, maꞌetamo teteligu ꞌana loguguya tomota sinoonoi baleꞌu maiboꞌana ꞌenaya, ta waine gete ꞌina guinuwa ꞌeguya tetelina sida emwasali wate.” ");
INSERT INTO dob_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ta Yesu ꞌina tonono ꞌebweu ꞌana esana Yudasa Isikaliota ꞌitauya totaliyao sinabwadi ꞌediya, ");
INSERT INTO dob_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ga ꞌieonedi, ꞌigwae, “ꞌEisa maisa waꞌebwaꞌegu ꞌabo Yesu ꞌemiya yatelesipupuye?” ꞌEnega mani siliba ꞌana yau teti siꞌebwaꞌena. ");
INSERT INTO dob_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ꞌEnega Yudasa tuta boboꞌana ꞌiyamwena be ꞌaene Yesu ꞌediya ꞌida telesipupuye be sigiyai. ");
INSERT INTO dob_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ataona masulina beledi daisina, nigeya gieseseinamo sieꞌani. Ga Ataona masulina ꞌana ꞌasiyata nugana ꞌena Yesu ꞌina tononoyao ꞌaidi ꞌenaya simai ga sigwae, “ꞌInapwana, mane ꞌena nuwanuwayo be Ataona masulina manuyo ꞌagibubu?” ");
INSERT INTO dob_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ꞌEnega Yesu ꞌiona, “Watauya Yelusalema be ꞌigu sida ꞌebweu tai ꞌena wasimane, wagwae, ‘ꞌIma toeꞌita ꞌina ona gete nadigega ꞌaene “ꞌIgu tuta niꞌatu ꞌiapwesama ta nuwanuwagu be ꞌimu anuwaya Ataona masulina ma igu tononoyao ꞌaꞌaꞌani.” ’ ” ");
INSERT INTO dob_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ga tonono nidi Yesu ꞌina ona nina siematamatanena ga tai nina ꞌina anuwaya Ataona masulina sigibubuna. ");
INSERT INTO dob_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ꞌEnega ꞌasuinuwanuwaya Yesu ma ina tononoyao site tuwelo nidi silugu ga masula nina siꞌenina. ");
INSERT INTO dob_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ta ꞌidi ꞌeꞌai solanaya Yesu ꞌigwae, “Gosegwao, yaona ꞌaiꞌaila ꞌaene ꞌebweu ꞌemiyega ꞌiabe ꞌitelesipupuyegu.” ");
INSERT INTO dob_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ta Yesu ꞌina ona gete manuna sinuwamwau ꞌaiꞌaila, ga ꞌebweuna ꞌebweuna Yesu ꞌena ꞌienaida, ꞌigwae, “ꞌInapwana, yaita tauna? Nai ꞌaboꞌagu?” ");
INSERT INTO dob_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ta Yesu ꞌieonedi, “Tai nina tauna maꞌiyagu gaeba ꞌebweuna ꞌenega ꞌaꞌeꞌai, tauna ꞌiabe ꞌitelesipupuyegu. ");
INSERT INTO dob_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ꞌAboꞌagu Tomota Natuna maꞌetamo yatatauya ꞌeda nina lowa Buki Tabu ꞌena ꞌigimisimanena, ta esi ꞌagu tosipupu nina nuwaꞌoleꞌolena saꞌi, ta boboꞌana ꞌabo lowa sinana geyaꞌabo ꞌida enaenatune.” ");
INSERT INTO dob_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ꞌEnega ꞌana totelesipupu Yudasa ꞌieonena, “ꞌInapwana, to tai tauna? Nai ꞌaboꞌagu?” Ga Yesu ꞌigwae, “Niꞌatu ꞌuona saba.” ");
INSERT INTO dob_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ꞌEtamo siꞌeꞌai ta Yesu masula ꞌiꞌewena ga manuna ꞌiona oboboma ta ꞌigitomwena ga ꞌina tononoyao ꞌiꞌebwaꞌedi, ꞌigwae, “Gete oogu waꞌewa be waꞌaꞌani.” ");
INSERT INTO dob_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ta oine makeigana wate ꞌiꞌewena ga manuna ꞌilokagutoki Yaubada ꞌena ga ꞌiꞌebwaꞌedi, ta ꞌigwae, “Maiboꞌami wanunuma. ");
INSERT INTO dob_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gete lalagu, loina auwauna manuna, ꞌidaudau tomota yaumi ꞌimi toꞌumalinao ꞌadi ꞌebe nuwatau manuna. ");
INSERT INTO dob_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ta yaeonami tuta gete be mulinaya oine gete geyaꞌabo ꞌenega yanumanuma limana ga ꞌana laba ꞌomi maꞌegwao oine auwauna tanunuma Tamagu ꞌina senaya.” ");
INSERT INTO dob_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ꞌEnega wali ꞌebweuna siwaliyena ga siapwesa ta situꞌe ꞌOya Olibe ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ta Yesu ꞌieonedi, ꞌigwae, “Batuwa boiboiya maiboꞌami wada denasinegu, nadigega Buki Tabu ꞌina simana, ꞌigwae, ‘Toꞌitaꞌiꞌita sipi yaloemwawasi be sipi maiboꞌadi sida ꞌelelewana.’ ");
INSERT INTO dob_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ta ꞌigu toololimana mulinaya Galili ꞌena yatatauya be ꞌomi muliguyega wawawai.” ");
INSERT INTO dob_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ꞌEnega Pita ꞌilolagata ga ꞌigwae, “ꞌIabe maiboꞌadi sidena sineyo ta tebweugu maꞌiyayo.” ");
INSERT INTO dob_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ta Yesu Pita ꞌieonena, “Yaona ꞌaiꞌaila boiboi batuwa, muliyega be kakaleko ꞌigwagwane ta ꞌoyo matoi ꞌueyaseyaseyegu.” ");
INSERT INTO dob_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ta Pita ꞌigwae, “ꞌInapwana, geyaꞌabo saꞌi yaeyaseyaseyeyo! ꞌEguma siloemwawasiyo ꞌaboꞌagu wate maꞌiyayo siloemwawasida.” Tomuliyao maiboꞌadi wate nadigega sionaona. ");
INSERT INTO dob_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ꞌEnega Yesu ꞌina tononoyao maꞌenao sitauya ꞌebweu sena ꞌana esana Gedesemani ꞌena, ta ꞌieonedi, ꞌigwae, “Gete ꞌena wamiyami, ta ꞌaboꞌagu yaalaga be yasisida Yaubada ꞌena.” ");
INSERT INTO dob_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ta site toi ꞌiꞌauꞌewedi, Pita be Sebedi natunao ꞌeluwa. ꞌEnega Yesu ma ina ꞌateuyauya ta ma ina nuwamwau ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ꞌigwae, “ꞌAtegu ꞌiuyauya sinabwana, nai ꞌiabe yamwamwawasa, ꞌenega bada wamiyami ta walomataꞌiꞌita, be ꞌenega walemegu.” ");
INSERT INTO dob_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ta Yesu ꞌialaga tupwana ga baleꞌuya ꞌibeꞌu sanamwaꞌuta ta ꞌisidasida, ꞌigwae, “Tamagu ye, ꞌeguma kapekapeyana ꞌelouya keigana gete ꞌeguyega ꞌuꞌewayaulei, ta geyaꞌabo ꞌaboꞌagu ꞌigu nuwena ꞌenega, ta ꞌoyo esi ꞌimu nuwena ꞌenega ꞌuda guinuwa.” ");
INSERT INTO dob_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ꞌEnega ꞌiila ga ꞌina tononoyao site toi nidi ꞌilobedi niꞌatu siꞌeno mwataya, ga Pita ꞌilowanowanona ga ꞌigwae, “Pita, nigeya sawesawemuya be ꞌumatapaꞌala be ꞌulemegu tuta gidalina namo manuna, aga?” ");
INSERT INTO dob_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ga wate ꞌieonedi maiboꞌadi, ꞌigwae, “ꞌIlobwenemi be wamatapaꞌala be wasidasida, be ꞌenega geyaꞌabo Seitani ꞌitootoomi. Onaꞌaiꞌaila yaluyaluwami nuwanuwana, ta tuga manuna oomi sitaba.” ");
INSERT INTO dob_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ꞌEnega Yesu ꞌilaga limana ga ꞌisidasida, ꞌigwae, “Tamagu, keiga gete geya nuwagu be ꞌenega yanunuma, ta ꞌabo ꞌimu nuwena nadigega, ta nigeya ꞌebweu wate ꞌeda ꞌimiyami, boboꞌana yanunuma tuga.” ");
INSERT INTO dob_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ta Yesu wate ꞌiila ꞌina tononoyao ꞌediya ga ꞌilobedi wate siꞌeno mwataya, manuna matadi niꞌatu siꞌenoꞌeno. ");
INSERT INTO dob_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ꞌEnega wate ꞌipilisinedi ga ꞌina sidasida ꞌetonina ꞌenaya ꞌina sidasida ꞌeluwena nadigega. ");
INSERT INTO dob_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ta ꞌiila limanama ga ꞌina tononoyao ꞌilowanowanodi, ga ꞌigwae, “Mwaꞌadega, maꞌetamo waꞌenoꞌeno ta waeyaeyawaiꞌata, aga? Ta waꞌita ꞌaboꞌagu Tomota Natuna ꞌigu tuta niꞌatu ꞌiapwesa be sida sipupuyegu totoꞌumalidi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Watoolo be tatatauya, manuna ꞌagu totelesipupu nina niꞌatu gete ꞌimeema.” ");
INSERT INTO dob_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ꞌetamo ꞌionaona ta ꞌebweu ꞌina tonono, Yudasa, tolosaiyao maꞌenao siapwesa. Totaliyao sinabwadi be me Isileli ꞌidi ꞌinapwanao tolosaiyao nidi sietunedi Yudasa maꞌedi, Yesu sabi giyaina, ta boda nidi ma idi sisisaiyao be wepasiyao wate simai. ");
INSERT INTO dob_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ta Yudasa weꞌiweꞌiyaya niꞌatu ꞌediya ꞌisimanena, ꞌigwae, “ꞌAbo yaita yaꞌatubwaili, nate tauna Yesu, be wagiyai.” ");
INSERT INTO dob_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ꞌEnega ꞌitauya palupaluna Yesu ꞌena ga ꞌilokagutokiyena ta ꞌiꞌatubwailina. ");
INSERT INTO dob_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ta Yesu ꞌigwae, “Gosiyagu, toꞌase manuna ꞌumai?” ꞌEnega boda nidi siapwesama ga Yesu sigiyaina. ");
INSERT INTO dob_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ta Yesu ꞌina bodao ꞌebweuna ꞌediyega ꞌina sisisaiya ꞌilisilolona ga totaliya sinabwana ꞌina toguinuwa tenana ꞌiupwa yaulena. ");
INSERT INTO dob_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ta Yesu tai nina ꞌieonena, “Tuwa! ꞌImu sisisaiya ꞌusaꞌuile ꞌina senaya, manuna tolosaiyao taudi losaiya ꞌenega simwamwawasa. ");
INSERT INTO dob_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ꞌUda mwalatoni ꞌaene ꞌabo nuwanuwagu Tamagu ꞌena yasisida ꞌagu lema manuna, ꞌiabe gete tuga aniloseyao mabodadi tomoyauyau ꞌietunedima. ");
INSERT INTO dob_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ta nigeya! ꞌEda gete ꞌenega Buki Tabu ꞌina simanao manugu sida apwesa.” ");
INSERT INTO dob_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Gote ꞌena Yesu boda ꞌieonedi, ꞌigwae, “Sana ꞌaboꞌagu toꞌipwala, ga ꞌenega ma imi sisisaiya be ma imi wepasi wamai sabi giyaigu! Ta toꞌase ꞌalena ga ꞌenega nigeya wagiyagiyaigu ꞌasiyata nidi yaudi Anuwa Tabu ꞌena yamiyami ta yaeꞌieꞌita tomota ꞌediya? ");
INSERT INTO dob_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ta yage getedi sida apwesa be ꞌenega palopitao ꞌidi gimisimana Buki Tabu solanaya sida apwesa.” ꞌEnega Yesu ꞌina tononoyao maiboꞌadi sidena sinena. ");
INSERT INTO dob_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Boda nidi niꞌatu Yesu sigiyaina ga siꞌauꞌewena totaliyao ꞌidi ꞌinapwana, ꞌana esana Kaiyapa, ꞌenaya. Ta Kaiyapa ꞌina anuwaya loina ꞌana toeꞌitao be ꞌinapwanao niꞌatu sideli egogonama ga simiyami. ");
INSERT INTO dob_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ta Pita ꞌedasolega Yesu ꞌimuliyena ga ꞌimai totaliya sinabwana ꞌina ꞌasaya, ga ꞌilugu anuwaya ta toꞌitaꞌiꞌitao maꞌediya simiyatowa be ꞌaene Pita nina Yesu ꞌana loina ꞌida nono. ");
INSERT INTO dob_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ta totaliya sinabwadi be ꞌinapwanao nidi nuwanuwadi Yesu ꞌana toeꞌewa kabokabo sida loba be ꞌidi eꞌewa ꞌenega Yesu sida loemwawasi. ");
INSERT INTO dob_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ꞌEnega toeꞌewa kabokabo yaudi simai, ta esi ꞌidi eꞌewa nigeya palupaludi. Ta muliyega ꞌeluwa tai simai ");
INSERT INTO dob_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ga sigwae, “Yesu lowa ꞌiona, ꞌigwae, ‘Sawesaweguya be Yaubada ꞌina anuwa yalige yaulei, be ꞌasiyata ꞌetoi ꞌediya yada ꞌabilima.’” ");
INSERT INTO dob_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ꞌEnega totaliyao ꞌidi ꞌinapwana sinabwana ꞌitoolo, ga ꞌigwae, “Nigeya ꞌimu eꞌisamo, aga? Tomota gotedi ꞌidi eꞌewa ꞌemuya niꞌatu ꞌunononaya?” ");
INSERT INTO dob_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ta Yesu tuga ꞌiꞌalaenono. ꞌEnega totaliya sinabwana Yesu ꞌieonena, “ꞌUona ꞌaiꞌaila Yaubada matanaya, mwaꞌadega ꞌoyo Toꞌetoseyana niyo, ta Yaubada natuna, nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ta Yesu ꞌigwae, “Niꞌatu nate ꞌuona saba, ta wate yaeonami ꞌaene ꞌaboꞌagu Tomota Natuna be maꞌetamo waꞌitagu Toewaiwai sana ꞌatainaya yamiyami be wate galewa pwananao debadiyega yamama.” ");
INSERT INTO dob_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ꞌEnega totaliya sinabwana nina ꞌigamwasowala ꞌaiꞌaila ga taunamo ꞌana ꞌoama ꞌisabuna ta ꞌigwae, “ꞌIna ona toꞌumalina wanononaya? Onaꞌaiꞌaila, tai gete Yaubada ꞌisinalina. Tuwa! Geyaꞌabo wate toeꞌewao sionaona ꞌina loegesiyao manudi. ");
INSERT INTO dob_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mwaꞌadega ꞌimi nuwanuwa Yesu manuna?” Ga taudi sigwae, “ꞌIlobwenena be ꞌimwamwawasa.” ");
INSERT INTO dob_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ꞌEnega maninina sigiwalina ta siunu dadanena, ta wate ꞌaidi sisapina, ");
INSERT INTO dob_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta sigwae, “ꞌEguma ꞌoyo Toꞌetoseyana nina ꞌuona apwesa ꞌemaya ꞌaene yaita tauna ꞌisapimu? Manuna ꞌuona ꞌaene ꞌoyo palopita.” ");
INSERT INTO dob_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ta Pita maꞌetamo ꞌetauluya ꞌimiyami ga toguinuwa gomagweine ꞌebweuna ꞌiapwesama ga ꞌienaidena, ꞌigwae, “Lowa goma Galili Yesu nina ꞌoyo maꞌiyayo wamiyami, aga?” ");
INSERT INTO dob_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ta tomota yaudi matadiya Pita ꞌieyaseyase, ꞌigwae, “Yage nina ꞌuonaonae nigeya yamwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ꞌEnega Pita ꞌidena ga tupwana ꞌiaapwesa. Ta ꞌebweu wate gomagweine Pita ꞌiꞌitena ga tomiya nidi ꞌediya ꞌigwae, “Tai gote lowa Yesu goma Nasaleta maꞌiyana.” ");
INSERT INTO dob_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wate Pita ꞌieyaseyase ta ꞌisawa tamatamana ga ꞌigwae, “ꞌInapwana ꞌimwalatonina ꞌaene tai nina ꞌaboꞌagu nigeya yamwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tuta kukupana namo mulinaya toyoꞌo nidi Pita ꞌenaya simai, ta sigwae, “Onaꞌaiꞌaila ꞌukabo! ꞌOyo Yesu ꞌina boda ꞌebweu, manuna ꞌimu lewa ꞌatuwa me Galili ꞌenadi.” ");
INSERT INTO dob_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ꞌEnega Pita ꞌisawa tamatamana ta ona toꞌumalina ꞌenega ꞌibwautuꞌe, ꞌigwae, “Tamada! Tai nate nigeya yamwalamwalatoni.” Ta tuta gote ꞌena kakaleko ꞌigwane. ");
INSERT INTO dob_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ꞌEnega Pita Yesu ꞌina ona ꞌinuwaꞌiꞌisina ꞌaene “Muliyega be kakaleko ꞌigwagwane ta ꞌoyo matoi ꞌueyaseyaseyegu.” ꞌEnega Pita nuwana ꞌimwau sinabwana ga ꞌiapwesa ꞌatamanaya ga ꞌidedoi. ");
INSERT INTO dob_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tomwa ꞌiulisina ga totaliyao sinabwadi be ꞌinapwanao maiboꞌadi siloiloina be ꞌaene Yesu siloemwawasi. ");
INSERT INTO dob_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ꞌEnega Yesu nimana siyonidi ga sitauyena toloina sinabwana Pailato ꞌenaya be ꞌaene Pailato nina ꞌida loine. ");
INSERT INTO dob_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ta Yudasa nina ꞌimwalatonina ꞌaene Yesu ꞌiabe siloemwawasi, ꞌenega ꞌinuwaꞌebuni ga ꞌina mani gulewa teti ꞌiiledi totaliyao be ꞌinapwanao ꞌediya, ");
INSERT INTO dob_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ta ꞌigwae, “Niꞌatu yaloegesi, manuna tai boboꞌana ꞌemiya yasipupuyenaya.” Ta sigwae, “Nate nigeya ꞌebweu toꞌase ꞌemaya ta ꞌoyo tuga manuna ꞌuda nuwanuwa.” ");
INSERT INTO dob_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ꞌEnega mani teti nidi ꞌiula mwaꞌutedi Anuwa Tabu solanaya, ta ꞌiapwesa ga ꞌitauya, ga balaeyega ꞌotona tauna ꞌididimagena ga ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ta totaliyao nidi mani nidi siegogonedi ga sigwae, “Nigeya sawesawenaya be Yaubada ꞌana ꞌebwayadaita ꞌena tasaꞌui, manuna mani gete tomota ꞌana loemwawasa ꞌana eꞌisa.” ");
INSERT INTO dob_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ꞌEnega taudimo siloina ga mani nina ꞌenega ꞌebweu toꞌabiꞌule ꞌina baleꞌu ꞌebweuna sigimwanena, be ꞌaene bwaꞌa nina ꞌowagao ꞌadi ꞌaliꞌali. ");
INSERT INTO dob_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ꞌEnega bwaꞌa nina sieesena ‘Lala baleꞌuna’, ga esana nina maꞌetamo ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Gote ꞌenega palopita Yelemaiya ꞌina onaupaupa ꞌiapwesa, manuna lowa Buki Tabu ꞌena ꞌina ona siꞌetoladina ꞌaene, “Ga me Isileli tauna ꞌana maisa sibwauyena, nate gulewa siliba ꞌadi yau teti, ga mani nidi siꞌewedi, ");
INSERT INTO dob_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ga ꞌenega toꞌabiꞌule ꞌina baleꞌu siemaisina, nadigega ꞌida ꞌInapwana ꞌiemataluwegu.” ");
INSERT INTO dob_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ꞌEnega Yesu Pailato matanaya sietoolona, tauna toloina sinabwana, ga Pailato nina Yesu ꞌienaidena, ꞌigwae, “ꞌUda simana, ꞌoyo me Yudia ꞌidi kini, aga?” Ta Yesu ꞌigwae, “Niꞌatu nate ꞌuona saba.” ");
INSERT INTO dob_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ꞌEnega totaliyao sinabwadi be ꞌinapwanao Yesu sieꞌewena Pailato matanaya, ta Yesu nigeya ꞌebweu toꞌase ꞌieꞌieꞌisa. ");
INSERT INTO dob_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ta Pailato ꞌigwae, “Mwaꞌadega, simana getedi ꞌamu eꞌewa manuna ꞌunononaya?” ");
INSERT INTO dob_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ta Yesu nigeya wate ꞌieꞌieꞌisa, ta tuga ꞌiꞌala enonomo. ꞌEnega Pailato nina nuwana ꞌiowana sinabwana. ");
INSERT INTO dob_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Yakwala ꞌebweuna ꞌebweuna ꞌediya, Ataona masulina ꞌenaya, toloina nina ꞌina bubuna nate deliyega ꞌebweu tai ꞌiliꞌami be ꞌiapwesa, ꞌeguma yaita pwalu siesinuwe. ");
INSERT INTO dob_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ta tuta gote ꞌena ꞌebweu tai deliya ꞌimiyami, ꞌana esana Balaba, tomota maiboꞌadi simwalatonina ꞌaene tauna totoꞌumalina sinabwana. ");
INSERT INTO dob_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ꞌEnega tomota siegogonama Pailato ꞌenaya, ta Pailato ꞌieonedi, ꞌigwae, “To tai nuwanuwami be manumi yaliꞌami? Balaba? nai Yesu, tauna sieesena Toꞌetoseyana?” ");
INSERT INTO dob_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Manuna Pailato ꞌimwalatonina ꞌaene eꞌipiꞌipiyega Yesu siwasegigiyena sabi loemwawasina. ");
INSERT INTO dob_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ta wate tuta nina ꞌetamo Pailato etala ꞌiguiguinuwe, ta mwanena ale ꞌietunenama ga ꞌigwae, “Geyaꞌabo wate toꞌase ꞌuloiloine tai palupaluna gete manuna, manuna niꞌa yamadawalena ga ꞌebe matauta sinabwana ꞌeguya.” ");
INSERT INTO dob_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ta esi totaliyao sinabwadi be ꞌinapwanao tomota siloaꞌetuꞌetunedi be ꞌaene sisisida Pailato ꞌena be Balaba ꞌiliꞌami ꞌediya ta Yesu sida loemwawasi. ");
INSERT INTO dob_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ꞌEnega toloina nina ꞌienaida limedi, ꞌigwae, “Siteluwa ꞌediyega yaita nuwanuwami be manumi yaliꞌami?” ꞌEnega sigwae, “Balaba.” ");
INSERT INTO dob_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ta Pailato ꞌigwae, “Ta mwaꞌadega yada loinaꞌesa Yesu, tauna sieesena Toꞌetoseyana?” ꞌEnega maiboꞌadi sigwae, “Kelose ꞌena tada tutuepaꞌiye!” ");
INSERT INTO dob_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ta Pailato ꞌieonedi, “Toꞌase sana ꞌina loegesi, ga ꞌenega ꞌaene mwawasa ꞌiloba?” Ta sibwau toitoila, sigwae, “Kelose ꞌenaya tada tutuepaꞌiye!” ");
INSERT INTO dob_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ꞌEnega Pailato ꞌimwalatonina ꞌaene nigeya ꞌina waiwaimo, ta pwalu siegewagewana ꞌana ꞌita ꞌaene ꞌiabe sieꞌale be silosaiya. ꞌEnega bwasiyega nimana ꞌiꞌutudi boda nidi matadiya ta ꞌigwae, “Geyaꞌabo wate toꞌase yaloiloina tai boboꞌana gete ꞌina mwawasa manuna, ta ꞌomi namo wada loina.” ");
INSERT INTO dob_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta boda maiboꞌadi sigwae, “Boboꞌana! ꞌAboꞌama ꞌada loine, ta ꞌana eꞌisa ꞌada loba, ꞌaboꞌama, ta ꞌepata simeemai ꞌediya wate.” ");
INSERT INTO dob_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ꞌEnega Pailato ꞌidi ona ꞌinononaya, ta Balaba ꞌiliꞌamina, ta wate ꞌina tolosaiyao ꞌiloinedi be Yesu balaeyega sida sapi, be muliyega sida tutuepaꞌiye kelose ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ꞌEnega toloina nina ꞌina tolosaiyao Yesu sisapina ta siluguyena ꞌidi anuwa sinabwana solanaya, ga ꞌidi boda maiboꞌadi sibwau egogonedima Yesu ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ga ꞌana ꞌoamao sialolodi, ta ꞌoama esaesa ꞌenega sieꞌoamena sabi tuyeyena, ");
INSERT INTO dob_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ga ꞌana peyaula kwakwakwala ꞌediyega siguinuwena ga debanaya sisaꞌuna, ta ꞌetoguna nima ꞌataina ꞌenaya sisaꞌuna, ta wate matanaya siꞌaetulasa ta situyeyena, sigwaegwae, “Kamatoki, ꞌoyo me Yudia ꞌidi kini ye!” ");
INSERT INTO dob_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ta wate sigiwalina, ga ꞌina ꞌetoguna siꞌewena ga ꞌenega debana sisapina. ");
INSERT INTO dob_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ꞌEnega ꞌidi tuyeya ꞌigumwala, ga ꞌoama esaesa ꞌenega sialolona, ta tauna ꞌana ꞌoamega sieꞌote limena ga siꞌauꞌewena sabi giekelosena. ");
INSERT INTO dob_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ta Yesu siapwesena ga sitauyena, ta ꞌedaya goma Sailini ꞌebweu, ꞌana esana Saimoni, sialobena ga sididigena be ꞌaene Yesu ꞌana kelose ꞌida ꞌaali. ");
INSERT INTO dob_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ga Saimoni nina ꞌiꞌaalina ga ꞌana laba siapwesa sena Goligota ꞌenaya. (Goligota ꞌana mwalatoi nate “Bulubulu ꞌasana.”) ");
INSERT INTO dob_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ga oine be ꞌapasiꞌuma siꞌeinisena ga siꞌebwaꞌena be ꞌaene geyaꞌabo uya ꞌilotolotoo sinabwana, ta Yesu oine nina ꞌilotoonamoya ta ꞌiguitoyasena. ");
INSERT INTO dob_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ꞌEnega kelose baleꞌuya sisaꞌunaya ta Yesu ꞌenaya situtu epaꞌiyena ga sietoolona, ga muliyega toguinuwa nidi Yesu ꞌana ꞌoamao siꞌewedi ga sieguyaiyedi taudimo ꞌediya, ta ꞌidi eguyai esasala ulaesinuwa ꞌenega, be ꞌabo yaita ꞌinugana tauna ꞌana ꞌoama ꞌida ꞌewa. ");
INSERT INTO dob_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ga muliyega simiyatowa sabi lomataꞌiꞌita. ");
INSERT INTO dob_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ta wate ꞌana kelose dabanaya siꞌetoladina, “Yesu tauna me Yudia ꞌadi toloina.” Nate ꞌina mwawasa ꞌalena. ");
INSERT INTO dob_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ta wate toꞌipwala ꞌeluwa sigiekeloseyedi, ꞌebweu Yesu ꞌatainaya ta ꞌebweu gegeuminaya. ");
INSERT INTO dob_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ta tomota ꞌaina ꞌedega Yesu kelose ꞌena situyeyena ta siedagiyena, ");
INSERT INTO dob_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","sigwae, “Nuwaꞌoleꞌoleyo! ꞌUona ꞌaene sawesawemuya Anuwa Tabu ꞌuligei be ꞌasiyata ꞌetoi soladiya ꞌuꞌabilima. Baga ꞌuda ꞌetoseyeyo tauyo be keloseyega ꞌuebusima, ꞌeguma ꞌoyo Yaubada natuna.” ");
INSERT INTO dob_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wate nadigega totaliyao sinabwadi be loina ꞌana toeꞌitao be ꞌinapwanao Yesu siꞌeetetena, ga sigwae, ");
INSERT INTO dob_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mali tomota ꞌiꞌetoseyedi, ta tauna ꞌida ꞌetoseye! Tauna ꞌaene sena Isileli ꞌana toloina, abaga keloseyega ꞌiebusima be ꞌenega taemisei. ");
INSERT INTO dob_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tauna ꞌaene Yaubada ꞌana toemisa, ta ꞌigwae, ‘ꞌAboꞌagu Yaubada natuna.’ ꞌEnega ꞌeguma Yaubada nuwanuwana tauna ꞌida ꞌetoseye, aga?” ");
INSERT INTO dob_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ta toꞌipwala nidi Yesu maꞌenao sigie kelosediya, taudi ꞌadi keloseyega sibwaꞌonao ga taudi wate nadigega Yesu sibaꞌena. ");
INSERT INTO dob_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ꞌAsuoleoleyega ga ꞌasuinuwanuwaya ꞌasa maiboꞌana ꞌiguguyoi, ");
INSERT INTO dob_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ga ꞌasuinuwanuwaya Yesu ꞌenana sinabwanega ꞌibwau ga ꞌigwae, Ol “Eli eli lama sabakitani!” Ta ꞌana gibui ꞌaene “ꞌIgu Yaubada, ꞌigu Yaubada, toꞌase manuna ꞌupilisinegu?” ");
INSERT INTO dob_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ta ꞌaina tomota selabenaya sitootoolo ꞌina bwau sinonona, ta sigwae, “Wanono! Tai gete Ilaitiya ꞌibwaubwauye.” ");
INSERT INTO dob_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ꞌEnega ꞌebweuna ꞌediyega ꞌipili ga balou ꞌiꞌewena ga oine dalelena ꞌena ꞌietupaꞌutuina, ꞌenega ꞌebweu kaiwe ꞌena matana ꞌibadiyena ga ꞌieꞌetotuꞌeyena Yesu ꞌawanaya ga ꞌisokukuna. ");
INSERT INTO dob_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ta tai nina gosenao sigwae, “Tuga tayamwayamwa, nai ꞌiabe Ilaitiya ꞌimama be ꞌiꞌetoseye.” ");
INSERT INTO dob_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ta Yesu ꞌenana sinabwanega ꞌibwau limana, ga yawasina ꞌigumwala. ");
INSERT INTO dob_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ta kaleko nina Anuwa Tabu ꞌana pitaupa ꞌiesabuluwena etanega ga ꞌimwaꞌuta ꞌubunaya, ta mwaniꞌiniꞌi ꞌidedela, ga gulewa sinabwadi siepisalidi. ");
INSERT INTO dob_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ta wate ꞌaliꞌali ꞌawadi siꞌegegedi ga toemisao yaudi lowa simwawasaya kokowadi sitoolo limana, ");
INSERT INTO dob_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ga Yesu ꞌina toolo limana mulinaya taudi wate ꞌaliꞌali ꞌediyega siapwesama, ga Yelusalema ꞌena silugu, ga tomota yaudi ꞌediya siapwesa. ");
INSERT INTO dob_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ta tolosaiyao nidi ma idi toanugana maꞌetamo Yesu siꞌitaꞌitaꞌiꞌisi, ga mwaniꞌiniꞌi be yage maiboꞌana siapwesaya siꞌitedi, ga simatauta sinabwana, ta sigwae, “Onaꞌaiꞌaila, tai gete Yaubada natuna.” ");
INSERT INTO dob_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ꞌAina iine wate ꞌedasolega sidunedune, taudi lowa Galiliyega Yesu simuliyenamaya ta ꞌana masula siguiguinuwe, ");
INSERT INTO dob_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ꞌebweuna ꞌana esana Meli Magidala, ta ꞌina waliyesa, tauna Yemesa be Yosepa sinadiya, ta wate Sebedi natunao sinadiya. ");
INSERT INTO dob_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ta ꞌasuinuwanuwaya ꞌebweu goma Alimatia ꞌimai Pailato ꞌenaya, tauna toesaesa, ta wate Yesu tauna ꞌana tomuliya ꞌebweu, ꞌana esana Yosepa. ");
INSERT INTO dob_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ga Pailato ꞌenaya Yesu kokowana ꞌisidena, ta Pailato ꞌitagwala be ꞌida ꞌewa. ");
INSERT INTO dob_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ꞌEnega Yosepa ma ina ꞌaliꞌeiyao Yesu kokowana siꞌewena, ga ꞌoama wakewakekena ta ꞌesasena ꞌenega siwaduna, ");
INSERT INTO dob_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ga Yosepa nina ꞌana ꞌaliꞌali auwauna ꞌena sisaꞌuna, ta ꞌaliꞌali nina sitainaya ꞌatuwa duluwa gulewa solanaya. Ta ꞌenega gulewa sinabwana ta pulipulina ꞌenega ꞌaliꞌali ꞌawana sisaꞌu bodena, ga muliyega Yosepa ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ta Meli Magidala ma ina waliyesa ꞌaliꞌali selabenaya simiyatowa ga sieꞌasiyedi. ");
INSERT INTO dob_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ta Yesu sigiekeloseyena me Yudia ꞌidi ꞌasiyata gibubu ꞌenaya, ꞌenega tomwa ꞌiulisina ga ꞌidi ꞌasiyata Sabate ꞌenaya totaliya sinabwadi be Palisiyao mabodadi sitauya Pailato ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ta sigwae, “ꞌInapwana, tokabo nina lowa mayawasina ꞌimiyami ꞌina ona ꞌanuwaꞌiꞌisina ꞌigwae, ‘ꞌAsiyata ꞌetoi beo mwawasega yada toolo limana.’ ");
INSERT INTO dob_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ꞌEnega ꞌab kapekapeyana ꞌuloina be ꞌaliꞌali ꞌana toꞌitaꞌiꞌitao siꞌitaꞌiꞌita ꞌaiꞌaili be ꞌana laba ꞌasiyata ꞌetoi, ꞌabona nai ꞌina tononoyao simamai be Yesu kokowana siyai be sidene, be tomota sikaboedi ꞌaene ‘Mwawasega niꞌatu ꞌitoolo limana’, be ꞌenega kabo mulimuliyana kabo nuganuganina ꞌida toꞌumalisine.” ");
INSERT INTO dob_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ta Pailato ꞌieonedi, ꞌigwae, “ꞌImi toꞌitaꞌiꞌitao tolosaiyao simiyami, watauyedi be ꞌaliꞌali silomataꞌiꞌita ꞌaiꞌaili.” ");
INSERT INTO dob_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ꞌEnega sitauya ga ꞌaliꞌali ꞌawana ꞌana ꞌauboda gulewa nina wate sibwadena, ta nada toꞌitaꞌiꞌitao sietoolodi. ");
INSERT INTO dob_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabate mulinaya niꞌatu be tomwa ꞌiulisi wiki auwauna ꞌana ꞌasiyata nugana ꞌena, Meli Magidala ma ina waliyesa simai ꞌaliꞌaliya sabi ayausa. ");
INSERT INTO dob_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ta mwaniꞌiniꞌi sinabwana ꞌidedela, nate ꞌInapwana ꞌina anilose ꞌebweu galewega ꞌiebusima ga gulewa ꞌaliꞌali ꞌawanega ꞌipuli ilena ga ꞌena ꞌimiyatowa. ");
INSERT INTO dob_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anilose nina ꞌana ꞌita namala nadigega, ta ꞌana ꞌoama wakewakeke ꞌaiꞌailina. ");
INSERT INTO dob_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ta ꞌaliꞌali ꞌana toꞌitaꞌiꞌitao anilose siꞌitena ga simatauta sinabwana, ꞌenega sitai, ga sibeꞌu baleꞌuya kokowa ꞌatuwa. ");
INSERT INTO dob_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ta anilose nina iine nidi ꞌieonedi, ꞌigwae, “Geyaꞌabo wamatamatauta. Yamwalamwalatoni ꞌomi Yesu tauna niꞌatu siloemwawasina waꞌebeꞌebese. ");
INSERT INTO dob_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tauna nigeya bada, manuna niꞌatu mwawasega ꞌitoolo limana, nadigega lowa ꞌieonemi. Wamai be ꞌina ꞌebeꞌeno kakaena waꞌita, ");
INSERT INTO dob_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","be muliyega watauya manini be ꞌina tononoyao waeonadi ꞌaene Yesu mwawasega niꞌatu ꞌitoolo limana, be ꞌiabe ꞌinuganugana Galili ꞌena, ta ꞌomi wamuliye be gote ꞌena waꞌita. Nate namo.” ");
INSERT INTO dob_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ꞌEnega iine nidi ma idi matauta ta wate ma idi gwausowala ꞌaliꞌali sipilisinena ga sipili manini be ꞌaene Yesu ꞌina tononoyao ꞌediya yage gete sida simana. ");
INSERT INTO dob_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ta Yesu ꞌedaya ꞌilobedi ga ꞌilokagutokiyedi, ta simai ga ꞌaena sigitoodi ta sibwagobwago ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Geyaꞌabo wamatamatauta, ta esi watauya be gosegwao waemataluwedi be sitatauya Galili ꞌena, be nada sida ꞌitagu.” ");
INSERT INTO dob_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iine nidi maꞌetamo ꞌedaya sitautauya ta ꞌaliꞌali ꞌana toꞌitaꞌiꞌitao ꞌaidi sitauya ꞌasa Yelusalema ꞌenaya, ga toꞌase siapwesa nadigega sisimanena totaliyao sinabwadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ꞌEnega totaliyao nidi ta ꞌinapwanao maꞌediyao sideli egogona ga siloina, ga mani toꞌitaꞌiꞌitao nidi siꞌebwaꞌedi ");
INSERT INTO dob_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","be ꞌaene tomota ꞌediya sida simana dadana be ꞌaene sida gwae, “Boiboiya ꞌaꞌenoꞌeno ta Yesu ꞌina tononoyao simai ga kokowana siꞌipwalina.” ");
INSERT INTO dob_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wate sieonedi, sigwae, “ꞌEguma toloina sinabwana ale gete ꞌinonoi ꞌetamo ꞌakaboe be ꞌenega geyaꞌabo ꞌigamwagamwasowala ꞌemiya.” ");
INSERT INTO dob_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ꞌEnega ꞌidi mani siꞌewena ga totaliyao be ꞌinapwanao ꞌidi nuwanuwa nina siematamatanena. Ta ꞌidi emwasala gete ꞌiꞌelelewana me Yudia ꞌediya, ga batuwa wate nadigega sionaona. ");
INSERT INTO dob_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ꞌEnega Yesu ꞌina tononoyao site ilebeni sitauya Galili ga situꞌe ꞌoya nina Yesu ꞌisimanena ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ga Yesu siꞌitena ga ꞌena sibwagobwago. Ta ꞌaidi ꞌediyega ꞌetamo ma idi enuwanaluwa. ");
INSERT INTO dob_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ꞌEnega Yesu ꞌimai ꞌediya ta ꞌieonedi, ꞌigwae, “Tamagu loina maiboꞌana galewaya ta baleꞌuya niꞌatu ꞌiꞌebwaꞌegu. ");
INSERT INTO dob_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ꞌEnega watatauya be sena maiboꞌadi ꞌediya waloguguya, be ꞌenega tomota sida emisegu, be wate wagiebapitaisoedi Tamagu ꞌana esanega be Natuna ꞌaboꞌagu ꞌagu esanega be wate Yaluyaluwa Tabuna ꞌana esanega. ");
INSERT INTO dob_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ta loina maiboꞌana niꞌatu yaꞌebwaꞌemi waeꞌitadi be taudi wate sida muliyedi. Onaꞌaiꞌaila, ꞌaboꞌagu maꞌemiya yada miyami tuta yauyauna, batuwa ga ꞌana laba baleꞌu ꞌana ꞌebe losalowa ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Gete tetela boboꞌana Toꞌetoseyana Yesu, Tauna Yaubada natuna, tetelina ꞌana ꞌebe eꞌale. ");
INSERT INTO dob_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Lowaenei palopita Aisea Yesu manuna ꞌiꞌetoladina, ga Yaubada ꞌina ona ꞌisimanena, ꞌigwae: “Gete ꞌigu toepilialeale yaetune be ꞌinugana be manuyo ꞌeda ꞌikakali, ");
INSERT INTO dob_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","be sena mitawa daitaya ꞌenana sinabwana ꞌenega ꞌida simana apwesa be ꞌida gwae, ‘ꞌInapwana ꞌina ꞌeda wada kakali ta wagiepaepalu.’ ” ");
INSERT INTO dob_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ꞌEnega Yoni togiebapitaiso nina ꞌiapwesa sena mitawa daitaya ga ꞌiguguya tomota ꞌediya, ꞌigwae, “ꞌImi bubuna toꞌumalidi ꞌediyega wada nuwaꞌebuni be ꞌenega yada giebapitaisoemi ta Yaubada ꞌimi bubuna nidi ꞌida nuwataudi.” ");
INSERT INTO dob_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ta tomota yauyaudi sena Yudia maiboꞌana ꞌenega be ꞌasa Yelusalema ꞌenega sidelima Yoni ꞌina guguya sabi nonona, ga ꞌidi bubuna toꞌumalidi sisimanedi, ga ꞌigiebapitaisoedi bwasi Yolidani ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoni ꞌana ꞌoama yobai kameli unuununa tuga, ta ꞌana gadiwana kameli bwalana, ta ꞌana masulao bilolo be muꞌawa tuga. ");
INSERT INTO dob_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ta Yoni ꞌiguguya ga ꞌigwae, “Tauna muliguyega ꞌimeemai ꞌisinabwa sinegu, ꞌenega nigeya ꞌilobwelobwenegu be ꞌaenaya yabwagobwago be ꞌana ꞌaelawa yaliꞌami. ");
INSERT INTO dob_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ꞌAboꞌagu bwasiyega tuga yagiebapitaisoemi, ta tauna Yaluyaluwa Tabunega ꞌida giebapitaisoemi.” ");
INSERT INTO dob_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tuta gote ꞌenaya Yesu ꞌasa Nasaleta ꞌipilisinena, nate sena Galili ꞌenega, ga ꞌimai bwasi Yolidani ꞌenaya ga Yoni Yesu ꞌigiebapitaisoena. ");
INSERT INTO dob_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ta Yesu niꞌatu bwasiyega ꞌigayoꞌoyaꞌama ga ꞌiꞌitatuꞌe ta galewa ꞌiꞌitena ꞌiꞌegegena, ta Yaluyaluwa Tabuna ꞌana ꞌita ꞌatuwa bunebune ꞌimwaꞌuta ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ꞌEnega ꞌebweu ꞌenana galewega ꞌionama ꞌigwae, “ꞌOyo natuꞌaiꞌailigu, manuyo yagwausowala sinabwana.” ");
INSERT INTO dob_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gote ꞌenega ga Yaubada Yaluyaluwana Yesu ꞌietunena ga ꞌitauya mitawa daitaya, ");
INSERT INTO dob_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ga ꞌasiyata poti gote ꞌena ꞌimiyana ta tuta nidi ꞌediya Seitani ꞌitoo waiwai be ꞌaene Yesu ꞌigiebeꞌu. Ta sena nina ꞌenaya yobai bosasa wate simiyami, ta aneloseyao Yesu siꞌitaꞌiꞌisina. ");
INSERT INTO dob_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ga tuta nina ꞌena Kini Elodi ꞌiloina ga ꞌenega Yoni deliya sisaꞌu luguyena ga muliyega Yesu ꞌiapwesa Galili, ga Tetela boboꞌana Yaubada ꞌenega ꞌiloguguyaena, ");
INSERT INTO dob_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ꞌigwae, “Tuta niꞌatu ꞌiapwesama be Yaubada ꞌida etoloina ꞌedaya. ꞌEnega ꞌimi guinuwa toꞌumalidi ꞌediyega wada nuwaꞌebuni be Tetela boboꞌana wada emise.” ");
INSERT INTO dob_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ꞌEnega ꞌebweu tuta Yesu ola Galili leꞌawinaya ꞌiwadawadaꞌe ga togomana siteluwa matasina ꞌiꞌitedi Galili olanaya ꞌidi gomana siyauyauye, ꞌadi esanao Saimoni be Anidulu. ");
INSERT INTO dob_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ga Yesu ꞌibwauyedima, ꞌigwae, “Wamuliyegu be yada gibubumi tomota ꞌadi togomanao.” ");
INSERT INTO dob_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Gote ꞌena ꞌidi gomana sipilisinena ga Yesu simuliyena. ");
INSERT INTO dob_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ꞌEnega ꞌiawadaꞌe nao tupwana ga Yemesa be Yoni, taudi Sebedi natunao, ꞌiꞌitedi wagaya ꞌidi gomana sigibugibudi, ");
INSERT INTO dob_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ga ꞌibwauyedima, ga tamadiya ma ina topaisewao siebesinedi nada wagaya ta Yesu simuliyena. ");
INSERT INTO dob_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ga muliyega simai ꞌasa sinabwana ꞌana esana Kapaneumi ꞌenaya, ga Sabateya Yesu anuwa tapwalolo ꞌena ꞌilugu ga ꞌieꞌita. ");
INSERT INTO dob_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ta tomota maiboꞌadi nuwadi ꞌiowana ꞌina eꞌita manuna, ga sigwae, “Eꞌita gete palupaluna ta waiwaina, ta ꞌida loina ꞌana toeꞌitao ꞌidi eꞌita nenetana.” ");
INSERT INTO dob_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ta anuwa tapwalolo nina ꞌenaya ꞌebweu tai ꞌimiyami, ta tai nina ꞌenaya yaluyaluwa biꞌi lowa ꞌilugu ga ꞌimiyami, ꞌenega tai nina Yesu ꞌena ꞌibwau, ");
INSERT INTO dob_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ꞌigwae, “Yesu, ꞌoyo goma Nasaleta, toꞌase ꞌalena ga ꞌumai ꞌemaya? Nuwanuwayo be ꞌaene ꞌuda peꞌuma, aga? Ta ꞌoyo saꞌi niꞌatu yamwalatonimu, ꞌoyo tuga Yaubada Natuna.” ");
INSERT INTO dob_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ta Yesu ꞌiloinena, ꞌigwae, “ꞌUlosaꞌu be tai nate ꞌenega ꞌuapwesama.” ");
INSERT INTO dob_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ꞌEnega yaluyaluwa biꞌi tai nina ꞌigietaina ga ꞌidededela ta ꞌimagana toila ga muliyega yaluyaluwa biꞌi tai solanega ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ꞌEnega tomota maiboꞌadi silosuyaedi ga taudimo sienaidedi, sigwae, “Mwaꞌadega eꞌita auwauna gete? Gete tai nina ꞌina loinega yaluyaluwa biꞌi ꞌiloiloinedi ta siematamatane.” ");
INSERT INTO dob_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ꞌEnega Yesu tetelina silelewanena Galili senanao maiboꞌadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ta Yesu anuwa tapwalolo ꞌenega ꞌiapwesa ga Yemesa be Yoni maꞌenao sitauya Saimoni be Anidulu ꞌidi anuwaya. ");
INSERT INTO dob_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ga Saimoni lawana ooyaiyaiyega ꞌileꞌoasa, ꞌenega Yesu siemataluwena toleꞌoasa nina manuna. ");
INSERT INTO dob_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ga Yesu ꞌilugu ꞌenaya ga nimanaya ꞌigiyaina ga ꞌigietoolona, ga ꞌina leꞌoasa ꞌisaligogo. ꞌEnega waine nina ꞌiapwesa ga ꞌadi masula ꞌigibubuna. ");
INSERT INTO dob_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ta sinala niꞌatu ꞌisugusuguwa, ga tomota ꞌidi toleꞌoasao be taudi yaluyaluwa biꞌi ꞌediyega sileꞌoasa maiboꞌadi simeꞌedi Yesu ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","be wate ꞌasa ꞌana tomiyanao maiboꞌadi siegogonama ga anuwa nina matanaya sitoolo. ");
INSERT INTO dob_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ꞌEnega toleꞌoasao yaudi be taudi yaluyaluwa biꞌi ꞌigie kabaleyedi maiboꞌadi Yesu ꞌigie boboꞌanedi. Ta yaluyaluwa biꞌi ꞌeguma ꞌiula apwesedi ꞌiꞌetobodedi be geyaꞌabo sisimasimane, manuna tauna simwalatonina. ");
INSERT INTO dob_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ta ꞌenega gonamapumapuya Yesu ꞌitoolo ga anuwega ꞌiapwesa ga tebweuna ꞌitauya mwatui daitaya ga ꞌisidasida Yaubada ꞌena. ");
INSERT INTO dob_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ta Saimoni magosenao wate siapwesa ga Yesu siꞌebesena, ");
INSERT INTO dob_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ga silobenaya ta sieonena, “Tomota yaudi nuwanuwadi ꞌoyo.” ");
INSERT INTO dob_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ta Yesu ꞌigwae, “Tatatauya ꞌaina wate ꞌasa ꞌediya be yaloguguya. Gete manuna yamai.” ");
INSERT INTO dob_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ꞌEnega Galili maiboꞌana ꞌiasakowasiyena ga ꞌidi anuwa tapwalolo ꞌediya ꞌiloguguya ta wate yaluyaluwa biꞌi tomota ꞌediyega ꞌiula apwesedi. ");
INSERT INTO dob_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ta tolepelo ꞌebweuna Yesu ꞌena ꞌimai ga ꞌiꞌaetulasaya ta ꞌisidena, ꞌigwae, “ꞌEguma ꞌimu nuwanuwa nadigega, kapekapeyana be ꞌugie boboꞌanegu.” ");
INSERT INTO dob_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ꞌEnega Yesu ꞌiꞌatenuwa ꞌoleꞌoleyena ga nimanega tai bwalana ꞌigitoona ta ꞌigwae, “O boboꞌana! ꞌUda ꞌesasa!” ");
INSERT INTO dob_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ga tai nina ꞌana lepelo ꞌigumwala manini, ga ꞌiꞌesasena. ");
INSERT INTO dob_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ta Yesu tai nina ꞌiꞌena paꞌalena, ");
INSERT INTO dob_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ꞌigwae, “ꞌUtatauya ta geyaꞌabo ꞌebweu wate yaita ꞌena ꞌusimasimanegu, ta esi palupaluna ꞌutatauya totaliya ꞌenaya be ꞌiꞌitayo, be ꞌenega ꞌimu taliya ꞌuꞌebwaya Yaubada ꞌena, toꞌase nadigega ꞌada loina Mosese ꞌenega, be ꞌenega tomota simwalatoniyo ꞌaene niꞌatu ꞌuꞌesasemu.” ");
INSERT INTO dob_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ta tolepelo nina nigeya Yesu ꞌina loina ꞌiematamatane, ta tomota yaudi ꞌediya ꞌiesimasimana. ꞌEnega Yesu nigeya sawesawenaya ꞌiaꞌataꞌatamana ꞌasa nidi soladiya, ta ꞌenega ꞌitauya sena mwatui daitaya ga nada ꞌimiyamiya, ta tomota sena yaudi ꞌediyega sitauya ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ꞌAsiyata ꞌaina sigumwala ga Yesu ꞌiila Kapaneumi ꞌenaya, ga alena sinonona ꞌaene Yesu niꞌatu ꞌiila limanama. ");
INSERT INTO dob_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta ꞌenega pwalu sinabwana anuwa solanaya be wate ꞌawa ꞌatamaninaya siegogona, ga Yesu ꞌiguguya ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ta tokweno ꞌebweu simeꞌena ta ꞌana toꞌaalao site ata ꞌebe ꞌenoega siꞌaalinama, ");
INSERT INTO dob_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ga sitoona be ꞌaene tokweno nina siluguye Yesu ꞌena, ta nigeya sawesawediya, manuna pwalu sinabwa wawasae, ꞌenega siꞌaala tuꞌeyena anuwa debanaya ga ꞌana ꞌatowa siꞌewayaulena, ta ꞌenega tokweno nina ma ꞌebeꞌenona sietabetabeyena ga Yesu matanaya sisaꞌuna. ");
INSERT INTO dob_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ꞌEnega Yesu niꞌatu tai nidi ꞌidi emisa ꞌimwalatonina ga tokweno nina ꞌieonena, “Natugu, ꞌimu bubuna toꞌumalidi ꞌadi nuwatau niꞌatu ꞌulobedi.” ");
INSERT INTO dob_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ta ꞌaina loina ꞌana toeꞌitao Yesu selabenaya simiyami ga ꞌina ona sinonona ga taudimo ꞌatediya sinuwanuwa, ");
INSERT INTO dob_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Yesu gete mwaꞌadega ga Yaubada ꞌena ꞌioopaꞌala? Manuna nigeya ꞌebweu yaita sawesawenaya be tomota ꞌidi bubuna toꞌumalina ꞌida nuwataudi, nate namo Yaubada sawesawenaya.” ");
INSERT INTO dob_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ta Yesu niꞌatu ꞌatenaya ꞌidi nuwanuwa ꞌimwalatonina, ꞌenega ꞌieonedi, “Toꞌase manuna nate nadigega wanuwanuwaꞌesa? ");
INSERT INTO dob_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ta toꞌase wanuwena yada onae tokweno gete ꞌenaya be ꞌaene yada gwae, ‘ꞌImu bubuna toꞌumalina niꞌatu yanuwataudi,’ nai yada gwae, ‘ꞌUtoolo be ꞌimu ꞌebeꞌeno ꞌuꞌaali be ꞌutatauya’? ");
INSERT INTO dob_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ta wada mwalatoni ꞌaene ꞌaboꞌagu Tomota Natuna, be ma igu loina baleꞌuya be tomota ꞌidi bubuna toꞌumalina yanuwataudi.” ");
INSERT INTO dob_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ꞌEnega tokweno nina ꞌieonena, ꞌigwae, “ꞌAboꞌagu gete yaeonayo, ‘ꞌUtoolo be ꞌimu ꞌebeꞌeno ꞌuꞌaala be ꞌutatauya ꞌimu ꞌasaya.’ ” ");
INSERT INTO dob_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ta ꞌenega ꞌitoolo ga ꞌina ꞌebeꞌeno ꞌiꞌaalena ga boda matadiyega ꞌiapwesa. Gote ꞌena pwalu maiboꞌadi nuwadi ꞌiowana ta Yaubada situpuna, sigwae, “Guinuwa gete ꞌebe nuwaowana ga batuwa namo taꞌitena.” ");
INSERT INTO dob_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ꞌEnega Yesu ꞌiapwesa limana Galili leꞌawinaya, ta wate pwalu siegogonama, ga ꞌieꞌita ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ta ꞌina eꞌita ꞌilosalonina ga ꞌitautauya ga ꞌebweu takisi ꞌana toꞌewa ꞌiꞌitena ꞌina anuwa ꞌebe paisewa ꞌena ꞌimiyami. Tai nina Libai, ta tamana Alipio. Ga Yesu ꞌieonena, “Libai ꞌumuliyegu.” ꞌEnega Libai nina ꞌitoolo ga Yesu ꞌimuliyena. ");
INSERT INTO dob_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ta muliyega Yesu ma ina tononoyao simai Libai ꞌina anuwaya sabi ꞌeꞌai, ga boda Yesu simuliyena, taudi takisi ꞌana toꞌewao be wate ꞌaidi totoꞌumalidi, ga Yesu ma ina tononoyao maꞌediyao simiyatowa. ");
INSERT INTO dob_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ꞌEnega Palisi ꞌidi loina ꞌana toeꞌitao siꞌitena, ga Yesu ꞌina tononoyao ꞌediya sienaida, sigwae, “Toꞌase manuna ꞌimi toeꞌita takisi ꞌana toꞌewao ta wate totoꞌumalidi ꞌaina maꞌenao siꞌeꞌai egogona?” ");
INSERT INTO dob_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ta Yesu ona gete ꞌinonona ga ꞌieonedi, “Taudi boboꞌadi geya nuwadi togileꞌoasa, ta toleꞌoasao esiya nuwanuwadi togileꞌoasa. ꞌAboꞌagu yamaiya nigeya topalupaludi manudi, ta totoꞌumalidi sabi lemedi.” ");
INSERT INTO dob_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ta Yoni ꞌina tononoyao be wate Palisiyao ꞌeꞌai ꞌenega siedidigula ꞌidi tapwalolo manuna, ꞌenega ꞌaina tomota Yesu ꞌena simai ga sieonena, sigwae, “Yoni ꞌina tononoyao be wate Palisiyao ꞌidi tononoyao siedidigula, ta mwaꞌadega ga ꞌenega ꞌimu tononoyao nigeya siediedidigula?” ");
INSERT INTO dob_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ꞌEnega Yesu ona semalimaliyega ꞌieonedi, ꞌigwae, “Mwaꞌadega, ꞌilobwenena be ai ꞌana toyoꞌoyao siedidigula ꞌabo toai meꞌolotona maꞌediya simiyami? Nigeya saꞌi! Manuna tauna maꞌenao maiboꞌadi siegwausowala. ");
INSERT INTO dob_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ta wanuwaꞌiꞌisi ꞌaene tuta ꞌimeemai be toai nina ꞌipilisinedi, ꞌenega esi sinuwa mwau be siedidigula ta siꞌebotana.” ");
INSERT INTO dob_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ta ꞌebweu wate onasemalimali ꞌiꞌebwaꞌedi, ꞌigwae, “Nigeya sawesawenaya be kaleko auwauna senasenaminega ꞌoama kadekadelina tabwabwada, ꞌabona nai esabu nina ꞌiesabu toili. ");
INSERT INTO dob_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ta wate nigeya ꞌebweu yaita oine auwauna ꞌida siwena bwala ꞌebesiwa kadekadelidi ꞌediya, ꞌabona nai siꞌalasabudi be oine ta ꞌebesiwa ꞌadi mudala, ta esi tada siwai ꞌebesiwa auwau daisinamo ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabateya Yesu ma ina tononoyao bagula solanega sitauya ga tonono nidi witi atuna siꞌegitagedi ga siꞌenidi. ");
INSERT INTO dob_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ta Palisiyao siꞌitediya ga Yesu sieonena, sigwae, “ꞌInapwana, mwaꞌadega ga ꞌenega ꞌimu tononoyao Sabate ꞌana loina sileꞌoaleꞌoa?” ");
INSERT INTO dob_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Buki Tabu ꞌena siꞌetoladina Debida manuna be ꞌeguma wasawai, wada mwalatoni ꞌaene tauna magosenao sibotana sinabwana, ");
INSERT INTO dob_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ꞌenega Yaubada ꞌina anuwaya ꞌilugu ga beledi etaetabuna ꞌiꞌewena ga siꞌenina. Beledi nina ma ꞌana loina ꞌaene totaliya dimo ꞌadi tagwala be sida ꞌani. Ta tuwa tuga sibotana, ꞌenega totaliya sinabwana, ꞌana esana Ebayada, ꞌitagwalena ga siꞌenina.” ");
INSERT INTO dob_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ꞌEnega Yesu ꞌieonedi wate, ꞌigwae, “Yaubada Sabate ꞌiꞌebwaꞌeda ꞌida boboꞌana manuna, nigeya ꞌaene ꞌimweluluida Sabate manuna. ");
INSERT INTO dob_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Manuna ꞌaboꞌagu Tomota Natuna ta wate Sabate ꞌana ꞌinapwana.” ");
INSERT INTO dob_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ꞌEnega muliyega Yesu ꞌiila limana anuwa tapwalolo ꞌenaya ga nada ꞌebweu tai nima meyomeyona ꞌilobena. ");
INSERT INTO dob_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ta Palisiyao Yesu silomataꞌiꞌisi, be ꞌeguma tai nina ꞌigieboboꞌane Sabate ꞌenaya maꞌetamo ꞌenega sida eꞌewa. ");
INSERT INTO dob_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ꞌEnega Yesu tai nina ꞌieonena, “ꞌUtoolo be ꞌulagama,” ga tai nina ꞌitoolo ga ꞌilaga. ");
INSERT INTO dob_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ga Yesu ꞌinapwanao ꞌieonedi, ꞌigwae, “Gete ꞌigu enaida ꞌemiya: To guinuwa boboꞌana ꞌedaya? Sabate ꞌena talelema nai tagieꞌelouya? Taꞌetoseyana nai taloemwawasa?” Ga ꞌina ona nigeya sieꞌieꞌisa. ");
INSERT INTO dob_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ta Yesu ꞌidune masimasiyedi ma ina gamwasowala ta ma ina nuwamwau ꞌidi debapaꞌala manuna, ga tai nina ꞌieonena, ꞌigwae, “Nimayo ꞌuyasitoto,” ga tai nimana ꞌiyasitotona ga ꞌiboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ꞌEnega Palisiyao ma idi gamwasowala siapwesa ga Elodi ꞌina bodao maꞌediyao siloiloina be mwaꞌadega Yesu sida loemwawasaꞌese. ");
INSERT INTO dob_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ꞌEnega Yesu ꞌipilisinedi ga ma ina tononoyao sidolo Galili leꞌawinaya, ta pwalu sinabwana simuliyenama. ");
INSERT INTO dob_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Boda nidi getedi Yesu alena sinononaya ta Galiliyega be Yudiaega be Yelusalemega be Idumea senanega be Yolidani mali senega ta ꞌaina ꞌasa nidi Taiya be Saidoni selabediyega siegogonama. ");
INSERT INTO dob_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ta Yesu toleꞌoasao ꞌigieboboꞌanedi, ꞌenega toleꞌoasao yaudi siegigigilama sabi gitoona, ꞌenega Yesu ꞌina tononoyao ꞌieonedi, “Waga manugu wameꞌe be ꞌabo tomota siegigigila wawasae yagegelu wagaya.” ");
INSERT INTO dob_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ta tomotai nidi ꞌediya yaluyaluwa biꞌi siluguya, ꞌeguma Yesu siꞌitai, sibeꞌu sanamwaꞌuta matanaya ta sibwaubwau, sigwae, “ꞌOyo Yaubada Natuna.” ");
INSERT INTO dob_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ta Yesu ꞌiloina paꞌaledi, ꞌigwae, “Geyaꞌabo wabwaubwau apwesa ꞌaene ꞌaboꞌagu Yaubada Natuna.” ");
INSERT INTO dob_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ꞌEnega muliyega ꞌoyaya ꞌituꞌe ga ꞌina tononoyao nidi ꞌiesinuwediya ga ꞌibwauyedi ga situꞌema ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ga ꞌieonedi, ꞌigwae, “ꞌOmi wate tuwelo yaesinuwemiya be ꞌomi maꞌegwao tamiyami be muliyega yaetunemi ꞌaina sena ꞌediya be wada loguguya ");
INSERT INTO dob_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ta waiwaiyega yaluyaluwa biꞌi tomota ꞌediyega wada ula apwesedi.” ");
INSERT INTO dob_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ta ꞌadi esanao getedi: Saimoni (tauna wate ꞌieesena Pita); ");
INSERT INTO dob_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ta wate Yemesa matasina Yoni, taudi Sebedi natunao, ta Yesu ꞌieesedi Bowanage (ta Bowanage ꞌana mwalatoi ꞌaene taudi ꞌatuwa wepalala nadigega); ");
INSERT INTO dob_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ta wate Anidulu be, Pilipi be, Batolomiu be, Madiu be, Tomasi be, mali Yemesa tauna Alipio natuna be, Tadiasi be, mali Saimoni, tauna togewana ꞌebeloina manuna; ");
INSERT INTO dob_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ta wate Yudasa Isikaliota, tauna maꞌetamo Yesu ꞌida sipupuye. ");
INSERT INTO dob_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ꞌEnega muliyega Yesu ꞌiila ꞌina ꞌasaya, ta boda sinabwa wawasae siegogona ꞌenaya ga nigeya sawesawenaya Yesu ma ina tononoyao sieyawaiꞌata be siꞌaꞌa. ");
INSERT INTO dob_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ta ꞌina susuyao sinonona ꞌaene Yesu nigeya ꞌida eyawaiꞌata, ꞌenega sitauya sabi ꞌauꞌewenama, manuna sinuwena ꞌaene, “Niꞌatu ꞌikabaleya.” ");
INSERT INTO dob_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ta loina ꞌana toeꞌitao ꞌaidi niꞌatu Yelusalemega simwaꞌutama ga Yesu ꞌina paisewa sinabwana siꞌitenaya ga sigwae, “Tai gete ꞌietoguinuwa manuna Bielisibubi, yaluyaluwa biꞌi ꞌidi ꞌinapwana ꞌina waiwaiyega yaluyaluwa biꞌi ꞌiula apwesedi.” ");
INSERT INTO dob_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ꞌEnega Yesu tomota nidi ꞌibwauyedima ga onasemalimaliyega ꞌieꞌita ꞌediya, ꞌigwae, “Toꞌase manuna Seitani ꞌaene tauna ꞌana bodao ꞌediya ꞌida etalauwala?” ");
INSERT INTO dob_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ta wate ꞌigwae, “ꞌEguma ꞌebweu ꞌebeloina ꞌenaya tomotai siweweyala be taudimo silosalosaiya maꞌetamo ꞌebeloina nina ꞌineneneta be ꞌibebeꞌu. ");
INSERT INTO dob_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wate ꞌeguma susu ꞌebweuna ta siweweyala be taudimo silosalosaiya maꞌetamo sineneta be ꞌidi miya ꞌitoꞌumali. ");
INSERT INTO dob_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Seitani wate nadigega, ꞌeguma ma gosenao taudimo silosaiya ꞌiabe ꞌina ꞌebeloina nina ꞌibebeꞌu be ꞌigugumwala. ");
INSERT INTO dob_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ꞌEbeꞌita gete tai waiwaina nadigega Seitani ꞌina anuwaya. Nigeya sawesawenaya ꞌebweu yaita ꞌilulugu be ꞌina gwegwe ꞌiloꞌewadi, ta esi ꞌeguma ꞌebweu tai balaeyega toewaiwai nina nimana be ꞌaena ꞌiyona nuganedi ta ꞌenega muliyega sawesawenaya ꞌilulugu ꞌina anuwaya be ꞌina gwegwe nidi ꞌiloꞌewadi. ");
INSERT INTO dob_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","ꞌEnega gete yaeona ꞌaiꞌailimi ꞌaene tomota ꞌidi loegesiyao be ꞌidi ona toꞌumalina maiboꞌana Yaubada ꞌida nuwataudi, ");
INSERT INTO dob_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ta ꞌabo yaita Yaluyaluwa Tabuna ꞌiꞌawa toꞌumaliyei, geyaꞌabo saꞌi Yaubada ꞌinuwanuwatau, ta gete bubuna toꞌumalina nina ꞌenaya ꞌida miyaataya.” ");
INSERT INTO dob_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Gete nadigega Yesu ꞌionaꞌesa manuna sionaona ꞌaene tauna ꞌina waiwai yaluyaluwa biꞌi ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ꞌEnega niꞌatu Yesu sinana ta tasinao simai ga ꞌatamanaya sitoolo, ta ꞌenega ona namo sietunena be ꞌaene Yesu ꞌida apwesama ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ga tomota nidi Yesu selabenaya simiyatowa sieonena, “ꞌInapwana, sinayo be tasimwao waꞌita apwesa, ta nuwanuwadi ꞌoyo.” ");
INSERT INTO dob_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ga Yesu ꞌieonedi, ꞌigwae, “Yaita sinagu ta yaisigedi tasigwao?” ");
INSERT INTO dob_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ga taudi nidi selabenaya simiyami ꞌiduneyediya ta ꞌigwae, “Gete taudi sinagu be tasigwao. ");
INSERT INTO dob_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ꞌEnega ꞌeguma yaisigedi Yaubada ꞌina nuwanuwa simulimuliye taudi tasigwao be nuugwao be wate sinagwao.” ");
INSERT INTO dob_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Muliyega wate Yesu ꞌiila limana Galili leꞌawinaya sabi loguguya ta boda sinabwana siegogona ꞌenaya, ꞌenega ꞌebweu waga ꞌidoedoe ꞌenaya ꞌigelu ga ꞌimiyatowa, ta pwalu leꞌawaya sitootoolo. ");
INSERT INTO dob_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ta Yesu onasemalimali yauna ꞌediyega ꞌieꞌita tomota ꞌediya, ꞌigwaegwae, ");
INSERT INTO dob_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wanono! Tobagula ꞌebweu ꞌina bagulaya ꞌitauya ga witi atuna ꞌilelewanedi, ");
INSERT INTO dob_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ga ꞌaina atu nidi ꞌedaya sibeꞌu, ꞌenega manuwa siꞌitedi ta simwaꞌuta ga siꞌenidi. ");
INSERT INTO dob_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ta ꞌaina sibeꞌu bwaꞌa logulegulewana ꞌenaya ga sitabwa manini, manuna bwaꞌa gidalina tuga, ");
INSERT INTO dob_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ꞌenega ala ꞌitudimwedi ga siꞌoapelu, manuna lamudi nigeya bwaꞌa gonituna silobaloba. ");
INSERT INTO dob_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ta ꞌaina kwakwakwala ꞌediya sibeꞌu ga sitabwa enoenowa, ta nigeya kapekapeyana be siuuwa, manuna kwakwakwala ꞌiewaiwai ga ꞌididiemwawasidi. ");
INSERT INTO dob_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ta ꞌaina atu bwaꞌa boboꞌana ꞌenaya sibeꞌu ga sitabwa ta sisinabwa ga siuwa, ga ꞌaina teti, be sikisiti, be analedi.” ");
INSERT INTO dob_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ga Yesu ꞌieonedi, ꞌigwae, “ꞌEguma matenami ona gete wada nono.” ");
INSERT INTO dob_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Muliyega pwalu sidelisawala ga Yesu taunamo, ga ꞌaina tomota ta ꞌina tononoyao site tuwelo maꞌediyao simai ga Yesu ꞌena sienaida, sigwae, “ꞌImu onasemalimali nidi toꞌase ꞌadi mwalatoi?” ");
INSERT INTO dob_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta Yesu ꞌigwae, “ꞌOmi niꞌatu Yaubada ꞌemiya ꞌiꞌebwaya be ꞌina loina solaꞌaiꞌailidi ꞌana tomwalatoiyao, ta esi tomota yaudi nuwa potapotadi ga onasemalimali sinono, ");
INSERT INTO dob_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ta ꞌana nuwasabwalena nigeya simwalamwalatoni, ta wate ꞌana mwalatoi siꞌebeꞌebese ta nigeya sawesawenaya siloba. ꞌEnega wate nigeya sawesawenaya ꞌidi loegesiyao ꞌediyega sinuwanuwaꞌebuni, be geyaꞌabo Yaubada ꞌinuwanuwataudi.” ");
INSERT INTO dob_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Mwaꞌadega ꞌigu onasemalimali gete nigeya wanuwanuwa sabwaleni, aga? Be mwaꞌadega ꞌaina onasemalimali gete nadigega wada nuwasabwalenidi? ");
INSERT INTO dob_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Tobagula nina Yaubada ꞌina ona ꞌilelewanena. ");
INSERT INTO dob_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ꞌAidi atu sibeꞌu ꞌedaya, ꞌatuwa nadigega tomotai Yaubada ꞌina ona sinonona, ta ꞌenega Seitani ꞌimai ga ona nina ꞌediyega ꞌiꞌewa yauledi. ");
INSERT INTO dob_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Wate nadigega atu nidi bwaꞌa logulegulewana ꞌenaya sibeꞌubeꞌu, ꞌaene ꞌabo tomota nidi Yaubada ꞌina ona sinonoi ta ma idi gwausowala sitatagwala, ");
INSERT INTO dob_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ta nigeya lamudi ꞌipaꞌapaꞌala, ꞌenega tuta gidalina namo ꞌenaya sida miyami, be ꞌabo to tuta ꞌenaya Yaubada ꞌina ona ꞌana emisa manuna mwau nai etalauwala silobai, sibeꞌu manini. ");
INSERT INTO dob_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ta atu nidi kwakwakwala ꞌediya sibeꞌuya ꞌatuwa tomota nidi taudi Yaubada ꞌina ona sinonona, ");
INSERT INTO dob_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ta esaesa be baleꞌu ꞌina yageyao ꞌadi nuwanuwa ꞌediyega Yaubada ꞌina ona sinuwa pupulena, ꞌenega nigeya sawesawenaya be siuuwa. ");
INSERT INTO dob_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Ta atu nidi bwaꞌa boboꞌana ꞌena sibeꞌuya ꞌatuwa tomota nidi taudi ma idi ꞌatetagwala Yaubada ꞌina ona sinonona, ꞌenega uwadi boboꞌana ta yauna siuwaedi. ꞌAina uwadiyao teti, ta ꞌaina sikisiti, ta ꞌaina analedi.” ");
INSERT INTO dob_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ta Yesu wate ꞌediya ꞌigwae, “Geyaꞌabo mayale loeloeꞌabina tasaꞌusaꞌu kwaiye ꞌule nai sita ꞌediyega, ta esi ꞌatamanaya tasaꞌu be ꞌimaedana, ");
INSERT INTO dob_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","be ꞌenega yage nidi kwaikwaiyidi maꞌetamo maedana nina ꞌigieapwesedi be taꞌitadi. ");
INSERT INTO dob_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ꞌEguma matenami ona gete wada nono.” ");
INSERT INTO dob_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ta wate ꞌieonedi, “Wada nuwaꞌiꞌisi be ona wada nono ꞌaiꞌailidi, manuna ꞌeguma ꞌomi toꞌase waꞌebwaya, wate nadigega ꞌana eꞌisa waꞌewa, ta esi ma ꞌana loeposeyana. ");
INSERT INTO dob_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Manuna ꞌeguma yaita ꞌenaya Yaubada ꞌina gwegwe ꞌimiyami, gwegwe nina ꞌiloeposeyane. Ta yaita ꞌenaya nigeya Yaubada ꞌina gwegwe ꞌimiyami, toꞌase ꞌena ꞌimiyami Yaubada ꞌenega ꞌiꞌewa yauledi.” ");
INSERT INTO dob_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ga Yesu ꞌigwae, “Yaubada ꞌina loina tomota ꞌediya ꞌatuwa nadigega suwana tai ꞌina tanowaya ꞌiasodi, ");
INSERT INTO dob_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ta tai nina ꞌiꞌeno be ꞌitoolo ꞌasiyata be boiboiya, ta suwana nidi sitabwatabwa, ta nigeya ꞌimwalamwalatoni mwaꞌadega sitabwatabwaꞌesa. ");
INSERT INTO dob_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Manuna bwaꞌa ꞌiloina ꞌidi tabwa be ꞌidi sinabwa be ꞌidi uwa manuna, ");
INSERT INTO dob_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","be muliyega ꞌabo uwana ꞌimatuwa ꞌenega toni bagula nina ꞌieꞌale be ꞌisesoni.” ");
INSERT INTO dob_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu wate ꞌieonedi, ꞌigwae, “Mwaꞌadega Yaubada ꞌina loina onasemalimaliyega yada giemaedanaꞌese ꞌemiya? ");
INSERT INTO dob_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nai gete nadigega ꞌebweu kaiwe atuna ꞌenaya yada loesawaꞌiꞌi, nate beno, manuna beno atuna gidalina, ");
INSERT INTO dob_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ta ꞌabo taasoi be ꞌitatabwa pwatula ꞌisinabwa sinedi, ta nalinao sinabwadi ꞌisaꞌudi, be nalinao yauyaukwidi ꞌediya manuwa ꞌidi newa siꞌabidi.” ");
INSERT INTO dob_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ꞌina loguguyao ꞌediya tuta yauna onasemalimali yauna ꞌediyega ꞌieꞌieꞌita, be ꞌenega ꞌabo tomota ꞌediya kapekapeyana sida mwalatoni. ");
INSERT INTO dob_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tauna tuta yauna onasemalimaliyega ꞌiloguloguguya pwalu ꞌediya, ta ꞌina tononoyao dimo ꞌediya onasemalimali nidi ꞌiliꞌaliꞌamidi. ");
INSERT INTO dob_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ꞌAsuinuwanuwaya Yesu ꞌina loguguya wagega ꞌilosalonina ga ꞌina tononoyao ꞌieonedi, ꞌigwae, “Wageluma be taabala mali esenaya.” ");
INSERT INTO dob_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ꞌEnega sigelu ga sigiseyana ga pwalu leꞌawaya sipilisinedi, ta ꞌaidi waga wate maꞌenao, ");
INSERT INTO dob_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ga wediliya sinabwana ꞌitowama, ta lisu wagaya ꞌisiwasiwaꞌoyaꞌa ga ꞌiabe sidadamana. ");
INSERT INTO dob_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ta Yesu waga kuliginaya ꞌana gedu ꞌisaꞌuna ga ꞌiꞌeno mwataya, ta ꞌina tononoyao silowanowanona ga sigwae, “ꞌInapwana ꞌutoolo be ꞌulemeda. ꞌIabe tamwamwawasa!” ");
INSERT INTO dob_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ꞌEnega Yesu ꞌitoolo ga yagila be lisu ꞌibaꞌedi, ꞌigwae, “Tuwa! ꞌUꞌemutuyo be ꞌusiwalowa!” ꞌEnega yagila ꞌipela ga bwagabwaga maiboꞌana ꞌisiwalowa. ");
INSERT INTO dob_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ta ꞌina tononoyao ꞌediya ꞌigwae, “Toꞌase manuna wamatauta? Mwaꞌadega nigeya waemiemisegu?” ");
INSERT INTO dob_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ta nuwadi ꞌiowana ga simatauta, ta taudimo ꞌediya sigwae, “To tai sana gete ga yagila be lisu ꞌenana siematamatanena?” ");
INSERT INTO dob_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ꞌEnega siabala ga silugu me Gelasine ꞌidi leꞌawaya, ");
INSERT INTO dob_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ga wagega Yesu ꞌisuya dabalaya, ta tai ꞌebweu ꞌilobena mayaluyaluwa biꞌina ꞌina ꞌebemiya duluwa, ꞌenega ꞌiapwesama, ta duluwa nina tomota ꞌadi ꞌaliꞌali. ");
INSERT INTO dob_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ta tai gete lowa tomota sitoo be ꞌaene sida yoni malakwa kainumu ꞌenega, ta nigeya sawesawediya, ");
INSERT INTO dob_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","manuna malakwa nidi nimanaya be ꞌaenaya tuta yauna ꞌilasalasadi ta nigeya ꞌebweu sawesawenaya be ꞌigiyai, ");
INSERT INTO dob_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ta ꞌidena sinedi ga ꞌitauya mitawaya ta boiboiya be ꞌasiyataya ꞌaliꞌaliya be ꞌoyaya ꞌiemagamagana, ta tauna gulewega ꞌiunuunu. ");
INSERT INTO dob_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ta tai nina niꞌatu ꞌedasolega Yesu ꞌiꞌitenama, ꞌenega ꞌipili ga Yesu matanaya ꞌilobwagoena, ");
INSERT INTO dob_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ta ꞌimagana toila, ꞌigwae, “Yesu ye, ꞌoyo Yaubada Toewaiwai sana Natuna, toꞌase ꞌutootoo be ꞌuguinuwe ꞌeguya? Tuwa! Yaubada ꞌana esanega yasida ꞌemuya be geyaꞌabo ꞌuda giegieꞌelouyagu.” ");
INSERT INTO dob_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ona gete ꞌiꞌinanena manuna Yesu niꞌatu ꞌieonena, “Yaluyaluwa biꞌi niyo tai gete ꞌenega ꞌuapwesama.” ");
INSERT INTO dob_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ta Yesu wate ꞌienaida yaluyaluwa nina ꞌena, ꞌigwae, “Mwaꞌadega ꞌamu esana?” Ga tauna ꞌigwae, “ꞌAgu esana Tomoyauyau, manuna mabodama tai gete solanaya ꞌamiyami.” ");
INSERT INTO dob_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ga ꞌisidasida gewagewana Yesu ꞌena ꞌaene geyaꞌabo ꞌasa gote ꞌenega ꞌietuetune apwesedi. ");
INSERT INTO dob_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ta sena gote ꞌenaya bawe yauna siduwaduwala ꞌoyaya. ");
INSERT INTO dob_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ta yaluyaluwa biꞌi nidi sisida Yesu ꞌenaya ga sigwae, “Uetunema be ꞌalulugu bawe gotedi ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ꞌEnega Yesu ꞌitagwaledi ga yaluyaluwa biꞌi tai nina ꞌenega siapwesa ga bawe ꞌediya silugu, ꞌenega bawe nidi siekabaleya ga maiboꞌadi sipili bulibuliyasu ga babagega sisobu olaya ga sidamana. Ta bawe nidi ꞌadi yau nadigega tu tausani. ");
INSERT INTO dob_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ꞌEnega bawe ꞌadi toꞌitaꞌiꞌitao ꞌidi matautega sidena ga sitauya ꞌasaya, ga yage nidi siꞌitedi maiboꞌana sisimanedi ꞌasa sinabwana be ꞌasa gidalidi tomotenidi ꞌediya. ꞌEnega toniꞌasa nidi simai be ꞌaene taudi matadiyega sida ꞌita toꞌase ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ta Yesu ꞌena simai ga tai nina bada siꞌitena, lowa yaluyaluwa biꞌi solanaya simiyami niꞌatu debana ꞌipalupalu ga ꞌoama ꞌiꞌotena ta ꞌimiyami. Gote ꞌena maiboꞌadi simatauta. ");
INSERT INTO dob_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ꞌEnega toepilialeale nidi tomotai ꞌediya siemwasala mwaꞌadega tai nina ꞌiboboꞌanaꞌesa, ta mwaꞌadega bawe siesilaeꞌesa. ");
INSERT INTO dob_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ta toniꞌasa nidi silolagata ga Yesu sieꞌidiꞌidiyena ꞌaene ꞌidi sena ꞌida pilisine. ");
INSERT INTO dob_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ꞌEnega Yesu wagaya ꞌidolodolo sabi gelu, ta tai nina niꞌa ꞌigieboboꞌanena Yesu ꞌena ꞌisida, ꞌigwae, “ꞌInapwana, sawesawenaya yamuliyeyo?” ");
INSERT INTO dob_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ta Yesu ꞌigwae, “Nigeya sawesawenaya, ta esi ꞌuila be ꞌutatauya ꞌimu susuyao ꞌediya be Yaubada ꞌina ꞌatenuwaꞌoleꞌoleyega ꞌigieboboꞌanemuya ꞌuemwasali be sida nono.” ");
INSERT INTO dob_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ꞌEnega tai nina ꞌitauya ꞌebeloina Dekapoli ꞌana ꞌasa sanau ꞌediya ga Yesu ꞌina guinuwa waiwaina manuna ꞌietetela ga tomota maiboꞌadi sinonona ga nuwadi ꞌiowana. ");
INSERT INTO dob_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ga Yesu ma ꞌana tomuliyao siabala limana, ga boda sinabwana siegogonama leꞌawa nina ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ꞌEnega ꞌebweu tai, ꞌana esana Yailo, tauna anuwa tapwalolo ꞌana toꞌitaꞌiꞌita, ꞌimai ga Yesu ꞌilobena ga matanaya ꞌibwagobwago, ");
INSERT INTO dob_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ga ꞌisida waiwai, ꞌigwae, “ꞌInapwana, natugu mewainena ꞌana leꞌoasa ꞌimwau ꞌaiꞌaila, ta tauna gwama tuga, ta nuwanuwagu ꞌumama be ꞌuda gitoo be ꞌida boboꞌana, ta geyaꞌabo ꞌimwawamwawasa.” ");
INSERT INTO dob_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ꞌEnega Yesu maꞌiyana sitautauya, ga boda sinabwana simulimuliye ta siegigigila ꞌedaya. ");
INSERT INTO dob_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ta boda nidi soladiya ꞌebweu waine maꞌedi ma ina leꞌoasa. Leꞌoasa nina nate lalana ꞌidaudau yakwala tuwelo ꞌediya, ta tuga ꞌetamo ꞌidaudau. ");
INSERT INTO dob_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lowa togileꞌoasa yaudi ꞌediya ꞌina mani maiboꞌana ꞌiloegumwalina, ta saꞌi ꞌidi guinuwa ꞌenega nigeya ꞌida boboꞌana, ta esi ꞌana leꞌoasa ꞌisinasinabwa. ");
INSERT INTO dob_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Waine nina Yesu ꞌimuliyena manuna lowa tetelina ꞌinonona, ga ꞌatenaya ꞌinuwanuwa ꞌaene, “ꞌEguma tuga Yesu ꞌana ꞌoama namo yagitoo yada boboꞌana.” ꞌEnega ꞌiloselabena ga ꞌana ꞌoama ꞌigitoona ");
INSERT INTO dob_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ga lalana ꞌina dau ꞌiyapasa manini, ta taunamo oona solanaya ꞌilotoona ꞌaene niꞌatu ꞌiboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ta Yesu niꞌatu ꞌilotoona ꞌaene waiwai ꞌenega ꞌiapwesa ga ꞌiasakowasi ga boda ꞌienaidedi, ꞌigwae, “Yaita ꞌagu ꞌoama ꞌigitoona?” ");
INSERT INTO dob_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta ꞌenega ꞌina tononoyao sieonena, “ꞌInapwana, niꞌatu ꞌuꞌitena boda siaꞌoabuꞌoabuyemu ta siegigigila, ga ꞌoyo ꞌuenaida, ‘Yaita ꞌigitoogu?’ ” ");
INSERT INTO dob_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ta Yesu ꞌiloꞌita dadana tomota gamwagamwanidiya be ꞌida ꞌita yaita ꞌina waiwai ꞌena ꞌiabala. ");
INSERT INTO dob_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ta waine nina taunamo ꞌana boboꞌana niꞌa ꞌilobena ꞌimwalatonina, ꞌenega ꞌimai ga ma ina dedela ꞌina matauta manuna ꞌibeꞌu sanamwaꞌuta matanaya ga ꞌisimana ꞌaiꞌaila ꞌaene tauna ꞌiguinuwena. ");
INSERT INTO dob_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ta Yesu ꞌigwae, “Natugu, ꞌimu emisa ꞌenega ꞌuboboꞌana. ꞌUtoolo be ma imu gwausowala ꞌutatauya. ꞌImu leꞌoasa maiboꞌana niꞌatu ꞌigumwala.” ");
INSERT INTO dob_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tuta nina Yesu ꞌionaona waine ꞌenaya ꞌaina tomota Yailo ꞌina anuwega ale simeꞌena, ga sigwae, “Natuyo niꞌatu yawasina ꞌigumwala, ta geyaꞌabo wate toeꞌita nina ꞌina tuta ꞌumudamudali.” ");
INSERT INTO dob_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ta Yesu wate ale nina ꞌinonona ga Yailo ꞌieonena, ꞌigwae, “Geyaꞌabo ꞌuꞌateꞌate saꞌala, ta esi ꞌuemisegu tuga.” ");
INSERT INTO dob_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ꞌEnega Yesu boda yauna ꞌiꞌetobodedi be geyaꞌabo simulimuliye, ta nate namo ꞌina tononoyao sitetoi maꞌenao, nate Pita be Yemesa matasina tauna Yoni ");
INSERT INTO dob_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","sitautauya ga Yailo ꞌina anuwaya siapwesa ga ꞌewabamu be dedoi sinabwana sinonona. ");
INSERT INTO dob_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ta Yesu ꞌilugu ga ꞌieonedi, “Toꞌase manuna wadedoi ta waegalagalala? Gwama nigeya ꞌimwawamwawasa ta ꞌiꞌeno mwataya tuga.” ");
INSERT INTO dob_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ta siedagiyena. Ta esi Yesu ꞌipaꞌidi ga siapwesa, ta gwama tamana be sinana be ꞌina tononoyao sitetoi Yesu maꞌedi silugu gwama ꞌina ꞌebeꞌeno ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ta Yesu gwama nimanaya ꞌigiyaina ga ꞌigwae, “Talita kumi.” Ta ꞌana gibui, “Negeyo ꞌutoolo.” ");
INSERT INTO dob_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ꞌEnega ꞌitoolo manini ga ꞌiadadana, manuna ꞌana yakwala niꞌatu tuwelo ꞌilobena. Ta tamana be sinana nuwadi ꞌiowana ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ga Yesu ꞌiꞌetobodedi ꞌigwae, “Geyaꞌabo ꞌebweu yaita ꞌena wasimasimana ꞌigu guinuwa gete manuna, ta esi gwama ꞌana masula wagibubu be ꞌiꞌaꞌa.” ");
INSERT INTO dob_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ta Yesu ꞌiila tauna ꞌina ꞌasaya, ga ꞌina tononoyao simuliyena. ");
INSERT INTO dob_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ga Sabateya ꞌidi anuwa tapwalolo ꞌena ꞌilugu ga ꞌitoolo ta ꞌieꞌieꞌita ga tomota sinonona, ta yauyaudi nuwadi ꞌiowana ꞌina mwalatoi be ꞌina guinuwa manudi, ga sigwae, “Tai gete mane ꞌenega ꞌina sinasinapu ꞌilobena? Ta wate guinuwa nidi waiwaidi nimanega ꞌiguinuwedi, mane ꞌenega ꞌina waiwai ꞌilobena?” ");
INSERT INTO dob_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ta wate sigwae, “Tai gete toꞌabiꞌabi tuga aga? Ta sinana Meli, be tasinao Yemesa be Yosese be Yudasa be Saimoni be wate nuunao maꞌedao tamiyami, aga?” ꞌEnega tomota Yesu siguitoyasena. ");
INSERT INTO dob_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ta Yesu ꞌieonedi, ꞌigwae, “Palopitao ꞌadi ꞌamayaba silobaloba mali ꞌasa ꞌediya. Ta taudi ꞌidi ꞌasaya esiya nigeya ꞌadi ꞌamayabamo, manuna taudi ꞌidi buꞌunao be ꞌidi susuyao siguitoyasedi.” ");
INSERT INTO dob_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ta Yesu nuwana ꞌiowana manuna tomota nigeya siemiemise, ꞌenega nigeya kapekapeyana be guinuwa waiwaina bada ꞌida guinuwedi. Nate namo toleꞌoasao puꞌepuꞌedimo ꞌigitoodi ga siboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ꞌEnega Yesu ꞌisakowasi ꞌasa ꞌediya ta ꞌieꞌieꞌita. ");
INSERT INTO dob_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ga ꞌina tononoyao site tuwelo ꞌibwauyedi ga ꞌiloinedi be ꞌaene ꞌeluwa ꞌeluwa sida sakowasi ꞌasa ꞌediya, ta wate loina be waiwai ꞌiꞌebwaꞌedi be ꞌenega sawesawediya yaluyaluwa biꞌi tomota ꞌediyega sida ula apwesedi, ");
INSERT INTO dob_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ga ꞌina guguya ꞌenaya ꞌiloinedi, ꞌigwae, “Geyaꞌabo ꞌebweu toꞌase waꞌewaꞌewa. Geyaꞌabo masula nai tana nai mani ꞌabwaga manuna. Nate namo ꞌimi ꞌetoguna nimamiya, ");
INSERT INTO dob_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","be ꞌami ꞌaelawa waꞌotedi, ta esi geyaꞌabo ꞌami ꞌoama ꞌeluwena waꞌoteꞌotedi.” ");
INSERT INTO dob_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ta wate ꞌieonedi, “ꞌEguma to anuwa ꞌena sibwauyemi be ꞌena walulugu, anuwa nina ꞌena waeꞌowaga be ꞌana laba sena nina wapilisine. ");
INSERT INTO dob_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ta saꞌi ꞌeguma ꞌasa ꞌaina ꞌediya waapwesa be tomota nidi nigeya siꞌauꞌauꞌewami ꞌidi anuwa ꞌediya be wate nigeya ꞌimi guguya sinoonodi, ꞌasa nidi nedilina ꞌaemiyega waloutuutu yauledi ta wapilisinedi, be ꞌenega waeꞌitadi ꞌaene ꞌiabe mwau ꞌediya ꞌiapwesa.” ");
INSERT INTO dob_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ꞌEnega ꞌina tononoyao nidi sisakowasi ꞌasa yaudi ꞌediya, ga siguguya be ꞌaene tomota ꞌidi bubuna toꞌumalidi sida guitoyasedi be sida nuwaꞌebuni, ");
INSERT INTO dob_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ga yaluyaluwa biꞌi tomota ꞌediyega siula apwesedi, ga toleꞌoasao yaudi wate bunamega sieꞌabidi ga siboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ꞌEnega Yesu tetelina tomota silelewanena sena yauyauna ꞌediya ga Kini Elodi ꞌinonona. Manuna ꞌaina tomota sionaona ꞌaene “Yoni togiebapitaiso mwawasega niꞌatu ꞌitoolo limana ꞌenega ma ina waiwai ꞌiguiguinuwa.” ");
INSERT INTO dob_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ta ꞌaidi siona ꞌaene, “Tauna Ilaitiya.” Ta ꞌaidi wate sigwae, “Tauna palopita ꞌebweu ꞌatuwa gimi palopitao.” ");
INSERT INTO dob_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Elodi wate niꞌatu tetela ꞌinonona ga ꞌigwae, “Nai tauna Yoni togiebapitaiso. Lowa yaloemwawasina ta saꞌi ꞌitoolo limanaya.” ");
INSERT INTO dob_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Manuna lowa Elodi Yoni ꞌigiyaina ga deliya ꞌiyonina, ta Yoni ꞌana giyai ꞌalena nate ꞌebweu waine ꞌana esana Elodiyasa, nate Elodi tasina Pilipi mwanena ta Elodi ꞌiꞌoayena, ");
INSERT INTO dob_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ta Yoni Elodi ꞌieonena ꞌaene, “Gote nigeya bubuna boboꞌana, manuna tasiyo mwanena ꞌuꞌoayena.” ");
INSERT INTO dob_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ta Yoni ꞌina guguya gete manuna waine nina ꞌinuwa mwau ꞌaiꞌaila ga nuwanuwana be Yoni ꞌida loemwawasi, ta nigeya sawesawenaya ");
INSERT INTO dob_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","manuna Elodi ꞌiegagalena ꞌaene Yoni nina tai palupaluna ta Yaubada ꞌina toguinuwa ꞌebweu, ꞌenega Elodi Yoni ꞌiꞌamayabena ga tuta yauna Elodi nuwanuwana ga Yoni ꞌina ona ꞌinonona ta manuna ꞌiꞌatesaꞌala. ");
INSERT INTO dob_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ꞌEnega Elodi nina ꞌina ꞌasiyata tubuwa ꞌiapwesa ga Elodiyasa niꞌatu ꞌeda ꞌinuwa lobena Yoni ꞌana loemwawasa manuna. ꞌAsiyata tubuwa nina ꞌana weꞌiweꞌiyaya masulina siguinuwena ga ꞌaina ꞌowaga sibwauyedima sabi ꞌemasula. ꞌOwagao nidi gabemani ꞌadi toloinao be tolosaiya ꞌadi toanuganao ta ꞌaidi Galili ꞌasanao ꞌidi ꞌinapwanao. ");
INSERT INTO dob_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tuta nina Elodi ma ꞌana ꞌowagao siꞌeꞌai, Elodiyasa natuna mewainena ꞌiluguma matadiya ga lausega ꞌigie gwausowalidi. ꞌEnega Elodi gomagweine nina ꞌena ꞌiona oboboma ꞌaene “ꞌEguma to yage ꞌuesinuwa be ꞌusidegu yada tagwala ꞌemuya.” ");
INSERT INTO dob_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ga wate ꞌiona upaupa sawatamatamana ꞌenega ꞌigwae, “Onaꞌaiꞌaila yaona upaupa toꞌase nai yada ꞌebwaꞌeyo, ꞌeguma nai ꞌuda sida be ꞌaene ꞌigu ꞌebeloina yada weyali manuyo.” ");
INSERT INTO dob_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ꞌEnega gomagweine nina ꞌiapwesa ga ꞌitauya sinana ꞌena ꞌienaida, ꞌigwae, “Sinagu, toꞌase ꞌimu nuwanuwa be kini ꞌenaya yada side?” Ta sinana ꞌigwae, “Kini ꞌueona ꞌugwae, ‘Nuwanuwagu Yoni togiebapitaiso bulubuluna.’ ” ");
INSERT INTO dob_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ꞌEnega gomagweine ꞌilomanini ga ꞌiila kini ꞌena ga ꞌigwae, “Nuwanuwagu gete tuga Yoni togiebapitaiso bulubuluna gaeba ꞌena ꞌusaꞌu be ꞌuꞌebwaꞌegu.” ");
INSERT INTO dob_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ta Elodi ꞌinuwamwau ꞌaiꞌaila, ta nigeya kapekapeyana be ꞌiguitoyase, manuna niꞌatu ꞌisawa tamatamana ꞌowagao matadiya. ");
INSERT INTO dob_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ꞌEnega deli ꞌana toꞌitaꞌiꞌita ꞌebweu ꞌiloinena be ꞌaene ꞌida tauya be Yoni bulubuluna ꞌida meꞌe. Ga ꞌenega toꞌitaꞌiꞌita nina deliya ꞌitauya ga Yoni ꞌotona ꞌiꞌupwena, ");
INSERT INTO dob_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ga bulubuluna gaebaya ꞌiusena ga ꞌimeꞌena, ga gomagweine nina ꞌiꞌebwaꞌena, ta tauna ꞌiꞌewena ga ꞌitauyena sinana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ta Yoni ꞌana tomuliyao ꞌina esilae tetelina sinononaya ga simai ga Yoni kokowana siꞌewena, ga sisaꞌu ꞌaliꞌaliyena. ");
INSERT INTO dob_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ta niꞌatu Yesu ꞌina topaisewao site tuwelo siilama ga Yesu ꞌena ꞌidi paisewa be ꞌidi eꞌita maiboꞌana sisimanedi. ");
INSERT INTO dob_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ta tomota yau wawasae simeemai ta siilaila ga ꞌenega nigeya kapekapeyana be Yesu ma ina tononoyao sieyawaiꞌata be siꞌaꞌa, ꞌenega ꞌieonedi ꞌigwae, “Sena getei tada pilisine be tada tauya sena mwatui daitaya be gote ꞌena tupwana waeyawaiꞌata.” ");
INSERT INTO dob_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ꞌEnega taudimo waga sigeluna ga sitauya ꞌebweu sena mwatui daitaya. ");
INSERT INTO dob_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ta pwalu nidi Yesu ma ina tononoyao ꞌidi gelu siꞌitena ga siꞌinanedi, ꞌenega taudi be ꞌasa yaudi ꞌadi tomiyanao wate maꞌediyao ꞌedega sipili ga sigimiapwesa sena gote ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ta muliyega waga ꞌilugu ga Yesu ꞌisuya dabalaya ga boda sinabwana kaukauya ꞌiꞌitedi, ta ꞌiꞌatenuwa ꞌoleꞌoleyedi manuna taudi ꞌatuwa nadigega sipiyao nigeya ꞌadi toꞌitaꞌiꞌitamo, ꞌenega ꞌilolagata ga sinasinapu yauna ꞌieꞌieꞌita ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ga ꞌasuinuwanuwaya ꞌina tononoyao simai ga Yesu sieonena, sigwae, “ꞌInapwana, sena gete mwatui daita ta niꞌatu sinala ꞌisugusuguwa, ");
INSERT INTO dob_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ꞌenega pwalu getedi ꞌuda etunedi be sida ila be ꞌadi masula sida gimwane ꞌasao be anuwao selabediya ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ta Yesu ꞌieonedi, ꞌigwae, “Ta mwaꞌadega? ꞌOmi geyaꞌabo waeꞌenidi, aga?” Ta ꞌina tononoyao sigwae, “ꞌInapwana, nigeya sawesawemaya, manuna maiboꞌadi ꞌadi masula ꞌana maisa nai tu analedi kina nadigega.” ");
INSERT INTO dob_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “ꞌEisa beledi ꞌemiya? Watauya be waꞌebesa.” ꞌEnega niꞌatu silobena ga Yesu sieonena, sigwae, “Beledi nima ta iyana ꞌeluwa ꞌalobedi.” ");
INSERT INTO dob_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ꞌEnega pwalu ꞌiloinedi be maiboꞌadi simiyatowa boda be boda pwatulaya. ");
INSERT INTO dob_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ꞌEnega siweyalidi ga simiyatowa, ꞌaina boda tomota ꞌadi yau analedi, be ꞌaina boda tomota ꞌadi yau pipiti nadigega. ");
INSERT INTO dob_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ta beledi nima be iyana ꞌeluwa ꞌiꞌewedi ga galewaya ꞌiꞌitatuꞌe ta ꞌiona oboboma masula nidi manudi, ga muliyega beledi ꞌigitomwedi ga ꞌina tononoyao ꞌiꞌebwaꞌedi be sida eguyaiye tomota ꞌediya. Wate iyana nadigega ꞌigitomwedi ga ꞌina tononoyao ꞌiꞌebwaꞌedi ta ꞌenega sieguyaiyedi. ");
INSERT INTO dob_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ꞌEnega maiboꞌadi siꞌai ga gamwadi ꞌipawa. ");
INSERT INTO dob_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ta beledi be iyana tupwatupwadi siegogonedi ga kodo tuwelo siloemaedi. ");
INSERT INTO dob_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Toꞌeꞌai nidi taidimo ꞌadi yau paibi tausani nadigega. ");
INSERT INTO dob_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ta muliyega ꞌina tononoyao ꞌiloinedi be wagaya sigegelu, ꞌigwae, “Wagegelu be wanugana Betesaida mali esenaya, ta ꞌaboꞌagu bada ꞌetamo boda yaemataluwedi be siila ꞌidi ꞌasaya.” ");
INSERT INTO dob_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ꞌEnega sigelu ta Yesu pwalu ꞌietunediya, ta muliyega ꞌituꞌe ꞌoyaya sabi sidasida Yaubada ꞌena. ");
INSERT INTO dob_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ga niꞌatu ꞌiboi, ta ꞌina tononoyao bwagabwagaya siꞌadaꞌadau, ta tauna saꞌi tebweuna dabalaya ");
INSERT INTO dob_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ꞌiꞌitedi ꞌidi neya ꞌenega siloꞌameꞌame manuna yagila matadiyega ꞌimeema. Ta tomwa uliulitaya Yesu ola debanega ꞌitauyama be ꞌaene selabediyega ꞌialogedo be ꞌida pilisinedi. ");
INSERT INTO dob_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Gote ꞌena ꞌina tononoyao maiboꞌadi Yesu siꞌitena ola debanega ꞌimeemai ga sinuwena ꞌaene welabana, ");
INSERT INTO dob_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ꞌenega simatauta ga sinanala. Ta Yesu ꞌieonedi, ꞌigwae, “Geyaꞌabo wamatamatauta. ꞌAboꞌagu tuga, ꞌimi ꞌinapwana.” ");
INSERT INTO dob_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ga wagaya ꞌigelu maꞌenao ga yagila ꞌipela. ");
INSERT INTO dob_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ta nuwadi ꞌiowana sinabwana, manuna Yesu ꞌina waiwai manuna nigeya sinuwanuwa sabwaleni. ꞌEguma tuta nina tomota yaudi ꞌadi beledi Yesu ꞌieguyai be ꞌalena sida mwalatoni be ꞌenega sida nuwasabwaleni, ta tuga nigeya simwalamwalatoni, manuna debapaꞌalidi. ");
INSERT INTO dob_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ꞌEnega siabala sena Genesaleta ꞌenaya ga leꞌawinaya silugu ga ꞌidi waga gote ꞌena siloomuna. ");
INSERT INTO dob_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ga tuta nina sisuya toniꞌasa Yesu siꞌinanena, ");
INSERT INTO dob_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ta ꞌenega tomota nidi sipili ga sitauya ꞌasa maiboꞌana ꞌediya ga toleꞌoasao simeꞌedi ꞌebeꞌeno ꞌediyega be Yesu ꞌena sitauyedi to sena ꞌena sinonona ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ga Yesu ꞌisakowasi sena yauyauna ꞌediya, ꞌaina ꞌasa sinabwadi be ꞌasa gidalidi be ꞌebe bagula ꞌediya. Ta tomota yaudi ꞌidi toleꞌoasao simeꞌedi ga ꞌebe gimwane ꞌediya siyamwayamwa ta sisidena sigwae, “ꞌInapwana, kapekapeyana be toleꞌoasao getedi ꞌamu ꞌoama tupitupinamo sida gitoo?” Ga Yesu ꞌediya ꞌitagwala. ꞌEnega taudi ꞌana ꞌoama sigitoona siboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ta Palisiyao be loina ꞌana toeꞌitao ꞌaidi wate maꞌediyao Yelusalemega simai ga Yesu ꞌena siegogonama, ");
INSERT INTO dob_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ga ꞌaina ꞌina tononoyao siꞌita lobedi siꞌeꞌai, ta nigeya nimadi siꞌutuꞌutudi. ");
INSERT INTO dob_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Manuna Palisiyao be wate me Yudia maiboꞌadi ꞌidi bubuna tubudiyao ꞌediyega nate nadigega: Nugana nimadi siꞌutu ꞌaiꞌailidi be muliyega siꞌaꞌa. ");
INSERT INTO dob_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ta ꞌeguma ꞌebe gimwane ꞌenega simamai wate siꞌesiwe be ꞌenega siꞌaꞌa. Ta wate loina yauna tubudiyao ꞌediyega gaeba be keiga be ꞌulena ꞌadi ꞌutu manudi simuliyedi. ");
INSERT INTO dob_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ꞌEnega gete Palisiyao be loina ꞌana toeꞌitao nidi Yesu ꞌena sienaida, sigwae, “Toꞌase manuna ꞌimu tononoyao tubudao ꞌidi loina nigeya siꞌamaꞌamayabedi, ta manima baibailidi siꞌeꞌai?” ");
INSERT INTO dob_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ta Yesu ꞌieonedi, ꞌigwae, “ꞌOmi tokabokabo. Lowaenei Aisea palopita manumi ꞌiona upaupa ꞌaiꞌaila, tuta nina Yaubada ꞌina ona ꞌiꞌetoladina gete nadigega: ‘Tomota getedi ꞌawadiyega siꞌamaꞌamayabegu, ta ꞌatediyega nigeya. ");
INSERT INTO dob_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ta wate ꞌeguya sitapwalolo besobeso, manuna ꞌidi eꞌitao ꞌaboꞌagu nigeya ꞌeguyega, ta esi tomota tuga ꞌidi nuwenuwega.’ ” ");
INSERT INTO dob_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ta Yesu ꞌieonedi wate, ꞌigwae, “Onaꞌaiꞌaila ꞌimi bubuna toꞌumalina, ꞌenega Yaubada ꞌina loina wasaꞌu kwaiyena ta tubumiyao saꞌi ꞌidi bubuna wamulimuliyedi.” ");
INSERT INTO dob_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ta wate ꞌigwae, “ꞌAene ꞌomi tomwalatoi ꞌaiꞌaila, ta nigeya! Manuna Yaubada ꞌina loinao waguiguitoyasedi ta esi tubumiyao ꞌidi bubuna wagiyaiꞌiꞌisidi. ");
INSERT INTO dob_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Lowa Mosese Yaubada ꞌina loina ꞌisimanena, ꞌigwae, ‘Tamayo be sinayo ꞌuda ꞌamayabedi.’ Ta wate ꞌigwae, ‘ꞌEguma yaita tamana nai sinana ꞌiꞌawa toꞌumaliyedi, ꞌilobwenena be waloemwawasi.’ ");
INSERT INTO dob_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ta ꞌomi ꞌimi eꞌita kabokabo gete nadigega, ‘ꞌAbo ꞌebweu yaita tamana be sinana ꞌieonadi ꞌigwae, “ꞌIgu gwegweyao niꞌatu yatagwaledi Yaubada ꞌenaya ga etaetabuna, ꞌenega nigeya sawesawenaya be yalememi.” ’ ");
INSERT INTO dob_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Gete ꞌimi loina ꞌenega tomota ꞌidi lema tamadiyao be sinadiyao ꞌediya waꞌetoꞌetobodedi. ");
INSERT INTO dob_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tubumiyao ꞌidi loina gete ꞌenega, be ꞌimi eꞌita wate yauna ꞌediyega, Yaubada ꞌina loina waeyage besobesoena.” ");
INSERT INTO dob_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ꞌEnega pwalu ꞌibwau limedima ga ꞌieonedi, “ꞌIgu ona gete maiboꞌami wanonodi be nuwami ꞌida sabwalena: ");
INSERT INTO dob_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nigeya ꞌebweu toꞌase tomota taꞌeꞌani be sigiegie bailida, ta esi yage nidi ꞌatedega siapweapwesa sawesawediya be sigiebailida.” ");
INSERT INTO dob_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(-) ");
INSERT INTO dob_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ꞌEnega Yesu ma ina tononoyao pwalu siebesinedi ga anuwaya silugu, ta ꞌenega ꞌina tononoyao sienaidena, sigwae, “Kapekapeyana ꞌimu onasemalimali nina tomota ꞌediya ꞌuda liꞌami ꞌemaya?” ");
INSERT INTO dob_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ga Yesu ꞌieonedi, ꞌigwae, “Nai ꞌomi wate nuwami nigeya ꞌisabwasabwalena, aga? ꞌEnega nigeya wamwalamwalatoni ꞌaene toꞌase taꞌaꞌani be ꞌilulugu soladaya nigeya saꞌi ꞌida giebailida, ");
INSERT INTO dob_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","manuna nigeya ꞌatedaya ꞌitauya ta esiya gamwada namo ꞌena ꞌilugu be muliyega ꞌitatauya sumwana ꞌenaya.” (Yesu ꞌina eꞌita gete ꞌana mwalatoi ꞌaene nigeya ꞌebweu wate masula etaetabuna, ta esi maiboꞌana tada ꞌani.) ");
INSERT INTO dob_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ta Yesu wate ꞌigwae, “Toꞌase tomota ꞌatediyega siapweapwesa sawesawediya be sigiebailidi, ");
INSERT INTO dob_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","nadigega nuwanuwa toꞌumalidi be loyawe, ꞌipwala, loemwawasa, ");
INSERT INTO dob_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","loelata, yalakwaiya, gamwasowala, kabo, sogala, eꞌipiꞌipi, sinala, gagasa be bubuna besobeso. ");
INSERT INTO dob_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gete yage nidi toꞌumalidi tomota soladiyega siapweapwesa ga sigiegie bailidi.” ");
INSERT INTO dob_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ga gote ꞌenega Yesu ꞌitoolo ga ꞌitauya Taiya be Saidoni senadiyao ꞌediya ga ꞌebweu anuwa ꞌena ꞌilugu, manuna geya nuwana be tomota sida mwalatoni ꞌina mai manuna, ta saꞌi nigeya kapekapeyana be ꞌimiya kwaiya ");
INSERT INTO dob_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","manuna ꞌebweu waine Yesu ꞌina mai tetelina ꞌinonona. Ta waine nina nigeya waine Yudia ta esi tauna goma Pinisia sena Silia solanega, ga natuna mewainena niꞌatu yaluyaluwa biꞌi ꞌigie toꞌumaliyena, ꞌenega sinanana ꞌimai ga Yesu ꞌaenaya ꞌibwago sanamwaꞌuta, ga ꞌisidena be ꞌaene yaluyaluwa biꞌi nina natuna ꞌenega ꞌida ula apwese. ");
INSERT INTO dob_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ga Yesu ꞌigwae, “ꞌIlobwenena be gogama ꞌadi masula yada ꞌebwaꞌedi bemi, ta nigeya sawesawenaya be gogama ꞌadi masula yaꞌebwaya kedewa ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ta waine ꞌigwae, “Onaꞌaiꞌaila ꞌInapwana, ta saꞌi kedewa tuta yauna ꞌebe ꞌeꞌai ꞌagalaunega gogama ꞌadi masula mugumuguna ꞌenega siꞌeꞌa.” ");
INSERT INTO dob_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ga Yesu ꞌigwae, “Kagutoki! Nate ona ꞌaiꞌaila. ꞌEnega ꞌutoolo be ꞌuila ꞌimu anuwaya. Yaluyaluwa biꞌi natuyo ꞌenega niꞌatu ꞌiapwesa, ga ꞌiboboꞌana.” ");
INSERT INTO dob_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ꞌEnega ꞌitoolo ga ꞌitauya ꞌina anuwaya ga natunana ꞌilobena ꞌina ꞌebeꞌeno ꞌena, niꞌatu ꞌiboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ꞌEnega Yesu Taiya ꞌipilisinena ga ꞌitauya Saidoni, ta wate ꞌiataona Dekapoli senanao ꞌediyega ga ꞌiapwesa Galili olana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ga ꞌebweu tai simeꞌena Yesu ꞌenaya tauna totenatui ta wate meya lidolidona ga Yesu sisidena be ꞌaene ꞌida gitoo be ꞌida boboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ga Yesu tai nina ꞌiꞌauꞌewena ga boda ꞌediyega siadumaduma taudimo, ga Yesu nima matagigina tai tenanaya ꞌisaꞌu luguyedi ga muliyega tauna nimana ꞌigiwalina ga tai meyana ꞌigitoona, ");
INSERT INTO dob_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ꞌenega Yesu ꞌiꞌitatuꞌe galewaya ga ꞌatenuwa ꞌoleꞌoleyega ꞌionaona, ꞌigwae, “Epapata”, nate ꞌana gibui “ꞌUebwale.” ");
INSERT INTO dob_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ꞌEnega tai nina tenana ꞌiebwalebwaledi ta wate meyana niꞌatu ꞌipalupalu be kapekapeyana ꞌiona ta ꞌinono palupalu. ");
INSERT INTO dob_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ꞌEnega Yesu tomota ꞌiꞌetobodedi be ꞌaene geyaꞌabo yaita ꞌena sida simasimane. Ta ꞌetoboda nina nigeya sinoono, ta esi siemwaemwasala dadanei tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ta taudi niꞌatu sinonona, nuwadi ꞌiowana sinabwana ga sigwae, “ꞌIna guinuwa maiboꞌana boboꞌana ta ꞌebe nuwaowana, manuna totenatui ꞌigienonoedi ta tomeya lidolido ꞌigie palupaludi be sioona.” ");
INSERT INTO dob_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tuta gote ꞌena boda sinabwana wate siegogonama Yesu ꞌenaya ta nigeya ꞌadi masulamo. ꞌEnega ꞌina tononoyao ꞌibwauyedima ga ꞌieonedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Tomota getedi yaꞌatenuwa ꞌoleꞌoleyedi manuna niꞌatu ꞌasiyata ꞌetoi bada maꞌegwao ꞌamiyami ta nigeya ꞌadi masulamo. ");
INSERT INTO dob_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ꞌEnega ꞌeguma mabotanidi yaetune iledi ꞌetamo ꞌedaya sitatai, manuna ꞌaidi ꞌedasolega simai.” ");
INSERT INTO dob_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ꞌEnega Yesu ꞌina tononoyao sieonena, sigwae, “Mwaꞌadega sena mwatui daita ꞌena tomota yaudi getedi ꞌadi masula talobaꞌese?” ");
INSERT INTO dob_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ta Yesu ꞌienaidedi, ꞌigwae, “ꞌEisa ꞌami belediyao simiyami?” Ga sigwae, “Sebeni namo.” ");
INSERT INTO dob_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ꞌEnega boda ꞌiloinedi be baleꞌuya simiyatowa, ga beledi sebeni nidi ꞌiꞌewedi ta manudi ꞌiona lokagutoki Yaubada ꞌena, ga ꞌigitomwedi ga ꞌina tononoyao ꞌiꞌebwaꞌedi be tomota ꞌediya sieguyai, ga sieguyai sakowasiyedi. ");
INSERT INTO dob_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ta ꞌaina iyana gidalidi wate simiyami, ꞌenega manudi Yesu ꞌiona oboboma, ga ꞌina tononoyao ꞌiloinedi be sieguyaiyedi wate tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ꞌEnega maiboꞌadi siꞌai ga gamwadi ꞌipawa, ga muliyega masula tupwatupwadi siegogonedi ga kodo sebeni siloemaedi. ");
INSERT INTO dob_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ta boda nidi ꞌadi yau powa tausani nadigega. ");
INSERT INTO dob_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ꞌEnega ꞌietune ilediya, ga ma ina tononoyao silomanini ga ꞌidi waga sigeluna ga Dalimanuta senanaya sitauya. ");
INSERT INTO dob_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ꞌEnega Palisiyao simai ga Yesu ꞌena siegewagewana ga sitoona be ꞌaene weꞌiweꞌiyaya ꞌebweu ꞌida guinuwe manudi be sida ꞌawaꞌaiꞌaile ꞌaene ꞌina waiwai Yaubada ꞌenega ꞌimai. ");
INSERT INTO dob_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ta Yesu ma ina nuwamwau ꞌieonedi, ꞌigwae, “Mwaꞌadega ga ꞌenega ꞌepata gete ꞌomi nuwanuwami weꞌiweꞌiyaya, ta esi geyaꞌabo ꞌebweu wate weꞌiweꞌiyaya waꞌitaꞌita.” ");
INSERT INTO dob_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ꞌEnega ꞌipilisinedi ga wagaya ꞌigelu limana ga siabala mali senaya. ");
INSERT INTO dob_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ta ꞌadi ꞌabwaga nigeya siꞌewaꞌewa manuna sinuwa pupuledi, ta beledi ꞌebweuna namo wagaya ꞌitupwa. ");
INSERT INTO dob_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ga Yesu ꞌiemataluwedi, ꞌigwae, “Palisiyao be Elodi ꞌadi beledi ꞌana ꞌebe gieseseya ꞌenega waꞌitaꞌiꞌisimi.” ");
INSERT INTO dob_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ꞌEnega tonono nidi taudimo ꞌediya sigwae, “Nai Yesu ꞌina ona ꞌalena gete, manuna ꞌada ꞌabwaga tanuwa pupulena.” ");
INSERT INTO dob_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ta Yesu ꞌidi nuwanuwa niꞌatu ꞌimwalatonina ga ꞌieonedi, “Toꞌase manuna waonaona ꞌaene nigeya ꞌami ꞌabwagamo? Nate nigeya manuna yaonaona. Mwaꞌadega ꞌimi nuwanuwa sipotaya ga nigeya sawesawenaya be ꞌigu ona wasinapudi. ");
INSERT INTO dob_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mamatami ta saꞌi nigeya waꞌitaꞌita, ta wate matenami ta saꞌi nigeya wanoono, ꞌenega geyaꞌabo wanuwanuwaꞌiꞌisi ꞌigu guinuwa pwaluyao ꞌadi ꞌeꞌai manuna aga? ");
INSERT INTO dob_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tuta nina beledi nima ꞌenega tomota paibi tausani yaeꞌenidiya, ta tupwa ꞌeisa kodo waegogonedi?” Ga sigwae, “Tuwelo.” ");
INSERT INTO dob_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ta Yesu ꞌienaida wate, ꞌigwae, “Ga tuta nina beledi sebeni ꞌenega tomota powa tausani yaeꞌenidiya ta tupwa ꞌeisa kodo waegogonedi?” Ga sigwae, “Sebeni.” ");
INSERT INTO dob_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ꞌEnega Yesu ꞌigwae, “Onaꞌaiꞌaila, ta ꞌomi sana nuwami nigeya ꞌisabwasabwalena.” ");
INSERT INTO dob_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ꞌEnega Beteseida ꞌena simai, ga tai tomata kebokebo tomota siꞌauꞌewena Yesu ꞌenaya, ga sisidena be ꞌaene ꞌida gitoo be ꞌida boboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ta Yesu tomata kebokebo nina nimanaya ꞌigiyaina ta ꞌiꞌauꞌewena, ga ꞌasa nina ꞌenega siapwesa. ꞌEnega Yesu tai nina matana ꞌigiwalidi ta nimanega matana ꞌigitoodi ga ꞌieonena, “Sawesawenaya toꞌase ꞌuꞌitadi?” ");
INSERT INTO dob_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ꞌEnega tai nina ꞌiloꞌita dadana ga ꞌigwae, “Tomota yaꞌitedi, ta ꞌadi ꞌita ꞌatuwa nadigega kaiwe siloopili dadana.” ");
INSERT INTO dob_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ta ꞌenega Yesu wate tai nina matana ꞌigitoo limedi, ꞌenega ꞌidune ga matana siꞌesasa ꞌaiꞌailidi, ga yage yauna ꞌiꞌitedi. ");
INSERT INTO dob_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ꞌEnega Yesu ꞌietunena, ꞌigwae, “Geyaꞌabo ꞌuilaila ꞌasa sinabwana ꞌenaya, ta esi ꞌutatauya tauyo ꞌimu anuwaya.” ");
INSERT INTO dob_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Gote ꞌena Yesu ma ina tononoyao sitautauya Sisalia Pilipai ꞌasanao manudi, ga ꞌedaya ꞌina tononoyao ꞌieonedi, ꞌigwae, “Mwaꞌadega tomota ꞌidi ona manugu ꞌaene ꞌaboꞌagu yaita?” ");
INSERT INTO dob_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ga tonono nidi sigwae, “Tomota ꞌaidi siona ꞌaene ꞌoyo Yoni togiebapitaiso, ta ꞌaidi sigwae ꞌaene ꞌoyo Ilaitiya, nai gimipalopita ꞌebweu tuga.” ");
INSERT INTO dob_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ꞌEnega wate ꞌienaidedi, ꞌigwae, “Ta ꞌomi mwaꞌadega ꞌimi nuwanuwa ꞌaene ꞌaboꞌagu yaita?” ꞌEnega Pita ꞌilolagata ga ꞌigwae, “ꞌOyo Keliso, Toꞌetoseyana niyo.” ");
INSERT INTO dob_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ta Yesu ꞌiloina paꞌaledi, ꞌigwae, “Geyaꞌabo ꞌebweu yaita ꞌena wasimasimanegu.” ");
INSERT INTO dob_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ta wate ꞌilolagata be toꞌase maꞌetamo ꞌilobai ꞌieꞌitaena ꞌediya, ꞌigwae, “ꞌAboꞌagu Tomota Natuna maꞌetamo ꞌelouya sinabwana yaloba. Manuna ꞌinapwanao be totaliyao sinabwadi be loina ꞌana toeꞌitao ꞌiabe sieꞌidiꞌidiyegu be siloemwawasigu ta ꞌasiyata ꞌetoi mulinaya yada toololimana.” ");
INSERT INTO dob_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu ꞌina ona gete ꞌenega ꞌisaꞌuapwese ꞌaiꞌailina ꞌina mwawasa manuna. ꞌEnega Pita Yesu maꞌalenaya ꞌitauyena ga ꞌiꞌetobodena be ꞌaene geyaꞌabo yage nidi siapweapwesa Yesu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ta Yesu ꞌiasakowasi ga ꞌina tononoyao ꞌiduneduneyedi ga ꞌiꞌenapaꞌala Pita ꞌena, ꞌigwae, “ꞌOyo Seitani, gete tuga ꞌupilisinegu! Manuna ꞌimu nuwanuwa tomota ꞌidi nuwanuwa, ta nigeya Yaubada ꞌina nuwanuwa nadigega.” ");
INSERT INTO dob_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ꞌEnega Yesu boda maiboꞌadi be ꞌina tononoyao maꞌediyao ꞌibwauyedima ga ꞌieonedi, ꞌigwae, “Yaita ꞌeguma nuwanuwana be ꞌimuliyegu, ꞌilobwenena be tauna ꞌina nuwanuwa ꞌida guitoyase be tauna ꞌana kelose ꞌiꞌaali be ꞌenega ꞌimwamwawasa, nate nadigega ꞌagu muliya nina ꞌana ꞌeda. ");
INSERT INTO dob_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Ta ꞌeguma yaita yawasina ꞌiegagale, maꞌetamo yawasi nina ꞌiloseye. Ta ꞌeguma yaita manugu be tetela boboꞌana manuna yawasina ꞌitagwale be ꞌimwamwawasa, tauna ꞌiabe yawasina boboꞌana ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“ꞌEguma ꞌida esaesao baleꞌuya sinabwa wawasae talobadi nate yage besobeso, ta esi yage sinabwana nate yawasida boboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Manuna ꞌeguma yawasida boboꞌana taloseyedi, nigeya ꞌebweu wate ꞌana lopaꞌelu ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“ꞌAboꞌagu Tomota Natuna, ta ꞌabo yaita ꞌoyo manugu ꞌuomayamaya ta wate ꞌigu eꞌita manuna ꞌuomayamaya be ꞌueyaseyaseyegu ꞌepata gete toꞌumalidi ta sogasogalidi matadiya, maꞌetamo yada eyaseyaseyo, tuta nina Tamagu ꞌina esaesa tuyatuyayalina ꞌenega yaila limanama, ta wate aneloseyao maꞌegwao. ");
INSERT INTO dob_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","“Ta Yesu ꞌieonedi wate, ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya ꞌaene tomota ꞌaimi geyaꞌabo wamwawamwawasa ga ꞌana laba Yaubada ꞌina loina waiwaina ꞌida apwesa be wada ꞌita.” ");
INSERT INTO dob_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ꞌAsiyata sikisi mulinaya Yesu ꞌina tononoyao ꞌetoi ꞌiꞌauꞌewedi, taudi Pita be Yemesa be Yoni, ga maꞌenao situꞌe ꞌoya ꞌebweu kesolana ꞌenaya, ga taudimo simiyami; ga siꞌitena Yesu maninina ꞌituyayala, ");
INSERT INTO dob_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ta ꞌana ꞌoama ꞌiwakeke ꞌaiꞌailina, ꞌana ꞌita nigeya ꞌebweu yaita baleꞌuya sawesawenaya be ꞌoama ꞌida ꞌgieꞌesase be ꞌana wakewakeke nadigega. ");
INSERT INTO dob_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ta wate Ilaitiya be Mosese siapwesama ga Yesu nina maꞌedi siꞌawaꞌawa gwae. ");
INSERT INTO dob_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ꞌEnega Pita ꞌilolagata ga Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌida miya gete nadigega boboꞌana, ꞌenega ꞌimi yoeyoe ꞌetoi ꞌaꞌabidi, ꞌebweuna ꞌoyo manuyo, ta ꞌebweuna Mosese manuna, ta ꞌebweuna Ilaitiya manuna.” ");
INSERT INTO dob_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nate Pita ꞌionaona besobeso tuga, manuna magosenao simatauta. ");
INSERT INTO dob_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ꞌEnega pwana wate ꞌimwaꞌuta ga ꞌitala ekabobodi, ta pwana ꞌenega ꞌebweu ꞌenana sinonona, ꞌigwae, “Gete natugu boboꞌaiꞌailina, ꞌina onao wada nonodi.” ");
INSERT INTO dob_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta silomanini ga siloꞌita dadana ga Yesu tebweuna namo, ta nigeya ꞌebweu wate yaita siꞌitaꞌita. ");
INSERT INTO dob_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ꞌEnega ꞌoyega siebuebusima ga Yesu ꞌiloinedi, ꞌigwae, “Yage nidi niꞌatu waꞌitediya geyaꞌabo tomota ꞌediya wasimasimanedi ga ꞌana laba ꞌaboꞌagu Tomota Natuna mwawasega yatoolo limana.” ");
INSERT INTO dob_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ꞌEnega yage nina sisaꞌu kwaiyena, ta taudimo sionaona, sigwae, “ꞌIna ona nina toololimana manuna mwaꞌadega ꞌana mwalatoi?” ");
INSERT INTO dob_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ga Yesu ꞌena sienaida wate, sigwae, “Toꞌase manuna loina ꞌana toeꞌitao siona ꞌaene Ilaitiya ꞌigimi nuganama be muliyega Toꞌetoseyana nina ꞌimama?” ");
INSERT INTO dob_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ta Yesu ꞌigwae, “O nadigega, Ilaitiya ꞌaene ꞌida giminuganama be ꞌenega yage maiboꞌadi ꞌida giepaepaludi. Ta saꞌi Ilaitiya nina niꞌatu ꞌimai saba, ta esi tomota siguinuwa besobeso ꞌenaya toꞌase ꞌidi nuwena nadigega, nadigega Buki Tabu ꞌigimi simanaꞌesena. Ta wate ꞌaboꞌagu Tomota Natuna, toꞌase manuna Buki Tabu ꞌigimi simanegu ꞌaene ꞌelouya yaudi yalobadi be wate tomota sida guitoyasegu?” ");
INSERT INTO dob_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ꞌEnega ꞌoyega simwaꞌuta ga ꞌina tononoyao maiboꞌadi siloba limedi be boda yaudi maꞌediyao, ta wate loina ꞌana toeꞌitao wate maꞌediyao siegewagewana. ");
INSERT INTO dob_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ga tuta nina pwalu Yesu siꞌinanena nuwadi ꞌiowana sinabwana, ga ꞌenaya sipili manini sabi ꞌitana. ");
INSERT INTO dob_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ta Yesu ꞌidi egewagewana manuna ꞌienaida, ꞌigwae, “Toꞌase manuna waonaona?” ");
INSERT INTO dob_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ga ꞌebweu tai boda nidi ꞌediyega Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌidi egewagewana ꞌalena natugu, manuna ꞌina leꞌoasa ꞌenega nigeya kapekapeyana be ꞌiona, ");
INSERT INTO dob_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ta ꞌaina tuta yaluyaluwa biꞌi ꞌina guinuwega ꞌitatai ta ꞌawanega busobuso siapweapwesa, ta ꞌiesalaꞌiꞌita be ꞌidededela. Ta ꞌimu tononoyao niꞌatu yasidedi be ꞌaene yaluyaluwa biꞌi gwama ꞌenega siula apwese, ta nigeya sawesawediya.” ");
INSERT INTO dob_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta Yesu ꞌieonedi, ꞌigwae, “ꞌOmi sana mwaꞌadega? Ga debami paꞌala yaita! Niꞌatu ꞌimi debapaꞌala ꞌenega yaloꞌameꞌame. Baga gwama nina wameꞌe ꞌeguya be yaꞌita.” ");
INSERT INTO dob_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ꞌEnega gwama nina simeꞌena ꞌenaya, ta yaluyaluwa biꞌi Yesu ꞌiꞌitena, ꞌenega ꞌiginao ga gwama ꞌitai ga baleꞌuya ꞌibeꞌu ga ꞌidededela ta ꞌawanega busobuso siapweapwesa. ");
INSERT INTO dob_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ta Yesu gwama tamana ꞌieonena, “To tuta ꞌena ꞌina leꞌoasa ꞌieꞌale?” Ga tamana ꞌigwae, “ꞌIna tuta gwamega. ");
INSERT INTO dob_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ꞌEnega ꞌabo ꞌitatai ꞌaina tuta ꞌibebeꞌu kaiwe ꞌalaꞌalasidi ꞌediya ta ꞌaina tuta bwasi niꞌudi ꞌediya be ꞌiabe ꞌiloemwawasi. ꞌEnega ꞌabo kapekapeyana ꞌuda ꞌatenuwa ꞌoleꞌoleyema be ꞌulemema.” ");
INSERT INTO dob_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ta Yesu tai nina ꞌieonena, ꞌigwae, “Niꞌatu ꞌuona ‘ꞌAbo kapekapeyana’, aga? Ta esi ꞌuda nuwaꞌiꞌisi ꞌaene ꞌeguma taemisa, yage maiboꞌana kapekapeyana ꞌedaya.” ");
INSERT INTO dob_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gote ꞌena tai nina ꞌiona toitoila, ꞌigwae, “Onaꞌaiꞌaila yaemisa, ta nigeya emisa ꞌaiꞌaila. Nuwanuwagu be ꞌigu emisa ꞌugiewaiwaiye.” ");
INSERT INTO dob_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ta Yesu boda yauyaudi sipilipilima ꞌiꞌitedi, ꞌenega yaluyaluwa biꞌi ꞌiꞌenapaꞌalina, ꞌigwae, “ꞌOyo yaluyaluwa toꞌumaliyo ꞌimu lobwebwai ꞌenega gwama ꞌieuwauwa, yaloineyo be ꞌupilisine atae be geyaꞌabo wate ꞌebweu tuta ꞌulugulugu limana ꞌena.” ");
INSERT INTO dob_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ꞌEnega yaluyaluwa nina ꞌimagamagana ga gwama ꞌana lobwebwai ꞌiginaona ga ꞌidededela sinabwana, ta yaluyaluwa biꞌi ꞌenega ꞌiapwesa ga ꞌitauya. Ta boda gwama siꞌitena ꞌana ꞌita ꞌatuwa ꞌimwawasa, ga simatauta ta sigwae, “Niꞌatu ꞌimwawasa.” ");
INSERT INTO dob_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ta Yesu gwama nimana ꞌigiyaina ga ꞌigietoolona, ta gwama nina ꞌitoolo, niꞌatu ꞌiboboꞌana. ");
INSERT INTO dob_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ꞌEnega muliyega Yesu ma ina tononoyao silugu anuwaya, ga nada taudimo. ꞌEnega tonono nidi Yesu sieonena sigwae, “ꞌInapwana, mwaꞌadega ꞌaboꞌama ga nigeya sawesawemaya be yaluyaluwa biꞌi ꞌaula apwese?” ");
INSERT INTO dob_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ta Yesu ꞌigwae, “Nigeya ꞌebweu to yage ꞌenega be yaluyaluwa biꞌi taula apwese. Nate namo sidesidega, Yaubada ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Gote ꞌenega Yesu ma ina tononoyao sena nina sipilisinena, ta Yesu geya nuwana be boda sida mwalatoni mane ꞌena sitautauya, ꞌenega Galili ꞌedana ꞌena sitauya, ");
INSERT INTO dob_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ga ꞌina tononoyao ꞌieꞌitedi ꞌina mwawasa manuna, ꞌigwae, “Maꞌetamo Tomota Natuna ꞌana totelesipupu ꞌida ꞌebwayae ꞌana talauwalao ꞌediya be siloemwawasi, be ꞌasiyata ꞌetoi muliyega ꞌida toololimana.” ");
INSERT INTO dob_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ta ꞌina eꞌita gete manuna nigeya simwalamwalatoni, ta esi nigeya ꞌidi ꞌInapwana ꞌena sienaenaida, manuna simatauta. ");
INSERT INTO dob_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ꞌEnega ꞌasa Kapaneumi ꞌena siapwesa ga anuwaya silugu, ga nada Yesu ꞌienaida ꞌina tononoyao ꞌediya, ꞌigwae, “To yage manuna waegewagewana ꞌedaya?” ");
INSERT INTO dob_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ta siomayamaya ga nigeya sieeꞌisa, manuna ꞌidi egewagewana ꞌalena nate yaita ꞌediyega ꞌida anugana. ");
INSERT INTO dob_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ꞌEnega Yesu ꞌimiyatowa ga site tuwelo ꞌibwauyedima ga ꞌieꞌita ꞌediya, ꞌigwae, “ꞌAbo yaita ꞌoyo nuwanuwayo be ꞌemiyega ꞌueꞌinapwana, ꞌilobwenemu be tauyo ꞌugimwaꞌuteyo be ꞌuetoguinuwa gosemwao manudi.” ");
INSERT INTO dob_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ta ꞌebweu gwama ꞌiꞌauꞌewenama ga gamwagamwanidiya ꞌietoolona ta ꞌiꞌatubwailina ga ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ꞌigwae, “ꞌEguma yaita ꞌoyo gwama gete nadigega ꞌuobobome manugu, nate ꞌaboꞌagu wate ꞌuobobomegu, ta nigeya ꞌaene taugumo ꞌuobobomegu, ta wate ꞌagu toetune Yaubada maꞌiyagu ꞌuobobomema.” ");
INSERT INTO dob_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ta Yoni ꞌilolagata ga ꞌigwae, “ꞌInapwana, ꞌebweu tai ꞌaꞌitena ꞌamu esanega yaluyaluwa biꞌi ꞌiulaula apwesedi, ꞌenega ꞌaꞌetobodena, manuna tai nina nigeya ꞌida boda.” ");
INSERT INTO dob_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ta Yesu esiya ꞌigwae, “Geyaꞌabo waꞌetoꞌetobode. Manuna ꞌabo ꞌebweu yaita yage waiwaidi ꞌagu esanega ꞌiguiguinuwedi, geyaꞌabo ꞌebweu wate ꞌisinasinaligu. ");
INSERT INTO dob_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Manuna ꞌeguma yaisigedi nigeya sietaetalauwaleda taudi silemelemeda. ");
INSERT INTO dob_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Ta wate wada nuwaꞌiꞌisi ꞌaene ꞌeguma tonaꞌami ꞌiyapayapasa be ꞌebweu yaita ꞌienumami manuna ꞌomi Keliso ꞌina bodao, tauna ꞌana pali boboꞌana maꞌetamo ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ta esi ꞌeguma yaita ꞌitoo be ꞌagu toemisao gogama getedi ꞌediyega ꞌebweuna ꞌigie beꞌuye, tai nina nai waine nina ꞌilobwenena be gulewa sinabwana ꞌotonaya silosipwa be magulewana siula mwaꞌutedi niꞌuya. ");
INSERT INTO dob_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Wate ꞌeguma nimayo ꞌigie beꞌuyeyo ꞌilobwenena be ꞌuꞌupwa yaule. Nate nigeya ꞌana toꞌumalinamo ꞌeguma manima ꞌupwaꞌupwayo ta yawasiyo boboꞌana ꞌuloba. Ta esi toꞌumali wawasae ꞌemuya ꞌeguma manima luwaluwayo siula mwaꞌuteyo kaiwe ꞌalaꞌalata atayana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO dob_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Be wate ꞌeguma ꞌaeyo ꞌigie beꞌuyeyo ꞌilobwenena be ꞌuꞌupwa yaule. Nate nigeya ꞌana toꞌumalinamo ꞌeguma ma imu lopegoi ta yawasiyo boboꞌana ꞌuloba. Ta esi toꞌumali wawasae ꞌemuya ꞌeguma maꞌae luwaluwayo siula mwaꞌuteyo ꞌasagabugabu ꞌena. ");
INSERT INTO dob_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO dob_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Matayo wate nadigega, ꞌeguma ꞌigie beꞌuyeyo ꞌuꞌiwa yaule tuga, manuna nigeya ꞌebweu wate ꞌana toꞌumalinamo ꞌeguma mamata ꞌebweꞌebweuyo ta Yaubada ꞌina ꞌebe loina ꞌuloba. Ta esi toꞌumali wawasae ꞌemuya ꞌeguma mamata luwaluwayo siula mwaꞌuteyo ꞌasagabugabu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Sena nina ꞌena kokowa ꞌediya ipwaipwa sisopisopila ataya, be wate kaiwe nigeya ꞌida kweu. ");
INSERT INTO dob_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ꞌEnega tomota maiboꞌadi ꞌawesabelulu ꞌida gieboboꞌanedi, nadigega ola masula ꞌigie boboꞌanena. ");
INSERT INTO dob_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ola yage boboꞌana. Ta ꞌeguma ꞌana lotoona ꞌisasawala, nigeya sawesawenaya be ꞌiboboꞌana limana. ꞌEnega ꞌilobwenemi be ꞌimi bubuna taumi walotoona ꞌana dibidibi nadigega waeoboobobomemi ꞌebweuna ꞌebweuna ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ga Yesu sena nina ꞌipilisinena ga Yudia ꞌina senaya ꞌitauya ga ꞌiabala bwasi Yolidani mali esenaya, ga boda sinabwana siegogonama ꞌenaya, ta ꞌenega ꞌina bubuna nadigega ꞌieꞌita ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ta Palisiyao simai ga nuwanuwadi be Yesu sitoo, ꞌenega ꞌena sienaida, sigwae, “ꞌInapwana, mwaꞌadega ꞌida loina saꞌila manuna? Kapekapeyana be tai mwanena ꞌisaꞌilei?” ");
INSERT INTO dob_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ta Yesu ꞌigwae, “Mwaꞌadega Mosese loina ꞌiꞌebwayaꞌesemi?” ");
INSERT INTO dob_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ga Palisiyao sigwae, “Mosese ꞌitagwala be ꞌabo tai nuwanuwana be ꞌisasaꞌila, nugana pwepwai ꞌena ꞌina guitoyasa ꞌisimane be mwanena ꞌiꞌebwaꞌe ta ꞌenega ꞌisaꞌile.” ");
INSERT INTO dob_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ga Yesu ꞌieonedi, ꞌigwae, “Mosese loina nate ꞌiꞌetoladina ꞌomi ꞌimi debapaꞌala manuna. ");
INSERT INTO dob_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ta esi wada nuwaꞌiꞌisi Yaubada ꞌina mweluluwa ꞌunu ꞌenega tomota ꞌeluwa ꞌimweluluidi, meꞌolotona ta mewainena. ");
INSERT INTO dob_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gete ꞌalena ꞌenega tai tamana be sinana ꞌida pilisinedi be mwanena maꞌiyana simiyaluwa, ");
INSERT INTO dob_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","be siteluwa nidi oodi ꞌebweuna tuga. Lowa siteluwa nidi simiya dumaduma ta gete tuga niꞌatu sieꞌebweu. ");
INSERT INTO dob_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yaubada niꞌatu ꞌisaꞌu luwedi ꞌenega geyaꞌabo ꞌebweu yaita ꞌiemiya dumedumedi.” ");
INSERT INTO dob_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ꞌEnega muliyega Yesu ma ina tononoyao siilama anuwaya ga tonono nidi sienaida limana saꞌila manuna. ");
INSERT INTO dob_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ꞌEnega Yesu ꞌieonedi, “ꞌEguma yaita tai mwanena ꞌisaꞌile be ꞌiaibala mali waine ꞌena, tai gete gimimwanena ꞌena ꞌiguinuwa toꞌumalina, manuna ꞌiloelata. ");
INSERT INTO dob_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ta wate ꞌeguma waine mwanena ꞌisaꞌile be ꞌiaibala mali tai ꞌena, waine nina ꞌiloelata.” ");
INSERT INTO dob_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ta ꞌenega tomota gogama simeꞌedi Yesu ꞌenaya be ꞌaene ꞌida gitoodi. Ta ꞌina tononoyao esi gogama nidi siꞌetobodedi. ");
INSERT INTO dob_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ta Yesu ꞌina tononoyao ꞌiꞌitedi ga ꞌienapaꞌaledi, ꞌigwae, “Geyaꞌabo gogama waꞌetoꞌetobodedi, ta esi wada tagwaledi be ꞌeguya sida mai, manuna gogama getedi nadigega Yaubada ꞌina ꞌebeloina ꞌilobwene ꞌaiꞌailidi. ");
INSERT INTO dob_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Manuna ꞌabo yaisigedi taudi geyaꞌabo gogama getedi nadigega ꞌidi emisa, geyaꞌabo saꞌi Yaubada ꞌina ꞌebeloina ꞌena silugulugu.” ");
INSERT INTO dob_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ꞌEnega Yesu gogama nidi ꞌiꞌaalidi ta ꞌigitoodi ga ꞌiona obobomedi. ");
INSERT INTO dob_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ga Yesu ꞌitoolo be ꞌaene ꞌitatauya, ta ꞌebweu tai ꞌipilima ga ꞌiꞌaetulasa Yesu matanaya ta ꞌigwae, “ꞌInapwana, yamwalamwalatoni ꞌaene ꞌoyo toeꞌita boboꞌana, ꞌenega toꞌase yada guinuwe be ꞌenega yawasigu ataya yaloba?” ");
INSERT INTO dob_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ga Yesu tai nina ꞌieonena, ꞌigwae, “Mwaꞌadega ga ꞌenega ꞌuꞌawa boboꞌanegu? Manuna nigeya ꞌebweu yaita boboꞌana; nate namo Yaubada. ");
INSERT INTO dob_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ta Yaubada ꞌina loinao niꞌatu ꞌumwalamwalatonidi, nate ꞌaene: Geyaꞌabo loemwawasa. Geyaꞌabo loelata. Geyaꞌabo ꞌipwala. Geyaꞌabo simana kabokabo. Geyaꞌabo kaboega tomota ꞌidi gwegwe ꞌuꞌewaꞌewadi. Ta wate tamayo be sinayo ꞌuda ꞌamayabedi.” ");
INSERT INTO dob_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ga tai nina ꞌigwae, “ꞌInapwana, ꞌigu tuta gwamega ga batuwa loina nidi getedi yamuliya ꞌaiꞌailedi.” ");
INSERT INTO dob_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ꞌEnega Yesu ma ina gwausowala tai nina ꞌiduneyena ta ꞌigwae, “Nate namo ꞌebweuna yage ꞌilogegesemu. ꞌEnega ꞌuila ꞌimu ꞌasaya be ꞌimu gwegwe maiboꞌadi ꞌuegimwaneyedi be ꞌadi maisa ꞌueguyaiyedi togomabeso ꞌediya, ta ꞌenega ꞌumamai be ꞌumuliyegu, be ꞌenega maꞌetamo ꞌimu esaesa galewaya ꞌuda loba.” ");
INSERT INTO dob_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ona gete tai nina ꞌinonona ta ꞌina esaesa sinabwana ꞌiegagalena, ꞌenega nuwana ꞌimwau ꞌaiꞌaila, ta ꞌiila. ");
INSERT INTO dob_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ꞌEnega Yesu ꞌiloꞌita dadana ga ꞌina tononoyao ꞌieonedi, ꞌigwae, “ꞌAbo yaisigedi ma idi esaesa sinabwana ꞌidi lugu Yaubada ꞌina ꞌebeloina solanaya mwauna.” ");
INSERT INTO dob_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ta ꞌina tononoyao nuwadi ꞌiowana ꞌina ona gete manuna. ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Natugwao, Yaubada ꞌina ꞌebeloina ꞌana lugu mwau wawasae. ");
INSERT INTO dob_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Onaꞌaiꞌaila kameli tauna yobai sinabwana, ꞌenega tupwana mwauna be siyaluma ꞌana lobwalena ꞌenega ꞌilulugu, ta esi toesaesao ꞌidi lugu Yaubada ꞌina ꞌebeloina ꞌenaya mwau wawasae.” ");
INSERT INTO dob_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesu ꞌina ona gete manuna ꞌina tononoyao sinuwa owana wawasae ga sieonena, “ꞌEguma gete nadigega, yaita sana sawesawenaya be ꞌebe gwausowala ꞌiloba?” ");
INSERT INTO dob_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ꞌEnega Yesu ꞌiduneyedi ga ꞌigwae, “Yage gete mwau wawasae tomota ꞌediya, ta esi nigeya mwauna Yaubada ꞌenaya, manuna Yaubada ꞌenaya yage maiboꞌana kapekapeyana.” ");
INSERT INTO dob_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ꞌEnega Pita ꞌilolagata ga ꞌigwae, “ꞌInapwana, ꞌaboꞌama mwaꞌadega? Manuna ꞌima gwegweyao maiboꞌadi niꞌatu ꞌapilisinedi ta ꞌamuliyemu.” ");
INSERT INTO dob_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ta Yesu ꞌigwae, “Onaꞌaiꞌaila, ꞌeguma yaisigedi ꞌomi ꞌimi anuwao, tasimiyao, nuumiyao, sinamiyao, tamamiyao, natumiyao be ꞌimi bwaꞌao wate wapilisinedi, ta wate ꞌelouya wada loba manugu be tetela boboꞌana ꞌana simana manuna, ");
INSERT INTO dob_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ꞌami eꞌisa gete tuga wada loba nadigega analedi anuwao, tasimiyao, nuumiyao, sinamiyao, natumiyao be ꞌimi bwaꞌao, ta wate maꞌetamo galewaya yawasimi ataya waloba. ");
INSERT INTO dob_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ta gete tuga toanuganao yaudi maꞌetamo sida muliya be taudi simulimuliya maꞌetamo sida nugana.” ");
INSERT INTO dob_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ꞌEnega maꞌetamo ꞌedaya situꞌetuꞌe Yelusalema manuna, ga Yesu ꞌinuganugana ta ꞌina tononoyao simulimuliya, be ma idi nuwaowana, ta ꞌaina tomota wate ma idi matauta ꞌedaya simulimuliyedi. ꞌEnega ꞌina tononoyao site tuwelo nidi ꞌibwau egogona limedi ga ꞌiemataluwedi toꞌase ꞌiabe ꞌiapwesa ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ꞌigwae, “Gete tuga tatuꞌetuꞌe Yelusalema. ꞌAboꞌagu Tomota Natuna ta ꞌagu tosipupu nina ꞌida telesipupuyegu totaliyao sinabwadi be loina ꞌana toeꞌitao ꞌediya, be ꞌigu mwawasa manuna sida loina, be muliyega sida ꞌebwayaegu taudi nigeya me Yudia ꞌediya, ");
INSERT INTO dob_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","be sida tuyeyegu be sigiwaligu be balaeyega sisapigu be ꞌenega siloemwawasigu, be ꞌasiyata ꞌetoi yatoolo limana.” ");
INSERT INTO dob_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ꞌEnega Yemesa be Yoni, taudi Sebedi natunao, Yesu ꞌena simai ga sieonena, sigwae, “ꞌInapwana, ꞌamai sabi sida ꞌemuya.” ");
INSERT INTO dob_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ga Yesu ꞌigwae, “Toꞌase nuwanuwami be yada guinuwa manumi?” ");
INSERT INTO dob_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ta sigwae, “Maꞌetamo ꞌimu ꞌebeloina ꞌena nuwanuwama be selabemuya ꞌada miyatowa, ꞌebweu ꞌataimuya ta ꞌebweu gegeumimuya.” ");
INSERT INTO dob_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ta Yesu ꞌieonedi, ꞌigwae, “ꞌOmi ꞌimi sida gete ꞌana mwalatoi nigeya wamwalamwalatoni. Mwaꞌadega ꞌelouya keigana ꞌenega yanunuma, kapekapeyana be ꞌomi wate ꞌenega wanunuma? Ta wate bapitaiso mwauna nina maꞌetamo yaloba, mwaꞌadega ꞌomi wate nadigega sawesawemiya be wada bapitaisoꞌesa?” ");
INSERT INTO dob_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ꞌEnega sigwae, “Sawesawemaya.” Ta Yesu ꞌigwae, “Onaꞌaiꞌaila, keiga nina ꞌenega yanunuma ꞌomi wate ꞌenega wanunuma, be wate bapitaiso nina ꞌenega ꞌiabe yada bapitaiso ꞌomi wate ꞌenega wada bapitaiso, ");
INSERT INTO dob_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ta esi nigeya sawesaweguya be yaesinuwa yaisigedi maꞌetamo ꞌigu etoloina ꞌenaya ꞌataiguya be gegeumiguya sida miyatowa, manuna Yaubada tauna ꞌina ꞌebeloina be ꞌiesinuwa.” ");
INSERT INTO dob_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ta tononoyao site sanau Yemesa be Yoni ꞌidi sida sinonona ga sigamwasowaledi. ");
INSERT INTO dob_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ꞌEnega Yesu maiboꞌadi ꞌibwau egogonedima ga ꞌieonedi, “ꞌOmi wamwalatonina taudi baleꞌuya sieesedi ꞌaene ꞌinapwanao ꞌidi tomotaiyao siloiloina paꞌaledi. ");
INSERT INTO dob_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ta ꞌomi geyaꞌabo wate nadigega taudi waguiguinuwaꞌesa. Ta ꞌeguma yaita ꞌoyo nuwanuwayo be ꞌemiyega ꞌuetoloina ꞌilobwenemu be gosemwao manudi ꞌuda etoguinuwa. ");
INSERT INTO dob_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ta wate ꞌeguma yaita ꞌoyo nuwanuwayo be ꞌemiyega ꞌuetoanugana, ꞌilobwenemu be gosemwao maiboꞌadi manudi ꞌuetopaisewa. ");
INSERT INTO dob_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","“Ta ꞌaboꞌagu Tomota Natuna yamai baleꞌuya nigeya ꞌaene tomota manugu siguinuwa, ta esi sabi guinuwa tomota manudi, ta wate yatagwalegu be yamwamwawasa tomota maiboꞌami ꞌami etoliꞌama manuna.” ");
INSERT INTO dob_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ꞌEnega simai Yeliko ꞌena, ga tuta nina Yesu ma ina tononoyao Yeliko sipilisinena, boda sinabwana siꞌoayabudi, ga tomata kebokebo ꞌana esana Batimio silobena, tauna Timio natuna, ta tuta yauna ꞌeda tupitupinaya ꞌimiyami ta ꞌiesidasida mani be gwegwe manudi. ");
INSERT INTO dob_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ga Batimio nina ale ꞌinonona ꞌaene Yesu goma Nasaleta ꞌitautauya, ꞌenega Yesu ꞌena ꞌibwau, ꞌigwae, “Yesu ye, ꞌoyo Debida ꞌina susu, ꞌuda ꞌatenuwa ꞌoleꞌoleyegu!” ");
INSERT INTO dob_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ꞌEnega tomota maiboꞌadi Batimio nina siꞌetobodena, sigwae, “Ulosaꞌu! Tuwa bwau!” Ta tuga ꞌibwau toitoila, ꞌigwae, “Debida tubuna ye, ꞌuda ꞌatenuwa ꞌoleꞌoleyegu.” ");
INSERT INTO dob_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ꞌEnega Yesu ꞌitoolo, ta ꞌiona, “Wada bwauyenama.” Ga tomota sigwae, “Boboꞌana, ꞌutoolo. Yesu ꞌibwauyemu.” ");
INSERT INTO dob_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ꞌEnega ꞌana talaꞌapwala ꞌiꞌewa yaulena ga ꞌitoolo manini, ga Yesu ꞌena ꞌimai. ");
INSERT INTO dob_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ta Yesu ꞌieonena ꞌigwae, “Toꞌase nuwanuwayo be manuyo yada guinuwe?” Ga tomata kebokebo nina ꞌigwae, “ꞌInapwana, kapekapeyana be matagu ꞌuda gieꞌesasedi?” ");
INSERT INTO dob_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ꞌEnega Yesu ꞌieonena, ꞌigwae, “Boboꞌana! Gete tuga ꞌimu emisa ꞌenega matayo ꞌiꞌesasedi niꞌatu.” Gote ꞌena matana ꞌiꞌesasedi, ga ꞌedaya Yesu ꞌimuliyena. ");
INSERT INTO dob_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ꞌEnega situꞌetuꞌe Yelusalema manuna ga ꞌasa gidalidi Betani ta Betipegi selabediya silogelogedo, nate ꞌoya Olibe ꞌagalaunaya, ta Yelusalema nuganidiya tupwana ꞌedasola. ꞌEnega Yesu ꞌina tononoyao ꞌeluwa ꞌigimi etunedi sena nidi gidalidi ꞌediya ma ꞌadi emataluwa, ");
INSERT INTO dob_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ꞌigwae, “Watauya ꞌasa gote matamiya ꞌenaya, ta ꞌeguma waapwesa ꞌasa nina matanaya, yobai ꞌebweu waꞌitaloba kaiwe ꞌena silosipwena, nate ase mwaneyauna, tauna nigeya tomota sida gelu toona. Yobai nina waliꞌami be wameꞌe. ");
INSERT INTO dob_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ta ꞌabo ꞌebweu yaita ꞌienaida ꞌemiya be ꞌigwae, ‘Toꞌase manuna nate yobai nina waliꞌaliꞌami?’ tai nina waeona, ‘ꞌInapwana nuwanuwana, be tuta kukupana namo be ꞌida etune ilenama.’ ” ");
INSERT INTO dob_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ꞌEnega site luwa nidi sitauya ꞌasa nina ꞌenaya ga yobai ase silobena anuwa mataꞌawaninaya, ta kaiwe ꞌena silosipwena, ꞌenega sieꞌale be siliꞌami. ");
INSERT INTO dob_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Siliꞌaliꞌami ta ꞌaina tomota sitootoolo selabediya sigwae, “Toꞌase manuna nate yobai nina waliꞌaliꞌami?” ");
INSERT INTO dob_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ta site luwa nidi sigwae, “ꞌInapwana nuwanuwana, be tuta kukupana namo be ꞌida etune ilenama,” ga ꞌediya sitagwalena. ");
INSERT INTO dob_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ta yobai nina siꞌewena ga sitauyena Yesu ꞌena, ga ꞌadi ꞌoamega gwauna siloesona, ꞌenega Yesu ꞌigelutuꞌe, ga ꞌitautauya. ");
INSERT INTO dob_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta boda yaudi wate ꞌadi ꞌoamao ꞌedaya siesodi, ta ꞌaidi kaiwe nalidi mayawadi siguledi ꞌeda ꞌana eiyala manuna. ");
INSERT INTO dob_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ta ꞌaina boda Yesu sianuganena ta ꞌaina boda siamuliya, ga maiboꞌadi silotuputupu ta sibwaubwau, sigwae, “Kamatoki ꞌInapwana, Yaubada ꞌana esanega ꞌumai sabi ꞌetoseyema. ");
INSERT INTO dob_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ꞌEbeloina tubumao Debida ꞌenega ꞌiapwesa limanama. Gete manuna Yaubada Toloetana sana ꞌatuputupu.” ");
INSERT INTO dob_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ga Yesu niꞌatu Yelusalema ꞌena ꞌiapwesa ga Anuwa Tabu ꞌena ꞌilugu, ga yage yauna Anuwa Tabu solanaya ꞌiduneyedi, ta niꞌatu ꞌasuinuwanuwa, ꞌenega ma ina tononoyao site tuwelo siila Betani ga nada siꞌeno. ");
INSERT INTO dob_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ga tomwa ꞌiulisina ga sitoolo ga Betaniyega siilaila limana Yelusalema manuna, ta Yesu ꞌibotana, ");
INSERT INTO dob_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ga ꞌedasolega kaiwe ꞌana ꞌita ꞌatuwa damaya mayawana ꞌiꞌitena, ꞌenega ꞌinao selabenaya be nuwanuwana ꞌaene uwanega ꞌida loepaꞌala, ta esi ꞌiꞌitena yawa daisinamo, tuga ꞌaweuwauwa maꞌetamo ꞌadi tuta. ");
INSERT INTO dob_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ꞌEnega Yesu kaiwe nina ꞌibaꞌena ga ꞌigwae, “Geyaꞌabo wate ꞌuuwauwa limana be tomota ꞌenega siꞌeꞌai.” Ga ꞌina ona gete ꞌina tononoyao sinonona. ");
INSERT INTO dob_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ꞌEnega Yelusalema ꞌena simai, ga Anuwa Tabu solanaya ꞌilugu, ga toegimwaneyao be togimwaneyao solanega ꞌipaꞌi apwesedi, ta mani ꞌana toesaꞌugelasao ꞌidi tebeli ꞌiꞌaubuiyedi, ta bunebune ꞌadi toegimwaneyao ꞌidi ꞌebemiya wate ꞌiꞌaubuiyedi. ");
INSERT INTO dob_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta wate anuwa solana ꞌiegagalena be geyaꞌabo tomota ma idi gwegwe sitautauya anuwa solanega. ");
INSERT INTO dob_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ga ꞌieꞌitedi ꞌigwae, “Nai Buki Tabu ꞌena Yaubada ꞌina ona siꞌetoladina wamwalatonina, ꞌigwae, ‘ꞌIgu anuwa sida eese anuwa ꞌebe sidasida tomota maiboꞌadi manudi,’ ta ꞌomi wagibunina ga ꞌaene ꞌimi ꞌebe ꞌipwala.” ");
INSERT INTO dob_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ta totaliyao sinabwadi be loina ꞌana toeꞌitao Yesu ꞌina guinuwa gete tetelina sinonona, ꞌenega sigamwasowalena ga sinuwa edaedadama be sida loemwawasi, ta nigeya sawesawediya, manuna simatautena, ta wate Yesu ꞌina eꞌitao tomota yauyaudi nuwadi ꞌiꞌewena. ");
INSERT INTO dob_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga niꞌatu ꞌiboi, ꞌenega Yesu ma ina tononoyao ꞌasa nina siebesinena. ");
INSERT INTO dob_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ta tomwa ꞌiulisina ga sitoolo sabi ila Yelusalema, ga ꞌedaya sitautauya, ta Yesu kaiwe nina ꞌibaꞌebaꞌenaya siꞌitena niꞌatu yawana maiboꞌana siꞌoapelu. ");
INSERT INTO dob_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ꞌEnega Pita Yesu ꞌina ona ꞌinuwaꞌiꞌisina ga ꞌigwae, “ꞌInapwana, ꞌuꞌita kaiwe nina ꞌubaꞌebaꞌenaya niꞌatu ꞌiꞌoapelu.” ");
INSERT INTO dob_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ta Yesu ꞌieonedi, ꞌigwae, “ꞌEguma ꞌimi emisa wasaꞌu Yaubada ꞌena, ꞌomi wate ꞌimi guinuwa waiwaidi wada guinuwedi. ");
INSERT INTO dob_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Wate yaona ꞌaiꞌaila ꞌemiya ꞌeguma yaita ꞌoyo nigeya ꞌuda enuwanaluwa ta esi ꞌuemiemisa be toꞌase ꞌuda ona sida apwesa tuga, ꞌeguma ꞌoya gote ꞌuloine be ꞌugwae, ‘ꞌUmiya dolo olaya,’ ꞌimu ona ꞌida ematamatane tuga. ");
INSERT INTO dob_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“ꞌEnega yaeonami toꞌase waside Yaubada ꞌena, wada emisa tuga be maꞌetamo wada loba. ");
INSERT INTO dob_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wate ꞌabo wasidasida Yaubada ꞌena, gosemiyao ꞌidi loegesiyao wanuwataudi ꞌabo toꞌase ꞌidi bubuna ꞌemiya, be gete ꞌenega Tamami galewaya ꞌomi wate ꞌimi loegesiyao ꞌida nuwataudi.” ");
INSERT INTO dob_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(-) ");
INSERT INTO dob_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ꞌEnega niꞌatu siilama Yelusalema, ta Yesu Anuwa Tabu solanaya ꞌiadadana, ga totaliyao be loina ꞌana toeꞌitao be wate ꞌinapwanao simai, ");
INSERT INTO dob_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ga Yesu sienaidena, sigwae, “Tai, yaita ꞌina loinega ga gete nadigega ꞌuguiguinuwaꞌesa?” ");
INSERT INTO dob_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ga Yesu ꞌieonedi, ꞌigwae, “Nugana yagimi enaida ꞌemiya be ꞌeguma waeꞌisa, ꞌaboꞌagu wate yaeonami ꞌigu loina manuna. ");
INSERT INTO dob_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ꞌIgu enaida gete: Yaita ꞌina loinega ga Yoni togiebapitaiso ꞌiguiguinuwa? Yaubada, nai ꞌebweu tomota?” ");
INSERT INTO dob_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ꞌEnega taudimo ꞌediya siegewagewana, sigwae, “ꞌIna ona mwaꞌadega taeꞌisaꞌese? Manuna ꞌabo tagwae, ‘Yaubada ꞌenega,’ ꞌiabe ꞌieona limada be ꞌigwae, ‘Ta! Toꞌase sana manuna ga Yoni nigeya waemiemise?’ ");
INSERT INTO dob_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ta ꞌeguma tagwae, ‘Tomota ꞌenega,’ ꞌiabe pwalu sigamwasowaleda.” Manuna tomota yaudi Yoni siemisena ꞌaene tauna palopita ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ꞌEnega Yesu ꞌina enaida nigeya sieꞌieꞌisa ꞌaiꞌaili, ta esi sigwae, “Nigeya ꞌamwalamwalatoni.” Ta Yesu ꞌieonedi, ꞌigwae, “ꞌAboꞌagu geyaꞌabo wate ꞌemiya yasimasimana apwesa yaita ꞌina loinega ga gete nadigega yaguiguinuwaꞌesa.” ");
INSERT INTO dob_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ꞌEnega Yesu ꞌiona semalimaliyedi, ꞌigwae, “ꞌEbweu tai ꞌina bagula ꞌiasona oine daisinamo ga ꞌali ꞌiguinuwena, ga oine ꞌana ꞌebebibi ꞌiguinuwena ga anuwa bagula solanaya ꞌiꞌabina, ꞌenega ꞌina toguinuwao ꞌiloinedi be siꞌitaꞌiꞌisi, ta tauna ꞌitauya mali esenaya. ");
INSERT INTO dob_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ta sesoi ꞌana tutaya, ꞌinapwana nina ꞌina ꞌaliꞌei ꞌebweuna ꞌietunena be ꞌaene oine uwana bagula ꞌana toꞌitaꞌiꞌitao ꞌediyega ꞌida meꞌedi. ");
INSERT INTO dob_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ꞌItautauya ga nigeya siꞌebwaꞌebwaꞌe, ta esi sigiyaina ga sisapina ꞌenega maꞌanimenimenamo sietunena ga ꞌiila. ");
INSERT INTO dob_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“ꞌEnega ꞌinapwana nina ꞌina ꞌaliꞌei ꞌeluwena wate ꞌietunena ꞌediya, ga siununa debanaya ga ma ina omayamaya ꞌiila. ");
INSERT INTO dob_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Ta wate ꞌetonina ꞌietunena ꞌediya ga siloemwawasina. Ta yaudi wate ꞌietunedi ꞌediya ga ꞌaidi sisapidi ta ꞌaidi siloemwawasidi, ga ꞌenega maiboꞌadi sigie toꞌumaliyedi. ");
INSERT INTO dob_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Gote ꞌena ꞌebweuna namo ꞌimiyami, tauna natuꞌaiꞌailina. ꞌEnega tauna wate ꞌietunena ꞌediya, ꞌigwae, ‘Tauna sana natugu, ꞌenega sida ꞌamayabe.’ ");
INSERT INTO dob_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ta niꞌatu natuna ꞌiapwesa ꞌediya ga toꞌitaꞌiꞌitao nidi taudimo ꞌediya sigwae, ‘Gosemao, ꞌInapwana gete natuna ꞌimeemai, ꞌenega batuwa nina taloemwawasi be ꞌaboꞌada bagula taloine.’ ");
INSERT INTO dob_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ta sigiyaina ga siloemwawasina ga bagula ꞌetaulunaya siula apwesena.” ");
INSERT INTO dob_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ga niꞌatu Yesu ꞌina emwasala ꞌigumwala, ga ꞌienaida ꞌediya, ꞌigwae, “Toꞌase ꞌiabe ꞌinapwana nina ꞌiguinuwe? Onaꞌaiꞌaila ꞌinapwana nina ꞌimama be toguinuwa nidi ꞌiloemwawasidi, be ꞌenega bagula nina mali toꞌitaꞌiꞌitao ꞌiꞌebwaꞌedi.” ");
INSERT INTO dob_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ꞌEnega Yesu wate onasemalimali Buki Tabu ꞌenega ꞌisimanena, ꞌigwae, “Wanuwaꞌiꞌisi Buki Tabu ꞌina simana gete nadigega: ‘ꞌOla nina lowa toꞌabi anuwa siguitoyasena. Ta gete tugai niꞌatu sietoolona be ꞌieꞌola nugana, be ꞌola maiboꞌadi ꞌiloinedi. ");
INSERT INTO dob_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nate ꞌInapwana ꞌina guinuwa ꞌebe nuwaowana ꞌedaya.’ ” ");
INSERT INTO dob_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesu ꞌina onasemalimali gete totaliyao sinabwadi be Palisiyao sinonona ga simwalatonina ꞌaene taudi tuga manudi ꞌionaona, ꞌenega ꞌaina ꞌedaꞌeda siꞌebesena be sida giyai, ta esi nigeya sigiyagiyai manuna simatauta pwalu ꞌediya. ꞌEnega sipilisinena ga sitauya. ");
INSERT INTO dob_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ta ꞌenega ꞌinapwanao nidi ꞌaina Palisiyao be wate Elodi ꞌina bodao sietunedi Yesu ꞌenaya be enaidega sikaboe be ꞌina loegesi siloba. ");
INSERT INTO dob_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ꞌEnega Yesu ꞌena simai ga sieonena, sigwae, “ꞌInapwana, niꞌatu ꞌamwalatonimu ꞌaene ꞌoyo toeꞌita ꞌaiꞌaila, ta tomota ꞌidi waiwai manuna nigeya ꞌumatamatauta, ta tuga ona ꞌaiꞌaila ꞌusimana leleleya tomota maiboꞌadi ꞌediya, nate Yaubada ꞌina ꞌeda ꞌueꞌita ꞌaiꞌaila. ꞌEnega mwaꞌadega? Sawesawenaya be Kini Sisa manuna takisi tasaꞌu, nai nigeya? ");
INSERT INTO dob_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Takisi nina taemaisi Kini ꞌenaya, nai nigeya?” Ta Yesu ꞌidi kabo niꞌatu ꞌimwalatonina, ꞌenega ꞌieonedi, ꞌigwae, “Toꞌase manuna watootoogu? Abaga mani nina wameꞌe be yaꞌita.” ");
INSERT INTO dob_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ꞌEnega mani ꞌebweuna siꞌebwaꞌena. Ga Yesu ꞌieonedi, ꞌigwae, “Wada eonagu, mani gete ꞌena yaita ꞌana maꞌamaꞌyau ta ꞌana esana?” Ta sigwae, “Kini Sisa.” ");
INSERT INTO dob_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ꞌEnega Yesu ꞌieonedi, “O nadigega. ꞌEnega ꞌeguma Kini ꞌina yage waꞌebwaya Kini ꞌenaya, ta ꞌeguma Yaubada ꞌina yage Yaubada waꞌebwaꞌe.” Ga Yesu ꞌina ona gete manuna nuwadi ꞌiowana sinabwana. ");
INSERT INTO dob_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ꞌEnega wate Sadusiyao, taudi nigeya siemiemisa tomwawasa ꞌidi toololimana manuna, simai ga Yesu ꞌena sienaida, sigwae, ");
INSERT INTO dob_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ꞌInapwana, loina gete nadigega Mosese ꞌiꞌetoladina manuda, ꞌigwae, ‘ꞌAbo ꞌebweu tai ꞌiai be nigeya natunamo ta ꞌimwamwawasa, tai nina tasina kwabulinana maꞌiyana sida ai, be ꞌenega ꞌabo waine ꞌienatuna, natunao tokwaiya nina ꞌana lopaꞌeluyao.’ ” ");
INSERT INTO dob_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ꞌEnega ꞌebeꞌita siꞌebwaꞌena, sigwae, “ꞌEbweu tai matasinao simiyami ꞌadi yau site sebeni, ga ꞌadi tomatuwa nina ꞌiai ga nigeya natunamo ta tai nina ꞌimwawasa. ꞌEnega wate tasina selabenega kwabula nina ꞌiaina ga wate nadigega nigeya natunamo ta ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ꞌEnega tasina selabenega kwabula nina ꞌiꞌewena ga wate simiyamiyana ta nigeya natunamo, ta tai nina ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ta nadigega tuga tasinao maiboꞌadi kwabula nina siaiai ta simwawamwawasa, ta nigeya wate natudimo. Ta muliyega waine wate ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ꞌEnega toololimana ꞌana tutaya waine nina to tai batu mwane ꞌaiꞌailina? Manuna site sebeni nidi niꞌatu siaina.” ");
INSERT INTO dob_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ta Yesu enaida gete ꞌieꞌisena, ꞌigwae, “Gete ꞌimi loegesi, manuna Buki Tabu nigeya wamwalamwalatoni, ta wate Yaubada ꞌina waiwai nigeya wamwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Toololimana mulinaya tomota geyaꞌabo siaiai, ta esi ꞌidi miya aneloseyao galewaya nadigega. ");
INSERT INTO dob_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Lowaenei Yaubada Mosese ꞌieonena toololimana manuna, ꞌabo Buki Tabu wasawai wada ꞌitaloba. Manuna tuta nina Mosese mitawaya ꞌitautauya ta Yaubada kaiwe sabelulu ꞌenega Mosese nina ꞌieonena, ꞌigwae, ‘ꞌAboꞌagu Ebelaamo ꞌina Yaubada ta Aisake ꞌina Yaubada ta Yekobe ꞌina Yaubada.’ ");
INSERT INTO dob_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yaubada nigeya tomota mwawamwawasidi ꞌidi Yaubada, ta esi tomota mayawasidi ꞌidi Yaubada. Ta ꞌomi ꞌimi eꞌita yage gete manuna nigeya palupaluna.” ");
INSERT INTO dob_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ꞌEnega loina ꞌana toeꞌita ꞌebweu ꞌimai ga taudi ꞌidi egewagewana Yesu maꞌedi ꞌinonona ga ꞌidi enaidao ꞌadi eꞌisa Yesu ꞌenega ꞌinonodi boboꞌana wawasae, ꞌenega tauna wate Yesu ꞌena ꞌienaida, ꞌigwae, “ꞌInapwana, loinao maiboꞌadi ꞌediyega to loina sinabwana?” ");
INSERT INTO dob_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta ꞌenega Yesu ꞌigwae, “Loina sinabwana gete: ꞌOmi me Isileli ꞌigu ona gete wanonoi ꞌaene ꞌInapwana Yaubada tebweuna namo, ");
INSERT INTO dob_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ꞌenega ꞌimu ꞌInapwana Yaubada ꞌuda obobome ꞌateyo be yaluyaluwayo be nuwayo be wate ꞌimu waiwai maiboꞌana ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Ta ꞌebweu wate loina sinabwana gete: Gosemwao ꞌuda obobomedi, nadigega tauyo ꞌamu oboboma. “Loina ꞌeluwa getedi loina maiboꞌadi sisinabwa sinedi.” ");
INSERT INTO dob_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ꞌEnega loina ꞌana toeꞌita nina Yesu ꞌina ona ꞌinonona ga ꞌigwae, “ꞌInapwana, ꞌimu ona nate ona ꞌaiꞌaila ꞌaene tauna tebweuna tuga Yaubada, ta nigeya ꞌebweu wate Yaubada ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ꞌEnega ꞌilobweneda be taobobome ꞌateda maiboꞌanega be nuwada maiboꞌanega be ꞌida waiwai maiboꞌanega, be wate gosedao tada obobomedi nadigega tauda taobobomeda. Loina ꞌeluwa getedi taliya yauyaudi be ꞌebwayadaitao maiboꞌadi sisinabwa sinedi, aga?” ");
INSERT INTO dob_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ta Yesu tai nina ꞌina ona ꞌinonona ꞌaene palupaluna, ga ꞌieonena, ꞌigwae, “Nate ona ꞌaiꞌaila, ta ꞌoyo Yaubada ꞌina ꞌebeloina ꞌena niꞌatu ꞌuloselabena.” ꞌEnega muliyega tomota Yesu simatautena ga nigeya ꞌebweu yaita ꞌitootoo be ꞌienaida limana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ta ꞌenega Yesu Anuwa Tabu solanaya ꞌieꞌieꞌita tomota ꞌediya, ga ꞌieonedi, ꞌigwae, “Mwaꞌadega ga ꞌenega ꞌaina loina ꞌana toeꞌitao sigwae ꞌaene Debida ꞌina susuyega Toꞌetoseyana Keliso ꞌiapwesa, ");
INSERT INTO dob_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","manuna lowa Yaluyaluwa Tabuna Debida ꞌigiesinapuna ga Debida Toꞌetoseyana nina ꞌiꞌawa ꞌinapwanena, ꞌigwae: Yaubada ꞌiona ꞌigu ꞌInapwana ꞌenaya, ꞌigwae, “ꞌAtaiguya ꞌumiyatowa be ꞌana laba ꞌamu talauwalao yasaꞌu mwaꞌutedi ꞌaeyo ꞌubuninaya.” ");
INSERT INTO dob_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Debida nina ꞌina ꞌInapwana Keliso, ꞌenega mwaꞌadega sana ga Debida ꞌina susuyega muliyega Keliso ꞌiapwesama?” Ta boda maiboꞌadi Yesu ꞌina eꞌita nuwadi ꞌiꞌewena. ");
INSERT INTO dob_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Geyaꞌabo loina ꞌana toeꞌitao ꞌidi bubuna wamulimuliye. Manuna taudi adelidi tuga nadigega tuta yauna nuwanuwadi be ꞌadi ꞌoamao duduladi siꞌotedi be tomota gamwagamwanidiya sisakosakowasi be ꞌaene sida ꞌamayabedi. ");
INSERT INTO dob_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ta wate nuwanuwadi ꞌebemiya boboꞌadi Anuwa Tapwalolo ꞌediya, be wate sagali ꞌadi tutaya nuwanuwadi be bwaimaya sida miyatowa. ");
INSERT INTO dob_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ta wate tuta yauna tomota matadiya Yaubada ꞌena sisidasida dudulana, ta esi ꞌidi sida nina nigeya boboꞌana, manuna ꞌatediya sinuwanuwa mwaꞌadega ꞌiabe kwabulao sikaboꞌesedi be ꞌidi gwegweyao siꞌewadi. ꞌEnega maꞌetamo Yaubada eꞌisa toꞌumalina ꞌiꞌebwaꞌedi.” ");
INSERT INTO dob_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ꞌEnega Yesu ꞌebwayadaita ꞌana ꞌebesaꞌu deinaya ꞌimiyatowa, ga tomota yaudi ꞌidi ꞌebwayadaita mani sisaꞌusaꞌu ta Yesu ꞌiyoꞌoyoꞌo, ga toesaesao ꞌidi ꞌebwayadaita sinabwadi ꞌiꞌitedi, ");
INSERT INTO dob_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ta wate kwabula gomagomabesona ꞌiꞌitena ꞌina ꞌebwayadaita toea ꞌeluwa namo ꞌisaꞌudi. ");
INSERT INTO dob_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ꞌEnega Yesu ꞌina tononoyao ꞌibwau egogonedima, ga ꞌieonedi, ꞌigwae, “Onaꞌaiꞌaila, kwabula gote ꞌina ꞌebwayadaita maiboꞌadi ꞌidi ꞌebwayadaita ꞌisinabwa sinedi. ");
INSERT INTO dob_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Manuna maiboꞌadi ꞌidi tupwa sinabwana ꞌimiyami, ta esi kwabula gote gomagomabesona ta ꞌina mani maiboꞌana ꞌisaꞌuna, ga nigeya ꞌebweu wate ꞌina tupwa ꞌimiyami be ꞌenega ꞌana masula ꞌida gimwane.” ");
INSERT INTO dob_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ꞌEnega Yesu ma ina tononoyao Anuwa Tabu ꞌenega siapwesa, ga ꞌina tonono ꞌebweu Anuwa Tabu ꞌana anuwao Yesu ꞌena ꞌieꞌitaena, ꞌigwae, “ꞌInapwana ꞌuꞌita anuwa getedi ꞌadi guinuwa boboꞌana wawasae, gulewa sinabwadi ꞌediyega siꞌabidi.” ");
INSERT INTO dob_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ta Yesu ꞌigwae, “Anuwa nidi sinabwadi ꞌuꞌitaꞌitadi maꞌetamo maiboꞌadi siligeya yauledi be geyaꞌabo wate ꞌebweu tupwa waꞌitaꞌita lima.” ");
INSERT INTO dob_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Muliyega Yesu ꞌitauya Olibe ꞌoyana ꞌena ga ꞌimiyatowaya ta ꞌenega Anuwa Tabu Yelusalema ꞌenaya ꞌidunedune, ga Pita, Yemesa, Yoni be Anidulu simai ga taudimo Yesu maꞌedi, ꞌenega sieonena, sigwae, ");
INSERT INTO dob_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ꞌInapwana, ꞌueonama to tuta ꞌena Anuwa Tabu nidi siligeidi ta to weꞌiweꞌiyaya ꞌadi ꞌita ꞌediyega ꞌada mwalatoni ꞌaene yage nidi ꞌuonaediya ꞌiabe siapwesama?” ");
INSERT INTO dob_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ꞌEnega Yesu ꞌilolagata ga ꞌediya ꞌigwae, “Waꞌitaꞌiꞌisimi ꞌabona nai tomota ꞌaidi sikaboemi. ");
INSERT INTO dob_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Manuna maꞌetamo tomota yaudi ꞌagu esanega simama be ꞌaene sianugana gesiyemi, be ꞌebweuna ꞌebweuna ꞌida gwae, ‘ꞌAboꞌagu Toꞌetoseyana nina,’ be tomota yaudi sida muliyedi. ");
INSERT INTO dob_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wate ale ꞌetamo wanonodi saiyao selabemiya ta ꞌedasolaya manudi, ta geyaꞌabo waꞌateꞌate saꞌala, manuna yage getedi sida apwesa nugana ta esi baleꞌu ꞌana ꞌebe losalowa ꞌana tuta maꞌetamo. ");
INSERT INTO dob_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Manuna ꞌetamo mali boda mali boda ꞌediya sida losaiya, ta wate mali ꞌebeloina mali ꞌebeloina ꞌediya sida losaiya, be wate mwaniꞌiniꞌi siapwesa sena yaudi ꞌediya, be botana sinabwadi sida apwesa. Ta yage getedi tuta mwaudi ꞌana ꞌebe eꞌale tuga. ");
INSERT INTO dob_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ta ꞌomi esi waꞌitaꞌiꞌisimi, manuna tomota sida giyaimi be sitauyemi etala manuna, be Anuwa Tapwalolo ꞌediya ꞌetamo sisapisapimi, ta wate ꞌiabe toloinao be kiniyao matadiya siꞌauꞌewami be watoolo ta sietalaemi, manuna ꞌomi ꞌaene ꞌigu bodao, be teteligu ꞌediya wada simane. ");
INSERT INTO dob_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ta tetela boboꞌana ꞌida ꞌelelewana nugana sena maiboꞌana ꞌediya be muliyega tuta ꞌana ꞌebe losalowa ꞌida apwesa. ");
INSERT INTO dob_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Ta ꞌabo toloinao matadiya sietoolomi sabi etala, geyaꞌabo waꞌateꞌate saꞌala be ꞌaene wada onaꞌesa, ta esi ma imi ꞌatepatu wada ona tuga, manuna nigeya ꞌomi ꞌimi ona wasimasimane, ta esiya Yaluyaluwa Tabuna tuta gote ꞌena ona ꞌiꞌebwaꞌemi be wasimana apwese. ");
INSERT INTO dob_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ta wate tuta simeemai ꞌediya tomota ꞌidi susu solanaya losaiya ꞌida apwesa manugu, nate tai tasina ꞌisipupuyei be siloemwawasi. Be nadigega wate tamana natuna ꞌida sipupuyei be siloemwawasi. Be wate gogama sinadiyao be tamadiyao sida etalauwaledi be siloemwawasidi. ");
INSERT INTO dob_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Be tomota maiboꞌadi sida etalauwalemi manuna ꞌomi ꞌaene ꞌagu toemisao. Ta ꞌabo yaita ꞌieꞌalamaꞌiꞌita be ꞌitoolopaꞌala be ꞌana laba tuta ꞌana ꞌebe losalowa ꞌenaya, gwausowala ataya ꞌida loba. ");
INSERT INTO dob_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Maꞌetamo ꞌeguma tomota waꞌita yage toꞌumali wawasae ta gadilulu sietoolo sena etaetabuna ꞌena (ꞌAbo yaita ona gete ꞌisawai ꞌida nuwa sabwalena), tuta gote ꞌenaya Yudia ꞌana tomiyanao ꞌilobwenedi be ꞌoya ꞌediya sidedena. ");
INSERT INTO dob_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ta ꞌeguma yaita bwaimaya ꞌimiyami ꞌida dena manini ta geyaꞌabo ꞌilugulugu limana ꞌina anuwaya ꞌina gwegwe sabi ꞌewadi. ");
INSERT INTO dob_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Be ꞌabo yaita bagulaya ꞌipaipaisewa geyaꞌabo ꞌiilaila ꞌana ꞌoama mali esenaya ꞌisaꞌunaya manuna. ");
INSERT INTO dob_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Ta tuta gote ꞌenaya toꞌeuwanao be toesusuyao sienuwaꞌoleꞌole. ");
INSERT INTO dob_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ꞌEnega wada sidasida be tuta boboꞌana Yaubada ꞌida ꞌebwaꞌemi ꞌimi tuta dena ꞌenaya, ta geyaꞌabo gogai ꞌana tutaya. ");
INSERT INTO dob_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","“Onaꞌaiꞌaila tuta gote mwau wawasae, manuna tuta nina Yaubada baleꞌu ꞌimweluluina ꞌenega ga batuwa nigeya ꞌebweu wate mwau gete nadigega, ta muliyega mwau gete geyaꞌabo wate ꞌiapwesapwesa limana. ");
INSERT INTO dob_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mwau gote ꞌana ꞌasiyatao ꞌeguma Yaubada geyaꞌabo ꞌigiegie kukupai ꞌiabe tomota maiboꞌadi simwamwawasa, ta esi Yaubada ꞌasiyata nidi ꞌida giekukupa, nate tauna ꞌina tomotai esiesinuwadi manudi. ");
INSERT INTO dob_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ꞌEnega ꞌabo yaita ꞌieonami be ꞌigwae, ‘Keliso gete’ nai ‘Gote’ geyaꞌabo waeemisedi. ");
INSERT INTO dob_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Manuna Keliso kabokabo be palopitao kabokabo ꞌiabe siapwesa be weꞌiweꞌiyaya waiwaidi tomota ꞌediya sida eꞌitaedi, be ꞌediyega ꞌabo sawesawediya Yaubada ꞌina bodao esiesinuwadi sikwakwani. ");
INSERT INTO dob_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ꞌEnega waꞌitaꞌiꞌisimi manuna yage getedi manudi niꞌatu yagimi simanedi ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ta tuta mwau nina ꞌigugumwala be muliyega sinala ꞌiguguyoi be wate nawalae ꞌina maedana ꞌikwekweu, ");
INSERT INTO dob_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","be kwadimao galewega sibebeꞌu, be yage yauyaudi galewaya simiyami ꞌidi waiwai sida neneta. ");
INSERT INTO dob_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ꞌAboꞌagu Tomota Natuna, be tuta gote me baleꞌu maiboꞌadi siꞌitagu pwanega yamwaꞌumwaꞌutama ma igu waiwai ta ma igu esaesa sinabwana, ");
INSERT INTO dob_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","be ꞌenega ꞌigu aneloseyao yaetunedi be ꞌigu boda esiesinuwadi siegogonedima baleꞌu be galewa be yagila maiboꞌadi ꞌidi senao ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ꞌEbe ꞌita saido ꞌenega yada eꞌitami ꞌaene ꞌeguma saido yawadi auwaudi ꞌigalugalu wamwalatonina ꞌaene losiye ꞌana tuta ꞌiloseloselabe. ");
INSERT INTO dob_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ta wate weꞌiweꞌiyaya nidi niꞌatu ꞌemiya yasimanedi, ꞌeguma to tuta waꞌitalobadi niꞌatu wamwalamwalatoni ꞌaene ꞌigu tuta ila limanama niꞌatu ꞌiloseloselabena. ");
INSERT INTO dob_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Onaꞌaiꞌaila ꞌepata gete geyaꞌabo wagumwagumwala be ꞌana laba yage nidi maiboꞌadi sida apwesa. ");
INSERT INTO dob_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Maꞌetamo galewa ta baleꞌu sisasawala ta ꞌigu onao geyaꞌabo saꞌi sisawasawala. ");
INSERT INTO dob_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nigeya ꞌebweu yaita ꞌimwalamwalatoni to tuta nai to ꞌasiyata ꞌena yaila limanama, ta wate aneloseyao galewaya nigeya simwalamwalatoni. ꞌAboꞌagu wate nigeya yamwalamwalatoni. Ta Tamagu tebweuna namo ꞌimwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ꞌEnega walomataꞌiꞌita manuna ꞌigu tuta ila limanama nigeya wamwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ꞌEbeꞌita wate Yesu ꞌiꞌebwaꞌedi, ꞌigwae, “ꞌEguma ꞌebweu ꞌinapwana ꞌiabe ꞌina anuwa ꞌida pilisine be ꞌitatauya mali senaya, ꞌina toguinuwao ꞌebweuna ꞌebweuna ꞌidi paisewa ꞌiꞌebwaꞌedi, be ꞌiloinedi be ꞌaene ꞌina anuwa siꞌitaꞌiꞌisi, ta wate anuwa ꞌana ꞌawa ꞌana toꞌitaꞌiꞌita ꞌieonena, ꞌigwae, ‘Geyaꞌabo ꞌuꞌenoꞌeno ta esi ꞌulomataꞌiꞌita ꞌaiꞌaila.’ ");
INSERT INTO dob_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ꞌEnega ꞌilobwenemi be walomataꞌiꞌita be wayamwayamwagu, manuna toni anuwa ꞌina mai ꞌana tuta nigeya wamwalamwalatoni, nai ꞌasuinuwanuwaya, nai niuniuwanaya, nai tomwa uliulitaya, nai gonagonaya. ");
INSERT INTO dob_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ta geyaꞌabo yalatuma be ꞌenoꞌenoega yaloeloesalutuimi. ");
INSERT INTO dob_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“ꞌIgu emataluwa gete ꞌomi ꞌemiya be wate tomota maiboꞌadi ꞌediya ꞌaene wada lomataꞌiꞌita ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ataona Sagalina ꞌana ꞌebe nuwaꞌiꞌita ꞌida apwesa ꞌasiyata ꞌeluwa mulidiya. Sagali nina ꞌenaya pwalawa daisina, nigeya ꞌana ꞌebe gieseseyamo, siꞌaꞌani. Ta totaliyao sinabwadi be loina ꞌana toeꞌitao sinuwanuwa edaedadama mwaꞌadega Yesu sida kaboꞌese be ꞌaene sida giyai be sida loemwawasi, ");
INSERT INTO dob_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ta sigwae, “Geyaꞌabo sagali solanaya Yesu tagiyagiyai ꞌabona nai tomota sigamwasowaleda be silosaiya ꞌedaya.” ");
INSERT INTO dob_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tuta nina Yesu Betani ꞌena ꞌimiyami, ta ꞌiꞌeꞌai Saimoni ꞌina anuwaya, tauna lowa tolepelo ꞌebweu; ga waine ꞌebweu ma ina bunama ꞌiluguma; ta bunama nina ꞌana esana nadi, ꞌana maisa sinabwana, ta ꞌana botolo boboꞌana wawasae ꞌenaya ꞌisiwena. Ta waine botolo ꞌawana ꞌiꞌaulasena ga bunama nina Yesu debanaya ꞌisiwena. ");
INSERT INTO dob_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ta ꞌaina tomota siꞌitena ga waine silomugiyena, sigwae, “Toꞌase manuna bunama ꞌimudalina? ");
INSERT INTO dob_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ꞌIlobwenena be bunama nina ꞌigimwaneye be ꞌana maisa ꞌetoi analedi kina nadigega ꞌiꞌewa be ꞌieguyaiye togomabeso ꞌediya.” ꞌEnega waine nina siꞌena paꞌalina. ");
INSERT INTO dob_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ta Yesu ꞌieonedi, ꞌigwae, “Tuwa! Walosaꞌu! Geyaꞌabo waine wagie dededoni, manuna ꞌina lema gete ꞌeguya boboꞌana wawasae. ");
INSERT INTO dob_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Togomabeso nidi waoneonedi tuta maiboꞌana selabemiya simiyami, be ꞌabo to tuta nuwanuwami wada lemedi, ta ꞌaboꞌagu esi nigeya tuta dudulana maꞌemi tamiyami. ");
INSERT INTO dob_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ta waine gete toꞌase sinabwana nadigega ꞌenaya ꞌiguinuwena ꞌeguya, nate bwalagu ꞌigimi eoloina sabi gibubu ꞌagu saꞌuꞌaliꞌali manuna. ");
INSERT INTO dob_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ta onaꞌaiꞌaila, maꞌetamo teteligu ꞌana loguguya tomota sinoonoi baleꞌu maiboꞌana ꞌenaya, ta waine gete ꞌina guinuwa ꞌeguya tetelina sida emwasali wate.” ");
INSERT INTO dob_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ꞌEnega Yesu ꞌina tonono ꞌebweu site tuwelo ꞌediyega, tauna Yudasa Isikaliota, ꞌitauya totaliya sinabwadi ꞌediya ga nuwanuwana be Yesu ꞌediya ꞌida telesipupuye. ");
INSERT INTO dob_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ga Yudasa ꞌina ona sinonona ga sigwausowala ga ꞌena siona upaupa be ꞌaene ꞌana maisa siꞌebwaꞌe. ꞌEnega Yudasa tuta boboꞌana ꞌiyamwena be ꞌaene Yesu ꞌediya ꞌida telesipupuye be sigiyai. ");
INSERT INTO dob_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ataona Sagalina solanaya beledi daisina nigeya gieseseinamo sieꞌani ga sagali ꞌana ꞌasiyata nugana ꞌena lamiyao siunudi Ataona ꞌana ꞌebe nuwaꞌiꞌita manuna, ga ꞌasiyata nina ꞌena Yesu ꞌina tononoyao sieonena, sigwae, “ꞌInapwana, mane ꞌena nuwanuwayo be Ataona Sagalina manuyo ꞌagibubu?” ");
INSERT INTO dob_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ꞌEnega ꞌina tononoyao ꞌeluwa ꞌietunedi ta ꞌieonedi, “Watatauya Yelusalema, be ꞌabo tai ꞌebweuna ma ina ꞌebe gobwasi ꞌiꞌaalina waloba, tai nina wamuli ꞌoayabu ");
INSERT INTO dob_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","be maꞌemi walulugu anuwaya, be toni anuwa waeona, wagwae, ‘ꞌIma toeꞌita gete nadigega ꞌionaꞌesa, “To sena ꞌutagwale be ꞌena ma igu tononoyao Ataona masulina ꞌaꞌaꞌani?” ’ ");
INSERT INTO dob_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Be ꞌenega ꞌiabe sena sinabwana etanaya gibugibubuna ꞌieꞌitami, tauna ꞌena Ataona masulina wagibubu manuda.” ");
INSERT INTO dob_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ꞌEnega tonono nidi sitauya ga ꞌasa Yelusalema ꞌena silugu ga toꞌase nadigega Yesu ꞌisimanena ꞌediya yage nidi maiboꞌadi silobedi, ga anuwa nina ꞌena Ataona masulina sigibubuna manudi. ");
INSERT INTO dob_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ta ꞌasuinuwanuwaya Yesu ma ina tononoyao simai ");
INSERT INTO dob_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ga site tuwelo simiyatowa sabi ꞌeꞌai. Ta ꞌidi ꞌeꞌai solanaya Yesu ꞌieonedi, “Gosegwao yaona ꞌaiꞌaila ꞌaene ꞌebweuna tai gete tuga maꞌedai taꞌeꞌai, ta saꞌi ꞌiabe ꞌitelesipupuyegu.” ");
INSERT INTO dob_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ta Yesu ꞌina ona gete manuna sinuwa mwau, ga ꞌebweuna ꞌebweuna Yesu ꞌena ꞌienaida, ꞌigwae, “ꞌInapwana, yaita? Nai ꞌaboꞌagu?” ");
INSERT INTO dob_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ga Yesu ꞌigwae, “ꞌAgu tosipupu nina ꞌomi wate tuwelo ꞌemiyega, ta tauna maꞌiyagu gaeba ꞌebweuna ꞌenega ꞌaꞌeꞌai. ");
INSERT INTO dob_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ꞌAboꞌagu Tomota Natuna maꞌetamo yatatauya ꞌeda nina lowa Buki Tabu ꞌena ꞌigimisimanena, ta esi ꞌagu totelesipupu nina nuwaꞌoleꞌolena saꞌi; ta boboꞌana ꞌabo lowa sinana geyaꞌabo ꞌida enaenatune, manuna ꞌina tubuwa ꞌenega ꞌienuwaꞌoleꞌole ꞌina guinuwa toꞌumalina manuna.” ");
INSERT INTO dob_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ꞌEtamo siꞌeꞌai ta Yesu masula ꞌiꞌewena ga manuna ꞌiona oboboma ta ꞌigitomwena ga ꞌiꞌebwaꞌedi, ꞌigwae, “Gete waꞌewa oogu.” ");
INSERT INTO dob_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ta oine makeigana wate ꞌiꞌewena ga manuna ꞌilokagutoki Yaubada ꞌena ga ꞌiꞌebwaꞌedi, ga maiboꞌadi sinuma. ");
INSERT INTO dob_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ta wate ꞌieonedi, ꞌigwae, “Gete lalagu ꞌidaudau tomota yaumi manumi, nate loina auwauna. ");
INSERT INTO dob_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ta yaeonemi tuta gete be mulinaya oine gete geyaꞌabo ꞌenega yanumanuma limana ga ꞌana laba oine auwauna yanunuma Yaubada ꞌina senaya.” ");
INSERT INTO dob_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ꞌEnega wali ꞌebweuna siwaliyena ta siapwesa ga situꞌe ꞌOya Olibe ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ta Yesu ꞌieonedi, “ꞌIabe maiboꞌami wada denasinegu, nadigega Buki Tabu ꞌina simana, ꞌigwae, ‘Toꞌitaꞌiꞌita sipi yaloemwawasi be sipi nidi sida ꞌelelewana.’ ");
INSERT INTO dob_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ta ꞌigu toololimana mulinaya Galili ꞌena yatatauya be ꞌomi muliguyega wawawai.” ");
INSERT INTO dob_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ꞌEnega Pita ꞌilolagata ga ꞌigwae, “ꞌIabe maiboꞌadi sidena sineyo ta tebweugu maꞌiyayo.” ");
INSERT INTO dob_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ta Yesu Pita ꞌieonena, “Yaona ꞌaiꞌaila, boiboi batuwa muliyega be kakaleko ꞌigwagwane maluwa, ta ꞌoyo ꞌuda gimi eyaseyaseyegu matoi.” ");
INSERT INTO dob_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ta ꞌenega Pita ma ina ꞌawapaꞌala ꞌigwae, “ꞌInapwana, geyaꞌabo saꞌi yaeyaseyaseyeyo. ꞌEguma siloemwawasiyo ꞌaboꞌagu wate maꞌiyayo siloemwawasida.” Tononoyao maiboꞌadi wate nadigega sionaꞌesa. ");
INSERT INTO dob_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ga sitauya ꞌebweu sena ꞌana esana Gedesemane ꞌena, ga ꞌina tononoyao ꞌediya ꞌigwae, “Gete ꞌena wamiyami, ta ꞌaboꞌagu yasisida Yaubada ꞌena.” ");
INSERT INTO dob_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ta site toi maꞌenao ꞌiꞌauꞌewedi, taudi Pita be Yemesa be Yoni, ꞌenega Yesu ma ina ꞌateuyauya ta ma ina nuwamwau, ");
INSERT INTO dob_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ꞌieonedi, ꞌigwae, “ꞌAtegu ꞌiuyauya sinabwana nai ꞌiabe yamwamwawasa, ꞌenega bada wamiyami ta walomataꞌiꞌita.” ");
INSERT INTO dob_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ta Yesu ꞌialaga tupwana ga ꞌibeꞌu sanamwaꞌuta ga ꞌisidasida ꞌaene ꞌabo kapekapeyana ꞌelouya gete Yaubada ꞌida ꞌewayaule, ");
INSERT INTO dob_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ꞌigwaegwae, “Tamagu ye, guinuwa yauna sawesawemuya, ꞌenega nuwanuwagu be ꞌelouya keigana gete ꞌeguyega ꞌuꞌewayaule, ta geyaꞌabo ꞌaboꞌagu ꞌigu nuwena ꞌenega ta ꞌoyo esi ꞌimu nuwena ꞌenega ꞌuda guinuwa.” ");
INSERT INTO dob_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ꞌEnega ꞌiila ga site toi nidi ꞌilobedi niꞌatu siꞌeno mwataya, ga Pita ꞌiloanoanona, ꞌigwae, “Saimoni, mwaꞌadega ꞌuꞌenoꞌeno. Nigeya sawesawemuya be tuta gidalina namo manuna ꞌumata paꞌala, aga?” ");
INSERT INTO dob_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ga wate ꞌieonedi maiboꞌadi, ꞌigwae, “ꞌIlobwenemi be wamata paꞌala be wasidasida be ꞌenega geyaꞌabo Seitani ꞌitootoomi. Onaꞌaiꞌaila, yaluyaluwami nuwanuwana ta tuga manuna oomi sitaba.” ");
INSERT INTO dob_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ꞌEnega Yesu ꞌilaga limana ta ꞌina sidasida niꞌa ꞌilolimena. ");
INSERT INTO dob_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ta Yesu wate ꞌiila ꞌina tononoyao ꞌediya ga ꞌilobedi wate siꞌeno mwataya, manuna matadi niꞌatu siꞌenoꞌeno. Ta ꞌiloanoanodi ga sitoolo ma idi omayamaya, ga nigeya ꞌidi ꞌebe onamo. ");
INSERT INTO dob_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ga Yesu wate ꞌilaga ga ꞌisidasida, ta ꞌina ilama ꞌetonina ꞌenaya ꞌilobedi siꞌeno mwataya, ga ꞌieonedi, “Mwaꞌadega, maꞌetamo tuga waꞌenoꞌeno ta waeyawaiꞌata, aga? Ta waꞌita, ꞌaboꞌagu Tomota Natuna ꞌigu tuta niꞌatu ꞌiapwesa be sida sipupuyegu totoꞌumalidi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Watoolo be tatatauya, manuna ꞌagu totelesipupu nina niꞌatu gete ꞌimeema.” ");
INSERT INTO dob_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ꞌetamo ꞌionaona ga Yudasa ꞌiapwesama, tauna Yesu ꞌina tononoyao site tuwelo ꞌebweuna ꞌediyega. Ta wate totaliya sinabwadi be loina ꞌana toeꞌitao be ꞌinapwanao tolosaiyao Yudasa maꞌedi sietunedi be ꞌaene Yesu sida giyai, ta boda nidi ma idi sisisaiyao be wepasiyao wate simeꞌedi. ");
INSERT INTO dob_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ta Yudasa weꞌiweꞌiyaya niꞌatu ꞌediya ꞌisimanena, ꞌigwae, “ꞌAbo yaita yaꞌatubwaili, nate tauna Yesu, be wagiyai ta walomataꞌiꞌisi be watauye.” ");
INSERT INTO dob_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ꞌEnega ꞌitauya palupaluna Yesu ꞌena ga ꞌilokagutokiyena ta ꞌiꞌatubwailina. ");
INSERT INTO dob_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ꞌEnega boda nidi siapwesama ga Yesu sigiyaina. ");
INSERT INTO dob_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ta Yesu ꞌina bodao ꞌebweuna ꞌediyega ꞌitootoolo selabenaya ga ꞌina sisisaiya ꞌilisilolona ga totaliya sinabwana ꞌina toguinuwa tenana ꞌiꞌupwa yaulena. ");
INSERT INTO dob_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ta Yesu boda ꞌieonedi, ꞌigwae, “Sana ꞌaboꞌagu toꞌipwala ga ꞌenega ma imi sisisaiya be ma imi wepasi wamai sabi giyaigu. ");
INSERT INTO dob_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ta toꞌase ꞌalena ga ꞌenega nigeya wagiyagiyaigu ꞌasiyata nidi yaudi gamwagamwanimiya yamiyami Anuwa Tabu ꞌena ta yaeꞌieꞌita tomota ꞌediya? Ta tuwa tuga yage getedi siapwesama be ꞌaene palopitao ꞌidi gimisimana Buki Tabu solanaya sida apwesa.” ");
INSERT INTO dob_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ꞌEnega Yesu ꞌina tononoyao maiboꞌadi sidena sinena. ");
INSERT INTO dob_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ta ꞌebweu tubuwau ma ꞌana ꞌoama ꞌebweuna namo Yesu ꞌiꞌoayabuna, ta tolosaiyao nuwanuwadi sigiyai, ");
INSERT INTO dob_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ta sigisaꞌilina ga ꞌana ꞌoamamo siꞌewena, ta mabubugewana ꞌidena. ");
INSERT INTO dob_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ta Yesu siꞌauꞌewena ga siluguyena totaliyao ꞌidi ꞌinapwana ꞌina anuwaya, manuna anuwa nina ꞌena totaliya sinabwadi be ꞌinapwanao be loina ꞌana toeꞌitao niꞌatu siegogonama ga simiyami. ");
INSERT INTO dob_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ta Pita ꞌedasolega Yesu ꞌimuliyena ga ꞌimai totaliya sinabwana nina ꞌina ꞌasaya, ga Pita nina toꞌitaꞌiꞌitao maꞌediya simiyatowa, ta kaiwe ꞌena sisiyasiyata. ");
INSERT INTO dob_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ꞌEnega totaliya sinabwadi be ꞌinapwanao nidi nuwanuwadi Yesu ꞌana toeꞌewao sida lobadi be ꞌidi eꞌewa ꞌenega Yesu sida loemwawasi, ta nigeya ꞌebweu wate silobaloba. ");
INSERT INTO dob_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Manuna toeꞌewa yaudi sisimasimana, ta esi ꞌidi simana nigeya leleleya. Taudi maiboꞌadi tokabo tuga. ");
INSERT INTO dob_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ta ꞌaidi ꞌediyega sitoolo ga Yesu sieꞌewa kabokaboena, sigwae, ");
INSERT INTO dob_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yesu ꞌina ona ꞌebweu ꞌanononaya, ꞌigwae, ‘Anuwa Tabu gete tomota siꞌabinaya maꞌetamo yalige yaulei be ꞌasiyata ꞌetoi ꞌediya yada ꞌabilima, ta nigeya tomota nimadiyega.’ ” ");
INSERT INTO dob_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ta saꞌi ꞌidi simanao yage gete manuna nigeya sieleleleya. ");
INSERT INTO dob_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ꞌEnega totaliya sinabwana nina matadiya ꞌitoolo ga Yesu ꞌienaidena, ꞌigwae, “Nigeya ꞌimu eꞌisamo, aga? Tomota gotedi ꞌidi eꞌewa ꞌemuya niꞌatu ꞌunononaya?” ");
INSERT INTO dob_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ta Yesu tuga ꞌiꞌalaenono, ga nigeya ꞌionaona. Ta ꞌenega totaliya sinabwana Yesu ꞌena ꞌienaida limana, ꞌigwae, “Mwaꞌadega ꞌoyo Yaubada natuna Toꞌetoseyana niyo, nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ga Yesu ꞌigwae, “ꞌAboꞌagu tauna, Tomota Natuna nigu, be maꞌetamo waꞌitagu Toewaiwai sana ꞌatainaya yamiyami be wate galewa pwananao debadiyega yamama.” ");
INSERT INTO dob_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","ꞌEnega totaliya sinabwana nina ꞌigamwasowala ꞌaiꞌaila, ꞌenega taunamo ꞌana ꞌoama ꞌisabuna ta ꞌigwae, “ꞌIna ona toꞌumalina wanononaya? Onaꞌaiꞌaila tai gete Yaubada ꞌisinalina. Tuwa! Geyaꞌabo wate ꞌana toeꞌewao sionaona ꞌina loegesiyao manudi. Mwaꞌadega ꞌimi nuwanuwa Yesu manuna?” Ta ꞌenega maiboꞌadi silolagata ga sigwae, “ꞌIlobwenena be ꞌimwamwawasa!” ");
INSERT INTO dob_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Gote ꞌena ꞌaina tomota Yesu sigiwalina, ga matana ꞌoamega siwaduna ta siunu dadanena ma idi ꞌeetete, sigwae, “ꞌUeonama yaita ꞌisapimu.” Ta toꞌitaꞌiꞌitao nidi Yesu sigiyaina ga sisapisapi ta sitautauye. ");
INSERT INTO dob_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ta Pita maꞌetamo ꞌetauluya ꞌimiyami, ga totaliya sinabwana ꞌina toguinuwa gomagweine ꞌebweuna ꞌiapwesama, ");
INSERT INTO dob_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ga Pita ꞌiꞌitena ꞌisiyasiyata. ꞌEnega waine nina Pita ꞌiduneduneye ga ꞌigwae, “ꞌOyo goma Nasaleta Yesu nina lowa maꞌiyayo wamiyami, aga?” ");
INSERT INTO dob_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ta Pita ꞌieyaseyase, ꞌigwae, “Yage nina ꞌuonaonae nigeya yamwalamwalatoni.” ꞌEnega Pita ꞌidena ga tupwana ꞌiaapwesa. ");
INSERT INTO dob_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ta gomagweine nina Pita ꞌienima susuyena tomiya nidi ꞌediya, ꞌigwae, “Tai gote Yesu ꞌina boda ꞌebweu.” ");
INSERT INTO dob_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ga Pita ꞌinonona ga ꞌieyaseyase limana, ꞌigwae, “ꞌAboꞌagu nigeya.” Tuta kukupana namo mulinaya toyoꞌo nidi Pita sieonena, sigwae, “Onaꞌaiꞌaila ꞌukabo. ꞌOyo Yesu ꞌina boda ꞌebweu, manuna ꞌoyo goma Galili.” ");
INSERT INTO dob_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ꞌEnega Pita ꞌisawatamatamana ta ona toꞌumalina ꞌenega ꞌibwautuꞌe, ꞌigwae, “Yesu tauna manuna waonaona, ꞌaboꞌagu nigeya wate yamwalamwalatoni. Tamada!” ");
INSERT INTO dob_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ta tuta gote ꞌena kakaleko ꞌigwane ꞌeluwena, ga Pita ꞌinuwaꞌiꞌisina Yesu ꞌina ona ꞌaene “Muliyega be kakaleko ꞌigwagwane maluwa, ta ꞌoyo ꞌuda gimi eyaseyaseyegu matoi.” Ta ꞌenega Pita ꞌina kabo toꞌumalina ꞌinuwaꞌiꞌisina ga ꞌidedoi. ");
INSERT INTO dob_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ꞌEnega tomwa ꞌiulisina ga totaliyao sinabwadi be ꞌinapwanao be loina ꞌadi toeꞌitao be toloinao maiboꞌadi sideli egogonama ga siloiloina Yesu manuna, ꞌenega nimana siyonidi ga sitauyena Pailato ꞌena be ꞌaene Pailato nina ꞌida loine. ");
INSERT INTO dob_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ꞌEnega Pailato Yesu ꞌienaidena, ꞌigwae, “ꞌUda simana, ꞌoyo me Yudia ꞌidi kini, aga?” Ta Yesu ꞌigwae, “Niꞌatu nate ꞌuona saba.” ");
INSERT INTO dob_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ta ꞌenega totaliyao sinabwadi yage yaudi manudi Yesu sieꞌewena. ");
INSERT INTO dob_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ꞌEnega Pailato Yesu ꞌienaida limena, ꞌigwae, “Mwaꞌadega nigeya ꞌimu eꞌisamo? Simana getedi ꞌamu eꞌewa manuna ꞌunononaya?” ");
INSERT INTO dob_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ta Yesu nigeya ꞌebweu wate ꞌieꞌieꞌisa, ꞌenega Pailato nuwana ꞌiowana sinabwana. ");
INSERT INTO dob_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Yakwala ꞌebweuna ꞌebweuna Ataona Sagalina ꞌana tuta ꞌenaya toloina nina ꞌina bubuna nate deliyega ꞌebweu tai ꞌiliꞌami be ꞌiapwesa, ꞌeguma yaita pwalu siesinuwe. ");
INSERT INTO dob_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tuta gote ꞌena ꞌaina me Loma ꞌadi talauwalao deliya simiyami, manuna geya nuwadi me Loma ꞌidi loina ga silosaiyedi, ga ꞌebweuna ꞌediyega ꞌana esana Balaba, losaiya nina solanaya tomota ꞌiloemwawasidi. ꞌEnega me Loma Balaba magosenao sigiyaidi ga deliya sisaꞌudi. ");
INSERT INTO dob_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ꞌEnega boda siegogonama ga siꞌawanoi Pailato ꞌenaya, sigwae, “Sawesawenaya be ꞌebweu tai ꞌuda liꞌami manuma, nadigega ꞌima sidasida ꞌemuya ꞌuguiguinuwe yakwala ꞌebweuna ꞌebweuna ꞌenaya?” ");
INSERT INTO dob_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ꞌEnega Pailato ꞌieonedi, “Nuwanuwami ꞌaene me Yudia ꞌimi kini yada ꞌetoliꞌami manumi, aga?” ");
INSERT INTO dob_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Manuna Pailato ꞌimwalatonina ꞌaene totaliya sinabwadi ꞌidi eꞌipiꞌipiyega Yesu siwasegigiyena sabi loemwawasina. ");
INSERT INTO dob_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ta saꞌi totaliya sinabwadi niꞌatu tomota nuwanuwa toꞌumalina sienuwa saꞌuyena ꞌediya, ꞌenega Yesu siguitoyasena ta Balaba esiya ꞌana esana siꞌinanena be ꞌida liꞌami manudi. ");
INSERT INTO dob_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ta Pailato ꞌieonedi wate ꞌigwae, “Ta mwaꞌadega yada loinaꞌesa tauna waeesena ꞌimi kini?” ");
INSERT INTO dob_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ga wate sibwau, sigwae, “Kelose ꞌena tada tutuepaꞌiye!” ");
INSERT INTO dob_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ta Pailato ꞌigwae, “Toꞌase sana ꞌina loegesi ga ꞌenega ꞌaene mwawasa ꞌiloba?” Ta sibwau toitoila, sigwae, “Kelose ꞌena tada tutuepaꞌiye.” ");
INSERT INTO dob_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ꞌEnega Pailato nuwanuwana be pwalu ꞌida giegwausowalidi ga Balaba ꞌiliꞌamina, ta wate ꞌina tolosaiyao ꞌiloinedi be Yesu balaeyega sida sapi be muliyega sida tutuepaꞌiye kelose ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ꞌEnega Pailato ꞌina tolosaiyao Yesu sisapina ta siꞌauꞌewena ga ꞌina anuwaya siluguyena, nate tolosaiyao ꞌidi sena sinabwana anuwa solanaya, ga tolosaiyao ꞌidi bodao maiboꞌadi sibwau egogonedima. ");
INSERT INTO dob_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ꞌEnega toesaesao ꞌadi ꞌoama bweyabweyalina ꞌenega Yesu sieꞌoamena ga ꞌana peyaula kwakwakwala ꞌediyega siguinuwena ga debanaya sisaꞌuna. ");
INSERT INTO dob_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ga silolagata be tuyeya ꞌenega silokagutokiye, sigwaegwae, “Kamatoki ꞌoyo me Yudia ꞌidi kini ye!” ");
INSERT INTO dob_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ta wate ꞌetoguna ꞌenega Yesu debana sisapina, ta sigiwalina, ga tuyeyega matanaya siꞌaetulasa. ");
INSERT INTO dob_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ꞌEnega ꞌidi tuyeya ꞌigumwala, ga ꞌoama esaesa ꞌenega sialolona, ta tauna ꞌana ꞌoamega sieꞌote limena, ga siꞌauꞌewena sabi giekelosena. ");
INSERT INTO dob_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ga ꞌasa sinabwana ꞌenega siapwesa, ga goma Sailini mitawega ꞌimeemai silobena, ga sididigena be Yesu ꞌana kelose ꞌida ꞌaali. Tai nina ꞌana esana Saimoni, ta Alekisana be Lupuso tamadiya. ");
INSERT INTO dob_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ꞌEnega siꞌauꞌewena sena Goligota ꞌenaya (Goligota ꞌana mwalatoi nate ‘Bulubulu ꞌasana’), ");
INSERT INTO dob_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ga oine be mulo siꞌeinisena ga siꞌebwaꞌena be ꞌaene geyaꞌabo uya ꞌilotolotoo sinabwana, ta Yesu ꞌiguitoyasena. ");
INSERT INTO dob_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ꞌEnega kelose baleꞌuya sisaꞌunaya ta Yesu ꞌenaya situtu epaꞌiyena ga sietoolona. Ga muliyega toguinuwa nidi Yesu ꞌana ꞌoamao siꞌewedi ga sieguyaiyedi taudimo ꞌediya, ta ꞌidi eguyai esasala ulaesinuwa ꞌenega, be ꞌeguma yaita ꞌinugana ꞌana ꞌoama ꞌebweu ꞌiꞌewa. ");
INSERT INTO dob_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tuta nina Yesu sigie kelosena nate gonagona ꞌana gamwagamwana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ta ꞌana kelose ꞌenaya siꞌetoladina “Me Yudia ꞌadi toloina.” Nate ꞌina mwawasa ꞌalena. ");
INSERT INTO dob_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ta wate toꞌipwala ꞌeluwa sigie kelosedi, ꞌebweu Yesu ꞌatainaya ta ꞌebweu gegeuminaya. ");
INSERT INTO dob_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO dob_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ta tomota ꞌaina ꞌedega Yesu kelose ꞌena situyeyena ta siedagiyena, sigwae, “Nuwaꞌoleꞌoleyo! ꞌUona ꞌaene sawesawemuya Anuwa Tabu ꞌuligei be ꞌasiyata ꞌetoi soladiya ꞌuꞌabilima. ");
INSERT INTO dob_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Baga ꞌuda ꞌetoseyeyo tauyo be keloseyega ꞌuebusima.” ");
INSERT INTO dob_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ta wate totaliyao sinabwadi be loina ꞌana toeꞌitao taudimo ꞌediya sionaona gagasa, ga Yesu siꞌeetetena, sigwaegwae, “Mali tomota ꞌiꞌetoseyedi ta tauna ꞌida ꞌetoseye! ");
INSERT INTO dob_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tauna ꞌaene Toꞌetoseyana nina ta sena Isileli ꞌana toloina, abaga keloseyega ꞌida ebusima be taꞌita, be ꞌenega taemise.” Ta toꞌipwala nidi Yesu maꞌenao sigie kelosediya taudi ꞌadi keloseyega sibwaꞌonao ga Yesu sibaꞌena. ");
INSERT INTO dob_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ta niꞌatu ꞌasuoleole sena maiboꞌana ꞌiguguyoi ga ꞌana laba ꞌasuinuwanuwaya, ");
INSERT INTO dob_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ga ꞌasuinuwanuwaya Yesu ꞌenana sinabwanega ꞌibwau, ga ꞌigwae, “Eloi, eloi, lama sabakitani,” ta ꞌana gibui ꞌaene “ꞌIgu Yaubada, ꞌigu Yaubada, toꞌase manuna ꞌupilisinegu?” ");
INSERT INTO dob_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ta ꞌaina tomota selabenaya sitootoolo ꞌina bwau sinonona ta sigwae, “Wanono, Ilaitiya ꞌibwaubwauye.” ");
INSERT INTO dob_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ꞌEnega ꞌebweuna ꞌediyega ꞌipili ga balou ꞌiꞌewena, ga oine dalelena ꞌena ꞌietupaꞌutuina, ꞌenega ꞌebweu kaiwe ꞌena matana ꞌibadiyena ga ꞌieꞌetotuꞌeyena Yesu ꞌawanaya be ꞌisokuku, ta tai nina ꞌigwae, “Tuga tayamwayamwa, nai ꞌiabe Ilaitiya ꞌimama be keloseyega ꞌiꞌetoseye.” ");
INSERT INTO dob_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ta Yesu ꞌibwau toitoila ga yawasina ꞌigumwala. ");
INSERT INTO dob_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ta kaleko nina Anuwa Tabu ꞌana pitaupa ꞌiesabu luwena etanega ga ꞌimwaꞌuta ꞌubunaya. ");
INSERT INTO dob_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ta tolosaiyao ꞌadi toanugana Yesu ꞌana kelose matanaya ꞌitootoolo Yesu ꞌina mwawasa ꞌana ꞌita gete nadigega ꞌiꞌitena, ꞌenega ꞌigwae, “Onaꞌaiꞌaila tai gote Yaubada natuna.” ");
INSERT INTO dob_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ꞌAina iine wate ꞌedasolega sidunedune, nate Meli Magidala be ꞌina waliyesa, tauna Yosese be tasina megwamana Yemesa sinadiya, be Salome wate, ");
INSERT INTO dob_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","taudi lowa Yesu simuliyena ta ꞌana masula siguinuwenaya ꞌina sakowasi Galili solanaya manuna, ta ꞌaina iine wate Galiliyega Yesu maꞌenao silagama Yelusalema ꞌenaya, maiboꞌadi siduneduneye. ");
INSERT INTO dob_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ta niꞌatu ꞌasuinuwa ga gibubuna mali ꞌasiyata manuna, nate me Yudia ꞌidi Sabate. ");
INSERT INTO dob_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ꞌEnega goma Alimatia ꞌana esana Yosepa ꞌimai, tauna ꞌebweu me Yudia ꞌidi toanugana ma ꞌana emisa, ta ꞌiyamwayamwa be to tuta Yaubada baleꞌuya ꞌida etoloina. Tauna Yosepa nina ꞌimai ga ma ina ꞌatepatu ꞌilugu Pailato matanaya ga Yesu kokowana ꞌisidena be ꞌaene ꞌida saꞌuꞌaliꞌaliye. ");
INSERT INTO dob_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ta ꞌenega Pailato ꞌilosuyaena, ꞌigwae, “Iyae! Yesu niꞌatu ꞌimwawasaya?” ꞌEnega tolosaiyao ꞌadi toanugana ꞌibwauyenama, ga ꞌimai, ga Pailato ꞌienaida, ꞌigwae, “Mwaꞌadega, Yesu niꞌatu ꞌimwawasa?” ");
INSERT INTO dob_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ga tai nina ꞌigwae, “O, niꞌatu ꞌimwawasa.” ꞌEnega Pailato ꞌitagwala be Yosepa Yesu kokowana ꞌida ꞌewa. ");
INSERT INTO dob_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ga Yosepa kaleko wakewakekena ꞌigimwanena ga ꞌiꞌewenama, ga ma ina toguinuwao Yesu kokowana kelose ꞌenega siꞌewa mwaꞌutenama, ga kaleko nina ꞌenega siwaduna, ga muliyega sisaꞌu ꞌaliꞌaliyena. Ta ꞌaliꞌali nina sitainaya ꞌatuwa duluwa gulewa solanaya, ta gulewa sinabwana ta pulipulina ꞌenega ꞌaliꞌali ꞌawana sisaꞌu bodena. ");
INSERT INTO dob_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ta Meli Magidala be ꞌina waliyesa, tauna Yosese sinana, maꞌiyana sieꞌasiyedi ga ꞌaliꞌali nina ꞌena kokowana sisaꞌuna siꞌitena. ");
INSERT INTO dob_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ꞌEnega Sabate nina ꞌigumwala ga Meli Magidala ma ina waliyesa, tauna Yemesa sinana, be Salome wate maꞌediya bunama boboꞌana sigimwanena be ꞌaene Yesu bwalana sida eoloi. ");
INSERT INTO dob_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ga tomwa ꞌiulisina, nate wiki ꞌana ꞌasiyata nugana ꞌenaya, ga sinala ꞌina saeꞌunu ꞌenaya iine nidi ma idi bunama simai Yesu ꞌana ꞌaliꞌali ꞌena. ");
INSERT INTO dob_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ga taudimo ꞌediya sionaona sigwae, “Yaita gulewa nina ꞌaliꞌali ꞌawanega ꞌida puliile manuda?” Manuna gulewa nina sinabwa wawasae. ");
INSERT INTO dob_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ta ꞌenega siꞌitanao ga ꞌaliꞌali ꞌana ꞌauboda gulewa niꞌatu ꞌawanega sipuli ilena siꞌitena. ");
INSERT INTO dob_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ꞌEnega iine nidi ꞌaliꞌali solanaya silugu ga ꞌataidiyega tubuwau ma ꞌana ꞌoama wakewakekena ꞌimiyami siꞌitena, ꞌenega siꞌatesaꞌala. ");
INSERT INTO dob_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ta tubuwau nina ꞌieonedi, ꞌigwae, “Geyaꞌabo waꞌateꞌate saꞌala. Yesu goma Nasaleta tauna sigiekelosena waꞌebeꞌebese. Tauna nigeya bada, manuna niꞌatu mwawasega ꞌitoolo limana. ꞌIna ꞌebeꞌeno gete waꞌitena tuga kakaena. ");
INSERT INTO dob_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ta ꞌomi waila be Yesu ꞌina tononoyao ꞌediya wasisimana, ta wate Pita ꞌena wasisimana, wagwae, ‘Yesu ꞌitatauya nugana Galili ꞌena, ta ꞌomi wamuliye be gote ꞌena waꞌita, nadigega lowa ꞌina simana ꞌemiya.’ ” ");
INSERT INTO dob_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ꞌEnega iine nidi ꞌaliꞌaliyega siapwesa manini ga sidena, manuna nuwadi ꞌiowana, ta wate sidededela, ta ꞌidi matauta nigeya yaita ꞌena sisimasimane. ");
INSERT INTO dob_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wiki ꞌana ꞌasiyata nugana gonagonaya, Yesu ꞌina toololimana ꞌenaya ꞌigimi apwesa Meli Magidala ꞌenaya, tauna solanega lowa yaluyaluwa biꞌi site sebeni Yesu ꞌiula apwesedi. ");
INSERT INTO dob_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ꞌEnega Meli nina ꞌitauya ga Yesu ꞌina tomotaiyao ꞌiemataluwedi, ta taudi tuga ꞌetamo ma idi nuwamwau sidedoi Yesu manuna. ");
INSERT INTO dob_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ta Meli emataluwa ꞌiꞌebwaꞌedi ꞌigwae, “Yesu mayawasina ꞌimiyami. Niꞌatu yaꞌitena.” Ta taudi saꞌi siꞌawa kabokaboena. ");
INSERT INTO dob_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ta muliyega Yesu ꞌana tomuliyao ꞌeluwa Yelusalemega siapwesa ga mali ꞌasa manuna sitautauya, ga Yesu ꞌigie apwesena tauna mali ꞌita ꞌenega. ");
INSERT INTO dob_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ꞌEnega site luwa nidi Yelusalema ꞌena siila ga gosediyao siemataluwedi, ta saꞌi nigeya siemiemisedi. ");
INSERT INTO dob_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Muliyega Yesu ꞌina tononoyao site elebeni siꞌeꞌai ga Yesu matadiya ꞌiapwesa, ga ꞌiꞌenapaꞌalidi ꞌidi debapaꞌala manuna, ꞌigwae, “Gosegwao taudi ꞌigu toololimana mulinaya siꞌitegu ga ꞌemiya sisimanaya, ta mwaꞌadega ga nigeya waeemisedi?” ");
INSERT INTO dob_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ta emataluwa ꞌiꞌebwaꞌedi, ꞌigwae, “Watatauya sena maiboꞌana ꞌediya be teteligu tomota maiboꞌadi ꞌediya waguguyae. ");
INSERT INTO dob_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ꞌEnega yaisigedi siemisegu wada giebapitaiseodi, be ꞌetoseyana sida loba, ta ꞌabo yaisigedi nigeya siemiemisa maꞌetamo loina toꞌumalina siloba. ");
INSERT INTO dob_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Ta ꞌagu toemisao nidi weꞌiweꞌiyaya waiwaidi sida guinuwedi, nate ꞌagu esanega yaluyaluwa biꞌi tomota ꞌediyega sida ula apwesedi, be ꞌenana dumadumadi be dumadumadi ꞌediyega sida onaona, ");
INSERT INTO dob_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","be ꞌabo mwata bolabolausidi sigilagasidi geyaꞌabo ꞌidi goꞌi ꞌenega siesiesilae, be ꞌabo bwasi bolausa sinunuma geyaꞌabo simwawamwawasa, be wate ꞌabo toleꞌoasao sigitoodi sida boboꞌana tuga.” ");
INSERT INTO dob_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ꞌIda ꞌInapwana Yesu ꞌina emataluwa ꞌediya niꞌatu ꞌilosalonina ga ꞌituꞌe galewaya, ga Yaubada ꞌatainaya ꞌimiyatowa. ");
INSERT INTO dob_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ta ꞌenega sitauya sena yauyaudi ꞌediya ga Yesu tetelina siloguguyaena, ta saꞌi ꞌInapwana maꞌedi siguiguinuwa ga ꞌina waiwaiyega guinuwa ꞌebe nuwaowanao siguinuwedi, ga ꞌenega tomota tetela nina siemisena. ");
INSERT INTO dob_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ye ꞌinapwana Tiopilo. Niꞌatu tomota yaudi Yesu tetelina siꞌetoladina toꞌase nadigega ꞌina guinuwa ꞌedaya manuna. ");
INSERT INTO dob_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tetela nidi siꞌetoladidi toꞌase nadigega taudi toꞌawaꞌaiꞌailao sigimiꞌitena, ꞌenega siloguguya ga siemwasala ꞌemaya, ");
INSERT INTO dob_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ta esi yage nidi maiboꞌadi gimitutega ga batuwa yamwalatoi ꞌaiꞌailidi, ꞌenega nuwanuwagu be ꞌaene yage nidi maiboꞌadi yada emwasala ꞌaiꞌailidi ꞌemuya, ");
INSERT INTO dob_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","be ꞌenega yage nidi niꞌatu ꞌunonodi ꞌaledi ꞌuda mwalatonidi be wate ꞌuda ꞌawa ꞌaiꞌailedi. ");
INSERT INTO dob_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ꞌIgu emwasala ꞌana ꞌebe eꞌale gete nadigega: Tuta nina Yudia ꞌena Elodi ꞌietoloina, totaliya ꞌebweu ꞌana esana Sakalaya ꞌimiyami. Tauna totaliya nina Ebaya ꞌina boda ꞌediyega. Ta mwanena ꞌana esana Ilisabeti, tauna wate totaliyao ꞌidi boda ꞌebweu. ");
INSERT INTO dob_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ta siteluwa nidi Yaubada matanaya sibubuna palupaluna, manuna Yaubada ꞌina loina maiboꞌana siematamatana ꞌaiꞌailena. ");
INSERT INTO dob_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ta nigeya natudimo, manuna Ilisabeti megamegagalina ga wate niꞌatu ꞌikaiyale, ta wate mwanena niꞌatu ꞌieꞌinapwana. ");
INSERT INTO dob_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ꞌEnega ꞌebweu tuta ꞌenaya Sakalaya ma ina bodao taliya siguiguinuwa, ta ꞌasiyata nina ꞌena Sakalaya nina ꞌina tuta be taliya ꞌida guinuwe Yaubada matanaya. ");
INSERT INTO dob_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Manuna nadigega ꞌidi bubuna, ga gosenao ꞌediyega esinuwa ꞌilobena, ꞌenega ꞌInapwana ꞌina Anuwa Tabu ꞌena ꞌilugu be ꞌaene galaꞌu ꞌida gabu ꞌebe taliya ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tuta nina galaꞌu ꞌana gabu ꞌana tuta ta boda sinabwana anuwa ꞌatamaninaya Yaubada ꞌena sisidasida. ");
INSERT INTO dob_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ꞌEnega Yaubada ꞌina anilose ꞌiapwesa Sakalaya matanaya, ga galaꞌu ꞌana ꞌebe gabu ꞌatainega ꞌitoolo. ");
INSERT INTO dob_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Gote ꞌena Sakalaya ꞌiꞌitena ga nuwana ꞌiowana, ta wate ma ina matauta. ");
INSERT INTO dob_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ta anilose ꞌigwae, “Sakalaya, geyaꞌabo ꞌumatamatauta. Yaubada ꞌimu sida niꞌatu ꞌinonona, ꞌenega mwaneyo Ilisabeti natuyo meꞌolotona ꞌienatunei be ꞌueese Yoni. ");
INSERT INTO dob_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ꞌEnega ꞌuda gwausowala ta wate tomota maiboꞌadi sida gwausowala gwama nina ꞌina tubuwa manuna. ");
INSERT INTO dob_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Manuna natumuna ꞌiabe ꞌana esana sinabwana Yaubada matanaya, ta geyaꞌabo oine nai bwasi waiwaidi ꞌinumanumadi, ta ꞌiabe ꞌina tubuwaꞌunu ꞌenega ꞌida maa Yaluyaluwa Tabunega. ");
INSERT INTO dob_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Be ꞌenega tauna me Isileli yaudi ꞌida ꞌauꞌewa limedima ꞌidi ꞌInapwana Yaubada ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ta tauna ꞌiabe ma ina waiwai ta ma ina ꞌatepatu, be Yaubada manuna ꞌida etosimana, ta ꞌina waiwai nadigega lowa palopita Ilaitiya ꞌina waiwai. Be ꞌenega guguya ꞌenega tama ꞌida giesana iledi be natudiyao sida nuwaꞌiꞌisi limedi. Be wate taudi toleꞌoa loina ꞌida giesana iledima ꞌeda palupaluna ꞌenaya, be ꞌenega ꞌInapwana ꞌina tomotaiyao ꞌida gibubudi ꞌina mai manuna.” ");
INSERT INTO dob_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ga Sakalaya anilose nina ꞌieonena, ꞌigwae, “Ona gete ꞌana nono ꞌeguya kwanikwanina, manuna ꞌaboꞌagu niꞌatu yaetai sinabwa, ta mwanegu wate ꞌikaiyale.” ");
INSERT INTO dob_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ta anilose nina ꞌigwae, “ꞌAboꞌagu Gebeliela, ta tuta yauna Yaubada matanaya yatootoolo, ta gete tuga Tauna ꞌietuneguma be ale gete boboꞌana yasimane ꞌemuya. ");
INSERT INTO dob_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ta ꞌoyo esi ꞌigu ale nina ꞌemuya nigeya ꞌuemiemise, ꞌenega ꞌiabe meyayo ꞌimwamwau be nigeya kapekapeyana ꞌuoona be ꞌana laba ꞌigu ale nina ꞌana mwalatoi ꞌaiꞌaila ꞌiapwesa be ꞌenega ona ꞌuꞌinana lima.” ");
INSERT INTO dob_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ta tomota maiboꞌadi ꞌetamo tuga ꞌatamanaya siyamwayamwa, ta sinuwanuwa toꞌase ꞌalena Sakalaya ꞌisoꞌisoꞌi Anuwa Tabu solanaya. ");
INSERT INTO dob_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ꞌEnega Sakalaya ꞌiapwesa, ta nigeya kapekapeyana be ꞌiona ꞌediya, manuna meyana ꞌimwau. Gete ꞌenega simwalatonina ꞌaene niꞌatu Anuwa Tabu solanaya weꞌiweꞌiyaya ꞌiꞌitena. Ta nigeya sawesawenaya be ꞌiona ꞌediya, ta tuga nimanega ꞌienimasusumo. ");
INSERT INTO dob_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ta Sakalaya ꞌina taliya ꞌana ꞌasiyatao sigumwalaya ga ꞌiila limana ꞌina ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ta tuta gete mulinaya, mwanena Ilisabeti ꞌiꞌeuwana, ga nawalae nima soladiya nigeya ꞌida adadana ta esiya anuwaya ꞌimiyamiya ");
INSERT INTO dob_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ta ꞌigwae, “Gete ꞌagu lema Yaubada ꞌenega. Lowa megagaligu ꞌenega yaomayamaya, ga gete tuga omayamaya ꞌigumwala.” ");
INSERT INTO dob_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ta niꞌatu Ilisabeti ꞌina nawalae sikisi sigumwala, ga Yaubada ꞌina anilose Gebeliela ꞌietunena ga ꞌimai sena Galili ꞌena, ꞌebweu ꞌasa ꞌana esana Nasaleta ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ga ꞌebweu gomagweine nuwenuwebolana ꞌena ꞌiapwesa, ꞌana esana Meli. Gomagweine nina tauna Yosepa ꞌena sisawa eyaiyena, ta tai nina Debida ꞌina susuyega. ");
INSERT INTO dob_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ta anilose nina ꞌimai ga ꞌieonena, ꞌigwae, “Kagutoki Meli. ꞌInapwana ꞌina oboboma sinabwana ꞌemuya, ta tauna maꞌiyayo.” ");
INSERT INTO dob_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ꞌEnega Meli nuwana ꞌiowana ga ꞌinuwanuwa edaedadama, ona nina ꞌana mwalatoi manuna. ");
INSERT INTO dob_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ta anilose nina ꞌigwae, “Meli, geyaꞌabo ꞌumatamatauta, ta Yaubada ꞌina oboboma sinabwa wawasae ꞌemuya ꞌimiyami, ");
INSERT INTO dob_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","be ꞌenega ꞌiabe ꞌuꞌeuwana be natuyo meꞌolotona ꞌuenatune, be ꞌana esana ꞌuda eese Yesu. ");
INSERT INTO dob_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tauna maꞌetamo ꞌietoewaiwai be tomota sida bwauye tauna Toloetana sana Natuna, be ꞌInapwana Yaubada loina waiwaina ꞌida ꞌebwaꞌe, nadigega tubuna Debida ꞌina loina, ");
INSERT INTO dob_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","be ꞌenega Yekobe ꞌina bodao ꞌiloinedi, ta ꞌina loina nina geyaꞌabo ꞌigumwagumwala.” ");
INSERT INTO dob_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ta Meli ꞌiona anilose nina ꞌenaya, ꞌigwae, “Mwaꞌadega batu saꞌi gete? Manuna ꞌaboꞌagu nigeya yaaiai!” ");
INSERT INTO dob_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ta anilose nina ꞌigwae, “Yaluyaluwa Tabuna ꞌiabe ꞌemuya ꞌimwaꞌutama be Yaubada ꞌida giewaiwaiyeyo be natuyo ꞌuenatune gwama ꞌesasena, tauna ꞌiabe sieese Yaubada Natuna. ");
INSERT INTO dob_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ta ꞌuda mwalatoni ꞌaene nibayo Ilisabeti ꞌikaiyale ta megagalina, ta esi ꞌiꞌeuwana, ga niꞌatu ꞌina nawalae sikisi. ");
INSERT INTO dob_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Manuna yage maiboꞌana Yaubada sawesawenaya.” ");
INSERT INTO dob_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ꞌEnega Meli ꞌigwae, “ꞌAgoꞌagu Yaubada ꞌina toguinuwa. Toꞌase ꞌimu ona ꞌeguya nadigega ꞌida apwesa tuga.” ꞌEnega anilose nina Meli ꞌiebesinena ga ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ta tuta gete mulinaya Meli ꞌitoolo ga Yudia ꞌoyanao ꞌituꞌetaodi ga ꞌebweu ꞌasa ꞌena ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ꞌEnega Sakalaya ꞌina anuwaya ꞌilugu ga nibana Ilisabeti ꞌilokagutokiyena. ");
INSERT INTO dob_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ta tuta nina Ilisabeti lokagutoki nina nibana ꞌenega ꞌinonona ga gwama nina gamwanaya ꞌiloniu, ta Yaluyaluwa Tabuna Ilisabeti nina ꞌiloemaena, ");
INSERT INTO dob_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ta ꞌenana sinabwanega ꞌibwau, ꞌigwae, “ꞌEniba, Yaubada ꞌiobobomemuya, nigeya ꞌebweu wate yaita waine nadigega ꞌoyo. Ta natumuna ꞌiabe ꞌuenatune gomagomabwainina. ");
INSERT INTO dob_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ta mwaꞌadega ga ꞌenega ꞌoyo ꞌigu ꞌInapwana sinana, ta ꞌumai ga ꞌuayausigu? ");
INSERT INTO dob_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ta ꞌuꞌita, ꞌimu lokagutoki yanonona, ga gwama ꞌina gwausowala ꞌenega gamwaguya ꞌiloniu sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ta ꞌoyo ꞌInapwana ꞌina ale ꞌana toemisa, ꞌenega ma imu gwausowala, manuna ꞌiabe ꞌana ꞌaiꞌaila ꞌiapwesa ꞌemuya.” ");
INSERT INTO dob_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ta Meli ꞌigwae, “Tuta yauna ꞌateguyega ꞌInapwana yatuputupu, ");
INSERT INTO dob_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ta yagwaugwausowala Yaubada tauna ꞌagu Toꞌetoseyana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Manuna ꞌaboꞌagu tuga ꞌina toguinuwa gomagomabesogu, ta tuwa tuga ꞌiꞌita mwaꞌutama be ꞌenega tuta simeemai ꞌediya ꞌepata auwaudi maiboꞌadi situpugu. ");
INSERT INTO dob_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Manuna Yaubada tauna Toewaiwai sana guinuwa waiwaina ꞌiguinuwena manugu, ta tauna ꞌana esana ꞌesasena ta etaetabuna. ");
INSERT INTO dob_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tauna ꞌana toꞌamayabao ꞌepata ꞌebweuna ꞌebweuna ꞌediyega ꞌiꞌatenuwa ꞌoleꞌoleyedi. ");
INSERT INTO dob_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ta esi taudi togagasao be tonuwatuꞌeyao nimana waiwaina ꞌenega ꞌiꞌausepaledi. ");
INSERT INTO dob_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Toesaesa nidi ꞌigimwaꞌutedi ꞌidi ꞌebemi esaesa ꞌediyega ta togomabeso ꞌigilagasidi. ");
INSERT INTO dob_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ta wate tobotana ꞌieꞌenidi ga gamwadi ꞌipawa, ta toesaesao maanimenimedimo ꞌietune iledi. ");
INSERT INTO dob_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ta tauna ꞌina onaupaupa nina tubudao ꞌediya ꞌinuwaꞌiꞌisina ꞌenega ꞌaboꞌada me Isileli ꞌiꞌatenuwa ꞌoleꞌoleyeda ga ꞌiꞌetoseyeda. ");
INSERT INTO dob_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Onaꞌaiꞌaila, tubudao nidi taudi Ebelaamo ma ina susuyao ꞌediya ꞌionaupaupa be ꞌaene ꞌida ꞌatenuwa ꞌoleꞌole ataedi.” ");
INSERT INTO dob_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ta Meli ꞌina onao niꞌatu ꞌilosalonidi, ꞌenega manibana simiyana nawalae ꞌetoi, ga muliyega ꞌiila limana ꞌina ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ta tuta nina Ilisabeti ꞌienatunaya ga gwama nina meꞌolotona. ");
INSERT INTO dob_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ꞌEnega ꞌina bodao ta wate gosenao Yaubada ꞌina oboboma ꞌenaya sinonona ga maiboꞌadi maꞌenao siegwausowala leleleya. ");
INSERT INTO dob_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ta gwama nina ꞌina tuta tubuwa mulinaya ga niꞌatu ꞌasiyata sebeni, ꞌenega ꞌina bodao sideli egogonama gwama nina bwalana sabi dabana be ꞌenega ꞌaene tamana ꞌena siewaliyesae. ");
INSERT INTO dob_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ga sinana ꞌiꞌetoboda, ꞌigwae, “Nigeya! Ta esi ꞌana esana Yoni.” ");
INSERT INTO dob_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ꞌEnega sigwae, “Nate esana nina nigeya ꞌomi ꞌami esana!” ");
INSERT INTO dob_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ꞌEnega enimasusuyega tamana sienaidena be ꞌaene mwaꞌadega gwama ꞌana esana sida eese. ");
INSERT INTO dob_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ga Sakalaya ꞌebe ꞌetoladi ꞌisidena ga gwama nina ꞌana esana ꞌiꞌetoladinaya, ꞌigwae, “ꞌAna esana Yoni.” ꞌEnega boda maiboꞌadi siꞌitena ga nuwadi ꞌiowana. ");
INSERT INTO dob_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ta tuta gote ꞌenaya Sakalaya meyana ꞌikapekapeyana limana, ga ꞌiona, ga Yaubada ꞌitupuna. ");
INSERT INTO dob_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ga ꞌenega gosenao nidi maiboꞌadi simatauta, ta tetela nina ꞌisakowasi Yudia ꞌoyanao ta senanao maiboꞌadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ta tomota nidi yaisigedi sinonona sinuwa edaedadamina, ꞌenega taudimo sienaidedi, sigwae, “Gwama gete mwaꞌadega ꞌiabe ꞌina guinuwa?” Manuna siꞌitena Yaubada ꞌina waiwai ꞌenaya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ta tamanana Sakalaya Yaluyaluwa Tabuna ꞌiloemaena ga ꞌenega ꞌionaupaupa, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ꞌInapwana tada tupu, tauna me Isileli ꞌida Yaubada, manuna niꞌatu ꞌiayausida sabi lemeda be miyamwau ꞌenega ꞌiliꞌamida. ");
INSERT INTO dob_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ꞌEnega tauna Yaubada ꞌina ꞌaliꞌei Debida ꞌina susuyega ꞌida Toꞌetoseyana nina ꞌigieapwesena ꞌedaya. ");
INSERT INTO dob_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Lowaenei palopitao nuganuganidi Yaubada ꞌina ona gete nadigega sigimi simanena ");
INSERT INTO dob_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ꞌaene ꞌida ꞌetoseyeda ꞌada talauwalao ꞌediyega, ta wate taudi ꞌada toeꞌidiꞌidiyao ꞌediyega, ");
INSERT INTO dob_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ta wate lowa ꞌionaupaupa be ꞌaene gimi tubudao ꞌiꞌatenuwa ꞌoleꞌoleyedi, ta ꞌina onaupaupa nina geyaꞌabo ꞌinuwanuwa pupulei. ");
INSERT INTO dob_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Onaupaupa gete tubuda Ebelaamo manuna Yaubada ꞌenega ");
INSERT INTO dob_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","be ꞌaene ꞌida liꞌamida ꞌada saiyao ꞌediyega ta ma ida ꞌatepatu ꞌenaya tada guinuwa, ");
INSERT INTO dob_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ta wate ꞌaene ma ida bubuna ꞌesasena ta palupaluna ꞌasiyata ꞌebweuna ꞌebweuna. ");
INSERT INTO dob_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ta ꞌoyo natugu, sida eeseyo Toloetana sana ꞌina palopita, manuna ꞌoyo ꞌiabe ꞌununugana be ꞌida ꞌInapwana ꞌina ꞌeda ꞌugibubu, ");
INSERT INTO dob_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ta wate ꞌina tomotaiyao ꞌuemataluwedi be ꞌaene ꞌidi bubuna toꞌumalina ꞌadi nuwatau ꞌediyega ꞌetoseyana siloba. ");
INSERT INTO dob_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Manuna gete, Yaubada ꞌina yala be ꞌina ꞌatenuwa ꞌoleꞌole ꞌedaya be ꞌetoseyana ꞌina maedana ꞌida gimisae ꞌedaya, ");
INSERT INTO dob_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","be ꞌenega taudi wate guguyoi be mwawasa senanao ꞌediya simiyami ꞌida giemaedanedi, be ꞌenega maiboꞌada ꞌida anuganeda gwausowala ꞌana ꞌeda ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ta niꞌatu gwama nina ꞌisinabwa ta yaluyaluwana wate ꞌiewaiwai. ꞌEnega tebweuna sena mwatui daitaya ꞌitauya ga nada ꞌiloꞌasa ga ꞌana laba me Isileli ꞌediya ꞌiapwesa ga ꞌiloguguya. ");
INSERT INTO dob_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ta Yoni ꞌina tuta gwama ꞌenaya ꞌebweu toloina sinabwana ꞌana esana Sisa Ogusito ꞌimiyami, ta ꞌina loina ꞌisaꞌuna be ꞌaene ꞌasa ꞌebweuna ꞌebweuna tomotenidi ꞌadi esanao sida ꞌetoladidi. ");
INSERT INTO dob_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Loina gete ꞌieꞌaleꞌunu tuta nina Kuwilinio ꞌina tuta etoloina Silia ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ꞌEnega tomota maiboꞌadi sitauya ꞌasetamadiya be ꞌadi esanao siꞌetoladidi. ");
INSERT INTO dob_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosepa wate Nasaletega ꞌitoolo nate Galili solanega ga ꞌitauya Yudiya, Debida ꞌina ꞌasa ꞌana esana Bedileema ꞌenaya, manuna Yosepa tauna ꞌebweu Debida ꞌina susu. ");
INSERT INTO dob_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ꞌEnega ꞌana sawaeyai Meli maꞌiyana sitauya be ꞌaene nada ꞌadi esana siꞌetoladi, ta Meli nina ma ꞌeuwanina. ");
INSERT INTO dob_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ta tuta nina Bedileema ꞌena simiyami ga niꞌatu ꞌina nawalae ꞌilobena ga ꞌienatuna, ");
INSERT INTO dob_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ꞌenega gwama nina ꞌoama ꞌediyega ꞌiwaduna ga yobai ꞌidi ꞌebe ꞌeꞌai ꞌenaya ꞌisaꞌuna. Manuna anuwa ꞌowaga niꞌatu ꞌimaa, ꞌenega nigeya ꞌebweu wate mwatui manudi be ꞌena silulugu. ");
INSERT INTO dob_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ta sena nina ꞌenaya sipi ꞌadi toꞌitaꞌiꞌitao boiboiya siyaweyawe ta ꞌidi sipiyao silomalomata ꞌiꞌisidi, ");
INSERT INTO dob_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ta ꞌInapwana ꞌina anilose ꞌiloesalutuidi ga ꞌituyayalidi ta maiboꞌadi simatauta. ");
INSERT INTO dob_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ꞌEnega anilose nina ꞌieonedi, ꞌigwae, “Geyaꞌabo wamatamatauta, ta esi wada gwausowala, manuna ale boboꞌana yameꞌena ꞌemiya be ꞌenega ꞌiabe tomota maiboꞌadi wate ꞌidi ꞌebe gwausowala. ");
INSERT INTO dob_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ta ale nina gete, batuwa boboi nina Debida ꞌina ꞌasaya ꞌami Toꞌetoseyana niꞌatu ꞌitubuwa, tauna ꞌida ꞌInapwana Keliso. ");
INSERT INTO dob_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ꞌEnega ꞌana ꞌebe ꞌinana gete, be ꞌabo gwama nina ꞌoama ꞌenega siwaduna ga yobai ꞌidi ꞌebe ꞌeꞌai ꞌena ꞌiꞌenoꞌeno walobai, tauna tuga nate gwama nina.” ");
INSERT INTO dob_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ta tuta nina ꞌenaya anilose wate yaudi siapwesa, ga Yaubada situputupu, ");
INSERT INTO dob_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","sigwaegwae, “Yaubada galewaya tada tupui, ta baleꞌuya taudi ꞌiobobomedi sida miya gwausowala.” ");
INSERT INTO dob_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ta niꞌatu anilose nidi siila limana galewaya, ga sipi ꞌadi toꞌitaꞌiꞌitao taudimo ꞌediya sigwae, “Bedileema ꞌena tatatauya be yage nina ꞌInapwana ꞌisimanena tada ꞌita. ");
INSERT INTO dob_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ꞌEnega silomanini ga sitauya, ga Meli be Yosepa ta wate gwama nina yobai ꞌidi ꞌebe ꞌeꞌai ꞌena ꞌiꞌenoꞌeno silobena. ");
INSERT INTO dob_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Gote ꞌena siꞌitena ga gwama nina tamana be sinana sieonedi toꞌase nadigega anilose ꞌina ona ꞌediya gwama nina manuna. ");
INSERT INTO dob_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ta ꞌaina tomota ale gete sinononaya ga nuwadi ꞌiowana toꞌitaꞌiꞌita sipi nidi ꞌidi ona manuna. ");
INSERT INTO dob_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ta Meli ona nidi maiboꞌana ꞌinuwaꞌiꞌisidi ga ꞌinuwa edaedadama manudi. ");
INSERT INTO dob_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ꞌEnega toꞌitaꞌiꞌita sipi nidi siila ga ma idi lotuputupu Yaubada ꞌana esana sigilagasina, manuna anilose nina ꞌina simana ꞌediya ꞌana ꞌaiꞌaila sinonona ta wate siꞌitena. ");
INSERT INTO dob_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ta ꞌina wiki niꞌatu ꞌebweuna ꞌigumwala, ga gwama nina bwalana sidabena ga sieesena Yesu, nate esana nina nate lowa anilose Meli ꞌiꞌebwaꞌena tuta nina ꞌetamo nigeya ꞌiꞌeuꞌeuwana. ");
INSERT INTO dob_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ta ꞌina ꞌegabu mulinaya Meli ꞌana gieꞌesasa ꞌana tuta ꞌilobena, ga natudina siꞌauꞌewena Yelusalema ꞌena be sida ꞌebwaya Yaubada ꞌenaya, nadigega Mosese ꞌina loina ꞌisaꞌuna be sida guinuwaꞌesa. ");
INSERT INTO dob_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yaubada ꞌina loina nina gete nadigega siꞌetoladina, ꞌigwae, “Gogama tomatuwa meꞌolotodi ꞌebweuna ꞌebweuna wada tagwaledi ꞌInapwana ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ta wate taudi ꞌidi taliya Yaubada manuna sitauyedi, nadigega ꞌina loina ꞌisaꞌuna, ꞌigwae, “ꞌImi taliya nai buneukwaukwa ꞌeluwa nai bunebune ꞌeluwa.” ");
INSERT INTO dob_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ta gote tuta nina ꞌenaya Yelusalema ꞌenaya ꞌebweu ꞌinapwana ꞌana esana Simioni ꞌimiyami. Tauna tai boboꞌana, ta wate Yaubada ꞌiꞌamayabena sinabwana, ta ma ina ꞌalamaꞌiꞌitana ꞌiyamwayamwa me Isileli ꞌadi Toꞌetoseyana manuna. Tai nina Yaluyaluwa Tabuna ꞌena ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ꞌEnega Yaluyaluwa Tabu nina ꞌieꞌitena be ꞌaene geyaꞌabo ꞌimwawamwawasa be ꞌana laba Toꞌetoseyana nina ꞌInapwana ꞌenega ꞌida ꞌita bemi. ");
INSERT INTO dob_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ta Yaluyaluwa Tabuna ꞌienuwa saꞌuyena, ga Simioni nina ꞌilugu Anuwa Tabu ꞌenaya, ta Yosepa be Meli gwama nina Yesu niꞌatu simeꞌena Anuwa Tabu ꞌenaya be manuna sida guinuwa toꞌase nadigega loina ꞌina simana. ");
INSERT INTO dob_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ꞌEnega Simioni gwama nina ꞌiꞌaalena ga Yaubada ꞌena ꞌilokagutoki, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ꞌInapwana ꞌimu onaupaupa ꞌeguya niꞌatu yalobena, ꞌenega gete tuga ꞌuda tagwalegu be ma igu gwausowala yada mwawasa, ");
INSERT INTO dob_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","manuna mataꞌaiꞌailiguyega ꞌimu Toꞌetoseyana nina yaꞌitena, ");
INSERT INTO dob_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","gete tauna ꞌusaꞌu apwesena maiboꞌama ꞌemaya, ");
INSERT INTO dob_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ta tauna taudi nigeya me Yudia ꞌadi togiemaedana, ta ꞌaboꞌama ꞌimu tomotaiyao me Isileli ꞌima ꞌebe tupu.” ");
INSERT INTO dob_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ta tamana be sinana nuwadi ꞌiowana Simioni ꞌina ona nidi manudi. ");
INSERT INTO dob_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ꞌEnega Simioni ꞌiona obobomedi, ga ꞌiona Meli ꞌenaya, tauna Yesu sinana, ga ꞌigwae, “ꞌUda ꞌita gwama gete Yaubada ꞌiesinuwena be ꞌenega maꞌetamo me Isileli yaudi ꞌigiebeꞌuyedi, ta wate yaudi ꞌigietoolodi. Ta tauna tuga ꞌiabe ꞌida eweꞌiweꞌiyaya tomota ꞌediya ta ꞌaidi sida ꞌawakabokaboe, ");
INSERT INTO dob_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ta ꞌenega ꞌidi nuwanuwa kwaikwaiyidi ꞌida gieapwesedi. Ta ꞌoyo Meli ꞌiabe ꞌimu nuwamwau ꞌatuwa suna ꞌibadibadiyo.” ");
INSERT INTO dob_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gote ꞌena ꞌebweu palopita mewainena ꞌimiyami, ꞌana esana Ana, tauna Panuela natuna, ta wate Aseli ꞌina susu ꞌebweu. Waine nina niꞌatu ꞌikaiyale, manuna lowaenei ꞌiai ga mamwanena simiyami nadigega yakwala sebeni. ");
INSERT INTO dob_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ta mwanenana ꞌimwawasa ga niꞌatu ꞌikwabula, ta ꞌimiyami ꞌana laba ꞌana yakwala eitipowa ꞌilobena. Ta waine nina tauna Anuwa Tabu nigeya ꞌida ebesinena ꞌasiyata be boiboi ꞌediya, ta Anuwa Tabu solanaya Yaubada ꞌiꞌamaꞌamayabe, ta ꞌisidasida ꞌebotanega. ");
INSERT INTO dob_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tuta gote ꞌenaya waine nina ꞌimai ga Yaubada ꞌena ꞌilokagutoki, ta gwama nina manuna ꞌiona me Yelusalema ꞌediya, ꞌigwae, “Gwama gete tauna ꞌada Toꞌetoseyana nina tayamwayamwena.” ");
INSERT INTO dob_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ta niꞌatu guinuwa maiboꞌana silosalonidi, toꞌase nadigega Yaubada ꞌina loina, ga siila limana Galili, sana taudi me Nasaleta. ");
INSERT INTO dob_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ga gwama nina ꞌisinabwa ga ma ina waiwai, ta wate ma ina sinasinapu, manuna Yaubada gwama nina ꞌiobobomena sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yakwala ꞌebweuna ꞌebweuna ꞌediya Yesu sinana be tamana situꞌetuꞌe Yelusalema, Ataona Sagalina manuna. ");
INSERT INTO dob_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ta tuta nina Yesu ꞌina yakwala tuwelo ꞌilobena ga maꞌedi situꞌe sagali nina ꞌena. ");
INSERT INTO dob_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ꞌEnega tuta nina sagali ꞌigumwala ga maiboꞌadi sideli sawala ꞌidi ꞌasaya, ta gwama nina Yesu tuga Yelusalema ꞌena ꞌimiyami. Ta tamana be sinana nigeya simwalamwalatoni, ");
INSERT INTO dob_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ta sinuwena ꞌaene tauna boda maꞌenao. ꞌEnega sitautauya ga ꞌana laba ꞌiboi, ga Yesu siꞌebesena ꞌidi bodao be gosediyao ꞌediya, ");
INSERT INTO dob_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ta nigeya silobaloba, ꞌenega siila limana Yelusalema, ga nada siꞌebesena, ");
INSERT INTO dob_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ta nigeya silobaloba ꞌana laba ꞌasiyata ꞌetoi sigumwala, ga silobena Anuwa Tabu solanaya, me Yudia ꞌidi toeꞌitao maꞌenao simiyami, ꞌienoenonoedi ta wate ꞌienaenaida ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ta taudi ꞌina eꞌisao boboꞌadi ta palupaludi sinonona, ga maiboꞌadi nuwadi ꞌiowana. ");
INSERT INTO dob_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ta wate tuta nina tamana be sinana siꞌitena nuwadi ꞌiowana, ga sinana ꞌieonena, ꞌigwae, “Natugu, toꞌase manuna gete nadigega ꞌuguinuwaꞌesa, ga ꞌenega ma ima nuwamwau tamayo maꞌiyagu ꞌaꞌebeꞌebeseyo?” ");
INSERT INTO dob_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ꞌEnega Yesu ꞌigwae, “Toꞌase manuna waꞌebeꞌebesegu? Nai nigeya wamwalamwalatoni ꞌaene ꞌaboꞌagu Tamagu ꞌina anuwaya yamiyami?” ");
INSERT INTO dob_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ta tamana be sinana nigeya nuwadi ꞌisabwasabwalena ꞌina ona manuna. ");
INSERT INTO dob_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ꞌEnega maꞌenao siila limana Nasaleta ga nada ꞌidi ona ꞌiematamatanedi. Ta esi sinana yage gete manudi ꞌinuwanuwa sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ga Yesu ꞌisinasinbwa ma ina sinasinapu, ꞌenega Yaubada ꞌigwausowala manuna, ta tomota wate nadigega ꞌidi gwausowala. ");
INSERT INTO dob_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Toloina sinabwana Sisa, tauna ꞌana esana Taibilia, niꞌatu ꞌiloiloina yakwala pipitini ꞌediya, ta ꞌubuninaya Ponitio Pailato sena Yudia ꞌana toloina, ta Elodi sena Galili ꞌana toloina, ta tasina Pilipi sena Itulia be Tilakoniti ꞌadi toloina, ta Lisania sena Abiline ꞌana toloina. ");
INSERT INTO dob_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ta Anasa be Kaiyapa taudi totaliyao ꞌadi toloinao. Tuta nina gote ꞌenaya Yaubada ꞌina ona ꞌimai Sakalaya natuna Yoni ꞌenaya, tauna sena mitawa daitaya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Gote ꞌena Yoni ꞌitoolo ga Yolidani senanao ꞌediya ꞌitauya ga tomota ꞌediya ꞌiloguguya, ꞌigwae, “ꞌImi guinuwa toꞌumalidi waguitoyasedi ta yagiebapitaisoemi be ꞌenega Yaubada ꞌimi toꞌumalinao ꞌida nuwataudi.” ");
INSERT INTO dob_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nadigega Buki Tabu ꞌenaya palopita Aisea ꞌigimisimanena, ꞌigwae, “Tobwau ꞌebweu sena mitawa daitaya ꞌenana sinabwana ꞌenega ꞌida simana apwesa be ꞌida gwae, ‘ꞌInapwana ꞌina ꞌeda wada kakali, ta wagiepaepalu. ");
INSERT INTO dob_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ꞌOyao maiboꞌadi watai yauledi be siꞌabatau, ta saꞌala maiboꞌadi wasiudi. Ta wate ꞌeda bokobokodi wagiepaepaludi ta ꞌeda dakadakadi wagienono kwaikwaidi. ");
INSERT INTO dob_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Be ꞌenega tomota maiboꞌadi Yaubada ꞌina ꞌetoseyana sida ꞌita.’” ");
INSERT INTO dob_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ꞌEnega tomota yaudi sitauya Yoni ꞌenaya be ꞌaene ꞌida giebapitaisoedi, ta Yoni nina ꞌieonedi, ꞌigwae, “Tokabo ꞌomi, nadigega mwata! Ta wanuwena ꞌaene ꞌiabe Yaubada ꞌina gamwasowala ꞌenega wadedena, aga? ");
INSERT INTO dob_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ꞌEnega ꞌilobwenemi be ꞌimi nuwaꞌebuni ꞌaiꞌaila wada eꞌitae ꞌimi guinuwa boboꞌadi ꞌediyega. Ta geyaꞌabo waonaona ꞌaene ꞌomi Ebelaamo tubunao ꞌenega Yaubada ꞌida ꞌatenuwa ꞌoleꞌoleyemi. Nigeya saꞌi! Ta waꞌita, Yaubada sawesawenaya be gulewa getedi ꞌediyega Ebelaamo tubunao ꞌimweluluidi. ");
INSERT INTO dob_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ta ꞌabo ꞌimi bubuna nigeya boboꞌadi ꞌiabe Yaubada ꞌibwaꞌomatami, nadigega kaiwe, ꞌabo nigeya uwana boboꞌana tomota sitala yauledi be ꞌawesabelulu ꞌena siuledi be sigabudi.” ");
INSERT INTO dob_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ꞌEnega boda nidi Yoni sienaidena, sigwae, “Toꞌase ꞌilobwenema be ꞌada guinuwe?” ");
INSERT INTO dob_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ga Yoni nina ꞌigwae, “ꞌAbo yaisigedi ꞌomi ꞌami ꞌoamao ꞌeluwa ta gosemiyao nigeya ꞌadi ꞌoamamo, ꞌebweu waꞌebwaꞌedi. Ta wate nadigega ꞌabo ꞌami masulao sinabwana, tupwana tobotanao ꞌediya wada eguyaiyedi.” ");
INSERT INTO dob_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ta ꞌaidi wate takisi ꞌana toꞌewao simai ꞌidi bapitaiso manuna, ga Yoni ꞌena sienaida, sigwae, “Toeꞌita, ꞌaboꞌama mwaꞌadega ꞌama loina?” ");
INSERT INTO dob_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ꞌEnega Yoni ꞌigwae, “Takisi ꞌana loinega waꞌewaꞌewa, ta geyaꞌabo loeposeyana wasaꞌusaꞌu.” ");
INSERT INTO dob_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ta ꞌaidi wate tolosaiyao sienaenaida, sigwae, “Ta ꞌaboꞌama, mwaꞌadega ꞌama loina?” Ga Yoni ꞌigwae, “ꞌOmi ꞌami eꞌisao niꞌatu sawesawemiya ta esi manudi wada gwausowala, ta geyaꞌabo ꞌami eꞌisa ꞌana loeposeyana kaboega be giematautega waꞌewaꞌewa.” ");
INSERT INTO dob_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ta esi tomota maiboꞌadi ma idi emisa siyamwayamwa Toꞌetoseyana nina Keliso ꞌina mai manuna, ga Yoni siꞌitena ta maiboꞌadi sienuwanaluwa ga sigwae, “Nai tauna Toꞌetoseyana nina, nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ꞌEnega Yoni ꞌiona apwesa ꞌediya, ꞌigwae, “ꞌAboꞌagu bwasiyega tuga yagie bapitaisoemi, ta esi ꞌebweu tai muliguyega ꞌimeemai be Yaluyaluwa Tabuna nadigega ꞌawe sabelulu ꞌenega ꞌigie bapitaisoemi. Tauna ꞌisinabwa sinegu, ꞌenega nigeya ꞌilobwelobwenegu be ꞌana ꞌaelawa yaliꞌami. ");
INSERT INTO dob_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ta tai gete ꞌina ꞌinawega ꞌiabe witi ꞌida sabutudi be uwana sisasagu be muliyega uwana boboꞌadi ꞌiedodo ꞌina anuwa masulaya, ta sumwasumwa nidi ꞌawe sabelulu ataya ꞌena ꞌigabudi.” ");
INSERT INTO dob_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ta guguya wate yauna ꞌediyega tetela boboꞌana Yoni ꞌiloguguyaena tomota ꞌediya, ");
INSERT INTO dob_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ta wate Yoni nina toloina ꞌana esana Elodi ꞌiꞌawa toꞌumaliyena, ꞌigwae, “Elodi, niꞌatu ꞌuloegesi. Elodiasa tauna tasiyo mwanena, ta ꞌuaina.” Ta ꞌaina wate Elodi ꞌina toꞌumalinao Yoni ꞌisimanedi. ");
INSERT INTO dob_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ꞌEnega Elodi ꞌigamwasowala ga Yoni deliya ꞌisaꞌu luguyena. Gote ꞌenega Elodi nina ꞌina toꞌumalina ꞌisinabwa ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ta niꞌatu Yoni boda maiboꞌadi ꞌigie bapitaisoedi, ga muliyega Yesu wate ꞌigie bapitaisoena, ta ꞌenega Yesu Yaubada ꞌena ꞌisidasida, ga galewa ꞌiꞌegegena, ");
INSERT INTO dob_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ta Yaluyaluwa Tabuna, maoona ꞌana ꞌita nadigega bunebune, ꞌimwaꞌuta Yesu ꞌenaya. ꞌEnega ꞌebweu ꞌenana galewega ꞌionama, ꞌigwae, “ꞌOyo natuꞌaiꞌailigu, manuyo yagwausowala sinabwana.” ");
INSERT INTO dob_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ta tuta nina Yesu ꞌana yakwala nadigega teti ꞌilobena, ꞌina guinuwa tomota ꞌediya ꞌieꞌalena. Ta tomota sinuwena ꞌaene tauna tamana Yosepa, ta Yosepa tamana Eli, ");
INSERT INTO dob_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ta Eli tamana Madati, ta Madati tamana Libai, ta Libai tamana Meliki, ta Meliki tamana Yanai, ta Yanai tamana Yosepa, ");
INSERT INTO dob_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ta Yosepa tamana Matadaya, ta Matadaya tamana Emosi, ta Emosi tamana Neumi, ta Neumi tamana Esili, ta Esili tamana Nagai, ");
INSERT INTO dob_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ta Nagai tamana Maati, ta Maati tamana Matadaya, ta Matadaya tamana Semini, ta Semini tamana Yoseki, ta Yoseki tamana Yoda, ");
INSERT INTO dob_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ta Yoda tamana Yoanani, ta Yoanani tamana Lisa, ta Lisa tamana Selubabela, ta Selubabela tamana Salatieli, ta Salatieli tamana Nili, ");
INSERT INTO dob_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ta Nili tamana Meliki, ta Meliki tamana Adi, ta Adi tamana Kosami, ta Kosami tamana Elimadami, ta Elimadami tamana Eli, ");
INSERT INTO dob_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ta Eli tamana Yosuwa, ta Yosuwa tamana Eliyesa, ta Eliyesa tamana Yolima, ta Yolima tamana Madati, ta Madati tamana Libai, ");
INSERT INTO dob_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ta Libai tamana Simioni, ta Simioni tamana Yuda, ta Yuda tamana Yosepa, ta Yosepa tamana Yonami, ta Yonami tamana Ilayakimi, ");
INSERT INTO dob_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ta Ilayakimi tamana Meliya, ta Meliya tamana Mena, ta Mena tamana Matata, ta Matata tamana Nedani, ta Nedani tamana Debida, ");
INSERT INTO dob_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ta Debida tamana Yese, ta Yese tamana Obedi, ta Obedi tamana Boasa, ta Boasa tamana Salimoni, ta Salimoni tamana Nasoni, ");
INSERT INTO dob_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ta Nasoni tamana Aminadaba, ta Aminadaba tamana Adamina, ta Adamina tamana Anai, ta Anai tamana Esiloni, ta Esiloni tamana Pelesi, ta Pelesi tamana Yuda, ");
INSERT INTO dob_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ta Yuda tamana Yekobe, ta Yekobe tamana Aisake, ta Aisake tamana Ebelaamo, ta Ebelaamo tamana Tela, ta Tela tamana Naoli, ");
INSERT INTO dob_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ta Naoli tamana Seluge, ta Seluge tamana Leu, ta Leu tamana Peligi, ta Peligi tamana Ibeli, ta Ibeli tamana Sila, ");
INSERT INTO dob_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ta Sila tamana Keinana, ta Keinana tamana Apakisadi, ta Apakisadi tamana Semi, ta Semi tamana Noa, ta Noa tamana Lemeki, ");
INSERT INTO dob_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ta Lemeki tamana Metusela, ta Metusela tamana Inoki, ta Inoki tamana Yeledi, ta Yeledi tamana Malaleli, ta Malaleli tamana Keinana, ");
INSERT INTO dob_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ta Keinana tamana Inosi, ta Inosi tamana Seti, ta Seti tamana Adama, ta Adama tamana Yaubada. ");
INSERT INTO dob_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ꞌEnega Yaluyaluwa Tabuna Yesu ꞌiloemaena ga Yolidaniyega Yesu ꞌiꞌauꞌewena ga ꞌitauyena sena mitawa daitaya. ");
INSERT INTO dob_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ga ꞌasiyata poti ꞌediya Seitani ꞌitoowaiwai be ꞌaene Yesu ꞌigiebeꞌu, ta ꞌasiyata nidi ꞌediya Yesu nigeya ꞌiꞌeꞌai, ga ꞌenega ꞌibotana sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ta Seitani nina Yesu ꞌieonena, ꞌigwae, “ꞌEguma ꞌoyo Yaubada natuna, gulewa getedi ꞌuloinedi be sida emasula.” ");
INSERT INTO dob_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ta Yesu ꞌigwae, “Buki Tabu solanaya loina ꞌimiyami ꞌaene ‘Tomota yawasidi nigeya masula namo ꞌenega sida lobena.’” ");
INSERT INTO dob_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ꞌEnega Seitani Yesu ꞌiꞌauꞌewa tuꞌeyena ga baleꞌu ꞌina ꞌebe loinao maiboꞌadi ꞌieꞌitena tuta nina gote ꞌenaya, ga ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","“Gete ꞌebeloina esaesa maiboꞌadi yaꞌebwaꞌeyo ꞌabo ꞌeguya ꞌubwagobwago. Manuna maiboꞌana tuga ꞌigu ꞌebeloina. Ta ꞌabo yaita ꞌena nuwanuwagu be yaꞌebwaꞌe, yada ꞌebwaya tuga.” ");
INSERT INTO dob_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ta Yesu ꞌigwae, “Buki Tabu solanaya loina ꞌimiyami, ꞌigwae, ‘ꞌImu ꞌInapwana Yaubada namo ꞌenaya ꞌuda bwagobwago be taunamo ꞌina ona ꞌuda ematamatanedi.’ ");
INSERT INTO dob_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ꞌEnega Seitani Yesu ꞌiꞌauꞌewena ga ꞌitauyena Yelusalema ga Anuwa Tabu tabwana ꞌaiꞌailaya ꞌituꞌeyena ga ꞌena ꞌieonena, ꞌigwae, “ꞌEguma ꞌoyo Yaubada Natuna, gete ꞌenega ꞌusosobu ta geyaꞌabo ꞌuesiesilae, ");
INSERT INTO dob_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","manuna Buki Tabu niꞌatu ꞌisimana, ꞌigwae, ‘Yaubada ꞌina aniloseyao ꞌida loinedi be siꞌitaꞌiꞌisiyo.’ ");
INSERT INTO dob_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ta ꞌebweu wate ꞌina ona ꞌigwae, ‘ꞌIna aniloseyao sida ꞌaaliyo be ꞌenega geyaꞌabo ꞌaeyo siesiesilae gulewa ꞌediya.’ ");
INSERT INTO dob_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ta Yesu ona nina ꞌieꞌisena ꞌigwae, “ꞌEbweu wate ona Buki Tabu ꞌena ꞌimiyami, ꞌigwae, ‘Geyaꞌabo ꞌimu ꞌInapwana Yaubada ꞌutootoo.’ ");
INSERT INTO dob_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ta niꞌatu Seitani ꞌina toona maiboꞌana Yesu ꞌenaya ꞌilosalonina, ga ꞌiebesinena be mali tuta ꞌida ilama. ");
INSERT INTO dob_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ꞌEnega Yesu Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌiila limana Galili. Ga gote ꞌena Yesu tetelina ꞌiꞌelelewana Galili senanao ꞌediya, ");
INSERT INTO dob_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","manuna me Galili nidi ꞌidi anuwa tapwalolo ꞌediya ꞌiloguloguguya, ga ꞌenega maiboꞌadi siꞌawa boboꞌanena. ");
INSERT INTO dob_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ga muliyega Yesu ꞌimai Nasaleta ꞌenaya, tauna gote ꞌina ꞌasa ꞌaiꞌaila. Ga ꞌebweu Sabate ꞌena Yesu ꞌilugu anuwa tapwaloloya, ꞌina bubuna nadigega. ꞌEnega ꞌitoolo be Buki Tabu ꞌida sawa, ");
INSERT INTO dob_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ꞌenega palopita Aisea ꞌina ꞌetoladi siꞌebwaꞌena, ga ꞌineyasina ga sawa nina ꞌilobena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ꞌInapwana Yaluyaluwana ꞌeguya ꞌimiyami. Tauna ꞌiesinuwegu be togomabeso ꞌediya tetela boboꞌana yaguguyae. Ta yoniyonidi wate ꞌediya ꞌietunegu be ꞌadi liꞌama manuna yada simane. Ta tomatakebokebo wate ꞌidi ꞌesasa limana manuna yasimane. Ta wate ꞌietunegu be tomiyamwau ꞌadi talauwalao nimadiyega yaꞌetoliꞌamidi. ");
INSERT INTO dob_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta yasimane yakwala nina maꞌetamo ꞌInapwana ꞌida ꞌetoseyemi.” ");
INSERT INTO dob_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ta Yesu niꞌatu ꞌetoladi nidi ꞌisawedi ga ꞌinunumina, ꞌenega buki ꞌana toꞌitaꞌiꞌita ꞌiꞌebwaya limena, ga ꞌimiyatowa. Ta toenonoyao maiboꞌadi nuwadi ꞌiꞌewena, ꞌenega simiyami ta siduneduneye. ");
INSERT INTO dob_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ꞌEnega ꞌieonedi, ꞌigwae, “Ona gete niꞌatu yasawena ga wanonona, lowa sigimi simanena, ta gete tuga niꞌatu ꞌiapwesa saba.” ");
INSERT INTO dob_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ga taudi nuwadi ꞌiowana ꞌaiꞌaila, ꞌenega ꞌina onao boboꞌadi manudi situpuna sinabwana, sigwae, “Tai gete Yosepa natuna, aga? Ta mwaꞌadega saꞌi?” ");
INSERT INTO dob_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ꞌEnega ꞌieonedi, ꞌigwae, “Niꞌatu yamwalatonimi manuna ꞌiabe onasemalimali gete ꞌenega waeonagu be wagwae, ‘ꞌOyo togileꞌoasa saꞌi, ꞌenega tauyo ꞌuda gieboboꞌaneyo.’ Ta wate ꞌiabe ꞌimi ona ꞌebweu ꞌenega waeonagu be wagwae, ‘Guinuwa nidi waiwaidi ꞌasa Kapaneumi ꞌenaya ꞌuguinuwediya, nadigega wate ꞌuda guinuwaꞌesedi bada ꞌida ꞌasa gete ꞌenaya.’ ");
INSERT INTO dob_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ta yaeona ꞌaiꞌailimi ꞌaene nigeya ꞌebweu palopita ꞌina bodao ꞌediyega ꞌana ꞌamayaba ꞌida lobena. ");
INSERT INTO dob_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ta wanuwaꞌiꞌisi ꞌaene lowa palopita Ilaitiya ꞌina tutaya kwabulao yaudi Isileli ꞌena simiyami, ta Yaubada nigeya Isileli wainena ꞌiesiesinuwe be Ilaitiya ꞌiꞌitaꞌiꞌisi tuta nina botana sinabwana, manuna yakwala ꞌetoi ta tupwana ꞌediya nigeya ꞌusana, ");
INSERT INTO dob_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ta esiya ꞌebweu kwabula Salepati ꞌenega Yaubada ꞌiesinuwena Ilaitiya ꞌana ꞌitaꞌiꞌita manuna, nate Saidoni sena nina, ta Yaubada Ilaitiya ꞌietunena kwabula nina ꞌina ꞌasaya ga ꞌiꞌitaꞌiꞌisina. ");
INSERT INTO dob_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta palopita Ilaisa wate ꞌina tutaya tolepelo yaudi Isileli ꞌenaya simiyami, ta nigeya ꞌebweu yaita ꞌediyega ꞌigiegie boboꞌane, ta esi ꞌebweu namo goma Silia ꞌigie boboꞌanena, ꞌana esana Naamani.” ");
INSERT INTO dob_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesu ꞌina ona gete ꞌediyega taudi totapwalolo nidi ꞌigie gamwasowalidi, ");
INSERT INTO dob_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ꞌenega sitoolo ga Yesu sigiyaina ta ꞌasega siꞌauꞌewa apwesena ga sitauyena ꞌidi ꞌasa ꞌoyana ꞌenaya, ga ꞌoya debanaya sisaꞌuna be ꞌaene siasepala mwaꞌute babagaya. ");
INSERT INTO dob_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ta tauna boda nidi ꞌiaweyalidi ga ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ga muliyega ꞌimwaꞌuta Kapaneumi ꞌena, nate Galili senanaya ga nada Sabateya tomota ꞌieꞌitedi. ");
INSERT INTO dob_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ta tomota maiboꞌadi nuwadi ꞌiowana manuna ꞌina eꞌita maiboꞌana palupaluna ta waiwaina. ");
INSERT INTO dob_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ta anuwa tapwalolo nina ꞌenaya ꞌebweu tai ꞌimiyami, ta tai nina ꞌenaya yaluyaluwa biꞌi lowa ꞌilugu ga ꞌimiyami, ꞌenega tai nina ꞌenana sinabwanega ꞌibwau, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ya! Yesu, ꞌoyo goma Nasaleta, toꞌase ꞌalena ga ꞌumai ꞌemaya? Nuwanuwayo be ꞌaene ꞌuda peꞌuma, aga? Ta ꞌoyo saꞌi niꞌatu yamwalatonimu, ꞌoyo tuga Yaubada Natuna.” ");
INSERT INTO dob_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ta Yesu ꞌiloinena, ꞌigwae, “ꞌUlosaꞌu, be tai nate ꞌenega ꞌuapwesama.” Ga palupaluna boda matadiya yaluyaluwa biꞌi nina tai ꞌiulaena baleꞌuya ta ꞌenega yaluyaluwa biꞌi ꞌiapwesa, ta nigeya ꞌebweu esilae tai nina ꞌilobaloba. ");
INSERT INTO dob_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ꞌEnega maiboꞌadi silosuyaedi ga taudimo sienaidedi, sigwae, “Mwaꞌadega sana gete? Ga ona namo ꞌina waiwai ꞌenega yaluyaluwa biꞌi ꞌiloinedi ga siapwesa.” ");
INSERT INTO dob_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Gote ꞌena Yesu tetelina silelewanena Galili senanao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ꞌEnega Yesu anuwa tapwalolo nina ꞌenega ꞌiapwesa ga Saimoni ꞌina anuwaya ꞌilugu. Ga Saimoni lawana ooyaiyaiyega ꞌileꞌoasa, ꞌenega Yesu sisidena be ꞌida gieboboꞌane. ");
INSERT INTO dob_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ꞌEnega Yesu ꞌilugu ga ꞌina ꞌebeꞌeno selabenaya ꞌitoolo, ta leꞌoasa nina ꞌiloinena ga ꞌina leꞌoasa ꞌisaligogo, ꞌenega waine nina ꞌitoolo ga ꞌadi masula ꞌigibubuna. ");
INSERT INTO dob_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ta niꞌatu sinala ꞌisuguwa ga tomota ꞌidi toleꞌoasao ꞌadi leꞌoasao dumadumadi be dumadumadi siꞌauꞌewedima Yesu ꞌenaya, ga maiboꞌadi ꞌebweuna ꞌebweuna ꞌigitoodi ga siboboꞌana. ");
INSERT INTO dob_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ta wate yaudi ꞌediyega yaluyaluwa biꞌi siapweapwesa ta sibwaubwau, sigwae, “Onaꞌaiꞌaila saꞌi, ꞌoyo Yaubada Natuna!” Ga Yesu ꞌiꞌetobodedi be geyaꞌabo nadigega sionaonaꞌesa, manuna niꞌatu simwalatonina ꞌaene tauna Toꞌetoseyana nina Yaubada ꞌenega. ");
INSERT INTO dob_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ta niꞌatu tomwa ꞌiulisina ga Yesu ꞌasa nina ꞌipilisinena ga tebweuna mwatui daitaya ꞌitauya. Ta tomota yaudi sieꞌale be ꞌaene Yesu siꞌebese, ta tuta nina silobena sieonena, sigwae, “Geyaꞌabo ꞌutautauya. Bada tuga tamiyami.” ");
INSERT INTO dob_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ꞌEnega ꞌieonedi, ꞌigwae, “ꞌAina wate ꞌasa ꞌediya yatatauya be Yaubada ꞌina loina tetelina yada loguguyae. Gete tetela nina manuna ga Yaubada ꞌietuneguma.” ");
INSERT INTO dob_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ꞌEnega ꞌiapwesa ga ꞌitauya Yudia senanao maiboꞌadi ꞌediya, ga ꞌidi anuwa tapwaloloyao soladiya ꞌiloguguya sakowasi. ");
INSERT INTO dob_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ꞌEbweu tuta Yesu ꞌitootoolo ola Genesaleta tupitupinaya ta boda simai ga sitoolo pogipogina be ꞌaene Yaubada ꞌina ona Yesu ꞌenega sida nono. ");
INSERT INTO dob_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Gote ꞌenaya togomana ꞌidi waga ꞌeluwa ꞌiꞌitedi selabenaya silisidi dabalaya, ta togomana nidi niꞌatu sisuya ga ꞌidi gomana siꞌutuꞌutudi. ");
INSERT INTO dob_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ꞌEnega Yesu waga ꞌebweu ꞌena ꞌigelu, nate Saimoni ꞌina waga, ga Saimoni ꞌieonena be tupwana ꞌitaladolo, ga ꞌenega ꞌitaladolo niꞌuya ga waga nina ꞌena Yesu ꞌimiyatowa ta ꞌieꞌita boda ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ta niꞌatu ꞌina eꞌita ꞌigumwala ga Saimoni ꞌieonena, ꞌigwae, “Saimoni, tupwana ꞌutaladolo niꞌuya be ꞌimu gomana ꞌuyauye.” ");
INSERT INTO dob_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ta Saimoni ꞌigwae, “ꞌInapwana, boiboiya saꞌi ꞌagomana masalina ta nigeya ꞌebweu wate iyana ꞌaꞌonaꞌona. Ta tuwa tuga ꞌimu ona manuna ꞌenega gomana yayauye.” ");
INSERT INTO dob_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Siyauyena ga iyana yau wawasae siꞌonedi ga gomana nina abe ꞌiꞌesaꞌesabu. ");
INSERT INTO dob_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ꞌEnega gosediyao mali wagega siloꞌuyoedi be ꞌaene simama be silemedi. ꞌEnega taudi ꞌidi wagega simai ga waga ꞌeluwa siloemaedi ga abe sidamadamana. ");
INSERT INTO dob_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Gote ꞌena Saimoni Pita iyana ꞌana yau ꞌiꞌitedi ga Yesu ꞌaenaya ꞌibwagobwago, ta Pita ꞌigwae, “ꞌInapwana ꞌuda pilisinegu, manuna ꞌaboꞌagu totoꞌumaligu.” ");
INSERT INTO dob_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ona gete ꞌiꞌinanena manuna magosenao nuwadi ꞌiowana ꞌaiꞌaila iyana nidi siꞌonedi manudi, ");
INSERT INTO dob_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ta wate nadigega Saimoni gosenao nidi Yemesa be Yoni, taudi Sebedi natunao. ꞌEnega Yesu Pita ꞌieonena, ꞌigwae, “Geyaꞌabo ꞌuꞌateꞌate saꞌala. Ta esi gete ꞌenega be tomota nadigega ꞌuda ꞌonaꞌesedi.” ");
INSERT INTO dob_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ꞌEnega maiboꞌadi silaga dabalaya ga yage yauyauna siebesinedi ga Yesu simuliyena. ");
INSERT INTO dob_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ta mali tutaya Yesu wate ꞌebweu ꞌasa ꞌena ꞌimiyami. Sena nina ꞌenaya ꞌebweu tai bwalana maiboꞌana lepelo ꞌiꞌewena. ꞌEnega tai nina Yesu ꞌiꞌitalobena ga ꞌibwago sanamwaꞌuta baleꞌuya ga ꞌisidena, ꞌigwae, “ꞌInapwana, ꞌeguma ꞌimu nuwanuwa nadigega, kapekapeyana be ꞌugie boboꞌanegu.” ");
INSERT INTO dob_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ta Yesu nimanega tai bwalana ꞌigitoona ta ꞌigwae, “O, boboꞌana! ꞌUda ꞌesasa.” Ga tai nina ꞌana lepelo ꞌigumwala manini. ");
INSERT INTO dob_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ꞌEnega Yesu tai nina ꞌiemataluwena, ꞌigwae, “ꞌUtatauya ta geyaꞌabo ꞌebweu yaita wate ꞌena ꞌusimasimanegu ta esi ꞌutatauya totaliya ꞌenaya be ꞌiꞌitayo, be ꞌenega ꞌimu taliya ꞌuꞌebwaya Yaubada ꞌena, toꞌase nadigega ꞌada loina Mosese ꞌenega, be ꞌenega tomota sida mwalatoniyo ꞌaene niꞌatu ꞌuꞌesasemu.” ");
INSERT INTO dob_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ta esi gote ꞌenega ga Yesu tetelina ꞌisinabwa ꞌaiꞌaila ga pwalu yaudi sidelima be ꞌaene Yesu ꞌina ona sida nono, ta wate ꞌadi leꞌoasao ꞌaene ꞌida gieboboꞌanedi, ");
INSERT INTO dob_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ta esi tuta yauyauna boda ꞌediyega ꞌitautauya dumaduma be ꞌisidasida Yaubada ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ꞌEbweu ꞌasiyata ꞌenaya Yesu boda ꞌieꞌieꞌitadi. Ta ꞌaidi Palisiyao be loina ꞌana toeꞌitao taudi simai Galili be Yudia be Yelusalema ꞌasanao ꞌediyega ga boda maꞌediyao simiyami ta sienoenono. Tuta gote ꞌena Yaubada ꞌina waiwaiyega Yesu toleꞌoasao ꞌigiegie boboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ꞌEnega boda ꞌebweu tokweno ꞌina ꞌebe ꞌenoega siꞌaalinama ga sitoona be ꞌaene siluguye anuwaya be Yesu matanaya sisaꞌu. ");
INSERT INTO dob_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ta nigeya sawesawediya, manuna pwalu sinabwa wawasae. ꞌEnega tokweno nina siꞌaala tuꞌeyena anuwa etaninaya ga ꞌana ꞌatowa siꞌewa yaulena ta ꞌenega tokweno nina ma ꞌebe ꞌenona sietabetabeyena boda nidi gamwagamwanidiya, ga Yesu matanaya sisaꞌuna. ");
INSERT INTO dob_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ga Yesu tomotai nidi ꞌidi emisa ꞌimwalatoninaya ga tai nina ꞌieonena, ꞌigwae, “Gosiyagu, ꞌimu bubuna toꞌumalidi ꞌadi nuwatau niꞌatu ꞌulobedi.” ");
INSERT INTO dob_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ta saꞌi, loina ꞌana toeꞌitao be Palisiyao Yesu ꞌina ona niꞌatu sinonona ga taudimo ꞌediya sienaenaida, sigwae, “Yesu gete mwaꞌadega ga Yaubada ꞌena ꞌioopaꞌala? Manuna nigeya ꞌebweu yaita sawesawenaya be tomota ꞌidi bubuna toꞌumalina ꞌida nuwataudi, nate namo Yaubada sawesawenaya.” ");
INSERT INTO dob_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ꞌIdi nuwanuwa Yesu niꞌatu ꞌimwalatonina, ꞌenega ꞌieonedi, “Toꞌase manuna ꞌatemiya nate nadigega wanuwanuwaꞌesa? ");
INSERT INTO dob_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ta toꞌase wanuwena yada onae tai gete ꞌenaya be ꞌaene yada gwae, ‘ꞌImu bubuna toꞌumalina niꞌatu yanuwataudi,’ nai yada gwae, ‘ꞌUtoolo be ꞌutatauya’? ");
INSERT INTO dob_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ta wada mwalatoni ꞌaene ꞌaboꞌagu Tomota Natuna ma igu loina baleꞌuya be tomota ꞌidi bubuna toꞌumalina yanuwataudi.” ꞌEnega tokweno nina ꞌieonena, ꞌigwae, “ꞌAboꞌagu gete yaeonayo, ‘ꞌUtoolo be ꞌimu ꞌebeꞌeno ꞌuꞌaala be ꞌutatauya ꞌimu ꞌasaya.’ ");
INSERT INTO dob_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ta ꞌilomanini ga boda matadiyega ꞌitoolo ga ꞌina ꞌebeꞌeno ꞌiꞌaalena ga ꞌitauya ꞌina ꞌasaya ta ma ina gwausowala Yaubada ꞌituputupu. ");
INSERT INTO dob_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Gote ꞌena boda maiboꞌadi nuwadi ꞌiowana sinabwana, ga ma idi ꞌamayaba Yaubada situpuna, ga siona, “Niꞌa ꞌebweu ꞌebe nuwaowana taꞌitena.” ");
INSERT INTO dob_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ta muliyega Yesu ꞌiapwesa ga ꞌebweu takisi ꞌana toꞌewa ꞌana esana Libai ꞌiꞌitena ꞌina anuwa ꞌebe paisewa ꞌena ꞌimiyami ta ꞌieonena, ꞌigwae, “Libai, ꞌumuliyegu.” ");
INSERT INTO dob_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ꞌEnega Libai nina ꞌitoolo ta yage yauna ꞌipilisinedi ga Yesu ꞌimuliyena. ");
INSERT INTO dob_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ꞌEnega Libai nina ꞌemasula sinabwana Yesu manuna ꞌiguinuwena, ga boda sinabwana simai Libai ꞌina anuwaya ꞌeꞌai nina manuna, ta takisi ꞌana toꞌewao yaudi wate maꞌediyao. ");
INSERT INTO dob_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Gote ꞌena Palisiyao be ꞌidi loina ꞌana toeꞌitao silomugi Yesu ꞌina tononoyao ꞌediya, sigwae, “Toꞌase ꞌalena ga takisi ꞌana toꞌewao be wate totoꞌumalidi ꞌaina maꞌemiyao waꞌeꞌai egogona?” ");
INSERT INTO dob_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ga Yesu ꞌidi ona nina ꞌieꞌisena, ꞌigwae, “Taudi boboꞌadi geya nuwadi togileꞌoasa, ta toleꞌoasa esiya nuwanuwadi togileꞌoasa. ");
INSERT INTO dob_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ꞌAboꞌagu yamaiya nigeya topalupaludi manudi, ta esi toloegesiyao sabi lemedi, be ꞌaene nuwa ꞌebuniyega sida boboꞌana.” ");
INSERT INTO dob_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ta muliyega ꞌaidi tomotai Yesu sieonena, sigwae, “Yoni ꞌina tononoyao tuta yauna mabotanidi sisidasida Yaubada ꞌenaya, nadigega wate Palisiyao ꞌidi tononoyao ꞌidi guinuwa, ta mwaꞌadega ga ꞌenega ꞌoyo ꞌimu tononoyao nigeya sida edidigula, ta tuga siꞌeꞌa ta sinumanuma besobeso.” ");
INSERT INTO dob_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ꞌEnega Yesu ꞌigwae, “Mwaꞌadega, ꞌilobwenena be ai ꞌana toyoꞌoyao siedidigula ꞌabo toai meꞌolotona maꞌediya siegwausowala? Nai nigeya, aga? ");
INSERT INTO dob_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ta wanuwaꞌiꞌisi ꞌaene tuta ꞌimeema be toai nina ꞌipilisinedi ꞌenega esi sinuwamwau be siedidigula, ta siꞌebotana.” ");
INSERT INTO dob_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ta wate ꞌebweu onasemalimali ꞌiemwasalina ꞌediya, ꞌigwae, “Nigeya sawesawenaya ꞌoama auwaunega senasenamina taꞌewa be ꞌoama kadekadelina ꞌenaya tabwabwadae. Nigeya! Ta ꞌeguma nadigega, niꞌatu ꞌoama auwaunana tagie toꞌumaliyena, ta wate auwaunana senasenamina ꞌoama kadekadelina nigeya ꞌilobwelobwena. ");
INSERT INTO dob_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ta wate nigeya ꞌebweu yaita bwasi waiwaina nadigega oine auwauna ꞌida siwena ꞌebesiwa kadekadelidi ꞌediya, ꞌabona nai siꞌalasabudi be bwasi ta ꞌebesiwa ꞌadi mudala. ");
INSERT INTO dob_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ta esi tada siwa ꞌebesiwa auwau daisidimo ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ta ꞌabo yaita oine kadekadelina ꞌinumai ꞌiabe ꞌiona ꞌaene geya nuwana auwauna, manuna ꞌaene ‘Oine kadekadelina esiya boboꞌana wawasae.’” ");
INSERT INTO dob_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabate ꞌebweuna ꞌenaya Yesu ma ina tononoyao bagula solanega sitauya, ga ꞌina tononoyao nidi witi atuna siꞌegitagedi ga siꞌetupiyepiyedi ga siꞌenidi. ");
INSERT INTO dob_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ta ꞌaidi Palisiyao siꞌitediya, ga sigwae, “Mwaꞌadega ga ꞌenega Sabate ꞌana loina waleꞌoaleꞌoa?” ");
INSERT INTO dob_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ꞌEnega Yesu Palisiyao ꞌidi ona ꞌieꞌisena, ꞌigwae, “Buki Tabu ꞌena siꞌetoladina Debida manuna be ꞌeguma wasawai wada mwalatoni ꞌaene tauna magosenao sibotana ga ");
INSERT INTO dob_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yaubada ꞌina anuwa ꞌena ꞌilugu ta beledi etaetabuna ꞌiꞌewena ga siꞌenina. Beledi nina ma ꞌana loina ꞌaene totaliya dimo ꞌadi tagwala be sida ꞌani. Ta sibotana ꞌenega tuwa tuga siꞌenina.” ");
INSERT INTO dob_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ꞌEnega Yesu wate ꞌieonedi, ꞌigwae, “Sabate ꞌana ꞌInapwana ꞌaboꞌagu tuga.” ");
INSERT INTO dob_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta ꞌebweu wate Sabate ꞌenaya Yesu ꞌilugu ꞌebweu anuwa tapwalolo ꞌenaya ga ꞌieꞌita. Anuwa nina ꞌenaya ꞌebweu tai ꞌimiyami nimaꞌataina meyomeyona. ");
INSERT INTO dob_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ta wate ꞌaidi loina ꞌana toeꞌitao be Palisiyao simiyami, ta Yesu silomataꞌiꞌisi be ꞌabo tai nina ꞌigieboboꞌane Sabate ꞌenaya, maꞌetamo ꞌenega sida eꞌewa toloina matanaya. ");
INSERT INTO dob_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ta Yesu niꞌatu saꞌi ꞌidi nuwanuwa ꞌimwalatonina, ꞌenega tai nina ꞌieonena, ꞌigwae, “ꞌUtoolo be ꞌulagama.” Ga tai nina ꞌitoolo ga ꞌilaga. ");
INSERT INTO dob_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ꞌEnega Yesu Palisiyao magosediyao ꞌieonedi, ꞌigwae, “Gete ꞌigu enaida ꞌemiya: To guinuwa boboꞌana ꞌedaya? Sabate ꞌena talelema, nai tagie ꞌelouya? Taꞌetoseyana nai taloemwawasa?” ");
INSERT INTO dob_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Gote ꞌena maiboꞌadi ꞌidune masimasiyedi ga ꞌenega tai nina ꞌieonena, ꞌigwae, “Nimayo ꞌuyasitoto.” Ga tai nimana ꞌiyasitotona ga ꞌiboboꞌana. ");
INSERT INTO dob_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Gote ꞌena Palisiyao magosediyao ꞌigiegamwasowala ꞌaiꞌailidi ga taudimo ꞌediya sigwae, “Tai gete mwaꞌadega tagie losaꞌuꞌese?” ");
INSERT INTO dob_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tuta gote ꞌenaya Yesu ꞌituꞌe ꞌoyaya ga nada boiboi maiboꞌana Yaubada ꞌena ꞌisidasida. ");
INSERT INTO dob_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ꞌEnega tomwa ꞌiulisina ga ꞌina tononoyao ꞌibwauyedi ga ꞌediyega site tuwelo ꞌiesinuwedi ga ꞌieesedi tosimanao. ");
INSERT INTO dob_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tosimanao nidi ꞌadi esanao getedi: Saimoni, tauna wate ꞌieesena Pita, ta tasina Anidulu, ta wate Yemesa be, Yoni be, Pilipi be, Batolomiu be, ");
INSERT INTO dob_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Madiu be, Tomasi be mali Yemesa tauna Alipio natuna, ta wate mali Saimoni, tauna togewana ꞌebeloina manuna, ");
INSERT INTO dob_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","be wate Yudasa tauna Yemesa natuna, ta wate Yudasa Isikaliota, tauna maꞌetamo Yesu ꞌida telesipupuye. ");
INSERT INTO dob_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ga ꞌina tosimanao nidi ta wate ꞌana tomuliyao yaudi, maiboꞌadi maꞌenao ꞌoyega siebusima ga ꞌabatau ꞌena sitoolo. ꞌAbatau nina ꞌenaya boda sinabwana simiyami, taudi simai Yudia be Yelusalema be wate Taiya ta Saidoni senadi leꞌawidi ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Taudi simai ꞌaene Yesu ꞌina onao sida nonodi ta wate ꞌaene ꞌadi leꞌoasao ꞌida gieboboꞌanedi. Ta wate taudi yaluyaluwa biꞌi silugu ꞌediya nuwanuwadi be yaluyaluwa nidi ꞌediyega ꞌida ula apwesedi. ");
INSERT INTO dob_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Boda nidi maiboꞌadi nuwanuwadi be Yesu sida gitoo be ꞌenega ꞌadi leꞌoasa sigugumwala, manuna siꞌitena Yesu ꞌena waiwai ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ꞌEnega Yesu ꞌina tononoyao nidi ꞌiduneyedi ga ꞌieonedi, ꞌigwae, “ꞌAbo ꞌomi gomagomabesomi, wada gwausowala manuna Yaubada nimanaya wamiyami. ");
INSERT INTO dob_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ta ꞌomi ꞌabo wabotana wada gwausowala, manuna maꞌetamo gamwami ꞌipapawa. Ta wate ꞌomi ꞌabo wadedoi, wada gwausowala manuna maꞌetamo waedagi. ");
INSERT INTO dob_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ꞌAboꞌagu Tomota Natuna ta wada gwausowala ꞌeguma manugu tomota sietalauwalemi, nai siguitoyasemi, nai siloꞌaegilemi nai siꞌawa toꞌumaliyemi. ");
INSERT INTO dob_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tuta gete ꞌediya ꞌabo mwau nidi siapwesa, manudi wada gwausowala be watoolo be walausa, manuna ꞌami pali boboꞌana galewaya ꞌimiyami. Ta wada nuwaꞌiꞌisi ꞌaene gete tuga toꞌawa toꞌumali nidi tubudiyao lowa palopitao siꞌawa toꞌumaliyedi, nadigega wate ꞌomi tuta gete ꞌenaya siꞌawaꞌawa toꞌumaliyemi. ");
INSERT INTO dob_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ta ꞌabo ꞌomi niꞌatu waeesaesa nuwaꞌoleꞌolemi, manuna ꞌimi esaesa niꞌatu walobena, ta maꞌetamo nigeya. ");
INSERT INTO dob_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ta yaisigedi ꞌomi gete tuga niꞌatu gamwami ꞌipawa, maꞌetamo wada nuwamwau manuna ꞌiabe botana sinabwana waloba. Ta wate ꞌabo gete tuga waedaedagi, maꞌetamo ma imi nuwamwau wadedoi. ");
INSERT INTO dob_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ta tuta nidi ꞌediya ꞌeguma tomota yaudi siꞌawa boboꞌanemi, wada nuwaila be wada nuwamwau, manuna lowa taudi tubudiyao wate nadigega palopita kabokabo siꞌawa boboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ta eꞌita gete wada nono be ꞌami talauwalao wada obobomedi, ta taudi siguitoyasemi wada lemedi, ");
INSERT INTO dob_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ta wate taudi siꞌawaꞌawa toꞌumaliyemi wada ꞌawa obobomedi, ta taudi sietalauwalemi manudi wada sidasida be Yaubada ꞌida lemedi. ");
INSERT INTO dob_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta ꞌabo yaita ꞌaseꞌaseyo ꞌisapi, geyaꞌabo nimana ꞌueꞌisaile ta esi mali ꞌaseꞌase wate ꞌutagwale be ꞌisapi. Ta ꞌeguma yaita ꞌimu sita ꞌiꞌewena, ꞌamu ꞌoama wate ꞌuda tagwale ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ta wate ꞌeguma yaita ꞌemuya ꞌisisida ꞌebweu yage manuna, yage nina ꞌuda ꞌebwaꞌe. Ta ꞌabo yaita ꞌimu gwegwe ꞌiꞌewena ga ꞌena ꞌimiyami, geyaꞌabo manuna ꞌuonaona limalimana. ");
INSERT INTO dob_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ta ꞌabo toꞌase nuwanuwami be tomota ꞌemiya siguinuwei, ꞌomi wate nadigega ꞌediya wada guinuwaꞌesa. ");
INSERT INTO dob_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ta ꞌabo ꞌaina tomota siobobomemi be taudimo waobobomedi, nigeya ꞌebweu ꞌana boboꞌanamo ꞌemiya, manuna totoꞌumalidi wate gosediyao siobobomedi, ꞌenega taudi be ꞌomi tuga ꞌimi bubuna leleleya. ");
INSERT INTO dob_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ta wate nadigega ꞌabo ꞌaina tomota silememi be taudimo walemedi, nigeya ꞌebweu wate ꞌana boboꞌanamo ꞌemiya, manuna totoꞌumalidi wate gosediyao silemedi. Ta ꞌidi bubuna tuga nadigega ꞌomi ꞌimi bubuna. ");
INSERT INTO dob_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ta ꞌeguma oboboma waꞌebwaya taudi namo wanuwena be ꞌaene ꞌemiya sida eꞌisa limana, toꞌase guinuwa nina ꞌana boboꞌana ꞌemiya? Guinuwa nidi nadigega taudi totoꞌumalidi siguiguinuwedi gosediyao ꞌediya be ꞌaene ꞌidi ꞌebwaya nina ꞌana eꞌisa sida lobalima. ");
INSERT INTO dob_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ta ꞌomi esi ꞌilobwenemi be ꞌami talauwalao wada yaledi be wada obobomedi be wada ꞌebwaya ꞌediya, ta geyaꞌabo eꞌisa manuna wayamwayamwa. Ta maꞌetamo ꞌami eꞌisa sinabwana wada loba, be ꞌenega ꞌomi Toloetana sana natunao. Manuna tauna totoꞌumalidi ta wate tooopaꞌalao ꞌiobobomedi. ");
INSERT INTO dob_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ꞌEnega ꞌomi wate wada ꞌatenuwaꞌoleꞌole tuga, nadigega Tamami ꞌiꞌatenuwa ꞌoleꞌoleꞌesemi. ");
INSERT INTO dob_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ta geyaꞌabo tomota waꞌawaꞌawa toꞌumaliyedi ꞌabona nai Yaubada wate ꞌiꞌawa toꞌumaliyemi. Ta wate geyaꞌabo gosemiyao waeꞌewadi, be ꞌenega ꞌomi geyaꞌabo eꞌewa walobaloba. Ta esi gosemiyao ꞌidi bubuna wada nuwataudi be ꞌenega Yaubada ꞌomi ꞌimi bubuna ꞌida nuwataudi. ");
INSERT INTO dob_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ta wate ma imi ꞌatetagwala tomota wada obobomedi, be ꞌenega Yaubada ꞌida obobomemi, be ꞌina oboboma nina sinabwa wawasae ꞌemiya ꞌida ꞌetosiwa. Manuna toꞌase ꞌimi guinuwa tomota ꞌediya, Yaubada wate nadigega ꞌida guinuwa ꞌemiya.” ");
INSERT INTO dob_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ꞌEnega onasemalimali getedi ꞌiꞌebwaꞌedi, ꞌigwae, “Mwaꞌadega? Sawesawenaya be ꞌebweu tomatakebokebo gosiyana matakebokebona ꞌianugane? Nai nigeya, aga? ꞌEguma nadigega ꞌiguinuwaꞌesa ꞌiabe siteluwa nidi gaula ꞌena sibebeꞌu. ");
INSERT INTO dob_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Wate nadigega ꞌabo ꞌebweu tonono, nigeya sawesawenaya be ꞌina toeꞌita ꞌina mwalatoi ꞌimwalatoi sine. Nate namo ꞌabo ꞌina mwalatoi ꞌisinabwa ta esi ꞌenega siteluwa nidi ꞌidi mwalatoi leleleya. ");
INSERT INTO dob_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nigeya ꞌilobwelobweneyo be tasiyo manuna ꞌuona ꞌabo matanaya kaiwe senasenamina ꞌimiyami, manuna ꞌoyo wate matamuya kegabugabu ꞌimiyami ta nigeya ꞌuꞌitaꞌita. ");
INSERT INTO dob_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ꞌEnega geyaꞌabo tasiyo ꞌueonai be ꞌugwae, ‘Tasigu, ꞌilobwenegu be ꞌaene kaiwe senasenamina matamuyega yaꞌewayaule,’ manuna ꞌoyo wate kegabugabu sinabwana matamuya ꞌimiyami nigeya ꞌuꞌitaꞌita. Onaꞌaiꞌaila ꞌoyo ꞌebweu tokabo, aga? Ta esi kegabugabu matamuyega ꞌuda gimi ꞌewayaule, be ꞌenega ꞌudune ꞌaiꞌaila ta muliyega tasimuna matanega kaiwe senasenamina ꞌuꞌewayaule. ");
INSERT INTO dob_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kaiwe boboꞌana nigeya sawesawenaya be uwana toꞌumalina ꞌiuwae. Nadigega wate kaiwe toꞌumalina nigeya sawesawenaya be uwana boboꞌana ꞌiuwae. ");
INSERT INTO dob_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ꞌEnega kaiwe ꞌebweuna ꞌebweuna uwadi ꞌediyega tamwalamwalatonidi ꞌaene kaiwe nidi boboꞌadi nai toꞌumalidi. Onaꞌaiꞌaila, nigeya sawesawenaya be kwakwakwala ꞌediyega damaya uwana taloba. Wate nadigega nigeya sawesawenaya be buyubuyuwa ꞌenega sibweya uwana taloba. ");
INSERT INTO dob_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nadigega tai ꞌina bubuna, ꞌabo tai ꞌina nuwanuwa boboꞌana ꞌina bubuna maiboꞌana boboꞌana. Ta ꞌabo tai ꞌina nuwanuwa toꞌumalidi, ꞌina bubuna maiboꞌana toꞌumalina. Manuna nuwanuwao nidi toꞌase nadigega ꞌatemiya simiyami tuta yauyauna ꞌawamiyega siapweapwesa. ");
INSERT INTO dob_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ta toꞌase manuna waꞌawa ꞌInapwanaegu, ta ꞌigu ona nigeya wada ematamatanedi. ");
INSERT INTO dob_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ta ꞌabo yaita ꞌoyo ꞌumama ꞌeguya be ꞌigu ona ꞌunonodi be ꞌuguinuwedi, ꞌoyo ꞌimu bubuna nadigega ꞌebweu toꞌabi anuwa yaeꞌita ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Toꞌabi anuwa nina nugana ꞌina ꞌautui paꞌalina ꞌilobena, gulewa daisinamo ꞌenaya, ga ꞌina anuwa ꞌena ꞌiꞌabina. ꞌEnega tuta nina ꞌusana sinabwana ꞌimwaꞌuta ga muluwa ꞌidau, ꞌidau ga anuwa nina ꞌiununa ta nigeya ꞌigiegie toꞌumaliye, manuna ꞌautui boboꞌana ꞌena ꞌiꞌabi. ");
INSERT INTO dob_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ta esiya ꞌabo yaita ꞌoyo ꞌigu ona ꞌunono namo ta nigeya ꞌuematamatane, ꞌoyo tuga ꞌatuwa toꞌabi anuwa nina kaukau daisinamo ꞌena ꞌiꞌabina. Ta tuta nina muluwa ꞌiapwesa, anuwa nina ꞌiununa ga ꞌiꞌebuiyena ta ꞌieligeiya toilina.” ");
INSERT INTO dob_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ta Yesu ꞌina ona tomota ꞌediya niꞌatu ꞌigumwala, ga ꞌenega ꞌiapwesa ga ꞌitauya Kapaneumi ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ꞌAsa nina ꞌenaya, tolosaiyao taudi me Loma ꞌadi toanugana ꞌebweu, ma ina ꞌaliꞌei simiyami. Ta ꞌina ꞌaliꞌei nina ꞌioboboma ꞌaiꞌailena, ta tuta gete ꞌenaya ꞌileꞌoasa sinabwana, ta ꞌiabe ꞌimwamwawasa. ");
INSERT INTO dob_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ta toloina nina Yesu ꞌina mai alena ꞌinonona, ga me Yudia ꞌidi ꞌinapwanao ꞌaidi ꞌietunedi Yesu ꞌena, be sisisida be ꞌaene Yesu ꞌida mai, be ꞌina ꞌaliꞌei nina ꞌida gieboboꞌane. ");
INSERT INTO dob_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ta ꞌinapwanao nidi niꞌatu simai Yesu ꞌena ga siꞌawanoi, sigwae, “ꞌInapwana, nuwanuwama ꞌuma be tatatauya be gosemai ꞌina ꞌaliꞌei ꞌebweuna ꞌileꞌoasa ꞌuda gieboboꞌane, ");
INSERT INTO dob_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","manuna tauna tai boboꞌana, ta wate maiboꞌada me Yudia ꞌiobobomeda, ga ꞌida anuwa tapwalolo ꞌiꞌabina.” ");
INSERT INTO dob_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ꞌEnega Yesu ꞌitagwala ga maꞌedi sitauya. Sitauya ga sena nina selabenaya siapwesa, ga toloina nina gosenao ꞌaidi wate ꞌietunedi Yesu sabi ꞌetobode. Ta simai Yesu ꞌenaya ga sigwae, “ꞌInapwana ꞌima toanugana ꞌigwae ꞌaene ꞌoyo tai sinabwayo ꞌenega nigeya ꞌilobwelobwene be ꞌululugu ꞌina anuwaya. ");
INSERT INTO dob_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ta wate nigeya ꞌilobwelobweneyo be tauna maꞌiyayo ꞌedaya waelobaloba. Ta esi nuwanuwana ꞌaene ꞌuda onamo be ꞌenega ꞌina ꞌaliꞌei ꞌida boboꞌana. ");
INSERT INTO dob_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ta wate ꞌenana gete nadigega ꞌigwae, ‘ꞌAboꞌagu loina yamwalamwalatoni, ta ꞌagu toloinao ꞌidi ona ꞌana toematamatana, ta wate ꞌigu tolosaiyao yaloiloinedi, ta ꞌeguma ꞌebweuna yaeonai “ꞌUtauya”, ꞌitatauya tuga; ta ꞌabo ꞌebweu wate ꞌena yagwae “ꞌUmai,” wate ꞌimama, ta ꞌabo ꞌigu topaisewa ꞌebweu yaeona be yagwae, “Gete ꞌuguinuwe”, ꞌida guinuwa tuga.’” ");
INSERT INTO dob_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Gete ona nidi Yesu ꞌinonodiya ga nuwana ꞌiowana ꞌaiꞌaila, ta ꞌiasakowasi ga boda nidi simulimuliye ꞌieonedi, ꞌigwae, “Onaꞌaiꞌaila, nigeya ꞌebweu yaita wate yalobaloba me Isileli ꞌemiyega ꞌina emisa tai gete nadigega.” ");
INSERT INTO dob_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ꞌEnega toepilialeale nidi siila limana toloina nina ꞌina anuwaya, ga nada ꞌaliꞌei nina silobena, niꞌatu ꞌiboboꞌana. ");
INSERT INTO dob_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ta nigeya tuta dudulana mulinaya, Yesu ꞌitauya ꞌebweu ꞌasa ꞌenaya, ꞌana esana Neini. Ta ꞌina tononoyao be wate boda sinabwana siꞌoayabuna. ");
INSERT INTO dob_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ꞌImai ꞌasa selabenaya ga tomwawasa ma ꞌana toꞌaalao ꞌilobedi siapweapwesama ꞌasa nina ꞌenega. Tomwawasa nina kwabula natuna, ꞌebweunamo tuga. ꞌEnega kwabula nina boda sinabwana maꞌenao sitautauya sabi saꞌu ꞌaliꞌali. ");
INSERT INTO dob_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Gote ꞌena Yesu kwabula nina ꞌiꞌitena ga ꞌiꞌatenuwa ꞌoleꞌoleyena ga ꞌieonena, “Geyaꞌabo ꞌudedo.” ");
INSERT INTO dob_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ꞌEnega ꞌinao ga tomwawasa nina ꞌana wadu ꞌigitoona ta toꞌaala nidi sitoolo enono. Ga Yesu ꞌigwae, “Tubuwau, ꞌutoolo.” ");
INSERT INTO dob_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ta tubuwau nina ꞌitoolo ga ꞌiona. ꞌEnega Yesu tubuwau nina ꞌiꞌauꞌewena, ga sinana ꞌiꞌebwaꞌena. ");
INSERT INTO dob_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Gote ꞌena tomotai nidi simatauta ga Yaubada situpuna, sigwae, “Palopita sinabwana niꞌatu gete ꞌiapwesama. Gete Yaubada ꞌina ayausa ꞌaboꞌada ꞌina tomotaiyao ꞌedaya.” ");
INSERT INTO dob_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Gote ꞌena Yesu alena silelewanena Yudia maiboꞌana ta wate ꞌasa nidi selabenaya maiboꞌadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ta muliyega Yoni ꞌana tomuliyao ale gete sisimanena ꞌidi ꞌenaꞌi ꞌena. ");
INSERT INTO dob_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ꞌEnega ꞌina tononoyao ꞌeluwa ꞌibwauyedi ga ꞌieonedi, ꞌigwae, “Watauya be ꞌinapwana nina waenaide, nai tauna Toꞌetosena nina manuna yaonaona, nai mali tai wate tada yamwa?” ");
INSERT INTO dob_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ta niꞌatu simai Yesu ꞌenaya ga sieonena, sigwae, “Yoni togiebapitaiso ꞌietunema ga ꞌamai sabi enaideyo, nai ꞌoyo Toꞌetoseyana niyo, nai mali tai wate ꞌayamwa?” ");
INSERT INTO dob_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tuta gete ꞌenaya Yesu ꞌetamo tuga toleꞌoasao ꞌadi leꞌoasao, be ꞌadi muyao, be yaluyaluwa biꞌi ꞌediyega ꞌigiegie boboꞌanedi, ta wate tomatakebokebo matadi ꞌigie ꞌesasedi. ");
INSERT INTO dob_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ꞌEnega muliyega siteluwa nidi ꞌidi enaida Yesu ꞌieꞌisena, ꞌigwae, “Waila be Yoni ꞌena waemwasala yage nidi ꞌeguyega niꞌatu wanonodiya ta waꞌitedi, nate: tomatakebokebo matadi niꞌatu siꞌesasediya, tolopegoi niꞌatu siboboꞌana ga sitautauya, tolepelo bwaladi siboboꞌana limana, totenatui niꞌatu ona sinoono, tomwawasa sitoolo limana, ta wate togomabeso tetela boboꞌana niꞌatu sinonona. ");
INSERT INTO dob_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ꞌEnega watauya be Yoni waeona be geyaꞌabo manugu ꞌienuenuwanaluwa, manuna ꞌabo yaita ꞌina emisa manugu nigeya ꞌineeneta, tauna ꞌida gwausowala.” ");
INSERT INTO dob_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yoni ꞌina tononoyao nidi siila, ta Yesu ꞌilolagata ga boda ꞌediya Yoni manuna ꞌisimana, ꞌigwae, “Lowa maiboꞌami sena mwatui daitaya watauya Yoni sabi nonona, ta toꞌase nuwanuwami be ꞌaene waꞌita? Nai nuwanuwami ꞌaene ꞌebweu pwatula sinabwana yagila ꞌiniuniuye waꞌita? ");
INSERT INTO dob_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nai ꞌebweu tai ma ꞌana ꞌoama esaesa sabi ꞌitana? Nai nigeya, manuna taudi ma ꞌadi ꞌoama esaesa toloina sinabwadi ꞌidi senaya simiyami ma idi gwausowala. ");
INSERT INTO dob_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ta toꞌase sana manuna ga watauya sena mwatui daitaya? Nai wanuwena ꞌaene ꞌiabe palopita ꞌebweu waꞌita, aga? Onaꞌaiꞌaila, tai nina waꞌitenaya palopitao ꞌisinabwa sinedi. ");
INSERT INTO dob_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yoni nina manuna lowa Yaubada ꞌina ona Buki Tabu ꞌena gete nadigega ꞌigimi simanena, ꞌigwae, ‘Gete ꞌigu toepilialeale yada etune matamuya ꞌitatauya be ꞌimu ꞌeda ꞌikakali.’ ");
INSERT INTO dob_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ꞌEnega Yesu wate ꞌiona ga ꞌigwae, “Yoni tauna me baleꞌu maiboꞌadi ꞌisinabwa sinedi, ta maiboꞌadi taudi Yaubada ꞌina ꞌebeloina solanaya Yoni sisinabwa sinena.” ");
INSERT INTO dob_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ꞌEnega pwalu nidi ta wate takisi ꞌana toꞌewao Yesu ꞌina ona getedi sinonona ga Yaubada situpuna, manuna taudi lowa Yoni ꞌigie bapitaisoedi. ");
INSERT INTO dob_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ta esi Palisiyao be loina ꞌana tomwalatoiyao Yaubada ꞌina nuwanuwa siguitoyasena, ꞌenega geya nuwadi be Yoni ꞌigie bapitaisoedi. ");
INSERT INTO dob_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ꞌEnega Yesu ꞌiona, “ꞌOmi ꞌepata gete mwaꞌadega yada loesawaꞌiꞌiꞌesa ꞌimi bubuna manuna?” ");
INSERT INTO dob_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nai yada gwae, ꞌomi ꞌatuwa nadigega gogama ꞌebe gimwane solanaya siesaesasala ta gosediyao ꞌediya sibwaubwau, sigwaegwae, ‘Gosemao, mwaꞌadega saꞌi ꞌaꞌabiꞌabi sinaa ta nigeya wada lausa, ta wate ꞌaꞌewaꞌewabamu ta nigeya wada dedoi.’ ");
INSERT INTO dob_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Loesawaꞌiꞌi gete ꞌana mwalatoi ꞌaene, Yoni togiebapitaiso nina ꞌimai ga beledi nigeya ꞌiꞌeꞌai ta oine nigeya ꞌinumanuma, ta ꞌenega waona ꞌaene yaluyaluwa biꞌi Yoni ꞌigie kabaleyena? ");
INSERT INTO dob_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ta esi ꞌaboꞌagu Tomota Natuna yamai be yaꞌeꞌai ta yanumanuma, ta wate manugu walomugi, wagwaegwae, ‘Tai getei toꞌai ta tonuma diidiga, ta wate takisi ꞌana toꞌewao be ꞌaidi wate totoꞌumalidi ꞌiegosigosiyanedi.’ ");
INSERT INTO dob_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ta taudi tomwalatoi ꞌaiꞌaila maꞌetamo ꞌidi guinuwa boboꞌadi ꞌediyega mwalatoi ꞌaiꞌaila ꞌiapweapwesa.” ");
INSERT INTO dob_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ꞌEbweu tuta Palisi ꞌebweu, ꞌana esana Saimoni, Yesu ꞌibwauyena be maꞌiyana siꞌaꞌa. ꞌEnega Yesu ꞌilugu Palisi nina ꞌina anuwaya ga ꞌimiyatowa sabi ꞌeꞌai. ");
INSERT INTO dob_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ta ꞌasa gote ꞌenaya ꞌebweu waine totoꞌumalina ꞌimiyami. Waine nina niꞌatu ꞌimwalamwalatoni ꞌaene Palisi ꞌina anuwaya Yesu ꞌiꞌeꞌai. ꞌEnega bunama boboꞌana ma ꞌana atu boboꞌana wawasae ꞌimeꞌena, ");
INSERT INTO dob_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ga Yesu deinaya ꞌitoolo ga ꞌidedoi ga mataselunega Yesu ꞌaena ꞌiepwasena, ga ꞌuyaꞌuyanega ꞌaena ꞌiloꞌiꞌilidi, manuna waine nina ꞌuyaꞌuyana dudulana, ta wate Yesu ꞌaena ꞌiꞌawamuidi ga bunama nina ꞌisiwena Yesu ꞌaenaya. ");
INSERT INTO dob_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ꞌEnega Palisi nina taunamo ꞌena ꞌinuwanuwa kwaiya ꞌigwae, “Tai gete, ꞌeguma tauna palopita, ꞌida mwalatoni waine gete ꞌigitogitoona tauna totoꞌumalina.” ");
INSERT INTO dob_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ta Yesu ꞌilolagata ga ꞌigwae, “Saimoni, nuwanuwagu be ꞌebweu yage yasimane ꞌemuya.” Ga Saimoni ꞌigwae, “ꞌInapwana, to yage? ꞌUda eoneguma.” ");
INSERT INTO dob_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ꞌEnega Yesu ꞌigwae, “ꞌEbweu toesaesa ta tomota ꞌeluwa ꞌigie lowagedi, ꞌebweuna ꞌina lowaga nadigega paibi analedi kina, ta ꞌebweu nadigega pipiti kina. ");
INSERT INTO dob_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ta siteluwa nidi nigeya sawesawediya be siyoyotula, ꞌenega toesaesa nina siteluwa nidi ꞌidi lowaga ꞌinuwataudi. ꞌEnega yaenaideyo, siteluwa nidi ꞌediyega yaita ꞌidi ꞌinapwana nina ꞌilokagutokiyena?” ");
INSERT INTO dob_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ꞌEnega Saimoni Yesu ꞌina ona ꞌieꞌisena, ꞌigwae, “Nai tai nina tauna ꞌina lowaga sinabwana ꞌilokagutoki.” Ga Yesu ꞌigwae, “O, onaꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ꞌEnega ꞌisanaila waine nina ꞌenaya, ga ꞌigwae, “Saimoni, waine gete ꞌina guinuwa manugu ꞌuꞌitena, nigeya nadigega ꞌoyo. Manuna ꞌimu anuwaya yaluguma ta bwasi ꞌaegu ꞌana ꞌutu manuna nigeya ꞌuꞌebwaꞌebwaꞌegu, ta esi waine gete mataselunega ꞌaegu ꞌiꞌutudi ga ꞌuyaꞌuyanega ꞌiloꞌiꞌilidi. ");
INSERT INTO dob_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ta wate ꞌoyo aesota ꞌana ꞌawamui nigeya ꞌuguiguinuwe ꞌeguya, ta tauna esi ꞌigu maiꞌunuyega ꞌaegu ꞌiꞌawaꞌawamuidi. ");
INSERT INTO dob_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nigeya wate bunamega ꞌueoeoloigu, ta tauna esiya ꞌina bunamega ꞌaegu ꞌieoloidi. ");
INSERT INTO dob_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tauna ꞌina toꞌumalinao yaudi niꞌatu yanuwataudi, ꞌenega ꞌiobobomegu sinabwana, ta esi ꞌabo yaita ꞌina toꞌumalina gidalina be yanuwatau, ꞌina oboboma ꞌeguya wate gidalina.” ");
INSERT INTO dob_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ꞌEnega Yesu waine nina ꞌieonena, ꞌigwae, “ꞌImu toꞌumalinao niꞌatu yanuwataudi.” ");
INSERT INTO dob_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ta tomotai nidi taudi maꞌenao siꞌeꞌa, Yesu ꞌina ona sinonona ga taudimo ꞌediya silomugi, sigwae, “Yaita sana gete be ꞌaene toꞌumalinao ꞌinuwataudi?” ");
INSERT INTO dob_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ga Yesu esi waine nina ꞌena ꞌigwae, “ꞌImu emisa ꞌenega niꞌatu ꞌetoseyana ꞌulobena, ꞌenega ma imu gwausowala ꞌutauya.” ");
INSERT INTO dob_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ga muliyega Yesu ꞌitoolo ga ꞌitauya ꞌasa sinabwadi be gidalidi ꞌediya, Yaubada ꞌina loina ꞌana tetela boboꞌana sabi loguguyaena, ta ꞌina tononoyao nidi site tuwelo maꞌenao. ");
INSERT INTO dob_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ta wate ꞌaina iine maꞌediyao, nate taudi lowa ꞌediyega yaluyaluwa biꞌi Yesu ꞌiula apwesedi ta wate ꞌadi leꞌoasao ꞌigie boboꞌanedi. Iine nidi nate Meli Magidala, tauna lowa ꞌenega yaluyaluwa biꞌi sebeni Yesu ꞌiula apwesedi, ");
INSERT INTO dob_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ta wate Yoana, tauna Kusa mwanena, Kusa nina Elodi ꞌina toguinuwa, ta wate Susana be wate ꞌaidi iine maꞌediyao. Iine nidi taudi ꞌidi gwegweyega Yesu magosenao siꞌitaꞌiꞌisidi. ");
INSERT INTO dob_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tomota yaudi ꞌasa yauna ꞌediyega simai ga siegogonama Yesu ꞌenaya, ga Yesu ona semalimaliyega ꞌieꞌitedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tobagula ꞌebweu ꞌina bagulaya ꞌitauya ga witi atuna ꞌilelewanedi, ga ꞌaina atuna ꞌedaya sibeꞌu ga tomota siaebaebatudi, ta wate manuwa siꞌitedi ga simwaꞌutama ga siꞌenidi. ");
INSERT INTO dob_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ta ꞌaina atuna bwaꞌa logulegulewana ꞌenaya sibeꞌu ga sitabwa ga muliyega siꞌoapelu, manuna bwaꞌa nina nigeya gonitunamo. ");
INSERT INTO dob_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ta ꞌaina atuna kwakwakwala ꞌediya sibeꞌu ga sitabwa enoenowa ta esi kwakwakwala ꞌiewaiwai ga ꞌididi emwawasidi. ");
INSERT INTO dob_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ta ꞌaina atuna bwaꞌa boboꞌana ꞌenaya sibeꞌu ga sitabwama ga sisinabwa ga siuwa, ta ꞌediyega sesoi boboꞌana silobena, manuna atu nidi ꞌebweuna ꞌebweuna ꞌediyega analedi silobedi.” ꞌEnega Yesu boda ꞌieonedi, ꞌigwae, “ꞌEguma matenami ona gete wada nono.” ");
INSERT INTO dob_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ta muliyega ꞌina tononoyao Yesu sienaidena, sigwae, “ꞌImu ona semalimali nidi toꞌase ꞌadi mwalatoi?” ");
INSERT INTO dob_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ga tauna ꞌigwae, “ꞌOmi niꞌatu Yaubada ꞌemiya ꞌitagwala be ꞌina loina solaꞌaiꞌailidi ꞌana tomwalatoiyao, ta esi tomota yaudi onasemalimali sinono ta ꞌana nuwasabwalena nigeya, ta wate ꞌana mwalatoi siꞌebeꞌebese ta geyaꞌabo silobaloba. ");
INSERT INTO dob_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ta ona semalimali nina ꞌana liꞌama gete nadigega: Atu nina nate Yaubada ꞌina ona. ");
INSERT INTO dob_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ta atu nidi ꞌedaya sibeꞌu taudi nate tomota nidi ona sinono namo, ta Seitani ꞌimai ga ꞌatediyega ona nina ꞌiꞌewa yaulena, ꞌenega geyaꞌabo siemiemisa be ꞌaene Yaubada ꞌiꞌetoseyedi. ");
INSERT INTO dob_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ta atu nidi sibeꞌu bwaꞌa logulegulewana ꞌenaya, tomotai nidi taudi nate Yaubada ꞌina ona manuna sigwausowala, ta nigeya lamudi ꞌipaꞌapaꞌala manuna ꞌidi emisa nigeya sinabwana, be ꞌabo ꞌebetoo ꞌediya ꞌiapwesa ꞌiabe sibebeꞌu. ");
INSERT INTO dob_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ta atu nidi kwakwakwala ꞌediya sibeꞌuya tomotai nidi taudi ona nina sinono, ta ꞌidi nuwanuwa maiboꞌana ꞌitautauya esaesao be baleꞌu gwausowalinao ta wate yage yauna ꞌediya, ta ꞌenega Yaubada ꞌina ona ꞌediya nigeya uwana ꞌida apwesa. ");
INSERT INTO dob_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ta atu nidi bwaꞌa boboꞌana ꞌena sibeꞌuya, taudi nate ma idi ꞌatetagwala ona nina sinonona, ꞌenega sieꞌalamaꞌiꞌitana, ga Yaubada ꞌina ona ꞌediya ꞌiuwa ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ta Yesu wate ꞌediya ꞌigwae, “Nigeya ꞌebweu yaita mayale loeloeꞌabina ꞌisaꞌusaꞌu kwaiye ꞌule nai sita ꞌediyega, ta esi ꞌatamanaya ꞌisaꞌu be ꞌenega anuwa ꞌana tomiyanao ꞌimaedanidi. ");
INSERT INTO dob_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ꞌEnega ꞌeguma to yage ꞌatemiya wakwaiyedi, maꞌetamo maedana nina ꞌigieapwese. Ta toꞌase saꞌusaꞌukwaiyina, maꞌetamo yage nidi ꞌiloapwese ꞌatamanaya. ");
INSERT INTO dob_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ꞌEnega wanuwaꞌiꞌisi be ona waenono ꞌaiꞌaila. Manuna ꞌeguma yaita ꞌenaya Yaubada ꞌina gwegwe ꞌimiyami ꞌiabe gwegwe nina ꞌiloeposeyane. Ta yaita ꞌenaya nigeya Yaubada ꞌina gwegwe ꞌimiyami, ta taunamo ꞌinuwena ꞌaene Yaubada ꞌina gwegwe ꞌena ꞌimiyami, ꞌiabe Yaubada gwegwe nidi ꞌenega ꞌiꞌewa yauledi. ");
INSERT INTO dob_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ga muliyega Yesu sinana be tasinao simai sabi ꞌitana, ta pwalu sinabwa wawasae, ꞌenega nigeya sawesawenaya be silulugu Yesu ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ta ona namo sietunena, sigwae, “ꞌInapwana, sinayo be tasimwao waꞌita apwesa ꞌatamanaya sitootoolo, ta nuwanuwadi ꞌoyo.” ");
INSERT INTO dob_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Nigeya taudimo, ta esi ꞌeguma yaisigedi Yaubada ꞌina ona sinono be siematamatane taudi sinagwao nai tasigwao.” ");
INSERT INTO dob_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ꞌEbweu tuta Yesu ma ina tononoyao sigelu ga ꞌediya ꞌisimana, ꞌigwae, “Taabala mali esenaya.” ꞌEnega situpa, ");
INSERT INTO dob_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ga sipilipili ta Yesu ꞌiꞌenoꞌeno ga ꞌiꞌeno mwataya. ꞌEnega wediliya sinabwana ꞌitowama ga lisu sinabwana sisiwasiwa taona wagaya ta selabenaya be sidadamana. ");
INSERT INTO dob_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ꞌEnega tomotai nidi Yesu silowanowanona ga sigwae, “ꞌInapwana ꞌutoolo, ꞌiabe tadadamana!” ꞌEnega Yesu ꞌitoolo ga yagila be lisu ꞌibaꞌedi, ꞌigwae, “Walosaꞌu!” ꞌEnega silosaꞌu ga ꞌisiwalowa. ");
INSERT INTO dob_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ga Yesu ꞌina tononoyao ꞌieonedi, ꞌigwae, “Mwaꞌadega? Nai nigeya waemiemisegu, aga?” Ta taudi siomayamaya ta wate nuwadi ꞌiowana, ga taudimo ꞌediya sigwae, “To tai sana gete? Ga yagila be lisu ꞌiloinedi ga ꞌenana siematamatanena!” ");
INSERT INTO dob_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ta niꞌatu Galili mali senaya siabala ga silugu me Gelasine ꞌidi leꞌawaya. ");
INSERT INTO dob_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ꞌEnega Yesu ꞌisuya dabalaya ta ꞌebweu tomiyaꞌasa ꞌiapwesama. Tai nina lowa solanaya yaluyaluwa biꞌi silugu ga ꞌena simiyami. Ta tai nina tuta dudulana ꞌoama nigeya ꞌida ꞌotena, ta anuwa ꞌediya nigeya ꞌida miyana, ta esiya ꞌina ꞌebemiya ꞌaliꞌali duluina ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ꞌEnega tai nina Yesu ꞌiꞌitena, ga ꞌibwau ta ꞌibeꞌusana mwaꞌuta, ga ꞌibwautoila, ꞌigwae, “Yesu ye, ꞌoyo Yaubada Toꞌewaiwai sana Natuna, toꞌase ꞌutootoo be ꞌaene ꞌuguinuwe ꞌeguya? Tuwa! Geyaꞌabo ꞌuda giegie ꞌelouyaegu.” ");
INSERT INTO dob_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ona gete ꞌiꞌinanena manuna Yesu niꞌatu ꞌieonena, ꞌigwae, “Yaluyaluwa biꞌi niyo, tai gete ꞌenega ꞌuapwesama.” Ta wada nuwaꞌiꞌisi ꞌaene tai nina lowa tuta yauna yaluyaluwa nina ꞌigiegie kabaleyae, ꞌenega sigiyaina ga nimana be ꞌaena siyoniyonidi malakwa kainumu ꞌediyega, ta tuga kainumu nidi ꞌilasalasadi ta wate yaluyaluwa nina tai nina ꞌitauyena sena mwatui daitaya. ");
INSERT INTO dob_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ꞌEnega Yesu tai nina ꞌienaidena, ꞌigwae, “Mwaꞌadega ꞌamu esana?” Ga tauna ꞌigwae, “ꞌAgu esana Tomoyauyau”, manuna yaluyaluwa biꞌi yaudi niꞌatu silugu solanaya ga simiyami. ");
INSERT INTO dob_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ta yaluyaluwa nidi ꞌenadi Yesu ꞌenaya sisida waiwai sigwae, “Geyaꞌabo ꞌuulaula mwaꞌutema gaula ꞌebe esilae ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ta esi ꞌuda etunema be ꞌalulugu bawe mabodadi gotedi siduwaduwala ꞌoyaya ꞌediya.” ꞌEnega Yesu ꞌitagwala, ");
INSERT INTO dob_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ga siapwesa tai nina ꞌenega ga bawe ꞌediya silugu. Gote ꞌena bawe nidi siekabaleya ga maiboꞌadi sipili bulibuliyasu, ga babagega sibeꞌu ga olaya sidamana. ");
INSERT INTO dob_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ta bawe ꞌadi toꞌitaꞌiꞌitao bawe nidi ꞌidi esilae siꞌitena ga simatauta, ꞌenega sidena ga sitauya ꞌasaya ga ale nina toꞌase nadigega siꞌitena sisimanedi ꞌasa sinabwana be ꞌasa gidalidi tomotenidi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ꞌEnega tomotai nidi simai be ꞌaene taudi matadiyega sida ꞌita toꞌase ꞌiapwesa. ꞌEnega Yesu ꞌena simai ga tai nina siꞌitena lowa yaluyaluwa biꞌi solanaya simiyami niꞌatu ꞌiboboꞌana ga ꞌoama ꞌiꞌotena ta Yesu ꞌaena selabenaya ꞌimiyatowa. Gote ꞌena maiboꞌadi simatauta. ");
INSERT INTO dob_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ta toepilialeale nidi tomotai ꞌediya siemwasala mwaꞌadega tai nina ꞌiboboꞌanaꞌesa. ");
INSERT INTO dob_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ꞌEnega me Gelasine maiboꞌadi simatauta sinabwana ga Yesu sieꞌidiꞌidiyena be ꞌaene ꞌida ebesinedi. ꞌEnega Yesu wagaya ꞌidolo sabi gelu be sitatauya. ");
INSERT INTO dob_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ta tai nina niꞌa ꞌigie boboꞌanena Yesu ꞌena ꞌisida, ꞌigwae, “Sawesawenaya yamuliyeyo?” ꞌEnega Yesu ꞌieonena, ");
INSERT INTO dob_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nigeya. Ta esi ꞌuila be ꞌutauya ꞌasaya be toꞌase nadigega Yaubada ꞌemuya ꞌiguinuwena ꞌuda simana dadane.” ꞌEnega tai nina ꞌitauya ꞌasa nina solanega ga Yesu ꞌina guinuwa waiwaina ꞌietetela tomiyaꞌasa maiboꞌadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ta Yesu ma ina tononoyao siabala limana, ga boda sinabwana ma idi gwausowala siaesotena, manuna tauna tuga manuna siyamwayamwa. ");
INSERT INTO dob_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ꞌEnega ꞌebweu tai ꞌiluapwesama, ꞌana esana Yailo, tauna ꞌidi anuwa tapwalolo ꞌana toꞌitaꞌiꞌita. ꞌImai ga Yesu ꞌaenaya ꞌibwago sanamwaꞌuta ta ꞌigwae, “ꞌInapwana tatauya ꞌigu anuwaya, ");
INSERT INTO dob_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","be natugu ꞌileꞌoasa sinabwana ꞌugie boboꞌane. Tauna tuga ꞌebweuna namo natuguna, ꞌana yakwala tuwelo, anuwaya ꞌiꞌenoꞌeno, tuta gidalina be ꞌimwamwawasa.” ꞌEnega maꞌiyana sitauya. Ta niꞌatu Yailo maꞌiyana ꞌedaya sitautauya ta boda sinabwana simuliyedi, ta siegigigila. ");
INSERT INTO dob_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ta boda nidi soladiya ꞌebweu waine maꞌedi, ma ꞌana leꞌoasa. Leꞌoasa nina nate lalana ꞌidaudau yakwala tuwelo ꞌediya, ta tuga ꞌetamo ꞌidaudau. Tuta yauna togileꞌoasa sitootoo be ꞌaene sigie boboꞌane, ta nigeya sawesawediya. ");
INSERT INTO dob_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ꞌEnega waine nina Yesu mulinega ꞌimai ga ꞌana ꞌoama tupitupina ꞌigitoona, ga lalana ꞌina dau ꞌiyapasa manini. ");
INSERT INTO dob_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ꞌEnega Yesu ꞌilosuyaena, ꞌigwae, “Eei! Yaita ꞌigitoogu?” Ga maiboꞌadi sieyaseyaseya, ta esi Pita ꞌieonena, ꞌigwae, “ꞌInapwana, nai boda nidi siegigigila ga siesetupedi ꞌemuya.” ");
INSERT INTO dob_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ta Yesu ꞌigwae, “Nigeya! ꞌEbweu yaita nai ꞌagu ꞌoama ꞌigitoona, manuna yalotoona ꞌaene ꞌeguyega waiwai ꞌiapwesa ga togitoona nina ꞌena ꞌiabala.” ");
INSERT INTO dob_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ta waine nina ꞌimwalatonina ꞌaene Yesu niꞌatu ꞌina guinuwa ꞌisinapuna, ꞌenega ꞌimai ga ma ina dedela ꞌibeꞌu sanamwaꞌuta Yesu ꞌaenaya, ga boda matadiya ꞌina gitoona ꞌalena ꞌisimana apwesena, ꞌigwae, “ꞌInapwana, nuwanuwagu be yaboboꞌana, ꞌenega ꞌamu ꞌoama yagitoona, ga yaboboꞌana manini.” ");
INSERT INTO dob_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ta Yesu waine nina ꞌieonena, ꞌigwae, “Natugu, ꞌimu emisa ꞌenega niꞌatu ꞌuboboꞌana. ꞌUtoolo be ma imu gwausowala ꞌutatauya.” ");
INSERT INTO dob_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tuta nina Yesu ꞌionaona waine ꞌenaya Yailo anuwega ꞌina toguinuwa ꞌebweuna ale ꞌimeꞌena Yailo nina ꞌena, ꞌigwae, “ꞌEnaꞌi, natuyo niꞌatu yawasina ꞌigumwala, ta geyaꞌabo toeꞌita nina ꞌina tuta ꞌumudamudali.” ");
INSERT INTO dob_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ale gete Yesu ꞌinonona ga Yailo ꞌieonena, ꞌigwae, “Geyaꞌabo ꞌuꞌateꞌate saꞌala. Ta esi ꞌuemisegu ꞌaene natuyo ꞌiabe ꞌiboboꞌana.” ");
INSERT INTO dob_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ꞌEnega sitauya ga ꞌasaya siapwesa, ga Yesu boda maiboꞌadi ꞌiꞌetobodedi be geyaꞌabo anuwa nina ꞌena silugulugu, nate namo nuwanuwana Pita, be Yoni, be Yemesa, ta wate gwama nina tamana be sinana maꞌenao silulugu. ");
INSERT INTO dob_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ta boda anuwaya ꞌetamo tuga sidedoi ta wate siꞌewabamu gwama manuna. ꞌEnega Yesu ꞌiꞌetobodedi, ꞌigwae, “Tuwa! Dedoi walosaꞌu. Manuna gwama nigeya ꞌimwawamwawasa, ta esi ꞌiꞌeno mwataya tuga.” ");
INSERT INTO dob_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ta maiboꞌadi Yesu siedagiyena manuna simwalatonina ꞌaene gwama nina niꞌatu ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ꞌEnega Yesu gwama nimanaya ꞌigiyaina ta ꞌieonena, ꞌigwae, “Negeyo, ꞌutoolo.” ");
INSERT INTO dob_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ta gwama palupaluna yawasina ꞌiilama ga ꞌitoolo. Ga Yesu gwama nina sinana be tamana ꞌediya ꞌigwae, “Masula waꞌebwaꞌe be ꞌiꞌaꞌa.” ");
INSERT INTO dob_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Gote ꞌena tamana be sinana nuwadi ꞌiowana ꞌaiꞌaila. Ta Yesu wate ꞌiemataluwedi, ꞌigwae, “Geyaꞌabo ꞌebweu yaita ꞌena wasimasimana ꞌigu guinuwa gete manuna.” ");
INSERT INTO dob_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ta Yesu ꞌina topaisewao site tuwelo ꞌibwau egogonedima ga ꞌadi loina be waiwai ꞌiꞌebwaꞌedi be ꞌenega sawesawediya yaluyaluwa biꞌi tomota ꞌediyega sida ula apwesedi, ta wate ꞌadi leꞌoasao sida gieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ꞌEnega ꞌietunedi be ꞌaene Yaubada ꞌina etoloina tomotai ꞌediya sida loguguyae, ta wate leꞌoasao sida gieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta wate ꞌina guguya ꞌena ꞌiloinedi, ꞌigwae, “Geyaꞌabo ꞌebweu toꞌase waꞌewaꞌewa. Geyaꞌabo ꞌetoguna nai tana nai masula nai mani, nai ꞌami ꞌoama ꞌeluwena. ");
INSERT INTO dob_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ta ꞌabo to anuwa ꞌena sibwauyemi be walulugu, anuwa nina ꞌena waeꞌowaga be ꞌana laba sena nina wapilisine. ");
INSERT INTO dob_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ta ꞌeguma to ꞌasa ꞌena nigeya siꞌauꞌauꞌewami ꞌidi anuwa ꞌediya, ꞌasa nina nedilina ꞌaemiyega waloutuutu yauledi ta wapilisinedi be ꞌenega waeꞌitadi ꞌaene ꞌiabe mwau ꞌediya ꞌiapwesa.” ");
INSERT INTO dob_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ta ꞌenega tononoyao nidi sitauya ga sena maiboꞌadi ꞌediya sisakowasi ga tetela boboꞌana siloguguyaena, ta wate toleꞌoasao sena ꞌebweuna ꞌebweuna ꞌediya sigie boboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gote ꞌena Elodi, tauna Galili ꞌana toloina, yage getedi siapweapwesa aledi ꞌinonodi ga nuwana ꞌiowana sinabwana manuna ꞌaidi tomota sigwae, “Yoni togiebapitaiso ꞌaene niꞌatu mwawasega ꞌitoolo limana,” ");
INSERT INTO dob_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ta ꞌaidi sigwae, “Nigeya, Ilaitiya ꞌiapwesama,” ta wate ꞌaidi sigwae, ꞌaene “Tauna ꞌebweu palopita lowaenei ꞌimwawasa ga gete tuga ꞌitoolo limanama.” ");
INSERT INTO dob_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ꞌEnega Elodi wate ꞌigwae, “Yoni niꞌatu ꞌaboꞌagu ꞌigu loinega ga ꞌotona siꞌupwena. Ta to tai sana gete sionaonae.” Gote ꞌena Elodi ꞌitoo waiwai be ꞌaene Yesu ꞌida loba. ");
INSERT INTO dob_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ta niꞌatu Yesu ꞌina toguinuwao nidi ꞌidi sakowasiyega siilama ga ꞌidi guinuwa maiboꞌana siemwasalina Yesu ꞌenaya. Ga muliyega ꞌidi ꞌinapwana nina ꞌiꞌauꞌewedi ga maꞌenao sitauya ꞌebweu ꞌasa, ꞌana esana Beteseida ꞌenaya, be ꞌaene taudimo nada sida miyami. ");
INSERT INTO dob_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ta nigeya sawesawediya, manuna boda ale sinonona, ga wate Yesu nina simuliyena ga simai ꞌenaya. ꞌEnega Yesu ꞌediya ꞌitagwala ga Yaubada ꞌina loina manuna ꞌieꞌitedi, ta wate ꞌadi leꞌoasao ꞌigie boboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Simiyami ga sinala ꞌisuguwa, ta site tuwelo nidi simai ga Yesu sieonena, sigwae, “ꞌInapwana, boda getedi ꞌuda etunedi be siila ꞌasa selabedaya ꞌediya, be nada masula be ꞌebeꞌeno siꞌebesa, be ꞌenega ꞌediya sieyawaiꞌata. Manuna bada saꞌi sena mwatui daita.” ");
INSERT INTO dob_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ꞌEnega Yesu ꞌediya ꞌigwae, “Mwaꞌadega, ꞌomi geyaꞌabo waeꞌenidi, aga?” Ta taudi sigwae, “Mwaꞌadega sana batu ꞌaꞌeꞌaiꞌesedi? Manuna ꞌama masula nigeya yauna. Beledi nima ta iyana ꞌeluwa situpwa. Nai nuwanuwayo ꞌaene ꞌatatauya be boda nidi ꞌadi masula ꞌagimwane, aga?” ");
INSERT INTO dob_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ta boda nidi ꞌediyega tai dimo ꞌadi yau nadigega paibi tausani. ꞌEnega Yesu ꞌina tononoyao ꞌieonedi, ꞌigwae, “Tomotai nidi waweyalidi be ꞌidi boda ꞌediya wasaꞌudi, nadigega tomotai pipiti boda ꞌebweuna ꞌebweuna ꞌediya, be nadigega simiyatowaꞌesa.” ");
INSERT INTO dob_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ta ꞌina loina nina maiboꞌana nadigega siguinuwena, ga simiyatowa ꞌidi boda ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ꞌEnega Yesu beledi nima ta wate iyana ꞌeluwa ꞌiꞌewedi, ga galewaya ꞌiꞌitatuꞌe, ga masula nidi manudi ꞌiona oboboma. Ta muliyega ꞌigitomwedi ga ꞌina tononoyao ꞌiꞌebwaꞌedi be sida eguyaiye tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ꞌEnega maiboꞌadi siꞌai ga gamwadi ꞌipawa, ta masula tupwatupwadi siegogonedi, ga kodo tuwelo siloemaedi. ");
INSERT INTO dob_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ꞌEnega Yesu ma ina tononoyao sitauya, ga muliyega Yesu tebweuna ꞌimiyami, ga Yaubada ꞌena ꞌisidasida. Ta ꞌina sidasida ꞌigumwalaya ga ꞌina tononoyao ꞌienaida ꞌediya, ꞌigwae, “Mwaꞌadega tomota ꞌidi ona manugu, ꞌaene ꞌaboꞌagu yaita?” ");
INSERT INTO dob_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ta tonono nidi sigwae, “Tomota ꞌaidi siona ꞌaene ꞌoyo Yoni togiebapitaiso, ta ꞌaidi sigwae ꞌaene ꞌoyo Ilaitiya, ta ꞌaidi sigwae ꞌaene ꞌoyo ꞌebweu gimipalopita mwawasega ꞌutoolo limanama.” ");
INSERT INTO dob_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ꞌEnega wate ꞌienaidedi, ꞌigwae, “Ta ꞌomi mwaꞌadega ꞌimi nuwanuwa ꞌaene ꞌaboꞌagu yaita?” Ga Pita ꞌigwae, “ꞌOyo Toꞌetoseyana, Yaubada ꞌenega.” ");
INSERT INTO dob_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Gote ꞌena Yesu ꞌina tononoyao ꞌiloina paꞌaledi be geyaꞌabo sisimasimane tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ꞌEnega wate ꞌieonedi, ꞌigwae, “ꞌAboꞌagu Tomota Natuna be maꞌetamo ꞌelouya sinabwana yaloba. Manuna ꞌInapwanao be totaliyao sinabwadi ta wate loina ꞌana toeꞌitao ꞌiabe sieꞌidiꞌidiyegu be siloemwawasigu, ta ꞌasiyata ꞌetonina ꞌenaya Yaubada ꞌida gietoolo limagu.” ");
INSERT INTO dob_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ꞌEnega muliyega maiboꞌadi ꞌediya ꞌigwae, “ꞌEguma yaita ꞌoyo nuwanuwayo be ꞌumuliyegu, geyaꞌabo tauyo manuyo ꞌunuwanuwa. Ta esi tauyo ꞌamu kelose ꞌuꞌaali ꞌasiyata ꞌebweuna ꞌebweuna, be ꞌenega ꞌumuliyegu. ");
INSERT INTO dob_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ta ꞌeguma yaita yawasi ꞌiegagale, maꞌetamo yawasi nina ꞌiloseye. Ta ꞌeguma yaita yawasina manugu ꞌitagwale be ꞌimwamwawasa, tauna ꞌiabe yawasina boboꞌana ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ꞌEguma ꞌida esaesao sinabwa wawasae talobadi nate yage besobeso, ta esi yage sinabwana nate yawasida boboꞌana. Manuna ꞌeguma yawasida boboꞌana taloseyedi, nate mwau wawasae. ");
INSERT INTO dob_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“ꞌAboꞌagu Tomota Natuna, ta ꞌabo yaita ꞌoyo manugu ꞌuomayamaya ta wate ꞌigu eꞌita manuna ꞌuomayamaya be ꞌueyaseyaseyegu, maꞌetamo yada eyaseyaseyeyo tuta nina ꞌabo ma ꞌagu tupu yailama, ta wate Tamagu be ꞌina aniloseyao ma idi esaesa maꞌegwao. ");
INSERT INTO dob_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yaona ꞌaiꞌaila ꞌemiya ꞌaene tomota ꞌaimi geyaꞌabo wamwawamwawasa ga ꞌana laba Yaubada ꞌina loina mamata ꞌiteꞌitemiya ꞌiapwesama bemi. ");
INSERT INTO dob_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ona nidi getedi sigumwala ga nadigega wiki ꞌebweuna mulinaya, ga Pita be Yoni ta wate Yemesa Yesu ꞌiꞌauꞌewedi ga maꞌenao situꞌe ꞌebweu ꞌoya ꞌena sabi sidasida Yaubada ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ta ꞌetamo tuga Yesu ꞌisidasida ga maninina ꞌana ꞌita maiboꞌana ꞌidumaduma, ta wate ꞌana ꞌoama ꞌana ꞌita wakewakeke ꞌaiꞌailina. ");
INSERT INTO dob_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Gote ꞌena tai ꞌeluwa siapwesa, ga Yesu maꞌediya siꞌawaꞌawagwae, taudi nate Mosese be Ilaitiya. ");
INSERT INTO dob_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Taudi wate ꞌediyega maedana ꞌisaesae, ta Yesu maꞌediya sieonaona Yesu nina ꞌina mwawasa ꞌetamo Yelusalema ꞌenaya manuna. ");
INSERT INTO dob_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ta Pita magosenao niꞌatu siꞌeno mwataya, ta muliyega siꞌenotoolo, ga maedana sinabwana siꞌitena ꞌisae Yesu magosenao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ga muliyega be siteluwa nidi Yesu sipilisine, ta Pita ꞌilolagata ga ꞌigwae, “ꞌInapwana, boboꞌana ꞌeguma tai nidi siteluwa maꞌedao bada tada miyami, be ꞌenega ꞌimi yoeyoe ꞌetoi ꞌaꞌabidi, ꞌebweuna ꞌoyo manuyo, ta ꞌebweuna Mosese manuna, ta wate ꞌebweuna Ilaitiya manuna.” Nate Pita ꞌionaona besobeso tuga. ");
INSERT INTO dob_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita ꞌina ona maꞌetamo nigeya ꞌilosalosaloni, ta etanidiya pwana ꞌimwaꞌutama ga ꞌitala kabobodi, ꞌenega tonono nidi simatauta. ");
INSERT INTO dob_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ta pwana ꞌenega ꞌebweu ꞌenana sinonona, ꞌigwae, “Gete Natugu boboꞌaiꞌailina, ꞌina onao wada nonodi.” ");
INSERT INTO dob_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ta niꞌatu ꞌenana nina ꞌigumwala, ga Yesu tebweuna siꞌitena ꞌitootoolo. Tuta nina gote ꞌenaya toꞌase nadigega matadiyega siꞌitena nigeya ꞌebweu wate yaita ꞌena sisimasimane, ta sikwaiyena. ");
INSERT INTO dob_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Niꞌatu tomwa ꞌiulisina ga Yesu ma ina tononoyao ꞌoyega simwaꞌuta ꞌasaya ga boda sinabwana maꞌediyao sielobaloba. ");
INSERT INTO dob_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ta ꞌebweu tai boda nidi ꞌediyega Yesu ꞌiꞌitena ga ꞌibwau, ꞌigwae, “Toeꞌita, nuwanuwagu be natugu ꞌuda gieboboꞌane, tauna natugu ꞌebweuna namo tuga. ");
INSERT INTO dob_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ta tuta yauna ꞌabo yaluyaluwa biꞌi gwama nina ꞌigiyai, natuguna ꞌibwaubwau sinabwana ta ꞌana lobwebwai manuna ꞌitatai ta ꞌawanega busobuso siapweapwesa. Tuta yauyauna nadigega ꞌigiegie ꞌelouyae. ");
INSERT INTO dob_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ta ꞌimu tonono nidi niꞌatu yasidedi be ꞌaene yaluyaluwa biꞌi nina siula apwese, ta nigeya sawesawediya.” ");
INSERT INTO dob_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ꞌEnega Yesu ꞌediya ꞌigwae, “ꞌOmi sana mwaꞌadega? Ga debami paꞌala yaita! Nai nigeya waemiemisegu, aga? Niꞌatu ꞌimi debapaꞌala ꞌenega yaloꞌameꞌame.” ꞌEnega tai nina ꞌieonena, ꞌigwae, “Natumuna ꞌumeꞌe ꞌeguya.” ");
INSERT INTO dob_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ta niꞌatu gwama nina ꞌimai Yesu ꞌena, ga yaluyaluwa biꞌi gwama nina ꞌiula mwaꞌutena baleꞌuya ga ꞌitaiya. ꞌEnega Yesu ꞌiloina ga yaluyaluwa nina ꞌiapwesa ga gwama ꞌiboboꞌana. Ga muliyega Yesu gwama nina ꞌiꞌauꞌewena tamana ꞌena. ");
INSERT INTO dob_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tuta gote ꞌenaya tomota maiboꞌadi Yaubada ꞌina waiwai niꞌatu siꞌitenaya, ꞌenega nuwadi ꞌiowana sinabwana. Ta tomotai nidi ꞌetamo sinuwanuwa owana, ta Yesu ꞌina tononoyao ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ꞌigwae, “ꞌIgu ona gete ꞌiabe yasimane ꞌemiya wada nuwaꞌiꞌita ꞌaiꞌaili, nate Tomota Natuna ꞌiabe sisipupuye be ꞌana talauwalao ꞌediya siꞌeꞌebwayae.” ");
INSERT INTO dob_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Gote ꞌena ꞌigiekwani ꞌaiꞌailidi, ꞌenega nigeya sawesawenaya be yage gete manudi nuwadi ꞌisabwalena, ta Yesu ꞌena nigeya sienaenaida be ꞌaene ꞌida giemaedana ꞌediya, manuna simatauta. ");
INSERT INTO dob_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ꞌEnega muliyega tonono nidi siegewagewana ꞌaene yaita ꞌediyega ꞌadi toanugana. ");
INSERT INTO dob_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ta Yesu saꞌi niꞌatu ꞌidi nuwanuwa ꞌimwalatonina. ꞌEnega ꞌebweu gwama ꞌiꞌauꞌewenama ga selabenaya ꞌietoolona, ta ꞌieonedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Gwama gete waꞌita. ꞌAbo yaita ꞌoyo gwama gete nadigega manugu ꞌuobobome, ꞌoyo nate niꞌatu ꞌuobobomegu, ta wate ꞌagu Toetune nina niꞌatu ꞌuobobomena. ꞌEnega ꞌabo yaita ꞌemiyega ꞌana esana nigeya sinabwana tauna ꞌiloetana sinemi.” ");
INSERT INTO dob_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ta Yoni ꞌilolagata ga ꞌigwae, “ꞌInapwana, ꞌebweu tai ꞌaꞌitena ta ꞌamu esanega yaluyaluwa biꞌi ꞌiulaula apwesedi. ꞌEnega ꞌaꞌetobodena, manuna tai nina nigeya ꞌida boda.” ");
INSERT INTO dob_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ta Yesu ꞌigwae, “Geyaꞌabo waꞌetoꞌetobode! Manuna ꞌabo yaita tauna nigeya ꞌietaetalauwalemi, tauna ꞌami tolema.” ");
INSERT INTO dob_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Niꞌatu ꞌasiyata ꞌiloselabena be Yesu ꞌiila limana galewaya, ꞌenega ꞌina nuwanuwa ꞌisaꞌuna be ꞌaene ꞌitatauya Yelusalema. ꞌEnega ꞌitoolo ga ma ina tononoyao sitauya. ");
INSERT INTO dob_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sitautauya ta Yesu ꞌina tononoyao ꞌaidi ꞌietune nuganedi, me Samelia ꞌidi ꞌasaya, be ꞌaene ꞌebe eyawaiꞌata manudi sigibubu. ");
INSERT INTO dob_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ta esi tomiyaꞌasa nidi nigeya ꞌediya sitagwatagwala, manuna sinuwena Yesu nigeya ꞌidi ꞌasa ꞌena ꞌitautauya ta esiya ꞌitautauya Yelusalema. ");
INSERT INTO dob_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ta Yemesa be Yoni ona gete sinonona, ga Yesu ꞌena sigwae, “ꞌInapwana, mwaꞌadega? Sawesawenaya taloina be kaiwe sabesabeluluna galewega ꞌimwaꞌutama be ꞌiꞌala egumwalidi?” ");
INSERT INTO dob_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ta Yesu ꞌigwae, “Tuwa! Geyaꞌabo nadigega.” ");
INSERT INTO dob_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ga ꞌenega mali ꞌasaya silaga. ");
INSERT INTO dob_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ta niꞌatu sitautauya, ga ꞌebweu tai ꞌimai ga Yesu ꞌena ꞌigwae, “ꞌAboꞌagu nuwanuwagu be yamuliyeyo. To sena ꞌena ꞌutautauya, ꞌaboꞌagu yada muliyeyo.” ");
INSERT INTO dob_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ꞌEnega Yesu tai nina ꞌieonena, ꞌigwae, “Kedewa bomitawa ma idi gaula ta wate manuwa ma idi newa, ta ꞌaboꞌagu Tomota Natuna nigeya ꞌigu ꞌebe ꞌenomo.” ");
INSERT INTO dob_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ꞌEnega ꞌeluwena wate ꞌimai ga Yesu tai nina ꞌena ꞌigwae, “ꞌUmuliyegu.” Ta tauna ꞌiona, “ꞌInapwana, ꞌuda tagwalegu be nugana yaila be tamagu yayamwa ꞌina mwawasa manuna be yada saꞌu ꞌaliꞌaliye ta muliyega yamuliyeyo.” ");
INSERT INTO dob_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ta Yesu ꞌigwae, “Tuwa nada tamayo, ta taudi tomwawasa ꞌidi tomwawasao sida saꞌuꞌaliꞌaliyedi. Ta ꞌoyo esiya ꞌimu paisewa ꞌaene ꞌuda etosimana Yaubada ꞌina etoloina manuna.” ");
INSERT INTO dob_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ta ꞌetonina wate ꞌimai, ga ꞌigwae, “ꞌInapwana, boboꞌana be yamuliyeyo, ta ꞌuda tagwalegu be nugana yada ila be ꞌigu susuyao ꞌediya yada lokaiyoni ta muliyega yamuliyeyo.” ");
INSERT INTO dob_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ꞌEnega Yesu wate ꞌieonena, ꞌigwae, “ꞌEguma yaita ꞌoyo nuwanuwayo be ꞌupaisewa ta ma imu enuwanaluwa, nigeya ꞌilobwelobweneyo be Yaubada ꞌina ꞌebeloina manuna ꞌupaisewa.” ");
INSERT INTO dob_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tuta gete mulinaya, Yesu ꞌaina wate ꞌana tomuliyao ꞌiesinuwedi, sebeniti ꞌadi yau, ga ꞌeluwa ꞌeluwa ꞌietune nuganedi ꞌaina ꞌasa ꞌediya be toniꞌasa sigibubudi Yesu ꞌina mai ꞌediya manuna. ");
INSERT INTO dob_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ta ꞌieonedi, ꞌigwae, “Sesoi boboꞌana ta tosesoi ꞌomi puꞌepuꞌemimo, ꞌenega Tonibagula ꞌenaya wasisida be topaisewao ꞌida etunedi ꞌina bagulaya sabi sesoi. ");
INSERT INTO dob_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ta wada nuwaꞌiꞌisi ꞌaene ꞌaboꞌagu yaetuetunemi ꞌomi nadigega sipi panapanaisimi watautauya kedewa bosasa gamwagamwanidiya. ");
INSERT INTO dob_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Geyaꞌabo mani waꞌewaꞌewa, nai masula makwalisidi, nai ꞌami ꞌaelawa waꞌewaꞌewadi. Ta ꞌabo ꞌedaya watautauya geyaꞌabo tomota ꞌediya waꞌawaꞌawagwae liya. ");
INSERT INTO dob_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ta ꞌabo ꞌebweu anuwa ꞌenaya walulugu, nugana wada ona, wagwae, “Nuwasiwalowa ꞌemiya.” ");
INSERT INTO dob_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta ꞌeguma nuwasiwalowa ꞌana toguinuwao simiyami, ꞌimi oboboma ꞌediya ꞌida miyaataya. Ta ꞌeguma nigeya, oboboma nina ꞌida ila limanawa ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Ta ꞌabo anuwa nina gete ꞌenaya wamiyami, be toꞌase ꞌami masula nai ꞌami bwasi matamiya sisaꞌu, wada ꞌani, manuna topaisewao ꞌilobwenedi be ꞌadi niyaula siloba. Ta geyaꞌabo watautauya mali anuwa ꞌediya, ta esi anuwa nina ꞌena wagimilugu ꞌena tuga wada miyami. ");
INSERT INTO dob_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ta ꞌabo to ꞌasa ꞌenaya siaesotemi be ꞌediya walulugu, be toꞌase matamiya sisaꞌu apwese, wada ꞌani tuga. ");
INSERT INTO dob_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ta wate ꞌasa nina ꞌena wamiyami ꞌidi toleꞌoasao wada gieboboꞌanedi, ta wate toniꞌasao waeonadi, wagwae, ‘Yaubada ꞌina loina selabenaya be ꞌiapwesa ꞌemiya.’ ");
INSERT INTO dob_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ta ꞌabo to ꞌasa ꞌenaya waapwesa be sieꞌidiꞌidiyemi, mwaumwauya ꞌeda ꞌediya waaila ta waeonadi, wagwae, ");
INSERT INTO dob_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Waꞌita, ꞌimi ꞌasa nedilina ꞌaemega ꞌaloutuutu yaule, be wada mwalatoni ꞌaene niꞌatu Yaubada ꞌina loina selabemiya ꞌimiyami.’ ");
INSERT INTO dob_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Onaꞌaiꞌaila, maꞌetamo bwaꞌomatana ꞌana tuta ꞌenaya, taudi ꞌasa nidi siguitoyasemi loina sinabwa wawasae siloba, ta nigeya nadigega me Sodoma ꞌadi loina.” ");
INSERT INTO dob_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ꞌEnega sena nidi ꞌana tomiyanao ꞌieonedi, ꞌigwae, “Me Kolesini be me Beteseida nuwaꞌoleꞌolemi saꞌi. Manuna ꞌebe nuwaowana nidi niꞌatu yaguinuwedi ꞌemiya ta esi nigeya wanuwanuwaꞌebuni, ta esi ꞌeguma me Taiya be me Saidoni ꞌediya yada guinuwenaya nai lowaenei niꞌatu sida nuwaꞌebuni, be kumata ꞌadi ꞌoamao sida ꞌotedi be kwausa ꞌediyega sida kwausidi, be sieꞌitaedi ꞌaene ꞌidi bubuna toꞌumalina ꞌediyega niꞌatu sinuwaꞌebuni. ");
INSERT INTO dob_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ta esi ꞌomi nigeya ꞌaiꞌaila, ꞌenega bwaꞌomatana ꞌana ꞌasiyata ꞌenaya Yaubada ꞌiabe me Taiya be me Saidoni ꞌiꞌatenuwa ꞌoleꞌoleyedi, ta ꞌomi geyaꞌabo. ");
INSERT INTO dob_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ta me Kapaneumi ꞌomi mwaꞌadega, ꞌaene wagituꞌeyemi galewaya, aga? Geyaꞌabo saꞌi! Ta esi tomwawasa ꞌidi ꞌasa ꞌubuninaya sida ulamwaꞌutemi.” ");
INSERT INTO dob_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ꞌEnega ꞌana tomuliyao nidi ꞌediya ꞌigwae, “ꞌEguma yaita ꞌimi ona ꞌinonodi, nate ꞌaboꞌagu ꞌigu ona ꞌinonona. Ta ꞌabo yaita ꞌiguitoyasemi ꞌaboꞌagu wate ꞌiguitoyasegu, ta wate ꞌagu Toetune nina ꞌiguitoyasena.” ");
INSERT INTO dob_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ta niꞌatu ꞌana tomuliyao site sebeniti ꞌidi paisewega siilama ga ma idi gwausowala Yesu ꞌena siemwasala, sigwae, “ꞌInapwana, ꞌada simana ꞌemuya ꞌaene yaluyaluwa biꞌiyao niꞌatu ꞌamu esanega ꞌaloiloinedi ga siapwesa.” ");
INSERT INTO dob_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ta Yesu ꞌediya ꞌigwae, “Seitani yaꞌitena galewega ꞌimwaꞌumwaꞌuta ꞌatuwa nadigega namala ꞌina pili. ");
INSERT INTO dob_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ꞌEnega wada nuwaꞌiꞌisi ꞌaene niꞌatu yagie waiwaiyemi be ꞌenega sawesawemiya waewaiwai ꞌada talauwala nina ꞌina guinuwa maiboꞌadi ꞌediya, be ꞌenega ꞌabo mwata nai ganiyeya waayaidi, geyaꞌabo wamatamatauta manuna geyaꞌabo sigiegie toꞌumaliyemi.” ");
INSERT INTO dob_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ꞌEnega wate ꞌediya ꞌigwae, “Onaꞌaiꞌaila, ꞌimi guinuwa yaluyaluwa toꞌumalidi ꞌediya waiwaina ga manuna wagwausowala, ta nate nigeya yage sinabwana, ta esi ꞌimi ꞌebe gwausowala sinabwana ꞌeguma ꞌami esanao niꞌatu galewaya siꞌetoladidi.” ");
INSERT INTO dob_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Gote tuta nina ꞌenaya Yaluyaluwa Tabuna Yesu ꞌigiegwausowalena ga ꞌigwae, “Kagutoki Tamagu, ꞌoyo galewa be baleꞌu ꞌadi toloina, mwalatoi gete ꞌukwaiyena tosinasinapuyao be tomwalatoiyao ꞌediyega ta esi gogama gidalidi ꞌediya ꞌueꞌitaena. Onaꞌaiꞌaila Tamagu, ꞌimu nuwanuwa gete boboꞌana.” ");
INSERT INTO dob_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ꞌEnega wate ꞌigwae, “Yage yauyauna niꞌatu Tamagu nimaguya ꞌisaꞌudi, ta Tamagu tebweuna ꞌimwalatonigu, ta ꞌaboꞌagu wate Tamagu tebweugu yamwalatonina, ta wate yaisigedi taudi ꞌabo nuwanuwagu be Tamagu yaeꞌitae ꞌediya, taudi wate sida mwalatoni.” ");
INSERT INTO dob_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ꞌEnega Yesu ꞌisanaila ꞌina tononoyao ꞌediya ga ꞌieonedi, ꞌigwae, “ꞌOmi ma imi gwausowala manuna yage getedi matamiyega waꞌitaꞌita. ");
INSERT INTO dob_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Yaonaꞌaiꞌaila, lowa palopitao ta toloinao yaudi nuwanuwadi be yage getedi sida ꞌitadi, ta wate ona nidi niꞌatu wanonodi taudi nuwanuwadi be ꞌaene sinonodi, ta nigeya silobalobadi.” ");
INSERT INTO dob_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ta ꞌebweu loina ꞌana toanugana ꞌimai ga Yesu ꞌena ꞌienaida sabi toona, ꞌigwae, “ꞌInapwana toꞌase yada guinuwe be yawasigu ataya yada loba?” ");
INSERT INTO dob_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ꞌEnega Yesu ꞌigwae, “Loina nidi Mosese ꞌiꞌetoladidi Buki Tabu ꞌenaya, niꞌatu ꞌumwalatonidiya ga?” ");
INSERT INTO dob_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ga tai nina ꞌigwae, “O, loina gete nadigega, ‘ꞌImu ꞌInapwana Yaubada ꞌuda obobome ꞌateyo be yaluyaluwayo be ꞌimu waiwai be ꞌimu nuwananuwa maiboꞌadi ꞌediyega. Ta wate gosemwao ꞌuda obobomedi nadigega tauyo ꞌamu oboboma.’ ");
INSERT INTO dob_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ꞌEnega Yesu ꞌigwae, “Nate ꞌuona ꞌaiꞌaila. ꞌEnega nadigega ꞌuda guinuwaꞌesa be yawasiyo ataya ꞌuloba.” ");
INSERT INTO dob_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ta tai nina ꞌinuwena ꞌaene tauna topalupaluna, ꞌenega Yesu wate ꞌena ꞌienaida limana, “Yaita sana gosiyagu?” ");
INSERT INTO dob_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ꞌEnega Yesu onasemalimaliyega tai nina ꞌieonena, ꞌigwae, “ꞌEbweu tai Yelusalemega ꞌitoolo ga ꞌitautauya Yeliko, ta ꞌedaya toꞌipwala ꞌilobedi, ga sigiyaina. ꞌAna ꞌoamao sisabu yauyauledi ga siunu geyogeyonina ta abe ꞌimwamwawasa ga siebesinena ta sitauya. ");
INSERT INTO dob_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ꞌIꞌenoꞌeno ta ꞌebweu totaliya ꞌiapwesa, ga toesilae nina ꞌiꞌitena ga ꞌinao, ga ꞌeda tupitupinega ꞌitautauya. ");
INSERT INTO dob_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ta wate nadigega totaliyao ꞌadi tolema ꞌebweu ꞌiapwesa, ga tai nina ꞌiꞌitena, ga wate ꞌiduneyenamoya ta ꞌipilisinena. ");
INSERT INTO dob_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ta muliyega ꞌebweu goma Samelia ꞌiapwesama ga tai nina ꞌiꞌitena ta ꞌiꞌatenuwa ꞌoleꞌoleyena, ");
INSERT INTO dob_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ꞌenega selabenaya ꞌinao ga bunama be oine ꞌisaꞌu apwesedi ga ꞌana ꞌabiyama ꞌediya ꞌisiwedi ta ꞌipaimidi, ga muliyega ꞌina yobai ꞌena ꞌiusena ta maꞌiyana sitauya ꞌebweu anuwa ꞌowaga ꞌenaya ga nada ꞌiꞌitaꞌiꞌisina. ");
INSERT INTO dob_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tomwa ꞌiulisina, ga kina ꞌeluwa ꞌiꞌewedi ga anuwa nina ꞌana toꞌitaꞌiꞌita ꞌiꞌebwaꞌena, ta ꞌieonena, ‘Toesilae gete ꞌuꞌitaꞌiꞌisi manugu, ta ꞌeguma ꞌeisa wate mani ꞌusaꞌuna manuna, ꞌiabe ꞌabo yailama yayotula ꞌemuya.’ ” ");
INSERT INTO dob_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ꞌEnega Yesu tai nina ꞌienaidena, ꞌigwae, “Sitetoi nidi gete ꞌediyega yaita toesilae nina gosiyana?” ");
INSERT INTO dob_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ga tai nina ꞌigwae, “Tauna ꞌana tooboboma nina.” ꞌEnega Yesu ꞌigwae, “Nate onaꞌaiꞌaila, ꞌenega ꞌutauya be nadigega ꞌuguinuwaꞌesa.” ");
INSERT INTO dob_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ta niꞌatu Yesu ma ina tononoyao sitauya ga siapwesa ꞌebweu sena ꞌenaya, ga waine ꞌebweu, ꞌana esana Malida ꞌiꞌauꞌewena tauna ꞌina anuwaya. ");
INSERT INTO dob_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ta waine nina tasina wate ꞌimiyami, ꞌana esana Meli, ga Meli nina ꞌimai ga Yesu selabenaya ꞌimiyatowa, be ꞌina ona sabi enonoedi. ");
INSERT INTO dob_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ta Malida ꞌigimagimasula, ma ina paisewa yauna. ꞌEnega Malida ꞌimai Yesu ꞌena ga ꞌigwae, “ꞌInapwana, mwaꞌadega ga tasigu maꞌiyayo wamiyami ta nigeya ꞌida lemegu? Sawesawenaya ꞌueona be ꞌilemegu, aga?” ");
INSERT INTO dob_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ta Yesu ꞌigwae, “Malida, mwaꞌadega ga yage yaudi manudi ꞌunuwanuwa, ");
INSERT INTO dob_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ta esi ꞌebweuna namo yage sinabwana manuna ꞌuda nuwanuwa, nadigega tasiyo Meli ꞌina esinuwa. Meli nuwanuwana be ꞌigu ona ꞌida nonodi, ꞌenega geyaꞌabo ꞌebweu yaita ꞌiꞌetoꞌetobodei.” ");
INSERT INTO dob_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ꞌEbweu tuta Yesu tebweuna sena ꞌebweuna ꞌena ꞌisidasida. ꞌIna sidasida mulinaya ꞌina tononoyao sieonena, sigwae, “ꞌInapwana, sidasida ꞌueꞌitama, nadigega Yoni ꞌina tononoyao sidasida ꞌieꞌitaꞌesedi.” ");
INSERT INTO dob_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ꞌEnega Yesu ꞌediya ꞌigwae, “Gete nadigega wasidasidaꞌesa, wagwae: Tamama, ꞌamu esana ꞌaꞌamayabei, ta ꞌasideyo be ꞌoyo ꞌuda loinema. ");
INSERT INTO dob_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ꞌAma masula ꞌasiyata ꞌebweuna ꞌebweuna ꞌenaya ꞌuda ꞌebwaꞌebwaꞌema. ");
INSERT INTO dob_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ta ꞌima bubuna toꞌumalina ꞌuda nuwataudi, manuna gosemao ꞌidi toꞌumalina ꞌemaya ꞌanuwataudi. Ta esi geyaꞌabo ꞌutootooma. ");
INSERT INTO dob_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ta Yesu wate ꞌediya ꞌiona, “Sidasida nina ꞌana mwalatoi gete nadigega. ꞌEguma yaita ꞌoyo ꞌebweu ꞌamu ꞌowaga niuniuwanaya ꞌimamai ꞌemuya ta nigeya ꞌebweu toꞌase ꞌemuya be ꞌuꞌebwaꞌe ꞌina loepaꞌala manuna, ꞌenega ꞌilobweneyo be gosiyayo ꞌena ꞌutatauya be ꞌuꞌawanoi, ꞌugwae, ‘Gosiyagu, sawesawenaya ꞌulemegu be beledi ꞌetoi ꞌuꞌebwaꞌegu, ");
INSERT INTO dob_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","manuna ꞌebweu gosiyagu auwauna ꞌedasolega ꞌimai, ta nigeya ꞌebweu toꞌase ꞌeguya be ꞌenega ꞌida loepaꞌala.’ ");
INSERT INTO dob_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Be ꞌabo tai nina anuwa solanega ꞌimu ona ꞌieꞌisenawa be ꞌigwae, ‘Gosiyagu, geyaꞌabo ꞌoataꞌoata ꞌusaꞌusaꞌu, manuna manatugwao niꞌatu ꞌaꞌenoꞌeno, ta wate ꞌali yagibodena, ꞌenega nigeya sawesaweguya be yalemeyo.’ ");
INSERT INTO dob_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ta ꞌabo ꞌiegagala ꞌemuya, tuga ꞌuda gewana, be ꞌenega ꞌida ꞌenotoolo be toꞌase ꞌimu sida nadigega ꞌida ꞌebwaꞌeyo. ");
INSERT INTO dob_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ꞌEnega yaemataluwemi, wada sidasida be Yaubada ꞌida ꞌebwaꞌemi. Wate wada ꞌebesa be ꞌenega wada loba, ta wada ꞌaukeke be ꞌenega ꞌali ꞌida gigege manumi. ");
INSERT INTO dob_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Onaꞌaiꞌaila ꞌeguma tasisida, Yaubada ꞌiꞌebwaya ꞌedaya, be ꞌeguma taꞌebesa maꞌetamo taloloba, be wate ꞌeguma taꞌaukeke ꞌenega ꞌali ꞌida gigege. ");
INSERT INTO dob_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ta mwaꞌadega ꞌomi gogama tamadiyao, ꞌeguma natumiyao iyana manuna sisisida, mwata waꞌebwaꞌedi? ");
INSERT INTO dob_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Nai ꞌabo wate pou manuna sisisida, ganiyeya waꞌebwaꞌedi? Nigeya saꞌi! ");
INSERT INTO dob_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Onaꞌaiꞌaila ꞌomi totoꞌumalimi, ta ꞌimi ꞌebwaya natumiyao ꞌediya niꞌatu wamwalamwalatoni ꞌaene yage boboꞌadimo waꞌebwaꞌebwaꞌedi. Nadigega wate Tamami galewaya ꞌina ꞌebwaya ꞌemiya boboꞌana wawasae, be ꞌabo wasisida ꞌenaya Yaluyaluwa Tabuna ꞌida ꞌebwaꞌemi.” ");
INSERT INTO dob_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ta tuta nina Yesu ꞌebweu tai ꞌilobena, tauna yaluyaluwa biꞌi ꞌina guinuwega meyana ꞌilido ga nigeya ꞌida ona, ꞌenega Yesu yaluyaluwa biꞌi ꞌiula apwesena, ta ꞌenega tai nina ꞌiboboꞌana ga ꞌiona. Gote ꞌena tomota siꞌitenaya ga nuwadi ꞌiowana. ");
INSERT INTO dob_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ꞌEnega ꞌaidi sigwae, “Yaluyaluwa biꞌi ꞌidi ꞌinapwana nina, Bielisibubi, ꞌina waiwaiyega Yesu yaluyaluwa biꞌi ꞌiula apwesedi.” ");
INSERT INTO dob_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ta ꞌaidi wate Yesu sitoona be ꞌaene weꞌiweꞌiyaya ꞌebweu ꞌida guinuwe manudi, be sida ꞌawaꞌaiꞌaile ꞌaene ꞌina waiwai Yaubada ꞌenega ꞌimai. ");
INSERT INTO dob_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ta Yesu boda nidi ꞌidi nuwanuwa niꞌatu ꞌimwalatonina, ga ꞌieonedi, ꞌigwae, “Bielisibubi tauna gosenao geyaꞌabo ꞌipaꞌipaꞌidi.” Ta wate ꞌigwae, “ꞌEguma ꞌebweu ꞌebeloina ꞌenaya tomotai siweweyala be taudimo silosalosaiya, maꞌetamo ꞌebeloina nina ꞌineneta be ꞌibebeꞌu. Ta wate nadigega ꞌeguma ꞌebweu susu taudimo silosalosaiya maꞌetamo ꞌidi miya ꞌitoꞌumali. ");
INSERT INTO dob_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Seitani wate nadigega ꞌeguma ma ina bodao taudimo silosaiya, ꞌiabe ꞌina ꞌebeloina nina ꞌibebeꞌu. Ta mwaꞌadega ga waona ꞌaene Bielisibubi ꞌina waiwaiyega yaluyaluwa biꞌi yaulaula apwesedi, ");
INSERT INTO dob_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ta yaita sana ꞌina waiwaiyega ꞌomi yaluyaluwa biꞌi waula apwesedi? Bielisibubi ꞌenega, nai Yaubada ꞌenega? Gete manuna wanuwanuwa be wada mwalatoni ꞌaene yaita ꞌaboꞌagu. ");
INSERT INTO dob_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ta ꞌaboꞌagu esi Yaubada ꞌina waiwaiyega yaluyaluwa biꞌi yaula apwesedi, ꞌenega wada mwalatoni ꞌaene Yaubada ꞌina loina niꞌatu ꞌiapwesama ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Seitani nina tauna ꞌatuwa ꞌebweu tai waiwaina ta ma ina gwegwe saiya, ꞌina anuwa sinabwana ꞌiꞌitaꞌitaꞌiꞌisi be ꞌaene geyaꞌabo ꞌebweu yaita ꞌina gwegwe ꞌigiegie toꞌumaliye. ");
INSERT INTO dob_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ta ꞌabo ꞌebweu tai waiwai wawasae ꞌiapwesama, ꞌiabe tai nina ꞌipaꞌi be ꞌina gwegwe saiya nimanega ꞌiꞌewadi, ta ꞌina gwegweyao maiboꞌadi ꞌiꞌewadi be gosenao ꞌiꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ꞌEguma yaisigedi taudi nigeya ꞌagu tolemao, taudi ꞌagu talauwalao. Ta wate yaisigedi taudi nigeya maꞌegwao ꞌada paisewa egogonaya, taudi ꞌigu paisewa sigiegie toꞌumaliye. ");
INSERT INTO dob_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ta ꞌabo yaluyaluwa biꞌi tai ꞌebweuna ꞌenega ꞌiapwesa, tai ꞌida boboꞌana, ta yaluyaluwa biꞌi nina ꞌiabe tuga ꞌatamanaya ꞌiadadana besobeso be ꞌina ꞌebe eyawaiꞌata ꞌiꞌebeꞌebese, ta geyaꞌabo ꞌilobaloba. ꞌEnega yaluyaluwa nina taunamo ꞌena ꞌigwae, ‘Nai ꞌana ꞌita yaila limana ꞌigu gimi ꞌebemiya ꞌena. ");
INSERT INTO dob_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ꞌEnega ꞌiila ga ꞌebemiya nina ꞌilobena ꞌesasena ta gibugibubuna, ");
INSERT INTO dob_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ꞌenega ꞌitauya ga yaluyaluwa site sebeni toꞌumali ꞌaiꞌailidi wate ꞌiꞌauꞌewedima ga maꞌenao silugu ꞌebemiya nina ꞌenaya, ga nada maꞌenao simiyana, ꞌenega tai nina ꞌina miya sigietoꞌumali ꞌaiꞌailena, lowa nigeya nadigega. ");
INSERT INTO dob_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nadigega Yesu ꞌionaꞌesa boda ꞌediya, ta ꞌebweu waine ꞌediyega ꞌenana sinabwanega ꞌibwau ga Yesu ꞌena ꞌigwae, “ꞌInapwana, waine nina tauna gamwanega ꞌienatunemu ta wate susunega ꞌususu, tauna togwausowala ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ta Yesu wate ꞌigwae, “Taudi esi ꞌabo Yaubada ꞌina ona sinonona ga ꞌenana siematamatanena, taudi togwausowala ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ta niꞌatu boda nidi Yesu sitoolo ꞌoabuꞌoabuyena, ga ꞌilolagata ga ꞌediya ꞌigwae, “ꞌEpata gete ꞌomi toꞌumalimi! Nate ꞌalena weꞌiweꞌiyaya waꞌebeꞌebese, ta geyaꞌabo saꞌi weꞌiweꞌiyaya nidi waꞌitaꞌita. Nate namo Yona manuna wanuwaꞌiꞌisi, tauna tuga weꞌiweꞌiyaya manumi. ");
INSERT INTO dob_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Manuna Yona ꞌina guinuwa ꞌenega me Ninibe simwalatonina ꞌaene tauna Yaubada ꞌenega ꞌimai. Nadigega wate ꞌaboꞌagu Tomota Natuna ꞌigu guinuwa ꞌediyega ꞌomi ꞌepata gete wada mwalatonigu ꞌaene Yaubada ꞌenega yamai. ");
INSERT INTO dob_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Onaꞌaiꞌaila, ꞌasiyata bwaꞌomatana ꞌenaya me Siba ꞌidi kuwini ꞌida toolo be ꞌomi ꞌepata nimi gete ꞌieꞌewami, manuna waine nina ꞌedasolega ꞌimai Solomoni ꞌina ona sinasinapu sabi nonona, ta gete tuga ona sinasinapu wawasae wanonodi, ta ꞌomi geya nuwami wanonodi. ");
INSERT INTO dob_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Wate nadigega ꞌasiyata bwaꞌomatana ꞌenaya me Ninibe sida toolo be ꞌepata nimi gete sida eꞌewami manuna Yona ꞌediya ꞌiloguguya ga ꞌidi bubuna toꞌumalina ꞌediyega sisanaila, ta ꞌomi gete tuga loguguya boboꞌana wawasae niꞌatu wanonodi, ta nigeya wada sanaila. ");
INSERT INTO dob_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nigeya ꞌebweu wate yaita mayale ꞌida loeꞌabi be ꞌida saꞌukwaiye gaulaya, nai gaeba ꞌagalaunaya, ta esiya ꞌebesaꞌu etaninaya ꞌida saꞌu be ꞌenega taudi anuwa ꞌana toluguyao ꞌida maedanidi. ");
INSERT INTO dob_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Manuna matayo bwalayo ꞌana mayale nadigega, be ꞌabo matayo ꞌesasena bwalayo maiboꞌana maemaedanina. Ta ꞌabo matayo toꞌumalina bwalayo wate maiboꞌana ꞌiguguyoi. ");
INSERT INTO dob_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ꞌEnega ꞌuꞌitaꞌiꞌisiyo ꞌabona nai ꞌimu mayale ꞌiguguyoi. ");
INSERT INTO dob_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ta ꞌabo bwalayo maiboꞌana maedana ꞌena ꞌimiyami, ta nigeya ꞌebweu wate guguyoi ꞌenaya, maiboꞌana tuga maemaedanina, ꞌatuwa nadigega mayale sinabwana ꞌina maedana.” ");
INSERT INTO dob_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ta Yesu niꞌatu ꞌina ona ꞌigumwala, ga ꞌebweu Palisi Yesu ꞌibwauyena be maꞌiyana siꞌaꞌa. ꞌEnega ꞌilugu ga ꞌimiyatowa ꞌebe ꞌeꞌai ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ta Palisi nina nuwana ꞌiowana manuna Yesu ꞌiꞌitena nimana nigeya ꞌiꞌutuꞌutudi ta ꞌiꞌeꞌai. ");
INSERT INTO dob_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ta Yesu niꞌatu Palisi nina ꞌina nuwanuwa ꞌimwalatonina, ꞌenega ꞌena ꞌigwae, “ꞌOmi Palisiyao ꞌatuwa nadigega keiga be gaeba, manuna gwaumimo waꞌutuꞌutudi, ta solami ꞌimaa ꞌaiꞌaila ꞌanawala be bubuna toꞌumalidi ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Waeuwauwa! Manuna nigeya wamwalamwalatoni ꞌaene gwaumi be solami ꞌadi tobubu Yaubada, ");
INSERT INTO dob_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ta ꞌilobwenemi be ꞌatemi loꞌebwaꞌebwaya ꞌenega wada gieꞌesasadi be ꞌenega wada ꞌesasa ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ta ꞌomi Palisiyao saꞌi nuwaꞌoleꞌolemi! Onaꞌaiꞌaila ꞌimi ꞌebwayadaita boboꞌana, manuna ꞌebwayadaita nina ꞌana loina maiboꞌana waꞌitaꞌiꞌita ꞌaiꞌailina, ꞌimi gwegwe sinabwadi be gidalidi ꞌediyega tupwana Yaubada waꞌebwaꞌebwaꞌe, nadigega mali pai be mali pai ꞌediyega. Ta esiya loina ꞌeluwa sinabwadi wanuwa pupuledi, nate Yaubada ꞌana oboboma ta loina palupalu. ꞌIlobwenemi be yage gete sinabwadi wada guinuwedi, ta wate geyaꞌabo yage gidalidi wanuwanuwa pupuledi. ");
INSERT INTO dob_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ꞌOmi Palisiyao nuwaꞌoleꞌolemi, manuna anuwa tapwalolo ꞌediya nuwanuwami be ꞌaene ꞌebemiya boboꞌadi ꞌediya wada miyatowa, ta wate nuwanuwami be ꞌaene tuta nina ꞌabo watautauya ꞌasaya tomota maiboꞌadi sida ꞌamayabemi. ");
INSERT INTO dob_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Onaꞌaiꞌaila saꞌi nuwaꞌoleꞌolemi, manuna ꞌatemi ꞌatuwa nadigega ꞌaliꞌali mapwatulidi, tomota ꞌediyega sitautauya ta nigeya simwalamwalatoni ꞌaene ꞌaliꞌali.” ");
INSERT INTO dob_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ta ꞌebweuna loina ꞌana toanugana Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌimu onao gete ꞌediyega ꞌusinalima, aga?” ");
INSERT INTO dob_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ga Yesu ꞌena ꞌigwae, “ꞌOmi wate loina ꞌana toanuganao nuwaꞌoleꞌolemi, manuna tomota ꞌaaꞌaala mwaudi waꞌebwaꞌebwaꞌedi ta ꞌomi nigeya saꞌi wada tagwala be ꞌaaꞌaala nidi ꞌediyega wada lemedi. ");
INSERT INTO dob_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Nuwaꞌoleꞌolemi saꞌi, manuna wate palopita nidi tubumiyao siloemwawasidi ta ꞌomi ꞌadi ꞌaliꞌali ꞌediya ꞌadi ꞌebe nuwaꞌiꞌita waꞌabidi. ");
INSERT INTO dob_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yage gete ꞌenega tubumiyao ꞌidi loina waꞌawa boboꞌanena, be ꞌaene taudi palopitao siloemwawasidi, ta ꞌomi ꞌadi ꞌaliꞌali ꞌediya ꞌadi ꞌebe nuwaꞌiꞌita waꞌabidi. ");
INSERT INTO dob_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yage getedi manudi Yaubada ꞌina sinasinapu ꞌisaꞌuna, ꞌigwae, ‘ꞌEtamo ꞌaidi palopitao be ꞌigu tosimanao yaetunediwa, be ꞌaidi waloemwawasidi ta ꞌaidi wapaꞌidi.’ ");
INSERT INTO dob_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ꞌEnega ꞌepata getemi ꞌiabe eꞌisa maiboꞌana waloba palopitao nidi loeloemwawasidi gabula ꞌana ꞌebe eꞌale ꞌenega ga batuwa manudi, ");
INSERT INTO dob_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nate Ebeli siloemwawasina ga ꞌenega siloeloemwawasa ga ꞌana laba Sakalaya ꞌina tuta ꞌenaya siloemwawasina Anuwa Tabu ta ꞌebe taliya gamwagamwanidiya. Onaꞌaiꞌaila, loemwawasa nidi maiboꞌadi ꞌadi eꞌisa ꞌepata getemi waloba. ");
INSERT INTO dob_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ta ꞌomi loina ꞌana toanuganao saꞌi nuwaꞌoleꞌolemi, manuna sinasinapu ꞌana ꞌawa waꞌetobodena, ꞌenega ꞌomi nigeya sawesawenaya be walulugu, ta wate taudi nuwanuwadi be ꞌaene silulugu waꞌetobodedi.” ");
INSERT INTO dob_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ta niꞌatu sena nina gote Yesu ꞌipilisinena, ga muliyega loina ꞌana toeꞌitao be Palisiyao sitootoo enaida yauna ꞌediyega ");
INSERT INTO dob_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","be ꞌaene mwaꞌadega be ꞌina onagesi sida loba be ꞌenega sida eꞌewa. ");
INSERT INTO dob_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pwalu sinabwa wawasae sideli egogonama ga siegigigila, ta Yesu ꞌiona nugana ꞌina tononoyao ꞌediya, ꞌigwae, “Wada ꞌitaꞌiꞌisimi ta Palisiyao ꞌidi guinuwa kabokabo geyaꞌabo waguiguinuwedi, manuna ꞌidi guinuwa ꞌatuwa nadigega pwalawa ꞌana ꞌebe gieseseya. ꞌEbe gieseseya nina ꞌabo toꞌase nadigega gidalina ꞌiabe ꞌigiesinabwa, ");
INSERT INTO dob_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ta yage nidi kwaikwaiyidi maꞌetamo Yaubada ꞌigieapwesedi be sida matanaꞌi. ");
INSERT INTO dob_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ta wate toꞌase guguyoi ꞌena waonaena ꞌiabe ꞌasiyata ꞌediya tomota sinono. Ta toꞌase nai manuna waeꞌawa sayasaya anuwa solanaya ꞌiabe tomota maiboꞌadi ꞌediya sisimana apwesedi. ");
INSERT INTO dob_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ta gosegwao yaemataluwemi, taudi bwalami siloeloemwawasi, geyaꞌabo wamatamatautedi, manuna taudi oomi namo sawesawenaya be siloemwawasi ta yaluyaluwami geyaꞌabo. ");
INSERT INTO dob_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ta esiya Yaubada wada mataute, manuna tauna ma ina loina be ꞌiloemwawasa nuganemi, ta muliyega ꞌida ulamwaꞌutemi ꞌasa gabugabu ꞌenaya. Onaꞌaiꞌaila, Taunamo wada mataute! ");
INSERT INTO dob_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ꞌEisa nadigega bedinegwa ꞌadi maisa? Nigeya sinabwana, nadigega toea ꞌeluwa namo ta manuwa nima ꞌadi yau. Ta tuga Yaubada geyaꞌabo wate ꞌebweuna ꞌediyega ꞌinuwanuwa pupule. ");
INSERT INTO dob_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ta ꞌanabwaꞌayoi nigeya sawesawenaya be ꞌuyaꞌuya wasawa ꞌebweu deba ꞌenaya, Yaubada ꞌadi yau ꞌimwalamwalatonidi. ꞌEnega geyaꞌabo waꞌateꞌate saꞌala, manuna ꞌomi Yaubada ꞌina yage sinabwana, ta bedinegwa nigeya yage sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ta gete wate wada mwalatoi ꞌaiꞌaili: ꞌEguma yaisigedi manugu tomotai matadiya sida simana, ꞌaboꞌagu Tomota Natuna yada simana Tamagu ꞌina aniloseyao matadiya. ");
INSERT INTO dob_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ta ꞌabo yaisigedi sieyaseyaseyegu tomota matadiya, ꞌaboꞌagu wate maꞌetamo Yaubada ꞌina aniloseyao matadiya yaeyaseyaseyedi. ");
INSERT INTO dob_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ꞌAboꞌagu Tomota Natuna, be ꞌabo yaita ꞌiꞌawa toꞌumaliyegu, Yaubada ꞌiabe ona nina ꞌida nuwatau. Ta ꞌabo yaita Yaluyaluwa Tabuna ꞌiꞌawa toꞌumaliyei, geyaꞌabo saꞌi Yaubada ꞌinuwanuwatau. ");
INSERT INTO dob_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ta ꞌabo tomota siꞌauꞌewami anuwa tapwalolo ꞌediya sabi etalaemi ꞌinapwanao be toloinao matadiya, geyaꞌabo waꞌateꞌate saꞌala nai wanuwanuwa mwaꞌadega ꞌidi enaida waeꞌisaꞌesa, ");
INSERT INTO dob_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","manuna ꞌetamo tuta nina nate ꞌena Yaluyaluwa Tabuna maꞌemi, be tauna ꞌiabe ꞌieꞌitami toꞌase waonae.” ");
INSERT INTO dob_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ta boda nidi ꞌediyega ꞌebweu ꞌenana ꞌiapwesa, ꞌigwae, “Toeꞌita, tasigu ꞌuda eona be tupwana ꞌebeloina ꞌida ꞌebwaꞌegu, lowa tamamai ꞌiaseyena.” ");
INSERT INTO dob_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ta Yesu tai nina ꞌina ona ꞌieꞌisena, ꞌigwae, “Tai, ꞌaboꞌagu nigeya sawesaweguya be yaetoloina ꞌami egueguyai manuna.” ");
INSERT INTO dob_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ta wate ꞌina ona nina ꞌitubwena ga boda maiboꞌadi ꞌediya ꞌigwae, “Wada ꞌitaꞌiꞌisimi be geyaꞌabo esaesa nuwami ꞌiꞌewaꞌewa, manuna nigeya sawesawenaya be esaesa ꞌenega yawasimi boboꞌana waloba.” ");
INSERT INTO dob_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ꞌEnega ꞌebeꞌita ꞌiꞌebwaꞌedi onasemalimaliyega, ꞌigwae, “ꞌEbweu toesaesa ꞌina bagulao sinabwadi ta yaudi ga sesoi sinabwana ꞌediyega ꞌilobena. ");
INSERT INTO dob_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ꞌEnega tai nina taunamo ꞌinuwa edaedadama, ga ꞌigwae, ‘Sesoi sinabwana ta ꞌigu anuwa masula nigeya sawesawediya. ꞌEnega toꞌase yaguinuwe? ");
INSERT INTO dob_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nai gete nadigega, anuwa masula kadekadelidi yaligeya yauyauledi be auwaudi ta sinabwadi yaꞌabidi be ꞌenega masula ta wate ꞌigu gwegweyao maiboꞌadi ꞌediya yasaꞌudi, ");
INSERT INTO dob_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","be muliyega ma igu gwausowala sawesaweguya be yaona, yagwae, “ꞌEbweu toesaesa ꞌaboꞌagu. Niꞌatu yagibubuna ataya ta ꞌigu esaesao maiboꞌana sawesaweguya yakwala ꞌeisa simeemai manudi. ꞌEnega paisewa ꞌenega yada eyawaiꞌata ta esi gwausowala namo, manuna niꞌatu ꞌagu ꞌeꞌai be ꞌagu bwasi maiboꞌana sawesaweguya.” ");
INSERT INTO dob_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ta Yaubada tai nina ꞌena ꞌigwae, ‘Tai, uwauwayo! Boiboi gete yawasiyo ꞌilosaꞌu, ta gwegwe nidi ꞌusaꞌudiya, yaita sana manuna?’ ” ");
INSERT INTO dob_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ta Yesu ꞌina ona ꞌana ꞌebe losalowa ꞌena ꞌigwae, “Onaꞌaiꞌaila, ꞌeguma yaita esaesa manuna ꞌipaisewa be ꞌimiya esaesa gwegwe baleꞌuya ꞌediyega ta nigeya galewa ꞌana esaesa ꞌediyega, tauna uwauwana!” ");
INSERT INTO dob_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ꞌEnega ꞌina tononoyao ꞌediya ꞌigwae, “Geyaꞌabo ꞌimi miya baleꞌu manuna wanuwanuwa sinabwana, ꞌami ꞌeꞌai be ꞌami ꞌoama manudi. ");
INSERT INTO dob_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Manuna yawasida yage sinabwana maiboꞌada ꞌedaya, ta gwegwe nidi bwala manudi nigeya yage sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Gete ꞌebweu ꞌebeꞌita yaꞌebwaꞌemi kaokao manuna, tuta yauna nigeya sida dauna, nai sida sesoi, ta wate nigeya ꞌidi anuwa masulamo. Kaokao nidi yage gidalidi ta tuwa tuga Yaubada tuta yauna ꞌadi masula ꞌiꞌebwaꞌebwaꞌedi; ta esi wada nuwaꞌiꞌisi ꞌaene ꞌomi sinabwami Yaubada ꞌenaya, ꞌenega sawesawenaya be ꞌieꞌenimi. ");
INSERT INTO dob_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ta ꞌeisa ꞌemiyega ꞌina nuwenuwega ꞌina tuta baleꞌuya ꞌigieduduli? Nigeya, aga? ");
INSERT INTO dob_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ta onaꞌaiꞌaila, ꞌatesaꞌala nigeya wate ꞌina lema ꞌedaya yage gidalina manuna, ta toꞌase ꞌalena waꞌateꞌate saꞌala yage sinabwadi manudi. ");
INSERT INTO dob_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ta ꞌebweuna wate gete ꞌebeꞌita, seninao ꞌidi tabwa manuna wada nuwa edaedadama. Tuta yauna nigeya sida paisewa, ta wate nigeya ꞌadi ꞌoama sida guinuwedi. Ta onaꞌaiꞌaila, Solomoni ꞌana ꞌoamao be ꞌana iyaiyalao ꞌadi ꞌita boboꞌadi, ta esi senina ꞌadi ꞌita boboꞌana wawasae. ");
INSERT INTO dob_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ꞌEnega wanuwanuwa Yaubada ꞌina ꞌitaꞌiꞌita ꞌemiya manuna. Tauna pwatula ꞌieiyalidi senina boboꞌadi ꞌediyega; batuwa sisenina ta gibwaꞌi siꞌoapelu be sigabudi, ta ꞌomi pwatula waboboꞌana sinedi, ꞌenega onaꞌaiꞌaila ꞌami ꞌoamao ꞌida ꞌebwaꞌemi. ꞌEnega geyaꞌabo ꞌimi emisa Yaubada ꞌena ꞌineeneta. ");
INSERT INTO dob_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ta wate geyaꞌabo wanuwanuwa sinabwana nai waꞌateꞌate saꞌala masula be bwasi manudi. ");
INSERT INTO dob_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Me baleꞌu maiboꞌadi yage getedi manudi sinuwanuwa, ta toꞌase ꞌimi nuwanuwa Yaubada niꞌatu ꞌisinapudi, nadigega ꞌami masula be ꞌami bwasi be wate ꞌami ꞌoama. ");
INSERT INTO dob_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ta ꞌilobwenemi be nugana Yaubada ꞌina loina ꞌena wada tagwalemi, be ꞌenega ꞌami masula be ꞌami ꞌoama wate ꞌiꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ta ꞌomi onaꞌaiꞌaila Yaubada ꞌina sipiyao, ꞌenega geyaꞌabo wamatamatauta, manuna niꞌatu ꞌiesinuwemi be ꞌina ꞌebeloina ꞌena walulugu. ");
INSERT INTO dob_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“ꞌEnega ꞌimi gwegweyao wada egimwaneyedi be mani nidi wada eguyaiyedi togomabeso ꞌediya, be ꞌenega galewaya ꞌimi esaesa ꞌida miyaataya. Esaesa nina galewaya ꞌimiyami nigeya wate ꞌina ꞌebe gumwalamo, manuna nigeya ꞌebweu wate toꞌipwala sena nina ꞌena, ta wate nigeya manumanuwa. ");
INSERT INTO dob_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ta wada nuwaꞌiꞌisi to sena ꞌena ꞌimi esaesa ꞌimiyami nate ꞌena ꞌimi nuwanuwa sida pili. ");
INSERT INTO dob_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ꞌEnega wada gibubuna ꞌaiꞌaila be ꞌami ꞌoamao wada ꞌote ꞌaiꞌailidi, ta wate ma imi mayale maemaedanidi ta wayamwayamwa, ");
INSERT INTO dob_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ꞌatuwa nadigega ꞌaliꞌeiyao ꞌidi ꞌinapwana siyamwayamwai ꞌina ilama ai masulina ꞌenega manuna. Ta ꞌabo to tuta ꞌena ꞌiapwesama be ꞌawa ꞌena ꞌiꞌaukeke, palupaluna tuga ꞌawa nina sigigege be ꞌilulugu. ");
INSERT INTO dob_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ta ꞌabo matadi paꞌalina be sigibugibubudi ta siyamwayamwa be ꞌilobadi, ꞌiabe sida gwausowala sinabwana. Onaꞌaiꞌaila ꞌidi ꞌinapwana nina ꞌiabe ꞌina ꞌaliꞌeiyao nidi ꞌadi ꞌoama ꞌiꞌote, ta ꞌaliꞌeiyao nidi simiyatowa ta tauna manudi ꞌida etopaisewa. ");
INSERT INTO dob_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ta wate ꞌabo ꞌina tuta ilama ꞌenaya ꞌisoꞌisoꞌi be niuniuwanaya nai tomwa uliulitaya ꞌiapwesama be tuga nadigega ꞌidi miya nina ta ꞌilobadi, ꞌiabe wate sigwausowala sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ta wate yage ꞌebweuna gete wada nuwaꞌiꞌisi, ꞌeguma tonianuwa ꞌimwalatonina to tuta ꞌena toꞌipwala ꞌilugulugu ꞌina anuwaya, ꞌida gibubuna ꞌaiꞌaila ta ꞌida yaweyawe be geyaꞌabo ꞌina anuwa ꞌibwalebwale. ");
INSERT INTO dob_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ꞌEnega ꞌomi wate wada gibubuna ꞌaiꞌaila be ꞌigu tuta ilama manuna wada yamwagu, manuna ꞌaboꞌagu Tomota Natuna ꞌigu ilama ꞌana tuta nigeya wamwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ꞌEnega Pita ꞌigwae, “ꞌInapwana nate ꞌaboꞌama manuma ꞌuonaona, nai tomota maiboꞌadi manudi?” ");
INSERT INTO dob_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ꞌEnega Yesu ꞌigwae, “Toguinuwa boboꞌadi ta sinasinapudi ꞌidi bubuna gete nadigega, ꞌabo yaita tauna ꞌina ꞌinapwana ꞌiesinuwena be anuwa ꞌida ꞌitaꞌiꞌisi, be gosenao ꞌadi masula ꞌiꞌebwaꞌedi ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya, ");
INSERT INTO dob_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","maꞌetamo ꞌabo ꞌinapwana nina ꞌiila limanama be ꞌina toguinuwa nina ꞌilobai ꞌiguiguinuwa palupalu, ꞌiabe manuna ꞌigwausowala be ꞌena ꞌida gwae, ");
INSERT INTO dob_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","‘ꞌImu guinuwa maiboꞌana boboꞌana, ꞌenega yage maiboꞌadi ꞌadi loina yaꞌebwaꞌeyo be ꞌuloina.’ ");
INSERT INTO dob_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ta esi ꞌabo toguinuwa nina taunamo ꞌena ꞌiona, ꞌigwae, ‘ꞌIgu ꞌinapwana ꞌetamo ꞌisoꞌisoꞌi, ꞌenega taugu ꞌigu nuwanuwa yaguinuwedi.’ ꞌEnega gosenao nidi meꞌolotodi be mewainedi ꞌimutumutudi, ta wate nigeya masula ꞌida ꞌebwaꞌediya, ta taunamo ꞌiꞌeꞌai ta ꞌinumanuma, ga ꞌinuma kabaleya. ");
INSERT INTO dob_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ta muliyega ꞌabo ꞌinapwana nina ꞌiaesalutuinama, be ina ꞌaliꞌei ꞌina guinuwa toꞌumalina ꞌiꞌitalobai, ꞌiabe anuwega ꞌipaꞌi, be ꞌenega eꞌisa toꞌumalina ꞌiloba, taudi tologuitoyasa ꞌidi senaya. ");
INSERT INTO dob_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ta ꞌeguma yaita ꞌina ꞌinapwana ꞌina nuwanuwa ꞌimwalamwalatoni ta tuga nigeya ꞌiguiguinuwe, ꞌiabe loina toꞌumalina ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ta ꞌabo yaita ꞌina ꞌinapwana ꞌina nuwanuwa nigeya ꞌimwalamwalatoni, ta ꞌiguinuwa gesi, ꞌiabe ꞌana loina ꞌiloba, ta nigeya sinabwana. Ta wate nadigega ꞌabo ꞌaliꞌei ꞌana egueguyai sinabwana, ꞌilobwenena be ꞌina ꞌinapwana manuna ꞌida paisewa sinabwana; ta ꞌeguma ꞌana egueguyai sinabwa wawasae ꞌida paisewa sinabwa wawasae. ");
INSERT INTO dob_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ta ꞌaboꞌagu niꞌatu yamai ꞌaene kaiwe yamuꞌe bada baleꞌuya, ta nuwanuwagu ꞌilomanini be ꞌiꞌaꞌalata. ");
INSERT INTO dob_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ta esi tuta gidalina be bapitaiso toꞌumalina yaloba, ꞌenega ma igu ꞌatesaꞌala be ꞌana laba bapitaiso nina ꞌeguya siguinuwe. ");
INSERT INTO dob_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Ta mwaꞌadega? Nai wanuwena ꞌaene ꞌigu mai baleꞌuya ꞌenega nuwasiwalowa waloba? Nigeya saꞌi. Ta esiya ꞌiabe eꞌupwa be weyala ꞌemiya siapwesa. ");
INSERT INTO dob_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tuta nina gete ꞌediyega be tuta simeemai ꞌediya ꞌiabe susu soladiya weyala siapwesa. Susu nidi soladiya ꞌeguma nadigega tomota ꞌadi yau nima, ꞌiabe soladiyega sitetoi silosaiya siteluwa ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ta wate ꞌabo tama natuna meꞌolotona ꞌena ꞌilosaiya ꞌiabe wate natunana tamana ꞌena ꞌilosaiya. Nadigega wate sina ꞌabo ꞌilosaiya natuna mewainena ꞌena, ꞌiabe wate tauna sinana ꞌilosaiye. Ta wate ꞌabo waine ꞌilosaiya lawana mewainena ꞌenaya, ꞌiabe lawanana ꞌena ꞌieꞌupwa limana.” ");
INSERT INTO dob_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ta Yesu wate tomota nidi ꞌediya ꞌiona, “Tuta nina ꞌabo yalowa gaigaidi waꞌitadi wanuwena ꞌaene ꞌiabe ꞌiꞌuꞌusana, nate onaꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ta ꞌabo sena yalasi ꞌenega yagila ꞌitowatowama, nate ꞌenega niꞌatu wamwalamwalatoni ꞌaene selabenaya be ala ꞌiapwesa, ta toꞌase wanuwena nadigega ꞌida apwesa. ");
INSERT INTO dob_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Onaꞌaiꞌaila ꞌomi toguinuwa kabokabo, manuna baleꞌu ꞌadi weꞌiweꞌiyayao niꞌatu wasinapudi ta esi Yaubada ꞌina weꞌiweꞌiyayao nigeya wada nuwa sabwalenidi tuta auwauna gote manudi. ");
INSERT INTO dob_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ta toꞌase ꞌalena ga nigeya waesiesinuwa ꞌaiꞌaila be ꞌeda palupaluna ꞌenega watautauya? ");
INSERT INTO dob_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Ta ꞌabo ꞌamu talauwala ꞌimama be ꞌiꞌauꞌewayo sabi etalaeyo, ꞌilobwenena be tuta nina ꞌedaya watautauya ꞌutoo be toꞌumalina nina niꞌatu ꞌuguinuwena ꞌugiepaepalu, be ꞌenega geyaꞌabo ꞌamu toetala nina ꞌiꞌauꞌauꞌewayo toloina ꞌenaya, ꞌabona nai toloina nina tolosaiyao ꞌiloinedi be deliya sisaꞌuyo. ");
INSERT INTO dob_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ta geyaꞌabo saꞌi ꞌuapweapwesa be ꞌana laba ꞌimu lowaga maiboꞌana ꞌuyotula egumwalidi!” ");
INSERT INTO dob_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tuta nina ꞌenaya ꞌaidi tomota simai ga Yesu ꞌena siemwasala, me Galili manudi, sigwae, “ꞌInapwana, me Galili ꞌaidi sitalitaliya Yaubada ꞌena, ta Pailato ꞌina tolosaiyao ꞌiloinedi ga tomotai nidi siloemwawasidi.” ");
INSERT INTO dob_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ꞌEnega Yesu ꞌieonedi, “Ta wanuwena ꞌaene taudi totoꞌumalidi sinabwana, ꞌenega siloemwawasidi, aga? Nigeya! Me Galili maiboꞌadi ꞌidi toꞌumalinao tuga nadigega. ");
INSERT INTO dob_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Ta ꞌomi wate maꞌetamo wamwamwawasa ꞌatuwa taudi nadigega, ꞌabo ꞌimi bubuna toꞌumalina ꞌediyega nigeya wanuwanuwa ꞌebuni. ");
INSERT INTO dob_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Ta mwaꞌadega ꞌimi nuwanuwa taudi me Sailoma site eitini nidi manudi, tuta nina anuwa nina sinabwana ꞌibeꞌu ga ꞌiloemwawasidi, ꞌaene taudi ꞌidi bubuna toꞌumalina sinabwa wawasae me Yelusalema maiboꞌadi ꞌediyega, ga ꞌenega esilae nina silobenaya? ");
INSERT INTO dob_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nigeya saꞌi! Ta esi ꞌomi ꞌabo nigeya ꞌimi bubunao ꞌediyega wanuwanuwa ꞌebuni, maꞌetamo wamwamwawasa site eitini nidi nadigega.” ");
INSERT INTO dob_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ga muliyega ꞌebweu wate onasemalimali ꞌiꞌebwaꞌedi, ꞌigwae, “ꞌEbweu tai ꞌina bagulaya kaiwe ꞌatuwa damaya ꞌiasona. Ta tuta yauna ꞌimeemai kaiwe nina ꞌenaya be uwana sabi gitagana, ta nigeya ꞌebweu tuta uwana ꞌida lobena. ");
INSERT INTO dob_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ꞌEnega ꞌina bagula nina ꞌana toꞌitaꞌiꞌita ꞌieonena, ꞌigwae, ‘Niꞌatu ꞌumwalamwalatoni ꞌaene yakwala ꞌetoi ꞌediya yameemai bada damaya nina uwana sabi gitagana, ta uwana nigeya ꞌebweu yada lobena. Gete tuga ꞌutala yaulei, manuna bwaꞌa boboꞌana ꞌimudamudali.’ ");
INSERT INTO dob_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ta toꞌitaꞌiꞌita nina ꞌina ꞌinapwana ꞌieonena, ꞌigwae, ‘ꞌEnaꞌi ye, tuwa! Geyaꞌabo yatalatala yaulei, ta esi ꞌina toꞌumalina yalobai ta egabu ꞌena yasaꞌu be mali yakwala ꞌena taꞌita, ");
INSERT INTO dob_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","be ꞌabo ꞌiuwa, tuwa tuga ꞌitootoolo, ta ꞌabo nigeya uwanamo, ꞌenega ꞌutala yaule.’” ");
INSERT INTO dob_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ꞌEbweu Sabate ꞌenaya Yesu anuwa tapwalolo ꞌena ꞌilugu ga ꞌieꞌieꞌita. ");
INSERT INTO dob_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ta ꞌebweu waine ꞌimiyami, ta yakwala eitini solanaya yaluyaluwa biꞌi ꞌenaya ꞌimiyami, ꞌenega ꞌileꞌoasa, ta ꞌina tauya tuga ꞌiaꞌopuꞌopumo, ta nigeya sawesawenaya ꞌinuwayata be ꞌitauya palupalu. ");
INSERT INTO dob_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ta tuta nina Yesu waine nina ꞌiꞌitena ga ꞌibwauyena, “Waine ꞌumai.” ꞌImai ga ꞌieonena, “Kaiyale, ꞌamu leꞌoasa niꞌatu ꞌigumwala.” ");
INSERT INTO dob_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ꞌEnega nimana ꞌisaꞌuna waine nina ꞌenaya ga ꞌenega ꞌinuwayata ga Yaubada ꞌitupuna. ");
INSERT INTO dob_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Gote ꞌena anuwa tapwalolo nina ꞌana toꞌitaꞌiꞌita Yesu ꞌina guinuwa ꞌiꞌitena, ga ꞌigamwasowala manuna Sabateya leꞌoasa ꞌigie boboꞌanena, ꞌenega tai nina ꞌilolagata boda ꞌediya ꞌisimana, ꞌigwae, “Onaꞌaiꞌaila, loina tamwalamwalatoni ꞌaene ꞌasiyata sikisi ꞌediya ꞌida guinuwao taguinuwedi. Gete nigeya ꞌana ꞌita boboꞌana be Sabateya toleꞌoasao simeema be ꞌadi leꞌoasao sabi gieboboꞌanedi.” ");
INSERT INTO dob_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ta Yesu niꞌatu ꞌinonona, ga maiboꞌadi ꞌediya ꞌigwae, “Kabokabomi, manuna ꞌomi ꞌimi bubuna Sabate ꞌebweuna ꞌebweuna ꞌediya ꞌimi yobaiyao maiboꞌadi ꞌadi ꞌaliyega waliꞌaliꞌamidi ta siapweapwesa ꞌatamanaya ꞌadi bwasi sabi numa. ");
INSERT INTO dob_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ta mwaꞌadega waine nina wanuwena ꞌaene nigeya sawesawenaya be ꞌina miyamwau ꞌenega yaliꞌami be ꞌetoseyana ꞌiloba, nadigega ꞌimi yobaiyao nidi. Manuna waine gete Ebelaamo ꞌina boda ꞌebweu, ta esi Seitani yakwala eitini ꞌediya ꞌigiyaina.” ");
INSERT INTO dob_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu ꞌina ona gete ꞌenega tolomugi nidi ꞌigie omayamayaedi, ta esi tomota yau wawasae sigwausowala sinabwana Yesu ꞌina guinuwa waiwaidi manudi. ");
INSERT INTO dob_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ꞌEnega boda nidi ꞌediya wate ꞌigwae, “Mwaꞌadega Yaubada ꞌina etoloina yada giemaedanaꞌese ꞌemiya. Nai gete nadigega ꞌebweu kaiwe ꞌenega yada loesawaꞌiꞌi. ");
INSERT INTO dob_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tai ꞌebweuna beno atuna ꞌiꞌewena ga ꞌatamanaya ꞌiasona, ta ꞌitabwa ga ꞌisinabwa, ta muliyega manuwa simai ga ꞌidi newa nalinao nidi ꞌediya siꞌabidi.” ");
INSERT INTO dob_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ꞌEnega wate ꞌieona limedi, ꞌigwae, “Onasemalimali gete, mwaꞌadega yada giemaedanaꞌese be ꞌenega Yaubada ꞌina etoloina wada mwalatoni? ");
INSERT INTO dob_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nai gete nadigega: Waine ꞌebweu pwalawa ꞌana ꞌebe gieseseya gidalina tuga ꞌiꞌewena ga pwalawa sinabwana maꞌiyana ꞌiꞌeinisina, ꞌenega pwalawa maiboꞌana ꞌiseseya.” ");
INSERT INTO dob_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tuta nina Yesu ꞌitautauya Yelusalema, ga ꞌedaya ꞌaina ꞌasa sinabwadi be gidalidi ꞌediya ꞌiapwesa, ga ꞌediya ꞌieꞌieꞌita ta ꞌiloguloguguya. ");
INSERT INTO dob_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ꞌEnega ꞌebweu tai Yesu ꞌienaidena, ꞌigwae, “ꞌInapwana, mwaꞌadega? Nai ꞌiabe tomota puꞌepuꞌedimo ꞌetoseyana siloba, aga?” Ga Yesu ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“O nadigega, ta esi wada toowaiwai be walulugu ꞌawa nina gidalina ꞌenega. Manuna yaudi sitoo be ꞌaene silulugu ta sisoꞌiyoge. ");
INSERT INTO dob_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ta ꞌiabe wate tonianuwa nina ꞌawa ꞌigibode, be ꞌomi ꞌatamanaya watootoolo, ta ꞌali nina ꞌena waꞌauꞌaukeke, be wasisida, wagwae, ‘ꞌInapwana, ꞌali ꞌugigege be ꞌaluguwa.’ Ta ꞌiabe ꞌinapwana nina ꞌimi ona ꞌieꞌisa be ꞌemiya ꞌigwae, ‘Mane ꞌenega wamai? Nigeya yamwalamwalatonimi.’ ");
INSERT INTO dob_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Be ꞌenega ꞌomi waeꞌisa be wagwae, ‘ꞌAboꞌama lowa maꞌemwao taꞌeꞌai, tanumanuma, ta wate ꞌima ꞌasaya ꞌemaya ꞌueꞌieꞌita.’ ");
INSERT INTO dob_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ta ꞌenega ꞌiabe ꞌInapwana nina ꞌieonami be ꞌida gwae, ‘Onaꞌaiꞌaila, nigeya yamwalamwalatonimi. Mane ꞌenega wamai? Waila ta geyaꞌabo waluguluguma, manuna ꞌomi totoꞌumalimi.’ ");
INSERT INTO dob_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Be ꞌenega ꞌetamo ꞌabo Ebelaamo be Aisake be Yekobe be wate palopitao maiboꞌadi maꞌediyao waꞌitadi Yaubada ꞌina ꞌebeloina ꞌena simiyami ta ꞌomi ma imi dedoi ta ma imi esalaꞌiꞌita tuta nina ꞌena ꞌabo ꞌetauluya wamiyami. ");
INSERT INTO dob_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ta sena maiboꞌana ꞌediyega tomota simama be ꞌidi ꞌebemiya boboꞌadi siꞌewadi Yaubada ꞌina ꞌebeloina ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ꞌEnega ꞌabo yaisigedi gete tuga sinuganugana maꞌetamo sida muliya, ta yaisigedi taudi gete tuga simulimuliya maꞌetamo sida nugana.” ");
INSERT INTO dob_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tuta gote ꞌena ꞌaidi Palisiyao simai ga Yesu sieonena, sigwae, “Gete tuga ꞌulomanini be ꞌudedena, ꞌabona nai Elodi ꞌiloemwawasiyo!” ");
INSERT INTO dob_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ꞌEnega Yesu ꞌediya ꞌiona, “Watauya be bosasa nina waeona ꞌaene gete tuga yaluyaluwa biꞌi tomota ꞌediyega yaula apwesedi, ta toleꞌoasao yagie boboꞌanedi, ta wate gibwaꞌi nadigega, be elaya ꞌigu guinuwa maiboꞌana yalosaloni. ");
INSERT INTO dob_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Ta ꞌaboꞌagu ꞌetamo yatautauya Yelusalema, batuwa be gibwaꞌi be elaya yaapwesa, be nada yamwamwawasa, manuna palopitao maiboꞌama ꞌima ꞌebe mwawasa Yelusalema.” ꞌEnega Yesu nuwana ꞌimwau ga Yelusalema manuna ꞌidedoi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yelusalema ye, mwaꞌadega ga palopitao ꞌuloemwawasidi, ta wate Yaubada ꞌina toepilialealeyao gulewega ꞌuloibweibwedi? Tuta yauna nuwanuwagu be ꞌimu tomotaiyao yabwau egogonedima ꞌatuwa kakaleko natunao papenega ꞌiꞌaubodebodedi, ta saꞌi siguitoyasegu! ");
INSERT INTO dob_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ꞌEnega Yaubada ꞌiabe ꞌipilisineyo, ta yaeonayo ꞌaene geyaꞌabo wate ꞌuꞌitaꞌita limagu be ꞌana laba ꞌimu tomotaiyao sitatagwala ꞌeguya be sida gwae, ‘Tauna Yaubada ꞌana esanega ꞌimeemai tada tupu.’ ");
INSERT INTO dob_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabate ꞌebweuna ꞌenaya Yesu ꞌitauya sabi ꞌeꞌai Palisiyao ꞌidi ꞌinapwana ꞌebweu ꞌina anuwaya. Anuwa nina ꞌena ꞌilugulugu ta boda siduneduneye, ");
INSERT INTO dob_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","manuna sena nina ꞌenaya ꞌebweu toleꞌoasa ꞌimiyami, bwalana maiboꞌana siꞌeloseseya. ");
INSERT INTO dob_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ꞌEnega Yesu toleꞌoasa nina manuna ꞌienaida loina ꞌana tosinasinapuyao be Palisiyao ꞌediya, ꞌigwae, “Mwaꞌadega? Wanuwena ꞌaene boboꞌana ꞌabo toleꞌoasa ꞌasiyata Sabate ꞌenaya tagieboboꞌane, nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ga ꞌina ona nina nigeya sieꞌieꞌisa, ga muliyega Yesu toleꞌoasa nina nimana ꞌigiyaina, ga ꞌana leꞌoasa ꞌigie boboꞌanena. ꞌEnega ꞌietunena ga ꞌitauya ꞌina ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ꞌEnega Yesu ꞌiasakowasi ꞌediya ga ꞌigwae, “ꞌAbo yaisigei ꞌomi ma imi yobaiyao nadigega ase be bulumakau ta ꞌebweuna yobai nina ꞌasiyata Sabate ꞌena ꞌibebeꞌu gaulaya, mwaꞌadega, ꞌilobwenena be walisi tuꞌeyei?” ");
INSERT INTO dob_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ta taudi tuga nigeya ꞌebweu wate ꞌidi eꞌisamo. ");
INSERT INTO dob_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ꞌEꞌai nina solanaya Yesu tomota ꞌaidi ꞌiꞌitedi, ꞌebemiya boboꞌana ꞌena simiyatowa, ꞌenega ꞌebweu onasemalimali ꞌiꞌebwaꞌedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ꞌAbo yaita ꞌina anuwaya ꞌibwauyeyo ai sagalina manuna, geyaꞌabo toai ꞌatainaya ꞌumiyamiyatowa, manuna nai ꞌebweu tai sinabwana ꞌeguma ꞌimama, ");
INSERT INTO dob_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","tonisagali nina ꞌieonayo be ꞌutatauya tupitupiya, ta ꞌimu ꞌebemiya nina ꞌenaya tai auwauna nina ꞌida miyatowa. Ta ꞌoyo ꞌiabe ma imu omayamaya tupiya ꞌuaila. ");
INSERT INTO dob_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ꞌEnega ꞌabo sibwauyeyo be ꞌululugu ꞌediya, ꞌebemiya tupiya ꞌuesinuwe be ꞌena ꞌumiyatowa, be ꞌenega tuta nina ꞌabo tonisagali ꞌimama be ꞌiꞌitayo ꞌiabe ꞌemuya ꞌida ona, ꞌigwae, ‘Gosiyagu, ꞌumiyalaga gamwagamwanaya,’ be ꞌenega ꞌulalaga ma imu gwausowala, ta wate ma ꞌamu tupu tomota matadiya. ");
INSERT INTO dob_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gete ꞌenega tamwalatoni ꞌaene yaita tauna ꞌigituꞌeye ꞌetamo ꞌiebusi; ta ꞌabo yaita tauna ꞌigimwaꞌute ꞌiabe ꞌitutuꞌe.” ");
INSERT INTO dob_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ꞌEnega Yesu Palisi nina ꞌibwauyena ga ꞌena ꞌigwae, “ꞌAbo ꞌemasula nai ꞌeꞌai gidalina ꞌuguinuwe, geyaꞌabo gosemwao nai tasimwao nai ꞌimu buꞌunao nai toesaesao ꞌubwaubwauyedi ꞌeꞌai nina ꞌenaya, manuna taudi maꞌetamo sibwauyeyo sabi eꞌisa ꞌemuya. ");
INSERT INTO dob_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ta esiya ꞌabo ꞌemasula ꞌuguinuwe, taudi gomagomabesodi be bwalobwalogodi be tolopegoi be wate tomatakebokebo ꞌuda bwauyedi, ");
INSERT INTO dob_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","be ꞌenega ꞌawaboboꞌana ꞌaiꞌaila ꞌuloba, manuna gete taudi nigeya sawesawediya be ꞌimu oboboma nina sieꞌisa. Ta esi Yaubada ꞌenega ꞌamu eꞌisa ꞌuda loba, tuta nina ꞌabo toboboꞌadi mwawasega ꞌigietoolodi.” ");
INSERT INTO dob_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ga niꞌatu maꞌenao siꞌeꞌai ta ꞌebweuna ꞌediyega ona gete ꞌinonona ga Yesu ꞌieonena, ꞌigwae, “O nadigega! ꞌAbo yaisigedi silulugu Yaubada ꞌina ꞌebeloina ꞌenaya be siꞌaꞌa, sida gwausowala sinabwana.” ");
INSERT INTO dob_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ꞌEnega Yesu tai nina ꞌina ona ꞌieꞌisena, ꞌigwae, “ꞌEbweu tai ꞌemasula sinabwana ꞌiguinuwena ga tomotai yaudi ꞌibwauyedi. ");
INSERT INTO dob_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ta niꞌatu masula ꞌigibubuna ga ꞌina ꞌaliꞌei ꞌietunena tomotai nidi ꞌediya ga ꞌieonedi, ‘Niꞌatu masula sigibubuna, ꞌenega wamai be tatatauya be ꞌeꞌai nina wada ꞌai.’ ");
INSERT INTO dob_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ta maiboꞌadi geya nuwadi, ꞌenega mali ona be mali ona siꞌebwaꞌena. ꞌEbweuna ꞌigwae, ‘Niꞌatu tanowa auwauna yagimwanena, ꞌenega nai yatatauya be yayausi. Ta kagutoki sinabwana, nai geyaꞌabo yaweewa.’ ");
INSERT INTO dob_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta ꞌebweuna wate ꞌigwae, ‘Kagutoki sinabwana, nai ꞌaboꞌagu wate geyaꞌabo yaweewa, manuna bulumakau sanau ta wate ꞌebe gesowa nima niꞌatu yagimwanedi, ꞌenega yatautauya be ꞌaene yada eguinuwaedi, be yada epaisewa toodi.’ ");
INSERT INTO dob_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta wate ꞌebweu ꞌigwae, ‘ꞌAboꞌagu auwaugu yaai, ꞌenega nai geyaꞌabo yaweewai.’ ");
INSERT INTO dob_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“ꞌEnega ꞌaliꞌei nina ꞌiila ga ꞌina ꞌinapwana ꞌenaya ꞌisimana, ꞌigwae, ‘Maiboꞌadi geya nuwadi.’ Ga tonianuwa nina ꞌigamwasowala, ꞌenega ꞌina ꞌaliꞌei nina ꞌena ꞌiona, ‘ꞌUtauya manini ꞌasa sinabwana ꞌedanao maiboꞌadi ꞌediya be ꞌeguma ꞌeisa tomotai ꞌulobadi, ꞌanabwaꞌayoi nanaewadi nai nenetadi nai matakebokebodi nai bwalobwalogodi, tuga maiboꞌadi ꞌuꞌauꞌewedima be sida ꞌa.’ ");
INSERT INTO dob_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ga ꞌaliꞌei nina ꞌiguinuwa nadigega, ta muliyega ꞌimai ga ꞌiona, ‘Niꞌatu tomota nidi yabwauyedima ta esi ꞌimu anuwa nina nigeya siloeloemaa.’ ");
INSERT INTO dob_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ꞌEnega ꞌinapwana nina wate ꞌigwae, ‘ꞌEda maiboꞌadi ꞌediya ꞌuda tauya be tomotai ꞌueonadi be simama, be ꞌenega ꞌigu anuwa sida loemaa. ");
INSERT INTO dob_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ta esi tomotai nidi yagimi bwauyedi geyaꞌabo ꞌebweu ꞌediyega ꞌagu masula ꞌilotolotoo.’” ");
INSERT INTO dob_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ta niꞌatu pwalu sinabwadi maꞌenao sitautauya, ga ꞌenega Yesu ꞌisanaila ga boda nidi ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yaita ꞌabo nuwanuwana be ꞌimuliyegu, nugana ꞌida yalaꞌaiꞌailigu ta tamana be sinana be mwanena be natunao be tasinao be nuunao ta wate tauna tuga manuna ꞌida guitoyasedi. Ta ꞌeguma nigeya, tauna nigeya ꞌagu tomuliya. ");
INSERT INTO dob_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ta ꞌabo yaita yawasina nigeya ꞌitagwatagwalei be ꞌimwamwawasa kelose ꞌenaya nadigega ꞌaboꞌagu, tauna nigeya sawesawenaya be ꞌimuliyegu. ");
INSERT INTO dob_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nadigega tuga ꞌabo yaita nuwanuwana be anuwa sinabwana ꞌiꞌabi, nugana yage maiboꞌadi ꞌida gibubudi ꞌabi nina manuna, ");
INSERT INTO dob_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ꞌabona nai ꞌola namo ꞌietoolodi be geyaꞌabo anuwa maiboꞌana ꞌilosalosaloni. Gete ꞌenega ꞌiabe tomota siꞌita be tai nina situyeye ");
INSERT INTO dob_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","be sida gwae, ‘Tai gete ꞌatuwa waiwaina ga ꞌola ꞌietoolodi ta nigeya anuwa nina maiboꞌana ꞌiꞌabiꞌabi.’ ");
INSERT INTO dob_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ta wate ꞌeguma ꞌebweu kini niꞌatu ma ina tolosaiyao teni tausani sitautauya sabi losaiya wate mali kini ma ina bodao tuweniti tausani ꞌadi yau ꞌediya, mwaꞌadega kini nina ꞌiabe ꞌinuwanuwaꞌesa? Nai nugana ꞌida miyatowa ta ꞌida nuwanuwa be ꞌaene sawesawediya siewaiwai ꞌadi talauwalao nidi ꞌediya, nai nigeya? ");
INSERT INTO dob_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ta ꞌeguma nigeya, ꞌina toepilialealeyao nidi ꞌietuetunedi be sipilipili bodedi, ꞌabo mali kini nina ma ina boda ꞌetamo ꞌedasolaya simiyami, be ꞌenega maꞌediyao sida eonaona nuwasiwalowa manuna.” ");
INSERT INTO dob_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ꞌEnega Yesu ꞌina emataluwa ꞌilosalonina, ga ꞌediya ꞌigwae, “Gete nadigega wate ꞌagu muliya ꞌana ꞌeda. ꞌEguma yaita ꞌoyo nuwanuwayo be ꞌumuliyegu, nugana ꞌimu ꞌebeloina maiboꞌana ꞌuda pilisinedi. ");
INSERT INTO dob_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ola yage boboꞌana. Ta ꞌeguma ꞌina waiwai ꞌigugumwala, nigeya sawesawenaya be ꞌiboboꞌana limana. ");
INSERT INTO dob_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nigeya wate ꞌilobwelobwene be bwaꞌa ꞌigieboboꞌane, ta esi tada guitoyase namo. “ꞌEguma matenami ona gete wada nono.” ");
INSERT INTO dob_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ꞌEbweu tuta takisi ꞌana toꞌewao ta wate ꞌaidi totoꞌumalidi simai Yesu sabi enonoena. ");
INSERT INTO dob_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ꞌEnega Palisiyao be loina ꞌana toeꞌitao silomugi, sigwae, “Tai gete totoꞌumalidi ꞌiegosigosiyanedi ta wate maꞌenao siꞌeꞌai.” ");
INSERT INTO dob_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ꞌEnega ꞌidi ona nina Yesu ꞌieꞌisena onasemalimaliyega, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mwaꞌadega ꞌabo ꞌebweu ꞌemiyega ꞌina sipi ꞌadi yau analedi, ta ꞌebweuna ꞌikwakwani, sawesawenaya be nainiti naini nidi mitawaya ꞌiebesinedi be sipi nina loseloseyena ꞌida ꞌebese ꞌana laba ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta ꞌabo ꞌilobai ꞌiabe ma ina gwausowala ꞌaalanaya ꞌisaꞌui be ꞌiila ꞌasaya, ");
INSERT INTO dob_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","be ꞌenega gosenao ꞌibwau egogonedi be ꞌieonadi, ꞌigwae, ‘Sipi nina loseloseyena niꞌatu yalobena, ꞌenega manuna tada egwausowala.’ ");
INSERT INTO dob_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ꞌEnega nadigega wate ꞌabo ꞌebweu totoꞌumalina ꞌinuwaꞌebuni, me galewa manuna sida gwausowala sinabwana, ta esi toboboꞌadi site nainiti naini nidi manudi ꞌidi gwausowala tupwana namo. ");
INSERT INTO dob_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nadigega ꞌabo wate waine nina ꞌina kina ꞌadi yau sanau ta ꞌebweuna ꞌiloseye, ꞌenega toꞌase ꞌida guinuwe be kina nina ꞌiloba? Nai mayale ꞌiloeꞌabi be anuwa maiboꞌana ꞌisiyayoni be ꞌiꞌebese ꞌaiꞌaila ꞌana laba ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ta ꞌabo ꞌilobai gosenao ꞌibwau egogonedima be ꞌediya ꞌigwae, ‘ꞌIgu kina nina yaloseyenaya niꞌatu yalobena, ꞌenega manuna tada egwausowala.’ ");
INSERT INTO dob_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nadigega wate ꞌabo ꞌebweu totoꞌumalina ꞌinuwaꞌebuni, ꞌiabe Yaubada ꞌina aniloseyao manuna sigwausowala sinabwana.” ");
INSERT INTO dob_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ta Yesu wate ꞌiona semalimaliyedi, ꞌigwae, “ꞌEbweu ꞌinapwana natunao meꞌolotodi ꞌeluwa maꞌenao simiyami, ");
INSERT INTO dob_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ga megwamana tamana ꞌieonena, ꞌigwae, ‘Tamagu, nuwanuwagu be gete tuga ꞌagu egueguyai ꞌuda ꞌebwaꞌegu.’ ꞌEnega ꞌinapwana nina gwegwe maiboꞌana ꞌieguyaiyena natunao nidi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ꞌEnega ꞌasiyata ꞌaina sigumwala ga megwamana nina ꞌina gwegwe ꞌiegimwaneyedi, ga ꞌana eꞌisa mani ꞌiꞌewena, ꞌenega sena nina ꞌipilisinena, ga sena ꞌedasolaya ꞌitauya ga nada gwausowala besobesoega ꞌina mani ꞌiloegumwalina. ");
INSERT INTO dob_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Ta niꞌatu ꞌina mani maiboꞌana ꞌigumwala ga kakaena ꞌimiyami, ga tuta gote ꞌenaya botana sinabwana sena nina ꞌena ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ꞌEnega tai nina ꞌina paisewa ꞌiꞌebesa ga ꞌebweu ꞌasa ꞌana ꞌinapwana ꞌilobena, ga ꞌietunena be ꞌina baweyao ꞌiꞌitaꞌiꞌisidi. ");
INSERT INTO dob_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ta tai nina nuwanuwana be bawe ꞌadi masulega ꞌida ꞌa, manuna nigeya ꞌana masulamo. ");
INSERT INTO dob_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tuta gote ꞌenaya nuwana ꞌisabwalena, ga taunamo ꞌena ꞌigwae, ‘Onaꞌaiꞌaila, tamagu ꞌina topaisewao ma ꞌadi masula sinabwana, ta ꞌaboꞌagu bada saꞌi botana ꞌiunuunugu. ");
INSERT INTO dob_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ꞌEnega yatoolo be yatatauya tamagu ꞌena be ꞌena yada gwae, “Tamagu, niꞌatu yatoꞌumalina Yaubada ꞌenaya ta wate ꞌoyo ꞌemuya. ");
INSERT INTO dob_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ꞌEnega nigeya ꞌilobwelobwenegu be ꞌuda ꞌawanatunegu, ta esi ꞌuda eesegu ꞌimu ꞌaliꞌei ꞌatuwa.” ’ ");
INSERT INTO dob_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Gete nadigega ꞌinuwanuwaꞌesa, ga ꞌenega ꞌitoolo ga tamana manuna ꞌitauya, ga ꞌedasolega tamana ꞌiꞌitenama ꞌimeema ga ma ina ꞌatenuwaꞌoleꞌole ꞌipili ꞌenaya ga ꞌiatubwalina ga maꞌiyana siededoi. ");
INSERT INTO dob_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“ꞌEnega natunana tamana ꞌieonena, ꞌigwae, ‘Tamagu, niꞌatu yatoꞌumalina Yaubada ꞌenaya ta wate ꞌoyo ꞌemuya, ꞌenega nigeya ꞌilobwelobwenegu be ꞌuꞌawa natunegu.’ ");
INSERT INTO dob_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ta esi tamanana ꞌina ꞌaliꞌeiyao ꞌibwauyedi ga ꞌediya ꞌigwae, ‘Walomanini be ꞌoama boboꞌaiꞌailina wameꞌe be natugu waeꞌote, ta wate nimapasapasa wameꞌe be nimanaya wasaꞌu, ta wate ꞌaelawa ꞌaenaya wasaꞌu, ");
INSERT INTO dob_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","be muliyega watatauya be bulumakau mwaneyauna ta momonanina waununama be masula sinabwana taguinuwe, be ꞌenega ma ida gwausowala tauna maꞌedai tada ꞌemasula. ");
INSERT INTO dob_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Manuna natugu gete lowa ꞌimwawasaya, ta batuwa mayawasina taloba limena.’ ꞌEnega sieꞌale be silosagali ma idi gwausowala. ");
INSERT INTO dob_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ta saꞌi natuna mesinabwana ꞌetamo bagulaya ꞌipaipaisewa, ta tuta nina ꞌasa selabenaya ꞌilogelogedo, wali be lausa ꞌinonodi. ");
INSERT INTO dob_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ꞌEnega ꞌebweu ꞌidi ꞌaliꞌei ꞌibwauyena ga ꞌienaidena, ꞌigwae, ‘Toꞌase ꞌalena ꞌenega siegwaegwausowala?’ ");
INSERT INTO dob_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ta ꞌaliꞌei nina ꞌigwae, ‘Tasiyo niꞌatu ꞌiilama ga tamayo bulumakau mwaneyauna ta momonanina ꞌiununa ga maꞌemai ꞌaegwaegwausowala, manuna natunana ma ina boboꞌana ꞌiloba limena.’ ");
INSERT INTO dob_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ona gete ꞌinonona ga ꞌigamwasowala sinabwana, ꞌenega geya nuwana be anuwaya ꞌilulugu. “ꞌEnega tamana ꞌiapwesa ga natunana mesinabwana ꞌieonena ꞌaene maꞌiyana sida lugu anuwaya. ");
INSERT INTO dob_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ta esi tai nina ꞌiguitoyasa, manuna ꞌigamwasowala sinabwana, ꞌenega tamana ꞌena ꞌigwae, ‘Tamagu, ꞌeisa yakwala ꞌediya niꞌatu manuyo yapaipaisewa ga ꞌimu eyowanao maiboꞌadi yaguinuwedi, ta nigeya ꞌebweu tuta ꞌuda obobomegu. Nigeya ꞌebweu wate yobai ꞌuꞌebwaꞌebwaꞌegu be magosegwao ꞌada gimasula be ꞌada egwausowala. Nigeya ꞌaiꞌaila! ");
INSERT INTO dob_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ta natumuna gete ꞌimu gwegwe maiboꞌana ꞌimudalidi tosogala ꞌediya, ta toꞌase manuna ꞌuobobomena, ga bulumakau mwaneyauna ta momonanina ꞌuununa manuna?’ ");
INSERT INTO dob_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ta ꞌenega ꞌinapwana nina natuna ꞌena ꞌigwae, ‘Natugu, ꞌuda mwalatoni ꞌaene ꞌoyo tuta maiboꞌana selabeguya ꞌumiyami, ga toꞌase nadigega ꞌigu ꞌebeloinao, maiboꞌana nimamuya simiyami, ");
INSERT INTO dob_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ta esi tasiyo gete ꞌimwawasaya, ta gete tuga mayawasina taloba limena, ꞌenega ꞌilobweneda be batuwa maꞌedai tada egwausowala.’ (v 33) Tetela gete ꞌenega Yesu Palisiyao be loina ꞌana toeꞌitao ꞌiona semalimaliyedi. ");
INSERT INTO dob_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu wate onasemalimali ꞌebweuna ꞌina tononoyao ꞌiꞌebwaꞌedi, ꞌigwae, “Toesaesa ꞌebweuna ma ina toꞌitaꞌiꞌita ꞌina gwegweyao manudi maꞌiyana simiyami. Ga ꞌebweu tuta ꞌena ꞌaina tomota ale simeꞌena ꞌinapwana nina ꞌenaya, sigwae, ‘ꞌInapwana, ꞌimu toꞌitaꞌiꞌita nina ꞌimu gwegweyao ꞌediyega ꞌiguiguinuwa besobeso.’ ");
INSERT INTO dob_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ꞌEnega toesaesa nina ꞌina toꞌitaꞌiꞌita ꞌibwauyenama ga ꞌieonena, ꞌigwae, ‘ꞌAina simana toꞌumalina manuyo yanonona, ꞌenega gete tuga ꞌigu gwegwe ꞌadi pwepwaiyao ꞌuꞌebwaya limagu ta ꞌeguyega ꞌuda apwesa.’ ");
INSERT INTO dob_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“ꞌEnega toꞌitaꞌiꞌita nina ꞌinuwanuwa, ꞌigwae, ‘Mwaꞌadega batu yaguinuwaꞌesa, manuna niꞌatu ꞌigu ꞌinapwana ꞌieꞌidiꞌidiyegu? Manuna nigeya kapekapeyana be yababagula, ta wate omayamaya ꞌabo yatautauya tomota ꞌediya be masula manuna yaesidasida.’ ");
INSERT INTO dob_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ꞌInuwanuwa ga ꞌebweu ꞌeda ꞌinuwalobena, ꞌigwae, ‘O, gete nadigega yaguinuwaꞌesa be ꞌenega gosegwao yaudi yalobadi, ꞌabo paisewa gete ꞌenega yaapwesa.’ ");
INSERT INTO dob_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ꞌEnega toꞌitaꞌiꞌita nina tolowagao maiboꞌadi ꞌibwauyedi, ga ꞌebweuna ꞌebweuna ꞌediya ꞌienaida. Gimitai ꞌena ꞌigwae, ‘ꞌEisa ꞌimu lowaga bada?’ ");
INSERT INTO dob_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ta ꞌiona, ‘Bunama ꞌadi yau analedi yalowagedi.’ ꞌEnega toꞌitaꞌiꞌita nina ꞌigwae, ‘Pwepwai gete ꞌena ꞌimu lowaga nina ꞌuꞌetoladi be pipiti namo ꞌusaꞌu.’ ");
INSERT INTO dob_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ga ꞌebweu wate ꞌilugu ga ꞌienaidena, ꞌigwae, ‘Ta ꞌoyo ꞌeisa ꞌimu lowaga?’ Ta ꞌigwae, ‘Masula ꞌadi yau analedi yalowagedi.’ ꞌEnega tauna wate ꞌigwae, ‘Pwepwai gete ꞌena ꞌimu lowaga nina ꞌuꞌetoladi be eiti namo ꞌusaꞌu.’ Ta maiboꞌadi nadigega ꞌidi lowagao sisaꞌu mwaꞌutedi. ");
INSERT INTO dob_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“ꞌEnega ꞌina ꞌinapwana nina ꞌina guinuwa gete alena ꞌinonona, ga ꞌitupuna, ꞌina sinasinapu manuna. Onasemalimali gete ꞌenega ꞌieꞌita ꞌaiꞌaila ꞌaene, me baleꞌu siewaiwai ꞌidi esaesa ꞌana guinuwa manuna, ta Yaubada ꞌina bodao ꞌidi paisewao maedana manuna nigeya siewaiwai.” ");
INSERT INTO dob_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ꞌEnega Yesu wate ꞌieonedi, “Baleꞌu esaesanao toꞌumalidi, ta ꞌabo esaesa nidi ꞌediyega gosemiyao waobobomedi maꞌetamo taudi siaesotami ꞌebemiya ataya ꞌenaya, tuta nina esaesa nidi sigugumwala. ");
INSERT INTO dob_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Manuna ꞌeguma yaita yage gidalina ꞌena ꞌiematamatana wate yage sinabwadi ꞌediya ꞌiematamatana. Ta ꞌabo gidalidi ꞌediya ꞌikabo wate yage sinabwadi ꞌediya ꞌikabo. ");
INSERT INTO dob_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ꞌEnega ꞌomi wate ꞌabo nigeya baleꞌu esaesanao manudi waguiguinuwa ꞌaiꞌaila, ꞌiabe Yaubada geyaꞌabo wate esaesa ꞌaiꞌaila ꞌiꞌebwaꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ta ꞌabo wate gosemiyao ꞌidi esaesa manudi nigeya waguiguinuwa ꞌaiꞌaila, geyaꞌabo wate Yaubada ꞌimi esaesa nina ꞌiꞌebwaꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ꞌEnega toguinuwa nigeya sawesawenaya be ꞌietopaisewa ꞌenaꞌiyao ꞌeluwa ꞌediya, ta ꞌebweuna ꞌida guitoyasei ta esi ꞌebweuna namo manuna ꞌida paisewa, be ꞌenega ꞌebweuna ꞌiꞌawa boboꞌane ta ꞌebweuna ꞌiꞌawa toꞌumaliye. ꞌEnega nigeya sawesawenaya be Yaubada ꞌina guinuwa be esaesa baleꞌu tagiluwedi.” ");
INSERT INTO dob_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tuta nina Palisiyao ona nina sinonona ga Yesu situyeyena, manuna taudi mani nuwanuwadi sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ꞌEnega Yesu Palisiyao nidi ꞌediya ꞌigwae, “ꞌOmi wanuwena ꞌaene ꞌimi bubuna boboꞌana tomota matadiya, ta esi toꞌumalina maiboꞌana ꞌatemiya Yaubada ꞌimwalamwalatonidi, manuna yage nidi tomota nuwadi siꞌewedi, Yaubada ꞌenaya yage besobeso. ");
INSERT INTO dob_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ta onaꞌaiꞌaila, Mosese be palopitao ꞌidi loinao ꞌemiya simiyami ꞌana laba Yoni togiebapitaiso ꞌimai, ta tuta gote ꞌenega ga batuwa tetela boboꞌana Yaubada ꞌina loina manuna ꞌetamo ꞌasimasimanedi, ta ꞌebeloina nina manuna tomota yaudi ma idi waiwai sitootoo ta silugulugu. ");
INSERT INTO dob_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Galewa be baleꞌu ꞌidi sawala kapekapeyana, ta Mosese ꞌina loinao ꞌanabwaꞌayoi gidala sedaidi, geyaꞌabo saꞌi sigumwagumwala.” ");
INSERT INTO dob_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ta Yesu wate ꞌediya ꞌigwae, “ꞌAbo yaita tai mwanena ꞌisaꞌile be ꞌiaibala mali waine ꞌena, tauna niꞌatu ꞌiloelata. Ta wate ꞌeguma waine saꞌisaꞌilina ꞌiai limana mali tai ꞌena, tai nina tauna wate niꞌatu ꞌiloelata.” ");
INSERT INTO dob_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ta Yesu wate ꞌieonedi, ꞌigwae, “ꞌEbweu tuta ꞌena toesaesa ꞌebweuna ta Lasalo simiyami. Toesaesa nina ꞌana ꞌoamao boboꞌaiꞌailidi ta wate ꞌana masulao maiboꞌadi boboꞌadi, ꞌenega ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya ma ina gwausowala. ");
INSERT INTO dob_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta Lasalo gomagomabesona ta lobonubonuna, ꞌenega Lasalo nina toesaesa ꞌina anuwa mataꞌawaninaya ꞌimiyami, ");
INSERT INTO dob_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","be toesaesa nina ꞌana masula mugumugunega tupwana ꞌida loepaꞌala. Ta Lasalo nina tuta yauna bonunao kedewa siloyamoyamosidi. ");
INSERT INTO dob_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ga tuta nina Lasalo ꞌimwawasa aniloseyao siꞌauꞌewena ga Ebelaamo selabenaya sisaꞌuna topalupaludi ꞌidi senaya. ꞌEnega muliyega wate toesaesa nina ꞌimwawasa ga sisaꞌu ꞌaliꞌaliyena, ");
INSERT INTO dob_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ta muliyega ma ina ꞌelouya sinabwana tomwawasa ꞌidi sena ꞌenega ꞌiꞌitatuꞌe ga Lasalo ꞌiꞌitena Ebelaamo maꞌiyana simiyami. ");
INSERT INTO dob_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ꞌEnega ꞌibwautoila ga ꞌigwae, ‘Tamagu ye! ꞌUda ꞌatenuwa ꞌoleꞌoleyegu be Lasalo ꞌuda etunenama be bwasi gonitu nimanega meyagu ꞌida giegonitu, manuna gete tuga yaꞌeloꞌelouya sinabwana kaiwe sabelulu ꞌenaya.’ ");
INSERT INTO dob_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ta Ebelaamo ꞌieonena, ꞌigwae, ‘Natugu, ꞌuda mwalatoni ꞌaene lowa yawasiyo maiboꞌana gwausowala daisinamo, ta esi Lasalo nigeya ꞌebweu ꞌebe gwausowala ꞌilobaloba. ꞌEnega gete tuga tauna ma ina gwausowala, ta ꞌoyo ꞌuꞌeloꞌelouya. ");
INSERT INTO dob_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ta wate ꞌuda mwalatoni ꞌaene gamwagamwanidaya saꞌala sinabwana ꞌimiyami ga ꞌenega ꞌiweyalida, ꞌenega nigeya sawesawemaya be gete ꞌenega ꞌaabalawa ꞌemiya. ꞌOmi wate, nigeya sawesawemiya be waabalama ꞌemaya.’ ");
INSERT INTO dob_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ta toesaesa nina ꞌigwae, ‘O boboꞌana, ta nate namo nuwanuwagu be Lasalo ꞌuda etune ꞌigu bodao ꞌediya, ");
INSERT INTO dob_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","be tasigwao site nima ꞌida emataluwedi, ꞌabona nai taudi wate simama ꞌelouya ꞌina sena gete ꞌenaya.’ ");
INSERT INTO dob_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ꞌEnega Ebelaamo tai nina ꞌieonena, ꞌigwae, ‘Niꞌatu tasimwao nidi ꞌadi toemataluwa simiyami, taudi nate Mosese be palopitao ꞌidi ona nidi Buki Tabu ꞌenaya. Ona gete solanaya sawesawenaya be tasimwao nidi sida enonoꞌaiꞌaila.’ ");
INSERT INTO dob_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ta esi toesaesa nina ꞌiona, ‘Tamagu, natei nigeya sawesawenaya. Ta ꞌabo yaita mwawasega ꞌitoolo limana be ꞌitatauya ꞌediya, be tauna siꞌitai, ꞌenega sida nuwaꞌebuni ꞌaiꞌaila.’ ");
INSERT INTO dob_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ta Ebelaamo wate ꞌigwae, ‘ꞌEguma Mosese be palopitao ꞌidi ona nigeya siemiemisedi, geyaꞌabo saꞌi ꞌebweu wate yaita siemiemise, ꞌanabwaꞌayoi ꞌabo ꞌebweu tomwawasa ꞌitoolo limana be ꞌitatauya ꞌediya.’ ");
INSERT INTO dob_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ꞌEnega Yesu ꞌina tononoyao ꞌieonedi, ꞌigwae, “Tomota ꞌaidi ꞌiabe ꞌebetoo yaudi siguinuwedi ꞌemiya be ꞌaene sida giebeꞌuyemi, ta ꞌabo yaisigedi taudi ꞌebe toona nidi siguinuwedi nuwaꞌoleꞌoledi saꞌi! ");
INSERT INTO dob_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ꞌEnega ꞌabo yaita togiebeꞌu nina, ꞌilobwenena be gulewa sinabwana sida losipwa ꞌotonaya be niꞌu gaigaiya sida ulamwaꞌute be ꞌenega geyaꞌabo gogama simulimuliye. ");
INSERT INTO dob_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“ꞌEnega wada ꞌitaꞌiꞌisimi, be ꞌabo tasiyo ꞌemuya ꞌiguinuwa toꞌumalina, ꞌutoo be maꞌiyayo wada giepaepalu, be ꞌabo niꞌatu ma ina nuwa boboꞌana ꞌuda nuwatau. ");
INSERT INTO dob_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ta ꞌabo tasimuna ꞌasiyata ꞌebweuna ꞌenaya be masebeni ꞌiguinuwa toꞌumalina ꞌemuya, be tuta ꞌebweuna ꞌebweuna ꞌenaya ꞌisidasida ꞌemuya sabi nuwatauna, ꞌilobweneyo be maiboꞌana ꞌuda nuwataudi.” ");
INSERT INTO dob_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ꞌEnega Yesu ꞌana tosimanao nidi sieonena, sigwae, “ꞌIma emisa ꞌuda giewaiwaiye.” ");
INSERT INTO dob_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ta ꞌinapwana nina ꞌigwae, “ꞌEguma ꞌimi emisa ꞌana waiwai nadigega beno atuna, sawesawemiya be kaiwe gete sinabwana ꞌena wada ona be wagwae, ‘ꞌUetodabuyo be olaya tauyo ꞌuasoyo,’ ꞌimi ona nina ꞌiematamatane.” ");
INSERT INTO dob_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ta wate ꞌediya ꞌigwae, “ꞌAbo ꞌebweu yaita ꞌoyo ma imu ꞌaliꞌei, tauna bwaꞌa ꞌana totai nai yobai ꞌana toꞌitaꞌiꞌita, ta tuta nina ꞌabo ꞌaliꞌei nina paisewega ꞌiapwesama, nigeya sawesawenaya be ꞌuloina ꞌaene tauna ꞌigimiꞌai, ");
INSERT INTO dob_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ta esi ꞌuda gwae, ‘ꞌAgu masula ꞌugibubu be ꞌuꞌitaꞌiꞌisigu ta yaꞌaꞌa, be ꞌenega ꞌoyo muliyega ꞌuꞌaꞌai ta ꞌununuma.’ ");
INSERT INTO dob_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ꞌEnega ꞌaliꞌei nina ꞌina paisewa manuna ꞌana lokagutoki nigeya ꞌida lobena ꞌina ꞌinapwana ꞌenega, manuna tauna tuga ꞌina paisewa. ");
INSERT INTO dob_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ta ꞌomi wate nadigega, ꞌabo tuta nina yage maiboꞌana waguinuwedi, toꞌase nadigega yaemataluwemi, wada gwae, ‘O, ꞌaboꞌama toguinuwa tuga, ꞌenega toꞌase nadigega ꞌama emataluwa ga nadigega ꞌaguinuwena, nate esi ꞌama lobwene ꞌaiꞌaila.’ ");
INSERT INTO dob_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ta Yesu niꞌatu Yelusalema manuna ꞌitautauya ta Samelia be Galili gamwagamwanidiya ꞌilogelogedo. ");
INSERT INTO dob_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ga ꞌebweu ꞌasa ꞌenaya ꞌimai ga tolepelo site sanau ꞌilobedi, ꞌenega ꞌina ꞌeda ꞌenega siasiꞌi, ");
INSERT INTO dob_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ta sibwaubwau ꞌenadi sinabwana ꞌenega, sigwae. “ꞌInapwana Yesu, ꞌuda ꞌatenuwa ꞌoleꞌoleyema.” ");
INSERT INTO dob_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ꞌEnega ꞌisanaila ga ꞌieonedi, “Watatauya be totaliyao ꞌediya wada eꞌitaemi.” Ta niꞌatu sitautauya ꞌedaya ga ꞌadi lepelo ꞌigumwala, ");
INSERT INTO dob_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ta ꞌebweuna tai ꞌediyega tauna goma Sameliana ꞌiꞌitena ꞌaene niꞌatu ꞌiboboꞌana, ꞌenega ꞌiila limana ga ꞌenana sinabwanega Yaubada ꞌitupuna, ");
INSERT INTO dob_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ga Yesu ꞌaenaya ꞌibeꞌu sanamwaꞌuta ga ꞌena ꞌilokagutoki. ");
INSERT INTO dob_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ꞌEnega Yesu tai nina ꞌieonena, “Niꞌa wate sanau yagie boboꞌanemi, ta mwaꞌo site naini nidi? ");
INSERT INTO dob_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mwaꞌadega nigeya siilailama be Yaubada ꞌena silokalokagutoki? Ta ꞌoyo toꞌuꞌumala nigeya Yudia ꞌenega, ta ꞌumai sabi lokagutoki. ");
INSERT INTO dob_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ꞌEnega ꞌimu emisega ꞌetoseyana ꞌulobena. Boboꞌana, ꞌutoolo be ꞌutatauya.” ");
INSERT INTO dob_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Palisiyao ꞌaidi simai ga Yesu sienaidena to tuta nadigega ꞌena Yaubada ꞌina loina ꞌida apwesama. ꞌEnega Yesu ꞌidi enaida ꞌieꞌisena gete nadigega, ꞌigwae, “Nigeya sawesawenaya be tomota matadiyega Yaubada ꞌina loina ꞌimeema siꞌita. ");
INSERT INTO dob_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ta wate nigeya sawesawediya be sida gwae, ‘Waꞌita gete’, nai ‘Gote’, manuna niꞌatu Yaubada ꞌina loina ꞌemiya ꞌimiyami.” ");
INSERT INTO dob_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ꞌEnega ꞌina tononoyao ꞌieonedi, ꞌigwae, “Maꞌetamo yapilisinemi, be muliguyega nuwanuwami sinabwana be ꞌaboꞌagu Tomota Natuna maꞌemi tada miyami ꞌasiyata ꞌebweuna namo manuna, ta esi geyaꞌabo waꞌitaꞌitagu. ");
INSERT INTO dob_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ta ꞌabo tomota sigwae, ‘Keliso gote’, nai ‘Gete’, geyaꞌabo wamulimuliyedi. ");
INSERT INTO dob_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Manuna tuta nina ꞌabo yamamai, galewa ꞌana ꞌita ꞌatuwa maedana daisina, nadigega namala sinabwana ꞌina giweyala ꞌana ꞌita. ");
INSERT INTO dob_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","“Ta muliyega be yage nidi siapwesa, nugana ꞌepata getedi sida guitoyasegu, be ꞌediyega ꞌelouya yada lobadi. ");
INSERT INTO dob_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“ꞌIgu mai limana ꞌana tuta Noa ꞌina tuta nadigega. ");
INSERT INTO dob_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Manuna Noa ꞌina tutaya tomota siꞌeꞌai ta sinumanuma ta wate meꞌolotodi be mewainedi siaiai ga ꞌana laba Noa ꞌina wagaya ꞌigelu ga muluwa ꞌiapwesa ga ꞌenega tomota maiboꞌadi ꞌipeꞌudi, ta ꞌaboꞌagu Tomota Natuna ꞌigu ila limanama nadigega. ");
INSERT INTO dob_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ta wate ꞌiabe Loti ꞌina tuta nadigega, tuta nina tomota maiboꞌadi siꞌeꞌai ta sinumanuma, ta wate sigimwagimwane be siegiegimwane, ta wate sibagubagula ta siꞌabiꞌabi anuwa, ");
INSERT INTO dob_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ga ꞌana laba Loti Sodoma ꞌipilisinena, ꞌenega kaiwe sabelulu be gulewa yaiyaidi galewega sisaguma nadigega ꞌusana, ga tomota maiboꞌadi ꞌiloemwawasidi. ");
INSERT INTO dob_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Yage nidi siapwesa ꞌediya, ꞌiabe wate nadigega tomota ꞌediya sida apwesaꞌesa, ꞌabo tuta nina ꞌaboꞌagu Tomota Natuna yaila limanama. ");
INSERT INTO dob_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ta ꞌasiyata nina ꞌena ꞌeguma yaita bwaimaya ꞌimiyami, geyaꞌabo wate anuwaya ꞌilugulugu be ꞌaene ꞌida logwegwe. Nai ꞌabo yaita bagulaya ꞌipaipaisewa geyaꞌabo wate ꞌasa manuna ꞌipilipili. ");
INSERT INTO dob_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","“Ta esi wada nuwaꞌiꞌisi toꞌase nadigega ꞌiapwesa Loti mwanena ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Manuna ꞌabo yaita tauna yawasina manuna ꞌietapewa, ꞌiabe yawasina nina ꞌiloseye; ta ꞌabo yaita yawasina ꞌitatagwala be ꞌiloseye, maꞌetamo ꞌida lobalima. ");
INSERT INTO dob_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ta yaeona ꞌaiꞌailimi ꞌaene boiboi nina gote ꞌena tai ꞌeluwa ꞌebeꞌeno ꞌebweuna ꞌena siꞌeꞌeno, be ꞌebweuna yaꞌauꞌewa ta ꞌebweuna ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wate nadigega iine ꞌeluwa siꞌetaꞌetagowa, ꞌebweu yaꞌauꞌewa ta ꞌebweuna ꞌimiyami.” ");
INSERT INTO dob_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(-) ");
INSERT INTO dob_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ꞌEnega ꞌina tononoyao nidi sienaidena, sigwae, “ꞌInapwana, mwaꞌo?” Ga Yesu ꞌieonedi, “Mane ꞌena kokowa ꞌimiyami nate ꞌena kaokao sida egogonama.” ");
INSERT INTO dob_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ꞌEnega ꞌebweu ona semalimali Yesu ꞌiꞌebwaꞌedi be ꞌaene geyaꞌabo sidasida ꞌenega sineeneta. ");
INSERT INTO dob_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Gete nadigega ꞌigwae, “ꞌEbweu ꞌasa ꞌenaya toloina ꞌebweu sinabwana ꞌimiyami, tauna Yaubada nigeya ꞌida matautena ta wate tomota nigeya ꞌida ꞌamayabedi. ");
INSERT INTO dob_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ta sena nina ꞌenaya wate ꞌebweu kwabula ꞌimiyami, ꞌenega tuta yauyauna kwabula nina ꞌiapweapwesa toloina nina ꞌena ta ꞌisidasida ꞌana lema manuna, ꞌigwae, ‘ꞌInapwana, ꞌagu talauwala ꞌenega ꞌuda ꞌetoseyegu.’ ");
INSERT INTO dob_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Tuta ꞌebweuna ꞌebweuna nadigega ꞌina guinuwa, ta toloina nina geya nuwana be ꞌileme. Ga ꞌebweu tuta ꞌenaya toloina nina ꞌieꞌoataꞌoata, ꞌenega taunamo ꞌena ꞌigwae, ‘Tuwa tuga Yaubada nigeya yamatamataute ta wate tomota nigeya yada ꞌamayabedi, ");
INSERT INTO dob_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ta esi kwabula gete ꞌina mai limalimana ꞌeguya manuna yada leme ꞌana talauwala ꞌenega, ꞌabona nai wate ꞌagu ꞌoataꞌoata ꞌisaꞌu.’” ");
INSERT INTO dob_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ꞌEnega Yesu wate ꞌieonedi, ꞌigwae, “ꞌInapwana gete ꞌina ona manuna wada nuwanuwa. Onaꞌaiꞌaila tauna tai toꞌumalina ta esi kwabula ꞌilemena. ");
INSERT INTO dob_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wate nadigega Yaubada ꞌiabe ꞌina tomotaiyao esiesinuwadi ꞌilemedi tuta nina ꞌabo siꞌawaꞌawanoi limalimana ꞌenaya, ꞌasiyata be boiboi ꞌediya, ");
INSERT INTO dob_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ta ꞌina lema nina palupaluna tuga ꞌida guinuwe ꞌediya. “Ta mwaꞌadega ꞌomi wanuwena ꞌabo tuta nina ꞌaboꞌagu Tomota Natuna yailama baleꞌu gete ꞌena, ꞌeisa tomota ma idi emisa yalobadi sitoolo paꞌala?” ");
INSERT INTO dob_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tomota ꞌaidi sinuwena ꞌaene taudi palupaludi ta mali tomota nigeya, ꞌenega Yesu ꞌiona semalimaliyedi gete nadigega, ");
INSERT INTO dob_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ꞌigwae, “ꞌEbweu tuta ꞌenaya tomota siteluwa silugu Anuwa Tabu ꞌena sabi sidasida Yaubada ꞌenaya. ꞌEbweuna Palisi ta ꞌebweuna takisi ꞌana toꞌewa. ");
INSERT INTO dob_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ꞌEnega Palisi nina ꞌitoolo ga ꞌisidasida, ꞌigwae, ‘Yaubada ye, yalokagutoki ꞌemuya manuna ꞌaboꞌagu nigeya nadigega gosegwao ꞌidi bubuna, manuna taudi toꞌipwala diidiga be kabokabodi be loeloelatadi, ta wate ꞌaboꞌagu nigeya nadigega takisi ꞌana toꞌewa gote, ");
INSERT INTO dob_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","manuna wiki ꞌebweuna ꞌebweuna ꞌasiyata ꞌeluwa ꞌediya ꞌeꞌai ꞌenega yaedidigula, ta wate ꞌigu gwegweyao maiboꞌana ꞌenega tupwa yaꞌebwaꞌebwaya daite ꞌemuya.’ ");
INSERT INTO dob_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ta esi takisi ꞌana toꞌewa nina maꞌalenega ꞌitoolo ga ma ina omayamaya lumalumana ꞌitutuna, ta ꞌikopu sanamwaꞌuta ga ꞌisidasida, ꞌigwae, ‘Yaubada ye, niꞌatu ꞌumwalatonigu ꞌaene ꞌaboꞌagu totoꞌumaligu, ꞌenega ꞌuda ꞌatenuwa ꞌoleꞌoleyegu!’ ");
INSERT INTO dob_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ꞌEnega Yesu wate ꞌediya ꞌigwae, “Onaꞌaiꞌaila, tai gete ꞌina sidasida nina manuna ꞌana ꞌawaboboꞌana ꞌilobena Yaubada ꞌenega, ta esi Palisi nina nigeya. Manuna ꞌabo yaita tauna ꞌigituꞌeye ꞌiabe sida gimwaꞌute, ta ꞌabo yaita tauna ꞌigimwaꞌute sida gituꞌeye.” ");
INSERT INTO dob_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ꞌAina tomota natudiyao gidalidi simeꞌedi be ꞌaene Yesu ꞌida gitoodi, ta ꞌina tononoyao tomotai nidi siꞌitedi ga siꞌetobodedi. ");
INSERT INTO dob_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ta Yesu ꞌibwau egogonedi ga ꞌigwae, “Geyaꞌabo gogama waꞌetoꞌetobodedi ta esi wada tagwaledi be ꞌeguya sida mai. Manuna gogama getedi nadigega Yaubada ꞌina ꞌebeloina ꞌilobwene ꞌaiꞌailidi. ");
INSERT INTO dob_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Manuna ꞌabo yaisigedi taudi geyaꞌabo gogama getedi nadigega ꞌidi emisa, geyaꞌabo saꞌi Yaubada ꞌina ꞌebeloina ꞌena silugulugu.” ");
INSERT INTO dob_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Me Yudia ꞌidi toanugana ꞌebweu ꞌimai ga Yesu ꞌienaidena, ꞌigwae, “ꞌInapwana, yamwalamwalatoni ꞌaene ꞌoyo toeꞌita boboꞌana, ꞌenega toꞌase yada guinuwe be ꞌenega yawasigu ataya yada loba?” ");
INSERT INTO dob_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ga Yesu tai nina ꞌieonena, “Mwaꞌadega ga ꞌenega ꞌuꞌawa boboꞌanegu? Manuna nigeya ꞌebweu yaita boboꞌana, nate namo Yaubada. ");
INSERT INTO dob_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ta Yaubada ꞌina loinao niꞌatu ꞌumwalamwalatonidi, nate ꞌaene: Geyaꞌabo loelata, Geyaꞌabo loemwawasa, Geyaꞌabo ꞌipwala, Geyaꞌabo simana kabokabo, Ta wate tamayo be sinayo ꞌuda ꞌamayabedi.” ");
INSERT INTO dob_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ga tai nina ꞌigwae, “ꞌIgu tuta gwamega ga batuwa loina nidi getedi yamuliya ꞌaiꞌailedi.” ");
INSERT INTO dob_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ꞌIna ona gete nadigega Yesu ꞌinonona, ꞌenega ꞌigwae, “ꞌEbweuna yage namo ꞌilogegesemu, nate ꞌaene ꞌimu gwegweyao maiboꞌana ꞌuda egimwaneyedi be ꞌadi maisa togomabeso ꞌediya ꞌueguyaiyedi, ta ꞌenega ꞌumamai be ꞌumuliyegu be ꞌenega maꞌetamo ꞌimu esaesa galewaya ꞌuda loba.” ");
INSERT INTO dob_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ona gete tai nina ꞌinonona ta ꞌina esaesa sinabwana ꞌiegagalena, ꞌenega nuwana ꞌimwau ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ta ꞌina nuwamwau nina niꞌatu Yesu ꞌimwalatonina, ꞌenega tomota ꞌediya ꞌigwae, “ꞌAbo yaisigedi taudi ma idi esaesa sinabwana ꞌidi lugu Yaubada ꞌina ꞌebeloina ꞌenaya mwau wawasae. ");
INSERT INTO dob_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Onaꞌaiꞌaila, kameli tauna yobai sinabwana, ꞌenega tupwana mwauna be siyaluma ꞌana lobwalena ꞌenega ꞌilulugu, ta esi toesaesao ꞌidi lugu Yaubada ꞌina ꞌebeloina ꞌenaya mwau wawasae.” ");
INSERT INTO dob_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Boda nidi Yesu maꞌenao simiyami ona nina sinonona, ga sienaidena, sigwae, “ꞌAbo gete nadigega, yaita sana sawesawenaya be ꞌebe gwausowala ꞌiloba?” ");
INSERT INTO dob_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ꞌEnega ꞌediya ꞌigwae, “Toꞌase tomota ꞌediya nigeya kapekapeyana, Yaubada ꞌena yage nidi kapekapeyadi.” ");
INSERT INTO dob_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ꞌEnega Pita Yesu ꞌieonena, “ꞌInapwana, ta ꞌaboꞌama mwaꞌadega? Manuna niꞌatu ꞌima ꞌasao ꞌapilisinedi ga ꞌamuliyemu.” ");
INSERT INTO dob_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ta Yesu maiboꞌadi ꞌieonedi, ꞌigwae, “Yasimana palupalu ꞌemiya, ꞌabo yaisigedi ꞌomi ꞌimi ꞌasa nai mwanemiyao nai tasimiyao nai tamamiyao nai sinamiyao nai natumiyao wapilisinedi be Yaubada ꞌina loina ꞌena watagwalemi, ");
INSERT INTO dob_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tuta gete ꞌena eꞌisa sinabwana waloba, ta wate tuta ꞌimeemai ꞌenaya yawasimi ataya waꞌewa.” ");
INSERT INTO dob_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu site tuwelo nidi ꞌibwau egogonedi ga ꞌiailedi maꞌalenaya ga ꞌieonedi, “Gete tuga tatuꞌetuꞌe Yelusalema be yage nina maiboꞌana palopitao lowaenei siꞌetoladina ꞌaboꞌagu Tomota Natuna manugu ꞌiabe siapwesa be waꞌitadi. ");
INSERT INTO dob_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nugana sida ꞌebwayaegu taudi nigeya me Yudia ꞌediya, be sida tuyeyegu be sigie omayamayaegu be sigiwaligu, ");
INSERT INTO dob_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ta wate balaeyega sisapigu, ta ꞌenega siloemwawasigu, ta ꞌasiyata ꞌetonina ꞌenaya mwawasega yatoolo limana.” ");
INSERT INTO dob_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ta ꞌina tononoyao nidi nigeya ꞌebweu wate ꞌina ona nina ꞌana nuwasabwalena ꞌediya ꞌilugulugu. ");
INSERT INTO dob_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ta niꞌatu Yesu Yeliko ꞌena ꞌialogedo, ga ꞌebweu tomatakabokebo ꞌedaya ꞌimiyami ta ꞌiesidasida mani be gwegwe manudi. ");
INSERT INTO dob_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yesu ma ꞌana bodao ꞌenadi ꞌinonona ta ꞌilosuyaena ga ꞌigwae, “Yaisigedi natedi?” ");
INSERT INTO dob_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ꞌEnega sigwae, “Yesu goma Nasaleta ꞌitautauya.” ");
INSERT INTO dob_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ꞌEnega tomatakebokebo nina ꞌibwau toila ga ꞌigwae, “Yesu ye, ꞌoyo Debida ꞌina susu, ꞌuda ꞌatenuwa ꞌoleꞌoleyegu!” ");
INSERT INTO dob_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ga taudi tomota nidi sinuganama tai nina siꞌetobodena, sigwae, “ꞌUlosaꞌu! Tuwa bwau!” Ta tuga ꞌibwau toitoila ta ꞌigwae, “Debida tubuna ye, ꞌuda ꞌatenuwa ꞌoleꞌoleyegu.” ");
INSERT INTO dob_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ꞌEnega Yesu ꞌitoolo ga ꞌieonedi be tai nina sida bwauyenama. Ta niꞌatu ꞌimai ga ꞌienaidena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Toꞌase nuwanuwayo be yaguinuwe ꞌemuya?” ꞌEnega ꞌigwae, “ꞌInapwana, kapekapeyana be matagu ꞌuda gieꞌesasedi?” ");
INSERT INTO dob_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ta Yesu ꞌigwae, “Gete tuga matayo ꞌida ꞌesasa, manuna niꞌatu ꞌimu emisa ꞌenega ꞌuboboꞌana.” ");
INSERT INTO dob_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Gote ꞌena matana ꞌiꞌesasedi ga ma ina lokagutoki Yaubada ꞌenaya Yesu ꞌimuliyena. Ta boda nidi siꞌitenaya, ga maiboꞌadi Yaubada situpuna. ");
INSERT INTO dob_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ta niꞌatu Yesu Yeliko ꞌena ꞌilugu, ga ꞌasa nina solanega ꞌitautauya. ");
INSERT INTO dob_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Sena nina ꞌenaya ꞌebweu takisi ꞌadi toꞌewao ꞌadi toanugana ꞌimiyami, ꞌana esana Sakiusa, tauna toesaesa ꞌebweu. ");
INSERT INTO dob_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta tuta nina Yesu ꞌitautauya, Sakiusa nuwanuwana be Yesu ꞌida ꞌita ꞌaene yaita tauna, ta esi nigeya sawesawenaya be ꞌiꞌita, manuna tauna tai kukupana tuga, ta wate boda sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ꞌEnega ꞌipili nugana ga kaiwe ꞌebweu ꞌimwelena, ꞌana esana sikamole, be gote ꞌenega Yesu ꞌiꞌita, tuta nina ꞌabo sena nina ꞌena ꞌialogedo. ");
INSERT INTO dob_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ta tuta nina Yesu ꞌimai sena nina ꞌenaya, ꞌiꞌitatuꞌe ga Sakiusa ꞌiꞌitena, ꞌenega ꞌieonena, ꞌigwae, “Sakiusa, ꞌuebusi maninima, manuna batuwa ꞌoyo be ꞌaboꞌagu ꞌimu anuwaya tada miyami.” ");
INSERT INTO dob_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiusa ꞌilomanini ga ꞌiebusi, ga ma ina gwausowala Yesu maꞌiyana sielobaloba. ");
INSERT INTO dob_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Gote ꞌena tomotai nidi yage gete siꞌitena, ga silomugi, sigwae, “Mwaꞌadega ga Yesu ꞌilugu totoꞌumalina ꞌina anuwaya?” ");
INSERT INTO dob_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ta Sakiusa nina ꞌitoolo ga Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, batuwa ꞌenega ꞌigu gwegwe maiboꞌana yada ꞌupwaluwe be ꞌana tupwa maiboꞌana togomabeso yada ꞌebwaꞌedi. Ta wate ꞌabo yaita ꞌenega lowa yaꞌewagesi, yada yotuli ta ꞌana loeposeyana ata nadigega yaꞌebwaꞌe.” ");
INSERT INTO dob_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ꞌEnega Yesu ꞌieonena, “Gete tuga anuwa gete ꞌenaya ꞌetoseyana ꞌiapwesama, manuna tai gete tauna ꞌebweu Ebelaamo ꞌina boda. ");
INSERT INTO dob_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Onaꞌaiꞌaila ꞌaboꞌagu Tomota Natuna, ta yamai be kwanikwanidi yada ꞌebesedi be yaꞌetoseyedi, nadigega tai gete.” ");
INSERT INTO dob_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ta niꞌatu be Yelusalema ꞌena silogedo, ꞌenega boda nidi taudi sinuwena ꞌaene Yaubada ꞌina loina selabenaya be ꞌieꞌale, ꞌenega onasemalimali gete ꞌiꞌebwaꞌedi, ");
INSERT INTO dob_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ꞌigwae, “ꞌEbweu ꞌinapwana niꞌatu ꞌigibubuna be ꞌitatauya sena ꞌedasola ꞌenaya be ꞌaene nada ꞌietoloina, be ꞌenega muliyega ꞌiila limanama. ");
INSERT INTO dob_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ta muliyega be ꞌitatauya, ꞌina toguinuwao sanau ꞌibwau egogonedima ga ꞌadi egueguyai kina ꞌebweuna ꞌebweuna ꞌiꞌebwaꞌedi ga ꞌieonedi, ‘ꞌAmi egueguyai gete wada epaisewadi be ꞌana loeposeyana wada loba, ꞌana laba yaila limanama.’ ");
INSERT INTO dob_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ga muliyega ꞌinapwana nina ꞌina tomotaiyao ꞌaidi siguitoyasena, geya nuwadi be ꞌediya ꞌida etoloina, ꞌenega ale sietunena, sigwae, ‘Tai nina nate geya nuwama be ꞌemaya ꞌietoloina.’ ");
INSERT INTO dob_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ta ꞌinapwana nina tuwa tuga ꞌietoloina, ga tuta nina ꞌiila limanama, ga ꞌina toguinuwao nidi ꞌibwau egogonedima be ꞌaene nuwanuwana be ꞌida mwalatoi ꞌeisa ꞌadi egueguyai nidi ꞌediyega loeposeyana silobedi. ");
INSERT INTO dob_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ga tai ꞌebweu ꞌinugana ga ꞌina ꞌinapwana matanaya ꞌitoolo ta ꞌieonena, ꞌigwae, ‘ꞌEnaꞌi, ꞌimu kina nina ꞌebweuna lowa ꞌuꞌebwaꞌebwaꞌeguya gete ꞌana loeposeyana sanau yalobedi.’ ");
INSERT INTO dob_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“ꞌEnega ꞌinapwana nina ꞌigwae, ‘Onaꞌaiꞌaila, ꞌoyo togwaunuwa ꞌaiꞌaila, manuna yage gidalina ta ꞌugiesinabwena, ꞌenega ꞌamu eꞌisa yaꞌebwaꞌeyo, nate ꞌasa sanau ꞌediya ꞌuda etoloina.’ ");
INSERT INTO dob_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ga tai ꞌeluwena wate ꞌimai ga ꞌigwae, ‘ꞌInapwana, ꞌimu kina nina ꞌebweuna lowa ꞌuꞌebwaꞌebwaꞌeguya gete ꞌana loeposeyana nima yalobedi.’ ");
INSERT INTO dob_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“ꞌEnega tauna wate ꞌieonena, ꞌigwae, ‘ꞌAsa nima ꞌediya ꞌuda etoloina.’ ");
INSERT INTO dob_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ta ꞌetonina wate ꞌimai ga ꞌigwae, ‘ꞌInapwana, ꞌimu kina gete, kaleko ꞌenega yanugwena ga yasaꞌububu ꞌaiꞌailina. ");
INSERT INTO dob_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Manuna yamatautemu ꞌabona nai ꞌikwakwaiya. Ta onaꞌaiꞌaila, yamatautemuya manuna ꞌoyo tai paꞌaliyo ta ꞌimu esaesa ꞌuꞌewaꞌewa mali tomota ꞌidi paisewa ꞌediyega. ꞌEnega ꞌimu kina gete ꞌuꞌewalima.’ ");
INSERT INTO dob_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ga ꞌinapwana nina ꞌigwae, ‘Onaꞌaiꞌaila, ꞌoyo toguinuwa toꞌumaliyo. Tauyo saꞌi ꞌimu onega ꞌamu loina yaꞌebwaꞌeyo. Manuna niꞌatu ꞌumwalatonigu ꞌaene ꞌaboꞌagu tai paꞌaligu, ta ꞌigu esaesa yaꞌewaꞌewa mali tomota ꞌidi paisewa ꞌediyega, ");
INSERT INTO dob_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ta toꞌase ꞌalena ga ꞌenega nigeya ꞌigu mani nina banika ꞌena ꞌusaꞌusaꞌu be ꞌenega tuta nina yailama ma ꞌana loeposeyana yalobai?’ ");
INSERT INTO dob_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“ꞌEnega taudi ꞌinapwana nina selabenaya sitootoolo ꞌieonedi, ꞌigwae, ‘ꞌIgu kina nina ꞌenega waꞌewa be tai nina tauna loeposeyana sinabwana ꞌilobena ꞌenaya waꞌebwaꞌe.’ ");
INSERT INTO dob_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ga taudi sigwae, ‘ꞌInapwana, geyaꞌabo ꞌaꞌebwaꞌebwaꞌe, manuna tauna niꞌatu kina sanau ꞌiꞌewedi ga sawesawenaya.’ ");
INSERT INTO dob_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ta ꞌinapwana nina wate ꞌediya ꞌigwae, ‘Tuwa tuga, wada ꞌebwaꞌe, manuna ꞌabo yaita ꞌana egueguyai ꞌiloeposeyanei, ꞌana loeposeyana wate ꞌida loba, ta ꞌeguma yaita nigeya ꞌiloeloeposeyane, toꞌase ꞌenaya ꞌimiyami ꞌenega maꞌetamo sida ꞌewayaule. ");
INSERT INTO dob_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ꞌEnega gete tuga ꞌagu talauwalao nidi, taudi siguitoyasegu be ꞌaene geya nuwadi be ꞌediya yaetoloina, wada ꞌauꞌewedima be mataguya waloemwawasidi.’ ” ");
INSERT INTO dob_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu ꞌina ona gete ꞌilosalonina ga ꞌitoolo ga ma ina tononoyao situꞌetuꞌe Yelusalema manuna, ");
INSERT INTO dob_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ta ꞌidi tauya ꞌenaya Betipegi be Betani selabediya silogelogedo, nate Olibe ꞌoyana ꞌagalaunaya, ꞌenega ꞌina tononoyao ꞌeluwa ꞌigimi etunedi sena nidi ꞌediya ma ꞌadi emataluwa, ");
INSERT INTO dob_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ꞌigwae, “ꞌAsa nina gote matadaya ꞌena watatauya be gote ꞌena ꞌiabe ꞌebweu yobai waꞌitaloba, nate ase mwaneyauna, tauna nigeya tomota sida gelutoona, yobai nina waliꞌami be wameꞌe. ");
INSERT INTO dob_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta ꞌabo yaita ꞌigwae, ‘Toꞌase manuna nate yobai nina waliꞌaliꞌami?’ tai nina waeona, wagwae, ‘ꞌInapwana nuwanuwana.’ ” ");
INSERT INTO dob_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ꞌEnega taudi sitauya ga yage maiboꞌadi silobedi nadigega Yesu ꞌieonaꞌesedi. ");
INSERT INTO dob_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ta tuta nina ase nina siliꞌaliꞌami ta toniyobai nidi sieonedi, sigwae, “Mwaꞌadega ga ꞌima yobai waliꞌaliꞌami?” ");
INSERT INTO dob_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ga sigwae, “ꞌInapwana nuwanuwana.” ");
INSERT INTO dob_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ta yobai nina siꞌewena ga sitauyena Yesu ꞌena, ga ꞌadi ꞌoamega gwauna siloesona, ꞌenega Yesu ꞌigelutuꞌe, ");
INSERT INTO dob_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ga ꞌitautauya ta tomota yaudi ꞌadi ꞌoamao ꞌedaya siesodi. ");
INSERT INTO dob_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ga niꞌatu simai Yelusalema selabenaya ga simwaꞌumwaꞌuta Olibe ꞌedana ꞌenaya ga ꞌana tomuliyao nidi mabodadi ma idi gwausowala Yaubada situpuna, manuna niꞌatu ꞌina guinuwa waiwaidi siꞌitedi, ");
INSERT INTO dob_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","sigwae, “Kamatoki ꞌInapwana, Yaubada ꞌana esanega ꞌumai be ꞌenega gwausowala be tupu galewaya sida sinabwa ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ꞌEnega Palisiyao ꞌaidi boda nidi ꞌediyega Yesu sieonena, sigwae, “ꞌInapwana ꞌamu tomuliyao nidi ꞌueonadi be silosaꞌu.” ");
INSERT INTO dob_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ta Yesu ꞌigwae, “Geyaꞌabo yaꞌetoꞌetobodedi, manuna ꞌabo taudi siꞌalaenono gulewa ꞌenadi ꞌisaꞌu be sibwabwau.” ");
INSERT INTO dob_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Niꞌatu Yesu ꞌilogedo Yelusalema selabenaya ta ꞌasa nina sinabwana ꞌiꞌitena ga nuwana ꞌimwau ga ꞌidedoi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Yelusalema ye, ꞌiabe tomotenimwao nuwaꞌoleꞌoledi saꞌi, manuna tuta gete ꞌenaya ꞌadi ꞌetoseyana nina nigeya simwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ta esi tuta ꞌimeemai ꞌediya ꞌadi talauwalao simama be sipeꞌudi, manuna ꞌiabe ꞌimu sena maiboꞌana siꞌali sakowasiye ta maiboꞌadi siluguwa be tomotenimwao siloegumwalidi, ");
INSERT INTO dob_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ta wate anuwa maiboꞌana siligei yauyauledi. “Yage nidi getedi maꞌetamo ꞌemuya siapwesa, manuna natumwao nidi nigeya Yaubada ꞌana etuetune nina manuna sigwaugwausowala.” ");
INSERT INTO dob_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ꞌEnega ꞌitauya ga ꞌilugu Anuwa Tabu solanaya ta toegimwane solanega ꞌipaꞌidi, ta ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ꞌigwae, “Buki Tabu ꞌenaya Yaubada ꞌina ona siꞌetoladina ꞌigwae, ‘ꞌIgu anuwa ꞌaene anuwa ꞌebe sidasida, ta ꞌomi wagibunina ga ꞌaene ꞌimi ꞌebe ꞌipwala.’ ");
INSERT INTO dob_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ta ꞌasiyata ꞌebweuna ꞌebweuna Anuwa Tabu nina ꞌenaya ꞌieꞌieꞌita, ta totaliya sinabwadi be loina ꞌana toeꞌitao be wate toanuganao sitootoo be ꞌaene Yesu sida loemwawasi, ");
INSERT INTO dob_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ta nigeya sawesawediya, manuna Yesu ꞌina eꞌitao tomota yau wawasae nuwadi ꞌiꞌewena. ");
INSERT INTO dob_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ꞌEbweu tuta ꞌenaya, Yesu ꞌieꞌieꞌita Anuwa Tabu ꞌenaya, nate Tetela Boboꞌana ꞌisimasimana tomota ꞌediya, ta totaliyao be loina ꞌana toeꞌitao be wate ꞌinapwanao simai ga Yesu sienaidena, ");
INSERT INTO dob_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","sigwae, “Tai, yaita ꞌina loinega ga gete nadigega ꞌuguiguinuwaꞌesa?” ");
INSERT INTO dob_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ta Yesu ꞌieonedi, ꞌigwae, “Nugana yagimi enaida ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yaita ꞌina loinega ga Yoni togiebapitaiso ꞌiguiguinuwa? Yaubada, nai ꞌebweu tomota?” ");
INSERT INTO dob_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ꞌEnega taudimo ꞌediya sienuenuwana, sigwae, “ꞌIna ona mwaꞌadega tada eꞌisaꞌese? Manuna ꞌabo tagwae, ‘Yaubada ꞌenega’, ꞌiabe ꞌieona limada be ꞌigwae, ‘Ta! Toꞌase sana manuna ga Yoni nigeya waemiemise?’ ");
INSERT INTO dob_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ta ꞌabo tagwae, ‘Tomota ꞌenega’, nate be boda gulewega siloibwaibwada, manuna tomota yaudi Yoni siemisena ꞌaene tauna ꞌebweu palopita.” ");
INSERT INTO dob_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ꞌEnega ꞌina enaida nigeya sieꞌieꞌisa ꞌaiꞌaili, ta esi sigwae, “Nigeya ꞌamwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ta Yesu wate ꞌigwae, “ꞌAboꞌagu geyaꞌabo wate ꞌemiya yasimasimana apwesa yaita ꞌina loinega ga gete nadigega yaguiguinuwaꞌesa.” ");
INSERT INTO dob_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ꞌEnega Yesu tomota nidi ꞌiona semalimaliyedi, ꞌigwae, “ꞌEbweu tai ꞌina bagula ꞌiasona oine daisinamo, ga ꞌina toguinuwao ꞌiloinedi be siꞌitaꞌiꞌisi, ta tauna ꞌitauya mali senaya ga nada ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Ta sesoi ꞌana tutaya ꞌinapwana nina ꞌina ꞌaliꞌei ꞌebweuna ꞌietune ilena be ꞌaene oine uwana bagula ꞌana toꞌitaꞌiꞌitao ꞌediyega ꞌida meꞌedi. ꞌItautauya ga nigeya siꞌebwaꞌebwaꞌe, ta esi sisapina ga maꞌanimenimenamo sietunena ga ꞌiila. ");
INSERT INTO dob_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“ꞌEnega ꞌinapwana nina ꞌina ꞌaliꞌei ꞌeluwena wate ꞌietunena ꞌediya ga siununa ga wate sigie omayamayena ta maꞌanimenimenamo sietunena ga ꞌiila. ");
INSERT INTO dob_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Ta wate ꞌetonina ꞌietunena ꞌediya ga wate siunu geyogeyonina ga sipaꞌina. ");
INSERT INTO dob_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“ꞌEnega tonibagula nina ꞌinuwanuwa, ꞌigwae, ‘To ꞌeda wate yada guinuwe? Nai taugu tuga natuꞌaiꞌailigu yaetune be ꞌenega sida ꞌamayabe manuna tauna sana natugu.’ ");
INSERT INTO dob_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ta tuta nina toguinuwao nidi ꞌinapwana natuna siꞌitena ꞌimeema taudimo ꞌediya sigwae, ‘Gosemao, tai gote ꞌimeema, tauna ꞌinapwana nina natuna ꞌebweuna namo tuga, ꞌenega batuwa nina taloemwawasi be ꞌaboꞌada bagula taloine.’ ");
INSERT INTO dob_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“ꞌEnega sigiyaina ga bagulega siula apwesena ꞌetauluya, ga nada siloemwawasina.” Ga niꞌatu Yesu ꞌina emwasala ꞌigumwala ga ꞌienaida ꞌediya, ꞌigwae, “Toꞌase ꞌiabe ꞌinapwana nina ꞌina toꞌitaꞌiꞌitao nidi ꞌediya ꞌiguinuwe? ");
INSERT INTO dob_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Onaꞌaiꞌaila ꞌinapwana nina ꞌimama be toguinuwa nidi ꞌiloemwawasidi, be ꞌenega bagula nina mali toꞌitaꞌiꞌitao ꞌiꞌebwaꞌedi.” ꞌInapwanao nidi Yesu ꞌina ona gete nadigega sinonona ga sigwae, “Onaꞌaiꞌaila, ꞌaboꞌada geyaꞌabo wate nadigega!” ");
INSERT INTO dob_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ta Yesu ꞌiduneyedi ta wate ꞌediya ꞌigwae, “Mwaꞌadega ꞌana mwalatoi Buki Tabu ꞌina simana gete, ꞌigwae, ‘ꞌOla nina lowa toꞌabi anuwa siguitoyasena, ta gete tugai niꞌatu sietoolona be ꞌieꞌola nugana, be ꞌola maiboꞌadi ꞌiloinedi.’ ");
INSERT INTO dob_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“ꞌEguma yaita ꞌibebeꞌu ꞌola gete ꞌena, ꞌiabe luluna ꞌilasadi, ta ꞌeguma ꞌola nina ꞌibebeꞌu ꞌebweu yaita etaninaya ꞌiabe oona ꞌiꞌauideide namo.” ");
INSERT INTO dob_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gote ꞌena totaliyao be loina ꞌana toeꞌitao ꞌaina ꞌedaꞌeda siꞌebesena be ꞌaene Yesu sida giyai, manuna simwalatonina ꞌaene taudi tuga manudi ꞌiona semalimali, ta esi nigeya sigiyagiyai manuna pwalu ꞌediya simatauta. ");
INSERT INTO dob_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ꞌEnega tuta yauna Yesu siloomataꞌiꞌisi be ꞌaene toꞌase ꞌina loegesi siloba, be ꞌenega sisimana toloina ꞌenaya be ꞌietalae, ꞌenega tomota ꞌaidi sietunedi Yesu ꞌenaya be enaidega sikaboe be ꞌaene ꞌina loegesi siloba. ");
INSERT INTO dob_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ꞌEnega tomota nidi simai ga Yesu sieonena, sigwae, “ꞌInapwana, onaꞌaiꞌaila ꞌoyo ꞌimu onao be ꞌimu eꞌitao maiboꞌana palupaludi, ta wate ꞌamwalatonimu ꞌaene nigeya ꞌebweu tomota ꞌuda matautena, ta esi Yaubada ꞌina nuwanuwa ꞌana toeꞌita ꞌaiꞌaila ꞌoyo. ");
INSERT INTO dob_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ꞌEnega mwaꞌadega, sawesawenaya be Kini Sisa manuna takisi tasaꞌu, nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ta Yesu niꞌatu ꞌidi kabo nina ꞌimwalatonina, ꞌenega ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ꞌigwae, “Abaga mani nina wameꞌe be yaꞌita.” ꞌEnega siꞌebwaꞌena ga ꞌieonedi, ꞌigwae, “Wada eonagu yaita gete ꞌana maꞌamaꞌayau ta ꞌana esana mani nina ꞌena?” Ga taudi sigwae, “Kini Sisa.” ");
INSERT INTO dob_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ꞌEnega Yesu ꞌigwae, “O, nadigega, ꞌenega ꞌeguma Kini ꞌina yage waꞌebwaya Kini ꞌenaya, ta ꞌeguma Yaubada ꞌina yage Yaubada waꞌebwaꞌe.” ");
INSERT INTO dob_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yesu ꞌina ona gete pwalu matadiya maiboꞌana palupaluna, ta nigeya ꞌebweu wate onagesi ꞌenega silobaloba, ta ma idi nuwaowana simiya ꞌalaenono. ");
INSERT INTO dob_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ꞌEnega wate ꞌaina Sadusiyao, taudi nigeya siemiemisa tomwawasa ꞌidi toolo limana manuna, simai ga Yesu ꞌena sienaida, sigwae, ");
INSERT INTO dob_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ꞌInapwana, loina gete nadigega Mosese ꞌiꞌetoladina manuda, ꞌigwae, ‘ꞌAbo ꞌebweu tai ꞌiai be nigeya natunamo ta ꞌimwamwawasa, tai nina tasina kwabulinana maꞌiyana sida ai be ꞌenega ꞌabo waine ꞌienatuna, natunao tokwaiya nina ꞌana lopaꞌeluyao.’” ");
INSERT INTO dob_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ꞌEnega ꞌebeꞌita siꞌebwaꞌena, sigwae, “ꞌEbweu tai matasinao simiyami ꞌadi yau site sebeni, ga ꞌadi tomatuwa nina ꞌiai ga muliyega nigeya natunamo, ta tai nina ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ꞌEnega tasina selabenega kwabula nina ꞌiꞌewena ga wate simiyamiyana ta nigeya natunamo, ta tai nina ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ꞌEnega wate tasina selabenega kwabula nina ꞌiaina, ga wate nadigega nigeya natunamo, ta ꞌimwawasa. Ta nadigega tuga tasinao maiboꞌadi kwabula nina siaiai ta simwawamwawasa, ta nigeya natudimo, ");
INSERT INTO dob_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ga muliyega waine wate ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Ta toꞌase ꞌunuwena tomota gete manudi to tai waine nina mwaneꞌaiꞌailina, tuta nina ꞌabo mwawasega sitoolo limana? Manuna site sebeni nidi niꞌatu siaina.” ");
INSERT INTO dob_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ꞌEnega Yesu ꞌidi ona ꞌieꞌisena, ꞌigwae, “Wada nuwaꞌiꞌisi ꞌaene tuta gete ꞌena waine be tai siaiai, ");
INSERT INTO dob_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ta esi tuta ꞌimeema ꞌenaya ꞌabo waine be tai sawesawediya be mwawasega sitoolo limana geyaꞌabo wate siaiai limana. ");
INSERT INTO dob_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Manuna ꞌiabe taudi nadigega aniloseyao, be geyaꞌabo wate simwawamwawasa limana, ta esi Yaubada ꞌida ꞌawanatunedi manuna mwawasega sitoolo limana. ");
INSERT INTO dob_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Ta Mosese lowaenei ꞌieꞌita ꞌaiꞌailida tomwawasa ꞌidi toolo limana manuna. Tuta nina Mosese mitawaya ꞌitautauya ta Yaubada kaiwe sabelulu ꞌenega ꞌieonena, ꞌigwae, ‘ꞌAboꞌagu Ebelaamo be Aisake be Yekobe ꞌidi Yaubada’. ");
INSERT INTO dob_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gete ꞌana mwalatoi ꞌaene nigeya tomwawasa ꞌidi Yaubada ta esi taudi mayawasidi ꞌidi Yaubada, manuna ꞌinapwanao nidi Yaubada ꞌina senaya gete tuga mayawasidi simiyami.” ");
INSERT INTO dob_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Gote ꞌena loina ꞌana toeꞌitao simatauta ga ꞌaidi sigwae, “Toeꞌita, ꞌimu eꞌisa boboꞌana wawasae,” ꞌenega nigeya ꞌebweu wate enaida siꞌebwaꞌebwaꞌe. ");
INSERT INTO dob_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ꞌEnega Yesu wate ꞌienaida ꞌediya ꞌigwae, “Mwaꞌadega ga ꞌenega ꞌaina tomota sigwae ꞌaene Debida ꞌina susuyega Toꞌetoseyana Keliso ꞌiapwesa, ");
INSERT INTO dob_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","manuna Same ꞌenaya Debida ꞌigwae, ‘Yaubada ꞌiona ꞌigu ꞌInapwana ꞌenaya, ꞌigwae: ꞌAtaiguya ꞌumiyatowa, ");
INSERT INTO dob_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","be ꞌana laba ꞌamu talauwalao yasaꞌu mwaꞌutedi ꞌaeyo ꞌadi ꞌebesaꞌu manuna.’ ");
INSERT INTO dob_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Debida nina ꞌina ꞌInapwana Keliso, ꞌenega mwaꞌadega sana ga Debida ꞌina susuyega muliyega Keliso ꞌiapwesama?” ");
INSERT INTO dob_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ꞌEnega boda maiboꞌadi sienoenono, ta Yesu ꞌina tononoyao ꞌieonedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tasigwao, geyaꞌabo loina ꞌana toeꞌitao ꞌidi bubuna wamulimuliye. Manuna taudi adelidi tuga nadigega tuta yauna nuwanuwadi be ꞌadi ꞌoamao duduladi siꞌotedi be tomota gamwagamwanidiya sisakosakowasi be ꞌaene sida ꞌamayabedi. Ta wate nuwanuwadi ꞌidi ꞌebemiya boboꞌadi Anuwa Tapwalolo ꞌediya, be wate sagali ꞌadi tutaya nuwanuwadi be bwaimaya sida miyatowa. ");
INSERT INTO dob_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ta wate tuta yauna tomota matadiya Yaubada ꞌena sisidasida dudulana, ta esi ꞌidi sida nina nigeya boboꞌana, manuna ꞌatediya sinuwanuwa mwaꞌadega ꞌiabe kwabulao sikaboꞌesedi be ꞌidi gwegweyao siꞌewadi. ꞌEnega maꞌetamo Yaubada eꞌisa toꞌumalina ꞌiꞌebwaꞌedi.” ");
INSERT INTO dob_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu ꞌidunedune ga toesaesao ꞌidi ꞌebwayadaita mani ꞌebwayadaita ꞌana ꞌebesaꞌu ꞌenaya sisaꞌusaꞌudi. ");
INSERT INTO dob_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ꞌIdunedune ga ꞌebweu kwabula gomagomabesona ꞌiꞌitena, ꞌilaga ga ꞌina ꞌebwayadaita toea ꞌeluwa namo ꞌisaꞌudi. ");
INSERT INTO dob_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ꞌEnega Yesu ꞌigwae, “Onaꞌaiꞌaila, maiboꞌadi ꞌediyega kwabula gote ꞌina ꞌebwayadaita ꞌisinabwa wawasae, ");
INSERT INTO dob_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","manuna maiboꞌadi ꞌidi tupwa sinabwana ꞌimiyami, ta kwabula gote gomagomabesona ta ꞌina mani maiboꞌana ꞌisaꞌuna, ga nigeya ꞌebweu wate ꞌina tupwa ꞌimiyami be ꞌenega ꞌana masula ꞌida gimwane.” ");
INSERT INTO dob_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ta Yesu ꞌina tononoyao ꞌaidi Anuwa Tabu ꞌana ꞌita boboꞌana siꞌitena ga Yesu ꞌena sieꞌitena ta sigwae, “ꞌInapwana, Anuwa Tabu nina ꞌana iyalao ꞌadi ꞌita boboꞌana wawasae, manuna gulewa sinabwadi ꞌediyega siꞌabina, ta wate tomota ꞌidi ꞌebwayadaitao boboꞌadi ꞌediyega sieiyalina.” Ta Yesu ꞌediya ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Anuwa nina batuwa waꞌitaꞌita, ta tuta ꞌimeemai ꞌenaya maiboꞌana siligeya yaule be geyaꞌabo wate ꞌebweu tupwa waꞌitaꞌita lima.” ");
INSERT INTO dob_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ꞌEnega Yesu ꞌena sienaida, sigwae, “Toeꞌita ꞌueonama to tuta ꞌena Anuwa Tabu nina siligei, ta to weꞌiweꞌiyaya ꞌadi ꞌita ꞌediyega ꞌada mwalatoni ꞌaene yage nidi ꞌuonaediya ꞌiabe siapwesama?” ");
INSERT INTO dob_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ga Yesu ꞌediya ꞌigwae, “Waꞌitaꞌiꞌisimi ꞌabona nai tomota ꞌaidi sikaboemi, manuna maꞌetamo tomota yaudi ꞌagu esanega simama be ꞌaene sianugana gesiyemi be ꞌebweuna ꞌebweuna ꞌida gwae, ‘ꞌAboꞌagu Toꞌetoseyana nina,’ nai ꞌaina wate sida gwae, ‘Toꞌetoseyana ꞌina tuta niꞌatu ꞌiapwesama.’ Ta esi geyaꞌabo wamulimuliyedi. ");
INSERT INTO dob_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Ta ꞌeguma wate losaiya aledi wanonodi, geyaꞌabo waꞌateꞌate saꞌala, manuna yage getedi sida apwesa nugana ta baleꞌu ꞌana ꞌebe losalowa ꞌana tuta maꞌetamo.” ");
INSERT INTO dob_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ta wate ꞌieonedi, “Maꞌetamo mali boda mali boda ꞌediya sida losaiya. Ta wate mali ꞌebeloina mali ꞌebeloina ꞌediya sida losaiya. ");
INSERT INTO dob_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","“Ta tuta nina ꞌenaya mwaniꞌiniꞌi sena yaudi ꞌediya, be botana sinabwadi, be wate ꞌelouya sinabwadi, ta wate ꞌiabe ꞌebe nuwaowana ta ꞌebe matauta galewega siapwesama. ");
INSERT INTO dob_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ta muliyega be yage nidi getedi siapwesa, nugana ꞌami talauwalao sida giyaimi be sigie ꞌelouyami, ta wate anuwa tapwalolo ꞌediya sietalaemi be ꞌenega deliya sisaꞌumi. Ta wate kiniyao be toloinao matadiya siꞌauꞌewami be sietalaemi manuna ꞌomi ꞌaene ꞌigu bodao. ");
INSERT INTO dob_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ꞌImi etala nidi ꞌediya teteligu wada simane ꞌediya. ");
INSERT INTO dob_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ta geyaꞌabo wanuwanuwa wawasae, ꞌabo tuta nina watoo be ꞌediya waonaona, ");
INSERT INTO dob_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","manuna ꞌaboꞌagu ꞌetamo ona palupaludi ta mwalatoi yaꞌebwaꞌemi, be ꞌenega ꞌami talauwalao geyaꞌabo siꞌawaꞌawa kabokaboemi. ");
INSERT INTO dob_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Tuta nina ꞌenaya wate tamamiyao be sinamiyao be tasimiyao be ꞌimi buꞌunao be wate gosemiyao sida sipupuyemi, be ꞌaimi ꞌemiyega siloemwawasidi, ");
INSERT INTO dob_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","be tomota maiboꞌadi sida etalauwalemi manuna ꞌomi ꞌaene ꞌagu toemisao. ");
INSERT INTO dob_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ta esi geyaꞌabo ꞌebweu toꞌesimi sigiegie toꞌumaliye, ");
INSERT INTO dob_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ta ꞌomi wada toolopaꞌala be ꞌenega yawasimi ataya wada loba. ");
INSERT INTO dob_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ta ꞌeguma to tuta ꞌena Yelusalema waꞌita be tolosaiyao simiya sakowasiyei wada mwalatoni ꞌaene niꞌatu be Yelusalema nina sipeꞌu. ");
INSERT INTO dob_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ꞌEnega Yudia ꞌana tomiyanao ꞌilobwenedi be ꞌoya ꞌediya sidedena. Ta wate Yelusalema ꞌana tomiyanao ꞌilobwenedi be ꞌasega siapwesa. Wate nadigega taudi bagulaya sipaipaisewa geyaꞌabo ꞌasaya silugulugu limana. ");
INSERT INTO dob_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ꞌAsiyata getedi ꞌediya Yaubada ꞌina bwaꞌomatana ꞌida apwesa tomota ꞌediya, be ꞌenega Buki Tabu ꞌina gimisimana maiboꞌana ꞌida apwesa. ");
INSERT INTO dob_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Tuta gote ꞌenaya toꞌeuwanao be toesusuyao sienuwaꞌoleꞌole, manuna tuta mwauna me baleꞌu manudi, be gote ꞌena ꞌiabe Yaubada ꞌina gamwasowalega me Yudia ꞌigieꞌelouya ꞌaiꞌailidi. ");
INSERT INTO dob_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Gote ꞌena tolosaiyao ꞌaina tomota siloemwawasidi, ta ꞌaidi sigiyaidi be mali sena be mali sena ꞌediya sitauyedi, ta tolosaiyao nidi taudi nigeya me Yudia maꞌetamo siewaiwai be Yelusalema maiboꞌana siloine, be ꞌena sida sakosakowasi ꞌana laba tolosaiyao nidi ꞌidi loina ꞌilosaꞌu. ");
INSERT INTO dob_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ta wate muliyega ꞌebe nuwaowana siapwesama sinala be nawalae be kwadima ꞌediyega, be tomiya baleꞌu maiboꞌadi ꞌidi matautega sitatai manuna lisu weiyawanidi sidudu tuꞌema, ");
INSERT INTO dob_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ta ꞌenega ma idi matauta sinabwana siyamwayamwa ꞌaene to yage nai wate toꞌumalina ꞌiabe baleꞌuya ꞌida apwesa, manuna yage yauyaudi galewaya simiyami ꞌidi waiwai sida neneta. ");
INSERT INTO dob_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ꞌAboꞌagu Tomota Natuna, be tuta gote ꞌena me baleꞌu maiboꞌadi siꞌitagu pwanega yamwaꞌumwaꞌutama ma igu waiwai ta ma igu esaesa sinabwana. ");
INSERT INTO dob_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ta ꞌeguma weꞌiweꞌiyaya nidi getedi sieꞌaleꞌunu be waꞌitadi, wada ꞌatepatu tuga be waꞌitatuꞌe, manuna ꞌami ꞌetoseyana niꞌatu ꞌimeema.” ");
INSERT INTO dob_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ꞌEnega Yesu wate ꞌebweu ona semalimali ꞌieonedi, ꞌigwae, “Kaiwe nina saido ta wate ꞌaina kaiweyao ꞌabo waꞌitadi ");
INSERT INTO dob_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","be yawadi auwaudi ꞌigalugalu, wamwalatonina ꞌaene losiye ꞌana tuta ꞌiloseloselabe. ");
INSERT INTO dob_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nadigega wate ꞌabo weꞌiweꞌiyaya nidi waꞌitalobadi wada mwalatoni ꞌaene niꞌatu be Yaubada ꞌina loina ꞌiapwesama. ");
INSERT INTO dob_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Onaꞌaiꞌaila, ꞌepata gete geyaꞌabo wagumwagumwala be ꞌana laba yage getedi sida apwesa. ");
INSERT INTO dob_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maꞌetamo galewa be baleꞌu sisasawala ta ꞌigu onao geyaꞌabo saꞌi sisawasawala. ");
INSERT INTO dob_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ta wada ꞌitaꞌiꞌisimi be geyaꞌabo ꞌemasula be bwasi waiwaidi ꞌadi numa ꞌediya watautauya wawasae, ta wate geyaꞌabo ꞌimi miya baleꞌuya manuna wanuwanuwa wawasae, ꞌabona nai ꞌasiyata nina ꞌena Yaubada ꞌiloesalutuimi be nadigega gomana ꞌenega ꞌiꞌonami. ");
INSERT INTO dob_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Manuna ꞌasiyata nina ꞌenaya me baleꞌu maiboꞌadi ꞌiloesalutuidi ꞌina bwaꞌomatana nina ꞌenega. ");
INSERT INTO dob_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","“ꞌEnega wada gibubuna ataya be tuta yauna wada sidasida be ꞌaene ma imi ꞌatepatu yage getedi ꞌediyega wada ewaiwai be ꞌenega wada toolo ꞌaboꞌagu Tomota Natuna mataguya.” ");
INSERT INTO dob_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tuta gote ꞌediya Yesu Anuwa Tabu ꞌena ꞌieꞌieꞌita, ta ꞌasuinuwanuwaya ꞌiilaila Olibe ꞌoyana ꞌenaya ta ꞌiꞌenoꞌeno, ");
INSERT INTO dob_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ta tomota gonagona ꞌebweuna ꞌebweuna sitautauya Anuwa Tabu ꞌenaya Yesu sabi enonoena. ");
INSERT INTO dob_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ta niꞌatu Ataona Sagalina ꞌana tuta ꞌiloselabena be pwalawa daisina nigeya ꞌana ꞌebe gieseseyamo siꞌaꞌani. ");
INSERT INTO dob_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tuta nina ꞌena totaliyao sinabwadi be loina ꞌana toeꞌitao sinuwanuwa edaedadama mwaꞌadega be Yesu sigiyai ꞌana loemwawasa manuna, ta nigeya sawesawediya manuna pwalu sinabwana simatautedi. ");
INSERT INTO dob_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Gote ꞌena Seitani Yudasa ꞌena ꞌilugu, tauna ꞌana esana ꞌeluwena Isikaliota, ta wate tauna Yesu ꞌina tonono ꞌebweu site tuwelo ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ꞌEnega Yudasa nina ꞌitauya totaliya sinabwadi be Anuwa Tabu ꞌana toꞌitaꞌiꞌitao ꞌediya ga maꞌedi siꞌawagwae be ꞌaene mwaꞌadega Yesu ꞌitelesipupuꞌese be sigiyai. ");
INSERT INTO dob_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ꞌEnega Yudasa ꞌina ona manuna sigwausowala ga ꞌena sionaupaupa be ꞌaene ꞌana maisa siꞌebwaꞌe. ");
INSERT INTO dob_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ta Yudasa wate ꞌediya ꞌitagwala, ꞌenega tuta boboꞌana ꞌiyamwena be ꞌaene Yesu ꞌediya ꞌida telesipupuye be sigiyai, ta geyaꞌabo tomota matadiya. ");
INSERT INTO dob_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ꞌEnega niꞌatu Ataona Sagalina ꞌana ꞌasiyata ꞌimai be pwalawa nigeya gieseseinamo siꞌaꞌani, ta wate lamiyao siunudi Ataona ꞌana ꞌebe nuwaꞌiꞌita manuna. ");
INSERT INTO dob_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ꞌEnega Yesu ꞌina tononoyao Yoni ta Pita ꞌadi emataluwa ꞌiꞌebwaꞌedi, ꞌigwae, “Watatauya be Ataona masulina manuda wagibubu.” ");
INSERT INTO dob_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ga taudi sigwae, “Mane ꞌena nuwanuwayo be ꞌagibubu?” ");
INSERT INTO dob_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ꞌEnega ꞌediya ꞌigwae, “Watatauya be Yelusalema ꞌena waapwesa ta ꞌabo tai ꞌebweuna ma ina ꞌebe gobwasi ꞌiꞌaalina waloba, tai nina wamuliye, be ꞌabo anuwaya ꞌilugulugu ꞌomi wate anuwa nina ꞌena walulugu, ");
INSERT INTO dob_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","be tonianuwa waeona, wagwae, ‘ꞌIma toeꞌita gete nadigega ꞌionaꞌesa, ꞌigwae, “To sena ꞌutagwale be ꞌena ma igu tononoyao Ataona masulina ꞌaꞌaꞌani?” ’ ");
INSERT INTO dob_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Be ꞌenega ꞌiabe sena sinabwana etanaya ta gibugibubunaya ꞌieꞌitami, tauna ꞌena Ataona masulina wagibubu manuda.” ");
INSERT INTO dob_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ꞌEnega tonono nidi sitauya ga toꞌase nadigega Yesu ꞌisimanena ꞌediya yage nidi maiboꞌadi silobedi, ga anuwa nina ꞌena Ataona masulina sigibubuna manudi. ");
INSERT INTO dob_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ta niꞌatu ꞌeꞌai sigibubuna Yesu ma ꞌana tosimanao simiya egogonama ga maꞌenao siꞌeꞌai, ");
INSERT INTO dob_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ga ꞌidi ꞌeꞌai solanaya Yesu ꞌieonedi, ꞌigwae, “Nuwanuwagu sinabwana be ꞌomi maꞌegwao Ataona masulina gete tada ꞌani be ꞌenega muliyega ꞌigu ꞌelouyao yalobadi. ");
INSERT INTO dob_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ta onaꞌaiꞌaila, ꞌigu ꞌeꞌai gete ꞌana ꞌebe losalowa, be geyaꞌabo wate Ataona masulina yalotolotoo lima ꞌana laba ꞌana mwalatoi ꞌaiꞌaila ꞌida apwesa Yaubada ꞌina ꞌebeloina ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ꞌEnega oine makeigana ꞌiꞌewena ga manuna ꞌilokagutoki Yaubada ꞌena ga muliyega ꞌieonedi, ꞌigwae, “Keiga gete waꞌewa be ꞌebweuna ꞌebweuna maiboꞌami wanunuma. ");
INSERT INTO dob_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ta yaeonami tuta gete be mulinaya oine gete geyaꞌabo ꞌenega yanumanuma limana ga ꞌana laba Yaubada ꞌina loina ꞌiapwesa.” ");
INSERT INTO dob_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","20","ꞌEnega beledi ꞌiꞌewena ga manuna ilokagutoki Yaubada ꞌenaya ga muliyega ꞌigitomwena ga ꞌediya ꞌieguyai ta ꞌieonedi, “Oogu gete, ");
INSERT INTO dob_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ta waꞌita tai nina tauna ꞌiabe ꞌitelesipupuyegu maꞌiyagu gete tuga ꞌaꞌeꞌai. ");
INSERT INTO dob_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ꞌAboꞌagu Tomota Natuna maꞌetamo yatatauya ꞌeda nina lowa Yaubada ꞌiloinena, ta esi ꞌagu tosipupu nina nuwaꞌoleꞌolena saꞌi!” ");
INSERT INTO dob_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ꞌEnega ꞌina tononoyao nidi taudimo ꞌediya sienaida, sigwae, “Yaita sana be gote nadigega ꞌida guinuwaꞌesa?” ");
INSERT INTO dob_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ꞌEnega tonono nidi ꞌediyega egewagewana ꞌiapwesa ꞌaene yaita ꞌida loetana maiboꞌadi ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Baleꞌuya kiniyao ꞌidi tomotaiyao ꞌediya siloiloina, ga toguinuwao nidi ꞌidi toloinao siꞌawa boboꞌanedi, ");
INSERT INTO dob_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ta ꞌomi geyaꞌabo nadigega taudi, ta esi yaita tauna ꞌemiyega ꞌiloetana ꞌida loꞌubuna be tauna ꞌatuwa ꞌimi ꞌaliꞌei, ta wate ꞌimi toanuganao sida etoguinuwa manumi. ");
INSERT INTO dob_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Ta toꞌase wanuwena, ꞌaene yaita toloetana ꞌabo tai ꞌebweuna ꞌimiyatowa be ꞌiꞌeꞌai ta ꞌebweuna manuna ꞌietaetapewa? Nai tauna toꞌai, aga? Ta ꞌaboꞌagu yanuwena nai toetapewa nigu, manuna waꞌita ꞌaboꞌagu gete tuga gamwagamwanimiya manumi yaetaetapewa ga ꞌaboꞌagu ꞌatuwa ꞌimi ꞌaliꞌei. ");
INSERT INTO dob_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Onaꞌaiꞌaila, ꞌomi ꞌigu tuta mwau ꞌediyega watoolo paꞌala ga gete tuga ꞌomi maꞌegwao tamiyami. ");
INSERT INTO dob_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ꞌEnega toꞌase nadigega Tamagu ꞌigu ꞌebeloina ꞌiꞌebwaꞌegu ꞌomi wate nadigega yada ꞌebwayaꞌesemi, ");
INSERT INTO dob_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","be ꞌenega ꞌomi ꞌigu ꞌebeloina ꞌenaya maꞌegwao tada ꞌeꞌai be tanunuma, be wate ꞌebemi esaesa ꞌediya wamiyatowa be me Isileli ꞌidi susuyao tuwelo wada loinedi.” ");
INSERT INTO dob_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ꞌEnega wate Yesu ꞌigwae, “Saimoni, ꞌuda enono, Seitani niꞌatu tagwala ꞌiꞌewena be maiboꞌami ꞌida toomi, nadigega tuga tobagula ꞌina witiyao ꞌiꞌaututu toodi, ");
INSERT INTO dob_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ta geyaꞌabo ꞌebe toona nina ꞌena ꞌuneeneta ꞌaiꞌaila, manuna niꞌatu manuyo yasida waiwai ꞌimu toolopaꞌala manuna. Be ꞌenega ꞌabo to tuta ꞌusanaila ꞌeda boboꞌana ꞌenaya, tasimwao wate ꞌugie waiwaiyedi.” ");
INSERT INTO dob_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ꞌEnega Pita ꞌiona, ꞌigwae, “ꞌInapwana, niꞌatu yapasima manuyo be ꞌabo deliya sisaꞌu luguyeyo, ꞌaboꞌagu wate maꞌiyayo, ta ꞌabo wate siloemwawasiyo, ꞌaboꞌagu wate nadigega sida loemwawasigu.” ");
INSERT INTO dob_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ta Yesu ꞌieonena, “Pita, yaona ꞌaiꞌaila ꞌemuya, batuwa muliyega be kakaleko ꞌigwagwane, ta ꞌoyo ꞌuda gimi eyaseyaseyegu matoi.” ");
INSERT INTO dob_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ꞌEnega Yesu maiboꞌadi ꞌieonedi, ꞌigwae, “Lowa yaetune apwesemi ga yaeonemi, ꞌenega nigeya ꞌimi mani ꞌana ꞌebeusa nai ꞌimi tana nai ꞌami ꞌaelawa waꞌewaꞌewadi, ta mwaꞌadega tuta nina ꞌena mwau walobenaya?” Ga taudi sigwae, “Nigeya ꞌebweu wate toꞌase.” ");
INSERT INTO dob_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ꞌEnega Yesu wate ꞌieonedi, “Gete tuga be ꞌimi mani ma ꞌana ꞌebeusa be ꞌimi tana wate waꞌewadi. Ta ꞌabo yaita ꞌemiyega nigeya ꞌina sisisaiyamo, ꞌana talaꞌapwala ꞌida egimwaneye be ꞌana maisa ꞌenega ꞌina sisisaiya ꞌigimwane. ");
INSERT INTO dob_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“Manuna tuta niꞌatu ꞌimai saba, be ꞌenega Buki Tabu ꞌena lowa ꞌebweu ona manugu siꞌetoladinaya, ꞌida apwesa ꞌaiꞌaila, ꞌigwae, ‘Sietalaena ꞌatuwa nadigega ꞌebweu toleꞌoa loina’. Be wate ona yauna manugu siapwesa ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ga taudi ꞌina ona sieꞌisena, sigwae, “ꞌInapwana ꞌima sisisaiyao ꞌeluwa gete.” Ta Yesu ꞌigwae, “Nate sawesawenaya.” ");
INSERT INTO dob_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ꞌEnega Yesu ꞌasa sinabwana ꞌiebesinena ga ma ina tononoyao siila limana ꞌOya Olibe ꞌenaya. Tuta yauna nadigega ꞌidi guinuwa. ");
INSERT INTO dob_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Sena nina ꞌena simai ga Yesu ꞌina tononoyao ꞌieonedi, “Wada sidasida Yaubada ꞌena be ꞌenega geyaꞌabo Seitani ꞌitootoomi.” ");
INSERT INTO dob_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ga muliyega ꞌina tononoyao nidi ꞌediyega ꞌiadumaduma ga taunamo nada ꞌiꞌaetulasa ga ꞌisidasida Tamana ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ꞌigwae, “Tamagu ye, ꞌabo nuwanuwayo, ꞌelouya keigana gete ꞌeguyega ꞌuda ꞌewayaule. Ta geyaꞌabo ꞌaboꞌagu ꞌigu nuwena ꞌenega, ta ꞌoyo esi ꞌimu nuwena ꞌenega ꞌuda guinuwa.” ");
INSERT INTO dob_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ꞌEnega anilose galewega ꞌiapwesa ga Yesu ꞌigie ꞌatepatuyena, ");
INSERT INTO dob_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ta nuwana ꞌimwau wawasae, ꞌenega ꞌisida waiwai ga ꞌana amweyai sipesupesu baleꞌuya, ꞌatuwa nadigega lala ꞌidaudau. ");
INSERT INTO dob_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesu ꞌina sidasida ꞌilosalonina ꞌenega ꞌitoolo ga ꞌiila limana ꞌina tononoyao ꞌediya, ta nuwamwau ꞌenega niꞌatu siꞌeno mwataya, ");
INSERT INTO dob_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ꞌenega ꞌieonedi, ꞌigwae, “Geyaꞌabo waꞌenoꞌeno, ta watoolo be wasidasida be geyaꞌabo Seitani ꞌitootoomi.” ");
INSERT INTO dob_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ꞌetamo ꞌionaona ta boda siapwesama, ta Yudasa maꞌediya, tauna Yesu ꞌina tonono ꞌebweu, ga boda nidi ꞌianuganedima. Yudasa nina ꞌimai Yesu selabenaya be ꞌaene ꞌiꞌatubwaili, ");
INSERT INTO dob_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ꞌenega Yesu Yudasa nina ꞌieonena, ꞌigwae, “Yudasa, nigeya ꞌuomayamaya ta ꞌumai ga ꞌaboꞌagu Tomota Natuna ꞌatubwailega ꞌutelesipupuyegu!” ");
INSERT INTO dob_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ta Yesu ꞌina tononoyao nidi niꞌatu simwalatonina toꞌase ꞌiabe ꞌiapwesa, ꞌenega sigwae, “ꞌInapwana, mwaꞌadega, taunudi?” ");
INSERT INTO dob_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ꞌEnega ꞌebweuna ꞌina tonono nina ꞌina sisisaiya ꞌigilagasina ga totaliya sinabwana ꞌina toguinuwa tena ꞌataina ꞌiꞌupwa yaulena. ");
INSERT INTO dob_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ga Yesu ꞌiona, “Walosaꞌu! Geyaꞌabo nadigega!” Ga muliyega Yesu tai nina tenana ꞌigitoona ga ꞌigie boboꞌanena. ");
INSERT INTO dob_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu ꞌana togiyainao nidi taudi totaliyao sinabwadi be Anuwa Tabu ꞌana toꞌitaꞌiꞌitao be ꞌinapwanao simai, ga Yesu ꞌieonedi ꞌigwae, “Sana ꞌaboꞌagu toꞌipwala, ga ꞌenega ma imi sisisaiya be ma imi wapasi wamai sabi giyaigu! ");
INSERT INTO dob_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ta toꞌase ꞌalena ga ꞌenega nigeya wagiyagiyaigu ꞌasiyata nidi yaudi gamwagamwanimiya yamiyami Anuwa Tabu solanaya, ta yaeꞌieꞌita tomota ꞌediya? Ga gete tuga ꞌaene watoo be wagiyaigu manuna loina guguyoi ꞌina tuta niꞌatu ꞌimai saba.” ");
INSERT INTO dob_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ꞌEnega Yesu sigiyaina ga siꞌauꞌewena totaliyao ꞌidi ꞌinapwana ꞌina anuwaya. Ta Pita ꞌedasolega ꞌimuliyedi. ");
INSERT INTO dob_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Anuwa nina ꞌana ꞌali solanaya toguinuwao kaiwe simuꞌena ga maiboꞌadi sisiyasiyata. Pita ꞌiꞌitedi ga ꞌediya wate ꞌilugu. ");
INSERT INTO dob_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ꞌEnega topaisewa ꞌebweu mewainena Pita ꞌiduneduneyena ga ꞌigwae, “Tai gete lowa Yesu maꞌiyana yaꞌitedi.” ");
INSERT INTO dob_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ta Pita ꞌieyaseyase, ꞌigwae, “Waine, nigeya yamwalamwalatoni yaita tauna manuna ꞌuonaona.” ");
INSERT INTO dob_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Muliyega ꞌebweu wate tai Pita ꞌiduneduneyena ga ꞌieonena, ꞌigwae, “ꞌOyo ꞌebweu ꞌana tomuliya nina.” Ga Pita ꞌigwae, “Iyaa! ꞌAboꞌagu nigeya!” ");
INSERT INTO dob_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ta niꞌatu tupwana simiyaꞌamana, ga tai ꞌebweu wate ꞌenana waiwaina ꞌenega gosenao ꞌieonedi, ꞌigwae, “Onaꞌaiꞌaila, tai gete Yesu ꞌana tomuliya ꞌebweu, manuna sana tauna goma Galili.” ");
INSERT INTO dob_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ta Pita ꞌigwae, “Gosiyagu, tai nina manuna ꞌuonaona nigeya yamwalamwalatoni.” ꞌEtamo ꞌionaona ta kakaleko meꞌolotona ꞌigwane. ");
INSERT INTO dob_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ꞌEnega Yesu ꞌisanaila ga Pita ꞌiduneyena, ga gote ꞌena Pita ꞌinuwaꞌiꞌisina ꞌinapwana nina ꞌina ona tuta nina ꞌigwae, “Batuwa, muliyega be kakaleko ꞌigwagwane ta ꞌoyo ꞌuda gimi eyaseyaseyasegu matoi.” ");
INSERT INTO dob_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ꞌEnega Pita nuwana ꞌimwau sinabwana ga ꞌiapwesa ꞌatamanaya ga ꞌidedoi. ");
INSERT INTO dob_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ꞌEnega Yesu ꞌana toꞌitaꞌiꞌitao taudi Yesu situyeyena ga sisapina. ");
INSERT INTO dob_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ta wate matana sipaimina be geyaꞌabo ꞌidunedune, ga sisapisapiya ta sienaenaide, sigwae, “ꞌUeonama yaita ꞌisapimu? Manuna ꞌuona ꞌaene ꞌoyo palopita.” ");
INSERT INTO dob_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ga wate ꞌaina ona toꞌumalidi ꞌediyega sieliyena ga ꞌana laba ");
INSERT INTO dob_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","tomwa ꞌiulisina, ta ꞌenega me Yudia ꞌidi ꞌinapwanao, nate totaliyao sinabwadi be loina ꞌana toeꞌitao sideli egogona, ga Yesu simeꞌena, ga gamwagamwanidiya sietoolona, ");
INSERT INTO dob_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ta sienaidena, sigwae, “ꞌUsimana palupalu ꞌemaya mwaꞌadega ꞌoyo Toꞌetoseyana niyo, nai nigeya?” ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Nigeya waemiemisegu, ꞌenega geyaꞌabo yasimasimana ꞌemiya, ");
INSERT INTO dob_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","manuna ꞌabo enaida yaꞌebwaꞌemi geyaꞌabo waeꞌieꞌisadi. ");
INSERT INTO dob_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ta wada mwalatoni ꞌaene tuta gete ꞌenega be muliyega ꞌaboꞌagu Tomota Natuna yada miyami Yaubada Toewaiwai sana ꞌatainaya.” ");
INSERT INTO dob_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ꞌEnega maiboꞌadi sigwae, “Aga, tumada! ꞌOyo Yaubada natuna?” ꞌEnega ꞌidi ona ꞌieꞌisena, ꞌigwae, “Niꞌatu waona saba.” ");
INSERT INTO dob_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ꞌEnega taudi siona, “Niꞌatu ꞌina onagesi taloba sabena, ꞌenega geyaꞌabo wate ꞌana toeꞌewao manudi tanuwanuwa, manuna niꞌatu ꞌikabo ꞌaene tauna Yaubada natuna.” ");
INSERT INTO dob_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ꞌEnega maiboꞌadi sitoolo ga Yesu siꞌauꞌewena ga sitauyena toloina sinabwana ꞌana esana Pailato ꞌenaya, sabi etalaena. ");
INSERT INTO dob_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Sitauyena Pailato nina ꞌena ga Yesu manuna sisimana kabokabo, sigwae, “Tai gete ꞌina eꞌita ꞌanonodi be ꞌaene ꞌaboꞌama me Yudia ꞌiagesiyema, nate ꞌigwae, ‘Geyaꞌabo kini Sisa ꞌana takisi wasaꞌusaꞌu, manuna ꞌaboꞌagu kini nina, ta Toꞌetoseyana nigu.’” ");
INSERT INTO dob_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ꞌEnega Pailato Yesu ꞌienaidena, ꞌigwae, “ꞌUda simana, ꞌoyo me Yudia ꞌidi kini, aga?” Ga ꞌieonena, ꞌigwae, “Niꞌatu nate ꞌuona saba.” ");
INSERT INTO dob_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ga muliyega Pailato totaliyao be bodao ꞌieonedi, ꞌigwae, “Tai gete nigeya ꞌebweu ꞌina toꞌumalina yalobaloba.” ");
INSERT INTO dob_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ta taudi tuga sieꞌewa ꞌiꞌisina, sigwae, “ꞌIkabokaboeyo nate, manuna niꞌatu ꞌalobena tomota ꞌikabokaboedi be ꞌaene gabemaniyao ꞌediyega ꞌiweyalidi. Manuna niꞌatu Galili ꞌena ꞌina kabo ꞌieꞌalena ga Yudia senanao maiboꞌadi ꞌiloegumwalidi ga niꞌatu ꞌiapwesama sena gete ꞌena.” ");
INSERT INTO dob_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ꞌIdi ona gete Pailato ꞌinonona ga ꞌieonedi, “Mwaꞌadega tauna goma Galili, aga?” ");
INSERT INTO dob_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ga taudi siona, “O, nadigega.” ꞌEnega Pailato ꞌieonedi, ꞌigwae, “Galili nate Elodi ꞌina ꞌebeloina, ꞌenega Yesu watauye Elodi ꞌenaya be tauna ꞌiloine, manuna gete tuga Elodi bada Yelusalema ꞌena ꞌimiyami.” ");
INSERT INTO dob_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sitauyena Elodi ꞌenaya, ga tuta nina Elodi Yesu ꞌiꞌitena ꞌigwausowala sinabwana, manuna tuta dudulana Elodi nina nuwanuwana be Yesu ꞌiꞌita, manuna tetelina ꞌinononaya, ꞌenega ꞌina guinuwa waiwaidi nuwanuwana be ꞌiꞌitadi. ");
INSERT INTO dob_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ꞌEnega Elodi Yesu ꞌienaida wawasaena, ta nigeya ꞌebweu wate ꞌieꞌieꞌisa. ");
INSERT INTO dob_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ga totaliyao sinabwadi be loina ꞌana toeꞌitao silaga Elodi ꞌenaya ga Yesu sieꞌewa ꞌiꞌisina. ");
INSERT INTO dob_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ta ꞌenega Elodi ma ina tolosaiyao Yesu situyeyena ta siꞌawa toꞌumaliyena. Ga muliyega kini ꞌana ꞌoama sieꞌotena ga sietune limena Pailato ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ꞌAsiyata nina ꞌena Elodi be Pailato ꞌidi egamwagamwagu tuta dudulana ꞌenega siegosigosiyana. ");
INSERT INTO dob_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ꞌEnega Pailato totaliya sinabwadi be ꞌinapwanao be ꞌaina me Yudia nidi ꞌibwau egogonedima, ");
INSERT INTO dob_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ga ꞌieonedi, ꞌigwae, “Tai gete ꞌeguya wameꞌena ga wasimanena ꞌaene tomota ꞌiagesiyedi, ta niꞌatu matamiya yaetalaena ta nigeya ꞌebweu ꞌina toꞌumalina yalobaloba ꞌimi eꞌewao nidi ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elodi wate nigeya ꞌebweu toꞌumalina ꞌenaya ꞌilobaloba, ꞌenega ꞌedaya ꞌietune ilenama. ꞌEnega nigeya wate loemwawasa ꞌilobwelobwene, ");
INSERT INTO dob_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ta esi sapi namo ꞌida loba ta ꞌenega yatagwale be ꞌitatauya.” ");
INSERT INTO dob_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(-) ");
INSERT INTO dob_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ꞌEnega boda nidi sibwau leleleya, sigwae, “Tauna ꞌimwamwawasa, ta esi Balaba ꞌuda ꞌetoliꞌami manuma.” ");
INSERT INTO dob_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba nina loemwawasa manuna deliya sisaꞌunaya, manuna sena nina ꞌena lowa Balaba magosenao me Loma silosaiyedi, ga ꞌaina tomota ꞌiloemwawasidi. ");
INSERT INTO dob_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ta Pailato nuwanuwana be Yesu ꞌiꞌetoliꞌami, ꞌenega pwalu wate ꞌienaidedi, ");
INSERT INTO dob_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ta taudi saꞌi sibwau toitoila, sigwae, “Kelose ꞌena tada tutuepaꞌiye!” ");
INSERT INTO dob_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailato ꞌina ona ꞌetonina ꞌenaya ꞌieonedi, ꞌigwae, “Toꞌase sana ꞌina loegesi ga ꞌenega ꞌaene mwawasa ꞌiloba? Manuna nigeya ꞌebweu wate toꞌumalina ꞌena yalobaloba. Ta esi sapi namo ꞌilobwenena be muliyega yaꞌetoliꞌami.” ");
INSERT INTO dob_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ta boda nidi saꞌi ꞌetamo sibwaubwau toitoila, sigwaegwae, “Kelose ꞌenaya tada tutuepaꞌiye!” Ga boda nidi ꞌidi ona ꞌiewaiwai, ");
INSERT INTO dob_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ꞌenega Pailato ꞌediya ꞌitagwala be Yesu sida giekeloseye. ");
INSERT INTO dob_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ta tai nina nuwanuwadi be ꞌaene ꞌiꞌetoliꞌami manudi, ꞌiꞌetoliꞌamina, tauna toloemwawasa nina deliya sisaꞌunaya, lowa tuta nina tauna me Loma ꞌidi toanuganao ꞌilosaiya ꞌediya. ꞌEnega Pailato nina pwalu nimadiya Yesu ꞌisaꞌuna, be ꞌidi nuwanuwa nina sida losaloni. ");
INSERT INTO dob_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Niꞌatu Yesu siꞌauꞌewena ga sitautauya, ta ꞌedaya ꞌebweu tai ꞌana esana Saimoni silobena, tauna goma Sailini, mitawega ꞌiapwesama ga ꞌitautauya ꞌasaya. ꞌEnega tolosaiyao nidi Saimoni nina sididigena ga Yesu ꞌana kelose ꞌiꞌaalena ga ꞌimuliya. ");
INSERT INTO dob_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ga boda sinabwana Yesu simuliyena, ta wate iine yaudi simulimuliya ta sidedoi ma idi nuwamwau Yesu manuna. ");
INSERT INTO dob_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ta Yesu ꞌisanaila ga iine nidi ꞌieonedi, “ꞌOmi Yelusalema iinediyao, geyaꞌabo manugu wadedo, ta ꞌomi taumi manumi be natumiyao manudi wada dedoi, ");
INSERT INTO dob_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","manuna tuta ꞌimeemai ꞌenaya mwau ꞌiapwesa be yaisigedi ꞌomi megagalimi nai nigeya natumimo ꞌiabe boboꞌana waloba. ");
INSERT INTO dob_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Manuna tuta nidi ꞌediya ꞌiabe tomota ꞌoya ꞌediya sioona be sigwae, ‘ꞌOya wabeꞌuma be wasiuma!’ ");
INSERT INTO dob_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Onaꞌaiꞌaila, ꞌaboꞌagu ꞌiabe yaesilae, ta ꞌomi maꞌetamo waesilae geyogeyoi. Manuna ꞌaboꞌagu ꞌatuwa kaiwe mamaꞌigu, ta ꞌomi tuga ꞌatuwa kaiwe mwawamwawasidi.” ");
INSERT INTO dob_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ta totoꞌumalidi ꞌeluwa wate siꞌauꞌewedi be Yesu maꞌenao sida loemwawasidi. ");
INSERT INTO dob_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ꞌEnega ꞌebweu sena ꞌena siapwesa, ꞌana esana Bulubulu, ga sena nina ꞌenaya kelose baleꞌuya sisaꞌunaya ta Yesu situtu epaꞌiyena ga sietoolona, ta totoꞌumalina nidi siteluwa wate ꞌadi kelose ꞌediya situtu epaꞌiyedi, ga ꞌebweuna Yesu ꞌatainega ta ꞌeluwena Yesu gegeuminega sietoolodi. ");
INSERT INTO dob_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ꞌEnega Yesu ꞌigwae, “Tamagu ye, ꞌidi guinuwa gete ꞌuda nuwataudi, manuna nigeya simwalamwalatoni toꞌase siguiguinuwa.” Ta tolosaiyao nidi Yesu ꞌana ꞌoama siꞌewena, ga ꞌenega siesaesasala, ꞌatuwa nadigega siulaesinuwa, be ꞌenega ꞌabo yaisigedi sinunugana ꞌoama nidi siꞌewadi. ");
INSERT INTO dob_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gote ꞌena tomota siyoꞌoyoꞌo, ta me Yudia ꞌadi toanuganao Yesu situyetuyeyena, sigwaegwae, “Mali tomota ꞌiꞌetoseyedi ta abaga gete tuga tauna ꞌida ꞌetoseye, ꞌabo tauna Toꞌetoseyana Keliso, Yaubada ꞌenega.” ");
INSERT INTO dob_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tolosaiyao nidi wate Yesu situyeyena, ga oine dalelena simeꞌena ga sieꞌetotuꞌeyena, ");
INSERT INTO dob_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ta sigwae, “ꞌAbo ꞌoyo me Yudia ꞌidi toloina, ꞌuda ꞌetoseyeyo tauyo.” ");
INSERT INTO dob_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ta wate ꞌana kelose debanaya ꞌina mwawasa ꞌalena siꞌetoladina, ꞌigwae, “Tai gete me Yudia ꞌadi toloina.” ");
INSERT INTO dob_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kelose nidi ꞌediyega ꞌebweu totoꞌumalina Yesu ꞌiꞌena paꞌalina, ꞌigwae, “Toꞌase manuna ꞌoyo Toꞌetoseyana, ta nigeya ꞌuꞌetoꞌetoseyeda?” ");
INSERT INTO dob_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ta totoꞌumalina ꞌeluwena gosiyanana ꞌiꞌena paꞌalina, ꞌigwae, “Mwaꞌadega Yaubada nigeya ꞌumatamataute? Ta ꞌunono tatetoi ꞌada loina ꞌebweuna tuga siꞌebwaꞌeda, ");
INSERT INTO dob_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ta loina nina ꞌoyo be ꞌaboꞌagu ꞌilobweneda, manuna ꞌaboꞌada totoꞌumalida, ta tai gete nigeya ꞌebweu ꞌina loegesimo.” ");
INSERT INTO dob_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ꞌEnega tai nina Yesu ꞌieonena, “Yesu, maꞌetamo ꞌimu etoloina ꞌana tutaya, kapekapeyana be ꞌuda nuwaꞌiꞌisigu?” ");
INSERT INTO dob_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ta Yesu ꞌigwae, “Yaona ꞌaiꞌaila ꞌemuya, ꞌoyo ta ꞌaboꞌagu ꞌiabe sena boboꞌana ꞌena tada miyami.” ");
INSERT INTO dob_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ta niꞌatu ꞌasuoleole ga sinala ꞌiguguyoi, ꞌenega sena maiboꞌana ꞌiguguyoi ga ꞌana laba ꞌasuinuwanuwaya ꞌasa ꞌimaedana limana. ");
INSERT INTO dob_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ta kaleko nina ꞌenega Anuwa Tabu sipitaupena, tuta nina ꞌena ꞌiesabuluwena. ");
INSERT INTO dob_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ꞌEnega Yesu ꞌenana sinabwanega ꞌibwau, ꞌigwae, “Tamagu ye, yaluyaluwagu nimamuya yasaꞌusaꞌu.” ꞌIna ona gete ꞌiꞌinanena ꞌenega yawasina ꞌigumwala. ");
INSERT INTO dob_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Gote ꞌena tolosaiyao ꞌadi toanugana ꞌiꞌitena ꞌaene Yesu yawasina ꞌigumwala, ꞌenega Yaubada ꞌitupuna, ꞌigwae, “Onaꞌaiꞌaila, tai gete tai boboꞌana.” ");
INSERT INTO dob_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ta wate toyoꞌo maiboꞌadi sena nina ꞌena siegogonaya Yesu siꞌitena ꞌaene niꞌatu ꞌimwawasa, ꞌenega ma idi nuwamwau siila ꞌidi ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ta Yesu gosenao be wate iine nidi lowa Galiliyega simuliyenamaya, taudi ꞌedasolaya sitootoolo ta Yesu ꞌina mwawasa sidunedune. ");
INSERT INTO dob_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","ꞌEbweu tai ꞌana esana Yosepa, Yudia taina, ꞌina ꞌasa gidalina Alimatia, tauna tai boboꞌana ta ma ꞌana emisa. Tai nina ꞌebweu me Yudia ꞌidi toanugana, ta ꞌiyamwayamwa be to tuta Yaubada ꞌida etoloina me Yudia ꞌediya. Lowa tuta nina toanuganao nuwanuwadi be Yesu sida loemwawasi, ta Yosepa nina geya nuwana. ");
INSERT INTO dob_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tai nina Pailato ꞌenaya ꞌitauya, ga Yesu kokowana ꞌisidena be ꞌaene ꞌida saꞌuꞌaliꞌaliye. ");
INSERT INTO dob_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ꞌEnega Pailato ꞌitagwala, ga Yosepa Yesu kokowana kelose ꞌenega ꞌiꞌewa mwaꞌutenama, ga ꞌiwaduna kaleko wakewakekena ꞌenega, ga muliyega ꞌisaꞌu ꞌaliꞌaliyena. ꞌAliꞌali nina sibwalena ꞌatuwa duluwa gulewa solanaya, ta nigeya ꞌebweu tuta kokowa ꞌena sida saꞌuna. ");
INSERT INTO dob_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ꞌAsiyata gote ꞌena me Yudia ꞌidi tuta gibubuna ꞌidi Sabate manuna. ");
INSERT INTO dob_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ta iine nidi taudi Galiliyega Yesu simulimuliyenamaya sitauya ga Yesu ꞌana ꞌaliꞌali siꞌitena, ta wate kokowana ꞌana ꞌebesaꞌu siꞌitena. ");
INSERT INTO dob_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ꞌEnega siila limana ꞌasaya ga bunama boboꞌana sigibubuna Yesu bwalana ꞌana eolowa manuna, ga ꞌasiyata mulinaya sieyawaiꞌata, manuna Sabate ꞌina loina. ");
INSERT INTO dob_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ꞌEnega wate tomwa ꞌiulisina, nate wiki ꞌana ꞌasiyata nugana gonagonaya, ga iine nidi bunama nina sigibubunaya siꞌewena ga simeꞌena ꞌaliꞌaliya. ");
INSERT INTO dob_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Simai ga ꞌaliꞌali siꞌitena ꞌawana ꞌana ꞌauboda gulewa niꞌatu sipuli ilena. ");
INSERT INTO dob_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ꞌEnega ꞌaliꞌali nina solanaya silugu, ta ꞌinapwana Yesu kokowana nigeya siꞌitaꞌita. ");
INSERT INTO dob_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ꞌEnega ꞌaliꞌali nina ꞌenaya ma idi enuwanaluwa simiyami ta sidunedune, ga tuta gidalina ꞌenaya tai ꞌeluwa ma ꞌadi ꞌoama wakewakekedi ta maemaedanidi siapwesa, ga selabediya sitoolo. ");
INSERT INTO dob_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Iine tai nidi siꞌitedi ga simatauta, ꞌenega sibeꞌu sanamwaꞌuta baleꞌuya, ta ꞌoloto nidi iine ꞌediya sigwae, “Toꞌase manuna tomwawasa ꞌidi senaya tai mayawasina waꞌebeꞌebese? ");
INSERT INTO dob_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tauna nigeya bada, ta ꞌina ona nina ꞌemiya wada nuwaꞌiꞌisi lowa Galili ꞌena maꞌemi wamiyamiya, tuta nina ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘ꞌAboꞌagu Tomota Natuna sida ꞌebwayaegu totoꞌumalidi ꞌediya, ꞌenega kelose ꞌenaya sida tutu epaꞌiyegu, ta ꞌasiyata ꞌetonina ꞌenaya mwawasega yada toololimana.’” ");
INSERT INTO dob_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iine nidi ona gete sinuwaꞌiꞌisina, ");
INSERT INTO dob_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ꞌenega ꞌaliꞌali sipilisinena ga sitauya Yesu ꞌina toguinuwao site ilebeni magosediyao ꞌediya, ga sisimana toꞌase nadigega ꞌaliꞌaliya ꞌediya ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Toemwasala nidi taudi Meli Magidala be Yowana be mali Meli, tauna Yemesa sinana, ta wate ꞌaidi iine maꞌediyao, Yesu ꞌina toololimana manuna ꞌina toguinuwao nidi sieonedi, ");
INSERT INTO dob_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ta tai nidi iine ꞌidi ona nigeya siemiemise, ꞌidi nuwanuwa ꞌaene tuga situyetuyeya. ");
INSERT INTO dob_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","(-) ");
INSERT INTO dob_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ꞌAsiyata nina ꞌenaya Yesu ꞌana tomuliyao ꞌeluwa sitautauya ꞌebweu ꞌasa ꞌenaya, ꞌana esana Emeusa. ꞌAsa nina ꞌana ꞌedasola Yelusalema ꞌenega nadigega ꞌabo gonagonega tatoolo be gonagona nina ꞌana gamwagamwana ꞌenaya taapwesa. ");
INSERT INTO dob_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Siteluwa nidi sitautauya ta sionaona yage nidi Yesu ꞌena siapwesa manudi. ");
INSERT INTO dob_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sitautauya ta siꞌawaꞌawagwae liya, ꞌenega Yesu ꞌediya ꞌiapwesa ga maꞌedi sitautauya. ");
INSERT INTO dob_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yesu nina niꞌatu siꞌitena, ta esi nigeya siꞌinaꞌinane. ");
INSERT INTO dob_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ꞌEnega siteluwa nidi ꞌieonedi, ꞌigwae, “To yage manuna waꞌawaꞌawagwae liya?” Ga taudi ma idi nuwamwau sitoolo enono. ");
INSERT INTO dob_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ga gosiyanana ꞌana esana Kaliopasa ꞌiona limana ga Yesu ꞌena ꞌigwae, “Na ꞌoyo tebweumumo Yelusalema ꞌenaya nigeya ꞌumwalamwalatoni toꞌase ꞌiapwesa ꞌasiyata ꞌetoi sigumwala ꞌediya, aga?” ");
INSERT INTO dob_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ꞌEnega Yesu ꞌieonedi, “To yage sana?” Ga taudi sigwae, “Yage nidi Yesu goma Nasaleta ꞌenaya siapwesa. Tai getei tauna palopita, ta wate Yaubada be tomota matadiya ꞌina onao be ꞌina guinuwao waiwaidi. ");
INSERT INTO dob_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ta ꞌima totaliya sinabwadi be ꞌima toanuganao tai nina sietalaena ꞌina mwawasa manuna ga muliyega tolosaiyao situtu epaꞌiyena kelose ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ta ꞌaemisena ꞌaene tauna ꞌiabe ꞌaboꞌama me Isileli ꞌiꞌetoseyema. Yage getedi ꞌasiyata ꞌeluwa sigumwala ꞌediya siapwesa, ta batuwa ꞌasiyata ꞌetonina. ");
INSERT INTO dob_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ta ꞌaina iine ꞌemega nuwama sigieowanina, manuna niꞌa gonamapumapuya sitauya ꞌaliꞌaliya ");
INSERT INTO dob_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ga Yesu nina kokowana nigeya siꞌitaꞌita, ta siilama ga toꞌase nadigega anilose ꞌidi eꞌita ꞌediya ga sisimana ꞌemaya ꞌaene niꞌatu ꞌitoolo limana. ");
INSERT INTO dob_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wate nadigega ꞌaidi ꞌemega sitauya ꞌaliꞌali nina ꞌenaya ga silobena nadigega iine nidi ꞌidi simana, ta Yesu nina nigeya siꞌitaꞌita.” ");
INSERT INTO dob_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ꞌEnega Yesu ꞌediya ꞌigwae, “Kwanikwanimi, manuna nigeya gimi palopitao ꞌidi onao wada emisedi. ");
INSERT INTO dob_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Toꞌetoseyana nina ꞌilobwene ꞌaiꞌailina be ꞌelouya nidi ꞌida lobadi be ꞌenega muliyega ꞌana esana ꞌisinabwa.” ");
INSERT INTO dob_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ꞌEnega ꞌieꞌale be ꞌediya ꞌiliꞌama toꞌase nadigega Buki Tabu ꞌina simana Toꞌetoseyana nina manuna. Mosese be palopitao ꞌidi bukiyao ꞌediyega ꞌieꞌale ga Buki Tabu maiboꞌana ꞌiloegumwalina, be ꞌenega mwalatoi sida loba. ");
INSERT INTO dob_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ta sena nina ꞌena sitautauya niꞌatu be selabenaya siapwesa ga Yesu ꞌieonedi, ꞌigwae, “Wamiyamiya ta yatatauya.” ");
INSERT INTO dob_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ga taudi sigwae, “Nigeya! Geyaꞌabo ꞌutautauya, bada taꞌeꞌeno, manuna niꞌatu ꞌiboi.” ꞌEnega ꞌitagwala ga ꞌilugu ꞌidi anuwaya. ");
INSERT INTO dob_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ꞌIdi tuta ꞌeꞌai ꞌenaya, Yesu beledi ꞌiꞌewena ga manuna ꞌiona oboboma, ga muliyega ꞌigitomwena ga ꞌiꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Gote ꞌena nuwadi ꞌisabwalena ga Yesu nina siꞌinanena, ta ꞌediyega ꞌikwaiya. ");
INSERT INTO dob_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ꞌEnega siteluwa nidi taudimo ꞌediya sionaona, sigwae, “Onaꞌaiꞌaila tuta nina ꞌedaya tameema, ta ꞌiliꞌaliꞌama Buki manuna, ꞌada lotoona sidumaduma wawasae ꞌatuwa kaiwe ꞌatedaya ꞌisabesabelulu.” ");
INSERT INTO dob_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ꞌEnega sitoolo manini ga sitauya Yelusalema, ga nada gosediyao silobedi site ilebeni magosediyao simiya egogona, ");
INSERT INTO dob_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ta taudi Yesu manuna sionaona, sigwae, “Saimoni niꞌatu ꞌInapwana ꞌiꞌitena, mwawasega ꞌitoolo limana.” ");
INSERT INTO dob_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ꞌEnega siteluwa nidi silolagata ga wate siemwasala toꞌase nadigega ꞌedaya ꞌiapwesa, ta wate ꞌina gitomwa beledi ꞌenega siꞌinanena, siemwasalina. ");
INSERT INTO dob_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ꞌEtamo gosediyao ꞌediya siemwaemwasala ta Yesu nina ꞌiapwesa ga gamwagamwanidiya ꞌitoolo, ");
INSERT INTO dob_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ga siꞌitena ta simatauta, ꞌidi nuwanuwa ꞌebweu yaluyaluwa biꞌi. ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Geyaꞌabo wamatamatauta! ");
INSERT INTO dob_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ta geyaꞌabo wate waenuenuwanaluwa. ꞌAboꞌagu tuga. ");
INSERT INTO dob_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ta esi nimagu be ꞌaegu wada ꞌitadi ta wagitoogu, manuna yaluyaluwa biꞌi nigeya bwalanamo, ta wate nigeya lulunamo.” ");
INSERT INTO dob_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","(-) ");
INSERT INTO dob_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Gote ꞌena sigwausowala, ta esi tupwana ma idi enuwanaluwa manuna nigeya siemiemisa ꞌaiꞌaila. Ta ꞌieonedi, “Masula ꞌeisa, waꞌebwaꞌegu be yaꞌaꞌa?” ");
INSERT INTO dob_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ta iyana tupwana mesomesona siꞌebwaꞌena, ");
INSERT INTO dob_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ga matadiya ꞌiꞌenina. ");
INSERT INTO dob_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ta ꞌieonedi, ꞌigwae, “Ona nidi niꞌatu yaemwasalidi ꞌemiya tuta nina ꞌaboꞌagu maꞌemi, maiboꞌana manugu siꞌetoladina Mosese ꞌina buki ꞌenaya be palopitao ꞌidi buki ꞌediya ta wate wali Same ꞌediya, be ꞌenega ꞌigu simana nina ꞌana mwalatoi ꞌaiꞌaila ꞌida apwesa.” ");
INSERT INTO dob_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Gote ꞌena nuwadi ꞌigiesabwalenina ga Buki Tabu simwalatonina. ");
INSERT INTO dob_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ga ꞌediya ꞌigwae, “Gete nadigega siꞌetoladiꞌesena, ꞌigwae, Toꞌetoseyana nina ꞌelouya be mwawasa ꞌida loba, be ꞌenega ꞌasiyata ꞌetonina ꞌena mwawasega ꞌida toololimana, ");
INSERT INTO dob_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","be ꞌenega ꞌana esanega tetela boboꞌana, nuwaꞌebuni be toꞌumalina ꞌana nuwatau manudi sida guguyae. ꞌIdi guguya nina sida eꞌale Yelusalema ꞌenega be ꞌida sakowasi baleꞌu maiboꞌana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yage getedi ꞌomi tuga ꞌadi tosimanao. ");
INSERT INTO dob_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ta esi ꞌaboꞌagu ꞌiabe Tamagu ꞌina onaupaupa nina nate yaluyaluwana yada etunenama ꞌemiya be ꞌida giewaiwaiyemi, ꞌenega Yelusalema ꞌena wada yamwayamwa manuna.” ");
INSERT INTO dob_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ꞌEnega ꞌina ona ꞌilosalonina, ga muliyega ꞌiꞌauꞌewedi ga sitauya Betani ꞌenaya, ga nada nimana ꞌiasitotoona ꞌediya ga ꞌiona obobomedi. ");
INSERT INTO dob_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ꞌIna ona oboboma nina ꞌenaya, ꞌaena ꞌiꞌewena ga ꞌituꞌe galewaya. ");
INSERT INTO dob_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Taudi ꞌina ꞌebetuꞌe nina ꞌena ma idi ꞌamayaba sibwagobwago, ga muliyega ma idi gwausowala sinabwana siila limana Yelusalema. ");
INSERT INTO dob_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Siila ga Anuwa Tabu solanaya tuta yauyauna Yaubada situputupu. ");
INSERT INTO dob_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tuta ꞌana ꞌebe eꞌale ꞌunuya Ona ꞌimiyami. Ta Ona nina tauna Keliso, Yaubada maꞌiyana, ta tauna Yaubada nina. ");
INSERT INTO dob_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tuta nina ꞌana ꞌebe eꞌale ꞌenaya, Ona nina Yaubada maꞌiyana simiyami, ");
INSERT INTO dob_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ta Ona nina, tauna Keliso, Yaubada maꞌiyana yage maiboꞌadi simweluluidi, ta nigeya ꞌebweu wate yaita tomweluluwa, ta Ona nina tuga. ");
INSERT INTO dob_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tauna yawasi ꞌaiꞌaila, ta yawasi nina ꞌenega maedana ꞌimeꞌena tomota yauyauda ꞌedaya. ");
INSERT INTO dob_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ta maedana nina guguyoi ꞌenaya ꞌisae, ga guguyoi nigeya ꞌina waiwaimo. ");
INSERT INTO dob_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Gote ꞌena Yaubada tai ꞌebweuna ꞌietunenama, ꞌana esana Yoni. ");
INSERT INTO dob_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tauna tomota ꞌediya ꞌimai be ꞌaene tomota ꞌediya maedana manuna ꞌida simana be ꞌenega tomota sida nono be ꞌidi emisa sida saꞌu maedana nina ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ta tauna nigeya maedana nina, ta esi maedana ꞌana tosimana. ");
INSERT INTO dob_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ta maedana nina maedana ꞌaiꞌaila ga me baleꞌu maiboꞌada ꞌituyayalida. ");
INSERT INTO dob_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tauna niꞌatu ꞌimai baleꞌuya ga baleꞌuya ꞌimiyami, ta tauna tuga baleꞌu ꞌana tomweluluwa, ta tomiya baleꞌu nigeya simwalamwalatoni yaita tauna. ");
INSERT INTO dob_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ta tuta nina tauna ꞌimai ꞌina buꞌunao ꞌediya taudi wate sieꞌidiꞌidiyena. ");
INSERT INTO dob_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ta esi tomota puꞌepuꞌedimo ꞌina ona siemisena ꞌaene tauna Toꞌetoseyana nina, ga ꞌediya ꞌitagwala be taudi Yaubada natunao. ");
INSERT INTO dob_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ꞌEnega tomota getedi tada eesedi ꞌaene taudi niꞌatu situbuwa limana, ta tubuwa limana nina nigeya nadigega tomota laladi nai ꞌidi nuwanuwa ꞌenega, ta esi tubuwa limana nina Yaubada ꞌenega. ");
INSERT INTO dob_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ona nina niꞌatu ꞌedaya ꞌietomotai, ga ꞌina esaesa ꞌena ꞌaꞌitena, tosinabwa sana ꞌituyayalina, manuna tauna Yaubada natuꞌaiꞌailina, ta wate tauna tooboboma ta adelina palupaluna maiboꞌana. ");
INSERT INTO dob_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ꞌEnega Yoni ꞌisimanena ga ꞌibwau, ꞌenana sinabwana ꞌenega ꞌigwae, “Tauna gete tai nina manuna yaonaona tuta nina yasimanena ꞌaene ꞌebweu muliguyega ꞌimamai be ꞌida nuganegu, manuna muliyega be yamamai ta tauna niꞌatu ꞌimiyami.” ");
INSERT INTO dob_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tauna toꞌebwaya boboꞌana, ga ꞌina obobomega maiboꞌada ꞌiloemaeda. ");
INSERT INTO dob_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mosese ꞌina ꞌebwaya boboꞌana, nate loina nidi Buki Tabu ꞌena, ta esi Yesu Keliso ꞌina ꞌebwaya boboꞌana wawasae, manuna oboboma be bubuna boboꞌana ꞌiꞌebwaꞌeda. ");
INSERT INTO dob_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nigeya ꞌebweu tuta Yaubada ꞌana ꞌita tomota sida ꞌitena, nate namo natuꞌaiꞌailina selabenaya ꞌimiyami, ꞌenega tauna Tamana ꞌana ꞌita nina niꞌatu ꞌieꞌiteda. ");
INSERT INTO dob_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tuta gote ꞌenaya me Yudia ꞌidi toanuganao Yelusalema ꞌenaya simiyami, ga ꞌaidi totaliyao be ꞌaidi Libai ꞌina bodao sietunedi Yoni ꞌenaya sabi enaidena ꞌaene tauna yaita. ");
INSERT INTO dob_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ga Yoni eꞌisa boboꞌana ta maemaedanina ꞌiꞌebwaꞌedi, ꞌigwae, “ꞌAboꞌagu nigeya Toꞌetoseyana nina.” ");
INSERT INTO dob_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ꞌEnega wate sienaidena ga sigwae, “Ta yaita ꞌoyo? ꞌAene ꞌoyo Ilaitiya, aga?” Ga ꞌiona, “ꞌAboꞌagu nigeya.” Ta wate sienaidena, “Nai ꞌoyo palopita nina Mosese manuna ꞌionaonaya?” Ga Yoni wate ꞌieꞌisa ga ꞌigwae, “Nigeya.” ");
INSERT INTO dob_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ꞌEnega taudi wate sigwae, “Ta sana yaita ꞌoyo? Toꞌase ꞌimu ona manuyo, be ꞌenega ꞌada ila be ꞌama toetuneyao ꞌada emataluwedi?” ");
INSERT INTO dob_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ꞌEnega Yoni ꞌidi enaida ꞌieꞌisena ga ꞌisimana apwesa, ꞌigwae, “Lowa palopita Aisea ꞌina buki ꞌena manugu ꞌisimana gete nadigega: Tai ꞌebweu sena mitawa daita ꞌena ꞌibwaubwau, ꞌigwaegwae, ‘ꞌInapwana ꞌina ꞌeda wada kakali ta wagiepaepalu.” ’ ");
INSERT INTO dob_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ta Palisiyao ꞌadi toepilialeale nidi ");
INSERT INTO dob_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yoni sienaida limena, sigwae, “ꞌEguma ꞌoyo nigeya Toꞌetoseyana nina, nai ꞌoyo nigeya Ilaitiya, nai ꞌoyo wate nigeya mali palopita, toꞌase manuna ꞌugiegie bapitaiso?” ");
INSERT INTO dob_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ta Yoni ꞌieonedi, “ꞌAboꞌagu bwasiyega tuga tomota yagiegie bapitaisoedi, ta ꞌebweu tai nigeya wamwalamwalatoni gamwagamwanimiya gete tuga ꞌitootoolo, ");
INSERT INTO dob_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","tauna muliguyega ꞌimeema, ta ꞌaboꞌagu nigeya ꞌilobwelobwenegu be ꞌana ꞌaelawa yada liꞌami, manuna tauna toesaesa sana.” ");
INSERT INTO dob_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Gete yage nidi maiboꞌadi siapwesa sena Betani ꞌenaya nate Yoni ꞌina ꞌebe giebapitaiso senanaya, bwasi Yolidani mali esenaya. ");
INSERT INTO dob_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ga mali ꞌasiyataya Yoni Yesu ꞌiꞌitena ꞌimeemai ꞌenaya, ga Yoni tomota ꞌieonedi, ꞌigwae, “Tai gote tauna Yaubada ꞌina Lami, be me baleꞌu manuda ꞌimwamwawasa be ꞌida bubuna toꞌumalina maiboꞌana ꞌiꞌewayauledi. ");
INSERT INTO dob_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lowa gete tai nina manuna yaonaona, tuta nina yaeonemi ꞌaene tai ꞌebweuna muliguyega ꞌimamai be ꞌida nuganegu, manuna muliyega be yamamai ta tauna niꞌatu ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ta nigeya yamwalamwalatoni ꞌaene yaita tauna, ta nate namo tuga ꞌaboꞌagu me Isileli bwasiyega yagiegie bapitaisoemi be ꞌenega muliyega tauna wada mwalatoni.” ");
INSERT INTO dob_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ona gete Yoni ꞌisimana apwesa Yesu manuna, ga ꞌediya ꞌigwae, “Yaluyaluwa Tabuna yaꞌitena ꞌana ꞌita nadigega bunebune galewega ꞌimwaꞌutama ga Yesu ꞌena ꞌitowa. ");
INSERT INTO dob_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Lowa nigeya yamwalamwalatoni yaita tauna, ta Yaubada tauna ꞌietuneguma be bapitaiso bwasiyega yada guinuwedi, ga ꞌeguya ꞌisimanena, ꞌigwae, ‘ꞌEtamo Yaluyaluwagu ꞌuda ꞌita ꞌida mwaꞌutama be tai ꞌena ꞌitotowa, tauna nate Yaluyaluwa Tabunega ꞌida giebapitaiso tomota ꞌediya.’ ” ");
INSERT INTO dob_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ta Yoni wate ꞌieonedi, “ꞌAboꞌagu tai nina mata ꞌaiꞌailiguyega yaꞌitena, ꞌenega gete yasimasimana apwesa ꞌaene tauna Yaubada natuꞌaiꞌailina.” ");
INSERT INTO dob_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta mali ꞌasiyataya, tuta nina Yoni be ꞌana tomuliyao ꞌeluwa maꞌenao sitootoolo, ga Yesu siꞌitena selabediyega ꞌitautauya, ");
INSERT INTO dob_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ꞌenega Yoni ꞌana tomuliyao nidi ꞌediya ꞌigwae, “Tai gote tauna Yaubada ꞌina Lami.” ");
INSERT INTO dob_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gote ꞌena siteluwa nidi Yoni ꞌina ona sinonona, ga Yesu simuliyena. ");
INSERT INTO dob_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ꞌEnega Yesu mulinega sitautauya ta ꞌediya ꞌisanaila, ga ꞌiꞌitedi. Ta ꞌienaidedi, ꞌigwae, “Toꞌase nuwanuwami?” Ta taudi sigwae, “Labai, mwaꞌo ꞌimu ꞌebemiya?” (Labai ꞌana gibui Toeꞌita.) ");
INSERT INTO dob_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ta Yesu ꞌieonedi, ꞌigwae, “Wamuliyegu be ꞌenega ꞌigu ꞌebemiya yaeꞌitami.” Ta simuliyena, ga asuinuwanuwaya siapwesa sena nina ꞌenaya, ga nada simiya ebonina. ");
INSERT INTO dob_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tomuliya nidi siteluwa ꞌediyega ꞌebweu ꞌana esana Anidulu, tauna Saimoni Pita tasina. ");
INSERT INTO dob_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anidulu ꞌilomanini ga tasina ꞌilobena ta ꞌieonena, ꞌigwae, “Saimoni, niꞌatu Mesaiya nina ꞌalobena.” (Mesaiya ꞌana gibui Keliso, nate ꞌena Gilisi, ta ꞌana mwalatoi Toꞌetoseyana.) ");
INSERT INTO dob_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ga Saimoni ꞌiꞌauꞌewena ga Yesu ꞌena ꞌimeꞌena. Gote ꞌena Yesu Saimoni ꞌiꞌitena ga ꞌieonena, ꞌigwae, “ꞌOyo ꞌamu esana Saimoni, Yoni natuna, ta ꞌamu esana auwauna yada bwauye Pita, ꞌana gibui Gulewa.” ");
INSERT INTO dob_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ga mali ꞌasiyataya Yesu nuwanuwana be ꞌitatauya Galili, ꞌenega ꞌitauya ga nada Pilipi ꞌilobena, ga ꞌieonena, ꞌigwae, “ꞌUda muliyegu.” ");
INSERT INTO dob_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipi ꞌina ꞌasa Beteseida, nate Anidulu be Pita ꞌidi ꞌasa. ");
INSERT INTO dob_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ꞌEnega Pilipi Nataniela ꞌilobena, ga ꞌieonena, “Niꞌatu tai nina ꞌalobena, tauna lowa Mosese ꞌina loinao ꞌediya ta wate palopitao ꞌidi ꞌetoladiyao ꞌediya sisimanena, tauna goma Nasaleta, ta Yosepa natuna, ꞌana esana Yesu.” ");
INSERT INTO dob_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ga Nataniela Pilipi ꞌena ꞌigwae, “Nasaleta nigeya ꞌebweu toꞌase boboꞌana ꞌenega ꞌida apwesa.” Ga Pilipi ꞌigwae, “Tuwa tuga, ꞌuda mai be tai nina ꞌuda ꞌita.” ꞌEnega Yesu ꞌena simai. ");
INSERT INTO dob_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ga tuta nina Yesu Nataniela ꞌiꞌitena ga tomota ꞌieonedi Nataniela manuna, ꞌigwae, “Tai gote tauna goma Isileli ta nigeya ꞌebweu wate kabo ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ta Nataniela Yesu ꞌienaidena, ꞌigwae, “Mwaꞌadega ga ꞌenega ꞌumwalatonigu?” Ga Yesu ꞌigwae, “Muliyega be Pilipi ꞌibwauyeyo, ta ꞌaboꞌagu yagimi ꞌitemu damaya ꞌagalaunaya ꞌumiyami.” ");
INSERT INTO dob_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Gote ꞌena Nataniela nuwana ꞌiowana ga Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌoyo onaꞌaiꞌaila Yaubada Natuna, ta ꞌoyo wate me Isileli ꞌima kini.” ");
INSERT INTO dob_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ga Yesu ꞌieonena, “ꞌUemiseguya manuna yaeonemu ꞌaene tuta nina ꞌoyo damaya ꞌagalaunaya yaꞌitemu, aga? Gete tuga ꞌebeꞌita gidalina ꞌemuya, ta maꞌetamo esi yage sinabwadi ꞌuda ꞌitadi.” ");
INSERT INTO dob_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ta Yesu wate ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya ꞌaene maꞌetamo galewa ꞌegeꞌegegena ꞌena Yaubada ꞌina aniloseyao waꞌitadi, situꞌetuꞌe be simwaꞌumwaꞌutama ꞌaboꞌagu Tomota Natuna manugu.” ");
INSERT INTO dob_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ga niꞌatu ꞌasiyata ꞌeluwa sigumwala ga ai sagalina siguinuwena ꞌasa Kena ꞌena, Galili senanaya. Ta sagali nina solanaya Yesu sinana ꞌimiyami, ");
INSERT INTO dob_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ga Yesu ma ina tononoyao sagali nina ꞌena sibwauyedi ga maꞌediyao silugu ga siꞌeꞌai. ");
INSERT INTO dob_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tuta nina ꞌidi ꞌeꞌai solanaya ga ꞌadi oine siloegumwalina, ꞌenega Yesu sinana ꞌigwae, “Natugu, oine maiboꞌana niꞌatu ꞌigumwala.” ");
INSERT INTO dob_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ga Yesu ꞌigwae, “ꞌOyo geyaꞌabo ꞌuloiloinegu, manuna ꞌigu guinuwa nigeya yaeꞌaeꞌale.” ");
INSERT INTO dob_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ga Yesu sinana topaisewao ꞌieonedi be ꞌaene Yesu ꞌina ona sida ematamatane, ꞌigwae, “ꞌEguma toꞌase nuwanuwana be waguinuwei, wada guinuwe tuga.” ");
INSERT INTO dob_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tuta nina ꞌenaya me Yudia ꞌidi bubuna, nate ꞌebesiwa siguinuwedi gulewa ꞌenega, ꞌidi ꞌebe loꞌutu manuna. Ta sagali nina ꞌenaya ꞌebesiwa nidi sikisi Yesu ꞌiꞌitedi. Taudi kakaedi ta sinabwadi, sawesawenaya be bwasi sinabwa wawasae sisiwadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ꞌEnega Yesu topaisewao ꞌieonedi ga ꞌebesiwa nidi kakaedi bwasiyega siloemaedi. ");
INSERT INTO dob_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ga wate ꞌieonedi ga tupwana bwasi ꞌebesiwa nidi soladiyega sigonidi ga tonisagali ꞌenaya sitauyedi. ");
INSERT INTO dob_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ga tonisagali bwasi nina ꞌilotoona ꞌaene dumadumana, nigeya bwasi ta esi oine ꞌana lotoona, ta boboꞌana. Ta tonisagali nigeya ꞌimwalamwalatoni ꞌaene oine nina mane ꞌenega siꞌewena, ta topaisewao dimo simwalatonina. ꞌEnega tonisagali nina toai meꞌolotona ꞌibwauyena, ");
INSERT INTO dob_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ga ꞌieonena, ꞌigwae, “ꞌAboꞌada ꞌida bubuna be ꞌaene oine boboꞌana tada ꞌebwaya nugana tomota ꞌediya, be muliyega oine toꞌumalina taꞌebwayae. Ta ꞌoyo toꞌase manuna ga oine toboboꞌana sana ꞌusaꞌu kwaiyena ga ꞌuemuliyena?” ");
INSERT INTO dob_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Gete ꞌena Yesu ꞌina paisewa waiwaina nuganuganina, ꞌana weꞌiweꞌiyaya ꞌigieapwesena ꞌasa Kena ꞌenaya, Galili senanaya, ga ꞌina waiwai ꞌieꞌitaena tomota ꞌediya, ta ꞌina tononoyao tauna siemisena. ");
INSERT INTO dob_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ga sagali mulinaya, Yesu sinana be tasinao ta wate ꞌina tononoyao maꞌenao simwaꞌuta Kapaneumi, ga gote ꞌena ꞌaina ꞌasiyata ꞌediya simiyami. ");
INSERT INTO dob_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ta niꞌatu tuta selabenaya be me Yudia ꞌidi Ataona Sagalina sida guinuwe. Tuta nina ꞌenaya Yesu ꞌituꞌe Yelusalema. ");
INSERT INTO dob_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ꞌEnega Anuwa Tabu solanaya ꞌilugu ga toegimwane ꞌiꞌitedi, taudi bulumakau be sipi be bunebune ꞌadi toegimwaneyao, ta wate mani ꞌana toesaꞌugelasao Anuwa Tabu solanaya simiyami. ");
INSERT INTO dob_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ꞌEnega balae metametana ꞌiꞌewena ga tomota be yobaiyao Anuwa Tabuyega ꞌipaꞌidi, ta wate toesaꞌugelasao ꞌidi tebeli ꞌiꞌaubuiyedi ga ꞌidi mani ꞌilelewanedi, ");
INSERT INTO dob_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ga ꞌenega toegimwane bunebune ꞌieonedi, ꞌigwae, “ꞌImi manuwao maiboꞌadi gete ꞌenega wada ꞌewa apwesedi, ta geyaꞌabo Tamagu ꞌina anuwa wagiegiebaili be ꞌaene ꞌimi ꞌebe gimwane.” ");
INSERT INTO dob_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ta ꞌina tononoyao ona nina Buki Tabu solanaya sinuwaꞌiꞌisina, ꞌigwae, “Yaubada ye, ꞌimu anuwa toboboꞌana sana gete nuwagu ꞌiꞌewena.” ");
INSERT INTO dob_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ꞌEnega me Yudia ꞌadi toanuganao simai ga Yesu sienaidena, sigwae, “To weꞌiweꞌiyaya ꞌuda eꞌitama be ꞌada mwalatoni yaita sana ꞌina loinega yage getedi ꞌuguiguinuwedi?” ");
INSERT INTO dob_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ta Yesu ꞌediya ꞌigwae, “Anuwa gete ꞌeguma waligei, ꞌasiyata ꞌetoi ꞌena yada ꞌabilima.” ");
INSERT INTO dob_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ga taudi wate sigwae, “ꞌAene anuwa gete ꞌasiyata ꞌetoi ꞌena ꞌuda ꞌabilima? Ta ꞌuda nuwaꞌiꞌisi ꞌaene anuwa gete yakwala poti sikisi solanaya siꞌabiꞌabi ga ꞌenega silosalonina.” ");
INSERT INTO dob_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ta Yesu nigeya anuwa nina manuna ꞌionaona ta esi tauna bwalana manuna. ");
INSERT INTO dob_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ꞌEnega tuta nina Yesu mwawasega ꞌitoolo limana ga ꞌina tononoyao Buki Tabu ꞌina ona be wate Yesu ꞌina ona ꞌediyega sinuwaꞌiꞌisina, ga siemisa ꞌaiꞌailidi. ");
INSERT INTO dob_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tuta nina Yesu Ataona Sagalina solanaya ꞌimiyami ga tomota yaudi Yesu ꞌina guinuwa waiwaina siꞌitena, ꞌenega siemisena ꞌaene tauna Toꞌetoseyana. ");
INSERT INTO dob_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ta Yesu nigeya ꞌiemiemisedi, ");
INSERT INTO dob_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","manuna niꞌatu maiboꞌadi ꞌidi nuwanuwa ꞌigimi sinapudi, ga ꞌenega nigeya ꞌebweu yaita tomota sawesawenaya be tetelidi ꞌida ꞌebwaya Yesu ꞌenaya, manuna toꞌase ꞌidi nuwanuwa ꞌatediya niꞌatu ꞌisinapu ꞌaiꞌailidi. ");
INSERT INTO dob_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tai ꞌebweu ꞌana esana Nikodimo, tauna ꞌebweu Palisi, ta wate me Yudia ꞌadi toanugana, ");
INSERT INTO dob_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ga boiboiya ꞌimai Yesu ꞌenaya ga ꞌieonena, ꞌigwae, “ꞌInapwana, ꞌamwalamwalatoni ꞌaene ꞌoyo toeꞌita Yaubada ꞌenega, manuna nigeya ꞌebweu yaita ꞌina guinuwa ꞌana waiwai nadigega ꞌoyo, ꞌabo Yaubada nigeya maꞌiyana.” ");
INSERT INTO dob_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ta Yesu ꞌilolagata ga ꞌieonena, “Yaona ꞌaiꞌaila ꞌemuya, ꞌeguma nigeya ꞌutubutubuwa limana, geyaꞌabo Yaubada ꞌina ꞌebeloina ꞌuꞌitaꞌita.” ");
INSERT INTO dob_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ta Nikodimo Yesu ꞌienaidena, ꞌigwae, “Mwaꞌadega ꞌaboꞌagu tai sinabwagu be ꞌaene yada tubuwa limana? Onaꞌaiꞌaila nigeya sawesawenaya be sinagu gamwanaya yalulugu be yatubuwa limana.” ");
INSERT INTO dob_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ta Yesu ꞌiona limana, “Yasimana ꞌaiꞌaila ꞌaene ꞌeguma nigeya bwasiyega be Yaluyaluwa Tabuna ꞌenega ꞌutubutubuwa, geyaꞌabo Yaubada ꞌina ꞌebeloina ꞌenaya ꞌulugulugu. ");
INSERT INTO dob_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sinadao ꞌediyega tatubuwenama bwala namo, ta yaluyaluwada ꞌina tubuwa limana Yaubada Yaluyaluwana ꞌenega. ");
INSERT INTO dob_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Geyaꞌabo ꞌunuwanuwa owana manuna yaeonemu be ꞌaene wada tubuwa limana. ");
INSERT INTO dob_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nadigega tuga yagila ꞌina towa, be mane ꞌenega nuwanuwana be ꞌitotowa tuga ꞌida towa, ta ꞌenana ꞌuda nonodi ꞌidududuma, ta nigeya ꞌuda mwalatonina mane ꞌenega yagila ꞌimeemai nai mane ꞌena ꞌitautauya. Nadigega wate taudi yaluyaluwa ꞌenega situbuwa limana. ");
INSERT INTO dob_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ga Nikodimo Yesu ꞌienaidena, ꞌigwae, “ꞌImu ona gete mwaꞌadega ꞌana mwalatoi?” ");
INSERT INTO dob_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ta Yesu ꞌigwae, “ꞌOyo me Isileli ꞌidi toeꞌita sinabwayo, ta ꞌigu ona gete manuna nigeya ꞌunuwanuwa sabwalena. ");
INSERT INTO dob_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yasimana palupalu ꞌemuya ꞌaene yage nidi niꞌatu ꞌaꞌitedi ta ꞌamwalamwalatonidi ꞌenega ꞌasimasimanedi ꞌemiya, ta nigeya ꞌima onao nidi wada emisedi. ");
INSERT INTO dob_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ꞌEguma yage baleꞌu manudi ꞌemiya yasimasimana ta nigeya wada emisedi, mwaꞌadega be yage galewa manuna yaeꞌitaꞌesa? ");
INSERT INTO dob_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Manuna nigeya ꞌebweu yaita galewaya ꞌituꞌetuꞌe. Nate namo ꞌaboꞌagu Tomota Natuna, manuna ꞌaboꞌagu galewega yagimi mwaꞌutama. ");
INSERT INTO dob_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nadigega tuga lowaenei tuta nina sitautauya sena mwatui daitaya, ga Mosese mwata kainumu ꞌenega ꞌiguinuwenaya ta kaiwe ꞌena ꞌigilagasina, ꞌaboꞌagu nadigega sida gilagasigu ");
INSERT INTO dob_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","be ꞌenega yaisigedi ꞌeguya siemisa, yawasidi ataya sida loba. ");
INSERT INTO dob_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ta Yaubada saꞌi tomota maiboꞌadi baleꞌuya ꞌiobobomedi ga natuna tebweuna ꞌitagwalena be ꞌenega yaisigedi tauna ꞌena siemisa, geyaꞌabo simwawamwawasa ta esi yawasidi ataya sida loba. ");
INSERT INTO dob_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ta Yaubada Natuna baleꞌuya ꞌietunenama, nigeya ꞌaene tomiya baleꞌu ꞌida bwaꞌomatadi, ta esi sabi ꞌetoseyedi. ");
INSERT INTO dob_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“ꞌEguma yaita Yaubada Natuna ꞌiemisei, geyaꞌabo bwaꞌomatana ꞌilobaloba, ta ꞌeguma yaita nigeya ꞌiemiemisa, tauna niꞌatu loina ꞌena ꞌilugu, manuna nigeya Yaubada natuꞌaiꞌailina ꞌena ꞌiemiemisa. ");
INSERT INTO dob_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Gete loina nina ꞌalena manuna maedana niꞌatu baleꞌuya ꞌimai ta tomotai guguyoi nuwanuwadi, ta maedana siguitoyasena manuna ꞌidi bubuna toꞌumalina. ");
INSERT INTO dob_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ꞌEnega ꞌeguma yaisigedi ꞌidi bubuna toꞌumalina, tomotai nidi maedana siguitoyasena ga nigeya maedana ꞌena sida mai, ꞌabona nai maedana nina ꞌida gieapwesedi ꞌaene taudi ꞌidi bubuna toꞌumalina. ");
INSERT INTO dob_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ta ꞌeguma yaisigedi taudi ꞌidi bubuna palupaluna maedana ꞌena sida apwesa be ꞌenega maedana ꞌida gieapwesedi ꞌaene taudi ꞌidi guinuwa boboꞌana Yaubada ꞌenega.” ");
INSERT INTO dob_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ga tuta muliyega Yesu ma ina tononoyao sitauya ꞌasa sinabwana Yudia ꞌenaya, ga nada ꞌaina ꞌasiyata simiyamiya, ta Yesu tomota ꞌigiegie bapitaisoedi. ");
INSERT INTO dob_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ta Yoni wate tomota ꞌigiegie bapitaisoedi sena Ainoni ꞌenaya, nate Selimi selabenaya, manuna sena nina ꞌenaya bwasi sinabwana. Ga ꞌenega tomota yaudi sitautauya ꞌenaya ta ꞌigiegie bapitaisoedi. ");
INSERT INTO dob_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Gote tuta nina ꞌenaya Yoni maꞌetamo nigeya deliya sisaꞌusaꞌu. ");
INSERT INTO dob_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ta Yoni ꞌaina ꞌana tomuliyao ta ꞌebweuna Yudia taina maꞌedi siegewagewana bapitaiso manuna, ꞌaene yaita ꞌina bapitaiso boboꞌana be tomota ꞌida gieꞌesasedi. ");
INSERT INTO dob_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ꞌEnega toegewagewana nidi Yoni ꞌenaya sitauya ga sieonena, sigwae, “ꞌInapwana, ꞌunuwaꞌiꞌisina tai nina lowa Yolidani mali esenaya maꞌiyayo, ta ꞌemaya ꞌusimana apwesa tai nina manuna, tauna niꞌatu tomota gete tuga ꞌigiegie bapitaisoedi, ga maiboꞌadi ꞌina bapitaiso nuwanuwadi, ga ꞌenaya sitautauya.” ");
INSERT INTO dob_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ta Yoni ꞌieonedi ga ꞌigwae, “Nigeya ꞌebweu yaita sawesawenaya be ꞌietai sinabwa ꞌeguma Yaubada nigeya ꞌena ꞌitagwatagwala. ");
INSERT INTO dob_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Niꞌatu ꞌemiya yaona ga wanonona ꞌaene ꞌaboꞌagu nigeya Keliso nina, ta ꞌaboꞌagu niꞌatu Yaubada ꞌietune nuganeguma be tai nina ꞌimuliyama. ");
INSERT INTO dob_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yesu tauna tuga nadigega toai meꞌolotona ta ꞌaboꞌagu gosiyana, ꞌenega tetelina yanonona ga ma igu gwausowala sinabwana. Nadigega tuga toai meꞌolotona mwanena ꞌilobai, ꞌenega ꞌeguma toai ꞌenana ꞌebweu gosiyana ꞌinonoi, gosiyana manuna ꞌida gwausowala. ");
INSERT INTO dob_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ꞌEnega tauna Yesu ꞌida etoloina, ta ꞌaboꞌagu yada mwaꞌuta. ");
INSERT INTO dob_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tai nina galewega ꞌimai tomota maiboꞌadi ꞌisinabwa sinedi, ta esi yaita tauna baleꞌuyega ꞌimai tauna baleꞌu tomotenina, ꞌenega baleꞌu gwegwenao manudi ꞌionaona. Ta tai nina galewega ꞌimwaꞌutama tomota maiboꞌadi ꞌiloetana sinedi. ");
INSERT INTO dob_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yage nidi niꞌatu ꞌiꞌitedi manudi ꞌisimana apwesa ta nigeya ꞌebweu yaita ꞌinoonodi nai ꞌiemiemisedi ꞌina simana nidi manudi. ");
INSERT INTO dob_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ta ꞌabo yaisigedi ꞌina simana nina siemisena, gote ꞌena siꞌawa ꞌaiꞌaila ꞌaene Yaubada tauna topalupaluna. ");
INSERT INTO dob_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tai nina tauna Yaubada ꞌietunenama, tauna Yaubada ꞌina ona ꞌisimasimane, manuna Yaubada Yaluyaluwanega ꞌiloemaa ꞌaiꞌailina. ");
INSERT INTO dob_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ꞌInapwana Natuna ꞌiobobomena ꞌenega yage maiboꞌana nimanaya ꞌisaꞌuna, ");
INSERT INTO dob_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","be ꞌenega ꞌabo yaita tauna ꞌiemisena yawasina ataya ꞌida loba, ta ꞌabo yaita tauna ꞌiguitoyasena geyaꞌabo wate yawasina ataya ꞌilobaloba, ta esi Yaubada ꞌina gamwasowala ꞌenaya geyaꞌabo ꞌisawasawala.” ");
INSERT INTO dob_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu ꞌina giebapitaisoega ꞌana tomuliyao yaudi ꞌilobedi ta Yoni ꞌana tomuliyao nigeya yaudi. ");
INSERT INTO dob_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ta Yesu tauna nigeya bapitaiso ꞌida guinuwena, ta ꞌina tononoyao dimo siguiguinuwe.) ");
INSERT INTO dob_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ta Yesu ꞌimwalatonina ꞌaene Palisiyao niꞌatu Yesu ꞌina guinuwa alena sinonona, ꞌenega Yudia ꞌipilisinena sabi ilalimana Galili ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ta ꞌina tuta ila ꞌenaya, Samelia ꞌasanao gamwagamwanidiyega ꞌitauya, ");
INSERT INTO dob_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ta Samelia ꞌasana ꞌebweu ꞌana esana Saika ꞌena ꞌiapwesa. Saika ꞌenega be bwaꞌa nina lowa Yekobe natuna Yosepa ꞌiꞌebwaꞌena nigeya ꞌedasola. ");
INSERT INTO dob_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Sena nina ꞌenaya ꞌebweu bwasi gaula ꞌimiyami, tauna Yekobe ꞌiguinuwena, ta Yesu ꞌitauya ga ꞌasuoleoleya sena nina ꞌena ꞌiapwesa, ga niꞌatu ꞌiloꞌameꞌame, ꞌenega ꞌimiyatowa sabi eyawaiꞌata. ");
INSERT INTO dob_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tuta gidalina ꞌenaya ꞌebweu waine Samelia ꞌimai sabi gobwasi, ga Yesu waine nina ꞌiꞌitena ga ꞌena ꞌisida, ꞌigwae, “Waine, bwasi ꞌuda ꞌebwaꞌegu be yada numa.” ");
INSERT INTO dob_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tuta gote ꞌena taunamo ꞌimiyami, manuna ꞌina tononoyao niꞌatu sitauya ꞌasa sinabwana ꞌena ꞌadi masula sabi gimwane. ");
INSERT INTO dob_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Gote ꞌena waine Samelia Yesu ꞌena ꞌiona, “ꞌUꞌita ꞌoyo goma Yudiayo ta ꞌaboꞌagu waine Samelia, ta toꞌase manuna ga bwasi ꞌusidena ꞌeguya?” (Manuna me Yudia be me Samelia nigeya sida egosigosiyana.) ");
INSERT INTO dob_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ta Yesu waine Samelia nina ꞌieonena, ꞌigwae, “ꞌEguma ꞌumwalamwalatoni Yaubada ꞌina oboboma ꞌemuya, ta wate ꞌabo ꞌumwalatonina ꞌaene yaita ꞌaboꞌagu numa manuna yasidasidawa, ꞌoyo esi ꞌilobwenemu be ꞌeguya ꞌuda sida bwasi yawasiyo manuna, be yada ꞌebwaꞌeyo.” ");
INSERT INTO dob_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ꞌEnega waine nina ꞌigwae, “ꞌInapwana, nigeya ꞌimu ꞌebe goimo ta wate bwasi gaula ꞌimwaꞌuta wawasae. Ta ꞌaene mane ꞌenega bwasi ꞌuda ꞌebwaꞌegu yawasigu manuna? ");
INSERT INTO dob_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ꞌAene ꞌoyo tubuda Yekobe ꞌuloetana sinena? Tauna Yekobe nina ꞌama bwasi gaula gete lowaenei ꞌiguinuwena ga manatunao be ꞌidi yobaiyao bwasi nina ꞌidi ꞌebe numa.” ");
INSERT INTO dob_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ga Yesu ꞌieonena, “ꞌEguma yaita bwasi gete ꞌenega ꞌinunuma, tonaꞌana ꞌida yapasa limana, ");
INSERT INTO dob_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ta ꞌeguma ꞌebweu yaita bwasi nina ꞌeguyega ꞌinumai, geyaꞌabo wate tonaꞌana ꞌiyapayapasa limana. Manuna bwasi nina tauna yada ꞌebwaꞌe ꞌatenaya be ꞌida ewewelupwa ta yawasina ataya ꞌenega ꞌida loba.” ");
INSERT INTO dob_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ga waine Yesu ꞌena ꞌigwae, “ꞌInapwana, bwasi nina ꞌuda ꞌebwaꞌegu, be ꞌenega tonaꞌagu geyaꞌabo ꞌiyapayapasa, nai wate geyaꞌabo yailaila limanama bwasi gete ꞌenaya sabi goi.” ");
INSERT INTO dob_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ga Yesu ꞌigwae, “ꞌUtauya be mwaneyo ꞌuꞌauꞌewenama.” ");
INSERT INTO dob_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ta waine nina Yesu ꞌieonena, “ꞌAboꞌagu nigeya mwanegumo.” ꞌEnega Yesu wate ꞌiona limana ga ꞌigwae, “Nate onaꞌaiꞌaila ꞌaene nigeya ꞌebweu mwanemumo, ");
INSERT INTO dob_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ta mwanemwao ꞌadi yau nima, ta tai nina ꞌuaina ga maꞌiyayo ꞌasaya wamiyami nigeya mwane ꞌaiꞌailiyo. Toꞌase nadigega ꞌimu ona, nate onaꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Gote ꞌena waine Yesu ꞌina ona ꞌieꞌisena ga ꞌigwae, “ꞌInapwana, niꞌatu yamwalatonimu ꞌaene ꞌoyo palopita ꞌebweu. ");
INSERT INTO dob_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ꞌEnega ꞌuda eona ꞌaiꞌailigu to sena ꞌenaya Yaubada ꞌana bwagobwago ꞌilobwenena? Manuna ꞌaboꞌama tubumao ꞌediyega Samelia ꞌoyana getei ꞌena ꞌalotapwalolo, ta ꞌomi me Yudia waona ꞌaene Yelusalema ꞌebe lotapwalolo ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ta Yesu waine ꞌina ona ꞌieꞌisena ga ꞌigwae, “Waine, ꞌigu ona ꞌuda emise manuna tuta maꞌetamo ꞌena tomota geyaꞌabo sibwagobwago Samelia ꞌoyana gete ꞌenaya nai Yelusalema ꞌena, ");
INSERT INTO dob_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ta ꞌuda mwalatoni ꞌaene me Samelia ꞌomi nigeya wamwalamwalatoni yaita ꞌena wabwagobwago, ta ꞌaboꞌama me Yudia ꞌamwalamwalatoni yaita ꞌena ꞌabwagobwago manuna ꞌetoseyana ꞌemega ꞌiapwesama. ");
INSERT INTO dob_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ta tuta niꞌatu selabenaya, ta wate niꞌatu gete tuga ꞌiapwesa, be taudi Tamada ꞌana tobwagobwago ꞌaiꞌailao ꞌena sida bwagobwago, ta ꞌidi bwagobwago nina yaluyaluwadi maiboꞌana ꞌenega, ta wate ꞌate ꞌaiꞌailidiyega. Taudi gete nadigega tobwagobwago nidi Yaubada nuwanuwana be ꞌena sida bwagobwago. ");
INSERT INTO dob_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yaubada tauna yaluyaluwa tuga, ꞌenega yaisigedi taudi ꞌena sibwagobwago, yaluyaluwadi maiboꞌana ꞌenega ta wate ꞌate ꞌaiꞌailidiyega sida bwagobwago.” ");
INSERT INTO dob_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ta waine Yesu ꞌieonena ga ꞌigwae, “Niꞌatu yamwalatonina ꞌaene maꞌetamo Toꞌetoseyana nina ꞌimamai, tauna sieesena Keliso, ta ꞌabo ꞌimamai, tauna mwalatoi maiboꞌana ꞌedaya ꞌida simanedi.” ");
INSERT INTO dob_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ta Yesu waine ꞌieonena, “ꞌAboꞌagu Toꞌetoseyana nina gete, yaonaonawa.” ");
INSERT INTO dob_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tuta gote ꞌenaya Yesu ꞌina tononoyao niꞌatu siilama ga siꞌitena ꞌidi ꞌInapwana waine nina maꞌiyana siꞌawaꞌawagwae, ga nuwadi ꞌiowana, ta tuwa tuga nigeya ꞌebweu wate yaita ꞌionaona “Toꞌase nuwanuwayo?” nai “Toꞌase manuna waine maꞌiyayo waꞌawaꞌawagwae?” ");
INSERT INTO dob_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ta waine nina ꞌina ꞌebegoi ꞌipilisinena ga ꞌitauya ꞌasaya ga tomota ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ꞌigwae, “Wamai be tai nina wada ꞌita, tauna niꞌatu ꞌieonegu ꞌigu bubuna maiboꞌana manuna. Nai tauna gete Toꞌetoseyana nina.” ");
INSERT INTO dob_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ꞌEnega tomota ꞌasa sinabwana ꞌenega siapwesa, ga Yesu ꞌena simai. ");
INSERT INTO dob_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tuta nina gote ꞌenaya Yesu ꞌina tononoyao sieonaona, “ꞌInapwana, masula gete ꞌuda ꞌa.” ");
INSERT INTO dob_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ga ꞌidi ona ꞌieꞌisena, ꞌigwae, “ꞌAgu masula ꞌomi nigeya wamwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ga ꞌina tononoyao nuwadi ꞌiowana ga taudimo ꞌediya sieonaona, sigwae, “Nai yaita ꞌana masula ꞌimeꞌena?” ");
INSERT INTO dob_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ta Yesu ꞌiona limana ga ꞌediya ꞌigwae, “ꞌAgu masula nate ꞌagu Toetune nina ꞌina nuwanuwa sabi guinuwedi, be ꞌina paisewa sabi losalonina.” ");
INSERT INTO dob_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ta wate ꞌediya ꞌigwae, “ꞌImi ona ꞌebweu ꞌimiyami ꞌaene ‘Nawalae ata mulidiya sesoi ꞌana tuta,’ ta yaona ꞌaiꞌaila ꞌemiya wada ꞌitasakowasi be bagula ꞌana ꞌita wada ꞌita ꞌaene niꞌatu masula ꞌimatuwa, ga ꞌilobwenena be tuta sesoi. ");
INSERT INTO dob_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yaisigedi taudi sisesoi, ꞌadi eꞌisa siloba, ta sesoi nina tomota yawasidi ataya manuna. ꞌEnega ꞌeguma yaisigedi taudi sidaunaya ta yaisigedi taudi sisesoni siegwausowala leleleya. ");
INSERT INTO dob_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ona gete onaꞌaiꞌaila ꞌaene ‘Tai ꞌebweu todauna ta tai ꞌebweuna tosesoi.’ ");
INSERT INTO dob_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ꞌAboꞌagu ꞌInapwana ꞌina sesoi manuna yaetunemi be wada sesoi bagula nina ꞌenega, tauna ꞌena nigeya wabagubagula, ta esi mali tomota ꞌena sibagula be ꞌidi guinuwa ꞌenega ꞌomi sesoi wada guinuwe.” ");
INSERT INTO dob_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ꞌAsa gote ꞌena me Samelia yaudi Yesu siemisena, manuna waine nina ꞌediya ꞌisimana ꞌaene, “Tauna ꞌieonegu ꞌigu bubuna maiboꞌana manuna.” ");
INSERT INTO dob_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ꞌEnega me Samelia Yesu ꞌena simai ga sisidena be ꞌaene maꞌedi sida miyami, ga Yesu nada ꞌasiyata ꞌeluwa ꞌediya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ta wate tomota yaudi Yesu siemisena, ꞌina ona manuna, ");
INSERT INTO dob_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ga waine nina sieonena, sigwae, “Niꞌatu ꞌaꞌawa ꞌaiꞌailemu, nigeya ꞌaene ꞌimu ona namo manuna, ta esi ꞌaboꞌama taumamo ꞌina ona ꞌanonona, ga ꞌenega ꞌamwalatoi ꞌaiꞌailina ꞌaene tauna Toꞌetoseyana nina me baleꞌu maiboꞌada manuda.” ");
INSERT INTO dob_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ga ꞌasiyata ꞌeluwa nidi mulidiya Yesu sena nina ꞌipilisinena, ga Galili ꞌena ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ga gote ꞌena Yesu tauna ꞌina ona gete nadigega ꞌigwae, “Palopita nigeya ꞌebweu wate ꞌadi ꞌamayabamo ꞌeguma taudi ꞌidi sena ꞌena siloguloguguya.” ");
INSERT INTO dob_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Tuta nina Galili ꞌena ꞌiapwesa, me Galili sigwausowala ꞌina mai manuna, manuna Ataona Masulina Yelusalema ꞌena sitauya, ga niꞌatu Yesu ꞌina guinuwa siꞌitena ꞌemasula nina solanaya ꞌiguiguinuwedi. ");
INSERT INTO dob_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ta ꞌenega Yesu wate ꞌiila ꞌasa Kena ꞌena, nate Galili senanaya. Ta lowa sena nina ꞌena bwasi ꞌigibunina ga ꞌieoine. Gote ꞌena ꞌebweu toloina sinabwana natuna meꞌolotona ꞌileꞌoasa Kapaneumi ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tuta nina ꞌinonona ꞌaene Yesu sena Yudia ꞌenega ꞌimai ga Galili ꞌena ꞌimiyami, toloina nina Yesu ꞌena ꞌitauya ga ꞌisida, ꞌigwae, “ꞌAbo sawesawemuya tatatauya Kapaneumi be natugu ꞌana leꞌoasa ꞌuda gieboboꞌane, manuna tuta gidalinamo be yawasina ꞌigugumwala.” ");
INSERT INTO dob_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ga Yesu tai nina ꞌieonena, ꞌigwae, “Nigeya ꞌebweu ꞌomi ꞌemiyega ꞌida emisegu, nate namo ꞌeguma ꞌigu paisewa waiwaina ꞌana weꞌiweꞌiyaya waꞌita, be ꞌenega wada emisegu.” ");
INSERT INTO dob_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ꞌEnega toloina nina ꞌieonena, “ꞌInapwana, ꞌulomanini be tatatauya ꞌabona nai natugu ꞌimwamwawasa.” ");
INSERT INTO dob_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ga Yesu ꞌiona, “ꞌUila ꞌimu anuwaya be natuyo ꞌuda ꞌita ꞌiboboꞌana.” Ga tai nina Yesu ꞌina ona ꞌiemisena ga ꞌiila limana. ");
INSERT INTO dob_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tuta nina ꞌina ila ꞌenaya ꞌina topaisewao ꞌilobedi ga ale siꞌebwaꞌena, sigwae, “Natuyo niꞌatu ꞌana leꞌoasa ꞌigumwagumwala.” ");
INSERT INTO dob_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ꞌEnega ꞌediya ꞌienaida to tuta ꞌena natuna ꞌana leꞌoasa ꞌipilisinena. Ga taudi sigwae, “Boga ꞌasuoleoleya ꞌina yaiyai ꞌisaligogo.” ");
INSERT INTO dob_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ta ꞌenega gwama nina tamana ꞌinuwaꞌiꞌisina gote tuta nina ꞌenaya Yesu ꞌigwae, “Natuyo ꞌida boboꞌana.” ꞌEnega tai nina ma ina susuyao Yesu siemisena. ");
INSERT INTO dob_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Gete Yesu ꞌina paisewa waiwaina ꞌeluwena ꞌana weꞌiweꞌiyaya tuta nina Yudiaega ꞌimai ga Galili ꞌena ꞌipaisewa. ");
INSERT INTO dob_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tuta gete mulinaya ꞌebweu ꞌebe nuwaꞌiꞌita me Yudia siguinuwena Yelusalema ꞌena, ꞌenega Yesu ꞌituꞌe Yelusalema, guinuwa nina manuna. ");
INSERT INTO dob_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ta Yelusalema ꞌena nate sipi ꞌidi ꞌawa selabenaya ꞌebweu bwasi niꞌuniꞌuna ꞌimiyami. Bwasi nina me Yudia ꞌenadiyega sieesena Beteseida. Ta sena nina ꞌena anuwa ꞌebe eyawaiꞌata nima simiyami bwasi tupitupinaya. ");
INSERT INTO dob_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ta anuwa nidi ꞌediya toleꞌoasa yaudi siꞌenoꞌeno, tomatakebokeboyao be, tolopegoiyao be, tokwenoyao be. ");
INSERT INTO dob_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(-) ");
INSERT INTO dob_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ta ꞌebweu ꞌediyega ꞌana leꞌoasa ꞌena ꞌimiyami yakwala teti eita nadigega. ");
INSERT INTO dob_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ta Yesu ꞌiapwesa, ga tai nina ꞌiꞌitena, ta wate ꞌimwalatonina ꞌaene yakwala yauna ꞌana leꞌoasa ꞌena ꞌimiyami, ꞌenega Yesu tai nina ꞌienaidena, ꞌigwae, “Nuwanuwayo be ꞌuboboꞌana?” ");
INSERT INTO dob_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ꞌEnega toleꞌoasa nina ꞌigwae, “ꞌInapwana, nigeya ꞌebweu ꞌagu tolemamo be bwasi gete ꞌena ꞌida saꞌu ebusiyegu, ꞌabo bwasi ꞌina ꞌapwayama ꞌana tutaya. Tuta yauna yatoo be ꞌaene taugumo yaebusi ta nigeya sawesaweguya, ta mali toleꞌoasao sima be siebusi be siboboꞌana, ta ꞌaboꞌagu tuga ꞌagu ꞌitanigu.” ");
INSERT INTO dob_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ꞌEnega Yesu tai nina ꞌieonena, “ꞌUtoolo be ꞌimu sita ꞌuꞌewa be ꞌutatauya.” ");
INSERT INTO dob_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Gote ꞌena tai ꞌiboboꞌana ga ꞌina sita ꞌiꞌewena ga ꞌitauya. Tuta gote ꞌenaya nate ꞌasiyata Sabate. ");
INSERT INTO dob_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ta me Yudia ꞌadi toanuganao tai nina siꞌitena ga ꞌena siona, sigwae, “Toꞌase manuna Sabate ꞌana tuta ta ꞌimu sita ꞌuꞌaalena?” ");
INSERT INTO dob_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ta ꞌidi ona ꞌieꞌisena ga ꞌigwae, “Tai nina ꞌigie boboꞌaneguya ꞌieonegu, ‘ꞌImu sita ꞌuꞌewa be ꞌutatauya.’ ” ");
INSERT INTO dob_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ta wate sienaidena, ga sigwae, “To tai sana ꞌemuya ꞌiona nadigega?” ");
INSERT INTO dob_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ta tai nina tauna ꞌana leꞌoasa ꞌigumwalaya nigeya ꞌimwalamwalatoni to tai, manuna Yesu niꞌatu ꞌitauya ta boda sinabwana sena nina ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tuta muliyega Yesu tai nina ꞌilobena Anuwa Tabu solanaya, ga ꞌieonena, ꞌigwae, “ꞌUꞌita niꞌatu ꞌuboboꞌana, ta geyaꞌabo wate toꞌumalina ꞌuguiguinuwe, ꞌabona nai yage toꞌumali wawasae ꞌemuya ꞌida apwesa.” ");
INSERT INTO dob_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ta tai nina ꞌitauya ga me Yudia nidi ꞌediya ꞌisimana apwesa ꞌaene ꞌana togieboboꞌana tauna Yesu. ");
INSERT INTO dob_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gete ꞌalena ꞌenega me Yudia nidi Yesu sietalauwalena manuna paisewa nina ꞌasiyata Sabate ꞌena ꞌiguinuwena. ");
INSERT INTO dob_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Gote ꞌena Yesu me Yudia nidi ꞌieonedi, ꞌigwae, “Tamagu ꞌasiyata maiboꞌana ꞌediya ꞌipaipaisewa, ꞌenega ꞌaboꞌagu wate nadigega.” ");
INSERT INTO dob_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ta me Yudia nidi ꞌina ona sinonona, ga sitoo waiwai be mwaꞌadega sida loemwawasaꞌese. Manuna ꞌalena Sabate ꞌana loina ꞌileꞌoena ta wate ꞌiona ꞌaene Yaubada tauna tama ꞌaiꞌailina, be ꞌaene Yaubada maꞌiyana sieleleleya. ");
INSERT INTO dob_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ꞌEnega Yesu tomota nidi ꞌieonedi, ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya, ꞌaboꞌagu nigeya sawesaweguya be taugumo yada guinuwa, ta esi ꞌigu guinuwa getei toꞌase nadigega yaꞌitena Tamagu ꞌiguiguinuwe; ꞌenega yage nidi Tamagu ꞌiguiguinuwedi ꞌaboꞌagu wate nadigega yaguiguinuwaꞌesa. ");
INSERT INTO dob_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tamagu ꞌiobobomegu sinabwana ta ꞌenega ꞌina guinuwa toꞌase nadigega ꞌiguiguinuwedi maiboꞌana ꞌieꞌitegu, be wate guinuwa sinabwadi manudi ꞌida eꞌitagu be yada guinuwedi, be ꞌenega nuwami sida owana manudi. ");
INSERT INTO dob_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nadigega tuga Tamagu tomwawasa ꞌigietoolodi ga yawasidi ꞌiꞌebwaꞌedi, ꞌaboꞌagu wate nadigega yawasi auwauna yada ꞌebwaya tomota ꞌediya, yaisigedi taudi yaesinuwedi. ");
INSERT INTO dob_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nigeya ꞌebweu wate Tamagu ꞌina loinamo tomota ꞌadi bwaꞌomatana manuna, manuna bwaꞌomatana ꞌana loina maiboꞌana niꞌatu ꞌiꞌebwaꞌegu, be ꞌaboꞌagu yada guinuwe. ");
INSERT INTO dob_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ꞌEnega maiboꞌami wada ꞌamayabegu tuga nadigega ꞌimi ꞌamayaba Tamagu ꞌena. Ta ꞌeguma yaisigedi taudi nigeya siꞌamaꞌamayabegu, taudi wate Tamagu tauna ꞌietuneguma, nigeya siꞌamaꞌamayabe. ");
INSERT INTO dob_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ꞌEnega yasimana ꞌaiꞌaila ꞌemiya ꞌabo yaisigedi ꞌigu ona sinonodi be tauna ꞌietuneguma siemisei yawasidi ataya sida loba, be geyaꞌabo ꞌasiyata bwaꞌomatana ꞌena silugulugu, manuna niꞌatu mwawasa ꞌina sena sipilisinena ga siabala yawasi auwauna ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ta wate yada eona ꞌaiꞌailimi ꞌaene tuta ꞌiapweapwesama, nai tagwae niꞌatu tuta gete ꞌimai, be tomwawasa Yaubada Natuna ꞌenana sida nono, nate ꞌaboꞌagu ꞌenagu, be taudi ꞌenagu sinonona yawasidi auwauna sida loba. ");
INSERT INTO dob_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tamagu tauna yawasida ꞌalena, ꞌenega niꞌatu ꞌitagwala ꞌeguya be ꞌaboꞌagu wate yawasi ꞌalena. ");
INSERT INTO dob_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ta wate bwaꞌomatana ꞌana loina ꞌiꞌebwaꞌeguya be yada guinuwedi manuna ꞌaboꞌagu yaetomotai baleꞌuya. ");
INSERT INTO dob_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ꞌEnega geyaꞌabo wanuwanuwa owana yage gete manudi. Ta tuta ꞌimeemai ꞌena tomwawasa maiboꞌadi ꞌenagu sida nono, ");
INSERT INTO dob_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","be ꞌaliꞌaliyega sida apwesama, be taudi ꞌidi bubuna boboꞌana yawasidi sida loba, ta taudi ꞌidi bubuna toꞌumalina bwaꞌomatana sida loba. ");
INSERT INTO dob_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ꞌAboꞌagu nigeya sawesaweguya be taugumo guinuwa yaguinuwedi, manuna ꞌigu loina Yaubada tauna ꞌieꞌitegu, ꞌenega ꞌigu loina palupaluna, manuna ꞌaboꞌagu nigeya yatootoo be ꞌigu nuwena taugu yaguinuwei, ta esi toꞌase nadigega tauna ꞌietuneguma ꞌina nuwena yaguinuwei. ");
INSERT INTO dob_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ta ꞌeguma taugumo manugu yasimana apwesa, nate nigeya simana ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ta esi mali tomota tauna manugu niꞌatu ꞌietosimana, ga yamwalatonina toꞌase nadigega ꞌina simana manugu nate ona ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lowa ꞌomi toepilialealeyao ꞌaina waetunedi tai nina Yoni ꞌenaya, ga tauna ona ꞌaiꞌailega ꞌieonedi, ga ꞌemiya sisimana.” ");
INSERT INTO dob_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ta Yesu wate ꞌediya ꞌigwae, “ꞌAboꞌagu nigeya tomota ꞌidi simana manuna yanuwanuwa, ta ona gete yasimanena Yoni manuna, be ꞌaene wada nuwa sabwalena be ꞌetoseyana wada loba. ");
INSERT INTO dob_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ta Yoni nina nadigega mayale tuyatuyayalina, ga ꞌomi lowa tuta gidalina namo ꞌenaya nuwanuwami, ga ꞌina maedana nina ꞌenega wagwaugwausowala. ");
INSERT INTO dob_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Yoni ꞌina simana manugu nigeya yage sinabwana, ta esi ꞌebweu yage sinabwana ꞌimiyami, nate ꞌebeꞌita getedi Tamagu ꞌenega yaguiguinuwedi. ꞌEguma guinuwa nidi manudi wanuwa edaedadama wada nuwasabwaleni ꞌaene Tamagu tauna ꞌietuneguma. ");
INSERT INTO dob_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ta Tamagu wate tauna ꞌisimanegu, ta ꞌomi nigeya ꞌebweu tuta ꞌenana wada nonona, nai maninina wada ꞌitena, ");
INSERT INTO dob_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ta wate ꞌina ona ꞌemiya nigeya ꞌatemiya sida miya. ꞌAlena manuna nigeya waemiemisegu ꞌaene ꞌaboꞌagu Yaubada ꞌenega. ");
INSERT INTO dob_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Tuta yauyauna Buki Tabu wasawasawa ga wanuwena ꞌaene maꞌetamo yawasimi ataya wada loba, ta nigeya wanuwanuwa sabwaleni ꞌaene Buki Tabu nina ꞌisimasimanegu. ");
INSERT INTO dob_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ga ꞌenega geya nuwami be yawasimi ataya manuna wamama ꞌeguya. ");
INSERT INTO dob_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ꞌAboꞌagu nigeya yanuwanuwa taugu ꞌagu tupu tomota ꞌediyega manuna. ");
INSERT INTO dob_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ta ꞌomi niꞌatu yamwalamwalatonimi ꞌaene nigeya ꞌebweu Yaubada ꞌana oboboma ꞌatemiya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ꞌAboꞌagu Tamagu ꞌina loinega yamai ta nigeya manugu wagwaugwausowala, ta ꞌeguma ꞌebweu yaita taunamo ꞌina loinega ꞌemiya ꞌimamai, tauna manuna wada gwausowala. ");
INSERT INTO dob_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“ꞌOmi nuwanuwami be taumi ꞌemiyega ꞌami tupu wada nonodi, ta esi ꞌami tupu Yaubada ꞌenega waguitoyasena. Nate ꞌalena nigeya kapekapeyana be waemisegu. ");
INSERT INTO dob_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Geyaꞌabo wanuwena ꞌaene ꞌaboꞌagu yada eꞌewami Tamagu ꞌenaya, ta esi ꞌebweu tai maꞌetamo ꞌida eꞌewami, tauna wanuwena ꞌaene ꞌetamo ꞌida lememi, ꞌana esana Mosese. ");
INSERT INTO dob_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ta ꞌeguma ꞌomi Mosese waemisa ꞌaiꞌailina, ꞌaboꞌagu wate nadigega waemisegu, manuna tauna lowa manugu Buki Tabu ꞌena ꞌisimana ga ꞌiꞌetoladina. ");
INSERT INTO dob_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ta ꞌina simana nina nigeya waemiemise, ꞌenega nigeya sawesawenaya be ꞌigu ona waemise.” ");
INSERT INTO dob_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","(1,4) ꞌEnega tuta muliyega ta tuta nina ꞌena niꞌatu selabenaya be me Yudia ꞌidi Ataona Sagalina siguinuwe, ga Yesu Galili leꞌawinaya ꞌimiyami, ta ola nina ꞌana esana ꞌeluwena Taibilia. Ta Yesu ꞌigelu ga ꞌiabala mali esenaya. ");
INSERT INTO dob_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ga wate boda sinabwana Yesu simuliyena, manuna niꞌatu ꞌina guinuwa waiwaina toleꞌoasao ꞌediya siꞌitena. ");
INSERT INTO dob_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ꞌEnega Yesu ma ina tononoyao ꞌoyaya situꞌe ga simiyatowa. ");
INSERT INTO dob_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(-) ");
INSERT INTO dob_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ga Yesu ꞌiꞌita sakowasi ga boda sinabwana simeema ꞌiꞌitedi. Ga Yesu Pilipi ꞌieonena, ꞌigwae, “Pilipi, mane ꞌenega masula sawesawenaya tagimwane be tomota gete tada eꞌenidi?” ");
INSERT INTO dob_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Enaida gete ꞌenega Yesu Pilipi ꞌitoona, ta niꞌatu ꞌimwalatonina toꞌase ꞌiabe ꞌida guinuwe, boda nidi manudi. ");
INSERT INTO dob_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ꞌEnega Pilipi Yesu ꞌieonena, ꞌigwae, “Boda gete sinabwa wawasae, ta ꞌeguma tu analedi kina ꞌenega beledi tagimwanedi be ꞌediya taeguyaiye, nai nigeya sawesawenaya be maiboꞌadi sida lotoo.” ");
INSERT INTO dob_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ga ꞌenega ꞌebweu wate Yesu ꞌina tonono Anidulu, tauna Saimoni Pita tasina ꞌieonena, ");
INSERT INTO dob_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ꞌigwae, “ꞌEbweu gwama gete yalobena ma ꞌana beledi nima ta iyana ꞌeluwa ꞌenaya, ta nai boda getedi nigeya sawesawediya.” ");
INSERT INTO dob_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ga ꞌenega Yesu ꞌina tononoyao ꞌieonedi, ꞌigwae, “Tomota maiboꞌadi wada eonadi be pwatulaya sida miyatowa.” Manuna sena nina ꞌena pwatula boboꞌana. ꞌEnega simiyatowa, ga tai dimo ꞌadi sawasawa nadigega paibi tausani. ");
INSERT INTO dob_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ga Yesu beledi nidi ꞌiꞌewedi ga manudi Yaubada ꞌena ꞌilokagutoki, ga muliyega tomota nidi simiyatowaya ꞌediya ꞌieguyaiyena. Ga wate iyana nidi ꞌeluwa nadigega ꞌediya ꞌiguinuwaꞌesa, ga maiboꞌadi siꞌai ga sawesawediya. ");
INSERT INTO dob_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ga ꞌeꞌai mulinaya Yesu ꞌina tononoyao ꞌieonedi, “Beledi tomwatomwadi waegogonedima. Geyaꞌabo wate ꞌebweu tupwa wamudamudali.” ");
INSERT INTO dob_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ꞌEnega beledi nima nidi tomota siꞌenidiya, ta tupwatupwadi ꞌediyega ꞌina tononoyao kodo tuwelo siloemaedi. ");
INSERT INTO dob_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tuta nina gote ꞌenaya tomota nidi ꞌina guinuwa waiwaina ꞌana weꞌiweꞌiyaya siꞌitena ga sigwae, “Gete palopita nina siona upaupaena ꞌaene baleꞌuya ꞌida ma.” ");
INSERT INTO dob_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ga gote ꞌena Yesu tomota ꞌimwalatonidi ꞌaene tuta gidalina ꞌenaya be sigiyai be ꞌediya ꞌida ekini. Ta Yesu geya nuwana, ꞌenega taunamo ꞌitauya ga ꞌiila ꞌoyaya. ");
INSERT INTO dob_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ta boiꞌunuya ꞌina tononoyao sidolo ola Galili leꞌawinaya, ");
INSERT INTO dob_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ga ꞌidi waga ꞌena sigelu be ꞌaene siabala limana Kapaneumi senanaya. Ta niꞌatu bwagabwagaya sineyaneya ga ꞌiguguyoi, ta Yesu nigeya ꞌediya ꞌimeema. ");
INSERT INTO dob_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ta tuta nina ꞌenaya yagila be lisu sinabwana silobena. ");
INSERT INTO dob_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ta niꞌatu sineya ga tupwana ꞌedasolaya sitauya, ta Yesu ola debanega ꞌimeema ꞌidi waga selabenaya, ga siꞌitena, ta ꞌenega maiboꞌadi simatauta. ");
INSERT INTO dob_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ꞌEnega ꞌieonedi, “Geyaꞌabo wamatamatauta. ꞌAboꞌagu tuga.” ");
INSERT INTO dob_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ga ꞌenega tonono nidi sitagwala ga Yesu ꞌigelu wagaya, ta waga ꞌilomanini ga siapwesa sena nina ꞌena sitautauya leꞌawinaya. ");
INSERT INTO dob_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ga mali ꞌasiyataya boda nidi Galili olana mali esenaya simiyami simwalatonina ꞌaene ꞌasiyata nina ꞌigumwala ꞌena Yesu ma ina tononoyao ꞌidi waga ꞌebweu namo sigeluna, ta tononoyao dimo niꞌatu sigelu ga sitauya, ta Yesu nigeya maꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ꞌAsiyata nina ꞌena Taibilia ꞌenega waga ꞌaidi simai, ga sena nina ꞌena boga Yesu pwalu beledi ꞌenega ꞌieꞌenidi selabenaya silugu. ");
INSERT INTO dob_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ga gote ꞌena tomota maiboꞌadi Yesu ma ina tononoyao siꞌebesa yogenedi, ꞌenega tomota nidi waga ꞌediya sigelu ga siabala Kapaneumi be Yesu siꞌebese. ");
INSERT INTO dob_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ta silobena Galili olana mali esenaya, ga sieonena, sigwae, “ꞌInapwana, maisa ꞌumai?” ");
INSERT INTO dob_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ga tomota ꞌediya ꞌigwae, “Yaona ꞌaiꞌaila, ꞌomi nigeya waꞌebeꞌebesegu weꞌiweꞌiyaya manudi, ta esi ꞌimi ꞌebesa ꞌalena manuna beledi nidi waꞌenidiya ga gamwami ꞌipawa. ");
INSERT INTO dob_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ꞌOmi geyaꞌabo masula gumwagumwalina manuna waguiguinuwa ta esi masula tauna yawasimi ataya manuna. ꞌAboꞌagu Tomota Natuna be masula gete yada ꞌebwaꞌemi, manuna Yaubada Tamagu tauna ꞌiesinuweguya ꞌina guinuwa gete manuna.” ");
INSERT INTO dob_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ga taudi sieonena, sigwae, “To guinuwa Yaubada ꞌina guinuwa be ꞌada guinuwe?” ");
INSERT INTO dob_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ga Yesu ꞌieonedi, ꞌigwae, “Yaubada ꞌina guinuwa gete, ꞌaene wada emisegu ꞌaboꞌagu tai nigu ꞌietuneguma.” ");
INSERT INTO dob_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ga sieonena, “To weꞌiweꞌiyaya ꞌuda guinuwe be ꞌenega ꞌada emiseyo? ");
INSERT INTO dob_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nadigega lowa tubumao masula nina mitawa daitaya siꞌenina, ꞌana esana mana, nadigega Buki Tabu ꞌionaꞌesa, ‘Masula galewega ꞌiꞌebwaꞌedi ga siꞌai.’ Ta toꞌase ꞌoyo ꞌimu weꞌiweꞌiyaya ꞌuda guinuwe?” ");
INSERT INTO dob_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ꞌEnega Yesu tomota nidi ꞌieonedi, ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya ꞌaene Mosese tauna nigeya masula galewega ꞌiꞌebwaꞌebwaꞌemi, ta esi Tamagu tauna masula ꞌaiꞌaila galewega ꞌana toꞌebwaya ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ta masula nina, nate Yaubada ꞌenega, tauna niꞌatu ꞌimai baleꞌuya be tomota yawasidi ꞌida ꞌebwaꞌedi.” ");
INSERT INTO dob_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ga taudi wate Yesu sieonena, sigwae, “ꞌInapwana, masula gete ꞌuda ꞌebwaꞌema tuta yauyauna.” ");
INSERT INTO dob_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ta Yesu ꞌieonedi, “ꞌAboꞌagu yawasimi ꞌana masula be ꞌenega ꞌabo yaita ꞌimama ꞌeguya geyaꞌabo ꞌibotabotana, ta ꞌabo yaita ꞌiemisegu geyaꞌabo saꞌi tonaꞌana ꞌiyapayapasa. ");
INSERT INTO dob_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Niꞌatu yaeonemi ꞌaene waꞌiteguya, ta tuwa tuga nigeya wada emisegu. ");
INSERT INTO dob_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tomota nidi taudi Tamagu ꞌiꞌebwaꞌegu maꞌetamo ꞌeguya simama be geyaꞌabo saꞌi yaeꞌidiꞌidiyedi. ");
INSERT INTO dob_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Manuna ꞌaboꞌagu galewega yamai nigeya ꞌigu nuwena taugu sabi guinuwena, ta esi tauna ꞌietuneguma ꞌina nuwena. ");
INSERT INTO dob_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ꞌAgu toetune nina ꞌigu tomota ꞌiꞌebwaꞌeguya, ta gete ꞌina nuwena be ꞌaene geyaꞌabo yaita ꞌebweu ꞌediyega ꞌiloseloseyei, ta esi tuta ꞌana ꞌebe losalowa ꞌenaya mwawasega yada gietoolodi. ");
INSERT INTO dob_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ta gete Tamagu ꞌina nuwena nadigega ꞌaene ꞌeguma yaisigedi taudi ꞌaboꞌagu natunana siꞌitagu, be wate siemisegu, yawasidi ataya siloba, ta tuta ꞌana ꞌebe losalowa ꞌenaya ꞌaboꞌagu mwawasega yada gietoolodi.” ");
INSERT INTO dob_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Gote ꞌena me Yudia ꞌina ona sinonona ga silomugiyena, manuna ꞌina ona nina ꞌenaya ꞌigwae, “ꞌAboꞌagu masula nina galewega yamwaꞌutama.” ");
INSERT INTO dob_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ga wate taudi sigwae, “Tai gete Yosepa natuna, tauna Yesu, aga? Ta tamana be sinana tamwalamwalatonidi, ta mwaꞌadega ga ꞌenega ꞌiona ꞌaene tauna galewega ꞌimwaꞌutama?” ");
INSERT INTO dob_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ga Yesu ꞌieonedi, ꞌigwae, “Geyaꞌabo taumimo ꞌemiya manugu walomulomugi. ");
INSERT INTO dob_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Manuna Tamagu tauna ꞌietuneguma be ꞌenega yaisigedi taudi ꞌabo ꞌilisidi be ꞌeguya simama, taudi tuta ꞌana ꞌebe losalowa ꞌena mwawasega yagietoolo limadi, ta ꞌabo yaisigedi taudi nigeya ꞌeguya ꞌilisilisidima geyaꞌabo saꞌi ꞌeguya simeemai. ");
INSERT INTO dob_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ona gete niꞌatu lowa palopita siꞌetoladina Buki Tabu ꞌena, sigwae, ‘Tomota yauyaudi Yaubada ꞌenega ꞌadi eꞌita sida loba,’ be ꞌenega yaisigedi taudi Tamagu ꞌina eꞌita sinono be sisinapui, taudi ꞌeguya simama. ");
INSERT INTO dob_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ta ꞌomi nigeya ꞌebweu yaita ꞌemiyega Tamadai ꞌiꞌitaꞌita, nate namo tebweugu, manuna ꞌaboꞌagu ꞌenega yamai. ");
INSERT INTO dob_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Yaona ꞌaiꞌaila ꞌemiya ꞌaene yaisigedi taudi siemisegu yawasidi ataya siloba. ");
INSERT INTO dob_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Manuna ꞌaboꞌagu yawasimi ꞌana masula. ");
INSERT INTO dob_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Lowa mitawa daitaya tubumiyao masula nina ꞌana esana mana siꞌenina, ta esi nigeya yawasidi boboꞌana ꞌenega silobaloba, ta tuwa tuga niꞌatu simwawasa, ");
INSERT INTO dob_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ta masula gete esi galewega ꞌimwaꞌutama be ꞌenega ꞌabo yaita ꞌiꞌaꞌani, geyaꞌabo saꞌi ꞌimwawamwawasa. ");
INSERT INTO dob_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ꞌAboꞌagu yawasimi ꞌana masula galewega yamwaꞌutama, be ꞌabo yaita masula nina ꞌiꞌaꞌani yawasina ataya ꞌida ꞌewa, ta masula nina yaꞌebwaꞌemi bwalagu tuga, ta bwalagu yatagwalena me baleꞌu yauyaumi yawasimi manuna.” ");
INSERT INTO dob_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ga gote ꞌenega me Yudia nidi sieꞌale be taudimo siegewagewana, sigwae, “Mwaꞌadega tai gete be ꞌaene bwalana ꞌida ꞌebwaꞌeda be taꞌaꞌani?” ");
INSERT INTO dob_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya, ꞌaboꞌagu Tomota Natuna, ta ꞌeguma bwalagu geyaꞌabo waeꞌani ta wate ꞌeguma lalagu geyaꞌabo wanumanumai, geyaꞌabo saꞌi yawasimi ataya waꞌewaꞌewa. ");
INSERT INTO dob_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ta ꞌabo yaita bwalagu ꞌiꞌaꞌani be lalagu ꞌinumai yawasina ataya ꞌiꞌewa, be tuta ꞌana ꞌebe losalowa ꞌena mwawasega yada gietoolo lima. ");
INSERT INTO dob_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ta wada nuwaꞌiꞌisi ꞌaene bwalagu masula ꞌaiꞌaila, ta lalagu wate ꞌebe tonaꞌatowa ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ꞌEnega ꞌabo yaita tauna bwalagu ꞌiꞌaꞌani be lalagu ꞌinumai tauna ꞌeguya ꞌimiyami, ta wate ꞌaboꞌagu ꞌenaya yamiyami. ");
INSERT INTO dob_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Tamagu tauna miyamiya atayana ꞌietuneguma ga tauna tuta yauyauna ꞌenega yawasigu yaꞌewaꞌewa. ꞌAboꞌagu wate nadigega ꞌeguma yaita ꞌiꞌenigu, tauna wate yawasina ꞌeguyega ꞌida ꞌewaꞌewa. ");
INSERT INTO dob_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Masula gete galewega ꞌimai ta nigeya nadigega masula nina tubumiyao siꞌenina, manuna masula nina lowa siꞌenina ta nigeya yawasidi boboꞌana silobaloba, ta tuga simwawasa. ꞌEnega masula gete ꞌabo yaita ꞌiꞌaꞌani yawasina ataya ꞌida ꞌewa.” ");
INSERT INTO dob_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yage getedi maiboꞌadi ꞌisimana apwesedi tuta nina ꞌieꞌita anuwa tapwalolo solanaya sena Kapaneumi ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tuta nina tomuliyao yaudi Yesu ꞌina ona gete sinonona ga taudimo ꞌediya sigwae, “Ona gete ꞌana nono mwauna, ta ꞌaboꞌada geya nuwada.” ");
INSERT INTO dob_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ta Yesu niꞌatu tauna ꞌigimi mwalatonidi ꞌaene ona gete manudi silomulomugi, ga ꞌediya ꞌigwae, “Ona gete manuna nuwami ꞌimwauya. ");
INSERT INTO dob_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ꞌAboꞌagu Tomota Natuna ta mwaꞌadega ꞌeguma waꞌitagu lowa sena nina ꞌenega yamaiya ꞌena yatuꞌetuꞌe? ");
INSERT INTO dob_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ta Yaluyaluwa Tabuna tauna yawasimi ꞌana toꞌebwaya, ta bwalami nigeya sida lememi. ꞌIgu ona gete niꞌatu yaꞌebwaꞌemi, be ꞌenega ona nidi Yaluyaluwa Tabunega yawasimi sida ꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ta tuwa tuga ꞌaimi nigeya waemiemisegu.” Yesu ona gete ꞌiꞌinanedi manuna ꞌigimi mwalatonina yaisigedi taudi nigeya siemiemise ta wate ꞌimwalatonina yaita ꞌana tosipupu nina. ");
INSERT INTO dob_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ga wate ꞌieonedi, ꞌigwae, “Gete manuna lowa yagimi eonemi ꞌaene nigeya sawesawemiya be ꞌeguya wamama, ꞌabo Tamagu nigeya ꞌitagwatagwala.” ");
INSERT INTO dob_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Gete ꞌenega Yesu ꞌana tomuliyao yaudi siguitoyasena ga sipilisinena. ");
INSERT INTO dob_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ta site tuwelo dimo situpwa, ga Yesu ꞌieonedi, ꞌigwae, “ꞌOmi wate nuwanuwami be wapilisinegu, aga?” ");
INSERT INTO dob_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ꞌEnega Saimoni Pita Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, yaita ꞌena ꞌatatauya? Manuna ꞌoyo tebweuyo yawasima ataya ꞌana ona ꞌemuya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ta ꞌaboꞌama niꞌatu ꞌaemisemu, ga ꞌamwalatonimu ꞌaene ꞌoyo tuga Toꞌetoseyana niyo Yaubada ꞌenega.” ");
INSERT INTO dob_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ga Yesu ꞌigwae, “Onaꞌaiꞌaila, wate tuwelo yaesinuwemi, ta tuwa tuga ꞌebweu ꞌemiyega Seitani ꞌina boda.” ");
INSERT INTO dob_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu gete ꞌionaona Yudasa manuna, tauna Saimoni Isikaliota natuna. Ta Yudasa nina tauna ꞌebweu Yesu ꞌina tonono, ta tuwa tuga maꞌetamo ꞌida telesipupuye. ");
INSERT INTO dob_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ta yage nidi niꞌatu sigumwala ga Yesu Galili maiboꞌana ꞌena ꞌisakowasi. Ta esi geya nuwana be Yudia senanaya ꞌida sakowasi, manuna me Yudia ꞌidi ꞌinapwanao nuwanuwadi be ꞌaene sida loemwawasi. ");
INSERT INTO dob_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ta niꞌatu Yoeyoe Sagalina ꞌana tuta ꞌiloselabena be me Yudia sida guinuwe. ");
INSERT INTO dob_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ꞌEnega Yesu tasinao Yesu sieonena, sigwae, “Sena gete ꞌupilisine be Yudia ꞌena ꞌutatauya, be ꞌenega nada ꞌamu tomuliyao ꞌimu guinuwa sida ꞌita.” ");
INSERT INTO dob_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wate sieonena, sigwae, “ꞌUda mwalatoni ꞌaene nigeya ꞌebweu yaita guinuwa kwaikwaiyega ꞌana esana ꞌida sinabwa, ta ꞌeguma nuwanuwayo be tomota maiboꞌadi sida mwalatoniyo, ꞌenega ꞌuda eꞌitaeyo tauyo ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tasinao ona nina ꞌena siꞌinanena manuna nigeya wate siemiemise. ");
INSERT INTO dob_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ga gote ꞌena ꞌieonedi, ꞌigwae, “ꞌIgu tuta nigeya ꞌilobaloba be sena nina ꞌena yatatauya, ta ꞌomi esi ꞌilobwenemi be ꞌena watatauya ꞌabo to tuta ꞌena nuwanuwami, ");
INSERT INTO dob_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","manuna ꞌomi geyaꞌabo me baleꞌu sietaetalauwalemi, ta ꞌaboꞌagu esi sietalauwalegu manuna ꞌidi bubuna toꞌumalina yasimasimanedi. ");
INSERT INTO dob_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Boboꞌana! ꞌOmi taumimo watatauya sagali nina ꞌena. ꞌAboꞌagu geyaꞌabo yaweewa ꞌenaya, manuna nigeya ꞌigu tuta ꞌaiꞌaila ꞌiapweapwesa.” ");
INSERT INTO dob_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ona gete niꞌatu ꞌiꞌebwaꞌedi ga sitauya, ta tauna tuga Galili ꞌena ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ga niꞌatu Yesu tasinao sipilisinena ga sitauya sagali nina ꞌena, ꞌenega Yesu mulidiyega ꞌiakwaikwaiya ga sena nina ꞌena ꞌiapwesa, ta nigeya ꞌebweu yaita ꞌimwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ta tuta nina ꞌenaya me Yudia ꞌidi ꞌinapwanao Yesu siꞌebeꞌebese sagali nina solanaya, ta sigwaegwae, “Mwaꞌo tauna gete tai nina?” ");
INSERT INTO dob_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ga gote ꞌena tomota yau wawasae taudimo ꞌediya silomulomugi Yesu manuna, ga ꞌaidi sigwae, “Tauna tai boboꞌana,” ta ꞌaidi sigwae, “Nigeya! Tauna tai nina kabo ꞌalena, tomota ꞌiwasewasegigiyedi.” ");
INSERT INTO dob_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ta tomota yaudi me Yudia ꞌidi ꞌinapwanao simatautedi, ꞌenega nigeya ꞌebweu yaita ꞌionaona apwesa Yesu manuna. ");
INSERT INTO dob_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ta niꞌatu sagali ꞌana wiki gamwagamwaninaya, ga Yesu Anuwa Tabu ꞌena ꞌilugu, ga ꞌina eꞌita ꞌieꞌalena. ");
INSERT INTO dob_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ꞌEnega me Yudia gote ꞌena nuwadi ꞌiowana sinabwana ga sigwae, “Mane ꞌenega tai gete ꞌina mwalatoi ꞌilobena? Tauna nigeya ꞌebweu ꞌebe sikulu sinabwana ꞌena ꞌilugulugu.” ");
INSERT INTO dob_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ta Yesu ꞌilolagata ga ꞌieonedi, “ꞌAboꞌagu nigeya taugu ꞌigu nuwena ꞌenega, ta esi ꞌagu toetune nina ꞌina nuwena ꞌenega yaeꞌieꞌita. ");
INSERT INTO dob_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ta ꞌomi wate ꞌabo nuwanuwami be Yaubada ꞌina nuwena wada guinuwe, ꞌomi ꞌigu eꞌita wada mwalatoni ꞌaene Yaubada ꞌenega, ta nigeya taugu ꞌigu nuwanuwa ꞌenega. ");
INSERT INTO dob_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ta ꞌomi ꞌimi bubuna ꞌaene ꞌeguma yaita tauna ꞌina nuwena ꞌenega ꞌieꞌita, tauna tuga taunamo ꞌana esana manuna ꞌietaetapewa. Ta ꞌaboꞌagu esi nigeya nadigega ꞌomi, manuna ꞌaboꞌagu nuwanuwagu be ꞌagu toetune ꞌana esana yada giesinabwa, manuna ꞌigu bubuna palupaluna ta nigeya ꞌebweu wate ꞌigu toꞌumalinamo. ");
INSERT INTO dob_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ꞌOmi esi Mosese ꞌami loina nina ꞌiꞌebwaꞌemi ta nigeya ꞌebweu yaita ꞌemiyega ꞌimulimuliya ꞌaiꞌaili. ꞌEnega toꞌase manuna ꞌaene wada loemwawasa daidaisigu?” ");
INSERT INTO dob_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ga boda nidi ꞌina ona sieꞌisena, sigwae, “Mwaꞌadega, yaluyaluwa biꞌi debayo ꞌigiesakowasiyena, ga nadigega ꞌuonaꞌesa? Ta yaita sana nuwanuwana be ꞌaene ꞌida loemwawasiyo?” ");
INSERT INTO dob_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ꞌEnega Yesu ꞌidi ona ꞌieꞌisena ga ꞌediya ꞌigwae, “Nuwami ꞌitoꞌumaliya manuna ꞌasiyata Sabate ꞌenaya tai yagie boboꞌanena. ");
INSERT INTO dob_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ta mwaꞌadega ꞌomi ꞌimi guinuwa tuta Sabate ꞌena? Manuna Mosese ꞌina loinega natumiyao meꞌolotodi bwaladiya weꞌiweꞌiyaya walodabedi. (Ta loina getei nigeya Mosese ꞌenega ta esi lowaenei gimitubudao ꞌediyega ꞌimai.) ");
INSERT INTO dob_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ta ꞌabo guinuwa nina meꞌolotodi ꞌediya waguiguinuwedi ꞌasiyata Sabate ꞌenaya, toꞌase manuna ga waetalauwalegu tuta nina ꞌasiyata Sabate ꞌenaya tai yagie boboꞌanena? ");
INSERT INTO dob_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Geyaꞌabo gosemiyao ꞌadi ꞌita ꞌenega waesiesinuwa manudi, ta esi loina palupaluna ꞌenega wada esinuwa.” ");
INSERT INTO dob_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ga gote ꞌena ꞌaidi me Yelusalema sigwae, “Nai tai gete tauna nuwanuwadi be ꞌaene sida loemwawasi, aga? ");
INSERT INTO dob_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ta waꞌita, niꞌatu tomota gamwagamwanidiya ꞌitootoolo ga ꞌionaona ꞌediya, ta nigeya ꞌebweu yaita ꞌenana ꞌida eꞌisena. Ta mwaꞌadega, niꞌatu ꞌida toanuganao siꞌawa ꞌaiꞌailena ꞌaene tauna Toꞌetoseyana, aga? ");
INSERT INTO dob_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nai nigeya. Manuna tai gete maiboꞌada niꞌatu tamwalamwalatoni mane ꞌenega ꞌimai, ta ꞌeguma Toꞌetoseyana ꞌimamai, geyaꞌabo yaita ꞌimwalamwalatoni mane ꞌenega ꞌimai.” ");
INSERT INTO dob_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tuta nina Yesu maꞌetamo ꞌieꞌieꞌita Anuwa Tabu solanaya, ta ꞌenana sinabwana ꞌenega ꞌigwaegwae, “Onaꞌaiꞌaila niꞌatu wasinapugu ꞌaene to sena ꞌenega yamai, ta wada nuwaꞌiꞌisi tauna ꞌietuneguma ga ꞌina loinega yamai, ta esi ꞌaboꞌagu nigeya taugu ꞌigu loinega be yamamai sena gete ꞌena. Tauna ꞌagu Toetune nina ꞌina bubuna boboꞌana ta palupaluna, ta ꞌomi nigeya wamwalamwalatoni yaita tauna. ");
INSERT INTO dob_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ta ꞌaboꞌagu yamwalatonina, manuna tauna ꞌietuneguma ga ꞌenega yamai.” ");
INSERT INTO dob_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ta gote ꞌena tomota nidi sitoona be ꞌaene sida giyai, ta mwaꞌadega ga ꞌenega nigeya ꞌebweu yaita bwalana ꞌigitogitoo, manuna tauna nigeya ꞌina tuta ꞌilobaloba be ꞌimwamwawasa. ");
INSERT INTO dob_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ta esiya tomota yaudi siemisena ga sigwae, “Onaꞌaiꞌaila tai gete Toꞌetoseyana, manuna nigeya sawesawenaya be ꞌebweu wate tai ꞌimama be tauna ꞌina guinuwa tai gete ꞌina guinuwa ꞌida boboꞌana sinei.” ");
INSERT INTO dob_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Gote ꞌena Palisiyao tomota ꞌidi ona kwaiya sinonona, ꞌenega taudi be totaliyao sinabwadi ꞌidi toꞌitaꞌiꞌitao sietunedi be Yesu sida giyai. ");
INSERT INTO dob_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ꞌEnega toꞌitaꞌiꞌitao nidi simai ga ꞌieonedi, ꞌigwae, “ꞌAboꞌagu tuga tuta kukupana namo ꞌena maꞌemiya, be ꞌenega wate yada ila tauna ꞌagu Toetune ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","be maꞌetamo wada ꞌebesegu ta geyaꞌabo saꞌi walobalobagu, be sena nina ꞌena yamiyami ꞌomi nigeya sawesawemiya be ꞌena wawawa.” ");
INSERT INTO dob_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ta me Yudia nidi taudimo ꞌediya sigwae, “Mane ꞌena ꞌaene ꞌitautauya be ꞌenega geyaꞌabo talobaloba? ꞌAene ꞌitatauya taudi me Yudia nidi ꞌasa sipilisinena ga sitauya mali senao ꞌediya, be ꞌida eꞌitadi, aga? ");
INSERT INTO dob_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ꞌIna ona gete toꞌase ꞌana mwalatoi? Manuna ꞌigwae, ‘Maꞌetamo wada ꞌebesegu be geyaꞌabo saꞌi walobalobagu’, ta wate ꞌigwae, ‘Sena nina ꞌena yamiyami ꞌomi geyaꞌabo ꞌena waweewa.’ ” ");
INSERT INTO dob_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ta niꞌatu sagali ꞌana ꞌasiyata sinabwana, sagali ꞌana ꞌebe losalowa ꞌena, Yesu gamwagamwanidiya ꞌitoolo ga ꞌenana sinabwanega ꞌibwaubwau, ꞌigwaegwae, “Yaita ꞌoyo ꞌeguma tonaꞌayo ꞌiyapasa ꞌumai ꞌeguya be ꞌununuma. ");
INSERT INTO dob_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta nadigega tuga Buki Tabu ꞌisimanena ꞌagu toemisao manudi ꞌaene, ‘Atediyega ꞌatuwa bwasi ꞌidaudau tomota yawasidi manuna.’ ” ");
INSERT INTO dob_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu ꞌina ona gete ꞌenaya ꞌionaona Yaluyaluwa Tabuna manuna, be ꞌenega Yaluyaluwa Tabuna maꞌetamo ꞌida lugu taudi ꞌana toemisao ꞌediya. Ta tuta nina ꞌena Yaluyaluwa Tabuna nigeya ꞌilugulugu tomota ꞌediya, manuna Yesu nigeya ꞌina ꞌebeloina ꞌena ꞌituꞌetuꞌe. ");
INSERT INTO dob_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesu ꞌina ona tomota yauyaudi sinonona, ga ꞌaidi sigwae, “Onaꞌaiꞌaila, tai gete tauna palopita nina sionaonaena.” ");
INSERT INTO dob_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Ta ꞌaidi wate sigwae, “Tauna esi Toꞌetoseyana nina.” Ta wate ꞌaidi ꞌediyega sigwae, “ꞌAene Toꞌetoseyana nina Galiliyega ꞌimamai? Nigeya, aga? Manuna Buki Tabu ꞌena niꞌatu ꞌisimanena be Toꞌetoseyana Debida ꞌina susu ꞌenega ꞌimamai, be Debida ꞌina ꞌasa Bedileema ꞌena ꞌitutubuwa.” ");
INSERT INTO dob_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Gote ꞌena ga weyala ꞌiapwesa tomota gamwagamwanidiya. ");
INSERT INTO dob_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ga ꞌaidi nuwanuwadi be Yesu sida giyai, ta nigeya ꞌebweu yaita bwalana ꞌigitogitoo. ");
INSERT INTO dob_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ꞌEnega toꞌitaꞌiꞌitao nidi siila totaliyao sinabwadi be Palisiyao ꞌediya, ga ꞌinapwanao nidi sieonedi, sigwae, “Toꞌase manuna nigeya wagiyagiyainama?” ");
INSERT INTO dob_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ta toꞌitaꞌiꞌitao nidi ꞌidi ꞌinapwanao sieonedi, ga sigwae, “Tai gote ꞌina ona boboꞌana wawasae. Nigeya ꞌebweu wate yaita nadigega.” ");
INSERT INTO dob_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ga Palisiyao wate sigwae, “Nai nuwami ꞌiꞌewena, aga? ");
INSERT INTO dob_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ta wada mwalatoni ꞌaene nigeya ꞌebweu yaita toloinao nai Palisiyao ꞌemega Yesu ꞌaemiemise. ");
INSERT INTO dob_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ta esi boda yaudi siemisena, manuna boda nidi nigeya Mosese ꞌina loina sinuwanuwa sabwaleni, ꞌenega Yaubada ꞌadi eꞌisa toꞌumalina ꞌida ꞌebwaꞌedi.” ");
INSERT INTO dob_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ta ꞌebweu wate ꞌediyega toloina ꞌana esana Nikodimo, tauna lowa boiboiya ꞌitauya ga Yesu maꞌiyana siꞌawagwae, gosenao ꞌieonedi, ");
INSERT INTO dob_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ꞌigwae, “ꞌAboꞌada ꞌida loina gete nadigega ꞌaene geyaꞌabo taloiloina besobeso, ta esi nugana tai ꞌina toꞌumalina tada ꞌebese, be ꞌenega ꞌana etala mulinaya toꞌase manuna tada loine.” ");
INSERT INTO dob_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ga ꞌinapwanao nidi Nikodimo siꞌena paꞌalina, sigwae, “Nai ꞌoyo sana goma Galili aga? Ta Buki Tabu ꞌusawa be ꞌumwalatoni ꞌaene nigeya ꞌebweu wate palopita Galili ꞌenega ꞌimeema.” ");
INSERT INTO dob_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ꞌEnega maiboꞌadi niꞌatu sideli ila ꞌidi ꞌasaya, ta Yesu Olibe ꞌoyana ꞌenaya ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","(-) ");
INSERT INTO dob_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ga mali gonagonaya Yesu ꞌiila limana Anuwa Tabu solanaya, ta tomota wate maiboꞌadi simiya sakowasiyena, ga ꞌimiyatowa ga ꞌieꞌitedi. ");
INSERT INTO dob_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ta taudi loina ꞌadi toeꞌitao ta wate Palisiyao waine ꞌebweu simeꞌena, manuna tauna niꞌatu silobena ꞌiloelata, ta waine nina gamwagamwanidiya sietoolona, ");
INSERT INTO dob_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ꞌenega Yesu sieonena, sigwae, “Toeꞌita, waine gete niꞌatu ꞌalobena ꞌiloelata, ");
INSERT INTO dob_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ta ꞌaboꞌada ꞌida loina Mosese ꞌenega ꞌaene ꞌeguma waine gete nadigega talobadi, gulewega taloibwaibwadi be simwamwawasa. Ta ꞌoyo mwaꞌadega ꞌimu nuwanuwa waine gete manuna?” ");
INSERT INTO dob_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ona gete siꞌinanena be ꞌaene Yesu ꞌina kabo sida loba be sieꞌewa. ꞌEnega Yesu nigeya ꞌidi ona ꞌieꞌieꞌisadi, ta esi ꞌimiya agaagala kaukauya, ga nimanega kaukau ꞌena ꞌiꞌetoꞌetoladi, ");
INSERT INTO dob_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ta taudi tuga ꞌetamo sienaenaide. ꞌEnega Yesu ꞌitoolo ga ꞌieonedi, ꞌigwae, “O, boboꞌana. ꞌEnega ꞌabo ꞌemiyega ꞌebweu yaita nigeya ꞌina toꞌumalinamo, nate ꞌoyo gulewa ꞌuda gimiule waine gote ꞌena.” ");
INSERT INTO dob_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ꞌEnega wate ꞌimiya agaagala limana ga kaukauya ꞌiꞌetoꞌetoladi. ");
INSERT INTO dob_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ta gote ꞌena Yesu ꞌina ona sinonona ga ꞌidi loegesi sinuwedi, ꞌenega ꞌebweuna ꞌebweuna sitautauya. Taudi ꞌinapwanao sitauya nugana ꞌenega maiboꞌadi simuliya, ga siteluwa Yesu be waine nina ꞌitootoolo maꞌiyana sipilisinedi. ");
INSERT INTO dob_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ꞌEnega Yesu ꞌitoolo ga waine ꞌieonena, ꞌigwae, “Waine, taudi getedi mwaꞌo sitauya? Nigeya ꞌebweu ꞌitupwatupwa be ꞌida eꞌewayo, aga?” ");
INSERT INTO dob_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ga waine nina Yesu ꞌieonena, “ꞌInapwana, nigeya ꞌebweu yaita.” ꞌEnega Yesu ꞌiona limana, ga ꞌigwae, “O, ꞌaboꞌagu wate geyaꞌabo yaeꞌewayo. Ta boboꞌana, ꞌutatauya, ta esi geyaꞌabo ꞌuloeloegesi limana.” ");
INSERT INTO dob_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ta Yesu ꞌediya ꞌiona limana, ꞌigwae, “ꞌAboꞌagu me baleꞌu ꞌidi maedana, be ꞌenega yaita tauna ꞌimuliyegu maedana nina yawasina ꞌena ꞌida sae, ta geyaꞌabo wate guguyoi ꞌena ꞌitautauya.” ");
INSERT INTO dob_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ꞌEnega Palisiyao Yesu sieonena, sigwae, “ꞌOyo tauyo saꞌi manuyo ꞌuonaona, ꞌenega nigeya ꞌaemiemiseyo.” ");
INSERT INTO dob_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ta Yesu wate ꞌiona limana ga ꞌediya ꞌigwae, “Onaꞌaiꞌaila taugu manugu yaonaona, ta esi toꞌase nadigega ꞌigu simana, nate simana ꞌaiꞌaila, manuna sena nina ꞌenega yamai ta wate ꞌiabe ꞌena yaila yamwalamwalatoni. Ta esi ꞌomi sena nina ꞌenega yamai ta wate ꞌiabe ꞌena yailaila nigeya wamwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ta ꞌomi ꞌimi esinuwa, me baleꞌu ꞌidi esinuwa nadigega waguiguinuwedi, ta ꞌaboꞌagu nigeya ꞌebweu yaita manuna yada esinuwa nai manuna yada loina. ");
INSERT INTO dob_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ta ꞌeguma ꞌigu loina tomota manudi yaguiguinuwedi, gete loina palupaluna, manuna loina gete nigeya taugu ꞌigu loina ta esi Tamagu tauna ꞌietuneguma maꞌiyagu ꞌima loina. ");
INSERT INTO dob_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ta wate ꞌida loina nidi ꞌetoꞌetoladidi ꞌena sisimana ꞌaene ꞌeguma tosimana ꞌeluwa ꞌidi simana leleleya, nate simana ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nadigega tuga ꞌaboꞌagu taugu manugu yaonaona, ta wate Tamagu tauna ꞌietuneguma manugu ꞌisimasimana.” ");
INSERT INTO dob_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ꞌEnega sienaidena, sigwae, “Mwaꞌo Tamayo?” Ga Yesu ꞌigwae, “Nigeya wamwalamwalatonigu, ta Tamagu wate nigeya wamwalamwalatoni. Ta ꞌomi ꞌeguma wamwalatonigu, ꞌenega Tamagu wate wamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu ꞌina eꞌitao getedi Anuwa Tabu solanaya ꞌieꞌieꞌitaedi, nate ꞌebwayadaita ꞌana dedewaga selabenaya, ga gote ꞌena nigeya ꞌebweu yaita Yesu ꞌigiyagiyai, manuna ꞌina tuta nigeya ꞌilobaloba. ");
INSERT INTO dob_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ꞌEnega Yesu wate ꞌediya ꞌigwae, “Maꞌetamo yapilisinemi be ꞌomi wada ꞌebesa yogenegu, be tuwa tuga ma imi bubuna toꞌumalina wamwamwawasa. Manuna sena nina ꞌena yatautauya ꞌomi nigeya sawesawemiya be ꞌena wawawai.” ");
INSERT INTO dob_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ꞌEnega me Yudia nidi taudimo ꞌediya sigwae, “ꞌIna ona baga wada nono, manuna ꞌigwae, ‘Sena nina ꞌena yatautauya, ꞌomi nigeya sawesawemiya be ꞌena wawawai.’ ꞌIna ona gete ꞌana mwalatoi ꞌaene taunamo ꞌida loemwawasi, aga?” ");
INSERT INTO dob_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ta Yesu ꞌieonedi, ꞌigwae, “ꞌOmi ꞌubunega wamai ta ꞌaboꞌagu etanega yamai. ꞌAna mwalatoi ꞌaene ꞌomi me baleꞌu, ta ꞌaboꞌagu esi nigeya baleꞌuyega yameema. ");
INSERT INTO dob_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ꞌEnega yaeonami ꞌaene ꞌimi bubuna toꞌumalidi ꞌediyega wada mwawasa, ꞌabo nigeya waemiemisegu. Nate ꞌalena ꞌenega yaeonami ꞌaene wamwamwawasa ma imi bubuna toꞌumalina. ");
INSERT INTO dob_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ꞌEnega sienaidena, “Ta yaita ꞌoyo?” Ta wate ꞌieonedi, ꞌigwae, “Nadigega tuga lowa yasimanena ꞌemiya.” ");
INSERT INTO dob_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ta wate ꞌieonedi, “Yage yau wawasae manumi yada ona be yada loinemi, ta esi tauna ꞌietuneguma ꞌina bubuna palupaluna, ꞌenega toꞌase nadigega yanonona ꞌenega gete me baleꞌu ꞌemiya yasimasimanedi.” ");
INSERT INTO dob_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ta taudi tuga ꞌina ona Tamana manuna nigeya sinuwanuwa sabwalena. ");
INSERT INTO dob_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “ꞌAboꞌagu Tomota Natuna, ta maꞌetamo wada gituꞌeyegu, be ꞌenega nate ꞌena wada mwalatonigu yaita ꞌaboꞌagu, be ꞌenega wada mwalatoni ꞌaene taugu nigeya ꞌigu nuwena ꞌenega yada guinuwa, ta esi toꞌase nadigega Tamagu ꞌieꞌitegu ꞌediyega yaonaona. ");
INSERT INTO dob_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ta ꞌagu toetune nina nigeya ꞌipilipili sinegu ta esi maꞌiyagu tuga, manuna tuta yauna ꞌigu guinuwa ꞌenega yagiegie gwausowali.” ");
INSERT INTO dob_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Gote ꞌena tomota yaudi Yesu ꞌina ona sinonodi ga ꞌenaya siemisa ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ꞌEnega me Yudia nidi taudi Yesu siemisenaya, ꞌieonedi, ꞌigwae, “ꞌEguma ꞌigu eꞌita wamuliyedi, ꞌomi ꞌagu tomuliya ꞌaiꞌailao.” ");
INSERT INTO dob_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ꞌEnega ꞌomi mwalatoi ꞌaiꞌaila wada mwalatoni, be gete ꞌenega liꞌama wada loba.” ");
INSERT INTO dob_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ga taudi Yesu sieonena ga sigwae, “ꞌAboꞌama Ebelaamo ꞌina susu, ꞌenega nigeya ꞌebweu yaita ꞌina loinega ꞌiyoniyonima. Toꞌase ꞌimu ona ꞌana mwalatoi tuta nina ꞌugwae, ‘Liꞌama wada loba’?” ");
INSERT INTO dob_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ꞌEnega Yesu ꞌieonedi, “Yaona ꞌaiꞌaila ꞌemiya, ꞌabo yaisigedi taudi ꞌidi guinuwa toꞌumalina, taudi toꞌumalina nina ꞌiyoniyonidi, be toꞌumalina ꞌina sena ꞌena simiyami. ");
INSERT INTO dob_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Manuna ꞌaliꞌei nigeya susu ꞌina boda ꞌena ꞌida miya ataya, ta esi tai natuna tauna susu solanaya ꞌimiya ataya. ");
INSERT INTO dob_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nadigega tuga ꞌeguma natunana ꞌiliꞌamimi, ꞌomi niꞌatu liꞌaliꞌama ꞌaiꞌailimi.” ");
INSERT INTO dob_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ta Yesu wate ꞌediya ꞌigwae, “Yamwalatonimi ꞌaene ꞌomi Ebelaamo ꞌina susuyao, ta tuwa tuga watootoo be ꞌaene wada loemwawasigu, manuna nigeya ꞌigu eꞌita ꞌatemiya wasaꞌusaꞌudi. ");
INSERT INTO dob_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ꞌAboꞌagu toꞌase nadigega Tamagu ꞌieꞌitegu gete ꞌemiya yaonaonaedi, ta ꞌomi esi toꞌase nadigega tamami ꞌenega wanononaya wate nadigega waguiguinuwaꞌesa.” ");
INSERT INTO dob_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ꞌEnega taudi Yesu ꞌina ona sieꞌisena, sigwae, “Ta ꞌaboꞌama tamamai Ebelaamo.” Ta wate Yesu ꞌieonedi, “ꞌEguma ꞌomi Ebelaamo natu ꞌaiꞌailinao ꞌina guinuwega wada guinuwa. ");
INSERT INTO dob_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ta saꞌi ꞌomi ꞌimi guinuwa dumadumadi, ꞌenega ꞌaene watootoo be waloemwawasigu, ꞌaboꞌagu Yaubada ꞌina ona ꞌaiꞌaila ꞌana tosimana. Ta waꞌita Ebelaamo ꞌina guinuwa nigeya gete nadigega. ");
INSERT INTO dob_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ta ꞌomi tamami ꞌina guinuwa waguiguinuwedi.” ꞌEnega taudi wate sigwae, “Iye! ꞌAboꞌama nigeya pesiyeda. ꞌAboꞌama tamama ꞌebweuna tuga, Yaubada.” ");
INSERT INTO dob_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ꞌEnega Yesu ꞌediya ꞌigwae, “ꞌEguma Yaubada tauna tama ꞌaiꞌailimi wada obobomegu, manuna ꞌaboꞌagu Yaubada ꞌietuneguma, ga sena gete ꞌena yamai. ꞌAboꞌagu nigeya taugu ꞌigu nuwenuwega yameemai, ta esi tauna ꞌietuneguma ꞌina nuwanuwa ꞌenega. ");
INSERT INTO dob_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Toꞌase manuna ꞌigu ona ꞌemiya nigeya wada nuwasabwalenidi? Nate manuna nigeya ꞌigu simana wada enono ꞌaiꞌailina. ");
INSERT INTO dob_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yamwalatonimi ꞌomi Seitani natunao, ꞌenega nuwanuwami be tamamiya ꞌina nuwanuwa wada guinuwe. Tuta ꞌana ꞌebe eꞌale ꞌenega ga batuwa, tauna toloemwawasa, ta nigeya ꞌebweu wate ꞌeda palupaluna ꞌenega ꞌida tauya, manuna tauna nigeya ꞌebweu ꞌeda palupaluna ꞌena ꞌimiyami. Tuta yauna kaboega ꞌionaona, manuna tauna tuga adelina nadigega, ta wate tokaboyao maiboꞌadi tamadiya. ");
INSERT INTO dob_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ta esi ꞌaboꞌagu ona ꞌaiꞌaila ꞌemiya yasimasimane, nate ꞌalena ꞌenega nigeya wada emisegu. ");
INSERT INTO dob_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Ta mwaꞌadega, sawesawemiya be ꞌemiyega ꞌebweu yaita ꞌigu bubuna toꞌumalina ꞌida simana apwese? Nai nigeya sawesawemiya, aga? Ta ꞌeguma ona ꞌaiꞌailega yaonaona ꞌemiya, tuwa tuga nigeya wada emisegu. ");
INSERT INTO dob_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Manuna ꞌeguma yaita tauna Yaubada ꞌenega ꞌimai, tauna Yaubada ꞌina onao ꞌinonodi. Ta ꞌomi nai nigeya Yaubada ꞌenega wameema, nate ꞌalena ꞌenega nigeya Yaubada ꞌina ona wada nonona.” ");
INSERT INTO dob_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Gote ꞌena me Yudia ꞌidi ꞌinapwanao Yesu ꞌena sigwae, “ꞌIma ona lowa ꞌana ꞌaiꞌaila niꞌatu ꞌiapwesa, manuna ꞌagwae, ꞌaene ꞌoyo ꞌebweu goma Samelia, ꞌenega yaluyaluwa biꞌi ꞌemuya ꞌipaipaisewa.” ");
INSERT INTO dob_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ꞌEnega Yesu ꞌinapwanao nidi ꞌieonedi, ꞌigwae, “ꞌAboꞌagu nigeya ꞌebweu yaluyaluwa biꞌi ꞌeguya, manuna Tamagu yaꞌamayaba ꞌaiꞌailina, ta ꞌomi esi nigeya waꞌamaꞌamayabegu. ");
INSERT INTO dob_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ꞌAboꞌagu nigeya taugu ꞌagu esana yagitugituꞌeye, ta esi ꞌebweuna toloina tauna ꞌagu esana ꞌana togituꞌe ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yaona ꞌaiꞌaila ꞌemiya, ꞌabo yaita ꞌigu ona ꞌimuliya ꞌaiꞌailidi, tauna geyaꞌabo saꞌi ꞌimwawamwawasa.” ");
INSERT INTO dob_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ꞌEnega me Yudia nidi Yesu sieonena, sigwae, “Niꞌatu ꞌamwalatoi ꞌaiꞌailimu ꞌaene yaluyaluwa biꞌi ꞌemuya ꞌipaipaisewa, manuna Ebelaamo ꞌamwalatonina ꞌaene niꞌatu ꞌimwawasa, ta wate palopitao ꞌamwalatonidi ꞌaene niꞌatu simwawasa, ta ꞌugwaegwae ꞌaene ‘ꞌEguma yaita ꞌigu ona ꞌimuliya ꞌaiꞌailidi, geyaꞌabo saꞌi ꞌimwawamwawasa.’ ");
INSERT INTO dob_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","To tai sana ꞌoyo? Tamamai Ebelaamo niꞌatu ꞌimwawasa, ꞌenega geyaꞌabo ꞌutootoo be ꞌaene ꞌusinabwasine. Wate palopitao niꞌatu simwawasa, ta ꞌoyo ꞌunuwena ꞌaene ꞌusinabwa sinedi, aga?” ");
INSERT INTO dob_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ga Yesu ꞌediya ꞌigwae, “ꞌEguma ꞌaboꞌagu taugu yatupugu, ꞌagu tupu nina yage besobeso tuga, ta Tamagu tauna ꞌagu totupu nina, tauna waona ꞌaene ꞌimi Yaubada. ");
INSERT INTO dob_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ꞌOmi nigeya Yaubada wamwalamwalatoni, ta esi ꞌaboꞌagu yamwalatonina. Manuna ꞌeguma yagwae, ‘Nigeya yamwalamwalatoni’, nate kabo tuga, nadigega ꞌomi ꞌimi kabo. Ta esi yamwalatonina, ꞌenega ꞌina ona yaematamatanena. ");
INSERT INTO dob_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ta tamamiya Ebelaamo ma ina gwausowala be ꞌaene ꞌigu tuta ꞌida ꞌita, ga niꞌatu ꞌiꞌitena ꞌenega ꞌigwausowala sinabwana.” ");
INSERT INTO dob_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ꞌEnega me Yudia nidi ꞌena sigwae, “ꞌOyo ꞌetamo nigeya ꞌamu yakwala pipiti ꞌulobaloba, ta ꞌuona ꞌaene Ebelaamo ꞌuꞌitena.” ");
INSERT INTO dob_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ga gote ꞌinapwanao nidi ꞌieonedi, ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya, ꞌaene muliyega be Ebelaamo ꞌitutubuwa ta ꞌaboꞌagu tuga yamiyami.” ");
INSERT INTO dob_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ꞌEnega me Yudia nidi gulewa siꞌewedi be ꞌaene sida loemwawasi, ta Yesu ꞌediyega ꞌiakwaiya ga Anuwa Tabuyega ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ꞌEnega mali tuta Yesu ꞌitautauya ꞌedaya ga tai ꞌebweu ꞌilobena matana kebokebona adelina ꞌitubuwenama. ");
INSERT INTO dob_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ta ꞌana tomuliyao tai nina wate siꞌitena, ꞌenega Yesu sienaidena, sigwae, “Toeꞌita, yaita ꞌina toꞌumalina ga ꞌenega tai gete mamata kebokebona ꞌitubuwa, tauna nai tamana be sinana?” ");
INSERT INTO dob_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ꞌEnega Yesu ꞌieonedi, ꞌigwae, “Nigeya tauna ꞌina loegesiyega, nai tamana be sinana, ta tuga mamata kebokebona ꞌitubuwa, be ꞌenega Yaubada ꞌina guinuwa waiwaina ꞌenaya ꞌida eꞌitae tomota yauyaudi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tauna ꞌietuneguma ꞌina guinuwa tada guinuwedi tuta ꞌasiyata ꞌena, manuna ꞌeguma boiboi ꞌimamai nigeya ꞌebweu yaita sawesawenaya be ꞌida paisewa. ");
INSERT INTO dob_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ꞌEnega ꞌaboꞌagu tuta nina baleꞌu ꞌena yamiyami, ꞌaboꞌagu baleꞌu ꞌana maedana.” ");
INSERT INTO dob_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Niꞌatu ona gete ꞌiꞌinanedi ꞌenega baleꞌuya ꞌigiwala ga sepwala ꞌiguinuwena, ꞌenega sepwala nina ꞌiꞌewena ga tai nina matana ꞌiꞌeꞌabina, ");
INSERT INTO dob_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ta ꞌenega ꞌieonena, ꞌigwae, “ꞌUtatauya be Sailoma bwasina ꞌena ꞌuꞌesiwe.” (Sailoma ꞌana gibui “Etune”). ꞌEnega ꞌitauya ga ꞌiꞌesiwe, ta matana ꞌiꞌesasedi, ga ꞌenega ꞌiilama. ");
INSERT INTO dob_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Gote ꞌena tai nina gosenao be wate ꞌaidi tomota simwalatonina ꞌaene tauna toesidasida, ga sigwae, “ꞌAene tauna gete toesidasida nina tuta yauna ꞌimiyami ta ꞌiesidasida, aga?” ");
INSERT INTO dob_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ta ꞌenega ꞌaidi sigwae, “Tauna tuga”, ta ꞌaidi sigwae, “Nigeya! Mali tai. Ta esi ꞌana ꞌita nadigega tuga.” Ta tai nina ꞌigwae, “ꞌAboꞌagu tuga.” ");
INSERT INTO dob_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ꞌEnega sieonena, “Mwaꞌadega ga ꞌenega matayo ꞌiꞌesasedi?” ");
INSERT INTO dob_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ga ꞌieonedi, ꞌigwae, “ꞌEbweu tai ꞌana esana Yesu, sepwala ꞌiguinuwena ga matagu ꞌiꞌeꞌabina, ꞌenega ꞌeguya ꞌigwae, ‘ꞌUtatauya Sailoma bwasina ꞌena be ꞌuꞌesiwe.’ Ta yatauya ga yaꞌesiwe, ga matagu ꞌiꞌesasedi.” ");
INSERT INTO dob_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ꞌEnega taudi sienaidena, sigwae, “Mwaꞌo tauna?” Ta tai nina ꞌigwae, “Nigeya yamwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Yesu ꞌasiyata Sabate ꞌena tai nina matana sepwalega ꞌigieboboꞌanena, nate ꞌalena tai nina siꞌauꞌewena Palisiyao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ga ꞌenega Palisiyao nidi tomata kebokebo nina sienaida limena, “Mwaꞌadega ga matayo ꞌiꞌesasedi?” ꞌEnega ꞌieonedi, ꞌigwae, “Yesu sepwala ꞌiguinuwena ga mataguya ꞌisaꞌudi ga yaꞌutuna, ꞌenega matagu ꞌiꞌesasedi.” ");
INSERT INTO dob_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ga ꞌaidi Palisiyao sigwae, “Tauna toguinuwa nina nigeya Yaubada ꞌenega, manuna Sabate ꞌana loina nigeya ꞌida muliyena.” Ta ꞌaidi wate sigwae, “Mwaꞌadega be totoꞌumalina weꞌiweꞌiyaya gete nadigega ꞌida guinuwaꞌese? Nai nigeya sawesawenaya, aga?” Gote ꞌena weyala ꞌiapwesa be ꞌaidi ꞌidi ona dumadumadi be dumadumadi. ");
INSERT INTO dob_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ꞌEnega wate Palisiyao nidi tomata kebokebo sienaida limena, sigwae, “Ta ꞌoyo mwaꞌadega ꞌimu nuwanuwa tauna matayo ꞌigieꞌesasedi manuna?” Ga ꞌigwae, “Tauna palopita ꞌebweu.” ");
INSERT INTO dob_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ta me Yudia nidi nigeya siemiemisa ꞌaene tai nina mamata kebokebona ꞌitubuwa ta gete tugai ꞌiꞌesasedi. ꞌEnega tamana be sinana sibwauyedima, ");
INSERT INTO dob_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ga sienaidedi, sigwae, “ꞌAene gwama gete natumiya? Wada simana ꞌabo gwama gete mamata kebokebona ꞌitubuwaya? Ta mwaꞌadega ga ꞌenega matana ꞌiꞌesasedi?” ");
INSERT INTO dob_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ꞌEnega tai nina tamana be sinana Palisiyao ꞌediya sigwae, “ꞌAmwalamwalatoni tauna natumai ta wate mamata kebokebona ꞌitubuwa, ");
INSERT INTO dob_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ta esi nigeya ꞌamwalamwalatoni mwaꞌadega ga matana ꞌiꞌesasena, ta wate yaita ꞌigieꞌesasenaya nigeya ꞌamwalamwalatoni. Ta baga wada enaide be tauna manuna ꞌida ona, manuna niꞌatu ꞌisinabwa.” ");
INSERT INTO dob_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamana be sinana ona gete siꞌinanena manuna ꞌidi ꞌinapwanao ꞌediya simatauta, manuna ꞌinapwanao nidi ꞌidi loina sisaꞌuna be ꞌaene ꞌeguma yaita Yesu ꞌida ꞌawa toꞌetoseyanei taudi anuwa tapwaloloega sida eꞌidiꞌidiyedi. ");
INSERT INTO dob_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gete ꞌalena ꞌenega tai nina tamana be sinana sigwae, “Tauna wada enaide, manuna niꞌatu ꞌisinabwa.” ");
INSERT INTO dob_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ꞌEnega wate tomata kebokebo nina sibwau limena ga sieonena, sigwae, “ꞌUsimana palupalu ꞌemaya, manuna tai nina ꞌamwalamwalatoni ꞌaene tauna totoꞌumalina.” ");
INSERT INTO dob_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ta ꞌigwae, “Nigeya yamwalamwalatoni nai tauna totoꞌumalina nai nigeya. Ta nate namo yamwalatonina, ꞌaene matagu ꞌikebo ga niꞌatu ꞌigieꞌesasedi.” ");
INSERT INTO dob_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ꞌEnega ꞌena sigwae, “Toꞌase ꞌiguinuwena ga ꞌenega matayo ꞌiꞌesasedi?” ");
INSERT INTO dob_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ga ꞌigwae, “Niꞌatu yaeonemi, ta nigeya ꞌenagu wanoonodi. Toꞌase ꞌalena be nuwanuwami wada nonolima? Nai nuwanuwami be ꞌaene ꞌomi ꞌana tomuliyao, aga?” ");
INSERT INTO dob_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gote ꞌena sieliyena ga sigwae, “ꞌOyo tuga ꞌana tomuliya niyo, ta ꞌaboꞌama Mosese ꞌana tomuliyao, ");
INSERT INTO dob_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","manuna niꞌatu ꞌamwalatonina ꞌaene Yaubada ꞌina simana Mosese ꞌenaya, ta esi tai nina Yesu nigeya ꞌamwalamwalatoni mane ꞌenega ꞌimai.” ");
INSERT INTO dob_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ꞌEnega tai nina ꞌediya ꞌigwae, “Gete yage kwanikwanina. Tai nina matagu ꞌigieꞌesasedi ta nigeya wamwalamwalatoni ꞌaene mane ꞌenega ꞌimai. ");
INSERT INTO dob_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Niꞌatu tamwalatonina ꞌaene Yaubada nigeya totoꞌumalidi ꞌenadi ꞌida muliyedi, ta esi ꞌeguma ꞌebweu yaita Yaubada ꞌida ꞌamayabe be ꞌina nuwena ꞌida guinuwei, Yaubada tai nina ꞌenana ꞌida muliye. ");
INSERT INTO dob_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Niꞌatu tamwalamwalatoni ꞌaene lowaenei ga batuwa nigeya ꞌebweu yaita tanonono ꞌaene tomata kebokebo ꞌida gieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ꞌEnega ꞌeguma tai gete nigeya Yaubada ꞌenega, nai nigeya sawesawenaya be weꞌiweꞌiyaya gete nadigega ꞌida guinuwa.” ");
INSERT INTO dob_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ꞌEnega Palisiyao tai nina sieonena, sigwae, “ꞌOyo tuga totoꞌumaliyo ꞌimu tuta gwamega ga batuwa, ta ꞌaene ꞌutoo be ꞌueꞌitama, aga? Yaita sana ꞌoyo?” Ga gote ꞌenega sipaꞌina ga anuwa tapwaloloega ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ta Yesu tai nina alena ꞌinonona ꞌaene anuwa tapwalolo ꞌenega sipaꞌina, ꞌenega ꞌiꞌebesena ga tuta nina ꞌilobena ꞌieonena, ꞌigwae, “Toꞌetoseyana nina ꞌuemisenaya, aga?” ");
INSERT INTO dob_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ga tai nina ꞌigwae, “ꞌInapwana, yaita tauna be ꞌena yada emisa?” ");
INSERT INTO dob_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ta Yesu ꞌieonena, “Tai nina gete tuga ꞌuꞌitaꞌitai maꞌiyayo waeonaona.” ");
INSERT INTO dob_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ꞌEnega tai nina ꞌigwae, “ꞌInapwana, niꞌatu yaemisemu,” ta ꞌiꞌaetulasa ga ꞌena ꞌibwagobwago. ");
INSERT INTO dob_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ta Yesu ꞌigwae, “ꞌAboꞌagu baleꞌuya niꞌatu yamai be yada loinemi, ꞌenega taudi tomata kebokebo sida ꞌita, ta taudi matadi ꞌesasena sida kebo.” ");
INSERT INTO dob_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ꞌEnega Palisiyao nidi Yesu ꞌina ona sinonona ga sigwae, “Mwaꞌadega ꞌaene ꞌaboꞌama wate mata kebokeboma, aga?” ");
INSERT INTO dob_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ga Yesu ꞌieonedi, ꞌigwae, “ꞌEguma ꞌomi matami kebokebodi geyaꞌabo saꞌi bubuna toꞌumalidi ꞌemiya ꞌimiyami, ta esi manuna wagwae, ‘ꞌAboꞌama matama ꞌesasedi’, ꞌenega ꞌimi bubuna toꞌumalina tuga ꞌimiya ataya.” ");
INSERT INTO dob_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ta Yesu wate ꞌediya ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya, ꞌabo yaita sipi ꞌadi ꞌali ꞌawanega nigeya ꞌilugulugu ta mali senega ꞌimwela taona, tauna tuga toꞌipwala. ");
INSERT INTO dob_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ta ꞌeguma yaita sipi ꞌidi ꞌawa ꞌenega ꞌilulugu, tauna sipi ꞌadi toꞌitaꞌiꞌita ꞌaiꞌaila, ");
INSERT INTO dob_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","manuna ꞌidi ꞌawa nina ꞌana toꞌitaꞌiꞌita ꞌawa ꞌigigegena be toꞌitaꞌiꞌita sipi nina ꞌilulugu be ꞌina sipiyao ꞌadi esanega ꞌibwauyedi, ta ꞌenana sinono be ꞌenega simuliye ta siapwesa ꞌatamanaya. ");
INSERT INTO dob_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Niꞌatu maiboꞌadi siapwesa, ta ꞌadi toꞌitaꞌiꞌita ꞌinugana be simulimuliye, manuna ꞌenana simwalatonina ta niꞌatu sipanaitena. ");
INSERT INTO dob_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ta sipi nidi geyaꞌabo mali tomota simulimuliyedi, ta ꞌediyega sida dena, manuna ꞌenadi nigeya simwalamwalatonidi ta wate nigeya sipanapanaitedi.” ");
INSERT INTO dob_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ona semalimali gete Yesu ꞌisimanena ꞌediya, ta yage nina manuna ꞌionaona nigeya ꞌimaemaedana taudi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ta Yesu ꞌediya ꞌionalimana, ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya, ꞌaboꞌagu sipi ꞌidi ꞌawa nina. ");
INSERT INTO dob_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ta lowa togimi ꞌitaꞌiꞌita nidi, taudi toꞌipwala, ga sipi nigeya ꞌenadi sida nonona.” ");
INSERT INTO dob_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ꞌEnega wate ꞌediya ꞌigwae, “ꞌAboꞌagu tuga ꞌawa nina, be ꞌabo yaita tauna ꞌeguyega ꞌiluguma ꞌida boboꞌana, manuna tuta yauna ꞌiluguluguma be ꞌiapweapwesa ta pwatula boboꞌana ꞌilobaloba. ");
INSERT INTO dob_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ta toꞌipwala taudi tuga ꞌidi guinuwa nate simamai be siꞌiꞌipwala ta siloemwawasa ta wate sigietoꞌumali, ta ꞌaboꞌagu yamai be ꞌenega tomota yawasidi boboꞌana ta maamaana ꞌeguyega sida loba.” ");
INSERT INTO dob_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ta wate ꞌediya ꞌigwae, “ꞌAboꞌagu sipi ꞌadi toꞌitaꞌiꞌita boboꞌana, ꞌenega yawasigu yatagwalena be ꞌigu sipiyao manudi yamwamwawasa. ");
INSERT INTO dob_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ta ꞌabo yaita nigeya tonisipi, ta maisa manuna ꞌietoꞌitaꞌiꞌita, be ꞌabo kedewa bosasa ꞌiꞌita ꞌimeema, sipi nidi ꞌipilisinedi ta ꞌidedena. Ta kedewa nina sipi ꞌaidi ꞌiloemwawasidi, be matautega sipi maiboꞌadi siꞌelelewana. ");
INSERT INTO dob_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tai nina ꞌina dena ꞌalena tuga maisa manuna ꞌipaipaisewa, ta sipi nidi mali tai ꞌina sipiyao, ꞌenega nigeya manudi ꞌinuwanuwa. ");
INSERT INTO dob_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ꞌEnega wate ꞌieonedi, “ꞌAboꞌagu sipi ꞌadi toꞌitaꞌiꞌita boboꞌana, manuna ꞌigu sipiyao yamwalamwalatonidi ta taudi simwalamwalatonigu. ");
INSERT INTO dob_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nadigega tuga Tamagu ꞌimwalatonigu ta ꞌaboꞌagu wate yamwalatonina. Ta wate ꞌaboꞌagu yawasigu niꞌatu yatagwalena be ꞌigu sipiyao manudi yamwamwawasa. ");
INSERT INTO dob_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ꞌAina wate ꞌigu sipiyao simiyami, nate taudi gete tuga nigeya ꞌigu ꞌali ꞌena simiyami, taudi sipi nidi yatootoodi be ꞌeguya yameꞌedi be ꞌenega ꞌenagu sinono ta simama ꞌeguya, be magosediyao sida eboda ꞌebweuna, ta ꞌadi toꞌitaꞌiꞌita ꞌebweuna tuga. ");
INSERT INTO dob_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tamagu ꞌioboboma ꞌaiꞌailigu manuna yawasigu yatagwalena be ꞌaene yamwamwawasa, ꞌenega maꞌetamo yawasigu wate yada lobalimai. ");
INSERT INTO dob_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nigeya ꞌebweu yaita ꞌiloiloinegu be yamwamwawasa. Taugu tuga yatagwalegu be yamwamwawasa, ta sawesaweguya be yawasigu yaꞌewa limai. Manuna gete nadigega Tamagu ꞌina nuwena, ta wate ꞌina loina ꞌeguya.” ");
INSERT INTO dob_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ta Yesu ꞌina ona gete manudi ga me Yudia nidi wate taudimo ꞌediya siegewagewana sinabwana, ꞌenega weyala ꞌediya ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ga tomota yau wawasae sigwae, “Tauna yaluyaluwa biꞌi ꞌenaya, ga ꞌigiekabaleyena. Geyaꞌabo ꞌina ona wanoonodi.” ");
INSERT INTO dob_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ta ꞌaidi wate sigwae, “Gete nigeya nadigega yaluyaluwa biꞌi ꞌina ona, ta mwaꞌadega ga waona ꞌaene yaluyaluwa biꞌi sawesawenaya be tomata kebokebo matana ꞌida gieꞌesasadi? Nigeya sawesawenaya!” ");
INSERT INTO dob_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tuta nina gogai ꞌana tutaya ꞌebweu sagali siguinuwena, nate Anuwa Tabu ꞌana gieꞌesasa manuna. ");
INSERT INTO dob_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Tuta nina ꞌena Yesu Anuwa Tabu solanaya ꞌilopili dadana, ꞌebweu pitaupa ꞌenaya, nate sieesena Kini Solomoni ꞌina ꞌaliupa. ");
INSERT INTO dob_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ga gote ꞌena me Yudia nidi Yesu siasakowasiyena ga sieonena, sigwae, “ꞌOyo tuta yauna ꞌugiegie nuwanaluwema, ta to tuta ꞌena be ꞌenega ꞌemaya ꞌuda simana ꞌaiꞌaila ꞌaene ꞌoyo Toꞌetoseyana nina?” ");
INSERT INTO dob_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ga Yesu ꞌediya ꞌigwae, “Niꞌatu ꞌemiya yasimana ta esi nigeya waemiemisegu. Ta wate guinuwa nidi Tamagu ꞌana esanega yaguinuwediya ꞌediyega niꞌatu sieꞌitaegu, ");
INSERT INTO dob_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ta tuwa tuga nigeya wada emisegu, manuna ꞌomi nigeya ꞌigu sipiyao. ");
INSERT INTO dob_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ta ꞌaboꞌagu ꞌigu sipiyao ꞌenagu sinonona, ta taudi wate yamwalatonidi ga ꞌenega simulimuliyegu, ");
INSERT INTO dob_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ta yawasidi ataya yaꞌebwaꞌedi be ꞌenega geyaꞌabo sitoꞌutoꞌumali, ta wate geyaꞌabo ꞌebweu yaita nimaguyega ꞌiꞌoaeꞌoaegu. ");
INSERT INTO dob_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Taudi sipi nidi Tamagu ꞌiꞌebwaꞌeguya ꞌenega geyaꞌabo yaita saꞌi Tamagu nimanega ꞌiꞌoaeꞌoaena, manuna tauna yage yauyauna ꞌiloetana sinedi. ");
INSERT INTO dob_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ꞌAboꞌagu be Tamagu ꞌebweuna tuga.” ");
INSERT INTO dob_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ꞌEnega me Yudia nidi wate gulewa siꞌewedi ga ꞌaene Yesu sida loemwawasi. ");
INSERT INTO dob_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ta Yesu ꞌiꞌitedi ga ꞌediya ꞌigwae, “Guinuwa yaudi ta boboꞌadi Tamagu ꞌenega niꞌatu yaguinuwedi ꞌemiya, ta to guinuwa sana manuna wanuwanuwa ꞌaene toꞌumalina, ga ꞌenega ꞌaene gulewega wada loemwawasigu?” ");
INSERT INTO dob_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ꞌEnega me Yudia nidi Yesu ꞌina ona sieꞌisena, sigwae, “Nigeya ꞌaene ꞌimu guinuwa boboꞌana manudi ꞌaunuyo, ta esi ꞌimu ona oopaꞌala manuna. Manuna ꞌoyo tai tuga ta ꞌuona ꞌaene ꞌoyo Yaubada.” ");
INSERT INTO dob_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ta Yesu wate ꞌediya ꞌigwae, “Loina ꞌetoꞌetoladina ꞌimi Buki Tabu solanaya, ꞌigwae, ‘Niꞌatu yaona ꞌaene ꞌomi yaubada nimi.’ ");
INSERT INTO dob_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ta tamwalatonina ꞌaene Buki Tabu ꞌina simana maiboꞌana nigeya kabo, ta Buki Tabu nadigega ꞌina simana be ꞌaene taudi Yaubada ꞌina ona ꞌiꞌebwaꞌediya ꞌieesedi yaubadao. ");
INSERT INTO dob_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ꞌEnega toꞌase ꞌalena tuta nina yagwae, ꞌaene ꞌaboꞌagu Yaubada natuna, ga ꞌigu ona nina manuna wanuwena ꞌaene ona oopaꞌala? Ta ꞌaboꞌagu ꞌiesinuwegu ta ꞌietuneguma ga baleꞌuya yamai be ꞌina guinuwa yada guinuwei. ");
INSERT INTO dob_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“ꞌEnega ꞌeguma wanuwena ꞌaene ꞌaboꞌagu Tamagu ꞌina guinuwa nigeya yaguiguinuwei, geyaꞌabo waemiemisegu. ");
INSERT INTO dob_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ta esi ꞌeguma wanuwena ꞌaene guinuwa nidi yaguiguinuwedi, ta nigeya waemiemisegu, tuwa tuga guinuwa dimo wada emisedi, be gote ꞌenega sida giesana ilemi be wada mwalatonigu ꞌaene ꞌaboꞌagu Tamagu ꞌeguya ꞌimiyami, ta ꞌaboꞌagu wate Tamagu ꞌena yamiyami.” ");
INSERT INTO dob_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gote ꞌena me Yudia nidi wate sitoona be ꞌaene sigiyai, ta esi ꞌipili sinedi. ");
INSERT INTO dob_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ꞌEnega ꞌitauya ga Yolidani bwasina ꞌiabala limena, nate Yoni ꞌina ꞌebe giebapitaiso lowa senanaya, ga nada ꞌiloꞌasa, ");
INSERT INTO dob_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ga gote ꞌena tomota yaudi ꞌenaya simai ga taudimo ꞌediya sigwae, “Yoni nigeya ꞌebweu guinuwa waiwaina ꞌiguiguinuwedi, ta esi Yoni ꞌina simana tai gete manuna ꞌaiꞌailina ꞌiapwesama.” ");
INSERT INTO dob_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ꞌEnega sena nina ꞌena tomota yaudi Yesu siemisena. ");
INSERT INTO dob_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ꞌEbweu tai leꞌoaleꞌoasina ꞌana esana Lasalo. Lasalo tauna Betani taina, ta wate nuunao ꞌeluwa, nate Meli be Malida maꞌenao simiyami. ");
INSERT INTO dob_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ta Meli nina tauna maꞌetamo Yesu ꞌaena ꞌida bunamidi be ꞌuyaꞌuyanega ꞌida loꞌiꞌili. ");
INSERT INTO dob_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ta tuta nina nuudina Lasalo ꞌileꞌoasa ga taudi nuunao nidi ale sietunena Yesu ꞌena, sigwae, “ꞌInapwana, gosiyamuna niꞌatu ꞌileꞌoasa.” ");
INSERT INTO dob_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ta Yesu ale nina ꞌinononaya ta tomota ꞌediya ꞌigwae, “Leꞌoasa gete ꞌana mwalatoi ꞌaene Lasalo geyaꞌabo ꞌimwawamwawasa, ta esi leꞌoasa gete ꞌiapwesa be ꞌenega tomota yauyaudi Yaubada sida tupu, ta wate Natuna sida tupu.” ");
INSERT INTO dob_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ta Yesu, Malida be tasina ta wate nuudiya Lasalo ꞌiobobomedi sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ꞌEnega tuta nina ale ꞌinononaya ꞌaene Lasalo ꞌileꞌoasa, ga sena nina ꞌena wate ꞌasiyata ꞌeluwa ꞌimiya ila. ");
INSERT INTO dob_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ꞌEnega niꞌatu ꞌasiyata sigumwala, ꞌina tononoyao ꞌediya ꞌigwae, “Gete tuga taila Yudia ꞌena.” ");
INSERT INTO dob_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ga ꞌina tononoyao nidi Yesu sieonena, “ꞌInapwana, geyaꞌabo tatautauya sena nina ꞌena, manuna me Yudia ꞌetamo tuga nuwanuwadi ꞌaene gulewega sida unuyo.” ");
INSERT INTO dob_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ta Yesu ꞌediya ꞌigwae, “ꞌAsiyata ꞌana maiboꞌana ꞌena nate gonegonega be ꞌana laba ꞌasuinuwanuwa. ꞌEnega ꞌeguma yaita ꞌasiyataya ꞌitatauya geyaꞌabo ꞌieseesetupe, manuna niꞌatu baleꞌu ꞌana maedana ꞌimiyami, ");
INSERT INTO dob_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ta esi ꞌeguma guguyoi ꞌena ꞌitautauya maꞌetamo ꞌiesetupei, manuna nigeya maedana ꞌena ꞌimiyami.” ");
INSERT INTO dob_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ꞌEnega niꞌatu yage getedi ꞌiꞌinanedi ta wate ꞌediya ꞌigwae, “Gosedai nina Lasalo niꞌatu ꞌiꞌeno mwataya, ꞌenega yatatauya be yalowanowanoi.” ");
INSERT INTO dob_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ta tonono nidi siona, “ꞌInapwana, ꞌunuwena ꞌeguma ꞌiꞌeno mwataya nate ꞌiabe ꞌiboboꞌana.” ");
INSERT INTO dob_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ta Yesu ꞌina ona ꞌana mwalatoi ꞌaene Lasalo niꞌatu ꞌimwawasa, ta esi tononoyao ꞌidi nuwanuwa ꞌaene tuga ꞌenomwataiya manuna ꞌionaona. ");
INSERT INTO dob_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ꞌEnega Yesu ꞌediya ꞌiona apwesa ꞌaiꞌaila, ꞌigwae, “Lasalo niꞌatu ꞌimwawasa, ");
INSERT INTO dob_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ta yagwausowala manuna ꞌina mwawasa nina nigeya ꞌena yamiyami, be gote ꞌenega ꞌigu guinuwa wada ꞌita be wada emisegu. Boboꞌana, ta tuwa tuga tatatauya be taꞌita.” ");
INSERT INTO dob_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ta Tomasi tauna sieesena Didiluwaluwa, ꞌilolagata ga gosenao ꞌediya ꞌiona, “Tuwa, ꞌida toeꞌita maꞌeda tatatauya, be ꞌenega ꞌeguma ꞌimwamwawasa, ꞌaboꞌada wate tamwamwawasa.” ");
INSERT INTO dob_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ta niꞌatu Yesu ꞌimai Betani selabenaya ga ale ꞌinonona ꞌaene niꞌatu ꞌasiyata ata ꞌigumwala ꞌediya Lasalo sisaꞌu ꞌaliꞌaliyena. ");
INSERT INTO dob_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani be Yelusalema nigeya ꞌedasola, ");
INSERT INTO dob_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ꞌenega me Yudia yaudi ma idi ꞌatenuwaꞌoleꞌole simai be ꞌaene Malida be Meli nuwadi tupwana sida gieboboꞌanedi nuudina manuna. ");
INSERT INTO dob_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ta Malida ale ꞌinonona ꞌaene Yesu ꞌimeemai, ꞌenega taunamo ꞌiapwesa ꞌedaya be Yesu ꞌiaesote, ta tasina Meli anuwaya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ga Malida nina Yesu ꞌilobena ga ꞌena ꞌigwae, “ꞌInapwana, ꞌeguma ꞌoyo lowa bada ꞌumiyamiya, geyaꞌabo saꞌi nuugu ꞌimwawamwawasa. ");
INSERT INTO dob_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ta yamwalatonina ꞌaene tuta gete ꞌeguma toꞌase manuna Yaubada ꞌena ꞌusisida ꞌida ꞌebwaꞌeyo tuga.” ");
INSERT INTO dob_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ꞌEnega Yesu Malida ꞌena ꞌigwae, “Nuuyo mwawasega ꞌida toololimana.” ");
INSERT INTO dob_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ga waine nina ꞌigwae, “O, yamwalamwalatoni ꞌaene maꞌetamo tuta ꞌana ꞌebe losalowa ꞌenaya mwawasega ꞌida toololimana.” ");
INSERT INTO dob_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ga Yesu wate ꞌena ꞌiona, “ꞌAboꞌagu toololimana ꞌaledi be wate yawasi ꞌaiꞌaila. ꞌEnega ꞌabo yaita tauna ꞌiemisegu ta tuta nina ꞌimwamwawasa, yawasina ataya ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ta ꞌeguma yaisigedi taudi mayawasidi siemisegu, geyaꞌabo saꞌi simwawamwawasa. Ta ꞌoyo mwaꞌadega? ꞌIgu ona gete manuna ꞌuemiseguya nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ta Malida ꞌigwae, “ꞌInapwana, nadigega yaemisemu ꞌaene ꞌoyo Toꞌetoseyana niyo, Yaubada natuna baleꞌuya ꞌumai.” ");
INSERT INTO dob_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Niꞌatu Malida ꞌina ona mulinaya ga ꞌiila anuwaya ga nada tasina Meli ꞌieona maꞌulena, ꞌigwae, “Toeꞌita nina niꞌatu ꞌimai ga ꞌienaidemu.” ");
INSERT INTO dob_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ꞌEnega Meli ꞌinonona ga ꞌitoolo manini ta ꞌiapwesa sabi ꞌitana. ");
INSERT INTO dob_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ta Yesu maꞌetamo nigeya ꞌimeema ꞌasaya, ta esi tuga sena nina ꞌena niꞌa Malida ꞌilobena. ");
INSERT INTO dob_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ta me Yudia nidi taudi Meli maꞌenao anuwaya sidedoi, Meli ꞌina tauya siꞌitena ga sinuwena ꞌaene ꞌitautauya ꞌaliꞌaliya sabi dedoi, ꞌenega mulinega sitauya. ");
INSERT INTO dob_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ta Meli sena nina ꞌena ꞌiapwesa ga Yesu ꞌiꞌitena, ꞌenega matanaya ꞌibwago sanamwaꞌuta ga ꞌena ꞌigwae, “ꞌInapwana, ꞌeguma ꞌoyo bada lowa ꞌumiyamiya, geyaꞌabo nuugu ꞌimwawamwawasa.” ");
INSERT INTO dob_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ga gote ꞌena Yesu Meli ꞌina dedoi ꞌiꞌitena, ta wate me Yudia nidi taudi maꞌenao simai ꞌidi dedoi wate ꞌiꞌitena, ga ꞌatena ꞌiuya, ꞌenega nuwana ꞌimwau sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ga ꞌediya ꞌienaida, ꞌigwae, “Mane ꞌena ꞌana ꞌaliꞌali?” Ga sigwae, “ꞌInapwana, ꞌumai be ꞌaeꞌitayo.” ");
INSERT INTO dob_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ga gote ꞌena Yesu wate ꞌidedoi. ");
INSERT INTO dob_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ta me Yudia nidi Yesu ꞌina dedoi siꞌitena, ꞌenega sigwae, “Onaꞌaiꞌaila, gosiyanana ꞌiobobomena sinabwana.” ");
INSERT INTO dob_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ta ꞌaidi ꞌediyega sigwae, “Yesu nina ma ina waiwai, ga sawesawenaya tomata kebokeboyao matadi ꞌigieꞌesasedi, aga? Ta mwaꞌadega ga ꞌenega nigeya ꞌimeemai lowa be gosiyanana ꞌigieboboꞌane be ꞌana leꞌoasega geyaꞌabo ꞌimwawamwawasa?” ");
INSERT INTO dob_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ta Yesu tuga ma ina nuwamwau ta ꞌilaga ꞌaliꞌali ꞌenaya, ta ꞌaliꞌali nina tuga gaula, ꞌenega ꞌana ꞌawa ꞌenaya gulewega siꞌaubodena. ");
INSERT INTO dob_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ꞌEnega Yesu boda ꞌediya ꞌigwae, “Gulewa nina gote waꞌewa yaule.” Ta Malida, tauna tokwaiya nuuna, Yesu ꞌieonena, ꞌigwae, “ꞌInapwana, niꞌatu ꞌimwaulu, manuna ꞌasiyata ata niꞌatu sigumwala ꞌena sisaꞌuna.” ");
INSERT INTO dob_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ta Yesu Malida ꞌieonena, “Niꞌa yasimana ꞌemuya ꞌaene ꞌeguma ꞌuemisegu, maꞌetamo Yaubada ꞌina waiwai ꞌuda ꞌita.” ");
INSERT INTO dob_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ꞌEnega gulewa nina siꞌewa yaulena ga Yesu ꞌiꞌitatuꞌe ga ꞌigwae, “Tamagu, kagutoki sinabwana, manuna tuta gete ꞌenaya ꞌunonogu. ");
INSERT INTO dob_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Niꞌatu yamwalatonimu ꞌaene tuta yauna ꞌigu sida ꞌunonodi, ta gete tugai yasidasidawa tomota getedi manudi, ꞌenega ꞌimu waiwai sida ꞌita be sida emisa ꞌaiꞌaila ꞌaene ꞌoyo ꞌuetuneguma.” ");
INSERT INTO dob_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ta ꞌina sida mulinaya ꞌenana sinabwanega ꞌibwau ga ꞌigwae, “Lasalo, ꞌuapwesama!” ");
INSERT INTO dob_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ga tomwawasa nina ma ꞌana nugwa ꞌiapwesama, nimana be ꞌaena ta wate maninina ꞌoamega sinugwena, ꞌenega Yesu boda ꞌieonedi, ꞌigwae, “Waliꞌami be ꞌoama nina weꞌewa yaule ta wagisine be ꞌitatauya.” ");
INSERT INTO dob_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Gote ꞌena me Yudia nidi, taudi Meli ꞌana toayausao, Yesu ꞌina guinuwa siꞌitena, ga yaudi siemisa ꞌaiꞌailena, ");
INSERT INTO dob_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ta esi ꞌaidi nigeya siemisemise, ga siila limana Palisiyao ꞌediya, ga sisimanena toꞌase nadigega siꞌitena Yesu ꞌiguinuwena. ");
INSERT INTO dob_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ꞌEnega Palisiyao nidi be totaliyao ꞌidi ꞌinapwanao be wate toloinao maiboꞌadi siegogona, ga sigwae, “Tai nina toꞌase ꞌena tada guinuwe? Manuna guinuwa waiwaidi ꞌiguiguinuwedi. ");
INSERT INTO dob_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ta ꞌeguma geyaꞌabo tagiegie losaꞌuye, maꞌetamo tomota maiboꞌadi ꞌena sida emisa, be ꞌenega me Loma ꞌidi loina ꞌiapwesa, be ꞌida Anuwa Tabu be wate ꞌida boda maiboꞌadi sida gietoꞌumaliyedi.” ");
INSERT INTO dob_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ga ꞌebweu ꞌediyega ꞌana esana Kaiyapa tauna yakwala gote ꞌena totaliyao ꞌidi ꞌinapwana sinabwana, gosenao nidi ꞌieonedi, ꞌigwae, “ꞌOmi sana mwagemwagemi! ");
INSERT INTO dob_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ꞌEnega nigeya wanuwanuwa sabwalena ꞌaene yage boboꞌana ꞌedaya ꞌida apwesa ꞌeguma ꞌebweu tai maꞌetamo ꞌimwamwawasa tomota maiboꞌada manuda. Ta nigeya ꞌana ꞌita boboꞌana ꞌeguma ꞌaboꞌada me Yudia ꞌida boda sigiegie toꞌumaliye.” ");
INSERT INTO dob_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ta Kaiyapa nina ona getedi ꞌiꞌinanedi nigeya tauna ꞌina nuwenuwega, ta esi yakwala nina ꞌena tauna totaliyao ꞌidi ꞌinapwana, ꞌenega ꞌigimisimana ꞌaene Yesu ꞌiabe ꞌimwamwawasa me Yudia ꞌidi boda manudi, ");
INSERT INTO dob_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ta nigeya ꞌaene me Yudia dimo manudi, ta esi sena yauyaudi ꞌediya Yaubada ꞌina tomotaiyao ꞌida egogonedima be sieboda ꞌebweu. ");
INSERT INTO dob_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ꞌEnega ꞌasiyata nina gote ꞌena taudi toloinao nidi siloina leleleya be ꞌaene sida loemwawasi. ");
INSERT INTO dob_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Gote ꞌenega Yesu nigeya me Yudia matadiya ꞌida lopilidadana, ꞌenega ꞌipilisinedi ga ꞌitauya mitawa tupitupinaya ꞌebweu ꞌasa ꞌana esana Epileimi ꞌenaya, ga nada ma ina tononoyao simiyami. ");
INSERT INTO dob_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ta tuta nina ꞌena me Yudia ꞌidi Ataona Sagalina ꞌana tuta ꞌiloselabena, ꞌenega tomota yaudi ꞌidi ꞌasega situꞌe Yelusalema ꞌena sabi gieꞌesasadi be muliyega sagali nina sida guinuwe. ");
INSERT INTO dob_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Gote ꞌena Yesu siꞌebesena, ta tuta nina Anuwa Tabu ꞌena sitootoolo taudimo ꞌediya sieonaona, sigwae, “Mwaꞌadega ꞌimi nuwanuwa? Onaꞌaiꞌaila, tai nina nigeya sawesawenaya be ꞌimama sagali gete ꞌena, aga?” ");
INSERT INTO dob_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ona gete tomota ꞌawadiyega ꞌiapwesa, ꞌidi ꞌinapwanao ꞌidi loina paꞌalina manuna. Manuna taudi totaliyao ꞌidi ꞌinapwanao be wate Palisiyao tomota ꞌediya siemataluwaya ꞌaene ꞌeguma to sena ꞌena Yesu silobai sida simana manini ꞌinapwanao nidi ꞌediya, be Yesu sigiyai. ");
INSERT INTO dob_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ꞌAsiyata sikisi simiyami be Ataona Sagalina sida guinuwe, ta Yesu ꞌitauya Betani, Lasalo ꞌina ꞌasaya, tauna lowa mwawasega Yesu ꞌigietoolo limena. ");
INSERT INTO dob_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ga nada masula siguinuwena Yesu manuna, ga Malida ꞌiꞌesikala, ga Lasalo be Yesu ma ina bodao maꞌenao simiya egogona ga siꞌeꞌai. ");
INSERT INTO dob_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ta Meli ꞌebweu bunama ꞌana esana nadi, ta ꞌana maisa sinabwana, ꞌiꞌewena ga Yesu ꞌaena ꞌibunamidi. ꞌEnega muliyega Meli nina ꞌikopu ga ꞌuyaꞌuyanega Yesu ꞌaena ꞌiloꞌiꞌilina. Ta gote ꞌena bunama nina maina sinabwana ga anuwa ꞌiloemaena. ");
INSERT INTO dob_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Gete ꞌena Yudasa Isikaliota, tauna ꞌebweu Yesu ꞌina tonono ta wate tauna tuga maꞌetamo Yesu nina ꞌida telesipupuye, ꞌilomugi ");
INSERT INTO dob_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ga ꞌigwae, “Toꞌase ꞌalena ga ꞌenega bunama gote nigeya ꞌiegimwaneye be ꞌana maisa nadigega ꞌetoi analedi kina ꞌida ꞌewa be gomabeso ꞌediya tada eguyaiye?” ");
INSERT INTO dob_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasa ꞌina ona getedi nigeya ona ꞌaiꞌaila ꞌaene togomabeso manudi, ta esi tauna manuna, manuna tauna toꞌipwala tuga, ta wate tauna Yesu ma ina tononoyao ꞌidi mani ꞌana toꞌitaꞌiꞌita, ta mani nidi ꞌediyega ꞌiꞌipwaꞌipwala. ");
INSERT INTO dob_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ꞌEnega Yesu ꞌieonena, ꞌigwae, “Tuwa, geyaꞌabo toꞌase ꞌena ꞌuonaonae. Manuna toꞌase nadigega ꞌeguya ꞌiguinuwena ꞌagu saꞌu ꞌaliꞌali manuna. ");
INSERT INTO dob_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ta togomabeso nidi ꞌuoneonediya tuta yauyauna selabemiya simiyami, ta ꞌaboꞌagu esi nigeya tuta dudulana maꞌemi tamiyami.” ");
INSERT INTO dob_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tuta nina me Yudia yauyaudi Yesu alena sinononaya ꞌaene Betani ꞌena ꞌimiyami, ꞌenega ꞌena sitauya. ꞌIdi tauya ꞌalena manuna nuwanuwadi be Yesu sida ꞌita, ta wate Lasalo sida ꞌita, tauna mwawasega Yesu ꞌina onega ꞌigietoolo limena. ");
INSERT INTO dob_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ga gote ꞌena Lasalo siꞌitena ga me Yudia yaudi ꞌidi toanuganao ꞌidi loina siguitoyasena ta Yesu esi siemisena, ꞌenega totaliyao ꞌidi ꞌinapwanao siloina leleleya be ꞌaene Lasalo wate sida loemwawasi. ");
INSERT INTO dob_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ga mali ꞌasiyata tomota nidi yaudi niꞌatu simai Ataona Sagalina ꞌenaya, Yesu alena sinonona ꞌaene maꞌetamo ꞌimamai Yelusalema. ");
INSERT INTO dob_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ꞌEnega tomota nidi magimagi yawadi siꞌewedi ga siapwesa sabi aesotana ta sibwaubwau ꞌenadi sinabwana ꞌenega, sigwaegwae, “Kamatoki ꞌInapwana, Yaubada ꞌana esanega ꞌumai be ꞌuetoloina sinabwana me Isileli ꞌemaya.” ");
INSERT INTO dob_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ta Yesu yobai ase ꞌiꞌewena ga ꞌena ꞌigelu ga ꞌitautauya, nadigega lowa Buki Tabu ꞌena ꞌisimanena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sayoni tomota nimi geyaꞌabo wamatamatauta. Gete tuga ꞌimi kini niꞌatu ꞌiluguluguwa ꞌemiya, Tauna ase mwaneyauna ꞌena ꞌigelu.” ");
INSERT INTO dob_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tuta gote ꞌena ꞌina tononoyao nigeya ona nina sinuwanuwa sabwaleni, ta esi Yesu ꞌina toololimana mulinaya sinuwaꞌiꞌisina ona nina Buki Tabu ꞌenega, tuga nadigega toꞌase tomota siguinuwena Yesu ꞌena. ");
INSERT INTO dob_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ꞌEnega boda nidi taudi lowa matadiyega Yesu Lasalo ꞌaliꞌaliyega ꞌibwauyena ga mwawasega ꞌitoolo limana, niꞌatu sitauya gosediyao ꞌediya, ga ale nina sisimana dadanena. ");
INSERT INTO dob_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Gote ꞌenega me Yudia yaudi Yesu ꞌina paisewa waiwaina alena sinonona, ꞌenega simai sabi aesotana tuta nina ꞌina lugu Yelusalema ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Gote ꞌena Palisiyao taudimo ꞌediya sigwae, “Wada ꞌita, ꞌida waiwai niꞌatu ꞌigumwala, manuna tomota maiboꞌadi Yesu ꞌina boda ꞌena sitautauya.” ");
INSERT INTO dob_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tuta nina ꞌena ꞌaidi me Gilisi gamwagamwanidiya simiyami, taudi tomota nidi situꞌema Yelusalema, Ataona Sagalina ꞌena sabi lotapwalolo. ");
INSERT INTO dob_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Taudi me Gilisi nidi ma idi enaida sitauya Pilipi ꞌena. Ta Pilipi tauna Beteseida taina, nate Galili senanaya. ꞌEnega simai ga sieonena, sigwae, “ꞌInapwana, ꞌaboꞌama nuwanuwama be Yesu ꞌada ꞌita.” ");
INSERT INTO dob_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ꞌEnega Pilipi ꞌitoolo ga ꞌitauya Anidulu ꞌena ga ꞌieonena, ꞌenega siteluwa nidi simai Yesu ꞌena ga me Gilisi ꞌidi nuwanuwa sisimanena. ");
INSERT INTO dob_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ꞌEnega Yesu me Gilisi ꞌidi ona ꞌieꞌisena, ga ꞌigwae, “ꞌAboꞌagu Tomota Natuna, ta niꞌatu tuta ꞌimai saba be ꞌenega ꞌagu tupu yaloba.” ");
INSERT INTO dob_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ta wate ꞌediya ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya, ꞌabo ewana bwaꞌa ꞌena tadauni, maꞌetamo bwaꞌa solanaya ꞌidadaula, ta esi solanega ꞌitatabwa be uwana boboꞌana ꞌisusaila, manuna ꞌeguma geyaꞌabo bwaꞌa solanaya tadaudauni, geyaꞌabo saꞌi ꞌitabwatabwa be uwana boboꞌana ꞌisusasusaila. ");
INSERT INTO dob_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tuga wate nadigega ꞌabo yaita tauna yawasina ꞌiyale baleꞌu ꞌana miya manuna, yawasina boboꞌana ꞌiloseye, ta ꞌabo yaita tauna baleꞌuya yawasina ꞌitagwale, tuta ꞌimeemai ꞌenaya yawasina ataya ꞌiloba. ");
INSERT INTO dob_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","“ꞌEnega ꞌabo yaita nuwanuwana be ꞌeguya ꞌida etoguinuwa, nugana ꞌida muliyegu, be ꞌenega to sena ꞌenaya yamiyami tauna maꞌiyagu, ta wate ꞌabo yaita manugu ꞌida etoguinuwa, Tamagu ꞌida ꞌawa boboꞌane.” ");
INSERT INTO dob_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Tuta gete ꞌenaya nuwagu ꞌimwau sinabwana, ꞌenega mwaꞌadega yasidaꞌesa? Nai Tamagu ꞌena yasisida, be tuta mwau gete ꞌena ꞌiꞌetoseyegu? Nai geyaꞌabo nadigega yasidasidaꞌesa, manuna mwau nina tauna manuna yamai. ");
INSERT INTO dob_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ta esi yasisida be Tamagu ꞌena yagwae, ‘Tamagu, ꞌamu esana ꞌugituꞌeye.’ ” ꞌEnega ꞌebweu ꞌenana galewega sinonona, ꞌigwae, “ꞌAgu esana niꞌatu yagituꞌeyena ta wate maꞌetamo yada gituꞌe limai.” ");
INSERT INTO dob_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ta boda nina gote ꞌena sitootoolo, ꞌenana nina sinonona ga sigwae, “Wepalala ꞌidududu”, ta ꞌaidi sigwae, “Nigeya, anilose esi ꞌenaya ꞌionaona.” ");
INSERT INTO dob_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ta muliyega Yesu ꞌediya ꞌigwae, “ꞌEnana nina wanononaya nigeya ꞌaboꞌagu manugu ta esi ꞌomi manumi. ");
INSERT INTO dob_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tuta gete niꞌatu ꞌimai saba be totoꞌumalidi baleꞌuya simiyami Yaubada ꞌida loinedi, ta wate baleꞌu gete ꞌana toloina toꞌumalina ꞌida ula apwese. ");
INSERT INTO dob_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ta ꞌaboꞌagu ꞌabo baleꞌuyega sigituꞌeyegu kaiwe ꞌenaya, tomota maiboꞌadi yalisidima be ꞌeguya simamai.” ");
INSERT INTO dob_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ta gete nadigega Yesu ꞌieꞌitedi, mwaꞌadega maꞌetamo ꞌimwawasaꞌesa. ");
INSERT INTO dob_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ta boda nidi ꞌina ona sinonona ga sieꞌisena, sigwae, “ꞌIma Buki Tabu ꞌisimana ꞌaene Toꞌetoseyana nina miyamiya atayana, ta mwaꞌadega ga ꞌenega ꞌuona ꞌaene Tomota Natuna sida gituꞌeye? Yaita sana gete Tomota Natuna?” ");
INSERT INTO dob_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ꞌEnega Yesu ꞌieonedi, “Tuta gidalinamo ꞌena maedana ꞌemiya ꞌimiyami, ꞌenega gete tuga maedana nina ꞌena watatauya, manuna ꞌabo guguyoi ꞌimamai geyaꞌabo ꞌeda waꞌitaꞌita. Manuna ꞌabo yaita tauna guguyoi ꞌena ꞌitautauya nigeya ꞌimwalamwalatoni mwaꞌo ꞌena ꞌitautauya. ");
INSERT INTO dob_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ta ꞌabo maedana ꞌemiya ꞌimiyami, maedana nina ꞌena wada emisa, be ꞌenega ꞌomi maedana natunao ga maemaedanimi. Yesu ꞌina ona gete ꞌiꞌinanedi ga ꞌipilisinedi ta ꞌediyega ꞌikwaiya. ");
INSERT INTO dob_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ta Yesu niꞌatu weꞌiweꞌiyaya yaudi ꞌieꞌita ꞌediya, ta tuwa tuga nigeya siemiemise. ");
INSERT INTO dob_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ꞌEnega toꞌase nadigega palopita Aisea lowa Buki Tabu ꞌena ꞌisimanena, niꞌatu ꞌiapwesa, tuta nina ꞌigwae, “ꞌInapwana, ale nina ꞌasimanena, yaita ꞌida emisedi? Ta yaisigedi ꞌediya ꞌinapwana ꞌina waiwai ꞌida eꞌitae?” ");
INSERT INTO dob_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ta taudi nigeya siemiemisa ꞌalena gete manuna Aisea wate Buki Tabu ꞌena ꞌisimana, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yaubada niꞌatu matadi ꞌigiekebodi, ta wate ꞌidi nuwanuwa ꞌigibodedi, be gote ꞌenega nigeya sawesawediya be matadiyega sida ꞌitaꞌita, ta nigeya sawesawediya be ꞌidi nuwanuwa ꞌenega mwalatoi sida ꞌewaꞌewa, ta wate nigeya sawesawediya be sida sanailama be ꞌaene yada gieboboꞌanedi.” ");
INSERT INTO dob_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisea ona gete ꞌiꞌinanedi manuna Yesu ꞌina esaesa ꞌigimi sinapuna, ꞌenega manuna ꞌigimi simanena. ");
INSERT INTO dob_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ta tuwa tuga me Yudia nidi ꞌidi toanuganao tupwana yaudi wate Yesu siemisena, ta nigeya sisimasimana apwese, manuna Palisiyao ꞌediya simatauta, ꞌabona nai anuwa tapwaloloega sida ula apwesedi. ");
INSERT INTO dob_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Taudi tomotai nidi nuwanuwadi ꞌadi ꞌawaboboꞌana tomota ꞌediyega, ta ꞌawaboboꞌana Yaubada ꞌenega geya nuwadi. ");
INSERT INTO dob_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ta Yesu ꞌenana sinabwana ꞌenega ꞌediya ꞌigwae, “ꞌAbo yaisigedi ꞌomi waemisegu, ꞌagu toetune wate waemisena. ");
INSERT INTO dob_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ta wate yaisigedi ꞌomi waꞌitegu, ꞌagu toetune nina niꞌatu waꞌitena. ");
INSERT INTO dob_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ta ꞌaboꞌagu maedana nina gete yamai baleꞌuya be ꞌenega yaisigedi ꞌomi waemisegu geyaꞌabo wate guguyoi ꞌena wamiyami. ");
INSERT INTO dob_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ta ꞌabo yaita tauna ꞌenagu ꞌinononaya ta nigeya ꞌiematamatanedi, geyaꞌabo ꞌina toꞌumalina manuna yaetaetalae. Manuna ꞌaboꞌagu yamai nigeya sabi etala, ta esi tomotai sabi ꞌetoseyedi. ");
INSERT INTO dob_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Manuna ꞌabo yaita nai ꞌoyo ꞌuguitoyasegu, ta wate ꞌigu ona ꞌuguitoyasedi, maꞌetamo tuta ꞌana ꞌebe losalowa ꞌenaya loina ꞌuloba, nigeya ꞌaboꞌagu ꞌeguyega, ta esi manuna ꞌigu ona nina ꞌuguitoyasena. ");
INSERT INTO dob_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Manuna ona nidi nigeya ꞌigu nuwenuwega, ta esi ꞌagu toetune nina toꞌase nadigega ꞌiemataluweguya yasimanedi ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ta ꞌina emataluwa yamwalatonina yawasi ataya ꞌena ꞌimiyami. ꞌEnega toꞌase nadigega Tamagu ꞌina emataluwa ꞌeguya gete nadigega yasimasimanediwa.” ");
INSERT INTO dob_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ta niꞌatu tuta gidalina be Ataona Sagalina ꞌana ꞌasiyata sida guinuwe, ta Yesu ꞌimwalatonina ꞌaene niꞌatu ꞌina tuta ꞌiapwesama be baleꞌu gete ꞌida pilisine be ꞌitatauya Tamana ꞌena. Ta Yesu ꞌina bodao ꞌiobobomedi sinabwana, ꞌenega tuta ꞌana ꞌebe eꞌale ꞌenega ga ꞌana laba ꞌina ꞌebe losalowa ꞌena ꞌiobobomedi. ");
INSERT INTO dob_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ta Seitani niꞌatu Yudasa ꞌena ꞌilugu ga ꞌienuwa saꞌuyena be ꞌaene Yesu ꞌida sipupuye. Yudasa nina tauna Saimoni Isikaliota natuna. ꞌEnega tuta nina ꞌidi ꞌeꞌai solanaya ");
INSERT INTO dob_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu niꞌatu ꞌimwalatonina ꞌaene Yaubada yage maiboꞌadi ꞌiꞌebwaꞌena be tauna ꞌida loina, ta wate ꞌimwalatonina ꞌaene tauna Yaubada ꞌenega ꞌimai, be wate Yaubada ꞌena ꞌida ila. ");
INSERT INTO dob_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ꞌEnega ꞌidi ꞌebe ꞌeꞌai nina ꞌenega Yesu ꞌitoolo ga ꞌana ꞌoama ꞌialolona ta tawelo ꞌiꞌewena ga ꞌilogadiwanena. ");
INSERT INTO dob_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ta bwasi ꞌisiwena gaeba sinabwana ꞌenaya ga ꞌieꞌale be ꞌana tomuliyao ꞌaedi ꞌiꞌutudi be muliyega tawelo nina ꞌilogadiwanenaya ꞌenega ꞌaedi ꞌitalaꞌiꞌilidi. ");
INSERT INTO dob_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ta tuta nina Yesu ꞌimai Saimoni Pita ꞌenaya, Pita nina ꞌigwae, “ꞌInapwana, geyaꞌabo ꞌaegu ꞌuꞌutuꞌutudi.” ");
INSERT INTO dob_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ꞌEnega Yesu ꞌiona, “Nigeya ꞌumwalamwalatoni toꞌase tuta gete yaguiguinuwa ꞌemuya ta esi maꞌetamo be ꞌuda mwalatoni.” ");
INSERT INTO dob_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ta Pita Yesu ꞌieonena, “Geyaꞌabo wate ꞌebweu tuta ꞌaegu ꞌuꞌutuꞌutudi.” Ta Yesu Pita ꞌenana ꞌieꞌisena, ꞌigwae, “ꞌEguma geyaꞌabo ꞌaeyo yaꞌutuꞌutudi ꞌoyo nigeya gosiyagu.” ");
INSERT INTO dob_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ꞌEnega Saimoni Pita ꞌitagwala, ga ꞌigwae, “ꞌInapwana, boboꞌana! Ta geyaꞌabo ꞌaegumo, ta esi nimagu be debagu wate ꞌuda ꞌutudi.” ");
INSERT INTO dob_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ta Yesu ꞌigwae, “ꞌEguma yaisigedi ꞌomi niꞌatu waꞌesiweya, ꞌilobwenemi be ꞌaemimo wada ꞌutudi be ꞌenega bwalami maiboꞌana ꞌida ꞌesasadi. Ta niꞌatu ꞌomi waꞌesasemi, ta nigeya ꞌaene maiboꞌami.” ");
INSERT INTO dob_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ta Yesu niꞌatu ꞌigimi sinapuna yaita tauna maꞌetamo ꞌida sipupuye, nate ꞌenega ꞌigwae, “ꞌAimi nigeya ꞌesasemi.” ");
INSERT INTO dob_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ta niꞌatu ꞌaedi ꞌiꞌutudi, ꞌenega ꞌana ꞌoama ꞌiꞌote limena ga ꞌimiyatowa ta ꞌediya ꞌiona, ꞌigwae, “Wamwalatonina toꞌase yaguinuwena ꞌemiya, nai nigeya? ");
INSERT INTO dob_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ta ꞌomi niꞌatu waeesegu ꞌaene ꞌaboꞌagu Toeꞌita, ta wate ꞌInapwana, ga nate ona ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ꞌAboꞌagu ꞌimi ꞌInapwana be wate ꞌimi toeꞌita, ta niꞌatu ꞌaemi yaꞌutudi, ꞌenega ꞌomi ꞌilobwenemi be wate gosemiyao ꞌaedi wada ꞌutudi, ");
INSERT INTO dob_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","tuga toꞌase nadigega yaguinuwena ꞌemiya wada etotowanegu be wada guinuwa nadigega gosemiyao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ta yaona ꞌaiꞌaila ꞌemiya ꞌaene nigeya ꞌebweu yaita toguinuwa ꞌina ꞌinapwana ꞌida loetana sinena, ta nigeya ꞌebweu wate toepilialeale ꞌana toetune ꞌida loetana sinena. ");
INSERT INTO dob_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ta niꞌatu eꞌita nidi getedi wamwalamwalatonidi, ta ꞌabo waguinuwedi ꞌebe gwausowala wada loba. ");
INSERT INTO dob_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Yage getedi nigeya ꞌaene maiboꞌami manumi yaonaona, ta esi taudi yaesinuwediya manudi yaonaona, ta Buki Tabu ꞌina simana mali tai manuna ꞌigwae, ‘Tai nina tauna ꞌana masula yaꞌebwaꞌena, ꞌisanaila ga ꞌietalauwalegu.’ ꞌEnega ona nina ꞌana ꞌaiꞌaila ꞌiabe ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Niꞌatu yage nidi gete ꞌemiya yasimanedi muliyega sida apwesa, be ꞌenega tuta nina siapwesa wada emisegu ꞌaene ꞌaboꞌagu tuga. ");
INSERT INTO dob_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","“Onaꞌaiꞌaila, maꞌetamo yaetunemi tomota ꞌediya be ꞌabo yaita ꞌitagwala ꞌemiya, nate tauna niꞌatu ꞌitagwala ꞌeguya, ta wate ꞌitagwala ꞌagu toetune nina ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ta niꞌatu Yesu yage nidi getedi ꞌionaedi ga nuwana ꞌimwau sinabwana, ꞌenega ꞌina tononoyao ꞌediya ꞌisimana apwesa ga ꞌigwae, “Yaona ꞌaiꞌaila ꞌemiya ꞌaene ꞌebweu ꞌemiyega maꞌetamo ꞌida sipupuyegu.” ");
INSERT INTO dob_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ta tononoyao maiboꞌadi taudimo ꞌediya siedunedune, ta nuwadi ꞌiowana sinabwana. Manuna ꞌina ona ꞌana mwalatoi nigeya simwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ta ꞌebweu ꞌina tonono, tauna Yesu gosiya ꞌaiꞌailina, selabenaya ꞌiꞌeno ilaila, ");
INSERT INTO dob_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ta Saimoni Pita tupwana ꞌimiyaila, ꞌenega Pita nina nimanega ꞌieonena, “ꞌUda enaide yaita tauna manuna ꞌionaona?” ");
INSERT INTO dob_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ꞌEnega tai nina ꞌiꞌeno ilaila Yesu selabenaya ga tenanaya ꞌiona, ꞌigwae, “ꞌInapwana, yaita sana manuna ꞌuonaona?” ");
INSERT INTO dob_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ta Yesu tai nina ꞌieonena, ꞌigwae, “ꞌIabe beledi yagitomwa be yaepwasa be yaꞌebwaꞌe, tauna nate tai nina.” ꞌEnega Yesu beledi nina gidalina ꞌiꞌewena ga ꞌiepwasena ga Yudasa ꞌiꞌebwaꞌena, Yudasa tauna Saimoni Isikaliota natuna. ");
INSERT INTO dob_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ga tuta nina Yudasa beledi ꞌiꞌewena Seitani ꞌena ꞌilugu, ga Yesu Yudasa ꞌieonena, “ꞌUlomanini be ꞌimu guinuwa nina ꞌuda guinuwe.” ");
INSERT INTO dob_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ta taudi Yesu maꞌenao siꞌeꞌai nigeya ꞌebweu yaita ꞌediyega ꞌimwalamwalatoni toꞌase Yesu ꞌina ona Yudasa ꞌenaya ꞌana mwalatoi. ");
INSERT INTO dob_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tauna Yudasa ꞌidi mani ꞌana toꞌitaꞌiꞌita ꞌenega sinuwena ꞌaene Yesu ꞌieonena be tauna Yudasa ꞌitatauya be ꞌidi sagali gwegwena ꞌida gimwane, nai ꞌitatauya be ꞌaina mani gomabeso ꞌida ꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ꞌEnega Yudasa beledi nina ꞌiꞌenina, ga ꞌilomanini ga ꞌiapwesa ꞌatamanaya, ta niꞌatu ꞌiboi. ");
INSERT INTO dob_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasa niꞌatu ꞌipilisinedi, ga Yesu ꞌieonedi, ꞌigwae, “Niꞌatu tuta ꞌimai saba be ꞌaboꞌagu Tomota Natuna ꞌigu esaesa ꞌida apwesa, be ꞌaboꞌagu Yaubada ꞌina esaesa wate yada gieapwese. ");
INSERT INTO dob_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Onaꞌaiꞌaila, Yaubada tauna ꞌenega ꞌigu esaesa ꞌida gieapwese manini. ");
INSERT INTO dob_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Natugwao, tuta gidalina namo ꞌena ꞌaboꞌagu maꞌemi, ta maꞌetamo waꞌebesegu, nadigega lowa me Yudia ꞌediya yasimanaꞌesa, yagwae, ‘Sena nina ꞌena yatatauya ꞌomi nigeya sawesawemiya be ꞌena wawawai.’ ");
INSERT INTO dob_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“ꞌEnega ꞌomi wate gete tuga loina auwauna yaꞌebwaꞌemi, be ꞌatemiyega wada eobooboboma ꞌebweuna ꞌebweuna ꞌenaya, nadigega ꞌaboꞌagu yaobobomaꞌesemi, ");
INSERT INTO dob_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","be ꞌimi eobooboboma ꞌenega tomota yaudi sida mwalatonimi ꞌaene ꞌomi ꞌagu tomuliyao.” ");
INSERT INTO dob_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ꞌEnega Saimoni Pita Yesu ꞌienaidena, ꞌigwae, “ꞌInapwana, mwaꞌo batu ꞌutatauya?” Ta Yesu ꞌieonena, “Nigeya sawesawemuya be tuta gete ꞌenaya ꞌumuliyegu, ta esi ꞌetamo be ꞌuda muliyegu sena nina ꞌena.” ");
INSERT INTO dob_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ꞌEnega Pita Yesu ꞌienaidena, ꞌigwae, “ꞌInapwana, toꞌase manuna gete tuga geyaꞌabo yamulimuliyeyo? Niꞌatu yatagwalegu be manuyo tuga yada mwawasa.” ");
INSERT INTO dob_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ta Yesu Pita ꞌena ꞌigwae, “ꞌImu ona ꞌeguya nigeya yaemiemise, ta yasimana ꞌaiꞌaila ꞌemuya ꞌaene boiboi gete ꞌenaya ꞌuda eyaseyaseyegu matoi, be muliyega kakaleko ꞌigwagwane.” ");
INSERT INTO dob_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ꞌEnega Yesu wate ꞌieonedi ga ꞌediya ꞌigwae, “Geyaꞌabo waenuenuwanaluwa, ta esi Yaubada wada emise, ta wate ꞌaboꞌagu wada emisegu. ");
INSERT INTO dob_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ta Tamagu ꞌina senaya anuwa yaudi sitootoolo. ꞌEnega ꞌaboꞌagu sena nina ꞌena yatatauya be ꞌimi sena yagibubu. ꞌEguma ona gete nigeya onaꞌaiꞌaila, geyaꞌabo saꞌi gete nadigega yasimasimanaꞌesa ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ta ꞌabo yatatauya sena nina ꞌena be ꞌimi sena yagibubu, maꞌetamo yada ilama be yada ꞌauꞌewami be sena nina ꞌena yamiyami ꞌomi wate ꞌena wamiyami. ");
INSERT INTO dob_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ta ꞌeda nina ꞌena yatatauya niꞌatu wamwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ꞌEnega Tomasi Yesu ꞌienaidena, ꞌigwae, “ꞌInapwana, to ꞌeda ꞌenega ꞌutautauya? Ta mwaꞌadega ꞌeda nina ꞌada mwalatoiꞌese?” ");
INSERT INTO dob_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ta Yesu Tomasi ꞌieonena, ꞌigwae, “ꞌAboꞌagu ꞌeda nina, ta wate ona ꞌaiꞌaila, be yawasimi ꞌaledi. ꞌAbo yaita nuwanuwana be ꞌitatauya Tamagu ꞌena, nigeya ꞌebweu wate ꞌeda ꞌimiyami, nate namo tuga ꞌaboꞌagu.” ");
INSERT INTO dob_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ꞌEnega Yesu wate ꞌediya ꞌigwae, “ꞌAboꞌagu niꞌatu wamwalatonigu, ꞌenega wate Tamagu wamwalatonina. Onaꞌaiꞌaila, Tamagu niꞌatu wamwalatonina, ta wate waꞌitena.” ");
INSERT INTO dob_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ta Pilipi Yesu ꞌena ꞌiona, “ꞌInapwana, nate namo nuwanuwama be Tamamuna ꞌuda eꞌitama.” ");
INSERT INTO dob_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ꞌEnega Yesu Pilipi ꞌena ꞌigwae, “Niꞌatu tuta dudulana ꞌaboꞌagu maꞌemi tamiyami, ta tuga nigeya ꞌumwalamwalatonigu. Ta yaisigedi ꞌomi niꞌatu waꞌiteguya, ꞌomi wate Tamagu niꞌatu waꞌitena ga wamwalatonina. ꞌEnega toꞌase manuna ꞌugwae ꞌaene ‘Tamamuna ꞌuda eꞌitama’? ");
INSERT INTO dob_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nai nigeya ꞌuemiemisegu ꞌaene ꞌaboꞌagu Tamagu ꞌena yamiyami, ta wate Tamagu tauna ꞌeguya ꞌimiyami, aga?” Ta Yesu wate ꞌediya ꞌigwae, “Ona nidi niꞌatu yaonaedi ꞌemiya nigeya ꞌaboꞌagu ꞌigu ona ta Tamagu esi ꞌenega, manuna tauna ꞌeguya ꞌimiyami, ta wate ꞌeguyega ꞌina guinuwa ꞌiguiguinuwedi. ");
INSERT INTO dob_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gete tuga wada emisegu ꞌaene ꞌaboꞌagu Tamagu ꞌena yamiyami, ta Tamagu wate tauna ꞌeguya ꞌimiyami. Ta ꞌabo ꞌigu ona nigeya waemiemisedi, ꞌigu guinuwa nidi waiwaidi wada nuwaꞌiꞌisidi, be wada emisegu. ");
INSERT INTO dob_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ta yaona ꞌaiꞌaila ꞌemiya, ꞌabo yaisigedi ꞌomi waemisegu, guinuwa nidi waiwaidi yaguiguinuwedi ꞌomi wate nadigega wada guinuwedi, ta wate maꞌetamo ꞌimi guinuwa waiwai wawasaedi wada gieapwesedi, manuna ꞌaboꞌagu yatatauya Tamagu ꞌena. ");
INSERT INTO dob_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Be toꞌase nadigega nuwanuwami, be ꞌagu esanega wasisida, yaꞌebwaꞌemi tuga, be gote ꞌenega Tamagu ꞌana tupu ꞌida loba ꞌigu guinuwa ꞌenega. ");
INSERT INTO dob_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ꞌEguma to yage nai manuna ꞌagu esanega wasisida yada guinuwa tuga.” ");
INSERT INTO dob_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ta Yesu wate ꞌediya ꞌigwae, “ꞌAbo waobobomegu, ꞌigu loinao waematamatanedi, ");
INSERT INTO dob_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ta maꞌetamo Tamagu ꞌena yada sida be tauna wate ꞌami tolema ꞌebweu ꞌida ꞌebwaꞌemi. Tauna tolema nina Yaluyaluwa ꞌesasena ta palupaluna, be tauna ꞌemiya ꞌida miyaataya. ");
INSERT INTO dob_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ta me baleꞌu nigeya sawesawediya be Yaluyaluwa nina ꞌena sitatagwala, manuna ꞌana ꞌita nigeya sida ꞌitena ta nigeya sida mwalatonina. Ta esi tolema nina wamwalatonina ꞌaene tuta yauyauna ꞌatemiya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ta ꞌabo yapilisinemi, geyaꞌabo wanuwanuwa ꞌaene sinasinagenimi, manuna maꞌetamo yatatauya be muliyega wate yaila limanama. ");
INSERT INTO dob_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","“Ta tuta gidalina namo ꞌena be yapilisinemi, be geyaꞌabo me baleꞌu siꞌitaꞌitagu, ta ꞌomi maꞌetamo wada ꞌitagu mayawasigu yamiyami, ꞌenega ꞌomi wate nadigega mayawasimi wamimi. ");
INSERT INTO dob_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ta ꞌasiyata gote ꞌena wada mwalatonigu ꞌaene ꞌaboꞌagu Tamagu ꞌena yamiyami, ta ꞌomi ꞌeguya wamiyami ta ꞌaboꞌagu ꞌemiya yamiyami. ");
INSERT INTO dob_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ꞌEguma yaita ꞌoyo ꞌigu loina ꞌusinapudi be ꞌuematamatanedi, ꞌoyo niꞌatu ꞌuobobomegu. ꞌEnega Tamagu wate ꞌida obobomeyo, ta ꞌaboꞌagu wate yada obobomeyo, ta yada eꞌitaegu taugu ꞌemuya.” ");
INSERT INTO dob_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ꞌEnega mali Yudasa, (tauna nigeya Isikaliota) Yesu ꞌena ꞌigwae, “ꞌInapwana, mwaꞌadega ꞌuda eꞌitaꞌeseyo ꞌemaya ta nigeya me baleꞌu ꞌediya?” ");
INSERT INTO dob_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ta Yesu ꞌena ꞌigwae, “ꞌAbo ꞌoyo yaita ꞌuobobomegu ꞌigu ona ꞌuda muliyedi, ꞌenega Tamagu ꞌida obobomeyo, be ꞌenega Tamagu maꞌiyagu ꞌawawai ꞌemuya, be ꞌoyo maꞌema tada miya leleleya. ");
INSERT INTO dob_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ta ꞌabo ꞌoyo yaita nigeya ꞌuobobomegu, ꞌigu ona wate nigeya ꞌuda ematamatanedi. Ta ona nidi nate wanoonodi nigeya ꞌeguyega, ta esi tauna ꞌagu toetune Yaubada ꞌenega. ");
INSERT INTO dob_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tuta gete ꞌenaya ꞌaboꞌagu maꞌemi, ꞌenega ꞌigu ona gete yaꞌebwaꞌebwaꞌemi, ");
INSERT INTO dob_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","be maꞌetamo tolema nina, ꞌagu esanega Yaubada ꞌida etunenama, nate Yaluyaluwa Tabuna, tauna yage yauyauna ꞌida eꞌitami, ta wate ona nidi maiboꞌadi yaonaedi ꞌida gienuwaꞌiꞌisimi.” ");
INSERT INTO dob_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ꞌAboꞌagu niꞌatu be yapilisinemi, ꞌenega taugu tuga ꞌigu nuwasiwalowa ꞌenega yada ꞌebwaꞌemi, ta nuwasiwalowa nina nigeya nadigega me baleꞌu siꞌebwaꞌebwaꞌemi. ꞌEnega geyaꞌabo waenuenuwanaluwa nai waꞌateꞌate saꞌala. ");
INSERT INTO dob_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Niꞌatu ꞌigu ona wanonona ꞌaene maꞌetamo yatatauya be muliyega yada ilama ꞌemiya. Ta ꞌeguma ꞌomi waobobomegu, geyaꞌabo wanuwanuwa mwau ꞌigu tauya Tamadai ꞌena manuna, ta esi wada gwausowala, manuna Tamadai nina tauna ꞌiloetana sinegu. ");
INSERT INTO dob_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Tuta gete ꞌenaya yage nidi yasimasimanedi ꞌemiya, ta ꞌabo tuta ꞌimeemai ꞌediya yage nidi siapwesama, ꞌiabe ꞌigu ona nidi waꞌawa ꞌaiꞌailidi. ");
INSERT INTO dob_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Nai geyaꞌabo tuta dudulana yaonaona ꞌemiya, manuna niꞌatu gabula ꞌana ꞌinapwana toꞌumalina ꞌimeema, ta tauna nigeya ꞌebweu wate ꞌina waiwai ꞌeguya, ");
INSERT INTO dob_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ta ꞌagu emataluwa esi Tamagu ꞌenega tuta yauyauna yaguiguinuwedi, be gete ꞌenega me baleꞌu sida mwalatoni ꞌaene Tamagu yaobobomena. “Niꞌatu! Watoolo, be tatatauya.” ");
INSERT INTO dob_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu wate ꞌediya ꞌigwae, “ꞌAboꞌagu ꞌawe uwauwa ꞌaiꞌaila, oine manuna, ta Tamagu tauna tobagula. ");
INSERT INTO dob_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ta ꞌabo naligwao nigeya sida uwa, ꞌiꞌupwaꞌupwa yauledi, ta esi naligwao nidi taudi uwadi ꞌisaꞌuna, ꞌigieꞌesasedi be ꞌenega sida uwa sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ta ꞌomi nadigega niꞌatu ꞌigu ona ꞌenega yagieꞌesasemi. ");
INSERT INTO dob_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ꞌEnega ꞌomi ꞌeguya wada miyami, ꞌaboꞌagu wate ꞌemiya yada miyami. Manuna ꞌabo ꞌomi nigeya ꞌeguya wamiyami, geyaꞌabo wauwauwa boboꞌana. Nadigega ꞌabo kaiwe nalina nigeya kaiwe ꞌena ꞌimiyami, geyaꞌabo ꞌiuwauwa. ");
INSERT INTO dob_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ta ꞌaboꞌagu kaiwe nigu ta ꞌomi naligwao, ꞌenega ꞌeguma yaita ꞌeguya ꞌimiyami be ꞌaboꞌagu ꞌena yamiyami, ꞌida uwa boboꞌana. Manuna ꞌeguma ꞌaboꞌagu nigeya, geyaꞌabo toꞌase ꞌebweu boboꞌana waguiguinuwe. ");
INSERT INTO dob_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ta ꞌabo yaita tauna nigeya ꞌeguya ꞌimiyami, sida ula apwese be ꞌiꞌoapelu, nadigega naliyao ꞌupwaꞌupwa yauledi, siegogonedi be kaiwe sabelulu ꞌena sigabudi. ");
INSERT INTO dob_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ta ꞌabo ꞌeguya wamiyami ta wate ꞌabo ꞌigu ona ꞌemiya ꞌimiyami, ꞌenega ꞌabo toꞌase nuwanuwami wada sida manudi be walobadi. ");
INSERT INTO dob_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ꞌAbo wamuliya ꞌaiꞌailigu, uwami ꞌida boboꞌana, be ꞌenega Tamagu ꞌina waiwai tomota sida ꞌita. ");
INSERT INTO dob_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ta nadigega tuga Tamagu ꞌiobobomegu, ꞌaboꞌagu wate yaobobomemi, be ꞌigu oboboma nina ꞌena wada miyami. ");
INSERT INTO dob_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ꞌEguma ꞌigu loina wamuliya ꞌaiꞌailidi, ꞌigu oboboma ꞌena wamiyami. Nadigega ꞌaboꞌagu Tamagu ꞌina loina yamuliya ꞌaiꞌailidi, ꞌenega ꞌaboꞌagu wate ꞌina oboboma ꞌena yamiyami. ");
INSERT INTO dob_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Niꞌatu tuga nadigega yaeonemi be gete ꞌenega ꞌigu gwausowalega wada gwausowala, be nuwami maiboꞌana sida uyawana ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Ta gete ꞌigu loina ꞌemiya ꞌaene wada eoboobobomemi nadigega ꞌaboꞌagu yaobobomemi. ");
INSERT INTO dob_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ta ꞌeguma yaita gosenao manudi ꞌida mwawasa, nate oboboma sinabwa wawasae. ");
INSERT INTO dob_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","“Ta ꞌomi wate nadigega ꞌabo ꞌigu loinao waematamatanedi, ꞌomi gosegwao. ");
INSERT INTO dob_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Lowa yaꞌawa toguinuwaemi, ta esi tuta gete ꞌenaya yaꞌawaꞌawa gosiyanemi, manuna toguinuwao nigeya wate ꞌilobwelobwenedi be ꞌidi ꞌinapwana ꞌina nuwanuwa sida mwalatoni. Ta esi yada ꞌawa gosiyanemi, manuna toꞌase nadigega Tamagu ꞌenega yanononaya niꞌatu yasimanedi ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Ta wada nuwaꞌiꞌisi ꞌaene ꞌomi nigeya waesiesinuwegu be yada eꞌinapwana ꞌemiya, ta esi ꞌaboꞌagu yaesinuwemi be yada etunemi be wada paisewa, ta ꞌimi paisewa nina ꞌenega uwami boboꞌana sida apwesa, ta uwami nidi sida miyaataya. Ta wate ꞌabo toꞌase ꞌagu esanega wasidei, Tamagu ꞌida ꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","“Niꞌatu ꞌigu loina nina yasimanena ꞌemiya, ꞌaene wada eoboobobomemi.” ");
INSERT INTO dob_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ꞌEnega Yesu wate ꞌediya ꞌiona, “ꞌAbo me baleꞌu siguitoyasemiya, wanuwaꞌiꞌisi ꞌaene ꞌaboꞌagu wate lowa sigimi guitoyasegu. ");
INSERT INTO dob_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ta ꞌabo ꞌomi ꞌimi bubuna me baleꞌu nadigega, me baleꞌu sida obobomemi, manuna ꞌomi gosediyao. Ta baleꞌu gete ꞌenega ꞌomi niꞌatu yaꞌauꞌewa apwesemi, ꞌenega nigeya wate me baleꞌu ꞌidi boda ꞌena wamiyami. Nate ꞌenega me baleꞌu siguitoyasemi. ");
INSERT INTO dob_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Wanuwaꞌiꞌisi ona nina lowa yaꞌebwaꞌemi ꞌaene nigeya ꞌebweu toguinuwa ꞌina ꞌinapwana ꞌida loetana sinena. ꞌAboꞌagu lowa sietalauwaleguya, ꞌenega ꞌomi wate nadigega sietalauwalemi. Ta ꞌeguma lowa ꞌigu ona siematamatanediya ꞌomi wate ꞌimi ona sida ematamatanedi. ");
INSERT INTO dob_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ta yage nidi toꞌumalidi gete sida guinuwedi ꞌemiya manuna ꞌomi ꞌigu bodao, ta wate manuna ꞌagu toetune nina nigeya simwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“ꞌAbo lowa nigeya yameemai be ꞌediya yasimasimana, geyaꞌabo ꞌidi loegesi ꞌimiyami. Ta esi niꞌatu yamai ga ꞌediya yaona saba, ꞌenega nigeya ꞌebweu wate ꞌidi onalimana ꞌidi loegesi manuna. ");
INSERT INTO dob_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ta ꞌabo yaita tauna ꞌiguitoyasegu, tauna wate Tamagu ꞌiguitoyasena. ");
INSERT INTO dob_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ta ꞌabo lowa nigeya guinuwa nidi waiwaidi matadiya yaguiguinuwedi, geyaꞌabo ꞌidi loegesi ꞌimiyami. Ta saꞌi niꞌatu yaguinuwedi guinuwa nidi, nate nigeya ꞌebweu yaita sawesawenaya be ꞌiguinuwedi, ga siꞌitedi, ta tuwa tuga Tamagu be ꞌaboꞌagu siguitoyasema. ");
INSERT INTO dob_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ta ꞌidi guinuwa nidi niꞌatu ꞌiapwesa ꞌaiꞌaila manuna Buki Tabu ꞌena ꞌionaupaupa saba ꞌigwae, ‘ꞌIdi guitoyasa manugu nigeya ꞌalenamo.’ ");
INSERT INTO dob_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ta esi maꞌetamo ꞌami tolema nina Tamagu ꞌenega yada etunenama, tauna Yaluyaluwa ꞌesasena ta palupaluna Tamagu ꞌenega, be tauna ꞌida etosimana manugu, ");
INSERT INTO dob_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ta ꞌomi wate wada etosimana manugu, manuna ꞌigu paisewa ꞌana ꞌebe eꞌaleꞌunu ꞌenega ga batuwa ꞌomi maꞌegwao.” ");
INSERT INTO dob_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ga Yesu wate tonono nidi ꞌediya ꞌiona, “Niꞌatu yage nidi getedi yasimanedi ꞌemiya be ꞌenega geyaꞌabo ꞌeguyega wabeꞌubeꞌu. ");
INSERT INTO dob_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Manuna maꞌetamo anuwa tapwaloloega sipaꞌimi, ta wate maꞌetamo tuta ꞌimeemai be ꞌabo yaita ꞌida loemwawasimi, tauna ꞌinuwanuwa ꞌaene gete Yaubada ꞌina ꞌebe gwausowala. ");
INSERT INTO dob_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ꞌIdi guinuwa getedi toꞌumalidi ꞌemiya sida guinuwedi manuna nigeya Tamagu be ꞌaboꞌagu simwalamwalatonima. ");
INSERT INTO dob_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yage nidi getedi niꞌatu yasimanedi ꞌemiya, be ꞌenega tuta nina ꞌabo siapwesa ꞌemiya wada nuwaꞌiꞌisidi.” Ta wate ꞌediya ꞌigwae, “Yage nidi getedi nigeya lowa yagimigimi simanedi ꞌemiya, manuna tuta yauyauna ꞌaboꞌagu maꞌemi. ");
INSERT INTO dob_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ta esi niꞌatu be yatatauya tauna ꞌietuneguma ꞌenaya, ꞌenega yage nidi gete tuga yagieapwesedi ꞌemiya. Ta niꞌatu gete be yapilisinemi, ta nigeya ꞌebweu ꞌemiyega yaita ꞌienaenaidegu be nai ꞌida gwae, ‘Mwaꞌo ꞌutautauya?’ ");
INSERT INTO dob_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ta ꞌenega ꞌigu ona manudi nuwami simwau sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ta esi yaona ꞌaiꞌaila ꞌemiya ꞌaene boboꞌana ꞌabo yapilisinemi, manuna ꞌabo nigeya yapilipili sinemi tolema nina geyaꞌabo ꞌimeema. Ta ꞌabo yapilisinemi be yatatauya, maꞌetamo tolema nina yada etunenama ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ga tuta nina ꞌabo ꞌimamai, ꞌomi me baleꞌu yage ꞌetoi ꞌida eꞌitami be wada mwalatonidi. Yage nidi nate guinuwa toꞌumalina be guinuwa boboꞌana be wate bwaꞌomatana. ");
INSERT INTO dob_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ꞌEnega ꞌida eꞌitami ꞌaene ꞌabo nigeya waemiemisegu, ꞌomi nate guinuwa toꞌumalina ꞌana toguinuwao. ");
INSERT INTO dob_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ta tauna wate bubuna palupaluna ꞌida eꞌitami, manuna ꞌaboꞌagu niꞌatu be yatatauya Tamagu ꞌenaya be geyaꞌabo wate waꞌitaꞌitagu. ");
INSERT INTO dob_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ta wate tauna bwaꞌomatana ꞌida eꞌitami ꞌaene niꞌatu bwaꞌomatana ꞌimai saba baleꞌuya, manuna baleꞌu ꞌana toloina nina ꞌina guinuwa toꞌumalina ꞌenega ꞌana bwaꞌomatana ꞌilobena. ");
INSERT INTO dob_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ta eꞌita yau wawasae simiyami, ta esi geyaꞌabo maiboꞌana tuta gete yasimasimanedi ꞌemiya, manuna nigeya sawesawemiya be wamwalatonidi. ");
INSERT INTO dob_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ta maꞌetamo Yaluyaluwa ꞌesaꞌesasena ꞌimamai, tauna ꞌida anuganemi yage palupaludi maiboꞌadi ꞌediya. Ta tauna geyaꞌabo ꞌina nuwenuwega ꞌionaona, ta esi toꞌase nadigega ꞌinonodi ꞌida onaedi, ta wate ꞌida eonami yage matamiya manudi. ");
INSERT INTO dob_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ta ꞌigu sinasinapuyega ꞌemiya ꞌida eꞌita be ꞌenega ꞌagu esana wada gituꞌeye. ");
INSERT INTO dob_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ta wate toꞌase nadigega Tamagu ꞌina yage, maiboꞌana ꞌaboꞌagu tuga ꞌigu yage. Nate ꞌenega yagwae, ‘ꞌIgu sinasinapuyega ꞌemiya ꞌida eꞌita.’ ” ");
INSERT INTO dob_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ꞌEnega Yesu wate ꞌediya ꞌiona, ꞌigwae, “Niꞌatu tuta gidalina ꞌena be geyaꞌabo wate waꞌitaꞌitagu, ta ꞌenega tuta gidalina maꞌetamo ꞌena wada ꞌitalimagu.” ");
INSERT INTO dob_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ta ꞌaidi ꞌina tononoyao gosediyao ꞌediya sigwae, “Toꞌase ꞌina ona gete ꞌana mwalatoi? Manuna ꞌedaya ꞌiona, ‘Tuta gidalina ꞌena be geyaꞌabo wate waꞌitaꞌitagu, ta tuta gidalina maꞌetamo ꞌena wada ꞌitalimagu’, ta wate ꞌedaya ꞌiona, ‘Manuna yatatauya Tamagu ꞌena’. ");
INSERT INTO dob_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Toꞌase getedi ‘Tuta gidalina’ ꞌana mwalatoi?” ꞌEnega sigwae, “ꞌIyaugwa! Nigeya tamwalamwalatoni toꞌase manuna ꞌionaona.” ");
INSERT INTO dob_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ta Yesu ꞌina tononoyao ꞌidi nuwanuwa ꞌimwalatonidi be ꞌaene nuwanuwadi ꞌenaya sida enaida, ꞌenega ꞌediya ꞌigwae, “Toꞌase manuna taumimo waenaenaidemi? ꞌAene manuna yagwae, ‘Tuta gidalina ꞌena be geyaꞌabo wate waꞌitaꞌitagu, ta tuta gidalina maꞌetamo ꞌena wada ꞌitalimagu’, aga? ");
INSERT INTO dob_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yaona ꞌaiꞌaila ꞌemiya ꞌaene maꞌetamo ma imi nuwamwau wadedoi, ta esi me baleꞌu maiboꞌadi sigwausowala. Ta ꞌomi maꞌetamo wanuwamwau ta ꞌimi nuwamwau nina ꞌida gibuni be wagwausowala. ");
INSERT INTO dob_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","“Nadigega tuga ꞌabo waine ꞌina tuta enatuna ꞌenaya ꞌelouya ꞌilobaloba, ta ꞌabo ꞌina enatuna mulinaya ꞌelouya maiboꞌana ꞌinuwapupuledi, manuna gwama niꞌatu ꞌitubuwa ga ma ina gwausowala. ");
INSERT INTO dob_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ta ꞌomi nadigega tuga, manuna mwau ꞌemiya tuta gete, ta maꞌetamo yailama be wada ꞌitagu, ꞌenega manugu wada gwausowala ꞌaiꞌaila. Ta gwausowala nina tauna geyaꞌabo yaita wate ꞌemiyega ꞌiꞌewaꞌewa yaule. ");
INSERT INTO dob_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ta ꞌabo tuta nina ꞌimamai, ꞌomi geyaꞌabo toꞌase manuna waenaenaida ꞌeguya. Ta yaona ꞌaiꞌaila ꞌemiya, ꞌeguma ꞌagu esanega Tamagu ꞌena toꞌase manuna wasisida, ꞌida ꞌebwaꞌemi tuga. ");
INSERT INTO dob_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ta lowaenei ga batuwa nigeya wate ꞌebweu toꞌase manuna ꞌagu esanega wasidasida. ꞌEnega gete tuga wasisida be ꞌida ꞌebwaꞌemi, ꞌenega wada gwausowala ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ta Yesu wate ꞌediya ꞌigwae, “Niꞌatu ona semalimaliyega yage getedi yasimanedi ꞌemiya. Ta maꞌetamo tuta ꞌida mai be geyaꞌabo wate ona semalimaliyega yaeonami, ta esi Tamagu manuna yada onaapwesa ꞌaiꞌaila ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ta tuta maꞌetamo ꞌenaya ꞌomi ꞌagu esanega wasisida Yaubada ꞌenaya, ta geyaꞌabo ꞌaboꞌagu manumi yasidasida, ");
INSERT INTO dob_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","manuna Tamagu tauna niꞌatu ꞌiobobomemi. Ta ꞌina oboboma nina ꞌalena manuna ꞌomi waobobomegu, ta wate waemisegu ꞌaene Yaubada ꞌenega yamai. ");
INSERT INTO dob_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ꞌAboꞌagu Tamagu ꞌenega yamai ga baleꞌuya yamiyami, ꞌenega gete tuga baleꞌu yapilipilisine ta yailaila Tamagu ꞌena.” ");
INSERT INTO dob_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ꞌEnega ꞌina tononoyao sinonona ga sieonena, sigwae, “ꞌInapwana, gete tuga niꞌatu ꞌuona apwesa ꞌaiꞌaila ꞌemaya, ta nigeya ona semalimaliyega. ");
INSERT INTO dob_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gete ꞌenega niꞌatu ꞌamwalatoi ꞌaiꞌailimu ꞌaene ꞌoyo yage yauyaudi ꞌumwalamwalatonidi. ꞌEnega geyaꞌabo wate ꞌaenaenaideyo, manuna niꞌatu ꞌima nuwanuwa maiboꞌadi ꞌumwalamwalatonidi. ꞌEnega tuga ꞌaemiseyo ꞌaene ꞌoyo Yaubada ꞌenega ꞌumai.” ");
INSERT INTO dob_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ta Yesu ꞌieonedi ga ꞌigwae, “Niꞌatu waemisegu, aga? ");
INSERT INTO dob_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ta maꞌetamo tuta ꞌida apwesama, nai tada gwae, ‘Niꞌatu tuta ꞌimai saba’, be maiboꞌami wada ꞌelelewana ꞌimi ꞌasao ꞌediya, be ꞌaboꞌagu tebweugu yada miyami. Ta nigeya ꞌaene tebweugumo ta esi Tamagu maꞌiyagu. ");
INSERT INTO dob_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ona gete yasimanena ꞌemiya be ꞌenega ma imi gwausowala wada miyami, manuna ꞌaboꞌagu maꞌemi. Ta maꞌetamo baleꞌuya wamiyamwau, ta tuwa tuga wada ꞌatepatu, manuna ꞌaboꞌagu loina baleꞌu yaewaiwai sinena.” ");
INSERT INTO dob_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ta niꞌatu yage getedi Yesu ꞌiꞌinanedi ta galewa ꞌena ꞌiꞌitatuꞌe, ga ꞌisidasida, ꞌigwae, “Tamagu, ꞌigu tuta niꞌatu ꞌimai. ꞌEnega ꞌaboꞌagu natuyo ꞌagu esana ꞌuda gituꞌeye, be ꞌenega ꞌaboꞌagu wate ꞌamu esana yada gituꞌeye. ");
INSERT INTO dob_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Manuna ꞌoyo loina ꞌuꞌebwaꞌegu tomota maiboꞌadi manudi, be ꞌenega ꞌaboꞌagu yawasi ataya yada ꞌebwaya taudi maiboꞌadi ꞌuꞌebwaꞌeguya ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ta yawasi ataya gete ꞌabo tomota simwalatoniyo ꞌaene ꞌoyo tuga tebweuyo Yaubada ꞌaiꞌaila, be wate ꞌabo Toꞌetoseyana nigu simwalatonigu ꞌaene ꞌoyo ꞌuetuneguma. ");
INSERT INTO dob_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Baleꞌu gete ꞌena ꞌamu esana niꞌatu yagituꞌeyena, manuna ꞌigu guinuwa nidi ꞌuꞌebwaꞌeguya niꞌatu yalosalonidi. ");
INSERT INTO dob_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamagu ye, gete tuga matamuya ꞌagu esana ꞌuda gituꞌeye, nadigega tuga lowa ꞌoyo be ꞌaboꞌagu ꞌida esaesa nina ꞌena tamiyami, ga muliyega baleꞌu tamweluluina. ");
INSERT INTO dob_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ta ꞌimu bubuna maiboꞌana niꞌatu yaeꞌitaena taudi me baleꞌu ꞌuꞌebwaꞌeguya ꞌediya, manuna ꞌoyo ꞌimu tomotaiyao ta ꞌuꞌebwaꞌegu, ga ꞌimu ona maiboꞌana simuliyena, ");
INSERT INTO dob_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ta wate yage nidi yauyauna ꞌuꞌebwaꞌeguya simwalamwalatonidi ꞌaene ꞌoyo ꞌemuyega. ");
INSERT INTO dob_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Manuna ona nina ꞌuꞌebwaꞌeguya niꞌatu yaeꞌitedi ta ꞌatediya sisaꞌuna, ꞌenega simwalatoi ꞌaiꞌailiguya ꞌaene ꞌoyo ꞌemuyega yamai, ta wate siemiseguya ꞌaene ꞌoyo ꞌuetuneguma. ");
INSERT INTO dob_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ꞌEnega gete tuga manudi yasidasidawa ꞌemuya. Nigeya ꞌaene me baleꞌu manudi, ta esi tomota nidi ꞌuꞌebwaꞌeguya manudi, manuna taudi ꞌimu tomotaiyao. ");
INSERT INTO dob_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ta toꞌase nadigega ꞌeguya simiyami ꞌoyo ꞌimu ꞌebeloina, ta toꞌase nadigega ꞌemuya simiyami ꞌaboꞌagu ꞌigu ꞌebeloina, be tomota getedi manudi ꞌagu esana niꞌatu ꞌisinabwa. ");
INSERT INTO dob_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ta ꞌaboꞌagu niꞌatu gete be ꞌemuya yawawa, ta geyaꞌabo wate baleꞌuya yamiyami, ta esi taudi gete bada baleꞌuya simiyami. Tamagu ye, ꞌoyo toꞌesasa ꞌaiꞌaila. Yasida ꞌemuya be ꞌaene ꞌimu waiwaiyega ꞌuda ꞌitaꞌiꞌisidi taudi tomotai nidi ꞌuꞌebwaꞌegu, be ꞌenega sida eboda ꞌebweuna, nadigega tuga ꞌoyo be ꞌaboꞌagu ꞌebweuna tuga. ");
INSERT INTO dob_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ta tuta nina ꞌaboꞌagu maꞌedi ꞌimu waiwai nina ꞌuꞌebwaꞌeguya ꞌenega yaꞌitaꞌiꞌisidi, ta nigeya ꞌebweu wate yaita ꞌediyega yaloseloseye, nate namo tai nina lowa Buki Tabu ꞌena tauna manuna ꞌieonena be ꞌaene ꞌiesilae. ");
INSERT INTO dob_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ta ꞌaboꞌagu niꞌatu gete be yawawa ꞌemuya, ta ꞌigu ona getedi baleꞌuya ꞌigu tomotaiyao yaonaonaedi be ꞌenega ꞌigu gwausowala ꞌenega sida gwausowala sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ta tomota nidi ꞌimu ona niꞌatu yaꞌebwaꞌedi, ta esi me baleꞌu sietalauwaledi, manuna taudi nigeya me baleꞌu ꞌidi boda ꞌena simiyami, tuga nadigega ꞌaboꞌagu wate nigeya ꞌidi boda ꞌena yamiyami. ");
INSERT INTO dob_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ta nigeya yasidasida manudi be ꞌaene baleꞌuyega ꞌuda ꞌewa apwesedi, ta esi yasidasida manudi be ꞌaene geyaꞌabo totoꞌumalina nina ꞌigitogitoodi. ");
INSERT INTO dob_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Manuna gete tuga taudi nigeya me baleꞌu ꞌidi boda ꞌena simiyami, ta taudi esi nadigega ꞌaboꞌagu. ");
INSERT INTO dob_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ta yasida ꞌemuya be ꞌimu ona ꞌaiꞌailega ꞌuda gieboboꞌanedi be ꞌimu bodao ꞌesasedi. ");
INSERT INTO dob_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","“Nadigega tuga ꞌoyo ꞌuetuneguma me baleꞌu ꞌediya ꞌaboꞌagu wate nadigega yaetunedi me baleꞌu ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ꞌIgu tomotai nidi manudi yatagwalegu ꞌemuya be ꞌenega tuta ꞌimeema ꞌenaya taudi wate sida tagwala ꞌaiꞌailedi ꞌemuya. ");
INSERT INTO dob_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Tamagu ye, nigeya ꞌaene taudimo manudi yasidasidawa, ta esi taudi wate maꞌetamo ꞌidi onega sida emisegu manudi. ");
INSERT INTO dob_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yasida ꞌemuya be ꞌaene maiboꞌadi sida eꞌebweu ꞌedaya, nadigega ꞌoyo be ꞌaboꞌagu ꞌebweuna tuga, be ꞌenega me baleꞌu sida emisegu ꞌaene ꞌoyo ꞌuetuneguma. ");
INSERT INTO dob_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","“Lowa ꞌimu esaesa maemaedanina ꞌuꞌebwaꞌeguya niꞌatu tomotai nidi yaꞌebwaꞌedi, be ꞌenega sida eꞌebweu, nadigega tuga ꞌaboꞌada taeꞌebweuna. ");
INSERT INTO dob_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ta ꞌaboꞌagu ꞌediya yamiyami. ꞌOyo wate ꞌeguya ꞌumiyami, be gete ꞌenega sida eꞌebweu ꞌaiꞌaila. Be wate gete ꞌenega me baleꞌu sida mwalatonigu ꞌaene ꞌoyo ꞌuetuneguma, be wate sida mwalatoniyo ꞌaene ꞌoyo ꞌuobobomedi taudi, tuga nadigega ꞌaboꞌagu ꞌuobobomegu. ");
INSERT INTO dob_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamagu ye, taudi niꞌatu ꞌuꞌebwayaedi ꞌeguya nuwanuwagu be maꞌegwao ꞌada miyami. Ta gote ꞌena ꞌigu esaesa nina ꞌuꞌebwaꞌeguya sida ꞌita, manuna muliyega be baleꞌu ꞌana mweluluwa ta ꞌoyo ꞌugimi obobomegu. ");
INSERT INTO dob_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamagu ye, ꞌoyo palupaluyo, me baleꞌu nigeya simwalamwalatoniyo, ta esi ꞌaboꞌagu yamwalatonimu. Ta wate tomotai nidi getedi niꞌatu simwalatonimu ꞌaene ꞌoyo ꞌuetuneguma. ");
INSERT INTO dob_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ꞌEnega niꞌatu ꞌimu bubuna yaeꞌitaena ꞌediya, ta maꞌetamo wate yada eꞌita limadi be sida mwalatoi ꞌaiꞌailiyo, ꞌenega ꞌimu oboboma nina ꞌateguya ꞌimiyami, taudi wate ꞌatediya ꞌida miyami, ta ꞌaboꞌagu wate ꞌediya yada miyami.” ");
INSERT INTO dob_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ta niꞌatu ꞌina sidasida ꞌilosalonina ta ma ina tononoyao sitauya, ga ꞌebweu saꞌala ꞌana esana Kidiloni siabalena, ga Olibe bagulinaya silugu. ");
INSERT INTO dob_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ta Yudasa tauna totelesipupu nina sena nina ꞌimwalamwalatoni, manuna tuta yauna Yesu ma ina tononoyao sena nina ꞌena sitautauya. ");
INSERT INTO dob_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ꞌEnega Yudasa tolosaiyao maꞌenao simai sena nina ꞌenaya, ma idi wenukwa be mayale be wate ma idi gwegwe saiyao. Ta tolosaiyao nidi taudi totaliyao be Palisiyao sietunedima Yudasa maꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ta Yesu yage nidi ꞌiabe be ꞌena ꞌiapwesa niꞌatu ꞌigimi sinapudi, ꞌenega ꞌinao tolosaiyao nidi ꞌediya ga ꞌienaidedi, ꞌigwae, “Yaita waꞌebeꞌebese?” ");
INSERT INTO dob_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ga taudi sigwae, “ꞌEbweu goma Nasaleta ꞌana esana Yesu.” ꞌEnega Yesu ꞌieonedi, “ꞌAboꞌagu gete.” Ta totelesipupu nina Yudasa tolosaiyao nidi maꞌediya sitootoolo. ");
INSERT INTO dob_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ta tuta nina Yesu ꞌigwae, “ꞌAboꞌagu gete”, gote ꞌena tolosaiyao nidi tupwana siaila ga sibeꞌu baleꞌuya. ");
INSERT INTO dob_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ta tolosaiyao nidi baleꞌuyega sitoolo limana ga Yesu wate ꞌienaida limedi ꞌigwae, “Yaita sana waꞌebeꞌebese?” Ta taudi wate sigwae, “ꞌEbweu goma Nasaleta ꞌana esana Yesu.” ");
INSERT INTO dob_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ꞌEnega wate ꞌediya ꞌigwae, “Ta! Niꞌatu saꞌi yaeonemi ꞌaene ꞌaboꞌagu gete. Ta ꞌeguma ꞌaboꞌagu waꞌebeꞌebesegu, ꞌagu tomuliyao getedi wada tagwaledi be sitatauya ꞌidi ꞌasaya.” ");
INSERT INTO dob_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu ona nina gete nadigega ꞌiꞌinanena be ꞌenega ꞌina sida nina niꞌa Tamana ꞌenaya ꞌida apwesa ꞌaiꞌaila, tuta nina ꞌigwae, “Tamagu, tomotai nidi ꞌuꞌebwaꞌeguya nigeya ꞌebweu wate yaita ꞌediyega yaloseloseye.” ");
INSERT INTO dob_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ta Saimoni Pita selabenaya ꞌitootoolo, ga ꞌina sisisaiya ꞌilisilolona ga totaliya sinabwana ꞌebweu ꞌina toguinuwa tenaꞌataina ꞌiꞌupwayaulena. Toguinuwa nina ꞌana esana Maliko. ");
INSERT INTO dob_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ꞌEnega Yesu ꞌiona Pita ꞌenaya, ꞌigwae, “ꞌImu sisisaiya ꞌusaꞌulima, geyaꞌabo ꞌigu ꞌelouya keigana ꞌuꞌetoꞌetobode, manuna keiga nina Tamagu ꞌiꞌebwaꞌegu be yada numa.” ");
INSERT INTO dob_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ꞌEnega tolosaiyao nidi ma idi toanuganao be wate me Yudia ꞌidi ꞌaliꞌeiyao Yesu sigiyaina ga nimana siyonina. ");
INSERT INTO dob_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ga nugana siꞌauꞌewena ga sitauyena Anasa ꞌina anuwaya. Tauna Anasa nina ꞌinapwana ꞌebweu, nate Kaiyapa bwasiyana. Ta yakwala gote ꞌena Kaiyapa nina totaliyao ꞌidi ꞌinapwana sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ta wate tauna Kaiyapa nina lowa me Yudia ꞌieonedi ꞌaene ꞌilobwenena be tai ꞌebweuna ꞌida mwawasa tomota yauyaudi manudi. ");
INSERT INTO dob_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ꞌEnega Yesu siꞌauꞌewena ga ꞌina tononoyao ꞌeluwa boda nidi simuliyedi. Taudi tonono nidi Saimoni Pita be wate ꞌebweu mali tonono, tauna totaliya sinabwana gosiyana. ꞌEnega boda maꞌenao silugu totaliya sinabwana ꞌina anuwaya. ");
INSERT INTO dob_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita nigeya ꞌilugulugu ta ꞌawa selabenaya ꞌitootoolo, ꞌenega tomuliya nina tauna totaliya sinabwana gosiyanana ꞌiapwesa ga ꞌawa ꞌana toꞌitaꞌiꞌita ꞌebweu waine ꞌieonena be ꞌaene Pita wate ꞌida lugu. ꞌEnega waine nina ꞌitagwala ga Pita ꞌilugu. ");
INSERT INTO dob_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ta waine nina Pita ꞌienaidena, ꞌigwae, “ꞌOyo nai ꞌebweu Yesu ꞌana tomuliya, aga?” Ta Pita ꞌieyaseyase, ꞌigwae, “Yaa! ꞌAboꞌagu nigeya.” ");
INSERT INTO dob_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ta tuta nina ꞌena, tuta gogai, ꞌenega toguinuwao be tolosaiyao kaiwe simuꞌena ga sisiyasiyata, ta Pita wate ꞌilugu ꞌediya ga maꞌediya sisiyasiyata. ");
INSERT INTO dob_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ta totaliya sinabwana Yesu ꞌienaidena ꞌaene yaisigedi ꞌana tomuliyao be wate toꞌase ꞌina eꞌita ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ꞌEnega Yesu ꞌieonena, ga ꞌigwae, “ꞌAboꞌagu ꞌigu eꞌita apwesaya tomota ꞌediya anuwa tapwalolo soladiya ta wate Anuwa Tabu solanaya, ꞌenega me Yudia maiboꞌadi tuta nina ꞌena silugulugu ga niꞌatu ꞌigu eꞌitao sinonodi, manuna nigeya ꞌediyega yada eꞌita kwaiya. ");
INSERT INTO dob_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ta toꞌase ꞌalena ga ꞌenega ꞌeguya waenaenaida, ta esi taudi ꞌigu ona sinonona ꞌediya wada enaida. Manuna toꞌase ꞌigu ona ꞌediya niꞌatu simwalamwalatoni.” ");
INSERT INTO dob_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tuta nina Yesu ꞌina eꞌisao ꞌisimanediya gete nadigega, ꞌenega ꞌebweu tolosaiya selabenaya ꞌitootoolo nimanega Yesu ꞌiꞌauꞌaseꞌasena, ga ꞌena ꞌigwae, “Yaita sana ꞌoyo ꞌuonaona oopaꞌala totaliya sinabwana ꞌenaya?” ");
INSERT INTO dob_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ta Yesu tai nina ꞌina ona ꞌieꞌisena ga ꞌigwae, “ꞌAbo ꞌunuwena ꞌigu ona nigeya palupaluna ꞌuda simana apwesa toꞌase ꞌigu onagesi. Ta ꞌabo ꞌigu ona palupaluna, toꞌase ꞌalena ga ꞌenega ꞌusapigu?” ");
INSERT INTO dob_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ꞌEnega Anasa Yesu ꞌietunena, ga ma ꞌana yona tolosaiyao sitauyena totaliya sinabwana Kaiyapa ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ta Pita tuga ꞌetamo maꞌediya sisiyasiyata, ꞌenega sienaidena, sigwae, “ꞌOyo gete tai nina ꞌana tomuliya ꞌebweu, aga?” Ta Pita wate ꞌieyaseyase ga ꞌigwae, “Yaa! ꞌAboꞌagu nigeya.” ");
INSERT INTO dob_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ꞌEnega ꞌebweu totaliya sinabwana ꞌina toguinuwa, tai nina tenana lowa Pita ꞌiꞌupwayaulena ꞌina susuyega, Pita ꞌieonena, ꞌigwae, “ꞌOyo nai wate Yesu maꞌiyayao bagulaya yaꞌitemi, aga?” ");
INSERT INTO dob_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ta Pita wate ꞌieyaseyase limana, ga gete ꞌena kakaleko ꞌigwane. ");
INSERT INTO dob_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ꞌEnega Yesu Kaiyapa ꞌina anuwega siꞌauꞌewena ga sitauyena toloina sinabwana Pailato ꞌina anuwaya. Ta niꞌatu tomwa ꞌiulisina, ꞌenega nigeya sawesawediya be me Yudia nidi silulugu Pailato ꞌina anuwaya, manuna to tuta ꞌena Ataona masulina sida ꞌani geyaꞌabo me Loma ꞌidi anuwa ꞌediya silugulugu. Nate ꞌidi tabu sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nate ꞌalena ga ꞌenega Pailato ꞌiapwesa ꞌediya ta ꞌienaidedi, ꞌigwae, “Toꞌase ꞌimi eꞌewa tai gete manuna? Wada eonagu.” ");
INSERT INTO dob_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ꞌEnega me Yudia nidi sigwae, “ꞌEguma tai gete nigeya totoꞌumalina geyaꞌabo ꞌaꞌauꞌewenama ꞌemuya.” ");
INSERT INTO dob_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ta Pailato wate ꞌediya ꞌiona, “Boboꞌana ꞌeguma watauye be ꞌomi taumi ꞌimi loinega waetalae.” Ta me Yudia nidi sigwae, “ꞌAboꞌama nigeya ꞌama tagwala be tai ꞌina mwawasa manuna ꞌada loina.” ");
INSERT INTO dob_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ta ona getedi ꞌina mwawasa manuna niꞌatu Yesu lowa ꞌigimi simanedi, be ꞌenega tuta gete ꞌida apwesa. ");
INSERT INTO dob_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ꞌEnega Pailato ꞌilugu limana ꞌina anuwaya ga Yesu ꞌibwauyena ta tauna wate ꞌilugu ꞌenaya; ꞌenega ꞌienaidena, ꞌigwae, “ꞌOyo me Yudia ꞌidi kini?” ");
INSERT INTO dob_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ta Yesu wate ꞌiona, “Gete ꞌoyo ꞌimu nuwenuwega ꞌuenaidegu? Nai tomota ꞌawadiyega ꞌunonona ꞌaene ꞌaboꞌagu me Yudia ꞌidi kini?” ");
INSERT INTO dob_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ꞌEnega Pailato ꞌigwae, “ꞌAboꞌagu nigeya goma Yudiagu! Ta ꞌoyo tauyo ꞌimu tomotaiyao ta wate totaliyao siꞌauꞌewemuma ꞌeguya. Toꞌase sana ꞌimu toꞌumalina?” ");
INSERT INTO dob_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ta Yesu ꞌiona, “ꞌIgu ꞌebeloina nigeya gete baleꞌuya. ꞌEguma nadigega, ꞌigu ꞌaliꞌeiyao sida losaiya manugu be geyaꞌabo me Yudia sigiyagiyaigu. Onaꞌaiꞌaila, ꞌaboꞌagu nigeya ꞌigu ꞌebeloina bada.” ");
INSERT INTO dob_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ꞌEnega Pailato ꞌienaidena, ꞌigwae, “ꞌAene ꞌoyo ꞌebweu kini, aga?” Ta Yesu ꞌigwae, “ꞌOyo ꞌuona ꞌaene ꞌaboꞌagu ꞌebweu kini, aga? Ta ꞌaboꞌagu tuga yatubuwa ga yamai baleꞌuya be ꞌaene yada etosimana ona palupaluna manuna, ta ꞌabo yaisigedi taudi ona palupaluna ꞌina sena ꞌena simiyami, taudi nate ꞌenagu ꞌana tononoyao.” ");
INSERT INTO dob_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ta Pailato wate ꞌienaida, “Ona palupaluna toꞌase?” ꞌEnega Pailato ꞌiapwesa limana ga me Yudia nidi ꞌediya ꞌigwae, “Nigeya ꞌebweu ꞌina loegesi yalobaloba. ");
INSERT INTO dob_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ta ꞌomi tuta yauna ꞌimi bubuna be ꞌaene Ataona Sagalina ꞌana tuta ꞌediya ꞌebweu tomota yoniyonina yaꞌetoliꞌami manumi. Mwaꞌadega nuwanuwami be me Yudia ꞌimi kini yada ꞌetoliꞌami manumi?” ");
INSERT INTO dob_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ta maiboꞌadi silolagata ga ꞌenadi sinabwana ꞌenega sieꞌisena, sigwae, “Nigeya! Geyaꞌabo tauna! Ta esi nuwanuwama Balaba ꞌuda ꞌetoliꞌami.” Balaba tauna toꞌoae sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ꞌEnega Pailato Yesu ꞌiꞌauꞌewena ga ꞌina tolosaiyao ꞌiꞌebwaꞌedi, ga balae metametana siꞌewena ga ꞌenega Yesu sisapina sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ta wate tolosaiyao nidi kwakwakwala siꞌewena ga ꞌana peyaula siyonina, ꞌenega debanaya sisaꞌuna. Ta wate ꞌoama esaesa siꞌewena ga ꞌenega sieꞌoamena, ");
INSERT INTO dob_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ga muliyega simai selabenaya ga ꞌena sigwae, “Kamatoki, ꞌoyo me Yudia ꞌidi kini, aga?” Ta wate nimadiyega sisapina. ");
INSERT INTO dob_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ta Pailato ꞌiapwesa limanama ga boda ꞌediya ꞌigwae, “Waꞌita tai nina gete yaꞌauꞌewa apwesenama ꞌemiya, be wada mwalatoni ꞌaene nigeya ꞌebweu ꞌina loegesi yalobaloba.” ");
INSERT INTO dob_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ꞌEnega Yesu ma ꞌana peyaula ta wate ma ꞌana ꞌoama esaesa ꞌiapwesama. Ta wate Pailato boda ꞌediya ꞌiona, ꞌigwae, “Tai nina gete waꞌita.” ");
INSERT INTO dob_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ta totaliyao ꞌidi ꞌinapwanao, ta wate ꞌidi toguinuwao, tuta nina Yesu siꞌitena, sibwau, sigwae, “Watutu epaꞌiye kelose ꞌenaya!” Ga Pailato ꞌediya ꞌiona, “Taumi wada tauye be wada tutu epaꞌiye, manuna ꞌaboꞌagu nigeya ꞌebweu ꞌina loegesi yalobaloba.” ");
INSERT INTO dob_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ta me Yudia nidi siona limana, sigwae, “ꞌIma loina nadigega be ꞌida mwawasa, manuna ꞌikabo ꞌaene tauna Yaubada natuna.” ");
INSERT INTO dob_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ta ona gete Pailato ꞌinonona ga ꞌimatauta sinabwana. ");
INSERT INTO dob_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ꞌEnega Yesu ꞌiꞌauꞌewa limena ꞌina anuwaya ga ꞌienaidena, ꞌigwae, “ꞌOyo mane ꞌenega ꞌumai?” Ta Yesu nigeya ꞌieꞌieꞌisa. ");
INSERT INTO dob_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ꞌEnega Pailato wate ꞌena ꞌiona, “Nigeya ꞌigu enaida ꞌueꞌisai, aga? Ta ꞌuda mwalatonigu ꞌaene ꞌaboꞌagu ma igu loina be sida ꞌetoliꞌamiyo nai sida loemwawasiyo?” ");
INSERT INTO dob_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ta Yesu ꞌigwae, “Nigeya ꞌebweu wate ꞌimu loina ꞌeguya ꞌimiyami ꞌabo nigeya Yaubada ꞌemuya ꞌitagwatagwala. Ta ꞌuda mwalatoni ꞌaene tai nina ꞌitagwalegu ꞌimu loina ꞌenaya, tauna ꞌina toꞌumalina sinabwa wawasae, ta ꞌoyo tupwana.” ");
INSERT INTO dob_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ta Pailato ona nina ꞌinonona ga nuwanuwana sinabwana be Yesu ꞌida liꞌami, ta me Yudia nidi geya nuwadi, ꞌenega sibwau toitoila, sigwae, “ꞌEguma tai nina ꞌuliꞌami, ꞌoyo nigeya Sisa ꞌana tolema, manuna tai nina ꞌiona ꞌaene tauna kini, ꞌenega tamwalatonina ꞌaene tauna Sisa ꞌana talauwala.” ");
INSERT INTO dob_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ta Pailato niꞌatu ꞌidi ona ꞌinonodi, ꞌenega Yesu ꞌiꞌauꞌewa apwesena ga Pailato nina ꞌimiyatowa ꞌebeloina daꞌwa ꞌenaya. Sena nina me Yudia ꞌenadiyega sieesena Gabada. ");
INSERT INTO dob_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ta niꞌatu ꞌasuoleole, be muliyega mali ꞌasiyataya Ataona masulina siꞌaꞌani. ꞌEnega Pailato me Yudia ꞌieonedi, ꞌigwae, “Waꞌita ꞌimi kini gete.” ");
INSERT INTO dob_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ta taudi sibwau, “Watauye be watutu epaꞌiye kelose ꞌena.” ꞌEnega Pailato wate ꞌediya ꞌienaida, “Mwaꞌadega ꞌimi kini tauna, ta ꞌaene ꞌada loemwawasi?” Ta totaliya sinabwadi ꞌina ona sieꞌisena, sigwae, “ꞌIma kini tuga Sisa namo. ");
INSERT INTO dob_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ꞌEnega Pailato ꞌediya ꞌitagwala be ꞌaene Yesu sida tutu epaꞌiye kelose ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ꞌEnega tolosaiyao nidi Yesu sigiyaina ga sitauyena. Yesu tauna ꞌana kelose ꞌiꞌaalina ga maꞌenao sitauya ꞌebweu sena ꞌena, ꞌana esana ‘Bulubulu’, ꞌena Yudia nate Goligota. ");
INSERT INTO dob_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ga gote ꞌena situtu epaꞌiyena ꞌana kelose ꞌena. Ta tai ꞌeluwa wate situtu epaꞌiyedi ga sietoolodi, ꞌebweu ꞌatainega ta ꞌebweu gegeuminega, ta Yesu gamwagamwanidiya. ");
INSERT INTO dob_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailato ꞌebweu pwepwai niꞌatu ꞌiꞌetoladina ga kelose debanaya sigiepaꞌiyena, ꞌana ꞌetoladi nadigega ꞌigwae, “Me Yudia ꞌidi kini gete, tauna Yesu goma Nasaleta.” ");
INSERT INTO dob_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ta sena nina ꞌena Yesu sigiekelosenaya nigeya ꞌedasola Yelusalema ꞌenega, ꞌenega me Yudia yaudi ꞌetoladi nina sisawena, manuna ꞌenana ꞌetoi ꞌediyega siꞌetoladina, ꞌena Yudia be ꞌena Loma, ta wate ꞌena Gilisi. ");
INSERT INTO dob_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ꞌEnega totaliyao ꞌidi ꞌinapwanao simai ga Pailato ꞌenaya sigwae, “ꞌInapwana, toꞌase manuna ꞌuꞌetoladina ꞌaene me Yudia ꞌidi kini? Ta esi ꞌuꞌetoladi be ꞌuda gwae, ‘Tai gete ꞌiona ꞌaene tauna me Yudia ꞌidi kini.’” ");
INSERT INTO dob_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ga Pailato ꞌediya ꞌiona, ꞌigwae, “Geyaꞌabo yasaꞌusaꞌu gelase. Tuwa tuga nadigega ꞌimiyami.” ");
INSERT INTO dob_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","ꞌEnega tolosaiyao nidi site ata taudi Yesu sigiekelosenaya, ga ꞌana ꞌoamao siꞌewedi ga sieguyaiyedi taudimo ꞌediya. Ta ꞌana talaꞌapwala siꞌewena ta taudimo ꞌediya sigwae, “Geyaꞌabo tasabusabui, manuna ꞌoama sinabwana ta bababana, ta nigeya ꞌebweu wate ꞌana tubwemo. ꞌEnega nai ꞌebweu esaesasala ꞌenega tada ulaesinuwa, be ꞌabo yaita ꞌinunugana tauna talaꞌapwala nina ꞌida ꞌewa.” Gete ꞌenega be Buki Tabu ꞌina simana ꞌida apwesa ꞌaiꞌaila, manuna ꞌigwae, “ꞌAgu ꞌoamao sieguyaiyedi, ta ꞌagu talaꞌapwala manuna siulaesinuwa.” ꞌEnega tolosaiyao nidi nadigega siguinuwena. ");
INSERT INTO dob_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ta Yesu ꞌana kelose selabenaya iine site ata sitootoolo, nate taudi Yesu sinana matasina ta wate mali Meli tauna Kilopa mwanena, ta wate Meli Magidala. ");
INSERT INTO dob_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gote ꞌena Yesu ꞌisanamwaꞌuta ga sinana be iine nidi maꞌenao ꞌiꞌitedi, ta wate ꞌina tonono nina gosiya ꞌaiꞌailina ꞌiꞌitena. ꞌEnega sinana ꞌena ꞌigwae, “Sinagu, tai nate natuyo.” ");
INSERT INTO dob_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ta wate tai nina ꞌena ꞌigwae, “Gosiyagu, nate sinayo.” Gote ꞌena Yesu ꞌina mwawasa mulinaya tai nina Yesu sinana ꞌiꞌauꞌewena ꞌina ꞌasaya ga ꞌiꞌitaꞌiꞌisina. ");
INSERT INTO dob_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Gete ꞌena Yesu ꞌimwalatonina ꞌaene yage yauyaudi niꞌatu ꞌilosalonidi, ꞌenega ꞌigwae, “Tonaꞌagu ꞌiyapasa”. Be ona gete ꞌenega Buki Tabu ꞌina simana ꞌida apwesa ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sena nina ꞌena oine mayumayuyuna makeigana sisaꞌuna, ꞌenega balou siꞌewena ga bwasi nina ꞌena siepwasena, ga ꞌebweu kaiwe ꞌana esana isopa matanaya sibadiyena, ga sieꞌetotuꞌeyena Yesu ꞌawanaya, ta ꞌenega ꞌisokuku. ");
INSERT INTO dob_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ta muliyega Yesu ꞌigwae, “Niꞌatu.” ꞌEnega ꞌotona ꞌiꞌenoꞌuna, ga yawasina ꞌigumwala. ");
INSERT INTO dob_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ꞌEnega me Yudia ꞌadi toanuganao nidi sitauya Pailato ꞌena, ga sisida ꞌabo sawesawenaya ꞌida tagwaledi be tomotai nidi kelose ꞌediya situtu epaꞌiyediya ꞌaedi sida lasadi be sida mwawasa manini, be ꞌenega ꞌadi keloseyega sida ꞌaala mwaꞌutedi, manuna niꞌatu simwalatonina ꞌaene ꞌidi ꞌasiyata sinabwana selabenaya be ꞌena siapwesa, ꞌenega geya nuwadi be tomotai nidi sida miyami kelose ꞌediya ꞌidi Sabate nina ꞌena. ");
INSERT INTO dob_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ꞌEnega Pailato ꞌitagwala, ga ꞌaidi tolosaiyao ꞌietunedi kelose nidi ꞌediya, ga tai ꞌebweuna ꞌaena sigimi lasena ga ꞌimwawasa, ꞌenega wate mali tai ꞌaena silasena ga ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ta wate simai Yesu ꞌena ga siꞌitena tauna niꞌatu ꞌimwawasa, ꞌenega nigeya ꞌaena silasalasadi. ");
INSERT INTO dob_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ta tolosaiya ꞌebweu gita ꞌigilagasina ga Yesu lesulesunaya ꞌibadina, ga lala be bwasi sidau. ");
INSERT INTO dob_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ꞌAboꞌagu ꞌana tomuliya ꞌebweu ga mataguyega yaꞌitena, ꞌenega gete manuna yaonaona ꞌemiya, be ona ꞌaiꞌaila nidi getedi wada mwalatonidi be ꞌenega wada emisa. ");
INSERT INTO dob_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yage nidi gete niꞌatu siapwesa be ꞌenega Buki Tabu ꞌina simana ꞌida apwesa, tuta nina ꞌigwae, “Geyaꞌabo saꞌi lulunao silasalasadi.” ");
INSERT INTO dob_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ta wate Buki Tabu nina ꞌebweu ꞌina simana ꞌigwae, “Tai nina sibadinaya maꞌetamo siduneye.” ");
INSERT INTO dob_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ga yage getedi sigumwala, ga tai ꞌebweu ꞌimai, ga Yesu kokowana Pailato ꞌena ꞌisidena. Tai nina goma Alimatia ꞌana esana Yosepa, ta wate tauna ꞌebweu Yesu ꞌana tomuliya kwaikwaiyina, manuna me Yudia ꞌidi toanuganao ꞌimatautedi. ꞌEnega Pailato ꞌitagwala, ga Yosepa ꞌimai ga Yesu kokowana ꞌigitaꞌina, ga ꞌisaꞌu mwaꞌutena ga ꞌiꞌewena. ");
INSERT INTO dob_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ta Nikodimo wate ꞌimai ga Yosepa ꞌilemena. Tauna Nikodimo nina lowa Yesu ꞌena ꞌitauya boiboiya ga siꞌawagwae. Nikodimo bunama sinabwana ta mwauna ꞌimeꞌena, ꞌana mwau nadigega tai ꞌana mwau, ta bunama nina solanaya mulo ta aloe siꞌeinisina. ");
INSERT INTO dob_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ꞌEnega tomotai nidi ꞌeluwa Yesu kokowana siꞌewena ga bunama nina ꞌenega sibunamina, ta kaleko wakewakekena ta dudulana siꞌewena ga bunama nina ꞌana tupwa Yesu kokowana maꞌiyana sinugwena, nadigega tuga me Yudia ꞌidi saꞌuꞌaliꞌali be ꞌidi gibubuna kokowa manudi. ");
INSERT INTO dob_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ta Yesu ꞌina ꞌebe mwawasa nina selabenaya ꞌebweu ꞌoꞌai, ta ꞌoꞌai nina ꞌenaya ꞌebweu ꞌaliꞌali auwauna ꞌimiyami, ta ꞌenaya nigeya ꞌebweu kokowa sida saꞌuna. ");
INSERT INTO dob_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ꞌEnega ꞌaliꞌali nina ꞌenaya Yesu kokowana sisaꞌuna, manuna selabenaya, ta wate me Yudia ꞌidi Sabate ꞌiloselabena. ");
INSERT INTO dob_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ta niꞌatu wiki ꞌana gimiꞌasiyata ꞌimai ga gonamapumapuya Meli Magidala ꞌimai ꞌaliꞌaliya ga ꞌana ꞌauboda gulewa ꞌiꞌitena ꞌaliꞌali ꞌawanega niꞌatu sipuli ilena. ");
INSERT INTO dob_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ꞌEnega ꞌipili ga Yesu ꞌina tononoyao ꞌediya ꞌiona, ꞌigwae, “Niꞌatu ꞌInapwana siꞌewa apwesena ꞌaliꞌaliyega, ta mwaꞌo nai sisaꞌuna.” Tonono nidi Saimoni Pita be Yesu gosiya ꞌaiꞌailina. ");
INSERT INTO dob_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ꞌEnega siteluwa nidi sitoolo ga sitauya ꞌaliꞌaliya, ");
INSERT INTO dob_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ta ꞌidi tauya ꞌenaya sipilipili, ga Yesu gosiya ꞌaiꞌailina ꞌipili waiwai ga ꞌinugana ꞌaliꞌaliya, ");
INSERT INTO dob_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ga ꞌaliꞌali ꞌena ꞌikopu sanalugu ga kaleko daisidimo ꞌiꞌitedi simiyami, ta nigeya ꞌilugulugu ꞌaliꞌali solanaya. ");
INSERT INTO dob_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ꞌEnega Saimoni Pita wate mulinega ꞌipilima ga palupaluna ꞌilugu ꞌaliꞌali solanaya, ga tauna wate kaleko nidi ꞌeluwa ꞌiꞌitedi, ");
INSERT INTO dob_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ꞌebweu debana ꞌana wadu ta wate oona maiboꞌana ꞌana wadu, ta debana ꞌana wadu nina tuwa tuga ꞌetamo paipaimina ꞌiꞌitena, tupwana ꞌimiya dumaduma oona ꞌana wadu ꞌenega. ");
INSERT INTO dob_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ta muliyega tai nina tauna ꞌaliꞌaliya ꞌigimiapwesa ꞌilugu Pita ꞌena, ga tauna wate kaleko nidi ꞌiꞌitedi ga ꞌiꞌawa ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ta esi nigeya sinuwanuwa sabwaleni Buki Tabu ꞌina simana nina ꞌigwae, ‘Toꞌetoseyana nina mwawasega ꞌida toolo limana.’ ");
INSERT INTO dob_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gote ꞌenega tonono nidi siila ꞌidi anuwaya. ");
INSERT INTO dob_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ta Meli nina taunamo ꞌaliꞌali selabenaya ꞌitootoolo ta ꞌidedo, ꞌenega tuwa tuga ma ina dedoi ꞌaliꞌali nina ꞌena ꞌikopu sanalugu, ");
INSERT INTO dob_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ga aniloseyao ꞌeluwa ꞌiꞌitedi, ꞌadi ꞌoamao wakewakekedi Yesu ꞌina ꞌebeꞌeno ꞌena simiyatowa, ꞌebweu debanega ta ꞌebweu ꞌaenega. ");
INSERT INTO dob_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ꞌEnega siteluwa nidi Meli sieonena, sigwae, “Toꞌase manuna ꞌudedoi?” Ga ꞌieonedi, “ꞌIgu ꞌInapwana ꞌaliꞌaliyega siꞌewa apwesena ga nigeya yamwalamwalatoni mane ꞌena sisaꞌuna.” ");
INSERT INTO dob_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ta ꞌina ona gete mulinaya ꞌisanaila, ga Yesu ꞌiꞌitena selabenaya ꞌitootoolo, ta nigeya ꞌimwalamwalatoni ꞌaene tauna Yesu. ");
INSERT INTO dob_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ta Yesu Meli ꞌienaidena, ꞌigwae, “Waine, toꞌase manuna ꞌudedoi? Ta yaita ꞌuꞌebeꞌebese?” Ta Meli ꞌina nuwanuwa ꞌaene bagula nina ꞌana toꞌitaꞌiꞌita, ꞌenega ꞌena ꞌigwae, “ꞌInapwana, ꞌeguma ꞌoyo ꞌuꞌaala apwesena, ꞌuda eonagu mane ꞌena ꞌusaꞌuna, be yada ꞌewalima.” ");
INSERT INTO dob_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ꞌEnega Yesu Meli ꞌana esana ꞌiꞌinanena, ꞌigwae, “Meli!” ta Meli ꞌisanasakowasi ga ꞌena ꞌigwae, “Labonai!” Me Yudia ꞌenadi nate ꞌana gibui “ꞌEnaꞌi.” ");
INSERT INTO dob_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ta Yesu wate ꞌieonena, ꞌigwae, “Geyaꞌabo ꞌugitogitoogu, manuna ꞌetamo nigeya yatuꞌetuꞌe Tamagu ꞌena. Ta ꞌutatauya be tasigwao ꞌueonadi ꞌaene ꞌaboꞌagu ꞌiabe yatutuꞌe Tamagu ꞌenaya, ꞌomi wate Tamami, ta ꞌigu Yaubada ta wate ꞌomi ꞌimi Yaubada.” ");
INSERT INTO dob_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ꞌEnega Meli Magidala ꞌitauya ta tononoyao ꞌediya ꞌisimana, ꞌigwae, “ꞌInapwana niꞌatu yaꞌitena.” Ta wate Yesu ꞌina ona ꞌenaya ꞌisimana apwesedi tonono nidi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ta niꞌatu wiki ꞌana gimiꞌasiyata nina ꞌasuinuwanuwaya, Yesu ꞌina tononoyao anuwa ꞌebweu ꞌena silugu, ga ꞌawa sigibodena, ta solanaya simiyami, ma idi matauta me Yudia manudi. ꞌEnega Yesu ꞌimai ga gamwagamwanidiya ꞌitoolo, ga ꞌediya ꞌigwae, “Geyaꞌabo wamatamatauta.” ");
INSERT INTO dob_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ta muliyega nimana be lesulesuna ꞌieꞌitedi, ga tononoyao sigwausowala manuna ꞌidi ꞌInapwana niꞌatu siꞌitena. ");
INSERT INTO dob_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ta Yesu wate ꞌediya ꞌigwae, “Geyaꞌabo wamatamatauta. Tamagu tauna ꞌietuneguma, ta ꞌaboꞌagu wate nadigega yada etunemi.” ");
INSERT INTO dob_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ta ꞌina ona mulinaya ga yawasina ꞌimuꞌebalena ꞌediya ta wate ꞌediya ꞌiona, “Yaluyaluwa Tabuna waꞌewa, ");
INSERT INTO dob_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","be ꞌabo tomotai ꞌidi toꞌumalinao wanuwataudi Yaubada wate ꞌinuwataudi, ta ꞌeguma nigeya wanuwanuwataudi ꞌediya tuga sida miyami.” ");
INSERT INTO dob_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ta Tomasi tauna ꞌebweuna tononoyao site tuwelo ꞌediyega, ta ꞌana esana ꞌeluwena Didiluwaluwa. Tomasi nina nigeya gosenao maꞌedi tuta nina Yesu ꞌimai. ꞌEnega muliyega Tomasi ꞌimai ga gosenao ꞌena sisimana, sigwae, “ꞌIda ꞌInapwana niꞌatu ꞌaꞌitena.” ");
INSERT INTO dob_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ga tauna ꞌiona, ꞌigwae, “Yee! Nate tuga kabo, ta esi ꞌaboꞌagu ꞌeguma nimana kainumuyega situtu epaꞌiyedi ꞌawaꞌiyaꞌiyaena yaꞌitadi be yagitoodi, ta wate lesulesunana sibadina ꞌena nimagu yasaꞌuluguyei, be ꞌenega yaemisemi.” ");
INSERT INTO dob_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ta niꞌatu wiki ꞌebweuna ꞌigumwala, ga wate tonono nidi anuwa nina ꞌena siegogona limana ga solanaya simiyami, Tomasi nina maꞌediya, ta ꞌawa sigibodedi. ꞌEnega Yesu wate ꞌiapwesa ga gamwagamwanidiya ꞌitoolo, ga ꞌediya ꞌigwae, “Geyaꞌabo wamatamatauta.” ");
INSERT INTO dob_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ta Tomasi ꞌena ꞌiona, “Gete nimagu, ꞌuꞌita, be nimayo ꞌuda saꞌudi weꞌiweꞌiyaya nidi ꞌediya, ta wate nimayo ꞌuda saꞌuluguye lesulesuguya, be ꞌenega ꞌuda emisegu, ta esi geyaꞌabo ꞌuꞌawaꞌawa kabokabo.” ");
INSERT INTO dob_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ꞌEnega Tomasi ꞌigwae, “ꞌOyo ꞌigu ꞌInapwana ta ꞌigu Yaubada.” ");
INSERT INTO dob_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ta Yesu ꞌieonena, ꞌigwae, “Tomasi, niꞌatu ꞌuꞌitegu ꞌenega ꞌuemisegu, aga? Ta ꞌuda mwalatoni ꞌaene yaisigedi taudi nigeya siꞌitaꞌitagu ta tuwa tuga siemiemisegu, taudi tuta yauna ma idi gwausowala.” ");
INSERT INTO dob_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu niꞌatu weꞌiweꞌiyaya yaudi ꞌiguinuwedi ꞌana tomuliyao matadiya. Maiboꞌadi nigeya yaꞌetoꞌetoladidi buki gete ꞌena, ");
INSERT INTO dob_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ta tuwa tuga puꞌepuꞌedimo yaꞌetoladidi be wada sawadi be wada mwalatoni be wate Yesu wada emise ꞌaene tauna Toꞌetoseyana nina, Yaubada natuna, be ꞌenega Yesu ꞌana esanega yawasimi ataya wada ꞌewa. ");
INSERT INTO dob_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","(1,14) Niꞌatu Yesu maluwa tauna ꞌieꞌitaena ꞌina tononoyao ꞌediya, ta wate gete ꞌetonina ꞌina apwesa ꞌediya, ta gete tuga tononoyao sigomagomana Ola Taibilia ꞌena, ga ꞌiapwesa ꞌediya. ");
INSERT INTO dob_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Gete nadigega ꞌina apwesa ꞌediya. Ta tononoyao nidi getedi Saimoni Pita be Tomasi, tauna sieesena Didiluwaluwa, be Nataniela, tauna ꞌina ꞌasa Kena, nate Galili solanaya, ta wate Sebedi natunao, be wate ꞌeluwa tononoyao maꞌediyao. ");
INSERT INTO dob_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Gote ꞌena Saimoni Pita tonono nidi ꞌediya ꞌiona, ꞌigwae, “Gosegwao, nai yatatauya be yagogomana.” Ta wate sigwae, “O, boboꞌana, tawai.” Ga maiboꞌadi waga sigeluna ga sineya, ta boiboi nina gote ꞌena sigomagomana ga silomasalina, ta nigeya ꞌebweu iyana siꞌonaꞌona. ");
INSERT INTO dob_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ta niꞌatu tomwa ꞌiulisina ga tononoyao Yesu siꞌitena leꞌawaya ꞌitootoolo, ta nigeya simwalamwalatoni ꞌaene tauna Yesu. ");
INSERT INTO dob_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ꞌEnega Yesu ꞌediya ꞌigwae, “Tasigwao, ꞌeisa iyana waꞌonedi?” Ga sigwae, “Kakae.” ");
INSERT INTO dob_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ta wate ꞌediya ꞌigwae, “Gomana wayauye waga ꞌatainega be iyana waꞌonadi.” ꞌEnega ꞌidi gomana siyauyena ga iyana yau wawasae siꞌonedi, ga nigeya sawesawediya be gomana siꞌabi. ");
INSERT INTO dob_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Gote ꞌena Yesu ꞌina tonono nina tauna gosiya ꞌaiꞌailina Pita ꞌena ꞌiona, ꞌigwae, “Gosiyagu, gote tauna ꞌida ꞌInapwana nina.” ꞌEnega Saimoni Pita ꞌinonona ꞌaene ꞌidi ꞌInapwana nina, ga ꞌana ꞌoama ꞌiꞌotena, manuna bwala daisinamo ꞌigomagomana, ꞌenega ꞌisobu niꞌuya. ");
INSERT INTO dob_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ta Yesu ꞌina tononoyao maiboꞌadi sineyama ga gomana ma iyanidi wagega silisinama, ga sisuya dabalaya, manuna leꞌawa nigeya ꞌedasola. ");
INSERT INTO dob_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ta niꞌatu tonono nidi dabalaya sisuya ga kalikau ꞌenaya siꞌitena iyana be beledi ꞌisaꞌu baledi.” ");
INSERT INTO dob_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ga Yesu wate ꞌediya ꞌigwae, “ꞌEisa wate ꞌami iyana nidi wameꞌedi be tasaꞌu baledi?” ");
INSERT INTO dob_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ta Saimoni Pita waga ꞌena ꞌigelu ga gomana dabalaya ꞌiꞌabi lagaena, ta gomana nina iyana maiboꞌana ꞌimaa ꞌaiꞌaila, ga ꞌana maiboꞌana nadigega analedi be pipiti tili, ta wate sinabwadi, ta gomana nigeya ꞌiꞌesaꞌesabu. ");
INSERT INTO dob_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ga Yesu ꞌediya ꞌigwae, “Wamai be wadinagwala.” ꞌEnega simwalatonina ꞌaene tauna tuga ꞌidi ꞌInapwana nina, ta nigeya ꞌebweu yaita ꞌediyega ꞌida enaida ꞌaene, “Yaita ꞌoyo?” manuna niꞌatu simwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ꞌEnega Yesu ꞌinao ga beledi be iyana ꞌiꞌewedi ga ꞌina tononoyao ꞌiꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","(-) ");
INSERT INTO dob_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ta ꞌidi loepaꞌala mulinaya, Yesu Saimoni Pita ꞌienaidena, ꞌigwae, “Saimoni ꞌoyo Yoni natuna, ꞌimu oboboma sinabwana ꞌeguya, ta taudi getedi tupwana, aga?” Ga Pita ꞌigwae, “ꞌInapwana niꞌatu ꞌumwalamwalatonigu ꞌaene yaobobomemu.” Ta Yesu ꞌiona, “ꞌIgu lamiyao ꞌuda ꞌitaꞌiꞌisidi.” ");
INSERT INTO dob_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ta Yesu wate ꞌieona limena ga ꞌigwae, “Saimoni ꞌoyo Yoni natuna, ꞌuobobomeguya?” Ga Pita ꞌigwae, “O, niꞌatu ꞌumwalamwalatonigu ꞌaene yaobobomemu.” ꞌEnega Yesu ꞌiona, “ꞌIgu sipiyao ꞌuꞌitaꞌiꞌisidi.” ");
INSERT INTO dob_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ta Yesu wate ꞌina ona ꞌetonina Pita ꞌena ꞌigwae, “Saimoni, ꞌoyo Yoni natuna, ꞌuobobomeguya?” Ga gote ꞌena Pita nuwana ꞌimwau, manuna Yesu ꞌienaenaida matoi ꞌenaya, ꞌigwae, “ꞌUobobomeguya?” Ta Pita ꞌiona limana ga ꞌena ꞌigwae, “ꞌInapwana yage yauyauna ꞌumwalamwalatonidi, ꞌenega ꞌumwalatonigu ꞌaene yaobobomemu.” Ga Yesu wate ꞌena ꞌiona, ꞌigwae, “ꞌIgu sipiyao ꞌuꞌitaꞌiꞌisidi. ");
INSERT INTO dob_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ta yaona ꞌaiꞌaila ꞌemuya ꞌaene ꞌimu tuta gwama ꞌena, tauyo ꞌamu ꞌoama ꞌuꞌoteꞌote be to sena ꞌena nuwanuwayo be ꞌutatauya ꞌuda tauya tuga, ta ꞌabo tuta nina ꞌueꞌinaꞌinapwanaya nimayo ꞌuda yasitoto be mali tomota ꞌamu ꞌoama sida eꞌoteyo, be to sena nina ꞌena geya nuwayo ꞌutatauya, sena nina ꞌena sida tauyeyo.” ");
INSERT INTO dob_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ona gete ꞌenega Yesu ꞌiliꞌaliꞌama Pita ꞌina mwawasa manuna, be ꞌina mwawasa nina ꞌenega Yaubada ꞌana esana ꞌida giesinabwa. ꞌEnega Yesu wate Pita ꞌena ꞌigwae, “ꞌUda muliyegu.” ");
INSERT INTO dob_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ꞌEnega Pita ꞌisanaila, ga ꞌebweu tonono nina Yesu gosiya ꞌaiꞌailina ꞌiꞌitena, tauna ꞌeꞌai ꞌana tutaya Yesu selabenaya ꞌiꞌeno ilaila, ga ꞌienaidena, ꞌigwae, “ꞌInapwana, yaita tauna ꞌamu tosipupu nina?” ");
INSERT INTO dob_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ga Pita tai nina ꞌiꞌitena, ꞌimulimuliyedi ga ꞌiona, “ꞌInapwana, tai gete mwaꞌadega ꞌana loina?” ");
INSERT INTO dob_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ꞌEnega Yesu Pita ꞌina ona ꞌieꞌisena ga ꞌigwae. “ꞌAbo nuwanuwagu be tauna ꞌida miyami be ꞌana laba yailama nate nigeya ꞌebweu wate toꞌase ꞌemuya, ta ꞌoyo tuga ꞌuda muliyegu.” ");
INSERT INTO dob_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ta Yesu ꞌina tononoyao ꞌina ona gete sinonona, ꞌenega taudimo ꞌediya sionaona manuna ꞌidi nuwanuwa ꞌaene tonono nina geyaꞌabo ꞌimwawamwawasa. Ta Yesu gete nadigega nigeya ꞌionaonaꞌesa, ta esi ꞌigwae, “ꞌAbo nuwanuwagu be tauna ꞌida miyami be ꞌana laba yailama, nate nigeya ꞌebweu wate toꞌase.” ");
INSERT INTO dob_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tonono nina gete tauna yage gete manudi ꞌisimana ta wate tauna ona nidi ꞌiꞌetoladidi tetela gete ꞌenaya, ga tamwalatonina toꞌase ꞌisimanedi ona ꞌaiꞌaila maiboꞌana. ");
INSERT INTO dob_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ta onaꞌaiꞌaila, Yesu ꞌina guinuwa yau wawasae simiyami, ta ꞌabo ꞌina guinuwao nidi maiboꞌadi taꞌetoladidi, yanuwena baleꞌu maiboꞌana buki daisinamo, be geyaꞌabo tetelina taloeloegumwali. ");
INSERT INTO dob_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilo ye, buki nina yaꞌetoladi nuganena solanaya Yesu ꞌina guinuwao be ꞌina eꞌitao, ");
INSERT INTO dob_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tuta nina baleꞌuya ꞌimiyami ꞌana laba Yaubada ꞌiꞌauꞌewa tuꞌeyena galewaya. Yesu nina ꞌina mwawasa mulinaya, mayawasina ꞌiapwesa ꞌana tosimanao esiesinuwadi ꞌediya, ga Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌadi loina ꞌiꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ꞌAsiyata poti soladiya ꞌiapweapwesa ꞌediya, ga ꞌebeꞌita yaudi ꞌieꞌitedi, ꞌenega ꞌina toololimana siꞌawa ꞌaiꞌailena, ta Yaubada ꞌina loina manuna ꞌieꞌitedi. ");
INSERT INTO dob_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ꞌEtamo maꞌediya simiyami ta ꞌadi loina ꞌiꞌebwaꞌedi, ꞌigwae, “Geyaꞌabo Yelusalema wapilipilisine, ta esi Tamadai ꞌina onaupaupa nina lowa yaeonemiya manuna wayamwayamwa. ");
INSERT INTO dob_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wanuwaꞌiꞌisi ꞌaene Yoni bwasiyega ꞌigiebapitaisoemi, ta ꞌasiyata nigeya yauna simiyami be ꞌomi ꞌimi bapitaiso Yaluyaluwa Tabuna ꞌenega wada loba.” ");
INSERT INTO dob_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ꞌEbweu tuta Yesu ma ꞌina tononoyao simiya egogona, ta sienaida ꞌenaya, sigwae, “ꞌInapwana, sawesawenaya be gete tuga ꞌaboꞌada me Isileli ꞌuanuganeda be taudamo taloina limaneda?” ");
INSERT INTO dob_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ta Yesu ꞌigwae, “Tamagu tauna ꞌiloiloina, ta nigeya sawesawenaya be ꞌomi wamwalatoni to tuta ꞌina loinao nidi ꞌida guinuwedi. ");
INSERT INTO dob_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ta ꞌomi esi maꞌetamo Yaluyaluwa Tabuna ꞌimamai be ꞌigiewaiwaiyemi, be manugu wada etosimana Yelusalema ꞌenaya, be Yudia ta Samelia ꞌasanao maiboꞌadi ꞌediya, be wate baleꞌu maiboꞌana ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Niꞌatu ꞌina ona getedi ꞌilosalonidi, ga matadiyega Yesu siꞌitena ꞌituꞌe galewaya, ta pwana solanaya ꞌikwaiya. ");
INSERT INTO dob_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Niꞌatu ꞌipilisinedi, ta ꞌetamo sidunedune galewaya, ga tai ꞌeluwa ma ꞌadi ꞌoama wakewakekedi selabediya sitoolo, ");
INSERT INTO dob_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ga sigwae, “Me Galili ye, toꞌase manuna wadunedune galewaya? Yaubada niꞌatu Yesu nina ꞌiꞌauꞌewena galewaya, ta maꞌetamo ꞌimwaꞌuta limanama, be ꞌina mwaꞌutama ꞌana ꞌita ꞌetamo nadigega ꞌina tuꞌe nina niꞌa waꞌitena.” ");
INSERT INTO dob_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ꞌEnega ꞌoya ꞌana esana Olibe ꞌenega siila ga sitauya Yelusalema, nate nigeya ꞌedasola, nadigega tomota siadadana ꞌasiyata Sabate ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ga silugu ꞌidi anuwaya ga situꞌe anuwa etaninaya, taudi Pita be Yoni be Yemesa be Anidulu be Pilipi be Tomasi be Batolomiu be Madiu be mali Yemesa (tauna Alipio natuna) be Saimoni (tauna lowa togewana ꞌebeloina manuna) be Yudasa (tauna Yemesa natuna). ");
INSERT INTO dob_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Maiboꞌadi getedi ꞌidi ꞌatetagwalega sisidasida Yaubada ꞌena, iine maꞌediyao, be Meli, tauna Yesu sinana, be Yesu tasinao wate maꞌediyao. ");
INSERT INTO dob_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Boda nidi ꞌadi yau nadigega wani analedi be tuweniti, ga ꞌebweu ꞌasiyata ꞌenaya Pita gamwagamwanidiya ꞌitoolo ta ꞌieonedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","“Tasigwao, lowa Debida ꞌina ona Yaluyaluwa Tabuna ꞌiꞌebwaꞌena Yudasa manuna, ta Buki Tabu ꞌena ꞌimiyami. Yudasa nina lowa maꞌedai taetosimana Yesu manuna, ta saꞌi ꞌida ꞌInapwana ꞌisipupuyena ga ꞌiꞌebwayaena Yesu ꞌana talauwalao nimadiya. Ta ꞌebweu wali Buki Tabu solanaya Debida ꞌina ona Yudasa manuna, gete nadigega ꞌigwae, ‘ꞌIna ꞌasa ꞌida wabolebole, be geyaꞌabo ꞌebweu yaita tomota ꞌenaya ꞌida miyami.’ Ta wate ꞌigwae, ‘ꞌAna lopaꞌelu tauna ꞌina paisewa ꞌida ꞌewa.’ ꞌEnega ꞌilobwenena be ona gete ꞌana mwalatoi ꞌaiꞌaila ꞌida apwesa.” Pita ꞌina ona gete nadigega manuna Yudasa niꞌatu ꞌimwawasa. Tauna lowa ꞌina guinuwa toꞌumalina ꞌana maisa ꞌenega bwaꞌa ꞌiegimwanena, ga bwaꞌa nina solanaya ꞌibeꞌu sanamwaꞌuta, ga gamwana ꞌilosabuyena, ta diyana maiboꞌana ꞌiapwesa, ga tetelina me Yelusalema maiboꞌadi sinononaya, ga ꞌenadiyega bwaꞌa nina sieesena “Akelidama,” ta ꞌana mwalatoi “Bwaꞌa lala.” ");
INSERT INTO dob_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ta wate Pita ꞌigwae, “ꞌEnega Yudasa ꞌana lopaꞌelu tada ꞌebese, ta ꞌilobwenena be tai nina lowa maꞌedai tamiyamiyanaya tuta maiboꞌana ");
INSERT INTO dob_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yesu ꞌina bapitaiso Yoni ꞌenega ga ꞌana laba ꞌina tuꞌe galewaya, ꞌina sakowasi maiboꞌana ꞌediya, be tai nina maꞌedai tada simana Yesu ꞌina toololimana manuna.” ");
INSERT INTO dob_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ꞌEnega tai ꞌeluwa ꞌadi esanao sigilagasidi, ꞌebweu Yosepa, tauna sieesena Basaba, tauna wate sieesena Yusito, ta ꞌeluwena tai ꞌana esana Mataya. ");
INSERT INTO dob_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ꞌEnega sisidasida Yaubada ꞌena, sigwae, “ꞌInapwana ye, ꞌoyo tomota maiboꞌama ꞌima nuwanuwa ꞌumwalamwalatonidi, ꞌenega ꞌimu esinuwa tai ꞌeluwa getedi ꞌediyega ꞌueꞌitae ꞌemaya ");
INSERT INTO dob_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","be Yudasa ꞌana lopaꞌelu, be tauna ꞌietoguinuwa be ꞌietosimana Yesu manuna, manuna Yudasa paisewa nina ꞌipilisinena ga ꞌitauya tauna ꞌina senaya.” ");
INSERT INTO dob_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ꞌEnega siulaesinuwa ga Mataya ꞌana esana ꞌinugana, ꞌenega tauna ꞌilugu Yesu ꞌana tosimanao site ilebeni nidi maꞌenao, ga maꞌediya siguinuwa. ");
INSERT INTO dob_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ga muliyega ꞌemasula ꞌana esana Penitikosi ꞌana ꞌasiyata ꞌenaya Yesu ꞌana toemisao maiboꞌadi niꞌatu sideli egogonama, ");
INSERT INTO dob_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ga anuwaya simiyamiya, ta galewega ꞌebweu dudu ꞌatuwa wediliya sinabwana sinonona, ga ꞌidi anuwa solana nigeya sawesawenaya be ꞌebweu wate toꞌase sida nono, ");
INSERT INTO dob_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ta ꞌebweu yage siꞌitena ꞌana ꞌita kaiwe sabesabeluluna nadigega, ga ꞌenega sabelulu nidi debadiya sitowa ꞌebweuna ꞌebweuna. ");
INSERT INTO dob_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ꞌEnega maiboꞌadi Yaluyaluwa Tabuna ꞌiloemaedi, ta sieꞌale ga mali ꞌenana be mali ꞌenana ꞌediyega sionaona, nate Yaluyaluwa Tabuna ꞌina waiwaiyega. ");
INSERT INTO dob_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tuta gote ꞌenaya totapwalolo me Yudia mali esenega be mali esenega niꞌatu simai, ga Yelusalema ꞌena simiyami, ");
INSERT INTO dob_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ga dudu nina sinononaya ta sideli egogonama, manuna maiboꞌadi taudi ꞌenadiyega ꞌebweuna ꞌebweuna ona sinonona, ꞌenega nuwadi ꞌiowana sinabwana, ");
INSERT INTO dob_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ga sigwae, “Mwaꞌadega, taudi toona nidi maiboꞌadi me Galili aga? ");
INSERT INTO dob_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ta mwaꞌadega ga ꞌenega maiboꞌada tauda ꞌenadega sionaona, ");
INSERT INTO dob_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ꞌenana nidi nate Palitia, be Midia, be Elama, be Mesopotemia ꞌana tomiyanao, be Yudia, be Kapadosia, be Ponito, be Esia, be ");
INSERT INTO dob_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Piligia, be Pamipilia, be Itipita, be Libia senanao nidi Sailini solanaya simiyami, be taudi Lomega simai, ꞌaidi me Yudia, ta ꞌaidi nigeya me Yudia ta esi ꞌida tapwalolo ꞌena sitagwaledi maꞌediyao, ");
INSERT INTO dob_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","be wate me Kiliti be me Alebia, ta maiboꞌada tauda ꞌenada dumadumadi be dumadumadi ꞌediyega ꞌidi ꞌawagwae Yaubada ꞌina guinuwao waiwaidi manuna sionaona.” ");
INSERT INTO dob_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ꞌEnega maiboꞌadi ma idi nuwaowana taudimo ꞌediya sigwaegwae, “Toꞌase ꞌalena ga ꞌidi guinuwa gete nadigega?” ");
INSERT INTO dob_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ta saꞌi gosediyao ꞌaidi sigwae, “Nai bwasi waiwaiyega siekabaleya.” ");
INSERT INTO dob_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ta Pita gosenao site ilebeni maꞌenao sitoolo, ga Pita ꞌieꞌale ga ꞌediya ꞌiloguguya, ꞌigwae, “ꞌOmi me Yudia be Yelusalema ꞌana tomiyanao maiboꞌami ꞌigu ona wada nono, be wada nuwasabwalena, ");
INSERT INTO dob_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ꞌaene ꞌima guinuwa gete nigeya bwasi waiwaiyega, manuna maꞌetamo gonagona, nigeya numa ekabaleya ꞌana tuta. ");
INSERT INTO dob_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ta esi yage gete lowa palopita Yoeli ꞌigimi simanena, ꞌiona, ");
INSERT INTO dob_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Yaubada ꞌina simana gete nadigega ꞌigwae, “Maꞌetamo tuta ꞌana ꞌebe losalowa ꞌenaya, yaluyaluwagu yada ꞌetosiwa tomota maiboꞌadi ꞌediya, be natumiyao meꞌolotodi nai mewainedi sida loguguya, be ꞌimi tubuwauyao sida ꞌenomataꞌitaꞌita, ta ꞌimi ꞌinapwanao sida madawala. ");
INSERT INTO dob_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Onaꞌaiꞌaila, tuta gote ꞌena yaluyaluwagu yada siwa ꞌigu toguinuwa meꞌolotodi be mewainedi ꞌediya, be manugu sida loguguya. ");
INSERT INTO dob_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Be ꞌigu guinuwao ꞌebe nuwaowana yada eꞌitaedi galewaya tomota ꞌediya, be wate edeedede bada baleꞌuya, nadigega lala be kaiwe sabelulu be bwawa, ");
INSERT INTO dob_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","be sinala ꞌida guguyoi, be nawalae ꞌana ꞌita ꞌida elala, be muliyega ꞌInapwana ꞌina ꞌasiyata ꞌebe matauta ꞌida apwesa. ");
INSERT INTO dob_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ꞌEnega ꞌabo yaisigedi ꞌInapwana ꞌana esanega sibwabwau ꞌenaya, ꞌida ꞌetoseyedi tuga.” ’ ” ");
INSERT INTO dob_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pita wate ꞌieonedi, ꞌigwae, “Me Isileli ꞌomi ona gete wada nono, Yesu tauna goma Nasaleta manuna. Yesu nina matamiya Yaubada ꞌieꞌitaena ꞌaene tauna ꞌina toguinuwa nina, manuna Yesu ꞌina guinuwa waiwaidi ta ꞌebe nuwaowana, Yaubada ꞌina waiwaiyega ꞌiguinuwedi, ta wamwalamwalatonidi manuna gamwagamwanimiya ꞌiguinuwedi. ");
INSERT INTO dob_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yaubada lowaenei Yesu nina manuna ꞌiloina, ga toꞌase baleꞌuya ꞌida loba Yaubada ꞌigimi mwalatonina, ta ꞌomi wasipupuyena, ga ꞌimi loinega tomota toꞌumalidi kelose ꞌenaya siloemwawasina. ");
INSERT INTO dob_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ta Yaubada mwawasa ꞌina sena mwauna ꞌenega ꞌiꞌetoseyena, ga ꞌigietoolo limena, manuna nigeya sawesawenaya mwawasa ꞌina senaya ꞌimiyaataya. ");
INSERT INTO dob_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Gete manuna lowa Debida Yesu ꞌina ona ꞌigimi simanena, ꞌigwae, ‘ꞌInapwana yaꞌitena mataguya ꞌimiyaataya, ta ꞌataiguya ꞌimiyami, ta ꞌigiewaiwaiyegu be geyaꞌabo yaneeneta. ");
INSERT INTO dob_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ꞌEnega yagwausowala sinabwana ta yatuputupuna, be yanuwayaina ꞌaene geyaꞌabo bwalagu ꞌitoꞌutoꞌumali. ");
INSERT INTO dob_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ꞌAboꞌagu ꞌimu tai esiesinuwagu, ꞌenega geyaꞌabo yaluyaluwagu ꞌusaꞌusaꞌu ataya tomwawasao ꞌidi ꞌasaya, nai bwalagu wate ꞌimwaulu. ");
INSERT INTO dob_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ta esi yawasi boboꞌana ꞌina ꞌeda ꞌueꞌitaena ꞌeguya. ꞌEnega matamuya ꞌuda giegwausowala ataegu.’ ” ");
INSERT INTO dob_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ta Pita wate ꞌigwae, “Tasigwao, ona gete nigeya tubuda Debida manuna, manuna Debida nina tamwalatonina ꞌaene lowaenei ꞌimwawasa ga sisaꞌu ꞌaliꞌaliyena, ta gete tuga ꞌana ꞌaliꞌali nina bada ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ta Debida nina palopita ꞌebweu, ga Yaubada ꞌina onaupaupa waiwaina ꞌenaya ꞌinuwaꞌiꞌisina ꞌaene maꞌetamo Debida tubuna ꞌebweuna Debida nina ꞌina ꞌebeloina ꞌida ꞌewa Yaubada ꞌenega. ");
INSERT INTO dob_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ꞌEnega Toꞌetoseyana nina ꞌina toololimana ꞌigimi mwalatonina, ga ꞌieonena ꞌaene geyaꞌabo tomwawasao yaluyaluwadi ꞌidi ꞌasa ꞌena ꞌimiyamiya ataya, ta wate bwalana geyaꞌabo ꞌimwaumwaulu. ");
INSERT INTO dob_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Gete Yesu nina niꞌatu mwawasega Yaubada ꞌigietoolo limena, ga ꞌaboꞌama maiboꞌama ꞌaꞌitena. ");
INSERT INTO dob_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ꞌEnega Yaubada ꞌigituꞌeyena ga tauna ꞌatainaya ꞌimiyami, ga tauna Yaluyaluwa Tabu nina Yaubada lowa ꞌiona upaupaena, ta gete tuga niꞌatu ꞌiꞌebwaꞌema, ꞌenega guinuwa gete waꞌitaꞌitadi ta wanononodi, tauna ꞌenega simai. ");
INSERT INTO dob_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Manuna Debida nigeya tauna ꞌina tuꞌe galewaya manuna ꞌiona, ta Yesu esi manuna ꞌiona, ꞌigwae, ‘Yaubada niꞌatu ꞌiona ꞌigu ꞌInapwana ꞌena, “ꞌAtaiguya ꞌuda miyatowa ");
INSERT INTO dob_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","be ꞌana laba tuta nina ꞌamu talauwalao yasaꞌu ebusiyedi ꞌaeyo ꞌana ꞌebesaꞌu ꞌena.” ’ ");
INSERT INTO dob_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Gete manuna me Isileli maiboꞌami wada mwalatoni ꞌaiꞌaili ꞌaene Yaubada Yesu niꞌatu ꞌiꞌawa ꞌInapwanaena be tauna Toꞌetoseyana, tauna Yesu nina niꞌatu wagiekelosena.” ");
INSERT INTO dob_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tomota nidi Pita ꞌina ona gete niꞌatu sinonona, ga manuna sinuwanuwa sinabwana, ga Pita magosenao ꞌediya sienaida, sigwae, “Tasimao, niꞌatu ꞌaloegesi. Mwaꞌadega ꞌada guinuwaꞌesa?” ");
INSERT INTO dob_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ꞌEnega Pita ꞌigwae, “ꞌImi guinuwa toꞌumalina ꞌediyega wada nuwaꞌebuni, be maiboꞌami Toꞌetoseyana Yesu ꞌana esanega ꞌada giebapitaisoemi, be ꞌimi toꞌumalinao ꞌida nuwataudi, be wate Yaluyaluwa Tabuna ꞌida ꞌebwaꞌemi. ");
INSERT INTO dob_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Manuna Yaubada ꞌina onaupaupa nina ꞌaene ꞌomi manumi, be natumiyao wate manudi, be taudi ꞌedasolaya simiyami manudi, yaisigedi taudi Yaubada ꞌibwauyedi ꞌena.” ");
INSERT INTO dob_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ta Pita ꞌina ona be ꞌina loguguya yauna wate ꞌediyega ꞌisimana, ga ꞌigwae, “Gosegwao, ꞌepata gete toꞌumalina ꞌenega waꞌetoseyemi.” ");
INSERT INTO dob_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ꞌEnega ꞌasiyata nina ꞌena ꞌaina tomota Pita ꞌina ona sinonona ga sibapitaiso, ta ꞌadi yau nadigega ꞌetoi tausani, ");
INSERT INTO dob_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ga sitagwala ꞌaiꞌailedi tosimanao nidi ꞌidi eꞌitao ꞌediya, ta siegosigosiyana ꞌaiꞌailedi, ta siꞌeꞌai leleleya, ta wate sisidasida Yaubada ꞌena. ");
INSERT INTO dob_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ta maiboꞌadi Yaubada siꞌamayabena, ta tosimanao ꞌidi guinuwao ꞌebe nuwaowana ta edeedede yaudi siguinuwedi. ");
INSERT INTO dob_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ta toemisao nidi siegogonedima, ta ꞌidi gwegweyao sitagwaledi be ꞌaene tomota maiboꞌadi ꞌidi gwegwe. ");
INSERT INTO dob_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Be ꞌeguma ꞌidi ꞌebeloina ꞌasaya simiyami siegimwaneyedi, be yage nidi ꞌadi maisega sieguyaiyedi taudi nigeya ꞌidi gwegwemo ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ꞌEnega ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya ma idi ꞌatetagwala sitapwatapwalolo Anuwa Tabu ꞌenaya, ta taudi ꞌidi anuwaya ma idi gwausowola siꞌeꞌai egogona, ");
INSERT INTO dob_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ta Yaubada situputupu. Ta wate pwalu maiboꞌana toemisao nidi siꞌawa boboꞌanedi. Ga ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya Yaubada ꞌaina tomota wate ꞌiꞌetoꞌetoseyedi, ga toekalesiyao ꞌadi yau ꞌisinasinabwa. ");
INSERT INTO dob_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ga ꞌebweu tuta ꞌasuinuwanuwaya, Pita Yoni maꞌiyana silagalaga Anuwa Tabu ꞌena sabi sidasida, manuna nate sidasida ꞌana tuta. ");
INSERT INTO dob_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ta Anuwa Tabu nina ꞌana ꞌawa sieesena Kausala selabenaya, tolopegoi ꞌebweu ꞌimiyami, tauna ꞌina tuta tubuwa ꞌenega ma ina lopegoi, ꞌenega gosenao ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya simeꞌemeꞌe ꞌawa nina ꞌena be ꞌiesidasida ꞌina mani nai ꞌina gwegwe manudi, Anuwa Tabu ꞌana toluguyao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ga tolopegoi nina Pita be Yoni ꞌiꞌitedi ꞌiabe silulugu, ꞌenega lema manuna ꞌisida ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ꞌEnega Pita be Yoni siduneyena, ga Pita ꞌigwae, “ꞌUdunema.” ");
INSERT INTO dob_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ꞌEnega tolopegoi nina ꞌiduneyedi ma ina emisa ꞌaene toꞌase ꞌiabe siꞌebwaꞌe. ");
INSERT INTO dob_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ta Pita ꞌigwae, “Nigeya ꞌebweu wate ꞌigu manimo, ta oboboma nina ꞌeguya ꞌimiyami yada ꞌebwaꞌeyo. Toꞌetoseyana Yesu, tauna goma Nasaleta, ꞌana esanega yaloineyo be ꞌutoolo be ꞌutatauya.” ");
INSERT INTO dob_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ga nima ꞌatainega ꞌigietoolona, ta ꞌae tubwenao sipaꞌala, ");
INSERT INTO dob_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ga ꞌilosuyaena ta ꞌitoolo, ta ꞌenega ꞌitauya, ga maꞌediya silugu Anuwa Tabu solanaya, ta tai nina ꞌilosuyasuyae ta ꞌituputupu Yaubada ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ꞌEnega boda siꞌitena tolopegoi nina ꞌitautauya ma ina lotuputupu Yaubada ꞌena, ");
INSERT INTO dob_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ga siꞌinanena ꞌaene tolopegoi nina lowa Anuwa Tabu ꞌana ꞌAwa Kausala selabenaya ꞌimiyami ta ꞌiesidasida ꞌana lema manuna, ꞌenega silosuyaedi ta sinuwaowana ꞌina boboꞌana limana manuna. ");
INSERT INTO dob_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Tuta nina tai nina Pita be Yoni ꞌigiyaidi Anuwa Tabu papenaya, tauna sieesena Solomoni ꞌina ꞌaliupa, ga boda nidi ma idi nuwaowana sipili egogona ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ta Pita ꞌiꞌitedi, ꞌenega boda ꞌieonedi, ꞌigwae, “Me Isileli ꞌomi, toꞌase manuna wanuwa owana ta waduneduneyema? Nigeya ꞌaene tauma ꞌima waiwaiyega nai ꞌima bubuna ꞌesasena ꞌenega, tai gete ꞌagieboboꞌanena ga ꞌitautauya, ");
INSERT INTO dob_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ta esi Yaubada ꞌina waiwaiyega, tauna Ebelaamo be Aisake be Yekobe ꞌidi Yaubada, ta tubudao ꞌidi Yaubada, ga niꞌatu Yaubada ꞌina ꞌaliꞌei Yesu ꞌana esana ꞌigituꞌeyena, tauna lowa Pailato nuwanuwana be ꞌiliꞌami, ta ꞌomi waeyaseyaseyena, ga waꞌawa toꞌumaliyena Pailato matanaya. ");
INSERT INTO dob_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Onaꞌaiꞌaila, Yesu tauna tai palupaluna ta ꞌesasena, ta waeꞌidiꞌidiyena, ga tomota ꞌadi toloemwawasa ꞌebweu nuwanuwami, ga manuna Pailato ꞌena wasidena. ");
INSERT INTO dob_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ꞌEnega yawasi boboꞌana ꞌana toꞌebwaya waloemwawasina, ta Yaubada tauna mwawasega ꞌigietoolo limena, ga maiboꞌama ꞌaꞌitena. ");
INSERT INTO dob_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ꞌEnega Yesu ꞌana esanega tai gete niꞌatu ꞌiboboꞌana limana. Tai gete waꞌitena ta wamwalatoninaya, ta Yesu ꞌana esana ꞌiemisena, ꞌenega niꞌatu matamiya ꞌiboboꞌana ꞌaiꞌaila, ta ꞌiewaiwai. ");
INSERT INTO dob_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Tasigwao, yamwalatonimi ꞌaene ꞌimi emwagemwageyega Yesu nina waloemwawasina, nadigega ꞌimi ꞌinapwanao. ");
INSERT INTO dob_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ta wanuwaꞌiꞌisi ꞌaene Yaubada ꞌina palopitao ꞌediyega ꞌigimi simanena ꞌaene Toꞌetoseyana nina ꞌina ꞌelouyao ꞌida lobadi, ꞌenega ona nina ꞌana ꞌaiꞌaila niꞌatu ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ꞌEnega ꞌilobwenemi be wanuwaꞌebuni be ꞌimi loegesiyao ꞌida ꞌewayauledi, be ꞌami lotoona boboꞌana wada loba ꞌInapwana tauna ꞌenega, ");
INSERT INTO dob_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","be wate Toꞌetoseyana nina, tauna ꞌigimi esinuwena, ꞌida etune ꞌemiya, nate Yesu. ");
INSERT INTO dob_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tauna niꞌatu galewaya ꞌitauya, be ꞌida miyami ꞌana laba yage maiboꞌadi ꞌida giepaepaludi, nadigega Yaubada ꞌina palopitao lowaenei sigimi simanena. ");
INSERT INTO dob_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Lowa Mosese wate ꞌionaupaupa, ꞌigwae, ‘Maꞌetamo ꞌida ꞌInapwana Yaubada ꞌemiyega ꞌebweu tai ꞌida gilagasi be ꞌiepalopita manumi, nadigega ꞌaboꞌagu ꞌigilagasigu, be ꞌina simana maiboꞌadi wada nonodi. ");
INSERT INTO dob_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Be ꞌabo yaisigedi palopita nina ꞌina ona siguitoyase Yaubada ꞌida gietoꞌumaliyedi, be ꞌida ꞌewayauledi ꞌina tomotaiyao ꞌediyega.’ ");
INSERT INTO dob_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ta palopitao maiboꞌadi Samuwela ꞌenega ga taudi simuliyena ꞌediya, ꞌidi onaupaupa ꞌediyega sigimi simanena guinuwa nidi gete tuga manudi. ");
INSERT INTO dob_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ta ꞌomi palopitao nidi tubumiyao. Ta wate onaoboboma nina Yaubada tubudai Ebelaamo ꞌiꞌebwaꞌena, ꞌigwae, ‘ꞌOyo ꞌimu susuyega maꞌetamo ꞌebeloinao maiboꞌadi baleꞌuya ꞌidi ꞌebe gwausowala.’ ꞌEnega onaoboboma nina ꞌomi wate manumi. ");
INSERT INTO dob_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ta Yaubada ꞌina ꞌaliꞌei Yesu mwawasega ꞌigietoolo limena, ga ꞌomi me Yudia ꞌemiya ꞌigimi etunenama, be ꞌina oboboma ꞌemiya nate ꞌaene ꞌimi loegesiyao ꞌediyega wada nuwaꞌebuni, ta mali bodao muliyega.” ");
INSERT INTO dob_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ta ꞌetamo tuga sionaona pwalu ꞌediya, ta totaliyao be Anuwa Tabu ꞌana tuilala sinabwana, be wate Sadusiyao simai, ");
INSERT INTO dob_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ma idi gamwasowala manuna Pita be Yoni pwaluyao sieꞌitedi ꞌaene Yesu mwawasega ꞌitoolo limana. ");
INSERT INTO dob_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ꞌEnega sigiyaidi ga deliya sisaꞌu luguyedi be ꞌaene tomwa ꞌiulisi be ꞌidi etala sida guinuwe, manuna niꞌatu ꞌiboi. ");
INSERT INTO dob_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ta saꞌi ꞌidi loguguya pwalu nidi niꞌatu sinonona ga tupwana yaudi siemisa, ꞌenega toemisa maiboꞌadi ꞌoloto ꞌadi sawasawa nadigega paibi tausani. ");
INSERT INTO dob_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tomwa ꞌiulisina, ga ꞌidi toloinao be ꞌidi ꞌinapwanao be loina ꞌana toeꞌitao ");
INSERT INTO dob_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ta wate Anasa, tauna totaliya sinabwana ma ina susuyao be ma ina bodao, nate Kaiyapa be, Yoni be, Alekisana be, Yelusalema ꞌena sideli egogonama. ");
INSERT INTO dob_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ꞌEnega Pita be Yoni gamwagamwanidiya sietoolodi, ga sienaidedi, sigwae, “ꞌImi guinuwa gete yaita ꞌina waiwaiyega, nai yaita ꞌana esanega waguinuwena?” ");
INSERT INTO dob_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ta Pita Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌieonedi, ꞌigwae, “ꞌIma toloinao be ꞌinapwanao ye, ");
INSERT INTO dob_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nai ꞌima etala batuwa ꞌalena manuna tolopegoi ꞌalemena, be ꞌaene mwaꞌadega ꞌagieboboꞌana ꞌesena? ");
INSERT INTO dob_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ꞌEnega nuwanuwama ꞌomi be me Isileli maiboꞌami wada mwalatoni ꞌaene tai gete matamiya ꞌitootoolo ꞌina boboꞌana Yesu Keliso ꞌenega, tauna goma Nasaleta, kelose ꞌena waloemwawasina, ta Yaubada ꞌigietoolo limena. ");
INSERT INTO dob_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu nina ꞌatuwa ꞌola, ta toꞌabi anuwa ꞌomi ꞌola nina waguitoyasena, ta esi niꞌatu ꞌieꞌola nugana ga ꞌola maiboꞌadi ꞌiloinedi. ");
INSERT INTO dob_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ta nigeya ꞌebweu yaita sawesawenaya be ꞌiꞌetoseyeda. Nate namo Yesu. Ta nigeya ꞌebweu wate esana baleꞌuya ꞌimiyami be ꞌenega ꞌetoseyana tada loba.” ");
INSERT INTO dob_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ga toloinao nidi siꞌitena Pita be Yoni ꞌidi ꞌatepatu, ta simwalatonina ꞌaene taudi tuga tomiya ꞌasa, ta ꞌebe sikulu sinabwana ꞌediya nigeya silugulugu, ꞌenega sinuwaowana ta sinuwaꞌiꞌisina ꞌaene lowa Yesu maꞌediya simiyami. ");
INSERT INTO dob_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ta wate tolopegoi nina niꞌatu ꞌiboboꞌana siꞌitena selabediya ꞌitootoolo, ꞌenega nigeya wate ꞌidi ꞌebe onamo. ");
INSERT INTO dob_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ta sietunedi ga siapwesa be ꞌaene taudimo anuwaya sida loina, ꞌenega Pita be Yoni siapwesa, ta toloinao nidi siloina, ");
INSERT INTO dob_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ta sigwae, “Mwaꞌadega tada loinaꞌesa tai ꞌeluwa gete manudi, manuna Yelusalema ꞌana tomiyanao maiboꞌadi simwalamwalatoni ꞌaene weꞌiweꞌiyaya sinabwana niꞌatu siguinuwena, ta nigeya sawesawedaya taeyaseyaseye. ");
INSERT INTO dob_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nate namo tada too be tetela gete tada gielosaꞌu, be geyaꞌabo ꞌiꞌelelewana boda yauyaudi ꞌediya, ꞌenega tada loina paꞌala ꞌediya be geyaꞌabo wate Yesu ꞌana esanega tomota ꞌediya siemwaemwasala.” ");
INSERT INTO dob_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ꞌEnega sibwauyedima, ga silugu limana ꞌediya, ga siloinedi be geyaꞌabo wate Yesu ꞌana esanega sionaona, nai sieꞌieꞌita tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ta Pita be Yoni ꞌidi loina sieꞌisena, sigwae, “Mwaꞌadega ꞌilobwenema be Yaubada matanaya tauna ꞌina ona ꞌena ꞌada ematamatana, nai ꞌomi tuga ꞌimi ona ꞌena ꞌada ematamatana? Gete manuna wada nuwanuwa. ");
INSERT INTO dob_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ta ꞌaboꞌama saꞌi nigeya sawesawemaya be ꞌima ona ꞌilosaꞌu yage nidi ꞌaꞌitedi ta ꞌanonodi manudi.” ");
INSERT INTO dob_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ꞌEnega siꞌena paꞌalidi ga muliyega siliꞌamidi. Manuna nigeya ꞌidi loegesi silobaloba be manuna eꞌisa mwauna sida ꞌebwaꞌedi, ta sana boda maiboꞌadi Yaubada situpuna, ");
INSERT INTO dob_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","manuna tolopegoi nina ꞌana yakwala poti be tupwana, ta niꞌatu sigie boboꞌanena. ꞌEnega toloinao pwalu simatautedi, ga nigeya ꞌebweu toꞌase siguiguinuwe Pita be Yoni ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ꞌEnega Pita be Yoni siapwesa ga gosediyao ꞌediya sitauya, ga totaliyao sinabwadi be ꞌinapwanao ꞌidi ona sisimanedi. ");
INSERT INTO dob_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ta gosediyao sinonona maiboꞌana, ꞌenega Yaubada ꞌena siona leleleya, sigwae, “ꞌIma ꞌInapwana ye, ꞌoyo galewa ta baleꞌu, ola ta yage maiboꞌadi soladiya simiyami ꞌumweluluidi, ");
INSERT INTO dob_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ꞌenega ꞌimu ꞌaliꞌei, nate tubuma Debida, Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌimu ona ꞌisimana apwesena, ꞌigwae, ‘Toꞌase ꞌalena ꞌebeloina yaudi ꞌInapwana sieetalauwale, ta wate sinuwanuwa besobeso? ");
INSERT INTO dob_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ꞌEnega me baleꞌu ꞌidi kiniyao be toloinao sideli egogonama ga sigibubuna sabi losaiya ꞌInapwana be ꞌina Keliso ꞌediya.’ ");
INSERT INTO dob_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Onaꞌaiꞌaila, ꞌasa gete solanaya sideli egogonama sabi losaiya ꞌimu ꞌaliꞌei ꞌesasena ta esiesinuwana, tauna Yesu ꞌenaya, taudi tolosaiyao nidi nate Elodi, be Ponitio Pailato, be me Yudia, be wate taudi nigeya me Yudia, ");
INSERT INTO dob_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ga siguinuwena toꞌase nadigega ꞌoyo ꞌimu nuwena lowa ꞌuloinena be sida guinuwe. ");
INSERT INTO dob_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ꞌInapwana ye, ꞌidi ꞌenapaꞌala ꞌimu toguinuwao ꞌemaya geyaꞌabo ꞌunoonodi, ta esi ꞌuda giewaiwaiyema be ma ima ꞌatepatu ꞌimu ona ꞌada simana apwese. ");
INSERT INTO dob_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ta wate ꞌimu waiwaiyega toleꞌoasao ꞌuda gieboboꞌanedi, be ꞌimu ꞌaliꞌei esiesinuwana, ꞌana esana Yesu, ꞌenega weꞌiweꞌiyayao be edeedede ꞌuda gieapwesedi.” ");
INSERT INTO dob_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ꞌIdi sidasida gete silosalonina, ga anuwa nina ꞌena simiyamiya ꞌiloniu, ga maiboꞌadi Yaluyaluwa Tabuna ꞌina waiwaiyega siꞌatepatu, ga Yaubada ꞌina ona siona apwesena. ");
INSERT INTO dob_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Boda nidi Yesu siemisena, ta ꞌidi nuwanuwa maiboꞌana leleleya, ta nigeya sida egewagewana be sida gwae, “ꞌIgu yage gete, ta ꞌomi nigeya.” Ta esi ꞌidi gwegwe maiboꞌadi sitagwaledi boda maiboꞌadi ꞌidi guinuwa manudi. ");
INSERT INTO dob_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ta wate ꞌInapwana Yesu ꞌana tosimanao nidi siewaiwai wawasae ꞌina toololimana ꞌana simana manuna, ta maiboꞌadi sieobooboboma leleleya. ");
INSERT INTO dob_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ta wate maiboꞌadi ma ꞌadi masula be ma ꞌadi ꞌoama, manuna toesaesao ꞌediyega niꞌatu ꞌidi baleꞌu be ꞌidi anuwao siegimwaneyedi, ");
INSERT INTO dob_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ga ꞌadi maisa maiboꞌana simeꞌedi ga siꞌebwaꞌedi Yesu ꞌana tosimanao ꞌediya, ga taudi sieguyai yaisigedi simiyamwau ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Toesaesa ꞌebweuna ꞌediyega, ꞌana esana Yosepa, ta ꞌana esana auwauna tosimanao nidi siꞌebwaꞌena Banaba, nate ꞌana mwalatoi “Togieꞌatepatu,” tauna goma Saipilosi, ta Libai ꞌina susu ꞌebweu, ");
INSERT INTO dob_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ga tauna ꞌina tanowa ꞌiegimwaneyena, ga manena ꞌimeꞌena ga ꞌiꞌebwaꞌena Yesu ꞌana tosimanao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tai ꞌebweu wate mamwanena ꞌidi tanowa siegimwaneyena, ga manena simeꞌena. Tai nina ꞌana esana Ananayasi ta mwanena Sapaila. ");
INSERT INTO dob_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Siteluwa nidi sitagwala ga ꞌaina mani sikwaiyena, ta ꞌana tupwa namo Ananayasi ꞌimeꞌena tosimanao nidi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ꞌEnega Pita ꞌieonena, ꞌigwae, “Ananayasi, toꞌase manuna Seitani nuwayo ꞌiꞌewena ga tanowa ꞌana maisa tupwana ꞌukwaiyena? Nate ꞌimu kabo Yaluyaluwa Tabuna ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lowa nigeya ꞌuegimwaneye, tanowa nina ꞌoyo ꞌimu ꞌebeloina, ta wate tuta nina ꞌuegimwaneyena, mani nina ꞌoyo ꞌimu ꞌebeloina. Ta toꞌase manuna ꞌatemuya ꞌunuwanuwa ga mani nina manuna ꞌukabo? ꞌImu kabo gete nigeya tomota ꞌemaya, ta esi Yaubada ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pita ꞌina ona gete Ananayasi ꞌinonona ta ꞌibeꞌu ga ꞌimwawasa. ꞌEnega tomota yaudi ale nina sinonona ga simatauta sinabwana. ");
INSERT INTO dob_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ga ꞌaina tubuwau simai ga kokowana kalekoega sinugwena ga siꞌaala apwesena ga sisaꞌu ꞌaliꞌaliyena. ");
INSERT INTO dob_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ta mwanena nigeya ꞌimwalamwalatoni, ꞌenega mulinaya ꞌiluguma anuwaya, ");
INSERT INTO dob_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ta Pita ꞌienaidena, ꞌigwae, “Sapaila, ꞌimi tanowa nina waegimwaneyenaya, ꞌeisa ꞌana maisa waꞌewena? Nadigega mwaneyo ꞌieonemaya, aga?” Ta Sapaila nina ꞌigwae, “O, nadigega.” ");
INSERT INTO dob_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ꞌEnega Pita ꞌigwae, “Mwaꞌadega ga wateluwa watagwala be watoo be ꞌaene ꞌInapwana Yaluyaluwana wakaboe? ꞌUnono, mwaneyo ꞌana tosaꞌu ꞌaliꞌaliyao siluguluguma be ꞌiabe siꞌaala apweseyo wate.” ");
INSERT INTO dob_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ta Sapaila nina ꞌibeꞌu manini Pita ꞌaenaya, ga ꞌimwawasa wate. ꞌEnega tubuwau nidi siluguma, ga siꞌitena niꞌatu ꞌimwawasa, ꞌenega siꞌaala apwesena ga sisaꞌu ꞌaliꞌaliyena, mwanena selabenaya. ");
INSERT INTO dob_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ꞌEnega toekalesiyao maiboꞌadi simatauta sinabwana, ta yaisigedi ale nina sinonona simatauta wate. ");
INSERT INTO dob_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ta boda gamwagamwanidiya Yesu ꞌana tosimanao nidi edeedede be yage ꞌebe nuwaowana yaudi siguinuwedi. Ta maiboꞌadi ꞌidi ꞌebe deliegogona Anuwa Tabu papena, tauna sieesena Solomoni ꞌina ꞌaliupa. ");
INSERT INTO dob_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ta boda yaudi ꞌidi matautega nigeya silugulugu toemisao nidi ꞌediya, ta tomota maiboꞌadi toekalesiyao siꞌamayabedi sinabwana, ");
INSERT INTO dob_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ga yau wawasae siemisa, ta ꞌenega silugu ꞌInapwana ꞌina bodao ꞌediya, meꞌolotodi be wate mewainedi. ");
INSERT INTO dob_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ꞌEnega wate toleꞌoasao siꞌauꞌewedima ma ꞌebeꞌenodi ga sisaꞌudi Pita ꞌina ꞌebe tauyao ꞌediya, be ꞌaene Pita yauyaukwina ꞌenega ꞌida gieboboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wate ꞌasa nidi Yelusalema selabenaya ꞌadi tomiyanao sideli egogonama, ga ꞌidi toleꞌoasao be yaisigedi yaluyaluwa biꞌiyao sigie leꞌoasidiya simeꞌedi ga maiboꞌadi sigie boboꞌanedi. ");
INSERT INTO dob_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ta totaliyao ꞌidi ꞌinapwana sinabwana be Sadusiyao ꞌidi boda maꞌenao sigamwasowala ta sieꞌipiꞌipiyedi, ");
INSERT INTO dob_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ꞌenega sitoolo ga Yesu ꞌana tosimanao nidi sigiyaidi, ga deliya sisaꞌudi. ");
INSERT INTO dob_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ta boiboiya, ꞌInapwana ꞌina anilose ꞌebweuna deli ꞌana ꞌawa ꞌigigegena, ga ꞌiꞌauꞌewa apwesedi, ");
INSERT INTO dob_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ta ꞌieonedi, ꞌigwae, “Watauya Anuwa Tabu ꞌena, be nada watoolo be tomota ꞌediya ona nidi yawasi boboꞌana manuna waloguguya.” ");
INSERT INTO dob_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ꞌEnega anilose ꞌina ona sinononaya ta tomwa ꞌiulisina, ga Anuwa Tabu ꞌena siluguya, ga boda sieꞌitedi. ꞌEnega wate totaliya sinabwana ma ina bodao sideli egogonama, ga me Isileli ꞌidi ꞌinapwanao be ꞌadi toloinao maiboꞌadi sibwauyedima, ga ꞌidi ꞌaliꞌeiyao deliya ꞌaidi sietunedi be ꞌaene Yesu ꞌana tosimanao simeꞌedi, be sida etala matadiya. ");
INSERT INTO dob_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ꞌEnega sitauya ga deli kakaena siꞌitena, ta siilama, ");
INSERT INTO dob_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ga sigwae, “Deli gibogibodana ta paꞌalina ꞌaꞌitena, ta ꞌana tolomataꞌiꞌitao ꞌawa ꞌediya sitootoolo wate, ta tuta nina ꞌawa ꞌagigegena solana kakaena.” ");
INSERT INTO dob_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ta Anuwa Tabu ꞌana toꞌitaꞌiꞌita sinabwana be totaliyao sinabwadi tetela gete sinonona ga siꞌatesaꞌala sinabwana, toꞌase ꞌiabe ꞌiapwesa manuna. ");
INSERT INTO dob_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ꞌEnega ꞌebweu tai ꞌediya ꞌimai ta ꞌieonedi, ꞌigwae, “Tomota nidi deliya wasaꞌusaꞌudiya, niꞌatu Anuwa Tabu solanaya sitootoolo, ta sieꞌieꞌita tomota ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ꞌEnega Anuwa Tabu ꞌana toꞌitaꞌiꞌita ma ina toguinuwao siapwesa, ga tosimanao nidi sigiyaidi ga oonuwega simeꞌedi, manuna simatauta pwalu ꞌediya, ta geya nuwadi be pwalu sigamwasowaledi, ꞌabona nai gulewega siloibwaibwadi. ");
INSERT INTO dob_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ꞌEnega maoonuwadi simeꞌedi ga toloinao nidi matadiya sietoolodi. Ta totaliya sinabwana ꞌienaidedi, ");
INSERT INTO dob_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ꞌigwae, “Lowa ꞌemiya ꞌaloina paꞌala ꞌaene geyaꞌabo Yesu ꞌana esanega waeꞌieꞌita ꞌediya, ta mwaꞌadega ga ꞌenega Yelusalema maiboꞌana solanaya tomota waeꞌieꞌita Yesu manuna, ꞌaene ꞌaboꞌama ꞌima loinega siloemwawasina?” ");
INSERT INTO dob_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ta Pita be tosimanao nidi sigwae, “ꞌIlobwenema be Yaubada ꞌina ona ꞌaematamatane, ta geyaꞌabo tomota ꞌidi ona. ");
INSERT INTO dob_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Onaꞌaiꞌaila, ꞌomi Yesu kaiwe ꞌena watutu epaꞌiyena ga ꞌana laba ꞌimwawasa, ta tubudao ꞌidi Yaubada Yesu ꞌigietoolo limena, ");
INSERT INTO dob_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ga ꞌigilagasina tauna ꞌatainaya ꞌaene tauna Toꞌetoseyana be Toanugana, be wate tauna togienuwaꞌebuni me Isileli manuda, be ꞌenega ꞌida toꞌumalinao ꞌinuwataudi. ");
INSERT INTO dob_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ꞌEnega ꞌaboꞌama yage getedi manudi ꞌasimasimana, ta Yaluyaluwa Tabuna tosimana wate, tauna Yaubada ꞌiꞌebwaya ꞌina ona ꞌana toematamatanao ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ta toloinao Yesu ꞌana tosimanao ꞌidi ona gete sinonona, ga sigamwasowala ꞌaiꞌaila, ta nuwanuwadi be siloemwawasidi. ");
INSERT INTO dob_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ta ꞌebweuna ꞌediyega, ꞌana esana Gamelieli, tauna Palisi, ta loina ꞌana toeꞌita, ta ma ꞌana ꞌamayaba tomota yaudi ꞌediya, ꞌitoolo ga ꞌiloina be ꞌaene Yesu ꞌana tosimanao nidi siꞌewa apwesedi tuta kukupana namo manuna, ");
INSERT INTO dob_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ꞌenega muliyega toloinao nidi ꞌieonedi, ꞌigwae, “Me Isileli ye, waꞌitaꞌiꞌisimi be geyaꞌabo waloiloina paꞌala tai gotedi manudi. ");
INSERT INTO dob_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wada nuwaꞌiꞌisi tuta lowa Tudasi ꞌiapwesa ꞌaene tauna mali toanugana ꞌebweu, ta tomota ꞌadi yau nadigega powa analedi silugu ꞌina boda ꞌena, ta esi gabemani Tudasi nina siloemwawasina, ga ꞌana tomuliyao siꞌelelewana, ta ꞌidi boda ꞌigumwala. ");
INSERT INTO dob_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Ta Tudasi muliyega, tuta nina tomota maiboꞌadi sisawedi ꞌena, ꞌebweu goma Galili ꞌiapwesa, ꞌana esana Yudasa, ga ꞌaina tomota ꞌilisidima ga simuliyena, ꞌenega tauna wate ꞌiesilae, ta ꞌana tomuliyao siꞌelelewana. ");
INSERT INTO dob_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“ꞌEnega gete tuga yaeonami ꞌaene geyaꞌabo toꞌase waloiloine tai gotedi manudi. ꞌEguma ꞌadi loina nai ꞌidi guinuwa gete tomota ꞌediyega ꞌiapwesama, maꞌetamo sida neneta, ");
INSERT INTO dob_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ta esi ꞌeguma ꞌadi loina Yaubada ꞌenega ꞌiapwesama, nigeya sawesawemiya be waꞌetobodedi, manuna ꞌabo nadigega, Yaubada niꞌatu walosaiyena.” ");
INSERT INTO dob_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ꞌEnega Gamelieli ꞌina loina simuliyena, ga tosimanao wate sibwauyedima ꞌediya, ga sisapidi, ta sigwae, “Geyaꞌabo wate Yesu ꞌana esanega waonaona tomota ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ta siliꞌamidi ga siapwesa, ga sitauya taudi ꞌidi boda ꞌediya ma idi gwausowala, manuna sawesawediya be ꞌelouya nidi silobadi Yesu ꞌana esana manuna. ");
INSERT INTO dob_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ga ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya sieꞌieꞌita ta siloguloguguya Anuwa Tabu solanaya, ta wate tomota ꞌidi anuwao ꞌediya, ꞌaene Yesu tauna Toꞌetoseyana nina. ");
INSERT INTO dob_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tuta gote ꞌena Yesu ꞌana toemisao ꞌidi boda ꞌisinasinabwa, ga ꞌediyega toꞌena Gilisi ꞌidi bodao toꞌena Yudiao silomugiyedi, manuna ꞌasiyata ꞌebweuna ꞌebweuna, ꞌabo tuta nina masula sieguyaiyedi kwabulao ꞌediya, taudi toꞌena Gilisi ꞌidi kwabulao ꞌadi masula nigeya sawesawediya, ꞌenega sibotabotana. ");
INSERT INTO dob_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ꞌEnega Yesu ꞌana tosimanao site tuwelo toemisao maiboꞌadi sibwauyedima, ga sigwae, “Nigeya sawesawenaya Yaubada ꞌina ona ꞌana loguguya ꞌalosaꞌu be ꞌaene masula ꞌaeguyai. ");
INSERT INTO dob_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ꞌEnega ꞌomi ꞌemiyega tai sebeni waesinuwedi, yaisigedi ma ꞌadi ꞌamayaba, ta sinasinapudi, ta wate ꞌabo Yaluyaluwa Tabuna ꞌina waiwai ꞌediya, be paisewa gete masula ꞌana eguyai manuna, ꞌada ꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ta ꞌaboꞌama ꞌada etapewa sidasida manuna, ta wate Yaubada ꞌina ona ꞌana eꞌita manuna.” ");
INSERT INTO dob_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ta boda sigwausowala ꞌidi loina gete manuna, ꞌenega site sebeni siesinuwedi getedi, Sitibeni, tauna ꞌina emisa sinabwana Yesu ꞌena, ta Yaluyaluwa Tabuna ꞌina waiwai ꞌena, be Pilipi be Pilokolo be Nikano be Timoni be Pamena be wate Nikola, tauna goma Anitioki ta niꞌatu me Yudia ꞌidi tapwalolo ꞌena ꞌilugu. ");
INSERT INTO dob_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ꞌEnega tai getedi sigilagasidi Yesu ꞌana tosimanao matadiya, ta sigidebedi ga manudi sisidasida Yaubada ꞌenaya, ga guinuwa nina sieꞌalidi. ");
INSERT INTO dob_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ꞌEnega Yaubada ꞌina ona ꞌiewaiwai tomota ꞌediya, ga tomuliyao ꞌadi boda ꞌisinabwa wawasae sena Yelusalema ꞌenaya, ta totaliyao yaudi wate ona nina sinonona, ga Yesu siemisena. ");
INSERT INTO dob_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ta Sitibeni nina ma ina waiwai, ta ma ina oboboma sinabwana, ga guinuwa ꞌebe nuwaowana ta weꞌiweꞌiyayao ꞌiguinuwedi tomota gamwagamwanidiya. ");
INSERT INTO dob_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ta ꞌaina tomota simai ga Sitibeni maꞌediya siegewagewana, taudi ꞌaina me Yudia ꞌidi tapwalolo sieesena “Liꞌaliꞌamina,” ta ꞌaidi Sailini ꞌenega, ta ꞌaidi Alekisanidela ꞌenega, ta ꞌaidi Silisia be Esia ꞌediyega, ");
INSERT INTO dob_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ta nigeya sawesawenaya siewaiwai, manuna Sitibeni ꞌina ona sinasinapu Yaluyaluwa Tabuna ꞌenega. ");
INSERT INTO dob_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ꞌEnega taudi Sitibeni sisipupuyena ga ꞌaina tomota sieonedi be Sitibeni sida eꞌewa, sigwae, “Sitibeni nina ꞌina ona toꞌumalina ꞌanononaya, nate Mosese be Yaubada ꞌiꞌawa toꞌumaliyedi.” ");
INSERT INTO dob_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ta wate tomota sienuwa saꞌuyedi ga Sitibeni nina sietalauwalena, ꞌenega boda yaudi be ꞌinapwanao be wate loina ꞌana toeꞌitao simai ga sigiyaina, ga siꞌauꞌewena toloinao ꞌidi deliegogona ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ta toeꞌewa kabokabo nidi sibwauyedima, ta taudi sigwae, “Tai gete, tuta yauyauna ꞌediya, Mosese ꞌina loinao be Anuwa Tabu gete wate ꞌisinalidi, ");
INSERT INTO dob_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ta wate ꞌina ona ꞌanononaya ꞌigwae, ‘Yesu tauna goma Nasaleta maꞌetamo Anuwa Tabu gete ꞌida ligeiyaule, be ꞌida guinuwao nidi Mosese ꞌiꞌebwaꞌeda ꞌida saꞌugelasedi, be dumadumadi ꞌisaꞌudi.’ ” ");
INSERT INTO dob_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ta todeliegogona nidi maiboꞌadi Sitibeni maninina siduneyena, ꞌana ꞌita anilose maninina nadigega. ");
INSERT INTO dob_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ꞌEnega totaliya sinabwana Sitibeni ꞌienaidena, ꞌigwae, “Mwaꞌadega ꞌidi eꞌewa manuyo, ona ꞌaiꞌaila aga?” ");
INSERT INTO dob_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ta Sitibeni ꞌigwae, “Tasigwao be tamagwao, ꞌigu ona gete wada nono. Yaubada Toloetana sana lowaenei tubudai Ebelaamo ꞌena ꞌiapwesa, tuta nina Mesopotemia ꞌena ꞌimiyami, ta ꞌetamo nigeya ꞌiꞌasaꞌasa Elana ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ta ꞌigwae, ‘Ebelaamo, ꞌimu ꞌasa be ꞌimu susu gete ꞌupilisinedi be ꞌutatauya mali senaya, sena nina yaeꞌitayo ꞌena.’ ");
INSERT INTO dob_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“ꞌEnega sena Kalidia ꞌipilisinena ga ꞌiloꞌasa Elana ꞌena. Ta Ebelaamo tamana ꞌina mwawasa mulinaya Yaubada ꞌianuganena ga bada ꞌiloꞌasa, sena gete ꞌena tamiyami, ");
INSERT INTO dob_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ta nigeya ꞌebweu wate bwaꞌa ꞌiꞌebwaꞌebwaꞌe Ebelaamo ꞌina ꞌebeloina, ta saꞌi Yaubada ꞌionaupaupa tuga be ꞌaene sena nina tauna Ebelaamo ma ina susuyao ꞌidi baleꞌu sida ꞌewa, ta tuta gote ꞌenaya Ebelaamo nigeya natunamo. ");
INSERT INTO dob_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Ta wate Yaubada ꞌigimi simanena ꞌaene Ebelaamo tubunao sida esugalagala mali boda ꞌidi sena ꞌenaya, be toniꞌasa nidi paisewa mwauna sida ꞌebwaꞌedi, be sida miyamwau yakwala powa analedi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ta saꞌi Yaubada ꞌigwae, ‘Maꞌetamo toniꞌasa nidi loina mwauna yada ꞌebwaꞌedi, be muliyega sena gote ꞌenega ꞌigu boda sida apwesa be sida bwagobwago ꞌeguya sena gete ꞌenaya.’ ");
INSERT INTO dob_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Ta Yaubada ꞌina ona nina ꞌana weꞌiweꞌiyaya ꞌiꞌebwaꞌena Ebelaamo bwalanaya, nate ꞌilodaba. ꞌEnega Ebelaamo Aisake ꞌienatunena, ga ꞌina ꞌasiyata nima ta ꞌetonina ꞌena ꞌilodaba, ga muliyega Aisake Yekobe ꞌienatunena, ga muliyega Yekobe natunao meꞌolotodi tuwelo ꞌienatunedi, ga site tuwelo nidi ꞌaboꞌada tubudao. ");
INSERT INTO dob_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ta ꞌebweuna ꞌediyega ꞌana esana Yosepa, ta tasinao site ilebeni taudi sieꞌipiꞌipiyena ga sigimwaneyena ꞌaina tomota ꞌediya, ga Yosepa nina sitauyena Itipita ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ta Yaubada maꞌiyana, ga ꞌiꞌetoseyena ꞌana mwauyao ꞌediyega, ta wate sinasinapu boboꞌana ꞌiꞌebwaꞌena, ga me Itipita ꞌidi kini Pelo sinasinapu nina ꞌiꞌitalobena, ꞌenega Pelo Yosepa ꞌiemiya tuꞌeyena ga loina ꞌiꞌebwaꞌena sena Itipita maiboꞌana manuna, ta wate kini nina tauna ꞌina anuwa manuna. ");
INSERT INTO dob_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ga muliyega botana sinabwana ꞌiapwesa Itipita maiboꞌana be Kenani ꞌediya, ga miyamwau ꞌaiꞌaila ꞌiapwesa, ta tubudao nidi nigeya ꞌadi masulamo. ");
INSERT INTO dob_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ta Yekobe tetela ꞌinonona ꞌaene masula Itipita ꞌena ꞌimiyami, ga natunao meꞌolotodi ꞌietuneꞌunudi Itipita ꞌenaya, masula manuna. ");
INSERT INTO dob_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ga muliyega wate sitauya limana Itipita ꞌena, ta Yosepa tasinao ꞌediya ꞌiona apwesa, ꞌigwae, ‘ꞌAboꞌagu tasimi Yosepa’, ta Pelo wate ꞌena ꞌisimanedi, ꞌigwae, ‘Tasigwao getedi.’ ");
INSERT INTO dob_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“ꞌEnega Yosepa tamana Yekobe ma ina susuyao ꞌibwauyedima, ꞌadi yau sebeniti paibi, ga Itipita ꞌena simai. ");
INSERT INTO dob_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ga nada Yekobe nina ꞌimwawasa, ta wate tubudao simwawasa, ");
INSERT INTO dob_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ta kokowadi siꞌewa iledima ꞌasa Sekemi ꞌena, ga sisaꞌu ꞌaliꞌaliyedi, ꞌaliꞌali nina lowa Ebelaamo ꞌigimwanena me Sekemi, taudi Emoli natunao, ꞌediyega, ta ꞌaliꞌali nina ꞌana maisa siliba ꞌiꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ta Yosepa ꞌina mwawasa mulinaya Yaubada ꞌina onaupaupa Ebelaamo ꞌenaya niꞌatu ꞌiloselabena, ga me Isileli Itipita solanaya niꞌatu sisusaila wawasae, ");
INSERT INTO dob_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ta kini auwauna ꞌieꞌale ga ꞌiloina paꞌaledi, kini nina Yosepa nigeya ꞌimwalamwalatoni, ");
INSERT INTO dob_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ga ꞌina susuyao ꞌikaboedi manuna tubudao nidi ꞌiloinedi ga natudiyao gidagidalidi siuledi ꞌatamanaya be sida mwawasa. ");
INSERT INTO dob_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ta gwama Mosese ꞌitubuwa tuta gote solanaya, tauna ꞌana ꞌita boboꞌana, ga tamana be sinana ꞌidi anuwaya siꞌitaꞌiꞌita kwaiyena ga nawalae ꞌetoi. ");
INSERT INTO dob_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ta muliyega ꞌidi anuwega sisaꞌu apwesena, ga Pelo natuna mewainena ꞌilobena, ga ꞌiꞌauꞌewena ꞌina anuwaya be ꞌaene tauna natuna, ga ꞌiꞌitaꞌiꞌisina. ");
INSERT INTO dob_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","“ꞌEnega Mosese me Itipita ꞌidi sinasinapu maiboꞌana sieꞌitena, ga ꞌimwalatonidi, ta ꞌina onao be ꞌina guinuwao ꞌediya ꞌiewaiwai wawasae. ");
INSERT INTO dob_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ta tuta nina ꞌana yakwala poti ꞌilobena, Mosese nina nuwanuwana be tasinao me Isileli ꞌiayausidi. ");
INSERT INTO dob_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ꞌEnega ꞌina ayausa nina solanaya goma Itipita ꞌebweuna ꞌilobena goma Isileli ꞌiunu daidaisina, ꞌenega Mosese tasinana ꞌiꞌetoseyena ta goma Itipitana ꞌiloemwawasina. ");
INSERT INTO dob_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ta Mosese ꞌinuwena ꞌaene tasinao nidi niꞌatu simwalatonina ꞌaene tauna nimanega Yaubada ꞌida ꞌetoseyedi, ta saꞌi nigeya simwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Ta mali ꞌasiyata ga Mosese tasinao ꞌeluwa ꞌilobedi sieꞌueꞌupwa, ta nuwanuwana be ꞌigielosaꞌudi ga ꞌigwae, ‘Gosegwao, ꞌomi susu ꞌebweuna, ta mwaꞌadega ga ꞌimi miya wagiegie toꞌumaliye?’ ");
INSERT INTO dob_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ta tolosaiya nidi ꞌebweuna ꞌediyega Mosese ꞌina ona ꞌieꞌisena, ga ꞌigwae, ‘Yaita ꞌoyo ꞌutoo be ꞌuetoloina ꞌemaya? ");
INSERT INTO dob_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Mwaꞌadega? Nuwanuwayo be ꞌuloemwawasigu nadigega boga goma Itipitana ꞌuloemwawasinaya?’ ");
INSERT INTO dob_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Ona gete Mosese ꞌinonona ga ꞌimatauta ta ꞌidena, ga ꞌietoꞌuꞌumala sena Midiani ꞌenaya, ga nada ꞌiai ga natunao meꞌolotodi ꞌeluwa ꞌienatunedi. ");
INSERT INTO dob_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Yakwala poti mulinaya Mosese sena mwatui daitaya, ꞌoya Sainai selabenaya, ꞌiadadana, ga anilose ꞌiapwesa ꞌawe sabelulu ꞌalaꞌalasina ꞌenega, kaiwe mayawana solanega. ");
INSERT INTO dob_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ga Mosese ꞌiꞌitena, ꞌenega nuwana ꞌiowana, ga ꞌinaonao sabi ꞌitana, ta ꞌInapwana ꞌionama, ");
INSERT INTO dob_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ꞌigwae, ‘ꞌAboꞌagu tubumwao, taudi Ebelaamo be Aisake be Yekobe, ꞌidi Yaubada.’ Ta Mosese ꞌina matautega ꞌidededela, ta geya nuwana ꞌida dune. ");
INSERT INTO dob_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“ꞌEnega ꞌInapwana nina ꞌigwae, ‘ꞌAmu ꞌaelawa ꞌugimonidi, manuna sena nina ꞌena ꞌutootoolo nate bwaꞌa etaetabuna, be ꞌigu ona ꞌuda nono. ");
INSERT INTO dob_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ꞌIgu tomotaiyao Itipita solanaya ꞌidi miyamwau yamwalamwalatoni, ta ꞌidi sida nuwaꞌoleꞌole niꞌatu yanonodi, ꞌenega yaebusima sabi ꞌetoseyedi. ꞌEnega ꞌoyo ꞌutoolo be yaetuneyo Itipita ꞌenaya, guinuwa gete manuna.’ ");
INSERT INTO dob_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Onaꞌaiꞌaila, Mosese nina lowa siguitoyasena, sigwae, ‘ꞌOyo sana yaita ga ꞌutoo be ꞌuetoloina ꞌemaya?’ Ta esi tauna Yaubada ꞌiesinuwena be ꞌida loinedi, ta wate ꞌida ꞌetoseyedi, anilose ꞌina lemega, tuta nina mitawaya ꞌiapwesa ꞌena. ");
INSERT INTO dob_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“ꞌEnega Mosese guinuwa ꞌebe nuwaowana ta edeededeyao ꞌiguinuwedi, Itipita ꞌena, be wate Ola Bweyabweyalina, ta sena mwatui daita ꞌediya, tuta nina Itipitega ꞌiꞌewa apwesedima ga ꞌianuganedi sena mwatui daita mitawaya, yakwala poti ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Gete Mosese nina me Isileli ꞌieonedi ꞌigwae, ‘Yaubada maꞌetamo tasimiyao ꞌediyega ꞌebweu palopita ꞌida esinuwe manumi, nadigega lowa ꞌiesinuwegu.’ ");
INSERT INTO dob_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","“Ta wate Mosese nina mitawaya tubudao maiboꞌadi maꞌenao ꞌoya Sainai ꞌena simiyamiya, ta anilose Mosese loina boboꞌana yawasida manuna ꞌiꞌebwaꞌena. ");
INSERT INTO dob_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ta tubudao nidi Mosese ꞌina loina siguitoyasena, ta nuwanuwadi be siila Itipita ꞌena, ");
INSERT INTO dob_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ga Eloni sieonena, sigwae, ‘ꞌIda ꞌebe bwagobwago ꞌububudi be sianuganeda, manuna Mosese tauna lowa Itipitega ꞌianuganedama mwaꞌo nai ꞌitauya.’ ");
INSERT INTO dob_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ꞌEnega ꞌidi ꞌebe bwagobwago tokwalui bulumakau sibubuna, ga ꞌenaya sitaliya, ta manuna sigwausowala sinabwana. ");
INSERT INTO dob_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“ꞌEnega Yaubada ꞌiguitoyasedi be ꞌaene taudimo ꞌidi nuwanuwa sida guinuwe, nate kwadimao galewaya ꞌediya sida bwagobwago, nadigega palopitao ꞌidi buki solanaya Yaubada ꞌina ona ꞌimiyami, ꞌigwae, ‘ꞌOmi me Isileli yakwala poti sena mwatui daitaya wamiyami, yobaiyao waunudi ta nigeya ꞌeguya wada taliyaedi. ");
INSERT INTO dob_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ta saꞌi mali ꞌebe bwagobwago ꞌana esana Moloke ꞌenaya wataliyaedi, ta Moloke nina ꞌina anuwa waꞌaalena maꞌemi, ta wate Lipani ꞌana kwadima ꞌena wabwagobwago, ta wate yage nidi wabubudi ꞌediya wabwagobwago, ꞌenega yada ꞌausepalemi be watatauya Babiloni ꞌetaulunaya.’ ” ");
INSERT INTO dob_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ta Sitibeni wate ꞌigwae, “Tubudao nidi Yaubada ꞌina anuwa siꞌabina ꞌana ꞌita nadigega Yaubada Mosese ꞌieonena be ꞌida ꞌabiꞌese, ꞌigwae, ‘ꞌIgu anuwa ꞌana ꞌebeꞌita gete, be nadigega waꞌabiꞌese.’ ꞌEnega siꞌabina, ga tuta nina sena mwatui daitaya sitautauya, ta Yaubada ꞌina anuwa nina wate siꞌaala dadanena. ");
INSERT INTO dob_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","“Muliyega tubudao Yosuwa maꞌenao anuwa nina simeꞌena, ga tuta nina ꞌenaya tubudao toniꞌasao sipaꞌidi sena gete ꞌenega, manuna Yaubada ꞌilemedi ga siewaiwai ga ꞌidi baleꞌu gete siꞌewena, ga bada simiyana ga ꞌana laba Debida ꞌietoloina ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ta Debida nina manuna Yaubada ꞌigwausowala, tauna tubudai Yekobe ꞌina Yaubada, ta Debida Yaubada ꞌena ꞌisidasida be ꞌabo kapekapeyana ꞌaene Yaubada ꞌina anuwa auwauna ꞌida ꞌabi. ");
INSERT INTO dob_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ta saꞌi Debida natuna Solomoni anuwa nina ꞌiꞌabina. ");
INSERT INTO dob_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ta esi wanuwaꞌiꞌisi ꞌaene Yaubada Toloetana sana geyaꞌabo anuwa nina tomota nimadiyega siꞌabiꞌabi ꞌena ꞌimiyami, manuna palopita ꞌebweuna Yaubada ꞌina ona niꞌatu lowa ꞌisimanena ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Galewa ꞌigu ꞌebemi esaesa, ta baleꞌu ꞌaegu ꞌadi ꞌebesaꞌu. ꞌEnega to anuwa sana sawesawemiya be manugu waꞌabi, be anuwa nina ꞌena yaeyawaiꞌata? ");
INSERT INTO dob_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Manuna yage getedi maiboꞌadi ꞌaboꞌagu yabubudi.’ ");
INSERT INTO dob_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ta Sitibeni ꞌieonedi wate ꞌigwae, “Onaꞌaiꞌaila, ꞌomi debapaꞌala ꞌalemi, ꞌenega Yaubada ꞌina lodaba bwalamimo ꞌenaya, ta nigeya ꞌatemiya nai tenamiya, ꞌenega tuta yauyauna Yaluyaluwa Tabuna ꞌina loina waguiguitoyase, nadigega tubumiyao siguitoyasena. ");
INSERT INTO dob_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Onaꞌaiꞌaila, tubumiyao palopitao maiboꞌadi sibubuna geyogeyoiyedi ga siloemwawasidi, palopitao nidi taudi Topalupaluna ꞌina mai sigimi simanena, ꞌenega ꞌomi wate Topalupaluna nina wasipupuyena ga waloemwawasina. ");
INSERT INTO dob_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ta ꞌomi lowa aniloseyao Yaubada ꞌina loina siꞌebwaꞌemi, ta saꞌi nigeya wada muliyena.” ");
INSERT INTO dob_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sitibeni ꞌina ona gete toloinao sinonona ga sigamwasowala sinabwana, ta siesalaꞌiꞌita ꞌidi gamwasowala manuna. ");
INSERT INTO dob_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ta esi Yaluyaluwa Tabuna Sitibeni ꞌiloemaena, ta galewa ꞌiduneduneyena ga Yaubada ma ina esaesa tuyayalina be Yesu ꞌatainaya ꞌitootoolo, ꞌiꞌitedi, ");
INSERT INTO dob_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ta ꞌigwae, “Waꞌita, galewa ꞌiꞌegegena, ga Tomota Natuna Yaubada ꞌatainaya ꞌitootoolo, yaꞌitena.” ");
INSERT INTO dob_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ta Sitibeni ꞌana talauwalao sibwaubwau toitoila, ga tenadi sigibodedi be ꞌaene Sitibeni ꞌina ona geyaꞌabo sinoono, ta maiboꞌadi sipili, ga sigiyaina, ");
INSERT INTO dob_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ta ꞌasega siula apwesena, ga gulewega siloibweibwena. Ta Sitibeni ꞌana toeꞌewa kabokaboyao ꞌadi ꞌoamao sialolodi be ꞌaene gulewega Sitibeni sida unu. Ta ꞌadi ꞌoamao nidi tubuwau ꞌana esana Saulo ꞌiꞌitaꞌisidi. ");
INSERT INTO dob_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ta tuta nina Sitibeni gulewega siloibwaibwa ta ꞌisidasida, ga ꞌigwae, “ꞌInapwana Yesu, yaluyaluwagu ꞌuꞌewenawa.” ");
INSERT INTO dob_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ga ꞌiꞌaetulasa, ta ꞌibwau, ꞌigwae, “ꞌInapwana, ꞌidi bubuna toꞌumalina gete geyaꞌabo ꞌueꞌieꞌisa ꞌediya.” Ga ꞌina ona gete mulinaya yawasina ꞌigumwala. ");
INSERT INTO dob_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ta Saulo boda nidi ꞌiꞌawa boboꞌanedi, Sitibeni ꞌana loemwawasa manuna. ꞌAsiyata gote ꞌena toekalesiyao sena Yelusalema ꞌena ꞌadi talauwalao sieꞌale be silosaiyedi, ꞌenega siꞌelelewana Yudia be Samelia senanao ꞌediya, ta Yesu ꞌana tosimanao site tuwelo dimo Yelusalema ꞌena simiyami. ");
INSERT INTO dob_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ta ꞌaina tomota, taudi Yaubada ꞌana toꞌamayabao, Sitibeni nina sisaꞌu ꞌaliꞌaliyena ma idi dedoi sinabwana. ");
INSERT INTO dob_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ta Saulo saꞌi toekalesiyao ꞌieꞌediluluyedi ga manudi ꞌilugulugu anuwa ꞌebweuna ꞌebweuna ꞌediya, ta ꞌeguma toekalesiyao meꞌolotodi be mewainedi ꞌilobalobadi, ꞌigiyaidi tuga, be deliya ꞌisaꞌu luguyedi. ");
INSERT INTO dob_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ta toekalesiyao siꞌelelewana, be ꞌabo to sena ꞌena sitautauya, tetela boboꞌana siloguguyaena tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ꞌEnega Pilipi ꞌimwaꞌuta ꞌebweu Samelia ꞌasana ꞌenaya, ga nada Toꞌetoseyana nina tetelina ꞌiloguguyaena ꞌediya, ");
INSERT INTO dob_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ga maiboꞌadi Pilipi ꞌina ona sinonona, ta ꞌina guinuwa waiwaidi siꞌitedi, ");
INSERT INTO dob_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ꞌeguma yaisigedi sileꞌoasa yaluyaluwa biꞌi ꞌediyega ꞌiula apwesedi ma bwaubwaudi, ta wate tokwenoyao be tolopegoiyao ꞌigieboboꞌanedi. ꞌEnega boda nidi sitagwatagwala leleleya Pilipi ꞌina loguguya ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ta ꞌenega ꞌebe gwausowala sinabwana ꞌasa nina ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ta toniꞌasa ꞌebweuna, ꞌana esana Saimoni, tauna Pilipi ꞌina ona ꞌiemisena. Saimoni nina lowa ꞌiꞌobaꞌoba sinabwana ꞌasa nina ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ga me Samelia maiboꞌadi sinuwaowana ꞌina guinuwa waiwaidi manudi, ta Saimoni tauna ꞌana esana sinabwana. ꞌEnega tomota maiboꞌadi, nai ꞌinapwanao, nai gomabesoyao, Saimoni nina siemisena, ta sigwaegwae, “Tauna Saimoni nina toewaiwai sana, Yaubada ꞌenega.” ");
INSERT INTO dob_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ꞌEnega Saimoni ꞌina onao sinonodi, manuna ꞌina ꞌobega ꞌigienuwa owanedi tuta yauyauna ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ta muliyega Pilipi nina ꞌiapwesama ga tetela boboꞌana, Toꞌetoseyana Yesu ꞌana esana be Yaubada ꞌina loina manudi, ꞌiloguguyaedi, ta siemisena, ga sibapitaiso, ꞌoloto be wate iine. ");
INSERT INTO dob_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ta Saimoni wate Yaubada ꞌiemisena, ga ꞌina bapitaiso mulinaya Pilipi maꞌiyana simiyami. Ta Saimoni nina Pilipi ꞌina edeededeyao be ꞌina guinuwa waiwaidi ꞌiꞌitedi, ta ꞌenega ꞌinuwaowana ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ꞌEnega Yesu ꞌana tosimanao taudi Yelusalema ꞌena simiyami, ale sinonona ꞌaene me Samelia niꞌatu sitagwala Yaubada ꞌina ona ꞌenaya, ꞌenega Pita be Yoni sietunedima, ");
INSERT INTO dob_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ga siteluwa nidi simwaꞌuta Samelia ꞌena, ga toemisa auwaudi manudi sisidasida be ꞌaene Yaluyaluwa Tabuna ꞌediya ꞌida lugu, ");
INSERT INTO dob_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","manuna maꞌetamo nigeya ꞌilugulugu ꞌediya. Nate namo ꞌInapwana Yesu ꞌana esanega sibapitaiso. ");
INSERT INTO dob_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ꞌEnega Pita be Yoni nimadi sisaꞌudi ꞌediya ga Yaluyaluwa Tabuna ꞌediya ꞌilugu. ");
INSERT INTO dob_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ta Saimoni guinuwa gete ꞌiꞌitena ꞌaene Yesu ꞌana tosimanao nimadi sisaꞌudi tomota ꞌediya ga Yaluyaluwa Tabuna ꞌediya ꞌilugu, ꞌenega mani ꞌiꞌewena be ꞌaene Pita be Yoni ꞌida ꞌebwaꞌedi, ");
INSERT INTO dob_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ta ꞌigwae, “ꞌImi waiwai nate nuwanuwagu waꞌebwaꞌegu, be ꞌenega ꞌabo nimagu yasaꞌu yaisigedi ꞌediya Yaluyaluwa Tabuna ꞌediya ꞌida lugu.” ");
INSERT INTO dob_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ta Pita Saimoni ꞌibaꞌena, ꞌigwae, “ꞌImu mani maꞌiyayo wada esilae ataya, manuna ꞌaene Yaubada ꞌina oboboma ꞌimu mani ꞌenega ꞌugimwane. ");
INSERT INTO dob_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ꞌOyo nigeya ꞌima boda, ta esi ꞌateyo ꞌibubuna geyogeyoi Yaubada matanaya. ");
INSERT INTO dob_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ꞌEnega ꞌilobweneyo be ꞌimu toꞌumalina gete ꞌenega ꞌunuwaꞌebuni, be ꞌusidasida Yaubada ꞌena, be nai ꞌimu nuwanuwa gete toꞌumalina ꞌida nuwatau, ");
INSERT INTO dob_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","manuna yamwalatonimu ꞌateyo ꞌibaila, eꞌipiꞌipi be bubuna toꞌumalina ꞌediyega.” ");
INSERT INTO dob_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ta Saimoni ꞌigwae, “Wasidasida ꞌInapwana ꞌena be yage nidi toꞌumalidi wasimanediya, geyaꞌabo ꞌeguya simeemai.” ");
INSERT INTO dob_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ꞌEnega Pita be Yoni ꞌidi ꞌInapwana manuna sisimana apwesa, ta ꞌina ona siloguguyaena, ga muliyega siila Yelusalema ꞌenaya, ta ꞌidi tauya solanaya tetela boboꞌana sisimanena Samelia ꞌasanao ꞌebweuna ꞌebweuna ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ta Yaubada ꞌina anilose Pilipi ꞌieonena, “ꞌUtoolo be ꞌasuoleoleya ꞌeda nina Yelusalemega be Gasa ꞌenaya ꞌenega ꞌutatauya.” ꞌEda nina sena mwatui daita ꞌenega ꞌitautauya. ");
INSERT INTO dob_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ꞌEnega Pilipi ꞌitoolo ga ꞌitauya, ga goma Idiopia ina waga lisilisi ꞌenega ꞌitautauya ꞌilobena, tauna tai ꞌewaꞌewana, ta ꞌana esana sinabwana, ta ꞌidi kuwini Kanidesi manuna ꞌiguiguinuwa, nate ꞌina esaesa maiboꞌadi ꞌiꞌitaꞌiꞌisidi, ta tauna niꞌatu ꞌimai Yelusalema sabi tapwalolo, ");
INSERT INTO dob_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ga ꞌina waga lisilisiyega ꞌiilaila ꞌina ꞌasaya, ta waga lisilisi ꞌena ꞌigelu ta Buki Tabu ꞌisawasawa, Palopita Aisea ꞌina ꞌetoladi ꞌisawasawai. ");
INSERT INTO dob_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ꞌEnega Yaluyaluwa Tabuna Pilipi ꞌieonena, “ꞌUlomanini be waga lisilisi ꞌena ꞌutatauya.” ");
INSERT INTO dob_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ꞌEnega Pilipi ꞌipili, ga tai nina ꞌenana ꞌinonona palopita Aisea ꞌina ꞌetoladi ꞌisawasawa. Ta Pilipi ꞌigwae, “Mwaꞌadega, ona nidi ꞌusawasawadi ꞌumwalatonidiya?” ");
INSERT INTO dob_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ta tai nina ꞌigwae, “Nigeya, manuna nigeya wate ꞌigu toeꞌitamo.” ꞌEnega tai nina Pilipi ꞌibwauyenama wagaya, ta Pilipi ꞌigelu ga selabenaya ꞌimiyatowa ga Buki Tabu nina ꞌisawena, ");
INSERT INTO dob_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ta sawa nina niꞌatu ꞌisawena gete nadigega ꞌigwae, “Tauna ꞌatuwa sipi ꞌiabe siunu, nai nadigega lami, ꞌabo unuununa ꞌana toꞌupwa matanaya ꞌitootoolo, nigeya ꞌebweu wate ꞌenana ꞌida ona apwesena. ");
INSERT INTO dob_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ta wate ꞌina etala ꞌena sikaboena, ga ꞌiomayamaya. ꞌEnega natunao tetelidi nigeya ꞌebweu yaita ꞌida simana apwesena, manuna yawasina baleꞌuya niꞌatu ꞌigumwagumwala.” ");
INSERT INTO dob_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ga goma Idiopia nina Pilipi ꞌieonena, “Yaita manuna palopita gete ꞌionaona? tauna manuna? nai mali tai manuna?” ");
INSERT INTO dob_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ꞌEnega Pilipi ꞌieꞌale sawa nina ꞌana liꞌama manuna ga Yesu tetelina ꞌieꞌitaena. ");
INSERT INTO dob_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ga ꞌeda nina sitautauya ga bwasi siꞌita lobena, ta tai nina ꞌigwae, “Gote bwasi! Mwaꞌadega, kapekapeyana be ꞌugie bapitaisoegu, aga?” ");
INSERT INTO dob_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(-) ");
INSERT INTO dob_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ꞌEnega ꞌina toguinuwao ꞌiloinedi ga waga lisilisi sigie losaꞌuna, ga siteluwa Pilipi maꞌiyana sisuya ta siebusi bwasiya, ga Pilipi tai nina ꞌigie bapitaisoena. ");
INSERT INTO dob_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ꞌEnega bwasiyega situꞌema ga Yaubada Yaluyaluwana Pilipi ꞌiꞌauꞌewena, ga tai nina nigeya Pilipi ꞌiꞌitaꞌita lima, ta ma ina gwausowala ꞌitauya ꞌina ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ta Pilipi saꞌi silobena ꞌasa Asota ꞌena, ga ꞌenega ꞌitautauya, ta tetela boboꞌana ꞌiloguloguguya ꞌasa ꞌebweuna ꞌebweuna ꞌediya, ga ꞌana laba ꞌiapwesa Sisalia ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ta Saulo ꞌetamo tuga ꞌInapwana ꞌana tomuliyao ꞌediya ꞌietaetalauwala sinabwana, ꞌenega ꞌitauya totaliya sinabwana ꞌena, ");
INSERT INTO dob_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","nuwanuwana ꞌina letao ꞌida ꞌetoladidi be ꞌida tauyedi me Yudia ꞌidi deliegogonao Damasiko ꞌena ꞌediya, ta leta nidi ꞌediyega ꞌaene ꞌeguma Yesu ꞌina ꞌeda ꞌana tomuliyao ꞌilobadi, meꞌolotodi nai mewainedi, ꞌida giyaidi be ꞌida meꞌedi Yelusalema, sabi etalaedi. ꞌEnega leta nidi ꞌiꞌewedi ga ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ta Saulo ꞌitautauya ga Damasiko ꞌena ꞌiabe ꞌiapwesa, ꞌenega maedana galewega ꞌisaema, ");
INSERT INTO dob_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ga ꞌibeꞌu baleꞌuya, ta ꞌebweu ꞌenana ꞌinonona, ꞌigwaegwae, “Saulo, Saulo, toꞌase manuna ꞌuetalauwalegu?” ");
INSERT INTO dob_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ta Saulo ꞌigwae, “ꞌInapwana yaita sana ꞌoyo?” Ta ꞌenana nina ꞌigwae, “ꞌAboꞌagu Yesu nigu ꞌuetalauwalegu. ");
INSERT INTO dob_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ta esi ꞌutoolo be ꞌululugu ꞌasaya be nada ꞌamu emataluwa ꞌuda nono, be ꞌuda guinuwa.” ");
INSERT INTO dob_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ta tomota nidi Saulo maꞌenao sitautauya nuwadi ꞌiowana, ga sitoolo enono, ta ꞌenana namo sinonona, ta nigeya ꞌebweu yaita siꞌitaꞌita. ");
INSERT INTO dob_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ꞌEnega Saulo baleꞌuyega ꞌitooloma ga nuwanuwana be matana ꞌida ꞌesasa, ta saꞌi nigeya kapekapeyana toꞌase ꞌiꞌita, manuna matana siumauma, ꞌenega Saulo siginimena ga siluguyena Damasiko ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ga nada ꞌasiyata ꞌetoi ꞌediya nigeya toꞌase ꞌida ꞌitena, ta nigeya ꞌida ꞌeꞌai, ta nigeya ꞌida numa. ");
INSERT INTO dob_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ta Damasiko ꞌenaya, Yesu ꞌana tomuliya ꞌebweu ꞌimiyami, ꞌana esana Ananayasi, ta ꞌina ꞌenomataꞌiteꞌitega Yaubada ꞌieonena, ꞌigwae, “Ananayasi.” Ta Ananayasi nina ꞌigwae, “O, ꞌaboꞌagu ꞌInapwana.” ");
INSERT INTO dob_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ꞌEnega Yaubada ꞌigwae, “ꞌUtoolo be ꞌasa gamwanaya ꞌutatauya ꞌeda ꞌana esana Palupaluna ꞌenaya, be Yudasa ꞌina anuwaya ꞌebweu tai ꞌuenaide, tauna goma Tasisi ta ꞌana esana Saulo, ta tuta gete ꞌenaya ꞌisidasida, ");
INSERT INTO dob_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ga ꞌebweu tai ꞌana esana Ananayasi ꞌiꞌitena, ꞌimeemai sabi gitoona, be ꞌenega matana sida ꞌesasa limana.” ");
INSERT INTO dob_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ta Ananayasi nina ꞌigwae, “ꞌInapwana, tai nina tetelina tomota yaudi sieonegu, ꞌaene tai toꞌumalina, ga ꞌimu toemisao Yelusalema ꞌena niꞌatu ꞌietalauwala wawasaedi, ");
INSERT INTO dob_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ta wate totaliyao sinabwadi sitagwalena be gete tuga ꞌimai bada be ꞌamu bodao maiboꞌama sabi yonima, ꞌeguma ꞌamu esanega ꞌasidasidawa.” ");
INSERT INTO dob_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ta ꞌInapwana ꞌieonena, “Tuwa tuga, ꞌuda tauya ꞌena. Manuna Saulo nina niꞌatu yaesinuwena be teteligu ꞌida simana taudi nigeya me Yudia ꞌediya, be toloina sinabwadi matadiya be me Isileli wate ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Be wate yada eꞌitae ꞌina ꞌelouyao sinabwadi ꞌida lobadi, ꞌaboꞌagu ꞌagu simana manuna.” ");
INSERT INTO dob_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ꞌEnega Ananayasi ꞌitoolo ga ꞌitauya, ga Yudasa ꞌina anuwaya ꞌilugu, ga Saulo ꞌigidebena, ta ꞌigwae, “Tasigu Saulo, ꞌInapwana nina Yesu ꞌedaya ꞌiapwesa ꞌemuya, tauna gete ꞌietuneguma matayo ꞌadi gieꞌesasa manuna, be wate ꞌaene Yaluyaluwa Tabunega ꞌiloemaeyo.” ");
INSERT INTO dob_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ꞌEnega Saulo matanega ꞌatuwa bwala sibeꞌu manini ga ꞌiꞌita limana. ꞌEnega ꞌitoolo ga ꞌibapitaiso, ");
INSERT INTO dob_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ta wate masula ꞌiꞌewena ga ꞌiloepaꞌala. ꞌEnega ꞌaina ꞌasiyata ꞌediya Saulo Yesu ꞌana tomuliyao maꞌenao simiyami Damasiko ꞌena. ");
INSERT INTO dob_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ga me Yudia ꞌidi anuwa tapwalolo ꞌediya Saulo nina ꞌiloguloguguya ꞌaene, “Yesu tauna Yaubada natuꞌaiꞌailina.” ");
INSERT INTO dob_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ta ꞌana toenonoyao sinuwaowana sinabwana, ta sigwae, “Na! ꞌIna guguya gete wada nono? Tauna lowa Yesu ꞌana tomuliyao Yelusalema ꞌena ꞌietalauwaledi. Ta wate gete ꞌina mai bada ꞌalena be ꞌaene Yesu ꞌana tomuliyao bada simiyami ꞌida giyaidi, be ꞌida yonidi be ꞌiiledi Yelusalema, totaliya sinabwadi ꞌediya. Ta mwaꞌadega ꞌina nuwaꞌebuni ꞌilobaꞌesena?” ");
INSERT INTO dob_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ta Saulo ꞌina guguya gote ꞌena ꞌiewaiwai wawasae, ga me Yudia nidi Damasiko ꞌena simiyami ꞌieꞌitedi ꞌaene Yesu tauna Toꞌetoseyana nina, ta nigeya wate ꞌidi ꞌebe onamo. ");
INSERT INTO dob_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Saulo Damasiko ꞌena ꞌimiyami, ta me Yudia siloiloina be sida loemwawasi, ");
INSERT INTO dob_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ta Saulo saꞌi ꞌidi loina kwaiya ꞌinonona ꞌaene ꞌasa ꞌana ꞌawao silomataꞌiꞌisidi, be ꞌabo to tuta Saulo ꞌiapweapwesa sida loemwawasi tuga. ");
INSERT INTO dob_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ꞌEnega boiboiya Saulo ꞌana tomuliyao kodo sinabwana ꞌena siusena, ga ꞌasa ꞌana ꞌali etaninega sietabetabeyena ꞌetauluya, ga ꞌitauya. ");
INSERT INTO dob_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ꞌEnega Saulo nina ꞌiila Yelusalema ga ꞌitoo be ꞌilulugu Yesu ꞌana tomuliyao ꞌediya, ta simatautena, manuna nigeya sida emisena ꞌaene niꞌatu ꞌinuwaꞌebuni. ");
INSERT INTO dob_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ta Banaba namo Saulo ꞌilemena, ga ꞌiꞌauꞌewena Yesu ꞌana tosimanao ꞌediya, ga ꞌiemwasala ꞌaene Saulo ꞌedaya ꞌInapwana ꞌilobena ga ꞌenana ꞌinonona, ꞌenega Damasiko ꞌena ma ina ꞌatepatu Yesu manuna ꞌiloguguya. ");
INSERT INTO dob_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ꞌEnega sitagwala Saulo ꞌena ga ꞌilugu ꞌadi boda ꞌena, ta ꞌidi guinuwa maiboꞌana Yelusalema ꞌena tauna maꞌediya simiyami. Ta Saulo nina ma ina ꞌatepatu ꞌiewaiwai ꞌInapwana Yesu ꞌana loguguya manuna. ");
INSERT INTO dob_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ta me Yudia taudi toꞌena Gilisi Saulo maꞌediya sionaona ta siegewagewana, ꞌenega siloiloina be mwaꞌadega sida loemwawasaꞌese. ");
INSERT INTO dob_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ta ꞌidi loina nina toekalesiyao sinonona, ga Saulo sitauyena Sisalia, ga gote ꞌenega sietunena ga ꞌitauya Tasisi. ");
INSERT INTO dob_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Gote ꞌena toekalesiyao me Yudia be me Galili be me Samelia senadiyao ꞌediya simiya gwausowala, ta sipaꞌala, ta ma idi ꞌamayaba ꞌInapwana ꞌena, ta Yaluyaluwa Tabuna ꞌina ꞌitaꞌiꞌita ꞌenega ꞌadi boda ꞌisinabwa. ");
INSERT INTO dob_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ta Pita ꞌisakosakowasi toekalesiyao ꞌediya, ga ꞌimai ꞌebweu ꞌasa ꞌana esana Lida ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ga ꞌebweu tai tokweno ꞌilobena, ꞌana esana Inia, tauna yakwala eita ꞌina ꞌebeꞌeno ꞌena ꞌiꞌenoꞌeno, ta nigeya sawesawenaya ꞌiadadana. ");
INSERT INTO dob_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ꞌEnega Pita ꞌieonena, ꞌigwae, “Inia, Yesu Keliso ꞌida gieboboꞌaneyo, ꞌenega ꞌutoolo be ꞌimu sita ꞌugibubudi.” ꞌEnega ꞌitoolo manini. ");
INSERT INTO dob_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ta tomota nidi Lida be Seloni ꞌadi tomiyanao siꞌitena, ga ꞌenega ꞌInapwana Yesu ꞌena sisanaila. ");
INSERT INTO dob_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ta ꞌasa Yopa ꞌena, Yesu ꞌana tomuliya ꞌebweu waine ꞌimiyami, ꞌana esana Tabita, ta ꞌana gibui Dokasa, ta Dokasa ꞌana gibui yobai ꞌana esana diya, ta waine nina lema be oboboma ꞌalena, ");
INSERT INTO dob_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ta ꞌileꞌoasa ga ꞌimwawasa. ꞌEnega kokowana siꞌewena ga sieꞌesiwena, ga anuwa etanaya solanaya sisaꞌuna. ");
INSERT INTO dob_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ta ꞌasa nina Yopa, Lida ꞌenega nigeya ꞌedasola, ga toekalesiyao sinonona ꞌaene Pita ꞌasa Lida ꞌena ꞌimiyami, ꞌenega tomota ꞌeluwa sietunedi Lida ꞌenaya Pita sabi ꞌauꞌewana, ga Lida ꞌena siapwesa, ga Pita sisidena, sigwae, “ꞌInapwana, ꞌumai be tatauya manini ꞌima ꞌasaya.” ");
INSERT INTO dob_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ꞌEnega Pita ꞌitoolo ga maꞌedi simai Yopa ꞌena. ꞌEnega toekalesiyao Pita siꞌauꞌewena anuwa nina solanaya. Ta kwabulao yaudi Pita sitoolo sakowasiyena ta sidedoi, ta ꞌadi ꞌoamao sieꞌitaena manuna lowa Dokasa tuta mayawasina ꞌadi ꞌoamao nidi ꞌiguinuwedi, ga ꞌiꞌebwaꞌedi, ga sigwae, “ꞌOama getedi tauna Dokasa ꞌana saisailao lowa mayawasinaya maꞌemai ꞌamiyami.” ");
INSERT INTO dob_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ta Pita ꞌiloinedi ga anuwega siapwesa, ta taunamo ꞌimiyami, ta ꞌiꞌaetulasa ta ꞌisidasida Yaubada ꞌena, ꞌenega ꞌisanaila ga kokowa nina ꞌieonena, ꞌigwae, “Tabita ꞌutoolo.” ꞌEnega Tabita matana ꞌiꞌesasena, ga Pita ꞌiꞌitena, ꞌenega ꞌenoꞌenoega ꞌimiyatowa. ");
INSERT INTO dob_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ta Pita nimanaya ꞌigiyaina ga ꞌigietoolona. ꞌEnega kwabulao be toekalesiyao nidi ꞌibwauyedima, ga Tabita mayawasina ꞌieꞌitaena ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ga tetela ꞌiꞌelelewana sena Yopa maiboꞌana ꞌediya, ꞌenega tomota yaudi ꞌInapwana Yesu ꞌena siemisa. ");
INSERT INTO dob_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ta Pita Yopa ꞌena ꞌimiyaꞌamana, tai ꞌana esana Saimoni ꞌina anuwaya, tauna ꞌina paisewa yobai bwaladiyega gwegwe ꞌiguiguinuwedi. ");
INSERT INTO dob_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ta ꞌasa Sisalia ꞌenaya ꞌebweu tai ꞌana esana Konilio ꞌimiyami. Tauna me Loma tolosaiyao ꞌadi yau analedi ꞌidi toanugana, boda Itali ꞌenega, ");
INSERT INTO dob_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ta tauna tai boboꞌana ga ma ina susuyao Yaubada siꞌamayabena, ta tuta yauna togomabeso ꞌilemelemedi ta ꞌisidasida Yaubada ꞌena. ");
INSERT INTO dob_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ta ꞌasiyata ꞌebweu ꞌena ꞌasuinuwanuwaya, Konilio nina ꞌina ꞌenomataꞌitaꞌita ꞌenega Yaubada ꞌina anilose ꞌebweu ꞌimeema ꞌenaya, ga ꞌiꞌita ꞌaiꞌailina, ta anilose nina ꞌigwae, “Konilio!” ");
INSERT INTO dob_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ta Konilio anilose nina ꞌiduneduneyena ga ma ina matauta, ta ꞌigwae, “ꞌInapwana! Toꞌase?” Ta anilose ꞌigwae, “Yaubada ꞌimu sidasida be ꞌimu lema togomabeso ꞌediya ꞌimwalatonina, ga manudi ꞌinuwaꞌiꞌisimu. ");
INSERT INTO dob_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ꞌEnega ꞌimu toguinuwao ꞌaidi ꞌuetunedi be sitatauya Yopa, be Saimoni tauna sieesena Pita siꞌauꞌewenama. ");
INSERT INTO dob_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ta Pita nina ꞌebweu wate Saimoni ꞌina anuwa leꞌawaya ꞌenaya ꞌimiyami, ta Saimoni nina ꞌina paisewa yobai bwaladiyega gwegwe ꞌiguiguinuwedi.” ");
INSERT INTO dob_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anilose nina ꞌina ona ꞌigumwala ga ꞌitauya, ꞌenega Konilio ꞌina toguinuwao ꞌediyega ꞌeluwa ꞌibwauyedi ma ina tolosaiya ꞌebweuna, tauna wate Yaubada ꞌana toꞌamayaba sinabwana. ");
INSERT INTO dob_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ꞌEnega anilose ꞌina simana Konilio ꞌiemwasalina sitetoi nidi ꞌediya, ga ꞌietunedi Yopa ꞌenaya, ga sitauya. ");
INSERT INTO dob_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Mali ꞌasiyataya ꞌasuoleoleya ꞌetamo sitautauya ga ꞌasa Yopa siloselabena, ta Pita anuwaya ꞌimiyami ga ꞌituꞌe etaninaya sabi sidasida. ");
INSERT INTO dob_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ꞌIsidasida ta ma ina botana sinabwana. ꞌEtamo anuwaya masula sigibugibubu ga Pita ꞌiꞌenomataꞌitaꞌita, ");
INSERT INTO dob_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ga galewa ꞌiꞌitena ꞌiꞌegegena ga ꞌebweu yage ꞌiꞌitena ꞌimwaꞌutama, ꞌana ꞌita ꞌatuwa kaleko sinabwana tupitupina ata ꞌediyega sietabe mwaꞌutenama baleꞌuya, ");
INSERT INTO dob_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ta solanaya mali yobai, be mali yobai, be yobai kawakawalidi, be mali manuwa be mali manuwa. ");
INSERT INTO dob_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ꞌEnega ꞌebweu ꞌenana Pita ꞌieonena, ꞌigwae, “Pita, ꞌutoolo be yobai nate ꞌuunudi be ꞌuꞌaꞌa ꞌamu masula.” ");
INSERT INTO dob_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ta Pita ꞌiguitoyasa, ꞌigwae, “ꞌInapwana, tuwa, manuna nigeya ꞌebweu wate yobai ꞌetoꞌetobodana getedi nadigega yada ꞌenidi.” ");
INSERT INTO dob_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ta ꞌenana nina ꞌiona limana, ꞌigwae, “Yaubada yobai natedi niꞌatu ꞌigieꞌesasedi, ꞌenega geyaꞌabo ꞌuꞌawaꞌawa toꞌumaliyedi.” ");
INSERT INTO dob_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yage gete matoi Pita ꞌena ꞌiapwesa, ga ꞌenana nina matoi nadigega ꞌieonena, ga muliyega yage nina ꞌiila galewaya. ");
INSERT INTO dob_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ta Pita ꞌinuwanuwa edaedadama ꞌaene toꞌase ꞌenomataꞌitaꞌita gete niꞌatu ꞌiꞌitena, ta tomota ꞌetoi nidi Konilio ꞌietunedima siapwesa anuwaya, manuna niꞌatu ꞌasaya simai ga Saimoni ꞌina anuwa tomota ꞌediya sienaida. ");
INSERT INTO dob_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ꞌEnega silobena ga anuwa ꞌawanaya sitoolo ta sibwau, “Gosemao, Saimoni nina sieesena Pita, nate anuwaya ꞌimiyami, nai nigeya?” ");
INSERT INTO dob_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ta anuwa nina etaninaya Pita ma ina nuwa edaedadama ꞌimiyami, ta Yaluyaluwa Tabuna ꞌena ꞌigwae, “Pita, tai ꞌetoi siꞌebeꞌebeseyo, ta niꞌatu simai ga ꞌagalauya. ");
INSERT INTO dob_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ꞌEnega ꞌutoolo be ꞌumwaꞌuta ꞌediya be maꞌemwao watatauya, ta geyaꞌabo ꞌuꞌateꞌate saꞌala, manuna ꞌaboꞌagu tomota nidi yaetunedima.” ");
INSERT INTO dob_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ꞌEnega Pita nina ꞌimwaꞌuta ꞌediya ga ꞌigwae, “ꞌAboꞌagu Pita! Toꞌase manuna wamai?” ");
INSERT INTO dob_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ta sigwae, “Konilio ꞌietunema, tauna ꞌima tolosaiyao ꞌadi toanugana, ta tai palupaluna ta Yaubada ꞌana toꞌamayaba, ta wate me Yudia maiboꞌadi siꞌawa tai boboꞌanena, ga ꞌana emataluwa ꞌinonona anilose ꞌenega, be ꞌaene ꞌoyo ꞌibwauyeyo tauna ꞌina anuwaya, be ꞌimu ona ꞌida nono.” ");
INSERT INTO dob_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ꞌEnega Pita tai nidi ꞌibwauyedi, ga anuwa nina ꞌena sieꞌowaga. ꞌEnega tomwa ꞌiulisina ga sitoolo ga Pita maꞌediya sitauya, ta ꞌaidi gosediyao Yopa ꞌenega maꞌediyao wate sitauya. ");
INSERT INTO dob_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Sitautauya ga mali ꞌasiyataya siapwesa Sisaliya. Ta gote ꞌenaya Konilio ꞌina susuyao be gosenao ꞌibwau egogonedimaya, ga ꞌina anuwaya siyamwayamwa. ");
INSERT INTO dob_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ꞌEnega Pita ꞌilogedoma anuwaya ta Konilio ꞌiaapwesa, ga Pita matanaya ꞌibeꞌu sanamwaꞌuta ga ꞌibwagobwago. ");
INSERT INTO dob_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ta Pita Konilio ꞌigietoolona, ta ꞌigwae, “ꞌUtoolo! ꞌAboꞌagu tomotai tuga, nadigega ꞌoyo.” ");
INSERT INTO dob_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ꞌEnega Pita be Konilio maꞌiyana sieonaona, ta silugu anuwaya, ga Pita boda anuwa solanaya ꞌiꞌitedi, ");
INSERT INTO dob_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ga ꞌieonedi, “ꞌOmi ꞌaboꞌama me Yudia ꞌama loina wamwalamwalatoni ꞌaene nigeya sawesawemaya be ꞌomi nigeya me Yudia ꞌayausimi, nai maꞌemao taegosigosiyana, ta saꞌi Yaubada niꞌatu ꞌenomataꞌiteꞌitega ꞌieꞌitegu be geyaꞌabo ꞌebweu tomota yaꞌawaꞌawa toꞌumaliyei. ");
INSERT INTO dob_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ꞌEnega tuta nina Konilio ꞌibwauyeguma, nigeya yaguiguitoyasa, ta esi yatagwalegu ga niꞌatu yamai. Ta toꞌase manuna ꞌubwauyeguma?” ");
INSERT INTO dob_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ꞌEnega Konilio ꞌigwae, “Gete manuna: ꞌAsiyata ata sigumwala ꞌena ꞌasuinuwanuwaya, nadigega gete tuga sidasida ꞌana tuta, ꞌenega ꞌigu anuwaya yasidasida Yaubada ꞌena, ga ꞌebweu tai yaꞌitena mataguya ꞌitootoolo ma ꞌana ꞌoama ꞌesasena. ");
INSERT INTO dob_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ta ꞌieonegu, ‘Konilio, Yaubada ꞌimu sidasida niꞌatu ꞌinonodi, ta wate ꞌimu lema gomabeso ꞌediya ꞌinuwaꞌiꞌisidi. ");
INSERT INTO dob_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ꞌEnega ꞌimu ꞌaliꞌeiyao ꞌuetunedi Yopa ꞌena be Saimoni ꞌubwauyenama, tauna sieesena Pita, ta mali Saimoni ꞌina anuwaya, Yopa ꞌena leꞌawaya, ꞌimiyami, ta mali Saimoni nina ꞌina guinuwa yobai bwaladiyega gwegwe ꞌiguiguinuwedi.’ ");
INSERT INTO dob_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ꞌEnega yalomanini ga ꞌigu ꞌaliꞌeiyao nidi yaetunediwaya ga sibwauyemuma, ta ꞌutagwalemuya ga ꞌumai, ga kagutoki. ꞌEnega gete tuga maiboꞌama Yaubada matanaya ꞌadeli egogonama, be toꞌase ꞌInapwana ꞌiloinemuya ꞌuda eonama, be ꞌada nono.” ");
INSERT INTO dob_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ꞌEnega Pita ꞌieonedi, ꞌigwae, “Onaꞌaiꞌaila! Niꞌatu nuwagu ꞌisabwalena ꞌaene tomota maiboꞌadi Yaubada matanaya leleleya, ta nigeya me Yudia mamo ꞌiobobomema, ");
INSERT INTO dob_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ta esi mali sena be mali sena tomoteninao, ꞌeguma siꞌamayabena be sibubuna palupalu, ꞌigwausowala manudi. ");
INSERT INTO dob_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ta Toꞌetoseyana Yesu, tauna maiboꞌada ꞌida ꞌInapwana, ga Yaubada ꞌina tetela boboꞌana Yesu ꞌiꞌebwaꞌena, ꞌaboꞌama me Isileli ꞌima ꞌebe gwausowala manuna. Ta ꞌomi tetela nina wamwalamwalatoni, ");
INSERT INTO dob_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","manuna Yoni tetela nina ꞌieꞌalena Galili ꞌenega, tuta nina ꞌiloguguya, ga tomota ꞌigiebapitaisoedi ga muliyega Yesu tetelina ꞌiꞌelelewana Yudia senanao maiboꞌadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tetela nina ꞌaene Yaubada Yesu goma Nasaleta ꞌigiewaiwaiyena Yaluyaluwa Tabuna ꞌenega, ga ꞌisakosakowasi ga tomota ꞌilemelemedi, ta ꞌabo yaisigedi Seitani be yaluyaluwa toꞌumalidi sigieleꞌoasidiya, Yesu ꞌigieboboꞌanedi, manuna Yaubada ꞌina waiwai ꞌenaya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ta ꞌaboꞌama saꞌi Yesu ꞌana tosimanao, manuna ꞌina guinuwao ꞌaꞌitediya Yudia senanao maiboꞌadi ꞌediya be wate Yelusalema ꞌenaya, ga ꞌana ꞌebe losalowa kaiwe ꞌena situtu epaꞌiyena ga ꞌimwawasa, ");
INSERT INTO dob_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ta ꞌasiyata ꞌetonina ꞌenaya Yaubada ꞌigietoolo limena, ga ꞌigieapwesena, ");
INSERT INTO dob_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","nigeya tomota maiboꞌadi ꞌediya, nate namo ꞌaboꞌama Yaubada ꞌiesinuwema ꞌana tosimanao, ꞌemaya, ga ꞌina toololimana mulinaya ꞌaꞌeꞌai ta ꞌanumanuma Yesu nina maꞌemai. ");
INSERT INTO dob_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“Ga ꞌiloinema be tomota ꞌediya ꞌaloguguya ꞌaene Yaubada Yesu nina ꞌiesinuwena be ꞌaene tuta ꞌana ꞌebe losalowa ꞌena tauna bwaꞌomatana ꞌida guinuwa, tomota taudi niꞌatu simwawasa manudi, be wate ꞌaboꞌada mayawasida manuda. ");
INSERT INTO dob_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","“Palopitao wate lowaenei sigimi simanena ꞌaene ꞌeguma yaisigedi Yesu ꞌena siemiemisa, ꞌidi loegesiyao Yaubada ꞌida nuwataudi, Yesu tauna ꞌana esanega.” ");
INSERT INTO dob_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ꞌetamo ꞌionaona ga Yaluyaluwa Tabuna ꞌimwaꞌuta taudi sienoenono ꞌediya, ");
INSERT INTO dob_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","ga mali ꞌenana be mali ꞌenana ꞌediyega sionaona, ta Yaubada situputupu, ta me Yudia taudi Yesu ꞌana toemisao nidi, Pita maꞌenao Yopa ꞌenega simaiya, sinuwaowana, manuna siꞌitena Yaubada niꞌatu Yaluyaluwa Tabuna ꞌiꞌebwaya taudi nigeya me Yudia ꞌediya. ꞌEnega Pita ꞌieonedi, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Gosegwao! Waꞌita! Yaluyaluwa Tabuna niꞌatu siꞌewena, nadigega lowa ꞌaboꞌada. ꞌEnega nigeya sawesawenaya ꞌidi bapitaiso bwasiyega taꞌetobode, aga?” ");
INSERT INTO dob_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ꞌEnega Pita nina ꞌiloina be Toꞌetoseyana Yesu ꞌana esanega sida bapitaiso, ga muliyega tomota nidi Pita sisidena be ꞌaina ꞌasiyata wate maꞌediya sida miyami, ga ꞌitagwala. ");
INSERT INTO dob_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ta Yesu ꞌana tosimanao, ta wate toekalesiyao, taudi Yudia ꞌana tomiyanao, niꞌatu tetela sinonona ꞌaene ꞌaidi tomota taudi nigeya me Yudia niꞌatu Yaubada ꞌina ona siemisena. ");
INSERT INTO dob_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ꞌEnega tuta nina Pita ꞌituꞌe limana Yelusalema ꞌenaya, toekalesiyao taudi Mosese ꞌina loina ꞌana tomuliyao, Pita nina silomugiyena, ");
INSERT INTO dob_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","sigwae, “Mwaꞌadega ga ꞌenega ꞌoyo ꞌulugu taudi nigeya me Yudia ꞌidi anuwaya ga maꞌemwao waꞌeꞌai?” ");
INSERT INTO dob_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ꞌEnega Pita ꞌilolagata ga guinuwa gete maiboꞌana ꞌiemwasalina, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Lowa ꞌaboꞌagu Yopa ꞌena yamiyami ta yasidasida Yaubada ꞌena, ga ꞌenomataꞌitaꞌita, ꞌenega ꞌebweu yage yaꞌitena ꞌatuwa kaleko sinabwana ta tupitupinao ata ꞌediyega sietabetabe mwaꞌutenama ꞌeguya. ");
INSERT INTO dob_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Yage nina yaduneduneyena, ga yobaiyao, be yobai bosasa, be mwata, be wate manuwao, kaleko nina solanaya yaꞌitedi, ");
INSERT INTO dob_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ga ꞌebweu ꞌenana yanonona ꞌieonegu, ꞌigwae, ‘Pita, ꞌutoolo be ꞌamu yobai ꞌuunudi be ꞌuꞌaꞌa.’ ");
INSERT INTO dob_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ta ꞌaboꞌagu yagwae, ‘ꞌInapwana, tuwa! Manuna nigeya ꞌebweu wate yage etaetabuna yada ꞌenina.’ ");
INSERT INTO dob_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ta ꞌenana nina galewega ꞌiona limana, ꞌigwae, ‘Yaubada yobai natedi niꞌatu ꞌigieꞌesasedi, ꞌenega geyaꞌabo ꞌuꞌawaꞌawa toꞌumaliyedi.’ ");
INSERT INTO dob_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Yage nina matoi ꞌeguya ꞌiapwesama, ga ꞌenana nina wate matoi ꞌieonegu, ga muliyega maiboꞌana ꞌituꞌe ga ꞌikwaiya galewaya. ");
INSERT INTO dob_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ta gote tuta nina ꞌenaya, tai ꞌetoi siapwesa anuwa nina ꞌena yamiyami, Sisalia ꞌenega simai manugu. ");
INSERT INTO dob_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","“ꞌEnega Yaluyaluwa Tabuna ꞌieonegu, ꞌigwae, ‘ꞌUtoolo be geyaꞌabo ꞌuenuwanaluwa ta tuwa tuga taudi maꞌemwao watatauya.’ Ta gosedao site sikisi gete siꞌoayabugu, ga ꞌatauya Konilio ꞌina anuwaya, ga ꞌalugu. ");
INSERT INTO dob_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","“Ta tai nina ꞌemaya ꞌiemwasala ꞌigwae, ‘Lowa ꞌebweu anilose yaꞌitena ꞌigu anuwa solanaya ꞌitootoolo, ta ꞌigwae, “Konilio, ꞌimu ꞌaliꞌeiyao ꞌuetunedi Yopa ꞌena, be Saimoni, tauna sieesena Pita, sida ꞌauꞌewenama, ");
INSERT INTO dob_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","be tauna tetela ꞌida eonami, be ꞌenega ꞌomi ma imu susuyao ꞌetoseyana wada loba.” ’ ");
INSERT INTO dob_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“ꞌEnega yalolagata ga yaonaona, ta Yaluyaluwa Tabuna ꞌediya ꞌimwaꞌutama, nadigega lowa ꞌaboꞌada ꞌedaya ꞌigimi mwaꞌutama. ");
INSERT INTO dob_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","“ꞌEnega ꞌInapwana ꞌina ona lowa yanuwaꞌiꞌisina, ꞌigwae, ‘Yoni tomota bwasiyega ꞌigiebapitaisoedi, ta ꞌomi maꞌetamo Yaluyaluwa Tabuna ꞌenega wada bapitaiso.’ ");
INSERT INTO dob_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Yaubada ꞌina ꞌebwaya nina ꞌediya nadigega ꞌaboꞌada ꞌedaya, tuta nina tagimi emisa ꞌInapwana Yesu Keliso ꞌenaya. ꞌEnega ꞌaboꞌagu nigeya sawesaweguya Yaubada ꞌina guinuwa gete yaꞌetobode.” ");
INSERT INTO dob_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pita ꞌina ona gete sinononaya, ta nigeya ꞌidi ꞌebe onamo, ga Yaubada situpuna, sigwae, “Onaꞌaiꞌaila, Yaubada niꞌatu ꞌitagwatagwala taudi nigeya me Yudia ꞌediya, be ꞌidi nuwaꞌebuniyega yawasi ataya sida loba.” ");
INSERT INTO dob_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lowa toekalesiyao ꞌadi talauwalao Sitibeni siloemwawasina, ta wate sitoo be toekalesiyao maiboꞌadi sida mutudi, ꞌenega toekalesiyao nidi sidena mali ꞌasa be mali ꞌasa ꞌediya, ga ꞌaidi siapwesa Pinisia be Saipilosi be Anitioki ꞌediya, ga tetela boboꞌana sisimanena me Yudia dimo ꞌediya, ta nigeya ꞌasa nidi ꞌadi tomiyanao maiboꞌadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ta muliyega ꞌaidi toekalesiyao, taudi me Saipilosi be me Sailini, siapwesa Anitioki ꞌenaya, ga ꞌInapwana Yesu tetelina siguguyaena me Yudia, be taudi nigeya me Yudia wate, ꞌediya, ");
INSERT INTO dob_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ta ꞌInapwana ꞌigiewaiwaiyedi, ga tomota yaudi ꞌidi ona siemisena, ga sisanaila ꞌInapwana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Taudi nigeya me Yudia, ta niꞌatu siemisa ꞌInapwana ꞌenaya, ꞌenega tetelidi ꞌiꞌelelewana ga toekalesiyao Yelusalema ꞌena sinonona, ꞌenega Banaba sietunena be ꞌiayausidi. ");
INSERT INTO dob_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ga tuta nina Banaba ꞌimai Anitioki ꞌenaya Yaubada ꞌina oboboma toekalesiyao nidi ꞌediya ꞌiꞌitena, ga ꞌigwausowala sinabwana, ga ꞌiguguyedi be geyaꞌabo sienuenuwanaluwa, ta esi sida toolopaꞌala ma idi emisa ꞌInapwana ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Manuna Banaba nina tai boboꞌana ga Yaluyaluwa Tabuna ꞌiloemaena ta ma ina emisa sinabwana ꞌInapwana ꞌenaya. ꞌEnega ꞌina loguguya ꞌenega tomota yaudi ꞌInapwana siemisena, ga toekalesiyao ꞌidi boda ꞌisinabwa. ");
INSERT INTO dob_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ꞌEnega Banaba ꞌitauya Tasisi, ga Saulo ꞌiꞌebesena, ");
INSERT INTO dob_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ga ꞌilobena, ꞌenega maꞌiyana siila Anitioki ꞌenaya. ꞌEnega yakwala ꞌebweuna solanaya silugulugu toekalesiyao nidi ꞌidi deliegogonao ꞌediya, ta tomota yaudi sieꞌieꞌitadi. ꞌAsa nina Anitioki ꞌenaya Yesu ꞌana tomuliyao tuta nina ꞌena sigimi eesedi Kelisitianiyao. ");
INSERT INTO dob_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tuta gote ꞌenaya ꞌaina palopitao Yelusalemega simwaꞌuta Anitioki ꞌenaya, ");
INSERT INTO dob_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ta ꞌebweuna ꞌediyega, ꞌana esana Agabu, ꞌidi deliegogona ꞌena ꞌitoolo, ga Yaluyaluwa Tabuna ꞌina waiwaiyega ꞌigimi simanena ꞌaene maꞌetamo botana sinabwana ꞌida apwesa sena yauyaudi ꞌediya, ga muliyega Sisa Kalodiu ꞌina tuta etoloina ꞌenaya botana sinabwana ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ta tuta nina Yesu ꞌana tomuliyao Agabu ꞌina simana nina sinonona, taudimo siloiloina be ꞌebweuna ꞌebweuna sida tootoo be sida ꞌebwayadaita be lema mani sida etune gosediyao nidi sena Yudia ꞌena simiyami, ");
INSERT INTO dob_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ꞌenega sigimi ꞌebwayadaita ga mani silobena, ga tuta nina botana ꞌiapwesa, ꞌenega siꞌebwaꞌedi Banaba ta Saulo, ga taudi sitauyena sena Yudia ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tuta gote ꞌenaya Kini Elodi ꞌina loina paꞌala ꞌenega ꞌina tolosaiyao ꞌaina toekalesiyao sigiyaidi sabi gietoꞌumaliyedi. ");
INSERT INTO dob_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ꞌEnega Yemesa, tauna Yoni tasina, Elodi ꞌina loinega siununa sisisaiyega ga ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ta me Yudia sigwausowala Yemesa ꞌina mwawasa manuna. ꞌEnega Elodi ꞌiloina limana be Pita sida giyai. Ta wiki nina nate me Yudia ꞌidi edidigula ꞌana tutaya ta beledi daisina nigeya ꞌana ꞌebe gieseseyamo sieꞌani. ");
INSERT INTO dob_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ꞌEnega Pita sigiyaina ga deliya sisaꞌu luguyena, ta Elodi ꞌina tolosaiyao sikisitini ꞌiloinedi be silomataꞌiꞌita ꞌaiꞌaili, ta Elodi ꞌinuwanuwa ꞌaene Ataona Sagalina mulinaya Pita nina ꞌida saꞌuapwese me Yudia ꞌediya, be ꞌina etala sida guinuwe. ");
INSERT INTO dob_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ꞌEnega deliya siꞌitaꞌiꞌisina ta toekalesiyao saꞌi sisidasida waiwai Yaubada ꞌena, Pita manuna. ");
INSERT INTO dob_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ta Pita ꞌaina ꞌasiyata ꞌediya deliya ꞌimiyami, be mali ꞌasiyata ꞌenaya Elodi Pita ꞌida saꞌuapwese, ta boiboiya Pita tolosaiyao gamwagamwanidiya ꞌiꞌenoꞌeno, ta ꞌana ꞌebeyona seni ꞌeluwa ꞌediyega siyonina, ta wate deli ꞌawanaya tolosaiyao siꞌitaꞌiꞌisina. ");
INSERT INTO dob_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ga Yaubada ꞌina anilose ꞌebweu manini ꞌiapwesa ga deli solana ꞌimaedana, ga anilose nina Pita lesulesuna ꞌisapina, ta ꞌilowanowanona, ga ꞌigwae, “ꞌUtoolo manini,” ga ꞌana ꞌebe yonao nimanega sibeꞌu. ");
INSERT INTO dob_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ga anilose nina ꞌieonena, ꞌigwae, “ꞌAmu ꞌoama ꞌuꞌote be ꞌamu ꞌaelawa ꞌulosipwa,” ga ona nina Pita ꞌiematamatanena. Ta anilose nina wate ꞌigwae, “ꞌAmu talaꞌapwalega ꞌubwabwasa be ꞌumuliyegu,” ");
INSERT INTO dob_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ga ꞌiapwesa ta Pita ꞌimuliyena ta ꞌinuwena ꞌaene ꞌimadamadawala, ta nigeya ꞌimwalamwalatoni ꞌaene anilose nina ꞌina guinuwa yage ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ꞌEnega toꞌitaꞌiꞌita ꞌebweuna sipilisinena, ta ꞌeluwena wate sipilisinena, ga ꞌawa sinabwana kainumuyega siguinuwenaya ꞌena simai, ga ꞌawa nina taunamo ꞌiꞌegegena, ga siapwesa ꞌasaya, ta ꞌeda ꞌenega sitauya, ga manini anilose nina Pita ꞌipilisinena. ");
INSERT INTO dob_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ꞌEnega Pita ꞌinuwa sabwalena, ta ꞌigwae, “Niꞌatu yamwalatoni ꞌaiꞌailina ꞌaene ꞌInapwana ꞌina anilose ꞌietunenama, ga ꞌiꞌetoseyegu Elodi ꞌina loina ꞌenega, be geyaꞌabo me Yudia ꞌidi nuwanuwao sida guiguinuwedi.” ");
INSERT INTO dob_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita niꞌatu nuwana ꞌisabwalena ga ꞌitauya Meli ꞌina anuwaya, tauna Yoni sinana, ta Yoni ꞌana esana ꞌeluwena Maki, ta anuwa nina solanaya tomota yaudi sideli egogonama, ga sisidasida Yaubada ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ꞌEnega Pita anuwa ꞌana ꞌawa ꞌenaya ꞌiꞌaukeke, ta topaisewa mewainena ꞌana esana Loda ꞌimai, ");
INSERT INTO dob_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ta Pita ꞌenana ꞌimwalatonina, ga ꞌigwausowala sinabwana, ga nigeya ꞌawa ꞌigigegigege, ta ꞌiila manini anuwa solanaya ga ꞌigwae, “Pita ꞌawaya ꞌitootoolo.” ");
INSERT INTO dob_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ta sigwae, “Uwauwayo!” Ta waine ꞌawana ꞌipaꞌala ꞌaene tauna Pita nina. ꞌEnega sigwae, “Nai Pita yaluyaluwana.” ");
INSERT INTO dob_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ta Pita ꞌetamo ꞌetauluya ꞌimiyami ta ꞌiꞌauꞌaukeke tuga, ꞌenega ꞌawa sigigegena, ga siꞌitena tauna, ga nuwadi ꞌiowana ꞌaiꞌaila. ");
INSERT INTO dob_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ta Pita nimanega ꞌiꞌetobodedi be sida ꞌalaenono, ta ꞌiemwasala ꞌInapwana deliyega ꞌiꞌauꞌewenama manuna, ꞌenega ꞌigwae, “Tetela gete wasimana Yemesa be gosedao wate ꞌediya.” ꞌEnega ꞌipilisinedi ga ꞌitauya mali esenaya. ");
INSERT INTO dob_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tomwa ꞌiulisina ga tolosaiyao nuwadi ꞌiowana, ta siꞌatesaꞌala sinabwana Pita manuna, mwaꞌadega ꞌiapwesaꞌesa. ");
INSERT INTO dob_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ta Elodi ꞌiloinedi be Pita nina sida ꞌebesei, ta nigeya sida lobena, ꞌenega toꞌitaꞌiꞌitao ꞌidi etala ꞌiguinuwena, ga ꞌadi loemwawasa ꞌiloinena. ꞌEnega Elodi nina Yudia ꞌenega ꞌimwaꞌuta Sisalia, ga nada ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Elodi nina me Taiya be me Saidoni lowa ꞌigamwasowaledi, ꞌenega Elodi ꞌina toꞌitaꞌiꞌita, ꞌana esana Bilasito, sigiegwausowalena, ga muliyega mabodadi simai Elodi ꞌena, ga nuwanuwadi be maꞌenao sida egosigosiyana limana, manuna taudi ꞌadi masula Kini nina ꞌina senega silobaloba. ");
INSERT INTO dob_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ꞌEnega Elodi ꞌebweu ꞌasiyata ꞌiupaena be maꞌenao sida onaona, ga ꞌasiyata nina ꞌena ꞌana ꞌoama esaesa ꞌiꞌotena, ga ꞌina ꞌebemi esaesa ꞌena ꞌimiyatowa, ga boda nidi ꞌediya ꞌiona. ");
INSERT INTO dob_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ta boda nidi sibwaubwau, sigwae, “Gote ꞌebweu Yaubada ꞌina ona, ta nigeya tomota ꞌina ona.” ");
INSERT INTO dob_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tuta gote ꞌena Yaubada ꞌina anilose Elodi ꞌiununa, manuna Yaubada ꞌana tupu ꞌisaꞌubalena tauna ꞌenaya, ga ipwaipwa solana siꞌenina ga ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ta ꞌenega Yaubada ꞌina ona ꞌiewaiwai tomota yauyaudi ta sena maiboꞌadi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ta Banaba be Saulo ꞌidi guinuwa Yelusalema ꞌena silosalonina, ga ꞌenega simwaꞌuta limana Anitioki ꞌena, ta Yoni, tauna ꞌana esana ꞌeluwena Maki, siꞌauꞌewenama maꞌedi. ");
INSERT INTO dob_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ꞌAsa Anitioki ꞌenaya, ekalesiya ꞌidi palopitao be toeꞌitao getedi: Banaba be Simioni (tauna sibwauyena Bwalagai) be Lusiasi (tauna goma Sailini) be Maneeni (tauna kini Elodi ꞌana ꞌepata ꞌebweu) ta Saulo. ");
INSERT INTO dob_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Taudi sitapwatapwalolo ma idi ꞌebotana Yaubada ꞌena ga Yaluyaluwa Tabu ꞌieonedi, ꞌigwae, “Nuwanuwagu Banaba be Saulo ꞌigu guinuwa ꞌebweuna manuna, ꞌenega wada tagwaledi guinuwa nina ꞌena.” ");
INSERT INTO dob_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ꞌEnega Yaubada ꞌena sisidasida limana mabotanidi, ga sigidebedi, ga Banaba be Saulo sietunedi ꞌidi guinuwa nina manuna. ");
INSERT INTO dob_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Yaluyaluwa Tabuna niꞌatu ꞌietunedi ga simwaꞌuta Selusia, ga wagega sigelu ga situpa salu Saipilosi manuna, ");
INSERT INTO dob_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ga ꞌasa ꞌana esana Salami ꞌenaya sisuya, ga nada me Yudia ꞌidi anuwa tapwalolo ꞌena Yaubada ꞌina ona sisimanena. ꞌEbweu ꞌidi ꞌaliꞌei maꞌedi sisakosakowasi, ꞌana esana Yoni. ");
INSERT INTO dob_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ꞌEnega salu nina maiboꞌana sisakowasiyena, ga ꞌasa Pepose ꞌenaya siapwesa, ga nada toꞌoba, ꞌana esana Bayesu, goma Yudia, tauna palopita kabokabo ꞌebweu. ");
INSERT INTO dob_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ta Bayesu nina Sagiu Paulosi maꞌiyana, tauna ꞌasa ꞌana toloina ta tai sinasinapuna, ꞌenega Sagiu Paulosi Banaba be Saulo ꞌibwauyedima, ga nuwanuwana be Yaubada ꞌina ona ꞌida nono, ");
INSERT INTO dob_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ta esi toꞌoba ꞌiꞌetobodedi, manuna geya nuwana be toloina nina Yesu ꞌena ꞌida emisa. Toꞌoba nina ꞌana esana ꞌana gibui Elaimasi, nate tobalau. ");
INSERT INTO dob_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ta Saulo, tauna ꞌana esana ꞌeluwena sibwauyena Paulo, Yaluyaluwa Tabuna ꞌiloemaena ga toꞌoba nina ꞌiduneduneye, ");
INSERT INTO dob_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ta ꞌigwae, “ꞌOyo Seitani ꞌina boda ta kabo ꞌaleyo, ꞌenega guinuwa palupaluna ꞌuetalauwalena, ta ꞌInapwana ꞌina ꞌeda palupaluna tuta maiboꞌana ꞌutootoo be ꞌaene ꞌugiebokoboko. ");
INSERT INTO dob_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ꞌEnega gete tuga ꞌInapwana ꞌina waiwaiyega matayo ꞌida uma tuta kukupana namo manuna, be geyaꞌabo sinala ꞌana maedana ꞌuꞌitaꞌita.” Tuta gote ꞌena umauma ꞌatuwa ꞌenega toꞌoba nina matana ꞌiguguyoi, ga ꞌiꞌebeꞌebesa yaita ꞌida leme be ꞌida anugane. ");
INSERT INTO dob_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ta toloina nina Sagiu Paulo ꞌina guinuwa gete ꞌiꞌitena, ga ꞌInapwana tetelina manuna nuwana ꞌiowana, ꞌenega ꞌiemisena. ");
INSERT INTO dob_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ta Paulo ma ꞌana bodao Peposeyega sigelu ga situpa limana, ga Peliga ꞌena silugu, sena Pamipilia solanaya. Ta Yoni ꞌipilisinedi ga ꞌiila Yelusalema. ");
INSERT INTO dob_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ta boda nidi Peliga sipilisinena ga Anitioki ꞌenaya siapwesa, nate sena Pisidia solanaya. ꞌEnega ꞌasiyata Sabate ꞌena silugu me Yudia ꞌidi anuwa tapwalolo ꞌena, ga simiyatowa. ");
INSERT INTO dob_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ta toanuganao Mosese ꞌina loina ꞌana sawa, be palopitao ꞌidi ona ꞌana sawa sisawedi, ga toanuganao nidi ꞌebweu tai sietunena Paulo be Banaba ꞌediya be ꞌaene ꞌiemataluwedi, ꞌigwae, “ꞌEguma loguguya nai eꞌita ꞌemiya ꞌimiyami wada simana tomota ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ꞌEnega Paulo ꞌitoolo ga nimana ꞌigilagasina, ta ꞌigwae, “Tasigwao me Isileli, be ꞌomi mali esenega Yaubada ꞌana toꞌamayabao, ꞌigu ona gete wada nono. ");
INSERT INTO dob_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yaubada lowaenei me Isileli tubudao ꞌiesinuwedi, ga ꞌidi boda ꞌigiesinabwena ꞌidi esugalagala Itipita solanaya, ga ꞌina waiwai sinabwana ꞌenega ꞌianuganedi ga Itipita sipilisinena. ");
INSERT INTO dob_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ta yakwala poti ꞌediya ꞌidi nenetao ꞌieꞌalamaꞌiꞌitanedi sena mwatui daita mitawaya. ");
INSERT INTO dob_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","“Ga muliyega kini sebeni ma idi bodao ꞌimutudi sena Kenani solanaya, ga sena nina me Isileli ꞌiꞌebwaꞌedi ꞌidi baleꞌu, ga simiyami nadigega yakwala powa analedi ta pipiti ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ga muliyega ꞌidi toloinao ꞌiꞌebwaꞌedi ga siloinedi ꞌana laba palopita nina Samuwela ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“ꞌEnega sisidasida be Yaubada ꞌidi kini ꞌida ꞌebwaꞌedi, ꞌenega Saulo ꞌiꞌebwaꞌedi, tauna Kisi natuna, ta ꞌina susu Beniamina ꞌenega, ga yakwala poti ꞌediya ꞌiloiloinedi. ");
INSERT INTO dob_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Muliyega Yaubada Saulo ꞌieꞌidiꞌidiyena ga ꞌidi kini auwauna Debida ꞌisaꞌuna. Tauna Debida manuna Yaubada ꞌigwae, ‘Desi natuna Debida yalobena, ta yayalena, manuna ꞌigu nuwanuwao ꞌida guinuwedi.’ ");
INSERT INTO dob_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ta Debida nina ꞌina susu ꞌediyega, Yaubada me Isileli ꞌada Toꞌetoseyana Yesu ꞌigieapwesena, nadigega lowaenei ꞌigimi simanena. ");
INSERT INTO dob_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Ta lowa tuta nina Yesu nigeya ꞌiapweapwesama, Yoni ꞌilooguguya me Isileli ꞌediya, be ꞌidi loegesiyao ꞌediyega sida nuwaꞌebuni be ꞌida giebapitaisoedi, ");
INSERT INTO dob_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ta Yoni ꞌina guinuwa ꞌana ꞌebe losalowa ꞌena ꞌigwae, ‘ꞌOmi wanuwena ꞌaene ꞌaboꞌagu yaita? ꞌAboꞌagu nigeya Toꞌetoseyana nina. Ta tauna muliguyega ꞌimeemai, Toloetana sana, ꞌenega ꞌaboꞌagu nigeya ꞌilobwelobwenegu be ꞌana ꞌaelawa yaliꞌamidi.’ ");
INSERT INTO dob_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Tasigwao, ꞌomi Ebelaamo ꞌina susuyao, be wate ꞌomi mali senega Yaubada ꞌana toꞌamayabao, wanono ꞌaene ꞌetoseyana tetelina gete ꞌedaya niꞌatu ꞌimai. ");
INSERT INTO dob_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ta Yelusalema ꞌana tomiyanao, be ꞌidi ꞌinapwanao, Toꞌetoseyana nina nigeya sida mwalatonina, ta wate palopitao ꞌidi simanao Sabate ꞌebweuna ꞌebweuna sisawasawa totapwalolo ꞌediya, ta esiya nigeya simwalamwalatonidi, ga ꞌenega Toꞌetoseyana nina sisipupuyena, ꞌenega palopitao ꞌidi gimisimanao lowaenei ꞌadi ꞌaiꞌaila gete tuga sigieapwesena. ");
INSERT INTO dob_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ta nigeya ꞌebweu wate ꞌina loegesi silobaloba be ꞌenega sida loemwawasi, ta tuwa tuga Pailato sisidena be ꞌida loemwawasi. ");
INSERT INTO dob_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“ꞌEnega ona nidi Buki Tabu ꞌena sigimi simanena Toꞌetoseyana manuna, maiboꞌana gote me Yudia niꞌatu siguinuwedi, ga ꞌina mwawasa mulinaya ꞌana kelose ꞌenega siꞌewa mwaꞌutena ga sisaꞌuna ꞌaliꞌali ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ta Yaubada mwawasega ꞌigietoolona, ");
INSERT INTO dob_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ga ꞌasiyata tupwana yauna ꞌediya ꞌiapweapwesa ꞌana toꞌoayabuyao ꞌediya, taudi lowa maꞌenao Galiliyega ga Yelusalema ꞌenaya simai. Taudi gete tuga Toꞌetoseyana nina manuna sisimasimana tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ta ꞌaboꞌama wate tetela boboꞌana gete ꞌaꞌebwaꞌemi, lowa Yaubada ꞌiona upaupaena tubudao ꞌediya, ");
INSERT INTO dob_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ga niꞌatu ꞌigieapwesena ꞌepata auwauna ꞌaboꞌada ꞌedaya, tuta nina Yesu mwawasega ꞌigietoolona. Gete manuna Same ꞌeluwena ꞌena Yaubada ꞌina ona sigimi simanena, ꞌigwae, ‘ꞌOyo natugu, batuwa ꞌena yaꞌawa natunemu.’ ");
INSERT INTO dob_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Ta wate ꞌigietoolo limena be geyaꞌabo ꞌimwawamwawasa limana, nai ꞌimwaumwaulu, ta gete manuna ꞌigimi simanena, ꞌigwae, ‘Yage nidi boboꞌadi yaona obobomediya Debida ꞌenaya, maꞌetamo yada ꞌebwaꞌeyo.’ ");
INSERT INTO dob_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Ta wate ꞌebweu Same ꞌena ꞌigimi simanena, ꞌigwae, ‘Geyaꞌabo ꞌutagwatagwala be tauna ꞌamu esiesinuwana ꞌimwaumwaulu.’ ");
INSERT INTO dob_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ona getedi nigeya Debida tauna manuna. Debida nina ꞌina tutaya Yaubada ꞌina nuwanuwa ꞌiguinuwedi, ga ꞌikwaiya, ga sisaꞌu ꞌaliꞌaliyena, ga tubunao maꞌediya simwaumwaulu, ");
INSERT INTO dob_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ta saꞌi tai nina mwawasega Yaubada ꞌigietoolona nigeya ꞌimwaumwaulu. ");
INSERT INTO dob_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ꞌEnega, tasigwao, wada mwalatoni ꞌaiꞌaili ꞌaene gete tai nina ꞌenega ꞌimi loegesiyao ꞌadi nuwatau wada loba, ");
INSERT INTO dob_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","be ꞌabo yaita tauna ꞌena ꞌiemisa, ꞌina loegesi ꞌediyega ꞌida liꞌami, ta Mosese ꞌina loina nigeya sawesawenaya ꞌiliꞌamimi. ");
INSERT INTO dob_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","“ꞌEnega wada ꞌitaꞌiꞌisimi be ona nina palopitao lowa manuna sionaona upaupa, geyaꞌabo ꞌomi ꞌilooꞌawasimi. Ona nina ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ꞌOmi totuyeyao, ꞌigu guinuwa gete waꞌita be manuna nuwami ꞌiowana, be muliyega waesilae, manuna ꞌimi tutaya ꞌigu guinuwa nina sida simana ꞌemiya, ta esi nigeya waemiemise.’ ” ");
INSERT INTO dob_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ꞌEnega Paulo be Banaba siapwesa, ta boda nidi sisidedi be mali Sabate ꞌena eꞌita gete ꞌediya sida simana limana. ");
INSERT INTO dob_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ga boda anuwa tapwaloloega sideli apwesa, ta ꞌaidi me Yudia, be ꞌaidi Yaubada ꞌana toemisao mali sena be mali sena ꞌediyega, Paulo be Banaba simuliyedi, ꞌenega Paulo be Banaba ꞌediya siloguguya be ꞌaene Yaubada ꞌina oboboma sida giyaiꞌiꞌisi. ");
INSERT INTO dob_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ꞌEnega mali Sabate ꞌena, ꞌasa nina ꞌana tomiyanao yaudi sideli egogonama Yaubada ꞌina ona sabi nonona. ");
INSERT INTO dob_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ta saꞌi me Yudia, boda sinabwana siꞌitena, ꞌenega sieꞌipiꞌipi, ga Paulo ꞌina loguguya ꞌena sionaila, ta siꞌawa toꞌumaliyena. ");
INSERT INTO dob_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ꞌEnega Paulo be Banaba ma idi ꞌatepatu siona apwesa me Yudia nidi ꞌediya, sigwae, “ꞌIlobwenena be Yaubada ꞌina ona ꞌagimisimana ꞌemiya, ta gete tuga waguitoyasena, nai ꞌomi taumi waloinemi ꞌaene nigeya sawesawemiya be yawasimi ataya wada loba, ꞌenega ꞌaguitoyasemi, be mali bodao ꞌediya ꞌada loguguya, taudi nigeya me Yudia ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","“Manuna ꞌInapwana niꞌatu ꞌiemataluwema, ꞌigwae, ‘ꞌImi guinuwa niꞌatu yaꞌebwaꞌemi be ꞌaene ꞌomi taudi nigeya me Yudia ꞌidi mayale, be sena maiboꞌadi ꞌediya ꞌadi ꞌetoseyana watauye.’ ” ");
INSERT INTO dob_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ꞌEnega taudi nigeya me Yudia Paulo be Banaba ꞌidi ona gete sinonona, ga sigwausowala sinabwana, ga Yaubada tetelina siꞌawa boboꞌanena, ga taudi yaisigedi Yaubada ꞌiesinuwedi be yawasi miyamiya atayana sida loba, taudi ona nina siemisena. ");
INSERT INTO dob_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ta Yaubada tetelina ꞌiꞌelelewana sena nina maiboꞌana solanaya. ");
INSERT INTO dob_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ta saꞌi me Yudia Paulo be Banaba sietalauwaledi, ga silomugiyedi iine ꞌalawatao taudi totapwalolo ꞌediya, be wate ꞌasa ꞌana ꞌinapwanao ꞌediya, ꞌenega taudi wate sietalauwala Paulo be Banaba ꞌediya, ga sipaꞌidi, ta sena nina sipilisinena. ");
INSERT INTO dob_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ta muliyega be sena nina sipilisine, ꞌaedi nedilina siloutuutu yaulena ꞌidi senaya, nate ꞌebeꞌita toniꞌasao ꞌediya, ga ꞌenega sitauya Ikoniami ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ta esi Yaubada ꞌana toemisao sigwausowala sinabwana, ta Yaluyaluwa Tabuna ꞌina waiwai ꞌiloemaedi. ");
INSERT INTO dob_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulo be Banaba siapwesa Ikoniami ꞌena, ga ꞌidi guinuwa Anitioki ꞌena wate nadigega Ikoniami ꞌena siguinuwaꞌesa, nate me Yudia ꞌidi anuwa tapwalolo ꞌena siluguya ga sieꞌita, ta ma idi eꞌita waiwai, ꞌenega boda yaudi siemisedi, boda nidi ꞌaidi me Yudia ta ꞌaidi mali senao ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ta saꞌi ꞌaidi me Yudia eꞌita nina nigeya siemisena, ta sisinalina ga siꞌawa toꞌumaliyena, ga sitauya taudi nigeya me Yudia ꞌediya ga silomugi Paulo be Banaba manudi, ꞌenega taudi wate Paulo be Banaba sietalauwaledi. ");
INSERT INTO dob_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ta tuwa tuga, tuta dudulana Paulo be Banaba simiyana sena nina ꞌena, ta ma idi ꞌatepatu siloguloguguya ꞌInapwana manuna. Ga ꞌInapwana nina ꞌina waiwaiyega guinuwa ꞌebe nuwaowana be edeedede siguinuwedi, ga ꞌediyega ꞌInapwana nina ꞌina oboboma tetelina ꞌana ꞌaiꞌaila tauna ꞌieꞌitaena tomota ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ta saꞌi me Ikoniami nidi siweyala, ga ꞌaidi me Yudia siꞌawa ꞌaiꞌailedi, ta ꞌaidi Yesu ꞌana tosimanao siꞌawa ꞌaiꞌailedi. ");
INSERT INTO dob_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ꞌEnega taudi nigeya me Yudia, be me Yudia wate, be ꞌidi ꞌinapwanao maꞌediyao siloina leleleya be Paulo ta Banaba sida gieꞌelouyaedi, nai gulewega sida loemwawasidi. ");
INSERT INTO dob_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ta esiya alena sinonona ga sidena, ga sitauya Lakeonia ꞌasanao ꞌediya, nate Lisitila be Dabi ꞌediya, ");
INSERT INTO dob_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ga nada tetela boboꞌana sisimana apwesena, ta ꞌasanao selabediya ꞌediya wate. ");
INSERT INTO dob_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisitila ꞌena ꞌebweu tai silobena ꞌina tuta tubuwa ꞌenega ga ꞌietai, ta ꞌimiyamiya namo tuga, ta nigeya ꞌida toolo nai ꞌida adadana, manuna maꞌae lopelopegoina ꞌitubuwa. ");
INSERT INTO dob_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ga tolopegoi nina ꞌimiyatowa, ta Paulo ꞌina loguguya ꞌienoenonoena. ꞌEnega Paulo tolopegoi nina ꞌiduneyena, ga ꞌimwalatonina ꞌaene ma ina emisa Yesu ꞌena, be sawesawenaya ꞌida gieboboꞌane, ");
INSERT INTO dob_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ꞌenega Paulo ꞌenana sinabwana ꞌenega ꞌibwaunao ꞌena, ꞌigwae, “ꞌUtoolo.” Ta tolopegoi nina ꞌitoolo manini ga ꞌiadadana. ");
INSERT INTO dob_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ta tomota maiboꞌadi Paulo ꞌina guinuwa gete siꞌitena, ga ꞌena Lakeoniyega sibwaubwau, “Yaubadao niꞌatu simwaꞌutama, ꞌadi ꞌita ꞌatuwa tomota.” ");
INSERT INTO dob_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ga pwaluyao Banaba sibwauyena Yupita, ta Paulo sibwauyena Mekiuli, manuna tauna ꞌidi toona. Esanao getedi ꞌidi yaubadao ꞌadi esanao, nate Yupita ta Mekiuli. ");
INSERT INTO dob_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ta ꞌidi yaubada Yupita ꞌina totaliya ꞌasa nina ꞌena ꞌimiyami, ta ꞌina Anuwa Taliya ꞌasa ꞌetaulunaya. ꞌEnega totaliya nina ꞌaina bulumakau be kaiwe senina sulasulana ꞌimeꞌedi ꞌasa ꞌana ꞌawa ꞌena, ta nuwanuwana ꞌaene pwalu maꞌenao sida taliya Paulo be Banaba ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ta siteluwa nidi niꞌatu totaliya ꞌina nuwanuwa simwalatonina, ga geyanuwa ꞌaiꞌailidi, ꞌenega ꞌadi ꞌoamao sigisabudi ta sipili apwesa boda ꞌediya, sigwaegwae, ");
INSERT INTO dob_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Gosemao, geyaꞌabo ꞌaboꞌama ꞌemaya watalitaliya. ꞌAboꞌama tomota tuga nadigega ꞌomi, ga tetela boboꞌana gete ꞌameꞌena ꞌemiya, be ꞌaene ꞌimi ꞌebe emisa besobeso wada guitoyasedi be wada sanaila Yaubada mayawasina ꞌena, tauna galewa be baleꞌu be bwagabwaga be wate yage maiboꞌadi soladiya ꞌadi tomweluluwa. ");
INSERT INTO dob_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Yaubada nina lowa sena yauyaudi tomotenidiyao ꞌitagwaledi, be taudimo ꞌidi nuwanuwao, be ꞌidi bubunao sida muliyedi, ");
INSERT INTO dob_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ta saꞌi ꞌebeꞌitao ꞌediya simiyami be ꞌaene ꞌediyega Yaubada nina sida mwalamwalatoni, ta ꞌebeꞌita nidi ꞌina obobomao ꞌediya be ꞌomi ꞌemiya, nate ꞌusana galewega be wate ꞌoelaa boboꞌana, be ꞌediyega sesoi boboꞌadi walobaloba be ꞌenega waꞌeꞌai be manuna wagwaugwausowala.” ");
INSERT INTO dob_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ta Paulo be Banaba tomota nidi siꞌetoboda yogenedi, ta ꞌebe losalowa ꞌena siewaiwai, ga nigeya ꞌediya sitalitaliya. ");
INSERT INTO dob_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ta saꞌi me Yudia Anitioki be Ikoniami ꞌediyega simai, ga silugu boda nidi Paulo ta Banaba ꞌadi toenonoyao soladiya, ga siloꞌae etuetunedi ga Paulo gulewega siloibweibwena, ta ꞌasa solanega silisi apwesena, ta ꞌidi nuwanuwa niꞌatu ꞌimwawasa. ");
INSERT INTO dob_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ga muliyega Yesu ꞌana tomuliyao simai ga Paulo sitoolo sakowasiyena, ta Paulo nina ꞌitoolo, ga ꞌilugu limana ꞌasaya. Ta ꞌenega tomwa ꞌiulisina ga Banaba maꞌiyana sitauya Dabi. ");
INSERT INTO dob_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Dabi ꞌena tetela boboꞌana siloguguyaena, ga tomota yaudi siemisena, ga simuliyena, ꞌenega Paulo be Banaba siila limana Lisitila be Ikoniami be Anitioki ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ta ꞌidi sakowasi nina ꞌena Yesu ꞌana toemisao sigiepaꞌalidi ꞌasa ꞌebweuna ꞌebweuna ꞌediya, ta siloguguyedi be geyaꞌabo ꞌidi emisa ꞌida neeneta, ta sigwae, “Onaꞌaiꞌaila, maꞌetamo ꞌida ꞌelouyao yaudi ꞌediyega talulugu Yaubada ꞌina ꞌebeloina ꞌena.” ");
INSERT INTO dob_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ta wate ꞌasa ꞌebweuna ꞌebweuna ꞌediya Paulo be Banaba toekalesiyao ꞌidi toanuganao siaseyedi, ta ꞌadi gilagata gete nadigega, ꞌebotanega ꞌInapwana nina siemisenaya ꞌena sisidasida, be ꞌida giewaiwaiyedi ꞌidi guinuwa nina manuna. ");
INSERT INTO dob_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ta Pisidia solanega simai ga Pamipili ꞌena siapwesa, ");
INSERT INTO dob_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ga ꞌasa Peliga ꞌena siloguguya, ꞌenega sidolo Atalaya, ");
INSERT INTO dob_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ga wagega sigelu, ga siila Anitioki, sena nina lowa ꞌenega ꞌidi guinuwa nina sieꞌalena, ta ꞌena wate lowa Yaubada ꞌina oboboma silobena, paisewa nina niꞌatu silosalonina manuna. ");
INSERT INTO dob_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ꞌEnega tuta nina Anitioki ꞌena siluguya, toekalesiyao sibwau egogonedima, ga yage yauyauna Yaubada ꞌiguinuwenaya manudi, ꞌidi sakowasi nina solanaya siemwasalidi, nate emisa ꞌana ꞌawa ꞌigigegena taudi nigeya me Yudia manudi, be taudi wate sida lugu. ");
INSERT INTO dob_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ꞌEnega Paulo be Banaba Yesu ꞌana toemisao sena nina Anitioki ꞌena maꞌediyao simiyamiya tuta dudulana. ");
INSERT INTO dob_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ꞌEnega ꞌaidi tomota Yudia ꞌenega siebusima, ga sieꞌieꞌita toekalesiyao me Anitioki ꞌediya, sigwaegwae, “Mosese lowaenei ꞌiloinema bwalama ꞌana daba manuna. ꞌEnega ꞌeguma ꞌomi daba nina nigeya waꞌewaꞌewa, geyaꞌabo ꞌetoseyana walobaloba.” ");
INSERT INTO dob_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ta Paulo be Banaba nigeya siꞌawaꞌawa ꞌaiꞌailedi, ꞌenega maꞌediyao siegewagewana sinabwana. Ga toekalesiyao Anitioki ꞌena Paulo, be Banaba, be ꞌaina wate tomuliyao ꞌediyega, siesinuwedi be ꞌaene sida tuꞌe Yelusalema, be nuwanuwa gete manuna sida onaona, nai sida loina, Yesu ꞌana tosimanao site tuwelo be wate toanuganao maꞌediyao. ");
INSERT INTO dob_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ꞌEnega toekalesiyao silokaiyoniyedi ga sena Pinisia ta Samelia siataonedi, ga ꞌidi sakowasi nina ꞌena ꞌasa apwesa tomoteninao ꞌidi sanaila Yaubada ꞌena sisimanena, ta Yesu ꞌana toemisao ꞌasa ꞌebweuna ꞌebweuna ꞌediya, simana gete sinonona, ga ꞌenega sigwausowala sinabwana. ");
INSERT INTO dob_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ꞌEnega siapwesa Yelusalema, ga toekalesiyao be Yesu ꞌana tosimanao be toanuganao siꞌauꞌewedi ꞌidi anuwaya, ga Paulo be Banaba siemwasala ꞌediya toꞌase be toꞌase ꞌidi paisewa Yaubada ꞌina waiwaiyega siguinuwedi. ");
INSERT INTO dob_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ta ꞌaina Yesu ꞌana toemisao Palisi bodadi ꞌediyega sitoolo, ga sigwae, “ꞌEguma ꞌasa apwesa ꞌadi tomiyanao siemiemisa, ꞌilobwenedi be daba siꞌewa be wate tada loinedi be Mosese ꞌina loinao sida muliyedi bemi, be muliyega siekalesiya ꞌaiꞌaila.” ");
INSERT INTO dob_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ꞌEnega Yesu ꞌana tosimanao site tuwelo nidi be toanuganao deliegogona siguinuwena, ga nuwanuwa gete manuna sionaona. ");
INSERT INTO dob_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ga tupwana siegewagewana ꞌamana, ꞌenega Pita ꞌitoolo ga ꞌigwae, “Tasigwao, wamwalamwalatoni ꞌaene tuta lowa Yaubada ꞌedega ꞌaboꞌagu ꞌiesinuwegu, ga ꞌawaguyega taudi nigeya me Yudia tetela boboꞌana sinonona, ga siemisena. ");
INSERT INTO dob_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ta Yaubada toꞌase ꞌatedaya simiyami ꞌimwalamwalatoni, ga taudi nigeya me Yudia ꞌediya ꞌitagwala, ga Yaluyaluwa Tabuna ꞌiꞌebwaꞌedi, nadigega ꞌaboꞌada ꞌiꞌebwayaꞌeseda, ");
INSERT INTO dob_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ta nigeya ꞌebweu wate weyala ꞌigieapwesena, be ꞌaene taudi dumadumadi be ꞌaboꞌada dumadumada, ta taudi siemisena nadigega ꞌaboꞌada taemisena, ga ꞌenega maiboꞌada ꞌateda ꞌigieꞌesasedi. ");
INSERT INTO dob_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“ꞌEnega geyaꞌabo Yesu ꞌana toemisa auwaudi sena apwesa ꞌediyega ꞌadi ꞌaaꞌaala mwauna waꞌebwaꞌebwaꞌedi, ꞌabona nai Yaubada wagiegamwasowale, manuna ꞌaaꞌaala nina tubudao nigeya sawesawediya be siꞌaali, ta ꞌaboꞌada wate nigeya sawesawedaya. ");
INSERT INTO dob_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ta saꞌi ꞌida emisa ꞌaene ꞌInapwana Yesu ꞌina obobomega ꞌiꞌetoseyeda, ta taudi wate Yesu ꞌiobobomedi, ga ꞌenega wate ꞌiꞌetoseyedi.” ");
INSERT INTO dob_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ga maiboꞌadi simiya ꞌalaenono, ga muliyega, Banaba be Paulo siemwaemwasala edeededeyao be ꞌebe nuwaowanao Yaubada ꞌiguinuwedi sena apwesa ꞌediya ꞌidi guinuwega manudi. ");
INSERT INTO dob_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ta muliyega Yemesa ꞌitoolo ga ꞌigwae, “Tasigwao, ꞌigu ona gete wada nono. ");
INSERT INTO dob_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimoni ꞌedaya ꞌisimanaya ꞌaene Yaubada niꞌatu ꞌieꞌale, ga taudi nigeya me Yudia ꞌediyega ꞌaina ꞌina tomotaiyao ꞌiesinuwedi. ");
INSERT INTO dob_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Yage gete manuna lowa palopitao Yaubada ꞌina ona sigimi simanena, ꞌigwae, ");
INSERT INTO dob_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Muliyega yada ilama be Debida ꞌina anuwa niꞌatu ꞌieligeina, yada ꞌabilima. Gete tuga ꞌimiyami besobeso ta esi yada gieboboꞌana lima. ");
INSERT INTO dob_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Be ꞌenega tomota tupwatupwadi simiyami ꞌInapwana sida ꞌebesa, be ꞌagu esiesinuwao, taudi nigeya me Yudia ꞌediyega, taudi wate sida ꞌebesegu. ");
INSERT INTO dob_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Gete ꞌInapwana ꞌina ona, tauna lowaenei nuwanuwa gete ꞌigieapwesena.’ ” ");
INSERT INTO dob_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ta Yemesa wate ꞌigwae, “ꞌIgu loina gete, taudi nigeya me Yudia Yaubada ꞌena sisanasana ila, ꞌaene geyaꞌabo ꞌadi mwau tasaꞌusaꞌu, ");
INSERT INTO dob_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ta esi ꞌidi leta tada ꞌetoladi be ꞌetoboda ata dimo tasaꞌudi nate, masula nina mali ꞌebe bwagobwago ꞌediya siꞌebwaꞌebwaya be, loelata be, yobai didimagadi esiyodi be, lala be. ");
INSERT INTO dob_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Manuna lowaenei ga batuwa Mosese ꞌina loina ꞌana tologuguya ꞌasa ꞌebweuna ꞌebweuna ꞌediya simiyami, ta wate me Yudia ꞌidi anuwa tapwalolo ꞌediya ꞌetoboda getedi sisawasawadi ta tomota sinonodi Sabate ꞌebweuna ꞌebweuna ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ꞌEnega Yesu ꞌana tosimanao site tuwelo be toanuganao be toekalesiyao maiboꞌadi sinuwanuwa leleleya ga ꞌaidi ꞌediyega siesinuwedi be sietunedi be ꞌaene Paulo be Banaba maꞌediyao sitatauya Anitioki. Ta ꞌeluwa toekalesiyao ꞌadi toanuganao ꞌediyega siesinuwedi, natedi Yudasa, tauna sieesena Basaba, be wate Sailasa, ");
INSERT INTO dob_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ga toemisao nidi taudi nigeya me Yudia ꞌidi leta siꞌewena, ta ꞌana ꞌetoladi ꞌigwae, “Kagutoki tasimao ꞌomi toekalesiyao sena apwesaya Anitioki be Silia be Silisia ꞌediya wamiyami. ꞌAboꞌama Yesu ꞌana tosimanao be toanuganao ꞌimi leta ꞌaꞌetoladinawa. ");
INSERT INTO dob_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Lowa alemi ꞌanononaya ꞌaene ꞌaidi tomota ꞌemega siwai, ga mali tetela ꞌenega sigie kwanimi, nate taudimo ꞌidi nuwenuwega, ta nigeya ꞌima emataluwa ꞌediya ꞌenega. ");
INSERT INTO dob_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ꞌEnega ꞌaboꞌama niꞌatu gete ꞌadeli egogonama, ga ꞌima nuwanuwa ꞌebweuna ꞌenega ꞌaina ꞌima tomotaiyao ꞌaesinuwedi, be gosedao Banaba be Paulo maꞌediyao ꞌaetunediwa ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ta Banaba be Paulo nidi taudimo sitagwaledi ga tuta yauyauna ꞌediya sitautauya ꞌebe esilae soladiya, ꞌida ꞌInapwana Yesu Keliso ꞌina guinuwa manuna. ");
INSERT INTO dob_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ta ꞌima tomotai nidi niꞌatu ꞌaesinuwedi, ꞌadi esanao Yudasa be Sailasa, be ꞌami loina sida ꞌebwaꞌemi ꞌimi leta ꞌenega, be wate taudi ꞌidi ona ꞌenega. ");
INSERT INTO dob_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ꞌAmi loina nina ꞌaboꞌama, be wate Yaluyaluwa Tabuna maꞌemai, ꞌanuwena ꞌaene gete loina boboꞌana be ꞌetoboda nidi ata getedi sinabwadimo wada ꞌamayabedi, be geyaꞌabo ꞌebweu toꞌase wate manuna wanuwanuwa. ");
INSERT INTO dob_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ꞌEtoboda nidi nate, toꞌase tomota sitalitaliyae mali ꞌebe bwagobwagoyao ꞌediya, geyaꞌabo waeꞌani, wate yobai malaladi ta yobai didimagadi esiyodi geyaꞌabo waeꞌenidi, ta wate geyaꞌabo waloeloelata. ꞌEguma ꞌetoboda getedi ꞌediyega waꞌitaꞌiꞌisimi, ꞌimi miya boboꞌana. Kaiyoni.” ");
INSERT INTO dob_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ꞌEnega site ata nidi sitoolo, ga simwaꞌuta Anitioki, ta toekalesiyao nada sibwau egogonedima, ga ꞌidi leta nina siꞌebwaꞌedi. ");
INSERT INTO dob_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ꞌEnega leta nina sisawena, ta ꞌina simana manuna sigwausowala sinabwana. ");
INSERT INTO dob_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ta Yudasa be Sailasa taudi sana wate palopitao, ga ꞌidi loguguya yauna ꞌediyega toekalesiyao sigiewaiwaiyedi. ");
INSERT INTO dob_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ꞌEnega siteluwa nidi nada maꞌediyao simiyaꞌamana, ta tuta niꞌatu be sitatauya, ga toekalesiyao nidi silokagutokiyedi, ta silokaiyoniyedi, ga siila taudi ꞌadi toetuneyao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(-) ");
INSERT INTO dob_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ta esi Paulo be Banaba Anitioki ꞌena simiyaila, ga ꞌInapwana ꞌina ona sieꞌieꞌita ta siloguloguguya, ta yaudi wate maꞌediyao siguinuwa. ");
INSERT INTO dob_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ta ꞌasiyata ꞌaina sigumwala ga Paulo Banaba ꞌieonena, ꞌigwae, “Gosiyagu, taila be ꞌasa nidi lowa ꞌInapwana tetelina ꞌaloguguyaena ꞌediya taayausidi wate, be tasidao nidi taꞌitadi, mwaꞌadega ꞌidi miyamiya.” ");
INSERT INTO dob_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ꞌEnega Banaba ꞌigwae, “O boboꞌana, ta Yoni tauna taeesena Maki taꞌauꞌewa be maꞌedai tatautauya.” ");
INSERT INTO dob_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ta Paulo ꞌigwae, “Nai geyaꞌabo tauna ꞌiꞌoayaꞌoayabuda, manuna lowa Pamipili ꞌena ꞌipilisineda, ga ꞌiila ꞌasaya, ta geya nuwana be ꞌiꞌoayabuda ꞌida sakowasi ꞌenaya.” ");
INSERT INTO dob_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ꞌEnega Paulo be Banaba siegewagewana sinabwana Maki manuna, ga Banaba Maki ꞌiꞌauꞌewena ga sigelu wagaya ga sidolo salu Saipilosi ꞌenaya. ");
INSERT INTO dob_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ta Paulo Sailasa ꞌiesinuwena be ꞌida ꞌoayabuna ꞌina sakowasi nina ꞌena. ꞌEnega toekalesiyao Yaubada ꞌena sisidasida be ꞌina obobomega siteluwa nidi ꞌida giewaiwaiyedi; ta sitauya, ");
INSERT INTO dob_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ga sisakowasi Silia be Silisia ꞌasanao ꞌediya, ga Paulo toekalesiyao ꞌilemedi, ta ꞌigiewaiwaiyedi. ");
INSERT INTO dob_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ga ꞌidi sakowasi ꞌenaya sitauya Debi be Lisitila ꞌediya, ga Lisitila ꞌena Yesu ꞌana tomuliya ꞌebweu silobena, ꞌana esana Timoti, tauna sinana waine Yudia ta Yesu ꞌana toemisa, ta tamana saꞌi goma Gilisi. ");
INSERT INTO dob_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ta toekalesiyao ꞌasa Lisitila be Ikoniami ꞌediya, Timoti nina siꞌawa boboꞌanena, ");
INSERT INTO dob_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ga Paulo nuwanuwana be Timoti maꞌediya sisakowasi, ꞌenega ꞌibwauyena ga bwalana ꞌilodabena Mosese ꞌina loina nadigega, be ꞌaene me Yudia Timoti nina sida ꞌamayabe, manuna me Yudia sena nina Lisitila ꞌena simwalatonina ꞌaene Timoti tamana goma Gilisi. ");
INSERT INTO dob_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ꞌEnega sisakosakowasi ꞌasa ꞌebweuna ꞌebweuna ꞌediya, ga loina nina Yesu ꞌana tosimanao be toanuganao toꞌase Yelusalema ꞌena siloinenaya sisimanena ꞌasa maiboꞌadi ꞌediya, be ꞌaene loina nina sida mulimuliye. ");
INSERT INTO dob_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ꞌEnega toekalesiyao ꞌidi emisa ꞌiewaiwai, ga ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya ꞌadi boda ꞌisinasinabwa. ");
INSERT INTO dob_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ꞌEnega Paulo magosenao sena Piligia be Galetia soladiyega sitautauya, ta Yaluyaluwa Tabuna niꞌatu ꞌiꞌetobodedi be ꞌaene geyaꞌabo Yaubada tetelina sena Esia ꞌenaya siloguloguguyae. ");
INSERT INTO dob_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ga simai Misia ga sitoona be ꞌaene Bitinia ꞌena silulugu, ta Yesu Yaluyaluwana nigeya ꞌitagwatagwaledi. ");
INSERT INTO dob_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ꞌEnega Misia sipilisinena ga sidolo Tiloasi. ");
INSERT INTO dob_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ꞌEnega boiboiya siꞌenoꞌeno ga Paulo ꞌimadawala, ta ꞌina madawala nina ꞌaene tai ꞌebweu goma Masidonia ꞌiꞌitena, ꞌitoolo ta ꞌisidasida Paulo ꞌena, ꞌigwaegwae, “ꞌUabalama Masidonia ꞌenaya be ꞌulemema.” ");
INSERT INTO dob_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo ꞌina madawala nina ꞌenega ꞌamwalatonina ꞌaene Yaubada niꞌatu ꞌibwauyema be tetela boboꞌana ꞌada loguguyae me Masidonia ꞌediya, ꞌenega ꞌeda ꞌaꞌebesa sabi abala Masidonia. ");
INSERT INTO dob_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ꞌEnega waga ꞌalobena ga Tiloasi ꞌenega ꞌatupa, ga palupaluna Samotilesi, ga nada ꞌaꞌeno. Tomwa ꞌiulisina ga ꞌaꞌadau limana ga Niapoli ꞌena ꞌasuya, ");
INSERT INTO dob_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ga Niapoli ꞌenega ꞌatauya Pilipai, tauna ꞌasa sinabwana sena Masidonia solanaya, ta ꞌasa nina solanaya me Loma toesugalagala yaudi simiyami, ga gote ꞌena ꞌamiya ila ꞌaina ꞌasiyata. ");
INSERT INTO dob_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ga Sabateya ꞌasega ꞌaapwesa ꞌebweu bwasi tuputupinaya, sena nina ꞌanuwena ꞌebe lotapwalolo, ga ꞌenaya ꞌamiyatowa, ta iine niꞌatu siegogonama wate maꞌemao ꞌaꞌawaꞌawagwae. ");
INSERT INTO dob_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ta ꞌebweu waine ꞌediyega ꞌana esana Lidia, ꞌasa Tayataila wainena, ta Yaubada ꞌana toemisa, ta ꞌina paisewa nate ꞌebweu ꞌoama esaesa ꞌana toegimwane. Ta ꞌetamo iine nidi ꞌima ona sinononoi, ga Yaubada emisa Lidia ꞌatenaya ꞌienuwa saꞌuyena, ga Paulo ꞌina loguguya ꞌiemisena, ");
INSERT INTO dob_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ga tauna ma ina susuyao ꞌagie bapitaisoedi. Ga muliyega ꞌisidema, ꞌigwae, “ꞌInapwanao, wamwalatonigu ꞌaene niꞌatu Yesu yaemisa ꞌaiꞌailena, ꞌenega kapekapeyana wamamai be waeꞌowaga ꞌigu anuwaya?” Ta ꞌigewagewanema, ga ꞌenega ꞌatauya. ");
INSERT INTO dob_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Mali ꞌasiyata ꞌena ꞌatautauya sena nina ꞌebe lotapwalolo nina ꞌena, ga ꞌaina ꞌinapwanao ꞌidi ꞌaliꞌei gomagweine ꞌalobena, tauna yaluyaluwana nabwanabwasuwana ꞌenega sawesawenaya ꞌigimi simanedi toꞌase maꞌetamo ꞌida apwesa, ta ꞌina guinuwa gete ꞌenega gomagweine nina ꞌina ꞌinapwanao mani sinabwana siꞌewaꞌewa tomota ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ꞌEnega waine nina ꞌimulimuliyema, ta ꞌibwaubwau, “Gete tomota nidi Yaubada Toloetana sana ꞌina toguinuwao, ta ꞌetoseyana ꞌana ꞌeda ꞌana tosimanao.” ");
INSERT INTO dob_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Gomagweine nina gete nadigega ꞌibwaubwau ꞌasiyata yaudi ꞌediya, ꞌenega Paulo ꞌieꞌoataꞌoata, ga ꞌisanasakowasi, ta yaluyaluwa nina ꞌieonena, ꞌigwae, “Yesu Keliso ꞌana esanega yaloineyo be gomagweine nate ꞌenega ꞌuapwesa.” Ga gote tuta nina ꞌenaya ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ta gomagweine ꞌina ꞌinapwanao sigamwasowalema, manuna ꞌidi mani sinabwana ꞌana ꞌebe loba tauna gomagweine nina, ta niꞌatu Paulo ꞌigieboboꞌanena. ꞌEnega Paulo be Sailasa sigiyaidi ga silisi dadanedi, ga sitauyedi ꞌebe egimwane ꞌena, ta siꞌauꞌewedi toloinao ꞌediya sabi etalaedi, ");
INSERT INTO dob_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ga sieonedi, sigwae, “Gete tai nidi taudi me Yudia, ta simai ꞌida ꞌasaya ga ꞌada ꞌoataꞌoata sisaꞌusaꞌu, ");
INSERT INTO dob_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","manuna mali bubuna sieꞌieꞌita, nate ꞌaboꞌada me Loma ꞌida ꞌetoboda, be geyaꞌabo bubuna nina taguiguinuwe.” ");
INSERT INTO dob_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ta pwaluyao wate gete nadigega sieꞌewedi, ꞌenega toloinao siloinedi, ga Paulo be Banaba ꞌadi ꞌoamao ꞌediyega sialolodi, ga kaiwe ꞌediyega sisapi dadanedi. ");
INSERT INTO dob_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Siunu geyogeyonidi ga ꞌigumwala, ta deliya sisaꞌu luguyedi, ta deli ꞌana toꞌitaꞌiꞌita siloinena be ꞌida lomataꞌiꞌita ꞌaiꞌailidi. ");
INSERT INTO dob_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ꞌEnega toꞌitaꞌiꞌita nina ꞌana loina ꞌinonona, ga ꞌisaꞌu luguyedi deli solaꞌaiꞌailinaya, ta wate ꞌaedi ꞌitalayaidi kaiwe sinabwadi ꞌediyega. ");
INSERT INTO dob_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ta niuniuwanaya Paulo be Sailasa sisidasida ta siwaliwali Yaubada ꞌena, ta ꞌenega tolugu deliyao maiboꞌadi sienoenonoedi, ");
INSERT INTO dob_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ta mwaniꞌiniꞌi sinabwana ꞌiniuniu ga silosuyaedi, ta anuwa deli ꞌana ꞌautui ꞌiloniu, ga deli nina ꞌana ꞌawao siꞌegegedi, ta ꞌenega tolugu nidi ꞌaedi ꞌadi talayainao sieliꞌamidi taudimo. ");
INSERT INTO dob_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ta deli ꞌana toꞌitaꞌiꞌita ꞌenoꞌenoega ꞌilosuyaena, ga ꞌawa ꞌegeꞌegegedi niꞌatu ꞌiꞌitedi, ga ꞌina nuwena toluguyao nidi niꞌatu sidena, ꞌenega ꞌina sisisaiya ꞌiꞌewena ta ꞌaene tauna ꞌida loemwawasi. ");
INSERT INTO dob_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ta Paulo ꞌiꞌitenama, ga ꞌibwau, ꞌigwae, “Gosiyagu, geyaꞌabo tauyo ꞌuloeloemwawasiyo. Maiboꞌama gete ꞌamiyami.” ");
INSERT INTO dob_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ꞌEnega toꞌitaꞌiꞌita nina ꞌina toguinuwao ꞌediya ꞌibwau be mayale simeꞌe, ga mayale ꞌiꞌewena, ta ꞌipili ga ꞌilugu ma ina dedela, manuna ꞌimatauta, ta ꞌibeꞌusana mwaꞌuta Paulo be Sailasa matadiya. ");
INSERT INTO dob_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ta muliyega ꞌitoolo ga ꞌiꞌauꞌewa apwesedi, ta ꞌigwae, “ꞌInapwanao, waeonagu toꞌase yada guinuwa be ꞌenega Yaubada ꞌida ꞌetoseyegu?” ");
INSERT INTO dob_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ta Paulo be Sailasa sigwae, “ꞌEguma ꞌInapwana Yesu ꞌena ꞌuemisa, ꞌiabe ꞌoyo be ꞌimu susuyao wate ꞌetoseyana waloba.” ");
INSERT INTO dob_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ꞌEnega ꞌInapwana tetelina siemwasalina tauna ma ina buꞌunao ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Boiboi gote ꞌena ꞌiꞌauꞌewa apwesedi ga ꞌadi ꞌabiyama be lala sapiyega silobenaya ꞌiꞌutudi, ga tauna ma ina susuyao sibapitaiso. ");
INSERT INTO dob_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ꞌEnega ꞌiꞌauꞌewedi tauna ꞌina anuwaya, ta ꞌenega ꞌadi masula ꞌigibubuna, ga siꞌeꞌai. Ga deli ꞌana toꞌitaꞌiꞌita nina ma ina susuyao sigwausowala sinabwana, ꞌina emisa auwauna Yaubada ꞌena ꞌilobenaya manuna. ");
INSERT INTO dob_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tomwa ꞌiulisina ga toloinao ꞌidi pilisimaniyao sietunedi deli ꞌana toꞌitaꞌiꞌita ꞌena be sida emataluwena ꞌaene, “Tai ꞌeluwa nidi deliya ꞌasaꞌu luguyediya ꞌuliꞌamidi be siapwesa.” ");
INSERT INTO dob_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ꞌEnega toꞌitaꞌiꞌita nina deli solanaya ꞌilugu ga ale nina ꞌisimanena Paulo ꞌena, ꞌigwae, “Toloinao ale sietunenama ꞌaene yada liꞌamimi, ꞌenega waapwesama be ma imi gwausowala watatauya.” ");
INSERT INTO dob_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ta Paulo ꞌiguitoyasa, ꞌigwae, “Geyaꞌabo ꞌatautauya. Manuna nigeya ꞌebweu ꞌima loegesi etala ꞌenega silobaloba, ta bodao matadiya siunu dadanema, ga deliya sisaꞌu luguyema, ta ꞌaboꞌama saꞌi lowa ꞌaeLoma. Toꞌase manuna ꞌaene sida liꞌamima be sigieapwesema kwaiyega? Ta ꞌilobwenedi esi taudi tuga sida mai be siꞌauꞌewa apwesema.” ");
INSERT INTO dob_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ꞌEnega pilisimani nidi siila toloinao ꞌediya, ga Paulo ꞌina ona sisimanena ꞌediya. ꞌEnega toloinao nidi siomayamaya sinabwana, manuna niꞌatu simana gete ꞌenega simwalatonina ꞌaene Paulo be Sailasa sieLoma. ");
INSERT INTO dob_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ꞌEnega simai deliya, ga nuwaꞌoleꞌoleyega siona oboboma Paulo be Sailasa ꞌediya, ga deliyega siꞌauꞌewa apwesedi, ga sisidedi be sida tauya mali ꞌasaya. ");
INSERT INTO dob_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ꞌEnega Paulo be Sailasa deliyega sitauya Lidia ꞌina anuwaya, ga toekalesiyao maꞌediyao siegosigosiyana, ta siloguguya ꞌediya, ga muliyega sitauya. ");
INSERT INTO dob_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ꞌEnega Amipipoli be Apolonia ꞌediyega sitauya ga Tesalonaika ꞌena siapwesa, ta Tesalonaika ꞌena me Yudia ꞌidi anuwa tapwalolo ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ꞌEnega Paulo ꞌidi lotapwalolo ꞌena ꞌilugu, nadigega sena yauyaudi ꞌediya ꞌiguiguinuwaꞌesa, ga nada tapwalolo ꞌetoi ꞌediya Buki Tabu ꞌenega ꞌieꞌieꞌita be maꞌediya siegewagewana, ");
INSERT INTO dob_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ta Paulo nina mwalatoi ꞌiꞌebwaꞌedi, ꞌigwae, “Toꞌetoseyana nina ꞌilobwenena be ꞌelouya ꞌiloba be ꞌida mwawasa, be wate mwawasega ꞌida toolo limana.” Ta wate ꞌigwae, “Yesu nina yasimasimanena ꞌemiya, tauna tuga Toꞌetoseyana nina.” ");
INSERT INTO dob_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ꞌEnega ꞌaidi siꞌawa ꞌaiꞌailena ga Paulo be Sailasa ꞌidi boda ꞌena silugu, ta Yaubada ꞌana toꞌamayabao taudi nigeya me Yudia ꞌediyega, be iine ꞌadi esanao sinabwadi ꞌediyega, yaudi wate siemisa. ");
INSERT INTO dob_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ta me Yudia saꞌi Paulo be Sailasa sieꞌipiꞌipiyedi ga siꞌawa toꞌumaliyedi, ga ꞌaina toadadana besobeso toꞌumalidi siloinedi ga pwalu sinabwana siegogonedima ta nuwanuwadi be silosaiyedi. ꞌEnega Yesoni ꞌina anuwa simwelena, ꞌidi nuwanuwa ꞌaene Paulo be Sailasa anuwaya simiyami, be ꞌaene sida giyaidi, ");
INSERT INTO dob_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ta siꞌebesa yogenedi, ga Yesoni ta ꞌaina toekalesiyao maꞌenao sigiyaidi, ta ꞌenega siꞌauꞌewedi ꞌasa ꞌana toloinao ꞌediya sabi etalaedi, ta sibwaubwau, sigwae, “Tai getedi sena maiboꞌadi ꞌadi togietoꞌumali niꞌatu simai bada, ");
INSERT INTO dob_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ga Yesoni ꞌina anuwaya sieꞌowaga, ta ꞌidi eꞌita ꞌenega Sisa ꞌina loina sileꞌoena, manuna sionaona ꞌaene kini auwauna ꞌiapwesamaya, ꞌana esana Yesu.” ");
INSERT INTO dob_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ꞌAsa ꞌana toloinao ta pwaluyao eꞌewa gete sinonona ga siꞌatesaꞌala, ");
INSERT INTO dob_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ꞌenega siloina Yesoni magosenao ꞌediya be ꞌidi mani ꞌenega sida yotula, be wate sida miya siwalowa. ꞌEnega siyotulaya, ta siliꞌamidi ga sitauya. ");
INSERT INTO dob_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ta boiboiya toekalesiyao Paulo ta Sailasa sietunedi be sitatauya Belia, ꞌenega sitauya, ga tuta nina siapwesa Belia, silugu me Yudia ꞌidi anuwa tapwalolo ꞌena, ga Yesu tetelina sieꞌieꞌita. ");
INSERT INTO dob_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Lowa Tesalonaika ꞌena me Yudia geya nuwadi tetela nina, ta saꞌi me Yudia Belia ꞌena ꞌidi tagwala boboꞌana, ga tetela nina nuwadi ꞌiꞌewena, ꞌenega ꞌasiyata ꞌebweuna ꞌebweuna Buki Tabu sisawasawa be ꞌaene tetela gete ꞌana ꞌaiꞌaila sida mwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ꞌEnega me Yudia yaudi siemisena, ta wate taudi nigeya me Yudia, iine taudi ꞌadi esana sinabwadi, be wate ꞌaina ꞌoloto, tupwana yaudi siemisa. ");
INSERT INTO dob_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ta saꞌi me Yudia Tesalonaika ꞌana tomiyanao nidi sinonona ꞌaene Paulo Yaubada tetelina niꞌatu ꞌiloguloguguya ꞌasa Belia ꞌena, ga silomaninima ga pwaluyao sienuwa saꞌuyedi be ꞌaene Paulo be Banaba sida losaiyadi. ");
INSERT INTO dob_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ꞌEnega toekalesiyao siloina manini, ga Paulo sietunena be ꞌimwaꞌuta ꞌasa leꞌawaya ꞌena, ta Sailasa be Timoti bada maꞌediyao simiyami. ");
INSERT INTO dob_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ꞌEnega ꞌaina toekalesiyao ꞌediyega Paulo siꞌoayabuna ga sitauya Ateni, ta ꞌenega Paulo loina ꞌiꞌebwaꞌedi be ꞌaene Sailasa be Timoti sida lomaninima Ateni ꞌena, ꞌenega toꞌoayabu nidi siila Belia. ");
INSERT INTO dob_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ta Paulo Ateni ꞌena, Sailasa be Timoti manudi ꞌetamo ꞌiyamwayamwa, ga ꞌinuwamwau sinabwana, manuna ꞌiꞌitena me Ateni nigeya Yaubada ꞌena siemiemisa, ta ꞌidi ꞌebe emisa dumadumadi ta yau wawasae. ");
INSERT INTO dob_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ꞌEnega maꞌediya siegewagewana, nuwanuwa gete manuna, me Yudia ta ꞌaidi Yaubada ꞌana toemisao wate maꞌediya sionaona, me Yudia ꞌidi anuwa tapwalolo ꞌena, ta wate toniꞌasa, ꞌeguma ꞌialobadi ꞌebe gimwane ꞌena, maꞌediya sionaona ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ta ꞌaidi tosinasinapuyao wate, taudi sieesedi Epikulo, be ꞌaidi Sitoike wate, Paulo maꞌenao sieonaona, ga ꞌaidi taudimo ꞌediya siemwaemwasala, sigwae, “Na! Kabaleya nina toꞌase ꞌioneone?” Ta ꞌaidi sigwae, “Nai mali yaubadao manudi ꞌiloguloguguya.” Manuna sinononaya Yesu ꞌina toololimana mwawasega manuna ꞌiloguloguguya. ");
INSERT INTO dob_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ꞌEnega Paulo nina siꞌauꞌewena Anuwa Deliegogona ꞌana esana Aliopago ꞌena, ga sieonena, “ꞌImu eꞌita gete auwauna, ");
INSERT INTO dob_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ta ꞌemaya ꞌana nono ꞌaene nuwaowana, ꞌenega ꞌana mwalatoi ꞌuda liꞌami be ꞌada nuwasabwalena.” ");
INSERT INTO dob_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ta me Ateni be ꞌowagao maiboꞌadi ꞌidi nuwanuwa mwalatoi auwaudi ꞌadi eꞌita be ꞌadi enono namo tuga manudi. ");
INSERT INTO dob_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ꞌEnega Paulo Anuwa Deliegogona solanaya ꞌitoolo ga ꞌiloguguya ꞌediya, ꞌigwae, “Me Ateni ꞌomi, niꞌatu yamwalatonimi ꞌaene waetaetapewa ꞌimi tapwaloloyao ꞌediya, ");
INSERT INTO dob_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","manuna ꞌigu adadanao ꞌediya ꞌimi ꞌebe bwagobwagoyao yaudi yaꞌitedi, ta ꞌediyega ꞌebweu ꞌebe taliya ma ꞌana ꞌetoladi yaꞌita lobena, ga ꞌana ꞌetoladi gete nadigega, ꞌigwae, ‘Yaubada tauna nigeya tada mwalatonina ꞌina ꞌebe taliya gete.’ Ta Yaubada nina ꞌina ꞌebe taliya nate ꞌena wabwagobwago, ta nigeya wamwalamwalatoni, tauna manuna yasimasimana ꞌemiya. ");
INSERT INTO dob_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Tauna baleꞌu maiboꞌana ta yage yauyaudi ꞌenaya simiyami ꞌadi tomweluluwa, ta galewa be baleꞌu ꞌadi ꞌInapwana. ꞌEnega nigeya anuwao tomota nimadiyega siꞌabiꞌabidi soladiya Yaubada nina ꞌida miyami. ");
INSERT INTO dob_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ta tomota ꞌaboꞌada nigeya sawesawedaya be ꞌebweu toꞌase nimadega tauna Yaubada nina taꞌebwaꞌe, ꞌabo tanuwanuwa ꞌaene nuwanuwana, ta tauna esi yawasida be yaluyaluwada be ꞌida yageyao maiboꞌadi ꞌadi Toꞌebwaya, ");
INSERT INTO dob_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ga ꞌebweuna tai ꞌana esana Adama ꞌenega mali sena be mali sena tomotenidiyao ꞌimweluluida be tomota sida ꞌelelewana baleꞌu maiboꞌana ꞌenaya, ga boda ꞌebweuna ꞌebweuna ꞌidi tuta be ꞌidi sena Yaubada ꞌiloinedi. ");
INSERT INTO dob_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ꞌIna nuwanuwa ꞌaene tauna sida ꞌebese, be nai maꞌetamo sida lotoona, nai sida loba. Ta saꞌi Tomweluluwa nina maiboꞌada selabedaya ꞌimiyami. ");
INSERT INTO dob_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Manuna ‘Tauna tuga ꞌenega yawasida taꞌewaꞌewa, ta maꞌedai tatautauya be wate tamiyami.’ “Ta ꞌaina wate ꞌimi toedale Yaubada nina manuna sigwae, ‘Onaꞌaiꞌaila, ꞌaboꞌada tauna natunao.’ ");
INSERT INTO dob_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“ꞌEnega geyaꞌabo tanuwena ꞌaene Tamadai nina ꞌatuwa tokwalui, nate tomota ꞌidi nuwenuwega be goula nai siliba nai gulewa ꞌediyega sibubuna. ");
INSERT INTO dob_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","“Tuta nidi lowa tomota Yaubada siemwagemwageyena, ꞌenega nigeya ꞌida gamwasowaledi, ta esi gete tuga sena maiboꞌadi tomotenidiyao ꞌiloineda be ꞌida loegesi ꞌediyega tada nuwaꞌebuni, ");
INSERT INTO dob_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","manuna ꞌida ꞌasiyata bwaꞌomatana maꞌetamo ꞌiupaena be me baleꞌu maiboꞌada ꞌada loina palupaluna ꞌida ꞌebwaꞌeda tai nina ꞌiesinuwena ꞌenega, ga tai nina mwawasega ꞌigietoolo limenaya, be ꞌenega tomota maiboꞌada tetela gete tada ꞌawaꞌaiꞌaile.” ");
INSERT INTO dob_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ta pwalu tomwawasa ꞌidi toloolimana tetelina sinononaya, ga ꞌaina siedagi, ta ꞌaidi sigwae, “Nuwanuwama be maꞌetamo nuwanuwa gete manuna ꞌuemwasala limana be ꞌanono.” ");
INSERT INTO dob_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ꞌEnega Paulo boda nidi ꞌediyega ꞌiapwesa. ");
INSERT INTO dob_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ta ꞌaina tomota Paulo ꞌina ona siemisena ga ꞌina boda ꞌena silugu, ꞌebweuna tai ꞌana esana Dionisio, tauna Anuwa Deliegogona nina ꞌana toguinuwa ꞌebweu, be ꞌebweu waine ꞌana esana Damali, ta ꞌaidi wate. ");
INSERT INTO dob_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Muliyega Paulo Ateni ꞌipilisinena ga ꞌisakowasi Kolinita ꞌena, ");
INSERT INTO dob_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ga goma Yudia ꞌilobena, ꞌana esana Akuila, ta ꞌina ꞌasa Ponitio, ta mamwanena Pilisila niꞌa Italiega simai, manuna Kini Kolodia me Yudia maiboꞌadi ꞌiloinedi be Lomega sida apwesa. Ga Paulo Akuila mamwanena ꞌiayausidi, ");
INSERT INTO dob_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ta taudi ꞌidi guinuwa yobai bwaladiyega sisaisaila yoeyoe, nadigega Paulo ꞌina guinuwa tuga. ꞌEnega ꞌieꞌowaga ꞌidi anuwaya, ga maiboꞌadi yoeyoe siguinuwedi. ");
INSERT INTO dob_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ga Sabate ꞌebweuna ꞌebweuna ꞌediya me Yudia ꞌidi anuwa tapwalolo ꞌena ꞌionaona, toluguyao maꞌenao, ga ꞌitootoodi be sida emisa, ga ꞌaidi me Yudia ta ꞌaidi wate nigeya me Yudia siemisena. ");
INSERT INTO dob_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ꞌEnega tuta nina Sailasa be Timoti Masidoniyega siapwesama, Paulo maꞌetamo ꞌiloguloguguya, ta me Yudia ꞌediya ꞌisimasimana ꞌaene Toꞌetoseyana nina tauna Yesu. ");
INSERT INTO dob_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ꞌEnega siegewagewana ta siꞌawa kabokabo, ta Paulo ꞌana ꞌoama ꞌiloutuutuna matadiya, nate ꞌidi loguitoyasa ꞌana ꞌebeꞌita ꞌiguinuwena, ga ꞌieonedi, “ꞌOmi maꞌetamo waesilae ꞌimi guitoyasa gete manuna, be nate taumimo ꞌimi loinega ta nigeya ꞌaboꞌagu ꞌigu loinega. ꞌEnega yaebesinemi be tetela yada tauye taudi nigeya me Yudia ꞌediya.” ");
INSERT INTO dob_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ꞌEnega ꞌidi anuwa tapwalolo ꞌenega ꞌiapwesa, ga ꞌilugu Taito Yusito ꞌina anuwaya, tauna Yaubada ꞌana toꞌamayaba ꞌebweu, ta ꞌina anuwa me Yudia ꞌidi anuwa tapwalolo selabenaya. ");
INSERT INTO dob_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ga anuwa tapwalolo ꞌana toanugana, ꞌana esana Kilisipo, ma ina susuyao, ꞌInapwana Yesu ꞌena siemisa, ta me Kolinita yaudi wate Paulo ꞌina loguguya sinonona, ga Yesu ꞌena siemisa, ga sibapitaiso. ");
INSERT INTO dob_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ꞌEnega boiboiya Paulo ꞌina ꞌenomataꞌiteꞌitega ꞌInapwana Yesu ꞌiꞌitena, ga Yesu ꞌigwae, “Paulo, geyaꞌabo ꞌuꞌateꞌate saꞌala, ta tuwa tuga tetela ꞌuda simasimana apwesa, be geyaꞌabo ꞌulosalosaꞌu. ");
INSERT INTO dob_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ta ꞌaboꞌagu saꞌi maꞌiyayo tamiyami, manuna ꞌasa gete ꞌena tomota yaudi sida emisegu be ꞌigu bodao taudi, ta geyaꞌabo ꞌebweu yaita sawesawenaya ꞌilosaiyeyo, nai ꞌigie toꞌumaliyeyo.” ");
INSERT INTO dob_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ta yakwala ꞌebweuna ta tupwana ꞌediya Kolinita ꞌena ꞌimiyami, ga Yaubada ꞌina ona ꞌieꞌieꞌitae. ");
INSERT INTO dob_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Tuta muliyega Galio ꞌietoloina sinabwana sena nina Akaya ꞌenaya, ꞌenega me Yudia nidi siloina ga Paulo sitauyena sabi etala Galio nina matanaya, ");
INSERT INTO dob_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ta sigwae, “Tai nina gete tomota ꞌiwasewasegigiyedi be ꞌaene mali tapwalolo Yaubada ꞌena sida guinuwa, ta gete ꞌida loinao ꞌileꞌoeleꞌoedi.” ");
INSERT INTO dob_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ga Paulo ꞌiabe be ꞌieona limadi, ta Galio saꞌi ꞌiona nugana me Yudia ꞌediya, ta ꞌigwae, “Me Yudia, ꞌomi ꞌigu ona wanonoi: ꞌEguma tai gete ꞌibubuna toꞌumalina nai loegesi ꞌiguiguinuwe, ꞌilobwenena be ꞌimi eꞌewa yada nono, ");
INSERT INTO dob_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ta esi nuwanuwa gete, taumi tuga ꞌimi onaona be esanao be loinao ꞌimi ꞌasega, ꞌenega taumi tuga wada loina. ꞌAboꞌagu yaguitoyasa.” ");
INSERT INTO dob_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ꞌEnega ꞌebe etala ꞌenega ꞌipaꞌidi. ");
INSERT INTO dob_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ta pwaluyao Sositeni sigiyaina, tauna me Yudia ꞌidi anuwa tapwalolo ꞌana toꞌitaꞌiꞌita, ga siunu dadanena Galio ꞌina ꞌebe etala matanaya, ta Galio nina nigeya wate manudi ꞌinuwanuwa. ");
INSERT INTO dob_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Losaiya gete mulinaya Paulo nada ꞌimiyami ꞌaina ꞌasiyata ꞌediya, ꞌenega muliyega toekalesiyao nidi ꞌilokaiyoniyedi ga wagega ꞌigelu sabi ꞌadau Silia manuna. Ta Akuila mamwanena Pilisila wate maꞌenao sigelu. Ta ꞌebweu yage, nate maꞌetamo be sigegelu Kenikilia ꞌena, Paulo ꞌina onaupaupa ꞌiguinuwena Yaubada matanaya, ta onaupaupa nina ꞌana weꞌiweꞌiyaya Paulo ꞌuyaꞌuyana sikolina. ");
INSERT INTO dob_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ꞌIdi ꞌadau nina ꞌena nugana silugu Epeso, ga Akuila mamwanena sisuya ga simiyami, ta Paulo wate ꞌisuya ga ꞌilugu me Yudia ꞌidi anuwa tapwalolo ꞌena, ga ꞌitootoo be ꞌaene ꞌilisidima be Keliso ꞌena sida emisa, ta maꞌediya siꞌawaꞌawagwae. ");
INSERT INTO dob_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ꞌEnega sisidena be tuta dudulana maꞌediya sida miyami, ta ꞌiguitoyasa, ");
INSERT INTO dob_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ꞌigwae, “Maꞌetamo yailama, ꞌeguma Yaubada ꞌitagwalegu.” ꞌEnega me Epeso nidi ꞌilokaiyoniyedi, ta ꞌigelu limana, ");
INSERT INTO dob_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ga ꞌitauya Sisalia ꞌena ꞌisuya, ga ꞌilaga Yelusalema ga toekalesiyao maꞌenao siegosigosiyana, ga muliyega ꞌitauya Anitioki. ");
INSERT INTO dob_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Anitioki ꞌena ꞌimiyaꞌamana, ga muliyega ꞌitoolo ga Galetia be Piligia ꞌasanao ꞌebweuna ꞌebweuna ꞌediya ꞌisakosakowasi, ta Yesu ꞌana toemisao ꞌigiepaꞌalidi. ");
INSERT INTO dob_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tuta nina ꞌena, ꞌebweu goma Yudia ꞌana esana Apolosa, ta ꞌasa Alekisanidela taina, ꞌimai Epeso, tauna loguguya ꞌalena, ta Buki Tabu ꞌimwalatoi ꞌaiꞌailina. ");
INSERT INTO dob_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ta wate eꞌitao Yaubada ꞌina ꞌeda manuna ꞌimwalatonidi, ga ꞌietaetapewa Yesu tetelina ꞌieꞌieꞌita. ꞌIna eꞌita nina ꞌaiꞌaila, ta esi tupwana namo, manuna toꞌase Yoni ꞌiloguguyaena ꞌina bapitaiso manuna Apolosa nina ꞌimwalamwalatoni, ta Yesu tetelina ꞌana ꞌebe losalowa nigeya ꞌimwalamwalatoni. ");
INSERT INTO dob_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ꞌEnega tuta nina Epeso ꞌena ꞌiapwesama ꞌilugu me Yudia ꞌidi anuwa tapwalolo ꞌena, ga ma ina waiwai ꞌiloguguya. Ta Akuila be Pilisila ꞌina loguguya sinonona ꞌaene ꞌina mwalatoi tupwana namo tuga, ꞌenega siꞌauꞌewena, ga Yaubada ꞌina ꞌeda maiboꞌana sieꞌitena. ");
INSERT INTO dob_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Muliyega Apolosa nuwanuwana be ꞌiabala Akaya, ga toekalesiyao silemena, ga Yesu ꞌana toemisao Akaya ꞌena ꞌidi leta siꞌetoladina, ga Apolosa siꞌebwaꞌena be ꞌabo to tuta Akaya ꞌena ꞌida apwesa ꞌidi leta ꞌida ꞌebwaꞌedi be sida ꞌauꞌewena ꞌidi anuwaya. ꞌEnega Apolosa ꞌiabala ga ꞌilugu Akaya ꞌena, ga taudi me Akaya, lowa Yaubada ꞌina obobomega Yesu siemisenaya, ta Apolosa nina ꞌina loguguyega ꞌilemedi sinabwana, ");
INSERT INTO dob_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ta ꞌina eꞌita me Yudia ꞌidi eꞌita ꞌiewaiwai sinena, manuna Buki Tabu ꞌenega ꞌieꞌitedi ꞌaene Toꞌetoseyana nina tauna tuga Yesu. ");
INSERT INTO dob_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolosa ꞌetamo Kolinita ꞌena ꞌimiyami, ga Paulo ꞌisakowasi senao ꞌaina mitawaya ꞌediyega, ga Epeso ꞌenaya ꞌimai leꞌawaya. Gote ꞌena ꞌaina Yesu ꞌana tomuliyao ꞌialobedi, ");
INSERT INTO dob_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ga ꞌienaidedi, “Gosegwao, tuta nina Yesu wagimi emisena, Yaluyaluwa Tabuna ꞌina waiwai walotoona nai nigeya?” Ta sieonena sigwae, “Nigeya. Nigeya ꞌamwalamwalatoni ꞌaene Yaluyaluwa Tabuna ꞌimiyami.” ");
INSERT INTO dob_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ꞌEnega Paulo ꞌigwae, “To bapitaiso sana ꞌenega wabapitaiso?” Ta sigwae, “Yoni ꞌina bapitaisoega.” ");
INSERT INTO dob_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ta Paulo ꞌieonedi, “Yoni ꞌina giebapitaiso nate nuwaꞌebuni bubuna toꞌumalina ꞌenega manuna, ta ꞌiemataluwemi be ꞌaene wada emise tauna ꞌetamo mulinega ꞌimeemai, nate Yesu.” ");
INSERT INTO dob_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Gete me Epeso nidi sinonona, ga sinuwa sabwalena ꞌaiꞌaila, ꞌenega ꞌInapwana Yesu ꞌana esanega sibapitaiso, ");
INSERT INTO dob_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ga Paulo ꞌigidebedi ga Yaluyaluwa Tabuna ꞌilugu ꞌediya, ta ꞌina waiwaiyega mali ꞌenana be mali ꞌenana ꞌediyega siona apwesa, ta Yaubada manuna siloguguya. ");
INSERT INTO dob_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ta maiboꞌadi ꞌadi yau nadigega site tuwelo. ");
INSERT INTO dob_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ga nawalae ꞌetoi ꞌediya me Yudia ꞌidi anuwa tapwalolo solanaya Paulo nina ꞌilugulugu, ta Yaubada ꞌina etoloina manuna ma ina ꞌatepatu ꞌionaona, ta ꞌiegewagewana ta ꞌiꞌiꞌiꞌimidi. ");
INSERT INTO dob_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ta saꞌi ꞌaidi deba paꞌapaꞌalidi ga nigeya siemiemisa, ta Yesu ꞌina ꞌeda nina siꞌawa toꞌumaliyena toegogona nidi matadiya. ꞌEnega Paulo ꞌitoolo ga ꞌana tomuliyao maꞌenao siapwesa, ga silugu Tilano ꞌina anuwa ꞌebe sikulu ꞌenaya, ga nada ꞌasiyata ꞌebweuna ꞌebweuna ꞌediya Paulo ꞌiloguloguguya. ");
INSERT INTO dob_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ꞌIna guinuwa nina gete nadigega tuga ꞌipaipaisewa yakwala ꞌeluwa ꞌediya. ꞌEnega sena Esia ꞌana tomiyanao maiboꞌadi, taudi me Yudia be taudi nigeya me Yudia, ꞌInapwana tetelina sinonona. ");
INSERT INTO dob_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ta Yaubada yage ꞌebe nuwaowanao ꞌigieapwesedi Paulo ꞌina guinuwega, ");
INSERT INTO dob_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ga ꞌana ꞌamweyai ꞌana ꞌebe talaꞌiꞌilao be ꞌana ꞌoamao siꞌewedi ta toleꞌoasao ꞌediya sigiepaꞌiyedi, ga ꞌadi leꞌoasa sigumwagumwala, ta wate yaluyaluwa biꞌiyao siula apwesedi. ");
INSERT INTO dob_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Ta ꞌaina me Yudia ꞌidi toꞌobao nada simiyami ga taudi sisakosakowasi ta ꞌoba ꞌenega sigilegileꞌoasa. ꞌEnega ꞌaina ꞌediyega Paulo ꞌina guinuwa alena sinonona, taudi totaliya sinabwana, ꞌana esana Sikiba, natunao meꞌolotodi site sebeni. ꞌEnega site sebeni nidi sitoona ꞌaene ꞌInapwana Yesu ꞌana esanega yaluyaluwa biꞌi toleꞌoasao ꞌediyega sida ula apwesedi, ta ꞌebweu kabaleya sieonena, sigwae, “Yesu nina, Paulo ꞌiguguyae, tauna ꞌana esanega ꞌaloineyo be tai ꞌupilisine be ꞌutatauya.” ");
INSERT INTO dob_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ta yaluyaluwa biꞌi nina ꞌieonedi, “Yesu ta Paulo yamwalamwalatonidi, ta yaisigedi sana ꞌomi?” ");
INSERT INTO dob_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ꞌEnega tai nina ꞌigiekabaleyena, ta ꞌenega tai ꞌilosuyaena, ga toꞌoba nidi ꞌilosaiyedi, ga ꞌadi ꞌoamao ꞌisabuyauledi ta ꞌiunudi, ga bwala daisidi anuwega sidena. ");
INSERT INTO dob_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ta ale gete Epeso ꞌana tomiyanao maiboꞌadi sinonona ga simatauta, taudi me Yudia be taudi nigeya me Yudia, ta ꞌInapwana Yesu ꞌana esana siꞌawa waiwaiyena. ");
INSERT INTO dob_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ta toemisa auwaudi yaudi simai ga bodao matadiya ꞌidi bubuna guguyoi sisimanedi, ꞌaene taudi wate siꞌobaꞌoba. ");
INSERT INTO dob_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ta ꞌidi ꞌobao bukidi siegogonedima ga boda matadiya sigabu yauledi, ta buki nidi ꞌadi maisa sisawa egogonedi, ga pipiti tausani kina nadigega. ");
INSERT INTO dob_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Gote ꞌenega Yaubada ꞌina ona ꞌitabwa sinabwana, ta ꞌiewaiwai tomota yaudi ꞌediya. ");
INSERT INTO dob_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Muliyega Yaluyaluwa Tabuna Paulo ꞌienuwa saꞌuyena ꞌaene Masidonia be Akaya ꞌediyega ꞌida tauya, be Yelusalema ꞌena ꞌida apwesa, ga ꞌigwae, “Yanuganugana Yelusalema, ta yanuwena muliyega yatatauya Loma.” ");
INSERT INTO dob_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ꞌEnega tauna ꞌimiyami Esia tuta kukupana namo ꞌena, ta ꞌana tolemao nidi Timoti be Elasito ꞌietune nuganedi ga sitauya Masidonia. ");
INSERT INTO dob_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ta tuta gote ꞌena egewagewana sinabwana ꞌiapwesa Yesu ꞌina ꞌedaꞌeda manuna, ga gete nadigega ꞌiapwesaꞌesa. ");
INSERT INTO dob_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tai ꞌebweu ꞌana esana Dimitilo, tauna dayagi ꞌana toguinuwa siliba ꞌenega, ta me Epeso ꞌidi yaubada mewainena ꞌana esana Dayana ꞌina anuwa tapwalolo maꞌamaꞌayauna gidalidi ꞌidayagidi, ta ꞌiegiegimwaneyedi tomota ꞌediya, ga ꞌina esaesa sinabwana ꞌediyega ꞌilobaloba, ta tomota yaudi wate dayagi nidi siguiguinuwedi nadigega. ");
INSERT INTO dob_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ga Dimitilo ꞌina topaisewao ꞌibwau egogonedima, ta ꞌaidi wate ꞌidi guinuwa tauna nadigega, ga ꞌieonedi, ꞌigwae, “Gosegwao, wanuwaꞌiꞌisi ꞌaene paisewa gete ꞌenega ꞌida esaesa talobaloba, ");
INSERT INTO dob_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ta Paulo saꞌi niꞌatu tomota yaudi ꞌiꞌiꞌimidi ga ꞌigienuwa ꞌebuniyedi, ta ꞌionaona ꞌaene yaubadao tomota nimadiyega siꞌabidi nigeya Yaubada ꞌaiꞌailao, ta gete nigeya Epeso namo ꞌenaya, ta saꞌi sena yaudi Esia soladiya wate, ga ꞌomi niꞌatu wanonona ta waꞌitena Paulo nina ꞌina guinuwa, aga? ");
INSERT INTO dob_vpl 