﻿USE sofia;
DROP TABLE IF EXISTS sofia.dnv_vpl;
CREATE TABLE dnv_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dnv_vpl WRITE;
INSERT INTO dnv_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","အာဗြဟံရဲ့အမျိုးနဲ့ ဒါဝိဒ်ရဲ့ အမျိုးမှ ဆင်းသက်သော ယေရှုခရစ်ရဲ့ ဆွေစဉ်မျိုးဆက်များ စာရင်းမှာ ဟေလို့ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","အာဗြဟံဟ ဣဇက်ရဲ့ အဖ၊ ဣဇက်ဟ ယာကုပ်ရဲ့ အဖ၊ ယာကုပ်ဟ ယုဒနဲ့ သူ့ညီများရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ယုဒဟ ဖာရက်နဲ့ ဇာရရဲ့ အဖ သူလို့ အမေ့ဟ တာမာ ဖြစ်အယ်။ ဖာရက်ဟ ဟေဇရုံရဲ့ အဖ၊ ဟေဇရုံဟ အာရံရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","အာရံဟ အမိနဒပ်ရဲ့ အဖ၊ အမိနဒပ်ဟ နာရှုန်ရဲ့ အဖ၊ နာရှုန်ဟ စာလမုန်ရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","စာလမုန်ဟ ဗောဇရဲ့ အဖ၊ သူလို့ အမေ့ဟ ရာခပ် ဖြစ်အယ်။ ဗောဇဟ ဩဗက်ရဲ့ အဖ၊ သူ့လို့ အမေ့ဟ ရုသ ဖြစ်အယ်။ ဩဗက်ဟ ယေရှဲရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ယေရှဲယ ဆှင်ဘုရင် ဒါဝိဒ်ရဲ့ အဖ ဖြစ်အယ်။ ဒါဝိဒ်ဟ ရှောလမုန်ရဲ့ အဖ ဖြစ်အယ်။ ဥရိယရဲ့ ပေါင်အိုမ ဖြစ်ဖူးသောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ရှောလမုန်ဟ ရောဗောင်ရဲ့ အဖ၊ ရောဗောင်ဟ အဘိယရဲ့ အဖ၊ အဘိယဟ အာသရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","အာသဟ ယောရှဖတ်ရဲ့ အဖ၊ ယောရှဖတ်ဟ ယဟောရံရဲ့ အဖ၊ ယဟောရံဟ ဩဇိရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ဩဇိဟ ယောသံရဲ့ အဖ၊ ယောသံဟ အာခတ်ရဲ့ အဖ၊ အာခတ်ဟ ဟေဇကိရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ဟေဇကိဟ မနာရှေရဲ့ အဖ၊ မနာရှေဟ အာမုန်ရဲ့ အဖ၊ အာမုန်ဟ ယောရှိရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ဗာဗုလုန်မြို့ဟို ဣသရေလအမျိုးသားလို့အား ဖမ်းဆီးခေါ်ဆောင်သွားသော အချိန်တွင် ယောရှိဟ ယေခေါနိနဲ့ သူရဲ့ ညီအကိုများဟို ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ဗာဗုလုန်မြို့သို့ ဖမ်းဆီးခေါ်ဆောင်ခြင်း ခံရပင်းနောက်၊ ယေခေါနိဟ ရှာလသေလရဲ့ အဖ ဖြစ်အယ်။ ရှာလသေလဟ ဇေရုဗဗေလရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ဇေရုဗဗေလဟ အဗျုဒ်ရဲ့ အဖ၊ အဗျုဒ်ဟ ဧလျာကိမ်ရဲ့ အဖ၊ ဧလျာကိမ်ဟ အာဇော်ရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","အာဇော်ဟ ဇာဒုတ်ရဲ့ အဖ၊ ဇာဒုတ်ဟ အာခိမ်ရဲ့ အဖ၊ အာခိမ်ဟ ဧလုတ်ရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ဧလုတ်ဟ ဧလဇာရဲ့ အဖ၊ ဧလဇာဟ မဿန်ရဲ့ အဖ၊ မဿန်ဟ ယာကုပ်ရဲ့ အဖ၊ ");
INSERT INTO dnv_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ယာကုပ်ဟ ယောသပ်ရဲ့ အဖ၊ မာရိရဲ့ ဖိုးအို၊ ယေရှုရဲ့ အမေ့၊ ခရစ်တော်ဟူယွေ့ ခေါ်သောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","အဲလိုမို့ ဆွေစဉ်မျိုးဆက်အပေါင်းမှာ အာဗြဟံမှ ဒါဝိဒ်တိုင်အောန် တဆယ့်လေးဆက်၊ ဒါဝိဒ်မှ ဗာဗုလုန်မြို့ဟို နေရာပြောင်းလဲ့ တိုင်အောန် တဆယ့်လေးဆက်၊ ဗာဗုလုန်မြို့ဟို ပြောင်းခြင်းခံရလဲ့ အချိန်မှ မေဆှိယ တိုင်အောန် တဆယ့်လေးဆက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ယေရှု ခရစ်ဟ ဖွားမျော်ခြင်းမှာ ဟေလို့ဖြစ်အယ်။ ကိုယ်တော်ရဲ့ အမေ့ မာရိနဲ့ ယောသပ်လို့ လက်မထပ်ခင် စေ့စပ်ကျောန်းလမ်းထားပေမဲ့လည်း၊ မာရိဟ သန့်ဆှင်းသော ဝိညာဉ်တော်အားဖြင့် လူပဲ့စွဲကျောန်း တွေ့ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","သူရဲ့ ဖိုးအို ယောသပ်ဟ အမြဲတမ်း ဖြောင့်မတ်သောသူ ဖြစ်သောကျောန့် မာရိဟို လူသိဆှင်ကြား အဆှက်တကွဲ မဖြစ်စေလိုပါ။ အဲလိုမို့ သူဟ တိတ်တိတ်လေး စေ့စပ်ထားတာဟို ဖျက်မယ်လို့ စီစဉ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","သူဟ အဲအကျောန်းဟို စဉ်းစားနေခါ ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန်ဟ သူ့ရဲ့ အိမ်မက်ထဲမှာ ပေါ်လာယွေ့ “ဒါဝိဒ်အမျိုး ယောသပ် နင့်ရဲ့ ပေါင်အိုမ မာရိဟို ယူရမှာ မကြောက်နဲ့။ အကျောန်းမှာ ဟေလူပဲ့စွဲခြင်းဟာ သန့်ဆှင်းသော ဝိညာဉ်တော်ကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","သူဟ အောင်နီငယ်ဟို မွေးလိမ့်မယ်။ အဲအောင်နီငယ်ဟ မိမိလူလို့ဟို အပစ်မှ ကယ်ချွတ်မယ့်သူ ဖြစ်သောကျောန့် ယေရှုဆိုသော နာမယ် ပေးရမယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","အဲအကျောန်းအရာဟ ပရောဖက်အားဖြင့် ဘုရားသခင်ဟောခဲ့လဲ့ အတိုင်း အမန်တကယ် ဖြစ်ပျက်လာခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ဗျာဒိတ်တော်မှာ “အပျိုကညာဟ လူပဲ့စွဲယူယွေ့ အောင်နီငယ်ဟို ဖွားမျော် လိမ့်မယ်။ အဲအောင်နီငယ်ဟို ဧမာနွေလ နာမယ်ပေးရမယ်” (အေးအဓိပ္ပာယ်ဟ “ဘုရားသခင်ဟ ငါလို့နဲ့အတူ ဆိအယ်”) ဟု ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ယောသပ်ဟ အိပ်မွေ့ရာမှ နိုးလာသောအခါ ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန် မှာထားလဲ့အတိုင်း မိမိရဲ့ပေါင်အိုမဟို လက်ထပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","အဲလိုလဲ သူဟ အောင်နီငယ်ဟို မမွေးသေးခင်အထိ မာရိနဲ့ ပေါင်းသင်းနေထိန်မှုဟို မလုပ်ဘဲ နေအယ်။ သူဟ အဲအောင်နီငယ်ဟိုလည်း ယေရှု ဟူသော နာမယ်ပေး လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ဟေရုဒ် မင်းကြီးလက်ထက် အချိန်ကာလအတွင်း ယေရှုဟ ယုဒပြေ ဗက်လင်မြို့တွင် ဖွားမျော်ပင်းနောက် အဆေ့တိုင်းနိုင်ငံမှ နက္ခတ်ပညာဆှင်အချို့လို့ဟ ယေရုရှလင်မြို့ဟို ရောက်လာကြယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“အခု ဖွားမျော်သော ယုဒ ဘုရင်ဟ၊ ဖယ်နားမှာ ဆိလုန်း။ အဆေ့ပြေနှိုက် သူရဲ့ကြယ်ဟို ငါလို့ မျော်ရတာ ဖြစ်ယွေ့ သူ့ဟို ဖူးမြော်ဖို့ရန် လာပီ” ဟု မေးမြန်းပြောဆို ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","အဲအကျောန်းဟို ကြားသောအခါ ဟေရုဒ်မင်းကြီးဟ၊ ယေရုရှလင်မြို့သူမြို့သားအပေါင်းလို့နဲ့တကွ ရမ်းဆာ့ တုန်လှုပ်ချောက်ချား လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ဟေရုဒ်မင်းကြီးဟ ယဇ်ပုရောဟိတ်ကြီးလို့နဲ့ လူလို့တွင် ကျမ်းပြုဆရာလို့ဟို စုဝေးစေယွေ့ မေဆှိယဟို ပစာအရပ်မှာ ဖွားမျော်မယ်ဟို သူလို့အား မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","သူလို့ဟလည်း “ယုဒပြေ ဗက်လင်မြို့နှိုက် ဖြစ်အယ်” ဟု ပြန်ပြောအယ်။ “အကျောန်းမှာ ပရောဖက် တဦးရဲ့ ရေးသားချက်မှာ၊ ");
INSERT INTO dnv_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘အို၊ ယုဒပြေ ဗက်လင်မြို့၊ နင်ဟ ယုဒပြေဟို အုပ်ချုပ်သောမြို့လို့တွင် အသေးသိမ်ဆုံး မဟုတ်၊ အကျောန်းမှာ ငါရဲ့လူစု ဣသရေလအမျိုးဟို ယိုးမယ့် ခေါင်းဆောင်တဦး နင်လို့အထဲမှာ ပေါ်ထွန်းလိမ့်မယ်’ ဟု ဆှောက်ထားအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","အဲပင်းရင် ဟေရုဒ်မင်းကြီးဟ နတ်က္ခပညာဆှင်လို့ဟို တိတ်တိတ်လေးခေါ်ပင်း မေးမြန်းရာတွင် သူလို့ဆေမှ ကြယ်ပေါ်ထွန်းသော အချိန်ကာလဟို အတိအကျ သိဆိသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","“သွားယွေ့ လူပဲ့ငယ်ဟို ကြိုးစား ဆာကြမန့်။ နင်လို့ သူ့ဟို တွေ့သောအခါ ပြန်လာယွေ့ ငါဟို ပြောကြားလော့။ အဲလို့မှ ငါလည်း သွားယွေ့ အေးလူပဲ့ငယ်ဟို ဖူးမြော်ရအောန်” ဟု မှာထားလျက်၊ သူလို့အား ဗက်လင်မြို့ဟို စေလွှတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","အဲသူလို့ဟ မင်းကြီးစကားဟို နားထောင်ပင်းနောက် ထွက်သွားကြယွေ့ အဆေ့ပြေနှိုက် သူလို့ မျော်ခဲ့သော ကြယ်ဟ လူပဲ့ငယ်ဆိရာ နေရာပေါ်ရောက်ယွေ့ တန့်လဲ့တိုင်အောန် သူလို့အဆေ့ဟ သွားလေအယ်။ သူလို့ဟ အဲကြယ်ဟို မျော်သောအခါ ရမ်းဆာ့ ဝမ်းမြောက်ဝမ်းသာခြင်း ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","သူလို့ဟ နေအိုင်ဟို ဝင်ယွေ့ မယ်တော်မာရိနဲ့တကွ လူပဲ့သငယ်ဟို မျော်သောအခါ ဒူးထောက်ယွေ့ ရှိခိုးကြအယ်။ သူလို့ရဲ့ ဘဏ္ဍာကြုတ်လို့ဟို ဖွင့်ပင်းမှ ဆွေ၊ လောဗန်နဲ့ မုရန်တည်းဟူသော လက်ဆောင်များဟို ဆက်သကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","အေးနောက်မှ ဟေရုဒ်မင်းကြီး ဆေဟို မပြန်ရမဲ့အကျောန်း အိမ်မက်တွင် ဘုရားသခင် သတိပေးယွေ့ မိမိလို့ ပြေဟို တခြားလမ်းဖြင့် ပြန်သွား ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","အဲသူလို့ သွားပင်းနောက်၊ ယောသပ် အိမ်မက်ထဲမှာ ထာဝရဘုရားရဲ့ ခေါန်းခင်တမန်ဟ ပေါ်လာပင်း “ဟေရုဒ်မင်းကြီးဟ လူပဲ့သငယ်ဟို သတ်ဖို့ရန် ဆှာကြံနေအယ်။ အဲလိုမို့ ထလော့၊ မယ်တော်နဲ့ လူပဲ့သငယ်ဟို ယူပင်းယင် အဲဂုတ္တုပြေဟို သွားလော့။ ငါထွက်သွားဖို့ ဟောလဲ့တိုင်အောန် အဲပြေနှိုက် နေလော့” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","အဲလိုမို့ ယောသပ်ဟ ထပင်း၊ မယ်တော်နဲ့ လူပဲ့သငယ်ဟို ညအချိန်တွင်း ခေါ်ယူပင်းရင် အဲဂုတ္တုပြေဟို ထွက်သွားယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","သူဟ ဟေရုဒ်မင်းကြီး အနိစ္စရောက်လဲ့တိုင်အောန် အေးပြေမှာ နေလေအယ်။ အဲစာဟ “ငါ့သားဟို အဲဂုတ္တုပြေမှ ငါခေါ်ခဲ့ပီ” ဟု ထာဝရဘုရားဟ ပရောဖက်အားဖြင့် ထားသော ဗျာဒိတ်တော် ပြေ့စုံမယ့်အကျောန်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","အဲအခါ ဟေရုဒ်မင်းကြီးဟ မာဂုပညာဆိလို့ လှည့်စားတာဟို သိရင်၊ သူဟ ရမ်ဆာ့အူထော့ယွေ့ မာဂုပညာဆိဆေမှ သေချာစွာလေ့လာ စီစစ်ထားလဲ့ အချိန်ကာလအရ၊ ဗက်လင်မြို့နဲ့ ၎င်းအရပ်ဒေသတဝိုက်ဆိသော အသက်နေနှစ်အရွယ်နဲ့ အေးအောင်နီငယ်အားလုံးဟို သတ်ရန် အမိန့်ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","အေးနောက် ပရောဖက် ယေရမိအားဖြင့် မိန့်တာဟ ");
INSERT INTO dnv_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ရာမ အရပ်တွင် ငိုကခြင်းနဲ့ ကြီးစွာသော မြည်တမ်းခြင်း အသံဟို ကြားရအယ်၊ ရာခေလဟ မိမိရဲ့ လူပဲ့သငယ်များအတွက် ငိုကကာ၊ သူလို့ဟ နောက်ထပ် မဆိကြသောကျောန့် သူ့အား နှစ်သိမ့်ယွေ့ မရနိန်” ဟု ဆိုတာဟ ပြေ့စုံလာခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ဟေရုဒ်မင်းကြီး အနိစ္စရောက်ပင်းနောက်၊ ထာဝရဘုရားရဲ့ ခေါန်းခင်တမန်ဟ အဲဂုတ္တုပြေနှိုက် ယောသပ်ရဲ့ အိမ်မက်ထဲမှာ ပေါ်လာပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ထလော့၊ မယ်တော်နဲ့ လူပဲ့သငယ်ဟို ခေါ်ပင်းရင် ဣသရေလပြေဟို သွားလော့၊ လူပဲ့သငယ်ရဲ့ အသက်ဟို သတ်ဖို့ ဆာသော သူလို့ဟ သေကြပီ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","အဲအခါ ယောသပ်ဟ ထယွေ့ မယ်တော်နဲ့ လူပဲ့သငယ်ဟို ခေါ်ပင်းရင် ဣသရေလပြေဟို ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","အဲလိုလဲ အာခေလဟ သူ့ရဲ့အဖ ဟေရုဒ်မင်းကြီးအရာဟို ဆက်ခံလျက် ယုဒပြေတွင် အုပ်ချုပ်နေကျောန်းဟို သူဟ ကြားသောအခါ၊ အဲပြေဟို သွားရန် ကြောက်ရွံ့ လေအယ်။ အိမ်မက်တွင် ညွန်ကြားချက်ကို ရပင်းမှ ဂါလိလဲပြေဟို သွားယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","နာဇရက် နာမယ်တွင်သော မြို့တွင် နေထိန်လေအယ်။ “ကိုယ်တော်ဟို နာဇရက်မြို့သား ဟု ခေါ်ဝေါ်ကြရ လိမ့်မယ်” ဟူသော ပရောဖက်များရဲ့ ဟောပြောချက် အမန် ဖြစ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","အဲအခါကာလနှိုက် နှစ်ခြင်းဆရာ ယောဟန်ဟ ယုဒ တောကန္တာရဟို လာပင်း စတင် ဟောပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“နင်လို့ အပစ်များမှ နောင်တရပင်း လှည့်ပြန်ကြလော့၊ ပစာကို့ ခေါန်းခင်နိုင်ငံတော် တည်လုနီးပီ” ဟု ဟောပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ပရောဖက် ဟေရှာယဟ၊ “ ‘ထာဝရဘုရားအတွက် လမ်းဟို ပြင်ဆင်ကြလော့၊ သူရဲ့ လမ်းခရီးတော်ဟို ဖြောင့်တန်းအောန် ပြုကြလော့’ ဟု တောကန္တာရနှိုက် လူတယောက် အော်လျက်နေအယ်” ဟူယွေ့ ဆိုထားတာဟ ယောဟန်ရဲ့အကျောန်းပင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ယောဟန်ဟ ကုလားအုတ်မွေးနဲ့ ရက်သော အဝတ်ဟို ဝတ်ယွေ့၊ သူရဲ့ ခါးနှိုက် သားရေ ခါးကြိုးဟို စဲထားအယ်။ သူရဲ့ အစားအစာမှာ ပလံမစိမ်းနဲ့ တောပျားရည် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ယေရုရှလင်မြို့၊ ယုဒပြေတပြေလုံးနဲ့ ယော်ဒန်မြစ် ပတ်ဝန်းကျင် တဆှောက်လုံးနှိုက်ဆိသော လူလို့ဟ ယောဟန်ဆေဟို လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","သူလို့ဟ မိမိလို့ရဲ့ အပစ်များဟို ဖော်ပြဝန်ခံကြပင်း၊ ယောဟန်ဟ ယော်ဒန်မြစ်တွင် သူလို့အား နှစ်ခြင်းဟို ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ဖာရိရှဲနဲ့ ဇဒ္ဒုကဲအများလို့ဟ နှစ်ခြင်းခံယူရန် လာကြတာဟို မျော်သောအခါ ယောဟန်ဟ သူလို့အား “အချင်းမြွေပွေးလို့၊ ရောက်လာမယ့် အူထော့ခြင်းဘေးမှ လွတ်မြောက်နိန်တယ် ဟု နင်လို့အား စလူဟ သတိပေးလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","နောင်တနဲ့ ထိုက်တန်သော အကျင့်ဟို ကျင့်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘အာဗြဟံဟ ငါလို့ရဲ့ ဖိုးဖေး ဖြစ်အယ်’ ဟု နင်လို့တတ်တိုင်း ပြောဆိုရန်ပင် မစဉ်းစားကြနဲ့။ နင်လို့အား ငါပြောတာဟ ဘုရားသခင်သည် အာဗြဟံအတွက် လူပဲ့သငယ်များဟို ဟေကျောက်ခဲလို့ထဲမှ ပေါ်ထွန်းစေနိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ပေါက်ဆိန်ဟို သစ်ပင်တွေရဲ့ အမြစ်နားမှာ အဆင်သင့် ချထားပင်း၊ ကောင်းသော အသီးမသီးသောအပင် ဆိသမျှဟ ခုတ်လှဲယွေ့ မီးထဲဟို လောချခြင်း ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","နင်လို့ နောင်တရလဲ့အတွက် ငါဟ ယေနှိုက် နှစ်ခြင်းဟို ပေးအယ်။ အဲလိုလဲ ငါထက်ကြီးမြတ်သောသူဟ နောက်တွင် ကြွလာမယ်၊ ငါဟ သူရဲ့ ဖိနပ်ဟိုမျှ ကိုင်ဆောင်ရန် မထိုက်တန်ပါ။ သူဟ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ မီးနှိုက် နင်လို့ဟို နှစ်ခြင်း ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","သူ့ရဲ့ လက်တော်တွင် စပါးလှေ့ရန် ဆန်ကောဟို ကိုင်လျက် မိမိရဲ့ ကောက်နယ်တလင်းဟို ဆှင်းလင်းအယ်။ သူဟ ဂျုံစပါးဟို ကျီတွင် စုသိမ်းယွေ့၊ အဖျင်းများဟိုဟ မငြိမ်းနိန်သော မီးနဲ့ ရှို့လိမ့်မယ်” ဟု ယောဟန်ဟ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","အဲအချိန်အခါနှိုက် ယေရှုဟ ဂါလိလဲပြေမှ ရောက်လာပင်း၊ ယော်ဒန်မြစ်နားဆိ ယောဟန်ဆေတွင် နှစ်ခြင်းခံယူရန် လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","အဲလိုလဲ ယောဟန်ဟ ကိုယ်တော်ရဲ့ စိတ်ဟို ပြောင်းလဲဖို့ ကြိုးစားလျက် “ငါဟ ကိုယ်တော်ဆေတွင် နှစ်ခြင်းဟို ခံယူသင့်သူဖြစ်ပါလျက် ကိုယ်တော်ဟ ငါ့ဆေဟို ကြွလာပါသလော့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","အဲလိုလဲ ယေရှုဟ သူ့ဟို “အခုအတွက် အခွင့်ပေးလော့။ အကျောန်းမှာ ဟေနည်းအားဖြင့် ငါလို့ဟ ဘုရားသခင် အလိုဆိသမျှဟို ဟေသို့ ပြေ့စုံသင့်အယ်” ဟု မိန့်အယ်။ အဲလိုမို့ ယောဟန်ဟ သဘောတူလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ယေရှုဟ နှစ်ခြင်းဟို ခံယူပင်းချင်း ယေမှ ပေါ်ထလာအယ်။ အေးနောက် မိုးခေါန်းခင်ဟ ပွင့်သဖြင့်၊ ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်ဟ ချိုးတူးမပုံစံလို ဆင်းလာယွေ့ ကိုယ်တော်ရဲ့ အပေါ်မှာ နားတာဟို မျော်ဟယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","အေးနောက် “ဟေသူဟ ငါ နှစ်သက်မြတ်နိုးရာ၊ ငါရဲ့ ချစ်သား ဖြစ်အယ်” ဟု ခေါန်းခင်မှ အသံတော် ပေါ်ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","အေးနောက် မာရ်နတ်ရဲ့ စုံစမ်းသွေးဆောင်ခြင်းဟို ခံစေမို့ ဝိညာဉ်တော်ဟ ယေရှုဟို တောကန္တာရထဲဟို ယိုးသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ယေရှုဟ နေ့ပေါင်းလေးဆယ်နဲ့ ညပေါင်းလေးဆယ် အစာဆှောင်ပင်းနောက် မွတ်ယွေ့ လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","အဲအခါ မာရ်နတ်ဟ သူ့ဆေဟို လာပင်း “နင်ဟ ဘုရားသခင်ရဲ့ သားတော်ဟုတ်ရင်၊ ဟေကျောက်ခဲများဟို မုန့်ဖြစ်လာအောန် အမိန့်ပေးမန့်” ဟု ဟောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ယေရှုဟလည်း “ ‘လူဟ မုန့်တခုတည်းအားဖြင့်သာ အသက်ဆှင်တာ မဟုတ်ဘဲ ဘုရားသခင်ရဲ့ နှုတ်တော်ထွက် စကားဆိသမျှအားဖြင့် အသက်ဆှင်ရမယ်လို့ ကျမ်းစာလာအယ်’ ” ဟူယွေ့ မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","အဲပင်းရင် မာရ်နတ်ဟ ကိုယ်တော်ဟို သန့်ဆှင်းသော မြို့တော်ဟို ခေါ်ဆောင်သွားပင်း ဗိမာန်တော် ထိပ်ဖျားနှိုက် ရပ်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“နင်ဟ ဘုရားသခင်ရဲ့ သားတော် ဟုတ်ရင်၊ နင့်တတ်တိုင်း အောက်ဟို ခုန်ချပါ” ဟု သူဟ ပြောအယ်။ အကျောန်းမှာ “ ‘နင့်အတွက် ခေါန်းခင်တမန်များဟို မှာထားအယ်၊ အဲလိုမို့ နင့်ရဲ့ ခြေဟို ကျောက်နဲ့ မခိုက်မိစေရန်၊ သူလို့ လက်နဲ့ နင့်ဟို ချီမကြ လိမ့်မယ်’ ဟု ကျမ်းစာရေးထားအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ယေရှုဟလည်း “ ‘နင့်ရဲ့အဆှင် ဘုရားသခင်ဟို အစုံစမ်း မပြုရ’ ဟူယွေ့လည်း ကျမ်းစာနှိုက် ရေးထားအယ်” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","တခါ မာရ်နတ်ဟ ယေရှုဟို ရမ်းဆာ့ မြင့်သော တောင်ပေါ်ဟို ခေါ်သွားပင်း လောကနိုင်ငံဆိသမျှနဲ့ အဲနိုင်ငံလို့ရဲ့ ဘုန်းစည်းစိမ်ဟို ယိုးပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“နင်ဟ ငါ့ဟို ဦးချရှိခိုးမယ်ဆိုရင် ဟေအရာအားလုံးဟို ငါပေးမယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ယေရှုဟ သူ့အား “အချင်း စာတန်၊ ငါ့နားဟနေပင်း သွားလော့၊ ‘နင့်ရဲ့ အဆှင် ဘုရားသခင်ဟိုသာလျှင် ဝတ်ပြုရှိခိုးရမယ်၊ အဲအဆှင်ရဲ့ အစေဟိုသာလျှင် ခံရမယ်’ ဟု ကျမ်းစာနှိုက် ရေးထားအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","အဲအခါ မာရ်နတ်ဟ ယေရှုဆေမှ ထွက်သွားပင်းနောက် ခေါန်းခင်တမန်လို့ဟ သူ့ဆေဟို လာယွေ့ ကူညီကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ယေရှုဟ ယောဟန် ထောင်ထဲမှာ အဖမ်းခံရကျောန်းဟို ကြားသောအခါ ကိုယ်တော်ဟ ဂါလိလဲပြေဟို ထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ယေရှုဟ နာဇရက်မြို့တွင် မနေဘဲ ဇာဗုလုန်နဲ့ နဿလိစပ်ကြား၊ ဂါလိလဲအိန်နီးဆိ ကပေရနောင်မြို့ဟို သွားပင်း နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ဟေလို့ပြုရခြင်းမှာ ပရောဖက် ဟေရှာယရဲ့ ဟောကြားချက် မန်ကန်လာစေရန် ဖြစ်အယ်။ ပရောဖက်ဟေရှာယဟ၊ ");
INSERT INTO dnv_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ဇာဗုလုန်နယ်နဲ့ နဿလိနယ်၊ ယောဒန်မြစ်တဖက်ကမ်း၊ ပင်လယ်လမ်းတဆှောက် လူမျိုးခြားလို့ နေထိန်ရာ ဂါလိလဲပြေ၊ ");
INSERT INTO dnv_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","မိုက်ထဲမှာ နေထိန်ကြသော သူလို့ဟ တောက်ပသော အလင်းရောင်ဟို မျော်ရလေပီ။ သေမင်းအရိပ်တွင် နေထိန်ကြသူလို့ရဲ့ အပေါ် အလင်းရောင် သက်ရောက်လိမ့်မယ်” ဟု ဟောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","အဲအခါမှစပင်း ယေရှုဟ “နင်လို့ အပစ်များမှ နောင်တရပင်း လှည့်ပြန်ကြလော့။ အကျောန်းမှာ ခေါန်းခင်နိုင်ငံတော် တည်လုနီးပီ” ဟု ဟောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ယေရှုဟ ဂါလိလဲအိန်အနီးတွင် ဆှောက်သွားရင်း တံငါသည် ညီအကို နေယောက်ဖြစ်သော၊ ပေတရု ခေါ် ရှိမုန်နဲ့ သူရဲ့ ညီအန္ဒြေလို့ ဖြစ်ပင်း၊ အိန်ထဲတွင် ပိုက်ကွန်ပစ်လျက်နေကြတာဟို မျော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ယေရှုဟ “လာကြ၊ ငါ့နောက်ဟို လိုက်ကြ။ နင်လို့ဟို လူဟိုမျှားလဲ့ တံငါသည်များ ဖြစ်စေမယ်” ဟု သူလို့ဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","သူလို့ဟ ခုတုံးပင် မိမိလို့ရဲ့ ပိုက်ကွန်များဟို လောပစ်ယွေ့ သူ့နောက်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ယေရှုဟ အဲအရပ်မှ ဆက်ယွေ့ ဆှောက်သွားစဉ်၊ အခြား ညီအကို နေယောက်ဖြစ်လဲ့ ဇေဗေဒဲရဲ့သား ယာကုပ်နဲ့ သူရဲ့ညီယောဟန်လို့ဟို မျော်အယ်။ မိမိလို့ အဖ ဇေဗေဒဲနဲ့အတူ လှေထဲတွင် ပိုက်ကွန်များဟို အသင့်ပြင်လျက် ဆိအယ်။ ယေရှုဟ သူလို့ဟို ခေါ်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","သူလို့ဟ ခုတုံးပင် လှေနဲ့ သူလို့အဖဟို ထားခဲ့ပင်း ကိုယ်တော်ရဲ့ နောက်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ယေရှုဟ ဂါလိလဲပြေတဆှောက်လုံး ပတ်သွားပင်း၊ တရားဇရပ်များတွင် သွန်သင်ကာ၊ နိုင်ငံတော်နဲ့ယှဉ်သော သတင်းကောင်းဟို ဟောပင်း၊ လူလို့တွင် အနာရောဂါအမျိုးမျိုးနဲ့ အဖျားအနာဆိသမျှလို့ဟို ငြိမ်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ယေရှုရဲ့ သတင်းဟ ရှုရိပြေ တဆှောက်လုံးတွင် ပျံ့သွားပင်း၊ လူလို့တွင် နတ်ဆိုးဝင်သောသူ၊ ဝက်ရူးစွဲသောသူ၊ လေဖြတ်သောသူ၊ မကျန်းမာသောသူမှ စယွေ့ အမျိုးမျိုးသော အနာရောဂါစွဲကပ်သူ ဝေဒနာဆှင်များဟို အထံတော်သို့ ခေါ်ခဲ့ကြပင်း ယေရှုဟ အဲလူအပေါင်းလို့ဟို ရောဂါပျောက်ကင်း စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ဂါလိလဲပြေ၊ ဒေကာပေါလိပြေ၊ ယေရုရှလင်မြို့၊ ယုဒပြေနဲ့ ယော်ဒန်မြစ်တဖက်ကမ်းမှ လူအုပ်များဟ ယေရှုရဲ့ နောက်တော်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ယေရှုဟ လူအုပ်လို့ဟို မျော်ရင် တောင်ပေါ်ဟို တက်ယွေ့ အဲမှာ ထိန်အယ်။ ကိုယ်တော်ရဲ့ တဘဲ့တော်လို့ဟ အထံတော်ဟို လာကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","အားပင်း ယေရှုဟ သူလို့ဟို သင်ကြားတာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“စိတ်နေလုံး နှိမ့်ချသောသူလို့ဟ မင်္ဂလာဆိ ကြအယ်၊ အကျောန်းမှာ ခေါန်းခင်နိုင်ငံတော်ဟ အဲသူလို့ရဲ့ နိုင်ငံ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","စိတ်မသာ ညည်းတွားသောသူလို့ဟ မင်္ဂလာဆိ ကြအယ်၊ အကျောန်းမှာ ဘုရားသခင်ဟ သူလို့အား နှစ်သိမ့်မှုဟို ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","စိတ်နေလုံး နှိမ့်ချသောသူလို့ဟ မင်္ဂလာဆိ ကြအယ်၊ အကျောန်းမှာ အဲသူလို့ဟ ဘုရားသခင် ကတိထားသော အရာဟို ရဆိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ဘုရားသခင်ရဲ့ အလိုတော်နဲ့အညီ လိုက်နာရန် လိုလားတောင်းတသောသူလို့ဟ မင်္ဂလာဆိ ကြအယ်၊ အကျောန်းမှာ ဘုရားသခင်ဟ သူလို့ဟို အပြေ့အဝ ကျေနပ်စေ လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","သနားကြင်နာသောသူလို့ဟ မင်္ဂလာဆိ ကြအယ်၊ အကျောန်းမှာ ဘုရားသခင်ဟ အဲသူလို့အား သနားကြင်နာ လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","စိတ်နေလုံး ဖြူစင်သောသူလို့ဟ မင်္ဂလာဆိ ကြအယ်၊ အကျောန်းမှာ အဲသူလို့ဟ ဘုရားသခင်ဟို မျော်ရကြ လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ငြိမ်းချမ်းရေးအတွက် ဆောင်ရွက်သောသူလို့ဟ မင်္ဂလာဆိ ကြအယ်၊ အကျောန်းမှာ အဲသူလို့ဟ ဘုရားသခင်ရဲ့ လူပဲ့သငယ်များဟု အခေါ်ခံရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ဘုရားသခင်ရဲ့ အလိုတော်နဲ့အညီ ဆောင်ရွက်သဖြင့် နှိပ်စက်ညှဉ်းဆဲခံရသော သူလို့ဟ မင်္ဂလာဆိ ကြအယ်၊ အကျောန်းမှာ ခေါန်းခင်နိုင်ငံတော်ဟ အဲသူလို့ရဲ့ နိုင်ငံ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“နင်လို့ဟ ငါ့နောက်ဟို လိုက်သောကျောန့် လူလို့ရဲ့ အမျိုးမျိုးမဟုတ်ကဟုတ်က ဝါခြင်းဟို ခံရပင်း၊ နှိပ်စက်ခံရခြင်းနဲ့ စော်ကားခံရသောအခါ နင်လို့ဟ မင်္ဂလာဆိ ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ရွှင်လန်းဝမ်းသာကြလော့၊ ခေါန်းခင်ဘုံတွင် နင်လို့ရမဲ့ ဆုဟ ကြီးအယ်။ ဟိုအရင်ခါဟ ဆိခဲ့လဲ့ ပရောဖက်လို့ဟို အေးတိုင်းတိုင်း နှိပ်စက်ခံရကြပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“နင်လို့ဟ လောကရဲ့ ဆားနဲ့ တူကြအယ်။ အဲလိုလဲ ဆားဟ အငန်ပျောက်သွားရင်၊ ပစာလိုပြန်ပင်း ငန်အောန် လုပ်နိန်မလဲ။ ပစာမျှ သုံးစားရဘဲ အပြင်ဟို ဝဲလိုက်ယွေ့ လူလို့ဟ ခွနင်းသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“နင်လို့ဟ လောကရဲ့ အလင်းနဲ့ တူကြအယ်။ တောင်ပေါ်မှာ တည်သောမြို့ဟို ဖုံးကွယ်ယွေ့ မထားနိန်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ဆီမီးဟို ထွန်းယွေ့ တောင်းနဲ့အုပ်ပင်း မထားတတ်ကြ။ အဲအစား အိုင်သူအိုင်သားအပေါင်းလို့ အလင်းရောင်ရစေရန် ဆီမီးခုံပေါ်မှာသာ တင်ထားတတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","အေးတိုင်းတိုင်း လူလို့ဟ နင်လို့ရဲ့ ကောင်းသောအကျင့်ဟို မျော်ယွေ့ ခေါန်းခင်ဘုံနှိုက်ဆိသော နင်လို့အဖရဲ့ ဂုဏ်တော်ဟို ချီးမွန်းစေရန် နင်လို့ရဲ့ အလင်းဟို လူလို့ရဲ့ ဆေ့မှာ ထွန်းလင်းစေကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“မောရှေရဲ့ ပညတ္တိကျမ်းနဲ့ ပရောဖက်ကျမ်းများဟို ဖျက်သိမ်းရန် ငါလာတာလို့ မထင်ကြနဲ့။ အဲကျမ်းများတွင် ဆိလဲ့အတိုင်း ပြေ့စုံစေရန်သာ ငါ လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ငါအမန်ဆိုတာဟ ခေါန်းခင်နဲ့ မြေကြီး မပျောက်ကွယ်မီတိုင်အောန်၊ ပညတ်ကျမ်းနှိုက် အသေးဆုံး စာလုံးတလုံး၊ ဗိန္ဒုတလုံးမျှ ပြေ့စုံခြင်းဟို မရောက်ခင် မပျက်စီးရ။ အေးကျမ်းတွင် ဖော်ပြထားလဲ့ အမှုအရာအလုံးစုံလို့ဟ ဖြစ်ပျက်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ပစာကို့ အကြင်သူဟ အသေးဆုံး ပညတ်တခုဟို တတ်တိုင်းလွန်ကျူးယွေ့ သူတပါးလို့အားလည်း အေးတိုင်းတိုင်း သင်ကြားသော အဲသူဟ ခေါန်းခင်နိုင်ငံတော်နှိုက် အငယ်ဆုံးသောသူ ဖြစ်လိမ့်မယ်။ အဲလိုလဲ အကြင်သူဟ တတ်တိုင်းကျင့်ယွေ့ သူတပါးလို့အားလည်း သင်ကြားပေးသူဟ ခေါန်းခင်နိုင်ငံတော်တွင် အကြီးဆုံးသောသူ ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","အကျောန်းမှာ ငါအမန်အကန်ဆိုတာဟ နင်လို့ရဲ့ ဖြောင့်မတ်ခြင်းဟ ကျမ်းတတ်ဆရာများနဲ့ ဖာရိရှဲများထက် မသာရင် နင်လို့ဟ ခေါန်းခင်နိုင်ငံတော်ဟို စခါမှ ဝင်ရလိမ့်မယ် မဟုတ်ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ ‘လူအသက်ဟို မသတ်ရ။ စသူမဆို ပစ်မှုကျူးလွန်သူဟို ရုံးတင်စစ်ဆေးရမယ်’ ဟု အရင်ခါဟ လူတွေပြောခဲ့တာဟို နင်လို့ ကြားရပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","အဲလိုလဲ နင်လို့အား ငါပြောတာဟ တစုံတယောက်သည် မိမိရဲ့ ညီအကိုအား အူထော့သော သူဟ ရုံးတင်စစ်ဆေး ရမယ်။ နောက်တခါ တစုံတယောက်ဟ မိမိရဲ့ ညီအကိုအား ‘အလကားလူ’ ဟု ပြောသောသူဟ တရားရုံးတွင် စစ်ဆေးခြင်း ခံထိုက်အယ်။ အားပင်း တစုံတယောက်ဟ ‘လူမိုက်’ ဟု ပြောသောသူဟ ငရဲမီးအိန်ထဲဟို သွားဖို့ ထိုက်တန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","အေးလို့မို့ နင်ဟ ယဇ်ပလ္လင်တွင် ပူဇော်သကာ ဆက်သမယ်ပြုစဉ် မိမိအပေါ်နှိုက် ညီအကိုဟ နင့်အား တစုံတခုမကျေနပ်မှုဟို သတိရခဲ့ရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ပူဇော်သကာဟို အဲယဇ်ပလ္လင် ဆေ့တွင် ထားလော့။ ဦးရင်ဆုံး သူလို့ဆေ သွားယွေ့ သူနဲ့ သင့်မြတ်အောန် ပြုလော့၊ အဲပင်းရင် ပြန်လာပင်း နင်ရဲ့ ပူဇော်သကာဟို ဆက်သလော။ ");
INSERT INTO dnv_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“တစုံတယောက်ဟ ရုံးတွင် နင့်ဟို တရားစွဲရင် သူနဲ့အတူ လမ်းခရီးနှိုက်ဆိနေစဉ် သူနဲ့လျင်မြန်စွာ အဆင်ပြေအောန် ပြုလော့။ အေးလို့မဟုတ်ရင် သူဟ နင့်ဟို တရားသူကြီးရဲ့ လက်ဟို အပ်ယွေ့ တရားသူကြီးဟလည်း ထောင်မှုးလက်ဟို အပ်ပင်း နင့်ဟို ထောင်ချထား လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ငါအမန်တကယ် နင်လို့အား ပြောတာဟ၊ ပေးရန်ဆိသော ငွေအားလုံးဟို မပေးမချင်း နင်ဟ ထောင်ထဲမှ ထွက်ရလိမ့်မယ် မဟုတ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ ‘အိုင်ထောင်ရေးဖောက်ပြန်မှုဟို မကျူးလွန်ရ’ ဟု ပြောထားတာဟို နင်လို့ ကြားရလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","အဲလိုလဲ နင်လို့အား ငါပြောတာဟ တစုံတယောက်သည် တပ်မက်သောစိတ်နဲ့ အမျိုးသမီးတဦးဟို ကျေ့သူဟ မိမိရဲ့ စိတ်တွင် အဲအမျိုးသမီးဟို ပစ်မားပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","နင့်ရဲ့ လက်ယာမျက်စေ့ဟ နင်ဟို မားယွင်းစေရင် အဲမျက်စေ့ဟို ဆယ်ယွေ့ လောပလိုက်လော့။ နင်ရဲ့ ခန္ဓာကိုယ်တခုလုံး ငရဲဟိုသွားရတာထက် ကိုယ်အင်္ဂါတခု ချို့တဲ့ရခြင်းဟ သာယွေ့ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","နင့်ရဲ့ လက်ယာလက်ဟ နင့်ဟို မားယွင်းစေရန် အဲလက်ဟို ဖြတ်ယွေ့ လောပလိုက်လော့။ နင်ရဲ့ ခန္ဓာကိုယ်တခုလုံး ငရဲဟို သွားရတာထက် ခန္ဓာကိုယ်တခု ချို့တဲ့ရခြင်းဟ သာယွေ့ ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ ‘မိမိရဲ့ ပေါင်အိုမနဲ့ ကွာဆှင်းလိုသူဟ ဖြတ်စာဟို ပေးအပ်ရမယ်’ လို့ ပြောထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","အဲလိုလဲ ငါ နင့်ဟို ပြောတာဟ တစုံတယောက်သည် မတရားသော မေထုန်ပြုခြင်း အကျောန်းမှလွဲယွေ့ မိမိပေါင်အိုမဟို ကွာဆှင်းသောသူတိုင်းဟ အေးပေါင်အိုမအား အိုင်ထောင်ရေးဖောက်ပြန်မှုဟို ကျူးလွန်စေအယ်။ ကွာဆှင်းထားသော ပေါင်အိုမနဲ့ လက်ထပ်ခြင်းဟို ပြုသောသူဟလည်း အိုင်ထောင်ရေးဖောက်ပြန်မှုဟို ကျူးလွန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“နောက်တခါ ‘နင်ဟ ကျိန်ဆိုခြင်းဟို မဖျက်ရ၊ အဲလိုလဲ အဆှင်ရဲ့ ဆေ့တွင် နင်လို့ထားဆိလဲ့ ကျိန်ဆိုခြင်းဟို ပြုတဲ့အတိုင်း ဆောင်ရွက်ရမယ်’ ဟု ဆေ့လူလို့ ပြောထားတာဟို နင်လို့ ကြားရပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","အဲလိုလဲ ငါ နင့်ဟို ပြောတာဟ ကျိန်ဆိုခြင်းဟို လုံးဝမပြုရ၊ ခေါန်းခင်ဘုံဟို တည်ယွေ့ မကျိန်ဆိုကြနဲ့၊ အကျောန်းမှာ ခေါန်းခင်ဘုံဟ ဘုရားသခင်ရဲ့ ပလ္လင်တော် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","အဲဟာမဟုတ်ရင် ကမ္ဘာမြေကြီးဟို တိုင်တည်ယွေ့ မကျိန်ဆိုကြနဲ့၊ အကျောန်းမှာ ကမ္ဘာမြေကြီးဟ ဘုရားသခင်ရဲ့ ခြေတင်ရာခုံ ဖြစ်အယ်။ အဲဟာမဟုတ်ရင် ယေရုရှလင်မြို့ဟို တိုင်တည်ယွေ့ မကျိန်ဆိုကြနဲ့၊ အကျောန်းမှာ ယေရုရှလင်မြို့ဟ ဘုရင်ရဲ့ မြို့တော် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","အားပင်း မိမိရဲ့ဦးခေါင်းဟို တိုင်တည်ပင်း မကျိန်ဆိုကြနဲ့၊ အကျောန်းမှာ နင်လို့ဟ ဆံပင်တပင်ဟိုပင် ဖြူအောန် အဲဟာမဟုတ်ရင် မဲအောန် မတတ်နိန်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","နင်လို့ဟ ဟုတ်တာဟို ‘အဟုတ်’ မဟုတ်တာဟို ‘မဟုတ်’ — ဟူယွေ့ ရိုးဆှင်းစွာ ပြောဆိုကြလော့။ ဟေထက်ပိုသော စကားဟ မာရ်နတ်ဆေမှ လာသောစကား ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ ‘မျက်စေ့တလုံးအစား မျက်စေ့တလုံး၊ သွားတချောင်းအစား သွားတချောင်း’ ဟု ပြောထားတာဟို နင်လို့ ကြားရပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","အဲလိုလဲ နင်လို့ဟို ငါပြောတာဟ မကောင်းသောသူဟို အတိုက်အခံ မပြုကြနဲ့။ တစုံတယောက်ဟ နင်ရဲ့ လက်ယာပါးဟို ရိုက်ရင် အခြားပါးတဖက်လည်း လှည့်ပေးဦးလော။ ");
INSERT INTO dnv_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","အားပင်း နင့်ဟို တစုံတယောက်ဟ တရားစွဲယွေ့ နင့်ရဲ့ အင်္ကျီဟို ယူချင်ရင်၊ နင့်ရဲ့ ဝတ်လုံဟိုလည်း ယူခွင့်ပြုလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","နင့်အား တစုံတယောက်ဟ အနိန်အထက်ပြုယွေ့ ခရီးတမိုင် သွားစေရင်၊ သူနဲ့အတူ ခရီးနေမိုင် သွားလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","တောင်းသောသူအား ပေးကမ်းလော့၊ နင့်ဆေမှ ငမ်းလိုသော သူအားလည်း မငြင်းပယ်နဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ ‘မိတ်ဆွေများဟို ချစ်လော့၊ ရန်သူဟို မုန်းလော့’ ဟု ပြောထားတာဟို နင်လို့ ကြားရလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","အဲလိုလဲ ငါ နင့်ဟို ပြောတာဟ ရန်သူဟို ချစ်ကြလော့၊ နင်လို့အား နှိပ်စက်သောသူလို့အတွက် ဆုတောင်းပေးကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","အဲလိုမို့ နင်လို့ဟ ခေါန်းခင်ဘုံနှိုက်ဆိသော နင်လို့ အဖရဲ့ လူပဲ့သူငယ်များ ဖြစ်ကြလိမ့်မယ်။ အကျောန်းမှာ ကိုယ်တော်ဟ မကောင်းသောသူများနဲ့ ကောင်းသောသူများအပေါ် သူရဲ့နေဟို ထွက်စေပင်း၊ ကောင်းသောသူများနဲ့ မကောင်းသောသူများအပေါ် မိုးဟို ရွာစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","နင်လို့ဟ နင်လို့ဟို ချစ်သောသူလို့အား ချစ်ရင်၊ နင်လို့ ပစာအကျိုးကျေးဇူးဟို ရဆိလုန်း၊ အခွန်ခံသူများပင် အေးတိုင်းတိုင်း ပြုကြအယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","အားပင်း နင်လို့ဟ နင်လို့ရဲ့ မိတ်ဆွေများဟိုသာ နှုတ်ဆက်မယ်ဆိုရင်၊ အပြုအမူဟ စလို ထူးခြားမှု ဆိနိန်မလုန်း၊ ဘုရားသခင်ဟို မသိသောသူများပင် ဟေသို့ ပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ခေါန်းခင်ဘုံနှိုက်ဆိသော နင်လို့အဖဟ စုံလင်လဲ့နည်းတူ နင်လို့လည်း စုံလင်ခြင်း ဆိရမယ်” ဟု ယေရှုဟ မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“နင်လို့ရဲ့ ဖြောင့်မတ်သောအမှုဟို သူလို့မျော်အောန် လူလို့ဆေ့မှာ မလုပ်မဲ့အကျောန်း သတိပြုကြလော့။ နင်လို့ အဲလိုလုပ်ရင်၊ ခေါန်းခင်ဘုံနှိုက်ဆိသော နင်လို့ အဖဆေမှ အကျိုးကျေးဇူးဟို နင်လို့ ရဆိကြလိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“အဲလိုမို့ နင်ဟ လိုအပ်နေတဲ့သူဟို ပေးသောအခါ သူတော်ကောင်းဟန်ဆောင်သူလို့ လိုမျိုး လူများရဲ့ ချီးမွန်းဟို ခံလိုယွေ့ တရားဇရပ်များနဲ့ လမ်းဆုံလမ်းခွများတွင် မိမိလို့ဆေ့မှာ တံပိုးခရာ မှုတ်စေလဲ့နည်းတူ မပြုကြနဲ့။ ငါ နင့်ဟို အမန်ဆိုတာဟ၊ အဲသူလို့ဟ မိမိလို့အကျိုးဟို ရကြပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","အဲလိုလဲ နင်လို့ဟ လိုအပ်နေသော သူတယောက်ဟို ပေးသောအခါ၊ နင်လို့ရဲ့ လက်ယာလက် ပြုလုပ်လဲ့အရာဟို နင်လို့ရဲ့ လက်ဝဲလက်အား မသိစေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","အဲလိုမို့ နင်လို့ ပေးကမ်းတာဟို လျှို့ဝှက်ထားနိန်အယ်။ အေးနောက် မထင်မဆှားသောအရာဟို မျော်သော နင်ရဲ့အဖဟ နင့်ဟို ဆုလာဘ်ပေး လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“နင်လို့ဟ ဆုတောင်းသောအခါ၊ သူတော်ကောင်းဟန်ဆောင်သူလို့ လိုမျိုး မပြုကြနဲ့။ အဲသူလို့ဟ လူများမျော်သာအောန် တရားဇရပ်များနဲ့ လမ်းဆုံလမ်းခွများမှာ ရပ်လျက် ဆုတောင်းခြင်းဟို နှစ်သက်ကြအယ်။ ငါ နင့်လို့ဟို အမန်အကန်ပြောတာဟ၊ အဲသူလို့ဟ မိမိလို့ အကျိုးဟို ခံရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","အဲလိုလဲ နင်လို့ဟ ဆုတောင်းသောအခါ၊ နေအိုင်အတွင်းခန်းဟို ဝင်ယွေ့ ထင်ခါးဟို ပိတ်ပင်းရင် မျက်စေ့နဲ့ မမျော်နိန်သော နင်လို့ရဲ့ အဖဆေဟို ဆုတောင်းကြလော့။ အားပင်း မထင်မဆှားပြုသောအမှုဟို မျော်သော နင်လို့ရဲ့အဖဟ နင်လို့ဟို ဆုလာဘ်ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“နင်လို့ဟ ဆုတောင်းသောအခါ၊ ဘုရားသခင်ဟို မသိသောသူလိုမျိုး အလကားကားစကားဖြင့် ခုတင်ခု မမြွတ်ကြနဲ့။ အဲသူလို့ဟ ရမ်းဆာ့စကားများဟို ရွတ်ဆိုသောကျောန့် သူလို့ဟို နားထောင်ပေးလိမ့်မယ်ဟု ထင်မှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","အဲသူလို့လိုမျိုး မပြုကြနဲ့၊ နင်လို့ရဲ့အဖဟ နင်လို့ မတောင်းဆှောက်ခင်ကပင် နင်လို့ လိုသောအရာလို့ဟို သိနဲ့ပင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","အေးကျောန့် နင်လို့ ဟေလို့ ဆုတောင်းကြလော့၊ “ ‘ခေါန်းခင်ဘုံနှိုက်ဆိလဲ့ ငါလို့အဖ၊ ကိုယ်တော်ရဲ့ နာမတော်အား ရိုသေလေးမြတ်ခြင်း ဆိစေမန့်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","နိုင်ငံတော် တည်ထောင်စေမန့်။ အလိုတော်ဟ ခေါန်းခင်ဘုံနှိုက် ပြေ့စုံသလိုမျိုး မြေကြီးပေါ်မှာ ပြေ့စုံစေမန့်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","အသက်မွေးဖို့ လိုအပ်လဲ့အစာဟို ငါလို့အား ခုနေ့ ပေးသနားမန့်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","သူတပါးဟ ငါလို့ဟို ပစ်မားလဲ့ အပစ်များဟို ငါလို့ဟ လွှတ်သလိုမျိုး ငါလို့ရဲ့ အပစ်များဟို လွှတ်မန့်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","အပစ်သွေးဆောင်ရာဟို မလိုက်ပါစေဘဲ၊ အကောင်းလဲ့အမှုအရာမှလည်း ကယ်နုတ်မန့်။’ ဟု ဆုတောင်းကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“နင်လို့ဟ သူတပါးလို့ အမားဟို ခွင့်လွှတ်ရင်၊ ခေါန်းခင်ဘုံနှိုက်ဆိသော နင်လို့အဖဟ နင်လို့ရဲ့ အပစ်များဟို ဖြေလွှတ်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","အဲလိုလဲ နင်လို့ဟ သူတပါးဟို ခွင့်မလွှတ်ရင်၊ နင်လို့အဖဟလည်း နင်လို့ရဲ့ အပစ်များဟို ခွင့်လွှတ်လိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“နင်လို့ဟ အစာဆှောင်ခြင်း အကျင့်ဟို ကျင့်သောအခါ ဟန်ဆောင်တတ်သောသူလို့ လိုမျိုး မျက်နှာညှိုးငယ်ခြင်း မဆိကြနဲ့။ အဲသူလို့ဟ မိမိလို့ အစာဆှောင်တာဟို လူများလို့ဆေ့မှာ ပေါ်လွင်စေဖို့၊ မိမိလို့ရဲ့ မျက်နှာဟို ဖျက်တတ်ကြအယ်။ ငါ နင်လို့ဟို အမန်ပြောတာဟ၊ အဲသူလို့ဟ မိမိလို့ အကျိုးဟို အပြေ့အဝခံစားရကြပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","အဲလိုလဲ နင်လို့ဟ အစာဆှောင်ကြသောအခါ၊ မျက်နှာဟို သစ်ယွေ့ ဦးခေါင်းဟို ဆီလိမ်း ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","အေးကျောန့် နင်ဟ အစာဆှောင်သောအခါ အစာဆှောင်တာဟို လူများလို့ ဆေ့မှာ မပေါ်လွင်စေဘဲ၊ မပေါ်လွင်သော အရပ်နှိုက် ဆိသော နင်လို့အဖ ဆေ့တော်နှိုက်သာ ပေါ်လွင်စေကြလော့။ မပေါ်လွင်သောအရာဟို မျော်သော နင်လို့အဖဟ နင့်လို့အား ဆုလာဘ်ဟို ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“သံချေးနဲ့ ပိုးရွ ဖျက်ဆီးယွေ့ သူခိုးထွင်းဖောက်ခိုးယူရာ မြေကြီးပေါ်မှာ ဘဏ္ဍာဟို နင်လို့အတွက် မဆည်းပူးကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","အဲလိုလဲ သံချေးနဲ့ ပိုးရွ မဖျက်ဆီးယွေ့ သူခိုး မထွင်းမဖောက်၊ မခိုးမယူရာ ခေါန်းခင်ဘုံနှိုက် နင်လို့အတွက် ဘဏ္ဍာဟို ဆည်းပူးကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","အကျောန်းမှာ နင်လို့ရဲ့ ဘဏ္ဍာဆိရာဟို နင်လို့ဟ စိတ်နေလုံး ရောက်တတ်သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“မျက်စေ့ဟ ခန္ဓာကိုယ်ရဲ့ ဆီမီးလိုမျိုး ဖြစ်အယ်။ မျက်စေ့ကြည်လင်ရင် နင်လို့ရဲ့ ခန္ဓာကိုယ်တခုလုံး လင်းလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","အဲလိုလဲ နင်လို့ရဲ့ မျက်စေ့မွဲရင် ခန္ဓာကိုယ်တခုလုံး မိုက်လိမ့်မယ်။ အဲလိုမို့ နင်လို့တွင် ဆိသော အလင်းဟ မိုက်ဖြစ်ရင် အဲမိုက်ဟ ရမ်းဆာ့ မိုက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“စသူမျှ သခင်နေဦး အစေဟို မခံနိန်။ သခင်တဦးဟို မုန်းယွေ့ တဦးဟို ချစ်လိမ့်မယ်။ သခင်တဦးဟို သစ္စာစောင့်ယွေ့ တဦးဟို မလေးမခန့်ပြုလိမ့်မယ်။ နင်လို့ဟ တချိန်တည်းနှိုက် ဘုရားသခင်ရဲ့ အစေနဲ့ လောကီစည်းစိမ်ရဲ့ အစေဟို မခံနိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“အဲကျောန့် ငါ နင်လို့ဟို ပြောတာဟ၊ နင်လို့ ဖဝါ့အတွက် ပစာစားရမယ် အဲဟာမဟုတ်ရင် သောက်ရမယ်အကျောန်းဟို မစိုးရိမ်ကြနဲ့။ ဖယ်လိုဝတ်ရမယ်ဟို ခန္ဓာကိုယ်အတွက် မစိုးရိမ်ကြနဲ့။ အသက်ဟ အစားအသောက်ထက် လည်းကောင်း၊ ခန္ဓာကိုယ်ဟ အဝတ်ထက် လည်းကောင်း ပိုယွေ့ အရေးကြီးတာ မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","မိုးခေါန်းခင်နှိုက် ကျင်လည်သော ငက်များဟို ကျေ့ရှုဆင်ခြင်ကြလော့။ သူလို့ဟ မျိုးစေ့ဟို မကြဲ အဲဟာမဟုတ်ရင် စပါးများဟို မရိတ်မသိမ်း အဲဟာမဟုတ်ရင် ကျီများတွင် လှောင်မှုဟို မပြု၊ အားပင်း ခေါန်းခင်ဘုံဆှင် နင်လို့အဖဟ သူလို့ဟို ကျွေးမွေးအယ်။ နင်လို့ဟ ငက်များထက် ရမ်းဆာ့ ပိုယွေ့ အဖိုးတန်ကြအယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","နင်လို့တွင် စသူဟ စိုးရိမ်ခြင်းအားဖြင့် မိမိရဲ့အသက်ဟို နှစ်ကတီလောက် ပိုပင်း ရှည်စေနိန်သလော။ ");
INSERT INTO dnv_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“နင်လို့ဟ ပစာကျောန့် အဝတ်အတွက် စိုးရိမ်ကြလုန်း။ တောနှင်းပန်းများ စလိုဆှင်သန်လာတာဟို ကျေ့ရှုဆင်ခြင်ကြလော့။ အဲပန်းပင်လို့ဟ အလုပ်လည်း မလုပ် အဲဟာမဟုတ်ရင် ချေဖြစ်စေဖို့ မငင်မဝင့်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","အဲလိုလဲ နင်လို့ဟို ငါပြောတာဟ ရမ်းဆာ့ ချမ်းသာကြွယ်ဝပင်း ဘုန်းကြီးလဲ့ ရှောလမုန်မင်းကြီးပင်လျှင် အဲပန်းပင်တပင်မျှရဲ့ အလှဟို မမှီ။ ");
INSERT INTO dnv_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ယုံကြည်ခြင်း အားနည်းသောသူလို့၊ ခုနေ့ အသက်ဆှင်လျက် မနက်ခါ မီးဖိုထဲဟို ရောက်သော တောမြက်ပင်ဟို ဘုရားသခင်ဟ ဟေမျှလောက် ဆင်ယင်ပေးရင် နင်လို့ဟို ပိုကောင်းစွာ ဆင်ယင်ပေးမယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“အဲလိုမို့ ‘ငါလို့ ပစာလိုမျိုး စားရမယ် အဲဟာမဟုတ်ရင် သောက်ရမယ် အဲဟာမဟုတ်ရင် ပစာလိုမျိုး ဝတ်ရမယ်’ ဟု မစိုးရိမ်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ဘုရားသခင်ဟို မသိသောသူလို့ဟ အဲလိုမျိုး စိုးရိမ်တတ်ကြအယ်။ ခေါန်းခင်ဘုံဆှင် နင်လို့ရဲ့အဖဟ အဲအရာအားလုံးဟို နင်လို့လိုကျောန်း သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","အဲလိုလဲ ဘုရားသခင်ရဲ့ နိုင်ငံတော်နဲ့ ဖြောင့်မတ်ခြင်းဟို ဦးရင် ဆှာကြလော့၊ အားပင်း ဟေအရာအားလုံးလို့ဟို နင်လို့အား ထပ်ယွေ့ ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","အဲလိုမို့ မနက်ခါအဖို့ မစိုးရိမ်ကြနဲ့၊ မနက်ခါနေ့ဟ မိမိအဖို့ စိုးရိမ်လိမ့်မယ်။ ခုနေ့နှိုက်ဆိသော မကောင်းမသင့်သောအရာဟ အခုနေ့ဖို့ လောက်ပေအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“သူတပါးဟို မစီရင်ကြနဲ့၊ အေးမှသာ ဘုရားသခင်ဟ နင်လို့ဟို စီရင်လိမ့်မယ် မဟုတ်၊ ");
INSERT INTO dnv_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","အကျောန်းမှာ သူတပါးဟို နင်လို့ စီရင်လဲ့နည်းအတိုင်း ဘုရားသခင်ဟ နင်လို့ဟို စီရင်လိမ့်မယ်၊ အားပင်း သူတပါးလို့ဟို စီရင်ရာတွင် နင်လို့ အသုံးပြုလဲ့နည်းအတိုင်း နင်လို့ဟို စီရင်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","နင်လို့ဟ ကိုယ့်မျက်စေ့ထဲဟ သစ်တုံးဟို မမျော်ဘဲ ညီအကိုရဲ့ မျက်စေ့ထဲဟ ငြောင့်သငယ်ဟို ပစာကျောန့် မျော်နေလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","နင်လို့ရဲ့ မျက်စေ့ထဲဟ သစ်တုံးဆိနေလျက် ပစာကျောန့် ညီအကိုအား ‘နင့်ရဲ့မျက်စေ့ထဲဟ ငြောင့်သငယ်ဟို ထုတ်ပေးမန့်’ ဟု စလိုပြောရဲလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ဟန်ဆောင်တတ်သောသူ၊ ကိုယ်မျက်စေ့နှိုက်ဆိသော သစ်တုံးဟို ဦးရင် ဖယ်ပစ်လော့၊ နောက်မှ ညီအကို မျက်စေ့နှိုက်ဆိသော ငြောင့်သငယ်ဟို ထုတ်ပစ်ခြင်းငှာ နင်ဟ ဆှင်းလင်းစွာ မျော်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“သန့်ဆှင်းသောအရာဟို ခွေးလို့အား မပေးကြနဲ့၊ သူလို့ဟ လှည့်ပင်း နင်လို့ဟို တိုက်ခိုက်လိမ့်မယ်။ နင်လို့ရဲ့ ပုလဲရတနာများဟို ဝက်လို့ဆေ့မှာ မချထားကြနဲ့၊ သူလို့ဟ အဲအရာလို့ဟို မိမိလို့ခြေဖြင့်နင်းချေပင်း သွားကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“တောင်းကြလော့၊ တောင်းရင် ရကြလိမ့်မယ်၊ ဆှာကြလော့၊ ဆှာရင် တွေ့ကြလိမ့်မယ်၊ ထင်ခါးဟို ခေါက်ကြလော့၊ ခေါက်ရင် နင်လို့ဟို ထင်ခါး ဖွင့်ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","အကျောန်းမှာ တောင်းသောသူဟ ရအယ်၊ ဆှာသောသူဟ တွေ့အယ်၊ ထင်ခါးခေါက်သောသူဟို ဖွင့်ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","နင်လို့တွင် စသူဟ မိမိရဲ့အောင်နီဟ မုန့်ဟိုတောင်းရင် ကျောက်ခဲဟို ပေးမလော၊ ");
INSERT INTO dnv_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","အဲဟာမဟုတ်ရင် ငါးဟို တောင်းရင် မြွေဟို ပေးမလော။ ");
INSERT INTO dnv_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","နင်လို့ဟ မကောင်းသောသူများဖြစ်လျက်ပင် မိမိလို့ရဲ့ လူပဲ့သူငယ်အား ကောင်းမွန်သောအရာဟို ပေးရမယ် သိကြရင်၊ ခေါန်းခင်ဘုံဆှင် နင်လို့ရဲ့အဖဟလည်း မိမိဆေ တောင်းဆှောက်သူလို့အား ကောင်းမွန်သောအရာလို့ဟို ပိုပင်းပေးမယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“နင်လို့ဟ ကိုယ်နှိုက် သူတပါး လုပ်စေလိုလဲ့အတိုင်း သူတပါးနှိုက် ပြုကြလော့၊ အေးစာဟ မောရှေရဲ့ ပညတ္တိကျမ်းနဲ့ ပရောဖက်ကျမ်းများရဲ့ အချုပ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ကျဉ်းမြောင်းသော ထင်ခါးဟို ဝင်ကြလော့။ အကျောန်းမှာ ပျက်စီးခြင်းဟို ရောက်သော ထင်ခါးဟ ကျယ်ဝန်းယွေ့ လမ်းဟ ပြန့်ပြူးပင်း၊ အဲလမ်းဟို ဝင်သောသူလို့လည်း များကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","အဲလိုလဲ အသက်ဆှင်ခြင်းဟို ရောက်သော ထင်ခါးဟ ကျဉ်းမြောင်းယွေ့ လမ်းဟ ကြမ်းပင်း အဲလမ်းဟို တွေ့ဆိသူလို့ဟ နည်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“မားသောပရောဖက်လို့ဟို သတိထားကြလော့။ သူလို့ဟ သိုးရေခြုံလျက် နင်လို့ဆေဟို လာပေမဲ့လည်း အတွင်းစိတ်ဟ ရက်စက်သော ဝံပုလွေလိုမျိုး ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","အဲသူလို့ရဲ့ အသီးများအားဖြင့် သူလို့ဟို နင်လို့ သိကြလိမ့်မယ်။ လူများဟ ဆူးပင်မှ စပျစ်သီးဟို ခူးတတ်သလော အဲဟာမဟုတ်ရင် ဆူးပင်မှ သင်္ဘောသဖန်းသီးဟို ခူးတတ်သလော။ ");
INSERT INTO dnv_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","အဲနည်းတူ ကောင်းသော အပင်တိုင်းဟ အသီးကောင်းဟို သီးတတ်ပေမဲ့ မကောင်းလဲ့အပင်ဟ မကောင်းသောအသီးဟို သီးတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ကောင်းသော အပင်တပင်ဟ မကောင်းသောအသီး မသီးနိန်။ မကောင်းသော အပင်တပင်ဟလည်း ကောင်းသောအသီးဟို မသီးနိန်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","အသီးကောင်းဟို မသီးလဲ့ အပင်ဆိသမျှဟို ခုတ်လှဲယွေ့ မီးထဲဟို လောချတတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","အဲလိုမို့ သူလို့ရဲ့ အသီးအားဖြင့် သူလို့ဟို နင်လို့ သိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ ‘သခင်၊ သခင်’ ဟု ငါ့ဟို ခေါ်သောသူတိုင်း ခေါန်းခင်နိုင်ငံတော်ဟို ဝင်ရလိမ့်မယ် မဟုတ်။ အဲလိုလဲ ခေါန်းခင်ဘုံဆှင် ငါ့အဖရဲ့ အလိုတော်အတိုင်း လိုက်ဆှောက်သူသာရင် ဝင်ရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","တရားစီရင်ရာနေ့ ရောက်သောအခါ၊ ‘သခင်၊ သခင် ငါလို့ဟ ကိုယ်တော်ရဲ့ နာမတော်ဟို အမှီပြုယွေ့ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တော်ဟို ဟောပြောလျက်၊ ကိုယ်တော်ရဲ့ နာမတော်ဟို အမီပြုယွေ့ နတ်ဆိုးများဟို မောင်းထုတ်ပင်း အံ့ဩဖွယ်သောအမှုများဟို ပြုခဲ့ကြအယ် မဟုတ်လော’ ဟု လူအများပင် ငါ့အား ပြောကြားလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","အဲအခါ ‘နင်လို့ဟို ဖယ်ခါမျှ ငါမသိ။ ဆိုးသွမ်းသူလို့ ငါ့ဆေမှ ထွက်သွားကြလော’ ဟု အဲသူလို့အား ငါပြောမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“အေးလိုမို့ ငါဟောပြောသော ဟေတရားစကားဟို ကြားယွေ့ လိုက်ဆှောက်သူတိုင်းဟ ကျောက်ပေါ်တွင် နေအိုင်ဆောက်လဲ့ ပညာဆိနဲ့တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","မိုးသည်းစွာ ရွာယွေ့၊ မြစ်ယေလျှံကာ၊ လေပြင်းထန်လျက် အဲနေအိုင်ဟို တိုက်ခတ်အယ်။ အဲလိုလဲ အဲအိုင်ဟ ကျောက်ပေါ်မှာ အုတ်မြစ်ချထားသောကျောန့် မပြိုလဲချေ။ ");
INSERT INTO dnv_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“အဲလိုလဲ ငါဟောပြောသော ဟေတရားစကားဟို ကြားပင်း မလိုက်မဆှောက်သူတိုင်းဟ သဲပေါ်မှာ နေအိုင်ဆောက်သော လူမိုက်နဲ့တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","မိုးသည်းထန် ရွာယွေ့၊ မြစ်ယေလျှံကာ၊ လေပြင်းထန်လျက် အဲအိုင်ဟို တိုက်ခတ်သောကျောန့် အဲနေအိုင်ဟ ပြိုလဲသွားအယ်။ အားပင်း အဲနေအိုင်ရဲ့ အပျက်အစီးမှာ ကြီးလှအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ယေရှု ဟေအရာများဟို ဟောပြောပင်းသောအခါ၊ လူအုပ်လို့ဟ ကိုယ်တော်ရဲ့ သွန်သင်ပုံဟို အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ကိုယ်တော်ဟ ကျမ်းတတ်ဆရာလို့လိုမျိုး မဟုတ်ဘဲ အာဏာဆိလိုမျိုး သွန်သင်ပေးသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ယေရှုဟ တောင်ပေါ်မှ ဆင်းလာသောအခါ ရမ်းဆာ့သော လူအုပ်ကြီးဟ ကိုယ်တော်နောက်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","အဲအခါ အရေပြားရောဂါစွဲကပ်သူ လူတယောက်ဟ ကိုယ်တော်ဆေဟို လာယွေ့၊ ဆေ့မှာ ဒူးထောက်လျက် “ဆရာ၊ ကိုယ်တော် အလိုတော်ဆိရင် ငါ့အား သန့်စင်စေနိန်မန့်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ယေရှုဟ လက်တော်ဟို ဆန့်ယွေ့ အေးသူဟို တို့ထိကာ “ငါ အလိုဆိအယ်၊ သန့်စင်စေ” ဟု မိန့်အယ်။ ခုတုံး သူဟ အဲအရေပြားရောဂါ ပျောက်ကင်း သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","အဲအခါ ယေရှုဟ “နားထောင်လော့၊ စသူ့ဟိုမှ မပြောနဲ့။ အဲလိုလဲ ယဇ်ပုရောဟိတ် ဆေဟို သွားယွေ့ နင့်ရဲ့ ကိုယ်ဟို ပြပင်း လူလို့ဆေ့နှိုက် သက်သေဖြစ်စေဖို့ မောရှေ စီရင်မှာထားသော ပူဇော်သကာဟို ဆက်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ကပေနောင်မြို့ဟို ယေရှု ဝင်သောအခါ ရောမ တပ်မှူးတယောက်ဟ ကိုယ်တော်နဲ့ တွေ့ဆုံပင်း သူ့ဟို ကူညီဖို့ တောင်းပန်ပင်း ");
INSERT INTO dnv_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ဆရာ၊ ငါ့ရဲ့ အစေခံတယောက်ဟ ရမ်းဆာ့ဝေဒနာ ခံစားပင်း မရွေ့နိန်ဘဲ နေအိုင်ရဲ့ အိပ်ယာထဲမှာ လဲယွေ့ နေအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ယေရှုဟလည်း “ငါ လာယွေ့ သူ့ဟို ကျန်းမာစေမယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","တပ်မှူးဟ “ဆရာ၊ ငါ့ရဲ့ အိုင်မိုးအောက်ဟို ကိုယ်တော် ဝင်လာဖို့ မထိုက်တန်ပါ။ အမိန့်တော်ဟိုသာ ပေးပါ၊ အားပင်း ငါ့ရဲ့ အစေခံဟ ကျန်းမာစေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","အကျောန်းမှာ ငါ့တတ်တိုင်းဟလည်း အထက်အာဏာအောက်နှိုက် ဆိသောသူတယောက် ဖြစ်ပင်း၊ ငါ့ရဲ့ လက်အောက်တွင် စစ်သားများ ဆိအယ်။ ဟေတယောက်ဟို ‘သွားမန့်’ ဟု ငါပြောရင် သူဟ သွားယွေ့၊ အခြားတယောက်ဟို ‘လာမန့်’ ဟု ပြောရင် သူဟ လာအယ်။ ငါ့ရဲ့ အစေခံအား ‘ဟေအရာဟို လုပ်ပါ’ ဟု ပြောရင် သူဟ လုပ်အယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ဟေစကားဟို ယေရှု ကြားသောခါ၊ အံ့ဩယွေ့ နောက်ဟို လိုက်လာကြသော သူလို့အား “ငါ နင်လို့ဟို အမန်ပြောတာဟ၊ ဟေမျှလောက် ကြီးမားသော ယုံကြည်ခြင်းဆိသောသူ တစုံတယောက်ဟိုမျှ ဣသရေလအမျိုးထဲနှိုက် ငါ မတွေ့ဖူးသေး။ ");
INSERT INTO dnv_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","နင်လို့အား အမန်အကန် ငါပြောတာဟ ရမ်းဆာ့သောလူလို့ဟ အဆေ့အရပ်နဲ့ အနောက်အရပ်မှ လာယွေ့ ခေါန်းခင်နိုင်ငံတော်တွင် အာဗြဟံ၊ ဣဇက်၊ ယာကုပ်လို့နဲ့အတူ ထိန်ပင်း စားသောက်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","အဲလိုလဲ နိုင်ငံတော်သား ဖြစ်သင့်သောသူလို့မူကား အပြင်မိုက်ထဲဟို လောထုတ်ခြင်းဟို ခံရကြလိမ့်မယ်၊ အဲအရပ်တွင် သူလို့ဟ ငိုကြွေးမြည်တမ်းယွေ့ အံသွားခဲကြိတ်လျက် နေကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","အဲပင်းရင် ယေရှုဟ တပ်မှူးအား “နေအိုင်ဟို သွားလော့၊ နင်ယုံကြည်လဲ့အတိုင်း ဖြစ်လိမ့်မယ်” ဟု မိန့်အယ်။ အားပင်း အေးအချိန်နှိုက်ပင် တပ်မှူးရဲ့ အစေခံဟ ရောဂါပျောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ယေရှုဟ ပေတရုရဲ့ နေအိုင်ဟို လာသောအခါ၊ ကိုယ်တော်ဟ ပေတရုရဲ့ ယောက္မမဟ ဖျားယွေ့ အိပ်ယာပေါ်တွင် လဲနေတာဟို မျော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ယေရှုဟ အဲမိန်းမရဲ့ လက်ဟို တို့ထိယွေ့ သူမဟ အဖျားပျောက်သွားပင်း၊ ထယွေ့ ယေရှုအား ဧည့်ခံပြုစုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ညနေအချိန်ရောက်သောအခါ လူလို့ဟ နတ်ဆိုးစွဲသောသူ အများလို့ဟို အထံတော်ဟို ဆောင်ခဲ့ကြပင်း၊ ယေရှုဟ အဲနတ်ဆိုးလို့ဟို နှုတ်တော်ထွက်စကား တခွန်းအားဖြင့် မောင်းထုတ်အယ်၊ အားပင်း နေမကောင်းသောသူ အပေါင်းလို့ဟိုလည်း ကျန်းမာစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","အေးဟာဟ “သူ့တတ်တိုင်း ငါလို့ရဲ့ အနာရောဂါများနဲ့ ဝေဒနာများဟို ဆောင်ယူသွားအယ်” ဟူယွေ့ ပရောဖက် ဟေရှာယ ဟောခဲ့လဲ့ စကားအတိုင်း ဖြစ်ပျက်ယွေ့ လာခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ယေရှုဟ မိမိပတ်လည်ဆိ လူအုပ်ဟို မျော်သောအခါ၊ ကိုယ်တော်ဟ အိန်တဖက်ကမ်းဟို ကူးရန် အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","အဲပင်းရင် ကျမ်းတတ်ဆရာ တယောက်ဟ ကိုယ်တော်ဆေဟို လာယွေ့ “ဆရာ၊ ကိုယ်တော် ဖယ်နားဟိုဘဲ သွားသွား ငါလိုက်မယ်” ဟု ဆှောက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ယေရှုဟ “မြေခွေးမှာ တွင်း ဆိအယ်။ မိုးခေါန်းခင် ငက်မှာလည်း အသိုက် ဆိပေမဲ့ လူသားမှာဟ ခေါင်းချစရာ နေရာမဆိ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","အခြား တဘဲ့တော်တဦးဟ ကိုယ်တော်အား “ဆရာ၊ ငါ့အဖဟို ဦးရင်သွားယွေ့ သင်္ဂြိုဟ်ပါရစေ” ဟု ဆှောက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ယေရှုဟလည်း “ငါ့နောက်သို့ လိုက်လော့၊ လူသေလို့ဟ မိမိလူသေလို့ဟို သင်္ဂြိုဟ်မန့်လေစေ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ယေရှုဟ လှေပေါ်သို့ တက်ပင်း တဘဲ့တော်လို့ဟလည်း ကိုယ်တော်နဲ့အတူ လိုက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","အိန်ထဲတွင် ခုတုံး လေမုန်တိုင်းကျလာသဖြင့် လှေဟ လှိုင်းတံပိုးများထဲတွင် မြုပ်လုမြုပ်ခင် ဖြစ်လေအယ်။ အဲလိုလဲ ယေရှုဟ အိပ်မွေ့လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","တဘဲ့တော်လို့ဟ ကိုယ်တော်ဆေဟို သွားပင်း နှိုးယွေ့ “သခင်ဘုရား၊ ငါလို့ဟို ကယ်မန့်၊ ငါလို့ သေဆုံးရကြတော့မယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ယေရှုဟ “ယုံကြည်မှု အားနည်းသူလို့၊ နင်လို့ ပစာကျောန့် ကြောက်လန့်နေလုန်း” ဟု မိန့်အယ်၊ အဲပင်းနောက် ကိုယ်တော်ဟ ထယွေ့ လေနဲ့ လှိုင်းများဟို ဆုံးမပင်း၊ လေနဲ့ လှိုင်းလို့ဟ ငြိမ်သက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","အေးသူလို့ဟ အံ့ဩယွေ့၊ “ဟေသူဟ မစာသို့သောသူဖြစ်သလော၊ လေနဲ့ လှိုင်းများပင်လျှင် သူဟို နာခံကြအယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ယေရှုဟ အိန်တဖက်ကမ်းဆိ ဂါဒရနယ်ဟို ရောက်လာသောအခါ၊ နတ်ဆိုးစွဲသူ လူနေယောက်ဟ လုတ်တိုင်းဂူများ အကြားမှ ထွက်လာပင်း ကိုယ်တော်နဲ့ တွေ့ဆုံကြအယ်။ အဲသူလို့ဟ ရမ်းဆာ့ ဆိုးသွမ်းသဖြင့် စသူမျှ အဲလမ်းဟို မဖြတ်သွားနိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","“ဘုရားသခင်ရဲ့ သားတော်၊ ကိုယ်တော်ဟ မစာသို့ ဆိုင်သလုန်း၊ အချိန်မကျခင် ငါလို့ဟို ညှဉ်းဆဲခြင်းရန် ကြွလာသလော” ဟု ဟစ်အော်ယွေ့ ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","အဲသူလို့နဲ့ ကတစ်မျှဝေးသော နေရာတွင် ဝက်အုပ်ကြီးတအုပ်ဟ အစာစားလျက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","နတ်ဆိုးလို့လည်း ယေရှုအား “ငါလို့ဟို မောင်းထုတ်ရင်၊ အဲဝက်အစုထဲဟို ဝင် အခွင့်ပေးပါ” ဟု တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ယေရှုဟ သူလို့အား “သွားကြလော့” ဟု မိန့်အယ်။ အဲလိုမို့ သူလို့ဟ ထွက်လာယွေ့ ဝက်ထဲဟို ဝင်ကြပင်း ဝက်အုပ်တအုပ်လုံးပင် ချောက်ကမ်းပါးအတိုင်း အိန်ထဲဟို ပြေးဆင်းကာ ယေထဲနှိုက် သေဆုံးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ဝက်ကျောင်းသောသူလို့ဟလည်း ပြေးယွေ့ မြို့ထဲသို့ ဝင်ပင်းရင်၊ နတ်ဆိုးစွဲသောသူလို့ရဲ့ အကျောန်းမှစပင်း ဖြစ်လေသမျှလို့ဟို ကြားပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","အဲလိုမို့ လူတိုင်းဟ ယေရှုဟို တွေ့ရန် မြို့ထဲမှ ထွက်လာကြအယ်၊ အားပင်း သူလို့ဟ ယေရှုဟို မျော်သောအခါ၊ မိမိလို့ပြေမှ ထွက်ခွာသွားရန် ကိုယ်တော်ဟို တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ယေရှုဟ လှေဟို စီးယွေ့၊ အိန်တဖက်ဟို ကူးပင်းရင် မိမိနေရင်းမြို့ဟို လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","လူအချို့လို့ဟ အိပ်ယာပေါ်နှိုက် လဲလျောင်းနေလဲ့ လေဖြတ်သူ လူတယောက်ဟို ကိုယ်တော်ဆေဟို ခေါ်ခဲ့ကြအယ်။ ယေရှုဟ အဲသူလို့ရဲ့ ယုံကြည်ခြင်းဟို မျော်သောအခါ လေဖြတ်သူအား “ငါ့သား အားမငယ်နဲ့။ နင်ရဲ့အပစ်ဟို လွှတ်ပီ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","အဲပင်းရင် ကျမ်းတတ်ဆရာအချို့လို့ဟ “ဟေသူသည် ဘုရားသခင်ဟို ပစ်မား ပြောဆိုလေပီ” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ယေရှုဟ အဲသူလို့ တွေးတောပုံဟို သိမျော်သဖြင့် “နင်လို့ဟ ပစာကျောန့် ဟေလို့မားယွင်းစွာ တွေးနေကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘နင်ရဲ့ အပစ်ဟို ဖြေလွှတ်ပီ’ ဟု ပြောရန် ပိုယွေ့ လွယ်ကူသလော၊ အဲဟာမဟုတ်ရင် ‘ထပင်း လှမ်းသွားလော့’ ဟု ပြောရန် ပိုယွေ့ လွယ်ကူသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","အဲပင်းရင်၊ လူသားဟ လောကတွင် အပစ်ဖြေလွှတ်ပိုင်တာဟို ငါ နင်လို့ဟို သက်သေပြမယ်။” အဲလိုမို့ ကိုယ်တော်ဟ လေဖြတ်သူအား “ထလော့၊ အိပ်ယာဟို မပင်း နေအိုင်ဟို ပြန်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","အဲသူဟလည်း ထယွေ့ နေအိုင်ဟို ပြန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ဟေအရာဟို လူများလို့ မျော်ကြသောအခါ သူလို့ဟ ကြောက်ရွံ့ကြပင်း လူလို့အား ဟေသို့သော တန်ခိုးဟို ပေးသော ဘုရားသခင်ရဲ့ ဘုန်းတော်ဟို ချီးမွန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ယေရှုဟ အဲအရပ်မှ ထွက်သွားပင်းခါ၊ အကောက်ခွန်ရုံးတွင် ထိန်လျက်နေသော မဿဲဆိုသူ လူတယောက်ဟို မျော်အယ်။ ယေရှုဟ “ငါ့နောက်ဟို လိုက်လော့” ဟု မိန့်သော် အဲသူဟ ထယွေ့ နောက်ဟို လိုက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ယေရှုဟ မဿဲရဲ့နေအိုင်တွင် ညစာစားလျက် နေခါ အခွန်ခံနဲ့ တခြား ဆိုးသွမ်းသောသူများဟ လာပင်း ယေရှုမှစသော တဘဲ့လို့နဲ့တကွ စားပွဲနှိုက် ထိန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ဟေအရာဟို ဖာရိရှဲလို့ မျော်ရင် တဘဲ့တော်လို့အား၊ “နင်လို့ရဲ့ ဆရာဟ မစာကျောန့် ဟေဆိုးသွမ်းသောသူ၊ အခွန်ခံသောသူနဲ့အတူ စားသောက်နေလော” ဟု မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","အေးအရာဟို ယေရှု ကြားရင် “ကျန်းမာသူဟ ဆရာဝန်ဟို မလိုပေမဲ့ ဖျားနာသူသာ လိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‘ယဇ်ပူဇော်ခြင်းဟို မဟုတ်ဘဲ ကရုဏာဟို အလိုဆိအယ်’ ဟူသော ကျမ်းစကားဟို နားလည်ခြင်းငှာ နင်လို့ သွားယွေ့ လေ့လာကြလော။ အကျောန်းမှာ ငါဟ ဖြောင့်မတ်သောသူလို့ဟို ခေါ်ရန် လာတာ မဟုတ်ဘဲ အပစ်သားများဟို ခေါ်ရန် ငါလာအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","အဲပင်းရင် ယောဟန်ရဲ့ တဘဲ့များဟ ယေရှုဆေဟို လာပင်း “ငါလို့နဲ့ ဖာရိရှဲလို့ဟ မကြာခဏ အစာဆှောင်ကြအယ်၊ အဲလိုလဲ ကိုယ်တော်ရဲ့ တဘဲ့များဟ ပစာကျောန့် အစာမဆှောင်ကြသလော” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ယေရှုဟ “မင်္ဂလာဆောင်ပွဲတွင် အပေါင်းအဖော်များဟ သတို့သားနဲ့အတူ ဆိနေချိန်နှိုက် ဝမ်းနည်းပူဆွေးကြမယ်လော။ ဝမ်းနည်းမယ် မဟုတ်ဘဲ သူလို့ဆေမှ သတို့သားဟို ခွဲခွာယူဆောင်သွားမဲ့ နေ့ရက် ရောက်လာလိမ့်မယ်။ အဲအခါ သူလို့ဟ အစာဆှောင်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“စသူမျှ ပိတ်စသစ်နဲ့ အထည်ဟောင်းဟို ဖာလေ့ မဆိ။ အကျောန်းမှာ ဖာထားသော ပိတ်စသစ်ဟ အဝတ်ဟို ရုန်းသဖြင့် အပေါက်ကျယ်တတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","အဲအပြင် စပျစ်ယေဟို သားယေဖူးဟောင်းတွင် ထည့်လေ့ မဆိ။ ထည့်ခဲ့ရင် သားယေဖူးဟ ပေါက်ပြဲယွေ့ စပျစ်ယေ ယိုထွက်ကုန်ပင်း သားရေဖူးလည်း ဖျက်စီးသွားလိမ့်မယ်။ အဲအစား စပျစ်ဝိုင်အသစ်ဟို သားရေဖူးအသစ်နှိုက်သာ ထည့်ကြအယ်။ အေးလို့လုပ်ရင် နေမျိုးလုံး တာရှည် ထိန်းသိမ်းနိန်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ယေရှုဟ ဟေသို့ မိန့်မြွတ်လျက်နေခါ၊ ယုဒ အရာဆိတယောက်ဟ ကိုယ်တော်ဆေဟို လာပင်း ဆေ့တော်နှိုက် ဒူးထောက်လျက် “ငါ့ရဲ့ သမီးဟ အခုပင် သေဆုံးသွားအယ်။ အဲလိုလဲ လာယွေ့ သူ့အပေါ်မှာ ကိုယ်တော်ရဲ့ လက်တော်ဟို တင်ရင် သူဟ အသက်ဆှင်လာလိမ့်မယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","အဲလိုမို့ ယေရှုဟ ထယွေ့ အဲသူနောက်ဟို လိုက်ပင်း တဘဲ့တော်လို့လည်း ကိုယ်တော်နဲ့အတူ လိုက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","တဆယ့်နေနှစ်ပတ်လုံး သွေးသွန်ရောဂါစွဲကပ်နေသော မိန်းမတယောက်ဟ ယေရှုရဲ့နောက်ဟို ချဉ်းကပ်ပင်းရင်၊ အဝတ်တော် အမြိတ်ဟို တို့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“ကိုယ်တော်ရဲ့ အဝတ်တော်ဟိုမျှ လက်နဲ့ တို့ထိရရင်ပင် ငါရဲ့ ရောဂါပျောက်လိမ့်မယ်” ဟု သူ့တတ်တိုင်း ပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ယေရှုဟ လှည့်ယွေ့ ကျေ့ရင် အဲမိန်းမဟို မျော်သဖြင့် “ငါ့သမီး၊ မစိုးရိမ်နဲ့။ နင်ရဲ့ယုံကြည်ခြင်းဟ နင်ရဲ့ ရောဂါပျောက်စေပီ” ဟု မိန့်အယ်။ အဲအချိန်နှိုက်ပင် အဲမိန်းမရဲ့ရောဂါ ပျောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","အဲပင်းရင် ယေရှုဟ အရာဆိနေအိုင်ဟို ရောက်အယ်။ အသုဘအတွက် တီးမှုတ်သူလို့နဲ့ အုန်းအုန်းသဲသဲ ပြုကြသော သူများဟို ကိုယ်တော် မျော်သောအခါ၊ ");
INSERT INTO dnv_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ယေရှုဟ “ဖယ်ဆှားကြလော့။ မိနီငယ်သေတာ မဟုတ် အိပ်မွေ့လျက်သာ နေအယ်” ဟု မိန့်အယ်။ အဲပင်းရင် သူလို့အားလုံးဟ ယေရှုဟို လှောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ယေရှုဟ လူလို့ဟို အပြင်ဟို ထွက်စေပင်းနောက်၊ ကိုယ်တော်ဟ အခန်းထဲဟို ဝင်ယွေ့ မိနီငယ်ရဲ့ လက်ဟို ကိုင်ရာ၊ မိနီငယ်ဟ ထလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","အဲသတင်းဟ တပြေလုံးနှိုက် နှံ့ပြားကျော်စောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ယေရှုဟ အဲအရပ်မှ ထွက်စဉ် မျက်မမြင်နေယောက်ဟ “ဒါဝိဒ်ရဲ့ သားတော်၊ ငါလို့ဟို သနားမန့်” ဟု ဟစ်အော်လျက် ကိုယ်တော်ရဲ့ နောက်တော်ဟို လိုက်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ယေရှုဟ နေအိုင်ထဲဟို ဝင်သောအခါ၊ အဲမျက်မမြင်လို့ဟ ကိုယ်တော်ဆေဟို လာကြအယ်၊ အားပင်း ယေရှုဟ “ဟေအရာဟို ငါ လုပ်နိန်အယ်ဟု နင်လို့ ယုံကြည်ကြသလော” ဟု မေးရင် အဲသူလို့ဟ “ယုံကြည်ပါအယ်၊ သခင်ဘုရား” ဟု ပြန်ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","အဲအခါ ယေရှုဟ သူလို့ရဲ့ မျက်စေ့များဟို တို့ထိယွေ့ “နင်လို့ရဲ့ ယုံကြည်လဲ့အတိုင်း နင်လို့နှိုက် ဖြစ်စေ” ဟု မိန့်ပင်း ");
INSERT INTO dnv_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","သူလို့ဟ မျက်စေ့ မျော်လာအယ်။ ယေရှုဟလည်း “အဲအမှုဟို စသူဟိုမျှ မသိစေနဲ့” ဟု ကြပ်တည်းစွာ သတိပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","အဲလိုလဲ အဲသူလို့ဟ ထွက်သွားယွေ့ ကိုယ်တော်ရဲ့သတင်းဟို အေးတပြေလုံးနှိုက် နှံ့ပြားကျော်စောစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","အဲသူလို့ဟ ထွက်သွားကြစဉ်၊ နတ်ဆိုးစွဲသောကျောန့် စကားမပြောနိန်သော လူတယောက်ဟို ကိုယ်တော်ဆေဟို ခေါ်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","အဲလိုလဲ နတ်ဆိုးဟို မောင်းထုတ်လိုက်တာနဲ့ တပြိုင်နက် စကားအသောသူဟ စကားစပြောလေအယ်။ လူအားလုံးလို့ဟ ရမ်းဆာ့အံ့ဩကြလျက် “ဟေလိုအရာမျိုးဟို ဣသရေလအမျိုးတွင် ငါလို့ မမျော်စဖူး” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","အဲလိုလဲ ဖာရိရှဲလို့ဟ “သူဟ နတ်ဆိုးခေါင်းဆောင်ဟို အမှီပြုယွေ့ နတ်ဆိုးလို့ဟို မောင်းထုတ်အယ်” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ယေရှုဟ မြို့ရွာဆိသမျှဟို လှည့်လည်ပင်းရင်၊ တရားဇရပ်များတွင် သွန်သင်ယွေ့၊ နိုင်ငံတော်နဲ့ယှဉ်သော သတင်းကောင်းအကျောန်းဟို ဟောပြောလျက် ဖျားနာခြင်းနဲ့ အနာရောဂါအမျိုးမျိုးလို့ဟို ပျောက်ကင်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ကိုယ်တော်ဟ လူအုပ်ကြီးလို့ဟို မျော်သောအခါ သူလို့ဟ သိုးထိန်းမဲ့လဲ့ သိုးလို့လိုမျိုး အားကိုးစရာ မဆိ၊ ပူပင်သောကရောက်လျက် နေကြသောကျောန့် သူလို့အပေါ်မှာ သနားကြင်နာစိတ် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","အဲအခါ ကိုယ်တော်ဟ “ရိတ်သိမ်းရန် စပါးများသော်လည်း ရိတ်သိမ်းသောသူလို့ဟ ရမ်းဆာ့နည်းလအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","အဲကျောန့် လုပ်ဆောင်သောသူလို့ဟို စပါးရိတ်စေဖို့ စေလွှတ်မဲ့အကျောန်း၊ စပါးဆှင်ဟို ဆုတောင်းကြလော့” ဟု သူ့ရဲ့တဘဲ့တော်လို့အား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ယေရှုဟ တဆယ့်နေပါးသော တဘဲ့တော်လို့ဟို အထံတော်သို့ ခေါ်ပင်းနောက် ညစ်ညူးသော နတ်များဟို မောင်းထုတ်နိန်ရန်နဲ့ ရောဂါအမျိုးမျိုးမှစသော ဖျားနာခြင်းဆိသမျှဟို ပျောက်ကင်းစေရန် တန်ခိုးအာဏာဟို ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","တမန်တော် တဆယ့်နေပါးလို့ရဲ့ နာမယ်ဟ ပထမမှာ ပေတရုဟူယွေ့ ခေါ်သော ရှိမုန်နဲ့ သူ့ညီအန္ဒြေ၊ ဇေဗေဒဲရဲ့သား ယာကုပ်နဲ့ သူ့ညီယောဟန်၊ ");
INSERT INTO dnv_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ဖိလိပ္ပုနဲ့ ဗာသောလမဲ၊ သောမနဲ့ အခွန်ခံသူ မဿဲ၊ အာလဖဲရဲ့သား ယာကုပ်နဲ့ သဒ္ဒဲ၊ ");
INSERT INTO dnv_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","မျိုးချစ်စိတ်ဆိသူ ရှိမုန်နဲ့ ကိုယ်တော်ဟို သစ္စာဖောက်သူ ယုဒရှကာရုတ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","တဆယ့်နေပါးသောသူလို့ဟို ယေရှုဟ စေလွှတ်ယွေ့ မိန့်တာဟ “တပါးအမျိုးသားလို့ ဆိရာဟို မသွားကြနဲ့ အဲဟာမဟုတ်ရင် ရှမာရိမြို့ထဲဟို မဝင်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ဣသရေလအမျိုးရဲ့ ပျောက်သော သိုးများဆိရာဟိုသာ သွားကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","နင်လို့သွားပင်း ‘ခေါန်းခင်နိုင်ငံတော် တည်လုနီးပီ’ ဟု ဟောပြောကြလော။ ");
INSERT INTO dnv_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","မကျန်းမာသူလို့ဟို ကျန်းမာစေကြလော့၊ သေသူလို့အား ပြန်ပင်း ဆှင်စေကြလော့၊ အရေပြားရောဂါသည်လို့ဟို သန့်စင်စေကြလော့၊ နတ်ဆိုးလို့ဟို မောင်းထုတ်ကြလော့၊ နင်လို့ဟ အခမဲ့ရကြပီ ဖြစ်ယွေ့ အခမဲ့ ပေးကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ခါးကြိုးတွင် ဆွေ၊ ငွေ၊ ကြေး၊ ပိတ်ဆန်လို့ဟို မဆောင်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","လမ်းခရီးဖို့ ခရီးဆောင်လွယ်အိုက်၊ အင်္ကျီအပို အဲဟာမဟုတ်ရင် ဖိနပ် အဲဟာမဟုတ်ရင် တောင်ဝှေးလို့ဟို မယူကြနဲ့။ အလုပ်လုပ်သောသူအား သူလို့လိုအပ်တာဟို ပေးသင့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“မြို့ အဲဟာမဟုတ်ရင် ရွာဟို နင်လို့ ဝင်သောအခါ နင်လို့အား ကြိုဆိုရန် ဆန္ဒဆိမယ့်သူဟို သွားယွေ့ ဆာကြလော့၊ အဲမြို့ရွာမှ ထွက်ခွာယွေ့ မသွားမချင်း အဲသူရဲ့ ဆေမှာ တည်းခိုကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","နေအိုင်ဟို ဝင်သောအခါ ‘နင်လို့နဲ့အတူ ငြိမ်သက်ခြင်း ဆိပါစေ’ ဟု နှုတ်ဆက်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","အေးနေအိုင်ဟ ထိုက်တန်ရင် နင်လို့ရဲ့ ငြိမ်သက်ခြင်းဟ အဲသူလို့အပေါ် သက်ရောက်မန့်စေ မထိုက်တန်ရင် နင်လို့ရဲ့ ငြိမ်သက်ခြင်းဟ နင်လို့ဆေဟို ပြန်လာပါစေ။ ");
INSERT INTO dnv_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","အားပင်း နင်လို့ဟို တချို့ နေအိုင်၊ မြို့တွေဟ မကြိုဆို အဲဟာမဟုတ်ရင် နင့်ရဲ့ စကားဟို နားမထောင်ရင် နင်လို့ရဲ့ ခြေထောက်မှ ဖုန်မှုန့်ဟို ခါချပင်း အေးနေရာမှ ထွက်ခွာခဲ့ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","အမန်အကန် နင်လို့အား ငါပြောတာဟ တရားစီရင်ရာနေ့နှိုက် အဲမြို့ဟ သောဒုံမြို့နဲ့ ဂေါမောရမြို့လို့ထက် ပိုပင်း အပစ်ဒဏ် ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“နားထောင်ကြမန့်၊ သိုးများအား ဝံပုလွေစုထဲဟို စေလွှတ်သလိုမျိုး နင်လို့အား ငါစေလွှတ်အယ်။ မြွေလိုမျိုး ပါးနပ်လိမ္မာကာ ချိုးတူးမလိုမျိုး ရိုးသားဖြူစင်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","သတိထားကြလော့၊ သူလို့ဟ နင်လို့အား ဖမ်းဆီးယွေ့ တရားရုံးဟို ပို့ဆောင်ကြပင်း သူလို့ဟ နင်လို့ဟို တရားဇရပ်များတွင် ဖိုင်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","နင်လို့ဟ ငါ့အတွက်ကျောန့် အာဏာပိုင်များနဲ့ ဘုရင်များ ဆေ့မှောက်ဟို ရောက်ရကြလိမ့်မယ်။ အဲသူလို့နဲ့ တပါးအမျိုးသားလို့အား သက်သေဖြစ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","နင်လို့ဟို သူလို့လက်ဟို အပ်ခံရသောအခါ၊ စလိုပြောဆိုရမယ် အဲဟာမဟုတ်ရင် ပစာစကားဟို ပြောရမယ်အကျောန်းဟို မစိုးရိမ်ကြနဲ့၊ နင်လို့ ပြောဆိုရမဲ့စကားများဟို အဲအချိန်နှိုက်ပင် နင်လို့ရဆိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","အကျောန်းမှာ အေးစကားများဟ နင်လို့ရဲ့ စကားများ မဟုတ်၊ သူလို့ဟ နင်လို့အဖ ဘုရားရဲ့ ဝိညာဉ်တော်ဟ နင်လို့အားဖြင့် လာသော စကားများ ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ညီအကိုအချင်းချင်း တယောက်နဲ့ တယောက် သေစေရန် အပ်ကြပင်း အဖလို့ဟ သူလို့ရဲ့ လူပဲ့သငယ်များ အေးတိုင်းတိုင်း ပြုကြလိမ့်မယ်၊ လူပဲ့သငယ်လို့ဟလည်း သူလို့ရဲ့ မိဘများဟို ဆန့်ကျင်ပုန်ကန်ယွေ့ သူလို့ဟို သေစေရန် ပြုကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","လူတိုင်းဟ ငါကျောန့် နင်လို့ဟို မုန်းကြလိမ့်မယ်။ အဲလိုလဲ အဆုံးတိုင်အောန် တည်ကြည်သူဟ ကယ်တင်ခြင်းခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","သူလို့ဟ နင်လို့ဟို မြို့တမြို့တွင် ညှဉ်းဆဲနှိပ်စက်သောအခါ အခြားတမြို့ဟို ထွက်ပြေးကြလော့။ အမန်အကန် နင်လို့အား ငါပြောတာဟ နင်လို့သည် ဣသရေလမြို့ဆိသမျှဟို သွားလာယွေ့ မပင်းခင် လူသားဟ ကြွလာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“တဘဲ့ဟ ဆရာထက်မသာ၊ ကျွန်ဟ သခင်ထက်မသာ။ ");
INSERT INTO dnv_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","တဘဲ့ဟ သူလို့ရဲ့ ဆရာလိုမျိုးလည်းကောင်း၊ ကျွန်ဟ သူလို့ရဲ့ သခင်လိုမျိုးလည်းကောင်း ဖြစ်ရင် လုံလောက်အယ်။ အိုင်ထောင်ဦးစီးဟို ဗေလဇေဗုလဟု ခေါ်ကြရင် သူရဲ့ နေအိုင်သူအိုင်သားများဟို စလောက် ပိုယွေ့ ခေါ်ကြလိမ့်မလဲ။ ");
INSERT INTO dnv_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“အေးလိုမို့ လူလို့ဟို မကြောက်ကြနဲ့။ အခု ဖုံးအုပ်ထားလဲ့ အရာဟူသမျှဟ ထင်ပေါ်လာပင်း လျှို့ဝှက်ချက် မန်သမျှဟလည်း သိယွေ့ လာရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","မိုက်နှိုက် နင်လို့အား ငါပြောသောအရာများဟို နင်လို့ဟ အလင်းနှိုက် ကြားပြောကြလော့၊ နင်လို့နားနှိုက် ပြောယွေ့ ကြားတဲ့အရာများဟို အိုင်မိုးပေါ်မှာ ဟောကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ခန္ဓာကိုယ်ဟို သတ်နိန်သော်လည်း ဝိညာဉ်ဟို မသတ်နိန်သော သူများအား မကြောက်ကြနဲ့။ ခန္ဓာကိုယ် နဲ့ဝိညာဉ် နေမျိုးစလုံးဟို ငရဲတွင် ဖျက်ဆီးနိန်သော သူဟိုသာလျှင် ကြောက်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","စိန်စာ နေကောင်ဟို ပဲနိတပြားနဲ့ ရောင်းတာ မဟုတ်လော၊ အဲလိုမို့ နင်လို့အဖရဲ့ ခွင့်ပြုချက်မရဘဲ စိန်စာတကောင်မျှ မြေပေါ် မကျရ။ ");
INSERT INTO dnv_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","အားပင်း နင်လို့ဦးခေါင်းဟ ဆံပင်များဟိုပင်လျှင် အကုန်ရေတွက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","အဲလိုမို့ မကြောက်ကြနဲ့၊ နင်လို့ဟ စိန်စာ အမြောက်အမြားထက် ရမ်းဆာ့ပိုယွေ့ အဖိုးထိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“အဲလိုမို့ စသူမဆို လူလို့ဆေ့တွင် ငါ့ဟို ဝန်ခံရင်၊ ခေါန်းခင်ဘုံနှိုက်ဆိသော ငါ့အဖရဲ့ ဆေ့တွင် အေးသူဟို ငါဝန်ခံမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","အဲလိုလဲ ငါ့ဟို လူလို့ဆေ့တွင် ငြင်းပယ်သူ စသူမဆို ခေါန်းခင်ဘုံနှိုက် ဆိသော ငါ့အဖရဲ့ ဆေ့တွင် ငါ ငြင်းပယ်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ဟေလောကဟို ငြိမ်သက်ခြင်း ပေးရန် ငါလာတာဟု မထင်ကြနဲ့။ ငါဟ ငြိမ်သက်ခြင်းပေးရန် လာတာ မဟုတ်၊ ခိုက်ရန်ဖြစ်ပွားရန်သာ ငါ လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","သားနဲ့ သူလို့ရဲ့အဖ၊ သမီးနဲ့ သူလို့ရဲ့အမေ့၊ ချွေးမနဲ့ သူလို့ရဲ့ယောက္ခမလို့ ရန်ဖက်ဖြစ်စေရန် ငါ လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","လူတဦးတယောက်ရဲ့ ရန်သူများဟ သူ့ရဲ့ အိုင်သူအိုင်သားများ ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“တစုံတယောက်ဟ သူလို့ မိဖဟို ငါ့ထက်ပိုယွေ့ ချစ်သူဟ ငါနဲ့မထိုက်တန်၊ တစုံတယောက်ဟ သူလို့ရဲ့သား အဲဟာမဟုတ်ရင် သမီးဟို ငါ့ထက်ပိုယွေ့ ချစ်သူဟ ငါနဲ့မထိုက်တန်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","စသူမဆို သူလို့ရဲ့ လက်ဝါးကပ်တိုင်ဟို ထမ်းယွေ့ ငါ့နောက်ဟို မလိုက်သောသူဟ ငါနဲ့ မထိုက်တန်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","မိမိအသက်လုံခြုံမှု ရဆိရန် ကြိုးပမ်းသူဟ အသက်ဆုံးရှုံးလိမ့်မယ်၊ အဲလိုလဲ ငါ့အတွက် အသက်ဆုံးရှုံးသူဟ မိမိအသက် လုံခြုံမှု ရဆိလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“နင်လို့ဟို လက်ခံသောသူဟ ငါ့ဟို လက်ခံအယ်။ ငါ့ဟို လက်ခံသောသူဟ ငါ့ဟို စေလွှတ်သောသူဟို လက်ခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ပရောဖက်ဟူသော အမယ်နာမဟို ထောက်ယွေ့ ပရောဖက်ဟို လက်ခံသောသူဟ ပရောဖက်နဲ့ဆိုင်သော အကျိုးကျေးဇူးဟို ရဆိလိမ့်မယ်၊ အားပင်း ဖြောင့်မတ်သောသူ ဟူသော အမယ်နာမဟို ထောက်ယွေ့ ဖြောင့်မတ်သောသူဟို လက်ခံသောသူဟလည်း ဖြောင့်မတ်သောသူနဲ့ဆိုင်သော အကျိုးကျေးဇူးဟို ရဆိလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","အမန်အကန် နင်လို့အား ငါပြောတာဟ၊ ငါရဲ့ တဘဲ့များအနက် အသိမ်ငယ်ဆုံးသူ တစုံတယောက်အား ငါရဲ့ မျက်နှာဟို ထောက်ယွေ့ သောက်ယေတမုတ်ဟို ပေးသောသူဟ အကျိုးဟို မခံစားဘဲ မနေရ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ယေရှုဟ အဲတဘဲ့တော် တဆယ့်နေယောက်လို့အား ဩဝါဒပေးပင်သောအခါ ကိုယ်တော်ဟ အနီးအနားဆိမြို့များတွင် ဟောပြောသွန်သင်ရန် အေးအရပ်မှ ထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ခရစ်တော် ပြုသော အမှုများအကျောန်းဟို နှစ်ခြင်းဆရာယောဟန်ဟ ထောင်ထဲတွင် ကြားရသောအခါ၊ မိမိရဲ့ တဘဲ့တော်များဟို ကိုယ်တော်ဆေ စေလွှတ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“ကိုယ်တော်ဟ ကြွလာမယ့်အဆှင်လော၊ အဲဟာမဟုတ်ရင် ငါလို့ဟ အခြားသောသူဟို စောင့်မျော်ရမယ်လော” ဟု မေးစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ယေရှုဟ အဲသူလို့အား “နင်လို့ မျော်ရ၊ ကြားရလဲ့ အရာများဟို ယောဟန်ဆေ သွားပင်း ပြောပြကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","မျက်စေ့ကန်းသူလို့ဟ မျက်စေ့မျော် ရကြအယ်။ ခြေမသန်သောသူလို့ဟ လမ်းဆှောက်နိန်ကြအယ်။ အရေပြားရောဂါစွဲသူလို့ဟ သန့်စင်သွားကြအယ်။ နားပင်းသူလို့ဟ ကြားရကြအယ်။ သေသူလို့ဟ အသက်ပြန်ဆှင်ခြင်းဟို ခံရကြပင်း ဆင်းရဲသူလို့ဟ သတင်းကောင်းဟို ကြားရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ငါရဲ့အပေါ်နှိုက် သံသယကင်းသူလို့ဟ မင်္ဂလာဆိကြအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ယောဟန်ရဲ့ တဘဲ့များပြန်သွားကြစဉ်၊ ယေရှုဟ လူအုပ်ကြီးလို့အား ယောဟန်အကျောန်း ပြောတာဟ “နင်လို့ဟ စလိုအရာဟို ကျေ့ရှုရန် တောကန္တာရဟို သွားလုန်း။ လေတိုက်ယွေ့ လှုပ်သောကျူပင်ဟိုလော။ ");
INSERT INTO dnv_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","အဲလိုမှမဟုတ်ရင် စလိုအရာဟို ကျေ့ရှုရန် ထွက်သွားလုန်း။ ဝတ်ကောင်းစားလ ဝတ်ဆင်ထားသူလော။ ဝတ်ကောင်းစားလ ဝတ်ဆင်ထားသူများဟ ဘုရင်နန်းတော်များနှိုက် ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","အဲပင်းရင် စလိုအရာဟို ကျေ့ရှုရန် ထွက်သွားလုန်း။ ပရောဖက်ဟိုလော၊ မန်အယ်၊ နင်လို့ဟ ပရောဖက်ထက်ပင် ကြီးမြတ်သောသူ ဖြစ်အယ်ဟု နင်လို့အား ငါပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‘နားထောင်လော့၊ နင်ဆေ့နှိုက် နင့်ရဲ့ လမ်းဟို ပြင်ဆင်မယ့် ငါရဲ့ သတင်းသယ်ပို့သူဟို နင့်အရင် ငါစေလွှတ်မယ်’ ဟု ကျမ်းစာနှိုက် ရေးထားတာဟ ဟေသူအကျောန်းပင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","နင်လို့အား ငါ အမန်ပြောတာဟ၊ နှစ်ခြင်းဆရာယောဟန်သည် အသက်ဆှင်ခဲ့ဖူးသူတိုင်းထက် ပိုပင်းကြီးမြတ်အယ်။ အဲလိုလဲ ခေါန်းခင်နိုင်ငံတော်နှိုက် အသိမ်ငယ်ဆုံးသောသူဟ ယောဟန်ထက် ကြီးမြတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","နှစ်ခြင်းဆရာယောဟန် စတင်ဟောပြောချိန်မှ ခနေ့တိုင်အောန်၊ ခေါန်းခင်နိုင်ငံတော်ဟ အကြမ်းဖက်လို့ရဲ့ တိုက်ခိုက်မှုဟို ခံရအယ်၊ အားပင်း အကြမ်းဖက်သမားလို့ဟ အဲနိုင်ငံဟို သိမ်းယူရန် ကြိုးစားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","အကျောန်းမှာ ပရောဖက်ကျမ်းများနဲ့ မောရှေရဲ့ပညတ္တိကျမ်းဆိသမျှဟ ယောဟန် လက်ထက်တိုင်အောန် ပရောဖက်ပြုခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","အားပင်း အဲအရာဟို နင်လို့လက်ခံရန် ဆန္ဒဆိလျှင်၊ ယောဟန်ဟ ပေါ်ထွန်းလာရမယ့် ဧလိယဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ကြားရန် နားဆိသောသူ စသူမဆို ကြားပါစေ။ ");
INSERT INTO dnv_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ငါဟ ဟေခေတ်လူလို့ဟို ပစာလိုပုံနှိုင်းရမလုန်း။ သူလို့ဟ ဆေးတွင် ထိန်လျက်နေလဲ့ လူပဲ့သငယ်နဲ့တူကြအယ်။ အုပ်စုတစုဟ အခြားသူများဟို အော်ယွေ့ ");
INSERT INTO dnv_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘ငါလို့ဟ နင့်အတွက် မင်္ဂလာဆောင်သီချင်းဟို တီးမှုတ်ပေမဲ့ နင်လို့ဟ မကကြ။ ငါလို့ဟ အသုဘသီချင်းတွေဟို ဆိုကြပေမဲ့ နင်လို့ဟ မငိုကကြ။’ ");
INSERT INTO dnv_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ယောဟန်ဟ အစာဆှောင်လျက် မသောက်မစားဘဲ နင်လို့ဆီလာသောအခါ၊ လူတိုင်းဟ ‘သူဟ နတ်ဆိုးစွဲသောသူ ဖြစ်အယ်’ ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","လူသားဟ လာသောအခါနှိုက် သူဟ စားလျက်သောက်လျက်နေသော် ‘အေးသူဟို ကျေ့လော့၊ သူဟ စားကြူးသောက်ကြူးသူ ဖြစ်အယ်၊ အခွန်ခံသူလို့နဲ့ အခြားဆိုးသွမ်းသောသူလို့ရဲ့ မိတ်ဆွေ ဖြစ်အယ်’ ဟု ဆိုကြအယ်။ ဘုရားသခင်ရဲ့ ဉာဏ်ပညာတော်ဟ မန်ကန်ကျောန်းဟို မိမိရဲ့ လုပ်ဆောင်မှုများဟ ဖော်ပြကြအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ယေရှုဟ အံ့ဩဖွယ် နိမိတ်လက္ခဏာများဟို ပြခဲ့လဲ့ မြို့များဟ သူလို့ရဲ့အပစ်များမှ နောင်တမရကြသဖြင့် ကိုယ်တော်ဟ အဲမြို့လို့အား ဟေသို့ပစ်တင်ဆုံးမအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ခေါရာဇိန်မြို့ ကြောက်စရာကောင်းလဲ့အရာဟ နင့်ဟို စောင့်နေအယ်၊ အေးတိုင်းတိုင်း ဗက်ဇဲဒမြို့လည်း ကြောက်စရာကောင်းလဲ့အရာဟလည်း နင့်ဟို စောင့်နေအယ်၊ နင်လို့ဆေမှာ ပြခဲ့လဲ နိမိတ်လက္ခဏာများဟို တုရုမြို့နဲ့ ဇိဒုန်မြို့တွင်ပြခဲ့ရင် လူများလို့ဟ အရင်အခါဟ လျှော်တေအဝတ်ဟို ဝတ်ပင်း၊ ပြာမှုန့်ဟို သူလို့ပက်ပင်း ထိန်လျက် သူလို့ဟ မိမိလို့ရဲ့အပစ်များမှ ပြန်လှည့်ကျောန်းဟို ပြသမယ်ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ငါအမန်အကန် နင်လို့အားပြောတာဟ တရားဆုံးဖြတ်ရာနေ့နှိုက် နင်လို့ထက် တုရုမြို့နဲ့ ဇိဒုန်မြို့ဟို ဘုရားသခင်ဟ ကရုဏာပိုပင်းပြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","အားပင်းနင့်အတွက်၊ ကပေနောင်မြို့ နင်ဟ ခေါန်းခင်မှာ မြောက်စားခြင်းဟို ခံလိုသလော၊ ငရဲထိ လောချခြင်းဟို ခံရလိမ့်မယ်၊ နင်လို့ဆေတွင် ငါပြုခဲ့လဲ့ နိမိတ်လက္ခဏာများဟို သောဒုံမြို့တွင်သာ ပြုခဲ့ရင်၊ အေးမြို့ဟ ခုနေ့တိုင်အောန် တည်လျက်ဆိပေမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","အဲလိုလဲ နင်လို့အား ငါ ပြောတာဟ တရားစီရင်ရာနေ့နှိုက် သောဒုံမြို့ထက်ပိုယွေ့ နင်ဟ အပစ်ဒဏ်ခံရလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","အဲအချိန်တွင် ယေရှုဟ “ခေါန်းခင်နဲ့ မြေကြီးရဲ့ အဆှင်သခင်ဖြစ်သော အဖ၊ ကိုယ်တော်ဟ အသိပညာဆှင်များအား သိခွင့်မပေးဘဲထားလဲ့အရာများဟို ပညာမဲ့သူလို့အား ဖွင့်ပြသဖြင့် ကျေးဇူးတော်ဟို ချီးမွန်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","မန်ပါအယ် အဖ၊ အကျောန်းမှာ ဆေ့တော်နှိုက် နှစ်သက်သောအရာ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ငါ့ခမည်းတော်ဟ ခပ်သိမ်းသောအရာလို့ဟို ငါ့အား ပေးအပ်ထားလေပီ။ ခမည်းတော်မှတပါး အခြားစသူမျှ သားတော်ဟို မသိ။ ခမည်းတော်ဟိုလည်း သားတော်နဲ့ သားတော်ဖွင့်ပြလိုသူများမှတပါး အခြားစသူမျှ မသိ။ ");
INSERT INTO dnv_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ဝန်လေးယွေ့ ပင်ပန်းသူအပေါင်းလို့ ငါ့ဆေဟို လာကြလော့။ ငါဟ ချမ်းသာပေးမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ငါဟ နူးညံ့သိမ်မွေ့ယွေ့ စိတ်နေလုံး နှိမ့်ချသောကျောန့် ငါတင်သော ထမ်းပိုးဟို ထမ်းယွေ့ ငါရဲ့ ဆေတွင် နည်းနာခံယူကြလော့၊ နင်လို့ဟ ချမ်းသာရဆိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","အကျောန်းမှာ ငါ ထမ်းပိုးဟ ထမ်းရလွယ်ယွေ့ ငါတင်သောဝန်ဟလည်း ပေါ့အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","အေးနောက်မကြာခင် ဥပုသ်နေ့နှိုက် ယေရှုဟ တချို့ဂျုံခင်းလို့ဟို ဖြတ်ယွေ့သွားသောအခါ တဘဲ့တော်လို့ဟ မွတ်သဖြင့် ဂျုံနှံများဟို ဆွတ်ပင်း စားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","အဲအရာဟို ဖာရိရှဲလို့မျော်သောအခါ၊ သူလို့ဟ ယေရှုအား “ကျေ့မန့်၊ ကိုယ်တော်ရဲ့ တဘဲ့များဟ ဥပုသ်နေ့နှိုက် ပညတ်ဟို ကာပြန်ယွေ့ ပြုနေသလော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ယေရှုဟ “ဒါဝိဒ်မင်းဟ မိမိနဲ့ အဖော်လို့ မွတ်သောအခါ ပစာသို့ပြုခဲ့ကျောန်း နင်လို့တခါမျှ မဖတ်ဝူးသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","သူဟ ဘုရားသခင်ရဲ့ အိုင်တော်ဟို ဝင်ယွေ့ ယဇ်ပုရောဟိတ်မှတပါး သူတတ်တိုင်းရော သူနဲ့အတူဆိသော သူလို့ပါ စားခွင့်မဆိသော ဆေ့တော်မုန့်ဟို စားခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","အဲဟာမဟုတ်ရင် ဗိမာန်တော်တွင် ယဇ်ပုရောဟိတ်လို့ဟ ဥပုသ်နေ့ဆိုင်ရာ ပညတ်ဟို ချိုးဖောက်သော်လည်း အပစ်မသင့်ကျောန်း မောရှေရဲ့ပညတ်ကျမ်းတွင် မဖတ်ဝူးကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","နင်လို့ဟို ငါပြောတာဟ ဟေအရပ်တွင် ဗိမာန်တော်ထက် ကြီးမြတ်သော အရာဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘ငါဟ တရိစ္ဆာန်နဲ့ ယဇ်ပူဇော်ခြင်း မဟုတ်ဘဲ သနားကြင်နာခြင်းဟို အလိုဆိအယ်’ ဟု ကျမ်းစကားဟ စလိုအရာဟို ဆိုလိုကျောန်း နင်လို့ အမန်သိခဲ့ရင်၊ အပစ်မဆိသူများဟို ပစ်တင်ရှုတ်ချကြလိမ့်မယ် မဟုတ်၊ ");
INSERT INTO dnv_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","အကျောန်းမှာ လူသားဟ ဥပုသ်နေ့ရဲ့ အဆှင်ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ယေရှုဟ အဲအရပ်မှကြွယွေ့ တရားဇရပ်တခုဟို ဝင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","တရားဇရပ်ထဲတွင် လက်တဖက်သေသူ လူတယောက်ဆိအယ်။ လူအချို့လို့ဟ ယေရှုဟို ပစ်တင်စွပ်စွဲလိုသောကျောန့် သူလို့ဟ ကိုယ်တော်အား “ဥပုသ်နေ့နှိုက် အနာရောဂါ ပျောက်ကင်းစေခြင်းဟ ငါလို့ရဲ့ ပညတ်တရားဟို ဆန့်ကျင်သလော” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ယေရှုဟ “နင်လို့ရဲ့ သိုးတကောင်ဟ ဥပုသ်နေ့နှိုက် တွင်းထဲဟို ပုတ်ကျအယ်ဆိသော် အဲသိုးဟို မဆွဲတင်ဘဲနေမယ့်သူ နင်လို့တွင် ဆိမန့်သလော။ ");
INSERT INTO dnv_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","လူဟ သိုးထက် ရမ်းဆာ့ပိုယွေ့ အဖိုးတန်တာ မဟုတ်မန့်လော။ အဲလိုမို့ ငါလို့ရဲ့ ဥပဒေအရ ဥပုသ်နေ့နှိုက် ကောင်းသောအမှုဟို ကူညီနိန်ခွင့် ဆိသလော” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","အဲပင်းရင် ကိုယ်တော်ဟ လက်သေသူအား “နင့်ရဲ့ လက်ဟို ဆန့်လော့” ဟု မိန့်အယ်။ အဲသူဟ လက်ဟို ဆန့်လိုက်ခါ အခြားလက်တဖက်လို အကောင်းတိုင်းတိုင်း ပြန်ဖြစ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","အဲပင်းရင် ဖာရိရှဲလို့ဟ ထွက်သွားကြပင်း ယေရှုဟို သတ်ရန် ကြံစည်တိုင်ပင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ဟေသို့ ကြံစည်ကျောန်းဟို ယေရှု ကြားသိသောအခါ အေးအရပ်မှ ကြွသွားပင်း ရမ်းဆာ့သော လူလို့ဟ နောက်တော်ဟို လိုက်ကြအယ်။ ယေရှုဟ ဖျားနာသူလို့ရဲ့ ရောဂါများဟို ပျောက်ကင်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","မိမိရဲ့အကျောန်းဟို သူတပါးလို့အား မပြောကြားရန် အဲသူလို့ဟို အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ဟေသို့ ပညတ်ရခြင်းမှာ ပရောဖက် ဟေရှာယအားဖြင့် ဘုရားသခင်ပေးသော မိန့်သောအရာမှာ ပြေ့စုံခြင်းဟို ရောက်မယ့်ဖြစ်အယ်။ အေးမိန့်ချက်ဟ ");
INSERT INTO dnv_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ငါနှစ်သက်မြတ်နိုးသူ၊ ငါရွေးချယ်သော ငါ့အစေခံဟို ကျေ့ကြလော့၊ ငါရဲ့ ဝိညာဉ်တော်ဟို သူရဲ့အပေါ်ဟို သက်ရောက်စေမယ်။ သူဟ ငါတရားစီရင်ချက်ဟို လူမျိုးတကာလို့အား ကြေညာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","သူဟ ငြင်းခုံခြင်း၊ အဲဟာမဟုတ်ရင် ဟစ်အော်ခြင်းဟို ပြုလိမ့်မယ်မဟုတ်၊ လမ်းတွင် သူရဲ့ အသံဟို စသူမျှကြားရလိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","သူဟ ကွေ့ကောက်လျက်ဆိသော ကျူပင်ဟို မချိုး၊ မီးမတောက်ဘဲ တငွေ့ငွေ့လောင်နေသော မီးစာဟို မငြိမ်းသတ်။ သူဟ တရားမျှတမှု စိုးမိုးလာလဲ့တိုင်အောန် လုပ်ဆောင်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","လူမျိုးတကာလို့ဟလည်း သူရဲ့ နာမနှိုက် မျော်လင့်အားထားကြလိမ့်မယ်” ဟူယွေ့ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","အေးနောက် လူအချို့လို့ဟ နတ်ဆိုးစွဲသောကျောန့် မျက်စေ့ကန်းပင်း အနေသူတယောက်ဟို ယေရှုဆေဟို ခေါ်ခဲ့ကြအယ်။ ယေရှုဟ အေးသူဟို ကျန်းမာစေသောကျောန့် အဲသူဟ မျက်စေ့မျော်လာပင်းရင် စကားပြောနိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","လူပရိသတ်အားလုံးလို့ဟ ယေရှုလုပ်ဆောင်လဲ့ အရာဟို အံ့ဩကြအယ်။ သူလို့ဟ “ဟေသူဟ ဒါဝိဒ်ရဲ့ သားတော်ဖြစ်မန့်မယ်လော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ဟေအရာဟို ဖာရိရှဲလို့ ကြားသောအခါ သူလို့ဟ “ဟေသူသည် နတ်ဆိုးမင်း ဗေလဇေဗုလဟို အမီပြုယွေ့ နတ်ဆိုးလို့ဟို မောင်းထုတ်သူ ဖြစ်အယ်” ဟု ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ယေရှုဟ သူလို့ရဲ့ စဉ်းစားဆင်ခြင်မှုများဟို သိသဖြင့် ကိုယ်တော်ဟ သူလို့အား “နိုင်ငံတခုတွင် အတွင်းနှိုက် စိတ်ဝမ်းကွဲပြားလျက် အချင်းချင်းတိုက်ခိုက်နေရင် အဲနိုင်ငံဟ မကြာခင်ပျက်စီးလိမ့်မယ်။ အားပင်း အတွင်းနှိုက် စိတ်ဝမ်းကွဲပြားလျက် နေသောမြို့တိုင်း အဲဟာမဟုတ်ရင် မိသားစုဟလည်း မရပ်မတည်နိန်ရာ။ ");
INSERT INTO dnv_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","စာတန်ဟ စာတန်ဟို မောင်းထုတ်ရင် မိမိအတွင်းနှိုက် ဆန့်ကျင်ကွဲပြားအယ်။ အဲလိုဖြစ်ရင် သူရဲ့နိုင်ငံဟ စလို တည်တံ့နိန်မလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ငါဟ ဗေလဇေဗုလဟို အမီပြုယွေ့ နတ်ဆိုးများဟို မောင်းထုတ်တာဆိုရင် နင်လို့ရဲ့ တဘဲ့များဟ စသူဟိုအမီပြုယွေ့ မောင်းထုတ်ကြလုန်း။ အဲလိုမို့ နင်လို့ မားယွင်းကျောန်းဟို နင်လို့ တဘဲ့များရဲ့ အပြုအမူဟပင် သက်သေခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","အဲလိုလဲ ငါဟ ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်ဟို အမီပြုယွေ့ နတ်ဆိုးလို့ဟို မောင်းထုတ်မယ်ဆိုရင် ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ နင်လို့ဆေဟို ရောက်ဆိလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ခွန်အားကြီးသူဟို ဦးစွာ မတုတ်ချေဘဲ သူရဲ့ နေအိုင်ဟို ဝင်ယွေ့ ဥစ္စာပစ္စည်းများဟို စသူဟ လုယူနိန်မလုန်း။ တုတ်ချေပင်းမှသာ သူရဲ့အိုင်ဟို လုယူနိန်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ငါ့ဘက်မှာ မနေသူဟ ငါ့ဟို ဆန့်ကျင်သူဖြစ်အယ်။ ငါနဲ့အတူ မစုမသိမ်းသူဟ ကြဲဖြန့်သူဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","အဲကျောန့် နင်လို့အား ငါပြောတာဟ အပစ်များအားလုံး အတွက်လည်းကောင်း၊ ပစ်မားပြောဆိုလဲ့ စကားများအတွက်လည်းကောင်း လူလို့ အပစ်ဖြေလွှတ်နိန်ခွင့် ဆိပေမဲ့ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ပစ်မားပြောဆိုသူဟ အပစ်ဖြေလွှတ်နိန်ခွင့် မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","လူသားဟို ပစ်မားပြောဆိုသူဟ အပစ်ဖြေလွှတ်နိန်ပေမဲ့ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ပစ်မားပြောဆိုသောသူဟ အခုဖဝါ့ နောင်ဖဝါ့တွင် အပစ်ဖြေလွှတ်လိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“အသီးကောင်းဟို ရလိုလျှင် အပင်ကောင်းဟို စိုက်ရမယ်။ အပင်ညံ့ဟ အသီးညံ့ဟို သီးလိမ့်မယ်။ အသီးဟိုထောက်ပင်း အပင်အကျောန်းဟို သိရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","မြွေပွေးအမျိုးလို့၊ နင်လို့ဟ ဆိုးယုတ်သောသူများဖြစ်လျက် စလို ကောင်းလဲ့စကားဟို ပြောနိန်ကြမလုန်း။ စိတ်နေလုံးနှိုက် ပြည့်လျှံနေလဲ့အရာများဟို နှုတ်ဟ ဖော်ပြတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ကောင်းသောသူဟ ကောင်းသောအရာဟို ဘဏ္ဍာတိုက်အထဲမှ ထုတ်ဖော်တတ်အယ်။ မကောင်းသောသူဟ မကောင်းသောအရာများဟို ဘဏ္ဍာတိုက်အတွင်းမှ ထုတ်ဖော်တတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“နင်လို့အား ငါပြောတာဟ တရားစီရင်ရာနေ့နှိုက် လူလို့ဟ မိမိလို့ အကျိုးမဲ့ပြောဆိုသော စကားများအတွက် စီရင်ခြင်းဟို ခံရကြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","အကျောန်းမှာ နင်လို့ပြောလဲ့ စကားများအားဖြင့် နင်လို့ဟ ဖြောင့်မတ်အယ်ဟု အသိအမှတ်ပြုခံရလိမ့်မယ်။ အားပင်း နင်လို့ပြောလဲ့ စကားများအားဖြင့် အပစ်ဆိအယ်ဟု သတ်မှတ်ခြင်းခံရလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","အဲပင်းရင် အချို့သော ကျမ်းတတ်ဆရာများနဲ့ ဖာရိရှဲများဟ “ဆရာ၊ ငါလို့ဟ ကိုယ်တော်ပြလဲ့ နိမိတ်လက္ခဏာဟို တွေ့ချင်ပါအယ်” ဟု ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ယေရှုဟ “ဆိုးညစ်ယွေ့ ဘုရားမဲ့သော ဟေခေတ်လူလို့ဟ နိမိတ်လက္ခဏာဟို တောင်းဆိုကြအယ် ဟုတ်မောင့်လဲ့။ နင်လို့ဟ ပရောဖက် ယောနရဲ့ နိမိတ်လက္ခဏာမှတပါး မစာနိမိတ်လက္ခဏာဟိုမျှ နင်လို့အား ပေးလိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","အေးနည်းတူ ယောနဟ ငါးကြီးရဲ့ဖိုက်ထဲတွင် သုံးရက်လုံးလုံးနေရသလို လူသားဟလည်း မြေကြီးထဲတွင် သုံးရက်နေရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","တရားစီရင်သောအခါ နိနေဝေမြို့သားလို့ဟ ဟေမျိုးဆက်နဲ့အတူ ထမြောက်လျက် ဟေမျိုးဆက်ရဲ့ အပစ်ဟို ထင်ဆှားစေကြလိမ့်မယ်။ အကျောန်းမှာ သူလို့ဟ ယောနရဲ့ ဟောပြောချက်ကျောန့် နောင်တရကြပင်း ဟေအရပ်တွင် ယောနထက် ကြီးမြတ်လဲ့အရာ ရောက်ဆိနေလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","တရားဆုံးဖြတ်သောနေ့နှိုက် တောင်အရပ်မှ ဘုရင်မဟ ဟေမျိုးဆက်ဘက်နှိုက် ထယွေ့ တရားစီရင်လိမ့်မယ်။ ပစာကို့ အဲဘုရင်မဟ ရှောလမုန်မင်းကြီးရဲ့ ပညာစကားဟို နားထောင်ဖို့ မြေကြီးစွန်းမှ လာအယ်။ ဟေအရပ်နှိုက်ဟ၊ ရှောလမုန်ထက် သာယွေ့ ကြီးမြတ်သောသူဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ညစ်ညမ်းသော နတ်ဟ လူထဲမှထွက်သောအခါ၊ ခြောက်ကပ်ရာအရပ်တွင် ဝေ့ပတ်ပင်း နားနေစရာဟို ဆာတတ်အယ်။ ဟေလို့တနေရာမှ ဆာယွေ့ မတွေ့ရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘ငါထွက်လာခဲ့သော အိုင်ဟိုပြန်မယ်’ ဟု ဆိုအယ်။ အေးနေရာဟို ပြန်ရောက်သောအခါ သပ်ရပ်စွာ လှည်းကျင်းထားတာဟို တွေ့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","အဲပင်းရင် သူဟ သွားယွေ့ မိမိထက် ညစ်ညမ်းသော နတ်ခုနေဦးဟို ခေါ်ခဲ့ပင်း အဲနေရာတွင်နေလေအယ်။ အဲလိုမို့ နတ်ပူးဝင်သူရဲ့ နောက်ဖြစ်ပုံဟ ပထမဖြစ်ပုံထက် ဆိုးလေတော့အယ်။ ဟေဆိုးညစ်သော လူလို့ဟလည်း အဲနည်းအတိုင်းပင် ခံစားရကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ယေရှုဟ လူလို့အား ဟောပြောနေစဉ် မယ်တော်နဲ့ ညီတော်များ ရောက်လာအယ်။ သူလို့ဟ ယေရှုနဲ့ စကားပြောလိုယွေ့၊ အပြင်တွင် ရပ်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","အဲလိုမို့ အဲမှာဆိလဲ့ လူတယောက်ဟ ကိုယ်တော်အား “ကျေ့ပါ၊ ကိုယ်တော်ရဲ့ မယ်တော်နဲ့ ညီတော်လို့ဟ ကိုယ်တော်နဲ့ စကားပြောလိုယွေ့ အပြင်တွင် ရပ်နေကြအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ယေရှုဟ “ငါ့မေနဲ့ ငါ့ညီများဟ စသူလုန်း” ဟု ပြန်ယွေ့ မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","အဲပင်းရင် ယေရှုဟ တဘဲ့တော်လို့ဟို ထိုးပြလျက် “ကျေ့ပါ၊ ငါ့မေနဲ့ ငါ့ညီများဟ ဟေသူလို့ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ခေါန်းခင်ဘုံဆှင် ငါ့ခမည်းတော်ရဲ့ အလိုတော်အတိုင်း ဆောင်ရွက်သူမန်သမျှဟ ငါ့ညီ၊ ငါ့နှမနဲ့ ငါမေ့လို့ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","အဲနေ့နှိုက်ပင်လျှင် ယေရှုဟ အဲနေအိုင်မှ ထွက်ယွေ့ အိန်နားတွင် ထိန်ပင်း သွန်သင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ရမ်းဆာ့သော လူထုပရိတ်သတ်လို့ဟ အထံတော်ဟို စုဝေးလာကြသဖြင့် ကိုယ်တော်ဟ လှေပေါ်ဟို တက်ယွေ့ထိန်ပင်း လူအပေါင်းလို့ဟ ကုန်းပေါ်တွင် ရပ်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ကိုယ်တော်ဟ အဲသူလို့အား ပုံဥပမာဟို အသုံးပြုယွေ့ ရမ်းဆာ့သော အကျောန်းအရာများဟို ဟောအယ်။ “အရင်ခါဟ မျိုးစေ့ကြဲသော လူတယောက်ဟ မျိုးစေ့ကြဲမို့ ထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","မျိုးစေ့ကြဲသောအခါ အချို့မျိုးစေ့လို့ဟ လမ်းတွင်ကျသဖြင့် ငက်လို့ဟ လာယွေ့ စားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","အချို့မျိုးစေ့လို့ဟ မြေနည်းလဲ ကျောက်ဆောင်ပေါ်တွင် ကျအယ်။ မြေသားတိမ်သဖြင့် အပင်များ အမြန်ပေါက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","အဲလိုလဲ နေထွက်သောအခါ အပင်နေပူလောင်ပင်း အမြစ်မစွဲသောကျောန့် ခြောက်ပင်းသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","အချို့မျိုးစေ့လို့ဟ ဆူးတောတွင် ကျသဖြင့် ဆူးပင်များ ကြီးထွားလာပင်းနောက် အပင်ငယ်လို့ဟို အုပ်သွားကာ သေစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","အချို့မျိုးစေ့လို့ဟ မြေကောင်းမြေသန့်တွင် ကျသဖြင့် အချို့လို့ဟ အဆသုံးဆယ်၊ အဆခြောက်ဆယ်၊ အဆတရာပွားများယွေ့ အသီးသီးကြအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“ကြားရန် နားဆိသောသူ စသူမဆို ကြားပါစေ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","တဘဲ့တော်လို့ဟ အထံတော်ဟို ချဉ်းကပ်ယွေ့ “ယေရှုဟ မစာကျောန့် လူလို့အား ပုံဥပမာဖြင့်သာလျှင် မိန့်လုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ယေရှုဟ “နင်လို့သည် ခေါန်းခင်နိုင်ငံတော်နဲ့ဆိုင်သော နက်နဲလဲ့ အကျောန်းအရာများဟို သိရသောခွင့် ပေးထားကြပေမဲ့ သူလို့ဟ အဲအခွင့်ဟို မရကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","အကျောန်းမှာ ဆိသောသူအား ထပ်ယွေ့ပေးသဖြင့် သူဟ ကြွယ်ဝပြေ့စုံလိမ့်မယ်။ မဆိသောသူဆေမှ သူနှိုက်ဆိသော အရာဟိုပင် သိမ်းယူလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","သူလို့အား ပုံဥပမာဆောင်ယွေ့ ငါပြောရလဲ့အကျောန်းမှာ သူလို့ဟ ကျေ့သော်လည်း မမျော်၊ နားထောင်သော်လည်း မကြား အဲဟာမဟုတ်ရင် နားမလည်သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","အဲကျောန့် ဟေရှာယ ဟောဖူးသော အနာဂတ်စကားဟ ပြေ့စုံခြင်းဟို ရောက်လေအယ်။ ဟောပြောချက်မှာ၊ “ ‘ဟေသူလို့ဟ ကြားလျက်နဲ့ နားလည်လိမ့်မယ် မဟုတ်၊ ကျေ့လျက်နဲ့ မျော်လိမ့်မယ် မဟုတ်၊ ");
INSERT INTO dnv_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ပစာကို့ ဟေလူစုရဲ့ စိတ်နေလုံးဟ ထိုင်းမှိုင်းလျက်၊ သူလို့ရဲ့ နားများဟ လေးလျက် မျက်စေ့များဟ ပိတ်လျက် ဆိအယ်။ အကယ်ယွေ့သာ သူလို့ရဲ့ မျက်စေ့များဟ မျော်နိန်ယွေ့ နားများဟ ကြားနိန်လျက် စိတ်နေလုံးဟလည်း သိနားလည်နိန်မယ်ဆိုမန့်မူ၊ သူလို့ဟ ငါ့ဟို ခိုလှုံကိုးစားလာကြမယ် ဖြစ်ယွေ့၊ ငါဟလည်း သူလို့ဟို ကျန်းမာစေမယ်’ ဟု ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“အဲလိုလဲ နင်လို့ရဲ့ မျက်စေ့များဟ မျော်ယွေ့ နားများဟလည်း ကြားသောကျောန့် နင်လို့ဟ မင်္ဂလာဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","နင်လို့အား အမန်အကန် ငါပြောတာဟ၊ နင်လို့ မျော်ရတဲ့အရာများဟို ပရောဖက်နဲ့ သူတော်ကောင်းအများပင် မျော်လိုကြသော်လည်း မမျော်ရကြ။ နင်လို့ ကြားရလဲ့အရာများဟို သူလို့ကြားလိုသော်လည်း မကြားရကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“အဲကျောန့် မျိုးစေ့ကြဲသူရဲ့ ပုံဥပမာ အနက်အဓိပ္ပာယ်ဟို နင်လို့ဟ နားထောင်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","လမ်းတွင် ကျလဲ့ မျိုးစေ့ဟ နိုင်ငံတော်အကျောန်း တရားတော်ဟို ကြားသော်လည်း နားမလည်သူလို့နဲ့တူအယ်။ သူလို့ရဲ့ စိတ်နေလုံးတွင် ကြဲထားလဲ့ တရားတော်မျိုးစေ့ဟို မာရ်နတ်ဟ လာယွေ့ နှုတ်ယူသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ကျောက်ပေါသော မြေတွင်ကျလဲ့ အစေ့ဟ သတင်းစကားဟို ကြားပင်း ဝမ်းသာစွာ ခုတုံး ခံယူသူလို့ဟို ဆိုလိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","အဲလိုလဲ သူလို့ရဲ့ စိတ်နေလုံးတွင် အမြစ်မစွဲ၊ ကာလကတစ်သာ တည်နေအယ်။ အဲလိုမို့ သူလို့ဟ သတင်းစကားကျောန့် ဒုက္ခ အဲဟာမဟုတ်ရင် နှိပ်စက်ညှဉ်းပန်းမှု ကြုံသောအခါ ခုတုံးပင် ဖောက်ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ဆူးပင်တွင် ကြဲခြင်းခံရတာဟ တရားစကားဟို ကြားသော်လည်း ဟေဖဝါ့ စိုးရိမ်ကျောန့်ကြမှုများနဲ့ စည်းစိမ်ချမ်းသာ ခံစားလိုမှုများဟ တရားတော်မျိုးစေ့ဟို လွှမ်းမိုးသဖြင့် စလိုမျှ အသီးမသီးနိန်သောသူလို့ဟို ဆိုလိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","မြေကောင်းမြေသန့်တွင် ကျလဲ့မျိုးစေ့ဟ တရားတော်ဟို ကြားယွေ့ နားလည်သူလို့ဟို ဆိုလိုအယ်။ အချို့လို့ဟ အဆတရာ၊ အဆခြောက်ဆယ်၊ အဆသုံးဆယ်ပွားများယွေ့ အသီးသီးတတ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ယေရှုဟ အခြားပုံဥပမာဟို ဆောင်ပင်း သူလို့အား မိန့်တာဟ “ခေါန်းခင်နိုင်ငံတော်သည် လူတယောက်ဟ မိမိဂျုံအစေ့ မျိုးကောင်းမျိုးသန့်ဟို ကြဲသောသူနဲ့တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ညမှာ လူလို့ အိပ်မွေ့နေသောအခါ၊ ရန်သူဟ လာယွေ့ ဂျုံစေ့များကြားတွင် မြက်သီးစေ့များဟို ကြဲပင်းနောက် ထွက်ခွာသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","အပင်ပေါက်ယွေ့ အနှံထွက်လာသောအခါ၊ မြက်သီးပင်များလည်း ထွက်လာလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","အဲအခါ ကျွန်လို့ဟ လယ်ဆှင်ဆေ လာယွေ့ ‘ဆရာ၊ ဆရာဂျုံခင်းတွင် မျိုးကောင်းမျိုးသန့် အစေ့များကြဲခဲ့အယ် မဟုတ်လော၊ မြက်သီးပင်များဟ စနားဟနေပင်း ရောက်ဆိလာလုန်း’ ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","လယ်ဆှင်ဟ ‘ဟေအရာဟ ရန်သူရဲ့ လက်ချက်ပင် ဖြစ်အယ်’ ဟု ဖြေအယ်။ အစေခံလို့ဟ ‘အဲသို့ဖြစ်မန့်မူ မြက်သီးများဟို သွားယွေ့ နုတ်လောရမယ်လော’ ဟု မေးပြန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","လယ်ဆှင်ဟ ‘နုတ်မပစ်ကြနဲ့၊ မြက်သီးများဟို နုတ်လိုက်ရင် ဂျုံပင်ဟို ရောယွေ့ အမြစ်ပါမကျန် ဆွဲနုတ်မိလိမ့်မယ်ဟို စိုးရိမ်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ကောက်ရိတ်ချိန်တိုင်အောန် အပင်နေမျိုးလုံး ဆက်လက် ကြီးစေကြလော့။ အချိန်ရောက်မှ ကောက်ရိတ်သမားလို့အား ဦးရင် မြက်သီးများဟို နုတ်ယွေ့ စည်းထားပင်းလျှင် မီးရှို့ပစ်ကြ။ အဲပင်းရင် ဂျုံမျိုးစေ့ဟို စုသိမ်းယွေ့ ငါရဲ့ ကျီနှိုက် သွင်းထားကြဟု ငါမှာကြားမယ်’ ဟုဆိုအယ်” ဟူယွေ့ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ယေရှုဟ အခြားပုံဥပမာဟို ပေးယွေ့ သူလို့အား မိန့်တာဟ “ခေါန်းခင်နိုင်ငံတော်သည် လူတယောက်ဟ မုန်ညင်းအစေ့ဟို ယူယွေ့ မိမိစိုက်ခင်းထဲတွင် ကြဲသောသူနဲ့တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","အဲအစေ့ဟ အစေ့တကာလို့ထက် သေးငယ်ပေမဲ့ ကြီးထွားလာသောအခါ ဟင်းသီးဟင်းရွက်ပင်လို့ထက် ကြီးလာသောကျောန့် ငက်များဟ လာယွေ့ အဲအပင်ရဲ့ အကိုင်းများတွင် အသိုက်ပြုလုပ်နိန်ကြအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ယေရှုဟ အခြားပုံဥပမာဟို ဆောင်ယွေ့ သူလို့ဟို မိန့်စဉ် “ခေါန်းခင်နိုင်ငံတော်သည် အမျိုးသမီးတယောက်ဟ တဆေးတချို့ဟို ယူပင်းလျှင် ဂျုံမှုန့်သုံးတင်းထဲတွင် ထည့်သဖြင့် မုန့်ညက်အားလုံးဟို ဖောင်းပွစေတတ်သော အဖြစ်အပျက်နဲ့ တူအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ယေရှုဟ လူအုပ်လို့အား ဟေအကျောန်းအရာများဟို ပုံဥပမာဆောင်ယွေ့ ဟောကြားအယ်။ ပုံဥပမာမဆောင်ဘဲ သူလို့အား မစာအကျောန်းအရာဟိုမျှ ဟောကြားတော်မမူ။ ");
INSERT INTO dnv_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","အဲလိုမို့ “ငါဟ ပုံဥပမာဆောင်ယွေ့ ငါ့ရဲ့ စလောင်ဟို ဖွင့်လျက်၊ လောကဟို ဖန်ဆင်းကတုန်းဟ ဖုံးနေခဲ့လဲ့အရာများဟို ငါထုတ်ဖော်မယ်” ဟူသော ပရောဖက်အားဖြင့် မိန့်သောအရာ ပြေ့စုံခြင်းဟို ရောက်မယ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","အဲပင်းရင် ယေရှုဟ လူအုပ်ကြီးဆေမှ ထွက်ခွာယွေ့ နေအိုင်ထဲဟို ဝင်အယ်။ တဘဲ့တော်လို့ဟ အထံတော်ဟို လာယွေ့ “လယ်ထဲမှ မြက်သီးပင်များရဲ့ ပုံဥပမာဟို ငါလို့အား ဆှင်းပြမန့်” ဟု ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ယေရှုဟ “ကောင်းသောမျိုးစေ့ဟို ကြဲသူဟ လူသားပင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","လယ်ဟ ဟေလောကဖြစ်ပင်း ကောင်းသောမျိုးစေ့ဟ နိုင်ငံတော်ရဲ့သားများ ဖြစ်ကြအယ်။ မြက်သီးပင်များဟ မာရ်နတ်ရဲ့သားများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","အဲမျိုးစေ့များဟို ကြဲသောရန်သူဟ မာရ်နတ် ဖြစ်အယ်။ ကောက်ရိတ်ချိန်ဟ ကပ်ကမ္ဘာကုန်ဆုံးချိန်ဖြစ်ပင်း ကောက်ရိတ်သမားများဟ ခေါန်းခင်တမန်များ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","မြက်သီးပင်များဟို စုသိမ်းပင်း မီးရှို့ပစ်လိုက်သလိုမျိုး ကပ်ကမ္ဘာကုန်ဆုံးချိန်နှိုက်လည်း အဲတိုင်းတိုင်း ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","လူသားဟ မိမိရဲ့ခေါန်းခင်တမန်များဟို စေလွှတ်သဖြင့် သူလို့ဟ မှောက်မားလမ်းလွဲစေသော အရာများနဲ့ မတရားအမှုဟို ပြုသောသူဆိသမျှလို့ဟို နိုင်ငံတော်ထဲဟ နုတ်စေပင်းရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","သူလို့ဟ တောက်လောင်သော မီးဖိုထဲဟို သူလို့အား လောချစေမယ်။ အဲနေရာနှိုက် ငိုကြွေးမြည်တမ်းယွေ့ အံသွားခဲကြိတ်ကြ လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","အဲအခါ ဖြောင့်မတ်သောလို့ဟ သူလို့အဖရဲ့ နိုင်ငံတော်တွင် နေလိုမျိုး ထွန်းလင်းတောက်ပလျက် နေကြလိမ့်မယ်။ ကြားရန် နားဆိသောသူ စသူမဆို ကြားပါစေ။ ");
INSERT INTO dnv_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ခေါန်းခင်နိုင်ငံတော်သည် လူတယောက်ဟ လယ်နှိုက် အောင်းထားသော ဘဏ္ဍာဟို တွေ့သဖြင့် တခါ မြှပ်ထားခဲ့ပင်း ဝမ်းမြောက်စွာသွားပင်းရင် ဆိသမျှဟို ရောင်းချလျက် အဲလယ်ဟို ဝယ်သောသူနဲ့ တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“အဲပင်းရင် ခေါန်းခင်နိုင်ငံတော်ဟ ပုလဲကောင်းဟို ဆာလျက်နေသော ကုန်သည်နဲ့ တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","သူဟ ရမ်းဆာ့ အဖိုးတန်လဲ့ ပုလဲဟို တွေ့သောအခါ ဆိသမျှဟို ရောင်းချယွေ့ အဲပုလဲဟို ဝယ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“အဲပင်းရင် ခေါန်းခင်နိုင်ငံတော်သည် တံငါသည်အချို့လို့ဟ အိန်တွင် သူလို့ရဲ့ ပိုက်ကွန်ဟို ချယွေ့ ငါးအမျိုးမျိုးဟို အုပ်မိသောအရာနဲ့ တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ပိုက်ကွန်အပြေ့ရသောအခါ တံငါသည်လို့ဟ ပိုက်ကွန်ဟို ကုန်းပေါ်သို့ ဆွဲတင်ယွေ့ ငါးများဟို ရွေးကြအယ်။ ငါးကောင်းများဟို ခြင်းများတွင် ထည့်ထားပင်းနောက် ငါးညံ့များဟိုမူ အပြင်ဟို လောထုတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ကပ်ကမ္ဘာကုန်ဆုံးချိန်နှိုက်လည်း အဲနည်းတူဖြစ်လိမ့်မယ်။ ခေါန်းခင်တမန်များဟ လာယွေ့ သူယုတ်မာများဟို သူတော်ကောင်းများထဲမှ ခွဲထုတ်ပင်းရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","တောက်လောင်သော မီးဖိုထဲဟို လောချလိမ့်မယ်။ အဲနေရာနှိုက် ငိုကြွေးမြည်တမ်းယွေ့ အံသွားခဲကြိတ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“ဟေအကျောန်းအရာ အားလုံးဟို နင်လို့ နားလည်ကြသလော” ဟု ယေရှုဟ သူလို့အား မေးအယ်။ တဘဲ့တော်လို့ဟ “နားလည်အယ်” ဟု ဖြေကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","အဲလိုမို့ ကိုယ်တော်ဟ “ခေါန်းခင်နိုင်ငံတော်တွင် တဘဲ့ဖြစ်လာသူ ကျမ်းတတ်ဆရာဟ မိမိရဲ့ဘဏ္ဍာတိုက်ထဲမှ ဥစ္စာပစ္စည်းအသစ်နဲ့ အဟောင်းများဟို ထုတ်ယူသော အိုင်ဆှင်နဲ့တူအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ယေရှုဟ အဲပုံဥပမာများဟို မိန့်ကြားပင်းသောအခါ အဲအရပ်မှ ထွက်သွားပင်း ");
INSERT INTO dnv_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","မိမိနေရင်းမြို့ဟို ပြန်သွားအယ်။ ကိုယ်တော်ဟ တရားဇရပ်တွင် သွန်သင်ရာတွင် ကြားနာသော လူလို့ဟ ရမ်းဆာ့အံ့ဩကြအယ်။ သူလို့ဟ “ဟေသူသည် အသိပညာများနဲ့ အံ့ဖွယ် နိမိတ်လက္ခဏာများဟို ဖယ်နားဟ ရလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","သူဟ လက်သမားဆရာရဲ့ သားမဟုတ်လော၊ သူ့မေ့ဟ မာရိ မဟုတ်လော၊ သူ့ညီများဟ ယာကုပ်၊ ယောသပ်၊ ရှိမုန်နဲ့ ယုဒလို့ မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","သူ့နှမ အားလုံးဟလည်း ဟေမှာနေတာ မဟုတ်လော၊ ဟေသူဟ အရာအားလုံးကို ဖယ်နားဟ ရလုန်း” ဟု ဆိုကာ ");
INSERT INTO dnv_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ယေရှုရဲ့ အပေါ်နှိုက် အကြည်ညိုပျက်ကြအယ်။ ယေရှုဟလည်း “ပရောဖက်ဟ မိမိမြို့နဲ့ မိမိနေအိုင်မှလွဲယွေ့ မစာအရပ်တွင်မဆို ဂုဏ်အသရေဆိအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","အဲမြို့သားလို့ဟ မိမိအား ယုံကြည်ကိုးစားမှု မဆိကြသဖြင့် ယေရှုဟ အံ့ဩဖွယ်သော အမှုလို့ဟို အဲမြို့တွင် ပြုတော်မမူ။ ");
INSERT INTO dnv_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","အေးကာလနှိုက် ဂါလိလဲပြေဟို အုပ်စိုးသူဟေရုဒ်ဟ ယေရှုရဲ့ သတင်းဟို ကြားရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“ဟေသူဟ နှစ်ခြင်းဆရာယောဟန် ဖြစ်အယ်။ သူဟ သေရာမှ အသက်ပြန်ဆှင်လေပီ။ အဲကျောန့် တန်ခိုး နိမိတ်လက္ခဏာများဟို လုပ်နိန်အယ်” ဟု မိမိအမှုထမ်းလို့အား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","အကျောန်းမှာ ဟေရုဒ်ဟ ညီဖြစ်သူ ဖိလိပ္ပုရဲ့ ပေါင်အိုမ ဟေရောဒိနဲ့ ပတ်သက်ယွေ့ အစောထဲဟ ယောဟန်ဟို ဖမ်းဆီးတုတ်ချေပင်း ထောင်ထဲမှာ လှောင်ထားခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","အကျောန်းမှာ ယောဟန်ဟ “နင်သည် အဲမိန်းမဟို လက်ထပ်ယူတာ ပညတ်နဲ့ညီသလော” ဟု ဟေရုဒ်အား ပြောခဲ့သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ဟေရုဒ်ဟ ယောဟန်ဟို သတ်ချင်သော်လည်း ယုဒအမျိုးသားလို့ဟို ကြောက်လေအယ်။ ပစာကို့ သူလို့ဟ ယောဟန်ဟို ပရောဖက်တပါးဟု ထင်နေစာရီးကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ဟေရုဒ်ရဲ့ မွေးနေ့နှိုက် ဟေရောဒိရဲ့ သမီးဟ ဧည့်သည်တော်များ ဆေ့တွင် အကနဲ့ ဖျော်ဖြေလျက် ဟေရုဒ်ရဲ့ စိတ်ဟို ရမ်းဆာ့ ရွှင်လန်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","အေးကျောန့် ဟေရုဒ်ဟ “နင်တောင်းသမျှ အရာအားလုံး ငါပေးမယ်” ဟု ကျိန်ဆိုယွေ့ သူ့အား ကတိပြုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","မိနီငယ်ဟလည်း သူ့မေ့ရဲ့ အကြံပေးချက်အရ “နှစ်ခြင်းဆရာယောဟန်ရဲ့ ဦးခေါန်းဟို လင်ပန်းပေါ်တွင် တင်ပင်း ငါ့အား ဟေနေရာတွင်ပင် ပေးပါ” ဟု တောင်းဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ဘုရင်ဟ စိတ်မချမ်းမသာဖြစ်သော်လည်း ဧည့်သည်တော်များဆေ့တွင် မိမိပေးခဲ့လဲ့ ကတိဟို ထောက်ယွေ့ မိနီငယ် တောင်းဆှောက်လဲ့အတိုင်း ပေးစေရန် အမိန့်ချအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","အဲလိုမို့ ယောဟန်ရဲ့ ဦးခေါန်းဟို ထောင်ထဲတွင် ဖြတ်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ဦးခေါင်းဟို လင်ပန်းပေါ်တင်ယွေ့ ယူလာကာ မိနီငယ်အား ပေးပင်းမှ မိနီငယ်ဟလည်း အဲဦးခေါန်းဟို သူ့မေ့ဆေဟို ယူသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ယောဟန်ရဲ့ တဘဲ့လို့ဟ လာယွေ့ အလောင်းဟို ယူပင်းရင် သင်္ဂြိုဟ်ကြအယ်။ အဲပင်းရင် ယေရှုဆေဟို သွားယွေ့ သတင်းပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ယေရှုဟ ယောဟန်ရဲ့ သတင်းဟို ကြားသောအခါ အဲအရပ်မှ တကိုယ်တည်း ဆိတ်ကွယ်ရာ အရပ်ဟို လှေဖြင့် သွားအယ်။ အေးအကျောန်းဟို လူလို့ကြားရင်၊ သူလို့ရဲ့ မြို့ရွာများကို ထားခဲ့ပင်း ကိုယ်တော်ရဲ့ နောက်တော်ဟို ကုန်းကျောန်းနဲ့ လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ယေရှုဟ လှေပေါ်မှ ဆင်းပင်း လူအုပ်ဟို မျော်သောအခါ သူလို့ဟို သနားစိတ်ဆိသဖြင့် ဖျားနာသူများဟို ကျန်းမာစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","အဲညနေခင်းအချိန်နှိုက် တဘဲ့တော်လို့ဟ အထံတော်ဟို လာယွေ့ “ဟေအရပ်ဟ လူသူမဆိလဲ့ အရပ်ဖြစ်အယ်။ အချိန်လည်း ရမ်းဆာ့နောက်ကျပီ။ လူလို့အား ကျေးရွာများဟို သွားယွေ့ မိမိလို့အတွက် အစားအစာ ဝယ်ယူနိန်စေရန် စေလွှတ်ပါ” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ယေရှုဟ “သူလို့သွားရန် မလို။ နင်လို့တတ်တိုင်း သူလို့အား စားစရာ ပေးကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","တဘဲ့တော်လို့ဟ “ငါလို့မှာ မုန့်ငါးလုံးနဲ့ ငါးနေကောင် ဆိအယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ယေရှုဟ “အေးမုန့်နဲ့ ငါးဟို ငါ့ဆေဟို ယူခဲ့ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ကိုယ်တော်ဟ လူအုပ်လို့ဟို မြက်ခင်းပေါ်တွင် ထိန်စေရန် အမိန့်ပေးနောက် မုန့်ငါးလုံးနဲ့ ငါးနေကောင်ဟို ယူယွေ့ ခေါန်းခင်ဟို မော်ကျေ့လျက် ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟို ချီးမွန်းပင်း မုန့်များဟို ဖဲ့ယွေ့ တဘဲ့တော်လို့အား ပေးအယ်။ တဘဲ့တော်လို့ဟလည်း လူလို့အား ဝေပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","လူအပေါင်းလို့ဟ အဝစားကြအယ်။ အဲပင်းရင် တဘဲ့တော်လို့ဟ အကြွင်းအကျန်များဟိုပင် ကောက်သိမ်းကြရာ တဆယ့်နေတောင်း အပြေ့ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","အမျိုးသမီးနဲ့ လူပဲ့များမှလွဲရင် မုန့်စားသူ ယောက်ျား ဦးရေမှာ ၅,၀၀၀ လောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","အဲပင်းရင် ယေရှုဟ လူအပေါင်းလို့အား ပြန်လွှတ်နေစဉ် တချိန်တည်းမှာပင် တဘဲ့တော်လို့အား လှေပေါ်ဟို တက်စေယွေ့ အိန်တဖက်အရင် ကူးစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","လူအပေါင်းလို့အား ပြန်စေပင်းနောက် ယေရှုဟ ဆုတောင်းရန် တောင်ပေါ်ဟို တကိုယ်တည်း တက်အယ်။ ညခင်းချိန်ရောက်သောအခါ အဲအရပ်တွင် ကိုယ်တော် တယောက်တည်း ဆိနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","အားပင်း အဲအချိန်တွင် လှေဟ ကမ်းနဲ့ ရမ်းဆာ့ ဝေးကွာ သွားပင်း လေဆန်ဖြစ်သောကျောန့် အဲလှေဟို လှိုင်းတံပိုးများ ရိုက်ခတ်လျက်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","အရုဏ်ဦးအချိန်နှိုက် ယေရှုဟ ယေပေါ်မှာ စက်တော်ဖြန့်ယွေ့ တဘဲ့တော်လို့ ဆေဟို ကြွလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ယေပေါ်မှာ ကိုယ်တော် လမ်းဆှောက်နေတာဟို သူလို့ မျော်သောအခါ တဘဲ့တော်လို့ဟ တုန်လှုပ်ချောက်ချားကြယွေ့ “ကဆေ” ဟု အလန့်တကြား ဟစ်အော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ယေရှုဟ သူလို့အား “အားမငယ်ကြနဲ့၊ ငါပင် ဖြစ်အယ်၊ မကြောက်ကြနဲ့” ဟု ခုတင်ချင်း မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","အဲပင်းရင် ပေတရုဟ “သခင်၊ ကိုယ်တော်ဖြစ်တာ မန်ရင် ငါဟ ယေပေါ်မှာ ဆှောက်ပင်း အထံတော်ဟို လာနိန်ရန် အမိန့်ဆိမန့်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ယေရှုဟ “လာခဲ့လော့” ဟု မိန့်အယ်။ အဲလိုမို့ ပေတရုဟ လှေပေါ်ဟ ဆင်းယွေ့ ယေပေါ်တွင် စတင်ဆှောက်ကာ ယေရှု ဆေဟို သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","အဲလိုလဲ သူဟ လေဟုန်ပြင်းတာဟို မျော်သောအခါ ကြောက်လန့်လာသဖြင့် ယေနစ်စပြုတာနဲ့ “သခင်၊ ငါ့အား ကယ်ပါ” ဟု အော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ခုတင်ချင်း ယေရှုဟ လက်တော်ဟို ဆန့်ယွေ့ ပေတရုဟို ဆွဲကိုင်ပင်းလျှင် “ယုံကြည်ခြင်းအားနည်းသောသူ၊ မစာကျောန့် သံသယဖြစ်လုန်း” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","သူလို့နေယောက်လုံး လှေပေါ်ဟို တက်ကြရာ လေဟ ငြိမ်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","အဲပင်းရင် လှေထဲဆိ တဘဲ့တော်လို့ဟ ယေရှုအား ဦးချရှိခိုးလျက် “အမန်တကယ် ကိုယ်တော်ဟ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်အယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","သူလို့ဟ အိန်ဟို ဖြတ်ပင်း ဂင်နေသရက်မြို့ဟို ကုန်းကျောန်းလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","အဲမှာဆိသော လူများဟ ယေရှုဟို မှတ်မိကြအယ်။ အဲလိုမို့ သူလို့ဟ ပတ်ဝန်းကျင်အရပ်ရပ်သို့ လူများစေလွှတ်ပင်း ဖျားနာသူလို့ဟို ယေရှုဆေဟို ခေါ်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ဖျားနာသူလို့ဟ ကိုယ်တော်ရဲ့ အဝတ်တော်အမြိတ်ဟို တို့ထိခွင့်ပြုရန် ကိုယ်တော်ဟို တောင်းပန်ကြအယ်။ ဟေသို့ တို့ထိရသူ အပေါင်းလို့ဟလည်း ကျန်းမာသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","အဲပင်းရင် ယေရုရှလင်မြို့မှ ဖာရိရှဲတချို့နဲ့ ကျမ်းတတ်ဆရာများဟ ယေရှုဆေဟို မေးဖို့ ရောက်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ကိုယ်တော်ရဲ့ တဘဲ့များဟ မစာကျောန့် ဆေ့လူကြီးလို့ရဲ့ သင်ကြားမှုများဟို မလိုက်နာကြလုန်း။ သူလို့ဟ နည်းမန်အတိုင်း လက်မဆေးဘဲ စားသောက်ကြအယ်” ဟု ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ယေရှုဟ “နင်လို့သည် မစာကျောန့် ဘုရားသခင်ရဲ့ ပညတ်တော်လို့ဟို နာမခံဘဲ မိမိလို့ရဲ့ သွန်သင်ချက်များဟို လိုက်နာကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","အကျောန်းမှာ ဘုရားသခင်ဟ ‘နင့်ရဲ့ မိဘဟို ရိုသေစွာပြုလော့။ မိဘဟို ကျိန်ဆဲသောသူဟ သေဒဏ်ခံစေ။’ ");
INSERT INTO dnv_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","အဲလိုလဲ နင်လို့ သင်ကြတာဟ လူတယောက်နှိုက် အဖ အဲဟာမဟုတ်ရင် အမေ့အား ကူညီရန် ပစ္စည်းတစုံတခု ဆိသော်လည်း အေးပစ္စည်းဟို ‘ဘုရားသခင်ပိုင်လဲ့ ပစ္စည်းဖြစ်အယ်’ ဟု ဆိုရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","သူဟ မိမိရဲ့အဖအား ဂုဏ်ပြုရန် မလို။ အေးနည်းလမ်းဖြင့် နင်လို့ဟ မိမိလို့ရဲ့ ထုံးတမ်းစဉ်လာများဟို လိုက်နာရန် ဘုရားသခင်ရဲ့ ပညတ်ဟို ပစ်ပယ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","သူတော်ကောင်းဟန်ဆောင်တတ်သောသူလို့၊ ဟေရှာယဟ နင်လို့ဟို ရည်မှတ်ယွေ့ ဟေသို့ ဟောတာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘ဟေလူမျိုးဟ ငါ့ဟို စလောင်အားဖြင့် ဂုဏ်ပြုကြအယ်၊ အဲလိုလဲ သူလို့ရဲ့ စိတ်နေလုံးမှာ ငါနဲ့ ဝေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ငါ့ဟို ကိုးကွယ်သောသူလို့နှိုက် အကျိုးမဆိ၊ ပစာကို့ သူလို့ဟ ငါရဲ့ပညတ်တွေလိုဘဲ လူ့စည်းမျဉ်းတွေဟို သင်ပေးအယ်’ ဟု မိန့်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","အေးနောက် ယေရှုဟ လူအုပ်လို့အား အထံတော်ဟို ခေါ်ပင်း သူလို့အား “နားထောင်ပင်း နားလည်ကြလော့၊ ");
INSERT INTO dnv_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","လူဟို စုတ်ပဲ့စေလဲ့အရာဟ စလောင်ထဲဟို ဝင်သည့်အရာ မဟုတ်၊ စလောင်ထဲမှ ထွက်လဲ့အရာ သာလျှင် လူဟို စုတ်ပဲ့စေအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","အဲပင်းရင် တဘဲ့တော်လို့ဟ အထံတော်ဟို လာယွေ့ “ကိုယ်တော်မိန့်သော စကားကျောန့် ဖာရိရှဲလို့ ခံစားကြတာဟို သိသလော” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ယေရှုဟ “ခေါန်းခင်ဘုံဆှင် ငါရဲ့ အဖ စိုက်ပျိုးတော်မမူလဲ့ အပင်ဆိသမျှဟ အမြစ်ပါမကျန် နုတ်လောခြင်းဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","သူလို့အတွက် စိတ်မပူကြနဲ့၊ သူလို့ဟ မျက်မမြင်များဟို လမ်းပြလဲ့ မျက်မမြင်များ ဖြစ်ကြအယ်။ မျက်မမြင်တယောက်ဟ တခြားမျက်မမြင်တယောက်အား လမ်းပြသောအခါ သူလို့ နေယောက်စလုံးပင် တွင်းထဲဟို ကျလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ပေတရုဟ “အဲပုံဥပမာဟို ငါလို့အား ဆှင်းပြမန့်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ယေရှုဟ “နင်လို့ဟလည်း သူများလို့ထက် ခုတိုင်အောန် အသိဉာဏ်ကင်းမဲ့လျက် ဆိနေကြသေးသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","စလောင်ထဲဟို ဝင်သောအရာဟူသမျှဟ အစာအိမ်ဟို ရောက်ပင်းနောက် အိုင်သာတွင် စွန့်ပစ်တာဟို နင်လို့ နားမလည်သလော။ ");
INSERT INTO dnv_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","အဲလိုလဲ စလောင်ထဲဟ ထွက်လဲ့အရာဟတော့ စိတ်နေလုံးထဲမှ ထွက်လာသောအရာဖြစ်ပင်း အဲအရာများဟ လူဟို စုတ်ပဲ့စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","အကျောန်းမှာ မကောင်းသော တွေးတောကြံစည်မှုများ၊ လူ့အသက်ဟို သတ်ခြင်း၊ အိုင်ထောင်ရေး ဖောက်ပြန်ခြင်း၊ ကာမဂုဏ်လိုက်စားခြင်း၊ သူ့ဥစ္စာဟို ခိုးခြင်း၊ လိမ်လည်ခြင်း၊ သူ့အသရေဟို ဖျက်ခြင်း အစဆိသည့် စုတ်ပဲ့လဲ့ အကြံအစည်များဟ စိတ်နေလုံးထဲမှ ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ဟေအရာများဟ လူဟို စုတ်ပဲ့စေကြအယ်။ အဲလိုလဲ လက်မဆေးဘဲ အစားအစာ စားခြင်းဟ လူဟို စုတ်ပဲ့စေတာ မဟုတ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ယေရှုဟ အဲအရပ်မှ ထွက်ခွာယွေ့ တုရုနဲ့ ဇိဒုန်မြို့လို့ရဲ့ နယ်များဟို ကြွအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","အဲဒေသတွင် နေထိန်သူ ခါနာန် အမျိုးသမီးတယောက်ဟ ကိုယ်တော်ဆေဟို လာယွေ့ “ဆရာ၊ ဒါဝိဒ်ရဲ့သားတော်၊ ကျွန်မဟို သနားမန့်။ ကျွန်မရဲ့ သမီးဟ နတ်ဆိုးစွဲသဖြင့် ရမ်းဆာ့ ဝေဒနာခံလျက် နေအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","အဲလိုလဲ ယေရှုဟ သူဟို တခွန်းမှ ဖြေကြားတော်မမူ။ တဘဲ့တော်လို့ဟ ယေရှု ဆေဟို လာယွေ့ တောင်းပန်ပင်း “ဟေမိန်းမဟ ငါလို့ရဲ့ နောက်လိုက်ပင်း အော်နေအယ်၊ သူ့အား မောင်းထုတ်မန့်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","အဲပင်းရင် ယေရှုဟ “ငါသည် ဣသရေလအမျိုးသားများ ပျောက်နေသော သိုးများဆေသို့သာ စေလွှတ်ခြင်း ခံရအယ်” ဟု ဖြေကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","အဲအခါ အေးမိန်းမဟ ခြေတော်ရင်းနှိုက် လာရောက် ပျပ်ဝပ်လျက် “ဆရာ၊ ကျွန်မဟို ကူညီမန့်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ယေရှုဟ “လူပဲ့သငယ်လို့ရဲ့ ကောင်းသော အစာဟို ယူယွေ့ ခွေးလို့အား မကျွေးအပ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","အဲမိန်းမဟ “မန်ပါအယ် ဆရာ၊ အဲလိုလဲ ခွေးများပင်လျှင် မိမိလို့ သခင်ရဲ့ စားပွဲမှကျသည့် စားကြွင်းစားကျန်များဟို စားရကြအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","အဲလို့မို့ ယေရှုဟ၊ “အချင်း မိန်းမ၊ နင်ရဲ့ယုံကြည်ခြင်းသည် အားကြီးအယ်။ နင်အလိုဆိသည့်အတိုင်း ဖြစ်စေ” ဟု မိန့်အယ်။ အဲအချိန်မှ စယွေ့ အဲမိန်းမရဲ့ သမီးဟ ရောဂါပျောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ယေရှုဟ အဲအရပ်မှ ထွက်ခွာယွေ့ ဂါလိလဲ အိန်နားတဆှောက် ကြွလေအယ်။ ကိုယ်တော်ဟ တောင်ကုန်းတခုပေါ်ဟို တက်ယွေ့ ထိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","လူအုပ်ကြီးဟ ခြေမစွမ်းမသန်သူများ၊ မျက်မမြင်များ၊ ကိုယ်အင်္ဂါချို့တဲ့သူများ၊ ဆွံ့အသူများနဲ့ အခြားရောဂါသည်များဟို ခေါ်လာကာ ယေရှုရဲ့ ခြေတော်ရင်းတွင် ချထားကြအယ်။ ယေရှုဟ အဲလူနာလို့ရဲ့ ရောဂါများဟို ပျောက်ကင်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ဆွံ့အသူများ စကားပြောကြတာဟို လည်းကောင်း၊ ကိုယ်အင်္ဂါချို့တဲ့သူများ အကောင်းတိုင်းတိုင်း ဖြစ်လာတာဟို လည်းကောင်း၊ ခြေမစွမ်းသူများ လမ်းဆှောက်ကြတာဟို လည်းကောင်း၊ မျက်မမြင်များ မျက်စေ့မျော်ကြတာဟို လည်းကောင်း တွေ့မျော်သောအခါ လူအုပ်လို့ဟ ရမ်းဆာ့အံ့ဩယွေ့ ဣသရေလအမျိုးသားလို့ရဲ့ ဘုရားသခင်ဟို ချီးမွန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ယေရှုဟ တဘဲ့တော်လို့အား အထံတော်ဟို ခေါ်ပင်းရင် “ဟေလူအပေါင်းဟို ငါသနားအယ်။ ပစာကို့ သူလို့ဟ ငါနဲ့အတူ သုံးရက်တိုင်တိုင် နေခဲ့ကြပင်း သူလို့မှာ ပစာမှ စားဖို့မဆိ။ သူလို့အား အစားအစာမကျွေးဘဲ နေအိုင်ဟို ငါ မပြန်စေလို၊ အေးလို့ပြန်ရင် သူလို့ဟ လမ်းတွင် အားပြတ်ကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","တဘဲ့တော်လို့ဟ “ဟေမျှ များပြားလဲ့ လူအုပ်ကြီး စားလောက်အောန် အစားအစာများဟို ငါလို့ဟ ဟေတောကန္တာရတွင် စနားမှာ ရနိန်မလုန်း” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ယေရှုဟ “နင်လို့တွင် မုန့်စလောက် ဆိလုန်း” ဟု မေးသော်၊ “မုန့်ခုနေလုံးနဲ့ ငါးကတစ် ဆိမန့်အယ်” ဟု ပြန်ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","အဲလိုမို့ ယေရှုဟ လူအုပ်ဟို မြေပေါ်တွင် ထိန်ရန် အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","အဲပင်းရင် ကိုယ်တော်ဟ မုန့်ခုနေလုံးနဲ့ ငါးဟို ယူယွေ့ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟို ချီးမွန်းအယ်။ မုန့်နဲ့ ငါးဟို ဖဲ့ယွေ့ တဘဲ့တော်လို့အား ပေးအယ်။ သူလို့ဟလည်း လူအုပ်လို့အား ပေးဝေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","သူလို့အားလုံးဟ ဝစွာ စားရကြအယ်။ အဲပင်းရင် တဘဲ့တော်များဟ စားကြွင်းစားကျန်များဟို တောင်း ခုနေတောင်းပြေ့ ကောက်သိမ်းကြရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","မုန့်စားသူ ဦးရေမှာ အမျိုးသမီးနဲ့ လူပဲ့များမှ လွဲရင် ယောက်ျား ၄,၀၀၀ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","အဲပင်းရင် ယေရှုဟ လူလို့အား ပြန်စေပင်း လှေပေါ်ဟို တက်ယွေ့ မာဂဒလမြို့ အရပ်ဒေသသို့ ကြွလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ဖာရိရှဲတချို့နဲ့ ဇဒ္ဒုကဲများဟ ယေရှုဟို စမ်းသပ်လိုသဖြင့် လာယွေ့ ခေါန်းခင်မှ နိမိတ်လက္ခဏာဟို ပြပေးရန် ကိုယ်တော်အား တောင်းဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ယေရှုဟ “ညနေခင်း ရောက်လာသောအခါ ‘မိုးခေါန်းခင် နီရင် ရာသီဥတု သာယာလိမ့်မယ်’ ဟု ဆိုတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","နက်စာ အချိန်နှိုက် ‘မိုးခေါန်းခင် နီယွေ့ မိုးအုံ့နေရင် ခုနေ့ မုန်တိုင်း လာလိမ့်မယ်’ ဟု ဆိုတတ်ကြအယ်။ နင်လို့ဟ မိုးခေါန်းခင်ဟို ကျေ့ခြင်းအားဖြင့် မိုးလေဝသရဲ့ အခြေနေဟို သိနိန်ကြသော်လည်း အချိန်ကာလများရဲ့ နိမိတ်လက္ခဏာများဟို ပိုင်းခြားယွေ့ မသိနိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ဆိုးညစ်ယွေ့ ဖောက်ပြန်သော မျိုးဆက်ဟ နိမိတ်လက္ခဏာဟို တောင်းကြသော်လည်း၊ ယောနရဲ့ နိမိတ်လက္ခဏာ မှတပါး ပစာ နိမိတ်လက္ခဏာမျှ နင်လို့အား ပြလိမ့်မယ် မဟုတ်” ဟု မိန့်အယ်။ အဲပင်းရင် ယေရှုဟ အဲသူလို့ဆေမှ ထွက်ခွာသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","တဘဲ့တော်လို့ဟ အိန်တဖက်ကမ်းဟို လာကြသောအခါ သူလို့ဟ မုန့်ဟို ယူဖို့ မေ့ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ယေရှုဟ သူလို့အား “ဖာရိရှဲနဲ့ ဇဒ္ဒုကဲလို့ရဲ့ တဆေးဟို သတိနဲ့ ဆှောင်ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","တဘဲ့တော်လို့ဟ “ငါလို့ မုန့် မယူလာခဲ့သောကျောန့် ဖြစ်အယ်” ဟု အချင်းချင်း ပြောဆိုလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","အေးလို့ ပြောဆိုနေတာဟို ယေရှုသိသဖြင့် သူလို့အား “ယုံကြည်ခြင်း အားနည်းသူလို့၊ နင်လို့ဟ မုန့်မပါကျောန်းဟို မစာကျောန့် အချင်းချင်း ဆွေးနွေးနေကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","နင်လို့ နားမလည်နိန်ကြသလော။ မုန့်ငါးလုံးဟို လူ ၅,၀၀၀ စားယွေ့ စနေတောင်း ကောက်သိမ်းရတာဟို နင်လို့ သတိမရကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","အဲဟာမဟုတ်ရင် မုန့်ခုနေလုံးဟို လူ ၄,၀၀၀ စားယွေ့ စနေတောင်း ကောက်သိမ်းရတာဟိုလည်း သတိမရကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","မုန့်နဲ့ ပတ်သက်ယွေ့ နင်လို့အား ငါပြောနေခြင်း မဟုတ်ကျောန်းဟို နင်လို့ မစာကျောန့် နားမလည်ကြတာလုန်း။ ဖာရိရှဲနဲ့ ဇဒ္ဒုကဲလို့ရဲ့ တဆေးဟို ဆှောင်ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","အဲပင်းရင် တဘဲ့တော်လို့ဟ မုန့်လုပ်တဆေးဟို ဆှောင်ရန် ပြောတာ မဟုတ်ဘဲ ဖာရိရှဲနဲ့ ဇဒ္ဒုကဲလို့ရဲ့ သွန်သင်ချက်များဟို မလိုက်နာရန် ကိုယ်တော် သတိပေးကျောန်း နားလည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ယေရှုဟ ကဲသရိ ဖိလိပ္ပုပြေနယ်ဟို ရောက်ဆိသောအခါ ကိုယ်တော်ဟ တဘဲ့တော်လို့အား “လူလို့ဟ လူသားဟို စသူဖြစ်အယ်ဟု ပြောဆိုကြလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“အချို့ဟ နှစ်ခြင်းဆရာယောဟန် ဟု ပြောယွေ့ အချို့ဟ ဧလိယ ဟု ပြောအယ်။ အချို့ဟ ယေရမိ အဲဟာမဟုတ်ရင် အခြား ပရောဖက်တပါးပါး ဟု ပြောဆိုကြအယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ကိုယ်တော်ဟ “နင်လို့ဟမူ ငါ့ဟို စသူ ဟု ဆိုကြလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ရှိမုန် ပေတရုဟ “ကိုယ်တော်သည် အသက်ဆှင်သော ဘုရားသခင်ရဲ့ သားတော်တည်းဟူသော ခရစ်တော် ဖြစ်အယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ယေရှုဟ “ယောဟန်ရဲ့ သား ရှိမုန်ဗာယောန၊ နင်ဟ မင်္ဂလာဆိအယ်။ အကျောန်းမှာ အသွေးအသားဟ ဟေအကျောန်းအရာဟို နင့်အား ဖွင့်ပြတာ မဟုတ်ဘဲ ခေါန်းခင်ဘုံနှိုက်ဆိသော ငါရဲ့ခမည်းတော်ဟ ဖော်ပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","အားပင်း နင်လို့အား ငါဆိုတာဟ၊ နင်ဟ ပေတရု ဖြစ်အယ်။ ဟေကျောက်ပေါ်မှာ ငါ့ရဲ့ အသင်းတော်ဟို ငါတည်ဆောက်ပင်း မရဏာနိုင်ငံရဲ့ ထင်ခါးလို့ဟလည်း အဲအသင်းတော်ဟို အနိန်ရကြမယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ခေါန်းခင်နိုင်ငံတော်ရဲ့ သော့များဟို နင့်အား ငါပေးမယ်။ နင်ဟ မြေကြီးပေါ်မှာ တုတ်ချေသမျှဟ ခေါန်းခင်ဘုံနှိုက် တုတ်ချေလျက် ဆိလိမ့်မယ်။ နင်ဟ မြေကြီးပေါ်မှာ ဖြည်လွှတ်သမျှဟ ခေါန်းခင်ဘုံနှိုက် ဖြည်လွှတ်လျက် ဆိလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","အေးနောက် ကိုယ်တော်ဟ မိမိ ခရစ်တော်ဖြစ်ကျောန်းဟို စသူမျှ မပြောရန် တဘဲ့တော်လို့အား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ယေရှုဟ ယေရုရှလင်မြို့သို့ သွားယွေ့ လူအကြီးအကဲများ၊ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာများရဲ့ လက်တွင် ဒုက္ခဝေဒနာများစွာ ခံစားရပင်း အသေသတ်ခြင်းခံရကာ သုံးရက်မြောက်သောနေ့နှိုက် သေခြင်းမှ ထမြောက်ဆှင်ပြန်မဲ့အကျောန်း တဘဲ့တော်လို့အား အဲအချိန်မှစယွေ့ စတင်ဆှင်းပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ပေတရုဟ ကိုယ်တော်အား ဘေးဖက်ဟို ခေါ်ယွေ့ စတင်ပင်း အပစ်တင်ကာ “သခင်ဘုရား၊ ဟေအမှုဟ ကိုယ်တော်နဲ့လွဲပါစေ။ ကိုယ်တော်ဟ အဲအမှုအရာများ မစာခါမျှ မဖြစ်ပျက်ပါစေနဲ့” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ယေရှုဟ လှည့်ယွေ့ ပေတရုအား “အချင်းစာတန်၊ ငါ့နောက်ဟို ဆုတ်လော့။ နင်ဟ ငါမှောက်မားလမ်းလွဲစေသူ ဖြစ်အယ်။ နင်ဟ ဘုရားသခင်ရဲ့ ရှုထောင့်ဟ မတွေးဘဲ လူရဲ့ ရှုထောင့်ဟသာ တွေးအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","အဲပင်းရင် ယေရှုဟ တဘဲ့တော်လို့အား “စသူမဆို ငါ့တဘဲ့ဖြစ်ချင်ရင် ကိုယ့်ကိုယ်ဟို ငြင်းပယ်ပင်း သူလို့ဟ ကိုယ့်လက်ဝါးကပ်တိုင်ဟို ထမ်းယွေ့ ငါ့နောက်ဟို လိုက်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","အကျောန်းမှာ စသူမဆို မိမိအသက်ဟို ကယ်ချင်သောသူဟ အသက်ဆုံးရှုံးရပေမဲ့ ငါအတွက် အသက်ဆုံးရှုံးသောသူ စသူမဆို အသက်ဟို တွေ့လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","လူဟ လောကတခုလုံးဟို အစိုးရသော်လည်း မိမိရဲ့ အသက်ဝိညာဉ်ဆုံးရှုံးလျှင် မစာအကျိုး ဆိမလုန်း။ အဲဟာမဟုတ်ရင် မိမိရဲ့ အသက်ဝိညာဉ်အား မစာအရာဟို ပေးယွေ့ လဲလှယ်နိန်မလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","အကျောန်းမှာ လူသားဟ မိမိအဖရဲ့ ဘုန်းအသရေဟို ဆောင်လျက် ခေါန်းခင်တမန်များနဲ့ အတူ ကြွလာလိမ့်မယ်။ အဲအခါ လူအပေါင်းလို့အား မိမိလို့ရဲ့ အကျင့်အလျောက် အကျိုးအပစ်ဟို ဆပ်ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","နင်လို့အား ငါ အမန်အကန် ဆိုတာဟ လူသားဟ နိုင်ငံတော်တည်လျက် ကြွလာတာဟို ဟေအရပ်နှိုက် ရပ်နေသော လူအချို့လို့ဟ မမျော်ခင် မသေရကြ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ခြောက်ရက်ကြာသောအခါ ယေရှုဟ သူနဲ့အတူ ပေတရု၊ ယာကုပ်၊ ယာကုပ်ရဲ့ညီ ယောဟန်လို့ဟို ယိုးကာ တောင်အမြင့်ပေါ်ဟို ခေါ်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","အဲမှာ ကိုယ်တော်ဟ သူလို့ရဲ့ ဆေ့တွင် အရောင်အဆင်း ပြောင်းလဲသွားအယ်။ မျက်နှာတော်ဟ နေလိုမျိုးတောက်ပလျက် အဝတ်ဟလည်း အလင်းလို ဖြူလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","အဲပင်းရင် မောရှေနဲ့ ဧလိယဟ ယေရှုနဲ့ စကားပြောလျက်နေတာဟို တဘဲ့တော် သုံးယောက်ဟ မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","အဲအခါ ပေတရုဟ ယေရှုဟို “သခင်ဘုရား၊ ဟေအရပ်နှိုက် ငါလို့အတွက် နေဖွယ်ကောင်းအယ်။ ကိုယ်တော် အလိုတော်ဆိရင် ကိုယ်တော်အတွက် တဲတဆောင်၊ မောရှေအတွက် တဆောင်၊ ဧလိယအတွက် တဆောင်၊ တဲသုံးဆောင်ဟို ငါလို့ ဆောက်လုပ်မယ်” ဟု ဆှောက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","အေးလို့ ပေတရု ဆှောက်ထားစဉ်ပင် တောက်ပသော မိုးသားတုန်းဟ သူလို့ အပေါ်ဟို ကျလာအယ်။ မိုးသားတုန်းထဲမှ အသံတော်ဟ “ဟေသူဟ ငါနှစ်သက်မြတ်နိုးရာ ငါရဲ့ ချစ်သားပေတည်း — သူရဲ့ စကားဟို နားထောင်ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","အဲအသံဟို တဘဲ့တော်လို့ ကြားသောအခါ ရမ်းဆာ့ ကြောက်လန့်ပင်း သူလို့ မျက်နှာဟို မြေကြီးပေါ်မှာ အပ်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ယေရှုဟ လာယွေ့ သူလို့ဟို တို့ထိပင်းလျှင် “ထကြ၊ မကြောက်ကြနဲ့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","အဲလိုမို့ သူလို့ဟ မော်ကျေ့ပင်း ယေရှု မှလွဲယွေ့ အခြားစသူဟိုမျှ မမျော်ကြတော့ချေ။ ");
INSERT INTO dnv_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","သူလို့ တောင်ပေါ်မှ ဆင်းကြစဉ်၊ ယေရှုဟ သူလို့အား “နင်လို့ မျော်ခဲ့ကြလဲ့ ရူပါရုံဟို လူသား သေခြင်းမှ မထမြောက်ခင် စသူမျှ မပြောကြနဲ့” ဟု မှာထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","အဲပင်းရင် တဘဲ့တော်လို့ဟ “ဧလိယသည် အရင် လာရမယ်ဟု ကျမ်းပြုဆရာလို့ဟ မစာကျောန့် ဆိုလုန်း” ဟု ယေရှုအား မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ယေရှုဟ “ဧလိယသည် အရင်လာပင်း အမှုအရာအားလုံးဟို အသင့်ပြင်ဆင်ရမယ် မန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","အဲလိုလဲ နင်လို့အား ငါပြောတာဟ ဧလိယဟ ရောက်လာပေမဲ့ လူလို့ဟ သူ့ဟို မသိကြသဖြင့် သူ့အား လုပ်ချင်ရာဟို လုပ်ခဲ့ကြပီ။ အဲတိုင်းတိုင်းပင် လူသားဟလည်း အဲသူလို့ရဲ့လက်တွင် ဒုက္ခဆင်းရဲ ခံရလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","အဲအခါမှ တဘဲ့တော်လို့ဟ နှစ်ခြင်းဆရာယောဟန်ဟို ညွန်းပင်း ယေရှု မိန့်ကျောန်း နားလည်လာကြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","သူလို့ဟ လူအုပ်ဆိရာဟို ပြန်လာကြသောအခါ လူတယောက်ဟ ယေရှုဆေဟို လာယွေ့ ဆေ့တော်နှိုက် ဒူးထောက်ကာ၊ ");
INSERT INTO dnv_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ဆရာ၊ ငါ့ရဲ့ သားဟို သနားမန့်။ သူဟ ဝက်ရူးပြန်ရောဂါစွဲပင်း မီးထဲ အဲဟာမဟုတ်ရင် ရေထဲဟို ဖြစ်စေ ခဏခဏ လဲကျတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","သူ့အား ကိုယ်တော်ရဲ့ တဘဲ့များဆေဟို ခေါ်ခဲ့သော်လည်း သူလို့ဟ မကျန်းမာစေနိန်ပါ” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ယေရှုဟ “ယုံကြည်ခြင်း ကင်းယွေ့ ဖောက်ပြန်ကြသော လူလို့၊ ငါဟ နင်လို့နဲ့ စလောက်ကြာအောန် နေရမလုန်း။ စလောက်ကြာအောန် နင်လို့အား သည်းခံရမလုန်း။ လူပဲ့သငယ်ဟို ငါ့ဆေဟို ခေါ်ခဲ့ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ယေရှုဟ နတ်ဆိုးအား အမိန့်ပေးလျှင် နတ်ဆိုးဟ လူပဲ့သငယ်ဆေမှ ထွက်သွားပင်း ခုတုံးပင် သူငယ်ဟ ကျန်းမာလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","အဲပင်းရင် တဘဲ့တော်လို့ဟ ယေရှုတယောက်တည်း ဆိသောအခါ အထံတော်ဟို ချဉ်းကပ်ယွေ့ “ငါလို့ဟ အဲနတ်ဟို မစာကျောန့် မောင်းထုတ်ယွေ့ မရလုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ယေရှုဟ “နင်လို့သည် ယုံကြည်ခြင်း အားနည်းသောကျောန့် ဖြစ်အယ်။ နင်လို့အား ငါ အမန်အကန် ပြောတာဟ၊ နင်လို့ဟ မုန်ညင်းစေ့လောက် ယုံကြည်ခြင်းဆိပါက ဟေတောင်အား ‘ဟေနေရာမှ အဲနေရာဟို ရွေ့ပြောင်းလော့’ ဟုဆိုလျှင် ပြောင်းရွေ့လိမ့်မယ်။ နင်လို့ မတတ်နိန်လဲ့ အရာမဆိ။” ");
INSERT INTO dnv_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","တဘဲ့တော် အားလုံးလို့ဟ ဂါလိလဲပြေဟို အတူလာကြသောအခါ ယေရှုဟ သူလို့အား “လူလို့ရဲ့ လက်တွင်းသို့ လူသားဟို အပ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","သူ့ဟို သတ်ကြပေမဲ့ သုံးရက်မြောက်သောနေ့တွင် လူသားဟ သေခြင်းမှ ဆှင်ပြန်ထမြောက်လိမ့်မယ်” ဟု မိန့်အယ်။ တဘဲ့တော်လို့ဟလည်း ရမ်းဆာ့ စိတ်မချမ်းမသာ ဖြစ်ကြကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ယေရှုနဲ့ တဘဲ့တော်လို့ဟ ကပေနောင်မြို့ဟို ရောက်ကြသောအခါ ဗိမာန်တော်ခွန်အတွက် ကောက်ခံသူများဟ လာပင်း ပေတရုအား “နင်ရဲ့ဆရာဟ ဗိမာန်တော်ခွန် ပေးဆောင်မန့်သလော” ဟု မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ပေတရုဟ “ပေးဆောင်အယ်” ဟု ဆိုအယ်။ နေအိုင်ထဲဟို ပေတရု ဝင်လာသောအခါ ယေရှုဟ ဦးရင်ဆုံးပြောတာဟ “ရှိမုန်၊ နင်မစာသို့ ထင်လုန်း။ လောကီဘုရင်လို့ဟ စသူ့ဆေမှ အခွန်များဟို ကောက်ခံကြလုန်း။ မိမိသားဆေမှလော၊ အခြားသူများဆေမှလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ပေတရုဟ “အခြားသူများဆေမှ ကောက်ခံအယ်” ဟုဆှောက်အယ်။ ယေရှုဟ “အဲသို့ဖြစ်ရင် အောင်နီငယ်ဟတော့ လွတ်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","အဲလိုလဲ သူလို့ စိတ်မနာသွားစေရန် နင်ဟ အိန်ဟို သွားပင်း ငါးမျှားလော့။ နင်ပထမ မိသော ငါးကို ယူပင်း ငါးစလောင်ဟို ဖွင့်လော့။ ငွေဒင်္ဂါးတပြားဟို တွေ့လိမ့်မယ်။ အဲငွေဟိုယူပင်း နင်နဲ့ ငါ့အတွက် အခွန်တော်ဟို သူလို့အား ပေးဆောင်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","အဲအချိန်နှိုက် တဘဲ့တော်လို့ဟ ယေရှု ဆေဟို လာယွေ့ “ခေါန်းခင်နိုင်ငံတော်တွင် စသူဟ အကြီးမြတ်ဆုံးဖြစ်လုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","အေးလိုမို့ ယေရှုဟ လူပဲ့သငယ်တယောက်ဟို သူ့နားဟို ခေါ်ပင်းရင် သူလို့ရဲ့ ဆေ့တွင် ရပ်နေစေပင်း ");
INSERT INTO dnv_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ကိုယ်တော်ဟ “နင်လို့အား ငါ အမန်အကန် ပြောတာဟ နင်လို့သည် ပြောင်းလဲယွေ့ လူပဲ့သငယ်လူမျိုး မဖြစ်ရင် ခေါန်းခင်နိုင်ငံတော်ဟို ဝင်ရလိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","အဲကျောန့် ဟေလူပဲ့သငယ်လိုမျိုး မိမိတတ်တိုင်းနှိမ့်ချသောသူ စသူမဆို ခေါန်းခင်နိုင်ငံတော်တွင် အကြီးမြတ်ဆုံး ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ငါရဲ့ နာမဟိုထောက်ပင်း ဟေလိုသော လူပဲ့သူငယ် တစုံတယောက်ဟို လက်ခံသူဟ ငါ့ဟို လက်ခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ငါ့ဟို ယုံကြည်လဲ့ လူပဲ့သငယ် တစုံတယောက်အား ယုံကြည်ခြင်း မားစေသူဟ လည်ပင်းတွင် ကြိတ်ဆုံကျောက်ကြီးဟို ဆွဲလျက် ပင်လယ်နက်ထဲဟို အချခံရရင် သူ့အဖို့ ပိုပင်း ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","လူတွေရဲ့ ယုံကြည်ခြင်းပျက်ပြားစေလဲ့ ကမ္ဘာကြီးဟာ ကြောက်စရာကောင်းလဲ့အရာဟ နင့်ဟို စောင့်နေအယ်၊ အေးလို့သော အမူအရာလို့ဟ အမြဲတမ်း တည်လိမ့်မယ်။ အဲလိုလဲ သူလို့ကို ယုံကြည်ခြင်းမှာ မားစေသောသူဟ ကြောက်စရာကောင်းလဲ့အရာဟ နင်ဟို စောင့်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“နင်ရဲ့ ခြေထောက် အဲဟာမဟုတ်ရင် လက်ဟ နင်ရဲ့ ယုံကြည်ခြင်းဟို မားစေရင်၊ အဲအရာဟို ဖြတ်ယွေ့ လောပလိုက်လော့။ လက်နေဖက် အဲဟာမဟုတ်ရင် ခြေနေဖက်ပါလျက် ထာဝရမီးထဲဟို လောချခံရတာထက် ခြေထောက် အဲဟာမဟုတ်ရင် လက်မပါဘဲ အသက်ဆှင်ခြင်းသို့ ဝင်စားခြင်းဟ နင့်အတွက် သာယွေ့ ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","အားပင်း နင်ရဲ့ မျက်စေ့ဟ နင်ရဲ့ယုံကြည်ခြင်းဟို ပျက်ပြယ်စေရင်၊ အဲမျက်စေ့ဟို ထုတ်ပင်း လောပစ်လော့။ မျက်စေ့ နေလုံးပါလျက် ငရဲမီးထဲဟို လောချခြင်း ခံရတာထက် မျက်စေ့တလုံးနဲ့ အသက်ဆှင်ခြင်းသို့ ဝင်စားခြင်းဟ နင့်အတွက် သာယွေ့ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“နင်လို့ဟ ဟေလူပဲ့သူငယ်ထဲမှ တစုံတယောက်ဟို မထီမဲ့မြင် မလုပ်မိစေဖို့ သတိထားကြလော့။ နင်လို့အား ငါပြောတာဟ၊ သူလို့ရဲ့ ခေါန်းခင်တမန်များဟ ခေါန်းခင်ဘုံဆှင် ငါ့ခမည်းတော်ရဲ့ မျက်မှောက်နှိုက် အမြဲတမ်း ခစားလျက် ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“နင်လို့ဟ စလို ထင်ကြလုန်း။ လူတယောက်ဟ မိမိမှာ ဆိလဲ့ သိုးကောင် ၁၀၀ အနက် တကောင် ပျောက်သွားရင် သူဟ ၉၉ ကောင်ဟို တောင်ပေါ်စားကျက်တွင် ထားခဲ့ပင်းရင် ပျောက်သော သိုးတကောင်ဟို လိုက်ယွေ့ မဆာဘဲ နေမလော။ ");
INSERT INTO dnv_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ပျောက်သောသိုးတကောင်ဟို ဆာယွေ့ တွေ့သောအခါ မပျောက်တဲ့ သိုး ကိုးဆယ့်ကိုးကောင်အတွက် ဝမ်းသာတာထက် အဲသိုးတကောင်အတွက် ပိုယွေ့ ဝမ်းသာအယ် ဟု နင်လို့အား ငါ အမန်အကန် ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","အဲနည်းတူစွာ ခေါန်းခင်ဘုံနှိုက် ဆိသော နင်လို့ရဲ့ အဖဟလည်း ဟေလူပဲ့သငယ် တစုံတယောက် ပျောက်ဆုံးသွားတာဟို အလိုတော်မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“နင်ရဲ့ ညီအကိုဟ နင့်ဟို ပစ်မားလျှင် သူ့အပစ်ဟို ဟောပြဖို့ သူ့ဆေဟို သွားလော့။ အဲလိုလဲ နင်လို့ သီးသန့်တွေ့ပင်း ပြောလော့။ နင့်ရဲ့ စကားဟို နားထောင်ရင် အဲညီအကိုနဲ့ နင်ဟ ပြန်ယွေ့ သင့်မြတ်သွားလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","အဲလိုလဲ သူဟ နင့်ရဲ့ စကားဟို နားမထောင်ရင် ‘သက်သေ နေယောက် အဲဟာမဟုတ်ရင် သုံးယောက်ရဲ့ ထွက်ဆိုချက်အားဖြင့် စကားအားလုံး အတည်ဖြစ်စေရန်’ ကျမ်းစာလာလဲ့အတိုင်း တယောက် အဲဟာမဟုတ်ရင် နေယောက်ဟို ခေါ်လော့။ ");
INSERT INTO dnv_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","အားပင်း သူဟ အဲသူလို့ရဲ့ စကားဟိုလည်း နားမထောင်ပြန်ရင် အေးအကျောန်းအရာအားလုံးဟို အသင်းတော်အား တိုင်ကြားလော့။ နောက်ဆုံးမှာ သူဟ အသင်းတော်ရဲ့ စကားဟိုပင် နားမထောင်ရင် အဲသူအား ဘုရားမဲ့သူ တယောက် အဲဟာမဟုတ်ရင် အခွန်ခံသူ တယောက်လိုမျိုး မှတ်ယူလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“နင်လို့အား ငါ အမန်အကန် ပြောတာဟ မြေကြီးပေါ်တွင် နင်လို့ တားမြစ်သမျှဟို ခေါန်းခင်ဘုံနှိုက် တားမြစ်ပင်း မြေကြီးပေါ်တွင် နင်လို့ ခွင့်ပြုသမျှဟို ခေါန်းခင်ဘုံနှိုက် ခွင့်ပြုလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“အားပင်း နင်လို့အား ငါ အမန်အကန်ပြောတာဟ လောကတွင် နင်လို့အနက် လူနေယောက်လို့ဟ သဘောတူပင်း ဆုတောင်းလဲ့ အရာအားလုံးအတွက် ခေါန်းခင်နှိုက်ဆိသော ငါရဲ့အဖဟ သူလို့အတွက် အေးအရာဟို ပြေ့စုံစေမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","အကျောန်းမှာ လူနေယောက် အဲဟာမဟုတ်ရင် သုံးယောက်လို့ဟ ငါ့နာမဖြင့် တနေရာရာတွင် စုဝေးကြသောအခါ အဲနေရာတွင် သူလို့နဲ့ အတူ ငါဆိမယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","အဲပင်းရင် ပေတရုဟ ယေရှုဆေဟို လာယွေ့ “သခင်ဘုရား၊ ငါရဲ့ ညီအကိုဟ ငါ့ဟို ပစ်မားရင် သူ့အား ဖယ်နေကြိမ်လောက် ခွင့်လွှတ်ရမလုန်း။ ခုနေကြိမ် တိုင်အောန်လော” ဟု မေးဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ယေရှုဟ “ခုနေကြိမ်တိုင်အောန် ဟု နင့်အား ငါမဆိုဘဲ အကြိမ် ခုနေဆယ် ခုနေလီ တိုင်အောန် ဟု ငါဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","အဲလိုမို့ ခေါန်းခင်နိုင်ငံတော်ဟ မိမိရဲ့ အစေခံများနဲ့ စာရင်းဆှင်း လိုလဲ့ ဘုရင်တပါးနဲ့ တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","သူဟ စာရင်းစပင်း ဆှင်းစဉ် ဆွေ မုတ်တသောင်း ကြွေးတင်သူ လူတယောက်ဟို သူ့ဆေဟို ခေါ်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","အဲသူဟ အကြွေးဆပ်စရာ မဆိသောကျောန့် ဘုရင်ဟ အဲသူနဲ့ တကွ သား ပေါင်အိုမ၊ ပစ္စည်းဥစ္စာဆိသမျှလို့ဟို ရောင်းယွေ့ ဆပ်ပေးစေရန် အမိန့်ချမှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","အဲအခါ အစေခံဟ ဘုရင်ရဲ့ ဆေ့တွင် ပျပ်ဝပ်လျက် ‘ငါ့ဟို သည်းခံတော်မူပါ၊ ဆိသမျှဟို ငါ ဆပ်မယ်’ ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ဘုရင်ဟ သူ့ဟို သနားသောကျောန့် အကြွေးဟို ခွင့်လွှတ်ပေးယွေ့ သူ့ဟို သွားခွင့်ပြုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“အဲလိုလဲ အေးအစေခံဟ ထွက်သွားသောအခါ မိမိအား ငွေဒင်္ဂါးတရာ အကြွေးတင်သောသူ အစေခံချင်း တယောက်ဟို မျော်အယ်။ သူဟို ဖမ်းယွေ့ လည်ပင်းညစ်ပင်း ‘နင်ဆပ်ရန် ဆိသော အကြွေးဟို ပြန်ဆပ်လော့’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","အဲအစေခံချင်းဟ ဒူးထောက်လျက် ‘ငါ့ဟို သည်းခံပါ၊ နင့်အား အကြွေး ပြန်ဆပ်ပါမယ်’ ဟု တောင်းပန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","အဲလိုလဲ သူဟ လက်မခံဘဲနေအယ်။ အဲအစား သူဟ သွားပင်း အေးသူဟို သူယူထားလဲ့ အကြွေးအား ပြန်ဆပ်လဲ့တိုင်အောင် သူ့ဟို ထောင်ထဲထည့်ထားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","အဲအဖြစ်အပျက်ဟို အခြားသော အစေခံချင်းလို့ သိမျော်သောအခါ ရမ်းဆာ့ စိတ်မကောင်းဖြစ်ပင်း မိမိလို့ရဲ့ သခင်ဆေဟို သွားပင်းလျှင် ဖြစ်ပျက်သမျှအားလုံးလို့ဟို ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","အဲအခါ သခင်ဟ အဲကျွန်ဟို ခေါ်ယွေ့ ‘ဆိုးညစ်သော အစေခံ၊ နင်ဟ ငါ့ဟို တောင်းပန်သောကျောန့် နင်ပေးဆပ်ရန် အကြွေးဆိသမျှဟို ငါပယ်ဖျက်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","နင့်ဟို ငါသနားသလို နင်ဟလည်း အစေခံချင်းဟို မသနားသင့်ဝူးလော’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","သူရဲ့ သခင်ဟ အူထော့ယွေ့ အကြွေးဆိသမျှ ပြန်ဆပ်လဲ့တိုင်အောင် သူ့ဟို အကျဉ်းချနှိပ်စက်သောသူ လက်ဟို အပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“အေးစာဟ နင်လို့သည် ညီအကိုအား စိတ်နေလုံးထဲမှ ခွင့်မလွှတ်ရင် ခေါန်းခင်ဘုံနှိုက် ဆိသော ငါရဲ့ အဖဟလည်း နင်လို့ဟို အဲတိုင်းတိုင်းပြုလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ယေရှုဟ ဟေသို့မိန့်ပင်းသောအခါ ဂါလိလဲပြေမှ ထွက်ခွာယွေ့ ယော်ဒန်မြစ်တဖက်ကမ်း ယုဒပြေဟို သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","လူအုပ်ကြီးဟ ကိုယ်တော်နောက်ဟို လိုက်ကြပင်း အဲအရပ်တွင် ကိုယ်တော်ဟ သူလို့ဟို ကျန်းမာစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ဖာရိရှဲအချို့လို့ဟ ကိုယ်တော်ဟို စမ်းချင်သောကျောန့် အထံတော်ဟို လာပင်း “လူတယောက်ဟ စလို အကျောန်းကျောန့်မဆို မိမိရဲ့ ပေါင်အိုမနဲ့ ကွာဆှင်းခြင်းဟ ငါလို့ရဲ့ ဥပဒေနဲ့ ညီသလော” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ယေရှုဟ “ဖန်ဆင်းဆှင်သည် အစအဦးကပင် ယောက်ျားနဲ့ မိန်းမအဖြစ် ဖန်ဆင်းအယ် ဟူသော ကျမ်းစကားဟို နင်လို့ မဖတ်ဖူးကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","အားပင်း ဘုရားသခင်ဟ ‘ဟေအကျောန်းကျောန့် ယောက်ျားဟ ကိုယ့်မိဘဟို စွန့်ယွေ့ မိမိပေါင်အိုမနဲ့ ပေါင်းသင်းနေထိန်ပင်း အဲသူနေယောက်ဟ တသားတည်း ဖြစ်ကြလိမ့်မယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","အဲလိုမို့ သူလို့ဟ နေဦးမဟုတ်ဘဲ တဦးတည်း ဖြစ်အယ်။ အဲကျောန့် ဘုရားသခင် စုံဖက်ပေးတာဟို လူဟ မခွဲခွာစေနဲ့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ဖာရိရှဲလို့ဟ ကိုယ်တော်ဟို “အဲသို့ဖြစ်ရင် မစာကျောန့် သူဟ မိမိရဲ့ ပေါင်အိုမဟို ကွာဆှင်းစာချုပ်နဲ့ ကွာဆှင်းရန် မောရှေ ပညတ်ခဲ့လုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ယေရှုဟ “နင်လို့သည် သင်ရခက်သူများ ဖြစ်သောကျောန့် မောရှေဟ နင်လို့အား ပေါင်အိုမနဲ့ ကွာဆှင်းခွင့် ပေးခဲ့ခြင်း ဖြစ်ပေမဲ့ မူလအစဟ အေးလိုမျိုး မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","နင်လို့အား ငါပြောတာဟ မိမိရဲ့ပေါင်အိုမအား အကျင့်ဖောက်ပြန်လဲ့ အပစ်မှတပါး အခြား စလို အပစ်ကျောန့် မဆို ကွာဆှင်းယွေ့ အခြားအမျိုးသမီးတယောက်နဲ့ အိုင်ထောင်ပြုသူဟ အိုင်ထောင်ရေးဖောက်ပြန်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","တဘဲ့တော်လို့ဟ ကိုယ်တော်အား “လင်နဲ့ မယား ပေါင်းသင်းဆက်ဆံမှုဟ ဟေသို့ဖြစ်လျှင် အိုင်ထောင် မပြုဘဲနေတာဟ ပိုယွေ့ ကောင်းအယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ယေရှုဟ “ဟေသင်ကြားခြင်းသည် လူတိုင်း ခံယူနိန်တာ မဟုတ်၊ အဲလိုလဲ ဘုရားသခင် ခွင့်ပြုသူများသာလျှင် ခံယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","အကျောန်းမှာ ယောက်ျားများ အိုင်ထောင် မပြုနိန်ကြတာဟ ကွဲပြားသော အကျောန်းအမျိုးမျိုးကျောန့် ဖြစ်အယ်။ တချို့မှာ အေးလိုမျိုး မွေးဖွားလာသောကျောန့် ဖြစ်အယ်၊ တချို့မှာ အဲနည်းအတိုင်း ယောက်ျားများဟ သူလို့ နည်းလမ်းအတိုင်း လုပ်ဆောင်သောကျောန့် ဖြစ်အယ်၊ အချို့မှာ ခေါန်းခင်နိုင်ငံတော်အတွက် အိုင်ထောင်ပြုနိန်စွမ်းဟို တတ်တိုင်း စွန့်လွတ်ရသူများလည်း ဆိကြအယ်။ အေးသင်ကြားမှုဟို လက်ခံနိန်သော သူဟ ခံယူစေ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","လူအချို့လို့ဟ လူပဲ့သူငယ်များအပေါ် လက်တော်တင်ပင်း ဆုတောင်းပေးစေခြင်းငှာ အထံတော်ဟို ခေါ်ဆောင်လာကြပေမဲ့ တဘဲ့တော်လို့ဟ လူလို့ဟို ငေါက်ငမ်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ယေရှုဟ “လူပဲ့သူငယ်လို့ ငါ့ဆေဟို လာကြစေ၊ အားပင်း သူလို့ဟို မတားဆီးကြနဲ့။ ပစာကို့ ခေါန်းခင်နိုင်ငံတော်ဟ အဲသို့သော သူလို့ရဲ့ နိုင်ငံဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ကိုယ်တော်ဟ သူလို့အပေါ်မှာ လက်တော်တင်ပင်း အဲအရပ်မှ ထွက်ကြွအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","လူတယောက်ဟ ယေရှုဆေဟို လာယွေ့ “ဆရာ၊ ထာဝရအသက်ဟို ရဖို့ ငါဟ မစာ ကောင်းမြတ်တဲ့ အမှုဟို ပြုရမှာလုန်း” ဟု မေးဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ယေရှုဟ “နင်သည် ကောင်းမြတ်လဲ့အမှုနဲ့ ပတ်သက်ယွေ့ ငါ့အား မစာကျောန့် မေးလုန်း။ ကောင်းမြတ်သော အဆှင် တပါးတည်းသာ ဆိအယ်။ နင်ဟ ထာဝရအသက်ဟို ခံယူလိုလျှင် ပညတ်တော်လို့ဟို စောင့်ထိန်းလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","အဲသူဟ “မစာ ပညတ်တော်များလုန်း” ဟု ဆှောက်ရင် ယေရှုဟ “လူ့အသက်ဟို မသတ်နဲ့၊ အိုင်ထောင်ရေးမဖောက်ပြန်နဲ့၊ သူ့ဥစ္စာဟို မခိုးနဲ့၊ မမန်သော သက်သေဟို မခံနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","မိဘဟို ရိုသေစွာပြုလော့၊ အိုင်နီးချင်းဟို ကိုယ်နဲ့အမျှ ချစ်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","အဲလူငယ်ဟလည်း “ငါဟ အဲပညတ်အပေါင်းဟို စောင့်ထိန်းပီ၊ ငါ့တွင် မစာအရာ လိုနေသေးလုန်း” ဟု ပြန်လည်ဆှောက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ယေရှုဟ “နင်ဟ ပြည့်စုံသောသူဖြစ်လိုလျှင် သွားပင်း နင့်ဥစ္စာဆိသမျှဟို ရောင်းပင်းလျှင် ဆင်းရဲသူလို့အား ပေးကမ်းလော့၊ အားပင်း နင်ဟ ခေါန်းခင်ဘုံတွင် ဘဏ္ဍာဟို ရလိမ့်မယ်။ အဲပင်းရင် လာယွေ့ ငါ့နောက်သို့ လိုက်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","လူငယ်ဟ ရမ်းဆာ့ ချမ်းသာသူ ဖြစ်သောကျောန့် အဲစကားဟို ကြားသောအခါ ဝမ်းနည်းလျက် ထွက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","အဲပင်းရင် ယေရှုဟ တဘဲ့တော်လို့အား “နင်လို့အား ငါ အမန်အကန် ပြောတာဟ ချမ်းသာသူဟ ခေါန်းခင်နိုင်ငံတော်ဟို ဝင်နိန်ရန် ခက်ခဲ့လအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","တဖန် ငါ နင့်ဟို ပြောတာဟ၊ ချမ်းသာသောသူသည် ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို ဝင်ဖို့ထက် အပ်နဖားပေါက်မှ ကုလားအုတ် လျှိုဝင်ရန် လွယ်ကူအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","တဘဲ့တော်လို့ဟ အဲစကားဟို ကြားသောအခါ ရမ်းဆာ့ အံ့ဩကြသဖြင့် “အဲလိုမို့ စသူဟ ကယ်တင်ခြင်းဟို ရနိန်လုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ယေရှုဟ သူလို့ဟို စိုက်ကျေ့လျက် “ဟေအရာဟ လူလို့အတွက် မဖြစ်နိန်ပေမဲ့လည်း ဘုရားသခင်အတွက် အရာအားလုံးဟ ဖြစ်နိန်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","အဲပင်းရင် ပေတရုဟ “ကျေ့မန့်၊ ငါလို့ဟ အရာအားလုံးဟို စွန့်ယွေ့ ကိုယ်တော်ရဲ့ နောက်တော်သို့ လိုက်ခဲ့ကြပီ။ ငါလို့ ပစာအရာဟို ရမလုန်း” ဟု ဆှောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ယေရှုဟ သူလို့အား “ငါ အမန်အကန် နင်လို့ဟို ပြောတာဟ အသစ်ပြုပြင်ရာ ကာလတွင် လူသားဟ ဘုန်းအသရေနဲ့ ပြေ့စုံလဲ့ ပလ္လင်တော်မှာ ထိန်သောအခါ ငါရဲ့ တဘဲ့ဖြစ်သူ နင်လို့ဟလည်း ပလ္လင် တဆယ့်နေခုပေါ်မှာ ထိန်ယွေ့ ဣသရေလ အနွယ်တဆယ့်နေမျိုးဟို တရားစီရင် ရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","အားပင်း ငါ့အတွက်ကျောန့် နေအိုင်၊ လယ်၊ ညီအကို၊ နှမ၊ မိဘ၊ သားသမီးဖြစ်စေ စွန့်သောသူတိုင်းဟ အဆတရာမျှ အကျိုးဟို ရဆိပင်း ထာဝရအသက်ဟိုလည်း အမွေခံ ရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","အဲလိုလဲ နောက်ကျသောသူ အများလို့ဟ အရင်ကျပင်း အရင်ကျသောသူ အများလို့ဟ နောက်ကျကြလိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ခေါန်းခင်နိုင်ငံတော်သည် မခင်အခါဟ လူတယောက်သည် မိမိရဲ့ စပျစ်ဥယျာဉ်အတွက် အလုပ်သမားများဟို ငှားရန် နက်စာစောစော ထွက်သွားသောသူနဲ့တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","သူဟ တနေ့လျှင် ငွေဒင်္ဂါး တပြားနဲ့ သဘောတူသဖြင့် သူလို့အား မိမိရဲ့ စပျစ်ဥယျာဉ်ဟို စေလွှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","သူဟ နက်စာ ကိုးနာရီခန့်တွင် ဆေးရပ်ကွက်ဟို ထွက်လာရာ တခြားသူများ အလုပ်မဲ့ ရပ်နေတာဟို မျော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","အဲသူလို့အား ‘နင်လို့ဟ ငါ့ စပျစ်ဥယျာဉ်ဟို သွားပင်း အလုပ်လုပ်ကြ။ သင့်တင့်သော လုပ်အားခဟို ငါပေးမယ်’ ဟု ဆိုသဖြင့် ");
INSERT INTO dnv_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","သူလို့ဟ သွားကြအယ်။ အဲနောက် သူဟ မွန်းတည့်ချိန်နဲ့ မွန်းလွဲ သုံးနာရီခန့်တွင် တခါထွက်သွားပင်း အဲတိုင်းတိုင်းလုပ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ညနေ ငါးနာရီနှိုက် ထွက်သွားယွေ့ အခြားသောသူလို့ ရပ်လျက်နေတာဟို မျော်အယ်။ သူဟ သူလို့အား ‘နင်လို့ မစာကျောန့် တနေ့လုံး အလုပ်မလုပ်ဘဲ ဟေနေရာတွင် ရပ်နေကြလုန်း’ ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","သူလို့ဟ ‘ငါလို့အား စသူမျှ မငှားသောကျောန့် ဖြစ်အယ်’ ဟု ပြန်ပြောကြအယ်။ ဥယျာဉ်ဆှင်ဟ ‘နင်လို့လည်း ငါ့ စပျစ်ဥယျာဉ်ဟို သွားပင်း အလုပ်လုပ်ကြ’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ညနေခင်းချိန် ရောက်လာသောအခါ ဥယျာဉ်ဆှင်ဟ မိမိရဲ့ စီမံခန့်ခွဲရေးမှူးအား ‘အလုပ်သမားများဟို ခေါ်ယွေ့ နောက်ဆုံး အလုပ်ဝင်သူများမှ အစပြုပင်း ပထမဆုံး အလုပ်ဝင်သူများတိုင်အောန် အားခများဟို ပေးလော့’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ငါးနာရီချိန်တွင် စပင်းအလုပ်လုပ်သော သူလို့ဟ ငွေဒင်္ဂါး တပြားစီရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","အဲလိုမို့ ပထမဆုံး ငှားလဲ့ အလုပ်သမားများ လာကြသောအခါ သူလို့ဟ ပိုပင်း ရမယ် ဟု ထင်ထားကြပေမဲ့ သူလို့ဟလည်း ငွေဒင်္ဂါးတပြားစီ ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","သူလို့ဟ သူလို့ရဲ့ အားခဟို ယူပင်း စတင်ကာ ဥယျာဉ်ဆှင်ဟို ကဲ့ရဲ့ပစ်တင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘နောက်ဆုံးလာသော ဟေသူလို့ဟ တနာရီလောက်သာ အလုပ်လုပ်ကြရအယ်။ ငါလို့မူ တနေကုန် နေပူကြဲကြဲတွင် ပင်ပန်းစွာ လုပ်ကိုင်ကြရပေမဲ့လည်း အဆှင်ဟ ငါလို့အား အဲသူလို့နဲ့ ညီတူမျှတူ အားခပေးအယ် ဟုတ်မောင့်လဲ့။’ ");
INSERT INTO dnv_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ဥယျာဉ်ဆှင်ဟ သူလို့ထဲမှ တယောက်အား ‘နားထောင်ပါ၊ မိတ်ဆွေ၊ ငါဟ နင့်ဟို မတရားပြုတာ မဟုတ်။ နင်ဟ တနေ့လျှင် ငွေဒင်္ဂါး တပြားနဲ့ အလုပ်လုပ်ရန် သဘောတူခဲ့တာ မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","အခု နင့်ရဲ့ အားခဟို ယူယွေ့ အိုင်ဟို သွားလော့။ နောက်ဆုံးငှားလဲ့ ဟေအလုပ်သမားအား နင့်ဟို ပေးသလို ငါပေးလိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ငါဟ ငါပိုင်လဲ့ ငွေဟို ပြုလိုသမျှ မပြုရသလော။ အဲဟာမဟုတ်ရင် ငါသဘော ကောင်းသောကျောန့် နင် မနာလိုစိတ် ဆိသလော’ ဟု ဆိုအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","အားပင်း ယေရှုဟ “အဲနည်းတူ နောက်ကျသော သူလို့ဟ အရင်ကျကြလိမ့်မယ်။ အရင်ကျသော သူလို့ဟ နောက်ကျကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ယေရှုဟ ယေရုရှလင်မြို့ဟို တက်ကြွစဉ် လမ်းခရီးနှိုက် တဘဲ့တော် တဆယ့်နေပါးလို့အား မလှမ်းမကမ်းဟို သီးသန့် ခေါ်ဆောင်ပင်းရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“နားထောင်ကြလော့၊ ငါလို့ဟ ယေရုရှလင်မြို့သို့ တက်သွားကြအယ်။ အဲမြို့တွင် လူသားဟ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာများရဲ့ လက်ထဲအပ်နှံခြင်းဟို ခံရလိမ့်မယ်။ သူလို့ဟ သေဒဏ်စီရင်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","အားပင်း တပါးအမျိုးသားလို့ရဲ့ လက်သို့ အပ်နှံကြလိမ့်မယ်။ ပြက်ရယ်ပြုခြင်း၊ ရိုက်နှက်ခြင်း၊ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ကြပေမဲ့ သုံးရက်မြောက်သောနေ့နှိုက် လူသားဟ ထမြောက်လိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","အဲပင်းရင် ဇေဗေဒဲရဲ့ ပေါင်အိုမဟ သားများနဲ့အတူ ယေရှုဆေ ချဉ်းကပ်ပင်း ဦးချရှိခိုးလျက် မျက်နှာသာပေးဖို့ ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ယေရှုဟ သူမဟို “နင် မစာအရာဟို အလိုဆိလုန်း” ဟု မေးရင်၊ သူဟ “ကိုယ်တော်ရဲ့ နိုင်ငံတွင် ဘုရင်အဖြစ်အုပ်စိုးသောအခါ ကျွန်မရဲ့သား နေယောက်လို့ဟ လက်ယာတော်ဘက်နှိုက် တယောက်နဲ့ လက်ဝဲတော်ဘက်နှိုက် တယောက် ထိန်ရသော အခွင့်ပေးပါ” ဟု ဆှောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ယေရှုဟ “နင်လို့သည် စလိုအရာအတွက် တောင်းဆှောက်နေတာဟို နင်လို့ မသိကြ၊ ငါသောက်ရမဲ့ ဒုက္ခဝေဒနာမုတ်ဟို နင်လို့ သောက်နိန်ကြသလော” ဟု မေးအယ်။ သူလို့ဟ “ငါလို့ သောက်နိန်မန့်အယ်” ဟု ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ယေရှုဟ “နင်လို့သည် ငါရဲ့ မုတ်မှ အမန်ပင် သောက်ရကြပေမဲ့ ငါရဲ့ လက်ယာဘက်နဲ့ လက်ဝဲဘက်လို့နှိုက် ထိန်ရသောအခွင့်ဟို ငါပေးတာ မဟုတ်။ ဟေနေရာဟ ငါ့ရဲ့အဖ ပြင်ဆင်ထားသူများ အတွက်သာ ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ဟေအကျောန်းအရာဟို အခြား တဘဲ့တော် ဆယ်ဦးလို့ ကြားသောအခါ သူလို့ဟ အဲညီအကိုနေယောက်ဟို အူထော့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ယေရှုဟ သူလို့ဟို အတူတကွ ခေါ်လျက် “လူမျိုးခြားလို့တွင် အုပ်ချုပ်သူလို့ဟ ပြည်သူလို့အပေါ် စိုးမိုးခြယ်လှယ်ကြယွေ့ အကြီးအကဲလို့ဟ သူလို့အပေါ် အာဏာသုံးတတ်ကြတာဟို နင်လို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","နင်လို့ဟတော့ အဲလိုမပြုကြနဲ့။ အဲအစား၊ နင်လို့တွင် ကြီးမြတ်သောသူဖြစ်လိုသူဟ နင်လို့ရဲ့ အစေခံ ဖြစ်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ဦးရင်ဆုံးဖြစ်ချင်သောသူဟ နင်လို့ရဲ့ ကျွန်ဖြစ်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","လူသားပင်လျှင် သူတပါးအား အစေခံရန် ကြွလာတာ မဟုတ်။ အဲလိုလဲ သူတပါးရဲ့ အစေဟိုခံရန်နဲ့ မိမိအသက်ဟို စွန့်ယွေ့ လူများအား ရွေးနုတ်ရန် ကြွလာသတည်း” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ယေရှုနဲ့ တဘဲ့တော်လို့ဟ ယေရိခေါမြို့မှ ထွက်ခွာလာကြစဉ် လူအုပ်ကြီးဟ နောက်တော်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ယေရှု ကြွသွားကျောန်းဟို လမ်းအနီးတွင် ထိန်နေသော မျက်စေ့ မမျော်သောသူနေယောက်လို့ဟ ကြားယွေ့ “ဒါဝိဒ်ရဲ့သားတော် သခင်ဘုရား၊ ငါလို့ဟို သနားမန့်” ဟု စတင် အော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","လူအုပ်ကြီးလို့ဟ သူလို့အား တိတ်တိတ်နေရန် ငေါက်ငမ်းပြောဆိုကြပေမဲ့ သူလို့ဟ “ဒါဝိဒ်ရဲ့သားတော် သခင်ဘုရား၊ ငါလို့ဟို သနားမန့်” ဟု ပိုပင်းအော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ယေရှုဟ ရပ်တန့်ယွေ့ အဲသူလို့အား အထံတော်ဟိုခေါ်ပင်းလျှင် “နင်လို့အတွက် မစာအရာဟို ပြုစေလိုလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","သူလို့ဟ “သခင်ဘုရား၊ ငါလို့အား မျက်စေ့ပြန်ယွေ့ မျော်ချင်ပါအယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ယေရှုဟ သူလို့ဟို သနားသဖြင့် သူလို့ရဲ့မျက်စေ့ဟို လက်နဲ့ တို့အယ်။ အဲသူလို့ဟ ခုတင်ချင်းပင် မျက်စေ့မျော်ယွေ့ နောက်တော်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ယေရှုနဲ့ တဘဲ့တော်လို့ဟ ယေရုရှလင်မြို့ဟို ချဉ်းကပ်လာပင်း သံလွင်တောင်အနီးဆိ ဗက်ဖာဂေရွာဟို ရောက်ကြစဉ်၊ ယေရှုဟ တဘဲ့တော်နေယောက်အား ဦးရင် စေလွတ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“နင်လို့ ဆေ့တွင် ဆိသော ရွာဟို သွားကြလော့။ ကြိုးနဲ့လှန်ထားသော မြည်းမနဲ့ သူရဲ့ နားမှာဆိသော မြည်းသငယ်ဟို နင်လို့ ခုတင်ချင်း မျော်ရလိမ့်မယ်။ ကြိုးဟို ဖြေယွေ့ မြည်းများဟို ငါဆေ ယူခဲ့ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","တစုံတယောက်ဟ နင်လို့အား တစုံတခုပြောရင် ‘သခင်အလိုဆိပါအယ်’ ဟု ပြောကြလော့။ အားပင်း သူဟ ခုတုံး ယူခွင့်ပြုလိမ့်မယ်” ဟူယွေ့ မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ဟေအကျောန်းအရာဟ ပရောဖက် ဟောခဲ့လဲ့အတိုင်း အမန်တကယ် ဖြစ်ပျက်လာခြင်း ဖြစ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ကျေ့မန့်၊ နင်ရဲ့ ဘုရင်ဟ နင့်ဆေဟို ကြွလာပီ၊ အေးသူဟ နူးညံ့သိမ်မွေ့စွာဖြင့် မြည်းဟို စီးအယ်၊ ဝန်တင်သော တိရစ္ဆာန်ရဲ့ သား၊ မြည်းသငယ်ဟို စီးအယ်ဟု ဇိအုန်မြို့အား ပြောကြလော့။” ");
INSERT INTO dnv_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","တဘဲ့တော် နေယောက်လို့ဟ ထွက်သွားပင်းရင် ယေရှု မိန့်မှာလဲ့အတိုင်း ဆောင်ရွက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","သူလို့ဟ မြည်းမနဲ့ မြည်းသငယ်ဟို ယူခဲ့ပင်း မိမိလို့ရဲ့ ဝတ်လုံများဟို လွားတင်ကြရာ ယေရှုဟ အဲအပေါ်မှာ ထိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","လူအုပ်ကြီးလို့ဟလည်း မိမိလို့ရဲ့ ဝတ်လုံများဟို လမ်းပေါ်မှာ ခင်းကြအယ်။ လူအချို့လို့ဟ သစ်ပင်များမှ အကိုင်းအခက်များဟို ခုတ်ပင်း လမ်းပေါ်မှာ ခင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ကိုယ်တော်ရဲ့ဆေ့မှ သွားသော လူအုပ်ကြီးနဲ့ နောက်မှလိုက်သော လူအုပ်လို့ဟ “ဒါဝိဒ်ရဲ့ သားတော်အား ဟောရှဏ္ဏာ ဖြစ်စေသတည်း။ ထာဝရဘုရားရဲ့ နာမတော်နဲ့ ကြွလာသော အဆှင်ဟ မင်္ဂလာဆိစေသတည်း။ ဘုရားသခင်ရဲ့ ဂုဏ်တော်ဟို ချီးမွန်းကြစေသတည်း” ဟု ကြွေးကြော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ယေရုရှလင်မြို့ဟို ကိုယ်တော် ဝင်လာသောအခါ တမြို့လုံး အုတ်အုတ်သဲသဲဖြစ်ပင်းရင် လူလို့ဟ “ဟေသူသည် စသူလုန်း” ဟု မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","လူအုပ်ကြီးဟ “ဟေသူသည် ဂါလိလဲပြေ နာဇရက်မြို့သား ပရောဖက် ယေရှု ဖြစ်အယ်” ဟု ဖြေကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ယေရှုဟ ဗိမာန်တော်ဟို ဝင်ပင်း ဗိမာန်တော် အထဲမှ ရောင်းဝယ်နေသူလို့ဟို မောင်းထုတ်အယ်။ ပိတ်ဆန်လဲသူလို့ရဲ့ စားပွဲများနဲ့ ချိုးငက်ရောင်းသူလို့ ထိန်ခုံများဟို လှန်လောပစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","အေးသူလို့အား “ ‘ငါအိုင်တော်ဟို ဆုတောင်းရာ အိုင်တော်ဟု ခေါ်ဝေါ်ခြင်းဟို ခံရလိမ့်မယ်’ ဟု ကျမ်းစာနှိုက် ရေးထားပေမဲ့လည်း နင်လို့ဟ အိုင်တော်ဟို ထားမြခိုအောင်းရာ ဖြစ်စေကြပီ ဟုတ်မောင့်လဲ့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ဗိမာန်တော်တွင် မျက်မမြင်များနဲ့ ခြေမစွမ်းမသန်သူများဟ အထံတော်ဟို လာကြပင်း ကိုယ်တော်ဟ သူလို့ရဲ့ ရောဂါများဟို ပျောက်ကင်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာများဟ ကိုယ်တော် လုပ်သော အံ့ဩဖွယ် အမှုအရာများဟို မျော်ယွေ့ “ဒါဝိဒ်ရဲ့ သားတော်အား ဟောရှဏ္ဏာ ဖြစ်စေသတည်း” ဟု ဗိမာန်တော်ထဲတွင် လူပဲ့သငယ်လို့ အော်နေတာဟို ကြားကြသောအခါ အူထော့လျက်၊ ");
INSERT INTO dnv_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","သူလို့ဟ “ဟေလူပဲ့သငယ်လို့ ပစာအရာ ပြောဆိုနေတာဟို ကြားသလော” ဟု ယေရှုအား မေးဆှောက်ကြအယ်။ ယေရှုဟ “ငါကြားအယ်။ ‘လူပဲ့သငယ်များနဲ့ နို့စို့သူငယ်များအား ချီးမွန်းစေရန် ပြင်ဆင်ပေးပီ’ ဟူ သောကျမ်းစကားဟို နင်လို့ ပစာအခါမျှ မဖတ်ဖူးကြပါသလော” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","အေးနောက် ယေရှုဟ မြို့မှ ထွက်ပင်းရင် ဗေသနိရွာဟို ကြွယွေ့ အဲရွာနှိုက် တညတာကုန်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ယေရှုဟ နက်စာစောစော မြို့သို့ပြန်လည်ကြွလာစဉ် မွတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","လမ်းတွင် သင်္ဘောသဖန်းပင် တပင်ဟို မျော်သဖြင့် အေးအပင်ဆိရာဟို သွားပေမဲ့ အပင်ပေါ်တွင် အရွက်များမှ လွဲယွေ့ စလိုအရာဟိုမျှ မတွေ့။ အဲလိုမို့ ကိုယ်တော်ဟ အေးအပင်အား “နင်ဟ နောင်ပစာအခါနှိုက် အသီးမသီးစေနဲ” ဟု မိန့်အယ်။ သင်္ဘောသဖန်းပင်ဟလည်း ခုတုံးပင် နွမ်းခြောက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","အေးအရာဟို တဘဲ့တော်လို့ မျော်ရင် အံ့ဩကြအယ်။ သူလို့ဟ “သင်္ဘောသဖန်းပင်သည် ပစာသို့ အမြန် နွမ်းခြောက်သွားသလုန်း” ဟု အချင်းချင်းမေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ယေရှုဟ “နင်လို့အား ငါ အမန်အကန် ပြောတာဟ နင်လို့ဟ သံသယကင်းသော ယုံကြည်ခြင်းဆိရင် သင်္ဘောသဖန်းပင်ဟို ငါလုပ်သလို လုပ်နိန်တာသာမက ဟေတောင်အား ‘ဟေနေရာမှ ရွေ့ပင်း ပင်လယ်ထဲဟို ကျလော’ ဟု ပြောရင် ပြောလဲ့အတိုင်း ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","နင်လို့ဟ ယုံကြည်ခြင်းဆိရင် ဆုတောင်းသမျှလို့ဟို ရဆိကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ယေရှုဟ ဗိမာန်တော်ဟို ပြန်လည်ကြွလာယွေ့ ဟောပြောသွန်သင်စဉ် ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အသက်ကြီးသူများဟ အထံတော်ဟို လာပင်းရင် “နင်ဟ ဟေအမှုအရာများဟို ပစာအခွင့်အာဏာနဲ့ ပြုလုန်း။ အေးအခွင့်အာဏာဟို စသူဟ နင့်အားပေးလုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ယေရှုဟ သူလို့အား “နင်လို့ဟို မေးခွန်းတခုဟို ငါမေးပင်း နင်လို့ ငါ့ဟို ဖြေရင် ဟေအမှုအရာများဟို ပစာအခွင့်အာဏာနဲ့ ငါလုပ်တာဟို ငါပြောမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ယောဟန် နှစ်ခြင်းမင်္ဂလာဟ ပစာကလာသလုန်း။ ခေါန်းခင် ဆေမှလော အဲဟာမဟုတ်ရင် လူလို့ ဆေမှသလော” ဟု မေးအယ်။ သူလို့ဟ အချင်းချင်း ငြင်းခုန်ကြကာ “‘ခေါန်းခင်မှ ဖြစ်အယ်’ ဟု ငါလို့ပြောရင် သူဟ ‘အဲလို့ဖြစ်ရင် ပစာကျောန့် သူ့ဟို မယုံကြလုန်း’ ဟု မေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","အဲလိုလဲ ‘လူလို့ဆေမှ ဖြစ်အယ်’ ဟု ငါလို့ပြောရင် လူလို့ဟို ငါလို့ ကြောက်ရအယ်။ အကျောန်းမှာ သူလို့အားလုံးဟ ယောဟန်ဟို ပရောဖက်တပါးအဖြစ် မှတ်ယူကြအယ်” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","အဲလိုမို့ သူလို့ဟ “ငါလို့ မသိပါ” ဟု ပြန်ဖြေကြအယ်။ အေးအခါ ယေရှုဟ “ငါပြုလဲ့ အမှုအရာများဟို ပစာအခွင့်အာဏာနဲ့ ပြုတာဟိုလည်း နင်လို့အား ငါမပြော” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“နင်လို့ဟ ပစာသို့ ထင်ကြလုန်း။ လူတယောက်မှာ သားနေယောက်ဆိအယ်။ သူဟ ပထမ သားဆေဟို သွားပင်းရင် ‘ငါ့သား၊ ခုနေ့ စပျစ်ဥယျာဉ်ဟို သွားပင်း အလုပ်လုပ်လော့’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","သားကြီးဟ ‘ငါသွားချင်ဝူး’ ဟု ဖြေသော်လည်း နောက်မှ စိတ်ပြောင်းလဲသဖြင့် သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","အဲပင်းရင် အဖဟ တခြားသား ဆေဟို သွားပင်း အဲတိုင်းတိုင်း ပြောအယ်။ သူဟ ‘ဟုတ်ကဲ့ ဆရာ၊ ငါ သွားမယ်’ ဟု ဖြေသော်လည်း မသွားဘဲနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","အေးသား နေယောက်လို့တွင် စသူဟ အဖရဲ့ အလိုဟို ဆောင်ခဲ့လုန်း” ဟု မေးအယ်။ အေးသူလို့ဟ “ပထမ သား ဖြစ်အယ်” ဟု ဖြေကြားကြအယ်။ ယေရှုဟ သူလို့အား “နင်လို့အား ငါ အမန်အကန် ပြောတာဟ အခွန်ခံသူများနဲ့ ပြည့်တန်ဆာများဟ နင်လို့ထက် အရင် ဘုရားသခင်ရဲ့ ခေါန်းခင်နိုင်ငံတော်ဟို ဝင်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","အကျောန်းမှာ ယောဟန်ဟ ဖြောင့်မတ်သောအကျင့်ဟို ပြဖို့ နင်လို့ဆေဟို လာသော်လည်း နင်လို့ဟ သူ့ဟို မယုံကြည်ကြ။ အဲလိုလဲ အခွန်ခံသူများနဲ့ ပြည့်တန်ဆာများဟတော့ ယုံကြည်ကြအယ်။ ဟေအကျောန်းအရာဟို မျော်ရကြသောအခါနှိုက်ပင် နင်လို့ဟ နောင်တရယွေ့ သူ့ဟို ယုံကြည်လာခြင်း မဆိကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“အခြားပုံဥပမာ တခုဟို နားထောင်ကြလော့” ဟု ယေရှုဟ ပြောအယ်။ “စပျစ်ဥယျာဉ်တခုဟို စိုက်ပျိုးသည့် မြေပိုင်ဆှင် တယောက်ဆိအယ်။ သူဟ စောင်းရန်း ကာယွေ့ စပျစ်သီးနယ်ရာကျင်းဟို တူးပင်း လင့်စင်တခုဟိုလည်း ဆောက်လုပ်အယ်။ အေးနောက် မိမိရဲ့ ဥယျာဉ်ဟို ခြံသမားလို့အား ငှားယွေ့ ခရီးထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","စပျစ်သီးပေါ်ချိန် နီးလာသောအခါ မိမိရဲ့ ငယ်သားများဟို ခြံသမားလို့ဆေ စေလွှတ်ပင်း သီးစားခ စပျစ်သီးများဟို တောင်းခံစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ခြံသမားလို့ဟ ငယ်သားများဟို ဖမ်းယွေ့ ရိုက်သူဟို ရိုက်၊ သတ်သူဟို သတ်၊ ခဲနဲ့ပစ်သူဟို ပစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ထပ်ပင်း ဥယျာဉ်ဆှင်ဟ ပထမအကြိမ်ထက် ငယ်သားများဟို ပိုပင်း စေလွှတ်ယွေ့ ခြံသမားလို့ဟ အေးငယ်သားများဟိုလည်း အရင်ခါတိုင်း လုပ်ကြပြန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","နောက်ဆုံးနှိုက် သူဟ ‘ငါရဲ့သားဟို အေးသူလို့ လေးစားလိမ့်မယ်’ ဟု ဆိုလျက် မိမိရဲ့ သားဟို ခြံသမားလို့ ဆေဟို စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","အဲလိုလဲ အေးသူလို့ဟ ဥယျာဉ်ဆှင်ရဲ့ သားကို မျော်သောအခါ ‘ဟေသူဟ အမွေစား အမွေခံ ဖြစ်အယ်။ လာကြ၊ သူ့ဟို သတ်ယွေ့ သူ့ဥစ္စာဟို ယူကြကုန်အံ့’ ဟု အချင်းချင်း တိုင်ပင်ပင်းနောက် ");
INSERT INTO dnv_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","သူ့ဟို ဖမ်းပင်း စပျစ်ဥယျာဉ် အပြင်ဟို ထုတ်ယွေ့ သတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“အဲလိုမို့ စပျစ်ဥယျာဉ်ဆှင် ရောက်လာသောအခါ ခြံသမားလို့အား ပစာသို့ ပြုလိမ့်မလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","သူလို့ဟ “သူသည် အေးဆိုးသွမ်းသော သူလို့ဟို အမန်ပင် သတ်ပစ်လိမ့်မယ်။ စပျစ်ဥယျာဉ်ဟိုလည်း စပျစ်သီးစားခ မန်မန်ပေးမဲ့ အခြားခြံသမားလို့အား ပေးအပ်ပါလိမ့်မယ်” ဟု ဖြေကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ယေရှုဟ သူလို့အား၊ “ ‘တိုက်တည်သူလို့ ပယ်ထားသော ကျောက်ဟ အရေးအကြီးဆုံးသော ထောင့်ချုပ်ကျောက် ဖြစ်လာရအယ်။ ဟေအမှုဟ ဘုရားသခင်ပြုသောအမှု ဖြစ်အယ်။ ငါလို့ မျက်မှောက်တွင် အံ့ဩဖွယ်ရာဖြစ်လေစွ’ ဟူသော ကျမ်းစာဟို နင်လို့ မဖတ်ဖူးကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“အဲလိုမို့ နင်လို့အား ငါပြောတာဟ၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို နင်လို့ ဆေမှ ရုပ်သိမ်းယွေ့ နိုင်ငံတော်ရဲ့ အသီးဟို လူအပေါင်းအား ပေးလိမ့်မယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ယေရှုရဲ့ ပုံဥပမာများဟို ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ဖာရိရှဲများ ကြားကြသောအခါ မိမိလို့ဟို ရည်မှတ်ယွေ့ မိန့်ကျောန်းသိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","သူလို့ဟ ကိုယ်တော်ဟို ဖမ်းဆီးရန် နည်းလမ်းဆာကြပေမဲ့ ကိုယ်တော်အား ပရောဖက်ဟု မှတ်ယူယုံကြည်နေသူ လူအုပ်ကြီးဟို ကြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ယေရှုဟ ထပ်ယွေ့ ပုံဥပမာဟို အသုံးပြုပင်း သူလို့အား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ခေါန်းခင်နိုင်ငံတော်ဟ မိမိရဲ့ သားအတွက် မင်္ဂလာဆောင်ဧည့်ခံပွဲ ပြင်ဆင်ထားတဲ့ ဘုရင်တပါး ကြုံတွေ့ရလဲ့ အဖြစ်အပျက်နဲ့ တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","သူဟ ဖိတ်ကြားထားသူများဟို ပွဲဟိုခေါ်လာရန် မိမိရဲ့ ငယ်သားလို့ဟို လွှတ်ပင်း ဖိတ်ခေါ်စေပေမဲ့ သူလို့ဟ မလာချင်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","အဲလိုမို့ ‘ငါရဲ့ ညစာစားပွဲ အသင့်ဆိပီ၊ နွားထီး အစဆိလဲ့ ဝသော တိရစ္ဆာန်များဟိုလည်း သတ်ပင်းပီ။ အားလုံး အဆင်သင့်ဆိပီ။ မင်္ဂလာဆောင်ပွဲဟို ကြွရောက်ကြပါ’ ဟု ဖိတ်ကြားသူလို့အား ပြောကြလော့ ဟူယွေ့ အခြားငယ်သားလို့အား မှာလိုက်ပြန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","အဲလိုလဲ ဖိတ်ကြားထားသော ဧည့်သည်လို့ဟ ဂရုမစိုက်ဘဲ တယောက်ဟ လယ်တောဟိုလည်းကောင်း၊ အခြားတယောက်ဟ မိမိကုန်သွယ်ရာဟိုလည်းကောင်း သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ကျန်သောသူများဟ ငယ်သားလို့ဟို ဖမ်းပင်း ဖိုင်သတ်ဖြတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ဘုရင်ဟ ရမ်းဆာ့အူထော့ယွေ့ စစ်သားများဟို စေလွှတ်ပင်း အေးလူသတ်သမားလို့ဟို သတ်စေယွေ့ သူလို့ရဲ့မြို့ဟိုလည်း မီးရှို့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","အေးနောက် ငယ်သားလို့ဟို ခေါ်ပင်းရင် ‘မင်္ဂလာဆောင်ဧည့်ခံပွဲဟ အသင့်ဆိပီ ဖြစ်သော်လည်း ဖိတ်ကြားခြင်း ခံရသူလို့ဟ အေးပွဲနဲ့ မတန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","အခု လမ်းမများဟို သွားပင်း နင်လို့ မျော်သမျှသောသူလို့ဟို မင်္ဂလာဆောင်ပွဲဟို ဖိတ်ခေါ်ကြလော့’ ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","အဲလိုမို့ ငယ်သားလို့ဟ လမ်းများဟို သွားပင်း မျော်သမျှသော လူဆိုး လူကောင်း အားလုံးလို့ဟို စုဝေးစေကြသဖြင့် မင်္ဂလာဆောင်ပွဲခန်းမဟ ဧည့်သည်များ ပြေ့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ဘုရင်ဟ ဧည့်သည်များဟို ကျေ့ရှုရန် ကြွလာသောအခါ မင်္ဂလာဆောင် ပွဲထိန်ဝတ်စုံဟို ဝတ်ဆင်မထားသောသူ လူတယောက်ဟို မျော်သဖြင့် ");
INSERT INTO dnv_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘အဆွေ၊ နင်ဟ မဝတ်စားပဲ ပစာကျောန့် ဝင်လာလုန်း’ ဟု မေးအယ်။ အဲလိုလဲ အေးသူဟ မဖြေနိန်ဘဲ ဆိနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","အေးအခါ ဘုရင်ဟ အစေခံလို့အား ‘အေးသူလို့ရဲ့ ခြေလက်လို့ဟို တုပ်ချေပင်းရင် အပြင်မိုက်ထဲဟို ထုတ်လိုက်ကြ။ အေးနေရာတွင် သူဟ ငိုကမြည်တမ်းပင်း အံသွားခဲကြိတ်လျက် နေရလိမ့်မယ်’ ဟု မိန့်အယ်” ဟူယွေ့ မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","အေးနောက် ယေရှုဟ “ဖိတ်ကြားခြင်းခံရသူလို့မှာ များသော်လည်း ရွေးချယ်ထားသူလို့ဟ နည်းအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","အေးနောက် ဖာရိရှဲလို့ဟ ထွက်သွားပင်း ကိုယ်တော်ဟို သူရဲ့ နှုတ်တော်ထွက် စကားအားဖြင့် အကွက်ဆင် ဖမ်းနိန်ရန် ဆွေးနွေးတိုင်ပင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","အဲပင်းရင် သူလို့ဟ မိမိလို့ရဲ့ တဘဲ့များဟို ဟေရုဒ်ရဲ့ ပါတီဝင်တချို့နဲ့အတူ အထံတော်ဟို စေလွှတ်ပင်းရင် “ဆရာ၊ ဆရာဟ သမ္မာတရားဟို ပြောကျောန်း ငါလို့သိအယ်။ တခြားသူများ စလိုထင်ကျောန်းဟို ဂရုမစိုက်ဘဲ လူလို့အတွက် ဘုရားသခင်ရဲ့ အလိုတော်အကျောန်း သမ္မာတရားဟို သွန်သင်အယ်။ ပစာကို့ စသူရဲ့ အဆင့်အတန်းဟိုမှ အလေးမထားပါ။ ");
INSERT INTO dnv_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","အဲပင်းရင် နင်လို့ စလိုထင်တာဟို ငါလို့အား ပြောပါ။ ရောမအင်ပါယာရဲ့ ဥပဒေအရ ဧကရာဇ်ဘုရင်အား အခွန်ဆက်သင့်သလော အဲဟာမဟုတ်ရင် မဆက်သင့်သလော” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","အဲလိုလဲ ယေရှုဟ သူလို့ရဲ့ ဆိုးသောအကြံအစည်ဟို သိသဖြင့် “သူတော်ကောင်း ဟန်ဆောင်တတ်သောသူလို့၊ နင်လို့ဟ ပစာကျောန့် ငါ့အား ထောင်ချောက်ဆင်ရန် ကြိုးစားကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","အခွန်တော် ပေးဆောင်ရန် ငွေဒင်္ဂါးတပြားဟို ငါ့အား ပြကြလော့” ဟု မိန့်အယ်။ သူလို့ဟ ဒေနာရိတပြားဟို ယူခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ကိုယ်တော်သည် “ဟေဟာဟ စသူ့ရုပ်ပုံ၊ စသူ့ကမ္ပည်းစာ ဖြစ်လုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","သူလို့ဟ “ဧကရာဇ်ရဲ့ရုပ်ပုံ၊ ဧကရာဇ်ဘုရင် ကမ္ပည်းစာ ဖြစ်ပါအယ်” ဟု ပြန်ဆှောက်ကြအယ်။ အဲလိုမို့ ယေရှုဟ သူလို့အား “ဧကရာဇ်ပိုင်လဲ့ အရာဟို ဧကရာဇ်အား ဆက်ကြလော့။ ဘုရားသခင် ပိုင်လဲ့အရာဟို ဘုရားသခင်အား ဆက်ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","အေးသူလို့ဟ အေးစကားဟို ကြားသောအခါ အံ့ဩကြယွေ့ ကိုယ်တော်ဆေမှ ထွက်ခွာသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","အေးနေ့နှိုက်ပင် ဇဒ္ဒုကဲအချို့လို့ဟ ယေရှုဆေဟို လာကြအယ်၊ သူလို့ဟ သေခြင်းမှ ဆှင်ပြန်ထမြောက်ခြင်း မဆိဟု ခံယူယုံကြည်ကြသူများ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","သူလို့ဟ “ဆရာ၊ တစုံတယောက်ဟ သားသမီးမရဘဲ သေသွားရင် မုဆိုးမဟို သူရဲ့ ညီဖြစ်သူဟ ဆက်ယူရမယ်။ ရသော လူပဲ့သူငယ်များအားဖြင့် အစ်ကိုရဲ့ အမျိုးဟို မပြတ်စေရဟု မောရှေ မိန့်မှာခဲ့ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","အခု ငါလို့တွင် ညီအကိုခုနေယောက် ဆိခဲ့ရာ အကိုကြီးဟ အိုင်ထောင်ကျပင်းနောက် လူပဲ့မဆိဘဲ သေဆုံးသွားလျက် သူရဲ့ပေါင်အိုမဟို သူ့ညီဆေ ထားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ဒုတိယညီ၊ တတိယညီစသည်ဖြင့် ညီအကို ခုနေယောက်စလုံးပင် အေးတိုင်းတိုင်း ဖြစ်ကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","နောက်ဆုံးနှိုက် မိန်းမဟလည်း သေပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","သို့ဖြစ်ယွေ့ သေခြင်းမှ ဆှင်ပြန်ထမြောက်ရာနေ့နှိုက် အေးမိန်းမဟ ညီအကို ခုနေယောက်အနက် စသူရဲ့ ပေါင်အိုမ ဖြစ်ပါမလုန်း။ သူလို့အားလုံးဟ အေးမိန်းမနဲ့ လက်ထပ်ခဲ့ကြပါအယ်” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ယေရှုဟ “နင်လို့သည် ကျမ်းစာ အဲဟာမဟုတ်ရင် ဘုရားသခင်ရဲ့ တန်ခိုးတော်ဟိုလည်း မသိကြယွေ့ အယူလွဲလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","အကျောန်းမှာ သေခြင်းမှ ဆှင်ပြန်ထမြောက်ကြသောအခါ လက်ထပ်ထိမ်းမြားခြင်းဟို မပြု။ သူလို့ဟ ခေါန်းခင်နှိုက်ဆိသော ခေါန်းခင်တမန်များလို ဖြစ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","သေသောသူလို့ရဲ့ ဆှင်ပြန်ထမြောက်ခြင်း အကျောန်းနဲ့ ပတ်သက်ယွေ့ နင်လို့အား ဘုရားသခင် မိန့်ခဲ့သောစကားဟို မဖတ်ဖူးကြသလော။ ဘုရားသခင်ဟ ");
INSERT INTO dnv_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘ငါဟ အာဗြဟံရဲ့ဘုရား၊ ဣဇက်ရဲ့ဘုရား၊ ယာကုပ်ရဲ့ဘုရား ဖြစ်အယ်’ ဘုရားသခင်ဟ သေသောသူလို့ရဲ့ ဘုရား မဟုတ်ဘဲ အသက်ဆှင်သော သူလို့ရဲ့ ဘုရား ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","အေးသွန်သင်ချက်ဟို လူအုပ်ကြီးလို့ ကြားသောအခါ သူလို့ဟ အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ဇဒ္ဒုကဲလို့ မချေပနိန်အောန် ဟေသို့ ယေရှု ဖြေကြားလိုက်ကျောန်းဟို ဖာရိရှဲလို့ ကြားသောအခါ သူလို့ဟ စုရုံးလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","သူလို့အထဲမှ ကျမ်းတတ်ဆရာတယောက်ဟ ထောင်ချောက်ဆင်ပင်း စမ်းသပ်လိုသဖြင့် မေးခွန်းမေးဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ဆရာ၊ ပညတ္တိကျမ်းမှာ ပစာပညတ်ဟ အကြီးမြတ်ဆုံး ဖြစ်လုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ယေရှုဟ “ ‘နင်ရဲ့ ဘုရားသခင် ထာဝရဘုရားဟို စိတ်နေလုံး အကြွင်းမဲ့၊ ကိုယ်စွမ်းဆိသမျှ၊ ဉာဏ်စွမ်းဆိသမျှနဲ့ ချစ်ရမယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ဟေပညတ်ဟ အရေးကြီးဆုံးပညတ်နဲ့ အကြီးမြတ်ဆုံးပညတ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ဒုတိယ အရေးကြီးဆုံး ပညတ်ဟ ဟေလိုမျိုး ဖြစ်ပင်း ‘အိုင်နီးချင်းဟို ကိုယ်နဲ့အမျှ ချစ်ရမယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ဟေပညတ်နေပါးလို့ဟ မောရှေရဲ့ပညတ္တိကျမ်း တစောင်လုံးနဲ့ ပရောဖက်ကျမ်းများရဲ့ အချုပ်အခြာပင် ဖြစ်သတည်း” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ဖာရိရှဲအချို့လို့ စုရုံးမိကြသောအခါ ယေရှုဟ သူလို့အား ");
INSERT INTO dnv_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“မေဆှိယ အကျောန်းနဲ့ ပတ်သက်ယွေ့ နင်လို့ စလို ထင်ကြလုန်း။ သူဟ စသူရဲ့ သားမြေး ဖြစ်လုန်း” ဟု မေးအယ်။ သူလို့ဟ “သူဟ ဒါဝိဒ်ရဲ့ သားမြေး ဖြစ်အယ်” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“သို့ဖြစ်ပါမူ ဒါဝိဒ်မင်းဟ ဝိညာဉ်တော်ရဲ့ နှိုးဆော်ချက်ဖြင့် သူ့ဟို ‘အဆှင်’ ဟု ပစာကျောန့် ခေါ်လုန်းဟု ယေရှုဟ မေးအယ်။ ဒါဝိဒ်မင်းကြီးဟ ");
INSERT INTO dnv_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘နင့်ရန်သူများဟို နင့်ရဲ့ ခြေထောက်အောက်ဟို ငါ ချထားသည့်တိုင်အောန် ငါရဲ့ လက်ယာဘက်တွင် ထိန်နေလော့ဟု ဘုရားသခင်ဟ ငါလို့ရဲ့ အဆှင်အား မိန့်အယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","အကယ်ယွေ့ ဒါဝိဒ်မင်းဟ မေဆှိယဟို ‘သခင်’ ဟု ခေါ်ရင် မေဆှိယဟ စလို ဒါဝိဒ်ရဲ့ သားမြေး ဖြစ်နိန်လုန်း” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ယေရှုအား စသူမျှ အဖြေ မပေးနိန်ကြ၊ အေးနေ့မှ စယွေ့ စသူမျှ ယေရှုအား နောက်ထပ် မမေးမြန်းဝံ့တော့ပေ။ ");
INSERT INTO dnv_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","အေးနောက် ယေရှုဟ လူအုပ်ကြီးနဲ့ တဘဲ့တော်လို့အား ");
INSERT INTO dnv_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ကျမ်းတတ်ဆရာနဲ့ ဖာရိရှဲများဟ မောရှေရဲ့ ထိန်ခုံပေါ်နှိုက် ထိန်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","အဲလိုမို့ အေးသူလို့ ပြောသမျှအတိုင်း နင်လို့ ဂရုစိုက်ကြလော့။ အဲလိုလဲ သူလို့ပြုလဲ့အတိုင်း မပြုကြနဲ့ အကျောန်းမှာ သူလို့ ပြောသလိုမျိုး သူလို့ မကျင့်သုံးကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","သူလို့ဟ လေးလံပင်း ထမ်းရခက်လဲ့ ဝန်ထုပ်များဟို သူတပါးလို့အား ထမ်းစေကြအယ်။ မိမိလို့ တတ်တိုင်းမူ အေးဝန်ထုပ်များဟို လက်ဖျားနဲ့မျှ မတို့လိုကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","မိမိလို့ ပြုလုပ်သမျှသောအရာလို့ဟို လူမျော်သာအောန် ပြုလုပ်တတ်ကြအယ်။ မိမိလို့နဖူးနဲ့ လက်မောင်းများပေါ်တွင် ကျမ်းစာလက်ဖွဲ့များဟို အပြားကြီးလုပ်ပင်း ဝတ်ဆင်တတ်ကြအယ်။ သူလို့ရဲ့ ဝတ်လုံအမြိတ်များဟို အဆှည် ချုပ်ထားတတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ပွဲသဘင်တွင် အကောင်းဆုံးသော နေရာထိန်ခင်းများ၊ တရားဇရပ်များတွင် သီးသန့်ထားသော နေရာများဟို နှစ်သက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ဆေးတွင် နှုတ်ဆက်ခြင်းဟို ခံလိုကြပင်း ‘ဆရာ’ ဟု အခေါ်ခံလိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","နင်လို့အားလုံးဟ မိသားစုဝင်များ ဖြစ်လျက် နင်လို့မှာ ဆရာတပါးတည်းသာ ဆိသောကျောန့် ‘ဆရာ’ ဟု အခေါ်မခံကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ဟေလောကတွင် စသူဟိုမျှ ‘အဖ’ ဟု မခေါ်ကြနဲ့၊ ပစာကို့ နင်လို့တွင် ခေါန်းခင်ဘုံ အဖတပါးတည်းသာ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","နင်လို့ဟ ခေါင်းဆောင် ဟူယွေ့လည်း အခေါ်မခံကြနဲ့၊ ပစာကို့ နင်လို့တွင် မေဆှိယ တည်းဟူသော ခေါင်းဆောင် တပါးတည်းသာ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","နင်လို့တွင် အကြီးမြတ်ဆုံးသူဟ နင်လို့ရဲ့ အစေခံ ဖြစ်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","မိမိတတ်တိုင်း ချီးမြှောက်သူဟ နိမ့်ကျရလိမ့်မယ်။ မိမိတတ်တိုင်း နိမ့်ချသူဟ ချီးမြှောက်ခြင်းဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“သူတော်ကောင်းဟန်ဆောင်သူ ဖာရိရှဲနဲ့ ကျမ်းတတ်ဆရာလို့၊ နင်လို့ဟ အမင်္ဂလာ ဆိကြအယ်။ အကျောန်းမှာ နင်လို့ဟ ခေါန်းခင်နိုင်ငံတော်ဟို လူလို့ဆေ့နှိုက် ထင်ခါး ပိတ်ထားယွေ့ နင်လို့ တတ်တိုင်းလည်း မဝင်၊ ဝင်ရန် ကြိုးစားသူများဟိုလည်း ဝင်ခွင့် မပြုကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“သူတော်ကောင်းဟန်ဆောင်သူ ဖာရိရှဲနဲ့ ကျမ်းတတ်ဆရာလို့၊ နင်လို့ဟ အမင်္ဂလာ ဆိကြအယ်။ အကျောန်းမှာ လူတယောက်ဟို ဘာသာဝင် ဖြစ်လာစေရန် နင်လို့ဟ ယေကျောန်း၊ ကုန်းကျောန်း ခရီးပြုကြယွေ့ ဘာသာဝင် ပင်းသောအခါနှိုက်လည်း အေးသူအား နင်လို့ထက် နေဆပိုယွေ့ ငရဲဟို သွားထိုက်သူ ဖြစ်စေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“လမ်းပြတဲ့ မျက်မမျော်လို့၊ နင်လို့ဟ အမင်္ဂလာ ဆိအယ်။ ‘တစုံတယောက်ဟ ဗိမာန်တော်ဟို တိုင်တည်ပင်း ကျိန်ဆိုရင် အေးကျိန်ဆိုချက်ဟ အတည်မဖြစ်ပေမဲ့ ဗိမာန်တော်ရဲ့ ဆွေဟို တိုင်တည်ယွေ့ ကျိန်ဆိုရင် အတည်ဖြစ်အယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","မျက်စေ့မမျော်သော လူမိုက်လို့၊ ပစာအရာကပိုပင်း အရေးကြီးပါလုန်း၊ ဆွေလော၊ အဲဟာမဟုတ်ရင် ဆွေဟို သန့်ဆှင်းစင်ကြယ်စေသော ဗိမာန်တော်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","နင်လို့အား သင်ပေးတာဟ ‘တစုံတယောက်ဟ ယဇ်ပလ္လင်ဟို တိုင်တည်ပင်း ကျိန်ဆိုရင် ကျိန်ဆိုချက်ဟ အတည်မဖြစ်ပေမဲ့ ယဇ်ပလ္လင်ပေါ်ဆိ ပူဇော်သကာဟို တိုင်တည်ယွေ့ ကျိန်ဆိုရင် အတည်ဖြစ်အယ်’ ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","နင် လို့ရဲ့မျက်စေ့ဟ ကန်းလှအယ် ဟုတ်မောင့်လဲ့၊ ပစာအရာဟ ပိုပင်း အရေးကြီးလုန်း။ ပူဇော်သကာလော၊ အဲဟာမဟုတ်ရင် ပူဇော်သကာဟို သန့်ဆှင်းစင်ကြယ်စေလဲ့ ယဇ်ပလ္လင်လော။ ");
INSERT INTO dnv_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","အဲလိုမို့ ယဇ်ပလ္လင်ဟို တိုင်တည်ယွေ့ ကျိန်ဆိုသူဟ ယဇ်ပလ္လင်နဲ့တကွ ယဇ်ပလ္လင်ပေါ် ဆိသမျှလို့ဟိုပါ တိုင်တည်ယွေ့ ကျိန်ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ဗိမာန်တော်ဟို တိုင်တည်ယွေ့ ကျိန်ဆိုသောအခါ ဗိမာန်တော်နဲ့တကွ ဗိမာန်တော်တွင် ကျိန်းဝပ်သော ဘုရားသခင်ဟိုပါ တိုင်တည်ယွေ့ ကျိန်ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ခေါန်းခင်ဘုံဟို တိုင်တည်ယွေ့ ကျိန်ဆိုသောအခါ ဘုရားသခင်ရဲ့ ပလ္လင်တော်နဲ့တကွ အေးပလ္လင်ပေါ်မှာ စံနေသော အဆှင်ဟိုပါ ကျိန်ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“သူတော်ကောင်းဟန်ဆောင်သူ ဖာရိရှဲနဲ့ ကျမ်းတတ်ဆရာလို့၊ နင်လို့ဟ အမင်္ဂလာဆိကြအယ်။ အကျောန်းမှာ နင်လို့ဟ ပင်စိမ်း၊ စမွတ်နဲ့ ဇီရာလို့ဟို ဆယ်ဖို့တဖို့ ပေးလှူကြသော်လည်း တရားမျှတမူ၊ သနားကြင်နာမှု၊ ရိုးသားဖြောင့်မတ်မှုစလဲ့ ပညတ်ကျမ်းမှ အကယ်ပင် အရေးကြီးသော သွန်သင်ချက်များဟိုတော့ လျစ်လျူရှုကြအယ်။ အေးအရာများဟို ပြုရမယ်ဖြစ်ပင်း အထက်တွင်ဆိုသော အရာများဟိုလည်း လျစ်လျူမရှုကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","လမ်းပြလဲ့ မျက်စေ့မမျော်လို့၊ နင်လို့ဟ ခြင်ကောင်မမျိုမိစေရန် သောက်ရည်ဟို စစ်ယွေ့ သောက်ကြပေမဲ့ ကုလားအုတ်ဟိုတော့ မျိုချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“သူတော်ကောင်းဟန်ဆောင်သူ ကျမ်းတတ်ဆရာနဲ့ ဖာရိရှဲလို့၊ နင်လို့ဟ အမင်္ဂလာဆိကြအယ်။ အကျောန်းမှာ နင်လို့ဟ ပန်းကန်ခွက်များရဲ့ အပြင်ဟို သန့်ဆှင်းအောင် ဆေးကြောကြသော်လည်း နင်လို့ရဲ့ စိတ်အတွင်းမှာဟ လောဘလွန်ကျူးမှုနဲ့ အကြမ်းဖက်မှုလို့ဖြင့် ပြည့်လျက်ဆိနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","မျက်စေ့မမျော်သော ဖာရိရှဲလို့၊ မုတ်များအား အတွင်းဖက်ဟို ဦးစွာ ဆေးကြောကြလော့၊ အဲလို့လုပ်ရင် ပြင်ပဟလည်း သန့်ဆှင်းခြင်း ဆိလာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“သူတော်ကောင်းဟန်ဆောင်သူ ကျမ်းတတ်ဆရာနဲ့ ဖာရိရှဲလို့၊ နင်လို့ဟ အမင်္ဂလာဆိကြအယ်။ အကျောန်းမှာ နင်လို့ဟ ထုံးဖြူသုတ်သော လုတ်တိုင်းဂူများနဲ့ တူကြအယ်။ အေးဂူလို့ဟ အပြင်ပန်းအားဖြင့် လှသော်လည်း အထဲနှိုက်မှာတော့ လူသေအရိုးနဲ့ ပုပ်နေသော အလောင်းကောင်လို့ဖြင့် ပြည့်လျက်ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","အေးနည်းတူ နင်လို့ဟ အပြင်အားဖြင့် လူလို့ဆေ့တွင် သူတော်ကောင်းများ ဟု ထင်ရသော်လည်း စိတ်အတွင်းမှာတော့ သူတော်ကောင်းဟန်ဆောင်ခြင်းနဲ့ အပစ်များ ပြည့်လျက်ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“သူတော်ကောင်းဟန်ဆောင်သူ ကျမ်းတတ်ဆရာနဲ့ ဖာရိရှဲလို့၊ နင်လို့ဟ အမင်္ဂလာ ဆိကြအယ်။ အကျောန်းမှာ နင်လို့ဟ ပရောဖက်များရဲ့ လုတ်တိုင်းဂူများဟို တည်ဆောက်ပင်း သူတော်ကောင်းလို့ရဲ့ လုတ်တိုင်းဂူများဟို မွမ်းမံခြယ်လှယ်ကြကာ၊ ");
INSERT INTO dnv_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","နင်လို့ဟ ‘ငါလို့သာ ဘိုးဘေးလို့ရဲ့ ခေတ်ဟ အသက်ဆှင်ခဲ့မယ် ဆိုပါက၊ ပရောဖက်များဟို သတ်ဖြတ်လဲ့အမှုတွင် ပါဝင်ခဲ့ကြမယ် မဟုတ်’ ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","အဲလိုမို့ နင်လို့ဟ ပရောဖက်များဟို သတ်ဖြတ်သူလို့ရဲ့ သားမြေးများဖြစ်ကျောန်း သက်သေခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","နင်လို့ရဲ့ ဖိုးဖေးများ စတင် ကျူးလွန်ခဲ့လဲ့ အပစ်ဟို အပင်းတိုင်အောန် ဆက်လက်ကျူးလွန်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","အချင်းမြွေပွေးများနဲ့ မြွေပွေးရဲ့ သားမြေးလို့၊ နင်လို့ဟ ငရဲသို့လားရမယ့် တရားစီရင်ခြင်းမှ ပစာသို့ လွတ်နိန် ကြမယ်လုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","အဲလိုမို့ နင်လို့အား ငါပြောတာဟ၊ နင်လို့ ဆေသို့ ပရောဖက်များ၊ ပညာဆိများ၊ ကျမ်းတတ်ဆရာများဟို ငါစေလွတ်ပင်း နင်လို့ဟ အေးသူ အချို့ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ဖြတ်ကြလိမ့်မယ်။ အချို့ဟိုမူ တရားဇရပ်များတွင် ကြိမ်ဒဏ်ပေးယွေ့ အချို့ဟိုမူ တမြို့ပင်းတမြို့လိုက်လံ ဖမ်းဆီးကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","အေးကျောန့် ဖြောင့်မတ်သောသူ အာဗေလရဲ့အသွေးမှ စယွေ့ အတွင်းဗိမာန်တော်နဲ့ ယဇ်ပလ္လင်အကြားတွင် နင်လို့သတ်ခဲ့လဲ့ ဗာရခိရဲ့သား ဇာခရိရဲ့ အသွေး တိုင်အောန် မြေကြီးအပေါ်နှိုက် သွန်းလောင်းပင်းသမျှသော ဖြောင့်မတ်သူလို့ရဲ့ အသွေးဟ နင်လို့ ပေါ်ဟို ရောက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ဟေအရာအားလုံးလို့ဟ ဟေမျိုးဆက် အပေါ်ကျရောက် လိမ့်မယ် ဟု နင်လို့အား ငါ အမန်အကန် ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“အို ယေရုရှလင်မြို့၊ ယေရုရှလင်မြို့၊ ပရောဖက်များဟို သတ်ယွေ့ ဘုရားသခင် စေလွတ်သော စေတမန်များဟို ခဲနဲ့ပေါက်လဲ့မြို့၊ ကြက်မကြီးဟ ကြက်သူငယ်များဟို အတောင်အောက်တွင် စုသိမ်းသလိုမျိုး ငါဟ နင်ရဲ့ လူများဟို ယုယပိုက်ထွေးနိန်ရန် ခဏခဏကြိုးစားခဲ့ပေမဲ့ နင်ဟ ငါ့ဟို အခွင့်မပေး။ ");
INSERT INTO dnv_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","အေးကျောန့် နင်ရဲ့ ဗိမာန်တော်ဟို ဘုရားသခင်ဟ စွန့်ပစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","‘ဘုရားသခင်ရဲ့ နာမတော်ဖြင့် ကြွလာသော အဆှင်ဟ မင်္ဂလာ ဆိစေသတည်း’ ဟု နင်မြွတ်ဆိုမယ့် နေ့မတိုင်ခင် နင်ဟ အခုမှ စယွေ့ ငါ့ဟို မျော်ရလိမ့်မယ် မဟုတ်ဟု နင်လို့အား ငါပြောအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ယေရှုဟ ဗိမာန်တော်မှ ထွက်ခွာသွားစဉ် တဘဲ့တော်လို့ဟ အထံတော်ဟို ချဉ်းကပ်ပင်း ဗိမာန်တော် အဆောက်အအုံများဟို ကိုယ်တော်အား ပြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ကိုယ်တော်ဟ “ဟေအရာအားလုံးဟို နင်လို့ မျော်ကြအယ် မဟုတ်လော၊ နင်လို့အား ငါ အမန်အကန် ပြောတာဟ၊ ဟေနေရာနှိုက် ကျောက်တတုံးပေါ် တတုံးတင်ယွေ့ မကျန်ရစ်လဲ့ တိုင်အောန် ပြိုပျက်ကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ယေရှုဟ သံလွင်တောင်ပေါ်တွင် တကိုယ်တည်း ထိန်နေစဉ် တဘဲ့တော်လို့ဟ အထံတော်ဟို သီးသန့် ချဉ်းကပ်ပင်း “ဟေအမူအရာများဟ ပစာကာလနှိုက် ဖြစ်ပျက်မလော။ ကိုယ်တော် ကြွလာချိန်နဲ့ ကပ်ကမ္ဘာကုန်ဆုံးချိန်နှိုက် ပစာနိမိတ်များ ပေါ်ထွန်းမလော။ ငါလို့အား မိန့်ပါ” ဟု ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ယေရှုဟ “နင်လို့အား စသူမျှ မလှည့်စားစေရန် သတိပြုလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","အကျောန်းမှာ ရမ်းဆာ့သော လူလို့ဟ ငါ့ရဲ့နာမဟို ခံယူသုံးစွဲယွေ့ ရောက်လာကာ ‘ငါဟ မေဆှိယ ဖြစ်အယ်’ ဟု ပြောပင်း လူများလို့ဟို ဝါကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","နင်လို့ဟ စစ်ပွဲများအကျောန်းနဲ့ စစ်မက်သတင်းများဟို ကြားကြပေမဲ့ သတိပြုလျက် မထိတ်လန့်ကြနဲ့။ ဟေအမှုအရာများဟ ဖြစ်ပျက်ရပေမဲ့ ကပ်ကမ္ဘာကုန်ဆုံးချိန်ဟ မရောက်သေး။ ");
INSERT INTO dnv_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","လူမျိုးတမျိုးနဲ့ တမျိုး၊ တနိုင်ငံနဲ့ တနိုင်ငံ စစ်ဖြစ်ယွေ့ နေရာအနှံ့တွင် အစာခေါင်းပါးပင်း မြေငလျင်လှုပ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ဟေအမှုအားလုံးလို့ဟ လူပဲ့မွေးခြင်း ဝေဒနာရဲ့အစလိုမျိုး ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“အေးနောက် လူတို့ဟ နင်လို့ဟို နှိပ်စက်ရန် အပ်နှံယွေ့ သတ်ဖြတ်ကြပင်း နင်လို့ဟ ငါရဲ့နာမကျောန့် လူမျိုးအပေါင်းလို့ဟ နင်လို့ဟို မုန်းကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","အေးကာလနှိုက် ရမ်းဆာ့သောလူလို့ဟ ယုံကြည်ခြင်း လမ်းလွဲကြလျက် အချင်းချင်း တယောက်ဟိုတယောက် မုန်းပင်း သစ္စာဖောက်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ရမ်းဆာ့သော ပရောဖက်အတုအယောင်လို့ဟ ပေါ်လာပင်း လူများစွာလို့ဟို ဝါကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","မတရားအမှုလို့ဟ များပြားသောကျောန့် လူတို့တွင် ချစ်ခြင်းမေတ္တာ ခေါင်းပါးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","အဲလိုလဲ အဆုံးတိုင်အောန် တည်ကြည်သူဟ ကယ်တင်ခြင်း ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","နိုင်ငံတော်နဲ့ဆိုင်လဲ့ သတင်းကောင်း အကျောန်းဟို ကမ္ဘာတဝန်းလုံးဆိ လူမျိုးအပေါင်းလို့အား သက်သေခံ ဟောပြောပင်းမှ ကပ်ကမ္ဘာကုန်ဆုံးချိန် ရောက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ပရောဖက် ဒံယေလ ဟောကြားခဲ့လဲ့ ‘ထိတ်လန့် ဆက်ဆုပ်ဖွယ်ကောင်းလဲ့အရာ’ ဟ သန့်ဆှင်းသော အရပ်နှိုက်နေတာဟို နင်လို့ မျော်ရလိမ့်မယ်။” (စာဖတ်သူဟ ဆိုလိုရင်း အဓိပ္ပာယ်ဟို နားလည်ပါစေ။) ");
INSERT INTO dnv_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“အေးနောက် ယုဒပြေဆိသော လူတို့ဟ တောင်များပေါ်သို့ ပြေးကြစေ။ ");
INSERT INTO dnv_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","နေအိုင်မိုးပေါ်တွင် ဆိသူဟ အိုင်ထဲမှ ဥစ္စာပစ္စည်းများဟို ယူရန် အောက်ဟို မဆင်းစေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","လယ်ထဲတွင် ဆိသူဟလည်း ဝတ်လုံယူရန် နေအိုင်ဟို မပြန်စေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","အေးနေ့ရက်နှိုက် ဖိုက်ကျီးသည်နဲ့ လူပဲ့ငယ်မေ့လို့ အတွက် အကျိုးနည်း ပေတော့မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","နင်လို့ဟ ထွက်ပြေးရမယ့် အချိန်ကာလဟ ဆောင်းရာသီ အဲဟာမဟုတ်ရင် ဥပုသ်နေ့လို့ မကျရောက်စေရန် ဘုရားသခင်ဆေ ဆုတောင်းကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","အကျောန်းမှာ ရမ်းဆာ့သော ဆင်းရဲဒုက္ခကျရောက် လာလိမ့်မယ်။ အေးမျှဆိုးရွားသော ဆင်းရဲဒုက္ခမျိူးဟို ကမ္ဘာဦးမှစယွေ့ ပစာကာလနှိုက်မျှ လူတို့ မကြုံစဖူး၊ နောင်ကာလနှိုက်လည်း တွေ့ကြုံရကြမယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","အေးနေ့ရက်ကာလဟို တိုစေတော်မမူရင် စသူမျှ အသက်ဘေးမှ ကင်းလွတ်နိန်လိမ့်မယ် မဟုတ်။ အကျောန်းမှာ မိမိရွေးချယ်ထားသော သူများအဖို့အလို့ငှာ အေးနေ့ရက်ကာလဟို တိုစေလိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“အေးအချိန်နှိုက် တစုံတယောက်ဟ ‘ကျေ့လော့၊ ဟေအရပ်တွင် မေဆှိယ ဆိအယ်’ အဲဟာမဟုတ်ရင် ‘အေးအရပ်တွင် ဆိအယ်’ ဟု ဆိုလျှင် — မယုံကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","အကျောန်းမှာ မေဆှိယ အတုယောင်များနဲ့ ပရောဖက်အတု အယောင်များ ပေါ်ပေါက်လာပင်း ဖြစ်နိန်ပါက ရွေးချယ်ထားသော သူများဟိုပင် ဝါနိန်ရန် ကြီးမားသော နိမိတ်လက္ခဏာများနဲ့ အံ့ဩဖွယ်သောအရာများဟို ပြကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","နားထောင်ကြလော့၊ ဟေအရာများ နင်လို့အား ကြိုတင်ယွေ့ ငါဖော်ပြပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“အဲလိုမို့ လူတို့ဟ ‘ကျေ့လော့၊ ကိုယ်တော်ဟ တောကန္တာရတွင် ဆိအယ်’ ဟု ဆိုလျှင် မသွားကြနဲ့ အဲဟာမဟုတ်ရင် ‘ကျေ့လော့၊ အိပ်ခန်းထဲမှာ ဆိအယ်’ ဟု ဆိုလျှင်လည်း မယုံကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","အကျောန်းမှာ ဆှပ်စီးလက်ယွေ့ အဆေ့အရပ်မှ အနောက်အရပ် တိုင်အောန် ခေါန်းခင်တပြင်လုံး ထွန်းလင်းစေသလိုမျိုး လူသား ကြွလာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“လူသေကောင်ဆိရာ အရပ်တွင် လင်းတတို့ စုရုံးကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“အေးနေ့ရက်ရဲ့ ဆင်းရဲဒုက္ခများ ကျရောက်လာပင်းနောက် ခုတုံးပင် နေဟ မိုက်သွားလိမ့်မယ်။ လဟ အလင်းရောင်ပေးလိမ့်မယ် မဟုတ်၊ ကြယ်များဟလည်း ခေါန်းခင်မှ ကြွေလိမ့်မယ်။ ခေါန်းခင်လည်း တုန်လှုပ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","အဲပင်းရင် လူသားရဲ့ နိမိတ်လက္ခဏာဟ မိုးခေါန်းခင်တွင် ပေါ်ထွန်းလာလိမ့်မယ်။ မိုးချေးသားဟိုစီးလျက် ကြီးသောဘုန်းတန်ခိုးတော်ဖြင့် လူသားကြွလာတာဟို မြေကြီးပေါ်ဆိ လူအပေါင်းလို့ဟ မျော်ကြသောအခါ ငိုကြွေးမြည်တမ်း ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","အေးနောက် လူသားဟ ကြီးမားသော တံပိုးခရာသံနဲ့အတူ မိမိရဲ့ခေါန်းခင်တမန်များအား အရပ်လေးမျက်နှာဟို စေလွတ်ယွေ့ ကမ္ဘာမြေကြီးတစွန်းမှ တစွန်းအထိဆိကြသော ကိုယ်တော် ရွေးချယ်ထားသော သူလို့ဟို စုသိမ်းစေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“သင်္ဘောသဖန်းပင်မှ ပုံဥပမာဟို သင်ယူကြလော့။ အေးအပင်တွင် အကိုင်းအညှောက်ထွက်ယွေ့ အရွက်ပေါက်သောအခါ နွေကာလ ရောက်ခါနီးဟို နင်လို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","အေးနည်းတူစွာ နင်လို့ဟလည်း အဲအရာများ မျော်သောအခါ လူသားဟ နင်လို့အနီး ထင်ခါးဝသို့ပင် ရောက်ဆိနေပီ ဟု သိမှတ်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","နင်လို့အား ငါ အမန်အကန် ပြောတာဟ ဟေအမှုအရာ အားလုံး မဖြစ်ပျက်မီတိုင်အောန် ဟေမျိုးဆက်ဟ ပစာအခါမှ ပျောက်ကွယ်လိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ခေါန်းခင်နဲ့ မြေကြီး ပျောက်ကွယ်သွားပေမဲ့ ငါ့ရဲ့ စကားဟ ပစာအခါမှ ပျောက်ကွယ်လိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“အဲလိုလဲ အေးအချိန် အဲဟာမဟုတ်ရင် နာရီနဲ့ ပတ်သက်ယွေ့ ခမည်းတော်မှတပါး စသူမှမသိ၊ ခေါန်းခင်ဘုံဆိ ခေါန်းခင်တမန်များလည်း မသိ၊ သားတော်လည်း မသိ။ ");
INSERT INTO dnv_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","နောဧ လက်ထပ်ဟ ဖြစ်ပျက်သလိုမျိုး လူသား ကြွလာသောအခါနှိုက်လည်း ဖြစ်ပျက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","အေးနေ့ရက်ကာလနှိုက် ယေမလွမ်းမိုးခင်၊ သင်္ဘောထဲဟို နောဧ ဝင်သည့်နေ့တိုင်အောန် လူတို့ဟ စားသောက်လျက် ထိမ်းမြားစုံဖက်လျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","သူလို့ဟ ယေလွမ်းမိုးယွေ့ သေကြေပျက်စီးကြသည့် အချိန်တိုင်အောန် သတိမဲ့လျက်နေကြအယ်။ လူသား ကြွလာချိန်နှိုက်လည်း အေးတိုင်းတိုင်း ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","အေးအချိန်နှိုက် လယ်ထဲတွင် ဆိသူ လူနေယောက်အနက် တယောက်ဟို သိမ်းယွေ့ တယောက်ဟို ထားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ကြိတ်ဆုံလှည့်နေသူ မိန်းမနေယောက်အနက် တယောက်ဟို သိမ်းယူယွေ့ တယောက်ဟို ထားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","သို့ဖြစ်ယွေ့ သတိနဲ့စောင့်နေကြလော့၊ ပစာကို့ နင်လို့ရဲ့ အဆှင်ဟ ပစာအခါ ကြွလာမယ်ဟို နင်လို့ မသိကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","အိုင်ဆှင်ဟ သူခိုးလာမယ့် အချိန်ဟိုသာ သိရရင် သတိနဲ့နေလျက် မိမိနေအိုင်ဟို သူခိုးဖောက်ခွင့်ပြုမယ် မဟုတ်ကျောန်း နင်လို့ သိမှတ်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","အဲလိုမို့ လူသားဟ နင်လို့ မထင်မှတ်သော အချိန်နှိုက် ကြွလာမယ် ဖြစ်ယွေ့ နင်လို့ဟလည်း အဆင့်သင့်ဆိနေကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“သစ္စာဆိပင်း ပညာဆိသော ကျွန်ဟ စသူလုန်း၊ အေးသူဟ တခြား ကျွန်များဟို အုပ်ချုပ်ရန်နဲ့ အချိန်တန်လျှင် ရိက္ခာများထုတ်ပေးရန် သခင်ဟ ခန့်ထားသူဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ကျွန်ဟ မိမိတာဝန်ဟို သစ္စာဆိစွာဆောင်ရွက်နေတာဟို သခင်အိုင် ပြန်လာချိန်နှိုက် တွေ့ရင် မင်္ဂလာဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","နင်လို့အား ငါ အမန်အကန် ပြောတာဟ သခင်သည် မိမိဥစ္စာဆိသမျှဟို စီမံအုပ်ချုပ်ရန် အေးကျွန်အား အပ်နှင်းလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","အဲလိုလဲ အေးကျွန်ဟ ကျွန်မိုက်ဖြစ်ပါဟ ‘ငါ့သခင်ပြန်လာအုံးမှာ မဟုတ်၊ ကြာအုံးမယ်’ ဟု စိတ်နေလုံးနှိုက် အောက်မေ့ကာ၊ ");
INSERT INTO dnv_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ကျွန်ချင်းလို့အား ရိုက်နှက်လျက် သေရည်သောက်ကြူးသူလို့နဲ့ သောက်စားမူးယဇ်လျက် နေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","အေးနောက် အေးကျွန် မမျော်လင့်သောနေ့၊ မသိမျော်လဲ့ အချိန်နှိုက် သူ့သခင်ပြန်လာယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","သူ့ဟို ပြင်းစွာ ကြိမ်ဒဏ်ခတ်ယွေ့ သူတော်ကောင်းဟန်ဆောင်သူလို့ခံရသော ကံကြမ္မာဆိုးဟို ခံစေလိမ့်မယ်။ သူဟ ငိုကမြည်တမ်းယွေ့ အံသွားခဲကြိတ်လျက် နေရလိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“အေးကာလနှိုက် ခေါန်းခင်နိုင်ငံတော်ဟ မီးဖူးများဟို ယူယွေ့ မင်္ဂလာဆောင်သတို့သားဟို ကြိုဆိုရန် ထွက်သွားလဲ့ အပျိုကညာဆယ်ယောက်လို့နဲ့ တူလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","သူလို့အနက် ငါးယောက်ဟ ပညာဆိဖြစ်ကြပင်း ငါးယောက်မှာတော့ ပညာမဲ့ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ပညာမဲ့သော သူလို့ဟ မိမိလို့ရဲ့ မီးဖူးများဟို ယူခဲ့သော်လည်း မိမိလို့နဲ့အတူ ဆီပိုဟို မယူခဲ့ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ပညာဆိသူများဟတော့ မိမိလို့ရဲ့ မီးဖူးများမက ဆီအပိုဟိုလည်း ဖူးတွင် ထည့်ပင်း ယူခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","မင်္ဂလာဆောင်သတို့သားဟ ရောက်လာရန် ကြန့်ကြာနေသောကျောန့် သူလို့အားလုံး ငိန်းကျာ့ယွေ့ အိပ်မွေ့နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ညဉ့်သန်းခေါင်နှိုက် ‘မင်္ဂလာဆောင်သတို့သား ရောက်လာပီ၊ သွားပင်း ကြိုဆိုကြလော့’ ဟူသော အော်သံဟို ကြားရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","အပျိုကညာ အားလုံးတို့ဟ ထယွေ့ မိမိရဲ့မီးဖူးများဟို အသင့်ပြင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","အဲပင်းရင် ပညာမဲ့သောသူများဟ ‘ငါလို့ မီးဖူး သေတော့မယ်ဖြစ်ယွေ့ ငါလို့ဟို ဆီကတီလောက်ပေးပါ’ ဟု ပညာဆိသူလို့ဆေ တောင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ပညာဆိသူများဟလည်း ‘နင်လို့ အဖို့နဲ့ ငါလို့ အဖို့ ဆီမလောက်ပါ။ သွားယွေ့ နင်လို့အတွက် ဝယ်ကြပါ’ ဟု ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","အဲလိုမို့ ပညာမဲ့သောသူလို့ ဆီဝယ်ရန် ထွက်သွားနေခိုက် မင်္ဂလာဆောင်သတို့သားဟ ရောက်လာအယ်။ အသင့်ဆိနေကြသော အပျိုကညာလို့ဟလည်း သူနဲ့အတူ မင်္ဂလာဆောင်ပွဲဟို ဝင်ပင်းရင် ထင်ခါးဟို ပိတ်ထားလိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“အခြားသော အပျိုကညာများဟ ပြန်ရောက်လာပင်း ‘ဆရာ၊ ဆရာ ငါလို့အား ထင်ခါးဖွင့်ပေးမန့်’ ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","အဲလိုလဲ မင်္ဂလာဆောင်သတို့သားဟ ‘နင်လို့အား ငါ အမန်အကန် ပြောတာဟ နင်လို့ဟို ငါမသိ’ ဟု ပြန်ပြောအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“သို့ဖြစ်ယွေ့ နင်လို့ဟလည်း အေးနေ့အေးအချိန်ဟို မသိကြသဖြင့် သတိနဲ့စောင့်နေကြလော့” ဟု ယေရှုဟ အဆုံးသတ် ပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ခေါန်းခင်နိုင်ငံတော်ဟ ခရီးပြုရန် မိမိနေအိုင်မှ ထွက်ခါနီးဆိသူဟ မိမိရဲ့ အစေခံများဟို ခေါ်ပင်း ဥစ္စာပစ္စည်းများဟို အပ်နှံခဲ့တာနဲ့တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","သူဟ သူလို့အသီးသီးလို့အား သူလို့အရည်အချင်းနဲ့အညီ တယောက်ဟို ငွေဒင်္ဂါး ငါးပိဿာ၊ တခြားတယောက်ဟို နေပိဿာ၊ အခြားတယောက်ဟို ငွေဒင်္ဂါး တပိဿာ အစဆိသဖြင့် ပေးအပ်ပင်းနောက် ခရီးဟို ထွက်ခွာလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ငွေဒင်္ဂါး ငါးပိဿာရသူဟ ခုတုံးပင် သွားယွေ့ အဲပိတ်ဆန်များဖြင့် ကူးသန်းရောင်းဝယ်မှုဟို လုပ်သဖြင့် အမြတ် ငွေဒင်္ဂါး ငါးပိဿာဟို ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","အေးတိုင်းတိုင်း ငွေဒင်္ဂါး နေပိဿာဟို ရသူဟလည်း အမြတ် ငွေဒင်္ဂါး နေပိဿာဟို ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","အဲလိုလဲ ငွေဒင်္ဂါး တပိဿာ ရသူဟ သွားယွေ့ မိမိသခင်ရဲ့ ပိတ်ဆန်ဟို မြေကြီးနှိုက် ကျွင်းတူးကာ မြှပ်ထားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ကာလအတော်ကြာသော် အေးကျွန်လို့ရဲ့ သခင်ဟ ပြန်လာယွေ့ သူလို့နဲ့ စာရင်းဆှင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ငွေဒင်္ဂါး ငါးပိဿာ ရသူဟ အပိုငွေဒင်္ဂါး ငါးပိဿာဟို ယူဆောင်လာပင်းရင် ‘ဆရာ၊ ငါ့အား ငွေဒင်္ဂါး ငါးပိဿာ ပေးအပ်ခဲ့ပါအယ်။ ကျေ့ပါ၊ ငါ ငွေဒင်္ဂါး ငါးပိဿာ အမြတ်ရပါပီ။’ ");
INSERT INTO dnv_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","သူရဲ့သခင်ဟလည်း ‘ကောင်းလေစွ၊ သစ္စာဆိသော ငါ့အစေခံကောင်း၊ နင်ဟ သေးသောအမှုတွင် သစ္စာဆိအယ်။ အဲလိုမို့ ကြီးသောအမှုဟို နင့်အား ငါအပ်နှင်းမယ်။ ငါရဲ့ဝမ်းမြောက်ခြင်းနှိုက် ပါဝင်ပါလော့’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ဆွေနေပိဿာ ရသူဟလည်း လာယွေ့ ‘ဆရာ၊ ငါ့အား ငွေဒင်္ဂါး နေပိဿာဟို ပေးအပ်ခဲ့ပါအယ်။ ကျေ့မန့်၊ ငါဟ ငွေဒင်္ဂါး နေပိဿာဟို အမြတ်ရပါပီ’ ဟု ဆှောက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","သူရဲ့သခင်ဟ ‘ကောင်းလေစွ၊ သစ္စာဆိသော ငါ့အစေခံကောင်း၊ နင်ဟ သေးငယ်သောအမှုတွင် သစ္စာဆိအယ်၊ အဲလိုမို့ ကြီးသောအမှုဟို နင့်အား ငါအပ်နှင်းမယ်၊ ငါရဲ့ဝမ်းမြောက်ခြင်းနှိုက် ပါဝင်ပါလော့’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","အဲပင်းရင် ငွေဒင်္ဂါး တပိဿာရသူဟ လာယွေ့ ‘ဆရာ၊ ဆရာဟ ခက်ထန်သူဖြစ်ယွေ့ မိမိမစိုက်မပျိုးလဲ့အရပ်တွင် ရိတ်သိမ်းပင်း မိမိမကြဲဖြန့်လဲ့ နေရာမှ စုသိမ်းတတ်လဲ့သူ ဖြစ်ကျောန်း ငါသိပါအယ်။ မကြဲဖြန့်လဲ့အရပ်တွင် စုသိမ်းတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","အဲလိုမို့ ငါဟ ကြောက်ရွံ့သဖြင့် သွားပင်း ဆရာရဲ့ ငွေဒင်္ဂါးဟို မြေတွင် မြှုပ်ထားခဲ့အယ်။ ကျေ့မန့်၊ သခင်ရဲ့ ပစ္စည်းဟေမှာ ဆိအယ်’ ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","သူရဲ့သခင်ဟလည်း ‘ဆိုးညစ်လဲ့ ပျင်းရိသောအစေခံ၊ ငါဟ မိမိမစိုက်မပျိုးလဲ့ အရပ်တွင် ရိတ်သိမ်းယွေ့ မကြဲမဖြန့်သည့်အရပ်တွင် စုသိမ်းတတ်တာဟို နင်သိတာမန်ရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ငါရဲ့ ပိတ်ဆန်ဟို ဘဏ်တွင် အပ်ထားသင့်အယ်။ သို့မှသာလျှင် ငါပြန်လာသောအခါ အတိုးနဲ့အတူ ပြန်လည်ရဆိနိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","အဲလိုမို့ အေးသူဆေမှ ငွေဒင်္ဂါး တပိဿာဟို ယူယွေ့ ဆယ်ပိဿာဆိသူအား ပေးကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","အကျောန်းမှာ ဆိသောသူအား ထပ်ယွေ့ ပေးသဖြင့် သူဟ ကြွယ်ဝပြေ့စုံ နေလိမ့်မယ်။ မဆိသောသူဆေမှ သူနှိုက်ဆိသော အရာဟိုပင် နုတ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","အသုံးမကျလဲ့ ဟေအစေခံဟို အပြင်မိုက်ထဲဟို ထုတ်လိုက်ကြ၊ သူဟ အေးအရပ်တွင် ငိုကမြည်တမ်းယွေ့ အံသွားခဲကြိတ်လျက် နေရလိမ့်မယ်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“လူသားဟ ခေါန်းခင်တမန် အပေါင်းခြံရံလျက် ဘုရင်အဖြစ် ကြွလာသောအခါ ဘုန်းဆိသော ပလ္လင်ပေါ်နှိုက် ထိန်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","လူမျိုးအပေါင်းလို့ဟ ဆေ့တော်တွင် စုရုံးရကြပင်း သိုးထိန်းဟ သိုးနဲ့ ဆိတ်လို့ဟို တခြားစီခွဲထုတ်သလို လူသားဟလည်း လူလို့အား နေစုခွဲထုတ်ပင်းရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","သိုးများဟို မိမိရဲ့ လက်ယာဘက်နှိုက် ထားယွေ့ ဆိတ်များဟို လက်ဝဲဘက်တွင် ထားလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","အေးနောက် ဘုရင်ဟ လက်ယာဘက်တွင် ဆိသောသူလို့အား ‘ငါ့အဖဆေမှ ကောင်းချီးမင်္ဂလာဟို ခံရသူလို့ လောကဟို ဖန်ဆင်းချိန်မှစယွေ့ နင်လို့တွက် ပြင်ဆင်ထားလဲ့ နိုင်ငံတော်ဟို လာယွေ့ အမွေဆက်ခံကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","အကျောန်းမှာ နင်လို့ဟ ငါမွတ်စဉ်အခါ ငါ့ဟို စားစရာပေးကြအယ်၊ ငါယေငတ်သောအခါ ငါ့ဟို သောက်စရာ ပေးကြအယ်။ ငါဟ ဧည့်သည်ဖြစ်သောအခါ နင်လို့ဟ ငါ့ဟို ကြိုဆိုလက်ခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ငါဟ အဝတ်ဝတ်စရာမဆိသောအခါ နင်လို့ဟ ငါ့ဟို အဝတ်ပေးကြအယ်။ ငါဖျားနာသောအခါ နင်လို့ဟ ငါ့ဟို ကျေ့ရှုကြအယ်။ ငါထောင်ကျသောအခါ ငါ့ဆေဟို လာကြအယ်’ ဟု မိန့်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","အေးအခါ ဖြောင့်မတ်သောသူလို့ဟ ‘သခင်ဘုရား၊ ကိုယ်တော် မွတ်တာဟို ပစာအခါနှိုက် မျော်ယွေ့ ငါလို့ ကျွေးမွေးကြလုန်း အဲဟာမဟုတ်ရင် ယေငတ်တာဟို ပစာအခါနှိုက် မျော်ယွေ့ ယေဟို ပေးလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ဧည့်သည်ဖြစ်တာဟို ပစာအခါနှိုက် မျော်ယွေ့ ငါလို့ ကြိုဆိုလက်ခံခဲ့ကြလုန်း အဲဟာမဟုတ်ရင် အဝတ်ဝတ်စရာ မဆိဖြစ်တာဟို ပစာအခါနှိုက် မျော်ယွေ့ အဝတ်ပေးလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ဖျားနာတာဟိုလည်းကောင်း၊ ထောင်ကျတာဟိုလည်းကောင်း ပစာအခါနှိုက် ငါလို့ဟ မျော်ယွေ့ အထံတော်ဟို လာခဲ့လုန်း’ ဟု ပြန်ယွေ့ဆှောက်ကြသော်၊ ");
INSERT INTO dnv_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ဘုရင်ဟ ‘နင်လို့အား ငါ အမန်အကန်ပြောတာဟ ငါရဲ့ညီများအနက် အသိမ်ငယ်ဆုံးဖြစ်သူ တယောက်အား နင်လို့ ပြုခဲ့သမျှဟ ငါ့အား ပြုခဲ့ခြင်းဖြစ်အယ်’ ဟု မိန့်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“အေးနောက် ဘုရင်ဟ လက်ဝဲဘက်နှိုက်ဆိသော သူလို့အား ‘ကျိန်ဆဲခြင်း ခံရသောသူလို့ ငါ့ဆေမှ ထွက်သွားကြလော့၊ မာရ်နတ်နဲ့ သူ့ခေါန်းခင်တမန်များအတွက် ပြင်ဆင်ထားလဲ့ ထာဝရမီးထဲဟို ဆင်းသက်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","အကျောန်းမှာ ငါမွတ်သောအခါ နင်လို့ဟ ငါ့ဟို စားစရာမပေးကြ၊ ငါ ယေငတ်သောအခါ နင်လို့ဟ ငါ့ဟို သောက်စရာဟို မပေးကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ငါဟ ဧည့်သည်ဖြစ်သောအခါ နင်လို့ဟ ငါ့ဟို ကြိုဆိုလက်ခံခြင်း မဆိ၊ ငါဟ အဝတ်ဝတ်စရာ မဆိဖြစ်သောအခါ နင်လို့ဟ ငါ့ဟို ဝတ်စရာအဝတ်ဟို မပေးကြ၊ ငါဟ ဖျားနာသောအခါနဲ့ ထောင်ကျသောအခါတွင်လည်း နင်လို့ဟ ငါ့ဟို မကျေ့ရှုကြ’ ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","အေးသူလို့ ‘သခင်ဘုရား၊ ကိုယ်တော် ဆာလောင်မွတ်သိပ်ခြင်း၊ ယေငတ်ခြင်း၊ ဧည့်သည် ဖြစ်ခြင်း၊ အဝတ်အချည်းစည်း ဖြစ်ခြင်း၊ ဖျားနာခြင်း၊ ထောင်ကျခြင်းလို့ဟို ပစာအခါနှိုက် ငါလို့ မျော်ပါလျက် ကိုယ်တော်အား မပြုစုမလုပ်ကျွေးပဲ နေခဲ့လုန်း’ ဟု ဆှောက်ထားကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ဘုရင်ဟ ‘နင်လို့အား ငါ အမန်အကန် ပြောတာဟ သိမ်ငယ်သည့် ဟေသူများအနက် တစုံတယောက်သောသူဟို နင်တို့ မပြုမစုဘဲနေခဲ့သမျှဟ ငါ့ဟို မပြုမစုဘဲ နေခဲ့ခြင်းဖြစ်အယ်’ ဟု မိန့်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","အေးကျောန့် အေးသူလို့ဟ ထာဝရအပစ်ဒဏ် ခံရကြပေမဲ့ ဖြောင့်မတ်သောလို့ဟတော့ ထာဝရ အသက်ဆှင်ခြင်းဟို ဝင်စားရကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ယေရှုဟ ဟေသို့ ဟောပြောသွန်သင်ပင်းသောအခါ ကိုယ်တော်ဟ တဘဲ့တော်လို့အား ");
INSERT INTO dnv_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“နောက် နေရက်ကြာရင် ပသခါပွဲကျရောက်မယ်ဟို နင်လို့ သိကြအယ်။ အေးအခါ လူသားဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်စေရန် ရန်သူ့လက်ဟို အပ်ကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","အေးအချိန်နှိုက်ပင် ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အသက်ကြီးသူလို့ဟ ကယာဖ နာမယ်ဆိသော ယဇ်ပုရောဟိတ်မင်းရဲ့ အိုင်ဝင်းအထဲမှာ စုရုံးလျက် နေကြပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","သူလို့ဟ ယေရှုဟို တိတ်တိတ်လေး ဖမ်းဆီးယွေ့ သတ်ရန် ဆွေးနွေး တိုင်ပင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","အဲလိုလဲ သူလို့ဟ “လူလို့ ရုန်းရင်းဆန်ခတ်ဖြစ်မယ်ဟို စိုးရိမ်စရာဆိသဖြင့် ပွဲတော်ရက်အတွင်းနှိုက် မဖမ်းဆီးကြနဲ့” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ယေရှုဟ ဗေသနိရွာတွင် အရေပြားရောဂါ စွဲကပ်ခဲ့ဖူးသူ ရှိမုန်ရဲ့ နေအိုင်နှိုက် ဆိနေစဉ်၊ ");
INSERT INTO dnv_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ယေရှုဟ အစားအစာသုံးဆောင်လျက် နေသောအခါ အမျိုးသမီးတယောက်ဟ ရမ်းဆာ့အဖိုးကြီးသော ဆီမွှေးကျောက်ဖြူဖူးဟို ယူဆောင်ယွေ့ အထံတော်ဟို လာပင်းရင် အေးဆီမွှေးဟို ကိုယ်တော်ရဲ့ ခေါင်းပေါ် သွင်းချလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","အေးအရာဟို တဘဲ့တော်လို့မျော်ရင် အူထော့ယွေ့ “ပစာကျောန့် ဟေသို့ ဖြုန်းတီးလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ဟေဆီမွှေးဟို ပိတ်ဆန်အများနဲ့ ရောင်းပင်း ဆင်းရဲသူများဟို ပေးကမ်းသင့်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ယေရှုဟ သူလို့ ပစာပြောနေတာဟို သိပင်း “ပစာကျောန့် ဟေအမျိုးသမီးဟို နင်လို့ နှောင့်ယှက်ကြလုန်း။ သူပြုသောအမှုဟ ရမ်းဆာ့ ဆှောက်ပတ်ပေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ဆင်းရဲသူများဟ နင်လို့နဲ့အမြဲ ဆိနေကြပေမဲ့ ငါဟတော့ နင်လို့နဲ့ အမြဲဆိနေမယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ဟေအမျိုးသမီးဟ ငါ့အပေါ်ဟို ဆီမွှေးလောင်းတာဟ ငါရဲ့ရုပ်အလောင်းဟို သင်္ဂြိုဟ်ရန် ပြင်ဆင်ခြင်းပင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","နင်လို့အား ငါ အမန်အကန် ပြောတာဟ သတင်းကောင်းဟို ကမ္ဘာအရပ်ရပ်တွင် ကြေညာသောအခါ ဟေအမျိုးသမီးဟို အောက်မေ့သတိရကြစေရန် သူပြုခဲ့သော ကောင်းမှုဟို ဟောကြားကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","အေးနောက် တဆယ့်နေပါးထဲမှ တပါးဖြစ်သော ယုဒရှကာရုတ်ဟ ယဇ်ပုရောဟိတ်ကြီးများ ဆေဟို သွားပင်း ");
INSERT INTO dnv_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ယေရှုဟို နင်လို့လက်ဟို ငါအပ်ရင် နင်လို့ဟ ငါ့အား ပစာပေးမလုန်း” ဟု မေးအယ်။ အေးသူလို့ဟလည်း သူ့အား ငွေဒင်္ဂါးသုံးဆယ် ပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","အေးအချိန်မှစယွေ့ ယုဒဟ ယေရှုအား ရန်သူ့လက်ဟို အပ်ရန် အခွင့်ကောင်း ဆာလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","တဆေးမဲ့မုန့်ပွဲတော် ပထမနေ့နှိုက် တဘဲ့တော်လို့ဟ ယေရှုဆေဟို လာယွေ့ “ကိုယ်တော်အတွက် ပသခါပွဲညစာဟို ငါလို့ ပစာအရပ်တွင် ပြင်ဆင်စေလိုလုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ကိုယ်တော်ဟ “မြို့ထဲဟို ဝင်ယွေ့ အေးသူဆေဟို သွားယွေ့ ဆရာဟ ‘ငါ့ရဲ့အချိန် နီးပီ၊ ငါ့တဘဲ့များနဲ့အတူ နင့်ရဲ့အိုင်တွင် ပသခါပွဲဟို ကျင်းပလိုအယ်’ ဟု မှာကြားလိုက်ကျောန်း ပြောကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","တဘဲ့တော်လို့ဟလည်း ယေရှုမိန့်လဲ့အတိုင်း လိုက်နာဆောင်ရွက်ယွေ့ ပသခါပွဲဟို အသင့်ပြင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ညနေခင်းချိန်ရောက်သောအခါ ကိုယ်တော်ဟ တဆယ့်နေပါးလို့နဲ့အတူ စားပွဲတွင် ညစာစားဖို့ အတူထိန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","သူလို့ဟ စားလျက်နေစဉ် ကိုယ်တော်ဟ “နင်လို့အား ငါ အမန်အကန် ပြောတာဟ နင်လို့ထဲမှတယောက်သည် ငါ့ဟို သစ္စာဖောက်လိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","တဘဲ့တော်လို့ဟ ရမ်းဆာ့ စိတ်မချမ်းမသာဖြစ်ကြလျက် စတင်ပင်း “သခင် ငါလော” ဟု တဦးပင်း တဦး မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ကိုယ်တော်ဟ “ငါနဲ့အတူ ပကန်တွင် နှိုက်ယွေ့ စားသောသူဟ ငါ့ဟို သစ္စာဖောက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ကျမ်းစာလာလဲ့အတိုင်း လူသားဟ အသေခံရန် သွားရပေမဲ့ လူသားဟို ရန်သူလက်သို့ အပ်သောသူဟ အမင်္ဂလာဆိအယ်။ မွေးဖွားခြင်းဟို မခံရရင် သူအဖို့ ကောင်းသေးအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","အဲပင်းရင် ကိုယ်တော်ဟို ရန်သူလက်သို့ အပ်မယ့်သူ ယုဒဟ “ဆရာ၊ ငါလော” ဟု မေးဆှောက်ရင် ကိုယ်တော်ဟ “နင်ပြောလဲ့အတိုင်းပင် မန်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ယေရှုဟ သူလို့ စားလျက်နေစဉ် မုန့်ဟို ယူယွေ့ ကျေးဇူးတော်ဟို ချီးမွန်းပင်း မုန့်ဟိုဖဲ့ယွေ့ “ဟေမုန့်ဟ ငါရဲ့ ခန္ဓာကိုယ် ဖြစ်အယ်၊ ယူယွေ့ စားကြလော့” ဟု မိန့်ပင်းရင် တဘဲ့တော်လို့အား ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","အဲပင်းရင် မုတ်ဟို ယူယွေ့ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟို ချီးမွန်းပင်းနောက် တဘဲ့တော်လို့အား ပေးအယ်။ ကိုယ်တော်ဟ “နင်လို့အားလုံး ဟေမုတ်ဟို သောက်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ဟေစာဟ ဘုရားသခင်ရဲ့ ပဋိညာဉ်တော်ဟို တံဆိပ်ခတ်သော လူတို့အပစ် ဖြေလွှတ်ရန်အတွက် သွန်းသော ငါရဲ့ အသွေးဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","နင်လို့အား ငါပြောတာဟ အခုအချိန်မှစယွေ့ ငါ့ခမည်းတော်ရဲ့ နိုင်ငံတော်တွင် နင်လို့နဲ့အတူ စပျစ်ယေသစ်ဟို သောက်ရလဲ့နေ့ မတိုင်မီ ငါဟ ဟေစပျစ်ယေဟို နောက်တဖန် မသောက်တော့ပီ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","အေးနောက် သူလို့ဟ ချီးမွန်း သီချင်းဆိုပင်းနောက် သံလွင်တောင်ဟို ထွက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","အေးနောက် ယေရှုဟ သူလို့အား “ကျမ်းစာထဲတွင် ‘ဘုရားသခင်ဟ သိုးထိန်းဟို သတ်သဖြင့် သိုးလို့ဟ ဖရိုဖရဲ ဖြစ်ကြလိမ့်မယ်’ ဟု ပြောထားသည်နဲ့အညီ ခုညနှိုက်ပင် နင်လို့ဟ ငါ့ဟို စွန့်ပစ်ယွေ့ ပြေးကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","အဲလိုလဲ ငါဟ သေခြင်းမှ ထမြောက်ပင်းနောက် နင်လို့ထက် ဦးရင် ဂါလိလဲပြေဟို သွားနှင့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ပေတရုဟ ယေရှုအား “အခြားသူအပေါင်းလို့ဟ ကိုယ်တော်ဟို စွန့်ပစ်ကြသော်လည်း ငါဟ ပစာအခါမျှ စွန့်ပစ်မယ် မဟုတ်ပါ” ဟု ဆှောက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ယေရှုဟ “နင်အား ငါ အမန်အကန် ပြောတာဟ အခုညနှိုက်ပင် ကြက်မတွန်ခင် နင်ဟ ငါ့ဟို မသိ ဟု သုံးကြိမ်တိုင်တိုင် ငြင်းဆိုလိမ့်မယ်” ဟု ပေတရုအား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ပေတရုဟ “ငါသည် ကိုယ်တော်နဲ့အတူပင် သေရရင် ကိုယ်တော်ဟို မငြင်းပါ” ဟု ဆှောက်ထားအယ်။ အခြားတဘဲ့တော်လို့ဟလည်း ဟေအတိုင်း ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","အေးနောက် ယေရှုဟ တဘဲ့တော်လို့နဲ့အတူ ဂေသရှေမန် ဟုခေါ်သော အရပ်ဟို ရောက်ဆိအယ်။ ကိုယ်တော်ဟ “ငါဟ အေးနေရာဟို သွားယွေ့ ဆုတောင်းနေစဉ် နင်လို့ ဟေနေရာတွင် ထိန်နေကြလော” ဟု တဘဲ့တော်လို့အား မိန့်ပင်းရင် ");
INSERT INTO dnv_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ပေတရုနဲ့ ဇေဗေဒဲရဲ့သားနေယောက်လို့ဟို ကိုယ်တော်နဲ့အတူ ခေါ်သွားအယ်။ ကိုယ်တော်ဟ စိတ်မချမ်းမသာဖြစ်လျက် ရမ်းဆာ့သောက ရောက်သဖြင့် ");
INSERT INTO dnv_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","“ငါဟ သေလုအောန် စိတ်နေလုံး ရမ်းဆာ့ညှိုးငယ်လှအယ်။ နင်လို့ဟ ဟေနေရာတွင် ငါနဲ့အတူ စောင့်နေကြလော့” ဟု သူလို့အား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","အေးနောက် ဆေ့ဟို ကတစ်လေးကြွယွေ့ မြေပေါ်တွင် ပျပ်ဝပ်ပင်းရင် “အို ငါ့ရဲ့အဖ၊ ဖြစ်နိန်ပါဟ ဟေဝေဒနာမုတ်ဟို ငါ့ဆေမှ လွဲဖယ်ပေးပါ။ အဲလိုလဲ ငါရဲ့ အလိုအတိုင်း မဟုတ်ပါ၊ ကိုယ်တော်ရဲ့ အလိုတော်အတိုင်းသာ ဖြစ်စေပါ” ဟု ဆုတောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","အေးနောက် ကိုယ်တော်ဟ တဘဲ့တော်လို့ဆေ ပြန်လာရာ အိပ်မွေ့လျက်နေကြတာဟို မျော်သဖြင့် “နင်လို့ဟ တနာရီမျှပင် ငါနဲ့အတူ စောင့်ယွေ့ မနေနိန်ကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","စုံစမ်းသွေးဆောင်ခြင်းဟို မကျရောက်စေရန် ဆုတောင်းယွေ့ စောင့်နေကြလော့၊ စိတ်ဝိညာဉ်ဟ ဆန္ဒဆိသော်လည်း ခန္ဓာကိုယ်ဟ အားနည်းအယ်” ဟု ပေတရုအား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","အေးနောက် ကိုယ်တော်ဟ ဒုတိယအကြိမ် ကြွသွားပြန်ယွေ့ “ငါရဲ့အဖ၊ ဟေဝေဒနာမုတ်ဟို ငါမသောက်ဘဲ လွဲသွားရန် မဖြစ်ပါဟ ကိုယ်တော်ရဲ့ အလိုတော်အတိုင်း ဖြစ်စေပါ” ဟု ဆုတောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ကိုယ်တော် နောက်တကြိမ် ပြန်လာသောအခါ တဘဲ့တော်လို့ဟ မျက်စေ့လေးလံသဖြင့် အိပ်မွေ့လျက်နေကြတာဟို မျော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ယေရှုဟ သူလို့ဆေမှ တဖန်ကြွသွားပင်းလျှင် မခင်ဟ မြွတ်ဆိုလဲ့အတိုင်း တတိယအကြိမ် ဆုတောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","အေးနောက် တဘဲ့တော်လို့ဆေဟို ပြန်လာယွေ့ “နင်လို့ဟ အိပ်မွေပင်း အနားယူနေကြသလော။ ကျေ့လော့၊ လူသားဟို အပစ်သား လက်သို့ အပ်နှံလဲ့အချိန် ရောက်လာပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ထကြ၊ ငါလို့သွားကြကုန်အံ့၊ ကျေ့လော့၊ ငါ့ဟို ရန်သူလက်ဟို အပ်မယ့်သူ ရောက်လာပီ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ကိုယ်တော် မိန့်စဉ်နှိုက်ပင်လျှင် တဆယ့်နေပါးအဝင်ဖြစ်သူ ယုဒရှကာရုတ်ဟ ရောက်လာအယ်။ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အသက်ကြီးသူများဟ စေလွှတ်လိုက်သော ရမ်းဆာ့သော လူအစုအဝေးလို့ဟလည်း တုတ်၊ ထားကိုင်ဆောင်လျက် သူနဲ့အတူပါလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ကိုယ်တော်ဟို ရန်သူလက်ဟို သစ္စာဖောက်သူဟ “ငါနမ်းသောသူသည် အေးသူပင် ဖြစ်အယ်။ သူ့ဟို ဖမ်းဆီးကြလော့” ဟု အမှတ်ပေးထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ယုဒဟ ခုတင်ချင်း ယေရှုဆေဟို ချဉ်းကပ်ကာ “ဆရာ၊ မင်္ဂလာဆိပါစေသော” ဟု ဆိုယွေ့ ကိုယ်တော်ဟို နမ်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ယေရှုဟ “မိတ်ဆွေ၊ နင်လာလဲ့ အကျောန်းကိစ္စဟို ဆောင်ရွက်လော့” ဟု မိန့်အယ်။ လူလို့ဟ လာယွေ့ ယေရှုဟို ဖမ်းဆီး ချုပ်ကိုင်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ယေရှုနဲ့ လိုက်ပါလာသော လူတယောက်ဟ ထားဟို ဆွဲထုတ်ပင်းရင် ယဇ်ပုရောဟိတ်မင်းရဲ့ ကျွန်တယောက်ဟို ခုတ်လိုက်ရာ အေးသူ နားရွက်ပြုတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ယေရှုဟ အေးသူအား “နင့်ရဲ့ ထားဟို ထားအိုင်ထဲဟို ပြန်ထည့်လော့ အကျောန်းမှာ ထားဟို ကိုင်သူဟ ထားဖြင့် သေကြေပျက်စီးရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ငါဟ ငါ့ခမည်းတော်ဆေမှ အကူအညီတောင်းခံရင် တဆယ်နေတပ်ထက် ရမ်းဆာ့သော ခေါန်းခင်တမန်လို့ဟို ခုတင်ချင်း ငါ့ဆေ စေလွှတ်မယ်ဟို နင်လို့ မသိကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","အဲလိုလဲ ဟေသို့ပြုပါမူ ကျမ်းစာလာလဲ့အတိုင်း ပစာသို့လျှင် ပြေ့စုံခြင်းဟို ရောက်နိန်လုန်း” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","အေးနောက် ယေရှုဟ လူအမြောက်အမြားလို့အား “နင်လို့ဟ ထားမြဟို ဖမ်းသလိုမျိုး ငါ့ဟိုဖမ်းရန် တုတ်များ ထားများနဲ့ လာကြသလော၊ ငါဟ နေ့စဉ်နေ့တိုင်း ဗိမာန်တော်တွင် ထိန်ယွေ့ ဟောပြောသွန်သင်နေစဉ်အခါ နင်လို့ဟ ငါ့ဟို မဖမ်းမဆီးခဲ့ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","အဲလိုလဲ ဟေအမှုအရာအားလုံး ဖြစ်ပျက်ရခြင်းမှာ ကျမ်းစာတော်တွင် ပရောဖက်များ ဟောကြားခဲ့သမျှအတိုင်း အမန်ဖြစ်လာစေရန် ဖြစ်သတည်း” ဟု မိန့်အယ်။ အေးအခါ တဘဲ့တော်အပေါင်းလို့ဟ ကိုယ်တော်ဟို စွန့်ပစ်ယွေ့ ပြေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ယေရှုဟို ဖမ်းဆီးကြသော သူလို့ဟ ယဇ်ပုရောဟိတ်မင်း ကယာဖရဲ့ အိုင်ဟို ခေါ်ဆောင်သွားကြအယ်။ ကျမ်းတတ်ဆရာများနဲ့ အသက်ကြီးသူများဟ အေးအရပ်တွင် စုရုံးလျက်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ပေတရုဟ ခပ်ခွာခွာဟ နေယွေ့ ယဇ်ပုရောဟိတ်မင်းရဲ့ အိုင်ဝင်းတိုင်အောန် ကိုယ်တော်ရဲ့ နောက်ကလိုက်လာခဲ့ကြအယ်။ ဝင်းထဲဟိုဝင်ယွေ့ ပစာသို့ဖြစ်မယ်ဟို သိဆိနိန်ရန် ယဇ်ပုရောဟိတ်ရဲ့ ကိုယ်ရံတော်တပ်သားများ နဲ့အတူ ထိန်လျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ယဇ်ပုရောဟိတ်ကြီးများနဲ့ တကွ တရားလွှတ်တော် အဖွဲ့ဝင်အပေါင်းလို့ဟ ယေရှုအား သေဒဏ်ပေးနိန်ရန် ကစတ်ကလတ်သော သက်သေဟို ဆာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","မမန်သောသက်သေခံသူများစွာ လာကြပေမဲ့ သူလို့ဟ စလို သက်သေဟိုမှ မတွေ့ကြ။ နောက်ဆုံးနှိုက် လူနေယောက်ဟ ဆေ့ဟို ထွက်လာပင်းရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ဟေသူဟ ‘ငါသည် ဘုရားသခင်ရဲ့ဗိမာန်တော်ဟို ဖြိုဖျက်ယွေ့ သုံးရက်အတွင်း ပြန်လည်ဆောက်နိန်အယ်’ ဟု ဟောအယ်” ဟူယွေ့ သက်သေခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ယဇ်ပုရောဟိတ်မင်းဟ နေရာမှထယွေ့ “နင့်အား အေးသူလို့ စလိုစွပ်စွဲ ထွက်ဆိုကြလုန်း နင့်မှာ စလိုမျှ ဖြေစရာမဆိပါသလော” ဟု ယေရှုအား မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","အဲလိုလဲ ယေရှုဟ ဆိတ်ဆိတ်နေအယ်။ ယဇ်ပုရောဟိတ်မင်းဟ “နင်သည် ဘုရားသခင်ရဲ့သားတော် မေဆှိယလော၊ ငါ့အား ဖြေကြားလော၊ အသက်ဆှင်သော ဘုရားသခင်ရဲ့နာမဟို တိုင်တည်ယွေ့ နင့်အား ငါမေးအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ယေရှုဟ “နင်ဟောသည် အတိုင်းမန်ပေမဲ့ နင်လို့အား ငါပြောတာဟ နောင်အခါတွင် လူသားဟ အနတ္တတန်ခိုးဆှင်ရဲ့ လက်ယာဘက်တွင် ထိန်လျက်နေတာဟိုလည်းကောင်း၊ ခေါန်းခင် မိုးချေးသားဟို စီးယွေ့ ကြွလာတာဟို လည်းကောင်း နင်လို့ မျော်ရကြမယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","အေးအခါ ယဇ်ပုရောဟိတ်မင်းဟ မိမိရဲ့အဝတ်ဟို ဆွဲဖြဲပင်းရင် “အေးသူဟ ဘုရားသခင်ဟို ပစ်မား ပြောဆိုချေပီ၊ ငါလို့ သက်သေများ ထပ်ယွေ့ မလိုတော့ပီ၊ ဘုရားသခင်အား ပစ်မားပြောဆိုတာဟို နင်လို့ အခု ကြားရပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","နင်လို့ စလိုထင်လုန်း။” အေးသူလို့ဟ “သူ့ဟို သေဒဏ်ပေးရမယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","အေးနောက် သူလို့ဟ ကိုယ်တော်ရဲ့ မျက်နှာတော်ဟို ဆံထွေးနဲ့ ထွေးပင်း ရိုက်ကြအယ်။ တချို့သော သူလို့ဟ ကိုယ်တော် ပါးဟို ရိုက်ပင်းရင်၊ ");
INSERT INTO dnv_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“မေရှိယ၊ နင့်ဟို စသူ ရိုက်တာဟို ဟောကျေ့မန့်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ပေတရုဟ အပြင်ဖက် အိုင်ဝင်းအတွင်းနှိုက် ထိန်လျက်နေစဉ် အစေခံမိန်းမ တယောက်ဟ ရောက်လာယွေ့ “နင်ဟလည်း ဂါလိလဲပြေသား ယေရှုနဲ့ ပေါင်းဖော်သူဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","အဲလိုလဲ ပေတရုဟ “နင်ဟောလဲ့အရာဟို ငါမသိ” ဟု လူအပေါင်းလို့ အဆေ့တွင် ငြင်းဆိုပင်းရင် ");
INSERT INTO dnv_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","အိုင်ဝင်း ဝင်ပေါက်ဟို ထသွားလေအယ်။ တခြား အစေခံမိန်းမ တယောက်ဟ သူ့ဟိုမျော်ရင် အေးနေရာတွင် ဆိသော သူလို့အား “ဟေသူဟ နာဇရက်မြို့သား ယေရှုနဲ့ ပေါင်းဖော်သူ ဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ပေတရုဟ “အေးသူဟို ငါမသိ” ဟု ကျိန်ဆိုယွေ့ ငြင်းပြန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","အေးနောက် အချိန်ကတစ်ကြာသောအခါ အနီးတွင် ရပ်နေသောသူများဟ ပေတရုဆေ လာယွေ့ “နင်ဟ အမန်ပင် အေးသူလို့ထဲမှ တယောက် ဖြစ်အယ်၊ အကျောန်းမှာ နင်ပြောပုံဆိုပုံအားဖြင့် သိသာအယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ပေတရုဟ “အေးသူဟို ငါမသိ” ဟု ဘုရားသခင်ဟို တိုင်တည်ယွေ့ ကျိန်ဆိုလေအယ်။ အေးခဏနှိုက် ကြက်တွန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","အေးအခါ “ကြက်မတွန်မီ နင့်ဟ ငါ့အား မသိဟု သုံးကြိမ်မြောက်အောန် ငြင်းဆိုလိမ့်မယ်” ဟု ယေရှု မိန့်ခဲ့လဲ့ စကားဟို ပေတရု ပြန်လည်သတိရသဖြင့် အပြင်ဟို ထွက်ယွေ့ ရမ်းဆာ့ ငိုကလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","မနက်စောစောနှိုက် ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အသက်ကြီးသူများဟ ယေရှုဟို သေဒဏ်ချရန် တိုင်ပင်ကြပင်း ");
INSERT INTO dnv_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ယေရှုဟို တုတ်ချေကာ ခေါ်ဆောင်ယွေ့ ရောမဘုရင်ခံ ပိလတ်မင်းဆေ အပ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ကိုယ်တော်အား သစ္စာဖောက်ခဲ့သူ ယုဒဟ ယေရှုဟို စီရင်ပေးရမယ့်အကျောန်းဟို သိမြော်သောအခါ နောင်တရလျက် ငွေသုံးဆယ်ဟို ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အသက်ကြီးသူများဆေဟို ပြန်ယွေ့ ပေးခဲ့ပင်းရင် ");
INSERT INTO dnv_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ငါဟ အပစ်မဆိသောသူရဲ့ အသွေးဟို အပ်မိပါပီ” ဟု ဆိုအယ်။ အဲလိုလဲ အေးသူလို့ဟ “ငါလို့နဲ့ ဟေကိစ္စဟ စလိုဆိုင်လုန်း၊ နင်ရဲ့ တာဝန်သာ ဖြစ်အယ်” ဟု ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","အေးအခါ ယုဒဟ ငွေဒင်္ဂါးဟို ဗိမာန်တော်တွင် လောချပင်း ထွက်ပြေးသွားအယ်။ အေးနောက် တခြားဟို သွားပင်းရင် ကြိုးဆွဲချယွေ့ သေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ယဇ်ပုရောဟိတ်ကြီးဟ အေးငွေဒင်္ဂါးဟို ကောက်ယူယွေ့ “ဟေငွေဒင်္ဂါးဟ အသွေးရဲ့ အခဖြစ်သောကျောန့် ငါလို့ရဲ့ဥပဒေအရ ဘဏ္ဍာတိုက်ထဲဟို မသွင်းယူသင့်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","သူလို့ဟ ဆွေးနွေးတိုင်ပင်ကြပင်းရင် အေးငွေဒင်္ဂါးနဲ့ အိုးထိန်းသည်ရဲ့ လယ်မြေဟို လူမျိုးခြားလို့ရဲ့ လုတ်တိုင်းအဖြစ် အသုံးပြုရန် ဝယ်ယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","အဲကျောန့် အေးလယ်ဟ ခုနေ့တိုင်အောန် “အသွေးမြေ” ဟူယွေ့ ခေါ်တွင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","အဲအခါ ပရောဖက် ယေရမိဟ “သူလို့သည် အေးသူရဲ့တန်ဖိုးအဖြစ် ဣသရေလအမျိုးသားလို့ အကဲဖြတ်ပေးလဲ့ ငွေဒင်္ဂါးသုံးဆယ်ဟို ယူပင်းရင် ");
INSERT INTO dnv_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ဘုရားသခင် ငါ့အား မှာကြားလဲ့အတိုင်း အိုးထိန်းသည်ရဲ့ လယ်မြေဟို အဲငွေဒင်္ဂါးနဲ့ ဝယ်ယူကြအယ်” ဟု ဟောကြားခဲ့လဲ့အရာဟ ပြေ့စုံလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ရောမဘုရင်ခံမင်းရဲ့ ဆေ့ဟို ယေရှု ရပ်ရာ ဘုရင်ခံမင်းဟ “နင်သည် ယုဒ ဘုရင်ပေလော” ဟု မေးအယ်။ ယေရှုဟ “နင်ပြောလဲ့တိုင်းတိုင်း ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","အဲလိုလဲ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အသက်ကြီးသူများ အပစ်တင် စွပ်စွဲချက်များဟို ယေရှုဟ စလိုမှ ဖြေကြားတော်မမူ။ ");
INSERT INTO dnv_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","အဲအခါ ပိလတ်မင်းဟ “နင့်အား အေးသူလို့ဟ စလောက် အပစ်တင် စွပ်စွဲယွေ့ သက်သေခံလျက် ဆိတာဟို နင်မကြားသလော” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","အဲလိုလဲ ယေရှုဟ စကားတခွန်းဟိုမှ ပြန်ပင်း မမိန့်ဘဲနေသဖြင့် ဘုရင်ခံဟ ရမ်းဆာ့အံ့ဩလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ရောမဘုရင်ခံမင်းဟ ပသခါပွဲအခါကျတိုင်း လူအုပ်လို့တောင်းလဲ့ အကျဉ်းသား တယောက်ဟို လွတ်ငြိမ်းချမ်းသာခွင့် ပေးလဲ့ စလေ့ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","အေးအချိန်နှိုက် ယေရှု ဗာရဗ္ဗဟု ခေါ်လဲ့ နာမယ်ဆိုးနဲ့ အကျဉ်းသား တယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","အဲလိုမို့ လူလို့ စုရုံးလာကြသောအခါ ပိလတ်မင်းဟ “နင်လို့အတွက် စသူအား လွတ်ငြိမ်းချမ်းသာခွင့် ပေးစေလိုသလော။ ယေရှု ဗာရဗ္ဗလော အဲဟာမဟုတ်ရင် ယေရှုဆိုသူ မေဆှိယလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","အေးသူလို့ မနာလိုယွေ့ ယေရှုအား မိမိလက်နှိုက် အပ်နှံကြကျောန်းဟို ပိလတ်မင်း သိသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ပိလတ်မင်းဟ တရားစီရင်ခြင်း ထိန်ခုံတွင် ထိန်နေခါ သူရဲ့ပေါင်အိုမဟ လူဟို စေလွှတ်ယွေ့ “အေးဖြောင့်မတ်သောသူနဲ့ ပတ်သက်ယွေ့ ပစာအရာဟိုမျှ မလုပ်ပါနဲ့။ ပစာကို့ ငါဟ မနေ့ည အိပ်မက်တွင် သူ့အတွက် စိတ်ဒုက္ခများစွာ ရောက်ရပါအယ်” ဟု ပြောစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အသက်ကြီးသူများဟ ဗာရဗ္ဗအား လွတ်ငြိမ်းချမ်းသာခွင့်ပေးမန့်၊ ယေရှုဟို သတ်မန့် ဟု ပိလတ်မင်းဆေ တောင်းဆိုရန် လူအုပ်လို့အား စည်းရုံးသိမ်းသွင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","အဲလိုလဲ ပိလတ်မင်းဟ “ဟေသူနေယောက်လို့တွင် နင်လို့အတွက် စသူဟို လွတ်ငြိမ်းချမ်းသာခွင့် ပေးစေလိုလုန်း” ဟု မေးအယ်။ လူလို့ဟ “ဗာရဗ္ဗဟို လွှတ်ပေးမန့်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ပိလတ်မင်းဟ “သို့ဖြစ်ရင် မေဆှိယ ဟုခေါ်သော ယေရှုဟို စလို လုပ်ရမလုန်း” ဟု မေးအယ်။ အေးသူအပေါင်းလို့ဟ “သူအား လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ပါ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","အဲလိုလဲ ပိလတ်မင်းဟ “သူသည် ပစာအပစ်ဟို ကျူးလွန်လုန်း” ဟု မေးအယ်။ အဲပင်းရင် အေးသူလို့ဟ “သူအား လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ပါ” ဟု အသံကုန်အော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ပိလတ်မင်းဟ စလိုအကျိုးမှ မဆိဘဲ ရုန်းရင်းဆန်ခတ်ဖြစ်မယ့် အရိပ်အရောင်ဟိုသာ သိမျော်လာသဖြင့် လူထုဆေ့တွင် ယေဟို ယူယွေ့ “ဟေသူရဲ့ အသွေးနဲ့ ငါဟ ကင်းဆှင်းအယ်။ နင်လို့ရဲ့ တာဝန်သာ ဖြစ်အယ်” ဟု ဆိုကာ မိမိရဲ့လက်ဟို ဆေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","လူအပေါင်းလို့ဟ “အေးသူရဲ့ အသွေးဟ ငါလို့နဲ့ ငါလို့သားမြေးများရဲ့ တာဝန်ဖြစ်ပါစေ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","အေးအခါ ပိလတ်မင်းဟ ဗာရဗ္ဗဟို လွတ်ငြိမ်းချမ်းသာခွင့် ပေးယွေ့ ယေရှုဟို ကြိမ်ဒဏ်ခတ်စေပင်းရင် လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ရန် အပ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","အေးနောက် ပိလတ်မင်းရဲ့ စစ်သားများဟ ယေရှုအား ဘုရင်ခံမင်းရဲ့ အိုင်တော်ဟို ခေါ်ဆောင်သွားကြပင်း တပ်ဖွဲ့တတပ်လုံးဟ ယေရှု ပတ်လည် စုရုံးလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","သူလို့ဟ ကိုယ်တော်အား အဝတ်ဟို ချွတ်ယွေ့ နီသော ဝတ်လုံဟို ခြုံပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","အေးနောက် ဆူးခက်ဖြင့် ရက်လဲ့ သရဖူဟို ဦးခေါင်းပေါ်မှာ ဆောင်းပေးကြယွေ့ ကျူရိုးတချောင်းဟို လက်ယာလက်တွင် ထည့်ပေးကြပင်းနောက် အဆေ့တွင် ဒူးထောက်လျက် “ယုဒဆှင်ဘုရင်၊ သက်တော်ဆှည်ပါစေသော” ဟု ပြောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ကိုယ်တော်ဟို ဆံထွေးနဲ့ထွေးယွေ့ ကျူရိုးဟို ယူပင်း ခေါင်းဟို အကြိမ်ကြိမ် ရိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","သူလို့ ပြောင်ကြပင်းရင် ဝတ်လုံနီဟို ချွတ်ယွေ့ ကိုယ်တော်ရဲ့ အဝတ်ဟို ပြန်ဝတ်ပေးကြအယ်။ အေးနောက် လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ရန် ကိုယ်တော်ဟို ခေါ်ဆောင်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","သူလို့ဟ ထွက်လာကြသောအခါ ရှိမုန် နာမယ်ဆိသူ ကုရေနေပြေသား တယောက်ဟို မျော်သဖြင့် အေးသူအား အတင်းအကြပ် ခေါ်ယွေ့ ယေရှုရဲ့လက်ဝါးကပ်တိုင်ဟို ထမ်းစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","“ဦးခေါင်းခွံအရပ်” ဟု အဓိပ္ပာယ်ဆိသော ဂေါလဂေါသ နာမယ်တွင်လဲ့အရပ်ဟို ရောက်ရင် ");
INSERT INTO dnv_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","သူလို့ဟ ဆေးခါးနဲ့ ရောစပ်ထားသော စပျစ်ယေဟို ယေရှုအား တိုက်ကြပေမဲ့ ယေရှုဟ မြည်းကျေ့ပင်းရင် မသောက်ဘဲနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","အေးနောက် သူလို့ဟ ယေရှုဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ကြပင်း အဝတ်တော်များဟို မဲချယွေ့ ခွဲဝေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","အေးနောက် အဲနေရာတွင် ထိန်ယွေ့ ယေရှုဟို စောင့်ကျေ့နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ယေရှုရဲ့ ခေါင်းထက်တွင် “ဟေသူဟ ယုဒဆှင်ဘုရင် ယေရှု ဖြစ်အယ်” ဟု ရေးထားလဲ့ ကိုယ်တော်အပေါ် တင်သောစွဲချက်ဟို တပ်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","အေးအချိန်နှိုက် ထားမြနေယောက်ဟိုလည်း ယေရှုနဲ့အတူ လက်ယာဘက်တွင် တယောက်၊ လက်ဝဲဘက်တွင် တယောက်၊ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","လမ်းသွားလမ်းလာများဟ မိမိရဲ့ခေါင်းဟို ခါယွေ့ ယေရှုအား ကဲ့ရဲ့လျက် ");
INSERT INTO dnv_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ဗိမာန်တော်ဟို ဖြိုဖျက်ယွေ့ သုံးရက်အတွင်း ပြန်လည်တည်ဆောက်မယ့်သူ နင်ဟ ဘုရားသခင်ရဲ့ သားတော်မန်ရင် တတ်တိုင်း ကယ်တင်ပင်း လက်ဝါးကပ်တိုင်ပေါ်မှ ဆင်းခဲ့လော့” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","အေးနည်းတူစွာ ယဇ်ပုရောဟိတ်ကြီးများ၊ ကျမ်းတတ်ဆရာများနဲ့ အသက်ကြီးသူများဟလည်း ကိုယ်တော်ဟို ပြောင်ကြယွေ့ ");
INSERT INTO dnv_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ဟေသူဟ သူတပါးဟို ကယ်တင်ပေမဲ့ မိမိတတ်တိန်း မကယ်တင်နိန်တာ ဟုတ်မောင့်လဲ့၊ သူဟ ဣသရေလဘုရင် မဟုတ်လော၊ လက်ဝါးကပ်တိုင်မှ အခုဆင်းလာရင် ငါလို့ သူ့ဟို ယုံကြည်ကြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","သူဟ ဘုရားသခင်ဟို ယုံကြည်ကိုးစားအယ်။ ‘ငါဟ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်အယ်’ ဟု ဆိုအယ်။ အဲလိုမို့ ဘုရားသခင်ဟ သူဟို အလိုတော်ဆိရင် အခုပင် ကယ်တင်ပါစေ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ကိုယ်တော်နဲ့အတူ လက်ဝါးကပ်တိုင်တွင် အသတ်ခံရသူ ထားမြများကပင်လျှင် အေးနည်းတူ ကိုယ်တော်ဟို ကဲ့ရဲ့ပစ်တင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","မွန်းတည့်ချိန်မှစယွေ့ မွန်းလွဲသုံးနာရီတိုင်အောန် မြေတပြင်လုံးတွင် မိုက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","မွန်းလွဲသုံးနာရီ အချိန်နှိုက် ယေရှုဟ “ဧလိ၊ ဧလိ၊ လာမာ ရှာဗခသာနိ” ဟု ကျယ်သောအသံနဲ့ အော်ဟစ်အယ်။ ဆိုလိုလဲ့အနက်ဟ “ငါ့ ဘုရား၊ ငါ့ ဘုရား၊ ပစာကျောန့် ငါ့ဟို စွန့်ပစ်လုန်း။” ");
INSERT INTO dnv_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","အဲရပ်နှိုက် ရပ်နေသူ လူတချို့လို့ဟ အေးစကားဟို ကြားရင် “သူဟ ဧလိယဟို ခေါ်နေအယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","အေးသူလို့အနက် လူတယောက်ဟ ချက်ချင်းပြေးယွေ့ ယေမြှုပ်ဟိုယူကာ စပျစ်ယေချဉ်နဲ့ပြေ့စေပင်း အေးဟာဟို ကျူရိုးဖျားတွင် ပတ်ယွေ့ ကိုယ်တော်သောက်ရန် ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","အဲလိုလဲ အခြားသောသူလို့ဟ “ဆိစေတော့၊ သူဟိုကယ်ရန် ဧလိယ လာမလာဟို ငါလို့ကျေ့ကြကုန်အံ့” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ယေရှုဟ တဖန်ကျယ်စွာ အော်ပင်းလျှင် အသက်ချုပ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","အေးအခါ ဗိမာန်တော်ကန့်လန့်ကာဟ အထက်စွန်းမှ အောက်စွန်းတိုင်အောန် နေခြမ်း ကွဲလေအယ်၊ မြေငလျင်လှုပ်ယွေ့ ကျောက်ဆောင်များ ပြိုကွဲကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","လုတ်တိုင်းဂူများ ပွင့်သဖြင့် သေလွန်ပင်းသူ သန့်ဆှင်းသောသူလို့ရဲ့ ရုပ်အလောင်းများစွာလို့ဟ အသက်ပြန်ဆှင်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ယေရှု ဆှင်ပြန်ထမြောက်ပင်းနောက် အေးသူလို့ဟ လုတ်တိုင်းထဲမှ ထွက်လာကာ သန့်ဆှင်းသောမြို့တော်ဟို ဝင်သွားကြသဖြင့် လူအများပင် သူလို့ဟို တွေ့မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","တပ်မှူးနဲ့တကွ ယေရှုဟို စောင့်ကျေ့နေကြသော စစ်သားများဟ မြေငလျင်လှုပ်ခြင်းနဲ့ အခြားအဖြစ်အပျက်များဟိုလည်းကောင်း တွေ့မျော်ကြသောအခါ ရမ်းဆာ့ကြောက်လန့်ကြယွေ့ “ဟေသူဟ အမန်ပင် ဘုရားသခင်ရဲ့သားတော် ဖြစ်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","အေးအရပ်တွင် အဝေးဟရပ်လျက် ကျေ့နေသော အမျိူးသမီးများဆိပင်း ဂါလိလဲပြေမှ ယေရှုရဲ့ နောက်တော်ဟို လိုက်ယွေ့ လုပ်ကျွေးသမှု ပြုကြသူများ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","အေးသူလို့အထဲတွင် မာဂဒလမြို့သူ မာရိ၊ ယာကုပ်နဲ့ ယောသပ်လို့ရဲ့ အမေ့ဖြစ်သူ မာရိနဲ့ ဇေဗေဒဲရဲ့ပေါင်အိုမလို့ ပါကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ညခင်းအချိန်ရောက်သောအခါ အရိမဿဲမြို့မှ ယောသပ် နာမယ်ဆိသော သူဌေးတယောက် ရောက်လာအယ်။ သူဟ ယေရှုရဲ့ တဘဲ့တော်တယောက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","သူဟ ပိလတ်မင်းဆေဟို ဝင်ပင်းရင် ယေရှုရဲ့ ရုပ်အလောင်းဟို တောင်းပင်း ပိလတ်မင်းဟ ယောသပ်အား ပေးရန် အမိန့်ချမှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ယောသပ်ဟ ရုပ်အလောင်းဟို ယူယွေ့ ဖြူစင်သော ပိတ်ချောဖြင့် ပတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","အေးနောက် ကျောက်ဆောင်နှိုက် အသစ်ထွင်းထားလဲ့ မိမိလုတ်တိုင်းဂူတွင် သွင်းထားပင်းနောက် ဂူဝဟို ကြီးမားလဲ့ ကျောက်တုံးတခုလှိမ့်ယွေ့ ပိတ်ထားလိုက်ပင်းနောက် ပြန်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","လုတ်တိုင်းဆေ့တွင် မာဂဒလမြို့သူ မာရိနဲ့ တခြားမာရိလို့ဟ ထိန်လျက် ဆိနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","နောက်တနေ့ ကုန်လွန်ယွေ့ ဥပုသ်နေ့ရောက်သော် ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ဖာရိရှဲများဟ ပိလတ်မင်း ဆေဟို သွားပင်းရင် ");
INSERT INTO dnv_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ဆရာ၊ အေးလူလိမ် အသက်ဆှင်စဉ်အခါဟ ‘ငါသည် သုံးရက်ကြာရင် သေခြင်းမှ ထမြောက်မယ်’ ဟု ဟောခဲ့တာဟို ငါလို့ မှတ်မိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","သို့ဖြစ်ယွေ့ သုံးရက်မြောက်သောနေ့အထိ လုတ်တိုင်းဂူဟို လုံခြုံစွာ ပိတ်ယွေ့ စောင့်ကြပ်စေရန် အမိန့်ပေးမန့်။ အဲလိုမဟုတ်ရင် သူရဲ့တဘဲ့များဟ လာယွေ့ ရုပ်အလောင်းဟို ခိုးယူကာ သူဟ သေခြင်းမှ ထမြောက်လေပီ ဟု လူလို့အား ပြောကြလိမ့်မယ်။ အေးအခါ နောက်ဆုံးလှည့်စားချက်ဟ ပထမလှည့်စားချက်ထက် ပိုယွေ့ ဆိုးပါလိမ့်မယ်” ဟု ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ပိလတ်မင်းဟ “အစောင့်တပ် တတပ်ဟို ခေါ်ပင်း လုတ်တိုင်းဂူဟို သွားယွေ့ အတတ်နိန်ဆုံး စောင့်ကျေ့စေလော့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","သို့ဖြစ်ယွေ့ အေးသူလို့ဟ လုတ်တိုင်းဂူသို့ သွားပင်းရင် ကျောက်တုံးဟို တံဆိပ်ခတ်နှိပ်ကာ အစောင့်တပ်များဟို ချထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ဥပုသ်နေ့ပင်းနောက် တနင်္ဂနွေနေ့ မိုးလင်းခါနီး အချိန်နှိုက် မာဂဒလမြို့သူ မာရိနဲ့ တခြားမာရိလို့ဟ လုတ်တိုင်းဟို သွားကျေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ရုတ်တရက် ပြင်းလဲ့ မြေငလျင်လှုပ်လေအယ်။ အကျောန်းမှာ ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန်ဟ ခေါန်းခင်ဘုံမှ ဆင်းလာယွေ့ ကျောက်တုံးဟို တွန်းဖယ်ပင်း အဲကျောက်တုံးပေါ်မှာ ထိန်နေသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","သူရဲ့ပုံစံဟ ရှပ်စီးလပ်သလိုဖြစ်ယွေ့ သူရဲ့ အဝတ်ဟ နှင်းပွင့်လို ဖြူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","အစောင့်တပ်သားများဟ ခေါန်းခင်တမန်ဟို ရမ်းဆာ့ ကြောက်လန့်သဖြင့် တုန်လှုပ်ကာ လူသေလိုမျိုး ဖြစ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ခေါန်းခင်တမန်ဟ မိန်းမလို့အား “မကြောက်ကြနဲ့၊ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ခံရသော ယေရှုဟို နင်လို့ ဆာနေကျောန်းဟို ငါသိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ကိုယ်တော်ဟ ဟေနေရာနှိုက် မဆိ မိန့်ခဲ့လဲ့အတိုင်း ဆှင်ပြန်ထမြောက်ပီ။ ကိုယ်တော် လျောင်းတဲ့နေရာဟို လာပင်း ကျေ့ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","တဘဲ့တော်ဆေဟို အခုမြန်မြန်သွားပင်း ‘ကိုယ်တော်ဟ သေခြင်းမှ ဆှင်ပြန်ထမြောက်ပီ၊ နင်လို့ထက်အရင် ဂါလိလဲပြေဟို ကြွမယ်ဖြစ်ယွေ့ အဲအရပ်တွင် ကိုယ်တော်ဟို နင်လို့ တွေ့ရကြလိမ့်မယ်’ ဟု ပြောကြားကြလော့၊ ငါဟောလဲ့ စကားဟို မမေ့ကြနဲ့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","အဲမိန်းမလို့ဟ ကြောက်လန့်ကြသော်လည်း ရမ်းဆာ့ ရွှင်လန်းဝမ်းမြောက်စွာ လုတ်တိုင်းဂူမှ မြန်မြန်ထွက်ခွာယွေ့ တဘဲ့တော်လို့အား အေးသတင်းဟို ဟောကြားရန် ပြေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","အဲအချိန်နှိုက် ယေရှုဟ သူလို့ဆေဟို ရောက်ဆိလာကာ “နင်လို့ဟ မင်္ဂလာဆိပါစေသော” ဟု မိန့်အယ်။ သူလို့ဟ အထံတော်ဟို ချဉ်းကပ်ယွေ့ ခြေထောက်ဟို ဖက်ယမ်းလျက် ပျပ်ဝပ်ရှိခိုးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","အဲအခါ ယေရှုဟ “မကြောက်ကြနဲ့၊ သွားယွေ့ ငါရဲ့ညီအကိုများအား ဂါလိလဲပြေဟို သွားရန် ဟောကြားလော့။ သူလို့ဟ အေးပြေတွင် ငါ့ဟို မျော်ရကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","မိန်းမလို့ ထွက်ခွာသွားကြစဉ် လုတ်တိုင်းဂူ အစောင့်တပ်သား တချို့လို့ဟ မြို့ထဲဟိုဝင်ယွေ့ ယဇ်ပုရောဟိတ်ကြီးများအား ဖြစ်ပျက်လဲ့ အကျောန်းအရာအလုံးစုံဟို ကြားပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ယဇ်ပုရောဟိတ်အကြီးများနဲ့ အသက်ကြီးသူများဟ စုရုံးတိုင်ပင်ကြပင်းနောက် စစ်သားများအား ရမ်းဆာ့သော ပိတ်ဆန်ဟို ပေးယွေ့ ");
INSERT INTO dnv_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ညအခါ ငါလို့အိပ်မွေ့နေခိုက် အေးသူရဲ့ တဘဲ့လို့ဟ လာယွေ့ အလောင်းဟို ခိုးယူသွားကြတာဟု ဟောကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","အေးသတင်းဟို မြို့ဝန်မင်းများ ကြားခဲ့ရင် သူ့ဟို ငါလို့ ဖျောင်းဖျယွေ့ သူလို့နှိုက် စိုးရိမ်စရာ မဆိစေရန် ဆောင်ရွက်ပေးမယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","စစ်သားလို့ဟ ပိတ်ဆန်ဟို ယူယွေ့ သူလို့ သင်ကြားပေးလိုက်လဲ့အတိုင်း ဟောကြအယ်။ အဲလိုမို့ အဲသတင်းဟို အခုနေ့တိုင်အောန် ယုဒအမျိုးသားလို့ဟ အနှံ့အပြား ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","တဘဲ့တော် တဆယ့်တဦးလို့ဟ ယေရှု မှာကြားလဲ့အတိုင်း ဂါလိလဲပြေ တောင်ပေါ်သို့ သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","သူလို့ဟ ကိုယ်တော်ဟို မျော်သောအခါ ပျပ်ဝပ်ရှိခိုးကြပေမဲ့ အေးသူလို့အနက် တချို့သောသူလို့ဟ သံသယ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ယေရှုဟ သူလို့ အနီးဟို ကြွလာလျက် “ခေါန်းခင်ဘုံနဲ့ မြေကြီးပေါ် ဆိသမျှသောတန်ခိုး အာဏာလို့ဟို ငါဆေ ပေးအပ်ထားလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","အဲလိုမို့ နင်လို့ဟ သွားယွေ့ လူမျိုးတကာလို့ဟို ငါ့တဘဲ့ ဖြစ်စေကြလော့။ သူလို့အား ခမည်းတော်၊ သားတော်၊ သန့်ဆှင်းသော ဝိညာဉ်တော်ရဲ့ နာမဟို အမှီပြုယွေ့ နှစ်ခြင်းမင်္ဂလာဟို ပေးကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","နင်လို့အား ငါပေးသမျှသော ပညတ်လို့ဟို စောင့်ထိန်းကြစေရန် သူလို့အား သွန်သင်ကြလော။ ငါဟ ကပ်ကမ္ဘာကုန်ဆုံးချိန်တိုင်အောန် နင်လို့နဲ့အတူ အစဉ်မပြတ် ဆိမယ်” ဟု မိန့်အယ်။");
INSERT INTO dnv_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ဟေအကျောန်းအရာဟ ဘုရားသခင်ရဲ့ သားတော် ယေရှု ခရစ်အကျောန်း သတင်းကောင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ပရောဖက် ဟေရှာယကျမ်းတွင် စတင် ရေးသားခဲ့လဲ့အတိုင်း၊ “ဘုရားသခင်ဟ၊ ‘ငါဟ နင့်ရဲ့ လမ်းဟို ပြင်စေရန် ငါရဲ့ တမန်ဟို နင့်ဆေ့အူးရင် စေလွှတ်လိမ့်မယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","တောကန္တာရထဲတွင် တစုံတယောက် အော်ပြောသောသူရဲ့ အသံမှာ ‘အဆှင် ကြွလာရာလမ်းဟို အသင့်ပြင်ဆင်ကြလော့၊ အဲသူရဲ့ လမ်းဟို ဖြောင့်တန်းအောန် လုပ်ကြလော့။’ ” ");
INSERT INTO dnv_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","နှစ်ခြင်းဆရာ ယောဟန်ဟ တောကန္တာရနှိုက် ပေါ်ထွန်းလာပင်း အပစ်များဟို ခွင့်လွှတ်ခြင်းအတွက် နောင်တနဲ့ဆိုင်သော နှစ်ခြင်းတရားဟို ဟောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ရမ်းဆာ့သော ယုဒနယ်တနယ်လုံးဆိ လူအပေါင်းလို့နဲ့ ယေရုရှလင်မြို့မှ လူအားလုံးလို့ဟ ယောဟန်ဆေသို့ ကြားနာဖို့ သွားကြကုန်အယ်။ မိမိလို့ အပစ်များဟို ပြောပြဝန်ခံပင်း ယော်ဒန်မြစ်တွင် ယောဟန်ဆေမှာ နှစ်ခြင်းဟို ခံယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ယောဟန်ဟ ကုလားအုတ် အမွေးနဲ့ရက်သော အဝတ်ကြမ်းဟို ဝတ်ဟားပင်း၊ သားရေ ခါးပတ်ဟို သူ့ရဲ့ ခါးတွင် စဲထားလျက်၊ ပလံမစိမ်းနဲ့ တောပျားရည်ဟို စားသောက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","သူဟ “ငါ့ထက်ကြီးမြတ်သောသူဟ ငါရဲ့ နောက်တွင် ပေါ်ထွန်းလာလိမ့်မယ်။ ငါဟ အဲသူရဲ့ ဖိနပ်သိုင်းကြိုးဟိုမျှ ငုံ့ယွေ့ ဖြေပေးရန် ငါမထိုက်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ငါဟ နင်လို့အား ယေတွင် နှစ်ခြင်းဟို ပေးယွေ့၊ အဲသူမှာမူ သန့်ဆှင်းသော ဝိညာဉ်တော်နှိုက် နင်လို့ဟို နှစ်ခြင်း ပေးလိမ့်မယ်” ဟု ဟောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","အဲအချိန်မှာ ယေရှုဟ ဂါလိလဲပြေ နာဇရက်မြို့မှ ကြွလာယွေ့၊ ယော်ဒန်မြစ်တွင် ယောဟန်ဆေမှာ နှစ်ခြင်းဟို ခံယူလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ယေထဲမှ တက်လာတာနဲ့ တခါတည်း မိုးခေါန်းခင်ပွင့်ယွေ့ သူ့အပေါ်ဟို ဝိညာဉ်တော်ဟ ချိုးငက်အသွင်ဖြင့် ဆင်းလာတာဟို မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","မိုးခေါန်းခင် ပေါ်မှ လာသော အသံဟ “နင်ဟ ငါပိုင်တဲ့ ငါရဲ့ ချစ်သား ဖြစ်အယ်။ ငါ နှစ်သက်မြတ်နိုးသောသူ ဖြစ်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ခုတင်ချင်းပင် ဝိညာဉ်တော်ဟ ကိုယ်တော်အား တောကန္တာရထဲဟို ပို့ဆောင်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","တောကန္တာရတွင် စာတန်ဟ ကိုယ်တော်အား ရက်ပေါင်း လေးဆယ်တိတိ စမ်းသပ်သွေးဆောင်လေအယ်။ အဲနေရာတွင် တောတိရစ္ဆာန်ကောင်များလည်း ဆိကြပင်း ခေါန်းခင်တမန်လို့ဟ လာယွေ့ ကိုယ်တော်ဟို ကူညီလုပ်ကျွေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ယောဟန်ဟ အကျဉ်းထောင်ထဲဟို ရောက်ပင်းနောက် ယေရှုဟ ဂါလိလဲပြေသို့ ကြွလာယွေ့ ဘုရားသခင်ဆေမှ သတင်းကောင်းဟို ဟောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“အချိန်ကျလာပီ။ ဘုရားသခင်ရဲ့ နိုင်ငံတော် တည်လုနီးပီမို့၊ နောင်တရယွေ့ သတင်းကောင်းဟို ယုံကြည်ကြလော့” ဟု ဟောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ယေရှုဟ ဂါလိလဲ အိန်ကမ်းနားတွင် ဆှောက်သောအခါ ရှိမုန်နဲ့ သူ့ညီ အိန္ဒြေလို့ တံငါသည် နေယောက်ဟ အိန်ထဲတွင် ကွန်ပစ်နေကြတာဟို မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ယေရှုဟ “လာမန့်။ ငါ့နောက်ဟို လိုက်ကြ။ နင်လို့ဟို လူဟိုဖမ်းသော တံငါသည်များဖြစ်အောန် ငါသင်ပေးမယ်” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","သူလို့ဟ တခါထဲ ပိုက်ကွန်ဟို ထားခဲ့ယွေ့ နောက်တော်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ကိုယ်တော်ဟ ကတစ်ဆက်လက်ယွေ့ ဆှောက်သွားပင်း နောက်ထပ် ညီအကို နေယောက်ဖြစ်သော ဇေဗေဒဲရဲ့ သား ယာကုပ်နဲ့ ယောဟန်ဟို မျော်လေအယ်။ သူလို့ဟလည်း လှေထဲတွင် ပိုက်ကွန်များဟို အသင့်ပြင်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ယေရှုဟ သူလို့ဟို မျော်ရင် ခုတုံးခေါ်လိုက်သဖြင့် သူလို့ဟ အဖ ဇေဗေဒဲဟို လူငှားများနဲ့ လှေထဲတွင် ထားခဲ့ယွေ့ ယေရှု နောက်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ယေရှုနဲ့ သူရဲ့ တဘဲ့တော်လို့ဟ ကပေရနောင်မြို့ထဲဟို လာကြအယ်။ ဥပုသ်နေ့ရောက်သောအခါ ယေရှုဟ တရားဇရပ်ဟို ဝင်ယွေ့ စတင်သွန်သင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","လူလို့ဟ ကိုယ်တော် သွန်သင်ခြင်းဟို အံ့ဩကြအယ်၊ ပစာကို့ ကိုယ်တော်ဟ ကျမ်းတတ်ဆရာများလိုမျိုး မဟုတ်ဘဲ၊ အဲသူလို့အား အမိန့်အာဏာဆိသောသူလိုမျိုး သွန်သင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","အားပင်း ညစ်ညူးသော နတ်ပူးနေသူ တအူးဟ တရားဇရပ်ထဲဟို လာယွေ့ အော်ကတာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“နာဇရက်မြို့သား ယေရှု၊ နင်ဟ ငါလို့အား ပစာလို လုပ်ချင်လုန်း။ ငါလို့အား ဖျက်ဆီးရန် ဟေမှာ ဆိနေပါလော။ နင်ဟာ စသူဖြစ်ကျောန်း ငါ သိအယ် — နင်ဟ ဘုရားသခင်ရဲ့ သန့်ဆှင်းသောသူ ဖြစ်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ယေရှုဟ “တိတ်တိတ်နေလော့၊ သူ့အထဲမှ ထွက်သွားလော့” ဟု ဝိညာဉ်ဟို အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ညစ်ညူးသောနတ်ဟ လူဟို တောင့်မာစေပင်း၊ အသံကျယ်ရီးနဲ့ အော်ဟစ်ပင်း သူဆေဟနေ ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","လူအပေါင်းလို့ဟ ရမ်းဆာ့အံ့ဩကြလျက် “ဟေဟာရာ့ ပစာရီးနှင်း။ အေးဟာဟ အသစ်သင်ကြားခြင်းရဲ့ တချို့လော။ သူဟာ ညစ်ညူးသော နတ်များဟို အာဏာနဲ့ အမိန့်ပေးယွေ့ သူလို့ဟ နာခံကြအယ်” ဟု သူလို့ အချင်းချင်း စတင်ပင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","အဲကျောန့် ကိုယ်တော်ရဲ့ သတင်းအကျောန်းဟ ဂါလိလဲပြေ တနယ်လုံးဆိ နေရာတိုင်း မြန်မြန် ပျံ့နှံ့သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ယေရှုနဲ့ သူရဲ့ တဘဲ့တော်လို့ဟ ယာကုပ်၊ ယောဟန်နဲ့အတူ တရားဇရပ်မှ ထွက်ခွာယွေ့ ရှိမုန်၊ အိန္ဒြေလို့ရဲ့ နေအိုင်ဟို တန်းသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ရှိမုန်ရဲ့ ယောက္ခမဟ ဖျားနေယွေ့ အိပ်ယာပေါ်လှဲလျက် နေတာဟို ယေရှုအား သူမအကျောန်း သူလို့ဟ ခုတုံးပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ကိုယ်တော်ဟ သူမဆေဟို သွားပင်း၊ သူမရဲ့ လက်ဟို ယူယွေ့ ထရန် ကူညီပင်း၊ သူမဟ အဖျားပျောက်ယွေ့ စတင်ပင်း သူလို့ဟို လုပ်ကျွေးပြုစုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","နေဝင်ယွေ့ ညခင်းအချိန် ရောက်လာပင်းနောက် လူများဟ ရောဂါသည်များနဲ့ နတ်မိစ္ဆာပူးသူများ အားလုံးဟို ယေရှု ဆေဟို ခေါ်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","မြို့ထဲမှ လူအားလုံးလို့ဟ နေအိုင် ဆေ့အူးတွင် စုဆုံလျက် ဆိနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ယေရှုဟ ဖျားနာနေသူများနဲ့ ရောဂါအမျိုးစုံစွဲကပ်သူ အမြောက်အများဟို ကျန်းမာစေယွေ့ ရမ်းဆာ့သော နတ်ဆိုးလို့ဟို မောင်းထုတ်ပလိုက်အယ်။ နတ်ဆိုးလို့ဟ ကိုယ်တော် စသူဖြစ်ကျောန်းဟို သိနေကြသောကျောန့် ကိုယ်တော်ဟ သူလို့အား စကားပြောခွင့် မပေးချေ။ ");
INSERT INTO dnv_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","မနက်စောစော မိုးမလင်းခင် ယေရှုဟ အိပ်ယာမှ ထပင်း၊ သူဟ နေအိုင်ဟနေ တိတ်ဆိတ်လဲ့ နေရာဟို ထွက်သွားပင်း အဲအရပ်နှိုက် ဆုတောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ရှိမုန်နဲ့ သူရဲ့ အပေါင်းအဖော်များဟ ထွက်သွားယွေ့ ကိုယ်တော်ဟို လိုက်ဆာယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","သူလို့ ကိုယ်တော်ဟို တွေ့သောအခါ “လူအပေါင်းလို့ဟ ကိုယ်တော်ဟို ဆာနေကြပါအယ်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ယေရှုဟ “အနီးအနားဆိ အခြားရွာများဟို သွားကြစို့။ ငါဟ သူလို့ဆေမှာ တရားဟောရမယ်၊ အဲဒီအတွက်ကျောန့် ငါလာခဲ့အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ကိုယ်တော်ဟ ဂါလိလဲပြေအနှံ့ သွားလာယွေ့ တရားဇရပ်များနှိုက် တရားဟောပင်း နတ်မိစ္ဆာများဟို မောင်းထုတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","နူနာရောဂါစွဲကပ်သူ လူတယောက်ဟ ယေရှုဆေဟိုလာပင်း ဒူးထောက်ယွေ့ “ကိုယ်တော် အလိုတော်ဆိရင် ငါ့ဟို ရောဂါမှ သန့်စင်စေနိန်ပါအယ်” ဟု တောင်းပန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ယေရှုဟ သနား သဖြင့် လက်ဟို ဆန့်ယွေ့ အဲသူဟို တို့ထိလေအယ်။ “ငါ အလိုဆိအယ်၊ သန့်ဆှင်းပါစေ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ခုတုံးပင် သူဟ နူနာရောဂါပျောက်ယွေ့ သန့်စင်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ယေရှုဟ သူဟို ခုတုံးလွှတ်လိုက်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","သူ့ဟို ပြောပင်းနောက်၊ “နားထောင်ပါ၊ အဲအကျောန်းဟို စသူ့ဟိုမှ မပြောနဲ့။ အဲလိုလဲ ယဇ်ပုရောဟိတ်ဆေသို့ တန်းသွားပင်း ကိုယ်ဟို ပြပင်း နင်လို့ဟ သန့်ဆှင်းကျောန်း လူတိုင်းဟို သက်သေပြရန် မောရှေ မိန့်မှာလဲ့အတိုင်း ပူဇော်သကာဟို ဆက်သပါ” ဟု တင်းတင်းကြပ်ကြပ် သတိပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","အားပင်မဲ့ သူထွက်သွားပင်း သတင်းဟို နေရာအနှံ့ဟို ပြောကြားလေအယ်။ အဲသတင်းဟ ရမ်းဆာ့ ပြန့်သွားသဖြင့် ယေရှုဟ မြို့ထဲဟို လူသိဆှင်ကြား မဝင်နိန်တော့ချေ။ ဆိတ်ကွယ်ရာအရပ်တွင် နေခဲ့ပင်း အရပ်ရပ်မှ လူအပေါင်းလို့ဟ ကိုယ်တော်ဆေဟို လာကြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ရက်နဲနဲကြာသောအခါ ယေရှုဟ ကပေရနောင်မြို့ဟို လဲ့ပြန်လာပင်း၊ နေအိုင်မှာ ကိုယ်တော် ရောက်ဆိနေလဲ့ သတင်းဟ ပျံ့နှံ့သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ရမ်းဆာ့သော လူလို့ဟ စုဝေးလာကြသဖြင့် အဲမှာ အခန်းလွတ်များ မကျန်တော့သာမက၊ ထင်ခါး အပြင်ဖက်မှာ နေရာပင် မဆိတော့ပေ။ ယေရှုဟ သူလို့အား တရားတော်ဟို ဟောလျက် နေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","အဲအခါ လူလေးယောက်လို့ဟ လာပင်း လေဖြတ်သူ တဦးဟို ကိုယ်တော်ဆေဟို မကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","လူအုပ်ကြီးကျောန့် သူလို့ဟ သူ့ဟို ယေရှုဆေဟို မ မလာနိန်ကြ။ သူလို့ဟ ယေရှုဆိလဲ့ နေရာအပေါ်မှ ခေါင်မိုးဟို ဖွင့်ယွေ့ အပေါက်ဖောက်ကာ လေဖြတ်နေသောသူ လဲလျောင်းနေသော ထမ်းစင်ဟို လျှောချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ယေရှုဟ သူလို့ရဲ့ ယုံကြည်ခြင်းဟို မျော်ရင် “ငါ့သား၊ နင့်ရဲ့ အပစ်များဟို လွှတ်စေပီ” ဟု လေဖြတ်သူအား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","အဲနေရာမှာ ထိန်နေကြသော ကျမ်းတတ်ဆရာအချို့လို့ဟ သူလို့ တတ်တိုင်း တွေးနေကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ဟေသူဟ ပစာကျောန့် ဟေလို့ ပြောဝံ့လုန်း။ သူဟ ဘုရားသခင်ဟို စော်ကား ပြောဆိုလေပီ၊ ဘုရားသခင်ဟ အပစ်များဟို ခွင့်လွတ်နိန်သော တဦးတည်းသောသူ ဖြစ်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ယေရှုဟ အဲသူလို့ ပစာတွေးနေလဲဆိုတာဟို ခုတုံးသိသောကျောန့် ယေရှုဟ သူလို့အား ပြောတာဟ၊ “နင်လို့ဟာ ပစာကျောန့် ဟေအရာဟို တွေးနေကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ဟေလေဖြတ်သူအား ‘နင်ရဲ့ အပစ်များဟို ခွင့်လွှတ်ပီ’ အားမှမဟုတ် ‘ထလော့၊ နင့်ထမ်းစင်ဟို ကောက်ယူယွေ့ လမ်းဆှောက်လော့’ ဟု ပြောရန် ပိုလွယ်သလော။ ");
INSERT INTO dnv_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","အဲလိုလဲ လူသားဟ မြေကြီးပေါ်တွင် အပစ်များ ခွင့်လွှတ်ပိုင်ခွင့် အာဏာဆိတာဟို နင်လို့အား ငါ သက်သေပြမယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“နင့်ဟို ငါပြောမယ်၊ ထလော့၊ နင့်ထမ်းစင်ဟို ကောက်ယူယွေ့ နေအိုင်ဟို ပြန်လော့” ဟု သူဟ လက်ခြေသေသောသူအား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","သူလို့အားလုံး ကျေ့နေခါ၊ အဲသူဟ ထယွေ့၊ သူရဲ့ ထမ်းစင်ဟို ကောက်ယူယွေ့ အမြန် ထွက်သွားလေအယ်။ သူလို့အားလုံးဟ လုံးဝအံ့ဩယွေ့ ဘုရားသခင်ဟို ချီးမွန်းပင်း “ငါလို့ ဟေလိုမျိုး တခါမှ မမြင်ဖူးဝူး” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ယေရှုဟ ဂါလိလဲအိန်နားဟို နောက်တခါ လဲ့ပြန်လာအယ်။ လူအုပ်လို့ဟ ကိုယ်တော်ဆေဟို လာကြယွေ့ သူလို့ဟို စတင်သွန်သင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ကိုယ်တော်ဟ ဆှောက်လာခါ၊ အခွန်ခံ လေဝိဟ ရုံးခန်းတွင် အာလဖဲရဲ့သား လေဝိ ထိန်နေတာဟို မျော်ပင်း “ငါ့ နောက်လိုက်လော့” ဟု ယေရှုဟ သူဟို ပြောယွေ့၊ လေဝိဟ ထယွေ့ ကိုယ်တော် နောက်ဟို လိုက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ယေရှုဟ လေဝိရဲ့ နေအိုင်တွင်ညနေစာ စားသောက်လျက်နေစဉ်၊ ရမ်းဆာ့သော အခွန်ခံများနဲ့ အပစ်သားများဟ တဘဲ့တော်များနဲ့တကွ ကိုယ်တော်နဲ့အတူ စားသောက်လျက် ဆိကြအယ် အကျောန်းမှာ ကိုယ်တော် နောက်ဟို လိုက်သောသူ ရမ်းဆာ့ ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ကိုယ်တော်ဟ အပစ်သားများ၊ အခွန်ခံများနဲ့အတူ စားသောက်နေတာဟို ဖာရိရှဲလို့ ထဲမှ ကျမ်းတတ်ဆရာများ မျော်သောအခါ “ပစာကျောန့် ကိုယ်တော်ဟ အပစ်သားများ၊ အခွန်ခံများနဲ့အတူ စားသောက်လုန်း” ဟု သူလို့ဟ ကိုယ်တော်ရဲ့ တဘဲ့များဟို မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ယေရှုဟ အေးအရာဟို ကြားရင်၊ “ကျန်းမာသူလို့ဟ ဆရာဝန်ဟို မလိုအပ်ကြ၊ ဖျားနေသူသာလျှင် လိုအပ်ကြအယ်။ ဖြောင့်မတ်သောသူဟို ခေါ်ရန် ငါ လာတာ မဟုတ်၊ အပစ်သားများဟို ခေါ်ရန်လာအယ်” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ယောဟန်ရဲ့ တဘဲ့များနဲ့ ဖာရိရှဲလို့ဟ အစာဆှောင်လျက် နေကြအယ်။ လူအချို့လို့ဟ ယေရှု ဆေဟိုလာယွေ့ “ယောဟန်ရဲ့ တဘဲ့များနဲ့ ဖာရိရှဲရဲ့ တဘဲ့များဟ အစာဆှောင်ကြသော်လည်း ကိုယ်တော်ရဲ့ တဘဲ့များဟ ပစာကျောန့် အစာမဆှောင်ကြလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ယေရှုဟ “သတို့သားရဲ့ အပေါင်းအဖော်များဟ သူနဲ့တူတူ ဆိနေစဉ်နှိုက် စလိုအစာဆှောင်ဖို့ မျော်လင့်နိန်သလော။ သူလို့ဟ သတို့သား ဆိနေသမျှ ကာလပတ်လုံး အစာမဆှောင်နိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","အားပင်မဲ့ သူလို့ဆေမှ သတို့သားဟို ယူဆောင်သွားမယ့်အချိန် ရောက်ဆိလာလိမ့်မယ်၊ အေးနေ့ရက် ရောက်လာတဲ့အခါ သူလို့ဟ အစာဆှောင်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“စသူမျှ အဝတ်ဟောင်းဟို ပိတ်စသစ်နဲ့ မဖာတတ်။ မဟုတ်ရင် အသစ်ဖာထားသော ပိတ်စဟ အဝတ်ဟောင်းဟို ရုန်းသဖြင့် အပေါက်ဟ ပိုကြီးစေတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","စသူမှ စပျစ်ယေသစ်ဟို သားယေဖူးဟောင်းတွင် ထည့်လေ့ မဆိ။ မဟုတ်ရင် စပျစ်ယေဟ သားယေဖူးဟို ပေါက်ပြဲသဖြင့် စပျစ်ယေနဲ့ သားယေဖူးရော ပျက်စီးသွားလိမ့်မယ်။ အဲအစား စပျစ်ယေသစ်ဟို သားယေဖူး အသစ်နှိုက်သာ ထည့်ကြအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ယေရှုဟ တနေ့သော ဥပုပ်နေ့နှိုက် ဂျုံခင်းဟို ဖြတ်ဆှောက်သွားခဲ့အယ်။ သူရဲ့ တဘဲ့တော်လို့နဲ့အတူ သွားနေကြစဉ်၊ သူလို့ဟ ဂျုံနှံများဟို စတင်ပင်း ဆွတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ဖာရိရှဲများဟ “ကျေ့မန့်၊ ပညတ်တရားအရ ဥပုသ်နေ့နှိုက် မပြုသင့်သော အမှုဟို သူလို့ဟ ပစာကျောန့် လုပ်ကြလုန်း” ဟု ကိုယ်တော်ဟို မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ယေရှုဟလည်း “ဒါဝိဒ်ဟ သူနှိုက် စားစရာမဆိသဖြင့် သူနဲ့ သူ့အဖော်တစုလို့ မွတ်သောအခါ စလိုပြုခဲ့ကျောန်းဟို နင်လို့ တခါမှ မဖတ်ဖူးသလော။ ");
INSERT INTO dnv_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ယဇ်ပုရောဟိတ်မင်း အဗျာသာလက်ထက်တွင် ဒါဝိဒ်ဟ ဘုရားသခင်ရဲ့ ဗိမာန်တော်သို့ဝင်ယွေ့ ယဇ်ပုရောဟိတ်များမှအပ ပညတ်အရ စသူမျှ မစားရသော ဆေ့တော်မုန့်ဟို စားယွေ့ သူနဲ့အတူဆိသော အပေါင်းအဖော်များအားလည်း ပေးခဲ့အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","အဲပင်းရင် ယေရှုဟ “ဥပုသ်နေ့ဟ လူသားအတွက် ဖြစ်အယ်၊ လူဟ ဥပုသ်နေ့အတွက် ဖြစ်အယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","အေးလို့မို့ လူသားဟ ဥပုသ်နေ့ရဲ့ အဆှင်ပင် ဖြစ်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ယေရှုဟ တရားဇရပ်ဟို တဖန် ဝင်ရင်၊ အဲနေရာတွင် လက်တဖက်သေသောသူ တယောက်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","လူအချို့လို့ဟ ယေရှုဟို ပစ်တင်စွပ်စွဲရန်အတွက် ဥပုသ်နေ့နှိုက် သူ့အား ပျောက်စေမယ် အဲဟာမဟုတ်ရင် မပျောက်စေဘူးဆိုတာ အနီးကပ် စောင့်ကျေ့နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ယေရှုဟ လက်တဖက်သေသောသူအား “လူတိုင်းဆေ့တွင် မတ်တတ်ရပ်လော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","အဲပင်းရင် ယေရှုဟ “ငါလို့ ပညတ်တရားအရ ဥပုသ်နေ့တွင် ကောင်းသောအရာ အဲဟာမဟုတ်ရင် ဆိုးသောအရာဟို ပြုသင့်သလော၊ လူ့အသက်ဟို ကယ်အပ်သလော အဲဟာမဟုတ်ရင် သတ်အပ်သလော” ဟု သူလို့အား မေးလေအယ်။ အားပင်မဲ့ သူလို့ဟ တိတ်တိတ်လေး နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ယေရှုဟ အူထော့လျက် သူလို့ဟို ပတ်ပတ်လည်သို့ ကျေ့လိုက်ပင်း၊ သူလို့ရဲ့ ခိုင်မာသော စိတ်နေလုံးကျောန့် ရမ်းဆာ့ ဝမ်းနည်းလျက်၊ အဲသူအား “နင့်ရဲ့ လက်ဟို ဆန့်လိုက်” ဟု ပြောလေအယ်။ သူဟ လက်ဟို ဆန့်လျှင် သူ့လက်ဟ ပြန်ကောင်းသွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","အဲပင်းရင် ဖာရိရှဲလို့ဟ တရားဇရပ်မှ တန်းသွားကြပင်း ယေရှုဟို သတ်ရန် နည်းလမ်းဟို ဟေရုဒ်ရဲ့ နောက်လိုက်များနဲ့ ခုတုံးတိုင်ပင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ယေရှုဟ တဘဲ့တော်လို့နဲ့အတူ ဂါလိလဲအိန်ဟို သွားပင်း၊ လူအုပ်ကြီးလို့ဟ သူ့နောက်ဟို လိုက်ကြအယ်။ သူလို့ဟ ဂါလိလဲပြေ၊ ယုဒပြေ၊ ");
INSERT INTO dnv_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ယေရုရှလင်မြို့၊ ဣဒုမဲနယ် ယော်ဒန်မြစ် အဆေ့ဖက်နယ်နဲ့ တုရု၊ ဇိဒုန်မြို့ အနီးနားမှ သူလို့ဟ ရောက်ဆိလာကြအယ်။ ရမ်းဆာ့သော လူလို့ဟ ယေရှုပြုလဲ့ အမှုအရာများဟို ကြားသဖြင့် သူ့ဆေသို့ လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","လူအုပ်ဟ ရမ်းဆာ့များသောကျောန့် ကိုယ်တော်ဟ မိမိအား မတိုက်မိစေရန် လှေတစင်းဟို သူ့အတွက် အဆင်သင့်ထားရန် တဘဲ့တော်လို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ကိုယ်တော်ဟ ရမ်းဆာ့သော လူလို့ဟို ကျန်းမာစေသဖြင့် ရောဂါဆိသူအားလုံးလို့ဟ ကိုယ်တော်ဟို တို့ထိနိန်ရန် တိုးဝှေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ညစ်ညူးသော နတ်ပူးနေသော သူလို့ဟ ကိုယ်တော်ဟို မျော်သောအခါ ဆေ့အူးတွင် အပြားဝပ်ယွေ့ “ကိုယ်တော်ဟ ဘုရားသခင်ရဲ့ သားတော် ဖြစ်အယ်” ဟု ဟစ်အော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ကိုယ်တော်ဟ မိမိစသူဖြစ်တာဟို တခြားသူအား မပြောရန် ညစ်ညူးသော နတ်လို့အား ကြပ်တည်းစွာ မှာထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","အဲပင်းရင် ကိုယ်တော်ဟ တောင်ပေါ်ဟို တက်ပင်း သူဟ အလိုဆိသော သူလို့ဟို သူနဲ့တူတူ ခေါ်အယ်။ သူလို့ဟ ကိုယ်တော်ဆေဟို လာကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ကိုယ်တော်ဟ တဆယ့်နေပါးလို့ဟို ရွေးချယ်ပင်း သူလို့ဟို တမန်တော်များဟု နာမယ်ပေးလေအယ်။ “ငါနဲ့အတူ ဆိစေရန် နင်လို့အား ရွေးချယ်အယ်၊ ငါဟ နင်ဟို တရားဟောဖို့ အပြင်ဟို စေလွှတ်မယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","အဲပင်းရင် နတ်ဆိုးလို့ဟို မောင်းထုတ်နိန်သော အခွင့်အာဏာဟိုလည်း ငါပေးမယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ကိုယ်တော် ရွေးချယ်ခန့်ထားသော တဆယ့်နေပါးလို့မှာ၊ ရှိမုန် (ယေရှုဟ သူ့ဟို ပေတရုလို့ နာမယ်ပေးအယ်)၊ ");
INSERT INTO dnv_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ယာကုပ်နဲ့ သူ့ညီ ယောဟန်၊ ဇေဗေဒဲရဲ့ သားများ (ကိုယ်တော် မှည့်ခေါ်သူများဟ ဗောနေဂရက်ဟူသော နာမယ်ဖြင့် “မိုးကြိုးရဲ့ သားများ” ဟု အနက်ဆိအယ်) ");
INSERT INTO dnv_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","အိန္ဒြေ၊ ဖိလိပ္ပု၊ ဗာသောလမဲ၊ မဿဲ၊ သောမ၊ အာလဖဲရဲ့ သား ယာကုပ်၊ သဒ္ဒဲ၊ မျိုးချစ်စိတ်ထက်သန်သူ ရှိမုန်နဲ့၊ ");
INSERT INTO dnv_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ယေရှုဟို သစ္စာဖောက်ခဲ့သူ ယုဒရှကာရုတ်လို့ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","အဲပင်းရင် ယေရှုဟ နေအိုင်ဟို ပြန်လေအယ်။ လူအုပ်ကြီးလို့ဟ တဖန် စုရုံးလာကြပြန်သဖြင့် ကိုယ်တော်နဲ့ တဘဲ့တော်လို့မှာ အစာစားဖို့အချိန် မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ဟေအကျောန်းဟို ကိုယ်တော်ရဲ့ မိသားစုကြားကြရင်၊ ကိုယ်တော်ဟို ထိန်းချုပ်ရန် ထွက်လာခဲ့အယ်၊ ပစာကို့ သူလို့ဟ “သူ့ဟို စိတ်ဖောက်ပြန်သွားပီ” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ယေရုရှလင်မြို့မှ လာသော ကျမ်းတတ်ဆရာ တချို့လို့ဟ “ကိုယ်တော်ဟို ဗေလဇေဗုလ နတ်ပူးနေပင်း၊ အဲနတ်ဆိုးလို့ရဲ့ အကြီးအကဲဟို အမှီပြုယွေ့ နတ်ဆိုးများဟို မောင်းထုတ်အယ်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","အဲကျောန့် ယေရှုဟ သူလို့အား သူဆေဟို ခေါ်ပင်းရင် ပုံဥပမာအားဖြင့် ပြောတာဟ “စာတန်ဟာ စာတန်ဟို စလို မောင်းထုတ်နိန်မလဲ၊” ");
INSERT INTO dnv_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","နိုင်ငံတနိုင်ငံဟ အတွင်းနှိုက် ဆန့်ကျင်ကွဲပြားနေရင်၊ အေးနိုင်ငံဟ မတည်နိန်ဝူး၊ ");
INSERT INTO dnv_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","နေအိုင် တခုဟ အတွင်းနှိုက် ဆန့်ကျင်ကွဲပြားနေရင်၊ အေးနေအိုင်ဟ မတည်နိန်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","အေးနည်းတူ စာတန်ရဲ့ နိုင်ငံဟ အုပ်စုကွဲပြားနေရင် သူဟ မရပ်တည်နိန်ဘဲ၊ ဆုံးခြင်းဟို ရောက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ခွန်အားကြီးသော သူဟို ဦးရင်ဆုံး မတုပ်ချေရင် စသူမှ သူရဲ့ နေအိုင်သို့ ဝင်ယွေ့ သူပိုင်ဆိုင်သော အရာများဟို မလုမယူနိန်၊ သူ့ဟို အရင်တုပ်ချေပင်းမှသာ လုယူနိန်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“အမန်အကန် နင်လို့အား ငါပြောတာဟ၊ လူလို့သည် မိမိတို့ ကျူးလွန်သော အပစ်များ အားလုံးနဲ့၊ ဘုရားသခင်ဟို စော်ကားပြောဆိုသမျှ အားလုံး အတွက် ခွင့်လွတ်ခြင်းခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","အဲလိုလဲ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို စော်ကားပြောဆိုရင် ဖယ်တော့မှ ခွင့်လွတ်ခြင်းရမှာ မဟုတ်၊ ပစာကို့ သူဟ ထာဝရ အပစ်ဒဏ်သင့်သောသူ ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","အေးလို့ ယေရှု ပြောရလဲ့အကျောန်းမှာ လူအချို့လို့ဟ “ကိုယ်တော်အား ညစ်ညူးသော နတ်ပူးနေသူ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","အေးအခါ ယေရှုရဲ့ အမေ့နဲ့ ညီတော်လို့ဟ ရောက်လာပင်း အပြင်တွင် ရပ်ယွေ့ တယောက်ယောက်ဟို ကိုယ်တော် ဆေသို့ စေလွတ်ယွေ့ ခေါ်ခိုင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","လူအုပ်လို့ဟ ယေရှုရဲ့ ပတ်လည်နှိုက် ထိန်နေယွေ့၊ သူလို့ဟ “ကိုယ်တော်ရဲ့ အမေ့၊ ညီတော်များနဲ့ နှမများလို့ဟ ကိုယ်တော်ဟို ဆှာလျက် အပြင်တွင် ဆိကြပါအယ်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ယေရှုဟ “ငါ့အမေ့၊ ငါ့ညီများဟ စသူလုန်း” ဟု ပြန်ယွေ့ မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","အဲပင်းရင် မိမိပတ်လည်နှိုက် ဝန်းရံလျက် ထိန်နေသူများဟို ကျေ့ရှုလျက် “ကျေ့လော့၊ ငါ့အမေနဲ့ ငါ့ညီများဟာ ဟေမှာဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ဘုရားသခင်ရဲ့ အလိုတော်အတိုင်း ဆောင်ရွက်သူမန်သမျှဟ ငါ့ညီ၊ ငါ့နှမ၊ ငါ့မေ ဖြစ်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","တဖန် ယေရှုဟ ဂါလိလဲအိန်ဖေးတွင် စတင် သွန်သင်လေအယ်။ သူ့ပတ်လည်နှိုက် စုရုံးနေသော လူအုပ်ကြီးဟ ရမ်းဆာ့များသဖြင့် ကိုယ်တော်ဟ အိန်ထဲဆိ လှေပေါ်ဟို တက်ယွေ့ ထိန်လေအယ်။ လှေဟ ယေနှိုက် ဆိနေစဉ်၊ လူအုပ်ဟ ကမ်းစပ်နားနှိုက် ရပ်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ကိုယ်တော်ဟ သူလို့ဟို ပုံဥပမာအားဖြင့် ရမ်းဆာ့သော အရာများဟို သွန်သင်ပင်း၊ သူလို့ဟို ပြောတာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“နားထောင်ကြလော့၊ မျိုးစေ့ကြဲသူ တယောက်ဟ မျိုးကြဲဖို့ ထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","သူဟ မျိုးစေ့ဟို လယ်နှိုက် ကြဲတာဟ အချို့ မျိုးစေ့လို့ဟ လမ်းတဆှောက် ကျသဖြင့်၊ ငက်လို့ဟ လာယွေ့ စားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","အချို့ မျိုးစေ့လို့ဟ မြေကတစ်သာဆိသော ကျောက်ပေါ်သော အရပ်နှိုက် ကျအယ်။ အစေ့များဟ မြေသားတိမ်သဖြင့် မကြာမီ အစေ့များ ပေါက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","နေထွက်သောအခါ ပူလောင်တာ ဖြစ်ယွေ့ အမြစ်မစွဲသောကျောန့် ညှိုးနွမ်းခြောက်သွေ့ သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","အချို့ မျိုးစေ့လို့ဟ ဆူးပင်များကြားတွင် ကျသဖြင့် ဆူးပင်များ ကြီးထွားလာပင်း အပင်ငယ်လို့ဟို လွှမ်းမိုးသဖြင့် အသီးမသီးနိန်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","အချို့ မျိုးစေ့လို့မှာ ကောင်းသောမြေတွင် ကျသဖြင့်၊ အပင်ပေါက်ယွေ့ ကြီးထွားလာလျက် သီးနှံများအယ် အချို့ဟ အဆသုံးဆယ်၊ အချို့ဟ အဆခြောက်ဆယ်၊ အချို့ဟ အဆတရာ ပွားကြအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ပီးတော့ ယေရှုဟ “ကြားရန် နားဆိသောသူ စသူမဆို၊ ကြားပါစေ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ယေရှု တယောက်တည်း ဆိသောအခါ၊ ကြားဖူးသူအချို့လို့ဟ တဘဲ့တော် တဆယ့်နေဦးလို့နဲ့ သူဆေသို့ လာယွေ့ ပုံဥပမာလို့ဟို ဆှင်းပြစေရန် အခွင့်တောင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ယေရှုဟ “နင်လို့အား ဘုရားသခင်ရဲ့ နိုင်ငံတော်နဲ့ဆိုင်သော လျှို့ဝှက်နက်နဲလဲ့ အကျောန်းအရာလို့ဟို သိနိန်ခွင့်ပေးထားပေမဲ့ အပြင်လူလို့ဟ ပုံဥပမာများအားဖြင့်သာ ကြားခွင့်ရကြအယ် ဟု ပြန်ဖြေအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ပစာကို့၊ “ ‘သူလို့ဟ မျော်သင့်ရဲ့နဲ့ မမျော်ကြ၊ နားလည်သင့်ရဲ့နဲ့ နားမလည်ကြ။ အကယ်ယွေ့သာ သူလို့မျော်ယွေ့ နားလည်ပါဟ သူလို့ဟ ဘုရားသခင်ဆေသို့ ပြန်လှည့်လာမှာမို့၊ သူလို့ဟ အဲလိုလုပ်မယ်ဆိုရင် ဘုရားသခင်ဟ သူလို့အား အပစ်ဖြေလွှတ်ပေးမယ်’ ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","အဲပင်းရင် ယေရှုဟ “နင်လို့ဟ ဟေပုံဥပမာဟို နားမလည်ဝူးလော၊ အဲလိုဖြစ်ရင် ပစာလိုမျိုး ပုံဥပမာဟို နင်လို့ နားလည်နိန်မှာမို့လုန်းဟု သူလို့ဟို ပြောအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","မျိုးစေ့ကြဲသောသူဟ ဘုရားသခင်ရဲ့ တရားစကားဟို ကြဲအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","လူအချို့လို့ဟ လမ်းမြေတွင်ကျလဲ့ မျိုးစေ့နဲ့ တူအယ်။ သူလို့ဟ တရားစကားကြားတာနဲ့ တပြိုင်နက်၊ စာတန်ဟ လာယွေ့ သူလို့နှိုက် ကြဲထားသော တရားတော်ဟို နုတ်ယူသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","အဲနည်းတူစွာ အချို့သော သူလို့ဟ ကျောက်ခံမြေတွင်ကျလဲ့ မျိုးစေ့နဲ့ တူအယ်။ သူလို့ဟ တရားတော်ဟို ကြားကြားချင်း ဝမ်းမြောက်စွာ လက်ခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","အားပင်မဲ့ တရားတော်ဟ စိတ်နေလုံးတွင် အမြစ်မစွဲဘဲ၊ ခဏဘဲ ခံအယ်။ အဲပင်းရင် ဟေတရားစကားကျောန့် ဆင်းရဲဒုက္ခ အဲဟာမဟုတ်ရင် နှိပ်စက်ညှဉ်းပမ်းမှုဟို ရောက်လာသောအခါ သူလို့ဟ ခပ်မြန်မြန်ပင် စိတ်ပျက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","အချို့သောသူလို့ဟ ဆူးတောမြေတွင် ကျသည့် မျိုးစေ့နဲ့ တူအယ်။ သူလို့ဟ တရားစကားဟို ကြားအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","အားပင်မဲ့ ဖဝါ့အတွက် စိုးရိမ်ကျောန့်ကြစရာများ၊ စည်းစိမ်ချမ်းသာ ခံစားလိုမှုများနဲ့ အခြား လိုအင်ဆန္ဒများ ပေါ်ပေါက်လာပင်းရင် အဲတရားစကားဟို လွှမ်းမိုးသဖြင့် တရားစကားဟ ပစာလိုမျှ အသီး မသီးနိန်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","အခြားသော သူများဟ ကောင်းသောမြေတွင် ကြဲလဲ့ မျိုးစေ့နဲ့ တူအယ်။ သူလို့ဟ တရားစကားဟို ကြားယွေ့ ခံယူကြအယ်ဖြစ်ရာ အချို့ဟ အဆသုံးဆယ်၊ အချို့ဟ အဆခြောက်ဆယ်၊ အချို့ဟ အဆတရာ သီးနှံများ သီးကြကုန်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ယေရှုဟ “ဆီမီးဟို တောင်းဇလားအောက် အဲဟာမဟုတ်ရင် ခုတင်အောက်တွင် ထားရန် တစုံတယောက်ဟ ယူလာလေ့ ဆိသလော။ အဲအစား ဆီမီးခုံပေါ်မှာသာ တင်ထားရန် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","အောင်းထားသော အရာမန်သမျှဟ ပွင့်လင်းစွာ ထုတ်ပြလိမ့်မယ်၊ ဖုံးအုပ်ထားသောအရာ မန်သမျှဟ ပွင့်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ကြားရန် နားဆိသောသူ စသူမဆို၊ ကြားပါစေ။” ");
INSERT INTO dnv_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","အဲပင်းရင် ကိုယ်တော်ဟ “နင်ဘာကြားလဲဆိုတာဟို အာရုံစိုက်ပါ၊ နင်လို့ဟ တပါးသူအား စီရင်လဲ့အတိုင်း ဘုရားသခင်ဟလည်း နင်ဟို စီရင်လိမ့်မယ်၊ အဲထက်မက ပိုယွေ့ ပြင်းထန်စွာ ခံရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ဆိသောသူအား ထပ်ယွေ့ပေးလိမ့်မယ်၊ မဆိသောသူဆေမှ သူနှိုက်ဆိသော အရာဟိုပင် သိမ်းယူလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","အဲပင်းရင် ယေရှုဟ ဆက်ယွေ့ ပြောတာဟ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ လူတယောက် သူရဲ့ လယ်နှိုက် မျိုးစေ့ကြဲတာနဲ့ တူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","သူဟ ညဖက်နှိုက် အိပ်ပင်း၊ နေ့ခင်းဖက်တွင် ထယွေ့ အစေ့များ အပင်ပေါက်လာတာနဲ့ တပြိုင်နက် ကြီးထွားလာအယ်။ အဲလိုလဲ စလိုဖြစ်သွားတာဟို သူမသိ။ ");
INSERT INTO dnv_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","မြေကြီးဟ သူ့တတ်တိုင်း အပင်ဟို ကြီးစေယွေ့ အသီးဟို သီးလာအယ်၊ ဦးရင်ဆုံး အညှောက်ဟို ထွက်စေအယ်၊ အဲပင်းရင် အနှံဟို ဖြစ်စေအယ်၊ နောက်ဆုံးမှာ အောင်သောအနှံဟို ဖြစ်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","စပါးနှံများ ရိတ်ချိန်ရောက်သောအခါ၊ အဲသူဟ သူရဲ့ တန်းစဉ်နဲ့ စတင်ပင်း ရိတ်အယ်၊ ပစာကို့ ရိတ်သိမ်းချိန် ရောက်လာသောကျောန့် ဖြစ်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ယေရှုဟ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်နဲ့ တူတာဟို စလိုပြောရမလုန်း၊ အဲဟာမဟုတ်ရင် ပစာပုံဥပမာဟို ငါလို့ အသုံးပြုပင်း ဆှင်းပြသင့်လဲ၊ ");
INSERT INTO dnv_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","အဲဒီအရာဟ မုန်ညင်းစေ့နဲ့ တူအယ်၊ လူတယောက်ဟ မုန်ညင်းစေ့ဟာ မြေနှိုက် စိုက်သောအခါ မြေကြီးပေါ်ဆိ အစေ့တကာလို့ထက် သေးငယ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","စိုက်ပင်းနောက် ကြီးပွားလာတာနဲ့ တပြိုင်နက် အခြားသော အသီးအရွက်အပင် အားလုံးထက် ပိုပင်း ကြီးမားအယ်။ ကြီးမားလဲ့ အကိုင်းများထွက်လာပင်း အဲအရိပ်အောက်တွင် ငက်များလာယွေ့ သူလို့ရဲ့ အသိုက်များ ပြုလုပ်နိန်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ယေရှုဟ သူရဲ့ တရားတော်ဟို လူလို့အား တခြား ပုံဥပမာများစွာဟို ဟေလိုမျိုး အသုံးပြုပင်း ဟောအယ်။ ကိုယ်တော်ဟ သူလို့ နားလည်နိန်သလောက် ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ကိုယ်တော်ဟ ပုံဥပမာ မသုံးဘဲ သူလို့ဟို မဟောပေမဲ့ ကိုယ်တော်ဟ တဘဲ့တော်တွေနဲ့ပဲ ကျန်တဲ့အချိန်မှာ သူလို့ဟို အကုန်လုံး ဆှင်းပြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","အဲနေ့တည်း ညနေချမ်းအချိန်တွင် ယေရှုဟ တဘဲ့တော်လို့အား “ငါလို့ အိန်တဖက်ကမ်းဟို ကူးကြကုန်အံ့” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","အေးကျောန့် သူလို့ဟလည်း လူအုပ်ထဲမှ ထွက်ခွာပင်း၊ တဘဲ့တော်လို့ဟ ယေရှု အဆင်သင့်ထိန်နေလဲ့ လှေထဲဟို တက်ကြယွေ့၊ ယေရှုဟို သူလို့နဲ့အတူ ခေါ်သွားကြအယ်။ အခြား လှေများလည်း ကိုယ်တော်နဲ့အတူ လိုက်ပါကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ရုတ်တရက် ပြင်းစွာသော လေတိုက်ခတ်သဖြင့်၊ လှိုင်းများဟ စတင်ပင်း လှေဟို ကျော်ယွေ့ လှေဟ ယေနဲ့ အပြေ့လောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ယေရှုဟ လှေပဲ့ပိုင်းတွင် မှီအုံးတခုပေါ်မှာ အိပ်မွေ့လျက် နေလေအယ်။ တဘဲ့တော်လို့ဟ ကိုယ်တော်ဟို နှိုးကြပင်းရင် “ဆရာ၊ ငါလို့ သေတော့မဲ့အကျောန်းဟို ကိုယ်တော် ဂရုမစိုက်တော့ဝူးလော” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ယေရှုဟ ထယွေ့ လေဟို “တိတ်တိတ်နေလော့” လှိုင်းဟိုလည်း “ငြိမ်သက်လော့” ဟု အမိန့်အာဏာနဲ့ ပြောလေအယ်၊ လေဟ ငြိမ်သွားအယ်၊ လှိုင်းလည်း မထတော့ပေ။ ");
INSERT INTO dnv_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","အဲပင်းရင် ယေရှုဟ တဘဲ့တော်လို့အား “ပစာကျောန့် ဟေလောက်ထိ ကြောက်လန့်ကြလုန်း။ အခုတိုင်အောန် နင်လို့ဟ ငါ့အပေါ်နှိုက် ယုံကြည်ကိုးစားမှု ဆိကြသေးဝူးလော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","အဲအခါ သူလို့ဟ ရမ်းဆာ့ ကြောက်လန့်ကြအယ်။ “ဟေသူရာ့ စသူရီးလုန်း။ လေနဲ့ လှိုင်းများပင်လျှင် သူ့အမိန့်ဟို နားထောင်ကြအယ်” ဟု သူလို့ချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ယေရှုနဲ့ သူ့ရဲ့ တဘဲ့တော်လို့ဟ ဂါလိလဲအိန် တဖက်ကမ်းတွင် ဆိသော ဂါဒရဒေသဟို ရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ယေရှု လှေထဲဟ ထွက်လဲ့ခဏနှိုက်၊ လူတယောက်ဟ လုတ်တိုင်းမှ ထွက်လာပင်းရင် ကိုယ်တော်နဲ့ တွေ့ဆုံခဲ့အယ်။ အေးသူထဲမှာ ညစ်ညူးသော နတ် ဆိအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","လုတ်တိုင်းဂူများ ကြားတွင် နေထိန်အယ်။ သူ့အား တယောက်မှ ကြိုးနဲ့ချေယွေ့ မရတော့ဘဲ၊ သံကြိုးနဲ့တောင်မှ တုတ်ချေယွေ့ မနိန်၊ ");
INSERT INTO dnv_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ကြိမ်ဖန်များစွာ သူရဲ့ ခြေနဲ့လက်များဟို တုတ်ချေခဲ့ဖူးသော်လည်း၊ သူဟ သံကြိုးများဟို ဖြတ်ကာ သံခြေချင်းများဟို အချိန်တိုင်း ရိုက်ဖျက်တတ်အယ်။ သူဟ ရမ်းဆာ့ အားဆိသောကျောန့် သူဟို တယောက်မှ မထိန်းချုပ်နိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","သူဟ နေ့ညမပြတ် လုတ်တိုင်းများကြားနဲ့ တောင်ကုန်းများနှိုက် လှည့်လည်ပင်း အော်လျက် ကိုယ့်တတ်တိုင်းကိုယ်ဟို ချွန်ထက်လဲ့ ကျောက်တုံးများနဲ့ လှီးဖြတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","သူဟ ယေရှုဟို အဝေးမှ မျော်သောအခါ ပြေးယွေ့၊ ဆေ့အူးနှိုက် ဒူးထောက်ပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","“အမြင့်ဆုံးသော ဘုရားသခင်ရဲ့ သားတော် ယေရှု၊ ငါ့ဟို ပစာပြုလိုလုန်း၊ ငါ့အား မနှိပ်စက်ပါနဲ့။ ဘုရားသခင်ဟို အမှီပြုယွေ့ ငါ တောင်းပန်ပါအယ်” ဟု အသံအကျယ်ရီး အော်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ယေရှုဟ သူ့ဟို “ညစ်ညူးသော နတ်၊ ဟေလူအထဲမှ ထွက်ခဲ့လော့” ဟု ပြောခဲ့သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","အေးကျောန့် ယေရှုဟ သူ့ဟို “နင့် နာမယ်ဟ ပစာရီး” ဟု မေးအယ်၊ အဲသူဟ “ငါ့ နာမယ်ဟ လေဂေါင်၊ (လူအုပ်) ဖြစ်အယ်၊ ငါလို့ဟ ရမ်းဆာ့ ဆိသောကျောန့် ဖြစ်အယ်” ဟု ဖြေအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","အဲပင်းရင် နတ်ဆိုးပူးနေသောသူဟ အဲနယ်မှ မောင်းမထုတ်ရန် ဆက်လက်ယွေ့ ယေရှုအား တောင်းပန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","အဲအရပ် အနီးနားဆိ တောင်စောင်းနှိုက် ဝက်အုပ်ကြီး တအုပ် ကျက်စားလျက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ညစ်ညူးသော နတ်များဟ “ငါလို့အား ဝက်များဆေဟို လွတ်ယွေ့၊ ငါလို့ဟို ဝက်များထဲဟို ဝင်ခွင့်ပေးပါ” ဟု ယေရှုအား တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ကိုယ်တော်ဟ သူလို့ဟို ခွင့်ပြုအယ်၊ ညစ်ညူးသော နတ်လို့ဟ အဲလူဆေမှ ထွက်သွားယွေ့ ဝက်များထဲဟို ဝင်ကြအယ်။ ၂,၀၀၀ လောက်ဆိသော ဝက်အစုဟ ချောက်ကမ်းပါးအတိုင်း အိန်ထဲဟို တဟုန်ထိုးပြေးဆင်းလျက် ယေနစ် သေဆုံးကြကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ဝက်တွေဟို ကျောင်းတဲ့သူများဟ ထွက်ပြေးယွေ့ အဲသတင်းဟ မြို့ထဲနဲ့ လယ်တောများကြားတွင် ပျံ့နှံ့ခဲ့အယ်။ လူလို့ဟ ပစာဖြစ်ပျက်တာဟို ကျေ့ရန် ထွက်လာကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","သူလို့ ယေရှုဆေဟို ရောက်လာသောအခါ၊ လေဂေါင် နတ်ဆိုး အမြဲတမ်း ပူးဝင်ခဲ့သူဟို သူလို့ မျော်ကြအယ်။ အဲမှာသူဟ အင်္ကျီဟို ဝတ်ကာ ပကတိစိတ်ဆိလျက် ထိန်နေယွေ့ သူလို့အားလုံးဟ ကြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","မျက်မြင်တွေ့ဆိသူများဟ နတ်ဆိုးပူးသူနဲ့ စလိုဖြစ်ပျက်ခဲ့တာဟို လည်းကောင်း ဝက်များရဲ့ အကျောန်းဟို လည်းကောင်း အဲလူလို့အား ပြောပြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","အဲမို့ သူလို့ဟ မိမိလို့ နယ်မှ ထွက်ခွာသွားရန် ယေရှုအား ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ယေရှုဟ လှေပေါ်ဟို တက်နေတုန်းတွင်၊ နတ်ဆိုး ပူးခဲ့သောသူဟ ကိုယ်တော်ဟို “ကိုယ်တော်နဲ့အတူ ငါ လိုက်ပါရစေ” ဟု တောင်းပန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","အဲလိုလဲ ယေရှုဟ ခွင့်မပြုပေ။ အဲအစား ယေရှုဟ သူ့ဟို “နင့်ရဲ့မိသားစု နေအိုင်သို့ ပြန်ယွေ့ ဘုရားသခင်ဟ နင့်အတွက် စလောက် လုပ်ဆောင်တာနဲ့ သူဟ စလို သနားကြင်နာသလဲဆိုတာဟို သူလို့အား ပြောပြလော့” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","အဲကျောန့် သူဟ ထွက်သွားယွေ့ မိမိအား ယေရှုဟ ပစာပြုလုပ်ခဲ့ကျောန်းဟို ဒေကာပေါလိနယ် တဆှောက်တွင် သွားယွေ့ ပြောလေအယ်။ ကြားရသောသူ အားလုံးလို့ဟ အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ယေရှုဟ အိန်ရဲ့ တဖက်ခြမ်းဟို ပြန်သွားလေအယ်။ အဲအိန်နဘေးမှာ လူအုပ်ကြီးလို့ဟ ကိုယ်တော်ဆေဟို စုဝေးလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ယာဣရုဆိုသူ တရားဇရပ်တာဝန်ခံဟ ရောက်လာယွေ့၊ သူဟ ယေရှုဟို မျော်သောအခါ သူရဲ့ ခြေရင်းမှာ ပျပ်ဝပ်ဒူးထောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ငါ့ရဲ့ မိနီငယ်ဟ သေလုနီးပါး ဖြစ်နေပါအယ်။ ကျေးဇူးပြုပင်း လာယွေ့ သူမရဲ့ အပေါ်နှိုက် နင့်ရဲ့ လက်ဟို တင်ပေးပါ၊ သူမ ရောဂါပျောက်ကင်းပင်း အသက်ဆှင်လိမ့်မယ်” ဟု အနူးအညွတ် တောင်းပန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","အဲပင်းရင် ယေရှုဟ သူနဲ့တူတူ လိုက်သွားအယ်။ ရမ်းဆာ့သော လူအုပ်လို့ဟ နောက်တော်ဟို လိုက်သဖြင့် ကိုယ်တော်ဟို တိုက်မိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","အဲနေရာနှိုက် အမျိုးသမီးတယောက်ဟ ဆယ့်နေနှစ်ပတ်လုံး သွေးသွန်ရောဂါစွဲကပ်လျက် အပြင်းအထန် ခံစားခဲ့ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","သူမဟ ရမ်းဆာ့သော ဆရာဝန်လို့ရဲ့ ကုသမှုဟို ခံရအယ်ဟုပင် ထင်ခဲ့အယ်။ သူမဟာ သူမရဲ့ ပိတ်ဆန်အားလုံးဟို အကုန်သုံးစွဲခဲ့အယ်၊ အားပင်မဲ့ ပိုကောင်းလာမဲ့အစား သူမဟ ပိုပိုဆိုးလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","သူမဟ ယေရှုအကျောန်းဟို ကြားသောအခါ၊ သူမဟ လူအုပ်ထဲမှ ထွက်လာပင်း သူရဲ့ နောက်မှ ဝတ်လုံဟို တို့ထိလိုက်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","သူမဟ “ကိုယ်တော်ရဲ့ အဝတ်တော်ဟို တို့ထိရုံမျှဖြင့်၊ ငါဟ သက်သာလိမ့်မယ်” ဟု ထင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ခုတုံးပင် သူမရဲ့ သွေးသွန်ခြင်းဟ ရပ်သွားသဖြင့် သူမ ခံစားနေရလဲ့ ဝေဒနာဟနေ လွတ်မြောက်သွားပီလို့ မိမိကိုယ်ခန္ဓာနှိုက် ခံစားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ယေရှုဟ မိမိဆေမှ တန်ခိုးထွက်တာဟို ခုတုံး သိအယ်၊ သူဟ လူအုပ်ဘက်ဟို လှည့်ယွေ့ “ငါ့ အဝတ်ဟို စသူ တို့ထိလုန်း” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","တဘဲ့တော်လို့ဟ “ကိုယ်တော်ဟို တိုးဝှေ့သော လူအုပ်ကြီးဟို မျော်နေပါလျက်၊ ငါ့ဟို စသူ တို့ထိသလဲလို့ နင် ပစာကျောန့် မေးတာလဲ” ဟု ပြန်ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","အားပင်မဲ့ ယေရှုဟ စသူဟ လုပ်ခဲ့ဟယ်ဆိုတာ မျော်ဖို့ ပတ်ပတ်လည်သို့ ကျေ့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","အဲပင်းရင် အမျိုးသမီးဟ မိမိခံစားရလဲ့အဖြစ်ဟို သိသဖြင့်၊ ကြောက်ရွံ့တုန်လှုပ်လျက် လာယွေ့ သူ့ခြေရင်းနှိုက် ဒူးထောက်လျက်၊ ဟုတ်မန်လဲ့အတိုင်း အကုန်လုံး ပြောပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ယေရှုဟ “ငါ့သမီး၊ နင့်ရဲ့ ယုံကြည်ခြင်းဟ နင့်ဟို ကျန်းမာစေပီ။ ငြိမ်းချမ်းစွာ သွားယွေ့ နင်ရဲ့ ဝေဒနာမှ ရောဂါပျောက်ကင်းစေ” ဟု သူမဟို ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","အေးလို့ ယေရှု ပြောချိန်နှိုက် ယာဣရုရဲ့ နေအိုင်မှ တမန်တချို့ ရောက်လာကြပင်း၊ “နင့်ရဲ့ သမီးဟ သေဆုံးပါပီ၊ ဆရာဟို ပစာကျောန့် နှောင့်ယှက်သေးလုန်း” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ယေရှုဟ ဂရုမစိုက်ဘဲ “မကြောက်ကြနဲ့၊ ယုံကြည်ခြင်းသာ ဆိလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","အဲပင်းရင် ကိုယ်တော်ဟ ပေတရု၊ ယာကုပ်၊ သူရဲ့ ညီ ယောဟန်တို့မှလွဲယွေ့ စသူဟိုမျှ မိမိနဲ့တူတူ သွားခွင့်ပြုတော်မမူ။ ");
INSERT INTO dnv_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","တရားဇရပ်တာဝန်ခံရဲ့ နေအိုင်ဟို ရောက်သောအခါ၊ ယေရှုဟ လူလို့ တအုံးထဲဖြစ်လျက် ကျယ်လောင်စွာ ငိုကယွေ့ မြည်တမ်းနေကြတာဟို မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ကိုယ်တော်ဟ ဝင်ယွေ့ အဲသူလို့အား၊ “နင်လို့ ပစာကျောန့် တအုံးထဲဖြစ်နေကြလုန်း။ ပစာကျောန့် ငိုကနေကြလုန်း။ မိနီငယ်ဟ သေတာ မဟုတ်၊ အိပ်မွေ့နေစာရီး” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","အဲအခါ သူလို့ဟ ကိုယ်တော်ဟို လှောင်ပြောင်ရယ်မောကြအယ်။ ကိုယ်တော်ဟ သူလို့ဟို ပြင်ဟို မောင်းထုတ်လိုက်ပင်း မိနီငယ်ရဲ့ မိဖလို့နဲ့ ကိုယ်တော်နဲ့တူတူ တဘဲ့တော် သုံးဦးလို့ဟို ခေါ်ယွေ့၊ မိနီငယ်လဲလျောင်းရာ အခန်းဆေဟို ဝင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","သူဟ မိနီငယ်ရဲ့ လက်ဟို ဆုပ်ကိုင်ကာ “တလိသ ကုမိ” အဓိပ္ပာယ်မှာ “မိနီငယ်၊ ထလော့၊ နင့်အား ငါဆိုအယ်” ဟု ဆိုလိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ခုတုံးပင် မိနီငယ်ဟ ထယွေ့ စတင် လမ်းဆှောက်အယ် (သူမဟ တဆယ့်နေနှစ်အရွယ် ဆိအယ်။) အဲလိုဖြစ်သောအခါ သူလို့ဟ ရမ်းဆာ့အံဩကြကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","အားပင်မဲ့ ယေရှုဟ သူလို့အား စသူဟိုမျှ မပြောရန် ကြပ်တည်းစွာ မိန့်မှာပင်း၊ “မိနီငယ်ဟို ပစာငြမ်းငြမ်း ကျွေးလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ယေရှုဟ အဲနေရာမှ ထွက်ခွာယွေ့ မိမိရဲ့ မွေးရပ်ဇာတိမြို့ဟို လှည့်ပြန်လာအယ်၊ သူ့ရဲ့ တဘဲ့တော်လို့ဟလည်း လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ဥပုသ်နေ့တွင် ကိုယ်တော်ဟ တရားဇရပ်ထဲတွင် စတင် သွန်သင်လေအယ်။ အဲမှာဆိသော ရမ်းဆာ့သော လူဟ၊ ကိုယ်တော် သွန်သင်ချက်ဟို ကြားသောအခါ၊ သူလို့အားလုံးဟ အံ့ဩကြအယ်။ “သူဟ ဟေအရာများ အားလုံးဟို ပစာဟ ရလုန်း” ဟု သူလို့ မေးကြအယ်။ “သူ့ဟို ပေးသော ပညာဟ ပစာလုန်း၊ သူဟ နိမိတ်လက္ခဏာများဟို စလိုမျိုး လုပ်ဆောင်နိန်လုန်း၊ ");
INSERT INTO dnv_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","သူဟ လက်သမား မဟုတ်လော၊ မာရိရဲ့ အောင်နီငယ်ဖြစ်ပင်း ယာကုပ်၊ ယောသပ်၊ ယုဒနဲ့ ရှိမုန်လို့ရဲ့ ညီအကို မဟုတ်လော၊ သူ့ရဲ့ နှမများဟလည်း အေးမှာနေတာ မဟုတ်လော” ဟု မေးအယ်။ အေးကျောန့် သူလို့ဟ ကိုယ်တော်ဟို ငြင်းပယ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ယေရှုဟ သူလို့အား “ပရောဖက်ဟ သူလို့ရဲ့ ကိုယ်ပိုင် မွေးရပ်ဇာတိမြို့၊ သူလို့ ဆွေမျိုးများ၊ သူလို့ မိသားစုဆေမှလွဲယွေ့ နေရာတိုင်းတွင် လေးစားကြအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ကိုယ်တော်ဟ ဖျားနာသူအနည်းငယ်လို့အပေါ် လက်ဟိုတင်ယွေ့ သူလို့ဟို ကျန်းမာစေခြင်း မှတပါး၊ အဲနေရာတွင် ပစာနိမိတ်လက္ခဏာဟိုမျှ မပြနိန်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ကိုယ်တော်ဟ ရမ်းဆာ့အံဩခဲ့အယ်၊ ပစာကို့ လူများလို့ဟ ယုံကြည်ခြင်း မဆိကြဝူး။ အဲပင်းရင် ယေရှုဟ ပတ်ဝန်းကျင်ဆိ ရွာများဟို လှည့်လည်သွားယွေ့၊ လူလို့အား သွန်သင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","တဘဲ့တော် တဆယ့်နေဦးလို့ဟို ခေါ်ယွေ့ နေယောက်စီတွဲယွေ့ သူလို့ဟို စေလွတ်လေအယ်။ သူလို့အား ညစ်ညူးသော နတ်များဟို နိန်သော အခွင့်အာဏာဟို ပေးယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","သူလို့ဟို “လမ်းခရီးအတွက် တောင်ဝှေးတခုမှလွဲရင် တခြား ပစာအရာဟိုမျှ မယူကြနဲ့၊ မုန့်၊ လွယ်အိုက်၊ အိတ်ကပ်ထဲ ပိတ်ဆန်များဟို မထည့်သွားကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ဖိနပ်ဟို စီးလော့၊ သို့ရာတွင် အင်္ကျီအပို မသယ်ဆောင်ကြနဲ့” ဟု မှာထားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","သူလို့အား “ဖယ်အရပ်တွင် မဆို နင့်ဟို ကြိုဆိုရင်၊ အဲအရပ်မှ ပြန်ထွက်ခွာလဲ့တိုင်အောန် အေးအိုင်မှာ နေကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","နင်လို့ မြို့ထဲဟိုလာရင် အဲလူများဟ နင်လို့ဟို မကြိုဆိုရင် အဲဟာမဟုတ်ရင် နင့်စကားဟို နားမထောင်ရင်၊ အေးဟနေ ထွက်ခွာယွေ့ နင်လို့ ခြေဖဝါးမှ မြေမှုန့်ဟို ခါချခဲ့လိုက်ကြ။ အဲဒါဟ သူလို့ဟို သတိပေးလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","အဲကျောန့် သူလို့ဟ ထွက်သွားယွေ့ လူများ မိမိလို့ အပစ်များမှ နောင်တရကြရန် ဟောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","သူလို့ဟ ရမ်းဆာ့သော နတ်ဆိုးများဟို မောင်းထုတ်ကြအယ်၊ ဖျားနာသောသူများစွာဟို သံလွင်ဆီလိမ်းယွေ့ ကျန်းမာစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ယေရှုရဲ့ ဂုဏ်သတင်းဟ နေရာတိုင်း ပျံ့နှံ့လာသောကျောန့် ဟေရုဒ်မင်းကြီးဟ အဲကျောန်းအားလုံးဟို ကြားလေအယ်။ လူအချို့လို့ဟ “နှစ်ခြင်းဆရာ ယောဟန် အသက်ပြန်ဆှင်လာအယ်၊ အေးလို့မို့ သူနှိုက် တန်ခိုးနိမိတ်လက္ခဏာများ ပြဖို့အတွက် အဲလိုမျိုး ဆိနေအယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","အခြားသူများဟ “သူဟ ဧလိယဖြစ်အယ်” ဟု ဆိုကြအယ်။ အခြားသောသူများဟလည်း၊ “သူဟ ဟိုးမခင်အခါဟ ပရောဖက် တယောက်ယောက်လိုမျိုး ပရောဖက်တယောက်ဖြစ်အယ်” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ဟေရုဒ်ဟ အေးအကျောန်းဟို ကြားသောအခါ သူဟ “ငါဟ သူရဲ့ ဦးခေါင်းဖြတ်ခဲ့ပေမဲ့လည်း ယောဟန်ဟ အသက်ပြန်ဆှင်လာပီ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ဟေရုဒ်ဟ သူ့တတ်တိုင်း ယောဟန်ဟို ဖမ်းဆီးဖို့ အမိန့်ပေးခဲ့ယွေ့၊ ယောဟန်ဟို တုတ်ချေပင်း ထောင်ထဲဟို ထည့်ခဲ့အယ်။ အေးအရာဟို ဟေရုဒ် လုပ်ခဲ့အယ် ပစာကို့ သူမဟ မိမိညီ ဖိလိပ္ပုရဲ့ ပေါင်အိုမ ဖြစ်ပေမဲ့လည်း၊ သူဟ ဟေရောဒိဟို လက်ထပ်သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ယောဟန်ဟ ဟေရုဒ်အား “နင့်အကိုရဲ့ ပေါင်အိုမဟို လက်ထပ်တာဟ နင့်အတွက် မမန်ကန်ဝူး” ဟု ဆက်လက်ပင်း ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","အေးကျောန့် ဟေရောဒိဟ ယောဟန်ဟို ရန်ငြိုးထားယွေ့ သတ်ချင်ပေမဲ့ သူမဟ ဟေရုဒ်ကျောန့် သတ်ရန် မတတ်နိန်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ယောဟန်ဟ ဖြောင့်မတ် သန့်ဆှင်းသောသူဖြစ်ကျောန်းဟို ဟေရုဒ် သိသဖြင့် ကြောက်ယွေ့၊ သူ့အား ဘေးမဲ့လုံခြုံစွာ ထားအယ်။ ဟေရုဒ်ဟ ယောဟန်ရဲ့ သွန်သင်ချက်များဟို ကြားနာရလဲ့ အချိန်တိုင်း စိတ်အနှောင့်အယှက် ဖြစ်တတ်သော်လည်း နှစ်သက်စွာ နားထောင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","နောက်ဆုံးမှာ ဟေရောဒိဟ အခွင့်အခါရလာအယ်။ အေးစာဟ ဟေရုဒ်ရဲ့ မွေးနေ့မှာဖြစ်ပင်း ဟေရုဒ်ဟ ဂါလိလဲပြေမှ ခေါင်းဆောင်ကြီးများ၊ တပ်မတော် အရာဆိကြီးများ၊ အစိုးရ အကြီးအကဲဖြစ်သော သူလို့အားလုံးဟို ကျွေးမွေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ဟေရောဒိရဲ့ သမီး ဟ လာယွေ့ ကပြလျက် ဟေရုဒ်နဲ့ သူရဲ့ ဧည့်သည်များရဲ့ စိတ်ဟို နှစ်သက်စေအယ်။ အဲကျောန့် ဆှင်ဘုရင်ဟ မိနီငယ်အား “နင်အလိုဆိသမျှသော အရာဟို တောင်းလော့၊ နင့်လိုချင်လဲ့ အရာဟို ငါပေးမယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","သူဟ “နင်တောင်းသမျှ ဖယ်အရာမဆို ငါ ပေးမယ်၊ ငါ့ တိုင်းပြည် တဝက်တိုင်အောန် နင့်ဟို ငါပေးမယ်လို့ ကျိန်ဆိုယွေ့” တိုင်တည်ခြင်းယွေ့ သူမဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","အေးကျောန့် မိနီငယ်ဟ ထွက်သွားကာ သူမေ့အား “ငါ ပစာအရာဟို တောင်းရမလဲ” ဟု မေးအယ်။ အမေ့ဟ “နှစ်ခြင်းဆရာ ယောဟန်ရဲ့ ဦးခေါင်း” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","မိနီငယ်ဟ ခုတင်ချင်း ဆှင်ဘုရင်ဆေဟို အလျင်အမြန်ဝင်ယွေ့ “နှစ်ခြင်းဆရာ ယောဟန်ရဲ့ ဦးခေါင်းဟို ဟေလင်ပန်းပေါ်တွင် တင်ယွေ့ ခုတင်ချင်း ကျွန်မအား ပေးစေချင်ပါအယ်” ဟု တောင်းဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","အဲဒါဟ ဆှင်ဘုရင်ဟို ရမ်းဆာ့ စိတ်မကောင်း ဖြစ်ပေမဲ့ မိနီငယ်ရဲ့ တောင်းဆှောက်ချက်ဟို မငြင်းမပယ်နိန် ပစာကို့ သူရဲ့ ဧည့်သည်တော်များ ဆေ့တွင် မိမိတိုင်တည်ယွေ့ ပေးခဲ့လဲ့ကတိဟို ပြုခဲ့သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","အေးလို့မို့ ယောဟန်ရဲ့ ဦးခေါင်းဟို ယူလာခဲ့ရန် အမိန့်ပေးယွေ့ အာဏာပါးကွက်သား တယောက်ဟို ခုတင်ချင်း စေလွှတ်လိုက်အယ်။ အာဏာပါးကွက်သားဟ အကျဉ်းထောင်ဟို သွားယွေ့၊ ယောဟန်ရဲ့ ဦးခေါင်းဟို ဖြတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","အဲပင်းရင် သူဟ ဦးခေါင်းဟို လင်ပန်းပေါ်တွင် တင်ယွေ့ ယူလာပင်း မိနီငယ်ဟို ပေးယွေ့၊ မိနီငယ်ဟလည်း အဲအရာဟို သူ့မေအား ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","အဲဒါဟို ကြားတာနဲ့၊ ယောဟန်ရဲ့ တဘဲ့လို့ဟ လာယွေ့ သူရဲ့ အလောင်းဟို ယူယွေ့ လုတ်တိုင်းတွင်းနှိုက် ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","တမန်တော်လို့ဟ ယေရှုနဲ့ တွေ့ဆုံဖို့ ပြန်လာပင်း၊ မိမိလို့ ပြုခဲ့သမျှနဲ့ သွန်သင်ခဲ့သမျှလို့ဟို ကိုယ်တော်ဟို ကြားပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ရမ်းဆာ့သော လူလို့ဟ ဝင်ထွက်သွားလာလျက် ဆိကြသဖြင့် ယေရှုနဲ့ သူရဲ့ တဘဲ့တော်လို့ဟ အစားအစာစားဖို့ အချိန်ပင် မရကြ။ အဲမို့ ကိုယ်တော်ဟ “ငါလို့ တိတ်ဆိတ်သော နေရာတခုဟို ခဏအနားယူဖို့ သွားကြစို့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","အေးလိုမို့ သူလို့ဟ ဆိတ်ကွယ်ရာအရပ်ဟို သူလို့ချဲချဲ လှေဖြင့် စတင်ထွက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","အားပင်မဲ့ သူလို့ ထွက်သွားတာဟို ရမ်းဆာ့သော တွေ့တဲ့သူလေဟ သူလို့ဟို မှတ်မိပင်း မြို့အားလုံးဟနေ ခြေချင်ပြေးပင်း သူလို့ဆေ့ဟို ရောက်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ယေရှုဟ လှေမှ တက်သောအခါ လူအုပ်ကြီးဟို မျော်ရင်၊ သူလို့ဟ သိုးထိန်း မဆိသော သိုးများနဲ့ တူသောကျောန့် သူလို့ကို သနားခြင်း ဆိအယ်။ အေးလိုမို့ ကိုယ်တော်ဟ သူလို့ဟို ရမ်းဆာ့သော အရာလို့ဟို စတင်သွန်သင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","မိုးချုပ်စပြုသောအခါ၊ တဘဲ့တော်လို့ဟ ကိုယ်တော်ဆေဟို လာယွေ့ ပြောကြအယ်၊ “ဟေအရပ်ဟ လူသူမဆိလဲ့ အရပ်တခုဖြစ်ပင်း အချိန်လည်း နောက်ကျပါပီ။ ");
INSERT INTO dnv_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","သူလို့ဟ အနီးအနား ကျေးရွာများဟို သွားယွေ့ စားစရာတခုခုဟို ဝယ်နိန်ရန် လူလို့အား အဝေးဟို စေလွှတ်ပါ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ယေရှုဟ “နင်လို့တတ်တိုင်း သူလို့အား စားစရာ ပစာငြမ်းငြမ်း ပေးလော့” ဟု ပြန်ဖြေအယ်။ အဲအခါ တဘဲ့တော်လို့ဟ “ငါလို့ဟ ငွေဒင်္ဂါး ၂၀၀ ဖိုးဖြင့် စားစရာဝယ်ယွေ့ သူလို့အား ကျွေးရမယ်လော” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ယေရှုဟ “နင်လို့နှိုက် မုန့်ပစာလောက် ဆိလုန်း၊ သွားယွေ့ ကျေ့ကြလော့” ဟု မေးလေအယ်။ သူလို့ဟ တွေ့ကြလဲ့အခါ “မုန့်ငါးလုံးနဲ့ ငါးနေကောင် ဆိပါအယ်” ဟု ပြန်ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","အဲပင်းရင် ယေရှုဟ လူအပေါင်းလို့ဟို မြက်ခင်း စိမ်းပေါ်တွင် အစုလိုက် ထိန်စေရန် သူလို့အား ညွှန်ကြားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","လူလို့ဟ အစုလိုက် တရာစီ၊ ငါးဆယ်စီ အစုလိုက်ဖြင့် စီတန်း ထိန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","အဲပင်းရင် ကိုယ်တော်ဟ မုန့်ငါးလုံးနဲ့ ငါးနေကောင်ဟို ယူယွေ့ မိုးခေါန်းခင်ဟို မော်ကျေ့လျက် ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟို ချီးမွန်းအယ်။ သူဟ မုန့်ဟို ဖဲ့ပင်း လူလို့အား ဝေပေးရန် တဘဲ့တော်လို့အား ပေးအယ်။ သူဟ ငါးနေကောင်ဟိုလည်း သူလို့အား ခွဲဝေပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","သူလို့အားလုံးဟ စားပင်း ကျေနပ်ခဲ့ကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","အဲပင်းရင် တဘဲ့တော်လို့ဟ မုန့်နဲ့ ငါးအကျိုးအပဲ့ဟို ကောက်သိမ်းရာ တဆယ့်နေတောင်း အပြေ့ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","မုန့်စားသူ ယောက်ျားဦးရေမှာ ၅,၀၀၀ ဆိလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ယေရှုဟ ခုတုံးပင် တဘဲ့တော်လို့အား လှေတစင်းပေါ်ဟို တက်ယွေ့ အိန်ရဲ့ တခြားတဖက်ဆိ ဗက်ဇဲဒမြို့ဟို ဦးရင်ကူးနှင့်စေပင်း၊ တချိန်တည်းပင် လူအုပ်ဟို အဝေးဟို ပြန်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","လူအပေါင်းလို့ဟို နှုတ်ဆက်ပင်းနောက်၊ ကိုယ်တော်ဟ ဆုတောင်းရန် တောင်ပေါ်ဟို တက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ညခင်းချိန် ကျရောက်သောအခါ၊ လှေဟ အိန်အလယ်နှိုက် ဆိလျက်နေအယ်၊ အဲအချိန်နှိုက် ကိုယ်တော်ဟ ကုန်းပေါ်မှာ တယောက်တည်း ဆိနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","လေဆန်သောကျောန့် တဘဲ့တော်လို့ဟ တက်ခတ်ယွေ့ ပင်ပန်းကြတာဟို မျော်သောအခါ ကိုယ်တော်ဟ ယေပေါ်မှာ လမ်းဆှောက်ယွေ့ သူလို့ဆေဟို လာအယ်။ အချိန်ဟ မိုးမလင်းခင် ဖြစ်အယ်၊ ကိုယ်တော်ဟ သူလို့ အနီးမှ ဖြတ်ကျော်ယွေ့ သွားအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","သူလို့ဟ ယေပေါ်မှာ ကိုယ်တော် လမ်းဆှောက်နေတာဟို မျော်ကြအယ်။ သူလို့ဟ “ကဆေ” ဟု ထင်မှတ်ယွေ့ အော်ကကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","သူလို့အားလုံးဟ ကိုယ်တော်ဟို မျော်သောအခါ ကြောက်လန့်နေကြအယ်။ အဲအခါ ကိုယ်တော်ဟ “အားမငယ်ကြနဲ့၊ ငါရီးဝဲ့၊ မကြောက်ကြနဲ့” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","အဲပင်းရင် သူလို့ဆိရာ လှေပေါ်ဟို ကိုယ်တော်ဟ တက်လျှင် လေဟ ငြိမ်သပ်သွားအယ်။ သူလို့ဟ ရမ်းဆာ့ အံ့ဩကြကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ပစာကို့ လူ ၅,၀၀၀ ဟို ကိုယ်တော် ကျွေးစဉ်ဟ မိမိလို့ တွေ့မြင်ခဲ့လဲ့ အရာရဲ့ အဓိပ္ပာယ်ဟို သူလို့ နားမလည်ခဲ့ကြသောကျောန့် ဖြစ်အယ်၊ သူလို့ရဲ့ စိတ်နေလုံး မာကြောလျက် ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","သူလို့ဟ အိန်သို့ ကူးကြယွေ့ ဂင်နေသရက်မြို့ဟို ရောက်ရင်၊ သူလို့ဟ လှေဟို ချေခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","သူလို့ဟ လှေမှ ဆင်းဆင်းချင်း၊ လူလို့ဟ ကိုယ်တော်ဟို မှတ်မိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","သူလို့ဟ ပတ်ဝန်းကျင်အရပ်ရပ်ဟို ပြေးသွားယွေ့ ကိုယ်တော်ဆိလဲ့ သူလို့ ကြားလဲ့နေရာဟို လူနာများဟို ထမ်းစင်များနဲ့ မခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ယေရှုဟ နေရာတိုင်း၊ ကျေးရွာများ၊ မြို့များ၊ လယ်တောများဟို သွားယွေ့၊ လူလို့ဟ လူနာများအား ဆေးဟို ခေါ်သွားယွေ့ ကိုယ်တော်ရဲ့ ဝတ်လုံဖျားဟို တို့ထိခွင့်ပြုရန် တောင်းပန်ကြအယ်။ တို့ထိခွင့်ရသော သူလို့ဟ ကျန်းမာလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ဖာရိရှဲအချို့လို့နဲ့ ယေရုရှလင်မြို့မှ ရောက်လာကြသော ကျမ်းတတ်ဆရာလို့ဟ ယေရှု ဆေဟို စုဝေးလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","အဲဒါဟို သူလို့ဟ သတိထားမိအယ် တဘဲ့တော် တချို့လို့ဟ မစင်ကြယ်သော လက်များနဲ့ စားသောက်နေကြတာဟို တွေ့မျော်ကြအယ်၊ အဲဟာဟ သူလို့ဟ ဖာရိရှဲလို့ ပြောလဲ့တိုင်းတိုင်း သူလို့ဟ လက်မဆေးကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ဖာရိရှဲများနဲ့ ယုဒအမျိုးသားအပေါင်းလို့ဟ ဆေ့လူကြီးလို့ရဲ့ သွန်သင်ချက်များဟို လက်ခံပင်း လိုက်နာကြအယ်။ လက်ဟို ဦးရင် မဆေးကြောဘဲ အစားအစာ စားလေ့ မဆိကြ၊ ");
INSERT INTO dnv_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ဆေးမှ ဝယ်လာလဲ့အရာဟို အရင်မဆေးကြောရင် သူလို့ဟ ပစာအရာဟိုမျှ မစားကြ။ ပီးတော့ သင့်တော်သော နည်းလမ်းများဖြင့် အိုးများ၊ မုတ်များ၊ ကြေးဖလားများနဲ့ အိပ်ယာများဟို ဆေးကြောခြင်းနဲ့ ပတ်သက်ယွေ့၊ သူလို့ဟ ၎င်းလို့ရဆိထားသော အခြား စည်းမျဉ်းများစွာဟို လိုက်နာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","အေးကျောန့် ဖာရိရှဲနဲ့ ကျမ်းတတ်ဆရာများဟ “နင့်ရဲ့ တဘဲ့များဟ ပစာကျောန့် ငါလို့ ဖိုးဘေးများ ပေးခဲ့သော သွန်သင်ခြင်းဟို မလိုက်နာဘဲ၊ မသန့်ဆှင်းသော လက်ဖြင့် အစာစားကြလုန်း” ဟု ယေရှုအား မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ကိုယ်တော်ဟ သူလို့အား “နင်လို့ရဲ့အကျောန်း ဟေရှာယ ပရောဖက်ပြုသောအခါ မန်လွန်းလှအယ်၊ နင်လို့ဟ သူတော်ကောင်းဟန်ဆောင်သူများ ဖြစ်အယ်။ သူရေးသားထားဟ၊ “ ‘ဟေလူမျိုးဟာ ငါ့ဟို စလောင်ဖြင့် သူလို့ ရိုသေကြအယ်၊ အဲလိုလဲ သူလို့ရဲ့ စိတ်နေလုံးဟ ငါနဲ့ အမန်တကယ် ဝေးလှအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","သူလို့ဟ ငါ့ဟို အလကားကား ကိုးကွယ်ကြအယ်၊ ပစာကို့ သူလို့ဟ လူ့စည်းမျဉ်း ဟို သင်ကြားပေးအယ်၊ အဲလိုလဲ သူလို့ဟ ဘုရားသခင်ရဲ့ ပညတ်တွေပါပဲ’ ဟု ရေးသားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“နင်လို့ဟ ဘုရားသခင်ရဲ့ ပညတ်တော်ဟို ပယ်ယွေ့ လူလို့ရဲ့ စလေ့ထုံးတမ်းများဟို လိုက်နာအယ်” ဟု သူလို့ဟို ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","အေးပင်း ကိုယ်တော်ဟ ဆက်ယွေ့ “နင်လို့ဟ မိမိလို့ရဲ့ သွန်သင်ချက်များဟို တည်စေရန်၊ ဘုရားသခင်ရဲ့ ပညတ်လို့ဟို ငြင်းပယ်တဲ့ နည်းလမ်းမှာ တော်လှပေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","အကျောန်းမှာ မောရှေ ပညတ်ထားတာဟ ‘နင့် မိဖဟို ရိုသေလော့၊’ အဲပင်း ‘စသူမဆို သူ့မေ့ အဲဟာမဟုတ်ရင် အဖဟို ကျိန်ဆဲရင် သေဒဏ်ခံရမယ်၊’ ");
INSERT INTO dnv_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","အဲလိုလဲ နင်လို့ အဲလိုသင်ပေးရင် လူတဦးဟ သူ့အဖ အဲဟာမဟုတ်ရင် အမေအား အကျိုးပြုစေမယ့် တစုံတရာဆိအယ် ဆိုတာဟ၊ ‘အေးတာဟ ကော်ဘန် ဖြစ်အယ်’ ဟု ပြောအယ် (အဲ အဓိပ္ပာယ်မှာ ဘုရားသခင်ပိုင်လဲ့ အရာဖြစ်အယ်)၊ ");
INSERT INTO dnv_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","သူလို့ဟ သူ့မိဖဟို ကူညီဖို့ ခွင့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","အေးနည်းအတိုင်း နင်လို့ သူတပါးများအား လက်ဆင့်ကမ်း ပေးအပ်ကြလဲ့ သွန်သင်ချက်များအားဖြင့် ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တော်ဟို ပယ်ဖျက်ကြအယ်။ အေးလို့ပုံစံမျိုးပင် ရမ်းဆာ့သော တခြားအရာလို့ဟိုလည်း နင်လို့လုပ်ကြအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","အဲပင်းရင် ယေရှုဟ လူအုပ်လို့အား သူ့ဆေဟို တဖန်ခေါ်ပင်း ပြောအယ်၊ “ငါ့ စကားဟို နင်လို့အားလုံး နားထောင်ယွေ့၊ နားလည်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","လူရဲ့ အပြင်မှ ဝင်လဲ့အရာဟ လူဟို စုတ်ပဲ့စေနိန်ဝူး။ အတွင်းမှ ထွက်လဲ့အရာဟသာ လူဟို စုတ်ပဲ့စေနိန်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ကိုယ်တော်ဟ လူအုပ်ဆေမှ ထွက်သွားယွေ့ နေအိုင်ဟို ဝင်သောအခါ၊ သူရဲ့ တဘဲ့တော်လို့ဟ ပုံဥပမာအကျောန်းဟို သူ့အား မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ယေရှုဟ “နင်လို့ဟ တခြားသူတွေထက် အသိဉာဏ်ကင်းမဲ့လျက် နေကြသလော” ဟု သူလို့ဟို ပြောအယ်။ “နင်လို့ဟ နားမလည်ကြဝူးလော၊ ပြင်ပမှ လူရဲ့ အတွင်းဟို ဝင်လဲ့အရာ လူဟို မစုတ်ပဲ့စေနိန်တာဟို နင်လို့ မသိကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ပစာကို့ အဲအရာဟ နင့်ရဲ့ စိတ်နေလုံးထဲဟို ဝင်တာမဟုတ်ပင်မဲ့ နင့်ရဲ့ အစာအိမ်ထဲဟို ဝင်ပင်း၊ ခန္ဓာကိုယ်မှ ထွက်သွားအယ်” ဟု ပြောလေအယ်။ အေးလို့ ပြောခြင်းမှာ၊ ယေရှုဟ အစားအစာအားလုံးဟ သန့်ဆှင်းကျောန်း ကြေညာခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ကိုယ်တော်ဟ ဆက်ပြောအယ်၊ “လူရဲ့ အတွင်းမှ ထွက်လဲ့အရာဟ လူဟို စုတ်ပဲ့စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","အကျောန်းမှာ လူအတွင်းဆိ စိတ်နေလုံးထဲမှ မကောင်းသော အကြံများ ထွက်လာအယ်၊ အဲဒီအရာတွေဟ မတရားသော မေထုန်ပြုခြင်း၊ သူ့ဥစ္စာဟို ခိုးခြင်း၊ လူ့အသက်ဟို သတ်ခြင်း၊ ");
INSERT INTO dnv_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","သူတပါး မယားဟို ပစ်မားခြင်း၊ လောဘလွန်ကျူးခြင်း၊ ဆိုးယုတ်မိုက်မဲခြင်း၊ လိမ်လည်လှည့်စားခြင်း၊ တရားလက်လွတ်ပြုမူခြင်း၊ မနာလိုခြင်း၊ သူ့အသရေဟိုဖျက်ခြင်း၊ မာနထောင်လွှားခြင်း၊ လျှပ်ပေါ်ခြင်း၊ ");
INSERT INTO dnv_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","အစဆိသော ဆိုးညစ်လဲ့အရာအားလုံးဟ လူ့အတွင်းမှ ထွက်လာယွေ့ လူဟို စုတ်ပဲ့စေအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ယေရှုဟ အဲအရပ်မှ ထွက်ခွာယွေ့ တုရုမြို့ အနီး နယ်များဟို သွားလေအယ်။ သူဟ နေအိုင်တအိုင်ထဲဟို ဝင်သွားပင်း ကိုယ်တော်ဟ ဆိနေကျောန်း စသူဟိုမျှ မသိစေလိုပေမဲ့ သူဟ အောင်းယွေ့ မနေနိန်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ညစ်ညူးသော နတ်ပူးဝင်နေသော မိနီငယ် တအူးရဲ့မိခင်ဟ ယေရှု အကျောန်းဟို ကြားရင် တန်းလာယွေ့ သူရဲ့ ခြေတော်ရင်းတွင် ဒူးထောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","အဲအမျိုးသမီးဟ ရှုရိတွင် ဆိသော ဖိနိတ်နယ်မှ မွေးဖွားလဲ့၊ တပါးအမျိုးသား ဖြစ်အယ်။ မိမိရဲ့ သမီးထဲမှ နတ်ဆိုးဟို မောင်းထုတ်ပေးရန် ယေရှုအား တောင်းပန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","အားပင်မဲ့ ယေရှုဟ “လူပဲ့သငယ်လို့ဟို ဦးရင် ဝအောန်ကျွေးပါရစေ။ လူပဲ့သငယ်လို့ရဲ့ အစားအစာဟို ယူယွေ့ ခွေးများဆေ လောချခြင်းဟ မမန်ပေ” ဟု သူမအား ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","အဲအမျိုးသမီးဟ “သခင်ဘုရား၊ စားပွဲအောက်မှ ခွေးလို့ပင် လူပဲ့သငယ်လို့ရဲ့ အစာ အစနများဟို စားရကြပါအယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","အဲအခါ ယေရှုဟ “ဟေလိုမျိုးသော အဖြေအတွက်၊ နင်ဟ နေအိုင်ဟို သွားနိန်ပီ၊ ပစာကို့ နတ်ဆိုးဟ နင့်သမီးဆေမှ ထွက်ခွာသွားလေပီ” ဟု သူမအား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","အဲအမျိုးသမီးဟ သူ့နေအိုင်ဟို ပြန်ရောက်ပင်း အိပ်ယာထဲမှာ လဲလျောင်းနေသော မိမိရဲ့ သမီးငယ်ဟို တွေ့ရအယ်၊ နတ်ဆိုးဟ သူမဆေမှ အမန်ကယ် ထွက်သွားခဲ့ပင်းကျောန်း သိရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","အဲပင်းရင် ယေရှုဟ တုရုမြို့ရဲ့ အနီးဝန်းကျင်မှ ထွက်ခွာပင်း ဇိဒုန်မြို့မှတဆင့်၊ ဂါလိလဲအိန်ဟို ဖြတ်ယွေ့ ဒေကာပေါလိနယ်ဟို ဆက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","လူအချို့လို့ဟ ဆွံ့အနားပင်းသူ တယောက်ဟို ကိုယ်တော်ဆေသို့ ဆောင်ခဲ့ကြပင်း၊ သူ့ပေါ်တွင် လက်တော်ဟို တင်ပေးရန် ယေရှုအား တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ယေရှုဟ သူ့အား လူအုပ်နဲ့ ဝေးရာဟို ခေါ်သွားပင်းရင် ကိုယ်တော်ဟ သူရဲ့ လက်ချောင်းများဟို သူရဲ့ နားထဲဟို ထည့်လေအယ်။ အဲပင်းရင် ကိုယ်တော်ဟ ဆံထွေး ထွေးပင်း သူရဲ့ လျှာဟို တို့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","အဲပင်းရင် ယေရှုဟ မိုးခေါန်းခင်သို့ မျှော်ကျေ့လျက်၊ သက်ပြင်းချကာ “ဧဖသ” ဟု သူ့အား ပြောလေအယ်။ ဧဖသ အဓိပ္ပာယ်မှာ “ပွင့်စေ” ဟု ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ခုတုံးပင် သူရဲ့ နားလို့ဟ ပွင့်သွားအယ်၊ သူရဲ့ လျှာဟ ပြေလျော့သွားပင်း သူဟ ပြတ်ပြတ်သားသား စတင် ပြောလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ယေရှုဟ သူလို့ဟို စသူ့ဟိုမျှ မပြောဖို့ အမိန့်ပေးအယ်။ အားပင်မဲ့ ကိုယ်တော်ဟ တားမြစ်လေလေ၊ သူလို့ဟ အဲသတင်းဟို ပိုယွေ့ ပြောကြားလေ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ကြားရသူအပေါင်းလို့ဟ ရမ်းဆာ့ အံ့ဩကြအယ်။ “ကိုယ်တော်ဟ အရာအားလုံးဟို စလောက် ကောင်းကောင်းလုပ်အယ်၊ သူဟ နားပင်းသူလို့ဟို ကြားစေပင်း ဆွံ့အသူလို့ဟို စကားပြောစေပီ” ဟု သူလို့ဟ ကြွေးကြော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","သိပ်မကြာခင် တခြား လူအုပ်ကြီး စုဆုံလာကြအယ်။ လူလို့နှိုက် စားဖို့ မကျန်သောအခါ၊ ယေရှုဟ တဘဲ့တော်လို့ဟို သူဆေဟို ခေါ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ဟေလူတွေအတွက် ငါ သနားအယ်၊ ပစာကို့ သူလို့ဟ သုံးရက်လုံးလုံး ငါနဲ့တူတူ ဆိကြပီမို့ အခု သူလို့မှာ စားစရာမဆိ။ ");
INSERT INTO dnv_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","တချို့သော သူများဟ အဝေးမှ လာကြသောကျောန့်၊ သူလို့ဟို မကျွေးမွေးဘဲ ငါဟ နေအိုင်ဟို ပြန်လွှတ်ရင်၊ သူလို့ဟ လမ်းနှိုက် မူးမေ့သွားလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","သူရဲ့ တဘဲ့တော်လို့ဟ “ဟေလူသူကင်းမဲ့သော နေရာမှာ စသူကမှ အေးလူအားလုံးဟို ကျွေးဖို့ လုံလောက်တဲ့ အစားအစာဟို စသူဆှာနိန်လုန်း” ဟု သူ့ဟို မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ယေရှုဟ “နင်မှာ မုန့်စလောက် ဆိလုန်း” ဟု မေးလေအယ်။ သူလို့ဟ “မုန့်ခုနေလုံး ဆိပါအယ်” ဟု ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ကိုယ်တော်ဟ လူအပေါင်းလို့ဟို မြေပေါ်တွင် ထိန်စေရန် အမိန့်ပေးအယ်။ အဲပင်းရင် မုန့်ခုနေလုံးဟို ယူပင်း၊ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟို ချီးမွန်းယွေ့၊ မုန့်ဟိုဖဲ့ကာ လူအုပ်လို့အား ဝေပေးရန် သူရဲ့ တဘဲ့တော်လို့ဟို ပေးအယ်၊ အဲပင်း တဘဲ့တော်လို့ဟလည်း လူအုပ်အား ဝေပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","သူလို့နှိုက် ငါးကတစ်လည်း ဆိအယ်။ ယေရှုဟ အဲအတွက် ကျေးဇူးတော်ဟို ချီးမွန်းယွေ့ သူလို့အား ဝေပေးရန် တဘဲ့တော်လို့ဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","လူတိုင်းဟ လုံလောက်စွာ စားရပင်း အဲမှာ လူ ၄,၀၀၀ လောက် ဆိလေအယ်။ အဲပင်းရင် တဘဲ့တော်လို့ဟ ကျန်တာဟို ကောက်သိမ်းယွေ့ ခုနေတောင်း အကျိုးအပဲ့များ အပြေ့ရကြအယ်။ ယေရှုဟ လူလို့ဟို အဝေးဟို ထွက်ခွာစေပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","သူရဲ့ တဘဲ့တော်လို့နဲ့အတူ လှေပေါ်ဟို ခုတုံးတက်ယွေ့ ဒါလမနုသ နယ်များသို့ သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ဖာရိရှဲအချို့လို့ဟ ယေရှုဆေဟို လာယွေ့ ကိုယ်တော်နဲ့ စတင်ပင်း ငြင်းခုံကြအယ်။ သူလို့ဟ ကိုယ်တော်ဟို ထောင်ချောက်ဆင်ချင်ကြအယ်၊ အဲလိုမို့ သူလို့ဟ ကိုယ်တော်ဟို ဘုရားသခင် နှစ်သက်ကျောန်း ပြသရန် နိမိတ်လက္ခဏာ ပြုလုပ်ရန် သူ့ဟို တောင်းဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","အဲလိုလဲ ယေရှုဟ သက်ပြင်းချပင်းတော့ “ဟေနေ့ခေတ် လူများဟ နိမိတ်လက္ခဏာဟို ပစာကျောန့် တောင်းကြလုန်း၊ ငါ နင့်ဟို ပြောတာဟ၊ ဒီလိုလူတွေဟ သက်သေဟို ပေးလိမ့်မယ် မဟုတ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ကိုယ်တော်ဟ သူလို့ ဆေမှ ထွက်ယွေ့၊ လှေထဲဟို ပြန်လာပင်း အိန်တဖက်သို့ စတင်ပင်း ကူးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","တဘဲ့တော်လို့ဟ မုန့်အလုံအလောက် ယူလာရန် မေ့သွားပင်း လှေပေါ်တွင် သူလို့နဲ့အတူ မုန့်တလုံးသာ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ယေရှုဟ “ဂရုစိုက်မန့်” ဟု သူလို့အား သတိပေးအယ်၊ “နင်လို့ဟာ ဖာရိရှဲများရဲ့ တဆေးနဲ့ ဟေရုဒ်ရဲ့ တဆေးဟို သတိနဲ့ ဆှောင်ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","သူလို့ဟ စတင်ပင်း သူလို့အချင်းချင်း ဆွေးနွေးကြတာဟ “ငါလို့မှာ ပစာမုန့်မှ မဆိသောကျောန့် သူဟ ဟေလို့ ပြောအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","သူလို့ ပစာပြောဆိုနေတာဟို ယေရှု သိသောကျောန့် ကိုယ်တော်ဟ သူလို့အား “နင်လို့ မုန့်မပါတဲ့အကျောန်းဟို ပစာကို့ ဆွေးနွေးကြလုန်း၊ နင်လို့ မသိသေးသလော အဲဟာမဟုတ်ရင် နားမလည်ကြဝူးလော၊ နင်လို့ရဲ့ စိတ်နေလုံးဟ မာကျောနေသေးသလော။ ");
INSERT INTO dnv_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","နင်လို့မှာ မျက်စေ့ဆိလျက် မမျော်နိန်ကြ၊ နင်လို့မှာ နားဆိလျက် မကြားနိန်ကြ၊ မမှတ်မိကြဝူးလော၊ ");
INSERT INTO dnv_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","မုန့်ငါးလုံးဟို လူ ၅,၀၀၀ အတွက် ငါ ချိုးဖဲ့သောအခါ၊ အကျိုးအပဲ့များဟို တောင်းအပြေ့ စမတောင်း ကောက်သိမ်းခဲ့ကြလုန်း” ဟု မေးအယ်။ သူလို့ဟ “ဆယ့်နေတောင်း” ဟု ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ငါဟ လူ ၄,၀၀၀ အတွက် မုန့်ခုနစ်လုံးဟို ဖဲ့ခဲ့စဉ်၊ မုန့်အကျိုးအပဲ့များဟို စမတောင်းအပြေ့ ကောက်သိမ်းရကြလုန်း” ဟု ကိုယ်တော်ဟ မေးလေအယ်။ သူလို့ဟ “ခုနေတောင်း ကောက်သိမ်းကြပါအယ်” ဟု ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ကိုယ်တော်ဟ “နင်လို့ဟ နားမလည်ကြသေးဝူးလော” ဟု သူလို့အား မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","သူလို့ဟ ဗက်ဇဲဒမြို့သို့ လာကြအယ်၊ လူအချို့လို့ဟ မျက်စေ့မမျော်လဲ့ တယောက်အား ယေရှုဆေဟို ခေါ်လာယွေ့ အဲသူအား တို့ထိပေးရန် တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ယေရှုဟ မျက်စေ့မမျော်သောသူအား လက်ဆွဲကာ ရွာအပြင်ဟို ခေါ်သွားအယ်။ သူရဲ့ မျက်စေ့များဟို ဆံထွေး ထွေးယွေ့ ကိုယ်တော်ဟ သူရဲ့ အပေါ်မှာ လက်ဟို တင်ပင်း၊ “နင်ဟ တစုံတခုဟို မျော်ပီလော” ဟု သူ့အား မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","သူဟ မျော်ကျေ့ပင်း ပြောတာဟ၊ “ငါဟ လူလို့ဟို မျော်နိန်ပေမဲ့ သူလို့ဟ လမ်းဆှောက်နေလဲ့ သစ်ပင်တွေနဲ့ တူအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ယေရှုဟ အဲသူရဲ့ မျက်စေ့ပေါ်တွင် လက်ဟို နောက်တခါ တင်လေအယ်။ ဒီတခါတော့ အဲသူဟ စူးစူးစိုက်စိုက် ကျေ့ရာ၊ သူ့မျက်စေ့ မျော်လာပင်း အရာအားလုံးဟို ဆှင်းဆှင်းလင်းလင်း မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ယေရှုဟ သူ့အား နေအိုင်ဟို ပြန်ဖို့ အမိန့်ပေးယွေ့၊ “ရွာထဲဟို မပြန်နဲ့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","အဲပင်းရင် ယေရှုနဲ့ သူရဲ့ တဘဲ့တော်လို့ဟ ကဲသရိ ဖိလိပ္ပု ကျေးရွာများ အနီးသို့ သွားကြအယ်။ လမ်းတွင် ကိုယ်တော်ဟ “ငါ့ဟို ပြောမန့်၊ လူလို့ဟ ငါ့ဟို စသူလို့ ပြောသလော” ဟု သူလို့အား မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","သူလို့ဟ “အချို့ဟ နှစ်ခြင်းယောဟန်ဟု ပြောအယ်၊ အချို့ဟ ဧလိယဟု ပြောပင်း၊ အချို့ဟ ပရောဖက်တပါးပါး ဖြစ်အယ်ဟု ပြောကြအယ်” ဟု ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ကိုယ်တော်ဟ “နင်လို့ဟရော ငါ့ဟို စသူဖြစ်အယ်ဟု ဆိုကြလုန်း” ဟု သူလို့အား မေးလေအယ်။ ပေတရုဟ “ကိုယ်တော်ဟ မေဆှိယ ဖြစ်အယ်” ဟု ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","အဲပင်းရင် ယေရှုဟ “ငါ့အကျောန်း စသူဟိုမှ မပြောနဲ့” ဟု သူလို့အား မိန့်မှာခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","အဲပင်းရင် ယေရှုဟ “လူသားဟ ရမ်းဆာ့သော ဒုက္ခဝေဒနာ ခံစားလျက် အသက်ကြီးသူများ၊ ယဇ်ပုရောဟိတ်ကြီးများ၊ ကျမ်းတတ်ဆရာများရဲ့ ငြင်းပယ်ခြင်းဟို ခံရမယ်။ သူဟ အသတ်ခံရလိမ့်မယ်၊ အဲလိုလဲ နောက်သုံးရက်အကြာတွင် သူဟ ထမြောက်လိမ့်မယ်” ဟု သူရဲ့ တဘဲ့တော်လို့အား စတင် သွန်သင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","သူဟ အဲအကျောန်းဟို သူလို့အား ဆှင်းဆှင်းလင်းလင်း ဖြစ်စေအယ်။ အဲလိုမို့ ပေတရုဟ ကိုယ်တော့်ဟို ဘေးဖက်ဟို ခေါ်ပင်း သူ့ဟို အပစ်တင်စကား စတင်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","အဲလိုလဲ ယေရှုဟ လှည့်ကျေ့လျက်၊ တဘဲ့တော်လို့ဟို ကျေ့ပင်း ပေတရုဟို ဆုံးမလေအယ်။ “စာတန်၊ ငါ့ဆေမှ ထွက်သွားလော့၊ နင်ရဲ့ အတွေးတွေဟ ဘုရားသခင်ဆေမှ လာတာမဟုတ်ပေမဲ့ လူ့ သဘောသဘာဝဘဲ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","အဲပင်းရင် ယေရှုဟ သူရဲ့ တဘဲ့တော်လို့နဲ့တကွ လူအုပ်ဟို ခေါ်ပင်း ပြောတာဟ၊ “ငါ့တဘဲ့ဖြစ်လို သူတိုင်းဟ ကိုယ့်ကိုယ်ဟို ငြင်းပယ်ပင်း သူလို့ရဲ့ လက်ဝါးကပ်တိုင်ဟို ထမ်းယွေ့ ငါ့နောက်ဟို လိုက်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","အကျောန်းမှာ သူလို့ရဲ့ အသက်ဟို ကယ်တင်လိုသောသူဟ အသက် ဆုံးရှုံးရလိမ့်မယ်၊ အဲလိုလဲ ငါ့အတွက် သူလို့ရဲ့ အသက်နဲ့ ဧဝံဂေလိတရားအတွက် အသက်ဆုံးရှုံးသောသူဟ ကယ်တင်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","တစုံတယောက်သောသူဟ ကမ္ဘာလောကတခုလုံးဟို ရယူသော်လည်း သူလို့ရဲ့ စိတ်ဝိညာဉ်ဆုံးရှုံးရင် ပစာအကျိုးဆိမှာမို့လုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","အဲဟာမဟုတ်ရင် စသူ့ဟိုမျှ သူလို့ရဲ့ စိတ်ဝိညာဉ်အတွက် ပစာအရာနဲ့ ရွေးနိန်လုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ဟေဘုရားတရားမဲ့နဲ့ ဆိုးသွမ်းသောနေ့နှိုက် နင်ဟ ငါနဲ့ ငါ့သွန်သင်ချက်ဟို ဆှက်ရင်၊ သန့်ဆှင်းသော ခေါန်းခင်တမန်လို့နဲ့အတူ ခမည်းတော်ဟ ဘုန်းတန်ခိုးနဲ့ ကြွလာသောအခါ လူသားဟ နင်လို့ဟို ဆှက်လိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","အဲပင်းရင် ကိုယ်တော်ဟ သူလို့ဟို “နင်ဟို အမန် ငါပြောတာဟ၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ တန်ခိုးနဲ့အတူ လာတာဟို မမျော်ခင်အထိ ဟေအရပ်ဆိ လူအချို့လို့ဟာ မသေရကြ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ခြောက်ရက်ပင်းနောက် ယေရှုဟ ပေတရု၊ ယာကုပ်နဲ့ ယောဟန်လို့ဟို သူနဲ့အတူ ခေါ်ယွေ့ တောင်မြင့်ပေါ်ဟို သူလို့ဟို ယိုးပင်း တက်ခဲ့အယ်၊ အေးအရပ်မှာ သူလို့ဘဲ ဆိအယ်။ အေးမှာ ယေရှုဟ သူလို့ဆေ့မှာ အဆင်းသဏ္ဌာန်ပြောင်းလဲလာခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ကိုယ်တော်ရဲ့ အဝတ်များဟ ဖြူဖွေးတောက်ပလာအယ်၊ ဟေလောကထဲမှာ စသူမှ အေးလောက် ဖြူဖွေးအောန် သူလို့ မဖွတ်နိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","အေးနောက် ဧလိယနဲ့ မောရှေဟ ယေရှုနဲ့အတူ စကားပြောနေတာဟို တဘဲ့တော်သုံးဦးလို့ဟ မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ပေတရုဟ စကားပြောယွေ့ ယေရှုဟို ပြောတာဟ “ဆရာ၊ ဟေအရပ်တွင် ငါလို့အတွက် နေဖို့ကောင်းပါအယ်၊ ကိုယ်တော်ဖို့ တဲတဆောင်၊ မောရှေဖို့ တဲတဆောင်နဲ့ ဧလိယဖို့ တဲတဆောင်၊ တဲသုံးဆောင်ဟို ငါလို့ ဆောက်ပါရစေ။” ");
INSERT INTO dnv_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ပေတရုနဲ့ တခြားသူများဟ ရမ်းဆာ့ ကြောက်လန့်သွားကြသဖြင့် ပစာပြောရမန်းဟို မသိသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","အဲပင်းရင် မိုးချေးသားတခုဟ ပေါ်လာယွေ့ သူလို့ဟို မိုးတိမ်ရိပ်နဲ့အတူ အုပ်ကာ “ဟေသူဟာ ငါ့ချစ်သား ဖြစ်အယ်၊ သူရဲ့ စကားဟို နားထောင်လော့” ဟု မိုးချေးသားဟ အသံထွက်ပေါ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","တဘဲ့တော်လို့ဟ မိမိလို့ပတ်လည်ဟို ဝေ့ကျေ့ကြသော်လည်း ယေရှုမှလွဲယွေ့ တခြားပစာသူဟိုမျှ မမျော်ရတော့ပေ။ ");
INSERT INTO dnv_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","သူလို့ တောင်ပေါ်မှ ဆင်းလာစဉ်၊ ယေရှုဟ သူလို့အား မိန့်တာဟ “လူသားဟ သေခြင်းမှ မထမြောက်ခင်အချိန်ထိ၊ နင်လို့ ပစာမျော်ခဲ့လဲ့အရာဟို တယောက်ဟိုမှ မပြောကြနဲ့။” ");
INSERT INTO dnv_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","သူလို့ဟ ကိုယ်တော်ရဲ့ အမိန့်ဟို နားထောင်အယ်၊ အဲလိုလဲ သူလို့အချင်းချင်း အေးကိစ္စဟို စတင်ပင်း ဆွေးနွေးကြအယ် “‘သေခြင်းမှ ထမြောက်မယ်’ ပစာအရာဟို ဆိုလိုလုန်း၊” ");
INSERT INTO dnv_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","အဲအခါ သူလို့ဟ ယေရှုအား “ဧလိယ အရင်လာရမယ်လို့ ပစာကျောန့် ကျမ်းတတ်ဆရာလို့ဟ ပြောလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ယေရှုဟ “ဧလိယဟ အရာအားလုံးဟို အဆင်သင့်ဖြစ်ရန် ဦးရင်ဆုံးလာခြင်းမှာ တကယ်ပင် ဖြစ်အယ်၊ လူသားဟ ရမ်းဆာ့သော ဒုက္ခဆင်းရဲဟို ခံရပင်း ငြင်းပယ်ခံရလိမ့်မယ်လို့ ကျမ်းစာဟ ပစာကျောန့်ပြောလုန်း၊ ");
INSERT INTO dnv_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","အဲလိုလဲ ငါနင့်ဟို ပြောတာဟ ဧလိယဟ ကြွလာပင်း သူ့အကျောန်း ရေးထားလဲ့အတိုင်း၊ သူလို့ ဆန္ဒဆိသမျှ အရာအားလုံး သူ့အပေါ်ပြုလုပ်ခဲ့အယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","သူလို့ဟ တခြားတဘဲ့တော်များဆေဟို လာကြသောအခါ၊ လူအုပ်ကြီးဟ သူလို့ဟို ဝိုင်းယွေ့ ကျမ်းတတ်ဆရာများဟ သူလို့နဲ့ ငြင်းခုန်ကနေတာဟို သူလို့ မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","လူလို့ဟ ယေရှုဟို မျော်သောအခါ၊ သူလို့ဟ ရမ်းဆာ့ အံ့ဩကြလျက်၊ ကိုယ်တော်ဆေဟို ပြေးယွေ့ နှုတ်ဆက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ယေရှုဟ တဘဲ့တော်လို့အား “နင်လို့ဟ သူလို့နဲ့ ပစာအကျောန်းဟို ငြင်းခုန်နေကြလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","လူအုပ်ထဲမှ လူတယောက်ဟ “ဆရာ၊ ငါ့ရဲ့ သားဟို ကိုယ်တော်ဆေသို့ ခေါ်ခဲ့အယ်၊ ပစာကို့ သူထဲမှာ ညစ်ညူးသောနတ် ဆိနေပင်း၊ စကားမပြောနိန်သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","နတ်ဆိုးဟ သူ့ဟို တိုက်ခိုက်လဲ့အခါတိုင်း၊ သူဟို မြေပေါ်သို့ လဲချပင်း၊ သူဟ စလောင်နှိုက် အမြုပ်များ ထွက်လျက်၊ အံသွားကြိတ်ကာ တကိုယ်လုံး မာတောင့်လာတတ်အယ်။ ငါဟ ကိုယ်တော်ရဲ့ တဘဲ့တော်များအား ဝိညာဉ်ဟို မောင်းထုတ်ပေးရန် ပြောအယ်၊ အဲလိုလဲ သူလို့ဟ မတတ်နိန်ကြပါ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ယေရှု ပြန်ပြောတာဟ “ယုံကြည်ခြင်း မဆိသော နင်လို့ မျိုးဆက်၊ ငါဟ နင်လို့နဲ့အတူ ပစာလောက်ကြာအောန် နေရမလုန်း၊ ငါ နင်လို့နဲ့အတူ စလောက်ကြာအောန် သည်းခံရမလုန်း၊ အောင်နီငယ်ဟို ငါ့ဆေသို့ ခေါ်ခဲ့ကြ။” ");
INSERT INTO dnv_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","အေးကျောန့် သူလို့ဟ အောင်နီငယ်ဟို ယေရှုဆေဟို ခေါ်ခဲ့ကြအယ်။ ဝိညာဉ်ဟ ယေရှုဟို မျော်ရင်၊ အောင်နီငယ်ဟ ခုတင်ချင်း တုန်လှုပ်သွားအယ်။ အောင်နီငယ်ဟ မြေပေါ်ဟို လဲကျကာ လူးလှိမ့်လျက် စလောင်မှ အမြှုပ်များ ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“သူဟေလို ဖြစ်နေတာ စလောက်ကြာပီလုန်း” ဟု အောင်နီငယ်ရဲ့ အဖအား ယေရှု မေးလေအယ်။ “လူပဲ့အရွယ်ကတည်းထဲဟ” ဟု သူဟ ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ဝိညာဉ်ဟ သူ့အား သေစေဖို့ မီးနဲ့ ယေထဲဟို လောချရန် အကြိမ်များစွာ ကြိုးစားခဲ့အယ်။ ကိုယ်တော် ဖြစ်နိန်ရင်၊ ငါလို့ဟို သနားပါ၊ ငါလို့ဟို ကူညီပါ၊” ");
INSERT INTO dnv_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ယေရှုဟ “ဟုတ်ပီ” ဟု ပြောပင်း၊ “နင်လို့တတ်တိုင်း တတ်နိန်ရင် ယုံကြည်ခြင်းဆိသူအတွက် အရာအားလုံး ဖြစ်နိန်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ခုတုံးပင် အောင်နီငယ်ရဲ့ အဖဟ ငိုကယွေ့ “ငါ ယုံကြည်ခြင်း ဆိအယ်၊ အဲလိုလဲ မလုံလောက်ပါ။ ငါ့ဟို ပိုဆိရစေဖို့ ကူညီမန့်၊” ");
INSERT INTO dnv_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","လူအုပ်များ ပြေးလာကြတာဟို ယေရှု မျော်သောအခါ၊ ကိုယ်တော်ဟ ညစ်ညူးသောနတ်ဟို ဆုံးမလျက် “နားပင်းယွေ့ စကားအသောနတ်၊ သူထဲမှ ထွက်လော့၊ ပစာခါမျှ သူ့ထဲဟို ပြန်မဝင်နဲ့၊ ငါ နင့်ဟို အမိန့်ပေးအယ်” ဟု ကိုယ်တော်ဟ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ညစ်ညူးသောနတ်ဟ အော်ကပင်း အောင်နီငယ်ဟို ပြင်းထန်စွာ တွန်းလှန်ပင်း သူ့ထဲမှ ထွက်သွားအယ်။ အောင်နီငယ်ဟ လူသေနဲ့ ရမ်းဆာ့တူပင်း လူများဟ “အောင်နီငယ် သေပီ” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","အဲလိုလဲ ယေရှုဟ အောင်နီငယ်ရဲ့ လက်ဟို ကိုင်ပင်း သူ့ဟို ထဖို့ ကူညီပေးခဲ့အယ်။ အဲအခါ အောင်နီငယ်ဟ ထလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ယေရှုဟ နေအိုင်ထဲသို့ ဝင်ပင်းနောက် သူရဲ့ တဘဲ့တော်လို့ဟ “ငါလို့ဟ ပစာကျောန့် နတ်ဆိုးဟို မမောင်းထုတ်နိန်ခဲ့တာလုန်း” ဟု သူ့ဟို သီးသန့်မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ယေရှုဟ “ဆုတောင်းခြင်းသာလျှင် ဟေအရာဟို မောင်းထုတ်နိန်အယ်၊ အခြားအရာ ဆိဝူး” ဟု ဖြေကြားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ယေရှုနဲ့ သူရဲ့ တဘဲ့တော်လို့ဟာ အဲအရပ်မှ ထွက်ယွေ့ ဂါလိလဲပြေဟို ဖြတ်သွားကြအယ်။ ယေရှုဟ သူပစာနေရာမှာ ဆိနေတာဟို စသူ့ဟိုမျှ မသိစေချင်ပေ၊ ");
INSERT INTO dnv_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ပစာကို့ ကိုယ်တော်ဟ သူရဲ့ တဘဲ့တော်လို့ဟို သင်ကြားပေးတာဟ “လူသားဟ လူလို့ လက်ဟို အပ်နှံခြင်း ခံရလိမ့်မယ်။ သူလို့ဟ သူ့ဟို သတ်ကြလိမ့်မယ်၊ သူဟ သုံးရက်လွန်ပင်းမှ ထမြောက်လိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","အဲလိုလဲ သူလို့ဟ ကိုယ်တော် ပစာဆိုလိုတာဟို နားမလည်ဘဲနဲ့ သူ့အကျောန်းဟို မေးဖို့ ကြောက်ရွံ့နေခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","သူလို့ဟ ကပေရနောင်မြို့ဟို လာကြအယ်။ သူလို့ဟ နေအိုင်နှိုက် ဆိနေစဉ်၊ ယေရှုဟ “လမ်းမှာ နင် ပစာငြင်းခုံနေစာလုန်း” ဟု သူလို့အား မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","အဲလိုလဲ သူလို့ဟ တိတ်ဆိတ်နေခဲ့အယ်၊ ပစာကို့ စသူဟ အကြီးမြတ်ဆုံးလဲဆိုတာဟို လမ်းမှာ ငြင်းခုံနေခဲ့ပင်းသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ယေရှုဟ ထိန်လျက်၊ တဘဲ့တော် တဆယ့်နေပါးလို့ဟို ခေါ်ပင်းမှ၊ “စသူမဆို ပထမဖြစ်လိုသူဟ နောက်ဆုံးနှိုက် နေရာယူပင်း အားလုံးရဲ့ ကျွန်လည်းဖြစ်ရမယ်” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","အဲပင်းရင် ကိုယ်တော်ဟ လူပဲ့တယောက်ဟို ခေါ်ယွေ့ သူလို့ဆေ့တွင် ရပ်ခိုင်းအယ်။ ကိုယ်တော်ဟ သူ့ဟို ကွေ့ပင်း သူလို့ဟို ပြောအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ဟေလူပဲ့များထဲမှ တစုံတယောက်ဟို ငါရဲ့ နာမယ်နှိုက် လက်ခံသောသူဟ ငါ့ဟို လက်ခံအယ်၊ ငါ့ဟို လက်ခံသောသူ စသူဟ ငါ့ဟို သာမကဘဲ ငါ့ဟို စေလွှတ်သောသူဟိုလည်း လက်ခံအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ယောဟန်ဟ “ဆရာ၊ ကိုယ်တော်ရဲ့ နာမယ်နဲ့ နတ်မိစ္ဆာလို့ဟို မောင်းထုတ်နေလဲ့ လူတယောက်ဟို ငါလို့ တွေ့ခဲ့အယ်၊ ပစာကို့ သူဟ ငါလို့ အုပ်စုနဲ့ မဆိုင်လဲ့အတွက်၊ ရပ်ဖို့ သူ့ဟို ပြောခဲ့အယ်” ဟု သူ့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ယေရှုဟ “သူ့ဟို တားဖို့ မကြိုးစားကြနဲ့၊ ပစာကို့ ငါရဲ့ နာမနှိုက် အံ့ဖွယ်သောအမှုဟို ပြုသောသူဟ ငါနှိုက် မကောင်းသောအရာလို့ဟို မကြာမီ ပြောဆိုနိန်လိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ငါလို့အား မဆန့်ကျင်သူဟ ငါလို့အတွက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","အမန်အကန် နင်လို့အား ငါဆိုတာဟ၊ ငါရဲ့ နာမဟို အမှီပြုယွေ့ နင်လို့အား ယေတမုတ်ပေးသောသူ စသူမဆို နင်လို့ရဲ့အကျိုးဟို မဆုံးရှုံးစေရ။ ");
INSERT INTO dnv_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ငါ့ဟို ယုံကြည်သော ဟေလူပဲ့သငယ် တစုံတယောက်ဟ တစုံတယောက်ဟို မားယွင်းစေရင်၊ သူလို့ရဲ့ လည်ပင်းနှိုက် ကြိတ်ဆုံကြီးဟို ဆွဲထားပင်း ပင်လယ်ထဲဟို လောချရင် သူလို့အတွက် ပိုကောင်းလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","နင့်ရဲ့လက်ဟ နင့်ယုံကြည်ခြင်းဟို ဆုံးရှုံးစေဟယ်ဆိုရင်၊ ဖြတ်လောပလိုက်။ လက်နေဖက်ပါလျက် မီးမငြိမ်းနိန်လဲ့ ငရဲဟို သွားရတာထက် လက်တဖက်ထဲနဲ့ အသက်ဆှင်ခြင်းသို့ ဝင်ရတာဟ နင့်အတွက် သာယွေ့ ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","နင့်ရဲ့ ခြေထောက်ဟ နင့်ယုံကြည်ခြင်းဟို ဆုံးရှုံးစေအယ်ဆိုရင်၊ ဖြတ်လောပလိုက်။ ခြေထောက်နေဖက်ပါလျက် ငရဲထဲဟို လောချခြင်း ခံရတာထက် ခြေထောက်တဖက်မပါဘဲနဲ့ အသက်ဆှင်ခြင်းသို့ ဝင်စားရတာဟ နင့်အတွက် သာယွေ့ ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","နင့်ရဲ့ မျက်စေ့ဟ နင့်ယုံကြည်ခြင်းဟို ဆုံးရှုံးစေအယ်ဆိုရင်၊ ထုတ်လောပလိုက်။ မျက်စေ့နေလုံးပါလျက် ငရဲထဲဟို လောချခြင်း ခံရတာထက် မျက်စေ့တလုံးထဲနဲ့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်သို့ ဝင်စားရတာဟ သာယွေ့ ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","အဲဒီမှာ သူလို့ဟို စားလဲ့ လောက်ကောင်တွေဟ ပစာခါမှ မသေဝူး၊ သူလို့ဟို လောင်လဲ့မီးဟ ပစာခါမှ မငြိမ်းဝူး။ ");
INSERT INTO dnv_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ယဇ်ကောင်ဟို ဆားဖြင့် သန့်စင်စေသလို လူတိုင်း မီးဖြင့် သန့်စင်စေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ဆားဟ ကောင်းအယ်၊ အဲလိုလဲ အငန်ကင်းပျောက်သွားရင် ဆားအား ပစာလို ပြန်ယွေ့ ငန်အောန် ပြုနိန်ပါမလုန်း။ “နင်လို့ဟ မိမိတတ်တိုင်းနှိုက် မိတ်ဆွေဖွဲ့ခြင်းဟူသော ဆားဆိစေပင်း၊ အချင်းချင်း ငြိမ်းချမ်းစွာနေကြလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","အဲပင်းရင် ယေရှုဟ အေးအရပ်မှ ထွက်ခွာယွေ့၊ ယုဒပြေသို့ သွားပင်းရင်၊ ယော်ဒန်မြစ်ဟို ကူးလေအယ်။ လူအုပ်လို့ဟ ကိုယ်တော်နားဟို နောက်တခါလာရောက် စုပြုံနေယွေ့၊ ကိုယ်တော်ဟ လုပ်ကျင့်ဆိလဲ့အတိုင်း သူလို့အား သွန်သင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ဖာရိရှဲတချို့လို့ဟ ကိုယ်တော်ဆေဟို လာယွေ့ သူ့အား ထောင်ချောက်ဆင်ရန် ကြိုးစားအယ်။ သူလို့ဟ “ငါလို့ဟို ပြောမန့်၊ ငါလို့ရဲ့ ဥပဒေဟ ယောက်ျားတယောက်ဟ သူရဲ့ ပေါင်အိုမဟို ကွာဆှင်းခွင့်ပြုလော့” ဟု သူလို့ မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ယေရှုဟ ပြန်ပြောတာဟ “မောရှေဟ နင်လို့အား ပစာလို ပညတ်ထားလုန်း။” ");
INSERT INTO dnv_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","သူလို့ဟလည်း “မောရှေဟ ယောက်ျားတယောက်အား ကွာဆှင်းပြတ်စဲခြင်းဆိုင်ရာ စာတစောင်ရေးရန်နဲ့ သူရဲ့ ပေါင်အိုမဟို အဝေးဟို ပို့ရန် ခွင့်ပြုပေးခဲ့အယ်” ဟု ဖြေကြားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ယေရှုဟ သူလို့အား “နင်လို့ဟ သွန်သင်ရန် ရမ်းဆာ့ ခက်သောကျောန့် နင်လို့အတွက် ဟေပညတ်ဟို မောရှေရေးခဲ့ခြင်းဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","အဲလိုလဲ ဖန်ဆင်းခြင်းရဲ့အစမှာ ဘုရားသခင်ဟ ‘ယောက်ျားနဲ့ မိန်းမဟို ဖန်ဆင်းထားအယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘ဟေအကျောန်းအတွက်ကျောန့် ယောက်ျားဟ ကိုယ့်မိဖဟို စွန့်ယွေ့ မိမိပေါင်အိုမနဲ့ တလုံးတဝတည်း ဖြစ်ရမယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ပင်းတော့ အဲသူနေဦးလို့ဟာ တသားတကိုယ်တည်း ဖြစ်လာကြလိမ့်မယ်။’ အေးလို့မို့ သူလို့ဟ နေဦး မဟုတ်တော့ဘဲ တသားတကိုယ်တည်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","အေးကျောန့် ဘုရားသခင်ဟ အတူတကွ ပေါင်းစည်းပေးထားသော အရာဖြစ်ယွေ့ စသူမှ မကွဲကွာစေနဲ့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","တဘဲ့တော်လို့ဟ နေအိုင်ဟို ပြန်ရောက်ကြသောအခါ၊ အေးကိစ္စအကျောန်းဟို ယေရှုအား မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ယေရှုဟ သူလို့အား “သူရဲ့ ပေါင်အိုမဟို ကွာဆှင်းယွေ့ အခြားမိန်းမတယောက်နဲ့ လက်ထပ်သော ယောက်ျားတယောက်ဟ မိမိရဲ့ ပေါင်အိုမနဲ့ အိုင်ထောင်ရေးဖောက်ပြန် ကျူးလွန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","အေးတိုင်းတိုင်းပင် မိန်းမဟလည်း သူရဲ့ ဖိုးအိုနဲ့ ကွာဆှင်းပင်း အခြားယောက်ျားတယောက်နဲ့ လက်ထပ်ရင် အိုင်ထောင်ရေးဖောက်ပြန်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","လူအချို့လို့ဟ လူပဲ့သငယ်များအပေါ် လက်ဟိုတင်စေရန် ယေရှုဆေသို့ ခေါ်ခဲ့ကြအယ်၊ အဲလိုလဲ တဘဲ့တော်လို့ဟ လူများလို့ဟို အော်ငေါက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ယေရှုဟ အေးအရာဟို သတိပြုမိသောအခါ၊ ကိုယ်တော်ဟ အူထော့ခဲ့ပင်း တဘဲ့တော်လို့အား “လပဲ့သငယ်လို့ဟို ငါ့ဆေသို့ လာကြပါစေ၊ သူလို့ဟို မဆီးတားကြနဲ့၊ ပစာကို့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ ဟေလိုမျိုး သူများနဲ့ ဆိုင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","အမန်အကန် နင်ဟို ငါပြောတာဟ၊ လူပဲ့သငယ်တယောက်လိုပဲ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို မရလဲ့ စသူမဆို အဲဒီနိုင်ငံဟို ဘယ်တော့မှ ဝင်ရမှာ ဟုတ်ဝူး” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","အဲပင်းရင် ကိုယ်တော်ဟ လူပဲ့သငယ်လို့ဟို သူ့လက်မောင်းမှာ ချီပင်း၊ သူလို့ အယောက်ချင်းစီတိုင်းဟို လက်များတင်ကာ သူလို့ဟို ကောင်းချီးပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ယေရှုဟ တဖန်စတင်ယွေ့ လမ်းနှိုက်ကြွခဲ့စဉ်၊ လူတယောက်ဟ ပြေးလာပင်းလျှင် ကိုယ်တော် ဆေ့ဦးတွင် ဒူးထောက်လျက် “ကောင်းမြတ်သော ဆရာ၊ ထာဝရအသက်ဟို ရဖို့ရန် ငါဟ ပစာလို ပြုရမလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ယေရှုဟ “နင်ဟ ပစာကျောန့် ငါ့ဟို ကောင်းမြတ်သောသူဟု ခေါ်လုန်း။ ဘုရားသခင် တပါးမှလွဲယွေ့ ကောင်းမြတ်သောသူ တစုံတယောက်မျှ မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ပညတ်တော်လို့ဟို နင်လို့ သိကြအယ် ‘လူ့အသက်ဟို မသတ်ရ၊ သူ့မယားဟို မပစ်မားရ၊ မခိုးရ၊ စသူကိုမှ ကစတ်ကလတ် မစွပ်စွဲရ၊ မဝါကရ၊ နင်လို့ရဲ့ မိဖဟို ရိုသေလော့’ ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","အဲသူဟ “ဆရာ၊ ငါငယ်ခါကတည်းဟ၊ ဟေပညတ်အားလုံးဟို လိုက်နာခဲ့အယ်” ဟု ပြန်ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ယေရှုဟ အဲသူဟို မေတ္တာဖြင့် တန်းတန်းကျေ့လျက် “နင့်မှာ လိုအပ်သောအရာ တခုဆိသေးအယ်။ သွားယွေ့ နင့်မှာဆိသော အရာအားလုံးဟို ရောင်းယွေ့ ဆင်းရဲသူလို့အား ပိတ်ဆန်ပေးလော့၊ ပင်းရင် နင်ဟ ခေါန်းခင်ဘုံနှိုက် ချမ်းသာမှု ရဆိလိမ့်မယ်၊ အေးနောက် လာယွေ့ ငါ့နောက်ဟို လိုက်လော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","သူဟ ရမ်းဆာ့ ချမ်းသာသူဖြစ်သောကျောန့်၊ သူဟ အဲအရာဟို ကြားသောအခါ၊ မျက်နှာပျက်ယွေ့၊ ဝမ်းနည်းပင်း ထွက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ယေရှုဟ တဘဲ့တော်လို့ဟို ပတ်ပတ်လည် ကျေ့ယွေ့ သူလို့အား “ချမ်းသာသော သူများဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ထဲသို့ ဝင်ရောက်ရန် စလောက် ခက်ခဲလှအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","တဘဲ့တော်လို့ဟ ကိုယ်တော်ရဲ့စကားဟို ကြားပင်း အံ့ဩကြအယ်၊ အဲလိုလဲ ယေရှုဟ ဆက်ပြောအယ် “ငါ့လူပဲ့သငယ်လို့၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို ဝင်ရောက်ရန် စလောက် ခက်ခဲမလော၊ ");
INSERT INTO dnv_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ကုလားအုတ်ဟ အပ်နဖားပေါက်ထဲဟို လျှိုဝင်ရန်ထက် ချမ်းသာသောသူအတွက် ဘုရားသခင်ရဲ့ နိုင်ငံတော်သို့ ဝင်ရန် ပိုပင်းခက်ခဲအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","တဘဲ့တော်လို့ဟ ပိုယွေ့ပင် အံ့ဩယွေ့ “ဒါဆိုရင် စသူဟ ကယ်တင်နိန်မလုန်း” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ယေရှုဟ သူလို့ဟို စေ့စေ့ကျေ့ယွေ့ “ဟေအရာဟ လူသားအတွက် မဖြစ်နိန်သော်လည်း ဘုရားသခင်အတွက် ဖြစ်နိန်အယ်၊ အရာအားလုံးဟ ဘုရားသခင်အတွက် ဖြစ်နိန်အယ်” ဟု ပြန်ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","အဲအခါ ပေတရုဟ “ကိုယ်တော်ရဲ့ နောက်လိုက်ဖို့ ငါလို့ဟ အရာအားလုံးဟို စွန့်ခဲ့အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ယေရှုဟ “နင်လို့အား ငါအမန်ဆိုတာဟ နေအိုင်၊ ညီအကို၊ နှမ၊ တို့မေ၊ တို့ဖ၊ သားသမီး၊ လယ်ယာများ အဲဟာမဟုတ်ရင် ငါနဲ့ ဧဝံဂေလိတရားအတွက် စွန့်သောစသူမဆို၊ ");
INSERT INTO dnv_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ဟေဖဝါ့နှိုက် ရမ်းဆာ့ ပိုရလိမ့်မယ်။ သူဟ အဆတရာပိုသော နေအိုင်၊ ညီအကို၊ နှမ၊ တို့မေ၊ သားသမီးများနဲ့ လယ်ယာများနဲ့ ညှဉ်းပန်းနှိပ်စက်ခြင်းဟို ခံရလိမ့်မယ်၊ နောက်လာမဲ့ဖဝါ့နှိုက် ထာဝရအသက်ဟို ရဆိလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","အားပင်မဲ့ ဦးရင်ကျသူများဟ နောက်ဆုံးကျလိမ့်မယ်၊ နောက်ဆုံးကျသူများဟ ဦးရင်ကျလိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ယေရှုနဲ့ သူရဲ့ တဘဲ့တော်လို့ဟ အခု ယေရုရှလင်မြို့သို့ သွားသောလမ်းနှိုက် ဆိကြအယ်။ ယေရှုဟ တဘဲ့တော်လို့ ဆေ့နှိုက် နှိုးဆော်သံများနဲ့ ပြေ့နေပင်း နောက်မှ လိုက်လာသော လူလို့ဟ ကြောက်ရွံ့ကြအယ်။ တခါ ယေရှုဟ တဘဲ့တော် တဆယ့်နေပါးဟို နဖေးခေါ်ယွေ့ သူနှိုက် ဖြစ်ပျက်မဲ့အရာများဟို ပြောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ကိုယ်တော်ဟ “နားထောင်ကြလော့၊ ငါလို့ဟ ယေရုရှလင်မြို့သို့ သွားနေကြအယ် အဲနေရာတွင် လူသားအား ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာလို့ရဲ့ လက်သို့ အပ်နှံကြလိမ့်မယ်။ သူလို့ဟ လူသားဟို သေဒဏ်စီရင်ပင်း တပါးအမျိုးသားလို့ရဲ့ လက်ဟို အပ်နှံကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","သူလို့ဟ လူသားအား လှောင်ပြောင်မယ်၊ ဆံထွေး ထွေးကြလိမ့်မယ်၊ ကြိမ်ဒဏ်ပေးယွေ့ အသေသတ်ကြလိမ့်မယ်၊ အဲလိုလဲ သုံးရက်အကြာမှာ သူဟ ဆှင်ပြန်ထမြောက်လိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","အဲပင်းရင် ဇေဗေဒဲရဲ့ အောင်နီငယ်များဖြစ်ကြသော ယာကုပ်နဲ့ ယောဟန်လို့ဟ ယေရှုဆေဟို လာကြအယ်။ သူလို့ဟ “ဆရာ၊ ငါလို့ တောင်းသမျှဟို ငါလို့ နင်လို့အတွက် လုပ်ပေးချင်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ယေရှုဟ “နင်အတွက် ငါပစာလုပ်စေချင်လဲ” ဟု သူလို့ဟို မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","သူလို့ဟ “ကိုယ်တော်ရဲ့ ဘုန်းကြီးသော နိုင်ငံတော်နှိုက် နင်ရဲ့ ရာဇပလ္လင်ပေါ်မှာ ထိန်လဲ့အခါ ငါလို့ဟို နင်ရဲ့ ညာဘက်မှာ တယောက်၊ ဘယ်ဘက်မှာ နင်နဲ့အတူ ထိန်ခွင့်ရချင်အယ်” ဟု ပြန်ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ယေရှုဟ “နင် ပစာဟို တောင်းဆိုနေတာလဲဆိုတာ နင် သိဝူး။ ငါသောက်ရမဲ့ ဆင်းရဲဒုက္ခခွက်ဟို သောက်နိန်လော။ ငါ နှစ်ခြင်းခံရမယ်ဆိုလဲ့အတိုင်း နင်လို့ နှစ်ခြင်းခံနိန်လော” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","သူလို့ဟ “ငါလို့ တတ်စွမ်းနိန်အယ်” ဟု ဖြေကြအယ်။ ယေရှုဟ “ငါအမန် သောက်ရမဲ့ခွက်ဟို နင်သောက်ရမယ်၊ ငါ နှစ်ခြင်းခံရမဲ့အတိုင်း နှစ်ခြင်း ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","အဲလိုလဲ ငါ့ ညာဘက်နဲ့ ဘယ်ဘက်မှာ ထိန်မဲ့သူဟို ရွေးချယ်ပိုင်ခွင့် ဆိဝူး။ ဘုရားသခင်ဟ ဟေနေရာဟို ပြင်ဆင်ထားသော သူလို့အား ပေးလိမ့်မယ်” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ဟေအကျောန်းအရာဟို အခြား တဘဲ့တော်ဆယ်ဦးလို့ဟ ကြားသောအခါ၊ သူလို့ဟ ယာကုပ်နဲ့ ယောဟန်လို့ဟို အူထော့လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ယေရှုဟ အဲသူလို့ဟို အတူတကွခေါ်ယွေ့ “လူမျိုးခြားလို့အတွက် သူလို့ဟို အုပ်ချုပ်ရန် သတ်မှတ်ထားခြင်း ခံရသောသူလို့ဟ ပြေသူလို့အပေါ် စိုးမိုးခြယ်လှယ်ကြယွေ့၊ သူလို့ရဲ့ အထက်အရာဆိများဟ သူလို့အပေါ် အခွင့်အာဏာဟို အသုံးပြုတာဟို နင်လို့ သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","နင်နဲ့အတူ မဟုတ်ပါ။ အဲအစား၊ နင်လို့တွင် ကြီးမြတ်လိုသူ စသူမဆို နင်ရဲ့ အစေခံ ဖြစ်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ပထမ အလိုဆိသောသူဟ လူခပ်သိမ်းလို့ရဲ့ ကျွန်ဖြစ်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","အကျောန်းမှာ လူသားဟ စေစားဖို့ လာတာ မဟုတ်၊ သူတပါးအစေဟို ခံခြင်းငှာလည်းကောင်း၊ မိမိအသက်ဟို စွန့်ယွေ့ လူများဟို ရွေးနုတ်ရန် လည်ကောင်း၊ ကြွလာခြင်း ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","အဲပင်းရင် သူလို့ဟ ယေရိခေါမြို့သို့ ရောက်လာကြအယ်။ ယေရှုနဲ့ တဘဲ့တော်လို့ဟ လူအုပ်ကြီးနဲ့အတူ မြို့မှ ထွက်ခွာလာစဉ်၊ မျက်စေ့မမျော်သော ဗာတိမဲ (တိမဲရဲ့ အောင်နီငယ်ဟု ဆိုသူ)၊ လမ်းဘေးနှိုက် ထိန်ပင်း တောင်းစားနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","အဲသူဟ နာဇရက်မြို့သား ယေရှု ဖြစ်ကျောန်း ကြားရသောအခါ၊ “ဒါဝိဒ်ရဲ့ သားတော် ယေရှု၊ ငါ့ဟို သနားပါ” ဟု စတင် အော်ကလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ရမ်းဆာ့သော လူဟ သူ့ဟို ငေါက်ငမ်းပင်း သူ့ဟို တိတ်တိတ်နေရန် ပြောခဲ့အယ်။ အဲလိုလဲ သူဟ “ဒါဝိဒ်ရဲ့ သားတော် ယေရှု၊ ငါ့ဟို သနားမန့်” ဟု ပိုယွေ့ပင် ကျယ်လောင်စွာ အော်ဟစ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ယေရှုဟ ရပ်တန့်လျက် “သူ့ဟို ခေါ်ခဲ့လိုက်” ဟု ပြောလေအယ်။ အဲကျောန့် သူလို့ဟ မျက်စေ့မမျော်သောသူဟို ခေါ်လိုက်အယ်။ “အားမငယ်နဲ့၊ ထမန့်၊ သူဟ နင့်ဟို ခေါ်နေအယ်” ဟု သူလို့ဟ ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","သူဟ သူ့ဝတ်လုံဟို လောချပင်း၊ ခုန်ယွေ့ ယေရှု ဆေဟို လာလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ယေရှုဟ “နင့်အတွက် ပစာအရာဟို ပြုစေလိုလုန်း” ဟု သူ့အား မေးလေအယ်။ မျက်စေ့မမျော်သောသူဟ “ဆရာ၊ ငါ မျက်စေ့ပြန်ယွေ့ မျော်ချင်အယ်” ဟု ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ယေရှုဟ “သွားလော့၊ နင့်ရဲ့ ယုံကြည်ခြင်းဟ နင့်ဟို ကောင်းစေပီ” ဟု သူ့အား ပြောလေအယ်။ ခုတုံးပင် အဲသူဟ မျက်စေ့မျော်ယွေ့ ယေရှု ကြွလာရာလမ်းတွင် နောက်တော်ဟို လိုက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","သူလို့ဟ ယေရုရှလင်မြို့သို့ ရောက်သောအခါ၊ ဗက်ဖာဂေမြို့နဲ့ ဗေသနိရွာအနီးဆိ သံလွင်တောင်ဟို သူလို့ ချဉ်းကပ်လာကြအယ်။ ယေရှုဟ သူရဲ့ တဘဲ့နေယောက်ဟို အဆေ့ဟို စေလွှတ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ဟေ ညွှန်ကြားချက်များဖြင့် “နင်လို့ ဆေ့တွင်ဆိသော ရွာဟို သွားကြလော့။ နင်အဲဒီဟို ရောက်တာနဲ့၊ စသူမှ မစီးဖူးသေးသော မြည်းသငယ်တကောင်ဟို လံထားတာဟို နင်မျော်လိမ့်မယ်။ အေးဒါဟို ဖြေပင်း ဟေဟို ယူလာပါ။ ");
INSERT INTO dnv_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ပင်းရင် တယောက်ယောက်ဟ နင်ပစာလို့ အေးလိုလုပ်လဲလို့ မေးရင်၊ အဲအရာဟို သခင်အလိုဆိအယ်၊ အဲပင်း တခါထဲ တန်းပြန်ပို့ပေးပါလိမ့်မယ်” ဟု ပြောလော့။ ");
INSERT INTO dnv_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","အဲကျောန့် သူလို့ဟ သွားယွေ့ နေအိုင်တအိုင်ရဲ့ ထင်ခါးမှာ လံထားသော လမ်းနှိုက် မြည်းသငယ်ဟို မျော်အယ်။ သူလို့ဟ အေးကြိုးဟို ဖြေနေအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ဖေးမှ ရပ်ကျေ့နေသောသူ အချို့ဟ သူလို့ဟို “မြည်းကြိုးဟို ဖြေယွေ့၊ နင်လို့ ပစာလုပ်နေလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","သူလို့ဟ ယေရှု မှာလိုက်ခဲ့လဲ့အတိုင်း ဖြေကြသဖြင့်၊ ရပ်ကျေ့နေသောသူလို့ဟ သူလို့ဟို သွားခွင့်ပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","သူလို့ဟ မြည်းသငယ်ဟို ယေရှုဆေသို့ ခေါ်ခဲ့ပင်းရင်၊ သူလို့ရဲ့ ဝတ်လုံများဟို မြည်းကျောပေါ်သို့ လွှားတင်ကြပင်း၊ ယေရှုဟ မြည်းဟို စီးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ရမ်းဆာ့သော လူလို့ဟ မိမိလို့ရဲ့ ဝတ်လုံများဟို လမ်းပေါ်မှာ ဖြန့်ခင်းကြအယ်၊ အခြားသူများဟ လယ်ကွင်းများထဲမှ သစ်ကိုင်းများဟို ခုတ်ယွေ့ သူလို့ဟ လမ်းမှာ ဖြန့်ခင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ဆေ့မှသွားသော လူများနဲ့ နောက်မှ လိုက်တဲ့ လူတွေဟ စတင်ပင်း အော်ကြအယ်၊ “ဘုရားဟို ချီးမွန်းကြလော့၊ သခင်ဘုရားရဲ့ နာမနဲ့ ကြွလာသောသူဟို ဘုရားသခင် ကောင်းချီးပေးပါစေ၊ ");
INSERT INTO dnv_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","လာမဲ့ ဘုရင်ဒါဝိဒ်ရဲ့ နိုင်ငံတော်ဟို ဘုရားသခင် ကောင်းချီးပေးပါစေ၊ ငါလို့ အဖ၊ ဘုရားသခင်ဟို ချီးမွန်းကြလော့၊” ");
INSERT INTO dnv_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ယေရှုဟ ယေရုရှလင်မြို့ဟို ဝင်ယွေ့၊ ဗိမာန်တော်သို့ သွားကြအယ်၊ အေးပင်း အရာအားလုံးဟို လှည့်ပတ်ကျေ့အယ်။ အဲလိုလဲ အေးနေ့ဟ နောက်ကျနေသောကျောန့်၊ ကိုယ်တော်ဟ တဘဲ့တော် တဆယ့်နေဦးနဲ့အတူ ဗေသနိရွာဟို ထွက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","နောက်တနေ့နှိုက်၊ သူလို့ဟ ဗေသနိရွာမှ ပြန်လာကြစဉ်၊ ယေရှုဟ မွတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ကိုယ်တော်ဟို အဝေးဟ အရွက်တွေနဲ့ အုပ်ထားလျက် သင်္ဘောသဖန်းပင်ဟို မျော်အယ်၊ အေးကျောန့် ကိုယ်တော်ဟ အသီးတွေ့လိုတွေ့နိုး အပင်နားသို့ သွားကျေ့လေအယ်။ အဲလိုလဲ အေးအပင်နားဟို ကိုယ်တော်လာသောအခါ၊ သဖန်းသီးပေါ်ချိန် မဟုတ်သောကျောန့် ကိုယ်တော်ဟ အရွက်များဟိုသာ မျော်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ယေရှုဟ သင်္ဘောသဖန်းပင်အား “နင့်ဆေဟ သင်္ဘောသဖန်းသီးဟို စသူမှ နောက်တခါ မစားရဘူး” ဟု မိန့်လေအယ်။ ပင်းတော့ တဘဲ့တော်လို့ဟလည်း ကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","သူလို့ဟ ယေရုရှလင်မြို့ဟို ရောက်ကြသောအခါ၊ ယေရှုဟ ဗိမာန်တော်သို့ သွားယွေ့ ဗိမာန်တော်အတွင်းမှာ ရောင်းဝယ်နေသူ အားလုံးလို့ဟို စတင်မောင်းထုတ်လေအယ်။ ကိုယ်တော်ဟ ငွေလဲလှယ်သူလို့ရဲ့ စားပွဲများနဲ့ ခိုငက် ရောင်းသူများရဲ့ ထိန်ခုံများဟို မှောက်လောပစ်လေအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","အဲပင်း ကိုယ်တော်ဟ ဗိမာန်တော်ဟို ဖြတ်ယွေ့ ပစာအရာဟိုမျှ ရောင်းဝယ်ရန် ခွင့်ပြုတော်မမူ။ ");
INSERT INTO dnv_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ကိုယ်တော်ဟ “ဘုရားသခင် မိန့်လဲ့ ကျမ်းစာနှိုက်၊ ‘ငါရဲ့ အိုင်တော်ဟို လူမျိုးတကာလို့ရဲ့ ဆုတောင်းရာအိုင်တော်ဟု ခေါ်ဝေါ်ရလိမ့်မယ်’ ဟု ရေးထားအယ် မဟုတ်လော။ အဲလိုလဲ နင်လို့ဟ အဲအိုင်တော်ဟို ထားပြတွေအတွက် ခိုအောင်းရာတခုအဖြစ် ပြောင်းလိုက်ပီလော” ဟု လူလို့အား သွန်သင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာများဟ ကြားယွေ့ ဟေသတင်းဟို ကြားသောအခါ သူလို့ဟ ယေရှုဟို သတ်ရန် နည်းလမ်းအချို့ဟို ဆာခဲ့ကြအယ်။ လူအုပ်အပေါင်းလို့ဟ ကိုယ်တော် သွန်သင်တာဟို ရမ်းဆာ့ အံ့ဩသောကျောန့်၊ သူလို့ဟ ကိုယ်တော်ဟို ကြောက်ရွံ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ညခင်းရောက်သောအခါ၊ ယေရှုနဲ့ သူရဲ့ တဘဲ့တော်လို့ဟ မြို့မှ ထွက်ခွာသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","နောက်တနေ့ နက်စာစောစောအချိန်နှိုက် သူလို့ဟ လမ်းတလျှောက် လမ်းဆှောက်သွားကြစဉ်၊ သင်္ဘောသဖန်းပင်ဟို မျော်လေအယ်။ အဲအပင်ဟ အမြစ်မှစယွေ့ တပင်လုံး ညှိုးနွမ်းလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ပေတရုဟ ဖြစ်ပျက်ခဲ့တာတွေဟို သတိရပင်း “ကျေ့မန့်၊ ဆရာ၊ နင်ကျိန်ဆိုခဲ့သော သင်္ဘောသဖန်းပင်ဟ သေဆုံးသွားပီ” ဟု ယေရှုအား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ယေရှုဟ “ဘုရားသခင်ဟို ယုံကြည်ခြင်း ဆိလော့” ဟု သူလို့အား ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“အမန်အကန် နင်လို့အား ငါဆိုတာဟ စသူမဆို ဟေတောင်အား ‘ရွေ့သွားယွေ့၊ ပင်လယ်ထဲဟို ဆင်းဝါးလော့’ ဟု ဆိုလျက် သူလို့ စိတ်နေလုံးအတွင်းတွင် ယုံမားခြင်းမဆိဘဲ သူလို့ ပြောဆိုလဲ့အတိုင်းဖြစ်မယ်ဟု ယုံကြည်ရင်၊ အဲသူလို့ပြောလဲ့အတိုင်း ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ဟေအကျောန်းကျောန့် နင်လို့အား ငါဆိုတာဟ၊ နင်ဆုတောင်းသောအခါ တောင်းဆှောက်သမျှဟို ရဆိလိမ့်မယ်ဟု ယုံကြည်ကြလော့၊ နင်လို့ တောင်းသမျှဟို ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","နင်လို့ဟ ရပ်လျက် ဆုတောင်းသောအခါ၊ တစုံတယောက်အပေါ် အပစ်တင်စရာ ဆိရင်၊ သူလို့ဟို ခွင့်လွှတ်မန့်၊ အေးလို့မှသာ ခေါန်းခင်ဘုံနှိုက် ဆိသော နင်လို့ အဖဟ နင်လို့ရဲ့ အပစ်များဟို ဖြေလွှတ်ပေးလိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","သူလို့ဟ ယေရုရှလင်မြို့ဟို တခါရောက်ဆိလာကြပင်း၊ ယေရှုဟ ဗိမာန်တော်တွင် လမ်းဆှောက်နေစဉ်၊ ယဇ်ပုရောဟိတ်ကြီးများ၊ ကျမ်းတတ်ဆရာများနဲ့ အသက်ကြီးသူများဟ ကိုယ်တော်ဆေဟို လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","သူလို့ဟ “ဟေအရာလို့ဟို နင် ပစာအခွင့်နဲ့ လုပ်ဆောင်နေလုန်း၊ ဟေလိုလုပ်ဖို့ စသူဟ နင့်ဟို အခွင့်အာဏာဟို ပေးထားလုန်း” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ယေရှုဟ “ငါ နင်ဟို မေးခွန်းတခု မေးမယ်။ ငါ့ဟို ဖြေမန့်၊ ဟေအရာများဟို ငါလုပ်ပိုင်ခွင့် အာဏာအားဖြင့် ငါပြောမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ယောဟန်ရဲ့ နှစ်ခြင်းအခွင့်အာဏာဟ ခေါန်းခင်မှ ဖြစ်သလော၊ အဲဟာမဟုတ်ရင် လူလို့ဆေမှ ဖြစ်သလော။ ငါ့ဟို ဖြေလော့” ဟု ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","သူလို့ဟ အချင်းချင်း ဆွေးနွေးပြောဆိုတာဟ “‘ခေါန်းခင်မှ ဖြစ်အယ်’ လို့ ငါလို့ဟ ပြောရင်၊ သူဟ ‘အဲဆိုနင်ဟ သူ့ဟို ပစာကျောန့် မယုံတာလုန်း’ ဟု မေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","အဲလိုလဲ လူလို့ရဲ့ အခွင့်အာဏာအရဟု ငါလို့ဆိုမလော” ဟု အချင်းချင်း ဆွေးနွေးကြအယ်။ လူအပေါင်းလို့ဟ ယောဟန်ဟို ပရောဖက်ဖြစ်အယ်ဟု အမန်မှတ်ယူသောကျောန့်၊ သူလို့ဟ လူများဟို ကြောက်ရွံ့ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","အဲကျောန့် ယေရှုဟို “ငါလို့ သိဝူး” ဟု သူလို့ ပြန်ဖြေလေအယ်။ ယေရှုဟ “ဟေအရာလို့ဟို ငါလုပ်တာဟို ပစာအခွင့်အာဏာနဲ့ ငါလုပ်ကျောန်း နင်လို့ဟို ငါမပြော” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","အဲအခါ ယေရှုဟ သူလို့အား ပုံဥပမာများဖြင့် မိန့်အယ် “တခါဟ စပျစ်ဥယျာဉ် စိုက်ပျိုးသော လူတယောက်ဟ ခြံစည်းရိုးခတ်လျက်၊ စပျစ်သီးနယ်ရာတွင်းဟိုလည်း တူးယွေ့ မျှော်စင်ဟို ဆောက်လုပ်အယ်။ အဲပင်းရင်သူဟ စပျစ်ဥယျာဉ်ဟို ခြံသမားလို့အား ငမ်းယွေ့ နေအိုင်မှထွက်ယွေ့ ခရီးသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","စပျစ်သီးများ စုသိမ်းချိန် ရောက်လာသောအခါ၊ သူဟ ရိတ်သိမ်းထားတဲ့ ဝေစုရဆိရန် အစေခံလို့အား ခြံငမ်းသမားများဆေသို့ စေလွှတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ခြံငမ်းသမားလို့ဟ အေးအစေခံဟို ဖမ်းဆီးကာ၊ သူ့ဟို ရိုက်နှက်ယွေ့ အေးတိုင်းတိုင်း ပြန်လွှတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","အေးနောက် ပိုင်ဆှင်ဟ အခြားအစေခံတယောက်ဟို စေလွှတ်အယ်၊ ခြံငမ်းသမားလို့ဟ အေးသူရဲ့ ဦးခေါင်းဟို ရိုက်နှက်ယွေ့ သူ့ဟို အဆှက်ခွဲလိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ပိုင်ဆှင်ဟ အခြား ကျွန်တယောက်ဟို စေလွှတ်ယွေ့၊ သူလို့ဟ သူ့ဟို သတ်ကြအယ်၊ အားပင်း သူလို့ဟ အခြားသောသူများဟို အေးနည်းအတိုင်း ဆက်ဆံကြပင်း၊ အချို့လို့ဟို ရိုက်နှက်ယွေ့၊ အချို့သူများလို့ဟို သတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","အေးလူရဲ့ ချစ်လှစွာသော သားဟိုစေလွှတ်ရန် တဦးတည်းသာ ကျန်တော့အယ်။ နောက်ဆုံးအနေနဲ့ပင်းတော့ သူ့သားဟို ခြံငမ်းသမားတွေဆေဟို သူလွှတ်ခဲ့အယ်၊ သူဟ ‘သူလို့ဟ ငါ့သားဟို လေးစားလိမ့်မယ်’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","အဲလိုလဲ အေးခြံငမ်းသမားများဟ အချင်းချင်းပြောဆိုပင်း ‘ဒါဟ ပိုင်ဆှင်ရဲ့ သားရီး။ လာကြ၊ သူ့ဟို သတ်ကြရစို့၊ အားပင်း သူ့ဥစ္စာဟို ငါလို့ ပိုင်လိမ့်မယ်’ ဟု ပြောအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","အေးကျောန့် သူလို့ဟ သူ့ဟိုဖမ်းယွေ့ သတ်ပင်းရင် သူ့အလောင်းအား စပျစ်ဥယျာဉ်အပြင်ဟို လောပစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ဒါဆို စပျစ်ဥယျာဉ်ပိုင်ဆှင်ဟ ပစာလို ပြုလိမ့်မလုန်း” ဟု ယေရှုအား မေးအယ်။ “သူဟ လာယွေ့ ခြံငမ်းသမားများဟို သတ်ပင်း စပျစ်ဥယျာဉ်ဟို အခြားသူများသို့ လွဲပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","နင်လို့ ဟေကျမ်းစာဟို သေချာဖတ်ပီးပီလော၊ “ ‘တည်ဆောက်သော သူများဟ တန်ဖိုးမဆိဟု ငြင်းပယ်ခဲ့သော ကျောက်ဟ အားလုံးထဲမှာ အရေးကြီးဆုံး ထောင့်ချုပ်ကျောက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ဟေအမှုဟို ထာဝရဘုရားပြုခဲ့အယ်၊ အေးဒါဟ မျက်မှောက်နှိုက် အံ့ဩဖွယ်ကောင်းအယ်။’” ");
INSERT INTO dnv_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ယဇ်ပုရောဟိတ်ကြီးများ၊ ကျမ်းတတ်ဆရာများနဲ့ လူကြီးများဟ ယေရှုဟို ဖမ်းဆီးရန် ကြိုးစားခဲ့အယ်၊ ပစာကို့ ကိုယ်တော်ဟ သူလို့ဟို ရည်ညွှန်းယွေ့ ဟေပုံဥပမာဟို ပြောကျောန်းဟို သိကြအယ်။ အဲလိုလဲ သူလို့ဟ လူအုပ်ကြီးဟို ကြောက်သောကျောန့် ကိုယ်တော်ဟို ထားခဲ့ပင်း ထွက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ဖာရိရှဲအချို့နဲ့ ဟေရုဒ်ပါတီဝင်အချို့လို့ဟ မေးခွန်းများနဲ့ ထောင်ချောက်ဆင်ရန် ယေရှုဆေဟို စေလွှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","သူလို့ဟ ကိုယ်တော်ဆေဟို လာယွေ့ “ဆရာ၊ လူတွေ ပစာထင်တဲ့အကျောန်းဟို စိတ်မပူပဲ၊ ကိုယ်တော်ဟ အမန်ပြောတာဟို ငါလို့သိအယ်၊ ကိုယ်တော်ဟ တဦးတယောက်ရဲ့ အခြေအနေဟို ကရုမစိုက်သော်လည်း၊ လူများအတွက် ဘုရားသခင်ရဲ့ အလိုတော်အကျောန်း အမန်အတိုင်း သွန်သင်ပါအယ်။ ငါလို့အား ပြောပါ၊ ရောမအစိုးရအား အခွန်ပေးဆောင်ခြင်းဟ ငါလို့ရဲ့ ဥပဒေနဲ့ ဆန့်ကျင်ပါသလော၊ ငါလို့ဟ သူလို့ဟို အခွန်ဆောင်သင့်သလော အဲဟာမဟုတ်ရင် မဆက်သင့်သလော” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","အဲလိုလဲ ယေရှုဟ သူလို့ရဲ့ လှည့်စားပုံဟို မျော်ယွေ့ “နင်လို့ဟ ငါ့ဟို ပစာကျောန့် ဖမ်းရန် ကြိုးစားကြလုန်း၊ ငွေဒင်္ဂါးတပြားဟို ယူလာပင်း ငါကျေ့ရအောန်” ဟု ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","သူလို့ဟ တပြားဟို ယူခဲ့ယွေ့၊ ကိုယ်တော်ဟ “ဒါတွေဟ စသူ့မျက်နှာနဲ့ နာမယ်ဖြစ်လုန်း” ဟု မေးလေအယ်။ သူလို့ဟ “ဧကရာဇ်မင်းရဲ့ပုံနဲ့ နာမယ်” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","အေးကျောန့် ယေရှုဟ “ကောင်းပီ၊ အဲဆိုရင် ဧကရာဇ်ပိုင်လဲ့အရာဟို ဧကရာဇ်အား ဆက်ပင်း၊ ဘုရားသခင် ပိုင်လဲ့အရာဟို ဘုရားသခင်အား ဆက်ကြလော့” ဟု ပြောအယ်။ အားပင်း သူလို့ဟ ယေရှုဟို အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","အေးအခါ သေခြင်းမှ ထမြောက်ဆှင်ပြန်ခြင်းမဆိဟု ပြောသော ဇဒ္ဒုကဲအချို့လို့ဟ ယေရှုဆေသို့ လာယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ဆရာ၊ မောရှေဟ ဟေပညတ်များဟို ငါလို့အတွက် ရေးသားခဲ့အယ်၊ ‘လူတယောက်ဟ သေဆုံးယွေ့ လူပဲ့မဆိဘဲ ပေါင်အိုမဟိုထားခဲ့ရင်၊ အေးသူရဲ့ ညီဖြစ်သူဟ မုဆိုးမဟို လက်ထပ်ရမယ်၊ အေးကျောန့် သူလို့ဟ သေသွားလဲ့သူရဲ့ လူပဲ့ငယ်လို့ သတ်မှတ်ခံရမယ့် လူပဲ့တွေဟို ရဆိနိန်လိမ့်မယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","တချိန်ဟ ညီအကို ခုနေယောက် ဆိအယ်၊ အကိုအကြီးဆုံးဟ အိုင်ထောင်ကျပင်း လူပဲ့မဆိဘဲ သေသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","အေးနောက် ဒုတိယ တယောက်ဟ အေးမိန်းမနဲ့ လက်ထပ်ခဲ့ပင်း၊ သူဟလည်း လူပဲ့မရဆိဘဲ သေပြန်အယ်။ တတိယ ညီဟလည်း အေးဖြစ်ပျက်မှုအရာဟ အတူတူပဲ၊ ");
INSERT INTO dnv_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ပင်းတော့ ကျန်ခဲ့သော ညီအကိုခုနေယောက်စလုံးဟ အေးမိန်းမနဲ့ လက်ထပ်ပင်း လူပဲ့မရဆိဘဲ သေကြအယ်။ နောက်ဆုံးနှိုက် အေးမိန်းမလည်း သေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ညီအကို ခုနေယောက်စလုံးပင် သူမနဲ့ စုံဖက်ခဲ့ကြအယ် ဖြစ်ယွေ့ ဆှင်ပြန်ထမြောက်ရာနေ့နှိုက် အေးမိန်းမဟ စသူရဲ့ပေါင်အိုမ ဖြစ်မလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ယေရှုဟ “နင်လို့ဟ ကျမ်းစာဟို အဲဟာမဟုတ်ရင် ဘုရားသခင်ရဲ့ တန်ခိုးတော်ဟို မသိသောကျောန့် ဖြစ်အယ်။ နင်လို့ဟ ပစာမားယွင်းလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","အကျောန်းမှာ သေလွန်သောသူလို့ဟ ထမြောက်သောအခါ၊ ခေါန်းခင်ဘုံနှိုက် ဆိသော ခေါန်းခင်တမန်များလို ဖြစ်လိမ့်မယ်၊ ပင်းရင် ထိမ်းမြားကြလိမ့်မယ်မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","အခု၊ သေလွန်သူလို့ဟ ထမြောက်ခြင်း ခံရသလို၊ မောရှေရဲ့ ကျမ်းနှိုက် မီးရှို့သော ချုံနဲ့ပတ်သက်သော ကျမ်းပိုဒ်ဟို နင်လို့ မဖတ်ဖူးကြဝူးလော။ ဘုရားသခင်ဟ ‘ငါဟ အာဗြဟံရဲ့ ဘုရား၊ ဣဇက်ရဲ့ ဘုရား၊ ယာကုပ်ရဲ့ ဘုရားဖြစ်အယ်’ ဟု မောရှေအား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","သူဟ သေလွန်သူလို့ရဲ့ ဘုရားမဟုတ်၊ အဲလိုလဲ အသက်ဆှင်သောသူလို့ရဲ့ ဘုရား ဖြစ်အယ်။ နင်လို့ဟ ရမ်းဆာ့ အယူလွဲကြပီ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ကျမ်းတတ်ဆရာတယောက်ဟ ရောက်လာပင်း သူလို့ ဆွေးနွေးနေတာဟို ကြားလိုက်ရအယ်။ ယေရှုဟ သူလို့ဟို အဖြေကောင်းကောင်းပေးခဲ့တာဟို သတိပြုမိပင်း၊ သူဟ ကိုယ်တော်အား “ပညတ်ဆိသမျှလို့တွင် အရေးကြီးဆုံးဖြစ်လဲ့ ပညတ်ဖြစ်အယ်” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ယေရှုဟ “အရေးကြီးဆုံးအရာမှာ၊ ‘နားထောင်လော့၊ အိုဣသရေလအမျိုး။ ငါလို့ရဲ့ ဘုရားသခင် ထာဝရဘုရားဟ တဆူတည်းသော ဘုရားဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","နင်လို့ရဲ့ ဘုရားသခင် ထာဝရဘုရားဟို စိတ်နေလုံးအကြွင်းမဲ့၊ စိတ်ဝိညာဉ်တခုလုံး၊ ဉာဏ်စွမ်းဆိသမျှ၊ အစွမ်းသတ္တိဆိသမျှနဲ့ ချစ်လော့။’ ");
INSERT INTO dnv_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","‘အိုင်နားနီးချင်းဟို ကိုယ်နဲ့အမျှ ချစ်ရမယ်’ ဟူသော ပညတ်ဟ ဒုတိယအကြီးမြတ်ဆုံး ပညတ်ဖြစ်အယ်။ ဟေပညတ်နေပါးထက် ပိုအရေးကြီးသောပညတ် မဆိ” ဟု ဖြေကြားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ကျမ်းတတ်ဆရာဟ “ဆရာ၊ နင်ရဲ့ ပြောကြားချက်ဟ သင့်မြတ်အယ်” ဟု ပြန်ပြောလေအယ်။ “ဘုရားသခင်ဟ တဆူတည်းသာဖြစ်ယွေ့ ဘုရားသခင်မှတပါး အခြားမဆိဟု နင်ပြောခြင်းဟ မန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ဘုရားသခင်အား စိတ်နေလုံး အကြွင်းမဲ့၊ ဉာဏ်စွမ်းဆိသမျှ၊ အစွမ်းသတ္တိဆိသမျှဖြင့် ချစ်လော့၊ အဲပင်းရင် နင့်အိုင်နားနီးချင်းဟို ကိုယ်နဲ့ အမျှချစ်ရမယ် ဟူသော ပညတ်နေပါးဟို လိုက်နာခြင်းဟ ဘုရားသခင်အား ပူဇော်လဲ့ မီးရှို့ရာယဇ်နဲ့ ယဇ်များအားလုံးထက် ပိုအရေးကြီးအယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","သူဟ ပညာဆိစွာ ဖြေတာဟို ယေရှု မျော်လျှင်၊ ကိုယ်တော်ဟ “နင်ဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်နဲ့ မဝေးတော့ဝူး” ဟု ပြောလေအယ်။ အဲအချိန်မှစယွေ့ စသူမျှ ကိုယ်တော်ဟို မေးခွန်းများ မမေးရဲတော့ချေ။ ");
INSERT INTO dnv_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ယေရှုဟ ဗိမာန်တော်နှိုက် သွန်သင်ပေးနေစဉ်၊ သူဟ မေးခွန်းမေးလေတာဟ “မေဆှိယဟ ဒါဝိဒ်ရဲ့ သားမြေးဖြစ်လိမ့်မယ်ဟု ကျမ်းတတ်ဆရာလို့ဟ စလိုပြောနိန်လုန်း။ ");
INSERT INTO dnv_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ ဒါဝိဒ်အား ပြောရန် လှုံဆော်ပေးခဲ့အယ်၊ “ ‘ထာဝရဘုရားဟ ငါရဲ့ သခင်ဟို ပြောအယ် နင်ရဲ့ ရန်သူလို့ဟို နင်ရဲ့ခြေအောက်နှိုက် ငါ မချထားမှီတိုင်အောန် ငါရဲ့ လက်ယာဖက်နှိုက် ထိန်နေလော့’ ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ဒါဝိဒ် တတ်တိုင်းဟ သူ့ဟို ‘သခင်’ ဟု ခေါ်အယ်။ အဲဆို သူဟ ပစာလိုလုပ် သူ့သားဖြစ်တာလဲ” ဟု မေးကြအယ်။ လူအုပ်ကြီးဟ ယေရှုရဲ့ စကားတော်ဟို အားရရွှင်လန်းစွာ နားထောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","သူလို့ဟို သင်ပေးလဲ့အတိုင်းပါဘဲ၊ ကိုယ်တော်ဟ “ကျမ်းတတ်ဆရာလို့ဟို သတိထားကြလော့။ သူလို့ဟ ဝတ်လုံရှည်များဟို ဝတ်ယွေ့ ပတ်ဝန်းကျင်နှိုက် လမ်းဆှောက်ခြင်းနဲ့ ဆေးနှိုက် ရိုသေလေးစားစွာ နှုတ်ဆက်ခြင်းဟို နှစ်သက်ကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","တရားဇရပ်များရဲ့ သီးသန့်ထိန်ခုံများနဲ့ ပွဲသဘင်များတွင် အကောင်းဆုံးသော နေရာများဟို နှစ်သက်ကြသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","သူလို့ဟ မုဆိုးမများဟို အခွင့်ကောင်းယူယွေ့ သူလို့ရဲ့ နေအိုင်များဟို လုယူကြအယ်၊ အဲပင်းရင် ဟန်ပြယွေ့ ရှည်လျားသော ဆုတောင်းစကားဟို ပြောတတ်ကြအယ်။ သူလို့ဟ ပိုယွေ့ ကြီးလေးသော အပစ်စီရင်ခြင်းဟို ခံရကြလိမ့်မယ်” ဟု ပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ယေရှုဟ ဗိမာန်တော် အလှူခံသေတ္တာဟို ထားရာအရပ်ရဲ့ ဆန့်ကျင်ဘက်နှိုက် ထိန်လျက် လူအုပ်ကြီးဟ သူလို့ရဲ့ ပိတ်ဆန်များဟို အလှူခံသေတ္တာထဲသို့ ထည့်နေတာဟို ကျေ့နေအယ်။ ရမ်းဆာ့သော သူဌေးသူကြွယ်လို့ဟ ပိတ်ဆန်အမြောက်အများဟို လောချခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","အဲလိုလဲ ဆင်းရဲသော မုဆိုးမတယောက်ဟ လာယွေ့ ကတစ်သာ တန်ဖိုးဆိလဲ့၊ ကတစ်ခန့်သော ကြေးနီဒင်္ဂါးနေပြားအား အလှူခံသေတ္တာထဲဟို ထည့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ကိုယ်တော်ဟ သူရဲ့ တဘဲ့တော်လို့ဟို အတူတူခေါ်ပင်းရင်၊ “နင်လို့အား အမန်အကန် ငါဆိုတာဟ ဟေဆင်းရဲသော မုဆိုးမဟ အလှူခံသေတ္တာထဲဟို ထည့်ဝင်သောသူအပေါင်းလို့ထက် ပိုယွေ့ ထည့်လေပီဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","အကျောန်းမှာ သူလို့အားလုံး သူလို့ရဲ့ ကြွယ်ဝသော စည်းစိမ်ဥစ္စာထဲမှ ထည့်ကြအယ်၊ အဲလိုလဲ သူမဟ ဆင်းရဲလျက် သူမနှိုက် ဆိသမျှသောအရာအားလုံး၊ သူရဲ့ အသက်မွေးစရာအားလုံးဟို ပေးခဲ့အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ဗိမာန်တော်မှ ယေရှုလဲ့ထွက်သွားစဉ် ကိုယ်တော့်ရဲ့ တဘဲ့တော်တဦးဟ “ဆရာ၊ ကျေ့ပါ၊ ကျောက်တုံးများနဲ့ အံ့ဩဖွယ်ကောင်းသော အဆောက်အဦးလေ ဟုတ်မောင့်လဲ့” ဟု ဆှောက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“ဟေကြီးမားလဲ့ အဆောက်အုံကြီးတွေ အားလုံးဟို နင်မျော်လား” ဟု ယေရှု ပြန်ပြောအယ်။ “ဟေနေရာနှိုက် အခြား ကျောက်တုံးတတုံးမှ မကျန်ရစ်ရ၊ အသီးသီး လှဲချခြင်းဟို ခံရလိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ယေရှုဟ ဗိမာန်တော်ဖက်နဲ့ မျက်နှာချင်းဆိုင်ဆိ သံလွင်တောင်ပေါ်တွင် ထိန်စဉ်၊ ပေတရု၊ ယာကုပ်၊ ယောဟန်နဲ့ အိန္ဒြေလို့ဟ ကိုယ်တော်ဟို သီးသန့်မေးခဲ့အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ဟေအရာများ ပစာအခါတွင် ဖြစ်ပျက်လိမ့်မလဲ၊ ပင်းတော့ သူလို့အားလုံး ပြေ့စုံတော့မယ့် ပစာနိမိတ်များ ဘာလဲ၊ အကျွန်ုပ်လို့အား ပြောပါ၊” ");
INSERT INTO dnv_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ယေရှုဟ သူလို့အား “သတိထားပါ၊ စသူမှ နင်လို့ဟို မလှည့်စားပါစေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ရမ်းဆာ့သော လူလို့ဟ ငါရဲ့ နာမနဲ့ လာကြလိမ့်မယ်၊ ‘ငါဟ သူဖြစ်အယ်’ ကြွေးကြော်ယွေ့၊ ရမ်းဆာ့သော လူလို့ဟို လှည့်စားကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","နင်လို့ဟ စစ်ပွဲများနဲ့ စစ်ပွဲများရဲ့ ကောလဟာလများဟို သင်ကြားရသောအခါ၊ မထိတ်လန့်ပါနဲ့။ အေးလိုမျိုးအရာများဟ ဖြစ်ပျက်လာရမယ်၊ အဲလိုလဲ အဆုံးသတ်ဖို့ လာရန် လိုသေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","လူမျိုးတမျိုးနဲ့ တမျိုး၊ တနိုင်ငံနဲ့ တနိုင်ငံ ရန်ဖက်ပြုကြလိမ့်မယ်။ နေရာအနှံ့အပြားတွင် မြေငလျင်လှုပ်ယွေ့ အစာငတ်မွတ် ခေါင်းပါးမှုများ ဖြစ်လိမ့်မယ်။ အဲဒါတွေဟ သားဖွားခြင်း ဝေဒနာရဲ့အစ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“နင်လို့တတ်တိုင်းဟလည်း သတိထားရမယ်။ နင့်ဟို ဖမ်းပင်း တရားရုံးသို့ ခေါ်သွားကြလိမ့်မယ်။ တရားဇရပ်များနှိုက် နင်အရိုက်ခံရလိမ့်မယ်၊ နင်လို့ဟာ ငါ့အတွက်ကျောန့် အာဏာပိုင်များနဲ့ ဆှင်ဘုရင်များရဲ့ ဆေ့နှိုက်ရပ်ယွေ့ သတင်းကောင်းဟို ပြောရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","အဲလိုလဲ အဆုံးချိန်မရောက်ခင်၊ သတင်းကောင်းဟို လူမျိုးအပေါင်းလို့အား ဟောပြောရကြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","အားပင်း နင်အား ဖမ်းဆီးယွေ့ တရားရုံးသို့ ခေါ်သွားသောအခါ၊ ပစာပြောဆိုရမယ်အကျောန်းဟို ကြိုတင်ယွေ့ မစိုးရိမ်ကြနဲ့၊ အချိန်ရောက်လာသောအခါ၊ နင့်ဟို ပေးထားတဲ့ ပစာအရာဟိုမဆို ပြောကြလော့၊ နင်လို့ ပြောလဲ့စကားများဟ နင်လို့ဆေမှ မဟုတ်ဘဲ၊ သူလို့ဟ သန့်ဆှင်းသော ဝိညာဉ်တော် ဆေမှလာသော စကားများ ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","လူတွေဟ သေစေရန် သူလို့ရဲ့ ညီအကိုလို့ဟို လက်သို့ အပ်ကြလိမ့်မယ်၊ ပင်းတော့ အဖဟလည်း လူပဲ့ငယ်များအား သေစေရန် အေးနည်းအတိုင်း ပြုကြလိမ့်မယ်။ လူပဲ့လို့ဟလည်း မိဘများဟို ဆန့်ကျင်ယွေ့ သူလို့ဟို သေစေရန် ပြုကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ငါအတွက်ကျောန့် လူတိုင်း နင်လို့ဟို မုန်းလိမ့်မယ်။ အဲလိုလဲ အဆုံးတိုင်အောန် တည်ကြည်သောစသူမဆို ကယ်တင်ခြင်းဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ ‘ကြောက်လန့်စက်ဆုပ်ဖို့ကောင်းလဲ့အရာ’ ဟ မဆိအပ်လဲ့အရပ်တွင် ဆိနေတာဟို နင်လို့ မျော်ရကြလိမ့်မယ်။” (စာဖတ်သူရဲ့ မှတ်ချက်ဟ၊ အေးအရာဟ ပစာကိုဆိုလိုတာ သေချာနားလည်ပါစေ) “အေးအခါ ယုဒပြေနှိုက် ဆိသော သူလို့ဟ တောင်များပေါ်ဟို ပြေးကြရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","အိုင်မိုးပေါ်တွင် ဆိသောသူ တစုံတယောက်ဟ တခုခုယူရန် အောက်ဟို ဆင်းခြင်းအားဖြင့် အချိန် မဆုံးရှုံးစေနဲ့၊ နေအိုင်ထဲသို့ ဝင်ပင်းရင် ပစာအရာဟိုမျှ မယူစေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","လယ်ထဲတွင် ဆိသော တစုံတယောက်ဟလည်း ဝတ်လုံဟို ယူရန် နေအိုင်ဟို မပြန်စေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","လူပဲ့စွဲသော မိန်းမနဲ့ လူပဲ့သငယ်ဆိသော မိခင်လို့အတွက် အေးနေ့ရက် စလောက် ဒုက္ခရောက်လိမ့်မလဲ။ ");
INSERT INTO dnv_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ဆောင်းရာသီနှိုက် အဲအရာများ မဖြစ်ပျက်စေရန် ဘုရားသခင်ဆေ ဆုတောင်းမန့်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","အကျောန်းမှာ အဲကာလရဲ့ ဒုက္ခဟ ကမ္ဘာဦးအစမှ ဘုရားသခင် ဖန်ဆင်းသော အချိန်မှစယွေ့ ခုနေ့ မျက်မှောက်ခေတ်အထိ မသိခဲ့သမျှထက် ပိုဆိုးလိမ့်မယ်။ နောက်လည်း ဒီလိုမျိုး ပစာခါမှ ဖြစ်လာမှာ ဟုတ်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ထာဝရဘုရား မဆိရင် အဲနေ့ရက်များဟို စသူမျှ လျှော့ချနိန်မယ် မဟုတ်ချေ။ အဲလိုလဲ သူရဲ့ ရွေးချယ်ထားသော လူများအကျိုးအတွက် အဲနေ့ရက်များဟို လျှော့ချခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“အေးကာလတွင် လူတစုံတယောက်ဟ နင်လို့အား ပြောဆိုရင် ‘ကျေ့မန့်၊ ဟေအရပ်တွင် မေဆှိယဆိအယ်’ အဲဟာမဟုတ်ရင် ‘ကျေ့မန့်၊ အေးအရပ်တွင် မေဆှိယဆိအယ်’ ဟု — မယုံကြည်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","အကျောန်းမှာ မေဆှိယ အတုအယောင်များနဲ့ ပရောဖက် အတုအယောင်များ ပေါ်လာလိမ့်မယ်။ သူလို့ဟ ဖြစ်နိန်ပါက ဘုရားသခင် ရွေးချယ်ထားသူများဟိုပင် လှည့်ဖြားနိန်ရန် အံ့ဩဖွယ်အမှုများနဲ့ နိမိတ်လက္ခဏာများဟို ပြကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","နင်လို့ဟ သတိပြုကြလော့။ ဟေအမှုအရာအလုံးစုံလို့ မဖြစ်ပေါ်ခင် နင်လို့အား ငါကြိုတင် ပြောပီးပီ။ ");
INSERT INTO dnv_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ဆင်းရဲဒုက္ခများကျရောက်သော နေ့ရက်များတွင် နေဟာ မိုက်လာလိမ့်မယ်၊ လဟ မတောက်ပတော့ပါ၊ ");
INSERT INTO dnv_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ကြယ်များဟ ခေါန်းခင်မှ ကြွေကျလိမ့်မယ်၊ ခေါန်းခင် နက္ခတ်များဟလည်း လမ်းကြောင်းပြောင်းလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","အဲအခါ လူသားဟ ကြီးစွာသော တန်ခိုးတော်နဲ့ ဘုန်းအသရေလို့ဖြင့် မိုးချေးသားများထဲမှ ကြွလာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","လူသားဟ မြေကြီးစွန်းမှ ခေါန်းခင်စွန်းတိုင်အောန် ဘုရားသခင် ရွေးချယ်ထားသော လူများဟို စုသိမ်းရန် အရပ်လေးမျက်နှာသို့ ခေါန်းခင်တမန်များဟို စေလွှတ်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“သင်္ဘောသဖန်းပင်မှ ပုံသက်သေတခုဟို သင်ယူကြလော့။ အဲအပင်ရဲ့ အကိုင်းများဟ စိမ်းလန်းပင်း နူးညံ့လာခါ အရွက်များ စတင်ထွက်လာလဲ့အခါ နွေရာသီနီးတာဟို နင်လို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","အေးတိုင်းတိုင်း ဖော်ပြခဲ့သော အမှုအရာများ ဖြစ်ပျက်လျက်ဆိတာဟို မျော်ရသောအခါ လူသားဟ နင်လို့ အနီး၊ ထင်ခါးဝဟိုပင် ရောက်ဆိနေပီဟု နားလည်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","အမန်အကန် ငါပြောတာဟ ဟေအမှုအရာအလုံးစုံလို့ မဖြစ်ပျက်ခင် အခုခေတ်လူလို့ သေလွန်ရကြလိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ခေါန်းခင်နဲ့ မြေကြီး ကွယ်ပျောက်သွားလိမ့်မယ်၊ အဲလိုလဲ ငါ့စကားဟ ပစာခါမျှ ပျောက်ကွယ်သွားမယ် မဟုတ်ပေ။ ");
INSERT INTO dnv_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“အဲလိုလဲ နေ့ရက် အဲဟာမဟုတ်ရင် နာရီရဲ့ အကျောန်းဟို ခမည်းတော်မှတပါး စသူမှ မသိ။ ခေါန်းခင်ဘုံဆိ ခေါန်းခင်တမန်များ မသိ၊ သားတော်လည်း မသိ။ ");
INSERT INTO dnv_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","အဲနေ့ရက်ကာလဟ ပစာအခါကျရောက်မယ်ဟို နင်လို့ မသိကြသဖြင့် သတိနဲ့ စောင့်နေကြလော့။ နိုးနိုးကြားကြား ဆိကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","လူတယောက်ဟ နေအိုင်ဟနေ ခရီးထွက်ပင်း သူ့ရဲ့ အစေခံများ လက်ဟို အပ်ထားခဲ့လဲ့ သူနဲ့ တူအယ်၊ သူလို့အား ကိုယ့်အငန်းကိုယ်လုပ်ကိုင်ရန် လုပ်ငန်းတာဝန်များဟို ပေးအပ်ခဲ့ယွေ့၊ ထင်ခါးမှူးအား သတိနဲ့စောင့်နေရန် မှာထားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","အဲကျောန့် အိုင်ဆှင်ဟ ညခင်းအချိန်နှိုက် ဖြစ်စေ၊ သန်းခေါင်အချိန် ဖြစ်စေ၊ ကြက်တွန်သောအခါ ဖြစ်စေ၊ မိုးသောက်ယံဖြစ်စေ အိုင်ဆှင်ဟ ပစာခါလဲ့ပြန်လာမယ်ဟို စသူမှ မသိသောကျောန့် သတိပြုကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","သူဟ ပြုန်းခနဲ ပြန်လာရင်၊ နင်လို့ အိပ်မွေ့နေတာဟို တွေ့လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","သတိနဲ့ စောင့်နေကြလော့ဟု နင်လို့ဟို ငါဆိုလဲ့အတိုင်း လူခပ်သိမ်းလို့အား ငါဆိုအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ပသခါပွဲနဲ့ တဆေးမဲ့မုန့်ပွဲတော် ကျရောက်ရန် နေရက်လောက် လိုတော့အယ်။ ယဇ်ပုရောဟိတ်မင်းများနဲ့ ကျမ်းတတ်ဆရာများဟ ယေရှုဟို တိတ်တဆိတ် ဖမ်းဆီးယွေ့ သတ်ရန် နည်းလမ်းများဟို ဆှာဖွေလျက်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","သူလို့ဟ “ပွဲတော်အတွင်းနှိုက် လူလို့ ရုန်းရင်းဆန်ခတ် မဖြစ်စေရန် သူ့ဟို မဖမ်းဆီးကြနဲ့” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ယေရှုဟ ဗေသနိရွာတွင် အနူရောဂါ စွဲကပ်ဖူးသူ ရှိမုန်ရဲ့ နေအိုင်တွင် ဆိအယ်။ ယေရှု အစားအစာ သုံးဆောင်နေစဉ်၊ အမျိုးသမီးတယောက်ဟ ရမ်းဆာ့ အဖိုးတန်သော နာဒုဆီမွှေးနဲ့ ပြုလုပ်သော ကျောက်ဖြူအိုး အပြေ့တလုံးနဲ့အတူ ဝင်လာအယ်။ သူမဟ အိုးဟိုခွဲပင်း ယေရှုရဲ့ ခေါင်းပေါ်နှိုက် ဆီမွှေးဟို သွန်းလောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","အဲမှာဆိနေတဲ့ လူအချို့လို့ဟ အူထော့လာယွေ့ တယောက်နဲ့တယောက် ပြောကြအယ် “ပစာကျောန့် ဆီမွှေးဟို အလကားကား ဖြုန်းတီးလုန်း၊ ");
INSERT INTO dnv_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ဟေဆီမွှေးဟို ငွေဒင်္ဂါးအပြား ၃၀၀ ကျော်နဲ့ ရောင်းယွေ့ ပိတ်ဆန်ဟို ဆင်းရဲသူများအား ပေးကမ်းနိန်အယ်” အားပင်း သူလို့ဟ သူမဟို ပြင်းပြင်းထန်ထန် ဝေဖန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","အဲလိုလဲ ယေရှုဟ “အေးအမျိုးသမီးဟို ဆိပါစေ၊ ပစာကျောန့် သူမဟို နှောင့်ယှက်ကြလုန်း၊ သူမဟ ငါ့အတွက် ကောင်းမွန်ပင်း လှပတဲ့အရာတခုဟို ပြုလုပ်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ဆင်းရဲသူများဟာ နင်လို့နဲ့ အမြဲဆိနေကြသဖြင့် နင်အလိုဆိလဲ့အချိန်တိုင်း၊ နင်လို့ဟ သူလို့ဟို အမြဲကူညီနိန်အယ်။ အဲလိုလဲ ငါဟတော့ နင်လို့နဲ့ အမြဲဆိနေတာ မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ဟေအမျိုးသမီးဟ သူတတ်နိန်သလောက် ပြုခဲ့ပီ၊ သူမဟ သင်္ဂြိုဟ်ခြင်းအတွက် ကြိုတင်ပြင်ဆင်ရန် ငါရဲ့ ခန္ဓာကိုယ်ဟို ဆီမွှေးနဲ့ သွန်းလောင်းလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","အခု၊ နင်လို့ဟို ငါ အမန်အကန် ပြောတာဟ ကမ္ဘာအရပ်ရပ်တွင် ဧဝံဂေလိတရားဟို ဟောပြောတဲ့ နေရာတိုင်းနှိုက်၊ ဟေအမျိုးသမီးဟို သူပြုခဲ့သောအမှုဟိုလည်း အမှတ်တရအဖြစ် ပြောကြားကြလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","အေးနောက် တဆယ့်နေပါးသော တဘဲ့တော်လို့ထဲမှ တပါးဖြစ်သော ယုဒရှကာရုတ်ဟ၊ ယဇ်ပုရောဟိတ်ကြီးများ လက်သို့ ယေရှုဟို သစ္စာဖောက်ရန် သူလို့ဆေသို့သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","သူပြောတဲ့ စကားဟို ကြားရတော့ သူလို့ဟ ဝမ်းသာကြယွေ့၊ သူ့အား ငွေပေးမယ်လို့ ကတိပြုကြအယ်။ အေးလို့မို့ ယုဒဟ ယေရှုဟို သူ့လို့ လက်ထဲဟိုအပ်ရန် အခွင့်ကောင်းဟို စတင် ဆှာလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","တဆေးမဲ့မုန့်ပွဲတော်ရဲ့ ပထမနေ့တည်းဟူသော၊ ပသခါပွဲတော်အတွက် သိုးသငယ်ဟို ယဇ်ပူဇော်ရသော ထုံးစံဆိအယ်၊ ယေရှုရဲ့ တဘဲ့တော်များဟ ကိုယ်တော်အား “ကိုယ်တော်အတွက် အကျွန်ုပ်လို့ဟ ပစာအရပ်နှိုက် သွားပင်း ပသခါပွဲအတွက် စားဖို့ရန် ပြင်ဆင်မှုတွေ လုပ်စေချင်လဲ” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","အေးလို့မို့ ယေရှုဟ တဘဲ့တော် နေယောက်ဟို စေလွှတ်ယွေ့၊ သူလို့ဟို ပြောစေအယ် “မြို့ထဲဟို သွားကြ၊ အားပင်း ယေအိုး သယ်လာသူဟ နင်ဟို တွေ့လိမ့်မယ်။ သူရဲ့ နောက်လိုက်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","သူဝင်သွားသော နေအိုင်မှ အိုင်ဆှင်အား ပြောပါ၊ ‘ဆရာဟ ငါ့တဘဲ့တော်များနဲ့အတူ ပသခါပွဲဟို စားဖို့၊ ဧည့်ခန်းဟ ပစာနားမှာရီး၊’ ");
INSERT INTO dnv_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","သူဟ အပေါ်ထပ်အခန်းဆိ အသင့်ပြင်ဆင်ခင်းကျင်းထားသော အခန်းကြီးဟို နင်လို့အား ပြလိမ့်မယ်။ အေးနေရာနှိုက် ငါလို့အတွက် ပြင်ဆင်မှု ပြုကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","တဘဲ့တော်လို့ဟ ထွက်သွားပင်းရင်၊ မြို့ထဲဟိုသွားယွေ့ ယေရှုဟ သူလို့အား ပြောလိုက်တဲ့အတိုင်း အရာများဟို တွေ့ဆိခဲ့အယ်။ အေးကျောန့် သူလို့ဟ ပသခါပွဲတော်ဟို ပြင်ဆင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ညခင်းအချိန်ရောက်လာသောအခါ၊ ယေရှုဟ တဆယ့်နေပါးသော တဘဲ့တော်လို့နဲ့အတူ ရောက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","သူလို့ဟ စားပွဲနားမှာလျောင်းလျက် စားနေစဉ်တွင်၊ ယေရှုဟ “အမန်အကန် နင်ဟို ငါပြောတာဟ၊ ငါနဲ့အတူ စားနေသော သင်လို့ထဲမှ သူတယောက်ဟ ငါ့ဟို သစ္စာဖောက်လိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","တဘဲ့တော်လို့ဟ စိတ်မချမ်းမသာဖြစ်ကြလျက် “သေချာတာဟ နင်ဟ ငါဟို ဆိုလိုလော” ဟု တယောက်ပင်းတယောက် သူလို့ဟ ကိုယ်တော်အား မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ယေရှုဟ “တဆယ့်နေပါးသော သူလို့ထဲမှ တယောက်ဖြစ်ပင်း၊ ငါနဲ့အတူ တပကန်ထဲတွင် မုန့်ဟို နှိုက်သောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ကျမ်းစာလာလဲ့အတိုင်း လူသားဟ အသေခံလိမ့်မယ်၊ အဲလိုလဲ လူသားအား သစ္စာဖောက်သောသူဟ စလောက်ကြောက်စရာ ကောင်းလိမ့်မလဲ၊ သူဟ ဘယ်တော့မှ မမွေးဖွားခဲ့ရင် အေးလူအတွက်ပိုပင်း ကောင်းလိမ့်မယ်” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","သူလို့ဟ စားနေကြစဉ်၊ ယေရှုဟ မုန့်ဟိုယူယွေ့၊ ကျေးဇူးတင်ကျောန်း ဆုတောင်းကာ၊ မုန့်ဟိုဖဲ့ယွေ့ တဘဲ့တော်လို့အား ပေးအယ်။ ကိုယ်တော်ဟ “ယူကြလော့၊ ဟေမုန့်ဟ ငါရဲ့ ခန္ဓာကိုယ် ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","အေးနောက် ခွက်ဟို ယူယွေ့၊ ဘုရားသခင်ဟို ကျေးဇူးတင်ယွေ့၊ သူလို့ရဲ့ လက်ထဲသို့ အေးခွက်ဟို ပေးရင်၊ သူလို့အားလုံးဟ အေးခွက်ဟို သောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ယေရှုဟ “အေးဒါဟ အများအတွက်သွန်းသော ငါ့ရဲ့ အသွေး ဖြစ်အယ်၊ ဘုရားသခင်ရဲ့ ပဋိညာဉ်တော်ဟို တံဆိပ်ခတ်နှိပ်သော ငါရဲ့ အသွေး ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","အမန်အကန် နင်ဟို ငါပြောတာဟ၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်နှိုက် အသစ်ပြန်သောက်မဲ့ နေ့မတိုင်ခင် ငါဟ ဟေစပျစ်မှဖြစ်သော အရည်ဟို နောက်တခါ မသောက်တော့ဝူး” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","အဲပင်းရင် သူလို့ဟ ဓမ္မသီချင်းဆိုပင်းရင် သံလွင်တောင်ဟို ထွက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ယေရှုဟ သူလို့အား “နင်လို့အားလုံးဟ ထွက်ပြေးပင်း ငါ့ဟို ထားသွားလိမ့်မယ်၊ ကျမ်းစာပြောထားလဲ့အတိုင်း၊ ‘ဘုရားသခင်ဟ သိုးထိန်းဟို သတ်ပင်း သိုးများအားလုံး ကျဲပြေးကုန် ကြလိမ့်မယ်။’ ");
INSERT INTO dnv_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","အဲလိုလဲ ငါဟ ထမြောက်ပင်းနောက်၊ ဂါလိလဲပြေဟို နင်လို့ဆေ့အူးရင် ငါသွားနှင့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ပေတရုဟ “အားလုံး စွန့်ပစ်ကြသော်လည်း ငါမစွန့်ပစ်ပါ” ဟု ကြွေးကြော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ယေရှုဟ ပေတရုအား “အမန်အကန် နင်ဟို ငါပြောတာဟ၊ ဟေနေ့ညတွင်ပင် ကြက် နေခါမတွန်ခင်၊ နင်ဟ သုံးကြိမ်တိတိ ငါ့ဟို မသိဟု ငြင်းဆိုလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ပေတရုဟ ပိုပင်း ပြင်းပြင်းထန်ထန် ဖြေပင်း၊ “ငါ ကိုယ်တော်နဲ့အတူတူပင် သေရင်တောင်၊ ငါ ပစာခါမှ ပြောမှာ ဟုတ်ဝူး” ဟု ပြောအယ်။ အားပင်း အခြားသော တဘဲ့တော်လို့ဟလည်း အေးတိုင်းတိုင်းလိုက် ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","သူလို့ဟ ဂေသရှေမန်ဟု ခေါ်သော အရပ်သို့ရောက်ကြပင်း၊ ယေရှုဟ သူရဲ့ တဘဲ့တော်များအား၊ “ငါဆုတောင်းနေစဉ် ဟေနေရာတွင် ထိန်နေကြလော့” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ပေတရု၊ ယာကုပ်နဲ့ ယောဟန်လို့ဟို မိမိနဲ့အတူ ခေါ်သွားလေအယ်။ စိတ်ဆင်းရဲမှုနဲ့ ပူပန်မှုလို့ဟ ကိုယ်တော်ဆေဟို ရောက်လာသဖြင့်၊ ");
INSERT INTO dnv_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","အားပင်း ကိုယ်တော်ဟ သူလို့အား “ငါဟာ စိတ်နေလုံးနှိုက် ဝမ်းနည်းခြင်းဟ ရမ်းဆာ့ကြီးပင်း ငါဟ သေလုနီးပီ။ ဟေအရပ်တွင် သတိနဲ့ စောင့်နေကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ကိုယ်တော်ဟ ဆေ့သို့ နည်းနည်းသွားပင်းရင်၊ မိမိကိုယ်ဟို မြေပေါ်တွင် လှဲချပင်း၊ ဖြစ်နိန်ရင် သူခံရသော ဒုက္ခကာလဟို လွှဲဖယ်ပေးပါမယ့်အကျောန်း ဆုတောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ကိုယ်တော် ဆုတောင်းတာဟ “အဖ၊” “ငါ့ အဖ၊ ကိုယ်တော်အတွက် အရာခပ်သိမ်းဟ တတ်နိန်ပါအယ်။ ဟေဒုက္ခဝေဒနာခွက်ဟို ငါ့ဆေမှ လွှဲဖယ်ပေးပါ။ အဲလိုလဲ ငါရဲ့ အလိုအတိုင်း မဟုတ်ဘဲ၊ ကိုယ်တော်ရဲ့ အလိုအတိုင်း ဖြစ်စေမူမန့်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","အဲပင်းရင် ကိုယ်တော်ဟ တဘဲ့တော်သုံးဦးလို့ ဆေဟို ပြန်လာရာ သူလို့ဟ အိပ်မွေ့လျက်နေကြတာဟို မျော်အယ်။ ကိုယ်တော်ဟ “ရှိမုန်၊ နင်ဟ အိပ်မွေ့နေသလော။ မအိပ်ဘဲ တနာရီလောက် စောင့်ယွေ့ မနေနိန်ဝူးလော” ဟု ပေတရုအား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","အဲပင်းရင် ကိုယ်တော်ဟ “နင်လို့ဟ စုံစမ်းနှောင့်ယှက်ခြင်းသို့ မကျရောက်စေရန် ဆုတောင်းလျက် စောင့်နေကြလော့။ စိတ်ဆန္ဒဆိအယ်၊ အဲလိုလဲ ကိုယ်ခန္ဓာဟ အားနည်းအယ်” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ကိုယ်တော်ဟ နောက်တကြိမ် ထွက်သွားယွေ့ တူညီသောစကားများဟို ပြောကာ ဆုတောင်းခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","အဲပင်းရင် ကိုယ်တော်ဟ တဘဲ့တော်လို့ထံသို့ ပြန်လာယွေ့ သူလို့ဟ မျက်စေ့လေးလံသဖြင့် တဖန် အိပ်မွေ့နေကြတာဟို မျော်လေအယ်။ သူလို့ဟ ကိုယ်တော်အား ပစာလို ပြောရမယ်ဟို မသိကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ကိုယ်တော်ဟ သူလို့ဆေသို့ တတိယအကြိမ် ပြန်လာယွေ့ “နင်လို့ဟာ အခုထိတိုင် အိပ်မွေ့လျက်၊ နားလျက် နေကြသလော၊ တော်လောက်ပီ။ အချိန်ရောက်လာပီ။ ကျေ့မန့်၊ လူသားဟို ဆိုးသွမ်းသောသူများ လက်သို့အပ်နှံခြင်း ခံရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","လာကြ။ ငါလို့ သွားကြကုန်အံ့။ ငါ့အား ရန်သူ့လက်ဟို အပ်မဲ့သူ ရောက်လာပီ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","အေးလို့မျိုး ယေရှုပြောနေချိန်တွင် တဆယ့်နေပါးအဝင်ဖြစ်သော ယုဒ ရောက်ဆိလာအယ်။ သူနဲ့အတူ တုတ်၊ ထားကိုင်သူ လူအမြောက်အများပါအယ်။ အေးသူလို့ဟ ယဇ်ပုရောဟိတ်ကြီးများ၊ ကျမ်းတတ်ဆရာများနဲ့ အသက်ကြီးသူများဟ စေလွှတ်ယွေ့ ရောက်ဆိလာကြခြင်းဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ကိုယ်တော်အား သစ္စာဖောက်မဲ့သူဟ “ငါ နမ်းသောသူဟ နင်လို့ အလိုဆိသောသူ ဖြစ်အယ်၊ သူ့ဟို ဖမ်းဆီးယွေ့ အစောင့်နဲ့ ခေါ်သွားကြလော့” ဟု သူလို့အား အမှတ်ပေးခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ယုဒဟ ရောက်လာတာနဲ့ ခုတုံးပင် ယေရှုဆေဟို ချဉ်းကပ်ယွေ့၊ “ဆရာ” ဟု ဆိုယွေ့ ကိုယ်တော်ဟို နမ်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","အဲကျောန့် သူလို့ဟ ယေရှုဟို ဖမ်းဆီးယွေ့ တင်းကျပ်စွာ တုတ်ချေထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","အဲအခါ အနီးတွင် ရပ်နေသူတဦးဟ ထားဟို ဆွဲထုတ်ပင်း ယဇ်ပုရောဟိတ်မင်းရဲ့ ကျွန်ဟို ခုတ်သဖြင့် အဲသူနားရွက် ပြတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ယေရှုဟ “နင်လို့ဟ ထားပြဟို ဖမ်းဆီးသလိုမျိုး ငါ့ဟို ဖမ်းဆီးရန် တုတ်နဲ့ ထားများဟို စွဲယွေ့ လာကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ငါဟ ဗိမာန်တော်နှိုက် နင်လို့နဲ့အတူ နေ့စဉ်နေ့တိုင်း ဆုံးမဩဝါဒ ပေးခဲ့အယ်၊ နင်လို့ဟ ငါ့ဟို ဖမ်းခဲ့ဝူး။ အဲလိုလဲ ကျမ်းစာလာလဲ့အတိုင်း အမန်ဖြစ်ရမယ်” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","အဲအခါ တဘဲ့တော်အပေါင်းလို့ဟ ကိုယ်တော်ဟို စွန့်ယွေ့ ထွက်ပြေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","စောင်ငယ်တထည်ဟိုသာ လွှားထားလဲ့ လူပဲ့ငယ်တယောက်ဟ ယေရှုရဲ့ နောက်တော်ဟ လိုက်လာအယ်။ သူလို့ဟ ကိုယ်တော်ဟို ဖမ်းဆီးမယ် လုပ်ကြသောအခါ၊ ");
INSERT INTO dnv_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","သူဟ စောင်ဟို လောပလိုက်ယွေ့ ကိုယ်ချဲချဲ ထွက်ပြေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","အဲသူလို့ဟ ယေရှုဟို ယဇ်ပုရောဟိတ်မင်းရဲ့ အိုင်တော်သို့ ခေါ်ဆောင်သွားကြအယ်၊ ယဇ်ပုရောဟိတ်အကြီးများ၊ အသက်ကြီးသူများနဲ့ ကျမ်းတတ်ဆရာများဟ အေးအိုင်တော်တွင် စုရုံးလျက်ဆိနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ပေတရုဟ ခပ်လှမ်းလှမ်းကနေယွေ့ ယဇ်ပုရောဟိတ်မင်းရဲ့ အိုင်တော်ဝင်းထဲအထိ ကိုယ်တော်ရဲ့နောက်ဟ လိုက်လာခဲ့အယ်။ သူဟ အစောင့်တွေနဲ့ ထိန်ပင်း မီးလှုံလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ယုဒတရားလွှတ်တော် အဖွဲ့ဝင်အပေါင်းလို့ဟ ယေရှုအား သေဒဏ်ပေးနိန်ရန် သက်သေဟို ဆာကြအယ်၊ အဲလိုလဲ သူလို့ဟ မတွေ့ကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","လူအများလို့ဟ ကိုယ်တော်ဟို မားယွင်းစွာ သက်သေခံကြအယ်၊ အဲလိုလဲ သူလို့ရဲ့ ထွက်ဆိုချက်များ ကိုက်ညီမှု မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","အဲအခါ လူအချို့လို့ဟ ထယွေ့ မားယွင်းသော သက်သေခံချက်ဟို ကိုယ်တော်အား ပေးကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","သူလို့ဟ “လူ့လက်ဖြင့် တည်ဆောက်သော ဟေဗိမာန်ဟို ငါ ဖျက်ယွေ့ သုံးရက်အတွင်း လူ့လက်ဖြင့် မတည်ဆောက်လဲ့ ဗိမာန်တော်ဟို ငါတည်ဆောက်မယ်” ဟု သူပြောဆိုတာဟို ကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","အဲလိုလဲ သူလို့ရဲ့ သက်သေခံချက်များဟလည်း ကိုက်ညီမှု မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ယဇ်ပုရောဟိတ်မင်းဟ အဲသူလို့ အဆေ့မှာ ထယွေ့ ယေရှုဟို၊ “အေးသူလို့ နင့်အား စွပ်စွဲပြောဆိုနေကြတာဟို နင်ဟ ပစာလိုမျှ ပြန်မဖြေဘဲနေသလော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","အဲလိုလဲ ယေရှုဟ စကားတခွန်းမှ မပြောဘဲ၊ တိတ်ဆိတ်နေခဲ့အယ်။ တခါ ယဇ်ပုရောဟိတ်မင်းဟ “နင်ဟ မေဆှိယ၊ ကောင်းချီးပေးသော ဘုရားသခင်ရဲ့ သားတော်လော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ယေရှုဟ “မန်အယ်။ လူသားဟ အနန္တတန်ခိုးဆှင်ရဲ့ လက်ယာဘက်တွင် ထိန်နေပင်း မိုးချေးသားလို့နဲ့အတူ ကြွလာတာဟို နင်လို့အားလုံး မျော်ရကြလိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ယဇ်ပုရောဟိတ်မင်းဟ မိမိရဲ့ အဝတ်ဟို ဆုတ်ယွေ့၊ “ငါလို့ ပစာကျောန့် သက်သေတွေ ထပ်လိုအုံးတော့မလဲ။ ");
INSERT INTO dnv_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ဘုရားသခင်အား ဟေသူစော်ကားပြောဆိုသော စကားဟို နင်လို့ ကြားရကြပီ။ နင်လို့ စလို စီရင်ချက်ချမှတ်ကြမလုန်း” ဟု ဆိုအယ်။ အေးသူလို့အားလုံးဟ သူ့ဟို ပစ်မှုထင်ဆှားယွေ့ သေဒဏ်ပေးထိုက်အယ်ဟု စီရင်ချမှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","အချို့သောသူလို့ဟ ကိုယ်တော်ဟို ဆံထွေးနဲ့ ထွေးပင်း၊ မျက်နှာတော်ဟို ဖုံးပင်းလျှင် ဖိုင်ကြအယ်။ သူလို့ဟ “နင့်အား စသူရိုက်လဲဆိုတာဟို ပရောဖက်ပြုယွေ့ ဟောကျေ့ပါ” ဟု ဆိုကြအယ်။ အစောင့်လို့ဟ ကိုယ်တော်ဟို ဖမ်းယွေ့ လက်နဲ့ပါးဟို ပုတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ပေတရုဟ ကျောင်းတော်ဝင်းအတွင်းနှိုက် ဆိနေစဉ် ယဇ်ပုရောဟိတ်မင်းရဲ့ အစေခံ မိနီငယ်တယောက်ဟ ရောက်ဆိလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ပေတရု မီးလှုံနေတာဟို မျော်သောအခါ၊ မိနီငယ်ဟ သူ့ဟို စေ့စေ့ကျေ့ယွေ့၊ “နင်ဟလည်း နာဇရက်မြို့သား ယေရှုနဲ့အတူ ဆိခဲ့ကြအယ်” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","အဲလိုလဲ ပေတရုဟ ငြင်းဆိုခဲ့အယ်။ “နင်ပြောနေတာဟို ငါမသိဝူး အဲဟာမဟုတ်ရင် နားမလည်ဝူး” ဟုဆိုကာ ဝင်ပေါက်ဟို ထွက်သွားအယ်။ အဲအချိန်နှိုက် ကြက်တွန်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","အစေခံ မိနီငယ်ဟ ပေတရုဟို တခါမျော်သောအခါ၊ အနားတွင် ရပ်နေသူလို့ဟို ထပ်ပြောပြန်အယ်၊ “ဟေသူဟာ သူလို့ထဲဟ တယောက်ဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ပေတရုဟလည်း မဟုတ်ကျောန်း ငြင်းဆိုပြန်အယ်။ ခဏအကြာတွင်၊ အနီးနှိုက် ရပ်နေသောသူလို့ဟ “နင်ဟ ဂါလိလဲလူဖြစ်သောကျောန့် အမန်ပင် အေးသူလို့ထဲဟ တယောက်ဖြစ်အယ်” ဟု ပေတရုအား ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","အဲပင်းရင် ပေတရုဟ “ငါဟတော့ အမန်တိုင်း ကျိန်ဆိုယွေ့ ပြောအယ်။ ငါဟ မမန်ဝူးဆိုရင် ဘုရားသခင်ဟ ငါ့ဟို အပစ်ပေးမန့်စေ၊ နင်လို့ပြောသော သူရဲ့အကျောန်းဟို ငါမသိ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","အေးခဏတွင် ဒုတိယအကြိမ် ကြက်တွန်လေအယ်၊ အဲအခါ ပေတရုဟ “ကြက် နေကြိမ်မတွန်ခင် နင်ဟ ငါ့ဟို မသိဟူယွေ့ သုံးကြိမ်မြောက်အောန် ငြင်းဆိုလိမ့်မယ်” ဟု ယေရှု ပြောခဲ့လဲ့စကားဟို ပြန်လည်သတိရသဖြင့် ချုံးပွဲချယွေ့ ငိုကြွေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","နက်စာအစောတွင် ယဇ်ပုရောဟိတ်ကြီးလို့နဲ့ အကြီးအကဲများ၊ ကျမ်းတတ်ဆရာများနဲ့ လွှတ်တော်အဖွဲ့ဝင်အပေါင်းလို့ဟ သူလို့ရဲ့ အစီစဉ်တွေဟို ပြုလုပ်ခဲ့အယ်။ သူလို့ဟ ယေရှုဟို သံကြိုးနဲ့ တုတ်ချေပင်း ခေါ်သွားကာ ပိလတ်မင်း လက်ဟို အပ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ပိလတ်မင်းဟ ကိုယ်တော်အား “နင်ဟ ယုဒဆှင်ဘုရင်လော” ဟု မေးအယ်။ ယေရှုဟ “နင်ပြောလဲ့အတိုင်း ဖြစ်အယ်” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ယဇ်ပုရောဟိတ်ကြီးလို့ဟ ယေရှုဟို အရာများစွာနဲ့ စွပ်စွဲကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","အေးကျောန့် ပိလတ်မင်းဟ ကိုယ်တော်ဟို ထပ်မေးအယ်၊ “နင်ဖြေမှာ မဟုတ်ဝူးလော၊ သူလို့ရဲ့ စွပ်စွဲချက်တွေ အားလုံးဟို နားထောင်မန့်။” ");
INSERT INTO dnv_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","တဖန် ယေရှုဟ စကားတခွန်းဟိုမျှ မပြောဘဲနေသဖြင့် ပိလတ်မင်းဟ အံ့ဩလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ပိလတ်မင်းဟ ပသခါပွဲ ကျရောက်လေတိုင်း လူလို့တောင်းဆိုလဲ့ စလိုအကျဉ်းသမား တယောက်ဟို လွတ်ငြိမ်းချမ်းသာခွင့် ပေးလေ့ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","အဲအချိန်တွင် ဗာရဗ္ဗနာမယ်ဆိသော အမျိုးသားတဦးဟ ပုန်ကန်ထကြွမှုနှိုက် လူသတ်မှုကျူးလွန်ခဲ့သော သူပုန်များနဲ့အတူ အကျဉ်းထောင်ထဲတွင် ဆိနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","လူအုပ်လို့ဟ ရောက်လာကြပင်း သူလို့ လုပ်လေ့ဆိလဲ့အရာဟို သူလို့အတွက် လုပ်ပေးဖို့ ပိလတ်မင်းဟို တောင်းဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ပိလတ်မင်းဟ “နင်လို့ဟ ငါဟို ယုဒဆှင်ဘုရင်အား လွှတ်ပေးစေချင်ပါသလော” ဟု မေးအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","အေးလို့ မေးလဲ့အကျောန်းမှာ ယဇ်ပုရောဟိတ်ကြီးလို့ဟ ယေရှုအား မနာလိုသဖြင့် မိမိလက်သို့ကျောန်းဟို သူဟ ကောင်းစွာသိသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","အဲလိုလဲ ယဇ်ပုရောဟိတ်ကြီးလို့ဟ ပိလတ်မင်းအစား ဗာရဗ္ဗဟို လွှတ်ပေးရန် လူအုပ်ကြီးအား လှုံ့ဆော်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ပိလတ်မင်းဟ သူလို့ဟို “သို့ဖြစ်လျှင် ယုဒဆှင်ဘုရင်ဟု သင်လို့ခေါ်သောသူဟို ငါပစာ လုပ်ရမလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","သူလို့ဟ “သူ့ဟို လက်ဝါးကပ်တိုင်မှာ တင်ယွေ့သတ်ပါ” ဟု အော်ဟစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ပိလတ်မင်းဟ “ပစာကျောန့်လုန်း၊ သူဟ ပစာရာဇဝတ်မှုဟို ကျူးလွန်ခဲ့သလော” ဟု မေးအယ်။ အဲလိုလဲ သူလို့အားလုံးဟ “သူ့ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ပါ” ဟု ကျယ်ကျယ်အော်ကကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","လူအုပ်ဟို ကျေနပ်စေလိုသဖြင့်၊ ပိလတ်မင်းဟ သူလို့အား ဗာရဗ္ဗဟို လွှတ်ပေးလေအယ်။ သူဟ ယေရှုဟို ရိုက်နှက်စေယွေ့၊ လက်ဝါးကပ်တိုင်မှာ တင်ယွေ့သတ်ရန် လက်ဟို အပ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ယေရှုဟို စစ်သားများဟ ဘုရင်ခံမင်းရဲ့ အိုင်တော်ဝင်းသို့ ခေါ်ဆောင်သွားယွေ့ တပ်ဖွဲ့တဖွဲ့လုံးဟို စုရုံးစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ကိုယ်တော်ဟို သူလို့ဟ ခရမ်းရောင်ဝတ်ရုံဟို ဝတ်ဆင်စေယွေ့ ဆူးခက်များဖြင့် သရဖူဟို ပြုလုပ်ပင်း၊ သူရဲ့ ခေါင်းပေါ်မှာ တင်ထားစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","အေးနောက် “ယုဒဆှင်ဘုရင် သက်တော်ရှည်ပါစေသော” ဟု သူလို့ဟ ကိုယ်တော်ဟို စတင် နှုတ်ဆက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","သူလို့ဟ ကိုယ်တော်ဟို တုတ်နဲ့ ဦးခေါင်းဟို ရိုက်ကြအယ်၊ ကိုယ်တော်ဟို ဆံထွေးနဲ့ထွေးပင်း၊ သူလို့ဟ ဒူးထောက်ယွေ့ ကိုယ်တော်ဟို ရှိခိုးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","သူလို့ဟ ကိုယ်တော်ဟို လှောင်ပြောင်ကြပင်းသောအခါ၊ သူလို့ဟ ခရမ်းရောင်ဝတ်ရုံဟို ချွတ်ယွေ့ ကိုယ်တော်ရဲ့ အဝတ်တော်ဟို ပြန်ဝတ်ပေးကြအယ်။ အဲပင်းရင် သူလို့ဟ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ရန် ကိုယ်တော်ဟို အပြင်သို့ ခေါ်ထုတ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","အေးအချိန်တွင် အာလေဇန္ဒြုနဲ့ ရုဖုတို့ရဲ့ အဖ၊ ကုရေနေပြေသား ရှိမုန်ဟ ကျေးလက်တောရွာဖက်မှ လာယွေ့ လမ်းနှိုက်ဖြတ်သွားတာဟို သူလို့ဟ သူ့ဟို အတင်းကြပ်ခေါ်ယွေ့ ကိုယ်တော်ရဲ့ လက်ဝါးကပ်တိုင်ဟို ထမ်းစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","သူလို့ဟ ယေရှုဟို ဂေါလဂေါသ ဟုခေါ်သော အရပ်ဟို ခေါ်ဆောင်သွားကြအယ် (အနက်အဓိပ္ပာယ်မှာ “ဦးခေါင်းခွံအရပ်” ဖြစ်အယ်။) ");
INSERT INTO dnv_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","အေးနောက် သူလို့ဟ မုရန်နဲ့ ရောစပ်ထားသော စပျစ်ယေဟို ကိုယ်တော်အား တိုက်ကြအယ်၊ အဲလိုလဲ ကိုယ်တော်ဟ မသောက်ပေ။ ");
INSERT INTO dnv_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","အဲပင်းရင် သူလို့ဟာ ကိုယ်တော်ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ကြအယ်။ ကိုယ်တော်ရဲ့ အဝတ်တော်များဟို ခွဲဝေယူကြအယ်၊ သူလို့ဟ ပစာရမလဲဆိုတာဟို ကျေ့ဖို့ စာရေးတံချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ကိုယ်တော်ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်လဲ့အချိန်မှာ နက်စာပိုင်း ကိုးနာရီ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ကိုယ်တော်ရဲ့ ပစ်မှုဟို ကမ္ပည်းရေးထိုးယွေ့ လက်ဝါးကပ်တိုင်ထက်တွင် တင်ထားတာဟ “ယုဒဆှင်ဘုရင်” ဟု ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","သူလို့ဟ ကိုယ်တော်နဲ့အတူ ထားပြနေယောက်ဟို ညာဖက်တွင် တယောက် ဘယ်ဖက်တွင် တယောက် လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ဖြတ်သွားလဲ့ လူတွေဟ သူလို့ ခေါင်းဟိုခါပင်း၊ “ဟဲ့ ဗိမာန်တော်ဟို ဖြိုဖျက်ယွေ့ သုံးရက်တွင် ပြန်လည်တည်ဆောက်မဲ့သူ၊ ");
INSERT INTO dnv_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","လက်ဝါးကပ်တိုင်ပေါ်မှ ဆင်းခဲ့မန့်၊ နင့်တတ်တိုင်း ကယ်တင်ပါလား” ဟု ယေရှုဟို ကဲ့ရဲ့စကားပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","အဲနည်းတူ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာလို့ဟ ယေရှုဟို ကဲ့ရဲ့လှောင်ပြောင်ကြအယ်။ “ဟေသူဟ သူများဟို ကယ်တင်နိန်အယ်၊ အဲလိုလဲ သူ့တတ်တိုင်းတော့ မကယ်တင်နိန်ဝူးဟု သူလို့အချင်းချင်း ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","မေဆှိယ၊ ဣသရေလဆှင်ဘုရင်၊ ငါလို့ မျော်ယွေ့ ယုံကြည်မည့်အကျောန်း လက်ဝါးကပ်တိုင်မှ အခု ဆင်းခဲ့ပါစေ” ဟု အချင်းချင်းပြောဆိုကြအယ်။ ယေရှုနဲ့အတူ လက်ဝါးကပ်တိုင်မှာ ရိုက်ထားသော နေယောက်လို့ဟလည်း သူ့ဟို ကဲ့ရဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","မွန်းတည့်ချိန်နှိုက် အမိုက်ဟ မွန်းလွဲသုံးနာရီတိုင်အောန် မြေတပြင်လုံးနှိုက် လွှမ်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","မွန်းလွဲသုံးနာရီအချိန်တွင် ယေရှုဟ “ဧလိ၊ ဧလိ၊ လာမ ရှာဗခသာနိ” ဟု ကျယ်စွာ ကြွေးကြော်လေအယ်။ ဆိုလိုလဲ့အနက်ဟ “အကျွန်ုပ်ဘုရား၊ အကျွန်ုပ်ဘုရား၊ ပစာကျောန့် အကျွန်ုပ်ဟို စွန့်ပစ်သလော” ဟု ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","အနီးနှိုက် ရပ်နေသောသူအချို့လို့ဟ အေးစကားဟို ကြားသောအခါ၊ သူလို့ဟ “နားထောင်လော့၊ သူဟ ဧလိယဟို ခေါ်နေအယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","လူတယောက်ဟ ပြေးယွေ့ ပင်လယ်ယေမြုပ်ဟို ပုံးယေနဲ့ ပြေ့စေပင်း၊ ကျူရိုးအဖျားတွင် တပ်ယွေ့ ယေရှုအား သောက်ရန် ကမ်းပေးခဲ့အယ်။ “အခု သူ့ဟို တယောက်တည်း ထားလိုက်မန့်။ ဧလိယဟ သူ့ဟို ယူခြင်းငှာ လာမယ် မလာမယ်ဟို ငါလို့ ကျေ့ကြစို့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ယေရှုဟ ကျယ်လောင်စွာ ကြွေးကြော်သံဖြင့် အသက်ချုပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ဗိမာန်တော်ဆိ ကန့်လန့်ကာဟ အထက်စွန်းမှ အောက်စွန်းတိုင်အောန် နေခြမ်းကွဲလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ယေရှုရဲ့ ဆေ့တွင် ရပ်နေသော တပ်မှူးဟ ကိုယ်တော် အသက်ချုပ်ပုံဟို မျော်သဖြင့် “ဟေသူဟ အမန်ပင် ဘုရားသခင်ရဲ့ သားတော် ဖြစ်အယ်” ဟု သူဟ ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","အဝေးကနေ လှမ်းကျေ့နေလဲ့ အမျိုးသမီးအချို့ ဆိနေအယ်။ အေးသူလို့အထဲတွင် မာဂဒလမြို့သူ မာရိ၊ မောင်ငယ် ယာကုပ်နဲ့ ယောသပ်လို့ရဲ့ အမိဖြစ်သူ မာရိနဲ့ ရှာလုံလို့ ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","သူလို့ဟ ဂါလိလဲပြေနှိုက် ဆိစဉ်တွင် ယေရှု နောက်တော်သို့ လိုက်ယွေ့ လုပ်ကျွေးသမှု ပြုခဲ့ကြအယ်။ သူလို့အပြင် ကိုယ်တော်နဲ့ ယေရုရှလင်မြို့သို့ လိုက်လာသော အခြားအမျိုးသမီးများလည်း အဲနေရာတွင် ဆိနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","အရိမဿဲမြို့သား ယောသပ် ရောက်လာသောအခါ ညနေစောင်းနေပီ။ သူဟ ဂုဏ်အသရေ ကြီးမြင့်သူ တရားလွှတ်တော်အဖွဲ့ဝင် ဖြစ်ပင်း၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်တည်မဲ့အချိန်ဟို စောင့်မျှော်နေသူဖြစ်အယ်။ အဖိတ်နေ့ (ဥပုသ်နေ့) ဖြစ်သောကျောန့် ယောသပ်ဟ ပိလတ်မင်းဆေသို့ ရဲရင့်စွာ သွားယွေ့ ယေရှုရဲ့ အလောင်းဟို တောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ယေရှု သေဆုံးသွားပီဆိုတာဟို ကြားသော် ပိလတ်မင်းဟ အံ့ဩသွားအယ်။ သူဟ တပ်မှူးဟို ခေါ်ပင်း ယေရှု သေဆုံးတာ ကြာပီလောဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","သူဟ တပ်မှူးရဲ့ အစီရင်ခံချက်ဟို ကြားရပင်းနောက်၊ ပိလတ်မင်းဟ ယောသပ်အား အလောင်းဟို ယူခွင့်ပြုအယ်ဟု ပြောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ယောသပ်ဟ ပိတ်ချောဟို ဝယ်ယွေ့ အလောင်းဟို လက်ဝါးကပ်တိုင်မှ ချယွေ့ ပိတ်ချောဖြင့် ပတ်ကာ၊ ကျောက်ဆောင်ဟို ထွင်းထားလဲ့ လုတ်တိုင်းဂူနှိုက် ထားလေအယ်။ အဲပင်းရင် လုတ်တိုင်းဝတွင် ကျောက်တုံးကြီးဟို လှိမ့်ချလိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","မာဂဒလမြို့သူ မာရိနဲ့ ယောသပ်ရဲ့ အမေ့ မာရိလို့ဟ ယေရှုရဲ့ အလောင်းဟို ပစာနေရာနှိုက် ထားကြတာဟို ကျေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ဥပုသ်နေ့ လွန်သွားသောအခါ၊ မာဂဒလမြို့သူ မာရိ၊ ယာကုပ်ရဲ့ အမေ မာရိနဲ့ ရှာလုံလို့ဟ ယေရှုရဲ့ အလောင်းဟို သွားယွေ့ လိမ်းရန် ဆီမွှေးများဟို ဝယ်ယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","တနင်္ဂနွေနေ့ နက်စာအစော၊ နေထွက်ချိန်တွင်၊ သူလို့ဟ လုတ်တိုင်းသို့ သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","အားပင်း သူလို့ဟ “လုတ်တိုင်းဂူဝမှ ကျောက်တုံးဟို စသူ လှိမ့်ဖယ်ပေးမှာလုန်း” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","အဲလိုလဲ သူလို့ မော်ကျေ့လိုက်သောအခါ၊ ရမ်းဆာ့ကြီးသော ကျောက်တုံးမှာ၊ လှိမ့်ထားနှင့်ပီး ဖြစ်တာဟို သူလို့ မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","သူလို့ဟ လုတ်တိုင်းဂူထဲသို့ ဝင်စဉ်၊ သူလို့ဟ အဖြူရောင် ဝတ်ရုံဟို ဝတ်ဆင်ထားသော လူငယ်တဦးဟ လက်ယာဖက်ဘက်နှိုက် ထိန်နေတာဟို မျော်ကြအယ်၊ အဲအခါ သူလို့ဟ ထိတ်လန့်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","သူဟ “မထိတ်လန့်ကြနဲ့” ဟု ပြောအယ်။ နင်လို့ဟ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့ အသတ်ခံရသူ နာဇရက်မြို့သား ယေရှုဟို ဆာလျက်နေတာဟို ငါသိအယ်။ သူဟ ဟေမှာမဆိ၊ ကိုယ်တော်ဟ ထမြောက်ပီ။ ကိုယ်တော်ရဲ့ အလောင်းဟို ထားသောနေရာဟို ကျေ့ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","အဲလိုလဲ သွားယွေ့၊ ပေတရုနဲ့ ကိုယ်တော်ရဲ့ တဘဲ့တော်များအား “ကိုယ်တော်ဟ ဂါလိလဲပြေသို့ နင်လို့ ဦးရင်သွားနှင့်ပီ။ ကိုယ်တော် ပြောတဲ့အတိုင်း၊ အေးမှာ နင်လို့ သူဟို မျော်ရလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","အမျိုးသမီးများဟ တုန်လှုပ်ခြင်းနဲ့ မိန်းမောတွေဝေလျက် လုတ်တိုင်းမှ ထွက်ပြေးကြအယ်။ သူလို့ဟ ကြောက်ရွံ့သောကျောန့် စသူကိုမှ စလိုအရာဟိုမျှ မပြောခဲ့ကြဘူး။ အဆုံးသတ်လဲ့ နည်းဟောင်းတမျိုး  ");
INSERT INTO dnv_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","တနင်္ဂနွေနေ့ နက်စာအစောတွင် ယေရှုဟ သေခြင်းမှ ထမြောက်ပင်းနောက်၊ ကိုယ်တော်ဟ သူ့ဆေမှ နတ်ဆိုး ခုနစ်ဦးဟို မောင်းထုတ်ပေးခဲ့သော မာဂဒလမြို့သူ မာရိဆေ ဦးရင်ဆုံး ကိုယ်ထင်ပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","သူမဟ သွားယွေ့ ကိုယ်တော်ရဲ့ အဖော်များဟို ပြောပြခဲ့အယ်၊ သူလို့ဟ ငိုက မြည်တမ်းကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ယေရှု အသက်ဆှင်ယွေ့၊ ကိုယ်တော်အား မာရိ မျော်ခဲ့ရကျောန်း၊ သူလို့ ကြားသောအခါ မယုံကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ဒီနောက် သူလို့ထဲမှ နေယောက်ဟ တောရွာဟို သွားကြစဉ် ယေရှုဟ ခြားနားသော ပုံစံဖြင့် သူလို့အား ကိုယ်ထင်ပြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","သူလို့ ပြန်လာပင်း အခြားသူတွေဟို ပြောပြအယ်၊ အဲလိုလဲ သူလို့ဟ မယုံကြ။ ");
INSERT INTO dnv_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","အဲပင်းရင် ယေရှုဟ တဆယ့်တပါးသော တဘဲ့တော်လို့အား စားသောက်နေစဉ် သူလို့ဟို ကိုယ်ထင်ပြလေအယ်။ သူလို့တွင် ယုံကြည်ခြင်းမဆိသောကျောန့် ကိုယ်တော်အား ဖူးမျော်ရသူလို့ရဲ့စကားဟို မယုံနိန်လောက်အောန် သူလို့ဟ ခေါင်းမာသောကျောန့်၊ ကိုယ်တော်ဟ သူလို့အား ပစ်တင်ဆုံးမလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ကိုယ်တော်ဟ “ကမ္ဘာတဝှမ်းလုံးသို့ သွားယွေ့ လူသတ္တဝါအပေါင်းလို့အား ဧဝံဂေလိတရားဟို ဟောကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ယုံကြည်ယွေ့ နှစ်ခြင်းဟို ခံသောသူဟ ကယ်တင်ခြင်းဟို ရောက်လိမ့်မယ်၊ မယုံကြည်သောသူဟ အပစ်စီရင်ခြင်း ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ယုံကြည်သူလို့ဟ အံ့ဖွယ်အမှုများ ပြုလုပ်ရန် တန်ခိုးဟို ခံရမယ် ဖြစ်ပင်း၊ သူလို့ဟ ငါရဲ့ နာမဟို အမှီပြုယွေ့ နတ်ဆိုးများဟို မောင်းထုတ်ကြလိမ့်မယ်ဖြစ်ပင်း၊ ထူးခြားသော ဘာသာစကားများဟို ပြောဆိုကြလိမ့်မယ်၊ ");
INSERT INTO dnv_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","မြွေဆိုးများဟို ကိုင်ဖမ်းသော် အဲဟာမဟုတ်ရင် သေစေတတ်သော အဆိပ်ဟို သောက်ရင်လည်း သူလို့တွင် ဘေးအန္တရာယ်ဖြစ်စေမယ် မဟုတ်၊ မကျန်းမာသူများအပေါ်တွင် လက်ဟို တင်ယွေ့ အဲသူလို့ဟ ကျန်းမာလာကြလိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","သခင် ယေရှုဟ သူလို့နဲ့ စကားပြောပင်းနောက်၊ ခေါန်းခင်ဘုံသို့ ဆောင်ယူခြင်းဟို ခံပင်း ဘုရားသခင်ရဲ့ လက်ယာတော်ဖက်တွင် ထိန်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","တဘဲ့တော်လို့ဟ အရပ်ရပ်သို့ သွားယွေ့ တရားဟောသဖြင့်၊ သခင်ဘုရားဟ သူလို့နဲ့အတူ လုပ်ဆောင်ပင်း အံ့ဖွယ်သောအမှုများဖြင့် သူလို့ရဲ့ ဟောပြောခြင်း မန်ကန်ကျောန်း သက်သေပြခဲ့အယ်။ အခြားသော နည်းဟောင်းအဆုံးသတ်  ");
INSERT INTO dnv_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","အမျိုးသမီးများဟ ပေတရုနဲ့ သူရဲ့ သူငယ်ချင်းများဆေဟို သွားယွေ့ သူလို့ ပြောသမျှဟို အတိုချုပ် ပြောပြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","အဲပင်းရင်၊ ယေရှုတတ်တိုင်း ထာဝရကယ်တင်ခြင်းဆိုင်ရာ မြင့်မြတ်ပင်း ထာဝရ အသက်ဆှင်သော သတင်းစကားဟို အဆေ့ဖက်မှ အနောက်ဖက်ဆေဟို တဘဲ့တော်များမှ တဆင့် စေလွှတ်ခဲ့အယ်။");
INSERT INTO dnv_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ချစ်လှစွာသော သော်ဖိလု၊ လူများစွာဟ ငါလို့ကြားတွင် ဖြစ်ပျက်လာရမဲ့ အဖြစ်အပျက်များဟို မှတ်တမ်းတခုရေးရန် အစွမ်းကုန် ကြိုးစားခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","အဲအကျောန်းအရာများဟို မျက်မြင်သက်သေများ ဖြစ်ယွေ့ ယေရှုအကျောန်းဟို ဟောပြောသူလို့ရဲ့ ဟောကြားချက်အရ ကျမ်းပြုပုဂ္ဂိုလ်လို့ဟ ရေးသားပြုစုခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","အဲကျောန့် သော်ဖိလု၊ အဲအကျောန်းအရာအားလုံးဟို အစကတည်းဟ သေသေချာချာ လေ့လာပင်းပီ ဖြစ်လို့ နင့်အတွက် အစီစဉ် ညီညွတ်တာဟို ပြုစုရသော် ကောင်းမယ်ဟု ထင်မှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","နင် ဟောသောအမှုအရာများနဲ့ ပတ်သက်ယွေ့ မန်ကန်သောအရာများဟို နင် သိရန် အကျောန်းအရာဟို ပြုစုရခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ယုဒပြေဘုရင် ဟေရုဒ်မင်း လက်ထပ်နှိုက် ဇာခရိ နာမယ်ဆိသော ယဇ်ပုရောဟိတ်တပါး ဆိအယ်၊ အေးလူဟ အဘိယ ယဇ်ပုရောဟိတ်အဖွဲ့ဝင် ဖြစ်အယ်။ အေးလူရဲ့ ပေါင်အိုမဟ ဧလိရှဗက် နာမယ်တွင်အယ်၊ ဧလိရှဗက်ဟလည်း အာရုန်အနွယ်ဝင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","အဲသူ နေဦးလုံးဟ ဘုရားသခင်ရဲ့ ဆေ့တွင် သူတော်ကောင်းများ ဖြစ်ကြအယ်။ သခင်ဘုရားရဲ့ ပညတ်တော်ဆိသမျှနဲ့ ညွှန်ကြားချက်များဟို တခုမကျန် နားထောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ဧလိရှဗက်ဟ မြုံနေသောကျောန့် သူလို့မှာ လူပဲ့သငယ် မဆိ၊ သူမနဲ့ ဇာခရိနေယောက်လုံး ရမ်းဆာ့အိုကြပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","တနေ့မှာ ဇာခရိဟ မိမိရဲ့ အဖွဲ့အလှည့်ကျသဖြင့် ဗိမာန်တော်နှိုက် ယဇ်ပုရောဟိတ် တာဝန်ဟို ဆောင်ရွက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ယဇ်ပုရောဟိတ်လို့ရဲ့ စလေ့အရ၊ သူဟ ယဇ်ပလ္လင်ပေါ်မှာ နံ့သာပေါင်းဟို မီးရှို့ဖို့ သူ့ဟ အများကြီးအားဖြင့် ရွေးချယ်ခဲ့အယ်။ အေးကျောန့် သူဟ သခင်ဘုရားရဲ့ ဗိမာန်တော်ထဲဟို သွားခဲ့အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","နံ့သာပေါင်း မီးရှို့လဲ့အချိန်အတွင်း အပြင်မှာဆိလဲ့ လူအုပ်လို့ဟ ဆုတောင်းလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","အေးအခါ သခင်ဘုရားရဲ့ ခေါန်းခင်တမန်ဟ ဇာခရိအဆေ့မှာ ပေါ်လာယွေ့၊ နံ့သာပေါင်းဟို မီးရှို့ပူဇော်သော ယဇ်ပလ္လင်ရဲ့ လက်ယာဖက်တွင် ရပ်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ဇာခရိဟ ခေါင်းခင်တမန်ဟို မျော်သောအခါ၊ သူဟ ထိတ်လန့်ပင်း ကြောက်လန့် သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","အဲလိုလဲ ခေါန်းခင်တမန်ဟ “ဇာခရိ၊ မကြောက်နဲ့၊ ဘုရားသခင်ဟ နင် ဆုတောင်းလဲ့အရာဟို နားညောင်းပီ၊ နင်ရဲ့ ပေါင်အိုမ ဧလိရှဗက်ဟ အောင်နီငယ်ဟို ဖွားမျော်လိမ့်မယ်။ နင်ဟ သူ့ဟို ယောဟန်ဟု နာမယ်မှည့်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","သူဟ နင့်အတွက် ဝမ်းမြောက်ပင်း ပျော်ရွှင်စေလိမ့်မယ်၊ အခြားသောလူများဟလည်း သူရဲ့ မွေးလာခြင်းအတွက် ဝမ်းမြောက်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","သူဟ သခင်ဘုရားရဲ့ အဆေ့တွင် ကြီးမြတ်သောသူ ဖြစ်လိမ့်မယ်။ သူဟ စပျစ်ယေနဲ့ သေယေသေရက်ဟို သောက်လိမ့်မယ် မဟုတ်။ မွေးကတည်းဟ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ရမ်းဆာ့များသော ဣသရေလအမျိုးသားလို့ဟို မိမိလို့ရဲ့ ဘုရားသခင် သခင်ဘုရား ဆေသို့ ပြန်လည် ပို့ဆောင်ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ကိုယ်တော်ရဲ့ ဆေ့ပြေး ဖြစ်ယွေ့၊ ဧလိယလိုမျိုး ခွန်အားတန်ခိုးကြီး လိမ့်မယ်။ သူဟ အဖလို့ဟို လူပဲ့သငယ်လို့နဲ့ ပြန်လည် သင့်မြတ်စေလိမ့်မယ်။ မနာခံသောသူလို့အား သူတော်ကောင်းလို့ရဲ့ အသိပညာဟို ပြန်လည် ရဆိစေလိမ့်မယ်၊ ဘုရားသခင်အတွက် အဆင်သင့်ဖြစ်စေရန် ကိုယ်တော်ရဲ့ လူစုတော်ကို ပြင်ဆင်ပေးလိမ့်မယ်” ဟု ဇာခရိအား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ဇာခရိဟ “ဟေသို့ ဖြစ်မယ်ဟို စလို သိနိန်မလုန်း၊ ငါဟ အိုစာနေရီး ဖြစ်အယ်၊ ငါ့ပေါင်အိုမဟလည်း အသက်ကြီးနေပီ” ဟု ခေါန်းခင်တမန်အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ခေါန်းခင်တမန်ဟ “ငါဟ ဘုရားသခင်ရဲ့ အဆေ့မှာ ခစားရသော ဂါဗြေလ ဖြစ်အယ်၊ နင့်အား ဟေသတင်းကောင်းဟို ဟောပြရန် ငါ့ကို စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","နင်ဟ ငါဟောပြောသော စကားဟို မယုံကြည်သောကျောန့် ဟေအမှုအရာ ဖြစ်လာတဲ့နေ့ချိန်ထိ စကားမဟောနိန်ဘဲ အလျက် နေလိမ့်မယ်၊ အချိန်တန်ရင် ငါ့ရဲ့စကား မန်ကန်လာလိမ့်မယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","လူလို့ဟ ဇာခရိဟို ငံ့လျက် နေယွေ့ သူဟ ဗိမာန်တော်ထဲတွင် ကြန့်ကြာနေတာဟို အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ဇာခရိ ပြန်ထွက်လာသောအခါ သူလို့အား စကားမပြောနိန်တော့သဖြင့် သူဟ ဗိမာန်တော်ထဲနှိုက် ဗျာဒိတ်ရူပါရုံဟို မျော်ခဲ့ရပီဟု သူလို့ သိဆိကြအယ်။ ဇာခရိဟ သူလို့အား စကားအယွေ့ လက်ဟန်ခြေဟန် ပြလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ဗိမာန်တော်နှိုက် ယဇ်ပရောဟိတ် တာဝန်ဟို ဆောင်ရွက်ရသော အချိန်ကာလကုန်ပင်း၊ ဇာခရိဟ နေအိုင်ဟို ပြန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","အချိန် ကတစ်ကြာသောအခါ သူရဲ့ပေါင်အိုမ ဧလိရှဗက်ဟ လူပဲ့စွဲယွေ့ ငါးလပတ်လုံးလုံး အိုင်တွင်း အောင်းလျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ဧလိရှဗက်ဟ “အခု ငါ့အား သခင်ဘုရား ကူညီပီ၊ ငါ့အား လူလို့ရဲ့ ကဲ့ရဲ့ခြင်းဟို ကိုယ်တော်ဟ ပပျောက်စေပီ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ဧလိရှဗက် လူပဲ့စွဲစာ ခြောက်လထဲ ရောက်သောအခါ ဘုရားသခင်ဟ ခေါန်းခင်တမန် ဂါဗြေလအား ဂါလိလဲပြေ နာဇရက်မြို့ဆိ မိန်းမပျိုတဦးဆေဟို စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","အဲအပျိုကညာဟ ဒါဝိဒ်မင်းမှ ဆင်းသက်သူ ယောသပ် နာမယ်ဆိသော ကွင်တယောက်နဲ့ နားဖောက်ထားသူ ဖြစ်အယ်။ သူမ နာမယ်ဟ မာရိ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ခေါန်းခင်တမန်ဟ မာရိဆေဟို လာယွေ့ “ရမ်းဆာ့ ကောင်းကြီးဟို ခံစားရသော မိနီ၊ နင်နဲ့အတူ ငြိမ်သက်ခြင်း ဆိပါစေ၊ သခင်ဘုရားဟ နင်နဲ့အတူ ဆိအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","မာရိဟ ခေါန်းခင်တမန်ရဲ့ စကားကျောန့် စိတ်မငြိမ်မသက်ဖြစ်ကာ ဟေနှုတ်ဆက်စကားဟ စလိုလုန်းဟု တွေးတောဆင်ခြင်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ခေါန်းခင်တမန်ဟ “မာရိ၊ မကြောက်နဲ့၊ နင်ဟ ဘုရားသခင် ဆေ့မှာ မျက်နှာရပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","နင်ဟ လူပဲ့စွဲယွေ့ အောင်နီငယ်ဟို မွေးလိမ့်မယ်၊ အဲအောင်နီငယ်ဟို ယေရှုလို့ နာမယ် မှည့်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","အောင်နီငယ်ဟ ကြီးမြတ်လိမ့်မယ်၊ အမြင့်မြတ်ဆုံးသော ဘုရားသခင်ရဲ့ သားတော်ဟု အခေါ်ခံရလိမ့်မယ်။ သခင် ဘုရားသခင်ဟ သူ့အဖ ဒါဝိဒ်မင်းရဲ့ ရာဇပလ္လင်ဟို သူ့အား ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","သူဟ ယာကုပ်အမျိုးဟို အစဉ်အမြဲ အုပ်ချုပ်လိမ့်မယ်၊ အေးသူရဲ့ နိုင်ငံဟလည်း ပစာခါမှ ကုန်ဆုံးလိမ့်မယ် မဟုတ်” ဟု မာရိအား ဟောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","မာရိဟ “ငါသည် အပျိုကညာ ဖြစ်သဖြင့် စလို လူပဲ့စွဲယွေ့ အောင်နီငယ်ဟို မွေးနိန်မှာလုန်း” ဟု ခေါန်းခင်တမန်ဟို မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ခေါန်းခင်တမန်ဟ “သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ နင်ရဲ့ အပေါ်ဟို သက်ရောက်ပင်း အမြင့်မြတ်ဆုံးသော ဘုရားသခင်ရဲ့ တန်ခိုးတော်ဟ နင့်ဟို လွှမ်းမိုးလိမ့်မယ်။ အဲအကျောန်းကျောန့် သန့်ဆှင်းသော သားဟလည်း ဘုရားသခင်ရဲ့ အောင်နီဟု ခေါ်ခြင်းဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","နင်ရဲ့ ဆွေမျိုးဖြစ်သော ဧလိရှဗက်ဟလည်း အသက်ကြီးသောအခါမှ လူပဲ့စွဲလျက် ဆိအယ်၊ အမြုံမလို့ အခေါ်ခံရသူဟ လူပဲ့စွဲယွေ့ အခု ခြောက်လအဝင် ဆိပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ဘုရားသခင် မတတ်နိန်သောအမှုအရာ တခုမှမဆိ” ဟု ဟောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","မာရိဟ “ကျွန်မသည် သခင်ဘုရားရဲ့ အစေခံ ဖြစ်ပါအယ်။ ကိုယ်တော်ရဲ့ စကားအတိုင်း ငါနှိုက် ဖြစ်ပါစေသော” ဟု ခေါန်းခင်တမန်အား ပြန်ပြောအယ်၊ အဲအခါ ခေါန်းခင်တမန်ဟ သူမဆေမှ ထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","များမကြာမီ မာရိဟ ပြင်ဆင်ယွေ့ တောင်ပေါ်ဒေသဆိ ယုဒပြေရဲ့ မြို့တမြို့ဟို အလျင်အမြန် သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","သူမဟ ဇာခရိရဲ့ နေအိုင်ဟို ဝင်ပင်း ဧလိရှဗက်ဟို နှုတ်ဆက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","မာရိရဲ့ နှုတ်ဆက်စကားဟို ကြားသောအခါ၊ ဧလိရှဗက်ရဲ့ ဖိုက်ထဲဟ လူပဲ့ဟ လှုပ်လေအယ်၊ ဧလိရှဗက်ဟ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝလျက်၊ ");
INSERT INTO dnv_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","သူဟ အသံကျယ်ကျယ် ဟောတာဟ “နင်ဟ မီနီတကာလို့ထက် မင်္ဂလာဆိအယ်၊ နင်မွေးမဲ့ အောင်နီငယ်ဟ မင်္ဂလာဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ငါ့အဆှင်ရဲ့ မယ်တော်ဟ ပစာကျောန့် ငါ့ဆေဟို ကြွလာလုန်း၊ ပစာကျောန့် ဟေအခွင့်ထူးဟို ငါခံစားရလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","နင့်ရဲ့ နှုတ်ဆက်စကားဟို ကြားသောအခါ ငါရဲ့ ဖိုက်မှာ လူပဲ့ငယ်ဟ ဝမ်းမြောက်ရွှင်မြူးသဖြင့် ခုန်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","သခင်ဘုရား ပေးသော ဗျာဒိတ်တော်အတိုင်း ဖြစ်လိမ့်မယ်လို့ နင်ဟ ယုံကြည်သဖြင့် မင်္ဂလာဆိအယ်” ဟုဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","မာရိဟ “ငါရဲ့ စိတ်နေလုံးဟ သခင်ဘုရားဟို ချီးမွန်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ငါ့ဟို ကယ်တင်သောအဆှင် ဘုရားသခင်ဟို အမှီပြုယွေ့ ငါ့စိတ်ဝိညာဉ်ဟ ရွှင်လန်းပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ကိုယ်တော်ဟ မိမိအစေခံရဲ့ နိမ့်ကျသောအဖြစ်ဟို သတိရပီ၊ အခုမှစယွေ့ နောင်လာမဲ့ လူသားအပေါင်းလို့ဟ ငါ့ဟို မင်္ဂလာဆိသူဟု ခေါ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ပစာကို့ တန်ခိုးကြီးသော ဘုရားသခင်ဟ ငါ့ဖို့ အံ့ဖွယ်သောအမှုများဟို ပြုသောကျောန့် ဖြစ်အယ်။ ကိုယ်တော်ရဲ့ နာမတော်ဟ မြင့်မြတ်သန့်ဆှင်းအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","မျိုးဆက် တဆက်မှ နောက်တဆက်အထိ ကိုယ်တော်ဟို ရိုသေသူအပေါင်းလို့အား ကရုဏာတော်ဟို ပြသအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ကိုယ်တော်ဟ ခွန်အားကြီးသော လက်ရုံးတော်ဟို ဆန့်ယွေ့၊ မာနထောင်လွှားသော သူလို့ဟို အကြံအစည် ဆိသမျှနဲ့ ကွဲလွင့်စေပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ဘုရင်များဟို သူလို့ ပလ္လင်ပေါ်မှ ချယွေ့၊ နှိမ့်ချသောသူများဟို ချီးမြှောက်ပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ဖိုက်ဆာသောသူလို့အား ကောင်းသောအရာများနဲ့ ကျွေးမွေးယွေ့၊ ချမ်းသာသောသူများဟို လက်ချဲချဲ လွှတ်လိုက်ပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ကိုယ်တော်ဟ ငါလို့ရဲ့ ဖိုးဖေးများအား ပေးခဲ့လဲ့ ကတိတော်နဲ့အညီ၊ မိမိရဲ့ အစေခံ ဣသရေလလူလို့ဟို မစပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","အာဗြဟံနဲ့ သူရဲ့ အမျိုးနွယ်လို့ဆေ ထားသော ကရုဏာဟို အစဉ်အမြဲ ပြုခြင်းငှာ သတိရပီ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","အဲပင်းရင် မာရိဟ ဧလိရှဗက်နဲ့ သုံးလခန့် နေပင်းနောက် နေအိုင်ဟို ပြန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ဧလိရှဗက်ဟ မွေးလစေ့သောအခါ၊ အောင်နီငယ်ဟို မွေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","သခင်ဘုရားဟ ကြီးမြတ်လဲ့ ကရုဏာတော်ဟို သူမအပေါ် ပြသကျောန်း အိုင်နီးချင်းများနဲ့ ဆွေမျိုးများလို့ဟ ကြားသောအခါ သူလို့အားလုံးဟ သူမနဲ့အတူ ဝမ်းမြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","တပတ်မြောက်သောနေ့နှိုက် သူလို့ဟ အောင်နီငယ်ရဲ့ အရေဖျားလှီးခြင်း ပေးရန် လာကြယွေ့ သူ့အား ဇာခရိဟူယွေ့ အဖရဲ့ နာမယ်ဟို ပေးချင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","အဲလိုလဲ သူ့ရဲ့ အမေ့ဟ “အေးနာမယ်ကို မမှည့်ပါနဲ့၊ ယောဟန်လို့ မှည့်ခေါ်ကြပါ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","လူလို့ဟ “နင်ရဲ့ အမျိုးတွင် ယောဟန်လို့ နာမယ်တွင်သူ တယောက်မှမဆိ” ဟု သူမအား ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","အဲပင်းရင် သူ့ဖဟို လက်ဟန်ခြေဟန်နဲ့ ပြယွေ့ စလို မှည့်စေလိုလောဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ဇာခရိဟ ကျောက်သင်ပုံးတချပ်ကို တောင်းယူပင်းရင်၊ “အောင်နီငယ်ရဲ့ နာမယ်ဟ ယောဟန် ဖြစ်အယ်” ဟု ရေးအယ်၊ အေးအခါ အဲသူအပေါင်းလို့ဟ ရမ်းဆာ့ အံ့သြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ခုတုံးပင် ဇာခရိဟ ပြန်လည် စကားပြောနိန်သဖြင့်၊ ဘုရားသခင်ဟို စတင် ချီးမွန်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","အိုင်နီးချင်းအပေါင်းလို့ဟ ကြောက်ရွံ့ခြင်းနဲ့ ပြေ့ကြယွေ့၊ ဟေအဖြစ်အပျက်သတင်းဟ ယုဒပြေ တောင်ပေါ်ဒေသ တဆှောက်လုံးဟို ပျံ့နှံသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ကြားကြသူအပေါင်းလို့ဟ စိတ်နေလုံးနှိုက် မှတ်သားယွေ့ “ဟေအောင်နီငယ်ဟ စလိုလူ ဖြစ်လိမ့်မလုန်း” ဟု ပြောဆိုကြအယ်၊ သခင်ဘုရားရဲ့ တန်ခိုးတော်ဟ အဲအောင်နီငယ်အပေါ် သက်ရောက်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ယောဟန်ရဲ့ အဖ ဇာခရိဟ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝလျက် ဟောကြားတာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ဣသရေလ လူမျိုးလို့ရဲ့ ဘုရားသခင်ဟို ချီးမွန်းကြလော့၊ ကိုယ်တော်ဟ ဣသရေလ လူမျိုးလို့ ဆေဟို ကြွလာယွေ့ သူလို့ဟို လွတ်မြောက်စေပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ကိုယ်တော်ရဲ့ အစေခံ ဒါဝိဒ်အမျိုးတွင်၊ ငါလို့အတွက် တန်ခိုးကြီးသော ကယ်တင်ဆှင် ပေါ်ထွန်းပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","မခင်ဟ သန့်ဆှင်းမြင့်မြတ်သူ ပရောဖက်များမှ တဆင့် ");
INSERT INTO dnv_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ကိုယ်တော်ဟ ငါလို့အား ရန်သူများရဲ့ လက်မှ လည်းကောင်း၊ ငါလို့ဟို မုန်းသောသူအပေါင်းလို့ရဲ့ လက်မှ လည်းကောင်း ကယ်တင်ရန်၊ ");
INSERT INTO dnv_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ငါလို့ရဲ့ ဖိုးဖေးများအပေါ်မှာ ကရုဏာထားမယ် ဖြစ်ကျောန်းနဲ့၊ သန့်ဆှင်းသော ပဋိညာဉ်ဟို သတိရမယ် ဖြစ်ကျောန်း မိန့်ခဲ့ပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","ငါလို့ရဲ့ ဖိုးဖေးများအပေါ် ကရုဏာတော်ဟို ပြသရန်နဲ့ ငါလို့ဟို ရန်သူများရဲ့ လက်မှ ကယ်တင်ယွေ့ ကိုယ်တော်ရဲ့ အစေဟို ကြောက်ရွံ့ခြင်း ကင်းလျက် ဆောင်ရွက်စေမယ်ဟု ငါလို့ရဲ့ အဖ အာဗြဟံအား ကျိန်ဆိုခဲ့ပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ငါလို့ရဲ့ ဖဝါ့တခုလုံး ဘုရားသခင် ဆေ့နှိုက်၊ သန့်ဆှင်းပင်း ဖြောင့်မတ်သောသူ ဖြစ်မဲ့အကျောန်းတည်း။ ");
INSERT INTO dnv_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“အောင်နီငယ်၊ နင်ဟ အမြင့်မြတ်ဆုံးသော ဘုရားသခင်ရဲ့ ပရောဖက်လို့ အခေါ်ခံရလိမ့်မယ်၊ နင်ဟ အဆှင်အတွက် လမ်းဟို အသင့် ပြင်ဆင်ရလိမ့်မယ် ဆေ့ပြေး ဖြစ်ပင်းရင်၊ ");
INSERT INTO dnv_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ကိုယ်တော်ရဲ့ လူစုအား အပစ်ဖြေလွှတ်ယွေ့၊ ကယ်တင်မဲ့အကျောန်း ဟောကြားလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ငါလို့ရဲ့ ဘုရားသခင်ဟ သနားခြင်း ကရုဏာနဲ့ ကြွယ်ဝသောကျောန့် ကိုယ်တော်ဟ ကယ်တင်ခြင်းဟို ခေါန်းခင်မှ နေအရုဏ်ဟ ငါလို့အပေါ်ဟို သက်ရောက်စေယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","မိုက်နဲ့ သေမင်းရဲ့ အရိပ်တွင် နေထိန်သူများအပေါ် ထွန်းလင်း စေလိမ့်မယ်၊ ငါလို့အား ငြိမ်းချမ်းရေး လမ်းဟို ပို့ဆောင်စေလိမ့်မယ်” ဟု ဟောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","အောင်နီငယ်ဟ ကြီးထွားယွေ့ စိတ်ဝိညာဉ် ကြံ့ခိုင်လာပင်း သူဟ ဣသရေလအမျိုးသားလို့ရဲ့ ဆေ့မှာ ထင်ဆှားမပြမီတိုင်အောန် တောကန္တာရနှိုက် နေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","အေးကာလနှိုက် ရောမ အင်ပါယာဆိ သန်းခေါင်စာရင်းဟို ယူရန် ဧကရာဇ် ဩဂုတ္တုဟ အမိန့်ထုတ်ပြန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ဟေလူဦးရေ စာရင်းယူခြင်းဟ ရှုရိပြေ မြို့ဝန် ကုရေနိလက်ထပ်မှာ ပထမ သန်းခေါင်စာရင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","လူအပေါင်းလို့ဟ သန်းခေါင်စာရင်း တင်ရန် မိမိလို့ မြို့ရွာဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ယောသပ်ဟလည်း ဂါလိလဲပြေ နာဇရက်မြို့မှ ယုဒပြေ ဗက်လင်မြို့လို့ နာမယ်တွင်သော ဒါဝိဒ်မင်းရဲ့ မြို့ဟို သွားအယ်။ ယောသပ်ဟ ဒါဝိဒ်ရဲ့ အမျိုးနွယ်ဖြစ်သောကျောန့် အဲဟို သွားခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","သူနဲ့ လက်ထပ်ရန် ကတိပြုပင်း လူပဲ့စွဲနေသော မာရိနဲ့ စာရင်းသွင်းရန် အဲနေရာသို့ သွားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ဗက်လင်မြို့တွင် သူလို့ ဆိကြသောအခါနှိုက် အောင်နီငယ်ကို မွေးရန် နေ့စေ့လစေ့လျှင်၊ ");
INSERT INTO dnv_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","သားဦးဟို မွေးယွေ့ ခနှီးနဲ့ ထုပ်ပင်း၊ ဧည့်သည် တည်းစရာ နေရာနှိုက် သူလို့နေစရာ မဆိသောကျောန့် အောင်နီငယ်ဟို နွားစားခွက်ထဲမှာ သိပ်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","အေးပြေတွင် သိုးထိန်းတချို့ ဆိအယ်၊ သူလို့ဟ ညအခါ ကွင်းပြင်များတွင် သိုးများဟို စောင့်လျက်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","သခင်ဘုရားရဲ့ ခေါန်းခင်တမန်ဟ သူလို့ဆေ့မှာ ပေါ်လာအယ်၊ သူလို့ပတ်လည်တွင် သခင်ဘုရားရဲ့ ဘုန်းတော် ထွန်းတောက်နေသဖြင့် သူလို့ဟ ရမ်းဆာ့ ထိတ်လန့်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ခေါန်းခင်တမန်ဟ “မကြောက်ကြနဲ့၊ ငါဟ လူအပေါင်းလို့ ရမ်းဆာ့ ဝမ်းသာစရာ သတင်းကောင်းဟို နင်လို့ဆေဟို ယူဆောင်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ခုနေ့တွင် ဒါဝိဒ်မြို့နှိုက် သခင် ခရစ်တော်တည်းဟူသော ကယ်တင်ဆှင်ဟ နင်လို့အဖို့ မွေးဖွားပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","နင်လို့ဟ ပစာနိမိတ်ဖြင့် သိရမယ်မှာ၊ အောင်နီငယ်ဟို အနှီးနဲ့ထုပ်ထားပင်း နွားစားခွက်ထဲမှာ သိပ်ထားလျက် ဆိတာဟို မျော်ကြလိမ့်မယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ခေါန်းခင်တမန်နဲ့အတူ ရမ်းဆာ့များသော ခေါန်းခင်ဗိုလ်ခြေလို့ဟ ခုတုံး ပေါ်လာယွေ့၊ ဘုရားသခင်ဟို သီဆို ချီးမွန်းကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ခေါန်းခင်ဘဝဂ်ဝယ် ဘုရားသခင်ဟ ဘုန်းကြီးပါစေ၊ မြေကြီးပေါ်မှာ ငြိမ်သက်ခြင်း ဆိစေယွေ့ လူလို့အား မေတ္တာကရုဏာ ဆိစေသတည်း” ဟု မြွက်ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ခေါန်းခင်တမန်များ ခေါန်းခင်ဘုံဟို ပြန်သွားကြသောအခါ သိုးထိန်းလို့ဟ “ငါလို့သည် ဗက်လင်မြို့ဟို သွားကြကုန်အံ့၊ ငါလို့အား သခင်ဘုရား ဖော်ပြသောအကျောန်းအရာဟို ကျေ့ကြကုန်အံ့” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","သူလို့ဟ အမြန် သွားပင်း မာရိနဲ့ ယောသပ်ဟို လည်းကောင်း၊ နွားစားခွက်ထဲတွင် သိပ်ထားသော အောင်နီငယ်ဟို လည်းကောင်း မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","အောင်နီငယ်ဟို သိုးထိန်းများ မျော်သောအခါ အောင်နီငယ်ရဲ့ အကျောန်းဟို သူလို့အား ခေါန်းခင်တမန် ဟောကျောန်းဟို ပြောကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","သိုးထိန်းလို့ ဟောသောစကားဟို ကြားသောသူ ဆိသမျှလို့ဟ အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","မာရိဟ အေးအကျောန်းအရာ အားလုံးလို့ဟို အောက်မေ့ပင်း နက်နဲစွာ စိတ်နေလုံးထဲမှာ တွေးတောဆင်ခြင်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","သိုးထိန်းလို့ဟ မိမိလို့အား ခေါန်းခင်တမန်ဟောလဲ့အတိုင်း တွေ့မျော် ကြားသိရသဖြင့် ဘုရားသခင်ရဲ့ ဂုဏ်တော်ဟို ချီးမွန်းလျက် ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","တပတ်ကြာပင်းနောက် အောင်နီငယ်အား အရေဖျားလှီးခြင်းဟို ခံယူရန် အချိန်ရောက်လာသောအခါ သူ့အား ယေရှုဟု နာမယ်မှည့်ကြအယ်၊ ဟေနာမယ်ဟ အောင်နီငယ်ဟို လူပဲ့မစွဲခင် ခေါန်းခင်တမန်ဟ ပေးစေလဲ့ နာမယ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","မောရှေရဲ့ ပညတ်တရားအရ စင်ကြယ်ခြင်း အခမ်းအနား ပြုလုပ်ရန် အချိန်ရောက်လာသောအခါ ယောသပ်နဲ့ မာရိလို့ဟ အောင်နီငယ်ဟို သခင်ဘုရားဆေ ဆက်ကပ်ရန် ယေရုရှလင်မြို့ဟို ခေါ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","သခင်ဘုရားရဲ့ ပညတ်တော်နှိုက် လာတာဟ၊ “သားဦး ယောက်ျားအပေါင်းလို့ဟ သခင်ဘုရားအဖို့ သန့်ဆှင်းရမယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ချိုးတူးမ နေကောင် အဲဟာမဟုတ်ရင် ခိုသငယ်နေကောင်ဟို ပူဇော်ရမယ်ဟု သခင်ဘုရားရဲ့ ပညတ်ကျမ်းနှိုက် ဖော်ပြထားလဲ့အတိုင်း ယဇ်ပူဇော်ကြရန် သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","အေးအချိန်နှိုက် ယေရုရှလင်မြို့တွင် ရှုမောင် နာမယ်ဆိသော လူတယောက် ဆိအယ်။ သူဟ ဘုရားသခင်ဟို ကြည်ညိုယွေ့ ဖြောင့်မတ်သောသူ ဖြစ်ပင်း၊ ဣသရေလလူမျိုးလို့ သက်သာခြင်း ရရန် စောင့်မျော်နေသူ ဖြစ်အယ်၊ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ သူအပေါ်နှိုက် တည်ယွေ့ ");
INSERT INTO dnv_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","သူဟ ထာဝရဘုရား ကတိထားလဲ့ မေဆှိယဟို မမျော်ရခင် မသေရဟု ဗျာဒိတ်တော် ရဆိထားသူလည်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ရှုမောင်ဟ ဝိညာဉ်တော် ယိုးခြင်းအားဖြင့် ဗိမာန်တော်ဟို သွားခဲ့လေအယ်။ ပညတ်တရားအရ ဆောင်ရွက်စရာဝတ်ဟို ဆောင်ရွက်ရန် မိဘလို့ဟ အောင်နီငယ် ယေရှုဟို ဗိမာန်တော်ဟို ခေါ်ခဲ့ကြသောအခါ၊ ");
INSERT INTO dnv_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ရှုမောင်ဟ အောင်နီငယ်ဟို သူရဲ့ လက်မောင်းပေါ်မှာ ချီပင်း ဘုရားသခင်အား ");
INSERT INTO dnv_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“အခု သခင်ဘုရား၊ ကိုယ်တော်ရဲ့ ကတိတော် စကားပြေ့စုံပင်း ဖြစ်ယွေ့ ကိုယ်တော်ရဲ့ ကျွန်ဟ ငြိမ်းချမ်းစွာ သေရသောအခွင့်ဟို ပေးပါ။ ");
INSERT INTO dnv_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ကိုယ်တော်ရဲ့ ကယ်တင်ခြင်းဟို ငါ့မျက်စေ့နဲ့ မျော်ရပါပီ၊ ");
INSERT INTO dnv_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","လူအားလုံးလို့ ဆေ့မှာ ကိုယ်တော် ပြင်ဆင်ထားလဲ့ ");
INSERT INTO dnv_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","လူမျိုးခြားလို့အား ကိုယ်တော်ရဲ့ အလိုတော်ဟို ဖော်ပြသော အလင်းဖြစ်စေရန်နဲ့ ကိုယ်တော်ရဲ့ လူမျိုးဖြစ်သော ဣသရေလဟ ဘုန်းတော်ထွန်းလင်း လာစေရန် ဖြစ်အယ်” ဟု ကျေးဇူးတော်ဟို ချီးမွန်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","အောင်နီငယ်ရဲ့ အဖနဲ့ အမေ့လို့ဟ ရှုမောင် ပြောဆိုသော အကျောန်းဟို ကြားသောအခါ အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ရှုမောင်ဟ သူလို့ဟို ကောင်းချီးပေးပင်း သူ့မေ မာရိအား၊ “ဟေအောင်နီငယ်ဟို ဣသရေလူမျိုးထဲဟ လူလို့ဟို ဖျက်စီးခြင်းနဲ့ ကယ်တင်ခြင်းအတွက် ဘုရားသခင် ရွေးချယ်ထားပီ၊ သူဟ ဘုရားသခင်ရဲ့ နိမိတ်လက္ခဏာ ဖြစ်ပင်း သူ့ဟို ရမ်းဆာ့သော လူများဟ ဆန့်ကျင် ပြောဆိုလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","သူလို့ရဲ့ လျှို့ဝှက်အတွေးများဟို ဖော်ထုတ်စေကြလိမ့်မယ်။ ပင်းနောက် နင့်ရဲ့ စိတ်နေလုံးဟို ထက်သောသန်လျက်ဟ ထိုးဖောက်ခံရသလို ဖြစ်လိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","အဲနေရာနှိုက် အာရှာလူမျိုး၊ ဖနွေလရဲ့ သမီး၊ အန္န နာမယ်ဆိသော မုဆိုးမတယောက် ဖြစ်ပင်း အသက် ရမ်းဆာ့အိုသော ပရောဖက်တဦး ဖြစ်အယ်။ သူမဟ အသက် ခုနေနှစ်အရွယ်မှာ လက်ထပ်ခဲ့ပင်း ");
INSERT INTO dnv_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","မုဆိုးမဖြစ်လျက် အခု အသက် ၈၄ နှစ်အရွယ် ဖြစ်အယ်။ သူမဟ ဆုတောင်းခြင်း၊ အစာဆှောင်ခြင်းအားဖြင့် နေ့ညမပြတ် ဘုရားဝတ်နှိုက် မွေ့လျော်ယွေ့ ဗိမာန်တော်နဲ့ မခွာဘဲ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","အဲချိန်နာရီတည်းမှာ သူရောက်လာပင်းလျှင် ဘုရားသခင်အား ကျေးဇူးတော်ဟို ချီးမွန်းပင်း ယေရုရှလင်မြို့ဟို ရွေးနှုတ်ခြင်းအရာဟို စောင့်မျော်နေကြသော သူအပေါင်းလို့အား အေးအောင်နီငယ် အကျောန်းဟို ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ယောသပ်နဲ့ မာရိလို့ဟ သခင်ဘုရားရဲ့ ပညတ်တရားအတိုင်း အကုန်စင် ပြုပီးသောအခါ ဂါလိလဲပြေ နာဇရက်မြို့လို့ခေါ်လဲ့ မိမိလို့မြို့ဟို ပြန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","အောင်နီငယ်ဟ ကြီးပြင်း သန်စွမ်းလာအယ်၊ ဉာဏ်ပညာ တိုးတက်လာအယ်၊ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်လည်း သူအပေါ်နှိုက် တည်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ယေရှုရဲ့ မိဖလို့ဟ နှစ်စဉ် ပသခါပွဲချိန်နှိုက် ယေရုရှလင်မြို့ဟို သွားလေ့ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ယေရှုဟ အသက် တဆယ့်နေနှစ် ဆိသောအခါ ပသခါပွဲဟို ထုံးစံအတိုင်း သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ပွဲတော်ပီးဆုံးချိန်နှိုက် သူလို့ အိုင်ဟို ပြန်ကြအယ်၊ အဲလိုလဲ အောင်နီငယ် ယေရှုဟ ယေရုရှလင်မြို့မှာ ကျန်ခဲ့အယ်၊ အေးလို့ ကျန်ခဲ့တာဟို မိဖလို့ သိကြမောင့်လဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","သူလို့ဟ အဖွဲ့နဲ့အတူ ဆိအယ်လို့ စိတ်ထင်ကြအယ်၊ တနေ့လုံး ခရီးသွားကြပင်းမှ ဆွေမျိုးအသိအကျွမ်းများထဲမှာ အောင်နီငယ်ဟို စတင်ဆှာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","သူ့ဟို မတွေ့သောအခါ ယေရုရှလင်မြို့ဟို ပြန်သွားပင်း ဆှာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","သူဟ ဗိမာန်တော်နှိုက် ယုဒဆရာများနဲ့အတူ ထိန်ကာ သူလို့အား တရားစကားများဟို နားထောင်ခြင်းနဲ့ မေးခွန်းများ မေးလျက်ဆိတာဟို မိဘလို့ဟ သုံးရက်ကြာပင်းမှ တွေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","သူရဲ့ စကားဟို ကြားကြသော သူအပေါင်းလို့ဟ သူရဲ့ အသိပညာနဲ့ ဖြေကြားချက်ဟို အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","သူ့ရဲ့ မိဖလို့ဟ မျော်လျှင် မိန်းမောတွေဝေယွေ့ အမေဟ “ငါ့ အောင်နီငယ်၊ နင်ဟ ပစာကျောန့် ငါလို့အား ဟေသို့လုပ်လုန်း၊ နင့်ဖနဲ့ ငါဟ နင့်ဟို စိုးရိမ်ကြီးစွာနဲ့ ဆှာခဲ့ပီ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ယေရှုဟ “ပစာကျောန့် ငါ့ဟို ဆာကြလုန်း၊ ငါဟ ခမည်းတော်ရဲ့ အိုင်တွင် ဆိနေရမယ်ဟို သိကြဝူးလော” ဟု ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","အဲလိုလဲ သူလို့ဟ အဲစကားဟို နားမလည်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","အဲပင်း ယေရှုဟ မိဖလို့နဲ့အတူ ပြန်သွားယွေ့ နာဇရက်မြို့ဟို ရောက်သောအခါ သူလို့ စကားဟို နားထောင်ပင်း နေအယ်။ သူ့ရဲ့ မေ့ဟ အေးအဖြစ်အပျက် အကုန်လုံးဟို သူမရဲ့ စိတ်နေလုံးထဲမှာ မှတ်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ယေရှုဟ အစဉ်တိုင်း ကြီးလာယွေ့ ပညာတိုးတက်လျက် ဘုရားသခင်နဲ့ လူလို့ဆေ့တွင် မျက်နှာရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ဧကရာဇ်မင်း တိဗေရိ နန်းစံလဲ့ တဆယ့်ငါးနှစ် ဆိသောအခါ၊ ယုဒပြေတွင် ပုန္တိပိလတ်ဟ ဘုရင်ခံ ဖြစ်အယ်၊ ဂါလိလဲပြေတွင် ဟေရုဒ် အုပ်ချုပ်ပင်း၊ သူ့ရဲ့ အကို ဖိလိပ္ပုဟ ဣတုရဲပြေနဲ့ တရာခေါနိတ်ပြေလို့ရဲ့ နယ်မြေများဟို အုပ်ချုပ်အယ်၊ လုသာနိဟ အဘိလင်ပြေဟို အုပ်ချုပ်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","အန္နနဲ့ ကယာဖလို့ဟ ယဇ်ပုရောဟိတ်မင်းများ ဖြစ်ကြအယ်။ အေးအချိန်အခါနှိုက် တောကန္တာရထဲမှာဆိလဲ့ ဇာခရိရဲ့သား ယောဟန်ဆေဟို ဘုရားသခင်ရဲ့ စကား ရောက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","အဲလိုမို့ ယောဟန်ဟ ယော်ဒန်မြစ်ပိုင်နက် တဆှောက်လုံးဟို သွားယွေ့ “နင်လို့ အပစ်များဟို နောင်တရကြပင်း၊ ယေနှစ်ခြင်းဟို ခံယူကြလော့။ အေးလို့မှသာ ဘုရားသခင်ဟ နင်လို့ အပစ်များဟို ဖြေလွှတ်မယ်” ဟု ဟောပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ပရောဖက် ဟေရှာယ ရေးသားလဲ့အတိုင်း၊ “တောကန္တာရမှာ တယောက်ယောက်ဟ အော်နေတာဟ၊ ‘သခင်အတွက် လမ်းဟို အသင့် ပြင်ဆင်ကြလော့။ သူ့ရဲ့ လမ်းခရီးဟို ဖြောင့်စေကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ချိုင့်ဝှမ်းတိုင်းဟို ဖြေ့စေပင်း၊ တောင်ကြီး တောင်ငယ်အားလုံးဟို ဖြိုချရမယ်။ အကွေ့အကောက်များလဲ့ လမ်းများဟို ဖြောင့်အောန် လုပ်ပင်း၊ လမ်းကြမ်းများဟို ချောအောန် လုပ်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","လူသားမျိုးနွယ်အားလုံး ဘုရားသခင်ရဲ့ ကယ်တင်ခြင်းဟို မျော်ရလိမ့်မယ်’ ဟု ဖြစ်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","နှစ်ခြင်းခံဖို့ လူများလို့ဟ ယောဟန်ဆေဟို လာကြအယ်။ “အချင်း မြွေပွေးအမျိုးလို့၊ ဘုရားသခင် စီရင်သော ဘေးဒဏ်ကနေ နင် လွတ်မြောက်လိမ့်မယ်လို့ စသူဟောလုန်းဟု သူလို့ဟို ဟောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","နောင်တနဲ့ ထိုက်တန်သော အသီးဟို သီးကြလော့။ အာဗြဟံဟ ငါလို့ရဲ့အဖ ဖြစ်အယ်လို့ နင်လို့တတ်တိုင်း မပြောဆိုကြနဲ့။ နင်လို့ဟို ငါပြောတာဟ ဘုရားသခင်သည် အာဗြဟံရဲ့ လူပဲ့သငယ်များဟို ဟေကျောက်ခဲလို့ထဲမှ ပေါ်ထွန်းစေနိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","သစ်ပင် အမြစ်နားနှိုက် ပေါက်ဆိန် ချထားတာ ဖြစ်ယွေ့၊ ကောင်းသော အသီးဟို မသီးသော အပင်ဆိသမျှလို့ဟို ခုတ်ပစ်ပင်း မီးထဲဟို လောချခြင်း ခံရလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","လူအပေါင်းလို့ဟ “အဲလို့ဖြစ်ရင် ငါလို့ဟ စလို ပြုရမလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","သူဟ “ရှပ်အင်္ကျီ နေထည်ဆိသောသူဟ မဆိသောသူဟို ငရမယ်၊ စားစရာဆိသောသူဟလည်း အေးတိုင်းတိုင်း ငရမယ်” လို့ ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","အခွန်ခံတချို့လို့ဟ နှစ်ခြင်း ခံဖို့လာကြယွေ့ သူလို့ဟ “ဆရာ၊ ငါလို့ဟ စလို လုပ်ရမလုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","သူဟ “နင်လို့ဟ ဥပဒေဟ သက်မှတ်ထားတာထက် ပိုပင်း အခွန် မကောက်ခံကြနဲ့” ဟု သူလို့အား ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","အချို့ စစ်သားများဟလည်း “ငါလို့ဟ စလိုလုပ်ရမလုန်း” ဟု မေးဆှောက်ကြအယ်။ သူဟ “စသူဆေမှ အတင်းအကျပ် ပိတ်ဆန် မယူကြနဲ့၊ စသူ့ဟိုမှ ကစတ်ကလတ် မစွပ်စွဲကြနဲ့။ နင်လို့ရလဲ့ လခနဲ့ ရောင့်ရဲပင်း နေကြလော့” ဟု သူလို့အား ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","လူတွေရဲ့ မျော်လင့်ချက်တွေ မြင့်မားနေချိန် ယောဟန်ဟ မေဆှိယ ဖြစ်နိန်မလောဟု သူလို့ စိတ်နေလုံးထဲဟ စတင် တွေးတောလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ယောဟန်ဟ သူလို့အားလုံးဟို ပြန်ပြောတာဟ “ငါဟ နင်လို့အား ယေနဲ့ နှစ်ခြင်းဟို ပေးအယ် အဲလိုလဲ ငါ့ထက်ကြီးမြတ်သူဟ ငါနောက်မှ လာမယ်။ ငါဟ အေးသူရဲ့ ဖိနပ်ကြိုးဟိုမှ မဖြေထိုက်။ သူဟ နင်လို့အား သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ မီးနဲ့ နှစ်ခြင်းဟို ပေးမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","မိမိရဲ့ ကောက်နယ်တလင်းဟို ဆှင်းလင်းရန် လက်တော်တွင် ဆန်ကောဟို ကိုင်ထားတာဖြစ်ယွေ့၊ ဂျုံစပါးဟိုဟ ကျီနှိုက် စုသိမ်းယွေ့ အဖျင်းများဟိုဟ မငြိမ်းနိန်သော မီးထဲမာ ရှို့လိမ့်မယ်” ဟု သူလို့အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","နည်းအမျိုးမျိုးနဲ့ ယောဟန်ဟ လူလို့အား သတင်းကောင်း ဟောပြောခဲ့ပင်း၊ သူလို့ရဲ့ လမ်းစဉ်ဟို ပြောင်းလဲရန် တိုက်တွန်းခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","အဲလိုလဲ ဟေရုဒ်ဟ မိမိအကိုရဲ့ ပေါင်အိုမ ဟေရောဒိဟို လက်ထပ်ယူခြင်းနဲ့ ပတ်သက်ယွေ့ မိမိလုပ်ခဲ့သော မကောင်းမှုအလုံးစုံနဲ့ ပတ်သက်ပင်း ယောဟန်ဟ သူ့ဟို တိုက်တွန်းဆုံးမခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","အေးနောက် ဟေရုဒ်ဟ ယောဟန်ဟို ထောင်ချခြင်းအားဖြင့် ပိုယွေ့ ဆိုးသောအမှုဟို ပြုခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","လူအပေါင်းလို့ နှစ်ခြင်းဟို ခံယူပင်းသောအခါ ယေရှုဟလည်း နှစ်ခြင်း ခံယူအယ်။ ယေရှုဟ ဆုတောင်းနေစဉ်တွင် ခေါန်းခင် ပွင့်လာယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ ချိုးတူးမပုံစံဖြင့် ယေရှု အပေါ်ဟို ဆင်းသက်အယ်။ မိုးခေါန်းခင်မှ “နင်ဟ ငါရဲ့ ချစ်သား ဖြစ်အယ်၊ နင်ဟ ငါနှစ်သက် မြတ်နိုးရာ ဖြစ်အယ်” ဟု အသံပေါ်ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ယေရှု အမှုတော်ဟို စတင် ဆောင်ရွက်သောအခါ၊ သူဟ အသက်သုံးဆယ်ခန့် ဆိအယ်။ လူလို့ ထင်မြင်ယူဆချက်အရ ကိုယ်တော်ဟ ယောသပ်ရဲ့ သား ဖြစ်အယ်၊ ယောသပ်ဟ ဧလိရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ဧလိဟ မဿတ်ရဲ့ သား၊ မဿတ်ဟ လေဝိရဲ့ သား၊ လေဝိဟ မေလခိရဲ့ သား မေလခိဟ ယန္နရဲ့ သား၊ ယန္နဟ ယောသပ်ရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ယောသပ်ဟ မတ္တသိရဲ့ သား၊ မတ္တသိရဲ့ သားဟ အာမုတ်၊ အာမုတ်ဟ နာဟုံရဲ့ သား၊ နာဟုံဟ ဧသလိရဲ့ သား၊ ဧသလိဟ နဂ္ဂဲရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","နဂ္ဂဲဟ မာအတ်ရဲ့ သား၊ မာအတ်ဟ မတ္တိသိရဲ့ သား၊ မတ္တိသိဟ ရှေမိရဲ့ သား၊ ရှေမိဟ ယောသပ်ရဲ့ သား၊ ယောသပ်ဟ ယုဒရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ယုဒဟ ယောဟန္နရဲ့ သား၊ ယောဟန္နဟ ရေသရဲ့ သား၊ ရေသဟ ဇေရုဗဗေလရဲ့ သား၊ ဇေရုဗဗေလဟ ရှာလသေလရဲ့ သား၊ ရှာလသေလဟ နေရိရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","နေရိဟ မေလခိရဲ့ သား၊ မေလခိဟ အဒ္ဒိရဲ့ သား၊ အဒ္ဒိဟ ကောသံရဲ့ သား၊ ကောသံဟ ဧလမောဒံရဲ့ သား၊ ဧလမောဒံဟ ဧရရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ဧရဟ ယောရှုရဲ့ သား၊ ယောရှုဟ ဧလျေဇာရဲ့ သား၊ ဧလျေဇာဟ ယောရိမ်ရဲ့ သား၊ ယောရိမ်ဟ မဿတ်ရဲ့ သား၊ မဿတ်ဟ လေဝိရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","လေဝိဟ ရှိမောင်ရဲ့ သား၊ ရှိမောင်ဟ ယုဒရဲ့ သား၊ ယုဒဟ ယောသပ်ရဲ့ သား၊ ယောသပ်ဟ ယောနန်ရဲ့ သား၊ ယောနန်ဟ ဧလျာကိမ်ရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ဧလျာကိမ်ဟ မေလရဲ့ သား၊ မေလဟ မဲနန်ရဲ့ သား၊ မဲနန်ဟ မတ္တသရဲ့ သား၊ မတ္တသဟ နာသန်ရဲ့ သား၊ နာသန်ဟ ဒါဝိဒ်ရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ဒါဝိဒ်ဟ ယေရှဲရဲ့ သား၊ ယေရှဲဟ ဩဗက်ရဲ့ သား၊ ဩဗက်ဟ ဗောဇရဲ့ သား၊ ဗောဇဟ စာလမုန်ရဲ့ သား၊ စာလမုန်ဟ နာရှုန်ရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","နာရှုန်ဟ အမိနဒပ်ရဲ့ သား၊ အမိနဒပ်ဟ အာရံရဲ့ သား၊ အာရံဟ ဟေဇရုံရဲ့ သား၊ ဟေဇရုံဟ ဖာရက်ရဲ့ သား၊ ဖာရက်ဟ ယုဒရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ယုဒဟ ယာကုပ်ရဲ့ သား၊ ယာကုပ်ဟ ဣဇက်ရဲ့ သား၊ ဣဇက်ဟ အာဗြဟံရဲ့ သား၊ အာဗြဟံဟ တေရရဲ့ သား၊ တေရဟ နာခေါ်ရဲ့ သား ");
INSERT INTO dnv_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","နာခေါ်ဟ စေရောက်ရဲ့ သား၊ စေရောက်ဟ ရာဂေါရဲ့ သား၊ ရာဂေါဟ ဖာလက်ရဲ့ သား၊ ဖာလက်ဟ ဟေဗာရဲ့ သား၊ ဟေဗာဟ ရှာလရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ရှာလဟ ကာဣနန်ရဲ့ သား၊ ကာဣနန်ဟ အာဖာဇဒ်ရဲ့ သား၊ အာဖာဇဒ်ဟ ရှေမရဲ့ သား၊ ရှေမဟ နောဧရဲ့ သား၊ နောဧဟ လာမက်ရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","လာမက်ဟ မသုရှေလရဲ့ သား၊ မသုရှေလဟ ဧနောက်ရဲ့ သား၊ ဧနောက်ဟ ယာရက်ရဲ့ သား၊ ယာရက်ဟ မဟာလေလရဲ့ သား၊ မဟာလေလဟ ကာဣနန်ရဲ့ သား၊ ");
INSERT INTO dnv_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ကာဣနန်ဟ ဧနုတ်ရဲ့ သား၊ ဧနုတ်ဟ ရှေသရဲ့ သား၊ ရှေသဟ အာဒံရဲ့ သား၊ အာဒံဟ ဘုရားသခင်ရဲ့ သား ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ယေရှုဟ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝပင်း ယော်ဒန်မြစ်မှ ပြန်လာစဉ် ဝိညာဉ်တော်ဟ ယေရှုအား တောကန္တာရထဲဟို ပို့ဆောင်ခံရယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","အဲမှာ ရက်ပေါင်း လေးဆယ်လုံးလုံး မာရ်နတ်ရဲ့ စုံစမ်းသွေးဆောင်ခြင်းဟို ခံအယ်။ အေးနေ့ရက် အချိန်အတွင်း ပစာအစာဟိုမှ စားတော်မမူ၊ အေးကာလ လွန်သောအခါ ယေရှုဟ မွတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","မာရ်နတ်ဟ “နင်သည် ဘုရားသခင်ရဲ့ သားတော် ဖြစ်ရင်၊ ဟေကျောက်ခဲဟို မုန့်အဖြစ် ပြောင်းဖို့ အမိန့်ပေးမန့်” ဟု ကိုယ်တော်ဟို ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","အဲလိုလဲ ယေရှုဟလည်း “ကျမ်းစာပြောတာဟ ‘လူသားတွေဟ မုန့်အားဖြင့် အသက်ဆှင်ရမယ် မဟုတ်’ ” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","အေးနောက် မာရ်နတ်ဟ ကိုယ်တော်ဟို ခေါ်သွားပင်း ခုတင်ချင်း လောကနှိုက် ဆိသမျှသော တိုင်းနိုင်ငံများဟို ပြသခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“ငါဟ ဟေတန်ခိုးအားလုံးနဲ့ ချမ်းသာကြွယ်ဝမှုအားလုံးဟို နင့်ဟို ပေးမယ်၊ ဆိသမျှလို့ဟ ငါ့လက်ဟို အပ်နှင်းထားပင်း ဖြစ်ယွေ့ ငါအလိုဆိလဲ့ စသူမဆို ငါပေးနိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ငါ့ဟို ကိုးကွယ်ရင် ဟေအရာအားလုံးလို့ဟ ကိုယ်တော်ရဲ့ ဥစ္စာ ဖြစ်လိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ယေရှုဟလည်း “ကျမ်းစာပြောတာဟ ‘နင်ရဲ့ အဆှင် ဘုရားသခင်ဟိုသာ ကိုးကွယ်ရမယ်’ ” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","အဲပင်းရင် မာရ်နတ်ဟ ယေရှုအား ယေရုရှလင်မြို့ဟို ခေါ်သွားယွေ့ ဗိမာန်တော်ရဲ့ ထိပ်ဖျားနှိုက် တင်ထားပင်း “နင်ဟ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ရင်၊ ဟေနေရာမှ အောက်ဟို ကိုယ့်တတ်တိုင်း ခုန်ချပါလော့ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ကျမ်းစာပြောတာဟ ‘ဘုရားသခင်ဟ နင့်ဟို စောင့်ဆှောက်ဖို့ ခေါန်းခင်တမန်များဟို အမိန့်ပေးမယ်’ ");
INSERT INTO dnv_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘နင်ရဲ့ ခြေထောက်များဟို ကျောက်နဲ့ မထိခိုက်စေရန် သူလို့ဟ နင့်ဟို သူလို့ လက်နဲ့ ချီပင့်ကြလိမ့်မယ်’ ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ယေရှုဟလည်း “ကျမ်းစာပြောတာဟ ‘နင့်ရဲ့ ဘုရားသခင် အဆှင်ဟို အစုံစမ်း မပြုရ’ ” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","မာရ်နတ်ဟ ယေရှုဟို နည်းအမျိုးစုံနဲ့ စုံစမ်းသွေးဆောင် ပင်းသောအခါ၊ သူ့ဆေမှ ထွက်သွားယွေ့ အခွင့်ကောင်းရလဲ့အထိ စောင့်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ယေရှုဟ ဝိညာဉ်တော် တန်ခိုးနဲ့ ပြေ့ဝလျက် ဂါလိလဲပြေဟို ပြန်လာအယ်၊ သူနဲ့ ပတ်သက်လဲ့ သတင်းဟ အေးနယ်မြေတခုလုံး ပျံ့နှံ့သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ကိုယ်တော်ဟ တရားဇရပ်များမှာ သွန်သင်ရာ လူအားလုံးလို့ဟ ကိုယ်တော်ဟို ချီးမွန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ယေရှုဟ သူကြီးပြင်းခဲ့သော နာဇရက်မြို့မှ ပြန်သွားပင်း၊ ဥပုသ်နေ့နှိုက် ကိုယ်တော်ဟ အလေ့ဆိလဲ့အတိုင်း တရားဇရပ်ဟို ဝင်အယ်။ ကိုယ်တော်ဟ ကျမ်းစာဖတ်ဖို့ ထအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ဇရပ်စောင့်ဟ ပရောဖက် ဟေရှာယရဲ့ ကျမ်းပအုပ်ဟို ကမ်းယွေ့ ပေးအယ်။ ကျမ်းစာလိပ်ဟို ဖွင့်ပင်း ရေးသားထားလဲ့ နေရာဟိုတွေ့ရင်၊ ");
INSERT INTO dnv_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“သခင်ဘုရားရဲ့ ဝိညာဉ်တော်ဟ ငါ့အပေါ်မှာ တည်အယ်။ ဆင်းရဲသောသူလို့အား သတင်းကောင်းဟို ဟောကြားစေရန် ငါဟို ခန့်ထားပီ။ ဖမ်းဆီးချုပ်ထားလျက် ဆိသော သူလို့အား လွတ်မြောက်စေရန်၊ မျက်စေ့ကန်းသူများ မျက်စေ့အလင်း ပြန်လည်ရဆိစေရန်၊ နှိပ်စက်ခံရသူများအား လွတ်မြောက်စေရန်၊ ");
INSERT INTO dnv_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","သခင်ဘုရားဟ မိမိလူစုဟို ကယ်တင်မယ်အချိန်ရောက်လာပီ ဖြစ်ကျောန်း၊ ကြေညာရန် ငါ့ဟို စေလွှတ်ပီ” ဟု ကျမ်းပိုဒ်ဟို ဖတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","အေးနောက် ယေရှုဟ ကျမ်းစာလိပ်ဟို ပြန်လိပ်ပင်း ဇရပ်စောင့်အား ပြန်ပေးပင်းမှ ထိန်အယ်။ တရားဇရပ်နှိုက် ဆိသော လူအားလုံးဟ ကိုယ်တော်ဟို စိုက်ကျေ့ နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ယေရှုဟ “ဟေဖတ်ခဲ့တာဟို ကြားခဲ့လဲ့အတိုင်း ခုနေ့ပင် ဟေကျမ်းစာချက်ဟ အမန်တကယ် ပြေ့စုံလာပီ” ဟု သူလို့အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","သူလို့အားလုံးဟ ကိုယ်တော်ဟို ချီးကျူးကြပင်း သူ့နှုတ်ထွက်စကားလို့ဟို အံ့ဩလျက် “ဟေသူဟ ယောသပ်ရဲ့ သား မဟုတ်လော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ယေရှုဟလည်း “နင်လို့ဟ ဟေပုံဥပမာဟို ကိုးကားလျက် ‘ဆရာဝန်၊ ကိုယ့်အနာဟို ပျောက်ကင်းစေလော့’ ဟု ငါ့ဟို ပြောဆိုလိမ့်မယ်။ ကပေနောင်မြို့မှာ လုပ်ခဲ့ဟာဟို နင်လို့ ကြားလဲ့အတိုင်း ကိုယ့်ဇာတိမြို့တွင်လည်း ပြုပါဟု ငါ့ဟို ပြောဆိုကြလိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ယေရှုဟ ငါ အမန်ပြောတာဟ “ပရောဖက်လို့သည် သူလို့ရဲ့ ဇာတိမြို့တွင် ပစာအခါမှ ကြိုဆိုခြင်း မခံရဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ငါ ပြောလဲ့စကားဟို နားထောင်ပါ ဧလိယ လက်ထက်နှိုက် ဣသရေလနိုင်ငံတွင် သုံးနှစ်နဲ့ ခြောက်လပတ်လုံး မိုးမရွာသောအခါ မြေတပြင်လုံးတွင် ပြင်းထန်သော အစာငတ်မွတ် ခေါင်းပါးခြင်း ဖြစ်ပွားခဲ့သောကျောန့် မုဆိုးမများ ရမ်းဆာ့များခဲ့အယ်ဆိုတာ မန်သောစကား ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","အဲလိုလဲ ဣသရေပြေဆိ မုဆိုးမလို့ထဲမှ စသူ့ဆေဟိုမျှ ဧလိယဟို မစေလွှတ်ဘဲ ဇိဒုန်ပြေ ဇရတ္တမြို့နှိုက်နေသော မုဆိုးမ တယောက်ဆေဟို စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ပရောဖက် ဧလိရှဲ လက်ထက်အချိန် အတောအတွင်းလည်း ဣသရေလပြေတွင် နေထိန်ကြသော လူများလို့ဟ ရမ်းဆာ့ ကြောက်ဖို့ကောင်းလဲ့ အရေပြားရောဂါကျောန့် ဒုက္ခဆင်းရဲခံရကြအယ်၊ ပစာကို့ နေမန် နာမယ်ဆိသော ရှုရိလူမှတပါး စသူမှ သန့်ဆှင်းခြင်းဟို မရောက်ရ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","တရားဇရပ်မှာဆိသော လူများလို့ဟ အေးစကားဟို ကြားသောအခါ ရမ်းဆာ့ အူထော့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","သူလို့ဟ ထပင်း ယေရှုဟို မြို့ပြင်ဟို ဆွဲထုတ်ပင်းရင်၊ သူလို့မြို့မှာ တည်ဆောက်ထားသော တောင်ထိပ်ဟို ခေါ်သွားကြပင်း သူ့ဟို ချောက်ထဲဟို လောချရန် ခေါ်ဆောင်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","အဲလိုလဲ ယေရှုဟ လူအုပ်အလယ်မှ ဖြတ်ဆှောက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ယေရှုဟ ဂါလိလဲပြေ ကပေရနောင်မြို့ဟို သွားအယ်၊ ဥပုသ်နေ့နှိုက် ကိုယ်တော်ဟ လူလို့အား သင်ပေးခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ကိုယ်တော်ရဲ့ စကားဟ အခွင့်အာဏာ ဆိသောကျောန့် လူလို့ဟ ကိုယ်တော်ရဲ့ သွန်သင်ချက်ဟို အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","တရားဇရပ်နှိုက် ညစ်ညူးသောနတ်ပူးသူ လူတယောက် ဆိပင်း၊ သူဟ ရမ်းဆာ့ အသံကျယ်နဲ့ အော်ကယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“အို နာဇရက်မြို့သား ယေရှု၊ ငါလို့ဆေဟ ပစာလိုချင်လို့လုန်း၊ ငါလို့ဟို ဖျက်ဆီးမို့ လာသလော၊ ကိုယ်တော်ဟ စသူဆိုဟာ ငါသိအယ်၊ ကိုယ်တော်ဟ ဘုရားသခင်ရဲ့ သန့်ဆှင်းလဲ့ သတင်းစကား သယ်ဆောင်လာသူ ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ယေရှုဟ “တိတ်တိတ်နေလော့၊ အေးသူရဲ့ အထဲဟ ထွက်သွားလော့” ဟု နတ်ဆိုးဟို အမိန့်ပေးအယ်။ နတ်ဆိုးဟ အဲသူဟို လူများဆေ့မှာ လဲချပင်း အန္တရာယ်တခုမှ မလုပ်ပဲ သူ့ဆေဟနေ ထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","လူအားလုံးလို့ဟ အံ့ဩကြပင်း “အေးသူရဲ့ စကားဟ စလိုလုန်း၊ သူဟ ညစ်ညူးသောနတ်များဟို ထွက်သွားရန် တန်ခိုးအာဏာဖြင့် အမိန့်ပေးယွေ့ သူလို့ဟ ထွက်သွားကြအယ်” ဟု တယောက်နဲ့ တယောက် ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ယေရှုရဲ့ သတင်းတော်ဟ ပတ်ဝန်းကျင်အရပ်လို့နှိုက် ပျံ့နှံ့သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ယေရှုဟ တရားဇရပ်မှ ထွက်သွားပင်းနောက် ရှိမုန်ရဲ့ နေအိုင်ဟို သွားအယ်။ သူလို့ဟ ရှိမုန်ရဲ့ ယောက္ခမ ရမ်းဆာ့ ဖျားနေကျောန်းဟို ယေရှုအား ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ကိုယ်တော်ဟ အေးမိန်းမရဲ့ နဘေးမှာ ရပ်ပင်း အဖျားပျောက်စေရန် အမိန့်ပေးအယ်၊ သူဟ ခုတုံးပင် အဖျားပျောက်ယွေ့ ထပင်း သူလို့အား စတင် လုပ်ကျွေးပြုစုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ညခင်းချိန်နှိုက် အမျိုးမျိုး အနာရောဂါစွဲသော သူလို့ရဲ့ မိတ်ဆွေများဟ အေးလူနာလို့ကို ယေရှု ဆေဟို ခေါ်ခဲ့ကြအယ်၊ ကိုယ်တော်ဟ လူနာအသီးသီးလို့ အပေါ်မှာ သူ့လက်ဟို တင်ယွေ့ သူလို့ရဲ့ ရောဂါများဟို ပျောက်ကင်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","နတ်ဆိုးလို့ဟ လူများဆေမှ “ကိုယ်တော်ဟ ဘုရားသခင်ရဲ့ သားတော် ဖြစ်အယ်” လို့ အော်ပင်း ထွက်သွားကြအယ်။ ယေရှုဟ နတ်ဆိုးများဟို စကားတခွန်းမှ မပြောစေခြင်းငှာ အမိန့်ပေးအယ်၊ သူလို့ဟ ကိုယ်တော်သည် မေဆှိယ ဖြစ်ကျောန်းဟို သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","မိုးလင်းသောအခါ ယေရှုဟ မြို့ထဲမှာ ထွက်သွားပင်းနောက် တိတ်ဆိတ်သောနေရာဟို သွားအယ်။ လူလို့ဟ ကိုယ်တော်ဟို စတင် ဆာကြအယ်၊ သူလို့ဟ ကိုယ်တော်ဟို ဆာယွေ့ တွေ့သောအခါ မိမိလို့ဆေမှ မထွက်သွားစေရန် ကြိုးစားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","အဲလိုလဲ ယေရှုဟ “ငါဟ တခြားမြို့များတွင် ဘုရားသခင်ရဲ့ နိုင်ငံတော်အကျောန်း သတင်းကောင်းဟို ဟောရမယ်၊ ပစာကို့ အေးလို့လုပ်ရန် ဘုရားသခင်ဟ ငါ့ဟို စေလွှတ်အယ်” လို့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","အေးကျောန့် ကိုယ်တော်ဟ ယုဒပြေတလွှားဆိ တရားဇရပ်များနှိုက် တရားဟောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","တနေ့တွင် ယေရှုဟ ဂင်နေသရက် အိန်နားမှာ ရပ်နေစဉ် လူများဟ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တော်ဟို နားထောင်ရန် ကိုယ်တော်ရဲ့ အနီးဟို တိုးလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","သူဟ ကမ်းခြေနားမှာ ဆိုက်ထားသော လှေနေစီးဟို မျော်အယ်၊ တံငါသည်လို့ဟ လှေပေါ်မှာ ထားခဲ့ပင်း မိမိလို့ရဲ့ ပိုက်ကွန်များဟို ဆေးနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ယေရှုဟ ရှိမုန် ပိုင်ဆိုင်သော လှေဆေဟို သွားပင်း၊ ကမ်းမှ နည်းနည်းခွာဖို့ ပြောအယ်၊ အေးနောက် ကိုယ်တော်ဟ လှေပေါ်မှာ ထိန်ပင်း လူအုပ်လို့အား သွန်သင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","စကားပြောပင်းသောအခါ “လှေဟို ယေနက်ရာဟို ရွေ့အုံးမန့်၊ ငါးမိစေဖို့ နင်နဲ့ နင်ရဲ့ လုပ်ဖော်ကိုင်ဖက်လို့ရဲ့ ပိုက်ကွန်ဟို ချလော့” ဟု ရှိမုန်အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ရှိမုန်ဟ “သခင်၊ ငါလို့ဟ တညလုံး ကြိုးစားပင်း ဖမ်းခဲ့ပေမဲ့ တကောင်မှ မရမန့်၊ အဲလိုလဲ ကိုယ်တော် ပြောသောကျောန့် ငါ ပိုက်ကွန်ဟို ချမန့်မယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","သူလို့ဟ လောချယွေ့ ရမ်းဆာ့သော ငါးလို့ဟို အုပ်မိသဖြင့် ပိုက်ကွန်ဟ ပြဲခါနီး ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","အခြား လှေတစင်းမှာ ဆိသော သူလုပ်ဖော်ကိုင်ဖက်လို့ဟို လာကူညီပေးဖို့ သူလို့ဟို အချက်ပြလေအယ်။ အေးသူလို့ဟ လာယွေ့ လှေနေစင်းလုံး ငါးနဲ့ ပြေ့သဖြင့် နစ်ခါနီးနီး ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ရှိမုန် ပေတရုဟ ဖြစ်ပျက်ခဲ့လဲ့အရာဟို မျော်သောအခါ ယေရှု ဆေ့မှာ ဒူးထောက်ပျပ်ဝပ်လျက် “သခင်၊ ငါဟ အပစ်သား ဖြစ်အယ်၊ ငါဆေမှ ထွက်သွားမန့်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","သူနဲ့ တခြားသူများအားလုံး သူလို့ ဖမ်းမိလိုက်သော ရမ်းဆာ့များသော ငါးလို့ဟို ကျေ့ပင်း အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ရှိမုန်ရဲ့ လုပ်ဖော်ကိုင်ဖက်ဖြစ်သော ဇေဗေဒဲရဲ့ သား ယာကုပ်နဲ့ ယောဟန်လို့လည်း အဲတိုင်းတိုင်း အံ့ဩကြအယ်။ ယေရှုဟ “မကြောက်ကြနဲ့၊ အခုမှစပင်း နင်လို့ဟ လူဟို ဖမ်းမိသောသူ ဖြစ်လိမ့်မယ်” ဟု ရှိမုန်အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","သူလို့ဟ လှေဟို ကမ်းပေါ် ဆွဲတင်ပင်း ဆိသမျှအားလုံးဟို ထားပင်း ယေရှု နောက်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","တခါ ယေရှုဟ မြို့ထဲတွင် ဆိပင်း အေးမြို့တွင် အရေပြားရောဂါဝေဒနာ ခံစားနေရသော လူတယောက် ဆိအယ်။ သူဟ ယေရှုဟို မျော်သောအခါ သူ့ကိုယ်သူ လဲချပင်း အသနားခံလျက် “ဆရာ၊ ကိုယ်တော် အလိုဆိရင် ငါ့အား သန့်ဆှင်းစေနိန်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ယေရှုဟ သူ့လက်တော်ဟို ဆန့်ပင်း အေးသူဟို တို့အယ် “ငါ အလိုဆိအယ်၊ သန့်ဆှင်းစေ” ဟု ပြောအယ်။ ခုတုံးပင် သူဟ နူနာရောဂါ ပျောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ယေရှုဟ “စသူ့ဟိုမှ မပြောနဲ့၊ အဲလိုလဲ ယဇ်ပုရောဟိတ်ဆေဟို သွားယွေ့ ကိုယ့်တတ်တိုင်း ပြလော့၊ သူလို့ဆေမှာ သက်သေဖြစ်စေရန် နင်ရဲ့ စင်ကြယ်ခြင်းအတွက် မောရှေ မိန့်မှာထားလဲ့အတိုင်း ပူဇော်သကာဟို ပူဇော်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","အဲလိုလဲ ယေရှုနဲ့ ပတ်သက်လဲ့ သတင်းများဟ ပိုပင်း ကျယ်ပြန့် ပျံ့နှံ့သွားပင်း လူများလို့ဟလည်း ယေရှုရဲ့ တရားဟို ကြားနာရန်နဲ့ မိမိလို့ရဲ့ အနာရောဂါများ ပျောက်ကင်းစေရန် လာကြကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","အဲလိုလဲ ယေရှုဟ လူသူကင်းဝေးရာ နေရာဟို သွားပင်း ဆုတောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","တနေ့မှာ ယေရှုဟ သွန်သင်နေစဉ် ယေရုရှလင်မြို့မှ စပင်း ယုဒပြေ၊ ဂါလိလဲပြေ မြို့များမှ လာကြသော ဖာရိရှဲလို့နဲ့ ကျမ်းတတ်ဆရာများဟ ထိန်နေကြအယ်။ အနာရောဂါများ ပျောက်ကင်းစေဖို့ ဘုရားသခင်ရဲ့ တန်ခိုးတော်ဟ ယေရှုနဲ့အတူ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","လူအချို့လို့ဟ လေဖြတ်နေသောသူ တယောက်ဟို အိပ်ယာထမ်းစင်နဲ့ သယ်ဆောင်လာပင်း သူ့ဟို နေအိုင်ထဲဟို သယ်ပင်း ယေရှုဆေ့တွင် ချထားရန် ကြိုးစားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","လူများသောကျောန့် အထဲဟို ဝင်စရာ နည်းလမ်း မတွေ့သဖြင့်၊ အိုင်မိုးပေါ်ဟို သယ်ခဲ့ပင်း အုတ်ကြွပ်ပြားဟို ဖွင့်ယွေ့ လူနာဟို အိပ်ယာနဲ့အတူ လူလို့အလယ် ယေရှုဆေ့ဟို လျှောချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ယေရှုဟ အေးသူလို့ရဲ့ ယုံကြည်ခြင်း စလောက်ဆိအယ်ဟို မျော်သောအခါ အေးလူဟို “မိတ်ဆွေ၊ နင်ရဲ့ အပစ်ဟို ငါ ခွင့်လွှတ်ပီ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ကျမ်းတတ်ဆရာများနဲ့ ဖာရိရှဲများဟ “ဘုရားဟို ပစ်မားပြောဆိုသော ဟေသူဟ စသူလုန်း၊ အပစ်များမှ ခွင့်လွှတ်နိန်သူဟာ ဘုရားသခင် တဦးတည်းသာ ဖြစ်အယ်” ဟု သူလို့တတ်တိုင်း ဟောနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ယေရှုဟ သူလို့ စိတ်ထဲမှ အတွေးဟို သိရင် “ပစာကျောန့် နင်လို့ ဟေအရာများဟို တွေးနေကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘နင့်ရဲ့ အပစ်ဟို လွှတ်စေပီ’ လို့ပြောရဟာ ပိုပင်း လွယ်ကူသလော အဲဟာမဟုတ်ရင် ‘ထပင်း လှမ်းသွားမန့်’ လို့ ပြောရဟာ ပိုပင်း လွယ်သလော။ ");
INSERT INTO dnv_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","လူသားဟ မြေကြီးပေါ်မှာ အပစ်လွှတ်ပိုင်လဲ့ အာဏာဆိတာဟို နင်လို့ဟို သက်သေပြမယ်” ဟု သူလို့အား ပြောပင်း၊ ယေရှုဟ “ထလော့၊ နင့်အိပ်ယာဟို သိမ်းပင်း အိုင်ဟို ပြန်လော့” ဟု လေဖြတ်နေသောသူဟို မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","သူဟ လူလို့ဆေ့မှာ ခုတုံး ထပင်း အိပ်ယာဟို ယူယွေ့၊ ဘုရားသခင်ဟို ချီးမွန်းပင်း အိုင်ဟို ပြန်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","သူလို့ဟ ရမ်းဆာ့အံ့ဩ ကြောက်လန့်မှုနဲ့ ပြေ့ပင်း ဘုရားသခင်ဟို ချီးမွန်းလျက် “အံ့ဩဖွယ် အမှုအရာလို့ဟို ငါလို့ ခုနေ့ မျော်ရလေပီ” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","အေးနောက် ယေရှုဟ ထွက်သွားပင်း အကောက်ခွန်ရုံးတွင် လေဝိ နာမယ်ဆိသော အခွန်ခံသူ ထိန်နေဟာဟို မျော်အယ်။ ယေရှုဟ “ငါ့နောက်ဟို လိုက်မန့်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","လေဝိဟ ဆိသမျှဟို စွန့်ပင်း ထယွေ့ ယေရှု နောက်လိုက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","အဲပင်းရင် လေဝိဟ ယေရှုဖို့ နေအိုင်နှိုက် ဧည့်ခံပွဲကြီးဟို ကျင်းပအယ်။ အခွန်ခံသူ လူအစုဝေးနဲ့ အခြားသောသူ များစွာလို့ဟ သူလို့နဲ့အတူ ထိန်ယွေ့ စားသောက်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ဖာရိရှဲလို့နဲ့ သူလို့ရဲ့ အုပ်စုဝင် ဖြစ်လဲ့ ကျမ်းတတ်ဆရာလို့ဟ “ပစာကျောန့် နင်လို့ဟ အခွန်ခံများနဲ့ တခြား ဆိုးသွမ်းသောသူများနဲ့အတူ စားသောက်ကြသလော” ဟု ယေရှုရဲ့ တဘဲ့တော်လို့ဟို ကဲ့ရဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ယေရှုဟ “ကျန်းမာသောသူလို့ဟ ဆရာဝန် လိုအပ်ဝူး၊ နေမကောင်းသူပဲ လိုအပ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ငါဟ နောင်တရပင်း ဂုဏ်အသရေဆိသူများဟို ခေါ်ဖို့ လာတာ မဟုတ်၊ အဲလိုလဲ အပယ်ခံရသူများဟို ခေါ်ဖို့ လာအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","လူအချို့လို့ဟ ယေရှုဟို “ယောဟန်ရဲ့ တဘဲ့လို့နဲ့ ဖာရိရှဲလို့ဟ အစာဆှောင်ခြင်းနဲ့ ဆုတောင်းခြင်းဟို ခဏခဏလုပ်လေ့ ဆိကြအယ်၊ အဲလိုလဲ ကိုယ်တော်ရဲ့ တဘဲ့တော်လို့ဟ စားသောက်နေကြမန့်လော” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ယေရှုဟ “မင်္ဂလာဆောင်ပွဲတွင် သတို့သားရဲ့ မိတ်ဆွေလို့ဟ သတို့သားနဲ့အတူ ဆိနေစဉ် သူလို့ဟို အစာဆှောင်နိန်စေမလော။ ");
INSERT INTO dnv_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","အဲလိုလဲ သတို့သားဟို သူရဲ့ အပေါင်းအဖော်လို့ဆေမှ ခေါ်ဆောင်သွားမဲ့ နေ့ရက် ရောက်လာလိမ့်မယ်၊ အေးအခါ သူလို့ဟ အစာဆှောင်ကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ယေရှုဟ ပုံဥပမာနဲ့ သူလို့ဟို ပြောတာဟ “စသူမှ အဝတ်ဟောင်းဟို အဝတ်သစ်နဲ့ ဖာလဲ့ စလေ့မဆိ၊ အဲလိုမို့ အဝတ်သစ်ဟို ဖြဲရတာမက ဖာသောအထည်သစ်ဟ အဝတ်ဟောင်းနဲ့ မကိုက်ညီဘဲ ဆိလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","အေးနည်းတူ စပျစ်ယေသစ်ဟို သားယေဖူးဟောင်းတွင် ထည့်လေ့ မဆိ၊ ပစာကို့ စပျစ်ယေသစ်ဟ သားယေဖူးဟို ပေါက်ပြဲစေသဖြင့် စပျစ်ယေယိုပင်း သားယေဖူးဟ ပျက်စီးသွားလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","အသစ်သော စပျစ်ယေဟို အသစ်သော သားယေဖူးထဲမှာ ထည့်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","စပျစ်ယေဟောင်းဟို သောက်ပင်းသော သူဟလည်း ‘စပျစ်ယေဟောင်းဟ ကောင်းအယ်’ ဟု ဆိုလျက် စပျစ်ယေအသစ်ဟို သောက်လိုစိတ်မဆိ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ဥပုသ်နေ့နှိုက် ယေရှုဟ ဂျုံစပါးခင်းလို့ဟို ဖြတ်ဆှောက်သွားခဲ့အယ်။ ကိုယ်တော်ရဲ့ တဘဲ့တော်လို့ဟ ဂျုံနှံများဟို ခူးပင်း သူလို့လက်နဲ့ ပွတ်နယ်ပင်း စားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","တချို့ ဖာရိရှဲလို့ဟ “နင်လို့ဟ မစာကျောန့် ဥပုသ်နေ့နှိုက် ငါလို့ ပညတ်ထားလဲ့ မလုပ်သင့်လဲ့ အလုပ်ဟို လုပ်ကြလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ယေရှုဟ သူလို့အား “ဒါဝိဒ်နဲ့ သူ့ရဲ့ လူများ မွတ်သောအခါ စလိုလုပ်ခဲ့ကျောန့် နင်လို့ တခါမျှ မဖတ်ဝူးသလော၊ ");
INSERT INTO dnv_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","သူဟ ဘုရားသခင်ရဲ့ အိုင်တော်ဟို ဝင်ယွေ့ ပညတ်အရ ယဇ်ပုရောဟိတ်မှတပါး စသူမှ စားခွင့် မဆိသော ဆေ့တော်မုန့်ဟို ယူစားပင်း သူရဲ့ လူများအား ပေးခဲ့အယ်” သူလို့အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","အေးနောက် ယေရှုဟ “လူသားသည် ဥပုသ်နေ့ဟို အစိုးရလဲ့ သခင် ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","တခြား ဥပုသ်နေ့နှိုက် ယေရှုဟ တရားဇရပ်ဟို ဝင်ယွေ့ သွန်သင်အယ်၊ အေးဇရပ်ထဲတွင် ညာလက် သေနေသောသူ တယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","အချို့ ကျမ်းတတ်ဆရာများနဲ့ ဖာရိရှဲအချို့လို့ဟ ယေရှုဟို မားလဲ့လုပ်ရပ်အဖြစ် စွပ်စွဲဖို့ အကျောန်းပြချက် လိုချင်နေသဖြင့်၊ ကိုယ်တော်ဟ ဥပုသ်နေ့နှိုက် အေးသူရဲ့ ရောဂါဟို ငြိမ်းစေမယ် မငြိမ်းစေမယ်ဟို သူလို့ဟ စောင့်ကျေ့နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ယေရှုဟ သူလို့ရဲ့ အတွေးဟို သိသောကျောန့် သူ့အား “ထလော့၊ အဆေ့မှာ လာလော့” ဟု မိန့်အယ်။ အေးသူဟ နေရာမှ ထပင်း ရပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","အေးနောက် ယေရှုဟ “ပညတ်အရ ဥပုသ်နေ့နှိုက် စလိုလုပ်ရမလော၊ ကောင်းတာဟို လုပ်မလော အဲဟာမဟုတ်ရင် ဆိုးတာဟို လုပ်မလော၊ တစုံတယောက်ရဲ့ အသက်ဟို ကယ်ဖို့လား အဲဟာမဟုတ်ရင် သတ်ဖို့လား” ဟု သူလို့အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ယေရှုဟ အေးသူအားလုံးလို့ဟို လှည့်ကျေ့ပင်း အေးသူဟို “နင့်လက်ဟို ဆန့်လော့” ဟု မိန့်ယွေ့ သူဟ လက်ဟို ဆန့်လိုက်သောအခါ သူ့လက်ဟ အကောင်းအတိုင်း ဖြစ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","အဲလိုလဲ ဖာရိရှဲလို့နဲ့ ကျမ်းတတ်ဆရာလို့ဟ အူထော့ဖြစ်လျက် ယေရှုအား စလို လုပ်ရမယ်ဟု အချင်းချင်း စတင် ဆွေးနွေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","အေးအချိန်ခါနှိုက် ယေရှုဟ ဆုတောင်းဖို့ တောင်ပေါ် တက်သွားပင်း၊ အေးမှာ တညလုံး ဘုရားသခင်ဆေ ဆုတောင်းနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","နောက်နေ့ရောက်သောအခါ သူ့ရဲ့ တဘဲ့တော်လို့ဟို ခေါ်ပင်း သူလို့ထဲဟ တဆယ့်နေပါးဟို ရွေးချယ်ပင်း တမန်တော်လို့ဟု နာမယ်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ရှိမုန် (ယေရှု နာမယ်ပေးတဲ့ ပေတရု) နဲ့ သူ့ရဲ့ ညီ အန္ဒြေ၊ ယာကုပ်နဲ့ ယောဟန်၊ ဖိလိပ္ပုနဲ့ ဗာသောလမဲ၊ ");
INSERT INTO dnv_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","မဿဲနဲ့ သောမ၊ အာလဖဲရဲ့ သား ယာကုပ်နဲ့ ဇေလုပ်ဟု ခေါ်သော ရှိမုန် (မျိုးချစ်စိတ်ထက်သန်သူလို့ ခေါ်သောသူ)၊ ");
INSERT INTO dnv_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ယာကုပ်ရဲ့ သား ယုဒနဲ့ သစ္စာဖောက်ဖြစ်လာမဲ့ ယုဒရှကာရုတ်လို့ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ယေရှုဟ တမန်တော်လို့နဲ့အတူ တောင်ပေါ်ဟ ဆင်းလာပင်း မြေညီရာအရပ်တွင် သူ့ရဲ့ တဘဲ့ လူအုပ်ကြီးများနဲ့အတူ ရပ်အယ်။ အေးနေရာတွင် ရမ်းဆာ့များသော လူအုပ်ကြီးများဟ ယုဒပြေ၊ ယေရုရှလင်မြို့မှ လည်းကောင်း၊ ကမ်းရိုးတန်းမြို့များ ဖြစ်လဲ့ တုရုမြို့နဲ့ ဇိဒုန်မြို့များမှ လည်းကောင်း လာကြသူ အများဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","သူလို့ဟ ကိုယ်တော်ရဲ့ တရားကြားနာရန်နဲ့ မိမိလို့ရဲ့ အနာရောဂါများ ပျောက်ကင်းစေရန် လာရောက်ကြအယ်။ ညစ်ညူးသောနတ်ကျောန့် ဒုက္ခရောက်သူများလည်း လာယွေ့ ကျန်းမာခြင်းဟို ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ကိုယ်တော်အထဲဟ တန်ခိုး ထွက်ယွေ့ လူအပေါင်းလို့ဟို ကျန်းမာစေတာ ဖြစ်ယွေ့၊ လူအားလုံးလို့ဟ ကိုယ်တော်ဟို ထိနိန်ဖို့ ကြိုးစားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ယေရှုဟ သူ့တဘဲ့တော်များဟို ကျေ့ပင်း၊ “ဆင်းရဲသော နင်လို့ဟ မင်္ဂလာဆိကြအယ်၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ နင်လို့ရဲ့ နိုင်ငံ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","အခု မွတ်သောသူလို့ဟ မင်္ဂလာဆိအယ်၊ နင်လို့ ဝပြောရလိမ့်မယ်။ အခု ငိုကသော နင်လို့ဟ မင်္ဂလာဆိအယ်၊ နင်လို့ဟ ရယ်မောရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“လူသားကျောန့် လူလို့ဟ နင်လို့ဟို မုန်းသောအခါနှိုက် လည်းကောင်း၊ ငြင်းပယ်ကြသောအခါနှိုက် လည်းကောင်း၊ စော်ကားခံရသောအခါနှိုက် လည်းကောင်း၊ မကောင်းသောသူဟု ပြောကြသောအခါနှိုက် လည်းကောင်း၊ နင်လို့ဟ မင်္ဂလာဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","အေးလို့ ကြုံတွေ့ရသောအခါ ဝမ်းမြောက်ကြလော့၊ ဝမ်းမြောက်လဲ့အတွက် ခုန်ကကြလော့၊ ပစာကို့ ခေါန်းခင်နိုင်ငံမှာ နင်လို့ဆုဟ ရမ်းဆာ့ ကြီးအယ်။ သူလို့ရဲ့ ဖိုးဖေးများဟ ပရောဖက်များလို့ဟို အေးလို့ ပုံစံအတိုင်း လုပ်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“အဲလိုလဲ ခုခါ ချမ်းသာသူလို့ နင်လို့ စလောက် ကြောက်စရာ ကောင်းလဲ၊ နင်လို့ဟ အခု ဖဝါ့နှိုက် သက်သာစွာ နေထိန်ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ခုခါ ဝစွာ စားရသောသူလို့ နင်လို့ စလောက် ကြောက်စရာကောင်းလဲ၊ နင်လို့ဟ မွတ်ခြင်းဟို ရောက်လိမ့်မယ်၊ ခုခါ ရယ်တတ်သောသူလို့ နင်လို့ စလောက် ကြောက်စရာကောင်းလဲ၊ နင်လို့ဟ ညည်းတွားခြင်းနဲ့ ငိုကခြင်းဟို ရောက်လိမ့်မယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“လူအားလုံးဟ နင်လို့ဟို ချီးမွန်းကြသောအခါ စလောက် ကြောက်စရာ ကောင်းလဲ၊ သူလို့ရဲ့ ဖိုးဖေးများဟ မားယွင်းလဲ့ ပရောဖက်များဟို အေးပုံစံအတိုင်း ဟောခဲ့ကြပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“အဲလိုလဲ ငါဟောတာဟို ကြားသောသူလို့၊ နင်လို့ရဲ့ ရန်သူများဟို ချစ်ပါ၊ နင်လို့ဟို မုန်းတဲ့လူဟိုလည်း ကောင်းလဲ့အမှုဟို ပြုပါ၊ ");
INSERT INTO dnv_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","နင်လို့ဟို ကျိန်ဆဲသောသူဟို ကောင်းချီးပေးပါ၊ နင်လို့ဟို ကဲ့ရဲ့ရှုတ်ချသော သူလို့အတွက် ဆုတောင်းပေးပါ။ ");
INSERT INTO dnv_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","နင်လို့ ပါးတဖက်ဟို တယောက်ယောက်ဟ ရိုက်ရင်၊ တခြားတဖက်ဟိုလည်း ရိုက်ဖို့ ပေးပါ၊ နင်ရဲ့ ဝတ်လုံဟို တယောက်ယောက်ဟ ယူသွားရင် နင်ရဲ့ အင်္ကျီဟိုလည်း ယူသွားဖို့ ပေးပါ။ ");
INSERT INTO dnv_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","နင့်ဆေ တောင်းခံလာသူတိုင်းဟို ပေးလော့၊ နင်ပိုင်ဆိုင်သောအရာလို့ဟို ယူသွားသော သူလို့ဆေမှ ပြန်မတောင်းနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","နင်လို့ဟ ကိုယ်နှိုက် တခြားသူ လုပ်စေလိုလဲ့အတိုင်း တခြားသူလို့အား လုပ်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“နင်လို့ဟို ချစ်သောသူဟိုသာ ချစ်ရင်၊ စလို ကောင်းကြီးဟို ခံစားနိန်မလဲ၊ အပစ်သားများတောင် သူလို့ဟို ချစ်သောသူလို့အား ချစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","နင်လို့ဟို ကောင်းတာဟို လုပ်သောသူများဟိုသာ ကောင်းတာလုပ်ပေးရင်၊ နင်လို့ဟ စလို ကောင်းကြီးဟို ခံစားနိန်မလဲ၊ အပစ်သားလို့ပင် ဟေသို့ လုပ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ပြန်လည်ရဆိမယ်ဟု မျော်လင့်လျက် သူလို့အား နင်လို့ ငမ်းရင် နင်လို့ဟ စလို ကောင်းကြီး ခံစားနိန်မလဲ၊ တူညီသော ပိတ်ဆန်ဟို ပြန်ရဆိရန် အပစ်သားလို့ပင် အပစ်သားများဆေ ငမ်းပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","အဲလိုလဲ နင်လို့ ရန်သူဟို ချစ်ကြလော့၊ ကောင်းတာဟို လုပ်ပေးကြလော့၊ ပစာဟိုမှ ပြန်ရဖို့ မမျော်လင့်ဘဲ ငမ်းကြလော့။ အေးလို့လုပ်ရင် နင်လို့ဟ ရဆိမဲ့ ဆုလာဘ်ဟ ကြီးမားပင်း နင်လို့ဟ အမြင့်မြတ်ဆုံးသော ဘုရားရဲ့ လူပဲ့သငယ်လို့ ဖြစ်ကြလိမ့်မယ်၊ ပစာကို့ သူဟ ကျေးဇူးမသိသောသူနဲ့ ဆိုးသောသူအားလည်း ကျေးဇူးပြုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","နင်လို့အဖဟ ကရုဏာဆိလဲ့အတိုင်း နင်လို့ဟလည်း ကရုဏာ ဆိကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“သူတပါးဟို တရား မစီရင်နဲ့၊ ဘုရားသခင်ဟ နင်လို့ဟို တရားစီရင် လိမ့်မယ် မဟုတ်၊ သူတပါးဟို အပစ်တင် မရှုတ်ချနဲ့၊ ဘုရားသခင်ဟ နင်လို့ဟို အပစ်တင် ရှုတ်ချတော်မမူ၊ သူတပါးဟို ခွင့်လွှတ်ကြလော့၊ ဘုရားသခင်ဟ နင်လို့ဟို ခွင့်လွှတ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","သူတပါးဟို ပေးကြလော့၊ ဘုရားသခင်ဟ နင်လို့ဟို ပေးလိမ့်မယ်။ အမန်စင်စစ်၊ ရက်ရက်ရောရော ကူညီခြင်း၊ ပြေ့လျှံသော အတိုင်းအတာထက် နင်လို့ လက်ထဲဟို သွန်းလောင်းလိမ့်မယ်။ နင်ဟ အခြားသူလို့ဟို ပေးလဲ့ပမာဏအတိုင်း ဘုရားသခင်ဟ နင်လို့ဟို ပေးလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ယေရှုဟ ပုံဥပမာအားဖြင့် သူလို့ဟို ပြောတာဟ “မျက်စေ့ မမျော်သောသူသည် တခြား မျက်စေ့ မမျော်သောသူဟို ဦးမဆောင်နိန်၊ သူဟ ဟေသို့လုပ်ခဲ့ရင် နေယောက်လုံး တွင်းထဲဟို ပြုတ်ကျလိမ့်မယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","တဘဲ့ဟ သူလို့ ဆရာထက် မြတ်တာ မဟုတ်၊ အဲလိုလဲ တဘဲ့တိုင်း သူရဲ့ ပညာသင် ပင်းသောအခါ သူလို့ဆရာလို ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“နင်လို့ဟ ပစာကျောန့် ကိုယ့်မျက်စေ့နှိုက် သစ်တုံးဟို ဂရုမစိုက်ဘဲ ညီအကိုရဲ့ မျက်စေ့မှာ ဆိလဲ့ ငြောင့်သငယ်ဟို မျော်လုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","နင်ရဲ့ ညီအကိုဟို ‘ကျေးဇူးပြုပင်း ညီအကိုရေ နင့်ရဲ့ မျက်စေ့ထဲဟ ငြောင့်သငယ်ဟို ငါ ထုတ်ပေးပါရစေ’ လို့ နင်လို့ ဖယ်လိုပြောမလဲ။ သူတော်ကောင်းဟန်ဆောင်သူလို့ နင့်ရဲ့ မျက်စေ့ထဲဟ သစ်တုံးဟို အရင်ထုတ်လော့၊ အေးသာမှ ညီအကို မျက်စေ့ထဲဟ ငြောင့်သငယ်ဟို ဆှင်းဆှင်းလင်းလင်း မျော်ရလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ကျန်းမာတဲ့ အပင်ဟ ညံ့သောအသီးဟို မသီးနိန်၊ ညံ့သောအပင်ဟလည်း ကောင်းသောအသီးဟို မသီးနိန်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","အသီးဟို ထောက်ပင်း အပင်တိုင်းဟို သိကြရအယ်၊ သင်္ဘောသဖန်းသီးဟို ဆူးပင်မှ မခူးတတ်၊ စပျစ်သီးဟို ဆူးချုံမှ လည်းကောင်း နင်လို့ မခူးနိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ကောင်းသောလူဟ ကောင်းတဲ့ စိတ်နေလုံး ဘဏ္ဍာတိုက်အထဲမှ ကောင်းတဲ့အရာများဟို ထုတ်ဖော်တတ်အယ်။ ဆိုးတဲ့လူဟ မကောင်းတဲ့ စိတ်နေလုံး ဘဏ္ဍာတိုက်အထဲမှ မကောင်းတဲ့အရာဟို ထုတ်ဖော်တတ်အယ်။ အကျောန်းမှာ စိတ်နေလုံးနှိုက် ပြေ့နေလဲ့အရာဟို စလောင်ဟ ပြောဆိုတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“နင်လို့ဟ ငါပြောလဲ့အတိုင်း မလုပ်ဘဲ ပစာကျောန့် ငါ့ဟို ‘သခင်၊ သခင်’ လို့ ခေါ်ကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ငါ့ဆေဟို လာယွေ့ ငါ့စကားများဟို ကြားပင်း နားထောင်သောသူဟ — စသူနဲ့ တူတာဟို ငါ ပြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","သူဟ မြေနက်နက် တူးပင်းမှ ကျောက်ပေါ်တွင် အုတ်မြစ်ချယွေ့ နေအိုင်ဟို တည်ဆောက်သောသူနဲ့ တူအယ်။ မြစ်ယေကြီးပင်း ယေလျှံယွေ့ အေးနေအိုင်ဟို တိုက်ခတ်လေအယ်၊ အေးယေအရှိန်ဟ နေအိုင်ဟို မလှုပ်ဆှားစေနိန်၊ ပစာကို့ အေးနေအိုင်ဟို ခိုင်အောန် တည်ဆောက်ထားသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","အဲလိုလဲ ငါ့တရားစကားများဟို ကြားပင်း မနာခံသောသူဟ အုတ်မြစ်မချဘဲ မြေပေါ်မှာ နေအိုင်ဟို တည်ဆောက်သောသူနဲ့ တူအယ်၊ မြစ်ယေလျှံပင်း အေးနေအိုင်ဟို တိုက်ခတ်လျှင် ခုတုံး ပြိုကျသွားအယ် — တကယ့်ဆိုးရွားတဲ့ ပျက်စီးမှုပဲ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ယေရှုဟ လူလို့ဟို ဟေအကျောန်းအရာ အားလုံးဟို ပြောပင်းသောအခါ ကပေရနောင်မြို့ဟို သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","အေးမြို့နှိုက် ရောမတပ်မှူး တယောက်မှာ ရမ်းဆာ့ချစ်လဲ့ ကျွန်တယောက် ဆိပင်း၊ အေးသူဟ ဖျားနာပင်း သေခါနီး ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","တပ်မှူးဟ ယေရှုရဲ့ အကျောန်းဟို ကြားသောအခါ၊ ယုဒအကြီးအကဲ တချို့လို့ဟို စေလွှတ်ပင်း၊ ကိုယ်တော်ဟ လာပင်း မိမိကျွန်ဟို ကျန်းမာစေဖို့ ဆှောက်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","သူလို့ဟ ယေရှုဆေဟို လာပင်း “အေးသူဟ နင့်ရဲ့ အကူအညီဟို အမန်တကယ်ပင် ခံထိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","သူဟ ငါလို့လူမျိုးဟို ချစ်သောကျောန့် တရားဇရပ်ဟို ငါလို့အဖို့ သူတတ်တိုင်း တည်ဆောက်ပေးသူ ဖြစ်အယ်” ဟု စိတ်အားထက်သန်စွာ တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ယေရှုဟ သူလို့နဲ့အတူ သွားအယ်။ တပ်မှူးနေအိုင်နဲ့ မနီးမဝေး ရောက်သောအခါ တပ်မှူးရဲ့ မိတ်ဆွေများဟို ကိုယ်တော်ဆေဟို လွှတ်ပင်း “ဆရာ၊ ဒုက္ခမဆာပါနဲ့၊ ကိုယ်တော်ဟာ ငါရဲ့ နေအိုင်မိုးဟို လာဖို့ ငါဟ ထိုက်တန်တဲ့သူ တယောက် မဟုတ်ပါ။ ");
INSERT INTO dnv_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","အဲကျောန့် ငါ့တတ်တိုင်းလည်း ကိုယ်တော့်ဆေ လာဖို့ ထိုက်တန်အယ်လို့တောင် ငါ မထင်ခဲ့မိဝူး။ အဲလိုလဲ အမိန့်ဟိုသာ ပေးရင် ငါ့ရဲ့ အစေခံဟ ကျန်းမာပါလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ငါတတ်တိုင်းလည်း အထက်တပ်မှူးရဲ့ အာဏာ အောက်တွင် အမှုထမ်းသူ ဖြစ်ပင်း၊ ငါ့ရဲ့ လက်အောက်တွင်လည်း စစ်သားများ ဆိပါအယ်။ စစ်သားတယောက်ဟို ‘သွားလော့’ ဟု အမိန့်ပေးရင် သူဟ သွားပါအယ်။ တယောက်ဟို ‘လာပါ’ ဟု အမိန့်ပေးရင် သူဟ လာပါအယ်။ ငါ့ရဲ့ ကျွန်ဟို ‘အေးသာဟို လုပ်ပါ’ ဟု အမိန့်ပေးရင် သူဟ လုပ်ပါအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ယေရှုဟ သူ့ရဲ့ အေးစကားဟို ကြားသောအခါ အံ့ဩယွေ့၊ သူ့နောက်ဟ လိုက်လာကြသော လူများလို့ဟို လှည့်ကျေ့ပင်း “ငါ ပြောမယ်၊ အေးလို ယုံကြည်ခြင်းဟို ဣသရေလအမျိုးထဲမှာတောင် ငါ မတွေ့ဖူးသေး” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","သတင်းပို့သမားများဟ တပ်မှူးရဲ့ နေအိုင်ဟို ပြန်ရောက်သွားသောအခါ အေးကျွန်ဟ ကျန်းမာလျက် ဆိတာဟို တွေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","မကြာခင်ပင်းနောက် ယေရှုဟ နာဣနမြို့လို့ခေါ်လဲ့ မြို့ဟို သွားခဲ့ပင်း တဘဲ့တော်လို့နဲ့ လူအုပ်လို့ဟ ကိုယ်တော်နဲ့အတူ လိုက်ပါလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ယေရှုဟ မြို့ဂိတ်အနီးဟို ရောက်သွားချိန်နှိုက် လူလို့ဟ သေဆုံးသောသူတယောက်ဟို မြို့ပြင်သို့ သယ်ဆောင်လာကြအယ်။ သူဟ အမေ့ဖြစ်သူ မုဆိုးမရဲ့ တဦးတည်းသောသား ဖြစ်အယ်။ မြို့ထဲမှာ ဆိလဲ့ လူအပေါင်းလို့ဟ သူမနဲ့အတူ လိုက်ပို့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ကိုယ်တော်ဟ အေးမိန်းမဟို မျော်သောအခါ သနားခြင်းစိတ်နဲ့ ပြေ့သဖြင့် “မငိုနဲ့” ဟု သူမဟို မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","အေးနောက် ဆှောက်သွားပင်း အခေါင်းဟို လက်နဲ့ ထိအယ်၊ အေးအခါ အခေါင်းသယ်လာသူလို့ဟ ရပ်ကြအယ်။ ယေရှုဟ “အောင်နီငယ်၊ ထလော့၊ နင့်အား ငါ ပြောအယ်” ဟု မိန့်ရင်၊ ");
INSERT INTO dnv_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","လူသေဟ ထထိန်ပင်း စကားပြောအယ်၊ ယေရှုဟ သူ့ဟို သူ့မေ့ဆေ ပြန်အပ်ဟယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","သူလို့အားလုံးဟ ကြောက်ရွံ့ပင်း ဘုရားသခင်ရဲ့ ဂုဏ်တော်ဟို ချီးမွန်းကြအယ်။ သူလို့ဟ “ငါလို့ထဲမှာ ပရောဖက်ကြီး တပါး ပေါ်ပေါက်လာပီ၊ ဘုရားသခင်ဟ မိမိလူမျိုးဟို ကယ်တင်ရန် ကြွလာပီ” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ယေရှုရဲ့ သတင်းဟ ယုဒပြေအားလုံးနဲ့ ပတ်ဝန်းကျင်တွင် ပျံ့နှံ့သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ယောဟန်ရဲ့ တဘဲ့များဟ ယောဟန်အား အေးအကျောန်းအရာ အားလုံးဟို ပြောကြားကြအယ်၊ အဲအခါ သူဟ တဘဲ့နေယောက်ဟို ခေါ်ယွေ့ ");
INSERT INTO dnv_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","သခင့်ဆေဟို စေလွှတ်ပင်း “ကိုယ်တော်ဟ ယောဟန်ပြောတဲ့ ကြွလာသောသူလော၊ အဲဟာမဟုတ်ရင် တခြားတယောက်ဟို စောင့်မျော်ရမယ်လော” ဟု မေးဆှောက်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ယေရှုဆေဟို သူလို့ လာသောအခါ သူလို့ဟ “ကိုယ်တော်ဟ ကြွလာလဲ့သူလော၊ အဲဟာမဟုတ်ရင် တခြားလူဟို မျော်လင့်ရမယ်လော ဟု မေးဖို့ နှစ်ခြင်း ယောဟန်ဟ ငါလို့ဟို ကိုယ်တော်ဆေဟို စေလွှတ်ပါပီ” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","အေးအချိန် နာရီနှိုက် ယေရှုဟ ဖျားနာသူများ၊ ရောဂါများ၊ နတ်ဆိုးဘေးမှ ကင်းလွတ်ခြင်း၊ လူများလို့အား ပျောက်ကင်းစေပင်း မျက်စေ့ မမျော်လဲ့သူများဟို မျက်စေ့ မျော်စေခြင်းဟို အခွင့်ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ကိုယ်တော်ဟ ယောဟန်ရဲ့ သတင်းသယ်ဆောင်လဲ့သူဟို “နင်လို့မျော်ပင်း ကြားရသမျှ အားလုံးဟို ယောဟန်ဆေဟို ပြန်ပင်း ပြောကြလော့၊ မျက်စေ့ မမျော်သောသူများ မျက်စေ့ မျော်ကြအယ်၊ ခြေထောက်မသန်သောသူများ လမ်းဆှောက်ကြအယ်၊ အနူရောဂါစွဲသောသူများဟ သန့်ဆှင်းခြင်းဟို ရအယ်၊ နားပင်းသောသူများ နားကြားကြအယ်၊ သေသောသူဟ အသက်ပြန်ဆှင်ကြအယ်၊ ဆင်းရဲသားလို့ဟလည်း သတင်းကောင်းဟို ကြားရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ငါ့အကျောန်းကျောန့် သံသယ မဆိသောသူဟ မင်္ဂလာဆိအယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ယောဟန်ရဲ့ သတင်းသယ်သမားလို့ ပြန်သွားကြပင်းနောက်၊ ယေရှုဟ ယောဟန်အကျောန်းနဲ့ ပတ်သက်ပင်း လူအပေါင်းလို့အား ပြောတာဟ “နင်လို့ဟ ပစာအရာဟို ကျေ့ရန် ယောဟန်ဆိရာ တောကန္တာရဟို သွားကြလုန်း။ လေတိုက်ယွေ့ လှုပ်သောကျူပင်ဟို ကျေ့ဖို့လော။ ");
INSERT INTO dnv_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","အေးလို့မဟုတ် အဝတ်အကောင်းစား ဝတ်ဆင်ထားသူလို့ဟို ကျေ့ဖို့ သွားသလော၊ အဝတ်အကောင်းစား ဝတ်ဆင်ယွေ့ ကောင်းကောင်း စားသောက်သောသူလို့ဟ မင်းအိုင်နှိုက် နေတတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ပရောဖက်လို့ဟို ကျေ့ဖို့ သွားသလော၊ မန်ပါအယ်၊ ပရောဖက်ထက် ကြီးမြတ်သူဟို ကျေ့ရှုရန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ကျမ်းစာတွင် ‘ဘုရားသခင်ဟ၊ နင့်ရဲ့ လမ်းဟို အဆင်သင့် ဖြစ်စေရန် ငါရဲ့ သတင်းသယ်ဆောင်သူဟို နင့်ရဲ့ အဆေ့မှာ စေလွှတ်မယ်’ ဟု ပြောရာနှိုက် ယောဟန်ဟို ဆိုလိုအယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ယေရှုဟ ငါအမန်ဆိုတာမှာ “မိန်းမမှ မွေးသောသူလို့တွင် ယောဟန်ထက် ကြီးမြတ်သောသူ တယောက်မျှ မဆိ။ အဲလိုလဲ ဘုရားသခင်ရဲ့ နိုင်ငံတော်တွင် အငယ်ဆုံးသောသူဟ ယောဟန်ထက် ပိုပင်း ကြီးမြတ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","လူအပေါင်းလို့ဟ သူ့ရဲ့ စကားဟို ကြားကြပင်း အေးသူလို့အနက် အထူးသဖြင့် အခွန်ခံသူများဟ ဘုရားသခင်ရဲ့ ဖြောင့်မတ်ခြင်းဟို ဝန်ခံကြပင်း ယောဟန်ပေးသော နှစ်ခြင်းဟို ခံယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ဖာရိရှဲလို့နဲ့ ကျမ်းတတ်ဆရာလို့ဟ မိမိလို့အတွက် ဘုရားသခင်ရဲ့ ရည်ရွယ်ချက်ဟို ငြင်းပယ်ယွေ့ ယောဟန်ဆေမှာ နှစ်ခြင်းဟို မခံပဲနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ယေရှုဟ ဆက်ပင်း “ဟေနေ့လူလို့ဟို စလို နှိုင်းရမလော၊ သူလို့ဟ စသူနဲ့တူလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","သူလို့ဟ ဆေးထဲမှာ ထိန်နေသော လူပဲ့သငယ်များနဲ့ တူအယ်။ သူလို့ဟ ‘ငါလို့သည် မင်္ဂလာဆောင် သီချင်းဟို တီးမှုတ်သော်လည်း နင်လို့ဟ မကကြ၊ ငါလို့ဟ အသုဘ သီချင်းဟို ဆိုကြသော်လည်း နင်လို့ဟ မငိုကကြ’ ဟု တဖွဲ့နဲ့တဖွဲ့ အော်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","နှစ်ခြင်း ယောဟန်ဟ အစာဟို မစား၊ စပျစ်ယေဟို မသောက်ဘဲနေသော် နင်လို့ဟ ‘သူနှိုက် နတ်ဆိုးစွဲနေအယ်’ ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","လူသားဟ စားလျက် သောက်လျက် လာသောအခါ နင်လို့ဟ ‘အေးလူဟို ကျေ့လော့၊ သူဟ စားကြူးပင်း သောက်ကြူးသောသူ ဖြစ်အယ်၊ အခွန်ခံများနဲ့ တခြား အပယ်ခံရသူလို့ဟို မိတ်ဆွေဖွဲ့သူ ဖြစ်အယ်’ ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","အဲလိုလဲ ဘုရားသခင်ရဲ့ ဉာဏ်ပညာဟို လက်ခံသောသူအားလုံး အမန်ဖြစ်ကျောန်းဟို ပြသကြအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ဖာရိရှဲတယောက်ဟ ယေရှုဟို မိမိနဲ့အတူ ညစာစားဖို့ ဖိတ်ခေါ်အယ်၊ ယေရှုဟ ဖာရိရှဲနေအိုင်ဟို သွားပင်း စားပွဲတွင် ထိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","အေးမြို့တွင် အပစ်နဲ့ပြေ့နေသူ မိန်းမတယောက် ဆိအယ်၊ သူမဟ ဖာရိရှဲနေအိုင်မှာ ကိုယ်တော် စားသောက်နေတယ်ဟို ကြားသောအခါ ဆီမွှေး ကျောက်ဖြူဖူး တခုဟို ယူလာပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ကိုယ်တော်ရဲ့ ခြေတော်ရင်းနှိုက် ရပ်ပင်း ငိုလျက် သူ့ရဲ့ မျက်ရည်ဟ ခြေထောက်ပေါ် ကျပင်း မိမိဆံပင်နဲ့ သုတ်လေအယ်။ ခြေထောက်ဟိုလည်း နမ်းယွေ့ ဆီမွှေးနဲ့ သုတ်လိမ်းလျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ဖာရိရှဲဟ အေးအရာဟို မျော်သောအခါ “ဟေသူဟ ပရောဖက်မန်လျှင် ခြေထောက်ဟို ကိုင်သော ဟေမိန်းမဟ စသူဖြစ်တာဟို သိလိမ့်မယ်။ စလို အပစ်နဲ့ပြေ့ပင်း အသက်ဆှင်နေလဲ့ မိန်းမဖြစ်အယ်ဟို သိလိမ့်မယ်” ဟု သူ့တတ်တိုင်း ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ယေရှုဟ “ရှိမုန်၊ ငါ နင့်ဟို ပြောစရာ တခုခုဆိအယ်” ဟု မိန့်ရာ သူဟ “ဟုတ်ကဲ့၊ ဆရာ ပြောပါ” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ယေရှုဟ “ပိတ်ဆန် ငမ်းစားလဲ့သူတဦးတွင် အကြွေးတင်သူ နေဦး ဆိအယ်။ တဦးဟ ငွေဒင်္ဂါး ငါးရာ၊ တခြားတဦးဟ ငါးဆယ် အကြွေးတင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","အကြွေးဆပ်ရန် မဆိသောကျောန့်၊ အကြွေးငမ်းထားသူဟ အေးသူနေဦးလုံးဟို အကြွေးကျေခွင့် ပေးလိုက်အယ်။ အေးသူနေဦးထဲမှာ စသူဟ အကြွေးငမ်းထားသူဟို ပိုပင်း ချစ်လိမ့်မလဲ” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ရှိမုန်ဟ “ရမ်းဆာ့သော အကြွေးဟို လျှော်ပေးခြင်း ခံရသူဖြစ်မယ်လို့ ငါထင်မြင်အယ်” ဟု ပြန်ပြောအယ်။ ယေရှုဟ “နင် ယူဆလဲ့အတိုင်း မန်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","အေးနောက် မိန်းမရဲ့ ဘက်ဟို လှည့်ပင်း ရှိမုန်ဟို “အေးမိန်းမဟို နင် မျော်သလော။ ငါဟ နင့်နေအိုင်ဟို ဝင်လာသောအခါ၊ နင်ဟ ခြေထောက်ဆေးဖို့ ယေဟို မပေး၊ အဲလိုလဲ ဟေမိန်းမဟ ငါခြေထောက်ပေါ်မှာ သူမမျက်ရည်ဖြင့် စိုစေပင်း သူမရဲ့ ဆံပင်နဲ့ သုတ်လေပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","နင်ဟ ငါ့ဟို ကြိုဆိုပင်း မနမ်း၊ အဲလိုလဲ သူမဟ ငါဝင်လဲ့အခါမှ စပင်း ငါရဲ့ ခြေထောက်ဟို အဆက်မပြတ် နမ်းလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","နင်ဟ ငါ့ဦးခေါင်းဟို ဆီနဲ့ မလိမ်း၊ အဲလိုလဲ သူမဟ ငါ့ခြေထောက်ပေါ်တွင် ဆီမွှေးနဲ့ လိမ်းလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","အဲကျောန့် နင်လို့အား ငါပြောတာဟ သူမဟ ရမ်းဆာ့သော အပစ်လို့ဟို ခွင့်လွှတ်ခြင်း ခံရပီ။ သူမဟ ကြီးမားလဲ့ အချစ်ဟို သက်သေပြလေပီ။ အဲလိုလဲ အပစ်နည်းနည်းဘဲ ခွင့်လွှတ်တဲ့သူဟ နည်းနည်းပဲ ချစ်တတ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","အဲပင်းရင် ယေရှုဟ သူမအား “နင့်ရဲ့ အပစ်ဟို ခွင့်လွှတ်ပီ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","စားပွဲနှိုက် ထိန်နေကြသော တခြားသူများဟ “အပစ်များဟို ခွင့်လွှတ်နိန်သော ဟေသူဟ စသူလဲ” ဟု အချင်းချင်း ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","အဲလိုလဲ ယေရှုဟ မိန်းမအား “နင့်ရဲ့ ယုံကြည်ခြင်းဟ နင့်ဟို ကယ်တင်ပီ၊ ငြိမ်းချမ်းစွာ သွားပါ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ကာလကတစ်ကြာသော် ယေရှုဟ တမြို့ပင်း တမြို့၊ တရွာပင်း တရွာဟို လှည့်လည်ကာ ခရီးသွားလျက် ဘုရားသခင်ရဲ့ နိုင်ငံတော်အကျောန်း သတင်းကောင်းဟို ဟောပြောအယ်။ တဘဲ့တော် တဆယ့်နေဦးလုံး ကိုယ်တော်နဲ့အတူ သွားကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","နတ်ဆိုးစွဲခြင်း ဘေးနဲ့ အနာရောဂါဘေးလို့မှ ကျန်းမာလာသော မိန်းမတချို့လို့လည်း လိုက်ကြအယ်။ မာရိ (မာဂဒလလို့ ခေါ်လဲ့သူ) ဆေမှ နတ်ဆိုးခုနေကောင် ထွက်လာတဲ့သူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ဟေရုဒ်မင်းရဲ့ တရားရုံးတွင် အရာဆိ ဖြစ်သူ ခုဇရဲ့ ပေါင်အိုမ ယောဟန္န၊ ရှုရှန္နနဲ့ တခြားမိန်းမများဟ ယေရှုနဲ့ သူ့ရဲ့ တဘဲ့တော်များဟို မိမိလို့စရိတ်ဖြင့် ကူညီ လုပ်ကျွေးသူများလည်း ပါဝင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","တမြို့ပင်း တမြို့မှ လူလို့ဟ ယေရှုဆေဟို လာကြအယ်။ လူအုပ်ကြီးဟ စုဝေးလာကြသောအခါ ယေရှုဟ ပုံဥပမာနဲ့ ပြောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“မျိုးစေ့ကြဲသောသူဟ မိမိမျိုးစေ့ဟို ကြဲမို့ ထွက်သွားလေအယ်။ သူမျိုးစေ့ကြဲစဉ်တွင် တချို့သောအစေ့ဟ လမ်းဘေးတွင် ကျသဖြင့် နင်းမိခြင်း ခံရယွေ့ မိုးခေါန်းခင် ငက်လို့ဟ ၎င်းလို့ဟို ကောက်စားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","တချို့ဟ ကျောက်မြေပေါ်မှာ ကျသဖြင့် အပင်များ ပေါက်သောအခါ မြေဆီလွှာတွင် အစိုဓာတ် မဆိသောကျောန့် ခြောက်ကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","တချို့အစေ့ဟ ဆူးတောတွင် ကျအယ်၊ ဆူးပင်များနဲ့အတူ ကြီးလာပင်း အေးအပင်လို့ဟို အုပ်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","တချို့အစေ့များဟ ကောင်းသောမြေပေါ်မှာ ကျသဖြင့်၊ အပင်ဟ ကြီးထွားပင်း ပြောင်းကောင်းဟို ရပင်း အဆတရာအသီးဟို သီးကြအယ်” ဟု မိန့်အယ်။ အေးနောက် ယေရှုဟ “ကြားရန် နားဆိသောသူ စသူမဆို၊ ကြားပါစေ” ဟု အဆုံးသတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","သူ့ရဲ့ တဘဲ့တော်များဟ ဟေပုံဥပမာရဲ့ အဓိပ္ပာယ်ဟ မစာလောဟု ယေရှုဟို မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ယေရှုဟလည်း “နင်လို့ဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်နဲ့ဆိုင်လဲ့ လျှို့ဝှက်တဲ့အရာလို့ဟို သိနားလည်ရန် နင်လို့အား ပေးခဲ့အယ်။ အဲလိုလဲ ကြွင်းသောအရာဟ နင်လို့ ကျေ့လျက်နဲ့ မမျော်၊ ကြားရလျက်ပင် နားမလည်” ဟု ပုံဥပမာရဲ့ ဆိုလိုရင်းဟို ပြောပြလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“အေးဥပမာရဲ့ ဆိုလိုရင်း အဓိပ္ပာယ်ဟ မျိုးစေ့ဟ ဘုရားသခင်ရဲ့ စကားဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","လမ်းတွင် ကျသော အစေ့များဟ တရားစကားဟို ကြားသူများဟို ဆိုလိုအယ်၊ အဲလိုလဲ မာရ်နတ်ဟ လာပင်း သူလို့ဟ ယုံကြည်ယွေ့ ကယ်တင်ခြင်း မရောက်ဖို့ လာပင်း သူလို့ရဲ့ စိတ်နေလုံးထဲမှ သတင်းစကားဟို နှုတ်ယူသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ကျောက်မြေတွင် ကျသောအစေ့ဟ သတင်းစကားဟို ကြားသောအခါ ဝမ်းသာစွာနဲ့ လက်ခံသူများ ဖြစ်ကြအယ်။ အဲလိုလဲ သူလို့ စိတ်နေလုံးတွင် အမြစ်မစွဲ၊ ခဏသာ ယုံကြည်ပင်း စုံစမ်းခြင်း အချိန်ရောက်လာသောအခါ သူလို့ဟ ဖောက်ပြန်သူများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ဆူးတောတွင် ကျသောအစေ့များဟ သတင်းစကားဟို ကြားပင်းနောက် စိုးရိမ်ခြင်းများ၊ ချမ်းသာကြွယ်ဝမှုများ၊ ကာမဂုဏ် ခံစားခြင်းလို့ဟ နှိပ်စက်သဖြင့် အသီးမသီးနိန်သော အသက်တာဆိသောသူများဟို ဆိုလိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ကောင်းသောမြေပေါ်တွင် ကျသောအစေ့ဟ သတင်းစကားဟို ကြားယွေ့ ကောင်းသော နာခံမှုဆိသော စိတ်နေလုံးဖြင့် ထိန်းသိမ်းထားကာ အသီးသီးသည်အထိ တည်မြဲကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ဆီမီးဟို ထွန်းပင်းလျှင် တောင်းနဲ့ အုပ်ထားသောသူ မဆိ၊ အိပ်ယာအောက်မှာ ထားသောသူမဆိ။ ဝင်လာသောသူဟ အလင်းဟို မျော်ဖို့ ဆီမီးခုံပေါ်မှာ တင်ထားတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“ပုန်းထားသောအရာ ဆိသမျှလို့ဟ ပေါ်လာလိမ့်မယ်၊ ဖုံးထားသောအရာ ဆိသမျှဟ အလင်းဟို ယူခြင်းဖြင့် တွေ့လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“နင်လို့ စလို နားထောင်တာဟို ဂရုစိုက်ကြလော့၊ ဆိသူအား ထပ်ပင်း ပေးလိမ့်မယ်၊ မဆိသူဆေဟ ဆိလဲ့အရာကတစ်ဟိုပင် နှုတ်ယူလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ယေရှုရဲ့ မေ့နဲ့ ညီများဟ ကိုယ်တော်ဆေဟို ကျေ့ဖို့ လာကြအယ်၊ အဲလိုလဲ လူအုပ်ကြီးကျောန့် သူ့ဆေဟို မရောက်နိန်ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","တယောက်ဟ ယေရှုဟို “ကိုယ်တော်ရဲ့ မေ့နဲ့ ညီများဟ ကိုယ်တော်ဟို တွေ့ချင်လို့ အပြင်မှာ စောင့်နေကြအယ်” ဟု ပြောကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ယေရှုဟ သူလို့အားလုံးဟို “ဘုရားသခင်ရဲ့ စကားဟို ကြားပင်း နားထောင်သောသူလို့ဟ ငါ့မေ့နဲ့ ငါ့ညီများ ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","တနေ့မှာ ယေရှုဟ တဘဲ့တော်လို့နဲ့အတူ လှေထဲဟို ဝင်ပင်း သူလို့ဟို “အိန်တဖက်ကမ်းဟို ကူးကြမယ်” ဟု ပြောအယ်။ အဲကျောန့် သူလို့ဟ စပင်း သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","သူလို့ ရွက်လွင့်နေခါ ယေရှုဟ အိပ်မွေ့နေအယ်။ ခုတုံးပင် အိန်မှာ ပြင်းထန်လဲ့ မုန်တိုင်း တိုက်သဖြင့် လှေဟ ယေနဲ့ ပြေ့သောကျောန့် သူလို့ဟ ကြီးလဲ့ အန္တရာယ်ရောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","တဘဲ့တော်လို့ဟ ယေရှုဆေဟို သွားယွေ့ သူ့ဟို နိုးပင်း “သခင်၊ သခင်၊ ငါလို့ သေတော့မယ်” ဟု ပြောကြအယ်။ ကိုယ်တော်ဟ ထယွေ့ လေနဲ့ လှိုင်းလို့ဟို ဆုံးမသဖြင့် ၎င်းလို့ဟ ရပ်တန့်ကြပင်း ငြိမ်သက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ယေရှုဟ သူ့ရဲ့ တဘဲ့တော်လို့ဟို “နင်လို့ရဲ့ ယုံကြည်ခြင်းဟ ပစာမှာ ဆိလုန်း” လို့ မေးအယ်။ အဲလိုလဲ သူလို့ဟ ကြောက်ပင်း အံ့ဩယွေ့ “ဟေသူဟ စသူလုန်း၊ သူဟ လေနဲ့ လှိုင်းဟို အမိန့်ပေးယွေ့ သူလို့ဟ နားထောင်ကြအယ်” ဟု တယောက်နဲ့တယောက် ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ယေရှုနဲ့ တဘဲ့တော်များဟ ဂါရစပြေဟို ဆက်ပင်း ရွက်လွင့်ကြအယ်၊ ဂါရစပြေဟ ဂါလိလဲပြေရဲ့ အိန်တဖက်ကမ်းတွင် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ယေရှုဟ ကမ်းပေါ် တက်လာသောအခါ မြို့မှ နတ်ဆိုးစွဲနေသော သူတဦးနဲ့ တွေ့အယ်။ အေးသူဟ ကာလအတန်ကြာ အဝတ်လည်း မဝတ်ဘဲ နေအိုင်နှိုက် မနေဘဲ လုတ်တိုင်းနှိုက်သာ နေထိန်တတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","သူဟ ယေရှုဟို မျော်သောအခါ ငိုကပင်း ယေရှုရဲ့ ခြေထောက်နားဟို လဲချကာ “ယေရှု၊ အမြင့်ဆုံးသော ဘုရားသခင်ရဲ့ သားတော်၊ ငါနဲ့ စလိုဆိုင်လုန်း။ ငါ့ဟို မညှဉ်းဆဲမဲ့အကျောန်း ငါ တောင်းပန်အယ်” ဟု အော်ပင်း ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","အေးလို့ ပြောရလဲ့အကျောန်းမှာ ယေရှုဟ နတ်ဆိုးများဟို သူ့ဆေဟ ထွက်သွားဖို့ အမိန့်ပေးလိုက်သောကျောန့် ဖြစ်အယ်၊ အကြိမ်များစွာ သူ့ဟို နတ်ဆိုးဝင်ပူးခဲ့အယ်၊ သူ့ရဲ့ ခြေထောက် လက်များလို့ဟို သံကြိုးများနဲ့ တုတ်ခြေ ဖမ်းချုပ်ထားသော်လည်း သူဟ သံကြိုးများဟို ဖြတ်ပင်း တောကန္တာရသို့ နတ်ဆိုးအားဖြင့် နှင်ချခြင်း ခံရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ယေရှုဟ သူဟို “နင့်နာမယ် စလိုခေါ်လုန်း” လို့ မေးအယ်။ ရမ်းဆာ့များလဲ့ နတ်ဆိုးများ သူ့အထဲဟို ဝင်နေသောကျောန့် “ငါ့ရဲ့ နာမယ်ဟ လေဂေါင် ဖြစ်အယ်” လို့ ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","နတ်ဆိုးများဟ တွင်းနက်ထဲဟို မပို့ဖို့ ယေရှုဟို တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","တောင်ပေါ်မှာ အစာစားနေသော ရမ်းဆာ့များလဲ့ ဝက်အုပ် အနားမှာဆိအယ်။ နတ်ဆိုးများဟ အေးဝက်အုပ်ထဲဟို ဝင်ရဖို့ တောင်းပန်ကြလျှင် သူလို့ဟို ဝင်ဖို့ အခွင့်ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","နတ်ဆိုးများဟ အေးလူထဲမှထွက်ပင်း ဝက်အုပ်ထဲဟို ဝင်ကြအယ်။ ဝက်အုပ်တအုပ်လုံးဟ အိုင်ကမ်းပါးဇောက်ဟို တဟုန်ထိုး ပြေးဆင်းပင်း ယေနစ် သေကုန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ဝက်ဟို ထိန်းလဲ့သူများဟ အေးအဖြစ်အပျက်ဟို မျော်ပင်း၊ သူလို့ဟ ပြေးပင်း မြို့နဲ့ တောရွာများတွင် သတင်းဟို အနှံ့အပြားပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","လူများလို့ဟ အေးအဖြစ်အပျက်ဟို ကျေ့ဖို့ ထွက်လာခဲ့ကြအယ်၊ ယေရှုဆေဟို သူလို့ရောက်သောအခါ နတ်ဆိုးထွက်ပင်း အဝတ်ဝတ်ယွေ့ ယေရှုရဲ့ ခြေထောက်နားမှာ အကောင်းအတိုင်း ထိန်နေလဲ့သူဟို မျော်လျှင် သူလို့အားလုံးဟ ကြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","မျော်ခဲ့လဲ့ လူများဟ နတ်ဆိုးစွဲသောသူ စလို ပျောက်ကင်းစေခဲ့တာဟို တခြားသူများအား ပြောပြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","အေးနောက် ဂါရစလူ အားလုံးလို့ဟ ရမ်းဆာ့ ကြောက်လန့်ကြသဖြင့် မိမိလို့အရပ်မှ ထွက်သွားဖို့ ယေရှုဟို ပြောကြအယ်။ အေးကျောန့် ယေရှုဟ လှေပေါ်ဟို တက်ပင်း ပြန်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","နတ်ဆိုးများ ထွက်သွားသောသူဟ “နင်နဲ့အတူ လိုက်ပါရစေ” ဟု ယေရှုဟို တောင်းပန်အယ်။ အဲလိုလဲ ယေရှုဟ သူ့ဟို စေလွှတ်ပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“နေအိုင်ဟို ပြန်ယွေ့ ဘုရားသခင်ဟ နင့်ဟို စလို လုပ်ပေးခဲ့တယ်ဆိုတာဟို ပြောလော့” ဟု အေးသူဟို မိန့်အယ်။ အေးသူဟ မြို့ထဲဟို သွားပင်း၊ ယေရှုဟ သူ့အတွက် ပစာပေးခဲ့အယ် ဆိုတာဟို ပြောကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ယေရှုဟ တခြား အိန်တဖက်ကမ်းမှ ပြန်လာသောအခါ၊ လူအားလုံးလို့ဟ သူ့ဟို စောင့်နေကြသောကျောန့် လူများဟ သူ့ဟို ကြိုဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","အေးအခါ ယာဣရု နာမယ်ဆိသောလူဟ ရောက်လာအယ်၊ သူဟ ဒေသခံတရားဇရပ်ရဲ့ အရာဆိ ဖြစ်အယ်။ သူဟ ယေရှုရဲ့ ခြေထောက်မှာ သူ့တတ်တိုင်း လဲချပင်း သူ့အိုင်ဟို လိုက်ခဲ့ဖို့ ယေရှုဟို တောင်းပန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ပစာကို့ အသက်ဆယ့်နေနှစ်အရွယ်ဆိလဲ့ သူ့ရဲ့ တဦးတည်းသောသမီးဟ သေခါနီးဆိသောကျောန့် ဖြစ်အယ်။ ယေရှုဟ ကြွလာသောအခါ လူအပေါင်းလို့ဟ အရပ်ရပ်မှ စုဝေးလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","သူလို့အထဲမှ တဆယ့်နေနှစ်ပတ်လုံး သွေးသွန်နာ ရောဂါခံစားနေရသော မိန်းမတယောက် ဆိအယ်။ မိမိမှာ ဆိလဲ့အရာအားလုံးဟို သုံးစွဲပင်း ဆရာဝန်များနဲ့ ကုသခဲ့ပေမဲ့လည်း အေးမိန်းမရဲ့ ရောဂါပျောက်ကင်းအောန် တယောက်မှ မကုသနိန်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","အဲမိန်းမဟ ယေရှုနောက်ဟို လာပင်း သူ့ရဲ့ ပန်းဖွားဟို တို့ပင်း ခုတုံးပင် သူမရဲ့ သွေးသွန်နာဟ ရပ်တန့်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ယေရှုဟ “စသူ ငါ့ဟို ထိတာလဲ” ဟု မေးအယ်။ လူတိုင်းဟ ငြင်းကြအယ်၊ ပေတရုဟ “သခင်၊ ပတ်ပတ်လည်မှာ လူအားလုံးနဲ့ လူအုပ်ကြီးဟ ကိုယ်တော်ဟို တိုးဝှေ့ကြအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","အဲလိုလဲ ယေရှုဟ “တယောက်ယောက်ဟ ငါ့ဟို ထိအယ်၊ ငါ့ကိုယ်ထဲဟ တန်ခိုးထွက်တာဟို ငါသိအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","အေးမိန်းမဟ မိမိလုပ်လဲ့အမှု ပေါ်ကျောန်းဟို သိသောအခါ တုန်လှုပ်ပင်း လာယွေ့ ယေရှုရဲ့ ခြေထောက်ရင်းမှာ သူ့တတ်တိုင်း လဲချလေအယ်။ အဲမိန်းမဟ ယေရှုဟို ပစာကျောန့် ထိရအယ်၊ ခုတုံးပင် စလို ကျန်းမာသွားကျောန်းဟို လူများဆေ့တွင် ကိုယ်တော်ဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ယေရှုဟ အေးမိန်းမဟို “ငါ့သမီး၊ နင့်ရဲ့ ယုံကြည်ခြင်းဟ နင့်ဟို ကျန်းမာစေပီ၊ ငြိမ်းချမ်းစွာ သွားလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ယေရှု အေးလို့ပြောစဉ် တရားဇရပ်မှူးရဲ့ နေအိုင်ဟ သတင်းသမားဟ လာအယ်။ “နင့်ရဲ့ သမီး သေပီ၊ ဆရာဟို မနှောက်ယှက်ပါနဲ့” လို့ ယာဣရုဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","အေးစကားဟို ယေရှု ကြားပင်းရင် “မကြောက်ကြနဲ့၊ ယုံကြည်ခြင်း တခုသာ လိုအယ်၊ သူမ ကျန်းမာလာလိမ့်မယ်” လို့ ယာဣရုဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","သူ့ရဲ့ နေအိုင်ဟို ရောက်သောအခါ ပေတရု၊ ယောဟန်၊ ယာကုပ်နဲ့ မိနီငယ် အဖနဲ့ အမေ့မှလွဲပင်း တခြားစသူဟိုမှ မိမိနဲ့အတူ အထဲဟို ဝင်ဖို့ အခွင့်မပေးဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","လူအပေါင်းလို့ဟ ဝမ်းနည်းလျက် မိနီငယ်အတွက် ငိုကလျက် နေကြအယ်။ ယေရှုဟ “မငိုကြနဲ့၊ မိနီငယ်ဟ သေသွားတာ ဟုတ်ဝူး — သူမဟ အိပ်မွေ့နေစာရီး” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","သူလို့အားလုံးဟ ယေရှုဟို ပြောင်ကြအယ်၊ ပစာကို့ သူလို့ဟ မိနီငယ်သေကျောန်းဟို သိကြသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ယေရှုဟ အဲမိနီငယ်လက်ဟို ယူပင်း “ငါ့ရဲ့ မိနီငယ်၊ ထလော့” ဟု ခေါ်တာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","မိနီငယ်ဟ အသက်ပြန်ဝင် လာပင်း ခုတုံး ထလေအယ်၊ ယေရှုဟ သူစားဖို့ တခုခုပေးရန် သူလို့ဟို အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","သူ့ရဲ့ မိဖလို့ဟ အံ့ဩသွားကြအယ်၊ အဲလိုလဲ ယေရှုဟ ပစာဖြစ်ပျက်ခဲ့အယ်ဆိုတာ တယောက်မှ မပြောဖို့ အမိန့်ပေးခဲ့တယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ယေရှုဟ တဆယ့်နေပါးသော တဘဲ့တော်များဟိုခေါ်ပင်း နတ်ဆိုးများဟို မောင်းထုတ်နိန်အောန်နဲ့ အနာရောဂါပျောက်အောန် ကုသနိန်သော တန်ခိုးအာဏာများဟို ပေးအပ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","အေးနောက် ယေရှုဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်အကျောန်းဟို ဟောပြောရန်နဲ့ ဖျားနာသူများဟို ကျန်းမာစေဖို့ သူလို့ဟို စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","သူလို့ဟို အဲသာတွေပြောပင်းနောက် “လမ်းခရီးအတွက် ပစာအရာဟိုမှ မယူကြနဲ့၊ တောင်ဝှေး၊ ခရီးဆောင်အိတ်၊ အစားအစာ၊ ပိတ်ဆန်၊ အင်္ကျီအပိုတောင် မယူကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","နင့်ဟို ကြိုဆိုလဲ့ စလို နေအိုင်မဆို အေးမြို့မှ မထွက်မချင်း အဲနေအိုင်မှာ နေလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","နင့်ဟို လူလို့ မကြိုဆိုလဲ့ နေရာတိုင်းမှာ သူလို့တဖက်နှိုက် သက်သေအနေနဲ့ အေးမြို့မှ မသွားခင် နင်လို့ ခြေဖဝါးမှ ဖုန်မှုန့်ဟို ခါချခဲ့ကြလော့” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","တဘဲ့တော်လို့ဟ ထွက်သွားယွေ့ ရွာများလို့ဟို ဖြတ်သွားပင်း ခရီးပြုလျက် သတင်းကောင်းနဲ့ ကျန်းမာခြင်းများဟို နေရာတိုင်းမှာ ဟောပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ဂါလိလဲပြေတွင် အုပ်ချုပ်နေသော ဟေရုဒ်မင်းဟ ဖြစ်ပျက်သမျှအားလုံးဟို ကြားသိသောအခါ သူဟ စိတ်ရှုပ်ထွေးသွားအယ်၊ ပစာကို့ လူတချို့ဟ နှစ်ခြင်း ယောဟန် အသက်ပြန်ဆှင်လာပီဟု ပြောသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","တချို့လို့ဟ ဧလိယ ပေါ်လာပီလို့ ပြောဆိုကြအယ်၊ တချို့လို့ဟလည်း ရှေးအခါဟ ပရောဖက်တပါးပါး အသက်ပြန်ဆှင်လာအယ်ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ဟေရုဒ်ဟလည်း “ငါဟ ယောဟန်ရဲ့ ဦးခေါင်းဟို ဖြတ်ခဲ့အယ်၊ အဲလိုလဲ ငါကြားရတဲ့ ဟေအကျောန်းအရာရဲ့ အေးသူဟ စသူလုန်း” ဟု ပြောဆိုယွေ့ သူဟ ယေရှုဟို တွေ့နိန်ဖို့ ကြိုးစားနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","တမန်တော်လို့ဟ ယေရှုဆေဟို ပြန်လာပင်း မိမိလို့လုပ်ခဲ့လဲ့ အရာအားလုံးဟို ပြောကြအယ်။ ယေရှုဟ သူလို့ဟို ခေါ်ပင်း ဗက်ဇဲဒလို့ ခေါ်လဲ့မြို့ဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","လူအုပ်ကြီးဟ အေးအကျောန်းဟို ကြားလျှင် သူလို့ဟ ယေရှုနောက်ဟို လိုက်ကြအယ်။ ကိုယ်တော်ဟ သူလို့ဟို ကြိုဆိုပင်းရင် ဘုရားသခင်ရဲ့ နိုင်ငံတော်အကျောန်းဟို ပြောကြားယွေ့၊ ကျန်းမာခြင်း လိုအပ်သူများဟိုလည်း ကျန်းမာစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ညနေစောင်းသောအခါ တဘဲ့တော် တဆယ့်နေပါးလို့ဟ ယေရှုဆေဟို လာပင်း “လူလို့ဟို စေလွှတ်ပင်း ပတ်ဝန်းကျင်ရွာများဟို သွားပင်း နေစရာနဲ့ စားစရာများဟို ဆာစေပါ၊ ပစာကို့ ဟေအရပ်ဟ အထီးကျန်လဲ့ အရပ်ဖြစ်သောကျောန့် ဖြစ်အယ်” ဟု ပြောပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","အဲလိုလဲ ယေရှုဟ သူလို့ဟို “နင်လို့တတ်တိုင်း သူလို့ဟို စားစရာတခုခုဟိုပေးပါ” လို့ ပြောအယ်။ သူလို့ဟ “ငါ့လို့မှာ မုန့်ငါးလုံးနဲ့ ငါးနေကောင်ပဲ ဆိအယ်၊ ငါလို့ဟ ဟေလူအုပ်အားလုံးအတွက် အစားအစာဟို သွားဝယ်စေချင်သလော” ဟု ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(အေးမှာ ယောက်ျားအရေအတွက် ၅,၀၀၀ ဆိအယ်) ယေရှုဟ တဘဲ့တော်လို့အား “အေးသူလို့ဟို အယောက်ငါးဆယ် တစုစီ ထိန်ခိုင်းကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","တဘဲ့တော်လို့ဟလည်း ပြောလဲ့အတိုင်း လုပ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ယေရှုဟ မုန့်ငါးလုံးနဲ့ ငါးနေကောင်ဟို ယူပင်း ခေါန်းခင်ဟို မော့ကျေ့ယွေ့ သူလို့အတွက် ဘုရားသခင်ဟို ချီးမွန်းပင်း မုန့်ဟို ဖဲ့ယွေ့ လူလို့အား ဝေပေးဖို့ တဘဲ့တော်လို့ဟို ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","သူလို့အားလုံးဟ လုံလုံလောက်လောက် စားရပင်း၊ သူလို့ရဲ့ အကျန်များဟို တဘဲ့တော်လို့ဟ ကောက်သိမ်းရာ ဆယ့်နေတောင်း ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","တနေ့မှာ ယေရှုတယောက်တည်း ဆုတောင်းနေသောအခါ တဘဲ့တော်များဟ သူ့ဆေဟို လာကြအယ်။ ကိုယ်တော်ဟ “လူအုပ်များဟ ငါ့ဟို စသူလို့ ပြောကြတုန်း” ဟု သူလို့ဟို မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“တချို့ပြောကြတာဟ နင်သည် နှစ်ခြင်း ယောဟန် ဖြစ်အယ်၊ တချို့ပြောကြတာဟ နင်သည် ဧလိယ ဖြစ်အယ်၊ တချို့ပြောကြတာက ဟိုအရင်ခါဟ ပရောဖက်တပါးပါး အသက်ပြန်ဆှင်လာအယ်” လို့ ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“နင်လို့ကော စလိုထင်တုန်း၊ ငါ့ဟို စသူလို့ ထင်ကြတုန်း” လို့ ယေရှုဟ သူလို့ဟို မေးအယ်။ ပေတရုဟ “နင်ဟ ဘုရားသခင်ရဲ့ မေဆှိယ ဖြစ်အယ်” လို့ ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ယေရှုဟ တယောက်ဟိုမှ မပြောဖို့ သူလို့ဟို တင်းတင်းကျပ်ကျပ် အမိန့်ပေးတယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ယေရှုဟ “လူသားဟ အကြီးအကဲများ၊ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာများရဲ့ ငြင်းပယ်ခြင်းဟို ခံရပင်းရင် ဝေဒနာများဟိုလည်း ခံစားရမယ်။ သူဟ အသေသတ်ခြင်းဟို ခံရမယ်။ အဲလိုလဲ သုံးရက်မြောက်နေ့မှာ အသက်ပြန်ဆှင် ထမြောက်လိမ့်မယ်” ဟု သူလို့အား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","အေးလို့သူလို့အားလုံးဟို ပြောပင်းနောက် “ငါနဲ့အတူလိုက်ချင်သော သူတစုံတယောက်ဟ ကိုယ့်ကိုကိုယ် ငြင်းပယ်ရမယ်၊ ကိုယ့်လက်ဝါးကပ်တိုင်ဟို နေ့တိုင်းထမ်းယွေ့ ငါ့နောက်ဟို လိုက်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","နင်ဟ မိမိရဲ့ အသက်ဟို ကယ်တင်လိုရင် နင်ဟ အသက်ဟို ဆုံးလိမ့်မယ်၊ အဲလိုလဲ နင်လို့ဟ ငါ့ကျောန့် အသက်ဆုံးသူဟ မိမိအသက်ဟို ကယ်တင်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","လူဟ လောကတခုလုံးဟို အောန်နိန်ခွင့်ရသော်လည်း မိမိတတ်တိုင်း ဆုံးရှုံးသောသူဟ ပစာအကျိုးဆိလုန်း၊ စလို အကျိုးကျေးဇူးမှ ဆိမောင့်လဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","တစုံတယောက်ဟ ငါနဲ့ ငါ့ရဲ့ သင်ကြားမှုကျောန့် ဆှက်ရင် လူသားဟ မိမိရဲ့ ဘုန်း၊ အဖရဲ့ ဘုန်း၊ သန့်ဆှင်းသော ခေါန်းခင်တမန်များရဲ့ ဘုန်းနဲ့ ပြန်လာသောအခါ အေးသူဟို ဆှက်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","နင်လို့ဟို ငါအမန်အကန်ဆိုတာဟ ဟေအရပ်နှိုက်ဆိသော သူအချို့လို့ဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို မမျော်ခင် မသေရကြ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","အေးအကျောန်းဟို ပြောပင်း တပတ်လောက်ကြာသောအခါ၊ ယေရှုဟ ပေတရု၊ ယောဟန်နဲ့ ယာကုပ်လို့ဟို ခေါ်ပင်း သူနဲ့အတူ ဆုတောင်းဖို့ တောင်ပေါ်ဟို သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ဆုတောင်းနေလဲ့အချိန်တွင် သူ့ရဲ့ မျက်နှာ ပြောင်းလဲလာပင်း၊ သူ့ရဲ့ အဝတ်အစားဟ ဖြူဖွေး တောက်ပလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ခုတုံးပင် လူနေယောက်ဟ ပေါ်လာပင်း ယေရှုနဲ့ စကားပြောလျက်နေအယ်။ သူလို့ဟ ဧလိယနဲ့ မောရှေ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","သူလို့ဟ ခေါန်းခင်ကနေ ဘုန်းတော်နဲ့အတူ ပေါ်လွင်လာပင်း ဘုရားသခင်ရဲ့ ရည်ရွယ်ချက် မကြာခင် ပြေ့စုံဖို့ ယေရုရှလင်မြို့မှာ အသေခံရမဲ့အကျောန်းဟို ယေရှုနဲ့အတူ ပြောဆိုနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ပေတရုနဲ့ သူ့ရဲ့ အဖော်လို့ဟ အိပ်မွေ့လျက်နေကြအယ်။ အဲလိုလဲ သူလို့ဟ ထလာပင်း ယေရှုရဲ့ ဘုန်းတော်နဲ့ သူနဲ့အတူ ရပ်နေကြလဲ့ လူနေယောက်လို့ဟို မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","အေးလူလို့ဟ ယေရှုဆေမှ ထွက်သွားပင်း၊ ပေတရုဟ “သခင်၊ ဟေနေရာဟ ငါလို့ဖို့ စလောက်နေဖို့ကောင်းအယ်၊ ငါလို့ ကိုယ်တော်အတွက် တခု၊ မောရှေအတွက် တခုနဲ့ ဧလိယအတွက် တခု၊ တဲသုံးခုဟို ငါလို့ ဆောက်လုပ်ပါရစေ” ဟု မိမိ စလိုအရာ ပြောဆိုနေတာဟို မသိဘဲ ယေရှုအား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","အေးလို့ စကားပြောနေသောအခါ မိုးချေးသားဟ ပေါ်လွင်လာပင်း သူလို့ဟို အရိပ်နဲ့ ဖုံးယွေ့ မိုးချေးသားဟ တဘဲ့တော်များ အပေါ်မှာ ရောက်လာသောအခါ သူလို့ဟ ကြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","မိုးချေးသားထဲဟ “အေးသူဟ ငါရွေးချယ်ထားလဲ့ ငါ့ရဲ့ သား ဖြစ်အယ် သူ့စကားဟို နားထောင်ကြလော့” လို့ အသံထွက်ပေါ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","အသံရပ်သွားသောအခါ၊ ယေရှုဟ တယောက်တည်း ဆိအယ်။ တဘဲ့တော်များဟ သူလို့ မျော်လဲ့အကျောန်းအရာများဟို အဲအချိန်နှိုက် စသူမှ မပြောဘဲ တိတ်ဆိတ်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","နောက်တနေ့မှာ ယေရှုနဲ့ တဘဲ့တော် သုံးယောက်ဟ တောင်ပေါ်မှ ပြန်ဆင်းကြသောအခါ လူအုပ်ကြီးများဟ ယေရှုဟို ကြိုဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","လူအုပ်ထဲမှ လူတယောက်ဟ အော်ပင်း “ဆရာ၊ ငါရဲ့ သားဟို ကျေ့ပေးပါ၊ ငါ တောင်းပန်ပါတယ်၊ သူဟ ငါရဲ့ တဦးတည်းသောသား ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","နတ်ဟ သူ့ဟို တိုက်ခိုက်သဖြင့် သူဟ ခုတုံး အော်ယွေ့ လဲချပင်း စလောင်ထဲမှာ အမြှုပ်ဟို ထွက်စေတတ်အယ်။ သူ့ဟို နာကျင်စေပင်းမှ ခက်ခက်ခဲခဲနဲ့ ထွက်သွားတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ငါဟ နင့်ရဲ့ တဘဲ့တော်များအား မောင်းထုတ်ပေးရန် တောင်းပန်ပေမဲ့ သူလို့ဟ မလုပ်နိန်ကြပါ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ယေရှုဟ “ယုံကြည်ခြင်း ကင်းမဲ့လူလို့နဲ့ မားသောလူလို့၊ နင်လို့နဲ့အတူ ငါ စလောက်ကြာအောန် နေရမလဲ၊ နင်လို့ဟို စလောက်ကြာအောန် သည်းခံရမလဲ” လို့ ပြန်ပြောအယ်။ အေးနောက် ယေရှုဟ အေးလူဟို “နင့်ရဲ့ သားဟို ဟေနားခေါ်ခဲ့” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","အောင်နီငယ် လာသောအခါ၊ နတ်ဆိုးဟ မြေကြီးပေါ်မှာ မောက်ချပင်း သူ့ဟို ကြမ်းတမ်းစွာ ပစ်ချအယ်။ ယေရှုဟ ညစ်ညူးသောနတ်ဟို အမိန့်ပေးယွေ့ အောင်နီငယ်ဟို ကျန်းမာစေပင်းနောက် သူ့အဖဆေဟို ပြန်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","လူအားလုံးလို့ဟ ဘုရားသခင်ရဲ့ ကြီးမြတ်သော တန်ခိုးတော်ဟို မျော်ပင်း အံ့ဩကြအယ်။ လူအားလုံးလို့ဟ ယေရှုလုပ်ခဲ့လဲ့ အရာအားလုံးဟို အံ့ဩနေကြစဉ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ယေရှုဟ သူရဲ့ တဘဲ့တော်များဟို “ငါပြောခဲ့လဲ့ အကျောန်းအရာဟို မမေ့ကြနဲ့၊ လူသားဟ လူလို့ရဲ့ လက်ထဲဟို အပ်တဲ့အချိန် ရောက်လာပီ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","အဲလိုလဲ တဘဲ့တော်များဟ ပစာဆိုလိုတာဟို မသိကြ။ သူလို့ နားမလည်အောန် အဲဒီအရာဟို သူ့လို့ဆေမှာ အောန်းထားသောကျောန့် ဖြစ်အယ်၊ သူလို့ဟ အေးအကျောန်းအရာဟို မေးဖို့ ကြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","တဘဲ့တော်များဟ မိမိလို့တွင် စသူဟ အကြီးမြတ်ဆုံး ဖြစ်မလဲဆိုတာဟို အချင်းချင်း ငြင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ယေရှုဟ သူလို့ စလိုစိတ်ထဲမှာ တွေးနေကြတယ်ဆိုတာဟို သိသောကျောန့် လူပဲ့သငယ်ဟို ခေါ်ပင်းရင် သူ့ဘေးမှာ ရပ်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","အေးနောက် ယေရှုဟ သူလို့ဟို “ငါ့ရဲ့ နာမနဲ့ ဟေလူပဲ့သူငယ်ဟို ကြိုဆိုလဲ့သူဟ ငါ့ဟိုလည်း ကြိုဆိုအယ်။ ငါ့ဟို ကြိုဆိုသော သူဟ ငါ့စေလွှတ်လိုက်သော သူဟိုလည်း ကြိုဆိုအယ်။ နင်လို့တွင် အနှိမ့်ချဆုံးသောသူဟ အကြီးမြတ်ဆုံးသောသူ ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ယောဟန်ဟ “သခင်၊ နင့်ရဲ့ နာမနဲ့ နတ်ဆိုး မောင်းထုတ်နေသူတဦးဟို ငါလို့ မျော်ခဲ့အယ်၊ သူဟ ငါလို့ အဖွဲ့ထဲဟ မဟုတ်သောကျောန့် ငါလို့ သူ့ဟို ရပ်ဖို့ ပြောခဲ့အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ယေရှုဟ “အေးသူလို့ဟို မတားကြနဲ့၊ ပစာကို့ နင်လို့ရဲ့ ရန်သူဖက်နှိုက် မဆိသောသူဟ နင်လို့ဖက်နှိုက် ဆိအယ်” ဟု တဘဲ့တော်များဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ယေရှုဟ ခေါန်းခင်ဟို ခေါ်ဆောင်ရန် အချိန်နီးလာသောအခါ သူ့စိတ်ထဲမှာ ဆိလဲ့အတိုင်း ယေရုရှလင်မြို့ဟို သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ကိုယ်တော်ဟ သူ့ဆေ့မှာ သတင်းသမားဟို ဦးရင် စေလွှတ်အယ်။ သူလို့ဟ ကိုယ်တော်အတွက် အဆင်သင့် အားလုံးပြင်ဆင်ဖို့ ရှမာရိရွာထဲဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","အဲလိုလဲ ကိုယ်တော်ဟ ယေရုရှလင်မြို့ဟို ခရီးသွားနေတာ ဖြစ်သောကျောန့်၊ အေးမှာဆိလဲ့လူများဟ သူ့ဟို လက်မခံကြဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ကိုယ်တော်ရဲ့ တဘဲ့တော်များဖြစ်ကြလဲ့ ယောဟန်နဲ့ ယာကုပ်ဟ အေးအရာဟို မျော်သောအခါ “သခင်၊ သူလို့ဟို ဖျက်ဆီးဖို့ ခေါန်းခင်ဟ မီးကျယွေ့ လောင်စေဖို့ရန် ငါလို့ လုပ်စေချင်သလော” ဟု သူလို့ဟ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ယေရှုဟ လှည့်ပင်း သူလို့ဟို ဆုံးမအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","အေးနောက် ယေရှုနဲ့ တဘဲ့တော်များဟ တခြားရွာဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","အေးသူလို့ လမ်းမှာ သွားနေစဉ် လူတယောက်ဟ “နင် စနားသွားသွား ငါ နင့်နောက်လိုက်မယ်” ဟု ယေရှုဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ယေရှုဟ “မြေခွေးမှာ တွင်းဆိအယ်၊ မိုးခေါန်းခင်နှိုက် ငက်မှာလည်း အသိုက်ဆိပေမဲ့ လူသားမှာတော့ နားဖို့နဲ့ လဲဖို့ နေရာမဆိ” ဟု သူ့ဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ကိုယ်တော်ဟ တခြားလူတယောက်ဟို “ငါ့နောက်လိုက်မန့်” ဟု ပြောအယ်။ အဲလိုလဲ အေးလူဟ “ဆရာ၊ ငါအဖဟို သင်္ဂြိုဟ်ဖို့ အရင် ငါ ပြန်ပါရစေ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ယေရှုဟ “လူသေများဟို လူသေလို့ပဲ သင်္ဂြိုဟ်ပါစေ၊ နင်သွားပင်း ဘုရားသခင်ရဲ့ နိုင်ငံတော်အကျောန်းဟို ပြောကြားလော့” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","နောက်တယောက်ဟ “ဆရာ၊ ငါဟ ကိုယ်တော့်နောက်ဟို လိုက်မယ်၊ အဲလိုလဲ ငါ့ရဲ့ မိသားစုဟို အရင်သွားပင်း နှုတ်ဆက်ပါရစေ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ယေရှုဟ သူဟို “ထယ်ကို ကိုင်ပင်း နောက်ဟို လှည့်ကျေ့သူဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်အတွက် အသုံးမဝင်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","သခင်ဘုရားဟ တခြားတဘဲ့တော် ၇၂ ဦး ဟို ရွေးချယ်ပင်းနောက် သူလို့ဟို နေယောက်တတွဲစီ တွဲပင်း သူလာမဲ့ မြို့နေရာများလို့ဟို အရင်သွားဖို့ သူလို့ဟို စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ကိုယ်တော်ဟ သူလို့ဟို “ရိတ်သိမ်းရန် အများဆိအယ်၊ အဲလိုလဲ အလုပ်သမားများဟ ရမ်းဆာ့နည်းအယ်။ ပိုင်ဆှင်ဟ ရိတ်သိမ်းရန် အလုပ်သမားများ ပိုမို စေလွှတ်ဖို့ ဆုတောင်းကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","သွားကြ၊ ဝံပုလွေအုပ်ထဲဟို သိုးသငယ်များဟို စေလွှတ်သလိုမျိုး နင်လို့ဟို ငါ စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ပိတ်ဆန်အိတ်၊ လွယ်အိတ်၊ ဖိနပ်လို့ဟို မယူသွားကြနဲ့၊ လမ်းမှာ ရပ်ပင်း တယောက်ဟိုမှ မနှုတ်ဆက်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","နင်လို့ အိုင်ဟို ဝင်လဲ့အခါတိုင်း ‘ဟေနေအိုင်ပေါ်မှာ ငြိမ်သက်ခြင်း ဆိပါစေ’ လို့ အရင်ပြောလော။ ");
INSERT INTO dnv_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ငြိမ်သက်မှုဟို ချစ်လဲ့သူတဦး အေးမှာနေထိန်ရင် နင်လို့နှုတ်ဆက်လဲ့ ငြိမ်သက်ခြင်းဟို အေးသူခံစားရလိမ့်မယ်။ အေးလို့မဟုတ်ရင် နင့်ရဲ့ နှုတ်ဆက်လဲ့ ငြိမ်သက်ခြင်းဟို ပြန်တုံ့လာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","အေးနေအိုင်မှာ နေပင်း အိုင်ဆှင် ကျွေးမွေးလဲ့ စားစရာ သောက်စရာများဟို စားကြလော့၊ ပစာကို့ အလုပ်သမားများအတွက် အခဟို ပေးရတဲ့အတွက် ဖြစ်အယ်။ နေအိုင်တအိုင်မှ တခြားနေအိုင်ဟို မရွေ့ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","နင်လို့မြို့ထဲဟို ဝင်ပင်း ကြိုဆိုလက်ခံလဲ့အခါ နင်လို့အဆေ့မှာ ဆိလဲ့အရာဟို စားကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","အေးမြို့မှာဆိလဲ့ ဖျားနာသူများဟို ကျန်းမာစေကြပင်းနဲ့ ‘ဘုရားသခင်ရဲ့ နိုင်ငံတော် တည်လုနီးပီ’ လို့ လူလို့ဟို ပြောလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","အဲလိုလဲ နင်လို့ မြို့ထဲဟို သွားယွေ့ သူလို့ မကြိုဆိုရင် လမ်းအပြင်ဟို ထွက်ပင်း ဟေလို့ပြောလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘နင်လို့ဟို သတိပေးလဲ့အနေနဲ့ ငါလို့ခြေထောက်မှာ ကပ်နေလဲ့ နင်လို့မြို့ဟ ဖုန်မှုန့်ဟို ငါလို့ ခါချအယ်၊ အဲလိုလဲ ဘုရားသခင်ရဲ့ နိုင်ငံတော် တည်လုနီးပီဟို သတိရကြပါ’ ဟု ပြောကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","နင်လို့ဟို ငါ အမန်အကန်ဆိုတာဟ တရားစီရင်ရာနေ့မှာ ဘုရားသခင်ဟ အေးမြို့ထက်ပိုပင်း သောဒုံမြို့ဟို ကရုဏာထားမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ခေါရာဇိန်မြို့ ကြောက်စရာကောင်းလဲ့အရာဟ နင့်ဟို စောင့်နေအယ်၊ အေးတိုင်းတိုင်း ဗက်ဇဲဒမြို့လည်း ကြောက်စရာလဲ့အရာတွေဟ နင့်ဟို စောင့်နေအယ်။ နင်လို့ဆေမှာ ပြခဲ့လဲ့ နိမိတ်လက္ခဏာများဟို တုရုမြို့နဲ့ ဇိဒုန်မြို့တွင် ပြခဲ့ရင် လူများလို့ဟ အရင်အခါဟ လျှော်တေအဝတ်ဟို ဝတ်ပင်း၊ ပြာမှုန့်ဟို သူလို့ပက်ပင်း ထိန်လျက် သူလို့ဟ မိမိလို့ရဲ့ အပစ်များမှ ပြန်လှည့်ကျောန်းဟို ပြသမယ်ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","တရားဆုံးဖြတ်ရာ နေ့နှိုက် နင်လို့ထက် တုရုမြို့နဲ့ ဇိဒုန်မြို့ဟို ဘုရားသခင်ဟ ကရုဏာပိုပင်း ပြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","အဲလိုလဲ ကပေနောင်မြို့ နင်ဟ နင့်တတ်တိုင်း ခေါန်းခင်တိုင်အောန် မြှောက်စားခြင်းဟို ခံလိုသလော၊ ငရဲတိုင်အောန် နိမ့်ချခြင်းဟို ခံရလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ယေရှုဟ “နင်လို့စကားဟို နားထောင်လဲ့ စသူမဆို ငါ့စကားဟို နားထောင်အယ်၊ နင်လို့ဟို ငြင်းပယ်လဲ့ စသူမဆို ငါ့ဟို ငြင်းပယ်အယ်၊ ငါ့ဟို ငြင်းပယ်လဲ့ စသူမဆို ငါ့ဟို စေလွှတ်လဲ့သူဟို ငြင်းပယ်အယ်” ဟု တဘဲ့တော်များဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","တဘဲ့တော် ၇၂ ဦး လို့ဟ ဝမ်းမြောက်စွာနဲ့ ပြန်လာပင်း “သခင်၊ ငါလို့ဟ ကိုယ်တော်ရဲ့ နာမနဲ့ အမိန့်ပေးသောအခါ နတ်ဆိုးလို့ပင် နာခံကြပီ” ဟု သူလို့ဟ ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ယေရှုဟ သူလို့ဟို “ခေါန်းခင်မှ ဆှပ်စီးကျသလိုမျိုး စာတန် ကျလာတာဟို ငါ မျော်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","နားထောင်လော့၊ ငါ့ရဲ့ တန်ခိုးအာဏာများဟို နင်လို့ဟို ပေးထားသောကျောန့် နင်လို့ဟ မြွေများ၊ ကင်းမြီးကောက်လို့ဟို နိန်ရသောအခွင့်နဲ့ ရန်သူများဟို နိန်လိမ့်မယ်၊ နင်လို့ဟို ပစာအရာမှ မနာကျင်စေရ။ ");
INSERT INTO dnv_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","အဲလိုလဲ နတ်ဆိုးများဟ နင်လို့စကားဟို နားထောင်သောကျောန့် ဝမ်းမသာကျနဲ့။ နင်လို့ရဲ့ နာမယ်များဟို ခေါန်းခင်မှာ ရေးထားတဲ့အတွက်ကျောန့် ဝမ်းသာကြလော့” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","သန့်ဆှင်းသော ဝိညာဉ်တော်အားဖြင့် ယေရှုဟ ဝမ်းမြောက်ခြင်းနဲ့ ပြေ့နေချိန်နှိုက် ကိုယ်တော်ဟ “အဖ၊ ခေါန်းခင်နဲ့ မြေကြီးရဲ့ အဆှင်၊ ပညာဆိများနဲ့ ဉာဏ်ထက်မြက်သောသူများအား ဟေအရာလို့ဟို အောင်းထားလျက် မသိနားမလည်သော သူများဟို ပြသပေးခဲ့လို့ ကျေးဇူးတင်ပါတယ်။ မန်အယ်၊ အဖ၊ အေးလို့ ဖြစ်ပျက်ရလဲ့အကျောန်းဟ ကိုယ်တော် အလိုဆိသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ငါ့အဖဟ အရာအားလုံးဟို ငါ့အား ပေးအယ်၊ သားတော်ဟ စသူဖြစ်ကျောန်းဟို ခမည်းတော်မှလွဲရင် စသူမှ မသိ၊ အဖဟ စသူဖြစ်ကျောန်းဟိုလည်း သားတော်နဲ့ သားတော်ဟ ဖော်ပြလိုသူမှလွဲရင် စသူမှ မသိ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","အေးနောက် ယေရှုဟ တဘဲ့တော်များဆေဟို လှည့်ပင်း “နင်လို့ မျော်လဲ့အရာလို့ဟို မျော်ရသော မျက်စေ့လို့ဟ မင်္ဂလာဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","နင်လို့ဟို ငါပြောတာဟ ရမ်းဆာ့သော ပရောဖက်များ၊ ဘုရင်များဟ နင်လို့ မျော်ရလဲ့အရာများဟို မျော်ရရန် အလိုဆိသော်လည်း မမျော်ရကြ။ နင်လို့ ကြားနေရသောအရာများဟို ကြားရရန် အလိုဆိသော်လည်း မကြားခဲ့ရကြ” လို့ သူလို့ဟို သီးသန့်ပြောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ကျမ်းတတ်ဆရာတယောက်ဟ ယေရှုဆေဟို လာပင်း “ဆရာ၊ ထာဝရ အသက်ဟို ရဖို့ ငါ ပစာလုပ်ရမလဲ” လို့ ထောင်ချောက်ဆင်ပင်း မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ယေရှုဟ “ပညတ္တိကျမ်းတွင် စလို ဖော်ပြသလဲ၊ သူလို့ဟို နင် စလို အနက်ပြန်မလဲ” ဟု သူ့ဟို ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","အေးလူဟ “ ‘နင့်ရဲ့ အဆှင် ဘုရားသခင်ဟို စိတ်နေလုံး အကြွင်းမဲ့၊ အစွမ်းဆိသမျှ၊ ဉာဏ်ဆိသမျှ အားလုံးနဲ့ ချစ်လော့၊ နင့်ရဲ့ အိုင်နီးချင်းဟိုလည်း မိမိတတ်တိုင်း ချစ်သလိုမျိုး ချစ်လော့’ ဟူယွေ့ လည်းကောင်း ဖြစ်ပါ” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ယေရှုဟ “နင် မန်အယ်၊ အေးအတိုင်းလုပ်ရင် အသက်ဟို ရလိမ့်မယ်” လို့ ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","အဲလိုလဲ ကျမ်းတတ်ဆရာဟ သူတတ်တိုင်း အပစ်မဆိကျောန်း သက်သေပြလိုသောစိတ်နဲ့ ယေရှုဟို “ငါရဲ့ အိုင်နီးချင်းဟ စသူလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ယေရှုဟ “လူတယောက်ဟ ယေရုရှလင်မြို့မှ ယေရိခေါမြို့ဟို သွားလဲ့လမ်းတွင် ထားပြများရဲ့ တိုက်ခိုက်ခြင်းဟို ခံရအယ်။ သူ့ရဲ့ အဝတ်ဟို ချွတ်ပင်း၊ ဖိုင်ယွေ့ သေခါနီး ဖြစ်သောအခါ သူ့ဟို ထားခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ယဇ်ပုရောဟိတ်တပါးဟ အေးလမ်းဟနေပင်း သွားတာ ဖြစ်သောကျောန့် အေးလူဟို မျော်သောအခါ သူဟ တခြားတဖက်ဟနေပင်း ကွင်းသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","အေးတိုင်းတိုင်း လေဝိ လူတယောက်ဟလည်း အေးနေရာဟို ရောက်လာအယ်။ သူဟ အေးလူနာနားဟို သွားကျေ့ပင်း တခြားတဖက်ဟနေ ကွင်းသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","အဲလိုလဲ အဲလမ်းဖြင့် ခရီးသွားသော ရှမာရိ လူတယောက်ဟ အေးလူဟို မျော်သောအခါ သနားခြင်းစိတ် ဆိသဖြင့်၊ ");
INSERT INTO dnv_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","အေးလူဆေဟို ချဉ်းကပ်ပင်း၊ သူ့ရဲ့ အနာအပေါ်မှာ ဆီနဲ့ စပျစ်ယေဟို လောင်းချယွေ့ အဝတ်နဲ့ ချေပေးပင်း မိမိရဲ့ တိရစ္ဆာန်ပေါ် တင်ယွေ့ တည်းခိုခန်းဟို ခေါ်သွားယွေ့ ပြုစုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","နောက်တနေ့မှာ သူဟ ငွေဒင်္ဂါးနေပြားဟို ထုတ်ပင်း တည်းခိုခန်း ပိုင်ဆှင်ဟို ပေးအယ်၊ ‘သူ့ဟို ဂရုစိုက်ပါ၊ ဟေလမ်းဟနေပင်း ငါ ပြန်လာသောအခါ သူ့အတွက် ကုန်ကျသမျှဟို ငါပေးမယ်’ လို့ ပြောအယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ယေရှုဟ အချုပ်အားဖြင့် “အေးသုံးယောက်လို့တွင် စသူဟ ထားပြရဲ့ တိုက်ခိုက်ခြင်းနဲ့ တွေ့ရသူရဲ့ အိုင်နီးချင်း ဖြစ်မယ်လို့ နင် ထင်သလဲ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ကျမ်းတတ်ဆရာဟ “သူ့အပေါ်မှာ သနားကြင်နာလဲ့ တယောက် ဖြစ်အယ်” လို့ ပြန်ပြောအယ်။ ယေရှုဟ “နင်သွားယွေ့ အေးပုံစံအတိုင်း လုပ်ပါ” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ယေရှုနဲ့ သူ့ရဲ့ တဘဲ့တော်များဟ သူလို့လမ်းဟို သွားခဲ့ကြပင်းနောက် ရွာတရွာဟို ရောက်ခဲ့ကြအယ်။ အဲရွာမှာ မာသလို့ နာမယ်ခေါ်လဲ့ မိန်းမတယောက်ဟ ယေရှုဟို သူ့နေအိုင်တွင် ကြိုဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","သူမမှာ မာရိလို့ နာမယ်ခေါ်လဲ့ ညီမတယောက် ဆိအယ်၊ သူမဟ သခင်ရဲ့ ခြေထောက်နားမှာ ထိန်ပင်း သူ့ရဲ့ သင်ကြားမှုများဟို နားထောင်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","မာသဟ အလုပ်အားလုံးဟို သူတယောက်တည်း လုပ်နေရသောကျောန့် စိတ်ပျက်ပင်း ယေရှုဆေဟို လာယွေ့ “သခင်၊ ငါ့ရဲ့ ညီမဟ ငါ့တယောက်တည်း အလုပ်လုပ်စေဖို့ ငါ့ဆေဟနေပင်း ပစ်ထားခဲ့တာဟို နင်ဟ ဂရုမစိုက်သလော၊ ငါ့ဟို လာပင်း ကူညီဖို့ ပြောပေးပါ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","သခင်ဟ သူမဟို “မာသ၊ မာသ နင်ဟ ရမ်းဆာ့သောအရာများတွက် စိုးရိမ်ပင်း ဒုက္ခခံလျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","အဲလိုလဲ နင့်မှာ လိုအပ်နေလဲ့အရာတခု ဆိအယ်။ မာရိဟ ကောင်းသောအရာဟို ရွေးချယ်ပီ၊ အေးအရာဟ သူ့ဆေဟ စသူမှ လုယူလို့ မရ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","တနေ့မှာ ယေရှုဟ နေရာတခုတွင် ဆုတောင်း နေအယ်။ သူ ဆုတောင်းပင်းသောအခါ တဘဲ့တော် တယောက်ဟ “သခင်၊ ယောဟန်ဟ တဘဲ့တော်များဟို သင်ကြားပေးသလိုမျိုး ငါလို့ဟို ဆုတောင်းရန် သင်ကြားပေးပါ” လို့ ယေရှုဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ယေရှုဟ သူလို့ဟို “နင်လို့ ဆုတောင်းသောအခါ ဟေလို့ပြောမန့်၊ “ ‘ခေါန်းခင်ဘုံနှိုက် ဆိသော ငါလို့ အဖ၊ ကိုယ်တော်ရဲ့ သန့်ဆှင်းသော နာမတော်ဟို ရိုသေလေးမြတ်ခြင်း ဆိပါစေသော၊ နိုင်ငံတော် တည်ထောင်ပါစေသော။ ");
INSERT INTO dnv_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ငါလို့ နေ့စဉ် လိုအပ်လဲ့ အစားအစာဟို နေ့တိုင်းပေးပါ၊ ");
INSERT INTO dnv_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ငါလို့အား ပစ်မားသောသူဆိသမျှလို့ရဲ့ အပစ်များဟို ငါလို့ လွှတ်သလိုမျိုး ငါလို့ အပစ်များဟို ခွင့်လွှတ်ပါ ငါလို့ဟို ခက်ခဲသော စုံစမ်းခြင်းဟို မခံရပါစေနဲ့’ ဟု မြွက်ဆိုကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ယေရှုဟ သူ့ရဲ့ တဘဲ့တော်များဟို ပြောပင်းနောက် “ညနက်အချိန်နှိုက် တယောက်ဟ မိတ်ဆွေရဲ့ နေအိုင်ဟို သွားတာဆိုပါစို့၊ ‘မိတ်ဆွေ၊ ငါ့ဟို မုန့်သုံးလုံးဟို ငမ်းပါ ဟု ပြောပါ။ ");
INSERT INTO dnv_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ခရီးသွားနေလဲ့ ငါ့ရဲ့ မိတ်ဆွေတယောက်ဟ ငါ့နေအိုင်ဟို ရောက်လာအယ်၊ သူ့ဟို ကျွေးဖို့ ငါ့မှာ ပစာအစားအစာမှ မဆိဝူး။’ ");
INSERT INTO dnv_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","အဲပင်းရင် ‘ငါ့ဟို အနှောက်အယှက်မပေးနဲ့၊ ထင်ခါးဟို ပိတ်ထားပင်းပီ၊ ငါ့လူပဲ့သငယ်များနဲ့ ငါဟ အိပ်ယာထဲဟို ရောက်နေကြပီ။ ငါထပင်း နင့်ဟို ပစာမှ မပေးနိန်ဝူး’ လို့ နင့်မိတ်ဆွေဟ အထဲကနေပင်း ပြန်ပြောတယ်ဆိုပါစို့၊ ");
INSERT INTO dnv_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","အေးလို့ဖြစ်ရင် ပစာလိုလုန်း၊ ငါပြောတာဟ သူဟ မိတ်ဆွေတယောက်ဖြစ်သောကျောန့် ထပင်း မုန့်ဟို ပေးလိမ့်မယ် မဟုတ်၊ အဲလိုလဲ အေးသူဟ ဆှက်ကြောက်မှု မဆိဘဲ ဆက်ပင်း မေးနေသောကျောန့် သူဟ ထပင်း လိုချင်တာဟို ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","အဲကျောန့် နင်လို့အား ငါပြောတာဟ တောင်းပါ တောင်းရင် ရလိမ့်မယ်၊ ဆာပါ ဆာရင် တွေ့လိမ့်မယ်၊ ထင်ခါးဟို ခေါက်ပါ၊ ခေါက်ရင် ထင်ခါး ဖွင့်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","တောင်းသောသူဟ ရလိမ့်မယ်၊ ဆာသောသူဟ တွေ့လိမ့်မယ်၊ ထင်ခါးဟို ခေါက်သောသူလို့ဟ ထင်ခါးဟို ဖွင့်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","နင်လို့တွင် အဖဖြစ်လဲ့သူဟ သူ့ရဲ့ သားဟ ငါးဟို တောင်းရင် မြွေဟို ပေးမယ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ကြက်ဥဟို တောင်းရင် ကင်းမြီးကောက်ဟို ပေးမယ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","နင်လို့ဟ ဆိုးသောသူများဖြစ်သော်လည်း နင်လို့ရဲ့ လူပဲ့သငယ်လို့အား အကောင်းဟို ပေးတတ်ရင်၊ ခေါန်းခင်ပေါ်မှာ ဆိလဲ့ နင်လို့ရဲ့ အဖဟ တောင်းလဲ့အရာများဟို နင်လို့အား သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ပိုပင်း ပေးမယ် မဟုတ်လော” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ယေရှုဟ စကားမပြောနိန်လဲ့ နတ်ဆိုးဟို မောင်းထုတ်ပင်း နတ်ဆိုး ထွက်သွားသောအခါ အေးလူဟ စကားဟို စပင်း ပြောလေအယ်။ လူအုပ်ကြီးဟ အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","အဲလိုလဲ တချို့လူများဟ “နတ်ဆိုးလို့ရဲ့ ခေါင်းဆောင် ဗေလဇေဗုလဟ ပေးထားလဲ့ တန်ခိုးအားဖြင့် ကိုယ်တော်ဟ နတ်ဆိုးလို့ဟို မောင်းထုတ်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","တချို့ဟ ယေရှုဟို ထောင်ချောက်ဆင်ပင်း၊ မိုးခေါန်းခင်ဟ ဖြစ်သော နိမိတ်လက္ခဏာတခုဟို ပြသရန် သူ့ဟို တောင်းဆိုခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ယေရှုဟ သူလို့ စလို တွေးနေကျောန်းဟို သိပေမဲ့လည်း သူလို့ဟို “တိုင်းနိုင်ငံတခုတွင် လူလို့ စိတ်ဝမ်းကွဲပြားပင်း အချင်းချင်း တိုက်ခိုက်နေရင် အဲနိုင်ငံဟ ပျက်စီးခြင်းဟို ရောက်လိမ့်မယ်၊ မိသားစုတခုတွင် စိတ်ဝမ်းကွဲပြားပင်း အချင်းချင်း တိုက်ခိုက်နေရင် အေးမိသားစုဟ ပြိုကွဲလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","အေးကျောန့် စာတန်ရဲ့ နိုင်ငံတွင် အချင်းချင်း တိုက်ခိုက်မှုဆိရင် စလို ရပ်တည်နိန်မလဲ။ ငါ့ဟို ဗေလဇေဗုလဟ ပေးတဲ့ တန်ခိုးများနဲ့ နတ်ဆိုးများဟို မောင်းထုတ်အယ်ဟု နင်လို့ ငါ့ဟို ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ငါဟ ဗေလဇေဗုလဟို အမှီပြုယွေ့ နတ်ဆိုးလို့ဟို မောင်းထုတ်တာ မန်ရင်၊ နင်လို့ရဲ့ နောက်လိုက်များဟ စသူဟို အမှီပြုပင်း မောင်းထုတ်ကြလုန်း။ အေးနင်လို့ရဲ့ နောက်လိုက်များကပင် နင်လို့မားကျောန်း သက်သေပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ငါဟ ဘုရားသခင်ရဲ့ တန်ခိုးတော်အားဖြင့် နတ်ဆိုးလို့ဟို မောင်းထုတ်တာဖြစ်သောကျောန့် ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ တည်လုနီးပီ ဖြစ်ကျောန်းဟို သက်သေပြနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“အားကောင်းလဲ့လူဟ လက်နက်အစုံနဲ့ သူရဲ့ နေအိုင်ဟို စောင့်ကျေ့ဖို့ အဆင်သင့်ဖြစ်နေသောအခါ သူပိုင်လဲ့အရာအားလုံးဟ လုံခြုံမှုဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","အဲလိုလဲ ပိုယွေ့အားကောင်းလဲ့လူဟ သူလို့ဟို တိုက်ခိုက်ပင်း နိန်သောအခါ၊ သူအားကိုး အားထားရလဲ့ လက်နက်များဟို သိမ်းယူပင်း တိုက်ခိုက်ရဆိလဲ့ ဥစ္စာပစ္စည်းများဟို ခွဲဝေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“ငါ့ဖက်မှာ မနေသောသူဟ ငါ့ရန်ဖက် ဖြစ်အယ်၊ ငါနဲ့အတူ မစုဆောင်းလဲ့သူဟ တကွဲတပြားဖြစ်စေသောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ ညစ်ညူးသောနတ်ဟ လူထဲဟ ထွက်ဝါးလဲ့ခါ ခြောက်သွေ့သောနေရာဟို ဝေ့လယ်ယွေ့ နားဖို့နေရာဟို ဆှာတတ်အယ်။ ဆှာယွေ့ မတွေ့လျှင် ‘အရင်နေရာ နေအိုင်ဟောင်းဟို ပြန်တော့မယ်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ပြန်လာသောအခါ အဲနေရာမှာ လှဲကျင်းယွေ့ သန့်ဆှင်းသပ်ရပ်နေတာဟို မျော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","သူ့ထက် သာယွေ့ ညစ်ညူးသောနတ်ဆိုး ခုနေဦးဟို ခေါ်ခဲ့ပင်းရင် အေးနေရာနှိုက် ဝင်နေအယ်။ အဲလိုမို့ နတ်ပူးသူရဲ့ နောက်ဖြစ်လာပုံဟ ဆေ့ဦးဖြစ်ပုံထက် ဆိုးအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ယေရှုဟ ဟေလို့ပြောပင်းသောအခါ လူအုပ်ထဲဟ အမျိုးသမီးတယောက်ဟ “ကိုယ်တော်ဟို မွေးယွေ့ နန်းအုပေးစို့ရသော အမျိုးသမီးဟ မင်္ဂလာဆိပါအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","အဲလိုလဲ ယေရှုဟ “ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ကြားယွေ့ လိုက်နာသောသူလို့ဟ သာယွေ့ မင်္ဂလာဆိကြအယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","လူအုပ်ကြီးဟ စုဆုံလျက်နေတုန်းတွင် ကိုယ်တော်ဟ “ခနေ့ခေတ်လူလို့ဟာ ရမ်းဆာ့ ဆိုးညစ်အယ်။ သူလို့ဟ နိမိတ်လက္ခဏာဟို တောင်းဆိုကြရာတွင် ပရောဖက် ယောနရဲ့ လက္ခဏာတခုမှ လွဲယွေ့ ပစာနိမိတ်လက္ခဏာဟိုမျှ ပြနိန်ဝူးဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ဟေနည်းတိုင်းတိုင်းပင် ယောနဟ နိနေဝေမြို့သားလို့အား နိမိတ်လက္ခဏာဖြစ်သလိုမျိုး ဟေခေတ်လူများလို့အတွက် လူသားဟ နိမိတ်လက္ခဏာ ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","တရားစီရင်သောနေ့နှိုက် ရှေဘပြေဟို အုပ်စိုးသောဘုရင်မဟ ဟေလူမျိုးတဖက်တွင် ထယွေ့ အရှုံးခံစေရလိမ့်မယ်။ ပစာကို့ မိဖုရားဟ ရှောလမုန်မင်းရဲ့ ပညာစကားဟို နားထောင်ရဖို့ မြေကြီးစွန်းမှ လာအယ်။ ဟေနေရာတွင် ရှောလမုန်ထက် သာယွေ့ ကြီးမြတ်သောသူ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","တရားစီရင်သောနေ့နှိုက် နိနေဝေမြို့သားလို့ဟ ဟေလူမျိုးတဖက်တွင် နေယွေ့ အရှုံးခံစေလိမ့်မယ်။ ပစာကို့ သူလို့ဟ ယောန ဟောပြောသော စကားကျောန့် နောင်တရကြအယ်။ ဟေနေရာတွင် ယောနထက် သာယွေ့ ကြီးမြတ်သောသူ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“စသူမျှ မီးဖူးထွန်းပင်း ဖုံးထားလေ့ မဆိ၊ တောင်းဇလားအောက်နှိုက်လည်း မထားတတ်။ ဝင်လာသောသူဟ အလင်းရောင်ရဖို့ မီးတင်ခုံပေါ်မှာ တင်ထားလေ့ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","မျက်စေ့ဟ ကိုယ်ခန္ဓာဖို့ မီးဖူးသဖွယ် ဖြစ်အယ်။ မျက်စေ့ကောင်းရင် နင့်ရဲ့ ခန္ဓာကိုယ်တခုလုံး လင်းလိမ့်မယ်။ မျက်စေ့ မကောင်းရင်တော့ နင့်တကိုယ်လုံးဟ မိုက်နေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","အဲလိုမို့ နင်လို့ဆေတွင် ဆိသော အလင်းဟ အမိုက် မဖြစ်စေရန် သတိထားကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","အကယ်ယွေ့ နင့်တကိုယ်လုံး လင်းနေရင် မီးဖူးရဲ့ အလင်းရောင်နဲ့ လင်းနေစေသလို နင်လို့ ခန္ဓာကိုယ် တခုလုံးဟလည်း အလင်းနဲ့ ပြေ့နေလိမ့်မယ်” ဟု သွန်သင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","အေးလို့ ယေရှု ပြောပင်းသောအခါ ဖာရိရှဲတယောက်ဟ ကိုယ်တော်အား အစာဟို သုံးဆောင်ဖို့ ပင့်ဖိတ်လေအယ်။ ကိုယ်တော်ဟ အေးသူရဲ့ အိုင်သို့ သွားယွေ့ စားပွဲနှိုက် ထိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ယေရှုဟ အစာမစားခင် ဆေးကြောခြင်း မလုပ်တာဟို ဖာရိရှဲဟ မျော်ရင် အံ့ဩလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","အဲလိုမို့ သခင်ဟ “ဖာရိရှဲဖြစ်လဲ့ နင်လို့ဟာ ပန်းကန်၊ ခွက်ယောက်များရဲ့ ပြင်ပဟို သန့်ဆှင်းတတ်ကြအယ်။ အဲလိုလဲ နင်လို့စိတ်ထဲတွင် အကြမ်းဖက်မှု၊ ဆိုးညစ်မှုများနဲ့ ပြေ့နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","လူမိုက်တေ၊ အပြင်ဟို ဖန်ဆင်းသောအဆှင်ဟ အတွင်းဟိုလည်း ဖန်ဆင်းတာ မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","အဲလိုလဲ နင်လို့ရဲ့ ပန်းကန်၊ ခွက်ယောက်များတွင် ဆိလဲ့အရာဟို ဆင်းရဲသူများဟို ပေးကမ်းစွန့်ကြဲလိုက်ကြ။ အေးလို့ပြုလျှင် ပစာညမ်းညမ်း နင်လို့ဖို့ ဖြူစင်စေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ဖာရိရှဲလို့ နင်လို့ဟ အမင်္ဂလာဆိကြအယ်။ နင်လို့ဟ ပင်စိမ်းရွက်၊ လျူရွက်နဲ့ အခြားဆေးဘက်ဝင် အပင်မျိုးစုံဟို ဆယ်ဖို့တဖို့ ပေးလှူကြပေမဲ့ တရားမျှတမှုနဲ့ ဘုရားသခင်ရဲ့ ချစ်ခြင်းဟို လျစ်လျူရှုကြအယ်။ အရင်ဆိုခဲ့လဲ့ အရာများဟို မချန်ထားဘဲ နောက်ဆိုသောအရာလို့ဟို ကျင့်သုံးသင့်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ဖာရိရှဲလို့၊ နင်လို့ဟာ ရမ်းဆာ့ ဆိုးကြအယ်။ နင်လို့ဟ တရားဇရပ်များတွင် မြင့်မြတ်သောနေရာများဟို လည်းကောင်း၊ ဆေးတွင် ရိုသေစွာ နှုတ်ဆက်ခြင်းဟို လည်းကောင်း နှစ်သက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","နင်လို့ဟ ရမ်းဆာ့ ဆိုးကြအယ်။ နင်လို့ဟ အမှတ်သား မဆိလဲ့ လုတ်တိုင်းနဲ့ တူကြဟယ်။ လူလို့ဟ အေးတွင်းများအပေါ် သွားကြသောအခါ လုတ်တိုင်းတွင်း ဖြစ်မှန်းဟို မသိကြ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ကျမ်းတတ်ဆရာတယောက်ဟ “ဆရာ၊ အေးလို့ပြောရင် ငါလို့ဟိုလည်း စော်ကားရာ ရောက်ပါအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ယေရှုဟ “ကျမ်းတတ်ဆရာလို့၊ နင်လို့ဟ ရမ်းဆာ့ဆိုးကြအယ်။ ထမ်းရခက်လဲ့ ဝန်ထုပ်များဟို နင်လို့ဟ လူများဟို ပေးထမ်းကြပင်း ကိုယ့်တတ်တိုင်းကျတော့ အေးဝန်ထုပ်များဟို လက်ဖျားနဲ့တောင် မထိကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","နင်လို့အတွက် စလောက်ကြောက်ဖို့ ကောင်းကျောန်း၊ အကျောန်းမှာ နင်ဖိုးဖေးများ သတ်ဟားလဲ့ ပရောဖက်များအတွက် လုတ်တိုင်းဂူများဟို ဆောက်ပေးနေကြစာရီးမို့ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","နင်လို့ရဲ့ ဖိုးဖေးများ ကျူးလွန်ခဲ့လဲ့ အမှုများတွင် နင်လို့ဟ သက်သေဖြစ်ကြအယ်။ ဖိုးဖေးများဟ ပရောဖက်များဟို သတ်ယွေ့ နင်လို့ဟ လုတ်တိုင်းများဟို ဆောက်ပေးနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","အေးလို့ဖြစ်ခြင်းကျောန့် ဘုရားသခင်ဟ ဉာဏ်တော်ဖြင့် ‘ဟေလူများထဲသို့ ပရောဖက်များ စေတမန်များဟို ငါစေလွှတ်မယ်၊ သူလို့ဟ သူလို့ထဲမှ တချို့ဟို ညှဉ်းဆဲယွေ့ အချို့ဟို သတ်ကြလိမ့်မယ်’ ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","အေးကျောန့် ကမ္ဘာဦးမှစယွေ့ သွန်းပင်းသော ပရောဖက်အပေါင်းလို့ရဲ့ အသွေးကျောန့် အခုဖြစ်သော လူလို့ဟ စစ်ကြောခြင်းဟို ခံရကြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","အာဗေလရဲ့ အသွေးမှစယွေ့ ယဇ်ပလ္လင်အကြားနဲ့ ဗိမာန်တော် အတွင်းပိုင်းမှာ အသတ်ခံရလဲ့ ပရောဖက် ဇာခရိအထိ၊ ကမ္ဘာတည်ချိန်မှစယွေ့ အသတ်ခံခဲ့ရသော ပရောဖက်များရဲ့ အသွေးကျောန့် ဟေခေတ်လူများဟ အပစ်စီရင်ခြင်းဟို ခံရကြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ကျမ်းတတ်ဆရာလို့ နင်လို့ဟ ရမ်းဆာ့ ဆိုးကြအယ်။ နင်လို့ဟ အသိပညာ ထင်ခါးသော့ဟို သိမ်းထားပင်းရင် နင်လို့တတ်တိုင်းလည်း မဝင်၊ ဝင်ချင်သောသူများဟိုလည်း တားဆီးကြအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","အဲနေရာမှ ယေရှု ထွက်လာသောအခါ ကျမ်းတတ်ဆရာများနဲ့ ဖာရိရှဲများဟ ကိုယ်တော်အား ရမ်းဆာ့ ဝေဖန်မှုများဟို စတင် ပြုလုပ်ယွေ့ ကြပ်ကြပ် စစ်မေးလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","နှုတ်တော်ထွက်စကား တစုံတခုတွင် ကိုယ်တော်ဟို အမားဆှာနိန်ရန် ချောင်းမြောင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ထောင်ပေါင်းများစွာသော လူအုပ်ကြီးများလို့ဟ အတူတူစုသောကျောန့် အချင်းချင်း တက်နင်းမိကြအယ်၊ ယေရှုဟ တဘဲ့တော်လို့ဟို ပထမဦးဆုံး “ဖာရိရှဲလို့ရဲ့ တဆေးဟို သတိနဲ့ ဆောင်ကြဟု မိန့်အယ် — ဆိုလိုတာဟ သူလို့ဟ သူတော်ကောင်းယောင်ဆောင်ထားသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ဖုံးထားသော အရာဆိသမျှဟ ပွင့်လာရမယ်၊ လျှို့ဝှက်ထားတဲ့ အရာဟလည်း သိလာရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","အဲလိုမို့ မိုက်တွင် နင်လို့ ပြောလဲ့စကားများဟို သူများလို့ဟ အလင်းနှိုက် ကြားသိရလိမ့်မယ်၊ အိုင်အတွင်းခန်းတွင် နင်လို့ သီးသန့် တိုးတိုးပြောလဲ့စကားဟ နေအိုင်မိုးပေါ်ဟ အော်ပြောရလိမ့်မယ်ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ငါ့မိတ်ဆွေလို့ ငါပြောတာဟ ခန္ဓာကိုယ်ဟို သတ်ပင်း၊ တခြားဆိုးသောအမှုဟို မလုပ်နိန်သော သူလို့ဟို မကြောက်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","စသူ့ဟို ကြောက်ရမလဲဆိုတာ နင်လို့ဟို ငါ ပြောမယ်၊ ဘုရားသခင်ဟို ကြောက်ရွံ့ကြလော့၊ ကိုယ်ခန္ဓာဟို သတ်ပင်းနောက် ငရဲထဲဟို ချနိန်လဲ့ အခွင့်အာဏာဆိသော သူ့ဟို ကြောက်ကြလော့။ ငါအမန်ဆိုတာဟ အဲအဆှင်ဟို ကြောက်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“စိန်စာငက် ငါးကောင်ဟို ပဲနိနေပြားနဲ့ ဝယ်ရတာ မဟုတ်လော၊ စိန်စာငက် တကောင်တောင် ဘုရားသခင်ဟ မမေ့ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","နင်လို့ ဦးခေါင်းပေါ်ဟ ဆံပင်လို့ဟို အကုန်လုံး ရေတွက်ထားအယ်။ အဲကျောန့် နင်လို့ မကြောက်ကြနဲ့၊ နင်လို့ဟ စိန်စာငက်များလို့ထက် ပိုပင်း မြတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“နင်လို့ဟို ငါဆိုတာဟ သူလို့ဟို ငါပိုင်ကျောန်း လူများလို့ဆေ့မှာ ဝန်ခံလဲ့သူဟို လူသားဟလည်း ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန်များ ဆေ့တွင် အဲတိုင်းတိုင်း ငါ ဝန်ခံမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","အဲလိုလဲ လူများလို့ဆေ့မှာ ငါ့ဟို ငြင်းပယ်ရင် လူသားဟလည်း ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန်များဆေ့မှာ သူလို့ဟို ငါ ငြင်းပယ်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“လူသားဟို နှုတ်နဲ့ ပစ်မားသောသူရဲ့ အပစ်ဟို ခွင့်လွှတ်နိန်အယ်။ အဲလိုလဲ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို နှုတ်နဲ့ ပစ်မားသောသူရဲ့ အပစ်ဟိုတော့ ခွင့်လွှတ်နိန်မောင့်လဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“သူလို့ဟ နင်လို့ဟို တရားဇရပ်များ၊ အုပ်ချုပ်သူများနဲ့ အာဏာပိုင်များဆေ့ဟို ခေါ်ဆောင်သွားကြသောအခါ ကိုယ့်တတ်တိုင်းဟို စလို ချေပပြောရမယ်ဆိုတာဟို မစိုးရိမ်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","အေးအချိန်နှိုက် သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ စလို ပြောရမယ်ဆိုတာ နင်လို့ဟို သင်ကြားပေးလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","လူအုပ်ကြီးထဲမှ လူတယောက်ဟ “ဆရာ၊ ငါလို့အဖ ထားခဲ့လဲ့ ပစ္စည်းတွေဟို ခွဲဝေပေးရန် ငါရဲ့ ကိုရင်ဖြစ်သူဟို ပြောပေးပါ” လို့ ယေရှုဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ယေရှုဟ “အချင်းလူ၊ ဖယ်သူဟ ငါ့ဟို မန်ကန်တဲ့ တရားသူကြီးအဖြစ် လည်းကောင်း၊ နင်လို့ကြားမှာ ပစ္စည်းဥစ္စာများဟို ခွဲဝေပိုင်သောအခွင့်ဟို လည်းကောင်း၊ ငါ့အား အပ်ပေးလုန်း” ဟု သူ့အား ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","အေးသူဟ သူလို့အားလုံးဟို “လောဘအမျိုးမျိုးဟို သတိနဲ့ဆောင်ကြလော့၊ ပစာကို့ စလောက်ပဲ ချမ်းသာပါစေ၊ နင့်ရဲ့ စစ်မန်လဲ့ ဖဝါ့ဟာ နင်ပိုင်ဆိုင်ထားလဲ့ အရာတွေအပေါ်မှာ မတည်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","အေးနောက် ယေရှုဟ ပုံဥပမာနဲ့ တဘဲ့တော်များလို့ဟို “ချမ်းသာလဲ့ လူတဦးနှိုက် မြေကောင်းယွေ့ အသီးအနှံများ ထွက်သော လယ်တကွက်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","သူဟ ‘ငါ့သီးနှံများဟို သိမ်းထားမဲ့နေရာ မဆိတော့ဝူး၊ ငါ ဖယ်လိုလုပ်ရမလဲ’ ဟု စတင်ပင်း ကိုယ့်တတ်တိုင်းဟို စဉ်းစားလာအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ငါ ဟေလိုလုပ်မယ်၊ ‘ငါ့ကျီများဟို ဖြိုဖျက်ပင်းရင် ပိုကြီးလဲ့ဟာကို တည်ဆောက်မယ်၊ ငါရဲ့ စပါးနဲ့ တခြား ပစ္စည်းများဟို သိုထားမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","အေးနောက် ငါဟ ကံကောင်းလဲ့လူလို့ ငါ့ဝိညာဉ်အား ငါပြောမယ်၊ နင်ဟ နှစ်ပေါင်းများစွာ သုံးဆောင်ရန် ဥစ္စာပစ္စည်းများဟို သိုမှီးထားလျက် ဆိအယ်၊ ဖဝါ့ဟို အေးဆေးဖြတ်သန်းပါ၊ စားလော့၊ သောက်လော့၊ ပျော်မွေ့ခြင်း ပြုလော့’ ဟု ကိုယ့်တတ်တိုင်း ငါပြောမယ်ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","အဲလိုလဲ ဘုရားသခင်ဟ ‘မိုက်မဲလဲ့ လူ၊ ခုနေ့ညမှာ နင်ရဲ့ အသက်ဝိညာဉ်ဟို စွန့်ရမယ်၊ အေးဖြစ်ယွေ့ နင်သိုထားလဲ့ ဥစ္စာဟို စသူ ပိုင်မယ်လော’ ဟု အေးလူအား မိန့်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ယေရှုဟ နိဂုံးချုပ်အနေနဲ့ “မိမိလို့အဖို့ စည်းစိမ်များဟို သိုမှီးထားသော်လည်း အဲသူဌေးဟ ဘုရားသခင်ရဲ့ ဆေ့တွင် ဆင်းရဲသောသူ ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","အေးနောက် ယေရှုဟ တဘဲ့တော်လို့ဟို “အေးကျောန့် အသက်ဆှင် နေထိန်ဖို့ လိုအပ်လဲ့ အစားအစာအတွက် စိတ်မပူကြနဲ့၊ နင်လို့ ခန္ဓာကိုယ်မှာ လိုအပ်လဲ့ အဝတ်အစားအတွက် စိတ်မပူကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","အစားစာထက် အသက်ဟ ပိုပင်း အရေးကြီးအယ်၊ အဝတ်အစားထက် ခန္ဓာကိုယ်ဟ ပိုပင်း မြတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ကျီးကန်းများဟို ကျေ့လော့၊ သူလို့ဟ မျိုးစေ့ဟို မကြဲ၊ အသီးနှံများဟို မရိတ်မသိမ်း၊ သူလို့မှာ လှောင်စရာ အခန်းများ၊ ကျီများ မဆိ၊ ဘုရားသခင်ဟ သူလို့ဟို ကျွေးမွေးအယ်၊ ငက်များထက် နင်လို့ဟ ရမ်းဆာ့ အဖိုးထိုက်အယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","နင်လို့တွင် စသူဟ ပူပန်ခြင်းအားဖြင့် မိမိရဲ့ အသက်ဟို နှစ်အနည်းမှ ပိုပင်း ရှည်စေနိန်သလော။ ");
INSERT INTO dnv_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","သေးလဲ့အမှုဟို စီမံခန့်ခွဲမှု မလုပ်နိန်ရင် ပစာကျောန့် အခြားအကျောန်းအတွက် ပူပန်ကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","တောနှင်းပန်းများဟ စလို ကြီးထွားအယ်ဟို ကျေ့လော့၊ သူလို့ဟ အလုပ် မလုပ်၊ အဝတ်ဖြစ်ဖို့ သူလို့တတ်တိုင်း မလုပ်ကြ။ အဲလိုလဲ ငါဆိုတာဟ ဘုန်းကြီးသော ရှောလမုန်မင်းကြီးရဲ့ အဝတ်ဟ ဟေတောနှင်းပင် တပင်ရဲ့ အလှဟို မမီဝူးဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ယုံကြည်အားနည်းသောသူလို့ ခုနေ့တွင် ဆိယွေ့ နက်ခါ မီးဖိုထဲဟို ရောက်ရသော တောမြက်ပင်ဟို ဘုရားသခင်ဟ အေးလို့အဝတ်နဲ့ ဖုံးအုပ်ရင်၊ နင်လို့အား အေးထက်မက ဝတ်ဆင်ပေးမယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“အားကျောန့် စိတ်မပျက်နဲ့၊ ဖယ်လို စားရမယ် သောက်ရမယ်ဆိုတာဟို စိတ်မပူကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","လောကမှာဆိလဲ့ မယုံကြည်သူလို့ဟ အေးအရာအားလုံးအတွက် အမြဲတမ်း စိုးရိမ်ကြအယ်။ နင်လို့ရဲ့ အဖဟ အေးအရာများဟို နင်လို့ အသုံးလိုကျောန်း သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","နင်လို့ဟ သူ့ရဲ့ နိုင်ငံတော်ဟို ဆှာကြလော့၊ နောက်မှ အေးအရာများဟိုလည်း နင်လို့အား ထောက်ပံ့ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“သိုးစုသငယ်၊ မကြောက်ကြနဲ့၊ နင်လို့ရဲ့ အဖဟ နင်လို့အား နိုင်ငံတော်ဟို ပေးရန် အလိုတော်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","နင်လို့ ပိုင်ဆိုင်သမျှဟို ရောင်းချပင်း ဆင်းရဲသောသူလို့အား ပိတ်ဆန်ဟို ပေးကြလော့။ မဟောင်းနွမ်းနိန်သော ပိတ်ဆန်အိတ်လို့ဟို ကိုယ့်အဖို့ ပြင်ဆင်ကြလော့။ ပစာခါမှ မပျက်စီးနိန် မလျော့သွားတဲ့ ခေါန်းခင်နိုင်ငံမှာ နင်လို့ရဲ့ ဘဏ္ဍာဟို သိမ်းထားကြလော့။ ပစာကို့ အေးအရာများဟို သူခိုးလို့ဟ မရနိန်၊ အဲဒီအရာဟို ပိုးရွလို့ မဖျက်စီးနိန်သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","နင်လို့ရဲ့ ဘဏ္ဍာဆိရာဟို နင်လို့ စိတ်နေလုံး ရောက်တတ်သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ပစာဖြစ်ဖြစ် အဆင်သင့်လာဖို့ ဝတ်စုံများဟို ဝတ်ဆင်လျက် မီးဖူးများဟို နင်လို့နဲ့အတူ ထွန်းထားကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","မင်္ဂလာဆောင်ပွဲမှ ပြန်လာသော မိမိလို့ရဲ့ သခင်ဟို စောင့်နေသော အစေခံကျွန်လိုမျိုး ဖြစ်ကြလော့။ အဲသူလို့ဟ သခင် ပြန်လာပင်း ထင်ခါးဟို ခေါက်ရင် ခုတုံး ထင်ခါးဟို ဖွင့်ပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","အေးအစေခံလို့ဟ စောင့်နေကြတာဟို သခင်ဟ ပြန်လာယွေ့ မျော်အယ်။ အေးအစေခံလို့ဟ မင်္ဂလာဆိအယ်၊ နင်လို့အား ငါ အမန်ဆိုတာဟ သခင်ဟ လုပ်ကျွေးဖို့ရန် သူရဲ့ ဝတ်စုံဟို ဝတ်ဆင်ယွေ့ အစေခံလို့အား ထိန်ဖို့ ပြောပင်း လုပ်ကျွေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ညနက်ချိန် ဖြစ်စေ၊ မိုးသောက်ယံနှိုက် ဖြစ်စေ၊ သခင်ဟ လာယွေ့ အေးလို့ အဆင်သင့် ပြင်ဆင်ထားတာဟို တွေ့ရင် အေးကျွန်လို့ဟ မင်္ဂလာဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","တကယ်လို့ အိုင်ပိုင်ဆှင်ဟ သူခိုးလာမဲ့အချိန်ဟို သိရရင် မိမိရဲ့ နေအိုင်ဟို သူခိုးအား ဖောက်ခွင့်ပြုမှာ ဟုတ်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","အဲကျောန့် နင်လို့ဟ အေးတိုင်းတိုင်း အဆင်သင့် ဖြစ်နေရမယ်၊ ပစာကို့ နင်လို့ မထင်မှတ်ထားလဲ့ အချိန်နှိုက် လူသားဟ ကြွလာလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ပေတရုဟ “သခင်၊ အေးပုံဥပမာဟ ငါလို့အတွက်လော အဲဟာမဟုတ်ရင် အားလုံးအတွက် ဆိုလိုသလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","သခင်ဟ “သူ့သခင်ဟ တခြား အစေခံများနဲ့ အိုင်သူအိုင်သားလို့ဟို အုပ်ချုပ်ရန်နဲ့ အချိန်တန်ရင် အစားအသောက်များ ထုတ်ပေးရန် ခန့်ထားသော သစ္စာဆိပင်း ပညာဆိလဲ့ အစေခံဟ စသူလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","အေးကျွန်လုပ်နေတာဟို သခင်ဟ ပြန်လာပင်း မျော်ခဲ့ရင် အေးကျွန်ဟ စလောက် မင်္ဂလာဆိလိုက်မလဲ။ ");
INSERT INTO dnv_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","နင်လို့အား ငါ အမန်ဆိုတာဟ သခင်ဟ မိမိဥစ္စာဆိသမျှ အားလုံးဟို စီမံအုပ်ချုပ်ရန် အေးအစေခံဟို အပ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","အဲလိုလဲ အစေခံဟ ငါ့သခင် ပြန်လာဖို့ ကြာအုံးမယ်လို့ စိတ်ထဲမှာ အောက်မေ့ပင်း အစေခံ ယောက်ျားနဲ့ အစေခံ မိန်းမလို့အား ရိုက်နှက်ပင်း သောက်စား ယစ်မူးလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","အစေခံ မသိလဲ့ နေ့၊ မမျော်လင့်လဲ့ အချိန်နှိုက် သခင် ပြန်လာပင်း သူ့ဟို အပိုင်းပိုင်း ခုတ်ဖြတ်ရန် ပြုလုပ်ယွေ့ ယုံကြည်ခြင်း ကင်းမဲ့သူလို့ ခံစားရမဲ့ ကံကြမ္မာဟို ခံစားစေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“အစေခံဟ သခင်ရဲ့ လိုချင်တဲ့အရာဟို သိလျက်နဲ့ သူ့တတ်တိုင်း အဆင်သင့် မလုပ်လဲ့ အစေခံဟ ပြင်းထန်လဲ့ ကြိမ်ဒဏ်များစွာဟို ခံရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","အဲလိုလဲ အစေခံဟ သခင် ပစာ လိုချင်အယ်ဆိုတာဟို မသိဘဲ၊ တခုခုဟို လုပ်မိရင် ကြိမ်ဒဏ်နည်းနည်းပဲ ခံရအယ်။ များစွာ ရဆိထားသောသူအားလုံးဆေမှ များစွာ တောင်းဆိုလိမ့်မယ်၊ များစွာ အပ်နှံထားသောသူဆေမှ ပိုပင်း များစွာ တောင်းကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ငါဟ မြေကြီးပေါ်ဟို မီးလောင်စေရန် လာအယ်၊ အခု လောင်စေရန် ငါ အလိုဆိပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ငါလက်ခံရမဲ့ နှစ်ခြင်း ဆိအယ်၊ အေးအရာဟို မကျော်လွန်မချင်း ငါဟ စိတ်ဒုက္ခရောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ငါဟ ဟေလောကဟို ငြိမ်းချမ်းစေရန် လာတာလို့ ထင်ကြသလော။ မဟုတ်ပါ၊ အချင်းချင်း ကွဲပြားစေရန် ငါ လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","အခုမှစပင်း လူငါးယောက်ဆိလဲ့ မိသားစုတွင် နေယောက် တစု၊ သုံးယောက် တစုစီ အချင်းချင်း တိုက်ခိုက် ကွဲပြားကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","အဖဟ သားများလို့ဟို ရန်ဖက်ပြုလိမ့်မယ်၊ သားများဟ အဖလို့ဟို ရန်ဖက်ပြုလိမ့်မယ်၊ အမေ့ဟ သမီးများလို့ဟို ရန်ဖက်ပြုလိမ့်မယ်၊ သမီးများဟ အမေ့လို့ဟို ရန်ဖက်ပြုလိမ့်မယ်၊ ယောက္ခမလို့ဟ ချွေးမလို့ဟို ရန်ဖက်ပြုလိမ့်မယ်၊ ချွေးမလို့ဟ ယောက္ခမလို့ဟို ရန်ဖက်ပြုလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ယေရှုဟ လူလို့ဟို “အနောက်အရပ်တွင် မိုးချေးသားလာတာဟို နင်လို့ မျော်သောအခါ၊ မိုးရွာလိမ့်မယ်လို့ နင်လို့ ခုတုံး ပြောတတ်ကြအယ်၊ နင်လို့ပြောလဲ့အတိုင်းလည်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","တောင်ဖက်ဟ လေတိုက်လာအယ်ဟို နင်လို့ ခံစားရသောအခါ နင်လို့ဟ နေပူလိမ့်မယ်လို့ ပြောတတ်ကြအယ်၊ ပြောလဲ့အတိုင်းလည်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","သူတော်ကောင်းဟန်ဆောင်သူလို့၊ နင်လို့ဟ မြေကြီးနဲ့ မိုးခေါန်းခင်ဟို ကျေ့ပင်း ရာသီဥတုရဲ့ အခြေအနေဟို ပိုင်းခြားနိန်ပါလျက်နဲ့ ဟေအချိန်ကာလရဲ့ ဆိုလိုရင်းဟို ပစာကျောန့် နင်လို့ မပိုင်းခြားနိန်လုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“မန်ကန်လဲ့အရာဟို ပစာကျောန့် နင်လို့တတ်တိုင်း မဆုံးဖြတ်ကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","တစုံတယောက်ဟ နင့်ဟို တရားစွဲပင်း တရားရုံးဟို ခေါ်လာရင်၊ တရားရုံးဟို မရောက်ခင် လမ်းနှိုက် သူနဲ့ ကျေအေးအောန် အတတ်နိန်ဆုံး ကြိုးစားလော့။ အေးလို့မလုပ်ရင်၊ နင့်ဟို တရားသူကြီးဆေ့ဟို ဆွဲခေါ်ခံရပင်း နင့်ဟို ရဲတွေဆေ လွှဲပြောင်းပေးမယ့် နင့်ဟို ထောင်ချထားလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","နင်လို့ဟို ငါဆိုတာဟ၊ အကြွေး အကုန်ပြန်မဆပ်မချင်း နင်ဟ အဲနေရာမှာဘဲ နေရလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","အဲအချိန်တွင် လူတချို့လို့ဟ ယေရှုဆေဟို လာယွေ့ ယဇ်ပူဇော်နေတုန်း ပိလတ်မင်း သတ်ပလိုက်လဲ့ ဂါလိလဲပြေဟ လူလို့အကျောန်း ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ယေရှုဟ “အဲဂါလိလဲ လူလို့ဟာ အေးလို့မျိုး အသတ်ခံရအယ် ဆိုပင်း တခြားသော ဂါလိလဲပြေသားလို့ထက် ပိုပင်း အပစ်ဆိသူများဟု ထင်နေကြလော။ ");
INSERT INTO dnv_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ဟုတ်မောင့်လဲ့ နင်လို့ဟို ငါပြောတာဟ နင်လို့အားလုံးဟလည်း နောင်တမရရင် အဲတိုင်းတိုင်း သေကြေပျက်စီးရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ရှိလောင်မြို့ရိုး ပြိုကျသောအခါ အသတ်ခံရသော လူတဆယ့်ဆစ်ယောက်ဟ ယေရုရှလင်မြို့နှိုက် နေထိန်သော အခြားသူများထက် သူလို့ဟ သာယွေ့ အပစ်ဆိကျောန်း သက်သေထူအယ်ဟု နင်လို့ ထင်ကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ဟုတ်မောင့်လဲ့ နင်လို့ဟို ငါပြောတာဟ နင်လို့အားလုံးဟလည်း နောင်တမရရင် အဲတိုင်းတိုင်း သေကြေပျက်စီးကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","တခါ ယေရှုဟ ပုံဥပမာဖြင့် ထပ်ပြောပုံမှာ “လူတယောက်ရဲ့ စပျစ်ဥယျာဉ်ထဲတွင် စိုက်ပျိုးထားလဲ့ သင်္ဘောသဖန်းပင် တပင်ဆိအယ်။ သူဟ သင်္ဘောသဖန်းသီးဟို ဆှာသော်လည်း မတွေ့ရချေ။ ");
INSERT INTO dnv_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","အဲလိုမို့ ဥယျာဉ်စောင့်ဟို ‘ကျေ့မန့်၊ ငါ ဟေအပင်နား လာပင်း သင်္ဘောသဖန်းပင်ဟ အသီးဆှာဟာ သုံးနှစ်ဆိဝါးပီ၊ ပစာအသီးမှ မမျော်ရ။ ခုတ်လောပလိုက်၊ ပစာကျောန့် မြေဟို အလကားကား ဖြစ်စေမလုန်း’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ဥယျာဉ်စောင့်ဟ ‘ဆရာ၊ ဟေအပင်ဟို တနှစ် ထားပေးအုံးမန့်၊ အပင်ပတ်လည်ဟို ငါ လိုက်ဆွပင်း မြေဩဇာအချို့ ဖို့ပါမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","နောက်နှစ်ခါ အသီး ပိုထွက်ချင် ထွက်ပါလိမ့်မယ်။ အေးလို့မဟုတ်ရင် ခုတ်လောပလိုက်မန့်’ ဟု ပြန်ဆှောက်အယ် ” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ဥပုသ်နေ့ တနေ့မှာ ယေရှုဟ တရားဇရပ်တခုတွင် ဟောပြောသွန်သင်နေအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ဆယ့်ဆစ်နှစ်လုံး နတ်ဆိုးဝင်ပူးသဖြင့် မသန်စွမ်းဖြစ်လျက်နေသော အမျိုးသမီးတယောက် ဆိအယ်။ သူဟ ကျောကုန်းငိုင်းကျယွေ့ ခါးလုံးလုံး မဆန့်နိန်ချေ။ ");
INSERT INTO dnv_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ယေရှုဟ အေးအမျိုးသမီးဟို မျော်သောအခါ သူ့ဆေ့ဟို ခေါ်ယွေ့ “အမျိုးသမီး၊ နင့်ရဲ့ အနာရောဂါဟနေ လွတ်ပီ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ကိုယ်တော်ဟ အေးအမျိုးသမီးအပေါ် လက်တင်လိုက်သောအခါ ခုတုံးပင် သူ့ခါးဟ တန်းဆန့်သွားယွေ့ ဘုရားသခင်ဟို ချီးမွန်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ဥပုသ်နေ့တွင် ယေရှုဟ အနာရောဂါပျောက်စေလို့ ဆိုပင်း တရားဇရပ်အုပ်ချုပ်ရေးမှူးဟ စိတ်တိုပင်းလျှင် “ငါလို့မှာ အလုပ်လုပ်သင့်လဲ့နေ့ ခြောက်ရက် ဆိအယ်၊ အဲလိုမို့ ဟေဥပုသ်နေ့မှာတော့ အနာရောဂါငြိမ်းခြင်းဟို လာမလုပ်ကြပါနဲ့” ဟု လူလို့အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ကိုယ်တော်ဟ “သူတော်ကောင်းဟန်ဆောင်သူလို့ နင်လို့တွေဟ ဥပုသ်နေ့မှာ နင်လို့ရဲ့ မြည်းများ၊ နွားများအား တဲကုပ်မှ ကြိုးဟို ဖြေပင်း ယေသွားတိုက်တတ်ကြအယ် ဟုတ်ဝူးလော။ ");
INSERT INTO dnv_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","တဆယ့်ဆစ်နှစ်လုံးလုံး စာတန်ရဲ့ တုပ်ချေခံရသော အာဗြဟံရဲ့ သမီးဖြစ်လဲ့ ဟေအမျိုးသမီးဟို ဥပုသ်နေ့မှာ အေးအနှောင်အဖွဲ့ဟ လွတ်ငြိမ်းခွင့် ပေးသင့်ဝူးလော” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","အေးလို့ ပြောလိုက်သောအခါ ကိုယ်တော်ဟို ဆန့်ကျင်လိုသူများဟ အဆက်ကွဲ ကုန်ကြယွေ့၊ လူအပေါင်းလို့ဟ ကိုယ်တော် ပြုလုပ်လဲ့ အံ့ဩဖွယ် အမှုအားလုံးလို့အတွက် ဝမ်းမြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ယေရှုဟ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟာ ပစာနဲ့ တူလဲ၊ ပစာလိုဟာမျိုးနဲ့ နှိုင်းယှဉ်ပြရမလဲ။ ");
INSERT INTO dnv_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ဟေလို့မျိုးနှင်း။ လူတယောက်ဟ မုန်ညင်းစေ့ဟို ယူယွေ့ မိမိဥယျာဉ်ထဲတွင် စိုက်အယ်။ အေးအပင် ကြီးထွားလာသောအခါ အဲအပင်ရဲ့ အကိုင်းအခက်များတွင် ခေါန်းခင်ဟ ငက်များလည်း လာနားနေကြအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","နောက်တခါ ယေရှုဟ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို ပစာလိုဟာနဲ့ နှိုင်းယှဉ်ပြရမလဲ။ ");
INSERT INTO dnv_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","မိန်းမတယောက်ဟ တဆေးဟို ယူယွေ့ မုန့်ညက်တချပ်နဲ့ ရောကာ မုန့်ညက်အားလုံးဟို ဖောင်းပွလာစေတတ်သော တဆေးနဲ့ တူအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","အဲပင်းရင် ယေရှုဟ မြို့ရွာလို့ဟို လှည့်လည်ယွေ့ လူလို့ဟို သွန်သင်ပေးလျက် ယေရုရှလင်မြို့သို့ ကြွလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","လူတယောက်ဟ “ဆရာ၊ ကယ်တင်ခြင်း ခံရသူ ကတစ်သာ ဆိသလား” ဟု မေးအယ်။ ကိုယ်တော်ဟ သူလို့အား ");
INSERT INTO dnv_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ကျဉ်းသော ထင်ခါးပေါက်ဟို ဝင်ရဖို့ နင်လို့ အကောင်းဆုံး ကြိုးစားကြလော့၊ ပစာကို့ လူများစွာဟ ကြိုးစားကြလိမ့်မယ်၊ အဲလိုလဲ ဝင်နိန်ကြဝူးလို့ နင်လို့အား ငါ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","အိုင်ဆှင်ဟ ထင်ခါးပေါက်ဟို ထပိတ်လိုက်ယွေ့ နင်လို့ဟ နေအိုင်ပြင်မှာ ရပ်ပင်း ထင်ခါး ခေါက်နေရလဲ့ အဖြစ်နဲ့ ကြုံရပုံမျိုး ဖြစ်ယွေ့၊ ဆရာ ထင်ခါးပေါက် ဖွင့်ပေးအုံးလို့ ပြောပေမယ့် အိုင်ဆှင်ဟ ‘နင်လို့ ပစာနားဟ လာအယ် ငါလဲ မသိ’ ဟု ပြောလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","အဲအခါ နင်လို့ဟ ‘ငါလို့ဟ ဆရာနဲ့အတူတူ စားသောက်ခဲ့ဖူးဝဲ့၊ ငါလို့ မြို့မှာလဲ ကိုယ်တော် သွန်သင်ပေးခဲ့အယ်’ ဟု ပြန်ပြောလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","အဲလိုလဲ အိုင်ဆှင်ဟ ‘နင်လို့ ပစာနားဟ လာအယ်ဟို ငါ မသိ။ ဆိုးညစ်တဲ့လူတွေ အဝေးဟို ထွက်သွားကြ’ ဆိုပင်း ပြန်ပြောလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","အဲအခါ အာဗြဟံ၊ ဣဇက်၊ ယာကုပ်နဲ့ ပရောဖက်အများဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ထဲဟို ဆိကြတာဟို နင်လို့ မျော်ရပေမဲ့ နင်လို့တတ်တိုင်းဟ အပြင်သို့ နှင်ထုတ်ခံရသဖြင့် စလောက် ငိုကခြင်းနဲ့ အံကြိတ်ခြင်း ဆိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","လူများဟ အဆေ့၊ အနောက်၊ တောင်နဲ့ မြောက် အရပ်လေးမျက်နှာမှ လာယွေ့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်တွင် ပွဲဝင်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","အဲအခါ အခု နောက်ဆုံးဟို ရောက်ဆိနေသူလို့ဟ ဆေ့ဆုံးဟို ရောက်ကြပင်းရင်၊ အခု ဆေ့ဆုံးဟို ရောက်ဆိနေသူလို့မှာ နောက်ဆုံးသို့ ရောက်ရကြလိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","အဲအချိန်တွင် ဖာရိရှဲအချို့လို့ဟ ယေရှုဆေဟို လာပင်းရင် “ဟေအရပ်မှ အခြားနေရာဟို ပြောင်းသွားပါ၊ ဟေရုဒ်မင်းဟ ကိုယ်တော်ဟို သတ်ဖို့ ကြံနေအယ်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ယေရှုဟ “သွားယွေ့ အေးမြေခွေးဟို သွားပြောချေ။ သူလို့အား ‘ငါဟ ခုနေ့နဲ့ မနက်ခါကျရင် နတ်ဆိုးလို့ဟို မောင်းထုတ်ပင်း ရောဂါများဟို ငြိမ်းစေမယ်၊ တတိယနေ့မှာတော့ ငါ့အလုပ်ဟို အဆုံးသတ်မယ်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","အဲလိုလဲ ခုနေ့နဲ့ မနက်ခါ၊ သောင်ဖက်နေ့နှိုက် ငါ ခရီးပြုရအုံးမယ်၊ ပရောဖက်ဟ ယေရုရှလင်မြို့မှ လွဲပင်း ပစာနေရာမှာမှ အသတ်ခံရဖို့ မသင့်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“အို ယေရုရှလင်၊ ယေရုရှလင်၊ ပရောဖက်လို့ဟို သတ်ယွေ့ ဘုရားသခင် စေလွှတ်တဲ့သူတွေဟို ကျောက်ခဲတုံးနဲ့ သတ်လဲ့မြို့၊ ကြက်မဟ မိမိရဲ့ ကြက်သငယ်များဟို တောင်ပံထဲတွင် အုပ်ထားသလိုမျိုး နင်ရဲ့ အောင်နီငယ်တွေဟို စုရုံးစေဖို့ ကြိမ်ဖန်များစွာ ငါ အလိုဆိအယ်။ နင်ဟတော့ အလိုမဆိဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ကျေ့လော့၊ နင့်ရဲ့ နေအိုင်ဟ နင်လို့ဆေဟို စွန့်ပစ်ထားခြင်း ခံရမယ်။ နင်လို့ဟို ငါ ပြောတာဟ ‘သခင်ဘုရားရဲ့ နာမတော်အားဖြင့် ကြွလာသောသူဟ မင်္ဂလာဆိအယ်’ ဟု နင် မြွတ်ဆိုရာ နေ့မတိုင်မီ နင်ဟ ငါ့ဟို မတွေ့မမျော်ရ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ဥပုသ်နေ့ တနေ့တွင် ယေရှုဟ အစားစာသုံးဆောင်ရန် ဖာရိရှဲ ခေါင်းဆောင်တဦး နေအိုင်ဟို ဝင်လေအယ်၊ လူလို့ဟ ယေရှုဟို စောင့်ကျေ့နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ရေဖျဉ်းနာစွဲသော သူတယောက်ဟ ယေရှုရဲ့ ဆေ့တွင် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ယေရှုဟ “ငါလို့ ဥပဒေအရ ဥပုသ်နေ့တွင် အနာရောဂါ ငြိမ်းစေသင့်ဝူးလော” ဟု ကျမ်းတတ်ဆရာများနဲ့ ဖာရိရှဲလို့ဟို မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","အဲလိုလဲ သူလို့ဟ တိတ်ဆိတ်စွာ နေကြအယ်။ ယေရှုဟ အေးလူဟို ခေါ်ယွေ့၊ အနာရောဂါဟို ပျောက်ကင်းစေပင်းရင် သူ့အား လွှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","အဲပင်းရင် သူလို့အား “နင်လို့ရဲ့ လူပဲ့ဖြစ်ဖြစ်၊ နွားဖြစ်ဖြစ်၊ ဥပုသ်နေ့မှာ ယေတွင်းထဲ ပြုတ်ကျခဲ့ရင် တခါထဲ မဆွဲတင်ဘဲ နေမဲ့သူ တစုံတယောက် နင်လို့မှာ ဆိသလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","အဲလိုလဲ အဲအကျောန်းအရာဟို သူလို့ဟ ကိုယ်တော်အား မဖြေနိန်ကြဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","အဲအခါ ဖိတ်ခေါ်ခြင်း ခံရသောသူလို့ဟ နေရာကောင်းများ ရွေးချယ်နေကြပုံဟို ကိုယ်တော် မျော်သောအခါ အေးသူလို့အား ပုံဥပမာတခုဖြင့် ပြောဆိုအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“တစုံတယောက်ဟ နင့်ဟို မင်္ဂလာဆောင်ပွဲသို့ ဖိတ်ကြားသောအခါ နေရာကောင်းနှိုက် မထိန်ပါနဲ့။ သူဟ နင့်ထက် အရေးကြီးသောသူအား ဖိတ်ကောင်း ဖိတ်ထားနိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","အဲအခါ နင်လို့ နေဦးလုံးဟို ဖိတ်ခေါ်ထားသောသူဟ နင့်ဆေဟို လာပင်း ‘နင့်နေရာဟို ဟေသူအား ပေးလိုက်မန့်’ ဟု ဆိုလာရင် နင်ဟ အဆက်ရလျက် နိမ့်သောနေရာဟို ယူရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","အဲလိုလဲ ဖိတ်ကြားခြင်းခံရသောအခါ နိမ့်သောနေရာနှိုက် ထိန်လော့၊ အဲအခါ ဖိတ်ခေါ်ထားသောသူဟ လာယွေ့ ‘မိတ်ဆွေ ကောင်းသောနေရာသို့ လာမန့်’ ဟု နင့်အား ခေါ်လိမ့်မယ်။ အဲအခါ နင်ဟ တခြား ဧည့်သည်များ ဆေ့တွင် မျက်နှာရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","အကျောန်းမှာ ကိုယ့်တတ်တိုင်းကိုယ် ချီးမြှောက်သူတိုင်းဟ နှိမ့်ချခြင်းဟို ခံရလိမ့်မယ်၊ ကိုယ့်တတ်တိုင်းကိုယ် နှိမ့်ချသောသူဟ ချီးမြှောက်ခြင်းဟို ခံရလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","အဲပင်းရင် ယေရှုဟ သူ့အိုင်ဆှင်အား “နင်ဟ နေ့လယ်စာဖြစ်ဖြစ်၊ ညခင်းစာဖြစ်ဖြစ်၊ ဖိတ်သောအခါ မိတ်ဆွေများ၊ ညီအကိုများ၊ ဆွေမျိုးများ၊ ချမ်းသာသော အိုင်နီးနားချင်းများဟို မဖိတ်ခေါ်နဲ့၊ အေးလို့ဖိတ်လျှင် သူလို့ဟ နင့်ဟို ပြန်ဖိတ်ခေါ်ပင်း ဟေနည်းတိုင်း နင်ပြုသောအရာအတွက် ကျေးဇူးဆပ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","နင်ဟ ကျွေးမွေးဧည့်ခံပွဲ ကျင်းပသောအခါ ဆင်းရဲသား၊ အင်္ဂါမစုံသူ၊ ခြေမစွမ်းသောသူ၊ မျက်စေ့မမျော်သောသူများဟို ဖိတ်ကြားလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","အေးလို့လုပ်ရင် နင့်ဖို့ မင်္ဂလာဆိလိမ့်မယ်၊ ပစာကို့ သူလို့အနေနဲ့ နင့်အား ပစာမှ ပြန်မပေးဆပ်နိန်သောကျောန့် ဖြစ်အယ်။ သူတော်ကောင်းလို့ သေခြင်းမှ ထမြောက်သောနေ့နှိုက် ဘုရားသခင်ဟ နင့်အား ကျေးဇူးဆပ်ပေးလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ဧည့်သည်များထဲမှ ယေရှုနဲ့ တူတူထိန်နေသူ တဦးဟ အဲစကားဟို ကြားရင် “ဘုရားသခင်ရဲ့ နိုင်ငံတော်မှာ ပွဲဝင်ရတဲ့သူဟ စလောက် မင်္ဂလာဆိသလဲ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ယေရှုဟ “လူတယောက်ဟ ကျွေးမွေးဧည့်ခံပွဲကြီး တခုဟို ပြင်ဆင်ပင်း ဧည့်သည် အမြောက်အများဟို ဖိတ်ကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ပွဲလုပ်ချိန် ရောက်သောအခါ သူဖိတ်ကြားထားသူများ ဆေဟို အစေခံ တယောက်အား သွားခိုင်းယွေ့ ‘လာကြမန့်၊ အရာအားလုံး အဆင်သင့် ဖြစ်နေပါပီ’ ဟု ပြောခိုင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","အဲလိုလဲ ဖိတ်ကြားထားသူများဟ တယောက်ပင်း တယောက် ဆင်ခြေပေးကြအယ်။ ပထမဦးဆုံးသူဟ ‘လယ်တကွက် ဝယ်ဟားတာဟို သွားကျေ့မှ ရမှာရီး၊ ကျေးဇူးပြုပင်း ငါရဲ့ တောင်းပန်မှုဟို လက်ခံမန့်’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","တခြားတယောက်ဟလည်း ‘ငါဟ နွားငါးရှဉ်းဟို ဝယ်ဟားဟို့ သွားစမ်း ကျေ့ရအုံးမှာမို့ ခွင့်လွှတ်ပေးဖို့ တောင်းပန်အယ်’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","အခြားတယောက်ဟလည်း ‘ငါ ခုမှ အိုင်ထောင်ကျဟားလို့ လာနိန်သေးဝူး’ ဟု ဆင်ခြေပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","အစေခံဟ သူ့သခင်ဆေဟို ပြန်လာပင်း အေးသူလို့ အကျောန်းများဟို ပြောပြလေအယ်။ အဲအခါ အိုင်ဆှင်ဟ ဒေါသထွက်ယွေ့ ‘လမ်းမ၊ လမ်းကြားဆေဟို အမြန် သွားပင်း ဆင်းရဲသူ၊ အင်္ဂါချို့တဲ့သူ၊ မျက်စေ့မမျော်သူများနဲ့ ခြေထောက်ဆွံ့သူများဟို ခေါ်ခဲ့လိုက်’ ဟု အစေခံဟို ခိုင်းလိုက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ခဏကြာပင်း အစေခံဟ ပြန်ရောက်လာယွေ့ ‘ဆရာ ခိုင်းလဲ့အတိုင်း ဆောင်ရွက်ပီးပါပီ၊ အဲလိုလဲ နေရာလပ်များ ဆိပါသေးအယ်’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","သခင်ဟ သူ့အစေခံအား ‘လမ်းမများနဲ့ ကျေးလက် တောရွာများသို့ သွားယွေ့ ငါ့နေအိုင် ပြေ့အောန် လူများဟို မရမက ခေါ်သွင်းခဲ့လိုက်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","အရင်ဟ ဖိတ်ကြားထားသူ တဦးမျှ ငါရဲ့ ညနေစာ ဧည့်ခံပွဲဟို ပေးမဝင်နဲ့ဟု နင်လို့ဟို ငါပြောအယ်’ ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","တခါဟ လူအုပ်ကြီးဟ ယေရှုနဲ့ အတူ နောက်တော်ဟို လိုက်သွားကြလဲ့အခါ၊ ကိုယ်တော်ဟ သူလို့အား လဲ့ကျေ့ပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ငါ့ဆေဟို လာသောသူလို့ဟ ငါ့ဟို ချစ်တာထက် တို့မေနဲ့ တို့ဖ၊ ပေါင်အိုမနဲ့ သားသမီး၊ ညီအကိုနဲ့ မောင်နှမနဲ့ မိမိတတ်တိုင်း ပိုယွေ့ ချစ်သောသူဟ ငါ့တဘဲ့ မဖြစ်နိန်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ကိုယ့်လက်ဝါးကပ်တိုင်ဟို ထမ်းပင်း ငါ့နောက်ဟို မလိုက်သောသူဟ ငါ့တဘဲ့ ဖြစ်နိန်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","အကယ်ယွေ့ နင်လို့ထဲတွင် တစုံတယောက်ဟ အေးတိုက်ပီးအောန် ဆောက်လိုရင် ကိုယ့်ဆေမှာ ပိတ်ဆန် အလုံလောက် ဆိ မဆိ သိဖို့ ဦးရင်ဆုံး ထိန်ပင်း မတွက်ကျေ့ဘဲ နေမှာမို့လော။ ");
INSERT INTO dnv_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","နင်ဟ မလုပ်ခင် တိုက်ဟို အုတ်မြစ် ချပင်း အပီးမသတ်နိန်ရင် ဖြစ်ပျက်ခဲ့တာဟို မျော်ရသောသူများဟ နင့်ဟို ကဲ့ရဲ့ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘အေးသူဟ စဆောက်ပင်း ပီးအောန်လဲ လုပ်နိန်ဝူး’ ဟု ဆိုကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","အကယ်ယွေ့ လူ ၁၀,၀၀၀ ဆိသော ဘုရင်တပါးဟ လူ ၂၀,၀၀၀ ဆိသော တခြား ဘုရင်တပါးနဲ့ တိုက်ခိုက်ဖို့ လုပ်သောအခါ သူ့လူတသောင်းဖြင့် ခံတိုက်နိန်မလား ခံတိုက်နိန်ဝူးလားဟု ဦးဆုံး ထိန်ပင်း မစဉ်းစားဘဲ နေမှာမို့လော။ ");
INSERT INTO dnv_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","အကယ်ယွေ့ မခံနိန်ရင် စစ်ချီတက်လာသော ဘုရင်နဲ့ ဝေးတုန်းမှာ သံတမန်ဟို စေလွှတ်ယွေ့ စစ်ပြေငြိမ်းချမ်းဖို့ စကားကမ်းလှမ်းတတ်တာ မဟုတ်လော။” ");
INSERT INTO dnv_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","အေးတိုင်းတိုင်း “စသူငြမ်းငြမ်း သူ့မှာ ဆိသမျှဟို မစွန့်လောနိန်ရင် ငါ့တဘဲ့ ဖြစ်နိန်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ဆားဟ ကောင်းအယ်၊ အဲလိုလဲ အငံပျောက်ဝါးရင် စလို ငံသောအရသာဟို ပြန်လုပ်မလဲ။ ");
INSERT INTO dnv_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","မြေဖို့ အဲဟာမဟုတ်ရင် မြေဆီလွှာဖို့ မကောင်းသဖြင့် အေးဒါဟို အပြင်သို့ လောပလိုက်အယ်။ “ကြားစရာ နားဆိရင် ကြားကြပါစေ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","တနေ့သောအခါ အခွန်ခံများနဲ့ အပယ်ခံရသူများဟ တရားနာဖို့ရန် ယေရှုဆေဟို လာကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ဖာရိရှဲများနဲ့ ကျမ်းတတ်ဆရာများဟ “ဟေသူဟ အပယ်ခံရသူများဟို ကြိုဆိုပင်း သူလို့နဲ့အတူတူပင် စားသောက်နေအယ်” ဟု စတင် ငြီးတွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","အေးလို့မို့ ယေရှုဟ သူလို့ဟို ပုံဥပမာ ပြောတာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“နင်လို့ထဲမှာ တစုံတယောက်ဟ သိုးအကောင်တရာ ဆိယွေ့ တကောင်ပျောက်ဝါးရင် စလိုလုပ်မို့။ သူဟ ကိုးဆယ့်ကိုးကောင်လုံးဟို စားကျက်တွင် ထားခဲ့ပင်း ပျောက်ဝါးလဲ့သိုးဟို မတွေ့မချင်း လိုက်ဆာမယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","နင်လိုက်ဆာယွေ့ တွေ့သောအခါ ပျော်ရွှင်စွာနဲ့ ပခုံးပေါ် ထမ်းယွေ့ ");
INSERT INTO dnv_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","နေအိုင်ဟို သယ်ပြန်လာမယ်။ အဲပင်းရင် အိုင်နီးချင်းနဲ့ မိတ်ဆွေများဟို ခေါ်ပင်း ‘ငါနဲ့အတူ ဝမ်းမြောက်ကြလော့၊ ပျောက်သော သိုးဟို ငါတွေ့ပီ’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","အေးနည်းတိုင်းတိုင်း နောင်တရစရာမလိုလဲ့ ဖြောင့်မတ်သောသူ ကိုးဆယ့်ကိုးယောက်ထက် နောင်တရလဲ့ အပစ်သားတဦးအတွက် ခေါန်းခင်ဘုံနှိုက် ပိုယွေ့ ကြီးသော ဝမ်းမြောက်ခြင်းဆိလိမ့်မယ်ဟု နင်လို့အား ငါဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“အဲဟာမဟုတ်ရင် အမျိုးသမီးတဦးနှိုက် ငွေဒင်္ဂါးဆယ်ပြားဆိပင်း တပြားပျောက်သွားအယ်။ သူမဟ မီးဖူးထွန်းယွေ့ နေအိုင်ဟို တံမျက်စဲလှည်းကာ အေးဟာဟို မတွေ့မချင်း သေချာစွာ ဆှာမယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","သူမဟ အေးဟာဟို တွေ့သောအခါ မိတ်ဆွေနဲ့ အိုင်နီးချင်းလို့ဟို ခေါ်ပင်း ‘ငါနဲ့အတူ ဝမ်းမြောက်ကြလော့၊ ပျောက်သော ဒင်္ဂါးဟို ငါတွေ့ပီ’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","အေးတိုင်းတိုင်း နောင်တရသော အပစ်သားတယောက်အတွက် ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန်များ ဝမ်းသာခြင်းဆိအယ်ဟု နင်လို့အား ငါဆိုအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ယေရှု ဆက်ပြောတာဟ “လူတယောက်နှိုက် သားနေယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","သားငယ်ဟ သူ့ဖအား ‘တို့ဖ၊ ငါရထိုက်လဲ့ အမွေဟို ခွဲပေး’ ဟု ပြောအယ်။ အဲလိုမို့ သူဟ သားနေယောက်အား သူရဲ့ ဥစ္စာပစ္စည်းများဟို ခွဲဝေပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","အဲပင်းရင် ရက်ကတစ်ကြာရင် သားငယ်ဟ သူ့ဥစ္စာများဟို ရောင်းချယွေ့ ရသောငွေဟို ယူပင်းရင် ဝေးလှသော ပြေဟို ထွက်သွားအယ်။ သူဟ ဝေးလှသော တိုင်းပြေဟို သွားပင်း သူ့ပိတ်ဆန်ဟို မဆင်မခြင် နေထိန်မှုဖြင့် ဖြုန်းလောပလိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","သူ့ဆိသမျှလို့ဟို အကုန် သုံးဖြုန်းလိုက်အယ်။ အဲပင်းရင် အေးပြေတွင် အငတ်ဘေး ဆိုက်သဖြင့် သူဟ ပစာမျှ မဆိသဖြင့် ငတ်ပြတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","အေးလို့မို့ အဲပြေသားတယောက်ဆေဟို သွားပင်း အလုပ်ဆှာရင်၊ အေးသူဟ ဝက်ကျောင်းဖို့ သူ့လယ်ဟို လွှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","သူဟ ဝက်များစားနေလဲ့ ပဲတောင့်များဖြင့် မိမိဖိုက်ဟို ဖြေ့ရန် တောင့်တခဲ့အယ်၊ အဲလိုလဲ စသူဟမျှ သူ့ဟို စားစရာမပေးခဲ့ချေ။ ");
INSERT INTO dnv_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","နောက်ဆုံးနှိုက် သူ့အသိစိတ် ဝင်လာပင်း ‘တို့ဖအိုင်မှ အလုပ်သမားများဟ ဝလင်စွာ စားရယွေ့၊ ငါဟ ဟေနေရာနှိုက် ရမ်းဆာ့ ငတ်ပြတ် နေရပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ငါထယွေ့ တို့ဖဆေ ပြန်ပင်း တို့ဖ၊ ငါဟ ဘုရားသခင်နဲ့ တို့ဖဟို ဆန့်ကျင်ယွေ့ အပစ်လုပ်မိပါပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","တို့ဖရဲ့သားဆိုပင်း အခေါ်မခံထိုက်တော့ပါ၊ ငါ့ဟို နင့်ရဲ့ အလုပ်သမားတဦးအဖြစ် ထားပေးမန့်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","အဲပင်းရင် သူဟ ထယွေ့ သူ့ဖဆေဟို ပြန်သွားအယ်။ “သူဟ အဝေးမှာ ဆိနေတုန်းပင် သူ့ဖဟ သူ့ဟို မျော်သောအခါ သနားသောစိတ်ဖြင့် ပြေးယွေ့ ကွေ့ပင်းရင် နမ်းကလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","သားဟ ‘တို့ဖ၊ ငါဟ ဘုရားသခင်နဲ့ တို့ဖဟို ဆန့်ကျင်ယွေ့ အပစ်လုပ်မိပါပီ။ အေးလို့မို့ တို့ဖသားလို့ မခေါ်ထိုက်တော့ပါ’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","အဲလိုလဲ အဖဟ သူရဲ့ အစေခံများဟို ‘အကောင်းဆုံးသော ဝတ်လုံဟို မြန်မြန်ယူပင်း သူ့ဟို ဝတ်ပေးလိုက်ကြ။ သူ့လက်မှာ လက်စွပ်ဟို စွပ်ပေးပင်း ဖိနပ်ဟို စီးပေးလိုက်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","အဲပင်းရင် ဝဖီးနေသော နွားသငယ်ဟို သွားယူပင်း သတ်ကြလော့၊ ငါလို့ ပွဲဟို ဆင်နွှဲကြစို့။ ");
INSERT INTO dnv_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ငါ့သားဟ မခင်ဟ သေခဲ့ပေမဲ့လည်း အခု သူဟ ပြန်ဆှင်လာအယ်။ မခင်ဟ ပျောက်ဆုံးခဲ့ပေမဲ့လည်း အခု ပြန်ယွေ့ တွေ့ပီ’ ဟု ဆိုလေအယ်။ အဲပင်းရင် သူလို့ဟ ပျော်မွေ့ခြင်းဟို ပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“အေးအချိန်တွင် သားအကြီးယောက်ဟ လယ်တောထဲ ရောက်ဆိနေအယ်။ သူပြန်လာယွေ့ နေအိုင်နားနီးလာသောအခါ တီးမှုတ်သံနဲ့ ကခုန်သံဟို ကြားရလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","အေးအခါ အစေခံတယောက်ဟို ခေါ်ယွေ့ ‘ပစာရီး လုပ်နေကြနှင်း’ ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","အစေခံဟ ‘နင့်ညီ ပြန်လာလို့ရီး’ ‘သူဟ ဘေးနဲ့ ကင်းလွတ်ပြန်လာသောကျောန့် ဝအောန်မွေးလဲ့ နွားသငယ်တကောင်ဟို သတ်ပါပီ’ ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","သားကြီးဟ ရမ်းဆာ့ အူထော့ယွေ့ အိုင်ထဲ မဝင်ဘဲနေအယ်။ သူ့ဖဟ သူ့ဆေဟို သွားပင်း အိုင်ထဲဝင်ဖို့ ချော့ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","သားကြီးဟ ‘ကျေ့မန့်၊ ငါဟ နှစ်ပေါင်းများစွာ အဖအတွက် အစေခံလို အလုပ်လုပ် ပေးခဲ့အယ်၊ အဖရဲ့ အမိန့်ဟို တခါမှ မငြင်းဆန်ဖူးဝူး။ အဖ ငါ့အတွက် ပစာပေးခဲ့လဲ။ ငါ့သူငယ်ချင်းတွေနဲ့ ပျော်ပွဲစားဖို့ ဆိတ်သငယ်တကောင်ဟိုမှ မပေးဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","တို့ဖရဲ့ ဥစ္စာပစ္စည်းတွေဟို ပြေ့တန်ဆာမလို့နဲ့ သုံးဖြုန်းခဲ့လဲ့ အဖရဲ့ ဟေသား နေအိုင်ပြန်လာသောအခါ သူ့အတွက် ဝအောန်မွေးဟားလဲ့ နွားသငယ်ဟို သတ်လိုက်အယ်’ ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","အဖဖြစ်သူဟ ‘ငါ့သား၊ နင်ဟ ငါနဲ့အမြဲ တူတူနေအယ်။ ငါ့ဥစ္စာပစ္စည်းဆိသမျှဟ နင့်ဟာဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","အဲလိုလဲ နင့်ညီဟ သေဆုံးခဲ့ပေမဲ့လည်း အသက်ဆှင်လာအယ်။ ပျောက်သွားခဲ့ပေမဲ့လည်း ပြန်တွေ့ရပီ။ အေးလို့မို့ ငါလို့ ပျော်ပျော်ရွှင်ရွှင်နဲ့ ဆင်နွှဲခဲ့ကြအယ်’ ” ဆိုပင်း ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ယေရှုဟ သူ့တဘဲ့တော်လို့အား၊ “တခါဟ သူဌေးတယောက်မှာ သူ့ဥစ္စာလို့ဟို ထိန်းသိမ်းလဲ့ အစေခံတယောက် ဆိအယ်။ အေးလူဟ သူဌေးရဲ့ ငွေကြေးဥစ္စာများဟို ဖြုန်းတီးနေကျောန်းဟို သူများလို့ဟ သူဌေးဆေ ဝိုင်းတိုင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","သူဌေးဟ သူ့ဟို ခေါ်ယွေ့ ‘နင့်အကျောန်း ငါကြားနေရပုံဟ ပစာလိုရီးနှင်း။ လုပ်ငန်းနဲ့ ပတ်သက်သော ငွေစာရင်းများဟို တင်ပြပါ။ နင်ဟ ငါ့ရဲ့ ငွေကြေးဥစ္စာထိန်းသိမ်းလဲ့သူ ဟုတ်တော့ဝူး’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","အေးချိန်တွင် အစေခံဟ ‘ငါပစာလို လုပ်မို့၊ ငါ့သခင်ဟ ငွေကြေးဥစ္စာထိန်းသိမ်းလဲ့ ရာထူးဟို ဖြုတ်လိုက်ပီ။ ငါ့မှာ မြေတူးဆွနိန်သော ခွန်အား မဆိ၊ ကျောန့်နန်လုပ်ဖို့ ငါဆှက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ငွေကြေးဥစ္စာထိန်းသိမ်းလဲ့ ရာထူးမှ ပြုတ်ပင်းနောက် သူများလို့ဟ သူလို့နေအိုင်မှာ ငါ့ဟို လက်ခံအောန် ပစာလိုလုပ်ရမယ် ငါသိပီ’ ဟု စိတ်ထဲနှိုက် ကြံစည်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","အဲပင်းရင် သူဌေးအား ငွေပေးဆပ်ရန်ဆိသော လူပေါင်းလို့ဟို ခေါ်အယ်။ အဲပင်းရင် ပထမလူအား ‘ငါ့သခင်ဟို ပေးဖို့ အကြွေးပစာလောက်ဆိလုန်း’ ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","အေးသူဟ ‘ဆီဂါလံ ၈၀၀ ပေးဖို့ ဆိပါအယ်’ ဟု ပြန်ပြောအယ်။ အဲအခါ ငွေကြေးဥစ္စာထိန်းသိမ်းလဲ့သူဟ ‘နင့်စာရင်းဟို ယူယွေ့၊ ထိန်ပင်း ဂါလံ ၄၀၀ လို့ ရေးမှတ်လိုက်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","အဲပင်းရင် တခြားသူတယောက်ဟို ‘နင်ရော ပေးစရာအကြွေး ပစာလောက်ဆိလဲ’ ဟု မေးအယ်။ အေးသူဟ ‘ဂျုံစပါး တင်း ၁,၀၀၀ ဆိပါအယ်’ ဟု ဖြေအယ်။ ငွေကြေးဥစ္စာထိန်းသိမ်းလဲ့သူဟ ‘နင့်စာရင်းဟို ယူပင်း အတင်း ၈၀၀ လို့ ရေးမှတ်လိုက်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","အေးလို့ လိမ္မာပါးနပ်စွာ လုပ်တတ်သော မရိုးဖြောင့်သော ငွေကြေးဥစ္စာထိန်းသိမ်းလဲ့သူဟို သူဌေးဟ ချီးမွန်းယွေ့၊ ပစာကို့ လောကီသားလို့ဟ မိမိလို့ရဲ့အမှုဟို ဆောင်ရွက်ရာတွင် အလင်းဟို ရောက်သော သူလို့ထက် သာယွေ့ လိမ္မာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“နောက်တခု နင်လို့ဟို ငါပြောတာဟ လောကီစည်းစိမ်ချမ်းသာအားဖြင့် မိတ်ဆွေများ ရအောန်ပြုကြလော့၊ အေးလို့မှသာ နင်လို့ သေလွန်သောအခါ ထာဝရတည်သော အိုင်တော်တွင် နင်လို့ဟို လက်ခံပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","အမှုငယ်တွင် သစ္စာဆိသူဟ အမှုကြီးတွင်လည်း သစ္စာဆိလိမ့်မယ်။ အမှုငယ်တွင် မရိုးသားသူဟ အမှုကြီးတွင်လည်း ရိုးသားလိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","အဲလိုမို့ နင်လို့မှာ ဟေလောကစည်းစိမ်နဲ့ ပတ်သက်ပင်း သစ္စာမဆိရင်၊ နင်လို့အား စစ်မန်လဲ့ချမ်းသာမှုဟို စလို ပေးအပ်နိန်မာလဲ။ ");
INSERT INTO dnv_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","နင်လို့ဟ သများပိုင်ဆိုင်လဲ့ ပစ္စည်းအပေါ်မှာ သစ္စာမဆိရင် စသူဟ နင်လို့ ပိုင်ဆိုင်ရန် ဥစ္စာဟို ပေးအပ်မလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“စလို အစေခံမှ သခင်နေဦးရဲ့ အစေဟို မခံနိန်၊ တဦးဟို မုန်းယွေ့ တဦးဟို ချစ်မယ်။ တဦးမှာ သစ္စာဆိယွေ့ တဦးဟို မလေးမခန့်ပြုမယ်။ နင်လို့ဟ ဘုရားသခင်ရဲ့ အစေနဲ့ လောကစည်းစိမ်ရဲ့ အစေဟို မခံနိန်ကြ” ဟု သွန်သင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ပိတ်ဆန်ဟို တပ်မက်သော ဖာရိရှဲလို့ဟ အေးစကားများဟို ကြားသောအခါ ကိုယ်တော်ဟို ကဲ့ရဲ့လှောင်ပြောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ယေရှုဟ အေးသူလို့အား၊ “နင်လို့ဟ လူလို့ဆေ့မှာ မိမိတတ်တိုင်း ဖြောင့်မတ်ကျောန်း ဖော်ပြတတ်သူများ ဖြစ်ကြအယ်၊ အဲလိုလဲ ဘုရားသခင်ဟ နင်လို့ရဲ့ စိတ်နေလုံးဟို သိဆိအယ်။ လူလို့ အမြတ်တနိုးထားသောအရာဟ ဘုရားသခင်ရဲ့ ဆေ့နှိုက် စက်ဆုပ်ဖွယ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“နှစ်ခြင်း ယောဟန် ပေါ်လာလဲ့အချိန်အထိ မောရှေရဲ့ ပညတ္တိကျမ်းနဲ့ ပရောဖက်ကျမ်းများ အာဏာတည်လျက်ဆိအယ်။ ယောဟန်ပေါ်ပင်းချိန်မှစယွေ့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်အကျောန်း သတင်းကောင်းဟို ဟောလျက်ဆိယွေ့ လူများလို့ဟလည်း နိုင်ငံတော်ဟို အနိုင်အထက်နဲ့ ဝင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","အဲလိုလဲ ပညတ္တိကျမ်းမှ ကတစ်ချေးဆုံး အက္ခရာ စာလုံးတလုံး ပျက်စီးဖို့ထက် ခေါန်းခင်နဲ့ မြေကြီးဟ ပိုပင်းပျက်စီးလွယ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“သူ့ပေါင်အိုမဟို ကွာဆှင်းယွေ့ အခြားသောမိန်းမနဲ့ ထိမ်းမြားစုံဖက်သောသူတိုင်းဟ အိုင်ထောင်ရေး ဖောက်ပြန်မှုဟို ကျူးလွန်အယ်။ ခင်ပွန်းဟ ကွာဆှင်းထားသော မိန်းမနဲ့ ထိမ်းမြားစုံဖက်သော ယောက်ျားဟလည်း အိုင်ထောင်ရေး ဖောက်ပြန်မှုဟို ကျူးလွန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“တခါဟ သူဌေးတဦးဟ ဆေးအလွန်ကြီးသော ပိတ်ချောထည်များဟို ဝတ်ပင်း နေ့တိုင်း ဇိမ်ခံပင်း နေထိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","သူဌေးအိုင်ရဲ့ ထင်ခါးပေါက်တွင် လာဇရု နာမယ်ဆိသော ဆင်းရဲသားတယောက်ဟ အနာစိမ်းများပေါက်ယွေ့ တုံးလုံးလဲနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","သူဟ သူဌေးရဲ့ စားပွဲမှကျသော စားကြွင်းစားကျန်များဟို စားချင်ယွေ့ စောင့်မျော်နေတတ်အယ်။ ခွေးလို့ဟ လာယွေ့ သူရဲ့ အနာစိမ်းများဟို ယက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","အေးဆင်းရဲသား သေဆုံးသွားသောအခါ ခေါန်းခင်တမန်လို့ဟ သူ့အား အာဗြဟံရဲ့ နဘေးတွင် ထိန်စေရန် သယ်ဆောင်သွားကြအယ်။ သူဌေးဟလည်း သေလွန်ယွေ့ သင်္ဂြိုဟ်ခြင်းဟို ခံရအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","မရဏာနိုင်ငံတွင် နာကျင်မှုဝေဒနာဟို ရမ်းဆာ့ခံရသဖြင့် မျော်ကျေ့လိုက်သောအခါ အာဗြဟံနဲ့အတူ သူ့ရဲ့ နဘေးတွင် လာဇရုဟို မျော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","သူဌေးဟ ခေါ်ယွေ့ ‘တို့ဖ အာဗြဟံ၊ ငါ့ဟို သနားပါအုံး။ ငါဟ ဟေမီးလျှံထဲတွင် ရမ်းဆာ့ ဝေဒနာခံစားရသောကျောန့်၊ လာဇရုဟ သူ့လက်ဖျားဟို ယေထဲနစ်ပင်း ငါ့လျှာဟို အေးစေဖို့ သူ့ဟို ငါ့ဆေဟို စေလွှတ်ပေးပါ’ ဟု အော်ယွေ့ ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","အဲလိုလဲ အာဗြဟံဟ ‘ငါ့သား၊ နင်ဟ အသက်ဆှင်တုန်းခါဟ ကောင်းသောအရာများဟို ရဆိခဲ့ယွေ့ လာဇရုဟ မကောင်းသောအရာများဟို ရဆိခဲ့ကျောန်း သတိရလော့။ အဲလိုလဲ အခုမှာ သူဟ စိတ်သက်သာဟို ခံစားရယွေ့ နင်ဟ ရမ်းဆာ့ဝေဒနာဟို ခံစားနေရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","အဲပင်းရင် နင်နဲ့ ငါလို့စပ်ကြားတွင် ရမ်းဆာ့ နက်သောချောက်ကြီး တည်ဆိနေအယ်။ အေးလိုမို့ ဟေအရပ်မှ နင်လို့ဆိရာသို့ ကူးချင်သောသူ မကူးနိန်၊ နင်လို့ဆိရာအရပ်မှ အဲအရပ်ဟို ကူးချင်သောသူလည်း မကူးနိန်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","သူဌေးဟ ‘တို့ဖ အေးလို့ဖြစ်ရင် လာဇရုဟို ငါလို့ အဖအိုင်ဟို စေလွှတ်ပေးရန် တောင်းပန်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ငါ့မှာ ညီ ငါးယောက်ဆိပါအယ်။ သူလို့ဟ ဟေလိုမျိုး ရမ်းဆာ့ ဝေဒနာခံစားရလဲ့ နေရာမျိုးဟို မရောက်လာဖို့တွက် သူလို့အား သတိပေးရန် လာဇရုဟို တို့ဖအိုင်ဟို စေလွှတ်ပေးမန့်’ ဟု တောင်းပန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","အာဗြဟံဟ ‘နင့်ညီတွေဟို သတိပေးဖို့ မောရှေနဲ့ ပရောဖက်များ ဆိနေဝဲ့။ သူလို့ရဲ့ စကားဟို နားထောင်ကြမန့်စေ’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","သူဌေးဟ အေးလောက်နဲ့ မရလောက်ဝူး။ ‘တို့ဖ အာဗြဟံ၊ အကယ်ယွေ့ သေဆုံးသွားပီးလဲ့ တစုံတယောက်ဟ ထမြောက်ပင်း သူလို့ဆေ သွားပြောရင် သူလို့ဟ နောင်တရကြမှာရီး’ ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","အာဗြဟံဟ ‘သူလို့ဟ မောရှေနဲ့ ပရောဖက်တွေရဲ့ စကားဟို နားမထောင်ရင် တစုံတယောက်ဟ သေခြင်းဟနေ ထမြောက်လာရင်လည်း ယုံကြည်နိန်မှာ ဟုတ်ဝူး’ ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ယေရှုဟ တဘဲ့တော်လို့အား ပြောတာဟ “လူဟို အပစ်ပြုစေမဲ့အရာများ သေချာပေါက် ဆိရမယ်၊ အဲလိုလဲ မှောက်မားလမ်းလွဲစေသူဟ အမင်္ဂလာ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","အေးသူဟ ဟေလူပဲ့သငယ် တဦးတယောက်ဟို လမ်းမားစေမဲ့အစား လည်ဖင်းတွင် ကြိတ်ဆုံကျောက်ကြီးဟို ဆွဲယွေ့ ပင်လယ်ထဲဟို လောချခံရခြင်းဟ သူ့အတွက် သာယွေ့ ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","အေးလို့မို့ ကိုယ့်တတ်တိုင်း သတိထားကြလော့။ “နင့်ညီအကိုဟ နင့်ဟို ပစ်မားရင် သူ့ဟို ဆုံးမလော့။ သူဟ နောင်တရရင် သူ့အပစ်ဟို ခွင့်လွှတ်ပေးလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","တနေ့ထဲတွင် ခုနေကြိမ် နင့်ဟို ပစ်မားယွေ့ ခုနေကြိမ်မြောက်အောန် နင့်ဆေဟို လာပင်း ‘ငါ နောင်တရအယ်’ ဟု ပြောရင် နင်ဟ သူ့ရဲ့ အပစ်ဟို ခွင့်လွှတ်ရမယ်” ဟု တဘဲ့တော်လို့အား ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","တမန်တော်လို့ဟ သခင်ဘုရားအား “ငါ့လို့ရဲ့ ယုံကြည်ခြင်းဟို တိုးပွားစေမန့်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","သခင်ဘုရားဟ “နင်လို့မှာ ယုံကြည်ခြင်း မုန်ညင်းစေ့လောက် ဆိရင် ဟေပိုးစာပင်အား ‘အမြစ်နဲ့တူတူ ကျွတ်ထွက်ယွေ့ ပင်လယ်ထဲမှာ စိုက်နေစေလော့’ ဟု ဆိုရင် အေးအပင်ဟ နင်လို့ ပြောလဲ့အတိုင်း ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“နင်လို့ထဲဟ တယောက်ဟ လယ်လုပ်သောအစေခံ အဲဟာမဟုတ်ရင် သိုးကျောင်းသောအစေခံ ဆိလယ်ထဲအယ်။ သူဟ လယ်တောမှ ပြန်လာသောအခါ ခပ်သော့သော့လာပင်း အစာစားမန့်ဟု နင်လို့ပြောမလော။ ");
INSERT INTO dnv_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","အေးလို့မပြောဘဲ သူ့ဟို ‘ငါ့ဖို့ ညစာပြင်လော့၊ ငါစားသောက်နေတုန်း ခါးစဲပင်း ငါ့ဟို လုပ်ကျွေးမန့်၊ ပီးခါကျမှ နင်စားသောက်ရမယ်’ ဟု ပြောမယ် မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","အေးအစေခံဟ သူ့သခင် ခိုင်းစေလဲ့အတိုင်း ဆောင်ရွက်ပေးရလဲ့အတွက် သူ့ဟို ကျေးဇူးတင်စရာ မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","အေးတိုင်းတိုင်းပင် နင်လို့ဟလည်း မိမိလို့အား စေခိုင်းလဲ့အရာအားလုံးဟို ဆောင်ရွက်ပီးချိန်တွင် ‘ငါလို့ဟ သာမန် အစေခံများပင် ဖြစ်ယွေ့၊ ငါလို့ ဆောင်ရွက်ရန် ဆိလဲ့ လုပ်ငန်းဆောင်တာများဟို လုပ်ဆောင်ခဲ့ကြခြင်းသာ ဖြစ်အယ်’ ဟု ဆိုကြလော့” ဟူယွေ့ မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ယေရှုဟ ယေရုရှလင်မြို့သို့ သွားနေစဉ် ရှမာရိပြေနဲ့ ဂါလိလဲပြေနယ် စပ်ကြားတွင် ဆောက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ရွာတရွာသို့ဝင်သောအခါ အရေပြားရောဂါသည် ဆယ်ယောက်လို့ဟ ကိုယ်တော်ဟို ခရီးဦးကြိုပြုကြအယ်။ အေးသူလို့ဟ ခပ်ခွာခွာရပ်နေလျက်၊ ");
INSERT INTO dnv_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","“ယေရှု၊ သခင် ငါလို့ဟို ကယ်မသနားမန့်” ဟု အော်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ယေရှုဟ သူလို့ဟို မျော်သောအခါ “နင်လို့တွေ ယဇ်ပုရောဟိတ်ဆေ သွားပင်း ကိုယ်ဟို ပြလော့” ဟု ပြောအယ်။ သူလို့သွားနေတုန်းတွင် သန့်ဆှင်းခြင်းဟိုရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","အေးသူလို့ထဲတွင် တယောက်ဟ မိမိရောဂါ ပျောက်ကင်းသွားကျောန်းဟို သိသောအခါ အသံကျယ်ရီးဖြင့် ဘုရားသခင်ဟို ချီးမွန်းလျက် ကိုယ်တော်ဆေ ပြန်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","အဲပင်းရင် ယေရှုရဲ့ ခြေရင်းနှိုက် ပျပ်ဝပ်ယွေ့ ကိုယ်တော်ဟို ကျေးဇူးတင်ကျောန်း ပြောအယ်။ အေးလူဟ ရှမာရိလူမျိုး ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ယေရှုဟ “လူဆယ်ယောက်လို့ဟ ရောဂါပျောက်ကင်းသွားကြအယ် ဟုတ်ဝူးလော။ တခြားကိုးယောက်ဟ ပစာနားရောက်ကုန်နှင်း။ ");
INSERT INTO dnv_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ဘုရားသခင်ဟို ချီးမွန်းဖို့ရန် ပြန်လာသောသူဟ ဟေတပါးအမျိုးသားမှ လွဲယွေ့ တဦးမျှ မဆိဝူးလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","အေးနောက် ယေရှုဟ သူ့အား “နင်ထယွေ့ သွားမန့်၊ နင့်ရဲ့ ယုံကြည်ခြင်းဟ နင့်ဟို ကျန်းမာစေပီ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ဖာရိရှဲအချို့လို့ဟ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ ပစာအခါနှိုက် တည်ပါမလုန်း” ဟု ကိုယ်တော်အား မေးကြအယ်။ ကိုယ်တော်ဟ “ဘုရားသခင်ရဲ့ နိုင်ငံတော်တည်ခြင်းဟ မျော်သောအရာနှိုက် တည်တာ မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘ကျေ့လော့၊ ဟေအရပ်နှိုက် ဆိအယ်’ ‘ဟိုးဖက်အရပ်တွင် ဆိအယ်’ ဟု စသူမှ မပြောနိန်။ ပစာကို့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ နင်လို့အထဲတွင် တည်လျက်ဆိအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","အဲပင်းရင် ကိုယ်တော်ဟ တဘဲ့တော်လို့အား “နင်လို့ မျော်ချင်သော လူသားရဲ့ နေ့ရက် တနေ့ ရောက်ဆိလာသော်လည်း နင်လို့ တွေ့မျော်ရလိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","လူလို့ဟ နင်လို့အား ‘လူသားဟ ဟေအရပ်နှိုက် ဆိအယ်၊ ဟိုးနေရာမှာ ဆိအယ်’ ဟု ဆိုလိမ့်မယ်။ သူလို့နောက်ဟို ပြေးမလိုက်ကြနဲ့ ဟု ဆိုကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","အကျောန်းမှာ ဆပ်လက်ထိုးယွေ့ မိုးခေါန်းခင်တဖက်မှ အခြားတဖက်တိုင်အောန် လင်းထိန်သွားသလို လူသား ပြန်လာလဲ့နေ့ရက်နှိုက် အဲတိုင်းတိုင်း ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","အဲလိုလဲ သူဟ ဦးရင်ဆုံး ဒုက္ခဝေဒနာဟို ရမ်းဆာ့ ခံစားရယွေ့ ခုခေတ်လူလို့ရဲ့ ငြင်းပယ်ခြင်းဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","နောဧရဲ့ နေ့ရက်များနှိုက် ဖြစ်သလိုမျိုး လူသား ပြန်လာလဲ့ နေ့ရက်များနှိုက်လည်း ဖြစ်ပျက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","နောဧဟ သင်္ဘောထဲဟို ဝင်လဲ့နေ့တိုင်အောန် လူလို့ဟ စားသောက်လျက်၊ လက်ထပ်ထိမ်းမြားလျက် နေခဲ့ကြအယ်။ အဲပင်းရင် ယေလွှမ်းမိုးခြင်း ရောက်လာကာ သူလို့အားလုံးဟို ဖျက်ဆီးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","အေးတိုင်းတိုင်း လောတရဲ့ နေ့ရက်များနှိုက်လည်း လူလို့ဟ စားသောက်လျက်၊ ရောင်းဝယ်လျက်၊ စိုက်ပျိုးလျက်၊ အိုင်ဆောက်လျက် နေခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","သောဒုံမြို့မှ လောတ ထွက်ခွာသောနေ့နှိုက် ခေါန်းခင်မှ ကန့်နဲ့ မီးမိုးရွာကျယွေ့ လူအားလုံးဟို ဖျက်ဆီးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","လူသားပေါ်ထွန်းသော နေ့ရက်နှိုက်လည်း အေးတိုင်းတိုင်း ဖြစ်လိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“အေးနေ့ခါကျရင် အိုင်မိုးပေါ်မှာ ဆိသောသူဟ အိုင်ထဲတွင် ဆိလဲ့ မိမိဥစ္စာပစ္စည်းဟို ယူဖို့ မဆင်းစေနဲ့၊ အေးတိုင်းတိုင်းပင် လယ်နှိုက် ဆိသောသူဟလည်း နေအိုင်ဟို မပြန်စေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","လောတရဲ့ ပေါင်အိုမဟို အောက်မေ့ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ကိုယ့်အသက်ဟို ကယ်ဆယ်လိုသောသူဟ အသက်ဆုံးလိမ့်မယ်၊ ကိုယ့်အသက်ဟို အဆုံးခံသောသူဟ မိမိအသက်ဟို ကယ်ဆယ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","နင်လို့ဟို ငါပြောတာဟ အဲညတွင် အိပ်ယာတခုနှိုက် ဆိနေကြလဲ့လူနေယောက်ထဲတွင် တယောက်ဟို သိမ်းယူယွေ့ တယောက်ဟ ကျန်ရစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ကြိတ်ဆုံတူတူကြိတ်နေသော မိန်းမနေယောက်မှ တယောက်ဟို သိမ်းယူယွေ့ တယောက်ဟ ကျန်ရစ်လိမ့်မယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","တဘဲ့တော်လို့ဟ “သခင်၊ ပစာအရပ်မှာ ဟေလို့ အဖြစ်အပျက်ဖြစ်ပေါ်လိမ့်မလုန်း” ဟု မေးကြအယ်။ ယေရှုဟ “အသေကောင်ဆိရာ အရပ်တွင် လင်းတငက်များ လာစုနေကြလိမ့်မယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","အဲပင်းရင် ယေရှုဟ တဘဲ့တော်လို့ဟို အားမလျော့ဘဲ အစဉ် ဆုတောင်းရမဲ့အကျောန်းဟို ပုံဥပမာအားဖြင့် ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“မြို့တမြို့တွင် တရားသူကြီးတယောက်ဆိယွေ့ သူဟ ဘုရားသခင်ဟို မကြောက်၊ လူဟို အားမနာတတ်သူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","အေးမြို့နှိုက် ဆိသော မုဆိုးမတဦးဟ သူ့ဆေဟို ခဏခဏလာပင်း ‘ကျမရဲ့ ရန်ဖက်ဟို လက်စားချေလောက်အောန် ကူညီပေးမန့်’ ဟု သူ့အခွင့်ရေးအတွက် တောင်းဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","တရားသူကြီးဟ မစီရင်ပေးဘဲ အချိန်အကြာထားအယ်။ အဲပင်းရင် ‘ငါဟ ဘုရားသခင်ဟို မကြောက်၊ လူမျက်နှာဟို မထောက်တတ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","အဲလိုလဲ ဟေမုဆိုးမဟ ငါ့ဟို လာလာနှောင့်ယှက် နေယွေ့ သူ့ဖက်နှိုက် တရားစီရင်မယ်။ အေးလို့မှ မဟုတ်ရင် သူဟ ငါ့ဟို ဆက်ပင်းနှောင့်ယှက်သဖြင့် နောက်ဆုံးနှိုက် ငါ့ဟို ပင်ပန်းစေလိမ့်မယ်’ ဟု ဆိုအယ်။” ");
INSERT INTO dnv_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","သခင်ဘုရားဟ “ဆိုးညစ်သော တရားသူကြီး ပြောတာဟို နားထောင်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","အခုတွင် ရွေးချယ်ထားသောသူလို့ဟ နေ့တိုင်းညတိုင်း အော်ဟစ် တောင်းဆှောက်ရင် ဘုရားသခင်ဟ သူလို့ဖက်တွင် တရားမျှတစွာ မစီရင်ဘဲနေမလော၊ ကိုယ်တော်ဟ သူလို့အား ကူညီမစရန် နှောင့်နှေးနေမလော။ ");
INSERT INTO dnv_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","နင်လို့ဟို ငါပြောတာဟ သူလို့ဖက်တွင် အလျင်အမြန် တရားမျှတစွာ စီရင်မယ်။ အဲလိုလဲ လူသားဟ ကြွလာသောအခါ မြေကြီးပေါ်တွင် ယုံကြည်ခြင်းဟို တွေ့ရမလော” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","မိမိလို့တတ်တိုင်း သူတော်ကောင်းဟု ယုံကြည်ကာ သူတပါးလို့ဟို အထင်မြင်သေးတတ်သူ လူတချို့လို့အား ယေရှုဟ ဥပမာဖြင့် ပြောတာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“လူနေယောက်ဟ ဆုတောင်းရန် ဗိမာန်တော်ဟို သွားကြအယ်၊ တယောက်ဟ ဖာရိရှဲ၊ တခြားတယောက်မှာ အခွန်ခံ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ဖာရိရှဲဟ တယောက်တည်းရပ်လျက် ‘အို ဘုရားသခင်၊ ငါဟ အခြားသူများလို လောဘကြီးခြင်း၊ မရိုးသားခြင်း၊ သူ့မယားဟို ပစ်မားသောသူ မဟုတ်လဲ့အပြင် ဟေအခွန်ခံလို မဟုတ်သောကျောန့် ကျေးဇူးတင်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ငါဟ တပတ် နေရက် အစာဆှောင်ယွေ့ ငါပိုင်ဆိုင်သမျှထဲမှလည်း ဆယ်ဖို့တဖို့ လှူပါအယ်’ ဟု ဆုတောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","အဲလိုလဲ အခွန်ခံဟ အဝေးမှာ ရပ်ပင်း ခေါန်းခင်ဟို မမျော်ကျေ့ဘဲ ‘အို ဘုရားသခင်၊ အပစ်သား ကျွန်တော့်ဟို သနားမူပါ’ ဟု ရင်ဘတ်ဟို ထုပင်း ဆုတောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","နင်လို့ဟို ငါပြောတာဟ ဟေသူသည် ဘုရားသခင် ဆေ့တော်တွင် အပစ်ပြေပင်း၊ သူ့အိုင်ဟို ပြန်သွားယွေ့ ဖာရိရှဲမှာမူ အပစ်မပြေ။ ပစာကို့ ကိုယ့်တတ်တိုင်း ချီးမြှောက်သူဟ နှိမ့်ချခြင်းဟို ခံရယွေ့ မိမိကိုယ်ဟို နှိမ့်ချသူဟ ချီးမြှောက်ခြင်း ခံရမယ်ဖြစ်သောကျောန့် ဖြစ်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","လူတချို့ဟ လူပဲ့သငယ်လို့ဟို လက်တော်နဲ့ ပေးတို့စေရန် သခင့်ဆေဟို ခေါ်ခဲ့ကြအယ်။ တဘဲ့တော်လို့ဟ မျော်ရင် အေးသူလို့အား အပစ်တင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","အဲလိုလဲ ယေရှုဟ လူပဲ့သငယ်များဟို ခေါ်လျက် “လူပဲ့သငယ်လို့ဟို ငါ့နား လာကြပါစေ၊ မဆီးတားကြနဲ့။ ပစာကို့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ အေးသူလို့လိုမျိုးရဲ့ နိုင်ငံ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","နင်လို့ဟို ငါအမန်ဆိုတာဟ၊ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို လူပဲ့သငယ်လိုမျိုး လက်မခံသောသူဟ အဲနိုင်ငံတော်သို့ စခါမှဝင်ရလိမ့်မယ် ဟုတ်မောင့်လဲ့” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ယုဒအရာဆိ တယောက်ဟ “ကောင်းမြတ်လဲ့ ဆရာ၊ ထာဝရအသက်ဟို ရဖို့ ငါဟ ပစာလိုလုပ်ရမလုန်း” ဟု ယေရှုဟို မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ယေရှုဟ “ငါ့ဟို ကောင်းမြတ်တာဟု ပစာကျောန့် ခေါ်လုန်း။ ဘုရားသခင် တပါးမှလွှဲယွေ့ ကောင်းမြတ်သူ စသူမျှ မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‘သူ့မယားဟို မပစ်မားနဲ့၊ လူ့အသက်ဟို မသတ်နဲ့၊ သူ့ဥစ္စာဟို မခိုးနဲ့၊ မမန်သော သက်သေဟို မခံနဲ့၊ တို့မေ တို့ဖလို့ဟို ရိုသေရမယ်’ ဟူသော ပညတ်တော်များဟို နင်သိအယ် မဟုတ်လော” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","အဲသူဟ “ဟေပညတ်များဟို ငါဟ ငယ်တုန်းခါထဲဟ စောင့်ထိန်းခဲ့ပါပီ” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ယေရှုဟ အဲစကားဟို ကြားသောအခါ “နင်နှိုက် လုပ်စရာတခု လိုသေးအယ်။ နင့်ဥစ္စာဆိသမျှဟို ရောင်းပင်း ဆင်းရဲသားလို့ဟို ပေးကမ်းစွန့်ကြဲလိုက်၊ အေးလို့လုပ်ရင် နင်ဟ ခေါန်းခင်ဘုံတွင် ဘဏ္ဍာဟို ရလိမ့်မယ်၊ အေးလို့လုပ်ပင်းမှ ငါ့နောက်ဟို လိုက်ခဲ့လိုက်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","အဲလိုလဲ သူဟ ရမ်းဆာ့ ချမ်းသာသောသူ ဖြစ်သောကျောန့် အေးစကားဟို ကြားသောအခါ ရမ်းဆာ့ ဝမ်းနည်းသွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ယေရှုဟ အဲသူဝမ်းနည်းနေတာဟို မျော်ရင် “ဥစ္စာချမ်းသာသူလို့ဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ထဲဟို ရမ်းဆာ့ ဝင်ခဲလှအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ကုလားအုတ်ဟ အပ်နဖားဟို လျှိုလွယ်သော်လည်း ချမ်းသာသောသူဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို ဝင်ခဲလှအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","အေးစကားဟို ကြားသောသူလို့ဟ “အေးဆို စသူဟ ကယ်တင်ခြင်းဟို ရနိန်မလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ယေရှုဟ “လူလို့ မတတ်နိန်သောအရာဟို ဘုရားသခင် တတ်နိန်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ပေတရုဟ “ကျေ့မန့်၊ ငါလို့ဟ ငါလို့ ပိုင်ဆိုင်သောအရာလို့ဟို စွန့်ယွေ့ ကိုယ်တော်နောက်ဟို လိုက်လာခဲ့ကြအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ယေရှုဟ “ငါ အမန်ပြောတာဟ အကြင်သူဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ကျောန့် နေအိုင်၊ ပေါင်အိုမ၊ မိဖ၊ ညီအကို၊ သားသမီး တခုခုဟို စွန့်လာခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","အေးသူဟ ဟေဖဝါ့တွင် အဆများစွာ အကျိုးခံစားရပင်း နောင်ဖဝါ့နှိုက် ထာဝရအသက်ဟို ရလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ယေရှုဟ တဆယ့်နေပါးသော တဘဲ့တော်လို့ဟို ခေါ်ပင်းရင် “နားထောင်ကြ၊ ငါလို့ဟ ယေရုရှလင်မြို့ဟို သွားကြအယ်။ လူသားအကျောန်းနဲ့ ပတ်သက်ယွေ့ ပရောဖက်များ ရေးမှတ်ဖော်ပြခဲ့သမျှဟ ပြေ့စုံလာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","တပါးအမျိုးသားဟို လက်ဟို လှောင်ပြောင်ခြင်း၊ ညှဉ်းဆဲခြင်း၊ ဆံထွေးနဲ့ ထွေးခြင်းဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","သူလို့ဟ ကြိမ်ဒဏ်ပေးယွေ့ အသေသတ်ကြလိမ့်မယ်။ အဲလိုလဲ သုံးရက်မြောက်သောနေ့နှိုက် လူသားဟ ဆှင်ပြန်ထမြောက်လိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","အဲလိုလဲ တဘဲ့တော်လို့ဟ ကိုယ်တော်ရဲ့ စကားတခွန်းဟိုမျှ နားမလည်ကြ။ အေးစကားများရဲ့ အနက်အဓိပ္ပာယ်ဟ ကွယ်ဝှက်လျက်နေသဖြင့် ကိုယ်တော်ရဲ့ ပြောကြားမှုဟို နားမလည်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ယေရိခေါမြို့အနီးနှိုက် ရောက်လာစဉ်၊ မျက်စေ့မမျော်သော တယောက်ဟ လမ်းနားမှာ ထိန်ယွေ့ တောင်းစားလျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","သူဟ လူအုပ်လို့ သွားသောသံဟို ကြားသောအခါ “ပစာရီးလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","သူလို့ဟ “နာဇရက်မြို့သား ယေရှု ဖြတ်သွားစာရီး” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","“ဒါဝိဒ်ရဲ့ သားတော် ယေရှု၊ ငါ့ဟို သနားမန့်” ဟု အော်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ဆေ့မှာဆိသောလူလို့ဟ သူ့ဟို တိတ်တိတ်နေရန် ငေါက်ငမ်းယွေ့ ပြောကြအယ်။ အဲလိုလဲ သူဟ “ဒါဝိဒ်ရဲ့ သားတော်၊ ငါ့ဟို သနားမန့်” ဟု ပိုယွေ့ အော်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","အေးလို့မို့ ယေရှုဟ ရပ်တန့်လိုက်ပင်းနောက် အေးသူဟို ခေါ်ခဲ့ဟု ပြောအယ်။ သူအနား ရောက်လာသောအခါ ယေရှုဟ၊ ");
INSERT INTO dnv_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“နင့်ဖို့ ပစာလုပ်ပေးစေချင်လော” ဟု မေးသောအခါ သူဟ “ဆရာ” “ငါမျက်စေ့ မျော်ချင်အယ်” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ယေရှုဟ “မျက်စေ့ မျော်စေ၊ နင့်ရဲ့ ယုံကြည်ခြင်းဟ နင့်ဟို မျော်စေပီ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","အေးခဏချင်းတွင် သူဟ မျက်စေ့မျော်ယွေ့၊ ဘုရားသခင်ဟို ချီးမွန်းပင်း ကိုယ်တော်နောက်ဟို လိုက်အယ်။ အေးအရာဟို လူအုပ်ကြီးဟ မျော်သောအခါ ဘုရားသခင်ဟို ချီးမွန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ယေရှုဟ ယေရိခေါမြို့ဟို ဝင်ယွေ့ ဆှောက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","အဲအရပ်တွင် ဇက္ခဲ နာမယ်ဆိသော အခွန်ကောက်မှူးကြီးတယောက် ဆိအယ်၊ သူဟ ချမ်းသာသောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","သူဟ ယေရှု စလိုလူဖြစ်တာဟို မျော်ရရန် ကြိုးစားအယ်၊ အဲလိုလဲ အရပ်ပုသူဖြစ်သောကျောန့် လူအုပ်ကြီးဟို ကျော်ယွေ့ မမျော်နိန်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","အေးလို့မို့ ယေရှုဟို မျော်နိန်ရန် ကြွလာမဲ့လမ်းအတိုင်း ဆေ့ဟိုပြေးယွေ့ သဖန်းပင်ပေါ်ဟို တက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ယေရှုဟ အေးနေရာဟို ရောက်သောအခါ မော့ကျေ့ပင်းရင် “ဇက္ခဲ၊ အမြန် ဆင်းခဲ့လိုက်၊ ခုနေ့ နင့်နေအိုင်မှာ ငါတည်းခိုမယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ဇက္ခဲဟ သစ်ပင်ပေါ်မှ အမြန် ဆင်းယွေ့ ကိုယ်တော်ဟို ဝမ်းမြောက်စွာ ကြိုဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ဟေအခြင်းအရာဟို မျော်သောအခါ လူလို့ဟ “ဟေသူဟ ဆိုးသွမ်းသော သူတယောက်ရဲ့ အိုင်တွင် တည်းခိုရန် သွားပါအယ် ဟုတ်မောင့်လဲ့” ဟု စတင်ပင်း ကဲ့ရဲ့အပစ်တင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ဇက္ခဲဟ ရပ်လျက် သခင့်ဟို “နားထောင်ပါအုံး ဆရာ၊ ငါ့ရဲ့ ဥစ္စာပစ္စည်းတဝက်ဟို ဆင်းရဲသောသူလို့ဟို ပေးပါမယ်၊ အကယ်ယွေ့ တစုံတယောက်ဆေမှ မတရားတောင်းယူမိရင် အေးငွေရဲ့ လေးဆဟို ပြန်ပေးပါမယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ယေရှုဟ “ဟေသူဟလည်း အာဗြဟံရဲ့ သားမြေးဖြစ်သဖြင့် ကယ်တင်ခြင်းဟ ခုနေ့ပင် ဟေနေအိုင်ပေါ်ဟို သက်ရောက်လေပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","လူသားဟ ပျောက်ဆုံးသောသူများဟို ဆာရန်နဲ့ ကယ်တင်ရန် လာခြင်းဖြစ်အယ်” ဟု သူ့ဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ကိုယ်တော်ဟ ဟေအကျောန်းအရာလို့ဟို နားထောင်သောသူလို့အား ပုံဥပမာတခုဟို ထပ်ယွေ့ ပေးအယ်။ ပစာကို့ ကိုယ်တော်ဟ ယေရုရှလင်မြို့ အနီးဟို ရောက်လာသဖြင့် ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟ ခုတုံးပေါ်ထွန်းတော့မယ်ဟု လူလို့ ထင်နေကြသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","သူဟ “မြင့်မြတ်သော လူတဦးဟ ဘုရင်အရာဟို ခံယူလိုယွေ့ မိမိပြေသို့ ပြန်လာရန် ဝေးသော ပြေသို့ သွားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","မသွားခင် မိမိရဲ့ အစေခံဆယ်ယောက်ဟို ခေါ်ယူကာ ‘ငါပြန်ရောက်လာတဲ့ထိ ကုန်သွယ်ခြင်းအမှုဟို ပြုကြလော့’ ဟုဆိုယွေ့ ဆွေဒင်္ဂါးတပြားစီ ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","အဲလိုလဲ ပြေသားအချို့ဟ သူ့ဟို မုန်းကြသဖြင့် ‘အေးသူရဲ့ အုပ်ချုပ်မှုဟို ငါလို့မခံချင်’ ဟု သတင်းသယ်ပို့သူများအား သူ့နောက်ဟို လွှတ်ယွေ့ ပြောစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“အေးသူဟ ဘုရင်အရာဟို ခံယွေ့ ပြန်လာအယ်။ သူဟ ခုတုံးပင် မိမိရင်းနှီးငွေပေးခဲ့လဲ့ အစေခံများဟို ကုန်သွယ်ယွေ့ စလောက်အမြတ်ရတာဟို သိချင်သဖြင့် သူလို့အား ခေါ်လာရန် အမိန့်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ပထမအစေခံဟ လာယွေ့ ‘သခင် ပေးခဲ့လဲ့ ဆွေဒင်္ဂါးတပြားဖြင့် အမြတ် ဆယ်ဆရပါအယ်’ ဟု ဆောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","မင်းကြီးဟ ‘ကောင်းအယ်၊ နင်ဟ အစေခံကောင်းတယောက် ဖြစ်အယ်၊ သေးငယ်သောအမှုတွင် သစ္စာဆိသူဖြစ်သဖြင့် နင့်ဟို ငါဟ မြို့ကြီးဆယ်မြို့ဟို အုပ်ချုပ်လော့’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ဒုတိယအစေခံဟလည်း လာယွေ့ ‘သခင်၊ သခင်ပေးခဲ့လဲ့ ဆွေဒင်္ဂါးတပြားနဲ့ အမြတ် ငါးဆရပါအယ်’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","သခင်ဟ ‘နင်ဟ မြို့ကြီးငါးမြို့ဟို အုပ်ချုပ်လော့’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","အခြားသောအစေခံဟ လာယွေ့ ‘သခင်၊ သခင်ပေးခဲ့လဲ့ ဆွေဒင်္ဂါး ဟေမှာ ဆိပါအယ်၊ အေးငွေဟို ငါဟ ပုဝါဖြင့် ထုပ်ပင်း သိမ်းဆည်းထားပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","သခင်ဟ ခက်ထန်သူဖြစ်သောကျောန့် ငါ ကြောက်ရွံ့အယ်။ သခင်ဟ ကိုယ်မပိုင်လဲ့အရာဟို သိမ်းယူတတ်ပင်း မိမိမစိုက်ပျိုးလဲ့ သီးနှံဟို ရိတ်သိမ်းတတ်ပါအယ်’ ဟု ဆောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","မင်းကြီးဟ ‘ဆိုးညစ်သော အစေခံ၊ နင်ပြောလဲ့အတိုင်း နင့်ဟို ငါစီရင်မယ်။ ငါဟ ခက်ထန်သူဖြစ်ယွေ့ မိမိမပိုင်လဲ့အရာဟို သိမ်းယူတတ်တာဟို လည်းကောင်း၊ မိမိမစိုက်ပျိုးသည့် အသီးအနှံဟို ရိတ်သိမ်းတတ်တာဟို လည်းကောင်း နင်သိတာမန်ရင်၊ ");
INSERT INTO dnv_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ငါပေးလဲ့ငွေဟို ငါပြန်လာချိန်တွင် အတိုးနဲ့တကွ ပြန်လည်ပေးဆပ်နိန်ရန် ပစာကို့ ဘဏ်တွင် မအပ်ထားလုန်း’ ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","အနီးတွင် ရပ်နေသောသူလို့အား မင်းကြီးဟ ‘အေးသူဆေမှ ဆွေဒင်္ဂါးဟို ယူယွေ့ ဆွေဒင်္ဂါးဆယ်ပြားဆိသူအား ပေးလိုက်ကြ’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","သူလို့ဟ ‘သခင်၊ အဲသူနှိုက် ဆွေဒင်္ဂါးဆယ်ပြားဆိပင်း ဖြစ်ပါအယ်’ ဟု ဆောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","သူဟ ‘နင်လို့ဟို ငါပြောတာဟ ကြွယ်ဝချမ်းသာသူဟို ထပ်ယွေ့ပေးဦးမယ်။ အဲလိုလဲ ဆင်းရဲသောသူဆေမှ ဆိသမျှဟိုပင် သိမ်းယူလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","အဲပင်းရင် ငါ့ရဲ့ အုပ်ချုပ်မှုဟို မခံချင်သော ငါ့ရဲ့ ရန်သူများဟို ဟေနေရာသို့ ခေါ်ယွေ့ ငါ့ရဲ့ ဆေ့မှောက်တွင် သူလို့ဟို သတ်ကြလော့’ ဟု ဆိုအယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","အေးလို မိန့်ပင်းနောက် ကိုယ်တော်ဟ ယေရုရှလင်မြို့သို့ တဘဲ့တော်လို့ဆေ့နှိုက် သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","သံလွင်တောင်ဟု ခေါ်သော တောင်အနီးဆိ ဗက်ဖာဂေရွာနဲ့ ဗေသနိရွာအနီးဟို ရောက်သောအခါ တဘဲ့တော် နေယောက်လို့အား စေလွှတ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“နင်လို့ဆေ့နှိုက် ဆိသော သွားယွေ့ ရွာဟို ဝင်လျှင်ဝင်ချင်း စသူမှ မစီးဖူးသေးသော မြည်းသငယ်တကောင်ဟို မျော်လိမ့်မယ်၊ အဲမြည်းဟို ကြိုးဖြင့်လှန်ထားယွေ့ ကြိုးဟို ဖြေပင်း မြည်းဟို ယူခဲ့လော့။ ");
INSERT INTO dnv_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","အကယ်ယွေ့ လူတစုံတယောက်ဟ နင်လို့အား ‘ပစာကို့ မြည်းကြိုးဟို ဖြေသလော’ ဟု မေးရင် ‘အေးမြည်းဟို သခင် အလိုဆိအယ်’ ဟု ပြောကြမန့်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","စေလွှတ်ခံရသောသူလို့ဟလည်း သွားကြသောအခါ ယေရှု မှာကြားလိုက်လဲ့အတိုင်း တွေ့မျော်ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","သူလို့ဟ မြည်းကြိုးဟို ဖြည်နေစဉ် မြည်းဆှင်ဟ “နင်လို့ ပစာကို့ မြည်းကြိုးဟို လာဖြည်လုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","သူလို့ဟ “ဟေမြည်းဟို သခင် အလိုဆိအယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","အဲပင်းရင် မြည်းဟို ယေရှုဆေဟို ဆောင်ခဲ့ကြအယ်၊ မြည်းပေါ်မှာ မိမိလို့အဝတ်များဟို တင်ပင်းရင် ယေရှုဟို စီးစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ကိုယ်တော် မြည်းစီးယွေ့ ကြွလာစဉ် လူလို့ဟ သူလို့အဝတ်များဟို လမ်းပေါ်တွင် ဖြန့်ခင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ကိုယ်တော်ဟ သံလွင်တောင်ရဲ့ အဆင်းလမ်းအနီးဟို ရောက်သောအခါ တဘဲ့တော်အစုဝေးလို့ဟ မိမိလို့မျော်ခဲ့လဲ့ အံ့ဩဖွယ်သော အမှုအရာအတွက် ဝမ်းမြောက်ရွှင်လန်းလျက် ဘုရားသခင်ဟို ကျယ်သောအသံဖြင့် ချီးမွန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","အေးသူလို့ဟ “ထာဝရဘုရားရဲ့ နာမတော်နဲ့ ကြွလာသောဘုရင်ဟ မင်္ဂလာဆိမန့်စေ၊ ခေါန်းခင်ဘုံတွင် ငြိမ်သက်ခြင်း ဆိမန့်စေ၊ အမြင့်ဆုံးသော ဘုရားသခင်ဟ ဘုန်းကြီးမန့်စေ” ဟု ကြွေးကြော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","အဲအခါ ပရိသတ်အထဲမှ ဖာရိရှဲအချို့လို့ဟ “ဆရာ၊ ကိုယ်တော်ရဲ့ တဘဲ့တော်များအား တိတ်တိတ်နေရန် ဆုံးမပေးပါ” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ယေရှုဟ “နင်လို့ဟို ငါပြောတာဟ သူလို့တိတ်တိတ်နေကြရင် ကျောက်ခဲများဟ ကြွေးကြော်ကြလိမ့်မယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ကိုယ်တော်ဟ ယေရုရှလင်မြို့အနီးသို့ ရောက်ယွေ့ မြို့ဟို မျော်ရင် ငိုကြွေးအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ကိုယ်တော်ဟ “အချင်းမြို့၊ နင်ဟ ငြိမ်းချမ်းမှုဟို ရစေလဲ့လမ်းဟို ခုနေ့သိမျော်ရင် မင်္ဂလာဆိအယ်။ အဲလိုလဲ အခုမှာ နင်ဟအဲလမ်းဟို မသိမမျော်နိန်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","နင့်ရဲ့ ရန်သူများဟ နင့်ပတ်လည်တွင် တပ်တည်ယွေ့ အဖက်ဖက်မှ ဝန်းရံပိတ်ဆို့နေလဲ့ အချိန် ရောက်လာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","သူလို့ဟ နင့်ဟိုလည်းကောင်း၊ နင့်ရဲ့ မြို့ရိုးအတွင်းဆိ လူအပေါင်းလို့ဟို လည်းကောင်း ဖျက်ဆီးသုတ်သင်ကြလိမ့်မယ်။ ကျောက်တခုပေါ်တခုမျှ တင်နေလိမ့်မယ် ဟုတ်မောင့်လဲ့၊ ပစာကို့ နင်ဟ မိမိအား ကယ်တင်ရန် ဘုရားသခင်ကြွလာလဲ့အချိန်ဟို မသိမျော်သောကျောန့် ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","အဲပင်းရင် ယေရှုဟ ဗိမာန်တော်သို့ ဝင်ယွေ့ ဗိမာန်တော်နှိုက် ရောင်းဝယ်သောသူလို့ဟို မောင်းထုတ်လျက်၊ ");
INSERT INTO dnv_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ကိုယ်တော်ဟ သူလို့အား “ ‘ငါရဲ့ အိုင်တော်ဟို ဆုတောင်းရာ အိုင်တော်’ ဟု ကျမ်းစာလာတာ မဟုတ်လော။ အဲလိုလဲ နင်လို့ဟ ဟေဆုတောင်းရာ အိုင်တော်ဟို သူခိုးထားပြတွင်း ဖြစ်စေကြပီ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ယေရှုဟ နေ့တိုင်း ဗိမာန်တော်နှိုက် သွန်သင်လျက်နေအယ်။ ယဇ်ပုရောဟိတ်ကြီးများ၊ ကျမ်းတတ်ဆရာများနဲ့ ယုဒအမျိုးသားအကြီးအကဲများဟ ကိုယ်တော်ဟို သတ်ရန် အခွင့်အရေး ဆာလျက်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","အဲလိုလဲ လူအပေါင်းလို့ဟ ကိုယ်တော်ရဲ့ တရားတော်ဟို စေ့စေ့နားထောင်သောကျောန့် စလိုမှ မလုပ်နိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","တနေ့တွင် ယေရှုဟ ဗိမာန်တော်တွင် လူလို့အား ဆုံးမဩဝါဒပေးယွေ့ သတင်းကောင်းဟို ဟောလျက်နေစဉ် ယဇ်ပုရောဟိတ်ကြီးများ၊ ကျမ်းတတ်ဆရာများနဲ့ အသက်ကြီးသူများဟ သူ့ဆေဟို လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","သူလို့ဟ “ကိုယ်တော်ဟ ဟေအမှုများဟို ပစာအခွင့်နဲ့ ပြုလုန်း။ အေးအခွင့်ဟို စသူပေးလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ယေရှုဟ “ငါဟလည်း နင်လို့ဟို မေးခွန်းတခု မေးအုံးမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ယောဟန် နှစ်ခြင်းမင်္ဂလာပေးတာဟ ဘုရားသခင်ရဲ့ အခွင့်အာဏာလော၊ လူလို့ရဲ့ အခွင့်အာဏာလော ငါ့အား ဖြေကြားကြလော့” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","သူလို့ဟ အချင်းချင်း ဆင်ခြင်ကြလျက် “ဘုရားသခင်ဟ ဖြစ်တာဟု ငါလို့ပြောရင် ‘ယောဟန်ဟို ပစာကို့ မယုံကြည်ကြလုန်း’ ဟု သူမေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","အားပင်မဲ့ လူလို့အခွင့်အာဏာဟု နင်လို့ပြောရင် လူအပေါင်းလို့ဟ ယောဟန်ဟို ပရောဖက်တပါးဟု အမန်ပင် ယုံကြည်ကြသဖြင့် ငါလို့အား ခဲနဲ့ပေါက်ကြလိမ့်မယ်” ဟု အချင်းချင်း ဆွေးနွေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","အဲလိုမို့ သူလို့ဟ “စသူဟ အခွင့်အာဏာပေးတာဟို ငါလို့ သိဝူး” ဟု ဖြေကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","အဲအခါ ယေရှုဟ “ငါပြုလဲ့အမှုအရာများဟို ပစာအခွင့်အာဏာနဲ့ ပြုတာဟိုလည်း နင်လို့အား ငါမပြော” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","အဲပင်းရင် ယေရှုဟ လူလို့အား ပုံဥပမာဖြင့် ပြောသည်မှာ “လူတယောက်ဟ စပျစ်ဥယျာဉ် တခုဟို စိုက်ပျိုးယွေ့ သီးစားချအယ်။ အဲပင်းရင် နိုင်ငံရပ်ခြားသို့ ကာလအတော်ကြာ သွားယွေ့ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","အချိန်တန်သော် ကျွန်တယောက်အား ဥယျာဉ်စောင့်များဆေသို့ စေလွှတ်ယွေ့ သီးစားခဟို တောင်းခံစေအယ်။ အားပင်မဲ့ ဥယျာဉ်စောင့်လို့ဟ အေးကျွန်ဟို ရိုက်ယွေ့ လက်ချည်းဗလာ ပြန်လွှတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","အဲပင်းရင် ဥယျာဉ်ဆှင်ဟ တခြားကျွန်တယောက်ဟို စေလွှတ်ပြန်အယ်။ အားပင်မဲ့ ဥယျာဉ်စောင့်သမားလို့ဟ သူ့ဟိုလည်း ရိုက်ယွေ့ အဆက်ခွဲပင်းရင် လက်ချည်းဗလာ ပြန်လွှတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","နောက်တခါ ဥယျာဉ်ဆှင်ဟ တတိယကျွန်ဟို စေလွှတ်အယ်။ အားပင်မဲ့ ဥယျာဉ်စောင့်လို့ဟ အေးကျွန်ဟိုလည်း ရိုက်နှက်ယွေ့ အပြင်သို့ မောင်းထုတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ဥယျာဉ်ဆှင်ဟ ‘ငါပစာလိုလုပ်ရလုန်း။ ငါ့ရဲ့တဦးထဲသော ချစ်သားဟို စေလွှတ်မယ်။ သူ့ဟို တွေ့ရင် ဥယျာဉ်စောင့်လို့ လေးစားကြလိမ့်မယ်’ ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","အားပင်မဲ့ ဥယျာဉ်စောင့်လို့ဟ အေးသားဟိုမျော်ရင် ‘ဟေသူဟ ဥယျာဉ်ဆှင်ရဲ့ အမွေစား အမွေခံ ဖြစ်အယ်။ ငါလို့ ဥယျာဉ်ဟို အမွေရအောန် သူ့အား သတ်ပလိုက်မယ်’ ဟု အချင်းချင်း တိုင်ပင်ပီးမှ၊ ");
INSERT INTO dnv_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ဥယျာဉ်ဆှင်ရဲ့ သားဟို အပြင်ဟို ထုတ်ပင်းရင် သတ်ပစ်ကြအယ်။ “အဲအခါ ဥယျာဉ်ဆှင်ဟ ဥယျာဉ်စောင့်လို့ဟို စလို လုပ်မလုန်း” ဟု ယေရှုဟ မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“သူဟ လာယွေ့ အေးလူလို့ဟို သတ်ပင်းရင် စပျစ်ဥယျာဉ်ဟို အခြားသူများသို့ ပေးအပ်လိမ့်မယ်။” အေးစကားဟို ကြားသောအခါ လူလို့ဟ “အေးလို့ရီး မဖြစ်ပါစေနဲ့” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ယေရှုဟ သူလို့ဟို ကျေ့လျက် “တိုက်ဟို တည်ဆောက်သောသူများ ‘ပယ်ထားသော ကျောက်ဟ တိုက်ထောင့်ချုပ်ကျောက် ဖြစ်လာရအယ်’ ဟူသော ကျမ်းစကားရဲ့ အဓိပ္ပာယ်ဟ စလို ဆိုလိုလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","အေးကျောက်ပေါ်ဟို ကျသောသူဟ အပိုင်းပိုင်း ကျိုးလိမ့်မယ်၊ တယောက်ယောက်ပေါ်သို့ အေးကျောက်ကျရင် သူဟ ဖုန်မှုန့်ဖြစ်အောန် ကြေသွားလိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ကျမ်းတတ်ဆရာနဲ့ ယဇ်ပုရောဟိတ်ကြီးများဟ မိမိလို့ဟို ရည်စူးယွေ့ အေးပုံဥပမာဟို ပြောကျောန်းဟိုသိသဖြင့် ခုတုံးပင် ကိုယ်တော်ဟို ဖမ်းဆီးရန် ကြံစည်ကြအယ်။ အားပင်မဲ့ လူလို့ဟို ကြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","အေးလို့မို့ သူလို့ဟ အခွင့်အရေးဟို စောင့်နေကြအယ်။ သူလို့ဟ ယေရှုရဲ့ စကားအမားဟို ဆာပင်းရင် ကိုယ်တော်အား ဘုရင်ခံမင်းလက်ဟို အပ်ခွင့်ရနိန်ရန် သူတော်ကောင်းယောင်ဆောင်သော သူလျှိုများဟို သခင့်ဆေဟို စေလွှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","သူလျှိုလို့ဟ ယေရှုအား “ဆရာ၊ ကိုယ်တော် သွန်သင်ချက်များဟ မန်ကန်သင့်မြတ်ပါအယ်။ ကိုယ်တော်ဟ လူ့မျက်နှာဟို မထောက်ဘဲ ဖြောင့်မတ်စွာ ဆုံးမဩဝါဒပေးယွေ့၊ ဘုရားသခင်ရဲ့ တရားလမ်းဟို ဟုတ်မန်လဲ့အတိုင်း သွန်သင်ကျောန်း ငါလို့သိပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ငါလို့အနေဖြင့် ရောမဧကရာဇ်အား အခွန်တော်ပေးခြင်း မပေးခြင်းဟ ငါလို့ ဥပဒေနဲ့ ဆန့်ကျင်ပါသလော” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","အားပင်မဲ့ ယေရှုဟ သူလို့ ပရိယာယ်ဟို သိမျော်နေသဖြင့် သူလို့အား၊ ");
INSERT INTO dnv_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ငွေဒင်္ဂါးတပြားဟို ငါ့အား ပြပါ။ ဟေငွေဒင်္ဂါးတွင် စသူရဲ့ ရုပ်ပုံ၊ စသူ့ ကမ္ပည်းလိပ်စာ ဆိပါသလုန်း” ဟု ပြောအယ်၊ သူလို့ဟ “ကဲသာဘုရင်ရဲ့ပုံ၊ ကဲသာဘုရင်ရဲ့လိပ်စာ ဆိပါလုန်း” ဟု ပြန်ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ယေရှုဟ “ကဲသာဘုရင်ပိုင်လဲ့အရာဟို ကဲသာဘုရင်ဟို ဆက်ကြလော့။ ဘုရားသခင်ပိုင်လဲ့အရာဟို ဘုရားသခင်အား ဆက်ကြပါ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","သူလို့ဟ လူလို့ဆေ့နှိုက် ကိုယ်တော်ရဲ့ စကားတွင် အမားဆာယွေ့ မရသဖြင့် ကိုယ်တော်ပြန်ဖြေသော စကားကျောန့်လည်း အံ့ဩယွေ့ တိတ်တိတ်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","အဲပင်းရင် လူလို့ဟ သေပင်းနောက် ဆှင်ပြန်ထမြောက်ခြင်း မဆိဟု ဆိုကြသော ဇဒ္ဒုကဲအချို့လို့ဟ ယေရှုဆေဟို လာယွေ့ ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ဆရာ၊ ‘လူတယောက်ဟ လူပဲ့သငယ်မရဘဲ သေဆုံးသွားရင် ကျန်ခဲ့လဲ့ဇနီးဟို ညီဖြစ်သူဟ ဆက်လက်ထိမ်းမြားရမယ်၊ မွေးလဲ့ လူပဲ့သငယ်များဟို သူ့အကိုရဲ့ အမျိုးအနွယ်အဖြစ် သတ်မှတ်ရမယ်’ ဟု ငါလို့အား မောရှေရဲ့ ပညတ်ချက်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","တခါတုန်းဟ ညီအကို ခုနစ်ယောက်ဆိအယ်။ အကိုကြီးဟ အိုင်ထောင်ကျပင်း လူပဲ့သငယ်မရဘဲ သေဆုံးသွားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","အေးသူသေသွားသောအခါ သူ့ပေါင်အိုမဟို သူ့ညီအကြီး သိမ်းယူယွေ့ လူပဲ့မဆိဘဲ သေပြန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","အေးလို့မျိုးဖြင့် တတိယလူမှစယွေ့ တယောက်ပင်းတယောက် ခုနေယောက်သော ညီအကိုလို့ဟ အေးမိန်းမဟို သိမ်းယူယွေ့ လူပဲ့မဆိဘဲ သေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","နောက်ဆုံးတွင် အေးမိန်းမလည်း သေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ညီအကို ခုနစ်ယောက်လုံးဟ သူနဲ့ စုံဖက်ခဲ့ကြတာဖြစ်ယွေ့ သေခြင်းမှ ဆှင်ပြန်ထမြောက်ရာနေ့တွင် အေးမိန်းမဟ စသူရဲ့ မိန်းမ ဖြစ်ပါမလုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ယေရှုဟ သူလို့အား “ဟေဖဝါ့နှိုက် ယောက်ျားနဲ့ မိန်းမလို့ဟ လက်ထပ်ထိမ်းမြားခြင်းဟို ပြုတတ်ကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","အဲလိုလဲ သေခြင်းမှ ဆှင်ပြန်ထမြောက်လာပင်း နောင်လာမဲ့ အသက်တာတွင် ဆှင်သန်ရန် ထိုက်တန်သော အမျိုးသားနဲ့ အမျိုးသမီးများဟ ထိမ်းမြားခြင်းဟို မပြုတတ်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","သူလို့ဟ ခေါန်းခင်တမန်များလိုမျိုး သေနိန်ကြမယ် မဟုတ်။ သူလို့ဟ သေခြင်းမှ ဆှင်ပြန်ထမြောက်စေသူများ ဖြစ်သောကျောန့် ဘုရားသခင်ရဲ့ လူပဲ့သငယ်များ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","မီးလျှံထွက်လဲ့ ချုံအကျောန်းဟို ဖော်ပြရာတွင် မောရှေဟ ‘ထာဝရဘုရားဟ အာဗြဟံရဲ့ ဘုရား၊ ဣဇက်ရဲ့ဘုရား၊ ယာကုပ်ရဲ့ဘုရား’ ဟု ခေါ်ယွေ့ သေလွန်သောသူလို့ ဆှင်ပြန်ထမြောက်ခြင်းအကျောန်းဟို ဆှင်းလင်းစွာ ဖော်ပြခဲ့ခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","အေးသူလို့ဟ ဘုရားဆေ့တွင် ထာဝရကာလပတ်လုံး အသက်ဆှင်သူများ ဖြစ်ကြသဖြင့် ဘုရားသခင်ဟ သေလွန်သူလို့ရဲ့ ဘုရား မဟုတ်။ အသက်ဆှင်နေသူလို့ရဲ့ ဘုရား ဖြစ်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ကျမ်းပြုဆရာအချို့လို့ဟ “ဆရာ ကိုယ်တော်ပြောသော စကားများဟာ ဆီလျော်လျောက်ပတ်အယ်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ကျမ်းတတ်ဆရာအချို့လို့ဟ ကိုယ်တော်အား ထပ်မံယွေ့ မမေးမြန်းဝံ့ကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ယေရှုဟ သူလို့အား “မေဆှိယဟ ဒါဝိဒ်ရဲ့ သားမြေး ဖြစ်အယ်ဟု ပစာဟို ဆိုကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ဒါဝိဒ်မင်း တတ်တိုင်းကပင် ဆာလံကျမ်းနှိုက်၊ “ ‘ထာဝရဘုရားဟ ငါ့ရဲ့ သခင်အား နင့်ရဲ့ ရန်သူများဟို နင့်ခြေတင်ရာခုံ အဖြစ် မထားမီ ကာလတိုင်အောန်၊ ");
INSERT INTO dnv_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ငါရဲ့ လက်ယာဖက်နှိုက် ထိန်နေလော့ဟု မိန့်အယ်’ ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ဒါဝိဒ်မင်းဟ ကိုယ်တော်ဟို ‘အဆှင်’ ဟု ခေါ်တာဖြစ်ရာ အေးလို့ မေရှိယဟ ဒါဝိဒ်ရဲ့ သားမြေး ဖြစ်နိန်မလော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","လူအပေါင်းလို့ဟ နားထောင်လဲ့အတိုင်း၊ ယေရှုဟ သူ့တဘဲ့တော်လို့အား ပြောအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ကျမ်းတတ်ဆရာလို့ဟို သတိနဲ့ ဆောင်ကြလော့။ သူလို့ဟ ရှည်သော ဝတ်လုံဟို ဝတ်လျက် လည်ခြင်းငှာ အလိုဆိကြအယ်။ ဆေးတွင် ရိုသေစွာ နှုတ်ဆက်ခံရခြင်းဟို လည်းကောင်း၊ ပွဲသဘင်၊ တရားဇရပ်များတွင် အကောင်းဆုံးသော နေရာထိန်ခင်းများဟို လည်းကောင်း နှစ်သက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","မုဆိုးမများရဲ့ နေအိုင်များဟို မတရားသိမ်းယူပင်းရင် လူအထင်ကြီးစေရန် ရှည်လျားစွာ ဆုတောင်းတတ်ကြအယ်။ သူလို့ဟ ပိုယွေ့ ကြီးလေးသောဒဏ်ဟို စီရင်ခံရကြလိမ့်မယ်” ဟု သွန်သင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ယေရှုဟ ပတ်ပတ်လည်ဆိ ငွေကြေးကြွယ်ဝသော သူလို့ဟ သူလို့ရဲ့ အလှူငွေဟို ဘဏ္ဍာတိုက်ထဲဟို အလှူငွေများ ထည့်ဝင်ကြတာဟို မျော်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ဆင်းရဲသော မုဆိုးမတယောက်ဟလည်း ကြေးပြားနေပြားဟို သွင်းချတာဟို မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ကိုယ်တော်ဟ “ငါအမန်ပြောတာဟ ဆင်းရဲသော မုဆိုးမဟ တခြားသူအပေါင်းလို့ထက် ပိုယွေ့ ထည့်ဝင်လှူဒါန်းလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","တခြားသူလို့ဟ မိမိလို့ရဲ့ ဥစ္စာပစ္စည်းထဲမှ ပေးလှူကြအယ်။ ဟေအမျိုးသမီးကမူ ဆင်းရဲလျက်နဲ့ မိမိရဲ့ ချွေးနှဲစာဆိသမျှဟိုပင် ပေးလှူပီ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","တဘဲ့တော်အချို့လို့ဟ ဗိမာန်တော်ဟ လှပသော ကျောက်တုံးများနဲ့ ပူဇော်ဆက်ကပ်ထားလဲ့ ဝတ္ထုပစ္စည်းများဖြင့် အလွန် လှပတင့်တယ်လျက် ဆိကျောန်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","အဲအခါ ကိုယ်တော်ဟ “နင်လို့ မျော်ခဲ့ကြရလဲ့ အရာအားလုံးလို့ဟ ပြိုကျရလိမ့်မယ်။ ကျောက်တုံးတတုံးမျှ နဂိုနေရာတွင် တင်ယွေ့ မကျန်ရစ်လဲ့တိုင်အောန် ပြိုပျက်ရလဲ့ အချိန်ကာလ ရောက်လိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","သူလို့ဟ “ဆရာ” “ဟေအမှုအရာများဟ ပစာကာလတွင် ဖြစ်ပျက်ပါမလုန်း။ ဟေအမှုအရာများ ဖြစ်ပျက်ချိန်နှိုက် စလို နိမိတ်များ ပေါ်ထွန်းပါမလုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ယေရှုဟ “နင်လို့ဟ လှည့်စားခြင်း မခံရကြစေရန် သတိပြုကြလော့။ အကျောန်းမှာ ငါ့နာမဟို အမှီပြုယွေ့ ‘ငါဟ အဲသူဖြစ်အယ်၊ အချိန်နီးကပ်လာပီ’ ဟု ဆိုလျက် လာကြလိမ့်မယ်။ အေးသူလို့ရဲ့ နောက်ဟို မလိုက်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","နင်လို့ဟ စစ်ပွဲများနဲ့ ပုန်ကန်တော်လှန်မှုသတင်းများဟို ကြားကြသောအခါ မထိတ်လန့်ကြနဲ့။ ဟေအမှုအရာများဟ ဦးရင်ဆုံး ဖြစ်ပျက်ရမယ်၊ အဲလိုလဲ အဆုံးချိန်မှာ မရောက်သေး” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","အဲပင်းရင် ကိုယ်တော်ဟ “လူတမျိုးနဲ့ တမျိုး၊ နိုင်ငံတနိုင်ငံနဲ့တနိုင်ငံ ရန်ဖက်ပြုကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","နေရာအနှံ့အပြားတွင် မြေငလျင်ပြင်းထန်စွာ လှုပ်ခြင်း၊ အစာခေါင်းပါးခြင်း၊ အနာရောဂါကပ်ဆိုက်ခြင်းလို့ ဖြစ်လိမ့်မယ်၊ ခေါန်းခင်တွင် ကြောက်မက်ဖွယ်သောအရာများနဲ့ ကြီးစွာသော နိမိတ်လို့ဟ ပေါ်ထွန်းကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","အဲလိုလဲ ဟေအမှုအရာများ မဖြစ်ပျက်ခင် လူလို့ဟ နင်လို့အား ဖမ်းဆီးညှဉ်းဆဲကြလိမ့်မယ်၊ နင်လို့အား တရားဇရပ်များတွင် တရားစီရင်ရန် အပ်နှံယွေ့ ထောင်များတွင် အကျဉ်းချ ထားကြလိမ့်မယ်၊ နင်လို့ဟ ငါရဲ့နာမကျောန့် ဘုရင်များနဲ့ အာဏာပိုင်များရဲ့ ဆေ့မှောက်သို့ ရောက်ရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ဟေအရာအားဖြင့် နင်လို့ဟ သတင်းကောင်းဟို သက်သေခံရန် အခွင့်ရေးရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","မိမိလို့တတ်တိုင်း ပစာလိုချေပရမယ်ဟို ကြိုတင်ယွေ့ မစိုးရိမ်ဖို့ စိတ်ဟို ဆုံးဖြတ်ထားကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ပစာကို့ နင့်ရန်သူအပေါင်းလို့ဟ မငြင်းခုံ အဲဟာမဟုတ်ရင် မဟန့်တားနိန်သော နှုတ်သတ္တိနဲ့ ဉာဏ်သတ္တိဟို ငါပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","နင်လို့အား နင့်မေ့နဲ့နင့်ဖ၊ ညီအကို၊ မိတ်ဆွေ၊ ဆွေမျိုးသားချင်းများဟ ရန်သူလို့လက်ဟို အပ်လိုက်ကြလိမ့်မယ်၊ အချို့လို့ဟို အသေသတ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","လူအပေါင်းလို့ဟ ငါ့နာမကျောန့် နင်လို့ဟို မုန်းတီးကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","အဲလိုလဲ နင်လို့ ဦးခေါင်းဟ ဆံပင်တပင်မျှ မပျက်စီးရ။ ");
INSERT INTO dnv_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","နင်လို့ဟ တည်ကြည်သောအားဖြင့် နင်လို့ အသက်ဟို ရဆိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ယေရုရှလင်မြို့ဟို စစ်တပ်များ ဝန်းရံပိတ်ဆို့လျက်ဆိတာဟို နင်လို့မျော်သောအခါ အေးမြို့ဟ ပျက်စီးခြင်းသို့ ရောက်လုတာဟို သိမှတ်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","အဲအခါ ယုဒပြေဆိ လူလို့ဟ တောင်များပေါ်သို့ ပြေးစေ၊ မြို့ထဲမှာဆိသူလို့ဟ မြို့ပြင်သို့ ထွက်ကြစေ၊ တောရွာများတွင် ဆိသောသူလို့ဟို မြို့ထဲသို့ မဝင်စေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ပစာကို့ အေးနေ့ရက်ကာလဟ ကျမ်းစာတွင် ပြောထားချက်များ ပြေ့စုံလာစေရန် ‘အပစ်ဒဏ်စီရင်ရာ နေ့ရက်များ’ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","အဲကာလတွင် လူပဲ့စွဲသော အမျိုးသမီးနဲ့ နို့စို့လူပဲ့ဆိသော မိခင်လို့အတွက် အကျိုးနည်းပေလိမ့်မယ်။ ယုဒပြေတွင် ဒုက္ခအကြီးအကျယ်ရောက်ယွေ့ ပြေသူပြေသားလို့အပေါ် ဘုရားသခင်ရဲ့ အမျက်တော် ကျရောက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","အချို့သောသူလို့ဟ ထားဘေးဖြင့် ပျက်စီးခြင်းသို့ ရောက်ကြလိမ့်မယ်။ တချို့အခြားတိုင်းပြေများဟို စစ်သုံ့ပန်းများအဖြစ် ဖမ်းသွားကြလိမ့်မယ်။ လူမျိုးခြားလို့ဟ မိမိလို့ အချိန်ကာလ မပြေ့စုံမချင်း ယေရုရှလင်မြို့ဟို ခြေနဲ့နင်းကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“အဲအခါ နေ၊ လ၊ ကြယ်နက္ခတ်လို့နှိုက် ထူးဆန်းသော နိမိတ်များ ထင်ဆှားလိမ့်မယ်။ ကမ္ဘာပေါ်တွင် လူမျိုးအပေါင်းလို့ဟ ပင်လယ်လှိုင်းတံပိုးကြီးခြင်းကျောန့် ကြောက်ရွံ့စိတ်ပျက်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","လူလို့ဟ ကမ္ဘာပေါ်တွင် ဖြစ်လာလိမ့်မယ်ဖြစ်သော ဘေးများဟို တွေးမျော်ယွေ့ ကြောက်လန့်ကာ မူးဝေကြလိမ့်မယ်၊ အံ့ဖွယ်သော ခေါန်းခင်နက္ခတ်တာရာလို့ဟ တုန်လှုပ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","အဲအခါ မိုးချေးသားဟို စီးယွေ့ ကြီးစွာသော ဘုန်းတန်ခိုးဟို ဆောင်လျက် လူသားကြွလာတာဟို မျော်ရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ဟေအမှုအရာများ ဖြစ်ပျက်လာသောအခါ နင်လို့အား ရွေးနှုတ်ကယ်တင်မယ့် အချိန်ကာလဟ နီးကပ်လာပီ ဖြစ်သောကျောန့် နင်လို့ ခေါင်းဟို မော့ယွေ့ မျော်ကျေ့ကြလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","အဲပင်းရင် ယေရှုဟ သူလို့အား ပုံဥပမာဆောင်ယွေ့ “သင်္ဘောသဖန်းပင်နဲ့ တခြား သစ်ပင်လို့ဟို ကျေ့ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","အဲအပင်များ ရွက်နုပေါက်သောအခါ နွေကာလ နီးတာဟို နင်လို့ဟ ကိုယ့်တတ်တိုင်းကိုယ် နားလည်တတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","အဲလိုမျိုးပင် ဖော်ပြခဲ့သော အကျောန်းအရာများ ဖြစ်ပျက်လျက် ဆိတာဟို တွေ့မျော်ရသောအခါ ဘုရားသခင်ရဲ့ နိုင်ငံတော်တည်လုနီးပီဟု သိမှတ်နားလည်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ငါ အမန်ပြောတာဟ ဟေအမှုအရာအားလုံးတို့ မဖြစ်ပျက်သေးခင် အခု အသက်ဆှင်နေသူအားလုံး သေလွန်ရလိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ခေါန်းခင်နဲ့ မြေကြီး ကွယ်ပျောက်သွားလိမ့်မယ်၊ အဲလိုလဲ ငါ့စကားဟ စလိုမျှ ကွယ်ပျောက်လိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“နင်လို့ဟ ကိုယ်ကိုကိုယ် သတိပြုကြလော့။ အေးလို့မဟုတ် အစားသောက်လွန်ကျူးခြင်း၊ လောကီစိုးရိမ်ခြင်းအားဖြင့် စိတ်နေလုံး ပင်ပန်းလျက်နေစဉ် အဲနေ့ရက်ဟ အမှတ်တမဲ့ နင်လို့ဆေ ရောက်လာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","အေးနေ့ရက်ဟ ကမ္ဘာပေါ်ဆိ လူအပေါင်းလို့ အပေါ်ဟို ရောက်လာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","အေးလိုမို့ ကျရောက်လာလိမ့်မယ် ဖြစ်သော အမှုအရာလို့နဲ့ ကင်းလွတ်ယွေ့ လူသားရဲ့ ဆေ့နှိုက် မတ်တတ်ရပ်နိန်ရန် နိုးနိုးကြားကြား ဆိပင်း အစဉ် ဆုတောင်းလျက် စောင့်နေကြလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ယေရှုဟ နေ့ဖက်တွင် ဗိမာန်တော်နှိုက် ဟောပြောသွန်သင်ပင်းရင် ညနေခင်းများနှိုက် သံလွင်တောင်ဟု နာမယ်တွင်သော တောင်ပေါ်ဟို သွားယွေ့ ညဟို လွန်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","နက်စာစောစောတွင် လူအပေါင်းလို့ဟ ဗိမာန်တော်ဟို သွားယွေ့ ကိုယ်တော်နားတွင် တရားတော်ဟို နားထောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ပသခါပွဲဟု နာမယ်တွင်သော တဆေးမဲ့မုန့်ပွဲတော် ကျင်းပရန် အချိန်နီးကပ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာများဟ လူလို့ဟို ကြောက်သောကျောန့် ယေရှုဟို လျှို့ဝှက်စွာ သတ်ရန် နည်းလမ်းဆာလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","အဲပင်းရင် စာတန်ဟ တဘဲ့တော် တဆယ့်နေယောက် အဝင်ဖြစ်သော ရှကာရုတ်ဟု ခေါ်သော ယုဒရဲ့ စိတ်နေလုံးထဲဟို ဝင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","အေးကျောန့် သူဟ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ဗိမာန်တော်အစောင့် တပ်မှူးများဆေဟို သွားယွေ့ ယေရှုဟို စလိုအပ်ရမလုန်းဟု ဆွေးနွေး တိုင်ပင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","အေးသူလို့ဟ ဝမ်းမြောက်ဝမ်းသာ ဖြစ်ယွေ့ ပိတ်ဆန်ပေးရန် ကတိပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ယုဒရှကာရုတ်ဟ သဘောတူသဖြင့် လူများဟ မသိအောန် ယေရှုအား သူလို့လက်ဟို အပ်ရန် အခွင့်ကောင်းဟို ဆာကြံလျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","တဆေးမဲ့ မုန့်ပွဲတော်တွင် ပသခါ သိုးသငယ်ဟို သတ်ယွေ့ ပူဇော်ရာနေ့ ကျရောက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ယေရှုဟ ပေတရုနဲ့ ယောဟန်လို့ဟို “ငါလို့စားဖို့ ပသခါပွဲ ညစာဟို သွားယွေ့ ပြင်ဆင်ကြလော့” ဟု ညွှန်ကြားချက် ပေးပင်း စေလွှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","သူလို့ဟ “ပစာနေရာနားမှာ ပြင်ဆင်ရမလုန်း” ဟု သူ့ဟို မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ကိုယ်တော်ဟ “နင်လို့ဟ မြို့ထဲဟို ဝင်သောအခါ ယေအိုးဆောင်သောသူဟို တွေ့လိမ့်မယ်။ သူ့နောက်ဟို လိုက်ယွေ့ သူဝင်သော နေအိုင်ထဲဟို လိုက်ဝင်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","အိုင်ဆှင်အား ‘ငါ့ တဘဲ့လို့နဲ့တကွ ပသခါညစာဟို စားသောက်ရန် အခန်းဟ ပစာနားမှာနှင်း’ ဟု ဆရာဟ စုံစမ်းခိုင်းထားကျောန်း ပြောကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","အေးသူဟ ကျကျနနပြင်ထားသော အပေါ်ထပ် အခန်းကြီးဟို ပြလိမ့်မယ်။ အေးအခန်းတွင် ပြင်ဆင်ကြလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","တဘဲ့တော် နေယောက်လို့ဟ ထွက်သွားပင်းနောက် ယေရှု မှာကြားလိုက်လဲ့အတိုင်း တွေ့ဆိကြသဖြင့် ပသခါညစာဟို အသင့်ပြင်ဆင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","အချိန်ရောက်သောအခါ ယေရှုဟ တမန်တော်လို့နဲ့အတူ စားသောက်ရန် စားပွဲနှိုက် ထိန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ကိုယ်တော်ဟ “ငါဟ ဒုက္ခဝေဒနာမခံစားရမီ ဟေပသခါပွဲ ညစာဟို နင်လို့နဲ့ အတူစားရန် ရမ်းဆာ့အလိုဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","နင်လို့ဟို ငါအမန်ဆိုတာဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်တွင် ပြေ့စုံခြင်းသို့ မရောက်မီတိုင်အောန် နောက်တခါ ဟေပွဲဟို ငါလုံးဝ စားမယ်မဟုတ်” ဟု သူလို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","အဲပင်းရင် ယေရှုဟ ယေမုတ်ဟို ယူယွေ့ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟို ချီးမွန်းပင်းရင် “ဟေစပျစ်ယေမုတ်ဟို ယူယွေ့ အချင်းချင်း ဝေမျှယွေ့ သောက်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","နင်လို့ဟို ငါပြောတာဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော် မတည်မချင်း ငါဟ စပျစ်ယေဟို နောက်တဖန်သောက်လိမ့်မယ် မဟုတ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","အဲပင်းရင် ကိုယ်တော်ဟ မုန့်ဟို ယူယွေ့ ကျေးဇူးတော်ဟို ချီးမွန်းပင်းရင် မုန့်ဟို ဖဲ့ယွေ့၊ သူလို့အား ပေးအယ်၊ “ဟေမုန့်ဟ နင်လို့ဖို့ စွန့်သော ငါရဲ့ ခန္ဓာကိုယ် ဖြစ်အယ်။ ငါ့ဟို အောက်မေ့သတိရရန် ဟေသို့ပြုကြလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","အေးနည်းတိုင်းတိုင်းပင် ညစာစားပီးမှ မုတ်ဟို သူလို့အား ပေးယွေ့၊ ပြောတာဟ “ဟေမုတ်မှာ နင်လို့ဖို့ သွန်းသော ငါရဲ့ အသွေးအားဖြင့် တည်သော ဘုရားသခင်ရဲ့ ပဋိညာဉ်တရားသစ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“အဲလိုလဲ သတိပြုကြလော့။ ငါ့ဟို ရန်သူ့လက်ဟို အပ်မယ့်သူဟ ငါနဲ့အတူ စားပွဲမှာ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","လူသားဟ ဘုရားသခင် ခွဲခန့်မှတ်သားထားလဲ့အတိုင်း အသေခံရန် အမန်ပင် သွားရမယ်။ အဲလိုလဲ လူသားဟို ရန်သူလက်ဟို အပ်သောသူဟ အမင်္ဂလာဆိအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","တဘဲ့တော်လို့ဟလည်း အေးအမှုဟို စသူပြုလိမ့်မလောဟု သူလို့တတ်တိုင်း မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","တဘဲ့တော်လို့ဟ မိမိလို့တွင် စသူဟ အကြီးမြတ်ဆုံးဖြစ်လုန်းဟု အငြင်းပွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ယေရှုဟ “လောကီဘုရင်များဟ တပါးအမျိုးသားလို့အပေါ်တွင် အစိုးတရ ပြုတတ်ကြအယ်။ အာဏာပိုင်များဟလည်း မိမိလို့ကိုယ်ဟို ကျေးဇူးဆှင်များဟု အခေါ်ခံတတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","နင်လို့အချင်းချင်းတွင်မှာမူ အေးလို့ မဖြစ်စေသင့်၊ နင်လို့တွင် အကြီးမြတ်ဆုံးဖြစ်သူဟ အငယ်ဆုံးသောသူလိုမျိုး ဖြစ်ရမယ်၊ ခေါင်းဆောင်ဖြစ်သူဟ အစေခံလိုမျိုး ဖြစ်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","စသူဟ ပိုပင်း ကြီးမြတ်လုန်း၊ စားပွဲနှိုက် စားသောက်ရန် ထိန်နေသူလော အဲဟာမဟုတ်ရင် အစေခံသောသူလော။ စားပွဲနှိုက် စားသောက်ရန် ထိန်နေသူလော မဟုတ်လော။ အဲလိုလဲ ငါဟ နင်လို့တွင် အစေခံသောသူလို ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“နင်လို့ဟ ငါနဲ့အတူ စုံစမ်းနှောင့်ယှက်မှုများဟို ကြုံခဲ့ဖူးသူများ ဖြစ်ကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ခမည်းတော်ဟ ငါ့အား အုပ်စိုးခွင့် အပ်လဲ့နည်းတူ ငါဟလည်း နင်လို့အား အုပ်စိုးခွင့်ဟို ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","နင်လို့ဟ ငါရဲ့ နိုင်ငံတော်တွင် ငါရဲ့ စားပွဲနှိုက် စားသောက်ကြရလိမ့်မယ်။ ပင်းနောက် ပလ္လင်များပေါ်မှာ ထိန်လျက် ဣသရေလ တဆယ့်နေမျိုးလို့အား အုပ်ချုပ်ရကြလိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ရှိမုန်၊ ရှိမုန်၊ နားထောင်လော့။ ဂျုံစပါးဟို ဆန်ကာချသလို နင်လို့အားလုံးဟို စစ်ဆေးဖို့ စာတန်ဟ အခွင့်ရလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","အဲလိုလဲ နင့်ရဲ့ ယုံကြည်ခြင်း မဆုံးရှုံးမဲ့အကျောန်း၊ နင့်အတွက် ငါ ဆုတောင်းလေပီ။ နင်ဟ သတိရပြန်သောအခါ နင့်ရဲ့ ညီအကိုလို့ဟို တည်ကြည်စေလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ပေတရုဟ “သခင်၊ ငါဟ ကိုယ်တော်နဲ့အတူ ထောင်ထဲဟို သွားရန်နဲ့ ကိုယ်တော်နဲ့အတူ သေဖို့ အသင့်ဆိပါအယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ယေရှုဟ “ပေတရု၊ နင့်ဟို ငါ ပြောတာဟ ခနေ့ည ကြက်မတွန်ခင် နင်ဟ ငါ့ဟို မသိဟု သုံးကြိမ်မြောက်အောန် ငြင်းဆိုလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","အဲပင်းရင် ယေရှုဟ “ငါဟ နင်လို့ဟို ပိတ်ဆန်အိတ်၊ လွယ်အိတ်နဲ့ ဖိနပ်ဟို မယူစေဘဲ စေလွှတ်သောအခါ နင်လို့တွင် တခုခု ချို့တဲ့ခဲ့သလား” ဟု သူ့တဘဲ့တော်လို့အား မေးအယ်။ သူလို့ဟ “မဆိပါ” ဟု ပြန်ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ယေရှုဟ “အဲလိုလဲ အခု ပိတ်ဆန်အိတ်၊ လွယ်အိတ်ဆိရင် ယူခဲ့ကြ၊ ထားမဆိရင် အဝတ်ဟို ရောင်းယွေ့ ထားဟို ဝယ်ကြစေ။ ");
INSERT INTO dnv_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","နင်လို့ဟို ငါဆိုတာဟ ‘ရာဇဝတ် ကျူးလွန်သူများ စာရင်းတွင် ပါဝင်ရအယ်’ ဟူသော ကျမ်းစကားအတိုင်း ငါနှိုက် ဖြစ်ရမယ်။ ပစာကို့ ငါရဲ့ အကျောန်း ရေးသားထားလဲ့ ကျမ်းစကားအရ ဖြစ်ပျက်လျက် ဆိနေသောကျောန့် ဖြစ်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","တဘဲ့တော်လို့ဟ “သခင်၊ ကျေ့မန့်။ ဟေမှာ ထားနေလက်ဆိပါအယ်” ဟု ပြောအယ်။ ကိုယ်တော်ဟ “တော်လောက်ပီ” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ယေရှုဟ မြို့မှ ထွက်သွားယွေ့ သွားကျင့်ဆိလဲ့အတိုင်း သံလွင်တောင်ပေါ်ဟို သွားလေအယ်။ တဘဲ့တော်လို့ဟ သူနဲ့အတူ လိုက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","အေးနေရာဟို ရောက်သောအခါ ကိုယ်တော်ဟ “နင်လို့ဟ စုံစမ်းသွေးဆောင်ရာသို့ မလိုက်မပါစေရန် ဆုတောင်းကြလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","အဲပင်းရင် သူလို့ဟ ကျောက်ခဲတပစ်ခန့် ကွာသောအရပ်ဟို ကြွသွားယွေ့ ဒူးထောက်လျက်၊ ");
INSERT INTO dnv_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“တို့ဖ၊ အလိုတော်ဆိရင် ဟေဒုက္ခဝေဒနာ မုတ်ဟို ဖယ်ဆှားမန့်။ အဲလိုလဲ ငါ့အလိုအတိုင်း မဟုတ်၊ ကိုယ်တော်ရဲ့ အလိုတော်အတိုင်းသာ ဖြစ်စေမူပါ” ဟု ဆုတောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ခေါန်းခင်ဘုံမှ ခေါန်းခင်တမန်တပါးဟ ကိုယ်တော်ဆေဟို ပေါ်လာယွေ့ အားပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ကိုယ်တော်ဟ ပြင်းပြစွာ ဝေဒနာဟို ခံလျက်ပိုယွေ့ ကြိုးစား ဆုတောင်းလေအယ်၊ သူရဲ့ ချွေးထွက်နေပုံဟ သွေးစက်များသဖွယ် မြေပေါ်သို့ ကျလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ကိုယ်တော်ဟ ဆုတောင်းရာမှ ထယွေ့ တဘဲ့တော်လို့ ဆိရာဟို လဲ့ပြန်လာသောအခါ သူလို့ဟ ဝမ်းနည်း နုံးခွေယွေ့ အိပ်ပျော်နေကြတာဟို မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ကိုယ်တော်ဟ “နင်လို့ဟ ပစာကို့ အိပ်မွေနေကြလုန်း။ ထကြလော့၊ စုံစမ်းသွေးဆောင်ရာဟို မလိုက်ပါစေရန် ဆုတောင်းကြလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ယေရှုဟ မိန့်စဉ် လူအုပ်ကြီး ရောက်လာသောအခါ တဘဲ့တော် ဆယ့်နေပါး အပါအဝင်ဖြစ်သော ယုဒဟ အဲသူလို့ဟို ခေါ်လာအယ်။ သူဟ ယေရှုဟို နမ်းရန် ချဉ်းကပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ယေရှုဟ “ယုဒ၊ နင်ဟ ဟေလို့ နမ်းကယွေ့ လူသားဟို သစ္စာဖောက်မို့လော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","တဘဲ့တော်လို့ဟ အခြေအနေဟို မှန်းမိကြသောအခါ ယေရှုအား “သခင်၊ ငါလို့ဟ ထားဖြင့် ခုတ်ရမလော” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","တဘဲ့တော် တယောက်ဟ ယဇ်ပုရောဟိတ်မင်းရဲ့ ကျွန်တယောက်ဟို ထားဖြင့် ခုတ်သဖြင့် ညာဖက် နားရွက်ပြတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","အဲလိုလဲ ယေရှုဟ “တန့်ကြတော့” ဟု ပြောအယ်၊ အေးသူရဲ့ နားရွက်ဟို လက်တော်ဖြင့် တို့ထိယွေ့ သူ့အနာဟို ပျောက်စေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","အဲပင်းရင် ယေရှုဟ မိမိအား ဖမ်းဆီးရန် ရောက်ဆိလာကြလဲ့ ယဇ်ပုရောဟိတ်ကြီးများ၊ ဗိမာန်တော် အစောင့်တပ်မှူးများနဲ့ လူအကြီးအကဲလို့အား “နင်လို့ဟ ထားပြဟို ဖမ်းသလိုမျိုး ငါ့ဟို ဖမ်းရန် ထားနဲ့ တုတ်များဟို ကိုင်ပင်း လာခဲ့ကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ငါဟ နင်လို့နဲ့ ဗိမာန်တော်မှာ နေ့တိုင်းဆိချိန် ပစာကို့ ငါ့ဟို မဖမ်းကြလုန်း။ အဲလိုလဲ ဟေအချိန်ဟ နင်လို့ရဲ့ အချိန်၊ အမိုက်တန်ခိုးလည်း ဖြစ်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","သူလို့ဟ ယေရှုဟို ဖမ်းဆီးယွေ့ ယဇ်ပုရောဟိတ်မင်းရဲ့ အိုင်တော်ဟို ခေါ်ဆောင်သွားကြအယ်၊ ပေတရုဟ ခပ်ခွာခွာမှ လိုက်လာခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","လူအချို့ဟ အိုင်တော်ဝင်း အလယ်တွင် မီးဖိုယွေ့ ထိန်နေကြအယ်။ ပေတရုဟ သူလို့ရဲ့ အကြားတွင် ဝင်ယွေ့ ထိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ပေတရု ထိန်နေတာဟို အစေခံ မိနီငယ်တယောက်ဟ မျော်သဖြင့် ပေတရုဟို စူးကျေ့ပင်းရင် “ဟေသူဟ ယေရှုနဲ့ ပေါင်းဖော်သူ ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","အဲလိုလဲ ပေတရုဟ “အချင်း မိန်းမ၊ အေးသူဟို ငါသိဝူး” ဟု ခံငြင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","အဲပင်းရင် တအောင့်လောက်ကြာသော် လူတယောက်ဟ ပေတရုဟို မျော်သဖြင့် “နင်ဟလည်း အေးသူလူစုထဲတွင် အပါအဝင် ဖြစ်အယ်” ဟု ပြောအယ်။ အဲလိုလဲ ပေတရုဟ “အချင်းလူ၊ ငါဟ သူလို့ထဲဟ ဟုတ်မောင့်လဲ့” ဟု ပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","အဲပင်းရင် တနာရီလောက် ကြာသောအခါ တခြား လူတယောက်ဟ “ဟေသူဟ ဂါလိလဲပြေသား ဖြစ်သဖြင့် ယေရှုနဲ့ ဟုတ်တတ်ပေါင်းဖော်သောသူ ဖြစ်တာဟို မားစရာမဆိ” ဟု ခိုင်မာစွာ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","အဲလိုလဲ ပေတရုဟ “အချင်းလူ၊ နင်ပြောလဲ့ အကျောန်းအရာဟို ငါ သိမောင့်လဲ့” ဟု ပြန်ပြောအယ်။ အေးလို့ ပေတရု ပြောဆိုနေစဉ် ကြက်တွန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ကိုယ်တော်ဟ လှည့်ယွေ့ ပေတရုဟို ကျေ့လေအယ်။ အဲအခါ ပေတရုဟ “ခုနေ့ည ကြက်မတွန်ခင် နင်ဟ ငါ့ဟို မသိဟု သုံးကြိမ်မြောက်အောန် ငြင်းဆိုလိမ့်မယ်” ဟူသော ကိုယ်တော်ရဲ့ စကားတော်ဟို ပြန်သတိရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ပေတရုဟ အပြင်ဟို ထွက်ယွေ့ ရမ်းဆာ့ဝမ်းနဲစွာ ငိုကြွေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ယေရှုဟို စောင့်ကြပ်နေသူလို့ဟ ကိုယ်တော်အား လှောင်ပြောင်လျက် ဖိုင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","သူလို့ဟ ကိုယ်တော်ရဲ့ မျက်နှာဟို အုပ်ထားပင်းရင် “ကိုယ်တော်အား စသူ ဖိုင်တာဟို ပရောဖက်ပြုပါ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ပင်းနောက် သူလို့ဟ တခြားသော စကားများဖြင့်လည်း ကိုယ်တော်ဟို ပစ်မားကဲ့ရဲ့ယွေ့ ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","မိုးလင်းသောအခါ လူလို့တွင် အကြီးအကဲဖြစ်သောသူများ၊ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာများဟ စုဆုံကြပင်းရင်၊ ယေရှုအား တရားလွှတ်တော်သို့ ခေါ်ဆောင်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","သူလို့ဟ “နင်ဟ မေဆှိယ ဟုတ်လော၊ ငါလို့ဟို ပြောလော့” ဟု ဆိုကြအယ်။ ကိုယ်တော်ဟ “ငါပြောရင် နင်လို့ဟ ငါ့ဟို ယုံကြမှာ ဟုတ်ဝူး၊ ");
INSERT INTO dnv_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","အေးပင်းတော့ ငါဟ မေးခွန်း မေးရင်လည်း နင်လို့ဟ ဖြေကြမှာ ဟုတ်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","အခုခါဟစပင်း လူသားဟ အနန္တတန်ခိုးဆှင် ဘုရားသခင်ရဲ့ လက်ယာဖက်မှာ ထိန်နေလိမ့်မယ်” ဟု ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","အဲသူလို့ဟ “အေးလို့ဆိုရင် နင်ဟ ဘုရားသခင်ရဲ့ သားတော် ဟုတ်လော” ဟု မေးကြအယ်။ ကိုယ်တော်ဟ “နင်လို့ ပြောဆိုကြလဲ့အတိုင်း မန်အယ်” ဟု သူလို့အား ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","အဲအခါ သူလို့ဟ “စလို သက်သေ လိုသေးလို့လုန်း။ တို့တတ်တိုင်းပင် သူရဲ့ စကားဟို ကြားရကြပီ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","အဲပင်းရင် တရားလွှတ်တော်တဖွဲ့လုံးဟ ထယွေ့ ယေရှုအား ပိလတ်မင်းဆေဟို ခေါ်ဆောင်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","အဲပင်းရင် သူလို့ဟ “ဟေသူဟ ပြေသူလို့အား လမ်းလွဲစေရန် ဧကရာဇ်မင်းအား အခွန်တော် မပေးဆက်နဲ့ဟု ပြောဆိုပင်း ကိုယ့်တတ်တိုင်းကိုယ် မေဆှိယ တည်းဟူသော ဘုရင်တပါး ဖြစ်ကျောန်း သူလို့အား ပြောဆိုတာဟို ငါလို့ တွေ့ဆိရပါအယ်” ဟု ကိုယ်တော်ဟို စတင် စွပ်စွဲကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ပိလတ်မင်းဟ ကိုယ်တော်အား “နင်ဟ ယုဒဘုရင် ဟုတ်လော” ဟု မေးအယ်။ ယေရှုဟ “မင်းကြီး မေးလဲ့အတိုင်း မန်အယ်” ဟု ပြန်ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","အဲပင်းရင် ပိလတ်မင်းဟ “ဟေလူအား စွဲချက်တင်ရန် အကျောန်းတစုံတခုမျှ ငါ မတွေ့” ဟု ယဇ်ပုရောဟိတ်ကြီးများနဲ့ လူအပေါင်းလို့အား ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","အဲလိုလဲ သူလို့ဟ “သူရဲ့ သွန်သင်ချက်ကျောန့် ယုဒပြေ တဝှမ်းလုံးဆိ လူများကြားတွင် ရုန်းရင်းဆန်ခတ် ဖြစ်လျက် ဆိအယ်။ ဂါလိလဲပြေနှိုက် စတင်ယွေ့ အခု ဟေအရပ်သို့ ရောက်လေပီ” ဟု ပိုယွေ့ပင် အသံကျယ်စွာ အော်ယွေ့ စွပ်စွဲကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ပိလတ်မင်းဟ ဂါလိလဲဟူသော စကားဟို ကြားရင် “ဟေသူဟ ဂါလိလဲပြေသား ဟုတ်လော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ဟေရုဒ်အုပ်စိုးသော ဂါလိလဲပြေသား ဖြစ်ကျောန်းဟို သိရင် ယေရှုအား ဟေရုဒ်မင်းဆေဟို ပို့ကြအယ်။ အဲအချိန်အခါဟ ဟေရုဒ်မင်း ယေရုရှလင်မြို့မှာ ရောက်ဆိနေလဲ့အချိန် ဖြစ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ဟေရုဒ်မင်းဟ ယေရှုဟို မျော်သောအခါ ရမ်းဆာ့ ဝမ်းသာလေအယ်။ ကိုယ်တော်ရဲ့ သတင်းဟို များစွာ ကြားခဲ့ရသဖြင့် ကိုယ်တော်အား တွေ့မျော်လိုတာ ကြာနေပီ။ ယေရှုပြလဲ့ နိမိတ်လက္ခဏာတခုခုဟို တွေ့မျော်ရလိမ့်မယ်ဟု မျှော်လင့်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ဟေရုဒ်မင်းဟ ယေရှုဟို မေးခွန်းများစွာ မေးအယ် အဲလိုလဲ ကိုယ်တော်ဟ ဖြေကြားခြင်း မဆိပေ။ ");
INSERT INTO dnv_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ကျမ်းတတ်ဆရာများဟ ဆေ့ဟို လာယွေ့ ယေရှုအား အပြင်းအထန် စွပ်စွဲ ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ဟေရုဒ်မင်းနဲ့ သူရဲ့ စစ်သားများဟ ယေရှုအား မထီမဲ့မြင်လုပ်ယွေ့ ကဲ့ရဲ့ကြအယ်၊ အဲပင်းရင် တင့်တယ်သော အဝတ်ဟို ဝတ်စေပင်းရင် ပိလတ်မင်းဆေသို့ သူ့ဟို လဲ့ပြန်ပို့လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","အဲနေ့နှိုက် ပိလတ်မင်းနဲ့ ဟေရုဒ်မင်းလို့ဟ အချင်းချင်း မိတ်ဆွေဖွဲ့ကြအယ်၊ အရင်တုန်းခါဟ သူလို့ဟ ရန်ဖက်ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ပိလတ်မင်းဟ ယဇ်ပုရောဟိတ်ကြီးများ၊ ယုဒခေါင်းဆောင်များနဲ့ ယုဒအမျိုးသားများဟို စုဆုံစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","အေးပင်းနောက် သူလို့အား “ဟေသူဟ ပြေသူလို့ဟို ပုန်ကန်ရန် လှုံ့ဆော်သူဖြစ်တာဟု ဆိုယွေ့ သူ့အား နင်လို့ဟ ငါ့ဆေဟို ခေါ်ခဲ့အယ်။ နင်လို့ဆေ့မှာ ငါ စစ်ဆေးခဲ့ပင်း နင်လို့ တင်သော အပစ်တစုံတခုဟိုမှ အေးသူနှိုက် ငါမတွေ့။ ");
INSERT INTO dnv_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ဟေရုဒ်မင်းဟလည်း မတွေ့။ အေးလိုမို့ သူ့ဟို ငါလို့ဆေဟို ပြန်ပို့စေအယ်။ ဟေသူဟ သေဒဏ်ခံထိုက်သော အပစ်တစုံတရာဟိုမျှ မကျူးလွန်ခဲ့ချေ။ ");
INSERT INTO dnv_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","အေးလိုမို့ သူ့ဟို ကြိမ်ဒဏ်ဖြင့် ဆုံးမယွေ့ လွှတ်လိုက်မယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","လူအုပ်ကြီးဟ “ဟေလူဟို သေဒဏ်ပေးပါ၊ ငါလို့အတွက် ဗာရဗ္ဗဟို လွတ်ငြိမ်းချမ်းသာခွင့်ပေးပါ” ဟု ဝိုင်းအော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","အေးဗာရဗ္ဗမှာ မြို့နှိုက် ပုန်ကန်ခြင်း အပစ်၊ လူအသက်ဟို သတ်ခြင်း အပစ်ကျောန့် ထောင်ထဲကျနေသောသူ ဖြစ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ပိလတ်မင်းဟ ယေရှုအား လွတ်ငြိမ်းချမ်းသာခွင့် ပေးချင်ယွေ့ လူအုပ်ကြီးအား တခါ တင်ပြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","အဲလိုလဲ သူလို့ဟ “သူ့ဟို လက်ဝါးကပ်တိုင်မှာ တင်မန့်၊ သူ့ဟို လက်ဝါးကပ်တိုင်မှာ တင်မန့်” ဟု အော်ဟစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ပိလတ်မင်းဟ “သူဟ စလိုပစ်မှုဟို ကျူးလွန်လို့လုန်း၊ သူ့ဟို သေဒဏ်ပေးထိုက်သော အကျောန်း တခုတလေမှ ငါ မတွေ့။ အေးလိုမို့ သူ့ဟို ကြိမ်ဒဏ်ပေးယွေ့ လွှတ်လိုက်မယ်” ဟု သုံးခါမြောက် ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","အဲလိုလဲ လူလို့ဟ ယေရှုအား လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ရန် အားကုန်အော်က တောင်းဆိုကြသဖြင့် နောက်ဆုံးတွင် တောင်းဆိုချက် ရသွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ပိလတ်မင်းဟ သူလို့တောင်းဆိုချက်အတိုင်း စီရင်ချမှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ပုန်ကန်ထကြွမှု၊ လူသတ်မှုကျောန့် ထောင်ထဲရောက်နေသောသူဟို လူများ တောင်းဆိုလဲ့အတိုင်း လွှတ်ပေးပင်းရင် ယေရှုဟို သူလို့ လုပ်ချင်သမျှအတိုင်း လုပ်ကြစေဖို့ အပ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","စစ်သားများဟ ယေရှုဟို ထုတ်ဆောင်သွားကြချိန်တွင် တောရွာမှလာသော ကုရေနေပြေသား ရှိမုန်ဟို မျော်ကြအယ်။ သူလို့ဟ ရှိမုန်ဟို ဖမ်းဆီးယွေ့ လက်ဝါးကပ်တိုင်ဟို ပေးထမ်းပင်းရင် ယေရှုရဲ့ နောက်တော်မှ လိုက်လာစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","လူအုပ်ကြီးဟ နောက်တော်မှ လိုက်လာကြအယ်။ အမျိုးသမီးအချို့လို့ဟ မိမိလို့ရင်ဖတ်ဟို တီးယွေ့ ငိုကြွေးလျက် လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ယေရှုဟ အေးအမျိုးသမီးလို့ဖက်ဟို လှည့်ယွေ့ “ယေရုရှလင်မြို့သူလို့ ငါ့ဖို့ မငိုကြွေးကြနဲ့။ နင်လို့နဲ့ နင်လို့ လူပဲ့သငယ်များဖို့အတွက်သာ ငိုကြွေးကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‘လူပဲ့မဆိ မြုံသောမိန်းမဟ မင်္ဂလာဆိအယ်။ လူပဲ့ မစွဲဖူးသောဝမ်းနဲ့ လူပဲ့ မစို့ဖူးသော သားမြတ်ဟ မင်္ဂလာဆိအယ်’ ဟု ပြောရသောနေ့ရက်အချိန် ရောက်လာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","အဲအချိန်တွင် လူလို့ဟ တောင်များဟို ‘ငါလို့ အပေါ်ဟို ပြိုလဲကျမန့်’ ဟူယွေ့ လည်းကောင်း၊ တောင်ကုန်းများအား ‘ငါလို့ဟို အုပ်ပလိပ်မန့်’ ဟု ခေါ်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","စိမ်းစိုသော အပင်ဟို ဟေလို့ပြုကြပါဟ ခြောက်သွေ့သော အပင်တွင် စလို ဖြစ်လိမ့်မလုန်း” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ယေရှုနဲ့အတူ ပစ်မှုကျူးလွန်သူ နေယောက်ဟိုလည်း သတ်ဖို့ရန် ထုတ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","“ဦးခေါင်းခွံ” ဟု နာမယ်တွင်သော အရပ်ဟို ရောက်သောအခါ ကိုယ်တော်နဲ့ ရာဇဝတ်သင့်သူများဟို လက်ဝါးကပ်တိုင်မှာ တင်ယွေ့ ညာဖက်တွင် တယောက်၊ ဘယ်ဖက်တွင် တယောက်ထားပင်းရင် လက်ဝါးကပ်တိုင်မှာ ရိုက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ယေရှုဟ “တို့ဖ၊ အဲသူလို့အပစ်ဟို ဖြေလွှတ်ပေးပါ။ သူလို့ဟ မိမိလို့လုပ်နေလဲ့အမှုဟို မသိကြပါ” ဟု မြွက်ဆိုလေအယ်။ သူလို့ဟ ကိုယ်တော်ရဲ့ အဝတ်များဟို မဲနှိုက်ယွေ့ အချင်းချင်း ခွဲယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","လူများလို့ဟ ရပ်လျက် ကျေ့နေကြအယ် ယုဒခေါင်းဆောင်များဟ “ဟေသူဟ အခြားသူလို့ဟို ကယ်တင်ခဲ့အယ်။ ခရစ်တော် တည်းဟူသော ဘုရားသခင် ရွေးချယ်ထားသောသူမန်ရင် ကိုယ့်တတ်တိုင်းကိုယ် ကယ်တင်ပါစေ” ဟု ကဲ့ရဲ့ယွေ့ ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","စစ်သားများဟ ကိုယ်တော်ဟို စပျစ်ယေချဉ်ဟို တိုက်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“နင်ဟ ယုဒဘုရင်ဖြစ်ရင် ကိုယ့်တတ်တိုင်းကိုယ် ကယ်တင်မန့်” ဟု လှောင်ပြောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ကိုယ်တော်ရဲ့ အပေါ်ဘက်နှိုက် “ဟေသူဟ ယုဒ ဘုရင် ဖြစ်အယ်” ဟု ရေးထားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","လက်ဝါးကပ်တိုင်တွင် ရိုက်ထားခြင်း ခံရသူ ရာဇဝတ်သားလို့ထဲမှ တဦးဟ “နင်ဟ ခရစ်တော် မဟုတ်လော။ နင့်တတ်တိုင်း နင်ကယ်ပင်း ငါလို့ဟိုလည်း ကယ်တင်မန့်” ဟု ကဲ့ရဲ့ပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","တခြားတဦးဟ သူ့ဟို ဆုံးမယွေ့ “နင်ဟ သူနဲ့ တူညီသော ပစ်ဒဏ်စီရင်ခြင်းဟို ခံရလျက်၊ ဘုရားသခင်ဟို မကြောက်သလော။ ");
INSERT INTO dnv_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ငါလို့ဟ ကိုယ်ပြုသောအပစ်နဲ့ အလျောက် ခံရတာမို့ တရားသဖြင့် ခံရကြအယ်၊ အဲလိုလဲ သူဟ ပစာအပစ်မှ မကျူးလွန်ခဲ့” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","အဲပင်းရင် ယေရှုအား “ကိုယ်တော် နိုင်ငံတော်တည်လျက် ကြွလာသောအခါ ငါ့ဟို သတိရပါ” ဟု သူဟ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ယေရှုဟ သူ့အား “ငါ အမန်ပြောတာဟ ခုနေ့ပင် နင်ဟ ငါနဲ့အတူ ပရဒိသုဘုံမှာ ဆိလိမ့်မယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","အဲအချိန်မှာ မွန်းတည့်အချိန်လောက် ဖြစ်ယွေ့ အေးအချိန်မှစယွေ့ မွန်းလွဲသုံးနာရီအထိ မြေတပြင်လုံးတွင် နေရောင်အလင်းကွယ်ယွေ့ မိုက်အတိကျရောက်ပင်း ဗိမာန်တော် ကန့်လန့်ကာဟလည်း နေခြမ်းကွဲလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ယေရှုဟ “တို့ဖ၊ ငါရဲ့ ဝိညာဉ်ဟို ကိုယ်တော်ရဲ့ လက်ဟို အပ်အယ်” ဟု ကျယ်လောင်သောအသံဖြင့် အော်ကပင်း အသက်ချုပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ဟေအဖြစ်အပျက်ဟို မျော်သော တပ်မှူးဟ ဘုရားသခင်ရဲ့ ဂုဏ်တော်ဟို ချီးမွန်းလျက် “ဟေသူဟ အမန်ပင် သူတော်ကောင်း ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ဟေအမှုအရာဟို ကျေ့ရန် စုဝေးလာကြသော လူများဟ အေးအဖြစ်အပျက်များဟို မျော်ယွေ့၊ သူလို့အားလုံးဟ နေအိုင်ပြန်ကြပင်း သူလို့ ရင်ဘတ်ဟို တီးခတ်ကာ ဝမ်းနည်းနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ဂါလိလဲပြေမှ နောက်တော်ဟို လိုက်လာကြသော အမျိုးသမီးများ အပါအဝင် ယေရှုဟို သိကျွမ်းသော သူအပေါင်းလို့ဟ အဝေးမှ ရပ်ပင်း ကျေ့နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","ယုဒပြေ အရိမဿဲမြို့သား ယောသပ်ဟုခေါ်သော ယုဒတရားလွှတ်တော် အဖွဲ့ဝင်တဦး ဆိအယ်။ သူဟ သူတော်ကောင်းဖြစ်လျက် ဘုရားသခင်ရဲ့ နိုင်ငံတော်တည်မဲ့ အချိန်ဟို စောင့်မျော်လျက် နေအယ်။ သူဟ တရားလွှတ်တော် အဖွဲ့ဝင်ဖြစ်သော်လည်း တရားလွှတ်တော်ရဲ့ ဆုံးဖြတ်ချက်နဲ့ လုပ်ဆောင်ချက်ဟို သဘောမတူခဲ့ပေ။ ");
INSERT INTO dnv_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","သူဟ ပိလတ်မင်းဆေသို့ သွားယွေ့ ယေရှုရဲ့ အလောင်းဟို တောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","အဲပင်းရင် အလောင်းဟို လက်ဝါးကပ်တိုင်မှ ချယွေ့ ပိတ်ချောဖြင့် ပတ်ရစ်ကာ စသူမျှ မသင်္ဂြိုဟ်ရသော ကျောက်ဆောင်ဟို ထွင်းဟားလဲ့ လုတ်တိုင်းဂူသစ်ထဲတွင် ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","အဲနေ့ဟ သောကြာနေ့ ဖြစ်ယွေ့ ဥပုသ်နေ့ အချိန် နီးလာပီ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ဂါလိလဲပြေမှ ယေရှုနဲ့ လိုက်လာခဲ့ကြသော အမျိုးသမီးများဟလည်း ယောသပ်နောက်ဟို လိုက်ယွေ့ လုတ်တိုင်းဟို လည်းကောင်း၊ ယေရှုရဲ့ အလောင်းဟို စလို ထားတာဟို လည်းကောင်း တွေ့မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","အဲပင်းရင် သူလို့ဟ နေအိုင်ဟို ပြန်ယွေ့ ဆီမွှေးနဲ့ နံ့သာပေါင်းဟို အဆင်သင့်ပြင်ဆင်ကြအယ်။ သူလို့ဟ ပညတ်တော်ဆိလဲ့အတိုင်း ဥပုသ်နေ့တွင် အနားယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","တနင်္ဂနွေ နက်စာအစော မိုးလင်းစချိန်တွင် အေးမိန်းမလို့ဟ သူလို့ အသင့်ပြင်ဆင်ထားလဲ့ နံ့သာပေါင်းဟို ယူယွေ့ လုတ်တိုင်းဆေဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","လုတ်တိုင်းဝဟို ပိတ်ဟားသော ကျောက်တုံးဟို လှိမ့်ဖယ်ထားတာဟို မျော်သဖြင့်၊ ");
INSERT INTO dnv_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ဂူထဲသို့ ဝင်ကြအယ်။ အဲလိုလဲ ယေရှုရဲ့ အလောင်းဟို မမျော်ရကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","အေးလို့မျိုး ရပ်ယွေ့ စိတ်များတုံ့နေစဉ် ပြောင်လက်လဲ့ အဝတ်ဟို ဝတ်ဆင်ထားလဲ့ လူနေယောက်ဟ သူလို့ဆေ့တွင် စပ်ကနဲပေါ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","အမျိုးသမီးများဟ ကြောက်ရွံ့ယွေ့ မြေပေါ်မှာ ပျပ်ဝပ်နေကြအယ်။ အေးသူနေယောက်ဟ “ပစာကို့ နင်လို့ဟ အသက်ဆှင်နေသူဟို သေသောသူလို့ ထားလဲ့အရပ်မှာ ဆာနေကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ကိုယ်တော်ဟ ဟေအရပ်နှိုက် မဆိ၊ ဆှင်ပြန်ထမြောက်ပီ။ ကိုယ်တော်ဟ ဂါလိလဲပြေနှိုက် ဆိစဉ် နင်လို့အား စလို မိန့်ခဲ့တာဟို သတိရကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘လူသားဟ ဆိုးသွမ်းသောသူလို့ လက်နှိုက် အပ်နှံခြင်းဟို ခံရလျက် လက်ဝါးကပ်တိုင်မှာ တင်ခြင်း ခံရပင်း သုံးရက်မြောက်သောနေ့နှိုက် ထမြောက်လိမ့်မယ်’ ဟု မိန့်ခဲ့တာ မဟုတ်လော” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","အဲပင်းရင် အမျိုးသမီးများဟ ကိုယ်တော်ရဲ့ စကားများဟို သတိရယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","လုတ်တိုင်းဆေမှ ပြန်သွားပင်းရင် တဆယ့်နေပါးသော တဘဲ့တော်လို့နဲ့ အခြားသော သူအားလုံးလို့အား အေးအကျောန်းအရာ အလုံးစုံဟို ပြောပြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","အဲအကျောန်းအရာဟို တမန်တော်လို့ဟို ပြောကြားသူများမှာ မာဂဒလရွာသူ မာရိ၊ ယောဟန္န၊ ယာကုပ်ရဲ့ အမေဖြစ်သူ မာရိမှစယွေ့ တခြားသော အမျိုးသမီးများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","အဲလိုလဲ သူလို့ ပြောကြားသော စကားများဟ ယုတ္တိမဆိသောကျောန့် တမန်တော်လို့ဟ မယုံကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","အဲလိုလဲ ပေတရုဟ လုတ်တိုင်းဆေသို့ ပြေးသွားယွေ့ ငုံ့ကျေ့ပင်း ပိတ်စဟ လွဲယွေ့ ပစာမျှ မတွေ့။ အဲကျောန့် သူဟ အေးအဖြစ်ပျက်ဟို အံ့ဩယွေ့ နေအိုင်ဟို ပြန်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","အေးနေ့တွင် တဘဲ့တော် နေယောက်လို့ဟ ယေရုရှလင်မြို့နဲ့ ခုနေမိုင်ဝေးသော ဧမောက် နာမယ်ဆိသော ရွာသို့ သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","သူလို့နေယောက်ဟ ဖြစ်ပျက်ခဲ့ပင်းသော အကျောန်းအရာဟို အချင်းချင်း ဆွေးနွေးပြောဆိုနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","အေးလို့မျိုး ပြောဆိုနေလုန်း ယေရှု တတ်တိုင်း သူလို့နားဟို တိုးသွားယွေ့ သူလို့နဲ့တူတူ သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","အဲလိုလဲ သူလို့ရဲ့ မျက်စေ့ဟို ကာဆီးခြင်း ခံရသဖြင့် သူလို့ဟ ကိုယ်တော်ဟို မမှတ်မိကြ။ ");
INSERT INTO dnv_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ယေရှုဟ သူလို့အား “နင်လို့ဟ ခရီးသွားရင်းနဲ့ ပစာအကျောန်းအရာဟို ပြောနေကြနှင်း” ဟု မေးလေအယ်။ သူလို့ဟ မျက်နှာညှိုးငယ်စွာနဲ့ အဲနေရာတွင် တန်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","အေးသူလို့ထဲတွင် ကလောဖ နာမယ်ဆိသော သူဟ “ယေရုရှလင်မြို့ဟို လာတဲ့ ဧည့်သည်လုပ်ပင်း ခုရက်ပိုင်းထဲ ဖြစ်ပျက်ခဲ့လဲ့ အကျောန်းအရာဟို နင်တယောက်ထဲ မသိသလော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ကိုယ်တော်ဟ “ပစာအကျောန်းလုန်း” ဟု မေးအယ်။ သူလို့ဟ “နာဇရက်မြို့သား ယေရှုနဲ့ဆိုင်တဲ့ အကျောန်းအရာ ဖြစ်အယ်။ သူဟ ဘုရားသခင်နဲ့ လူလို့ဆေ့မှာ နှုတ်သတ္တိ၊ လက်သတ္တိနဲ့ ပြေ့စုံလဲ့ ပရောဖက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ငါလို့ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အကြီးအကဲများဟ သူ့ဟို သေဒဏ်ချမှတ်ဖို့ ပိလတ်မင်းရဲ့ လက်ဟို အပ်ခဲ့အယ်၊ ပင်းတော့ လက်ဝါးကပ်တိုင်မှာ တင်ယွေ့ သတ်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","သူဟ ဣသရေလလူမျိုးဟို လွတ်မြောက်စေမဲ့သူ ဖြစ်အယ်ဟု ငါလို့ မျော်လင့်ထားကြအယ်။ ဒါတွေအားလုံးအပြင် အခု အဖြစ်အပျက်ဖြစ်တာဟ သုံးရက်ဆိပီ။ ");
INSERT INTO dnv_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ငါလို့ရဲ့ အပေါင်းအဖော် အမျိုးသမီးတချို့ဟ ငါလို့ဟို ရမ်းဆာ့အံ့ဩစေခဲ့အယ်၊ သူလို့ဟ နက်စာအစော လုတ်တိုင်းဆေ သွားခဲ့ကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","အားပေမဲ့ ကိုယ်တော်ရဲ့ အလောင်းဟို မျော်ခဲ့ကြဝူး။ သူလို့ဟ ပြန်လာပင်း ယေရှု အသက်ဆှင်လျက် ဆိကျောန်းဟို ခေါန်းခင်တမန်များ ပေးလဲ့ ရူပါရုံ မျော်ရတာဟို ပြောပြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ငါလို့ထဲမှ လူတချို့ဟ လုတ်တိုင်းဆေသို့ သွားကြရာ အမျိုးသမီးများ ပြောခဲ့လဲ့အတိုင်း ဖြစ်အယ်၊ အဲလိုလဲ သူလို့ဟ ကိုယ်တော်ဟို မမျော်ခဲ့ကြမောင့်လဲ့” ဟု ပြန်ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","အဲပင်းရင် ယေရှုဟ “ပရောဖက်များ ဟောပြောသောစကားဟို ယုံကြည်ရန် ရမ်းဆာ့ စိတ်နုံနဲ့သော လူမိုက်လို့၊ ");
INSERT INTO dnv_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ခရစ်တော်ဟ ဘုန်းအသရေဟို မခံယူခင် ဟေလို့ ဒုက္ခဝေဒနာများဟို ခံစားရန် လိုအပ်အယ် ဟုတ်ဝူးလော” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","အဲပင်းရင် ယေရှုဟ မောရှေကျမ်းမှ အစပြုယွေ့ ပရောဖက် ကျမ်းအားလုံးတွင် ကိုယ်တော်အကျောန်းနဲ့ ပတ်သက်လဲ့ ကျမ်းစာများဟို အေးသူနေယောက်လို့ဟို ဆှင်းလင်း ပြောပြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","သူလို့သွားနေလဲ့ ရွာနားဟို ရောက်သောအခါ ယေရှုဟ ဆေ့ဟို ကျော်ယွေ့ သွားမဲ့ဟန် လုပ်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","အဲလိုလဲ သူလို့ဟ “မိုးချုပ်ခါနီးယွေ့ တနေ့တာလည်း ကုန်လုနီးပီ ဖြစ်သောကျောန့် တို့နဲ့ နေမန့်” ဟုဆိုယွေ့ ကိုယ်တော်ဟို ဖိတ်ခေါ်ကြအယ်။ ကိုယ်တော်ဟ သူလို့နဲ့အတူ တည်းရန် လိုက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","စားပွဲတွင် သူလို့နဲ့တူတူ ထိန်လျက် မုန့်ဟိုယူယွေ့ ကျေးဇူးတော်ဟို ချီးမွန်းအယ်၊ အဲပင်းရင် မုန့်ဟိုဖဲ့ယွေ့ သူလို့ဟို ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","အဲပင်းရင် သူလို့ မျက်စေ့ ပွင့်လာကြသဖြင့် ကိုယ်တော်မှန်း သိကြအယ်၊ အဲလိုလဲ ကိုယ်တော်ဟ သူလို့ဆေ့မှ ကွယ်ပျောက် သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","သူလို့ဟ “လမ်းခရီးမှာတုန်းဟ ကိုယ်တော် ငါလို့ဟို စကားပြောသောအခါနဲ့၊ ကျမ်းစာအနက်ဟို ဖွင့်ပြသောအခါတွင် ငါလို့ စိတ်နေလုံးထဲမှာ မီးလျှံထနေသလို ဖြစ်နေခဲ့တာ မဟုတ်လော” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","သူလို့ဟ တန်းထယွေ့ ယေရုရှလင်မြို့ဟို ပြန်ကြပီးမှ၊ တဆယ့်တပါးသော တဘဲ့တော်များနဲ့ အခြားသောသူများ စုံရုံးလျက် နေကြတာဟို မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","စုရုံးနေကြသော သူလို့ဟ “သခင်ဟ တကယ် ထမြောက်ဝါးပီ။ ကိုယ်တော်ဟ ရှိမုန်ဟို ကိုယ်ထင်ပြပီ” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","အဲပင်းရင် သူလို့နေယောက်ဟ လမ်းတွင် ဖြစ်ပျက်ခဲ့လဲ့ အကျောန်းအရာဟို လည်းကောင်း၊ မုန့်ဟို ဖဲ့စဉ်တွင် ကိုယ်တော်မှန်း သိဆိလာကျောန်းဟို သူလို့အား ဆှင်းပြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","အေးအကျောန်းအရာများဟို သူလို့နေယောက် ပြောနေတုန်း ယေရှုဟ သူလို့အလယ်တွင် စပ်ကနဲပေါ်လာယွေ့ “နင်လို့နှိုက် ငြိမ်သက်ခြင်း ဆိပါစေ” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","သူလို့ဟ ကဆေခြောက်နေစာရီးဟု ထင်နေကြသဖြင့် ကြောက်လန့်ယွေ့ တုန်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","အဲလိုလဲ သူလို့ဟို “ပစာကျောန့် ကြောက်နေလုန်း။ ပစာကျောန့် နင်လို့ စိတ်နေလုံးထဲနှိုက် သံသယဖြစ်နေဝလော။ ");
INSERT INTO dnv_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ငါ့လက်နဲ့ ငါ့ခြေဟို ကျေ့ကျေ့မန့်၊ ငါတတ်တိုင်းပင် ဖြစ်အယ်။ ငါ့ဟို စမ်းသပ်ကျေ့မန့်၊ အကျောန်းမှာ ကဆေနှိုက် အရိုးနဲ့ အသား မဆိ၊ ငါနှိုက် နင်လို့ မျော်လဲ့အတိုင်း အရိုးနဲ့ အသား ဆိအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ကိုယ်တော်ဟ ပြောပင်း မိမိရဲ့ လက်နဲ့ ခြေလို့ဟို သူလို့အား ပြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","သူလို့ဟ ရမ်းဆာ့ အံ့ဩဝမ်းသာ ဖြစ်ယွေ့ မယုံနိန်ကြသေးဘဲ ဖြစ်နေကြချိန်တွင် ကိုယ်တော်ဟ “နင်လို့မှာ ပစာစားဖို့ ဆိလုန်း” ဟု သူလို့အား မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","သူလို့ဟ ငါးကင်တပိုင်းဟို ကိုယ်တော်အား ပေးကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ကိုယ်တော်ဟ ယူယွေ့ သူလို့ဆေ့မှာ စားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","အဲပင်းရင် ကိုယ်တော်ဟ သူလို့အား “နင်လို့နဲ့တူတူ ဆိနေစဉ် နင်လို့အား ငါပြောခဲ့သော စကားများမှာ မောရှေရဲ့ ပညတ်ကျမ်း၊ ပရောဖက် ကျမ်းများနဲ့ ဆာလံကျမ်းတွင် ငါရဲ့ အကျောန်းနဲ့ ပတ်သက်ယွေ့ ရေးထားသမျှလို့ဟ ပြေ့စုံခြင်းသို့ ရောက်ရမယ် ဖြစ်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","အဲပင်းရင် ကိုယ်တော်ဟ ကျမ်းစာတော်ဟို နားလည်ကြစေရန် သူလို့အသိဉာဏ်ဟို ဖွင့်ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ပင်းနောက် သူလို့အား မိန့်တာဟ “ကျမ်းစာတွင် မေဆှိယဟ ဒုက္ခဝေဒနာ ခံစားရယွေ့ သုံးရက်မြောက်နေ့မှာ သေခြင်းမှ ထမြောက်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","နာမတော်ဟို အမှီပြုယွေ့ နောင်တရခြင်းတရားနဲ့ အပစ်ဖြေလွှတ်ခြင်း တရားဟို ယေရုရှလင်မြို့မှ အစပြုယွေ့ လူမျိုးအပေါင်းလို့ဟို ဟောပြောရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","နင်လို့ဟ ဟေအကျောန်းအရာများနဲ့ ပတ်သက်ပင်း မျက်မြင် သက်သေများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ငါ့ ခမည်းတော် ကတိထားခဲ့လဲ့အရာဟို နင်လို့ပေါ် ငါ စေလွှတ်လိမ့်မယ်။ အဲလိုလဲ နင်လို့ဟ ခေါန်းခင်ဟ တန်ခိုးဟို မခံရသေးခင်ထိ ယေရုရှလင်မြို့မှာ ငံ့နေကြလော့” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","အဲပင်းရင် ကိုယ်တော်ဟ သူလို့အား ဗေသနိရွာတိုင်အောန် မြို့ပြင်ဟို ယိုးသွားယွေ့ သူ့လက်ဟို မြောက်ယွေ့ ကောင်းချီး ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ဟေသို့ ကောင်းချီးပေးနေစဉ် ကိုယ်တော်ဟ သူလို့ဆေမှ ထွက်ခွာယွေ့ ခေါန်းခင်ဘုံသို့ ဆောင်ယူခြင်းဟို ခံလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","တဘဲ့တော်လို့ဟ ကိုယ်တော်ဟို ပျပ်ဝပ်ကိုးကွယ်ပင်းရင် ရမ်းဆာ့ ဝမ်းမြောက်ဝမ်းသာ ဖြစ်လျက် ယေရုရှလင်မြို့ဟို ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","သူလို့ဟ ဗိမာန်တော်နှိုက် ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟို အစဉ် ချီးမွန်းလျက် နေကြအယ်။");
INSERT INTO dnv_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","အစဦးနှိုက် နှုတ်ကပတ်တော် ဆိအယ်၊ နှုတ်ကပတ်တော်ဟ ဘုရားသခင်နဲ့အတူ ဆိအယ်၊ နှုတ်ကပတ်တော်ဟလည်း ဘုရားသခင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","နှုတ်ကပတ်တော်ဟ အစဦးနှိုက် ဘုရားသခင်နဲ့အတူ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ခပ်သိမ်းသောအရာလို့ဟ နှုတ်ကပတ်တော်အားဖြင့် ဘုရားသခင် ပြုလုပ်အယ်၊ ဖန်ဆင်းခြင်းနဲ့ ကင်းလွတ်လျက် ဖြစ်သောအရာ တစုံတခုမျှ မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","အဲနှုတ်ကပတ်တော်ဟ အသက်ရဲ့ အရင်းအမြစ် ဖြစ်အယ်၊ အေးအသက်ဟ လူလို့ဆေ အလင်းဟို ယူဆောင်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","အဲအလင်းဟ မိုက်ထဲတွင် တောက်ပယွေ့ မိုက်ဟ အဲအလင်းဟို စလိုမှ မဖုံးကွယ်နိန်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ဘုရားသခင်ဆေမှ စေလွှတ်ခံရလဲ့ ယောဟန် နာမယ်ဆိသော လူတဦး ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","လူအပေါင်းလို့ဟ သူ့အားဖြင့် ယုံကြည်လာမဲ့အကျောန်း သူဟ အလင်းအကျောန်းဟို သက်သေခံရန် သက်သေအဖြစ် လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","သူဟ အဲအလင်း မဟုတ်၊ အလင်းအကျောန်း သက်သေခံရန် လာသောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","အဲအလင်းဟ လောကဟို ကြွလာယွေ့ လူသားအပေါင်းလို့ပေါ်တွင် တောက်ပလဲ့ — စစ်မန်သော အလင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","အဲနှုတ်ကပတ်တော်ဟ ဟေလောကနှိုက် ဆိအယ်၊ ဟေလောကဟ သူ့အားဖြင့် ဖြစ်လာသော်လည်း လောကဟ ကိုယ်တော်ဟို အသိမှတ်မပြုဝူး။ ");
INSERT INTO dnv_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ကိုယ်တော်ဟ မိမိမွေးဖွားရာပြေဟို ကြွလာသော်လည်း မိမိရဲ့ လူမျိုးများဟ ကိုယ်တော်ဟို လက်မခံကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","အဲလိုလဲ ကိုယ်တော်ဟို လက်ခံသမျှသောသူတည်းဟူသော ကိုယ်တော်ရဲ့ နာမဟို ယုံကြည်သောသူလို့အား ဘုရားသခင်ရဲ့ လူပဲ့သငယ်ဖြစ်ခွင့်ဟို ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","သူလို့ဟ သဘာဝနည်းလမ်းဖြင့် ဘုရားသခင်ရဲ့ လူပဲ့သငယ် ဖြစ်လာကြတာ မဟုတ်၊ အဲဟာဟ လူသား အဖတဦးရဲ့ လူပဲ့သငယ်အဖြစ် မွေးဖွားလာခြင်းဖြင့် ဘုရားသခင် တတ်တိုင်းဟ သူလို့ရဲ့ အဖ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","နှုတ်ကပတ်တော်ဟ လူသားအဖြစ် ခံယူယွေ့ ကျေးဇူးတော်နဲ့ သမ္မာတရားဟို ပြေ့စုံလျက် ငါလို့ထဲတွင် ကျိန်းဝပ်အယ်။ ငါလို့ဟ ကိုယ်တော်ရဲ့ ဘုန်းအသရေဟို မျော်ကြရအယ်၊ အဲဘုန်းအသရေဟ ခမည်းတော်ရဲ့ တပါးတည်းသော သားတော်အဖြစ် ခံယူရဆိလဲ့ ဘုန်းအသရေ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ယောဟန်ဟ ကိုယ်တော်အကျောန်းဟို သက်သေခံအယ်။ သူဟ “‘ငါ့နောက်ကြွလာသူပေမဲ့လည်း ငါ့ထက် ကြီးမြတ်အယ်၊ ပစာကို့ ကိုယ်တော်ဟ ငါမမွေးခင်ရင်း ဆိနေတာ ဖြစ်အယ်’ ဟု ငါပြောခဲ့သူဟ အေးသူပင် ဖြစ်အယ်” လို့ ကြွေးကြော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ကိုယ်တော်ရဲ့ ကျေးဇူးတော်ဟ ပြေ့စုံကြွယ်ဝတာနဲ့အညီ ငါလို့အား ကောင်းချီးမင်္ဂလာ တခုပင်းနောက် တခု ချပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ဘုရားသခင်ဟ ပညတ်တရားဟို မောရှေအားဖြင့် ပေးအယ်၊ အဲလိုလဲ ကျေးဇူးတော်နဲ့ သမ္မာတရားဟ ယေရှုခရစ်အားဖြင့် ဖြစ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ဘုရားသခင်ဟို စသူမှ မမျော်ဖူးဝူး။ ဘုရားသခင်နဲ့ တူယွေ့ ခမည်းတော်ဘက်နှိုက် ဆိသော တပါးတည်းသော သားတော်ဟ ဘုရားသခင်ဟို သိစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","အခု ယေရုရှလင်မြို့ဆိ ယုဒ အာဏာဆိသောသူလို့ဟ ယဇ်ပုရောဟိတ်နဲ့ လေဝိအနွယ်ဝင် အချို့လို့ဟို ယောဟန်ဆေ စေလွှတ်ယွေ့ “နင်ဟ စသူတုန်း” လို့ သူ့ဟို မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","သူဟ ဝန်ခံပင်း မငြင်းဘဲ “ငါဟ ခရစ်တော် မဟုတ်” လို့ ဝန်ခံခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","သူလို့ဟ “အဲကျောန့် နင်ဟ စသူတုန်း၊ ဧလိယ ဖြစ်သလော” လို့ မေးကြအယ်။ ယောဟန်ဟ “ငါဟ ဧလိယ မဟုတ်” ဟု ဆိုအယ်။ သူလို့ဟလည်း “နင်ဟ ပရောဖက်လော” လို့ မေးကြအယ်။ သူဟ “မဟုတ်ဝူး” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","သူလို့ဟလည်း “နင်ဟ စသူဖြစ်တုန်း၊ ငါလို့ဟို စေလွှတ်လိုက်သူလို့အား ပြန်ပင်း ဖြေနိန်ရန် နင်အကျောန်းဟို နင် စလိုပြောမှာတုန်း” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ယောဟန်ဟ ပရောဖက် ဟေရှာယ ဖော်ပြခဲ့လဲ့အတိုင်း၊ “ငါဟ ‘ထာဝရဘုရားရဲ့ လမ်းခရီးအတွက် ဖြောင့်တန်းအောန် ပြုကြလော့ တောကန္တာရနှိုက် ဟစ်ကြော်နေသောသူရဲ့ အသံ ဖြစ်အယ်’” လို့ ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ဖာရိရှဲလို့ထဲမှ စေလွှတ်ခြင်းခံရသော သတင်းသယ်ဆောင်သူများဟ၊ ");
INSERT INTO dnv_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“နင်ဟ မေဆှိယ မဟုတ်၊ ဧလိယလည်း မဟုတ်၊ ပရောဖက်လည်း မဟုတ် ပစာကျောန့် နှစ်ခြင်းမင်္ဂလာဟို ပေးတာတုန်း” လို့ သူ့ဟို မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ယောဟန်ဟလည်း “ငါဟ ယေနဲ့ နှစ်ခြင်းမင်္ဂလာဟို ပေးအယ်၊ အဲလိုလဲ နင်လို့အလယ်မှာ နင်လို့မသိလဲ့ သူတယောက် ရပ်လျက် ဆိနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","အဲသူဟ ငါ့နောက်တွင် ကြွလာသောသူ ဖြစ်အယ်၊ အဲလိုလဲ ငါဟ သူ့ဖိနပ်ကြိုးတောင် မဖြည်ထိုက်” လို့ ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ယောဟန် နှစ်ခြင်းမင်္ဂလာပေးရာ ယော်ဒန်မြစ် အဆေ့ဖက်ကမ်းဆိ ဗေသနိရွာမှာ အေးအမှုအရာ ဖြစ်ပျက်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","နောက်နေ့နှိုက် သူ့ဆေဟို ယေရှု ကြွလာတာဟို မျော်ရင် ယောဟန်ဟ “လောကသားလို့ရဲ့ အပစ်ဟို ယူဆောင်သွားသော ဘုရားသခင်ရဲ့ သိုးသငယ်ဟို ကျေ့ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‘ငါ့နောက်ကြွလာသူပေမဲ့လည်း ငါ့ထက် ကြီးမြတ်အယ်၊ ပစာကို့ ကိုယ်တော်ဟ ငါမမွေးခင်ရင်း ဆိနေတာ ဖြစ်အယ်’ ဟု ငါပြောခဲ့သူဟ အေးသူပင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ကိုယ်တော်ဟ စသူဖြစ်တာဟို မခင်ဟ ငါမသိ၊ အဲလိုလဲ ဣသရေလအမျိုးသားလို့ သူ့ဟို သိဆိနိန်ကြစေရန် ငါဟ ယေနဲ့ နှစ်ခြင်းမင်္ဂလာဟို ပေးခြင်း ဖြစ်အယ်” လို့ ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","အဲပင်းရင် ယောဟန် သက်သေခံတာဟ “ဝိညာဉ်တော်သည် ချိုးတူးမလိုမျိုးနဲ့ ခေါန်းခင်မှ ဆင်းလာပင်း ကိုယ်တော်အပေါ်မှာ နားတာဟို ငါမျော်ရပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ကိုယ်တော်ဟ စသူဖြစ်တာဟို အခုထိ ငါမသိ၊ အဲလိုလဲ ယေဖြင့် နှစ်ခြင်းပေးရန် ငါ့ဟို စေလွှတ်သော ဘုရားသခင်ဟ ‘ဝိညာဉ်တော်သည် ဆင်းသက်ယွေ့ သူ့အပေါ်မှာ နားတာဟို နင်မျော်ရလိမ့်မယ်၊ အဲသူဟ သန့်ဆှင်းသော ဝိညာဉ်တော်နှိုက် နှစ်ခြင်းပေးသောသူ ဖြစ်အယ်’ လို့ ငါ့အား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ငါမျော်ရပီဖြစ်ယွေ့ ဟေသူဟ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ကျောန်းဟို ငါသက်သေခံအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","နောက်တနေ့နှိုက် အဲနေရာမှာ ယောဟန်ဟ မိမိရဲ့ တဘဲ့နေယောက်နဲ့အတူ ရပ်နေစဉ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ယေရှုကြွလာတာဟို မျော်သောအခါ သူဟ “ဘုရားသခင်ရဲ့ သိုးသငယ်ဟို ကျေ့လော့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","အဲလို သူပြောတာဟို တဘဲ့နေယောက်လို့ဟ ကြားသောအခါ ယေရှုရဲ့ နောက်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ယေရှုဟ နောက်သို့လှည့်ယွေ့ ကျေ့ရာ အေးသူလို့ လိုက်လာတာဟို မျော်ရင် “နင်လို့ ပစာဟို အလိုဆိကြတုန်း” လို့ မေးအယ်။ အေးသူလို့ဟ “ရဗ္ဗိ၊ ကိုယ်တော်ဟ ပစာနားမှာ နေလုန်း” ဟု ပြောအယ်၊ (ရဗ္ဗိအနက်မှာ “ဆရာ” ဟု ဆိုလိုအယ်။) ");
INSERT INTO dnv_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ကိုယ်တော်ဟ “လာယွေ့ ကျေ့ကြလော့” လို့ ဖြေအယ်။ အေးအချိန်ဟ ညခင်းလေးနာရီခန့်လောက် ဖြစ်အယ်။ အဲလိုမို့ သူလို့ဟ လိုက်ယွေ့ ကိုယ်တော်နေရာအရပ်ဟို မျော်ပင်း ကိုယ်တော်နဲ့အတူ အဲနေ့နှိုက် အတူနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ယောဟန် စကားဟို ကြားယွေ့ ကိုယ်တော်ရဲ့ နောက်ဟို လိုက်သွားသောသူ နေယောက်ထဲမှ တယောက်မှာ ရှိမုန် ပေတရုရဲ့ ညီအန္ဒြေ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","သူဟ အကိုဖြစ်သူ ရှိမုန်ဟို ဦးရင် ဆှာယွေ့ “မေဆှိယဟို ငါတွေ့ပီ” ဟု ပြောအယ်၊ မေဆှိယအနက်မှာ “ခရစ်တော်” ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","အဲပင်းရင် သူဟ ရှိမုန်အား ယေရှုဆေဟို ခေါ်သွားအယ်။ ယေရှုဟ ရှိမုန်ဟို ကျေ့ယွေ့ “နင်နာမယ်ဟ ယောဟန်သား ရှိမုန် ဖြစ်အယ်၊ အဲလိုလဲ နင့်ဟို ကေဖဟု ခေါ်ရလိမ့်မယ်” ဟု ပြောအယ်။ ကေဖဟ ပေတရုဟု နာမယ်နဲ့တူတူ ဖြစ်ယွေ့ “ကျောက်” ဟု အနက်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","နောက်တနေ့နှိုက် ယေရှုဟ ဂါလိလဲပြေသို့ ထွက်ခွာရန် ဆုံးဖြတ်ခဲ့အယ်။ ဖိလိပ္ပုဟို တွေ့ရင် ကိုယ်တော်ဟ “ငါ့နောက်ဟို လိုက်လော့” မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ဖိလိပ္ပုဟ ဗက်ဇဲဒမြို့မှ ဖြစ်အယ်၊ ဗက်ဇဲဒမြို့ဟ အန္ဒြေနဲ့ ပေတရုလို့ နေထိန်သောမြို့ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ဖိလိပ္ပုဟ နာသနေလဟို တွေ့သဖြင့် “မောရှေရဲ့ ပညတ်ကျမ်းနဲ့ ပရောဖက်ကျမ်းများတွင်လည်း ရေးသားဖော်ပြထားသူဟို ငါလို့ တွေ့ပီ။ အေးသူဟ ယောသပ်ရဲ့ သား၊ နာဇရက်မြို့မှ ယေရှု ဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","နာသနေလဟ “နာဇရက်မြို့မှ ကောင်းလဲ့အရာ တစုံတခု ထွက်ပေါ်နိန်ပါသလော” လို့ မေးအယ်။ ဖိလိပ္ပုဟ “လာယွေ့ ကျေ့မန့်” လို့ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ယေရှုဟ သူ့ဆေဟို နာသနေလ လာနေတာ မျော်သောအခါ သူဟ “ဟေမှာ ဣသရေလအမျိုးသားစစ် ဖြစ်အယ်၊ သူ့တွင် ပစာအမားမျှ မဆိမန့်” လို့ ကိုယ်တော်အကျောန်းဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","နာသနေလဟ “ကိုယ်တော် စလို ငါ့ဟို သိတုန်း” လို့ ကိုယ်တော်အား မေးအယ်။ ယေရှုဟ “နင့်အား ဖိလိပ္ပု မခေါ်ခင် သင်္ဘောသဖန်းပင်အောက်မှာ ဆိနေခါ နင့်ဟို ငါမျော်အယ်” လို့ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","နာသနေလဟ “ဆရာ၊ နင်ဟ ဘုရားသခင်ရဲ့ သားတော် ဖြစ်အယ်၊ ဣသရေလအမျိုးသားလို့ရဲ့ ဘုရင် ဖြစ်အယ်” လို့ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ယေရှုဟ “သင်္ဘောသဖန်းပင်အောက်တွင် နင့်ဟို ငါမျော်အယ်ဟု ဆိုသောကျောန့် နင် ယုံကြည်သလော။ အေးထက်ပိုယွေ့ ကြီးမြတ်သောအရာလို့ဟို နင် မျော်ရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","နင်လို့အား ငါ အမန်ပြောတာဟ ခေါန်းခင်ပွင့်လျက် လူသားအပေါ်တွင် ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန်များ ဆင်းလျက် တက်လျက်နေကြတာဟို နင်လို့ မျော်ရကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","နောက်နေရက်ပင်းနောက် ဂါလိလဲပြေ ကာနမြို့မှာ မင်္ဂလာဆောင်ပွဲ ကျင်းပအယ်။ အဲနေရာဟို ယေရှုရဲ့ အမေ့ လာရောက်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ယေရှုနဲ့ သူ့ရဲ့ တဘဲ့တော်လို့လည်း အေးပွဲသို့ ဖိတ်ခြင်းဟို ခံရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","စပျစ်ယေ ကုန်သွားသောအခါ ယေရှုရဲ့ အမေ့ဟ “အေးသူလို့မှာ စပျစ်ယေ မဆိတော့ဝူး” လို့ ယေရှုအား ပြောကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ယေရှုဟ “ငါ ပစာ လုပ်ရမယ်ဆိုတာဟို နင်ပြောဖို့ မလိုဝူး၊ ငါ့အချိန် မရောက်သေးဝူး” လို့ ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","အဲအခါ ယေရှုရဲ့ အမေ့ဟ အစေခံလို့အား “သူစေခိုင်းလဲ့အတိုင်း လုပ်ဆောင်ကြလော့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ယုဒအမျိုးသားလို့ရဲ့ ထုံးတမ်းစဉ်လာစလေ့အရ သန့်စင်မှုဟို ပြုရန် ရည်ရွယ်ချက်ဖြင့် ကျောက်အိုးကြီး ခြောက်လုံးဟို ထားအယ်၊ အဲယေအိုးတလုံးစီဟ ဂါလံနေဆယ်နဲ့ သုံးဆယ်ခန့်လောက် ဆန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ယေရှုဟ “အေးအိုးများတွင် ယေအပြေ့ ထည့်ကြလော့” လို့ အစေခံလို့အား မိန့်အယ်။ သူလို့ဟ အိုးအဝထိ ယေပြေ့အောန် ထည့်ကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","အဲပင်းရင် ကိုယ်တော်ဟ “အေးအိုးများမှ အခု ယေ ကတစ်ဟို ခပ်ယွေ့ ပွဲအုပ်ဆေ ယူသွားကြလော့” ဟု သူလို့အား မိန့်အယ်။ သူလို့ဟ ပွဲအုပ်ဆေဟို ယေ ယူသွားအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ပွဲအုပ်ဟ စပျစ်ယေအဖြစ် ပြောင်းလဲလာသောယေဟို မြည်းကျေ့အယ်။ အစေခံလို့ဟ စပျစ်ယေဟို ပစာမှ ရဆိကျောန်းဟို သိကြသော်လည်း ပွဲအုပ်မှာ မသိ၊ အဲလိုလဲ ပွဲအုပ်ဟ မင်္ဂလာဆောင်သတို့သားဟို ခေါ်ပင်းရင်၊ ");
INSERT INTO dnv_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“လူတိုင်းဟို စပျစ်ယေကောင်းနဲ့ အဦးဆုံး ဧည့်ခံတတ်အယ်၊ ဧည့်သည်လို့ ရမ်းဆာ့ မူးပင်းနောက် စပျစ်ယေအညံ့ဟို ထည့်ပေးလေ့ ဆိအယ်။ အဲလိုလဲ နင်ဟ စပျစ်ယေကောင်းဟို အခုထိ သိမ်းထားပီ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ယေရှုဟ ဟေဦးရင်ဆုံးသော နိမိတ်လက္ခဏာဟို ဂါလိလဲပြေ ကာနမြို့တွင် ပြုလျက် ကိုယ်တော်ဟ မိမိရဲ့ ဘုန်းအသရေဟို ထင်ဆှားစေအယ်၊ သူ့ရဲ့ တဘဲ့တော်လို့ဟ ကိုယ်တော်ဟို ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","အဲဟာပင်းနောက် ယေရှုနဲ့ သူ့အမေ့၊ ညီအကိုများနဲ့ တဘဲ့တော်လို့ဟ ကပေရနောင်မြို့ဟို ကြွယွေ့ ရက်ကတစ် နေထိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ယုဒအမျိုးသားလို့ရဲ့ ပသခါပွဲ နီးကပ်လာသောအခါ ယေရှုဟ ယေရုရှလင်မြို့ဟို သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ယေရှုဟ ဗိမာန်တော်အတွင်းတွင် နွားများ၊ သိုးများ၊ ချိုးတူးငက်များဟို ရောင်းသူများနဲ့ ငွေလဲလှယ်နေသူများ စားပွဲနှိုက် ထိန်နေတာဟို တွေ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","အဲအခါ ကြိုးနဲ့ ကျာပွတ်ဟို ပြုလုပ်ပင်း သိုး၊ နွားနဲ့တကွ အဲလူအားလုံးဟို ဗိမာန်တော်ထဲမှ မောင်းထုတ်အယ်၊ ငွေလဲလှယ်သူလို့ရဲ့ ငွေများဟို မောက်ချယွေ့ သူလို့ရဲ့ စားပွဲများဟို လောပစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ကိုယ်တော်ဟ ချိုးတူးငက်လို့ ရောင်းသူများအား “ဟေအရာများဟို ယူသွားကြ၊ တို့ဖရဲ့ အိုင်တော်ဟို ဆေး မဖြစ်စေနဲ့” မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","သူ့ရဲ့ တဘဲ့တော်လို့ဟ “ကိုယ်တော်ရဲ့ အိုင်တော်အတွက် စိတ်အားထက်သန်ခြင်းဟ ငါ့ဟို လွှမ်းမိုးလျက် ဆိအယ်” ဟူသော ရေးထားတာဟို သတိရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ယုဒအာဏာပိုင်လို့ဟ မေးခွန်းများနဲ့ ကိုယ်တော်ဆေဟို ပြန်လာပင်း “နင်ဟ ဟေအမှုအရာများဟို ပြုလုပ်ပိုင်ကျောန်း သိသာစေရန် ငါလို့အား ပစာ နိမိတ်လက္ခဏာဟို ပြမှာတုန်း။” ");
INSERT INTO dnv_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ယေရှုဟ “ဟေဗိမာန်တော်ဟို ဖြိုဖျက်ကြလော့၊ သုံးရက်အတွင်း ငါ ပြန်လည် တည်ဆောက်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ယုဒအမျိုးသားလို့ဟ “ဟေဗိမာန်တော်ဟို တည်ဆောက်ရန် လေးဆယ့်ခြောက်နှစ် ကြာအယ်၊ နင်ဟ သုံးရက်နဲ့ ပြန်ဆောက်မို့လော” ဟု ပြောပြန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","အဲလိုလဲ ယေရှုဟ မိမိ ကိုယ်ခန္ဓာဖြစ်သော ဗိမာန်တော်ဟို ရည်ညွှန်းယွေ့ ပြောခြင်းဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ကိုယ်တော် သေခြင်းမှ ဆှင်ပြန်ထမြောက်ပင်းနောက် တဘဲ့တော်လို့ဟ ကိုယ်တော်မိန့်ခဲ့သော စကားဟို အမှတ်ရကြအယ်။ အဲပင်းရင် ကျမ်းစာနဲ့ ယေရှု မိန့်ခဲ့သော စကားဟို ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ပသခါပွဲအတွင်း ယေရုရှလင်မြို့နှိုက် ယေရှုဆိစဉ် ရမ်းဆာ့သောလူလို့ဟ ကိုယ်တော်ပြုသော နိမိတ်လက္ခဏာများဟို မျော်ရကြသဖြင့် ကိုယ်တော်ဟို ယုံကြည်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","အဲလိုလဲ ယေရှုဟ အဲသူလို့ဟို မယုံကြည်ဝူး၊ အကျောန်းမှာ ကိုယ်တော်ဟ ခပ်သိမ်းသောသူလို့အား သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ကိုယ်တော်ဟ သူလို့ရဲ့ စိတ်နေလုံးဟို သိသောကျောန့် ကိုယ်တော်အား လူ့အကျောန်းဟို စသူမှ ပြောရန် မလို။ ");
INSERT INTO dnv_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ဖာရိရှဲလို့ အဖွဲ့ဝင်ဖြစ်သော နိကောဒင် နာမယ်ဆိသော ယုဒအမျိုးသား ခေါင်းဆောင်တယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","သူဟ ညနှိုက် ယေရှုဆေဟို လာယွေ့ “ရဗ္ဗိ၊ ကိုယ်တော်ဟ ဘုရားသခင်ဆေမှ လာသော ဆရာဖြစ်ကျောန်းဟို ငါလို့ သိအယ်။ အကျောန်းမှာ ဘုရားသခင် အတူမပါဆိရင် ကိုယ်တော်ပြုနေသော ဟေနိမိတ်လက္ခဏာများဟို စသူမျှ ပြုနိန်မှာ မဟုတ်မန့်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ယေရှုဟ “နင်လို့အား ငါ အမန်ဆိုတာဟ တဖန်မွေးဖွားခြင်းမခံသူဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်ဟို မမျော်နိန်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","နိကောဒင်ဟလည်း “အသက်ကြီးသောသူဟ စလို မွေးဖွားခြင်းဟို ခံရမှာတုန်း၊ သူ့မေ့ဖိုက်ထဲဟို ပြန်ယွေ့ ဝင်ပင်း ဒုတိယအကြိမ် မွေးဖွားခြင်းဟို ခံရမယ်လော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ယေရှုဟ “နင်အား ငါ အမန်ဆိုတာဟ၊ ယေနဲ့ ဝိညာဉ်တော်အားဖြင့် မွေးဖွားလာသူ မဟုတ်ရင် စသူမျှ ဘုရားသခင်ရဲ့ နိုင်ငံတော်သို့ မဝင်ရ။ ");
INSERT INTO dnv_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","အသွေးအသားအားဖြင့် မွေးဖွားသူဟ အသွေးအသား ဖြစ်အယ်၊ အဲလိုလဲ ဝိညာဉ်တော်အားဖြင့် မွေးဖွားသူဟ ဝိညာဉ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","တဖန်မွေးဖွားခြင်း ခံရကြမယ်လို့ ငါဆိုသောကျောန့် မအံ့ဩနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","လေဟ မိမိတိုက်လိုရာသို့ တိုက်တတ်အယ်။ လေရဲ့အသံဟို ကြားရပေမဲ့ ပစာအရပ်မှ တိုက်လာအယ် အဲဟာမဟုတ်ရင် ပစာအရပ်ဟို တိုက်လိမ့်မယ်ဟို နင်လို့ မသိနိန်။ အဲလိုမို့ ဝိညာဉ်တော်အားဖြင့် မွေးဖွားသူတိုင်းဟလည်း ဟေတိုင်းတိုင်းပင် ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","နိကောဒင်ဟ “ဟေအမှုအရာလို့ဟ စလို ဖြစ်နိန်မှာတုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ယေရှုဟလည်း “နင်ဟ ဣသရေလအမျိုးသားလို့ရဲ့ ကြီးမြတ်လဲ့ ဆရာတဦးဖြစ်လျက်နဲ့ အဲအရာဟို မသိသလော။ ");
INSERT INTO dnv_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","နင့်အား ငါ အမန်ဆိုတာဟ ငါလို့ဟ မိမိလို့သိသောအရာဟို ပြောကြအယ်၊ မျော်သောအရာဟို သက်သေခံကြအယ်၊ အဲလိုလဲ ငါလို့ရဲ့ သက်သေခံချက်ဟို နင်လို့ လက်မခံကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ဟေလောကနဲ့ဆိုင်သောအရာများဟို ငါဖော်ပြသောအခါ နင်လို့ မယုံရင် ခေါန်းခင်နဲ့ ဆိုင်သောအရာများဟို ဖော်ပြသောအခါ စလို နင်လို့ ယုံကြမှာတုန်း။ ");
INSERT INTO dnv_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ခေါန်းခင်မှ ဆင်းသက်လာသော လူသားမှတပါး စသူမျှ ခေါန်းခင်ဘုံသို့ မရောက်ဖူးကြ” မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","မောရှေဟ တောကန္တာရနှိုက် တိုင်ထိပ်ပေါ်တွင် ကြေးမြွေဟို မြှောက်ထားသလို လူသားဟလည်း အဲတိုင်းတိုင်း မြှောက်ထားခြင်းဟို ခံရလိမ့်မယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","အဲလိုမို့ သူ့ဟို ယုံကြည်သောသူတိုင်းဟ ထာဝရ အသက်ဟို ရဆိလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ဘုရားသခင်ဟ လောကသားလို့ဟို ရမ်းဆာ့ ချစ်သောကျောန့် မိမိရဲ့တပါးတည်းသော သားတော်ဟို ပေးအယ်၊ အဲဟာဟ သားတော်ဟို ယုံကြည်သောသူတိုင်း မပျက်စီးဘဲ ထာဝရအသက်ဟို ရဆိစေရန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","အကျောန်းမှာ ဘုရားသခင်ဟ သားတော်ဟို ဟေလောကသို့ စေလွှတ်တာဟ လောကသားလို့ဟို အပစ်စီရင်ရန် မဟုတ်၊ အဲလိုလဲ လောကသားလို့ဟ သားတော်အားဖြင့် ကယ်တင်ခြင်း ခံရရန်အတွက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","သားတော်ဟို ယုံကြည်သူဟ အပစ်စီရင်ခြင်း မခံရ၊ အဲလိုလဲ မယုံကြည်သူဟတော့ ဘုရားသခင်ရဲ့ တပါးတည်းသော သားတော်ဟို မယုံကြည်သောကျောန့် အပစ်စီရင်ခြင်းဟို ခံရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","အပစ်စီရင်ခြင်းရဲ့ အကျောန်းအရာဟ ဟေလို ဖြစ်အယ်၊ အလင်းဟ ဟေလောကသို့ ရောက်ဆိလာအယ်၊ အဲလိုလဲ လူလို့ဟ ဆိုးယုတ်သောသူများဖြစ်သောကျောန့် အလင်းထက် မိုက်ဟို ပိုပင်း ချစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ဆိုးယုတ်သောအကျင့်ဟို ကျင့်သောသူအပေါင်းလို့ဟ အလင်းဟို မုန်းယွေ့ မိမိလို့အကျင့်နှိုက် အပစ်ပါတာဟို မထင်ဆှားစေဖို့ အလင်းအနီးဟို မချဉ်းကပ်လိုကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","အဲလိုလဲ သမ္မာတရားဟို ကျင့်သောသူများမှာ မိမိပြုသောအရာလို့ဟ ဘုရားသခင်ရဲ့ အလိုတော်နဲ့အညီဖြစ်ကျောန်း သူလို့ သိသာထင်ဆှားစေရန် အလင်းဟို ချဉ်းကပ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","အဲပင်းရင် ယေရှုဟ တဘဲ့တော်လို့နဲ့အတူ ယုဒနယ်ဟို ကြွပင်း အေးအရပ်တွင် တဘဲ့တော်လို့နဲ့အတူ နေလျက် နှစ်ခြင်းမင်္ဂလာဟို ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ယောဟန်ဟလည်း ရှာလိမ်မြို့အနီး အဲနုန်အရပ်တွင် ယေများစွာ ဆိသောကျောန့် နှစ်ခြင်းမင်္ဂလာဟို ပေးလျက်နေအယ်။ လူလို့ဟ ယောဟန်ဆေသို့ လာယွေ့ နှစ်ခြင်းမင်္ဂလာဟို ခံယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","အဲဟာဟ ယောဟန် ထောင်ထဲနှိုက် ထည့်ထားခြင်း မခံရသေးကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ယောဟန်ရဲ့ တဘဲ့အချို့လို့ဟ ထုံးတမ်းစဉ်လာစလေ့အရ သန့်ဆှင်းခြင်းအကျောန်းနဲ့ ပတ်သက်ယွေ့ ယုဒအမျိုးသားတယောက်နဲ့ စတင် အငြင်းပွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","အဲလိုမို့ သူလို့ဟ ယောဟန်ဆေဟို လာပင်း “ဆရာ၊ ယော်ဒန်မြစ် အဆေ့ဘက်ကမ်းဆိ ကိုယ်တော်ဆေဟို လာရောက်ခဲ့ဖူးသူ လူတယောက်ဟို သတိရလော့။ သူရဲ့အကျောန်း ဆရာဟို သက်သေခံခဲ့ဖူးပါအယ်၊ အခု သူဟ နှစ်ခြင်းမင်္ဂလာဟို ပေးလျက်နေအယ်၊ လူအပေါင်းလို့ဟလည်း သူ့ဆေဟို လာလျက်နေကြအယ်” လို့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ယောဟန်ဟ “ဘုရားသခင် မပေးအပ်ရင် စသူမှ စလိုအရာဟိုမျှ မရနိန်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘ငါဟ မေဆှိယ မဟုတ်၊ သူ့ဆေ့နှိုက် စေလွှတ်ခြင်း ခံရသောသူသာ ဖြစ်အယ်’ ဟု ငါပြောခဲ့ကျောန်း နင်လို့တတ်တိုင်းဟ ငါရဲ့ သက်သေများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","မင်္ဂလာဆောင်သတို့သမီးဟို သိမ်းပိုက်ရသူဟ မင်္ဂလာဆောင်သတို့သား ဖြစ်အယ်၊ အဲလိုလဲ သတို့သားရဲ့ မိတ်ဆွေဟ အဆင်သင့်စောင့်ဆိုင်းကာ သတို့သားရဲ့ အသံဟို နားထောင်လျက်နေအယ်၊ သတို့သားရဲ့ အသံဟို ကြားသော် ရမ်းဆာ့ ဝမ်းသာအားရသလို ငါဟလည်း အခု အပြေ့အဝ ဝမ်းသာရလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","အဲသူဟ တိုးပွားရမယ်၊ ငါဟတော့ ဆိုးယုတ်ရမယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","အထက်မှ ကြွလာသောသူဟ အလုံးစုံလို့ထက် ကြီးမြတ်အယ်။ မြေကြီးမှ ဖြစ်သောသူဟ မြေကြီးနဲ့ဆိုင်ယွေ့ မြေကြီးနဲ့ဆိုင်သောအရာများဟို ပြောတတ်အယ်၊ ခေါန်းခင်မှ ကြွလာသောသူဟ အလုံးစုံလို့ရဲ့ အထက်မှာ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ကိုယ်တော်ဟ မိမိမျော်ခဲ့ ကြားခဲ့ရသောအရာလို့ဟို ဟောပြောသော်လည်း ကိုယ်တော်ရဲ့ သက်သေခံချက်ဟို စသူမျှ လက်မခံကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ကိုယ်တော်ရဲ့ သက်သေခံချက်ဟို လက်ခံသောသူဟတော့ အေးလို လက်ခံခြင်းအားဖြင့် ဘုရားသခင်ဟ သစ္စာစောင့်တာဟု အသိမှတ်ပြုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ဘုရားသခင်ဟ မိမိစေလွှတ်သောသူအား ဝိညာဉ်တော်ဟို အပြေ့အဝ ချပေးသောကျောန့် အေးသူဟ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ဟောပြောတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ခမည်းတော်ဟ သူ့သားတော်ဟို ချစ်ယွေ့ အရာခပ်သိမ်းလို့ဟို သားတော်လက်သို့ ပေးအပ်ပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","သားတော်ဟို ယုံကြည်သူဟ ထာဝရ အသက်ဟို ရအယ်၊ သားတော်ရဲ့ စကားဟို မနာခံသောသူဟတော့ အသက်ဟို မရဘဲ ဘုရားသခင်ရဲ့ အမျက်တော်ဟ သူ့အပေါ်နှိုက် တည်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ယေရှုဟ ယောဟန်ထက် ပိုပင်းများလဲ့ တဘဲ့များဟို နှစ်ခြင်းပေးလျက်နေတာဟို ဖာရိရှဲလို့ ကြားသိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","အမန်မှာ ယေရှုတတ်တိုင်း စသူ့ဟိုမှ နှစ်ခြင်း မပေး၊ တဘဲ့တော်လို့သာ ပေးခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","အဲလိုမို့ ဖာရိရှဲလို့ ကြားကျောန်းဟို ယေရှုသိသောအခါ ယုဒပြေမှ ထွက်ခွာယွေ့ ဂါလိလဲပြေဟို ပြန်သွားအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","လမ်းတွင် ရှမာရိနယ်ဟို ဖြတ်ယွေ့ သွားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ယာကုပ်ဟ သူ့ရဲ့ သားယောသပ်အား ပေးလဲ့ မြေကွက်အနီးဆိ ရှမာရိနယ်၊ ရှုခါ နာမယ် ဆိသောမြို့ဟို ရောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","အေးအရပ်တွင် ယာကုပ်ရဲ့ ယေတွင်း ဆိအယ်၊ ယေရှုဟ ခရီးသွားယွေ့ ပင်ပန်းသဖြင့် ယေတွင်းအနီးတွင် ထိန်နေအယ်။ အေးအချိန်ကား မွန်းတည့်အချိန်ခန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ရှမာရိ အမျိုးသမီးတဦးဟ ယေခပ်ရန် ရောက်ဆိလာအယ်၊ ယေရှုဟ “ငါသောက်ဖို့ ယေပေးမန့်” လို့ အေးအမျိုးသမီးဟို မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","သူ့ရဲ့ တဘဲ့တော်လို့ဟ အစားအစာဝယ်ရန် မြို့ထဲဟို သွားနေခိုက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ရှမာရိအမျိုးသမီးဟ “နင်ဟ ယုဒ အမျိုးသားတယောက်ဖြစ်ပါလျက် ရှမာရိ အမျိုးသမီးဖြစ်သူ ကျွန်မဆေမှ စလို သောက်ဖို့ တောင်းတုန်း” လို့ မေးအယ်။ အေးလို့ မေးရလဲ့အကျောန်းမှာ ယုဒလူလို့ဟ ရှမာရိလူလို့ရဲ့ မုတ်နဲ့ ပန်းကန်လို့ဟို အသုံးပြုလေ့ မဆိကြသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ယေရှုဟ “ဘုရားသခင် ပေးလဲ့ ဆုကျေးဇူးနဲ့ နင့်အား သောက်ဖို့ ယေတောင်းနေသူဟ စသူဖြစ်တာဟို နင်သိရင် အေးသူဆေမှ အသက်ယေဟို တောင်းလိမ့်မယ်၊ အေးသူဟလည်း နင့်အား အေးယေဟို ပေးလိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","အေးအမျိုးသမီးဟ “ဆရာ၊ ယေတွင်းဟ နက်ပင်း ကိုယ်တော်မှာ ခပ်စရာ ယေပုံး မဆိမန့်။ ဖယ်နားဟနေပင်း အသက်ယေဟို ရမာလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ငါလို့ ဖိုးဘေး ယာကုပ်ဟ သူတတ်တိုင်းမှစယွေ့ လူပဲ့သငယ်များ၊ တိရစ္ဆာန်များဟ ဟေယေတွင်း ယေဟို သောက်ခဲ့ကြအယ်။ ကိုယ်တော်ဟ အဖ ယာကုပ်ထက်ပင် ကြီးမြတ်သလော” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ယေရှုဟ “ဟေယေဟို သောက်သောသူတိုင်း နောက်တဖန် ယေငတ် လိမ့်အုံးမယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","အဲလိုလဲ ငါပေးလဲ့ ယေဟို သောက်သူဟ နောက်တဖန် ဖယ်တော့မှ ယေငတ်ခြင်းနဲ့ ကင်းလွတ်လိမ့်မယ်။ အမန်တကယ် ငါပေးလဲ့ ယေဟ အဲသူလို့နှိုက် ထာဝရ အသက်ဆှင်ခြင်းအလိုငှာ ထွက်သောစမ်းယေ ဖြစ်လိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","အဲအမျိုးသမီးဟ “ဆရာ၊ ကျွန်မဟ နောက်တခါ ယေ မငတ်စေရန်နဲ့ ဟေအရပ်ဟို လာယွေ့ ယေ မခပ်ရအောန် အေးယေဟို ကျွန်မအား ပေးမန့်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ယေရှုဟ “သွားလော့၊ နင့်ဖိုးအိုဟို ခေါ်ပင်း ဟေဟို လာလော့” လို့ မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","အဲအမျိုးသမီးဟ “ကျွန်မမှာ ဖိုးအို မဆိပါ” ဟု ပြန်ပြောအယ်။ ယေရှုဟ “နင့်မှာ ဖိုးအို မဆိဟု ဆိုတာဟ မန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","နင့်မှာ ဖိုးအို ငါးယောက် ဆိခဲ့ဖူးပီ၊ အခု နင်နဲ့အတူနေသောသူဟ နင်ရဲ့ဖိုးအို မဟုတ်။ နင်ဟ မန်သောစကားဟို ငါ့အား ပြောအယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","အဲမိန်းမဟ “ဆရာ၊ နင်ဟ ပရောဖက်ဖြစ်ကျောန်းဟို ကျွန်မ မျော်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“ငါလို့ရဲ့ ဘိုးဘေးများဟ ဟေတောင်ပေါ်မှာ ဘုရားသခင်ဟို ဝတ်ပြုကိုးကွယ် ခဲ့ကြအယ်၊ အဲလိုလဲ ယုဒလူလို့ဟ ဘုရားသခင်ဟို ဝတ်ပြုကိုးကွယ်ရမဲ့ နေရာဟ ယေရုရှလင်မြို့နှိုက် ဆိတာဟု ပြောဆိုကြအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ယေရှုဟ “အချင်းမိန်းမ၊ ငါ့စကားဟို ယုံလော့၊ ဟေတောင်ပေါ်နှိုက် အဲဟာမဟုတ်ရင် ယေရုရှလင်မြို့နှိုက် လည်းကောင်း ခမည်းတော်ဟို ဝတ်ပြုကိုးကွယ်ခြင်း မပြုတော့မဲ့အချိန် ရောက်ဆိလာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ရှမာရိအမျိုးဖြစ်လဲ့ နင်လို့ဟ မိမိလို့တကယ်မသိလဲ့ ဘုရားဟို ဝတ်ပြုကိုးကွယ်ကြအယ်၊ အဲလိုလဲ ငါလို့ဟတော့ ငါလို့သိလဲ့ ဘုရားဟို ဝတ်ပြုကိုးကွယ်ကြအယ်၊ ပစာကို့ ကယ်တင်ခြင်းဟ ယုဒအမျိုးသားဆေမှ တဆင့် သက်ရောက်လာသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ဝတ်ပြုကိုးကွယ်သူလို့ဟ ခမည်းတော်အား အမန်စင်စစ်ဖြစ်လဲ့အတိုင်း ဝိညာဉ်တော် တန်ခိုးအားဖြင့် မန်ကန်စွာ ဝတ်ပြုကိုးကွယ်ရမဲ့အချိန် ရောက်လာမယ်ဖြစ်ရာ အခုပင် ရောက်လျက်ဆိအယ်၊ အကျောန်းမှာ ခမည်းတော်ဟ အေးလိုမျိုးသော ဝတ်ပြုကိုးကွယ်သူလို့ဟို အလိုဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ဘုရားသခင်ဟ နာမ်ဝိညာဉ် ဖြစ်ယွေ့ ဘုရားသခင်အား ကိုးကွယ်သူလို့ဟ နာမ်ဝိညာဉ်နဲ့ သမ္မာတရားအားဖြင့် ကိုးကွယ်ရမယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","မိန်းမဟ “ခရစ်တော်ဟု ခေါ်သော မေဆှိယ ကြွလာတာဟို ကျွန်မ သိပါအယ်၊ အေးသခင် ကြွလာသောအခါ ငါလို့အား အမှုအရာခပ်သိမ်းဟို ဖော်ပြပါလိမ့်မယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ယေရှုဟလည်း “နင်နဲ့ စကားပြောနေသူဟ ငါပင် ဖြစ်အယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","အဲအချိန်နှိုက် တဘဲ့တော်လို့ ပြန်ရောက်လာကြအယ်၊ သူလို့ဟ အေးမိန်းမနဲ့ ကိုယ်တော် စကားပြောနေတာဟို တွေ့ရသဖြင့် အံ့ဩကြအယ်။ အဲလိုလဲ အေးမိန်းမဟို “ပစာဟို နင် အလိုဆိတုန်း” ဟူယွေ့ လည်းကောင်း၊ ကိုယ်တော်အား “ပစာကျောန့် အေးမိန်းမနဲ့ နင် စကားပြောနေတာတုန်း” ဟူယွေ့ လည်းကောင်း စသူမျှ မမေးဆှောက်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","အဲပင်းရင် မိန်းမဟ မိမိရဲ့ ယေအိုးဟို ထားခဲ့ယွေ့ မြို့ထဲဟို ပြန်သွားပင်း အဲမှာဆိလဲ့ ");
INSERT INTO dnv_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ငါ ပြုခဲ့သမျှသောအရာလို့ဟို ငါ့အား ပြောပြသူဟို လာပင်း ကျေ့ကြပါ။ သူဟ မေဆှိယ ဖြစ်လိမ့်မယ်လော” ဟု လူလို့အား ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","အဲလိုမို့ လူလို့ဟ မြို့ထဲမှထွက်ယွေ့ ကိုယ်တော်ဆေဟို လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ဟေအချိန်အတွင်းနှိုက် တဘဲ့တော်လို့ဟ “ဆရာ၊ အစားအစာ သုံးဆောင်ပါ” ဟု ကိုယ်တော်အား တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","အဲလိုလဲ ကိုယ်တော်ဟ “နင်လို့ မသိကြလဲ့စားဖို့ အစားအစာဟို ငါမှာဆိအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","အေးကျောန့် တဘဲ့တော်လို့ဟ “ကိုယ်တော်အား တစုံတယောက်သောသူဟ အစားအစာဟို ပို့ပီလော” လို့ အချင်းချင်း စတင်ပင်း မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ယေရှုဟ “ငါ့ဟို စေလွှတ်သော သူရဲ့အလိုတော်ဟို ဆောင်ရွက်ယွေ့ သူရဲ့ အမှုဟို ပီးမြောက်စေခြင်းဟ ငါရဲ့ အစားအစာ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","နင်လို့ဟ ‘နောက်လေးလမျှကြာရင် ကောက်ရိတ်ချိန် ရောက်လိမ့်မယ်’ ဟု ဆိုတတ်ကြအယ် မဟုတ်လော။ အဲလိုလဲ နင်လို့အား ငါဆိုတာဟ လယ်ပြင်လို့ဟို မျော်ကျေ့လော့၊ သီးနှံလို့ဟ မှည့်ဝင်းနေပင်း ရိတ်သိမ်းရန် အသင့်ဖြစ်နေပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ရိတ်သူဟ အခဟို ခံယူပင်း ထာဝရ အသက်ဆှင်ခြင်းအလိုငှာ သီးနှံများဟို ရိတ်သိမ်းအယ်၊ အဲလိုမို့ စိုက်သူနဲ့ ရိတ်သူလို့ဟ အတူဝမ်းမြောက်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‘တဦးဟ စိုက်ယွေ့ နောက်တဦး ရိတ်ရအယ်’ ဟု အေးစကားဟ မန်ကန်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","နင်လို့ မစိုက်မပျိုးလဲ့ လယ်မှအသီးအနှံများဟို ရိတ်သိမ်းရန် နင်လို့အား ငါစေလွှတ်အယ်၊ အခြားသောသူလို့ဟ စိုက်ပျိုးလုပ်ဆောင်ကြယွေ့ နင်လို့ဟ အကျိုးဟို ခံစားကြယာ့အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ရှမာရိအမျိုးသမီးဟ “ဟေသူဟ ငါပြုခဲ့သမျှသော အမှုအရာများဟို သက်သေခံခဲ့အယ်” ဟု ဆိုသဖြင့် အေးမြို့ဆိ ရှမာရိလူ အမြောက်အမြားပင် ယေရှုအား ယုံကြည်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","အဲလိုမို့ ရှမာရိလူလို့ဟ ကိုယ်တော်ဆေဟို ရောက်လာကြသောအခါ မိမိလို့ဆေတွင် နေပါဟု တောင်းပန်ကြအယ်၊ ယေရှုဟ အေးအရပ်တွင် နေရက်မျှ နေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ကိုယ်တော်ရဲ့ တရားဟို ကြားနာရသောကျောန့် ကိုယ်တော်ဟို ယုံကြည်လာကြသူ အမြောက်အများလည်း ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","အေးသူလို့ဟ မိန်းမအား “အခု ငါလို့ဟ ကိုယ်တော်အား ယုံကြည်လာကြတာဟ နင့်စကားကျောန့် မဟုတ်၊ ကိုယ်တော်ရဲ့တရားဟို ငါလို့တတ်တိုင်း ကြားကြရသောကျောန့် ဖြစ်အယ်၊ ဟေသူဟ လောကရဲ့ ကယ်တင်ဆှင် အစစ်အမန်ပင်ဖြစ်ကျောန်း ငါလို့ သိကြပီ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","အေးအရပ်နှိုက် နေရက်နေပင်းနောက် ယေရှုဟ ဂါလိလဲပြေဟို ကြွလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ပရောဖက်ဟ မိမိနေရင်းပြေနှိုက် ဂုဏ်သရေမဆိကျောန်း ယေရှုတတ်တိုင်း သက်သေခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ဂါလိလဲပြေသို့ ရောက်သောအခါ ဂါလိလဲပြေသားလို့ဟ ကိုယ်တော်ဟို လက်ခံကြိုဆိုကြအယ်၊ ပစာကို့ ယေရုရှလင်မြို့တွင် ကျင်းပခဲ့လဲ့ ပသခါပွဲတော်ဟို သူလို့တတ်တိုင်းရောက်ခဲ့ကြယွေ့ အေးပွဲတော်အတွင်းနှိုက် ကိုယ်တော်ပြုခဲ့သော အမှုအရာအပေါင်းဟို မျော်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","အေးနောက် ကိုယ်တော်ဟ ယေဟို စပျစ်ယေ ဖြစ်စေခဲ့ရာ ဂါလိလဲပြေ ကာနမြို့ဟို တခါကြွအယ်။ ကပေရနောင်မြို့နှိုက် အရာဆိတဦး ဆိယွေ့ သူရဲ့သားဟ ဖျားနာနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ယုဒပြေမှ ဂါလိလဲပြေသို့ ယေရှုကြွလာကျောန်းဟို အဲအရာဆိဟ ကြားသောအခါ မိမိရဲ့ သားဟ သေခါနီးဖြစ်သောကျောန့် ကိုယ်တော်ဆေဟို သွားပင်း သားရဲ့ အနာရောဂါဟို ပျောက်ကင်းစေပါမဲ့အကျောန်း ဆှောက်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ယေရှုဟလည်း “နင်လို့ဟ နိမိတ်လက္ခဏာများနဲ့ အံ့ဩဖွယ်သောအမှုလို့ဟို မမျော်ရရင် ပစာအခါမှ ယုံကြည်ကြမယ် မဟုတ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","အရာဆိဟ “ဆရာ၊ ငါရဲ့သား မသေခင် ကြွလာမန့်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ယေရှုဟလည်း “သွားလော့၊ နင့်သားဟ အသက်ဆှင်လိမ့်မယ်” ဟု မိန့်အယ်။ အေးသူဟ ယေရှုမိန့်လဲ့စကားဟို ယုံကြည်လျက် သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","သူဟ လမ်းမှာဆိနေသေးစဉ် သူရဲ့ အစေခံများ ရောက်လာယွေ့ “နင့်ရဲ့ သားငယ်ဟ သက်သာလာပါပီ” ဟု ပြောကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","အဲသူဟ “ဖယ်ချိန်နှိုက် သားငယ် ရောဂါသက်သာ သွားတာတုန်း” ဟု မေးသောအခါ အစေခံများဟ “မနေ့ မွန်းလွဲတနာရီခန့်တွင် အဖျားပျောက်အယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","အေးအခါ ဖခင်ဖြစ်သူဟ အေးအချိန်သည် “နင့်ရဲ့သား အသက်ဆှင်လိမ့်မယ်” ဟု ယေရှု မိန့်သောအချိန် ဖြစ်ကျောန်းဟို သတိရလေအယ်။ အဲလိုမို့ သူနဲ့တကွ အိုင်သူအိုင်သားအပေါင်းလို့ဟ ကိုယ်တော်အား ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ဟေဟ ယုဒပြေမှ ဂါလိလဲပြေဟို ယေရှု ကြွလာပင်းနောက် ဒုတိယအကြိမ် ပြလဲ့ အံ့ဖွယ်နိမိတ်လက္ခဏာ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","အဲပင်းရင် ယုဒအမျိုးသားလို့ရဲ့ ဘာသာရေးပွဲတော်အတွက် ယေရှုဟ ယေရုရှလင်မြို့ဟို သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ယေရုရှလင်မြို့နှိုက် သိုးထင်ခါးအနီးမှာ ယေကန် ဆိအယ်၊ အေးယေကန်ဟို ဟေဗြဲစကားဖြင့် ဗေသေသဒ ဟု ခေါ်အယ်၊ အေးယေကန်ဟို မုခ်ငါးခုဖြင့် ခြံရံထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","အဲမုခ်များအောက်တွင် — မျက်စေ့ကန်းသူ၊ ခြေမစွမ်းသူ၊ လေဖြတ်သူမှစယွေ့ လူနာအမြောက်အမြား လဲလျောင်းလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","အဲနေရာတွင် သုံးဆယ့်ဆစ်နေပတ်လုံး မကျန်းမာသောသူ လူတယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","အဲသူလဲလျောင်းနေတာဟို ယေရှု မျော်သောအခါ ကာလကြာမြင့်စွာ ဟေလို လဲလျောင်းနေခဲ့တာဟို သိအယ်၊ အေးလိုမို့ ကိုယ်တော်ဟ “နင်ဟ ကျန်းမာလိုပါသလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","အဲသူဟ “ဆရာ၊ ယေ လှုပ်ဆှားလာသောအခါ ငါ့ဟို ယေကန်ထဲသို့ ချပေးမဲ့သူ တယောက်မျှ မဆိမန့်။ ငါဆင်းမယ်ပြုနေစဉ် အခြားသူတယောက်ဟ ဦးရင် ယေကန်ထဲဟို ဆင်းသွားတတ်ပါအယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ယေရှုဟ “ထလော့၊ နင့်အိပ်ယာဟို ယူယွေ့ လှမ်းသွားလော့” ဟု အေးသူအား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","အဲသူဟ ခုတုံး ကျန်းမာလာသဖြင့် မိမိရဲ့ အိပ်ယာဟို ယူယွေ့ လှမ်းသွားလေအယ်။ အေးနေ့ကား ဥပုသ်နေ့ ဖြစ်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","အဲလိုမို့ ယုဒအာဏာပိုင်လို့ဟ ကျန်းမာလာသူအား “ခနေ့ဟ ဥပုသ်နေ့ ဖြစ်ယွေ့ နင့်အိပ်ယာဟို ဆောင်ယူခြင်းမှာ ငါလို့ ပညတ်တော်နဲ့ ဆန့်ကျင်နေအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","အဲလိုလဲ သူဟ “ငါ့အား ကျန်းမာစေသူဟ ‘နင့်အိပ်ယာဟို ယူယွေ့ လှမ်းသွားလော့’ လို့ ခိုင်းပါအယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","အဲလိုမို့ သူလို့ဟ “နင့်အား အိပ်ယာဟို ယူယွေ့ လှမ်းသွားလော့ဟု ဆိုသူဟ စသူလဲ” ဟု သူ့အား မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","အဲလိုလဲ ကျန်းမာလာသောသူသည် ယေရှုဟ စသူဖြစ်တယ်ဆိုတာဟို မသိ၊ အကျောန်းမှာ အဲအရပ်နှိုက် လူအများဆိယွေ့ ယေရှုဟ မထင်မဆှား ထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","အဲပင်းရင် ယေရှုဟ အေးသူဟို ဗိမာန်တော်ထဲတွင် တွေ့ဆိသဖြင့် “နားထောင်လော့၊ နင်ဟ အခု ကျန်းမာလာလေပီ၊ နောက်ထပ် အပစ်မလုပ်နဲ့ အဲဟာမဟုတ်ရင် နင်ဟ ဟေထက် ဆိုးရွားသောအဖြစ်မျိုးနဲ့ ကြုံရလိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","အဲပင်းရင် သူဟ ထွက်သွားယွေ့ မိမိအား ကျန်းမာစေသောသူမှာ ယေရှုဖြစ်ကျောန်း ယုဒအာဏာပိုင်လို့အား ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","အေးလိုမို့ ဟေအမှုအရာဟို ဥပုသ်နေ့နှိုက် ပြုသောကျောန့် ယုဒအာဏာပိုင်လို့ဟ ယေရှုအား ညှဉ်းဆဲကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ယေရှုဟလည်း “ငါ့ခမည်းတော်ဟ အခုတိုင်အောန် အလုပ်လုပ်တာ ဖြစ်ယွေ့ ငါလည်း အလုပ်လုပ်အယ်” ဟု သူလို့အား ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","အဲအကျောန်းကျောန့် ယုဒအာဏာပိုင်လို့ဟ ကိုယ်တော်ဟို သတ်ရန် ပိုယွေ့ ကြိုးစားဆှာကြအယ်၊ ဥပုသ်နေ့ဟို ဖောက်ဖျက်ရုံမက ဘုရားသခင်ဟို မိမိရဲ့ အဖဟုခေါ်လျက် မိမိတတ်တိုင်း ဘုရားနဲ့ တန်းတူထားသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ယေရှုဟ ယုဒအာဏာပိုင်လို့အား “နင်လို့အား ငါ အမန်ဆိုအယ်၊ ခမည်းတော်ပြုလဲ့ အမှုအရာများဟို မျော်ယွေ့ ပြုခြင်းမှတပါး အခြားစလိုအရာဟိုမျှ မိမိတတ်တိုင်း မပြုနိန်၊ ပစာကို့ ခမည်းတော်ပြုသမျှအတိုင်း သားတော်လည်း ပြုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ခမည်းတော်ဟ သားတော်ဟို ချစ်သဖြင့် မိမိပြုသမျှသောအမှုအရာများဟို သားတော်အား ပြသအယ်။ ဟေအမှုအရာများထက်ပင် ကြီးစွာသောအမှုအရာများဟို ပြုရန် ခမည်းတော်ဟ သားတော်အား ပြသပေးမယ် ဖြစ်ယွေ့ နင်လို့ဟ အံ့ဩကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ခမည်းတော်ဟ သေလွန်သောသူလို့ဟို အသက်ဆှင်စေသလို အဲတိုင်းတိုင်း သားတော်ဟလည်း မိမိအလိုဆိသူလို့ဟို အသက်ဆှင်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ခမည်းတော်ဟ စသူဟိုမျှ တရားစီရင်တော်မမူ။ သားတော်အား တရားစီရင် ပိုင်ခွင့်ဆိသမျှဟို ပေးအပ်ထားအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","အဲလိုမို့ လူအပေါင်းလို့ဟ ခမည်းတော်အား ရိုသေကြလဲ့တိုင်း သားတော်အား ရိုသေကြရမယ်။ သားတော်အား မရိုသေသောသူဟ သားတော်ဟို စေလွှတ်သော ခမည်းတော်အား မရိုသေသောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“နင်လို့အား ငါ အမန်ဆိုတာဟ ငါရဲ့စကားဟို ကြားယွေ့ ငါ့ဟို စေလွှတ်သောသူဟို ယုံကြည်သောသူဟ ထာဝရအသက်ဟို ရအယ်။ သူလို့ဟ တရားစီရင်ခြင်းဟို မခံရဘဲ သေခြင်းမှ အသက်ဆှင်ခြင်းဟို ကူးမြောက်သောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","နင်လို့အား ငါ အမန်ဆိုတာဟ သေလွန်သောသူလို့ဟ ဘုရားသခင်ရဲ့ သားတော်အသံဟို ကြားယွေ့ ကြားသောသူလို့ဟ အသက်ဆှင်ရမဲ့အချိန် ရောက်လာမယ်ဖြစ်ရာ အခုပင် ရောက်လာလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","အကျောန်းမှာ ခမည်းတော်ဟ မိမိနှိုက် အသက်ဆှင်လဲ့တိုင်းတိုင်း သားတော်ဟိုလည်း မိမိနှိုက် အသက်ဆှင်စေခြင်းငှာ အခွင့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","သားတော်ဟ လူသားဖြစ်သောကျောန့် ခမည်းတော်ဟ တရားစီရင်ခြင်း အခွင့်ဟိုလည်း သားတော်အား ပေးပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ဟေအမှုအရာဟို နင်လို့ မအံ့သြကြနဲ့၊ လုတ်တိုင်းမှ လူသေလို့ဟ သားတော်ရဲ့ အသံတော်ဟို ကြားယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ထွက်လာကြမဲ့အချိန် ကျရောက်လိမ့်မယ်။ အကျင့်ကောင်းဟို ပြုခဲ့သူလို့ဟ ထမြောက်ယွေ့ အသက်ဆှင်လိမ့်မယ်၊ ဆိုးညစ်သောအမှုဟို ပြုကျင့်သောသူလို့ဟလည်း ထမြောက်ယွေ့ အပစ်စီရင်ခြင်းဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ငါဟ မိမိအလိုအလျောက် စလိုအရာဟိုမှ မပြုနိန်၊ ငါဟ ကြားရလဲ့အတိုင်းသာ တရားစီရင်ယွေ့ ကိုယ့်အလိုမဟုတ်ဘဲ ငါ့ဟို စေလွှတ်သောသူရဲ့ အလိုတော်ဟို လိုက်နာသောကျောန့် ငါရဲ့ စီရင် ဆုံးဖြတ်ချက်ဟ မန်ကန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ငါဟ မိမိရဲ့အကျောန်းဟို သက်သေခံရင် ငါရဲ့ သက်သေခံချက်ဟ မန်ကန်မှု မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","အဲလိုလဲ ငါ့အကျောန်းဟို သက်သေခံသောသူ တပါးဆိအယ်၊ သူဟ ငါ့အကျောန်း သက်သေခံချက်ဟ မန်အယ်ဆိုတာ ငါသိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","နင်လို့ဟ ယောဟန်ဆေဟို နင်လို့ရဲ့ သတင်းသယ်ဆောင်သူများ စေလွှတ်ခဲ့ကြအယ်၊ သူဟ သမ္မာတရားဘက်နှိုက် သက်သေခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","အဲကျောန့် လူရဲ့ သက်သေခံချက်ဟို ငါ ခံယူတာ မဟုတ်၊ အဲလိုလဲ နင်လို့ ကယ်တင်ခြင်း ခံရစေရန် ဟေစကားဟို ငါပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ယောဟန်ဟ တောက်လောင်ယွေ့ ထွန်းလင်းသော မီးဖူးလိုမျိုး ဖြစ်အယ်၊ နင်လို့ဟ သူရဲ့ အလင်းနှိုက် ခဏသာပျော်မွေ့ လိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","အဲလိုလဲ ယောဟန်ရဲ့ သက်သေခံချက်ထက် ကြီးမြတ်လဲ့ သက်သေခံချက် ငါ့မှာ ဆိအယ်၊ ခမည်းတော် ငါ့အား ပေးအပ်သဖြင့် ခုတုံး ငါ ပီးမြောက်အောန် လုပ်ဆောင်ဖို့ ဆိလဲ့အရာများဟ ငါ့ဟို ခမည်းတော်စေလွှတ်ကျောန်း သက်သေခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ငါ့ဟို စေလွှတ်သော ခမည်းတော်တတ်တိုင်းဟလည်း ငါ့အကျောန်းဟို သက်သေခံအယ်။ နင်လို့ဟ ခမည်းတော်ရဲ့အသံဟို ပစာအခါမျှ မကြားဝူးကြ အဲဟာမဟုတ်ရင် ပုံသဏ္ဌာန်တော်ဟိုလည်း မမျော်ဝူးကြ၊ ");
INSERT INTO dnv_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ခမည်းတော် စေလွှတ်သောသူဟို မယုံကြည်ကြလဲ့အတွက် နှုတ်ကပတ်တော်ဟ နင်လို့ရဲ့ စိတ်နေလုံးတွင် မကိန်းအောင်း။ ");
INSERT INTO dnv_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ကျမ်းစာဟို ဆာဖွေယွေ့ ထာဝရအသက်ဟို တွေ့ဆိလိမ့်မယ်ဟု နင်လို့ ထင်မှတ်ကြသောကျောန့် ကျမ်းစာဟို လေ့လာကြအယ်။ အေးကျမ်းစာပင် ငါ့အကျောန်းဟို သက်သေခံအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","အဲလိုလဲ နင်လို့ဟ အသက်ဟို ရဆိရန် ငါ့ဆေဟို လာခြင်းငှာ အလိုမဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ငါဟ လူလို့ဆေမှရသော ဘုန်းအသရေဟို မခံမယူ၊ ");
INSERT INTO dnv_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","အဲလိုလဲ နင်လို့အကျောန်းဟို ငါ သိအယ်။ နင်လို့စိတ်နေလုံးတွင် ဘုရားသခင်ဟို ချစ်ခြင်း မဆိကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ငါဟ ခမည်းတော်ရဲ့ အခွင့်အာဏာနဲ့ ရောက်ဆိလာသော်လည်း နင်လို့ဟ ငါ့ဟို လက်မခံကြ၊ အခြားသူတဦးတယောက်ဟ ကိုယ်ပိုင်အခွင့်အာဏာနဲ့ ရောက်ဆိလာပါမူ နင်လို့ လက်ခံကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","နင်လို့ဟ အခြားသူတယောက်ရဲ့ ဘုန်းအသရေဟို လက်ခံလိုကြအယ်၊ အဲလိုလဲ တဆူတည်းဆိသော ဘုရားသခင်ရဲ့ ချီးမွမ်းဂုဏ်ပြုခြင်းဟို ခံရရန် မကြိုးစားကြ၊ အဲလိုမို့ နင်လို့ဟ ငါ့ဟို စလို ယုံကြည်နိန်ကြမှာတုန်း။ ");
INSERT INTO dnv_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ငါဟ နင်လို့အား ခမည်းတော်ရဲ့ ဆေ့တော်နှိုက် အပစ်တင်စွပ်စွဲလိမ့်မယ်ဟု မထင်ကြနဲ့။ နင်လို့အား အပစ်တင်မဲ့သူဟ နင်လို့ ကိုးစားသော မောရှေပင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","မောရှေဟ ငါအကျောန်းဟို ရေးထားတာဖြစ်ယွေ့ နင်လို့ဟ မောရှေဟို ယုံကြည်ခဲ့ရင် ငါ့ဟိုလည်း ယုံကြည်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","အဲလိုလဲ နင်လို့ဟ မောရှေ ရေးသားဖော်ပြချက်များဟို မယုံကြည်ကြသဖြင့် စလို ငါ့စကားဟို ယုံနိန်ကြမှာတုန်း” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","အဲပင်းရင် ယေရှုဟ ဂါလိလဲအိန် တိဗေရိအိန် ဟုလည်း ခေါ်သော ဟို ကူးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","လူနာများအား ရောဂါပျောက်ကင်းစေလဲ့ နိမိတ်လက္ခဏာဟို တွေ့မျော်ခဲ့ကြသောကျောန့် လူအုပ်ကြီးဟ နောက်တော်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ယေရှုဟ တောင်ပေါ်ဟို တက်ယွေ့ သူ့ရဲ့ တဘဲ့တော်လို့နဲ့အတူ ထိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ယုဒအမျိုးသားလို့ရဲ့ ပသခါပွဲရောက်ရန် အချိန် နီးလာပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ယေရှုဟ ဝေ့ကျေ့ပင်း မိမိဆေသို့ လူအုပ်ကြီးလာနေတာဟို မျော်ပင်း “ဟေသူလို့စားရန် အစားအစာ အလုံအလောက်ဟို ပစာမှာ ဝယ်ရမှာလုန်း” ဟု ဖိလိပ္ပုအား မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ဟေလိုမေးခြင်းမှာ ဖိလိပ္ပုဟို စမ်းသပ်လိုယွေ့ ဖြစ်အယ်၊ အမန်တကယ် ကိုယ်တော်ဟ သူပစာလုပ်မယ်ဆိုတာ သိဆိပင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ဖိလိပ္ပုဟ “လူတိုင်းအတွက် ကတစ်စီကျွေးရန် ငွေဒင်္ဂါး ၂၀၀ ဖိုးနဲ့ ဝယ်ရင်တောင်မှ မုန့်လုံလောက်မယ် မဟုတ်ပါ” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ရှိမုန် ပေတရုရဲ့ ညီ အိန္ဒြေ နာမယ်ဆိသော သူ့ရဲ့ တဘဲ့တော်တယောက်ဟ၊ ");
INSERT INTO dnv_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ဟေနေရာတွင် မုယောမုန့်ငါးလုံးနဲ့ ငါးနေကောင်ပါသော လပဲ့သူငယ်တယောက် ဆိပါအယ်။ အဲလိုလဲ ဟေလောက်များသော လူလို့အား လောက်အောန် ကျွေးနိန်မယ် မဟုတ်ပါ” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ယေရှုဟ “လူလို့အား ထိန်စေကြလော့” ဟု မိန့်အယ်။ အဲအရပ်တွင် မြက်ထူထပ်လျက် ဆိအယ်။ ၅,၀၀၀ ခန့်လောက်ဆိလဲ့ ယောက်ျားလို့ဟ မြက်ခင်းပေါ်တွင် ထိန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","အဲပင်းရင် ယေရှုဟ မုန့်ဟိုယူယွေ့ ဘုရားသခင်အား ကျေးဇူးတော်ဟို ချီးမွမ်းပင်း ထိန်နေသော သူလို့အား ဝေငှပေးအယ်။ သူဟ ငါးဟိုလည်း အဲတိုင်းတိုင်းပြုပင်း လူလို့ဟ သူလို့ အလိုဆိလဲ့အတိုင်း ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","အဲသူလို့ဟ ဝစွာ စားကြပင်းသောအခါ ကိုယ်တော်ဟ “စားပင်းသော မုန့်အပိုင်းအစများဟို အလေလွင့်မဖြစ်ရအောန် သိမ်းကြလော့” ဟု တဘဲ့တော်လို့အား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","အဲလိုမို့ တဘဲ့တော်လို့ဟ ကောက်သိမ်းကြရာ လူလို့စားခဲ့သော မုယောငါးလုံးမှ စားပင်းသော အပိုင်းအစများဟို တောင်းတဆယ့်နေတောင်း အပြေ့ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ဟေလို ကိုယ်တော်ပြသော အံ့ဩဖွယ်နိမိတ်လက္ခဏာဟို မျော်ကြရသောသူလို့ဟ “ဟေသူဟ လောကဟို ကြွလာမယ်ဟုဆိုသော ပရောဖက်အမန်ပင် ဖြစ်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ယေရှုဟ အေးသူလို့လာယွေ့ မိမိအား အတင်းခေါ်ဆောင်ကာ ဘုရင်မြှောက်ကြမယ်ဟို သိသဖြင့် သူ့တတ်တိုင်း တောင်ပေါ်ဟို တဖန်ထွက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ညခင်းအချိန်ရောက်သောအခါ ယေရှုရဲ့ တဘဲ့တော်လို့ဟ ဂါလိလဲအိန်ဟို ဆင်းသွားကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","လှေပေါ်သို့ တက်ကြပင်းရင် အိန်တဖက်ကမ်းဆိ ကပေရနောင်မြို့ဆေဟို ပြန်သွားကြအယ်။ ညရောက်လာသော်လည်း ယေရှုဟ သူလို့ဆေဟို မရောက်သေး။ ");
INSERT INTO dnv_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","အဲအချိန်နှိုက် လေပြင်းကျရောက်နေသဖြင့် အိန်တွင် လှိုင်းထလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","တဘဲ့တော်လို့ဟ သုံးလေးမိုင်ခန့် လှော်ခတ်ပင်းသောအခါ ယေရှု ယေပေါ်မှာ လမ်းဆှောက်ယွေ့ မိမိလို့ လှေအနီးသို့ ကြွလာတာဟို မျော်ကြအယ်၊ အေးအခါ သူလို့ဟ ကြောက်ရွံ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ယေရှုဟ “မကြောက်ကြနဲ့၊ ငါပင် ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","အဲအခါ သူလို့ဟ လိုလိုလားလားပင် လှေပေါ်ဟို ခေါ်ဖိတ်ကြအယ်၊ လှေဟ သူလို့သွားရန် ရည်ရွယ်ထားသော ကမ်းခြေသို့ ခုတုံး ရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","နောက်တနေ့နှိုက် အိန်တဖက်ကမ်းတွင် နေရစ်ခဲ့သော လူအုပ်လို့ဟ အေးအရပ်နှိုက် လှေတစင်းတည်းဆိခဲ့တာဟို အမှတ်ရကြအယ်။ အေးလှေတွင် ယေရှုဟ တဘဲ့တော်လို့နဲ့ မသွားဘဲ တဘဲ့တော်လို့သာ ထွက်ခွာသွားကြတာဟို သူလို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","တိဗေရိမြို့မှ အခြားလှေများဟ သခင်ဘုရား ကျေးဇူးတော်ဟို ချီးမွမ်းယွေ့ လူလို့အား မုန့်ဟို ကျွေးမွေးခဲ့လဲ့ အရပ်အနီးဟို ရောက်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","လူအုပ်ဟ အေးအရပ်နှိုက် ယေရှုမှစယွေ့ တဘဲ့တော်လို့ မပါဆိကျောန်းဟို သိမျော်သဖြင့် အေးလှေများပေါ်သို့ တက်ပင်း ယေရှုဟို ဆှာရန် ကပေရနောင်မြို့ဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","အိန်တဖက်ကမ်းတွင် ယေရှုဟို တွေ့ကြသောအခါ သူလို့ဟ “ဆရာ၊ ဟေအရပ်ဟို ပစာအချိန် ကြွလာမှာတုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ယေရှုဟ “နင်လို့အား ငါ အမန်ဆိုတာဟ နင်လို့ ငါ့ဟို ဆာကြခြင်းမှာ ငါပြလဲ့ နိမိတ်လက္ခဏာများဟို မျော်ရသောကျောန့် မဟုတ်၊ မုန့်ဟို စားယွေ့ ဝသောကျောန့်သာ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ပုပ်ပျက်တတ်သော အစားအစာအတွက် မဟုတ်ဘဲ လူသားဟ နင်လို့ဟို ပေးမဲ့ ထာဝရ အသက်တိုင်အောန် တည်မြဲသော အစားအစာအတွက် လုပ်ဆောင်ကြလော့။ အကျောန်းမှာ ခမည်းတော် ဘုရားသခင်ဟ အဲလူသားဟို အသိအမှတ်ပြုအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","အဲပင်းရင် သူလို့ဟလည်း “ငါလို့ဟ ဘုရားသခင် အလိုတော်ဆိလဲ့အရာဟို ဆောင်ရွက်နိန်ရန် စလို ပြုရမှာတုန်း” ဟု သူ့ဟို မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ယေရှုဟ “ဘုရားသခင် နင့်ဟို လုပ်စေချင်တဲ့အရာဟ ဘုရားသခင် စေလွှတ်သောသူဟို ယုံကြည်ရန်ပင် ဖြစ်အယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","အဲသူလို့ဟ “အဲလိုမို့ ငါလို့ မျော်ယွေ့ ကိုယ်တော်ဟို ယုံကြည်နိန်စေရန် ပစာ နိမိတ်လက္ခဏာဟို ပြရမှာတုန်း၊ ပစာအမှုဟို လုပ်ဆောင်ရမှာတုန်း၊ ");
INSERT INTO dnv_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ကျမ်းစာတွင် ‘ကိုယ်တော်ဟ အေးသူလို့စားရန် ခေါန်းခင်မှ မုန့်ဟို ချပေးအယ်’ ဟု ပါဆိလဲ့အတိုင်း ငါလို့ရဲ့ ဘိုးဘေးများဟ တောကန္တာရတွင် မန္နမုန့်ဟို စားရကြအယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ယေရှုဟ “နင်လို့အား ငါ အမန် ဆိုအယ်၊ မောရှေဟ နင်လို့အား ခေါန်းခင်မှ မုန့်ဟို ပေးတာ မဟုတ်၊ ငါ့ခမည်းတော်ဟ နင်လို့အား ခေါန်းခင်မှ အမန်ဖြစ်သော မုန့်ဟို ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","အကျောန်းမှာ ဘုရားသခင်ရဲ့ မုန့်ဟ ခေါန်းခင်မှ ဆင်းသက်ယွေ့ လောကီသားလို့အား အသက်ဟို ပေးသောသူ ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","အဲအခါ သူလို့ဟ “သခင်ဘုရား၊ အေးမုန့်ဟို ငါလို့အား အစဉ်ပေးပါ” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ယေရှုဟ သူလို့အား “ငါဟ အသက်မုန့် ဖြစ်အယ်၊ ငါ့ဆေဟို လာသောသူဟ ပစာအခါနှိုက်မျှ ဆာငတ်လိမ့်မယ် မဟုတ်၊ ငါ့ဟို ယုံကြည်သောသူဟလည်း ပစာအခါမျှ ယေငတ်လိမ့်မယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","အခု နင်လို့ဟ ငါ့ဟို မျော်ကြသော်လည်း မယုံကြည်ကြဟု ငါ ဆိုခဲ့ပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ငါ့အား ခမည်းတော် ပေးသောသူအပေါင်းလို့ဟ ငါ့ဆေဟို လာကြလိမ့်မယ်။ ငါ့ဆေ လာသောသူဟို ငါဟ ပစာအခါမျှ ပစ်ပယ်လိမ့်မယ် မဟုတ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ပစာကို့ ငါဟ ငါ့အလိုတော်အတိုင်း ခေါန်းခင်ဘုံမှ ဆင်းသက်လာတာ မဟုတ်ဘဲ ငါ့ဟို စေလွှတ်သောသူရဲ့ အလိုတော်အတိုင်း ဆောင်ရွက်ရန် လာတာဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ငါ့ဟို စေလွှတ်သောသူရဲ့ အလိုတော်မှာ ကိုယ်တော်ပေးထားသော သူအပေါင်းလို့တွင် တစုံတယောက်မျှ ငါမဆုံးရှုံးဘဲ နောက်ဆုံးသောနေ့နှိုက် ဆှင်ပြန်ထမြောက်ရန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","သားတော်ဟို ဖူးမျော်ယွေ့ ယုံကြည်လာသူအပေါင်းလို့ဟ ထာဝရအသက်ဟို ရစေရန် ငါ့ခမည်းတော် အလိုတော် ဆိအယ်၊ ငါဟလည်း သူလို့အား နောက်ဆုံးသောနေ့နှိုက် ဆှင်ပြန်ထမြောက်စေမယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ကိုယ်တော်ဟ “ငါသည် ခေါန်းခင်ဘုံမှ ဆင်းသက်သောမုန့် ဖြစ်အယ်” ဟု မိန့်သဖြင့် လူလို့ဟ စတင် ညည်းညူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","သူလို့ဟလည်း “ဟေသူဟ ယောသပ်ရဲ့ သား ယေရှု မဟုတ်လော၊ သူ့မိဘများဟို ငါလို့သိကြတာ မဟုတ်လော၊ အခု သူဟ ပစာကျောန့် ‘ငါဟ ခေါန်းခင်ဘုံမှ ဆင်းသက်လာအယ်’ ဟု ဆိုရတုန်း” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ယေရှုဟ “နင်လို့တတ်တိုင်းကြားတွင် အပစ်မတင်ကြနဲ့” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","“ငါ့ဟို စေလွှတ်သော ခမည်းတော် မပို့ဆောင်ရင် စသူမှ ငါ့ဆေဟို မလာနိန်၊ ငါ့ဆေ လာသောသူဟို ငါဟ နောက်ဆုံးသောနေ့နှိုက် ဆှင်ပြန်ထမြောက်စေမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ပရောဖက်ကျမ်းများတွင် ‘အေးသူအပေါင်းလို့ဟ ဘုရားသခင် သွန်သင်ခြင်းဟို ခံရသောသူများ ဖြစ်ကြလိမ့်မယ်’ ဟု ရေးထားအယ်။ ခမည်းတော်ဆေနှိုက် ကြားယွေ့ နည်းခံယူသောသူတိုင်းဟ ငါ့ဆေဟို လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ဟေလိုပြောရာနှိုက် ခမည်းတော်ဟို မျော်ဖူးသူ တစုံတယောက်ဆိတာဟု မဆိုလို၊ ဘုရားသခင်ဆေမှ ကြွလာသူတဦးတည်းသာ ခမည်းတော်ဟို မျော်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","နင်လို့အား ငါ အမန်ဆိုတာဟ ငါ့ဟို ယုံကြည်သောသူဟ ထာဝရ အသက်ဟို ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ငါဟ အသက်မုန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","နင်လို့ရဲ့ ဖိုးဘေးများဟ တောကန္တာရနှိုက် မန္နမုန့်ဟို စားခဲ့ပေမဲ့ သူလို့ဟ သေဆုံးသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","အဲလိုလဲ ဟေမုန့်ဟို စားသုံးသောသူဟ သေခြင်းနဲ့ ကင်းလွတ်မဲ့အကျောန်း ခေါန်းခင်ဘုံမှ ဆင်းသက်သော မုန့်ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ငါဟ ခေါန်းခင်မှ ဆင်းသက်သော အသက်မုန့် ဖြစ်အယ်။ စသူမဆို ဟေမုန့်ဟို စားရင် ထာဝရ အသက်ဆှင်လိမ့်မယ်။ လောကီသားလို့ အသက်ဆှင်ဖို့ ငါပေးလဲ့မုန့်ဟ ငါရဲ့အသား ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","အဲအခါ ယုဒလူလို့ဟ “ဟေသူဟ သူရဲ့အသားဟို ငါလို့စားရန် စလို ပေးနိန်မှာတုန်း” ဟု သူလို့တတ်တိုင်း စတင် ငြင်းခုံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ယေရှုဟ “နင်လို့အား ငါ အမန်ဆိုအယ်၊ လူသားရဲ့ အသားဟို မစား၊ သူရဲ့ အသွေးဟို မသောက်ရင် နင်လို့နှိုက် အသက်မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ငါ့အသားဟို စားယွေ့ ငါ့အသွေးဟို သောက်သောသူဟ ထာဝရအသက်ဟို ရအယ်၊ ငါဟလည်း နောက်ဆုံးသောနေ့နှိုက် အေးသူအား ဆှင်ပြန်ထမြောက်စေမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","အကျောန်းမှာ ငါ့အသားဟ စစ်မန်သော စားစရာဖြစ်ပင်း ငါရဲ့ အသွေး စစ်မန်သော သောက်စရာ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ငါ့အသားဟို စားယွေ့ ငါရဲ့ အသွေးဟို သောက်သောသူဟ ငါနှိုက် တည်အယ်၊ ငါဟလည်း အေးသူနှိုက် တည်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","အသက်ဆှင်သော ခမည်းတော်ဟ ငါ့ဟို စေလွှတ်ယွေ့ ငါဟ ခမည်းတော်ကျောန့် အသက်ဆှင်သလို ငါ့အသားဟို စားသောသူလည်း ငါ့ကျောန့် အသက်ဆှင်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ဟေဟာဟ ခေါန်းခင်ဘုံမှ ဆင်းသက်သော မုန့်ဖြစ်အယ်။ နင်လို့ ဖိုးဘေးများ စားသုံးခဲ့လဲ့ မုန့်လိုမျိုး မဟုတ်ဘဲ၊ အေးမုန့်ဟို စားလဲ့သူဟလည်း နောက်မှာ သေကြရအယ်။ ဟေမုန့်ဟို စားသောသူဟ အစဉ်မပြတ် အသက်ဆှင်လိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ယေရှုဟ ကပေရနောင်မြို့နှိုက် သွန်သင်စဉ် ဟေအကျောန်းအရာများဟို တရားဇရပ်တွင် မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","သူ့ရဲ့ တဘဲ့တော်များဟ အဲစကားဟို ကြားယွေ့ သူလို့ဟ “ဟေသွန်သင်ချက်လို့ဟ ရမ်းဆာ့ခက်ခဲအယ်။ စသူ နားထောင်နိန်မှာတုန်း” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","တဘဲ့တော်လို့ အဲလို့ ညည်းတွားနေကြတာဟို ယေရှု သိသဖြင့် “ဟေစကားကျောန့် နင်လို့ စိတ်ပျက်ကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","အဲပင်းရင် လူသားဟ မိမိနေရင်းအရပ်ဆေ တက်ကြွတာဟို မျော်ကြရင် နင်လို့ စလို ထင်တုန်း။ ");
INSERT INTO dnv_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ဘုရားသခင်ရဲ့ ဝိညာဉ်တော်သာ အသက်ဟို ဆှင်စေနိန်အယ်၊ လူလို့ရဲ့ တန်ခိုးဟ စလိုမျှ မတတ်နိန်။ နင်လို့အား ငါပြောသောစကားဟ အသက်ဆှင်စေလဲ့ ဝိညာဉ်တော်နဲ့ ဆိုင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","အဲလိုလဲ နင်လို့တွင် မယုံကြည်သောသူအချို့ ဆိအယ်” ဟု မိန့်လေအယ်။ အဲလို မိန့်လဲ့အကျောန်းမှာ မယုံကြသောသူလို့ဟ စသူလို့ဖြစ်ကြတာဟို လည်းကောင်း၊ မိမိဟို သစ္စာဖောက်မဲ့သူဟ စသူဖြစ်တာဟို ယေရှုဟ အစဦးဟပင် သိသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ကိုယ်တော်ဟ “အဲအကျောန်းကျောန့် ခမည်းတော်ဟ အခွင့်မပေးရင် စသူမျှ ငါ့ဆေဟို မလာနိန်ဟု နင်လို့အား ငါပြောခဲ့ပီ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","အဲအချိန်မှစယွေ့ တဘဲ့တော်လို့ထဲမှ အများစုဟ ပြန်လှည့်သွားပင်း ကိုယ်တော်နဲ့အတူ မလိုက်ပါတော့ဘဲ နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","အဲလိုမို့ ယေရှုဟ တဘဲ့တော် ဆယ့်နေယောက်လို့အား “နင်လို့ဟလည်း ငါဆေမှ ထွက်ခွာ သွားလိုကြသလော” ဟု မေးခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ရှိမုန် ပေတရုဟ “သခင်ဘုရား၊ ငါလို့ဟ စသူ့ဆေဟို သွားရမှာတုန်း၊ ထာဝရအသက်နဲ့ဆိုင်သော စကားလို့ဟ ကိုယ်တော်နှိုက်သာ ဆိပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ကိုယ်တော်ဟ ဘုရားသခင်ဆေမှ ကြွလာသော သန့်ဆှင်းသောသူဖြစ်ကျောန်းဟိုလည်း ငါလို့ ယုံကြည်ပင်း သိကြအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ယေရှုဟ “ငါဟ တဆယ့်နေပါးသော နင်လို့ဟို ရွေးချယ်တာ မဟုတ်လော၊ အဲလိုလဲ နင်လို့ထဲမှ တဦးဟ နတ်ဆိုး ဖြစ်အယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","တဆယ့်နေပါးသော တဘဲ့တော်အဝင် ဖြစ်သော်လည်း ကိုယ်တော်ဟို သစ္စာဖောက်မဲ့သူ ရှိမုန် ရှကာရုတ်ရဲ့သား ယုဒဟို ရည်ညွှန်းခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","အဲပင်းရင် ယေရှုဟ ဂါလိလဲပြေတွင် လှည့်လည်သွားအယ်၊ ယုဒ အာဏာဆိသောလို့ဟ ကိုယ်တော်ဟို သတ်ရန် ဆှာကြံနေကြသောကျောန့် ယုဒပြေနှိုက် လှည့်လည်ရန် အလိုမဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","အဲလိုလဲ ယုဒအမျိုးသားလို့ရဲ့ တဲတော်ပွဲ နီးလာသောအခါ၊ ");
INSERT INTO dnv_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ယေရှုရဲ့ ညီလို့ဟ “နင်ပြုသောအရာများဟို နင်ရဲ့ တဘဲ့များ မျော်စေရန် ဂါလိလဲပြေမှ ထွက်ခွာယွေ့ ယုဒပြေဟို သွားလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","စသူမဆို ထင်ပေါ်ကျော်ကြားလိုရင် ပစာအမှုဟိုမျှ လျှို့ဝှက်စွာ မပြုတတ်။ နင်ဟ ဟေအမှုအရာများဟို ပြုမယ်ဆိုပါဟ နင်ရဲ့အကျောန်းဟို ကမ္ဘာတခုလုံး သိအောန်ပြုမန့်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","သူရဲ့ ညီများဟပင် ကိုယ်တော်ဟို မယုံကြည်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ယေရှုဟ သူလို့အား “ငါ့အချိန် မရောက်သေး။ နင်လို့အတွက် ခပ်သိမ်းသောအချိန်ဟ အသင့်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","လောကီသားလို့ဟ နင်လို့ဟို မမုန်းနိန်၊ အဲလိုလဲ ငါ့ဟို မုန်းကြအယ်၊ ဟေလိုမုန်းကြခြင်းမှာ ငါဟ သူလို့ရဲ့ ဆိုးညစ်သောအကျင့်များဟို ပြောသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","အဲပွဲတော်ဟို နင်လို့ သွားကြပါ။ ငါ့အချိန် မရောက်သေးသောကျောန့် အဲပွဲဟို ငါ မသွားဝူး” ဟု ပြန်ယွေ့ မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","အဲလို မိန့်ပင်းနောက် ကိုယ်တော်ဟ ဂါလိလဲပြေတွင် ဆက်ယွေ့ နေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","အဲပွဲတော်ဟို သူ့ရဲ့ ညီများ ထွက်သွားကြပင်းမှ ယေရှုဟလည်း အဲပွဲဟို မထင်မဆှားဘဲ လျှို့ဝှက်စွာ သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ယုဒအာဏာပိုင်လို့ဟ အဲပွဲတော်တွင် ကိုယ်တော်ဟို ဆာလျက် “အဲသူဟ ပစာနားမှာ ဆိတုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","လူအုပ်ဟ ကိုယ်တော်နဲ့ပတ်သက်ယွေ့ များစွာ တီးတိုးပြောဆိုလျက် နေကြအယ်။ လူအချို့လို့ဟ “ဟေသူဟ လူကောင်း ဖြစ်အယ်” ဟု ဆိုကြအယ်။ အချို့ဟ “သူတော်ကောင်း မဟုတ်၊ လူလို့အား မောက်မားလမ်းလွဲစေသူ ဖြစ်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","အဲလိုလဲ သူလို့ဟ ယုဒအာဏာပိုင်လို့ဟို ကြောက်ရွံ့ကြသောကျောန့် ကိုယ်တော်ရဲ့အကျောန်းဟို စသူမျှ ပွင့်လင်းစွာ မပြောရဲကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ပွဲတော်ကျင်းပရက် တဝက်မျှလွန်သောအခါ ယေရှုဟ ဗိမာန်တော်ဟို တက်သွားယွေ့ စတင်ပင်း သွန်သင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ယုဒအာဏာပိုင်လို့ဟ ရမ်းဆာ့အံ့ဩကြယွေ့ “ဟေသူဟ သင်ယူခြင်း မဆိဘဲ ကျမ်းများဟို စလို တတ်တာတုန်း” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ယေရှုဟ “ငါရဲ့ သွန်သင်ချက်ဟ ငါတတ်တိုင်းရဲ့ သွန်သင်ချက် မဟုတ်ဘဲ ငါ့ဟို စေလွှတ်သောသူရဲ့ သွန်သင်ချက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","စသူမဆို အဲသူရဲ့ အလိုတော်ဟို ဆောင်ရွက်လိုသော ဆန္ဒဆိရင် ဟေသွန်သင်ချက်ဟ ဘုရားသခင်ဆေမှ လာသလော အဲဟာမဟုတ်ရင် ငါဟ ကိုယ့်ဆန္ဒအလျောက် ဟောပြောနေသလောဆိုတာဟို သိလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","မိမိအလိုအလျောက် ဟောပြောသောသူဟ မိမိရဲ့ ဘုန်းအသရေဟို ဆှာတတ်အယ်၊ အဲလိုလဲ မိမိဟို စေလွှတ်သောသူရဲ့ ဘုန်းအသရေဟို ဆှာသောသူဟတော့ ဖြောင့်မန်သောသူဖြစ်ပင်း အဲသူနှိုက် အမား မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","မောရှေဟ နင်လို့အား ပညတ်တရားဟို ပေးတာ မဟုတ်လော၊ အဲလိုလဲ နင်လို့တွင် အဲပညတ်တရားဟို နားထောင်သောသူ တစုံတယောက်မျှ မဆိ။ နင်လို့ဟ ငါ့ဟို သတ်ရန် ပစာကျောန့် ဆှာကြတုန်း” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","လူအုပ်ဟလည်း “နင်ဟ နတ်ဆိုးစွဲသောသူ ဖြစ်အယ်၊ စသူဟ နင့်ဟို သတ်ရန် ကြိုးစားလျက်နေတုန်း” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ယေရှုဟ “ငါပြုသော နိမိတ်လက္ခဏာတခုဟို နင်လို့အားလုံးဟ အံ့ဩခြင်း ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","မောရှေဟ အရေဖျားလှီးခြင်း ပညတ်ဟို နင်လို့အားပေးခဲ့သောကျောန့် နင်လို့ရဲ့ အောင်နီငယ်လို့ဟ ဥပုသ်နေ့နှိုက်ပင် အရေးဖျားလှီးခြင်းဟို ပြုကြအယ်၊ အမန်စင်စစ် ဟေအရေဖျားလှီးခြင်းဟ မောရှေဆေမှ မဟုတ်ဘဲ နင်လို့ ဖိုးဘေးဆေမှ လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","လူဟ မောရှေရဲ့ ပညတ်တရား မချိုးဖောက်ရန် နင်လို့ဟ အရေဖျားလှီးခြင်းဟို ခံရရင် ငါဟ ဥပုသ်နေ့နှိုက် လူတကိုယ်လုံးဟို ကျန်းမာလာစေလဲ့အတွက် ပစာကျောန့် ငါ့အား အူထော့ကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","အပြင်လက္ခဏာဟို ထောက်ယွေ့ မစီရင်ကြနဲ့၊ အမန်တရားအတိုင်း စီရင်ကြလော့” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ယေရုရှလင်မြို့သား အချို့လို့ဟ “ဟေသူဟို အာဏာပိုင်လို့ သတ်ရန် ကြိုးစားနေကြတာ မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ကျေ့မန့်၊ သူဟ လူမျော်ကွင်းမှာ ဟောပြောလျက် သူလို့ဟ စလိုအရာဟိုမျှ မပြောကြသလော၊ ဟေသူဟ မေဆှိယဖြစ်ကျောန်းဟို အာဏာပိုင်လို့ဟ အမန်တကယ် သိဆိကြပီလော။ ");
INSERT INTO dnv_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","အဲလိုလဲ ဟေသူဟ ပစာဆေမှ လာတာဟို ငါလို့ သိကြအယ်၊ မေဆှိယ ကြွလာသောအခါ ပစာဆေမှ လာတာဟို စသူမျှ မသိ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ယေရှုဟ ဗိမာန်တော်ထဲတွင် သွန်သင်လျက်နေစဉ် “ဟုတ်အယ်၊ နင်လို့ ငါ့ဟို သိယွေ့ ငါ ဖယ်နားဟ လာတာဟိုလည်း သိကြအယ်။ ငါဟ ကိုယ့်အခွင့်အာဏာနဲ့ လာတာ မဟုတ်ဘဲ၊ ငါ့ဟို စေလွှတ်သောသူဟ ဖြောင့်မတ်သောသူ ဖြစ်အယ်။ နင်လို့ဟ ကိုယ်တော်ဟို မသိကြ၊ ");
INSERT INTO dnv_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","အဲလိုလဲ ငါဟတော့ သူ့ဟို သိအယ် ပစာကို့ ငါဟ အဲအဆှင်ဆေမှ လာယွေ့ အဲအဆှင်ဟ ငါ့ဟို စေလွှတ်အယ်” ဟု ကြွေးကြော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","အဲပင်းရင် လူလို့ဟ ကိုယ်တော်အား ဖမ်းဆီးရန် အခွင့်ဟို ဆှာကြသော်လည်း သူ့အချိန်မကျသေးသောကျောန့် ကိုယ်တော်အား စသူမျှ မဖမ်းဆီးကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","အဲလိုလဲ လူအုပ်ထဲမှ လူအများပင် ကိုယ်တော်ဟို ယုံကြည်လာကြပင်း “မေဆှိယ ကြွလာသောအခါ အေးသူပြုတာထက် ပိုယွေ့ များသော နိမိတ်လက္ခဏာလို့ဟို ပြုမယ်လော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","လူအုပ်လို့ဟ ကိုယ်တော်ရဲ့အကျောန်း အဲလို တီးတိုးပြောဆိုနေတာဟို ဖာရိရှဲလို့ ကြားကြအယ်၊ အဲလိုမို့ သူလို့နဲ့ ယဇ်ပုရောဟိတ်ကြီးလို့ဟ ကိုယ်တော်ဟို ဖမ်းဆီးရန် အစောင့်တပ်သားလို့ဟို စေလွှတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ယေရှုဟ လူလို့အား “ငါဟ နင်လို့နဲ့အတူ ခဏတာနေပင်းရင် ငါ့ဟို စေလွှတ်သောသူဆေဟို ငါ သွားရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","နင်လို့ဟ ငါဟို ဆာသော်လည်း တွေ့ကြလိမ့်မယ် မဟုတ်၊ ငါဆိရာအရပ်ဟိုလည်း နင်လို့ မလာနိန်ကြ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ယုဒအာဏာပိုင်လို့ဟ “ငါလို့ ဆာယွေ့ မတွေ့စေရန် သူဟ ပစာအရပ်ဟို သွားမာလုန်း၊ တပါးအမျိုးသားလို့ နေထိန်ရာ မြို့များဟို သွားယွေ့ တပါးအမျိုးသားလို့ဟို သွန်သင်မာလား။ ");
INSERT INTO dnv_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","သူဟ နင်လို့ ငါ့ဟို ဆာသော်လည်း တွေ့ကြလိမ့်မယ် မဟုတ်၊ ငါဆိရာအရပ်ဟို နင်လို့ မလာနိန်ကြဟု ဆိုအယ်။ ဟေအဓိပ္ပာယ်ဟ ပစာလိုတုန်း” ဟု သူလို့တတ်တိုင်း မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ပွဲတော်ရဲ့ နေ့ထူးနေ့မြတ်ဖြစ်လဲ့ နောက်ဆုံးနေ့နှိုက် ယေရှုဟ ရပ်လျက် “ယေငတ်သောသူဟ ငါ့ဆေဟို လာယွေ့ သောက်လော့၊ ");
INSERT INTO dnv_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ကျမ်းစာဆိုလဲ့အတိုင်း ‘ငါ့ဟို ယုံကြည်သောသူရဲ့ စိတ်နေလုံးထဲမှ အသက်ယေဟ စမ်းချောင်းလို စီးထွက်နေလိမ့်မယ်’ ” ဟု အသံအကျယ်ရီးနဲ့ အော်ဟယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ဟေအရာဟ ကိုယ်တော်ဟို ယုံကြည်သောသူလို့ ခံယူရဆိမဲ့ ဝိညာဉ်တော်ဟို ရည်ညွှန်းယွေ့ မိန့်ခြင်းဖြစ်အယ်။ ယေရှုဟ ဘုန်းအသရေ ထင်ဆှားခြင်း မဆိသေးသောကျောန့် အဲအချိန်နှိုက် ဝိညာဉ်တော်ဟို ပေးတော်မမူသေး။ ");
INSERT INTO dnv_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","နှုတ်ကပတ်တော်ဟို ကြားသောလူအုပ်ထဲမှ အချို့ဟ “ဟေသူသည် အမန်ပင် ပရောဖက်ဖြစ်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","အချို့သောသူလို့ဟ “ဟေသူဟ မေဆှိယ ဖြစ်အယ်” ဟု ဆိုကြအယ်။ အဲလိုလဲ အချို့ဟ “မေဆှိယဟ ဂါလိလဲပြေမှ လာတာ မဟုတ်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“မေဆှိယဟ ဒါဝိဒ်ရဲ့ သားမြေးဖြစ်လိမ့်မယ်ဟု လည်းကောင်း၊ ဒါဝိဒ်နေခဲ့လဲ့ ဗက်လင်မြို့မှ မွေးဖွားလိမ့်မယ် ဟု လည်းကောင်း ကျမ်းစာလာအယ် မဟုတ်လော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","အဲလိုမို့ ယေရှုကျောန့် လူအုပ်လို့ထဲမှာ စိတ်သဘောကွဲလွဲလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","လူအချို့လို့ဟ ကိုယ်တော်ဟို ဖမ်းဆီးလိုကြအယ်၊ အဲလိုလဲ စသူမျှ မဖမ်းဆီးကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","အစောင့်တပ်သားလို့ဟ ယဇ်ပုရောဟိတ်ကြီးလို့နဲ့ ဖာရိရှဲများဆေသို့ ပြန်လာကြသောအခါ သူလို့ဟ “ပစာကျောန့် သူ့ဟို နင်လို့ မခေါ်ဆောင်လာကြတုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","အစောင့်တပ်သားလို့ဟ “ဟေသူဟောပြောသလို စသူမျှ မဟောဖူးပါ” ဟု ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ဖာရိရှဲလို့ဟ “နင်လို့ပင် သူရဲ့လှည့်စားခြင်းဟို ခံရကြပီလော။ ");
INSERT INTO dnv_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ခေါင်းဆောင်လို့ အဲဟာမဟုတ်ရင် ဖာရိရှဲလို့တွင် သူ့ဟို ယုံကြည်ခဲ့သောသူ တဦးတယောက် ဆိသလော။ ");
INSERT INTO dnv_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","အဲလိုလဲ မောရှေရဲ့ ပညတ်တရားဟို မသိသော ဟေသူလို့ဟ ကျိန်ခြင်းဟို ခံရသောသူဖြစ်အယ်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","အဲသူလို့အထဲတွင် နိကောဒင် ပါအယ်၊ သူဟ မခင်ဟ ယေရှုဆေဟို လာဖူးအယ်။ နိကောဒင်ဟ အခြားသူလို့အား ");
INSERT INTO dnv_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ငါလို့ရဲ့ ပညတ်တရားအရ ငါလို့ဟ လူလို့ဆေမှ ကြားနာပင်း သူလို့ပြုသောအမှုလို့ဟို မစစ်ဆေးခင် သူလို့ဟို အပစ်စီရင်နိန်သလော” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","အဲသူလို့ဟ “နင်ဟလည်း ဂါလိလဲပြေသား ဖြစ်သလော၊ ကျမ်းစာဟို လေ့လာကျေ့ရင် ဂါလိလဲပြေမှ ပစာပရောဖက်မျှ မပေါ်ထွန်းတာဟို နင်လို့ သိရလိမ့်မယ်” ဟု ပြန်ပြောအယ်။  ");
INSERT INTO dnv_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","အဲပင်းရင် သူလို့ဟ မိမိနေအိုင်ဟို ပြန်သွားကြပေမဲ့၊ ");
INSERT INTO dnv_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ယေရှုဟ သံလွင်တောင်သို့ ကြွလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","နောက်တနေ့ မနက်စောစောမှာ ကိုယ်တော်ဟ ဗိမာန်တော်ဟို ပြန်သွားခဲ့အယ်။ လူအားလုံးလို့ဟ ကိုယ်တော်ဆေ အတူဝိုင်းလာပင်း၊ ကိုယ်တော်ဟ ထိန်လျက် အဲသူလို့အား စတင်သွန်သင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ကျမ်းတတ်ဆရာလို့နဲ့ ဖာရိရှဲလို့ဟ အိုင်ထောင်ရေးဖောက်ပြန်မှုတွင် ဖမ်းမိသော မိန်းမတယောက်ဟို ခေါ်လာခဲ့ကြပင်း၊ သူလို့ဟ မိန်းမဟို မိမိလို့အားလုံးဆေ့တွင် ရပ်ခိုင်းစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","သူလို့ဟ ယေရှုအား “ဆရာ၊ ဟေမိန်းမ အိုင်ထောင်ရေးဖောက်ပြန်စဉ် ဖမ်းမိပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ပညတ်ကျမ်းတွင် မောရှေဟ အဲသို့သော မိန်းမမျိုးဟို ကျောက်ခဲနဲ့ ပေါက်ယွေ့ သတ်ရမယ်ဟု ပညတ်ထားပါအယ်။ အခု ကိုယ်တော်ဟ စလို ပြောမှာလုန်း။” ");
INSERT INTO dnv_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","သူလို့ဟ ယေရှုဟို စွပ်စွဲနိန်ရန် အေးလို့ ထောင်ချောက်ဆင်ယွေ့ မေးကြခြင်း ဖြစ်အယ်။ အဲလိုလဲ ကိုယ်တော်ဟ ငုံ့ယွေ့ မြေပေါ်တွင် သူရဲ့လက်ညှိုးနဲ့ ရေးခြစ်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","အဲသူလို့ဟ ထပ်တလဲလဲ မေးခွန်းထုတ်ကြသောအခါ ကိုယ်တော်ဟ မော့ကျေ့ယွေ့ “နင်လို့ထဲနှိုက် အပစ်ကင်းသူတယောက်ဟ ဦးရင် သူ့ဟို ကျောက်ခဲနဲ့ ပေါက်စေ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","အဲပင်းရင် တခါ ငုံ့ယွေ့ မြေပေါ်တွင် ရေးခြစ်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","အဲသူလို့ဟ အဲအရာဟို ကြားသောအခါ အသက်ကြီးသူများဟ အစပြုယွေ့ တယောက်ပင်းတယောက် ထွက်သွားကြအယ်။ အဲနေရာတွင် မတ်တတ်ရပ်လျက်နေသော မိန်းမနဲ့အတူ ယေရှု တယောက်ထဲ ကျန်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ယေရှုဟ မော့ကျေ့ယွေ့ “အချင်းမိန်းမ၊ အဲသူလို့ဟ ဖယ်မှာလုန်း၊ နင့်အား အပစ်ဒဏ်စီရင်မဲ့သူ တစုံတယောက်မျှ မဆိသလော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","အေးမိန်းမဟ “တယောက်မှ မဆိတော့ပါ ဆရာ” ဟု ပြန်ပြောအယ်။ ယေရှုဟ “ငါဟလည်း နင့်အား အပစ်ဒဏ် မစီရင်ပီ။ သွားလော့၊ နောက်တခါ အပစ်မလုပ်နဲ့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","တခါ ယေရှုဟ ဖာရိရှဲလို့အား “ငါဟ လောကရဲ့ အလင်းဖြစ်အယ်၊ ငါ့နောက်ဟို လိုက်သောသူဟ အသက်ရဲ့ အလင်းဟို ရယွေ့ ဖယ်ခါမှ မိုက်တွင် သွားလာရလိမ့်မယ် မဟုတ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ဖာရိရှဲလို့ဟ “အခု နင်ဟ ကိုယ့်အကျောန်းဟို သက်သေခံ နေအယ်၊ အဲလိုမို့ နင့်သက်သေခံချက်ဟ မမန်ကန်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ယေရှုဟ “ငါသည် ကိုယ့်အကျောန်းဟို သက်သေခံသော်လည်း၊ ငါရဲ့ သက်သေခံချက်ဟ မန်ကန်အယ်၊ ပစာကို့ ငါဟ ပစာအရပ်မှလာယွေ့ ပစာအရပ်သို့ သွားမယ်ဟို သိသောကျောန့် ဖြစ်အယ်။ နင်လို့ဟ ငါပစာအရပ်မှ လာယွေ့ ပစာအရပ်ဟို သွားမယ်ဟို မသိကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","နင်လို့ဟ လူတွေသတ်မှတ်ထားလဲ့ လမ်းစဉ်အတိုင်း တရားစီရင်တတ်ကြအယ်၊ ငါဟတော့ စသူဟိုမှ တရားစီရင်ခြင်း မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","အဲလိုလဲ ငါ စီရင်မယ်ဆိုရင်လည်း ငါတဦးတည်း စီရင်ခြင်း မဟုတ်၊ ငါ့ဟို စေလွှတ်သော ခမည်းတော်ဟ ငါနဲ့အတူ ဆိသောကျောန့် ငါရဲ့ စီရင်ခြင်းဟ မန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","နင်လို့ရဲ့ ပညတ်ကျမ်းနှိုက် သက်သေနေဦး သဘောတူရင် သူလို့ပြောလဲ့အရာဟ အမန်ဖြစ်အယ်ဟု ရေးသားထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ငါဟ ကိုယ့်အကျောန်းဟို သက်သေခံအယ်၊ ငါ့ဟို စေလွှတ်သော ခမည်းတော်ဟလည်း ငါ့အကျောန်းဟို သက်သေခံအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","အဲသူလို့ဟ “နင်ရဲ့ ခမည်းတော်ဟ ဖယ်နားမှာ ဆိတုန်း” ဟု မေးကြအယ်။ ယေရှုဟ “နင်လို့ဟ ငါ့ဟိုလည်းကောင်း၊ ငါ့ခမည်းတော်ဟိုလည်းကောင်း မသိကြ၊ ပစာကို့ နင်လို့ဟ ငါ့ဟို သိရင် ငါ့ခမည်းတော်ဟိုလည်း သိကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ယေရှုဟ ဟေစကားများဟို ဗိမာန်တော်အတွင်းဆိ အလှူခံသေတ္တာများ ထားရာ အခန်းနှိုက် သွန်သင်ခဲ့အယ်။ ပစာကို့ ကိုယ်တော်ရဲ့ အချိန်မကျသေးသဖြင့် စသူမှ ကိုယ်တော်ဟို မဖမ်းဆီးကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","တဖန် ယေရှုဟ “ငါ သွားရလိမ့်မယ်၊ နင်လို့ဟ ငါ့ဟို ဆာပေမဲ့လည်း နင်လို့ဟ မိမိအပစ်နှိုက် သေကြလိမ့်မယ်။ ငါသွားမဲ့အရပ်သို့ နင်လို့ မလာနိန်ကြ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","အဲလိုမို့ ယုဒအာဏာပိုင်လို့ဟလည်း “ကိုယ်တော်ဟ ငါသွားမဲ့အရပ်ဟို နင်လို့ မလိုက်နိန်ကြ ဟု ပြောအယ်။ ဒါဟ သူ့တတ်တိုင်း သတ်သေမယ်လို့ ဆိုလိုတာလား” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ယေရှုဟလည်း “နင်လို့ဟ အောက်အရပ်သားများ ဖြစ်ကြအယ်၊ အဲလိုလဲ ငါဟ အထက်ဘုံမှ လာအယ်။ နင်လို့ဟ ဟေလောကသားများ ဖြစ်ကြအယ်၊ အဲလိုလဲ ငါဟ ဟေလောကသား မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","အဲကျောန်းကျောန့် နင်လို့ဟ မိမိလို့အပစ်နှိုက် သေကြလိမ့်မယ် ဟု ငါဆိုအယ်။ ငါဟ ‘ငါဖြစ်လဲ့အတိုင်း ငါဖြစ်အယ်’ ဟို နင်လို့ မယုံကြည်ရင် မိမိလို့အပစ်နှိုက် သေလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","သူလို့ဟ “နင်ဟ စသူတုန်း” ဟု မေးကြအယ်။ ယေရှုဟ “ငါစသူဖြစ်တာဟို အစကတည်းဟ နင်လို့အား ငါပြောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“နင်လို့အကျောန်းနဲ့ ပတ်သတ်ယွေ့ ငါပြောစရာ ရမ်းဆာ့ ဆိအယ်၊ နင်လို့အား ပစ်တင်ရှုတ်ချစရာလည်း ရမ်းဆာ့များအယ်။ ငါ့ဟို စေလွှတ်သောသူဟ စစ်မန်ပင်း သူရဲ့ဆေမှ ငါကြားရလဲ့စကားဟိုသာ ဟေလောကနှိုက် ငါဟောပြောအယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ယေရှုဟ ခမည်းတော်ဟို ရည်ညွှန်းယွေ့ ပြောဆိုတာဟို အဲသူလို့ဟ နားမလည်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","အဲလိုမို့ ယေရှုဟ “လူသားဟို မြှောက်ထားသောအခါမှ ငါဟ ‘ငါဖြစ်လဲ့အတိုင်း ငါဖြစ်အယ်’ ဟို လည်းကောင်း၊ ငါဟ ကိုယ့်အလိုအတိုင်း ပစာအမှုဟိုမှ မပြုဘဲ၊ ငါ့ခမည်းတော်ရဲ့ သွန်သင်လဲ့အရာဟိုသာ ပြောတာဟိုလည်းကောင်း နင်လို့ဟ သိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ငါ့ဟို စေလွှတ်သောသူဟ ငါနဲ့အတူ ဆိအယ်၊ ငါဟ အေးအဆှင်နှစ်သက်သော အမှုအရာလို့ဟို အမြဲလုပ်နေသောကျောန့် သူဟ ငါ့ဟို တယောက်တည်း ပစ်မထားဘူး” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ဟေသို့ မိန့်တာဟို ကြားရသော ရမ်းဆာ့သောလူလို့ဟ ယေရှုဟို ယုံကြည်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","အဲလိုမို့ ယေရှုဟ မိမိဟို ယုံကြည်သောသူလို့အား “နင်လို့ဟ ငါရဲ့သွန်သင်တာဟို နာခံရင်၊ နင်လို့ဟ ငါရဲ့ တဘဲ့အမန် ဖြစ်ကြပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","နင်လို့ဟ သမ္မာတရားဟိုလည်း သိသောကျောန့် အေးသမ္မာတရားဟ နင်လို့အား လွတ်မြောက်စေလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","သူလို့ဟလည်း “ငါလို့ဟ အာဗြဟံရဲ့ သားမြေးများ ဖြစ်ကြအယ်၊ စသူ့ဆေမှာမှ ကျွန် မခံခဲ့ဖူးဝူး။ ‘နင်လို့ လွတ်မြောက်လိမ့်မယ်’ ဟု ပစာကျောန့် ပြောတုန်း” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ယေရှုဟ “နင်လို့အားငါ အမန်ပြောတာဟ၊ အပစ်ဆိသူတိုင်းဟ အပစ်ရဲ့ကျွန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ကျွန်ဟ မိသားစုနဲ့ အစဉ်နေတာမဟုတ်၊ သားဟ အစဉ်အမြဲ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","အဲလိုမို့ နင်လို့အား သားတော်ဟ လွတ်မြောက်စေရင် နင်လို့ဟ အမန်တကယ် လွတ်မြောက်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","နင်လို့ဟ အာဗြဟံရဲ့ သားမြေးဖြစ်တာဟို ငါသိအယ်။ အဲလိုလဲ နင်လို့ဟ ငါရဲ့ သွန်သင်ချက်ဟို လက်မခံဘဲ ငါ့ဟို သတ်ဖို့ ကြိုးစားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ငါဟ ငါ့ခမည်းတော် ပြသောအရာများအကျောန်းဟို ငါပြောအယ်၊ အဲလိုလဲ နင်လို့ဟ နင့်ရဲ့ အဖပြောလဲ့အတိုင်း ပြုကြအယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","အဲသူလို့ဟ “ငါလို့ရဲ့ အဖဟ အာဗြဟံ ဖြစ်အယ်” ဟု ဆိုကြအယ်။ ယေရှုဟ “နင်လို့ဟ အာဗြဟံရဲ့ လူပဲ့သငယ်များဖြစ်ရင် အာဗြဟံပြုသလို ပြုကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ဘုရားသခင်ဆေမှ ကြားခဲ့ရသော သမ္မာတရားဟို နင်လို့အား ဟောပြောခဲ့သူ ငါ့ဟို သတ်ရန် နင်လို့ဟ ကြိုးစားကြအယ်။ အာဗြဟံဟ ဟေလို ပြုခဲ့တာ မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","နင်လို့ဟ နင်လို့အဖပြုသော အမှုများဟို ပြုကြအယ်” ဟု မိန့်လေအယ်။ အဲသူလို့ဟလည်း “ငါလို့ဟ သူရဲ့စစ်မန်သော လူပဲ့သငယ်များ ဖြစ်အယ်၊ ငါလို့မှာ ဘုရားသခင်တည်းဟူသော အဖတပါးတည်း ဆိအယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ယေရှုဟ “ဘုရားသခင်သည် နင်လို့ရဲ့ အဖမန်ရင် နင်လို့ဟ ငါ့ဟို ချစ်ကြလိမ့်မယ်၊ ငါဟ ဘုရားသခင်ဆေမှ လာယွေ့ အခု ဟေအရပ်ဟို ရောက်ဆိနေအယ်။ ကိုယ်ပိုင်အခွင့်အာဏာအရ လာတာ မဟုတ်၊ အဲလိုလဲ ကိုယ်တော်ဟ ငါ့ဟို စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","နင်လို့ဟ ငါပြောဆိုတာဟို ပစာကျောန့် နားမလည်ကြတုန်း။ ငါရဲ့ တရားစကားဟို နင်လို့ မနာခံနိန်သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","နင်လို့ရဲ့အဖဟ မာရ်နတ် ဖြစ်အယ်၊ အဲလိုမို့ နင်လို့အဖရဲ့ အလိုဟို လိုက်ယွေ့ နင်လို့ဟ ပြုကြအယ်။ မာရ်နတ်ဟ ဟိုးအရင်ကပင် လူသတ်သမား ဖြစ်ပင်း သူနှိုက် အမန်တရား မဆိသောကျောန့် သူဟ သမ္မာတရားနှိုက် မရပ်တည်ခဲ့ဝူး။ သူဟ ဝါပြောသောအခါ မိမိသဘာဝဟိုသာ လုပ်တာဖြစ်ပင်း ဝါပြောတတ်သောသူလို့ရဲ့ အဖ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","အဲလိုလဲ ငါဟ သမ္မာတရားဟို ပြောသောကျောန့် နင်လို့ မယုံကြည်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ငါနှိုက် အပစ်ဆိကျောန်းဟို စသူဟ သက်သေပြနိန်တုန်း။ ငါဟ အမန်တရား ပြောနေတာတောင်မှ ပစာကျောန့် နင်လို့ဟ မယုံကြည်တုန်း။ ");
INSERT INTO dnv_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ဘုရားသခင်နဲ့ စပ်ဆိုင်သောသူဟ ဘုရားသခင်ရဲ့ စကားဟို နားထောင်တတ်အယ်။ နင်လို့ဟ ဘုရားသခင်နဲ့ မစပ်ဆိုင်သောကျောန့် နားမထောင်ကြ” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ယုဒလူလို့ဟ ယေရှုအား “နင်ဟ ရှမာရိလူဖြစ်ပင်း နတ်ဆိုးစွဲနေတာဟု ငါလို့ပြောသောစကားဟ အမန် မဟုတ်လော” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ယေရှုဟ “ငါသည် နတ်ဆိုးစွဲသောသူ မဟုတ်၊ ငါဟ ငါ့ခမည်းတော်ဟို ချီးမြှောက်အယ်၊ အဲလိုလဲ နင်လို့ဟ ငါ့ဟို ရှုတ်ချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ငါဟ ကိုယ့်တတ်တိုင်း ဂုဏ်အသရေဟို ဆာတာ မဟုတ်ဘဲ ငါရဲ့ ဂုဏ်အသရေဟို ဆာယွေ့ ငါ့ဖက်မှ စီရင်သောသူလည်း ဆိသေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","နင်လို့အား ငါ အမန်ဆိုအယ် ငါ့စကားဟို နာခံသောသူဟ သေခြင်းနဲ့ အစဉ်မပြတ် ကင်းလွတ်လိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ယုဒလူလို့ဟ “နင်နှိုက် နတ်ဆိုးစွဲတာဟို အခု ငါလို့ သိကြအယ်၊ အာဗြဟံဟ သေလွန်ခဲ့ပင်း ပရောဖက်လို့လည်း သေလွန်ကြပီ၊ ငါ့စကားဟို နာခံသောသူဟ သေခြင်းနဲ့ အစဉ်မပြတ် ကင်းလွတ်လိမ့်မယ်” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","“နင်ဟ သေလွန်သော ငါလို့ရဲ့အဖ အာဗြဟံထက် ကြီးမြတ်သလော။ သူဟလည်းသေခဲ့ပင်း ပရောဖက်လို့လည်း အဲတိုင်းတိုင်း သေကြပီ။ နင်ဟ မိမိတတ်တိုင်း စသူလို့ ထင်နေတာတုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ယေရှုဟလည်း “ငါဟ မိမိတတ်တိုင်း ချီးမြှောက်ရင် ငါရဲ့ ဂုဏ်အသရေဟ အလကားကား ဖြစ်အယ်။ ငါ့ဟို ချီးမြှောက်သောသူဟ ငါ့ခမည်းတော် ဖြစ်ပင်း အဲအဆှင်ဟ ငါလို့ရဲ့ ဘုရားသခင် ဖြစ်အယ်ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ဘုရားသခင်ဟို နင်လို့ မသိကြသော်လည်း ငါဟတော့ သူ့ဟို သိအယ်။ အေးအဆှင်ဟို ငါမသိဟု ပြောရင် နင်လို့လိုမျိုး ဝါလဲ့သူဖြစ်လိမ့်မယ်။ အဲလိုလဲ ငါဟ အေးအဆှင်ဟို သိယွေ့ သူ့ရဲ့စကားဟိုလည်း ငါနားထောင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","နင်လို့အဖ အာဗြဟံဟ ငါကြွလာမဲ့ အချိန်ကာလဟို မျော်ဖို့ ရမ်းဆာ့ အလိုဆိအယ်။ မျော်ရသောအခါ ဝမ်းမြောက်ခြင်းဟို ရောက်ရလိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ယုဒလူလို့ဟ သူ့ဟို “နင်ဟ အသက်ငါးဆယ်မျှ မဆိဘဲ နင် အာဗြဟံဟို မျော်ဖူးသလော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ယေရှုဟ “နင်လို့အား ငါ အမန်ဆိုအယ်၊ အာဗြဟံ မမွေးမီဟပင် ငါ ဆိအယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","အဲအခါ သူလို့ဟ ယေရှုဟို ပစ်ရန် ကျောက်ခလုံးဟို ကောက်ယူကြအယ်၊ အဲလိုလဲ ယေရှုဟ တိမ်းဆှောင်ယွေ့ ဗိမာန်တော်မှ ထွက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ယေရှုဟ လမ်းဆှောက်ယွေ့ သွားစဉ် အမေ့ဖိုက်ထဲဟ မျက်စေ့ကန်းသော သူတယောက်ဟို မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ကိုယ်တော်ရဲ့ တဘဲ့တော်လို့ဟ “ဆရာ၊ ဟေသူဟ ပစာအပစ်ကျောန့် မျက်စေ့ကန်းတုန်း။ မိမိ အပစ်ကျောန့်လား အဲဟာမဟုတ်ရင် မိဘ အပစ်ကျောန့်လား” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ယေရှုဟ “သူ့ အပစ်ကျောန့် မဟုတ်၊ မိဘ အပစ်ကျောန့်လည်း မဟုတ်။ သူမျက်စေ့မမျော်ရခြင်းမှာ ဘုရားသခင်ရဲ့ တန်ခိုးတော် သူနှိုက် ထင်ဆှားစေရန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ငါ့ဟို စေလွှတ်သော သူရဲ့အမှုဟို နေ့အချိန်နှိုက် ဆိစဉ် ငါလို့ လုပ်ရမယ်၊ စသူမျှ မလုပ်ဆောင်နိန်သော အချိန်တည်းဟူသော ညအချိန် ရောက်လာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ငါဟ ဟေလောကနှိုက် ဆိနေစဉ် ဟေလောကရဲ့ အလင်း ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ဟေလို မိန့်ပင်းနောက် ယေရှုဟ မြေပေါ်ဟို ဆံထွေးနဲ့ ထွေးယွေ့ ရွံ့လုပ်ပင်း ကန်းနေသောသူရဲ့ မျက်စေ့ဟို ရွံ့နဲ့ လူးယွေ့ ");
INSERT INTO dnv_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","သူ့ဟို “သွားပင်း ရှိလောင် ယေကန်နှိုက် မျက်စေ့ဟို ဆေးလော့” ဟု မိန့်အယ်။ ရှိလောင် အဓိပ္ပာယ်မှာ “စေလွှတ်အယ်” ဟု ဖြစ်အယ်။ အဲသူဟ သွားယွေ့ မျက်စေ့ဟို ဆေးပင်းနောက် မျက်စေ့မျော်လျက် ပြန်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","သူဟ ကျောန်နန်ဖြစ်တာဟို အိုင်နီးချင်းမှစယွေ့ မျော်ဖူးသောသူလို့ဟ “ဟေသူဟ ထိန်ပင်း တောင်းစားလေ့ဆိသောသူ မဟုတ်လော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","လူအချို့လို့ဟ “ဟုတ်အယ်” ဟု လည်းကောင်း၊ အချို့ဟ “အဲသူ မဟုတ်၊ အဲသူနဲ့ တူသောသူ ဖြစ်အယ်” ဟု လည်းကောင်း ဆိုကြအယ်။ သူတတ်တိုင်းပင် “ငါဟ အေးသူပင် ဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","သူလို့ဟ “နင် အခု စလိုမျက်စေ့ မျော်လာတုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","အေးသူဟ “ယေရှု နာမယ်ဆိသော သူတယောက်ဟ ရွံ့လုပ်ယွေ့ ငါ့မျက်စေ့ဟို လူးပင်း ရှိလောင် ယေကန်ဟို သွားယွေ့ မျက်စေ့ဟို ဆေးခိုင်းအယ်။ အဲလိုမို့ ငါဟ သွားယွေ့ ဆေးလိုက်ရာ မျက်စေ့မျော်လာအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","သူလို့ဟ “အဲသူဟ ဖယ်နားမှာ ဆိတုန်း” ဟု မေးကြအယ်။ သူဟ “ငါမသိ” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","လူလို့ဟ မျက်စေ့ကန်းဖူးသော အေးသူဟို ဖာရိရှဲလို့ ဆေဟို ခေါ်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ယေရှုဟ ရွံ့နဲ့ပြုလုပ်ယွေ့ သူရဲ့မျက်စေ့ဟို မျော်စေသောနေ့ဟ ဥပုသ်နေ့ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","အဲပင်းရင် ဖာရိရှဲလို့ဟ စလို နင်ရဲ့ မျက်စေ့မျော်လုန်း ဟု မေးကြအယ်။ သူဟ အေးသူလို့အား “ငါ့မျက်စေ့နှိုက် သူဟ ရွံ့နဲ့လူးပင်း၊ ငါရဲ့မျက်စေ့ဟို ဆေးလိုက်ရာ အခု မျက်စေ့မျော်လာအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ဖာရိရှဲအချို့လို့ဟ “အေးသူသည် ဥပုသ်နေ့ဟို မစောင့်ထိန်းသောကျောန့် ဘုရားသခင်ဆေမှ လာသောသူ မဟုတ်” ဟု ဆိုအယ်။ အခြားသောသူလို့ဟ “အပစ်သားဖြစ်သောသူတဦးဟ ဟေလို့သော နိမိတ်လက္ခဏာလို့ဟို စလို ပြုလုပ်နိန်မှာလဲ” ဟု ဆိုကြအယ်။ အားပင်း သူလို့ထဲတွင် ကွဲပြားခြင်း ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","အေးနောက် ဖာရိရှဲလို့ဟ မျက်စေ့ကန်းဖူးသောသူဆေ တခါပြန်လာယွေ့ “နင့်မျက်စေ့မျော်စေသောသူရဲ့ အကျောန်းဟို နင်စလိုပြောမလုန်း” ဟု မေးကြအယ်။ အေးသူဟ “ပရောဖက် ဖြစ်အယ်” ဟု ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ယုဒအာဏာပိုင်လို့ဟ မခင် အေးသူမျက်စေ့ကန်းတာဟို လည်းကောင်း၊ အခု မျက်စေ့ပြန်ပင်း မျော်လာတာဟို လည်းကောင်း မယုံကြသဖြင့် သူရဲ့မိဘလို့ဟို ခေါ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“ဟေသူဟ နင်လို့ရဲ့ သားလော၊ နင်လို့ပြောလဲ့အတိုင်း အမေ့ဖိုက်ထဲဟပင် မျက်စေ့ကန်းသလော၊ အေးတိုင်းမန်ရင် စလို မျက်စေ့မျော်လာတုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","သူ့ရဲ့ မိဘလို့ဟလည်း “ဟေသူဟ ငါလို့ရဲ့ သား မန်အယ်၊ ပင်းရင် အမေ့ဖိုက်ထဲဟပင် မျက်စေ့ကန်းတာဖြစ်ကျောန်း ငါလို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","အဲလိုလဲ အခု သူဟ စလိုမျက်စေ့မျော်တာဟို ငါလို့ မသိကြ၊ သူ့အား စသူ မျက်စေ့မျော်စေတာဟိုလည်း မသိပါ။ သူ့အား မေးမန့်။ သူဟ အရွယ်ရောက်ပီ၊ သူရဲ့အကျောန်းဟို သူ့တတ်တိုင်း ပြောပြနိန်လိမ့်မယ်” ဟု ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","သူ့ရဲ့ မိဘဟ ဟေလို့ဖြေရခြင်းဟာ ယုဒအာဏာပိုင်လို့ဟို ကြောက်သောကျောန့် ဖြစ်အယ်၊ ယေရှုအား မေဆှိယအဖြစ် ဝန်ခံသောသူ စသူဟိုမဆို တရားဇရပ်မှ မောင်းထုတ်ခံရမယ် ဟု ယုဒလူလို့ဟ သဘောတူဆုံးဖြတ်ပင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","အေးကျောန့် သူ့ရဲ့ မိဘလို့ဟ “သူဟ အရွယ်ရောက်ပီ၊ သူ့ဟို မေးမန့်” ဟု ဆိုကြခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","အေးကျောန့် သူလို့ဟ မျက်စေ့ကန်းဖူးသောသူဟို ဒုတိယအကြိမ် ခေါ်ပင်း “ကတိပေးထားလဲ့အတိုင်း ဘုရားသခင်ဆေ့နှိုက် အမန်တရားဟို ပြောမန့်၊ နင့်ဟို ကျန်းမာစေသောသူဟ အပစ်သားဖြစ်ကျောန်းဟို ငါလို့ သိအယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","အေးသူဟလည်း “ဟေသူဟ အပစ်သား ဖြစ်အယ် အဲဟာမဟုတ်ရင် မဖြစ်အယ်ဟို ငါမသိဝူး။ ငါသိလဲ့တခုမှာ၊ ငါဟ မခင် မျက်စေ့ကန်းယွေ့ အခု မျက်စေ့မျော်အယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","အေးသူလို့ဟလည်း “သူဟ နင့်ဟို စလို ပြုတုန်း၊ စလို နင့်မျက်စေ့မျော်လာတုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","အေးသူဟ “နင်လို့အား ငါပြောပြပင်း ဖြစ်အယ်၊ နင်လို့ဟ နားမထောင်ကြ။ ပစာကျောန့် ထပ်ပင်း ကြားလိုကြတုန်း။ နင်လို့ဟလည်း သူ့ရဲ့ တဘဲ့ ဖြစ်လိုသလော” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","အေးသူလို့ဟ သူ့အား ကဲ့ရဲ့ပင်း “နင်ဟ သူ့တဘဲ့ ဖြစ်အယ်၊ အဲလိုလဲ ငါလို့ဟတော့ မောရှေရဲ့ တဘဲ့များ ဖြစ်အယ်ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ဘုရားသခင်ဟ မောရှေအား ဗျာဒိတ်ပေးခဲ့ကျောန်းဟို ငါလို့ သိအယ်။ ဟေသူဟ ပစာဟလာတာဟို မသိ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","အေးသူဟ “သူဟ ငါ့မျက်စေ့ဟို မျော်စေခဲ့သူ ဖြစ်အယ်၊ အဲလိုလဲ သူဟ ဖယ်နားဟ လာတာဟို မသိရခြင်းမှာ အံ့ဩဖို့ကောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ဘုရားသခင်ဟ အပစ်ဆိသောသူလို့ရဲ့ စကားဟို နားမထောင်တာဟို ငါလို့ သိကြအယ်၊ ဘုရားသခင်ဟို ရိုသေလေးစားယွေ့ အလိုတော်တိုင်း လိုက်ဆှောက်သူရဲ့ စကားဟို နားထောင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","အမိဖိုက်ထဲဟ မျက်စေ့ကန်းသောသူဟို မျက်စေ့မျော်စေဖို့ တတ်နိန်ခြင်းဟို ကမ္ဘာဦးစကတည်းဟ တယောက်မှ မကြားဖူးဝူး။ ");
INSERT INTO dnv_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ဟေသူဟ ဘုရားသခင်ဆေမှ လာသောသူမဟုတ်ရင် ပစာအမှုဟိုမှ မတတ်နိန်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","အေးသူလို့ဟလည်း “နင်ဟ မွေးစဟပင် တကိုယ်လုံးနှိုက် ဒုစရိုက်အပစ်စွဲသောသူဖြစ်ပင်း ငါလို့ဟို သွန်သင်ဖို့ ကြိုးစားနေတာလား” ဟု ဆိုပင်း တရားဇရပ်မှ နှင်ထုတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","သူလို့ဟ သူဟို အပြင်မောင်းထုတ်လိုက်ကျောန်းဟို ယေရှု ကြားယွေ့ ကိုယ်တော်ဟ သူဟို တွေ့သောအခါ၊ “နင်ဟ လူသားဟို ယုံကြည်သလော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","အေးသူဟ “ဆရာ၊ ငါ သူ့ဟို ယုံကြည်နိန်စေရန် အဲသူဟ စသူဖြစ်တာဟို ငါ့ဟို ပြောပြပါ” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ယေရှုဟ “နင်ဟ သူ့ဟို မျော်ခဲ့ပင်း ဖြစ်အယ်၊ သူဟ အခု နင်နဲ့ စကားပြောနေသောသူ ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","အေးသူဟ “သခင်ဘုရား၊ ငါ ယုံကြည်အယ်” ဟု ဆှောက်ယွေ့ ကိုယ်တော်အား ပျပ်ဝပ် ကိုးကွယ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ယေရှုဟ “မျက်စေ့ကန်းသောသူဟို မျော်စေရန်နဲ့ မျက်စေ့မျော်သောသူဟို မျက်စေ့ကန်းစေခြင်းငှာ ငါဟ တရားစီရင်ရန် ဟေလောကဟို ကြွလာခြင်းဖြစ်အယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ကိုယ်တော်နဲ့အတူဆိနေသော ဖာရိရှဲအချို့လို့ဟ အေးစကားဟို ကြားယွေ့၊ “ငါလို့ဟလည်း မျက်စေ့ကန်းသောသူများ ဖြစ်ကြသလော” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ယေရှုဟ “နင်လို့ဟ မျက်စေ့ကန်းသောသူများဖြစ်ခဲ့ကြရင် နင်လို့နှိုက် အပစ်ဆိခဲ့မယ် မဟုတ်၊ အဲလိုလဲ ငါလို့ မျော်အယ်ဟု နင်လို့ အခုဆိုကြသဖြင့် နင်လို့အပစ်ဟ တည်မြဲတည်အယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ယေရှုဟ “နင်လို့အား ငါ အမန်ဆိုတာဟ သိုးခြံထဲဟို ထင်ခါးပေါက်ဟ မဝင်ဘဲ အခြားသောလမ်းနဲ့ ကျော်ဝင်သောသူဟ သူခိုး၊ ထားပြဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ထင်ခါးပေါက်မှ ဝင်သောသူဟ သိုးလို့ရဲ့ သိုးထိန်းဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","အေးသူအား ထင်ခါးစောင့်ဟ သိုးထိန်းအတွက် ထင်ခါးဖွင့်ပေးတတ်အယ်၊ သူရဲ့အသံဟို သိုးလို့ဟ နားထောင်တတ်ကြပင်း၊ သူဟ မိမိသိုးလို့ဟို နာမယ်ဖြင့် ခေါ်ယွေ့ ပြင်ဟို ထုတ်ဆောင်တတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","သူဟ သိုးလို့ဟို အပြင်ထုတ်သောအခါ၊ သိုးလို့ အဆေ့မှ သွားယွေ့၊ သိုးလို့ဟ သူရဲ့ အသံဟို သိသောကျောန့် နောက်ဟ လိုက်တတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","သိုးလို့ဟ လူစိမ်းရဲ့ နောက်ဟို လိုက်လိမ့်မယ် မဟုတ်၊ အဲအစား လူစိမ်းရဲ့အသံဟို မသိသောကျောန့် သူ့ဆေမှ ထွက်ပြေးလိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ယေရှုဟ ဟေပုံဥပမာဟို အေးသူလို့အား မိန့်အယ်၊ အဲလိုလဲ ဖာရိရှဲလို့ဟ ကိုယ်တော် စကားရဲ့ ဆိုလိုရင်းဟို နားမလည်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","အေးကျောန့် တဖန်ယေရှုဟ “နင်လို့အား ငါ အမန်ဆိုတာဟ၊ ငါဟ သိုးလို့ဝင်သော ထင်ခါးပေါက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ငါ့ဆေ့နှိုက် လာသောသူဆိသမျှလို့ဟ သူခိုးနဲ့ ထားပြများ ဖြစ်အယ်၊ အဲလိုလဲ သိုးလို့ဟ သူလို့ရဲ့ စကားဟို နားမထောင်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ငါဟ ထင်ခါးပေါက် ဖြစ်အယ်။ ငါ့အားဖြင့် ဝင်သောသူ စသူမဆို ကယ်တင်ခြင်းခံရလိမ့်မယ်၊ သူလို့ဟ ဝင်ထွက်သွားလာလျက် ကျက်စားရာဟို တွေ့လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","သူခိုးဟ ခိုးခြင်း၊ သတ်ခြင်း၊ ဖျက်ဆီးခြင်းဖို့သာ လာတတ်အယ်၊ ငါဟတော့ သိုးလို့ဟို အသက်ရဆိစေဖို့ သာမက — အဲအသက်ဟို ပြေ့စုံစေဖို့ လာခြင်းဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ငါဟ ကောင်းသော သိုးထိန်း ဖြစ်အယ်၊ ကောင်းသော သိုးထိန်းဟ သိုးလို့အတွက် မိမိအသက်ဟို စွန့်တတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","သိုးလို့ဟို ပိုင်သောသိုးထိန်း မဟုတ်၊ သူငှားဖြစ်သောသူဟ ဝံပုလွေလာတာဟို မျော်ရင်၊ သိုးလို့ဟို ပစ်ထားယွေ့ ထွက်ပြေးတတ်အယ်၊ အဲလိုမို့ ဝံပုလွေဟလည်း သိုးလို့ဟို တိုက်ခိုက်ပင်း ကွဲစေတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","သူငှားဟ သူငှားဖြစ်လဲ့အလျောက် သိုးလို့အတွက် ဂရုမစိုက်ဘဲ ထွက်ပြေးတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","ငါဟ ကောင်းသော သိုးထိန်း ဖြစ်အယ်။ ခမည်းတော်ဟ ငါ့ဟို သိပင်း ငါဟလည်း ခမည်းတော်ဟို သိသလို ငါ့သိုးလို့ဟိုလည်း ငါသိယွေ့ ငါ့သိုးလို့ဟလည်း ငါဟိုသိကြအယ်။ ငါဟ သိုးလို့အဖို့ အသေခံရန် ဆန္ဒဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ဟေသိုးခြံထဲဟ မဟုတ်သော အခြားသိုးလို့ဟိုလည်း ငါပိုင်သေးအယ်။ အေးသိုးလို့ဟိုလည်း ငါဆောင်ခဲ့ရမယ်၊ ငါ့ရဲ့ အသံဟို နားထောင်ပင်း သိုးအုပ်တအုပ်တည်းနဲ့ သိုးထိန်းတယောက်တည်း သူလို့ဟ ဖြစ်လာကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ငါဟ အသက်ဟို ပြန်လည်ရယူရန် ငါရဲ့ အသက်ဟို စွန့်ချင်သော ဆန္ဒဆိသောကျောန့် ခမည်းတော်ဟ ငါ့ဟို ချစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ငါ့အသက်ဟို စသူမှ မလုမယူဘဲ ငါ့ဆန္ဒအလျောက် အသက်ဟို စွန့်ခြင်း ဖြစ်အယ်။ ငါနှိုက် အသက်စွန့်ပိုင်ခွင့်နဲ့ နောက်တဖန် ကိုယ့်အသက်ဟို ပြန်ယူပိုင်သောအခွင့်ဟ ငါနှိုက်ဆိအယ်။ ငါဟ ဟေအမိန့်ဟို ငါ့ခမည်းတော်ဆေမှ ရဆိအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ဟေစကားကြားလဲ့ ယုဒလူလို့ဟ စိတ်သဘောထား ကွဲလွဲသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","သူလို့ထဲမှ အများစုဟ “သူဟ နတ်ဆိုးစွဲပင်း အရူး ဖြစ်အယ်။ ပစာကျောန့် သူရဲ့ စကားဟို နားထောင်ကြတုန်း” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","အဲလိုလဲ အခြားသောသူလို့ဟလည်း “နတ်ဆိုးစွဲသောသူဟ ဟေလိုစကားဟို မပြောနိန်ဝူး၊ နတ်ဆိုးစွဲသောသူဟ မျက်စေ့ကန်းသောသူလို့ဟို မျော်စေဖို့ တတ်နိန်သလော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","အဲအချိန်နှိုက် ယေရုရှလင်မြို့တွင် ဗိမာန်တော်နှိုက် ဆက်ကပ်လဲ့ ပွဲတော်ကျရောက်လျက်ဆိအယ်။ အေးအခါဟ ဆောင်းရာသီဖြစ်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ယေရှုဟ ဗိမာန်တော်နှိုက်ဆိသော ရှောလမုန် မုခ်တွင် လမ်းဆှောက်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","အဲမှာဆိလဲ့ ယုဒလူလို့ဟ ကိုယ်တော်ဟို ဝိုင်းပင်း “နင်ဟ စလောက်ထိ ငါလို့ဟို ယုံမားစေတုန်း၊ နင်ဟ မေဆှိယ မန်ရင် ငါလို့ဟို အတိအလင်းပြောပါ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ယေရှုဟ “နင်လို့အား ငါပြောပင်း ဖြစ်အယ်၊ အဲလိုလဲ နင်လို့ မယုံကြ။ ငါ့ခမည်းတော်ရဲ့ အခွင့်နဲ့ ငါပြုသောအမှုလို့ဟ ငါရဲ့ သက်သေ ဖြစ်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","အဲလိုလဲ နင်လို့ဟ ငါရဲ့ သိုးများ မဟုတ်သောကျောန့် ငါ့ဟို မယုံကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ငါ့သိုးလို့ဟ ငါ့အသံဟို နားထောင်ကြအယ်။ ငါဟ သူလို့ဟို သိယွေ့ သူလို့ဟလည်း ငါ့နောက်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ငါဟ သူလို့အား ထာဝရအသက်ဟို ပေးယွေ့ သူလို့ဟ သေခြင်းနဲ့ အစဉ်မပြတ် ကင်းလွတ်ကြလိမ့်မယ်။ စသူမျှ အဲသိုးလို့ဟို ငါ့လက်မှ လုယူယွေ့ မရနိန်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","သူလို့ဟို ငါအား ပေးသော ငါ့ခမည်းတော်ဟ ခပ်သိမ်းသောသူလို့ထက် ကြီးမြတ်တာဖြစ်ယွေ့၊ စသူမျှ သိုးလို့ဟို ငါ့ခမည်းတော်ရဲ့ လက်မှ မလုမယူနိန်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ခမည်းတော်နဲ့ ငါဟ တလုံးတဝတည်း ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","အေးနောက် ယုဒလူလို့ဟ ကိုယ်တော်ဟို ပစ်ရန် တခါ ကျောက်ခလုံးလို့ဟို ကောက်ယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ယေရှုဟလည်း “ငါဟ ခမည်းတော်ဆေမှ ကောင်းသောအမှုလို့ဟို နင်လို့အား ပြသခဲ့အယ်။ အေးအမှုထဲမှ ပစာအမှုကျောန့် ငါ့ဟို ခဲနဲ့ ပစ်မလုန်း” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","သူလို့ဟ “ကောင်းသောအမှုလို့ကျောန့် ခဲနဲ့ ပစ်တာ မဟုတ်၊ နင်ဟ လူဖြစ်လျက် ဘုရားယောင်ဆောင်ယွေ့ ဘုရားသခင်ဟို ပစ်မားလဲ့ စကားဟို ပြောသောကျောန့် ခဲနဲ့ ပစ်မယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ယေရှုဟလည်း “နင်လို့ရဲ့ ပညတ်ကျမ်းတွင် ဘုရားသခင်ဟ ‘နင်လို့ဟ ဘုရားများ ဖြစ်ကြအယ်’ ဟု ရေးထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ကျမ်းစာပြောလဲ့အရာများဟ အမြဲမန်ကန်ကျောန်းဟို ငါလို့ သိကြအယ်၊ ဘုရားသခင်ဟ မိမိရဲ့ တရားစကားဟို ရဆိသောလူများဟို ဘုရားများ ဟု ခေါ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ခမည်းတော်ဟ ငါ့ဟို ရွေးချယ်ယွေ့ ဟေလောကဟို စေလွှတ်အယ်။ အဲလိုမို့ ငါဟ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်အယ်ဟု ဆိုခြင်းဟ ငါဟ ဘုရားသခင်ဟို ပစ်မားလဲ့စကားဟို ပြောအယ်လို့ စလိုကျောန့် နင်လို့ ဆိုနိန်တုန်း။ ");
INSERT INTO dnv_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ငါဟ ခမည်းတော်ရဲ့ အမှုလို့ဟို ငါမဆောင်ရွက်ရင် ငါ့အား မယုံကြည်ကြနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","အဲလိုလဲ ငါဟ သူ့ရဲ့ အမှုတော်ဟို ဆောင်ရွက်ရင် ငါ့ဟို မယုံသော်လည်း အေးအမှုများဟို ယုံကြလော့၊ အေးလို ယုံကြည်ရင် ခမည်းတော်ဟ ငါနှိုက်ဆိလျက် ငါဟ ခမည်းတော်နှိုက် ဆိကျောန်းဟို နင်လို့ သိယွေ့ နားလည်ကြလိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","အေးသူလို့ဟ ယေရှုဟို ဖမ်းဆီးရန် နောက်တခါ ကြိုးစားကြပြန်အယ်၊ အဲလိုလဲ ကိုယ်တော်ဟ သူလို့ရဲ့ လက်မှ ဆှောင်တိမ်းယွေ့ သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ယေရှုဟ ယော်ဒန်မြစ်တဖက်ဆိ မခင် ယောဟန် နှစ်ခြင်းပေးသောအရပ်ဟို ပြန်လည်သွားယွေ့ အေးအရပ်နှိုက် နေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","လူများလို့ဟ ကိုယ်တော်ဆေဟို ရောက်လာကြအယ်။ သူလို့ဟလည်း “ယောဟန်ဟ ပစာနိမိတ်လက္ခဏာဟိုမျှ မပြ၊ အဲလိုလဲ ဟေလူအကျောန်းဟို ယောဟန် ပြောသမျှ မန်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","အေးအရပ်နှိုက် လူများလို့ဟ ယေရှုဟို ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ဗေသနိရွာမှာနေလဲ့ လာဇရုလို့ ခေါ်လဲ့ လူတယောက်ဟ ဖျားနာလျက် ဆိအယ်။ ဗေသနိရွာတွင် ညီအမဖြစ်ကြသော မာရိနဲ့ မာသလို့ နေထိန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ဟေမာရိဟ သခင်ဘုရားရဲ့ ခြေဟို ဆီမွှေးသွန်းလောင်းယွေ့ မိမိဆံပင်ဖြင့် သုတ်ပေးသူ ဖြစ်အယ်၊ ဖျားနာနေသူလာဇရုဟ သူမရဲ့ မောင်ငယ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ညီအမလို့ဟ ယေရှုဆေဟို စေလွှတ်ယွေ့ “သခင်ဘုရား၊ အဆှင်ချစ်သောသူဟ ဖျားနာလျက် နေအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ယေရှုဟ ဟေစကားဟို ကြားရင်၊ “ဟေအနာဟ သေနာ မဟုတ်၊ ဘုရားသခင်ရဲ့ ဘုန်းဟို ထင်ဆှားစေသော အနာဖြစ်အယ်၊ အေးအနာကျောန့် ဘုရားသခင်ရဲ့ သားတော်ဟလည်း ဘုန်းထင်ဆှားခြင်း ဆိလိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ယေရှုဟ မာသနဲ့ သူမရဲ့ ညီမဟို လည်းကောင်း၊ လာဇရုဟို လည်းကောင်း ချစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","လာဇရု ဖျားနာနေတာဟို သတင်းကြားသောအခါ ကိုယ်တော်ဟ မိမိရောက်ဆိသောအရပ်တွင် နေရက်တိုင်တိုင် ဆက်ယွေ့ နေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","အေးနောက် ကိုယ်တော်ဟ တဘဲ့တော်လို့အား “ယုဒပြေဟို ငါလို့ နောက်တခါ သွားရအောန်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","တဘဲ့တော်လို့ဟ “ဆရာ၊ ယုဒလူလို့ဟ ကိုယ်တော်အား မကြာခင်ဟပင် ခဲနဲ့ ပစ်ရန် ကြိုးစားကြအယ်၊ အေးအရပ်ဟို တဖန်သွားအုံးမယ်လော” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ယေရှုဟ “တနေ့တွင် တဆယ့်နေနာရီ ဆိအယ် မဟုတ်လော။ နေ့အချိန်နှိုက် သွားလာသောသူဟ နေရဲ့ အလင်းရောင်ဟို မျော်သောကျောန့် ခလုတ်မတိုက်ဘဲ ကောင်းစွာ သွားလာနိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ညအချိန်နှိုက် သွားလာသောသူဟ အလင်းရောင်ဟို မရသောကျောန့် ခလုတ်တိုက်ယွေ့ လဲတတ်အယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ယေရှုဟ ဟေလို့မိန့်ပင်းနောက် “ငါလို့ရဲ့ မိတ်ဆွေဖြစ်သော လာဇရုဟ အိပ်မွေ့လျက် နေအယ်၊ သူ့ဟို နိုးဖို့ ငါသွားမယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ကိုယ်တော်ရဲ့ တဘဲ့တော်လို့ဟ “သခင်ဘုရား၊ သူဟ အိပ်မွေ့လျက်နေရင် ကျန်းမာလာလိမ့်မယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ယေရှုဟ လာဇရုသေကျောန်းဟို ရည်ရွယ်ပင်း မိန့်အယ်၊ အဲလိုလဲ ပုံမန် အိပ်မွေ့လျက် နေကျောန်းဟို ဆိုတာ ဟု ကိုယ်တော်ရဲ့ တဘဲ့တော်လို့ဟ ထင်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","အဲလိုမို့ ယေရှုဟ သူလို့အား “လာဇရုဟ သေပီ၊ ");
INSERT INTO dnv_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","နင်လို့ ယုံကြည်လာစေရန် အေးအရပ်နှိုက် ငါမဆိခဲ့သောကျောန့် နင်လို့အတွက် ငါဝမ်းမြောက်အယ်။ အဲလိုလဲ သူ့ဆေဟို သွားကြမယ်” ဟု ဆှင်းဆှင်းလင်းလင်း ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","အမြွှာပူးဟု ခေါ်လဲ့ သောမဟ မိမိရဲ့အဖော် တဘဲ့တော်လို့အား “ငါလို့အားလုံးဟလည်း ကိုယ်တော်နဲ့အတူ အသေခံရန် လိုက်သွားကြရအောန်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ယေရှု ရောက်လာသောအခါ လာဇရုဟို သင်္ဂြိုဟ်ယွေ့ လုတ်တိုင်းနှိုက် လေးရက်မျှဆိပီဖြစ်ကျောန်းဟို တွေ့ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","အခု ဗေသနိရွာဟ ယေရုရှလင်မြို့မှ နေမိုင်အကွာနှိုက်ဆိတာဖြစ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ရမ်းဆာ့သောယုဒလူဟလည်း မာရိနဲ့ မာသလို့ရဲ့ မောင်ငယ် သေဆုံးသောကျောန့် သူလို့ဟို နှစ်သိမ့်ရန် လာရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","မာသဟ ယေရှု လာရောက်ကျောန်းဟို ကြားသောအခါ ကိုယ်တော်ဟို ခရီးဦးကြိုရန် ထွက်သွားအယ်၊ အဲလိုလဲ မာရိဟ နေအိုင်တွင် ထိန်လျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","မာသဟ ယေရှုအား “သခင်ဘုရား၊ ဟေအရပ်တွင် ကိုယ်တော်ဆိခဲ့ရင် ကျွန်မရဲ့ မောင် သေမှာမဟုတ်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","အဲလိုလဲ ဘုရားသခင်ဆေ ကိုယ်တော်တောင်းသမျှလို့ဟို ကိုယ်တော်အား ဘုရားသခင် ပေးမယ်ဟို ကျွန်မသိပါအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ယေရှုဟလည်း “နင်ရဲ့မောင်ငယ် အသက်ပြန်ယွေ့ ဆှင်လိမ့်မယ်” ဟု သူမအား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","မာသဟ “နောက်ဆုံးသောနေ့နှိုက် သေသောသူလို့ ဆှင်ပြန်ထမြောက်သောကာလတွင် သူဟ အသက်ပြန်ယွေ့ ဆှင်မည်ဟို ကျွန်မသိအယ်” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ယေရှုဟ “ငါဟ ထမြောက်ခြင်းနဲ့ အသက်ဆှင်ခြင်းအကျောန်း ဖြစ်အယ်။ ငါ့ဟို ယုံကြည်သောသူဟ သေသော်လည်း ဆှင်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ငါ့ဟို ယုံကြည်ယွေ့ အသက်ဆှင်သောသူဆိသမျှလို့ဟ သေခြင်းနဲ့ အစဉ်မပြတ် ကင်းလွတ်ကြလိမ့်မယ်။ ဟေအရာဟို နင် ယုံကြည်သလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","မာသဟ “ယုံကြည်ပါအယ်၊ သခင်ဘုရား၊ ကိုယ်တော်ဟ ဟေလောကဟို ကြွလာမဲ့ ဘုရားသခင်ရဲ့ သားတော် မေဆှိယဖြစ်တာဟို ကျွန်မ ယုံကြည်အယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ဟေလို့ဆှောက်ပင်းနောက် မာသဟ ပြန်သွားယွေ့ မိမိရဲ့ညီမ မာရိဟို တိတ်တိတ်လေးခေါ်ပင်း “ဆရာ ရောက်လာပီ၊ နင့်ဟို မေးနေအယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","မာရိဟ အေးစကားဟို ကြားသောအခါ ခပ်သုတ်သုတ် ထယွေ့ ကိုယ်တော်ဆေဟို သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","အဲအခါ ယေရှုဟ ရွာထဲဟို မဝင်သေးဘဲ မာသ ခရီးဦးကြိုပြုသောအရပ်နှိုက် ဆိလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","မာရိအား နှစ်သိမ့်စကားပြောရန် နေအိုင်တွင် ဆိနေသော ယုဒလူလို့ဟ မာရိ ခပ်သုတ်သုတ်ထယွေ့ ထွက်သွားတာဟို မျော်ကြရင် ငိုကဖို့ လုတ်တိုင်းဟို သွားတာ ဟု ထင်ကြအယ်။ အေးကျောန့် သူလို့ဟ မာရိရဲ့ နောက်ဟို လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","မာရိဟ ယေရှု ဆိသောအရပ်ဟို ရောက်ယွေ့ ကိုယ်တော်ဟို မျော်သောအခါ ခြေတော်ရင်းနှိုက် ပျပ်ဝပ်လျက် “သခင်ဘုရား၊ ဟေအရပ်နှိုက် ကိုယ်တော်ဆိရင် ကျွန်မရဲ့မောင်ငယ် သေမှာမဟုတ်ဝူး” ဟု ဆှောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ယေရှုဟ မာရိ ငိုကနေတာဟို လည်းကောင်း၊ သူနောက်လိုက်လာသော ယုဒလူလို့ ငိုကနေတာဟို လည်းကောင်း မျော်သောအခါ ရမ်းဆာ့ညှိုးငယ်ခြင်း၊ စိတ်နေလုံးပူပန်ခြင်း ဖြစ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ကိုယ်တော်ဟ “သူ့အလောင်းဟို ပစာနားမှာ သင်္ဂြိုဟ်ကြတုန်း” ဟု မေးအယ်။ အေးသူလို့ဟ “သခင်ဘုရား၊ ကြွယွေ့ ကျေ့မန့်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ယေရှုဟ ငိုကအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","အဲပင်းရင် ယုဒလူလို့ဟ “ကျေ့မန့် လာဇရုဟို ရမ်းဆာ့ချစ်အယ်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","အဲလိုလဲ သူလို့ထဲမှ အချို့လို့ဟ “မျက်စေ့ကန်းသောသူဟို မျော်စေသောသူဟ လာဇရုဟို မသေစေရန် မတတ်နိန်သလော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","တဖန် ယေရှုဟ ရမ်းဆာ့ညှိုးငယ်သောစိတ်နဲ့ လုတ်တိုင်းဂူဟို ကြွလေအယ်။ အေးဂူဟ ကျောက်ဂူဖြစ်ပင်း အဝင်ဝဟို ကျောက်တုံးနဲ့ ပိတ်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ယေရှုဟ “ကျောက်တုံးဟို တောကြလော” ဟု မိန့်အယ်။ သေလွန်သောသူရဲ့အမ မာသဟ၊ “သခင်ဘုရား သူ့ဟို သင်္ဂြိုဟ်တာ လေးရက်ဆိပီ ဖြစ်ယွေ့ အခုဆိုရင် အပုပ်နံ့ ထွက်နေလိမ့်မယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ယေရှုဟ “နင် ယုံကြည်ရင် ဘုရားသခင်ရဲ့ ဘုန်းအသရေဟို မျော်ရလိမ့်မယ်ဟူယွေ့ ငါပြောပီ မဟုတ်လော” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","အဲလိုမို့ သူလို့ဟ ကျောက်တုံးဟို တောလိုက်ကြအယ်။ ယေရှုဟ အထက်ဟိုမော့ကျေ့လျက် “အဖ၊ ငါတောင်းဆှောက်တာဟို နားထောင်သောကျောန့် ကိုယ်တော်ဟို ကျေးဇူးတင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ကိုယ်တော်ဟ ငါရဲ့ ဆုတောင်းသံဟို အမြဲနားထောင်ကျောန်း ငါသိအယ်၊ အဲလိုလဲ ဟေလို့ တောင်းဆှောက်ခြင်းဟ ဝန်းရံလျက်ဆိသော လူလို့ရဲ့အကျိုးအတွက်ဖြစ်ပင်း ငါ့ဟို ကိုယ်တော်စေလွှတ်ကျောန်း သူလို့ ယုံကြည်စေရန်အတွက် ဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","အဲသို့မိန့်ပင်းနောက် ကျယ်လောင်သော အသံဖြင့် “လာဇရု၊ ထွက်လာလော့” ဟု ခေါ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","အေးအခါ သေလွန်သောသူဟ မိမိခြေလက်နှိုက် အဝတ်ဖြင့် ပတ်လျက်၊ မျက်နှာဟိုလည်း ပဝါနဲ့ စည်းလျက် ထွက်လာအယ်။ ယေရှုဟလည်း “သူ့အား ပတ်ထားလဲ့ အဝတ်လို့ဟို ဖြေပေးပင်း သွားခွင့်ပေးလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","အဲလို့မို့ မာရိဆေဟို လာသော ရမ်းဆာ့သော ယုဒလူလို့ဟ ယေရှု ပြုသောအမှုဟို မျော်ရင်၊ ကိုယ်တော်ဟို ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","အဲလိုလဲ အချို့လို့ဟ ဖာရိရှဲလို့ဆေဟို သွားယွေ့ ယေရှု ပြုသောအမှုဟို ကြားပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","အေးအခါ ယဇ်ပုရောဟိတ်ကြီးလို့နဲ့ ဖာရိရှဲလို့ဟ ယုဒတရားလွှတ်တော်နှိုက် စည်းဝေးစေပင်းရင် “ငါလို့ဟ စလို ပြုလျက်နေကြတုန်း၊ အေးသူဟ အံ့ဩဖွယ်သော နိမိတ်လက္ခဏာဟို ပြလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","သူ့ဟို ဟေအတိုင်းလွှတ်ထားရင် လူအားလုံးလို့ဟ သူ့ဟို ယုံကြည်ကြလိမ့်မယ်၊ အေးအခါ ရောမအာဏာပိုင်လို့ဟ လာယွေ့ ငါလို့ရဲ့ ဗိမာန်တော်နဲ့ ငါလို့ရဲ့ လူမျိုးလို့ဟို ဖျက်ဆီးကြလိမ့်မယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","အေးသူလို့ထဲမှ တဦးဖြစ်ပင်း အေးနှစ်တွင် ယဇ်ပုရောဟိတ်မင်းဖြစ်သော ကယာဖ နာမယ်ဆိသောသူဟ “နင်လို့ဟ ပစာအရာဟိုမျှ မသိကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ယုဒလူမျိုးလို့ သေကျေပျက်စီးတာထက်၊ လူမျိုးလို့အတွက် လူတယောက်သေရတာဟ နင်လို့အဖို့ ပိုယွေ့ ကောင်းတာဟို နင်လို့ မသိကြသလော” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","အေးစကားဟို ကိုယ်အလိုအလျောက် ပြောဆိုခြင်းမဟုတ်၊ သူဟ အဲနှစ်တွင် ယဇ်ပုရောဟိတ်မင်းဖြစ်လျက် ယေရှုဟ ယုဒလူမျိုးများအတွက် အသေခံရမယ်ဖြစ်ကျောန်းနဲ့ ");
INSERT INTO dnv_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","အေးလူမျိုးအတွက် သာမက ကွဲပြားလျက်ဆိသော ဘုရားသခင်ရဲ့ လူပဲ့သငယ်လို့ဟို အတူစုဝေးစေရန်အတွက်ပါ ပရောဖက်ပြု ဟောပြောခြင်းဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","အဲကျောန့် သူလို့ဟ အဲနေ့မှစယွေ့ ယုဒအာဏာပိုင်လို့ဟ ယေရှုဟို သတ်ရန် တိုင်ပင်ကြံစည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","အဲကျောန့် ယေရှုဟ ယုဒပြေတွင် ထင်ဆှားစွာ မသွားလာတော့ဘဲ၊ အေးအရပ်မှ ထွက်ယွေ့ တောကန္တာရနဲ့နီးသော ဧဖရိမ် နာမယ်ဆိသောမြို့ဟို ကြွပင်း တဘဲ့တော်လို့နဲ့အတူ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ယုဒလူမျိုးလို့ရဲ့ ပသခါပွဲ နီးလာပီဖြစ်ယွေ့ လူများလို့ဟ မိမိလို့ဟို သန့်ဆှင်းစေရန် ပွဲတော်မတိုင်ခင် နေရပ်အသီးသီးလို့မှ ယေရုရှလင်မြို့ဟို လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","အေးသူလို့ဟ ယေရှုဟို ဆှာလျက် နေကြအယ်၊ သူလို့ဟ ဗိမာန်တော်တွင် စုရုံးကြသောအခါ “သူဟ ပွဲသို့မလာတာဟ သေချာသလော၊ စလို ထင်မှတ်ကြတုန်း” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ယဇ်ပုရောဟိတ်ကြီးလို့နဲ့ ဖာရိရှဲလို့ဟ စသူမဆို ယေရှုဆိရာအရပ်ဟို သိရင် သူ့ဟို ဖမ်းဆီးနိန်ရန် အကျောန်းကြားရမယ်ဟု အမိန့်ထုတ်ပြန်ထားပင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ပသခါပွဲခံချိန် ခြောက်ရက်လိုသောအခါ သေလွန်ပင်းမှ ပြန်ယွေ့ အသက်ပြန်ဆှင်ခဲ့သူ လာဇရု နေထိန်ရာဖြစ်သော ဗေသနိရွာဟို ယေရှုရောက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","လူလို့ဟ ဟေအရပ်နှိုက် ကိုယ်တော်အတွက် ညစာဟို ပြင်ဆင်ကြပင်း မာသဟ ဧည့်ဝတ်ပြုနေအယ်၊ ကိုယ်တော်နဲ့အတူ စားပွဲနှိုက် ထိန်နေသူများထဲတွင် လာဇရုလည်း ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","အဲအခါ မာရိဟ ရမ်းဆာ့အဖိုးထိုက်သော နာဒုဆီမွှေးအစစ် သုံးဆယ်သားဟို ယူယွေ့ ယေရှုရဲ့ ခြေဟို ဆီလိမ်းပင်း မိမိဆံပင်နဲ့ သုတ်အယ်။ အေးဆီမွှေးရဲ့ ရနံ့ဟ နေအိုင်တခုလုံးဟို မွှေးကြိုင်လျက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ယေရှုရဲ့ တဘဲ့တော်လို့ထဲမှ တဦးဖြစ်ပင်း ကိုယ်တော်ဟို သစ္စာဖောက်မဲ့သူ ယုဒရှကာရုတ်ဟ ");
INSERT INTO dnv_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ပစာကျောန့် “ဟေဆီမွှေးဟို ငွေဒင်္ဂါး ၃၀၀ နဲ့ ရောင်းယွေ့ ဆင်းရဲသောသူလို့အား မပေးတာတုန်း” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ဟေလိုပြောရာနှိုက် သူဟ ဆင်းရဲသောသူလို့အား သနားကြင်နာသောကျောန့် မဟုတ်ဘဲ၊ သူဟ သူခိုးသောကျောန့် ဖြစ်အယ်။ သူဟ ပိတ်ဆန်အိတ်ဟို သယ်ရသောသူဖြစ်ယွေ့ အဲအိတ်ထဲမှ ပိတ်ဆန်အချို့ဟို သူ့တတ်တိုင်းအတွက် ခိုးယူသုံးစွဲလေ့ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","အဲလိုလဲ ယေရှုဟ “သူမဟို မနှောင့်ယှက်နဲ့၊ ငါရဲ့ အလောင်းဟို သင်္ဂြိုဟ်မဲ့နေ့အတွက် သူမဟ ဟေဆီမွှေးဟို သိုထားမန့်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ဆင်းရဲသောသူလို့ဟ နင်လို့နဲ့ အမြဲ ဆိလိမ့်မယ်၊ အဲလိုလဲ ငါဟတော့ နင်လို့နဲ့ အမြဲဆိမှာ မဟုတ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ဗေသနိရွာနှိုက် ယေရှု ရောက်ဆိနေကျောန်း ကြားသောအခါ ယုဒလူအများလို့ဟ အဲနေရာဟို လာရောက်ကြအယ်၊ သူလို့ဟ ကိုယ်တော်ကျောန့်သာ လာကြတာ မဟုတ်၊ ကိုယ်တော် အသက်ပြန်ဆှင်စေခဲ့သောသူ လာဇရုဟို မျော်လိုသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","အဲကျောန့် ယဇ်ပုရောဟိတ်ကြီးလို့ဟ လာဇရုဟိုလည်း သတ်ရန် တိုင်ပင်ကြခြင်းမှာ၊ ");
INSERT INTO dnv_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","လာဇရုဟို အကျောန်းပြုယွေ့ ယုဒလူမျိုးများပင် ယဇ်ပုရောဟိတ်ကြီးလို့ဟို ငြင်းပယ်ပင်း ယေရှုဟို ယုံကြည်လာကြသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","နောက်တနေ့နှိုက် ပသခါပွဲဟို လာကြသော လူအုပ်ကြီးလို့ဟ ယေရုရှလင်မြို့သို့ ယေရှု ကြွလာမယ်ဟို ကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","အဲလိုမို့ သူလို့ဟ စွန်ပလွံခက်များဟို ကိုင်လျက် ကိုယ်တော်ဟို ခရီးဦးကြိုပြုရန် ထွက်သွားကြယွေ့ “ဟောရှဏ္ဏာ၊ ထာဝရဘုရားရဲ့ နာမနဲ့ လာသော သခင်ဟ မင်္ဂလာဆိစေမန့်၊ ဣသရေလလို့ရဲ့ ဘုရင်ဟ မင်္ဂလာဆိစေမန့်” ဟု ကြွေးကြော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ကျမ်းစာလာလဲ့အတိုင်း ယေရှုဟ မြည်းသငယ်ဟို တွေ့ပင်း စီးလျက် ကြွလာလေပီ၊ ");
INSERT INTO dnv_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“အို ဇိအုန်မြို့၊ မကြောက်နဲ့။ နင်လို့ရဲ့ ဘုရင်ဟ၊ မြည်းသငယ်ဟို စီးယွေ့ နင်လို့ဆိရာ ကြွလာလေပီ။” ");
INSERT INTO dnv_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ဟေအကျောန်းရာများဟို တဘဲ့တော်လို့ဟလည်း ဦးရင်ဟ နားမလည်ကြဝူး၊ အဲလိုလဲ ယေရှု ဘုန်း ထင်ဆှားခြင်း ဆိသောအခါမှ ဟေအကျောန်းရာများဟ ကိုယ်တော်ရဲ့အကျောန်း ရေးထားခဲ့ခြင်းဖြစ်ပင်း လူလို့ဟ ကိုယ်တော်အပေါ် ဟေအတိုင်းပြုလဲ့ကျောန်းဟို ပြန်သတိရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","လာဇရုဟို လုတ်တိုင်းဂူမှ ခေါ်ထုတ်ယွေ့ သေခြင်းမှ အသက်ပြန်ဆှင်စဉ်ဟ ကိုယ်တော်နဲ့အတူဆိလဲ့ လူအပေါင်းလို့ဟ အဲအကျောန်းဟို သက်သေခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","လူအုပ်လို့ဟ အေးနိမိတ်လက္ခဏာပြကျောန်းဟို သတင်းကြားသောကျောန့် ယေရှုအား တွေ့ရန် လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ဖာရိရှဲလို့ဟ “ငါလို့မှာ လုံးဝအောန်မြင်မှု မဆိ။ ကျေ့မန့်၊ ဟေလောကတခုလုံးပင် အဲသူနောက်ဟို လိုက်သွားကြပီ” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ပွဲအတွင်း ကိုးကွယ်ဝတ်ပြုရန် ယေရုရှလင်မြို့ဟို သွားကြသော လူလို့အထဲတွင် တပါးအမျိုးသားအချို့ ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","သူလို့ဟ ဂါလိလဲပြေ ဗက်ဇဲဒမြို့သားဖြစ်သော ဖိလိပ္ပုဆေဟို သွားယွေ့ “ဆရာ၊ ငါလို့ဟ ယေရှုဟို မျော်လိုအယ်” ဟု တောင်းဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ဖိလိပ္ပုဟ အန္ဒြေဆေသွားပင်း အဲအကျောန်းဟို ပြောအယ်၊ အားပင်း အဲသူနေယောက်လို့ဟ ယေရှုဟို သွားပင်း မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ယေရှုဟ “လူသား ဘုန်းတော် ထင်ဆှားစေမဲ့အချိန် ရောက်လာပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","နင်လို့အား ငါ အမန် ဆိုအယ်၊ ဂျုံစေ့ဟ မြေသို့ကျယွေ့ မပျက်ရင် တစေ့တည်း နေအယ်၊ ပျက်ယွေ့ သွားရင် ရမ်းဆာ့သော အသီးဟို သီးတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","မိမိအသက်ဟို ချစ်သောသူဟ အသက် ဆုံးရှုံးလိမ့်မယ်၊ ဟေလောကတွင် မိမိအသက်ဟို မုန်းသောသူဟ မိမိအသက်ဟို ထာဝရအသက်အတွက် စောင့်ဆှောက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ငါရဲ့အမှုဟို ဆောင်ရွက်သောသူဖြစ်ရင် ငါ့နောက်ဟို လိုက်ရမယ်၊ အဲမှသာ ငါဆိရာအရပ်နှိုက် သူဟလည်း ဆိလိမ့်မယ်။ ငါရဲ့အစေဟို ဆောင်ရွက်သောသူဟို ငါ့ရဲ့ခမည်းတော်ဟ ချီးမြှောက်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“အခု ငါ့ရဲ့ စိတ်နေလုံး ပူပန်ခြင်း ဆိအယ်၊ စလို ငါ ဆှောက်ရမှာတုန်း။ ‘အို အဖ၊ ငါ့အား ဟေဒုက္ခဝေဒနာ ရောက်ချိန်နဲ့ ကင်းလွတ်စေမန့်’ ဟု ဆှောက်ရမယ်လော။ အဲလိုလဲ ငါဟ ဟေဒုက္ခဝေဒနာ ခံဖို့ရန် ရောက်ဆိလာခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","အို ခမည်းတော်၊ ကိုယ်တော်ရဲ့ နာမတော်အား ဘုန်း ထင်ဆှားစေမန့်” ဟု မြွတ်ဆိုအယ်။ အဲအခါ ခေါန်းခင်မှ အသံတော်မှာ “ငါဟ ဘုန်း ထင်ဆှားစေပီ၊ နောက်တဖန်လည်း ထင်ဆှားစေအုံးမယ်” ဟု ပေါ်ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","အေးနေရာတွင် ရပ်လျက်နေကြသော လူအုပ်ကြီးဟ အဲအသံဟို ကြားယွေ့ အချို့ဟ မိုးချုန်းတာဟု ဆိုကြအယ်၊ အချို့ဟလည်း “ကိုယ်တော်အား ခေါန်းခင်တမန် စကားပြောတာ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","အဲလိုလဲ ယေရှုဟ “ဟေအသံဟ ငါ့အတွက် မဟုတ်ဘဲ နင်လို့ အဖို့အတွက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","အခု ဟေလောကရဲ့ တရားစီရင်ခြင်း ကာလ ဖြစ်အယ်၊ ဟေလောကဟို အစိုးရသောသူဟလည်း အခုပင် ပြင်သို့ မောင်းထုတ်ခြင်းဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ငါဟ မြေမှ မြှောက်ထားခြင်းဟို ခံရသောအခါ လူအားလုံးလို့ဟို ငါ့ဆေဟို ငါ ဆွဲခေါ်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","အဲသို့မိန့်ခြင်းမှာ မိမိဟ စလို အသေခံရမယ်ဟို အရိပ်အမြွက်အားဖြင့် ဖော်ပြခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","လူအုပ်ကြီးလို့ဟလည်း “မေဆှိယဟ အစဉ်အမြဲ အသက်ဆှင်အယ်ဟု ပညတ်ကျမ်းဟ ဆိုအယ်။ အဲလိုမို့ လူသားဟ မြှောက်ထားခြင်းဟို ခံရမယ်ဟု ပစာကျောန့် နင်လို့ ဆိုတုန်း၊ အေးလူသားဟ စသူတုန်း” ဟု မေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","အဲကျောန့် ယေရှုဟလည်း “အလင်းဟ နင်လို့တွင် ခဏသာ ဆိလိမ့်အယ်။ နင်လို့အား မိုက် မလွှမ်းမိုးစေရန် အလင်းဆိစဉ်အခါ သွားလာကြလော့၊ မိုက်နှိုက် သွားလာသောသူဟ မိမိဖယ်နားသွားတာဟို မသိ။ ");
INSERT INTO dnv_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","နင်လို့ဟ အလင်းရဲ့လူပဲ့သငယ်များဖြစ်စေရန် နင်လို့နှိုက် အလင်းဆိစဉ်အခါ အလင်းဟို ယုံကြည်ကြလော့” ဟု မိန့်လေအယ်။ အေးလိုမိန့်ပင်းမှ ယေရှုဟ ထွက်ကြွယွေ့ အေးသူလို့ဟို တိမ်းဆှောင်လျက် နေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ယေရှုဟ ရမ်းဆာ့သော နိမိတ်လက္ခဏာလို့ဟို သူလို့မျက်မှောက်နှိုက် ပြသော်လည်း သူလို့ဟ ကိုယ်တော်ဟို မယုံကြည်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ဟေသို့ဖြစ်ပျက်ရခြင်းမှာ၊ “ထာဝရဘုရား၊ စသူဟ ငါလို့ရဲ့ သတင်းစကားဟို ယုံကြည်မှာတုန်း၊ ထာဝရဘုရားရဲ့ တန်ခိုးတော်ဟ စသူအား ဖော်ပြခြင်းခံရမှာတုန်း” ဟူသော ပရောဖက် ဟေရှာယ ဟောဖူးသော စကားဟ ပြေ့စုံခြင်းသို့ ရောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","အဲကျောန်းကျောန့် သူလို့ဟ မယုံကြည်ဝူး။ ပစာကို့ ဟေရှာယ ဟောလဲ့တိုင်းတိုင်း၊ ");
INSERT INTO dnv_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ဘုရားသခင်ဟ သူလို့ရဲ့ မျက်စေ့များဟို ကွယ်စေပင်း သူလို့ရဲ့ စိတ်နေလုံးဟို ခိုင်မာစေသောကျောန့် သူလို့ဟ မျက်စေ့ဖြင့် မမျော်နိန်၊ နေလုံးသားဖြင့် နားမလည်နိန် မလှည့်နိန်၊ သူလို့ဟို ငါ ကုသပေးမယ် ဖြစ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ဟေရှာယဟ ယေရှုရဲ့ ဘုန်းတော်ဟို မျော်သောကျောန့် ဟေလို့ပြောပင်း ကိုယ်တော်ရဲ့အကျောန်းဟို အေးလို့ ပြောခဲ့ခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","စလိုပင်ဖြစ်စေ အာဏာပိုင် အမြောက်အမြားပင် ယေရှုဟို ယုံကြည်လာကြအယ်၊ အဲလိုလဲ ဖာရိရှဲလို့ကျောန့် တရားဇရပ်မှ မောင်းထုတ်ခံရမယ်ဟို စိုးရိမ်ယွေ့ မိမိလို့ ယုံကြည်ကျောန်းဟို ထင်ဆှားစွာ ဝန်မခံကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","သူလို့ဟ ဘုရားသခင်ရဲ့ မျက်နှာသာရခြင်းထက် လူ့မျက်နှာသာရခြင်းဟို ပိုယွေ့ နှစ်သက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","အဲပင်းရင် ယေရှုဟ “ငါ့ဟို ယုံကြည်သောသူဟ ငါ့ဟိုသာ ယုံကြည်တာ မဟုတ်၊ ငါ့ဟို စေလွှတ်သောသူဟိုလည်း ယုံကြည်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ငါ့ဟို မျော်သောသူဟ ငါ့ဟို စေလွှတ်သောသူဟိုလည်း မျော်တတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ငါ့ဟို ယုံကြည်သောသူလို့ဟ မိုက်နှိုက် မနေစေရန် ငါဟ အလင်းအဖြစ် ဟေလောကသို့ ကြွလာပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ငါ့စကားဟို ကြားသောသူဟ မနာခံဘဲနေရင် အေးသူဟို ငါဟ အပစ်မစီရင်။ လောကီသားလို့ဟို အပစ်စီရင်ဖို့ ငါလာတာ မဟုတ်၊ လောကီသားလို့ဟို ကယ်တင်ရန်သာ ငါလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ငါ့ဟို ပစ်ပယ်ယွေ့ ငါ့စကားဟို မနာခံသောသူအား စီရင်သောသူတယောက် ဆိသေးအယ်။ ငါ ဟောပြောသောစကားပင် အဲသူဟို နောက်ဆုံးသောနေ့နှိုက် တရားသူကြီးအဖြစ်နဲ့ တရားစီရင်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ငါဟ ကိုယ်ပိုင်အခွင့်အာဏာအရ ဟောပြောခြင်း မဟုတ်၊ ငါ့ဟို စေလွှတ်သောခမည်းတော်ဟ စလို ငါဟောပြောရမယ်ဟို ပညတ်ပေးလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ခမည်းတော်ရဲ့ အမိန့်ဟ ထာဝရအသက်ရစေတာဟို ငါသိအယ်။ အဲလိုမို့ ခမည်းတော် ပြောစေလိုလဲ့အတိုင်း ငါ ဟောပြောအယ်” ဟု ဟေလိုကြီးသောအသံနဲ့ ကြွေးကြော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","အခုဟ ပသခါပွဲမတိုင်မီနှိုက် တရက် ဖြစ်အယ်။ ယေရှုဟ ဟေလောကမှ ထွက်ခွာယွေ့ ခမည်းတော်ဆေဟို သွားရမဲ့ အချိန်ကျရောက်လာကျောန်းဟို သိအယ်။ ကိုယ်တော်ဟ ဟေလောကဆိ မိမိလူလို့ဟို အစဉ် ချစ်အယ်၊ သူလို့အား အဆုံးတိုင်အောန် ချစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ယေရှုနဲ့ သူ့တဘဲ့တော်လို့ဟ ညစာစားလျက် နေအယ်။ ကိုယ်တော်ဟို သစ္စာဖောက်မဲ့အကျောန်း မာရ်နတ်ဟ ရှိမုန် ရှကာရုတ်ရဲ့သား ယုဒ စိတ်နေလုံးနှိုက် အကြံပေးထားပင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ယေရှုဟ မိမိအား ခမည်းတော်ဟ အာဏာအားလုံး လွဲအပ်ထားကျောန်း၊ မိမိဟ ဘုရားသခင်ဆေမှ ကြွလာယွေ့ ဘုရားသခင်ဆေသို့ ပြန်တော့မယ်ဟိုလည်း သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","အဲလိုမို့ စားပွဲမှ ထယွေ့ ဝတ်လုံတော်ဟို ချွတ်ပင်း၊ ပုဝါဟို ယူယွေ့ သူ့ရဲ့ ခါးဟို စည်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","အဲပင်းရင် ယေဟို အင်တုံနှိုက် လောင်းယွေ့ တဘဲ့တော်လို့ရဲ့ ခြေဟို ဆေးပင်းမှ သူ့ခါးနှိုက် စဲထားသော ပုဝါနဲ့ သုတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ရှိမုန် ပေတရုဆေဟို ရောက်သောအခါ သူဟ “သခင်ဘုရား၊ ကိုယ်တော်ဟ ငါ့ရဲ့ ခြေဟို ဆေးမယ်လော့” ဟု သူ့ဟို မေးဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ယေရှုဟ “ငါ ပြုသောအမှုဟို အခု နင်မသိပေမဲ့လည်း နောက်မှ သိလိမ့်မယ်” ဟု သူ့ဟို ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ပေတရုဟလည်း “မဟုတ်ဝူး၊ ကိုယ်တော်ဟ ငါ့ရဲ့ ခြေဟို ပစာခါမှ မဆေးရ” ဟု ပြောအယ်။ ယေရှုဟ “နင့်ခြေဟို ငါ မဆေးရရင် နင်ဟ ငါ့တဘဲ့ ဖြစ်မှာ မဟုတ်တော့ဝူး” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ရှိမုန် ပေတရုဟ “သခင်ဘုရား၊ ငါ့ရဲ့ခြေဟိုသာ မဆေးပါနဲ့၊ ငါ့ရဲ့ လက်နဲ့ ဦးခေါင်းဟိုလည်း ဆေးပါ” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ယေရှုဟ “ယေချိုးပင်းသောသူဟ သူလို့ရဲ့ခြေဟို ဆေးခြင်းမှတပါး ဆေးရသောအကျောန်း မဆိ ၊ တကိုယ်လုံး စင်ကြယ်အယ်။ နင်လို့ထဲမှ တယောက်ဟလွဲပင်း အားလုံးစင်ကြယ်အယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","အကျောန်းမှာ ယေရှုဟ မိမိအား သစ္စာဖောက်မဲ့သူဟို သိပင်းဖြစ်သောကျောန့် “နင်လို့အားလုံး စင်ကြယ်တာ မဟုတ်” ဟု မိန့်ရခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ယေရှုဟ သူလို့ရဲ့ခြေဟို ဆေးပင်းနောက် ဝတ်လုံဟို ပြန်ယွေ့ ဝတ်ပီး သူ့နေရာဟို ပြန်သွားအယ်။ ကိုယ်တော်ဟ “နင်လို့အတွက် ငါပြုခဲ့သောအမှုဟို နားလည်ကြသလော။” ");
INSERT INTO dnv_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“နင်လို့ဟ ငါ့ဟို ဆရာဟူယွေ့ လည်းကောင်း၊ သခင်ဘုရားဟူယွေ့ လည်းကောင်း ခေါ်တတ်ကြအယ်၊ အဲစကားဟာလည်း ဟုတ်မန်သောစကား ဖြစ်အယ်၊ ပစာကို့ နင်လို့ခေါ်လဲ့အတိုင်း ငါမန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ငါဟ နင်လို့ရဲ့ သခင်ဘုရား၊ ဆရာဖြစ်လျက်နဲ့ နင်လို့ရဲ့ခြေဟို ဆေးပေးခဲ့အယ်။ အဲကျောန့် နင်လို့ဟလည်း အချင်းချင်းလို့ရဲ့ ခြေဟို ဆေးကြော ပေးသင့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ငါဟ နင်လို့နှိုက် ပြုသလို နင်လို့ဟလည်း ပြုကြရန် ပုံသက်သေဟို ပြခဲ့ပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","နင်လို့အား ငါ အမန်ဆိုတာဟ အစေခံသည် သူ့သခင်ထက် ကြီးမြတ်တာ မဟုတ်၊ တမန်ဟလည်း စေလွှတ်သောသူထက်သာယွေ့ ကြီးမြတ်တာ မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ဟေအရာလို့ဟို နင်လို့အခု သိယွေ့ အဲအတိုင်းကျင့်ရင် နင်လို့ဟ မင်္ဂလာဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“နင်လို့ဆိသမျှဟို ငါရည်မှတ်ယွေ့ ပြောတာ မဟုတ်၊ ငါရွေးကောက်သောသူလို့ဟို ငါ သိအယ်။ အဲလိုလဲ ကျမ်းစာချက် ပြေ့စုံစေမဲ့အကျောန်း ‘ငါရဲ့အစာဟို ဝေမျှသောသူဟ ငါ့ဟို ဆန့်ကျင်ဘက်ပြုလေ့မယ်’ ဟု ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","အဲသို့ဖြစ်ပျက်သောအခါ ‘ငါဟ ငါဖြစ်လဲ့အတိုင်း ငါဖြစ်တာဟို’ နင်လို့ ယုံကြည်လာကြစေရန် အဲအရာမဖြစ်ပျက်ခင် အခု နင်လို့အား ငါပြောနှင့်ပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","နင်လို့အား ငါ အမန် ဆိုတာဟ ငါစေလွှတ်သောသူဟို လက်ခံသောသူဟ ငါ့ဟို လက်ခံအယ်၊ ငါ့ဟို လက်ခံသောသူဟလည်း ငါ့ဟို စေလွှတ်သောသူဟို လက်ခံအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ယေရှုဟ ဟေအကျောန်းအရာလို့ဟို မိန့်ပင်းမှ စိတ်နေလုံးပူပန်ခြင်း ဆိယွေ့ “နင်လို့အား ငါ အမန်ဆိုအယ်၊ နင်လို့ထဲမှ တယောက်ဟ ငါ့ဟို သစ္စာဖောက်လိမ့်မယ်” ဟု သက်သေခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","တဘဲ့တော်လို့ဟ စသူဟို ရည်မှတ်ယွေ့ မိန့်တာဟို တွေးယွေ့ မရနိန်သဖြင့် အချင်းချင်း တယောက်ဟိုတယောက် ကျေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","တဘဲ့တော်လို့ထဲမှ တဦးဖြစ်လဲ့ ယေရှု ချစ်သော သူဟ ကိုယ်တော်ရဲ့ ဘေးဘက်နှိုက် ထိန်လျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ရှိမုန် ပေတရုဟလည်း “ကိုယ်တော်ဟ စသူ့ဟို ဆိုတာတုန်း” ဟု မေးဆှောက်ပင်း အဲတဘဲ့တော်အား မျက်ရိပ်ပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","အဲလိုမို့ အေးတဘဲ့တော်ဟ ယေရှုရဲ့ ဘေးဟို ကပ်ပင်း “သခင်ဘုရား၊ အဲသူဟ စသူတုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ယေရှုဟလည်း “ဟေမုန့်ကတစ်ဟို ပန်းကန်ထဲတွင် နှစ်ယွေ့ ငါ ပေးသောသူဟ အဲသူပင် ဖြစ်အယ်” ဟု မိန့်အယ်။ အဲမုန့်ကတစ်ဟို ပန်းကန်တွင် နှစ်ပင်း ရှိမုန် ရှကာရုတ်ရဲ့သား ယုဒအား ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","အဲမုန့်ဟို ခံယူပင်းနောက် စာတန်ဟ သူရဲ့အထဲဟို ဝင်လေအယ်။ ယေရှုဟ ယုဒအား “နင်ပြုရမဲ့အမှုဟို အလျင်အမြန်ပြုလော့” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","အဲလိုလဲ ယေရှုဟ ပစာကျောန့် ဟေသို့မိန့်တာဟို စားပွဲနှိုက် ထိန်နေသောသူတယောက်မျှ နားမလည်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","အချို့သောတဘဲ့တော်လို့ဟ ယုဒသည် ပိတ်ဆန်အိတ်ဟို ထိန်းသိမ်းရသောသူဖြစ်သောကျောန့် ယေရှုဟ ဟေပွဲအတွက် လိုအပ်သောအရာများဟို ဝယ်ယူလော့ အဲဟာမဟုတ်ရင် ဆင်းရဲသောသူလို့အား တစုံတခုဟို ပေးသင့်အယ်ဟု ထင်မှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ယုဒဟ မုန့်ကတစ်ဟို ခံယူပင်းရင် ခုတုံး ထွက်သွားအယ်။ အဲအချိန်ဟ ညအချိန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ယုဒထွက်သွားပင်းနောက် ယေရှုဟ “အခု လူသားဟ ဘုန်းတော် ထင်ဆှားခြင်း ဆိယွေ့ ဘုရားသခင်ဟလည်း လူသားအားဖြင့် ဘုန်းတော် ထင်ဆှားခြင်း ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ဘုရားသခင်ဟ လူသားအားဖြင့် ဘုန်းထင်ဆှားခြင်း ဆိရင်၊ ဘုရားသခင်ဟ မိမိတတ်တိုင်းအားဖြင့် သူရဲ့ဘုန်းတော်ဟို ထင်ဆှားစေလိမ့်မယ်၊ အဲဘုန်းတော်ဟို ခုတုံး သူ့ဟို ထင်ဆှားစေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ငါချစ်လဲ့ လူပဲ့သငယ်လို့၊ ငါဟ နင်လို့နဲ့အတူ ခဏသာ နေရလိမ့်မယ်။ နင်လို့ဟ ငါ့ဟို ဆှာကြလိမ့်မယ်၊ အဲလိုလဲ ‘ငါသွားရာအရပ်ဟို နင်လို့ မလာနိန်ကြ’ ဟု ယုဒအာဏာပိုင်လို့အား ပြောခဲ့လဲ့အတိုင်း အခု နင်လို့အား ငါပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","အချင်းချင်း ချစ်ကြလော့ဟု ပညတ်သစ်ဟို နင်လို့အား ငါပေးအယ်။ ငါဟ နင်လို့ဟို ချစ်လဲ့တိုင်းတိုင်း နင်လို့ဟလည်း အချင်းချင်း ချစ်ကြရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","နင်လို့ဟ အချင်းချင်း ချစ်ကြရင် လူအပေါင်းလို့ဟ အဲမေတ္တာဟို ထောက်ယွေ့ နင်လို့ဟ ငါရဲ့ တဘဲ့များ ဖြစ်ကျောန်းဟို သိကြလိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ရှိမုန် ပေတရုဟ ကိုယ်တော်အား “သခင်ဘုရား၊ ပစာအရပ်ဟို ကြွမှာတုန်း” ဟု မေးဆှောက်အယ်။ ယေရှုဟ “ငါသွားရာအရပ်သို့ နင်ဟ အခု မလိုက်နိန်၊ နောက်မှ လိုက်ရလိမ့်မယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ပေတရုဟလည်း “သခင်ဘုရား၊ ပစာကျောန့် ကိုယ်တော်နဲ့အတူ အခု မလိုက်နိန်တုန်း။ ကိုယ်တော်အတွက် ငါဟ အသက်ဟိုပင် စွန့်ပါမယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ယေရှုဟလည်း “နင်ဟ ငါ့အတွက် တကယ်ဘဲ နင့်အသက်ဟို စွန့်မယ်လော၊ နင့်အား ငါ အမန်အကန် ဆိုအယ်၊ ကြက်မတွန်ခင် နင်ဟ ငါ့ဟို မသိဟု သုံးကြိမ်တိုင်အောန် ငြင်းဆိုလိမ့်မယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ယေရှုဟ “နင်လို့ စိတ်နေလုံးပူပန်ခြင်း မဆိစေနဲ့။ ဘုရားသခင်ဟို ယုံကြည်ကြလော့၊ ငါ့ဟိုလည်း ယုံကြည်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ငါ့အဖရဲ့ အိုင်တော်နှိုက် နေစရာအခန်း ရမ်းဆာ့ ဆိအယ်၊ မဆိရင် မဆိကျောန်း နင်လို့အား ငါ ပြောခဲ့လိမ့်မယ်၊ နင်လို့အတွက် နေစရာပြင်ဆင်ရန် ငါသွားရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","အဲသို့သွားယွေ့ နင်လို့အတွက် နေရာပြင်ဆင်ပင်းရင် ငါဆိရာအရပ်နှိုက် နင်လို့လည်း ဆိစေရန် ပြန်လာယွေ့ နင်လို့အား ငါ့နဲ့အတူဆိစေရန် သိမ်းဆည်းမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ငါသွားရာအရပ်သို့ ရောက်သောလမ်းဟို နင်လို့ သိကြအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","သောမဟ “သခင်ဘုရား၊ ကိုယ်တော်ဟ ပစာအရပ်သို့ သွားမယ်ဟို ငါလို့ မသိတာဖြစ်ယွေ့ အဲလမ်းဟို ငါလို့ စလို သိနိန်မှာတုန်း” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ယေရှုဟ “ငါဟ လမ်းခရီး၊ သမ္မာတရားနဲ့ အသက် ဖြစ်အယ်။ ငါ့ဟို အမှီမပြုရင် စသူမှ ခမည်းတော်ဆေဟို မရောက်နိန်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","အခု နင်လို့ဟ ငါ့ဟို သိကြပီ ဖြစ်ယွေ့ ငါ့ခမည်းတော်ဟိုလည်း သိကြလိမ့်မယ်၊ အခုမှစယွေ့ ခမည်းတော်ဟို နင်လို့ သိကျွမ်းပင်း မျော်ရကြလေပီ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ဖိလိပ္ပုဟ ကိုယ်တော်အား “သခင်ဘုရား၊ ခမည်းတော်ဟို ငါလို့အား ပြမန့်၊ အဲသို့ပြရင် ငါလို့အတွက် လုံလောက်ပီ” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ယေရှုဟ “ဖိလိပ္ပု၊ ငါဟ နင်လို့နဲ့အတူ ဟေမျှလောက်ကြာအောန် နေခဲ့ပင်းဖြစ်လျက် ငါ့ဟို နင် မသိသေးသလော၊ ငါ့ဟို မျော်သောသူဟ ခမည်းတော်ဟို မျော်အယ်။ အဲလိုမို့ ‘ခမည်းတော်ဟို ငါလို့အား ပြပါ’ ဟု ပစာကျောန့် နင်လို့ ပြောတုန်း။ ");
INSERT INTO dnv_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ငါဟ ခမည်းတော်နှိုက် ဆိကျောန်းနဲ့ ခမည်းတော်ဟ ငါနှိုက် ဆိကျောန်းဟိုလည်းကောင်း မယုံကြည်သလော၊ နင်လို့အား ငါပြောသောစကားလို့ဟ ကိုယ်အလိုအလျောက် ငါပြောတာ မဟုတ်။ ငါနှိုက် တည်နေသော ခမည်းတော်ဟ သူ့ရဲ့ အမှုများဟို ပြုခြင်းဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ငါဟ ခမည်းတော်နှိုက် ဆိယွေ့ ခမည်းတော်ဟ ငါနှိုက် ဆိကျောန်းဟို ယုံကြလော့။ မယုံရင် ငါပြုသောအမှုများဟို ထောက်ယွေ့ ယုံကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","နင်လို့အား ငါ အမန် ဆိုအယ်၊ ငါ့ဟို ယုံကြည်သောသူဟ ငါပြုသောအမှုလို့ဟို ပြုလိမ့်မယ်၊ အဲအမှုလို့ထက်သာယွေ့ ကြီးသောအမှုလို့ဟိုလည်း ပြုလိမ့်မယ်၊ ပစာကို့ ငါဟ ခမည်းတော်ဆေဟို သွားမယ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","နင်လို့ဟ ငါရဲ့ နာမဟို အမှီပြုလျက် ဆုတောင်းသမျှအတိုင်း ငါ ပြုမယ်၊ အဲကျောန့် ခမည်းတော်ဟ သားအားဖြင့် ဘုန်းထင်ဆှားလိမ့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","နင်လို့ဟ ငါရဲ့နာမဟို အမှီပြုယွေ့ တစုံတခုသောဆုဟို ငါ့ဟို တောင်းရင် တောင်းလဲ့အတိုင်း ငါ ပြုမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“နင်လို့ဟ ငါ့ဟို ချစ်ရင် ငါ့ပညတ်လို့ဟို စောင့်ထိန်းလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ငါဟ ခမည်းတော်ဟို တောင်းဆှောက်သဖြင့် နင်လို့နဲ့အတူ အစဉ်အမြဲဆိယွေ့ နင်လို့အား မစသော အခြားသောသူတပါးဟို ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","သူဟ ဘုရားသခင်အကျောန်းဆိုင်ရာ သမ္မာတရားဟို ဖော်ပြသော ဝိညာဉ်တော် ဖြစ်အယ်။ လောကီသားလို့ဟ အေးဝိညာဉ်တော်ဟို မျော်လည်း မမျော်၊ သိလည်းမသိသဖြင့် မခံမယူနိုင်။ အဲလိုလဲ ဝိညာဉ်တော်ဟ နင်လို့နဲ့အတူ တည်နေယွေ့ နင်လို့နှိုက် ဆိသောကျောန့် နင်လို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ငါဟ နင်လို့ဟို မိဘမဲ့အဖြစ် လောထားမှာ မဟုတ်၊ နင်လို့ဆေဟို ငါလာဦးမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ခဏကြာပင်းမှ လောကသားလို့ဟ ငါ့ဟို မျော်ကြရမယ် မဟုတ်သော်လည်း နင်လို့ဟ မျော်ကြရလိမ့်မယ်၊ ငါဟ အသက်ဆှင်သောကျောန့် နင်လို့ဟလည်း အသက်ဆှင်ရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","အဲနေ့တွင် ငါ့ခမည်းတော်နှိုက် ငါဆိတာဟို လည်းကောင်း၊ နင်လို့ဟ ငါနှိုက် ဆိယွေ့ ငါဟ နင်လို့နှိုက် ဆိတာဟို လည်းကောင်း နင်လို့ သိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ငါ့ပညတ်လို့ဟို နာခံယွေ့ စောင့်ထိန်းသောသူဟ ငါ့ဟို ချစ်သောသူ ဖြစ်အယ်။ ငါ့ဟို ချစ်သောသူဟို ငါ့ခမည်းတော်ဟ ချစ်လိမ့်မယ်၊ ငါဟလည်း သူ့လို့ဟို ချစ်ယွေ့ သူဆေနှိုက် မိမိတတ်တိုင်း ထင်ဆှားစေမယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ယုဒရှကာရုတ် မဟုတ်သော ယုဒဟ “သခင်ဘုရား၊ ကိုယ်တော်အား ငါလို့ဆေဟို ထင်ဆှားစေရန် ကြံရွယ်သော်လည်း လောကသားလို့ဆေ မထင်ဆှားတာဟ စလိုတုန်း” ဟု မေးဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ယေရှုဟ ယုဒအား “ငါ့ဟို ချစ်သောသူဟ ငါ့သွန်သင်ချက်ဟို နားထောင်လိမ့်မယ်။ ငါ့ခမည်းတော်ဟ အေးသူဟို ချစ်လိမ့်မယ်၊ ငါ့ခမည်းတော်နဲ့ ငါဟလည်း သူ့ဆေဟို လာယွေ့ သူနဲ့အတူ နေထိန်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ငါ့ဟို မချစ်သောသူဟ ငါ့သွန်သင်ချက်ဟို နားမထောင်။ နင်လို့ကြားရသော သွန်သင်ချက်ဟ ငါ့သွန်သင်ချက် မဟုတ်၊ ငါ့ဟို စေလွှတ်သော ခမည်းတော်ရဲ့ သွန်သင်ချက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“နင်လို့နဲ့အတူ ဆိစဉ်တွင် ဟေအရာလို့ဟို ငါပြောခဲ့ပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ခမည်းတော်ဟ ငါ့နာမကျောန့် စေလွှတ်လဲ့ မစသောသူတည်းဟူသော သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ နင်လို့အား ခပ်သိမ်းသောအရာလို့ဟို သွန်သင်ပေးယွေ့ ငါပြောခဲ့သမျှသောအရာလို့ဟို နင်လို့အား ပြန်လည် သတိရစေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ငါဟ ငြိမ်သက်ခြင်းဟို နင်လို့နှိုက် ထားခဲ့အယ်၊ ငါရဲ့ ငြိမ်သက်ခြင်းဟို နင်လို့အား ငါပေးအယ်။ ဟေလောကသားလို့ ပေးသလို ငါပေးတာ မဟုတ်။ နင်လို့ စိတ်နေလုံးပူပန်ခြင်းနဲ့ ကြောက်ရွံ့ခြင်း မဆိစေနဲ့။ ");
INSERT INTO dnv_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘ငါ အခုသွားသော်လည်း နင်လို့ဆေဟို ပြန်လာဦးမယ်’ ဟု ငါပြောတာဟို နင်လို့ ကြားခဲ့ပီ။ နင်လို့ဟ ငါ့ဟို ချစ်ရင် ခမည်းတော်ဆေဟို ငါသွားမည်ဟို ဝမ်းမြောက်ကြလိမ့်မယ်၊ အကျောန်းမှာ ငါ့ခမည်းတော်ဟ ငါ့ထက် သာယွေ့ ကြီးမြတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","အဲအမှုအရာ ဖြစ်ပျက်လာသောအခါ နင်လို့ ယုံကြည်စေရန် မဖြစ်ပျက်ခင်ဟပင် နင်လို့ဟို အခု ငါပြောနှင့်ပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","နင်လို့နဲ့ များစွာ ပြောတော့မှာ မဟုတ်၊ အဲအကျောန်းမှာ ဟေလောကဟို အုပ်ချုပ်သောသူဟ ရောက်ဆိလာတော့မယ်။ သူဟ ငါ့အပေါ်နှိုက် စလိုအခွင့်အာဏာမျှ မဆိ၊ ");
INSERT INTO dnv_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","အဲလိုလဲ ငါဟ ခမည်းတော်ဟို ချစ်ကျောန်း ဟေလောကအား သိစေရန် ငါ့ဟို ခမည်းတော်မှာလဲ့အတိုင်း ငါပြုအယ်။ “ထကြလော့၊ ဟေအရပ်မှ သွားကြကုန်စို့” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ငါဟ မန်သော စပျစ်နွယ်ပင် ဖြစ်အယ်၊ ငါ့ခမည်းတော်ဟလည်း ဥယျာဉ်ပိုင်ဆှင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ငါနှိုက် အသီးမသီးသော အကိုင်းအခက် ဆိသမျှလို့ဟို ခုတ်ပစ်အယ်၊ အသီးသီးသော အကိုင်းအခက် ဆိသမျှလို့ဟို သာယွေ့ သီးစေခြင်းငှာ သုတ်သင်ဆှင်းလင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","နင်လို့ဟ ငါဟောပြောသော စကားအားဖြင့် နင်လို့ဟ ဆှင်းလင်းလျက် ဆိခဲ့ကြပင်းပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ငါနှိုက် တလုံးတဝတည်း တည်နေကြလော့၊ ငါဟလည်း နင်လို့နဲ့ တလုံးတဝတည်း တည်နေမယ်။ စပျစ်ခက်ဟ အပင်နှိုက် မတည်လျှင်၊ ကိုယ်အလိုအလျောက် အသီးမသီးနိန်သလို နင်လို့ဟ ငါနှိုက် မတည်ရင် အသီးမသီးနိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ငါဟ စပျစ်နွယ်ပင် ဖြစ်အယ်၊ နင်လို့ဟ အကိုင်းအခက်များ ဖြစ်ကြအယ်။ စသူမဆို ငါနှိုက် တည်နေယွေ့ ငါဟလည်း သူနှိုက် တည်နေရင် နင်လို့ဟ ရမ်းဆာ့သော အသီးဟို သီးလိမ့်မယ်၊ ငါနဲ့ကွာရင် နင်လို့ဟ ပစာအရာဟိုမှ မလုပ်နိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ငါနှိုက် မတည်သောသူဟ ခြောက်သွေ့သွားလဲ့ အကိုင်းအခက်လို အပြင်သို့ လောခြင်းဟို ခံရပင်း၊ လူလို့ဟ အဲအကိုင်းအခက်များဟို စုသိမ်းလျက် မီးထဲဟို လောလိုက်ကြသဖြင့် လောင်ကျွမ်းသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","နင်လို့ဟ ငါနှိုက် တည်ယွေ့ ငါ့စကားဟ နင်လို့နှိုက် တည်ရင်၊ နင်လို့ လိုချင်သမျှဟို တောင်းကြလော့၊ နင်လို့ လိုချင်သောအရာလို့အတွက် တောင်းယွေ့ နင်လို့ဟ အဲအရာလို့ဟို ရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","နင်လို့ဟ ရမ်းဆာ့သော အသီးသီးခြင်းအားဖြင့် ငါ့ခမည်းတော်ရဲ့ ဘုန်းဟို ထင်ဆှားစေကြအယ်၊ အဲတိုင်းတိုင်းဖြင့် နင်လို့ဟ ငါရဲ့ တဘဲ့များ ဖြစ်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ခမည်းတော်ဟ ငါ့ဟို ချစ်သလို ငါဟ နင်လို့ဟို ချစ်အယ်၊ ငါရဲ့ ချစ်ခြင်းမေတ္တာနှိုက် တည်နေကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ငါဟ ခမည်းတော်ရဲ့ ပညတ်လို့ဟို စောင့်ထိန်းယွေ့ ခမည်းတော်ရဲ့ မေတ္တာနှိုက် တည်နေသလိုမျိုး၊ နင်လို့ဟ ငါ့ပညတ်လို့ဟို စောင့်ထိန်းရင် ငါ့မေတ္တာနှိုက် တည်နေကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“နင်လို့နှိုက် ငါရဲ့ ဝမ်းမြောက်ခြင်း တည်နေယွေ့ နင်လို့ ဝမ်းမြောက်ခြင်းဟ ပြေ့ဝစုံလင်စေမဲ့အကျောန်း ဟေအရာများဟို နင်လို့အား ငါပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ငါ့ပညတ်ဟ အဲလိုဖြစ်အယ်၊ ငါဟ နင်လို့ဟို ချစ်လဲ့တိုင်းတိုင်း၊ နင်လို့ဟ အချင်းချင်း ချစ်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","မိမိရဲ့ မိတ်ဆွေအတွက် အသက်ဟို စွန့်သော မေတ္တာထက် ကြီးမြတ်သောမေတ္တာဟ စသူ့မှာမှ မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","နင်လို့အား ငါ့ပညတ်လဲ့အရာလို့ဟို နင်လို့ ကျင့်သုံးရင် နင်လို့ဟ ငါရဲ့ မိတ်ဆွေများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","အခုမှစယွေ့ နင်လို့အား အစေခံ ဟူယွေ့ ငါခေါ်တော့မှာမဟုတ်၊ ပစာကို့ အစေခံဟ သခင်ပြုသောအမှုဟို မသိဝူး။ ခမည်းတော်ဆေမှ ငါကြားသမျှသောအရာလို့ဟို နင်လို့အား ငါပြောပင်းဖြစ်သောကျောန့် နင်လို့ဟို မိတ်ဆွေဟူယွေ့ ငါ ခေါ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","နင်လို့ဟ ငါ့ဟို ရွေးကောက်ကြတာ မဟုတ်၊ ငါဟ နင်လို့ဟို ရွေးကောက်သဖြင့် နင်လို့ဟ သွားယွေ့ တည်ကြည်သောအသီးဟို သီးနိန်မယ်အကျောန်းနဲ့ ငါ့နာမဟို အမှီပြုယွေ့ ခမည်းတော်မှာ တောင်းသမျှလို့ဟို ရမယ်အကျောန်း နင်လို့ဟို ငါ ခန့်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","နင်လို့ဟ အချင်းချင်း ချစ်ကြလော့ဟူသော ဟေပညတ်လို့ဟို နင်လို့အား ငါပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“လောကသားလို့ဟ နင်လို့ဟို မုန်းရင်၊ နင်လို့ဟို မမုန်းခင် ငါ့ဟို မုန်းကြတာဟို သိမှတ်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","နင်လို့ဟ လောကနဲ့ သက်ဆိုင်သောသူများဖြစ်ရင် လောကသားလို့ဟ မိမိလို့နဲ့ဆိုင်သော နင်လို့ဟို ချစ်ကြလိမ့်မယ်။ အဲလိုလဲ ငါဟ နင်လို့ဟို ဟေလောကထဲဟ ရွေးကောက်တာဖြစ်ယွေ့ နင်လို့ဟ ဟေလောကနဲ့ မသက်ဆိုင်ဝူး၊ အဲအကျောန်းကျောန့် လောကသားလို့ဟ နင်လို့ဟို မုန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘အစေခံဟ သခင်ထက် ကြီးမြတ်တာ မဟုတ်’ ဟု နင်လို့အား ငါပြောခဲ့တာဟို သတိရကြလော့။ သူလို့ဟ ငါ့ဟို ညှဉ်းဆဲရင် နင်လို့ဟိုလည်း ညှဉ်းဆဲကြလိမ့်မယ်၊ ငါ့စကားဟို နားထောင်ရင် နင်လို့ရဲ့ စကားဟိုလည်း နားထောင်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","အဲလိုလဲ သူလို့ဟ ငါ့ဟို စေလွှတ်သောသူဟို မသိကြသဖြင့် ငါရဲ့နာမကျောန့် နင်လို့အား အဲအမှုဆိသမျှလို့ဟို ပြုကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ငါဟ လာယွေ့ အေးသူလို့အား မဟောပြောရင် သူလို့နှိုက် အပစ်မဆိ၊ အဲလိုလဲ အခုမှာ မိမိလို့အပစ်အတွက် ဆင်ခြေပေးလို့ မရနိန်ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ငါ့ဟို မုန်းသောသူဟ ခမည်းတော်ဟိုလည်း မုန်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ငါဟ အခြားစသူမျှ မပြုဖူးသောအမှုဟို သူလို့ဆေ့မှာ မပြုခဲ့ရင် သူလို့နှိုက် အပစ်မဆိ၊ အခုမှာ သူလို့ဟ အေးအမှုများဟို မျော်ရကြပင်း ငါနဲ့ ငါ့ခမည်းတော်ဟို မုန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ဟေသို့ မုန်းကြရခြင်းမှာ သူလို့ရဲ့ ပညတ်ကျမ်းနှိုက် ‘သူလို့ဟ ငါ့ဟို အကျောန်းမဲ့ မုန်းကြအယ်’ ဟု ရေးသားဖော်ပြထားလဲ့အတိုင်း ပြေ့စုံရန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ခမည်းတော်ဆေမှ နင်လို့ဆေဟို ငါစေလွှတ်မဲ့ ကူညီမစသောသူတည်းဟူသော ခမည်းတော်ဆေမှ လာလဲ့ သမ္မာတရားရဲ့ ဝိညာဉ်တော်ဟ ရောက်လာသောအခါ ငါရဲ့အကျောန်းဟို သက်သေခံလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","နင်လို့ဟလည်း အစဦးဟပင် ငါနဲ့အတူဆိနေသောကျောန့် ငါ့အကျောန်းဟို သက်သေခံရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“နင်လို့ရဲ့ ယုံကြည်ခြင်း မပျက်ပြားစေရန် ဟေအရာများဟို ငါ ပြောထားခဲ့ပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","နင်လို့ဟ တရားဇရပ်များမှ မောင်းထုတ်ခံရလိမ့်မယ်၊ ဟေလောက်မက နင်လို့ဟို သတ်သောသူတိုင်းဟ မိမိလို့ဟ ဘုရားဝတ်ဟို ပြုနေတာဟု ထင်မှတ်သောအချိန်ကာလ ရောက်လာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","သူလို့ဟ ခမည်းတော် အဲဟာမဟုတ်ရင် ငါ့ဟို မသိကြသောကျောန့် ဟေသို့ နင်လို့အား ပြုကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","သူလို့ရဲ့အချိန်ရောက်သောအခါ ငါဟ ဟေသို့ပြောပီးတာဟို နင်လို့ သတိရစေရန် ဟေအကျောန်းအရာများဟို ငါ ပြောထားအယ်။ “ငါဟ နင်လို့နဲ့အတူ ငါဆိသောကျောန့် ဟေအကျောန်းအရာများဟို အစဦးနှိုက် နင်လို့အား မပြောခဲ့ဝူး။ ");
INSERT INTO dnv_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","အဲလိုလဲ ငါ့ဟို စေလွှတ်သောသူဆေဟို အခု ငါ သွားရမယ်၊ နင်လို့ထဲဟ စသူမှ နင် ဖယ်နားသွားမို့လို့ ငါ့ဟို မမေးကြဝူး။ ");
INSERT INTO dnv_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ဟေအကျောန်းအရာဟို ငါပြောသောကျောန့် နင်လို့ နေလုံးသားဟ ဝမ်းနည်းခြင်းနဲ့ ပြေ့လျက် ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","အဲလိုလဲ နင်လို့အား ငါ အမန်ဆိုအယ်၊ ငါသွားရင် နင်လို့အတွက် ပိုကောင်းအယ်၊ ပစာကို့ ငါမသွားရင် မစသောသူဟ ကြွလာမှာ မဟုတ်။ အဲလိုလဲ ငါသွားရင် အေးသူဟို နင်လို့ဆေဟို ငါ စေလွှတ်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","အဲသူကြွလာသောအခါ လောကသားလို့အား အပစ်အကျောန်း၊ အမန်တရားအကျောန်းနဲ့ တရားစီရင်ခြင်းအကျောန်းဟို ဖော်ပြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","အေးသူလို့ဟ ငါ့ဟို မယုံကြည်ကြသောကျောန့် အပစ်အကျောန်းဟို ဖော်ပြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ငါဟ ခမည်းတော်ဆေဟို သွားမယ် ဖြစ်ယွေ့ နင်လို့ဟ ငါ့ဟို တွေ့မျော်ရတော့မှာ မဟုတ်သောကျောန့် သူလို့ရဲ့ မားယွင်းနေသောအရာဟို အမန်တရားအားဖြင့် ဖော်ပြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ဟေလောကဟို အစိုးရသောသူဟ တရားစီရင်ခြင်းဟို ခံရပီဖြစ်သောကျောန့် တရားစီရင်အကျောန်းဟို ဖော်ပြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“နင်လို့အား ငါပြောစရာ စကားအများဆိသော်လည်း၊ နင်လို့ဟ အခု မခံနိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","အဲလိုလဲ သမ္မာတရားရဲ့ ဝိညာဉ်တော် ရောက်လာသောအခါ သမ္မာတရား အလုံးစုံထဲဟို နင်လို့ဟို ရိုးသွားလိမ့်မယ်။ အဲဝိညာဉ်တော်ဟ ကိုယ်အလိုအလျောက် ဟောပြောတာ မဟုတ်၊ မိမိကြားသိရလဲ့အရာလို့ဟို နင်လို့အား ပြောလိမ့်မယ်၊ နောက်ဖြစ်လာမဲ့အရာလို့ဟိုလည်း နင်လို့အား ဖော်ပြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","အဲသူဟ ငါ့ဆေမှ ရဆိသောစကားဟို နင်လို့အား ပြောကြားမယ် ဖြစ်သောကျောန့် ငါရဲ့ဘုန်းဟို ထင်ဆှားစေလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ခမည်းတော်နဲ့ စပ်ဆိုင်သောအရာလို့ဟ ငါနဲ့ စပ်ဆိုင်သောအရာ ဖြစ်အယ်၊ အဲကျောန်းကျောန့် ဝိညာဉ်တော်ဟ ငါ့ဆေမှ ရသောအရာလို့ဟို ယူယွေ့ နင်လို့အား ပြောကြားမယ်ဟု ငါဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“အချိန်ကတစ်ကြာရင် နင်လို့ဟ ငါ့ဟို မမျော်ရကြတော့မှာ မဟုတ်၊ အဲပင်းရင် ခဏကြာပင်းမှ ငါ့ဟို မျော်ပြန်ကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ကိုယ်တော်ရဲ့ တဘဲ့တော်အချို့လို့ဟလည်း “အချိန်ကတစ်ကြာရင် နင်လို့ဟ ငါ့ဟို မျော်ရကြတော့မှာ မဟုတ်၊ အဲပင်းရင် အချိန်ကတစ်ကြာပင်းမှ ငါ့ဟို မျော်ကြလိမ့်မယ်ဟူယွေ့ လည်းကောင်း ‘ငါဟ ခမည်းတော်ဆေဟို သွားမယ်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","သူလို့ဟ ‘အချိန်ကတစ်ကြာရင်’ ဟူယွေ့ ဆိုသော စကားမှာ ပစာလိုတုန်း၊ ကိုယ်တော်မိန့်သောအရာဟို ငါလို့ နားမလည်ကြ” ဟု ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ယေရှုဟ မိမိအား အဲသူလို့ဆှောက်ထား မေးမြန်းလိုကျောန်း သိသဖြင့် “အချိန်ကတစ်ကြာရင် နင်လို့ဟ ငါ့ဟို မျော်ရကြမှာ မဟုတ်၊ အဲပင်းရင် အချိန်ကတစ်ကြာပင်းမှ ငါ့ဟို မျော်ရကြလိမ့်မယ်” ဟု ငါ ပြောသောစကားများနဲ့ ပတ်သက်ယွေ့ အချင်းချင်း မေးမြန်း ပြောဆိုကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","နင်လို့အား ငါ အမန်ဆိုအယ်၊ နင်လို့ဟ ငိုကလျက် မြည်တမ်းကြလိမ့်မယ်၊ လောကသားလို့ဟ ဝမ်းမြောက်ကြလိမ့်မယ်၊ အဲလိုလဲ နင်လို့ဟ ဝမ်းနည်းခြင်းဆိသော်လည်း နင်လို့ရဲ့ဝမ်းနည်းခြင်းဟ ဝမ်းမြောက်ခြင်းအဖြစ်ဟို ပြောင်းလဲသွားလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","မိန်းမဟ သားဖွားသောအခါ မွေးဖွားချိန်ရောက်သောကျောန့် ဒုက္ခဝေဒနာဟို ခံစားရအယ်၊ အဲလိုလဲ လပဲ့မွေးဖွားပင်းသောအခါ ဟေလောကတွင် လူတယောက်ဟို မွေးဖွားလဲ့အတွက် ဝမ်းမြောက်ခြင်းဆိသဖြင့် ခံစားရသော ဒုက္ခဝေဒနာဟို သတိမရတော့ပေ။ ");
INSERT INTO dnv_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","အေးတိုင်းတိုင်း နင်လို့ဟ အခု ဝမ်းနည်းခြင်း ဆိကြသော်လည်း ငါဟ နင်လို့နဲ့ တဖန် ပြန်တွေ့မယ် ဖြစ်သောကျောန့် နင်လို့ရဲ့ စိတ်နေလုံး ဝမ်းမြောက်ခြင်းဖြင့် ပြေ့စုံကြလိမ့်မယ်၊ အေးဝမ်းမြောက်ခြင်းဟို စသူမျှ နင်လို့ဆေမှ မနုတ်ယူနိန်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“အဲနေ့နှိုက် နင်လို့ဟ ငါ့အား ပစာအရာဟိုမျှ တောင်းဆှောက်ကြလိမ့်မယ် မဟုတ်။ နင်လို့အား ငါ အမန် ဆိုအယ်၊ နင်လို့ဟ ငါရဲ့ နာမဟို အမှီပြုယွေ့ တောင်းဆှောက်သမျှသော အရာလို့ဟို ခမည်းတော်ဟ နင်လို့အား ပေးလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","အခုတိုင်အောန် ငါရဲ့ နာမဟို အမှီပြုယွေ့ နင်လို့ဟ ပစာဆုဟိုမျှ မတောင်းကြသေး၊ နင်လို့ဟ ဝမ်းမြောက်စရာအကျောန်း စုံလင်စေခြင်းငှာ တောင်းကြလော့၊ အဲလိုတောင်းရင် ရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ဟေအရာလို့ဟို ပုံဥပမာအားဖြင့် ငါပြောအယ်။ ပုံဥပမာအားဖြင့် မဟောပြောဘဲ ခမည်းတော်နဲ့ စပ်ဆိုင်သောအရာလို့ဟို နင်လို့အား ပွင့်လင်းစွာ ဖော်ပြသော အချိန်ကာလ ရောက်ဆိလာလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","အဲကာလနှိုက် နင်လို့ဟ ငါရဲ့နာမဟို အမှီပြုယွေ့ ဆုတောင်းကြလိမ့်မယ်၊ နင်လို့အဖို့အလိုငှာ ငါဟ ခမည်းတော်ဟို တောင်းမယ်ဟု မဆို။ ");
INSERT INTO dnv_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","အကျောန်းမှာ နင်လို့ဟ ငါ့ဟို ချစ်ယွေ့ ငါဟ ဘုရားသခင်ဆေမှ လာကျောန်းဟို ယုံကြည်သောကျောန့် ခမည်းတော်တတ်တိုင်း နင်လို့ဟို ချစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ငါဟ ခမည်းတော်ဆေမှ ကြွလာယွေ့ ဟေလောကသို့ ကြွလာခဲ့အယ်။ အခု ဟေလောကမှ ထွက်ခွာယွေ့ ခမည်းတော်ဆေဟို ငါသွားတော့မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","အဲပင်းရင် သူ့ရဲ့ တဘဲ့တော်လို့ဟလည်း “အခု ကိုယ်တော်ဟ ပုံဥပမာမဆောင်ဘဲ ပွင့်လင်းစွာ ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ကိုယ်တော်ဟ အလုံးစုံလို့ဟို သိကျောန်း အခု ငါလို့ သိကြပီ၊ ကိုယ်တော်အား စသူမျှ မေးဆှောက်ရန် မလိုတော့ပါ။ အဲကျောန်းကျောန့် ကိုယ်တော်ဟ ဘုရားသခင်ဆေမှ ကြွလာတာဟို ငါလို့ ယုံကြည်အယ်” ဟု ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ယေရှုဟ “နင်လို့ အခု ယုံကြပီလော။ ");
INSERT INTO dnv_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","နင်လို့ဟ ကွဲပြားယွေ့ ငါ့ဟို တကိုယ်တည်း နေစေခြင်းငှာ စွန့်ပစ်လျက်၊ အသီးသီး မိမိလို့နေရာသို့ ပြေးသွားမဲ့အချိန်ကာလဟ လာယွေ့ အခုပင် ရောက်အယ်။ အဲလို့မို့ ငါဟ တကိုယ်တည်းနေတာ မဟုတ်၊ ခမည်းတော်ဟ ငါနဲ့အတူ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","နင်လို့ဟ ငါ့ဟို အမှီပြုယွေ့ ငြိမ်သက်ခြင်း ဆိစေကြရန် ဟေစကားဟို ငါပြောပီ။ နင်လို့ဟ လောကနှိုက် ဆင်းရဲဒုက္ခဟို ခံရကြလိမ့်မယ်။ အဲလိုလဲ မစိုးရိမ်ကြနဲ့၊ ငါဟ လောကဟို အောန်ပီ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ယေရှုဟ ဟေသို့မိန့်ပင်းမှ ခေါန်းခင်သို့ မျော်ကျေ့လျက် “အို အဖ၊ အချိန်ကျလေပီ။ သားတော်ဟ ကိုယ်တော်ရဲ့ ဘုန်းအသရေဟို ထွန်းတောက်စေနိန်ရန် သားရဲ့ ဘုန်းအသရေဟို ထွန်းတောက်စေမန့်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","အကျောန်းမှာ ကိုယ်တော်ဟ သားတော်အား လူအားလုံးဟို အုပ်စိုးရသောအခွင့်ဟို ပေးပီ၊ ဟေဟာဟ သားတော်သည် ကိုယ်တော်ပေးအပ်သမျှသောသူလို့အား ထာဝရအသက်ဟို ပေးနိန်ရန်အတွက် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ထာဝရအသက်ဟူသည် မန်သော ဘုရားသခင် တဆူတည်းဖြစ်သော ကိုယ်တော်နဲ့ စေလွှတ်သော ယေရှု ခရစ်တော်ဟို လည်းကောင်း သိကျွမ်းခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ငါဟ မြေကြီးပေါ်မှာ ကိုယ်တော်ဟို ဘုန်းထင်ဆှားစေပီ၊ ငါဆောင်ရွက်စရာဖို့ ငါနှိုက် ကိုယ်တော် အပ်ပေးသောအမှုဟို အပီးတိုင်အောန် ဆောင်ရွက်ပါပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","အို အဖ၊ ဟေကမ္ဘာ မတည်မဆိမီဟပင် ကိုယ်တော်နဲ့အတူ ငါလို့ ခံစားသော ဘုန်းအသရေအားဖြင့် အခုပင် ကိုယ်တော့်ဆေ့တော်နှိုက် ဘုန်းထင်ဆှားစေမန့်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ဟေလောကထဲမှ ယူယွေ့ ငါနှိုက် အပ်ပေးသောသူအား ငါဟ ကိုယ်တော်ရဲ့နာမဟို ပြမန့်ပီ။ အဲသူလို့ဟို ကိုယ်တော်ဟ ပိုင်သဖြင့် အကျွန်ုပ်အား ပေးလေအယ်၊ သူလို့ဟ ကိုယ်တော်ရဲ့ နှုတ်ကပတ်တရားဟို လိုက်နာကြပါပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ငါ့အား ပေးသမျှလို့ဟ ကိုယ်တော်ဆေမှ ဖြစ်ကျောန်းဟို သူလို့ဟ အခု သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","အကျောန်းမှာ ငါ့အား ကိုယ်တော်ပေးသော တရားစကားဟို ငါဟ သူလို့အား ပေးသောအခါ သူလို့ ခံယူကြအယ်၊ ကိုယ်တော်ဆေမှ ငါလာတာဟ အမန်ဖြစ်ကျောန်းဟို သူလို့ သိကြပင်း၊ ကိုယ်တော်ဟ ငါ့အား စေလွှတ်ကျောန်းဟိုလည်း သူလို့ ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ငါဟ သူလို့အတွက် ဆုတောင်းအယ်။ လောကသားလို့အတွက် ဆုတောင်းတာ မဟုတ်မန့်၊ ငါ့အား ကိုယ်တော်ပေးသော သူများဟ ကိုယ်တော် ပိုင်ဆိုင်သောသူများဖြစ်သဖြင့် အဲသူလို့အတွက် ဆုတောင်းပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ငါပိုင်သောအရာအားလုံးလို့ဟို ကိုယ်တော်ပိုင်ပင်း ကိုယ်တော်ပိုင်သောအရာလို့ဟိုလည်း ငါပိုင်တာဖြစ်ယွေ့ ငါဟ အဲအရာများအားဖြင့် ဘုန်းထင်ဆှားခြင်း ဆိပါပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ငါဟ ဟေလောကနှိုက် ဆိတော့မှာ ဟုတ်ဝူး၊ သူလို့ဟတော့ ဟေလောကနှိုက် ဆိကြမယ်၊ ငါဟ ကိုယ်တော့်ဆေဟို လာအယ်။ သန့်ဆှင်းသော အဖ၊ သူလို့ဟ ငါလို့တိုင်းတိုင်း တလုံးတဝတည်းဖြစ်ကြရန် ငါ့အား ပေးသော ဟေသူလို့ဟို ကိုယ်တော်ရဲ့ နာမတော်နှိုက် စောင့်ဆှောက်မန့်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ငါဟ ဟေလောကနှိုက် သူလို့နဲ့တကွ ဆိစဉ်ကာလ၊ သူလို့ဟို ကိုယ်တော်ရဲ့ နာမနှိုက် တည်စေပီ၊ ငါ့အား ပေးသောသူလို့ဟို ငါ စောင့်မပါပီ။ အဲသူလို့တွင် ပျက်စီးခြင်းရဲ့ သားတယောက်မှတပါး စသူမျှ ပျက်စီးခြင်းသို့ မရောက်မန့်၊ အဲသူဟ ပျက်စီးခြင်းသို့ အကျောန်းဟ ကျမ်းစာပြေ့စုံမဲ့အကျောန်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","အခုတွင် ငါဟ ကိုယ်တော်ဆေဟို သွားရမယ် ဖြစ်ယွေ့ ဟေသူလို့ဟ ငါ့ဟို အမှီပြုသဖြင့် ဝမ်းမြောက်ခြင်းနဲ့ ပြေ့စုံမဲ့အကျောန်း ဟေစကားဟို လောကနှိုက် ငါပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ကိုယ်တော်ရဲ့ နှုတ်ကပတ်တရားဟို ဟေသူလို့အား ငါ ပေးပါပီ၊ ငါဟ ဟေလောကနဲ့ မသက်ဆိုင်သလို ဟေသူလို့ဟလည်း မသက်ဆိုင်သောကျောန့် ဟေသူလို့ဟို မုန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","သူလို့အား ဟေလောကမှ နုတ်ယူရန် ငါ တောင်းဆှောက်တာ မဟုတ်မန့်၊ သူလို့ဟ မာရ်နတ်ရဲ့ ဘေးမှကင်းလွတ်မဲ့အကျောန်း စောင့်ထိန်းရန်ဟိုသာ တောင်းဆှောက်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ငါဟ ဟေလောကနဲ့ မသက်ဆိုင်သလို အဲသူလို့ဟလည်း မသက်ဆိုင်ကြပါ။ ");
INSERT INTO dnv_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","သမ္မာတရားအားဖြင့် သူလို့ဟို သန့်ဆှင်းစေမန့်၊ ကိုယ်တော်ရဲ့ နှုတ်ကပတ်တော်ဟ သမ္မာတရား ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ကိုယ်တော်ဟ ငါ့ဟို ဟေလောကသို့ စေလွှတ်လဲ့အတိုင်း၊ ငါဟလည်း ဟေသူလို့ဟို ဟေလောကထဲသို့ စေလွှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","သမ္မာတရားအားဖြင့် သူလို့ဟို သန့်ဆှင်းစေမဲ့အကျောန်း ငါဟ သူလို့အတွက် ကိုယ်ဟို သန့်ဆှင်းစေပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ငါဟ အဲသူလို့အတွက်သာလျှင် ဆုတောင်းတာ မဟုတ်မန့်၊ သူလို့ ဟောပြောခြင်းအားဖြင့် ငါ့ဟို ယုံကြည်သော သူလို့အတွက်လည်း ဆုတောင်းပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","အဲသူအပေါင်းလို့ဟ တလုံးတဝတည်း ဖြစ်ကြစေရန် ဆုတောင်းပါအယ်။ အိုအဖ၊ ကိုယ်တော်ဟ ငါနှိုက် တည်ဆိယွေ့ ငါဟလည်း ကိုယ်တော်နှိုက် တည်ဆိသလို အဲသူလို့ဟ ငါလို့နှိုက် တည်ဆိစေမန့်။ ငါ့ဟို ကိုယ်တော်စေလွှတ်ကျောန်းဟို လောကသားလို့ ယုံကြည်ကြစေရန် အဲသူလို့ဟို တလုံးတဝတည်း ဖြစ်စေပါ။ ");
INSERT INTO dnv_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ကိုယ်တော်နဲ့ ငါဟ တလုံးတဝတည်းဖြစ်သလို အဲသူလို့ဟလည်း ဖြစ်ကြစေရန် ငါဟ ကိုယ်တော်ပေးသော ဘုန်းအသရေဟို သူလို့အား ပေးပါပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ငါဟ သူလို့နှိုက်လည်းကောင်း၊ ကိုယ်တော်ဟ ငါနှိုက်လည်းကောင်း တည်ဆိသဖြင့် သူလို့ဟ တလုံးတဝတည်းဖြစ်သောအားဖြင့် ကိုယ်တော်ဟ ငါ့အား စေလွှတ်ကျောန်းနဲ့ ငါ့ဟို ချစ်သလို သူလို့ဟိုလည်း ချစ်ကျောန်းဟို လောကသားလို့ဟ သိစေခြင်းငှာလည်းကောင်း ကိုယ်တော်ဟ ငါ့အားပေးသော ဘုန်းအသရေဟို ငါဟ သူလို့အား ပေးပါပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“အို အဖ၊ ကိုယ်တော်ဟ ကမ္ဘာမတည်မဆိမီ ငါ့ဟို ချစ်ယွေ့ ပေးသော ဘုန်းအသရေဟို ငါ့အား ကိုယ်တော်ပေးသော သူလို့ဟ မျော်ကြစေရန် ငါဆိရာအရပ်တွင် သူလို့အား ဆိစေလိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ဖြောင့်မတ်သော အဖ၊ လောကသားလို့ဟ ကိုယ်တော်ဟို မသိကြသော်လည်း ငါသိအယ်၊ ကိုယ်တော်ဟ ငါ့အား စေလွှတ်ကျောန်းဟို အဲလူလို့ဟ သိကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ကိုယ်တော်ဟ ငါ့ဟို ချစ်သော မေတ္တာဟ သူလို့နှိုက် တည်ဆိစေယွေ့ ငါလို့ဟလည်း သူလို့နှိုက် တည်ဆိစေရန် ကိုယ်တော်ရဲ့ နာမဟို သူလို့အား ငါသိစေပင်း ဆက်ပင်းလည်း သိစေအုန်းမယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ယေရှုဟ ဟေသို့ ဆုတောင်းပင်းနောက် တဘဲ့တော်လို့နဲ့အတူ သွားယွေ့ ကေဒြုန်ချောင်းဟို ကူးလေအယ်။ အေးအရပ်တွင် ဥယျာဉ်တခု ဆိအယ်၊ ယေရှုနဲ့ တဘဲ့တော်လို့ဟ အဲဥယျာဉ်ထဲသို့ ဝင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","အဲအရပ်သို့ ယေရှုနဲ့ သူ့ရဲ့ တဘဲ့တော်လို့ဟ အကြိမ်များစွာ သွားလေ့ဆိသဖြင့် သစ္စာဖောက် ယုဒဟ အေးဥယျာဉ်ဟို သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","အဲလိုမို့ သူဟ ရောမစစ်သားတတပ်၊ ယဇ်ပုရောဟိတ်ကြီးလို့နဲ့ ဖာရိရှဲလို့ရဲ့ စေလွှတ်လိုက်သော အစောင့်တပ်သားများဟိုလည်းကောင်း ခေါ်ခဲ့အယ်။ သူလို့ဟ မီးဖူးများ၊ မီးတုတ်များနဲ့ လက်နက်များဟို ကိုင်ဆောင်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ယေရှုဟ မိမိကြုံတွေ့ရမဲ့ အမှုအလုံးစုံဟို သိပင်းဖြစ်သဖြင့် အဲသူလို့ရဲ့ဆေဟို သွားလျက် “နင်လို့ စသူ့ဟို ဆှာကြတုန်း” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","အဲသူလို့ဟ “နာဇရက်မြို့သား ယေရှုဟို ဆာအယ်” ဟု ပြန်ပြောအယ်။ ကိုယ်တော်ဟ “ငါဟ အေးသူပင် ဖြစ်အယ်” ဟု မိန့်အယ်။ ကိုယ်တော်အား သစ္စာဖောက်သူ ယုဒဟလည်း အဲသူလို့နဲ့အတူ ရပ်လျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“ငါဟ အေးသူပင် ဖြစ်အယ်” ဟု ယေရှု မိန့်သောအခါ သူလို့ဟ နောက်သို့ဆုတ်ကာ မြေပေါ်တွင် လဲကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","အဲလိုမို့ ယေရှုဟ “နင်လို့ စသူ့ဟို ဆှာတုန်း” ဟု တဖန် မေးပြန်အယ်။ သူလို့ဟလည်း “နာဇရက်မြို့သား ယေရှုဟို ဆှာကြအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ယေရှုဟ “အဲသူဟ ငါပင် ဖြစ်အယ်ဟု နင်လို့အား ငါပြောခဲ့ပီ။ အဲလိုမို့ ငါဟ နင်လို့ ဆှာသောသူဖြစ်ရင် ဟေသူလို့ဟို သွားပါလေစေ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ဟေသို့ပြောရခြင်းမှာ “ကိုယ်တော်ပေးအပ်သော သူတစုံတယောက်မျှ ပျက်စီးခြင်းသို့ မရောက်မန့်” ဟု မခင်ဟ ကိုယ်တော် မိန့်ခဲ့လဲ့အတိုင်း ပြေ့စုံစေရန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","အဲအခါ ရှိမုန် ပေတရုဟ မိမိနှိုက်ပါသော ထားဟို ဆွဲထုတ်ပင်း ယဇ်ပုရောဟိတ်မင်းရဲ့ ကျွန်တယောက်ဟို ခုတ်သဖြင့် ညာဖက်နားရွက် ပြုတ်ထွက်အယ်။ အဲကျွန် နာမယ်မှာ မာလခု ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ယေရှုဟ “နင့်ရဲ့ ထားဟို ထားအိုင်နှိုက် ပြန်သွင်းလော့။ ခမည်းတော် ငါ့အား ခံစေလဲ့ ဒုက္ခဝေဒနာဟို ငါ မခံသင့်သလော” ဟု ပေတရုအား မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","အဲပင်းရင် ရောမစစ်သားများနဲ့ ယုဒအမျိုးသား အစောင့်တပ်သားများဟ ယေရှုဟို ဖမ်းဆီးတုတ်ချေပင်း အန္နတ်မင်းဆေဟို ဆေ့ဦးစွာ ခေါ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","အန္နတ်မင်းဟ အဲနှစ်တွင် ယဇ်ပုရောဟိတ်မင်းဖြစ်သော ကယာဖရဲ့ ယောက္ခမ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ကယာဖဟ “လူအပေါင်းလို့အတွက် လူတဦးတယောက် သေရတာဟ ပိုယွေ့ ကောင်းအယ်” ဟု ယုဒအာဏာပိုင်လို့အား အကြံပေးခဲ့သူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ရှိမုန် ပေတရုနဲ့ အခြား တဘဲ့တော်တယောက်ဟ ယေရှု နောက်ဟို လိုက်ကြအယ်။ အဲတဘဲ့တော်ဟ ယဇ်ပုရောဟိတ်မင်းရဲ့ အသိဖြစ်ယွေ့၊ ယေရှုနဲ့တကွ ယဇ်ပုရောဟိတ်မင်းရဲ့ အိုင်တော်ဝင်းသို့ လိုက်သွားခွင့်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ပေတရုဟ ထင်ခါးအပြင်မှာ ရပ်နေအယ်။ အဲကျောန့် ယဇ်ပုရောဟိတ်မင်းသိသော အခြားတဘဲ့တော်ဟ ထွက်လာယွေ့ ထင်ခါးစောင့်မိန်းမအား ပြောပင်းမှ ပေတရုဟို အထဲဟို ခေါ်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ထင်ခါးစောင့်မိန်းမဟ ပေတရုအား “နင်ဟ အဲသူရဲ့ တဘဲ့တဦး မဟုတ်လော” ဟု ဆိုရင်၊ “ငါ မဟုတ်” ဟု ပေတရု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","အေးကာလနှိုက် ချမ်းသောကျောန့် အစေခံနဲ့ အစောင့်တပ်သားလို့ဟ မီးခဲပုံထည့်ယွေ့ မီးလှုံလျက် နေကြအယ်။ ပေတရုတတ်တိုင်းဟလည်း သူလို့နဲ့အတူ ရပ်ပင်း မီးလှုံလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ယဇ်ပုရောဟိတ်မင်းဟ ယေရှုအား တဘဲ့တော်လို့ရဲ့ အကျောန်းနဲ့ ယေရှုရဲ့ သွန်သင်ချက်အကျောန်းလို့ဟို မေးမြန်းစစ်ဆေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ယေရှုဟ “ငါသည် လူအပေါင်းလို့ ဆေ့တွင် အစဉ်ပွင့်လင်းစွာ ဟောပြောခဲ့အယ်၊ ယုဒအမျိုးသားအပေါင်းလို့ စုဝေးရာဖြစ်သော တရားဇရပ်များနဲ့ ဗိမာန်တော်တွင် ငါ သွန်သင်ခဲ့အယ်၊ ပစာခါမျှ လျှို့ဝှက်စွာ မပြောပီ။ ");
INSERT INTO dnv_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","အဲလိုမို့ ပစာကျောန့် ငါ့ဟို စစ်ဆေးမေးမြန်းတုန်း၊ ငါ ဟောပြောတာဟို ကြားနာသောသူလို့ဟို မေးလော့။ ငါပြောသောစကားဟို အဲသူလို့ဟ သိကြအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","အဲသို့ ယေရှု မိန့်သောအခါ အစောင့်တပ်သားတဦးဟ “ယဇ်ပုရောဟိတ်မင်းအား နင်ဟ ဟေသို့ ပြန်ပြောရသလော” ဟု ဆိုလျက် ယေရှုဟို ဖိုင်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ယေရှုဟလည်း သူ့ဟို “ငါရဲ့ စကားမမန်ရင် မမန်ကျောန်းဟို သက်သေပြမန့်။ မန်ရင် ငါ့ဟို ပစာကျောန့် ရိုက်တုန်း” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","အဲပင်းရင် အန္နတ်မင်းဟ ကိုယ်တော်ဟို ချည်နှောင်လျက်ဆိလဲ့အတိုင်း ယဇ်ပုရောဟိတ်မင်း ကယာဖဆေဟို ပို့စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ပေတရုဟ ရပ်လျက် မီးလှုံနေအယ်။ အဲလိုမို့ အခြားသောလူလို့ဟ “နင်ဟ အေးသူရဲ့ တဘဲ့ မဟုတ်လော” ဟု မေးကြအယ်။ အဲလိုလဲ ပေတရုဟ “ငါ မဟုတ်” ဟု ငြင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ပေတရု ခုတ်ယွေ့ နားရွက်ပြတ်သောသူနဲ့ ဆွေမျိုးတော်စပ်သော ယဇ်ပုရောဟိတ်မင်းရဲ့ ကျွန်တယောက်ဟ၊ “နင့်အား အေးသူနဲ့အတူ ဥယျာဉ်ထဲတွင် ငါမျော်ခဲ့တာ မဟုတ်လော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ပေတရုဟ “ငါ မဟုတ်” ဟု တဖန် ငြင်းပြန်အယ်၊ ခုတုံးပင် ကြက်တွန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","မနက်အချိန်ရောက်ရင် ယေရှုဟို ကယာဖရဲ့ အိုင်တော်မှ ဘုရင်ခံရဲ့ နန်းတော်ဆေဟို ခေါ်ဆောင်သွားကြအယ်။ ယုဒအာဏာပိုင်လို့ဟ ပသခါပွဲဟို စားနိန်ရန် မိမိလို့ ကိုယ်ကိုဘာသာရေးထုံးစံအရ သန့်စင်စေလိုသဖြင့် အိုင်တော်သို့ မဝင်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","အဲလိုမို့ ပိလတ်မင်းဟ အေးသူလို့ဆိရာ အပြင်ဟို ထွက်လာပင်း “ဟေသူအား ပစာပစ်မှုနဲ့ စွပ်စွဲကြတုန်း” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","အဲသူလို့ဟလည်း “ဟေသူဟ အပစ်ကျူးလွန်သူ မဟုတ်ရင် သူ့အား ကိုယ်တော်ဆေဟို ငါလို့ မအပ်မန့်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ပိလတ်မင်းဟလည်း “နင်လို့ တတ်တိုင်း သူ့အား ခေါ်သွားယွေ့ နင်လို့ရဲ့ကိုယ်ပိုင် ပညတ်တရားအတိုင်း စီရင်ကြလော” ဟု ဆိုအယ်။ ယုဒလူလို့ဟလည်း “ငါလို့နှိုက် စသူ့ဟိုမျှ သေဒဏ်ပေးပိုင်ခွင့် မဆိပါ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ဟေလို ဖြစ်ပျက်ရခြင်းမှာ မိမိ စလိုသေရမယ်ဟို ယေရှု မိန့်သောစကားဟ ပြေ့စုံမဲ့အကျောန်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ပိလတ်မင်းဟ အိုင်တော်ထဲသို့ ပြန်ဝင်ပင်း ယေရှုအား ခေါ်အယ်။ “နင်ဟ ယုဒဘုရင်လော” ဟု မေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ယေရှုဟ “ဟေမေးခွန်းဟို မင်းကြီးအလိုအလျောက် မေးသလော အဲဟာမဟုတ်ရင် အခြားသောသူလို့ဟ နင့်အား ငါရဲ့အကျောန်းဟို ပြောကြသလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ပိလတ်မင်းဟ “နင်ဟ ငါ့ဟို ယုဒလူဖြစ်တာဟု ထင်မှတ်သလော၊ နင့်ဟို ငါ့ဆေဟို ပို့လာသောသူများမှာ နင်ရဲ့ အမျိုးသားများနဲ့ ယဇ်ပုရောဟိတ်ကြီးလို့ပင် ဖြစ်အယ်။ နင်ဟ ပစာအမှုဟို ပြုမိတုန်း” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ယေရှုဟ “ငါ့ရဲ့ နိုင်ငံတော်သည် ဟေလောကနဲ့ မသက်ဆိုင်၊ ငါ့ရဲ့ နိုင်ငံဟ ဟေလောကနဲ့ မသက်ဆိုင်ရင် ငါဟ ယုဒအာဏာပိုင်လို့ လက်သို့မရောက်ရအောန် ငါ့ရဲ့ နောက်လိုက်လူလို့ဟ တိုက်ခိုက်ကြလိမ့်မယ်။ အဲလိုလဲ ငါရဲ့ နိုင်ငံဟ ဟေလောကနဲ့ မသက်ဆိုင်” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ပိလတ်မင်းဟ “အဲကျောန့် နင်ဟ ဆှင်ဘုရင်လော” ဟု မေးအယ်။ ယေရှုဟ “ငါဟ နင်ဆိုလဲ့အတိုင်း ဆှင်ဘုရင် ဖြစ်အယ်။ ငါဟ သမ္မာတရားဘက်နှိုက် သက်သေခံရန် မွေးဖွားခြင်းဟို ခံယွေ့ ဟေလောကသို့ ကြွလာပီ။ သမ္မာတရားနဲ့ စပ်ဆိုင်သောသူတိုင်း ငါ့အသံဟို နားထောင်ကြအယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ပိလတ်မင်းဟ “သမ္မာတရားဟ ပစာတုန်း” ဟု မေးအယ်။ အဲပင်းရင် ပိလတ်မင်းဟ လူလို့ဆေဟနေ အပြင်ဟိုထွက်လာပင်း “အေးသူအား အပစ်စီရင်ရန် တစုံတရာဟိုမျှ ငါမတွေ့။ ");
INSERT INTO dnv_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","နင်လို့ရဲ့ ထုံးစံအရ ပသခါပွဲအတွင်းနှိုက် အကျဉ်းသမားတဦးဟို ငါလွတ်ငြိမ်းချမ်းသာခွင့် ပေးမြဲဖြစ်အယ်။ နင်လို့အတွက် ယုဒဆှင်ဘုရင်ဟို လွတ်ငြိမ်းချမ်းသာခွင့် ပေးချင်သလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","အဲသူလို့ဟ “သူ့ဟို လွှတ်မပေးပါနဲ့၊ ဗာရဗ္ဗဟို ပေးမန့်” ဟု ပြန်ဟစ်အော်ကြအယ်။ ဗာရဗ္ဗဟ ထားပြဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","အဲပင်းရင် ပိလတ်မင်းဟ ယေရှုဟို ခေါ်သွားစေပင်း ကြိမ်ဒဏ်ခတ်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","စစ်သားများဟ ဆူးခက်ဖြင့် ရက်သောဦးရစ်ဟို သူ့ရဲ့ ဦးခေါင်းနှိုက် တင်ယွေ့ ခရမ်းရောင် ဝတ်လုံဟို ကိုယ်တော်အား ဝတ်ပေးပင်းရင် ");
INSERT INTO dnv_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ကိုယ်တော်ဆေဟို ချဉ်းယွေ့ “ယုဒဆှင်ဘုရင် သက်တော်ဆှည်မန့်စေ” ဟု ဆိုယွေ့ ပါးရိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ပိလတ်မင်းဟ အပြင်သို့ တဖန်ထွက်ပင်း လူအုပ်ကြီးအား “အေးသူဟို ပစာအပစ်ဟိုမျှ ငါမတွေ့ကျောန်းဟို နင်လို့သိစေရန် သူ့ဟို နင်လို့ဆိရာဟို ငါ ခေါ်ဆောင်လာမယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","အဲအခါ ယေရှုဟ ဆူးခက်ဦးရစ်နဲ့ ခရမ်းရောင် ဝတ်လုံဟို ဝတ်လျက် ပြင်သို့ ထွက်လာအယ်။ ပိလတ်မင်းဟ “ကျေ့လော့၊ ဟေသူပင် ဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ယဇ်ပုရောဟိတ်ကြီးနဲ့ အစောင့်တပ်သားများဟ ကိုယ်တော်ဟို မျော်သောအခါ “သူ့ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့ သတ်မန့်၊ သူ့ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့ သတ်မန့်” ဟု ဟစ်အော်ကြအယ်။ ပိလတ်မင်းဟလည်း “နင်လို့ဟ သူ့ဟို ယူယွေ့ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့ သတ်လော့။ သူ့ဟို သေဒဏ်ပေးရန်အကျောန်း တစုံတရာမျှ ငါမတွေ့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","လူအုပ်ကြီးဟ “အဲသူဟ မိမိကိုယ်ကို ဘုရားသခင်ရဲ့ သားဟုပြောသောကျောန့် ငါလို့ တရားဥပဒေအရ သေဒဏ်ခံထိုက်အယ်” ဟု ပြန်ပင်း ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ပိလတ်မင်းဟ အဲသူလို့ရဲ့စကားဟို ကြားသောအခါ ပိုပင်း ကြောက်လန့်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","အဲလိုမို့ သူဟ အိုင်တော်ထဲဟို ပြန်ဝင်ပင်းနောက် ယေရှုအား “နင်ဟ ဖယ်နားဟ လာတုန်း” ဟု မေးအယ်။ အဲလိုလဲ ယေရှုဟ ပစာမျှ ဖြေတော်မမူ။ ");
INSERT INTO dnv_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ပိလတ်မင်းဟ နင်ဟ ငါ့ဟို စကားမပြောဘဲ နေသလော၊ ငါဟ “နင့်ဟို လွှတ်ပေးနိန်သော အခွင့်အာဏာ ဆိယွေ့ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်နိန်သော အခွင့်အာဏာလည်း ဆိတာဟို နင် မသိသလော” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ယေရှုဟ “မင်းကြီးအား ဘုရားသခင် အခွင့်နဲ့သာ ဟေလို့သော အခွင့်အာဏာဟို ရဆိခြင်း ဖြစ်အယ်။ အဲကျောန့် ငါ့ဟို မင်းကြီးရဲ့ လက်သို့အပ်နှံသောသူဟ ပိုယွေ့ အပစ်ကြီးအယ်” ဟု ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ဟေသို့ ဖြေကြားခြင်းဟို ကြားသောအခါ ပိလတ်မင်းဟ ကိုယ်တော်ဟို လွတ်ငြိမ်းခွင့်ပေးရန် နည်းလမ်းဆှာကြံလေအယ်။ အဲလိုလဲ လူအုပ်ကြီးဟ “အဲသူအား လွတ်ငြိမ်းခွင့်ပေးသောသူဟ ကဲသာဘုရင်ရဲ့ မိတ်ဆွေ မဟုတ်ပီ၊ စသူမဆို မိမိကိုယ်ကို ဆှင်ဘုရင် ဟု ဆိုသူဟ ကဲသာဘုရင်ရဲ့ ရန်သူ ဖြစ်အယ်” ဟု ဟစ်အော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ပိလတ်မင်းဟ အဲစကားဟို ကြားသောအခါ ယေရှုဟို ပြင်သို့ထုတ်ပင်းမှ ကျောက်ပြား ဟု ခေါ်သောနေရာနှိုက် တရားပလ္လင်ပေါ်မှာ ထိန်လေအယ်။ အဲအရာဟို ဟေဗြဲ နာမယ်ဖြင့် ဂဗ္ဗသဟု ခေါ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","အဲအချိန်ဟ ပသခါပွဲမတိုင်ခင်နေ့ မွန်းတည့်ခါနီး ဖြစ်အယ်။ ပိလတ်မင်းဟ “နင်လို့ရဲ့ ဆှင်ဘုရင်ဟို ကျေ့ကြလော့” ဟု ယုဒအမျိုးသားလို့အား ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","အဲသူလို့ဟ “သူ့ဟို သတ်မန့်၊ သူ့ဟို သတ်မန့်၊ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်မန့်” ဟု ပြန်ပင်း အော်ကြအယ်။ ပိလတ်မင်းဟလည်း “နင်လို့ရဲ့ ဆှင်ဘုရင်ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်စေလိုသလော” ဟု မေးအယ်။ ယဇ်ပုရောဟိတ်ကြီးလို့ဟ “ငါလို့မှာ ကဲသာဘုရင်မှတပါး အခြား ဆှင်ဘုရင် မဆိမန့်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","အဲအခါ ပိလတ်မင်းဟ ယေရှုဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ရန် အေးသူလို့လက်သို့ အပ်လိုက်အယ်။ အဲလိုမို့ သူလို့ဟ ယေရှုဟို ခေါ်ဆောင်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ကိုယ်တော်ဟ “ဦးခေါင်းခွံအရပ်” ဟူယွေ့ နာမယ်တွင်သောအရပ်ဟို မိမိလက်ဝါးကပ်တိုင်ဟို ထမ်းလျက် ကြွအယ်။ အဲအရပ်ဟို ဟေဗြဲစကားဖြင့် “ဂေါလဂေါသ” ဟု နာမယ် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","သူလို့ဟ အဲအရပ်နှိုက် ကိုယ်တော်ဟို အခြားသူနေယောက်လို့နဲ့အတူ လက်ဝါးကပ်တိုင်အပေါ်နှိုက် တင်ကြပင်း ယေရှုဟို အလယ်နှိုက် ထားယွေ့ အဲသူနေဦးလို့ဟို ကိုယ်တော်ရဲ့ တဖက်တချက်စီ ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ပိလတ်မင်းဟ ကမ္ပည်းလိပ်စာဟို ရေးယွေ့ လက်ဝါးကပ်တိုင်မှာ ကပ်ထားလေအယ်။ အဲကမ္ပည်းလိပ်စာဟ “ယုဒဆှင်ဘုရင်၊ နာဇရက်မြို့သား ယေရှု” ဟု ရေးထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ယေရှုဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်လဲ့အရပ်မှာ မြို့နဲ့နီးသဖြင့် လူအများဟ အဲကမ္ပည်းလိပ်စာဟို ဖတ်ကျေ့ကြအယ်။ အဲလိပ်စာဟို ဟေဗြဲဘာသာ၊ ဟေလသဘာသာနဲ့ ရောမဘာသာအားဖြင့် ရေးသားထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ယဇ်ပုရောဟိတ်ကြီးလို့ဟ ပိလတ်မင်းအား “ယုဒဘုရင်ဟူယွေ့ မရေးပါနဲ့၊ ငါဟ ယုဒဆှင်ဘုရင် ဖြစ်အယ်ဟု သူဆိုကျောန်းဟို ရေးမန့်” ဟု ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ပိလတ်မင်းဟ “ငါရေးပီးလဲ့အတိုင်း အတည်ဖြစ်ရမယ်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","စစ်သားလို့ဟ ယေရှုဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ကြပင်းသောအခါ ကိုယ်တော်ရဲ့ အဝတ်တော်ဟို လေးပိုင်းပိုင်းယွေ့ တယောက်တပိုင်းစီ ယူကြအယ်။ သူလို့ဟ အထဲခံ အင်္ကျီဟိုလည်း ယူကြအယ်၊ အေးအင်္ကျီဟ ချုပ်ရိုးမဆိဘဲ အပေါ်မှ အောက်ခြေအထိ တထည်လုံးဟို တဆက်တည်း ရက်ထားလဲ့ အဝတ် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","သူလို့ဟ “အေးအင်္ကျီဟို မဆုတ်ကြနဲ့၊ မဲချယွေ့ ယူကြကုန်အံ့” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ဟေသို့ပြုမူကြခြင်းမှာ ကျမ်းစာတွင်၊ “ဟေသူလို့ဟ ငါရဲ့ အဝတ်အစားများဟို ခွဲဝေယူကြပင်း ငါရဲ့အင်္ကျီဟို မဲချယူကြအယ်” ဟု ပါဆိလဲ့အတိုင်း ပြေ့စုံလာစေရန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ယေရှုရဲ့ လက်ဝါးကပ်တိုင်နားမှာ သူ့အမေ့နဲ့ သူ့အမေ့ရဲ့ညီမ ဖြစ်သော ကယာဖရဲ့ ပေါင်အိုမဖြစ်သူ မာရိနဲ့ မာဂဒလရွာသူ မာရိလို့ဟ ရပ်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ယေရှုဟ သူ့အမေ့နဲ့ ကိုယ်တော် ချစ်သောတဘဲ့တော်လို့ ရပ်နေတာဟို မျော်လေအယ်၊ အဲလိုမို့ ကိုယ်တော်ဟ အမေ့၊ “ဟေမှာ နင်ရဲ့သား” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","အဲပင်းရင် တဘဲ့တော်အား ဟေမှာ နင်ရဲ့အမေ့ ဟု ဆိုလေအယ်။ အဲအချိန်မှစယွေ့ တဘဲ့တော်ဟ အမေ့အား မိမိလို့နေအိုင်နှိုက် ခေါ်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","အဲအချိန်နှိုက် အမှုဆိသမျှ ပီးစီးကျောန်းဟို ယေရှု သိသဖြင့် ကျမ်းစာပြေ့စုံစေရန် ကိုယ်တော်ဟ “ငါ ယေငတ်အယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","အဲအရပ်နှိုက် စပျစ်ယေချဉ်နဲ့ ပြေ့သော အိုးတလုံးဆိတာဖြစ်ယွေ့ အဲသူလို့ဟ ရေမြှုပ်တခုဟို စပျစ်ယေချဉ်တွင် နစ်စေပင်း ဟုဿုပ်ပင် အကိုင်းဖျားနှိုက် တပ်ယွေ့ ကိုယ်တော်ရဲ့ စလောင်နားဟို ကမ်းပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ယေရှုဟ စပျစ်ယေချဉ်ဟို သောက်ပင်းမှ “အမှုပီးပီ” ဟု မိန့်လျက် ဦးခေါင်းတော်ဟို ငိန်းလျက် အသက်ချုပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ယုဒအာဏာပိုင်လို့ဟ လက်ဝါးကပ်တိုင်တွင် တင်ထားသူများရဲ့ ခြေထောက်လို့ဟို ချိုးယွေ့ အလောင်းများဟို ကားတိုင်မှ ယူဆောင်သွားခွင့်ပြုရန် ပိလတ်မင်းအား တောင်းဆှောက်ကြအယ်။ သူလို့ ဟေသို့တောင်းဆှောက်ကြရခြင်းမှာ အဲနေ့ဟ သောကြာနေ့ဖြစ်ယွေ့ ဥပုသ်နေ့နှိုက် အလောင်းများဟို လက်ဝါးကပ်တိုင်တွင် မဆိစေလိုသောကျောန့် လည်းကောင်း၊ လာမဲ့ဥပုသ်နေ့ဟလည်း နေ့ထူးနေ့မြတ်ဖြစ်သောကျောန့် လည်းကောင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","အဲကျောန့် စစ်သားများဟ သွားယွေ့ ယေရှုနဲ့အတူ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်ခံရသူ ပထမလူရဲ့ခြေထောက်ဟို ချိုးပင်းရင် အခြားတယောက်ရဲ့ခြေထောက်ဟိုလည်း ချိုးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","အဲလိုလဲ ယေရှုဆေဟို သူလို့ရောက်သောအခါ သေနေပီဖြစ်ကျောန်းဟို မျော်ရင် ခြေထောက်ဟို မချိုးကြတော့ချေ။ ");
INSERT INTO dnv_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","အဲအစား စစ်သားတယောက်ဟ ယေရှုရဲ့ နံဘေးဟို လှံနဲ့ ထိုးလိုက်ရာ ခုတုံးပင် သွေးနဲ့ ယေ ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ဟေအရာဟို မျော်သောသူဟ သက်သေခံခဲ့ယွေ့ သူရဲ့ သက်သေခံချက်ဟလည်း မန်အယ်။ နင်လို့ဟလည်း ယုံကြည်ကြရန် သူဟ မန်ကန်စွာ ပြောဆိုနေကျောန်း သူသိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ဟေသို့ဖြစ်ပျက်ရခြင်းဟ “သူရဲ့ အရိုးတချောင်းမှ မကျိုးရ” ဟု ကျမ်းစာလာချက် ပြေ့စုံမဲ့အကျောန်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","တဖန် အခြားကျမ်းစာနှိုက် “သူလို့ဟ မိမိလို့ လှံနဲ့ ထိုးဖောက်သောသူဟို မျော်ရလိမ့်မယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","အဲသို့မိန့်ပင်းနောက် ယုဒအာဏာပိုင်လို့ဟို ကြောက်ရွံ့သဖြင့် မထင်မဆှား ယေရှုရဲ့ တဘဲ့ဖြစ်သော အရိမဿဲမြို့သား ယောသပ်ဟ ယေရှုရဲ့ အလောင်းတော်ဟို ယူခွင့်ပြုရန် ပိလတ်မင်းအား တောင်းဆှောက်အယ်။ ပိလတ်မင်းဟလည်း ခွင့်ပြုသဖြင့် ယောသပ်ဟ လာယွေ့ အလောင်းဟို ယူသွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","မခင်ဟ ယေရှုဆေဟို ညအခါနှိုက် လာတွေ့ဖူးသူ နိကောဒင်ဟလည်း မုရန်နဲ့ အကျော်ရောထားသော ဆီမွှေးနံ့သာပေါင်း ပိဿာနေဆယ်ကျော်ဟို ယူယွေ့ ယောသပ်နဲ့အတူ လိုက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","အဲသူလို့ဟ ယေရှုရဲ့ အလောင်းဟို ယူယွေ့ ယုဒအမျိုးသားလို့ရဲ့ သင်္ဂြိုဟ်ခြင်းနဲ့ဆိုင်သော ပြင်ဆင်ခြင်း စလေ့ဆိလဲ့အတိုင်း နံ့သာပေါင်းနဲ့တကွ ပိတ်စများဖြင့် ပတ်စဲကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ယေရှုဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့သတ်လဲ့ အရပ်နှိုက် ဥယျာဉ်တခု ဆိယွေ့၊ အဲဥယျာဉ်နှိုက် စသူဟိုမှ မသင်္ဂြိုဟ်ဖူးသေးလဲ့ လုတ်တိုင်းဂူသစ်တခု ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","အဲနေ့ဟ ယုဒအမျိုးသားလို့ရဲ့ အဖိတ်နေ့ဖြစ်သောကျောန့် အနီးတွင်ဆိသော အဲလုတ်တိုင်းတွင်းနှိုက် အလောင်းဟို သင်္ဂြိုဟ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","တနင်္ဂနွေနေ့ မိုးမလင်းခင် မိုက်နေသေးခါနှိုက် မာဂဒလမြို့သူ မာရိဟ လုတ်တိုင်းသို့ သွားယွေ့ တွင်းဝမှာပိတ်သော ကျောက်တုံးဟ ဖယ်လောထားတာဟို မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","အဲလို့မို့ သူမဟ ရှိမုန်ပေတရုနဲ့ ယေရှုချစ်သော အခြားတဘဲ့တော်ဆေဟို ပြေးသွားယွေ့ “သူလို့ဟ လုတ်တိုင်းထဲမှ သခင်ဘုရားဟို ယူသွားကြပီ၊ ကိုယ်တော်ဟို သူလို့ ဖယ်နားမှာထားကြတာဟို ငါလို့မသိ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","အဲအခါ ပေတရုနဲ့ အခြားတဘဲ့တော်ဟ လုတ်တိုင်းသို့ သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","အဲသူနေယောက်လို့ဟ အတူပြေးကြသော်လည်း အခြားတဘဲ့တော်ဟ ပေတရုထက် လျင်မြန်စွာ ပြေးယွေ့ လုတ်တိုင်းသို့ ဦးရင်ရောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","သူဟ ငုံ့ယွေ့ ကျေ့ရာ လုတ်တိုင်းထဲတွင် ပိတ်စများ ဆိနေတာဟို မျော်လေအယ်၊ အဲလိုလဲ သူဟ ဂူထဲဟို မဝင်ဘဲ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ရှိမုန် ပေတရုဟ နောက်သို့လိုက်ယွေ့ ရောက်သောအခါ လုတ်တိုင်းဂူထဲဟို ဝင်ရင်၊ ပိတ်စများဆိတာဟို လည်းကောင်း၊ ");
INSERT INTO dnv_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ကိုယ်တော်ရဲ့ ဦးခေါင်းဟို ပတ်စဲထားသော ပုဝါဟ အဲပိတ်စများနဲ့အတူ မဆိဘဲ တခြားစီ လိပ်လျက်ဆိတာဟို လည်းကောင်း မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","အဲအခါ လုတ်တိုင်းဂူသို့ ဦးရင်ရောက်သော အခြားတဘဲ့တော်ဟလည်း အေးထဲသို့ဝင်ယွေ့ မျော်သဖြင့် ယုံကြည်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ကိုယ်တော်ဟ သေခြင်းမှ ဆှင်ပြန်ထမြောက်ရမယ် ဟူသော ကျမ်းစာဟို အဲသူလို့ဟ နားမလည်ကြသေး။ ");
INSERT INTO dnv_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","အဲပင်းရင် တဘဲ့တော်နေယောက်လို့ဟ နေအိုင်သို့ ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","မာရိဟ လုတ်တိုင်း အပြင်နှိုက် ငိုကလျက် ရပ်နေအယ်။ သူမဟ ငိုကနေခါ ငုံ့ယွေ့ ဂူထဲဟို ကျေ့လိုက်သောအခါ ");
INSERT INTO dnv_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ဖြူသောအဝတ်ဟို ဝတ်ဆင်လဲ့ ခေါန်းခင်တမန်နေပါးလို့ဟ ယေရှုရဲ့ အလောင်း လဲလျောင်းခဲ့ရာ အရပ်ရဲ့ ခေါင်းရင်းနှိုက် တပါး၊ ခြေရင်းနှိုက် တပါး ထိန်နေတာဟို မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","အဲသူလို့ဟ “အချင်းမိန်းမ၊ ပစာကျောန့် ငိုကတုန်း” ဟု မေးအယ်။ သူမဟ “ကျွန်မရဲ့ သခင်ဘုရားဟို သူလို့ ယူဆောင်သွားကြပီ၊ ကိုယ်တော်အား ဖယ်နားထားတာဟို မသိမန့်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","အဲလိုဆိုပင်းမှ နောက်သို့လှည့်ယွေ့ ကျေ့ရင် ယေရှု ရပ်လျက်နေတာဟို မျော်အယ်၊ အဲလိုလဲ ယေရှု ဖြစ်ကျောန်းဟို မသိ။ ");
INSERT INTO dnv_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ယေရှုဟ “အချင်းမိန်းမ၊ ပစာကျောန့် ငိုကတုန်း၊ နင်ဟ စသူ့ဟို ဆှာတုန်း” ဟု မေးအယ်။ သူမဟ ကိုယ်တော်ဟို ဥယျာဉ်ပိုင်ဆှင်ဟု ထင်မှတ်ပင်း၊ “ဆရာ၊ ကိုယ်တော်ရဲ့ အလောင်းဟို ယူဆောင်သွားခဲ့ရင် ဖယ်နားမှာထားတာဟို ကျွန်မအား ပြောမန့်၊ ကိုယ်တော်ဟို ကျွန်မ သွားယွေ့ ယူပါမယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ယေရှုဟ “မာရိ” ဟု ခေါ်အယ်။ မာရိဟ လှည့်ယွေ့ ဟေဗြဲစကားဖြင့် “ရဗ္ဗုနိ” ဟု ထူးလေအယ်၊ ရဗ္ဗုနိအနက်မှာ ဆရာဟု ဆိုလိုခြင်းဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ယေရှုဟလည်း “ငါဟ ခမည်းတော်ဆေဟို မတက်သွားရသေးလဲ့အတွက် ငါ့ဟို မထိနဲ့ဦး။ ငါ့ညီအကိုများဆေဟို သွားယွေ့ ‘ငါ့အဖဟူသော နင်လို့ရဲ့ ခမည်းတော်၊ ငါ့ ဘုရားသခင်ဟူသော နင်လို့ရဲ့ ဘုရားသခင်ဆေဟို ငါတက်သွားတော့မယ်’ ဟု သူလို့အား ပြောလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","အဲလိုမို့ မာဂဒလရွာသူ မာရိဟ တဘဲ့တော်လို့ဆေဟို သွားယွေ့ သခင်ဘုရားဟို ငါတွေ့မျော်ကျောန်းနဲ့ သခင်ဘုရားဟ စလို မိန့်ကျောန်းဟို ပြောကြားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","တဘဲ့တော်လို့ဟ ယုဒအာဏာပိုင်လို့ဟို ကြောက်လန့်သောကျောန့် တနင်္ဂနွေ ညခင်းချိန်နှိုက် ထင်ခါးများဟို ပိတ်ပင်း စုဝေးနေကြအယ်။ အဲပင်းရင် ယေရှုဟ ကြွလာယွေ့ အေးသူလို့အလယ်မှာ ရပ်လျက် “နင်လို့နှိုက် ငြိမ်သက်ခြင်း ဆိစေမန့်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ဟေသို့မိန့်ပင်းနောက် ကိုယ်တော်ဟ သူလို့အား သူရဲ့လက်များနဲ့ နံဘေးဟို ပြအယ်။ တဘဲ့တော်လို့ဟ သခင်ဘုရားဟို မျော်သောအခါ ဝမ်းမြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","တဖန် ယေရှုဟ “နင်လို့နှိုက် ငြိမ်သက်ခြင်း ဆိစေမန့်။ ခမည်းတော်ဟ ငါ့ဟို စေလွှတ်လဲ့အတိုင်း၊ နင်လို့ဟို ငါ စေလွှတ်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ဟေသို့မိန့်ပင်းမှ ကိုယ်တော်ဟ သူလို့အပေါ်သို့ မှုတ်သွင်းပင်း “သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ခံယူကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","နင်လို့ဟ လူလို့ရဲ့ အပစ်များဟို ဖြေလွှတ်ရင် သူလို့ဟ အပစ်ခွင့်လွှတ်ခြင်း ခံရမယ်၊ နင်လို့ဟ မဖြေလွှတ်ရင် သူလို့ဟ အပစ်ခွင့်လွှတ်ခြင်း ခံရမှာ မဟုတ်ဝူး” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ယေရှု ကြွလာသောအခါ တဆယ့်နေပါးသော တဘဲ့တော်လို့ထဲမှ တပါးဖြစ်ပင်း အမြွှာပူးဟု နာမယ်တွင်လဲ့ သောမဟ တဘဲ့တော်လို့နဲ့အတူ မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","အဲလိုမို့ အခြားတဘဲ့တော်လို့ဟလည်း “ငါလို့ဟ သခင်ဘုရားဟို မျော်ရကြပီ” ဟု သောမအား ပြောကြအယ်၊ သောမဟလည်း “ငါဟ သူ့လက်နှိုက် သံရိုက်ရာဟို မမျော်၊ သံရိုက်ရာထဲဟို ငါ့လက်ညှိုးဖြင့် မတို့မစမ်း၊ သူ့နံဘေးဟို ငါ့လက်ဖြင့် မစမ်းရရင် ငါယုံမှာ မဟုတ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ဆစ်ရက်ကြာပင်းနောက် တဘဲ့တော်လို့ဟ တဖန် အိုင်အတွင်းနှိုက် ဆိကြပင်း သောမလည်း သူလို့နဲ့အတူ ဆိအယ်။ ထင်ခါးများဟို ပိတ်ထားသော်လည်း ယေရှုဟ ကြွလာယွေ့ သူလို့အလယ်မှာ ရပ်လျက် “နင်လို့နှိုက် ငြိမ်သက်ခြင်းစေမန့်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","အဲပင်းရင် သောမအား “နင့်လက်ညှိုးဖြင့် ငါ့လက်များဟို တို့ကျေ့လော့၊ နင်ရဲ့လက်ဟို ဆန့်ယွေ့ ငါ့နံဘေးဟို စမ်းသပ်လော့။ ယုံမားခြင်း မဆိစေနဲ့၊ ယုံကြည်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","သောမဟ ကိုယ်တော်အား “ငါ့ရဲ့ သခင်၊ ငါ့ရဲ့ ဘုရားသခင်” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ယေရှုဟ “နင်ဟ ငါ့ဟို မျော်သောကျောန့် ယုံကြည်သလော၊ ငါ့ဟို မမျော်ဘဲ ယုံကြည်သောသူလို့ဟ မင်္ဂလာဆိကြအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ဟေကျမ်းစာနှိုက် ရေးမထားသော အခြားများစွာသော နိမိတ်လက္ခဏာများဟိုလည်း ယေရှုဟ သူရဲ့ တဘဲ့တော်လို့ မျက်မှောက်နှိုက် ပြုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","အဲလိုလဲ ယေရှုဟ ဘုရားသခင်ရဲ့ သားတော် ခရစ်တော်ဖြစ်ကျောန်းဟို နင်လို့ ယုံကြည်ကြရန်နဲ့ အဲသို့ ယုံကြည်ခြင်းဖြင့် ကိုယ်တော်ရဲ့ နာမနှိုက် အသက်ဟို ရဆိကြရန် ဟေအရာများဟို ရေးထားခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","အဲပင်းနောက် ယေရှုဟ တိဗေရိအိန်အနီးတွင် တဘဲ့တော်လို့အား တဖန် ကိုယ်ထင်ပြလေအယ်။ အဲသို့သော ဖြစ်ပျက်လဲ့အရာမှာ ");
INSERT INTO dnv_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ရှိမုန် ပေတရု၊ အမြွှာပူးဟု ခေါ်သော သောမ၊ ဂါလိလဲပြေ ကာနမြို့သား နာသနေလ၊ ဇေဗေဒဲရဲ့ သားများနဲ့ အခြား တဘဲ့တော်နေယောက်လို့ဟ အတူဆိနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ရှိမုန် ပေတရုဟ အခြားသူလို့အား “ငါ ငါးဖမ်းထွက်မယ်” ဟု ဆိုအယ်။ အဲသူလို့ဟ သူ့အား “ငါလို့လည်း လိုက်မယ်” ဟု ဆိုအယ်။ အဲလိုမို့ သူလို့ဟ ထွက်သွားယွေ့ လှေပေါ်ဟို တက်ကြအယ်၊ အဲလိုလဲ အေးညနှိုက် ငါးတကောင်မျှ မမိကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","မနက်စောစောနှိုက် ယေရှုဟ ကမ်းနားမှာ ရပ်လျက်နေအယ်၊ အဲလိုလဲ ယေရှုဖြစ်ကျောန်းဟို တဘဲ့တော်လို့ဟ မသိကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","အဲအခါ ယေရှုဟ သူလို့အား “လူပဲ့လို့၊ နင်လို့ ငါးမိကြသလော” ဟု မေးအယ်။ သူလို့ဟ “မမိပါ” ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ကိုယ်တော်ဟ သူလို့အား “လှေရဲ့ ညာဖက်သို့ ပိုက်ကွန်ဟို လောလော့၊ အဲသို့ပြုရင် နင်လို့ ရကြလိမ့်မယ်” ဟု မိန့်အယ်။ အဲလိုမို့ သူလို့ဟ ပိုက်ကွန်ဟို လောယွေ့ ရမ်းဆာ့များသော ငါးလို့ဟို အုပ်မိသောကျောန့် ပိုက်ကွန်ဟို ဆွဲယွေ့ မရနိန်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","အဲအခါ ယေရှုချစ်သော တဘဲ့တော်ဟ ပေတရုအား ငါလို့ရဲ့ “သခင်ဘုရား ဖြစ်အယ်” ဟု ပြောအယ်။ ရှိမုန် ပေတရု သခင်ဘုရားဖြစ်ကျောန်း ကြားသောအခါ၊ မိမိချွတ်ထားလဲ့ အပေါ်ဝတ်ဟို ခါးတွင် ပတ်ယွေ့ အိန်ထဲဟို ခုန်ဆင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","အခြားတဘဲ့တော်လို့ ကမ်းနဲ့ မနီးမဝေး ကိုက်တရာခန့်သာ ကွာယွေ့ ငါးနဲ့ပြေ့နေသော ပိုက်ကွန်ဟို ဆွဲလျက် လှေဖြင့် လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","သူလို့ဟ လှေပေါ်ဟ ဆင်းယွေ့ ကုန်းပေါ်သို့ ရောက်သောအခါ မီးခဲပုံဟိုလည်းကောင်း၊ ကင်ထားသောငါးနဲ့ မုန့်ဟိုလည်းကောင်း မျော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ယေရှုဟ သူလို့အား “အခု ဖမ်းမိသော ငါးကတစ်ဟို ယူခဲ့ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ရှိမုန် ပေတရုဟ လှေပေါ်ဟို တက်ယွေ့ ငါးကြီး ၁၅၃ ကောင်နဲ့ ပြေ့လျက်ဆိသော ပိုက်ကွန်ဟို ကုန်းသို့ ဆွဲတင်လေအယ်၊ ဟေမျှလောက်များသော်လည်း ပိုက်ကွန်ဟ မစုတ်မပြဲ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ယေရှုဟ သူလို့အား “လာယွေ့ စားလော့” ဟု မိန့်အယ်။ တဘဲ့တော်လို့ဟ သခင်ဘုရားဖြစ်ကျောန်းဟို သိသောကျောန့် စသူ့မျှ “ကိုယ်တော်ဟ စသူတုန်း” ဟု မမေးရဲကြ။ ");
INSERT INTO dnv_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","အဲလိုမို့ ယေရှုဟ လာယွေ့ မုန့်ဟို ယူပင်းရင် သူလို့အား ပေးအယ်၊ ငါးဟိုလည်း အဲတိုင်းတိုင်း ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","အဲသို့ပြခြင်းမှာ ယေရှုဟ သေခြင်းမှ ထမြောက်ပင်းနောက် တဘဲ့တော်လို့အား သုံးကြိမ်မြောက်သော ကိုယ်ထင်ဆှားပြခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","သူလို့စားကြပင်းနောက် ယေရှုဟ “ယောဟန်ရဲ့သား ရှိမုန်၊ အဲအခြားသူလို့ ငါ့ဟို ချစ်တာထက် နင်ဟ ငါ့ဟို ပိုယွေ့ ချစ်သလော” ဟု ရှိမုန် ပေတရုအား မေးလေအယ်။ “ဟုတ်အယ် သခင်ဘုရား၊ ကိုယ်တော်အား ငါ ချစ်တာဟို ကိုယ်တော် သိမန့်အယ်” ဟု ပြန်ဖြေအယ်။ ယေရှုဟ “ငါ့သိုးသငယ်လို့ဟို ကျွေးမွေးလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ဒုတိယအကြိမ် ယေရှုဟ “ယောဟန်ရဲ့သား ရှိမုန်၊ နင်ဟ ငါ့ဟို ချစ်သလော” ဟု မေးအယ်။ “ဟုတ်အယ် သခင်ဘုရား၊ ကိုယ်တော်အား ငါ ချစ်တာဟို ကိုယ်တော် သိမန့်အယ်” ဟု ပြန်ဖြေအယ်။ ယေရှုဟ “ငါ့သိုးလို့ဟို စောင့်ဆှောက်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ယေရှုဟ “ယောဟန်ရဲ့သား ရှိမုန်၊ နင်ဟ ငါ့ဟို ချစ်သလော” ဟု တတိယအကြိမ် မေးအယ်။ ပေတရုဟ ဝမ်းနည်းသောကျောန့် “သခင်ဘုရား၊ ကိုယ်တော်ဟ အရာခပ်သိမ်းဟို သိအယ်၊ ကိုယ်တော်အား ငါ ချစ်တာဟို ကိုယ်တော် သိမန့်အယ်” ဟု ပြောအယ်။ ယေရှုဟ သူ့အား ဆိုအယ် “ငါ့သိုးလို့ဟို ထိန်းလော့။ ");
INSERT INTO dnv_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","နင်လို့အား ငါ အမန်ဆိုအယ်၊ နင်ဟ ငယ်ခါဟ ဝတ်ချင်ရာဝတ်ပင်း သွားချင်ရာသို့ သွားတတ်အယ်၊ အဲလိုလဲ နင်ဟ အိုလာသောအခါ နင်ရဲ့လက်နေဖက်ဟို ဆန့်လျက် သူတပါးဟ နင့်ဟို တုတ်ချေပင်း နင်မသွားလိုလဲ့အရပ်ဟို ဆောင်သွားလိမ့်မယ်” ဟု မိန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(ဟေသို့မိန့်ရာနှိုက် ပေတရုဟ စလို သေခြင်းအားဖြင့် ဘုရားသခင်ရဲ့ ဘုန်းအသရေဟို ထွန်းတောက်စေမဲ့အကျောန်း ဖော်ပြခြင်း ဖြစ်အယ်။) အဲသို့ မိန့်ပင်းမှ “ငါ့နောက်ဟို လိုက်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ပေတရုဟ လှည့်ယွေ့ ကျေ့လိုက်သောအခါ သူရဲ့နောက်တွင် ယေရှုချစ်သော အခြားတဘဲ့တော်ဟို မျော်လေအယ်။ အဲသူဟ ညစာစားစဉ် ယေရှုရဲ့ ရင်တော်ဟို မှီလျက် “သခင်ဘုရား၊ ကိုယ်တော်အား သစ္စာဖောက်မဲ့သူဟ စသူတုန်း” ဟု မေးဆှောက်ခဲ့သူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ပေတရုဟ အေးသူဟို မျော်သောအခါ “သခင်ဘုရား၊ ဟေသူဟ စလို ဖြစ်မှာတုန်း” ဟု မေးဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ယေရှုဟ “ငါ ကြွလာလဲ့တိုင်အောန် သူ့အား အသက်ဆှင်စေရန် ငါအလိုဆိရင် နင်နဲ့ စလိုဆိုင်တုန်း၊ နင်ဟ ငါ့နောက်ဟို လိုက်လော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","အဲလိုမို့ ယေရှုရဲ့ နောက်လိုက်တဘဲ့တော်လို့ဟ သေရတော့မှာ မဟုတ်ဟု တဘဲ့တော်လို့ အထဲတွင် ပျံ့နှံ့သွားအယ်။ အဲလိုလဲ ယေရှုဟ အဲသူဟ မသေရဟု မိန့်တာ မဟုတ်။ “ငါ ကြွလာလဲ့တိုင်အောန် သူ့အား အသက်ဆှင်စေရန် ငါအလိုဆိရင် နင်လို့နဲ့ စလိုဆိုင်တုန်း” ဟု မိန့်ခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ဟေအကျောန်းရာလို့ဟို သက်သေခံယွေ့ ရေးသားထားသူမှာ အေးတဘဲ့တော်ပင် ဖြစ်အယ်။ သူရဲ့ သက်သေခံချက် မန်ကျောန်းဟိုလည်း ငါလို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","အခု ယေရှု ပြုသော အခြားအမှုရာများစွာ ဆိသေးအယ်။ အဲအမှုရာလို့ဟို တခုချင်းရေးထားရင် ဟေလောကနှိုက်ပင် အဲရေးထားသော ပအုပ်များ ဆန့်မှာ မဟုတ်ဟု ငါ ထင်မှတ်အယ်။");
INSERT INTO dnv_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ချစ်သော သော်ဖိလု၊ ယေရှုဟ သူ့ရဲ့ အမှုတော် ဆောင်ရွက်ခြင်းနဲ့ သွန်သင်ခြင်းလို့ဟို အစပြုချိန်မှ စယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ရွေးကောက်သော တမန်တော်များဟို သန့်ဆှင်းသော ဝိညာဉ်တော်အားဖြင့် မိန့်မှာပင်းနောက် ခေါန်းခင်ဟို ဆောင်ယူခြင်းခံသော နေ့တိုင်အောန် ဖြစ်ပျက်သမျှလို့ဟို ပထမစာစောင်နှိုက် ငါရေးသား ဖော်ပြခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ကိုယ်တော်ဟ ဒုက္ခဝေဒနာ ခံစားပင်းနောက် မိမိအသက်ဆှင်လျက် ဆိကျောန်း အေးတမန်တော်လို့အား ရမ်းဆာ့ အထောက်အထားလို့ဖြင့် ပြသကာ ရက်ပေါင်းလေးဆယ်အတွင်း သူလို့ဆေ ထင်ဆှားယွေ့ ဘုရားသခင်ရဲ့ နိုင်ငံတော်အကျောန်းဟို ဟောပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","အဲပင်းရင် သူလို့ဟ အတူတကွ လာကြသောအခါ ကိုယ်တော်ဟ သူလို့ဟို “ယေရုရှလင်မြို့မှ မထွက်ခွာကြဘဲ ငါပြောလဲ့ ဆုကျေးဇူးအကျောန်းဖြစ်သော ငါ့အဖ ကတိထားလဲ့ ဆုကျေးဇူးအတွက် စောင့်မျော်နေကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","အကျောန်းမှာ ယောဟန်ဟ ယေနဲ့ နှစ်ခြင်းဟို ပေးပေမဲ့ နင်လို့ဟ ရက်အနည်းငယ်အတွင်းနှိုက် သန့်ဆှင်းသော ဝိညာဉ်တော်ဖြင့် နှစ်ခြင်းဟို ခံယူကြရလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","အဲပင်းရင် တမန်တော်လို့ဟ ယေရှုနဲ့ တွေ့ရန် စုဝေးလာကြသောအခါ သူလို့ဟ “အဆှင်၊ ဟေအချိန်ဟ ဣသရေလ အမျိုးသားလို့အတွက် နိုင်ငံဟို ပြန်လည်ထူထောင် ပေးမယ်လော” ဟု မေးဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ယေရှုဟ သူလို့အား “ငါ့အဖရဲ့ ကိုယ်ပိုင် အခွင့်အာဏာအားဖြင့် စီရင်ပြဋ္ဌာန်းထားလဲ့ အချိန်အခါဟို နင်လို့ သိပိုင်ခွင့် ဆိဝူး။ ");
INSERT INTO dnv_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","အဲလိုလဲ နင်လို့ အပေါ်ဟို သန့်ဆှင်းသော ဝိညာဉ်တော် ဆင်းသက်သောအခါ နင်လို့ဟ တန်ခိုးနဲ့ ပြေ့လိမ့်မယ်၊ နင်လို့ဟ ယေရုရှလင်မြို့၊ ယုဒပြေတပြေလုံးနဲ့ ရှမာရိပြေမှ စယွေ့ ကမ္ဘာမြေကြီး အဆုံးတိုင်အောန် ငါရဲ့ အကျောန်းဟို သက်သေခံသူများ ဖြစ်ကြလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","အေးအရာများဟို ပြောပင်းရင်၊ သူလို့ ကျေ့လျက်နေခါ ကိုယ်တော်ဟ ခေါန်းခင်ဘုံဟို ဆောင်ယူခြင်းဟို ခံအယ်၊ အဲပင်းရင် မိုးချေးသားဟ ကိုယ်တော်ဟို ဖုံးကွယ်ပင်း သူလို့မြင်ကွင်းမှ ဆောင်ယူသွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ဟေလို့ ကိုယ်တော် တက်ကြွစဉ် တမန်တော်လို့ဟ မိုးခေါန်းခင်ဟို အာရုံစိုက်ယွေ့ ကျေ့နေကြရာ၊ အချိန်မှာ အဝတ် အဖြူဝတ်ထားသော လူနေယောက်ဟ ခုတုံး သူလို့ဖေးနားတွင် ရပ်နေကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“ဂါလိလဲပြေသားလို့၊ နင်လို့ဟ ပစာကျောန့် ရပ်ယွေ့ မိုးခေါန်းခင်ဟို မော်ကျေ့နေကြလုန်း၊ နင်လို့ဆေမှ ခေါန်းခင်ဘုံဟို ယူဆောင်ခြင်းဟို ခံသော အေးယေရှုဟ ပစာသို့ ခေါန်းခင်ဘုံဟို တက်ကြွတာဟို နင်လို့ မျော်ရကြအယ်၊ ဟေနည်းအတိုင်းပင် ပြန်လည် ကြွလာလိမ့်မယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","အေးနောက် တမန်တော်များဟ သံလွင် နာမယ်တွင်သော တောင်မှ ယေရုရှလင်မြို့ဟို ပြန်ကြအယ်၊ အေးတောင်ဟ မြို့နဲ့ မိုင်ဝက်ခန့်လောက် ဝေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","သူလို့ဟ မြို့ထဲဟို ဝင်ယွေ့ မိမိလို့ တည်းခိုရာနေအိုင် အပေါ်ထပ် အခန်းဟို တက်သွားကြအယ်။ အဲသူလို့ဟ ပေတရု၊ ယောဟန်၊ ယာကုပ်နဲ့ အိန္ဒြေ၊ ဖိလိပ္ပုနဲ့ သောမ၊ ဗာသောလမဲနဲ့ မဿဲ၊ အာလဖဲ သား ယာကုပ်၊ မျိုးချစ်စိတ်ထက်သန်သူ ရှိမုန်နဲ့ ယာကုပ်ရဲ့ သား ယုဒလို့ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","သူလို့ဟ ယေရှုနဲ့ အမေ့ဖြစ်သူ မာရိ အပါအဝင် အမျိုးသမီးလို့နဲ့ လည်းကောင်း၊ ကိုယ်တော်ရဲ့ ညီတော်လို့နဲ့ လည်းကောင်း မကြာခဏ တွေ့ဆုံယွေ့ ဆုတောင်းလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ရက်အနည်းငယ် ကြာသောအခါ အရေအတွက်အားဖြင့် လူ တရာ့နေဆယ်ခန့်သော ယုံကြည်သူများလို့ဟ တနေရာတည်းတွင် စုဝေးကြရာ ပေတရုဟ စကားပြောရန် ထယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","သူဟ “ငါ့ရဲ့ မိတ်ဆွေလို့၊ ယေရှုဟို ဖမ်းဆီးသူလို့ရဲ့ လမ်းပြဖြစ်သူ ယုဒရှကာရုတ်ဟို ရည်မှတ်ယွေ့ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ ဒါဝိဒ်မင်း စလောင်အားဖြင့် ကြိုတင်ဟောပြောထားသော ကျမ်းချက်ဟ ပြေ့စုံလာစေရန် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ယုဒဟ ငါလို့ အဖွဲ့ထဲဟ အဖွဲ့ဝင်တယောက် ဖြစ်ပင်း ငါလို့ အလုပ်ထဲရဲ့ တထောင့်တနေရာမှာ ရွေးချယ်ခံရသော သူတယောက် ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","သူဟ မိမိဆိုးညစ်မှုကျောန့် ရဆိလဲ့ ပိတ်ဆန်ဖြင့် လယ်တကွက်ဟို ဝယ်ပင်းနောက် အဲလယ်မြေပေါ်တွင် လဲကျသေဆုံးလေအယ်၊ သူ့ရဲ့ ဖိုက်ဟ ပေါက်ယွေ့ အူများ ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ယေရုရှလင်မြို့နှိုက် နေထိန်သော လူအားလုံးလို့ဟ ဟေအဖြစ်အပျက်အကျောန်းဟို ကြားသိကြအယ်၊ အေးလို့ဖြစ်ယွေ့ အဲလယ်ဟို မိမိလို့ ဘာသာစကားဖြင့် “အကေလဒမ” ဟု ခေါ်ဆိုကြအယ်၊ အနက်အဓိပ္ပာယ်ဟ “သွေးလယ်မြေ” ဟု ဆိုလိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“အကျောန်းမှာ ဆာလံ ပအုပ်နှိုက်၊ “ ‘သူ့ရဲ့ နေအိုင် လူသူဆိတ်ညံရာ ဖြစ်စေမန့်၊ အဲအိုင်တွင် စသူမှ မနေပါစေနဲ့။’ ‘အဲသူရဲ့ ရာထူးဟိုလည်း အခြားသူတဦး ယူပါစေ’ ဟူယွေ့ ရေးသားထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“အဲလိုမို့ သခင် ယေရှု ဆှင်ပြန်ထမြောက်စေကျောန်းဟို ငါလို့နဲ့အတူ သက်သေခံရန်အတွက် လူတယောက်ဟို ရွေးချယ်ရမယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ယောဟန်ဟ သူ့ရဲ့ နှစ်ခြင်းအကျောန်း ဟောပြော လဲ့ အချိန်မှ စယွေ့ ခေါန်းခင်ဘုံသို့ ဆောင်ယူခြင်းဟို ခံချိန်ထိ ငါလို့နဲ့အတူ သွားလာနေထိန်ခဲ့သူ တဦးဟ ကိုယ်တော်ရဲ့ ဆှင်ပြန်ထမြောက်ခြင်းအကျောန်း ငါလို့နဲ့အတူ သက်သေခံသူ ဖြစ်ရမယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","အဲလိုမို့ သူလို့ဟ ဗာရှဗ ခေါ် ယုတ္တုနာမယ်သစ်ဟို ရသောသူ ယောသပ်နဲ့ မဿိလို့ လူနေယောက်ဟို ရွေးကောက်ရန် အဆိုပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","အေးနောက် သူလို့ဟ “အဆှင်၊ ကိုယ်တော်ဟ လူတိုင်းရဲ့ အတွေးများဟို သိသောကျောန့်၊ ");
INSERT INTO dnv_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ယုဒဟ မိမိနေရာဟို သွားရန် တမန်တော် အရိုက်အရာမှ ရွေ့လျော့ဖောက်ပြန်တာ ဖြစ်ယွေ့ ဟေအမှုတော်လုပ်ငန်းနဲ့ တမန်တော် အရိုက်အရာဟို ဆက်ခံရန် ဟေသူ နေယောက်အနက် စသူဟို ကိုယ်တော် ရွေးချယ်ထားတာဟို ငါလို့အား ဖော်ပြမန့်” ဟု ဆုတောင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","အဲပင်းရင် သူလို့နေဦးအတွက် စာရေးတံ မဲနှိုက်ကြရာ မဿိ ရဆိသဖြင့် သူ့အား တမန်တော် တဆယ့်တပါးလို့နဲ့အတူ တမန်တော် ဖြစ်စေရန် အဖွဲ့ထဲဟို ထည့်ဖို့ ရွေးကောက်ခန့်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ပင်တေကုတ္တေ ပွဲတော်နေ့ ကျရောက်သောအခါ ယုံကြည်သူများ အားလုံးလို့ဟ တနေရာတည်းတွင် စုဆုံလျက် ဆိနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","အေးအခါ လေပြင်းမုန်တိုင်း တိုက်ခတ်သံလိုမျိုး နှောင်းနှင်းခတ်သံဟ အထက် မိုးခေါန်းခင်မှ ခုတင်ချင်း ပေါ်လာပင်း သူလို့ နေထိန်ရာ နေအိုင် တအိုင်လုံးဟို ပြေ့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","အဲပင်းရင် သူလို့ဟ ပျံ့နှံ့လျက်ဆိသော မီးလျှာများလိုမျိုး အရာများဟိုလည်း မျော်ရပင်း အေးမှာဆိလဲ့သူလို့ အသီးသီးပေါ်တွင် တည်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","အဲသူအပေါင်းလို့ဟလည်း သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝလျက် ဝိညာဉ်တော်ဟ သူလို့အား ပြောနိန်စွမ်းပေးလဲ့အတိုင်း အခြားသော ဘာသာစကားများဖြင့် စတင် ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","အဲကာလနှိုက် ခေါန်းခင်အောက်တွင် ဆိသမျှ တိုင်းပြေအသီးသီးမှ လာရောက်ကြသော ဘုရားတရား ရိုသေကိုင်းရှိုင်းသော ယုဒလူမျိုးလို့ဟ ယေရုရှလင်မြို့တွင် တည်းခိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","အေးအသံဟို သူလို့ ကြားသောအခါ လူအုပ်ကြီးလို့ဟ စုလာကြအယ်။ ယုံကြည်သူများ ဟောတာဟို လူတိုင်း မိမိဘာသာစကားဖြင့် ကြားရသောကျောန့် သူလို့အားလုံးဟ အံ့ဩကုန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","သူလို့ဟ ရမ်းဆာ့ အံ့ဩပင်း တွေဝေကာ “ဟေလို့ ဟောပြောနေကြသော လူလို့ဟ ဂါလိလဲပြေသားများ မဟုတ်လော။ ");
INSERT INTO dnv_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","အေးလို့ဟုတ်ရင် ငါလို့အားလုံးဟ မိမိလို့ ဘာသာစကားအတိုင်း အသီးသီး ကြားရကြတာဟ စလိုလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ငါလို့ဟ ပါသိပြေ၊ မေဒိပြေ၊ ဧလံပြေမှ၊ မေသောပေါတာမိပြေ၊ ကပ္ပဒေါကိပြေ၊ ယုဒပြေ၊ ပုန္တုပြေနဲ့ အာရှပြေ၊ ");
INSERT INTO dnv_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ဖြူဂိပြေမှ ပမ်ဖုလိပြေ၊ အဲဂုတ္တုပြေနှိုက် နေသောသူ၊ အဲဂုတ္တု၊ ကုရေနေမြို့နဲ့စပ်သော လိဗုကျေးလက်နှိုက် နေသောသူများ ဖြစ်ကြအယ်။ တချို့သော ငါလို့ဟ ရောမမြို့မှ ရောက်လာသောသူများ၊ ");
INSERT INTO dnv_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ယုဒအမျိုးသားများနဲ့ ယုဒဘာသာဟို ကူးပြောင်းလာကြသော တပါးအမျိုးသားများ ဖြစ်ကြအယ်၊ တချို့သော ငါလို့ဟ ကရေတေပြေနဲ့ အာရပ်အမျိုးသားများ ဖြစ်ကြအယ်၊ အဲလိုမို့ ငါလို့ဟ ဘုရားသခင်ပြုသော အံ့ဩဖွယ်အမှုများဟို ငါလို့ ဘာသာစကားဖြင့် ဟောပြောကြတာဟို ကြားရကြအယ်” ဟု ကြွေးကြော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","သူလို့ဟ အံ့ဩပင်း ဝေခွဲမရ ဖြစ်ကြကာ “ဟေအရာဟ ပစာအရာဟို ဆိုလိုလုန်း” ဟု အချင်းချင်း ဆက်ပင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","အဲလိုလဲ အခြားသူများဟ “ဟေသူလို့သည် စပျစ်ယေ မူးယစ်နေသူများ ဖြစ်ကြအယ်” ဟု ယုံကြည်သူများအား ကဲ့ရဲ့ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","အဲပင်းရင် ပေတရုဟ တခြားတမန်တော် တဆယ့်နေယောက်လို့နဲ့အတူ ရပ်လျက် လူအုပ်ကြီးလို့အား အသံကျယ်ကြီးနဲ့ စပင်း ပြောတာဟ “ယုဒအမျိုးသားများနဲ့ ယေရုရှလင်မြို့တွင် နေသောသူအားလုံး ငါ့စကားဟို နားထောင်ကြလော့၊ အေးအရာဟ ပစာဆိုလိုတာဟို ငါ ပြောပြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ဟေလူလို့ဟ နင်လို့ ထင်လဲ့အတိုင်း မူးနေသူများ မဟုတ်၊ အေးအချိန်ဟ နက်စာ ကိုးနာရီဘဲ ဆိသေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","အဲအစား၊ ဟေအရာဟ ပရောဖက် ယောလ ဟောကြားခဲ့လဲ့အကျောန်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘ဘုရားသခင် ပြောတာဟ နောက်ဆုံးသော နေ့ရက်များမှာ ငါ လုပ်မဲ့အရာဟ ဟေလို ဖြစ်လိမ့်မယ်၊ လူတိုင်းအပေါ်ဟို ငါရဲ့ ဝိညာဉ်တော် သွန်းလောင်းမယ်။ နင်လို့ရဲ့ အောင်နီငယ်များနဲ့ မိနီငယ်များဟ ငါရဲ့ သတင်းစကားဟို ဟောပြောလိမ့်မယ်၊ လူငယ်များဟ ဗျာဒိတ် ရူပါရုံများဟို မျော်ရကြလိမ့်မယ်၊ အားပင်း လူအိုလို့ဟ အိပ်မက်များ မက်ကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ဟုတ်အယ်၊ ငါရဲ့ အစေခံများ ယောက်ျားနဲ့ မိန်းမများတောင်မှ ငါရဲ့ ဝိညာဉ်တော်ဟို အေးနေ့ရက်များမှာ သွန်းလောင်းလိမ့်မယ်၊ အားပင်း သူလို့ဟ ငါရဲ့ သတင်းစကားဟို ဟောပြောကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","အထက် မိုးခေါန်းခင်တွင် အံ့ဩဖွယ်သော အရာများဟို လည်းကောင်း၊ အားပင်း အောက်အရပ် မြေကြီးပေါ်တွင် နိမိတ်လက္ခဏာများဟို ငါ ပြလိမ့်မယ်၊ အသွေး၊ မီး၊ မီးခိုးတည်းဟူသော အတိတ်နိမိတ်များ ဖြစ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","အဆှင်ရဲ့ နေ့ထူးနေ့မြတ်ကြီး မရောက်ခင် နေဟ မိုက်အတိ ဖြစ်လိမ့်မယ်၊ လဟ အသွေးလိုမျိုး အနီရောင် ပြောင်းသွားလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","အေးနောက်၊ အဆှင်ဟို ခေါ်သောလူ စသူမဆို ကယ်တင်ခြင်းဟို ခံရကြလိမ့်မယ်’ ဟု ဟောပြောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ဣသရေလ အမျိုးသားလို့၊ ဟေစကားများဟို နားထောင်ကြလော့။ နင်လို့ သိကြလဲ့အတိုင်း ဘုရားသခင်ဟ နာဇရက်မြို့သား ယေရှုအားဖြင့် နင်လို့ အလယ်နှိုက် အံ့ဩဖွယ်ရာများ၊ တန်ခိုးများနဲ့ နိမိတ်လက္ခဏာများဟို ပြခဲ့အယ်။ ဘုရားသခင်ဟ ဟေအရာများအားဖြင့် ယေရှုနဲ့ ပတ်သက်သော ခိုင်မာလဲ့ အထောက်ထားများဟို နင်လို့အား ပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ဘုရားသခင်ဟ မိမိရဲ့ အစီစဉ်နဲ့အညီ ယေရှုဟို နင်လို့ လက်ဟို ပေးအပ်ရန် ဆုံးဖြတ်ခဲ့ပင်း၊ နင်လို့ဟ အပစ်လုပ်သူလို့ လက်ဖြင့် အေးအဆှင်ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့ သတ်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","အဲလိုလဲ ဘုရားသခင်ဟ သူ့အား သေခြင်းမှ ထမြောက်စေပင်း သူ့ရဲ့ တန်ခိုးတော်အားဖြင့် လွတ်မြောက်စေအယ်၊ ပစာကို့ အေးအဆှင်ဟို သေခြင်းဟ အစဉ်အမြဲ ကိုယ်တော်ဟို တုတ်ချေယွေ့ မရနိန်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","အေးအဆှင်နဲ့ ပတ်သက်ယွေ့ ဒါဝိဒ်မင်းဟ၊ “ ‘ငါဟ ထာဝရဘုရားဟို အချိန်တိုင်း မျော်ရအယ်၊ ငါဟ ဒုက္ခမရောက်စေရန် ကိုယ်တော်ဟ ငါ့ အနီးတွင် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","အဲလို့မို့ ငါရဲ့ စိတ်နေလုံးဟ ရွှင်လန်းခြင်းနဲ့ ပြေ့လျက်၊ ငါရဲ့ စလောင်ဟ ရွှင်ပျသော စကားများဖြင့် ပြေ့လျက် ဆိအယ်။ ငါ့ အသွေးအသားဟ မျော်လင့်ချက်အတွက် အေးချမ်းစွာ နေရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ပစာကို့ ကိုယ်တော်ဟ ငါရဲ့ ဝိညာဉ်ဟို မရဏာနိုင်ငံတွင် လောယွေ့ ထားမယ် မဟုတ်၊ ကိုယ်တော်ဟ သစ္စာဆိသော အစေခံဟို လုတ်တိုင်းတွင် ပုပ်ပျက်ရန် ခွင့်ပြုဝူး။ ");
INSERT INTO dnv_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ကိုယ်တော်ဟ အသက်ဆှင်ရာ လမ်းလို့ဟို ငါ့အား ပြညွှန်အယ်။ ကိုယ်တော်ရဲ့ မျက်မှောက်မှာ ငါလို့ဟို ဝမ်းမြောက်ခြင်းနဲ့ ပြေ့စေလိမ့်မယ်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ငါ့ မိတ်ဆွေလို့၊ ငါလို့ရဲ့ နာမယ်ကျော် အဖဖြစ်သော ဒါဝိဒ်မင်းရဲ့ အကျောန်းဟို ငါဟ နင်လို့အား ဆှင်းလင်းစွာ ဖော်ပြပါရစေ။ သူဟ သေလွန်ယွေ့ သင်္ဂြိုဟ်ခြင်းဟို ခံရပင်း သူ့ရဲ့ လုတ်တိုင်းဟ ခုနေ့တိုင်အောန် ငါလို့နှိုက်တွင် ဆိသေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","သူဟ ပရောဖက်တပါး ဖြစ်သောကျောန့် သူ့ရဲ့ သားမြေးထဲမှ တဦးဟို သူ့ရဲ့ ပလ္လင်ပေါ်တွင် ထိန်စေမယ်ဟု ဘုရားသခင်ဟ သူ့အား ကတိသစ္စာဖြင့် တိုင်တည်ယွေ့ မိန့်ကျောန်း သိထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ဒါဝိဒ်ဟ နောင်အခါတွင် ဘုရားသခင် စလိုမျိုး ပြုမယ်ဟို မျော်သဖြင့်၊ “ ‘ကိုယ်တော်ဟို မရဏာနိုင်ငံတွင် စွန့်ပစ်ယွေ့ ထားတော်မမူ။ သူ့ရဲ့ ကိုယ်ခန္ဓာဟ လုတ်တိုင်းတွင် ပုပ်ပျက်စေမယ် မဟုတ်’ ဟု မေဆှိယ ထမြောက်မဲ့အကျောန်းဟို ပြောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","အဲယေရှုအား ဘုရားသခင် ဆှင်ပြန်ထမြောက်စေကျောန်းဟို ငါလို့အားလုံးဟ ဟေအကျောန်းအရာရဲ့ သက်သေ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ကိုယ်တော်ဟ ဘုရားသခင်ရဲ့ လက်ယာဖက်တွင် ချီးမြှင့်ခြင်း ခံပင်းနောက် ခမည်းတော် ကတိထားလဲ့ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ခံယူယွေ့ နင်လို့အခု တွေ့မြင် ကြားသိနေကြလဲ့ ဝိညာဉ်တော်ဟို ငါလို့ အပေါ်သို့ သွန်းလောင်းလေပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ဒါဝိဒ်ဟ ခေါန်းခင်သို့ မတက်သေး၊ အဲလိုမို့ သူဟ၊ ‘ထာဝရဘုရားဟ ငါ့အဆှင်ဟို ဟောတာဟ ငါရဲ့ လက်ယာဖက်တွင် ထိန်နေလော့။ ");
INSERT INTO dnv_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","နင့်ရဲ့ ရန်သူများဟို နင့်ရဲ့ ခြေတင်ရာခုံ အဖြစ် ငါ မချထားခင် အထိ’ ဟူယွေ့ ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“အဲလိုမို့ ဣသရေလအမျိုးသား အားလုံးလို့၊ မေဆှိယနဲ့ အဆှင်အဖြစ်ဖြင့် လည်းကောင်း၊ ဘုရားသခင် ခန့်ထားသောသူဟ နင်လို့ လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့ သတ်ကြလဲ့ ယေရှုပင် ဖြစ်ကျောန်း အမန် သိမှတ်ကြလော့” ဟု ဟောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","လူလို့ဟ အဲစကားဟို ကြားသောအခါ သူလို့ဟ ရမ်းဆာ့ပင် စိတ်ပူပင်သောက ရောက်ကြလျက် ပေတရုနဲ့ အခြား တမန်တော်လို့အား “ညီအကိုလို့၊ ငါလို့ စလိုပြုရမလုန်း” ဟု မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ပေတရုဟ သူလို့ဟို “နင်လို့ အယောက်စီတိုင်း အပစ်မှ နောင်တရကြပင်း၊ နင်လို့ အပစ်များ ဖြေလွှတ်စေရန် ယေရှု ခရစ်ရဲ့ နာမနှိုက် နှစ်ခြင်းဟို ခံလော့။ အားပင်း နင်လို့ဟ သန့်ဆှင်းသော ဝိညာဉ်တော် တည်းဟူသော ဘုရားသခင်ရဲ့ လက်ဆောင်ဟို ရဆိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","အကျောန်းမှာ ဟေကတိတော်ဟ နင်နဲ့ နင်လို့ရဲ့ လူပဲ့များမှ စယွေ့ အဝေးနှိုက်ဆိသော သူအားလုံးဖြစ်ကြသော ငါလို့ရဲ့ ဘုရားသခင် ထာဝရဘုရား ခေါ်သော သူလို့အတွက် ဖြစ်အယ်” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ပေတရုဟ အခြားသော တရားစကားများဖြင့်လည်း “နင်လို့ မိမိလို့တတ်တိုင်း ဟေဆိုးယုတ်သော လူလို့ခံရကြမဲ့ အပစ်ဒဏ်မှ ကင်းလွတ် စေကြလော့” ဟု အေးသူလို့အား တိုက်တွန်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","လူအမြောက်အများဟ သူရဲ့စကားဟို လက်ခံကြကာ နှစ်ခြင်းမင်္ဂလာဟို ခံယူကြသဖြင့် အဲနေ့တွင် လူပေါင်း ၃,၀၀၀ မျှ တိုးပွားလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","အဲသူလို့ဟ တမန်တော်လို့ရဲ့ ဆုံးမဩဝါဒဟို ခံယူခြင်း၊ မိတ်သဟာယဖွဲ့ခြင်း၊ စုပေါင်းနေထိန် စားသောက်ခြင်း၊ ပွဲတော်မင်္ဂလာဝင်ခြင်း၊ အတူတကွ ဆုတောင်းခြင်းလို့ဖြင့် အချိန်ဟို ကုန်လွန်စေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","တမန်တော်လို့ဟ ရမ်းဆာ့သော အံ့ဩဖွယ်ရာများနဲ့ နိမိတ်လက္ခဏာများဟို ပြကြသဖြင့် လူအပေါင်းလို့ဟ အံ့ဩမှုနဲ့ ပြေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ယုံကြည်သောသူအပေါင်းလို့ဟ တစုတဝေးတည်း နေထိန်ယွေ့ မိမိလို့ပိုင်ဆိုင်လဲ့ ဥစ္စာပစ္စည်းများဟို သူလို့အချင်းချင်း ဝေမျှသုံးစွဲကြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","မိမိလို့ရဲ့ ဥစ္စာပစ္စည်းများဟို ရောင်းချယွေ့ လိုအပ်နေသော သူတယောက်စီတိုင်းဟို ပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","သူလို့ဟ နေ့စဉ်နေ့တိုင်း ဗိမာန်တော်တွင် အတူတကွ ဆက်လက်ယွေ့ တွေ့ဆုံကြအယ်။ သူလို့ဟ မိမိလို့ နေအိုင်များတွင် နှိမ့်ချသောစိတ်ဖြင့် ဝမ်းမြောက်စွာ အတူတကွ အစာအာဟာရဟို သုံးဆောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ဘုရားသခင်ရဲ့ ကျေးဇူးတော်ဟို ချီးမွန်းလျက် လူအပေါင်းလို့ရဲ့ အဆေ့တွင် မျက်နှာရ ကြအယ်။ ကယ်တင်ခြင်းသို့ ရောက်သောသူလို့ဟိုလည်း သခင်ဘုရားဟ နေ့စဉ်နေ့တိုင်း တိုးပွားစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","တနေ့သောအခါ ဆုတောင်းချိန် မွန်းလွဲသုံးနာရီတွင် ပေတရုနဲ့ ယောဟန်လို့ဟ ဗိမာန်တော်ဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","မွေးရာပါ ခြေမသန်စွမ်းသူ လူတဦးဟို တင့်တယ်ဟုခေါ်လဲ့ ထင်ခါးနားဟို ထမ်းလာကြအယ်၊ အဲဗိမာန်တော်ထဲဟို လာကြသော သူများဆေမှ ပိတ်ဆန် တောင်းနိန်ရန်အတွက် သူ့ဟို ဗိမာန်တော် ထင်ခါးအနီးတွင် နေ့တိုင်းချထားလေ့ ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","သူဟ ပေတရုနဲ့ ယောဟန်လို့ ဗိမာန်တော်ထဲသို့ ဝင်မယ်လုပ်တာဟို မျော်သောအခါ တစုံတရာပေးရန် သူလို့ဟို တောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ပေတရုနဲ့ ယောဟန်လို့ဟ သူ့ဟို တန်းတန်းကျေ့ကြပင်း ပေတရုဟ “ငါလို့ဟို ကျေ့လော့” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","အဲအခါ သူဟ သူလို့ဆေမှ တစုံတခု ရဆိမယ်အထင်နဲ့ သူလို့ဟို အာရုံစိုက်ယွေ့ ကျေ့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","အဲလိုလဲ ပေတရုဟ သူ့အား “ငါ့မှာ ဆွေ အဲဟာမဟုတ်ရင် ပိတ်ဆန် မဆိ၊ အဲလိုလဲ ဆိလဲ့အရာဟို နင်အား ငါ ပေးမယ်၊ နာဇရက်မြို့သား ယေရှု ခရစ်တော်ရဲ့ နာမတော်အားဖြင့် ထယွေ့ လှမ်းသွားလော့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","အဲပင်းရင် သူထဖို့ သူရဲ့ ညာဖက်လက်ဟို ဆွဲပင်း မလိုက်အယ်။ ခုတုံးပင် သူရဲ့ ခြေထောက်နဲ့ ခြေကျင်းဝတ်များဟ သန်မာလာသဖြင့်၊ ");
INSERT INTO dnv_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","သူဟ ထခုန်ပေါက်ပင်း မတ်တတ်ရပ်ကာ၊ စတင်ပင်း လမ်းဆှောက်လေအယ်။ အဲပင်းရင် လမ်းဆှောက်လျက်၊ ခုန်ပေါက်လျက်၊ ဘုရားသခင်ရဲ့ ဂုဏ်တော်ဟို ချီးမွန်းလျက် သူလို့နဲ့အတူ ဗိမာန်တော်ထဲဟို လိုက်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","အဲသူဟ ဘုရားသခင်ရဲ့ ဂုဏ်တော်ဟို ချီးမွန်းလျက် လမ်းဆှောက်တာဟို လူအပေါင်းလို့ဟ မျော်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","အဲသူဟ ဗိမာန်တော် တင့်တယ် ထင်ခါးနားတွင် ထိန်နေလေ့ဆိလဲ့ ကျောန်နန် ဖြစ်ကျောန်းဟို မှတ်မိကြသောအခါ သူလို့ဟ အဲသူတွင် ဖြစ်ပျက်လဲ့ အမှုအရာဟို ရမ်းဆာ့ အံ့ဩယွေ့ မိန်းမောတွေဝေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","အဲသူဟ ပေတရုနဲ့ ယောဟန်လို့ဟို တွယ်ကပ်လျက်နေစဉ် လူအပေါင်းလို့ဟ ရမ်းဆာ့အံ့ဩလျက် သူလို့ဆိရာ ရှောလမုန်ဟု ခေါ်သော မုခ်ဦးဟို ပြေးယွေ့ လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ပေတရုဟ လူများဟို မျော်သောအခါ သူဟ အဲသူလို့အား “ဣသရေလ အမျိုးသားလို့၊ ပစာကို့ အေးအရာဟို နင်လို့ အံ့ဩကြလုန်း၊ ပစာကျောန့် ငါလို့ဟို ကျေ့လုန်း၊ ငါလို့ရဲ့ တန်ခိုး အဲဟာမဟုတ်ရင် ငါလို့ရဲ့ ကိုယ်ကျင့်သီလအားဖြင့် ဟေသူဟို လမ်းဆှောက်စေနိန်တာလို့ ထင်မှတ်ကြသလော။ ");
INSERT INTO dnv_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","အာဗြဟံရဲ့ ဘုရား၊ ဣဇက်နဲ့ ယာကုပ်လို့ရဲ့ ဘုရား၊ ငါလို့ ဖိုးဖေးများရဲ့ ဘုရားဟ မိမိရဲ့ အစေခံ ယေရှုဟို ဘုန်းတော် ထင်ဆှားစေပီ။ အဲလိုလဲ နင်လို့ဟ အဲအဆှင်ဟို ရန်သူလက်ဟို အပ်လိုက်ယွေ့ အဲအဆှင်ဟို လွတ်ငြိမ်းချမ်းသာ ခွင့်ပေးရန် ဆုံးဖြတ်ထားသော ပိလတ်မင်း ဆေ့တွင် ငြင်းပယ်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","နင်လို့ဟ သန့်ဆှင်းယွေ့ ဖြောင့်မတ်သော အဆှင်ဟို ငြင်းပယ်ခဲ့ကြပင်း၊ နင်လို့ဟ လူသတ်သမားအား လွတ်ငြိမ်းချမ်းသာခွင့် ပေးရန် တောင်းခံကြကာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","အသက်ဆှင်ခြင်းဟို ပို့ဆောင်သော အဆှင်ဟိုမူ သတ်ဖြတ်ကြအယ်၊ အဲလိုလဲ ဘုရားသခင်ဟ အဲအဆှင်ဟို သေခြင်းမှ ဆှင်ပြန်ထမြောက်စေကျောန်းဟို အဲအရာဟ ငါလို့ရဲ့ သက်သေခံ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","အဲအဆှင်ရဲ့ နာမတော် တန်ခိုးအားဖြင့် ဟေခြေမသန်စွမ်းသူဟ သန်စွမ်းယွေ့ လာအယ်။ အဲအဆှင်ရဲ့ နာမတော်ဟို ယုံကြည်ခြင်းအားဖြင့် အခု နင်လို့မျော်ယွေ့ သိရကြလဲ့အမှုအရာဟ ဖြစ်ပွားခဲ့အယ်၊ နင်လို့အားလုံး မျော်လဲ့အတိုင်း ယေရှုဟို ယုံကြည်ခြင်းကသာ အဲသူအား ကျန်းမာလာစေခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“အဲလိုမို့ အခု ငါ့ မိတ်ဆွေလို့၊ နင်လို့ဟ မိမိလို့ ခေါင်းဆောင်များလိုမျိုး မိမိလို့ပြုသော အမှုဟို မသိသက်ဘဲ အေးလို့ ပြုကြကျောန်းဟို ငါ သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","အဲလိုလဲ မေဆှိယဟ ဆင်းရဲဒုက္ခခံရမယ်ဖြစ်ကျောန်း ပရောဖက်အပေါင်းအားဖြင့် မခင်ကတည်းဟ ဘုရားသခင် ကြိုပြောထားသော အေးအရာဟ သူ့အားဖြင့် ပြေ့စုံလာခြင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","အေးလိုမို့ ဘုရားသခင်ဟ နင်လို့ရဲ့ အပစ်များဟို ဖြေလွှတ်စေရန် နောင်တရယွေ့ ပြောင်းလဲကြလော့။ အဲလိုဖြစ်ခါမှသာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ထာဝရဘုရား ဆေမှ ဝိညာဉ်ခွန်အား သက်ရောက်ရာ အချိန်ကာလ ရောက်လာလျက် နင်လို့အဖို့ ရွေးချယ်ခန့်ထားသော မေဆှိယ အဆှင်တည်းဟူသော ယေရှုဟို စေလွှတ်လိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","မခင်ဟ မိမိရဲ့ သန့်ဆှင်းသော ပရောဖက်များရဲ့ စလောင်အားဖြင့် ဘုရားသခင် မိန့်ခဲ့လဲ့အရာတည်းဟူသော အလုံးစုံလို့ဟို မူလအတိုင်း ပြန်ဖြစ်စေမဲ့ ကာလများတိုင်အောန် ခေါန်းခင်ဟ အေးအဆှင်ဟို လက်ခံထားရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","အကျောန်းမှာ မောရှေဟ ‘နင်လို့ရဲ့ ဘုရားသခင် ထာဝရဘုရားဟ ငါ့ဟို စေလွှတ်လဲ့တိုင်းတိုင်း ပရောဖက်တပါးဟိုလည်း နင်လို့ဆေဟို စေလွှတ်ပင်း အဲသူဟ နင်လို့ အမျိုးသားထဲမှ ဖြစ်လိမ့်မယ်။ သူ ဟောပြောသမျှသောလို့ဟို နင်လို့ဟ နားထောင်ကြရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","အဲပရောဖက်ရဲ့ စကားဟို နားမထောင်ဘဲနေသော သူတိုင်းဟ ဘုရားသခင်ရဲ့ လူမျိုးထဲမှ ဖယ်ဆှားပင်း ဖျက်ဆီးခြင်းဟို ခံရမယ်’ ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ရှမွေလ အပါအဝင် သူ့နောက်မှ ပေါ်ထွန်းလာသော သတင်းစကားဟို ဟောပြောသော ပရောဖက်အပေါင်းလို့ဟ အခု နေ့ရက်ကာလအကျောန်းဟို ဟောပြော ကြေငြာခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","နင်လို့ဟ ပရောဖက်လို့ရဲ့ သားမြေးများဖြစ်ကြတာ သာမက ဘုရားသခင်ဟ အာဗြဟံအား ‘ကမ္ဘာပေါ်ဆိ လူမျိုးစုအပေါင်းလို့ဟ နင်ရဲ့ အမျိုးအနွယ်အားဖြင့် ကောင်းချီးမင်္ဂလာ ခံစားရလိမ့်မယ်’ ဟု မိန့်လျက် နင်လို့ရဲ့ ဖိုးဖေးများနဲ့ ပြုခဲ့သော ပဋိညာဉ်ရဲ့ သားမြေးများလည်း ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","နင်လို့ တဦးစီရဲ့ ဆိုးညစ်သောအမှုလို့ဟို စွန့်ပယ်ခြင်းအားဖြင့် ကောင်းချီးခံစားကြရစေရန် ဘုရားသခင်ဟ မိမိရဲ့ အစေခံဟို နင်လို့ဆေဟို ဦးစွာ စေလွှတ်အယ်” ဟု ပေတရုဟ ဟောပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ပေတရုနဲ့ ယောဟန်လို့ဟ လူလို့အား ဟောပြောလျက် နေကြစဉ် အချို့ ယဇ်ပုရောဟိတ်များ၊ ဗိမာန်တော် အစောင့်တာဝန်ခံ အရာဆိနဲ့ ဇဒ္ဒုကဲများဟ ရောက်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","တမန်တော်နေဦးလို့ဟ ယေရှု သေခြင်းမှ ဆှင်ပြန်ထမြောက်လဲ့အကျောန်းဟို လူလို့အား သင်ကြားနေသောကျောန့် သူလို့ဟ စိတ်အနှောင့်အယှက် ဖြစ်ကြအယ်၊ ကိုယ်တော်ရဲ့ သေခြင်းမှ ဆှင်ပြန်ထမြောက်ခြင်းဟို အကျောန်းပြုယွေ့ လူလို့အား သက်သေပြလျက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","အေးလိုမို့ သူလို့ဟ တမန်တော်လို့ဟို ဖမ်းဆီးပင်း မိုးချုပ်ပီ ဖြစ်သောကျောန့် နောက်တနေ့တိုင်အောန် ထောင်ထဲမှာ ထည့်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","အဲလိုလဲ သတင်းစကားဟို ကြားသောသူများဟ ယုံကြည်လဲ့သူ ယောက်ျားအရေအတွက်မှာ ၅,၀၀၀ ခန့်မျှ တိုးပွားလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","နောက်တနေ့တွင် ယုဒခေါင်းဆောင်များ၊ အကြီးအကဲများနဲ့ ကျမ်းတတ်ဆရာများဟ ယေရုရှလင်မြို့နှိုက် စုဝေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ယဇ်ပုရောဟိတ်မင်း အန္နတ်နဲ့ ကယာဖ၊ ယောဟန်၊ အာလေဇန္ဒြု မှစယွေ့ ယဇ်ပုရောဟိတ်မင်းရဲ့ မိသားစုဝင် ဆိသမျှလိုဟ တွေ့ဆုံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","အဲသူလို့ဟ မိမိလို့ဆေ့တွင် တမန်တော်နေပါးဟို ရပ်စေယွေ့ “နင်လို့ဟ စလို တန်ခိုး အဲဟာမဟုတ်ရင် စလို နာမအားဖြင့် ဟေအမှုဟို ပြုလုန်း” ဟု မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","အဲအခါ ပေတရုဟ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝလျက် “လူများဟို အစိုးရသော ခေါင်းဆောင်လို့နဲ့ အကြီးအကဲလို့၊ ");
INSERT INTO dnv_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ခြေမသန်စွမ်းသောသူ တယောက်ဟို ကောင်းကျိုးပြုလဲ့ အကျောန်း၊ သူကျန်းမာလာပုံ အကျောန်းနဲ့ ပတ်သက်ယွေ့ ခနေ့ ငါလို့ စစ်ဆေးခံရရင်၊ ");
INSERT INTO dnv_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","နာဇရက်မြို့သား ယေရှု ခရစ်ရဲ့ နာမတော် တန်ခိုးအားဖြင့် အဲသူဟ ခြေသန်စွမ်းလာယွေ့ နင်လို့ ဆေ့တွင် ရပ်လျက်နေတာဟို နင်လို့နဲ့အတူ ဣသရေလအမျိုးသားအပေါင်းလို့ သိမှတ်ကြလော့၊ အဲအဆှင်ဟ နင်လို့ လက်ဝါးကပ်တိုင်မှာ တင်ယွေ့ သတ်ပင်းနောက် ဘုရားသခင် ဆှင်ပြန်ထမြောက်စေသောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ကျမ်းစာဟ ရည်ညွှန်းသူမှာ အေးယေရှုပင် ဖြစ်အယ်၊ “ ‘တိုက်ဟို တည်ဆောက်ရာတွင် နင်လို့ ပယ်ထားလဲ့ ကျောက်ဟ၊ အရေးကြီးဆုံးဖြစ်လဲ့ ထောင့်ချုပ်ကျောက် ဖြစ်လာအယ်။’ ");
INSERT INTO dnv_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ကယ်တင်ခြင်းဟ အခြားစသူမှာမှ မဆိ၊ အကျောန်းမှာ အေးနာမမှတပါး ငါလို့အား ကယ်တင်မဲ့ အခြားသော နာမဟို ခေါန်းခင်အောက် လူလို့နှိုက် ပေးအပ်ထားခြင်း မဆိ” ဟု သူလို့အား ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ပေတရုနဲ့ ယောဟန်လို့ဟ ပညာမတတ်သူ၊ သာမန် လူများသာဖြစ်လျက်နဲ့ စလောက် ရဲရင့်ကြတာဟို တရားလွှတ်တော်အဖွဲ့ဝင်လို့ မျော်ကြသောအခါ ရမ်းဆာ့အံ့ဩကြအယ်။ အေးသူနေဦးလို့ဟ ယေရှုရဲ့ အပေါင်းအဖော်များ ဖြစ်ခဲ့ကြတာဟိုလည်း သတိပြုမိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","အဲလိုလဲ ရောဂါပျောက်ကင်းသွားသူဟ သူလို့နဲ့ ရပ်လျက်နေတာဟို မျော်သောကျောန့် သူလို့ဟ စလိုမျှ ငြင်းဆိုရန် မတတ်နိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","အေးလိုမို့ သူလို့ဟို တရားလွှတ်တော်ထဲမှ ခဏထွက်ခွာစေရန် ပြောပင်း သူလို့အချင်းချင်း စတင် ဆွေးနွေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","သူလို့ဟ “ဟေသူလို့အား ငါလို့ စလိုလုပ်လုန်း” ဟု မေးကြအယ်။ “သူလို့အားဖြင့် ထူးခြားသော နိမိတ်လက္ခဏာ ဖြစ်ပေါ်ခဲ့တာဟို ယေရုရှလင်မြို့သားအပေါင်းလို့ ကောင်းစွာ သိကြတာ ဖြစ်ယွေ့ ငါလို့ ငြင်းဆိုယွေ့ မရနိန်ပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","အဲလိုလဲ အဲအကျောန်းဟ လူလို့အထဲတွင် ပိုယွေ့ ပျံ့မသွားစေရန် ယေရှုရဲ့ နာမဟို အမှီပြုယွေ့ နောက်တခါ ဖယ်သူဟိုမှ မဟောပြောရန် ငါလို့ တင်းကျပ်စွာ သတိပေးကြစို့။” ");
INSERT INTO dnv_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","အဲပင်းရင် သူလို့ဟို ပြန်ခေါ်ယွေ့ ယေရှုရဲ့ နာမတော်ဟို အမှီပြုယွေ့ ဟောပြောခြင်း အဲဟာမဟုတ်ရင် သွန်သင်ခြင်း လုံးဝမလုပ်ရန် အမိန့်ပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","အဲလိုလဲ ပေတရုနဲ့ ယောဟန်လို့ဟ “ဘုရားသခင်ရဲ့ စကားဟို နားထောင်တာထက် နင်လို့ရဲ့ စကားဟို နားထောင်ခြင်းဟ ဘုရားသခင်ဆေ့မှာ မန်အယ် မမန်ဝူးဆိုတာဟို နင်လို့ ဆုံးဖြတ်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","အကျောန်းမှာ ငါလို့တတ်တိုင်း ကြားရမျော်ရလဲ့ အမှုအရာများအကျောန်းဟို မဟောပြောဘဲ မနေနိန်” ဟု အေးသူလို့အား ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","အဲလိုမို့ တရားလွှတ်တော် အဖွဲ့ဝင်လို့ဟ သူလို့ဟို ထပ်မံကျပ်တည်းစွာ သတိပေးပင်းနောက် ထွက်ခွာသွား စေကြအယ်။ လူအပေါင်းလို့ဟ ဖြစ်ပျက်ခဲ့လဲ့ အမှုအရာကျောန့် ဘုရားသခင်ရဲ့ ဘုန်းတော်ဟို ချီးမွန်းလျက် နေကြသောကျောန့် သူလို့ဟ တမန်တော်လို့ဟို အပြစ်ဒဏ်ပေးနိန်မဲ့ နည်းလမ်းဟို ဆှာမတွေ့ကြ။ ");
INSERT INTO dnv_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ဟေနိမိတ်လက္ခဏာအားဖြင့် အကောင်းပကတိဖြစ်လာသော သူဟ အသက်လေးဆယ်ကျော် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ပေတရုနဲ့ ယောဟန်လို့ဟ လွတ်မြောက်လာကြသောအခါ မိမိလို့ရဲ့ လူစုဆေဟို ပြန်ပင်း ယဇ်ပုရောဟိတ်ကြီးများနဲ့ အကြီးအကဲများ ပြောသမျှလို့ဟို ပြန်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","အဲအကျောန်းဟို သူလို့ ကြားကြသောအခါ၊ အဲသူလို့ဟ အတူတကွ ဘုရားသခင်ဆေမှာ အသံလွှင့်လျက် “အစိုးရသော အဆှင်၊ ကိုယ်တော်ဟ ခေါန်းခင်၊ မြေကြီး၊ သမုဒ္ဒရာမှစယွေ့ ဆိသမျှအရာအားလုံးဟို ဖန်ဆင်းသောအဆှင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ကိုယ်တော်ဟ မိမိရဲ့ အစေခံ၊ ငါလို့ရဲ့ ဖိုးဖေး ဒါဝိဒ်မင်းရဲ့ နှုတ်မှတဆင့် သန့်ဆှင်းသော ဝိညာဉ်တော်အားဖြင့်၊ “ ‘လူမျိုးတကာလို့ဟ ပစာကျောန့် ရုန်းရင်းဆန်ခတ် ပြုကြလုန်း။ လူလို့ဟ ပစာကျောန့် အကျိုးမဲ့ ကြံစည်ကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","မြေကြီးရဲ့ ဆှင်ဘုရင်လို့ဟ ထကြယွေ့၊ အုပ်ချုပ်သူလို့ဟ အတူတကွ စုဝေးကြကာ ထာဝရဘုရားနဲ့ ကိုယ်တော်ရဲ့ မေဆှိယဟို ဆန့်ကျင်ကြအယ်’ ဟု မိန့်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","အမန်ပင် ဟေရုဒ်မင်းနဲ့ ပုန္တိပိလတ်မင်းလို့ဟ လူမျိုးခြားလို့၊ ဣသရေလ အမျိုးသားလို့နဲ့ ပေါင်းဖော်ပင်း ကိုယ်တော် ဘိသိက်ပေးလဲ့ ကိုယ်တော်ရဲ့ သန့်ဆှင်းသော အစေခံ ယေရှုဟို ဆန့်ကျင်လျက် ဟေမြို့တွင် စုဝေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ကိုယ်တော်ရဲ့ တန်ခိုးတော်နဲ့ အလိုတော်လို့အားဖြင့် ဖြစ်ပျက်လာရန် ကြိုတင် သတ်မှတ် ထားသမျှသောအရာလို့ဟို ပြုခဲ့ကြပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ထာဝရဘုရား၊ အခု အေးသူလို့ရဲ့ ခြိမ်းခြောက်ခြင်းဟို ရှုမှတ်ပင်း ကိုယ်တော်ရဲ့ အစေခံလို့အား တရားတော်ဟို ရဲရင့်စွာ ဟောပြောနိန်ခွင့်ဟို ပေးသနားပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","တချိန်တည်းမှာပင် အနာရောဂါများဟို ငြိမ်းစေရန် ကိုယ်တော်ရဲ့ လက်တော်ဟို ဆန့်တန်းယွေ့ ကိုယ်တော်ရဲ့ သန့်ဆှင်းသော အစေခံ ယေရှု နာမအားဖြင့် နိမိတ်လက္ခဏာများနဲ့ အံ့ဩဖွယ်ရာများဟို ပြုခွင့်ပေးပါ” ဟု ဆုတောင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","သူလို့ ဆုတောင်းကြပင်းသောအခါ စုဝေးရာနေရာဟ တုန်လှုပ်အယ်။ သူလို့အားလုံးဟ သန့်ဆှင်းသော ဝိညာဉ်တော်ဖြင့် ပြေ့ဝလျက် ဘုရားသခင်ရဲ့ တရားတော်ဟို ရဲရင့်စွာ ဟောပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ယုံကြည်သောသူအားလုံးဟ စိတ်နေလုံး တညီတညွတ်တည်း ဖြစ်ကြသဖြင့် စသူမျှ မိမိရဲ့ ဥစ္စာပစ္စည်းများဟို မိမိပိုင်တာဟု မဆိုဘဲ၊ ဆိသမျှသောအရာလို့ဟို ဘုံစုအဖြစ် ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","တမန်တော်လို့ဟ သခင် ယေရှု ဆှင်ပြန်ထမြောက်ခြင်း အကျောန်းဟို ကြီးသောတန်ခိုးဖြင့် သက်သေခံကြအယ်။ ဘုရားသခင်ဟ သူလို့အားလုံးအပေါ်ဟို ကောင်းချီးမင်္ဂလာ ကြွယ်ဝစွာ သွန်းလောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","အဲသူလို့တွင် ဆင်းရဲသောသူ တယောက်မျှ မဆိ။ အကျောန်းမှာ နေအိုင် အဲဟာမဟုတ်ရင် မြေကွက်ဟို ပိုင်သောသူဆိသမျှလို့ဟ ရောင်းပင်း၊ ရသောအဖိုးဟို ယူခဲ့ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","တမန်တော်လို့ရဲ့ ခြေရင်းတွင် ထားကြသဖြင့် တဦးချင်းစီနှိုက် လိုအပ်မှုဆိလဲ့အတိုင်း အသီးသီးလို့အား ဝေငှပေးကမ်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ယောသပ်ဟု နာမယ်ဆိသော လူတယောက်ဆိအယ်၊ သူ့ဟို တမန်တော်လို့ဟ ဗာနဗ ဟု ခေါ်ကြအယ်၊ ဗာနဗရဲ့ အနက်ဟ “နှစ်သိမ့်ခြင်းရဲ့ သား” ဟု အဓိပ္ပာယ်ရအယ်။ သူဟ ကုပရုပြေသား၊ လေဝိအနွယ်ဝင် ဖြစ်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","မိမိပိုင်သောလယ်ဟို ရောင်းယွေ့ ပိတ်ဆန်ဟို ယူလာပင်း တမန်တော်လို့ရဲ့ လက်နှိုက် အပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","အဲလိုလဲ အာနနိ နာမယ်ဆိသောသူနဲ့ သူ့ပေါင်အိုမ ရှဖိရေဟ ဥစ္စာတစုံတခုဟို ရောင်းချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","သူ့ရဲ့ ပေါင်အိုမနဲ့ သဘောတူလျက် ပိတ်ဆန်ထဲမှ အချို့ဟို မိမိလို့အဖို့ ချန်ထားကာ ကျန်သော ပိတ်ဆန်ဟိုသာ ယူလာယွေ့ တမန်တော်လို့ရဲ့ လက်နှိုက် အပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ပေတရုဟ သူ့အား “အာနနိ၊ နင်ဟ လယ်ရောင်းရလဲ့ ပိတ်ဆန် အချို့တဝက်ဟို မိမိအဖို့ ဖယ်ထားခြင်းအားဖြင့် သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ဝါပင်း စာတန်အား ပစာကျောန့် နင့်ရဲ့ စိတ်နေလုံးဟို စိုးမိုးခွင့်ပေးလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","နင်ဟ အဲလယ်ဟို မရောင်းခင်ဟ ပိုင်ဆိုင်တာ မဟုတ်လော။ ရောင်းချပင်းသောအခါတွင်လည်း မြေအဖိုးငွေဟို ပိုင်တာ မဟုတ်လော။ ပစာမို့ နင်ဟ ဟေအမှုဟို ကြံစည်လုန်း။ နင်ဟ လူဟို ဝါတာ မဟုတ်ဘဲ ဘုရားသခင်ဟို ဝါလေပီ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","အဲစကားဟို ကြားတာနဲ့ တပြိုင်နက် အာနနိဟ လဲကျသေဆုံးလေအယ်၊ အဲအကျောန်းဟို ကြားကြသူအပေါင်းလို့ဟ ရမ်းဆာ့ ကြောက်အားကြီးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","အဲပင်းရင် လူငယ်များဟ လာယွေ့ ရုပ်အလောင်းဟို အဝတ်နဲ့ ပတ်ပင်းနောက် သယ်ထုတ်သွားပင်း သင်္ဂြိုဟ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","သုံးနာရီလောက် ကြာသောအခါ အာနနိရဲ့ ပေါင်အိုမဟ ဖြစ်ပျက်ခဲ့လဲ့ အကျောန်းအရာဟို မသိဘဲ ဝင်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ပေတရုဟ “ငါ့ဟို ပြောမန့်၊ နင်နဲ့ နင့်ဖိုးအိုဟ လယ်အဖိုး ဟေလောက်ဖြင့် ရောင်းသလော” ဟု မေးအယ်။ အဲမိန်းမဟ “မန်အယ်၊ ဟေမျှလောက်ဖြင့်ပင် ရောင်းပါအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ပေတရုဟ သူမအား “သခင်ဘုရားရဲ့ ဝိညာဉ်တော်ဟို သွေးတိုးစမ်းရန် ပစာကျောန့် နင်လို့ သဘောတူ ကြံစည်ကြလုန်း၊ နားထောင်လော့၊ နင့်ရဲ့ ဖိုးအိုဟို သင်္ဂြိုဟ်ခဲ့သူလို့ဟ ထင်ခါးနှိုက်ပင် ဆိနေကြပင်း သူလို့ဟ နင့်ဟိုလည်း သယ်သွားကြလိမ့်မယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ခုတုံးပင် အဲအမျိုးသမီးဟ ပေတရုရဲ့ ခြေရင်းတွင် လဲကျ သေဆုံးလေအယ်။ လူငယ်လို့ ဝင်လာယွေ့ အဲမိန်းမ သေဆုံးနေတာဟို တွေ့ရရင် အဲမိန်းမ အလောင်းဟို သယ်ထုတ်ကာ ဖိုးအိုဖြစ်သူရဲ့ အနီးတွင် သင်္ဂြိုဟ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","အသင်းတော် တခုလုံးနဲ့ အဲအဖြစ်အပျက်အကျောန်းဟို ကြားကြသူအပေါင်းဟ ရမ်းဆာ့ ကြောက်လန့်ကုန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","တမန်တော်လို့ဟလည်း လူများဆေ့တွင် ရမ်းဆာ့ အံ့ဩဖွယ်ရာ အမှုအရာများနဲ့ နိမိတ်လက္ခဏာများဟို ပြကြအယ်။ ယုံကြည်သူအပေါင်းလို့ဟ ရှောလမုန် မုခ်ဦးတွင် စုဝေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","အခြားသောသူလို့ဟ သူလို့နဲ့အတူ မပေါင်းရဲကြသော်လည်း လူလို့ဟ သူလို့ဟို ချီးမွန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","အဲလိုလဲ သခင်ဘုရားဟို ယုံကြည်သူ ယောက်ျားနဲ့ မိန်းမ အရေအတွက်ဟ ပိုယွေ့ များပြားလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","လူလို့ဟ လူနာများဟို လမ်းမပေါ်ဟို သယ်လာပင်း ခုတင်များနဲ့ အိပ်ယာများပေါ်တွင် ထားကြကာ ပေတရု လာသောအခါ သူ့ရဲ့အရိပ်ဟိုပင် အေးလူနာအချို့လို့အပေါ်ဟို ကျရောက်စေရန် ကြိုးစားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","အားပင်း ယေရုရှလင်မြို့ ပတ်ဝန်းကျင်ဆိ မြို့များမှ လူပရိသတ်လို့ဟ ဖျားနာသူများ အဲဟာမဟုတ်ရင် နတ်ဝင်ပူးနေသူများဟို ခေါ်လာကြယွေ့၊ အဲလူနာအပေါင်းလို့ဟ ရောဂါပျောက်ကင်း သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","အဲအခါ ယဇ်ပုရောဟိတ်မင်းနဲ့ သူရဲ့ နောက်လိုက်များဖြစ်သော ဒေသဆိုင်ရာ ဇဒ္ဒုကဲအဖွဲ့ဝင်များဟ တမန်တော်လို့ဟို ရမ်းဆာ့ မနာလိုစိတ် ဆိလာကြသဖြင့် သူလို့ဟို အရေးယူရန် ဆုံးဖြတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","သူလို့ဟ တမန်တော်လို့ဟို ဖမ်းဆီးပင်း ပြေသူ့ အကျဉ်းထောင်ထဲတွင် ထည့်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","အဲလိုလဲ ညခါတွင် သခင်ဘုရားရဲ့ ခေါန်းခင်တမန် တပါးဟ ထောင်ထင်ခါးများဟို ဖွင့်ယွေ့ တမန်တော်လို့ဟို အပြင်ဟို ခေါ်ထုတ်ပင်း သူလို့အား၊ ");
INSERT INTO dnv_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ဗိမာန်တော်ဟို သွားယွေ့ လူလို့အား အသက်ဆှင်ခြင်း အကျောန်းအလုံးစုံဟို ဟောပြောကြလော့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","တမန်တော်လို့ဟ နာခံယွေ့ အရုဏ်တက်ချိန်တွင် ဗိမာန်တော်ထဲဟို ဝင်ယွေ့ စတင် သွန်သင်အယ်။ ယဇ်ပုရောဟိတ်မင်းနဲ့ သူရဲ့ အပေါင်းအဖော်လို့ဟ တရားလွှတ်တော် အစည်းအဝေးဟို ပြုလုပ်ရန် ဣသရေလလူလို့တွင် အသက်ကြီးသူအပေါင်းလို့ဟို တရားရုံးတွင် စုဝေးစေအယ်။ အဲပင်းရင် တမန်တော်လို့ဟို ခေါ်ဆောင်ခဲ့ရန် အမိန့်ပေးယွေ့ အစောင့်တပ်သားများဟို အကျဉ်းထောင်ဟို စေလွှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","အဲလိုလဲ အရာဆိလို့ဟ ရောက်သောအခါ တမန်တော်လို့ဟို အကျဉ်းထောင်ထဲမှာ မတွေ့ရကြ၊ အေးလိုမို့ တရားလွှတ်တော် အဖွဲ့ဝင်လို့ဆေဟို ပြန်လာပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“အကျဉ်းထောင် ထင်ခါးများဟို သေချာစွာ ပိတ်လျက် အစောင့်လို့ဟလည်း ထင်ခါးပြင်တွင် ရပ်လျက်ဆိနေတာဟို ငါလို့ တွေ့အယ်၊ အဲလိုလဲ ငါလို့ ထင်ခါးဟို ဖွင့်လိုက်သောအခါ အထဲမှာ စသူဟိုမျှ မတွေ့ရ” ဟု သတင်းပို့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","အဲစကားဟိုကြားသောအခါ ဗိမာန်တော် အစောင့်တပ်မှူးနဲ့ ယဇ်ပုရောဟိတ်ကြီးလို့ဟ ဟေအမှုဟ စလို ဖြစ်လိမ့်မလုန်းဟု တမန်တော်လို့နဲ့ ပတ်သက်ယွေ့ တွေးတောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","အဲအခါ လူတယောက် ရောက်လာယွေ့ “ကျေ့မန့်၊ အကျဉ်းချထားခဲ့သော သူလို့ဟ ဗိမာန်တော်ထဲတွင် ရပ်လျက် လူလို့အား သွန်သင်နေအယ်” ဟု ဆှောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","အဲအခါ အရာဆိလို့ဟ အစောင့်တပ်သားလို့နဲ့အတူ သွားရောက်ယွေ့ တမန်တော်လို့ဟို ခေါ်ဆောင်လာကြအယ်။ အဲလိုမို့ မိမိလို့အား လူလို့ဟ ခဲနဲ့ပေါက်မယ်ဟို စိုးရိမ်သဖြင့် တမန်တော်လို့အား အနိန်အထက် မပြုကြ။ ");
INSERT INTO dnv_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","တမန်တော်လို့ဟို အထဲသို့ ခေါ်ဆောင်လာပင်း တရားလွှတ်တော်အဖွဲ့ရဲ့ ဆေ့တွင် ရပ်စေပင်း၊ ယဇ်ပုရောဟိတ်မင်းဟ တမန်တော်လို့ဟို မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","သူဟ “အဲနာမဟို အမှီပြုယွေ့ သွန်သင်ခြင်း မလုပ်ရန် နင်လို့အား ငါလို့ ကျပ်ကျပ်အမိန့် ပေးခဲ့အယ်၊ အဲလိုလဲ နင်လို့ ပစာလုပ်တာဟို ကျေ့လော့၊ နင်လို့ဟ ယေရုရှလင်မြို့ တမြို့လုံးတွင် သွန်သင်ချက်ဟို ပျံ့နှံ့စေယွေ့ အဲသူ သေရတာဟ ငါလို့ကျောန့် ဖြစ်အယ်ဟူယွေ့ နင်လို့ အပစ်တင်လိုကြတာ မဟုတ်လော” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ပေတရုနဲ့ တခြား တမန်တော်လို့ဟ “ငါလို့သည် လူအမိန့်ထက် ဘုရားသခင် အမိန့်တော်ဟို နားထောင်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ငါလို့ ဖိုးဖေးများရဲ့ ဘုရားသခင်ဟ နင်လို့ လက်ဝါးကပ်တိုင်ပေါ်မှာ တင်ယွေ့ သတ်ခဲ့သော ယေရှုအား သေခြင်းမှ ဆှင်ပြန်ထမြောက်စေပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ဣသရေလအမျိုးသားလို့ဟ နောင်တရယွေ့ မိမိလို့ အပစ်များမှ ဖြေလွှတ်စိမ့်သောငှါ ဘုရားသခင်ဟ အဲသခင်အား မိမိရဲ့လက်ယာတော်ဘက်တွင် စံပယ်စေယွေ့ ခေါင်းဆောင်အဖြစ်နဲ့ ကယ်တင်ဆှင်အဖြစ် ချီးမြှင့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ဟေအမှုအရာများနဲ့ ပတ်သက်ယွေ့ ငါလို့ဟ အသိသက်သေ ဖြစ်ကြအယ်။ ဘုရားသခင်ရဲ့ အမိန့်ဟို နာခံသူလို့အား ချပေးလဲ့ ဆုကျေးဇူးတည်းဟူသော သန့်ဆှင်းသော ဝိညာဉ်တော်ဟလည်း အသိသက်သေ ဖြစ်အယ်” ဟု ပြန်ယွေ့ ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","အဲစကားဟို ကြားသောအခါ လွှတ်တော်အဖွဲ့ဝင်လို့ဟ ပြင်းစွာ အူထော့ကြသဖြင့် တမန်တော်လို့အား သေဒဏ်ပေးချင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","အဲလိုလဲ လူအပေါင်းလို့ ရမ်းဆာ့ ရိုသေလေးစားခံရယွေ့ ကျမ်းတတ်ဆရာ တဦးဖြစ်သော ဂါမလျေလ နာမယ်ဆိသော ဖာရိရှဲဟ တရားလွှတ်တော်တွင် ထယွေ့ တမန်တော်လို့အား အပြင်ဟို ခဏခေါ်ထုတ်သွားရန် အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","အဲပင်းရင် သူဟ တရားလွှတ်တော်အား “ဣသရေလ အမျိုးသားလို့၊ ဟေသူလို့အား နင်လို့လုပ်မယ့်အရာဟို သတိထားကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","လွန်ခဲ့သော နှစ်အနည်းငယ်ဟ သုဒဆိုသူဟ ပေါ်လာယွေ့ မိမိတတ်တိုင်း အရေးပါသူ ဖြစ်အယ်ဟု ဆိုကာ၊ ၄၀၀ ခန့်ဆိသောသူဟ သူရဲ့ နောက်လိုက်ခဲ့အယ်။ အဲလိုလဲ သူ အသတ်ခံရပင်း သူ့နောက်လိုက်သောသူ အားလုံးလို့ဟ ကွဲပြားဖြစ်လျက် စလိုမှအရာ မထင်ခဲ့ချေ။ ");
INSERT INTO dnv_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","အဲပင်းရင် သန်းခေါင်စာရင်း ကောက်ချိန်တွင် ဂါလိလဲပြေသား ယုဒဆိုသူ ပေါ်ပေါက်လာကာ မိမိနောက်ဟို လိုက်ကြရန် လူလို့ဟို ဆွဲဆောင်စည်းရုံးခဲ့ပင်း၊ အဲလိုလဲ သူဟလည်း အသတ်ခံရယွေ့၊ သူရဲ့ နောက်လိုက်သောသူ အားလုံးဟ ကွဲလွင့်သွားကြကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","အေးလိုမို့ အဲကိစ္စမှာ အခု နင်လို့အား ငါပြောတာဟ ဟေသူလို့ဟို အရေးမယူကြနဲ့။ သူလို့တတ်တိုင်း ဆိနေပါစေ၊ သူလို့ အကြံအစည်နဲ့ ဟေလှုပ်ဆှားမှုဟ လူလို့ဆေမှဖြစ်ရင် ပျက်စီးသွားလိမ့်မယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","အဲလိုလဲ ဘုရားသခင်ဆေမှ ဖြစ်ရင် အဲသူလို့ မတားဆီးနိန်လဲ့အပြင် နင်လို့ဟ ဘုရားသခင်ဟို ဆန့်ကျင်သူများ ဖြစ်သွားနိန်အယ်” ဟု ဆိုအယ်။ တရားလွှတ်တော် အဖွဲ့ဝင်လို့ဟ ဂါမလျေလရဲ့ အကြံပေးချက်ဟို လက်ခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","သူလို့ဟ တမန်တော်လို့ဟို ခေါ်လျက် သူလို့အား ကြိမ်ဒဏ်ခတ်ကာ “ယေရှုရဲ့ နာမဟို အမှီပြုယွေ့ သွန်သင်ခြင်းဟို နောက်တခါ မပြုရ” ဟု အမိန့်ပေးပင်းနောက် လွှတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","တမန်တော်လို့ဟ ယေရှုရဲ့ နာမတော်ကျောန့် အဆှက်ကွဲခြင်းဟို ခံထိုက်သူများအဖြစ်ဖြင့် ဘုရားသခင် မှတ်သောကျောန့် ဝမ်းမြောက်စွာ တရားလွှတ်တော်မှ ထွက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","အားပင်း နေ့စဉ်နေ့တိုင်း ဗိမာန်တော်တွင် လည်းကောင်း၊ လူလို့ရဲ့ နေအိုင်များတွင် လည်းကောင်း ယေရှုဟ မေဆှိယ ဖြစ်အယ်ဟူသော သတင်းကောင်းအကျောန်းဟို ဟောပင်း ဆက်လက်ယွေ့ သွန်သင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","အေးနေ့ရက်များနှိုက် တဘဲ့တော်များ တိုးပွားလာသောအခါ၊ ဟေလသစကားဟို ပြောသော ယုဒလူလို့ဟ မိမိလို့ထဲမှ မုဆိုးမများဟ နေ့စဉ် ထောက်ပံ့ခြင်းအမှုတွင် လျစ်လျူရှုခံရအယ်ဟု ဟေဗြဲစကားဟို ပြောသော ယုဒလူလို့ဟို အပစ်တင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","အဲလိုမို့ တဆယ့်နေပါးသော တမန်တော်လို့ဟ တဘဲ့တော်အပေါင်းလို့ဟို ခေါ်ယွေ့ “ငါလို့ဟ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော် ဟောပြောမှုဟို လျစ်လျူရှုပင်း ငွေရေးကြေးရေး စီမံဆောင်ရွက်ရန် မသင့်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","အဲလိုမို့ ငါ့ မိတ်ဆွေလို့၊ နင်လို့အထဲမှ ဝိညာဉ်တော်နဲ့ လည်းကောင်း၊ ဉာဏ်ပညာနဲ့ ပြေ့ဝယွေ့ ဂုဏ်သတင်းကောင်းသော လူခုနေဦးဟို ရွေးချယ်ကြလော့။ ငါလို့ဟ အေးသူလို့ဟို ဟေတာဝန်အတွက် ခန့်ထားမယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ငါလို့တတ်တိုင်းဟ ဆုတောင်းခြင်းနဲ့ နှုတ်ကပတ်တော် ဟောပြောခြင်း အလုပ်အားဖြင့်သာ အချိန်ဟို ကုန်လွန်စေကြမယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ဟေအကြံဟို တဘဲ့တော် တဖွဲ့လုံးဟ နှစ်သက်ကြအယ်။ သူလို့ဟ ယုံကြည်ခြင်း အားကြီးယွေ့ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝသူ သတေဖန် မှစယွေ့ ဖိလိပ္ပု၊ ပြောခေါ်၊ နိကနော်၊ တိမုန်၊ ပါမေနနဲ့ ယုဒဘာသာသို့ ကူးပြောင်းလာသူ အန္တိအုတ်မြို့သား နိကောလလို့ဟိုလည်း ရွေးချယ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","အဲသူလို့အား တမန်တော်လို့ ဆေ့မှာ ရပ်စေကြပင်း၊ တမန်တော်လို့ဟ ဆုတောင်းယွေ့ အဲသူလို့ရဲ့ ခေါင်းပေါ်မှာ မိမိလို့ရဲ့လက်ဟို တင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","အဲလိုမို့ ဘုရားသခင်ရဲ့ နှုတ်ကပတ် တရားတော်ဟ ဆက်လက်ပင်း ပျံ့နှံ့သွားအယ်။ ယေရုရှလင်မြို့တွင် တဘဲ့တော်လို့ရဲ့ အရေအတွက်ဟ ရမ်းဆာ့ တိုးပွားပင်း၊ ယဇ်ပုရောဟိတ် အမြောက်အများပင် ယုံကြည်ခြင်းတရားဟို လက်ခံလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","သတေဖန်ဟ ဘုရားသခင်ရဲ့ ကောင်းချီးမင်္ဂလာဟို ကြွယ်ဝစွာ ခံစားရသူ၊ တန်ခိုးတော်နဲ့ ပြေ့ဝသူဖြစ်သဖြင့် အံ့ဩဖွယ်ရာအမှုများနဲ့ နိမိတ်လက္ခဏာများဟို လူလို့ဆေ့တွင် ပြုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","အဲပင်းရင် လွတ်လပ်သောသူများ လို့ခေါ်လဲ့ တရားဇရပ်မှ လူအချို့လို့ဖြစ်ကြသော ကုရေနေမြို့သားနဲ့ အာလေဇန္ဒြူယမြို့သားမှ စယွေ့ ကိလိကိပြေနဲ့ အာရှပြေမှ လာသောသူလို့ဟ ထယွေ့ သတေဖန်နဲ့ စတင် ငြင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","အဲလိုလဲ သတေဖန်ဟ ဝိညာဉ်တော်ပေးလဲ့ အသိပညာနဲ့ ပြောဆိုသဖြင့် အဲသူလို့ဟ ချေပနိန်စွမ်း မဆိကြ။ ");
INSERT INTO dnv_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","အေးလိုမို့ သူလို့ဟ လူလို့အား သွေးထိုးပေးယွေ့ “ဟေသူဟ မောရှေနဲ့ ဘုရားသခင်အား ပစ်မား ပြောဆိုတာဟို ငါလို့ ကြားအယ်” ဟု ပြောခိုင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ဟေနည်းအားဖြင့် သူလို့ဟ လူများ၊ ကျမ်းတတ်ဆရာများနဲ့ အကြီးအကဲများအား လှုံ့ဆော်ကြအယ်။ သူလို့ဟ သတေဖန်ဟို ဝင်ရောက် ဖမ်းဆီးယွေ့ သူ့ဟို တရားလွှတ်တော်ဆေ့ ခေါ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","အဲပင်းရင် သူလို့ဟ မမန်လဲ့ သက်သေများဟို ခေါ်ခဲ့ယွေ့ အဲသက်သေများဟ “ဟေသူဟ သန့်ဆှင်းသော အရပ်နဲ့ ပညတ်တရားတော်ဟို ဆန့်ကျင်ယွေ့ အမြဲတမ်း ပြောဆိုလျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","နာဇရက်မြို့သား ယေရှုဟ ဗိမာန်တော်ဟို ဖျက်ဆီးယွေ့ ငါလို့အား မောရှေ ပေးအပ်ခဲ့လဲ့ ထုံးတမ်းစဉ်လာများဟို ပြောင်းလဲစေလိမ့်မယ် ဖြစ်ကျောန်း အဲသူပြောဆိုတာဟို ငါလို့ ကြားရအယ်” ဟု ထွက်ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","တရားလွှတ်တော်တွင် ထိန်လျက်နေကြသော သူအပေါင်းလို့ဟ သတေဖန်ဟို အာရုံစိုက်ယွေ့ ကျေ့သောအခါ သူ့ရဲ့ မျက်နှာဟ ခေါန်းခင်တမန် မျက်နှာနဲ့တူတာဟို တွေ့မျော်ရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ယဇ်ပုရောဟိတ်မင်းဟ သတေဖန်ဟို “အဲဟာ မန်ပါသလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","သတေဖန်ဟ၊ “ညီအကိုလို့နဲ့ အဖလို့ ငါ့စကားဟို နားထောင်ကြလော့၊ ငါလို့အဖ အာဗြဟံဟ ခါရန်မြို့နှိုက် မနေခင်၊ မေသောပေါတာမိပြေတွင် ဆိခါ၊ ဘုရားသခင်ရဲ့ ဘုန်းတော်ဟ သူ့ဆေမှာ ပေါ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ဘုရားသခင်ဟ ‘နင့်ရဲ့ ပြေနဲ့ နင့်ရဲ့ လူများလို့ဆေမှ ထွက်ယွေ့ ငါပြမဲ့ ပြေဟို သွားလော့’ ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","အဲအခါ သူဟ ခါလဒဲပြေမှ ထွက်ယွေ့ ခါရန်မြို့ဟို သွားရောက် နေထိန်အယ်။ သူရဲ့အဖ သေပင်းနောက်၊ ဘုရားသခင်ဟ အခု နင်လို့နေသော ဟေပြေဟို အဲမြို့မှ ပြောင်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","အဲလိုလဲ ဟေပြေနှိုက် ခြေချစရာနေရာဟိုမှ အမွေအဖြစ် မပေးဘဲ သူတတ်တိုင်းနဲ့ သူ့ရဲ့ အမျိုးအနွယ်လို့အား ဟေပြေဟို အပိုင်ပေးမယ်ဟု အာဗြံဟံနှိုက် လူပဲ့သငယ်တယောက်မှ မဆိခင် သူ့အား ကတိပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ဘုရားသခင်ဟ အေးနည်းလမ်းအားဖြင့် သူ့ဟို ပြောတာဟ ‘နင့်ရဲ့ အမျိုးအနွယ်ဟ သူတပါးပိုင်သော ပြေနှိုက် တစိမ်း ဖြစ်ကြသဖြင့်၊ သူလို့ဟ ကျွန်ခံခြင်းနဲ့ နှိပ်စက်ညှဉ်းဆဲခြင်းဟို အနှစ် ၄၀၀ ပတ်လုံး ခံရကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","အဲလိုလဲ သူလို့ဟို အစေခံသော လူမျိုးဟိုလည်း ငါ စီရင်မယ်၊ အဲပင်းရင်မှ သူလို့ဟ အေးပြေမှ ထွက်ယွေ့ ဟေအရပ်တွင် ငါ့အား ဝတ်ပြုကြလိမ့်မယ်’ ဘုရားသခင် မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","အဲပင်းရင် ဘုရားသခင်ဟ ပဋိညာဉ်ရဲ့ အမှတ်လက္ခဏာတရပ် အနေဖြင့် အရေဖျားလှီးခြင်းမင်္ဂလာဟို အာဗြဟံအား အပ်ပေးအယ်။ အဲလို မို့ အာဗြဟံဟ ဣဇက်ဟို ရပင်းနောက် ဆစ်ရက်မြောက်သောနေ့တွင် သူ့အား အရေဖျားလှီးမင်္ဂလာဟို ပေးအယ်။ ဣဇက်သား ယာကုပ်၊ ယာကုပ်သားများမှာ တဆယ့်နေပါးသော မျိုးနွယ်ဖြစ်ပင်း၊ ငါလို့ရဲ့ ကျော်ကြားလဲ့ ဖိုးဖေးများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ယာကုပ်ရဲ့ သားလို့ဟ မိမိလို့ ညီယောသပ်အား မနာလိုသဖြင့် အဲဂုတ္တုပြေဟို ကျွန်အဖြစ် ရောင်းလိုက်ကြအယ်။ အဲလိုလဲ ဘုရားသခင်ဟ သူနဲ့အတူ ဆိယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","သူ့အား ဒုက္ခဆင်းရဲအပေါင်းမှ ကယ်နုတ်အယ်။ ဘုရားသခင်ဟ ယောသပ်အား ဉာဏ်ပညာဟို ပေးလျက် အဲဂုတ္တု ဖာရောဘုရင်ရဲ့ ဆေ့တော်တွင် မျက်နှာရစေအယ်။ ဘုရင်ဟ သူ့ဟို အဲဂုတ္တုဘုရင်ခံ အဖြစ်ဖြင့်လည်းကောင်း၊ နန်းတော်အုပ်အရာဖြင့် လည်းကောင်း ခန့်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","အဲပင်းရင် အဲဂုတ္တုပြေနဲ့ ခါနာန်ပြေလို့တွင် အစာငတ်မွတ် ခေါင်းပါးခြင်းဘေး ဆိုက်ရောက်သဖြင့် ကြီးသော ဆင်းရဲဒုက္ခ ရောက်ကုန်ကြအယ်။ ငါလို့ ဖိုးဖေးလို့မှာ အစာယေစာ မဆိကြတော့ချေ။ ");
INSERT INTO dnv_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","အဲလိုလဲ အဲဂုတ္တုပြေတွင် အစားအစာများ ဆိကျောန်း ယာကုပ် ကြားသောအခါ ငါလို့ရဲ့ ဖိုးဖေးများဟို ပထမအကြိမ် စေလွှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ဒုတိယအကြိမ်တွင် ယောသပ်ဟ သူရဲ့ ညီအကိုလို့အား မိမိအကျောန်းဟို ဖော်ပြသဖြင့် ယောသပ်ရဲ့ မိသားစုဟို ဖာရောဘုရင် သိဆိလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","အဲအခါ ယောသပ်ဟ သူ့ရဲ့ အဖ ယာကုပ်နဲ့တကွ စုစုပေါင်း ခုနေဆယ့်ငါးယောက်သော ဆွေမျိုးသားချင်းလို့ဟို အဲဂုတ္တုပြေသို့ ခေါ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","အဲပင်းရင် ယာကုပ်ဟ အဲဂုတ္တုပြေဟို သွားယွေ့ အဲပြေတွင် သူနဲ့ သူရဲ့သားများ သေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","သူလို့ရဲ့ အလောင်းများဟို ရှေခင်မြို့ဟို သယ်ဆောင်ပင်း အဲမြို့နေ ဟာမော်ရဲ့ သားများဆေမှ တန်ဖိုးငွေ ပေးယွေ့ အာဗြဟံ ဝယ်ယူထားခဲ့လဲ့ လုတ်တိုင်းတွင် သင်္ဂြိုဟ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ဘုရားသခင်ဟ အာဗြဟံအား ထားသော သူ့ရဲ့ ကတိတော်ဟို ပြေ့စုံစေရန် အချိန်နီးကပ်လာသောအခါ အဲဂုတ္တုပြေတွင် လူဦးရေ ရမ်းဆာ့ တိုးပွားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","နောက်ဆုံးမှာ အဲဂုတ္တုပြေတွင် ယောသပ်ဟို မသိသော ဘုရင်တပါး စတင် အုပ်ချုပ်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","အဲဘုရင်ဟ ငါလို့ ဖိုးဖေးလို့ဟို လိမ်စားယွေ့ သူလို့အား နှိပ်စက်ညှဉ်းဆဲကာ၊ သူလို့ရဲ့ အောင်ငဲငယ်များအား သေစေရန် နေအိုင်ပြင်တွင် လောထားစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","အဲချိန်ကာလမှာ မောရှေ မွေးလာခဲ့ပင်း၊ သူဟ ဘုရားသခင်ရဲ့ ဆေ့တော်နှိုက် ရမ်းဆာ့လှသော အောင်ငဲငယ် ဖြစ်အယ်။ သုံးလတိန်တိန် သူ့အဖရဲ့ နေအိုင်တွင် ပြုစုစောင့်ဆှောက်ခြင်းဟို ခံခဲ့ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","အားပင်း သူဟ နေအိုင်ပြင်တွင် လောထားခြင်း ခံရသောအခါ ဖာရောဘုရင်ရဲ့ သမီးတော်ဟ သူ့အား ကောက်ယူပင်း မိမိသားအဖြစ် မွေးစားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","မောရှေဟ အဲဂုတ္တုအမျိုးသားလို့ရဲ့ အတတ်ပညာအားလုံးဟို သင်ယူယွေ့ နေလုံးရည် လက်ရုံရည်လို့ဖြင့် ပြေ့စုံသူ ဖြစ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“သူဟ အသက်လေးဆယ် ဆိသောအခါ မိမိရဲ့ အမျိုးသားချင်းဖြစ်လဲ့ ဣသရေလအမျိုးသားလို့ ဆေဟို သွားရောက်လည်ပတ်ရန် စိတ်ပိုင်းဖြတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","အားပင်း လူတဦးဟ မတရားသဖြင့် ပြုခြင်းခံနေရတာဟို အေးသူဟ ကူညီလျက် အဲဂုတ္တုအမျိုးသားဟို ရိုက်သတ်ကာ နှိပ်စက်ခံရသူအတွက် ခလဲ့စားချေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","မောရှေဟ သူ့အားဖြင့် သူ့ရဲ့ လူလို့အား လွတ်မြောက်ခြင်းဟို ဘုရားသခင် ပေးမယ်ဖြစ်ကျောန်း သူလို့ နားလည်ကြလိမ့်မယ်ဟု ထင်ခဲ့သော်လည်း သူလို့ဟ နားမလည်ခဲ့ကြပေ။ ");
INSERT INTO dnv_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","နောက်တနေ့တွင် ဣသရေလ အမျိုးသားနေယောက် ရန်ဖြစ်လျက်နေတာဟို မျော်ရင် မောရှေဟ ‘လူလို့၊ နားထောင်ကြလော့၊ နင်လို့ဟ ညီအကိုချင်း ဖြစ်ပါလျက်နဲ့ ပစာကျောန့် ဟေလို့ အချင်းချင်း မတရားပြုနေကြလုန်း’ ဟု ဆိုယွေ့ ငြိမ်သက်အောန် သူလို့ကြားမှာ ဖျန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","အဲလိုလဲ မတရားသဖြင့် ပြုသူဟ မောရှေအား ဘေးဟို တွန်းဖယ်လိုက်ပင်း ‘ငါလို့အား တရားစီရင် အုပ်ချုပ်သူအဖြစ်ဖြင့် နင့်ဟို စသူ ခန့်ထားလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ယမန်နေ့ဟ အဲဂုတ္တုအမျိုးသားဟို သတ်သလိုမျိုး ငါ့ဟိုလည်း သတ်လိုသလော’ ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","မောရှေဟ အေးစကားဟို ကြားသောအခါ အဲဂုတ္တုပြေမှ ထွက်ပြေးယွေ့ မိဒျန်ပြေတွင် နေထိန်လေအယ်။ သူဟ အဲပြေတွင် အောင်နီငယ် နေယောက်ဟို ရခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“အနှစ်လေးဆယ် ကြာပင်းနောက် သိနာတောင်အနီး တောကန္တာရတွင် မီးလောင်သော ချုံပုတ်နှိုက် ခေါန်းခင်တမန်ဟ မောရှေဆေ ထင်ဆှားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","အဲအရာဟို မျော်သောအခါ၊ မောရှေဟ ရမ်းဆာ့ အံ့ဩသဖြင့် ၎င်းဟို ကျေ့ရန် အနီးဟို တိုးလိုက်ရာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ငါဟ နင့်ဖိုးဖေးလို့ရဲ့ ဘုရား၊ အာဗြဟံ၊ ဣဇက်၊ ယာကုပ်လို့ရဲ့ ဘုရား ဖြစ်အယ်’ ဟု ထာဝရဘုရားရဲ့ အသံတော်ဟို ကြားရအယ်။ မောရှေဟ တုန်လှုပ်လျက် မကျေ့ရဲဘဲ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ထာဝရဘုရားဟ သူ့အား ‘နင်ခြေနင်းရာ အရပ်ဟ သန့်ဆှင်းသော မြေ ဖြစ်ယွေ့ နင့်ရဲ့ ဖိနပ်ဟို ချွတ်လော့။ ");
INSERT INTO dnv_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ငါဟ အဲဂုတ္တုပြေနှိုက် ဆိသော ငါရဲ့ လူစုတော် နှိပ်စက်ညှဉ်းဆဲခြင်း ခံရကြတာဟို ငါ မျော်ရပီ။ သူလို့ရဲ့ ညည်းတွားသံဟိုလည်း ငါ ကြားရပီ ဖြစ်ယွေ့ သူလို့အား ကယ်နုတ်ရန် ငါ ဆင်းလာခဲ့ပီ။ အခု လာလော့၊ နင့်ဟို အဲဂုတ္တုပြေသို့ ငါ စေလွှတ်မယ်’ ဟု မိန့်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“မောရှေဟ ဣသရေလ အမျိုးသားလို့ရဲ့ ပစ်ပယ်ခြင်းဟို ခံရသူဖြစ်အယ်။ သူလို့ဟ ‘ငါလို့ဟို တရားစီရင် အုပ်ချုပ်သူအဖြစ် နင့်အား စသူ ခန့်ထားလုန်း’ ဟု မေးကြအယ်။ သူဟ လူလို့ဟို အုပ်ချုပ်ရန်နဲ့ မီးလောင်သော ချုံတွင် ထင်ဆှားသော ခေါန်းခင်တမန် တပါးရဲ့ အကူအညီဖြင့် သူလို့ လွတ်မြောက်ရေး ဆောင်ရွက်ရန် ဘုရားသခင် စေလွှတ်သောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","သူဟ အဲဂုတ္တုပြေနဲ့ ပင်လယ်နီတွင် လည်းကောင်း၊ အနှစ်လေးဆယ်ပတ်လုံး တောကန္တာရနှိုက် လည်းကောင်း အံ့ဩဖွယ်ရာ နိမိတ်လက္ခဏာများဟို ပြလျက် ဣသရေလအမျိုးသားလို့ဟို အဲဂုတ္တုပြေမှ ထုတ်ဆောင်လာသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‘နင့်လူလို့ အထဲတွင် ငါ့လိုမျိုး ပရောဖက်တပါးဟို ဘုရားသခင်ဟ နင်လို့အတွက် ပေါ်ထွန်းစေလိမ့်မယ်’ ဟု ဣသရေလ အမျိုးသားလို့အား ပြောကြားခဲ့သူမှာ မောရှေပင် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","သူဟ သိနာတောင်နှိုက် သူ့အား စကားပြောခဲ့သော ခေါန်းခင်တမန်မှ စယွေ့ ငါလို့နဲ့ ဖိုးဖေးများနဲ့အတူ တောကန္တာရတွင် ဆိသော လူအစုအဝေးထဲနှိုက် ဆိလျက် ငါလို့အား ပေးအပ်ရန် အသက်ဆှင်သော နှုတ်ကပတ်တရားဟို လက်ခံရဆိခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“အဲလိုလဲ ငါလို့ ဖိုးဖေးများဟ သူရဲ့စကားဟို နားထောင်လိုသောဆန္ဒ မဆိကြ။ အဲအစား၊ သူ့အား ငြင်းပယ်ခြင်းနဲ့ သူလို့ရဲ့ စိတ်နေလုံးဟ အဲဂုတ္တုပြေဟို လှည့်ပြန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","သူလို့ဟ ‘ငါလို့ အဆေ့ဟ သွားမယ့် ဘုရားများဟို ငါလို့အတွက် ပြုလုပ်ပေးပါ။ ငါလို့အား အဲဂုတ္တုပြေမှ ထုတ်ဆောင်လာသော ဟေမောရှေဆိုသူဟ စလို ဖြစ်နေတာဟို ငါလို့ မသိပါ’ ဟု အာရုန်အား ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","အားပင်း သူလို့ဟ အဲနေ့ရက်များနှိုက် နွားသငယ် ရုပ်တုဟို သွန်းလုပ်ယွေ့ အဲရုပ်တုဆေသို့ ယဇ်ဟို ယူဆောင်လာကာ မိမိလို့ လက်နဲ့လုပ်သော ရုပ်တုနှိုက် ပျော်မွေ့နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","အေးလိုမို့ ဘုရားသခင်ဟ သူလို့ဆေမှ မျက်နှာလွှဲယွေ့ ခေါန်းခင်ရဲ့ ကြယ်များဟို ကိုးကွယ်ကြစေရန် သူလို့ဟို လောထားအယ်။ ပရောဖက် ပအုပ်များတွင် ဖော်ပြတာဟ “အို ဣသရေလ လူမျိုးလို့၊ နင်လို့ဟ တောကန္တာရတွင်၊ အနှစ်လေးဆယ်ပတ်လုံးလုံး၊ ယဇ်ပူဇော်ရန် တိရစ္ဆာန်များနဲ့ ယဇ်များဟို ငါ့ဆေဟို ယူဆောင်လာခဲ့ဖူးသလော။ ");
INSERT INTO dnv_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","နင်လို့ သယ်ဆောင်လာလဲ့ အရာများမှာ မောလုတ်ရဲ့ တဲနဲ့၊ နင်လို့ ဘုရား ရင်ဖန်ရဲ့ ကြယ် ဖြစ်အယ်။ အဲအရာလို့ဟ နင်လို့ ဝတ်ပြု ကိုးကွယ်ရန် သွန်းလုပ်လဲ့ ရုပ်တုများ ဖြစ်ကြအယ်။ အေးလို့မို့ နင်လို့အား ဗာဗုလုန်မြို့ဟို ကျော်လွန်အောန် ငါ ခေါ်ဆောင်သွားလိမ့်မယ်” ");
INSERT INTO dnv_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ငါလို့ရဲ့ ဖိုးဖေးများအတွက် တောကန္တာရတွင် သက်သေခံ တဲတော် ဆိအယ်။ ၎င်းဟ မောရှေအား သူမျော်ရလဲ့ပုံစံနဲ့ အညီပြုလုပ်ရန် မြွတ်ဆိုသော အဆှင်ဟ မှာကြားလဲ့အတိုင်း ပြုလုပ်ထားသော တဲတော် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ငါလို့ဖိုးဖေးများဟ အေးတဲတော်ဟို ဆက်ခံပင်းနောက် သူလို့ဆေ့မှ ဘုရားသခင် မောင်းထုတ်သော လူမျိုးလို့ရဲ့ ပြေဟို ယောရှုနဲ့အတူ ချီတက် သိမ်းပိုက်ကြသောအခါ အေးတဲတော်ဟို သယ်ဆောင်သွားကြအယ်။ အေးတဲတော်ဟ ဒါဝိဒ်မင်း လက်ထက်တိုင်အောန် ဆိနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","သူဟ ဘုရားသခင်ရဲ့ ဆေ့တော်တွင် မျက်နှာရယွေ့ ယာကုပ်ရဲ့ ဘုရား ကျိန်းဝပ်ရာ ဗိမာန်တော်ဟို တည်ဆောက်ခွင့်ပြုရန် တောင်းဆှောက်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","အဲလိုလဲ ဘုရားသခင်ရဲ့ ဗိမာန်တော်ဟို တည်ဆောက်ခွင့်ရသူမှာ ရှောလမုန်မင်းကြီး ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“အဲလိုလဲ အမြင့်ဆုံးသော ဘုရားဟ လူတည်ဆောက်သော နေအိုင်များတွင် ကျိန်းဝပ်တော်မမူ ဟု ပရောဖက် ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“ ‘ခေါန်းခင်ဘုံဟ ငါရဲ့ ပလ္လင် ဖြစ်အယ်၊ မြေကြီးဟ ငါရဲ့ ခြေတင်ရာခုံ ဖြစ်အယ်။ နင်ဟ စလိုအိုင်ဟို ငါ့အတွက် တည်ဆောက်မလုန်း။ ထာဝရဘုရား မိန့်တာဟ အဲဟာမဟုတ်ရင် ငါကျိန်းဝပ်ရာ အရပ်ဟ စနားမှာလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ငါတတ်တိုင်းပင် ဟေအရာခပ်သိမ်းဟို ဖန်ဆင်းတာ မဟုတ်လော’ ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“နင်လို့ဟ စလောက် ခေါင်းမာကြလုန်း” ဟု သတေဖန်ဟ ဆက်ပြောအယ်။ “နင်လို့ဟ ဘုရားသခင်ရဲ့ တရားစကားဟို နားထောင်ရန် နင်လို့ စိတ်နေလုံးလို့ စလောက် ခိုင်မာကြလုန်း၊ နင်လို့ဟ မိမိလို့ ဖိုးဖေးများလိုမျိုး သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို အမြဲတမ်း ဆန့်ကျင်ဖက်ပြု ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","နင်လို့ ဖိုးဖေးများ မနှိပ်စက်မညှဉ်းဆဲဖူးလဲ့ ပရောဖက်တပါးပါး ဆိသလော။ သူလို့ဟ ဖြောင့်မတ်သောသူ ကြွလာမဲ့အကျောန်းဟို ကြိုတင်ဟောကြားကြလဲ့ သူများဟိုပင် သတ်ခဲ့ကြအယ်။ အခု နင်လို့ဟ အဲအဆှင်ဟို သစ္စာဖောက်ယွေ့ သတ်ဖြတ်ကြပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","နင်ဟ ခေါန်းခင်တမန်များမှ တဆင့် ပေးအပ်လဲ့ ပညတ်တော်ဟို ရဆိသော်လည်း အေးပညတ်တော်ဟို မလိုက်နာကြ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ယုဒ တရားလွှတ်တော် အဖွဲ့ဝင်လို့ဟ အေးစကားဟို ကြားသောအခါ သူ့အပေါ် အူထော့ယွေ့ အံသွားကြိတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","အဲလိုလဲ သတေဖန်ဟ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝလျက် ခေါန်းခင်ဟို ကျေ့လေရာ၊ ဘုရားသခင်ရဲ့ ဘုန်းအသရေတော်ဟို လည်းကောင်း၊ ဘုရားသခင်ရဲ့ လက်ယာတော်ဖက်တွင် ယေရှု ရပ်နေတာဟို လည်းကောင်း မျော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","သူဟ “ကျေ့ပါ၊ ခေါန်းခင် ဖွင့်လှစ်ယွေ့ လူသားဟ ဘုရားသခင်ရဲ့ လက်ယာဖက်တွင် ရပ်လျက်နေတာဟို ငါမျော်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","အဲသူလို့ဟ ကျယ်စွာ ဟစ်အော်လျက် မိမိလို့ရဲ့ နားများဟို လက်နဲ့ပိတ်ပင်း သူ့ဆေဟို တရှိန်ထိုးပြေးကာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","သူ့ဟို မြို့ပြင်သို့ ဆွဲထုတ်ပင်းနောက် ကျောက်ခဲနဲ့ ပေါက်ကြအယ်။ အသိသက်သေများဟ မိမိလို့ ဝတ်လုံများဟို ရှောလု နာမယ်ဆိသူ လူရွယ်တယောက်ရဲ့ ခြေရင်းနား ချထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","သူ့အား ကျောက်ခဲနဲ့ ပေါက်နေကြခါ သတေဖန်ဟ အဆှင့်ဟို ခေါ်ပင်း “သခင် ယေရှု၊ ငါ့ရဲ့ ဝိညာဉ်ဟို သိမ်းယူပါ” ဟု ဆုတောင်းအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","အဲပင်းရင် သူဟ ဒူးထောက်ယွေ့ “သခင်ဘုရား၊ ဟေအပစ်ဟို သူလို့အပေါ် တင်တော်မမူပါနဲ့” ဟု အသံကျယ်စွာ ကြွေးကြော်ပင်းနောက် အသက်ချုပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ရှောလုဟ သတေဖန်ရဲ့ လူသတ်မှုဟို သက်သေပြုခဲ့အယ်။ အဲနေ့မှ စပင်း ယေရုရှလင်မြို့ဆိ အသင်းတော်အပေါ် ပြင်းထန်သော ညှဉ်းဆဲခြင်းဟို ခံရအယ်။ တမန်တော်လို့မှ လွဲယွေ့ ယုံကြည်သူများ အားလုံးဟ ယုဒပြေနဲ့ ရှမာရိပြေများ တဆှောက် ကျဲပြေးကြကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ဘုရားတရား ကြည်ညိုသူ အချို့လို့ဟ သတေဖန်ဟို သင်္ဂြိုဟ်ယွေ့ သူ့အတွက် ရင်ဖတ်တီးပင်း ရမ်းဆာ့ ငိုကကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","အဲလိုလဲ ရှောလုဟ အသင်းတော်ဟို ဖျက်ဆီးရန် ကြိုးစားလျက် နေပင်း၊ သူဟ နေအိုင်တအိုင်ပင်း တအိုင်ဝင်ယွေ့ ယုံကြည်သူ ယောက်ျား မိန်းမလို့ဟို ဆွဲထုတ်ကာ အကျဉ်းထောင်တွင် ထည့်ထားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ကျဲပြေးသွားလဲ့ ယုံကြည်သူလို့ဟ အရပ်ရပ်ဟို သွားယွေ့ သတင်းကောင်းဟို ဟောပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ဖိလိပ္ပုဟ ရှမာရိပြေဆိ မြို့တော်ဟို သွားယွေ့ မေဆှိယရဲ့ အကျောန်းဟို အဲမှာဆိလဲ့ လူလို့အား ဟောပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","လူအုပ်လို့ဟ ဖိလိပ္ပု ပြုလဲ့ နိမိတ်လက္ခဏာများဟို ကြားမျော်ရသောအခါ၊ သူပြောလဲ့အရာဟို သူလို့အားလုံးဟ အာရုံစိုက်ယွေ့ နားထောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","နတ်ဆိုးများဟ လူများစွာထဲမှ အသံကျယ်စွာ အော်ယွေ့ ထွက်ခွာသွားကြပင်း၊ လေဖြတ်သူများနဲ့ ခြေလက်မသန်စွမ်းသူများလည်း ကျန်းမာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","အေးလိုမို့ အဲမြို့နှိုက် ကြီးသော ဝမ်းမြောက်ခြင်း ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","အဲမြို့နှိုက် ရှိမုန်ဆိုသူ လူတယောက် နေထိန်အယ်။ သူဟ မခင်ကတည်းဟ မှော်အတတ်ဟို သုံးယွေ့ ရှမာရိနယ်သား အားလုံးဟို အံဩစေအယ်။ မိမိကိုယ်ကို ကြီးမြတ်သောတဦး ဖြစ်အယ်ဟု ကြွေးကြော်အယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","မြို့ထဲမှဆိလဲ့ အတန်းအစားအမျိုးမျိုးမှ လူအပေါင်းလို့ဟ သူ့ဟို အာရုံစိုက်ယွေ့ နားထောင်ကြအယ်။ သူလို့ဟ “ဟေလူဟ ကြီးမြတ်သော တန်ခိုးတော်ဟု ခေါ်သော ဘုရားရဲ့ တန်ခိုးတော်ပင် ဖြစ်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","သူလို့ဟ သူ့ဟို အာရုံစိုက်ကြခြင်းမှာ သူဟ အချိန်ကြာအောန် မှော်အတတ်နဲ့ သူလို့ဟို အံ့ဩငေးမောစေခဲ့သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","အဲလိုလဲ ဖိလိပ္ပုဟ ဘုရားသခင်ရဲ့ နိုင်ငံတော်နဲ့ ယေရှု ခရစ်တော်ရဲ့ နာမတော်အကျောန်း သတင်းကောင်းဟို ဟောပြောသောအခါ သူလို့ ယုံကြည်လာကြသဖြင့် ယောက်ျား မိန်းမလို့ဟ နှစ်ခြင်းဟို ခံယူကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ရှိမုန် တတ်တိုင်းဟလည်း ယုံကြည်သဖြင့်၊ နှစ်ခြင်း ခံယူပင်းနောက် ဖိလိပ္ပုဆေတွင် အနီးကပ် ဆည်းကပ်လျက် ကြီးမားသော အံ့ဩဖွယ်ရာများနဲ့ နိမိတ်လက္ခဏာများ ပြုတာဟို မျော်ရသောအခါ အံဩမိန်းမောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ယေရုရှလင်မြို့ဆိ တမန်တော်လို့ဟ ရှမာရိလူမျိုးလို့ ဘုရားသခင်ရဲ့ တရားတော်ဟို ခံယူကြကျောန်း ကြားရင် ပေတရုနဲ့ ယောဟန်လို့ဟို သူလို့ဆေဟို စေလွှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","သူလို့ဟ ရောက်လာသောအခါ၊ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို အေးယုံကြည်သူအသစ်လို့ဟ ခံယူကြစေရန် သူလို့အတွက် ဆုတောင်းကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ပစာကို့ သူလို့ဟ ယေရှုရဲ့ နာမတော်နှိုက် နှစ်ခြင်းဟို ခံယူထားရုံမျှသာ ဆိပင်း၊ သူလို့တွင် စသူ့အပေါ်မှ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ မသက်ရောက်သေးချေ။ ");
INSERT INTO dnv_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","အဲပင်းရင် ပေတရုနဲ့ ယောဟန်လို့ဟ အေးသူလို့ရဲ့ အပေါ် လက်တင်ကြသောအခါ သူလို့ဟ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ခံယူရဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","တမန်တော်လို့ရဲ့ လက်တင်ခြင်းအားဖြင့် ဝိညာဉ်တော်ဟို ယုံကြည်သူလို့ရဆိကျောန်းဟို ရှိမုန် မျော်ရင်၊ သူဟ ပိတ်ဆန်ဟို ပေတရုနဲ့ ယောဟန်ဆေမှာ ပေးလှူကာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ငါ လက်တင်သောသူတိုင်းဟ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ခံရစေနိန်သော တန်ခိုးဟို ငါ့အားလည်း ပေးပါ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ပေတရုဟ “နင်ဟ ဘုရားသခင်ရဲ့ ဆုကျေးဇူးတော်ဟို ပိတ်ဆန်နဲ့ ဝယ်ယူမယ်ဟု ထင်သောကျောန့် နင်ရဲ့ ပိတ်ဆန်ဟ နင်နဲ့အတူ ပျက်စီးပါစေ။ ");
INSERT INTO dnv_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ဘုရားသခင်ရဲ့ ဆေ့တွင် နင့်ရဲ့ စိတ်ထား မမန်ကန်သောကျောန့် ဟေအလုပ်တွင် နင်မပါဝင်နိန် အဲဟာမဟုတ်ရင် နင့်ဝေစုလည်း မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","အဲလိုမို့ နင်နှိုက်ဆိသော ဟေဆိုးညစ်မှုအတွက် နောင်တရလျက် ဘုရားသခင်ဆေ ဆုတောင်းကြလော့၊ အေးလို့လုပ်ရင် နင့်စိတ်နေလုံးရဲ့ အကြံအစည်အတွက် နင်ဟ ခွင့်လွှတ်ခြင်း ခံရကောင်း ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","အကျောန်းမှာ နင်ဟ မနာလိုစိတ်နဲ့ ပြေ့နေယွေ့ အပစ်ရဲ့ အနှောင်အဖွဲ့နှိုက် ဆိနေတာဟို ငါမျော်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ရှိမုန်ဟ “နင်လို့ ပြောလဲ့အရာတခုမျှ ငါ့အပေါ် မသက်ရောက်စေရန် ဘုရားသခင်နား ငါ့အတွက် ဆုတောင်းပေးကြပါ” ဟု ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ပေတရုနဲ့ ယောဟန်လို့ဟ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားဟို သက်သေခံယွေ့ ဟောပြောကြပင်းနောက် ယေရုရှလင်မြို့သို့ ပြန်သွားကြအယ်။ သူလို့ အပြန်လမ်းခရီးတွင် ရမ်းဆာ့သော ရှမာရိရွာလို့နှိုက် သတင်းကောင်းဟို ဟောပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ထာဝရဘုရားရဲ့ ခေါန်းခင်တမန်ဟ ဖိလိပ္ပုအား “နင်ဟ ထယွေ့ ယေရုရှလင်မြို့မှ ဂါဇမြို့သို့ သွားရာလမ်းအတိုင်း တောင်ဖက်ဟို သွားလော့” ဟု ဆိုအယ်။ အေးလမ်းဟို ဟေနေ့ခေတ်မှာ အသုံးမပြုတော့ပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","အေးလိုမို့ ဖိလိပ္ပုဟ ထယွေ့ သွားလေအယ်။ အဲအခါနှိုက် အဲသယောပိပြေမှ မိန်းမစိုး အရာဆိတယောက်ဟ ယေရုရှလင်မြို့ဟို သွားရောက်ယွေ့ ဘုရားသခင်အား ကိုးကွယ်ဝတ်ပြုပင်းနောက် မိမိနေအိုင်ဟို ပြန်လည်ထွက်ခွာလာအယ်။ သူဟ အဲသယောပိ ဘုရင်မ ကန္ဒက်ရဲ့ ဘဏ္ဍာအားလုံးဟို စီမံအုပ်ချုပ်ပင်း အရေးပါသောသူ ဖြစ်အယ်။ သူဟ ရထားစီးလျက် ပရောဖက် ဟေရှာယကျမ်းဟို ဖတ်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","အဲအခါ ဝိညာဉ်တော်ဟ ဖိလိပ္ပုအား “အေးမြင်းလှည်းအနီးဟို သွားလော့” ဟု အမိန့်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","အေးလိုမို့ ဖိလိပ္ပုဟ ပြေးယွေ့ သွားရာ ပရောဖက် ဟေရှာယကျမ်းဟို အဲသူ ဖတ်လျက်နေတာဟို ကြားသဖြင့် “နင် ဖတ်နေလဲ့အရာဟို နားလည်သလော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","သူဟ “ငါ့အား အနက်ဖွင့်ပြမဲ့သူ မဆိဘဲ စလို နားလည်နိန်မလုန်း” ဟု ပြောပင်းနောက် ဖိလိပ္ပုအား မြင်းလှည်းပေါ်သို့ တက်ယွေ့ မိမိနဲ့အတူ ထိန်ရန် ဖိတ်ခေါ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","အဲသူ ဖတ်လျက်နေလဲ့ ကျမ်းစာချက်မှာ၊ “သူဟ သတ်ရန် လျာထားသော သိုးလိုမျိုး ခေါ်ဆောင်သွားခြင်းဟို ခံရယွေ့၊ သိုးသငယ်ဟ အမွေးညှပ် သူလို့ရဲ့ ဆေ့နှိုက် အသံမထွက်ဘဲ နေသလိုမျိုး သူဟ မိမိ နှုတ်ဟို မဖွင့်ဘဲ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","သူဟ နှိမ့်ချခြင်း ခံရခါနှိုက် သူ့အတွက် တရားသဖြင့် စီရင်ပေးခြင်း မဆိကြ။ သူရဲ့ အသက်ဟို မြေကြီးပေါ်မှ ရုပ်သိမ်းသွားသောကျောန့် သူရဲ့ သားမြေးများအကျောန်းဟို စသူ ပြောပြနိန်မလုန်း” ဟူယွေ့ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","အဲအရာဆိဟ ဖိလိပ္ပုအား “ပရောဖက်ဟ စသူရဲ့ အကျောန်းဟို ပြောဆိုလျက် နေလုန်း။ မိမိရဲ့ အကျောန်းလော အဲဟာမဟုတ်ရင် အခြားသူတယောက်ရဲ့ အကျောန်းလော၊ ငါ့အား ပြောပြမန့်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","အဲပင်းရင် ဖိလိပ္ပုဟ အေးကျမ်းစာပိုဒ်နဲ့ပင် အစပြုယွေ့ ယေရှုအကျောန်း သတင်းကောင်းဟို ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","သူလို့ဟ ဆက်လက်ယွေ့ ခရီးပြုကြခါ ယေဆိလဲ့ အရပ်သို့ ရောက်လာသဖြင့် အရာဆိဟ “ဟေအရပ်တွင် ယေဆိအယ်။ နှစ်ခြင်းဟို ငါမခံယူစေရန် ဆီးတားလဲ့အကျောန်း ဆိသလော” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","အရာဆိဟ မြင်းလှည်းဟို ရပ်စေရန် အမိန့်ပေးပင်း၊ သူလို့နေယောက်ဟ ယေထဲသို့ ဆင်းသွားကြပင်း ဖိလိပ္ပုဟ အရာဆိအား နှစ်ခြင်းဟို ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","သူလို့ ယေမှ တက်လာကြသောအခါ ထာဝရဘုရားရဲ့ ဝိညာဉ်တော်ဟ ဖိလိပ္ပုအား တပါးအရပ်သို့ ဆောင်ယူသွားကြအယ်။ အရာဆိဟ ဖိလိပ္ပုဟို နောက်တခါ မတွေ့ရတော့ပေမဲ့ သူဟ ဝမ်းမြောက်ဝမ်းသာစွာ ဆက်လက် ခရီးပြုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ဖိလိပ္ပုဟ အာဇုတ်မြို့ဟို မိမိတတ်တိုင်း ရောက်ဆိနေတာကျောန်း သိရအယ်။ သူဟ ကဲသရိမြို့သို့ သွားပင်း လမ်းခရီးတွင် တမြို့ပင်း တမြို့ဟို ဝင်ယွေ့ သတင်းကောင်းဟို ဟောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ဟေအတောတွင်း ရှောလုဟ သခင်ဘုရားရဲ့ တဘဲ့တော်လို့အား သတ်ဖြတ်ရန် ခြိမ်းခြောက်လျက် နေအယ်။ သူဟ ယဇ်ပုရောဟိတ်မင်းဆေ သွားပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ဘုရားသခင်ရဲ့ လမ်းစဉ်ဟို လိုက်ဆှောက်သောသူ ယောက်ျား မိန်းမလို့ဟို တွေ့ဆိပါက အဲသူလို့ဟို ဖမ်းဆီးယွေ့ ယေရုရှလင်မြို့သို့ ခေါ်ဆောင်လာနိန်ရန် ဒမာသက်မြို့ဆိ တရားဇရပ်များဆေဟို အမိန့်စာများရေးပေးရန် သူ့ဆေမှ တောင်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","သူဟ ခရီးပြုယွေ့ ဒမာသက်မြို့ အနီးဟို ရောက်သောအခါ မိုးခေါန်းခင်မှ အလင်းရောင်ခြည်တခုဟ သူရဲ့ ပတ်လည်တွင် ခုတုံး ထွန်းတောက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","သူဟ မြေပေါ်ဟို လဲကျသွားပင်း “ရှောလု၊ ရှောလု၊ နင်ဟ ပစာကျောန့် ငါ့ဟို ညှဉ်းဆဲလုန်း” ဟု သူ့အား ပြောသော အသံဟို ကြားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ရှောလုဟ “သခင်ဘုရား၊ ကိုယ်တော်ဟ စသူလုန်း” ဟု မေးဆှောက်အယ်။ ကိုယ်တော်ဟ “ငါဟ နင် ညှဉ်းဆဲနေလဲ့ ယေရှုပင် ဖြစ်အယ်” ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“အဲလိုလဲ နင်ဟ ထယွေ့ မြို့ထဲဟို သွားလော့၊ အဲမှာ နင်ပြုရမယ့် အမှုဟို ငါ ပြောလိမ့်မယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ရှောလုနဲ့အတူ ခရီးသွားလျက်နေကြသော သူလို့ဟ အသံဟို ကြားရသော်လည်း လူတစုံတယောက်ဟိုမျှ မမျော်ရကြသဖြင့် ကြက်သေသေလျက် ရပ်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ရှောလုဟ မြေပေါ်မှ ထယွေ့ မျက်စေ့ ဖွင့်ပေမဲ့လည်း ပစာအရာဟိုမျှ မမျော်ရတော့ချေ။ အေးလိုမို့ အဲသူလို့ဟ သူ့လက်ဟို ဆွဲယွေ့ ဒမာသက်မြို့ထဲဟို ယိုးသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","အကျောန်းမှာ သူဟ သုံးရက်လုံးလုံး မျက်စေ့ မမျော်နိန်ဖြစ်ပင်း အဲအချိန်အတွင်း သူဟ တခုမှ မစားမသောက်ဘဲ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ဒမာသက်မြို့တွင် အာနနိ နာမယ်ဆိသူ တဘဲ့တော် တယောက် ဆိအယ်။ ဗျာဒိတ်ရူပါရုံထဲတွင် သခင်ဘုရားဟ သူ့အား “အာနနိ” ဟု ခေါ်ရင်၊ အာနနိဟ “ဆိပါအယ် သခင်ဘုရား” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","သခင်ဘုရားဟလည်း သူ့အား “နင်ဟ ထယွေ့ လမ်းဖြောင့်ဟု ခေါ်သော လမ်းဟို သွားလော့၊ တာရှုမြို့သား ရှောလုဆိုသူဟို ယုဒရဲ့ နေအိုင်တွင် စုံစမ်းမေးမြန်းလော့၊ အကျောန်းမှာ သူဟ ဆုတောင်းလျက် နေအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","သူဟ မျက်စေ့ အလင်းပြန်လည်ရဆိနိန်ရန် အာနနိ နာမယ်ဆိသောသူ လာယွေ့ မိမိအပေါ်မှာ လက်တင်တာဟို ဗျာဒိတ်ရူပါရုံတွင် မျော်လေပီ” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","အာနနိဟ “သခင်ဘုရား၊ ဟေလူဟ ယေရုရှလင်မြို့ဆိ ကိုယ်တော်ရဲ့ သန့်ဆှင်းသူလို့အား စလောက်ထိ ဒုက္ခပေးခဲ့တာဟို လူအမြောက်အမြားဆေမှ ငါ ကြားသိရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","အဲအပြင် ကိုယ်တော်ရဲ့ နာမယ်ဟို ခေါ်သောသူ မန်သမျှဟိုလည်း ဖမ်းဆီးရန် ယဇ်ပုရောဟိတ်ကြီးလို့ဆေမှ အခွင့်အာဏာ ရဆိထားသူ ဖြစ်ပါအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","အဲလိုလဲ သခင်ဘုရားဟ အာနနိအား “သွားလော့၊ ဟေလူဟ လူမျိုးခြားများ၊ ဘုရင်များနဲ့ ဣသရေလအမျိုးသားလို့အား ငါရဲ့ နာမဟို ကြေညာရန် ငါ ရွေးချယ်ထားသော တန်ဆာပလာ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","အကျောန်းမှာ ငါရဲ့ နာမတော် အတွက် စလောက် ဒုက္ခဆင်းရဲခံရမယ်ဟို သူ့အား ငါတတ်တိုင်း ဖော်ပြမယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","အေးလိုမို့ အာနနိဟ ရှောလုဆိလဲ့ နေအိုင်သို့ ဝင်သွားယွေ့ သူရဲ့ အပေါ်မှာ လက်ဟို တင်ပင်း သူဟ “ငါ့ညီ ရှောလု၊ နင်ဟ မျက်စေ့အလင်းဟို ပြန်လည်ရဆိစေရန်နဲ့ သန့်ဆှင်းသော ဝိညာဉ်တော်ဖြင့် ပြေ့ဝလာစေရန် နင်လာသော လမ်းခရီးနှိုက် နင့်အား ထင်ဆှားသော ယေရှုဟ ငါ့အား နင့်ဆေဟို စေလွှတ်လိုက်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ခုတုံးပင် ရှောလုရဲ့ မျက်စေ့မှ ငါးကြေးကွာကျ သလိုမျိုးဖြစ်ပင်း မျက်စေ့အလင်းဟို ပြန်လည်ရဆိအယ်။ သူဟ ထယွေ့ နှစ်ခြင်းဟို ခံလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","အဲပင်းရင် အစားအစာ သုံးဆောင်ပင်း ခွန်အားပြေ့ လာအယ်။ ရှောလုဟ ဒမာသက်မြို့မှာ တဘဲ့တော်များနဲ့အတူ ရက်အနည်းငယ် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","တရားဇရပ်များဟို ယေရှုဟ ဘုရားသခင်ရဲ့ သားတော်ဖြစ်ကျောန်းဟို ခုတင်ချင်း စတင် ဟောပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","သူ့ရဲ့ စကားဟို ကြားသောသူအပေါင်းလို့ဟ အံ့ဩကြလျက် “ဟေလူဟ ယေရှုဟို ကိုးကွယ်သောသူတိုင်း ယေရုရှလင်မြို့တွင် သတ်ဖြတ်ခဲ့သူ မဟုတ်ဝူးလော။ အေးသူလို့ဟို ဖမ်းဆီးယွေ့ ယဇ်ပုရောဟိတ်ကြီးများဆေ ခေါ်ဆောင်သွားရန်ဟူသော ရည်ရွယ်ချက်နဲ့ ဟေနေရာဟို လာရောက်တာ မဟုတ်လော” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","အဲလိုလဲ ရှောလုရဲ့ ဟောပြောချက်ဟ တန်ခိုးနဲ့ ပိုယွေ့ ပြေ့စုံလာပင်း ယေရှုဟ မေဆှိယဖြစ်ကျောန်းဟို ပိုင်ပိုင်နိန်နိန် သက်သေပြယွေ့ ဒမာသက်မြို့ဆိ ယုဒအမျိုးသားလို့ ပြည်လည်ယွေ့ မချေပနိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ရက်ပေါင်းများစွာ ကြာပင်းနောက် ယုဒအမျိုးသားလို့ဟ အတူတကွ တွေ့ဆုံပင်း ရှောလုဟို သတ်ရန် လျှို့ဝှက်ကြံစည်ကြအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","အဲလိုလဲ သူလို့ရဲ့ အကြံအစည်ဟို ရှောလု သိသွားအယ်။ သူလို့ဟ ရှောလုဟို သတ်ရန် နေ့ရောညဉ့်ပါ မြို့ထင်ခါးများတွင် စောင့်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","အဲလိုလဲ ရှောလုရဲ့ တဘဲ့လို့ဟ ညအခါ သူ့ဟို သယ်ဆောင်သွားကာ တောင်းတွင် ထည့်ယွေ့ မြို့ရိုးအောက်သို့ လျှောချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ရှောလုဟ ယေရုရှလင်မြို့သို့ ရောက်သောအခါ တဘဲ့တော်လို့နဲ့ ပေါင်းဖော်ရန် ကြိုးစားပေမဲ့ သူလို့အားလုံးဟ သူ့ဟို အမန်တကယ် တဘဲ့တော် တဦးဖြစ်ကျောန်းဟို မယုံသဖြင့် သူ့ဟို ကြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","အဲလိုလဲ ဗာနဗဟ သူ့ဟို ကူညီယွေ့ တမန်တော်လို့ဆေ ခေါ်လာအယ်။ ရှောလုဟ လမ်းခရီးနှိုက် သခင်ဘုရားဟို မျော်ခဲ့ပုံမှ စယွေ့ သခင်ဘုရားဟ သူ့အား မိန့်ခဲ့ပုံနဲ့ ဒမာသက်မြို့တွင် ယေရှုရဲ့ နာမတော်နှိုက် ရဲရင့်စွာ သူဟောပြောခဲ့ပုံလို့ဟို သူလို့အား ပြောပြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","အဲပင်းရင် ရှောလုဟလည်း ယေရုရှလင်မြို့တွင် သူလို့နဲ့အတူ နေပင်း သွားလာလှုပ်ဆှားလျက် သခင်ဘုရားရဲ့ နာမတော်ဟို အမှီပြုယွေ့ ရဲရင့်စွာ ဟောပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","သူဟလည်း ဟေလနစ်စကားဟို ပြောသောသူ ယုဒအမျိုးသားများနဲ့ အခြေအတင် ဆွေးနွေးပေမဲ့ အဲသူလို့ဟ သူ့ဟို သတ်ရန် ကြံစည် အားထုတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","အဲအကျောန်းဟို ညီအကိုလို့ ကြားသိသောအခါ၊ ရှောလုဟို ကဲသရိမြို့သို့ ပို့ဆောင်ပင်း အေးမှတဆင့် တာရှုမြို့သို့ ထွက်ခွာသွားစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","အဲလိုမို့ အေးကာလတွင် ယုဒပြေ၊ ဂါလိလဲပြေနဲ့ ရှမာရိပြေ အရပ်ရပ်လို့တွင် အသင်းတော်ဟ ငြိမ်းချမ်းစွာ နေရလေအယ်။ သခင်ဘုရားအား ကြောက်ရွံ့ ရိုသေသောစိတ်ဖြင့် သက်ဝင်လှုပ်ဆှားလျက် သန့်ဆှင်းသော ဝိညာဉ်တော်ရဲ့ ကူညီအားပေးမှုဖြင့် တည်တံ့ခိုင်မြဲကာ အရေအတွက် တိုးတက် များပြားလာလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ပေတရုဟ အရပ်ရပ်သို့ လှည့်လည် သွားလာပင်း၊ သူဟ လုဒ္ဒမြို့နှိုက် နေထိန်သော ဘုရားသခင်ရဲ့ သန့်ဆှင်းသူဆေသို့ ရောက်ဆိလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","အဲမြို့တွင် လေဖြတ်သဖြင့် ဆစ်နှစ်ပတ်လုံး အိပ်ယာပေါ်မှာ တုံးလုံးနေသူ အဲနေ နာမယ်ဆိသော လူတယောက်ဟို တွေ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ပေတရုဟ သူ့အား “အဲနေ၊ ယေရှု ခရစ်ဟ နင့်ဟို ကျန်းမာစေပီ။ ထယွေ့ အိပ်ယာဟို သိမ်းလော့” ဟု ဆိုအယ်။ အဲသူဟ ခုတင်ချင်း ထအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","လုဒ္ဒမြို့နဲ့ ရှာရုန်မြို့တွင် နေသောသူအပေါင်းလို့ဟ အေးသူဟို မျော်ယွေ့ သခင်ဘုရားဆေဟို ပြောင်းလဲလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ယုပ္ပေမြို့တွင် ဒေါ်ကာဟု အဓိပ္ပာယ်ရသော တဗိသ နာမယ်ဆိသော တဘဲ့တော်မ တယောက် ဆိအယ်။ သူမရဲ့ နာမယ်မှာ ဟေလသစကားအရ “ဒရယ်” ဟု အနက်ရလေအယ်။ သူဟ ဆင်းရဲသောသူအား ကောင်းမှုနဲ့ စွန့်ကြဲပေးကမ်းမှုဟို အမြဲပြုတတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","အေးအချိန်မှာ သူဟ ဖျားနာယွေ့ သေလေအယ်။ သူရဲ့ အလောင်းဟို ယေချိုးပေးကြပီပင်း အပေါ်ထပ်အခန်းတွင် ပြင်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","လုဒ္ဒမြို့ဟ ယုပ္ပေမြို့ အနီးတွင် ဆိသဖြင့် အေးလုဒ္ဒမြို့တွင် ပေတရုဆိကျောန်း တဘဲ့တော်လို့ ကြားသိကြသောအခါ “ငါလို့ဆေ ခုတင်ချင်း ကြွလာပါ” ဟူသော ပန်ကြားချက်ဖြင့် လူနေယောက်ဟို စေလွှတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","အဲလိုမို့ ပေတရုဟ ထယွေ့ အဲသူလို့နဲ့အတူ လိုက်သွားလေအယ်။ သူ ရောက်သောအခါ၊ သူလို့ဟ သူ့အား အပေါ်ထပ်အခန်းသို့ ခေါ်သွားကြအယ်။ မုဆိုးမအားလုံးလို့ဟ ပေတရုရဲ့ အနီးတွင် ဝိုင်းအုံကာ ငိုကလျက် ဒေါ်ကာ သူလို့နဲ့အတူ ဆိစဉ်အခါဟ ချုပ်လုပ်ထားခဲ့သော အင်္ကျီနဲ့ ဝတ်လုံများဟို ပြကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ပေတရုဟ အဲသူအပေါင်းလို့ဟို အပြင်သို့ ထွက်စေပင်း ဒူးထောက်ယွေ့ ဆုတောင်းလေအယ်။ အဲပင်းရင် ရုပ်အလောင်းဖက်ဟို လှည့်ယွေ့ “တဗိသ၊ ထလော့” ဟု ဆိုအယ်။ သူဟ မျက်စေ့ဟို ဖွင့်ယွေ့ ပေတရုဟို မျော်သောအခါ ထယွေ့ ထိန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ပေတရုဟ လက်ဟို ကမ်းပေးပင်း အဲအမျိုးသမီးဟို ဆွဲထူလိုက်အယ်။ အဲပင်းရင် အထူးသဖြင့် မုဆိုးမများ၊ သန့်ဆှင်းသူများဟို ခေါ်ယွေ့ အသက်ဆှင်လျက်ဆိသော သူ့ဟို ပေးအပ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ဟေသတင်းဟ ယုပ္ပေ တမြို့လုံးတွင် ကျော်ကြားသွားသဖြင့် လူအမြောက်အမြားပင် သခင်ဘုရားဟို သက်ဝင် ယုံကြည်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ပေတရုဟ ယုပ္ပေမြို့တွင် ရှိမုန် နာမယ်ဆိသော သားရေ လုပ်သမားနဲ့အတူ ရက်ပေါင်းများစွာ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ကဲသရိမြို့တွင် “ဣတလိတပ်” ဟု ခေါ်သော ရောမတပ်မှ ကော်နေလိ နာမယ်ဆိသူ တပ်မှူးတယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","သူနဲ့တကွ သူရဲ့ အိုင်သူအိုင်သား အားလုံးလို့ဟ ဘုရားတရား ကြည်ညိုယွေ့ ဘုရားသခင်ဟို ကိုးကွယ်သူများ ဖြစ်အယ်။ သူဟ ဆင်းရဲသော ယုဒအမျိုးသားလို့အား ရက်ရောစွာ လှူဒါန်းပင်း ဘုရားသခင်ဆေ အချိန်မန်မန် ဆုတောင်းလေ့ ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","တနေ့ မွန်းလွဲသုံးနာရီခန့် အချိန်နှိုက် ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန် တပါးဟ သူ့နားဟို လာယွေ့ “ကော်နေလိ” ဟု ခေါ်တာဟို ရူပါရုံနှိုက် အထင်အဆှား မျော်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","သူဟ ကြောက်လျက် ခေါန်းခင်တမန်ဟို စိုက်ကျေ့ပင်း “ဆရာ၊ ပစာအကျောန်း ဆိသလော” ဟု မေးဆှောက်အယ်။ ခေါန်းခင်တမန်ဟလည်း “နင် ဆုတောင်းခြင်းနဲ့ ရက်ရောမှုဟို ဘုရားသခင် နှစ်သက်သဖြင့် နင့်အား သိမှတ်လေပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","အခု ယုပ္ပေမြို့သို့ လူဟို စေလွှတ်ယွေ့ ပေတရုဟု ခေါ်သော ရှိမုန်ဟို ခေါ်ပင့်လော။ ");
INSERT INTO dnv_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","သူဟ သားရေ လုပ်သမား ရှိမုန်ရဲ့ နေအိုင်တွင် တည်းခိုလျက် နေပင်း၊ အဲနေအိုင်ဟ ပင်လယ်ကမ်း အနီးတွင် ဆိအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","မိမိအားမြွက်ဆိုသော ခေါန်းခင်တမန် ထွက်ခွာသွားသောအခါ ကော်နေလိဟ မိမိရဲ့ အစေခံ နေယောက်နဲ့ မိမိအနီးအပါးတွင် တာဝန် ထမ်းဆောင်နေသော သူလို့အထဲမှ ဘုရားဝတ်နှိုက် မွေ့လျော်သော စစ်သားတယောက်ဟို ခေါ်ကာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","အကျောန်း အလုံးစုံဟို ပြောပြပင်း ယုပ္ပေမြို့ဟို စေလွှတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","နောက်တနေ့နှိုက် အဲသူလို့ဟ ခရီးပြုကြစဉ် ယုပ္ပေမြို့အနီးဟို ရောက်ကြပင်း၊ မွန်းတည့်ချိန်ခန့်တွင် ပေတရုဟ ဆုတောင်းရန် ထပ်ခိုးပေါ်ဟို တက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","သူဟ မွတ်သဖြင့် အစားအစာ တခုခုဟို စားချင်အယ်၊ သူအတွက် အစားအစာများ ပြင်ဆင်နေကြခါ သူဟ ဗျာဒိတ်ရူပါရုံဟို မျော်ရလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","သူဟ မိုးခေါန်းခင် ဖွင့်ဟလျက် ထောင့်လေးထောင့်မှ ချုပ်ကိုင်ထားသော ရွက်ထည်နဲ့တူလဲ့ အရာတခု မြေကြီးပေါ် ကျလာတာဟို တွေ့ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","အဲအရာထဲတွင် မြေနှိုက် ကျင်လည်သော သားမျိုး ခြေလေးချောင်း သတ္တဝါမျိုး၊ တွားတတ်သော သတ္တဝါအမျိုးမျိုးနဲ့ ခေါန်းခင်ငက် အမျိုးမျိုးလို့ဖြင့် ပါဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","အဲပင်းရင် “ပေတရု၊ ထယွေ့ သတ်စားလော” ဟူသော အသံဟို သူကြားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","အဲလိုလဲ ပေတရုဟ “အဆှင်ဘုရား၊ စလိုနည်းနဲ့မျှ မဖြစ်နိန်ပါ။ ငါဟ မသန့်ဆှင်းသောအရာ အဲဟာမဟုတ်ရင် စုတ်ပဲ့လဲ့အရာဟို ပစာအခါမှ မစားဖူးပါ” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","အဲအခါ ဒုတိယအကြိမ် အသံထပ်ထွက်ပေါ်လာယွေ့ “ဘုရားသခင် သန့်စင်အယ် ဟု ဆိုလဲ့အရာဟို နင်ဟ စုတ်ပဲ့အယ်ဟု မဆိုရ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ဟေလို့ သုံးကြိမ်တိတိ ဖြစ်ပျက်ပင်းနောက် ရွက်ထည်နဲ့တူလဲ့အရာဟ ခုတင်ချင်း မိုးခေါန်းခင်ဟို ပြန်လည် ရုပ်သိမ်းခြင်းဟို ခံရလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ပေတရုဟ အဲဗျာဒိတ်ရူပါရုံရဲ့ အနက်အဓိပ္ပာယ်ဟို ဆင်ခြင် စဉ်းစားလျက်နေစဉ် ကော်နေလိ စေလွှတ်လိုက်သော လူလို့ဟ ရှိမုန်ရဲ့ နေအိုင်ဟို မေးမြန်းဆှာဖွေယွေ့၊ သူလို့ဟ ထင်ခါးပေါက်ဆေ့တွင် အခု ရပ်လျက်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","အဲသူလို့ဟ “ပေတရုခေါ် ရှိမုန်ဟ ဟေအိုင်တွင် တည်းခိုနေသလော” ဟု အော်ယွေ့ မေးမြန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ပေတရုဟ ဗျာဒိတ်ရူပါရုံ အကျောန်းဟို စဉ်းစားနေစဉ် ဝိညာဉ်တော်ဟ “လူသုံးယောက်လို့ဟ နင့်ဟို ဆာနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","အဲလိုမို့ ထယွေ့ အောက်ဟို ဆင်းသွားလော။ အကျောန်းမှာ ငါပင် သူလို့ဟို စေလွှတ်လိုက်တာ ဖြစ်ယွေ့ မဆိုင်းမတွဘဲ သူလို့နဲ့အတူ လိုက်သွားလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","အေးလိုမို့ ပေတရုဟ ဆင်းသွားပင်း “နင်လို့ ဆာနေသောသူမှာ ငါပင် ဖြစ်အယ်။ ပစာအကျောန်းကျောန့် နင်လို့ ရောက်လာကြလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","အဲသူလို့ဟလည်း “တပ်မှူးကောနေလိဟ ငါလို့အား စေလွှတ်အယ်” ဟု ပြန်ဖြေအယ်။ “ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန်ဟ သူ့အား နင့်ဟို မိမိနေအိုင်ဟို ဖိတ်ခေါ်ယွေ့ နင့်ဆေမှ တရားစကားဟို နားထောင်ရန် ပြောခဲ့အယ်။ သူဟ ဖြောင့်မတ်ယွေ့ ဘုရားသခင်ဟို ကြောက်ရွံ့သောသူ ဖြစ်ပင်း ယုဒလူမျိုးအားလုံးလို့ရဲ့ လေးစားခံရသောသူလည်း ဖြစ်အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","အဲပင်းရင် ပေတရုဟ အဲသူလို့အား အိုင်ထဲဟို ခေါ်ဖိတ်ယွေ့ အေးညတွင် အိပ်စေအယ်။ နောက်တနေ့နှိုက် သူဟ အေးသူလို့နဲ့အတူ ထွက်ခွာပင်း၊ ယုပ္ပေမြို့မှ ယုံကြည်သူအချို့လို့လည်း သူနဲ့အတူ လိုက်ပါသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","နောက်တနေ့နှိုက် သူဟ ကဲသရိမြို့သို့ ရောက်လေအယ်။ ကော်နေလိဟ မိမိဆွေမျိုးသားချင်းများနဲ့ ရင်းနှီးသော မိတ်ဆွေများဟို စုထားလျက် သူလို့အား စောင့်မျှော်လျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ပေတရု အိုင်ထဲဝင်လာသောအခါ၊ ကော်နေလိဟ ခရီးဦးကြိုပြုယွေ့ သူရဲ့ ခြေရင်းတွင် ပျပ်ဝပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","အဲလိုလဲ ပေတရု သူ့ဟို ထစေအယ်။ သူဟ “ရပ်လော့၊ ငါတတ်တိုင်းလည်း သာမန်လူ ဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ပေတရုဟ ကော်နလိနဲ့အတူ စကားပြောလျက် နေအိုင်ထဲဟို ဝင်သွားသောအခါ၊ လူအမြောက်အများ စုဝေးလျက်ဆိတာဟို တွေ့မျော်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ပေတရုဟ သူလို့အား “ယုဒအမျိုးသားလို့အတွက် လူမျိုးခြားများဆေ အလည်အပတ်သွားခြင်း အဲဟာမဟုတ်ရင် ပေါင်းဖော်ခြင်းဟ ဘာသာတရားဟ တားမြစ်ထားတာဟို နင်လို့တတ်တိုင်း ကောင်းစွာသိကြအယ်။ အဲလိုလဲ စသူဟိုမျှ စုတ်ပဲ့သောသူ အဲဟာမဟုတ်ရင် မသန့်စင်သူ ဟု မမှတ်ယူရန် ဘုရားသခင်ဟ ငါ့အား ဖော်ပြပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","အဲမို့ ငါ့ဟို နင်ခေါ်ဖိတ်သောအခါ ငါဟ မငြင်းဆိုဘဲ လိုက်လာခဲ့အယ်။ ပစာကို့ ငါ့ဟို ခေါ်ဖိတ်ရကျောန်း ပြောကြားပါလော့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ကော်နေလိဟ “ကျူးခဲ့သော သုံးရက်ဟ မွန်းလွဲသုံးနာရီနှိုက် ငါဟ အိုင်မှာ ဆုတောင်းလျက်နေအယ်။ ခုတင်ချင်း တောက်ပြောင်သော အဝတ်ဟို ဝတ်ဆင်ထားသူ လူတယောက်ဟ ငါရဲ့ ဆေ့တွင် ရပ်ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘ကော်နေလိ၊ နင့်ရဲ့ ဆုတောင်းသံဟို ဘုရားသခင် ကြားယွေ့ နင့်ရဲ့ စွန့်ကြဲပေးကမ်းမှုဟိုလည်း သိမှတ်ပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ယုပ္ပေမြို့ဟို လူစေလွှတ်ယွေ့ ရှိမုန် ပေတရုဟု ခေါ်သောသူဟို ခေါ်ပင့်လော့။ သူဟ ပင်လယ်ကမ်းအနီးဆိ သားရေလုပ်သမား ရှိမုန်ရဲ့ နေအိုင်တွင် တည်းခိုလျက် နေအယ်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","အဲမို့ ငါဟ ခုတင်ချင်း နင့်ရဲ့ ဆေဟို လူလွှတ်ခဲ့ပင်း နင်ဟလည်း ကြွရောက်လာသောကျောန့် ကောင်းစွာပြုပီ။ အခု နင့်အားဖြင့် ထာဝရဘုရား မိန့်သမျှသော စကားတော်လို့ဟို ကြားနာရန် ငါလို့ဟ ဘုရားသခင်ရဲ့ ဆေ့တော်မှောက်ဟို ရောက်ဆိနေကြပါပီ” ဟု ပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","အဲအခါ ပေတရုဟ “အမန်စင်စစ် ဘုရားသခင်ဟ မျက်နှာကြီးငယ် မထောက်ကျောန်းဟို အခု ငါသိဆိ နားလည်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","အဲလိုလဲ စလို လူမျိုးမဆို ကိုယ်တော်ဟို ကြောက်ရွံ့ယွေ့ တရားသဖြင့် ကျင့်သုံးသူမန်သမျှအား နှစ်သက်လက်ခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ဘုရားသခင်ဟ လူအပေါင်းလို့ရဲ့ အဆှင် သခင်ဖြစ်သော ယေရှု ခရစ်တော်အားဖြင့် ငြိမ်သက်ခြင်းနဲ့ဆိုင်သော သတင်းကောင်းဟို ဟောပြောယွေ့ ဣသရေလအမျိုးသားလို့ဆေ ပေးပို့သော နှုတ်ကပတ်တရားတော်ဟို နင်လို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","နှစ်ခြင်း တရားဟို ယောဟန် ဟောပြောပင်းနောက် ဂါလိလဲပြေမှ အစပြုယွေ့ ယုဒပြေ တဆှောက်လုံးတွင် ဖြစ်ပျက်ခဲ့လဲ့ အမှုအရာများအကျောန်းဟို လည်းကောင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ဘုရားသခင်ဟ နာဇရက်မြို့သား ယေရှုဟို သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ တန်ခိုးတော်လို့ဖြင့် စလိုမျိုး ဘိသိက်ပေးခဲ့တာဟို လည်းကောင်း နင်လို့ သိကြအယ်။ ဘုရားသခင်ဟ ကိုယ်တော်နဲ့အတူ ဆိသောကျောန့် ကိုယ်တော်ဟ အရပ်ရပ်ဟို လှည့်လည်ယွေ့ ကောင်းသောအမှုဟို ပြုကာ မာရ်နတ်ရဲ့ တန်ခိုးအောက်နှိုက်မှာ ဆိလဲ့သူအပေါင်းလို့အား လွတ်မြောက်စေခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ငါလို့ဟ ယေရုရှလင်မြို့မှ စယွေ့ ယုဒလူမျိုးများရဲ့ ပြေနှိုက် ကိုယ်တော် လုပ်ဆောင်ခဲ့သမျှသော အရာအားလုံးရဲ့ သက်သေများ ဖြစ်ကြအယ်။ အဲပင်းရင် လူလို့ဟ ကိုယ်တော်ဟို လက်ဝါးကပ်တိုင်တွင် တင်ယွေ့ သတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","အဲလိုလဲ တတိယနေ့နှိုက် ဘုရားသခင်ဟ ကိုယ်တော်ဟို သေခြင်းမှ ဆှင်ပြန်ထမြောက်စေယွေ့ ကိုယ်ထင်ပြစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","အဲလိုလဲ လူအားလုံးဆေနှိုက် မဟုတ်ဘဲ သက်သေအဖြစ် ဘုရားသခင် ကြိုတင်ခန့်ထားသော ငါလို့ဆေနှိုက်သာ ကိုယ်ထင်ဆှားပြအယ်။ ကိုယ်တော်ဟ သေသောလူလို့ထဲမှ ထမြောက်ပင်းနောက် ငါလို့ဟ ကိုယ်တော်နဲ့အတူ စားသောက်ခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ကိုယ်တော်ဟ လူလို့အား သတင်းကောင်းဟို ဟောပြောရန်နဲ့ ကိုယ်တော်ဟ အသက်ဆှင်နေသူနဲ့ သေလွန်သူများဟို တရားစီရင်သော သခင်အဖြစ် ဘုရားသခင် ခန့်ထားကျောန်း ဟောပြော သက်သေခံရန် ငါလို့အား ပညတ်ပေးခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","အဲအဆှင်နဲ့ ပတ်သက်ယွေ့ ပရောဖက်အားလုံးလို့ဟလည်း ကိုယ်တော်ဟို ယုံကြည်သောသူတိုင်း ကိုယ်တော်ရဲ့ နာမတော်အားဖြင့် အပစ်များ ခွင့်လွှတ်ခြင်း ကျေးဇူးဟို ခံစားရအယ်ဟု သက်သေခံကြအယ်” ဟူယွေ့ မြွက်ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ဟေတရားစကားဟို ပေတရု စကားပြောနေစဉ်၊ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ နှုတ်ကပတ်တရားဟို ကြားနာနေကြသော သူအပေါင်းလို့ အပေါ်သို့ ဆင်းသက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ပေတရုနဲ့အတူ လိုက်ပါလာလဲ့ အရေဖျားလှီးထားသော ယုံကြည်သူဆိသမျှလို့ဟ သန့်ဆှင်းသော ဝိညာဉ်တော်တည်းဟူသော လက်ဆောင်ဟို လူမျိုးခြားလို့ အပေါ်နှိုက်လည်း သွန်းလောင်းလဲ့အတွက် ရမ်းဆာ့ အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ပစာကို့ သူလို့ဟ အခြားသော ဘာသာစကားများ ပြောလျက် ဘုရားသခင်ဟို ချီးမွန်းကြတာဟို သူလို့ ကြားကြသောကျောန့် ဖြစ်အယ်။ အဲအခါ ပေတရုက၊ ");
INSERT INTO dnv_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ဟေသူလို့ဟ ငါလို့လိုမျိုး သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ခံယူရဆိသောသူများ ဖြစ်ကြအယ်။ အေးလိုမို့ စသူဟ သူလို့ နှစ်ခြင်း ခံယူမှုဟို တားမြစ်နိန်သလော” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","အဲလိုမို့ သူဟ အေးသူလို့အား ယေရှု ခရစ်တော်ရဲ့ နာမတော်ဟို အမှီပြုယွေ့ နှစ်ခြင်းဟို ခံစေရန် အမိန့်ပေးလေအယ်။ အဲပင်းရင် ပေတရုအား မိမိလို့နဲ့အတူ ရက်အနည်းငယ် နေထိန်ရန် သူလို့ဟ ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","လူမျိုးခြားများဟ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ခံယူကြကျောန်း ယုဒပြေဆိ တမန်တော်များနဲ့ ညီအကိုများ ကြားသိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ယေရုရှလင်မြို့သို့ ပေတရု ရောက်လာသောအခါ၊ အရေဖျားလှီးခြင်း ခံထားသော ယုံကြည်သူများဟ သူ့ဟို ဝေဖန်ကြကာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“နင်ဟ အရေဖျားလှီးခြင်းဟို မခံသောသူရဲ့ အိုင်ဟို ဝင်ယွေ့ သူလို့နဲ့အတူ စားသောက်အယ် ဟုတ်မောင့်လဲ့” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","အေးလိုမို့ ပေတရုဟ သူလို့အား ဖြစ်ပျက်ခဲ့သမျှသော အကျောန်းအရာလို့ဟို အစမှ အဆုံးတိုင်အောန် ဆှင်းလင်းပြောပြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ငါဟ ယုပ္ပေမြို့တွင် ဆုတောင်းလျက်နေခါ၊ ဗျာဒိတ်ရူပါရုံ တခုဟို ရအယ်။ ရွက်ထည်နဲ့တူသော အရာတခုဟို ထောင့်လေးထောင့်မှ ထိန်းထားယွေ့ မိုးခေါန်းခင်မှ လျောကျလာပင်း ငါဆေဟို ရောက်လာတာဟို ငါ မျော်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ငါဟ အဲအရာထဲဟို ကျေ့လိုက်ရာ မြေကြီးပေါ်ဆိ ခြေလေးချောင်း သတ္တဝါများ၊ သားရဲတိရစ္ဆာန်များ၊ တွားတတ်သောသတ္တဝါများနဲ့ ခေါန်းခင်ငက်များဟို မျော်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","အဲပင်းရင် ‘ပေတရု ထယွေ့ သတ်စားလော’ ဟု ငါ့အား ပြောသောအသံဟို ငါ ကြားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","အဲလိုလဲ ငါဟ ‘သခင်ဘုရား၊ စလိုနည်းနဲ့မျှ မဖြစ်နိန်ပါ။ စုတ်ပဲ့သောအရာ အဲဟာမဟုတ်ရင် မသန့်ဆှင်းသောအရာဟို ပစာအခါမျှ ငါ့စလောင်အတွင်း မဝင်ဖူးပါ’ ဟု ပြန်ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ဒုတိယအကြိမ် ခေါန်းခင်မှ အသံထွက်ပေါ်လာယွေ့ ‘ဘုရားသခင် သန့်စင်အယ် ဆိုလဲ့အရာဟို စုတ်ပဲ့တာဟု မဆိုရ’ ဟူယွေ့ မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ဟေလို့ သုံးကြိမ်တိတိ ဖြစ်ပျက်ပင်း၊ နောက်ဆုံးမှာ အားလုံးလို့ဟို မိုးခေါန်းခင်ဟို ပြန်လည်ရုပ်သိမ်း သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","အဲခုတင်ချင်း ကဲသရိမြို့မှ ငါ့ဆေဟို စေလွှတ်လိုက်သော လူသုံးယောက်ဟ ငါဆိရာနေအိုင်ဟို ရောက်ဆိလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ဝိညာဉ်တော်ဟ အေးသူလို့နဲ့အတူ မဆိုင်းမတွဘဲ တခါထဲ လိုက်သွားရန် ငါ့အား အမိန့်ဆိအယ်။ ယုပ္ပေမြို့မှ ညီအကို ခြောက်ယောက်လို့ဟလည်း ကဲသရိမြို့ဟို ငါနဲ့အတူ လိုက်ခဲ့ကြပင်း ငါလို့ဟလည်း ကော်နေလိရဲ့ အိုင်ဟို ဝင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","အေးသူဟ ခေါန်းခင်တမန်သည် သူ့အိုင်ထဲတွင် ရပ်လျက် ‘ယုပ္ပေမြို့ဟို လူလွှတ်ယွေ့ ရှိမုန် ပေတရုဟု ခေါ်သောသူဟို ဖိတ်ခေါ်လော့။ ");
INSERT INTO dnv_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","အဲသူဟ နင့်နဲ့ နင့်ရဲ့ အိုင်သူအိမ်သားများအား ကယ်တင်ခြင်း ရဆိစေမဲ့ကျောန်း တရားစကားများဟို ဟောပြောလိမ့်မယ်’ ဟူယွေ့ မြွက်ဆိုကျောန်းဟို ငါလို့အား ပြောပြခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","အဲပင်းရင် ငါဟ စကားစပြောသောအခါ၊ သန့်ဆှင်းသော ဝိညာဉ်တော်သည် အစကတည်းဟ ငါလို့အပေါ်ဟို သက်ရောက်သလိုမျိုး အေးသူလို့အပေါ်လည်း သက်ရောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","အဲအခါ ‘ယောဟန်ဟ ယေဖြင့် နှစ်ခြင်း ပေးအယ်၊ အဲလိုလဲ နင်လို့ဟ သန့်ဆှင်းသော ဝိညာဉ်တော်ဖြင့် နှစ်ခြင်းဟို ခံရကြလိမ့်မယ်’ ဟူသော ဘုရားသခင်ရဲ့ စကားတော်ဟို ငါ သတိရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","အဲလိုမို့ ဘုရားသခင်ဟ သခင် ယေရှု ခရစ်တော်ဟို ယုံကြည်သူ ငါလို့အား ပေးသနားသလိုမျိုး လူမျိုးခြားလို့ဟိုလည်း တူညီသော လက်ဆောင်ဟို ပေးရင် ငါဟ စလိုလူဖြစ်ယွေ့ ဘုရားသခင်ဟို တားဆီးနိန်မလုန်း” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","အဲစကားဟို ကြားသောအခါ အေးသူလို့ဟ ပစ်တင် ဝေဖန်မှုဟို မပြုကြတော့ဘဲ “ဘုရားသခင်ဟ လူမျိုးခြားလို့အားလည်း နောင်တရယွေ့ အသက်ဆှင်ခွင့်ဟို ပေးလေအယ်” ဟု ဆိုယွေ့ ဘုရားသခင်ရဲ့ ဂုဏ်တော်ဟို ချီးမွန်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","သတေဖန် အသတ်ခံရမှုနဲ့ ဆက်စပ်ယွေ့ ဖြစ်ပေါ်လာသော ညှဉ်းဆဲမှုကျောန့် အရပ်ရပ်သို့ ကွဲလွင့်သွားကြသော ယုံကြည်သူအချို့လို့ဟ ဖိနိတ်ပြေ၊ ကုပရုကျွန်း၊ အန္တိအုတ်မြို့ တိုင်အောန် သွားကြအယ်။ သူလို့ဟ နှုတ်ကပတ်တရားတော်ဟို ယုဒအမျိုးသားလို့ဟိုသာ ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","အဲလိုလဲ သူလို့တွင် ကုပရုပြေနဲ့ ကုရေနေပြေမှ လူအချို့ပါယွေ့ သူလို့ဟ အန္တိအုတ်မြို့သို့ သွားပင်း လူမျိုးခြားလို့အားလည်း သခင် ယေရှုရဲ့ အကျောန်း သတင်းကောင်းဟို ဟောပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ဘုရားသခင်ရဲ့ တန်ခိုးတော်ဟ သူလို့နဲ့အတူ ဆိသဖြင့် လူအမြောက်အများပင် ယုံကြည်ယွေ့ သခင်ဘုရားဆေ ပြောင်းလဲလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ဟေသတင်းအကျောန်းဟို ယေရုရှလင်မြို့ဆိ အသင်းတော်ဟ ကြားရင် ဗာနဗအား အန္တိအုတ်မြို့ဟို စေလွှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","သူဟ ရောက်လာသောအခါ လူလို့အား ဘုရားသခင် စလို ကောင်းချီးပေးတာဟို မျော်သောအခါ ရွှင်လန်းဝမ်းသာသဖြင့် သခင်ဘုရားအား စိတ်နေလုံး အကြွင်းမဲ့ ယုံကြည်ကိုးစားယွေ့ သစ္စာစောင့်ကြရန် တိုက်တွန်းနှိုးဆော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ဗာနဗဟ သူတော်ကောင်း ဖြစ်ယွေ့ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ လည်းကောင်း၊ ယုံကြည်ခြင်းနဲ့ လည်းကောင်း ပြေ့ဝသဖြင့် ရမ်းဆာ့သော သူလို့အား သခင်ဘုရားဆေ ပြောင်းလဲလာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","အဲပင်းရင် ဗာနဗဟ ရှောလုဟို ဆာရန် တာရှုမြို့ဟို သွားအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","သူ့ဟို တွေ့သောအခါ အန္တိအုတ်မြို့သို့ ခေါ်ခဲ့အယ်။ အဲလို့မို့ ရှောလုနဲ့ ဗာနဗလို့ဟ တနှစ်ပတ်လုံး အသင်းတော်နဲ့ တွေ့ဆုံလျက် ရမ်းဆာ့သော လူလို့ဟို သွန်သင်ကြအယ်။ တဘဲ့တော်လို့ဟ အန္တိအုတ်မြို့ ခရစ်ယာန်ဟု ပထမဆုံးအကြိမ် ခေါ်ဝေါ်ခြင်းဟို ခံကြရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","အဲအခါကာလနှိုက် ပရောဖက်အချို့လို့ဟ ယေရုရှလင်မြို့မှ အန္တိအုတ်မြို့ဟို လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","အဲသူလို့အနက် အာဂဗု နာမယ်ဆိသော သူဟ ထယွေ့ ကမ္ဘာတဝှမ်းလုံးတွင် အစားအစာ ငတ်မွတ်ခေါင်းပါးခြင်း ဘေးကြီး သက်ရောက်လိမ့်မယ်ဟု ဝိညာဉ်တော်အားဖြင့် ကြိုတင် ဟောပြောလေအယ်။ အေးဘေးဟ ဧကရာဇ် ကလောဒိ လက်ထက်နှိုက် ဖြစ်ပျက်ခဲ့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","တဘဲ့တော်လို့ဟ အသီးသီး တတ်နိန်လဲ့အတိုင်း ယုဒပြေတွင် နေထိန်ကြသော ညီအကိုများအား ကူညီ ထောက်ပံ့ပေးရန် ဆုံးဖြတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ဟေသို့ ဆုံးဖြတ်ကြပင်းနောက် ထောက်ပံ့ငွေများဟို ဗာနဗနဲ့ ရှောလုမှ တဆင့် အသင်းတော် လူကြီးများဆေဟို ပို့ပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","အဲအချိန်ကာလနှိုက် ဘုရင် ဟေရုဒ်ဟ အသင်းတော်ဝင် အချို့လို့ဟို စတင် ညှဉ်းဆဲရန် ကြံစည် အားထုတ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","သူဟ ယောဟန်ရဲ့ အကိုဖြစ်သော ယာကုပ်ဟို ထားဖြင့် ကွပ်မျက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","အဲအမှုဟို ယုဒအမျိုးသားလို့ နှစ်သက်ကြကျောန်း မျော်သောအခါ၊ သူဟ ထပ်ယွေ့ ပေတရုဟိုလည်း ဖမ်းဆီးရန် စီစဉ်ကြအယ်။ အဲအချိန်ဟ တဆေးမဲ့မုန့် ပွဲတော်အခါ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ဟေရုဒ်ဟ ပေတရုဟို ဖမ်းဆီးယွေ့ ထောင်ထဲ ထည့်ထားပင်းနောက်၊ အဲမှာ သူ့ဟို စောင့်ကျေ့ရန် အစောင့်တပ်သား လေးယောက်စီပါသော တပ်စုငယ် လေးစုလက်သို့ အပ်ထားအယ်။ ဟေရုဒ်ဟ ပသခါပွဲ လွန်သောအခါ သူ့ဟို လူထုဆေ့တွင် ထုတ်ရန် အကြံဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","အေးလိုမို့ ပေတရုဟ ထောင်ထဲမှာ ထိန်းသိမ်းထားခြင်း ခံရအယ်၊ အဲလိုလဲ အသင်းတော်ဝင် အပေါင်းလို့ဟ ပေတရုအတွက် စိတ်အားထက်သန်စွာ ဘုရားသခင်ဆေ ဆုတောင်းလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ဟေရုဒ်မင်းဟ ပေတရုဟို လူလို့ဆေ့ဟို ခေါ်ထုတ်မယ့်နေ့ မရောက်ခင် ညနှိုက်၊ ပေတရုဟ အစောင့်တပ်သား နေယောက်ကြားတွင် အိပ်မွေလျက် နေအယ်။ သူ့ဟို သူလို့ နေယောက်နဲ့အတူ သံကြိုးနေချောင်းဖြင့် တုတ်ချေထားပင်း၊ အဲထောင် ထင်ခါးဆေ့တွင်လည်း အစောင့်တပ်သားများဟ စောင့်ကြပ်လျက် ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ထာဝရဘုရားရဲ့ ခေါန်းခင်တမန်ဟ ရုတ်တရက် ပေါ်လာယွေ့ အချုပ်ခန်းထဲနှိုက် အလင်းရောင် ထွန်းလင်းလျက် နေအယ်။ ခေါန်းခင်တမန်ဟ ပေတရုရဲ့ ပခုံးဟို ပုတ်ယွေ့ သူ့ဟို နှိုးကာ “မြန်မြန်ထလော” ဟု ဆိုအယ်။ အဲအခါ သံကြိုးလို့ဟ ပေတရုရဲ့ လက်မှ ကျွတ်ကျအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","အဲပင်းရင် ခေါန်းခင်တမန်ဟ “နင့်ရဲ့ ခါးပန်းဟို စဲယွေ့ ဖိနပ်ဟို စီးလော” ဟု ဆိုအယ်။ ပေတရုဟ အေးလို့ ပြောလဲ့အတိုင်း ပြုအယ်။ အဲပင်းရင် ခေါန်းခင်တမန်ဟ သူ့အား “နင်ရဲ့ ဝတ်လုံဟို ခြုံယွေ့ ငါ့နောက်ဟို လိုက်လော့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ပေတရုဟ အချုပ်ခန်းမှ ထွက်ယွေ့ သူ့နောက် လိုက်သွားလေအယ်၊ အဲလိုလဲ ခေါန်းခင်တမန်အားဖြင့် ဖြစ်ပျက်နေသောအရာဟ အမန်တကယ်ဖြစ်ကျောန်း မသိဘဲ ရူပါရုံဟို မျော်နေအယ်ဟုသာ သူ ထင်မှတ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","သူလို့ဟ ကင်းစောင့်ထားချရာ ပထမနေရာနဲ့ ဒုတိယနေရာလို့ဟို ပွန်သွားပင်းရင် မြို့ဟို သွားလဲ့ သံထင်ခါးဟို ရောက်လာကြအယ်။ အဲထင်ခါးဟ သူလို့အတွက် တတ်တိုင်း ပွင့်သဖြင့် သူလို့ဟ ထွက်လာကြအယ်။ သူလို့ဟ လမ်းအတိုင်း လိုက်သွားကြပင်း ခေါန်းခင်တမန်ဟ ပေတရုနားမှ ခုတင်ချင်း ထွက်ခွာ သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","အဲအခါ ပေတရုဟ သူနှိုက် ပစာဖြစ်တာဟို သတိ ပြန်ဝင်လာယွေ့ “သခင်ဘုရားဟ မိမိရဲ့ ခေါန်းခင်တမန်ဟို စေလွှတ်ယွေ့ ငါ့ဟို ဟေရုဒ်ရဲ့ လက်မှလည်းကောင်း၊ ယုဒအမျိုးသားလို့ရဲ့ မျှော်လင့်သမျှသော အရာအားလုံးမှလည်းကောင်း ငါ့ဟို ကယ်နုတ်တာဟို အခု ငါ အမန်တကယ် သိပီ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","သူ့အခြေအနေဟို သတိထားမိသောအခါ၊ သူဟ မာကုဟု ခေါ်လဲ့ ယောဟန်ရဲ့ အမေ့ဖြစ်သော မာရိရဲ့ နေအိုင်ဟို သွားအယ်၊ အဲနေအိုင်တွင် ရမ်းဆာ့လူများ စုဆုံယွေ့ ဆုတောင်းလျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ပေတရုဟ အပြင်ဘက်ဟနေ ထင်ခါးဟို ခေါက်ရာ၊ ရောဒေ နာမယ်ဆိသူ အစေခံမိန်းမငယ် တယောက်ဟ မေးရန် လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","သူဟ ပေတရုရဲ့ အသံဟို မှတ်မိယွေ့ ရမ်းဆာ့ ဝမ်းမြောက်စွာဖြင့် ထင်ခါးဟို မဖွင့်ဘဲ နေအိုင်ထဲဟို ပြေးဝင်ကာ ထင်ခါးဆေ့တွင် ပေတရု ရပ်နေကျောန်းဟို ပြောကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","အဲသူလို့ဟ “နင် ရူးနေပီ” ဟု ဆိုအယ်။ အဲလိုလဲ သူဟ မိမိပြောလဲ့အတိုင်း အမန်ပင်ဖြစ်ကျောန်း ခိုင်မာစွာ ပြောဆိုနေသဖြင့် သူလို့ဟ “အဲသူသည် ပေတရုရဲ့ ခေါန်းခင်တမန် ဖြစ်လိမ့်မယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","အဲလိုလဲ ပေတရုဟ ထင်ခါးဟို ခေါက်မြဲခေါက်လျက် နေသဖြင့် သူလို့ဟ ထင်ခါး ဖွင့်လိုက်သောအခါ ပေတရုဟို မျော်သဖြင့် အံ့ဩကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ပေတရုဟ သူလို့ဟို တိတ်တိတ်နေကြရန် လက်ရိပ်ပြပင်း၊ မိမိအား သခင်ဘုရားဟ စလိုထောင်ထဲမှ ထုတ်ဆောင်လာကျောန်းဟို ပြောပြလေအယ်။ အဲပင်းရင် “ဟေအကျောန်းဟို ယာကုပ်နဲ့ အခြား ညီအကိုလို့အား ပြောပြကြပါ” ဟု မှာကြားပင်း အခြားအရပ်ဟို ထွက်ခွာသွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","မိုးလင်းသောအခါ ပေတရု စလို ဖြစ်သွားလုန်းဟု အစောင့်တပ်သားလို့ ကြားတွင် အကြီးအကျယ် ရုတ်ရုတ်သဲသဲ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ဟေရုဒ်မင်းဟ ပေတရုဟို ဆှာစေရန် အမိန့်ပေးပေမဲ့လည်း သူ့ဟို မတွေ့ကြ။ အဲလိုမို့ အစောင့်တပ်သားလို့အား စစ်ဆေးမေးမြန်းယွေ့ သေဒဏ်ပေးရန် အမိန့်ချမှတ် လိုက်လေအယ်။ အဲပင်းရင် ဟေရုဒ်မင်းဟ ယုဒပြေမှ ထွက်ခွာယွေ့ ကဲသရိမြို့တွင် ကာလအနည်းငယ် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ဟေရုဒ်မင်းဟ တုရုမြို့သားများနဲ့ ဇိဒုန်မြို့သားလို့အပေါ် ရမ်းဆာ့ အူထော့သဖြင့် အဲမြို့သားလို့ဟ စုရုံးလျက် မင်းကြီးဆေဟို လာရောက်ကြအယ်။ ပထမဆုံး နန်းတော်ဟို စီမံရသောသူ ဗလတ္တုဟို စည်းရုံးပင်း သူ့ရဲ့ အကူအညီဟို ရယူကြအယ်။ အဲပင်းရင် ဟေရုဒ်မင်းကြီး ဆေသို့ ဝင်ယွေ့ ငြိမ်သက်စေမဲ့အကျောန်း တောင်းပန်ကြအယ်။ ပစာကို့ သူလို့ရဲ့ ပြေဟ ဟေရုဒ်မင်းရဲ့ ပြေဟို မှီခို စားသောက်ရသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ဟေရုဒ်မင်းဟ ချိန်းချက်ထားလဲ့နေ့နှိုက် မင်းမြောက်တန်ဆာများဟို ဝတ်ဆင်ပင်း ရာဇပလ္လင်ပေါ်တွင် ထိန်လျက် အေးလူလို့အား မိန့်ခွန်းမြွက်ကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","အဲသူလို့ဟ “ဟေအသံဟ လူရဲ့ အသံ မဟုတ်၊ ဘုရားသခင်ရဲ့ အသံ ဖြစ်အယ်” ဟု ကြွေးကြော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ဟေရုဒ်ဟ ဘုရားသခင်ရဲ့ ဂုဏ်တော်ဟို မချီးမွန်းသောကျောန့် ခုတင်ချင်း ထာဝရဘုရားရဲ့ ခေါန်းခင်တမန်ဟ သူ့ဟို ဒဏ်ခတ်ယွေ့ ကိုယ်တွင်းနှိုက် ပိုးများ ကိုက်သဖြင့် အနိစ္စရောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","အဲအချိန်တွင် ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားဟ ဆက်လက်ပင်း ပျံ့နှံ့ယွေ့ တိုးပွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ဗာနဗနဲ့ ရှောလုဟ မိမိလို့ ဆောင်ရွက်ရန်ဆိလဲ့ အလုပ်ကိစ္စများဟို ဆောင်ရွက်ကြပင်းနောက် မာကုဟု ခေါ်လဲ့ ယောဟန်ဟိုလည်း ခေါ်ခဲ့ယွေ့ ယေရုရှလင်မြို့မှ ပြန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","အန္တိအုတ်မြို့ အသင်းတော်တွင် ဗာနဗ၊ နိဂါ ခေါ်သော ရှုမောင်၊ ကုရေနေ ပြေမှ လုကိ၊ စော်ဘွားဟေရုဒ်နဲ့ သူငယ်ချင်းဖြစ်သူ မာနင်နဲ့ ရှောလု စသော ပရောဖက်များနဲ့ ဆရာများ ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","အဲသူလို့ဟ သခင်ဘုရားရဲ့ အမှုတော်ဟို ဆောင်ရွက်ယွေ့ အစာဆှောင်လျက် နေကြစဉ် သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ သူလို့အား “ရှောလုနဲ့ ဗာနဗလို့ဟို သူလို့အတွက် သတ်မှတ်ထားသော အမှုတော်ဆောင်ရန် ငါ့အတွက် သီးသန့် ရွေးချယ်ကြလော့” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","အဲအခါ သူလို့ဟ အစာဆှောင်ယွေ့ ဆုတောင်းကြကာ အေးသူလို့နေဦးလို့အပေါ် လက်တင်ပင်းနောက် သူလို့ဟို စေလွှတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","အဲလိုမို့ သူလို့ဟ သန့်ဆှင်းသော ဝိညာဉ်တော် စေလွှတ်လဲ့အတိုင်း သေလုကိမြို့ဟို သွားရောက်ယွေ့ အဲမြို့မှ ကုပရုကျွန်းဟို သင်္ဘောလွှင့်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","သူလို့ဟ ရှာလမိမြို့ဟို ရောက်သောအခါ၊ ယုဒတရားဇရပ်များတွင် ဘုရားသခင်ရဲ့ နှုတ်ကပတ် တရားတော်ဟို ဟောပြောကြအယ်။ မာကုဟု ခေါ်လဲ့ ယောဟန်ဟိုလည်း အကူအညီပေးသူအဖြစ် သူလို့နဲ့အတူ ခေါ်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","သူလို့ဟ အဲကျွန်းဟို ဖြတ်ယွေ့ ပါဖုမြို့အထိ ဆှောက်သွားပင်း၊ အဲမြို့တွင် ယုဒအမျိုးသား မိစ္ဆာပရောဖက်ဖြစ်သော ဗာယေရှု နာမယ်ဆိသော မှော်ဆရာတယောက်ဟို တွေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","သူဟ ဉာဏ်ထက်မြက်သူ တဦးဖြစ်လဲ့ ကျွန်းရဲ့ အုပ်ချုပ်ရေးမှူး သေရဂိပေါလုနဲ့ မိတ်ဆွေ ဖြစ်အယ်။ အေးအုပ်ချုပ်ရေးမှုးဟ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ကြားနာလိုသောကျောန့် သူရဲ့ ဆေ့ဟို ဗာနဗနဲ့ ရှောလုဟို ဖိတ်ခေါ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","အဲလိုလဲ ဟေလသဘာသာအားဖြင့် ဧလုမဟု နာမယ်ဆိသော မှော်ဆရာဟ အုပ်ချုပ်ရေးမှူးအား ယုံကြည်ခြင်း လွှဲမားစေရန် ဗာနဗနဲ့ ရှောလုလို့ဟို ဟန့်တားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","အဲအခါ ပေါလုဟုလည်း ခေါ်သော ရှောလုဟ သန့်ဆှင်းသော ဝိညာဉ်တော်ဖြင့် ပြေ့ဝလျက် မှော်ဆရာဟို စေ့စေ့ကျေ့ရှုပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“စဉ်းလဲခြင်းအပေါင်းနဲ့ လှည့်စားမှု ဆိသမျှလို့ဖြင့် ပြေ့ဝသူ၊ မာရ်နတ်ရဲ့ သား၊ ဖြောင့်မတ်ခြင်း အပေါင်းလို့ရဲ့ ရန်သူ၊ နင်ဟ ထာဝရဘုရားရဲ့ ဖြောင့်မတ်သောလမ်းဟို ကွေ့ကောက်အောန် လုပ်ခြင်းမှ မရပ်တန့်ဘဲ နေမလော။ ");
INSERT INTO dnv_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ထာဝရဘုရားရဲ့ လက်တော်ဟ နင်အပေါ်ဟို အခု ကျရောက်သဖြင့်၊ နင်ဟ မျက်စေ့ကန်းပင်း ကာလအတန်အကြာ နေရဲ့ အလင်းရောင်ဟို တောင်မှ မျော်ရလိမ့်မယ် မဟုတ်” ဟု ဆိုအယ်။ ခုတင်ချင်း မှုန်ဝါးခြင်းနဲ့ မိုက်ခြင်းလို့ဟ ဧလုမအပေါ်ဟို ကျရောက်သဖြင့် သူဟ လက်ဆွဲယွေ့ ယိုးပေးမယ့်သူ တယောက်ယောက်ဟို ဆှာလျက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","အုပ်ချုပ်ရေးမှုးဟ အဲအဖြစ်အပျက်ဟို မျော်သောအခါ ယုံကြည်လာအယ်၊ အကျောန်းမှာ သူဟ ဘုရားသခင်အကျောန်း သွန်သင်ချက်များဟို အံ့ဩမိန်းမောနေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ပေါလုနဲ့ အပေါင်းအဖော်များဟ ပါဖုမြို့မှ သင်္ဘောလွှင့်ယွေ့ ပမ်ဖုလိပြေ ပေရဂေမြို့သို့ ရောက်ပင်း အဲမှာ မာကုဟု ခေါ်လဲ့ ယောဟန်ဟ သူလို့နဲ့ ခွဲခွာယွေ့ ယေရုရှလင်မြို့ဟို ပြန်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","သူလို့ဟ ပေရဂေမြို့မှ ထွက်ခွာကြရာ ပိသိဒိပြေ အန္တိအုတ်မြို့ဟို ရောက်ယွေ့ ဥပုသ်နေ့နှိုက် တရားဇရပ်သို့ ဝင်ယွေ့ ထိန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ပညတ်ကျမ်းနဲ့ ပရောဖက်ကျမ်းဟို ဖတ်ရွတ်ပင်းမှ၊ တရားဇရပ် အုပ်ချုပ်ရေးမှူးဟ သူလို့ဆေ လူလွှတ်ယွေ့ “ညီအကိုလို့၊ လူလို့အတွက် တိုက်တွန်းအားပေးစကား ပြောစရာဆိရင် ပြောကြပါ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ပေါလုဟ နေရာမှ ထယွေ့ လက်ရိပ်ပြလျက်၊ “ဣသရေလအမျိုးသားလို့နဲ့ ဘုရားသခင်အား ကိုးကွယ်သော လူမျိုးခြားလို့ ငါ့စကားဟို နားထောင်ကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ဣသရေလအမျိုးသားလို့ရဲ့ ဘုရားသခင်ဟ ငါလို့ဖိုးဖေးများဟို ရွေးကောက်ယွေ့ အဲဂုတ္တုပြေတွင် ဧည့်သည်ဖြစ်နေထိန်စဉ် အဲလူမျိုးဟို ချီးမြှောက်အယ်။ အားကြီးသော လက်တော်အားဖြင့် သူလို့ဟို အေးပြေမှ ထုတ်ဆောင်ပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","တောကန္တာရတွင် အနှစ်လေးဆယ်ပတ်လုံး သူလို့အား သည်းခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","အဲပင်းရင် ခါနာန်ပြေနှိုက် လူခုနစ်မျိုးလို့ဟို ဖျက်ဆီးပင်း သူလို့ပြေဟို မိမိလူလို့အား အမွေအဖြစ် ခွဲဝေပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","အဲအကျောန်းအရာလို့ဟ နှစ်ပေါင်း လေးရာငါးဆယ် ကြာခဲ့အယ်။ “အဲပင်းရင်ပရောဖက် ရှမွေလခေတ်တိုင်အောန် တရားသူကြီးများဟို ဘုရားသခင်ဟ သူလို့အား ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","အဲပင်းရင် သူလို့ဟ ဘုရင်ဟို တောင်းဆိုကြသဖြင့် ဘုရားသခင်ဟ ကိရှရဲ့သား ဗင်္ယာမိန်အနွယ်ဝင် ရှောလုဟို အနှစ်လေးဆယ်ပတ်လုံး အုပ်ချုပ်ရန် သူလို့အား ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","အဲပင်းရင် ရှောလုဟို ဖယ်ဆှားပင်းရင် ဒါဝိဒ်အား သူလို့ရဲ့ ဘုရင်အဖြစ် ချီးမြှောက်အယ်။ ဘုရားသခင်ဟ သူနဲ့ ပတ်သက်ယွေ့ သက်သေခံတာဟ ‘ငါရဲ့ စိတ်တော်နဲ့ တွေ့သူ ယေရှဲရဲ့ သားဒါဝိဒ်ဟို ငါ တွေ့ပီ၊ သူဟ ငါ့ရဲ့ အလိုသမျှလို့ဟို ဆောင်ရွက်လိမ့်မယ်’ ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ဘုရားသခင်ဟ မိမိရဲ့ ကတိတော်အတိုင်း ဣသရေလအမျိုးသားလို့အဖို့ ကယ်တင်ဆှင် ယေရှုဟို အေးသူရဲ့ သားမြေးလို့ထဲမှ ပေါ်ထွန်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ယေရှု မကြွလာခင် ယောဟန်ဟ ဣသရေလအမျိုးသား အပေါင်းလို့အား မိမိလို့အပစ်မှ နောင်တရယွေ့ နှစ်ခြင်းဟို ခံရန် ဟောပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ယောဟန်ဟ မိမိဆောင်ရွက်ရမဲ့အမှု ပီးဆုံးချိန် နီးသောအခါ၊ သူဟ လူလို့အား ‘နင်လို့ဟ ငါ့ဟို စသူ ဖြစ်အယ်ဟု ထင်မှတ်ကြသလော၊ ငါဟ နင်လို့ စောင့်မျှော်နေလဲ့ အဆှင် မဟုတ်။ အဲလိုလဲ နားထောင်လော့၊ အဲအဆှင်ဟ ငါ့နောက်တွင် ကြွလာပင်း ငါဟ အေးအဆှင်ရဲ့ ဖိနပ်ဟိုမျှ မချွတ်ထိုက်’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“အာဗြဟံရဲ့ သားမြေးဖြစ်သူ ငါ့ ဣသရေလအမျိုးသားလို့နဲ့ ဘုရားသခင်ဟို ကိုးကွယ်သော လူမျိုးခြားလို့ ဟေကယ်တင်ခြင်း သတင်းစကားဟ ငါလို့ဆေဟို ပေးပို့ခြင်း ခံရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","အကျောန်းမှာ ယေရုရှလင်မြို့တွင် နေထိန်ကြသော လူများနဲ့ သူလို့ရဲ့ ခေါင်းဆောင်များမှာ ကိုယ်တော်ဟ ကယ်တင်ဆှင်ဖြစ်ကျောန်းဟို မသိကြ၊ ဥပုသ်နေ့တိုင်း ဖတ်ကြလဲ့ ပရောဖက်လို့ရဲ့ စကားဟိုလည်း နားမလည်ကြ။ အဲလိုလဲ ယေရှုဟို သေဒဏ် စီရင်ကြခြင်းအားဖြင့် အဲသူလို့ဟ ပရောဖက်များရဲ့ စကားများဟို ပြေ့စုံလာစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","အေးလို့ သူလို့ဟ ကိုယ်တော်နှိုက် သေဒဏ်စီရင်ထိုက်သော အပစ်တစုံတရာဟိုမျှ မတွေ့သော်လည်း၊ သူလို့ဟ ကိုယ်တော်ဟို သေဒဏ်ပေးရန် ပိလတ်မင်းအား တောင်းဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","သူလို့ဟ အဲအဆှင်နဲ့ ပတ်သက်ယွေ့ ကျမ်းစာတွင် ပါဆိသမျှသောအရာလို့ဟို ပြုကြပင်းနောက်၊ သူလို့ဟ ကိုယ်တော်ရဲ့အလောင်းတော်ဟို လက်ဝါးကပ်တိုင်မှ ချယွေ့ လုတ်တိုင်းဂူတွင် သင်္ဂြိုဟ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","အဲလိုလဲ ဘုရားသခင်ဟ သူ့ဟို သေခြင်းမှ ဆှင်ပြန်ထမြောက်စေအယ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","အဲပင်းရင် အေးအဆှင်ဟ ဂါလိလဲပြေမှ ယေရုရှလင်မြို့သို့ မိမိနဲ့အတူ သွားလာကြသူလို့အား ရက်ပေါင်းများစွာ ကိုယ်ထင်ပြအယ်။ အခု သူလို့ဟ ဣသရေလ လူများဆေတွင် ကိုယ်တော်ရဲ့ အသိသက်သေများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","ငါလို့ဟ သတင်းကောင်းဟို နင်လို့ဆေ ယူဆောင်လာအယ်၊ ဘုရားသခင်ဟ ယေရှုဟို ဆှင်ပြန်ထမြောက်စေသဖြင့် ငါလို့ဖိုးဖေးလို့အား ပေးသော ကတိဟို သူလို့ရဲ့ သားမြေးများဖြစ်သူ ငါလို့အတွက် လုပ်ဆောင်ခဲ့ပီးပီ။ ဟေစာဟ ဒုတိယမြောက်သော ဆာလံကျမ်းနှိုက်၊ “ ‘နင်ဟ ငါရဲ့ သားတော် ဖြစ်အယ်။ ခုနေ့ပင် နင့်အား သားအရာဟို ငါ ပေးပီ’ ဟု ရေးထားလဲ့အတိုင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ကိုယ်တော်ဟို သေခြင်းမှ ထမြောက်စေမဲ့အကျောန်း၊ လုတ်တိုင်းထဲတွင် ဖယ်တော့မှ ပုပ်ခြင်းဟို မရောက်စေမဲ့အကျောန်းနဲ့ ပတ်သက်ယွေ့ ဘုရားသခင်ဟ၊ ‘ငါဟ ဒါဝိဒ်ဟို ကတိပေးထားလဲ့ မြင့်မြတ်ပင်း သေချာသော ကောင်းချီးဟို နင်လို့အား ငါ ပေးမယ်’ ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","အဲလိုမို့ အခြားသော ကျမ်းပိုဒ်တွင်၊ ‘ကိုယ်တော်ရဲ့ သန့်ဆှင်းသောသူအား လုတ်တိုင်းတွင်းမှာ ပုပ်ခွင့်ပေးလိမ့်မယ် မဟုတ်’ ဟု ပိုပင်း ဆှင်းပြထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","အကျောန်းမှာ ဒါဝိဒ်ဟ မိမိလက်ထပ်နှိုက် ဘုရားသခင်ရဲ့ အကြံအစည်ဟို ဆောင်ရွက်ပင်း သေလွန်ယွေ့ မိမိဖိုးဖေးလို့ရဲ့ လုတ်တိုင်းတွင် သင်္ဂြိုဟ်ခြင်းဟို ခံလျက် သူရဲ့ ကိုယ်ခန္ဓာဟ လုတ်တိုင်းတွင် ပုပ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","အဲလိုလဲ သေခြင်းမှ ဘုရားသခင် ထမြောက်စေသောသူဟ အဲလိုမျိုး ပုပ်ခြင်း မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","အဲလိုမို့ ငါ့ မိတ်ဆွေလို့၊ ယေရှုအားဖြင့် အပစ်များ ခွင့်လွှတ်ခြင်း အကျောန်းဟို နင်လို့အား ငါ သိစေချင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","သူ့အားဖြင့် ယုံကြည်သူအပေါင်းလို့ဟ အပစ်တရားမှ လွှတ်ယွေ့၊ မောရှေရဲ့ ပညတ်တရားအားဖြင့် ဖြောင့်မတ်တာဟု အသိအမှတ်ပြုခြင်း မခံရနိန်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ပရောဖက်ကျမ်းများတွင် နင်လို့အား၊ ");
INSERT INTO dnv_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ငါ မိန့်တာဟို မထီမဲ့မြင်ပြုသူလို့ ကျေ့ရှုလော့။ အံ့ဩလျက် ပျက်စီးခြင်းဟို ရောက်ကြလော့။ အကျောန်းမှာ ငါဟ နင်လို့လက်ထက်နှိုက် အမှုတခုဟို ပြုလုပ်မယ်၊ တစုံတယောက်ဟ အေးအမှုဟို အကုန်ပြောပြသော်လည်း၊ နင်လို့ဟ ဖယ်တော့မှ ယုံကြည်ကြမှာ မဟုတ်’ ဟု မိန့်ထားသော အရာဟ နင်လို့အပေါ် မသက်ရောက်မဲ့ကျောန်း သတိပြုကြလော့” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","တရားဇရပ်မှ ပေါလုနဲ့ ဗာနဗလို့ ထွက်ခွာလာကြစဉ်၊ လူလို့ဟ သူ့အား နောက်ဥပုသ်နေ့နှိုက် ပြန်လာပင်း ဟေအကျောန်းအရာများဟို ထပ်ပြောရန် တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","အစည်းအဝေးမှ လူလို့ ထွက်လာပင်းနောက်၊ ရမ်းဆာ့သော ယုဒလူမျိုးများမှ စယွေ့ ယုဒဘာသာမှ ပြောင်းလဲလာသော ရမ်းဆာ့သော လူမျိုးခြားလို့ဟ ပေါလုနဲ့ ဗာနဗနောက်သို့ လိုက်ကြအယ်။ တမန်တော်လို့ဟ သူလို့အား ဘုရားသခင်ရဲ့ ကျေးဇူးတော်နှိုက် ဆက်လက် အသက်ဆှင်နေထိန်ရန် အားပေးတိုက်တွန်းလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","နောက်ဥပုသ်နေ့တွင် ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ကြားနာရန် မြို့လုံးကျွတ်နီးပါး လူလို့ လာရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","အဲလိုလဲ ယုဒအမျိုးသားလို့ဟ လူအုပ်ဟို မျော်သောအခါ၊ မနာလိုစိတ်နဲ့ ပြေ့သဖြင့် ပေါလု ပြောသောစကားများဟို ငြင်းခုံပင်း စော်ကားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","အဲအခါ ပေါလုနဲ့ ဗာနဗလို့ဟ ရဲရင့်စွာ ဟောကြားတာဟ “ငါလို့ဟ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို နင်လို့အား ပထမဆုံး ဟောပြောရမယ်။ အဲလိုလဲ နင်လို့ဟ တရားတော်ဟို ငြင်းပယ်ကာ မိမိလို့ကိုယ်ကို ထာဝရအသက်နဲ့ မထိုက်တန်ဟု စီရင်ကြသောကျောန့်၊ ငါလို့ဟ နင်လို့နားမှ ထွက်ခွာယွေ့ လူမျိုးခြားလို့ဆေဟို သွားကြမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","အကျောန်းမှာ ငါလို့အား ထာဝရဘုရားဟ “ ‘ကယ်တင်ခြင်း ကျေးဇူးဟို တကမ္ဘာလုံးဆိ ရဆိစေရန် နင်လို့အား လူမျိုးခြားများအတွက် အလင်းအဖြစ် ငါ ခန့်ထားအယ်’ ဟူယွေ့ မိန့်ခဲ့အယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","လူမျိုးခြားလို့ဟ အဲစကားဟို ကြားသောအခါ ရွှင်လန်းဝမ်းမြောက်ပင်း ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ချီးမွန်း ပြောဆိုကြအယ်။ ထာဝရ အသက်ရဆိရန် ရွေးကောက်ခြင်း ခံရသူလို့ဟ ယုံကြည်သူများ ဖြစ်လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","အေးလိုမို့ ဘုရားသခင်ရဲ့ တရားတော်ဟ အေးဒေသတဆှောက်လုံးတွင် နှံ့ပြားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","အဲလိုလဲ ယုဒအမျိုးသားလို့ဟ ဘုရားသခင်ဟို ကိုးကွယ်သူ အထက်တန်းလွှာ မိန်းမနဲ့ မြို့ရဲ့ ခေါင်းဆောင်များဟို လှုံ့ဆော်ကြအယ်။ သူလို့ဟ ပေါလုနဲ့ ဗာနဗလို့အား စတင် ညှဉ်းဆဲပင်း မိမိလို့ပြေရဲ့ နယ်မှ မောင်းထုတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","အဲလိုမို့ ပေါလုနဲ့ ဗာနဗလို့ဟ အေးသူလို့ရဲ့ ခြေဖဝါးမှ ဖုန်မှုန့်ဟို သတိပေးလဲ့နေနဲ့ ခါချခဲ့ပင်း ဣကောနိမြို့သို့ ထွက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","အန္တိအုတ်မြို့ဆိ တဘဲ့တော်လို့ဟ ရွှင်လန်းဝမ်းမြောက်ယွေ့ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ပြေ့ဝလျက် ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ဣကောနိမြို့တွင် ပေါလုနဲ့ ဗာနဗဟ ယုဒအမျိုးသားလို့ရဲ့ တရားဇရပ်သို့ ဝင်ယွေ့ အဲနည်းအတိုင်း ဟောပြောကြရာ ယုဒအမျိုးသားများနဲ့ လူမျိုးခြား အမြောက်အမြားဟ ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","အဲလိုလဲ မယုံကြည်ကြလဲ့ ယုဒအမျိုးသားလို့ဟ လူမျိုးခြားလို့ဟို သွေးထိုးလှုံ့ဆော်ယွေ့ ညီအကိုလို့အပေါ် မနာလိုစိတ် ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","တမန်တော်လို့ဟ အဲအရပ်တွင် ကြာမြင့်စွာ နေထိန်လျက် ဘုရားသခင်ရဲ့ အကျောန်းဟို ရဲရင့်စွာ ဟောပြောကြအယ်။ ကိုယ်တော်ဟ အေးသူလို့ ဟောပြောလဲ့ ကျေးဇူးတော်ဆိုင်ရာ တရားမန်ကန်ကျောန်း သက်သေပြရန် သူလို့အား အံ့ဩဖွယ်ရာများနဲ့ နိမိတ်လက္ခဏာများ ပြနိန်သောတန်ခိုးဟို ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","မြို့သူမြို့သားလို့ဟ နေစု ကွဲပြားကြအယ်၊ တချို့ဟ ယုဒအမျိုးသားလို့ဖက်ဟို ပါသွားယွေ့ အခြားတစုဟ တမန်တော်လို့ဖက်ဟို ပါသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ယုဒအမျိုးသားနဲ့ လူမျိုးခြားအချို့လို့ဟ တမန်တော်လို့ဟို ညှဉ်းဆဲရန်နဲ့ ခဲဖြင့် ပေါက်ရန် မိမိလို့ ခေါင်းဆောင်များနဲ့အတူ ကြံစည် အားထုတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","အဲအကျောန်းဟို တမန်တော်လို့ဟ ကြားသိကြသောအခါ လုကောနိပြေဆိ လုတ္တရမြို့၊ ဒေရဗေမြို့ အနီးဆိဒေသဟို ထွက်ပြေးယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","အဲအရပ်နှိုက် သတင်းကောင်းဟို ဟောပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","လုတ္တရမြို့တွင် မွေးစကပင် ခြေမသန်စွမ်းဖြစ်ခဲ့သူ၊ ဖယ်ခါကမှ လမ်းမဆှောက်နိန်ခဲ့သူ လူတယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","သူဟ ပေါလု ဟောပြောတာဟို ထိန်ယွေ့ နားထောင်လျက် နေအယ်။ ပေါလုဟ သူ့အား စေ့စေ့ကျေ့ယွေ့ ရောဂါပျောက်ကင်း စေနိန်လောက်အောန် သူ့မှာ ယုံကြည်ခြင်း ဆိကျောန်း မျော်ရင်၊ ");
INSERT INTO dnv_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“ထယွေ့ နင့်ခြေထောက်ဖြင့် မတ်တတ်ရပ်လော့” ဟု အေးသူအား အသံကျယ်ရီးနဲ့ ပြောအယ်။ အဲပင်းရင် သူဟ ထခုန်ပင်း စတင် လမ်းဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","လူအုပ်လို့ဟ ပေါလု ပြုသောအမှုအရာဟို မျော်သောအခါ၊ သူလို့ဟ စတင်ပင်း “နတ်ဘုရားလို့ဟ လူ့အသွင်ဟို ဆောင်ယွေ့ ငါလို့ဆေဟို သက်ဆင်းလာလေပီ” ဟု မိမိလို့ လုကောနိ ဘာသာစကားဖြင့် ကြွေးကြော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","သူလို့ဟ ဗာနဗအား ဇုသဟု ခေါ်ယွေ့၊ ပေါလုဟ ခေါင်းဆောင် ဟောပြောသူဖြစ်သောကျောန့် သူ့ဟို ဟေရမေဟု ခေါ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ဇုသနတ်ဘုရားရဲ့ ဗိမာန်ဟ မြို့ပြင်တွင် ဆိရာ အဲနတ်ဘုရားရဲ့ ယဇ်ပုရောဟိတ်ဟ နွားထီးများနဲ့ ပန်းကုံးများဟို မြို့ထင်ခါးဝသို့ ယူဆောင်လာပင်း၊ သူနဲ့တကွ လူပရိသတ်လို့ဟ တမန်တော်လို့အား ယဇ်ပူဇော်ပသချင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","အဲလိုလဲ ပူဇော်ကြမဲ့အကျောန်းဟို တမန်တော် ဗာနဗနဲ့ ပေါလုလို့ ကြားကြသောအခါ မိမိလို့ရဲ့ အဝတ်များဟို ဆုတ်ဖြဲယွေ့ လူပရိတ်သတ်လို့ အလယ်ဟို ပြေးသွားပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“မိတ်ဆွေလို့၊ နင်လို့ဟ ပစာကျောန့် ဟေလိုလုပ်ကြလုန်း။ ငါလို့ဟလည်း နင်လို့လိုမျိုးပင် သာမန်လူများသာ ဖြစ်ကြပင်း၊ နင်လို့ဟ ဟေလို အကျိုးမဆိလဲ့ အမှုအရာများဟို စွန့်ပစ်ယွေ့ မိုးခေါန်းခင်၊ မြေကြီးဟို လည်းကောင်း ပင်လယ်နဲ့ အရာခပ်သိမ်းတွင် ဆိလေသမျှသောအရာလို့ဟို လည်းကောင်း ဖန်ဆင်းသော အသက်ဆှင်သော ဘုရားသခင်ဆေ ပြောင်းလဲကြရန် နင်လို့အား သတင်းကောင်းဟို ဟောပြောနေသူများ ဖြစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","လွန်ခဲ့သောခေတ်ကာလများဟ ကိုယ်တော်ဟ လူမျိုးတကာလို့အား မိမိလို့ လမ်းစဉ်အတိုင်း ဆှောက်လှမ်းကြရန် အခွင့်ဟို ပေးခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","အဲလိုလဲ သူပြုသော ကောင်းသောအမှုအားဖြင့် ကိုယ်တော် တည်ဆိကျောန်း သက်သေဟို အမြဲ ပြခဲ့အယ်။ ကိုယ်တော်ဟ ခေါန်းခင်မှ မိုးဟို ရွာစေပင်း အချိန်တန်ရင် သီးနှံများဟို ဖြစ်ထွန်းစေကာ၊ အစားအစာ ပေးယွေ့ ရွှင်လန်းဝမ်းမြောက်ခြင်းလို့ဖြင့် နင်လို့ စိတ်နေလုံးဟို ပြေ့စေအယ်” ဟု ကြွေးကြော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","သူလို့ဟ အေးလို့ပြောဆိုလျက် မိမိလို့အား ပူဇော်ခြင်း မပြုကြရန် လူအုပ်များဟို ခဲယဉ်းစွာ တားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","အဲအခါ အန္တိအုတ်မြို့နဲ့ ဣကောနိမြို့လို့မှ ယုဒအမျိုးသား အချို့လို့ဟ ရောက်လာကြပင်း လူအုပ်လို့ဟို မိမိလို့ဖက်သို့ပါအောန် စည်းရုံးကာ ပေါလုဟို ကျောက်ခဲနဲ့ နှက်ယွေ့ သေပီဟု ထင်သဖြင့် မြို့ပြင်ဟို ဆွဲထုတ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","အဲလိုလဲ မိမိရဲ့ပတ်လည်တွင် တဘဲ့တော်လို့ ဝိုင်းလျက် နေကြသောအခါ၊ ပေါလုဟ ထယွေ့ မြို့ထဲဟို ဝင်လေအယ်။ နောက်တနေ့မှာ သူနဲ့ ဗာနဗဟ ဒေရဗေမြို့ဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ပေါလုနဲ့ ဗာနဗလို့ဟ ဒေရဗေမြို့တွင် သတင်းကောင်းဟို ဟောပြောသဖြင့် ရမ်းဆာ့သော လူလို့ဟို တဘဲ့တော် ဖြစ်လာကြအယ်။ အဲပင်းရင် လုတ္တရမြို့၊ ဣကောနိမြို့နဲ့ ပိသိဒိပြေ အန္တိအုတ်မြို့ဟို ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","တဘဲ့တော်လို့ရဲ့ စိတ်နေလုံးဟို ခိုင်ခံ့မြဲမြံစေလျက် ယုံကြည်ခြင်းနှိုက် ဆက်ယွေ့ တည်နေကြရန် ခွန်အားပေးကြအယ်။ သူလို့ဟ “ငါလို့သည် ဘုရားသခင်ရဲ့ နိုင်ငံတော်သို့ ဝင်ရန် ရမ်းဆာ့ ဆင်းရဲဒုက္ခများ ဖြတ်သန်းရမယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","သူလို့ဟ အသင်းတော်တိုင်းတွင် အကြီးအကဲလို့ဟို ခန့်ထားယွေ့၊ အစာဆှောင်လျက် ဆုတောင်းပင်း သူလို့ ယုံကြည်သော သခင်ဘုရားဆေ သူလို့ဟို အပ်နှံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","အဲပင်းရင် ပိသိဒိပြေ တပြေလုံးဟို ဆှောက်သွားယွေ့ ပမ်ဖုလိပြေဟို ရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","သူလို့ဟ ပေရဂေမြို့တွင် တရားတော်ဟို ဟောပြောကြပင်းနောက် အတ္တလိမြို့သို့ သွားပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","အဲမြို့မှတဆင့် ရွက်လွင့်ကာ အခု မိမိလို့ ဆောင်ရွက်ပီးစီးသွားလဲ့ အမှုတော်အတွက် ဘုရားသခင်ရဲ့ ကျေးဇူးတော်နှိုက် အပ်နှံခြင်း ခံခဲ့ရာ အန္တိအုတ်မြို့ဟို ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","အန္တိအုတ်မြို့ဟို ရောက်သောအခါ သူလို့ဟ အသင်းတော်ဝင်လို့ဟို စုရုံးစေလျက် မိမိလို့အားဖြင့် ဘုရားသခင် ပြုခဲ့သမျှသော အမှုအရာလို့ဟို လည်းကောင်း၊ ယုံကြည်ခြင်း ထင်ခါးဟို တပါးအမျိုးသားလို့အတွက် ဖွင့်ကျောန်းဟို လည်းကောင်း ပြောကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","အဲပင်းရင် သူလို့ဟ တဘဲ့တော်လို့နဲ့အတူ ကြာမြင့်စွာ နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","လူအချို့လို့ဟ ယုဒပြေမှ အန္တိအုတ်မြို့ဟို လာယွေ့ ယုံကြည်သူလို့အား “နင်လို့ဟ မောရှေရဲ့ ပညတ်တရားအတိုင်း အရေဖျားလှီးခြင်းဟို မခံယူရင် ကယ်တင်ခြင်း မရနိန်” ဟု စတင် သွန်သင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ပေါလုနဲ့ ဗာနဗလို့ဟ အေးသူလို့ကြားနှိုက် ပြင်းထန်သော သဘောထားကွဲလွဲမှုနဲ့ အငြင်းပွားမှုများ ဖြစ်ပေါ်ခဲ့သဖြင့် ပေါလု၊ ဗာနဗနဲ့ မိမိလို့ထဲမှ လူအချို့လို့ဟို ဟေပြဿနာအတွက် ယေရုရှလင်မြို့နှိုက် တမန်တော်များနဲ့ အသင်းတော် အကြီးအကဲများဆေဟို သွားကြရန် ခန့်အပ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","သူလို့ဟ အသင်းတော်ရဲ့ ပို့ဆောင်ခြင်းအားဖြင့် ဖိနိတ်ပြေနဲ့ ရှမာရိပြေလို့ဟို ဖြတ်သွားစဉ် လူမျိုးခြားလို့ ဘုရားသခင်ဆေ ပြောင်းလဲလာပုံဟို ပြောပြကြသဖြင့် ယုံကြည်သူပေါင်းလို့ဟ ရမ်းဆာ့ ဝမ်းမြောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ယေရုရှလင်မြို့သို့ သူလို့ ရောက်ကြသောအခါ အသင်းတော်မှ စယွေ့ တမန်တော်များ၊ အသင်းတော် လူကြီးများဟ သူလို့အား ကြိုဆိုလက်ခံလဲ့အခါ မိမိလို့အား ဘုရားသခင် ပြုသမျှလို့ဟို ပြောကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","အဲလိုလဲ ဖာရိရှဲ အဖွဲ့ဝင်များအနက် ယုံကြည်သူအချို့လို့ဟ ထယွေ့ “လူမျိုးခြားလို့ဟ အရေဖျားလှီးခြင်း ပေးကြရန်နဲ့ မောရှေရဲ့ ပညတ်တရားဟို လိုက်နာရမယ်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","တမန်တော်များနဲ့ လူကြီးများဟ ဟေအမှုကိစ္စဟို စဉ်းစားဆင်ခြင်ရန် စုဝေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","အချိန်အကြာကြီး အခြေအတင် ဆွေးနွေးကြပင်းနောက် ပေတရုဟ နေရာမှ ထယွေ့ “ညီအကိုလို့၊ လူမျိုးခြားလို့ဟ ငါ့စလောင်အားဖြင့် သတင်းကောင်းနဲ့ဆိုင်သော တရားစကားဟို ကြားနာယွေ့ ယုံကြည်ကြစေရန် ဘုရားသခင်ဟ လွန်ခဲ့လဲ့အချိန်ဟ နင်လို့အထဲမှ ငါ့ဟို ရွေးကောက်ကျောန်း နင်လို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","စိတ်နေလုံးဟို သိသော ဘုရားသခင်ဟ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ငါလို့အား ပေးသလိုမျိုး လူမျိုးခြားလို့အားလည်း ပေးသောအားဖြင့် သူလို့ဟို အသိအမှတ်ပြုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ကိုယ်တော်ဟ သူလို့ဟို ငါလို့နဲ့ ခွဲခြားခြင်း ပြုတော်မမူဘဲ သူလို့ဟ ကိုယ်တော်ဟို ယုံကြည်ခြင်းအားဖြင့် သူလို့ရဲ့ စိတ်နေလုံးဟို သန့်ဆှင်းစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","အေးလိုမို့ နင်လို့ဟ ငါလို့ဖိုးဖေးများနဲ့ ငါလို့တတ်တိုင်းလည်း မထမ်းနိန်သော ထမ်းပိုးဟို တဘဲ့တော်လို့ရဲ့ လည်ပင်းပေါ်နှိုက် တင်ခြင်းအားဖြင့် ဘုရားသခင်ဟို ပစာကျောန့် စမ်းသပ်ကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","မဟုတ်ဝူး၊ ငါလို့ဟလည်း အေးသူလို့နည်းတူ ယုံကြည်သဖြင့် သခင် ယေရှုရဲ့ ကျေးဇူးတော်အားဖြင့် ကယ်တင်ခြင်းဟို ခံရကြအယ်” ဟု ပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","စုဝေးနေသော သူအပေါင်းလို့ဟ တိတ်ဆိတ်သွားယွေ့ ဗာနဗနဲ့ ပေါလုတို့ဟ မိမိလို့အားဖြင့် လူမျိုးခြားလို့ အလယ်နှိုက် ဘုရားသခင်ပြုသော အံ့ဩဖွယ်ရာများနဲ့ နိမိတ်လက္ခဏာများ အကျောန်းဟို ပြောကြားနေစဉ် တိတ်ဆိတ်စွာ နားထောင်လျက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","သူလို့ ပြောဆိုပင်းသောအခါ ယာကုပ်ဟ “ညီအကိုလို့ ငါ့စကားဟို နားထောင်ကြပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ဘုရားသခင်ဟ မိမိနာမတော်အတွက် လူမျိုးခြားလို့ထဲမှ လူမျိုးဟို ရယူရန် သူလို့ဆေ ဦးစွာ အကျေ့အရှု ကြွလာကျောန်း ရှိမုန် ဆှင်းပြခဲ့ပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ပရောဖက်လို့ရဲ့ ဟောကြားချက်များဟလည်း ဟေအချက်နဲ့ လုံးဝ ကိုက်ညီလျက် ဆိအယ်။ ကျမ်းစာတော်တွင် ");
INSERT INTO dnv_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘ဟေအရာများနောက်တွင် ငါ ပြန်လာယွေ့၊ ပြိုလဲသော ဒါဝိဒ်ရဲ့ တဲဟို ပြန်ယွေ့ တည်ဆောက်မယ်။ ငါဟ ဖြိုဖျက်ခြင်း ခံရသော အေးတဲဟို ပြန်ယွေ့ တည်ဆောက်ပင်း ၎င်းဟို ပြန်လည် ခိုင်ခံ့စေမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ဟေဟာဟ ကြွင်းကျန်သော လူလို့နဲ့ ငါ့ရဲ့နာမဖြင့် ခေါ်ဝေါ်သမုတ်ခြင်း ခံရသော လူမျိုးခြားလို့ဟ ထာဝရဘုရားဟို ဆှာဖွေကြမဲ့အကျောန်းတည်းဟု ");
INSERT INTO dnv_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","မခင်ကာလမှ စယွေ့ ဟေအမှုအရာများဟို သိစေသော ထာဝရဘုရား မိန့်အယ်’ ဟူယွေ့ ရေးထားလဲ့အတိုင်း ဖြစ်အယ်။” ");
INSERT INTO dnv_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ယာကုပ်ရဲ့ စီရင်ချက်ဟ ဆက်လက်ယွေ့ “အဲမို့ ဘုရားသခင်ဆေသို့ ပြောင်းလဲလာကြသူ လူမျိုးခြားလို့ အခက်ကြုံစေရန် ငါလို့ မပြုသင့်၊ ");
INSERT INTO dnv_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","အဲအစား ရုပ်တုအား ပူဇော်ထားသောကျောန့် မသန့်ဆှင်းလဲ့ အစားအစာများဟို မစားရန်၊ ကာမဂုဏ် လိုက်စားခြင်း၊ လည်ပင်းဟို ညှစ်ယွေ့ သတ်သော တိရစ္ဆာန်များ အဲဟာမဟုတ်ရင် အသွေးဟို စားသုံးခြင်းလို့ဟိုမူ ဆှောင်ဆှားကြစေရန် စာရေးယွေ့ အကျောန်းကြားသင့်တာဟု ငါ ယူဆအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","အကျောန်းမှာ မခင်ဟ မြို့တိုင်းနှိုက် မောရှေရဲ့ ပညတ်တရားဟို ဟောပြောသောသူ ဆိယွေ့ အေးကျမ်းဟို ဥပုသ်နေ့တိုင်း တရားဇရပ်များတွင် ဖတ်လေ့ဆိအယ်” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","အဲအခါ တမန်တော်များ၊ အသင်းတော် လူကြီးများနဲ့ အသင်းတော်အပေါင်းလို့ဟ သူလို့အဖွဲ့ထဲနှိုက် လူဟို ရွေးကောက်ယွေ့ အန္တိအုတ်မြို့ဟို ပေါလု၊ ဗာနဗလို့နဲ့အတူ စေလွှတ်ရန် ဆုံးဖြတ်ကြအယ်။ သူလို့ဟ ယုံကြည်သူလို့ ရမ်းဆာ့ ကြည်ညိုလေးစားလဲ့ ဗာရှဗ ခေါ်လဲ့ ယုဒနဲ့ သိလလို့ နေယောက်ဟို ရွေးကောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","အဲသူလို့မှတဆင့် ပေးလိုက်သော စာဟ၊ “နင်လို့ရဲ့ ညီအကိုများ၊ တမန်တော်များနဲ့ အသင်းတော် လူကြီးများ၊ ရှုရိပြေ၊ ကိလိကိပြေနဲ့ အန္တိအုတ်မြို့တွင် ဆိသော လူမျိုးခြားထဲမှ ညီအကိုလို့အား နှုတ်ခွန်းဆက်သလိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ငါလို့အထဲမှ အချို့လို့ဟ ငါလို့ရဲ့ ခွင့်ပြုချက် မရဘဲ ထွက်သွားယွေ့ သူလို့ပြောလဲ့ စကားများကျောန့် နင်လို့ စိတ်အနှောင့်အယှက် ဖြစ်ရပင်း နင်လို့အား ဒုက္ခရောက်စေကျောန်း ကြားရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","အေးလိုမို့ ငါလို့ဟ တညီတညွတ်တည်း တွေ့ဆုံခဲ့ကြပင်း အချို့သော သတင်းသယ်ဆောင်သူများဟို ရွေးချယ်ကာ နင်လို့ဆေ ပေးပို့ရန် အားလုံး သဘောတူခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ငါလို့ သခင် ယေရှု ခရစ်တော်ရဲ့ အမှုတော်ထဲမှာ မိမိလို့အသက်ဟို ဆက်ကပ်ထားသူများဖြစ်ကြလဲ့ ငါလို့ချစ်သော မိတ်ဆွေ ဗာနဗနဲ့ ပေါလုလို့ဟလည်း သူလို့နဲ့အတူ လိုက်သွားကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","အေးလိုမို့ ငါလို့ရဲ့ စာတွင် ရေးသားဖော်ပြထားလဲ့ အကျောန်းအရာများဟို သူလို့နှုတ်ဖြင့် အတည်ပြု ပြောကြားရန် ငါလို့ဟ ယုဒနဲ့ သိလလို့ဟို စေလွှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","အကျောန်းမှာ သန့်ဆှင်းသော ဝိညာဉ်တော်နဲ့ ငါလို့ဟ လိုက်နာရန် လိုအပ်လဲ့ အောက်ပါအချက်များမှတပါး အခြားစလို ဝန်ထုတ်ဝန်ပိုးဟိုမှ နင်လို့အပေါ်ဟို မတင်ရန် ဆုံးဖြတ်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","နင်လို့ဟ ရုပ်တုအား ပူဇော်ထားလဲ့ အစားအစာ၊ အသွေး၊ လည်ပင်းဟို ညှစ်ယွေ့ သတ်သော တိရစ္ဆာန်နဲ့ မတရားသော မေထုန်လို့ဟို ကြဉ်ဆှောင်ရန် ဖြစ်အယ်။ နင်လို့ဟ ဟေအရာလို့နဲ့ ကင်းဆှင်းလျက် နေရင် ကောင်းပေအယ်။ ကျန်းမာ ရွှင်လန်းကြပါစေ” ဟု ရေးထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","အဲလိုမို့ သတင်းသယ်ဆောင်သူလို့အား စေလွှတ်သဖြင့် သူလို့ဟ အန္တိအုတ်မြို့သို့ သွားယွေ့ အဲမှာဆိလဲ့ ယုံကြည်သူအပေါင်းလို့အား စုဝေးစေပင်း အမှာစာဟို အပ်ပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","သူလို့ဟ အဲစာဟို ဖတ်ကြသောအခါ သူလို့ဟ အားပေး စကားများကျောန့် ဝမ်းမြောက်ခြင်းနဲ့ ပြေ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ယုဒနဲ့ သိလလို့ တတ်တိုင်းဟလည်း ပရောဖက်များ ဖြစ်ကြသောကျောန့် ညီအကိုလို့အား ရမ်းဆာ့သောစကားနဲ့ တိုက်တွန်းအားပေးလျက် ကြံ့ခိုင်စေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","သူလို့ဟ အေးအရပ်တွင် ကာလအတန်ကြာ နေပင်းနောက် ညီအကိုလို့အား ငြိမ်သက်စွာ ပြန်လွှတ်သဖြင့် သူလို့ဟ မိမိလို့ဟို စေလွှတ်သော သူလို့ဆေဟို ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ပေါလုနဲ့ ဗာနဗလို့ဟ အန္တိအုတ်မြို့တွင် ဆက်လက် နေထိန်ယွေ့ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တော်ဟို အခြားသူများနဲ့အတူ ဟောပြော သွန်သင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ရက်အနည်းငယ် ကြာသောအခါ ပေါလုဟ ဗာနဗအား “ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ငါလို့ ဟောပြောခဲ့လဲ့ မြို့တိုင်းဆိ ညီအကိုများဆေဟို ပြန်သွားယွေ့ သူလို့ စလိုဆိနေကြတာဟို ကျေ့ရှုကြကုန်စို့” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ဗာနဗဟ မာကု နာမယ်ဆိသော ယောဟန်ဟို မိမိနဲ့အတူ ခေါ်သွားလိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","အဲလိုလဲ ပေါလုဟ ပမ်ဖုလိပြေတွင် သူလို့ဆေမှ ထွက်ခွာသွားသောကျောန့် အမှုတော် ထမ်းဆောင်ရာသို့ သူလို့နဲ့အတူ မလိုက်ခဲ့သောသူဟို မခေါ်သွားသင့်ဟု မှတ်ယူအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","သူလို့ဟ အပြင်းအထန် အငြင်းပွားပင်းနောက် လမ်းခွဲသွားကြအယ်။ ဗာနဗဟ မာကုဟို ခေါ်ယွေ့ ကုပရုကျွန်းသို့ ရွက်လွှင့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ပေါလုမူကား သိလဟို ရွေးချယ်ယွေ့ ညီအကိုများအားဖြင့် သခင်ဘုရားရဲ့ ကျေးဇူးတော်သို့ အပ်နှံခြင်းဟို ခံယူလျက် ထွက်ခွာသွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","သူဟ ရှုရိပြေနဲ့ ကိလိကိပြေဟို သွားရောက်ယွေ့ အသင်းတော်ဟို ခိုင်ခံ့စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ပေါလုဟ ဒေရဗေမြို့နဲ့ လုတ္တရမြို့ဟို ရောက်ဆိလာပင်း အဲအရပ်တွင် တိမောသေ နာမယ်ဆိသော တဘဲ့တော်တဦး ဆိအယ်။ သူရဲ့အမေ့ ယုံကြည်သူ ယုဒအမျိုးသမီး ဖြစ်သော်လည်း သူ့အဖမှာ ဟေလသအမျိုးသား ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","သူဟ လုတ္တရမြို့နဲ့ ဣကောနိမြို့ဆိ ယုံကြည်သူလို့ရဲ့ ချီးမွန်းခြင်းဟို ခံရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ပေါလုဟ တိမောသဟို မိမိနဲ့အတူ လိုက်စေလိုသဖြင့် သူ့အား အရေဖျားလှီးခြင်း ပေးအယ်။ အေးလို့ လုပ်ရခြင်းမှာ တိမောသေရဲ့ အဖဟ ဟေလသအမျိုးသားဖြစ်ကျောန်း အေးအရပ်ဆိ ယုဒအမျိုးသားလို့ သိကြသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","သူလို့ဟ မြို့များဟို ဖြတ်ယွေ့ သွားကြစဉ်တွင် ယေရုရှလင်မြို့နှိုက်ဆိသော တမန်တော်များနဲ့ အသင်းတော်လူကြီးများ ဆုံးဖြတ်ကြသော စည်းကမ်းများဟို ယုံကြည်သူလို့ လိုက်နာကျင့်သုံးရန် ညွှန်ကြားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","အေးလိုမို့ အသင်းတော်လို့ရဲ့ ယုံကြည်ခြင်း ပိုမိုခိုင်မြဲလာလျက် နေ့စဉ်နေ့တိုင်း အရေအတွက်အားဖြင့် တိုးတက်များပြားလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","သူလို့ဟ ဖြူဂိပြေနဲ့ ဂလာတိပြေလို့ဟို ဖြတ်သွားကြသောကျောန့် သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ သူလို့အား အာရှပြေနှိုက် နှုတ်ကပတ်တရားတော်ဟို ဟောပြောရန် အခွင့်ပေးတော်မမူ။ ");
INSERT INTO dnv_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","သူလို့ဟ မုသိပြေနယ်စပ်ဟို ရောက်ကြသောအခါ ဗိသုန်ပြေဟို သွားရန် ကြိုးစားကြသော်လည်း ယေရှုရဲ့ ဝိညာဉ်တော်ဟ ခွင့်မပြုခဲ့ပေ။ ");
INSERT INTO dnv_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","အဲလိုမို့ သူလို့ မုသိပြေဟို ဖြတ်ယွေ့ တာရောမြို့သို့ ဆင်းသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ညအခါ ပေါလုဟ ရူပါရုံ တခုဟို မျော်ယွေ့ မာကေဒေါနိပြေသား တယောက်ဟ ရပ်လျက် “မာကေဒေါနိပြေသို့ လာယွေ့ ငါလို့အား ကူညီပေးပါ” ဟု သူ့အား တောင်းပန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ဟေလို့ ရူပါရုံဟို ပေါလု မျော်ပင်းနောက် ခုတင်ချင်း ငါလို့ဟ မာကေဒေါနိပြေသို့ သွားရန် ပြင်ဆင်ကြပင်း သူလို့အား သတင်းကောင်းဟို ဟောပြောရန် ငါလို့အား ဘုရားသခင် စေခိုင်းတာဟု ကောက်ချက်ချခြင်းကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ငါလို့ဟ တာရောမြို့မှ သာမောသရက်ကျွန်းဟို တန်းတန်းရွက်လွှင့်ကြရာ နောက်တနေ့နှိုက် နာပေါလိမြို့ဟို ရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","အဲမြို့မှ ဖိလိပ္ပိမြို့ဟို သွားကြအယ်။ ဖိလိပ္ပိမြို့ဟ မာကေဒေါနိပြေ ပထမခရိုင်ရဲ့ မြို့တမြို့ဖြစ်ပင်း ရောမအမျိုးသားလို့ အခြေစိုက်ရာမြို့လည်း ဖြစ်အယ်။ အဲမြို့တွင် ငါလို့ဟ ရက်ပေါင်းများစွာ နေထိန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ဥပုသ်နေ့နှိုက် ငါလို့ဟ မြို့ထင်ခါးအပြင်ဟို ထွက်ယွေ့ ဆုတောင်းရန် နေရာဆိမယ် အထင်နဲ့ မြစ်ကမ်းနံဖေးဟို သွားယွေ့ အေးနေရာနှိုက် ထိန်ပင်း စုဝေးလျက်နေလဲ့ မိန်းမလို့အား ဟောပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","အေးသူလို့အထဲတွင် သွာတိရဲမြို့မှ ခရမ်းရောင်အထည်ကုန်သည် လုဒိ နာမယ်ဆိ မိန်းမတယောက်လည်း နားထောင်နေအယ်။ သူဟ ဘုရားသခင်အား ကိုးကွယ်သူ တယောက်ဖြစ်အယ်။ သခင်ဘုရားဟ ပေါလု ဟောပြောလျက်နေသော တရားစကားများဟို အာရုံစိုက်စေရန် အေးမိန်းမရဲ့ စိတ်နေလုံးဟို ဖွင့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","အေးမိန်းမဟ သူနဲ့ နေအိုင်သူအိုင်သားလို့ နှစ်ခြင်း ခံပင်းသောအခါ သူဟ ငါလို့အား သူရဲ့နေအိုင်ဟို ဖိတ်ခေါ်အယ်။ “ငါဟ ဘုရားသခင်ဟို ယုံကြည်သူဖြစ်အယ်လို့ နင်လို့ ယူဆရင် ငါရဲ့ နေအိုင်ဟို လာရောက်တည်းခိုကြပါ” လို့ ငါလို့အား မရမက ဖိတ်ခေါ်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","တနေ့နှိုက် ငါလို့ဟ ဆုတောင်းရာနေရာဟို သွားနေစဉ်၊ ဗေဒင်ဟောနိန်သော နတ်ဝင်ပူးနေလဲ့ အစေခံမိန်းမငယ် တယောက်နဲ့ တွေ့ဆုံအယ်။ သူဟ အေးလို့ ဗေဒင်ဟောပြောခြင်းဖြင့် မိမိရဲ့ သခင်ဖြစ်သူအတွက် ပိတ်ဆန်အများ ရဆိစေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","အေးမိန်းမဟ ပေါလုနဲ့ ငါလို့နောက်ဟို လိုက်ပင်း “အေးသူလို့အား အမြင့်ဆုံးသော ဘုရားရဲ့ အစေခံများ ဖြစ်ယွေ့ နင်လို့အား ကယ်တင်ခြင်း တရားဟို ဟောပြောသူများ ဖြစ်အယ်” လို့ အော်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","သူမဟ ရက်ပေါင်းများစွာ အေးလို့ လုပ်နေသဖြင့် ပေါလုဟ ရမ်းဆာ့ စိတ်ညစ်ရယွေ့ နောက်ဟို လှည့်ပင်း “ယေရှု ခရစ်ရဲ့ နာမဖြင့် အေးသူ့ဆေမှ ထွက်သွားရန် နင့်ဟို ငါ အမိန့်ပေးအယ်” လို့ နတ်ဆိုးအား ဆိုရင်၊ အေးခဏနှိုက် နတ်ဆိုးဟ သူမဆေမှ ထွက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","သူမရဲ့ သခင်ဖြစ်သူလို့ဟ မိမိလို့ ပိတ်ဆန် ဝင်ပေါက် ပိတ်သွားပင်း မျော်လင့်စရာ မဆိကျောန်း သိကြသောအခါ၊ ပေါလုနဲ့ သိလလို့ဟို ဖမ်းဆီးယွေ့ အာဏာပိုင်များဆိရာ အများနဲ့ဆိုင်သော နေရာဟို ဆွဲခေါ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ရောမတပ်မှူးလို့ရဲ့ ဆေ့ဟို ရောက်သောအခါ “အေးသူဟ ယုဒလူများ ဖြစ်ပင်း ငါလို့မြို့တွင် ဒုက္ခရောက်အောန် လုပ်နေကြအယ်လို့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ငါလို့ တရားဥပဒေများနဲ့ ဆန့်ကျင်သော စလေ့များဟို သင်ကြားနေကြအယ်။ ငါလို့ဟ ရောမနိုင်ငံသားဖြစ်သောကျောန့် အေးစလေ့များဟို လက်မခံနိန် အဲဟာမဟုတ်ရင် မကျင့်သုံးနိန်ပါ” လို့ ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","လူအုပ်ဟလည်း ပေါလုနဲ့ သိလလို့ဟို ဝိုင်းယွေ့ တိုက်ခိုက်ကြအယ်။ အဲပင်းရင် အရာဆိလို့ဟ အေးသူနေဦးရဲ့ အဝတ်များဟို ဆုတ်ဖြဲယွေ့ ကြိမ်ဒဏ်ပေးစေရန် အမိန့်ချမှတ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","သူလို့ဟို အကြိမ်များစွာ ရိုက်ပင်းနောက် ထောင်ထဲမှာ ချထားကြပင်း သူလို့အား လုံခြုံစွာ သော့ခတ်ထားရန် ထောင်မှူးဟ အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","အေးလို့ အမိန့်ဟို လက်ခံရဆိသော ထောင်မှူးဟ သူလို့အားလုံး ထောင်အတွင်းဟို ထည့်ယွေ့ သူလို့ရဲ့ ခြေထောက်များဟို ရမ်းဆာ့လေးလဲ့ သစ်သားများနဲ့ ထိပ်တုံး ခတ်ထားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ညဉ့်သန်းခေါင်အချိန်နှိုက် ပေါလုနဲ့ သိလလို့ဟ ဆုတောင်းကာ ဘုရားသခင်ဟို ချီးမွန်း သီချင်းများဟို သီဆိုလျက် နေကြအယ်။ တခြားထောင်သားများလည်း သူလို့ဟို နားထောင်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ရုတ်တရက် မြေငလျင်ပြင်းစွာ လှုပ်သဖြင့် အကျဉ်းထောင်ရဲ့ အုတ်မြစ်ဟ တုန်လှုပ်သွားအယ်။ ထင်ခါးအားလုံးဟ ခုတင်ချင်း ပွင့်သွားပင်း ထောင်သားများအားလုံးလို့ရဲ့ သံကြိုးများ ပြုတ်ထွက်ကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ထောင်မှူးဟ အိပ်ယာမှ နိုးယွေ့ ထောင်ထင်ခါး ပွင့်နေတာဟို မျော်သောအခါ အကျဉ်းသားများ ထွက်ပြေးကြပီလို့ ထင်သဖြင့် ထားဟို ဆွဲထုတ်ပင်း မိမိတတ်တိုင်း သတ်သေမယ် လုပ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","အဲလိုလဲ ပေါလုဟ “နင့်ကိုယ်နင် အန္တရာယ်မလုပ်နဲ့၊ ငါလို့အားလုံး ဟေမှာ ဆိအယ်” လို့ ကြီးလဲ့အသံနဲ့ အော်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ထောင်မှူးဟ မီးတိုင်ဟို တောင်းပင်း ပြေးဝင် လာယွေ့ သူဟ တုန်ပင်း ပေါလုနဲ့ သိလလို့ရဲ့ ခြေထောက်ရင်းမှာ ပျပ်ဝပ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","အေးနောက် သူလို့ဟို အပြင်သို့ ခေါ်လာပင်း “ဆရာလို့၊ ငါ ကယ်တင်ခြင်း ခံရဖို့ စလို လုပ်ရမလုန်း” လို့ မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","သူလို့ဟ “သခင် ယေရှုဟို ယုံကြည်ကြလော့၊ အဲလိုလုပ်ရင် နင်နဲ့ နင်ရဲ့မိသားစုလို့ဟ ကယ်တင်ခြင်း ရလိမ့်မယ်” လို့ ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","အဲပင်းရင် အေးသူနဲ့ သူ့ရဲ့ နေအိုင်မှာဆိလဲ့ တခြားသူများအားလုံးဟို ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ဟောပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","အေးညအချိန်နှိုက်ပင် ထောင်မှူးဟ သူလို့ဟို ခေါ်ယွေ့ သူလို့ရဲ့ ဒဏ်ရာများဟို ဆေးကြောပေးအယ်။ အေးနောက် ခုတင်ချင်း သူနဲ့ သူ့မိသားစုအားလုံးလို့ဟ နှစ်ခြင်းခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","အဲပင်းရင် သူဟ ပေါလုနဲ့ သိလလို့အား မိမိရဲ့နေအိုင်ဟို ဖိတ်ခေါ်ယွေ့ စားစရာများဟို တည်ခင်း ကျွေးမွေးအယ်။ သူနဲ့ သူရဲ့ အိုင်သားလို့ဟ ဘုရားသခင်ဟို ယုံကြည်လာကြသောကျောန့် ဝမ်းမြောက်ခြင်းနဲ့ ပြေ့လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","နောက်တနေ့ မိုးလင်းသောအခါ ရောမအာဏာဆိလို့ဟ အရာဆိများဟို စေလွှတ်ယွေ့ “အေးလူလို့ဟို လွှတ်စေ” ဟု အမိန့်ပေးလိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","အေးကျောန့် ထောင်မှူးဟ ပေါလုအား “အရာဆိလို့ဟ နင်နဲ့ သိလလို့အား လွှတ်ပေးရန် အမိန့်ပေးပါအယ်။ အေးကျောန့် နင်လို့ ငြိမ်းချမ်းစွာ သွားကြပါ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","အဲလိုလဲ ပေါလုဟ အရာဆိလို့အား “ရောမနိုင်ငံသားများဖြစ်သော ငါလို့အား စစ်ကြောစီရင်ခြင်း မလုပ်ဘဲ ငါလို့ဟို လူများဆေ့တွင် ဖိုင်ယွေ့ အကျဉ်းချထားကြအယ်။ အခု ငါလို့ဟို တိတ်တိတ်လေး လွှတ်လိုက်ကြမယ်လော။ အေးလို့ မလုပ်သင့်။ သူလို့တတ်တိုင်း လာယွေ့ ငါလို့ဟို ထုတ်ကြပါစေ” လို့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","အရာဆိလို့ဟလည်း အေးအကျောန်းဟို ရောမ အရာဆိလို့အား ပြန်ပြောကြအယ်။ ပေါလုနဲ့ သိလလို့ဟ ရောမနိုင်ငံသားများ ဖြစ်ကျောန်းဟို သူလို့ ကြားသောအခါ ကြောက်လန့်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","အေးကျောန့် သူလို့ဟ လာယွေ့ သူလို့အား တောင်းပန်ကြကာ သူလို့ဟို ထောင်မှထုတ်ပင်း အေးမြို့မှထွက်သွားရန် ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ပေါလုနဲ့ သိလလို့ဟ ထောင်ထဲမှ ထွက်ယွေ့ လုဒိရဲ့ နေအိုင်ဟို သွားကြအယ်။ အဲမှာ သူလို့ဟ ယုံကြည်သူလို့နဲ့ တွေ့ဆုံကာ တိုက်တွန်းအားပေးစကား ပြောကြားပင်းမှ ထွက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ပေါလုနဲ့ သိလလို့ဟ ခရီးဆက်ခဲ့ရာ အံဖိပေါလိမြို့နဲ့ အာပေါလောနိမြို့ဟို ဖြတ်ပင်း သက်သာလောနိကမြို့ဟို လာကြအယ်၊ အေးမြို့မှာ ယုဒတရားဇရပ် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ပေါလုဟ မိမိလို့ စလေ့ဆိလဲ့အတိုင်း အေးတရားဇရပ်ဟို သွားပင်း ဥပုသ်နေ့ သုံးရက်လုံးလုံး သူလို့နဲ့ ကျမ်းစာဟို အမှီပြုလျက် ဆွေးနွေးကာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","မေဆှိယဟ ဆင်းရဲဒုက္ခခံပင်း သေခြင်းမှ ဆှင်ပြန်ထမြောက်မယ် ဆိုလဲ့အကျောန်းဟို အထောက်အထားများနဲ့တကွ ဆှင်းပြအယ်။ ပေါလုဟ “ငါဟ နင်လို့ဟို ပြောပြနေလဲ့ ယေရှုဟ မေဆှိယ ဖြစ်အယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","တချို့သောသူလို့ဟ ယုံကြည်ကြသဖြင့် ပေါလုနဲ့ သိလလို့ရဲ့ အဖွဲ့ဟို ဝင်ကြအယ်၊ ဘုရားသခင်ဟို ကိုးကွယ်သူ ဟေလသ လူအမြောက်အမြားနဲ့ ထင်ဆှားသော မိန်းမများလည်း သူလို့အဖွဲ့ဟို ဝင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","အဲလိုလဲ ယုဒလူမျိုး အချို့လို့ဟ မနာလိုစိတ်နဲ့ မချမ်းသာသော မုန့်ဖုတ်သမားများဟို လမ်းများမှ လူအုပ်ဟို အတူစုစည်းခဲ့အယ်။ တမြို့လုံးဟို ရုန်းရင်ဆန်ခတ် ဖြစ်ပင်း ယာသုန် နာမယ်ဆိသော သူရဲ့နေအိုင်ဟို တိုက်ခိုက်ပင်း၊ ပေါလုနဲ့ သိလလို့ဟို လူများဆေ့ဟို ဆွဲထုတ်ဖို့ ကြိုးစားယွေ့ ဆှာဖွေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","အဲလိုလဲ သူလို့ဆှာယွေ့ မမျော်ကြသောအခါ ယာသုန်နဲ့ အခြား ယုံကြည်သူတချို့လို့ဟို မြို့အာဏာပိုင်များ ဆေ့ဟို ခေါ်ဆောင်ခဲ့ပင်း “အေးလူတွေဟ နေရာတိုင်းမှာ ဒုက္ခပေးခဲ့ကြပါအယ်၊ သူလို့ဟ ငါလို့ရဲ့ မြို့ဟိုလည်း အခု လာပါပီ၊ ");
INSERT INTO dnv_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ယာသုန်ဟ အေးသူလို့ဟို သူရဲ့နေအိုင်မှာ လက်ခံထားပါအယ်။ သူလို့အားလုံးဟ ယေရှုဆိုလဲ့ နာမယ်ဆိသော တခြားဘုရင်တပါး ဆိအယ်ဟု ပြောဆိုလျက် ကဲသာဘုရင်ရဲ့ ဥပဒေများဟိုလည်း ချိုးဖောက်ကြပါအယ်” ဟု အော်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","အေးစကားများအားဖြင့် သူလို့ဟ လူအုပ်နဲ့ မြို့အာဏာပိုင်များဟို ရုတ်ရုတ်သဲသဲ ဖြစ်စေခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","အာဏာဆိသူများဟ ယာသုန်နဲ့ အခြားသူများဟို လွှတ်ပေးရန် လိုအပ်လဲ့ ငွေများဟို ပေးဆောင်စေပင်းနောက် ထွက်သွား ခွင့်ပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ညအချိန် ရောက်သောအခါ၊ ယုံကြည်သူလို့ဟ ပေါလုနဲ့ သိလလို့ဟို ဗေရိမြို့ဟို စေလွှတ်ကြအယ်။ သူလို့ရောက်သောအခါ သူလို့ဟ ယုဒတရားဇရပ်ဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","သက်သာလောနိတ်မြို့မှာ ဆိလဲ့သူများလို့ထက် ဗေရိမြို့မှာဆိလဲ့ လူများလို့ဟ ပိုပင်း စိတ်ထား မြင့်မြတ်ကြအယ်။ သူလို့ဟ သတင်းစကားဟို ရမ်းဆာ့ စိတ်အားထက်သန်စွာ နားထောင်ပင်း ပေါလု ပြောခဲ့လဲ့စကား မန်အယ် မမန်သိနိန်ရန် ကျမ်းစာဟို နေ့တိုင်း လေ့လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ရမ်းဆာ့သော လူများလို့ဟ ယုံကြည်လာကြအယ်၊ ဂုဏ်အသရေဆိ ဟေလသ မိန်းမလို့နဲ့ ယောက်ျားများစွာလို့လည်း ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","အဲလိုလဲ ဗေရိမြို့တွင် ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားတော်ဟို ပေါလု ဟောပြောလျက် ဆိကျောန်းဟို သက်သာလောနိတ်မြို့မှ ယုဒအမျိုးသားလို့ဟ ကြားသိကြသောအခါ အဲမြို့ဟို လာယွေ့ လူအုပ်လို့အား ဆူပူအောန် လှုံ့ဆော်ပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","အေးအခါ ယုံကြည်သူလို့ဟ ပေါလုဟို ပင်လယ်လမ်းဖြင့် သွားစေခြင်းငှာ ချက်ချင်း လွှတ်လိုက်ကြအယ်၊ အဲလိုလဲ သိလနဲ့ တိမောသေလို့ဟ ဗေရိမြို့တွင် နေခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ပေါလုဟို လိုက်ပို့ကြသော သူလို့ဟ သူနဲ့ အာသင်မြို့အထိ လိုက်ပို့ပင်းမှ၊ သိလနဲ့ တိမောသေလို့ အမြန်ဆုံး လိုက်လာစေရန် ညွှန်ကြားချက် ရပင်း ဗေရိမြို့ဟို ပြန်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ပေါလုဟ အာသင်မြို့တွင် သိလနဲ့ တိမောသေလို့ဟို စောင့်နေချိန်နှိုက် အေးမြို့တွင် ရုပ်တုများနဲ့ ပြေ့နေတာဟို မျော်သဖြင့် ရမ်းဆာ့ စိတ်ပျက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","အေးကျောန့် တရားဇရပ်တွင် ယုဒအမျိုးသားများ၊ ဘုရားသခင်ဟို ကိုးကွယ်သော တပါးအမျိုးသားနဲ့ လည်းကောင်း၊ နေ့စဉ်နေ့တိုင်း အများနဲ့ဆိုင်သော နေရာ လာရောက်ကြသူများနဲ့ လည်းကောင်း ဆွေးနွေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ဧပိကုရုနဲ့ သတောအိတ် ဆရာလို့ဟလည်း သူလို့နဲ့ ဆွေးနွေး ငြင်းခုန်ကြအယ်။ တချို့ဟ “ဟေစကားအိုးဟ ပစာအရာဟို ပြောဆိုနေလုန်း” ဟု ပြောကြအယ်။ တခြားသူများဟ “သူလို့ဟ လူမျိုးခြားလို့ရဲ့ နတ်ဘုရားများ အကျောန်းဟို ပြောဆိုနေအယ်” ဟု ဖြေအယ်။ သူလို့အေးလို့ ပစာကျောန့် ပြောဆိုလဲဆိုရင် ပေါလုဟ ယေရှုအကျောန်းနဲ့ ဆှင်ပြန်ထမြောက်ခြင်း အကျောန်း သတင်းကောင်းဟို ဟောသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","အေးကျောန့် သူလို့ဟ ပေါလုဟို အာရေတောင်မြို့ တရားရုံးဟို ခေါ်ဆောင်သွားပင်း၊ “နင် သင်ကြားမှု အသစ်အကျောန်းဟ နင်ပြောလဲ့အကျောန်းဟို ငါလို့ သိပါရစေလို့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","နင်လို့ ဟောပြောသော အကျောန်းအရာ အချို့လို့မှာ ငါလို့အတွက် အစိမ်းသက်သက် ဖြစ်နေပါအယ်၊ အေးနေရာများရဲ့ ဆိုလိုရင်းဟို ငါလို့ သိချင်ပါအယ်” ဟု ဆိုကြအယ်။ ( ");
INSERT INTO dnv_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","အာသင်မြို့သားများနဲ့ အေးတွင် နေထိန်သော ဧည့်သည်များ အားလုံးအတွက် နောက်ဆုံးပေါ် အရာအားလုံးဟို ပြောပြရန်နဲ့ ကြားနာခြင်းအားဖြင့် အချိန်ဟို ကုန်လွန်စေတတ်ကြအယ်။) ");
INSERT INTO dnv_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ပေါလုဟ အာရေတောင် တရားရုံးဆေ့တွင် ရပ်ယွေ့ “အာသင်မြို့သားလို့ နင်လို့ဟ ရမ်းဆာ့ ဘာသာရေးဟို ရိုသေတတ်ကြတာဟို ငါ မျော်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ငါဟ နင်လို့မြို့ဟို လှည့်ပင်း ဘုရားဝတ်ပြုရာ နေရာဟို ကျေ့ခဲ့စဉ် ‘ငါလို့ မသိသော ဘုရားအဖို့’ ဟူယွေ့ ရေးသားထားသော ယဇ်ပလ္လင်တခုဟို ငါ မျော်ခဲ့အယ်၊ အေးလို့ နင်လို့မသိဘဲ ဝတ်ပြုကိုးကွယ်နေသော ဘုရားရဲ့အကျောန်းဟို နင်လို့အား ငါ အခု ဟောပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","လောကကြီးနဲ့တကွ အရာအားလုံးဟို ပြုလုပ်သော ဘုရားသခင်ဟ ခေါန်းခင်နဲ့ မြေကြီးဟို အစိုးရသော အဆှင်ဖြစ်ယွေ့ လူလက်များနဲ့ ဆောက်လုပ်လဲ့ ဗိမာန်တော်နှိုက် ကျိန်းဝပ်တော်မမူ။ ");
INSERT INTO dnv_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ကိုယ်တော်ဟ အသက်နဲ့တကွ ထွက်သက်ဝင်သက်နဲ့ အရာခပ်သိမ်းလို့ဟို လူအပေါင်းလို့အား ပေးသနားသောသူ ဖြစ်ယွေ့ တစုံတခုဟို လိုအပ်သည့်အလား လူ့လက်ဖြင့် ပြုစုခြင်းဟို ခံတာ မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ကိုယ်တော်ဟ လူတဦးတည်းမှ လူမျိုးအားလုံးဟို ဖန်ဆင်းယွေ့ ကမ္ဘာမြေပြင်အနှံ့တွင် နေထိန်စေကာ အချိန်ကာလများနဲ့ သူလို့နေထိန်ရာ နယ်နိမိတ်များဟို ကြိုတင်ချမတ် ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","အေးလိုပြုခြင်းမှာ သူလို့ဟ ကိုယ်တော်ဟို ဆှာတွေ့ရန် ဖြစ်အယ်၊ သူလို့ဟ ကိုယ်တော်ဟို သူလို့အဖို့ ပတ်ပတ်လည်ဆှာကြအယ်၊ ဘုရားသခင်ဟ ငါလို့တွင် စသူနဲ့မျှ ဝေးတာ မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","တစုံတယောက်ဟ ပြောခဲ့သလိုမျိုး “ ‘ငါလို့ဟ သူ့အားဖြင့် အသက်ဆှင် တည်ဆိလျက် ဆိကြအယ်။’ နင်လို့ရဲ့ ကဗျာဆရာ တချို့ဟ ‘ငါလို့ဟလည်း သူရဲ့ လူပဲ့သငယ်များ ဖြစ်ကြအယ်’ ဟု စပ်ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ငါလို့ဟ ဘုရားသခင်ရဲ့ လူပဲ့များ ဖြစ်လဲ့အတွက်ကျောန့် ဘုရားသခင်ဟ လူလို့ရဲ့ စိတ်ကူးနဲ့ အနုပညာစွမ်းရည်နဲ့ ထုလုပ်ထားလဲ့ ဆွေရုပ်တု၊ ငွေရုပ်တု၊ ကျောက်ရုပ်တုလို့နဲ့ တူတယ်ဆိုတာဟို မထင်မမှတ်ရ။ ");
INSERT INTO dnv_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ဘုရားသခင်ဟ လူလို့ မသိလဲ့အချိန်များဟို မမှတ်ထားဖူးခဲ့သော်လည်း၊ အခုအခါနှိုက် နေရာတိုင်းဆိ လူအပေါင်းလို့အား နောင်တရကြရန် အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","အကျောန်းမှာ ရွေးချယ်သောသူအားဖြင့် လောကသားလို့ဟို မန်ကန်စွာ တရားစီရင်မဲ့ နေ့ရက်ဟို သတ်မှတ်ပီးသောကျောန့် ဖြစ်အယ်။ အေးသူဟို သေခြင်းမှ ဆှင်ပြန်ထမြောက်စေသောအားဖြင့် လူအားလုံးလို့အား သက်သေပြပီ” ဟု ဟောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","သေခြင်းမှ ဆှင်ပြန်ထမြောက်မဲ့အကျောန်း ပေါလု ပြောတာဟို သူလို့ကြားသောအခါ၊ တချို့သောသူလို့ဟ သူဟို ပြောင်ကြသော်လည်း တချို့ဟ “နင်ပြောလဲ့ အကျောန်းဟို နောက်တခါ ငါလို့ ပြန်ကြားလိုအယ်” ဟု ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","အေးလို့ကျောန့် ပေါလုဟ အစည်းအဝေးမှ ထွက်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","လူတချို့ဟ ပေါလုရဲ့ နောက်လိုက်များ ဖြစ်လာပင်း ယုံကြည်ကြအယ်။ အေးသူလို့ အများထဲမှ ဒယောနုသိ နာမယ်ဆိလဲ့ အာရေတောင် အဖွဲ့ဝင်တဦး၊ ဒမာရိ နာမယ်ဆိလဲ့ မိန်းမတဦးအပြင် တခြားသူအချို့လို့ ပါဝင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","အေးနောက် ပေါလုဟ အာသင်မြို့မှ ထွက်ခွာပင်း ကောရိန့်မြို့ဟို ရောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","အေးမှာ ပုန္တုပြေသား အာကုလ နာမယ်ဆိလဲ့ ယုဒအမျိုးသား တယောက်နဲ့ တွေ့ဆုံအယ်။ ယုဒအမျိုးသားများအားလုံး ရောမမြို့မှ ထွက်သွားရန် ကလောဒိဘုရင် အမိန့်ထုတ်ပြန်သဖြင့် သူဟ သူရဲ့ပေါင်အိုမ ပြစ်ကိလနဲ့အတူ မခင်ဟ ဣတလိပြေမှ လာခဲ့ကြခြင်း ဖြစ်အယ်။ ပေါလုဟ သူလို့ဟို တွေ့ရန် သွားယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","အလုပ်ချင်း တူနေသောကျောန့် သူလို့နဲ့ အတူနေပင်း အလုပ်အတူတူ လုပ်ကြအယ်။ ပစာကို့ သူလို့ဟ ယာယီတဲဟို ချုပ်သောသူ ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ယုဒအမျိုးသားနဲ့ ဟေလသအမျိုးသားများဟို ဖြားယောင်းယွေ့ သူဟ ဥပုသ်နေ့တိုင်း တရားဇရပ်တွင် တရားဆွေးနွေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","သိလနဲ့ တိမောသေလို့ မာကေဒေါနိပြေမှ ရောက်လာကြသောအခါ၊ ပေါလုဟ သူရဲ့ အချိန်အားလုံးဟို နှုတ်ကပတ်တော် ဟောပင်း၊ ယေရှုဟ မေဆှိယဖြစ်ကျောန်းဟို ယုဒအမျိုးသားလို့အား သက်သေခံလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ယုဒလူလို့ဟ သူ့ဟို မကောင်းသောအရာများ အကျောန်းဟို ပြောဆိုသောအခါ၊ ပေါလုဟ မိမိအဝတ်မှ ဖုန်များဟို ပုတ်ချယွေ့ သူလို့အား “နင်လို့ သေကြေပျက်စီးကြရင် နင်လို့ရဲ့ တာဝန်ပင် ဖြစ်အယ်၊ ငါ့မှာ တာဝန် မဆိတော့ပီ။ အခုမှစယွေ့ ငါဟ လူမျိုးခြားလို့ဆေ သွားတော့မယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","အေးနောက် အေးသူလို့ဆေမှ ထွက်သွားပင်း ဘုရားသခင်ဟို ကိုးကွယ်သူ တိတုယုတ္တု နာမယ်ဆိသော လူမျိုးခြားရဲ့ နေအိုင်ဟို သွားပင်း နေထိန်အယ်။ အေးနေအိုင်ဟ တရားဇရပ်နဲ့ ကပ်လျက်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","တရားဇရပ်မှူး ကရိပ္ပုနဲ့ သူ့အိုင်သူအိုင်သားအားလုံးဟ သူနဲ့အတူ အဆှင်ဟို ယုံကြည်ကြအယ်။ အခြား ကောရိန့်မြို့သားများဟ တရားစကားဟို ကြားရပင်း ယုံကြည်ကြကာ နှစ်ခြင်းဟို ခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","တညနှိုက် ဘုရားသခင်ဟ ပေါလုဟို ရူပါရုံအားဖြင့် “မကြောက်ကြနဲ့၊ အဲလိုလဲ ဆက်လက် ပြောဆိုပင်း အရှုံးမပေးနဲ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","အကျောန်းမှာ ငါဟ နင်လို့နဲ့အတူ ဆိအယ်။ တယောက်မှ နင်လို့ဟို နာကျင်အောန် မပြုလုပ်နိန်။ ဟေမြို့နှိုက် ငါ့ရဲ့ လူများစွာ ဆိကြအယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","အေးကျောန့် ပေါလုဟ အေးမြို့တွင် တနှစ်ခွဲလောက် နေထိန်ပင်း၊ ဘုရားသခင်ရဲ့ နှုတ်ကပတ်တရားဟို လူများလို့အား သွန်သင်လျက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","အခါယပြေဟို ဂါလျုန်မင်းဟ ရောမအစိုးရ ဖြစ်နေသောအခါ ယုဒအမျိုးသားလို့ဟ စုရုံးလျက် ပေါလုဟို ဖမ်းပင်း တရားပလ္လင်ဆေ့ဟို ခေါ်သွားခဲ့ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","သူလို့ဟ “အေးသူသည် ပညတ်တရားနဲ့ ဆန့်ကျင်ယွေ့ ဘုရားဟို ကိုးကွယ်ကြစေရန် လူလို့အား ဖြားယောင်းလျက် နေပါအယ်” လို့ ဆှောက်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ပေါလုဟ ပြောဆိုမယ်အလုပ်တွင် ဂါလျုန်ဟ ယုဒလူလို့အား “ယုဒလူလို့၊ ဟေအမှုဟ မမန်ကန်သော အပစ် အဲဟာမဟုတ်ရင် လိမ်လည်မှုဖြစ်ရင် ငါဟ နင်လို့ရဲ့ စွပ်စွဲချက်ဟို စိတ်ဆှည်စွာ နားထောင်နိန်ပေးမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","အဲလိုလဲ ၎င်းဟ စကားလုံးများ၊ နာမယ်များနဲ့ နင့်ရဲ့ ကိုယ်ပိုင်ဥပဒေနဲ့ ပတ်သက်ယွေ့ အငြင်းပွားဖွယ်ရာ ဖြစ်သောကျောန့် နင်လို့တတ်တိုင်း ဖြေဆှင်းရမယ်။ အေးအမှုမျိုးဟို ငါ တရားစီရင်ဝူး” ဟု ဆိုယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","သူလို့ဟို တရားခွင်မှ မောင်းထုတ်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","အေးသူအပေါင်းလို့ဟ တရားဇရပ်မှူး သုဿင်ဟို ဖမ်းဆီးယွေ့ တရားခွင် ဆေ့နှိုက် ရိုက်ကြအယ်။ အဲလိုလဲ ဂါလျုန်ဟ အေးအပြုအမူဟို လုံးဝ ဂရုမစိုက်ဘဲ နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ပေါလုဟ ကောရိန့်မြို့ ယုံကြည်သူများနဲ့အတူ ရက်ပေါင်းများစွာ နေပင်းနောက် သူလို့ဆေမှ ထွက်ခွာယွေ့ ပြစ်ကိလ၊ အာကုလလို့နဲ့အတူ ရှုရိပြေဟို ရွက်လွင့်လေအယ်။ ကင်ခြေမြို့မှ မထွက်သွားခင် သစ္စာကတိပြုထားတာကျောန့် သူဟ ခေါင်းရိတ်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","သူလို့ဟ ဧဖက်မြို့ဟို ရောက်သောအခါ ပေါလုဟ ပြစ်ကိလနဲ့ အာကုလလို့ဟို မြို့ထဲတွင် ချန်ခဲ့အယ်။ သူဟ တရားဇရပ်ဟို ဝင်ပင်း ယုဒလူများနဲ့ ဆွေးနွေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","လူလို့တွင် မိမိလို့ဆေမှာ ကြာကြာနေရန် ပြောကြသော်လည်း ပေါလုဟ ငြင်းဆန်လျက် နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","အဲလိုလဲ “ဘုရားသခင် အလိုတော်ဆိရင် ငါ ပြန်လာခဲ့မယ်” ဟု သူလို့ဟို ပြောပင်း ထွက်သွားတယ်။ အဲပင်းရင် ဧဖက်မြို့မှ သင်္ဘောနဲ့ ရွက်လွင့်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","သူဟ ကဲသရိမြို့ဟို ရောက်သောအခါ သူဟ ယေရုရှလင်မြို့ဟို တက်သွားယွေ့ အသင်းတော်ဟို နှုတ်ဆက်ပင်းမှ အေးနောက် အန္တိအုတ်မြို့ဟို သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","အေးမှာ အချိန်အတန်ကြာ နေပင်းနောက် သူဟ ထွက်သွားယွေ့ ဂလာတိပြေ၊ ဖြူဂိပြေဟို ဆှောက်သွားပင်း တဘဲ့တော်များ အားလုံးဟို ကြံ့ခိုင်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","အေးအချိန်နှိုက် အာလေဇန္ဒြိမြို့မှာ မွေးဖွားသော အာပေါလု နာမယ်ဆိသော ယုဒ လူတယောက်ဟ ဧဖက်မြို့ဟို လာအယ်။ သူဟ အဟောပြောကောင်းလဲ့ ဟောပြောသူ တဦးဖြစ်ယွေ့ ကျမ်းစာဟိုလည်း ကောင်းစွာ သိကျွမ်းသူဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","သူဟ ဘုရားသခင်ရဲ့ လမ်းစဉ်အတိုင်း သွန်သင်ခြင်း ခံရခဲ့ပင်း စိတ်အားထက်သန်စွာဖြင့် ယေရှုနဲ့ ပတ်သက်လဲ့ အချက်အလက်များဟို မန်ကန်စွာ ဟောကြားခဲ့အယ်။ စလိုပဲဖြစ်ဖြစ် သူဟ ယောဟန်ရဲ့ နှစ်ခြင်းဟိုသာ သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","သူဟ တရားဇရပ်နှိုက် ရဲရင့်စွာ စတင် ပြောဆိုခဲ့အယ်။ အာကုလနဲ့ ပြစ်ကိလလို့ဟ သူပြောနေတာဟို ကြားသောအခါ သူလို့နေအိုင်ဟို ခေါ်ဖိတ်ယွေ့ ဘုရားသခင်ရဲ့ လမ်းစဉ်အကျောန်းဟို ပိုပင်း သေချာစွာ ဆှင်းပြပေးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","အာပေါလုဟ အခါယမြို့ဟို သွားဖို့ ဆုံးဖြတ်ချက်ချပင်း ဧဖက်မြို့ဆိ ယုံကြည်သူများဟ အခါယပြေဆိ တဘဲ့တော်များဆေဟို သူ့ဟို ကြိုဆိုဖို့ စာရေးခြင်းအားဖြင့် ကူညီကြအယ်။ သူဟ အခါယပြေဟို ရောက်သောအခါ ဘုရားသခင်ရဲ့ ကျေးဇူးတော်အားဖြင့် ယုံကြည်လာသောသူအား ရမ်းဆာ့ အကူအညီပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","အကျောန်းမှာ သူဟ လူထုဆေ့ ဆွေးနွေးပွဲများတွင် ကျမ်းစာများမှ အထောက်အထားများဖြင့် ယေရှုဟ မေဆှိယဖြစ်ကျောန်းဟို ယုဒအမျိုးသားလို့အား ပိုင်နိန်စွာ ချေပပြောဆိုသောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","အာပေါလုဟ ကောရိန့်မြို့ဟို ရောက်နေစဉ်၊ ပေါလုဟ အထက် ဒေသတဆှောက်ဟို ဖြတ်သွားပင်းမှ ဧဖက်မြို့ဟို ရောက်အယ်။ တဘဲ့တော် တချို့လို့ဟို အေးမှာ တွေ့သဖြင့်၊ ");
INSERT INTO dnv_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","သူလို့အား “နင်လို့ ယုံကြည်သူ ဖြစ်လာကြသောအခါ သန့်ဆှင်းသော ဝိညာဉ်တော်ဟို ရဆိကြသလော” ဟု မေးအယ်။ သူလို့ဟ “သန့်ဆှင်းသော ဝိညာဉ်တော် ဆိကျောန်းဟို ငါလို့ မကြားဖူးပါ” လို့ ပြန်ဖြေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ပေါလုဟ “အေးနောက် ကောင်းပီ၊ နင်လို့ စလို နှစ်ခြင်းမျိုးဟို ခံခဲ့လုန်း” လို့ မေးအယ်။ သူလို့ဟ “ယောဟန်ရဲ့ နှစ်ခြင်း ဖြစ်အယ်” လို့ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ပေါလုဟ “ယောဟန်ရဲ့ နှစ်ခြင်းသည် အပစ်များမှ နောင်တရ သူလို့အဖို့ ဖြစ်ပင်း၊ သူဟ မိမိနောက်မှလာမဲ့ သူဟို ယုံကြည်ရမယ်လို့ ဣသရေလူမျိုးလို့အား ပြောခဲ့အယ်။ အေးသူဟ ယေရှု ဖြစ်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","သူလို့ဟ အေးအရာဟို ကြားသောအခါ၊ သူလို့ဟ သခင် ယေရှုရဲ့ နာမနှိုက် နှစ်ခြင်း ခံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ပေါလုဟ သူလို့ရဲ့ ခေါင်းပေါ်မှာ လက်ဟို တင်ရင် သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ သူလို့အပေါ်မှာ ဆင်းသက်လာသဖြင့်၊ သူလို့ဟ အခြားသော ဘာသာစကားဟို ပြောယွေ့ ပရောဖက်ပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","သူလို့အားလုံးမှာ လူယောက်ျား ဆယ့်နေယောက်လောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ပေါလုဟ တရားဇရပ်ဟို ဝင်ပင်း သုံးလလုံးလုံး အချေအတင် ဆွေးနွေးကာ ဘုရားသခင်ရဲ့ နိုင်ငံတော် အကျောန်းများဟို ဖြားယောင်းယွေ့ ရဲရင့်စွာ ဟောပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","အဲလိုလဲ အချို့လို့ဟ ခိုင်မာသော သဘောဆိယွေ့ မယုံဘဲ နေသဖြင့်၊ လူအပေါင်းလို့ဆေ့တွင် ဘုရားသခင်ရဲ့ လမ်းစဉ်အကျောန်း မကောင်းသော စကားဟို ပြောကြအယ်။ အေးကျောန့် ပေါလုဟ တဘဲ့တော်လို့ဟို ခေါ်ယွေ့ သူလို့ဆေမှ ထွက်သွားပင်း တုရန္နုရဲ့ စာသင်ခန်းမဆောင်တွင် နေ့တိုင်း ဆွေးနွေး ပြောဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","အေးလို့ နေနှစ်တိုင်တိုင် အေးလို့ပြုကြရာ အာရှပြေတွင် နေထိန်သော ယုဒလူမျိုးများနဲ့ လူမျိုးခြားများ အပေါင်းလို့ဟ ဘုရားသခင်ရဲ့ စကားတော်ဟို ကြားနာရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ဘုရားသခင်ဟ ပေါလုအားဖြင့် ထူးခြားသော နိမိတ်လက္ခဏာများ ပြုလုပ်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","သူသုံးသော ပဝါနဲ့ ခါးစည်း တခုခုဟို ဖျားနာသူများနဲ့ နတ်ပူးသူများဆေဟို ယူသွားသဖြင့်၊ သူလို့ဟ ရောဂါပျောက်ကင်းယွေ့၊ နတ်ဆိုးများဟ သူလို့ဆေမှ ထွက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","နေရာတကာ သွားလာနေလဲ့ ယုဒအမျိုးသား ပယောဂဆရာအချို့လို့ဟ နတ်ဆိုးများဟို သခင် ယေရှုရဲ့ နာမအားဖြင့် မောင်းထုတ်ရန် ကြိုးစားကြအယ်။ သူလို့ဟ နတ်ဆိုးလို့အား “ပေါလု ဟောပြောသော ယေရှုရဲ့ နာမအားဖြင့် အမိန့်ပေးအယ်” လို့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","သကေဝ နာမယ်ဆိသော ယုဒ ယဇ်ပုရောဟိတ်မင်းရဲ့ သား ခုနေယောက်လို့ဟ အေးအရာဟို ပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","အဲလိုလဲ နတ်ဆိုးဟ သူလို့အား “ငါဟ ယေရှုဟို သိအယ် ပင်းတော့ ပေါလု အကျောန်းဟိုလည်း သိသော်လည်း နင်လို့ဟ စသူလုန်း” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","အေးနောက် နတ်ဆိုးဝင်ပူးနေသူဟ သူလို့အပေါ်ဟို ခုန်တက်ကာ သူလို့အားလုံးဟို နှိမ်နှင်းယွေ့ အနိန်ယူသောကျောန့် သူလို့ဟ အေးနေအိုင်မှ အဝတ်မပါဘဲ ဒဏ်ရာများနဲ့ ထွက်ပြေးရကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","အေးအကျောန်းဟို ဧဖက်မြို့တွင် နေထိန်ကြသော ယုဒအမျိုးသားနဲ့ လူမျိုးခြားများလို့ဟ ကြားကြသောအခါ၊ သူလို့အားလုံးဟ ကြောက်ရွံ့ခြင်းနဲ့ ပြေ့ပင်း သခင် ယေရှုရဲ့ နာမတော်ဟို ချီးမွန်းကြကုန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ယုံကြည်သူအများလို့ဟ လာပင်း လူသိဆှင်ကြား မိမိလို့ လုပ်ခဲ့သောအရာများဟို ဖော်ထုတ်ပြခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","မှော်အတတ်ဟို ကျင့်သောသူများစွာလို့ဟ မိမိလို့ရဲ့ စာလိပ်များဟို ယူခဲ့ယွေ့ လူအပေါင်းလို့ဆေ့မှာ မီးရှို့ကြအယ်။ အေးစာလိပ်များရဲ့ တန်ဖိုးဟို တွက်ချက်ကျေ့သောအခါ ငွေဒင်္ဂါး ၅၀,၀၀၀ မျှ ဆိကျောန်း တွေ့ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ဟေလို တန်ခိုးတော်နဲ့ ပြေ့သောအားဖြင့် ဘုရားသခင်ရဲ့ စကားတော်များဟာ ဆက်လက်ပင်း ပိုယွေ့ တိုးပွားလာခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","အေးအရာများ ဖြစ်ပျက်ပင်းနောက် မာကေဒေါနိပြေနဲ့ အခါယပြေမှတဆင့် ယေရုရှလင်မြို့ဟို သွားရန် ပေါလုဟ စိတ်ဆုံးဖြတ်အယ်။ သူဟ “အေးနေရာဟို ငါသွားပင်းနောက် ရောမမြို့ဟိုလည်း သွားရမယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","သူ့ဟို ကူညီပေးလဲ့ နေယောက်ဖြစ်သော တိမောသေနဲ့ ဧရတ္တုလို့ဟို မာကေဒေါနိပြေဟို စေလွှတ်ပင်းမှ သူဟ အာရှပြေတွင် ကာလအချိန် အနည်းငယ်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","အေးအချိန်နှိုက် ဘုရားသခင်ရဲ့ လမ်းစဉ်အတွက်ကျောန့် ဧဖက်မြို့တွင် ဆူပူလှုပ်ဆှားမှုကြီး ဖြစ်ပေါ်လာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ဒေမေတရိ နာမယ်ဆိသော ငွေပန်းထိမ်ဆရာဟ အာတေမိနတ်သမီးရဲ့ ငွေဗိမာန်ငယ်လို့ဟို လုပ်ခြင်းအားဖြင့် လက်မှုပညာသည်များစွာ ငွေဝင်လမ်း ဖြောင့်စေခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","အေးသူဟ ပန်းထိန်သမားများနဲ့ တခြားလုပ်ငန်းဆိုင်ရာ အလုပ်သမားများဟို စည်းရုံးစေပင်း “ငါ့ မိတ်ဆွေလို့၊ ဟေလုပ်ငန်းဖြင့် ငါလို့ အကျိုးစီးပွားဖြစ်တာဟို နင်လို့ သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","အခုတွင် ပေါလုဆိုသူဟ ဧဖက်မြို့တွင် သာမက အာရှပြေတခုလုံးလိုလိုနှိုက်ပင် လူ့လက်ဖြင့် ပြုလုပ်လဲ့ ဘုရားများဟ ဘုရားလုံးဝ မဟုတ်ဟု ဆိုယွေ့ လူအပေါင်းလို့ဟို ဖြားယောင်းသွေးဆောင်တာဟို နင်လို့ မျော်လျက် ကြားလျက် ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","အေးလို့ဆိုရင် ငါလို့ရဲ့ လုပ်ငန်းဟလည်း နာမယ်ပျက်စေမယ့် အန္တရာယ်ဆိအယ်။ အဲအရာသာမက ကြီးမြတ်သော နတ်ဘုရားမ အာတေမိရဲ့ ဗိမာန်တော်ဟ ပစာအရာမှ အဓိပ္ပာယ်ဆိတော့မှာ မဟုတ်ဘဲ အာရှပြေနဲ့ ကမ္ဘာတဝန်းလုံးဆိ လူတိုင်းကိုးကွယ်သော နတ်ဘုရားမရဲ့ ကြီးမြတ်မှုဟို ဖျက်ဆီးခံရလိမ့်မယ်” ဟု ပြောဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","လူအုပ်ကြီးဟ အေးစကားများဟို ကြားရင် သူလို့ဟ ရမ်းဆာ့ အူထော့ပင်း “ဧဖက်မြို့ရဲ့ အာတေမိ နတ်သမီးဟ ကြီးမြတ်ပေအယ်” ဟု စတင် အော်ဟစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","တမြို့လုံး ရုန်းရင်း ဆန်ခတ် ဖြစ်လေအယ်။ ပေါလုရဲ့ ခရီးသွားဖော်များဖြစ်လဲ့ မာကေဒေါနိပြေသား ဂါယုနဲ့ အာရိတ္တာခုလို့ဟို ဖမ်းဆီးယွေ့ ပြဇာတ်ရုံကြီးဟို တဟုန်ထိုး ပြေးဝင်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ပေါလုဟ သူ့တတ်တိုင်း လူအုပ်ကြီးလို့ ဆိရာဟို သွားဖို့ အလိုဆိအယ် အဲလိုလဲ တဘဲ့တော်များဟ သူ့ဟို သွားဖို့ ခွင့်မပြုဝူး။ ");
INSERT INTO dnv_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","သူရဲ့ မိတ်ဆွေများဖြစ်သော ပြေနယ် အာဏာဆိအချို့လို့ဟလည်း ပြဇာတ်ရုံထဲဟို မဝင်ရန် တောင်းပန်စာ တစောင် ပို့လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","အေးအတောအတွင်း အစည်းအဝေး တခုလုံးဟ ရုန်းရင်းဆန်ခတ် ဖြစ်ခဲ့ပင်း၊ လူအချို့လို့ဟ အရာတခုတည်းအတွက် အော်ဟစ်ကြကာ တခြားသူများဟလည်း တခြားဟာ တခုခုအတွက် အော်ဟစ်ခဲ့ကြအယ်။ ပစာကို့ သူလို့ထဲဟ လူအများစုဟာ သူလို့ ပစာကျောန့် အတူတကွ လာရတာဆိုတာတောင် မသိကြ။ ");
INSERT INTO dnv_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ယုဒအမျိုးသားလို့ဟ အာလေဇန္ဒြုဟို လူများဆေ့ဟို သွားစေသဖြင့် လူထုအထဲမှ လူအချို့လို့ဟ အေးသူဟ ဖြစ်ပေါ်လျက်ဆိသည့် အရေးအခင်းနဲ့ ပတ်သက်သူဖြစ်မယ်ဟု ယူဆကြအယ်။ အဲပင်းရင် အာလေဇန္ဒြုဟ လူများအား တိတ်ရန် လက်ရိပ်ပြအယ်၊ ချေပပြောဆိုရန် ကြိုးစားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","အဲလိုလဲ သူဟ ယုဒလူမျိုးဖြစ်တာဟို သူလို့ သတိထားမိကြသောအခါ “ဧဖက်မြို့သားလို့ရဲ့ အာတေမိဟ ကြီးမြတ်အယ်” ဟု သူလို့ဟ နေနာရီကြအောန် အတူအတွ အရာတခုတည်း သံပြိုင်အော်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","နောက်ဆုံးနှိုက် မြို့စာရေးဟ လူအုပ်ကြီးလို့အား ငြိမ်သက်အောန် လုပ်နိန်ခဲ့အယ်။ “ဧဖက်မြို့သားလို့၊ ဧဖက်မြို့ဟ ကြီးမြတ်လဲ့ အာတေမိရဲ့ ဗိမာန်တော်နဲ့ ခေါန်းခင်ဘုံမှ ကျလာလဲ့ ရုပ်တုတည်ဆိရာ ဌာနဖြစ်ကျောန်းဟို အယောက်ဆီတိုင်း သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","အေးအရာများဟို စသူမှ မငြင်းဆိုနိန်။ သို့ဖြစ်ယွေ့ နင်လို့ဟ ပစာအမှုဟိုမှ မဆင်မခြင် မလုပ်ဘဲ တိတ်ဆိတ်စွာ နေသင့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","နင်လို့ဟ ဟေနေရာဟို ခေါ်ဆောင်ခဲ့ကြသော ဟေသူလို့ဟ ဗိမာန်တော်ထဲ ဝင်ယွေ့ လုယက်သောသူ မဟုတ်။ ငါလို့ရဲ့ ဘုရားများဟို မကောင်းသော စကားဟို ပြောသောသူလည်း မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ဒေမေတရိနဲ့ သူရဲ့အလုပ်သမားများဟ တစုံတယောက်ဟို တရားစွဲဆိုချင်ရင် တရားရုံး ဖွင့်ရက်များနဲ့ အာဏာပိုင်များဆိသဖြင့် ရုံးတော်တွင် တရားစွဲဆို နိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","အဲလိုလဲ နင်လို့ဟ လိုချင်လဲ့အရာ တခုခုဆိရင် အေးစာဟို နိုင်ငံသားတွေရဲ့ တရားဝင် အစည်းအဝေးမှာ စီရင်ဆုံးဖြတ်ရမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ခုနေ့ ဖြစ်ပျက်ပင်းတဲ့အခါ ငါလို့ဟို အထိကရုဏ်းအဖြစ် စွပ်စွဲခံရမှာဟို စိုးရိမ်စရာ ဆိအယ်။ အေးဆူပူအုံကြွမှုတွေအတွက် အကျောန်းပြချက် ဆိဝူး၊ အေးကျောန့် ငါလို့အတွက် အကျောန်းပြချက်ကောင်း မပေးနိန်ခဲ့ဘူး။” ");
INSERT INTO dnv_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","အေးအရာများဟို ပြောပင်းနောက် သူဟ အစည်းအဝေးဟို ဖျက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ဆူပူလှုပ်ဆှားမှု ရပ်သွားပင်းနောက်၊ ပေါလုဟ တဘဲ့တော်များဟို ခေါ်ယွေ့ ခွန်အားပေးစကား ပြောပင်းနောက် သူလို့ဟို နှုတ်ဆက်ကြအယ်။ အေးနောက် သူဟ မာကေဒေါနိပြေဟို ထွက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","သူဟ အေးဒေသများဟို ဖြတ်သန်းပင်း ယုံကြည်သူလို့ဟို ခွန်အားပေးစကားများနဲ့ တရားစကားများစွာဟို ပြောကြားအယ်။ အဲပင်းရင် သူဟ အခါယပြေဟို လာခဲ့ယွေ့၊ ");
INSERT INTO dnv_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","သူဟ အေးမှာ သုံးလလောက် နေအယ်။ သူဟ ရှုရိပြေဟို သွားဖို့ အဆင်သင့် ဖြစ်နေပင်း ယုဒလူလို့ဟ သူ့ဟို မကောင်းကြံနေသောကျောန့် သူဟ မာကေဒေါနိပြေဟို ဖြတ်ပင်း ပြန်သွားဖို့ ဆုံးဖြတ်ချက်ချအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ဗေရိမြို့သား ပုရုရဲ့ သားဖြစ်သူ သောပတရု၊ သက်သာလောနိတ်မြို့သားများ ဖြစ်ကြသော အာရိတ္တာခုနဲ့ သေကန္နု၊ ဒေရဗေမြို့သားဖြစ်သူ ဂါယု၊ အာရှနယ်သားများ ဖြစ်ကြသော တုခိတ်နဲ့ တရောဖိမ်၊ တိမောသေဟလည်း ပေါလုနဲ့အတူ လိုက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","အေးသူလို့ဟ အရင်သွားနဲ့ကြပင်း တရောမြို့နှိုက် ငါလို့အား စောင့်နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ငါလို့ဟ တဆေးမဲ့မုန့်ပွဲ ပီးသောအခါ ဖိလိပ္ပိမြို့မှ ရွက်လွင့်ယွေ့ လာရာ ငါးရက်ကြာပင်းနောက် သူလို့ဆိရာ တရောမြို့ဟို ရောက်ယွေ့ အေးမြို့တွင် ခုနေရက်လောက် နေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","တပတ်ရဲ့ ပထမ စနေနေ့ ညနေမှာ မိတ်သဟာယ စားပွဲအတွက် ငါလို့အတူတကွ စုရုံးခဲ့အယ်။ ပေါလုဟ နောက်တနေ့ မထွက်သွားခင် အချိန်ထိ သူဟ လူများနဲ့ ညသခေါင်အချိန်တိုင်အောန် စကားပြောလျက် နေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ငါလို့ တွေ့ဆုံလဲ့ အပေါ်ထပ် အခန်းမှာ မီးဖူးများစွာ ထွန်းလျက်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ဥတု နာမယ်ဆိသော လူပဲ့ငယ်တယောက်ဟ ပြတင်းပေါက်နားမှာ ထိန်နေအယ်။ ပေါလုဟ ဆက်ယွေ့ စကားပြောနေချိန်၊ ဥတုဟ ငိန်းကျာ့လာပင်း အိပ်မွေသွားခဲ့အယ်။ နောက်ဆုံးနှိုက် အိပ်မွေသွားပင်း နေအိုင်ရဲ့ တတိယအထပ်မှ မြေပေါ်ဟို လှိမ့်ကျလေအယ်။ သူလို့ဟ သူ့ဟို မချီလိုက်သောအခါ သူဟ သေပင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","အဲလိုလဲ ပေါလုဟလည်း အောက်ဟို ဆင်းလာခဲ့ပင်း အေးသူရဲ့ အပေါ်ဟို ကိုယ်ကိုလှဲလျက် ဖက်ထားပင်းမှ “မစိုးရိမ်ကြနဲ့၊ သူဟ အသက်ဆှင်လျက် ဆိသေးအယ်” ဟု သူဟ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","အေးနောက် သူဟ အပေါ်ထပ်ဟို ပြန်တက်သွားကာ မုန့်ဟို ဖဲ့ပင်း စားကြအယ်။ သူလို့နဲ့ အရုဏ်တက်ချိန်တိုင်အောန် အချိန်အကြာကြီး စကားပြောပင်းနောက် ပေါလု ထွက်သွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","သူလို့ဟ အသက်ဆှင်သော လူပဲ့သငယ်ဟို နေအိုင်သို့ ခေါ်သွားပင်းမှ ရမ်းဆာ့ စိတ်သက်သာခြင်း ဆိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ငါလို့ဟ သင်္ဘောဆေဟို အမြန်သွားယွေ့ အဿုမြို့ဟို အရင်သွားကြအယ်။ အေးဟို ငါလို့သွားရခြင်းမှာ ပေါလုဟို သင်္ဘောစီးစေရန် ဖြစ်အယ်။ အေးလိုမျိုး စီစဉ်ခြင်းမှာ သူဟ အေးမြို့ဟို ကုန်းကျောန်း ဖြစ်သွားရန် စီစဉ်ထားယွေ့ အေးလို့မှာကြားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","သူဟ အဿုမြို့မှာ ငါလို့နဲ့ တွေ့ဆုံသောအခါ၊ ငါလို့ဟ သူ့ဟို သင်္ဘောပေါ်ဟို ခေါ်တင်ပင်း မိတုလင်မြို့ဟို သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","အေးမှ ငါလို့ ရွက်လွင့်ယွေ့ နောက်တနေ့မှာ ခိအုကျွန်းဟို ရောက်ကြအယ်။ တရက်ကြာပင်းနောက် ငါလို့ သာမုကျွန်းဟို ဝင်ယွေ့ နောက်တနေ့တွင် မိလက်မြို့ဟို ရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ပေါလုဟ အာရှမှာ အချိန်မကုန်စေလိုသဖြင့် ဧဖက်မြို့ အနီးမှ ဖြတ်ပင်း ရွက်လွင့်ရန် ဆုံးဖြတ်ထားအယ်။ သူဟ ဖြစ်နိန်ရင် ပင်တေကုတ္တေပွဲတော်အမှီ ယေရုရှလင်မြို့ဟို ရောက်ဖို့ အမြန် ခရီးသွားလျက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ပေါလုဟ ဧဖက်မြို့ အသင်းတော်လူကြီးများဟ သူနဲ့လာရောက်တွေ့ဆုံဖို့ မိလက်မြို့မှ သတင်းစကားပါး လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","သူလို့ ရောက်သောအခါ ပေါလုဟ သူလို့အား “ငါဟ အာရှနယ်ဟို ရောက်လဲ့နေ့မှစပင်း နင်လို့နဲ့အတူ ဆိနေခဲ့လဲ့ အချိန်ကာလ တဆှောက်လုံးတွင် စလို အသက်ဆှင်ခဲ့တာဟို နင်လို့ သိအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ယုဒလူအချို့လို့ရဲ့ မကောင်းကြံစည်များကျောန့် အခက်ခဲ ရောက်ဆိနေချိန်တွင် မျက်ရည်များစွာ ကျလျက် နှိမ့်ချကာ ဘုရားသခင်ရဲ့ အစေခံအဖြစ် အမှုတော်ဟို ငါ ဆောင်ရွက်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","နင်လို့သိလဲ့အတိုင်း လူအများဆေ့တွင် လည်းကောင်း၊ နင်လို့ နေအိုင်များတွင် လည်းကောင်း၊ ငါဟောပြော သွန်သင်သောအခါ နင်လို့အား အကျိုးဆိစေမဲ့ စကားများဟို ပစာအခါမှ မချန်ထားခဲ့။ ");
INSERT INTO dnv_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","နောင်တရယွေ့ ဘုရားသခင်ဆေဟို ချဉ်းကပ်ကြစေရန်နဲ့ ငါလို့ သခင် ယေရှုဟို ယုံကြည်ကြစေရန် ငါဟ ယုဒလူများနဲ့ လူမျိုးခြားများအား လေးနက်စွာ သတိပေးခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","အခုမှာ ငါဟ သန့်ဆှင်းသော ဝိညာဉ်တော်ရဲ့ အမိန့်ဟို နားထောင်ပင်း ယေရုရှလင်မြို့ဟို သွားရမယ်။ အေးမှာ ပစာဖြစ်လိမ့်မယ်ဆိုတာဟို ငါ မသိ။ ");
INSERT INTO dnv_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ တုတ်ချေခြင်းနဲ့ ဆင်းရဲဒုက္ခများဟ မြို့တိုင်းတွင် ငါဟို စောင့်နေကျောန်း သတိပေးတာဟို ငါ သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","အဲလိုလဲ ဘုရားသခင်ရဲ့ကျေးဇူးတော်အကျောန်း သတင်းကောင်းဟို သက်သေခံစေယွေ့၊ သခင် ယေရှုဟ ငါ့ဟို ပေးအပ်ထားသော အမှုတော်လုပ်ငန်း ပီးမြောက်စေနိန်ရန်အတွက်ဆိုရင် ငါဟ မိမိအသက်ဟိုပင် နှမြောခြင်း မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“အခုဟ နိုင်ငံတော်အကျောန်းဟို နင်လို့အားလုံး အလယ်နှိုက် လှည့်လည်ဟောပြောခဲ့သော ငါ့ရဲ့မျက်နှာဟို နင်လို့ မျော်ရတော့မှာ မဟုတ်ကျောန်း ငါ သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","အေးကျောန့် နင်လို့အားလုံးရဲ့ ဆုံးရှုံးမှုဟ ငါ့မှာ တာဝန်မဆိဝူးဟု ခုနေ့နှိုက် နင်လို့အား ငါ သက်သေခံအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","အကျောန်းမှာ ဘုရားသခင်ရဲ့ ရည်ရွယ်ချက်ဟို နင်လို့အား အကုန်အစင် ပြောပြခြင်းအမှုဟို ငါဟ မဆှောင်မလွဲဘဲ ပြုခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","နင်လို့ဟ မိမိကိုယ်ကိုလည်းကောင်း၊ သိုးများအားလုံးဟို လည်းကောင်း ဂရုစိုက်ကြလော၊ ကိုယ်တော်ရဲ့ အသွေးတော်အားဖြင့် ဝယ်ယူထားသော ဘုရားသခင်ရဲ့ အသင်းတော်ဟို နင်လို့ အုပ်ထိန်းစေရန် အေးသိုးစုဟို ကြီးကြပ်သူအဖြစ် သန့်ဆှင်းသော ဝိညာဉ်တော်ဟ နင်လို့ဟို ခန့်ထားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ငါ ထွက်ခွာသွားလဲ့နောက် ရက်စက်ကြမ်းကြုတ်သော ဝံပုလွေများဟ နင်လို့အထဲဟို ရောက်လာယွေ့ သိုးများဟို မညာဘဲ ပြုမူကြမယ်ဖြစ်ကျောန်းဟို ငါ သိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","တဘဲ့တော်များဟို သွေးဆောင်ဖို့ ဝါပြောတတ်သော လူလို့ဟ နင်လို့အထဲနှိုက်လည်း ပေါ်လာမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","သတိနဲ့ နေကြလော၊ အဲပင်းရင် ငါဟ နင်လို့အပေါင်းအား သုံးနှစ်ပတ်လုံး နေ့ညမပြတ် မျက်ရည်ကျလျက် ဆုံးမသွန်သင်ခဲ့တာဟို သတိရကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“အခု နင်လို့အား ဘုရားသခင်နှိုက် လည်းကောင်း၊ ကိုယ်တော်ရဲ့ ကျေးဇူးတော်နဲ့ဆိုင်သော နှုတ်ကပတ်တော်နှိုက် လည်းကောင်း ငါ အပ်နှံအယ်။ နှုတ်ကပတ်တော်ဟ နင်လို့ဟို တည်ဆောက်မြှင့်တင်လျက် သန့်ဆှင်းစေခြင်း ခံရသောသူ အပေါင်းလို့နဲ့အတူ အမွေဟို ရဆိစေနိန်စွမ်း ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ငါဟ သူတပါးရဲ့ ဆွေ၊ ငွေ၊ အဝတ်အစားများဟို လိုချင်တပ်မက်ခြင်း မဆိ။ ");
INSERT INTO dnv_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ငါဟ ဟေလက်များဖြင့် အလုပ်လုပ်ယွေ့ ငါနဲ့ ငါ့အပေါင်းဖော်များရဲ့ လိုအပ်တာများဟို ဖြည့်ဆည်းခဲ့ကျောန်း နင်လို့တတ်တိုင်း သိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","အေးလို့ ကြိုးစား လုပ်ဆောင်ယွေ့ အားနည်းသော သူလို့ဟို ကူညီမစသင့်ကျောန်းနဲ့ ‘ပေးကမ်းခြင်းဟ ရယူခြင်းထက် သာယွေ့ မင်္ဂလာဆိအယ်’ ဟု သခင် ယေရှုတတ်တိုင်း မိန့်လဲ့စကားဟို သတိရသင့်ကျောန်း အရာရာနှိုက် နင်လို့အား ငါ ပြသအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ပေါလုဟ အဲလို့ဆိုပင်းသောအခါ သူဟ ဒူးထောက်ယွေ့ သူလို့နဲ့အတူ ဆုတောင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","သူလို့ဟ ပေါလုဟို ဖက်ပင်း ငိုကာ သူ့ဟို နမ်းယွေ့ နှုတ်ဆက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ပေါလုဟ သူ့ဟို နောက်ဖယ်တော့မှ ပြန်တွေ့တော့မှာ ဟုတ်ဝူးလို့ ပြောခဲ့သောကျောန့် သူလို့ဟ အထူးသဖြင့် ဝမ်းနည်းကြအယ်၊ အေးပင်းနောက် သင်္ဘောဆေဟို သူနဲ့အတူ လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ငါလို့ဟ အေးသူလို့ဟို နှုတ်ဆက် ထွက်ခွာပင်းနောက် တန်းတန်း ရွက်လွင့်ယွေ့ ကောသကျွန်းဟို ငါလို့ သွားကြအယ်။ နောက်တနေ့နှိုက် ရောဒုကျွန်းဟို ရောက်ယွေ့၊ အေးကျွန်းမှ ပါတရမြို့ဟို ငါလို့ သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ဖိနိတ်ပြေဟို သွားမဲ့ သင်္ဘောတစီးဟို မျော်သဖြင့် အေးသင်္ဘောပေါ်ဟို တက်ယွေ့ ခရီးပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ငါလို့ဟ ကုပရုကျွန်းဟို မျော်ရသောအခါ အေးကျွန်းရဲ့ တောင်ဖက်မှ သွားပင်း ရှုရိပြေဟို ရွက်လွင့်ကြအယ်။ တုရုမြို့တွင် ကုန်ပစ္စည်းများဟို ချရမယ် ဖြစ်ယွေ့ အေးမြို့တွင် သင်္ဘောဟို ဆိုက်ကပ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","အေးမှာ တဘဲ့တော်အချို့လို့နဲ့ တွေ့ပင်း သူလို့နဲ့အတူ တပတ်လောက် နေကြအယ်။ ဝိညာဉ်တော်ရဲ့ တန်ခိုးအားဖြင့် သူလို့ဟ ပေါလုဟို ယေရုရှလင်မြို့ဟို မသွားရန် ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","အဲလိုလဲ သူလို့နဲ့အတူ ငါလို့ရဲ့အချိန်များ ကုန်လွန်သောအခါ၊ ငါလို့ဟ ထွက်သွားပင်း ခရီးဆက်သွားခဲ့အယ်။ သူလို့အားလုံးလို့ဟ မိမိလို့ရဲ့ ပေါင်အိုမများ၊ လူပဲ့ငယ်များနဲ့အတူ မြို့ပြင် ပင်လယ်ကမ်းဟို ရောက်အောန် လိုက်ပို့ကြအယ်။ ငါလို့ဟ ပင်လယ်ကမ်းခြေမှာ ဒူးထောက်ယွေ့ ဆုတောင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","အေးနောက် တယောက်နဲ့တယောက် နှုတ်ဆက်ပင်း၊ ငါလို့ဟ သင်္ဘောပေါ်ဟို တက်ယွေ့ သူလို့ဟ မိမိလို့နေအိုင်ဟို ပြန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","တုရုမြို့မှ ဆက်ယွေ့ ငါလို့ဟ ပတောလင်မြို့ဟို ရောက်ကြအယ်။ အေးမြို့တွင် ယုံကြည်သူလို့ဟို နှုတ်ဆက်ပင်းနောက် သူလို့ဆေမှာ တရက်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","နောက်တနေ့နှိုက် ထွက်သွားယွေ့ ကဲသရိမြို့ဟို ရောက်ကြအယ်။ အေးမှာ ဧဝံဂေလိ တရားဟောဆရာ ဖိလိပ္ပုရဲ့ နေအိုင်တွင် ငါလို့ တည်းခိုကြအယ်။ သူဟ တဘဲ့တော်များဟို ကူညီရန် ယေရုရှလင်မြို့ အသင်းတော်ဟ ရွေးချယ်သော လူခုနေယောက်လို့တွင် တဦးဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","သူ့မှာ ဘုရားသခင်ရဲ့ တရားတော်ဟို ဟောပြော ကြေညာသူများ အိမ်ထောင်မကျသေးသော သမီးလေးယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","အေးနေအိုင်တွင် ငါလို့ တည်းခိုယွေ့ ရက်အတော် အတန်ကြာသောအခါ အာဂဗု နာမယ်ဆိသော ပရောဖက်ဟ ယုဒပြေမှ ရောက်ဆိလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","သူဟ ငါလို့ဆေဟို လာယွေ့ ပေါလုရဲ့ ခါးကြိုးဟို ယူပင်းရင် မိမိရဲ့ ခြေနဲ့လက်လို့ဟို တုတ်ချေပင်းနောက် “ဟေ ခါးကြိုးပိုင်ဆှင်အား ယုဒလူများလို့ဟ ယေရုရှလင်မြို့တွင် ဟေလို့ တုတ်ချေယွေ့ လူမျိုးခြားလို့ရဲ့ လက်ဟို အပ်နှံကြလိမ့်မယ်လို့ သန့်ဆှင်းသော ဝိညာဉ်တော် မိန့်အယ်” ဟု ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","အေးအရာဟို ငါလို့ ကြားသောအခါ ငါလို့နဲ့ အေးမှာ ဆိသောသူလို့ဟ ယေရုရှလင်မြို့ဟို မသွားရန် ပေါလုအား တောင်းပန်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","အဲလိုလဲ ပေါလုဟ “ပစာကျောန့် ဟေလို့ ငိုကကာ စိတ်နေလုံး ကြေကွဲနေကြလုန်း၊ ငါဟ သခင် ယေရှုနာမအားဖြင့် ယေရုရှလင်မြို့တွင် တုတ်ချေခံရန် သာမက အေးမှာ အသေခံရန်ပင် အသင့်ဆိပါအယ်” လို့ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ငါလို့ဟ သူဟို ဖျောင်းဖျယွေ့ မရသောကျောန့် “သခင်ဘုရားရဲ့ အလိုအတိုင်း ဖြစ်ပါစေ” ဟု ဆိုကာ လက်လျော့လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","အေးမှာ ရက်အနည်းငယ် ကြာပင်းနောက် ငါလို့ ပစ္စည်းများဟို ထုတ်ပိုးပင်း ယေရုရှလင်မြို့ဟို တက်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ကဲသရိမြို့မှ တဘဲ့တော် တချို့လို့ဟ ငါလို့နဲ့အတူ လိုက်ခဲ့ပင်းရင် ငါလို့အား ကုပရုကျွန်းသား အစောပိုင်းဟ ယုံကြည်သူဖြစ်သူ မနာသုန်ရဲ့ နေအိုင်မှာ တည်းခိုရန် ခေါ်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ငါလို့ ယေရုရှလင်မြို့ဟို ရောက်သောအခါ ယုံကြည်သူလို့ဟ ငါလို့အား နွေးထွေးစွာ ကြိုဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","နောက်တနေ့မှာ ပေါလုဟ ငါလို့နဲ့အတူ ယာကုပ်ဆေဟို သွားရောက် တွေ့ဆုံရင်၊ အသင်းတော်ရဲ့ လူကြီးများ အားလုံးဟလည်း သူဆေမှာ ရောက်ဆိနေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ပေါလုဟ သူလို့ဟို နှုတ်ဆက်ပင်း မိမိရဲ့အလုပ်အားဖြင့် လူမျိုးခြားလို့အား ဘုရားသခင် ပြုခဲ့သောအမှုအရာ အားလုံးလို့ဟို ပြေ့စုံစွာ တင်ပြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","သူဆေဟ ကြားရပင်းနောက် သူလို့အားလုံးဟ ဘုရားဟို ချီးမွန်းကြအယ်။ အေးနောက် သူလို့ဟ “ညီအကို ပေါလု၊ ယုဒလူ ထောင်ပေါင်းများစွာဟ ယုံကြည်သူများ ဖြစ်လာကျောန်းနဲ့ သူလို့အားလုံး ပညတ်တရားဟို စိတ်အားထက်သန်သူများ ဖြစ်ကျောန်းဟို နင်လို့ မျော်နိန်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","နင်ဟ လူမျိုးခြားလို့ထဲတွင် နေထိန်ကြသော ယုဒအမျိုးသားလို့အား နင်လို့ရဲ့ လူပဲ့သငယ်များဟို အရေဖျားလှီးခြင်း မပေးကြနဲ့ အဲဟာမဟုတ်ရင် ယုဒ စလေ့အတိုင်းဟို မလိုက်နာကြရန် ပြောလျက် မောရှေရဲ့ ပညတ်တရားဟို စွန့်စေရန် သင်ကြားလျက် ဆိကျောန်းဟို သူလို့ ကြားသိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","သို့ဖြစ်ယွေ့ ငါလို့ စလို လုပ်ရမလုန်း။ နင်လို့ရောက်နေကျောန်းဟို သူလို့ဟ ကြားရမှာ သေချာပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","အေးအရာဟ ငါလို့ နင့်ဟို လုပ်စေချင်လဲ့အတိုင်း လုပ်လော့။ အေးမှာ သစ္စာကတိဟို ပြုထားသော လူလေးယောက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","အေးသူလို့ဟို ခေါ်သွားပင်း သူလို့နဲ့အတူ သန့်ဆှင်းခြင်းဟို ခံယူလျက် သူလို့ခေါင်းဟို ကတုံးရိတ်ရန် သူလို့အတွက် စရိတ်ခံပေးပါလော့။ အေးလို့ပြုရင် နင်လို့နဲ့ ပတ်သက်ယွေ့ သူလို့ ကြားသိထားသော သတင်းဟ ကစတ်ကလတ်ဘဲ နင်လို့တတ်တိုင်း ပညတ်တရားဟို စောင့်ထိန်းလျက် လိုက်ဆှောက်ကျောန်း သူလို့အားလုံး သိကြလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ယုံကြည်သူများ ဖြစ်လာသော လူမျိုးခြားလို့အတွက်မှာ ရုပ်တုများဟို ပူဇော်လဲ့ အစားအစာ၊ အသွေး၊ လည်ပင်း ညှစ်ယွေ့ သတ်ထားသော အကောင်ဟို မစားရန်နဲ့ ကာမဂုဏ်လိုက်စားမှုဟို ဆှောင်ကြဉ်ရန် ငါလို့ စီရင်ဆုံးဖြတ်ယွေ့ သူလို့ဆေဟို စာရေး အကျောန်းကြားပင်းပါပီ” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","အေးကျောန့် ပေါလုဟ နောက်တနေ့နှိုက် အေးလူလို့ဟို ခေါ်ပင်းရင် သူလို့နဲ့အတူ သန့်စင်ခြင်းဟို ပြုကြအယ်။ အေးနောက်သူဟ ဗိမာန်တော်ဟို သွားယွေ့ သန့်စင်ခြင်းဟို ပြုပင်း ပီးဆုံးမဲ့အချိန်နဲ့ မိမိလို့တဦးစီအတွက် ပူဇော်သကာ ဆက်သရမဲ့အချိန်လို့ဟို ကြိုတင် အကျောန်းကြား ထားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ခုနေရက်စေ့ခါနီးသောအခါ အာရှပြေမှ လာသော ယုဒလူအချို့လို့ဟ ပေါလုဟို ဗိမာန်တော်တွင် မျော်ကြအယ်။ သူလို့ဟ လူအုပ်လို့အား ရုန်းရင်းဆန်ခတ် ဖြစ်စေပင်း ပေါလုဟို ဖမ်းဆီးကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","သူလို့ဟ “ဣသရေလလူများ ကူညီကြပါ၊ ဟေလူဟ နေရာတကာသွားပင်း ဣသရေလလူများဟို လည်းကောင်း၊ ဟေဗိမာန်တော်မှာ မောရှေရဲ့ ပညတ်တရားဟို လည်းကောင်း ဆန့်ကျင်ပင်း လူအားလုံးလို့ဟို သင်ကြားပေးသူ ဖြစ်အယ်။ အေးစာတင် မကဝူး အခုသူဟ လူမျိုးခြားလို့ဟို ဗိမာန်တော်ထဲဟို ခေါ်လာပင်း ဟေသန့်ဆှင်းလဲ့နေရာဟို စုတ်ပဲ့စေပီ” လို့ အော်ပြောကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ပစာကို့ သူလို့ဟ ပေါလုဟို ဧဖက်မြို့သား တရောဖိမ်ဆိုသူနဲ့အတူ မြို့ထဲတွင် မျော်ခဲ့ယွေ့ ဗိမာန်တော်ထဲဟို ပေါလု ခေါ်ခဲ့တာလို့ ထင်သောကျောန့် ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","တမြို့လုံးဟ ရုန်းရင်းဆန်ခတ် ဖြစ်ယွေ့ လူလို့ဟ ပြေးယွေ့ လာပင်း ပေါလုဟို ဖမ်းဆီးကာ ဗိမာန်တော် အပြင်ဟို ဆွဲထုတ်သွားကြအယ်။ တခါတည်း ဗိမာန်တော်ရဲ့ ထင်ခါးများဟို ပိတ်လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","သူလို့ဟ ပေါလုဟို သတ်ဖို့ ကြိုးစားနေခါ ယေရုရှလင်မြို့ တမြို့လုံး ရုန်းရင်းဆန်ခတ် ဖြစ်နေအယ်ဟူသော သတင်းဟ ရောမတပ်မှူးဆေ ရောက်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","သူဟ ခုတင်ချင်း တပ်သားများနဲ့ တပ်မှူးများဟို အမြန်ခေါ်ယွေ့ လူအုပ်ကြီးဆိရာဟို ဆင်းလာအယ်။ လူလို့ဟ တပ်သားများနဲ့ တပ်မှူးဟို မျော်သောအခါ ပေါလုဟို ရိုက်ခြင်းမှ ရပ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","အေးအခါ တပ်မှူးဟ ပေါလုဆေဟို သွားပင်း သူ့ဟို ဖမ်းဆီးကာ သံကြိုးနေချောင်းနဲ့ တုတ်ချေရန် အမိန့်ပေးအယ်။ အေးနောက် သူဟ “အေးသူဟ စသူလုန်း၊ သူဟ ပစာအမှုဟို လုပ်လုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","လူအုပ်အချို့လို့ဟ တယောက်တမျိုးစီ အော်ကြအယ်။ အေးလို့ နောန်းနင်းခတ်သံများကျောန့် တပ်မှူးဟ ပစာဖြစ်တာဟို အတိအကျ မသိနိန်သဖြင့် ပေါလုဟို ရဲတိုက်ထဲဟို ခေါ်သွားစေရန် အမိန့်ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ပေါလုဟ လှေခါးဟို ရောက်သောအခါ လူလို့ဟ အကြမ်းဖက်မှု ပြင်းထန်လာသဖြင့် စစ်သားများဟ သူဟို မချီသွားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ရမ်းဆာ့သော လူလို့ဟ နောက်မှလိုက်လာယွေ့ “သူ့ဟို သတ်ပါ” ဟု အော်ပင်း လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ပေါလုဟ သူ့အား ရဲတိုက်ထဲဟို ခေါ်သွားမယ် လုပ်သောအခါ သူဟ တပ်မှူးဟို “ငါ နင့်ဟို တခု ပြောပါရစေ” ဟု ဆိုအယ်။ “နင် ဟေလသစကားဟို ပြောတတ်သလော” ဟု တပ်မှူးဟ မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“မကြာခင်အခါဟ ပုန်ကန်ယွေ့ သူပုန် ၄,၀၀၀ ဟို ယိုးယွေ့ တောကန္တာရဟို ခေါ်သွားသော အဲဂုတ္တုအမျိုးသားပင် မဟုတ်လော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ပေါလုဟ “ငါဟ ယုဒလူ ဖြစ်အယ်၊ ကိလိကိပြေရဲ့ မြို့တော်ဖြစ်သော တာရှုမြို့နှိုက် မွေးဖွားခဲ့သူ ဖြစ်အယ်။ ကျေးဇူးပြုပင်း ငါ့လူများနဲ့ စကားပြောခွင့်ပေးပါ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","တပ်မှူးဟ သူ့ဟို အခွင့်ပေးသဖြင့် ပေါလုဟ လှေခါးထစ်ပေါ်တွင် ရပ်ယွေ့ လူလို့အား တိတ်ဆိတ်ရန် လက်ရိပ်ပြအယ်။ သူလို့ တိတ်ဆိတ်နေကြသောအခါ ပေါလုဟ ဟေဗြဲစကားနဲ့ ပြောလျက်၊ ");
INSERT INTO dnv_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ညီအကိုများနဲ့ အဖလို့ အခု ငါ ပြန်ခုခံမဲ့ စကားဟို နားထောင်ကြပါ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","သူလို့ဟ မိမိလို့အား ဟေဗြဲစကားဖြင့် ပြောဆိုတာဟို ကြားသောအခါ ပိုယွေ့ တိတ်ဆိတ်နေကြအယ်။ ပေါလုဟ ဆက်ပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ငါဟ ကိလိကိပြေ၊ တာရှုမြို့တွင် မွေးဖွားခဲ့သော ယုဒလူ ဖြစ်ပါအယ်။ အဲလိုလဲ ဟေမြို့တွင် ကြီးပြင်းလာယွေ့ ဂါမလျေလရဲ့ နည်းခံယွေ့ ဖိုးဖေးလို့မှ ဆက်ခံသော ပညတ်တရားနဲ့အညီ တင်းကျပ်စွာ ဆုံးမသွန်သင်ခြင်းဟို ခံယူပင်း ခုနေ့ နင်လို့အားလုံးဟ ဘုရားသခင်အတွက် စိတ်အားထက်သန်သလိုမျိုး ငါဟလည်း စိတ်အားထက်သန်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ငါဟ သူရဲ့ လမ်းစဉ်ဟို လိုက်ဆှောက်သော သူများအား အသေသတ်လဲ့အထိ ငြင်းဆဲခဲ့ပါအယ်။ ငါဟ ယောက်ျားနဲ့ မိန်းမလို့ဟို ဖမ်းဆီးယွေ့ ထောင်ချခဲ့ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ငါပြောတာဟ မန်ကျောန်းဟို ယဇ်ပုရောဟိတ်မင်းနဲ့တကွ တရားရုံးမှာဆိလဲ့သူ အပေါင်းလို့ဟ သက်သေခံကြပါအယ်။ ငါဟ အေးသူလို့ဆေမှ ဒမာသက်မြို့နေ ယုဒညီအကိုဆေ ရေးပေးလိုက်တဲ့ အမှာစာများဟို ရယူအယ်။ အေးကျောန့် အေးမှာဆိလဲ့ သူလို့အား အပစ်ဒဏ်စီရင်ခြင်းငှာ ဖမ်းဆီး တုတ်ချေလျက် ယေရုရှလင်မြို့ဟို ထွက်သွားပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ငါဟ ခရီးသွားယွေ့ ဒမာသက်မြို့အနီးဟို ရောက်သောအခါ၊ မွန်းတည့်အချိန်တွင် ခေါန်းခင်မှ တောက်ပလဲ့ အလင်းရောင်ကြီး တခုဟ ခုတုံး ငါ့ပတ်လည်တွင် ထွန်းလင်းတောက်ပအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ငါဟ မြေကြီးပေါ် လဲကျသွားရာ ‘ရှောလု၊ ရှောလု၊ နင်ဟ ပစာကျောန့် ငါ့ဟို ငြင်းဆဲလုန်း’ ဟု ပြောသောအသံဟို ကြားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘အဆှင်၊ ကိုယ်တော်ဟ စသူလုန်း’ လို့ မေးသော် ကိုယ်တော်ဟ ‘ငါဟ နင်ငြင်းဆဲသော နာဇရက်မြို့သား ယေရှုပင် ဖြစ်အယ်’ ဟု ငါ့ဟို ပြန်ပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ငါနဲ့အတူ ပါလာသောသူလို့ဟ အလင်းဟို မျော်ရပေမဲ့လည်း ငါ့အား ပြောသောသူရဲ့ အသံဟို မကြားရကြ။ ");
INSERT INTO dnv_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ငါဟ ‘အဆှင်၊ ငါဟ ပစာ လုပ်ရမလုန်း’ ဟု မေးပင်း အဆှင်ဟ ‘ထပင်း ဒမာသက်မြို့ဟို သွားလော့။ နင်ဆောင်ရွက်ရန် ခွဲခန့်စီမံထားလဲ့ အမှုအရာအားလုံးဟို အေးမြို့တွင် နင့်အား ပြောမယ်’ ဟု ပြန်ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","တောက်ပလဲ့ အလင်းရောင်ကျောန့် ငါ မျက်စေ့ ကွယ်သွားသဖြင့် ငါနဲ့အတူ ပါလာကြသော သူလို့ဟ ငါ့ဟို လက်ဆွဲပင်း ဒမာသက်မြို့ဟို ပို့ဆောင်ပေးရကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“အေးမြို့မှာ အာနနိလို့ နာမယ်ဆိလဲ့ လူတယောက် ဆိအယ်။ သူဟ ပညတ်တရားဟို နာခံယွေ့ ဘုရားဝတ်နှိုက် မွေ့လျော်တဲ့သူ ဖြစ်ပင်း ဒမာသက်မြို့ဆိ ယုဒအမျိုးသား အပေါင်းလို့ရဲ့ ရိုသေလေးစားခြင်းဟိုလည်း ခံရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","သူဟ ငါဆေ လာယွေ့ အနားမှာ ရပ်ပင်း ‘ညီရှောလု၊ မျက်စေ့ ပြန်မျော်လော့’ ဟု ငါ့အား ပြောဆိုရင်၊ အေးခဏချင်းတွင် ငါဟ သူ့ဟို မျော်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","သူဟ ‘နင်သည် ငါလို့ဖိုးဖေးများ ဘုရားသခင်ဟ မိမိအလိုတော်ဟို သိစေရန် လည်းကောင်း၊ ကိုယ်တော်ရဲ့ ဖြောင့်မတ်သော အစေခံအား မျော်စေရန် လည်းကောင်း၊ အေးအဆှင်ရဲ့ စလောင်မှ အသံဟို ကြားစေရန် လည်းကောင်း ကိုယ်တော်ဟ နင့်အား ရွေးချယ်လေပီ။ ");
INSERT INTO dnv_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","နင်ဟ မျော်ရကြားရလဲ့အရာများဟို လူအားလုံးဟ ပြောကြားရန် အေးသူရဲ့ သက်သေဟို ခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","အခု ပစာကျောန့် အချိန်အကြာရီး စောင့်နေလုန်း။ ထပင်း နှစ်ခြင်းဟို ခံလော့။ နင့်ရဲ့ အပစ်များဟို လွှတ်ဖို့ ကိုယ်တော်ရဲ့ နာမဟို ခေါ်ပင်း ဆုတောင်းလော့’ ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ငါဟ ယေရုရှလင်မြို့ဟို ပြန်သွားပင်း ဗိမာန်တော်ထဲမှာ ဆုတောင်းနေစဉ် ရူပါရုံဟို မျော်ရစဉ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","အေးခါတွင် အဆှင်ဟို ငါ မျော်ယွေ့ ကိုယ်တော်ဟ ‘ယေရုရှလင်မြို့မှ အလျင်အမြန် ထွက်သွားလော့၊ ပစာကို့ ဟေမှာဆိလဲ့ လူများဟ ငါ့ရဲ့အကျောန်းနဲ့ ပတ်သက်သော နင်ရဲ့ သက်သေခံချက်ဟို လက်ခံကြလိမ့်မယ် မဟုတ်’ လို့ ငါ့ဟို ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ငါဟ ‘အဆှင်၊ တရားဇရပ်လို့ဟို သွားယွေ့ ကိုယ်တော်ဟို ယုံကြည်ကြသော သူလို့အား ဖိုင်ယွေ့ ဖမ်းဆီးခဲ့သူမှာ ငါဖြစ်ကျောန်းဟို သူလို့ ကောင်းစွာ သိကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ကိုယ်တော်ရဲ့ အကျောန်း သက်သေခံသူ သတေဖန်ဟို သတ်ကြသောအခါနှိုက်လည်း ငါတတ်တိုင်းလည်း အနီးတွင် ရပ်လျက် အလိုတူအလိုပါ ဖြစ်ကာ သူ့ဟို သတ်ကြသော သူလို့ရဲ့ အဝတ်များဟို စောင့်ပေးခဲ့ပါအယ်’ ဟု ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","အဆှင်ဟ ‘သွားလော့၊ ရပ်ဝေးဆိ လူမျိုးခြားလို့ဆေ နင့်ဟို ငါ စေလွှတ်လိမ့်မယ်’ ဟု ငါ့ဟို ပြောခဲ့အယ်။” ");
INSERT INTO dnv_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","လူလို့ဟ ပေါလုရဲ့ စကားဟို ဟေမျှအထိ နားထောင်ကြအယ်။ အဲပင်းရင် သူလို့ဟ အသံဟို ထိပ်ဆုံးထိရောက်အောန် အော်ဟစ်ကြတာဟ “သူ့ဟို မြေကြီးပြင်မှ သုတ်သင် ပယ်ဆှင်းပါ။ သူဟ အသက်ဆှင်ရင် မသင့်” ဟု ဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","သူလို့ဟ ဝတ်လုံများဟို ဝှေ့ရမ်းကာ မြေမှုန့်ဟို မိုးခေါန်းခင်ဟို ပစ်လောလျက် အော်ဟစ်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ရောမတပ်မှူးကြီးဟ ပေါလုဟို ရဲတိုက်ထဲဟို ခေါ်သွားရန်နဲ့ ပစာကျောန့် ယုဒလူလို့ သူ့ဟို ဆန့်ကျင်လျက် အေးလို့ အော်ဟစ်ရကျောန်းဟို သိဆိရန်အတွက် ပေါလုအား ရိုက်ယွေ့ စစ်ဆေးရန် အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","အဲလိုလဲ သူ့ဟို ကြာပွတ်နဲ့ ကြိမ်ဒဏ်ခတ်ရန် တုတ်ချေကြသောအခါ ပေါလုဟ အေးမှာရပ်နေလဲ့ တပ်မှူးအား “ရောမနိုင်ငံသား တယောက်ဟို စစ်ဆေးစီရင်ခြင်း မပြုဘဲ ကြိမ်ဒဏ်ခတ်ခြင်းမှာ တရားဥပဒေနဲ့ ကိုက်ညီပါသလော” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","တပ်မှူးဟ အေးစကားဟို ကြားသောအခါ သူဟ တပ်မှူးကြီးဆေဟို သွားပင်း “စလို လုပ်မလုန်း၊ အေးလူဟ ရောမနိုင်ငံသား ဖြစ်အယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","အေးကျောန့် တပ်မှူးကြီးဟ ပေါလုဆေဟို သွားပင်း “နင်ဟ ရောမနိုင်ငံသားလော၊ ငါ့ဟို ပြောပါ” ဟု သူ့ဟို မေးလေအယ်။ ပေါလုဟ “ဟုတ်အယ်” လို့ ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","တပ်မှူးကြီးဟ “ငါဟ ပိတ်ဆန် အများရီး ပေးခြင်းအားဖြင့် နိုင်ငံသား ဖြစ်လာအယ်” ဟု ဆိုရင် ပေါလုဟ “ငါဟ ရောမနိုင်ငံသားအဖြစ် မွေးဖွားလာအယ်” ဟု ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","သူ့ဟို စစ်မေးမဲ့ သူလို့ဟလည်း ခုတင်ချင်း နောက်ဟို ဆုတ်ခွာ သွားကြလေအယ်။ ပေါလုဟ ရောမနိုင်ငံသား ဖြစ်တာဟို လည်းကောင်း၊ သူ့အား သံကြိုးဖြင့် တုတ်ချေမိတာဟို လည်းကောင်း သိမျော်ကြသောအခါ တပ်မှူးကြီးဟ ကြောက်လန့်လေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","တပ်မှူးဟ ပေါလုအား ယုဒလူများလို့ဟ ပစာပစ်မှုဖြင့် စွပ်စွဲကြတာဟို သေချာ သိချင်ကြအယ်။ အေးလို့ဖြစ်ယွေ့ နောက်တနေ့နှိုက် ပေါလုအား တုတ်ချေထားလဲ့ သံကြိုးဟို ဖယ်ဆှားစေပင်း ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ယုဒတရားလွှတ်တော် အဖွဲ့ဝင်အပေါင်းလို့ဟို စုဝေးကြရန် အမိန့်ပေးလေအယ်။ အေးနောက် ပေါလုဟို ခေါ်ကာ အေးသူလို့ဆေ့တွင် ရပ်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ပေါလုဟ တရားလွှတ်တော်အဖွဲ့ဟို တန်းတန်းကျေ့ပင်း “ငါ့ညီအကိုလို့ ငါဟ ခုနေ့တိုင်အောန် တသက်လုံး ဘုရားသခင် ဆေ့တော်တွင် ဩတ္တပ္ပစိတ် ကြည်လင်ပင်း ကောင်းစွာ နေထိန်ခဲ့ပါအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ယဇ်ပုရောဟိတ်မင်း အာနနိဟလည်း သူ့အနီးတွင် ရပ်နေသူများအား ပေါလုရဲ့ စလောင်ဟို ရိုက်ရန် အမိန့်ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ပေါလုဟ သူ့အား “အဖြူရောင် သုတ်ထားသော နံရံ၊ နင်လို့ဟို ဘုရားသခင်ဟ အမန်ဒဏ်ခတ်မယ်။ နင်ဟ ငါအား တရားဥပဒေအရ စီရင်ရန် တရားရုံးတွင် ထိန်လျက် နေချိန်နှိုက် ငါ့ဟို ရိုက်ခိုင်းခြင်းဖြင့် ဥပဒေဟို ချိုးဖောက်အယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ပေါလုရဲ့ အနီးတွင် ရပ်နေသော သူလို့ဟ “နင်ဟ ဘုရားသခင်ရဲ့ ယဇ်ပုရောဟိတ်မင်းဟို ဆဲသလော” လို့ မေးရင်၊ ");
INSERT INTO dnv_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ပေါလုဟ “ညီအကိုလို့၊ အေးသူဟ ယဇ်ပုရောဟိတ်မင်း ဖြစ်တာဟို ငါ မသိပါ။ ကျမ်းစာဟ ‘နင်ရဲ့လူများဟို အုပ်စိုးသောသူအား မကောင်းသော စကားဟို မပြောရ’ ဟု ပြောအယ်။” ");
INSERT INTO dnv_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ပေါလုဟ တရားရုံးထဲတွင် တဖွဲ့ဟ ဖာရိရှဲများ ဖြစ်ယွေ့ တခြားတဖွဲ့ဟ ဇဒ္ဒုကဲများ ဖြစ်ကျောန်းဟို သိမျော်သောအခါ “ငါ့ ညီအကိုလို့၊ ငါဟ ဖာရိရှဲ ဖြစ်ပင်း ဖာရိရှဲရဲ့ သားလည်း ဖြစ်အယ်။ သေသူလို့ဟ ဆှင်ပြန်ထမြောက်မယ်ဟို မျော်လင့်သူဖြစ်သဖြင့် အခု ငါဟလည်း စစ်ဆေးခံနေရခြင်း ဖြစ်အယ်” ဟု တရားရုံးဆေ့တွင် အော်ပင်းပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","အေးလို့ ပေါလု ပြောလိုက်သောအခါ ဖာရိရှဲများနဲ့ ဇဒ္ဒုကဲလို့ကြားတွင် သဘောထားကွဲလွဲမှု ဖြစ်ပေါ်ယွေ့ အစုအဝေးဟ အုပ်စုကွဲသွားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","အကျောန်းမှာ ဇဒ္ဒုကဲလို့ဟ သေခြင်းမှ ထမြောက်ခြင်း မဆိ၊ ခေါန်းခင်တမန် မဆိ၊ ဝိညာဉ် မဆိဟု ဆိုကြအယ်။ အဲလိုလဲ ဖာရိရှဲလို့ဟ အေးအရာသုံးခုလုံးဟို ဆိအယ်လို့ ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","အော်ပြောဆိုမှုဟ ပိုယွေ့ ကျယ်လာပင်း၊ ဖာရိရှဲဂိုဏ်းဝင် ကျမ်းတတ်ဆရာ တချို့လို့ဟ ထယွေ့ “ဟေသူနှိုက် ပစာအပစ်ဟိုမျှ ငါလို့ မတွေ့၊ ဝိညာဉ်တပါး အဲဟာမဟုတ်ရင် ခေါန်းခင်တမန် တပါးပါးဟ သူ့အား မြွက်ဆိုကောင်း မြွက်ဆိုခဲ့လိမ့်မယ်” လို့ ပြင်းထန်စွာ ငြင်းခုန် ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ငြင်းခုန်မှုဟ ရမ်းဆာ့ ပြင်းထန်လာသဖြင့် ပေါလုဟို အပိုင်းပိုင်းဆုတ်ဖြတ်မယ်ဟို တပ်မှူးကြီးဟ စိုးရိမ်အယ်။ အဲလိုမို့ သူဟ စစ်သားများအား ဆင်းသွားယွေ့ ပေါလုအား အေးသူလို့ဆေမှ အတင်းခေါ်လာပင်း၊ ရဲတိုက်ထဲဟို ခေါ်သွားရန် အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","အေးညနှိုက် ဘုရားသခင်ဟ ပေါလုရဲ့ အနီးတွင် ရပ်လျက် “မကြောက်နဲ့၊ နင်ဟ ယေရုရှလင်မြို့တွင် ငါ့ရဲ့အကျောန်းဟို သက်သေခံခဲ့သလိုမျိုး ရောမမြို့တွင်လည်း သက်သေခံရ အုံးမယ်” ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","နောက်တနေ့ မနက်နှိုက် ယုဒလူများနဲ့ အတူတကွ တွေ့ဆုံပင်း အစီစဉ်များဟို ပြုလုပ်ကြအယ်။ ပေါလုဟို မသတ်ရမချင်း ငါလို့ မစားမသောက်ဘဲ နေမယ်လို့ သူလို့ သစ္စာကတိပြုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","အေးလျှို့ဝှက်ကြံစည်လဲ့သူများမှာ အယောက်လေးဆယ်ကျော် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","သူလို့ဟ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ လူအကြီးအကဲလို့ဆေဟို သွားယွေ့ “ငါလို့ဟ ပေါလုဟို မသတ်ရမချင်း ပစာအရာဟိုမှ မစားမသောက်ပါဟု သစ္စာကတိပြုထားကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","အဲလိုမို့ အခု အဆှင်လို့ဟ တရားလွှတ်တော် အဖွဲ့ဝင်နဲ့အတူ ပေါလုရဲ့ အချက်အလက်ဟို ပိုမိုသေချာစွာ စုံစမ်းစစ်ဆေး လိုဟန်ပြုသဖြင့် သူ့ဟို အဆှင်ဆေခေါ်လာရန် ရောမတပ်မှူးကြီးအား ဆှောက်ထားကြပါ။ အဲလိုလဲ ငါလို့ဟ ဟေနေရာဟို သူမရောက်ခင် သူ့ဟို သတ်ရန် အဆင်သင့် ဆိနေအယ်” ဟု ဆှောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","အဲလိုလဲ အေးလို့ ချောင်းမြောင်းသတ်မယ့် အစီအစဉ်ဟို ပေါလု ညီမရဲ့ သားဟ ကြားသိသွားသဖြင့် ရဲတိုက်ထဲဟို ဝင်ပင်းရင် ပေါလုအား ပြောကြားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","အေးနောက် ပေါလုဟ အရာဆိတယောက်ဟို ခေါ်ပင်း “တပ်မှူးကြီးအား ပြောရန် ကိစ္စတခု ဆိယွေ့ အေးလူငယ်ဟို သူ့ဆေဟို ခေါ်သွားပေးပါ” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","အရာဆိဟ အေးသူဟို တပ်မှူးကြီးဆေဟို ခေါ်သွားပင်း “ထောင်သား ပေါလုဟ ငါ့ဟို ခေါ်ယွေ့ အေးလူငယ်ဟို အဆှင့်ဆေဟို ပို့ခိုင်းပါအယ်။ ပစာကို့ သူ့မှာ အဆှင့်အား ပြောရန် ကိစ္စတခု ဆိပါအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","တပ်မှူးဟ သူရဲ့ လက်ဟို ဆွဲယွေ့ တိတ်ဆိတ်ရာ နေရာဟို သွားပင်း “နင်ဟ ငါ့ဟို ပြောစရာဆိတာဟ ပစာလုန်း” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","သူဟ “ယုဒအာဏာပိုင်လို့ဟ ပေါလုရဲ့ အချက်အလက်ဟို ပိုမိုသေချာစွာ စုံစမ်းစစ်ဆေး လိုဟန်ပြုလျက် မနက်ဖြန်နေ့နှိုက် သူ့ဟို တရားရုံးဟို ခေါ်သွားရန် အဆှင့်အား တောင်းဆိုမယ်လို့ သဘောတူဆုံးဖြတ်ထားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","အဲလိုလဲ အေးမှာ လူလေးဆယ်ကျော် ပုန်းနေကြပင်း သူ့ဟို စောင့်လျက်ဆိနေသောကျောန့် သူလို့ပြောတာဟို နားမထောင်ကြပါနဲ့။ သူလို့ဟ သူ့ဟို မသတ်ရမချင်း မစားမသောက်ဘဲနေမယ်လို့ သစ္စာကတိပြုထားကြအယ်။ အခု သူလို့ဟ အသင့်ပြင်ဆင်ပင်း အဆှင့်ရဲ့ ဆုံးဖြတ်ချက်ဟို စောင့်နေကြအယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","တပ်မှူးကြီးဟ “ဟေအရာများဟို ငါ့အား နင်ပြောပြကျောန်း စသူဟိုမှ မပြောနဲ့” ဟု ဆိုပင်း အေးလူငယ်ဟို ပြန်လွှတ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","အေးနောက် တပ်မှူးကြီးဟ အရာဆိနေယောက်ဟို ခေါ်ယွေ့ “ခုနေ့ည ကိုးနာရီအချိန်နှိုက် ကဲသရိမြို့ဟို သွားရန် တပ်သား ၂၀၀၊ မြင်းတပ်သား ခုနေဆယ်နဲ့ လှံတပ်သား ၂၀၀ လို့ဟို ထွက်ခွာရန် အဆင်သင့်ဆိ စေကြလော့။ ");
INSERT INTO dnv_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ပေါလုအတွက် မြင်းများဟို ပြင်ထားပင်း မောင်းနှင်ယွေ့ သူ့ဟို ဘုရင်ခံမင်း ဖေလဇ်ဆေဟို လုံခြုံစွာ ပို့ပေးကြလော့” လို့ အမိန့်ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","အေးနောက် တပ်မှူးဟ ရေးလိုက်သော စာဟ၊ ");
INSERT INTO dnv_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ကလောဒိလုသိဆေမှ မြတ်သောဘုရင်ခံ ဖေလဇ်မင်းဆေဟို နှုတ်ခွန်းဆက်သလိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ယုဒလူလို့ဟ အေးသူဟို ဖမ်းပင်း သတ်မယ် လုပ်ကြအယ်။ သူဟ ရောမနိုင်ငံသားဖြစ်ကျောန်းဟို ငါ သိရသောကျောန့် ငါ့တပ်သားနဲ့အတူ သွားပင်း သူ့ဟို ကယ်တင်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ငါဟ သူ့ဟို ပစာပစ်မှုနဲ့ စွပ်စွဲကြကျောန်း သိချင်သောကျောန့် သူ့ဟို သူလို့ဆေမှ ယူပင်း တရားရုံးဟို ခေါ်သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","သူ့မှာ သေဒဏ်နဲ့ ထိုက်တန်သော အပစ်၊ အဲဟာမဟုတ်ရင် အကျဉ်းထားခြင်းဟို ခံထိုက်သော အပစ်တခုမှ မဆိကျောန်းဟို ငါ တွေ့ဆိပါအယ်။ သူဟို ပညတ်တရားနဲ့ ဆိုင်သော မေးခွန်းများနဲ့ ပတ်သက်ယွေ့ ပစ်တင်စွပ်စွဲကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","သူ့ဟို လုပ်ကြံရန် လျှို့ဝှက်ကြံစည်လျက် ဆိကျောန်းဟို သတင်းရဆိသောအခါ ငါဟ နင့်ဆေဟို တခါတည်း စေလွှတ်ရန် ဆုံးဖြတ်ချက်ချပါအယ်။ တရားလိုများအားလည်း မိမိလို့ရဲ့ အမှုဟို နင်ရဲ့ဆေ့တွင် ဆှောက်ထားစေရန် ညွှန်ကြားလိုက်ပါအယ်” ဟု ပါဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","တပ်သားဟလည်း တပ်မှူးရဲ့ အမိန့်ပေးလဲ့အတိုင်း သယ်ဆောင်လာကြအယ်။ သူလို့ဟ ပေါလုဟို ခေါ်ယွေ့ အန္တိပတရိမြို့အထိ ညတွင်းချင်း ပို့ဆောင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","နောက်တနေ့နှိုက် ခြေလျင်တပ်သားများဟ ရဲတိုက်ဟို ပြန်လာခဲ့ကြပင်း မြင်းတပ်သားများဟ ပေါလုနဲ့အတူ ဆက်လက်ပင်း ခရီးသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","သူလို့ဟ ပေါလုအား ကဲသရိမြို့ဟို ခေါ်သွားပင်း စာဟို ဘုရင်ခံမင်းအား ပေးယွေ့ ပေါလုဟို သူ့ဆေမှာ အပ်နှံကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ဘုရင်ခံမင်းဟ အေးစာဟို ဖတ်ပင်းနောက် ပေါလုအား ပစာပြေသား ဖြစ်သလောလို့ မေးအယ်။ သူဟ ကိလိကိပြေသားဖြစ်ကျောန်းဟို သိသောအခါ၊ ");
INSERT INTO dnv_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","သူဟ “ဟေအရပ်ဟို နင်ရဲ့ တရားလိုများ ရောက်လာသောအခါ နင့်ရဲ့အမှုဟို ငါ ကြားနာမယ်” ဟု ဆိုအယ်။ အေးနောက် ပေါလုဟို ဟေရုဒ်မင်းကြီး ဆောက်လုပ်ခဲ့သော နန်းတော်တွင် အစောင့်အကြပ်နဲ့ထားရန် အမိန့်ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ငါးရက်ကြာသောအခါ ယဇ်ပုရောဟိတ်မင်း အာနနိဟ အသင်းတော် လူကြီးအချို့လို့နဲ့ လိုက်ပါလျက် တေရတုလု နာမယ်ဆိသော ဆေ့နေနဲ့အတူ ကဲသရိမြို့ဟို ရောက်လာကြအယ်။ အေးသူလို့ဟ ဘုရင်ခံဖေလဇ်ရဲ့ ဆေ့တော်ဟို ဝင်ပင်း ပေါလုအကျောန်းနဲ့ ပတ်သက်ပင်း စွဲချက်တင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","အေးနောက် ပေါလုဟို ခေါ်ပင်းမှ တေရတုလုဟ သူ့ဟို စတင်စွပ်စွဲယွေ့ ဆှောက်ထားတာဟ၊ “မြတ်သော ဖေလဇ်မင်း၊ အဆှင့်အားဖြင့် ငါလို့ဟ ရမ်းဆာ့သော ငြိမ်းချမ်းမှုဟို ခံစားရလျက် အဆှင့်ရဲ့ အမြော်အမြင်ကျောန့် ဟေတိုင်းပြေတွင် ပြုပြင်ပြောင်းလဲမှုများ ဖြစ်ပေါ်နေပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","မြတ်သော ဖေလဇ်မင်း ငါလို့ဟ ဟေဆောင်ရွက်မှုများဟို နေရာတိုင်းနှိုက် အစဉ်အမြဲ အထူးကျေးဇူးတင်ပင်း ကြိုဆိုကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ငါဟ အဆှင့်ရဲ့ အချိန်ဟို ရမ်းဆာ့ မယူလိုပါ။ အဲလိုမို့ အကျဉ်းချုပ်အားဖြင့် ငါလို့ ဆှောက်ထားတာဟို သနားစိတ်နဲ့ နားထောင်ရန် ပန်ကြားပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ပြဿနာဟိုသာ လုပ်လေ့ဆိသော ဟေသူဟ ကမ္ဘာအရပ်ရပ်နှိုက် ယုဒလူမျိုးအပေါင်းလို့နှိုက် ဆူပူအုံကြွမှုများ ဖြစ်ပေါ်အောန် လှုံ့ဆော်နေသူဖြစ်ပင်း နာဇရက်ဂိုဏ်းခွဲရဲ့ ခေါင်းဆောင်တဦးလည်းဖြစ်ကျောန်း တွေ့ဆိရပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ဗိမာန်တော်ဟိုလည်း စုတ်ပဲ့စေရန် ကြိုးစားသဖြင့် သူ့ဟို ငါလို့ ဖမ်းဆီးခဲ့ကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ဟေအကျောန်းအရာအားလုံးနဲ့ ပတ်သက်ယွေ့ အဆှင်တတ်တိန်း သူ့ဟို စစ်ဆေးရင် သူ့အပေါ် ငါလို့ စွပ်စွဲနေလဲ့အချက်များဟို သိမျော်နိန်ပါလိမ့်မယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ယုဒလူလို့ဟလည်း ဟေစကားဟ အားလုံး မန်တာဖြစ်အယ်လို့ သူ့ဟို ဝိုင်းယွေ့ စွပ်စွဲကြလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ဘုရင်ခံမင်းဟ လက်ရိပ်ပြယွေ့ ပေါလုဟို ပြောဆိုခွင့်ပေးသောအခါ ပေါလုဟ၊ “နင်ဟ ဟေလူမျိုးအပေါ်နှိုက် နှစ်ပေါင်းများစွာ တရားစီရင်ခဲ့သူဖြစ်ကျောန်း ငါ သိပါအယ်။ အေးကျောန့် နင်ရဲ့ဆေ့မှာ ငါကိုယ်ငါ ခုခံကာကွယ်ရလို့ ငါပျော်မိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ငါဟ ယေရုရှလင်မြို့ဟို ဝတ်ပြုကိုးကွယ်ရန် သွားရောက်ခဲ့တာ တဆယ့်နေရက်ထက် မပိုသေးကျောန်း နင်တတ်တိုင်း စုံစမ်းသိဆိနိန်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ငါဟ ဗိမာန်တော်တွင် လည်းကောင်း၊ တရားဇရပ်နှိုက် အဲဟာမဟုတ်ရင် မြို့ထဲနှိုက် လည်းကောင်း၊ နေရာတကာနှိုက် လူများဟို မငြိမ်မသက်ဖြစ်အောန် တစုံတယောက်သောသူနဲ့ ငြင်းခုန်နေတာဟို ယုဒလူများ မတွေ့ခဲ့ကြပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","အခု ငါ့ဟို စွပ်စွဲပြောဆိုကြလဲ့ အချက်များနဲ့ ပတ်သက်ယွေ့လည်း သူလို့ဟ အဆှင့်ဆေမှာ သက်သေမပြနိန်ပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","အေးသူလို့ဟ လွဲမားတာဟု ယူဆလဲ့လမ်းစဉ်အရ ငါဟ ဖိုးဖေးများရဲ့ ဘုရားသခင်ဟို ကိုးကွယ်ကျောန်းဟို နင့်အား ငါ ဝန်ခံပါအယ်။ အဲလိုလဲ ငါဟ မောရှေရဲ့ ပညတ်ကျမ်းနဲ့ ပရောဖက်ကျမ်းများတွင် ရေးသားထားသမျှသော အရာလို့ဟို ယုံကြည်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","သူလို့တတ်တိုင်းလည်း မျော်လင့်သလိုမျိုး ဖြောင့်မတ်သောသူများ ဖြစ်စေ၊ မဖြောင့်မတ်သောသူများ ဖြစ်စေ နောင်တွင် ဆှင်ပြန်ထမြောက်ကြလိမ့်မယ်လို့ ဘုရားသခင်ဟို အမှီပြုယွေ့ မျှော်လင့်နေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","အေးကျောန့် ငါဟ ဘုရားသခင်ဆေ့ လူလို့ဆေ့တွင် ငါ့ရဲ့ ဩတ္တပ္ပစိတ်ကြည်လင်မှု ဆိစေရန် အမြဲတမ်း ကြိုးစားအားထုတ်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ငါဟ ယေရုရှလင်မြို့မှ ထွက်သွားယွေ့ နှစ်အတန်ကြာပင်းနောက် ငါ့ရဲ့ လူများအတွက် အလှူငွေတချို့ဟို ပေးကမ်းရန်နဲ့ ဘုရားသခင်ဟို ပူဇော်သကာဆက်သရန်အတွက် ငါ ပြန်ရောက်ဆိလာပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ဗိမာန်တော်ထဲတွင် သန့်ဆှင်းခြင်းဟို ခံယူပင်းနောက် ပူဇော်သကာဆက်သနေချိန်နှိုက် အေးသူလို့ဟ ငါဟို မျော်ကြပါအယ်။ အေးမှာ လူအုပ်ကြီးလည်း မဆိ၊ ရုန်းရင်းဆန်ခတ်လည်း မဖြစ်ခဲ့ပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","အဲလိုလဲ အေးနေရာတွင် အာရှနယ်မှလာသော ယုဒလူအချို့ ဆိကြအယ်။ ငါအား စွပ်စွဲပြောဆိုစရာဆိရင် သူလို့တတ်တိုင်း အဆှင့်ဆေ့ဟို လာယွေ့ အပစ်တင်သင့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","အားမှမဟုတ် ငါဟ တရားရုံးဆေ့မှာ ရပ်နေသောအခါ ငါနှိုက် စလိုပစ်မှုဟို သူလို့တွေ့ဆိကျောန်း အခုဆိသော ဟေသူလို့တတ်တိုင်း ထွက်ဆိုကြပါစေ။ ");
INSERT INTO dnv_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ငါဟ သူလို့ဆေ့နှိုက် ရပ်လျက် ‘ငါဟ သေသောသူလို့ ဆှင်ပြန်ထမြောက်ခြင်းနဲ့ ပတ်သက်ယွေ့ ခုနေ့ နင်လို့ဆေ့နှိုက် စစ်ဆေး စီရင်ခံနေရပါအယ်’ ဟူသော စကားတခွန်းဟိုသာ ကြွေးကြော်ခဲ့ပါအယ်” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ဖေလဇ်မင်းဟလည်း လမ်းစဉ်အကျောန်းဟို ကောင်းစွာ သိထားသူဖြစ်သဖြင့် အမှုကြားနာခြင်းဟို ရပ်နားလိုက်အယ်။ သူဟ “တပ်မှူးကြီး လုသိ ရောက်ဆိလာသောအခါမှ နင်လို့အမှုဟို ငါ စီရင်ချက်ချမယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ပေါလုဟို စောင့်ကြပ်ထားရန်နဲ့ လွတ်လပ်မှုဟို နည်းနည်းပေးယွေ့ သူ့ရဲ့ မိတ်ဆွေများ သူ့အား ပြုစုတာဟို မတားဆီးရန် အရာဆိအား မှာကြားလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ရက်အနည်းငယ်ကြာပင်းနောက် ဖေလဇ်မင်းဟ သူ့ရဲ့ ပေါင်အိုမ ယုဒအမျိုးသမီးဖြစ်သော ဒြုသိလေနဲ့အတူ ရောက်လာအယ်။ ဖေလဇ်မင်းဟ ပေါလုဟို ခေါ်ခိုင်းပင်းရင် ယေရှု ခရစ်တော်အား ယုံကြည်ခြင်းနဲ့ ပတ်သက်ပင်း သူဟောပြောသော တရားစကားများဟို ကြားနာလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","အဲလိုလဲ ပေါလုဟ ဖြောင့်မတ်ခြင်း အကျောန်းနဲ့ မိမိကိုယ်ကိုချုပ်တည်းခြင်း အကျောန်းဟိုလည်းကောင်း၊ လာမဲ့ တရားစီရင်ခြင်း နေ့ရက်အကျောန်းဟိုလည်းကောင်း ဟောပြောသောအခါ ဖေလဇ်မင်းဟ ကြောက်ခဲ့ပင်း “အခု နင် သွားနိန်ပီ။ နောက်အခွင့်ကြုံလဲ့အခါ နင့်ဟို ငါ ခေါ်အုံးမယ်” ဟု ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","အေးတချိန်တည်းမှာ ဖေလဇ်ဟ သူဟို ပိတ်ဆန်တချို့ ပေးလိမ့်မယ်လို့ မျော်လင့်ကာ အေးအကျောန်းပြချက်နဲ့ ပေါလုဟို ခဏခဏခေါ်ယွေ့ သူနဲ့စကားပြောလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","နေနှစ်လောက်ကြာပင်းနောက် ဖေလဇ်ရဲ့ ဘုရင်ခံရာထူးဟို ပေါကိဖေတ္တုဟ ဆက်ခံရအယ်။ ဖေလဇ်ဟ ယုဒလူမျိုးလို့ဆေမှ မျက်နှာရလိုသဖြင့် ပေါလုအား ဆက်ပင်း အကျဉ်းချထားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ဖေတ္တုဟ အေးနယ်ဟို ရောက်ယွေ့ သုံးရက်ကြာပင်းနောက် သူဟ ကဲသရိမြို့မှ ယေရုရှလင်မြို့ဟို သွားအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","အဲမှာ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ယုဒခေါင်းဆောင်များဟ အပစ်အမျိုးမျိုးဟို ပေါလု ကျူးလွန်ခဲ့ကျောန်း သူလို့ဟ ဖေတ္တုမင်းအား စွဲချက်တင်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","သူလို့အား မျက်နှာသာပေးလဲ့ အနေဖြင့် ပေါလုဟို ယေရုရှလင်မြို့ဟို လာရန် မေတ္တာရပ်ခံကြအယ်။ အကျောန်းမှာ သူလို့ဟ ပေါလုဟို လမ်းတွင် ချောင်းယွေ့ သတ်ရန် လျှို့ဝှက်ကြံစည်ထားပင်း ဖြစ်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ဖေတ္တုမင်းဟ “ပေါလုသည် ကဲသရိမြို့မှာ အကျဉ်းသားဖြစ် ထိန်းသိမ်းထားပင်း ငါတတ်တိုင်း အေးမြို့ဟို မကြာခင် ပြန်သွားမယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","နင်လို့ ခေါင်းဆောင်များဟ ကဲသရိမြို့ဟို သွားရန် ငါနဲ့အတူ လိုက်ယွေ့ ပေါလုနှိုက် တစုံတခု မားယွင်းခဲ့တာများဆိရင် သူ့ဟို စွပ်စွဲကြစေ” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ဖတ္တုမင်းဟ သူလို့နဲ့အတူ ဆစ်ရက် အဲဟာမဟုတ်ရင် ဆယ်ရက်လောက်နေပင်းမှ ကဲသရိမြို့ဟို သွားအယ်။ နောက်တနေ့နှိုက် တရားစီရင်ရာ တရားခွင်မှာ ထိန်ပင်း ပေါလုဟို ခေါ်သွင်းရန် အမိန့်ပေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ပေါလု ရောက်ဆိလာသောအခါ ယေရုရှလင်မြို့မှ ဆင်းလာသော ယုဒလူလို့ဟ သူ့ဘေးနားမှာ ရပ်ပင်း ကြီးလေးသော အပစ်များနဲ့ စွပ်စွဲပြောဆိုကြသော်လည်း သူလို့ဟ ခိုင်လုံသော သက်သေမပြနိန်ကြ။ ");
INSERT INTO dnv_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","အဲပင်းရင် ပေါလုဟ “ငါဟ ယုဒလူလို့ရဲ့ ပညတ်တရားဟို လည်းကောင်း၊ ဗိမာန်တော်ဟို လည်းကောင်း၊ ဧကရာဇ်ဟို လည်းကောင်း ပစ်မားမှုတခုဟိုမျှ မကျူးလွန်ခဲ့ပါ” လို့ ကာကွယ်ပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ဖေတ္တုမင်းဟ ယုဒလူလို့ဆေမှ မျက်နှာရလိုသဖြင့် ပေါလုအား “နင်ဟ ယေရုရှလင်မြို့ဟို တက်သွားယွေ့ အဲမြို့နှိုက် ငါဆေ့တွင် ဟေအမှုများနဲ့ ပတ်သက်ယွေ့ အစစ်ဆေးခံမယ်လော” ဟု မေးအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ပေါလုဟ “အခု ငါ့ဟို စစ်ဆေးစီရင်သင့်တဲ့နေရာ ဧကရာဇ် တရားစီရင်ရာ တရားခွင်တွင် ရပ်နေအယ်။ အဆှင် ကောင်းစွာသိလဲ့အတိုင်း ငါဟ ယုဒလူလို့အား ပစာဟိုမျှ မပစ်မားခဲ့ပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","အကယ်ယွေ့ ငါဟ တရားဥပဒေဟို ချိုးဖောက်ကာ သေဒဏ်ခံရန် ထိုက်တန်သော အပစ်တခုဟို ကျူးလွန်မိရင် ငါဟ အသက်ချမ်းသာခွင့်ဟို တောင်းဆိုမယ် မဟုတ်ပါ။ အဲလိုလဲ အေးသူလို့ စွပ်စွဲချက်များဟ မမန်ကန်ရင် စသူမှ ငါ့ဟို သူလို့ရဲ့ လက်ဟို ပေးအပ်နိန်ပါ။ ငါဟ ဧကရာဇ်မင်းဆေ အယူခံပါအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","အေးနောက် ဖေတ္တုမင်းဟ သူ့ရဲ့ အတိုင်ပင်ခံအရာဆိများနဲ့ တိုင်ပင်ပင်းနောက် “နင်ဟ ဧကရာဇ်မင်းဆေ အယူခံသဖြင့် ဧကရာဇ်မင်းဆေဟို သွားရမယ်” ဟု ပြန်ဖြေလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","အချိန် နည်းနည်းကြာပင်းနောက် အဂြိပ္ပဘုရင်နဲ့ ဗေရနိတ်လို့ဟ ဖေတ္တုမင်းဟို နှုတ်ဆက်ရန် ကဲသရိမြို့ဟို လာကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","အေးမြို့တွင် သူလို့ ရက်အတော်ကြာနေပင်းနောက် ဖေတ္တုမင်းဟ ပေါလုရဲ့ အခြေအနေဟို ဘုရင်အား ဆှင်းပြတာဟ “အေးအရပ်တွင် ဖေလဇ်မင်း အကျဉ်းချထားခဲ့လဲ့ လူတယောက် ဆိပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ငါ ယေရုရှလင်မြို့ဟို ရောက်ခဲ့စဉ်အခါဟ ယဇ်ပုရောဟိတ်ကြီးများနဲ့ ယုဒအကြီးအကဲများဟ ငါ့အား အေးသူဟို စွပ်စွဲချက် တင်ကြပင်းနောက် သူ့ဟို အပစ်ဒဏ်စီရင်ရန် တောင်းဆိုကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","အဲလိုလဲ စွပ်စွဲသောသူနဲ့ မျက်နှာချင်းဆိုင်ယွေ့ စွပ်စွဲချက်နဲ့ ပတ်သက်ပင်း ချေပပြောဆိုခွင့်မရခင် သူ့ဟို လွဲအပ်ပေးခြင်းဟ ရောမလို့ရဲ့ စလေ့ထုံးစံ မဟုတ်ကျောန်း သူလို့အား ငါ ဖြေကြားခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","သူလို့ ဟေသို့ ရောက်လာသောအခါ ငါဟ မဆိုင်းမလင့်ဘဲ နောက်တနေ့နှိုက် တရားပလ္လင်မှာ ငါ ထိန်ယွေ့ အေးသူဟို အခေါ်ခိုင်းပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","အမှုလုပ်သောသူများဟ ထယွေ့ သူ့ဟို စွပ်စွဲပြောဆိုကြသော်လည်း ငါထင်လဲ့ ပစ်မှုများဖြင့် မဟုတ်ပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","သူလို့ရဲ့ ဘာသာရေးနဲ့ ပတ်သက်ယွေ့လည်းကောင်း၊ ယေရှုလို့ ခေါ်လဲ့သူ အကျောန်းနဲ့ ပတ်သက်ယွေ့လည်းကောင်း၊ ငြင်းခုန်မှုသာ ဖြစ်ပါအယ်။ အေးယေရှုဟ အသက်ဆှင်လျက်ဆိတာဟု ပေါလုဟ ကြွေးကြော်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","အေးပြဿနာများဟို ဖြေဆှင်းရန် ငါ့မှာ မကျွမ်းသဖြင့် ပေါလုအား နင်ဟ ယေရုရှလင်မြို့ဟို သွားပင်းရင် ဟေစွပ်စွဲချက်များနဲ့ စပ်လျဉ်းယွေ့ အစစ်ဆေးခံလိုပါသလော ဟုမေးပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","အဲလိုလဲ ပေါလုဟ ဧကရာဇ်မင်းရဲ့ ဆုံးဖြတ်ချက်ဟို ခံယူလဲ့အထိ သူ့အား ထိန်းသိမ်းထားပါရန် တောင်းဆိုသဖြင့် သူ့ဟို ဧကရာဇ်မင်းဆေဟို အပ်ချိန်အထိ ချုပ်ထားရန် အမိန့်ပေးခဲ့ပါအယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","အဂြိပ္ပဘုရင်ဟ “အေးလူပြောတာဟို ငါတတ်တိုင်း ကြားလိုပါအယ်” ဟု ဖေတ္တုမင်းအား ဆိုအယ်။ “အေးသူ ပြောတာဟို မနက်ခါ ကြားရလိမ့်မယ်” လို့ ဖေတ္တုမင်းဟ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","နောက်တနေ့နှိုက် အဂြိပ္ပဘုရင်နဲ့ ဗေရနိတ်လို့ဟ ခမ်းနားကြီးကျယ်သော အဆောင်အယောင်များနဲ့အကွ စစ်တပ်အကြီးအကဲများ၊ မြို့ပေါ်ဆိ ဂုဏ်အသရေဆိ လူကြီးများနဲ့အတူ ကြွလာပင်း ညီလာခံခန်းမကြီးဟို ဝင်အယ်။ အေးအခါ ဖေတ္တုမင်းဟ အမိန့်ပေးသဖြင့် ပေါလုဟို ခေါ်သွင်းကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ဖေတ္တုမင်းဟ “အဂြိပ္ပဘုရင်နဲ့ ငါနဲ့အတူဆိသော လူကြီးမင်းအပေါင်းလို့၊ အဆှင်လို့ မျော်သော ဟေသူနဲ့ပတ်သက်ယွေ့ ယုဒအမျိုးသားထုအပေါင်းလို့ဟ သူ့ဟို ဆက်ယွေ့ အသက်မဆှင်စေသင့်ပါ ဟု အော်ဟစ်လျက် ယေရုရှလင်မြို့ ဖြစ်စေ၊ ဟေမြို့နှိုက် ဖြစ်စေ ငါ့အား တောင်းဆိုခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","အဲလိုလဲ သူဟ သေဒဏ်ခံထိုက်သော အပစ်တစုံတရာဟိုမျှ မကျူးလွန်ကျောန်းဟို ငါ့အနေဖြင့် သိပါအယ်။ အားပင်း သူတတ်တိုင်းဟ ဧကရာဇ်မင်းဆေမှာ အယူခံပါမယ်လို့ ပြောသဖြင့် သူ့ဟို အထံတော်ဟို ပို့ဆောင်ရန် ငါ ဆုံးဖြတ်ခဲ့ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","အဲလိုလဲ ဧကရာဇ်မင်းဆေ သူ့အကျောန်းရေးသားရန် တိကျသော အကျောန်းပြချက် တစုံတခုမှ ငါနှိုက် မဆိပါ။ အေးလိုမို့ ဟေစစ်ဆေးမေးမြန်းမှု ပီးဆုံးသောအခါ ငါ ရေးသားရန် အကျောန်းပြချက် တစုံတခုရဆိနိန်မဲ့အကျောန်း သူ့ဟို အဆှင်လို့ အဆေ့နှိုက်၊ အထူးသဖြင့် အဂြိပ္ပဘုရင် အဆှင့်အဆေ့နှိုက် ငါ ထုတ်ဆောင်ခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","အကျောန်းမှာ အကျဉ်းသားတဦးဟို သူ့အပေါ် စွဲချက်တင်တဲ့အပစ် တစုံတခုမဆိဘဲ စေလွှတ်ခြင်းမှာ မသင့်လျော်ဟု ငါ ထင်ပါအယ်” ဟု ဆိုလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","အဂြိပ္ပဘုရင်ဟ ပေါလုအား “နင့်အကျောန်း နင်တတ်တိုင်း ဆှောက်ထားနိန်အယ်” ဟု ဆိုသော် ပေါလုဟ လက်ဟို ဆန့်ယွေ့ သူ့တတ်တိုင်း ခုခံကာကွယ်သော စကားဟို ဟေလို့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“အဂြိပ္ပဘုရင်၊ ငါအား ယုဒလူများလို့ စွပ်စွဲချက်များနဲ့ ပတ်သက်ပင်း အဆှင်ရဲ့ ဆေ့တွင် ခုနေ့ ချေပရတာဟ ငါအဖို့ ထူးမြတ်လဲ့ အခွင့်အရေးပင် ဖြစ်တာဟု ယူဆပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","အထူးသဖြင့် ယုဒအမျိုးသားလို့ရဲ့ စလေ့များနဲ့ အငြင်းပွားတတ်လဲ့ ပြဿနာများဟို သိကျွမ်းသူဖြစ်သောကျောန့် ဖြစ်ပါအယ်။ အေးလို့ ဖြစ်ယွေ့ ငါ့ဆှောက်ထားချက်ဟို စိတ်ဆှည်လျက် နားထောင်ပါရန် ငါ တောင်းပန်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ငါဟ မိမိရဲ့ လူမျိုးထဲနှိုက် လည်းကောင်း၊ ယေရုရှလင်မြို့နှိုက် အစပြုခဲ့လဲ့ ငယ်ခါမှစပင်း ဖဝါ့တဆှောက်လုံး စလို နေထိန်ခဲ့တယ်ဆိုတာဟို ယုဒလူမျိုးအားလုံး သိကြပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","သူလို့ဟ ငါ့ဟို မခင်ကတည်းဟ သိထားကြအယ် ဖြစ်ယွေ့ ငါဟ ငါ့ဘာသာတွင် စည်းမျဉ်း အတင်းကျပ်ဆုံးသော ဂိုဏ်းဖြစ်သည့် ဖာရိရှဲဂိုဏ်းဝင်တဦးအဖြစ် အသက်ဆှင်ခဲ့ကျောန်း သူလို့ သက်သေခံလိုရင် သက်သေခံနိန်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ဘုရားသခင်ဟ ငါလို့ရဲ့ ဖိုးဖေးများအားထားလဲ့ ကတိတော်ဟို ငါမျော်လင့်လဲ့အတွက် အခုအခါ ငါဟ စစ်ဆေးခံနေရပါအယ် — ");
INSERT INTO dnv_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ငါလို့ရဲ့ မျိုးနွယ်စု တဆယ့်နေပါးလို့ဟ နေ့ညမပြတ် ဘုရားသခင်ဟို ကိုးကွယ်လျက် အေးကတိတော်ဟို ခံစားရရန် မျော်လင့်နေကြအယ်။ အဆှင်မင်းကြီး ဟေလို့ မျော်လင့်ခြင်းကျောန့် ငါအား ယုဒအမျိုးသားလို့ စွပ်စွဲပြောဆိုကြခြင်း ဖြစ်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","သေသောသူလို့ဟို ဘုရားသခင် ထမြောက်စေတာဟို မယုံနိန်စရာ” ဟု နင်လို့တွင် ပစာကျောန့် ထင်ကြလုန်း။ ");
INSERT INTO dnv_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ငါတတ်တိုင်းဟလည်း နာဇရက်မြို့သား ယေရှုရဲ့ နာမနဲ့ ဆန့်ကျင်လဲ့အရာများဟို ပြုသင့်တာဟု တွေးခဲ့ပင်း၊ ");
INSERT INTO dnv_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ယေရုရှလင်မြို့မှာ အေးလို့ လုပ်ခဲ့ပါအယ်။ ယဇ်ပုရောဟိတ်ကြီးများဆေမှ အခွင့်အာဏာရဆိဖြင့် ဘုရားသခင်ရဲ့ လူများဟို ထောင်ထဲမှာ အကျဉ်းချထားလျက် သူလို့အား သေဒဏ်စီရင်ချိန်နှိုက်လည်း ငါသဘောတူ ထောက်ခံခဲ့ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","တရားဇရပ်တိုင်းတွင်လည်း သူလို့ဟို မကြာခဏ ပစ်ဒဏ်ပေးလျက် ဘုရားသခင်ဟို စော်ကားပြောဆိုကြရန် အတင်းအကျပ် စေခိုင်းခဲ့ပါအယ်။ အေးလောက်မက သူလို့အပေါ် ရမ်းဆာ့ အူထော့ယွေ့ တိုင်းတပါးမြို့များထိတိုင်အောန် သူလို့ဟို လိုက်ပင်း ညှဉ်းဆဲခဲ့ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“အေးရည်ရွယ်ချက်ဖြင့် ငါဟ ယဇ်ပုရောဟိတ်ကြီးများဆေမှ အခွင့်အာဏာ ရယူယွေ့ ဒမာသက်မြို့ဟို သွားနေစဉ်၊ ");
INSERT INTO dnv_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","မွန်းတည့်ချိန်တွင် လမ်းမှာ နေရောင်ထက်မက ထွန်းလင်းတောက်ပလဲ့ အလင်းရောင်ဟို ငါမှစပင်း ငါနဲ့အတူ ခရီးသွားသောသူများ ပတ်လည်နှိုက် ခေါန်းခင်မှ တောက်ပတာဟို ငါမျော်ရပါအယ် အဆှင်မင်းကြီး။ ");
INSERT INTO dnv_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ငါလို့အားလုံးဟ မြေပေါ်ဟို လဲကျကြပင်း ဟေဗြဲစကားနဲ့ ‘ရှောလု၊ ရှောလု၊ နင်ဟ ပစာကျောန့် ငါ့ဟို နှိပ်စက်လုန်း၊ တုတ်ချွန်ဟို ကန်ရန် နင့်အတွက် ခက်ခဲအယ်’ လို့ ငါ့ဟိုပြောသော အသံဟို ငါ ကြားရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ငါဟ ‘အဆှင်၊ အဆှင်ဟ စသူလုန်း’ လို့မေးပင်း အဆှင်ဟ ‘ငါဟ နင်ညှဉ်းဆဲလဲ့ ယေရှု ဖြစ်အယ်လို့ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","အဲလိုလဲ ထယွေ့ မတ်တတ်ရပ်လော့။ နင့်အား ငါ့ရဲ့ အစေခံအဖြစ် ခန့်ထားရန် နင့်ဆေဟို ငါပေါ်လာခြင်း ဖြစ်အယ်။ ခုနေ့ နင်မျော်ရလဲ့ ငါ့ရဲ့အကျောန်းနဲ့ နောက်ခါ ငါဖော်ပြမဲ့ အကျောန်းအရာလို့ဟို နင်ဟ သူတပါးလို့အား သက်သေခံရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ငါဟ နင့်ဟို ဣသရေလူများလို့ရဲ့ လက်မှလည်းကောင်း၊ ငါစေလွှတ်သော တပါးအမျိုးသားများ လက်မှလည်းကောင်း နင့်ဟို ငါ ကယ်နုတ်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","နင်ဟ သူလို့ရဲ့ မျက်စေ့ဟို ဖွင့်ပေးယွေ့ သူလို့အား မိုက်မှ အလင်းသို့လည်းကောင်း၊ စာတန်ရဲ့ အာဏာထဲမှ ဘုရားသခင်ဆေဟို ပြောင်းလဲစေသဖြင့်၊ သူလို့ဟ ငါ့ဟို ယုံကြည်ခြင်းအားဖြင့် အပစ်များ ခွင့်လွှတ်ခြင်း ခံရကာ ဘုရားသခင် ရွေးကောက်သော လူစုတွင် ပါဝင်ရလိမ့်မယ်’ ဟု မိန့်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“အေးကျောန့် အဂြိပ္ပဘုရင်ဟ၊ ငါ ခေါန်းခင်မှ ရဆိလဲ့ ရူပါရုံဟို မနာခံခဲ့ပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ပထဦးဆုံး ဒမာသက်မြို့နှိုက်ဆိသော သူလို့ဟို လည်းကောင်း၊ အဲပင်းရင် ယေရုရှလင်မြို့မှစပင်း ယုဒပြေတပြေလုံးဆိ လူလို့အား လည်းကောင်း၊ လူမျိုးခြားလို့အား လည်းကောင်း အပစ်များမှ နောင်တရပင်း ဘုရားသခင်ဆေဟို ပြောင်းလဲကာ သူလို့ဟို နောင်တနဲ့ ထိုက်တန်သောအမှုများဟို ပြုကြရန် ငါ ဟောပြောခဲ့အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","အေးကျောန့် ယုဒလူလို့ဟ ဗိမာန်တော်ထဲမှာ ငါဆိနေချိန်နှိုက် ငါ့ဟို ဖမ်းဆီးယွေ့ သတ်ရန် သူလို့ ကြိုးစားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","အဲလိုလဲ ငါဟ ဘုရားသခင်ရဲ့ ကူညီမစခြင်းဟို ခံစားရယွေ့ ခုနေ့တိုင်အောန် ရပ်လျက် လူကြီး လူငယ်လို့အား သက်သေခံနေအယ်။ အေးလို့ သက်သေခံရာနှိုက် နောင်တွင် ဖြစ်ပျက်မယ်ဟု မောရှေနဲ့ ပရောဖက်လို့ ဟောပြောခဲ့လဲ့အရာများမှတပါး အခြားစလိုအရာဟိုမှ မပြောဆိုခဲ့ပါ။ ");
INSERT INTO dnv_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","သူလို့ ဟောပြောခဲ့လဲ့အရာမှာ မေဆှိယဟ ဝေဒနာဟို ခံရလျက် သေသောသူလို့ထဲမှ ပထမဦးဆုံး ထမြောက်ပင်း ဣသရေလူများနဲ့ လူမျိုးခြားလို့အား ကယ်တင်ခြင်း အလင်းရောင်ဟို ကြေညာလိမ့်မယ် ဖြစ်အယ်” ဟု ချေပပြောဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ပေါလုဟ မိမိတတ်တိုင်း အေးနည်းလမ်းနဲ့ ချေပပြောနေစဉ် ဖေတ္တုမင်းဟ “ပေါလု၊ နင်ဟ ရူးလေပီ၊ အတတ်ကျုးယွေ့ အရူးဖြစ်ခဲ့ပီ” ဟု အော်ယွေ့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ပေါလုဟ “မြတ်သော ဖေတ္တုမင်း၊ ငါဟ အရူး မဟုတ်ဝူး။ ငါဟ မန်ကန်ယွေ့ လေးနက်သောစကားလို့ဟို ပြောခြင်းသာ ဖြစ်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ဘုရင်အဂြိပ္ပ၊ အေးအရာများ အကျောန်းဟို နင်သိသောကျောန့် ငါဟ နင့်ဆေ့မှာ ရဲဝံ့စွာပြောဆိုခြင်း ဖြစ်အယ်။ အေးအမှုအရာများဟ ချောင်ကြိုချောင်ကြားတွင် ဖြစ်ပျက်ခဲ့တာ မဟုတ်ပါ။ အကျောန်းမှာ ၎င်းလို့အထဲမှ မင်းကြီး မသိသောအရာ တစုံတခုမှဆိမယ် မဟုတ်ဟု ငါ ထင်မြင်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","အဂြိပ္ပမင်းကြီး၊ အဆှင်ဟ ပရောဖက်များဟို ယုံကြည်သလော။ ယုံကြည်တာဟို ငါ သိပါအယ်” ဟု ဆှောက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","အဂြိပ္ပမင်းကြီးဟ ပေါလုအား “နင်ဟ အေးအချိန်တိုအတွင်း ငါ့ဟို ခရစ်ယာန်ဖြစ်အောန် ဖြားယောင်းနိန်မယ်လို့ ထင်သလော” ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ပေါလုဟ “အချိန်တိုတာ ဖြစ်စေ၊ ကြာတာ ဖြစ်စေ နင်နဲ့တကွ ခုနေ့ ငါပြောဆိုတာဟို နားထောင်လျက်ဆိကြသော လူအားလုံးလို့ဟ အေးအနှောင်အဖွဲ့ ခံရမှုမှ လွဲယွေ့ ငါလိုမျိုးဖြစ်လာကြစေရန် ဘုရားသခင်ဆေ ငါ ဆုတောင်းပါအယ်” လို့ ပြန်ဖြေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","အေးနောက် ဘုရင်နဲ့ ဘုရင်ခံလို့ဟ ထပင်း ဗေရနိတ်မှစယွေ့ သူနဲ့အတူ ထိန်နေသော သူလို့ဟလည်း နေရာမှ ထကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","သူလို့ဟ အေးနေရာမှ ထွက်သွားပင်းနောက် “အေးသူဟ သေဒဏ် အဲဟာမဟုတ်ရင် အကျဉ်းချထားခြင်း ခံထိုက်လဲ့ ပစ်မှုတစုံတခုဟိုမျှ မကျူးလွန်” ဟု အချင်းချင်း ပြောဆိုကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","အဂြိပ္ပမင်းကြီးဟ ဖေတ္တုမင်းအား “အေးသူဟ ဧကရာဇ်မင်းဆေဟို အယူခံဝင်ရန် မဆှောက်ထားခဲ့ရင် သူဟို လွှတ်ပေးနိန်အယ်” လို့ ပြောအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ငါလို့ဟ ဣတလိပြေဟို ရွက်လွှင့်ရန် ဆုံးဖြတ်ပင်းနောက် သူလို့ဟ ပေါလုနဲ့အခြား အကျဉ်းသားအချို့လို့ဟို “ဧကရာဇ်မင်းရဲ့ တပ်” ဟု ခေါ်သော ရောမတပ်မှ တပ်မှူးယုလ လက်ဟို ပေးအပ်လိုက်အယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ငါလို့ဟ အာရှနယ် ကမ်းခြေ တဆှောက်ဆိသော သင်္ဘောဆိပ်မြို့များဟို သွားခါနီးဖြစ်လဲ့ သင်္ဘောတစီးပေါ်ဟို တက်ယွေ့ ရွက်လွင့်ကြအယ်။ အေးသင်္ဘောဟ အာဒြမုတ္တိမြို့မှ လာသော သင်္ဘော ဖြစ်အယ်။ မာကေဒေါနိပြေမှ သက်သာလောနိတ်မြို့သား အာရိတ္တာခုဟလည်း ငါလို့နဲ့အတူပါလာအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","နောက်တနေ့နှိုက် ငါလို့ဟ ဇိဒုန်မြို့ဟို ရောက်ကြအယ်။ ယုလိဟ ပေါလုဟို သနားကြင်နာစိတ်ဆိသဖြင့် သူ့ရဲ့ မိတ်ဆွေများဆေဟို သွားယွေ့ လုပ်ကျွေးပြုစုခြင်း ခံယူခွင့်ဟို ပေးလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","အေးအရပ်မှ ငါလို့ ထွက်သွားပင်း၊ လေတိုက်ခတ်သောကျောန့် ငါလို့ဟ ကုပရုကျွန်းရဲ့ လေကွယ်ရာဖက်မှ ရွက်လွင့်သွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ငါလို့ဟ ကိလိကိပြေနဲ့ ပမ်ဖုလိပြေရဲ့ ပင်လယ်ဟို ဖြတ်ယွေ့ ရွက်လွင့်ကြရာ လုကိပြေ မုရမြို့ဟို ရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","အေးမြို့တွင် ဣတလိပြေဟို ရွက်လွှင့်သွားမယ့် အာလေဇန္နြိမြို့မှ ရောက်ဆိလာသော သင်္ဘောတစီးဟို မျော်သဖြင့် တပ်မှူးဟ ငါလို့အား အေးသင်္ဘောပေါ်ဟို တက်စေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ငါလို့ဟ ရက်ပေါင်းများစွာ တရွေ့ရွေ့ ရွက်လွင့်ပင်းနောက် နောက်ဆုံးမှာ ကနိဒ်မြို့ အနီးဟို ခက်ခက်ခဲခဲနဲ့ ရောက်ကြအယ်။ လေကျောန်းမသင့်ယွေ့ ဆက်မသွားနိန်သဖြင့် ငါလို့ဟ သာလမုန် အငူအနီးမှ ဖြတ်ယွေ့ ကရေတေကျွန်းတောင်ဖက် လေကွယ်ရာဖက်မှ ရွက်လွင့်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ပင်လယ်ကမ်းရိုးတန်းတဆှောက် ခက်ခက်ခဲခဲ ရွက်လွင့်သွားပင်းနောက် လာသဲမြို့အနီး ဆိပ်သာလို့ခေါ်သော အရပ်ဟို ရောက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ငါလို့ဟ အေးအရပ်တွင် ရက်ပေါင်းများစွာ နေခဲ့ပင်း အပစ်ဖြေရာပွဲနေ့အခါပင် ပွန်လာပီဖြစ်သောကျောန့် ပင်လယ်ခရီးပြုရန် ဘေးအန္တရာယ် မကင်းတော့ပေ။ အေးကျောန့် ပေါလုဟ သူလို့ဟို သတိပေးကာ၊ ");
INSERT INTO dnv_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“ယောက်ျားလို့၊ ဟေပင်လယ်ခရီးတွင် သင်္ဘောနဲ့ ကုန်ပစ္စည်းများ သာမက ငါလို့ရဲ့ အသက်ပါဆုံးရှုံးစရာဆိကျောန်း ငါတွေ့မျော်အယ်” လို့ ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","အဲလိုလဲ တပ်မှူးဟ ပေါလုရဲ့ စကားထက် ယေယာဉ်မှူးနဲ့ သင်္ဘောပိုင်ဆှင်လို့ဟို ပိုပင်း ယုံကြည်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","အေးဆိပ်ကမ်းတွင် ဆောင်းကာလပတ်လုံး ရပ်နားရန် မသင့်သဖြင့် လူများစုဟ အေးဆိပ်ကမ်းမှ ထွက်ခွာပင်း ဖြစ်နိန်ပါဟ ဖိနိတ်မြို့ဟို ရောက်အောန်သွားယွေ့ ဆောင်းရာသီအတွက် ရပ်နားချင်ကြအယ်။ ဖိနိတ်ဆိပ်ကမ်းဟ ကရေတေကျွန်းတွင် ဆိယွေ့ အနောက်တောင်နဲ့ အနောက်မြောက်ဟို မျက်နှာမူလျက် ဆိအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","တောင်ဖက်မှ လေဟ ဖြေးညင်းစွာ စယွေ့ တိုက်ခတ်လာသောအခါ သူလို့ဟ မိမိလို့ရဲ့ အကြံအောန်မယ်လို့ ထင်မှတ်လျက် ကျောက်ဆူးဟို နုတ်ပင်းရင် သင်္ဘောဟို ကရေတေ ကမ်းခြေတဆှောက် ကပ်နိန်သမျှ ကပ်ယွေ့ ရွက်လွင့်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","အဲလိုလဲ မကြာခင်အတွင်း “အဆေ့မြောက်လေပြင်း” ဟု နာမယ်ဆိသော လေဟ ကုန်းတွင်းဖက်မှ အရှိန်ဟုန်ပြင်းစွာ တိုက်ခတ်လာလေအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","သင်္ဘောဟ လေမုန်တိုင်းမိသဖြင့် လေဟို ဆန်ယွေ့ မသွားနိန်သောကျောန့် ငါလို့ဟ လက်လျှော့ယွေ့ လေတိုက်ရာဟို မျောပါသွားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ကလောဒေဟု ခေါ်သော ကျွန်းငယ်ရဲ့ တောင်ဖက်ဟို ရောက်သောအခါ လေပြင်းဒဏ်မှ နည်းနည်း အကွယ်အကာရဆိကြအယ်။ အေးအရပ်တွင် သင်္ဘောနောက်မှ အသက်ကယ်လှေဟို မပျက်စီးစေရန် ခက်ခက်ခဲခဲ ကြိုးစားကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","သူလို့ဟ အေးလှေဟို ဆွဲတင်ပင်းရင် သင်္ဘောဟို ကြိုးများဖြင့် တုတ်ချေယွေ့ ခိုင်ခံ့အောန်ပြုကြအယ်။ သူလို့ဟ သုရတိသောင်တွင် သင်္ဘောတင်မှာ စိုးရိမ်သဖြင့် ရွက်ဟို လျော့ချလိုက်ပင်းရင် သင်္ဘောဟို လေတိုက်ရာဟို မျောပါစေကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","နောက်တနေ့နှိုက်လည်း လေပြင်းမုန်တိုင်း ဆက်လက် တိုက်ခတ်နေသဖြင့် သူလို့ဟ ကုန်ပစ္စည်းအချို့ဟို သင်္ဘောပေါ်မှ ပစ်ချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","သုံးရက်မြောက်သောနေ့နှိုက် သင်္ဘောရဲ့ ကုန်ပစ္စည်းလို့ဟို မိမိလို့လက်ဖြင့် ယူပင်း ပစ်ချကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ငါလို့ဟ ရက်ပေါင်းများစွာ နေနဲ့ ကြယ်များဟို မတွေ့ရကြ။ လေဟ ဆက်ယွေ့ အရှိန်ပြင်းစွာ တိုက်ခတ်လျက်ဆိသဖြင့် နောက်ဆုံးနှိုက် ငါလို့ လွတ်မြောက်မယ်ဟု မျော်လင့်စရာ မဆိသောကျောန့် လက်လျှော့လိုက်ကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","လူလို့ဟ အချိန်အတော်ကြာအောန် အစာမစားဘဲ နေပင်းနောက် ပေါလုဟ သူလို့ အဆေ့တွင် ရပ်ယွေ့ “ငါ့စကားဟို နားထောင်ယွေ့ ကရေတေကျွန်းမှ မထွက်ခွာဘဲ နေသင့်အယ်။ အေးလို့နေခဲ့ကြရင် ဟေလို့ ပျက်စီးဆုံးရှုံးမှုနဲ့ ရင်ဆိုင်ရကြမယ် မဟုတ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","အဲလိုလဲ အားမငယ်ကြရန် နင်လို့အား အခု ငါ တိုက်တွန်းပါအယ်။ နင်လို့အနက် စသူတစုံတယောက်မျှ အသက်ဆုံးရှုံးရမယ် မဟုတ်။ သင်္ဘောဟိုသာ ဆုံးရှုံးရလိမ့်မယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","အကျောန်းမှာ ငါ့ဟို ပိုင်သော ငါ ကိုးကွယ်သော ဘုရားသခင်ရဲ့ ခေါန်းခင်တမန်ဟ မနေ့ညမှာ ငါဆေဟို လာလျက်၊ ");
INSERT INTO dnv_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘ပေါလု၊ မကြောက်နဲ့၊ နင်ဟ ဧကရာဇ်မင်းဆေ့မှာ ရောက်ရမယ်။ ဘုရားသခင်ဟ သူ့ရဲ့ ကောင်းမြတ်ခြင်းအားဖြင့် နင်နဲ့အတူ ရွက်လွင့်ခဲ့ကြသူအပေါင်းလို့အား ဘေးကင်းစေခဲ့ပီ’ ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","အဲလိုမို့ မိတ်ဆွေလို့ အားမငယ်ကြနဲ့။ အကျောန်းမှာ ငါအား မိန့်လဲ့အတိုင်းပင် ဖြစ်လိမ့်မယ်ဟု ဘုရားသခင်ဟို အမှီပြုယွေ့ ငါ ယုံကြည်ပါအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","အဲလိုလဲ ငါလို့ဟ ကျွန်းတခုတွင် သောင်တင်လိမ့်မယ်” ဟု ဆိုအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","တဆယ့်လေးရက်မြောက်သော ညနှိုက် ငါလို့ အာဒြိပင်လယ်တွင် မျောပါနေစဉ် ညသခေါင်အချိန်ခန့်တွင် သင်္ဘောသားလို့ဟ ကမ်းတခုခုနဲ့ နီးလာတာလို့ ခံစားမိကြအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","အဲလိုမို့ သူလို့ဟ ယေတိမ် ယေနက်ဟို တိုင်းကျေ့ကြသောအခါ ပေတရာနေဆယ်ဆိကျောန်း မျော်ကြအယ်။ ဆေ့ဟို နည်းနည်းသွားပင်းနောက် တခါတိုင်း ကျေ့ပြန်ရာ ပေကိုးဆယ်ဆိတာဟို မျော်ရအယ်။ ");
INSERT INTO dnv_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","သူလို့ဟ ကျောက်ဆောင်နဲ့ တိုက်မိမယ် စိုးရိမ်သဖြင့် သင်္ဘောပဲ့မှ ကျောက်ဆူးလေးခုဟို ချပင်းရင် မိုးလ