﻿USE sofia;
DROP TABLE IF EXISTS sofia.dnj_vpl;
CREATE TABLE dnj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dnj_vpl WRITE;
INSERT INTO dnj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Klito 'bhɛma ‑nu 'tɔ ‑bhüö 'ö ꞊nɛɛ: ‑A 'bhɛma ‑nu 'wo bhë ‑an ꞊va ‑peedë 'wo tɔɔ Ablaamö waa‑ Davidö. ");
INSERT INTO dnj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaamö 'ö bhë ‑a gbö tɔɔ Izaakö, Izaakö gbö tɔɔ Zakɔbö, Zakɔbö gbö ‑nu tɔɔ Zuda waa‑ ö dhegluzë ‑nu. ");
INSERT INTO dnj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda gbö ‑nu tɔɔ Falɛ waa‑ Zala 'ö ‑an dhe ‑yö ‑kë Tamaa 'ka. Falɛ gbö tɔɔ Esilɔmë, Esilɔmë gbö tɔɔ Alamë, ");
INSERT INTO dnj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamë gbö tɔɔ Aminadabö, Aminadabö gbö tɔɔ Naasɔn, Naasɔn gbö tɔɔ Saamɔ, ");
INSERT INTO dnj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saamɔ gbö tɔɔ Boozö 'ö‑ dhe ‑yö ‑kë Laabö 'ka. Boozö gbö tɔɔ Obɛdö 'ö‑ dhe ‑yö ‑kë Lutö 'ka. Obɛdö gbö tɔɔ Zese, ");
INSERT INTO dnj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zese gbö tɔɔ ‑gludë Davidö. Davidö gbö tɔɔ Salomɔ 'ö‑ dhe ‑yö ‑kë Üli bɔɔ 'ka 'dhiö ‑bezë. ");
INSERT INTO dnj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔ gbö tɔɔ Loboamü, Loboamü gbö tɔɔ Abia, Abia gbö tɔɔ Aza, ");
INSERT INTO dnj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aza gbö tɔɔ Zozafa, Zozafa gbö tɔɔ Zolamë, Zolamë gbö tɔɔ Ozia, ");
INSERT INTO dnj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ozia gbö tɔɔ Zoatan, Zoatan gbö tɔɔ Akazö, Akazö gbö tɔɔ Ezekiasö, ");
INSERT INTO dnj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiasö gbö tɔɔ Manase, Manase gbö tɔɔ Amɔ, Amɔ gbö tɔɔ Zoziasö, ");
INSERT INTO dnj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zoziasö ‑yö Zekoniasö waa‑ ö dhegluzë ‑nu 'kpɔ ‑dë 'ka. ‑Yö ‑kë 'töng 'wo Izlaɛlö ‑mɛ ‑nu kun ‑a 'ka 'wo dho ‑an 'ka Babilɔnë bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","꞊Dhɛ 'ö Izlaɛlö ‑mɛ ‑nu ꞊wa 'go Babilɔnë ꞊wa nu, Zekoniasö ‑yö Salatiɛlö ‑kpɔ ‑a 'ka, Salatiɛlö gbö tɔɔ Zolobabɛlö. ");
INSERT INTO dnj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zolobabɛlö gbö tɔɔ Abiudö, Abiudö gbö tɔɔ Eliakimë, Eliakimë gbö tɔɔ Azɔɔ. ");
INSERT INTO dnj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔɔ gbö tɔɔ Sadɔkö, Sadɔkö gbö tɔɔ Akimë, Akimë gbö tɔɔ Eliudö, ");
INSERT INTO dnj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudö gbö tɔɔ Eleazaa, Eleazaa gbö tɔɔ Matan, Matan gbö tɔɔ Zakɔbö. ");
INSERT INTO dnj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zakɔbö gbö tɔɔ Zozɛfu. Zozɛfu 'ö bhë yö ꞊nɛ 'ö tɔɔ Mali ꞊gɔn. Mali 'ö 'dhö bhë ꞊nɛ 'ö Yesu 'ö 'wo‑ ‑dhɛ ‑Zlan ‑bha ‑Yamɛ bhë 'ö‑ kpɔ. ");
INSERT INTO dnj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mɛ ‑nu 'wo bhë 'saadhö ‑an 'bhɛma 'plɛ ‑dho 'kuë‑ ‑sü 'ö sü Ablaamö ‑bha 'ö dho 'ö yöë Davidö ‑bha ‑yö ‑kë 'gɔɔ‑ do ö ga ‑yiisië; 'ö sü Davidö ‑bha 'pö, 'ö dho 'ö yöë 'töng 'wo Izlaɛlö ‑mɛ ‑nu kun ‑a 'ka, 'wo dho ‑an 'ka Babilɔnë ‑a ‑bha, ‑an ‑dho 'kuë‑ ‑sü ‑kë 'gɔɔ‑ do ö ga ‑yiisië. 'Ö sü 'töng 'ö 'dhö ‑a ‑bha 'zü 'ö dho 'ö yöë ‑Zlan ‑bha ‑Yamɛ bhɔ ‑yi ‑bha, ‑an ‑dho 'kuë‑ ‑sü ‑yö ‑kë 'gɔɔ‑ do ö ga ‑yiisië 'zü. ");
INSERT INTO dnj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Klito bhɔ ‑kɔ ꞊ga 'ö ꞊nɛɛ: Mali 'ö ‑kë ‑a dhe 'ka bhë ‑a ‑bha ‑zo ‑tën ‑a ‑dhë ‑mɛ ‑yö ‑kë Zozɛfu 'ka. ‑Wo ‑to 'töng bhë ‑a 'ka kö ‑an ‑bha 'kɔ yaa kë do ꞊kun, 'ö Mali ‑yö 'gu ‑sü ‑Zuu 'slööslö ‑bha ꞊faan' ꞊kwaa' kö waa wo 'ko 'sü ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","‑A ‑bha ‑zo ‑tën ‑a ‑dhë ‑mɛ Zozɛfu 'ö ‑kë gɔɔn‑ kpengdhö 'ka bhë yaa 'we ‑a ‑bha kö ‑yaan ‑a ‑wun yö plaan, 'kɛɛ ‑ya ‑ya ö ‑zo 'piö ꞊zian' kö wo ‑bha ‑zo ‑tën 'ko ‑dhë ‑sü ‑yö 'kan ‑bindhe 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","꞊Dhɛ 'ö ‑kë ꞊nɛ ‑yö ‑kë ö ‑zo ‑ta ‑a 'gü ꞊dhia bhë, 'ö kwa Dëmɛ ‑Zlan ‑bha bɔmɛ do ‑yö ‑wo ‑a ‑ta yiö ꞊zian', 'yö‑ pö ‑a ‑dhë: «Zozɛfu, bhi 'ü Davidö ꞊suu'‑ 'gü 'në 'ka, kö ꞊kun 'ö 'suö ‑yö ü ‑kë, Mali ‑sü ü bɔɔ 'ka ꞊dhia, bhii 'gu 'ö‑ ‑gɔ bhë, ‑yö ‑ya ‑a ‑bha ‑Zuu 'slööslö ‑bha 'piigbeedhɛ ꞊kwaa'. ");
INSERT INTO dnj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","‑Yö ‑dho 'në gɔɔn‑ do kpɔ, ‑bhöë 'tɔ 'kpɔ Yesu 'ka, bhii ‑yö ‑dho ö bha 'sɛgɔgümɛ ‑nu dha ‑an ‑bha ꞊sɔɔn yaa ‑nu ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pë ‑nu 'wo 'dhö bhë, ‑wo ‑kë 'dhö kö pë 'ö kwa Dëmɛ ‑Zlan ‑ya pö 'ö bɔ ‑a 'ka ö ‑wodhiölomɛ ‑nu ‑ta bhë ‑yaan kë. Bhii ‑yö ꞊bɛɛn' ‑sü 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","'Nëdhezë do 'ö yaa gɔɔn‑ ‑wun ꞊tɛi' dɔ ꞊kun, ‑yö ‑dho 'gu sü, 'ö 'në gɔɔn‑ do kpɔ, ‑wo ‑dho ‑a ‑dhɛ Emanuɛlö. ('Tɔ bhë ‑a ‑gɛn tɔɔ «‑Zlan ‑yö kwa 'piö»). ");
INSERT INTO dnj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","꞊Dhɛ 'ö Zozɛfu ‑yö ‑büö, ‑ya ‑kë ꞊nɛ ‑kɔ 'ö kwa Dëmɛ ‑Zlan ‑bha bɔmɛ ‑ya pö ‑a 'ka ‑a ‑dhë bhë ‑a 'dhö; 'yö Mali sü ö bha dhebɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","'Kɛɛ waa wɔ wo 'ko 'piö 'yö dhoë 'ö yöë yi 'ö Mali ‑yö 'në gɔɔn‑ bhë ‑a kpɔa ‑a ‑bha. 'Yö Zozɛfu ‑ya 'tɔ kpɔ Yesu 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu ‑yö ‑bhɔ Zude ‑pö do 'wo‑ ‑dhɛ Betelɛmë ‑a 'gü, 'töng 'ö Elɔdö ‑yö ‑kë ‑a 'ka ‑gludë 'ka bhë ‑a 'ka. ꞊Dhɛ ꞊ya kë 'dhö, 'wunbhokoudɔmɛ ‑nu 'ö ‑an 'yan ‑yö ‑kë 'susongga ‑nu 'piö bhë, ‑wo ‑go 'sɛgɔ 'ö lan‑ ꞊luu'‑ ꞊zian' ‑a 'ka, 'wo nu Zeluzalɛmë. ");
INSERT INTO dnj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","'Wo mɛ ‑nu ꞊dhɛɛ' kpɔ ‑a pö ‑sü 'ka ꞊nɛɛ: «'Në 'ö dho kë Zuifö ‑nu ‑bha ‑gludë 'ka 'yö bhɔ bhë, ‑yö më ꞊ɛ? 'Susongga 'ö‑ ‑zɔn ꞊nɛ ꞊ya bhɔ bhë ‑yö ‑wo yi ‑ta 'ma, 'yi‑ yö yi ‑sɛ 'gü. ‑A ‑wun 'gü 'yi nu kö 'yiën‑ ‑a gba bhë.» ");
INSERT INTO dnj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","꞊Dhɛ 'wun bhë 'ö ‑gludë Elɔdö ‑ya ma, ‑a 'wun ‑ya ‑kun, 'ö 'suö ‑yö ‑da ‑a 'gü. ‑Kɔ do bhë 'ö ꞊kaa' Zeluzalɛmë ‑mɛ ‑nu 'töüdhö ‑gɔ 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","'Ö slabhomɛ ‑nu ‑gɔmɛ ‑nu, Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu 'wo‑ ‑gɔ 'sɛ 'ö bhë ‑a 'gü, 'yö ‑an 'plɛ ꞊dhɔɔ ‑kë wo 'ko ꞊bhaa, 'yö ‑an ꞊dhɛɛ' kpɔ ‑Zlan ‑bha ‑Yamɛ bhɔ ‑dhɛ ‑wun 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","'Ö 'wo‑ pö ‑a ‑dhë: «‑Yö ‑dho bhɔ Betelɛmë, Zude ‑sɛ 'gü. Bhii pë 'ö ‑Zlan ‑wodhiölomɛ ‑ya ‑ya ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ka gia‑ 'pö, 'ka Betelɛmë ‑mɛ ‑nu 'ka, 'ö 'ka Zude ‑sɛ 'gü, ka ‑bha pödhɛ bhë 'yaa pödhɛ 'tee 'ka Zude ‑pö ꞊vava ‑nu ziën. Bhii ‑gludë do ‑yö ‑dho go ka ziën kö ‑yaan yö ma 'sɛgɔgümɛ ‑nu 'ka Izlaɛlö ‑mɛ ‑nu 'ka ka ‑dhë 'dhiö ꞊nɛ ‑kɔ 'ö ‑tuë ‑maakëmɛ 'dhö yö ‑na ‑a 'ka ö bha ‑tuë ‑nu ‑dhë 'dhiö bhë ‑a 'dhö. » ");
INSERT INTO dnj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","꞊Dhɛ ꞊ya kë 'dhö, 'ö Elɔdö ‑yö 'wunbhokoudɔmɛ ‑nu ‑dhɛ ‑dhɛ ꞊taa, 'yö ‑an ꞊dhɛɛ' kpɔ kpinngdhö 'töng 'ö 'susongga ‑yö ꞊woë' ‑an ‑ta bhë ‑a ‑wun 'ka kö ‑wa ꞊blɛɛ'‑ ö ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'Go mü 'yö ‑an bɔ Betelɛmë ꞊woë' ꞊nɛɛ: «‑Ka 'dho 'ka 'në 'ö bhë 'ka‑ ꞊mɛɛ' ‑së 'ka! ꞊Ya kë ꞊nɛ 'ka‑ yö, ‑ka nu 'ka‑ ꞊blɛɛ'‑ n ‑dhë kö ma ‑de 'pö 'aan‑ 'dho ‑a gba ꞊dhia.» ");
INSERT INTO dnj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","꞊Dhɛ ‑gludë ‑wo 'ö bhë ꞊waa‑ ma, 'wo dho. ‑An ‑bha 'dho ‑sü 'ka, 'susongga do 'wo‑ yö wo ‑gɔ 'sɛ 'gü bhë, ‑wa yö 'zü. 'Susongga bhë ‑yö 'ta ‑sü ‑an 'dhiö 'ö 'wo dhoë 'dhö. ꞊Dhɛ 'wo ‑lo 'kɔ 'ö Yesu 'blë ‑kë ‑a 'gü bhë ‑a 'trüün 'ka, 'ö 'susongga bhë 'ö ꞊gbaannu. 'Ö ‑an ꞊zuö' 'glu ‑yö ‑dhi 'sönggö ‑sönggö. ");
INSERT INTO dnj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","'Wo dho 'wo ‑da 'kɔ 'ö bhë ‑a 'gü, 'wo 'në 'blë bhë waa‑ ö dhe Mali 'wo ‑an yö, 'wo ‑lo wo kpɔn 'gü, 'ö 'në 'blë bhë 'wo‑ gba. 'Go mü 'wo wo ‑bha ꞊kwɛɛ‑ ‑nu 'dhi ‑po, 'wo yö gbaɔ ‑nu kë ‑a ‑dhë ‑sü 'gü: 'Sënng ‑nu, pë 'bhaa 'ö waa‑ 'güö ‑pë 'tëë ‑sëëzë 'wo‑ ‑dhɛ ansaan waa‑ pë 'yi 'tëë ‑sëëzë 'wo‑ ‑dhɛ 'miilö bhë, 'wo ‑an nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑Zlan ‑yö 'wunbhokoudɔmɛ ‑nu ꞊kpaɔ yiö ꞊zian' ꞊nɛ kö ꞊kun 'wo ‑yɛ wo 'zü 'wo dho Elɔdö 'piö, 'kɛɛ 'wo bɔ zian gbɛ 'ka 'wo dho wo ꞊plöö. ");
INSERT INTO dnj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","꞊Dhɛ 'ö 'wunbhokoudɔmɛ ‑nu ꞊wa 'dho, 'ö ‑Zlan ‑bha bɔmɛ do ‑yö ‑wo Zozɛfu ‑ta yiö ꞊zian', 'ö‑ pö ‑a ‑dhë: «‑Bhö ꞊luu'‑, 'ü 'në bhë waa‑ ö dhe 'ü ‑an 'sü, 'ka ꞊duë 'ka 'dho Ezitö ‑sɛ 'gü! ‑Ka 'to 'ma ‑yö 'dho ‑yö yöë yi 'a dho ‑a pöë ü ‑dhë 'ü 'yɛ ü 'zü 'ü nu ‑a 'ka ‑a ‑bha! Bhii Elɔdö ‑dho 'në 'ö ꞊nɛ ‑a ꞊mɛɛ' kö ‑yaan ‑a zë.» ");
INSERT INTO dnj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Ö Zozɛfu ‑yö ꞊luu, 'yö 'në waa‑ ö dhe 'wo bhë ‑an sü gbeng, 'wo dho Ezitö ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","'Wo to Ezitö 'ö dho 'ö yöë Elɔdö ‑bha ga ‑yi ‑bha. Pë ‑nu 'wo ꞊nɛ ‑wo ‑kë kö pë 'ö kwa Dëmɛ ‑Zlan ‑ya ꞊blɛɛ 'ö bɔa ö ‑wodhiölomɛ ‑nu ‑ta bhë ‑an 'dhiö ‑yaan ‑mɔ 'kuë ꞊nɛɛ: A n Gbö ‑dhɛ, 'yö go Ezitö ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","꞊Dhɛ 'ö Elɔdö ꞊yaa‑ dɔa ꞊nɛ 'wunbhokoudɔmɛ ‑nu waa nu gbɔ, 'ö ‑naadhe ꞊va ‑yö ‑da ‑a 'gü. 'Yö‑ pö ö bha 'dhasi ‑nu ‑dhë kö ‑wo 'në gɔɔn‑ ꞊suu'‑ 'saadhö 'ö sü 'në 'blë ‑nu ‑bha 'ö yöë ‑an ‑mɛ 'ö ‑an ‑kwɛ dho yö ‑kwɛ ꞊plɛ ‑bha, 'wo Betelɛmë ‑dhɛ waa‑ ‑a ‑zütodhɛ ‑nu ‑bha, ‑wo ‑an 'plɛ zë. 'Ö tɔɔ kö ꞊ya 'töng 'ö 'wunbhokoudɔmɛ ‑nu ‑wo 'susongga ‑wo ‑an ‑ta ‑yi ꞊blɛɛ ‑a 'ka ‑a ‑dhë bhë ꞊yaa‑ ‑ya 'ko 'dhiö kë 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","‑Kɔ bhë ‑a 'ka, pë 'ö ‑Zlan ‑wodhiölomɛ Zelemi ‑ya pö bhë, 'ö‑ 'dhiö ‑yö ‑mɔ 'kuë. ");
INSERT INTO dnj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‑Ya ‑pö: ‑Wo 'gbla ‑wo ‑nu ma ‑na Lama ‑pö 'gü, 'gbo ‑zuö ‑nu waa‑ ‑de ꞊maamadhe ꞊va ‑nu ‑an 'ka. Lasɛlö ꞊nɛ 'ö 'gbo bɔ ‑na ö ‑bha 'në ‑nu ‑wun 'gü bhë; 'yaa‑ 'piö kö ‑wa ‑dhiaga bho, bhii 'ö tɔɔ ‑an 'gü ꞊ya ꞊siö'‑. ");
INSERT INTO dnj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","꞊Dhɛ 'ö Elɔdö 'gü ꞊ya ꞊siö'‑, 'ö ‑Zlan ‑bha bɔmɛ do ‑yö ‑wo Zozɛfu ‑ta yiö ꞊zian' Ezitö ‑sɛ 'gü, ");
INSERT INTO dnj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","'yö‑ pö ‑a ‑dhë: «‑Bhö ꞊luu'‑, 'ü 'në waa‑ ö dhe ‑an 'sü, 'ka 'yɛ ka 'zü 'ka 'dho Izlaɛlö ‑sɛ 'gü, bhii mɛ ‑nu 'wo‑ 'piö ‑be kö 'në bhë ‑waan ‑a zë bhë 'waa ‑dhö gbɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","'Ö Zozɛfu ‑yö ꞊luu, 'ö 'në waa‑ ö dhe bhë 'yö ‑an sü, 'wo ‑yɛ wo 'zü 'wo nu Izlaɛlö ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'Kɛɛ ꞊dhɛ 'ö Zozɛfu ꞊yaa‑ ma ꞊nɛ, Akelaisö, 'ö ‑kë ‑gludë Elɔdö gbö 'ka bhë, ꞊ya kë ‑gludë 'ka ö dë pin ꞊taa Zude ‑sɛ 'gü, 'ö 'suö ‑ya ‑kë ‑to Zude ‑sɛ 'gü ꞊dhia. ꞊Dhɛ 'ö ‑Zlan ꞊yaa‑ ꞊kpaɔ, 'yö dho Galile ‑sɛ 'gü ꞊zian', ");
INSERT INTO dnj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","'yö ‑ya ‑a 'kwipö do 'wo‑ ‑dhɛ Nazalɛtë ‑a 'gü. ‑Yö ‑kë 'dhö kö pë 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑wa pö, ‑a 'dhiö ‑yaan ‑mɔ 'kuë ꞊nɛɛ: ‑Wo ‑dho ‑a ‑dhɛ Nazalɛtë mi. ");
INSERT INTO dnj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","'Töng 'ö 'dhö bhë ‑a 'ka, mɛ do 'wo‑ ‑dhɛ Zan Batisö ‑yö ‑nu 'yënng ꞊taa Zude ‑sɛ 'gü, 'ö yö 'wuntaɔsë ꞊blɛɛ' ‑sü 'gü, ");
INSERT INTO dnj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","'ö‑ pö: «‑Ka ka ꞊kwaa' ka ‑bha ꞊sɔɔn yaa ‑nu ‑zü, 'ka ka ꞊zuö' ꞊dhië' ‑Zlan 'piö, bhii ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü bhë, ꞊ya yö ꞊klöö'!» ");
INSERT INTO dnj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zan ‑yö ‑kë mɛ 'ö ‑Zlan ‑wodhiölomɛ Ezai ‑yö 'wun 'ö ‑gban ‑a ‑bha 'ö‑ ꞊blɛɛ ‑a pö ‑sü 'ka ꞊nɛɛ: Gɔɔn‑ do ‑yö ‑dhoo bho ‑sü 'gü 'yënng ꞊taa ꞊nɛɛ: ‑Ka kwa Dëmɛ ‑bha zian ‑gblooga ‑nu ‑pë kë, ‑wo dɔ kpengdhö ‑a 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zan ‑da ‑bha ‑sɔ ‑yö ‑kë ‑yɔɔnmia kaa‑ 'wo‑ bɔ ‑a 'ka, 'ö ‑du kwi dɔ ö bha sɔ ‑ta, 'ö‑ ‑bhöpë ‑nu ‑wo ‑kë ‑kpaa waa‑ 'zɔ 'yɔn ‑nu ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mɛ ‑nu 'saadhö 'wo ‑kë Zeluzalɛmë, 'wo ‑kë Zude ‑sɛ 'gü waa‑ mɛ ‑nu 'wo bɔ 'yiga 'wo‑ ‑dhɛ Zuudɛn ‑a 'piö ꞊zian', ‑an 'plɛ ‑wo ‑nu ‑a 'piö mü, ");
INSERT INTO dnj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'ö 'wo wo ‑bha ꞊sɔɔn yaa ‑wun ‑nu ꞊blɛɛ mɛ ‑nu wö 'dhiö mü. 'Ö Zan ‑yö ‑an ‑bɔ yiö Zuudɛn ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","꞊Dhɛ 'ö Zan ꞊yaa‑ yö ꞊nɛ Falizi ‑mɛ ‑nu waa‑ Saduse ‑mɛ ‑nu ‑wo nu ‑na ꞊va ö 'piö, kö ‑yaan ‑an ‑bha ‑go ꞊sɔɔn yaa 'gü ‑bɔyiödhe kë, 'ö‑ pö ‑an ‑dhë: «Mɛ ꞊suu'‑ yaazë ‑nu 'ka ꞊nɛ ꞊mɛɛ 'në ‑nu 'dhö ꞊nɛ, dö 'yö‑ pö ka ‑dhë ka ‑dho dha ‑Zlan ‑bha ‑naazuëdhe 'gbee‑ 'yö 'dhoë‑ nu bhë ‑a ‑gɔ ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","‑Ka pë ‑nu kë kö ‑ya ‑zɔn ꞊nɛ 'ka ka ꞊zuö' ꞊dhië'‑! ");
INSERT INTO dnj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Iin kö ꞊kun 'ka ka ‑zo ta ‑a pö ‑sü 'ka ka ‑de 'gü ꞊nɛɛ: ‹Ablaamö ꞊suu'‑ ‑mü yi 'ka›, bhii a‑ ‑blɛɛ ka ‑dhë: ‑Zlan ‑yö ‑mɔa kö ‑guö ‑nu 'wo ꞊nɛ ‑yö ‑an kë Ablaamö ꞊suu'‑ ‑ta ‑nu 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","꞊Dua ꞊ya ‑pë kë 'saadhö kö ‑yaan 'lü ‑nu bho 'sɛidhö. 'Lü 'saadhö 'ö yaa 'dho bha ö bhɛ ‑së 'ka, ‑wo ‑dho ‑a ꞊kaan'‑ 'wo‑ güö.» ");
INSERT INTO dnj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'Ö Zan ‑ya pö 'zü: «Ma ‑zë a ka ‑bɔ yiö 'yi 'ka kö ‑yaan ‑a ‑zɔn ꞊nɛ 'ka ka ꞊zuö' ꞊dhië'‑, 'kɛɛ mɛ do ‑yö nu ‑na n ꞊zlöö, yö ‑zë ‑yö ‑dho ka pa ‑Zuu 'slööslö waa‑ 'siö 'ö mɛ ‑kë 'slööslö ‑an 'ka. ‑A 'pii ꞊yö 'gbee‑ 'ö ‑ziö ‑a 'ka n ‑ta. Yaa n ‑ma 'kun kö 'a 'dho ‑a 'dhiö 'aan‑ ‑a ‑bha ‑sakpa bho ‑a ‑gɛn ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","'Dhaa‑ do ‑ya kwɛɛ, pë ‑piö ‑pë 'ka kö ‑yaan ö bha ‑mlü ‑piö, kö ‑a ‑gbo ‑yaan 'go ‑a ga ‑nu ziën. ‑Yö ‑dho ö bha ‑mlüga ‑nu ‑lo ö ‑gɔ 'slëëdhö, 'ö ‑mlü ‑gbo ‑nu ‑güö 'siö 'ö 'yaa ꞊dhuu'‑ 'gbɛɛdhö ‑a 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑go Galile ‑sɛ 'gü, 'yö nu 'yiga 'wo‑ ‑dhɛ Zuudɛn ‑a ꞊bhaa, Zan 'piö kö ‑yaan ö bɔ yiö. ");
INSERT INTO dnj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","'Kɛɛ Zan yaa 'we ‑a ‑bha, 'ö‑ pö ‑a ‑dhë: «Bhi 'pö, 'a dho bɔ yiö ‑sü yö ü kwɛɛ ꞊zian' bhë, 'yö 'ü nu ma ‑zë n 'piö kö 'a ü bɔ yiö ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","'Yö Yesu ‑ya ‑pö ‑a ‑dhë: «‑Bhö 'we ‑a ‑bha kö ‑yö ‑kë ꞊nɛ ‑kɔ bhë ‑a 'dhö ꞊kun. Bhii ‑kɔ bhë ꞊nɛ 'ö pë 'ö ‑Zlan ‑ya pö 'kwa dho ‑a kaa.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö Zan ‑yö ‑we ‑a ‑bha, 'ö Yesu ‑bɔ yiö. ");
INSERT INTO dnj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","꞊Dhɛ 'ö ꞊ya yën Yesu ‑bɔ yiö ‑sü ‑bha 'ö ꞊luu' ‑na yiö, 'ö dhang‑ 'dhi ‑yö ‑po 'ö ‑Zuu 'slööslö 'ö go ‑Zlan 'piö bhë 'ö‑ yö kö ‑yö ꞊yɔɔ' ‑na ‑a ‑ta; 'kɛɛ ‑yö ‑kë ‑tönggö 'ka 'ö nu 'ö ‑ya ‑a ‑ta 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","'Ö ‑wo ‑wo do ‑yö go dhang‑ 'gü 'wo‑ ma ꞊nɛɛ: «Mɛ 'ö ꞊nɛ 'ö tɔɔ ma 'në 'ö‑ ‑dhɔ ‑yö n ‑kë, yö ꞊nɛ 'ö n ‑ma ꞊zuögludhi ‑wun 'plɛ 'dhö ‑ya ‑sü 'ka ‑a 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","꞊Dhɛ ꞊ya kë 'dhö, ‑Zuu 'slööslö ‑yö yö Yesu ‑dhë 'dhiö, 'yö dho ‑a 'ka 'yënng ꞊taa, 'ö dü ‑ya ‑püö ‑sü 'gü dan. ");
INSERT INTO dnj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","꞊Dhɛ 'ö ꞊ya ö ‑bɛn 'to, ‑dhɛkpaɔyi 'gɔɔ‑ ‑yiisië waa‑ gbeng 'gɔɔ‑ ‑yiisië 'ka, 'ö din ‑ya kun. ");
INSERT INTO dnj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Ö dü ‑yö ꞊yɔɔn Yesu ‑bha, 'yö‑ pö ‑a ‑dhë: «'Ö ꞊ya kë ꞊nɛ ‑Zlan Gbö ‑mü ü 'ka, ‑bhö ‑a pö ‑guö ‑nu 'wo ꞊nɛ ‑an ‑dhë ‑wo 'gla ꞊bluu'‑ 'gü kö 'ü ‑an ‑bhö!» ");
INSERT INTO dnj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ ꞊nɛɛ: «Pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ‑ya ‑pö: Mɛbheedhe 'ka 'dho ‑tosiadhe kë ‑bhöpë ‑de 'sloo ‑ta. 'Kɛɛ ‑yö ‑dho ‑mɔ ‑a ‑bha 'pö kö ‑yö ‑tosiadhe kë ‑wo 'saadhö 'ö 'go ‑na ‑Zlan 'dhiö bhë ‑a ‑ta. » ");
INSERT INTO dnj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","꞊Dhɛ ꞊ya kë 'dhö, 'ö dü ‑ya sü 'ö dho ‑a 'ka Zeluzalɛmë 'wo‑ ‑dhɛ pödhɛ 'slööslö bhë ‑a ‑bha, 'yö‑ ‑ya ‑Zlan ‑gba ‑a 'gü 'kɔ tuö. ");
INSERT INTO dnj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'Ö‑ pö ‑a ‑dhë: «'Ö ꞊ya kë ꞊nɛ ‑Zlan Gbö ‑mü ü 'ka, ü ꞊kwaa'‑ ü ‑de ‑zü 'ü ü ‑de ‑zuö sia‑ ‑de! Bhii pë 'ö ꞊bɛɛn' ‑sü 'ka ‑ya ‑pö: ‑Zlan ‑dho ö ‑bha bɔmɛ ‑nu bɔ, kö ‑wo wo ‑kɔ kpɔ ü ‑gɔ, ‑yö kë 'dhö kö ꞊kun 'ö pë pin dho to ü ‑gɛn ‑bha. » ");
INSERT INTO dnj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","'Ö Yesu ‑ya pö ‑a ‑dhë: «Pë 'ö ꞊bɛɛn' ‑sü 'ka ‑ya ‑pö 'pö: Kö ꞊kun 'ü ü Dëmɛ ü ‑bha ‑Zlan 'gü dan! » ");
INSERT INTO dnj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","'Ö dü ‑ya sü 'zü 'ö dho ‑a 'ka ‑tɔn do ꞊gbiin tuö. 'Ö ‑gludëdhɛ ‑pö ‑nu 'wo 'kpongtaa zö waa‑ ‑an ‑bha 'tɔbhɔdhe ‑an ‑zɔn Yesu ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'ö‑ pö ‑a ‑dhë: «꞊Ya kë ꞊nɛ 'bha 'gblü n 'dhiö n gba ‑sü 'ka, pë ‑nu 'wo bhë 'töüdhö a ‑dho ‑an 'plɛ nu ü ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑a ‑dhë: «Dü, ‑bhö yö 'ma 'ü 'go n 'sɔɔ, bhii pë 'ö ꞊bɛɛn' ‑sü 'ka ‑ya ‑pö: ‑Bhö ü Dëmɛ, ü ‑bha ‑Zlan dosɛn 'kpaan gba, 'ü yuö kë yö dosɛn ‑a ‑dhë! » ");
INSERT INTO dnj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","꞊Dhɛ ꞊ya kë 'dhö zlöö, 'ö dü ‑yö ‑kan ‑a ‑bha. 'Ö ‑Zlan ‑bha bɔmɛ ‑nu ‑wo nu ‑a 'piö, 'wo‑ gbaa pë 'ö‑ ‑wun ‑ya ‑kë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","꞊Dhɛ 'ö Yesu ꞊yaa‑ ma ꞊nɛ ꞊wa Zan ‑da ‑kanso 'gü, 'ö dho Galile ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yaa 'to Nazalɛtë gbɔ, 'kɛɛ ‑yö ‑dho 'ö ‑ya Kapɛɛnaɔmë, pödhɛ 'ö ‑ya ‑sü 'ka 'yipuë 'ö Galile 'sɔɔ, Zabilɔn waa‑ Nɛfutali ‑an ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","‑Yö ‑kë 'dhö, kö ‑wo 'ö go ‑Zlan ‑wodhiölomɛ Ezai dhiö bhë kö ‑yaan ‑mɔ 'kuë ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabülɔnë ‑sɛgümɛ waa‑ Nɛfutali ‑sɛgümɛ 'wo 'yoo 'piö 'sɛ 'ö Zuudɛn ꞊zlöö ꞊zian' ‑a 'gü, mɛ ‑nu 'kaa Zuifö 'ka Galile ‑sɛ 'gü, a‑ ‑pö ka ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mɛ ‑nu 'wo wo ‑bha ‑tosiadhe kë ‑na ‑dhɛtiidhɛ 'gü bhë, ‑wo ‑dho ‑dhɛpuudhɛ ꞊va yö; 'ö mɛ ‑nu 'wo wo ‑bha ‑tosiadhe kë ‑na, ‑dhɛ 'ö ga ꞊ya ‑dhɛ trö ‑a ‑dhɛ ‑bha bhë, ‑dhɛpuudhɛ ‑dho bhü mü. ");
INSERT INTO dnj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","꞊Dhɛ ꞊ya 'sü yi 'ö 'dhö bhë ‑a ‑bha, Yesu ‑yö ‑yö 'wuntaɔsë ꞊blɛɛ'‑ ‑sü ‑bha 'ö‑ pö: «‑Ka ka bo ka wɔ ‑kɔ yaa 'ka, 'ka ka ꞊zuö' ꞊dhië' ‑Zlan 'piö, bhii ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü bhë ꞊ya yö ꞊klöö'!» ");
INSERT INTO dnj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu ‑yö ‑kë 'ta 'sü ꞊dhia Galile 'yipuë 'kpong 'dhiö, 'yö ‑kpën dheglu 'nëgɔɔnzë ꞊plɛ 'wo ‑kë 'yiblükëmɛ ‑nu 'ka ‑an ‑bha. Mɛ ꞊plɛ 'wo bhë 'wo tɔɔ Simɔ ('wo‑ ‑dhɛ Piɛɛ) waa‑ ö dheglu Andre; ‑wo ‑kë 'yi ‑blü kë ꞊dhia wo ‑bha 'kplö ‑zuö 'yipuë ꞊bhaa ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka ziö n 'piö; a ‑dho ka kë 'kplö ‑zuö mɛ ‑nu ‑gɔ ‑mɛ 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","‑Dhɛ do bhë 'wo to ‑a ‑bha, 'wo wo ‑bha 'kplö ‑nu to mü, 'wo ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","꞊Dhɛ 'ö ꞊ya ꞊yɔɔn 'dhiö 'dɛdɛ, 'yö ‑kpën dheglu 'nëgɔɔnzë ꞊plɛ 'bhaa 'ö 'wo ‑an ‑dhɛ Zakö waa‑ Zan 'wo ‑kë Zebede gbö ‑nu 'ka ‑an ‑bha. Waa‑ wo dë Zebede ‑nu ‑wo ‑kë wo ‑bha 'yitagɔ 'gü, wo ‑bha 'kplö ‑nu ‑yuö kë ꞊dhia. 'Ö Yesu ‑yö ‑an ꞊dhɔɔ ‑kë. ");
INSERT INTO dnj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","‑Dhɛ do bhë 'wo to ‑a ‑bha, 'wo wo ‑bha 'yitagɔ waa‑ wo dë ‑an to mü, 'wo ‑ziö Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu ‑yö ‑bɔ Galile ‑sɛ 'saadhö ‑a 'gü, ‑Zlan ‑wo ‑pö mɛ ‑nu ‑dhë ‑sü 'ka Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑nu 'gü. 'Ö 'wuntaɔsë 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑bha 'yö‑ ꞊blɛɛ. Kö mɛ ‑nu 'ö 'yua ꞊suu'‑ 'oo ꞊suu'‑ ‑yö ‑an ‑kë, waa‑ ꞊niɔɔmɛ ‑nu ‑an ‑dhɛ bo ‑na. ");
INSERT INTO dnj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","‑A 'tɔ ‑yö ‑pɛn Sili ‑sɛ 'saadhö ‑ta. 'Ö mɛ ‑nu ‑wo nu mɛ ‑nu 'ö ‑an 'yënng 'dho bhɔ ‑na 'yua ꞊suu'‑ 'oo ꞊suu'‑ ꞊kwaa' ‑an 'ka; 'wo tɔɔ mɛ ‑nu 'ö 'puɛ‑ ‑yö ‑an kë ‑nu, 'tinngmɛ ‑nu, waa‑ mɛ ‑nu 'ö ‑zuu yaa 'dho ‑an 'piö ‑nu, ‑wo ‑kë ‑an ziën mü. 'Ö Yesu ‑yö ‑an ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mɛ ‑gbaa ꞊va 'wo go Galile oo, pö‑ 'gɔɔ‑ do ‑sɛ oo, Zeluzalɛmë pö‑ oo, Zude waa‑ mɛ ‑nu 'wo 'sɛ 'pian 'ö Zuudɛn ꞊zlöö ꞊zian', ‑wo ‑kë ‑ziö ‑a 'piö ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","꞊Dhɛ mɛ ‑gbaa ‑nu 'wo ꞊nɛ 'ö Yesu ꞊ya ‑an yö, 'yö ‑an to ‑tɔn ꞊gɛnngdhö, 'ö ‑da ‑tɔn bhë ‑a tuö, 'ö ꞊yaannu. 'Yö‑ ‑bha ꞊guë' ‑nu ‑wo dho ‑a 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'Ö Yesu ‑yö yö ‑Zlan ‑wo ‑blɛɛ ‑an ‑dhë ‑sü ‑bha ‑a pö ‑sü 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Mɛ ‑nu 'wo wo ‑de ‑wun ‑da sia‑ ‑Zlan 'dhiö, ‑an ‑bha ꞊yö ‑së, bhii 'ö tɔɔ ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ ‑nu 'gü, ‑yö ‑an ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mɛ ‑nu 'ö 'wo 'gbo bɔ ‑na, ‑an ‑bha ꞊yö ‑së, bhii 'ö tɔɔ ‑Zlan ‑dho ‑an 'yënng ꞊dhuë'‑. ");
INSERT INTO dnj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mɛ ‑nu 'wo 'lëëlë, ‑an ‑bha ꞊yö ‑së, bhii ‑Zlan ‑dho 'kpongtaadhɛ nu ‑an ‑dhë ꞊nɛ ‑kɔ 'ö‑ 'tɔ go ‑a 'ka ‑an ‑dhë bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mɛ ‑nu 'ö ‑kë kpengdhö ‑sü ‑dhɔ 'dhö ‑an kë ‑na bhë, ‑an ‑bha ꞊yö ‑së, bhii 'ö tɔɔ ‑wo ‑dho ‑a yö ꞊va. ");
INSERT INTO dnj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mɛ ‑nu 'wo mɛ ‑nu 'yena yö ‑na, ‑an ‑bha ꞊yö ‑së, bhii 'ö tɔɔ ‑Zlan ‑yö ‑dho ‑an 'yena yö 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mɛ ‑nu 'ö ‑an ꞊zuöpiödhɛ 'dhö 'puu, ‑an ‑bha ꞊yö ‑së, bhii 'ö tɔɔ ‑wo ‑dho ‑Zlan yö. ");
INSERT INTO dnj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mɛ ‑nu 'wo ‑nëng 'kuë‑ kë ‑na mɛ ‑nu 'ka, ‑an ‑bha ꞊yö ‑së, bhii 'ö tɔɔ ‑Zlan ‑dho ‑an ‑dhɛ ö bha 'në ‑nu. ");
INSERT INTO dnj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mɛ ‑nu 'wo ‑an 'klo bhɔ ‑na ‑Zlan ꞊dhɔɔbhaa kë ‑sü ‑wun 'gü, ‑an ‑bha ꞊yö ‑së, 'ö tɔɔ ‑Zlan ‑bha ‑gludëdhɛ ‑yö ‑an ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","꞊Ya kë ꞊nɛ mɛ ‑nu ꞊wa 'si ‑nu bho ka ‑gɔ, ꞊wa ka 'klo ‑nu bhɔ 'iin ꞊sua ‑nu kë ka ‑gɔ 'wun yaa ‑blɛɛ ka ‑gɔ ‑sü 'ka, ka ‑bha ‑kë n bha ꞊guë' ‑nu 'ka ‑sü ‑wun 'gü, ka ‑bha ꞊yö ‑së, ");
INSERT INTO dnj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ka ꞊zuö' 'glu ‑yö dhi ꞊va, bhii ka 'kian ꞊va ‑yö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü. ‑Kɔ bhë ꞊nɛ 'ö ‑Zlan ‑wodhiölomɛ ‑nu 'wo ‑kë ka 'dhiö, 'wo ‑an 'klo bhɔa 'pö.» ");
INSERT INTO dnj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","'Yö Yesu ‑ya pö 'zü: «'Kpongtaamɛ ‑nu ziën, ka ‑kë ꞊nɛ kweezö 'ö ꞊ya kë pë ‑bha 'ö pë 'yaa bu bhë ‑a 'dhö. 'Kɛɛ ꞊ya kë ꞊nɛ kweezö din 'yaa‑ ‑bha gbɔ, ‑wo ‑dho ‑a ‑kɔklë kö ‑a din ‑yaan kë ‑a ‑bha 'zü ‑dëüwo ꞊e? Kö ‑a ꞊kaa' ‑pë gbɛ 'yaa ‑dhö gbɔ, ‑a ꞊zong' 'wo dho ‑a wo plaan zlöö, 'ö mɛ ‑nu ‑wo ꞊taa ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ka 'ka tɔɔ 'kpongtaamɛ ‑nu ‑bha ‑dhɛpuudhɛ. Kwa‑ ꞊tɛi' dɔ ꞊nɛ pödhɛ 'ö dɔ ‑sü 'ka ‑tɔn tuö 'yaa ‑bin. ");
INSERT INTO dnj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","'Waa ꞊labang dɔ kö ‑waan dɔ 'gbonggbo ꞊löö. ‑Abi', ‑wa ‑dɔ ꞊labang ‑dɔ ‑a ‑ta dhuö ‑pë ‑ta, 'ö ‑dhɛ ‑po mɛ ‑nu 'wo kɔɔ 'saadhö ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","‑Kɔ bhë ꞊nɛ 'ö ka ‑bha ‑dhɛpuudhɛ dho bhü ‑a 'ka mɛ ‑nu 'dhiö. ‑Yö kë 'dhö, kö ka ‑bha 'wun ‑së kë ‑sü 'ö bhë ‑waan ‑a yö, kö ka Dë ‑Zlan 'ö dhang‑ ‑nu 'gü bhë ‑waan ‑a 'tɔ kë ꞊va.» ");
INSERT INTO dnj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","'Ö‑ pö ‑an ‑dhë 'zü: «Kö ꞊kun 'ö ‑kë ka ‑zo 'piö ꞊nɛ, a ‑nu kö tɔng ‑nu 'ö Moizö ‑ya dɔ bhë 'aan‑ ‑a 'gü ꞊siö'‑, 'iin mɛ ꞊daan' ‑wo 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑wa nu kwa ‑dhë bhë kö 'aan‑ ‑an 'gü ꞊siö'‑, 'kɛɛ a ‑nu kö 'aan‑ ‑an 'dhiö ‑mɔ 'kuë. ");
INSERT INTO dnj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bhii a‑ ‑blɛɛ ka ‑dhë giagia 'ka, ‑a kë ꞊yië' kö dhang‑ waa‑ 'sɛ ‑waan ziö, tɔng ‑nu 'saadhö 'wo ꞊nɛ ‑a do ꞊bɛɛn' ‑pin 'iin ‑a pë 'tee do ‑yö 'ka 'dho go ö pin ꞊taa, 'ö dhö to 'dhö 'ö yöë pë ‑nu 'plɛ 'dhiötoyi ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","‑A ‑wun 'gü, tɔng ‑nu 'wo ꞊nɛ, 'kö ‑kë ‑a 'teezë 'ka, mɛ 'ö yaa‑ ꞊bhlë ‑ya 'iin 'ö‑ pö mɛ ‑nu ‑dhë ‑wa kë ꞊nɛ ‑kɔ bhë ‑a 'dhö, ‑yö ‑dho kë mɛ 'teezë 'ka, ‑Zlan ‑bha ‑gludëdhɛ 'gü dhang‑ ‑nu 'gü. 'Kɛɛ mɛ 'ö 'dhoë‑ tɔng ‑nu 'wo ꞊nɛ ‑an ꞊bhlë ‑ya, kö ‑yaan mɛ ‑nu ‑daan ‑a 'ka, kö ‑waan ‑a kë ꞊nɛ ‑kɔ bhë ‑a 'dhö, ‑yö ‑dho kë mɛ ꞊va 'ka ‑Zlan ‑bha ‑gludëdhɛ 'gü dhang‑ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A‑ ‑pö ka ‑dhë ꞊nɛɛ: ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü bhë, ka ‑dho ‑da ‑a 'gü, 'kɛɛ kö ka ‑bha ‑kë kpengdhö ‑sü bhë ꞊ya ziö Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu ‑bha ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","'Yö‑ pö 'zü: «Pë 'ö ‑Zlan ‑ya pö ka 'bhɛma ‑nu ‑dhë 'ö tɔɔ ꞊nɛɛ: Kö ꞊kun 'ü mɛ zë; mɛ 'oo mɛ 'ö 'dhoë‑ mɛ zë, ‑wo ‑dho ‑a 'ka zakanmɛ 'dhiö 'ö ka gia‑ 'ka‑ ma. ");
INSERT INTO dnj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","'Kɛɛ ma ‑zë, a‑ ‑pö ka ‑dhë ꞊nɛɛ: Mɛ 'oo mɛ 'ö 'dhoë‑ ‑da ‑naazuëdhe 'gü ö dheglu ‑mɛ buëndhö, ‑wo ‑dho dho ‑a 'ka 'ö za ‑yö dɔ ‑a ‑bha. Mɛ 'ö ꞊yaa‑ pö ö dheglu ‑mɛ ‑dhë: ‹Laka!› (꞊Waa‑ pö 'dhö kö ‑wa ‑pö: Wü ‑mü ü 'ka), ‑wo ‑dho ‑a 'ka zakanmɛ ꞊va 'dhiö, 'iin mɛ 'ö 'dhoë‑ pö ö dheglu ‑dhë: ‹Somɛ ‑mü ü 'ka›, kö pë 'ö‑ ‑ma kun 'ö tɔɔ ‑a 'klo ‑yaan bhɔ ꞊glöötiaandhö 'siö 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","'Ö ꞊ya kë ꞊nɛ 'bha nu gbaapë ‑nu 'ka ‑Zlan wö 'dhiö, ‑a ‑bha slabhodhɛ ‑bha, 'ö ü ‑zo ꞊ya ‑büö ꞊nɛ 'wun 'bhaa ‑yö ü dheglumɛ ‑zuëë ü buëndhö, ");
INSERT INTO dnj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","‑bhö ü ‑bha gbaapë ‑nu bhë, ‑an 'to slabhodhɛ 'dhiö mü 'ü 'dho ꞊kun 'ü ꞊zuögludhi ‑da kaa‑ ü dheglu ‑mɛ bhë ka ziën, kö 'üën‑ nu ü bha gbaapë ‑nu bhë ‑a 'ka ‑Zlan wö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","'Ö ꞊ya kë ꞊nɛ mɛ ꞊ya 'wun ‑ya ü ‑bha, 'ö 'ka 'dho ‑na zadɔdhɛ ‑bha 'wun bhë ‑a ꞊blɛɛ' ꞊dhia, ‑bhö ‑a këdhɛ ꞊mɛɛ'‑ kö ka ‑wo ‑yö ‑mɔ 'kuë 'dhiö zian ‑gbloo 'piö, kö ꞊kun 'ö dho ü dɔ zakanmɛ ‑nu kwɛɛ, kö zakanmɛ ‑nu ‑de 'pö ‑waan ü ‑dɔ 'dhasi ‑nu kwɛɛ, kö ‑waan ü ‑zuö ‑kanso 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A‑ ‑pö ü ‑dhë 'wun gia‑ 'ka: Ü 'ka 'dho go mü 'gbɛɛdhö, ‑a 'ke ü 'ka mɛ 'ö 'dhö bhë ‑a ‑bha pë 'ö ü ‑bha bhë ‑a ‑yöë piën‑ nu ‑a ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","'Ö Yesu ‑ya pö: «'Ka‑ ma 'saadhö ꞊nɛ ‑Zlan ‑wo ‑ya pö: Kö ꞊kun 'ö 'ka ‑da dhe 'piö 'iin 'ka ‑da ka 'bha dhe ‑bha gɔɔn‑ 'piö, ");
INSERT INTO dnj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","'kɛɛ ma ‑zë a‑ pö ka ‑dhë ꞊nɛɛ: Mɛ 'oo mɛ 'ö 'dhoë‑ dhebɔ ‑ga ö buën‑ ‑a ‑dhɔ ‑yaan ‑a kë kö ꞊ya ‑da ‑a 'piö ö ꞊zuö' 'gü 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Ö ꞊ya kë ꞊nɛ ü ꞊kwɛɛ‑ 'gü 'yanga 'ö‑ ‑kë ü ‑püö ꞊sɔɔn yaa 'gü, kö ‑bhö ‑a bho mü 'ü‑ ꞊zong' ü 'ka ꞊gbiin! ꞊Yö ‑së kö ü bun ‑dhɛ 'bhaa ‑yö 'go ü ‑bha 'yö ꞊zië' ü bun ‑bha ‑to 'dhö ‑sü 'wo ü ꞊zong' ꞊glöötiaandhö 'siö 'gü ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Ö ꞊ya kë ꞊nɛ ü ꞊kwɛɛ‑ 'gü ‑kɔ ꞊nɛ 'ö ü ‑püö ꞊sɔɔn yaa 'gü, kö ‑bhö ‑a 'klu 'kan 'ü‑ ꞊zong' ü 'ka ꞊gbiin! Bhii ꞊yö ‑së ü ‑bha 'ka kö ü ‑gbiö do 'iin ü ‑gɛn do ‑yö 'kan ü ‑bha, 'ö ꞊zië' ü bun ‑to 'dhö ‑sü 'ü dhoë ꞊glöötiaandhö 'siö 'gü bhë ‑a ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","'Ö Yesu ‑ya pö 'zü ‑a pö ‑sü 'ka ꞊nɛɛ: «Mɛ 'ö 'dhoë‑ ö bha dhebɔ bho 'blü, ‑yö ‑dho ‑a ‑bho 'blü 'sëëdhɛ kpa ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","'Kɛɛ ma ‑zë, a‑ ‑pö ka ‑dhë ꞊nɛɛ: Mɛ 'oo mɛ 'ö 'dhoë‑ ö bha dhebɔ kë, 'ö yaa 'to ö ‑wo ‑ta, ꞊ya 'dho gɔɔn‑ gbɛ 'piö kö ‑a gɔɔn‑ zii bhë yö ꞊nɛ 'ö‑ ‑kë 'ö dhebɔ bhë 'ö ‑kë ꞊sɔɔnkëdhe 'ka. 'Go mü 'pö, mɛ 'ö 'dhoë‑ ö ‑kɔ kpɔ dhe 'ö 'dhö bhë ‑a ‑gɔ kö ‑yaan ‑a 'sü 'pö, kö ‑dadhepiömɛ ‑mü ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","'Yö‑ pö 'zü: «Pë 'ö 'ka‑ ma, 'ö‑ ꞊blɛɛ kwa 'bhɛma ‑nu ‑dhë 'ö tɔɔ: Kö ꞊kun 'ü ü ‑wo ‑bhö ꞊sua 'ka, 'go mü 'zü: Kö ꞊kun 'ü ‑wo ‑bhö ꞊sua 'ka; 'kɛɛ pë 'ü dho ‑a kë 'ö tɔɔ 'wun 'ü ü ‑wo ‑bhö ‑a ‑wun 'ka kwa Dëmɛ wö 'dhiö bhë, ‑bhö ‑a kë! ");
INSERT INTO dnj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","'Kɛɛ ma ‑zë, a‑ ‑pö ka ‑dhë: Kö ꞊kun 'ka ka ‑wo ‑bhö 'gbɛɛdhö! Kö ꞊kun 'ka ka ‑wo ‑bhö dhang‑ 'gü ‑dhɛ 'tɔ 'ka! Bhii 'ö tɔɔ ‑Zlan ‑bha 'gɔ ‑gbloo ‑mü ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","'Iin 'ka ‑wo ‑bhö sia‑ ‑dhɛ 'tɔ 'ka bhii 'ö tɔɔ yö ꞊nɛ 'ö ‑Zlan ‑gɛn ‑lo ‑a ‑ta ‑pë 'ka. 'Iin kö 'ka ‑wo ‑bhö Zeluzalɛmë ‑dhɛ 'tɔ 'ka, bhii 'ö tɔɔ ‑yö ‑gludë ꞊va ‑bha pödhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kö ꞊kun 'ka ka ‑wo ‑bhö ka ‑gɔ 'tɔ 'ka, bhii 'ö tɔɔ ü ‑kɔ 'ka 'dho ‑mɔ ‑a ‑bha kö 'ü ü ‑bha wun ga do kë ü ‑de ‑dhë 'puu 'iin tii. ");
INSERT INTO dnj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","'Kɛɛ a‑ ‑blɛɛ ka ‑dhë: Ka ‑bha ꞊ii‑ ‑yö kë ꞊ii‑ 'ka, 'iin ka ‑bha ‑abi' ‑yö kë ‑abi' 'ka. ꞊Ya 'go mü, pë ‑nu 'ö mɛ ‑nu 'dho ‑a pö ‑na ‑a 'piö zlöö bhë ‑yö ‑go dü 'piö.» ");
INSERT INTO dnj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","'Ö Yesu ‑ya pö 'zü: «Pë 'ö 'ka‑ ma 'zü 'ö tɔɔ ꞊nɛɛ: Mɛ 'ö ꞊ya ö 'bhamɛ 'yan wü, ‑wa ‑bha 'wü 'pö 'iin mɛ 'ö ꞊ya ö 'bhamɛ 'sɔn ga 'yɛ, ‑wa ‑bha 'yɛ 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","'Kɛɛ ma ‑zë a‑ ‑pö ka ‑dhë: Kö ꞊kun 'ka ka ‑de ‑gbɔ bho mɛ 'ö 'wun yaa ‑kë ka 'ka bhë ‑a ‑ta! 'Ö ꞊ya kë ꞊nɛ mɛ ꞊ya ü ꞊kwɛɛ‑ 'gü 'to ‑ma, ‑bhö ü ꞊kwaa‑ 'gü ‑bha ‑zɔn ‑a ‑dhë ‑ya ‑a ‑ma 'pö! ");
INSERT INTO dnj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","'Ö ꞊ya kë ꞊nɛ mɛ ꞊ya kë ‑dhö ꞊ya 'dho ü 'ka zakanmɛ 'dhiö kö ‑yaan ü bha sɔ 'në 'kun ü ‑gɔ, ‑bhö sɔ 'në 'ö 'dhö waa‑ ü bha gblang ‑a 'plɛ 'to ‑a ‑gɔ! ");
INSERT INTO dnj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","'Ö ꞊ya kë ꞊nɛ mɛ 'ö ‑wogbiindhɛ 'dhö ‑a ‑gɔ, ‑a mɛ do ꞊yaa‑ pö ü ‑dhë 'ü ꞊kwɛɛ‑ 'gbiin‑ bun 'ü 'ta 'sü ‑a 'ka 'kilong do 'piö, ‑bhö ‑a bun 'ü 'dho ‑a 'ka 'kilong ꞊plɛ ‑naa ‑bha! ");
INSERT INTO dnj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mɛ ꞊ya pë ‑dhɛ ü ‑gɔ, ‑bhö ‑a nu ‑a ‑dhë! 'Go mü, mɛ ꞊ya pë 'sënng ‑dhɛ ü ‑gɔ, kö ꞊kun 'ü ‑kɔ ‑a ‑dhë ‑a ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","'Yö‑ pö 'zü: «Pë 'ö 'ka‑ ma 'zü 'ö tɔɔ ꞊nɛɛ: Ü ‑dho ‑a ‑dhɔ kë ü ‑ya 'yɔɔ 'ka, 'ü ü yaagümɛ ‑san zë, ");
INSERT INTO dnj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","'kɛɛ ma ‑zë, a‑ ‑pö ka ‑dhë: ‑Kaa ‑dhɔ kë ka yaagümɛ 'ka, 'ka 'dhuë‑ 'kpɔ mɛ ‑nu 'wo 'kpöü ‑ya ka ‑bha ‑an ‑bha! ‑Ka pë ‑së kë mɛ ‑nu 'wo ka ‑san zë ‑na ‑an ‑dhë! 'Go mü 'ka ꞊bhɛa' mɛ ‑nu 'wo 'wun yaa kë ‑na 'ö 'wo ka 'klo bhɔ ‑na ‑an ‑wun 'gü! ");
INSERT INTO dnj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","‑Yö kë 'dhö kö 'kaan‑ kë ka Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bhë ‑a gbö ‑nu 'ka. Bhii 'ö tɔɔ ‑yö ö bha lan‑ ‑bhü 'pö ‑së 'ka, 'wunyaakëmɛ ‑nu ‑ta ꞊nɛ ‑kɔ 'ö‑ bhü ‑a 'ka mɛ këwunsëëzë ‑nu ‑ta ‑a 'dhö. 'Yö ö bha dha ‑nu ban mɛ ‑nu 'wo 'wun ‑kë yaa ‑an ‑ta ꞊nɛ ‑kɔ 'ö‑ ban mɛ ‑nu 'wo 'wun ‑së ‑kë ‑an ‑ta bhë ‑a 'dhö 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","'Ö ꞊ya kë ꞊nɛ 'ka‑ ‑dhɔ kë mɛ ‑nu 'wo‑ ‑dhɔ ‑kë ka 'ka bhë ‑an 'ka, ‑Zlan ‑dho ka 'kian nu ‑kɔklë ꞊ɛ? ‑A mɛ 'kö bhë, mɛ këwun yaazë 'wo ꞊nɛ 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu 'dhö bhë, wo ‑de 'pö, ‑wa ‑kë ꞊nɛ ‑kɔ gia‑ bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","'Ö ꞊ya kë ꞊nɛ 'ka ‑mɛɛ kë ka dhegluzë ‑nu 'sloo 'ka, kö pë 'gblüünzë 'pö 'ka‑ ‑kë bhë ꞊a? Mɛ ‑nu 'ö 'waa ‑Zlan ‑bha mɛ ‑nu 'ka, wo gia‑ ‑wa ‑kë 'dhö 'pö! ");
INSERT INTO dnj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","꞊Dhɛ 'ö 'dhö ꞊nɛ, ‑ka 'wun ‑nu yö 'ko 'dhiö kpengdhö ꞊nɛ ‑kɔ 'ö ka Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bhë 'ö‑ kë ‑na ‑a 'ka bhë ‑a 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","'Ö Yesu ‑ya pö 'zü: «‑Ka ka ‑zo kë ka ‑de 'piö ka ka ‑bha ‑Zlan gba ‑kɔ ‑nu ‑wun 'gü, kö ꞊kun 'ö dho kë mɛ ‑nu 'yaan 'kun ‑sü 'ka! ꞊Ya kë ꞊nɛ 'ka‑ kë mɛ ‑nu 'yaan 'kun ‑sü 'ka, ka 'ka 'dho ka 'kian gbɛ yö, ka Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bhë ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","꞊Ya kë ꞊nɛ 'bha 'wëüga nu 'yenamɛ ‑dhë, kö ꞊kun 'ü‑ ‑kë 'ö mɛ 'yan 'yö ‑da ‑a 'gü ꞊nɛ ‑kɔ 'ö mɛ 'yan ‑ta ‑pë kë ‑mɛ ‑nu 'dhoë‑ kë ‑na ‑a 'ka ‑bhɔkuëkɔ ‑nu 'gü, 'iin ‑kpinngga 'piö ‑dhɛ ‑nu ‑bha bhë ‑a 'dhö! ‑Wa ‑kë 'dhö kö mɛ ‑nu ‑waan wo 'tɔ ‑blü. A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: Wo ‑zë ꞊wa wo 'kian yö 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'Kɛɛ bhi ‑zë, ü 'dhoë‑ 'wëüga nu 'yenamɛ ‑dhë, ‑bhöë kë kö ꞊kun 'ö ü 'bhamɛ ‑de 'ö ü 'sɔɔ, 'ö‑ 'wun dɔ! ");
INSERT INTO dnj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","‑Yö kë 'dhö kö gbaɔ 'ü‑ ‑kë bhë ‑yö 'to ‑bin ‑sü 'gü, kö ü Dë 'ö pë ‑nu 'ü‑ kë ‑na ‑bin ‑sü 'gü 'ö ‑an yö bhë kö ‑yaan ü 'kian nu.» ");
INSERT INTO dnj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","'Yö‑ pö 'zü: «Ka ꞊bhɛa' ‑na kö ꞊kun 'ka‑ ‑kë ꞊nɛ mɛ ‑nu 'yan ‑ta ‑pë kë ‑mɛ ‑nu 'dhö; ꞊wa ‑dhɔ ‑kë ‑dɔ ‑gɛan ‑sü, 'wo ꞊bhɛa Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü, 'iin ‑kpinngga 'to 'dhiö ‑dhɛ ‑nu ‑bha ‑a 'ka kö mɛ ‑nu 'yan ‑yaan ‑da wo 'gü ‑an 'dhö. A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: Wo ‑zë ꞊wa wo 'kian yö 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","'Kɛɛ bhi ‑zë, ü 'dhoë‑ ꞊bhɛa'‑, ‑bhö ‑da ü ‑gɔ kɔɔ 'ü 'kwɛɛ ta ü ‑blü 'ü ꞊bhɛa'‑! ꞊Ya kë 'dhö ü Dë (‑Zlan) 'yö ü 'piö ‑bin ‑sü 'gü bhë, 'ö pë ‑nu 'ü‑ kë ‑na 'dhö 'ö‑ yö bhë, ‑yö ‑dho ü 'kian nu. ");
INSERT INTO dnj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ka 'dhoë‑ ꞊bhɛa'‑, kö ꞊kun 'ka 'dhi ‑wo ‑yaan ꞊plëëzë ꞊blɛɛ ꞊nɛ mɛ ‑nu 'ö 'waa ‑Zlan dɔ ‑an ‑bha ꞊bhɛa' ‑kɔ 'dhö! ‑Yö ‑an ‑zo 'piö ꞊nɛ, mɛ ꞊ya 'wun ꞊blɛɛ'‑ ꞊va, yö ꞊nɛ 'ö ‑Zlan ‑yö ö 'to ‑kë ‑a ‑wo ‑bha, 'ö‑ ‑bha ꞊bhɛa' ‑wo ‑daa ‑kë. ");
INSERT INTO dnj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","‑Abi', kö ꞊kun 'ka‑ ‑kë ꞊nɛ ‑an 'dhö! 'Ö tɔɔ kö ‑a ‑de kaa pë ‑dhɛ ka Dë ‑gɔ ꞊kun, pë 'ö ka ‑bha ‑wun ‑yö yö ‑a ‑bha, kö ꞊yaa‑ dɔ 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","꞊Bhɛa' ‑kɔ 'ö 'ka dho ꞊bhɛa ‑a 'ka 'ö ꞊nɛɛ: Yi Dë, bhi 'ü ‑ya ‑sü 'ka dhang‑ ‑nu 'gü, ü 'tɔ 'slööslö bhë ‑a ꞊bhlë ‑yö kë ‑dhö ‑dhɛ 'saadhö 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ü bha 'tɔbhɔdhe ‑yö nu. Ü ꞊dhɔɔbhaa ‑yö kë 'kpongtaa ꞊nɛ ‑kɔ 'ö‑ 'ka dhang‑ 'gü bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","‑Bhöpë 'ö ‑mɔ yi ꞊tian' ꞊dɛɛ, ‑bhö ‑a nu yi ‑dhë! ");
INSERT INTO dnj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","‑Bhö ziö yi ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta ꞊nɛ ‑kɔ 'ö 'yi ‑ziö ‑a 'ka mɛ ‑nu ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta 'pö bhë ‑a 'dhö! ");
INSERT INTO dnj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kö ꞊kun 'ü ‑kan yi ‑bha 'güdandhe ‑zian ‑ta, 'kɛɛ ‑bhö yi bho këpëyaamɛ ‑bha 'piigbeedhɛ ꞊kwaa'‑. Bhii bhi ꞊nɛ 'ö ‑gludëdhɛ, 'piigbeedhɛ waa‑ 'tɔbhɔdhe 'dhö ü ‑gɔ ꞊toëpö 'ka. Amɛn. ");
INSERT INTO dnj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","꞊Ya kë ꞊nɛ mɛ ‑nu ‑bha 'wun ꞊zaa' ‑sü ‑nu 'wo‑ ‑kë ka 'ka bhë 'ka ziö ‑a ‑ta, ka Dë 'ö dhang‑ 'gü, ‑yö ‑dho ziö ka ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'Kɛɛ ꞊ya kë ꞊nɛ kaa ziö mɛ ‑nu ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta, ka Dë ‑de 'pö yaa 'dho ziö ka ‑bha ꞊zaa' ‑sü ‑nu ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","'Yö‑ pö 'zü: «꞊Ya kë ꞊nɛ ka ka ‑bɛn 'to ‑na, kö ꞊kun 'ka ka wöödhɛ ‑kë 'güüzë ꞊nɛ mɛ 'yan ‑ta ‑pë kë ‑mɛ ‑nu 'dhö! 'Ö 'wo wo wö ‑siö kö mɛ 'plɛ ‑waan dɔa ꞊nɛ ‑wo wo ‑bɛn 'to ‑sü 'gü. A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: Wo ‑zë ꞊wa wo 'kian yö 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","'Kɛɛ bhi ‑zë, ü ü ‑bɛn 'to ‑na, ‑bhö ü wöödhɛ 'zlu, 'ü ü ‑bha wun ‑nu ‑piö ‑së 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","‑Yö kë 'dhö kö ꞊kun 'ö mɛ ‑nu dho ‑a ꞊tɛi' dɔ ꞊nɛ ü ü ‑bɛn 'to ‑sü 'gü. Ü Dë dosɛn 'ö ‑bin ‑sü 'ka ü 'piö mü bhë, yö ꞊nɛ 'ö dho ‑a dɔ. ꞊Ya kë 'dhö pë ‑nu 'ü‑ kë ‑na ‑bin ‑sü 'gü bhë, yö 'ö‑ dɔ bhë yö ꞊nɛ 'ö dho ü 'kian nu.» ");
INSERT INTO dnj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","'Yö‑ pö: «Kö ꞊kun 'ö ka ‑bha ꞊bhɔɔpë ‑nu 'kpuɛkpɔdhɛ ‑yö ‑kë 'kpongtaa zö, bhii 'kpongtaadhɛ 'ö ꞊nɛ 'ö tɔɔ ‑dhɛ 'ö 'lɔɔn ‑nu waa‑ 'kaɔ 'wo pë 'gü ꞊siö ‑a ‑bha, 'ö ꞊kwaanmɛ ‑nu ‑wo 'kɔ kpong wü, 'wo ꞊kwaan ‑a ‑bha bhë ‑a ‑bha! ");
INSERT INTO dnj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","'Kɛɛ ‑ka ka ‑bha ꞊bhɔɔpë ‑nu 'kpuɛ‑ 'kpɔ dhang‑ 'gü, ‑dhɛ 'ö 'lɔɔn ‑nu waa‑ 'kaɔ 'waa pë 'gü ꞊siö'‑ ‑a ‑bha, 'ö ꞊kwaanmɛ ‑nu wo 'ka 'dho 'kɔ kpong wü ‑waan pë ꞊kwaan ‑a ‑bha! ");
INSERT INTO dnj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Bhii ‑dhɛ 'ö ü bha ꞊bhɔɔpë ‑nu 'dhö ‑a ‑bha, yö ꞊nɛ 'ö ü ꞊zuö' 'dhö ‑a ‑bha 'pö!» ");
INSERT INTO dnj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","'Yö‑ pö 'zü: «'Yanga ‑yö ‑kë ꞊nɛ bun ‑bha ‑dhɛpuudhɛ 'dhö. ‑Potaasü ꞊ya kë 'yanga ‑gɔ, 'ö ü bun 'gü ‑dhɛ 'plɛ ‑yö ‑kë 'puu. ");
INSERT INTO dnj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","'Kɛɛ ꞊ya kë ꞊nɛ ü 'yanga ꞊ya kë yaa, kö ü bun 'plɛ 'dho ‑sü ‑mü ‑dhɛtiidhɛ 'gü. 'Ö ꞊ya kë ꞊nɛ pë 'ö dho ü gbaa ‑dhɛpuudhɛ 'ka, ‑yö ‑dhɛtiidhɛ 'gü, kö ‑dhɛtiidhɛ 'ö bhë ‑yö ‑dho trö ꞊gbaɔnsü.» ");
INSERT INTO dnj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","'Yö‑ pö 'zü: «Mɛ gbɛ yaa 'dho ‑mɔ ‑a ‑bha kö ‑yaan yuö kë ‑gɔmɛ ꞊plɛ 'piö. ‑Yö ‑dho ‑a mɛ do ‑san zë, 'ö‑ mɛ do ‑dhɔ ‑kë. ‑Yö ‑dho kpa mɛ do ‑bha, 'ö ‑kan mɛ do ‑bha. ‑A ‑wun 'gü, ka 'ka 'dho ‑mɔ ‑a ‑bha kö 'kaan‑ yuö kë ‑Zlan waa‑ 'wëüga ‑an ‑dhë 'ko ꞊yië'.» ");
INSERT INTO dnj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«꞊Dhɛ 'ö 'pö, a‑ ‑pö ka ‑dhë: Kö ꞊kun 'ka dɔ pë 'ka dho ‑a ‑bhö waa‑ pë ‑nu 'ö 'ka dho ‑a mü kö 'kaan‑ ‑tosiadhe kë ‑a ‑ta, 'iin sɔ ‑nu 'ö 'ka dho ‑a ‑da ka ‑bha ‑an ‑wun ꞊zɔnng' ‑ta! ‑Tosiadhe kë ‑sü ‑wun ‑yö 'gbee‑ 'ö ꞊zië' ‑bhöpë ‑ta, 'ö bun ‑wun 'dhö 'gbee‑ 'ö ꞊zië' sɔ ‑wun ‑ta, 'wun gia‑ 'yaa ‑mü ‑a? ");
INSERT INTO dnj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","‑Ma ‑nu 'wo ziö ‑na dhang‑ 'gü ꞊nɛ, ‑ka ‑an ‑ga! 'Waa pë gbɛ ta, ‑an ‑kɔ këpë ‑nu gbɛ 'yaa 'dhö, 'iin ‑bhöpë ‑nu 'wo dho ‑a ‑lo wo ‑bha 'slëëdhɛ ‑nu ‑bha 'yaa 'dhö. 'Kɛɛ ka Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü, ‑yö ‑bhöpë ‑nu ‑an ‑dhë. ꞊Dhɛ ‑kë 'dhö ꞊nɛ, ka ‑wun 'yaa 'gbee‑ yaa ꞊zië' ‑ma ‑nu 'wo bhë ‑an ‑ta ‑a? ");
INSERT INTO dnj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Dö ‑mü ka ziën 'ö‑ ‑bha ‑zotadhe 'gü 'ö dho ‑dhɛkpaɔyi 'bhaa ‑da ö ‑bha ‑tosiadhe yi ‑ta ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","'Ö bhii ꞊dhɛ ꞊ya kë 'dhö ꞊nɛ, ‑më 'ö ‑kë 'yö 'ka ‑ya sɔ 'ö 'ka dho ‑a kë ka ‑bha, ‑a ‑wun ꞊zɔnng' ‑ta ‑i? ꞊Blëë' 'bin ‑nu 'wo kë ‑na ꞊bhlöö‑ ꞊nɛ, ‑ka ‑an ‑ga bhë 'dhɛ! 'Waa yuö gbɛ kë, 'iin 'waa sɔ gbɛ bɔ. ");
INSERT INTO dnj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","‑Yö 'dhö, a‑ ꞊blɛɛ' ‑na ka ‑dhë ꞊nɛ ‑gludë Salomɔ ‑de gia‑, ‑a ‑bha 'tɔbhɔdhe 'gü, ꞊bhɔɔpë ꞊va 'ö ‑kë ‑a ‑gɔ bhë ‑a 'ka, sɔ 'ö dho kë ‑së ꞊nɛ ꞊blëë' 'bin ‑nu 'wo bhë ‑an do 'dhö yaa kë ‑a ‑gɔ do. ");
INSERT INTO dnj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","‑Zlan 'ö sɔ ‑së ‑da ‑na ꞊blëë' 'bin ‑nu 'wo ꞊dɛɛ ꞊bhlöödhɛ ‑nu ‑bha, 'ö ꞊dhia' 'piö 'wo dho ‑an kan kö wo ‑an güö ‑an ‑bha bhë, ‑a ‑kɔ 'pö yaa 'dho ‑mɔ ‑a ‑bha kö (ka 'ö ka ‑wun 'dhö ‑a ‑gɔ 'gbee‑ bhë) ‑yaan sɔ nu ka ‑dhë bhë ꞊a? Ka‑ ‑yö bhë ꞊a, kë ka ‑bha ‑zoyösü ‑yö ‑ya wo 'tee bhë yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","꞊Dhɛ ‑kë 'dhö, kö ꞊kun 'ka ‑ya ka ‑de ‑wun ꞊zɔnng' ‑ta ‑a pö ‑sü 'ka ꞊nɛɛ: ‹‑Më ‑nu 'yi dho ‑a ‑bhö ‑e? ‑Më 'yi dho ‑a mü ꞊i? 'Iin ‑më ‑nu 'yi dho ‑a kë yi bun ‑bha ‑ɛ?› ");
INSERT INTO dnj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mɛ ‑nu 'ö 'waa ‑Zlan dɔ wo ꞊nɛ 'ö pë ‑nu 'wo 'dhö bhë 'wo‑ ꞊mɛɛ ‑kplawo. 'Kɛɛ ka Dë 'ö ‑ya ‑sü 'ka dhang‑ 'gü bhë ‑ya ꞊tɛi' ‑dɔ ꞊nɛ ka ‑bha ‑wun ‑yö ‑yö ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","‑Ka ‑Zlan ‑bha ‑gludëdhɛ waa‑ ‑tosiadhe 'ö kpengdhö ‑an ꞊mɛɛ' 'dhiö ‑blɛɛzë, kö pë ‑nu 'wo to, ‑Zlan gia‑ ‑yaan ‑an nu ka ‑dhë, ‑a ‑ta 'kpɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","‑A ‑wun 'gü, kö ꞊kun 'ka ‑ya ‑dhɛ 'ö dho kpaɔ ꞊dhia' ‑a ‑wun ꞊zɔnng' ‑ta! 'Ö tɔɔ ‑dhɛkpaɔyi 'saadhö 'ö ‑dhö, ‑a ‑bha ‑zo ‑ta ‑a 'gü ‑wun ‑yö ‑dhö do do 'ka. ‑Dhɛ do 'ö ꞊kpaɔ ‑na bhë ‑a ‑bha ꞊sëëbhodhe ‑yö ‑mɔ ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","'Yö‑ pö ‑an ‑dhë 'zü: «Kö ꞊kun 'ka za dɔ mɛ gbɛ ‑bha! ‑Yö kë 'dhö, kö ꞊kun 'ö ‑Zlan dho za ‑lo ka tuö. ");
INSERT INTO dnj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bhii ‑Zlan ‑dho za ‑lo ka tuö ꞊nɛ ‑kɔ 'ö 'ka za dɔ ‑a 'ka mɛ ‑nu 'wo to ‑an ‑bha ‑a 'dhö. 'Ka za dɔ mɛ ‑bha 'gbee‑ 'ka, ‑Zlan ‑dho za ‑lo ka tuö 'pö 'gbee‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","‑Më 'ö ‑kë 'ö 'lü ‑gba ꞊va 'yö ‑sɔ ü 'yënngdhö bhë 'ö 'bhaa‑ yö, 'ö‑ pë 'ö dho ü dheglu 'yënngdhö bhë, 'yö 'ü ‑dhɛ ‑ga ‑a 'piö e? ");
INSERT INTO dnj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ü ‑dho ‑a pö ü dheglu ‑dhë ‑kɔklë: ‹Dɔ, 'a pë 'ö bhë 'a‑ bho ü 'yënngdhö!›, 'kɛɛ kö ü ‑bha 'lü ‑gba ꞊va ‑yö ü 'yënngdhö 'sa? ");
INSERT INTO dnj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mɛ 'yaan‑ 'kun ‑mɛ, ‑bhö ü ‑bha 'lü ‑gba bho ü 'yënngdhö poo ꞊e, kö 'üën‑ ‑dhɛ yö ‑së 'ka, 'üën‑ ü dheglu ‑bha bho ‑a 'yënngdhö 'pö! ");
INSERT INTO dnj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kö ꞊kun 'ö pë 'ö 'slööslö 'ka‑ nu gbɛn‑ ‑nu ‑dhë! ‑Yö kë 'dhö, kö ꞊kun 'wo dho ꞊dhië' ka 'piö ‑waan ka 'gü ꞊siö'‑. Kö ꞊kun 'ka ka ‑bha ‑zlɔɔ ‑nu 'ö ‑an ꞊bhlë 'dhö ꞊va, ‑an ‑zuö ‑bhɔtii ‑nu 'dhiö! 'Yö 'wo ꞊taa' ‑a ‑ta dhuö.» ");
INSERT INTO dnj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","'Yö‑ pö 'zü: «'Ka pë ‑dhɛ, ka ‑dho ‑a yö! 'Ka pë ꞊mɛɛ'‑, ka ‑dho ‑a yö! 'Ka 'kwɛɛ ‑ta ‑ma, ‑wo ‑dho ‑a po ka ‑gɔ! ");
INSERT INTO dnj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bhii mɛ 'oo mɛ 'ö pë ‑dhɛ, ‑ya yö, 'ö mɛ 'ö pë ꞊mɛɛ 'ö‑ yö, 'ö 'wo 'kwɛɛ ‑po mɛ 'ö 'kwɛɛ ‑ta ‑ma ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mɛ 'bhaa ‑yö ‑dhö ka ziën zö, 'ö‑ ‑bha 'në ꞊ya ꞊bluu'‑ ‑dhɛ ‑a ‑gɔ, 'ö ‑guö kpö nu ‑a ‑dhë ‑a? ");
INSERT INTO dnj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","'Iin 'ö dhö ꞊mɛɛ 'në sü 'ö‑ nu ‑a ‑dhë kö ꞊ya 'yuö‑ ‑dhɛ ‑a ‑gɔ ‑e? ");
INSERT INTO dnj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","꞊Dhɛ mɛ 'ö 'ka mɛ ‑nu këwunyaazë ‑nu 'ka, 'ka dɔ pë ‑sɛɛbɔ ‑nu ka ‑bha 'në ‑nu ‑dhë ‑dhɛ ‑dɔ bhë, kö ‑sama 'sama, ‑më 'ö ‑kë ka Dë 'ö dhang‑ 'gü, 'yaa 'dho pë ‑sɛɛbɔ ‑nu nu mɛ 'wo‑ ‑dhɛ ‑a ‑gɔ ‑an ‑dhë ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pë 'ka‑ 'piö kö mɛ ‑nu ‑wa kë ka ‑dhë bhë, ‑kaa kë ‑an ‑dhë 'pö! Bhii pë 'ö Moizö ‑bha tɔng waa‑ ‑Zlan ‑wodhiölomɛ ‑nu ‑bha 'sëëdhɛ ‑wa ‑zɔn ‑a 'ka yö ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","'Yö‑ pö 'zü: «‑Da 'kɔdhi 'gbɛa ‑bha ‑sü 'ka‑ ‑ga ‑na bhë, ꞊yö 'pëëpë 'dhö; 'kɛɛ yö ꞊nɛ 'ö tɔɔ zian ‑gblooga 'gbɛa 'ö dho mɛ 'bhee‑ 'ka 'gü ꞊siö' ‑zian 'piö; yö ꞊nɛ 'ö mɛdhɛvadhɛ dhö ‑a ‑zian ‑ta bhë. ꞊Dhɛ 'ö 'dhö ꞊nɛ, ‑ka ‑da 'kɔdhi 'sɔɔsɔ ‑bha ꞊zian'! ");
INSERT INTO dnj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","'Kɛɛ 'kɔdhi 'sɔɔsɔ bhë, yö ꞊nɛ 'ö tɔɔ 'kɔdhi 'ö‑ ‑da mü ‑sü 'dhö 'gbee‑ 'ka. Yö ꞊nɛ 'ö tɔɔ zian ‑gblooga 'ö dho ꞊toëpö ‑këdhösü ‑zian 'piö, 'ö mɛ ‑nu 'wo‑ ‑ta, 'wo 'tee.» ");
INSERT INTO dnj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","'Yö Yesu ‑ya pö ‑an ‑dhë 'zü: «‑Ka ka ‑de kë 'slë 'ka ‑Zlan ‑wodhiölomɛ ‑nu ꞊suazë ‑gɔ! 'Bhla kwi ꞊nɛ 'wo‑ ‑da wo ‑bha 'ö 'ka ‑an ‑ga, 'wo ‑kë 'bhla 'ka ka ‑dhë bhë, 'kɛɛ a‑ ‑pö ka ‑dhë: ꞊N 'n; wo ‑zë, ꞊laa' ‑mü ‑an 'ka 'dhɛ! ");
INSERT INTO dnj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka ‑dho ‑an dɔ ‑an këpë ‑nu ‑bha. 'Waa lɛzɛn ‑kpa bho 'kpa dan ‑kpɔɔ 'gü, 'iin 'waa figö bhɛ bho dhetii 'ginng 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","'Lü 'ö 'lü ‑së 'ka, ‑yö ‑bha ö bhɛ ‑së 'ka, 'ö 'lü mɛ 'ö‑ yaa 'ka, 'yö bha ö bhɛ yaa ‑nu 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Lü 'ö 'lü ‑së 'ka, 'yaa bha ö bhɛ yaa ‑nu 'ka; 'ö 'lü 'ö 'lü yaa 'ka, 'yaa bha 'pö ö bhɛ ‑së ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","'Lü 'oo 'lü 'ö yaa bha ö bhɛ ‑së ‑nu 'ka, ‑a 'kan ꞊nɛ 'wo dho ‑a wo ‑waan ‑a ‑zuö siöö. ");
INSERT INTO dnj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","‑Kɔ do bhë ‑a 'ka, ka dho ‑Zlan ‑wodhiölomɛ ꞊suazë ‑nu dɔ ‑a 'ka ‑an këyuö ‑nu ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","'Yö‑ pö: «Yaa kë ꞊nɛ mɛ ‑nu 'ö 'wo dho ‑a pö ‹N Dëmɛ, n Dëmɛ› 'töüdhö bhë ꞊nɛ 'ö 'wo dho ‑da ‑Zlan ‑bha ‑gludëdhɛ 'gü dhang‑ 'gü; 'kɛɛ dosɛn mɛ 'ö 'dhoë‑ n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü, pë 'ö‑ 'piö 'ö‑ kë. ");
INSERT INTO dnj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","‑Zlan ‑bha zakanyi 'ka, mɛdhɛvadhɛ ‑wo ‑dho ‑a pö n ‑dhë ꞊nɛɛ: ‹N Dëmɛ, n Dëmɛ, yi ‑Zlan 'dhi ‑wo ‑pö ü 'tɔ 'gü, yi ‑zuu yaa ‑nu ‑kë mɛ ‑nu 'gü ü 'tɔ 'gü, 'ö 'yi ‑dhidhaa ꞊plëëzë ‑nu ‑kë ü 'tɔ 'gü›. ");
INSERT INTO dnj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","'Kɛɛ a ‑dho ‑a pö ‑an ‑dhë 'sönggö ‑sönggö: ‹N 'ka ka dɔ 'gbɛɛdhö, ka 'ö ka ‑bha ‑yö ‑kë 'wun yaa kë ‑sü 'ka ‑kplawo bhë, ‑ka ꞊yɔɔn 'ma, 'ka 'go n 'sɔɔ!› » ");
INSERT INTO dnj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","'Yö‑ pö 'zü: «'Ö mɛ 'oo mɛ 'ö ö 'to to 'wun ‑nu 'ka 'go ‑na ‑a ma ꞊dhia ꞊nɛ ‑a ‑bha, 'ö‑ kun ‑a 'kun ‑kɔ gia‑ 'ka, ‑yö ‑dho bhɔ mɛ do 'wun ‑bho 'kou dɔ ‑sü ‑zë, 'ö ö ‑bha 'kɔ dɔ ‑guö ‑ta ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","'Ö dha ‑yö ban, 'ö 'yiga ‑nu ‑wo pa, 'ö 'tëë ‑yö ‑ziö 'gbee‑ 'ka 'kɔ bhë ‑a ‑bha, 'kɛɛ yaa ‑lo, bhii 'ö tɔɔ ‑a ‑gɛn ‑yö ‑gban ‑sü 'ka ‑guö ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Kɛɛ mɛ 'oo mɛ 'ö 'wun 'ka 'go ‑na ‑a ma ꞊dhia ꞊nɛ, ꞊yaa‑ ma 'ö yaa‑ 'kun ‑a 'kun ‑kɔ ‑së 'ka, ‑yö ‑dho bhɔ mɛ do 'ö 'yaa 'wun ‑bho 'kou dɔ 'ö ö ‑bha 'kɔ dɔ 'yënng 'gü ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","'Yö dha ‑nu ‑wo ‑ban, 'ö 'yiga ‑nu ‑wo pa, 'ö 'tëë ‑nu ‑wo ‑ziö 'gbee‑ 'ka 'kɔ bhë ‑a ‑bha, 'yö ‑lo. 'Ö 'kɔ 'ö 'dhö bhë, 'ö‑ ꞊siö' 'töüdhö.» ");
INSERT INTO dnj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","꞊Dhɛ 'ö Yesu ꞊ya yën 'wun ‑nu 'wo ꞊nɛ ‑an ꞊blɛɛ'‑ ‑sü ‑bha, mɛ gbung ‑nu 'wo ‑kë mü bhë, 'tetundhe ꞊va ‑yö ‑da ‑an 'gü, ‑a ‑bha mɛ ꞊daan' ‑kɔ ꞊suu'‑ bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bhii 'ö tɔɔ yaa kë ꞊nɛ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu ‑bha mɛ ꞊daan' ‑kɔ 'dhö, 'kɛɛ ‑yö mɛ ‑nu ‑daan ‑wogbiindhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","꞊Dhɛ Yesu ꞊ya 'go ‑tɔn tuö, mɛ ‑gbaa ꞊va ‑wo ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","'Ö ꞊wee ꞊yuamɛ do ‑yö ꞊yɔɔn ‑a ‑bha, 'ö ‑lo ö kpɔn 'gü ‑a 'dhiö 'ö‑ pö ‑a ‑dhë: «N ‑Gɔmɛ, 'ö ꞊ya kë ꞊nɛ ꞊ya dhi ü ‑dhë, ‑bhö n ‑dhɛ bo!» ");
INSERT INTO dnj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Ö Yesu ‑yö ö ‑kɔ pa ‑a 'ka, 'ö‑ pö: «‑Yö ‑dhi n ‑dhë; ü ‑dhɛ ‑yö bo!» ‑Dhɛ do bhë 'wo to ‑a ‑bha, 'ö‑ ‑bha ꞊wee ꞊yua' ‑yö go ‑a ‑bha, 'ö‑ bun ‑kë 'slööslö. ");
INSERT INTO dnj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑ya ‑pö ‑a ‑dhë: «‑Bhö ü 'to 'to ‑së 'ka, 'wun 'ö bhë kö ꞊kun 'ü‑ ꞊blɛɛ mɛ gbɛ ‑dhë! ‑Bhö 'dho 'ü ü ‑de ‑zɔn ‑Zlan ‑bha slabhomɛ ‑dhë, ‑kɔ 'ü‑ 'ka zlöö bhë ‑a ‑zɔn ‑sü 'ka! 'Go mü, 'ü sla‑ bho ꞊nɛ ‑kɔ 'ö Moizö ‑ya ‑zɔn ‑a 'ka ‑a 'dhö, kö ‑yaan ‑zɔn mɛ 'plɛ ‑dhë ꞊nɛ ü ‑dhɛ ꞊ya bo!» ");
INSERT INTO dnj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu ‑yö ‑kë ‑da ꞊dhia Kapɛɛnaɔmë plöö, 'ö Wlɔmë 'dhasi ꞊këng' do ‑gɔmɛ do ‑yö ‑yɔɔn ‑a ‑bha, ‑a ‑dhɛ ‑a ‑gɔ ‑sü 'ka kö ‑yö nu ö ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","'Ö‑ pö: «N ‑Gɔmɛ, n bha yuökëmɛ ‑yö wɔ ‑sü 'ka kɔɔ, 'tinng ꞊yua' ꞊yaa‑ 'kun, 'ö‑ 'yënng 'dhö bhɔ ‑na ꞊gbaɔnsü.» ");
INSERT INTO dnj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","'Ö Yesu ‑ya pö ‑a ‑dhë: «A ‑dho ‑lo ü ‑gɔ kɔɔ kö 'a‑ 'dhɛ bo.» ");
INSERT INTO dnj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","'Kɛɛ 'dhasi ꞊këng' do ꞊kɔɔnmɛ 'ö bhë ‑ya ‑pö ‑a ‑dhë: «N ‑Gɔmɛ, yaa n ‑ma 'kun kö 'ü ‑da n ‑gɔ kɔɔ, 'kɛɛ ‑bhö ü ‑wo dosɛn 'kpaan pö, ma yuökëmɛ bhë ‑a ‑dhɛ ‑dho bo. ");
INSERT INTO dnj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ma gia‑, n ꞊kɔɔnmɛ ‑nu ‑wo ‑dhö, 'ö 'a 'dhasi 'bhaa ‑nu ꞊kɔɔn 'pö. ꞊Ya kë ꞊nɛ 'ma‑ pö mɛ do ‑dhë ‑yö 'dho, 'yö dho n ‑wo 'ka; 'ö 'ma‑ pö ‑a 'bhaa ‑dhë ‑yö nu, 'ö nu n ‑wo 'ka, 'ö 'ma‑ pö ma yuökëmɛ ‑dhë: ‹‑Bhö pë 'ö ꞊nɛ ‑a kë!› 'Ö‑ kë n ‑wo 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","꞊Dhɛ 'ö Yesu ꞊yaa‑ ‑wo 'ö bhë ‑a ma, 'ö‑ ‑ga ‑kpɛ 'ka, 'yö‑ pö mɛ ‑nu 'wo ‑kë ‑a 'piö bhë ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka, ‑zoyösü ꞊suu'‑ 'ö ꞊nɛ, n 'ka‑ yö Izlaɛlö ‑sɛ 'gü do. ");
INSERT INTO dnj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A‑ ‑pö ka ‑dhë ꞊nɛɛ: Mɛdhɛvadhɛ ‑wo ‑dho go lan‑ bhɔ ꞊zian', 'wo go lan‑ ‑püö ꞊zian', 'ö 'wo ‑yadhɛ sü Ablaamö 'dhö, Izaakö 'dhö, 'ö Zakɔbö 'dhö ‑an 'piö ‑Zlan ‑bha ‑gludëdhɛ 'gü dhang‑ ‑nu 'gü, 'wo pë ‑nu ‑bhö wo 'ko ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","'Kɛɛ mɛ ‑nu 'wo dho kë ‑Zlan ‑bha ‑gludëdhɛ ‑pö ‑bha 'ka ‑bezë, 'ö waa kë ‑a 'ka gbɔ bhë, ‑wo ‑dho ‑an ‑zuö plaan ‑dhɛtiidhɛ 'gü, 'ö ‑dhɛ bhë ‑a 'gü 'wo 'gbo ‑nu bɔ, 'wo wo 'sɔn ‑nu ‑bhö ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö 'dhasi ꞊këng' do ꞊kɔɔnmɛ bhë ‑a ‑dhë: «‑Bhö 'dho ü ‑gɔ kɔɔ, ‑yö ‑dho kë ü ‑dhë ꞊nɛ ‑kɔ 'ü ü ‑zo yöë bhë ‑a 'dhö!» 'Ö 'dhasi ꞊këng' do ꞊kɔɔnmɛ 'ö bhë 'ö‑ ‑bha yuökëmɛ ‑dhɛ ‑yö bo 'töng gia‑ bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu ‑yö ‑dho Piɛɛ ‑gɔ kɔɔ; 'yö Piɛɛ ꞊da yö kö ‑yö ꞊waannu ꞊süë', 'ö tɔɔ 'gii‑ ‑kɔ ‑yö ‑kë ‑a kwi ꞊löö. ");
INSERT INTO dnj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","'Ö Yesu ‑yö pa ‑a ‑kɔ 'ka, 'ö to mü 'ö‑ ‑bha 'yua ‑yö bo 'ö ꞊luu 'ö yö ‑bhöpë ‑kë ‑an ‑dhë ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","꞊Dhɛ 'ö 'yinia ‑dhɛ ꞊ya dɔ, 'ö mɛ ‑nu ‑wo nu, mɛ 'ö ‑zuu yaa ‑yö ‑kë ‑an 'gü ꞊plëëzë 'ka bhë ‑an 'ka Yesu 'piö. 'Yö ‑zuu yaa ‑nu 'wo bhë, Yesu ‑yö ‑an ‑kë mɛ ‑nu 'wo bhë ‑an 'gü ö ‑wo 'ka; 'ö 'yuamɛ ‑nu 'wo ‑kë mü 'töüdhö, 'yö ‑an 'plɛ ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","‑Ya ‑kë 'dhö, kö pë 'ö ‑Zlan ‑wodhiölomɛ Ezai ‑ya ꞊blɛɛ bhë, ‑a 'dhiö ‑yaan ‑mɔ 'kuë. ‑Ya ‑pö: ‑Yö yi 'tɔ ‑siö ‑dhɛ ‑nu ‑bho yi ‑bha, 'ö yi ‑bha 'yua ‑nu bho yi 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","꞊Dhɛ 'ö Yesu ‑yö mɛ gbung ‑nu 'wo ‑kë ‑a ‑zü bhë ‑an yö, 'yö‑ pö ö ‑bha ꞊guë' ‑nu ‑dhë kö ‑wo bɔ 'yi 'kpong gbɛ 'dhiö ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","꞊Dhɛ 'ö ꞊ya kë 'dhö, 'ö Zuifö ‑nu ‑bha tɔnggɔmɛ do ‑yö ꞊yɔɔn ‑a ‑bha 'ö‑ pö ‑a ‑dhë: «N ‑Gɔmɛ, ‑dhɛ 'saadhö 'ü dhö dho ‑a ‑bha, a ‑dho ziö ü 'piö.» ");
INSERT INTO dnj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «Diɔng ‑nu ‑wɔ ‑a 'gü ‑du ‑yö ‑dhö, 'ö ‑ma ‑nu ‑wɔ ‑a 'gü ‑kɔ 'dhö ‑dhö, 'kɛɛ ‑dhɛ 'ö dho kë ma Mɛgbö n wɔ ‑dhɛ 'ka, kö 'aan‑ n 'tɛɛ pa ‑a ‑bha 'yaa ‑dhö.» ");
INSERT INTO dnj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","'Ö‑ ‑bha ꞊guë' ‑nu mɛ do ‑ya pö ‑a ‑dhë: «N ‑Gɔmɛ, ‑bhö 'we ‑a ‑bha 'dhiö n ‑gɔ, kö 'a 'dho n dë ‑bin ꞊dhia. 'Ma 'go mü kö 'a nu 'a ziö ü 'piö.» ");
INSERT INTO dnj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «‑Bhö ziö n 'piö 'ü ü ꞊kwaa' gamɛ ‑nu ‑zü, ‑wo wo 'ko ‑bin 'sa!» ");
INSERT INTO dnj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","꞊Dhɛ ‑kë 'dhö, Yesu ‑yö ‑da 'yitagɔ do 'gü, 'ö‑ ‑bha ꞊guë' ‑nu ‑wo ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","'Kan 'wo‑ wo wo ‑ta ꞊nɛ, 'ö 'buu 'gbee‑ ‑yö yö ziö ‑sü 'gü, 'yipuë ꞊va bhë ‑a ‑ta kö 'yi ‑yö ‑ma ‑na 'yitagɔ bhë ‑a ‑bha 'gbee‑ 'ka, kö 'yi kpö ‑nu ‑wo ꞊luu' ‑na ‑dhɛ 'saadhö 'gü, kö 'yi ‑yö ‑lo ‑na 'yitagɔ 'ö bhë ‑a 'gü. Yesu 'pö, ‑yö ‑kë yi zë ‑dhiadhö. ");
INSERT INTO dnj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo ꞊yɔɔn ‑a ‑bha, 'wo pa ‑a ‑bha, 'wo‑ pö ‑a ‑dhë: «Yi Dëmɛ, ‑bhö kwa dha, kwa 'dhoë‑ ga!» ");
INSERT INTO dnj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Më 'ö ‑kë 'ka ‑suö ꞊duö 'dhö e? Kë 'ö ka ‑bha ‑zo ‑yö ‑Zlan ‑bha ‑sü ‑ya wo 'tee bhë, ‑yö ya ꞊dhɛɛ!» ꞊Dhɛ ꞊ya kë 'dhö, 'yö ꞊luu 'yö 'wun ꞊blɛɛ 'gbee‑ 'ka 'buu waa‑ 'yi kpö ‑nu ꞊va bhë ‑an 'ka, 'ö ‑dhɛ ‑ga diin ꞊va ‑yö ‑kë ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Ö 'tetundhe ‑yö ‑da ‑an 'plɛ 'gü, 'ö 'wo‑ pö: «Mɛ ꞊suu'‑ ‑mlë 'ö ꞊nɛ 'ö 'buu ‑nu, 'yi kpö ‑nu ‑de gia‑, ‑wo 'wun ma ‑a ‑ta ꞊nɛɛ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","꞊Dhɛ 'ö Yesu ꞊ya ‑lo Galile 'yipuë bhë ‑a zlöö, Gadaleni ‑sɛ 'gü ꞊zian', 'ö gɔɔn‑ ‑nu ꞊plɛ ‑wo ‑go blɔɔn‑ ꞊taa ꞊zian', 'wo nu ‑a ‑gɔ zian‑. Mɛ ꞊plɛ 'wo bhë ‑zuu yaa ‑nu ‑wo ‑kë ‑an 'gü; 'ö‑ ‑wun 'gü ‑wo ‑kë ‑suö ‑an ‑dhë ꞊dhia zian bhë ‑a ‑ta; ‑dhɛ 'to ‑na zlöö, kö bɔ ‑dhɔ 'yaa mɛ gbɛ kë ‑na zian ‑gblooga 'ö bhë ‑a 'ka gbɔ; ");
INSERT INTO dnj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","'wo yö ꞊gblaa 'gbla ‑sü 'gü 'wo‑ pö: «‑Më 'ü 'dhoë‑ kë yi 'ka bhë ꞊ɛ, ‑Zlan Gbö, ü ‑nu zö kö 'üën‑ yi 'klo bhɔ ‑a 'töng 'yö dho kaa bhë ‑a 'dhiö a?» ");
INSERT INTO dnj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","‑Bhɔtii ‑gbaa ꞊va ‑wo ‑kë wo ‑bha ‑bhöpë ꞊mɛɛ' ꞊dhia ‑an 'ka ꞊gbiin 'dɛdɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","꞊Dhɛ ‑ya ‑kë 'dhö, 'ö ‑zuu yaa ‑nu 'wo bhë ‑wo ꞊bhɛa Yesu ‑dhë 'wo‑ pö: «꞊Ya kë ꞊nɛ ü ‑dho yi kë, kö ‑bhö yi bɔ ‑bhɔtii ‑nu 'wo ꞊nɛ ‑an 'gü!» ");
INSERT INTO dnj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka 'dho!» 'Ö ‑zuu yaa ‑nu ‑wo go gɔɔn‑ ‑nu ꞊plɛ 'wo bhë ‑an 'gü, 'wo dho ‑bhɔtii ‑nu 'wo bhë ‑an 'gü. 'Ö to mü, ‑bhɔtii ‑nu 'wo bhë 'ö ‑an ‑blazë, ‑wo ꞊yɔɔ goo ‑bha, 'ö 'wo nu 'wo ‑püö 'yipuë bhë ‑a ꞊bhaa 'töüdhö, 'ö ‑an 'plɛ 'gü ‑yö ‑siö yiö. ");
INSERT INTO dnj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","'Ö gɔɔn‑ ‑nu 'wo ‑kë ‑bhɔtii ‑maakëmɛ ‑nu 'ka bhë, 'wo ꞊duë 'wo dho plöö, 'ö pë ‑nu 'wo kë 'saadhö waa‑ 'wun 'ö ‑gban gɔɔn‑ ‑nu ꞊plɛ 'ö ‑zuu yaa ‑nu ‑wo ‑kë ‑an 'gü ‑be ‑a ‑bha bhë, 'wo‑ ꞊blɛɛ mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","꞊Dhɛ ꞊ya kë 'dhö, 'ö mɛ ‑nu 'töüdhö 'wo go pö‑ bhë ‑a 'gü, 'wo yö plaan, 'wo dho Yesu ‑gɔ zian‑. ꞊Dhɛ 'ö 'wo‑ yö, 'wo ꞊bhɛa ‑a ‑dhë kö ‑yaan 'go wo ‑bha 'sɛgɔ bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu ‑yö ‑da 'yitagɔ 'gü, 'yö 'yipuë ꞊va bhë 'yö‑ ‑kan 'zü, 'yö nu ö ‑gɔ plöö. ");
INSERT INTO dnj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Ö mɛ ‑nu ‑wo nu 'tinngmɛ do 'ö ‑kë wɔ ‑sü 'ka ꞊sɛɛ' ‑ta ‑a 'ka ‑a ꞊dhia. ꞊Dhɛ 'ö Yesu ꞊ya gɔɔn‑ ‑nu 'wo bhë ‑an ‑bha ‑zo ‑yö ö ‑bha ‑sü yö, 'yö‑ pö 'tinngmɛ bhë ‑a ‑dhë: «Ma 'në, ü 'gü dɔ ü ‑de ‑gɔ 'gbee‑, 'ma ziö ü bha ꞊sɔɔn yaa ‑nu ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","꞊N 'n, ꞊dhɛ ‑kë 'dhö, 'ö Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu mɛ 'bhaa ‑nu ‑wo yö ‑a pö ‑sü 'gü wo ꞊zuö' 'piö ꞊nɛɛ: «'Ö, gɔɔn‑ bhë ꞊ya ꞊daɔn pö ‑Zlan ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu ‑yö ‑an ‑bha ‑zo ‑ta ‑a 'gü ‑wun ‑dɔ. ꞊Dhɛ ‑kë 'dhö, 'yö‑ pö ‑an ‑dhë: «‑Më ‑kë 'ö ‑zotadhe yaa ꞊suu'‑ ‑nu 'wo ꞊nɛ 'wo ‑kë ka 'gü i? ");
INSERT INTO dnj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‑A pö ‑sü ‹ü bha ꞊sɔɔn yaa ‑nu ‑wun ꞊ya yën› 'pö 'pëëpë, 'iin ‑a pö ‑sü ‹‑bhö ꞊luu'‑ 'ü 'ta 'sü› bhë yö 'pö 'ö 'pëëpë e? ");
INSERT INTO dnj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","'Kɛɛ a‑ 'piö kö 'ka‑ dɔa ꞊nɛ, ‑kɔ ‑mɔ 'wuën‑ ‑sü ‑yö ma, Mɛgbö, n ‑gɔ 'kpongtaa zö kö 'a ziö mɛ ‑nu ‑bha ꞊sɔɔn yaa ‑nu ‑ta.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö 'tinngmɛ bhë ‑a ‑dhë: «‑Bhö ꞊luu'‑ 'ü ü ‑bha ꞊sɛɛ' 'sü 'ü 'dho ü ‑gɔ kɔɔ!» ");
INSERT INTO dnj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'Ö gɔɔn‑ 'ö bhë 'ö ꞊luu, ('ö ö ‑bha ꞊sɛɛ' sü,) 'ö dho ö ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","꞊Dhɛ 'ö mɛ gbung ‑nu 'wo ‑kë mü ꞊wa pë ‑nu 'wo ꞊nɛ ‑an yö, 'suö ‑yö ‑da ‑an 'gü, 'wo yö ‑Zlan 'tɔ ‑blü ‑sü ‑bha, ‑kɔ ‑mɔ 'wun ‑bha ‑sü ꞊suu'‑ 'ö‑ nu mɛ 'bhee‑ ‑nu ‑dhë 'dhö bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ‑yö ‑go ‑dhɛ bhë ‑a ‑bha. 'Ö‑ ‑bha ziö ‑sü 'ka, kö ꞊ya ö 'bhle 'tee ꞊yɔɔn 'dhiö, ‑yö ‑kpën gɔɔn‑ do 'wo‑ ‑dhɛ Matiö ‑a ‑bha kö ‑yö ‑ya ‑sü 'ka 'nii‑ ꞊sɔnng' ‑bho ‑a 'gü ‑kɔ 'gü, 'yö‑ pö ‑a ‑dhë: «‑Bhö ziö n 'piö!» 'ö Matiö ‑yö ꞊luu 'yö ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesu waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑kë pë ‑bhö ‑sü 'gü Matiö ‑gɔ kɔɔ. 'Nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu ꞊plëëzë waa‑ mɛ ‑nu 'ö ‑an 'tɔ 'gü ꞊ya ꞊siö' ‑an këpë yaa ‑nu ‑wun 'gü, ‑wo ‑kë ‑an 'piö mü pë ‑bhö ꞊dhia 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","꞊Dhɛ 'ö Falizi ‑mɛ ‑nu ‑wo 'wun 'ö bhë ‑a yö, 'yö 'wo‑ pö Yesu ‑bha ꞊guë' ‑nu ‑dhë: «‑Më 'ö ‑kë 'ö ka ‑gɔmɛ waa‑ 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu waa‑ mɛ ‑nu 'ö ‑an 'tɔ 'gü ꞊ya ꞊siö'‑ ‑an këpë yaa ‑nu ‑wun 'gü, 'wo pë ‑bhö ‑na wo 'ko ꞊bhaa bhë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ‑yö ‑an ‑wo ‑ma; 'yö‑ pö ‑an ‑dhë: «Mɛ ‑nu 'ö 'yua 'yaa ‑an ‑bha bhë, ‑an ‑bha ‑wun 'yaa ꞊dhɔngtrɔ ‑bha; 'kɛɛ mɛ ‑nu 'ö 'yua 'dho ‑an ‑bha ꞊nɛ 'wo nu ꞊dhɔngtrɔ 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‑Wo kpö 'në 'bhaa ‑yö ‑ya ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü. ‑Ka 'dho 'ka‑ pö, 'ka ka ‑zo 'ta ‑a ‑gɛn ‑wun 'gü kö 'kaan‑ ‑a dɔ. ‑Wo bhë ‑ya pö: Mɛ 'yena yö ‑sü 'ö tɔɔ pë 'ö‑ ‑dhɔ ‑yö n ‑kë. 'Kɛɛ 'maa slapë ‑nu 'piö. » 'Ö Yesu ‑ya pö 'zü: «Bhii n 'ka nu mɛ ‑nu 'wo kpengdhö ‑an ‑dhɛ ꞊dhia, 'kɛɛ mɛ ‑nu 'ö 'wo ꞊sɔɔnyaamɛ ‑nu 'ka ꞊zian' 'yö 'a nu ‑an ‑dhɛ.» ");
INSERT INTO dnj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Zan Batisö ‑bha ꞊guë' ‑nu ‑wo ‑yɔɔn Yesu ‑bha, 'wo‑ ꞊dhɛɛ' kpɔ ‑a pö ‑sü 'ka ꞊nɛɛ: «‑Më 'ö ‑kë 'ö yië‑ Falizi ‑mɛ ‑nu 'yi yi ‑bɛn to ‑kplawo, 'ö ü ‑bha ꞊guë' ‑nu 'waa‑ kë ꞊nɛ ‑kɔ bhë ‑a 'dhö 'pö e?» ");
INSERT INTO dnj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Mɛ ‑nu 'wo ‑an ꞊dhɔɔ ‑kë, dhe 'sü 'wlaan‑ ‑ta, ‑an wö 'ka 'dho ‑siö kö dhe 'sü ‑gɔɔn ‑yö ꞊tun ‑an 'piö. 'Kɛɛ 'töng ‑dho nu kö ‑waan dhe 'sü ‑gɔɔn 'sü ‑an ‑gɔ; 'töng 'ö 'dhö bhë 'wo dho wo ‑bɛn to ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mɛ gbɛ 'yaa sɔ 'klu ‑dëü ꞊nëng sɔ 'klu zii ‑bha ‑yaan ‑an ‑wɔ. ꞊Ya kë 'dhö, sɔ 'klu ‑dëüzë ‑yö ‑dho dho 'kou, 'ö ziizë ‑gan, 'ö 'blë ‑dhɛ ‑yö ‑kë 'zü ꞊va. ");
INSERT INTO dnj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","'Go mü 'zü, yɔ 'ö 'vuu dho ‑da ‑na, 'waa‑ yö 'pö ꞊puu' zii 'gü. ꞊Ya kë 'dhö 'puu bhë ‑yö ‑wü, 'ö yɔ ‑yö 'daawo. 'Ö kö pë 'plɛ 'gü ꞊ya ꞊siö'‑. Pë 'wo‑ ‑kë 'ö tɔɔ yɔ ‑dëü yö 'wo‑ wo ꞊puu' ‑dëü 'gü, 'ö ‑an 'plɛ ‑wo to ‑së 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ‑yö ‑to 'wun ‑blɛɛ ‑an ‑dhë ‑sü 'gü, 'ö Zuifö ‑nu ꞊kɔɔnmɛ do ‑yö ‑nu 'yö ‑lo ö kpɔn 'gü Yesu 'dhiö, 'ö‑ pö ‑a ‑dhë: «N 'dhu 'gü ꞊ya ꞊siö' 'piöklöözë ꞊nɛ, 'kɛɛ ‑bhö nu 'ü ü ‑kɔ kpa ‑a ‑ta kö ‑yö ‑büö.» ");
INSERT INTO dnj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu ‑yö ꞊luu 'ö waa‑ ö bha ꞊guë' ‑nu 'wo ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Dhebɔ do 'ö fɛi yën ꞊yua' ‑yö ‑kë ‑a 'yënng bhɔ ꞊dhia ‑kwɛ 'gɔɔ‑ do ö ga ꞊plɛ 'piö bhë ‑yö ‑yɔɔn Yesu ‑bha, ‑bɔ ‑a ꞊zlöö ‑sü 'ka, 'yö pa ‑a ‑bha sɔ 'to 'dhiö 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bhii ‑ya ‑pö ö ‑de 'gü ꞊nɛɛ: «'Ma n 'gü dɔ 'gbee‑ ꞊sia 'ma 'pa ‑a ‑bha sɔ 'to 'dhiö 'kpaan ‑de 'ka, n ‑dhɛ dho bo.» ");
INSERT INTO dnj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu ‑yö ‑dhië ö ‑zü, 'ö‑ yö, 'ö‑ pö ‑a ‑dhë: «Ü 'gü dɔ 'gbee‑, n 'dhu! Ü ‑bha ‑zo yö ‑sü ꞊ya ü ‑dhɛ bo.» 'Ö ‑dhɛ do bhë ‑a 'gü 'ö‑ ‑dhɛ ‑yö bo. ");
INSERT INTO dnj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu ‑yö ‑lo Zuifö ‑nu ꞊kɔɔnmɛ do bhë ‑a ‑gɔ kɔɔ. ꞊Dhɛ 'ö ꞊ya ‑kpën 'truupiömɛ ‑nu waa‑ mɛ ‑nu gbung 'wo ‑kë 'gbo bɔ ꞊dhia wo ‑de ꞊maa 'ma ‑sü 'ka bhë ‑an ‑bha, ");
INSERT INTO dnj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","'yö‑ pö ‑an ‑dhë: «‑Ka 'go zö 'ka yö plaan, bhii 'nëdhezë bhë yaa ga, yi 'ö‑ zë ‑na bhë.» 'Ö 'wo yö wo ‑wo ‑lo ‑a 'ka ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","꞊Dhɛ ꞊waa‑ pö mɛ gbung 'ö bhë ‑an ‑dhë ‑wo 'dho plaan, 'ö ꞊wa yö plaan, 'ö Yesu ‑yö ‑da kɔɔ mü, 'yö ‑ya 'nëdhezë 'ö bhë ‑a ‑kɔ ‑bha; 'ö ꞊dhɛ ꞊ya ‑büö, 'ö ꞊luu. ");
INSERT INTO dnj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","'Ö 'wun bhë 'ö‑ ‑taɔ ‑yö ‑pɛn 'sɛgɔ 'pian 'ö bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ‑yö ‑go ‑dhɛ bhë ‑a 'gü. ‑Yö ‑kë bɔ ꞊dhia ‑dhɛ 'bhaa ‑bha, 'ö 'yënngtiimɛ ꞊plɛ ‑wo yö ‑ziö ‑a 'piö ‑sü ‑bha ꞊gblaa 'gbla ‑sü 'ka ꞊nɛɛ: «‑Bhö yi 'yena yö e, Davidö gbö!» ");
INSERT INTO dnj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","꞊Dhɛ 'ö Yesu ꞊ya ‑lo kɔɔ, 'ö 'yënngtiimɛ ꞊plɛ 'wo bhë 'wo ꞊yɔɔn ‑a ‑bha 'zü; 'ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «Ka‑ ‑dhɛ 'wun gia‑ ꞊nɛ, a ‑mɔ ‑a ‑bha kö 'aan‑ ka ‑dhɛ bo ꞊a?» 'Ö 'wo‑ ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «꞊Ii dhö, yi ü ‑wun ‑dhɛ 'wun gia‑, yi ‑Gɔmɛ.» ");
INSERT INTO dnj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö ö ‑kɔ yö ‑an wö ‑bha ‑a pö ‑sü 'ka ꞊nɛɛ: «Kö ‑yö kë ka ‑dhë ꞊nɛ ‑kɔ 'ö 'ka ka ‑zo yöë n ‑ma bhë ‑a 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'Ö ‑an 'yan ‑yö ‑dhɛ yö. 'Ö Yesu ‑ya pö ‑an ‑dhë, ‑gbaɔn ‑a ‑ta dhuö ‑sü 'ka ꞊nɛɛ: «‑Ka ka 'to 'to ‑së 'ka, 'wun 'ö ꞊nɛ kö ꞊kun 'ka‑ ꞊blɛɛ mɛ gbɛ ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'Kɛɛ ‑wo ‑dho, 'ö 'wo Yesu ‑wun ꞊blɛɛ 'sɛgɔ 'pian 'ö zian bhë ‑a 'ka bhë ‑a ‑ta, ‑dhɛ 'saadhö 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yesu ‑yö ‑kë 'dho ꞊dhia, 'ö 'wo nu gɔɔn‑ do 'ö 'tuunmɛ 'ka ‑a ꞊dhia; pë ‑kë 'ö ‑kë 'dhö bhë 'ö tɔɔ ‑zuu yaa ‑yö ‑kë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","꞊Dhɛ ‑zuu yaa bhë 'ö Yesu ꞊yaa‑ kë, ꞊ya 'go ‑a 'gü, 'ö 'tuunmɛ bhë 'yö yö 'wun ꞊blɛɛ'‑ ‑sü ‑bha. 'Tetundhe ‑yö ‑da mɛ ‑gbaa ꞊va 'wo ‑kë mü bhë ‑an 'gü, 'ö 'wo‑ pö: «Kwaa pë 'ö ꞊suu'‑ 'dhö ꞊nɛ ‑a yö Izlaɛlö ‑sɛ ꞊nɛ ‑a 'gü do!» ");
INSERT INTO dnj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'Kɛɛ Falizi ‑mɛ ‑nu ‑zë ‑wa ‑pö: «‑Zuu yaa ‑nu ‑gɔmɛ ꞊nɛ 'ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu Yesu ‑dhë, 'yö ‑zuu yaa ‑nu 'wo bhë 'yö ‑an kë ‑na ‑a 'ka bhë.» ");
INSERT INTO dnj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu ‑yö ‑bɔ 'kwi ‑pö ‑nu waa‑ pödhɛ ‑nu 'gü, 'yö mɛ ‑nu ꞊daan Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑nu 'gü, 'wuntaɔsë 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑bha ‑a ꞊blɛɛ'‑ ‑sü 'ka, kö ‑yö 'yuamɛ 'saadhö waa‑ 'tɔsiömɛ ‑nu ‑an ‑dhɛ bo ‑na. ");
INSERT INTO dnj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","'Ö mɛ ‑gbaa ‑nu 'wo ‑kë ‑a 'piö bhë, ‑an 'yena ꞊va ‑yö ‑da ‑a 'gü, bhii 'ö tɔɔ ‑an 'gü ꞊ya ga. 'Go mü ꞊faan' 'yaa ‑an 'gü gbɔ, 'ö ꞊wa kë ꞊nɛ 'bhla ‑nu 'ö ‑an ‑maakëmɛ 'yaa 'dhö 'ö ꞊wa ‑pɛn ‑an 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","‑A ‑wun 'gü 'ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «‑Mlü ꞊ya ga ꞊va 'kɛɛ yuökëmɛ ‑nu 'waa ꞊va; ");
INSERT INTO dnj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","kö ‑ka ꞊bhɛa' bhlö‑ dëmɛ ‑dhë kö ‑yö yuökëmɛ ‑nu 'bhaa bɔ kö ‑waan ‑a ‑bha ‑mlü ‑nu 'kan!» ");
INSERT INTO dnj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu ‑yö ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an ꞊dhɔɔ ‑kë, 'yö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu ‑an ‑dhë kö ‑waan ‑zuu yaa ‑nu bho ‑a 'ka mɛ ‑nu 'gü, ‑waan 'yuamɛ ‑nu 'saadhö waa‑ ꞊niɔɔmɛ ‑nu ‑an ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesu ‑bha bɔmɛ 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an 'tɔ 'ö ꞊nɛ: Mɛ ‑blɛɛzë 'ö tɔɔ Simɔ 'wo‑ 'tɔ kpɔ Piɛɛ 'ka, waa‑ ö dheglu Andre; Zakö waa‑ ö dheglu Zan, 'wo ‑kë Zebede gbö ‑nu 'ka; ");
INSERT INTO dnj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipö, Baatelemi, Toma, Matiö 'yö ‑kë 'nii‑ ꞊sɔnng' 'kun ‑mɛ 'ka ‑be; Zakö 'ö ‑kë Alefe gbö 'ka; Taade, ");
INSERT INTO dnj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simɔ 'yö ‑kë 'yënngsiömɛ 'ka ö ‑bha 'sɛgɔ ‑wun 'gü, Zuda Ikaliɔtö 'ö dho zlöö 'ö Yesu dɔ ö yaagümɛ ‑nu kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu ‑yö ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an ‑bɔ, ‑a ‑pö ‑an ‑dhë ‑sü 'ka ꞊nɛɛ: «Kö ꞊kun 'ka dho 'sɛgɔ 'ö mɛ ‑nu 'wo‑ 'gü, 'waa Zuifö 'ka bhë ‑an 'gü, 'iin kö ꞊kun 'ka ‑da Samali ‑mɛ ‑nu ‑gɔ pödhɛ ‑nu 'gü! ");
INSERT INTO dnj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","‑Ka 'dho ꞊zian' 'bhla ‑tuë ‑nu 'wo ꞊dhɔng' ‑sü 'ka Izlaɛlö ‑sɛ 'gü ‑an 'piö! ");
INSERT INTO dnj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ka ‑bha 'ta 'ö bhë ‑a 'gü, ‑ka ‑Zlan ‑wo ꞊blɛɛ'‑ ‑a pö ‑sü 'ka ꞊nɛɛ: ‹‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ ‑nu 'gü bhë, ‑a 'töng ꞊ya yö ꞊klöö'.› ");
INSERT INTO dnj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","‑Ka 'yuamɛ ‑nu ‑dhɛ bo, 'ka mɛ ‑nu bho ga 'gü, ‑ka ꞊wee ꞊yuamɛ ‑nu ‑dhɛ bo, 'ka ‑zuu yaa ‑nu bho mɛ ‑nu 'gü! 'Piigbeedhɛ 'ö ‑Zlan ‑ya nu ka ‑dhë kö pë ‑nu 'wo bhë 'ka ‑an kë ‑a 'ka bhë, ‑ya gbaɔ ka ‑gɔ 'kpaan. Ka ‑de 'pö, ‑ka 'wunsë ‑nu 'wo bhë ‑an kë mɛ ‑nu ‑dhë 'kpaan. ");
INSERT INTO dnj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kö ꞊kun 'ka 'wëü‑ 'dhɛ ‑nu, 'iin 'wëü‑ 'sɛɛn‑ ‑nu ‑an gbɛ sü ka ‑kɔ 'piö! ");
INSERT INTO dnj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","'Go mü, kö ꞊kun 'ka pë ‑da ‑a 'gü ‑pë 'wo dho ‑a 'ka 'ta ‑nu 'gü ‑nu, 'bhɛi kë ꞊plɛ ‑naa ‑nu, ‑yö ‑gɛan ‑sakpa ‑nu, 'iin 'lünë gbɛ ‑nu sü ka ‑kɔ 'piö! 'Kɛɛ kë‑ wo 'dhö bhë, yuökëmɛ ꞊dua' ‑mü kö pë 'ö‑ ‑bha ‑wun 'dhö ‑a ‑bha ‑a nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","꞊Ya kë ꞊nɛ 'ka ‑da 'kwi ‑pö 'iin pödhɛ ‑nu 'gü, ‑ka mɛ 'ö ‑dhɔ ꞊kaa', kö ‑yaan ka ‑nia 'kun ‑a ꞊mɛɛ', kö 'ka 'dho ‑a ‑gɔ kɔɔ; ‑ka 'to mü, ‑yö 'dho ‑yö yöë ka ‑bha ‑go pödhɛ bhë ‑a 'gü ‑yi ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Kɔ 'saadhö 'ka dho ‑da ‑a 'gü, ‑ka ‑a pö ‑a 'gü ‑mɛ ‑nu ‑dhë: ‹꞊Zuöyagluu ‑yö kë ka ‑gɔ!› ");
INSERT INTO dnj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","꞊Ya kë ꞊nɛ 'kɔ bhë ‑a 'gü ‑mɛ ‑nu ꞊wa ka ‑nia 'kun, ka ‑bha ꞊zuöyagluu ‑mɛɛ bhë ‑yö 'to ‑an ‑ta. 'Kɛɛ ꞊ya kë ꞊nɛ waa ka ‑nia 'kun, ka ‑bha ꞊zuöyagluu ‑mɛɛ 'ö bhë ‑ka ‑a 'sü 'ka ziö ka ‑bha pë 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","꞊Ya kë ꞊nɛ 'kɔ 'bhaa 'gü, 'iin 'kwipö 'bhaa 'gü, waa 'we ‑a ‑bha ‑waan ka ‑nia 'kun, 'iin ‑waan wo 'to kë ka ‑wo ‑bha, ‑ka 'go ‑dhɛ bhë ‑a 'gü; 'kɛɛ ‑ka ka ‑gɛn ꞊kpënng ‑yö kë 'dhö kö ‑büö ‑bi 'ö to ka ‑gɛn ‑bha pödhɛ bhë ‑a 'gü bhë ‑yö 'go mü. ");
INSERT INTO dnj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka, ‑Zlan ‑bha zakanyi 'ka, Sodɔmë ‑mɛ ‑nu waa‑ Gomɔɔ ‑mɛ ‑nu, pë 'ö dho kë ‑an 'ka, yö 'ka 'dho kë pë gbɛ 'ka ‑yaan zië pödhɛ 'ö 'dhö bhë ‑a 'gü ‑mɛ ‑nu ‑bha ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","'Yö‑ pö ‑an ‑dhë 'zü: «‑Ka ka 'to 'to, a ka ‑bɔ ꞊nɛ 'bhla ‑nu 'dhö ꞊laa' ‑nu ziën. ‑A ‑wun 'gü, ‑ka kë ‑glengzë, 'ka kë mɛ ‑nu 'ö 'wun yaa 'yaa ‑an 'gü ‑an 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","‑Ka ka ‑zo kë ka ‑de 'piö mɛ ‑nu ‑gɔ, bhii ‑wo ‑dho bɔ ka 'ka za ‑dɔ ‑a 'gü ‑kɔ ‑nu 'gü; 'go mü 'wo dho ka ‑ma ‑klaaga ‑nu 'ka, Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","‑Wo ‑dho dho ka 'ka mɛ ‑gɔ ꞊taa ‑mɛ ‑nu waa‑ ‑gludë ‑nu ‑an 'dhiö n ‑wun 'gü; 'kɛɛ kë‑ wo 'dhö bhë ‑yö ‑kë 'dhö kö 'kaan‑ ka ‑bha ‑tɔmɔdhɛ ‑nu kë ‑an wö 'dhiö 'iin mɛ ‑nu 'waa Zuifö 'ka ‑an wö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Ö ꞊wa ka 'kun ꞊wa 'dho ka 'ka za ‑dɔ ‑a 'gü ‑kɔ ‑nu 'gü, kö ꞊kun 'ka ‑ya pë 'ka dho ‑a ꞊blɛɛ'‑ ‑a ‑wun ꞊zɔnng' ‑ta 'iin ‑kɔ 'ö 'ka dho 'wun ꞊blɛɛ'‑ ‑a 'ka ‑a ‑wun ꞊zɔnng' ‑ta! ‑Wo 'ö 'ka dho ‑a ꞊blɛɛ'‑ ‑an wö 'dhiö, ‑yö ‑dho dɔ ka 'dhi 'töng gia‑ bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","‑Wo ‑nu 'wo bhë waa 'dho go ka 'gü, 'kɛɛ ‑Zuu 'slööslö 'ö go ka Dë ‑Zlan 'piö ꞊nɛ, 'ö dho bɔ ka 'gü ‑yaan ‑an ꞊blɛɛ'‑. ");
INSERT INTO dnj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dhegluzë ‑nu ‑wo ‑dho wo 'ko dɔ mɛ ‑nu kwɛɛ 'wo ‑an zë. ‑Kɔ do bhë ‑a 'ka, 'ö 'në dë ‑nu dho ‑a kaa wo bha 'në ‑nu 'ka 'pö. 'Në ‑nu ‑wo ‑dho dɔ wo mɛ ‑nu ‑gɔ, 'ö 'wo ‑an dɔ mɛ ‑nu kwɛɛ 'wo ‑an zë. ");
INSERT INTO dnj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mɛ ‑nu 'saadhö ‑wo ‑dho ka ‑san zë n ‑wun 'gü, 'kɛɛ mɛ 'ö 'dhoë‑ ö 'gü dɔ 'gbee‑ ‑kplawo ‑yaan 'dho ‑yaan yöë ‑a 'dhiötoyi ‑bha, ‑yö ‑dho dha. ");
INSERT INTO dnj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","꞊Ya kë ꞊nɛ ꞊wa ka 'klo bhɔ 'kwi ‑pö do 'gü, ‑ka ꞊duë 'ka 'dho ‑a gbɛ 'gü, 'ka dhoë 'dhiö ‑kplawo! A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Ka 'ka 'dho yën ‑bɔ Izlaɛlö 'kwipö 'plɛ 'gü ‑sü ‑bha kö ma Mɛgbö 'ma nu. ");
INSERT INTO dnj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","꞊Guë' 'në gbɛ 'yaa ꞊va ö ‑gɔmɛ ‑ta. 'Go mü, yuökëmɛ 'yaa ꞊va ö ꞊kɔɔnmɛ ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pë dho kë 'ö tɔɔ ꞊guë' ‑yö ‑dho kë ꞊nɛ ö ‑gɔmɛ 'dhö, 'ö yuökëmɛ ‑yö ‑kë 'pö ꞊nɛ ö ꞊kɔɔnmɛ 'dhö. ꞊Ya kë ꞊nɛ mɛ ‑nu ꞊wa 'kɔ ꞊kɔɔnmɛ ‑dhɛ Bɛɛzebilö kö ‑wo ‑dho 'tɔ 'ö ‑ziö ‑a mɛ 'ö bhë ‑a ‑ta, ‑a nu ‑a 'piö ‑mɛ ‑nu ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","'Yö Yesu ‑ya pö ‑an ‑dhë 'zü: «'Kɛɛ kö ꞊kun 'ka ‑suö mɛ ‑nu ‑dhë! Bhii 'ö tɔɔ pë 'ö ‑bin ‑sü 'ka 'ö dho kun ‑yö ‑dhɛgbɛadhɛ 'gü ‑sü 'ka 'yaa 'dhö, 'ö 'sloo 'ka ‑wun 'ö mɛ ‑nu dho kun ‑a ꞊tɛi' dɔ ‑sü 'ka 'yaa 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","꞊Dhɛ ‑kë 'dhö bhë, 'wun ‑nu 'a‑ ꞊blɛɛ'‑ ‑na ka ‑dhë ‑bin ‑blü ꞊nɛ, ‑ka ‑a ꞊blɛɛ'‑ ‑dhɛbongdhɛ 'gü, 'iin 'wun ‑nu 'a‑ ꞊blɛɛ'‑ ‑na ka ‑dhë 'sloo 'ka bhë, ‑ka gblaa 'gbee‑ 'ka 'dhëëdhɛ ‑nu ‑bha, ‑a ꞊blɛɛ' ‑sü 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kö ꞊kun 'ka ‑suö mɛ ‑nu 'wo dho ka bun zë, 'ö ‑an ‑kɔ yaa 'dho ‑mɔ ka nii zë ‑sü ‑bha bhë ‑an ‑dhë! ‑Ka 'suö ꞊zian' ‑Zlan 'ö‑ ‑kɔ ‑yö ‑mɔ ka bun waa‑ ka nii ‑an zë ‑sü ‑bha kö ‑yö ‑an ‑zuö ꞊glöötiaandhö 'siö 'gü bhë ‑a ‑dhë! ");
INSERT INTO dnj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kë 'ö‑ wo ꞊nɛ 'waa ꞊zöng' ꞊plɛ 'dhɔɔ dɔ ‑su ga do ‑bha ‑a? ('Ö bhii ‑an ꞊bhlë 'yaa ꞊va); 'kɛɛ kö ‑an do ‑de 'yaa ‑püö sia‑ ‑a 'ke 'ö ka Dë yaa 'we ‑a ‑bha ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","'Kɛɛ ꞊ya kë ka ‑zë ka ‑bha 'ka, ka Dë ‑yö ö ‑zo ‑kë ka 'piö ‑së 'ka, ‑a ‑de ka ‑bha wun ga ‑de gia‑ ‑nu 'wo ka tuö bhë, 'yö ‑an 'plɛ ‑da 'kuë‑ ‑sü dɔ. ");
INSERT INTO dnj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","‑A ‑wun 'gü, kö ꞊kun 'ö 'suö ‑yö ka ‑kë; ka ‑wun ꞊yö 'gbee‑ 'yö ꞊zië' ꞊zöng' ‑nu ꞊plëëzë ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mɛ 'oo mɛ 'ö 'dhoë‑ pö mɛ ‑nu wö 'dhiö ꞊nɛ ‑yö ‑bɔ n 'ka, ma ‑de 'pö, n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bhë ‑a wö 'dhiö, a ‑dho ‑a pö ‑yö n ‑ma 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'Kɛɛ mɛ 'ö 'dhoë‑ pö mɛ ‑nu wö 'dhiö 'yaa n dɔ, ma ‑de 'pö, a ‑dho ‑a pö n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü bhë ‑a wö 'dhiö ꞊nɛ 'maa‑ dɔ 'pö.» ");
INSERT INTO dnj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","'Yö‑ pö: «Kö ꞊kun 'ö ‑kë ka ‑zo 'piö ꞊nɛ a ‑nu dhidhe ‑wun 'ka 'kpongtaamɛ ‑nu ꞊dhia. N 'ka nu ‑dhi 'kuë 'ka, 'kɛɛ ‑siödhe 'a nuë. ");
INSERT INTO dnj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bhii a ‑nu 'gügludhe ‑da ꞊dhia 'në gɔɔn‑ waa‑ ö dë, 'në dhe waa‑ ö dhe, dhe 'në waa‑ ö ꞊da ‑an ziën. ");
INSERT INTO dnj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","‑Siökuëdhe ‑yö ‑dho ‑da 'kɔ do 'gü ‑mɛ ‑nu giagia ziën. ");
INSERT INTO dnj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mɛ 'ö 'dhoë‑ ö dë waa‑ ö dhe ‑an ‑dhɔ kë ‑yaan zië n ‑dhɔ 'ö‑ 'gü ‑a ‑ta kö 'yaa ma mɛ 'ka. Mɛ 'ö 'dhoë‑ ö gbö 'iin ö 'dhu ‑an ‑dhɔ kë ‑yaan zië n ‑ta 'zü kö yaa‑ ‑ma 'kun kö ‑yaan kë ma mɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mɛ 'ö yaa ö ‑bha ‑gaatalü 'sü yaa zië n 'piö kö yaa‑ ‑ma 'kun ‑yaan kë ma mɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mɛ 'ö‑ 'piö kö 'ö ö ‑bha ‑tosiadhe ‑së kë ö ‑de ‑dhë, ‑a 'gü ‑dho ꞊siö' ‑a ‑gɔ; 'kɛɛ mɛ 'ö 'dhoë‑ ö ‑bha ‑tosiadhe 'gü ꞊siö' n ‑wun 'gü, ‑yö ‑dho ‑a yö.» ");
INSERT INTO dnj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","'Yö‑ pö: «Mɛ 'ö 'dhoë‑ ka ‑nia kun, kö ꞊ya n ‑nia 'kun. 'Ö mɛ 'ö 'dhoë‑ n ‑nia kun kö ꞊ya mɛ 'ö n bɔ bhë ‑a ‑nia 'kun. ");
INSERT INTO dnj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mɛ 'ö 'dhoë‑ ‑Zlan ‑wodhiölomɛ ‑nia kun, ‑a ‑bha ‑kë ‑Zlan ‑wodhiölomɛ 'ka ‑sü ‑wun 'gü, 'kian 'ö ‑Zlan dho ‑a nu ö ‑wodhiölomɛ ‑dhë bhë ‑yö ‑dho ‑a nu ‑a ‑dhë 'pö. 'Ö mɛ 'ö 'dhoë‑ mɛ kpengdhö ‑nia kun, ‑a ‑bha ‑kë mɛ kpengdhö 'ka ‑sü ‑wun 'gü, 'kian 'ö ‑Zlan dho ‑a nu mɛ kpengdhö 'ö bhë ‑a ‑dhë bhë ‑yö ‑dho ‑a ‑bha nu ‑a mɛ ‑dhë 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: 'Kö ‑kë ꞊nɛ ma mɛ ‑nu 'wo ꞊nɛ ‑a mɛ do 'ö‑ ꞊bhlë 'yaa‑ ‑bha yö ‑mü, mɛ 'ö 'yi ‑saa ‑kɔɔ do 'kpaan nu ‑a ‑dhë, ‑a ‑bha ‑kë ma mɛ 'ka ‑sü ‑wun 'gü, ‑yö ‑dho ö 'kian yö.» ");
INSERT INTO dnj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","꞊Dhɛ Yesu ꞊ya yën 'paanbhodhe ‑nu 'wo ꞊nɛ ‑an ‑nu ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an ‑dhë ‑sü ‑bha, 'yö go ‑dhɛ bhë ‑a ‑bha, 'yö dho ö bha mɛ ‑nu ꞊daan' ‑wo waa‑ ‑Zlan ‑wo pö ‑sü ‑an 'ka pödhɛ ‑nu ‑bha 'sɛ bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zan Batisö ‑yö ‑to ‑kanso 'kɔɔdhö, 'ö yuö 'ö Klito 'dhö ‑a kë ‑na bhë ‑ya ‑taɔ ‑ma. ꞊Dhɛ ꞊ya kë 'dhö, 'yö ö bha ꞊guë' ‑nu 'bhaa bɔ, ");
INSERT INTO dnj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","kö ‑waan Yesu ꞊dhɛɛ' 'kpɔ ꞊nɛɛ: «Ü mɛ 'ö 'yi‑ dɔa ꞊nɛ ‑yö ‑dho nu bhë ‑a 'ka, 'iin yi ‑dho ‑ya mɛ gbɛ 'bhaa ‑gɔ ee?» ");
INSERT INTO dnj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'yö‑ pö: «‑Ka 'dho, pë ‑nu 'ka ‑an ‑wun ma 'ö 'ka 'yan ‑kpën ‑a ‑bha 'nö bhë, 'ka‑ ‑wun ꞊blɛɛ'‑ Zan ‑dhë ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","'Yënngtiimɛ ‑nu ‑wo ‑dhɛ yö ‑na, ‑gɛnlomɛ ‑nu ‑wo 'ta ‑sü ‑na, ꞊wee ꞊yuamɛ ‑nu bun ꞊ya kë 'slööslö, 'totamɛ ‑nu ‑wo 'wun ma ‑na, gamɛ ‑nu ‑wo 'go ‑na ga 'gü, 'ö 'yenamɛ ‑nu ꞊wa 'wuntaɔsë ma. ");
INSERT INTO dnj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","꞊Zuögludhi ‑yö kë mɛ yaa 'dho ö bo ‑zo ‑yö n ‑ma ‑sü 'ka bhë ‑a ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","꞊Dhɛ 'ö Zan ‑bha ꞊guë' ‑nu ꞊wa ziö ꞊wa 'dho, 'ö Yesu ‑yö 'wun 'ö ‑gban Zan ‑bha 'ö‑ ꞊blɛɛ mɛ gbung ‑nu 'wo ‑kë mü bhë ‑an ‑dhë, 'ö‑ pö: «‑Më 'ka dho ‑a ‑ga ꞊dhia 'yënng ꞊taa ꞊ɛ? 'Lü 'në 'ö ꞊tuun' ‑na 'tëë ꞊kwaa' yö ‑mü ‑a? (‑Yö ‑kë n 'gü ꞊nɛ 'yaa ‑mü). ");
INSERT INTO dnj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","꞊Dhɛ 'ö 'dhö, ‑më 'ö 'ka dho ‑a ‑ga ꞊dhia ꞊ɛ? Gɔɔn‑ do 'ö sɔ ‑së 'dhö ‑a ‑bha yö ‑mü ‑a? 'Kɛɛ yö ꞊ga 'ö mɛ ‑nu 'wo sɔ ‑së kë ‑na wo ‑bha bhë 'sa, ‑wo ‑kë ‑gludë ‑nu ‑gɔ kɔɔ ‑dhɛ ‑nu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","꞊Ɛɛ, ‑më 'ö 'ka dho ‑a ‑ga ꞊dhia 'sa? ‑Zlan ‑wodhiölomɛ do ‑mü ‑a? A‑ ‑pö ka ‑dhë, ꞊ii‑, ‑a ‑de ‑a ꞊bhlë ꞊yö ꞊va 'ö ‑ziö ‑Zlan ‑wodhiölomɛ ‑nu ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bhii Zan ‑yö mɛ 'ö ‑Zlan ‑bha 'sëëdhɛ ꞊bɛɛn' ‑wo ‑yö 'wun ‑gban ‑a ‑bha yö ‑mü ‑a 'ka ꞊nɛɛ: ‑Zlan ‑ya ‑pö: ‑Dhɛ ‑ga zö, 'ma ma bɔmɛ do bɔ ü 'dhiö kö ‑yaan ü bha zian ‑gblooga ‑yuö kë. ");
INSERT INTO dnj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Mɛ ‑nu 'wo bhɔ 'kpongtaa zö ‑a mɛ 'ö‑ ‑gɔ dho ꞊luu'‑ ‑yaan zië Zan Batisö ‑ta 'yaa 'dhö. 'Kɛɛ kö mɛ 'ö mɛ 'tee 'ka ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü bhë ‑a 'gü, ‑yö Zan ‑bha ꞊va. ");
INSERT INTO dnj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","'Ö sü 'töng 'ö Zan Batisö ‑yö ‑Zlan ‑wo ꞊blɛɛ ‑a 'ka ‑a ‑bha, 'ö yöë ꞊dɛɛ ‑bha, ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ ‑nu 'gü, ꞊ya kë 'gü ‑dɔ ‑de ‑gɔ 'gbee‑ ‑sü ‑wun 'ka; bhii 'gü ‑dɔ ‑de ‑gɔ 'gbee‑ ‑mɛ ꞊faanzë ꞊nɛ 'yö dho kë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","‑Zlan ‑wodhiölomɛ ‑nu 'saadhö waa‑ tɔng ‑nu 'ö Moizö ‑yö ‑an nu kwa ‑dhë bhë, 'wun 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ 'ö bhë ‑a ‑bha, ‑wa ‑blɛɛ 'ö nu 'ö yöë Zan Batisö ‑bha 'töng ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","'Ö ꞊ya kë ꞊nɛ, ka 'to ‑yö n ‑ma, kö ‑kaa ‑dhɛ 'wun gia‑ ꞊nɛɛ: Zan ‑yö Eli 'ö‑ ‑bha nu ‑sü ‑wun ‑yö ꞊blɛɛ ‑Zlan ‑bha 'sëëdhɛ 'gü bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'Ö ꞊ya kë ꞊nɛ ka 'wun ma ‑to ‑yö ‑dhö, kö 'wun ꞊nɛ, ‑kaa ‑gɛn ma bhoo‑!» ");
INSERT INTO dnj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","'Ö Yesu ‑ya pö: «Dö 'a dho ꞊dɛɛ ꞊nɛ ‑a 'gü ‑mɛ ‑nu ‑zɔn ‑a 'ka ɛ? ‑Wo ‑bhɔ 'në 'sɛɛn‑ ‑nu 'wo ‑ya ‑sü 'ka pö‑ 'dhëëdhö ‑dhɛ ‑nu ‑bha, 'ö 'wo 'we ‑na wo 'ko 'piö ‑an ‑bha ");
INSERT INTO dnj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‑a pö ‑sü 'ka ꞊nɛɛ: ‹Yi 'truu ‑nu ‑piö ka ‑dhë, 'ö kaa 'tan kë, 'ö 'yi ga ‑gbo bɔ ka ‑bha 'ö kaa ‑da 'yena 'gü!› ");
INSERT INTO dnj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","‑Kɔ do bhë ‑a 'ka Zan ‑bha ‑këdhösü 'gü, yaa pë ꞊plëëzë gbɛ ‑bhö, 'iin yaa ‑drɔɔn gbɛ mü, 'ö mɛ ‑nu ‑wa pö: ‹‑Zuu yaa ‑ya 'gü!› ");
INSERT INTO dnj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Ö ma Mɛgbö 'a nu 'a pë ‑nu ‑bhö, 'a ‑drɔɔn ‑nu mü, 'ö mɛ ‑nu ‑wa pö: ‹‑Ka ‑dhɛ ‑ga, gɔɔn‑ 'ö ꞊nɛ ‑a ‑bha ‑zo ‑ta ‑a 'gü ‑wun 'ö tɔɔ ‑bhöpë ‑wun waa‑ ‑drɔɔn mü ‑sü; ‑yö 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu waa‑ këwunyaamɛ ‑nu 'bhamɛ 'ka!› 'Kɛɛ a‑ ‑pö ka ‑dhë ꞊nɛɛ: ‑Zlan ‑bha 'wunbhokoudɔdhe ‑yö ö ‑de ‑zɔn kpengdhö ö këpë ‑nu 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Ö Yesu ‑yö yö 'we ‑sü 'gü pödhɛ ‑nu 'ö ‑dhidhaapë ꞊plëëzë ꞊va ‑dhɛ ‑kë ‑an 'gü bhë ‑an 'gü ‑mɛ ‑nu ‑dhë, 'ö tɔɔ waa wo ꞊zuö' ꞊dhië'‑ ‑Zlan 'piö, 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Kolazɛn ‑mɛ ‑nu, 'wun 'yenazë ‑yö ‑dho nu ka ‑ta; Betesaida ‑mɛ ‑nu, 'wun 'yenazë ‑yö ‑dho ‑lo ka ‑ta 'pö! Bhii ‑dhidhaapë ‑nu 'a ‑an kë ka ꞊plöö 'ma bhë, ꞊ya kë ‑bezë ꞊nɛ, ‑yö ‑kë Tii ‑dhɛ ‑bha 'iin Sidɔn ‑dhɛ ‑bha ‑be, ‑wo ‑dho to mü 'wo wo ꞊zuö' ꞊dhië ‑Zlan 'piö. ‑Wo ‑dho ꞊bhɔɔ' 'kaazë ‑da wo ‑bha 'wo 'yoo ‑kë wo ‑bha ‑bezë kö ‑waan ‑zɔn ꞊nɛ wo wö ‑yö ‑siö ‑sü 'ka wo ‑bha ꞊sɔɔn yaa ‑nu ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","꞊Dhɛ ‑kë 'dhö, a‑ ‑pö ka ‑dhë: ‑Zlan ‑bha zakanyi 'ka, Tii ‑dhɛ waa‑ Sidɔn ‑dhɛ ‑an ‑bha 'klobhɔdhe ‑yö ‑dho kë 'tee 'ö ꞊zië' ka ‑bha ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapɛɛnaɔmë ‑mɛ ‑nu, ka ‑de 'pö, ‑yö ka ‑zo 'piö ꞊nɛ, ka ‑gɔ ‑dho ꞊luu'‑, 'ö yö ‑a 'ka dhang‑ ‑bha ‑a? Pë dho kë ka 'ka 'ö tɔɔ ka ‑gɔ dho ꞊yɔɔ'‑ 'ö dho ‑a 'ka ꞊glöötiaandhö 'siö 'gü. Bhii ꞊ya kë ꞊nɛ ‑dhidhaapë ‑nu 'wo ‑kë ka ꞊plöö ꞊nɛ ‑wo ‑kë Sodɔmë ‑bezë, kö Sodɔmë ‑mɛ ‑nu 'wo bhë ‑wo ‑dho kë ‑dhö dɔ 'kwa‑ wo ꞊dɛɛ ‑yi 'ö ꞊nɛ ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka ‑zë 'pö, ka n ‑wo ‑ma ‑së 'ka, a‑ ‑pö ka ‑dhë: ‑Zlan ‑bha zakanyi 'ka, pë 'ö ‑kë Sodɔmë 'ka bhë ‑yö 'tee.» ");
INSERT INTO dnj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yesu ‑yö ‑to ‑dhɛ do bhë ‑a 'gü yi bhë ‑a 'ka, 'ö yö ꞊bhɛa' ‑sü ‑bha 'ö‑ pö: «'Oo, n Dë, n Dëmɛ, 'ö dhang‑ waa‑ 'kpongtaadhɛ ꞊kɔɔn, a ü zuö ‑pö, bhii pë 'ö ‑bin ‑sü 'ka mɛ 'kpaakpa ‑nu waa‑ pëdɔmɛ ‑nu ‑an ‑gɔ bhë 'ü‑ ‑zɔn 'në 'sɛɛn‑ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","꞊Ii‑, n Dë, ‑yö kë ‑sü 'ka 'dhö, 'yö tɔɔ ü ‑zo 'kun ‑wun ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","'Go mü 'ö‑ pö 'zü ö bha ꞊guë' ‑nu ‑dhë: «N Dë ꞊ya pë 'plɛ 'saadhö ‑lo n kwɛɛ. Mɛ gbɛ 'yaa ma ‑Zlan Gbö n dɔ, ‑a 'ke yaa kë n Dë ‑de 'ka. 'Ö mɛ gbɛ 'yaa n Dë dɔ, ‑a 'ke yaa kë ma ‑Zlan Gbö waa‑ mɛ ‑nu 'ö 'a‑ 'piö, 'ö 'wun ‑nu 'ö 'wo bhë 'a‑ ‑zɔn ‑an ‑dhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mɛ ‑nu 'saadhö 'ö ka 'gü ꞊ya ga ꞊kwɛɛ‑ bun ‑sü 'ka, ‑ka nu n 'piö; a ‑dho ka gbaa 'tɛɛ pa ‑sü 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","‑Ka ma tɔng ‑nu 'kun, 'ka ka ꞊kwaa' ka ‑de ‑wun ‑zü, 'a ka ꞊daan' 'wundɔdhe 'ka, bhii ma 'wun ꞊yö ‑së, 'ö n ꞊zuö' 'dho ‑saa. ꞊Ya kë 'dhö, ka ‑dho ka 'tɛɛpasü yö. ");
INSERT INTO dnj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ma tɔng 'a dho ‑a nu ka ‑dhë 'kaan‑ ‑a bun bhë ‑yö 'föngfö, 'ö ꞊kwɛɛ‑ 'a dho ‑a nu ka ‑dhë 'pö 'yö 'föngfö.» ");
INSERT INTO dnj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","꞊Dhɛ 'töng 'bhaa ꞊ya ziö, Yesu ‑yö ‑kë ziö ‑dhiadhö 'blee‑ 'ö 'wo 'bluu‑ ‑pë ‑kë ‑a 'ka ‑a ‑bhlö ‑nu 'gü Zuifö ‑nu ‑bha ꞊glooyi 'ka. Din ‑yö ‑kë ‑a ‑bha ꞊guë' ‑nu ‑bha. ꞊Dhɛ ‑kë 'dhö 'wo yö 'blee‑ 'ö bhë ‑a ‑kpa ‑nu 'bhaa 'kan ‑sü ‑bha 'ö 'wo‑ ꞊kia' ‑nu bho ‑a ‑bha, 'wo‑ ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","꞊Dhɛ 'ö Falizi ‑mɛ ‑nu ꞊wa ‑an yö, 'wo‑ pö Yesu ‑dhë: «‑Bhö ‑dhɛ ‑ga, pë giagia 'ö kwa ‑bha tɔng ‑ya pö kö ꞊kun 'kwa‑ ‑kë ꞊glooyi 'ka bhë 'ö ü bha ꞊guë' ‑nu 'wo‑ kë ‑na bhë!» ");
INSERT INTO dnj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Pë 'ö Davidö ‑ya ‑kë kö yö 'dhö waa‑ ö ‑bha mɛ ‑nu, din ꞊ya ‑an 'kun, 'ö ꞊bɛɛn' ‑sü 'ka bhë kaa‑ pö ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","‑Yö ꞊bɛɛn' ‑sü 'ka ꞊nɛ ‑yö ‑da ‑Zlan ‑gɔ kɔɔ; yö 'dhö waa‑ ö ‑bha mɛ ‑nu 'dhö, 'wo ꞊bluu'‑ 'wo ‑Zlan gba ‑na ‑a 'ka bhë 'wo‑ sü 'wo‑ ‑bhö, 'kɛɛ kö ‑an ꞊dua' 'yaa ‑mü kö ‑waan ‑a ‑bhö. Bhii 'ö tɔɔ kwa ‑bha tɔng ‑ya ‑pö sla‑ ‑bho ‑Zlan ‑dhë ‑mɛ ‑de 'sloo ꞊nɛ 'wo dho ‑a ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'Go mü 'zü 'ö ‑ya ‑sü 'ka Moizö ‑bha tɔng 'gü ꞊nɛ, kwa ‑bha ꞊glooyi 'ka, sla‑ ‑bho ‑Zlan ‑dhë ‑mɛ ‑nu 'ö yuö 'dhö ‑an kwɛɛ, ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, tɔng 'ö ‑gban ꞊glooyi ‑bha bhë 'waa‑ 'kun bhë 'wun gbɛ 'yaa ‑an ‑bha. ‑A mɛ bhë 'kaa‑ ‑wo pö ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","'Kɛɛ a‑ ‑pö ka ‑dhë: Pë do 'bhaa ‑yö zö 'ö ꞊va 'ö ꞊zië' ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'Ö ꞊ya kë ꞊nɛ pë 'ö ‑ya ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü, ka‑ ‑gɛn dɔ ‑bezë kö mɛ ‑nu 'ö 'wun 'yaa ‑an ‑bha, ka 'ka 'dho za ‑lo ‑an tuö. Pë 'ö ꞊bɛɛn' ‑sü 'ka bhë 'ö tɔɔ: 'Glusë kë ‑sü 'ö tɔɔ pë 'ö‑ ‑dhɔ ‑yö n ‑kë, 'kɛɛ n 'to 'yaa ka ‑bha slapë ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bhii ma Mɛgbö 'a ꞊nɛ, 'a tɔɔ ꞊glooyi gia‑ 'ö bhë ‑a ‑gɔmɛ.» ");
INSERT INTO dnj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","'Yö Yesu ‑yö go ‑dhɛ bhë ‑a ‑bha, 'yö dho Zuifö ‑nu ‑bha ‑bhɔkuëkɔ do 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gɔɔn‑ do 'ö‑ ‑kɔ ‑yö ga ‑a ‑bha ‑yö ‑kë mü. 'Ö mɛ ‑nu 'wo ‑kë mü, 'wo Yesu ꞊dhɛɛ' kpɔ 'wo‑ pö: «Kwa ‑bha tɔng ‑yö ‑we ‑a ‑bha kö 'kwa mɛ ‑dhɛ bo ꞊glooyi 'ka a?» ‑Wa ‑kë 'dhö kö 'waan‑ 'wun ‑dɔ ‑a ‑bha ‑dhɛ yö. ");
INSERT INTO dnj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «'Ö ꞊ya kë ꞊nɛ, mɛ ꞊ya kë ‑dhö ka ziën, 'ö 'bhla do ꞊ya kë ‑a ‑gɔ, 'ö‑ ‑bha 'bhla bhë ꞊ya ‑püö ‑glu 'dhi ꞊gbiin do 'gü ꞊glooyi 'ka, yö 'ka 'dho ‑mɔ ‑a ‑bha kö ‑yaan ‑a bho ‑glu 'dhi bhë ‑a 'gü a? ꞊Ii‑, ‑a mɛ 'kö bhë za 'yaa‑ ‑bha, ‑yö ‑dho ‑a bho mü. ");
INSERT INTO dnj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mɛ 'bhee‑ ‑wun 'pö ‑yö 'gbee‑ 'yö ꞊zië' 'bhla ‑ta! 'Ö bhii, kö ‑dhɛ 'ö 'dhö bhë, kö kwa ‑bha tɔng ‑yö ‑we ‑a ‑bha 'sa kö 'kwa 'wun ‑së kë mɛ ‑dhë ꞊glooyi 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","'Ö Yesu ‑ya pö gɔɔn‑ bhë ‑a ‑dhë: «‑Bhö ü ‑gbiö 'po!» 'Yö ö ‑gbiö ‑po, 'ö‑ ‑gbiö ‑yö bo 'yö ‑kë ꞊nɛ ‑a do 'ö to bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","'Ö Falizi ‑mɛ ‑nu ‑wo dho 'wo yö mɛ ‑gɔ ꞊taa ‑mɛ ‑nu ‑bha, ‑kɔ 'wo dho ‑a kaa kö 'waan‑ Yesu zë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","꞊Dhɛ 'ö Yesu ‑yö ö zë ‑wun ma, 'yö go ‑dhɛ 'ö bhë ‑a ‑bha. Mɛ ‑gbaa ‑wo ‑ziö ‑a 'piö. 'Yuamɛ ‑nu ‑wo ‑kë mɛ ‑nu 'wo bhë ‑an ziën 'pö, 'yö ‑an 'plɛ ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","'Kɛɛ ‑yö 'wun ‑blɛɛ ‑an ‑dhë 'gbee‑ 'ka ꞊nɛɛ: «Kö ꞊kun mɛ 'ö 'a‑ 'ka ꞊nɛ, 'ka‑ ꞊blɛɛ mɛ gbɛ ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","‑Yö ‑kë 'dhö kö ‑wo 'ö ‑Zlan ‑wodhiölomɛ Ezai ‑ya ꞊blɛɛ bhë ‑a 'dhiö ‑yaan ‑mɔ 'kuë. ‑Wo bhë ‑ya ‑pö ꞊nɛɛ: ‑Zlan ‑ya ‑pö: ");
INSERT INTO dnj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ma yuökëmɛ 'a‑ sü, yö ꞊ga 'ö ꞊nɛ! Yö ꞊nɛ 'ö‑ ‑dhɔ ‑yö n ‑kë, 'a n ‑ma ꞊zuögludhi ‑wun 'plɛ ‑ya ‑a kwɛɛ, yö ꞊nɛ 'a dho n ‑Zuu ‑ya ‑a 'gü; ma za 'a dho ‑a kan bhë ‑yö ‑dhoë ‑wun ꞊blɛɛ'‑ 'kpongtaamɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Waa‑ mɛ gbɛ waa 'dho ‑dɔn bho, 'iin yaa 'dho ꞊gblaa gbla; waa 'dho ‑a yö 'wun ‑blɛɛ 'gbee‑ ꞊dhia ‑kpinngga ‑nu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yaa 'dho ‑të 'lü 'ö ꞊wüü' ‑sü 'ka ‑a yɛ; yaa 'dho ꞊labang 'ö‑ 'bhü ꞊ya 'to 'tee ‑a ꞊dhuu'‑, 'ö dho 'ö yö ‑a ‑bha ‑to ‑a 'gbee‑ 'ka ‑sü 'wun kpengdhö 'gü ‑yi ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'Ö 'kpongtaamɛ ‑nu 'saadhö dho wo ‑zo yö ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","꞊Dhɛ ꞊ya kë 'dhö, 'wo nu gɔɔn‑ 'yënngtiizë do 'ö 'yaa 'we bhii 'ö tɔɔ ‑zuu yaa ‑yö ‑kë ‑a 'gü bhë ‑a 'ka Yesu 'piö. Yesu ‑yö gɔɔn‑ 'ö bhë ‑a ‑dhɛ ‑bo, 'ö yö 'wun ꞊blɛɛ' ‑sü ‑bha, 'ö‑ 'yan ‑yö ‑dhɛ yö 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mɛ gbung ‑nu 'wo ‑kë mü bhë, 'wun bhë ‑yö ‑an 'te tun, 'ö 'wo‑ pö: «‑Yö ‑dho kë Davidö gbö ('ö kwa ‑ya ‑a ‑gɔ ꞊nɛ ‑a) 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","'Kɛɛ ꞊dhɛ 'ö Falizi ‑mɛ ‑nu ꞊wa ‑an ‑wo ma, 'wo‑ pö: «Gɔɔn‑ 'ö ꞊nɛ ‑zuu yaa kë 'ö‑ wo ‑na bhë ‑a ‑gɛn 'ö tɔɔ Bɛɛzebilö 'ö ‑zuu yaa ꞊kɔɔnmɛ 'ka bhë ꞊nɛ 'ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu ‑a ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","'Kɛɛ ‑an ‑zo ‑ta ‑a 'gü ‑wun bhë Yesu ‑ya ‑dɔ. ꞊Dhɛ ‑kë 'dhö 'ö‑ pö ‑an ‑dhë: «‑Gludëdhɛ ‑pö mɛ 'ö ‑a 'gü ‑mɛ ‑nu 'dho ‑glu gɔn ‑na wo 'ko 'ka bhë ‑an 'dhiötodhɛ do 'ö tɔɔ 'güsiödhe. 'Go mü 'zü, pödhɛ 'saadhö, 'iin 'kɔ 'saadhö 'ö‑ 'gü ‑mɛ ‑nu 'wo dɔ kö ‑wo ‑ya wo 'ko ‑gɔ 'yënng bhë, 'ka‑ yö do ꞊nɛ ‑an ‑bha ‑kë 'kuë‑ ‑sü ꞊ya 'dho 'dhiö a? ");
INSERT INTO dnj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","'Ö ꞊ya kë ꞊nɛ Satan ꞊ya ‑ya ö ‑bha 'sɛgümɛ ‑nu ‑bha ‑glu 'ka, kö ꞊ya ‑glu gɔn ö ‑de 'ka. ‑Yö ka ‑de 'gü ꞊nɛ, 'sɛgɔ 'ö 'dhö bhë ꞊glɔɔsü ‑dho kë ‑a ‑gɔ ‑a? ");
INSERT INTO dnj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'Ö ꞊ya kë 'zü ꞊nɛ 'ma ‑zuu yaa kë ‑zuu yaa ꞊kɔɔnmɛ 'ka, kö ka ‑bha ꞊guë' ‑nu ‑wo ‑dho ‑a kë ‑më 'ka 'pö e? ‑A mɛ bhë 'ma 'go ‑a 'gü, wo gia‑ ‑ga 'wo dho za ꞊siö ka ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","'Kɛɛ ꞊ya kë ꞊nɛ ‑Zuu 'slööslö 'ö go ‑Zlan 'piö bhë ꞊nɛ 'a ‑zuu yaa ‑kë ‑a 'ka, kö ‑kaa dɔa ꞊nɛ ‑Zlan ‑bha ‑gludëdhɛ ꞊ya yö ka ‑bha 'saadhö ‑o! ");
INSERT INTO dnj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","('Wun 'ö ‑gban ma ‑zuu yaa kë ‑sü ‑bha mɛ ‑nu 'gü bhë a‑ ‑pö ka ‑dhë:) Dö 'ö‑ ‑kɔ dho ‑mɔ ‑a ‑bha kö ‑yaan ‑da gɔɔn‑ 'gü 'gbeezë ‑gɔ kɔɔ ‑yaan ‑a ‑bha 'kɔɔpë ‑nu 'sü kö yaa gɔɔn‑ 'gü 'gbeezë 'ö 'dhö bhë ‑a ‑lö 'dhiö e? 'Kɛɛ ꞊yaa‑ ‑lö 'püë‑ wo 'dhiö, 'yö dho ‑mɔ ‑a ‑bha pë ‑nu 'sü ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","꞊Dhɛ ‑kë 'dhö a‑ ‑pö 'ka ‑dhë: Mɛ 'ö yaa nu n ‑dhë kö ‑yö ‑nu n ‑gɔ. 'Ö mɛ yaa nu n ‑dhë, ma pë ‑nu ‑kpɔ 'kuë‑ ‑sü 'gü, kö ‑yö ‑nu ma pë ‑pɛn ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","‑A ‑wun 'gü a‑ ‑pö ka ‑dhë: ‑Zlan ‑dho ziö mɛbheedhe ‑nu ‑bha ꞊sɔɔn yaa ‑nu waa‑ ‑an 'dhi ‑wo yaa ‑nu 'saadhö ‑ta. 'Kɛɛ mɛ 'ö 'dhoë‑ 'wun yaa ꞊blɛɛ'‑ ‑Zuu 'slööslö ‑gɔ, ‑Zlan 'ka 'dho ziö ‑a ‑bha 'wun 'dhö bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mɛ 'ö 'dhoë‑ 'wun ꞊blɛɛ'‑ ma Mɛgbö n 'ka, ‑Zlan ‑dho ziö ‑a ‑bha 'wun ꞊zaa' ‑sü bhë ‑a ‑ta, 'kɛɛ mɛ 'ö 'dhoë‑ 'wun yaa ꞊blɛɛ'‑ ‑Zuu 'slööslö ‑gɔ, ‑Zlan 'ka 'dho ziö ‑a ‑bha 'wun ꞊zaa' ‑sü 'ö bhë ‑a ‑ta 'töng 'ö ꞊nɛ 'iin 'töng 'ö dho nu ‑an 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","'Yö‑ pö 'zü: «'Lü ‑së ‑yö ‑bha ö bhɛ ‑së 'ka, 'ö 'lü yaa ‑yö bha ö bhɛ yaa 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","꞊Mɛɛ ꞊suu'‑ ‑ta ‑nu 'ka ꞊nɛ, ka këwun ‑yö ya, ka ‑dho 'wun ‑së ꞊blɛɛ'‑ ‑kɔklë ꞊ɛ? Bhii pë 'ö mɛ ꞊zuö' 'gü, yö ꞊nɛ 'ö 'dhi ‑ya ꞊blɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mɛ këwunsëëzë ꞊zuögüdhɛ ‑yö pa ‑sü 'ka 'wun ‑së 'ka. ‑A ‑bha 'wun ‑së 'sü ‑dhɛ 'ö bhë, ꞊ya kë 'ö‑ ꞊blɛɛ. Mɛ këwunyaazë ꞊zuögüdhɛ ‑yö pa ‑sü 'ka 'wun yaa 'ka. 'Yö 'ö 'wun yaa ‑sü ‑dhɛ bhë ‑a 'gü 'pö 'yö‑ ꞊blɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A‑ ‑blɛɛ ka ‑dhë ꞊nɛɛ: ‑Zlan ‑bha zakanyi 'ka, mɛ ‑nu ‑wo ‑dho wo ꞊blɛɛ'‑ ‑wun ‑nu 'flëëflëë 'wo‑ ꞊blɛɛ bhë ‑a 'plɛ ‑lo sia‑ ‑Zlan 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bhii ü ‑de ‑wo 'ö dho go ü dhiö 'kpongtaa zö bhë, ꞊yö ‑së o, ꞊yö yaa o, yö ꞊nɛ 'ö dho ü ‑bha za kan.» ");
INSERT INTO dnj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","'Ö Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu mɛ 'bhaa ‑nu waa‑ Falizi ‑mɛ ‑nu mɛ 'bhaa ‑nu ‑wa pö Yesu ‑dhë: «Yi ‑Gɔmɛ, yi‑ 'piö kö 'ü ‑dhidhaapë do kë yi ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «꞊Dɛɛ ‑yi ꞊nɛ ‑a 'gü ‑mɛ ‑nu këwunyaazë ‑nu, 'ö 'waa 'to wo ‑wo 'gü ‑Zlan ‑dhë, ‑wo ‑dhidhaapë ‑dhɛ ‑na, 'kɛɛ ‑dhidhaapë gbɛ yaa 'dho ‑zɔn ‑an ‑dhë zö, ‑a 'ke yaa kë ‑Zlan ‑wodhiölomɛ Zonasö ‑bha ‑dhidhaapë 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bhii ‑kɔ do 'ö Zonasö ‑yö ‑dhɛkpaɔyi ‑yaaga ꞊kaa' 'yuö‑ do ꞊va 'guu bhë, 'ö ma Mɛgbö 'a dho ‑dhɛkpaɔyi ‑yaaga kaa 'sɛidhö. ");
INSERT INTO dnj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","‑Zlan ‑bha zakanyi 'ka, mɛ ‑nu 'wo Ninivö plöö, ‑wo ‑dho ꞊luu' 'wo dɔ ꞊dɛɛ ꞊nɛ ‑a 'gü mɛ ‑nu 'dhiö, 'wo za ‑ya ‑an ‑bha; bhii ꞊dhɛ 'ö Zonasö ‑yö ‑Zlan ‑wo ‑blɛɛ Ninivö ‑mɛ ‑nu ‑dhë, ‑wo wo ‑kwaa wo ‑bha ꞊sɔɔn yaa ‑nu ‑zü, 'wo wo ꞊zuö' ꞊dhië ‑Zlan 'piö. 'Kɛɛ kö ka ‑bha 'ka, mɛ 'ö 'a ꞊bhlë 'dhö ꞊va 'ö ꞊zië' Zonasö ‑ta, ‑yö ka 'piö zö. ");
INSERT INTO dnj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'Go mü 'zü ‑Zlan ‑bha zakanyi 'ka, dhebɔ 'ö ‑kë ‑gludë 'ka 'ö 'sɛ 'ö kwa ‑bha 'sɛgɔ goo ꞊zian' 'ö go ‑a 'gü, ‑yö ‑dho dɔ mɛ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü ‑an 'dhiö, 'ö za ‑ya ꞊dɛɛ ꞊nɛ ‑a 'gü ‑mɛ ‑nu ‑bha. Bhii ‑yö ‑go 'sɛgɔ ꞊gbiin 'gü, 'ö nu 'ö ö 'to to Salomɔ ‑bha 'wun ‑bho 'kou dɔ ‑wo ‑bha. 'Ö ꞊dhɛ ‑kë 'dhö, mɛ 'ö‑ ꞊bhlë 'dhö ꞊va 'ö ꞊zië' Salomɔ ‑ta, ‑yö ka 'piö zö.» ");
INSERT INTO dnj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","'Yö‑ pö 'zü: «꞊Ya kë ꞊nɛ ‑zuu yaa ꞊ya 'go mɛ 'gü, ‑yö ‑nië 'yënng ꞊taa, ‑dhɛ 'ö dho ö 'tɛɛ pa ‑a ‑bha ‑a ꞊mɛɛ' ‑sü 'ka. ꞊Ya kë ꞊nɛ 'yaa‑ yö ‑na, ");
INSERT INTO dnj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","'yö‑ pö ö ‑de ‑dhë ꞊nɛɛ: ‹A ‑dho yɛ n 'zü, 'a dho ma 'kɔ 'a go ‑a 'gü bhë ‑a 'gü.› 'Yö nu 'ö kɔɔdhɛ yö 'kpaan, kö ‑dhɛ ‑yö ‑go ‑sü 'ka, 'kö pë 'plɛ ‑yö ‑dho 'kuë‑ dhö ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","꞊Ya kë 'dhö 'yö dho, 'yö ‑zuu yaa 'slaplɛ 'wo ‑ziö ‑a ‑ta, 'ö ‑an ‑dhɛ 'ö 'wo nu wo 'kuë, 'wo wo ‑ya ‑dhɛ kun mü. ꞊Ya kë 'dhö zlöö kö mɛ 'ö bhë ‑a këwun ꞊ya kë yaa ꞊ya zië ‑a mɛ 'ö 'dhiö ‑a ‑ta. ‑Kɔ do bhë ‑a 'ka 'yö dho kaa, mɛ këwunyaazë 'wo ꞊dɛɛ ‑yi ꞊nɛ ‑a 'gü bhë ‑an ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu ‑yö ‑to 'wun ꞊blɛɛ'‑ ‑sü 'gü mɛ gbung ‑nu ‑dhë 'ö‑ dhe waa‑ ‑a dheglu 'në gɔɔn‑ ‑nu ‑wo ‑nu, 'wo dɔ plaan, 'wo ‑kë ‑a këdhɛ ꞊mɛɛ' ꞊dhia kö 'waan‑ 'wun ꞊blɛɛ'‑ ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Ö mɛ do ‑ya pö Yesu ‑dhë: «‑Dhɛ ‑ga 'dhɛ, ü dhe waa‑ ü dheglu 'në gɔɔn‑ ‑nu ‑wo plaan, ‑wa 'piö kö 'wo 'wun ꞊blɛɛ'‑ ü ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'Ö Yesu ‑ya pö mɛ bhë ‑a ‑dhë: «Dö ‑nu 'pö 'wo tɔɔ n dhe waa‑ n dheglu 'në gɔɔn‑ ‑nu ‑i?» ");
INSERT INTO dnj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'Yö ö ‑kɔ ‑zɔn ö bha ꞊guë' ‑nu 'ka 'ö‑ pö: «‑Ka ‑dhɛ ‑ga, n dhe waa‑ n dhegluzë ‑nu ꞊ga 'wo ꞊nɛ. ");
INSERT INTO dnj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bhii mɛ ‑nu 'ö 'wo n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü ‑a ‑zo 'kun ‑wun kë bhë, wo ꞊nɛ 'wo tɔɔ n dheglu 'në gɔɔn‑ ‑nu, n dheglu 'në dhoo ‑nu waa‑ n dhe.» ");
INSERT INTO dnj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yi 'ö 'dhö bhë ‑a 'ka, Yesu ‑yö ‑go kɔɔ, 'yö dho, 'yö ‑ya 'yipuë ꞊va 'kpong 'dhiö kö ‑yaan mɛ ‑nu ꞊daan'‑. ");
INSERT INTO dnj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","'ö mɛ ‑gbaa ꞊va ‑wo nu 'wo ꞊nië ‑a ‑zü. ꞊Dhɛ 'wo‑ ꞊nëng ‑na, 'ö ‑da 'yitagɔ do 'gü, 'yö ꞊yaannu. 'Ö mɛ ‑gbaa ‑nu ‑wo to sia‑ 'yi 'kpong 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","'Yö 'wun ꞊plëëzë ꞊blɛɛ ‑an ‑dhë 'wun ꞊zuan' 'ka, 'yö‑ pö ‑an ‑dhë: «Gɔɔn‑ do ‑yö ‑dho ö bha pëga ‑pɛn ꞊dhia ꞊nɛ ‑kɔ 'wo ‑mlü ‑pɛn ‑na ‑a 'ka, 'ö 'wo‑ ‑ya ‑na bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pëga ‑nu 'ö kë ‑an ‑pɛn ‑sü 'gü ö ‑gɔ ꞊bhlöö‑ bhë, ‑a 'bhaa ‑nu ‑wo ‑püö zian ‑gbloo 'piö. 'Ö ‑ma ‑nu ‑wo nu 'wo‑ ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","'Ö‑ ga 'bhaa ‑nu ‑wo ‑püö gwa ‑ta; 'kɛɛ 'sɛ 'yaa kë mü ꞊va. Pëga ‑nu 'wo bhë 'wo bhɔ 'zodhö, bhii waa 'dho 'sɛidhö ꞊gbiin. ");
INSERT INTO dnj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","꞊Dhɛ 'ö lan‑ ‑yö yö 'bhü ‑sü ‑bha, 'ö‑ 'plüün 'plɛ ‑wo ga 'ö 'wo 'kpɛa kun, 'ö tɔɔ ‑an yun ‑nu waa 'dho 'sɛidhö ꞊gbiin. ");
INSERT INTO dnj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'Ö‑ ga 'bhaa ‑nu ‑wo ‑püö ꞊blëë' 'ginngzë ‑nu 'gü, 'ö ꞊blëë' 'ginngzë ‑nu ‑yö ꞊kpɛa, 'yö pëga ‑së 'yö bhɔ bhë 'wo sɔ ‑a ‑ta, 'ö 'wo‑ ꞊siö. ");
INSERT INTO dnj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'Kɛɛ ‑a ga 'bhaa ‑nu ‑wo ‑püö 'sɛ ‑së 'gü, 'wo ꞊kpɛa, 'ö ‑an ‑kpa ‑yö ‑kë. ‑A 'bhaa ‑nu ‑kpa ga ‑wo ‑kë ꞊këng' do; ‑a 'bhaa ‑nu ‑kpa ga ‑wo ‑kë 'gɔɔ‑ 'slado, 'ö‑ 'bhaa ‑nu ‑kpa ga ‑wo ‑kë 'gɔɔ‑ ‑yaaga.» ");
INSERT INTO dnj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü ꞊nɛɛ: «'Ö ꞊ya kë ꞊nɛ ka 'wun ma ‑to ‑yö ‑dhö, 'wun 'a‑ ꞊blɛɛ ꞊nɛ kö ‑ka ‑a ma ‑së 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑bha ꞊guë' ‑nu ‑wo ‑yɔɔn ‑a ‑bha ‑a ꞊dhɛɛ' 'kpɔ ‑sü 'ka ꞊nɛɛ: «‑Më ‑kë 'ü 'wun ꞊blɛɛ ‑an ‑dhë 'wun ꞊zuan' 'gü i?» ");
INSERT INTO dnj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","'Yö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ka ‑zë, 'wun 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ ‑nu 'gü ‑a ‑bha 'ö 'bin ‑sü 'ka, 'ka‑ yö; 'kɛɛ wo ‑zë, waa‑ yö. ");
INSERT INTO dnj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bhii mɛ 'ö pë 'dhö ‑a ‑gɔ, ‑a ꞊taɔ' ‑dho kë, kö pë ‑yö kë ‑a ‑gɔ ꞊va ‑yö ziö ‑mü. 'Kɛɛ mɛ 'ö pë gbɛ 'yaa‑ ‑gɔ, ‑a 'bhle 'tee 'ö‑ ‑gɔ bhë ‑yö ‑dho kun ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","‑A ‑wun 'gü ꞊nɛ 'ö 'a 'wun ꞊blɛɛ' ‑na ‑an ‑dhë 'wun ꞊zuan' ‑zɔn ‑sü 'ka bhë; bhii ‑wo pë ‑nu ‑ga, 'kɛɛ 'waa‑ yö; 'ö 'wo wo 'to to 'wun ‑nu ‑bha, 'waa‑ ‑gɛn ma, ‑waan 'dho ‑a ‑bho 'kou dɔ. ");
INSERT INTO dnj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","‑Kɔ bhë ꞊nɛ 'ö pë 'ö ‑Zlan ‑wodhiölomɛ Ezai ‑ya pö bhë 'ö‑ 'dhiö dho ‑mɔ ‑a 'ka 'kuë; 'yö‑ pö: ‑Zlan ‑ya pö: Ka ‑dho 'wun ma, 'kɛɛ ka 'ka 'dho ‑a ‑gɛn dɔ; ka ‑dho ‑dhɛ ‑ga, 'kɛɛ ka 'ka 'dhodhɛ yö. ");
INSERT INTO dnj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bhii 'sɛ ꞊nɛ ‑a 'gü ‑mɛ ‑nu ꞊zuö' 'yaa 'wun gbɛ dɔ gbɔ. ꞊Wa wo 'to ‑nu ‑ta, ꞊wa wo 'yan ‑nu kpö ‑ta, ‑yö ‑kë 'dhö kö ꞊kun 'ö ‑an 'yan dho ‑dhɛ yö, 'ö ‑an 'to dho 'wun ma, 'ö ‑an ꞊zuö' dho 'wun dɔ, 'iin 'wo dho ꞊dhië' n 'piö kö 'aan‑ dha. ");
INSERT INTO dnj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","꞊Ya 'to ma ꞊guë' ‑nu ka ‑bha, ꞊zuögludhi ‑yö kë ka ‑gɔ. Bhii ka 'yan ‑nu ꞊wa ‑dhɛ yö, ka 'to ‑nu ꞊wa 'wun ma. ");
INSERT INTO dnj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ‑Zlan ‑wodhiölomɛ ‑dhɛvadhɛ waa‑ ‑Zlan ‑bha mɛ kpengdhö ‑nu ‑wa ‑dhɔ ‑kë, pë ‑nu 'ka‑ yö ‑na ꞊nɛ kö ‑waan ‑a yö, 'kɛɛ waa‑ yö. 'Iin pë ‑nu 'ka‑ ma ‑na ꞊nɛ kö ‑waan ‑a ma, 'kɛɛ waa‑ ma.» ");
INSERT INTO dnj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","'Yö‑ pö: «꞊Dhɛ ‑kë 'dhö ‑ka ka 'to 'to, 'wun ꞊zuan' 'ö ‑gban pëga ‑pɛn ‑mɛ ‑bha bhë ‑a ‑gɛn ‑bha! ");
INSERT INTO dnj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Mɛ ‑nu 'wo wo 'to to ‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑bha 'ö 'waa ‑a ‑gɛn ma bhë, ‑wo ‑bhɔ mɛ ‑nu 'ö ‑an ‑bha ‑Zlan ‑wo 'kun ‑kɔ ‑yö ‑bhɔ zian ‑gbloo 'piö ‑dhɛ 'ö pëga ‑nu ‑wo ‑püö ‑a ‑bha bhë ‑a ‑bha. 'Ö ꞊ya kë 'ö dü ‑yö nu, 'ö ‑Zlan ‑wo mɛ 'ö ta ‑an ꞊zuö' 'piö bhë 'yö‑ bho mü. ");
INSERT INTO dnj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","'Ö mɛ 'bhaa ‑nu ‑bha ‑Zlan ‑wo 'kun ‑kɔ ‑yö bhɔ 'sɛ 'ö gwa ‑ta 'ö pëga ‑yö ‑püö ‑a ‑ta bhë ‑a ‑bha. ꞊Wa ‑Zlan ‑wo ma, 'wo to mü 'ö‑ kun ꞊zuögludhi 'ka, ");
INSERT INTO dnj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'kɛɛ 'waa wo ꞊kwaa' ‑a ‑zü, ‑a yun 'yaa ziö ‑an 'gü, 'wo kpa ‑a ‑bha 'töng 'bhaa 'ka, 'kɛɛ ꞊ya kë ꞊nɛ 'yënngbhɔdhe waa‑ 'klobhɔdhe ꞊wa nu ‑an ‑ta, ‑Zlan ‑wo 'wo‑ kun bhë ‑a ‑wun 'gü, 'wo wo ꞊kwaa ‑zo yö ‑sü ‑zü. ");
INSERT INTO dnj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mɛ 'bhaa ‑nu ‑wo mü 'zü, 'ö ‑an ‑bha ‑Zlan ‑wo 'kun ‑kɔ ‑yö ‑bhɔ ꞊blëë' 'ginngzë 'gü ‑dhɛ 'ö pëga ‑nu 'dhö ‑püö ‑na ‑an ziën bhë ‑a ‑bha. 'Ö 'wo ‑Zlan ‑wo ma, 'kɛɛ ‑ya ‑de ꞊zɔnng' ‑ta ‑sü 'ö 'kpongtaapë ‑wun 'gü waa‑ ‑ya ꞊bhɔɔpë 'ö ‑an ‑püö ‑pë 'ka, ‑an ‑wun ꞊zɔnng' ‑ta ‑sü ‑yö ‑kë 'ginng ‑nu 'ka; 'wo sɔ ‑Zlan ‑wo 'ö 'wo‑ ma ‑na bhë ‑a ‑ta, 'ö ‑an ‑kpa gbɛ 'yaa kë ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mɛ 'bhaa ‑nu ‑de 'pö ‑an ‑bha ‑Zlan ‑wo 'kun ‑kɔ ‑yö bhɔ 'sɛ ‑së 'ö pëga ‑yö ‑püö ‑a 'gü bhë ‑a ‑bha: ꞊Wa ‑Zlan ‑wo ma, 'ö 'wo‑ ‑gɛn ma. ꞊Ya kë 'dhö, 'ö 'wo ‑dhi, 'ö ‑an ‑kpa ‑yö ‑kë. ‑An 'bhaa ‑nu ‑kpa ga ‑wo ‑kë ꞊këng' do, ‑an 'bhaa ‑nu ‑kpa ga ‑wo ‑kë 'gɔɔ‑ 'slado, 'ö ‑an 'bhaa ‑nu ‑kpa ga ‑wo ‑kë 'gɔɔ‑ ‑yaaga.» ");
INSERT INTO dnj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu ‑yö ‑ko 'zü 'yö 'wun ꞊blɛɛ ‑an ‑dhë 'wun ꞊zuan' ‑zɔn ‑sü 'ka, 'ö‑ pö ‑an ‑dhë: «‑Ka ‑dhɛ ‑ga, pë 'ö ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü 'ö bhɔ ‑a ‑bha ꞊ga ꞊nɛ: Gɔɔn‑ do ‑bha pëga ‑së ‑bhlö ‑yö ‑kë ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","'Ö gbeng ‑yi do ‑yö dɔ, kö mɛ ‑nu ꞊wa yi zë, 'ö gɔɔn‑ 'ö bhë 'ö‑ yaagümɛ ‑yö nu, 'yö pëga yaa ‑pɛn ‑a ‑bha tapë ‑bhlö bhë ‑a 'gü 'ö to 'ö ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","꞊Dhɛ 'ö 'blee‑ ga ‑nu waa‑ pëga yaa 'ö bhë ‑nu 'wo bhɔ wo 'kuë‑, 'ö 'blee‑ ga ‑nu 'dho 'wü ‑na 'ö ꞊blëë' yaa ‑nu ‑de 'pö 'wo yö ꞊luu' ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","'Yö ꞊bhlöödhɛ dëmɛ ‑bha yuökëmɛ ‑nu ‑wo nu 'wo‑ pö ‑a ‑dhë: ‹Yi ‑Gɔmɛ, pëga ‑së ‑nu kun yi‑ ‑pɛn ü ‑gɔ ꞊bhlöö‑ ‑a, ꞊ya kë 'dhö kö ꞊blëë' yaa ‑nu 'wo ꞊nɛ ‑wo ‑go më ꞊ɛ?› ");
INSERT INTO dnj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","'Yö‑ pö ‑an ‑dhë: ‹N yaagümɛ ꞊nɛ 'ö‑ 'wun ‑kë bhë!› 'Ö‑ ‑bha yuökëmɛ ‑nu ‑wa pö ‑a ‑dhë: ‹Ü‑ 'piö kö 'yi 'dho 'yi ꞊blëë' yaa ‑nu bhë 'yi ‑an bho mü ꞊a?› ");
INSERT INTO dnj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","'Yö‑ pö ‑an ‑dhë: ‹‑Abi', bhii ꞊blëë' yaa ‑nu ‑wo ‑sü 'ka, ka ‑dho 'blee‑ 'lü ‑nu ꞊nëng ‑an ‑bha, 'ö 'ka ‑an bho ‑a 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‑Ka ka ꞊kwaa' ‑an ‑zü, ‑wo ꞊kpɛa' wo 'kuë, ‑yö 'dho ‑yö yöë ‑an 'kan ‑yi ‑bha! ꞊Ya kë 'dhö, a ‑dho ‑a pö ‑an 'kan ‑mɛ ‑nu ‑dhë: ‑Ka ꞊blëë' yaa ‑nu ꞊woo'‑ ꞊kun, 'ka ‑an kpa 'kuë‑ 'ka ‑an 'lü ꞊kaan'‑, 'ka ‑an 'güö! 'Go mü kö 'ka 'blee‑ ga ‑nu ‑lo n ‑gɔ 'slëëdhö!› » ");
INSERT INTO dnj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu ‑yö 'wun ꞊blɛɛ ‑an ‑dhë 'zü 'wun ꞊zuan' ‑zɔn ‑sü 'ka, 'ö‑ pö ‑an ‑dhë: «‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü ‑yö ‑kë ꞊nɛ mutaadö ga 'dhö. ‑A ga 'ö bhë ‑yö ‑bhɔ ꞊kplɔɔ' ga 'ö gɔɔndë do ‑ya ta ö ‑gɔ ꞊bhlöö‑ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yö ꞊nɛ 'ö tɔɔ tapëga ‑nu 'saadhö ‑an 'teezë, 'kɛɛ ꞊ya ꞊kpɛa'‑, 'too ‑lü ‑nu 'wo 'toodhɛɛdhö, ‑a mɛ 'ö dho kë ꞊va ‑a ‑bha 'yaa 'dhö; 'ö ꞊ya 'to zlöö kö ‑ma ‑nu ‑wo wo 'kɔ ‑nu dɔ ‑na ‑a ‑kɔ ‑nu ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ‑yö 'wun ꞊zuan' gbɛ 'bhaa ‑zɔn ‑an ‑dhë 'zü ꞊nɛɛ: «‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü ‑yö ‑bhɔ ꞊bluubhɛɛpë 'ö dhebɔ ‑nu 'dho ‑a ‑da ‑na ꞊bluu'‑ ‑bi 'piö bhë ‑a ‑bha. ꞊Waa‑ ‑da ꞊bluu'‑ ‑bi 'kilong 'gɔɔ‑ ꞊plɛ ö ga 'sɔɔdhu 'piö, 'yö ꞊bluu'‑ ꞊bhɛɛ 'yö ꞊luu 'yö pë 'wo‑ ‑da ‑a 'gü bhë 'ö‑ pa.» ");
INSERT INTO dnj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ‑yö 'wun ‑blɛɛ mɛ gbung ‑nu ‑dhë 'wun ꞊zuan' ‑zɔn ‑sü 'ka; 'yaa 'wun ꞊blɛɛ'‑ ‑an ‑dhë 'kpaan 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","‑Ya kë 'dhö, kö pë 'ö ‑Zlan ‑wodhiölomɛ ‑ya ꞊blɛɛ 'dhiö bhë ‑yaan kë ꞊nɛɛ: A ‑dho 'wun ꞊blɛɛ'‑ ‑an ‑dhë 'wun ꞊zuan' ‑zɔn ‑sü 'ka, 'ö pë ‑nu 'wo ‑kë ‑bin ‑sü 'ka 'ö ‑sü 'kpongtaadhɛ kë yi ‑bha 'ö yöë ꞊dɛɛ ‑bha, 'a‑ ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ö ‑kwaa mɛ gbung ‑nu 'wo bhë ‑an ‑zü, 'ö yö ‑zë 'yö dho kɔɔ. 'Ö‑ ‑bha ꞊guë' ‑nu ‑wo ꞊yɔɔn ‑a ‑bha 'wo‑ pö ‑a ‑dhë: «'Wun ꞊zuan' 'ö ‑gban ꞊blëë' yaa 'ö gɔɔn‑ do yaagümɛ ‑ya ‑pɛn ‑a ‑gɔ ꞊bhlöö‑ bhë ‑a ‑bha bhë, ‑a 'zü pö yi ‑dhë 'kwee‑!» ");
INSERT INTO dnj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Mɛ 'ö pëga ‑së ta 'ö tɔɔ ma Mɛgbö. ");
INSERT INTO dnj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","꞊Bhlöödhɛ 'ö tɔɔ 'kpongtaadhɛ, pëga ‑së 'ö tɔɔ mɛ ‑nu 'wo ‑Zlan ‑bha ‑gludëdhɛ 'gü ‑mɛ ‑nu 'ka bhë; ꞊blëë' yaa bhë 'ö tɔɔ mɛ ‑nu 'wo këpëyaamɛ ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","‑A yaagümɛ 'ö ꞊blëë' yaa ‑pɛn 'ö tɔɔ dü; tapë 'kan ‑sü 'ö tɔɔ 'kpongtaadhɛ 'dhiötoyi. 'Ö yuökëmɛ ‑nu 'wo tapë 'kan ‑mɛ ‑nu 'ka, 'wo ‑kë ‑Zlan ‑bha bɔmɛ ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","‑Kɔ do 'ö 'wo ꞊blëë' yaa ‑nu ꞊woë' tapë ‑nu ziën 'wo‑ ‑zong ‑a 'ka 'siö 'gü bhë, ‑kɔ do bhë 'yö dho kaa 'kpongtaadhɛ 'dhiötoyi 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ma Mɛgbö, a ‑dho ‑Zlan ‑bha bɔmɛ ‑nu bɔ, 'ö 'wo mɛ ‑nu 'wo mɛ ‑püö ‑na ꞊sɔɔn yaa 'gü waa‑ 'wunyaakëmɛ ‑nu ‑an bho n ‑ma ‑gludëdhɛ ‑pö 'gü, ");
INSERT INTO dnj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","'ö 'wo ‑an ‑zuö 'siö 'gü. ‑Dhɛ bhë ‑a 'gü, ‑wo ‑dho 'gbo ‑nu bɔ, 'wo wo 'sɔn ‑nu ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","'Kɛɛ mɛ ‑nu 'wo ‑Zlan ‑bha mɛ kpengdhö 'ka, ‑wo ‑dho bhü ꞊nɛ ‑kɔ 'ö lan‑ ‑yö bhüë ‑a 'dhö wo Dë ‑bha ‑gludëdhɛ ‑pö 'gü. 'Ö ꞊ya kë ꞊nɛ, ka 'wun ma ‑to ‑yö ‑dhö, kö 'wun 'ö ꞊nɛ ‑kaa ma ö ‑gɛn 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","'Yö Yesu ‑yö dho 'wun ꞊zuan' ‑zɔn ‑sü 'ka 'dhiö ꞊woë' ꞊nɛɛ: «‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑yö ‑bhɔ 'zü ꞊bhɔɔpë 'ö ‑bin ‑sü 'ka ꞊bhlöö‑ ‑a ‑bha. Gɔɔn‑ do ‑yö ö 'yan dɔ ꞊bhɔɔpë 'ö ‑bin ‑sü 'ka bhë ‑a ‑bha; 'yö dho 'yö‑ ‑bin 'zü. 'Ö dho ꞊zuögludhi 'ka, 'yö ö bha pë ‑nu 'plɛ 'dhɔɔ dɔ, 'yö dho 'ö ꞊bhlöödhɛ bhë 'ö‑ dhɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","'Yö‑ pö 'zü: «‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑yö ‑bhɔ 'zü 'dhɔɔdɔmɛ do 'yö ‑zlɔɔ ‑së ꞊mɛɛ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","꞊Dhɛ 'ö‑ mɛ 'ö‑ ꞊sɔnng' 'dhö 'gbee‑ 'ö‑ yö, 'yö dho 'ö pë ‑nu 'wo‑ ‑gɔ 'ö ‑an 'plɛ 'dhɔɔ dɔ, 'ö nu 'ö ‑zlɔɔ bhë 'ö‑ dhɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","'Ö Yesu ‑ya pö 'zü: «‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑yö ‑bhɔ 'zü 'kplö 'wo‑ ‑zuö ‑na 'yipuë ꞊va ꞊bhaa, 'ö 'wo 'yuö‑ ꞊suu'‑ 'oo ꞊suu'‑ 'kun ‑na ‑a 'ka bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","꞊Ya kë ꞊nɛ ꞊ya pa, 'ö 'yiblükëmɛ ‑nu ‑wo ‑nu 'ö 'wo‑ ‑gan 'wo dho ‑a 'ka 'kpongtaa; 'wo ꞊yaannu, 'wo 'yuö‑ ‑nu zë 'gü; 'wo‑ ‑sɛɛbɔ ‑nu ‑lo wo ‑gɔ ꞊sɛn 'gü. 'Ö‑ mɛ 'ö ‑an 'kun ‑pë gbɛ 'yaa 'dhö bhë 'wo ‑an ‑lo yiö. ");
INSERT INTO dnj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","‑Kɔ do bhë 'yö dho kë ‑a 'ka 'kpongtaadhɛ 'dhiötoyi 'ka. ‑Zlan ‑bha bɔmɛ ‑nu ‑wo ‑dho nu 'wo mɛ këwunyaazë ‑nu bho mɛ këwunsëëzë ‑nu 'piö, ");
INSERT INTO dnj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","'wo ‑an ‑zuö 'siö 'gü. ‑Dhɛ bhë 'wo dho 'gbo ‑nu bɔ, 'wo wo 'sɔn ‑nu ‑bhö ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","'Ö Yesu ‑ya pö ‑an ‑dhë: «'Wun ‑nu 'a ‑an ꞊blɛɛ ꞊nɛ, ka ‑an ‑ma ‑së 'ka a?» 'Wo‑ pö: «꞊Ii‑.» ");
INSERT INTO dnj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'Yö‑ pö ‑an ‑dhë: «꞊Dhɛ ‑kë 'dhö, mɛ ‑nu 'wo tɔnggɔmɛ ‑nu 'ka 'saadhö, 'ö 'wun 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑bha, 'wo‑ ‑bho 'kou dɔ bhë, ‑wo ‑bhɔ 'kɔ dëmɛ do 'ö ö bha pë ‑dëü waa‑ pë zii 'ö‑ ‑bha ‑wun yö ‑a ‑bha, 'ö‑ sü ö bha ꞊bhɔɔpë 'gü ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","꞊Dhɛ 'ö Yesu ꞊ya yën 'wun ‑blɛɛ ‑an ‑dhë 'wun ꞊zuan' 'ka ‑sü ‑bha, 'ö go ‑dhɛ bhë ‑a 'gü, ");
INSERT INTO dnj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","'yö dho pödhɛ 'ö ꞊kpɛa ‑a ‑bha ‑a 'gü, 'ö yö mɛ ‑nu ꞊daan' ‑sü ‑bha Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü. 'Ö mɛ ‑nu 'wo ‑kë mü 'töüdhö, 'tetundhe ‑yö ‑da ‑an 'gü, 'ö 'wo‑ pö: «‑Yö ‑go 'wunbhokoudɔdhe 'ö ꞊nɛ ‑a 'ka më ꞊ɛ? ‑Ya ‑kɔklë 'ö ‑dhidhaapë ‑nu 'wo ꞊nɛ 'yö ‑an ‑kë ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","'Lüyanmɛ gbö ꞊nɛ 'yaa ‑mü ‑a? Mali 'yaa ‑mü ‑a dhe 'ka a? Zakö 'dhö, Zozɛfu 'dhö, Simɔ 'dhö, Zude 'dhö 'waa ‑mü ‑a dheglu 'në gɔɔn‑ ‑nu 'ka a? ");
INSERT INTO dnj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'Iin ‑a dheglu 'në dhoo ‑nu 'waa kwa 'piö zö ꞊a? ‑Kɔ ‑mɔ 'wun ‑bha ‑sü 'yö‑ ‑gɔ ꞊nɛ 'yö go ‑a 'ka më ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","'Wun ‑nu 'wo ꞊nɛ ‑a ‑wun 'gü waa Yesu ‑wo ‑dhɛ 'wun gia‑. ꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «‑Wo ‑Zlan ‑wodhiölomɛ ꞊bhlë ‑ya ‑dhɛ 'saadhö 'gü, 'kɛɛ ‑a 'kpɔ ‑pö 'gü ‑mɛ ‑nu waa‑ ‑a ‑gɔ 'kɔɔmɛ ‑nu 'waa‑ ꞊bhlë ‑ya.» ");
INSERT INTO dnj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","‑Dhɛ bhë Yesu yaa ‑dhidhaa ‑kë mü ꞊va zlöö, ‑zo ‑yö ‑a ‑bha ‑sü yaa kë ‑an ‑gɔ bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","'Töng 'dhö bhë ‑a 'ka, Elɔdö ‑yö ‑kë ‑gludë 'ka Galile ‑sɛ 'gü, ‑yö Yesu ‑wun ‑ma. ");
INSERT INTO dnj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'Yö‑ pö ö bha yuökëmɛ ‑nu ‑dhë: «Mɛ 'ö ꞊nɛ Zan Batisö ‑mü, bhii 'go 'ö‑ wo ga 'gü bhë, 'yö ‑kɔ ‑mɔ 'wun ‑bha ‑sü 'dhö ‑a ‑gɔ 'yö ‑dhidhaapë ‑nu kë ‑na bhë.» ");
INSERT INTO dnj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kë‑ wo 'dhö bhë 'ö tɔɔ Elɔdö ‑yö Zan ‑kun, 'ö‑ ‑lö 'ö‑ ‑zuö ‑kanso 'gü. ‑A kë 'ö‑ wo 'dhö bhë ‑yö ‑sü Elɔdö ‑bha ö dheglu Filipö bɔɔ Elɔdiadö 'kun 'ö‑ wo ‑a ‑gɔ bhë ‑a ‑wun ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","'Yö‑ ‑wun 'gü, 'ö Zan ‑ya pö ‑a ‑dhë ꞊nɛɛ 'yaa ‑së kö ‑yö ö 'zlaa‑ bɔɔ 'kun ‑a ‑gɔ kö ‑ya 'sü ö bɔɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","‑A ‑wun 'gü Elɔdö ‑ya 'piö kö ‑yö Zan zë, 'kɛɛ ‑yö ‑suö 'sɛgümɛ ‑nu ‑dhë, bhii 'ö tɔɔ mɛ 'plɛ ‑wo Zan ‑dɔ ꞊nɛ ‑Zlan ‑wodhiölomɛ ‑mü. ");
INSERT INTO dnj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","꞊Dhɛ 'ö Elɔdö ‑bha bhɔ ‑yi 'wlaan‑ kë ‑yi ꞊ya ‑lo, Elɔdiadö 'dhu ‑yö ꞊troo' do kë mɛ ‑nu 'wo nu 'wlaan‑ ‑ta bhë ‑an 'dhiö, 'yö ‑kë Elɔdö ‑dhë ‑së. ");
INSERT INTO dnj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'Yö ö ‑wo ‑bhö ‑a ‑dhë ‑a pö ‑a ‑dhë ‑sü 'ka ꞊nɛ pë 'saadhö 'ö‑ ‑dhɛ ö ‑gɔ, 'ö dho ‑a nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'Nëdhezë 'ö bhë, ‑wo 'ö‑ dhe ‑ya pö ‑a ‑dhë bhë, 'yö dɔ ‑a ‑ta 'ö‑ pö: «‑Dhɛ do 'ö ꞊nɛ ‑a 'gü, a‑ 'piö kö 'ü Zan Batisö ‑gɔ ‑da 'tia‑ 'gü 'ü n gbaa.» ");
INSERT INTO dnj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Yö ‑kë ‑gludë Elɔdö ‑dhë yaa; 'kɛɛ ö ‑wo 'ö‑ ‑bhö mɛ ‑nu 'ö ‑an ꞊dhɔɔ ‑kë 'wlaan‑ ‑ta ‑an 'dhiö bhë ‑a ‑wun 'gü, 'yö‑ pö ö ‑bha mɛ ‑nu ‑dhë ‑wo nu Zan Batisö ‑gɔ 'ka ‑a ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","'Ö mɛ do bɔ ‑kanso 'kɔɔdhö kö ‑yaan Zan Batisö ‑gɔ 'kan. ");
INSERT INTO dnj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'Ö mɛ 'ö bhë 'ö dho 'ö Zan ‑gɔ 'kan 'ö nuë 'tia‑ do 'gü 'ö‑ nu 'nëdhezë 'ö bhë ‑a ‑dhë, 'ö dhoë ö dhe ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","'Ö Zan ‑bha ꞊guë' ‑nu ‑wo nu 'wo‑ ꞊glöö sü, 'wo dhoë 'wo‑ ‑bin. ꞊Dhɛ ꞊ya kë 'dhö, 'wo dho, 'wun ‑nu bhë 'saadhö 'wo‑ ꞊blɛɛ Yesu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","꞊Dhɛ Yesu ‑yö 'wun ‑nu 'wo bhë ‑an ma, 'yö go ‑dhɛ 'ö bhë ‑a ‑bha, 'yö ‑da 'yitagɔ do 'gü ö ‑de 'sloo 'ka, 'yö dho ‑dhɛ do 'ö dho ‑potaasü yö ‑a ‑dhɛ ‑bha ‑a 'gü. 'Kɛɛ mɛ ‑nu ‑wo Yesu ‑wun ‑ma, 'wo go pödhɛ ‑nu 'gü 'wo ‑ziö ‑a 'piö 'ta 'sü ‑sü 'ka 'yi 'kpong 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu ‑bha ‑go 'yitagɔ 'gü ‑sü 'ka, ‑a 'yan ‑yö ‑da mɛ ‑nu 'wo nu bhë ‑an ‑ta, 'ö ‑an 'yena ‑yö ‑da ‑a ꞊zuö' 'gü, 'ö yö ‑an ‑bha 'yua ‑nu bo ‑an ‑bha ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","꞊Dhɛ 'ö 'yinia ‑dhɛ ꞊ya dɔ, 'ö Yesu ‑bha ꞊guë' ‑nu ‑wo ꞊yɔɔn ‑a ‑bha, 'wo‑ pö ‑a ‑dhë: «'Bin ꞊ya 'më 'saadhö, 'ö ‑dhɛ 'kwa‑ ‑bha ꞊nɛ mɛ gbɛ 'yaa zö ꞊nɛ, ‑bhö ‑a pö mɛ ‑nu 'wo ꞊nɛ ‑an ‑dhë ‑wo 'dho pödhɛ ‑nu 'gü kö ‑waan wo ‑bhöpë ‑nu 'dhɔ!» ");
INSERT INTO dnj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «'Yaa ‑së kö ‑wo 'dho; ka gia‑, ‑ka ‑bhöpë nu ‑an ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","'Yö 'wo‑ pö ‑a ‑dhë: «Pë 'ö yi ‑gɔ zö 'ö tɔɔ ꞊bluu'‑ bhɛ 'sɔɔdhu waa‑ 'yuö‑ ꞊plɛ!» ");
INSERT INTO dnj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka nu ‑an 'ka n ꞊dhia zö!» ");
INSERT INTO dnj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö mɛ ‑nu 'wo bhë ‑an ‑dhë ‑wo ꞊yaannu 'kpaa‑ ‑ta. 'Go mü 'yö ꞊bluu'‑ bhɛ 'sɔɔdhu waa‑ 'yuö‑ ꞊plɛ 'wo bhë ‑an sü, 'yö ö 'yan ꞊luu dhang‑ 'gü, 'yö ꞊bhɛa ‑a ‑ta; 'ö ‑Zlan zuö pö. 'Yö ꞊bluu'‑ ꞊kaan, 'yö‑ nu ö ‑bha ꞊guë' ‑nu ‑dhë. 'Wo‑ ‑glu mɛ ‑nu 'wo bhë ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mɛ 'ö ‑dhö ‑yö pë ‑bhö, 'ö ‑bhöpë 'bhaa ‑yö to. 'Ö‑ ‑bha ꞊guë' ‑nu ‑wo dho ‑a 'kluklu ‑nu 'wo to 'wo‑ ‑kpa 'kuë‑ ‑sü ꞊kpasɛn pa ‑sü 'gɔɔ‑ do ö ga ꞊plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gɔɔn‑ ‑nu 'wo ‑bhöpë ‑bhö 'dhö bhë ‑an ‑dho 'kuë‑ ‑sü ꞊tɛi' ‑wo ‑kë ꞊nɛ mɛ ‑vuu 'sɔɔdhu 'dhö kö waa dhoo ‑nu waa‑ 'në ‑nu ‑an ꞊dhong'. ");
INSERT INTO dnj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","꞊Dhɛ 'ö ꞊wa yën, ‑dhɛ do bhë ‑a 'gü 'ö Yesu ‑yö ö bha ꞊guë' ‑nu ‑da 'yitagɔ 'gü kö ‑waan 'yipuë ꞊va bhë ‑a 'kan ö 'dhiö, kö yö gia‑ ‑yaan ‑a pö mɛ ‑nu 'wo bhë ‑an ‑dhë ‑wo 'yɛ wo 'zü ‑wo 'dho wo ‑gɔ plöö. ");
INSERT INTO dnj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","꞊Dhɛ 'ö yën ‑an 'paan bho ‑sü ‑bha, 'ö yö ‑de 'pö, 'ö ‑da ‑tɔn 'në do tuö, 'yö ‑ya ꞊bhɛa' ‑sü ‑bha 'töng bhë ‑a 'ka. Yö do 'kpaan 'yö ‑kë mü, kö ‑dhɛ ꞊ya trö. ");
INSERT INTO dnj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'Yitagɔ 'ö‑ ‑bha ꞊guë' ‑nu ‑wo ‑kë ‑a 'gü bhë, ꞊dhɛ 'ö ꞊ya bhɔ 'kpong ‑dhë ꞊taa' ꞊gbiin, 'yö 'yi kpö ‑nu ‑wo yö ꞊luu' ‑sü ‑bha ‑dhɛ 'plɛ 'gü 'wo ‑ma ‑an ‑bha 'yitagɔ ‑bha ‑dhɛ 'plɛ 'gü, bhii 'ö tɔɔ 'buu ‑yö ‑kë ziö ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","꞊Dhɛ 'kwa dɔ ‑dhɛkpaɔtadhɛ ꞊tɛi' 'ka, 'yö Yesu ‑yö ‑dho ö bha ꞊guë' ‑nu 'piö ꞊zian', ‑ta 'yi ‑ta ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","'Kɛɛ ꞊dhɛ 'wo‑ yö kö ‑yö 'ta ‑na 'yi ‑ta, 'ö 'siö ‑yö ‑kan ‑an 'gluu 'wo‑ pö: «꞊N nn, mɛ ‑zii 'ö kë ‑na bhë!» ꞊Dhɛ 'suö 'dhö ‑an kë ‑na, 'wo yö ꞊gblaa 'gbla ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","'Yö to mü, 'ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka ka ꞊zuö' kë ‑saa, ma ‑mü, kö ꞊kun 'ö 'ka ‑suö!» ");
INSERT INTO dnj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","'Ö Piɛɛ ‑ya pö: «N Dëmɛ, ꞊ya kë ꞊nɛ bhi ‑mü, kö ‑a pö n ‑dhë 'a 'ta 'sü 'yi ‑ta, 'a nu ü 'piö!» ");
INSERT INTO dnj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö nu!» 'Ö Piɛɛ ‑yö go 'yitagɔ 'gü, 'ö yö 'ta 'sü ‑sü 'gü 'yi ‑ta 'ö dhoë Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'Kɛɛ ꞊dhɛ ꞊ya yö ‑dhɛ 'bhaa 'gü, 'ö‑ ‑zo ‑to 'buu 'ö ziö ‑na bhë ‑a 'piö, 'ö 'suö ‑yö ‑da ‑a 'gü. ꞊Dhɛ 'ö 'më ‑na yiö, 'ö ‑gbla 'ö‑ pö: «N Dëmɛ, ‑bhö nu n ‑dhë ‑ɛ!» ");
INSERT INTO dnj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Ö to mü, Yesu ‑yö ‑ya ‑a ‑kɔ ‑bha, 'ö‑ pö ‑a ‑dhë: «Ü ‑bha ‑zo yö ‑sü ‑yö 'tee ꞊dhɛɛ! ‑Më 'ö ‑kë 'ö ü ꞊zuö' ‑yö 'zëzë ꞊kun ꞊i?» ");
INSERT INTO dnj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","꞊Dhɛ 'wo‑ ‑bha ꞊plɛ ꞊dhɛ 'wo ‑da 'yitagɔ 'gü, 'ö 'buu ‑yö to mü 'yö ꞊gbaannu. ");
INSERT INTO dnj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu ‑wo ‑gblü ‑a 'dhiö 'yitagɔ 'gü mü, 'wo‑ pö ‑a ‑dhë: «‑Zlan Gbö giagia ‑mü ü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","'Yipuë ꞊va bhë ‑wa ‑kan 'wo yö sia‑ Zenezalɛtö ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mɛ ‑nu 'wo zian bhë ‑a 'ka, ‑wo ‑to mü, 'wo Yesu dɔ. 'Ö‑ ‑bha nu ‑sü bhë, 'wo‑ ꞊blɛɛ ‑dhɛ 'plɛ 'gü; 'ö mɛ ‑nu 'wo nu wo ‑bha 'yuamɛ ‑nu 'ka‑ 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","‑Dhɛ bhë ‑a 'gü 'zü, 'wo ꞊bhɛa ‑a ‑dhë kö ‑yö ö ꞊kwaa' wo ‑zü 'wo 'pa ‑a ‑bha gblang 'to 'dhiö 'kpaan 'ka; ('ö ‑we ‑a ‑bha ‑an ‑gɔ,) 'ö mɛ ‑nu 'wo pa ‑a ‑bha gblang 'to 'dhiö 'ka, 'ö ‑an ‑dhɛ ‑yö bo. ");
INSERT INTO dnj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Falizi ‑mɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu ‑wo ‑go Zeluzalɛmë 'wo nu Yesu 'piö, 'wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«‑Më ‑kë 'ö mɛ ꞊daan' ‑wo 'ö go kwa 'bhɛma ‑nu dhiö ꞊nɛ, ü bha ꞊guë' ‑nu 'waa‑ 'kun ꞊nɛ ꞊ɛ? Bhii 'waa wo ‑kɔ ‑nu 'zlu ꞊nɛ ‑kɔ 'ö kwa ‑bha wɔ ‑kɔ 'dhoë‑ 'ka bhë ‑a 'dhö kö ‑waan ꞊tun pë ‑bhö ‑na.» ");
INSERT INTO dnj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ ꞊nɛɛ: «Ka ‑de 'pö, ‑më ‑kë 'ka ‑Zlan ‑bha tɔng ꞊bhlë ‑siö ka ‑de ‑bha mɛ ꞊daan' ‑wo 'kun ‑sü ‑wun 'gü i? ");
INSERT INTO dnj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","'Ö tɔɔ ‑Zlan ‑ya ‑pö: ‑Bhö ü dë waa‑ ü dhe ‑an ꞊bhlë ‑ya, 'ö go mü: Mɛ 'ö 'dhoë‑ 'wun yaa ꞊blɛɛ'‑ ö dë waa‑ ö dhe ‑an 'ka, ‑yö ‑dho kë zëmɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'Kɛɛ ka ‑zë, ka mɛ ‑nu ‑daan ‑a pö ‑sü 'ka: 'Ö ꞊ya kë ꞊nɛ mɛ ꞊yaa‑ pö ö dë waa‑ ö dhe ‑an ‑dhë: ‹Ma pë ‑nu 'wo n ‑gɔ 'a dho nu ‑a 'ka ü ‑dhë ‑be bhë, 'ma‑ ‑ya ‑Zlan ‑bha gbaɔ 'ka›, ");
INSERT INTO dnj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","gɔɔn‑ 'ö 'dhö kö 'yaa‑ nu ö mɛ ‑nu ‑dhë gbɔ. ‑Kɔ do 'ö bhë ‑a 'ka, ka ‑Zlan ‑wo ꞊bhlë ‑bho ‑a ‑bha, 'ka‑ ꞊siö, 'ö ka ‑de ‑bha mɛ ꞊daan' ‑wo bhë 'ka‑ ‑zɔn mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mɛ ‑nu 'yan ‑ta ‑pë kë ‑mɛ ‑nu 'ka ꞊nɛ! 'Wun 'ö ‑gban ka ‑bha 'ö Ezai ‑ya ꞊blɛɛ bhë 'wun gia‑ ‑mü. ");
INSERT INTO dnj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Ö tɔɔ: ‑Zlan ‑ya pö: 'Sɛgɔgümɛ ‑nu 'wo ꞊nɛ ‑wo n ꞊bhlë ‑ya wo 'dhi 'ka 'kpaan, 'kɛɛ ‑an ꞊zuö' ‑yö n 'ka ꞊gbiin. ");
INSERT INTO dnj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","꞊Bhlëyadhe ‑nu 'wo nu ‑na ‑a 'ka n 'piö, ‑a 'plɛ ‑yö 'kpaan, bhii ‑wo mɛ ‑nu ‑daan tɔng 'ö go mɛ ‑nu dhiö ‑an 'ka ꞊nɛ ‑kɔ 'wo‑ pö ‑a ‑bha 'kpa ‑yö ‑go ma ‑Zlan n 'piö ‑a 'dhö. » ");
INSERT INTO dnj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö mɛ gbung ꞊va ꞊dhɔɔ ‑kë, 'yö‑ pö ‑an ‑dhë: «‑Ka ka 'to 'to, kö 'wun 'a 'dhoë‑ ‑a ꞊blɛɛ'‑ ꞊nɛ, 'kaan‑ ‑a ma ö ‑gɛn 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Pë 'ö ‑da ‑na mɛ 'dhii bhë, 'yaa mɛ kë ‑dhuuzë. Pë 'ö mɛ ‑kë ‑dhuuzë 'ö tɔɔ pë ‑nu 'saadhö 'wo 'go ‑na mɛ 'dhii.» ");
INSERT INTO dnj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo ꞊yɔɔn ‑a ‑bha, 'wo‑ pö ‑a ‑dhë: «'Bhaa‑ dɔa ꞊nɛ ü ‑wo 'ö bhë ‑yö ‑na Falizi ‑mɛ ‑nu ‑zuë ‑a?» ");
INSERT INTO dnj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","'Ö‑ ‑daa ‑kë ‑an ‑gɔ ꞊nɛɛ: «Tapë 'saadhö 'ö n Dë 'ö dhang‑ 'gü yaa‑ ta, ‑an 'plɛ ‑wo ‑dho ‑wo, 'wo go 'sɛi. ");
INSERT INTO dnj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","‑Ka ka ꞊kwaa' ‑an ‑zü, ‑yö mɛ ‑dhë 'dhiö ‑mɛ 'yënngtiizë ‑nu ‑mü ‑an 'ka! ꞊Ya kë ꞊nɛ 'yënngtiimɛ ꞊ya yö 'yënngtiimɛ ‑dhë 'dhiö, ‑dhɛ 'wo‑ ‑bha ꞊plɛ, ‑wo ‑dho ‑püö ‑glu 'dhi do 'gü!» ");
INSERT INTO dnj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","'Ö Piɛɛ ‑ya pö ‑a ‑dhë: «‑Bhö 'wun ꞊zuan' bhë ‑a ‑gɛn pö yi ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'Ö Yesu ‑ya pö ‑an ‑dhë: «Ka ‑de 'pö, ka ‑kɔ yaa ‑mɔ 'wun ‑gɛn ma ‑sü ‑bha ꞊kun ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kaa‑ ma ꞊nɛ ‑bhöpë 'ö ‑da ‑na mɛ 'dhii bhë, ‑yö ‑bɔ mɛ 'guu ꞊zian' 'ö dhoë 'blü 'dhiö a? ");
INSERT INTO dnj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'Kɛɛ ‑a mɛ 'ö 'go ‑na mɛ 'dhii bhë, ‑yö ‑go mɛ ꞊zuö' 'piö, yö ꞊nɛ 'ö mɛ ‑kë ‑dhuuzë. ");
INSERT INTO dnj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bhii mɛ ꞊zuögüdhɛ ꞊nɛ 'ö ‑zotadhe yaa ‑nu 'wo go ‑a 'gü, 'wo mɛ ‑blü mɛ zë ‑sü ‑nu, dhebɔ 'kpɛɛkpɛ ꞊mɛɛ' ‑sü ‑nu, ꞊mlaabɔ 'kpɛɛkpɛ ꞊mɛɛ' ‑sü ‑nu, ꞊kwaan ‑sü ‑nu, ꞊sua kë ‑sü ‑nu, 'wun yaa ‑blɛɛ mɛ ‑gɔ ‑sü ‑nu ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Pë ‑nu 'wo mɛ ‑nu ‑kë ‑dhuuzë 'wo bhë, 'kɛɛ pë ‑bhö ‑sü kö waa wo ‑kɔ 'zlu ꞊nɛ ‑kɔ 'ö kwa 'bhɛma ‑nu ‑bha wɔ ‑kɔ 'dhö ‑a 'ka ‑a 'dhö bhë, 'yaa mɛ kë ‑dhuuzë.» ");
INSERT INTO dnj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","'Go mü Yesu ‑yö ‑go ‑dhɛ bhë ‑a 'gü, 'yö dho Tii waa‑ Sidɔn ‑pö 'gü ‑dhɛ ‑nu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dhebɔ do 'yö go Kanaa ‑sɛ 'gü, 'yö ‑kë 'sɛ bhë ‑a 'gü, ‑yö ‑nu Yesu 'piö, 'yö‑ pö ‑a ‑dhë 'gbla ‑sü 'ka ꞊nɛɛ: «N Dëmɛ, Davidö gbö, ‑bhö n 'yena yö! ‑Zuu yaa ‑yö n 'dhu 'gü. 'Yaa ‑potaasü ꞊duö!» ");
INSERT INTO dnj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'Kɛɛ yaa‑ ‑daa do kë ‑a ‑gɔ. 'Ö‑ ‑bha ꞊guë' ‑nu ‑wo ꞊yɔɔn ‑a ‑bha 'wo‑ pö ‑a ‑dhë: «Dhebɔ 'ö ꞊nɛ, ‑bhö ‑a kë ‑yö 'dho; ‑yö ziö ‑na kwa 'piö 'gbla ‑sü 'ka ‑kplawo!» ");
INSERT INTO dnj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'Ö Yesu ‑ya ‑pö ‑an ‑dhë: «‑Zlan ‑yö n ‑bɔ 'bhla ‑tuë ‑nu 'wo ꞊dhɔng ‑sü 'ka Izlaɛlö ‑sɛ 'gü ‑an ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","'Ö dhebɔ 'ö bhë ‑yö ‑nu 'ö ‑püö Yesu ꞊gɛɛndhö 'ö‑ pö: «N Dëmɛ, ‑bhö nu n ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'Ö Yesu ‑ya pö ‑a ‑dhë: «'Yaa ‑së kö ‑wo 'në ‑nu ‑bhöpë 'sü ‑waan ‑a nu gbɛn‑ ‑nu ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","'Ö dhebɔ bhë 'ö‑ pö: «'Wun gia‑ ‑mü, n Dëmɛ, 'kɛɛ ꞊ya kë ‑bhöpë 'peepee ‑nu 'wo 'go ‑na pë ‑bhö ‑ta ꞊gba ‑ta dhuö bhë, gbɛn‑ ‑nu ‑wa ‑bhö.» ");
INSERT INTO dnj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","'Ö Yesu ‑ya pö ‑a ‑dhë: «'Öö, dhebɔ, ü ‑bha ‑zo ‑yö n ‑ma ‑sü ꞊yö ꞊va 'dhɛ! ‑Yö kë ü ‑dhë ꞊nɛ ‑kɔ 'ö‑ 'ka ü ꞊zuö' 'piö bhë ‑a 'dhö!» 'Töng gia‑ bhë ‑a 'ka 'ö‑ 'dhu ‑dhɛ ‑yö boë. ");
INSERT INTO dnj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ‑yö ‑go mü, 'yö dho Galile 'yipuë ꞊va 'kpong 'dhiö, 'yö ‑da ‑tɔn do tuö 'ö ꞊yaannu. ");
INSERT INTO dnj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mɛ ‑gbaa ꞊va ‑wo ‑nu ‑a 'piö mü 'zü, wo ‑bha ‑gɛnlomɛ ‑nu, 'yënngtiimɛ ‑nu, ꞊niɔɔmɛ ‑nu, 'tuunmɛ ‑nu waa‑ 'yuamɛ ‑nu ꞊plëëzë ‑an 'ka Yesu 'piö, 'ö Yesu ‑yö ‑an ‑dhɛ bo, ");
INSERT INTO dnj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","kö 'tuunmɛ ‑nu ‑wo 'we ‑na, 'tɔsiömɛ ‑nu ‑dhɛ ‑yö bo ‑na, 'yënngtiimɛ ‑nu ‑wo ‑dhɛ yö ‑na bhë. ꞊Dhɛ ꞊waa‑ yö, 'ö 'tetundhe ‑yö ‑da ‑an 'gü, 'ö 'wo yö Izlaɛlö ‑bha ‑Zlan 'tɔ ‑blü ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu ‑yö ö bha ꞊guë' ‑nu ꞊dhɔɔ ‑kë, 'ö‑ pö ‑an ‑dhë: «Mɛ ‑nu 'wo ꞊nɛ ‑an 'yena ‑yö n kë ‑na, bhii ‑a ‑dhɛkpaɔyi ‑yaaga 'ö ꞊nɛ ꞊dɛɛ, ‑wo n 'piö, 'ö ‑bhöpë gbɛ 'yaa ‑an ‑gɔ gbɔ; 'maa‑ 'piö kö 'a n ꞊kwaa' ‑an ‑zü ‑wo 'dho kö waa pë gbɛ ‑bhö. ꞊Faan' 'yaa ‑an 'gü gbɔ bhë, ꞊ya kë 'dhö, ‑wo ‑dho ‑püö zian ‑gbloo ‑nu 'piö ‑an ‑yɛ 'zü ‑sü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","'Ö‑ ‑bha ꞊guë' ‑nu ‑wa ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑Dhɛ ‑mlë 'kwa dho mɛ gbung ꞊va ꞊suu'‑ 'ö ꞊nɛ ‑a ‑bhöpë yö ‑a ‑bha; ‑dhɛ 'ö mɛ gbɛ 'yaa‑ ‑bha zö ꞊nɛ ‑a 'gü i?» ");
INSERT INTO dnj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «꞊Bluu'‑ bhɛ ꞊dhë 'yö ka ‑gɔ ‑ɛ?» 'Wo‑ pö ‑a ‑dhë: «꞊Bluu'‑ bhɛ 'slaplɛ waa‑ 'yuö‑ 'në 'sɛɛn‑ 'bhaa ꞊nɛ 'wo yi ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö mɛ gbung ‑nu 'wo bhë ‑an ‑dhë ‑wo ꞊yaannu. ");
INSERT INTO dnj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'Ö ꞊bluu'‑ bhɛ 'slaplɛ waa‑ 'yuö‑ ‑nu 'wo bhë 'yö ‑an sü, 'yö ‑Zlan zuö pö ‑a ‑ta, 'yö ‑an ꞊kaan, 'ö‑ nu ö bha ꞊guë' ‑nu ‑dhë, 'ö 'wo‑ ‑glu mɛ 'wo nu bhë ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mɛ 'ö ‑dhö ‑yö pë ‑bhö, 'ö‑ 'gu ‑yö dɔ, 'ö‑ 'kluklu ‑nu ‑wo to. 'Yö‑ ‑bha ꞊guë' ‑nu ‑wo dho 'wo‑ 'kluklu ‑nu 'wo bhë 'wo ‑an ‑kpa 'kuë‑ ‑sü ꞊kpasɛn pa ‑sü 'slaplɛ sü 'wo ꞊zië'. ");
INSERT INTO dnj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mɛ ‑nu 'ö ‑bhöpë bhë 'wo‑ ‑bhö ‑an ‑dho 'kuë‑ ‑sü ‑wo ‑mɔ gɔɔn‑ ‑nu ‑vuu ‑yiisië ‑bha kö waa dhoo ‑nu, 'në ‑nu ‑an ꞊dhong'. ");
INSERT INTO dnj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","꞊Dhɛ 'ö Yesu ꞊ya ö ‑kwaa ‑an ‑zü, 'yö ‑da 'yitagɔ 'gü, 'yö dho Magadamë ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Falizi ‑mɛ ‑nu waa‑ Saduse ‑mɛ ‑nu ‑wo ‑nu Yesu 'piö kö ‑waan 'slë 'kan ‑a ‑gɔ, 'wo‑ pö ‑a ‑dhë ‑yö ‑dhidhaapë do kë wo ‑dhë, kö ‑yaan ‑zɔn wo ‑dhë ꞊nɛ ‑a ‑bha ‑kɔ ‑mɔ 'wun ‑bha ‑sü ‑yö ‑go ‑Zlan 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","'Kɛɛ Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Lan‑ ꞊ya ‑püö, dhang‑ 'gü ‑dhɛ ꞊ya kë 'zɛnzɛnzë, 'ö 'ka‑ pö: ‹‑Dhɛ ‑dho po ꞊dhia 'piö ‑së.› ");
INSERT INTO dnj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'Ö ‑dhiadhiö tii 'gü, ‑dhɛ ꞊ya kë ‑gisaadhö, 'ka‑ pö: ‹Dha ‑yö 'dhoë‑ nu›. Pë ‑nu 'wo dho kë dhang‑ 'gü 'dhö, ka ‑an ꞊dɔa' ‑dɔ, ꞊dhɛ ‑kë 'dhö ꞊nɛ ‑më ‑kë 'ö ka ‑kɔ 'yaa ‑mɔ ‑a ‑bha kö ꞊duakëpë ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü bhë, 'ka ‑an ‑bho 'kou dɔ ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mɛ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü 'ö ‑an këpë 'dhö yaa, 'ö 'waa 'to wo ‑wo 'gü ‑Zlan ‑dhë bhë ‑wo ‑dhidhaapë do ‑dhɛ, 'kɛɛ ‑dhidhaapë gbɛ 'ka 'dho kë ‑an ‑dhë ‑a 'ke yaa kë Zonasö ‑bha ‑dhidhaapë 'ka.» ꞊Dhɛ 'yö‑ pö 'dhö, 'ö to mü 'ö ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu ‑bha ꞊guë' ‑nu ‑zlö ‑yö ‑trö ꞊bluu'‑ ‑nu 'sü ‑sü ‑bha. ꞊Dhɛ 'ö 'yipuë ꞊va bhë ꞊waa‑ 'kan ꞊wa 'dho ‑a ꞊zlöö, ");
INSERT INTO dnj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka ka ‑zo kë ka ‑de 'piö, Falizi ‑mɛ ‑nu waa‑ Saduse ‑mɛ ‑nu ‑an ‑bha ꞊bluubhɛɛpë ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo yö 'wun ꞊blɛɛ'‑ ‑sü 'gü wo 'ko ziën ꞊nɛɛ: «꞊Bluu'‑ 'ö kwaa ‑a 'sü bhë, 'yö‑ ‑wun 'gü 'yö ‑wo 'ö bhë 'yö‑ ꞊blɛɛ'‑ ‑na bhë.» ");
INSERT INTO dnj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","꞊Dhɛ 'ö Yesu ꞊yaa‑ yö ꞊nɛ ‑wo ꞊suu'‑ bhë ‑wa ꞊blɛɛ'‑ ‑na wo 'ko ‑dhë, 'yö‑ pö ‑an ‑dhë: «‑Më ‑kë 'ka‑ pö ka 'ko ziën ꞊nɛ ꞊bluu'‑ 'ö kaa‑ 'sü bhë yö ‑mü ‑i? ꞊N nn, ka ‑bha ‑zo ‑yö n ‑ma ‑sü ‑yö ꞊tun 'tee ꞊dhɛɛ! ");
INSERT INTO dnj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","10","Kaa‑ 'wun dɔ ꞊kun ꞊a? Ka ‑zo 'pö yaa ‑büö ꞊kun ꞊bluu'‑ bhɛ 'sɔɔdhu 'a ‑an ꞊kaan 'ö gɔɔn‑ ‑nu ‑vuu 'sɔɔdhu ‑dhë, 'wo‑ ‑bhö, 'ö‑ 'kluklu ꞊kpasɛn 'bhaa ‑nu 'wo to 'ka ꞊zië' bhë o, waa‑ ꞊bluu'‑ bhɛ 'slaplɛ 'a ‑an ꞊kaan gɔɔn‑ ‑vuu ‑yiisië, ‑wa ‑bhö, 'ö ‑an 'kluklu ꞊kpasɛn 'bhaa ‑nu 'wo to, 'ka ꞊zië' bhë, ka ‑zo yaa ‑büö ‑a ‑wun 'ka ꞊kun ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","‑Më 'yö ‑kë 'kaa‑ dɔa ꞊nɛ n 'ka ꞊bluu'‑ ‑gɔ ‑wun ꞊blɛɛ'‑ ‑ɛ? 'Kɛɛ pë 'a‑ 'piö 'ö tɔɔ 'ka ka ‑zo kë ka ‑de 'piö, Falizi ‑mɛ ‑nu waa‑ Saduse ‑mɛ ‑nu ‑bha ꞊bluubhɛɛpë ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","꞊Dhɛ ‑kë 'dhö zlöö, 'ö‑ ‑bha ꞊guë' ‑nu ‑wa ma ꞊nɛ Yesu yaa‑ pö ‑wo wo ‑zo kë wo ‑de 'piö ꞊bluubhɛɛpë ‑wun 'gü, 'kɛɛ ‑wo wo ‑zo ‑kë wo ‑de 'piö Falizi ‑mɛ ‑nu waa‑ Saduse ‑mɛ ‑nu ‑bha mɛ ꞊daan' ‑wo ‑gɔ ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","꞊Dhɛ ꞊wa 'go mü, Yesu waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑dho 'sɛgɔ do 'bhaa 'yö ‑kë Sezale Filipö bhë ‑a 'gü. ‑Wo ‑kë 'dho ꞊dhia, 'ö ö ‑bha ꞊guë' ‑nu ꞊dhɛɛ' kpɔ 'ö‑ pö: «Mɛ ‑nu ‑wa ‑pö dö ‑mü ma Mɛgbö n 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","'Wo‑ ‑daa ‑kë ‑a ‑gɔ ꞊nɛɛ: «Mɛ 'bhaa ‑nu ‑wa ‑pö Zan Batisö ‑mü ü 'ka, mɛ 'bhaa ‑nu ‑wa ‑pö Eli ‑mü ü 'ka, 'ö mɛ 'bhaa ‑nu ‑wa ‑pö 'zü Zelemi 'iin ‑Zlan ‑wodhiölomɛ gbɛ ‑mü ü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","'Ö Yesu ‑ya pö ‑an ‑dhë: «꞊Ao', ka 'pö, ka‑ ‑pö dö ‑mü n 'ka ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","'Ö Simɔ Piɛɛ ‑ya pö ‑a ‑dhë: «‑Zlan 'ö 'bhee‑ ü‑ ‑bha ‑Yamɛ 'ka, 'ü‑ Gbö 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü ‑bha ꞊yö ‑së ꞊dhɛɛ, Simɔ, Zan gbö. Bhii mɛ 'bhee‑ ‑lü kun 'yö 'wun gia‑ 'ö ꞊nɛ 'ö‑ ‑zɔn ü ‑dhë, 'kɛɛ n Dë 'ö dhang‑ ‑nu 'gü bhë yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","꞊Dhɛ 'ö 'pö, ma ‑zë, a‑ ‑pö ü ‑dhë: Bhi ü tɔɔ Piɛɛ, (‑a ‑gɛn 'ö tɔɔ «‑guö»). ‑Guö 'ü‑ 'ka bhë 'a dho ma ‑Zlan ‑bha 'kɔ dɔ ü ‑ta. Ga ‑bha ‑kɔ ‑mɔ 'wun ‑bha ‑sü gia‑ ‑de yaa 'dho pë gbɛ kë 'kɔ 'a 'dhoë‑ dɔ bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","A ‑dho ‑Zlan ‑bha ‑gludëdhɛ ‑pö ꞊lakele nu ü ‑dhë. Pë 'ü 'dhoë‑ 'kɔdhi ta ‑a ‑gɔ 'kpongtaa zö kö ‑yö ‑ta ‑a ‑gɔ ‑sü 'ka dhang‑ ‑nu 'gü; 'ö pë 'ü 'dhoë‑ 'kɔdhi po ‑a ‑gɔ 'kpongtaa zö, kö ‑yö 'po ‑sü 'ka ‑a ‑gɔ dhang‑ ‑nu 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë kö ꞊kun 'wo‑ pö mɛ gbɛ ‑dhë ꞊nɛ ‑Zlan ‑bha ‑Yamɛ ‑mü ö 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","'Ö sü ‑a yi 'ö 'dhö bhë ‑a ‑bha, Yesu ‑yö ‑yö 'wun ꞊blɛɛ' ‑sü ‑bha ‑a 'gü 'po ‑sü 'ka ö bha ꞊guë' ‑nu ‑dhë ꞊nɛɛ: «A ‑dho dho Zeluzalɛmë; 'ö ‑dhɛ 'ö bhë ‑a 'gü, 'ö mɛ ziizii ‑nu, slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu, ‑wo n 'klo bhɔ giagiawo, 'wo n zë; 'ö‑ ‑dhɛkpaɔyi kë ‑yaaga ‑naa bhë 'a goë ga 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","'Ö Piɛɛ ‑ya ‑dhɛ ö 'sloo 'ka, 'ö‑ pö ‑a ‑dhë: «‑Zlan ‑yö ü 'piö, n Dëmɛ, pë 'ö 'dhö bhë yaa 'dho kë ü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","'Ö Yesu ‑yö ꞊dhië ö ‑zü 'ö ‑ta ‑yö Piɛɛ ‑bha ‑sü 'ka 'yö‑ pö ‑a ‑dhë: «‑Bhö 'go n 'sɔɔ 'ü 'dho ꞊gbiin, Satan, 'ü‑ ꞊mɛɛ' ‑na kö 'üën‑ n ‑püö ꞊sɔɔn yaa 'gü; bhii ü bha ‑zotadhe 'yaa ꞊nɛ ‑Zlan ‑bha 'dhö; 'kɛɛ ‑yö ‑kë ꞊nɛ mɛ 'bhee‑ ‑bha 'dhö ꞊zian'.» ");
INSERT INTO dnj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","'Go mü 'ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «Mɛ 'ö‑ 'piö kö 'ö ziö n 'piö, ‑yö ö ꞊kwaa' ‑zo 'ta ö ‑de ‑wun 'gü ‑sü ‑zü, ‑yö ö ‑bha ‑gaatalü 'sü ‑yö zië n 'piö! ");
INSERT INTO dnj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bhii mɛ 'ö‑ 'piö kö 'ö ö ‑bha ‑tosiadhe yö ö ‑de ‑ta, ‑yö 'ka 'dho ‑a yö; 'kɛɛ mɛ 'ö 'dhoë‑ ö ‑bha ‑tosiadhe 'gü ꞊siö n ‑wun 'gü, ‑yö ‑dho ꞊toëpö ‑këdhösü yö. ");
INSERT INTO dnj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","‑Yö ‑dho yö ‑më ‑bha mɛbheedhɛ ‑gɔ, kö ‑yö 'kpongtaapë 'plɛ yö, 'go mü kö ‑a nii ‑yaan 'kun ꞊toëpö ‑këdhösü yö ‑sü 'ka ɛ? Pë 'bhaa ‑yö ‑dhö kö mɛ ‑ya nu kö ‑yaan ö nii ‑gɔ ‑ta ‑bɔa ‑a? ");
INSERT INTO dnj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'Kɛɛ ma Mɛgbö a ‑dho nu n Dë ‑bha 'tɔbhɔdhe ꞊va 'ka waa‑ ma bɔmɛ ‑nu. ꞊Ya kë 'dhö, mɛ 'ö ‑dhö a ‑dho ‑a ꞊saan' bho ‑a ‑bha yuö kë ‑kɔ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: Mɛ ‑nu 'wo zö ‑an mɛ 'bhaa ‑nu waa 'dho ga kö Mɛgbö ‑bha nu ‑sü kö ꞊ya kë ‑gludë 'ka bhë waa wo 'yan dɔ ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","꞊Dhɛ 'ö ‑dhɛkpaɔyi 'slado ꞊ya ziö, 'ö Yesu ‑yö Piɛɛ 'dhö, Zakö 'dhö waa‑ ö dheglu Zan ‑an kpa ö ‑bha, 'wo dho ‑tɔn do ꞊gbiin tuö wo ‑de 'sloo 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","'Ö Yesu ‑yö ꞊dhië ‑kwaa bun gbɛ 'gü ‑an wö 'dhiö mü; 'ö‑ wöödhɛ ‑yö yö 'bhü ‑sü ‑bha ꞊nɛ lan‑ 'bhü ‑kɔ 'dhö, 'go mü 'ö‑ ‑bha sɔ ‑nu ‑wo ‑kë 'puu ꞊nɛ ‑dhɛpuudhɛ ‑bha 'bhü ‑sü 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","'Ö to mü, 'ö ꞊guë' ‑nu ‑yaaga 'wo bhë 'wo Moizö waa‑ Eli ‑an yö Yesu 'piö mü, kö wo ‑nu ‑wo 'wun ꞊blɛɛ ‑na wo 'ko ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","'Ö Piɛɛ ‑ya pö Yesu ‑dhë: «꞊Ii‑, n Dëmɛ, ꞊yö ‑së kö 'kwa 'to zö; ꞊ya kë ꞊nɛ 'bha 'we ‑a ‑bha, a ‑dho sɔ 'kɔ ‑yaaga dɔ zö, ü ‑bha do, Moizö ‑bha do, Eli ‑bha do.» ");
INSERT INTO dnj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","‑Yö ‑to 'wun ꞊blɛɛ' ‑sü 'gü, 'ö dha kpö 'bhü ‑sü ‑yö nu 'ö sɔ ‑an ‑ta. 'Ö ‑wo do ‑yö bɔ dha kpö bhë ‑a 'gü 'ö ‑we ꞊woë' ꞊nɛɛ: «Mɛ 'ö ꞊nɛ 'ö tɔɔ n Gbö (do 'ö n ‑gɔ) 'ö‑ ‑dhɔ ‑yö n ‑kë, 'ö n ꞊zuögludhi ‑wun 'plɛ 'dho ‑a kwɛɛ. ‑Ka ka 'to 'to ‑a ‑wo ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","꞊Dhɛ 'ö 'wo ‑wo ꞊nɛ 'wo‑ ma, 'ö 'suö ‑yö ‑da ‑an 'gü, 'wo ‑gblü sia‑. ");
INSERT INTO dnj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","'Yö Yesu ‑yö ꞊yɔɔn ‑an ‑bha, 'yö ö ‑kɔ pa ‑an 'ka 'ö‑ pö: «‑Ka ꞊luu'‑, kö ꞊kun 'ö 'suö ‑yö ka ‑kë!» ");
INSERT INTO dnj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","'Wo wo ‑gɔ ꞊luu, 'kɛɛ Yesu dosɛn ꞊nɛ 'wo‑ yö dɔ ‑sü 'ka mü. ");
INSERT INTO dnj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","‑Wo ‑kë ꞊yɔɔ' ꞊dhia kö ‑wo 'go ‑na ‑tɔn tuö, 'ö Yesu ‑ya ‑pö ‑an ‑dhë ꞊nɛɛ: «Kö ꞊kun pë 'ö 'ka‑ yö ꞊nɛ 'ka‑ ꞊blɛɛ mɛ gbɛ ‑dhë, ‑yö 'dho ‑yö yöë ma Mɛgbö n ‑ma ‑go ga 'gü ‑yi ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu ‑wa ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑Më ‑kë 'ö kwa ‑bha tɔnggɔmɛ ‑nu ‑wa pö Eli ‑dho nu 'dhiö ꞊kun ‑i?» ");
INSERT INTO dnj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","'Yö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Yö 'dhö, Eli ‑yö ‑dho nu 'dhiö kö ‑yaan pë 'plɛ 'dho 'ko ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'Kɛɛ a‑ ‑pö ka ‑dhë ꞊nɛɛ: Eli ꞊ya nu 'saadhö, bhii mɛ ‑nu waa‑ dɔ 'ö 'wo 'wun yaa ꞊kaa' ꞊nɛ ‑kɔ 'ö ‑dhi ‑a 'ka ‑an ‑dhë ‑a 'dhö. ‑Kɔ do bhë 'ö 'wo dho ma Mɛgbö n 'klo bhɔa 'pö.» ");
INSERT INTO dnj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'Ö‑ ‑bha ꞊guë' ‑nu ‑wa dɔa ꞊nɛ Zan Batisö ꞊nɛ 'ö‑ ‑bha 'wun ꞊blɛɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","꞊Dhɛ 'ö 'wo nu 'wo ‑lo ‑dhɛ 'wo mɛ ‑gbaa ‑nu to ‑a ‑bha bhë ‑a ‑bha, 'ö gɔɔn‑ do ‑yö ꞊yɔɔn Yesu ‑bha, 'yö ‑lo ö kpɔn 'gü ‑a 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","'Ö‑ pö ‑a ‑dhë: «N ‑Gɔmɛ, ‑bhö n gbö 'yena ‑yö wo! 'Puɛ‑ ‑ya 'yënng bhɔ ‑na ꞊duö. 'Ö ꞊ya kë ‑nu wo 'ö ‑püö siö, 'iin 'ö ‑püö yiö ‑dhɛ ‑nu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'A nuë ü bha ꞊guë' ‑nu ꞊dhia, 'kɛɛ waa ‑mɔ ‑a ‑bha kö ‑waan ‑an ‑dhɛ bo.» ");
INSERT INTO dnj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","'Ö Yesu ‑ya pö ‑an ‑dhë: «'Ö mɛ ‑nu ꞊gɔü' 'gbeezë këwunyaazë, 'töng ‑mlë 'kwa dho kaa kwa 'ko ꞊bhaa ꞊ɛ? 'Iin 'zü 'töng ‑mlë 'a dho ka bun ‑a 'ka ɛ?» 'Yö‑ pö: «‑Ka nu 'në bhë ‑a 'ka n ꞊dhia zö!» ");
INSERT INTO dnj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","'Yö 'wun ‑blɛɛ 'gbee‑ 'ka ‑zuu yaa bhë ‑a 'ka, 'yö go 'në 'ö bhë ‑a 'gü, 'ö‑ ‑dhɛ ‑yö bo ‑dhɛ do bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","꞊Dhɛ ‑kë 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu ‑wo ‑yɔɔn ‑a ‑bha wo 'kuë 'wo‑ ꞊dhɛɛkpɔdhe ‑kë ꞊nɛɛ: «‑Më ‑kë 'ö yi ‑kɔ yaa ‑mɔ ‑zuu yaa 'ö bhë ‑a kë ‑sü ‑bha ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Pë 'ö ‑kë 'dhö bhë 'ö tɔɔ ka ‑bha ‑zoyösü ‑yö 'teete! A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ꞊Ya kë ꞊nɛ ka ‑bha ‑zo yö ‑sü ꞊ya kë ꞊nɛ ꞊kplɔɔ' ga 'dhö, ka ‑dho ‑a pö ‑tɔn 'ö ꞊nɛ ‑a ‑dhë: ‹‑Bhö 'go ü pin 'ö ꞊nɛ ‑a ‑bha 'ü 'dho ‑de!›, ‑yö ‑dho go ö pin ‑bha. Pë gbɛ kë ‑sü yaa 'dho kë ka ‑kwaa 'gbee‑, ");
INSERT INTO dnj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'kɛɛ kë‑ wo 'dhö bhë ‑zuu yaa ꞊suu'‑ 'ö bhë pë 'ö 'kwa dhoë‑ kë kö 'kwaan‑ ‑mɔ ‑a kë ‑sü ‑bha 'ö tɔɔ ꞊bhɛa' ‑sü waa‑ ‑bɛn 'to ‑sü.» ");
INSERT INTO dnj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yi do 'ka kö Yesu waa‑ ö bha ꞊guë' ‑nu 'plɛ ‑wo wo 'ko ꞊bhaa Galile ‑sɛ 'gü bhë, 'ö‑ ‑pö ‑an ‑dhë: «Ma Mɛgbö, ‑wo ‑dho n dɔ mɛ ‑nu kwɛɛ ");
INSERT INTO dnj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","kö ‑waan n zë, 'kɛɛ ‑dhɛkpaɔyi ‑yaaga ‑naa 'ka 'a dho go ga 'gü.» 'Ö‑ ‑bha ꞊guë' ‑nu wö ‑yö ‑siö giagiawo. ");
INSERT INTO dnj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","꞊Dhɛ 'ö Yesu waa‑ ö ‑bha ꞊guë' ‑nu ꞊wa ‑lo Kapɛɛnaɔmë, 'ö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu ‑wo ‑yɔɔn Piɛɛ ‑bha ‑a ꞊dhɛɛ' 'kpɔ ‑sü 'ka ꞊nɛɛ: «Ka ‑gɔmɛ 'yaa ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑bha 'nii‑ ꞊sɔnng' bho ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","'Ö Piɛɛ ‑ya pö: «꞊Ii‑, ‑ya ‑bho.» Piɛɛ ‑yö ‑kë ‑da ꞊dhia kɔɔ, 'yö Yesu ‑ya ‑pö ‑a ‑dhë ꞊nɛɛ: «Ü ü ‑zo ‑ta ‑kɔklë ꞊ɛ, Simɔ? Dö ‑nu 'ö ‑an 'gbee‑ ‑ta bho ‑sü 'dho ‑mü, kö ‑waan 'nii‑ ꞊sɔnng' nu 'kpongtaa ‑gludë ‑nu ‑dhë ‑ɛ? ‑An ‑bha ‑sɛ 'gü 'në ‑nu ‑mü, 'iin ‑nia ‑nu ‑mü e?» ");
INSERT INTO dnj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","'Ö Piɛɛ ‑ya pö ‑a ‑dhë: «‑Nia ‑nu ‑mü.» 'Ö Yesu ‑ya pö: «꞊Dhɛ ‑kë 'dhö bhë, kö 'sɛ 'gü 'në ‑nu ‑zë ‑an ꞊dua' 'yaa ‑mü 'wëü‑ bho ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","'Kɛɛ kö ꞊kun 'kwa mɛ ‑nu 'wo ꞊nɛ 'kwa 'wun ‑na ‑an ‑zuë. ꞊Dhɛ 'dhö bhë, ‑bhö 'dho 'yipuë ꞊va ꞊bhaa, 'ü ‑piöga ‑zuö yiö, 'yuö‑ ‑blɛɛzë 'ü 'dhoë‑ ‑a sü bhë, ‑bhö ‑a 'dhi 'po, ü ‑dho 'wëü‑ 'tama ga do 'ö ‑mɔ ‑a ‑bha ‑yaan ko ‑bha 'nii‑ ꞊sɔnng' bho ‑a yö. ‑Bhö ‑a 'sü 'ü nuë kö 'üën‑ ko ‑bha bho ‑an ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","‑A 'töng gia‑ bhë ‑a 'ka, Yesu ‑bha ꞊guë' ‑nu ‑wo ‑yɔɔn ‑a ‑bha 'wo‑ ꞊dhɛɛkpɔdhe ‑kë ꞊nɛɛ: «Dö 'ö tɔɔ mɛ ꞊va ‑Zlan ‑bha ‑gludëdhɛ 'gü dhang‑ ‑nu 'gü i?» ");
INSERT INTO dnj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","'Ö Yesu ‑yö 'në 'tee do ꞊dhɔɔ ‑kë, 'ö‑ dɔ ‑an 'dhiö; ");
INSERT INTO dnj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","'yö‑ pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ꞊Ya kë ꞊nɛ kaa 'go ka pin ꞊taa kaa kë ꞊nɛ 'në 'sɛɛn‑ ‑nu 'wo ꞊nɛ ‑an 'dhö, kaa 'dho ‑da ‑Zlan ‑bha ‑gludëdhɛ 'gü dhang‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mɛ 'ö mɛ ꞊va 'ka ‑Zlan ‑bha ‑gludëdhɛ 'gü, 'ö tɔɔ mɛ 'ö ö ‑de dho sia‑ ꞊nɛ 'në 'ö ꞊nɛ ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mɛ 'ö 'dhoë‑ 'në ‑nu 'ö ‑an ꞊suu'‑ 'dhö ꞊nɛ ‑an kun ‑së n ‑wun 'gü, kö ꞊ya ma gia‑ n 'kun ‑së.» ");
INSERT INTO dnj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü: «'Në ‑nu 'wo n ‑wo ‑dhɛ 'wun gia‑ bhë, mɛ 'ö 'dhoë‑ kë kö ‑a mɛ do ‑de ‑yaan ‑püö ꞊sɔɔn yaa 'gü, 'a, ‑a mɛ 'ö 'dhö bhë pë 'ö ‑dhi ‑a ‑bha 'ö tɔɔ ‑wo ‑güö kpö dun ‑a bhɔa‑ ‑wa ‑zuö 'yoo ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","꞊N 'n! ‑Yö 'yenazë 'kpongtaamɛ ‑nu ‑bha 'ka ꞊dhɛɛ, 'ö tɔɔ 'wun ‑nu ‑wo ‑dhö 'kpongtaa zö, 'ö 'wo mɛ ‑nu ‑da ꞊sɔɔn yaa kë ‑sü 'gü. Bhii 'wun ‑nu 'wo 'dhö bhë, ‑wo ‑dho kë ‑dhö ‑kplawo, 'kɛɛ mɛ 'ö 'dhoë‑ bɔ ‑a ‑ta kö ‑yaan kë bhë, ‑yö ‑dho kë 'yenazë ‑a ‑bha 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","꞊Ɛɛ, 'ö ꞊ya kë ꞊nɛ ü ‑kɔ ‑wun 'iin ü ‑gɛn ‑wun 'ü dho ‑püö ‑a ‑dhë ꞊sɔɔn yaa 'gü, kö ‑bhö ‑an 'klu 'kan 'ü ‑an ‑zuö ü 'ka ꞊gbiin! ‑Yö ‑dho kë ‑së ü ‑bha 'ka kö 'ü ‑da ꞊toëpö ‑këdhösü 'gü ü ‑kɔ 'klu 'iin ü ‑gɛn 'klu 'ka 'ö ꞊zië' ü ‑kɔ ꞊plɛ waa‑ ü ‑gɛn ꞊plɛ ‑to ü ‑bha ‑sü 'ö 'wo ü ꞊zong ‑a 'ka ꞊glöötiaandhö 'siö 'ö ‑dhö ꞊toëpö 'ka bhë ‑a 'gü ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'Ö ꞊ya kë ꞊nɛ 'zü, ü 'yanga ‑wun 'ü dho ‑püö ‑a ‑dhë ꞊sɔɔn yaa 'gü, kö ‑bhö ‑a bho mü 'ü‑ ‑zuö ü 'ka ꞊gbiin! ꞊Yö ‑së ü ‑bha 'ka kö 'ü ‑da ꞊toëpö ‑këdhösü 'gü ü 'yanga dosɛn 'ka, 'yö ꞊zië' ü 'yanga ꞊plɛ ‑to mü ‑sü 'ö 'wo ü ꞊zong ‑a 'ka ꞊glöötiaandhö 'siö 'gü ‑sü ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","'Yö Yesu ‑ya pö ‑an ‑dhë 'zü: «‑Ka ka ‑zo kë ka ‑de 'piö kö ꞊kun 'ka 'në ‑nu 'wo ꞊nɛ 'ka 'yan ꞊ziö' kë ‑a mɛ do 'ka! A‑ ‑blɛɛ ka ‑dhë ‑yɔɔn ‑a ‑ta ‑sü 'ka ꞊nɛɛ: ‑Zlan ‑bha bɔmɛ ‑nu 'wo ‑an ‑maa kë ‑na 'ö 'wo dhang‑ ‑nu 'gü, ‑wo dɔ ‑sü 'ka ‑kplawo n Dë wö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bhii ma Mɛgbö, a ‑nu mɛ ‑nu 'wo dhɔng ‑sü 'ka ‑an dha ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","꞊Ya kë ꞊nɛ 'bhla ꞊këng' do ꞊ya kë gɔɔn‑ do ‑gɔ, 'ö‑ do ꞊ya ꞊dhɔng, yaa 'dho ‑an 'gɔɔ‑ 'sɛisië ö ga 'sɛisië bhë ‑an to ‑tɔn tuö mü ‑yaan 'dho ‑a do 'ö ꞊dhɔng bhë ‑a ꞊mɛɛ' ꞊dhia ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","꞊Ya kë ꞊nɛ ꞊yaa‑ yö, a‑ ‑pö ka ‑dhë gia‑ 'ka ꞊nɛɛ: ‑Yö ‑dho kë ‑a ‑gɔ ꞊zuögludhi ‑wun 'ka 'bhla do 'ö bhë ‑a ‑wun 'gü, 'ö ꞊zië' ‑an 'gɔɔ‑ 'sɛisië ö ga 'sɛisië 'ö waa ꞊dhɔng bhë ‑an ‑wun ‑ta; 'yaa 'dhö a? ");
INSERT INTO dnj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","‑Kɔ do 'ö bhë ‑a 'ka, ka Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü 'yaa‑ 'piö kö 'në ‑nu 'wo bhë ‑an do 'kpaan ‑de ‑yö ꞊dhɔng.» ");
INSERT INTO dnj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","'Ö Yesu ‑ya pö 'zü: «꞊Ya kë ꞊nɛ ü dheglu ‑mɛ ꞊ya 'wun yaa kë ü 'ka, ‑bhö ꞊yɔɔn ‑a ‑bha, 'ü‑ ‑bha 'wun ꞊zaa' ‑sü bhë ‑a ‑zɔn ‑a ‑dhë; 'kɛɛ ‑yö kë ka 'sloo 'ka. ꞊Ya kë ꞊nɛ ꞊ya 'we ü ‑wo ‑bha kö 'bha ‑a bho 'wun yaa 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","'Kɛɛ ꞊ya kë ꞊nɛ ꞊yaa‑ pö ö 'ka 'dho we ü ‑wo ‑bha, ‑bhö mɛ do 'iin mɛ ꞊plɛ 'sü ü 'piö, ‑yö kë 'dhö kö 'wun ‑dɔ mɛ ‑bha dhe 'ö dho kë, ‑a zü ‑yö dɔ mɛ ꞊plɛ 'iin mɛ ‑yaaga ‑bha ‑tɔmɔdhɛ kë ‑sü ‑bha ꞊nɛ ‑kɔ 'ö ꞊bɛɛn' ‑sü 'ka ‑a 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'Kɛɛ ꞊yaa‑ pö ö 'ka 'dho we ka ‑wo ‑bha ‑kplawo, ‑bhö ‑a ꞊blɛɛ'‑ ‑Zlan ‑bha mɛ ‑nu kpö 'gü! ꞊Ya kë ꞊nɛ 'zü ꞊yaa‑ pö ö 'ka 'dho we ‑an ‑wo ‑bha 'gbɛɛdhö, ‑kaa 'sü zlöö ꞊nɛ mɛ 'yaa ka 'piö, 'iin ꞊flüükëmɛ ‑nu mɛ do 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Mɛ 'oo mɛ 'ö 'ka 'dhoë‑ 'kɔdhi ta ‑a ‑gɔ sia‑ zö, kö 'kɔdhi ‑yö ‑ta ‑a ‑gɔ ‑sü 'ka dhang‑ 'gü. 'Iin mɛ 'oo mɛ 'ö 'ka 'dhoë‑ 'kɔdhi po ‑a ‑gɔ sia‑ zö, kö ‑yö 'po ‑sü 'ka ‑a ‑gɔ dhang‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A‑ ‑blɛɛ ka ‑dhë 'zü ꞊nɛɛ: ‑Yö ‑kë mɛ ꞊plɛ 'ka ka ziën, 'ö ‑an ‑wo ‑yö kpɔ ‑a ‑bha pë 'wo‑ 'piö ‑a ‑dhɛ ‑sü 'ka ꞊bhɛa' ‑sü 'gü n Dë 'ö ‑ya ‑sü 'ka dhang‑ ‑nu 'gü ‑a ‑gɔ, ‑yö ‑dho ‑a nu ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bhii ‑dhɛ 'ö mɛ ꞊plɛ 'iin mɛ ‑yaaga 'wo wo 'ko ꞊bhaa ‑a ‑bha n 'tɔ 'gü, a ‑an 'piö mü.» ");
INSERT INTO dnj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","꞊Dhɛ ꞊ya kë 'dhö, 'ö Piɛɛ ‑yö ꞊yɔɔn Yesu ‑bha, 'yö ꞊dhɛɛkpɔdhe ‑kë ‑a ‑gɔ ꞊nɛɛ: «N Dëmɛ, ꞊ya kë ꞊nɛ n dheglu ‑yö 'wun ꞊zaa' ‑sü kë ‑na n 'ka, ‑yö 'dho ‑na ‑a 'ka 'dhiö ‑kplawo, ‑a ‑gwaa kë ꞊dhë ‑naa 'a dho ziëë ‑a ‑ta ɛɛ? ‑Gwaa 'slaplɛ ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Abi'! N 'ka‑ pö ü ‑dhë ‑gwaa 'slaplɛ, 'kɛɛ ‑gwaa 'gɔɔ‑ 'slaplɛ ‑gwaa 'slaplɛzë.» ");
INSERT INTO dnj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‑A ‑wun 'gü 'ö Yesu ‑ya pö 'zü: «‑Dhɛ ‑ga, pë 'ö ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü 'ö bhɔ ‑a ‑bha 'yö ꞊nɛɛ: ‑Gludë do ‑yö ö bha yuökëmɛ ‑nu ‑dhɛ, 'ö yuö 'wo‑ kë ‑na bhë, 'wo‑ 'wëüga 'kluën bho ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","꞊Dhɛ 'ö ꞊wa ‑ya 'wëü‑ ꞊dhong' ‑sü ‑bha, 'wo nu mɛ do 'ö‑ ‑bha 'wëü‑ ‑vuu ꞊këng' ꞊plëëzë 'pë 'dho ‑a ‑bha ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gɔɔn‑ 'ö bhë pë 'ö dho ‑a kë kö ‑yaan 'wëüga ‑nu 'wo bhë ‑an 'pë bhoë yaa kë ‑dhö. 'Ö‑ ‑gɔmɛ ‑ya pö: ‹Gɔɔn‑ 'ö ꞊nɛ, ‑kaa 'dhɔɔ dɔ, yö 'dhö, ö bɔɔ 'dhö, ö ‑bha 'në ‑nu waa‑ pë ‑nu 'wo‑ ‑gɔ 'töüdhö; ‑ka ‑an 'plɛ 'dhɔɔ dɔ kö ‑waan kë ꞊nua ‑nu 'ka. ‑Yö kë 'dhö kö 'wëü‑ ‑nu 'wo bhë ‑yaan ‑an 'pë bho.› ");
INSERT INTO dnj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","'Ö yuökëmɛ bhë 'ö nu 'ö ‑lo ö kpɔn 'gü ö ‑gɔmɛ ꞊gɛɛndhö ‑bhɛa ‑a ‑dhë ‑sü 'ka ꞊nɛɛ: ‹‑Bhö ü ꞊zuö' 'dho sia‑ n 'piö, a ‑dho ü bha 'pë 'plɛ bho!› ");
INSERT INTO dnj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","'Ö‑ 'yena ‑yö ‑da ‑a ‑gɔmɛ 'gü, 'yö ö ꞊kwaa 'pë mɛ 'ö bhë ‑a ‑zü, 'yö‑ pö ‑a ‑dhë ‑yö 'dho. ");
INSERT INTO dnj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yuökëmɛ 'ö bhë, ‑a ‑yö plaan ‑sü 'ka, 'yö ö 'bhamɛ do 'ö wo ‑nu 'wo yuö ‑kë ‑dhɛ do 'gü, 'ö‑ ‑bha 'wëü‑ 'ö dho kë ꞊nɛ pë ꞊këng' do 'dhö 'ö‑ 'pë 'dhoë‑ ‑bha, ‑a yö. 'Ö ‑lo ‑a bhɔa, 'ö to 'tee kö ‑yö ‑to ‑a kwɛɛ, ‑a pö ‑a ‑dhë ‑sü 'ka ꞊nɛɛ: ‹‑Bhö n ‑ma 'pë 'ö ü ‑bha bhë ‑a bho!› ");
INSERT INTO dnj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","'Ö‑ 'bhamɛ ‑yö ‑püö ‑a ꞊gɛɛndhö ‑bhɛa ‑a ‑dhë ‑sü 'ka, 'ö‑ pö ‑a ‑dhë: ‹‑Bhö ü ꞊zuö' 'dho sia‑ n 'piö, a ‑dho ü bha 'pë 'plɛ bho!› ");
INSERT INTO dnj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'Kɛɛ yaa 'we ‑a ‑bha, 'yö‑ kun, 'yö‑ ‑zuö ‑kanso 'gü 'ö dho 'ö yöë ‑a ‑bha 'pë bho ‑yi ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","꞊Dhɛ 'ö‑ 'bhamɛ ‑nu 'ö wo ‑nu 'wo yuö ‑kë ‑dhɛ do 'gü, ‑wo 'wun ‑nu 'wo bhë ‑an yö, 'ö ‑siö ‑an ‑dhë ꞊gbaɔnsü; 'ö 'wo dho 'wo‑ ꞊blɛɛ wo ‑gɔmɛ ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑an ‑gɔmɛ ‑ya ꞊dhɔɔ ‑kë, 'yö‑ pö ‑a ‑dhë: ‹Yuökëmɛ 'gluyaazë! A ü bha 'pë ‑wun ‑to 'kpaan, 'ö tɔɔ ü ‑bhɛa n ‑dhë kö 'a‑ kë ü ‑dhë 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bhi ‑de 'pö, ü ꞊dua' ‑mü kö 'ü ü 'bhamɛ 'yena yö ꞊nɛ ‑kɔ 'a ü 'yena yöë bhë ‑a 'dhö 'pö!› ");
INSERT INTO dnj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Ö 'wun ‑yö ‑na ‑an ‑gɔmɛ 'ö bhë ‑a ‑zuë ꞊gbaɔnsü; 'yö yuökëmɛ 'ö bhë 'yö‑ ‑zuö ‑kanso 'gü kö ‑yaan 'klobhɔdhe yö ‑yaan 'dho ‑yaan yöë ‑a ‑bha 'pë 'plɛ bho ‑yi ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","'Ö Yesu ‑yö ö ‑wo ‑zuöatadhe ‑kë ꞊nɛɛ: «‑Kɔ bhë ꞊nɛ, 'ö n Dë 'ö dhang‑ 'gü, 'ö dho ‑a kaa ka 'ka ‑a 'ke kaa ziö ka 'ko ‑nu ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta ka ꞊zuöga 'plɛ 'ka ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","꞊Dhɛ Yesu ꞊ya yën 'wun ‑nu 'wo ꞊nɛ ‑an ꞊blɛɛ' ‑sü ‑bha, 'yö go Galile ‑sɛ 'gü, 'yö dho Zude ‑sɛ 'pian mɛ 'ö bɔ 'yiga 'wo‑ ‑dhɛ Zuudɛn bhë ‑a ꞊zlöö ꞊zian' bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mɛ ‑gbaa ꞊va ‑wo ‑ziö ‑a 'piö, 'yö ‑an ‑bha 'yuamɛ ‑nu ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Falizi ‑mɛ ‑nu 'bhaa ‑wo ‑yɔɔn Yesu ‑bha kö ‑waan 'slë 'kan ‑a ‑gɔ. 'Wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Kwa ‑bha tɔng ‑yö ‑we ‑a ‑bha kö gɔɔn‑ ‑yö ö bɔɔ bho 'blüü 'wun ‑gɛn ꞊suu'‑ 'oo ꞊suu'‑ ‑wun 'gü a?» ");
INSERT INTO dnj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: ‑A zü dɔ ‑sü 'ka, ‑Zlan ‑yö gɔɔn‑ waa‑ dhe ‑an ‑da. ‑Wo bhë kaa‑ pö ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","'Go mü 'yö‑ pö: ‑A ‑wun 'gü, gɔɔn‑ ‑dho kan ö dë waa‑ ö dhe ‑an ‑bha 'ö waa‑ ö bɔɔ 'wo wo ‑bha ‑tosiadhe kë wo 'ko 'piö. 'Ö ‑dhɛ 'wo‑ ‑bha ꞊plɛ 'wo ‑kë ꞊nɛ mɛ ‑lü do 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","꞊Ya kë 'dhö kö 'waa ꞊plɛ gbɔ, 'kɛɛ kö ꞊wa kë mɛ do 'ka; kö ꞊kun 'ö pë 'ö ‑Zlan ꞊ya ‑an ꞊nëng 'kuë‑, 'yö mɛ ‑yö ‑an ‑kan 'kuë‑.» ");
INSERT INTO dnj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'Ö Falizi ‑mɛ ‑nu ‑wa ꞊dhɛɛ' kpɔ 'zü ꞊nɛɛ: «‑Më 'ö ‑kë 'ö Moizö ‑ya pö gɔɔn‑ ‑yö ö bha dhe ‑bho 'blüü ‑sü 'sëëdhɛ kë ‑ya kpa ‑a ‑bha ‑ya kaa ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Pë 'yö ‑kë 'ö Moizö ‑ya pö 'dhö bhë 'ö tɔɔ ka ꞊gɔü' ‑yö 'gbee‑, 'kɛɛ kë‑ wo 'dhö bhë, ‑a züdɔyi 'ka yaa kë ꞊nɛ ‑kɔ bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A‑ ‑blɛɛ ka ‑dhë ꞊nɛɛ: Gɔɔn‑ ꞊ya ö bɔɔ bho 'blüü kö ‑a ‑gɛn yaa kë ꞊nɛ ꞊ya ꞊sɔɔn kë, 'ö ꞊ya dhe gbɛ 'sü kö ꞊ya ‑da dhe 'piö.» ");
INSERT INTO dnj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo ꞊yɔɔn ‑a ‑bha, 'wo‑ pö ‑a ‑dhë: «'Ö ꞊ya kë ꞊nɛ 'wun 'ö 'dhö bhë ‑yö gɔɔn‑ waa‑ dhe ‑an ziën, kö ‑a ꞊fië' ‑to kö mɛ ‑nu ‑wo 'to 'kwɛa 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Mɛ ‑nu 'plɛ waa 'dho ‑mɔ ‑a ‑bha kö mɛ ꞊daan' ‑wo 'ö ꞊nɛ ‑wa ‑gɛn ma, ‑a 'ke yaa kë mɛ ‑nu 'ö ‑Zlan ‑ya ‑a ‑gɛn ma ‑sü ꞊faan' nu ‑an ‑dhë bhë ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","'Wun ‑gɛn ꞊plëëzë ‑nu ‑wo ‑dhö, 'ö ‑an ‑wun 'gü, 'ö gɔɔn‑ ꞊plëëzë 'waa dhe 'sü. 'Ö tɔɔ mɛ 'bhaa ‑nu ‑bha 'ka, ‑an 'bɔn ‑yö 'kan ‑sü 'ka 'wo bhɔa 'ö ‑an 'bhaa ‑nu 'bɔn 'dhö 'kan ‑sü 'ka ‑an ‑de ‑zo we ‑a ‑bha ‑wun 'ka. 'Yö‑ mɛ 'bhaa ‑nu 'wo to, 'waa dhe 'sü ‑Zlan ‑bha ‑gludëdhɛ ‑wun 'gü kö ‑waan ‑Zlan ‑bha yuö kë ‑an ‑bha wo ‑de nu ‑sü 'plɛ 'ka. ꞊Ɛɛ, ꞊dhɛ 'ö 'dhö bhë, mɛ ꞊ya kë kö ‑yö ‑mɔ ‑a ‑bha ‑yaan mɛ ꞊daan' ‑wo ‑nu 'wo ꞊nɛ ‑yö ‑we ‑an ‑wun ‑bha, kö ‑ya ma!» ");
INSERT INTO dnj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","‑Dhɛ bhë ‑a ‑bha 'zü, mɛ ‑nu ‑wo ‑nu 'në 'sɛɛn‑ ‑nu 'ka Yesu ꞊dhia kö ‑yaan ö ‑kɔ kpa ‑an ‑ta, 'go mü kö ‑yaan ‑an ‑bha ꞊bhɛawodhe kë; 'kɛɛ ‑a ‑bha ꞊guë' ‑nu waa 'we ‑a ‑bha kö ‑wo ꞊yɔɔn Yesu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka ka ꞊kwaa' 'në 'sɛɛn‑ ‑nu ‑zü, ‑wo nu n 'piö! Kö ꞊kun 'ka ‑an ꞊kpaa, bhii ‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ ‑nu 'gü bhë, ‑yö mɛ ‑nu 'wo ‑kë ꞊nɛ 'në ‑nu 'wo ꞊nɛ ‑an 'dhö, ‑an ‑bha 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","'Yö ö ‑kɔ kpa ‑an tuö, ('ö 'dhuë‑ kpɔ ‑an ‑bha). ꞊Dhɛ ꞊ya kë 'dhö, 'yö ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yi do 'ka, gɔɔn‑ do ‑yö ‑yɔɔn Yesu ‑bha, 'yö‑ ꞊dhɛɛ' kpɔ 'ö‑ pö: «N ‑Gɔmɛ, ‑më ‑së 'a dho ‑a kë 'aan‑ ‑da ꞊toëpö ‑kë ‑a 'gü ‑dhɛ ‑bha ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Më 'yö ‑kë 'ü n ꞊dhɛɛ' kpɔ 'wun ‑së ‑wun 'ka ɛ? ‑Zlan do 'kpaan ꞊nɛ 'ö‑ këwun 'dho ‑së. 'Ö ꞊ya kë ꞊nɛ ü‑ 'piö kö 'ü ‑da ꞊toëpö ‑kë ‑a 'gü ‑dhɛ ‑bha, kö ‑bhö tɔng ‑nu ꞊bhlë ‑ya!» ");
INSERT INTO dnj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","'Ö‑ pö Yesu ‑dhë: «Tɔng ‑nu ‑mlë ‑ɛ?» 'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «'Ö tɔɔ: Kö ꞊kun 'ü mɛ zë; kö ꞊kun 'ü dhebɔ 'iin ꞊mlaabɔ ‑an gbɛ ꞊mɛɛ; kö ꞊kun 'ü ꞊kwaan; kö ꞊kun 'ü ꞊sua kë ü ‑ya 'yɔɔ ‑gɔ; ");
INSERT INTO dnj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‑bhö ü dë waa‑ ü dhe ‑an ꞊bhlë 'kpɔ; 'ü ü ‑ya 'yɔɔ ‑dhɔ kë ꞊nɛ ü ‑de 'dhö! » ");
INSERT INTO dnj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","'Ö 'nëgɔɔnzë 'ö bhë 'ö‑ pö: «Tɔng ‑nu 'wo bhë a ‑an 'plɛ kun. ‑Më 'bhaa 'ö‑ ‑wun ‑yö to 'a dho a‑ kë 'zü i?» ");
INSERT INTO dnj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","'Ö Yesu ‑ya pö ‑a ‑dhë: «꞊Ya kë ꞊nɛ ü‑ 'piö 'ü kë kpengdhö ö 'plɛ 'ka, ‑bhö 'dho 'ü ü ‑bha kɔɔpë ‑nu 'dhɔɔ dɔ, 'ü‑ 'wëüga bhë ‑a ‑glu 'fɛɛmɛ ‑nu 'ka, 'ü ziö n 'piö! ꞊Ya kë 'dhö ü ‑dho ü ‑bha ꞊bhɔɔpë ‑nu yö dhang‑ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","'Kɛɛ 'në gɔɔn‑ 'ö bhë ‑wo 'ö ꞊nɛ, ꞊dhɛ 'yö‑ ma, ‑yö dho wösiödhe 'ka, bhii 'ö tɔɔ ‑yö ‑kë ꞊bhɔɔzë ꞊duö. ");
INSERT INTO dnj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: ꞊Bhɔɔmɛ ‑bha ‑da ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü ‑sü 'ö dhang‑ 'gü, ‑yö ‑dho kë 'gbee‑. ");
INSERT INTO dnj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","'Ö ‑wo mɛ 'ö ꞊nɛ 'a‑ ‑pö ka ‑dhë 'zü ꞊nɛɛ: ‑Yö 'gbee‑ ‑yɔɔnmia ‑bha 'ka kö ‑yö bɔ miiga 'dhi 'gü, 'kɛɛ ‑yö ‑dho kë 'zü 'gbee‑ ꞊bhɔɔmɛ ‑bha ‑da ‑Zlan ‑bha ‑gludëdhɛ 'gü ‑sü 'ka 'ö ꞊zië' ‑yɔɔnmia ‑bha ‑bɔ miiga 'dhi ‑bha ‑sü ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","꞊Dhɛ 'ö‑ ‑bha ꞊guë' ‑nu ꞊wa 'wun 'ö ꞊nɛ ‑a ma, 'ö 'tetundhe ꞊va ‑yö ‑da ‑an 'gü 'wo‑ pö: «꞊Ya kë 'dhö kö dö 'yö dho dha 'sa?» ");
INSERT INTO dnj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","'Ö Yesu ‑yö ‑an ‑ga, 'ö‑ pö: «‑Yö 'gbee‑ mɛ 'bhee‑ ‑bha 'ka 'dhö, 'kɛɛ ‑yö 'pëëpë ‑Zlan ‑bha 'ka, 'ö tɔɔ ‑Zlan ‑kɔ ‑yö ‑mɔ 'wun 'plɛ kë ‑sü ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","꞊Dhɛ ꞊ya kë 'dhö, 'ö Piɛɛ ‑ya pö ‑a ‑dhë: «Ü 'to 'to, yi yi ‑bha pë ‑nu 'plɛ ‑to sia‑ 'yi ‑ziö ü 'piö. ꞊Ya kë 'dhö, kö ‑më 'yi dho ‑a yö 'pö e?» ");
INSERT INTO dnj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","'Ö Yesu ‑ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Yi 'ö ma Mɛgbö 'a dho ‑ya ‑a 'ka n ma 'gɔ ‑gbloo 'tɔ bhɔ ‑sü ‑zë 'gü 'kpongtaadhɛ ‑dëü ‑bha, ka 'gɔɔ‑ do ö ga ꞊plɛ, 'ka ‑ziö n 'piö ꞊nɛ, ka ‑de 'pö ka ‑dho ‑ya 'gɔ ‑gbloo ‑nu 'gü kö 'kaan‑ Izlaɛlö 'gunng 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an ‑bha za 'kan. ");
INSERT INTO dnj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","'Go mü, mɛ 'oo mɛ 'ö 'dhoë‑ ö bha 'kɔ ‑nu, ö dheglu 'në gɔɔn‑ ‑nu, 'nëdhoo ‑nu, ö dë ‑nu waa‑ ö dhe ‑nu, ö bha 'në ‑nu, ö bha ꞊bhlöödhɛ ‑nu ‑an 'plɛ to n ‑wun 'gü, ‑yö ‑dho ‑a yö ‑gwaa ꞊këng' do ‑zë. 'Go mü, 'ö ꞊toëpö ‑këdhösü dho kë ‑an ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","'Kɛɛ mɛdhɛvadhɛ 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü bhë, ‑an mɛ ‑blɛɛzë ‑nu ‑wo ‑dho kë ‑tozlöömɛ ‑nu 'ka; 'ö mɛ ‑nu 'wo ‑tozlöömɛ ‑nu 'ka, 'wo dho kë mɛ ‑blɛɛzë ‑nu 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","'Yö Yesu ‑ya pö ‑an ‑dhë: «Bhii pë 'ö ‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑yö bhɔ ‑a ‑bha, yö ꞊ga ꞊nɛ: Lɛzɛn ꞊dhɛɛdhɛ dëmɛ do ‑yö ‑yö plaan ‑dhiadhiö tii 'gü. ‑Ya ‑kë 'dhö kö 'ö yuökëmɛ ‑nu ‑da ö ‑gɔ lɛzɛn ‑bhlö 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","'Ö waa‑ yuökëmɛ ‑nu 'ö ‑an ‑wo ‑yö kpɔ ‑a ‑bha kö 'yaan‑ ‑an ꞊saan' bho ꞊nɛ ‑kɔ do 'ö 'wo mɛ ‑nu ꞊saan' bho ‑na ‑a 'ka ‑su ga do 'ka ‑dhɛkpaɔyi do ‑bha bhë ‑a 'dhö, 'yö ‑an bɔ lɛzɛn ꞊dhɛɛdhö yuö kë ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","'Yö ko 'zü 'yö yö plaan ‑dhiadhiö ‑lan 'tëë 'gbee‑ 'ka, 'yö mɛ 'bhaa ‑nu yö kö ‑wo ꞊gbaannu ‑sü 'ka 'dhëëdhɛ ‑nu ‑bha, bhii yuö 'yaa ‑an ‑gɔ, ");
INSERT INTO dnj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","'yö‑ pö ‑an ‑dhë: ‹Ka ‑de 'pö, ‑ka 'dho 'ka yuö kë n ‑gɔ lɛzɛn ꞊dhɛɛdhö, a ‑dho ka ꞊saan' bho 'kpodhö.› ");
INSERT INTO dnj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","'Ö 'wo dho yuö kë ꞊dhia lɛzɛn ꞊dhɛɛdhö. 'Ö ko 'zü, 'ö yö plaan lan‑ 'gü; 'go mü 'zü, 'yö yö plaan 'wɔ 'yɛ ‑lan 'ka, 'ö mɛ 'bhaa ‑nu yö; pë do bhë 'ö‑ pö ‑an ‑dhë, 'wo dho 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","꞊Dhɛ 'ö 'kwa dɔ 'dho ‑lan 'ka, 'yö yö plaan, 'yö mɛ 'bhaa ‑nu yö kö ‑wo dɔ ‑sü 'ka 'dhëëdhɛ ‑nu bhë ‑a ‑bha. 'Yö ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: ‹‑Më 'yö ‑kë 'ka ꞊gloo zö ‑dhɛkpaɔyi 'ö ꞊dɛɛ ꞊nɛ ‑a 'gü, 'ö 'kaa yuö gbɛ kë ꞊ɛ?› 'Wo‑ pö ‑a ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‹'Ö tɔɔ mɛ gbɛ 'yaa ‑dhö ‑yaan yi 'sü yuö 'gü.› 'Ö‑ pö ‑an ‑dhë: ‹꞊Dhɛ 'ö 'dhö, kö ‑ka 'dho 'ka yuö kë n ‑gɔ lɛzɛn ꞊dhɛɛdhö!› ");
INSERT INTO dnj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","꞊Dhɛ 'ö 'yiniadhɛ ‑yö dɔ, 'yö ö bha mɛ ꞊saan' bho ‑mɛ ꞊dhɔɔ ‑kë, 'ö‑ pö ‑a ‑dhë: ‹‑Bhö yuökëmɛ ‑nu ꞊saan' bho, ‑a zü dɔ mɛ ‑nu 'wo ‑da yuö 'dhiö zlöö bhë ‑an ‑ta 'ü 'dho 'ü yöë yuökëmɛ ‑nu 'wo ‑da mü 'dhiö bhë ‑an ‑bha!› ");
INSERT INTO dnj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mɛ ‑nu 'wo ‑da yuö 'dhiö 'dho ‑lan 'ka bhë ‑wo ‑nu, 'ö mɛ 'ö ‑dhö 'ö ö ‑bha ‑su ga do yö. ");
INSERT INTO dnj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","꞊Dhɛ mɛ ‑nu 'wo ‑da yuö 'gü 'dhiö ‑blɛɛzë 'ka bhë ꞊wa nu, ‑wa ‑pö ‑bezë wo ‑bha ‑dho ziö mɛ ‑nu 'wo nu zlöö bhë ‑an ‑bha ‑ta, 'kɛɛ mɛ 'ö ‑dhö ‑wa ‑bha ‑su ga do do ‑nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","‑An ‑bha 'wëü‑ 'sü ‑sü 'ka, ‑wo 'wun ‑blɛɛ wo ‑wo ꞊löö lɛzɛn ꞊dhɛɛdhɛ dëmɛ bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'Ö 'wo‑ pö: ‹Yuökëmɛ ‑nu 'wo nu zlöö, 'ö 'wo yuö ‑kë 'lɛlɛ do 'piö, 'ü ‑an ꞊saan' bho ꞊nɛ yi 'yi yuö ‑kë ‑dhɛkpaɔyi do 'piö, lan‑ 'bhü ‑sü ‑ta 'ö yi 'gü ꞊ya ga ꞊nɛ yi 'dhö a?› ");
INSERT INTO dnj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'Kɛɛ lɛzɛn ꞊dhɛɛdhɛ dëmɛ ‑ya ‑pö ‑a mɛ do ‑dhë: ‹N 'bhamɛ, n 'ka ü ‑püö, ü ‑we ‑a ‑bha 'ü yuö kë ‑su ga do ‑bha ‑dhɛkpaɔyi do 'ka, 'wun gia‑ 'yaa ‑mü ‑a? ");
INSERT INTO dnj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kö ‑bhö ü ꞊saan' bhë ‑a 'sü 'ü ü bha 'dho wo. Mɛ 'ö ‑da yuö 'gü zlöö bhë, a ‑dho ‑a ꞊saan' bho ꞊nɛ ‑kɔ do 'a ü ꞊saan' bho ‑a 'ka bhë ‑a 'dhö 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","N ‑kɔ yaa ‑mɔ ‑a ‑bha kö pë 'ö ‑dhi n ‑dhë, 'a‑ kë n ‑ma 'wëüga 'ka a? 'Iin n ‑ma 'glusë ‑wun 'kö bhë 'ö ꞊druɛi ‑yö ‑da ‑a ‑dhë ü 'gü i?› » ");
INSERT INTO dnj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","꞊Dhɛ ‑kë 'dhö, 'ö Yesu ‑yö ö ‑wo ‑zuöatadhe ‑kë 'zü ꞊nɛɛ: «Mɛ ‑nu 'wo ‑tozlöömɛ 'ka, ‑wo ‑dho kë mɛ ‑blɛɛzë ‑nu 'ka, 'ö mɛ ‑nu 'wo mɛ ‑blɛɛzë 'ka, 'wo dho kë ‑tozlöömɛ ‑nu 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu ‑yö ‑kë 'dho ꞊dhia Zeluzalɛmë; 'yö ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ bhë 'yö ‑an ‑sü ‑de ‑ta, 'ö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«‑Ka ka 'to 'to, kwa ‑da ‑na Zeluzalɛmë kö ma Mɛgbö ‑waan n dɔ slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu kwɛɛ ‑waan ga za ‑lo n tuö. ");
INSERT INTO dnj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'Go mü ‑waan n dɔ mɛ 'waa Zuifö 'ka ‑an kwɛɛ. ‑Wo ‑dho duö 'luu sü n ‑ma, 'wo n ‑ma ‑klaaga 'ka; ‑wo ‑dho n ‑dɔ ‑gaatalü ‑bha, 'ö 'wo n zë. 'Kɛɛ ‑a ‑dhɛkpaɔyi ‑yaaga ‑naa 'ö bhë ‑a 'ka, a ‑dho go ga 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","'Ö Zebede bɔɔ waa‑ ö bha 'në ‑nu ‑wo ꞊yɔɔn Yesu ‑bha. 'ö ‑an dhe ‑yö ‑gblü Yesu 'dhiö kö 'yaan‑ pë do 'bhaa ‑dhɛ ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Më 'ü‑ 'piö e?» 'Ö‑ pö Yesu ‑dhë: «‑Bhö ‑a kë kö ma 'në ‑nu ꞊plɛ 'wo ꞊nɛ, yi 'ü dho kaa ‑gludë 'ka, kö ‑a mɛ do ‑yö ‑ya ü ꞊kwɛɛ‑ 'gü, ‑a mɛ do ‑yö ‑ya ü ꞊kwaa‑ 'gü!» ");
INSERT INTO dnj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'Ö Yesu ‑ya pö ‑a ‑dhë: «Pë 'ka‑ ‑dhɛ ‑na bhë, 'kaa‑ dɔ. Ka ‑mɔ ‑a ‑bha kö 'yi 'güüzë 'a 'dhoë‑ ‑a mü ꞊nɛ 'kaa‑ ‑a mü ꞊a?» 'Wo‑ pö ‑a ‑dhë: «Yi ‑mɔ ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü: «꞊Ii‑, ka ‑dho ma 'yi 'güüzë bhë ‑a mü, 'kɛɛ ma kun 'a dho mɛ 'ö dho ‑ya n ꞊kwɛɛ‑ 'gü 'iin n ꞊kwaa‑ 'gü ‑a ‑zɔn. ‑Ya dhɛ ‑nu 'wo bhë ‑wo mɛ ‑nu 'ö n Dë ‑yö ‑an ‑ya ‑an ‑bha 'ka bhë, ‑an ‑bha 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","꞊Dhɛ ꞊guë' ‑nu 'gɔɔ‑ do 'wo to bhë ꞊wa 'wun bhë ‑a ma, 'wo 'wun ꞊blɛɛ dhegluzë ꞊plɛ 'wo bhë ‑an 'ka ‑an ꞊taa ‑bha wo 'ko ‑nu ziën. ");
INSERT INTO dnj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'Ö Yesu ‑yö ‑an 'plɛ ꞊dhɔɔ ‑kë, 'ö‑ pö ‑an ‑dhë: «Ka‑ ꞊dɔa' ꞊nɛɛ: ‑Gludë ‑nu ‑wo mɛ ‑nu 'gbee‑ ‑ta bho, 'ö mɛ ‑nu 'wo 'tɔbhɔmɛ ‑nu 'ka, 'wo mɛ ‑nu ꞊kɔɔn. ");
INSERT INTO dnj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'Kɛɛ kö ꞊kun 'ö ‑kë ꞊nɛ ‑kɔ bhë ‑a 'dhö ka ziën; ‑abi'! ꞊Ya kë ꞊nɛ mɛ ‑yö ‑dhö ka ziën 'ö‑ 'piö kö 'ö kë mɛ ꞊va 'ka, kö ‑yö ö ‑de kë ꞊nua 'ka ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","'Go mü 'zü, mɛ 'ö‑ 'piö kö 'ö kë mɛ ‑blɛɛzë 'ka, kö ‑yö ö ‑de kë yuö ‑kë mɛ 'plɛ 'dhiö ‑mɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","‑Kɔ do bhë 'ö ma Mɛgbö 'a nuë; n 'ka nu kö ‑waan yuö kë n 'dhiö, 'kɛɛ kö ma ‑zë, 'aan‑ yuö kë mɛ ‑nu 'dhiö. 'Go mü, 'aan‑ n ‑ma ‑tosiadhe nu mɛdhɛvadhɛ ‑bho 'gan 'gü ‑sü ꞊sɔnng' 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","‑Wo ‑kë 'go ꞊dhia Zeliko, 'ö mɛ ‑gbaa ꞊va ‑wo ‑ziö Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","'Yënngtiimɛ ꞊plɛ ‑wo ‑kë ꞊yaannu ‑sü 'ka zian 'to 'dhiö. ꞊Dhɛ 'wo‑ ma ꞊nɛ Yesu ‑yö ziö ‑na, 'wo yö ‑we 'gbee‑ ‑sü 'gü, 'wo‑ pö: «Yi ‑Gɔmɛ, Davidö gbö, ‑bhö yi 'yena yö e!» ");
INSERT INTO dnj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Ö mɛ ‑gbaa ‑nu ‑wo yö 'wun ‑blɛɛ ‑an 'ka ‑sü 'gü, ‑a pö ‑sü 'ka ꞊nɛ ‑wo wo 'dhi yö 'kuë‑. 'Kɛɛ ‑wo ‑yö 'we ‑sü 'gü 'gbee‑ 'ka 'zü ꞊nɛɛ: «Yi ‑Gɔmɛ, Davidö gbö, ‑bhö yi 'yena yö e!» ");
INSERT INTO dnj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","'Yö Yesu ‑yö ꞊gbaannu, 'ö ‑an ꞊dhɔɔ ‑kë, 'yö ‑an ꞊dhɛɛkpɔdhe ‑kë ꞊nɛɛ: «‑Më 'ka‑ 'piö kö 'a‑ kë ka ‑dhë ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","'Wo‑ pö ‑a ‑dhë: «Yi ‑Gɔmɛ, ‑bhö ‑a kë kö 'yi ‑dhɛ yö!» ");
INSERT INTO dnj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","'Ö ‑an 'yena ‑yö ‑da Yesu 'gü; 'ö ‑pa ‑an 'yan 'ka, 'ö ‑dhɛ do bhë ‑a 'gü, mɛ ꞊plɛ 'wo bhë 'ö ‑an 'yan ‑yö ‑po, 'yö 'wo ‑ziö Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","꞊Dhɛ 'wo ꞊yɔɔn ‑na Zeluzalɛmë ‑pö 'sɔɔ, 'wo bɔ Betefaze ‑pö 'ö Olivie ‑tɔn 'piö ꞊zian' bhë ‑a 'gü. Yesu ‑yö ö ‑bha ꞊guë' ‑nu ꞊plɛ bɔ ö 'dhiö ‑a ‑pö ‑an ‑dhë ‑sü 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","«‑Ka 'dho pödhɛ 'ö kwa 'dhiö bhë ‑a 'gü, ka ‑dho ꞊soofang mu 'ö‑ 'në 'dho ‑a 'piö ‑an yö kö ‑wo ‑klu ‑sü 'ka. ‑Ka ‑an 'po 'ka nu ‑an 'ka n ꞊dhia! ");
INSERT INTO dnj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","꞊Ya kë ꞊nɛ mɛ 'bhaa ꞊ya ka ꞊dhɛɛ' 'kpɔ, ‑kaa pö ‑a ‑dhë: ‹Yi Dëmɛ ‑bha 'wun ‑yö ‑yö ‑an ‑bha.› ‑Yö ‑dhö ö ꞊kwaa' ka ‑zü 'ka nuë n ꞊dhia zö!» ");
INSERT INTO dnj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pë ‑nu 'wo bhë, ‑wo ‑kë 'dhö kö pë 'ö ‑Zlan ‑wodhiölomɛ ‑ya pö 'dhiö bhë, ‑yaan ‑mɔ 'kuë ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‑Bhö ‑a pö Siɔn ‑pö ‑dhë: ‑Dhɛ ‑ga, ü bha ‑gludë ‑yö nu ‑na ü 'piö, ‑yö pa ‑sü 'ka ‑kë 'lëëlë ‑sü 'ka; 'yö ‑ya ‑sü 'ka ꞊soofang 'në ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","'Ö ꞊guë' ‑nu ꞊plɛ 'wo bhë 'wo dho 'wo‑ ‑kë ꞊nɛ ‑kɔ 'ö Yesu ‑ya pöë ‑an ‑dhë bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","'Wo nu ꞊soofang mu waa‑ ö 'në bhë ‑an 'ka, 'wo wo ‑bha gblang ‑nu ‑lo ‑an ꞊taa, 'ö Yesu ‑yö ‑ya ꞊soofang 'në ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mɛ ‑gbaa ꞊va ‑wo wo ‑bha gblang ‑nu ‑po zian ‑gbloo 'piö, 'ö mɛ 'bhaa ‑nu ‑wo 'dhɛ ‑saa ‑nu ‑yɛ, 'wo ‑an ‑po zian ‑gbloo 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mɛ ‑gbaa ‑nu 'wo yö Yesu ‑dhë 'dhiö waa‑ ‑an mɛ ‑nu 'wo ‑ziö ‑a 'piö, ‑wo ‑yö 'gɛi kë ‑sü 'gü 'gludhi 'ka ‑a pö ‑sü 'ka ꞊nɛɛ: «Kwaa‑ 'yoo ‑mü! Kwaa‑ 'yoo ‑mü! 'Tɔbhɔdhe ‑yö 'to Davidö gbö ‑ta! 'Dhuë‑ ‑yö 'kpɔ mɛ 'ö nu kwa Dëmɛ 'tɔ 'gü ‑a ‑ta! ‑Zlan 'ö dhang‑ ‑nu 'gü ‑a 'tɔ ‑yö kë ꞊va!» ");
INSERT INTO dnj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","꞊Dhɛ 'ö Yesu ‑ya ‑da Zeluzalɛmë, 'ö plöömɛ ‑nu 'saadhö ‑wo yö wo 'ko ‑nu ꞊dhɛɛ' 'kpɔ ‑sü 'gü ꞊nɛɛ: «Dö ‑mü gɔɔn‑ 'ö ꞊nɛ ‑a 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","'Ö mɛ ‑gbaa ‑nu 'wo kë ziö Yesu 'piö ꞊dhia bhë, 'wo‑ pö: «Yesu, ‑Zlan ‑wodhiölomɛ 'ö 'go Nazalɛtë, Galile ‑sɛ 'gü bhë yö ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu ‑yö ‑da ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'yö mɛ ‑nu 'wo ‑kë pë ‑nu 'dhɔɔ dɔ ꞊dhia waa‑ mɛ ‑nu 'wo ‑kë pë ‑nu 'dhɔ ꞊dhia mü bhë 'ö ‑an ‑kë, 'ö mɛ 'wo ‑kë 'wëü‑ ‑ta ‑bɔ ꞊dhia ‑Zlan ‑gba ‑a 'gü ‑kɔ 'wëü‑ 'ka ‑an ‑bha 'dhɔɔ dɔ ‑a ‑ta ꞊gba waa‑ ‑tönggö 'dhɔɔdɔmɛ ‑nu ‑bha ‑gbloo ‑nu ‑lo sia‑. ");
INSERT INTO dnj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö ‑an ‑dhë: «Pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ‑ya ‑pö: ‑Wo ‑dho n ‑ma 'kɔ ‑dhɛ ‑bhɛa ‑a 'gü ‑kɔ, 'kɛɛ ka ‑zë, 'ka‑ ‑kë ka ‑bha ꞊kwaanpë ‑bin ‑a 'gü ‑guö ꞊duudhɛ 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","꞊Dhɛ ꞊ya kë 'dhö, 'ö 'yënngtiimɛ ‑nu waa‑ ‑gɛnlomɛ ‑nu ‑wo ‑nu Yesu 'piö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'yö ‑an ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","꞊Dhɛ slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Zuifö ‑mɛ ‑nu ‑bha tɔnggɔmɛ ‑nu ꞊wa 'wun 'gblüünzë 'ö‑ ‑kë bhë ꞊waa‑ yö waa‑ 'në 'sɛɛn‑ ‑nu 'gbla ‑wo 'ö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü ‑a pö ‑sü 'ka ꞊nɛɛ «Davidö gbö 'tɔ ‑yö kë ꞊va!» bhë 'ö ꞊waa‑ ma, 'ö 'wun ‑yö ‑na ‑an ‑zuë. ");
INSERT INTO dnj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","'Ö 'wo‑ pö Yesu ‑dhë: «'Gbla ‑kɔ ꞊suu'‑ 'wo‑ kaa‑ ꞊nɛ, 'ü‑ ‑ma ‑a?» 'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «꞊Ii‑, a‑ ‑ma, 'kɛɛ ‑yö ‑ya ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: ‑We ü 'tɔ 'piö ‑sü ‑dho bɔ 'në 'sɛɛn‑ ‑nu waa‑ 'në 'puu ‑nu ‑an 'dhii. ‑Wo 'ö bhë kaa‑ pö do ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","꞊Dhɛ ꞊ya kë 'dhö, 'yö go ‑an 'piö pödhɛ bhë ‑a 'gü, 'ö dho Betani, 'yö ‑wɔ mü. ");
INSERT INTO dnj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya 'po, kö Yesu ‑yö nu ‑na plöö ꞊zian', 'ö din ‑ya ‑kun. ");
INSERT INTO dnj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","‑Yö figö ‑lü do ‑yö zian ‑gbloo 'dhiö, 'yö ꞊yɔɔn ‑a ‑bha ‑a bhɛ ‑wun 'gü, 'kɛɛ ‑a 'dhɛ 'kpaan ꞊nɛ 'ö‑ yö. 'Ö‑ pö figö ‑lü bhë ‑a ‑dhë: «Ü bhɛ gbɛ 'ka 'dhö kë ‑dhö gbɔ!» 'Ö figö ‑lü bhë 'ö to ‑dhɛ do bhë ‑a 'gü 'ö 'kpɛa kun. ");
INSERT INTO dnj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","꞊Dhɛ 'ö‑ ‑bha ꞊guë' ‑nu ‑wo 'wun 'ö ꞊nɛ ‑a ‑yö, 'ö 'tetundhe ‑yö ‑da ‑an 'gü, 'wo yö Yesu ꞊dhɛɛ' 'kpɔ ‑sü 'gü ꞊nɛɛ: «‑Më 'ö ‑kë 'piöklöözë 'ö figö ‑lü ꞊nɛ 'ö 'kpɛa kun ꞊i?» ");
INSERT INTO dnj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","'Ö Yesu ‑ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: 'Ö ꞊ya kë ꞊nɛ ‑zo ‑yö n ‑ma ‑sü ꞊ya kë ka ‑gɔ, 'ö ‑zogɔndhe yaa kë ‑a 'gü, ka ‑dho pë 'a‑ ‑kë figö ‑lü 'ka ꞊nɛ, ‑a kë 'pö 'ö yaa 'dhö kë ‑a ‑de 'sloo 'ka, 'kɛɛ ka ‑dho ‑mɔ ‑a ‑bha 'zü 'kaan‑ ‑a pö ‑tɔn 'ö ꞊nɛ ‑a ‑dhë: ‹‑Bhö 'go ü pin 'ö ꞊nɛ ‑a ‑bha 'ü 'dho 'ü ‑püö 'yoo ꞊bhaa!› ‑Yö ‑dho kë 'dhö 'gbɛɛdhö. ");
INSERT INTO dnj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pë ꞊suu'‑ 'saadhö 'ka‑ ‑dhɛ ‑Zlan ‑gɔ ꞊bhɛa' ‑sü 'ka, 'ö ꞊ya kë ꞊nɛ 'ka‑ ‑dhɛ 'wun gia‑ ꞊nɛ, ‑yö ‑dho kë, pë 'ka‑ ‑dhɛ bhë, ka ‑dho ‑a yö!» ");
INSERT INTO dnj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu ‑yö ‑da ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'ö yö mɛ ‑nu ꞊daan' ‑sü ‑bha. ꞊Dhɛ ꞊ya kë 'dhö, 'ö slabhomɛ ‑gɔmɛ ‑nu waa‑ mɛ ziizii ‑nu 'wo Zuifö 'ka, ‑wo ‑yɔɔn Yesu ‑bha, 'wo yö ‑a ꞊dhɛɛ' 'kpɔ ‑sü 'gü ꞊nɛɛ: «Pë ‑nu 'ü ‑an kë ‑na 'saadhö ꞊nɛ dö 'ö‑ pö ü ‑dhë 'ü‑ kë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ma ‑de 'pö, a ‑dho ꞊dhɛɛ' do kpɔ ka ‑gɔ. ꞊Ya kë ꞊nɛ 'ka‑ ‑daa kë n ‑gɔ ꞊sia, a ‑dho pë 'ö ‑kë 'a 'wun ‑nu 'wo ꞊nɛ 'a‑ kë ‑na bhë ‑a ‑gɛn pö ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Dö 'ö Zan bɔ ‑yaan mɛ ‑nu ‑bɔ yiö ꞊e? ‑Zlan ‑mü e, 'iin mɛ 'bhee‑ ‑nu ‑mü e?» 'Kɛɛ ‑wo ‑yö 'wun ꞊blɛɛ' ‑sü ‑bha wo 'ko ‑dhë ‑a pö ‑sü 'ka ꞊nɛɛ: «'Ö ꞊ya kë ꞊nɛ, 'kwa‑ ‑daa kë ꞊nɛɛ: ‹‑Zlan 'yö‑ bɔ›, ‑yö ‑dho kwa ꞊dhɛɛ' kpɔ ꞊nɛɛ: ‹‑Më 'ö ‑kë kaa Zan ‑wo ‑dhɛ 'wun gia‑ ‑ɛ?› ");
INSERT INTO dnj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kwaa 'dho ‑mɔa 'kwa‑ pö 'pö 'sa: ‹Mɛ 'bhee‑ ‑nu 'wo‑ bɔ›; bhii kwa ‑suö 'sɛgümɛ ‑nu ‑dhë, 'ö tɔɔ ‑an 'plɛ ‑wo wo ‑zo ‑ta ꞊nɛ ‑Zlan ‑wodhiölomɛ ‑mü Zan 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","꞊Dhɛ ꞊ya kë 'dhö, 'wo‑ pö Yesu ‑dhë: «'Yiëë‑ dɔ.» 'Ö Yesu ‑ya pö ‑an ‑dhë 'pö: «꞊Ɛɛ, ꞊dhɛ 'ö 'dhö, kö ma ‑de 'pö, n 'ka 'dho n ‑ma ‑gɛn pö ka ‑dhë 'pö.» ");
INSERT INTO dnj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","'Ö Yesu ‑ya pö ꞊nɛɛ: «'Wun mɛ 'ö ꞊nɛ ka ‑dhɛ ‑ga ‑a 'piö 'dhɛ: Gɔɔn‑ do ‑bha 'në ‑nu ꞊plɛ ‑wo ‑kë ‑dhö, 'yö‑ pö ‑a mɛ ‑blɛɛzë ‑dhë: ‹N gbö, ‑bhö 'dho yuö kë ‑dhiadhö ꞊dɛɛ n ‑gɔ lɛzɛn ꞊dhɛɛdhö!› ");
INSERT INTO dnj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'Yö‑ ‑daa ‑kë 'ö‑ pö ö dë ‑dhë: ‹N 'kaa dho.› 'Kɛɛ ꞊dhɛ 'ö 'töng pë 'bhle ꞊ya ziö, 'ö‑ ꞊zuö' ꞊ya ꞊kpaɔ, 'ö dho yuö bhë ‑a kë ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'Go mü ‑an dë ‑yö pë do bhë 'ö‑ pö ö gbö mɛ 'ö to bhë ‑a ‑dhë. Ö‑ gbö mɛ 'ö bhë 'yö‑ pö ö dë ‑dhë: ‹꞊Ii‑, n dë, a ‑dho dho›, 'kɛɛ yaa 'dho gbɔ. ");
INSERT INTO dnj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","'Në ‑nu ꞊plɛ 'wo bhë ‑a dö ‑zë 'ö ö dë ‑wo ‑kë ‑ɛ?» 'Wo‑ ‑daa ‑kë ‑a ‑gɔ ꞊nɛɛ: «‑A mɛ ‑blɛɛzë ‑mü.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: 'Nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu 'wo mɛ ‑nu ꞊flüübhömɛ ‑nu 'ka, waa‑ mɛ 'ö 'wo ꞊sɔɔnkëmɛ ‑nu 'ka ‑wo ‑dho ‑da ‑Zlan ‑bha ‑gludëdhɛ 'gü ka 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bhii Zan ‑yö ‑nu ka 'piö, 'ö zian ‑gbloo 'ö kpengdhö 'ö‑ ‑zɔn ka ‑dhë, 'ö kaa‑ ‑wo ‑dhɛ 'wun gia‑, 'kɛɛ 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu waa‑ mɛ ‑nu 'wo ꞊sɔɔnkëmɛ ‑nu 'ka ‑wa ‑wo ‑dhɛ 'wun gia‑. Yö do bhë 'zü, pë ‑nu 'wo ꞊nɛ ‑an yö ‑sü 'ka, kaa 'go ka ‑bha ꞊sɔɔn yaa 'gü kö 'kaan‑ ‑a ‑wo ‑dhɛ 'wun gia‑.» ");
INSERT INTO dnj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü: «‑Ka ka 'to 'to, 'wun ꞊zuan' mɛ 'ö ꞊nɛ ‑a ‑bha: Gɔɔn‑ do ‑yö ‑kë ‑dhö, 'ö lɛzɛn ꞊dhɛɛdhɛ ‑yö ‑kë ‑a ‑gɔ. 'Ö ‑gla ꞊nië ‑a ‑zü, 'ö ‑glu do pɔn ‑drɔɔn 'yi bho ‑a 'gü ‑pë 'ka, 'ö 'gbu ‑kɔ do ‑dɔ mü; 'ö lɛzɛn ꞊dhɛɛdhɛ bhë 'ö‑ nu lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu ‑dhë, 'yö dho 'ta 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","꞊Dhɛ 'ö lɛzɛn ‑nu ‑kpa bho ‑yi ꞊ya ‑lo, 'yö ö bha yuökëmɛ ‑nu bɔ lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu 'piö kö ‑waan ö bha lɛzɛn ‑kpa dɔ ‑an ‑gɔ, ‑waan nuë ö ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","'Kɛɛ mɛ ‑nu 'ö ‑an bɔ bhë ‑wo ‑an ‑kun. 'Ö 'wo ‑an mɛ do ‑ma, 'ö 'wo‑ mɛ do zë, 'ö 'wo ‑an mɛ ‑yaaga ‑naa ‑zuö ‑guö 'ka; 'ö 'wo‑ zë. ");
INSERT INTO dnj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","'Ö lɛzɛn ꞊dhɛɛdhɛ dëmɛ ‑yö ö bha bɔmɛ ‑nu 'bhaa 'ö 'wo ꞊va 'wo ꞊zië' ‑a mɛ ‑blɛɛzë ‑nu ‑ta, 'ö ‑an bɔ. Pë do 'ö lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu ‑wa ‑kë bɔmɛ ‑blɛɛzë ‑nu 'wo 'dhiö bhë ‑an ‑gɔ bhë, 'yö 'wo‑ kë ‑an 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","'Wun bhë kö ‑yaan yën, ‑yö ö gbö ‑bɔ ‑a ‑pö ö ‑de 'gü ‑sü 'ka ꞊nɛɛ: ‹‑Wo ‑dho n gbö ꞊bhlë ‑ya.› ");
INSERT INTO dnj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","'Kɛɛ ꞊dhɛ 'ö lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu ꞊waa‑ gbö yö, 'wo‑ pö wo 'ko ziën ꞊nɛɛ: ‹Dɔ, ‑ka ‑dhɛ ‑ga, mɛ 'ö pë ‑nu 'wo ꞊nɛ 'wo dho to ‑a ‑gɔ 'dhiö ꞊zian' bhë 'ö ꞊nɛ! ‑Kwa 'dho 'kwa‑ zë kö pë ‑nu 'wo ꞊nɛ ‑waan 'to kwa ‑gɔ!› ");
INSERT INTO dnj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'Ö 'wo ‑lo ‑a ‑ta, 'wo‑ kun, 'wo dho ‑a 'ka lɛzɛn ꞊dhɛɛdhɛ ꞊taa ‑bha, 'wo‑ zë.» ");
INSERT INTO dnj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Lɛzɛn ꞊dhɛɛdhɛ dëmɛ nu ‑yi 'ka, ‑më 'ö dho ‑a kë yuö ‑kë ‑a ‑gɔ lɛzɛn ꞊dhɛɛdhö ‑mɛ ‑nu 'wo bhë ‑an 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","'Wo‑ ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «Gɔɔn‑ ‑nu këwunyaazë ‑nu 'wo bhë ‑yö ‑dho ‑an 'plɛ zë, yaa 'dho ‑an 'yena yö; 'go mü, 'yö dho lɛzɛn ꞊dhɛɛdhɛ 'ö bhë ‑a dɔ lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu gbɛ 'ö yi 'ö lɛzɛn ‑kpa bho ‑yi ꞊ya ‑lo, 'wo dho ‑an bho ‑waan nu ‑a ‑bha 'ka bhë ‑an kwɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Wo do ‑yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: ‑Guö kpö 'ö 'kɔdɔmɛ ‑nu ‑wa ‑ga ‑guö yaa 'ka, 'wo‑ ꞊zong' bhë yö ꞊nɛ 'ö ꞊ya kë ‑guö 'ö dɔ ‑sü 'ka ‑guö gia‑ 'ka 'kɔ ‑gɔ kpinngdhö ‑a 'ka. Pë bhë ꞊nɛ 'ö kwa Dëmɛ ‑ya ‑kë; ‑yö kwa ‑bha pë 'gblüünzë 'ka. ‑Wo mɛ 'ö bhë kaa‑ pö do ‑a?» ");
INSERT INTO dnj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","'Yö Yesu ‑yö ö ‑wo ‑zuö ‑a ‑ta dhe ‑kë ꞊nɛɛ: «‑A ‑wun 'gü a‑ ‑pö ka ‑dhë: ‑Zlan ‑bha ‑gludëdhɛ ‑yö ‑dho kun ka ‑gɔ, 'yö nu 'sɛ gbɛ 'gü ‑mɛ ‑nu 'ö ‑an kë ‑sɔɔn dhö ‑a ꞊zuan' ꞊nɛ ‑Zlan ‑bha ‑gludëdhɛ ‑yö ‑an ‑bha 'ka bhë ‑an ‑dhë 'dhɛ. ");
INSERT INTO dnj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mɛ 'ö 'dhoë‑ ‑püö ‑guö kpö 'ö ꞊nɛ ‑a ‑ta, ‑yö ‑dho ö pë 'bhaa yɛ; 'kɛɛ mɛ 'ö ‑guö kpö ‑zë bhë ꞊ya ‑püö ‑a ‑ta, ‑yö ‑dho ‑a zɔn ꞊trüütrüüdhö.» ");
INSERT INTO dnj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","꞊Dhɛ 'ö slabhomɛ ‑nu ‑gɔmɛ waa‑ Falizi ‑mɛ ‑nu, ꞊wa Yesu ‑wo 'ö ꞊nɛ ‑a ma, 'wo‑ ꞊tɛi' dɔ ꞊nɛ wo ‑de gia‑ 'ö wo ‑bha 'wun ꞊blɛɛ' ‑na bhë. ");
INSERT INTO dnj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","'Yö 'wo yö ‑a këdhɛ ꞊mɛɛ' ‑sü ‑bha kö 'waan‑ Yesu 'kun, 'kɛɛ 'suö ‑yö ‑kë ‑an kë ꞊dhia mɛ ‑gbaa ‑nu 'wo Yesu sü ꞊nɛ ‑Zlan ‑wodhiölomɛ 'dhö bhë ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu ‑yö ‑ko 'zü, 'yö 'wun ꞊blɛɛ 'wun ꞊zuan' ‑zɔn ‑an ‑dhë ‑sü 'ka, 'to ‑to ö ‑bha ‑mɛ ‑nu ‑dhë 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Pë 'ö ‑Zlan ‑bha ‑gludëdhɛ ‑yö bhɔ ‑a ‑bha 'ö tɔɔ: ‑Gludë do ‑yö ö gbö ‑bha dhe 'sü 'wlaan‑ yi ‑da 'dhuu. ");
INSERT INTO dnj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","'Yö ö bha yuökëmɛ ‑nu 'bhaa bɔ mɛ ‑nu 'yö ‑an ꞊dhɔɔ ‑kë 'wlaan‑ ‑ta bhë ‑an ‑dhë kö ‑waan nu. 'Kɛɛ waa 'we ‑a ‑bha kö ‑waan nu. ");
INSERT INTO dnj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","'Yö ö bha yuökëmɛ ‑nu 'bhaa bɔ, 'yö‑ pö ‑an ‑dhë: ‹‑Kaa pö mɛ ‑nu 'a ‑an ꞊dhɔɔ ‑kë bhë ‑an ‑dhë: ‑Bhöpë ꞊ya ma; 'ma ma ‑du ‑nu waa‑ ma ‑tuë 'ö‑ 'yɔn ꞊ya kë bhë, 'ma ‑an zë, pë 'plɛ 'dhiö ꞊ya ‑mɔ 'kuë; ‑ka nu dhe 'sü 'wlaan‑ 'ö bhë ‑a ‑ta!› ");
INSERT INTO dnj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'Kɛɛ 'wlaan‑ bhë ‑a ‑wun yaa kë ‑an 'gü 'wun gbɛ 'ka, 'ö 'wo dho wo kë yuö ‑nu ꞊taa. Mɛ ꞊ya ꞊luu'‑, 'dho 'ö‑ wo ö ‑gɔ ꞊bhlöö‑, 'ö‑ mɛ 'bhaa ꞊ya ꞊luu'‑ ‑de, 'dho 'ö‑ wo ö bha pë 'dhɔɔ dɔ ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","'Ö‑ mɛ 'bhaa ‑nu ‑wo yuökëmɛ ‑nu 'wo bhë ‑an kun. ꞊Dhɛ 'wo ‑an 'klo bhɔ, 'wo ‑an zë. ");
INSERT INTO dnj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'Ö 'wun ‑yö ‑na ‑gludë ‑zuë, 'yö ö bha 'dhasi ‑nu bɔ, 'ö mɛzëmɛ ‑nu 'wo bhë 'wo ‑an zë, 'wo ‑an ‑bha pödhɛ ‑güö. ");
INSERT INTO dnj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","'Go mü 'ö‑ pö ö bha yuökëmɛ ‑nu ‑dhë: ‹Dhe 'sü 'wlaan‑ ‑pë ꞊ya ‑mɔ, 'kɛɛ mɛ ‑nu 'a ‑an ꞊dhɔɔ ‑kë bhë, waa nu gbɔ. ꞊Dhɛ 'ö 'dhö, yaa ‑an ‑bha 'kun kö ‑waan ‑a ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","‑Ka 'dho ‑kpinngga ꞊vava ‑nu 'piö, mɛ 'saadhö 'ka 'dhoë‑ ‑an yö, ‑ka ‑an ꞊dhɔɔ kë, ‑wo nu 'wlaan‑ 'ö ꞊nɛ ‑a ‑ta!› ");
INSERT INTO dnj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","'Ö yuökëmɛ ‑nu ‑wo dho zian ‑gbloo 'piö ‑dhɛ ‑nu ‑bha, 'wo mɛ këwunsëëzë ‑nu, mɛ këwunyaazë ‑nu, 'wo ‑an ꞊kpaa kpa 'kuë‑, 'wo nu ‑an 'ka, 'ö 'wlaan‑ ‑kë ‑a 'gü ‑kɔ ‑yö pa. ");
INSERT INTO dnj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","'Ö ‑gludë ‑yö ‑da kɔɔ kö mɛ ‑nu 'ö ‑an ꞊dhɔɔ ‑kë bhë, ‑yaan ö 'yan dɔ ‑an ‑bha. ‑A 'yan ‑yö ‑da gɔɔn‑ do 'ö dhe 'sü 'wlaan‑ ‑sɔ yaa kë ‑a ‑bha ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","'Ö‑ pö ‑a ‑dhë: ‹N 'bhamɛ, ü‑ ‑kë ‑kɔklë 'ü ‑da kɔɔ, 'kɛɛ kö dhe 'sü 'wlaan‑ ‑sɔ 'yaa ü ‑bha ‑ɛ?› Gɔɔn‑ bhë, ꞊dhɛɛ' 'ö kpɔ ‑a ‑gɔ bhë, yaa‑ ‑daa kë. ");
INSERT INTO dnj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑gludë ‑ya pö ö bha yuökëmɛ ‑nu ‑dhë: ‹‑Ka ‑a ‑gɛn ‑nu ‑lö, 'ka‑ ‑kɔ ‑nu ‑lö, 'ka‑ ‑zuö ‑dhɛtiidhɛ 'gü plaan, ‑dhɛ bhë ‑a 'gü, 'yö dho 'gbo ‑nu bɔ, 'yö ö 'sɔn ‑nu ‑bhö ‑a ‑bha.› » ");
INSERT INTO dnj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","'Ö Yesu ‑yö ö ‑wo ‑zuöatadhe ‑kë 'ö‑ pö: «Bhii ‑wo mɛ ‑nu ꞊dhɔɔ ‑kë ꞊va, 'kɛɛ ‑an mɛ ‑nu 'wo dho sü ‑an 'gü ꞊wo 'tee.» ");
INSERT INTO dnj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Falizi ‑mɛ ‑nu ‑wo ‑dho wo 'kuë‑, 'wo 'slë ꞊mɛɛ kö ‑waan Yesu 'kun ö ‑de ‑wo ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","'Ö 'wo wo ‑bha mɛ 'bhaa ‑nu waa‑ Elɔdö ‑bha mɛ 'bhaa ‑nu bɔ Yesu 'piö, 'ö 'wo Yesu ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Yi ‑Gɔmɛ, yi‑ ꞊dɔa' ꞊nɛ ü 'wun gia‑ ‑blɛɛ, 'ö 'ü mɛ ‑nu ‑daan 'wun giagia 'ö zian 'ö dho ‑Zlan 'piö 'ö‑ ‑zɔn ‑a 'ka; 'bhaa 'suö mɛ 'bhee‑ ‑bha ‑zo ‑ta ‑a 'gü ‑wun ‑dhë, bhii ü ‑zo 'yaa kë mɛ ‑nu 'yan 'dhiö ‑pë 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","꞊Dhɛ 'ö 'dhö, 'wun 'ö ꞊nɛ ‑kɔ 'ü ü ‑zo ꞊taa' ‑a 'gü ‑a ꞊blɛɛ'‑ yi ‑dhë, 'ö tɔɔ kwa ‑bha tɔng ‑yö ‑we ‑a ‑bha kö 'kwa 'nii‑ ꞊sɔnng' bho ‑gludë Sezaa ‑dhë ee, 'iin ‑daa ee?» ");
INSERT INTO dnj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu 'yö ‑an ‑bha ‑zotadhe yaa 'ö ‑an 'gü ‑a ‑dɔ bhë, 'ö‑ pö ‑an ‑dhë: «Mɛ ‑nu 'yan ‑ta ‑wun kë ‑mɛ ‑nu 'ka ꞊nɛ! ‑Më 'yö ‑kë 'ka n 'gü dan ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","‑Ka 'wëü‑ 'wo 'nii‑ ꞊sɔnng' bho ‑na ‑a 'ka bhë, ‑kaa do nu n ‑dhë 'a‑ ‑ga 'kwee‑!» 'Ö 'wo dönie ga do nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «Dö 'ö‑ ‑gɔ 'bin waa‑ ‑a 'tɔ 'wo ‑ya ‑sü 'ka zö ꞊nɛ ꞊ɛ?» 'Wo‑ pö ‑a ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","«Sezaa ‑mü.» 'Ö‑ pö ‑an ‑dhë: «Kö pë 'ö Sezaa ‑bha 'ka, ‑ka ‑a nu Sezaa ‑dhë; 'ka pë 'ö ‑Zlan ‑bha 'ka, 'ka‑ nu ‑Zlan ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","꞊Dhɛ 'ö 'wun ‑daa ꞊suu'‑ kë ‑kɔ 'ö bhë ꞊waa‑ ma, 'ö ‑an 'te giagia ‑yö tun 'gbönggböng, 'yö 'wo‑ to mü, 'wo ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","‑Dhɛkpaɔyi gia‑ bhë ‑a 'ka, Saduse ‑mɛ ‑nu 'wo‑ pö ‑na gamɛ ‑nu 'ka dho go ga 'gü bhë, ‑wo ‑nu Yesu 'piö, 'wo yö ‑a ꞊dhɛɛ' 'kpɔ ‑sü ‑bha ‑kɔ ꞊suu'‑ ꞊nɛ ‑a 'ka: ");
INSERT INTO dnj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Yi ‑Gɔmɛ, Moizö ‑ya ‑pö yi ‑dhë: ‹꞊Ya kë ꞊nɛ gɔɔn‑ yaa 'në 'kpɔ, ꞊ya ga, ‑a dheglu 'nëgɔɔnzë ꞊nɛ 'ö dho ‑a ‑bha ꞊gɛandhe bhë ‑a sü, 'ö 'wo 'në kpɔ ö dheglu 'ö ga bhë ‑a pin ꞊taa.› ");
INSERT INTO dnj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","'Kɛɛ yi 'piö zö dheglu 'në gɔɔn‑ ‑nu 'slaplɛ ‑wo ‑kë ‑dhö, 'ö‑ mɛ ‑blɛɛzë ‑yö dhe sü, 'ö yaa 'në 'kpɔ 'ö ga, 'ö ꞊gɛandhe 'ö bhë 'yö to ‑a dheglu 'në gɔɔn‑ ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","‑Kɔ do bhë 'ö ꞊kaa' ‑a mɛ kë ꞊plɛ ‑naa ‑gɔ; 'ö ꞊kaa' 'zü ‑a mɛ kë ‑yaaga ‑gɔ, 'ö dhegluzë 'slaplɛ 'wo bhë 'ö ‑kë ‑an 'plɛ ‑gɔ 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","꞊Dhɛ 'ö ‑an 'plɛ ꞊wa ga, 'yö dhebɔ ‑de 'pö, 'ö ga. ");
INSERT INTO dnj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","‑Go ga 'gü ‑yi 'ka, mɛ 'slaplɛ 'wo bhë, dö ‑zë 'yö dho kë ‑a bɔɔ 'ka ɛ? Bhii ‑dhɛ 'wo‑ ‑bha 'töüdhö ‑yö ‑kë ‑an 'plɛ bɔɔ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ka ‑de ‑püö 'ka ‑a wo bhë, 'ö tɔɔ 'kaa pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü waa‑ ‑Zlan ‑bha 'piigbeedhɛ ‑an gbɛ dɔ. ");
INSERT INTO dnj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bhii ‑go ga 'gü ‑yi 'ka, 'kosüdhe 'ka 'dho kë gɔɔn‑ waa‑ dhe ‑an ziën, 'kɛɛ ‑wo ‑dho kë ꞊nɛ ‑Zlan ‑bha bɔmɛ ‑nu 'wo dhang‑ 'gü bhë ‑an 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Kɛɛ ‑a mɛ 'ö ‑gban mɛ ‑nu 'ö 'waa ‑dhö gbɔ waa‑ ‑an ‑bha ‑go ga 'gü ‑sü ‑bha bhë, 'wun do ‑yö ‑dhö 'ö ‑kë ‑Zlan ‑wo 'ka, 'ö ‑ya ‑sü 'ka ‑a ‑bha 'sëëdhɛ 'gü. ‑A mɛ bhë kaa‑ pö ꞊a? ‑Ya ‑pö: ");
INSERT INTO dnj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","A Ablaamö ‑bha ‑Zlan 'ka, a Izaakö ‑bha ‑Zlan 'ka, 'ö 'a Zakɔbö ‑bha ‑Zlan 'ka. ‑Zlan ‑yö mɛ ‑nu 'wo 'bhee‑ ꞊toëpö 'ka ‑an ‑bha ‑Zlan 'ka, 'yaa gamɛ ‑nu ‑bha ‑Zlan 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mɛ ‑gbaa ‑nu 'wo‑ ‑bha mɛ ꞊daan' ‑wo 'ö bhë ‑a ma, 'tetundhe ꞊va ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","꞊Dhɛ Falizi ‑mɛ ‑nu ꞊waa‑ ma ꞊nɛ Yesu ‑bha 'wun ‑daa kë ‑kɔ bhë ꞊ya Saduse ‑mɛ ‑nu 'dhi yö 'kuë‑, ꞊wa ziö, 'ö 'wo dho wo 'ko ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Ö ‑an ziën Zuifö ‑nu ‑bha tɔnggɔmɛ do ‑yö go ‑an 'piö, 'ö‑ ‑kë kö 'yaan‑ 'slë 'kan Yesu ‑gɔ. 'Yö‑ ꞊dhɛɛkpɔdhe ‑kë 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«N ‑Gɔmɛ, kwa ‑bha tɔng ‑nu 'wo ꞊nɛ ‑a ‑mlë 'ö‑ ‑wun 'dhö 'gbee‑ ‑e?» ");
INSERT INTO dnj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü ‑dho ü Dëmɛ, ü ‑bha ‑Zlan, ‑dhɔ kë ü ꞊zuöga 'plɛ 'ka, ü nii 'plɛ 'ka, ü ‑zo ‑ta ‑a 'gü ‑wun ‑nu 'plɛ 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yö ꞊nɛ 'ö tɔɔ tɔng ꞊vaazë 'ö‑ ‑wun 'dhö 'gbee‑. ");
INSERT INTO dnj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","'Go mü ‑a mɛ 'ö yö ‑a 'piö 'ö‑ ‑wun 'dhö 'gbee‑ 'ö bhɔ ‑a ‑blɛɛzë bhë ‑a ‑bha 'ö ꞊nɛɛ: Ü ‑ya 'yɔɔ ‑dhɔ ‑yö ü kë ꞊nɛ ‑kɔ 'ö 'ü ü ‑de ‑dhɔ ꞊kaa' ‑a 'dhö! ");
INSERT INTO dnj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moizö ‑bha tɔng 'saadhö waa‑ ‑Zlan ‑wodhiölomɛ ‑nu ‑bha mɛ ꞊daan' ‑wo 'saadhö 'wo bhë ‑an 'plɛ ‑wo ‑gban tɔng ꞊plɛ 'wo ꞊nɛ ‑an ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","꞊Dhɛ ‑kë ꞊nɛ Falizi ‑mɛ ‑nu ‑wo ‑kë wo 'ko ꞊bhaa bhë, 'ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ, 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Ka ka ‑zo ‑ta ‑Zlan ‑bha ‑Yamɛ ‑wun 'gü ‑kɔklë ꞊ɛ? ‑Yö ‑go dö ꞊suu'‑ ‑ta 'gü i?» 'Wo‑ pö ‑a ‑dhë: «‑Yö ‑go Davidö ꞊suu'‑ ‑ta 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","'Ö Yesu ‑ya pö ‑an ‑dhë: «꞊Dhɛ 'ö 'dhö, ‑më 'ö ‑kë 'ö ‑Zuu 'slööslö ‑yö 'dhiö sü Davidö 'ka, 'ö Davidö ‑ya ‑dhɛ ö Dëmɛ ‑ɛ? Bhii Davidö ‑ya pö ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","N Dëmɛ (‑Zlan), ‑ya pö n Dëmɛ ‑dhë: ‑Bhö ‑ya ‑yadhɛ ꞊bhlëzë 'ö ꞊nɛ ‑a ‑bha, ‑yö ‑dho ‑yö yöë yi 'a dho toë ‑a 'gbee‑ 'ka ü yaagümɛ ‑ta ‑sü nu ü ‑dhë bhë ‑a ‑bha! ");
INSERT INTO dnj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","꞊Dhɛ 'ö Davidö gia‑ ‑ya ‑dhɛ ö Dëmɛ, ‑yö ‑kɔklë 'ö ‑Zlan ‑bha ‑Yamɛ ‑zë ‑yö go Davidö ꞊suu'‑ ‑ta 'gü i?» ");
INSERT INTO dnj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mɛ do gia‑ yaa kë ‑dhö kö ‑yaan ‑a ‑daa kë ‑a ‑gɔ. 'Yö sü ‑a yi 'ö 'dhö bhë ‑a ‑bha, mɛ gbɛ ‑zo yaa ‑gban gbɔ kö ‑yaan ꞊dhɛɛ' gbɛ 'kpɔ ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya ‑pö mɛ ‑gbaa ‑nu waa‑ ö bha ꞊guë' ‑nu ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu ‑yö ‑dɔ ‑an kwɛɛ ‑sü 'ka kö ‑waan Moizö ‑bha tɔng bho 'kou ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","꞊Dhɛ 'ö 'dhö, pë 'töüdhö 'wo dho ‑a pö ka ‑dhë bhë, ‑kaa kë! 'Kɛɛ kö ꞊kun 'ka 'wun ‑kë ꞊nɛ ‑an ‑bha 'wun kë ‑kɔ 'dhö! Bhii pë 'wo mɛ ‑nu ꞊daan' ‑na ‑a 'ka bhë, wo ‑zë 'waa ‑a kë. ");
INSERT INTO dnj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","‑Wo ꞊kwɛɛ‑ 'gbiin‑ ‑sü, 'wo‑ dɔ mɛ ‑nu gban tuö, 'kɛɛ 'waa 'we ‑a ‑bha kö ‑wo wo ‑kɔnëga do gia‑ ‑de dɔ ‑an ‑gɔ, ‑nu ‑an ‑dhë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","'Wo wo ‑bha 'wun ‑nu ‑kë, kö mɛ ‑nu ‑wo wo 'yan bɔ ‑an 'piö. ‑Kɔ bhë ꞊nɛ ‑a 'ka 'ö ‑Zlan ‑wo kpö kpö ‑nu 'wo ‑da ‑na wü kwi ꞊bhɔɔ' 'gü, 'wo‑ ‑ya ‑na wo ‑kpong ‑nu waa‑ wo ‑gbiö ‑nu ‑bha bhë 'wo‑ ‑kë 'gbɛagbɛa. 'Ö ꞊ya kë 'zü, 'wo wo ‑bha gblang 'saa ‑nu ‑kë ꞊gbiingbiin. ");
INSERT INTO dnj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Wo ‑yadhɛ ꞊vava ‑nu sü pë ‑bhö ‑dhɛ ‑nu ‑bha, 'ö 'wo ‑yadhɛ ‑sɛɛbɔ ‑nu sü Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Ö 'wo‑ ‑dhɔ ‑kë ‑mɛɛ ‑kë wo 'ka ꞊bhlë 'ka ‑sü 'gü 'dhëëdhɛ ꞊vava ‑nu ‑bha, 'iin kö mɛ ‑nu ‑waan wo ‑dhɛ wo ‑gɔmɛ. ");
INSERT INTO dnj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","'Kɛɛ ka ‑zë, kö ꞊kun 'ka‑ ‑kë 'wo ka ‑dhɛ ‑gɔmɛ. ");
INSERT INTO dnj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kö ꞊kun 'ka mɛ gbɛ ‑dhɛ 'kpongtaa ka dë. Bhii ka dë ‑yö dosɛn 'kpaan, 'yö 'ö dhang‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kö ꞊kun 'ka‑ ‑kë 'wo ka ‑dhɛ ꞊kɔɔnmɛ. Bhii ka ꞊kɔɔnmɛ ‑yö do, 'yö tɔɔ ‑Zlan ‑bha ‑Yamɛ. ");
INSERT INTO dnj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mɛ 'ö dho kë mɛ ꞊va 'ka ka ziën, ‑yö kë ka 'dhiö ‑yuökëmɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mɛ 'ö 'dhoë‑ ö ‑de ꞊luu'‑, ‑Zlan ‑yö ‑dho ‑a dho sia‑, 'ö mɛ 'ö 'dhoë‑ ö ‑de sü 'tee, 'ö ‑Zlan dho ‑a ꞊luu'‑.» ");
INSERT INTO dnj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","'Ö Yesu ‑ya pö 'zü: «'Yena ‑wun ꞊ya kë Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu kaa‑ Falizi ‑mɛ ‑nu 'ö 'ka mɛ ‑nu 'yan ‑ta ‑pë kë ‑mɛ ‑nu 'ka, ka 'ka! Bhii ka ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'dhi ‑ta mɛ ‑nu ‑gɔ. Ka gia‑ ‑de, 'ö ka 'ka 'dhö ‑da ‑a 'gü bhë 'ö 'kaa 'we ‑a ‑bha kö mɛ ‑nu 'wo‑ 'piö kö ‑wo ‑da ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü bhë, ‑wo ‑da ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","'Yena ‑wun ‑dho kë Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu kaa‑ Falizi ‑mɛ ‑nu ka 'ka! Mɛ ‑nu 'yan ‑ta ‑pë kë ‑mɛ ‑nu! Ka ꞊gɛandhoo ‑nu ‑bha pë 'plɛ ‑kun ‑an ‑gɔ! ꞊Ya 'go mü, 'ö 'ka ꞊bhɛawodhe ꞊gbiingbiin ‑kë kö 'kaan‑ kë mɛ ‑nu wö 'dhiö mɛ kpengdhö 'ka. ‑A ‑wun 'gü 'klobhɔdhe ꞊va ‑yö ‑dho wɔ ka ‑ta! ");
INSERT INTO dnj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu kaa‑ Falizi ‑mɛ ‑nu, ka ‑bha ‑yö 'yenazë; 'ö tɔɔ mɛ 'yaankunmɛ ‑mü kaa. 'Ka ꞊luu' ꞊nëdhö kö ka 'dho ‑sü ‑mü ‑dhɛ 'saadhö 'gü 'kpongtaa 'yootadhɛ ‑nu ‑bha kö mɛ ‑nu 'ö 'waa Zuifö 'ka bhë, 'kaan‑ kë ‑waan ‑da ka ‑bha ‑bhɛa ‑Zlan ‑dhë ‑kɔ bhë ‑a 'gü. 'Ö ꞊ya kë mɛ ‑nu 'wo bhë, ꞊wa kë ‑dhö ka ‑gɔ 'dhö, ka ‑ko 'zü 'ka ‑an ‑kë ꞊glöötiaandhö 'siö 'gü ‑mɛ 'ka ‑gwaa ꞊plɛ ‑naa wo 'wo ꞊zië' ka ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","'Yena ‑wun ‑yö kë ka 'ka, ‑yö mɛ ‑dhë 'dhiö ‑mɛ ‑nu 'yënngtiizë! Ka‑ ‑pö mɛ ꞊ya ‑wo ‑bhö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'tɔ 'ka, kö yaa ‑wo ‑bhö ꞊kun; 'kɛɛ mɛ 'ö ꞊ya ‑wo ‑bhö 'sënng 'ö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü bhë ‑a 'tɔ 'ka, kö ꞊ya ‑sö gia‑ ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","'Kaa 'wun ‑bho 'kou dɔ, 'yënngtiimɛ ‑nu! Pë ꞊plɛ 'wo bhë, ‑a ‑mlë 'ö‑ ‑wun 'dhö 'gbee‑ ‑e? 'Sënng ‑mü ee, 'iin ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑mü ee? Bhii ‑Zlan ‑gba ‑a 'gü ‑kɔ ꞊nɛ 'ö 'sënng ‑kë 'slööslö. ");
INSERT INTO dnj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","'Ka‑ pö 'zü: Mɛ ꞊ya ‑wo ‑bhö ‑Zlan ‑bha slabhodhɛ 'tɔ 'ka kö yaa ‑wo ‑bhö, 'kɛɛ ꞊ya ‑wo ‑bhö gbapë 'ö slabhodhɛ ‑bha bhë ‑a 'tɔ 'ka kö ꞊ya ‑wo gia‑ ‑bhö ꞊nɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","'Yënngtiimɛ ‑nu, pë 'plɛ 'wo bhë, ‑a ‑mlë ‑zë 'ö‑ ‑wun 'dhö 'gbee‑ ‑e? Gbapë ‑mü ‑i, 'iin slabhodhɛ 'ö gbapë ‑kë 'slööslö bhë yö ‑mü ‑i? ");
INSERT INTO dnj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'Kɛɛ a‑ ‑pö ka ‑dhë: Mɛ 'ö ‑wo ‑bhö ‑na slabhodhɛ 'tɔ 'ka bhë, kö ꞊ya ‑wo ‑bhö gbapë waa‑ pë ‑nu 'ö ‑an ‑ta dhuö 'töüdhö ‑an 'tɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mɛ 'ö ꞊ya ‑wo ‑bhö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'tɔ 'ka, kö ꞊ya ö ‑wo ‑bhö ‑Zlan ‑gba ‑a 'gü ‑kɔ waa‑ ‑Zlan gia‑ 'ö 'kɔ bhë ‑a 'gü bhë ‑an 'tɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mɛ ꞊ya ‑wo ‑bhö dhang‑ 'gü ‑dhɛ 'tɔ 'ka, kö ꞊ya ‑wo ‑bhö ‑Zlan ‑bha 'gɔ ‑gbloo waa‑ ‑Zlan gia‑ 'ö ‑ya ‑na ‑a 'gü bhë ‑an 'tɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","'Yena ‑wun ꞊ya kë tɔnggɔmɛ ‑nu kaa‑ Falizi ‑mɛ ‑nu ka 'ka! Mɛ ‑nu 'yan ‑ta ‑pë kë ‑mɛ ‑nu! 'Ka ka ‑bha tapë ‑nu 'tëëtëzë 'wo 'toodhɛɛdhö ‑a kë 'gɔɔ‑ do ‑naa nu ‑Zlan ‑dhë, 'kɛɛ 'ka mɛ ꞊daan' ‑wo 'ö‑ ‑wun 'dhö 'gbee‑, ‑Zlan ‑bha tɔng 'ka bhë, 'ka‑ ‑san zë, 'ka ka ‑ta yö ‑kë kpengdhö ‑sü, mɛ 'yena yö ‑sü waa‑ ‑to ‑wo 'gü ‑sü ‑an ‑bha, 'kɛɛ kö wo ꞊nɛ 'ö 'ka dho ‑an 'kpuɛ‑ kpɔ ‑së 'ka. 'Go mü, kö ꞊kun 'ka ‑an mɛ ‑nu 'wo to, 'ka ‑an ‑san zë! ");
INSERT INTO dnj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ka 'ö 'ka 'yënngtiimɛ 'ka, 'ka‑ pö 'ka yö 'yënngtiimɛ ‑dhë 'dhiö a? Ka ka ‑bha ‑drɔɔn ‑nu ‑kë 'slööslö, 'kɛɛ kö ꞊kun 'ö 'ka zɛnpë bho ‑a ꞊bhaa, 'ö ka ‑yɔɔnmia ‑to ‑a ꞊bhaa 'ö 'ka‑ ꞊yɔɔ! ");
INSERT INTO dnj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","'Yena ‑wun ‑dho kë ka 'ka! Tɔnggɔmɛ ‑nu kaa‑ Falizi ‑mɛ ‑nu 'ö 'ka mɛ ‑nu 'yan ‑ta ‑pë kë ‑mɛ ‑nu 'ka ꞊nɛ! Ka ka ‑bha 'yi ‑mü ‑a 'gü ‑pë waa‑ pë ‑bhö ‑a 'gü ‑pë ‑nu plaan ‑dhɛ ‑zlu, 'kɛɛ ‑an 'gü ꞊zian' ‑wo pa ‑sü 'ka ka ‑bha ꞊kwaanpë ‑nu, ka ꞊dhɔɔbhaapë yaa ‑nu 'wo bhë ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falizi ‑mɛ 'yënngtiizë ‑nu! Ü ‑bha pë ‑bhö ‑a 'gü ‑pë ‑nu 'gü 'zlu 'dhiö ‑blɛɛzë kö 'üën‑ ꞊tun ‑an plaandhɛ 'zlu ‑na kö ‑yaan kë 'puu. ");
INSERT INTO dnj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","'Yena ‑wun ‑dho kë Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu kaa‑ Falizi ‑mɛ ‑nu ka 'ka! Mɛ ‑nu 'yan ‑ta ‑pë kë ‑mɛ ‑nu! Ka ‑bhɔ blɔɔn‑ 'wo‑ ‑flö 'yɔɔ 'ka kö ‑yaan kë ‑së ‑a ‑bha, 'kɛɛ ‑an 'gü ꞊zian' bhë, mɛ ga ga 'lü ‑de 'sloo waa‑ pë 'bu ‑sü ꞊nɛ 'wo ‑an pa. ");
INSERT INTO dnj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ka ‑de gia‑, ka bun ‑bha, ka ‑kë mɛ ‑nu wö 'dhiö ‑së, 'kɛɛ ka 'gü ꞊zian', ka pa ‑sü 'ka mɛ 'yan ‑ta ‑wun kë ‑sü waa‑ pë yaa ‑an 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","'Go mü 'zü 'ö Yesu ‑ya pö: «'Yena ‑wun ‑dho kë Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu kaa‑ Falizi ‑mɛ ‑nu ka 'ka! Mɛ ‑nu 'yan ‑ta ‑pë kë ‑mɛ ‑nu! 'Ka ‑Zlan ‑wodhiölomɛ ‑nu blɔɔn‑ ‑dɔ ‑së 'ka, 'ö 'ka mɛ ‑nu 'wo ‑kë kpengdhö, 'ka ‑an blɔɔn‑ ‑yuö ‑kë ‑së 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Ö 'ka‑ pö: ‹꞊Ya kë ꞊nɛ yi ‑kë yi 'bhɛma ‑nu ‑bha 'töng 'ka ‑be, yi 'ka 'dho kë ꞊nɛ ‑an 'dhö, kö yi 'plɛ 'yiën‑ kë ‑Zlan ‑wodhiölomɛ ‑nu zëmɛ ‑nu 'ka›. ");
INSERT INTO dnj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","꞊Ya kë 'dhö kö ka ka ‑de ‑dɔ ꞊nɛ, ka mɛ ‑nu 'wo ‑Zlan ‑wodhiölomɛ ‑nu zë bhë ‑an ꞊suu'‑ ‑ta ‑nu 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","꞊Dhɛ 'ö 'dhö, ‑ka 'dho ka 'dhiö, 'ka yuö 'ö ka 'bhɛma ‑nu 'wo 'dhiö ꞊zian' 'wo‑ kë bhë, 'ka‑ 'dhiö 'to! ");
INSERT INTO dnj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","꞊Mɛɛ ‑nu, ꞊bhöü‑ 'në 'sɛɛn‑ ‑nu 'ka ꞊nɛ! Ka ‑dho ‑a kë ‑kɔklë kö ꞊kun 'ö 'ka dho 'klobhɔdhe 'ö ꞊glöötiaandhö 'siö 'gü bhë ‑a yö ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","‑A ‑wun 'gü, ‑ka ka 'to 'to! A ‑dho ‑Zlan ‑wodhiölomɛ ‑nu, mɛ 'kpaakpa ‑nu, mɛ ‑nu 'wo pë dɔ ‑nu, ‑an bɔ ka ‑dhë; ka ‑dho ‑a mɛ 'bhaa ‑nu zë, 'ka‑ mɛ 'bhaa ‑nu dɔ ‑gaatalü ‑bha, 'ka ‑an mɛ 'bhaa ‑nu ‑ma ‑klaa 'ka, ka ‑bha ‑bhɔkuëkɔ ‑nu 'gü, 'ö 'ka dho ziö ‑an 'piö pödhɛ ‑nu 'wo dhö bɔ ‑an ‑bha ‑a 'gü kö 'kaan‑ ‑an 'klo bhɔ. ");
INSERT INTO dnj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","‑Kɔ 'ö bhë ‑a 'ka, ka 'klo ‑dho bhɔ mɛ ‑nu 'ö waa pë gbɛ kë 'ö mɛ ‑nu ‑wo ‑an zë, 'ö‑ zü ‑yö dɔ Abɛlö 'ö kpengdhö ‑a ‑ta, 'ö dho 'ö yöë Zakali 'ö Balasi gbö 'ka, 'ö 'ka ‑an zë ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü ‑dhɛ 'slööslö ‑dhɛ waa‑ slabhodhɛ ‑an ziën bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: Mɛ zë ‑sü 'klobhɔdhe ‑nu 'wo bhë ‑an 'plɛ ‑wo ‑dho nu mɛ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü bhë ‑an ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","'Yö Yesu ‑ya pö: «Zeluzalɛmë, Zeluzalɛmë, bhi 'ü ‑Zlan ‑wodhiölomɛ ‑nu zë ‑na, 'ü mɛ ‑nu 'ö ‑Zlan 'dhö ‑an bɔ ‑na, 'ü ‑an zë ‑na ‑guö 'ka! ‑A ‑gwaa kë ꞊dhë ‑naa 'a‑ 'piö kö 'a ü 'gü ‑mɛ ‑nu 'kpɔ 'kuë‑ n 'piö ꞊nɛ ‑tɔ mu ‑yö ö bha 'në ‑nu kpɔa 'kuë‑ ö gban ꞊löö bhë ‑a 'dhö, 'kɛɛ ü 'ka 'we ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","꞊Dhɛ 'ö 'dhö, kö ‑Zlan ‑kwaa ü bha 'kɔ ‑wun ‑zü ‑sü ‑mü ö 'plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","‑A ‑kë 'dhö ‑sü 'ka, a‑ ‑pö ka ‑dhë: 'Go ꞊dɛɛ ‑bha zlöö, ka 'ka 'dhö n yö gbɔ 'ö dho 'ö yöë yi 'ö 'ka dho ‑a pöë: ‹'Dhuë‑ ‑yö 'to mɛ 'ö nu ‑na kwa Dëmɛ 'tɔ 'gü ‑a ‑ta!› bhë ‑a ‑yi ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu ‑yö ‑go ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü. ‑Yö ‑kë 'dho ꞊dhia, 'ö‑ ‑bha ꞊guë' ‑nu ‑wo ‑yɔɔn ‑a ‑bha kö ‑waan ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑nu ‑kë ‑së ‑kɔ bhë ‑a ‑zɔn ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","'Ö Yesu ‑ya pö ‑an ‑dhë: «Pë ‑nu 'wo ꞊nɛ, ka ‑an ‑yö ‑a? A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ‑Guö ‑nu gbɛ 'ka 'dho to wo 'ko ‑ta dhuö zö, ‑an 'plɛ ‑wo ‑dho ‑lo.» ");
INSERT INTO dnj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu ‑yö ‑dho Olivie ‑tɔn tuö, 'ö ꞊yaannu; 'ö‑ ‑bha ꞊guë' ‑nu ‑de 'sloo ‑wo ꞊yɔɔn ‑a ‑bha, 'wo ꞊dhɛɛkpɔdhe ‑kë ‑a ‑gɔ ‑a pö ‑sü 'ka ꞊nɛɛ: «Pë ‑nu 'wo bhë ‑wo ‑dho kë 'töng ‑mlë 'ka, 'iin ꞊duakëpë ‑mlë 'yö dho kë kö ‑yaan ü bha nu ‑yi waa‑ 'kpongtaadhɛ 'dhiötoyi ‑an ‑zɔn ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Ka ka ‑zo kë ka ‑de 'piö kö ꞊kun mɛ gbɛ‑ ka ‑püö! ");
INSERT INTO dnj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bhii mɛdhɛvadhɛ ‑wo ‑dho nu n 'tɔ 'ka 'ö 'wo‑ pö ‑Zlan ‑bha ‑Yamɛ ‑mü wo 'ka. ‑Wo ‑dho mɛdhɛvadhɛ ‑püö. ");
INSERT INTO dnj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ka ‑dho ‑glu ‑drinng ‑nu ma ka 'sɔɔ ‑dhɛ ‑nu ‑bha; 'ka ‑glu ‑wun ‑taɔ ma ka 'ka ꞊gbiin. Kö ꞊kun 'ö 'suö ‑yö ka ‑kë 'gbɛɛdhö! Pë ‑nu 'wo bhë ‑wo ‑dho kë, 'kɛɛ kö 'kpongtaadhɛ 'dhiötoyi 'yaa ‑mü ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Sɛgɔ ‑dho ‑glu gɔn ö 'bha 'sɛgɔ 'ka, 'ö ‑gludëdhɛ ‑kpa 'kuë‑ ‑sü nu dho ‑glu gɔn ‑an ‑kpa 'kuë‑ ‑sü gbɛ 'ka. Din ‑bha ‑da dhe waa‑ 'sɛ ‑bha ꞊zluun ‑sü ‑nu ‑dho kë 'sɛgɔ 'bhaa ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pë ‑nu 'wo bhë ‑wo ‑dho kë ꞊nɛ 'në 'kpɔ ‑sü ‑bha 'yënngbhɔdhe zü dɔ ‑sü 'dhö dhebɔ ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","꞊Ya kë 'dhö 'sɛgümɛ ‑nu 'saadhö ‑wo ‑dho ka ‑san zë; n ‑wun 'gü ‑wo ‑dho ka dɔ mɛ ‑gɔ ꞊taa ‑mɛ ‑nu kwɛɛ kö ‑waan ka 'klo bhɔ, 'go mü ‑waan ka zë. ");
INSERT INTO dnj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","'Ö‑ 'töng 'dhö bhë ‑a 'ka, mɛdhɛvadhɛ ‑dho kan ‑zo yö ‑sü ‑bha; ‑wo ‑dho wo 'ko ‑püö, 'ö 'wo wo 'ko ‑nu ‑san zë. ");
INSERT INTO dnj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","‑Zlan ‑wodhiölomɛ ꞊suazë ‑nu ‑wo ‑dho nu, 'wo mɛdhɛvadhɛ ‑püö. ");
INSERT INTO dnj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'Wun yaa kë ‑sü ‑dho dho 'dhiö 'ö sa ‑dhɛ 'saadhö ‑a 'gü. ꞊Ya kë 'dhö zlöö kö ‑a ‑dhɔ ‑kë 'ko 'ka ‑sü ‑dho kan mɛ ‑nu ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","'Kɛɛ mɛ 'ö 'dhoë‑ dɔ gɛnngdhö ‑yaan 'dho ‑yaan yöë ‑a 'dhiötoyi ‑bha, ‑a mɛ 'ö bhë ‑yö ‑dho dha. ");
INSERT INTO dnj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","'Wuntaɔsë 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑bha bhë ‑yö ‑dho ꞊blɛɛ'‑ 'sɛ 'saadhö ‑a 'gü; ‑yö ‑kë 'dhö kö 'kpongtaamɛ ‑nu 'saadhö ‑waan ‑a ma. ꞊Ya kë 'dhö zlöö, 'ö 'kpongtaadhɛ ‑yö yën.» ");
INSERT INTO dnj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","'Yö Yesu ‑ya pö 'zü: «Ka ‑dho pë 'wo‑ ‑dhɛ «pë yaa ꞊lɔɔzë» 'ö ‑Zlan ‑wodhiölomɛ Daniɛlö ‑ya ‑wun ꞊blɛɛ bhë, ‑a yö kö ‑yö dɔ ‑sü 'ka ‑dhɛ 'slööslö ‑dhɛ ‑bha. Mɛ 'ö 'sëëdhɛ ‑be 'ö Daniɛlö ‑ya ꞊bɛɛn, 'yö‑ pö ‑na bhë ‑ya ‑gɛn ma ‑së 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","꞊Ya kë 'dhö, mɛ ‑nu 'wo Zude ‑sɛ 'gü ‑wo ꞊duë, 'wo dho ‑tɔn ‑nu 'piö ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","‑A 'töng bhë ‑a 'ka, mɛ 'ö 'dhoë‑ kë ö ‑gɔ 'kɔ tuö, ꞊ya ꞊yɔɔ', kö ꞊kun 'ö dho kɔɔ kö ‑yaan pë ‑nu 'sü ‑yaan zië. ");
INSERT INTO dnj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mɛ 'ö 'dhoë‑ kë ö ‑gɔ ꞊bhlöödhɛ ‑nu ‑bha, kö ꞊kun 'ö nu kɔɔ kö ‑yaan ö bha gblang 'sü. ");
INSERT INTO dnj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","꞊N 'n, ‑më 'yena ‑wun 'ö bhë yi 'ö 'dhö bhë ‑a 'ka, dhoo ‑nu 'wo 'guzë waa‑ ‑an mɛ ‑nu 'wo 'bëë‑ 'ka ‑an ‑bha 'ka ‑o! ");
INSERT INTO dnj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","'Kɛɛ ‑ka ‑bhɛa ‑Zlan ‑dhë kö ꞊kun 'ö ka ‑bha ꞊duë ‑yi ‑yö ‑kë 'nɛnɛ nu 'töng, 'iin ꞊glooyi ‑an 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bhii 'töng 'ö 'dhö bhë ‑a 'ka, 'klobhɔdhe ‑yö ‑dho kë ꞊gbaɔnsü, 'yö ꞊zië' ‑an mɛ ‑nu 'wo kë 'kpongtaadhɛ züdɔyi 'ka, 'ö nu 'ö yöë ꞊dɛɛ ꞊nɛ ‑a ‑bha bhë ‑an ‑ta, 'ö‑ ꞊suu'‑ gbɛ 'ka 'dho kë gbɔ. ");
INSERT INTO dnj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","꞊Ya kë ꞊nɛ ‑Zlan yaa ‑dhɛkpaɔyi ‑nu 'wo bhë ‑an 'bhaa bho 'piö ‑bezë, kö ‑kë ‑a 'gü ‑mɛ gbɛ 'yaa 'dhö kë ‑dhö. 'Kɛɛ ‑yö ‑dhɛkpaɔyi ‑bhɔ züë ö bha mɛ ‑nu 'ö ‑an sü bhë ‑an ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","'Töng 'ö 'dhö bhë ‑a 'ka mɛ ꞊yaa‑ pö ka ‑dhë: ‹‑Dhɛ ‑ga zö, ‑Zlan ‑bha ‑Yamɛ ‑yö zö!› 'iin ‹‑yö ‑de!›, kö ꞊kun 'ka‑ ‑wo ‑dhɛ 'wun gia‑! ");
INSERT INTO dnj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bhii ‑Zlan ‑bha ‑Yamɛ ꞊suazë ‑nu waa‑ ‑Zlan ‑wodhiölomɛ ꞊suazë ‑nu ‑wo ‑dho nu ‑waan wo ‑bha ꞊duakëpë ‑nu waa‑ ‑dhidhaapë ‑nu ‑an kë kö ‑waan mɛ ‑nu 'ö ‑Zlan ꞊ya ‑an 'sü 'saadhö bhë ‑an ‑püö ‑sü ꞊mɛɛ'‑. ");
INSERT INTO dnj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","꞊Dhɛ 'ma‑ yi 'to 'dhiö 'ma‑ ꞊blɛɛ'‑ ka ‑dhë bhë kö 'ka kë 'slë 'ka! ");
INSERT INTO dnj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","'Ö ꞊ya kë ꞊nɛ ꞊waa‑ pö ka ‑dhë: ‹‑Ka ‑dhɛ ‑ga zö, ‑yö 'yënng ꞊taa!›, kö ꞊kun 'ka dho 'ma! 'Go mü 'zü, mɛ ‑nu ꞊waa‑ pö ka ‑dhë: ‹‑Yö ‑bin ‑sü 'ka kɔɔ zö›, kö ꞊kun 'ka‑ ‑wo ‑dhɛ 'wun gia‑! ");
INSERT INTO dnj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","‑Kɔ do 'ö dha 'dhö 'ö 'yan bɔ ‑na ‑a 'ka lan‑ ꞊luu'‑ ‑zian waa‑ lan‑ ‑püö ‑zian ‑an 'ka bhë, ‑kɔ do bhë ‑a 'ka 'pö, 'ö ma Mɛgbö 'a dho nuë. ");
INSERT INTO dnj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bhii ‑dhɛ 'ö pë ꞊glöö ‑nu 'dhö ‑a ‑bha, ‑dhɛ bhë 'ö 'gblübhaa ‑nu ‑wo dho wo 'kuë‑ ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","'Yö Yesu ‑ya pö: «'Yënngbhɔyi ‑nu 'wo bhë ꞊wa ziö, lan‑ ‑dho trö, 'su ‑de 'pö yaa 'dho bhü, 'susongga ‑nu ‑wo ‑dho go dhang‑ ‑nu ‑bha, 'wo ‑püö, 'ö 'piigbeedhɛ ‑nu 'wo dhang‑ ‑nu 'gü, 'wo ꞊zluu. ");
INSERT INTO dnj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kö ma Mɛgbö n ‑ma ꞊duakëpë ‑wo ‑sü ‑mü dhang‑ 'gü. 'Sɛgümɛ ‑nu 'saadhö ‑wo ‑dho ma Mɛgbö n yö kö a nu ‑na dha kpö ‑nu ‑ta dhang‑ 'gü 'piigbeedhɛ waa‑ 'tɔbhɔdhe ꞊va ‑an 'ka. ꞊Ya kë 'dhö, ‑wo ‑dho 'gbo bɔ wo ‑de ꞊maa 'ma ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","'Truu 'we ‑wo ꞊va ‑yö ‑dho kë. ꞊Ya kë 'dhö, ‑Zlan ‑bha bɔmɛ ‑nu 'wo n 'piö bhë, a ‑dho ‑an bɔ 'kpongtaadhɛ 'pian ‑yiisië ‑ta, ‑waan n ‑ma mɛ ‑nu 'ö 'a ‑an sü 'kpongtaadhɛ 'dhiötodhɛ do do 'ö ‑dhö ‑a ‑bha bhë, ‑an kpɔ 'kuë‑ ‑dhɛ do 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","'Yö‑ pö 'zü: «Mɛ ꞊daan' ‑wo 'ö ‑gban figö ‑lü ‑bha ꞊nɛ, ‑kaa ‑ga bhë 'dhɛ: 'Ö tɔɔ ꞊ya kë ꞊nɛ ‑a ‑kɔ ‑nu ‑wo ꞊kpɛa' ‑na, ‑a 'dhɛ ‑nu ‑wo bhɔ ‑na, kö 'ka‑ dɔa ꞊nɛ ꞊kpɔɔ ꞊ya yö ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","‑Kɔ do bhë ‑a 'ka, 'wun ‑nu 'wo ꞊nɛ 'ka ‑an yö, kö ‑kaa dɔa ꞊nɛ ma Mɛgbö n nu ‑yi ꞊ya yö ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Mɛ ‑nu 'wo 'bhee‑ ꞊dɛɛ ꞊nɛ ‑a 'gü zö ꞊nɛ, pë ‑nu 'wo ꞊nɛ ‑wo ‑dho kë kö ‑an 'plɛ waa ga ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dhang‑ waa‑ 'kpongtaadhɛ ‑wo ‑dho ziö, 'kɛɛ n ‑wo ‑nu 'ka 'dho ziö 'gbɛɛdhö» ");
INSERT INTO dnj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","'Yö‑ pö 'zü: «'Kɛɛ mɛ gbɛ 'yaa‑ yi ‑nu, ‑a 'lɛlɛ ‑nu gbɛ dɔ; ‑Zlan ‑bha bɔmɛ ‑nu ‑de 'wo dhang‑ 'gü, ma ‑de 'a‑ Gbö 'ka bhë, 'yiëë‑ yi dɔ; n Dë dosɛn ꞊nɛ 'ö‑ yi dɔ. ");
INSERT INTO dnj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Pë do 'yö ‑kë Noe ‑bha 'töng 'ka bhë, pë do bhë 'ö dho kë 'zü, 'töng 'ö ma Mɛgbö 'a dho nuë bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","‑A 'töng 'ö bhë ‑a 'ka kö 'yi ꞊va yaa pa ꞊kun, mɛ ‑nu ‑wo ‑kë pë ‑nu ‑bhö ‑sü 'gü, müpë ‑nu mü ‑sü 'gü; gɔɔn‑ ‑nu ‑wo ‑kë dhe ‑nu 'sü ‑sü 'gü, 'ö mɛ ‑nu ‑wo wo ‑bha 'në dhoo ‑nu dɔ gwaan 'ö dho 'ö yöë yi 'ö Noe ‑yö ꞊daa' 'yitagɔ 'gü ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","‑An ‑zo yaa kë 'wun 'gbee‑ 'yö dhö nu ‑an ‑ta bhë ‑a 'piö, 'ö dho 'ö yöë yi 'ö 'yi ꞊va ‑yö nuë, 'ö sɔ ‑an 'plɛ ‑zü ‑a ‑bha. ‑Kɔ do bhë 'yö dho kaa ma Mɛgbö n nu ‑yi 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A‑ ‑pö ka ‑dhë 'zü: ‑A yi bhë ‑a 'ka, mɛ ꞊plɛ ‑wo ‑dho kë ꞊bhlöö‑, ‑a mɛ do ‑dho sü, 'ö‑ mɛ do ‑yö to. ");
INSERT INTO dnj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dhoo ‑nu ꞊plɛ ‑wo ‑dho kë pë zɔn ‑dhiadhö, ‑a mɛ do ‑dho sü, 'ö‑ mɛ do ‑yö to. ");
INSERT INTO dnj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‑Ka ‑ya ka 'yaan, bhii 'kaa yi 'ö ka Dëmɛ dho nuë ‑a dɔ. ");
INSERT INTO dnj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Wun mɛ 'ö ꞊nɛ ‑ka ‑a ‑gɛn ma ‑së 'ka! 'Ö ꞊ya kë ꞊nɛ 'kɔdëmɛ ‑yö 'töng 'ö ꞊kwaanmɛ dho nuë gbeng ‑a ‑dɔ ‑bezë, kö ‑yö ‑dho ‑ya ö 'yaan kö ꞊kun 'ö dho ‑da ö ‑gɔ kɔɔ ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","‑Ka ka ‑zo kë ka ‑de 'piö! Bhii ma Mɛgbö, a ‑dho nu 'lɛlɛ 'ö ka ‑zo 'yaa‑ ‑dhë bhë ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","'Ö Yesu ‑ya pö 'zü: «Dö 'pö 'ö tɔɔ yuökëmɛ ‑towogüsüzë 'ö 'wun dɔ ꞊ɛ? 'Ö tɔɔ mɛ 'ö‑ dëmɛ ‑yö ö bha yuökëmɛ ‑nu ‑lo ‑a kwɛɛ ‑yaan ö ‑zo kë ‑an 'piö, kö ‑yaan ‑an 'dhi gba ‑an 'dhi ‑gba 'töng 'ka bhë. ");
INSERT INTO dnj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","꞊Ɛɛ, yuökëmɛ 'ö‑ dëmɛ ‑yɛ 'zü ‑sü 'ka, ‑yaan nu ö plöö, 'ö dho ‑a yö kö ‑a ‑zo ‑yö yuö ‑nu 'wo 'dhö bhë ‑an 'piö bhë, ꞊zuögludhi ‑yö kë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ‑A dëmɛ ‑yö ‑dho ö ‑bha pë ‑sɛɛbɔ ‑nu 'ö‑ ‑gɔ bhë ‑a 'plɛ ‑lo ‑a kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","'Kɛɛ ꞊ya kë ꞊nɛ yuökëmɛ këwunyaazë ‑mü ‑a 'ka, ‑yö ‑dho ‑a pö ö ‑de 'gü ꞊nɛɛ: ‹N dëmɛ 'yaa nu ‑na 'siö‑›, ");
INSERT INTO dnj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'ö dho ‑ya ö 'bhamɛ ‑nu 'ö ‑an ‑bha yuö 'dhö do ‑an ma ‑sü ‑bha; 'go mü 'ö waa‑ yɔ 'yi mü ‑mɛ ‑nu 'wo pë ‑nu ‑bhö, 'wo yɔ ‑nu mü wo 'ko ꞊bhaa, ");
INSERT INTO dnj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","‑a dëmɛ ‑dho nu yi 'ö 'yaa‑ dɔ, 'iin 'lɛlɛ 'ö 'yaa‑ dɔ ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","‑Yö ‑dho yuökëmɛ 'ö 'dhö bhë ‑a 'klo bhɔ ꞊gbaɔnsü 'ka, 'ö‑ bɔ mɛ 'yan ‑ta ‑pë kë ‑mɛ ‑nu 'piö. ‑Dhɛ bhë ‑a 'gü 'ö ‑an 'plɛ dhö 'gbo ‑nu bɔ ‑waan wo 'sɔn ‑nu ‑bhö ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","'Ö Yesu ‑ya pö: «‑Zlan ‑bha ‑gludëdhɛ 'yö dhang‑ 'gü bhë ‑yö bhɔ 'në dhoo ‑nu ‑dadhëü 'gɔɔ‑ do 'wo wo ‑bha ꞊labang sü 'wo dho dhe 'sü ‑gɔɔn ‑gɔ zian‑ ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","‑An mɛ 'sɔɔdhu 'waa 'kpaakpa, 'kɛɛ ‑an mɛ 'sɔɔdhu ‑wo 'kpaakpa. ");
INSERT INTO dnj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","'Ö ‑an mɛ 'sɔɔdhu 'waa 'kpaakpa bhë 'wo wo bha ꞊labang sü, 'kɛɛ waa 'siö 'yi 'wo dho ‑a kun wo ‑kɔ 'piö ‑a 'sü. ");
INSERT INTO dnj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Ö ‑an mɛ 'wo 'kpaakpa bhë 'wo wo ‑bha 'siö 'yi sü ‑sandhe 'gü, 'wo‑ kpa woë‑ ꞊labang ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","'Në dhoo ‑nu 'gɔɔ‑ do 'wo bhë, yi ‑yö ‑an ‑kun 'ö 'wo yi zë kö dhe 'sü ‑gɔɔn yaa nu ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","꞊Dhɛ ꞊wa dɔ gbeng ziën, 'ö ‑wo do ‑yö ‑we 'wo‑ ma: ‹Dhe ‑gɔn ꞊ya nu! ‑Ka yö plaan 'ka 'dho ‑a ‑gɔ zian‑!› ");
INSERT INTO dnj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","'Ö 'në dhoo ‑nu 'gɔɔ‑ do 'wo bhë 'wo ‑büö 'wo yö plaan, 'wo yö wo ‑bha ꞊labang ‑nu 'yan ꞊luu' ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","'Ö ‑an mɛ ‑nu 'waa 'kpaakpa bhë 'wo‑ pö ‑an mɛ 'wo 'kpaakpa bhë ‑an ‑dhë: ‹‑Ka 'siö 'yi pë 'tee nu yi ‑dhë ‑ɛ, yi ‑bha ꞊labang ‑nu ‑wo ꞊dhuu' ‑na!› ");
INSERT INTO dnj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Ö ‑an mɛ 'kpaakpazë ‑nu 'wo bhë 'wo‑ pö: ‹‑Abi', bhii yaa 'dho ‑mɔ kwa ‑bha. ‑Ka 'dho 'siö 'yi 'dhɔɔdɔmɛ 'piö 'ka ka ‑bha 'dhɔ!› ");
INSERT INTO dnj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","'Ö ‑an mɛ ‑nu 'waa 'kpaakpa bhë 'wo dho wo ‑bha 'siö 'yi 'dhɔ ꞊dhia, 'kɛɛ 'töng gia‑ bhë ‑a 'ka, 'ö dhe ‑gɔn ‑yö nu. 'Në dhoo ‑nu 'sɔɔdhu mɛ 'ö 'wo wo ‑de ‑pë ‑kë bhë, 'ö waa‑ dhe ‑gɔn ‑nu 'wo ‑da dhe 'sü ‑kɔ 'gü, 'ö mɛ ‑nu ‑wo 'kwɛɛ ta ꞊lakele 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","꞊Dhɛ 'ö‑ ‑dhɛ 'bhle 'tee ꞊ya ꞊glɔɔ, 'ö 'në dhoo ‑nu 'sɔɔdhu 'wo to bhë 'wo nu, 'wo yö 'gbla ‑sü 'gü ꞊nɛɛ: ‹Yi ‑gɔmɛ, yi ‑gɔmɛ, ‑bhö 'kwɛɛ 'po yi ‑gɔ ‑ɛ!› ");
INSERT INTO dnj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'Kɛɛ dhe ‑gɔn ‑ya ‑pö ‑an ‑dhë: ‹A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka 'maa kaa dɔ!› » ");
INSERT INTO dnj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","'Ö Yesu ‑yö ö ‑wo ‑zuöatadhe kë ꞊nɛɛ: «‑Ka ‑ya ka 'yaan, bhii 'kaa‑ yi ‑nu 'iin 'lɛlɛ ‑nu ‑an gbɛ dɔ!» ");
INSERT INTO dnj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","'Ö Yesu ‑ya pö: «‑Zlan ‑bha ‑gludëdhɛ 'ö dhang‑ 'gü bhë ‑yö ‑dho bhɔ gɔɔn‑ do 'yö dho 'ta 'gü ‑a ‑bha. 'Yö ö bha yuökëmɛ ‑nu ꞊dhɔɔ ‑kë, 'yö ö bha pë ‑nu ‑lo ‑an kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'Yö 'sënng 'tama ꞊këng' 'sɔɔdhu nu ‑a mɛ do ‑dhë, 'ö‑ mɛ kë ꞊plɛ bhë 'yö‑ ꞊këng' ꞊plɛ nu ‑a ‑dhë; ‑a mɛ kë ‑yaaga bhë 'yö‑ ꞊këng' do nu ‑a ‑dhë. ‑Ya ‑nu ‑an ‑dhë mɛ 'ö ‑dhö ‑a ‑bha 'dhɔɔ ‑siögüdhe kë ‑kɔ ꞊faan' ‑bha. ꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ to 'ö dho. ");
INSERT INTO dnj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yuökëmɛ 'ö 'sënng 'tama ꞊këng' 'sɔɔdhu yö bhë 'yö dho 'ö‑ ‑siögüdhe ‑kë, 'ö 'sënng 'tama ꞊këng' 'sɔɔdhu 'bhaa yö. ");
INSERT INTO dnj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mɛ 'ö‑ ‑bha ‑yö ‑kë 'pö ꞊këng' ꞊plɛ bhë, 'yö‑ ‑kë ꞊nɛ ‑kɔ do bhë ‑a 'dhö; 'yö‑ ꞊këng' ꞊plɛ 'bhaa yö 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","'Kɛɛ mɛ 'ö‑ ‑bha ‑yö ‑kë ꞊këng' do bhë ‑yö ‑dho, 'yö 'sɛ pɔn, 'yö ö ‑gɔmɛ ‑bha 'wëü‑ bhë 'yö‑ ‑bin. ");
INSERT INTO dnj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","꞊Dhɛ 'ö‑ ‑dhɛ ꞊ya ꞊glɔɔ, yuökëmɛ ‑nu 'wo bhë 'ö ‑an ‑gɔmɛ ‑yö nu, 'wo yö yuö ‑nu 'wo‑ ‑kë bhë ‑a 'kluën bho ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yuökëmɛ 'ö 'sënng 'tama ꞊këng' 'sɔɔdhu ‑yö nu ‑a ‑dhë bhë, ‑yö ‑nu 'sënng 'tama ꞊këng' 'sɔɔdhu gbɛ 'ka, 'ö‑ pö ö ‑gɔmɛ ‑dhë: ‹N ‑gɔmɛ, 'sënng 'tama ꞊këng' 'sɔɔdhu ꞊nɛ 'ü‑ nu n ‑dhë, 'kɛɛ ‑a ꞊këng' 'sɔɔdhu 'bhaa 'a‑ yö ‑a 'piö 'ö ꞊nɛ.› ");
INSERT INTO dnj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Ö‑ ‑gɔmɛ ‑ya pö ‑a ‑dhë: ‹꞊Yö ‑së, ma yuökëmɛ këwunsëëzë, ‑zo ‑tën ‑a ‑dhë ‑mɛ ‑mü ü 'ka; ü ü ‑zo ‑kë pë ‑nu 'ö ‑an 'tɔ 'gian 'yaa ‑an ‑bha ‑an 'piö; a ‑dho ‑an mɛ 'ö ‑an 'tɔ 'dho ‑an ‑bha ‑a nu ü ‑dhë. ‑Bhö nu 'ü ꞊zuögludhi kë n 'piö!› ");
INSERT INTO dnj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","'Ö yuökëmɛ mɛ 'ö 'tama ꞊këng' ꞊plɛ ‑yö nu ‑a ‑dhë bhë, 'ö ꞊yɔɔn ö ‑gɔmɛ ‑bha 'ö‑ pö: ‹N ‑gɔmɛ, 'sënng 'tama ꞊këng' ꞊plɛ 'ü‑ nu n ‑dhë bhë, ‑dhɛ ‑ga, ‑a ꞊këng' ꞊plɛ 'bhaa 'a‑ yö ‑a 'piö ꞊ga ꞊nɛ!› ");
INSERT INTO dnj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Ö‑ ‑gɔmɛ ‑ya pö ‑a ‑dhë: ‹꞊Yö ‑së, yuökëmɛ këwunsëëzë, ‑zo ‑tën ‑a ‑dhë ‑mɛ ‑mü ü 'ka; 'ö tɔɔ pë ‑nu 'ö‑ 'tɔ 'gian 'yaa 'dhö ‑a 'gü, ü ü ‑zo ‑kë ‑an 'piö. ꞊Dhɛ 'ö 'dhö, pë ‑nu 'ö ‑an 'tɔ 'dho 'gian ‑a nu ü ‑dhë. ‑Bhö nu, 'ü ꞊zuögludhi kë n 'piö!› ");
INSERT INTO dnj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'Ö yö 'sabla yuökëmɛ mɛ 'ö 'tama ꞊këng' do ‑yö nu ‑a ‑dhë bhë ‑a ‑bha, 'ö ꞊yɔɔn ö ‑gɔmɛ ‑bha 'ö‑ pö: ‹N ‑gɔmɛ, a‑ ꞊dɔa' ꞊nɛ ü mɛ 'ö 'gbee‑ ‑a 'ka, pë 'ö ü 'ka‑ ta, ü‑ ‑bho, 'ö pëga 'ö ü 'ka‑ ta, 'ü‑ ‑kan. ");
INSERT INTO dnj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","'Ö 'suö ‑yö n ‑kë. ‑A ‑wun 'gü 'a dho 'a ü bha 'wëüga bhë 'a‑ ‑bin 'sɛidhö. ‑Dhɛ ‑ga zö, ü bha pë bhë ꞊ga ꞊nɛ.› ");
INSERT INTO dnj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Ö‑ ‑gɔmɛ ‑ya pö ‑a ‑dhë: ‹Yuökëmɛ yaa, ü 'fiasü, ü‑ ꞊dɔa' ꞊nɛ pë 'ö n 'ka‑ ta, a‑ ‑bho, 'ö pëga n 'ka‑ ta, 'a‑ ‑kan. ");
INSERT INTO dnj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","꞊Dhɛ 'ö 'dhö, ü ꞊dua' ‑mü ‑be kö ma 'wëü‑ bhë 'ü‑ ‑da 'wëü‑ ‑da ‑a 'gü ‑kɔ 'gü, kö n ‑yɛ 'zü ‑sü 'ka, ma gia‑ 'aan‑ ‑a bho mü kö ‑a ꞊truën ‑yaan kë ‑a ‑ta!› ");
INSERT INTO dnj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'Ö‑ pö ö bha yuökëmɛ ‑nu ‑dhë: ‹'Sënng 'tama ꞊këng' do bhë ‑kaa 'kun ‑a ‑gɔ 'ka‑ nu mɛ 'ö 'sënng 'tama ꞊këng' 'sɔɔdhu 'dho ‑a ‑gɔ bhë ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bhii mɛ 'oo mɛ 'ö pë 'dhoë‑ ‑gɔ, ‑wo ‑dho ‑a ꞊taɔ' nu ‑a ‑dhë, 'ö pë ‑yö ‑kë ‑a ‑gɔ ꞊va, 'kɛɛ mɛ 'ö pë 'yaa‑ ‑gɔ, ‑a pë 'bhle 'tee 'yö‑ ‑gɔ, ‑wo ‑dho ‑a kun ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","꞊Ya 'to yuökëmɛ 'ö‑ ꞊truën gbɛ 'yaa ‑dhö ꞊nɛ ‑a ‑bha 'ka, ‑kaa ꞊zong' plaan ‑dhɛtiidhɛ 'gü! ‑Dhɛ bhë ‑a 'gü, 'yö dho ö 'sɔn ‑nu ‑bhö ‑a ‑bha, ‑yaan 'gbo ‑nu bɔ ‑a ‑bha.› » ");
INSERT INTO dnj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","'Go mü 'zü 'ö Yesu ‑ya pö: «Yi 'ö ma 'a Mɛgbö 'ka 'a dho nuë ‑gludë 'ka, yië‑ ‑Zlan ‑bha bɔmɛ ‑nu 'saadhö yi ‑dho nu. ‑A yi bhë ‑a 'ka a ‑dho ‑ya ma ‑gludëdhɛ kë 'gɔ ‑gbloo 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","'Sɛgɔ 'saadhö 'gü ‑mɛ ‑nu ‑wo ‑dho dho wo 'kuë‑ n wö 'dhiö, 'a mɛ ‑nu zë 'gü do do 'ka ꞊nɛ ‑kɔ 'ö ‑tuëmaakëmɛ 'dho 'bhla ‑nu bho ‑na 'ka ‑bho ‑nu ziën bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A ‑dho 'bhla ‑nu bɔ n ꞊kwɛɛ‑ 'gü ꞊zian', 'a ‑bho ‑nu bɔ n kwaa‑ 'gü ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","꞊Ya kë 'dhö, ma ‑gludëmɛ, a ‑dhoë pö mɛ ‑nu 'ö 'wo n ꞊kwɛɛ‑ 'gü ꞊zian' bhë ‑an ‑dhë: ‹‑Ka nu, mɛ ‑nu 'ö n Dë ꞊ya 'dhuë‑ 'kpɔ ka ‑bha, 'ö ‑Zlan ‑bha ‑gludëdhɛ 'ö‑ ‑ya 'kpongtaadhɛ kë ‑yi züdɔyi 'ka bhë, ‑yö ‑ya ka ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bhii din ‑yö ‑kë n kë ꞊dhia, 'ö 'ka n gbaa ‑bhöpë 'ka. 'Yi mü ‑dhɔ ‑yö ‑kë n kë ꞊dhia, 'ö 'ka n gbaa 'yi 'ka. A ‑kë ‑nia 'ka, 'ö 'ka n ‑nia 'kun ‑së. ");
INSERT INTO dnj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","A ‑kë n 'kpaan 'ka, 'ö 'ka sɔ ‑da n ‑ma. 'Yua ‑yö ‑kë n kë ꞊dhia, 'ö 'ka ka ‑zo ‑kë n 'piö. A ‑kë ‑kanso 'gü, 'ö 'ka bhɔ n ꞊dhia.› ");
INSERT INTO dnj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mɛ kpengdhö ‑nu 'wo bhë ‑wo ‑dho ‑a pö n ‑dhë: ‹Yi Dëmɛ, yi ü ‑yö 'më kö din ‑yö ü kë ‑na, 'yi ü gbaa ‑bhöpë 'ka ɛ? 'Yi ü yö 'më kö 'yi mü ‑dhɔ ‑yö ü kë ‑na, 'yi ü gbaa 'yi 'ka ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yi ü ‑yö 'më kö ü ‑nia 'ka, 'yi ü ‑nia kun ‑së ‑ɛ? Ü ‑kë ü 'kpaan 'ka 'më, 'yi sɔ ‑da ü ‑bha ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Yi ü ‑yö 'yua 'gü 'më, 'ö 'yi ü yö ‑kanso 'gü 'më, 'yi ‑bhɔdhia ‑kë ü ‑gɔ ‑ɛ?› ");
INSERT INTO dnj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","꞊Ya kë 'dhö, ma ‑gludëmɛ, a ‑dho ‑a pö ‑an ‑dhë: ‹A‑ ‑pö ka ‑dhë giagia 'ka: Pë ‑së 'saadhö 'ö 'ka‑ ‑kë mɛ ‑nu 'ö 'waa ‑an ꞊bhlë ‑ya 'ö 'wo n dheglu 'ka ‑a mɛ do ‑dhë bhë, kö ma ꞊nɛ 'ö 'ka‑ ‑kë n ‑dhë.› ");
INSERT INTO dnj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","'Go mü 'zü, ma ‑gludëmɛ, a ‑dho ‑a pö mɛ ‑nu 'wo n ꞊kwaa‑ 'gü ꞊zian' bhë ‑an ‑dhë: ‹‑Ka bhɔ n ‑dhë ꞊taa', mɛ 'ö ‑Zlan ꞊ya 'dhangga ‑ya ka ‑bha! ‑Ka 'dho ꞊toëpö 'siö 'ö ꞊glöötiaandhö ‑dhɛ 'ka 'ö ‑ya ‑sü 'ka dü waa‑ ö bha bɔmɛ ‑nu ‑an ‑dhë bhë ‑a 'gü! ");
INSERT INTO dnj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bhii din ‑yö ‑kë n kë ꞊dhia, kaa n gbaa ‑bhöpë 'ka, 'yi mü ‑dhɔ ‑yö n ‑kë, kaa n gbaa 'yi 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","A ‑kë ‑nia 'ka, kaa n ‑nia 'kun, a ‑kë n 'kpaan 'ka, kaa sɔ ‑da n ‑ma. A ‑kë 'yua 'gü, a ‑kë ‑kanso 'gü, kaa bhɔ n ꞊dhia.› ");
INSERT INTO dnj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‑Wo ‑dhoë pö: ‹Yi Dëmɛ, yi ü ‑yö 'më kö din ‑yö ü kë ‑na, kö 'yi mü ‑dhɔ ‑yö ü kë ‑na, kö ü ‑nia 'ka, kö ü 'kpaan 'ka, kö ü 'yua 'gü, kö ü ‑kanso 'gü, 'ö yiëë nu ü ‑dhë ‑ɛ?› ");
INSERT INTO dnj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","꞊Ya kë 'dhö, ma ‑gludëmɛ, a ‑dho ‑a ‑daa kë ‑an ‑gɔ ꞊nɛɛ: ‹A‑ ‑pö ka ‑dhë giagia 'ka: Pë ‑nu 'ö kaa‑ kë mɛ ‑nu 'waa ‑an ꞊bhlë ‑ya ꞊nɛ ‑a mɛ do ‑dhë bhë, ma ꞊nɛ 'ö kaa‑ kë n ‑dhë.› ");
INSERT INTO dnj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mɛ ‑nu 'wo 'dhö bhë ‑wo ‑dho dho ꞊toëpö 'klobhɔdhɛ ‑bha. 'Ö mɛ kpengdhö ‑nu ‑wo dho 'pö ꞊toëpö ‑këdhösü ‑dhɛ ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","꞊Dhɛ Yesu ꞊ya yën 'wun ‑nu bhë ‑an ꞊blɛɛ' ‑sü ‑bha, 'ö‑ pö ö bha ꞊guë' ‑nu ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Ka‑ ꞊dɔa' ꞊nɛ, Paakö 'wlaan‑ ‑dho kë ‑dhɛkpaɔyi ꞊plɛ ‑bha, ma Mɛgbö, n dɔ ‑sü ‑mü mɛ ‑nu kwɛɛ kö ‑waan n dɔ ‑gaatalü ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","꞊Dhɛ ꞊ya kë 'dhö, slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'sɛgümɛ ‑nu mɛ ziizii ‑nu 'wo Zuifö 'ka, ‑wo ‑nu wo 'ko ꞊bhaa slabhomɛ ꞊va 'wo‑ ‑dhɛ Kaifö bhë ‑a ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","'Ö ‑an ‑wo ‑yö kpɔ 'kuë‑, kö ‑waan Yesu 'kun ‑bin ‑blü 'waan‑ zë; ");
INSERT INTO dnj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","'wo‑ pö: «Kwa 'ka 'dho ‑a kun 'wlaan‑ kë ‑yi 'ka. ꞊Ya kë 'dhö, 'sɛgümɛ ‑nu ‑dho ꞊luu' 'wo nu kwa ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu ‑yö ‑kë Betani, Simɔ 'ö ꞊wee ꞊yua' ‑ya ‑kë ‑be bhë ‑a ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","'Ö dhebɔ do ‑yö ꞊yɔɔn ‑guö ‑kpo 'lü 'ö pë 'yi 'tëë ‑sëëzë ꞊sɔnng' 'gbeezë ‑ya pa bhë ‑a 'ka ‑a ‑bha. ꞊Dhɛ Yesu 'dhö pë ‑bhö ‑na, 'yö‑ 'daawo ‑a ‑gɔa. ");
INSERT INTO dnj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","꞊Dhɛ 'ö‑ ‑bha ꞊guë' ‑nu ꞊waa‑ yö, yaa dhi ‑an ‑dhë, 'wo‑ pö: «Pë 'gü ꞊siö' ‑sü 'kpaan kun ꞊nɛ ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pë 'yi 'tëë ‑sëëzë ꞊nɛ ‑wa 'dhɔɔ dɔ ꞊sɔnng' 'gbee‑ 'ka ‑bezë, 'ö‑ 'wëü‑ ‑nu bhë 'wo‑ nu 'fɛɛmɛ ‑nu ‑dhë kö 'yaa ‑së ‑a!» ");
INSERT INTO dnj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bhii ꞊dhɛ ‑kë ꞊nɛ Yesu ‑yö 'wun 'wo ‑kë ‑a ꞊blɛɛ' ꞊dhia bhë ‑a ‑ma bhë, 'yö‑ pö ‑an ‑dhë: «‑Më ‑kë 'ö dhebɔ ꞊nɛ 'ka‑ ꞊kɔɔ' ꞊yɛɛ ꞊ɛ? Pë 'ö‑ ‑kë n ‑dhë bhë ꞊yö ‑së. ");
INSERT INTO dnj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bhii 'fɛɛmɛ ‑nu ‑wo ‑dho kë ka 'piö zö ‑kplawo, 'kɛɛ ma ‑zë n 'ka 'dho to ka 'piö zö. ");
INSERT INTO dnj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dhebɔ ꞊nɛ ‑yö pë 'yi 'tëë ‑sëëzë ꞊nɛ ‑a ‑lo n ‑ma n ꞊glöö ꞊baa' ‑pë 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A‑ ‑pö ka ‑dhë giagia 'ka: ‑Dhɛ 'saadhö 'wo 'dhoë‑ 'wuntaɔsë ꞊blɛɛ' ‑a ‑bha 'kpongtaadhɛ 'ö ꞊nɛ ‑a 'gü, pë 'ö dhebɔ ꞊nɛ 'ö‑ ‑kë bhë ‑wo ‑dho ‑a ꞊blɛɛ'‑, 'ö ‑an ‑zo ‑yö ‑büö ‑a ‑wun 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","꞊Dhɛ ꞊ya kë 'dhö, 'ö ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑a mɛ do 'wo‑ ‑dhɛ Zuda Ikaliɔtö bhë, 'yö dho 'ö yö slabhomɛ ‑gɔmɛ ‑nu ‑bha, ");
INSERT INTO dnj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'ö‑ pö ‑an ‑dhë: «'Ma Yesu dɔ ka kwɛɛ ꞊sia, ‑më 'ka dhoë‑ nu n ‑dhë ‑ɛ?» 'Ö 'wo 'wëü‑ 'puu 'tama 'gɔɔ‑ ‑yaaga ꞊dhong, 'wo‑ nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","'Ö sü yi bhë ‑a ‑bha, Zuda ‑yö ‑kë ‑a ꞊mɛɛ' ꞊dhia kö 'yaan‑ Yesu dɔ ‑an kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","'Dhɔɔgɔ 'ö 'wo 'bluu‑ 'ö‑ ꞊bhɛɛpë 'yaa‑ 'piö, 'wo‑ ‑bhö ‑na ‑a 'ka bhë, ‑a ‑dhɛkpaɔyi ‑blɛɛzë 'ka, 'yö ꞊guë' ‑nu 'wo Yesu ꞊dhɛɛ' ‑kpɔ, 'wo‑ pö ‑a ‑dhë: «‑Dhɛ ‑mlë 'ü‑ 'piö kö 'yi ü bha Paakö 'wlaan‑ ‑bhöpë kë ‑a ‑bha ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","'Ö Yesu ‑ya pö ‑an ‑dhë ‑wo 'dho plöö; ꞊ya kë ꞊nɛ ꞊wa ‑da plöö ‑wo yö gɔɔndë do ‑bha; ‑wa ꞊dhɛɛ' kpɔ ꞊woë' ꞊nɛɛ: «Yi ‑gɔmɛ ‑ya ‑pö ö ‑bha 'lɛlɛ ꞊ya yö ꞊klöö'; 'kɛɛ ‑dhɛ 'ö ü ‑gɔ kɔɔ ꞊nɛ 'ö waa‑ ö ‑bha ꞊guë' ‑nu 'wo dho Paakö 'wlaan‑ ‑pë ‑bhö ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'Ö ꞊guë' ‑nu ‑wa ‑kë ꞊nɛ ‑kɔ 'ö Yesu ‑ya pöë ‑an ‑dhë bhë ‑a 'dhö. 'Wo dho 'wo Paakö ‑bhöpë ‑yuö ‑kë 'kɔ bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","꞊Dhɛ 'yiniadhɛ ꞊ya dɔ, Yesu waa‑ ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑wo ‑dho pë ‑bhö ‑a ‑ta ꞊gba 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","‑Wo ‑kë pë ‑bhö ꞊dhia, 'ö Yesu ‑ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë giagia 'ka: Mɛ do ‑yö ka ziën, yö ꞊nɛ 'ö dho n dɔ n yaagümɛ ‑nu kwɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","‑A ‑bha ꞊guë' ‑nu wöödhɛ ‑yö ‑siö ꞊gbaɔnsü, 'wo yö ‑a ꞊dhɛɛ' 'kpɔ ‑sü ‑bha do do 'ka ꞊nɛɛ: «N Dëmɛ, ma ‑mü ‑a?» ");
INSERT INTO dnj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","'Ö Yesu ‑ya pö: «Mɛ 'yö ö bha ꞊bluu'‑ ‑sɔ n 'piö pë ‑bhö ‑a 'gü 'tia‑ 'gü ꞊nɛ yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ma Mɛgbö, a ‑dho ga ꞊nɛ ‑kɔ 'ö pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü n ‑wun 'gü 'ö‑ 'ka‑ 'dhö. 'Kɛɛ ‑më 'yena ‑wun 'yö ꞊nɛ gɔɔn‑ 'ö 'dhoë‑ ma Mɛgbö n dɔ n yaagümɛ ‑nu kwɛɛ bhë ‑a ‑bha 'ka! Gɔɔn‑ 'ö 'dhö yaa bhɔ ‑bezë, kö ꞊yö ‑së ‑a ‑bha 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zuda 'ö dho ‑a dɔ ö yaagümɛ ‑nu kwɛɛ bhë, 'ö‑ pö: «N ‑Gɔmɛ, ma ‑mü ‑a?» 'Ö Yesu ‑ya pö: «Ü‑ ‑kpɔ ü ‑de 'yaan.» ");
INSERT INTO dnj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","‑Wo ‑kë pë ‑bhö ꞊dhia, 'ö Yesu ‑yö ꞊bluu'‑ ‑sü; ꞊dhɛ 'ö ꞊ya ‑Zlan zuö pö ‑a ‑ta, 'yö‑ ꞊kaan, 'ö‑ nu ö bha ꞊guë' ‑nu ‑dhë ‑a pö ‑sü 'ka ꞊nɛɛ: «‑Kaa 'sü, 'ka‑ ‑bhö, ‑a mɛ ꞊nɛ tɔɔ n bun.» ");
INSERT INTO dnj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","'Ö ‑drɔɔn ‑kɔɔ do sü; ꞊dhɛ ꞊ya ‑Zlan zuö pö ‑a ‑ta, 'yö‑ nu ‑an ‑dhë ‑a pö ‑sü 'ka ꞊nɛɛ: «Ka 'plɛ ‑kaa mü! ");
INSERT INTO dnj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bhii ‑a mɛ ꞊nɛ tɔɔ n fɛi. Fɛi bhë ꞊nɛ 'ö ‑Zlan ‑bha ‑dhi 'kuë‑ gën 'ka. Yö ꞊nɛ 'ö ‑lo ‑ziö mɛdhɛvadhɛ ‑bha ꞊sɔɔn yaa ‑ta ‑pë 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A‑ ‑pö ka ‑dhë: N 'ka ‑dho ‑drɔɔn mü ka 'piö gbɔ, 'ö dho 'ö yöë ‑drɔɔn ‑dëü gbɛ 'a dho ‑a mü ka 'piö n Dë ‑bha ‑gludëdhɛ ‑pö 'gü bhë ‑a yi ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","꞊Dhɛ ꞊ya kë 'dhö, 'wo 'wlaan‑ ‑ta 'tan ‑nu bho, 'wo dho Olivie ‑tɔn tuö. ");
INSERT INTO dnj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «Gbeng ‑yi gia‑ ꞊nɛ ‑a 'gü, ka 'plɛ ka ‑dho n to 'ka ‑ziö, bhii pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ‑ya ‑pö: A ‑dho 'bhla ‑maakëmɛ zë, 'ö 'bhla ‑tuë ‑nu ‑wo ‑pɛn ‑dhɛ 'saadhö ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","'Kɛɛ 'ma 'go ga 'gü, a ‑dho dho ka 'dhiö Galile ‑sɛ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","'Ö Piɛɛ ‑ya pö: «'Kö ‑kë ꞊nɛ mɛ 'plɛ ‑wo ü ‑to, ma ‑zë, n 'ka 'dho ü to 'gbɛɛdhö.» ");
INSERT INTO dnj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","'Ö Yesu ‑ya pö ‑a ‑dhë: «A‑ ‑pö ü ‑dhë giagia 'ka: Gbeng ‑yi gia‑ 'ö ꞊nɛ ‑a 'gü, ‑a kë ‑sü 'ka kö ‑tɔ gɔn ‑yaan 'we, ü ‑dho ‑a pö ‑gwaa ‑yaaga ‑zë ꞊nɛ 'bhaa n dɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","'Ö Piɛɛ ‑ya pö: «'Kö ‑kë ꞊nɛ ko zë ‑wun ‑mü 'dhee, n 'ka 'dho ‑a pö 'gbɛɛdhö 'maa ü dɔ!» 'Ö pë do bhë mɛ 'wo to 'wo‑ pö 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","꞊Dhɛ ꞊ya kë 'dhö, Yesu waa‑ ö bha ꞊guë' ‑nu 'wo ‑lo ‑dhɛ do 'wo‑ ‑dhɛ Zesemane bhë ‑a ‑bha, 'ö‑ pö ‑an ‑dhë: «‑Ka ꞊yaannu zö, kö 'a 'dho ‑de ꞊bhɛa' ꞊dhia!» ");
INSERT INTO dnj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Piɛɛ 'dhö, Zebede gbö ‑nu ꞊plɛ 'dhö, 'yö ‑an sü ö 'piö. 'Yö ‑wɛɛ ‑yö ‑kpɔ ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","'Ö‑ pö ‑an ‑dhë: «N ꞊zuö' ꞊ya pa ga ‑sü 'yena bhë ‑a 'ka. ‑Ka 'to zö, 'kwa ‑ya kwa 'yaan!» ");
INSERT INTO dnj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","꞊Dhɛ 'ö bhɔ ‑an ‑dhë ꞊taa' 'bhe 'ka, 'ö ö ‑gɔ ‑gblü 'sɛi 'ö ꞊bhɛa ö ‑wo ‑ta ꞊nɛɛ: «N Dë, ‑a këdhɛ ꞊ya kë ‑dhö, 'yi 'güüzë 'ö ꞊nɛ, ‑a bhɔ n ‑dhë ꞊taa'! Kë‑ wo 'dhö 'püë‑ wo bhë n 'ka‑ pö, ma 'pö n 'yi ꞊kaan ‑dhë ‑wun, 'kɛɛ bhi ‑zë, ü 'yi ꞊kaan ‑dhë ‑wun ‑yö kë.» ");
INSERT INTO dnj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'Ö ‑yɛ ö 'zü 'ö nu ö bha ꞊guë' ‑nu ‑yaaga bhë ‑an 'piö, 'ö ‑an yö kö ‑wo yiö, 'ö‑ pö Piɛɛ ‑dhë: «'E! Kaa ‑ya ka 'yaan n 'piö 'lɛlɛ do gia‑ 'ka a? ");
INSERT INTO dnj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","‑Ka ‑ya ka 'yaan, 'ka ꞊bhɛa'‑, kö ꞊kun 'ö 'ka dho ‑püö 'güdandhe 'gü, a‑ ꞊tɛi' ‑dɔ ꞊nɛ ka‑ 'piö 'ka ‑ya ka 'yaan, kë‑ wo 'ö ꞊faan' 'yaa bun ‑gɔ bhë yö ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","'Ö bhɔ ‑an ‑dhë ꞊taa' ‑gwaa kë ꞊plɛ ‑naa wo, 'ö ꞊bhɛa ‑wo 'ö ꞊nɛ ‑a 'ka: «N Dë, 'ö ꞊ya kë ꞊nɛ 'yi 'güüzë ‑kɔɔ 'ö ꞊nɛ yaa 'dho bhɔ n ‑dhë ꞊taa', kö ü 'yi ꞊kaan ‑dhë ‑wun ‑yö kë!» ");
INSERT INTO dnj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","'Ö nu ö bha ꞊guë' ‑nu 'piö, 'yö ‑an yö kö ꞊wa yi zë 'zü, bhii 'ö tɔɔ yi ‑yö ‑kë ‑an 'yënngdhö. ");
INSERT INTO dnj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","'Ö Yesu ‑yö go ‑an 'piö 'zü, 'yö dho ꞊bhɛa' ꞊dhia ‑gwaa ‑yaaga ‑naa wo, ‑wo do bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Ö nu ö bha ꞊guë' ‑nu 'piö, 'ö‑ pö ‑an ‑dhë: «Ka yi zë ‑na ‑kplawo ꞊a? Ka ka 'tɛɛ ‑nu pa ‑na ‑a? ‑Ka ‑dhɛ ‑ga: 'Lɛlɛ ꞊ya ‑lo kö ma Mɛgbö 'aan‑ dɔ ꞊sɔɔnyaamɛ ‑nu kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","‑Ka ꞊luu'‑ 'kwa 'dho! Gɔɔn‑ 'yö dho n 'dhɔɔ dɔ bhë, ꞊ya ‑lo zö 'saadhö!» ");
INSERT INTO dnj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu ‑yö ‑to 'wun ꞊blɛɛ' ꞊dhia, 'ö‑ ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑a mɛ do 'ö Zuda 'ka bhë, waa‑ mɛ ‑gbaa ꞊va 'ö ‑blaan ‑nu, 'lü 'klu ‑nu 'dhö ‑an ‑gɔ, ‑wo ‑kë ‑a 'piö 'wo nu. Mɛ ‑nu 'wo nu bhë, slabhomɛ ‑gɔmɛ ‑nu waa‑ Zuifö mɛ ziizii ‑nu ꞊nɛ 'wo ‑an bɔ. ");
INSERT INTO dnj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zuda 'ö Yesu dɔ ö yaagümɛ ‑nu kwɛɛ bhë, ‑yö ꞊duakëpë 'wo dho Yesu kun ‑a ‑bha ‑a ‑zɔn mɛ ‑gbaa ꞊va bhë ‑an ‑dhë ꞊nɛɛ: «Mɛ 'a 'dhoë‑ ‑a 'kpeng mü bhë 'ö tɔɔ mɛ 'ka‑ 'piö bhë kö ‑kaa 'kun!» ");
INSERT INTO dnj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","'Yö Zuda ‑yö ꞊yɔɔn Yesu ‑bha 'ö‑ pö: «'Bha ꞊büee, n ‑Gɔmɛ!» 'Ö to mü 'ö‑ 'kpeng mü. ");
INSERT INTO dnj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","'Ö Yesu ‑ya pö ‑a ‑dhë: «N 'bhamɛ, pë 'ü nu kö 'üën‑ ‑a kë bhë, ‑bhö ‑a kë!» ꞊Dhɛ ꞊ya kë 'dhö, mɛ ‑nu 'wo bhë 'wo ꞊yɔɔn Yesu ‑bha, 'ö 'wo‑ kun. ");
INSERT INTO dnj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","'Yö mɛ ‑nu 'wo ‑kë Yesu 'piö bhë ‑a mɛ do ‑yö ö ‑bha ‑blaan ‑gan ‑kloo 'gü, 'ö slabhomɛ ‑nu ‑gɔmɛ ‑bha yuökëmɛ zaa ö 'tonëga ‑bha, 'ö‑ 'klu ‑kan. ");
INSERT INTO dnj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö ü bha ‑blaan ‑da ‑kloo 'gü, mɛ 'saadhö 'wo ‑blaan 'sü ‑na bhë, ‑wo ‑dho to ‑blaan ꞊kwaa'. ");
INSERT INTO dnj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'Bhaa‑ dɔa ꞊nɛ a ‑mɔ ‑a ‑bha 'a‑ ‑dhɛ n Dë ‑gɔ kö ‑yö nu n ‑dhë, kö ‑dhɛ do ꞊nɛ ‑a 'gü 'yö ö bha bɔmɛ ‑nu 'wo ‑ziö ‑vuu 'gɔɔ‑ 'slaplɛ ö ga ꞊plɛ ‑ta bɔ n ‑dhë ‑a? ");
INSERT INTO dnj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","'Kɛɛ ꞊ya kë 'dhö ‑bezë, pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ‑a 'dhiö ‑dho ‑mɔ 'kuë ‑kɔklë ꞊ɛ? Bhii ‑yö ꞊bɛɛn' ‑sü 'ka ꞊nɛ pë ‑nu 'wo bhë ‑wo ‑dho kë ꞊nɛ ‑kɔ ꞊nɛ ‑a 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö mɛ ‑gbaa ‑nu 'wo bhë ‑an ‑dhë: «‑Më ‑kë 'ka nu n 'kun ꞊dhia ‑blaan ‑nu, 'lü 'klu ‑nu ‑an 'ka ꞊nɛ ꞊dhɛ 'wo‑ pö ‑a ‑bha 'kpa pëyaakëmɛ ‑mü n 'ka ‑a 'dhö e? Yi 'saadhö 'ka, a ‑kë ꞊yaannu ‑sü 'ka ka 'piö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü mɛ ‑nu ꞊daan' ‑sü 'ka, 'ö kaa n 'kun. ");
INSERT INTO dnj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","'Kɛɛ pë ‑nu 'wo bhë 'saadhö, ‑wo ‑kë kö pë 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑wa ꞊blɛɛ 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü bhë, ‑a 'dhiö ‑yaan ‑mɔ 'kuë.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu 'plɛ ‑wo ꞊duë 'wo ‑kan ‑a ‑zü 'kuë‑. ");
INSERT INTO dnj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mɛ ‑nu bhë ꞊dhɛ 'wo Yesu kun, ‑wo ‑nu ‑a 'ka Kaifö 'ö ‑kë slabhomɛ ‑nu ‑gɔmɛ ꞊va 'ka bhë ‑a 'dhiö. ‑Dhɛ bhë ‑a 'gü, Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ ‑an ‑bha mɛ ziizii ‑nu ‑wo ‑kë wo 'kuë‑ mü. ");
INSERT INTO dnj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛɛ ‑yö ‑ziö Yesu 'piö, ‑gɛntozlöödhe 'ka, 'ö nu 'ö ꞊daa' slabhomɛ ‑nu ‑gɔmɛ ꞊va ‑gɔ 'kwɛandhö, 'ö waa‑ 'yan ‑to 'kɔ ‑bha ‑mɛ ‑nu ‑wo ꞊yaannu mü, kö ‑kɔ 'ö 'wun bhë 'ö dho yën ‑a 'ka, 'yaan‑ ‑a dɔ. ");
INSERT INTO dnj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Slabhomɛ ‑nu ‑gɔmɛ 'wo zakanmɛ ꞊vava 'ka bhë waa‑ zakanmɛ ꞊vava 'wo to, ‑wo ꞊sua ‑wun 'wo dho ‑a dɔ ‑a ‑bha kö ‑yaan kë 'wun ‑dɔadhe 'ka ‑waan ‑za ‑lo ‑a tuö ‑yaan kë ‑a zë ‑gɛn 'ka bhë, ‑wo ‑kë ‑a ꞊mɛɛ' ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","‑Wo ‑bɔ mü 'dhö do do 'ka wo ‑bha ꞊sua ‑wun ꞊blɛɛ' ‑sü 'ka, 'ö ‑an ‑wo yaa 'ö 'ko 'sü. 'Ö mɛ ‑kaanta ꞊plɛ ‑wo nu ");
INSERT INTO dnj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","'wo‑ pö: «Gɔɔn‑ 'ö ꞊nɛ ‑ya pö ‑yö ‑dho ‑Zlan ‑gba ‑a 'gü ‑kɔ ꞊wüü'‑, 'ö‑ ‑dhɛkpaɔyi ‑yaaga 'ka 'ö‑ gbɛ dɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","'Ö slabhomɛ ‑nu ‑gɔmɛ ꞊va 'yö ꞊luu, 'ö‑ pö Yesu ‑dhë: «'Wun 'ö mɛ ‑nu ꞊nɛ 'wo‑ ꞊blɛɛ' ‑na ü ‑gɔ bhë, ü 'ka 'dho ‑a gbɛ ‑daa kë ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","'Kɛɛ Yesu yaa ‑daa kë ‑a ‑gɔ. 'Ö slabhomɛ ‑gɔmɛ ꞊va ‑ya pö ‑a ‑dhë 'zü: «‑Zlan 'ö 'bhee‑ ‑a 'tɔ 'ka, a‑ ‑dhɛ ü ‑gɔ kö 'ö ꞊ya kë ꞊nɛ ‑a Gbö, ‑a ‑bha ‑Yamɛ ‑mü ü 'ka 'ü‑ ꞊blɛɛ'‑ yi ‑dhë ‑wo ‑bhö ‑sü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «꞊Ii‑, yö gia‑ 'ü‑ ꞊blɛɛ bhë, 'kɛɛ a‑ ‑blɛɛ ka ‑dhë: 'Ö sü ꞊dɛɛ ‑bha zlöö, ka ‑dho ma Mɛgbö n yö kö 'a ‑ya ‑sü 'ka ‑Zlan 'piigbeezë ‑bha ‑yadhɛ ꞊bhlëzë ‑bha. Ka ‑dho n yö 'zü dha kpö ‑nu 'gü kö a nu ‑na.» ");
INSERT INTO dnj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","꞊Dhɛ ꞊ya kë 'dhö, slabhomɛ ꞊va ‑yö ö ‑bha gblang ‑blë ‑naazuëdhe 'ka 'ö‑ pö: «‑Më 'kwa ‑yaa ‑gɔ ‑ɛ? ꞊Ya 'si bho ‑Zlan ‑gɔ! Kwa ‑bha ‑wun 'yaa ‑tɔmɔ ‑bha gbɔ, 'wun 'ö 'go ‑na ‑a ꞊blɛɛ' ꞊dhia ‑Zlan 'ka bhë, ka‑ ‑ma. ");
INSERT INTO dnj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ka ‑bha ‑zotadhe tɔɔ ‑më ‑ɛ?» 'Wo‑ ‑daa ‑kë 'wo‑ pö: «꞊Ee‑, ‑a zë ‑sü ‑ya ‑ma ‑kun!» ");
INSERT INTO dnj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","'Wo wo 'dhee ‑nu ‑suö ‑a wöödhö, 'wo‑ ‑ma ‑kɔ kpö 'ka kö mɛ 'bhaa ‑nu ‑wa 'to ‑ma ‑na ‑a pö ‑sü 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","«‑Zlan ‑bha ‑Yamɛ, mɛ 'ö ü ‑ma bhë, ‑a 'tɔ pö yi ‑dhë!» (Bhii ꞊dhɛ kë ‑na 'dhö kö ꞊wa sɔ ‑klu ‑a woë‑.) ");
INSERT INTO dnj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piɛɛ ‑yö ‑kë ‑ya ‑sü 'ka plaan 'kwɛandhɛ bhë ‑a 'yasa 'gü ‑dhɛ ‑bha, 'ö slabhomɛ ‑gɔmɛ ‑bha yuökëdhe do ‑yö ꞊yɔɔn Piɛɛ ‑bha 'ö‑ pö: «Bhi ‑de 'pö, ü ‑kë Yesu 'ö go Galile bhë ‑a 'piö!» ");
INSERT INTO dnj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'Ö Piɛɛ ‑yö ꞊kploo Yesu ‑wun 'ka mɛ 'plɛ wö 'dhiö mü 'ö‑ pö: «Pë 'ü‑ 'piö kö 'ü‑ ꞊blɛɛ'‑ bhë 'maa‑ dɔ!» ");
INSERT INTO dnj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","꞊Dhɛ ‑kë 'dhö 'ö Piɛɛ ‑yö dho ‑yö plaan ‑zian 'ka, 'ö ‑ko 'zü 'ö yuö kë 'në dhe do 'bhaa ‑ya yö 'ö‑ pö mɛ ‑nu 'wo kë mü ‑an ‑dhë: «Mɛ ꞊nɛ ‑yö ‑kë Yesu, Nazalɛtë mi bhë ‑a 'piö!» ");
INSERT INTO dnj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","'Ö Piɛɛ ‑yö ꞊kploo 'zü ‑dëüwo 'ö‑ pö: «A‑ ‑blɛɛ ‑Zlan ‑dhë ꞊nɛ, gɔɔn‑ 'ö bhë 'maa‑ dɔ!» ");
INSERT INTO dnj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","꞊Dhɛ 'töng pë 'tee ꞊ya ziö, mɛ ‑nu 'wo ‑kë mü, 'wo ꞊yɔɔn Piɛɛ ‑bha, 'wo‑ pö ‑a ‑dhë: «Giagia 'ka, mɛ ‑nu 'wo bhë ü ‑an mɛ do 'ka, bhii ü 'wun ꞊blɛɛ' ‑wo ‑yö ü 'godhɛ ‑zɔn yi ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","꞊Dhɛ ‑kë 'dhö, 'ö Piɛɛ ‑yö yö ‑wo ‑bhokuëdhe kë ‑sü ‑bha ꞊nɛɛ: «꞊Ya kë ꞊sua 'ka, ‑Zlan ‑yö n 'klo bhɔ! A‑ ‑blɛɛ ‑Zlan ‑dhë ꞊nɛ, gɔɔn‑ bhë 'maa‑ dɔ!» ‑Dhɛ bhë 'ö to ‑a ‑bha 'ö ‑tɔgɔn ‑yö ‑we. ");
INSERT INTO dnj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Ö Piɛɛ ‑zo ‑yö ‑büö, ‑wo 'ö Yesu ‑ya pö ‑a ‑dhë bhë ‑a 'ka ꞊nɛɛ: «‑A kë ‑yi 'ka, ‑tɔgɔn ‑yaan 'we, ü ‑dho ꞊kploo n ‑wun 'ka ‑gwaa ‑yaagazë ꞊nɛ, 'bhaa n dɔ.» 'Ö yö plaan 'ö 'gbo bɔ 'yenazë 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","‑Dhiadhiö tii 'gü, slabhomɛ ‑gɔmɛ ‑nu 'töüdhö waa‑ Zuifö mɛ ziizii ‑nu ‑wo ‑kpɔ wo 'kuë‑ kö 'waan‑ Yesu zë. ");
INSERT INTO dnj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","'Wo‑ ‑lö 'wo dhoë 'wo‑ dɔ 'sɛ ꞊kɔɔnmɛ Pilatö kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","꞊Dhɛ Zuda 'ö Yesu 'dhɔɔ dɔ bhë ꞊yaa‑ yö ꞊nɛ ꞊wa za ‑lo Yesu tuö, 'ö‑ ꞊zuö' ‑yö za dɔ ‑a ‑bha, 'ö ‑yɛ ö 'zü, 'ö dho 'wëü‑ 'puu ga 'gɔɔ‑ ‑yaaga bhë ‑a 'ka slabhomɛ ‑gɔmɛ ‑nu waa‑ mɛ ziizii ‑nu ‑an ꞊dhia, ");
INSERT INTO dnj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'yö‑ pö ‑an ‑dhë: «꞊Sɔɔn yaa 'a‑ ‑kë mɛ yaa 'wun yaa kë bhë, 'a‑ dɔ ka kwɛɛ 'kaan‑ ‑a zë bhë ‑a 'ka.» 'Kɛɛ ‑wa ‑pö ‑a ‑dhë: «Yi ‑bha 'wun gbɛ 'yaa‑ 'gü, bhi ꞊nɛ 'ö ü bha 'wun 'dhö ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","'Ö Zuda ‑yö 'wëü‑ bhë 'yö‑ ‑pɛn sia‑ ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü mü, 'ö ‑ziö 'ö dho, 'yö ö ‑de dun 'lü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","'Ö slabhomɛ ‑gɔmɛ ‑nu ‑wo 'wëüga bhë ‑a sü 'wo‑ pö: «Kwa ‑bha tɔng ‑ya ‑pö kö ꞊kun 'kwaa fɛi ꞊sɔnng' ‑da ꞊gbëü 'ö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü bhë ‑a 'gü. Bhii 'ö tɔɔ mɛ 'wo‑ zë ‑a ꞊sɔnng' ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","꞊Dhɛ 'ö ‑an ‑wo ꞊ya 'kpɔ ‑a ‑bha, 'wëüga bhë 'wo gbɔdɔmɛ ‑bha ꞊bhlöödhɛ dhɔ ‑a 'ka, 'ö ‑kë ‑nia ‑nu mɛ ꞊wa ga ‑an ‑bindhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","‑A ‑wun 'gü ꞊dɛɛ ꞊nɛ ‑a 'gü, ‑wo ꞊tun ‑dhɛ bhë ‑a ‑dhɛ «mɛ fɛi ‑dhɛ». ");
INSERT INTO dnj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","‑Kɔ 'ö ꞊kaa' 'ö ‑wo 'ö ‑Zlan ‑wodhiölomɛ Zelemi ‑ya pö 'kpa 'ö‑ 'dhiö ‑yö ‑mɔ ‑a 'ka 'kuë 'ö bhë. Bhii ‑ya ‑pö: ‑Wo 'wëü‑ 'puu 'gɔɔ‑ ‑yaaga 'ö ‑kë 'wëü‑ 'ö Izlaɛlö ‑mɛ ‑nu ‑wo ‑kpɔ 'kuë‑ do kö ‑waan dhɔa bhë ‑wa ‑sü, ");
INSERT INTO dnj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'wo gbɔdɔmɛ ‑bha ꞊bhlöödhɛ dhɔ ‑a 'ka ꞊nɛ ‑kɔ 'ö kwa Dëmɛ ‑Zlan ‑ya ꞊blɛɛ ‑a 'ka bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ‑yö ‑dho 'sɛ ꞊kɔɔnmɛ Pilatö 'dhiö, 'yö‑ ꞊dhɛɛ' kpɔ 'ö‑ pö: «Zuifö ‑nu ‑bha ‑gludë ‑mü ü 'ka a?» 'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü‑ ꞊blɛɛ bhë.» ");
INSERT INTO dnj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Go mü ꞊dhɛ 'ö slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ mɛ ziizii ‑nu 'dho 'wun dɔ ‑na ‑a ‑bha, yaa‑ ‑daa kë gbɔ. ");
INSERT INTO dnj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","'Ö Pilatö ‑ya pö ‑a ‑dhë: «'Wun ‑nu 'wo‑ dɔ ‑na ü ‑bha ꞊nɛ, 'bhaa‑ ma ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'Kɛɛ Yesu yaa‑ ‑daa do gbɛ 'sü ‑a 'gü, yaa‑ kë ‑a ‑gɔ. ‑A ‑wun 'gü 'tetundhe ꞊va ‑yö ‑da 'sɛ ꞊kɔɔnmɛ Pilatö 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Paakö 'wlaan‑ 'saadhö ‑a 'ka, 'sɛ ꞊kɔɔnmɛ Pilatö ‑yö mɛ 'ö 'sɛgümɛ ‑nu 'dho ‑a 'piö, ‑a ‑bho ‑kanso 'gü ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Gɔɔn‑ do 'ö mɛ 'plɛ ‑wa dɔ 'wo‑ ‑dhɛ Balaba, ‑yö ‑kë ‑kanso 'gü mü. ");
INSERT INTO dnj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","'Ö Pilatö ‑ya pö mɛ ‑nu 'wo nu wo 'ko ꞊bhaa ‑a wö 'dhiö mü bhë ‑an ‑dhë: «Dö 'ka‑ 'piö kö 'a‑ bho mü ꞊i? Balaba 'iin Yesu 'wo‑ ‑dhɛ Klito bhë e?» ");
INSERT INTO dnj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bhii ‑ya ꞊dɔa' ꞊nɛ ‑wo Yesu ‑dɔ ö kwɛɛ ꞊druɛi 'ö ‑da ‑an 'gü bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatö ‑yö ‑kë zadɔkɔ 'gü, 'ö‑ ‑bha dhebɔ ‑yö mɛ ‑bɔ ‑a ‑dhë 'ö‑ pö: «Kö ꞊kun 'ü pë gbɛ ‑kë gɔɔn‑ 'ö 'wun yaa gbɛ 'yaa‑ ‑bha bhë ‑a 'ka! Bhii yiö ꞊zian' ꞊dɛɛ, n ꞊sëë'‑ ‑yö ‑bho ‑a ‑wun 'gü ꞊duö.» ");
INSERT INTO dnj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","'Kɛɛ slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ mɛ ziizii ‑wo ‑gban mɛ ‑gbaa ‑nu 'wo bhë ‑an ‑bha, kö ‑wo Balaba bho mü, kö ‑wo Yesu ‑zë zë. ");
INSERT INTO dnj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","'Ö Pilatö ‑yö ‑an ꞊dhɛɛ' kpɔ 'zü 'ö‑ pö: «Mɛ ꞊plɛ 'wo bhë, ‑a dözë 'ka‑ 'piö kö 'a‑ bho mü ꞊i?» 'Ö 'wo‑ pö: «Balaba ꞊nɛ 'yi‑ 'piö!» ");
INSERT INTO dnj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","'Ö Pilatö ‑yö ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Kö 'a ‑më kë Yesu 'ö‑ 'tɔ ‑yö ‑kë Klito 'ka bhë ‑a 'ka ɛ?» 'Ö ‑an 'plɛ ‑wa ‑pö: «‑A dɔ ‑gaatalü ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","'Ö Pilatö ‑ya pö: «‑Më ‑wun yaa 'ö gɔɔn‑ ꞊nɛ 'ö‑ ‑kë ‑ɛ?» 'Kɛɛ ‑wo ‑yö ꞊gblaa 'gbla ‑sü 'gü wo ꞊faan' 'plɛ 'ka ꞊nɛɛ: «‑Bhö ‑a dɔ ‑gaatalü ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","꞊Dhɛ 'ö Pilatö ꞊yaa‑ yö ꞊nɛ ö ‑wo 'yaa ‑mɔ ‑na, 'kɛɛ ‑an ‑wo 'dho ‑na 'dhiö ‑kplawo, 'ö 'yi sü 'yö ö ‑kɔ ‑zlu, mɛ ‑gbaa ‑nu 'plɛ wö 'dhiö mü, 'ö‑ pö: «N ‑kɔ 'yaa gɔɔn‑ 'ö kpengdhö ꞊nɛ ‑a zë ‑sü ‑wun 'gü, ‑a mɛ bhë ka ‑bha 'wun ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","'Ö mɛ ‑gbaa ‑nu 'wo bhë 'wo‑ pö: «‑A fɛi ‑wun ‑yö ‑lo yi ‑nu, yië‑ yi ‑bha 'në ‑nu, yi tuö!» ");
INSERT INTO dnj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","꞊Dhɛ ꞊ya kë 'dhö, 'ö Pilatö ‑yö Balaba bho ‑kanso 'gü 'sɛgümɛ ‑nu ‑dhë, 'ö Yesu nu 'dhasi ‑nu ‑dhë, 'wo‑ ‑ma. 'Go mü, 'ö‑ dɔ ‑an kwɛɛ kö 'waan‑ ‑a dɔ ‑gaatalü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","'Dhasi ‑nu ‑wo ‑dho Yesu 'ka Pilatö ‑gɔ kɔɔ, 'ö 'dhasi ‑nu mɛ 'wo to 'ö ‑an 'plɛ ‑wo nu wo 'ko ꞊bhaa mü. ");
INSERT INTO dnj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'Wo Yesu ‑bha sɔ ‑nu bho ‑a ‑bha, 'wo gblang nuɛazë do ‑da ‑a ‑bha, ");
INSERT INTO dnj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","'wo 'ginng ‑gbloo ꞊gblaa' do ‑kë, 'wo‑ ‑kë ‑a ‑bha 'gɔ ꞊gblaa' 'ka, 'wo‑ ‑ya ‑a tuö, 'ö 'wo 'lünë do dɔ ‑a ꞊kwɛɛ‑ 'gü ‑kɔ 'gü. 'Go mü, 'wo ‑lo wo kpɔn 'gü ‑a 'dhiö duö 'luu ‑sü ‑a ‑bha ‑sü 'ka, 'wo‑ pö: «Zuifö ‑nu ‑bha ‑gludë, 'bha ꞊büee!» ");
INSERT INTO dnj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","'Wo wo 'dhee bho ‑a ‑bha, 'ö 'wo 'lü 'wo‑ dɔ ‑a kwɛɛ bhë, 'wo‑ kun ‑a ‑gɔ, 'wo‑ ꞊maa' ‑a ‑gɔ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","꞊Dhɛ 'ö ꞊wa yën duö 'luu 'sü ‑sü ‑bha ‑a 'ka, 'ö gblang bhë 'wo‑ bho ‑a ‑bha, 'wo‑ ‑bha sɔ ‑nu ‑da ‑a ‑bha; 'wo dho ‑a 'ka kö ‑waan dɔ ‑gaatalü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","꞊Dhɛ 'wo 'dho ‑na, 'ö 'wo ‑kpën gɔɔn‑ do 'ö go Silɛnë, 'wo‑ ‑dhɛ Simɔ ‑a ‑bha, 'wo‑ 'gbee‑ ‑ta bho kö ‑yö Yesu ‑bha ‑gaatalü bun. ");
INSERT INTO dnj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","'Wo dho 'wo ‑lo ‑dhɛ do 'bhaa 'wo‑ ‑dhɛ «Gɔɔgota» ‑a ‑bha, ‑a ‑gɛn 'ö tɔɔ «mɛ ‑gɔ ‑klëë ‑lo ‑dhɛ». ");
INSERT INTO dnj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","‑Dhɛ bhë ‑a 'gü, 'wo ‑drɔɔn 'wo pë 'këü 'yi 'güüzë ꞊kaan ‑a 'ka bhë 'wo‑ nu ‑a ‑dhë. ꞊Dhɛ 'ö ꞊yaa‑ dan, yaa 'we ‑a ‑bha gbɔ kö ‑ya mü. ");
INSERT INTO dnj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","'Wo‑ dɔ ‑gaatalü ‑bha ꞊taan ‑nu ‑gban ‑a ‑gɛn waa‑ ‑a ‑kɔ ‑nu ‑an ‑ta ‑sü 'ka. 'Go mü 'wo‑ ‑bha sɔ ‑nu ‑glu wo 'ko 'ka 'töü‑ ‑bhö ‑sü 'ka, ");
INSERT INTO dnj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'wo ‑ya mü, wo 'yan ‑to ‑a ‑bha ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","‑A ‑gɔ ‑ta dhuö pë 'ö‑ zë ‑gɛn 'ka, 'wo‑ ‑ya mü 'ö tɔɔ: «Mɛ ꞊nɛ 'ö tɔɔ Yesu 'ö Zuifö ‑nu ‑bha ‑gludë 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","‑Wo ꞊kwaan ‑gludamɛ ‑nu ꞊plɛ ‑dɔ ‑gaatalü ‑bha Yesu 'pian 'piö mü; ‑a mɛ do ‑yö ‑kë ‑a ꞊kwɛɛ‑ 'gü, 'ö‑ mɛ do ‑yö ‑kë ‑a ꞊kwaa‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mɛ ‑nu 'wo ‑kë ziö ꞊dhia mü, ‑wo wo ‑gɔ zë 'gü 'si ‑nu ‑bho Yesu ‑gɔ ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","‑Wo ‑kë ‑a pö ꞊dhia ‑a ‑dhë: «Bhi 'ü‑ ‑kë kö 'üën‑ ‑Zlan ‑gba ‑a 'gü ‑kɔ 'wü, kö ‑dhɛkpaɔyi ‑yaaga 'piö 'üën‑ ‑a gbɛ dɔ bhë, ‑bhö ü ‑de dha; 'ö 'go mü, ꞊ya kë ꞊nɛ ‑Zlan Gbö ‑mü ü 'ka, ‑bhö 'go ‑gaatalü ‑bha 'ü yö sia‑ 'sa!» ");
INSERT INTO dnj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","‑Kɔ do bhë ‑a 'ka slabhomɛ ‑gɔmɛ ꞊vava ‑nu, Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ mɛ ziizii ‑nu, 'wo yö duö 'luu ‑sü ‑a 'ka ‑sü 'gü 'pö, ‑a pö ‑sü 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Mɛ ‑nu dha 'yö‑ wo, 'kɛɛ 'yaa ‑mɔ ‑a ‑bha kö ‑yö ö ‑de dha! 'Ö ꞊ya kë ꞊nɛ Izlaɛlö ‑bha ‑gludë ‑mü ‑a 'ka, kö ‑yö ö ‑de bho ‑gaatalü ‑bha kö 'yiën‑ ‑a ‑wo ‑dhɛ 'wun giagia. ");
INSERT INTO dnj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","‑Yö ö ‑zo yö ‑Zlan ‑bha 'ö‑ pö: ‹A ‑Zlan Gbö 'ka›; ꞊dhɛ 'ö 'dhö, ‑kwa ‑a ‑ga kö ‑a ‑dhɔ ‑dho ‑Zlan kë, 'yö‑ dha 'sabla kɔ.» ");
INSERT INTO dnj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","'Ö ꞊kwaan ‑gludamɛ ‑nu 'wo ‑kë ‑gaatalü ‑bha ‑a 'piö mü bhë, 'wo 'si ‑nu ‑bho ‑a ‑gɔ ꞊nɛ ‑kɔ do bhë ‑a 'dhö 'pö. ");
INSERT INTO dnj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","꞊Dhɛ 'kwa dɔ lënngü, 'ö ‑dhɛ ‑yö ‑trö 'sɛ ‑dhɛ 'saadhö ‑ta, 'ö dho 'ö yöë 'wɔ 'yɛ ‑lan ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","꞊Dhɛ 'kwa dɔ 'wɔ 'yɛ ‑lan 'ka, 'ö Yesu ‑yö ‑gbla ‑wo 'gbee‑ 'ka ꞊nɛɛ: «Eli, Eli, lema sabasötani!» (‑A ‑gɛn 'ö tɔɔ «n ‑ma ‑Zlan, n ‑ma ‑Zlan, ‑më 'yö ‑kë 'ü ü ꞊kwaa n ‑wun ‑zü ‑i?») ");
INSERT INTO dnj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mɛ ‑nu 'wo ‑kë mü, ‑a mɛ do do ‑nu ‑wa ‑wo ‑ma, 'ö 'wo‑ pö: «‑Yö Eli ꞊dhɔɔ kë ‑na!» ");
INSERT INTO dnj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Ö mɛ do ‑yö go ‑an 'gü ‑bla 'ka, 'yö dho 'yö ꞊fuu'‑ sü, 'ö‑ zë ‑drɔɔn 'yi ꞊gliisü 'ka, 'yö‑ ‑ya 'lünë 'dhiö, 'yö‑ ꞊yɔɔn Yesu 'dhi 'sɔɔ kö ‑yaan ‑a mü. ");
INSERT INTO dnj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","'Kɛɛ ‑an mɛ 'wo to ‑wa pö: «‑Bhö dɔ, 'ö ꞊ya kë ꞊nɛ Eli ‑dho nu 'ö‑ dha kö 'kwaan‑ ‑a yö.» ");
INSERT INTO dnj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","'Ö Yesu ‑gbla ‑dëüwo 'gbee‑ 'ka 'ö ga. ");
INSERT INTO dnj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","'Ö to mü, ‑dun 'kɔdhi ‑bha ‑sɔ 'ö ‑kë ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü bhë, 'ö ‑pɛ dhuö 'ö nu 'ö yöë sia‑ ‑tɛidhö; 'ö 'sɛ ‑nu ‑wo ꞊zluun, 'ö ‑guö ‑tɔn ‑nu ‑wo 'fa bho. ");
INSERT INTO dnj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","'Ö blɔɔn‑ ‑nu 'dhi ‑yö ‑po, 'ö ‑Zlan ‑bha mɛ ‑nu 'ö 'wo ga 'dhiö, 'ö ‑an ꞊plëëzë ꞊glöö ‑wo go ga 'gü, ");
INSERT INTO dnj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'wo go blɔɔn‑ 'gü 'wo yö plaan. ꞊Dhɛ Yesu ‑yö go ga 'gü, 'ö mɛ ‑nu 'wo bhë 'wo nu Zeluzalɛmë plöö, 'ö mɛdhɛvadhɛ ‑wo ‑an yö. ");
INSERT INTO dnj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wlɔmë mi 'ö ‑kë 'dhasi ꞊këng' do ‑gɔmɛ 'ka waa‑ 'dhasi ‑nu mɛ 'wo ‑kë wo 'yan ‑to Yesu ‑bha ꞊dhia bhë ‑wo 'sɛ ꞊zluun ‑kɔ waa‑ pë ‑nu 'wo ‑kë 'töüdhö bhë ‑an ‑yö. 'Ö 'suö ꞊va ‑yö ‑da ‑an 'gü 'wo‑ pö: «Mɛ 'ö ꞊nɛ ‑yö ‑Zlan Gbö giagia 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Dhoo ‑nu ꞊plëëzë 'wo dɔ ꞊gbiin 'wo ‑dhɛ ‑ga, ‑wo ‑kë ‑ziö Yesu 'piö ꞊dhia kö ‑yö Galile, 'wo yuö ‑nu ‑kë ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mali 'go Madala 'dhö, Mali Zakö waa‑ Zozɛfu ‑an dhe, waa‑ Zebede bɔɔ ‑wo ‑kë mü, dhoo ‑nu 'wo bhë ‑an ziën. ");
INSERT INTO dnj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","꞊Dhɛ 'yiniadhɛ ‑yö dɔ, gɔɔn‑ do ꞊bhɔɔzë 'yö ‑kë Alimate mi 'ka 'wo‑ ‑dhɛ Zozɛfu, yö ‑de 'pö ‑yö ‑kë Yesu ‑bha ꞊guë' ‑nu mɛ do 'ka, ");
INSERT INTO dnj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","'Ö dho Pilatö 'piö, 'yö Yesu ꞊glöö ‑dhɛ ‑a ‑gɔ. 'Ö Pilatö ‑yö ‑we ‑a ‑bha kö ‑wo Yesu ꞊glöö nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","'Ö Zozɛfu ‑yö Yesu ꞊glöö dhu sɔ 'puu ‑dëü do 'ka, ");
INSERT INTO dnj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'ö‑ ‑bin ‑guö ‑du do ‑dëü 'yö‑ pɔn ö ‑de ‑bha blɔɔn‑ 'ka bhë ‑a 'gü. 'Go mü 'yö ‑guö 'fa 'gbiin‑ do ꞊glöng glö 'ö‑ yö ‑guö ‑du bhë ‑a 'dhiö, 'ö‑ to 'ö dho. ");
INSERT INTO dnj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mali 'go Madala waa‑ Mali kë ꞊plɛ ‑naa, ‑wo ‑kë ‑ya ‑sü 'ka blɔɔn‑ bhë ‑a wö 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","꞊Dhɛ Zuifö ‑nu ‑bha ꞊glooyi ‑de ‑pë kë ‑yi ꞊ya ziö, 'ö‑ ‑ta ‑dhɛ ꞊ya 'po, 'ö slabhomɛ ‑gɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu ‑wo dho wo 'kuë‑ 'wo dho Pilatö 'piö. ");
INSERT INTO dnj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","'Ö 'wo‑ pö ‑a ‑dhë: «Yi dëmɛ, yi ‑zo ꞊ya ‑büö bhii ꞊suamɛ 'ö bhë kö yaa ga ꞊kun, ‑ya ‑pö ‑dhɛkpaɔyi kë ‑yaaga ‑naa 'ka, ‑yö ‑dho go ga 'gü. ");
INSERT INTO dnj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","‑Bhöë pö 'dhasi ‑nu ‑dhë ‑wo wo ‑zo ‑kë ‑a blɔɔn‑ 'piö ‑dhɛkpaɔyi ‑yaaga 'ka, ‑yö kë 'dhö kö ꞊kun 'ö‑ ‑bha ꞊guë' ‑nu dho nu ‑waan ‑a ꞊glöö ꞊kwaan, kö ‑waan pö 'sɛgümɛ ‑nu ‑dhë ꞊ya 'go ga 'gü. Kwaa‑ kë 'dhö, ꞊sua ‑wun ‑mɛ 'ö bhë ‑yö ‑dho kë ꞊gbaɔnsü 'ö ꞊zië' ‑a ‑blɛɛzë ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","'Ö Pilatö ‑ya pö ‑an ‑dhë: «'Dhasi ‑nu 'wo dho wo 'yan to ‑a blɔɔn‑ ‑bha 'wo ꞊nɛ. ‑Ka 'dho, ‑kɔ 'wo dho wo ‑zo kaa ‑a 'piö ‑së 'ka ka ‑dhë, 'ka‑ kaa!» ");
INSERT INTO dnj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","꞊Dhɛ ꞊ya kë 'dhö, 'ö blɔɔn‑ 'dhitapë bhë ꞊bhüö' ‑ziö ‑a 'dhiö, 'wo‑ ꞊dua' ‑kë, ‑yö kë 'dhö kö ꞊kun 'ö‑ 'dhi dho po. 'Go mü, 'wo 'dhasi ‑nu ‑ya ‑a ‑maa. ");
INSERT INTO dnj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","꞊Dhɛ 'ö Zuifö ‑nu ‑bha ꞊glooyi ꞊ya ziö, ‑dhɛ mɛ 'ö ‑po ‑a 'piö, ‑a ‑dhiadhiö tii 'gü bhë 'ö Mali 'go Madala waa‑ Mali kë ꞊plɛ ‑naa bhë 'wo nu blɔɔn‑ ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","'Ö to mü 'sɛ ‑yö yö ꞊zluun ‑sü ‑bha 'gbee‑ 'ka, 'ö ‑Zlan ‑bha bɔmɛ do ‑yö go dhang‑ 'gü 'yö nu mü, 'ö ‑guö bhë 'yö‑ ‑blü 'pian 'piö, 'ö dho ‑a ‑ta dhuö, 'yö ꞊yaannu. ");
INSERT INTO dnj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","'Ö‑ 'bhü ‑yö yö ꞊nɛ dha ‑bha 'yan bɔ ‑sü 'bhü 'dhö, 'ö‑ ‑bha sɔ ‑nu ‑wo ‑kë 'puu ꞊nɛ bhlo kpö 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Dhasi ‑nu ‑wo ‑zluun 'suö 'ka, 'ö ꞊dhɛ to zlöö kö ꞊wa kë ꞊nɛ mɛ ꞊wa ga ‑an 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","'Ö ‑Zlan ‑bha bɔmɛ ‑ya pö dhoo ‑nu 'wo bhë ‑an ‑dhë: «Kö ꞊kun 'ö 'suö ‑yö ka ‑kë! Bhii a‑ ꞊dɔa' ꞊nɛ Yesu 'wo‑ dɔ ‑gaatalü ‑bha bhë 'ka‑ ꞊mɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'Yaa zö gbɔ, ꞊ya 'go ga 'gü ꞊nɛ ‑kɔ 'ö‑ pöë ka ‑dhë 'dhiö bhë ‑a 'dhö. ‑Ka nu ‑dhɛ 'ö ‑wɔ ‑a ‑bha bhë 'ka‑ ‑ga!» ");
INSERT INTO dnj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","'Ö ‑Zlan ‑bha bɔmɛ ‑ya pö ‑an ‑dhë 'zü ꞊nɛɛ: «‑Ka 'dho ‑bla 'ka 'ka‑ pö ‑a ‑bha ꞊guë' ‑nu ‑dhë: ‹꞊Ya 'go ga 'gü, ‑yö 'dho ‑na ka 'dhiö Galile ‑sɛ 'gü. ‑Dhɛ bhë 'ka dho ‑a yö ‑a ‑bha›. 'Wun 'yö ‑kë n ‑gɔ 'aan‑ ꞊blɛɛ'‑ ka ‑dhë bhë 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Waa ꞊glɔɔ mü gbɔ, ‑wo ‑go blɔɔn‑ ꞊taa mü, 'suö waa‑ ꞊zuögludhi ꞊va 'yö ‑an pa bhë ‑a 'ka. 'Wo ‑bla sü, 'wo dho 'wuntaɔsë 'ö bhë ‑a 'ka Yesu ‑bha ꞊guë' ‑nu ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","‑Wo ‑kë 'dho ꞊dhia, 'ö 'kan 'wo‑ wo ‑ta, kö Yesu ‑yö nu ‑na ‑an ‑gɔ zian‑, 'ö‑ pö ‑an ‑dhë: «'Ka ꞊büee!» 'Wo ꞊yɔɔn ‑a ‑bha, 'wo pa ‑a ‑gɛn 'ka, ‑gblü ‑a ꞊gɛɛndhö ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «Kö ꞊kun 'ö 'suö ‑yö ka ‑kë! ‑Ka 'dho 'ka‑ pö n dhegluzë ‑nu ‑dhë ‑wo 'dho Galile, ‑dhɛ bhë 'wo dho n yö ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kö dhoo ‑nu 'wo bhë ꞊wa ‑da zian ‑ta, 'dhasi ‑nu 'wo wo ‑zo ‑kë Yesu blɔɔn‑ 'piö bhë, ‑an mɛ 'bhaa ‑nu, ‑wo ‑dho plöö, 'ö pë ‑nu 'wo ‑kë 'töüdhö bhë, 'wo‑ ꞊blɛɛ slabhomɛ ‑gɔmɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","'Yö slabhomɛ ‑nu ‑gɔmɛ ‑wo yö mɛ ziizii ‑nu ‑bha, 'ö ‑an ‑wo ‑yö kpɔ ‑a ‑bha, 'wo 'wëüga ꞊va sü 'wo‑ nu 'dhasi ‑nu 'wo bhë ‑an ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","'Ö 'wo‑ pö ‑an ‑dhë: «Ka ‑dho ‑a pö mɛ ‑nu ‑dhë: ‹‑A ‑bha ꞊guë' ‑nu ‑wo ‑nu gbeng, 'wo‑ ꞊glöö sü kö yi yiö.› ");
INSERT INTO dnj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","꞊Ya kë ꞊nɛ 'sɛ ꞊kɔɔnmɛ ꞊yaa‑ ma, yi ‑dho 'wun ꞊blɛɛ'‑ ‑a ‑dhë, 'ö 'yi ka bho 'wun bhë ‑a 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'Ö 'dhasi ‑nu ‑wo 'wëü‑ bhë 'wo‑ sü, 'ö 'wo‑ ‑kë ꞊nɛ ‑kɔ 'wo‑ pöë ‑an ‑dhë bhë ‑a 'dhö. 'Ö ‑an ‑bha ‑a ꞊blɛɛ' ‑kɔ bhë, 'ö‑ ‑taɔ ‑yö ‑pɛn ‑dhɛ 'saadhö 'gü, 'ö dho 'ö yöë ꞊dɛɛ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","꞊Guë' ‑nu 'gɔɔ‑ do ö ga do 'wo bhë ‑wo ‑dho Galile ‑tɔn do 'ö Yesu ‑ya ‑zɔn ‑an ‑dhë bhë ‑a tuö. ");
INSERT INTO dnj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","꞊Dhɛ 'ö ꞊waa‑ yö, 'wo ‑gblü ‑a ꞊gɛɛndhö; 'kɛɛ mɛ 'bhaa ‑nu ‑wo ‑kë ‑an ziën yaa ‑an ‑zo 'kun ꞊nɛ Yesu gia‑ ‑mü ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ‑yö ‑yɔɔn ‑an ‑bha, 'ö‑ pö ‑an ‑dhë: «‑Kɔ ‑mɔ 'wuën‑ ‑sü 'saadhö ‑yö ‑nu n ‑dhë ‑sü 'ka dhanggüdhɛ waa‑ 'kpongtaadhɛ ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","꞊Dhɛ ‑kë 'dhö, ‑ka 'dho mɛ ‑nu 'piö 'sɛ 'saadhö 'gü, 'ka ‑an kë ma ꞊guë' ‑nu 'ka! 'Go mü, 'ka ‑an ‑bɔ yiö n Dë ‑Zlan 'dhö, ‑a Gbö 'dhö, ‑Zuu 'slööslö 'dhö ‑an 'tɔ 'gü! ");
INSERT INTO dnj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","‑Ka ‑an ꞊daan'‑, ‑wo ‑nu 'saadhö 'a ka ꞊daan ‑an 'ka bhë ‑an 'ka, kö ‑wo ‑an 'kun! 'Go mü, 'ka‑ dɔa ꞊nɛ a ka 'piö ‑dhɛkpaɔyi 'saadhö 'ka, 'ö dho 'ö yöë 'kpongtaadhɛ 'dhiötoyi ‑bha.»");
INSERT INTO dnj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","'Wuntaɔsë 'ö ‑gban ‑Zlan Gbö Yesu Klito ‑bha bhë ‑a zü dɔ ‑kɔ ꞊ga ꞊nɛ. ");
INSERT INTO dnj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","‑Yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑wodhiölomɛ Ezai ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: ‑Zlan ‑ya ‑pö: ‑Dhɛ ‑ga, a ‑dho n ‑ma bɔmɛ do bɔ ü 'dhiö, kö ‑yaan ü ‑bha zian ‑gblooga ‑yuö kë. ");
INSERT INTO dnj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Gɔɔn‑ do ‑yö ‑dhoo bho ‑na 'yënng ꞊taa, ‑ya ‑pö ꞊nɛɛ: ‑Ka kwa Dëmɛ ‑bha zian ‑gblooga ‑yuö kë, 'ka‑ dɔ kpengdhö! ");
INSERT INTO dnj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","‑Kɔ do bhë ꞊nɛ 'ö mɛ 'wo‑ ‑dhɛ Zan ‑yö nuë 'yënng ꞊taa. ‑Yö mɛ ‑nu ‑bɔ yiö, 'go mü 'yö ‑dhoo bho mɛ ‑nu ꞊dhɔɔ kë ‑sü 'ka ꞊nɛɛ: «‑Ka ka ‑bha ‑kë ‑a 'gü ‑sü ꞊dhië' ‑kwaa, 'ka bɔ ‑Zlan 'ka kö ‑wo ka ‑bha ‑go ꞊sɔɔn yaa 'gü bɔyiödhe kë! ‑Yö kë 'dhö kö ‑yaan ziö ka këwun yaa ‑nu ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","'Ö mɛ ‑nu 'saadhö 'wo ‑kë Zude ‑mɛ ‑nu 'ka waa‑ mɛ ‑nu 'wo go Zeluzalɛmë plöö 'wo ‑nu ‑a 'piö mü, 'wo wo këwun yaa ‑wun ‑nu ꞊blɛɛ. 'Ö Zan ‑yö ‑an ‑bɔ yiö 'yiga 'wo‑ ‑dhɛ Zuudɛn bhë ‑a ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zan ‑bha ‑dasɔ ‑yö ‑kë ‑yɔɔnmia kaa‑ 'wo‑ bɔ ‑a 'ka, 'ö‑ ‑du kwi do ‑yö ‑kë ‑dɔ ‑a ‑bha sɔ ‑ta ‑pë 'ka, 'ö‑ ‑bhöpë ‑nu ‑wo ‑kë ‑kpaa waa‑ 'zɔ 'yɔn ‑nu ‑an 'ka. ('Ö tɔɔ ‑Zlan ‑wodhiölomɛ ‑nu 'wo ‑kë 'töng 'ö bhë ‑a 'ka bhë ‑an ‑da ‑sɔ waa‑ ‑an ‑bhöpë ‑nu 'wo bhë). ");
INSERT INTO dnj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","'Yö‑ pö mɛ ‑nu 'wo nu bhë ‑an ‑dhë: «Mɛ 'ö 'dhoë‑ nu n ꞊zlöö bhë ‑a 'pii ꞊yö 'gbee‑ 'ö ‑ziö ‑a 'ka n ‑ta. Ma ‑de yaa n ‑ma 'kun kö 'aan‑ ꞊kloo'‑ ‑a 'dhiö 'aan‑ ‑a ‑bha ‑sakpa yun ‑bhüö ‑nu 'po 'aan‑ bho ‑a ‑gɛn ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ma 'pö a ka ‑bɔ yiö 'yi 'ka, 'kɛɛ yö ‑zë ‑yö ‑dho ka pa ‑Zuu 'slööslö 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö go Galile pö‑ do 'wo‑ ‑dhɛ Nazalɛtë bhë ‑a 'gü 'ö nu Zan 'piö. 'Ö Zan ‑ya ‑bɔ yiö Zuudɛn ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","꞊Dhɛ 'ö Yesu 'dho 'go ‑na yiö, 'ö dho ‑dhɛ ‑ga kö dhang‑ 'dhi ꞊ya 'po 'ö ‑Zuu 'ö go ‑Zlan 'piö 'ö ꞊yɔɔ ‑a ‑ta; ‑yö ‑kë ‑tönggö 'ka 'ö nu 'ö ‑ya ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","'Ö‑ 'to ‑yö ‑da ‑Zlan ‑wo 'ö ‑kë 'we ꞊dhia dhang‑ 'gü bhë ‑a 'gü ꞊nɛɛ: «Bhi ꞊nɛ 'ü tɔɔ n Gbö do; ü ‑dhɔ ‑yö n ‑kë ꞊duö. Bhi ꞊nɛ 'ö n ꞊zuögludhi ‑wun 'plɛ 'dhö ü 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑Zuu 'slööslö ‑yö yö ‑a ‑dhë 'dhiö 'ö dho ‑a 'ka 'yënng ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","‑Dhɛkpaɔyi 'gɔɔ‑ ‑yiisië 'yö‑ ‑kë 'yënng ꞊taa mü. 'Ö Satan ‑ya 'gü dan. Waa‑ 'blü ‑wü ‑nu ‑wo ‑kë wo 'ko ꞊bhaa mü. 'Ö ‑Zlan ‑bha bɔmɛ ‑nu ‑wo nu, pë 'ö‑ ‑bha ‑wun ‑ya ‑kë ‑a 'ka, ‑a ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","꞊Dhɛ ꞊wa Zan ‑da ‑kanso 'gü, 'ö Yesu ‑yö dho Galile ‑sɛ 'gü 'ö yö 'wuntaɔsë 'ö go ‑Zlan 'piö ‑a ꞊blɛɛ' ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","'Yö‑ pö mɛ ‑nu ‑dhë: «'Töng ꞊ya ‑lo kö pë 'ö ‑Zlan ‑ya 'tɔ go mɛ 'bhee‑ ‑nu ‑dhë bhë ‑yaan ‑a 'gü ‑pë kë; bhii ‑a ‑bha ‑gludëdhɛ ꞊ya yö ꞊klöö'. ꞊Dhɛ 'ö 'dhö, ‑ka ka bo ka këwun yaa ‑nu 'ka, ('ka bɔ ‑Zlan 'ka,) 'ka 'wuntaɔsë ‑wun ‑dhɛ 'wun gia‑!» ");
INSERT INTO dnj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yi do 'ka kö Yesu ‑yö ‑kë 'ta 'sü ꞊dhia 'yipuë 'kpong 'dhiö Galile ‑sɛ 'gü, 'yö ‑kpën 'yiblükëmɛ ꞊plɛ 'wo ‑an ‑dhɛ Simɔ waa‑ ö dheglu Andre ‑an ‑bha. ‑Wo ‑kë wo ‑bha 'kplö ‑zuö ꞊dhia 'yuö‑ ‑gɔ 'yipuë bhë ‑a ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka ziö n 'piö, a ‑dho ka kë ma 'kplö ‑zuö mɛ ‑nu ‑gɔ ‑mɛ 'ka kö 'kaan‑ nu ‑an 'ka n 'piö.» ");
INSERT INTO dnj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","‑Dhɛ do bhë 'wo to ‑a ‑bha 'wo wo ‑bha 'kplö ‑nu to sia‑ mü 'wo ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","꞊Dhɛ 'ö ꞊ya ö 'bhe 'tee ꞊yɔɔn 'dhiö, 'ö ‑kpën Zakö waa‑ ö dheglu Zan 'wo ‑kë Zebede gbö nu 'ka bhë ‑an ‑bha. ‑Wo ‑kë wo ‑bha 'yitagɔ 'gü, wo ‑bha 'kplö 'blë ‑dhɛ ‑wɔ ‑dhiadhö. ");
INSERT INTO dnj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","'Ö Yesu ‑yö ‑an ꞊dhɔɔ ‑kë. 'Wo wo dë Zebede waa‑ ö ‑bha yuökëmɛ ‑nu ‑an to 'yitagɔ 'gü mü 'wo ‑ziö Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑luu 'wo dho Kapɛɛnaɔmë ‑pö 'gü. Zuifö ‑nu ‑bha ꞊glooyi 'ka, ‑wo ‑da ‑an ‑bha ‑bhɔkuëkɔ 'gü, 'ö Yesu ‑yö yö ‑an ꞊daan' ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mɛ ‑nu 'wo‑ ‑wo bhë ‑a ma, ‑an 'te ‑yö ‑tun ‑a ‑bha mɛ ꞊daan' ‑kɔ bhë ‑a ‑wun 'gü. Bhii ‑a ‑wo 'yaa kë ꞊nɛ ‑an ‑bha tɔnggɔmɛ ‑nu ‑bha mɛ ꞊daan' ‑wo 'dhö, 'ö tɔɔ ‑yö mɛ ‑nu ‑daan ‑wogbiindhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Yi bhë ‑a 'ka gɔɔn‑ do ‑yö ‑kë mü; ‑zuu yaa ‑yö ‑kë ‑a 'gü, 'ö ‑gbla ‑a pö ‑sü 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«‑Më ‑kë ‑ɛ? Yesu, Nazalɛtë mi, ü ‑nu yi 'gü ꞊siö' ꞊dhia ꞊a? A‑ ꞊dɔa' ꞊nɛ, ü mɛ 'slööslö 'ö ‑Zlan ‑ya bɔ ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","꞊Dhɛ ‑kë 'pö 'ö Yesu ‑yö ‑gbla ‑a ‑ta, ‑a pö ‑sü 'ka ꞊nɛɛ: «‑Dhɛ ga ü ‑ta kö 'ü 'go gɔɔn‑ 'ö ꞊nɛ ‑a 'gü!» ");
INSERT INTO dnj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","'Yö ‑zuu yaa ‑yö gɔɔn‑ 'ö bhë ‑a ꞊zaan 'zan 'gbee‑ 'ka 'ö go ‑a 'gü ‑gbla ‑sü 'ka 'gbee‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","'Wun 'ö ꞊nɛ ‑yö mɛ ‑nu 'wo ‑kë mü ‑an 'te ‑tun 'wo yö ꞊dhɛɛ' ‑nu 'kpɔ ‑sü ‑bha wo 'ko ziën ꞊nɛɛ: «Mɛ 'ö ꞊nɛ ‑yö mɛ ‑nu ‑daan ‑wogbiindhɛ 'ka 'dhɛ! Mɛ ꞊daan' ‑kɔ ꞊suu'‑ ‑dëü ‑mlë 'ö ꞊nɛ 'zü ‑i! Gɔɔn‑ 'ö ꞊nɛ ꞊ya 'gbla ‑zuu yaa ‑nu ‑de ‑ta, ‑wo 'wun ma ‑a ‑ta 'dhɛ!» ");
INSERT INTO dnj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","꞊Dhɛ ‑kë 'pö 'ö Yesu 'tɔ ‑yö yö ‑pɛn ‑sü ‑bha ‑dhɛ 'saadhö 'gü Galile ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","꞊Dhɛ ‑kë 'pö 'ö 'wo go Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü, 'wo dho Simɔ waa‑ Andre ‑an ‑gɔ kɔɔ. Zakö waa‑ Zan ‑wo ‑kë ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simɔ ꞊da ‑yö ‑kë ꞊waannu ꞊süë' 'ö tɔɔ 'gii‑ ‑kɔ ‑yö ‑kë ‑a ‑bha. ꞊Dhɛ 'ö Yesu ꞊ya ‑wo, 'ö 'wun 'ö ‑gban ‑a ‑bha, 'wo‑ ꞊blɛɛ ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","'Yö ꞊yɔɔn ‑a ‑bha, 'yö ‑yaa ‑kɔ ‑bha 'ö‑ ꞊luu. ‑Dhɛ do bhë ‑a ‑bha 'ö‑ ‑bha 'gii‑ ‑yö bo, 'ö ‑bhöpë ‑kpa ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","꞊Dhɛ 'ö 'yinia ‑dhɛ ꞊ya dɔ kö lan‑ ꞊ya ‑püö, mɛ ‑nu ‑wo ‑nu 'yuamɛ ꞊plëëzë waa‑ mɛ ‑nu 'ö ‑zuu yaa ‑yö ‑kë ‑an 'gü ‑an 'ka Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mɛ ‑nu 'saadhö 'wo ‑kë pö‑ bhë ‑a 'gü, ‑wo ‑nu 'kɔ 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu ‑yö 'yuamɛ ꞊plëëzë 'ö 'yua ꞊suu'‑ 'oo ꞊suu'‑ ‑yö ‑an ‑kë, ‑an ‑dhɛ bo. 'Ö ‑zuu yaa ꞊plëëzë ‑nu ‑kë mɛ ‑nu 'gü. Yaa 'we ‑a ‑bha kö ‑zuu yaa ‑nu ‑wo 'wun ꞊blɛɛ'‑, 'ö tɔɔ ‑wo Yesu dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","‑Dhɛ mɛ 'ö ‑po ‑a 'piö ‑a ‑dhiadhiö tii 'gü bhë, Yesu ‑yö ‑yö plaan, 'ö bhɔ pödhɛ ‑dhë ꞊taa', 'yö dho ‑dhɛ 'ö mɛ gbɛ 'yaa‑ ‑bha ‑a ‑bha, ꞊bhɛa' ‑dhiadhö ‑Zlan ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simɔ waa‑ ö 'bhamɛ ‑nu mɛ 'wo to, ‑wo ‑dho ‑a ꞊mɛɛ' ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","꞊Dhɛ 'ö ꞊waa‑ yö, 'wo‑ pö ‑a ‑dhë: «Mɛ 'plɛ ‑wo ü ꞊mɛɛ' ‑sü 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Yö 'dhö; 'kɛɛ ‑kwa 'dho pödhɛ ‑nu 'wo kwa 'sian 'piö ꞊nɛ ‑an 'gü 'pö kö 'aan‑ ‑Zlan ‑wo pö ‑an ‑dhë, bhii pë 'a nu ‑a ‑wun 'gü 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","'Yö Yesu ‑yö dho 'yö bɔ Galile ‑sɛ 'saadhö 'gü, 'yö 'wuntaɔsë ‑blɛɛ Zuifö ‑nu ‑dhë, ‑an ‑bha ‑bhɔkuëkɔ ‑nu 'gü, 'yö ‑zuu yaa ‑nu bho mɛ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yi do 'ka ꞊weemɛ do ‑yö ‑nu Yesu 'piö 'yö ‑lo ö kpɔn 'gü ‑a 'dhiö ꞊bhɛa' ‑sü 'ka ‑a ‑dhë, 'yö‑ pö: «N Dëmɛ, a ‑nu kö 'üën‑ n dha. ꞊Ya kë ꞊nɛ 'bha 'we ‑a ‑bha, ‑bhö n bun kë 'slööslö!» ");
INSERT INTO dnj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","'Ö‑ ‑wo 'yena ‑yö Yesu ‑kë, 'yö ö ‑kɔ paa, 'ö‑ pö ‑a ‑dhë: «A ‑we ‑a ‑bha, ü ‑dhɛ ‑yö bo!» ");
INSERT INTO dnj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","‑Dhɛ do bhë ‑a 'gü 'ö ꞊wee ‑yö go gɔɔn‑ 'ö bhë ‑a ‑bha, 'ö‑ ‑dhɛ ‑yö bo. ");
INSERT INTO dnj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ꞊ya pö ‑a ‑dhë ‑yö 'dho. 'Kɛɛ ‑yö 'wun ‑blɛɛ ‑a ‑dhë 'gbee‑ 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Ü 'to 'to ‑së 'ka: Kö ꞊kun 'ö 'wun ꞊nɛ 'ü‑ ꞊blɛɛ mɛ gbɛ ‑dhë, 'kɛɛ ‑bhö 'dho, ‑kɔ 'ü‑ 'ka zlöö ꞊nɛ 'ü‑ ‑zɔn slabhomɛ ‑dhë! 'Go mü 'ü sla‑ 'ö Moizö ‑ya ‑zɔn 'kpa bhë 'ü‑ bho kö ‑yaan ‑zɔn mɛ 'plɛ ‑dhë ꞊nɛ ü bha 'yua ꞊ya bo.» ");
INSERT INTO dnj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'Kɛɛ gɔɔn‑ bhë, 'dho 'ö‑ wo ꞊zian', 'ö 'wun 'ö Yesu ‑ya ‑kë ‑a ‑dhë bhë 'ö‑ ꞊blɛɛ ‑dhɛ 'saadhö 'gü. 'Ö‑ ‑wun 'gü Yesu yaa ö ‑de ‑zɔn plöö ‑dhɛ ‑nu gbɛ ‑bha gbɔ, 'ö to zlöö pö‑ ꞊taa ‑dhɛ ‑nu 'iin ‑dhɛ 'ö mɛ gbɛ 'yaa‑ ‑bha ‑a ‑bha. 'Ö mɛ ‑nu ‑wo go ‑dhɛ 'saadhö 'gü 'wo nu ‑a 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","꞊Dhɛ 'ö ‑dhɛkpaɔyi 'dɛdɛ ꞊ya ziö 'ö Yesu ‑yö nu 'zü Kapɛɛnaɔmë ‑pö 'gü. 'Ö mɛ ‑nu ‑wa ma ꞊nɛ ‑yö 'kɔ do 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'Ö mɛ ‑gbaa ꞊va ‑wo dho kɔɔ 'ma, 'ö‑ ‑dhɛ to zlöö kö dɔ ‑dhɛ gbɛ 'yaa 'kɔ 'dhiö plaan gbɔ. 'Ö Yesu ‑yö 'wuntaɔsë 'ö go ‑Zlan 'piö bhë ‑a ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","'Wo dho ‑dhɛ ‑ga kö mɛ 'bhaa ‑nu ꞊wa nu 'tinngmɛ do 'ö mɛ ‑yiisië ‑wa bun ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","'Kɛɛ ‑a këdhɛ gbɛ yaa kë ‑an ‑gɔ kö ‑waan dhoë Yesu 'dhiö kɔɔ, mɛ ‑gbaa ‑nu 'wo 'kɔ 'dhiö bhë ‑an ‑wun 'gü. ꞊Dhɛ ‑kë 'dhö ‑wo ‑da ‑a 'ka 'kɔ tuö 'ö 'wo 'kɔ ꞊gba 'dhi bho Yesu 'trüün 'ka ‑dhɛ gia‑ ‑bha. 'Ö ‑dhɛ 'dhi 'wo‑ bho bhë, 'wo 'tinngmɛ bhë ‑a to ö ‑wɔ ‑a ‑ta ꞊sɛɛ' ‑ta, 'wo‑ ꞊yɔɔ kɔɔ 'ma Yesu 'dhiö ‑dhɛ gia‑ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","꞊Dhɛ 'ö Yesu ꞊yaa‑ yö ꞊nɛ ‑zo yö ‑sü ‑yö ‑an ‑gɔ ꞊nɛ yö ‑mɔ ‑a ‑bha kö ‑ya ‑dhɛ bo, 'yö‑ pö 'tinngmɛ bhë ‑a ‑dhë: «Ma 'në, 'ma ziö ü bha ꞊sɔɔn yaa ‑wun ‑nu ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tɔnggɔmɛ ‑nu 'wo ‑kë ꞊yaannu ꞊süë' mü, ‑zotadhe ‑yö ‑kë ‑an 'gü ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«‑Më 'ö ‑kë 'ö gɔɔn‑ 'ö ꞊nɛ 'ö ꞊daɔn pö ‑Zlan ‑dhë ꞊nëdhö ꞊nɛɛ? Dö 'ö dho ‑mɔ ‑a ‑bha kö ‑yaan ziö mɛ ‑nu ‑bha ꞊sɔɔn yaa ‑nu ‑ta, ‑a 'ke yaa kë ‑Zlan dosɛn 'kpaan 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yesu ‑yö ‑to ‑dhɛ do bhë ‑a 'gü mü 'ö ‑an ‑bha ‑zotadhe dɔ; ꞊dhɛ ‑kë 'dhö, 'ö‑ pö ‑an ‑dhë: «‑Më ‑kë 'ö ‑zotadhe ꞊suu'‑ 'ö ꞊nɛ 'ö ‑kë ka 'gü ‑i? ");
INSERT INTO dnj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","‑A ‑pö 'tinngmɛ ‑dhɛ ‑sü: ‹'Ma ziö ü ‑bha ꞊sɔɔn yaa ‑wun ‑nu ‑ta› 'ö 'gbee‑ ‑e, 'iin ‑a pö ‑sü 'zü: ‹‑Bhö ꞊luu'‑ 'ü ü ‑bha ꞊sɛɛ' 'sü 'ü 'ta 'sü› yö 'pö 'ö 'gbee‑ ‑e? ");
INSERT INTO dnj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","'Kɛɛ a ‑dho 'slë 'bhaa kë kö 'kaan‑ ‑a dɔa ꞊nɛ ‑kɔ ‑mɔ 'wuën‑ ‑sü ‑yö ma 'a Mɛgbö 'ka n ‑gɔ 'kpongtaa zö kö 'aan‑ ziö mɛ ‑nu ‑bha ꞊sɔɔn yaa ‑nu ‑ta.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö 'tinngmɛ bhë ‑a ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«A‑ ‑pö ü ‑dhë: ‑Bhö ꞊luu'‑ 'ü ü bha ꞊sɛɛ' 'sü 'ü 'dho ü ‑gɔ kɔɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","‑Yö ‑to mɛ 'plɛ wö 'dhiö, ‑dhɛ do bhë ‑a 'gü mü 'ö ꞊luu 'yö ö bha ꞊sɛɛ' sü 'ö dho. 'Wun 'ö 'dhö bhë ‑yö mɛ 'plɛ 'te ‑tun, 'wo yö ‑Zlan 'tɔ bhɔ ‑sü ‑bha ‑a pö ‑sü 'ka ꞊nɛɛ: «Yiëë pë 'ö‑ ꞊suu'‑ 'dhö ꞊nɛ ‑a yö do!» ");
INSERT INTO dnj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu ‑yö ‑yɛ ö 'zü 'ö nu Galile 'yipuë ꞊va 'piö ꞊zian'. Mɛ ‑gbaa ꞊va ‑wo ‑nu ‑a 'piö mü 'yö ‑an ꞊daan ‑Zlan ‑wo 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","‑A ‑bha ziö ‑sü 'ka, ‑yö Alefe gbö Levi ‑yö kö ‑yö ‑ya ‑sü 'ka 'nii‑ ꞊sɔnng' ‑bho ‑a 'gü ‑kɔ 'gü ‑a yö. 'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö ꞊luu'‑ 'ü ziö n 'piö!» 'ö Levi ‑yö ꞊luu 'ö ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","꞊Dhɛ ‑kë 'pö Yesu ‑yö pë ‑bhö Levi ‑gɔ kɔɔ. 'Nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu ‑dhɛ ꞊va ‑dhɛ 'iin mɛ ‑nu 'ö ‑an 'tɔ ꞊ya ꞊siö'‑ ‑an këpë yaa ‑wun ‑nu 'gü waa‑ Yesu ‑bha ꞊guë' ‑nu ‑wo ‑kë pë ‑bhö ‑sü 'gü mü 'pö wo 'ko ꞊bhaa, 'ö tɔɔ ꞊suu'‑ yaa ‑mɛ ‑nu 'wo ‑kë ‑ziö ꞊dhia Yesu 'piö bhë ‑an ‑gwaa ‑yö ‑kë ꞊plëëzë. ");
INSERT INTO dnj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","꞊Dhɛ tɔnggɔmɛ ‑nu 'wo ‑kë Falizi ‑mɛ ‑nu ‑bha mɛ ‑nu 'ka, ‑wo Yesu ‑yö kö waa‑ mɛ ‑nu 'ö ‑an 'tɔ ꞊ya ꞊siö'‑ ‑an këpë ‑wun ‑nu 'gü, waa‑ 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu, ‑wo pë ‑bhö ‑na wo 'kuë‑, 'ö 'wo‑ ‑bha ꞊guë' ‑nu ꞊dhɛɛ' kpɔ ‑a pö ‑sü 'ka: «‑Më ‑kë 'ö ka ‑gɔmɛ waa‑ 'tɔsiömɛ ‑nu 'wo pë ‑bhö wo 'kuë‑ ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","꞊Dhɛ 'ö Yesu ‑yö ‑an ‑wo ma, 'ö‑ pö ‑an ‑dhë: «Mɛ ‑nu 'ö 'yua 'yaa ‑an ‑bha 'waa 'dho ꞊dhɔngtrɔ 'piö. 'Kɛɛ mɛ ‑nu 'ö 'yua 'dhö ‑an ‑bha ꞊nɛ 'ö ‑an ‑bha ‑wun ‑yö yö ꞊dhɔngtrɔ ‑bha. N 'ka nu mɛ ‑nu 'wo kpengdhö ‑an dha ꞊dhia, 'kɛɛ mɛ ‑nu 'ö 'waa kpengdhö 'a nu ‑an dha ꞊dhia ꞊zian'.» ");
INSERT INTO dnj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yi do 'ka Zan ‑bha ꞊guë' ‑nu waa‑ Falizi ‑mɛ ‑nu ‑wo ‑kë wo ‑bɛn 'to ꞊dhia, 'ö mɛ ‑nu ‑wo nu 'wo Yesu ꞊dhɛɛkpɔdhe ‑kë ꞊nɛɛ: «‑Më 'ö ‑kë 'ö Zan waa‑ Falizi ‑mɛ ‑nu ‑an ‑bha ꞊guë' ‑nu ‑wo wo ‑bɛn to 'ö ü ‑bha ꞊guë' ‑nu 'waa wo ‑bɛn 'to 'pö ꞊nɛ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ ꞊nɛɛ: «Ka ka ‑zo ‑ta ꞊nɛ, dhe 'sü ‑gɔɔn 'bhamɛ ‑nu ‑wo ‑dho wo ‑bɛn to, ‑a ‑bha dhe 'sü 'wlaan‑ yi 'ka, 'kɛɛ kö ‑yö ꞊tun ‑an 'piö a? ꞊Ii‑, 'kɛɛ ‑abi' i? ‑Abi'. 'Töng waa‑ dhe 'sü ‑gɔɔn 'wo dhoë‑ kë wo 'ko ꞊bhaa bhë, ‑wo ‑dho pë ‑bhö ‑kplawo, ('ö tɔɔ ‑an ꞊zuö' 'glu dhi ‑sü ‑mü). ");
INSERT INTO dnj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'Kɛɛ yi do ꞊ya dɔ, dhe ‑gɔn ꞊ya 'go ‑an 'piö, 'ö‑ yi bhë ‑a 'ka 'wo dho wo ‑bɛn toë ('ö tɔɔ ‑wo ‑dho kë 'yenazë). ");
INSERT INTO dnj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mɛ gbɛ 'yaa sɔ 'klu ‑dëü ‑wɔ sɔ zii 'ka. ꞊Ya kë 'dhö sɔ 'klu ‑dëü ‑yö ‑dho dho 'kou 'ö‑ zii 'blë ‑pin ‑yö ‑kë 'zü ꞊va. ");
INSERT INTO dnj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","'Ö 'go mü 'zü mɛ gbɛ 'yaa yɔ 'gbee‑ 'ö 'vuu 'dhö ‑da ‑na ‑a yö ꞊puu' zii 'gü. ꞊Ya kë 'dhö ‑yö ‑dho ꞊puu' bhë ‑a wü, 'ö yɔ waa‑ ꞊puu' ‑an 'plɛ 'gü ‑yö ꞊siö. Pë 'wo‑ ‑kë ꞊zian' 'ö tɔɔ yɔ 'gbee‑ yö 'wo‑ wo ꞊puu' ‑dëü 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Zuifö ‑nu ‑bha ꞊glooyi do 'ka, Yesu waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑kë ziö ꞊dhia 'blee‑ ‑bhlö do 'gü. 'Ö‑ ‑bha ꞊guë' ‑nu ‑wo yö ‑a ‑kpa ‑nu 'kan ‑sü ‑bha zian ‑gbloo 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","꞊Dhɛ 'ö Falizi ‑mɛ ‑nu ‑wo ‑an yö, 'wo‑ pö Yesu ‑dhë: «‑Më 'ö ‑kë 'ö pë 'ö kwa ‑bha tɔng ‑ya pö kö ꞊kun 'kwa‑ ‑kë ꞊glooyi 'ka bhë 'ö ü ‑bha ꞊guë' ‑nu ‑wa ‑kë ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ ꞊nɛɛ: «Pë 'ö Davidö ‑ya ‑kë 'ö ‑ya ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü kö din ‑yö yö gia‑ waa‑ ö ‑bha mɛ ‑nu ‑an kë ‑na bhë kaa‑ pö ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","‑Yö ‑kë 'dhö kö Abiataa ‑yö slabhomɛ ꞊va 'ka; 'ö Davidö ‑yö ‑da ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü 'ö ꞊bluu'‑ 'wo ‑Zlan gba ‑na ‑a 'ka bhë 'ö‑ ‑bhö. 'Kɛɛ kö kwa ‑bha tɔng ‑ya pö slabhomɛ ‑nu ‑de 'sloo ꞊nɛ 'wo dho ꞊bluu'‑ 'ö 'dhö ‑a ‑bhö, 'kɛɛ Davidö ‑ya ‑sü 'ö‑ ‑bhö 'ö‑ 'bhaa nu ö ‑bha yuökëmɛ ‑nu ‑dhë 'pö, 'wo‑ ‑bhö.» ");
INSERT INTO dnj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü ꞊nɛɛ: «‑Zlan ‑yö ꞊glooyi ‑da mɛ 'bhee‑ ‑nu ‑dhë 'kɛɛ yaa mɛ 'bhee‑ ‑nu kë ꞊glooyi ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ma 'a Mɛgbö 'ka bhë ma ‑de ꞊nɛ 'a pë 'plɛ waa‑ ꞊glooyi gia‑ 'ö bhë ‑an ‑gɔmɛ 'ka 'zü.» ");
INSERT INTO dnj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑yɛ ö 'zü 'ö nu Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü. Gɔɔn‑ do 'ö‑ ‑gbiö ‑yö ga ‑a ‑bha ‑yö ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mɛ ‑nu 'wo ‑kë mü, ‑an 'yan ‑yö ‑kë Yesu 'piö dosɛn 'ö ꞊ya kë ꞊nɛ ‑yö ‑dho ‑mɔ ‑a ‑bha kö ‑yaan gɔɔn‑ 'ö bhë ‑a ‑gbiö bo ꞊glooyi 'ka ‑a ‑wun 'gü. Bhii ‑wa 'piö kö 'wo 'wun dɔ ‑a ‑bha ꞊nɛ, ꞊ya kë 'dhö kö ꞊ya pë yaa kë, ‑an ‑bha tɔng 'gü ꞊siö' ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","'Ö Yesu ‑ya pö gɔɔn‑ 'ö‑ ‑gbiö ‑yö ga ‑a ‑bha bhë ‑a ‑dhë: «‑Bhö ꞊luu'‑ mɛ 'plɛ wö 'dhiö zö!» 'Ö gɔɔn‑ bhë 'ö ꞊luu. ");
INSERT INTO dnj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","꞊Dhɛ ꞊ya kë 'dhö, mɛ ‑nu 'wo ‑kë ‑a ‑ga ꞊dhia bhë, 'ö Yesu ‑ya pö ‑an ‑dhë: «‑Më 'ö kwa ‑bha tɔng ‑ya pö 'kwa‑ kë ꞊ɛ? 'Kwa 'wun ‑së kë ꞊glooyi 'ka, 'iin 'kwa 'wun yaa kë e? 'Kwa mɛ dha, 'iin 'kwa mɛ 'gü ꞊siö'‑ e?» 'Kɛɛ waa 'we ‑a ‑bha kö ‑waan ‑daa kë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","'Ö Yesu ‑yö ‑an ‑ta ‑ga, 'ö 'wun bhë 'ö ‑siö ‑a ‑dhë. 'Go mü 'ö‑ wö ‑yö ‑siö ꞊gbaɔnsü 'ka ‑an ‑bha ꞊zuö' yaa bhë ‑a ‑wun 'gü. ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö gɔɔn‑ bhë ‑a ‑dhë: «‑Bhö ü ‑gbiö 'po!» 'Yö ö ‑gbiö ‑po, 'ö‑ ‑gbiö to mü 'yö bo. ");
INSERT INTO dnj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","'Ö Falizi ‑mɛ ‑nu ‑wo go Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü mü 'wo yö plaan 'ö 'wo dho 'ö waa‑ Elɔdö ‑bha mɛ ‑nu 'wo ‑yakuëdhe do ‑kë, ‑kɔ 'wo dho ‑a kaa 'waan‑ Yesu zë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","꞊Dhɛ Yesu waa‑ ö bha ꞊guë' ‑nu 'wo go pö‑ bhë ‑a 'gü, ‑wo ‑dho Galile 'yipuë ꞊va 'piö ꞊zian'. 'Ö mɛ ‑gbaa ꞊va ‑wo ‑ziö ‑an 'piö: Galile ‑sɛgümɛ, Zude ‑sɛgümɛ, ");
INSERT INTO dnj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Zeluzalɛmë plöömɛ waa‑ Idume ‑sɛgümɛ, 'pian mɛ 'ö bɔ 'yiga 'wo‑ ‑dhɛ Zuudɛn ‑a ꞊zlöö ꞊zian' ‑mɛ, pödhɛ ‑nu 'wo bɔ Tii ‑pö waa‑ Sidɔn ‑pö ‑an 'piö ꞊zian' ‑mɛ, ‑an ‑dho 'kuë‑ ‑sü 'wo bhë ‑wo ‑nu Yesu 'piö, kö pë ‑nu 'ö Yesu 'dhö ‑an kë ‑na bhë kö ‑waan yö. ");
INSERT INTO dnj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë ‑wo 'yitagɔ do ꞊yɔɔn ö ‑bha, 'yaan‑ 'dho ‑a 'gü, ‑yö ‑kë 'dhö kö ꞊kun 'ö 'wo dho ꞊taa'‑ ö ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kë‑ wo 'dhö bhë, 'ö tɔɔ ꞊dhɛ 'ö mɛ ‑nu ꞊plëëzë ‑dhɛ bo ‑na 'ö mɛ ‑nu 'saadhö 'ö 'yua ‑yö ‑kë ‑an 'yënng bhɔ ꞊dhia 'wo yö wo 'ko ꞊blüü 'blü ‑sü 'gü, ‑pa ‑a 'ka ‑sü ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mɛ ‑nu 'ö ‑zuu yaa ‑yö ‑kë ‑an 'gü bhë, ꞊wa Yesu yö, ‑püö 'wo‑ wo ‑a ꞊gɛɛndhö, ‑gbla 'gbee‑ ‑sü 'ka ꞊nɛɛ: «‑Zlan Gbö ‑mü ü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Yö ꞊dhɛ ꞊ya kë 'dhö, Yesu ‑yö 'wun ‑blɛɛ ‑an ‑dhë 'gbee‑ ꞊nɛ kö ꞊kun 'ö mɛ 'ö‑ 'ka 'wo‑ ꞊blɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑dho ‑tɔn tuö, 'ö mɛ ‑nu 'ö‑ 'piö kö ‑wo ziö ö 'piö bhë 'ö ‑an ꞊dhɔɔ ‑kë, 'ö 'wo nu ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","'Ö mɛ ‑lü 'gɔɔ‑ do ö ga ꞊plɛ sü mɛ ‑nu 'wo nu bhë ‑an 'gü kö ‑waan kë ö 'piö 'ö ‑an 'tɔ kpɔ ö bha bɔmɛ ‑nu 'ka, 'yö ‑an sü kö 'yaan‑ ‑an bɔ ‑Zlan ‑wo ꞊blɛɛ' ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","'Ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu ‑an ‑dhë kö ‑waan ‑zuu yaa bhoë mɛ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mɛ 'gɔɔ‑ do ö ga ꞊plɛ 'ö ‑an sü bhë ‑an 'tɔ 'ö ꞊nɛ: Simɔ 'ö Yesu ‑ya 'tɔ kpɔ Piɛɛ 'ka, (‑a ‑gɛn 'ö tɔɔ «‑guö»,) ");
INSERT INTO dnj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zakö waa‑ ö dheglu Zan 'wo ‑kë Zebede gbö ‑nu 'ka 'ö Yesu ‑yö ‑an 'tɔ kpɔ Boanɛɛzë 'ka (‑a ‑gɛn 'ö tɔɔ «mɛ ‑nu 'wo bhɔ dha ‑bha 'gbla ‑wo ‑bha»), ");
INSERT INTO dnj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre, Filipö, Baatelemi, Matiö, Toma, Zakö 'ö ‑kë Alefe gbö 'ka, Taade, Simɔ 'wo‑ 'tɔ kpɔ 'yënngsiömɛ 'ka ö ‑bha 'sɛgɔ ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","waa‑ Zuda Ikaliɔtö 'ö Yesu dɔ ‑a yaagümɛ ‑nu kwɛɛ zlöö bhë. ");
INSERT INTO dnj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑nu kɔɔ. Mɛ ‑nu gbung ꞊va ‑wo ‑nu mü 'zü ‑dëüwo, 'ö‑ ‑dhɛ to ꞊zlöö kö 'töng ‑de gbɛ 'yaa Yesu waa‑ ö bha ꞊guë' ‑nu ‑an ‑gɔ kö ‑waan pë ‑bhö ‑dhɛ yö. ");
INSERT INTO dnj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","'Wun 'ö bhë ꞊dhɛ 'ö Yesu 'piö kɔɔmɛ ‑nu ꞊waa‑ ma, 'wo dho ‑a 'kun ꞊dhia, 'ö tɔɔ ‑wo ‑kë ‑a pö ꞊dhia 'dhö ꞊nɛɛ: «꞊Ya kë 'blɔɔnzë.» ");
INSERT INTO dnj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yi do 'ka Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu ‑wo ‑go Zeluzalɛmë plöö 'wo nu 'wo ‑lo ‑dhɛ 'ö Yesu ‑yö ‑kë ‑a ‑bha bhë ‑a 'gü, 'wo‑ pö: «Bɛɛzebilö 'ö dü 'ka bhë ‑ya 'gü.» Kö mɛ 'bhaa ‑nu ‑wa pö ‑na: «‑Zuu yaa ‑nu ‑gɔmɛ ꞊nɛ 'ö ‑kɔ ‑mɔ 'wuën‑ ‑sü nu ‑a ‑dhë 'ö ‑zuu yaa ‑nu kë ‑na ‑a 'ka bhë!» ");
INSERT INTO dnj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö ‑an ꞊dhɔɔ ‑kë 'yö 'wun ꞊blɛɛ ‑an ‑dhë, 'wun ꞊zuan' ‑zɔn ‑sü 'ka ꞊nɛɛ: «‑Yö ‑kɔklë 'ö Satan ‑yö ö ‑de ‑kë 'zü i? ");
INSERT INTO dnj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","꞊Ya kë ꞊nɛ mɛ ‑nu 'wo 'sɛgɔ do ꞊kɔɔnmɛ ‑nu 'ka, ꞊wa ‑glu gɔn wo 'kuë, 'sɛgɔ 'ö 'dhö bhë yö 'ka 'dho dho 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","'Iin 'go mü 'zü, ꞊ya kë ꞊nɛ 'kɔ do 'gü ‑mɛ ‑nu ꞊wa 'ko zë wo 'kuë, mɛ ‑nu 'wo bhë ‑an ‑bha ‑kë 'kuë‑ ‑sü yaa 'dho dho 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","‑Kɔ do 'ö bhë ‑a 'ka, ꞊ya kë ꞊nɛ Satan ꞊ya ‑glu gɔn ö 'piö ‑mɛ ‑nu 'ka kö 'gügludhe yaa ‑da ‑an ziën ꞊a? ꞊Ya kë 'dhö ‑a ‑bha ‑kɔ ‑mɔ 'wuën‑ ‑sü yaa 'dho ꞊glɔɔ gbɔ; 'kɛɛ pë dho kë 'ö tɔɔ ‑a 'tinng ‑dho yën. ");
INSERT INTO dnj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","‑A ‑ga 'ka‑ wo bhë: Dö 'ö dho ‑mɔ ‑a ‑bha kö ‑yaan ‑da gɔɔn‑ 'gügbeezë ‑gɔ kɔɔ kö ‑yaan ‑a ‑bha 'kɔɔpë ‑nu 'sü kö yaa gɔɔn‑ 'ö 'dhö bhë ‑a ‑lö ‑e? Mɛ 'ö 'gbee‑ 'ö ‑ziö ‑a 'ka ‑a ‑ta ꞊nɛ 'ö dho ‑da ‑a ‑gɔ kɔɔ.» ");
INSERT INTO dnj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","'Ö Yesu ꞊ya pö ‑an ‑dhë 'zü ꞊nɛɛ: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ‑Zlan ‑dho ziö mɛ 'bhee‑ ‑nu ‑bha këwun yaa ‑nu waa‑ ‑an ꞊blɛɛ'‑ ‑wun yaa ‑nu bhë ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","'Kɛɛ mɛ 'ö 'dhoë‑ 'wun yaa ꞊blɛɛ'‑ ‑Zuu 'slööslö ‑gɔ, ‑Zlan 'ka 'dho ziö ‑a ‑bha këwun yaa ‑nu bhë ‑a ‑ta. Bhii kö kë pë yaa 'ö dho to ‑a ‑bha bhë kö ꞊yaa‑ kë.» ");
INSERT INTO dnj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Pë 'ö ‑kë 'ö Yesu ‑ya pö ‑an ‑dhë 'dhö bhë 'ö tɔɔ ‑wo ‑kë ‑a pö ꞊dhia: «‑Zuu yaa ‑ya 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","꞊Dhɛ ꞊ya kë 'dhö, Yesu dhe waa‑ ‑a dheglu 'në gɔɔn‑ ‑nu ‑wo ‑nu; 'wo dɔ plaan, 'wo mɛ bɔ kɔɔ kö ‑yaan ‑a ꞊dhɔɔ kë. ");
INSERT INTO dnj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mɛ kpö ꞊va ‑wo ‑kë ꞊yaannu ꞊dhia Yesu ‑zü, wo 'to ‑to ‑a ‑wo ‑bha ‑sü 'ka. 'Ö 'wo‑ pö ‑a ‑dhë: «Ü‑ 'to 'to, ü dhe waa‑ ü dheglu 'në gɔɔn‑ ‑nu ‑wo plaan, ‑wa ‑pö 'ü nu!» ");
INSERT INTO dnj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Dö tɔɔ n dhe waa‑ n dheglu 'në gɔɔn‑ ‑nu ‑i?» ");
INSERT INTO dnj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","꞊Dhɛ ꞊ya kë 'dhö, 'ö mɛ ‑nu 'wo ‑kë ‑a ‑zü bhë 'ö ‑an ‑ta ‑ga, 'ö‑ pö: «‑Ka ‑dhɛ ‑ga, n dhe waa‑ n dheglu 'në gɔɔn‑ ‑nu ꞊ga 'wo ꞊nɛ! ");
INSERT INTO dnj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Bhii mɛ 'ö ‑Zlan ‑zo 'kun ‑wun kë ‑na bhë 'ö tɔɔ n dheglu 'në gɔɔn‑, n dheglu 'në dhe waa‑ n dhe.» ");
INSERT INTO dnj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu ‑yö ‑yö 'zü mɛ ‑nu ꞊daan' ‑sü ‑bha ‑Zlan ‑wo 'ka, Galile 'yipuë ꞊va 'kpong 'dhiö. ꞊Dhɛ 'ö mɛ gbung ꞊va ꞊wa ꞊nië' ‑a ‑zü, 'ö dho 'yitagɔ do 'gü 'ö ꞊yaannu, 'ö bhɔ ‑an ‑dhë ꞊taa' 'yi ꞊bhaa ꞊zian'; ‑yö kë 'dhö kö mɛ gbung ꞊va 'wo sia‑ 'yi 'kpong 'dhiö bhë ‑waan ‑a yö, 'iin kö 'wun 'ö‑ ꞊blɛɛ' ‑na bhë ‑waan ‑a ma. ");
INSERT INTO dnj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","'Yö ‑Zlan ‑wo pö ‑an ‑dhë ꞊plëëzë 'ka 'wun ꞊zuan' ‑zɔn ‑an ‑dhë ‑sü 'ka, 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«‑Ka ka 'to 'to, gɔɔn‑ do ‑yö ‑kë ‑dhö, 'yö ‑ziö 'ö dho ö bha ‑dhɛ ‑ya ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","‑Yö ‑kë ö ‑bha pëga ‑nu ‑pɛn ꞊dhia ö ‑gɔ ꞊bhlöö‑, 'ö pëga 'bhaa ‑nu ‑wo ‑püö zian ‑gbloo 'piö, 'ö ‑ma ‑nu ‑wo nu 'wo‑ ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'Ö‑ ga 'bhaa ‑nu ‑wo ‑püö gwa ‑ta, ‑dhɛ 'ö 'sɛ 'yaa mü ꞊va ‑a ‑ta. 'Wo to mü 'wo bhɔ ‑a ga ‑nu ‑bha 'dho waa‑ wo 'sɛidhö ꞊gbiin bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","'Kɛɛ ‑dhɛ 'ö lan‑ ꞊ya 'bhü ‑a ‑bha 'ö‑ 'plüün 'plɛ ‑wo ga, 'wo 'kpɛa kun, bhii 'ö tɔɔ ‑an yun yaa 'dho ꞊gbiin 'sɛidhö. ");
INSERT INTO dnj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'Ö‑ ga 'bhaa ‑nu ‑wo ‑püö ꞊blëë' 'ginngzë ‑nu ziën, 'ö ꞊blëë' 'ginngzë ‑nu ‑wo ꞊kpɛa 'ö 'wo sɔ pë 'plüün ‑sëëzë bhë ‑a ‑ta 'ö‑ ‑yöë ‑pë gbɛ yaa kë ‑dhö gbɔ. ");
INSERT INTO dnj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'Kɛɛ ‑a ga 'bhaa ‑nu ‑wo ‑püö 'sɛ ‑së 'gü, 'wo bhɔ 'wo ꞊kpɛa. 'Ö‑ 'bhaa ‑nu ‑kpa ga ‑wo ‑kë 'gɔɔ‑ ‑yaaga, 'ö‑ 'bhaa ‑nu ‑kpa ga ‑wo ‑kë 'gɔɔ‑ 'slado, 'ö‑ 'bhaa ‑nu ‑kpa ga ‑wo ‑kë ꞊këng' do.» ");
INSERT INTO dnj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑ya pö: «'Wun 'a‑ ꞊blɛɛ ꞊nɛ mɛ 'ö‑ 'wun ma ‑to 'dhö ‑dhö ‑ya ma!» ");
INSERT INTO dnj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","꞊Dhɛ Yesu ꞊ya 'dho mɛ gbung ‑nu 'wo bhë ‑an 'ka ꞊gbiin, 'ö mɛ ‑nu 'wo ‑kë ‑a 'piö waa‑ ‑a ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë, 'wo‑ ꞊dhɛɛ' kpɔ kö ‑yaan 'wun ꞊zuan' ‑nu bhë ‑an ‑gɛn pö wo ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","'Ö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ka ‑zë, 'ka 'wun ‑nu 'wo ‑bin ‑sü 'ka ‑Zlan ‑bha ‑gludëdhɛ ‑bha ‑a yö, 'kɛɛ mɛ ‑nu 'wo to, ‑wo wo ‑bha ‑ma 'wun ꞊zuan' 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‑Yö kë 'dhö kö ‑wo ‑dhɛ ‑ga ‑së 'ka 'kɛɛ ‑waan 'kun ‑dhɛ yö ꞊süë'; kö ‑wo 'wun ma, 'kɛɛ ‑waan 'kun ‑a ‑gɛn dɔ ꞊süë'. 'Ö yaa pö ‑be kö ‑wo ‑dho ꞊dhië' ‑Zlan 'piö, 'ö ‑Zlan ‑yö ‑ziö ‑an ‑bha ꞊sɔɔn yaa ‑nu ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «'Wun ꞊zuan' 'ö ꞊nɛ ꞊dhɛ 'kaa‑ ‑gɛn dɔ ꞊nɛ, kö ka ‑dho ‑a kë ꞊dhë kö ‑an mɛ ‑nu 'wo to 'kaan‑ ‑an ‑gɛn dɔ ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pëga 'ö mɛ ‑ya ‑pɛn 'ö tɔɔ ‑Zlan ‑wo. ");
INSERT INTO dnj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mɛ 'bhaa ‑nu ‑bha ‑Zlan ‑wo 'kun ‑kɔ ‑yö ‑bhɔ zian ‑gbloo 'piö ‑dhɛ, 'ö pëga ‑nu 'dhö ‑püö ‑na ‑a ‑bha bhë ‑a ‑bha. ꞊Ya kë ꞊nɛ ꞊waa‑ ma, 'ö Satan ‑yö nu 'ö ‑Zlan ‑wo mɛ 'ö ta ‑an 'gü bhë 'ö‑ bho mü. ");
INSERT INTO dnj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","‑Kɔ do bhë ‑a 'ka 'ö mɛ 'bhaa ‑nu ‑bha ‑Zlan ‑wo 'kun ‑kɔ ‑yö bhɔa pëga 'ö ‑püö 'sɛ 'ö gwa ‑ta dhuö bhë ‑a ‑bha. ꞊Dhɛ 'ö 'wo ‑Zlan ‑wo ma, ‑wo ‑to mü 'wo‑ kun ꞊zuögludhi 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'Kɛɛ 'waa wo ꞊kwaa' ‑a ‑zü, 'yaa ö yun ziö ‑an 'gü. 'Wo ꞊nëng ‑a ‑bha 'töng 'bhaa 'ka; 'kɛɛ ꞊ya kë ꞊nɛ ꞊sëëbhodhe waa‑ 'klobhɔdhe ꞊ya nu ‑an ‑ta, ‑Zlan ‑wo 'wo‑ ma bhë ‑a ‑wun 'gü, 'ö 'wo wo ꞊kwaa ‑zo yö ‑sü ‑zü 'wa 'sengdhö. ");
INSERT INTO dnj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mɛ 'bhaa ‑nu ‑bha ‑Zlan ‑wo 'kun ‑kɔ ‑yö bhɔ 'ginng 'gü ‑dhɛ 'ö pëga ‑së ‑yö ‑püö ‑a ‑bha, ‑a ‑bha. 'Wo ‑Zlan ‑wo kun, ");
INSERT INTO dnj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","'kɛɛ ‑dɔ ‑de ꞊zɔnng' ‑ta ‑sü ‑wun 'gü ‑sü ‑nu, ꞊bhɔɔpë 'ö‑ mɛ ‑püö ‑pë 'ka ‑nu waa‑ ‑ya pë ‑dhɔ 'ka ‑sü, ‑ya ‑kë zlöö 'wo sɔ ‑Zlan ‑wo bhë ‑a ‑ta 'ö ‑yö ‑a ‑bha ‑pë gbɛ yaa kë ‑dhö gbɔ. ");
INSERT INTO dnj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mɛ 'bhaa ‑nu ‑bha ‑Zlan ‑wo 'kun ‑kɔ ‑yö ‑bhɔ 'sɛ ‑së 'ö pëga ‑yö ‑püö ‑a 'gü bhë ‑a ‑bha. ꞊Wa ‑Zlan ‑wo ma, 'ö 'wo‑ kun ‑së 'ka, 'ö‑ ‑kpa ‑nu ‑wo ‑kë. 'Ö‑ 'bhaa ‑nu ‑kpa ga ‑wo ‑kë 'gɔɔ‑ ‑yaaga, 'ö‑ 'bhaa ‑nu ‑kpa ga ‑wo ‑kë 'gɔɔ‑ 'slado, 'ö‑ 'bhaa ‑nu ‑kpa ga ‑wo ‑kë ꞊këng' do.» ");
INSERT INTO dnj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'Go mü 'zü Yesu ‑ya ‑pö ‑an ‑dhë: «Mɛ ꞊ya nu ꞊labang 'kun ‑sü 'ka, 'yaa‑ dɔ 'gbonggbo ꞊löö; 'iin 'yaa‑ dɔ ꞊gba ꞊löö; 'kɛɛ ‑dhɛ 'ö‑ dɔ ‑a ‑bha 'yö kun tɔɔ ꞊labang ‑dɔ ‑a ‑ta dhuö ‑pë ‑a? ");
INSERT INTO dnj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","‑Kɔ bhë ‑a 'ka pë 'ö ‑bin ‑sü 'ka 'ö dho kun ‑yö ‑dhɛgbɛadhɛ ‑bha ‑sü 'ka 'yaa ‑dhö 'iin 'wun 'ö ‑bin ‑sü 'ka 'ö dho kun ‑yö ‑dhɛgbɛadhɛ ‑bha ‑sü 'ka 'yaa ‑dhö 'pö. 'Ö mɛ ꞊daan' ‑wo 'a ka ꞊daan' ‑na ‑a 'ka kwa 'sloo 'ka ꞊nɛ, 'ka dho ‑an ‑gɛn pö mɛ ‑nu ‑dhë ‑dhɛgbɛadhɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","'Ö ꞊ya kë ꞊nɛ mɛ ‑yö ‑dhö 'ö‑ 'wun ma ‑to 'dhö ‑dhö, kö ‑ya ma!» ");
INSERT INTO dnj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü: «‑Ka ka ‑zo kë ka ‑de 'piö, 'wun ‑nu 'ka ‑an ma ‑na ꞊nɛ ‑an ‑wun 'gü! 'Ö tɔɔ ‑Zlan ‑yö ‑dho gbaɔ ‑nu dan ka 'ka ꞊nɛ ‑kɔ ka gia‑ 'ka‑ kë ‑na ‑a 'ka bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bhii mɛ 'ö pë 'dhoë‑ ‑gɔ ꞊va ‑a 'bhaa ‑dho nu ‑a ‑dhë, 'kɛɛ mɛ 'ö pë gbɛ 'yaa‑ ‑gɔ, ‑a 'bhe 'tee ‑de 'ö‑ ‑gɔ, ‑yö ‑dho kun ‑a ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","'Ö Yesu ‑ya pö 'zü ꞊nɛɛ: «‑Zlan ‑bha ‑gludëdhɛ ‑yö ‑bhɔ pëga bhɔ ‑kɔ waa‑ ‑a ꞊kpɛa' ‑kɔ ‑bha. Gɔɔn‑ do ‑yö pëga ‑nu ‑ya ö ‑gɔ ꞊bhlöö‑. ");
INSERT INTO dnj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Gbeng ‑dhɛ ꞊ya dɔ 'yö ö bha yi zë, 'ö ‑dhɛ ꞊ya 'po 'ö ꞊luu, 'ö 'wun 'ö ‑gban pëga ‑bha bhɔ ‑kɔ ‑nu, ‑a ꞊kpɛa' ‑kɔ ‑nu ‑bha, 'ö 'yaa‑ gbɛ ‑gɛn dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Sɛ ꞊nɛ 'ö‑ ‑kë 'ö pëga ‑yö bhɔ, 'ö‑ ‑lü ‑yö ꞊kpɛa, 'yö wü, 'ö‑ ‑kpa ‑yö ga. ");
INSERT INTO dnj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","꞊Dhɛ 'ö ꞊ya ga, 'ö gɔɔn‑ 'ö ꞊nɛ 'ö ‑ya ö bha yuö ‑bha ‑an ‑kan ‑dhaanë 'ka ‑sü 'ka, bhii 'ö tɔɔ ‑a ‑bha pëga 'ö bhë ‑a 'kan ‑yi ꞊ya ‑lo.» ");
INSERT INTO dnj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","'Ö Yesu ‑ya pö 'zü: «‑Më 'ö 'kwa dho ‑Zlan ‑bha ‑gludëdhɛ ‑pö ‑zɔn ‑a 'ka ɛ? 'Iin 'wun ꞊zuan' ‑mlë 'kwa dho ‑a ‑gban ‑a ‑bha 'kwaan‑ ‑a ‑zɔn ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","‑Yö ‑bhɔ mutaadö ('ö‑ ga ‑yö bhɔ ꞊kplɔɔ' ga ‑bha bhë ‑a) ‑bha; yö ꞊nɛ 'ö tapëga ‑nu 'wo 'kpongtaa ‑an 'teezë 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'Kɛɛ ꞊ya kë ꞊nɛ ꞊waa‑ ta, 'ö ꞊kpɛa 'ö ‑kë 'too ‑lü ‑nu 'wo 'toodhɛɛdhö ‑an ꞊vaazë 'ka. 'Ö‑ ‑kɔ ‑nu ‑wo ꞊kpɛa 'wo ‑kë ꞊vava, 'ö ‑ma ‑nu 'dho ‑mɔ ‑a ‑bha kö ‑waan wo 'kɔ ‑nu dɔ ‑a ‑kɔ ‑nu ‑ta ‑a 'dhɛ 'bin ‑nu ꞊löö.» ");
INSERT INTO dnj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","‑Kɔ 'ö ꞊nɛ ‑a 'ka 'ö Yesu ‑yö ‑Zlan ‑wo pöë mɛ ‑nu ‑dhë, ‑a ‑zɔn 'wun ꞊zuan' ꞊plëëzë 'ka ‑sü 'ka ꞊nɛ ‑a mɛ ‑nu 'wo ꞊nɛ ‑an 'dhö. ‑A mɛ 'ö 'to to ‑a ‑wo ‑bha ‑mɛ ‑nu ‑kɔ dho ‑mɔ ‑a ‑gɛn ma ‑sü ‑bha ꞊nɛ 'ö‑ ‑zɔn ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","'Yaa 'wun ꞊blɛɛ'‑ 'kpaan ‑a 'ke yaa‑ kë 'wun ꞊zuan' 'ka ‑a 'ka, 'kɛɛ ꞊dhɛ waa‑ ö bha ꞊guë' ‑nu ꞊wa 'to wo 'sloo 'ka 'yö 'wun 'plɛ bho 'kou ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yi gia‑ bhë ‑a 'yinia 'ka, Yesu ‑ya ‑pö ö bha ꞊guë' ‑nu ‑dhë: «‑Kwa 'dho 'yipuë ꞊zlöö!» ");
INSERT INTO dnj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","'Ö 'wo go mɛ ‑nu gbung 'gü mü, 'ö‑ ‑bha ꞊guë' ‑nu ‑wa sü 'yitagɔ gia‑ 'ö ‑kë ‑a 'gü bhë ‑a 'gü, 'wo dho. 'Yitagɔ 'bhaa ‑nu ‑wo ‑kë ‑a 'sian 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","'Ö to mü 'buu 'gbee‑ ‑yö yö ziö ‑sü ‑bha, 'ö 'yi kpö ‑nu ‑wo yö ‑lo ‑sü ‑bha ‑an ‑bha 'yitagɔ bhë ‑a 'gü, 'ö 'yi ‑yö yö 'yitagɔ pa ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","꞊Dhɛ 'ö kë ‑na 'dhö kö Yesu ‑yö yi zë ‑sü 'gü 'yitagɔ bhë ‑a 'gü ‑a ꞊zlöö ꞊zian' ö ‑gɔ dɔ ‑sü 'ka ‑gɔ ‑dɔatapë ‑ta. 'Ö‑ ‑bha ꞊guë' ‑nu ‑wo ‑pa ‑a ‑bha 'ö 'wo‑ pö ‑a ‑dhë: «Yi Dëmɛ, ga 'kwa 'dhoë‑ ‑a wo ꞊nɛ, bhi ‑zë 'yaa ü ‑dhë pë gbɛ 'ka a?» ");
INSERT INTO dnj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","'Ö Yesu ‑yö ‑büö 'ö ꞊luu 'ö 'wun ꞊blɛɛ 'gbee‑ 'ka 'buu waa‑ 'yipuë ꞊va bhë ‑an 'ka, 'ö‑ pö: «‑Ka ka ‑ta ga, 'ka ꞊gbaannu!» ꞊Dhɛ ꞊ya kë 'dhö, 'ö 'buu ‑yö ꞊gbaannu 'ö ‑dhɛ ‑ta ‑yö ga diindhö. ");
INSERT INTO dnj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «‑Më ‑kë 'ö 'suö ‑yö ka ‑kë ‑ɛ? ‑Zo ‑yö n ‑ma ‑sü yaa kë ka ‑gɔ ꞊kun ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'Kɛɛ 'suö ꞊va ‑yö ‑kë ‑an 'gü, 'ö 'wo‑ pö wo 'ko ziën ꞊nɛɛ: «Dö ‑mü gɔɔn‑ 'ö ꞊nɛ ‑a 'ka, 'ö 'buu waa‑ 'yipuë ‑nu ‑de gia‑ 'wo 'wun ma ‑na ‑a ‑wo ‑ta ꞊nɛ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","꞊Dhɛ ꞊ya kë 'dhö, Yesu waa‑ ö bha ꞊guë' ‑nu ‑wo Galile 'yipuë ‑kan, 'wo dho 'wo ‑lo Zelazeni ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","꞊Dhɛ 'ö Yesu ‑yö go 'yitagɔ 'gü 'ö yö sia‑ 'ö to mü 'ö gɔɔn‑ do ‑yö go blɔɔn‑ ꞊taa ꞊zian' 'ö nu ‑a ‑gɔ zian‑. ");
INSERT INTO dnj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Gɔɔn‑ 'ö bhë ‑zuu yaa ‑yö ‑kë ‑a 'gü 'ö‑ këdhɛ ‑yö ‑kë blɔɔn‑ ꞊taa ‑dhɛ ‑nu ‑bha. Mɛ gbɛ ‑kɔ 'yaa ‑mɔ ‑a 'kun ‑sü ‑bha kö ‑yaan ‑a ‑lö ‑piö ꞊yɔɔ' giagia ‑de 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bhii ‑a 'bhaa ‑nu ꞊ya kë, ‑wa ‑gɛn ‑yö ‑piö 'lü 'gü, 'wo‑ ‑kɔ ‑nu ‑lö ‑piö ꞊yɔɔ' ‑nu 'ka. 'Kɛɛ ꞊yɔɔ' 'wo bhë 'yö ‑an ‑kaan 'ö ‑piö bhë 'ö‑ wü. 'Ö mɛ 'gbee‑ gbɛ yaa kë ‑dhö kö ‑yaan kuënnu. ");
INSERT INTO dnj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","'Ö yi 'saadhö ‑a 'ka, gbeng waa‑ lënng ‑yö ‑to 'gbla ‑sü ‑bha blɔɔn‑ ꞊taa ‑dhɛ ‑nu waa‑ ‑tɔn 'piö ‑dhɛ ‑nu ‑bha, kö ‑yö ö ‑de ‑gi ‑na ‑guö kpö ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Gɔɔn‑ 'ö bhë ‑yö ‑dɔ ꞊gbiin 'ö Yesu yö. 'Yö ‑bla sü 'ö nu ‑a ‑gɔ zian‑. ꞊Dhɛ 'ö ‑lo ‑a 'piö mü 'ö Yesu ‑yö 'wun ꞊blɛɛ ‑zuu yaa 'ö‑ 'gü bhë ‑a ‑dhë 'ö‑ pö: «‑Bhö 'go gɔɔn‑ 'ö ꞊nɛ ‑a 'gü!» ꞊Dhɛ ‑kë 'pö 'yö gɔɔn‑ bhë 'yö ‑lo ö kpɔn 'gü Yesu 'dhiö, 'yö ‑gbla ‑wo 'gbee‑ 'gü ꞊nɛɛ: «‑Më 'ü 'dhoë‑ ‑a kë n 'ka bhë ꞊ɛ, ‑Zlan 'ö ‑ziö pë 'plɛ ‑ta ‑a Gbö Yesu? ꞊Bhɛa'‑ 'a‑ wo ü ‑dhë ‑Zlan wö 'dhiö kö ꞊kun 'ö 'ü n 'klo‑ bhɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Ü tɔɔ dö ꞊e?» 'Ö ‑zuu yaa ‑yö bɔ gɔɔn‑ 'ö bhë ‑a 'gü, 'ö‑ pö: «N tɔɔ «Mɛ gbung ꞊va» 'ö tɔɔ yi ꞊plëëzë.» ");
INSERT INTO dnj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","'Ö ꞊bhɛa Yesu ‑dhë ꞊naazë 'ka ꞊nɛɛ: «Kö ꞊kun 'ü yi ‑kë, 'yi go 'sɛgɔ 'ö ꞊nɛ ‑a ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","‑Bhɔtii ‑gbaa ꞊va ‑wo ‑kë ‑tɔn 'piö mü 'pö, wo ‑bha ‑bhöpë ‑nu ꞊mɛɛ' ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","'Ö ‑zuu yaa ‑nu ‑wo ꞊bhɛa Yesu ‑dhë, 'wo‑ pö: «‑Bhö yi bɔ ‑bhɔtii ‑nu 'wo ꞊nɛ ‑an 'gü!» ");
INSERT INTO dnj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu ‑yö ‑we ‑a ‑bha ‑an ‑gɔ, 'ö ‑zuu yaa ‑nu ‑wo go gɔɔn‑ 'ö bhë ‑a 'gü, 'wo dho ‑bhɔtii ‑nu 'gü. 'Ö ‑bhɔtii ‑gbaa 'wo dho ‑mɔ ‑vuu ꞊plɛ ‑bha bhë ‑an ‑dho 'kuë‑ ‑sü ‑wo ꞊yɔɔ goo ‑bha 'ö ‑an 'plɛ ‑wo më 'yipuë ꞊va ꞊bhaa 'wo to yiö. ");
INSERT INTO dnj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gɔɔn‑ ‑nu 'wo kë ‑bhɔtii ‑maa kë ꞊dhia bhë 'wo ꞊duë 'wo dho 'wun ‑taɔ 'ö bhë ‑a 'ka ‑an ‑bha pödhɛ ꞊va waa‑ pödhɛ 'sɛɛn‑ ‑nu ‑bha. 'Ö mɛ ‑nu ‑wo nu kö 'waan‑ wo 'yan dɔ pë ‑nu 'wo ‑kë bhë ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","'Wo nu 'wo ‑lo Yesu 'piö kö gɔɔn‑ 'ö ‑zuu yaa ꞊plëëzë ‑nu ‑wo ‑kë ‑a 'gü bhë ‑yö mü. ‑Yö ‑kë ꞊yaannu ꞊süë' ‑potaasü 'gü kö sɔ ‑nu ‑wa ‑bha, kö 'wun ‑bho 'kou dɔ ‑sü ꞊ya kë ‑a ‑gɔ ‑së 'ka. 'Ö 'suö ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Gɔɔn‑ 'ö ‑zuu yaa ‑kë ‑a 'gü bhë waa‑ ‑bhɔtii ‑nu, pë 'ö ‑kë ‑an 'ka bhë, mɛ ‑nu 'ö ‑an 'yan dɔ ‑a ‑bha, ‑wa ‑wun ꞊blɛɛ mɛ ‑nu 'wo nu bhë ‑an ‑dhë 'pö. ");
INSERT INTO dnj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","꞊Dhɛ ꞊ya kë 'dhö, 'wo ꞊bhɛa Yesu ‑dhë kö ‑yö ziö, ‑yö 'go wo ‑gɔ 'sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","꞊Dhɛ 'ö Yesu 'dho ‑da ‑na 'yitagɔ 'gü, 'ö gɔɔn‑ 'ö ‑zuu yaa ‑nu ‑wo go ‑a 'gü bhë ‑ya pö ‑a ‑dhë 'ö 'to ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu yaa 'we ‑a ‑bha ‑a ‑gɔ, 'yö‑ pö ‑a ‑dhë: «‑Bhö 'yɛ ü 'zü, 'ü 'dho ü ‑mɛ ‑nu 'piö, 'ü pë 'ö kwa Dëmɛ ‑ya ‑kë ü ‑dhë ü 'yena yö ‑sü 'ka bhë, 'ü‑ ꞊blɛɛ'‑ ‑an ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","'Yö gɔɔn‑ bhë 'yö dho, 'ö bɔ 'sɛgɔ 'ö‑ pödhɛ 'dhö 'gɔɔ‑ do bhë ‑a 'gü, pë 'ö Yesu ‑ya ‑kë ‑a ‑dhë bhë ‑a ꞊blɛɛ' ‑sü 'ka. 'Ö mɛ ‑nu 'saadhö 'wo 'wun ‑nu 'wo bhë 'wo‑ ma, 'ö ‑an 'te ‑yö tun 'gbönggböng. ");
INSERT INTO dnj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu waa‑ ö bha ꞊guë' ‑nu ‑wo ‑da 'yitagɔ 'gü 'ö 'yipuë bhë 'wo‑ ‑kan 'zü. 'Ö mɛ ‑gbaa ꞊va ‑wo nu 'wo ꞊nië ‑a ‑zü 'yi 'kpong 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","‑Wo ‑kë ‑dhɛ bhë ‑a ‑bha, 'ö Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ꞊kɔɔnmɛ do 'wo‑ ‑dhɛ Zailusö ‑yö ꞊gbëü; 'ö‑ 'yan ‑da Yesu 'gü. ꞊Dhɛ ‑kë 'pö 'ö nu 'ö ‑lo ö kpɔn 'gü ‑a 'dhiö, ");
INSERT INTO dnj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'Ö‑ ꞊bhɛa Yesu ‑dhë kö ‑yö nu ö ‑dhë ꞊naazë 'ka ꞊nɛɛ: «N 'dhu 'ö 'dhoë‑ ga, ꞊bhɛa'‑ 'a‑ wo ü ‑dhë, ‑bhö nu 'ü ü ‑kɔ pa ‑a 'ka kö ‑a ‑dhɛ ‑yö bo, kö ‑kë ‑a 'gü ‑sü ‑yaan kë ‑a ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","꞊Dhɛ ‑kë 'pö, Yesu ‑yö ‑ziö ‑a 'piö. 'Ö mɛ ‑gbaa ꞊va ‑wo ‑to ‑a 'piö, 'ö ‑an 'dho ‑sü 'ka, 'wo ‑kë ꞊maa 'ma ꞊dhia ‑a ‑bha zian 'plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","‑Dhɛ bhë ‑a 'gü dhebɔ do 'ö fɛi yën ꞊yua' ‑ya ‑kë 'ö ‑kwɛ ‑ya kë 'gɔɔ‑ do ö ga ꞊plɛ ‑yö ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","‑A 'yënng ‑ya bhɔ ꞊duö ꞊dhɔngtrɔ ‑nu 'piö, yö do bhë 'zü, ‑ya ö bha 'wëüga ‑nu 'plɛ 'gü ꞊siö' 'kɛɛ ‑a ‑dhɛ bhë yaa bo. Pë 'ö ‑kë ꞊zian' 'ö tɔɔ 'dho 'ö‑ ‑bha 'yua ‑ya wo 'dhiö ‑kplawo. ");
INSERT INTO dnj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","‑Yö Yesu ‑wun ‑ma 'ö nu mɛ ‑nu gbung 'gü mü, 'ö pa ‑a ‑bha sɔ 'ka ‑a ꞊zlöö ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Bhii ‑yö ‑kë ‑a pö ꞊dhia ö ‑de ꞊zuö' 'piö ꞊nɛɛ: «꞊Ya kë ꞊nɛ 'ma 'pa ‑a ‑bha sɔ 'kpaan ‑de 'ka ꞊sia, n ꞊dhɛ ‑dho bo.» ");
INSERT INTO dnj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","'Ö to mü, 'ö‑ ‑bha fɛi yën ꞊yua' ‑yö ꞊gbaannu, 'ö yö gia‑ 'ö‑ ꞊tɛi' dɔ ꞊nɛ ö ‑dhɛ ꞊ya bo. ");
INSERT INTO dnj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","‑Dhɛ do bhë ‑a 'gü, Yesu ‑ya ꞊dɔa' ꞊nɛ 'gügbeedhɛ do ꞊ya 'go ö 'gü. 'Ö ꞊dhië ö ‑zü mɛ ‑gbaa ‑nu 'wo bhë ‑an ziën, 'ö‑ pö: «Dö 'ö pa ma sɔ 'ka ꞊nɛ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","'Ö‑ ‑bha ꞊guë' ‑nu ‑wa ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «Bhi gia‑, 'ü‑ ꞊tɛi' ‑dɔ ꞊nɛ, mɛ ‑gbaa ‑nu ‑wo ꞊maa 'ma ‑na ü ‑bha zian 'plɛ 'ka, 'ü ꞊dhɛɛ' kpɔ 'zü ꞊nɛ dö 'ö pa ü 'ka a?» ");
INSERT INTO dnj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'Kɛɛ Yesu ‑yö ‑dhɛ ‑ga ö ‑zü 'to ‑dhɛ ‑nu ‑bha kö mɛ 'ö pë ‑kë bhë 'yaan‑ ‑a yö. ");
INSERT INTO dnj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dhebɔ 'ö bhë 'siö‑ ‑kaan ‑a 'gluu 'ö yö ꞊zluun ‑sü ‑bha, bhii yö gia‑ ‑ya ꞊tɛi' dɔ ꞊nɛ pë 'ö ‑kë bhë ö ‑dhɛ ꞊ya bo. 'Ö nu 'ö ‑lo ö kpɔn 'gü Yesu 'dhiö, 'yö ‑kɔ 'ö ‑kë ‑a 'ka bhë 'ö‑ 'plɛ ꞊blɛɛ, ‑a ‑yö sia‑ ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","'Ö Yesu ‑ya pö ‑a ‑dhë: «N 'dhu, ü ‑bha ‑zo ‑yö n ‑ma ‑sü ꞊ya ü ‑dhɛ bo, ‑bhö 'dho ꞊zuöyagluu 'ka; 'yua bhë ö 'ka 'dho ü kë gbɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu ‑yö ‑to 'wun bhë ‑a ꞊blɛɛ' ꞊dhia, 'ö bɔmɛ ‑nu ‑wo ‑go Zailusö ‑gɔ kɔɔ, 'wo nu 'wo‑ pö ‑a ‑dhë: «Ü 'dhu 'yan ga; kö ꞊kun 'ü kwa ‑gɔmɛ bho piën‑ 'kpaan!» ");
INSERT INTO dnj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'Kɛɛ Yesu 'to yaa kë ‑an ‑wo ‑nu 'piö, 'ö‑ pö Zailusö ‑dhë: «Kö ꞊kun 'ö 'suö ‑yö ü ‑kë, ‑bhö ‑zo yö n ‑ma dosɛn!» ");
INSERT INTO dnj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","'Ö Yesu yaa 'we ‑a ‑bha mɛ gbɛ ‑gɔ kö ‑yaan ziö ö 'piö ‑a 'ke yaa kë Piɛɛ 'dhö, Zakö waa‑ ö dheglu Zan ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","'Wo dho 'wo ‑lo Zailusö ‑gɔ kɔɔ. 'Ö Yesu ‑yö ‑kpën mɛ gbung ‑nu 'wo ‑kë ‑zuö dɔ ꞊dhia waa‑ mɛ ‑nu 'wo ‑kë 'gbo ‑nu bɔ ꞊dhia ꞊gblaa 'gbla ‑sü 'ka ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","꞊Dhɛ ꞊ya ‑da kɔɔ 'ö‑ pö ‑an ‑dhë: «‑Më 'ö ‑kë 'ka ‑zuö ‑nu dɔ, 'ka 'gbo ‑nu bɔ ꞊ɛ? 'Në 'ö ꞊nɛ yaa ga, yi 'kpaan 'ö‑ zë.» ");
INSERT INTO dnj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'Ö 'wo yö ‑kaan ‑a ‑bha ‑sü 'gü. ꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö mɛ 'plɛ ‑dhë ‑wo yö plaan, 'yö 'në dë waa‑ ‑a dhe 'dhö, ‑a ‑bha ꞊guë' ‑nu ‑yaaga 'wo bhë 'dhö, 'ö ‑an sü ö 'piö, 'wo ‑da ‑wɔ ‑a 'gü ‑kɔ 'dhi mɛ 'ö 'në ꞊glöö ‑yö ‑kë ‑a 'gü bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","'Ö Yesu ‑yö ‑ya 'në 'ö bhë ‑a ‑kɔ ‑bha 'ö‑ pö Eblö ‑wo 'gü: «Talita kumi!» ‑A ‑gɛn 'ö tɔɔ: «'Nëdhezë, a‑ ‑pö ü ‑dhë, 'ü ꞊luu'‑!» ");
INSERT INTO dnj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","‑Dhɛ do bhë 'ö to ‑a ‑bha, 'ö ꞊luu 'ö yö 'ta ‑sü ‑bha. ('Nëdhezë bhë ‑a ‑kwɛ ‑yö ‑kë ꞊nɛ pë 'gɔɔ‑ do ö ga ꞊plɛ 'dhö.) ꞊Dhɛ 'wun ‑nu ꞊nɛ ꞊wa ‑an yö, 'tetundhe ꞊va ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","'Kɛɛ Yesu ‑ya ‑pö ‑an ‑dhë 'gbee‑ 'ka ꞊nɛ kö ꞊kun 'wo‑ ꞊blɛɛ mɛ gbɛ ‑dhë, 'ö‑ pö ‑a ‑bha mɛ ‑nu ‑dhë: «‑Ka ‑bhöpë nu ‑a ‑dhë, ‑ya ‑bhö!» ");
INSERT INTO dnj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","꞊Dhɛ 'ö Yesu ‑yö go ‑dhɛ bhë ‑a ‑bha, 'ö dho pödhɛ 'ö ꞊kpɛa ‑a ‑bha bhë ‑a 'gü. Waa‑ ö ‑bha ꞊guë' ‑nu ꞊nɛ 'wo dho. ");
INSERT INTO dnj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","'Ö Zuifö ‑nu ‑bha ꞊glooyi 'ka, 'yö yö ‑an ꞊daan' ‑sü ‑bha ‑Zlan ‑wo 'ka Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü. Mɛ ‑nu 'wo ‑kë wo 'to 'to ꞊dhia mü bhë, ‑an ꞊plëëzë 'te ‑tun, 'ö 'wo‑ pö: «‑Yö ‑go 'wun kë ‑kɔ ‑nu, 'kpaakpadhɛ 'yö‑ ‑gɔ, waa‑ ‑dhidhaapë ‑nu 'ö‑ kë ‑na ꞊nɛ ‑an ‑gɛn 'ka 'më ‑o! ");
INSERT INTO dnj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yö ꞊kun 'ö 'lüyanmɛ 'ka ꞊naa, 'ö‑ dhe tɔɔ Mali, 'ö‑ dheglu 'në gɔɔn‑ ‑nu ‑wo ‑kë Zakö, Zozö, Zudë, Simɔ ‑an 'ka ꞊naa. 'Go mü ‑a dheglu 'në dhoo ‑nu 'waa kwa 'piö zö ꞊a?» 'Wun ‑nu 'wo ꞊nɛ ‑an ‑wun 'gü, ‑a 'mɔnɛ waa‑ ‑naadhe ‑yö ‑më ‑an 'gü, 'ö waa 'we ‑a ‑bha kö ‑wa ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «‑Wo ‑Zlan ‑wodhiölomɛ ꞊bhlë ‑ya ‑dhɛ 'saadhö 'gü, 'kɛɛ ‑a 'kpɔ ‑pö 'gü ‑mɛ ‑nu, mɛ ‑nu 'ö wo ‑nu 'wo ‑mɛɛ ‑zë waa‑ ‑a ‑gɔ 'kɔɔmɛ ‑nu 'waa‑ ꞊bhlë ‑ya.» ");
INSERT INTO dnj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","‑A ‑wun 'gü Yesu yaa ‑dhidhaapë ‑nu kë mü ꞊va gbɔ, ‑a 'ke yaa kë ö ‑kɔ 'ö‑ 'kpa 'yuamɛ ‑nu mɛ do do ‑ta, 'ö ‑an ‑bha 'yua bo ‑a 'ka. 'Ö tɔɔ 'waa wo ‑zo yö ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yesu 'te ‑tun 'sönggö ‑sönggö ‑an ꞊zuö' ‑bha ‑kë 'glɔɔglɔ ‑sü ‑wun 'gü. ꞊Dhɛ ‑kë 'dhö Yesu ‑yö ‑bɔ pödhɛ ‑nu 'wo 'sian 'piö ‑dhɛ ‑nu ‑bha bhë ‑an 'gü ‑an ‑daan ‑Zlan ‑wo 'ka ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","'Yö ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë 'ö ‑an ꞊dhɔɔ ‑kë, 'ö ‑an dan ꞊plɛ ꞊plɛ, 'ö ‑an bɔ, 'ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu ‑an ‑dhë kö ‑waan ‑zuu yaa ‑nu kë mɛ ‑nu 'gü ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","'Kɛɛ ‑yö ‑dhio dɔ ‑an ‑dhë 'ö‑ pö: «'Ta 'ka 'dhoë‑ dho ‑a 'gü bhë, ka 'dho ‑na kö ꞊kun 'ka ꞊kwɛɛ‑ 'kpaan gbɛ sü ka ‑kɔ 'piö; ka ka ‑bha ‑gbangɔlü 'sü, ‑ka ziö! Kö ꞊kun 'ka ‑bhöpë ‑nu, 'ta 'sü ꞊bhɔɔ' ‑nu sü! 'Go mü 'ka 'wëüga ‑nu gbɛ ‑da ka ‑gɔ sɔ 'yuö‑ 'gü! ");
INSERT INTO dnj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","‑Ka ‑sakpa ‑nu yö ka ‑gɛn ‑bha, 'kɛɛ kö ꞊kun 'ka sɔ 'në ‑da 'ko ‑ta dhuö ꞊plɛ!» ");
INSERT INTO dnj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","'Ö‑ pö ‑an ‑dhë 'zü: «꞊Ya kë ꞊nɛ 'ka ‑da pödhɛ do 'gü, ‑ka 'to 'kɔ 'wo 'dhoë‑ ka ‑nia kun ‑a 'gü bhë ‑a 'gü, ‑yö 'dho ‑yö yöë ka ‑go ‑dhɛ 'ö bhë ‑a 'gü ‑yi ‑bha! ");
INSERT INTO dnj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Ö ꞊ya kë ꞊nɛ ‑dhɛ 'bhaa ‑nu 'gü, mɛ ‑nu ꞊waa‑ pö wo 'ka 'dho ka ‑nia kun 'iin wo 'to to ka ‑wo ‑bha, ‑ka 'go ‑dhɛ 'ö 'dhö ‑a 'gü; 'kɛɛ kö 'ka ka ‑gɛn ꞊kpënng kö ‑büö ‑bi ‑yö 'go ka ‑gɛn ‑nu ‑bha. ‑Yö ‑dho kë ‑an ‑zo ‑büö ‑sü 'ka ꞊nɛɛ pë mɛ 'ö 'ka nu ‑a ‑wuën bhë, 'ka‑ kë 'saadhö, 'kɛɛ 'wun yaa 'wo‑ kë ‑na bhë.» ");
INSERT INTO dnj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo dho, 'wo ‑Zlan ‑wo ꞊blɛɛ mɛ ‑nu ‑dhë ꞊nɛ ‑wo wo ꞊zuö' ꞊dhië'‑ ‑Zlan 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","'Wo ‑zuu yaa ꞊plëëzë ‑nu ‑kë mɛ ‑nu 'gü, 'ö 'wo 'yuamɛ ‑nu ꞊plëëzë ‑nu ‑dhɛ bo 'yɔn ‑yö ‑an tuö ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","‑A 'töng 'dhö bhë ‑a 'ka, ‑gludë Elɔdö ‑yö Yesu ‑wun ‑ma, bhii 'ö tɔɔ Yesu 'tɔ ‑yö ‑kë ‑pɛn ‑dhiadhö ‑dhɛ 'saadhö ‑a 'gü. Mɛ 'bhaa ‑nu ‑wo ‑kë ‑a pö ꞊dhia: «Zan Batisö 'ö go ga 'gü bhë, pë 'ö ‑kë 'ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü 'dhö ‑a ‑gɔ 'ö ‑dhidhaapë ‑nu kë ‑na bhë 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","'Kɛɛ mɛ 'bhaa ‑nu ‑wa ‑pö: «‑Zlan ‑wodhiölomɛ Eli 'ö ‑kë 'dhiö zian yö ‑mü.» 'Ö‑ mɛ 'bhaa ‑nu ‑wa pö 'zü: «‑Zlan ‑wodhiölomɛ do ‑mü ꞊nɛ ‑an mɛ ‑nu 'wo ‑kë 'dhiö bhë ‑an 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","꞊Dhɛ Elɔdö ꞊ya 'wun ‑nu 'wo ꞊nɛ ‑an ma 'ö‑ pö: «Zan Batisö 'a‑ ‑gɔ ‑kan ꞊nɛ 'ö go ga 'gü bhë!» ");
INSERT INTO dnj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pë 'ö ‑kë 'dhö bhë 'ö tɔɔ Elɔdö gia‑ ‑yö Zan ‑kun, 'ö‑ ‑lö, 'ö‑ ‑zuö ‑kansokɔ 'gü. (‑A zë ‑gɛn 'ö tɔɔ ‑më ‑ɛ?) Elɔdö ‑yö ö dheglu Filipö bɔɔ Elɔdiadö 'kun ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","'Yö Zan Batisö ‑ya ‑pö Elɔdö ‑dhë: «'Yaa ‑së kö 'ü ü dheglu bɔɔ 'kun ‑a ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","‑Naazuëdhe yaa ‑yö ‑da Elɔdiadö 'gü Zan buën‑, 'yö ‑kë ‑a këdhɛ ꞊mɛɛ' ꞊dhia kö 'ö‑ zë, 'kɛɛ yaa‑ këdhɛ gbɛ yö Elɔdö ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Elɔdö ‑yö ‑suö Zan ‑dhë, bhii 'ö tɔɔ ‑yö Zan ‑sü mɛ kpengdhö, 'ö 'slööslö ‑a 'ka; 'ö‑ ‑wun 'gü 'ö ö ‑zo ‑kë ‑a 'piö. ꞊Ya Zan ‑dhɛ, ꞊ya nu, ꞊ya ö 'to 'to ‑a 'wun ꞊blɛɛ' ‑wo ‑bha, ꞊zuö' ‑kaan 'kuë ‑sü ‑yö ‑kë ‑a ‑gɔ. 'Kɛɛ kë‑ wo 'dhö bhë ‑yö ‑kë ‑a ‑dhë ‑së kö ‑yö ö 'to 'to ‑a ‑wo ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'Ö yi Elɔdö ‑yö ‑ö bha bhɔ ‑yi 'wlaan‑ ꞊kaa', 'yö ‑kë Elɔdiadö ‑bha 'wunbɔdhɛ 'ka kö ‑yaan Zan zë. Elɔdö ‑yö ö bha yuö ‑kë ‑a 'piö ‑mɛ ‑nu, 'tɔ bhɔ ‑sü ‑zë ‑nu, 'dhasi ‑nu, 'sɛ ꞊kɔɔnmɛ ‑nu waa‑ mɛ 'tɔ ‑zë ‑nu 'wo Galile ‑sɛ 'gü ‑an ꞊dhɔɔ ‑kë 'wlaan‑ 'ö bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","'Ö Elɔdiadö 'dhu ‑yö ‑da kɔɔ 'ö yö 'tan kë ‑sü 'gü. ‑Yö ‑kë Elɔdö waa‑ mɛ ‑nu 'ö ‑an ꞊dhɔɔ ‑kë 'wlaan‑ ‑ta bhë ‑an ‑dhë ‑së. 'Ö ‑gludë Elɔdö ‑ya pö 'nëdhezë 'ö bhë ‑a ‑dhë: «Pë 'ü‑ ‑dhɔ ꞊kaa' ‑a ‑dhɛ n ‑gɔ, a ‑dho ‑a nu ü ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","'Ö Elɔdö ‑yö ö ‑wo ‑bhö ‑a ‑dhë 'ö‑ pö: «A‑ ‑zë ‑Zlan ‑dhë ꞊nɛ, pë 'ö‑ ‑dhɔ ‑yö ü ‑kë 'ü‑ ‑dhɛ n ‑gɔ, a ‑dho ‑a nu ü ‑dhë, 'kö ‑kë ꞊nɛ ma ‑gludëdhɛ këdhɛ ‑kɔ 'pian do ‑mü, a ‑dho ‑a nu ü ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","‑Dadhëü 'nëdhezë 'ö bhë ‑yö ‑yö plaan, 'ö dho 'ö 'wun bhë 'ö‑ ꞊blɛɛ ö dhe ‑dhë, 'ö‑ pö: «‑Më 'a dho ‑a ‑dhɛ ‑ɛ?» 'Ö‑ dhe ‑ya pö ‑a ‑dhë: «‑Bhö Zan Batisö ‑gɔ ‑dhɛ!» ");
INSERT INTO dnj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","꞊Dhɛ ‑kë 'pö 'ö ‑yɛ ö 'zü 'ö nu ‑bla 'ka ‑gludë 'piö 'ö pë 'ö‑ 'piö 'ö‑ ‑dhɛ ‑a ‑gɔ 'ö‑ pö: «A‑ 'piö 'piöklöözë ꞊nɛ kö 'ü‑ pö 'dhasi ‑nu ‑dhë ‑wo Zan Batisö ‑gɔ 'kan, ‑wa ‑da 'tia‑ 'gü, 'wo n gbaa ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","‑Yö ‑kë Elɔdö ‑dhë yaa, 'kɛɛ yaa ‑kɔ ‑a ‑dhë, ‑sö 'ö‑ ‑bhö mɛ ‑nu 'ö ‑an ꞊dhɔɔ kë 'wlaan‑ ‑ta bhë ‑an 'dhiö bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","'Yö ö bha 'kɔdhi ‑maa kë 'dhasi do bɔ 'wa vɛɛdhö ‑kansokɔ 'gü kö ꞊yaa‑ pö ‑a ‑dhë ꞊nɛɛ ‑yö nu Zan Batisö ‑gɔ 'ka ö ꞊dhia. 'Ö 'dhasi bhë 'ö dho ‑kansokɔ 'gü 'ma, 'ö Zan Batisö ‑gɔ ‑kan. ");
INSERT INTO dnj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'Ö‑ ‑gɔ ‑da 'tia‑ do 'gü, 'ö nuë 'ö‑ nu 'nëdhezë bhë ‑a ‑dhë, 'ö dhoë ö dhe ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","꞊Dhɛ 'ö Zan Batisö ‑bha ꞊guë' ‑nu ꞊waa‑ ma, 'wo nu 'wo‑ ꞊glöö sü 'wo dhoë 'wo‑ ‑bin. ");
INSERT INTO dnj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu ‑bha bɔmɛ ‑nu ‑wo ‑nu Yesu 'piö 'ö pë ‑nu 'wo‑ ‑kë waa‑ ‑Zlan ‑wo 'wo mɛ ‑nu ꞊daan ‑a 'ka bhë 'wo‑ 'plɛ ‑wun ꞊blɛɛ ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mɛ ‑nu ‑wo ‑kë nu ꞊dhia kö ‑an 'bhaa ‑nu ‑wo 'dho ‑na, ‑an ‑dho 'kuë‑ ‑sü ‑wo ‑kë ꞊va. 'Ö‑ ‑wun 'gü Yesu waa‑ ö bha ꞊guë' ‑nu ‑a këdhɛ ‑de yaa kë ‑an ‑gɔ kö ‑waan pë ‑bhö. 'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «‑Ka nu 'kwa 'dho ‑de 'sloo 'ka, ‑dhɛ 'kwa dho ‑potaasü yö ‑a ‑bha ‑a 'gü kö 'kaan‑ ka 'tɛɛ pa!» ");
INSERT INTO dnj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","'Ö wo ‑de 'sloo 'wo ‑da 'yitagɔ do 'gü, 'wo dho ‑dhɛ do 'wo dho ‑potaasü yö ‑a ‑bha ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","'Kɛɛ mɛdhɛvadhɛ ‑wo ‑an ‑yö kö ‑wo 'dho ‑na 'ö 'wo ‑an dɔ. 'Ö 'wo ‑bla sü 'wo goë pödhɛ ‑nu 'gü, 'wo dho 'wo ‑lo Yesu waa‑ ö bha ꞊guë' ‑nu ‑an 'dhiö, ‑dhɛ 'wo dho ‑a ‑bha bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu ‑bha ‑go 'yitagɔ 'gü ‑sü kö ‑yaan yö sia‑ ‑a 'yan ‑yö ‑da mɛ gbung ꞊va 'wo bhë ‑an ‑ta. 'Ö ‑an 'yena ‑yö ‑da ‑a ꞊zuö' 'gü, bhii 'ö tɔɔ ‑wo ‑bhɔ ‑a ‑dhë 'bhla ‑tuë ‑nu 'ö‑ ‑maakëmɛ gbɛ 'yaa ‑dhö ‑an ‑bha. 'Ö yö ‑Zlan ‑wo ꞊plëëzë ‑pö ‑an ‑dhë ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","꞊Dhɛ 'ö 'bin 'dhö 'më ‑na, 'ö Yesu ‑bha ꞊guë' ‑nu ‑wa pö ‑a ‑dhë: «'Bin ꞊ya bhɔ 'më ‑sü ‑bha 'ö ‑dhɛ 'kwa‑ ‑bha ꞊nɛ, mɛ gbɛ 'yaa zö. ");
INSERT INTO dnj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","‑Bhö ‑a pö mɛ ‑nu 'wo ꞊nɛ ‑an ‑dhë ‑wo 'dho 'kangbaa 'gü ‑dhɛ ‑nu, pödhɛ ‑nu 'wo kwa 'sian 'piö ‑dhɛ ‑nu ‑bha zö ꞊nɛ ‑an 'gü kö ‑wo wo ‑bhöpë 'dhɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","'Yö Yesu ‑ya pö ‑an ‑dhë: «Ka gia‑, ‑ka ‑bhöpë nu ‑an ‑dhë!» 'Wo Yesu ꞊dhɛɛ' kpɔ 'wo‑ pö: «Ü‑ 'piö kö 'yi 'dho 'yi dönie ꞊këng' ꞊plɛ ꞊bluu'‑ 'dhɔ 'yi nuë ‑an ꞊dhia kö ‑waan ‑bhö ‑a?» ");
INSERT INTO dnj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka 'dho 'ka ꞊kpɔɔ' 'ma kö ꞊bluu'‑ bhɛ ꞊dhë 'ö 'ma kɔ.» ꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ꞊bluu'‑ ꞊mɛɛ' 'ö 'wo ‑yɛ wo 'zü 'wo nu 'wo pö Yesu ‑dhë: «꞊Bluu'‑ bhɛ 'sɔɔdhu waa‑ 'yuö‑ ꞊plɛ 'yi ‑an yö.» ");
INSERT INTO dnj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","'Ö Yesu ‑ya pö ‑an ‑dhë ‑wa pö mɛ ‑nu 'wo bhë ‑an ‑dhë ‑wo ꞊yaannu wo kpö kpö 'ka 'kpaa‑ ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'Ö 'wo ‑an ‑ya wo ‑bhüö 'ka ‑an dan ‑sü 'ka ꞊këng' do 'iin 'gɔɔ‑ 'sɔɔdhu 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö ꞊bluu'‑ bhɛ 'sɔɔdhu waa‑ 'yuö‑ ꞊plɛ 'wo bhë ‑an sü, 'yö ö 'yan ꞊luu dhang‑ 'gü, 'yö ꞊bhɛa ‑a ‑ta, 'ö ‑Zlan zuö pö. 'Ö ꞊bluu'‑ bhë 'ö‑ ꞊kaan 'ö‑ nu ö bha ꞊guë' ‑nu ‑dhë kö ‑waan ‑glu mɛ ‑nu 'wo bhë ‑an 'ka. 'Ö ‑kɔ do bhë 'ö‑ ꞊kaa' 'yuö‑ ꞊plɛ 'wo bhë ‑an 'ka, 'ö 'wo‑ ‑glu ‑an 'ka 'zü 'töüdhö. ");
INSERT INTO dnj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mɛ 'ö ‑dhö ‑yö ö ‑bha ‑bhö, 'ö‑ 'bhaa ‑yö to. ");
INSERT INTO dnj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo dho ꞊bluu'‑ 'kluklu waa‑ 'yuö‑ 'kluklu ‑kpa 'kuë‑ ‑sü ꞊kpasɛn pa ‑sü 'gɔɔ‑ do ö ga ꞊plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Gɔɔn‑ ‑nu 'wo ‑bhöpë bhë 'wo‑ ‑bhö ‑an ‑kpa 'kuë‑ ‑sü ‑wo ‑kë ‑vuu 'sɔɔdhu 'ka, dhoo ‑nu waa‑ 'në 'sɛɛn‑ ‑nu ‑wo ‑kë mü pë ‑bhö ꞊dhia, 'kɛɛ waa ‑an ꞊dhong' gɔɔn‑ nu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë ‑wo ‑da 'yitagɔ do bhë ‑a 'gü, ‑wo 'dho ö 'dhiö 'yipuë ꞊va 'ö bhë ‑a ꞊zlöö ꞊zian' pödhɛ 'wo‑ ‑dhɛ Betesaida bhë ‑a 'gü, kö yö gia‑ 'ö ö ‑wo ‑da mɛ gbung ‑nu 'wo bhë ‑an ‑dhë kö ‑waan 'dho. ");
INSERT INTO dnj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","꞊Dhɛ 'ö ꞊wa 'kan wo 'kuë‑ ꞊ya 'go mɛ ‑nu 'wo bhë ‑an 'piö 'ö ‑da ‑tɔn do tuö kö 'yaan‑ ꞊bhɛa'‑. ");
INSERT INTO dnj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","꞊Dhɛ 'ö ‑dhɛ 'dhö trö ‑na, kö 'yitagɔ 'ö Yesu ‑bha ꞊guë' ‑nu ‑wo ‑kë ‑a 'gü bhë ꞊ya yö 'yipuë ꞊va bhë ‑a ziën, kö Yesu ‑zë ‑yö ꞊tun 'yi 'kpong 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","'Yö‑ yö ꞊nɛ ‑a ‑bha ꞊guë' ‑nu ꞊sëë'‑ ‑yö bho ‑na 'yitagɔ ‑blü ‑sü 'gü 'buu 'yö ‑kë ‑ziö ꞊dhia ‑an ‑bha bhë ‑a ‑wun 'gü. ꞊Dhɛ 'ö ꞊wa dɔ ‑dhɛ ‑bha 'po ‑sü ꞊tɛi' 'ka bhë, 'ö Yesu ‑yö dho ‑an 'piö ꞊zian' ‑ta 'yi ‑ta ‑sü 'ka, 'ö‑ ‑kë kö 'yaan‑ ziö ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","'Kɛɛ ꞊dhɛ 'ö ꞊waa‑ yö kö ‑yö 'ta ‑na 'yi ‑ta dhuö bhë 'wo‑ pö wo ꞊zuö' 'piö ꞊nɛ mɛ ‑zii ‑mü. 'Ö 'wo yö ꞊gblaa 'gbla ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bhii mɛ ‑nu 'wo‑ yö bhë ‑wo ‑yö zë ‑zë kun ‑sü ‑bha 'suö 'ka. ꞊Dhɛ ꞊ya kë 'dhö, ‑dhɛ do bhë ‑a ‑bha, 'ö Yesu ‑yö 'wun ꞊blɛɛ ‑an ‑dhë 'ö‑ pö: «‑Ka ka ‑zo ‑gban, ma ‑mü, kö ꞊kun 'ka ‑suö!» ");
INSERT INTO dnj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Ö ‑da ‑an 'piö 'yitagɔ 'gü 'ö 'buu ‑yö ꞊gbaannu. 'Ö‑ ‑bha ꞊guë' ‑nu 'dhi ‑yö pa, ");
INSERT INTO dnj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","bhii waa ‑dhidhaapë 'ö‑ ‑kë ꞊bluu'‑ ‑ta bhë ‑a ‑gɛn dɔ, 'ö tɔɔ ‑an ‑bha 'wundɔdhe ‑kɔ yaa ‑mɔ ‑a ‑bha kö ‑waan ‑a ‑gɛn dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","꞊Dhɛ ꞊wa 'yi 'kan ꞊wa ‑lo 'yipuë ꞊va bhë ‑a 'kpong 'dhiö Zenezalɛtö ‑sɛ 'gü, 'wo wo ‑bha 'yitagɔ ‑klu 'yi 'kpong 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","‑An ‑bha ‑go 'yitagɔ 'gü ‑sü 'ka, mɛ ‑nu ‑wo ‑to mü 'wo Yesu dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","'Wo ‑bla sü 'wo dhoë pödhɛ 'saadhö ‑a 'gü. 'Ö mɛ ‑nu ‑wo ‑nu wo ‑bha 'yuamɛ ‑nu 'ka ‑an ‑bun ꞊sɛɛ' 'gü ‑sü 'ka ‑dhɛ 'ö 'wo Yesu 'tɔ ma ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","'Ö ‑dhɛ 'saadhö 'ö Yesu ‑yö dho ‑a ‑bha, pödhɛ 'sɛɛn‑ ‑nu, pödhɛ ꞊vava ‑nu, 'kangbaa 'gü ‑dhɛ ‑nu, 'wo nu wo ‑bha 'yuamɛ ‑nu 'ka 'wo‑ ‑da 'dhëëdhɛ ꞊va ‑bha. ꞊Ya kë 'dhö 'wo ꞊bhɛa Yesu ‑dhë kö ‑yö 'we ‑a ‑bha wo ‑gɔ 'wo 'pa ‑a ‑bha sɔ 'to 'dhiö 'kpaan 'ka. 'Ö mɛ ‑nu mɛ 'wo pa ‑a ‑bha sɔ 'to 'dhiö 'ka 'ö ‑an ‑dhɛ ‑yö bo. ");
INSERT INTO dnj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Falizi ‑mɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ 'bhaa ‑nu 'wo go Zeluzalɛmë plöö, ‑wo ‑nu 'wo dho wo 'ko ꞊bhaa Yesu 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","'Wo‑ yö ꞊nɛ ‑a ‑bha ꞊guë' 'bhaa ‑nu 'waa wo ‑kɔ 'zlu ꞊nɛ ‑kɔ 'ö ‑an 'bhɛma ‑nu ‑bha wɔ ‑kɔ 'dhö ‑a 'ka bhë ‑a 'dhö ‑waan ꞊tun pë ‑bhö ‑na, ");
INSERT INTO dnj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","'kɛɛ kö Falizi ‑mɛ ‑nu waa‑ Zuifö mɛ ‑nu 'wo to ‑wo wo ‑kɔ ‑zlu 'papadhö ꞊nɛ ‑kɔ 'ö ‑an wɔ ‑kɔ 'dhö ‑a 'ka bhë ‑a 'dhö ‑waan ꞊tun pë ‑bhö ‑na. Bhii 'ö tɔɔ ‑wo wo ‑bha mɛ ziizii ‑nu wɔ ‑kɔ ꞊bhlë ‑ya. ");
INSERT INTO dnj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","'Ö ꞊ya kë ꞊nɛ ꞊wa 'go 'dhɔɔ 'gü ꞊wa nu, 'ö waa wo ‑kɔ 'zlu ꞊kun ꞊nɛ ‑kɔ 'wo‑ pö ‑a 'ka ‑an ‑dhë ‑a 'dhö 'waa pë ‑bhö. 'Ö ‑an ‑bha wɔ ‑kɔ ‑dhɛ ꞊va ‑dhɛ bhë, 'wo‑ ꞊bhlë ‑ya ‑an 'kun ‑sü 'ka; 'ö‑ 'bhaa ‑nu ‑wo ‑kë ‑kɔ ꞊ya kë 'wo wo ‑bha 'yi ‑mü ‑a 'gü ‑kɔɔ ‑nu, ‑an ‑bha gbɔ ‑nu, zën ‑piö gbɔ ‑nu, waa‑ ‑an ‑wɔ ‑a ‑ta ‑pë ‑nu ‑an ‑zlu ‑a 'ka bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","‑Dhɛ bhë ‑a ‑bha Falizi ‑mɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu ‑wo Yesu ꞊dhɛɛ' ‑kpɔ 'wo‑ pö: «‑Më 'ö ‑kë 'ö ü bha ꞊guë' ‑nu 'waa mɛ ꞊daan' ‑wo 'ö go kwa 'bhɛma ‑nu kwɛɛ bhë 'waa ‑a 'kun, 'ö 'waa wo ‑kɔ ‑nu 'zlu ꞊nɛ ‑kɔ 'ö 'kwa‑ wo ‑a 'ka ‑a 'dhö, 'wo pë ‑bhö ‑e?» ");
INSERT INTO dnj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","'Ö Yesu ‑ya pö ‑an ‑dhë: «Mɛ ‑nu 'yan ‑ta ‑wun kë ‑mɛ ‑nu, 'wun ‑gban ka ‑bha 'ö Ezai ‑ya ꞊blɛɛ 'dhiö bhë ‑yö 'wun gia‑ 'ka, bhii 'ö tɔɔ ‑ya ‑ya 'ö‑ pö: ‑Zlan ‑ya pö: 'Sɛgümɛ ‑nu ‑wo n ꞊bhlë ‑ya wo ‑wo 'kpaan 'ka, 'kɛɛ ‑an ꞊zuö' ‑yö n 'ka ꞊gbiin. ");
INSERT INTO dnj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","꞊Bhlëyadhe ‑nu 'wo nu ‑na ‑a 'ka n 'piö bhë, ‑a 'plɛ ‑yö 'kpaan, bhii ‑wo mɛ ‑nu ‑daan ‑wo 'ö go mɛ ‑nu dhiö ‑a 'ka ꞊nɛ, pë 'wo‑ pö ‑yö ‑go ‑Zlan 'dhi ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ka ‑Zlan ‑bha tɔng ‑nu ‑blü zian gbɛ 'ka kö 'kaan‑ mɛ ꞊daan' ‑wo ‑nu 'ö 'go ‑na mɛ ‑nu 'gü bhë ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","'Ö Yesu ‑yö ö ‑wo ‑zuöatadhe ‑kë 'zü 'ö‑ pö: «'Ka ‑Zlan ‑bha tɔng ‑da zian gbɛ 'ka kö 'kaan‑ ka ‑zo kë ka ‑de ‑bha mɛ ꞊daan' ‑wo ‑nu 'piö! ");
INSERT INTO dnj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bhii Moizö ‑ya pö: ‑Bhö ü dë waa‑ ü dhe ‑an ꞊bhlë ‑ya! 'Go mü: Mɛ 'ö 'dhoë‑ 'wun yaa ꞊blɛɛ'‑ ö dë 'iin ö dhe ‑gɔ, ‑wo ‑dho ‑a zë. ");
INSERT INTO dnj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","'Kɛɛ ka ‑zë, ka ‑pö mɛ ‑nu ‑dhë ꞊nɛ 'ö ꞊ya kë ꞊nɛ mɛ ꞊ya kë ‑dhö ꞊yaa‑ pö ö dë 'iin ö dhe ‑dhë: ‹Ma pë ‑nu 'wo n ‑gɔ, 'a dho nuë ka ‑dhë bhë, a‑ ‑ya ö ‑de ‑ta ‑Zlan ‑bha gbaɔ 'ka›, ");
INSERT INTO dnj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","'kaa 'we ‑a ‑bha ‑a ‑gɔ gbɔ ‑yö pë ‑nu nu ö dë waa‑ ö dhe ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","‑Kɔ 'ö ꞊nɛ ‑a 'ka, 'ka ‑Zlan ‑wo ꞊bhlë ꞊siö ‑a 'ka, ka ‑bha mɛ ‑nu ꞊daan' ‑wo ‑nu 'ka ka 'ko ‑dhë. 'Go mü, 'ka pë ‑dhɛ ꞊va ‑dhɛ 'ö bhɔ ‑a mɛ ‑nu 'wo ꞊nɛ ‑an ‑bha bhë, 'ka‑ ‑kë.» ");
INSERT INTO dnj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö mɛ ‑gbaa ‑nu 'wo bhë ‑an ꞊dhɔɔ ‑kë wo 'ko ꞊bhaa 'zü ‑dëüwo, 'ö‑ pö ‑an ‑dhë: «Ka 'plɛ, ‑ka ka 'to 'to n ‑ma, 'wun ꞊nɛ 'ka‑ ‑ya ka ꞊zuö' 'piö: ");
INSERT INTO dnj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","‑Bhöpë 'ö 'go ‑na plaan 'ö ‑da ‑na mɛ ‑nu 'gü bhë 'yaa mɛ ‑nu kë ꞊sɔɔnyaamɛ 'ka ‑Zlan wö 'dhiö, 'kɛɛ pë 'ö go ‑an ꞊zuö' 'gü bhë ꞊nɛ 'ö ‑an ‑kë ꞊sɔɔnyaamɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","‑Ka ka 'to 'to ‑së 'ka! 'Ö ꞊ya kë ꞊nɛ ka 'wun ma ‑to ‑yö ‑dhö kö 'wun 'a‑ ꞊blɛɛ ꞊nɛ, ‑kaa ‑gɛn ma!» ");
INSERT INTO dnj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","꞊Dhɛ Yesu ꞊ya 'go mɛ ‑nu gbung 'gü mü, ꞊ya 'dho kɔɔ, ‑a ‑bha ꞊guë' ‑nu ‑wo ‑yɔɔn ‑a ‑bha 'wo‑ ꞊dhɛɛ' kpɔ 'wun ꞊zuan' 'ö‑ ‑zɔn bhë ‑a ‑gɛn 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'Yö‑ pö ‑an ‑dhë: «Ka ‑de 'pö, ka ‑kɔ yaa ‑mɔ ‑a ‑bha kö 'kaan‑ 'wun ‑gɛn dɔ ꞊a? ‑Kaa dɔa ꞊nɛ, pë gbɛ yaa 'dho go plaan ꞊zian' kö ‑yaan ‑da mɛ 'gü ‑yaan ‑a kë ‑dhuuzë. ");
INSERT INTO dnj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bhii 'ö tɔɔ pë 'ö 'dhö bhë 'yaa 'dho ‑a ꞊zuö' 'gü, ‑dhɛ 'ö dho ‑a ‑bha ꞊zian' 'ö tɔɔ ‑a 'guu, 'ö dhoë 'blü 'dhiö.» (‑Wo ‑nu 'wo ꞊nɛ ‑an 'gü bhë ꞊nɛ 'ö Yesu ‑ya ꞊zuan' ꞊nɛ, ‑wo ‑mɔ ‑a ‑bha kö ‑wo ‑bhöpë ‑nu 'plɛ ‑bhö.) ");
INSERT INTO dnj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","'Ö‑ pö 'zü ꞊nɛɛ: «‑Bhöpë 'yaa mɛ 'bhee‑ kë ꞊sɔɔnyaamɛ 'ka 'kɛɛ 'wun 'ö 'go ‑na ‑a ꞊zuö' 'gü bhë 'ö‑ ‑kë ꞊sɔɔnyaamɛ 'ka ‑Zlan wö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bhii mɛ ꞊zuögüdhɛ ꞊nɛ 'ö ‑zotadhe yaa 'ö mɛ ‑blü ‑da dhe 'piö ‑sü, 'nuëbɔ 'kun ‑sü, ꞊mlaabɔ 'kun ‑sü, ꞊kwaan ‑sü waa‑ mɛ zë ‑sü ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Yö ꞊nɛ 'ö nu 'zü, dheagɔmɛ ‑bha dhe 'kpɛɛkpɛ ꞊mɛɛ' ‑sü, gwaandhe ‑bha gɔɔn‑ 'kpɛɛkpɛ ꞊mɛɛ' ‑sü, ‑ya mɛ gbɛ ‑bha pë ‑dhɔ 'ka ‑sü, këpë yaa kë ‑sü, mɛ ‑püö ‑sü, 'wun ‑dɔ 'gü ‑sü, ꞊druɛi kë ‑sü, 'wun yaa ‑blɛɛ mɛ ‑gɔ ‑sü, ‑de ‑sü ꞊va kë ‑sü waa‑ ‑kë 'yaa 'wun dɔ ‑mɛ 'ka ‑sü 'wo bhë 'saadhö ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pë yaa ‑nu 'töüdhö 'wo bhë ‑wo ‑go mɛ ‑nu ꞊zuö' 'gü, 'ö 'wo mɛ ‑kë ꞊sɔɔnyaamɛ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑go mü 'ö dho Tii ‑pö ‑nu 'gü. ꞊Dhɛ ꞊ya 'dho ꞊ya ‑lo 'ma, ‑yö ‑da 'kɔ do 'gü, bhii yaa kë ‑a 'piö kö mɛ gbɛ ‑ya ꞊tɛi' dɔ ꞊nɛ ö mü. 'Kɛɛ ‑a këdhɛ gbɛ yaa kë ‑dhö kö ‑a ‑dhɛ ‑yö ‑bin. ");
INSERT INTO dnj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bhii 'ö tɔɔ dhebɔ do 'ö ‑zuu yaa ‑yö ‑kë ‑a 'dhu 'gü, ‑yö Yesu ‑wun ‑ma. 'Ö nu 'ö ‑gblü Yesu 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Dhebɔ 'ö bhë yaa kë Izlaɛlö ‑sɛ 'gü 'në 'ka, ‑yö ‑go Fenisi, Sili ‑sɛ 'gü; 'yö ꞊bhɛa Yesu ‑dhë kö ‑yaan ‑zuu yaa bho ö 'dhu 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'Yö Yesu ‑yö 'wun ꞊zuan' ‑zɔn dhebɔ bhë ‑a ‑dhë ꞊nɛɛ: «‑Bhö ü ꞊kwaa' 'në ‑nu ‑zü ꞊kun, ‑wo ‑bhöpë ‑bhö, bhii 'yaa ‑së kö ‑wo 'në ‑nu ‑bhöpë 'sü ‑an 'dhiö ‑wa nu gbɛn‑ ‑nu ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'Ö dhebɔ bhë 'ö‑ pö Yesu ‑dhë: «'Wun gia‑ ‑mü, n ‑Gɔmɛ, 'kɛɛ ꞊ya kë gbɛn‑ ‑nu 'wo pë ‑bhö ‑a ‑ta ꞊gba ꞊löö bhë, 'në ‑nu ‑bhöpë 'pee ‑nu 'wo ‑püö ‑na sia‑ bhë ꞊ya kë ‑wa ‑bhö.» ");
INSERT INTO dnj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑A ‑daa 'ü‑ ‑kë bhë ‑a ‑wun 'gü, ‑bhö 'yɛ ü 'zü 'ü 'dho ü ‑gɔ kɔɔ, ‑zuu yaa ꞊ya 'go ü 'dhu 'gü 'saadhö.» ");
INSERT INTO dnj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","꞊Dhɛ 'ö ‑yɛ ö 'zü 'ö dho ö ‑gɔ kɔɔ, 'yö ö 'dhu yö kö ‑yö ꞊waannu ꞊süë', kö ‑zuu yaa ꞊ya 'go ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu ‑yö ‑go Tii ‑sɛ 'gü, 'ö bɔ Sidɔn ‑sɛ 'gü, 'ö nu Galile 'yipuë 'piö ꞊zian' ‑bɔ pödhɛ 'gɔɔ‑ do ‑sɛ 'gü ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","‑Wo ‑nu gɔɔn‑ do 'ö‑ 'to 'dhö ta ‑sü 'ka, 'go mü 'ö 'yaa 'we ‑a 'ka ‑a ꞊dhia. 'Wo ꞊bhɛa ‑a ‑dhë kö ‑yö ö ‑kɔ kpa ‑a ‑ta kö ‑yaan ‑a ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö bhɔ ‑a 'ka mɛ gbung 'wo bhë ‑an ‑dhë ꞊taa' wo ‑de 'sloo 'ka, 'yö ö ‑kɔnëga ꞊plɛ ‑sɔ ‑a 'to ꞊plɛ bhë ‑a 'gü, 'go mü 'ö 'dhee ‑suö ö ‑kɔnëga ‑bha 'ö‑ pa ‑a nɛ‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑dhɛ ‑ga dhang‑ 'gü ꞊bhɛa' ‑sü 'ka. 'Yö ö ‑zo ta ‑a ‑bha 'yena ‑wo 'gü 'ö ö ‑zo ‑lo, 'ö‑ pö: «Efata!» (‑A ‑gɛn 'ö tɔɔ: «‑Bhö 'po!») ");
INSERT INTO dnj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","‑Dhɛ do bhë ‑a ‑bha 'ö gɔɔn‑ 'ö bhë 'ö‑ 'to ‑nu ‑wo ‑po, 'ö‑ nɛ‑ gën ‑yö ‑kan, 'ö yö 'wun ‑nu ꞊blɛɛ' ‑sü ‑bha ‑së 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","꞊Dhɛ 'ö ꞊wa 'yɛ wo 'zü ꞊wa nu, mɛ ‑gbaa ‑nu 'wo sia‑ ‑an 'piö 'ö Yesu ‑ya pö ‑an 'plɛ ‑dhë kö ꞊kun 'wo 'wun ‑nu 'wo bhë 'wo‑ ꞊blɛɛ mɛ gbɛ ‑dhë. 'Kɛɛ 'wun bhë mɛ 'bha ‑nu ‑wa ꞊blɛɛ mɛ ‑nu ‑dhë. ('Wun ‑nu 'wo bhë ‑an ‑bindhɛ gbɛ yaa kë ‑dhö) 'ö bhii ‑ya pö ‑na kö ꞊kun 'ka‑ ꞊blɛɛ' kö ‑wa ꞊blɛɛ' ‑na. ");
INSERT INTO dnj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","'Tetundhe ꞊va ‑yö ‑kë ‑an ‑gɔ 'wo‑ pö: «Pë ‑nu 'saadhö 'ö‑ kë ‑na ꞊nɛ ‑a 'plɛ ꞊wo ‑së! ‑Yö mɛ ‑nu ‑de gia‑ 'ö ‑an 'to 'dhö ta ‑sü 'ka ‑an 'to 'dhi ‑po, 'ö mɛ ‑nu 'waa 'we 'ö 'wo ‑we!» ");
INSERT INTO dnj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","‑A 'töng 'dhö bhë ‑a 'ka, mɛ ‑gbaa ꞊va ‑wo ‑nu 'zü ‑dëüwo, 'wo ꞊nië Yesu ‑zü. ꞊Dhɛ 'ö ‑kë ꞊nɛ, ‑bhöpë gbɛ 'yaa kë ‑an ‑gɔ bhë, 'ö Yesu ‑yö ö ‑bha ꞊guë' ‑nu ꞊dhɔɔ ‑kë, 'ö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Mɛ ‑nu 'wo ꞊nɛ, ‑an 'yena ‑yö n kë ‑na, bhii ‑dhɛkpaɔyi kë ‑yaaga ‑naa 'ö ꞊nɛ, 'wo n 'piö zö, 'ö ‑bhöpë gbɛ 'yaa ‑an ‑gɔ gbɔ. ");
INSERT INTO dnj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","꞊Ya kë ꞊nɛ ‑bhöpë gbɛ yaa kë ‑an ‑gɔ ꞊sia, 'ö ꞊wa 'to din 'ö ꞊nɛ ‑a 'ka, 'ma‑ pö ‑an ‑dhë ‑wo 'dho wo ꞊plöö ‑dhɛ ‑nu ‑bha, ‑wo ‑dho ‑püö zian ‑gbloo ‑nu 'piö, kë 'ö ꞊waa‑ wo 'tëëtë bhë ‑a ‑wun 'gü, bhii mɛ 'bhaa ‑nu ‑wo ‑go 'ma ꞊gbiin.» ");
INSERT INTO dnj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","'Ö‑ ‑bha ꞊guë' ‑nu ‑wa pö ‑a ‑dhë: «Kwa ‑dho go mɛ ‑nu 'wo ꞊nɛ 'töüdhö ‑an ‑bhöpë 'ka 'më, ‑dhɛ 'ö mɛ gbɛ 'yaa‑ ‑bha zö ꞊nɛ ‑a 'gü i?» ");
INSERT INTO dnj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","'Ö Yesu ‑yö ‑an ꞊dhɛɛkpɔdhe ‑kë ꞊nɛɛ: «꞊Bluu'‑ bhɛ ꞊dhë 'ö ka ‑gɔ ‑ɛ?» 'Wo‑ pö ‑a ‑dhë: «꞊Bluu'‑ bhɛ 'slaplɛ.» ");
INSERT INTO dnj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'Ö‑ pö mɛ ‑gbaa ‑nu 'wo bhë ‑an ‑dhë ‑wo ꞊yaannu sia‑. 'Go mü 'ö ꞊bluu'‑ bhɛ 'slaplɛ bhë 'ö‑ sü, 'ö ‑Zlan zuö pö ‑a ‑ta, 'ö‑ ꞊kaan, 'ö‑ nu ö ‑bha ꞊guë' ‑nu ‑dhë kö ‑waan ‑glu mɛ ‑nu 'wo bhë ‑an 'ka. 'Ö‑ ‑bha ꞊guë' ‑nu ‑wa ‑glu ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","'Yuö‑ 'në 'sɛɛn‑ 'bhaa ‑nu ‑wo ‑kë ‑an ‑gɔ mü. ꞊Dhɛ 'ö Yesu ‑yö ‑Zlan zuö pö ‑a ‑ta, 'ö‑ pö ö bha ꞊guë' ‑nu ‑dhë, ‑wa ‑glu mɛ ‑nu 'wo bhë ‑an 'ka 'zü. ");
INSERT INTO dnj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mɛ 'ö ‑dhö ‑yö pë ‑bhö, 'ö‑ 'bhaa ‑yö to, 'ö‑ ‑bha ꞊guë' ‑nu ‑wo dho ‑bhöpë 'kluklu ‑nu 'wo to bhë ‑an ꞊kpasɛn pa ‑sü 'slaplɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mɛ ‑nu 'wo ‑kë mü ‑wo ‑mɔ mɛ ‑lü ‑vuu ‑yiisië ‑bha. ꞊Dhɛ ꞊wa yën 'ö Yesu ‑ya pö ‑an ‑dhë ‑wo 'dho. ");
INSERT INTO dnj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","‑Dhɛ bhë ꞊nɛ 'wo to ‑a ‑bha, 'ö Yesu waa‑ ö bha ꞊guë' ‑nu 'wo ‑da ‑a ‑bha 'yitagɔ 'gü, 'wo dho Dalimanuta ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Falizi ‑mɛ ‑nu ‑wo ‑nu kö 'waan‑ 'slë 'kan Yesu ‑gɔ, 'ö waa‑ Yesu ‑nu 'wo yö 'wun ‑blɛɛ wo 'ko ‑dhë ‑sü 'gü mü, 'wo‑ ‑dhɛ Yesu ‑gɔ kö ‑yö ‑dhidhaapë do 'ö dho ‑a ‑zɔn ꞊nɛ ‑a ‑bha ‑kɔ ‑mɔ 'wun ‑bha ‑sü ‑yö ‑go ‑Zlan 'piö, ‑a kë. ");
INSERT INTO dnj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","'Ö Yesu ‑yö ö ‑zo ‑lo 'piö ꞊gbiinzë 'ka 'ö‑ pö: «‑Më ‑de 'ö ‑kë 'ö ꞊dɛɛ ꞊nɛ ‑a 'gü ‑mɛ ‑nu 'wo‑ 'piö kö 'wo ‑dhidhaapë do yö ꞊nɛ ꞊ɛ? A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: ‑Dhidhaapë do gbɛ 'ka 'dho kë ‑an ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","꞊Dhɛ ꞊ya kë 'dhö, 'ö go ‑an 'piö mü, 'ö ‑da 'yitagɔ 'gü, 'ö dho 'yipuë ꞊va bhë ‑a ꞊zlöö ꞊zian' 'pian gbɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","'Kɛɛ kë‑ wo 'dhö bhë, Yesu ‑bha ꞊guë' ‑nu ‑zlö ‑yö ‑trö ꞊bluu'‑ ‑nu 'sü ‑sü ‑bha. ‑A bhɛ do 'kpaan ꞊nɛ 'ö ‑kë ‑an ‑gɔ 'yitagɔ 'gü mü. ");
INSERT INTO dnj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka kë 'slë 'ka, 'ka ka ‑zo kë ka ‑de 'piö Falizi ‑mɛ ‑nu waa‑ Elɔdö ‑an ‑bha ꞊bluubhɛɛpë ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","'Ö‑ ‑bha ꞊guë' ‑nu ‑wa pö wo 'ko ‑nu ‑dhë ꞊nɛɛ: «꞊Dhɛ 'ö ‑kë ꞊nɛ kwaa ꞊bluu'‑ 'sü bhë, 'yö‑ pö ‑na 'dhö bhë.» ");
INSERT INTO dnj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","꞊Dhɛ Yesu ꞊ya 'wun 'wo‑ ꞊blɛɛ' ‑na bhë ‑a ma, 'ö‑ pö ‑an ‑dhë: «‑Më 'ö ‑kë 'ka‑ pö ꞊dhɛ ‑kë ꞊nɛ ꞊bluu'‑ kaa‑ 'sü bhë, yö ‑mü ‑i? Kaa 'wun ‑nu 'a‑ ꞊blɛɛ ka ‑dhë bhë, ‑an ‑gɛn dɔ ꞊kun ꞊a? Kë‑ wo ka ‑gɔ ꞊nɛ, kë 'pö ka ‑bha 'wunbhokoudɔdhe 'dhi ‑ya wo ta ‑sü 'ka bhë ee? ");
INSERT INTO dnj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ka 'yan ‑nu ‑wo ‑dhö; ‑yö ‑kë ꞊dhë 'ö 'kaa ‑dhɛ yö ꞊nɛɛ, 'ö ka 'to ‑nu 'dho ‑dhö, 'ö 'kaa 'wun ma ꞊nɛɛ? Ka ‑zo 'yaa ‑büö ꞊nɛ ");
INSERT INTO dnj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","꞊dhɛ 'ma ꞊bluu'‑ bhɛ 'sɔɔdhu ꞊kaan' gɔɔn‑ ‑nu ‑vuu 'sɔɔdhu 'ka ‑waan ‑an ‑bhö, ‑a 'kluklu ‑nu ‑wo to ‑a ꞊kpasɛn pa ‑sü ꞊dhë 'ö 'ka dhoë ꞊ɛ?» 'Wo‑ ‑daa ‑kë 'wo‑ pö: «‑A ꞊kpasɛn 'gɔɔ‑ do ö ga ꞊plɛ.» ");
INSERT INTO dnj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","'Ö Yesu ‑ya pö 'zü: «꞊Dhɛ 'ma ꞊bluu'‑ bhɛ 'slaplɛ ꞊kaan' gɔɔn‑ ‑nu ‑vuu ‑yiisië 'ka, ‑a 'kluklu ‑nu 'wo to ‑a ꞊kpasɛn pa ‑sü ꞊dhë 'ka dhoë ꞊ɛ?» 'Wo‑ ‑daa ‑kë 'zü 'wo‑ pö: «‑A ꞊kpasɛn 'slaplɛ.» ");
INSERT INTO dnj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «'Ö ꞊dhɛ 'ö 'kwa yö më 'ö 'ka‑ pö ꞊dhɛ ‑kë ꞊nɛ ꞊bluu'‑ kaa‑ 'sü bhë, yö ‑mü ‑i?» ");
INSERT INTO dnj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","‑Wo ‑dho 'wo ‑lo Betesaida. ‑Dhɛ bhë ‑a 'gü, 'ö mɛ ‑nu ‑wo nu 'yënngtiimɛ do 'ka Yesu ꞊dhia, 'ö 'wo ꞊bhɛa ‑a ‑dhë kö ‑yaan 'pa ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","'Ö gɔɔn‑ 'yënngtiizë 'ö bhë 'ö Yesu ‑yö ‑yaa ‑kɔ ‑bha, 'ö dhoë pö‑ ꞊taa ‑bha. 'Yö ö 'dhee ‑kan ‑a 'yënngdhö, 'go mü 'yö ö ‑kɔ ‑kpa ‑a ‑ta ‑a ꞊dhɛɛ' 'kpɔ ‑sü 'ka ꞊nɛɛ: «Ü pë ‑nu ‑yö ‑a?» ");
INSERT INTO dnj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","'Ö gɔɔn‑ 'yënngtiizë 'ö ꞊sia bhë, 'yö ö 'yan po 'ö‑ pö: «A mɛ ‑nu ‑yö ꞊nɛ 'lü ‑nu 'dhö, 'kɛɛ pë 'ö ‑kë tɔɔ ‑wo 'ta ‑sü.» ");
INSERT INTO dnj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","'Ö Yesu ‑yö ö ‑kɔ kpa 'zü ‑dëüwo gɔɔn‑ 'ö bhë ‑a 'yan ‑ta. ꞊Dhɛ 'ö ꞊ya ö ‑kɔ bho mü, 'ö gɔɔn‑ 'ö bhë 'ö ‑dhɛ ‑ga ö 'dhiö 'wa vɛɛdhö, 'ö‑ 'yan ‑yö bo, 'ö ‑dhɛ yö ‑së 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","'Ö Yesu ‑ya ‑pö ‑a ‑dhë: «‑Bhö 'dho ü ‑gɔ kɔɔ vɛɛdhö kö ꞊kun 'ü dho plöö ꞊zian'.» ");
INSERT INTO dnj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu waa‑ ö bha ꞊guë' ‑nu ‑wo ‑dho Filipö Sezale ‑pö ‑nu 'gü. ‑Wo ‑kë 'dho ꞊dhia, 'ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «Mɛ ‑nu ‑wa ‑pö dö ‑mü n 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","'Wo‑ ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «Mɛ 'bhaa ‑nu ‑wa pö Zan Batisö ‑mü ü 'ka, mɛ 'bhaa ‑nu ‑wa pö 'zü Eli ‑mü ü 'ka, mɛ 'bhaa ‑nu ‑wa pö ‑Zlan ‑wodhiölomɛ do 'bhaa 'ö ‑kë 'dhiö ꞊zian' ‑yö ‑mü ü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","'Ö Yesu ‑ya pö ‑an ‑dhë: «Ka ‑de 'pö, ka‑ ‑pö dö ‑mü n 'ka ɛ?» 'Ö Piɛɛ ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «Ü ‑Zlan ‑bha ‑Yamɛ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë 'gbee‑ 'ka ꞊nɛɛ kö ꞊kun pë 'ö Piɛɛ ‑ya ꞊blɛɛ 'ö ‑gban ö ‑bha bhë, 'wo‑ ꞊blɛɛ mɛ gbɛ ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑yö ‑zobüödhe ‑nu ö bha ꞊guë' ‑nu ‑dhë ‑sü ‑bha 'ö‑ pö: «Pë dho kë 'ö tɔɔ ma 'a Mɛgbö 'ka, n 'klo‑ ‑dho bhɔ ꞊va. ‑A ‑gɛn 'ö tɔɔ mɛ ziizii ‑nu, slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa 'dho we n ‑wun ‑bha. ‑A ‑wun 'gü, ‑wo ‑dho n zë. ‑A ‑dhɛkpaɔyi kë ‑yaaga bhë 'a dho go ga 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","‑Yö 'wun ‑nu 'wo ꞊nɛ ‑a ‑blɛɛ ‑an ‑dhë, 'ö bɔa plöö ö ꞊gɛan'. ꞊Dhɛ ꞊ya kë 'dhö, Piɛɛ ‑ya ‑dhɛ ö 'sloo 'ka, 'ö‑ pö ‑a ‑dhë: «Kö ꞊kun 'ö 'wun ꞊suu'‑ 'ö ꞊nɛ 'ü‑ ꞊blɛɛ!» ");
INSERT INTO dnj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","'Kɛɛ Yesu ‑yö ‑dhië ö ‑zü, 'yö ö bha ꞊guë' ‑nu ‑ta ‑ga, 'go mü 'ö‑ pö Piɛɛ ‑dhë 'gbee‑ 'ka ꞊nɛɛ: «‑Bhö yö 'ma 'ü 'go n 'sɔɔ, Satan, bhii ü ‑bha ‑zotadhe 'yaa kë ꞊nɛ ‑Zlan ‑bha 'dhö, 'kɛɛ ‑yö ‑kë ꞊nɛ mɛ 'bhee‑ ‑bha ‑zotadhe 'dhö ꞊zian'!» ");
INSERT INTO dnj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö mɛ ‑gbaa ‑nu waa‑ ö bha ꞊guë' ‑nu ꞊dhɔɔ ‑kë, 'ö‑ pö ‑an ‑dhë: «꞊Ya kë ꞊nɛ mɛ ‑ya 'piö kö ‑yö ziö n 'piö, kö ‑yö ö bo ‑zo ‑ta ö ‑de ‑wun 'gü ‑sü 'ka, yö do bhë 'zü, ‑yö ꞊wa ‑bhö ꞊nɛ ‑kɔ 'a dho ꞊wa ‑bhö ‑a 'ka bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bhii mɛ 'ö‑ 'piö kö 'yö ‑kë ‑a 'gü ‑sü kë ö ꞊deë', yö 'ka 'dho ‑a yö, 'kɛɛ mɛ 'ö 'dhoë‑ ö ‑zo bho ö ‑de ‑wun 'piö n ‑wun waa‑ 'wuntaɔsë ‑an ‑wun 'gü, ‑yö ‑dho ‑kë ‑a 'gü ‑sü yö. ");
INSERT INTO dnj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","‑Yö ‑dho kë ‑së mɛ 'bhee‑ ‑bha 'ka kö ‑yö 'kpongtaapë 'plɛ yö, kö ‑a nii ‑zë 'gü ꞊ya ꞊siö'‑ ‑a? ");
INSERT INTO dnj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","‑Më 'wo dho ‑mɔ ‑a ‑bha kö ‑waan ‑a nu mɛ 'bhee‑ ‑dhë kö ‑yaan ö nii ‑ta bɔ ‑a 'ka ɛ? ");
INSERT INTO dnj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","'Ö mɛ ꞊ya lë‑ kë n ‑gɔ, 'iin n ‑wo ‑nu ‑gɔ, ꞊dɛɛ ꞊nɛ ‑a 'gü ‑mɛ ‑nu 'waa 'to wo ‑wo ‑ta ‑Zlan ‑dhë 'ö 'wo 'wun yaakëmɛ ‑nu 'ka bhë ‑an ziën, ꞊ya kë 'dhö 'pö, ma Mɛgbö ‑de 'pö, yi 'a dho nuë n Dë ‑bha 'tɔbhɔdhe, waa‑ ‑a ‑bha bɔmɛ ‑nu 'slööslö ‑an 'ka, a ‑dho lë‑ kë mɛ bhë ‑a ‑dhë 'pö.» ");
INSERT INTO dnj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü: «A‑ ‑pö ka ‑dhë 'wun giagia 'ka ꞊nɛɛ: Mɛ 'bhaa ‑nu ‑wo ka 'piö zö, waa 'dho ga kö ‑an 'yan yaa ‑kpën ‑Zlan ‑bha ‑gludëdhɛ këdhɛpö ‑bha ‑nu 'piigbeedhɛ 'ka ‑sü ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","꞊Dhɛ ‑dhɛkpaɔyi 'slado ꞊ya ziö, 'ö Yesu ‑yö Piɛɛ 'dhö, Zakö 'dhö, waa‑ Zan, 'ö ‑an sü ö 'piö, 'wo dho ‑tɔn do ꞊gbiin tuö wo 'sloo 'ka. 'Ö Yesu ‑yö ‑dhië bun gbɛ 'gü ‑an wö 'dhiö mü, ");
INSERT INTO dnj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'ö‑ ‑bha sɔ ‑nu ‑wo ‑kë 'puu; ‑a ‑bha ‑kë 'puu ‑sü bhë, mɛ ‑kɔ ‑mɔa ‑pë 'yaa ‑mü 'kpongtaa zö kö ‑yaan sɔ 'zlu ‑yaan bhɔ ꞊nɛ ‑kɔ bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","'Ö to mü, ꞊guë' ‑nu ‑yaaga 'wo bhë, 'wo Eli waa‑ Moizö ‑an yö kö waa‑ Yesu ‑nu ‑wo 'wun ꞊blɛɛ' ‑na wo 'ko ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","'Ö Piɛɛ ‑ya pö Yesu ‑dhë: «N ‑Gɔmɛ, ꞊yö ‑së kö 'kwa to zö. ‑Kwa sɔ 'kɔ ‑yaaga dɔ, ü ‑bha ‑yö kë do, Moizö ‑bha ‑yö kë do, Eli ‑bha ‑yö kë do.» ");
INSERT INTO dnj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pë 'ö dhoë‑ ‑a ꞊blɛɛ'‑ yaa‑ dɔ ö ‑de ‑gɔ, bhii ꞊guë' ‑nu ꞊plɛ 'wo to waa‑ yö gia‑, 'siö ꞊va ‑yö ‑kan ‑an 'gluu. ");
INSERT INTO dnj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","'Ö dha kpö do ‑yö nu, 'ö‑ 'bin ‑yö sɔ ‑an ‑ta. 'Ö ‑wo do ‑yö bɔ dha kpö bhë ‑a 'gü 'ö ‑we ꞊nɛɛ: «Mɛ 'ö ꞊nɛ 'ö tɔɔ n Gbö (do 'ö n ‑gɔ) 'ö‑ ‑dhɔ ‑yö n ‑kë ꞊duö. ‑Ka ka 'to 'to ‑a ‑wo ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","‑Dhɛ do bhë ‑a 'gü, ö ꞊guë' ‑nu 'wo bhë 'wo ‑dhɛ ‑ga wo ‑zü 'to; waa mɛ gbɛ yö gbɔ, ‑a 'ke yaa kë Yesu ‑de 'sloo 'ka wo 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","‑Wo ‑kë 'go ꞊dhia ‑tɔn bhë ‑a tuö kö ‑wo ꞊yɔɔ' ‑na, 'ö Yesu ‑ya pö ‑an ‑dhë: «Kö ꞊kun 'ö pë ‑nu 'ka ‑an yö ꞊nɛ, 'ka‑ ꞊blɛɛ mɛ gbɛ ‑dhë, ‑yö 'dho ‑yö yöë ma 'a Mɛgbö 'ka, n ‑ma ‑go ga 'gü ‑yi ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","'Ö ‑wo bhë 'wo‑ ma ‑a ‑ta. 'Kɛɛ ‑wa ‑pö wo 'ko ‑nu ziën ꞊nɛɛ: «‑Go ga 'gü ‑sü ꞊nɛ, ‑a ‑gɛn 'ö tɔɔ ‑më ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","꞊Dhɛ ꞊ya kë 'dhö, 'wo Yesu ꞊dhɛɛ' kpɔ 'wo‑ pö: «‑Më 'ö ‑kë 'ö kwa ‑bha tɔnggɔmɛ ‑nu ꞊waa‑ pö Eli ‑dho nu kö pë mɛ 'ö dho kë ‑yaan ꞊tun kë ‑na ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Eli ‑de ‑yö ‑dho nu 'dhiö ꞊kun kö ‑yaan pë 'plɛ ꞊baa', 'kɛɛ ‑më ‑kë 'ö ‑Zlan ‑bha 'sëëdhɛ ꞊bɛɛn' ‑wo ‑ya pö Mɛgbö 'klo‑ ‑dho bhɔ ꞊gbaɔnsü, 'go mü 'ö mɛ ‑nu dhö 'yan ꞊ziö' ꞊kaa' ɛ? ");
INSERT INTO dnj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'Kɛɛ a‑ ‑pö ka ‑dhë ꞊nɛɛ: Eli ‑de ꞊ya nu 'saadhö. 'ö mɛ ‑nu ‑wa kun yaa ꞊nɛ ‑kɔ 'ö ꞊dhië' ‑an ‑dhë ‑a 'dhö ꞊nɛ ‑kɔ 'ö ꞊bɛɛn ‑sü 'ka ‑a ‑wun 'gü ‑Zlan ‑bha 'sëëdhɛ 'gü bhë ‑a 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","꞊Dhɛ 'ö ꞊wa nu, ꞊wa ‑lo ꞊guë' mɛ ‑nu 'wo to ‑an 'piö, ‑wo mɛ gbung ꞊va waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu ‑yö ‑an 'piö mü, kö ‑wo 'wun ‑nu ꞊blɛɛ' ‑na wo 'ko 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","꞊Dhɛ 'ö ‑an 'yan ꞊ya ‑kpën Yesu ‑bha, (bhii ‑a ‑bha nu mü ‑sü bhë yaa kë ‑an 'yaan 'ka), 'wo ‑bla sü 'wo dhoë ‑a ‑gɔ zian‑ kö ‑waan ‑mɛɛ kaa. ");
INSERT INTO dnj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","꞊Dhɛ Yesu ꞊ya ‑lo ö bha ꞊guë' ‑nu 'piö, 'ö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «‑Më ‑wun 'ö kaa‑ mɛ ‑nu 'wo ꞊nɛ, 'ka‑ ꞊blɛɛ' ‑na bhë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Ö gɔɔn‑ do 'ö ‑kë mɛ gbung 'gü mü, 'ö‑ ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «N ‑Gɔmɛ, a ‑nu n gbö 'ö ꞊nɛ ‑a 'ka ü ꞊dhia, bhii 'ö tɔɔ ‑zuu yaa ‑ya 'gü, 'ö 'yaa 'we ‑a ‑bha ‑a ‑gɔ kö ‑yö 'we. ");
INSERT INTO dnj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'Ö ‑dhɛ 'saadhö 'ö ꞊ya ‑püö ‑a ‑ta ‑a ‑bha, 'ö‑ ‑zuö sia‑. ꞊Ya kë 'dhö 'ö‑ 'dhee 'vuu dɔ ‑a dhiö 'wa ‑gbɔudhö kö ‑yö ö 'sɔn ‑nu ‑bhö ‑na, kö ꞊ya dɔ zɛɛndhö. 'Ö 'a ꞊bhɛa ü bha ꞊guë' ‑nu ‑dhë kö ‑waan ‑a bho ‑a 'gü, 'kɛɛ ‑an ‑kɔ yaa ‑mɔ ‑a bho ‑a 'gü ‑sü ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «'E, ꞊zuö' 'glɔɔglɔ ‑mɛ ‑nu 'ka ꞊nɛ! 'Töng ꞊dhë 'a dho ‑a sü kö 'kwaan‑ kaa kwa 'ko ꞊bhaa ꞊ɛ? 'Töng ꞊dhë 'a dho ‑a sü 'zü kö 'aan‑ ka bun ‑a 'ka ɛ?» ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö: «‑Ka nu 'në bhë ‑a 'ka n ꞊dhia!» ");
INSERT INTO dnj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'Ö mɛ ‑nu ‑wo nu 'në bhë ‑a 'ka, ‑a ꞊dhia. ꞊Dhɛ 'ö ‑zuu yaa ꞊ya ö 'yan dɔ Yesu ‑bha, 'ö 'në bhë 'ö‑ ꞊zaan 'zan 'gbee‑ 'ka, 'ö‑ ‑zuö sia‑ 'ö yö ꞊glöng 'glö ‑sü 'gü kö ‑a 'dhee 'vuu ꞊ya dɔ ‑gbɔudhö. ");
INSERT INTO dnj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","'Ö Yesu ‑ya dë ꞊dhɛɛ' kpɔ 'ö‑ pö: «꞊Dhɛ 'ö ‑ya ‑a ‑bha ꞊nɛ, ‑a ‑dhɛ ꞊ya ꞊glɔɔ ꞊a?» 'Ö‑ pö: «‑Yö ‑ya ‑a ‑bha ‑a 'nëdhɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","'Ö‑ 'bhaa ‑nu ꞊ya kë 'ö ‑zuu yaa ‑ya ‑zuö 'siö 'iin yiö ‑dhɛ ‑nu ‑bha kö 'yaan‑ ‑a zë. 'Ö ꞊ya kë ꞊nɛ ü ‑kɔ ‑yö ‑mɔ ‑a ‑bha 'üën‑ pë 'bhaa kë, ‑bhö nu yi ‑dhë, n dë, 'ü yi 'yena yö!» ");
INSERT INTO dnj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü‑ ‑pö n ‑dhë, n ‑kɔ ‑mɔ ‑a ‑bha ‑i? Ma ꞊nɛ 'a dho ü ꞊dhɛɛ' kpɔ ꞊zian' ꞊nɛ, ü ‑bha ‑zo ‑yö ‑Zlan ‑bha ‑sü ‑kɔ ‑yö ‑mɔ ‑a ‑bha ‑a? 'Kɛɛ ‑yö kë ü 'yaan: Mɛ 'ö ‑Zlan ‑wun ‑dhɛ 'wun gia‑, ‑yö ‑dho pë 'plɛ kë.» ");
INSERT INTO dnj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","‑Dhɛ do bhë ‑a 'gü 'ö 'në bhë 'ö‑ dë ‑yö ‑gbla 'ö‑ pö: «'Ma ‑Zlan ‑wun ‑dhɛ 'wun gia‑, 'kɛɛ ‑bhö nu n ‑dhë, bhii 'ö tɔɔ n ‑ma ‑zo yö ‑sü bhë ꞊yö 'tee!» ");
INSERT INTO dnj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","꞊Dhɛ Yesu ꞊yaa‑ yö ꞊nɛ mɛ ‑gbaa ‑nu ‑wo nu ‑na ‑bla 'ka wo 'piö mü, 'ö 'wun ꞊blɛɛ ‑zuu yaa bhë ‑a 'ka 'gbee‑ 'ka 'ö‑ pö: «‑Zuu yaa 'ö 'yaa 'we ‑a ‑bha 'në ꞊nɛ ‑a ‑gɔ kö ‑yö 'we, 'iin kö ‑yö 'wun ma ꞊nɛ, a‑ ‑pö ü ‑dhë 'ü 'go 'në 'ö ꞊nɛ ‑a 'gü! 'Go mü kö ꞊kun 'ü nu ‑a 'gü gbɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","'Ö ‑zuu yaa 'ö bhë 'ö yö ꞊gblaa 'gbla ‑sü 'gü, 'ö 'në bhë 'ö‑ ꞊zaan zan 'gbee‑ 'ka ‑yaan ꞊tun 'go ‑na ‑a 'gü. 'Në 'ö bhë ‑yö ‑kë ꞊nɛ mɛ ꞊ya ga ‑a 'dhö, 'ö ꞊dhɛ 'to zlöö kö mɛ 'bhaa ‑nu 'wo ‑kë mü ‑wa pö ‑na: «꞊Ya ga.» ");
INSERT INTO dnj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","'Ö Yesu ‑yö ‑ya ‑a ‑kɔ ‑bha, 'ö‑ ꞊luu; 'yö ꞊luu 'ö dɔ ö ‑gɛn ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","꞊Dhɛ Yesu ꞊ya 'dho ꞊ya ‑lo kɔɔ, 'ö waa‑ ö bha ꞊guë' ‑nu ꞊wa 'to wo 'sloo 'ka, 'wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑Më 'ö ‑kë 'ö yi ‑kɔ yaa ‑mɔ ‑zuu yaa 'ö bhë ‑a kë ‑sü ‑bha ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ ‑pö: «꞊Bhɛa' ‑sü dosɛn 'kpaan ꞊nɛ 'ö dho ‑mɔ ‑a ‑bha kö ‑yaan ‑zuu yaa ꞊suu'‑ 'ö ꞊nɛ ‑a kaa mɛ ‑nu 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","‑Wo ‑go ‑dhɛ 'ö bhë ‑a 'gü 'wo dho; 'kɛɛ ‑wo ‑bɔ Galile ‑sɛ 'gü. 'Ö Yesu 'yaa‑ 'piö kö ‑dhɛ 'ö‑ ‑bha mɛ ‑nu ‑wa dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bhii ‑yö ‑kë ö bha ꞊guë' ‑nu ꞊daan' ‑sü 'gü, 'ö‑ pö ‑an ‑dhë: «Ma 'a Mɛgbö 'ka, ‑wo ‑dho n dɔ mɛ ‑nu kwɛɛ, 'ö 'wo n zë; 'ö‑ ‑dhɛkpaɔyi ‑yaaga ‑naa bhë 'a goë ga 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","'Kɛɛ ‑a ‑bha ꞊guë' ‑nu waa ‑wo 'ö bhë ‑a ‑gɛn dɔ, 'ö 'suö ‑yö ‑an ‑kë 'zü ‑a ꞊dhɛɛ' 'kpɔ ‑dhiadhö. ");
INSERT INTO dnj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","'Wo dho 'wo ‑lo Kapɛɛnaɔmë. ꞊Dhɛ ꞊wa 'dho ꞊wa ‑sɔ kɔɔ, 'ö Yesu ‑yö ö bha ꞊guë' ‑nu ꞊dhɛɛ' ‑kpɔ 'ö‑ pö: «‑Më ‑wun ‑nu 'ka ‑kë ‑a ꞊blɛɛ' ꞊dhia zian ‑gbloo 'piö ꞊nɛɛ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","'Kɛɛ ‑wo wo 'dhi ‑yö 'kuë‑, bhii zian ‑gbloo 'piö, ‑wo ‑kë mɛ 'ö dho kë mɛ ꞊va 'ka wo ziën ‑a ‑wun ꞊blɛɛ' ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ꞊yaannu, 'ö ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë, 'yö ‑an ꞊dhɔɔ ‑kë, 'ö‑ pö ‑an ‑dhë: «'Ö ꞊ya kë ꞊nɛ mɛ ‑yö ‑dhö kö ‑yö kë mɛ ꞊va 'ka, kö ‑yö kë ‑de ‑dho sia‑ ‑mɛ, waa‑ yuö ‑kë mɛ 'plɛ 'dhiö ‑mɛ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","'Go mü 'ö 'në 'tee do sü, 'ö‑ dɔ ‑an wö 'dhiö, 'ö‑ sü 'ö‑ ‑ya ö 'gban ‑ta dhuö, 'ö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Mɛ 'ö 'dhoë‑ mɛ ‑nu 'ö ‑an ꞊suu'‑ ‑yö ‑kë ꞊nɛ 'në ꞊nɛ ‑a 'dhö, ‑a mɛ do ‑nia kun n ‑wun 'gü, kö ꞊ya ma gia‑ n ‑nia 'kun. 'Ö mɛ 'ö 'dhoë‑ n ‑nia kun, kö ma do kun 'yö n ‑nia kun, 'kɛɛ kö mɛ 'yö n bɔ bhë, ꞊yaa‑ ‑nia 'kun.» ");
INSERT INTO dnj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","꞊Dhɛ ꞊ya kë 'dhö, 'ö Zan ‑ya pö Yesu ‑dhë: «Yi ‑Gɔmɛ, yi gɔɔn‑ do ‑yö kö ‑yö ‑zuu yaa bho ‑na mɛ 'gü ü 'tɔ 'ka, 'ö 'yi‑ pö ‑a ‑dhë kö ꞊kun 'ö‑ ‑kë 'dhö gbɔ, 'ö tɔɔ 'yaa kwaa‑ mɛ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «Kö ꞊kun 'ka‑ pö ‑a ‑dhë ‑abi', bhii mɛ 'ö ‑dhidhaapë ‑kë n 'tɔ 'ka yaa 'dhö to ‑dhɛ do bhë ‑a ‑bha kö ‑yaan 'wun yaa ꞊blɛɛ'‑ n ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","'Ö tɔɔ mɛ yaa nu kwa ‑gɔ, kö kwa ‑mɛ ‑mü. ");
INSERT INTO dnj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'Ö mɛ 'ö 'dhoë‑ 'yi ‑kɔɔ do nu ka ‑dhë ka ‑bha ‑kë Klito ‑bha mɛ ‑nu 'ka ‑sü ‑wun 'gü, a‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ‑A 'kian 'ka 'dho kun ‑këdhösü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","'Yö Yesu ‑ya pö 'zü: «Mɛ ‑nu 'wo wo ‑zo yö n ‑ma bhë, mɛ 'ö 'dhoë‑ ‑a 'në do 'kpaan ‑de ‑dian, ‑yaan ‑püö ꞊sɔɔn yaa 'gü, ꞊yö ‑së ‑a ‑bha 'ka kö ‑wo ‑guö kpö ꞊va do ‑klu ‑a bhɔ ‑bha, ‑wa ‑zuö 'yoo ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","'Ö ꞊ya kë ꞊nɛ ü ‑kɔ 'ö ü ‑da ꞊sɔɔn yaa 'gü, kö ‑bhö ‑a 'klu 'kan! ꞊Yö ‑së ü ‑bha 'ka kö ü ‑da ꞊toëpö ‑kë ‑a 'gü ‑dhɛ ‑bha ü ‑kɔ do 'ka 'ö ꞊zië' ü ‑kɔ ꞊plɛ ‑bha ‑to mü ‑sü 'ü dhoë ꞊glöötiaandhö, 'siö 'ö 'yaa ꞊dhuu' 'gbɛɛdhö ‑a 'gü ‑sü ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‑Dhɛ bhë ‑a 'gü ꞊nɛ 'ö nɔ ‑nu 'wo mɛ bun ‑bhö 'ö 'waa ga, waa‑ 'siö 'ö 'yaa ꞊dhuu' 'gbɛɛdhö bhë 'wo‑ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'Ö ꞊ya kë ꞊nɛ ü ‑gɛn 'ö ü ‑da ꞊sɔɔn yaa 'gü, kö ‑bhö ‑a 'klu 'kan! ꞊Yö ‑së ü ‑bha 'ka kö 'ü ‑da ꞊toëpö ‑kë ‑a 'gü ‑dhɛ ‑bha ü ‑gɛn do 'ka 'ö ꞊zië' ü ‑gɛn ꞊plɛ ‑këdhösü 'ü dhoë ꞊glöötiaandhö 'siö 'ö 'yaa ꞊dhuu' 'gbɛɛdhö ‑a 'gü bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‑Dhɛ bhë nɔ ‑nu ‑wo mɛ ‑nu bun ‑bhö 'ö 'waa ga, waa‑ 'siö 'ö 'yaa ꞊dhuu' 'gbɛɛdhö bhë ‑wa ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'Ö ꞊ya kë ꞊nɛ ü 'yanga 'ö ü ‑da ꞊sɔɔn yaa 'gü, kö ‑bhö ‑a bho mü; ꞊yö ‑së ü ‑bha 'ka kö 'ü ‑da ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü ü 'yanga do 'ka, 'ö ꞊zië' ü 'yanga ꞊plɛ ‑to ü ‑bha ‑sü, 'ü ꞊zong ‑a 'ka ꞊glöötiaandhö 'siö 'gü bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‑Dhɛ bhë ‑a 'gü, nɔ ‑nu 'wo mɛ bun ‑bhö 'ö 'waa ga, waa‑ 'siö 'ö 'yaa ꞊dhuu' 'gbɛɛdhö bhë, ‑wa ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Bhii ‑kɔ do 'ö kweezö 'dhö pë ‑nu 'kun ‑na ‑a 'ka bhë, 'ö 'siö ‑dho ‑a kë ‑a 'ka mɛ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kweezö ‑yö pë do ‑së 'ka, 'kɛɛ 'ö ꞊ya kë ꞊nɛ kweezö din 'yaa‑ ‑bha, ka ‑dho ‑a kë ‑kɔklë kö ‑a din ‑yö kë ‑a ‑bha 'zü ‑i? ꞊Dhɛ 'ö 'dhö, kö ka ‑bha kweezö ‑yö kë ka 'gü, 'ka ‑tosiadhe kë ka 'ko ‑nu ziën ꞊zuöyagluu 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu waa‑ ö bha ꞊guë' ‑nu ‑wo ‑go ‑dhɛ 'ö bhë ‑a 'gü, 'ö 'wo dho Zude ‑sɛ 'gü. 'Go mü 'ö 'wo dho 'yiga 'wo‑ ‑dhɛ Zuudɛn ‑a ꞊zlöö ꞊zian'. ‑Dhɛ bhë ‑a 'gü 'zü ‑dëüwo, mɛ ‑gbaa ꞊va 'wo ꞊nië ‑a ‑zü mü. 'Ö Yesu ‑yö yö mɛ ‑nu ꞊daan' ‑sü ‑bha 'zü ꞊nɛ ‑kɔ ꞊ya kë 'ö‑ ꞊kaa' ‑kplawo bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Falizi ‑mɛ 'bhaa ‑nu ‑wo ‑yɔɔn ‑a ‑bha kö 'waan‑ 'slë 'kan ‑a ‑gɔ, 'wo‑ pö ‑a ‑dhë: «Kwa ‑bha tɔng ‑yö ‑we ‑a ‑bha kö gɔɔn‑ ‑yö ö bɔɔ bho 'blü a?» ");
INSERT INTO dnj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ ꞊dhɛɛ' ‑kpɔ ‑an ‑gɔ ‑sü 'ka 'ö‑ pö: «‑Më 'ö Moizö ‑ya pö 'ka‑ kë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","'Wo‑ pö ‑a ‑dhë: «Moizö ‑ya ‑pö gɔɔn‑ ‑yö 'dhoë‑ dhebɔ bho 'blü ‑ya ‑bho 'blü 'sëëdhɛ kë ‑ya kpa ‑a ‑bha ‑ya kaa.» ");
INSERT INTO dnj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «Moizö ‑yö tɔng 'ö 'dhö bhë ‑a ‑nu ka ‑wun 'gü 'dhö 'ö tɔɔ ka ꞊gɔü' ꞊yö 'gbee‑. ");
INSERT INTO dnj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","'Kɛɛ ‑a züdɔyi 'ka ꞊dhɛ ‑Zlan ꞊ya pë 'plɛ ‑kë, pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö tɔɔ ‑yö gɔɔn‑ waa‑ dhe ‑an ‑da. ");
INSERT INTO dnj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‑A ‑wun 'gü gɔɔn‑ ‑dho kan ö dë waa‑ ö dhe ‑an ‑bha, 'ö waa‑ ö bɔɔ 'wo ‑tosiadhe ‑kë wo 'ko 'piö, ");
INSERT INTO dnj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","'Ö ‑dhɛ 'wo‑ ‑bha ꞊plɛ 'wo ‑kë mɛ ‑lü do 'ka.» 'Ö Yesu ‑ya pö 'zü: «꞊Ya kë 'dhö kö 'waa ꞊plɛ gbɔ, 'kɛɛ kö ꞊wa kë mɛ ‑lü do 'ka ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kö ꞊kun 'ö pë 'ö ‑Zlan ꞊yaa‑ ꞊nëng 'kuë‑ bhë 'ö‑ mɛ gbɛ ‑ya ‑kan 'kuë‑!» ");
INSERT INTO dnj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","꞊Dhɛ ꞊wa 'dho kɔɔ, 'ö‑ ‑bha ꞊guë' ‑nu ‑wa ꞊dhɛɛ' kpɔ 'wun bhë ‑a 'ka 'zü ‑dëüwo. ");
INSERT INTO dnj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Gɔɔn‑ 'oo gɔɔn‑ 'ö ꞊ya ö bɔɔ kë ꞊ya dhebɔ gbɛ 'sü, kö ꞊ya ꞊sɔɔn yaa kë dhebɔ ‑blɛɛzë 'ö‑ ‑kë ‑a ‑gɔ bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","‑Kɔ do bhë ‑a 'ka 'pö, dhebɔ ꞊ya 'go ö ꞊gɔn 'piö ꞊ya gɔɔn‑ gbɛ 'sü, kö ꞊ya ꞊sɔɔn yaa kë ö ‑gɔn ‑blɛɛzë bhë ‑a 'ka 'pö.» ");
INSERT INTO dnj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mɛ ‑nu ‑wo ‑nu wo ‑bha 'në ‑nu 'ka Yesu 'piö kö ‑yaan ö ‑kɔ kpa ‑an ‑ta 'dhuë‑ ‑kpɔ ‑an ‑bha ‑sü 'ka, 'kɛɛ Yesu ‑bha ꞊guë' ‑nu waa 'we ‑a ‑bha ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","꞊Dhɛ Yesu ꞊ya ‑an yö, ‑yö ‑kë ‑a ‑dhë yaa ö bha ꞊guë' ‑nu buën‑ ꞊zian' 'ö‑ pö: «‑Ka ka ꞊kwaa' 'në 'sɛɛn‑ ‑nu ‑zü ‑wo nu n 'piö, kö ꞊kun 'ka ‑an ‑kë! Bhii ‑Zlan ‑bha ‑gludëdhɛ ‑yö mɛ ‑nu 'wo ‑kë ꞊nɛ ‑an 'dhö ‑an ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: Mɛ 'oo mɛ 'ö yaa 'we ‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑bha ꞊nɛ 'në ‑nu 'wo ꞊nɛ ‑an 'dhö, yaa 'dho ‑da ‑a 'gü 'gbɛɛdhö.» ");
INSERT INTO dnj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","꞊Dhɛ ꞊ya kë 'dhö, 'ö 'në ‑nu 'wo bhë, 'ö ‑an ‑sü 'ö ‑an kpa ö ‑tong ‑ta 'ö ö ‑kɔ kpa ‑an ‑ta do do 'ka 'dhuë‑ ‑kpɔ ‑an ‑bha ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","꞊Dhɛ Yesu waa‑ ö bha ꞊guë' ‑nu 'wo dhoë‑ ‑da zian ‑ta, gɔɔn‑ do ‑yö ‑nu ‑bla 'ka, 'ö ‑lo ö kpɔn 'gü ‑a 'dhiö, 'ö ꞊dhɛɛkpɔdhe ‑kë ‑a ‑gɔ 'ö‑ pö: «N ‑gɔmɛ këwunsëëzë, ‑më 'a dho ‑a kë kö 'aan‑ ‑da ꞊toëpö ‑kë ‑a 'gü ‑dhɛ ‑bha ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Më 'ö ‑kë 'ü n ‑dhɛ mɛ këwunsëëzë ‑ɛ? ꞊Ya 'kan ‑Zlan ‑bha, këpësëmɛ gbɛ 'yaa ‑dhö.» ");
INSERT INTO dnj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","'Ö Yesu ‑ya pö ‑a ‑dhë 'zü: «Tɔng ‑nu 'wo ‑kë ‑Zlan ‑bha 'sëëdhɛ 'gü: Kö ꞊kun 'ü mɛ zë, 'ü dhebɔ gbɛ ꞊mɛɛ 'iin 'ü gɔɔn‑ gbɛ ꞊mɛɛ, 'ü ꞊kwaan, 'ü ꞊sua ‑kë ü ‑ya 'yɔɔ ‑gɔ, 'ü pë sü ü ‑ya 'yɔɔ ‑nu ‑gɔ ‑an ‑püö ‑sü 'ka; 'ö‑ 'bhaa ‑yö ‑kë 'zü ‑bhö ü dë waa‑ ü dhe ‑an ꞊bhlë ‑ya bhë 'ü ‑an ‑dɔ ‑a?» ");
INSERT INTO dnj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","'Ö gɔɔn‑ 'ö bhë 'ö‑ ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «N ‑gɔmɛ, a tɔng ‑nu 'wo bhë ‑an 'plɛ ‑kun n 'nëdhɛ 'gü 'ö dhoë 'ö yöë ꞊dɛɛ ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","'Ö Yesu ‑ya ‑ga ‑dhɔ 'ka, 'ö‑ pö ‑a ‑dhë: «Pë do ‑wun ‑yö ꞊tun ü ‑gɔ mü, 'ö tɔɔ 'ü 'dho 'ü ü bha pë ‑nu 'wo ü ‑gɔ 'ü ‑an 'dhɔɔ dɔ, 'ü‑ 'wëüga ‑nu bhë 'ü‑ ‑glu 'fɛɛmɛ ‑nu 'ka, 'ü nu 'ü ziö n 'piö! ꞊Ya kë 'dhö, ü bha ꞊bhɔɔpë ‑nu ‑wo ‑dho kë dhang‑ 'gü!» ");
INSERT INTO dnj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Kɛɛ gɔɔn‑ 'ö bhë ꞊dhɛ Yesu ‑wo ‑nu 'wo ꞊nɛ ꞊ya ‑an ma, 'ö‑ ꞊zuö' ‑yö ꞊kaan 'kuë, 'ö ‑ziö wösiödhe 'ka, bhii 'ö tɔɔ ‑yö ‑kë ꞊bhɔɔzë ꞊duö. 'Ö yaa 'we ‑a ‑bha kö ö ‑bha ꞊bhɔɔpë ‑nu 'dhɔɔ dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","'Ö Yesu ‑yö mɛ ‑nu 'wo ꞊nië ‑a ‑zü bhë ‑an ‑ta ‑ga. 'Go mü 'ö‑ pö ö bha ꞊guë' ‑nu ‑dhë: «꞊Bhɔɔmɛ ‑bha ‑da ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü ‑sü ꞊yö 'gbee‑!» ");
INSERT INTO dnj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Ö 'tetundhe ꞊va ‑yö ‑kë ‑a ‑bha ꞊guë' ‑nu ‑gɔ 'wun ‑nu 'ö‑ ꞊blɛɛ bhë ‑a ‑wun 'gü. 'Kɛɛ Yesu ‑ya ‑pö ‑an ‑dhë 'zü: «Ma 'në ‑nu, ꞊bhɔɔmɛ ‑bha ‑da ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü ‑sü ꞊yö 'gbee‑! ");
INSERT INTO dnj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","‑Yɔɔnmia ‑bha ‑bɔ miiga 'dhi 'gü ‑sü ꞊yö 'gbee‑ 'dhö, 'kɛɛ ꞊bhɔɔmɛ ‑bha ‑da ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü ‑sü ꞊yö 'gbee‑ 'zü 'ö ꞊zië' ‑yɔɔnmia ‑bha ‑bɔ miiga 'dhi ‑bha ‑sü ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","'Ö‑ ‑bha ꞊guë' ‑nu ‑bha 'tetundhe ‑yö ‑ziö ꞊gɔü' 'zü ꞊gbaɔnsü 'ka, 'wun ‑nu 'ö‑ ꞊blɛɛ' ‑na bhë ‑an ‑wun 'gü, 'wo yö wo 'ko ꞊dhɛɛkpɔdhe kë ‑sü ‑bha ‑a pö ‑sü 'ka ꞊nɛɛ: «꞊Dhɛ 'ö 'dhö kö dö 'ö tɔɔ dhamɛ 'sa?» ");
INSERT INTO dnj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","'Ö Yesu ‑yö ‑an ‑ga, 'ö‑ pö ‑an ‑dhë: «‑Yö pë 'ö mɛ ‑nu ‑kɔ 'yaa ‑mɔ ‑a ‑bha ‑a 'ka, 'kɛɛ ‑Zlan ‑kuënkapë 'yaa 'dhö, bhii 'ö tɔɔ ‑Zlan ‑yö ‑mɔ pë 'plɛ kë ‑sü ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","꞊Dhɛ ꞊ya kë 'dhö, Piɛɛ ‑ya ‑pö ‑a ‑dhë: «‑Bhö ü 'to 'to, 'yië yi ‑bha pë 'plɛ 'to sia‑, 'ö 'yië ziö ü 'piö!» ");
INSERT INTO dnj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka mɛ 'oo mɛ ꞊ya ö bha 'kɔ 'to, ꞊ya ö dheglu 'në gɔɔn‑ ‑nu, 'nëdhoo ‑nu, ö dhe, ö dë, ö bha 'në ‑nu, ö ‑bha ꞊bhlöödhɛ ‑nu 'to n ‑wun waa‑ 'wuntaɔsë ‑an ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","‑yö ‑dho 'kɔ ‑nu, dheglu 'në gɔɔn‑ ‑nu, 'nëdhoo ‑nu, ö dhe ‑nu, ö bha 'në ‑nu, ö ‑bha ꞊bhlöödhɛ ‑nu, ‑an ‑gwaa ꞊këng' do ‑zë ‑nu yö. 'Ö 'go mü ka 'klo‑ dho bhɔ n ‑wun 'gü, 'ö 'töng mɛ 'ö nuë‑ 'zü bhë, 'ö dho ꞊toëpö ‑kë ‑a 'gü ‑sü yö ‑a ‑dhɛ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","'Kɛɛ mɛ ‑nu ‑dhɛ ꞊va ‑dhɛ 'wo 'dhiö ꞊dɛɛ ꞊nɛ ‑a 'gü, ‑wo ‑dho kë ‑tozlöömɛ ‑nu 'ka, 'ö mɛ ‑nu 'wo ‑tozlöömɛ ‑nu 'ka, 'wo dho kë 'dhiömɛ ‑nu 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","'Yö 'wo ‑da zian 'ö dho Zeluzalɛmë plöö ‑a ‑ta, Yesu ‑yö ‑kë 'ta 'sü ‑sü 'gü ö bha ꞊guë' ‑nu 'ö 'suö ꞊ya ‑da ‑an 'plɛ 'gü bhë ‑an 'dhiö. 'Yö ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an sü wo 'sloo 'ka, 'ö pë ‑nu 'wo 'dhoë‑ kë ö 'ka bhë 'ö‑ ꞊blɛɛ ‑an ‑dhë ");
INSERT INTO dnj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","'ö‑ pö: «‑Ka ka 'to 'to! Kwa ‑da ‑na Zeluzalɛmë ‑dhɛ, 'ö ma 'a Mɛgbö 'ka, 'a dho kë slabhomɛ ‑gɔmɛ ‑nu, waa‑ kwa ‑bha tɔnggɔmɛ ‑nu 'wo bhë ‑dɔ ‑an kwɛɛ ‑mɛ 'ka, ‑wo ‑dho ga ‑sü ‑za ‑lo n tuö, 'go mü 'wo n dɔ mɛ ‑nu 'waa ‑Zlan ‑bha mɛ 'ka ‑an kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","'Ö mɛ ‑nu 'wo bhë 'wo duö 'luu sü n ‑ma, 'wo wo 'dhee ‑nu ‑pɛn n ‑ma, 'wo n ‑ma ‑klaa 'ka, ‑waan ꞊tun n zë ‑na, 'ö‑ ‑dhɛkpaɔyi ‑yaaga ‑naa bhë 'a goë ga 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","꞊Dhɛ ꞊ya kë 'dhö, Zakö waa‑ Zan 'wo ‑kë Zebede gbö ‑nu 'ka bhë, 'wo nu Yesu 'sɔɔ, 'wo‑ pö ‑a ‑dhë: «Yi ‑Gɔmɛ, yi‑ 'piö kö pë 'yi dhoë‑ ‑a ‑dhɛ ü ‑gɔ ꞊nɛ, 'ü‑ kë yi ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «‑Më 'ka‑ 'piö kö 'a‑ kë ka ‑dhë ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","'Ö 'wo‑ pö: «Yi 'ü 'dhoë‑ dhoë ü ‑bha 'tɔbhɔdhɛ këdhɛ ‑bha, ‑bhö 'we ‑a ‑bha yi ‑gɔ kö 'yi ‑ya ü 'sɔɔ. N dheglu ‑yö ‑ya ü ꞊kwɛɛ‑ 'gü, kö ma ‑de 'pö 'a ‑ya ü ꞊kwaa‑ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","'Yö Yesu ‑ya ‑pö ‑an ‑dhë: «Pë 'ka‑ ‑dhɛ bhë, 'kaa‑ dɔ ꞊dhɛɛ! Ka ‑dho ‑mɔ ‑a ‑bha kö 'yi 'güüzë 'a 'dhoë‑ mü bhë, 'kaan‑ ‑a mü ꞊a, 'iin 'klobhɔdhe 'yi ꞊suu'‑ 'a 'dhoë‑ ‑da ‑a ꞊bhaa ꞊nɛ, 'kaan‑ ‑da ‑a ꞊bhaa ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","'Wo‑ pö ‑a ‑dhë: «꞊Ii‑, yi ‑kɔ ‑yö ‑mɔ ‑a ‑bha.» 'Ö Yesu ‑ya pö ‑an ‑dhë: «'Wun giagia 'ka, ka ‑dho 'yi 'güüzë 'a 'dhoë‑ mü ꞊nɛ ‑a mü 'pö, 'ö 'go mü, 'klobhɔdhe ‑yi 'a 'dhoë‑ ‑da ‑a ꞊bhaa, ka ‑dho ‑da ‑a ꞊bhaa 'pö. ");
INSERT INTO dnj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","'Kɛɛ ma kun 'a dho ‑ya ‑dhɛ 'ö n ꞊kwɛɛ‑ 'gü waa‑ ‑a mɛ 'ö n ꞊kwaa‑ 'gü, ‑a nu mɛ ‑dhë; ‑yadhɛ 'wo 'dhö bhë, ‑wo mɛ 'ö ‑Zlan ‑ya ‑ya ‑an ꞊tian' ‑an ‑bha 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","꞊Dhɛ 'ö ꞊guë' ‑nu 'gɔɔ‑ do 'wo to ꞊wa 'wun 'wo‑ ꞊blɛɛ bhë ‑a ma, 'wo yö 'wun ‑blɛɛ Zakö waa‑ Zan ‑an 'ka ‑sü 'gü ‑naadhe 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑an 'plɛ ꞊dhɔɔ ‑kë, 'ö‑ pö ‑an ‑dhë: «Ka‑ ꞊tɛi' ‑dɔ ꞊nɛ, mɛ ‑nu 'wo ‑an ‑ga ‑na ꞊nɛ, 'sɛ ꞊kɔɔnmɛ ‑nu 'dhö bhë, ‑wo 'plɔɔ ‑dhɛ ‑da mɛ ‑nu ‑ta. 'Ö mɛ ‑nu 'wo 'tɔbhɔmɛ ‑nu 'ka, 'wo mɛ ‑nu ꞊kɔɔn 'wo ꞊zië' ‑naa 'gü, wo ‑bha ‑kɔ ‑mɔ 'wun ‑bha ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'Kɛɛ ‑kɔ 'ö ꞊nɛ ‑a 'ka, yaa 'dho kaa ka ziën, ka ‑bha 'ka dho ‑a kë 'ö tɔɔ ꞊ya kë ꞊nɛ mɛ ‑ya 'piö 'ö kë mɛ ꞊va 'ka ka ziën, kö ‑yö ‑dho kë yuö ‑kë ka 'dhiö ‑mɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","'Ö ꞊ya kë ꞊nɛ ka ziën mɛ ‑ya 'piö 'ö kë mɛ 'ö dho kë 'dhiö ‑a 'ka, kö ‑yö ‑dho kë yuö ‑kë mɛ 'plɛ 'dhiö ‑mɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bhii ma 'a Mɛgbö 'ka, n 'ka nu kö ‑waan yuö kë n 'dhiö, 'kɛɛ kö 'aan‑ yuö kë mɛ ‑nu 'dhiö, 'go mü kö 'aan‑ n ‑ma ‑kë ‑a 'gü ‑sü nu mɛdhɛvadhɛ ‑bho 'gan 'gü ‑sü ꞊sɔnng' 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","꞊Dhɛ ꞊ya 'go mü Yesu waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑dho 'wo ‑lo Zeliko. ꞊Dhɛ Yesu 'dhö ö bha ꞊guë' ‑nu waa‑ mɛ ‑nu ‑gbaa 'wo go ‑na pödhɛ bhë ‑a 'gü, 'yënngtiimɛ do 'wo‑ ‑dhɛ Batimɛɛ, 'ö ‑kë Time gbö 'ka, ‑yö ‑kë ‑ya ‑sü 'ka zian ‑gbloo 'dhiö pë ‑gba ‑dhɛ ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","꞊Dhɛ 'ö ꞊yaa‑ ma ꞊nɛ Yesu 'go Nazalɛtë ‑mü, 'ö ‑yö ‑we 'gbee‑ 'sü 'gü ꞊nɛɛ: «Yesu, Davidö gbö, ‑bhö n 'yena yö ꞊ee!» ");
INSERT INTO dnj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mɛdhɛvadhɛ ‑wo 'wun ꞊blɛɛ ‑a 'ka, 'ö 'wo‑ pö ‑a ‑dhë ‑yö ö 'dhi yö 'kuë‑; 'kɛɛ ‑yö ‑we 'zü 'gbee‑ 'ka 'ö‑ pö: «Davidö gbö, ‑bhö n 'yena ‑yö wo ꞊e!» ");
INSERT INTO dnj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","'Ö Yesu ‑yö ꞊gbaannu 'ö‑ pö: «‑Ka ‑a ꞊dhɔɔ ‑kë!» 'Ö 'yënngtiimɛ bhë 'wo‑ ꞊dhɔɔ ‑kë ‑a ‑pö ‑a ‑dhë ‑sü 'ka ꞊nɛɛ: «‑Bhö ü 'gü dɔ 'gbee‑ 'ü ꞊luu'‑! Yesu ‑yö ü ꞊dhɔɔ kë ‑na.» ");
INSERT INTO dnj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","꞊Dhɛ ꞊ya kë 'dhö, 'yö ö ‑bha gblang ‑zuö sia‑ ‑yɛidhö, 'ö ꞊luu 'ö dɔ ö ‑gɛn ‑ta, 'ö nu Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","'Ö Yesu ‑ya ꞊dhɛɛ' kpɔ 'ö‑ pö: «‑Më 'ü‑ 'piö kö 'a‑ kë ü ‑dhë ‑ɛ?» 'Ö 'yënngtiimɛ ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «N ‑Gɔmɛ, ‑bhö ‑a kë kö 'a ‑dhɛ yö 'zü ‑dëüwo!» ");
INSERT INTO dnj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö 'dho! Ü ‑bha ‑zo ‑yö n ‑ma ‑sü ꞊ya ü ‑dhɛ bo.» ‑Dhɛ do bhë ‑a 'gü 'yö‑ 'yan ‑yö ‑dhɛ yö, 'ö ‑ziö Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","꞊Dhɛ 'wo ꞊yɔɔn ‑na Zeluzalɛmë ‑dhɛ 'sɔɔ, zian 'ö bɔ Bɛtefaze ‑pö waa‑ Betani ‑pö ‑an 'piö ꞊zian' ‑a 'ka, 'wo dho 'wo ‑lo ‑tɔn 'wo‑ ‑dhɛ Olivie ‑tɔn bhë ‑a ꞊gɛɛndhö. 'Ö Yesu ‑yö ö bha ꞊guë' ‑nu ꞊plɛ bɔ ö 'dhiö ‑a ‑pö ‑an ‑dhë ‑sü 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","«‑Ka 'dho plöö ‑dhɛ 'ö kwa 'dhiö ꞊nɛ ‑a 'gü! 'Ka ‑lo mü ꞊sia, ka ‑dho ꞊soofang 'në 'ö mɛ gbɛ yaa ‑ya ‑a ꞊taa do ꞊kun, ‑a yö kö ‑yö ‑klu ‑sü 'ka. ‑Ka ‑a 'po 'ka nuë n ꞊dhia zö! ");
INSERT INTO dnj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","꞊Ya kë ꞊nɛ, mɛ ꞊ya ka ꞊dhɛɛ' 'kpɔ ꞊sia ꞊nɛɛ: ‹Dö 'ö‑ pö ka ‑dhë 'ka‑ 'po e?›, ‑kaa pö ‑a ‑dhë: ‹Yi Dëmɛ ‑bha ‑wun ꞊ya yö ‑a ‑bha›. ꞊Ya kë ꞊nɛ ꞊ya yën ‑a ‑bha, ‑yö ‑dho ü ‑bha pë yɛ 'zü.» ");
INSERT INTO dnj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","꞊Dhɛ ꞊ya kë 'dhö, 'wo dho; 'ö 'wo ꞊soofang 'në do yö kö ‑yö ‑klu ‑sü 'ka 'kɔ 'dhiö, ‑kpinngga 'piö ‑dhɛ do ‑bha, ‑wo ‑kë ‑a 'po ꞊dhia, ");
INSERT INTO dnj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","'ö mɛ ‑nu 'wo ‑kë mü, 'wo ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑Më 'ka‑ kë ‑na bhë ꞊ɛ? Dö 'yö‑ pö ka ‑dhë 'ka ꞊soofang 'në bhë, 'ka‑ 'po e?» ");
INSERT INTO dnj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'Ö 'wo‑ ‑daa ‑kë ‑an ‑gɔ ꞊nɛ ‑kɔ ‑de 'ö Yesu ‑ya pöë ‑an ‑dhë bhë ‑a 'dhö. 'Ö 'wo wo ꞊kwaa ‑an ‑zü, 'wo dho ꞊soofang 'në 'ö bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","'Wo dho ‑a 'ka Yesu ꞊dhia, 'wo wo ‑bha gblang ‑nu kpɔ ꞊soofang 'në ꞊taa, 'ö Yesu ‑yö ‑ya ‑a ‑ta dhuö. ");
INSERT INTO dnj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","'Ö mɛdhɛvadhɛ ‑wo wo ‑bha gblang ‑nu ‑po zian ‑gbloo 'piö. 'ö mɛ 'bhaa ‑nu ‑bha ‑yö ‑kë 'dhɛ ‑saa ‑nu 'wo ‑an ‑yɛ ‑an 'ka, 'wo‑ kpɔ zian ‑gbloo 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mɛ ‑nu 'wo ‑kë 'ta 'sü ‑dhiadhö ‑a 'dhiö waa‑ mɛ ‑nu 'wo ‑kë ‑a ꞊zlöö ꞊zian', ‑wo ‑kë 'gɛi kë ‑sü 'gü ‑a pö ‑sü 'ka ꞊nɛɛ: «Kwaa‑ 'yoo ‑mü! Kwaa‑ 'yoo ‑mü! ‑Zlan 'tɔ kë ꞊va! ‑Zlan ‑yö 'dhuë‑ 'kpɔ mɛ 'ö nu ‑a 'tɔ 'gü ‑a ‑bha! ");
INSERT INTO dnj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","‑Zlan ‑yö 'dhuë‑ 'kpɔ ‑gludëdhɛ 'ö dho nu 'ö kwa dë Davidö ‑bha 'ka bhë ‑a ‑bha, ‑Zlan 'ö dhang‑ 'gü, ‑a 'tɔ ‑yö kë ꞊va!» ");
INSERT INTO dnj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","‑Kɔ 'ö ꞊nɛ 'ö Yesu ‑yö ꞊daa' Zeluzalɛmë plöö, 'ö dho ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü. ꞊Dhɛ ꞊ya yën ‑dhɛ ‑nu ‑ga ö ‑zü 'to ‑sü ‑bha, 'go mü, ꞊yaa‑ yö ꞊nɛ 'bin ‑yö 'më ‑na, 'ö waa‑ ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë 'wo dho Betani plöö. ");
INSERT INTO dnj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","꞊Dhɛ 'ö ‑dhɛ ꞊ya 'po ‑an ‑bha ‑go Betani ‑sü 'ka, din ‑yö Yesu ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","꞊Dhɛ 'ö dɔ ꞊gbiin, 'ö figö ‑lü do 'ö‑ 'dhɛ ‑nu ‑wo ‑kë ‑a tuö, 'ö‑ yö, 'ö dho ‑kpɔɔ ‑a bhɛ ‑nu ‑wun 'gü ꞊dhia. 'Kɛɛ ‑dhɛ 'ö ꞊ya ‑lo ‑a ‑lü ꞊gɛɛndhö, ‑a 'dhɛ 'kpaan 'ö‑ yö, 'ö tɔɔ yaa kë figö bha 'töng 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö figö ‑lü bhë ‑a ‑dhë: «Ü bhɛ gbɛ 'ka 'dho kë ‑dhö gbɔ kö mɛ ‑yaan ‑bhö!» 'Ö‑ ‑wo 'ö bhë, 'ö ‑da ‑a ‑bha ꞊guë' ‑nu 'toodhö. ");
INSERT INTO dnj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","'Wo nu 'zü, 'wo ‑lo Zeluzalɛmë. 'Ö Yesu ‑yö dho 'ö ‑da ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'ö yö mɛ ‑nu 'wo ‑kë 'ma, pë ‑nu 'dhɔɔ dɔ ‑sü waa‑ pë ‑nu 'dhɔ ‑sü 'gü bhë ‑an kë ‑sü ‑bha. 'Ö mɛ ‑nu 'wo ‑kë 'wëü‑ ‑ta ‑bɔ ꞊dhia ‑Zlan ‑gba ‑a 'gü ‑kɔ 'wëü‑ 'ka 'ö ‑an ‑bha 'dhɔɔ dɔ ‑a ‑ta ꞊gba waa‑ ‑tönggö 'dhɔɔdɔmɛ ‑nu ‑bha ‑gbloo ‑nu ‑an ‑lo sia‑. ");
INSERT INTO dnj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","'Ö yaa 'we ‑a ‑bha mɛ gbɛ ‑gɔ, kö ‑wo bɔ pë 'vlaan 'vlaan ‑nu gbɛ 'ka, ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","'Go mü 'ö mɛ ꞊daan' ‑wo ‑nu 'wo ꞊nɛ ‑an 'ka 'ö‑ pö: «‑Yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: 'Ma 'kɔ 'yö kë 'kpongtaamɛ ‑nu 'kpɛkpɛ ‑bhɛa ‑a 'gü ‑kɔ 'ka, 'yaa 'dhö a? ‑Yö ‑kë ꞊dhë 'ö ka 'pö 'ka‑ kë ka ‑bha ꞊kwaanpë ‑bin ‑a 'gü ‑guö ꞊duudhɛ 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","꞊Dhɛ 'wun bhë 'ö slabhomɛ ‑gɔmɛ ‑nu waa‑ tɔnggɔmɛ ‑nu ‑wa ma, 'wo yö pë 'wo dho ‑a kë 'waan‑ Yesu zë ‑a ꞊mɛɛ' ‑sü 'gü. 'Kɛɛ ‑wo ‑suö ‑a ‑dhë, bhii 'ö tɔɔ ‑a ‑bha mɛ ‑nu ꞊daan' ‑wo bhë ‑yö mɛ ‑gbaa ‑nu 'wo ‑kë ‑ziö ‑a 'piö ꞊dhia bhë ‑an 'te tun, 'go mü, 'ö ‑kë ‑an ‑dhë ‑së. ");
INSERT INTO dnj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","꞊Dhɛ 'ö 'yiniadhɛ ꞊ya dɔ, Yesu waa‑ ö bha ꞊guë' ‑nu ‑wo ‑go plöö, 'wo dho ‑dhɛ do 'bhaa 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","꞊Dhɛ 'wo ziö ‑na ‑dhiadhiö tii 'gü, zian ‑gbloo 'piö, 'ö‑ ‑bha ꞊guë' ‑nu 'yan ‑yö ‑kpën figö ‑lü 'ö Yesu ‑yö 'kpöü ꞊yaa' bhë ‑a ‑bha kö ꞊ya 'kpɛa 'kun, ꞊ya 'dho ꞊ya yöë ö yun ‑nu 'plɛ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","'Ö Piɛɛ ‑zo ‑yö ‑büö pë ‑nu 'wo ‑kë 'dhiö bhë ‑an 'ka, 'ö‑ pö Yesu ‑dhë: «N ‑Gɔmɛ, ‑bhö ‑dhɛ ‑ga, figö ‑lü 'ü 'kpöü ꞊yaa' bhë, ‑a ‑dhɛ 'plɛ ꞊ya 'kpɛa 'kun!» ");
INSERT INTO dnj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu 'plɛ ‑dhë: «A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: 'Ö ꞊ya kë ꞊nɛ ka ‑zo yö ‑sü ‑mü ‑Zlan ‑bha, ka ‑kɔ ‑dho ‑mɔ ‑a ‑bha kö ‑yaan pë 'plɛ kë. ");
INSERT INTO dnj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","꞊Ya kë 'dhö, ka ‑dho ‑mɔ ‑a ‑bha 'kaan‑ pö ‑tɔn 'ö ꞊nɛ ‑a ‑dhë: ‹'Godhɛ 'ü dɔ ‑a ‑bha bhë ‑a 'gü, 'ü 'dho 'ü ‑püö 'yoo ꞊bhaa!› 'Ö ‑zogɔndhe yaa kë ka ꞊zuö' 'piö, pë 'ö 'ka‑ pö bhë, 'ka‑ ‑dhɛ 'wun gia‑, kö ‑yö ‑dho kë ꞊nɛ ‑kɔ bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","‑A ‑wun 'gü a‑ ‑pö ka ‑dhë: 'Ka pë ‑dhɛ ‑Zlan ‑gɔ ꞊bhɛa' ‑sü 'ka, 'ka‑ ‑dhɛ 'wun gia‑ ꞊nɛ 'ka‑ yö; pë 'ö 'dhö bhë 'ö‑ ‑de dho nu ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","'Go mü 'ö ꞊ya kë ꞊nɛ ka ꞊bhɛa' ‑na, 'wun ꞊ya kë ka ‑zuë mɛ buëndhö, ‑a ‑bha pë yaa ‑kë ka 'ka ‑sü ‑wun 'gü, ‑ka ziö ‑a ‑bha 'wun ꞊zaa' ‑sü 'ö bhë ‑a ‑ta, ka ꞊bhɛa' ‑wo 'gü! ꞊Ya kë 'dhö, ka Dë 'ö dhang‑ 'gü bhë ‑yö ‑dho ziö ka ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta 'pö. ");
INSERT INTO dnj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","'Kɛɛ 'ö ꞊ya kë ꞊nɛ, kaa ziö mɛ ‑nu ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta, kö ka Dë ‑de 'pö 'ö dhang‑ 'gü bhë, yaa 'dho ziö ka ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta 'pö.» ");
INSERT INTO dnj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","‑Wo ‑yɛ wo 'zü 'wo dho Zeluzalɛmë plöö 'zü ‑dëüwo. Yesu ‑yö ‑kë ꞊nië' ꞊dhia ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'ö slabhomɛ ‑gɔmɛ ‑nu, Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ mɛ ziizii ‑nu ‑wo ‑nu Yesu 'piö, ");
INSERT INTO dnj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'wo‑ ꞊dhɛɛ' kpɔ, 'wo‑ pö: «Pë ‑nu 'ü‑ kë ‑na ꞊nɛ, dö‑ pö ü ‑dhë 'ü‑ kë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ma ‑de 'pö, a ‑dho ꞊dhɛɛ' do kpɔ ka ‑gɔ. 'Ka‑ ‑daa kë n ‑gɔ ꞊sia, a ‑dho pë 'ö ‑kë 'a pë ‑nu 'wo bhë 'a ‑an kë ‑na bhë ‑a ‑gɛn pö ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","꞊Dhɛɛ' bhë 'ö tɔɔ: Dö 'ö Zan Batisö bɔ ꞊ɛ? ‑Zlan ‑mü 'iin mɛ 'bhee‑ ‑nu ‑mü e? ‑Kaa ‑daa do kë n ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","'Kɛɛ ‑wo ‑yö 'wun ‑blɛɛ wo 'ko ‑dhë ‑sü 'gü 'wo‑ pö: «꞊Ya kë ꞊nɛ 'kwa‑ pö ꞊sia, ‑Zlan 'yö‑ bɔ, ‑yö ‑dho kwa ꞊dhɛɛ kpɔ ꞊nɛ, ‑më 'ö ‑kë kaa‑ ‑wo ‑dhɛ 'wun gia‑ ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'Iin 'kwa‑ pö 'zü ꞊sia, mɛ ‑nu ꞊nɛ 'wo‑ bɔ, ꞊aa' ‑n!...» (Bhii ‑wo ‑suö 'sɛgümɛ ‑nu ‑dhë, 'ö tɔɔ mɛ 'plɛ ‑wo Zan ‑sü ‑Zlan ‑wodhiölomɛ giagia 'ka.) ");
INSERT INTO dnj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","꞊Dhɛ ꞊ya kë 'dhö, 'wo‑ ‑daa ‑kë Yesu ‑gɔ 'wo‑ pö: «'Yiëë‑ dɔ.» 'Ö Yesu ‑ya pö ‑an ‑dhë 'pö: «꞊Ɛɛ, ꞊dhɛ 'ö 'dhö, kö ma ‑de 'pö, n 'ka 'dho pë ‑nu 'a ‑an kë bhë ‑a ‑gɛn gbɛ pö ka ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑yö 'wun ‑blɛɛ ‑an ‑dhë ‑sü ‑bha, 'wun ꞊zuan' ‑zɔn ‑an ‑dhë ‑sü 'ka 'ö‑ pö: «Gɔɔn‑ do ‑bha lɛzɛn ꞊dhɛɛdhɛ ‑yö ‑kë ‑dhö. 'Ö ‑guö ‑gla ꞊nië ‑a ‑zü, 'ö ‑glu do pɔn ‑drɔɔn 'yi bho ‑dhɛ 'ka, 'ö 'gbu 'kɔ do dɔ mü, 'ö‑ dɔ lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu kwɛɛ, 'ö‑ to 'ö dho 'ta 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","꞊Dhɛ 'ö lɛzɛn ‑kpa ‑nu bho 'töng ꞊ya ‑lo, 'yö ö bha yuökëmɛ do bɔ mɛ ‑nu 'wo yuö kë ‑na lɛzɛn ꞊dhɛɛdhö bhë ‑an 'piö, kö ‑waan ö ‑bha ‑kpa nu ö ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'Wo yuökëmɛ 'ö‑ dëmɛ ‑ya bɔ bhë 'wo‑ kun 'wo‑ ‑ma; 'go mü 'wo‑ ‑kë 'ö ‑yɛ ö 'zü ö ‑kɔ 'kpaan 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","'Ö lɛzɛn ꞊dhɛɛdhɛ dëmɛ ‑yö ö bha yuökëmɛ gbɛ bɔ. Yuökëmɛ mɛ 'ö nu 'zü bhë 'wo‑ kun 'zü, 'wo‑ ‑ma ö ‑gɔ ‑bha, 'wo 'si ‑nu bho ‑a ‑gɔ, 'wo‑ ‑kë 'pö. ");
INSERT INTO dnj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","'Ö lɛzɛn ꞊dhɛɛdhɛ dëmɛ ‑yö ö bha yuökëmɛ kë ‑yaaga ‑naa bɔ 'zü. 'Ö mɛ 'ö bhë 'wo‑ kun 'wo‑ zë. ‑Kɔ do bhë 'wo yuökëmɛ ꞊plëëzë 'wo nu, 'wo‑ ‑kë ‑an ‑gɔ 'pö, ‑an mɛ 'bhaa ‑ma ‑sü waa‑ ‑an mɛ 'bhaa ‑nu zë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mɛ do 'kpaan 'ö to lɛzɛn ꞊dhɛɛdhɛ dëmɛ ‑gɔ zlöö, 'ö tɔɔ ‑a gbö ‑dhɔkësüzë. Yö 'ö tɔɔ mɛ ‑kaanta 'yö‑ bɔ zlöö, ‑a ‑pö ö ‑de 'gü ‑sü 'ka ꞊nɛɛ: ‹N gbö 'ö ꞊nɛ, ‑wo ‑dho ‑a ꞊bhlë ‑ya.› ");
INSERT INTO dnj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","'Ö lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu ‑wa pö wo 'ko ziën ꞊nɛɛ: ‹Mɛ 'ö pë ‑nu 'wo ꞊nɛ 'wo dho to ‑a ‑gɔ 'dhiö ꞊zian' 'ö ꞊nɛ, ‑kwaa zë kö lɛzɛn ꞊dhɛɛdhɛ 'ö ꞊nɛ ‑yö 'to kwa ‑gɔ!› ");
INSERT INTO dnj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'Wo ‑püö ‑a gbö ‑ta, 'wo‑ zë, 'wo‑ ꞊glöö bho lɛzɛn ꞊dhɛɛdhö, 'wo‑ ‑zong. ");
INSERT INTO dnj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","꞊Ya kë 'dhö, ‑më 'ö lɛzɛn ꞊dhɛɛdhɛ dëmɛ bhë 'ö dho ‑a kë ꞊ɛ? Pë 'ö dho ‑a kë 'ö tɔɔ nu 'ö dhoë‑ wo, 'ö lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu 'wo bhë 'yö ‑an zë, 'yö ö bha lɛzɛn ꞊dhɛɛdhɛ bhë 'ö‑ nu yuökëmɛ ‑nu gbɛ ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","'Ö ko 'zü, 'ö Yesu ‑ya pö mɛ ‑nu 'wo ‑kë wo 'to 'to ꞊dhia ‑a ‑wo ‑bha bhë ‑an ‑dhë: «‑Guö kpö 'ö 'kɔdɔmɛ ‑nu ‑wa ‑ga ‑guö yaa 'ka, 'wo‑ ꞊zong bhë, ꞊ya kë 'kɔ kuënnu ‑guö gia‑ 'ka. Pë 'ö bhë kwa Dëmɛ 'ö‑ ‑kë, ‑yö kwa ‑bha pë 'gblüünzë 'ka. ‑Yö ‑ya ‑sü 'ka 'dhö ‑Zlan ‑bha 'sëëdhɛ 'gü. Kaa‑ pö ꞊kun ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","꞊Dhɛ 'ö 'wun ꞊nɛ Zuifö ‑nu ꞊kɔɔnmɛ ‑nu ꞊waa‑ ma, ‑wa këdhɛ ‑mɛɛ kö 'waan‑ 'kun, 'ö tɔɔ wo gia‑ ‑wa ꞊dɔa' ꞊nɛ 'wun ꞊zuan' 'ö‑ ‑zɔn bhë, ‑yö ‑gban wo gia‑ wo ‑bha. 'Kɛɛ ꞊dhɛ 'ö ‑kë ꞊nɛ, ‑wo ‑suö mɛ ‑nu gbung 'wo ‑kë mü ‑an ‑dhë bhë, waa pë gbɛ kë Yesu 'ka gbɔ, 'wo‑ to 'wo ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","‑Wo Falizi ‑mɛ 'bhaa ‑nu waa‑ Elɔdö ‑bha mɛ 'bhaa ‑nu ‑bɔ Yesu 'piö kö 'waan‑ 'kun, 'wo 'slë ‑kan ‑a ‑gɔ ꞊dhɛɛ' ‑nu ‑kpɔ ‑a ‑gɔ ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","'Wo nu 'wo‑ pö Yesu ‑dhë: «Yi ‑Gɔmɛ, 'yi‑ ꞊dɔa' ꞊nɛ 'wun gia‑ ꞊blɛɛ'‑ ‑mɛ ‑mü ü 'ka, 'bhaa 'suö mɛ ‑nu ‑dhë, bhii ü ‑zo gbɛ 'yaa kë mɛ ‑nu 'yan 'dhiö ‑pë ‑nu 'piö; pë 'ü‑ ‑kë ꞊zian' 'ö tɔɔ ü mɛ ‑nu ‑daan 'wun gia‑ 'ö ‑Zlan 'dhö ‑a 'piö mɛ ‑nu ‑bha ‑tosiadhe ꞊paa' ‑a 'ka. 'Kɛɛ yi‑ 'piö kö 'wun 'ö ꞊nɛ 'ü‑ bho yi ‑dhë 'kou. 'Ö tɔɔ kwa ‑bha tɔng ‑yö ‑we ‑a ‑bha kö 'kwa 'nii‑ ꞊sɔnng' bho ‑gludë Sezaa ‑dhë ‑a? Kwa ‑dho ‑a bho, 'iin kö ꞊kun 'kwa‑ bho e?» ");
INSERT INTO dnj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","'Kɛɛ Yesu ‑yö ‑an ‑bha mɛ 'yan ‑kpaa 'kun ‑sü ‑dɔ. ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö ‑an ‑dhë: «‑Më 'ö ‑kë 'ka nu n 'gü dan ꞊dhia ꞊ɛ? ‑Ka nu n ꞊dhia dönie ga do 'ka, 'a‑ ‑ga!» ");
INSERT INTO dnj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'Wo nu ‑a ga do 'ka ‑a ꞊dhia. ꞊Dhɛ Yesu ꞊yaa‑ ‑ga, 'ö‑ pö ‑an ‑dhë: «Dö 'ö‑ ‑gɔ 'bin waa‑ ‑a 'tɔ 'wo ‑ya ‑sü 'ka zö ꞊nɛ ꞊ɛ?» 'Wo‑ pö ‑a ‑dhë: «Sezaa ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","'Ö Yesu ‑ya pö ‑an ‑dhë: «Pë 'ö Sezaa ‑bha 'ka, ‑kaa nu ‑a ‑dhë; 'ka pë 'ö ‑Zlan ‑bha 'ka, 'ka‑ nu ‑Zlan ‑dhë 'pö!» 'Ö 'tetundhe ‑yö ‑an 'plɛ pa ‑a ‑daa 'ö‑ ‑kë bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduse mɛ ‑nu 'ö 'wo‑ pö gamɛ yaa 'dhö go ga 'gü bhë ‑a mɛ 'bhaa ‑nu ‑wo ‑nu Yesu 'piö, 'wo ꞊dhɛɛ' ꞊suu'‑ ꞊nɛ ‑a kpɔ ‑a ‑gɔ 'wo‑ pö: ");
INSERT INTO dnj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«N ‑Gɔmɛ, ‑bhö ‑dhɛ ‑ga, pë 'ö Moizö ‑ya ꞊bɛɛn yi ‑dhë ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö tɔɔ: ꞊Ya kë ꞊nɛ gɔɔn‑ do ꞊ya kë ‑dhö, 'ö‑ dheglu 'në gɔɔn‑ do 'dhö ‑dhö. ꞊Ya ga, ‑a bɔɔ ꞊ya 'to ‑a ꞊zlöö, 'ö 'në gbɛ yaa kë ‑an ‑gɔ, ‑yö ‑dho kë ‑së kö ‑a dheglu 'në gɔɔn‑ bhë ‑ya bɔɔ ꞊gɛandhe bhë ‑a 'sü, ‑wo 'në kpɔ ‑a dheglu mɛ 'ö ga bhë ‑a pin ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","'Kɛɛ 'töng do 'ka, dheglu 'në gɔɔn‑ ‑nu 'slaplɛ ‑wo ‑kë ‑dhö. 'Ö‑ mɛ ‑blɛɛzë ‑yö dhe sü, 'ö waa 'në 'kpɔ, 'ö gɔɔn‑ bhë 'ö ga. ");
INSERT INTO dnj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'Ö‑ mɛ kë ꞊plɛ ‑naa ‑yö ꞊gɛandhe bhë 'ö‑ sü ö bɔɔ 'ka, 'ö waa 'në 'kpɔ, 'ö yö ‑de 'pö 'ö ga. ‑Kɔ do bhë 'ö ꞊kaa' mɛ ‑kë ‑yaaga ‑naa ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","'Ö dheglu 'në gɔɔn‑ ‑nu 'slaplɛ 'wo bhë 'ö dhebɔ bhë 'ö ‑kë ‑an 'plɛ bɔɔ 'ka, 'kɛɛ waa 'në gbɛ 'kpɔ, 'ö ‑an 'plɛ ‑wo ga. ꞊Dhɛ ꞊ya kë 'dhö, 'ö dhebɔ ‑de 'pö 'ö ga. ");
INSERT INTO dnj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","꞊Ya kë 'dhö, yi 'ö gamɛ ‑nu ‑dho go ‑a 'ka ga 'gü, dö 'ö dhebɔ bhë 'ö dhö kë ‑a bɔɔ 'ka kpinngdhö ꞊e? Bhii ꞊dhɛ 'wo‑ ‑bha 'slaplɛ ‑an 'plɛ ‑wo ‑kë ‑a ꞊gɔn 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ka ‑de ‑püö 'ka‑ wo bhë, 'ö tɔɔ pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü waa‑ ‑a ‑bha 'piigbeedhɛ 'kaa ‑an gbɛ dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","‑Yö kë ka 'yaan ꞊nɛɛ: Gamɛ ‑nu ‑bha ‑go ga 'gü ‑yi 'ka, gɔɔn‑ ‑nu waa‑ dhoo ‑nu wo 'ka 'dho wo 'ko sü gbɔ. Pë dhö kë 'ö tɔɔ ‑an kë ‑kɔ ‑dho kë zlöö ꞊nɛ ‑Zlan ‑bha bɔmɛ ‑nu 'dhö dhang‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Kɛɛ ‑a mɛ 'ö ‑gban mɛ ‑nu 'ö 'waa ‑dhö gbɔ, waa‑ ‑an ‑bha ‑go ga 'gü ‑sü ‑bha bhë; 'wun do 'ö ‑kë ‑dhö, 'ö Moizö ‑ya ‑ya 'ö ‑gban 'ginng ‑kpɔɔ kpö ‑wun ‑bha, ‑a 'sëëdhɛ ‑wo kpö bhë kaa‑ pö ꞊a? 'Yö ‑Zlan ‑ya pö Moizö ‑dhë: A Ablaamö ‑bha ‑Zlan 'ka, 'a Izaakö ‑bha ‑Zlan 'ka, 'ö 'a Zakɔbö ‑bha ‑Zlan 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","'Go mü 'ö Yesu ‑ya pö 'zü: «‑Zlan ‑yö 'wun 'dhö bhë ‑a ‑blɛɛ Moizö ‑dhë kö mɛ 'wo bhë ꞊wa ga 'saadhö, ‑a ‑dhɛ ꞊ya ꞊glɔɔ. ꞊Dhɛ ‑kë 'dhö, kwa‑ ꞊tɛi' ‑dɔ ꞊nɛ ‑Zlan 'yaa gamɛ ‑nu ‑bha ‑Zlan 'ka, 'kɛɛ ‑yö mɛ ‑nu 'wo 'bhee‑ ꞊toëpö 'ka, ‑an ‑bha ‑Zlan 'ka. ‑A ‑wun 'gü, ꞊ya kë ꞊nɛ 'ka ‑zo 'ta ꞊nɛ gamɛ ‑nu 'waa 'go ga 'gü, kö ka ‑de ‑püö 'ka‑ wo 'sönggö ‑sönggö!» ");
INSERT INTO dnj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Zuifö ‑nu ‑bha tɔnggɔmɛ do ‑yö ‑an ‑wo ‑ma, 'ö dɔa ꞊nɛ Yesu ‑yö ꞊dhɛɛ' 'ö Saduse ‑mɛ ‑nu ‑wa kpɔ bhë ‑a ‑daa ‑së ‑kë ‑an ‑gɔ. ꞊Dhɛ ꞊ya kë 'dhö, 'ö ꞊yɔɔn Yesu ‑bha, 'ö‑ ꞊dhɛɛ' kpɔ 'ö‑ pö: «Tɔng ‑nu 'saadhö 'wo bhë ‑a ‑mlë 'ö‑ ‑wun 'dhö 'gbee‑ ‑e?» ");
INSERT INTO dnj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ, 'ö‑ pö: «Tɔng mɛ 'ö‑ ‑wun 'dhö 'gbee‑ 'ö tɔɔ: Izlaɛlö ‑mɛ ‑nu, ‑ka ka 'to 'to, kwa Dëmɛ, kwa ‑bha ‑Zlan ꞊nɛ, ‑yö 'dhö dosɛn, mɛ 'plɛ Dëmɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‑Bhö ü Dëmɛ, ü bha ‑Zlan, ‑dhɔ kë ü ꞊zuöga 'plɛ 'ka, ü nii 'plɛ 'ka, ü ‑zo ‑ta ‑a 'gü ‑wun 'plɛ 'ka, ü ꞊faan' 'plɛ 'ka! ");
INSERT INTO dnj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","'Go mü, ‑a mɛ 'ö yö ‑a 'piö 'ö tɔɔ: ‑Bhö ü ‑ya 'yɔɔ ‑dhɔ kë ꞊nɛ ü ‑de 'dhö! Tɔng 'waa gbɛ 'ö‑ 'wun dho kë 'gbee‑ ‑yaan zië tɔng ꞊plɛ 'wo ꞊nɛ ‑an ‑ta 'yaa ‑dhö.» ");
INSERT INTO dnj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","꞊Dhɛ 'ö ꞊ya kë 'dhö, 'ö Zuifö ‑nu ‑bha tɔnggɔmɛ 'ö bhë, 'ö‑ pö Yesu ‑dhë 'zü: «꞊Yö ‑së, n ‑Gɔmɛ, 'wun 'ü‑ ꞊blɛɛ bhë 'wun gia‑ ‑mü, kwa Dëmɛ ꞊nɛ 'ö tɔɔ ‑Zlan do 'kpaan, 'ö ‑Zlan 'waa gbɛ 'yaa ‑dhö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mɛ ‑nu ꞊dua' ‑mü kö ‑wo ‑Zlan ‑dhɔ kë wo ꞊zuöga 'plɛ 'ka, ‑an ‑zo ‑ta ‑a 'gü ‑wun 'plɛ 'ka, ‑an ꞊faan' 'plɛ 'ka; 'iin ‑wa ‑dhɔ kë wo ‑ya 'yɔɔ 'ka ꞊nɛ wo ‑de 'dhö. ‑A ‑kë 'dhö ‑sü ꞊yö ‑së ꞊duö 'ö ꞊zië' sla‑ ꞊bhoë' ‑tuë ‑güö ‑Zlan ‑dhë ‑sü waa‑ ‑Zlan gba ‑kɔ 'saadhö 'wo to bhë ‑an ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","꞊Dhɛ Yesu ꞊yaa‑ yö 'pö ꞊nɛ ꞊yaa‑ ‑daa kë 'wundɔdhe 'gbloo 'piö, 'ö‑ pö ‑a ‑dhë: «'Bhaa ‑Zlan ‑bha ‑gludëdhɛ 'ka ꞊gbiin gbɔ.» ꞊Dhɛ ꞊ya kë 'dhö zlöö, ‑zogbanmɛ gbɛ yaa kë ‑dhö gbɔ kö ‑yaan ꞊dhɛɛ' ꞊suu'‑ gbɛ kpɔ ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu ‑yö ‑kë mɛ ‑nu ꞊daan' ꞊dhia, ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'yö ꞊dhɛɛ' do ‑kpɔ mü 'ö‑ pö: «‑Më ‑kë 'ö Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu ‑wa pö: ‹‑Zlan ‑bha ‑Yamɛ ‑yö ‑go Davidö ꞊suu'‑ ‑ta 'gü› ii? ");
INSERT INTO dnj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","'Kɛɛ kö Davidö bhë, ‑Zlan ‑bha ‑Zuu 'slööslö ‑yö 'dhiö ‑sü ‑a 'ka, 'ö yö gia‑ 'ö‑ pö: ‑Zlan ‑ya pö n Dëmɛ ‑dhë: ‑Bhö ‑ya n ‑ma ‑yadhɛ ꞊bhlëzë 'ö ꞊nɛ ‑a ‑bha, ‑yö 'dho ‑yö yöë yi 'ü dho toë ‑a 'gbee‑ 'ka ü yaagümɛ ‑nu ‑ta ‑a ‑bha! » ");
INSERT INTO dnj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","'Ö Yesu ‑ya pö 'zü: «Ka gia‑, ka‑ ‑yö bhë ꞊a? Davidö gia‑ ‑ya ‑dhɛ ö Dëmɛ; ꞊ya kë 'dhö, ‑yö ‑kɔklë 'ö ‑Zlan ‑bha ‑Yamɛ ‑zë ‑yö go Davidö ꞊suu'‑ ‑ta 'gü i? 'Wun mɛ bhë ‑ka ‑a ꞊blɛɛ'‑ n ‑dhë 'kwee‑!» Mɛ gbung ꞊va ‑wo ‑kë wo 'to ‑to Yesu ‑bha ꞊dhia 'gludhidhe 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","‑Yö ‑kë ‑a pö ꞊dhia mɛ ‑nu 'ö ‑kë ‑an ꞊daan' ꞊dhia bhë ‑an ‑dhë: «‑Ka ka ‑zo kë ka ‑de 'piö tɔnggɔmɛ ‑nu 'wo‑ ‑dhɔ ‑kë ‑nië gblang ꞊gbiingbiin 'ka ‑sü 'ka wo ‑bha ‑de ‑sü ꞊va ‑wun 'gü, 'iin kö mɛ ‑nu ‑wo ‑mɛɛ kë wo 'ka ꞊bhlë 'gü, mɛ ‑nu ziën 'dhëëdhɛ ꞊vava ‑bha bhë ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","'Ö 'wo‑ ‑dhɔ ‑kë ‑yadhɛ ꞊bhlëzë 'ö mɛ ‑nu 'yan ‑ya kun ‑a 'ka, ‑an ‑bha ‑bhɔkuëkɔ ‑nu 'gü, 'iin 'wo ‑yadhɛ 'gianzë ‑nu ‑bha 'wlaan‑ ‑bhöpë ‑nu ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","꞊Wa ꞊gɛandhoo ‑nu ‑bha pë ‑nu 'kun ‑an ‑gɔ, 'wo‑ ‑kë wo ‑bha 'ka. ꞊Wa 'go mü, 'wo ꞊bhɛadhe ꞊gbiin ‑nu ‑kë, kö ‑waan kë mɛ ‑nu këwunsëëzë 'ka mɛ ‑nu 'yan 'dhiö. 'Kɛɛ 'klobhɔdhe ꞊va ‑ziögɔüsüzë ‑yö ‑dho nu ‑an ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ‑yö ‑kë ‑ya ‑sü 'ka ‑Zlan ꞊gbaa' 'wëüga ‑da ‑a 'gü ‑pë 'ö ‑kë ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü bhë, ‑a 'trüün 'ka ‑dhɛ gia‑ ‑bha. ‑Yö ‑kë mɛ ‑gbaa 'wo ‑kë mü bhë ‑an ‑bha 'wëüga ‑da mü ‑kɔ ‑ga ꞊dhia. ꞊Bhɔɔmɛ ‑nu ‑dhɛ ꞊va ‑dhɛ ‑wo 'wëüga ꞊vava ‑da mü. ");
INSERT INTO dnj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","꞊Gɛandhe 'fɛɛzë do ‑yö ‑kë mü, 'ö nu 'ö 'wëü‑ 'puu 'tama ga 'sɛɛn‑ ꞊plɛ, 'ö dho ‑mɔ ‑a ‑bha ‑yaan kë ‑su ga do 'ka bhë 'yö ‑an ‑zuö mü. ");
INSERT INTO dnj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö ö bha ꞊guë' ‑nu ꞊dhɔɔ ‑kë, 'ö‑ pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ꞊Gɛandhe 'fɛɛzë 'ö ꞊nɛ pë 'ö‑ ‑da ‑Zlan ‑bha 'wëüga ‑da ‑a 'gü ‑pë 'ö ꞊nɛ ‑a 'gü bhë, ‑a ꞊bhlë ꞊yö ꞊va, 'ö ꞊zië' ‑a 'ka mɛ ‑nu 'saadhö ‑an ‑bha 'wo‑ ‑da mü bhë ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bhii mɛ ‑nu 'wo bhë, 'wëüga 'ö ‑an ‑bha ‑wun 'yaa‑ ‑bha gbɔ, 'wo‑ nu, 'kɛɛ yö ‑zë, ‑a ‑bha 'fɛɛdhɛ 'gü ‑pë ‑nu 'ö‑ ‑zo 'dhoë‑ ‑dhë waa‑ pë ‑nu 'ö dho ‑tosiadhe kë ‑a ‑ta bhë 'ö‑ 'plɛ nu bhë.» ");
INSERT INTO dnj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ‑yö ‑kë 'go ꞊dhia ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'ö‑ ‑bha ꞊guë' ‑nu mɛ do ‑ya pö ‑a ‑dhë: «N ‑Gɔmɛ, ‑bhö ‑Zlan ‑gba ‑a 'gü ‑kɔ kë ‑së ‑kɔ ‑ga bhë 'dhɛ! ‑Guö ‑nu kë ‑sɛɛbɔ ‑kɔ ‑ga!» ");
INSERT INTO dnj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","'Ö Yesu ‑ya pö ‑a ‑dhë: «'Kɔ ‑nu 'wo bhë ‑wo ꞊vava 'wun gia‑ 'ka, 'kɛɛ ‑an dɔ ‑guö ‑nu gbɛ 'ka 'dho to 'ko ‑ta dhuö zö, ‑an 'plɛ ‑wo ‑dho ‑lo, 'wo go wo 'ko ‑ta dhuö.» ");
INSERT INTO dnj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu ‑yö ‑kë ‑ya ‑sü 'ka Olivie ‑tɔn tuö, ‑Zlan ‑gba ‑a 'gü ‑kɔ 'trüün 'ka, ‑dhɛ gia‑ ‑bha. 'Ö Piɛɛ 'dhö, Zakö 'dhö, Zan waa‑ Andre 'wo nu, 'wo‑ ꞊dhɛɛ' kpɔ 'wo‑ pö: ");
INSERT INTO dnj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«‑Bhö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'wü ‑yi waa‑ ꞊duakëpë 'ö dho pë ‑nu 'saadhö 'ü ‑an ꞊blɛɛ yi ‑dhë bhë, ‑an kë ‑yi 'töng ‑zɔn, ‑a ꞊blɛɛ'‑ yi ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka ka ‑zo kë ka ‑de 'piö, ‑yö kë 'dhö, kö ꞊kun 'ö mɛ gbɛ dho ka ‑püö! ");
INSERT INTO dnj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bhii mɛdhɛvadhɛ ‑wo ‑dho nu n 'tɔ 'gü 'wo‑ pö ‑Zlan ‑bha ‑Yamɛ ‑mü wo 'ka; 'wo mɛdhɛvadhɛ ‑püö. ");
INSERT INTO dnj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","'Ka ‑glu ‑drinng ma ka 'sɔɔ ‑dhɛ ‑nu ‑bha, 'iin 'ka ‑glu ‑taɔ ‑nu ma, kö ꞊kun 'ö 'suö ‑yö ka ‑kë! Pë ‑nu 'wo bhë, ‑wo ‑dho kë 'gbɛɛdhö; 'kɛɛ kö 'kpongtaa 'dhiötoyi yaa ‑mü ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","'Sɛgɔ ‑dho 'ko zë ö 'bha 'sɛgɔ 'ka, 'ö ‑gludëdhɛ ‑nu ‑kpa 'kuë‑ ‑sü dho ‑glu gɔn ‑an ‑kpa 'kuë‑ ‑sü gbɛ 'ka. 'Ö 'sɛ ‑bha ꞊zluun ‑sü ‑yö ‑kë 'sɛgɔ 'bhaa ‑nu 'gü; 'ö din ‑nu dho ‑da. ‑Yö ‑dho kë ꞊nɛ dhe ‑bha 'në 'kpɔ ‑sü ‑bha 'yënngbhɔdhe zü dɔ ‑sü 'dhö. ");
INSERT INTO dnj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","'Kɛɛ ka ‑zë, ‑ka ka ‑zo kë ka ‑de 'piö! Bhii mɛ ‑nu ‑wo ‑dho dho ka 'ka za ‑dɔ ‑a 'gü ‑kɔ ‑nu 'gü, 'wo ka ‑ma ‑nu wo 'to. ‑Wo bɔ ka 'ka 'sɛ ꞊kɔɔnmɛ ‑nu waa‑ ‑gludë ‑nu ‑an 'dhiö n ‑wun 'gü kö 'kaan‑ ka ‑bha ‑tɔmɔdhɛ ‑nu kë ‑an wö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","'Kɛɛ pë dho kë 'dhiö ꞊kun 'ö tɔɔ 'wuntaɔsë 'ö bhë ‑yö ꞊blɛɛ'‑ 'sɛgɔ 'saadhö 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","'Ö ꞊ya kë ꞊nɛ ꞊wa ka 'kun, ꞊wa 'dho ka 'ka zakanmɛ ‑nu 'dhiö, kö ꞊kun 'ö 'suö ‑yö ka ‑kë, 'wun ‑nu 'ö 'ka dho ‑a ꞊blɛɛ'‑ ‑an ‑wun 'gü, bhii ‑dhɛ do bhë ‑a 'gü, 'wun ‑nu 'saadhö 'yö ‑da ka dhiö, ‑ka ‑a ꞊blɛɛ'‑; 'ö tɔɔ 'wun ‑nu 'wo bhë waa 'dho go ka gia‑ ka 'gü, 'kɛɛ mɛ 'ö go ‑a 'gü 'ö tɔɔ ‑Zuu 'slööslö. ");
INSERT INTO dnj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mɛ ‑nu ‑wo ‑dho wo ‑de dheglu 'në gɔɔn‑ ‑nu dɔ mɛ ‑nu kwɛɛ kö ‑waan ‑an zë. ‑Kɔ do bhë, 'ö 'në dë ‑nu dho ‑a kaa wo ‑bha 'në ‑nu 'ka 'pö. 'Në ‑nu ‑de 'pö, ‑wo ‑dho dɔ wo mɛ ‑nu ‑gɔ 'yënng, 'wo wo mɛ ‑nu dɔ mɛ ‑nu kwɛɛ, 'ö 'wo ‑an zë 'pö. ");
INSERT INTO dnj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mɛ ‑nu 'saadhö ‑wo ‑dho ka ‑san zë n ‑wun 'gü, 'kɛɛ mɛ 'ö dho ꞊wa ‑bhö ‑yaan yöë ‑a 'dhiötoyi ‑bha, ‑yö ‑dho dha.» ");
INSERT INTO dnj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","'Yö Yesu ‑ya pö ‑an ‑dhë 'zü: «Ka ‑dho pë 'ö mɛ ‑nu ‑wa ‑dhɛ ‹pë yaa ꞊lɔɔzë› ‑a yö kö ‑yö dɔ ‑sü 'ka ‑dhɛ 'ö 'yaa‑ dɔ ‑dhɛ 'ka ‑a ‑bha. Mɛ ‑nu 'ka pë ‑nu 'wo ꞊nɛ ‑an pö ‑na, ‑ka ꞊kpɔɔ' ‑a 'gü, 'ka‑ ‑gɛn ma ‑së 'ka.» 'Yö‑ pö 'zü: «꞊Ya kë 'dhö, kö mɛ ‑nu 'wo Zude ‑sɛ 'gü ‑wo ꞊duë 'wo dho ‑tɔn ‑nu 'piö ‑dhɛ ‑nu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","'Ö ꞊ya kë ꞊nɛ mɛ ꞊ya kë ö ‑gɔ 'kɔ tuö ö 'tɛɛ pa ꞊dhia, ‑yö ꞊duë; 'kɛɛ kö ꞊kun 'ö ö bha kɔɔpë gbɛ sü ‑yaan zië. ");
INSERT INTO dnj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Go mü, mɛ ꞊ya kë ö ‑gɔ ꞊bhlöö‑, kö ꞊kun 'ö ‑yɛ ö 'zü kö ‑yaan nu ö ‑gɔ kɔɔ ö bha gblang 'sü ‑dhiadhö. ");
INSERT INTO dnj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","꞊N nnn! ‑Më 'yena ‑wun 'ö 'pö ‑a yi ‑nu 'wo 'dhö bhë ‑an 'ka, dhoo ‑nu 'wo 'guzë waa‑ dhoo ‑nu mɛ 'wo 'bëë‑ 'ka ‑an ‑bha 'ka oo! ");
INSERT INTO dnj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","'Kɛɛ ‑ka ‑bhɛa ‑Zlan ‑dhë, kö ꞊kun 'ö pë ‑nu 'wo 'dhö bhë 'wo ‑kë 'nɛnɛ nu 'töng 'ka! ");
INSERT INTO dnj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bhii ‑a yi ‑nu 'wo 'dhö bhë ‑an 'ka 'yënngbhɔdhe ‑nu ‑dho kë ꞊va, 'wo ꞊zië' ‑an mɛ ‑nu 'ö mɛ ‑nu ‑wo ‑an dɔ, 'go 'kpongtaadhɛ züdɔyi ‑bha kö ‑Zlan ꞊ya pë 'plɛ kë, 'ö yöë ꞊dɛɛ ‑bha bhë ‑an ‑ta. 'Ö 'yënngbhɔdhe ꞊suu'‑ mɛ 'ö dho kë ꞊nɛ ‑a mɛ 'ö bhë ‑a 'dhö yaa 'dhö kë ‑dhö gbɔ. ");
INSERT INTO dnj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","'Ö ꞊ya kë ꞊nɛ kwa Dëmɛ gia‑ yaa‑ yi ‑nu 'kan ‑ta ‑bezë, kö ‑kë ‑a 'gü ‑mɛ gbɛ 'ka 'dho kë ‑dhö. 'Kɛɛ ‑ya yi ‑nu ‑kan ‑ta ö bha mɛ ‑nu 'ö ‑an sü kö ‑waan kë ö ‑bha 'ka bhë ‑an ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","꞊Dhɛ 'ö 'dhö, ꞊ya kë ꞊nɛ mɛ ꞊yaa‑ pö ka ‑dhë: ‹‑Ka ‑dhɛ ‑ga, ‑Zlan ‑bha ‑Yamɛ ‑yö zö› 'iin ‹‑ka ‑dhɛ ‑ga, ‑yö ‑de›, kö ꞊kun 'ka‑ ‑wo ‑dhɛ 'wun gia‑! ");
INSERT INTO dnj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bhii ‑Zlan ‑bha ‑Yamɛ ꞊suazë ‑nu waa‑ ‑Zlan ‑wodhiölomɛ ꞊suazë ‑nu ‑wo ‑dho nu, 'wo ꞊duakëpë ‑nu, ‑dhidhaapë ‑nu ‑kë, kö mɛ ‑nu 'ö ‑Zlan ꞊yaa‑ ‑an 'sü 'saadhö bhë ‑waan ‑püö 'gbɛɛdhö. ");
INSERT INTO dnj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","꞊Dhɛ 'ma‑ yi ‑nu 'to 'dhiö, 'ma ka 'paan bho bhë kö ‑ka ka ‑zo kë ka ‑de 'piö!» ");
INSERT INTO dnj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","'Kɛɛ yi ‑nu 'wo 'dhö bhë ‑an 'ka kö 'yënngbhɔdhe ‑nu 'wo bhë ꞊wa ziö bhë, lan‑ ‑dho trö, 'ö 'su ‑de 'pö yaa 'dho bhü gbɔ. ");
INSERT INTO dnj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","'Susongga ‑nu ‑wo ‑dho go dhang‑ ‑bha, 'wo ‑püö, 'ö 'piigbeedhɛ 'wo dhang‑ 'gü, 'wo ꞊zluun. ");
INSERT INTO dnj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","꞊Ya kë 'dhö, ‑wo ‑dho ma 'a Mɛgbö 'ka, n yö dha kpö ‑nu ‑ta kö a nu ‑na 'piigbeedhɛ waa‑ 'tɔbhɔdhe ꞊va ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A ‑dho ‑Zlan ‑bha bɔmɛ ‑nu bɔ 'kpongtaadhɛ 'pian 'saadhö ‑ta kö ‑a ‑bha mɛ ‑nu 'ö ‑an sü 'kpongtaa 'saadhö bhë ‑waan ‑an 'dho 'kuë‑. ");
INSERT INTO dnj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","꞊Dhɛ ꞊ya 'go mü, 'ö Yesu ‑ya pö 'zü: «Mɛ ꞊daan' ‑wo 'ö ‑gban figö ‑lü ‑bha bhë ‑ka ka ‑zo 'to ‑a 'piö! 'Ö tɔɔ ꞊ya kë ꞊nɛ ‑a ‑kɔ ‑nu ‑wo ꞊kpɛa' ‑na, ‑a 'dhɛ ‑nu ‑wo bhɔ ‑na kö 'ka‑ ꞊dɔa' ꞊nɛ ꞊kpɔɔ ꞊ya yö ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","‑Kɔ do bhë ‑a 'ka 'wun ‑nu 'ö 'a ‑an ꞊blɛɛ bhë, 'ka ‑an yöë, kö ‑kaa dɔa ꞊nɛ, pë ‑nu 'a‑ ‑wun ꞊blɛɛ ꞊nɛ, ‑an kë ‑yi ꞊ya yö ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Mɛ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü 'wo 'bhee‑, ‑an 'plɛ wo 'ka 'dho ga kö pë ‑nu 'wo ꞊nɛ waa kë ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dhang‑ waa‑ 'sɛ ‑wo ‑dho ziö, 'kɛɛ n ‑wo ‑nu 'wo ꞊nɛ wo 'ka 'dho ziö 'gbɛɛdhö.» ");
INSERT INTO dnj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","'Ö Yesu ‑ya pö: «Mɛ gbɛ 'yaa pë ‑nu 'wo ꞊nɛ ‑an kë ‑yi waa‑ ‑a 'lɛlɛ ‑nu dɔ; ‑Zlan ‑bha bɔmɛ ‑nu, 'iin ma ‑de gia‑ 'a‑ Gbö 'ka yiëë‑ dɔ. N Dë dosɛn ꞊nɛ 'ö‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","‑Ka ka ‑zo kë ka ‑de 'piö, 'ka ‑ya ka 'yaan, bhii 'kaa pë ‑nu 'wo ꞊nɛ ‑an nu 'töng dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","‑Yö ‑dho kë ꞊nɛ gɔɔn‑ do ‑bha ‑dho 'ta 'gü ‑sü 'dhö: ‑A ‑go ö ‑gɔ kɔɔ ‑sü 'ka, 'yö ö bha yuökëmɛ ‑nu 'yan to ö bha pë ‑nu ‑bha; 'ö mɛ 'ö ‑dhö, yuö 'ö dho ‑a kë, 'ö‑ nu ‑a ‑dhë. 'Go mü, 'ö‑ pö 'yan ‑to 'kɔ ‑bha ‑mɛ ‑dhë ‑yö ö ‑zo kë 'kɔ 'piö.» ");
INSERT INTO dnj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'Ö Yesu ‑ya pö 'zü: «꞊Dhɛ 'ö 'dhö, ‑ka ‑ya ka 'yaan, bhii yi 'ö 'kɔdëmɛ dho nu ‑a 'ka, 'kaa‑ dɔ. ‑Yö ‑dho nu 'yinia oo, gbeng ziën oo, ‑tɔgɔn bhɔ ‑bhla 'töng 'ka oo, 'iin kö ‑dhɛ ꞊ya 'po oo, 'kaa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","‑Yö kë 'dhö, ꞊ya kë ꞊nɛ ꞊ya nu kö ꞊kun 'yö dho ka yö yiö. ");
INSERT INTO dnj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","'Wun 'a‑ ꞊blɛɛ' ‑na ka ‑dhë ꞊nɛ ‑yö mɛ 'saadhö ka ‑bha 'ka: 'Ka ‑ya ka 'yaan!» ");
INSERT INTO dnj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","꞊Dhɛ 'ö Paakö waa‑ ꞊bluu'‑ 'ö‑ ꞊bhɛɛpë 'yaa‑ 'gü, ‑an 'wlaan‑ kë yi ꞊ya 'to ꞊nɛ pë 'plɛ 'dhö, 'ö slabhomɛ ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu ‑wo yö ‑a këdhɛ ꞊mɛɛ' ‑sü 'gü kö 'waan‑ Yesu 'kun ‑bin ‑blü kö 'waan‑ ‑a zë. ");
INSERT INTO dnj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","'Ö 'wo ‑kë ‑a pö ꞊dhia wo 'ko ‑nu ‑dhë ꞊nɛɛ: «Kwa ‑kɔ yaa 'dho ‑mɔ ‑a ‑bha kö 'kwa‑ 'kun 'wlaan‑ ‑yi 'ka. ꞊Ya kë 'dhö, 'sɛgümɛ ‑nu ‑wo ‑dho vin 'ö 'wo nu kwa ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ‑yö ‑kë Simɔ 'ö ꞊wee ‑yö ‑kë ‑a ‑bha ‑be bhë ‑a ‑gɔ kɔɔ Betani. ‑Yö ‑to pë ‑bhö ꞊dhia, 'ö dhebɔ do ‑yö ‑da kɔɔ ‑guö ‑kpo 'lü 'ö ‑kë pa ‑sü 'ka pë 'yi 'tëë ‑sëëzë ꞊sɔnng' ꞊vaazë 'wo‑ ‑dhɛ 'naa‑ bhë ‑a 'ka. 'Ö ‑guö ‑kpo 'lü bhë 'ö‑ 'to 'dhiö bho, 'ö pë 'yi 'tëë ‑sëëzë bhë 'ö‑ 'daawo Yesu tuö. ");
INSERT INTO dnj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mɛ ‑nu 'wo ‑kë mü bhë 'wun ‑na ‑an mɛ 'bhaa ‑nu ‑zuë, 'wo‑ pö wo 'ko ‑nu ‑dhë: «Pë 'yi 'tëë ‑sëëzë 'ö ꞊nɛ, ‑a 'gü kun 'ö ‑siö ꞊nɛ ꞊a; ‑a ꞊truën 'ö tɔɔ ‑më ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","‑Wo ‑dho ‑mɔ ‑a ‑bha 'wo‑ 'dhɔɔ dɔ dönie ꞊këng' ‑yaaga 'ka ‑be, 'wo‑ 'wëüga bhë 'wo‑ nu 'fɛɛmɛ ‑nu ‑dhë!» 'Wo yö dhebɔ 'ö bhë ‑a ꞊tɔɔ kë ‑sü 'gü 'gbee‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'Kɛɛ Yesu ‑ya ‑pö ‑an ‑dhë: «‑Ka ka ꞊kwaa' ‑a ‑zü 'sengdhö! ‑Më 'ö ‑kë 'ka‑ 'gü ga ꞊ɛ? Pë 'ö‑ ‑kë n ‑dhë bhë ꞊yö ‑së. ");
INSERT INTO dnj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","'Fɛɛmɛ ‑nu 'ka ‑an ‑ga ‑na bhë, ‑wo ‑dho kë ka 'piö 'töng 'saadhö 'ka. 'Ö‑ yi mɛ ꞊ya dhië ka ‑dhë, 'ka dho 'wun ‑së kë ‑an ‑dhë. 'Kɛɛ ma ‑zë, n 'ka 'dho kë ka 'piö zö 'töng 'saadhö 'plɛ 'ka. ‑A ‑wun 'gü, ꞊dhɛ 'a ꞊tun ka 'piö bhë, ‑ka ka ‑bha n ‑dhɔ ‑zɔn n ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","‑A ‑bha 'ö‑ ‑kɔ ‑yö ‑mɔ ‑a ‑bha 'ö‑ ‑kë bhë, n bun 'ö 'dhoë‑ dho ꞊gluudhö bhë, 'ö‑ ꞊baa pë 'yi 'tëë ‑sëëzë ‑lo ‑a ‑bha ‑sü 'ka ꞊klöödhö bhë. ");
INSERT INTO dnj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A‑ ‑blɛɛ ka ‑dhë 'wun giagia 'ka: ‑Dhɛ 'saadhö 'wo 'dhoë‑ 'wuntaɔsë ꞊blɛɛ'‑ ‑a ‑bha 'kpongtaadhɛ 'saadhö ‑a 'gü, 'wun 'ö dhebɔ 'ö ꞊nɛ 'ö‑ ‑kë ꞊nɛ, ‑wo ‑dho ‑a ‑wun ꞊blɛɛ'‑, 'ö ‑an ‑zo ‑yö ‑büö dhebɔ 'ö ꞊nɛ ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","꞊Dhɛ ꞊ya kë 'dhö, ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë, ‑a mɛ do 'wo‑ ‑dhɛ Zuda Ikaliɔtö bhë, 'ö dho 'ö‑ pö slabhomɛ ‑gɔmɛ ‑nu ‑dhë ꞊nɛ ö‑ 'piö kö 'ö Yesu dɔ ‑an kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","꞊Dhɛ 'ö‑ ‑wo bhë ꞊waa‑ ma, ‑an ꞊zuö' 'glu ‑yö ‑dhi, 'wo‑ pö ‑wo ‑dho 'wëüga nu ‑a ‑dhë. 'Ö Zuda ‑yö yö Yesu ‑dɔ ‑an kwɛɛ 'töng ‑së ꞊mɛɛ' ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","꞊Bluu'‑ 'ö‑ ꞊bhɛɛpë 'yaa‑ 'piö bhë, ‑a 'wlaan‑ kë ‑yi ‑blɛɛzë 'ö ‑kë Paakö ‑waamayi, 'ö ꞊ya kë 'ö 'wo 'bhlanë ‑gbɔng ‑nu zë ‑na ‑a 'ka bhë ‑a 'ka, 'ö Yesu ‑bha ꞊guë' ‑nu ‑wa ꞊dhɛɛ' kpɔ 'wo‑ pö: «‑Dhɛ ‑mlë 'ü‑ 'piö kö 'yi dho ‑a ‑bha ü ‑bha Paakö ‑bhöpë ‑yuö kë ꞊dhia ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","'Ö Yesu ‑yö ö bha ꞊guë' ‑nu ꞊plɛ bɔ, ‑a ‑pö ‑an ‑dhë ‑sü 'ka ꞊nɛɛ: «‑Ka 'dho plöö; 'ka 'dho, 'ka ‑dho ‑kpën gɔɔn‑ do ‑bha kö 'yi ‑gbɔ ‑ya ‑gɔ; ‑ka ziö ‑a 'piö! ");
INSERT INTO dnj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ka 'plɛ ‑ka ‑da 'kɔ 'ö 'dhoë‑ ‑da ‑a 'gü bhë ‑a 'gü 'ka‑ pö 'kɔ 'ö bhë ‑a dëmɛ ‑dhë: ‹Yi Dëmɛ ‑yö ü ꞊dhɛɛ' 'kpɔ ‑na ꞊nɛɛ: Ö bha 'kɔdhi 'ö waa‑ ö bha ꞊guë' ‑nu 'wo dho Paakö ‑bhöpë ‑bhö ‑a 'gü bhë, ‑yö më ꞊ɛ?› ");
INSERT INTO dnj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","‑Yö ‑dho 'kɔdhi do 'ö‑ 'gü ‑dhɛ 'dhö ꞊va 'ö ‑dɔ kɔɔpë ‑nu 'dhiö ꞊ya ‑mɔ 'kuë ‑a 'gü bhë ‑a ‑zɔn ka ‑dhë, 'kɔ 'ö dɔ 'kɔ ‑ta dhuö bhë ‑a 'gü. ‑Dhɛ bhë ꞊nɛ, 'ka dho kwa ‑bha ‑bhöpë ‑yuö kë ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","'Ö ꞊guë' ‑nu ꞊plɛ 'wo bhë 'wo dho, 'wo pë ‑nu 'wo bhë 'wo‑ yö ꞊nɛ ‑kɔ 'ö Yesu ‑ya ꞊blɛɛ ‑a 'ka ‑an ‑dhë bhë ‑a 'dhö, 'ö 'wo Paakö ‑bhöpë ‑yuö ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","꞊Dhɛ 'kwa dɔ 'yinia, 'ö Yesu waa‑ ö bha ꞊guë' ‑nu 'wo to bhë, 'wo dho ‑dhɛ bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","‑Wo ‑kë pë ‑bhö ‑sü 'gü, 'ö Yesu ‑ya ‑pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Mɛ 'ka pë ‑bhö ‑na n 'piö zö ꞊nɛ, mɛ do ‑yö ka ziën 'ö dho n dɔ n yaagümɛ ‑nu kwɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","'Ö‑ ‑bha ꞊guë' ‑nu wöödhɛ ‑yö ‑siö, 'wo yö ‑a ꞊dhɛɛ' 'kpɔ ‑sü ‑bha do do 'ka ꞊nɛɛ: «Ma ‑mü ‑a?» ");
INSERT INTO dnj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","'Ö Yesu ‑ya pö ‑an ‑dhë: «Mɛ 'gɔɔ‑ do ö ga ꞊plɛ 'ka ꞊nɛ, mɛ do ‑mü ka ziën, mɛ 'ö 'yi yi ‑kɔ ‑sɔ ‑na gbɔ dɔ 'gü yi 'kuë bhë yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma Mɛgbö, n ga ‑sü ‑mü ꞊nɛ ‑kɔ 'ö pë 'ö ꞊bɛɛn' ‑sü 'ka n ‑wun 'gü ‑Zlan ‑bha 'sëëdhɛ 'gü, 'ö‑ pöë bhë ‑a 'dhö. 'Kɛɛ 'yena ‑wun ꞊ya kë gɔɔn‑ 'ö 'dhoë‑ n dɔ n yaagümɛ ‑nu kwɛɛ bhë ‑a 'ka! Mɛ 'ö bhë yaa bhɔ ‑bezë, ‑yö ‑dho kë ‑a ‑gɔ ‑së!» ");
INSERT INTO dnj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","‑Wo ‑kë pë ‑bhö ‑sü 'gü, 'ö Yesu ‑yö ꞊bluu'‑ ‑sü. ꞊Dhɛ 'ö ꞊ya ‑Zlan zuö pö ‑a ‑ta, 'ö‑ ‑kaan 'ö‑ nu ö bha ꞊guë' ‑nu ‑dhë 'ö‑ pö: «‑A mɛ 'ö ꞊nɛ, ‑kaa 'sü, 'ka‑ ‑bhö, yö ꞊nɛ 'ö tɔɔ n bun.» ");
INSERT INTO dnj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","'Ö ‑drɔɔn ‑kɔɔ do sü. ꞊Dhɛ ꞊ya yën ‑Zlan zuö pö ‑sü ‑bha ‑a ‑ta 'zü, 'ö‑ nu ‑an ‑dhë, 'yö ‑an 'plɛ ‑wa mü. ");
INSERT INTO dnj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑A mɛ 'ö ꞊nɛ 'ö tɔɔ n fɛi, 'ö ‑Zlan waa‑ mɛ 'bhee‑ ‑nu ‑an ‑bha ‑dhi 'kuë gën 'ka; ‑yö ‑lo 'dhö mɛdhɛvadhɛ ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: N 'ka 'dho ‑drɔɔn gbɛ mü gbɔ 'ö dho 'ö yöë ‑drɔɔn ‑dëü gbɛ 'a dho ‑a mü ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü yi ‑bha ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","꞊Dhɛ ꞊ya kë 'dhö, 'wo 'wlaan‑ ‑ta ‑tan ‑nu bho. 'Go mü, 'wo dho Olivie ‑tɔn tuö. ");
INSERT INTO dnj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «Ka 'plɛ, ka ‑dho n to 'töüdhö, 'ka ꞊duë. Bhii ‑yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: A ‑dho 'bhla ‑maakëmɛ zë, 'ö 'bhla ‑nu ‑wo ‑kan 'kuë‑, 'wo ‑pɛn. » ");
INSERT INTO dnj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","'Ö Yesu ‑ya pö 'zü: «'Kɛɛ ꞊ya kë ꞊nɛ, 'ma 'go ga 'gü, a ‑dho dho ka 'dhiö Galile ‑sɛ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","'Ö Piɛɛ ‑ya pö Yesu ‑dhë: «'Kö ‑kë ꞊nɛ mɛ 'wo to ‑wo ü ‑to, 'wo ꞊duë 'dhee, ma ‑zë, n 'ka 'dho go ü 'piö 'gbɛɛdhö.» ");
INSERT INTO dnj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","'Ö Yesu ‑ya pö ‑a ‑dhë: «A‑ ‑blɛɛ ü ‑dhë giagia 'ka ꞊nɛ, ꞊dɛɛ ꞊nɛ, ‑a gbeng ‑yi gia‑ 'gü, ‑a kë ‑yi 'ka kö ‑tɔgɔn ‑yaan 'we ‑gwaa ꞊plɛzë, ü ‑dho ‑a pö ‑gwaa ‑yaagazë 'bhaa n dɔ.» ");
INSERT INTO dnj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","'Kɛɛ Piɛɛ ‑ya ‑pö 'zü 'gbee‑ 'ka ꞊nɛɛ: «'Kö ‑kë ꞊nɛ, ko zë ‑sü ‑wun ‑mü 'dhee, n ‑kɔ yaa ‑mɔ ‑a ‑bha kö 'a‑ pö 'maa ü dɔ!» 'Ö ꞊guë' ‑nu mɛ 'wo to 'wo pë do bhë 'wo‑ pö 'pö. ");
INSERT INTO dnj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","‑Wo ‑dho 'wo ‑lo ‑dhɛ 'wo‑ ‑dhɛ Zesemane bhë ‑a ‑bha. 'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «‑Ka ‑ya zö kö 'a 'dho ꞊bhɛa' ꞊dhia!» ");
INSERT INTO dnj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","'Ö Piɛɛ 'dhö, Zakö waa‑ Zan 'yö ‑an sü ö 'piö, 'wo dho. 'Ö ‑bɔ 'klobhɔdhe 'gü ‑sü ‑wɛɛ ꞊va ‑yö ‑lo ‑a ‑ta; 'ö‑ ꞊zuö' ‑yö ‑da 'yena 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","'Ö‑ pö ‑an ‑dhë: «Ga 'yena ꞊ya n ꞊zuö' pa. ‑Ka 'to zö 'ka ‑ya ka 'yaan!» ");
INSERT INTO dnj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","'Yö ö 'bhe 'tee ꞊yɔɔn 'dhiö, 'ö ‑püö sia‑ ꞊bhɛa' ‑sü 'ka kö ‑yö kë 'dhö ꞊ya kë ꞊nɛ ‑a këdhɛ ‑dho kë ‑dhö kö ꞊kun 'ö 'yënngbhɔdhe dho nu ö ‑ta ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","'Ö‑ pö: «'Aa, n Dë! Ü ‑kɔ ‑yö ‑mɔ pë 'plɛ kë ‑sü ‑bha. A‑ 'piö kö 'yi 'güüzë 'ö ꞊nɛ 'ü‑ bhɔ n ‑dhë ꞊taa', 'kɛɛ 'maa‑ 'piö kö n ‑zo 'kun ‑wun ‑yö kë, pë 'a‑ 'piö 'yö tɔɔ bhi ‑zë, ü ‑zo 'kun ‑wun ‑yö kë.» ");
INSERT INTO dnj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","꞊Dhɛ ꞊ya kë 'dhö, 'ö nu ö bha ꞊guë' ‑nu ‑yaaga 'wo bhë ‑an 'piö, 'ö ‑an yö kö ꞊wa yi zë, 'ö‑ pö Simɔ Piɛɛ ‑dhë: «Simɔ, 'bha yi zë 'saadhö ꞊a? Ü 'ka ‑mɔa kö 'ü 'to ü 'yaan 'lɛlɛ do gia‑ 'piö a? ");
INSERT INTO dnj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","‑Ka ‑ya ka 'yaan 'ka ꞊bhɛa'‑, kö ꞊kun 'ka dho ‑püö 'güdandhe 'gü! A‑ ꞊tɛi' ‑dɔ ꞊nɛ ka‑ 'piö 'ka ‑ya ka 'yaan, 'kɛɛ ꞊faan' 'yaa ka bun ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","'Ö ‑yɛ ö 'zü ‑dëüwo, 'ö dho 'ö ꞊bhɛa, ‑wo do 'ö bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","'Ö ko 'zü, 'ö nu ö bha ꞊guë' ‑nu 'piö. 'Yö ‑an yö kö ‑wo yiö; bhii ‑an ‑kɔ yaa ‑mɔa kö ‑wo 'to wo 'yaan. 'Ö pë 'wo dho ‑a pö Yesu ‑dhë waa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","꞊Dhɛ 'ö ꞊ya nu ‑gwaa kë ‑yaaga ‑naa wo, 'ö‑ pö ‑an ‑dhë: «Ka ꞊tun yi zë ꞊a? Ka ka 'tɛɛ pa ‑na ‑a? ‑Yö 'to 'pö, 'lɛlɛ ꞊ya ‑lo. ‑Ka ‑dhɛ ‑ga, ma Mɛgbö, n dɔ ‑sü ‑mü ꞊sɔɔnyaamɛ ‑nu kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","‑Ka ꞊luu'‑ 'kwa ziö, bhii mɛ 'yö dho n dɔ ‑an kwɛɛ bhë 'yaa 'ma ꞊gbiin gbɔ.» ");
INSERT INTO dnj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu ‑yö ‑to 'wun ꞊blɛɛ' ꞊dhia, 'ö‑ ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë, ‑a mɛ 'wo‑ ‑dhɛ Zuda bhë 'ö ‑wo. Mɛ ‑gbaa 'ö ‑blaan ‑nu, 'lü 'klu ‑nu 'dhö ‑an ‑gɔ bhë ‑wo ‑kë ‑a 'piö. Mɛ ‑nu 'wo ‑an bɔ 'wo tɔɔ slabhomɛ ‑nu ‑gɔmɛ ‑nu, Zuifö ‑nu ‑bha tɔng ‑gɔmɛ ‑nu, waa‑ ‑an ‑bha mɛ ziizii ‑nu. ");
INSERT INTO dnj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Zuda 'ö Yesu dɔ ö yaagümɛ ‑nu kwɛɛ bhë ‑yö ꞊duakëpë 'ö dho ‑a kë ‑a ‑zɔn mɛ ‑nu 'ö wo ‑nu 'wo nu bhë ‑an ‑dhë 'ö‑ pö: «Mɛ 'a 'dhoë‑ ‑a 'kpeng mü ꞊sia, 'ö tɔɔ mɛ 'a‑ dɔ ka kwɛɛ bhë. ‑Kaa 'kun, 'ka dhoë ‑zo ‑kë ‑a 'piö ‑sü 'ka ‑së 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","꞊Dhɛ Zuda ꞊ya ‑lo, 'ö ꞊yɔɔn Yesu ‑bha, 'ö‑ pö ‑a ‑dhë: «N ‑Gɔmɛ!» 'ö to mü 'ö‑ 'kpeng mü. ");
INSERT INTO dnj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","'Ö mɛ ‑nu 'wo bhë 'wo ‑ya Yesu ‑bha, 'wo‑ kun. ");
INSERT INTO dnj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'Kɛɛ mɛ ‑nu 'wo ‑kë Yesu 'piö mü bhë, ‑a mɛ do ‑yö ö ‑bha ‑blaan ‑gan ö ‑kloo 'gü, 'ö slabhomɛ ꞊va ‑bha yuökëmɛ 'to 'klu ‑kan ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","'Ö Yesu ‑ya pö mɛ ‑nu 'wo nu ‑a 'kun ꞊dhia bhë ‑an ‑dhë: «‑Më ‑kë 'ka nu n 'kun ꞊dhia, ‑blaan waa‑ 'lü ‑nu ‑an 'ka ꞊nɛ ꞊dhɛ 'wo‑ pö ‑a ‑bha 'kpa pëyaakëmɛ ‑mü n 'ka ‑a 'dhö e? ");
INSERT INTO dnj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","‑Dhɛkpaɔyi 'saadhö 'ka, a ‑kë ka 'piö, kwa ‑bha ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, mɛ ‑nu ꞊daan' ꞊dhia, 'ö kaa n 'kun. 'Kɛɛ 'wun ‑nu 'wo ꞊nɛ ‑wo ‑kë 'dhö kö pë ‑nu 'wo ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü bhë ‑waan kë.» ");
INSERT INTO dnj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu 'plɛ ‑wa to, 'wo ꞊duë. ");
INSERT INTO dnj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","‑Dadhëü gɔɔn‑ do ö ‑kpatasɔ do 'kpaan ‑yö ‑kë ‑a ‑bha, ‑yö ‑kë ‑ziö Yesu 'piö ꞊dhia. 'Ö mɛ ‑nu ‑wo ‑lo ‑a ‑bha ‑waan ‑a 'kun, ");
INSERT INTO dnj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","'kɛɛ ‑yö ö ‑bha ‑kpatasɔ ‑to ‑an kwɛɛ, 'ö ꞊duë ö bun 'kpaan 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","‑Wo ‑dho Yesu 'ka slabhomɛ ꞊va 'dhiö, ‑dhɛ 'ö slabhomɛ ‑nu ‑gɔmɛ 'saadhö, mɛ ziizii ‑nu, Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu 'wo nu ‑a ‑bha wo 'ko ꞊bhaa bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛɛ ‑yö ‑ziö Yesu 'piö ‑gɛntozlöödhe 'ka, 'ö dho, 'ö ‑da slabhomɛ ꞊va bhë ‑a ‑gɔ 'kwɛandhö. 'Ö waa‑ 'yan ‑to 'kɔ ‑bha ‑mɛ ‑nu 'wo ‑kë ꞊yaannu ꞊dhia mü, 'nɛnɛ ‑bho ꞊dhia 'siö ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Slabhomɛ ‑nu ‑gɔmɛ ‑nu 'wo zakanmɛ ‑nu ꞊vava 'ka waa‑ zakanmɛ ‑nu ꞊vava 'saadhö 'wo to, ‑wo ‑yö 'wun 'wo dho ‑a dɔ Yesu ‑bha kö 'waan‑ zë ‑a ‑wun 'gü ‑a ꞊mɛɛ' ‑sü ‑bha, 'kɛɛ waa‑ yö. ");
INSERT INTO dnj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","'Ö tɔɔ mɛdhɛvadhɛ ‑wo ‑yö ꞊sua ‑wun ‑dɔ Yesu ‑bha ‑sü 'gü, 'kɛɛ ‑an ‑wo yaa kë do wo 'wun ꞊blɛɛ' ‑wo 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","꞊Dhɛ ꞊ya kë 'dhö, mɛ 'bhaa ‑nu ‑wo ‑luu, 'wo yö ꞊sua ‑wun ‑dɔ ‑a ‑bha ‑sü 'gü 'wo‑ pö: ");
INSERT INTO dnj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Yi‑ ‑ma ‑a 'dhii ꞊nɛ, ‑yö ‑dho ‑Zlan ‑gba ‑a 'gü ‑kɔ 'ö mɛ ‑nu ‑wa dɔ bhë ‑a wü, 'ö ‑dhɛkpaɔyi ‑yaaga 'ka 'ö‑ gbɛ 'ö yaa 'dho kë mɛ ‑nu ꞊kwaa' 'ö‑ dɔ.» ");
INSERT INTO dnj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","'Kɛɛ ‑dhɛ 'ö bhë ‑a ‑bha 'zü ‑an ‑wo yaa kë do. ");
INSERT INTO dnj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","꞊Dhɛ ꞊ya kë 'dhö, 'ö slabhomɛ ꞊va ‑yö ꞊luu mɛ 'plɛ wö 'dhiö mü, 'ö yö Yesu ꞊dhɛɛ' 'kpɔ ‑sü ‑bha 'ö‑ pö: «'Wun ‑nu 'wo‑ ꞊blɛɛ' ‑na ü ‑gɔ ꞊nɛ, ü 'ka 'dho ‑a gbɛ ‑daa kë ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'Kɛɛ Yesu ‑yö ö 'dhi ‑yö 'kuë‑, yaa‑ gbɛ ‑daa kë ‑a ‑gɔ. 'Ö slabhomɛ ꞊va ‑yö Yesu ꞊dhɛɛ' kpɔ 'zü, 'ö‑ pö: «‑Zlan 'ö ‑ziö pë 'plɛ ‑ta bhë, ü‑ Gbö 'ö ü ‑ya bhë ‑a 'ka a?» ");
INSERT INTO dnj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «꞊Ii‑, a‑ 'ka. 'Ö go mü, ka ‑dho ma Mɛgbö n yö kö a ‑ya ‑sü 'ka ‑Zlan 'piigbeezë ‑bha ‑yadhɛ ꞊bhlëzë ‑bha, 'ka dho n yö 'zü, kö a nu ‑na dha kpö ‑nu 'gü dhang‑ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","꞊Dhɛ ꞊ya kë 'dhö, 'ö slabhomɛ ꞊va ‑yö ö bha gblang ‑blë (‑naazuëdhe 'ka, 'ö tɔɔ 'wun 'ö Yesu ‑ya ꞊blɛɛ bhë ‑a ‑bha 'ka, ‑yö 'si ‑bho ‑Zlan ‑gɔ ‑sü 'ka). 'Ö‑ pö mɛ ‑nu 'wo ‑kë mü ‑an ‑dhë: «‑Më 'kwa‑ ‑yaa ‑bha ‑ɛ? Kwa 'ka 'dho ‑tɔmɔ gbɛ ꞊mɛɛ' gbɔ! ");
INSERT INTO dnj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","'Wun 'ö‑ ꞊blɛɛ ‑Zlan ‑gɔ bhë ka gia‑ ka‑ ‑ma. Ka ka ‑zo ‑ta ‑kɔklë ꞊ɛ?» 'Ö ‑an 'plɛ ‑wa pö ꞊ya kë 'wuën‑ ‑bha ‑mɛ 'ka, pë dho kë tɔɔ ‑wa zë. ");
INSERT INTO dnj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","'Ö ‑an ziën, mɛ ‑nu ‑wo yö wo 'dhee ‑bho Yesu ‑bha ‑sü 'gü, 'wo sɔ ‑klu ‑a wö ‑bha, 'wo yö ‑a ‑ma ‑sü 'gü wo ‑kɔ kpö ‑nu 'ka; 'wo‑ pö ‑a ‑dhë: «‑Bhö yië‑ ‑dɛ bɔ, dö 'ö ü ‑ma bhë ꞊ɛ?» 'Ö 'yan ‑to 'kɔ ‑bha ‑mɛ ‑nu ‑wo Yesu sü, 'wo yö ‑a 'to ‑ma ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piɛɛ ‑yö ‑kë 'kwɛandhɛ bhë ‑a 'dhëëdhö mü. ꞊Dhɛ 'ö slabhomɛ ‑nu ‑gɔmɛ ꞊va ‑bha yuökëdhe ꞊ya nu, ");
INSERT INTO dnj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","'ö‑ 'yan ‑yö ‑da Piɛɛ 'ö ‑kë ‑ya 'siö 'piö ꞊dhia bhë, ‑a ‑ta. ꞊Dhɛ ꞊yaa‑ ‑ga ‑së 'ka 'ö‑ pö: «Bhi ‑de 'pö ü ‑kë Yesu, Nazalɛtë mi bhë, ‑a 'piö.» ");
INSERT INTO dnj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'Kɛɛ Piɛɛ ‑yö ‑kploo Yesu ‑wun 'ka 'ö‑ pö: «'Maa‑ ꞊tɛi' dɔ, 'iin pë 'ü‑ 'piö kö 'ü‑ ꞊blɛɛ'‑ bhë 'maa‑ ‑gɛn dɔ.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö go 'kwɛandhɛ gia‑ ‑bha, 'ö dho 'ö dɔ ‑da 'kwɛandhö ‑dhɛ 'dhi ‑bha. 'Ö ‑tɔgɔn do ‑yö ‑we. ");
INSERT INTO dnj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","'Kɛɛ yuökëdhe bhë ‑ya ‑yö, 'ö yö ‑a ‑wun ꞊blɛɛ' ‑sü 'gü, mɛ ‑nu 'wo ‑kë mü ‑an ‑dhë ꞊nɛɛ: «Mɛ 'wo bhë ‑a mɛ do ‑mü gɔɔn‑ 'ö ꞊nɛ ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","'Ö Piɛɛ ‑yö ‑kploo 'zü ‑dëüwo. ꞊Dhɛ 'töng pë 'bhe ꞊ya ziö, 'ö mɛ ‑nu 'wo ‑kë mü, 'wo‑ pö Piɛɛ ‑dhë 'zü: «'Wun gia‑ 'ka, ü mɛ ‑nu 'wo bhë ‑a mɛ do 'ka, bhii 'ö tɔɔ bhi ‑de 'pö Galile mi ‑mü ü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","꞊Dhɛ ꞊ya kë 'dhö, 'ö Piɛɛ ‑ya pö: «꞊Ya kë ꞊sua 'ka, ‑Zlan ‑yö n 'klo bhɔ, a n ‑wo ‑bhö ꞊nɛ gɔɔn‑ 'ka‑ ‑bha 'wun ꞊blɛɛ' ‑na bhë 'maa‑ dɔ.» ");
INSERT INTO dnj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","‑Dhɛ do bhë ‑a 'gü, 'ö ‑tɔgɔn ‑yö ‑we ‑gwaa ꞊plɛ ‑naa wo. 'Ö Piɛɛ ‑zo ‑yö ‑büö, 'wun 'ö Yesu ‑ya ꞊blɛɛ ‑a ‑dhë 'ö‑ pö ‑a kë ‑sü 'ka kö ‑tɔgɔn ‑yö 'we ‑gwaa ꞊plɛzë, ‑yö ‑dho ‑a pö ‑gwaa ‑yaagazë, 'yaa ö dɔ bhë ‑a 'ka. 'Ö yö 'gbo bɔ ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","‑Dhiadhiö tii 'gü bhë, slabhomɛ ‑nu ‑gɔmɛ ‑nu, mɛ ziizii ‑nu, Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ zakanmɛ ‑nu ꞊vava 'saadhö 'wo to, ‑wo ‑dho wo 'ko ꞊bhaa kö 'wun ‑dhɛ 'yö ‑an ‑wo dhö to ‑a ‑bha do, ‑waan ‑a 'sü, 'wo Yesu ‑lö, 'wo nuë Pilatö ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","'Ö Pilatö ‑ya ꞊dhɛɛ' kpɔ, 'ö‑ pö: «Zuifö ‑nu ‑bha ‑gludë ‑mü ü 'ka a?» 'Ö Yesu ‑ya pö ‑a ‑dhë: «'Bha‑ ꞊blɛɛ'‑.» ");
INSERT INTO dnj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","'Ö slabhomɛ ‑nu ‑gɔmɛ ꞊vava ‑nu ‑wo yö 'wun ‑nu ꞊plëëzë ‑dɔ Yesu ‑bha ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","'Ö Pilatö ‑ya ꞊dhɛɛ' kpɔ 'zü ‑dëüwo 'ö‑ pö: «'Wun ‑nu 'wo‑ dɔ ‑na ü ‑bha ꞊nɛ 'bhaa‑ ma ꞊a? Ü 'ka 'dho ‑a gbɛ ‑daa kë ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","'Kɛɛ Yesu yaa‑ gbɛ ‑daa kë gbɔ, 'ö‑ ‑wun 'gü, 'tetundhe ꞊va ‑yö ‑da Pilatö ꞊zuö' 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Paakö 'wlaan‑ ‑yi 'saadhö 'ka, mɛ 'ö 'sɛgümɛ ‑nu 'dhö ‑a 'piö, kö Pilatö ‑ya bho ‑kanso 'gü wo ‑dhë, ‑ya bho ‑an ‑dhë ‑kanso 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","‑A 'töng 'dhö bhë ‑a 'ka, gɔɔn‑ do 'wo‑ ‑dhɛ Balaba waa‑ këpëyaamɛ ‑nu 'wo mɛ zë ‑a 'ka 'töng 'wo dɔa 'sɛ ꞊kɔɔnmɛ ‑nu ‑gɔ 'yënng ‑a 'ka bhë ‑yö ‑kë ‑kanso 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","'Ö 'sɛgümɛ ‑nu ‑gbaa ‑wo dho Pilatö 'piö. 'Ö pë ꞊ya kë 'ö‑ ‑kë ‑an ‑dhë ‑kplawo bhë 'wo‑ ‑dhɛ ‑a ‑gɔ kö ‑yaan kë wo ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","'Ö Pilatö ‑ya pö ‑an ‑dhë: «Ka‑ 'piö kö 'a Zuifö ‑nu ‑bha ‑gludë ꞊nɛ, 'a‑ bho mü ka ‑dhë ‑a?» ");
INSERT INTO dnj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bhii yö gia‑ ‑ya ꞊dɔa' ‑së 'ka ꞊nɛ ꞊druɛi ‑yö slabhomɛ ‑gɔmɛ ꞊vava ‑nu 'gü, 'ö tɔɔ 'sɛgümɛ ‑nu ‑wo Yesu ‑dhɔ ‑kë, pë 'ö ‑kë 'wo‑ dɔ ö kwɛɛ bhë 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","'Kɛɛ slabhomɛ ‑nu ‑gɔmɛ ꞊vava ‑nu ‑wo ‑gban 'sɛgümɛ ‑nu gbung bhë ‑an ‑bha kö ‑wa pö Pilatö ‑dhë ‑yö Balaba bho ‑kanso 'gü wo ‑dhë ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatö ‑yö ‑ko 'zü 'ö‑ pö mɛ gbung 'wo bhë ‑an ‑dhë: «‑Më 'ka‑ 'piö kö 'a‑ kë mɛ 'ka‑ ‑dhɛ Zuifö ‑nu ‑bha ‑gludë ꞊nɛ ‑a 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","'Wo‑ ‑daa ‑kë ‑a ‑gɔ ꞊gblaa 'gbla ‑sü 'ka ꞊nɛɛ: «‑Bhö ‑a zë, ‑a ‑dɔ ‑gaatalü ‑bha ‑sü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","'Ö Pilatö ‑yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «‑Më ‑wun yaa 'ö‑ ‑kë ‑ɛ?» 'Kɛɛ ‑an 'plɛ ‑wo ‑yö ꞊gblaa 'gbla ‑sü 'gü 'gbee‑ 'ka 'zü ꞊nɛɛ: «‑Bhö ‑a zë ‑a ‑dɔ ‑gaatalü ‑bha ‑sü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","'Yö mɛ gbung ‑nu ‑dhi ‑a ‑dhë ‑wun ‑kë ‑an ‑dhë 'ö Balaba bho ‑kanso 'gü. ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö 'dhasi ‑nu ‑dhë ‑wo Yesu ‑ma ‑klaa 'ka. 'Go mü, 'ö‑ ‑dɔ ‑an kwɛɛ kö ‑waan zë, ‑a ‑dɔ ‑gaatalü ‑bha ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","'Dhasi ‑nu ‑wo ‑dho Yesu 'ka 'sɛ ꞊kɔɔnmɛ Pilatö ‑gɔ 'kwɛandhɛ 'gbɛa 'wo‑ ‑dhɛ pletua bhë ‑a ‑bha. 'Wo wo 'bhamɛ ‑nu 'plɛ ꞊dhɔɔ ‑kë wo 'ko ꞊bhaa mü. ");
INSERT INTO dnj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","'Wo gblang nuɛazë ('ö ‑kë ꞊nɛ ‑gludë ‑nu ‑bha gblang 'dhö bhë, 'wo‑) ‑da Yesu ‑bha. Kö ‑a ꞊tɛi' ‑yö ‑kë ꞊nɛ woë‑ ‑gludë 'dhö, kö 'waan‑ duö 'luu ‑sü ‑a ‑bha. 'Wo 'ginng 'gɔ ꞊gblaa' do ‑kë, 'wo‑ ‑kë ‑a ‑bha 'gɔ ꞊gblaa' 'ka, 'wo‑ ‑ya ‑a ‑gɔ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'Wo yö ‑mɛɛ ‑kë ‑a 'ka ‑sü 'gü 'wo‑ pö: «Zuifö ‑nu ‑bha ‑gludë, 'bha ꞊büee!» ");
INSERT INTO dnj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","'Go mü 'wo‑ ‑ma 'lü 'në 'ka ö ‑gɔ ‑bha, 'wo wo 'dhee ‑nu bho ‑a ‑bha, 'wo ‑lo wo kpɔn 'gü ‑a 'dhiö, 'wo wo ‑de ꞊yɔɔn sia‑, ‑gblü ‑a 'dhiö ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","꞊Dhɛ ꞊wa yën duö 'luu ‑sü ‑a ‑bha ‑sü ‑bha, 'ö gblang nuɛazë bhë 'wo‑ bho ‑a ‑bha, 'wo‑ ‑de ‑bha sɔ ‑nu ‑da ‑a ‑bha, 'wo‑ sü, 'wo dhoë plaan kö 'waan‑ dɔ ‑gaatalü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","꞊Dhɛ 'wo 'dho ‑na kö gɔɔn‑ do 'ö ‑kë Silɛnë mi 'ka 'wo‑ ‑dhɛ Simɔ, 'ö ‑kë Alezandrë waa‑ Lifisö ‑an dë 'ka bhë, ‑wa ‑yö kö ‑yö ziö ‑na zian bhë ‑a ‑ta 'pö. ‑Yö ‑kë 'go ꞊dhia bhlö‑ ‑gbaa 'to ‑dhɛ ‑nu ‑bha. 'Ö 'dhasi ‑nu ‑wa 'gbee‑ ‑ta bho; 'ö Yesu ‑bha ‑gaatalü bun. ");
INSERT INTO dnj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","'Wo dhoë ‑dhɛ do 'wo‑ ‑dhɛ Gɔɔgota ‑a ‑bha, ‑a ‑gɛn 'ö tɔɔ «mɛ ‑gɔ ‑klëë ‑lo ‑dhɛ». ");
INSERT INTO dnj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","‑Drɔɔn 'wo 'miilö ꞊kaan ‑a 'ka bhë, 'wo‑ nu Yesu ‑dhë kö ‑yaan mü, (kö ‑a ‑bha 'klobhɔdhe ‑gɔ pë 'tee ‑yaan ga,) 'kɛɛ Yesu yaa‑ mü. ");
INSERT INTO dnj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","꞊Dhɛ ꞊ya kë 'dhö, 'wo‑ dɔ ‑gaatalü ‑bha, ꞊taan ‑gban ‑a ‑kɔ waa‑ ‑a ‑gɛn ‑nu ‑ta ‑sü 'ka. 'Wo‑ ‑bha sɔ ‑nu ‑glu wo 'ko 'ka 'töü‑ ‑bhö ‑sü 'ka kö mɛ 'ö ‑dhö ‑yaan ‑a mɛ 'ö dho kë ö ‑bha 'ka ‑a dɔ. ");
INSERT INTO dnj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","꞊Dhɛ 'wo‑ dɔ ‑na ‑gaatalü ‑bha kö 'kwa dɔ ‑dhiadhiö ‑lan 'tëë 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pë 'ö ‑kë ꞊bɛɛn' ‑sü 'ka ‑a zë ‑gɛn ‑wun 'gü, ‑a ‑gɔ ‑ta dhuö 'ö tɔɔ «Zuifö ‑nu ‑bha ‑gludë 'ö ꞊nɛ». ");
INSERT INTO dnj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","‑Wo mɛzëmɛ ꞊plɛ ‑dɔ ‑gaatalü ‑bha 'pö Yesu 'piö mü; ‑a mɛ do ‑yö ‑kë ‑a ꞊kwɛɛ‑ 'gü, 'ö‑ mɛ do ‑yö ‑kë 'pö ‑a ꞊kwaa‑ 'gü ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","‑Kɔ 'ö ꞊nɛ ‑a 'ka, 'ö pë 'ö ꞊bɛɛn' ‑sü 'ka ‑a ‑wun 'gü ‑Zlan ‑bha 'sëëdhɛ 'gü 'yö ꞊kaa' ꞊nɛɛ: ‑Wa ‑da këpëyaamɛ ‑nu ‑bhüö 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mɛ ‑nu 'wo ‑kë ziö ꞊dhia mü, ‑wo wo ‑gɔ ‑zë 'gü, 'si ‑nu ‑bho ‑a ‑gɔ ‑sü 'ka, 'wo‑ pö ‑a ‑dhë: «'Ii, ü 'dhɛ bhë! Bhi 'ü‑ pö 'ü ‑dhö ‑Zlan ‑gba ‑a 'gü ‑kɔ wü, kö ‑dhɛkpaɔyi ‑yaaga 'ka 'üën‑ ‑a gbɛ dɔ bhë! ");
INSERT INTO dnj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ü ‑de dha 'ü ꞊yɔɔ'‑ 'ü 'go ‑gaatalü ‑bha 'sa!» ");
INSERT INTO dnj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","'Ö slabhomɛ ‑gɔmɛ ‑nu waa‑ tɔnggɔmɛ ‑nu ‑wo duö 'luu sü Yesu ‑bha 'pö, 'wo‑ pö wo 'ko ziën ꞊nɛɛ: «Mɛ 'waa ‑nu dha 'yö‑ wo, 'kɛɛ yaa ‑mɔ ‑a ‑bha kö ‑yö ö ‑de dha! ");
INSERT INTO dnj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bhi 'ü‑ pö ü ‑Zlan ‑bha ‑Yamɛ ‑mü ü 'ka, 'ü Izlaɛlö ‑bha ‑gludë 'ka, ‑bhö ꞊yɔɔ'‑ 'ü 'go ‑gaatalü ‑bha 'sabla 'sa! ꞊Ya kë ꞊nɛ, 'bha ꞊yɔɔ'‑ ꞊sia, yi ‑dho ü ‑wun ‑dhɛ 'wun gia‑!» 'Ö mɛ ‑nu 'wo ‑an dɔ ‑gaatalü ‑bha ‑a 'piö mü bhë 'wo 'si ‑nu bho ‑a ‑gɔ 'pö. ");
INSERT INTO dnj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","꞊Dhɛ 'ö lënng 'gü ‑dhɛ ꞊ya dɔ, 'ö ‑dhɛ ‑trö 'sënsëndhö 'kpongtaadhɛ 'plɛ ‑bha. ꞊Dhɛ 'ö ‑dhɛ 'dhö 'po ‑na kö 'kwa dɔ 'wɔ 'yɛ ‑lan 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","'Ö 'wɔ 'yɛ ‑lan gia‑ bhë ‑a 'ka Yesu ‑yö ‑gbla 'gbee‑ 'ka, Eblö ‑wo 'gü 'ö‑ pö: «Eloi, Eloi, lama sabasötani?» (‑A ‑gɛn 'ö tɔɔ: «N ‑ma ‑Zlan, n ‑ma ‑Zlan, ‑më ‑kë 'ü ü ꞊kwaa n ‑wun ‑zü ‑i?») ");
INSERT INTO dnj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mɛ ‑nu 'wo ‑kë mü, ‑a mɛ 'bhaa ‑nu ‑wa ‑wo ‑ma 'wo‑ pö: «‑Ka ka 'to 'to, ‑yö Eli ꞊dhɔɔ kë ‑na!» ");
INSERT INTO dnj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Ö ‑an ziën mɛ do ‑yö dho ‑bla 'ka, 'ö ꞊fuu'‑ zë ‑drɔɔn 'yi ꞊gliisü, 'ö ‑kë 'dhasi ‑nu müpë 'ka bhë ‑a 'ka. 'Ö‑ ‑ya 'lü 'në 'dhiö, 'ö nuë 'ö‑ ‑zɔn Yesu 'dhi 'ka kö ‑yaan ‑a 'yi mü, 'ö‑ pö: «‑Ka dɔ, ꞊ya kë ꞊nɛ Eli ‑dho nu 'ö‑ bho ‑gaatalü ‑bha kö 'kwaa‑ yö!» ");
INSERT INTO dnj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'Kɛɛ Yesu ‑yö ‑gbla 'gbee‑ 'ka, 'ö to mü, 'ö ga. ");
INSERT INTO dnj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","'Ö ‑dhɛ 'slööslö ‑dhɛ waa‑ ‑dhɛ 'slööslö ‑dhɛ ꞊duö, ‑an 'gü ‑kan 'gü ‑sɔ 'ö plöö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü bhë, 'ö ‑pɛ dhuö kpengdhö 'ö nu 'ö ‑zuö ‑a 'ka sia‑. ");
INSERT INTO dnj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wlɔmë ‑mɛ ‑nu ‑bha 'dhasi ‑gɔmɛ 'ö ‑kë dɔ ‑sü 'ka Yesu 'dhiö ‑dhɛ gia‑ ‑bha bhë, ‑tɔn tuö mü bhë, ꞊dhɛ ꞊yaa‑ ga ‑kɔ yö 'ö‑ pö: «Mɛ 'ö ꞊nɛ ‑Zlan Gbö giagia ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Dhoo ‑nu 'bhaa ‑nu 'wo dɔ ꞊gbiin, ‑dhɛ ‑ga ꞊dhia, ‑wo ‑kë mü. 'Ö ‑an ziën Mali 'yö go Madala, waa‑ Zoze waa‑ ö 'zlaa‑ Zakö ‑an dhe Mali, waa‑ Salome ‑wo ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","‑Wo ‑kë ‑ziö Yesu 'piö ꞊dhia kö ‑yö Galile ‑sɛ 'gü, 'wo yuö ‑nu ‑kë ‑a 'dhiö. 'Ö ‑dhɛ 'ö bhë ‑a 'gü 'zü, dhoo ‑nu ꞊plëëzë gbɛ 'wo nu ‑dɔ ‑a ‑gɔ ꞊dhia Zeluzalɛmë plöö, 'wo ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","꞊Dhɛ 'yinia ‑dhɛ ꞊ya dɔ, 'ö ꞊dhɛ ‑kë ꞊nɛ ‑yö ‑kë Paakö 'wlaan‑ ‑de ‑pë kë ‑yi, 'ö ‑kë Zuifö ‑nu ‑bha ꞊glooyi ‑waamayi 'ka ‑a 'ka, ");
INSERT INTO dnj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zozɛfu 'ö go Alimate ‑yö ‑kë zakanmɛ ꞊va do 'ö mɛ ‑nu ‑wa ꞊bhlë ‑ya ‑a 'ka. Yö ‑de 'pö, ‑yö ‑kë ‑ya ꞊dhia ‑Zlan ‑bha ‑gludëdhɛ ‑bha nu ‑sü ‑gɔ. 'Yö ‑nu 'ö ö ‑zo dɔ 'gbee‑, 'ö dho Pilatö 'piö, 'ö Yesu ꞊glöö ‑dhɛ ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","'Kɛɛ ꞊dhɛ 'ö Pilatö ‑ya ma ꞊nɛ Yesu ꞊ya ga 'saadhö, ‑a 'te ‑yö ‑tun, 'ö mɛ bɔ 'dhasi ‑gɔmɛ ‑dhë. 'Ö nu, 'yö‑ ꞊dhɛɛ' kpɔ ꞊nɛ ꞊dhɛ Yesu ‑yö ga bhë, ‑a ‑dhɛ ꞊ya ꞊glɔɔ ꞊a? ");
INSERT INTO dnj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","꞊Dhɛ 'ö 'dhasi ‑gɔmɛ ꞊yaa‑ ‑daa kë ‑a ‑gɔ, 'ö ‑we ‑a ‑bha Zozɛfu ‑gɔ kö ‑yö Yesu ꞊glöö 'sü. ");
INSERT INTO dnj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zozɛfu ‑yö 'glöö 'puu ‑dhɔ, 'ö Yesu ꞊glöö bho ‑gaatalü ‑bha, 'ö dhoë mɛ ‑bin ‑guö ‑du do 'wo yuö ‑kë ‑a 'gü, 'ö ‑guö 'fa ꞊va do 'ö ‑kë ‑a ‑te 'ka, 'yö‑ ꞊glöng glö, 'ö‑ yö ‑du bhë ‑a 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mali 'go Madala waa‑ Mali Zakö dhe ‑wo ‑kë mü 'ö ‑dhɛ 'wo Yesu ‑bin ‑a ‑bha bhë 'wo‑ ‑yö. ");
INSERT INTO dnj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Zuifö ‑nu ‑bha ꞊glooyi bhë, ‑a 'yinia 'piö (kö 'waa ꞊glooyi ‑bha tɔng ꞊löö gbɔ), 'ö Mali 'go Madala 'dhö, Zakö dhe Mali 'dhö, waa‑ Salome ‑nu 'wo pë 'yɔn 'tëë ‑sëëzë ‑nu dhɔ kö 'waan‑ dhoë 'waan‑ kë Yesu ꞊glöö ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya 'po, ‑dhiadhiö kö lan‑ ‑yö ꞊luu'‑ ‑na bhë, 'wo ‑ziö 'wo dho blɔɔn‑ ꞊taa 'ma. ");
INSERT INTO dnj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","‑An 'dho ‑sü 'ka, ‑wa ‑pö wo 'ko ‑dhë: «Dö 'ö dho ‑guö 'fa 'ö blɔɔn‑ 'dhiö ꞊nɛ, ‑a bho kwa ‑dhë mü ꞊i?» ");
INSERT INTO dnj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","'Kɛɛ ꞊dhɛ 'ö ꞊wa ‑lo mü, 'wo ‑dhɛ ‑ga, 'ö 'wo ‑guö 'fa ꞊va 'ö blɔɔn‑ 'dhi ta bhë, 'wo‑ yö kö ꞊ya 'go ‑a 'dhiö, ‑yö wɔ ‑sü 'ka 'pian gbɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","'Wo ‑sɔ ꞊duudhö mü; 'wo ‑Zlan ‑bha bɔmɛ do 'ö gblang 'puu ‑yö ‑kë ‑a ‑bha, ‑a yö kö ‑yö ‑ya ‑sü 'ka ‑an ꞊kwɛɛ‑ 'gü ꞊zian'. 'Ö 'siö‑ ‑kan ‑an 'gluu. ");
INSERT INTO dnj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö ‑an ‑dhë: «Kö ꞊kun 'siö‑ ‑kan ka 'gluu! Yesu, Nazalɛtë mi 'ö mɛ ‑nu ‑wa dɔ ‑gaatalü ‑bha bhë 'ka‑ ꞊mɛɛ ꞊a? ꞊Ɛɛ, 'kɛɛ ꞊ya 'go ga 'gü, 'yaa zö gbɔ. ‑Ka ‑dhɛ ‑ga, ‑dhɛ 'wo‑ ‑wɔ ‑a ‑bha yö ꞊ga ꞊nɛ! ");
INSERT INTO dnj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","‑Ka 'dho 'ka‑ pö ‑a ‑bha ꞊guë' ‑nu ‑dhë, 'go mü 'zü, 'ka‑ pö Piɛɛ gia‑ ‑dhë: ‑Yö 'dho ‑na ka 'dhiö Galile, ‑dhɛ bhë 'ka dho ö yö ‑a ‑bha ꞊nɛ ‑kɔ 'yö‑ ꞊blɛɛ ‑a 'ka ka ‑dhë 'dhiö bhë ‑a 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","'Wo yö plaan 'wo ꞊duë, 'wo dho blɔɔn‑ bhë ‑a 'ka ꞊gbiin. Bhii 'ö tɔɔ ‑wo ‑kë ꞊zluun ‑sü 'gü 'suö 'ka, 'ö waa‑ ꞊blɛɛ'‑ mɛ gbɛ ‑dhë, 'suö 'ö ‑kë ‑an 'gü bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","꞊Dhɛ Yesu ꞊ya 'go ga 'gü 'dhö, ‑dhiadhiö bhë ‑a 'ka, ‑yö ö ‑de ‑zɔn ‑blɛɛzë 'ka Mali 'go Madala, 'ö ‑zuu yaa 'slaplɛ bho ‑a 'gü 'dhiö bhë ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","'Ö dho 'ö‑ ꞊blɛɛ Yesu ‑bha mɛ ‑nu 'wo ‑kë ‑a 'piö 'dhiö bhë ‑an ‑dhë. ‑Wo ‑kë 'gbo bɔ ꞊dhia 'yenazë 'ka, Yesu ‑bha ga ‑sü ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","'Kɛɛ ꞊dhɛ 'ö Mali ‑wo ꞊nɛ ꞊waa‑ ma ꞊nɛ ‑ya ‑pö «Yesu ꞊ya 'go ga 'gü 'ya ‑kpën ‑a ‑bha» waa‑ ‑wo ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ö ‑de ‑zɔn ö bha ꞊guë' ꞊plɛ 'wo ‑kë 'dho ꞊dhia ‑dhɛ 'bhaa ‑bha ‑an ‑dhë ‑kɔ 'bhaa 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","'Wo nu 'wo‑ ꞊blɛɛ mɛ 'wo to ‑an ‑dhë, 'kɛɛ wo ‑de 'pö, waa ‑an ‑wo ‑dhɛ 'wun gia‑ 'pö. ");
INSERT INTO dnj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ö ‑de ‑zɔn ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga do 'wo to bhë ‑an ‑dhë kö ‑wo pë ‑bhö ‑sü 'gü. ‑Yö 'wun ‑blɛɛ ‑an 'ka, ‑zo yö ö ‑bha ‑sü yaa kë ‑an ‑gɔ, 'ö ‑an ꞊gɔü' ‑yö ‑kë 'gbee‑ bhë ‑a ‑wun 'gü, 'ö tɔɔ mɛ ‑nu ‑wo ö 'bhee‑ ‑yö, 'wo‑ ꞊blɛɛ ‑an ‑dhë bhë 'ö waa ‑an ‑wo ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","'Go mü 'ö‑ pö ‑an ‑dhë: «‑Ka 'dho 'kpongtaadhɛ 'saadhö ‑a 'gü, 'ka 'wuntaɔsë 'ö ꞊nɛ 'ka‑ ꞊blɛɛ'‑ mɛ 'kpɛkpɛ ‑dhë! ");
INSERT INTO dnj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mɛ 'ö ꞊ya n ‑wun ‑dhɛ 'wun gia‑, 'wo dho ‑a bɔ yiö n 'tɔ 'ka, ‑yö ‑dho dha; 'kɛɛ mɛ yaa n ‑wun ‑dhɛ 'wun gia‑, za ‑dho ‑lo ‑a tuö, 'yö‑ 'klo ‑yö bhɔ. ");
INSERT INTO dnj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","'Go mü ‑dhidhaapë 'ö mɛ ‑nu ꞊wa n ‑wun ‑dhɛ 'wun gia‑, 'wo dho ‑an kë 'ö tɔɔ: ‑Wo ‑dho ‑zuu yaa bho mɛ ‑nu 'gü n 'tɔ 'ka, 'wo dho 'wun ‑nu ꞊blɛɛ'‑ ‑wo 'waa gbɛ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","‑Wo ‑dho ‑mɔ ‑a ‑bha 'wo ꞊mɛɛ sü wo kwɛɛ, 'iin ꞊ya kë ꞊nɛ 'yi ꞊suu'‑ 'saadhö 'ö mɛ zë ‑pë 'dhö ‑a ꞊bhaa, ꞊waa‑ mü, pë gbɛ 'ka 'dho kë ‑an 'ka; ‑wo ‑dho wo ‑kɔ ‑nu kpa 'yuamɛ ‑nu ‑ta, 'ö ‑an ‑bha 'yua ‑nu ‑wo bo.» ");
INSERT INTO dnj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","꞊Dhɛ 'ö kwa Dëmɛ Yesu ꞊ya yën 'wun ‑nu 'wo ꞊nɛ ‑an ꞊blɛɛ' ‑sü ‑bha, 'ö ‑Zlan ‑ya ꞊luu, 'ö dho dhang‑ 'gü, 'ö ‑ya ‑Zlan ‑bha ‑yadhɛ ꞊bhlëzë ‑bha. ");
INSERT INTO dnj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo dho, 'wo ‑ya 'wuntaɔsë ꞊blɛɛ' ‑sü ‑bha ‑dhɛ 'saadhö 'gü. Kwa Dëmɛ gia‑ ‑yö yuö ‑kë ‑an ‑kɔ 'piö ‑dhidhaapë ‑nu kë ‑sü 'ka kö ‑yaan ‑zɔn ꞊nɛ 'wuntaɔsë 'wo‑ ꞊blɛɛ' ‑na bhë 'wun gia‑ ‑mü.");
INSERT INTO dnj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ma mɛ ‑wungbeezë Teofilö, mɛdhɛvadhɛ ꞊waa‑ këdhɛ ꞊mɛɛ'‑ kö 'wun ‑nu 'wo ‑kë yi ‑sɛ 'gü 'ö ‑gban Yesu Klito ‑bha bhë ‑waan ‑ya 'sëëdhɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","'Wun ‑nu 'wo ‑kë 'ma bhë ‑wo ‑nu 'wo‑ ꞊blɛɛ yi ‑dhë ꞊nɛ ‑kɔ 'ö mɛ ‑nu 'wo ‑kë mü ‑a züdɔyi 'ka, 'ö ‑kë ‑an 'yaan, 'ö ‑Zlan ‑wo pö ‑sü ‑yö ‑kë ‑an ‑bha yuö 'ka, 'wo‑ ꞊blɛɛ ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","꞊Dhɛ ꞊ya kë 'dhö, ma ‑de 'pö a ꞊dhɛɛ' ‑nu ‑kpɔ; 'ö ma ꞊dhɛɛ' ‑nu ‑wo ‑gban pë ‑nu 'wo ‑kë ‑a züdɔyi 'ka kpinngdhö ‑an ‑bha. 'Yö ꞊dhɛ 'a‑ ‑ga ‑a 'gü bhë, n dë, n ‑ma 'ka, ‑yö ‑kë n ‑dhë ‑së kö 'aan‑ ꞊blɛɛ'‑ ü ‑dhë, ‑a ‑ya 'sëëdhɛ ‑ta ‑sü 'ka ꞊nɛ ‑kɔ ‑de bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","‑Yö ‑kë 'dhö kö 'üën‑ 'wun gia‑ dɔ mɛ ꞊daan' ‑wo 'wo ü ꞊daan 'ka bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","'Töng 'ö Elɔdö ‑yö ꞊kaa' ‑gludë 'ka Zude ‑sɛ 'gü, slabhomɛ 'wo‑ ‑dhɛ Zakali ‑yö ‑kë mü, ‑yö ‑kë Abia ‑bha slabhomɛ kpö 'ö bhë ‑a 'gü ‑mɛ do 'ka. ‑A ‑bha dhebɔ Elizabɛtö ‑de 'pö ‑yö ‑kë Aalɔn 'yö ‑kë slabhomɛ ꞊va 'ka bhë ‑a ꞊suu'‑ ‑ta 'në dhe do 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","꞊Dhɛ 'wo‑ ‑bha ꞊plɛ ‑wo ‑kë ‑Zlan wö 'dhiö kpengdhö; 'wo 'wun ma ‑Zlan ‑bha tɔng ‑nu waa‑ ‑a ‑bha ‑dhiodɔwo ‑nu 'töüdhö ‑an ‑ta 'fɛfɛdhö. ");
INSERT INTO dnj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","'Kɛɛ 'në gbɛ yaa kë ‑an ‑gɔ, bhii 'ö tɔɔ Elizabɛtö ‑yö ‑kë 'bhüödhe 'ka; yö do bhë 'zü, kö ‑dhɛ 'wo‑ ‑bha ꞊plɛ ꞊wa kë ꞊klöö. ");
INSERT INTO dnj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yi do 'ka Zakali ‑yö ‑kë yuö 'dhiö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, bhii ‑yö ‑kë slabhomɛ ‑nu kpö mɛ 'ö ‑kë ‑a 'gü bhë ‑an ‑bha yi 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","‑A yi bhë ‑a 'ka ‑wo 'töü‑ ‑bhö ꞊nɛ ‑kɔ 'ö ‑an ‑bha slabhomɛ ‑nu ‑bha wɔ 'dho ‑a 'ka ‑a 'dhö. 'Ö 'töü‑ ‑yö Zakali sü, 'yö dho ‑dhɛ 'slööslö ‑dhɛ 'gü pë 'tëë ‑sëëzë 'wo‑ ‑dhɛ ansaan bhë ‑a 'güö ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zuifö ‑nu gbung ‑wo ‑kë plaan ꞊bhɛa' ꞊dhia 'yasa 'gü 'lɛlɛ 'yö ansaan ‑güö ‑a 'ka bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑Zlan ‑bha bɔmɛ do ‑yö ‑wo Zakali 'dhiö mü, ‑Zlan ‑bha sla‑ ‑bho ‑a ‑ta ‑pë 'wo ansaan ‑güö ‑na ‑a ‑ta bhë ‑a 'pian 'ö ꞊kwɛɛ‑ 'gü ꞊zian' ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","꞊Dhɛ 'ö Zakali ‑ya yö, 'yö 'siö ‑yö ‑kan ‑a 'gluu, 'ö 'suö ‑ya ‑kë. ");
INSERT INTO dnj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","'Yö ‑Zlan ‑bha bɔmɛ ‑ya ‑pö ‑a ‑dhë: «Kö ꞊kun 'ü ‑suö, Zakali, bhii ‑Zlan ꞊ya ü bha ꞊bhɛa' ‑wo ma 'saadhö, ü bha dhebɔ Elizabɛtö ‑dho 'në gɔɔn‑ do kpɔ ü ‑gɔ; ü ‑dho ‑a ‑dhɛ Zan. ");
INSERT INTO dnj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","‑Yö ‑dho kë ü ꞊zuögludhi ‑wun 'ka, 'go mü mɛdhɛvadhɛ ‑wo ‑dho ‑a ‑bha bhɔ ‑sü 'gludhi kë, ");
INSERT INTO dnj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","bhii ‑yö ‑dho kë mɛ ꞊va do 'ka ‑Zlan wö 'dhiö. Yö 'ka 'dho ‑drɔɔn 'iin müpë ‑nu 'dhiözë gbɛ mü; ‑yö ‑dho pa ‑Zuu 'slööslö 'ka, 'yö bhɔa. ");
INSERT INTO dnj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","‑Yö ‑dho nu Izlaɛlö 'në ‑nu ꞊va 'ka Dëmɛ wo ‑bha ‑Zlan 'piö; ");
INSERT INTO dnj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","yö gia‑ ‑de ‑yö ‑dho 'ta ‑sü ‑a 'dhiö ‑Zuu 'slööslö waa‑ 'piigbeedhɛ 'ö ‑kë ‑Zlan ‑wodhiölomɛ Eli 'gü 'pö bhë ‑a 'ka kö ‑yaan 'në ‑nu waa‑ wo dë ‑nu ‑an kë do, kö ‑yaan nu mɛ ‑nu 'wo dɔ ‑Zlan ‑gɔ 'yënng ‑mɛ 'ka ‑an 'ka ‑waan kë 'kpaakpa ꞊nɛ mɛ kpengdhö ‑nu 'dhö. ‑Yö ‑dho 'sɛgümɛ ‑nu ‑ya 'yaan Dëmɛ ‑bha 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","꞊Dhɛ ‑kë 'dhö, 'ö Zakali ‑ya ‑pö ‑Zlan ‑bha bɔmɛ bhë ‑a ‑dhë: «‑Yö ‑dho kë ‑kɔklë kö 'wun 'ö ꞊nɛ 'aan‑ ‑dhɛ 'wun gia‑, 'kɛɛ kö ma 'dhö, ma dhebɔ 'dhö 'yië kë ꞊klöö 'saadhö ꞊nɛ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'Ö ‑Zlan ‑bha bɔmɛ ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «N tɔɔ Gabliɛlö, ma ꞊nɛ a dɔ ‑sü 'ka ‑Zlan wö 'dhiö kö 'aan‑ ‑a ‑bha yuö kë; ‑yö n ‑bɔ kö ‑naɔ ‑së 'ö bhë 'aan‑ bɔ ü ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","꞊Dhɛ ‑kë ꞊nɛ 'wun ‑nu 'ö 'a ‑an ‑blɛɛ ü ‑dhë bhë, ü 'ka ‑an ‑dhɛ 'wun gia‑, 'kɛɛ kö ‑a 'töng ꞊ya ‑lo ꞊sia, ‑an ‑de ‑dho kë bhë, ‑a ‑wun 'gü ü ‑dho kë 'tuunmɛ 'ka; ü ‑kɔ yaa 'dho ‑mɔ ‑a ‑bha kö 'üën‑ 'wun ꞊blɛɛ'‑ ‑yaan 'dho ‑yaan yöë pë ‑nu 'wo bhë ‑an kë ‑yi ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","꞊Dhɛ kë ‑na 'pö zlöö kö mɛ gbung ‑nu 'wo ‑kë ꞊bhɛa' ꞊dhia plaan 'yasa 'gü bhë ‑an 'te ꞊ya tun ꞊glɔɔ 'ö Zakali ꞊yaa‑ wo ‑dhɛ 'slööslö ‑dhɛ 'gü bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","'Kɛɛ ꞊dhɛ 'ö yö plaan, yaa ‑mɔ ‑a ‑bha kö ‑yö 'wun ꞊blɛɛ'‑, 'ö mɛ ‑nu 'wo ‑kë mü 'wo‑ ꞊tɛi' dɔ ꞊nɛ Zakali ꞊ya 'yanpiöpë do 'bhaa yö ‑dhɛ 'slööslö ‑dhɛ bhë ‑a 'gü. 'Ö Zakali ‑yö 'wun ꞊blɛɛ ‑an ‑dhë ö ‑kɔ 'gü, 'yö to 'tuunmɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yi 'ö Zakali dho ö bha yuö kaa ‑Zlan ‑gɔ kɔɔ mü bhë, ꞊dhɛ ꞊ya yën, ‑yö ‑dho ö ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","꞊Dhɛ 'töng 'bhaa ꞊ya ziö, 'ö Elizabɛtö 'yö ‑kë ‑a bɔɔ 'ka bhë, 'ö 'gu sü, 'yö ö ‑de ‑bin 'su 'sɔɔdhu 'piö, ‑a ‑pö ö ‑de ‑dhë ‑sü 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Pë 'ö n Dëmɛ ‑ya ‑kë n ‑wun 'gü bhë, ‑kaa ‑ga 'dhɛ: ‑Yö ‑kë ‑a ‑dhë ‑së kö pë 'ö ‑kë ma lë‑ ‑wun 'ka mɛ 'bhee‑ ‑nu wö 'dhiö bhë ‑yaan ‑a bho n ‑ma.» ");
INSERT INTO dnj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","꞊Dhɛ ꞊ya kë 'dhö ‑a 'su kë 'slado ‑naa bhë, 'ö ‑Zlan ‑yö ö bha bɔmɛ Gabliɛlö ‑bɔ Galile ‑pö do 'wo‑ ‑dhɛ Nazalɛtë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","'Yö dho 'nëdhezë 'ö yaa gɔɔn‑ ‑wun ꞊tɛi' dɔ ꞊kun, 'ö‑ ‑bha ‑zo ‑tën ‑a ‑dhë ‑mɛ bhë 'wo‑ ‑dhɛ Zozɛfu, 'ö ‑kë ‑gludë Davidö ‑gɔ 'kɔɔmɛ ‑nu ꞊suu'‑ ‑ta do 'ka bhë ‑a 'piö. 'Nëdhezë 'yö bhë ‑a tɔɔ Mali. ");
INSERT INTO dnj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","꞊Dhɛ 'ö ‑Zlan ‑bha bɔmɛ ‑yö ‑da ‑a ‑gɔ kɔɔ, 'yö‑ pö ‑a ‑dhë: «'Bha ꞊büee! ‑Zlan ꞊ya 'wun ‑së ꞊va kë ü ‑dhë! Dëmɛ ‑yö ü 'piö!» ");
INSERT INTO dnj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Ö 'siö ‑yö ‑kan Mali 'gluu ‑büödawo ꞊suu'‑ 'ö bhë ‑a ‑wun 'gü, 'yö‑ pö ö ꞊zuö' 'piö: «‑Büödawo ꞊suu'‑ 'ö ꞊nɛ ‑a ‑gɛn tɔɔ ‑më ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑Zlan ‑bha bɔmɛ ‑ya ‑pö ‑a ‑dhë: «Kö ꞊kun 'ö 'suö ‑yö ü ‑kë, Mali, bhii ‑Zlan ꞊ya ö 'yan ‑së bɔ ü 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ü ‑dho 'gu sü, 'ü 'në gɔɔn‑ do kpɔ; 'ü ‑dho ‑a ‑dhɛ Yesu. ");
INSERT INTO dnj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","‑Yö ‑dho kë ꞊va, 'ö mɛ ‑nu dho ‑a ‑dhɛ ‑Zlan 'ö ‑ziö pë 'plɛ ‑ta bhë ‑a Gbö. Dëmɛ ‑Zlan ‑yö ‑dho ‑a kë ‑gludë 'ka ꞊nɛ ‑kɔ 'ö‑ 'bhɛma Davidö ꞊kaa' 'dhiö bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","'Go mü ‑yö ‑dho Izlaɛlö ‑sɛ ꞊kɔɔn ꞊toëpö 'ka; ‑a ‑bha mɛkɔɔnsü 'ö bhë, ‑a 'dhiötodhɛ yaa 'dho kë ‑dhö.» ");
INSERT INTO dnj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","'Ö Mali ‑ya pö ‑Zlan ‑bha bɔmɛ bhë ‑a ‑dhë: «'Wun ꞊nɛ ‑a kë ‑kɔ ‑dho kë ‑kɔklë, 'kɛɛ kö n 'ka gɔɔn‑ ‑wun ꞊tɛi' dɔ ꞊kun ꞊nɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'Ö ‑Zlan ‑bha bɔmɛ ‑ya pö ‑a ‑dhë: «‑Zuu 'slööslö ‑yö ‑dho nu ü 'gü, 'ö ‑Zlan 'ö ‑ziö pë 'plɛ ‑ta bhë, 'ö‑ ‑bha 'piigbeedhɛ dho kpa ü ‑ta ꞊nɛ ‑dhɛbiëndhɛ 'dhö. Pë 'ö ‑kë 'ö 'në 'ö 'dhoë‑ bhɔ bhë 'wo dho ‑a ‑dhɛ: Mɛ 'ö 'slööslö 'yö ‑Zlan Gbö 'ka bhë 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elizabɛtö 'ö ka ‑nu 'ka ‑mɛɛzë bhë, yö ‑de 'pö ‑yö 'guzë, 'kɛɛ kö ꞊ya kë ꞊klöö; 'ö yö do bhë 'zü, mɛ ‑nu ‑wa pö ‑be ö 'ka 'dho 'në kpɔ bhë, ꞊dɛɛ ꞊nɛ ‑a 'gü ‑yö 'guzë ‑a 'su 'slado 'ö ꞊nɛ. ");
INSERT INTO dnj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bhii ‑Zlan ‑kɔ ‑kun ‑a 'ka ‑pë gbɛ 'yaa 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","'Ö Mali ‑ya pö: «꞊Ɛɛ, a n Dëmɛ ‑bha yuökëdhe 'ka, kö ü ‑wo 'ö bhë ‑yö kë ꞊nɛ ‑kɔ 'ü‑ pöë bhë ‑a 'dhö!» ꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑Zlan ‑bha bɔmɛ ‑yö go ‑a 'piö mü 'ö ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","꞊Dhɛ 'ö ‑Zlan ‑bha bɔmɛ ‑yö go mü, ‑a ‑dhɛ yaa ꞊glɔɔ, 'ö Mali ‑yö ‑da zian ‑ta, 'ö dho 'zozodhö pödhɛ do 'yö ‑tɔn 'piö Zude ‑sɛ 'gü bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","'ö dho, 'yö ‑da Zakali ‑gɔ kɔɔ, 'yö ‑büö ‑da Elizabɛtö ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","꞊Dhɛ 'ö ‑büödawo 'ö bhë Elizabɛtö ꞊yaa‑ ma, 'ö 'në 'yö‑ ‑guzë bhë, 'yö pa ö ‑deë. 'Ö ‑Zuu 'slööslö ‑yö Elizabɛtö pa, ");
INSERT INTO dnj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'yö ‑we 'gbee‑ 'ka ꞊nɛɛ: «‑Zlan ꞊ya 'dhuë‑ 'kpɔ ü ‑bha, dhoo ‑nu 'plɛ ziën, 'ö‑ ‑bha 'dhuë‑ 'dho ‑ya ‑sü 'ka 'në 'ü 'dhoë‑ ‑a kpɔ bhë ‑a ‑ta! ");
INSERT INTO dnj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Dö ‑mü n 'ka 'ö n Dëmɛ dhe ‑yö nu n ‑gɔ kɔɔ ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bhii ‑bhö ‑dhɛ ‑ga, ü ‑büödawo 'a‑ ma bhë, 'në 'a‑ ‑guzë ꞊nɛ ‑yö ‑pa ö ‑deë 'gludhi 'ka n 'guu. ");
INSERT INTO dnj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bhi 'ö 'wun 'ö go kwa Dëmɛ 'piö, 'ü‑ ma, 'yö 'ü‑ ‑dhɛ 'wun gia‑ ꞊nɛ, ‑yö ‑dho kë bhë, 'dhuë‑ ‑yö ü ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","꞊Dhɛ ꞊ya kë 'dhö, 'ö Mali ‑ya pö: «N nii ‑yö n Dëmɛ ‑bha ‑kë ꞊va ‑sü 'tɔ bhɔ, ");
INSERT INTO dnj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","n ꞊zuögludhi ‑sü 'ka n Dhamɛ ‑Zlan ‑wun 'gü! ");
INSERT INTO dnj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bhii ‑yö ö 'yan ‑bɔ ma 'a‑ ‑bha yuökëdhe ‑de ‑dho sia‑ ‑sü ‑zë 'ka n 'piö. 'Ö ꞊dɛɛ ꞊nɛ ‑a 'gü mɛ 'bhee‑ ‑nu 'saadhö 'wo dho ‑a pö 'dhuë‑ ‑yö n ‑ta, ");
INSERT INTO dnj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","bhii ‑Zlan 'piigbeezë ꞊ya 'wun ‑së ꞊va kë n ‑dhë; ‑a 'tɔ ꞊yö 'slööslö! ");
INSERT INTO dnj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mɛ ‑nu 'wo ‑suö ‑a ‑dhë ‑a ꞊bhlë 'kpɔ ‑sü 'ka bhë, ‑yö ‑dho ‑an 'yena yö 'töng 'saadhö 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","꞊Ya ö bha yuö kë ö ‑kɔ 'piigbeezë 'ka, 'ö mɛ ‑nu 'ö ‑de ‑sü ꞊va ‑yö ‑an ꞊zuö' pa bhë ‑an ‑zuö ö ‑kɔ 'yan ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","꞊Ya ‑gludë ‑nu bho ‑an ‑bha 'gɔ ‑gbloo 'gü, ꞊ya ‑yadhɛ ꞊bhlëzë nu ‑de ‑dho sia‑ ‑mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","'Ö mɛ ‑nu 'ö din 'dho ‑an kë ‑na bhë, pë 'ö ‑an ‑bha ‑wun 'dho ‑a ‑bha, ꞊yaa‑ nu ‑an ‑dhë ꞊va 'ka, 'ö ꞊ya ꞊bhɔɔmɛ ‑nu kë, ꞊wa 'dho wo ‑kɔ 'kpaan 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","꞊Ya nu ö bha yuökëmɛ Izlaɛlö ‑bha 'në ‑nu ‑dhë, bhii 'ö tɔɔ ‑a ‑zlö 'yaa trö Ablaamö ꞊suu'‑ ‑ta ‑mɛ ‑nu 'yena yö ‑sü ‑wun 'ka ꞊toëpö 'ka ꞊nɛ ‑kɔ 'yö‑ ꞊blɛɛ ‑a 'ka kwa 'bhɛma ‑nu ‑dhë bhë ‑a 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","꞊Dhɛ ꞊ya kë 'dhö, Mali ‑yö ‑to Elizabɛtö 'piö mü 'su ‑yaaga 'ka ‑yaan ꞊tun 'dho ‑na ö ꞊plöö. ");
INSERT INTO dnj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","꞊Dhɛ 'töng 'ö Elizabɛtö dho 'bë bhoë ꞊ya ‑lo, 'yö 'në gɔɔn‑ do kpɔ. ");
INSERT INTO dnj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","꞊Dhɛ 'ö ‑a dɔmɛ ‑nu waa‑ ‑a ‑gɔ 'kɔɔmɛ ‑nu ‑wa ma ꞊nɛ, Dëmɛ ꞊ya 'glusë kë Elizabɛtö 'ka, 'wo nu 'ö wo 'plɛsɛn 'wo ꞊zuögludhi ‑kë wo 'ko ꞊bhaa mü. ");
INSERT INTO dnj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","꞊Dhɛ 'ö 'në bhë ‑a bhɔ ‑dhɛkpaɔyi ꞊ya kë 'slɛaga, 'wo dhoë 'wo‑ ‑kë 'bɔn 'ka; 'wo‑ ‑kë ‑bezë kö ‑a dë Zakali 'tɔ bhë ‑waan ‑a 'kpɔ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'Yö‑ dhe ‑ya ‑pö ‑an ‑dhë: «‑Daa, ‑a tɔɔ Zan!» ");
INSERT INTO dnj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","'Ö 'wo‑ pö ‑a ‑dhë: «Mɛ 'wo‑ ‑dhɛ Zan 'yaa ü ‑gɔ 'kɔɔmɛ ‑nu 'gü!» ");
INSERT INTO dnj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","꞊Dhɛ ‑kë 'dhö, 'wo yö ‑a dë ꞊dhɛɛ' 'kpɔ ‑sü ‑bha wo ‑kɔ 'gü kö ‑kɔ 'yö dho ö bha 'në bhë ‑a 'tɔ kpɔa kö ‑waan ‑a dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","'Ö Zakali ‑yö pë ‑bɛɛn ‑a ‑ta ‑pë do ‑dhɛ ‑an ‑gɔ, 'ö Zan ‑tɔ bhë 'ö‑ ‑ya. 'Ö ‑an 'plɛ 'te ‑yö tun. ");
INSERT INTO dnj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","‑Dhɛ do bhë ‑a 'gü, 'ö Zakali ‑wo ‑yö yö plaan 'zü ‑dëüwo; 'yö yö 'sabla ‑Zlan 'tɔ 'saa ‑blü ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","꞊Dhɛ ꞊ya kë 'dhö, 'ö 'suö ‑yö ‑da mɛ 'plɛ 'gü, 'ö 'pian 'yö bɔ ‑tɔn 'gü ꞊zian' Zude ‑sɛ 'gü bhë ‑a 'ka, 'wun ‑nu 'wo ‑kë ꞊nɛ 'wo‑ ꞊blɛɛ wo 'ko ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","'Ö mɛ ‑nu 'wo 'wun 'ö ‑kë bhë 'wo‑ ma, 'wo yö wo ‑zo 'ta ‑sü 'gü ꞊nɛɛ: «'Në 'ö ꞊nɛ ‑yö ‑dho kë dö 'ka ‑o?» Bhii Dëmɛ ‑yö ‑kë ‑a 'piö 'sönggö ‑sönggö. ");
INSERT INTO dnj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakali 'yö ‑kë 'në bhë ‑a dë 'ka bhë, ‑Zuu 'slööslö ‑ya pa, 'yö yö ‑Zlan ‑wo 'dhiö ‑lo ‑sü ‑bha 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Kwa Dëmɛ 'tɔ ‑yö kë ꞊va, bhi ‑yö Izlaɛlö 'sɛgɔ ‑bha ‑Zlan 'ka! 'ö tɔɔ ‑yö ö ‑zo ‑kë ö bha 'sɛgɔ bhë ‑a 'piö, 'ö‑ bho 'gan 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","꞊Ya ‑gludë Davidö 'yö ‑kë ‑a ‑bha yuökëmɛ 'ka bhë, ‑a ꞊suu'‑ ‑ta ‑mɛ do 'ö kwa Dhamɛ 'piigbeezë 'ka, ‑a nu kwa ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pë 'ö‑ ꞊blɛɛ ö ‑wodhiölomɛ 'slööslö ‑nu ‑dhë, 'yö‑ ‑dhɛ ꞊ya ꞊glɔɔ yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yö gia‑ ‑ya 'tɔ ‑go kwa ‑dhë 'dhiö ꞊nɛ ö ‑dho kwa dha kwa yaagümɛ ‑nu waa‑ kwa ‑sanzëmɛ ‑nu ‑bha ‑kɔ ‑mɔ 'wuën‑ ‑sü ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","‑Yö ‑dho kwa 'bhɛma ‑nu 'yena yö, 'ö‑ ‑zo dho ‑büö ‑a ‑bha ‑dhikuëdhe 'slööslö 'ö‑ ‑da kwa ‑nu kwa ziën bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bhii ‑yö ö ‑wo ‑bhö kwa 'bhɛma Ablaamö ‑dhë ꞊nɛ, ");
INSERT INTO dnj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ö ‑dho kwa bho kwa yaagümɛ ‑nu ‑bha ‑kɔ ‑mɔ 'wun ‑bha ‑sü 'gü, kö 'kwa yuö kë ‑a ‑dhë ‑zogbandhe 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","‑Yö kë 'dhö kö 'kwa kë 'slööslö 'iin kpengdhö ‑a wö 'dhiö ‑dhɛkpaɔyi 'saadhö 'ka, kwa ‑bha ‑tosiadhe kë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","꞊Dhɛ ꞊ya kë 'dhö, ma 'në, ‑wo ‑dho ü ‑dhɛ ‑Zlan 'yö ‑ziö pë 'plɛ ‑ta ‑a ‑wodhiölomɛ, bhii ü ‑dho 'ta sü Dëmɛ 'dhiö, ‑a ‑bha zian ‑gblooga ‑nu ‑yuö kë ‑sü 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","kö ‑yaan ‑a ‑zɔn ‑a ‑bha 'sɛgümɛ ‑nu ‑dhë ꞊nɛ ‑yö ‑dho ‑an dha, ‑ziö ‑an ‑bha ꞊sɔɔn yaa ‑nu ‑ta ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bhii kwa 'yena yö ‑sü 'gblüünzë bhë ‑a ‑wun 'gü, ‑Zlan ‑yö ‑dho ‑dhɛpuudhɛ 'yö go dhuö ‑a bhü kwa ‑ta ꞊nɛ lan‑ ꞊luu' ‑kɔ 'ö 'bhü ‑na 'ka bhë ‑a 'dhö ");
INSERT INTO dnj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","kö ‑yaan ‑dhɛ 'po mɛ ‑nu 'wo ‑dhɛtiidhɛ 'gü waa‑ mɛ ‑nu 'wo ‑suö ga ‑dhë ‑an ‑ta, kö ‑yaan kwa ‑da ꞊zuöyagluu ‑zian ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","'Në 'ö bhë ‑yö ‑kë ꞊kpɛa' ꞊dhia kö 'wundɔdhe ‑yö kë ‑na ‑a ‑gɔ; 'yö ‑kë ‑dhɛ 'ö mɛ gbɛ 'yaa‑ ‑bha ‑a ‑bha 'ö dho 'ö yöë yi 'yö ö ‑de ‑zɔn ‑a 'ka Izlaɛlö ‑sɛgümɛ ‑nu ‑dhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","'Töng 'dhö bhë ‑a 'ka, ‑gludë ꞊va Ogitö ‑yö tɔng ‑da kö mɛ ‑nu 'wo Wlɔmë ‑mɛ ‑nu ‑bha tɔng ꞊löö ‑wo ‑an 'plɛ 'tɔ ‑ya. ");
INSERT INTO dnj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","'Tɔyadhe 'ö 'dhö bhë ‑a ‑blɛɛzë ‑yö ‑kë 'töng 'ö Kilinisö 'yö kë 'sɛgɔ 'wo‑ ‑dhɛ Sili, ‑a ꞊kɔɔnmɛ do 'ka bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mɛ ‑nu 'töüdhö ‑wo ‑dho wo 'tɔ ‑ya ꞊dhia, mɛ 'ö ‑dhö ‑a 'kpɔ ‑pö 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Zozɛfu ‑de 'pö ‑yö ‑go Nazalɛtë Galile ‑sɛ 'gü, 'yö dho Zude ‑sɛ 'gü, pödhɛ do 'wo‑ ‑dhɛ Betelɛmë 'ö ‑gludë Davidö ‑yö bhɔ ‑a 'gü bhë ‑a ‑bha, bhii 'ö tɔɔ yö gia‑ ‑yö ‑go Davidö ꞊suu'‑ ‑ta 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yö 'dhö waa‑ ö bha ‑zo ‑tën ‑a ‑dhë ‑mɛ 'wo‑ ‑dhɛ Mali bhë ‑wo ‑dho 'wo wo 'tɔ ‑ya kö ‑yö 'guzë. ");
INSERT INTO dnj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","‑Wo ‑kë Betelɛmë, 'ö‑ 'bëbhoyi ‑yö ‑lo, ");
INSERT INTO dnj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'yö ö bha 'në ‑blɛɛzë kpɔ; ‑yö ‑kë 'në gɔɔn‑ 'ka; 'yö sɔ ꞊ploo ‑a 'ka, 'yö‑ ‑da ‑du ‑bha pë ‑bhö ‑a 'gü ‑pë 'gü, bhii 'ö tɔɔ waa wɔdhɛ yö ‑nia ‑nu ‑wɔ ‑a 'gü ‑kɔ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","'Pian gia‑ bhë ‑a ‑ta ‑tuëmaakëmɛ ‑nu ‑wo ‑kë blöö mü gbeng wo ‑bha ‑tuë ‑maa kë ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'Ö ‑Zlan ‑bha bɔmɛ do ‑yö ‑wo ‑an ‑ta, 'ö ‑Zlan 'bhü ‑yö ꞊nië ‑an ‑zü. ꞊Dhɛ ꞊ya kë 'dhö, 'yö 'suö ꞊va ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","'Yö ‑Zlan ‑bha bɔmɛ bhë 'yö‑ pö ‑an ‑dhë: «Kö ꞊kun 'ö 'suö ‑yö ka ‑kë, bhii a ‑nu 'wuntaɔsë 'yö dho Izlaɛlö ‑sɛgümɛ ‑nu 'plɛ ꞊zuögludhi ꞊va bhë ‑a 'ka ka ꞊dhia: ");
INSERT INTO dnj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gbeng do ꞊nɛ ‑a 'gü, Davidö ‑gɔ plöö, ka Dhamɛ ꞊ya bhɔ, 'ö tɔɔ Dëmɛ 'ö Klito 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pë 'yö dho kë ꞊duakëpë 'ka kö 'wun 'a‑ ꞊blɛɛ' ‑na ꞊nɛ 'kaan‑ ‑dhɛ 'wun gia‑ 'ö tɔɔ: 'Ka 'dho, ka ‑dho 'në 'puu 'wo sɔ ꞊ploo ‑a 'ka ‑a yö kö ‑yö wɔ ‑sü 'ka ‑du ‑bha pë ‑bhö ‑a 'gü ‑pë 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","'Yö 'kan 'wo‑ wo wo ‑ta kö ‑Zlan ‑bha bɔmɛ ‑gbaa ꞊va ꞊wa 'go dhang‑ 'gü, ꞊wa nu ‑a ‑bha bɔmɛ 'ö ꞊sia ‑a 'piö, 'wo yö 'tan bho ‑Zlan 'piö ‑sü ‑bha 'wo‑ pö: ");
INSERT INTO dnj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«'Tɔbhɔdhe ‑yö ‑Zlan 'yö dhang‑ 'gü 'ö ‑ziö pë 'plɛ ‑ta bhë ‑a ‑bha 'ka; ‑yö ö ‑bha ꞊zuöyagluu ‑nu mɛ ‑nu 'ö ‑an ‑dhɔ ‑ya ‑kë 'kpongtaa zö ‑an ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","꞊Dhɛ 'ö ‑Zlan ‑bha bɔmɛ ‑nu ꞊wa 'go ‑an 'piö ꞊wa 'dho dhang‑ 'gü, 'ö ‑tuëmaakëmɛ ‑nu 'wo bhë 'wo‑ pö wo 'ko ‑nu ‑dhë: «Kö ‑kwa 'dho 'kwa ‑lo Betelɛmë, pë 'bhle 'yö ‑kë 'ö Dëmɛ ‑ya ‑zɔn kwa ‑dhë bhë 'kwa kwa 'yan dɔ ‑a ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","'Wo ꞊luu 'wo ‑ziö 'wo dho 'zozodhö 'wo ‑kpën Mali 'dhö, Zozɛfu 'dhö waa‑ 'në 'yö ‑kë wɔ ‑sü 'ka ‑du ‑bha pë ‑bhö ‑a 'gü ‑pë 'gü bhë ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","꞊Dhɛ 'ö ꞊wa ‑an yö, 'ö 'wun 'ö ‑Zlan ‑bha bɔmɛ ‑ya ꞊blɛɛ ‑an ‑dhë 'yö ‑gban 'në bhë ‑a ‑bha bhë 'wo‑ ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","'Ö mɛ 'saadhö 'wo ‑tuëmaakëmɛ ‑nu ‑wo bhë 'wo‑ ma, ‑an 'te ‑yö ‑tun 'wun 'wo‑ ꞊blɛɛ bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","'Kɛɛ Mali ‑yö 'wun ‑nu 'wo ꞊nɛ ‑an 'plɛ ‑kpɔ ö ꞊zuö' 'piö, 'ö yö ‑a ‑yö 'ko 'dhiö kë ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","꞊Dhɛ ꞊ya kë 'dhö, ‑tuëmaakëmɛ ‑nu 'wo bhë 'wo ‑yɛ wo 'zü wo 'gbloo ‑ta, 'wo ‑Zlan 'tɔ ‑kë ꞊va, 'go mü 'wo‑ 'tɔ 'saa ‑blü pë ‑nu 'wo‑ ma, 'wo ‑an yö bhë ‑an ‑wun 'gü, bhii ‑an 'plɛ ‑wo ‑kë ꞊nɛ ‑kɔ 'ö ‑Zlan ‑bha bɔmɛ ‑ya ꞊blɛɛ ‑a 'ka ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","꞊Dhɛ 'ö ‑dhɛkpaɔyi 'slɛaga ‑naa ꞊ya ‑lo, 'wo‑ ‑kë 'bɔn 'ka; 'wo‑ Yesu ‑tɔ kpɔ, bhii 'tɔ bhë ‑Zlan ‑bha bɔmɛ ‑ya ‑zɔn 'dhiö Mali ‑dhë ‑yaan ꞊tun ‑a ‑gu 'sü ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","꞊Dhɛ yi 'ö ‑an ‑bha ‑kë 'slööslö ‑yi 'ka bhë ꞊waa‑ yö 'ko 'dhiö ꞊nɛ ‑kɔ 'ö Moizö ‑yö tɔng ‑zɔn ‑a 'ka bhë ‑a 'dhö. 'Yö Zozɛfu waa‑ Mali ‑wo nu 'në 'ö bhë ‑a 'ka Zeluzalɛmë kö ‑waan ‑a ‑zɔn ‑Zlan ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bhii ‑yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha tɔng 'gü ꞊nɛɛ: 'Në ‑blɛɛzë 'wo 'kpɔ ‑na 'në gɔɔn‑ 'ka bhë, ‑wo ‑dho ‑a ‑ya ‑de ‑ta ‑Zlan ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","'Ö 'wo slabhopë 'ö ‑Zlan ‑bha tɔng ‑ya ‑zɔn bhë 'wo‑ nu slabhomɛ ‑dhë; ‑yö ‑kë ‑tönggö ꞊plɛ 'iin ‑an ꞊suu'‑ ‑bhloo ꞊plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gɔɔn‑ do ‑yö ‑kë Zeluzalɛmë 'wo‑ ‑dhɛ Simeɔn. Gɔɔn‑ 'ö bhë ‑yö ‑kë kpengdhö; 'yö ‑Zlan ꞊bhlë ‑ya, 'ö ‑ya mɛ 'ö dho Izlaɛlö ‑sɛgümɛ ‑nu dha bhë ‑a ‑bha nu ‑sü ‑gɔ. ‑Zuu 'slööslö ‑yö ‑kë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","'Yö‑ pö ‑a ‑dhë ꞊nɛ ‑yö ‑dho ö 'yan dɔ ‑Zlan ‑bha ‑Yamɛ 'ö dhoë‑ bɔ bhë ‑a ‑bha ‑yaan ꞊tun ga ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","‑Zuu 'slööslö 'ö bhë ‑yö 'dhiö ‑sü Simeɔn 'ka, 'yö nu ‑Zlan ‑gɔ kɔɔ. ꞊Dhɛ Yesu ‑mɛ ‑nu ꞊wa nu ‑a 'ka, ‑yö kë 'dhö kö pë 'ö tɔng ‑ya pö ‑waan ‑a kë ‑a ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Ö Simeɔn ‑ya sü 'ö‑ kun ö kwɛɛ 'ö ‑Zlan zuö pö ꞊woë' ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«꞊Dhɛ ꞊ya kë 'dhö, n Dëmɛ, pë 'ü‑ 'tɔ go bhë 'bha‑ ‑de kë, ü ꞊kwaa' ma 'a ü bha yuökëmɛ 'ka n ‑zü, kö 'ü n 'sü ꞊zuöyagluu 'ka 'sabla, ");
INSERT INTO dnj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","bhii ü bha Mɛdhamɛ 'ö 'ü‑ ‑ya 'sɛgümɛ ‑nu 'plɛ 'dhiö 'ü‑ bɔ bhë, ma gia‑ n 'yan ꞊ya ‑kpën ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yö 'ö tɔɔ ‑dhɛpuudhɛ 'yö dho ü ‑zɔn 'kpongtaamɛ ‑nu 'saadhö ‑an ‑dhë. 'Go mü, 'yö dho 'tɔvadhɛ nu ü bha 'sɛgɔ Izlaɛlö ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesu dë waa‑ dhe ‑an 'te ‑yö ‑tun 'wun 'ö Simeɔn ‑ya ꞊blɛɛ ‑a 'kluë‑ bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'Ö Simeɔn ‑yö 'dhuë‑ kpɔ ‑an ‑bha, 'go mü 'ö‑ pö Yesu dhe Mali ‑dhë: «‑Zlan ‑yö 'në ꞊nɛ ‑ya ‑ya kö ‑yaan kë Izlaɛlö 'gü ‑mɛ ‑nu ‑dhɛ ꞊va ‑dhɛ ‑bha ‑püö ‑gɛn 'ka, 'go mü 'zü ‑yaan kë ‑an mɛdhɛvadhɛ ‑nu ꞊luu' ‑mɛ 'ka. ‑Yö ‑dho kë ‑Zlan ‑bha ꞊duakëpë do 'ö mɛ ‑nu dho dɔ ‑a ‑gɔ 'yënng ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'Go mü 'yö dho mɛdhɛvadhɛ ‑bha ‑zo ‑ta ‑a 'gü ‑wun 'yö ‑bin ‑sü 'ka, ‑an 'plɛ yö ‑dhɛgbɛadhɛ 'gü. Bhi ‑zë, dhebɔ, ꞊ya kë ü ‑bha 'ka, ꞊zuö' 'klobhɔdhe ‑dho ü ꞊zuö' pɛ ꞊nɛ ‑blaan ‑bha mɛ 'pɛ ‑kɔ 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Dhebɔ do ‑yö ‑kë ‑dhö 'pö, 'yö ‑kë ‑Zlan ‑wodhiölodhe 'ka 'wo‑ ‑dhɛ Anë; ‑yö ‑kë Fanuɛlö 'yö go Asɛɛ ‑gɔ 'gunng 'gü bhë ‑a 'dhu 'ka. ‑Yö ‑kë mɛ ꞊klöö 'ka. ‑Kwɛ 'slaplɛ ꞊nɛ 'ö waa‑ ö ꞊gɔn 'wo ‑kë wo 'ko 'piö, ");
INSERT INTO dnj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","'Ö to ꞊gɛandhe 'ka, 'ö‑ ‑kwɛ ‑kë 'gɔɔ‑ 'slɛaga ö ga ‑yiisië ‑naa ‑yö ꞊loë'. 'Yaa 'go ‑Zlan ‑gɔ kɔɔ 'gbɛɛdhö, 'yö yuö ‑kë ‑Zlan ‑dhë yi 'saadhö 'ka kö ‑yö ö ‑bɛn 'to ‑na kö ‑yö ꞊bhɛa' ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yö ‑de 'pö ‑yö ‑wo mü, 'ö yö ‑Zlan zuö pö ‑sü ‑bha. 'ö 'wun 'ö ‑gban 'në bhë ‑a ‑bha 'yö‑ ꞊blɛɛ mɛ ‑nu 'saadhö 'wo ‑ya kö ‑Zlan ‑yö Zeluzalɛmë ‑dhɛ bho 'gan 'gü bhë ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","꞊Dhɛ 'ö Yesu ‑mɛ ‑nu ꞊wa yën pë 'ö Dëmɛ ‑bha tɔng ‑ya pö bhë ‑a kë ‑sü ‑bha, 'ö 'wo dho wo ‑gɔ plöö Nazalɛtë, Galile ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","'Në bhë ‑yö ‑kpɛa 'wundɔdhe waa‑ 'kpaakpadhɛ ‑an 'ka; 'ö ‑Zlan ‑kɔ ‑së ‑yö ‑kë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","‑Kwɛ 'saadhö 'ka, Yesu ‑mɛ ‑nu ‑wo ‑dho Zeluzalɛmë Paakö 'wlaan‑ ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","꞊Dhɛ 'ö Yesu ‑kwɛ ꞊ya kë 'gɔɔ‑ do ö ga ꞊plɛ, ‑wo ‑dho Paakö 'wlaan‑ ‑ta ꞊nɛ ‑kɔ 'wo‑ ꞊kaa' ‑kplawo ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","꞊Dhɛ 'ö 'wlaan‑ ꞊ya yën, 'ö Yesu ‑mɛ ‑nu ‑wo ‑yɛ wo 'zü; Yesu ‑zë 'pö ‑yö ‑to Zeluzalɛmë, 'kɛɛ ‑a mɛ ‑nu waa‑ ꞊tɛi' dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","'Ö ‑an ‑bha ‑zotadhe ‑ya pö ‑bezë, Yesu ‑dho kë wo ‑ta 'kuë ‑mɛ ‑nu 'piö; 'wo ‑dhɛkpaɔyi do ꞊kaa' 'ta 'sü ‑sü 'gü. ꞊Dhɛ ‑kë 'dhö, 'wo yö ‑a ꞊mɛɛ' ‑sü ‑bha wo ‑mɛ ‑nu waa‑ wo dɔmɛ ‑nu ziën zian ‑ta, ");
INSERT INTO dnj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","'kɛɛ waa‑ yö. 'Yö 'wo ‑yɛ wo 'zü 'wo nu Zeluzalɛmë ‑a ꞊mɛɛ' ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","‑Dhɛkpaɔyi kë ‑yaaga ‑naa bhë 'wo‑ yö kö ‑yö ‑ya ‑sü 'ka Zuifö ‑nu ‑bha mɛ ꞊daan' ‑mɛ ‑nu ziën, ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, ö 'to 'to ꞊dhia ‑an ‑wo ‑bha kö ‑yö ꞊dhɛɛ' ‑nu 'kpɔ ‑na ‑an ‑gɔ, kö yö ‑de 'pö, ‑yö ‑an ‑bha ꞊dhɛɛ' ‑nu ‑yɛ 'zü kë ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mɛ ‑nu 'wo‑ ‑bha 'wun ‑daa ‑kë ‑kɔ ma, ‑an 'te ‑yö ‑tun ‑a ‑bha 'kpaakpadhɛ waa‑ 'wun ‑daa ‑nu 'yö‑ kë ‑na ‑an ‑gɔ bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","꞊Dhɛ 'ö‑ ‑mɛ ‑nu ꞊waa‑ yö, 'ö‑ ‑wun ‑yö ‑an kun, 'ö‑ dhe ‑ya pö ‑a ‑dhë: «Ma 'në, ‑më ‑kë 'ü‑ ‑kë yi ‑gɔ 'dhö e? Ü dë 'dhö, ma 'dhö, yi ꞊zuö' ꞊ya dɔ ‑gbɔudhö ü ꞊mɛɛ' ‑sü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Më ‑kë 'ka n ꞊mɛɛ ꞊ɛ? 'Kaa‑ dɔa ꞊nɛ a ‑dho n ‑zo kë n Dë ‑bha yuö ‑nu 'piö a?» ");
INSERT INTO dnj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Kɛɛ 'wun 'yö‑ ꞊blɛɛ 'dhö bhë waa‑ ‑gɛn dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","꞊Dhɛ ‑kë 'dhö Yesu ‑yö ꞊luu, 'yö ‑ziö ‑an 'piö 'wo dho Nazalɛtë; ‑yö ‑kë 'wun ‑ma ‑an ‑ta ꞊dhia. ‑A dhe ‑yö 'wun ‑nu 'wo ꞊nɛ ‑an 'plɛ ‑kpɔ ö ꞊zuö' 'piö ‑dhɛ ꞊kpaɔ ꞊dhia' ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","'Ö Yesu ‑yö ‑kë ꞊kpɛa ꞊dhia 'kpaakpadhɛ 'ka; 'yö ‑kë ‑Zlan waa‑ mɛ 'bhee‑ ‑nu ‑an wö 'dhiö ‑së. ");
INSERT INTO dnj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","‑Kwɛ 'gɔɔ‑ do ö ga 'sɔɔdhu ‑naa 'ö ‑kë ‑gludë ꞊va Tibɛɛ ꞊yënng 'gü bhë ‑a 'ka, Pɔnsö Pilatö ‑yö ‑kë Zude ‑sɛ ꞊kɔɔn ꞊dhia; Elɔdö ‑de 'pö ‑yö ‑kë Galile ‑sɛ ꞊kɔɔn ꞊dhia, 'ö‑ dheglu Filipö ‑de 'pö, ‑yö ‑kë Itule ‑sɛ waa‑ Trasonitö ‑sɛ ‑kpa 'kuë‑ ‑sü ꞊kɔɔn ꞊dhia; 'ö Lizania ‑yö ‑kë Abilɛnë ‑sɛ ꞊kɔɔn ꞊dhia, ");
INSERT INTO dnj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","'Ö Anë waa‑ Kaifö 'wo ‑kë slabhomɛ ꞊va 'ka. ‑A 'töng gia‑ bhë ‑a 'ka 'ö Zan 'ö ‑kë Zakali gbö 'ka bhë, 'ö ‑Zlan ‑yö 'wun ꞊blɛɛ ‑a ‑dhë 'yënng ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","'Ö Zan ‑yö dho 'pian 'ö bɔ 'yiga 'wo‑ ‑dhɛ Zuudɛn ga bhë ‑a 'piö ꞊zian', 'yö ‑dhoo bho 'ö‑ pö: «‑Ka nu 'ka ka ꞊zuö' ꞊dhië'‑ ‑Zlan 'piö, 'ka bɔ yiö kö ‑yaan ziö kaa‑ ꞊sɔɔn yaa ‑nu ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","‑Kɔ bhë 'ö ꞊kaa' ꞊nɛ pë 'ö ‑Zlan ‑wodhiölomɛ Ezai ‑ya ꞊bɛɛn ‑a 'ka ö ‑gɔ 'sëëdhɛ 'gü ‑a 'dhö: Mɛ ‑wo 'ö ‑dhoo bho ‑na 'yënng ꞊taa bhë ‑ya ‑pö: ‑Ka Dëmɛ ‑bha zian ‑gblooga ‑nu ‑yuö kë, 'ka ‑an dɔ kpengdhö! ");
INSERT INTO dnj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","'Yi goo 'gü ‑dhɛ ‑nu 'plɛ 'gü ‑dho ‑blü; ‑tɔn ‑nu, goo ‑nu ‑wo ‑dho ꞊wüü'‑, 'ö ‑an ‑ta ‑yö ‑mɔ 'kuë. ‑Kpinng ꞊kloo' ‑dhɛ ‑nu 'plɛ ‑dho dɔ 'trüün 'piö, 'ö zian ‑gblooga ‑nu 'waa ‑së, 'ö‑ 'plɛ ‑dho kë ‑së. ");
INSERT INTO dnj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mɛ ‑nu 'saadhö ‑wo ‑dho kwa dha ‑kɔ 'ö ‑Zlan ‑yö kwa dhaa bhë ‑a yö. ");
INSERT INTO dnj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mɛ ‑gbaa ‑nu ‑wo ‑nu Zan 'piö kö ‑yö ‑an ‑bha ‑go ꞊sɔɔn yaa 'gü ‑bɔyiödhe kë, 'kɛɛ Zan ‑ya ‑pö ‑an ‑dhë: «꞊Mɛɛziëmɛ ‑nu 'ka ꞊nɛ! ‑Yö ‑kë ka ‑zo 'piö ꞊nɛ ka ‑dho dha ‑Zlan ‑bha za 'ö 'dhoë‑ nu bhë ‑a ‑gɔ ‑a? ");
INSERT INTO dnj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","‑Ka 'wun ‑nu 'yö dho ‑a ‑zɔn ꞊nɛ 'ka ka ꞊zuö' ꞊dhië ‑Zlan 'piö ‑an kë; kö ꞊kun 'ka‑ pö ka ‑de ‑dhë ꞊nɛɛ: ‹Yi dë 'ö tɔɔ Ablaamö,› bhii a‑ ‑blɛɛ ka ‑dhë ꞊nɛ ‑Zlan ‑kɔ ‑yö ‑mɔa kö ‑yaan ‑guö kpö ‑nu 'wo ꞊nɛ ‑an kë mɛ 'ka ‑waan kë Ablaamö ꞊suu'‑ ‑ta ‑nu 'ka! ");
INSERT INTO dnj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","꞊Dua ‑yö ‑pë kë ‑sü 'ka kö mɛ ‑yaan 'lü bɔa. 'Lü 'ö 'yaa bha ö bhɛ ‑së 'ka, ‑yö ‑dho bɔ 'yö ‑lo 'siö 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","꞊Dhɛ ꞊ya kë 'dhö, 'ö mɛ gbung ‑nu 'wo bhë 'wo‑ pö ‑a ‑dhë: «꞊Dhɛ 'ö 'dhö ꞊nɛ, kö ‑më 'yi dho ‑a kë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","'Yö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Mɛ 'ö ‑da ‑bha ‑sɔ ꞊plɛ 'dho ‑a ‑gɔ, ‑ya do nu mɛ 'ö‑ gbɛ 'yaa‑ ‑gɔ ‑a ‑dhë. 'Go mü, mɛ 'ö ‑bhöpë 'dho ‑a ‑gɔ, ‑ya ‑glu mɛ 'ö 'yaa ‑an ‑gɔ ‑an 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","'Ö 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu ‑de 'pö, 'wo nu Zan 'piö kö ‑yaan ‑an bɔ yiö, 'ö 'wo Zan ꞊dhɛɛ' kpɔ 'wo‑ pö: «Yi ‑Gɔmɛ, yi ‑de 'pö, yi ‑dho ‑a kë ꞊dhë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'Yö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Kö ꞊kun 'ka bho ‑pë 'ö tɔng ‑ya pö 'kwa‑ bho bhë 'ö 'ka ‑lö ‑a ‑naa ‑zü!» ");
INSERT INTO dnj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","'Ö 'dhasi ‑nu ‑de 'pö, 'wo‑ ꞊dhɛɛ' kpɔ 'wo‑ pö: «Yi ‑de 'pö 'dhee, ‑më 'yi dho ‑a kë ꞊ɛ?» 'Yö‑ pö ‑an ‑dhë: «Kö ꞊kun 'ka 'wëü‑ gbɛ kun mɛ ‑nu ‑gɔ 'gügbeedhɛ 'ka, ‑kpla ‑ya ‑an ‑bha ‑sü 'ka; ‑ka ka ‑zo kë ka ꞊saan' 'wo‑ bho ‑na bhë ‑a 'piö!» ");
INSERT INTO dnj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","꞊Dhɛ ‑kë ꞊nɛ 'sɛgümɛ ‑nu ‑wo ‑ya ‑Zlan ‑bha ‑Yamɛ ‑bha nu ‑sü ‑gɔ 'yan ‑to zian‑ ‑sü 'ka bhë, ‑a ‑wun 'gü mɛ 'ö ‑dhö 'yö ‑kë ‑a ‑zo 'piö ꞊nɛ Zan 'ö tɔɔ ‑Zlan ‑bha ‑Yamɛ. ");
INSERT INTO dnj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","꞊Dhɛ ꞊ya kë 'dhö, 'ö Zan ‑ya ‑pö ‑an ‑dhë: «Mɛ 'ö‑ 'pii 'dhö 'gbee‑ 'ö ꞊zië' n ‑ta, ‑yö ‑dho nu; yaa n ‑ma 'kun poo kö 'aan‑ ꞊kloo'‑ ‑a 'dhiö 'aan‑ ‑a ‑bha ‑sakpa yun ꞊bhüö' 'po. Ma ‑zë a ka ‑bɔ yiö, 'kɛɛ yö ‑zë ‑yö ‑dho ka pa ‑Zuu 'slööslö waa‑ 'siö ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","‑Yö ‑dho 'dhaa‑ kun ö kwɛɛ, pë ‑piö ‑pë 'ka kö ‑yaan ‑mlü ‑gbo bho ‑a 'flee‑ ‑nu ziën. ‑Yö ‑dho ö bha ‑mlü 'flee‑ ‑nu ‑lo ö ‑gɔ 'slëëdhö, 'yö ‑mlü ‑gbo ‑güö 'siö 'yaa ꞊dhuu 'gbɛɛdhö bhë ‑a 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","‑Kɔ do bhë ‑a 'ka, 'ö Zan ‑yö 'wuntaɔsë ꞊blɛɛ ‑a 'ka 'sɛgümɛ ‑nu ‑dhë, ‑an ꞊faan' 'më ‑wo ꞊plëëzë ꞊blɛɛ'‑ ‑an ‑dhë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","'Töng 'ö 'dhö bhë ‑a 'ka, Zan ‑yö za ‑kpa 'sɛdë Elɔdö ‑bha, Elɔdiadö 'yö ‑kë ‑a dheglu bɔɔ 'ka bhë ‑a 'kun 'ö‑ wo ‑a ‑gɔ waa‑ 'wun ‑nu 'ö 'waa ‑së 'yö ‑an ‑kë bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","꞊Dhɛ ꞊ya kë 'dhö, Elɔdö ‑yö ko 'zü, 'ö 'wun yaa 'bhaa do kë, 'ö tɔɔ Zan 'kun 'yö‑ wo 'yö‑ ‑da ‑kanso 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","'Sɛgümɛ ‑nu ‑wo ‑dho 'wo ‑an bɔ yiö. Yesu ‑de 'pö, 'yö dho, 'ö Zan ‑ya bɔ yiö. ꞊Dhɛ 'ö ꞊bhɛa' ‑na, 'yö dhang‑ 'dhi ‑yö ‑po, ");
INSERT INTO dnj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","'Ö ‑Zuu 'slööslö ‑yö go dhang‑ 'gü; 'kɛɛ ‑yö ‑kë ‑tönggö 'ka 'ö nu 'ö ꞊yɔɔ ‑a ‑ta dhuö; 'ö ‑wo ‑yö bɔ dhang‑ 'gü 'yö ‑we 'ö‑ pö: «Ü n Gbö 'ö‑ ‑dhɔ ‑yö n ‑kë ‑a 'ka, bhi ꞊nɛ 'ö n 'yi ‑kan ‑a ‑dhë ‑wun 'plɛ 'dho ü 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","꞊Dhɛ Yesu ‑kwɛ ꞊tɛi' ꞊ya kë ꞊nɛ pë 'gɔɔ‑ ‑yaaga 'dhö, 'ö ‑ya ö bha yuö zü dɔ ‑sü ‑bha. Pë 'ö mɛ ‑nu ‑wo wo ‑zo ‑ta ‑a 'gü 'ö tɔɔ Zozɛfu gbö ‑mü ‑a 'ka. Zozɛfu ‑yö ‑kë Eli gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yö ‑de 'pö 'yö ‑kë Matatö gbö 'ka, yö ‑de 'pö 'yö ‑kë Levi gbö 'ka, yö ‑de 'pö 'yö ‑kë Mɛlisi gbö 'ka, yö ‑de 'pö 'yö ‑kë Zanai gbö 'ka, yö ‑de 'pö 'yö ‑kë Zozɛfu gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","yö ‑de 'pö 'yö ‑kë Matatiasö gbö 'ka, yö ‑de 'pö 'yö ‑kë Amɔsö gbö 'ka, yö ‑de 'pö 'yö ‑kë Naɔmë gbö 'ka, yö ‑de 'pö 'yö ‑kë Esili gbö 'ka, yö ‑de 'pö 'yö ‑kë Nagai gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","yö ‑de 'pö 'yö ‑kë Maatö gbö 'ka, yö ‑de 'pö 'yö ‑kë Matatiasö gbö 'ka, yö ‑de 'pö 'yö ‑kë Semeinë gbö 'ka, yö ‑de 'pö 'yö ‑kë Zozɛsö gbö 'ka, yö ‑de 'pö 'yö ‑kë Zoda gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","yö ‑de 'pö 'yö ‑kë Zoana gbö 'ka, yö ‑de 'pö 'yö ‑kë Lesa gbö 'ka, yö ‑de 'pö 'yö ‑kë Zolobabɛlö gbö 'ka, yö ‑de 'pö 'yö ‑kë Salatiɛlö gbö 'ka, yö ‑de 'pö 'yö ‑kë Neli gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","yö ‑de 'pö 'yö ‑kë Melisi gbö 'ka, yö ‑de 'pö 'yö ‑kë Adi gbö 'ka, yö ‑de 'pö 'yö ‑kë Kosamë gbö 'ka, yö ‑de 'pö 'yö ‑kë Elimadamë gbö 'ka, yö ‑de 'pö 'yö ‑kë Elö gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","yö ‑de 'pö 'yö ‑kë Yesu gbö 'ka, yö ‑de 'pö 'yö ‑kë Eliezɛɛ gbö 'ka, yö ‑de 'pö 'yö ‑kë Zɔlimë gbö 'ka, yö ‑de 'pö 'yö ‑kë Matatö gbö 'ka, yö ‑de 'pö 'yö ‑kë Levi gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","yö ‑de 'pö 'yö ‑kë Simeɔn gbö 'ka, yö ‑de 'pö 'yö ‑kë Zuda gbö 'ka, yö ‑de 'pö 'yö ‑kë Zozɛfu gbö 'ka, yö ‑de 'pö 'yö ‑kë Zonamë gbö 'ka, yö ‑de 'pö 'yö ‑kë Eliakimë gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","yö ‑de 'pö 'yö ‑kë Melea gbö 'ka, yö ‑de 'pö 'yö ‑kë Mɛna gbö 'ka, yö ‑de 'pö 'yö ‑kë Matata gbö 'ka, yö ‑de 'pö 'yö ‑kë Natan gbö 'ka, yö ‑de 'pö 'yö ‑kë Davidö gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","yö ‑de 'pö 'yö ‑kë Zese gbö 'ka, yö ‑de 'pö 'yö ‑kë Obɛdö gbö 'ka, yö ‑de 'pö 'yö ‑kë Boozö gbö 'ka, yö ‑de 'pö 'yö ‑kë Saala gbö 'ka, yö ‑de 'pö 'yö ‑kë Naasɔn gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","yö ‑de 'pö 'yö ‑kë Aminadabö gbö 'ka, yö ‑de 'pö 'yö ‑kë Ademinë gbö 'ka, yö ‑de 'pö 'yö ‑kë Aani gbö 'ka, yö ‑de 'pö 'yö ‑kë Esilɔmë gbö 'ka, yö ‑de 'pö 'yö ‑kë Falɛ gbö 'ka, yö ‑de 'pö 'yö ‑kë Zuda gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","yö ‑de 'pö 'yö ‑kë Zakɔbö gbö 'ka, yö ‑de 'pö 'yö ‑kë Izaakö gbö 'ka, yö ‑de 'pö 'yö ‑kë Ablaamö gbö 'ka, yö ‑de 'pö 'yö ‑kë Tala gbö 'ka, yö ‑de 'pö 'yö ‑kë Nasɔɔ gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","yö ‑de 'pö 'yö ‑kë Selusö gbö 'ka, yö ‑de 'pö 'yö ‑kë Lagau gbö 'ka, yö ‑de 'pö 'yö ‑kë Falɛkö gbö 'ka, yö ‑de 'pö 'yö ‑kë Ebɛlö gbö 'ka, yö ‑de 'pö 'yö ‑kë Saala gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","yö ‑de 'pö 'yö ‑kë Kainamë gbö 'ka, yö ‑de 'pö 'yö ‑kë Aafazadö gbö 'ka, yö ‑de 'pö 'yö ‑kë Sɛmë gbö 'ka, yö ‑de 'pö 'yö ‑kë Noe gbö 'ka, yö ‑de 'pö 'yö ‑kë Lamɛkö gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","yö ‑de 'pö 'yö ‑kë Matuzala gbö 'ka, yö ‑de 'pö 'yö ‑kë Enɔkö gbö 'ka, yö ‑de 'pö 'yö ‑kë Zalɛdö gbö 'ka, yö ‑de 'pö 'yö ‑kë Maleleɛlö gbö 'ka, yö ‑de 'pö 'yö ‑kë Kainamë gbö 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","yö ‑de 'pö 'yö ‑kë Enɔsö gbö 'ka, yö ‑de 'pö 'yö ‑kë Sɛtö gbö 'ka, yö ‑de 'pö 'yö ‑kë Adan gbö 'ka, yö ‑de 'pö 'yö ‑kë ‑Zlan gbö 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu 'ö ‑Zuu 'slööslö ‑ya pa bhë ‑a ‑go Zuudɛn ꞊bhaa ‑sü 'ka, 'ö ‑Zuu 'slööslö ‑yö yö ‑a ‑dhë 'dhiö, 'ö dhoë ‑dhɛ 'ö mɛ gbɛ 'yaa‑ ‑bha bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","‑Dhɛkpaɔyi 'gɔɔ‑ ‑yiisië ꞊nɛ 'yö‑ ‑kë mü. 'Töng 'ö 'dhö bhë yaa pë gbɛ ‑bhö ‑a 'ka. ꞊Dhɛ 'ö ‑dhɛkpaɔyi 'gɔɔ‑ ‑yiisië 'wo bhë 'ö ꞊wa ziö, 'ö din ‑ya kun. 'Ö Satan ‑ya 'gü dan, ");
INSERT INTO dnj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","'yö‑ pö ‑a ‑dhë: «꞊Ya kë ꞊nɛ ‑Zlan Gbö ‑mü ü 'ka, ‑bhö ‑guö 'ö ꞊nɛ ‑a 'gla ‑bhöpë 'gü kö 'ü‑ ‑bhö!» ");
INSERT INTO dnj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Abi', bhii pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö tɔɔ: Mɛ 'bhee‑ 'ka 'dho ‑tosiadhe kë ‑bhöpë ‑de 'sloo ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","'Yö‑ ‑sü 'yö ꞊daa' ‑tɔn tuö 'yö 'kpongtaa ‑gludëdhɛ ‑pö 'plɛ ‑zɔn ‑a ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","'Ö‑ pö ‑a ‑dhë: «A ‑dho ü gbaa ‑wogbiindhɛ waa‑ 'tɔbhɔdhe ‑an 'ka ‑gludëdhɛ ‑pö ‑nu ‑bha zö, bhii 'ö tɔɔ pë ‑nu 'wo zö ‑wo n ‑gbaa ‑a 'plɛ 'ka, a ‑dho ‑a nu mɛ 'ö ‑dhi n ‑dhë ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","꞊Ya kë ꞊nɛ 'bha 'gblü n 'dhiö, ‑a 'plɛ ‑dho kë ü ‑bha 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","'Ö Yesu ‑ya pö: «Pë 'ö ꞊bɛɛn' ‑sü 'ka 'ö tɔɔ: ‑Bhö ü Dëmɛ, ü ‑bha ‑Zlan dosɛn 'kpaan gba 'ü yuö kë yö dosɛn 'kpaan ‑a ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","'Ö Satan ‑ya sü 'zü, 'yö dhoë Zeluzalɛmë, ‑Zlan ‑bha 'kɔ ꞊va tuö, 'yö‑ pö ‑a ‑dhë: «꞊Ya kë ꞊nɛ ‑Zlan Gbö ‑mü ü 'ka, 'go dhuö zö 'ü ‑püö sia‑ ‑de, ");
INSERT INTO dnj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","bhii pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö tɔɔ: ‑Zlan ‑dho ‑a pö ö bha bɔmɛ ‑nu ‑dhë ‑wo wo ‑kɔ 'kpɔ ü ‑gɔ zian‑ kö ꞊kun pë gbɛ dho kë ü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","'Go mü 'zü ‑wo ‑dho ü bun ‑së 'ka kö ꞊kun ü ‑gɛn dho ‑zuö ‑guö ‑bha. » ");
INSERT INTO dnj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","'Ö Yesu ‑ya pö ‑a ‑dhë: «Pë 'ö ꞊bɛɛn' ‑sü 'ka 'pö 'ö tɔɔ: Kö ꞊kun 'ü ü Dëmɛ ü ‑bha ‑Zlan 'gü dan! » ");
INSERT INTO dnj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","꞊Dhɛ ꞊ya Yesu 'gü dan ‑kɔ ꞊suu'‑ 'saadhö ‑ta 'ö yaa‑ 'kundhɛ gbɛ yö, 'yö ‑ziö 'ö dho 'ö yöë yi gbɛ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu ‑yö ‑yɛ ö 'zü 'ö dho Galile, pa ‑sü 'ka ‑Zuu 'slööslö ‑bha 'piigbeedhɛ 'ka. ‑Wo ‑yö ‑a 'tɔ 'saa ‑blü ‑sü 'gü 'sɛgɔ 'ö bhë ‑a ‑dhɛ 'saadhö 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","‑Yö ‑kë mɛ ‑nu ꞊daan' ꞊dhia Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑nu 'gü. 'Ö mɛ ‑nu ‑wa 'tɔ ‑kë ꞊va ‑dhɛ 'saadhö ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu ‑yö ‑go mü 'yö nu Nazalɛtë, ‑dhɛ 'ö ꞊kpɛa ‑a ‑bha bhë ‑a ‑bha. 'Ö Zuifö ‑nu ‑bha ꞊glooyi 'ka 'yö ‑da ‑an ‑bha ‑bhɔkuëkɔ 'gü ꞊nɛ ‑kɔ ꞊ya kë 'yö‑ ꞊kaa' ‑kplawo bhë ‑a 'dhö; 'yö ꞊luu kö ‑yaan pë 'ö ꞊bɛɛn' ‑sü 'ka ‑a pö. ");
INSERT INTO dnj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'Wo nu ‑Zlan ‑wodhiölomɛ Ezai ‑bha 'sëëdhɛ ‑be 'ka ‑a ꞊dhia. 'Sëëdhɛ ‑be bhë, ꞊dhɛ 'ö‑ 'dhi ‑po, 'ö‑ 'yan ‑yö ‑kpën pë 'ö ‑kë ꞊bɛɛn' ‑sü 'ka‑ ‑bha ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‑Zuu 'slööslö 'ö go n Dëmɛ 'piö ‑yö n 'piö, ‑yö n ‑sü 'yö n bɔ kö 'aan‑ nu 'wuntaɔsë 'ka 'yenamɛ ‑nu ꞊dhia. ‑Yö n ‑bɔ kö 'aan‑ mɛ ‑nu bho 'gan 'gü, 'aan‑ 'yënngtiimɛ ‑nu ‑dhɛ bo; 'go mü 'aan‑ mɛ ‑nu 'wo 'klobhɔdhe 'gü ‑an bho ‑a 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kö ‑kwɛ 'ö Dëmɛ dho ö bha 'glusë kaa bhë, 'aan‑ ‑a ‑wun ꞊blɛɛ'‑ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","'Yö Yesu ‑yö 'sëëdhɛ ‑be bhë ‑a kpa 'kuë‑, 'yö‑ nu yuökëmɛ ‑dhë, 'ö ꞊yaannu kö ‑yaan ‑an ꞊daan'‑. Mɛ ‑nu 'töüdhö 'wo ‑kë ‑bhɔkuëkɔ 'gü mü 'saadhö, ‑an 'yan ‑yö ꞊dhië Yesu 'piö dosɛn. ");
INSERT INTO dnj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö ‑an ‑dhë: «'Wun ‑dhɛ 'ö ꞊bɛɛn' ‑sü 'ka, 'ka 'go ‑na ma ꞊dhia bhë, ‑a ‑de ‑ya kë ꞊dɛɛ 'töng gia‑ 'ka‑ ‑maa bhë ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mɛ ‑nu 'wo kë mü ‑wo ‑we ‑a ‑wo ‑bha, 'ö ‑an 'te ‑yö tun 'wun ‑sɛɛbɔ 'yö 'go ‑na ‑a dhiö bhë ‑a ‑wun 'gü, 'wo‑ pö wo 'ko ‑nu ‑dhë ꞊nɛɛ: «'E! Zozɛfu gbö ꞊nɛ 'yaa ‑mü ‑a?» ");
INSERT INTO dnj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","'Ö Yesu ‑ya pö ‑an ‑dhë: «Ka ‑dho 'wun ꞊zuan' 'ö ꞊nɛ ‑a ‑zɔn n ‑dhë: ‹꞊Dhɔngtrɔ, ‑bhö ü ‑de dha!› 'Ka dho ‑a pö 'zü n ‑dhë: ‹Pë ‑nu 'ü‑ ‑kë Kapɛɛnaɔmë 'saadhö 'yi‑ ‑ma bhë, ‑bhö ‑an 'plɛ kë ü ‑de ‑gɔ plöö zö!› » ");
INSERT INTO dnj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","'Go mü 'zü 'yö‑ pö: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: 'Waa ‑Zlan ‑wodhiölomɛ gbɛ ꞊bhlë ‑ya ö ‑de ‑gɔ plöö. ");
INSERT INTO dnj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A ‑yɔɔn ‑a ‑ta dhuö ka ‑dhë 'zü ꞊nɛ kö Eli ‑yö ꞊tun ‑dhö bhë, ꞊gɛandhoo ‑nu ‑wo ‑kë ‑dhö ꞊va Izlaɛlö ‑sɛ 'gü zö, 'töng 'ö dha yaa ban ‑a 'ka ‑kwɛ ‑yaaga waa‑ 'su 'slado ‑an ‑bha. 'Yö‑ 'töng bhë ‑a 'ka 'yö din ꞊va ‑yö ‑da 'sɛ ꞊nɛ ‑a ‑ta, ");
INSERT INTO dnj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","'kɛɛ ‑Zlan yaa Eli bɔ ꞊gɛandhoo ‑nu 'wo 'dhö bhë ‑an mɛ gbɛ 'piö ‑a 'ke yaa kë ꞊gɛandhe do 'yö ‑kë Salɛta, Sidɔn ‑sɛ 'ö 'sɛ gbɛ 'ka bhë ‑a 'gü ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","'Go mü 'zü, 'ö ꞊weemɛ ‑nu ‑wo ‑kë ꞊va Izlaɛlö ‑sɛ 'gü 'töng 'ö ‑Zlan ‑wodhiölomɛ Elize ‑yö ꞊kaa' mü ‑a 'ka, 'ö ‑an mɛ gbɛ ‑dhɛ yaa bo ‑a 'ke yaa kë Naama 'yö go Sili ‑dhɛ 'ö 'sɛ gbɛ 'ka bhë ‑a 'gü ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mɛ ‑nu 'wo ‑kë ‑bhɔkuëkɔ 'gü mü 'töüdhö bhë, 'wun ‑yö ‑na ‑an ‑zuë 'wun 'ö‑ ꞊blɛɛ bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","'Wo ꞊luu 'wo‑ kun 'wo‑ ꞊gbɔɔ gbɔ 'wo bɔa woë‑ pödhɛ 'ö ‑kë ‑tɔn 'kluë‑ bhë ‑a ‑bha, 'wo dhoë ‑tɔn gia‑ bhë ‑a tuö kö ‑waan ‑a ‑zuö goo 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'Kɛɛ Yesu ‑yö ‑bɔ ‑an ziën 'yö dho. ");
INSERT INTO dnj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö dho Kapɛɛnaɔmë plöö, Galile ‑sɛ 'gü, 'ö yö mɛ ‑nu ꞊daan' ‑sü ‑bha Zuifö ‑nu ‑bha ꞊glooyi 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","'Ö ‑an 'te ‑yö ‑tun ‑a ‑bha mɛ ꞊daan' ‑kɔ bhë ‑a ‑wun 'gü, bhii 'ö tɔɔ ‑yö 'wun ‑blɛɛ ‑wogbiindhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gɔɔn‑ do 'ö ‑zuu yaa ‑yö ‑kë ‑a 'gü bhë, ‑yö ‑kë ‑bhɔkuëkɔ 'gü mü 'pö, 'ö yö 'we ‑sü 'gü 'gbee‑ 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«'Aa! ‑Më ‑mü ‑i, Yesu 'go Nazalɛtë? Ü ‑nu kö 'üën‑ yi 'gü ꞊siö' ꞊a? A‑ ꞊dɔa' ꞊nɛ, ü mɛ 'slööslö 'ö ‑Zlan ‑ya bɔ ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","'Ö Yesu ‑yö 'wun ꞊blɛɛ ‑zuu yaa bhë ‑a 'ka 'gbee‑ 'ka 'ö‑ pö ‑a ‑dhë: «Ü 'dhi yö 'kuë‑ 'ü 'go gɔɔn‑ 'ö ꞊nɛ ‑a 'gü!» 'Yö ‑zuu yaa ‑yö gɔɔn‑ 'ö bhë ‑a ‑zuö sia‑ mɛ 'plɛ wö 'dhiö mü 'ö go ‑a 'gü; yaa pë yaa gbɛ kë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","'Ö mɛ ‑nu 'wo ‑kë mü ‑an 'te ‑yö tun, 'ö 'wo‑ pö wo 'ko ‑nu ‑dhë: «'Wun ꞊blɛɛ'‑ ‑wo ꞊suu'‑ ‑mlë 'ö ꞊nɛ ꞊ɛ? 'E, gɔɔn‑ 'ö ꞊nɛ ‑yö 'wun ‑blɛɛ ‑zuu yaa ‑nu 'ka ‑wogbiindhɛ waa‑ 'piigbeedhɛ 'ka, 'ö 'wo go mɛ ‑nu 'gü 'dhö e?» ");
INSERT INTO dnj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","'Ö Yesu 'tɔ ‑yö ‑pɛn 'pian 'ö 'dhö bhë ‑a ‑ta mɛ 'plɛ 'dhi. ");
INSERT INTO dnj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu ‑yö ‑go ‑bhɔkuëkɔ 'gü mü 'ö dho Simɔ ‑gɔ kɔɔ. Simɔ ꞊da ‑ta yaa kë 'po ‑sü 'ka, 'ö tɔɔ 'gii‑ ‑kɔ ‑yö ‑kë ‑a ‑bha 'gbee‑ 'ka; 'ö mɛ ‑nu ‑wo ꞊bhɛa Yesu ‑dhë kö ‑yaan ‑a ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Ö Yesu ‑yö ꞊yɔɔn ‑a ‑bha, 'yö 'wun ꞊blɛɛ 'gbee‑ 'ka 'gii‑ bhë ‑a 'ka, 'ö go ‑a 'gü, 'ö to mü 'ö ꞊luu 'ö yö ‑an ‑bhöpë ‑yuö kë ‑sü ‑bha ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","꞊Dhɛ lan‑ ꞊ya ‑püö, 'ö 'wo nu mɛ ‑nu 'ö 'yua ꞊suu'‑ 'oo ꞊suu'‑ ‑yö ‑an ‑kë ‑an 'ka Yesu 'piö; 'yö ‑an ‑dhɛ bo ö ‑kɔ ‑kpa ‑an ‑ta dhuö ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'Ö ‑zuu yaa ‑nu ‑wo go mɛ ‑nu ꞊plëëzë 'gü ꞊gblaa 'gbla ‑sü 'ka ꞊nɛɛ: «‑Zlan Gbö ‑mü ü 'ka!» 'Kɛɛ Yesu ‑yö 'wun ꞊blɛɛ ‑an 'ka, kö ꞊kun 'wo dho 'wun gbɛ ꞊blɛɛ'‑, bhii 'ö tɔɔ wo gia‑ ‑wa ꞊dɔa' ꞊nɛ ‑Zlan ‑bha ‑Yamɛ ‑mü ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","꞊Dhɛ 'ö‑ ‑dhɛ ꞊ya 'po, Yesu ‑yö ‑go plöö 'yö dho ö ‑de 'sloo 'ka ‑dhɛ do 'bhaa ‑bha. 'Ö mɛ ‑gbaa ꞊va ‑wo yö ‑a ꞊mɛɛ' ‑sü 'gü. ꞊Dhɛ 'ö ꞊waa‑ yö, 'wo‑ kuënnu kö ‑yaan 'to wo 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","'Kɛɛ Yesu ‑ya ‑pö ‑an ‑dhë: «A ‑dho 'wuntaɔsë 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑bha, ‑a ꞊blɛɛ pödhɛ mɛ ‑nu 'wo to ‑an 'gü; bhii pë 'ö ‑Zlan ‑yö n bɔ ‑a ‑wun 'gü bhë 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","'Yö ‑Zlan ‑wo ꞊blɛɛ Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑nu 'gü Zude ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yi do 'ka Yesu ‑yö ‑kë Zenezalɛtö 'yipuë 'kpong 'dhiö, 'ö mɛ ‑gbaa ꞊va ‑wo nu 'wo ꞊nië ‑a ‑zü zian 'plɛ 'ka kö ‑waan wo 'to ‑to ‑Zlan ‑wo ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","‑Dhɛ bhë ‑a 'gü 'yitagɔ ꞊plɛ ‑wo ‑kë 'yi 'kpong 'dhiö kö mɛ ‑nu 'wo 'yiblükëmɛ ‑nu 'ka, ꞊wa 'go ‑a 'gü ꞊wa 'dho wo ‑bha 'kplö 'zlu ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Ö Yesu ‑yö ‑da 'yitagɔ mɛ 'ö ‑kë Simɔ ‑bha 'ka bhë ‑a 'gü, 'ö‑ pö ‑a ‑dhë ‑ya 'bhe 'tee ꞊yɔɔn 'yi ‑ta; 'ö ꞊yaannu ‑a 'gü 'ö yö ‑an ꞊daan' ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","꞊Dhɛ ꞊ya yën 'wun ꞊blɛɛ' ‑sü ‑bha, 'ö‑ pö Simɔ ‑dhë: «‑Bhö ꞊yɔɔn 'yitagɔ 'ka 'yi ziëndhɛ gia‑ ‑bha kö bhi 'dhö, ü 'bhamɛ ‑nu 'dhö 'ka ka ‑bha 'kplö ‑zuö yiö 'kaan‑ 'yuö‑ 'sü!» ");
INSERT INTO dnj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","'Ö Simɔ ‑ya pö ‑a ‑dhë: «N ‑Gɔmɛ, yi 'yi ‑blü ‑kë gbenggbeng, 'kɛɛ yiëë pë gbɛ yö. ꞊Ao', ꞊dhɛ ‑kë ꞊nɛ bhi gia‑ 'ü‑ pö 'a‑ kë bhë kö a ‑dho ‑a kë ü ‑wo 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","꞊Dhɛ ꞊ya kë 'dhö, 'wo 'kplö ‑zuö yiö, 'ö 'yuö‑ ‑yö ‑an ‑bha 'kplö pa, ꞊dhɛ 'to ‑na zlöö kö ‑yö ꞊kaan' ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'Ö 'wo ꞊üü‑ ‑blü wo 'bhamɛ ‑nu 'wo ‑kë 'yitagɔ gbɛ 'gü bhë ‑an ‑gɔ kö ‑waan nu wo ‑dhë. 'Ö 'wo nu 'wo 'yitagɔ ꞊plɛ bhë 'wo ‑an 'plɛ pa 'yuö‑ 'ka, ꞊dhɛ 'to ‑na zlöö kö 'yitagɔ ‑nu 'wo bhë ‑wo 'dho ‑na 'yi ꞊löö. ");
INSERT INTO dnj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","꞊Dhɛ 'ö Simɔ Piɛɛ ꞊ya pë ‑nu 'wo bhë ‑an yö, 'yö nu 'yö ‑lo ö kpɔn 'gü Yesu 'dhiö, 'ö‑ pö ‑a ‑dhë: «N Dëmɛ, ‑bhö ꞊yɔɔn 'ma 'ü 'go n 'sɔɔ; ma 'a ꞊nɛ 'wunyaakëmɛ ‑mü n 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pë 'ö ‑kë 'ö‑ pö 'dhö bhë 'ö tɔɔ 'suö ‑yö ‑da yö gia‑ waa‑ mɛ ‑nu 'wo to ‑an 'gü 'yuö‑ ꞊va 'wo‑ sü bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","‑Kɔ do bhë ‑a 'ka 'ö ꞊kaa' Simɔ 'bhamɛ ‑nu Zakö waa‑ Zan 'wo ‑kë Zebede gbö ‑nu 'ka bhë ‑an ‑gɔ 'pö. 'Kɛɛ Yesu ‑ya ‑pö Simɔ ‑dhë: «Kö ꞊kun 'ö 'suö ‑yö ü ‑kë! 'Go ꞊dɛɛ ‑bha zlöö a ‑dho ka kë 'kplö ‑zuö mɛ ‑nu ‑gɔ ‑mɛ 'ka kö 'ka nu ‑an 'ka n ꞊dhia.» ");
INSERT INTO dnj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","꞊Dhɛ ‑kë 'dhö 'wo nu wo ‑bha 'yitagɔ 'ka 'yi 'kpong 'dhiö, 'ö 'wo pë 'plɛ to mü 'wo ‑ziö Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu ‑yö ‑kë pödhɛ do 'bhaa 'gü, 'ö mɛ do 'ö ꞊wee ‑ya ‑kë bhë 'yö nu. ꞊Dhɛ ꞊ya Yesu yö, 'yö ‑gblü ‑a 'dhiö 'yö ꞊bhɛa ‑a ‑dhë 'ö‑ pö: «N ‑Gɔmɛ, 'ö ꞊ya kë ꞊nɛ ‑yö ü ‑dhi ‑a ‑dhë ‑wun 'ka, ‑bhö n bun kë 'slööslö!» ");
INSERT INTO dnj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'Ö Yesu ‑yö ö ‑kɔ ‑po 'ö pa ‑a 'ka 'ö‑ pö ‑a ‑dhë: «A ‑we ‑a ‑bha, ü bun kë 'slööslö!» ‑Dhɛ do bhë ‑a 'gü, 'ö ꞊wee ‑yö go gɔɔn‑ 'ö bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","'Ö Yesu ‑ya pö ‑a ‑dhë: «'Wun 'ö ꞊nɛ kö ꞊kun 'ü‑ ꞊blɛɛ mɛ gbɛ ‑dhë, 'kɛɛ ‑bhö 'dho 'ü ü ‑de ‑zɔn slabhomɛ ‑dhë 'ü ü bun ‑kë 'slööslö ‑sü sla‑ bho ꞊nɛ ‑kɔ 'ö Moizö ‑ya ꞊blɛɛ ‑a 'ka bhë ‑a 'dhö kö ‑yaan ‑a ‑zɔn mɛ 'plɛ ‑dhë ꞊nɛ ü ‑dhɛ ꞊ya bo!» ");
INSERT INTO dnj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'Ö Yesu 'tɔ ‑yö ‑pɛn ‑dhɛ 'saadhö 'gü; mɛ ‑gbaa ꞊va ‑wo ‑kë ‑nu ‑a 'piö ꞊dhia mü kö ‑waan wo 'to 'to ‑a ‑wo ‑bha, kö ‑yö mɛ 'bhaa ‑nu dha ‑na ‑an ‑bha 'yua ‑nu ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'Kɛɛ Yesu ‑yö ‑go ‑an ziën mü, 'yö dho ö 'sloo 'ka ‑dhɛ ‑nu ‑bha kö ‑yaan ꞊bhɛa'‑. ");
INSERT INTO dnj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yi do 'ka Yesu ‑yö ‑kë mɛ ‑nu ꞊daan' ꞊dhia. ‑Dhɛ bhë ‑a ‑bha Falizi ‑mɛ ‑nu waa‑ tɔnggɔmɛ ‑nu 'wo go Galile waa‑ Zude ‑pö ‑nu 'gü 'iin Zeluzalɛmë plöö ‑wo ‑kë ꞊yaannu ‑sü 'ka ‑a 'sɔɔ mü. Dëmɛ ‑bha 'piigbeedhɛ ‑yö ‑kë Yesu 'gü, 'yö‑ ‑kë 'ö mɛ ‑nu ‑bha 'yua bo ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mɛ ‑nu ‑wo gɔɔn‑ do 'yö 'tinng ꞊yua' ‑ya ‑kë ‑a bun 'nuu 'gü 'wo nuë; 'wo‑ këdhɛ ꞊mɛɛ kö 'waan‑ dhoë Yesu 'dhiö kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'Kɛɛ bɔdhɛ gbɛ yaa kë ‑dhö ‑an ‑gɔ mɛ gbung 'wo ‑kë 'kɔ 'dhiö bhë ‑a ‑wun 'gü. 'Yö 'wo ‑da ‑a 'ka 'kɔ tuö, 'wo ‑dhɛ 'dhi do bho 'wo‑ to ö ‑bha 'nuu 'gü, 'wo‑ ꞊yɔɔ mɛ ‑nu gbung 'gü kɔɔ mü Yesu 'dhiö ‑dhɛ gia‑ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","꞊Dhɛ 'ö Yesu ꞊ya mɛ ‑nu 'wo bhë ‑an ‑bha ‑zo ‑yö ö ‑bha ‑sü yö, 'yö‑ pö 'yuamɛ bhë ‑a ‑dhë: «N 'bhamɛ, 'ma ziö ü bha ꞊sɔɔn yaa ‑nu ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","'Ö tɔnggɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu ‑wo yö wo 'ko ꞊dhɛɛ' 'kpɔ ‑sü ‑bha ꞊nɛɛ: «Dö ‑mü gɔɔn‑ ꞊nɛ ‑a 'ka 'yö 'wun ꞊blɛɛ ‑Zlan ‑gɔ ꞊nëdhö e? Dö dho ‑mɔ ‑a ‑bha kö ‑yaan ziö mɛ ‑nu ‑bha ꞊sɔɔn yaa ‑nu ‑ta ‑a 'ke yaa kë ‑Zlan dosɛn 'kpaan 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","'Kɛɛ ‑zotadhe 'yö ‑kë ‑an 'gü bhë, Yesu ‑ya ‑dɔ; ꞊dhɛ ‑kë 'dhö, 'ö‑ pö ‑an ‑dhë: «‑Më ‑kë 'ö ‑zotadhe ꞊suu'‑ ‑nu 'wo ꞊nɛ 'wo ‑kë ka 'gü i? ");
INSERT INTO dnj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‑A pö ‑sü ‹'ma ziö ü ‑bha ꞊sɔɔn yaa ‑nu ‑ta› 'iin ‹‑bhö ꞊luu'‑ 'ü 'ta 'sü› bhë ‑a ‑mlë 'ö 'pëëpë ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","'Kɛɛ a‑ 'piö kö 'ka‑ dɔa ꞊nɛ ‑kɔ ‑mɔ 'wuën‑ ‑sü ‑yö ma 'a Mɛgbö 'ka n ‑gɔ 'kpongtaa zö kö 'aan‑ ziö mɛ ‑nu ‑bha ꞊sɔɔn yaa ‑nu ‑ta.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö 'tinngmɛ bhë ‑a ‑dhë: «A‑ ‑pö ü ‑dhë, ‑bhö ꞊luu'‑ 'ü ü bha 'nuu 'sü 'ü 'dho ü ‑gɔ kɔɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","‑Dhɛ do bhë ‑a 'gü, gɔɔn‑ 'ö bhë 'yö ꞊luu 'ö dɔ ö ‑gɛan mɛ 'kpɛkpɛ wö 'dhiö mü, 'yö ö bha 'nuu sü 'yö dhoë ö ‑gɔ kɔɔ 'tan ‑bho ‑Zlan 'tɔ 'piö ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","‑An 'te ‑yö ‑tun, 'wo yö ‑Zlan 'tɔ 'saa ‑blü ‑sü ‑bha, 'kɛɛ 'suö ‑yö ‑da ‑an 'gü 'wo‑ pö: «'Yië pë 'gblüünzë yö ꞊dɛɛ!» ");
INSERT INTO dnj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑go pödhɛ bhë ‑a 'gü; ‑a ‑bha 'dho ‑sü 'ka, ‑yö 'nii‑ ꞊sɔnng' 'kun ‑mɛ do 'wo‑ ‑dhɛ Levi ‑a ‑yö kö ‑yö ‑ya ‑sü 'ka 'nii‑ ꞊sɔnng' ‑kun ‑a 'gü ‑kɔ 'gü. 'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö ꞊luu'‑ 'ü ziö n 'piö!» ");
INSERT INTO dnj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","'Yö Levi ‑yö ꞊luu, 'yö pë 'plɛ to sia‑, 'yö ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","꞊Dhɛ ꞊ya kë 'dhö, 'ö Levi ‑yö Yesu ꞊bhlë ‑kë ö ‑gɔ kɔɔ. 'Nii‑ ꞊sɔnng' 'kun ‑mɛ ‑dhɛ ꞊va ‑dhɛ waa‑ mɛ 'waa gbɛ ‑nu, ‑wo ‑kë ‑an 'piö pë ‑bhö ꞊dhia mü. ");
INSERT INTO dnj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mɛ ‑nu 'wo ‑kë Falizi ‑mɛ ‑nu 'ka waa‑ tɔnggɔmɛ ‑nu ‑wo 'wun ‑blɛɛ ‑wo ꞊löö wo 'ko ‑dhë, 'ö 'wo‑ pö Yesu ‑bha ꞊guë' ‑nu ‑dhë: «‑Më ‑kë 'ö 'ka pë ‑bhö, 'ka müpë mü 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu waa‑ 'wunyaakëmɛ ‑nu ‑an 'piö e?» ");
INSERT INTO dnj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Mɛ ‑nu 'ö 'yua 'yaa ‑an ‑bha bhë, ‑an ‑bha ‑wun 'yaa ꞊dhɔngtrɔ ‑bha, 'kɛɛ mɛ ‑nu 'ö 'yua 'dho ‑an ‑bha ꞊nɛ 'wo ꞊dhɔngtrɔ ꞊mɛɛ. ");
INSERT INTO dnj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","N 'ka nu mɛ ‑nu 'wo kpengdhö ‑an 'piö, 'kɛɛ mɛ ‑nu 'waa kpengdhö ꞊nɛ 'a nu ‑an 'piö kö ‑waan wo ꞊zuö' ꞊dhië'‑ ‑Zlan 'piö.» ");
INSERT INTO dnj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yi do 'ka, mɛ ‑nu ‑wa ‑pö Yesu ‑dhë 'zü: «꞊Ya kë Zan ‑bha ꞊guë' ‑nu ‑wo wo ‑bɛn ‑to, 'ö ꞊ya kë 'wo ꞊bhɛa. ‑Kɔ do bhë ‑a 'ka, 'ö Falizi ‑mɛ ‑nu ‑bha ꞊guë' ‑nu ‑wa ꞊kaa'; 'kɛɛ ü bha ꞊guë' ‑nu 'waa wo ‑bɛn 'to.» ");
INSERT INTO dnj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ka ‑dho ‑mɔa kö mɛ ‑nu 'wo ‑an ꞊dhɔɔ kë ‑na dhe 'sü 'wlaan‑ ‑ta bhë 'kaan‑ pö ‑an ‑dhë kö ꞊kun 'ö 'wo pë ‑bhö, 'kɛɛ kö dhe ‑gɔn ‑yö ‑an 'piö a? ‑Yö ‑dho kë ka ‑de 'gü 'dhö! ");
INSERT INTO dnj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","'Kɛɛ ‑abi', yi 'ö dhe ‑gɔn dho go ‑a 'ka ‑an 'piö ꞊ya ‑lo, 'ö 'wo dho wo ‑bɛn to.» ");
INSERT INTO dnj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","'Ö Yesu ‑yö 'wun ꞊blɛɛ ‑an ‑dhë 'zü 'wun ꞊zuan' 'ka 'ö‑ pö: «Mɛ gbɛ yaa 'dho ‑mɔa kö ‑yaan sɔ ‑dëü 'klu 'kan ‑yaan yö sɔ zii 'blëdhɛ ‑bha ‑yaan ‑a ‑wɔ. ꞊Ya kë 'dhö kö ꞊ya sɔ ‑dëü ꞊siö'‑; 'go mü sɔ ‑dëü waa‑ ‑a zii waa dhi wo 'kuë‑. ");
INSERT INTO dnj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","'Iin 'zü mɛ gbɛ 'ka 'dho yɔ 'gbee‑ yö ꞊puu' 'wɔɔnwɔn 'gü ‑yaan ‑a 'dhi ‑ta. ꞊Ya kë 'dhö yɔ ‑dho ꞊puu' 'ö 'dhö bhë ‑a wü 'ö 'daawo 'ö ‑an 'plɛ 'gü‑ ꞊siö. ");
INSERT INTO dnj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","'Kɛɛ ‑abi'! ‑Ka yɔ 'gbee‑ yö ꞊puu' ‑dëü 'gü! ");
INSERT INTO dnj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","'Ö mɛ gbɛ 'yaa‑ ‑dhɔ kë yɔ 'slëënslën 'ka kö ꞊ya 'go yɔ 'gbee‑ mü ꞊dhia, bhii ‑wa pö: ‹Yɔ 'gbee‑ ꞊nɛ 'ö ‑së!› » ");
INSERT INTO dnj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","꞊Glooyi do 'ka Yesu waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑kë bɔ ꞊dhia 'blee‑ 'wo ꞊bluu'‑ kë ‑na ‑a 'ka ‑a ‑bhlö ‑nu 'gü. 'Ö‑ ‑bha ꞊guë' ‑nu ‑wo ꞊bluu'‑ ‑kpa 'bhaa ‑nu bho 'wo‑ ꞊sii si wo kwɛɛ 'ö 'wo‑ ga ‑nu ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Falizi ‑mɛ 'bhaa ‑nu ‑wo ‑kë mü, 'wo‑ pö ‑an ‑dhë: «‑Më ‑kë 'ö pë kwaa‑ tɔng ‑ya pö kö ꞊kun 'kwa‑ ‑kë ꞊glooyi 'ka 'ö 'ka‑ ‑kë ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ, yi do 'ka Davidö waa‑ ö bha mɛ ‑nu din ‑yö ‑an ‑kun bhë kaa‑ pö ꞊a? ");
INSERT INTO dnj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","‑Ya ‑pö yi bhë ‑a 'ka ‑yö ‑dho 'yö ‑da ‑Zlan ‑gɔ kɔɔ, 'yö ꞊bluu'‑ 'wo‑ ‑ya ‑Zlan ‑bha 'ka bhë 'ö slabhomɛ ꞊va ‑ya nu ‑a ‑dhë 'yö‑ ‑bhö 'yö‑ 'bhaa nu ö bha mɛ ‑nu ‑dhë, 'kɛɛ kö kwa ‑bha tɔng ‑ya ‑pö sla‑ ‑bho ‑Zlan ‑dhë ‑mɛ ‑nu ‑de 'sloo ꞊nɛ 'wo dho ꞊bluu'‑ bhë ‑a ‑bhö. ꞊Ya kë 'dhö kö pë ma ꞊guë' ‑nu ‑wa ‑kë bhë, 'yaa 'wun yaa ꞊va 'kpaan 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","'Ö Yesu ‑ya pö 'zü ꞊nɛɛ: «Ma Mɛgbö, 'a tɔɔ ꞊glooyi ‑de gia‑ bhë ‑a ‑gɔmɛ.» ");
INSERT INTO dnj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","꞊Glooyi do 'bhaa 'ka Yesu ‑yö ‑da Zuifö ‑nu ‑bha ‑bhɔkuëkɔ do 'gü, 'ö yö ‑an ꞊daan' ‑sü ‑bha. Gɔɔn‑ do ‑yö ‑kë mü, 'ö‑ ꞊kwɛɛ‑ 'gü ‑gbiö ‑yö ga ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tɔnggɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu 'yan ‑yö ‑kë Yesu ‑bha, kë ꞊nɛ ‑yö ‑dho mɛ ‑dhɛ bo ꞊glooyi 'ka kö ‑waan ‑a dɔ, bhii pë 'wo ‑kë ‑a ꞊mɛɛ' ꞊dhia 'ö tɔɔ 'wun 'wo dho ‑a dɔ ‑a ‑bha ꞊nɛ ꞊ya 'wun yaa kë. ");
INSERT INTO dnj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","꞊Dhɛ ‑kë ꞊nɛ Yesu ‑yö ‑an ‑bha ‑zotadhe ‑dɔ bhë, 'yö‑ pö mɛ 'yö‑ ‑gbiö ‑yö ga ‑a ‑bha bhë ‑a ‑dhë: «‑Bhö ꞊luu'‑ 'ü dɔ ü ‑gɛan mɛ 'plɛ 'dhiö zö!» Mɛ 'ö bhë 'yö ꞊luu 'yö dɔ ö ‑gɛan mü. ");
INSERT INTO dnj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «A ‑dho ka ꞊dhɛɛ' kpɔ: ‑Më 'ö kwa ‑bha tɔng ‑ya pö 'kwa‑ kë ꞊ɛ? ‑Wo 'wun ‑së kë ꞊glooyi 'ka i 'iin ‑wo 'wun yaa kë e? ‑Wo mɛ dha ꞊i 'iin ‑wo mɛ 'gü ꞊siö'‑ e?» ");
INSERT INTO dnj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","꞊Dhɛ 'yö ‑an 'plɛ ‑ta ‑ga, 'yö‑ pö mɛ 'ö bhë ‑a ‑dhë: «‑Bhö ü ‑gbiö 'po!» 'Yö ö ‑gbiö ‑po 'ö‑ ‑gbiö ‑yö to mü 'ö bo. ");
INSERT INTO dnj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Ö 'wun ‑yö ‑na mɛ ‑nu 'wo ‑kë mü ‑an ‑zuë 'sönggö ‑sönggö, 'wo yö pë 'wo dho ‑a kë Yesu 'ka ‑a ꞊blɛɛ' ‑sü ‑bha wo 'ko ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","'Töng 'ö 'dhö bhë ‑a 'ka, Yesu ‑yö ‑dho ‑tɔn tuö kö ‑yaan ꞊bhɛa'‑; 'ö gbeng ‑yi do sü 'ö ꞊bhɛa ‑a 'ka ‑Zlan ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","꞊Dhɛ 'ö‑ ‑dhɛ ꞊ya 'po, 'yö ö bha ꞊guë' ‑nu ꞊dhɔɔ ‑kë, 'yö ‑an 'gɔɔ‑ do ö ga ꞊plɛ sü ‑an 'gü; 'yö ‑an 'tɔ kpɔ bɔmɛ ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mɛ 'wo 'dhö bhë ‑an 'tɔ 'ö ꞊nɛ: Simɔ 'yö‑ 'tɔ kpɔ Piɛɛ 'ka waa‑ ö dheglu Andre, Zakö, Zan, Filipö, Baatelemi, ");
INSERT INTO dnj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiö, Toma, Zakö Alefe gbö, Simɔ 'wo‑ 'tɔ kpɔ 'yënngsiömɛ 'ka ö ‑bha 'sɛgɔ ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zakö gbö Zudë waa‑ Zuda Ikaliɔtö 'yö dho zlöö 'yö ‑kë Yesu 'dhɔɔdɔmɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu waa‑ mɛ ‑nu 'wo bhë ‑wo ‑go ‑tɔn tuö 'wo dho 'wo ꞊gbaannu ‑dhɛ 'kpɛkpɛ ‑dhɛ do ‑bha. ‑A ‑bha ꞊guë' ‑nu ‑gbaa ꞊va ‑wo ‑kë mü. 'Go mü 'zü 'ö mɛ ‑gbaa ꞊va 'wo go Zude ‑sɛ ‑nu, Zeluzalɛmë plöö ‑dhɛ ‑nu 'iin pödhɛ ‑nu 'wo ‑an ‑zütodhɛ ‑nu 'gü ‑nu, Tii ‑dhɛ waa‑ Sidɔn ‑dhɛ ‑nu 'wo 'yoo 'kpong 'dhiö, ");
INSERT INTO dnj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","‑wo ‑nu ‑a 'piö mü kö 'waan‑ wo 'to 'to ‑a ‑wo ‑bha, 'iin kö ‑yö ‑an ‑bha 'yua ‑nu bho ‑an 'gü. 'Ö mɛ ‑nu 'ö ‑zuu yaa ꞊ya ‑an 'tu bɔ bhë 'yö ‑an ‑dhɛ bo 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mɛ 'plɛ ‑wa këdhɛ ‑mɛɛ kö 'waan‑ 'pa ‑a 'ka, bhii 'ö tɔɔ ꞊ya kë 'dhö 'piigbeedhɛ ‑yö ‑go ‑a 'gü, 'yö ‑an 'plɛ ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","꞊Dhɛ Yesu ꞊ya ö bha ꞊guë' ‑nu ‑ga, 'ö‑ pö ‑an ‑dhë: «꞊Zuögludhi ‑yö kë mɛ ‑nu 'ka 'yenazë ka ‑gɔ, bhii 'ö tɔɔ ‑Zlan ‑bha ‑gludëdhɛ ‑yö ‑dho kë ka ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","꞊Zuögludhi ‑yö kë mɛ ‑nu 'ö din 'dho ka kë ‑na bhë ka ‑gɔ, bhii 'ö tɔɔ ‑bhöpë ‑nu ‑dho kë ka ‑gɔ ꞊va. ꞊Zuögludhi ‑yö kë mɛ ‑nu 'ka 'gbo bɔ ‑na bhë ka ‑gɔ, bhii 'ö tɔɔ ka ‑dho 'yee to 'dhiö ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","꞊Zuögludhi ‑yö kë ka ‑gɔ, 'kö ‑kë ꞊nɛ mɛ ‑nu ‑wo ‑ya ka ‑san 'ka, 'ö 'wo ‑kan ka ‑bha, 'iin 'wo 'si ‑nu bho ka ‑gɔ, 'ö 'wo ka bho yunng, ma 'a Mɛgbö 'ka n 'tɔ ‑wun 'gü 'dhee! ");
INSERT INTO dnj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","‑Ka ꞊zuögludhi kë yi 'ö pë ‑nu 'wo bhë 'wo dho kaa ka 'ka ‑a 'ka; ‑ka ‑lö ꞊zuögludhi 'ka, bhii 'ö tɔɔ ka 'kian ꞊va ‑yö ‑ya ‑sü 'ka ka ‑gɔ dhang‑ 'gü. ‑Kɔ do 'ö bhë ‑a 'ka, 'ö ‑an 'bhɛma ‑nu ‑wa ꞊kaa' ‑Zlan ‑wodhiölomɛ ‑nu 'ka 'pö 'dhiö ‑be. ");
INSERT INTO dnj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","'Kɛɛ 'yena ‑wun ‑yö ‑dho kë ꞊bhɔɔmɛ ‑nu ka 'ka, bhii 'ö tɔɔ 'ka ka ‑bha 'wun ‑së ‑nu 'plɛ yö 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","'Yena ‑wun ‑dho kë pëyagɔmɛ ‑nu ka 'ka, bhii 'ö tɔɔ din ‑yö ‑dho ka kë! 'Yena ‑wun ‑yö ‑dho kë mɛ ‑nu 'ka 'yee 'to ‑na ka 'ka, bhii 'ö tɔɔ ka ‑dho kë ꞊zuö' 'klobhɔdhe waa‑ 'gbo bɔ ‑sü ‑an 'gü! ");
INSERT INTO dnj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'Yena ‑wun ‑yö ‑dho kë mɛ ‑nu 'ö mɛ 'plɛ 'dho 'wun ‑së ꞊blɛɛ' ‑na ka ‑gɔ bhë ka 'ka, bhii 'ö tɔɔ ‑kɔ do 'ö bhë ‑a 'ka 'ö ‑an 'bhɛma ‑nu ‑wa ꞊kaa' ‑Zlan ‑wodhiölomɛ ꞊suazë ‑nu ‑gɔ! ");
INSERT INTO dnj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","'Kɛɛ mɛ ‑nu 'ka ka 'to 'to ‑na n ‑ma ꞊nɛ, a‑ ‑pö ka ‑dhë: ‑Ka ka yaagümɛ ‑nu ‑dhɔ kë, 'ka 'wun ‑së kë mɛ ‑nu 'wo ka ‑san zë ‑na bhë ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","‑Ka 'dhuë‑ 'kpɔ mɛ ‑nu 'wo 'wun 'kpöü ‑ya ‑na ka ‑bha bhë ‑an ‑bha, 'ka ꞊bhɛa'‑ mɛ ‑nu 'wo 'wun 'gbee‑ wɔ ‑na ka ‑ta bhë ‑an ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","꞊Ya kë ꞊nɛ mɛ ꞊ya ü 'to ‑ma, ‑bhö ‑a kë ꞊plɛ ‑naa ‑zɔn ‑a ‑dhë, 'iin mɛ ꞊ya ü bha gblang 'sü, ‑bhö ü ꞊kwaa' ‑a ‑zü ‑yö ü bha ‑dasɔ 'sü 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mɛ ꞊ya pë ‑dhɛ ü ‑gɔ, ‑bhö ‑a nu ‑a ‑dhë, 'ö ꞊ya kë ꞊nɛ mɛ ꞊ya pë 'sü ü ‑gɔ, kö ꞊kun 'ü‑ ‑dhɛ ‑a ‑gɔ gbɔ. ");
INSERT INTO dnj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pë 'ka‑ 'piö kö mɛ ‑ya kë ka ‑dhë bhë, ‑kaa kë 'pö ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","꞊Ya kë ꞊nɛ 'ka‑ ‑dhɔ kë mɛ 'ö ka ‑dhɔ ‑kë ‑a 'ka, ‑a ꞊truën ‑dho kë ka ‑gɔ ‑më 'ka ɛ? 'Kɛɛ kö 'wunyaakëmɛ ‑nu ‑wa ‑dhɔ ‑kë mɛ ‑nu 'wo ‑an ‑dhɔ ‑kë ‑an 'ka ꞊nɛ ‑kɔ do bhë ‑a 'dhö 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","'Ö ꞊ya kë ꞊nɛ 'ka 'wun ‑së kë mɛ 'ö 'wun ‑së ‑kë ka ‑dhë ‑a ‑dhë, ‑a ꞊truën ‑dho kë ka ‑gɔ ‑më 'ka ɛ? 'Kɛɛ kö 'wunyaakëmɛ ‑nu ‑wa ‑kë ꞊nɛ ‑kɔ do bhë ‑a 'dhö! ");
INSERT INTO dnj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'Ö ꞊ya kë ꞊nɛ 'ka 'pë dɔ mɛ 'ka‑ ꞊dɔa' ꞊nɛ, ‑yö ‑dho ka ‑bha 'pë bho ‑a ‑bha, ‑a ꞊truën ‑dho kë ka ‑gɔ ‑më 'ka ɛ? 'Wunyaakëmɛ ‑nu ‑wo 'pë ‑dɔ wo 'ko ‑nu ‑bha. ‑Yö ‑kë 'dhö kö 'pë ‑nu 'wo‑ dɔ wo 'ko ‑nu ‑bha bhë, ‑waan ‑a ‑yɛ 'zü kë wo 'ko ‑nu ‑dhë! ");
INSERT INTO dnj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","‑Abi'! Ka ‑bha 'ka, ‑kaa ‑dhɔ kë ka yaagümɛ ‑nu 'ka, 'ka 'wunsë kë ‑an ‑dhë. 'Go mü 'ka pë ‑nu nu ‑an ‑dhë, kö ꞊kun 'ka ka ‑zo ‑kë ‑a ‑yɛ 'zü 'piö. ꞊Ya kë 'dhö ka ‑dho ka 'kian ꞊va yö, 'ö 'ka dho kë ‑Zlan 'ö ‑ziö pë 'plɛ ‑ta bhë ‑a ‑bha 'në ‑nu 'ka, bhii ‑a këwun ꞊yö ‑së mɛ ‑nu 'waa mɛ ‑ya 'ti kë waa‑ 'gluyaamɛ ‑nu ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ka 'pö, ‑ka pa mɛ ‑nu 'yena yö ‑sü 'ka ꞊nɛ ‑kɔ 'ö ka Dë ‑Zlan 'dho pa ‑sü 'ka mɛ ‑nu 'yena yö ‑sü 'ka bhë ‑a 'dhö! ");
INSERT INTO dnj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kö ꞊kun 'ka za dɔ mɛ gbɛ ‑bha, ‑yö ‑kë 'dhö kö ꞊kun 'ö ‑Zlan ‑dho za dɔ ka ‑bha. Kö ꞊kun 'ka za ‑lo mɛ gbɛ tuö, ‑yö ‑kë 'dhö kö ꞊kun 'ö ‑Zlan dho za ‑lo ka tuö. ‑Ka ziö mɛ ‑nu ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta, ꞊ya kë 'dhö, ‑Zlan dho ziö ka ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","‑Ka pë nu mɛ ‑nu ‑dhë, ꞊ya kë 'dhö ‑Zlan ‑yö ‑dho pë nu ka ‑dhë 'pö; ‑yö ‑dho pë dan papasü 'ö‑ ‑lo ka ‑bha gblang 'yuö‑ 'gü, bhii 'ö tɔɔ ‑yö ‑dho ö bha gbaɔ dan 'yö‑ nu ka ‑dhë ꞊nɛ ‑kɔ 'ka‑ nuë ka 'ko ‑nu ‑dhë bhë ‑a 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","'Ö Yesu ‑yö 'wun ꞊zuan' do ‑zɔn ‑an ‑dhë 'zü 'ö‑ pö: «꞊Ya kë ꞊nɛ 'yënngtiimɛ ‑nu ꞊wa 'dhiö ‑sü wo 'ko 'ka, ‑dhɛ 'wo‑ ‑bha ꞊plɛ wo 'ka 'dho ‑püö ‑glu 'kpa 'dhi do 'gü a? ");
INSERT INTO dnj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","꞊Guë' gbɛ 'yaa ꞊va yaa zië ö ‑gɔmɛ ‑ta, 'kɛɛ ꞊guë' mɛ 'ö ꞊ya pë dɔ ꞊duö ‑së 'ka, ‑yö ‑dho kë ꞊nɛ ö ‑gɔmɛ 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‑Më 'yö‑ ‑kë 'ö ꞊blëë' 'yö ü dheglu 'yënngdhö bhë 'ü‑ ‑ga, 'kɛɛ kö ü ‑bha 'lü ‑gba ‑yö ü 'yënngdhö ꞊e? ");
INSERT INTO dnj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ü ‑dho ‑a pö ‑kɔklë ü dheglu ‑dhë: ‹N dheglu, dɔ! 'A ꞊blëë' bho ü 'yënngdhö›, kö bhi ‑de 'pö ü ‑bha 'lü ‑gba ‑yö ü 'yënngdhö ꞊e? Mɛ 'yan ‑ta ‑wun kë ‑mɛ, ‑bhö ü ‑bha 'lü ‑gba 'yö ü 'yënngdhö bhë ‑a bho mü ꞊kun kö 'ü ‑dhɛ yö ‑së 'ka 'üën‑ ꞊tun ü dheglu ‑bha ꞊blëë' bho ‑a 'yënngdhö ‑süë. ");
INSERT INTO dnj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","'Lü ‑së 'yaa bha ö bhɛ yaa 'ka 'iin 'lü yaa ‑de 'pö 'yaa bha ö bhɛ ‑së 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","'Lü 'ö ‑dhö ‑wa ‑dɔ ö bhɛ ‑bha. 'Waa figö bhɛ bho 'ginng ‑kpɔɔ 'gü 'iin 'waa lɛzɛn ‑kpa bho dankpɔɔ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","‑Kɔ do bhë ‑a 'ka 'ö mɛ këwunsëëzë ‑yö ö ‑bha pë ‑së sü ö ꞊zuö' 'gü, 'ö mɛ këwunyaazë ‑de 'pö 'yö ö bha 'wun yaa sü ö ꞊zuö' 'gü, bhii 'wun 'yö mɛ ꞊zuö' pa, ö 'dhi ‑ya ꞊blɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","'Ö‑ pö: «‑Më 'ö ‑kë 'ka n ‑dhɛ ka Dëmɛ, 'ö pë 'a‑ pö ka ‑dhë 'kaa‑ kë ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","A ‑dho mɛ 'yö n ‑wo ma 'yö‑ kun ‑së 'ka, ‑a ‑bhɔa ‑zɔn ka ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","‑Yö ‑bhɔ mɛ 'ö dho ö bha 'kɔ dɔ ꞊dhia, 'yö 'sɛ pɔn ꞊gbiin, 'yö dho 'ö yöë ‑guö ‑bha ‑a zü ꞊luu'‑ ‑sü 'ka ‑a ‑bha. 'Kö ‑kë ꞊nɛ 'yiga ‑nu ‑wo ‑pa, 'wo ‑ma 'kɔ 'dhö bhë ‑a ‑bha, ‑dɔ gɛnngdhö ‑sü ‑ya ‑gɔ, bhii 'ö tɔɔ 'kɔ bhë ‑yö ‑dɔ ‑së 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","'Kɛɛ mɛ 'yö ö 'to to n ‑wo ‑bha 'ö yaa‑ 'kun, ‑yö ‑bhɔ mɛ 'ö dho ö bha 'kɔ dɔ ꞊dhia, 'yö‑ zü ‑gban 'sɛ ‑ta dhuö ‑dhɛ gia‑ ‑bha 'ö 'yaa 'sɛidhö ‑a ‑bha. ꞊Dhɛ 'ö 'yiga ‑nu ꞊wa pa, 'ö 'yi ‑nu ‑wo ‑ma ‑a ‑bha 'ö to mü 'ö ‑lo; 'yö‑ 'plɛ ‑yö ꞊wüü 'töüdhö.» ");
INSERT INTO dnj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","꞊Dhɛ Yesu ꞊ya yën 'wun 'ö bhë ‑a ꞊blɛɛ' ‑sü ‑bha 'sɛgümɛ ‑nu ‑dhë, 'yö dho Kapɛɛnaɔmë. ");
INSERT INTO dnj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","‑Dhɛ bhë ‑a ‑bha, Wlɔmë 'dhasi ‑gɔmɛ do ‑yö ‑kë mü, 'yö‑ ‑bha yuökëmɛ do ‑wungbeezë ‑yö ‑kë ‑a ‑gɔ. Yuökëmɛ 'ö bhë 'yua ‑yö ‑kë ‑a kë ꞊dhia, 'ö‑ ‑wun 'gü ꞊ya 'to 'tee kö ‑yaan ga. ");
INSERT INTO dnj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","꞊Dhɛ 'ö 'dhasi ‑gɔmɛ 'ö bhë ꞊ya Yesu 'tɔ ma, 'yö Zuifö ‑nu ‑bha mɛ zii 'bhaa ‑nu bɔ kö ‑waan pö Yesu ‑dhë ‑yö nu ‑yaan ö bha yuökëmɛ bhë ‑a ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","'Wo dho 'wo ‑lo Yesu 'piö, 'wo yö ‑bhɛa ‑a ‑dhë ‑sü ‑bha ꞊naazë 'ka, 'wo‑ pö ‑a ‑dhë: «Gɔɔn‑ 'ö bhë, ‑nu ‑a ‑dhë ‑sü ‑ya ‑ma ‑kun, ");
INSERT INTO dnj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","'ö tɔɔ yië‑ 'sɛgümɛ ‑nu ‑dhɔ ‑ya ‑kë, 'go mü 'zü yö ꞊nɛ 'yö yië‑ ‑bhɔkuëkɔ dɔ.» ");
INSERT INTO dnj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑ziö ‑an 'piö. ꞊Dhɛ 'ö ꞊wa yö 'kɔ 'ka ꞊klöö', 'ö 'dhasi ‑gɔmɛ bhë 'yö ö 'bhamɛ ‑nu bɔ kö ‑waan pö ‑a ‑dhë ö ‑wo 'ka ꞊nɛɛ: «N ‑Gɔmɛ, kö ꞊kun 'ü ü ‑de ꞊sëë' bho 'kpaan, 'ö tɔɔ yaa n ‑ma 'kun kö 'üën‑ ‑da n ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","‑A ‑wun 'gü ꞊nɛ 'a n ‑de yö ꞊nɛ yaa n ‑ma 'kun kö 'a nu ü 'dhiö, 'kɛɛ ‑bhö ü ‑wo 'kpaan pö, ꞊ya kë 'dhö ma yuökëmɛ ‑dho dha. ");
INSERT INTO dnj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ma ‑de gia‑ n ꞊kɔɔnmɛ ‑nu ‑wo ‑dhö, 'ö go mü ma 'dhasi ‑nu 'a ‑an ꞊kɔɔn 'wo ‑dhö. 'Ö 'ma‑ pö ‑a mɛ do ‑dhë: ‹‑Bhö 'dho!› 'ö dho n ‑wo 'ka; 'ö 'ma‑ pö ‑a mɛ do 'bhaa ‑dhë 'zü: ‹‑Bhö nu!› 'ö nu n ‑wo 'ka; 'ö 'ma‑ pö yuökëmɛ ‑dhë: ‹Pë 'ö ꞊nɛ, ‑bhö ‑a kë!› 'ö‑ ‑kë n ‑wo 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","꞊Dhɛ 'ö Yesu ꞊yaa‑ ‑wo 'ö ꞊nɛ ‑a ma, 'yö 'dhasi ‑gɔmɛ ‑wun ‑ya 'te tun, 'ö ꞊dhië mɛ ‑gbaa ‑nu 'wo ‑ziö ‑a 'piö bhë ‑an 'piö ꞊zian', 'yö‑ pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë n 'ka ‑zo yö n ‑ma ‑sü 'ö ꞊suu'‑ 'dhö ꞊nɛ ‑a yö do, ‑abi', ‑a mɛ gbɛ 'yaa 'dhö Izlaɛlö ‑sɛ ‑de 'ö ꞊nɛ ‑a 'gü!» ");
INSERT INTO dnj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","꞊Dhɛ ꞊ya kë 'dhö, bɔmɛ ‑nu ‑wo ‑yɛ wo 'zü 'wo dho 'dhasi ‑gɔmɛ bhë ‑a ‑gɔ kɔɔ, 'ö 'wo yuökëmɛ 'ö ꞊sia 'wo‑ yö kö ‑a ‑bha 'yua ꞊ya bo. ");
INSERT INTO dnj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑dho pödhɛ do 'wo‑ ‑dhɛ Nainë bhë ‑a 'gü. ‑A ‑bha ꞊guë' ‑nu waa‑ mɛ ‑gbaa ꞊va ‑wo ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","꞊Dhɛ 'wo ꞊yɔɔn ‑na ‑da plöö ‑dhɛ 'sɔɔ kö mɛ ‑nu ‑wo 'dho ‑na mɛ do 'ö ga bhë ‑a ‑bin ꞊dhia. Gɔɔn‑ 'ö bhë ‑yö ‑kë dhe 'ö ꞊gɛandhe 'ka ‑a ‑bha 'në dosɛn 'kpaan 'yö‑ ‑gɔ ‑a 'ka. Mɛ ‑gbaa ꞊va 'wo go pödhɛ 'ö bhë ‑a 'gü, ‑wo ‑kë dhebɔ 'ö bhë ‑a 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","꞊Dhɛ 'ö dhebɔ 'ö bhë Dëmɛ ꞊yaa‑ yö, 'ö‑ 'yena ‑ya ‑kë 'ö‑ pö ‑a ‑dhë: «Kö ꞊kun 'ü 'gbo bɔ gbɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö ꞊yɔɔn ꞊glöö ‑bun ‑a 'gü ‑pë bhë ‑a ‑bha 'yö pa ‑a 'ka 'ö mɛ ꞊glöö bun ‑mɛ ‑nu 'wo bhë 'wo ꞊gbaannu, 'ö Yesu ‑ya pö: «'Në gɔɔn‑ 'ü ꞊nɛ, a‑ ‑pö ü ‑dhë, ‑bhö ꞊luu'‑!» ");
INSERT INTO dnj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","'Ö mɛ 'ö ga bhë 'yö ꞊luu 'ö ‑ya ö ‑gɛan 'ö yö 'wun ꞊blɛɛ' ‑sü ‑bha, 'ö Yesu ‑ya nu ö dhe ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","'Suö ‑yö ‑da mɛ ‑nu 'wo ‑kë mü ‑an 'plɛ 'gü, 'ö 'wo yö ‑Zlan 'tɔ 'saa ‑blü ‑sü ‑bha 'wo‑ pö: «‑Zlan ꞊ya ö ‑wodhiölomɛ do ꞊va bɔ kwa ‑dhë!» 'Go mü 'wo‑ pö 'zü: «‑Zlan ꞊ya nu ‑dɔ ö bha 'sɛgümɛ ‑nu ‑gban ‑gɔ ꞊dhia!» ");
INSERT INTO dnj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","'Ö 'wun 'ö Yesu ‑ya ‑kë bhë 'ö ‑pɛn Zude ‑sɛ waa‑ ‑a ‑zütodhɛ ‑nu 'saadhö 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zan Batisö ‑bha ꞊guë' ‑nu ‑wo ‑nu, 'ö 'wun ‑nu bhë 'wo‑ 'plɛ ꞊blɛɛ ‑a ‑dhë. 'Ö Zan ‑yö ‑an mɛ ꞊plɛ ꞊dhɔɔ ‑kë, ");
INSERT INTO dnj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'yö ‑an bɔ Dëmɛ 'piö kö ‑waan ‑a ꞊dhɛɛ' 'kpɔ ꞊nɛɛ: «Ü mɛ 'yi‑ dɔa ꞊nɛ ‑yö ‑dho nu bhë ‑a 'ka i, 'iin 'yi ‑ya mɛ gbɛ ‑gɔ e?» ");
INSERT INTO dnj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ‑lo Yesu 'piö, 'ö 'wo‑ pö ‑a ‑dhë: «Zan Batisö 'ö yi bɔ kö 'yiën‑ ü ꞊dhɛɛ' 'kpɔ ꞊nɛɛ ü mɛ 'yi ‑ya ‑a ‑bha nu ‑sü ‑gɔ bhë ‑a 'ka i, 'iin yi ‑dho ‑ya mɛ gbɛ ‑gɔ e?» ");
INSERT INTO dnj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","‑Dhɛ do bhë ‑a 'gü, 'ö Yesu ‑yö yö 'yuamɛ ꞊plëëzë waa‑ 'tɔsiömɛ ‑nu ‑an ‑dhɛ bo ‑sü ‑bha, kö ‑yö ‑zuu yaa bho ‑na mɛ ‑nu 'gü, kö ‑yö 'yënngtiimɛ ‑nu ꞊plëëzë 'yan 'po ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","꞊Dhɛ ‑kë 'dhö 'ö Yesu ‑ya pö Zan ‑bha bɔmɛ ‑nu ‑dhë: «‑Ka 'dho, pë 'ka‑ yö 'iin 'ka‑ ma ꞊nɛ 'ka‑ ꞊blɛɛ Zan ‑dhë ꞊nɛɛ: 'Yënngtiimɛ ‑nu ‑wo ‑dhɛ yö ‑na, ‑gɛntɔsiömɛ ‑nu ‑wo 'ta ‑na, ꞊weemɛ ‑nu ‑bha ꞊wee ‑yö 'go ‑na ‑an ‑bha, 'totamɛ ‑nu ‑wo 'wun ma ‑na, gamɛ ‑nu ‑wo 'go ‑na ga 'gü, 'wuntaɔsë ‑yö ꞊blɛɛ' ‑na 'yenamɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","꞊Ao'! ꞊Zuögludhi ‑yö kë mɛ 'ö yaa 'dho go ‑zo ‑yö n ‑ma ‑sü 'gü ‑a ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","꞊Dhɛ 'ö Zan ‑bha bɔmɛ ‑nu ꞊wa 'yɛ wo 'zü ꞊wa 'dho, 'ö 'wun 'ö ‑gban Zan ‑bha, 'ö Yesu ‑yö yö ‑a ‑blɛɛ mɛ gbung 'wo bhë ‑an ‑dhë ‑sü ‑bha 'ö‑ pö: «'Yënngtaadhɛ 'ö Zan ‑yö ‑kë ‑a ‑bha bhë, 'dho 'ö 'ka‑ wo ‑a ‑bha bhë, ‑më 'ö 'ka dho ‑a ‑ga ꞊dhia 'ma ɛ? 'Lü 'në 'ö 'tëë 'dho ‑a ꞊tuun' ‑na bhë 'ö 'ka dho ‑a ‑ga ꞊dhia ꞊a? ");
INSERT INTO dnj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'Yaa 'dhö, ‑më 'ka dho ‑a ‑ga ꞊dhia ꞊ɛ? Gɔɔn‑ do 'ö sɔ ‑së 'dho ‑a ‑bha yö ‑mü ‑a? 'Kɛɛ ꞊dhɛ 'a ‑ga ‑a 'gü bhë, ‑yö ‑kë ꞊nɛ mɛ ‑nu 'ö sɔ ꞊sɔnng' 'gbeezë 'dho ‑an ‑bha bhë, ‑an këdhɛ 'ö tɔɔ ‑dhɛ ‑së ‑dhɛ 'gü, ‑wo ‑kë ‑gludë ‑nu ‑bha wɔ ‑a 'gü ‑kɔ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","꞊Dhɛ 'ö 'dhö ꞊nɛ, ‑më 'ka dho ‑a ‑ga ꞊dhia 'sa? ‑Zlan ‑wodhiölomɛ do ‑mü ‑a? A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: ꞊Ii‑, 'ö ‑de, mɛ 'ka‑ yö bhë, ‑yö ‑ziö ‑Zlan ‑wodhiölomɛ ‑ta, ");
INSERT INTO dnj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","bhii Zan 'ö bhë pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö ‑gban ‑a ‑bha ‑ya ‑pö: ‑Zlan ‑ya ‑pö: 'Ma ma bɔmɛ do bɔ ü 'dhiö, kö ‑yaan ü bha zian ‑gblooga ‑pë kë. » ");
INSERT INTO dnj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü ꞊nɛɛ: «A‑ ‑pö ka ‑dhë: Mɛ 'ö‑ 'tɔ dho kë ꞊va ‑yaan ꞊zië' Zan ‑ta 'yaa 'dhö, 'kɛɛ kë‑ wo 'dhö bhë, mɛ 'ö 'gügaazë ‑Zlan ‑bha ‑gludëdhɛ 'gü, ꞊yö ꞊va 'yö ꞊zië' ‑a ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","'Sɛgümɛ ‑nu waa‑ 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu ‑wo ‑nu, 'ö 'wo wo 'to to ‑a ‑wo ‑bha; 'ö 'wo‑ dɔa ꞊nɛ ‑Zlan 'ö bhë ‑yö kpengdhö, 'ö 'wo nu Zan 'piö, 'yö ‑an ‑go ꞊sɔɔn yaa 'gü ‑bɔyiödhe ‑kë. ");
INSERT INTO dnj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'Kɛɛ Falizi ‑mɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa 'we ‑a ‑bha kö Zan ‑yaan wo bɔ yiö. ‑A ‑kë 'dhö ‑sü 'ka, pë 'ö ‑Zlan dho ‑a kë ‑an ‑dhë ‑be bhë, ‑wa ‑bhɔ wo ‑dhë ꞊taa'. ");
INSERT INTO dnj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","'Ö Yesu ‑ya pö ‑an ‑dhë: «꞊Dhɛ 'ö 'dhö ꞊nɛ, a ‑dho mɛ ‑nu 'wo ꞊dɛɛ ‑yi ꞊nɛ ‑a 'gü, ‑an ‑zɔn dö 'ka ɛ? ‑Wo ‑bhɔ dö ‑bha ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","‑Wo ‑bhɔ 'në ‑nu 'wo ‑ya ‑sü 'ka pö‑ 'dhëë ziën 'wo 'we ‑na wo 'ko ‑nu 'piö ‑an ‑bha: ‹'Ö 'yië 'truu 'piö kö 'kaan‑ 'tan kë ‑a ‑bha 'ö 'kaa 'tan kë! 'Ö 'yië gaa‑ ‑tan bho kö 'kaan‑ 'gbo bɔ 'ö 'kaa 'gbo bɔ ꞊nɛ!› ");
INSERT INTO dnj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","‑A ‑gɛn 'ö tɔɔ: Zan Batisö ‑yö ‑nu, 'ö 'yaa ‑bhöpë 'waa gbɛ ‑bhö, 'iin 'yaa ‑drɔɔn mü, 'ö 'ka‑ pö ꞊nɛɛ: ‹‑Zuu yaa ‑ya 'gü!› ");
INSERT INTO dnj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Ö ma 'a Mɛgbö 'ka, 'a nu 'a pë ‑bhö 'ö 'a ‑drɔɔn mü 'ö 'ka‑ pö: ‹Gɔɔn‑ 'ö ꞊nɛ ‑yö 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu waa‑ 'wunyaakëmɛ ‑nu ‑an 'bhamɛ 'ka; yö do bhë ꞊yö ‑siözë!› ");
INSERT INTO dnj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","'Kɛɛ ‑Zlan ‑bha 'kpaakpadhɛ bhë mɛ ‑nu 'ö ꞊waa‑ ‑dhɛ 'wun gia‑ ‑wa dɔ ꞊nɛ ‑yö kpengdhö.» ");
INSERT INTO dnj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Falizi ‑mɛ do ‑yö Yesu ꞊dhɔɔ ‑kë yi do 'ka kö 'waan‑ pë ‑bhö wo 'ko ꞊bhaa, 'ö Yesu ‑yö dho gɔɔn‑ 'ö bhë ‑a ‑gɔ kɔɔ kö 'waan‑ pë ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pödhɛ 'ö bhë ‑a 'gü ꞊sɔɔnkëdhe do ‑yö ‑kë mü. ꞊Dhɛ 'ö ꞊yaa‑ ma ꞊nɛ Yesu ‑yö pë ‑bhö ꞊dhia Falizi ‑mɛ bhë ‑a ‑gɔ kɔɔ, 'yö dho ‑guö ‑kpo 'lü 'bhlöngbhlöng 'ö pë 'yi 'tëë ‑sëëzë ‑ya pa bhë ‑a 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'yö bɔ Yesu ꞊zlöö ꞊zian' 'yö dho ‑a ‑gɛn 'piö 'ö 'gbo bɔ, 'ö‑ 'yënng ‑yö ‑lo Yesu ‑gɛn 'dhɛadhö. ꞊Dhɛ ꞊ya kë 'dhö, 'yö ö bha wun ‑ta ‑a ‑gɛan 'yö ö ‑bɛn ‑yɛ ‑a ‑gɛn ‑bha ꞊nɛ ‑kɔ 'wo mɛ 'kpeng mü ‑na ‑a 'ka bhë ‑a 'dhö, 'yö pë 'yi 'tëë ‑sëëzë bhë 'yö‑ ꞊kpënng ‑a ‑gɛn ‑ta dhuö. ");
INSERT INTO dnj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","꞊Dhɛ 'ö Falizi ‑mɛ 'ö Yesu ꞊dhɔɔ ‑kë bhë 'ö pë ‑nu 'wo ꞊nɛ ꞊yaa‑ yö, 'yö‑ pö ö ‑de ꞊zuö' 'piö ꞊nɛɛ: «'Ö ꞊ya kë ꞊nɛ gɔɔn‑ 'ö ꞊nɛ ‑Zlan ‑wodhiölomɛ ‑mü 'gbödhö, kö ‑yö ‑dho dhebɔ 'yö paa ꞊nɛ ‑a dɔ, 'go mü 'ö mɛ 'ö‑ 'ka 'yö‑ dɔ, bhii ‑yö ꞊sɔɔnkëdhe 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö Falizi ‑mɛ bhë ‑a ‑dhë: «Simɔ, 'wun do 'bhaa ‑yö n ‑gɔ kö 'aan‑ ꞊blɛɛ'‑ ü ‑dhë.» 'Ö Simɔ ‑ya pö: «N ‑Gɔmɛ, ‑bhöë ꞊blɛɛ'‑!» ");
INSERT INTO dnj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","'Ö Yesu ‑ya pö ‑a ‑dhë: «'Pëdɔmɛ do ‑bha 'wëü‑ ‑yö ‑kë mɛ ꞊plɛ ‑bha, mɛ do ‑bha 'ö tɔɔ dönie ꞊këng' 'sɔɔdhu, 'ö mɛ do ‑bha ‑yö ‑kë 'pö ‑a 'gɔɔ‑ 'sɔɔdhu 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","꞊Dhɛ 'ö ‑kë ꞊nɛ mɛ ꞊plɛ 'wo bhë ‑an ‑kɔ yaa 'dho ‑mɔ ‑a bho ‑sü ‑bha, 'yö ö bo ‑dhɛ 'wo‑ ‑bha ꞊plɛ ö bha 'pë 'yö ‑an ‑bha bhë ‑a 'ka. ꞊Ya kë 'dhö mɛ ꞊plɛ 'wo 'pë dɔ ‑an ‑bha bhë, dö 'ö dho ‑a ‑dhɔ kë 'pëdɔmɛ 'ka ꞊duö ꞊e?» ");
INSERT INTO dnj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","'Ö Simɔ ‑ya ‑daa ‑kë 'ö‑ pö: «A n ‑zo ‑ta ꞊nɛ, mɛ 'ö ‑a ‑bha 'wëü‑ ‑yö ‑kë ꞊va, 'ö ö ꞊kwaa ‑a ‑wun ‑zü bhë ꞊nɛ, 'yö dho ‑a ‑dhɔ kë ‑a 'ka ꞊duö.» 'Ö Yesu ‑ya pö ‑a ‑dhë: «'Wun gia‑ 'ü‑ ꞊blɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","꞊Dhɛ ꞊ya kë 'dhö, 'ö ꞊sië dhebɔ 'ö bhë ‑a 'piö, 'yö‑ pö Simɔ ‑dhë ꞊nɛɛ: «Dhebɔ ꞊nɛ ü‑ ‑yö ‑a? Nu 'a‑ wo ü ‑gɔ kɔɔ ꞊nɛ, ü 'ka 'yi nu n ‑dhë kö 'aan‑ n ‑gɛn 'zlu ‑a 'ka (꞊nɛ ‑kɔ 'ö kwa ‑bha wɔ ‑kɔ 'dhö ‑a 'ka bhë ‑a 'dhö), 'kɛɛ yö 'pö ‑yö n ‑gɛn ‑zlu ö 'yënng 'ka, 'yö ö bha wun ‑ta ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ü 'ka nu n ‑gɔ zian‑ n 'kpeng mü ‑sü 'ka, 'kɛɛ 'yö sü n ‑ma ‑da ü ‑gɔ kɔɔ ‑sü ‑bha ꞊sia, yaa ö bo ö ‑bɛn ‑yɛ n ‑gɛn ‑bha ‑sü 'ka ꞊nɛ ‑kɔ 'wo mɛ 'kpeng mü ‑na ‑a 'ka bhë ‑a 'dhö; ");
INSERT INTO dnj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ü 'ka 'yɔn gbɛ ‑lo n tuö, 'kɛɛ yö 'pö ‑yö pë 'yi 'tëë ‑sëëzë ‑lo n ‑gɛn ‑ta dhuö. ");
INSERT INTO dnj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","‑A ‑wun 'gü 'a‑ pö ü ‑dhë: ‑Dhɔ ꞊va 'yö‑ ‑zɔn bhë ‑ya ‑zɔn ꞊nɛ ‑Zlan ꞊ya ziö ‑a ‑bha ꞊sɔɔn yaa ꞊plëëzë ‑nu 'plɛ ‑ta, 'kɛɛ mɛ 'ö ‑Zlan ꞊ya ziö ‑a ‑bha 'wun yaa 'bhe 'tee ‑ta, ‑a ‑bha ‑Zlan ‑dhɔ ꞊yö 'tee.» ");
INSERT INTO dnj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö dhebɔ bhë ‑a ‑dhë: «'Ma ziö ü bha ꞊sɔɔn yaa ‑nu ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","'Ö mɛ ‑nu 'wo ‑kë ‑a 'piö pë ‑bhö ꞊dhia bhë, 'wo‑ pö wo ‑de ꞊zuö' 'piö ꞊nɛɛ: «Dö ‑mü gɔɔn‑ 'ö ꞊nɛ ‑a 'ka 'yö ziö ‑na mɛ ‑nu ‑bha ꞊sɔɔn yaa ‑nu ‑ta ꞊nɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu ‑yö ‑to mü 'yö‑ pö dhebɔ bhë ‑a ‑dhë: «Ü ‑bha ‑zo ‑yö n ‑ma ‑sü ꞊ya ü dha, ‑bhö 'dho ꞊zuöyagluu 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑dho pö‑ ꞊vava waa‑ pö‑ 'sɛnsɛn 'gü ‑dhɛ ‑nu ‑bha ‑Zlan ‑wo ꞊blɛɛ' ‑sü 'ka; 'yö 'wuntaɔsë 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑bha, 'yö‑ ꞊blɛɛ mɛ ‑nu ‑dhë. ‑A ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑wo ‑kë ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","‑Kɔ do bhë ‑a 'ka 'ö dhoo ‑nu 'bhaa ‑nu 'yö ‑zuu yaa ‑nu bho ‑an 'gü waa‑ ‑a mɛ ‑nu 'yö ‑an ‑bha 'yua ‑nu bho ‑an 'gü bhë, 'wo ‑ziö ‑a 'ka ‑a 'piö 'pö. ‑A mɛ 'bhaa ‑nu 'tɔ 'ö ꞊nɛ: Mali 'ö go Madala 'ö Yesu ‑yö ‑zuu yaa 'slaplɛ bho ‑a 'gü 'dhiö ‑be bhë, ");
INSERT INTO dnj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Zanë 'yö ‑kë Elɔdö ‑bha yuökëmɛ ‑nu ‑gɔmɛ Suza bɔɔ 'ka bhë oo, Sizanë waa‑ dhoo ‑nu ꞊plëëzë 'ö 'wo pë ‑nu 'wo ‑kë ‑an ‑gɔ, 'wo‑ nu Yesu waa‑ ö bha ꞊guë' ‑nu ‑dhë, ‑nu ‑an ‑dhë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pö‑ 'saadhö ‑a 'gü ‑mɛ ‑nu ‑wo ‑go mü, 'wo nu Yesu 'piö. ꞊Dhɛ mɛ ‑gbaa ꞊va ꞊wa nu wo 'ko ꞊bhaa ‑a 'piö mü bhë, Yesu ‑yö 'wun ꞊blɛɛ ‑an ‑dhë 'wun ꞊zuan' 'ka 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Mɛ do ‑yö ‑dho ö bha pëga ‑pɛn ꞊dhia ö ‑gɔ ꞊bhlöö‑. ‑Yö ‑kë ö bha pëga ‑pɛn ꞊dhia, 'ö ‑a ga 'bhaa ‑nu ‑wo ‑püö zian ‑gbloo 'piö, 'ö mɛ ‑nu ‑wo ꞊taa ‑a ‑ta, 'ö ‑ma ‑nu ‑wa ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","'Ö‑ ga 'bhaa ‑nu ‑wo ‑püö 'sɛ 'ö gwa ‑ta dhuö ‑a ‑ta. ꞊Dhɛ 'ö ‑a 'plüün ‑nu ꞊wa bhɔ 'dhö, 'wo 'kpɛa kun, 'ö tɔɔ ‑dhɛ bhë 'yaa ‑saa. ");
INSERT INTO dnj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'Ö‑ ga 'bhaa ‑nu ‑wo ‑püö 'zü ꞊blëë' 'ginngzë 'plüün 'gü, 'ö waa‑ pëga ‑së ꞊sia 'wo ꞊kpɛa wo 'ko ꞊yië', 'ö ꞊blëë' 'ginngzë ‑yö sɔ ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","'Kɛɛ ‑a ga 'bhaa ‑nu ‑wo ‑püö 'sɛ ‑dhɛ ‑së ‑dhɛ 'gü; 'wo bhɔ 'wo ꞊kpɛa, 'ö‑ ‑kpa ‑yö ‑ya; ‑a 'bhaa ‑nu ‑kpa ga ‑wo ‑kë ꞊këng' do.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö 'zü ꞊nɛɛ: «‑Ka ka 'to 'to ‑së 'ka, ꞊ya kë ꞊nɛ ka 'wun ma ‑to ‑yö ‑dhö, kö 'wun ꞊nɛ, ‑kaa ‑gɛn dɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu ‑wa ꞊dhɛɛ' kpɔ, 'wun ꞊zuan' 'yö‑ ‑zɔn bhë ‑a ‑gɛn 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","'Yö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ka 'pö, 'wundɔdhe 'yö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑bha 'yö ‑bin ‑sü 'ka, 'ma ‑dhɛ 'po ‑a ‑ta kö 'kaan‑ ‑gɛn dɔ; 'kɛɛ mɛ ‑nu 'wo to ‑an ‑bha 'ka, a‑ ‑blɛɛ ‑an ‑dhë ‑a ‑zɔn 'wun ꞊zuan' 'gü ‑sü 'ka; ‑yö kë 'dhö kö ‑waan ‑a ‑ga 'kɛɛ kö ‑waan 'kun ‑a yö ‑sü 'ka, 'iin kö ‑waan ‑a ma 'kɛɛ kö ‑waan 'kun ‑a ‑bho 'kou dɔ ‑sü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","'Ö‑ pö: «'Wun ꞊zuan' 'a‑ ‑zɔn bhë ‑a ‑gɛn ꞊ga ꞊nɛ: Pëga 'wo‑ ‑pɛn ‑na bhë 'ö tɔɔ ‑Zlan ‑wo. ");
INSERT INTO dnj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mɛ 'bhaa ‑nu ‑wo ‑bhɔ zian ‑gblooga 'ö pëga ‑yö ‑püö ‑a ‑ta bhë ‑a ‑bha; 'wo ‑Zlan ‑wo ‑ma, 'kɛɛ dü ‑yö nu 'yö ‑Zlan ‑wo bho ‑an ꞊zuö' 'piö. ‑Yö kë 'dhö kö ꞊kun 'wun ‑dhɛ 'wun gia‑ ‑sü waa‑ dha ‑sü dho kë ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mɛ 'bhaa ‑nu ‑wo ‑bhɔ gwatadhɛ 'ö pëga ‑nu ‑wo ‑püö ‑a ‑ta bhë ‑a ‑bha. ꞊Wa ‑Zlan ‑wo ma 'wo‑ kun ꞊zuögludhi 'ka, 'kɛɛ ‑an yun 'yaa 'dhö; ‑wo 'wun ‑dhɛ 'wun gia‑ 'töng 'bhaa 'ka; ꞊ya kë ꞊nɛ 'güdandhe ꞊ya nu ‑an ‑ta, 'wo wo ꞊kwaa ‑zo ‑yö ‑Zlan ‑bha ‑sü ‑zü. ");
INSERT INTO dnj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","‑Dhɛ ꞊blëë' 'ginngzë 'dho ‑a ‑bha, 'ö pëga ‑nu ‑wo ‑püö ‑a ‑bha bhë ‑ya ‑zɔn mɛ ‑nu 'wo ‑Zlan ‑wo ma 'wo wo ꞊kwaa wo ‑de ‑zü wo ‑bha ‑zo ‑ta ‑a 'gü ‑wun, ꞊bhɔɔpë ‑wun, waa‑ ‑de ꞊dhɔɔbhaapë 'ö 'kpongtaa ‑a ‑wun 'gü, 'wo ꞊nëng 'ö‑ ‑kpa ‑nu 'waa kë ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","'Sɛ ‑dhɛ ‑së ‑dhɛ 'ö pëga ‑nu ‑wo ‑püö ‑a ‑ta bhë, ‑ya ‑zɔn mɛ ‑nu 'wo ‑Zlan ‑wo ma, 'wo‑ ‑da wo ꞊zuö' 'gü, ‑a ‑kun ‑së ‑sü 'plɛ 'ka, 'wo to wo ‑wo 'gü 'ö ‑an ‑kpa ‑yö ‑kë ‑dhö.» ");
INSERT INTO dnj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","'Ö‑ pö: «Mɛ gbɛ 'yaa ꞊labang dɔ, 'yaa 'gbonggbo 'gblü ‑a ‑ta, 'iin 'yaa‑ dɔ ꞊gba ꞊löö, 'waa‑ kë 'dhö. Pë ꞊ya kë 'wo‑ ‑kë 'ö tɔɔ ‑a dɔ 'wo‑ wo ‑a ‑dɔ ‑a ‑ta dhuö ‑pë ‑ta. ‑Yö kë 'dhö mɛ 'kpɛkpɛ 'wo ‑da ‑na kɔɔ kö ‑waan ‑dhɛpuudhɛ yö. ");
INSERT INTO dnj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","'Ö pë 'ö ‑dhö 'ö ‑bin ‑sü 'ka, 'yö dho kun ‑yö ‑dhɛgbɛadhɛ ‑bha ‑sü 'ka 'yaa 'dhö. Yö do bhë 'zü, 'sloo 'ka ‑wun 'yö dho kun ‑yö ‑dhɛgbɛadhɛ ‑bha ‑sü 'ka 'yaa 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","‑Ka ka ‑zo kë ka ‑de 'piö ka ‑bha 'wun ma ‑kɔ ‑wun 'gü! Bhii mɛ 'ö pë 'dhoë‑ kë ‑a ‑gɔ ‑a 'bhaa ‑dho ‑da ‑a ‑ta; 'kɛɛ mɛ 'ö pë gbɛ 'yaa‑ ‑gɔ, ‑a pë 'bhe 'tee 'ö ö ‑zo 'ta ‑na ‑a ‑wun 'gü bhë, ‑yö ‑dho kë ‑kun ‑a ‑gɔ ‑pë 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu dhe waa‑ ‑a dheglu 'në gɔɔn‑ ‑nu ‑wo ‑nu wo 'yan dɔ ‑a ‑bha ꞊dhia, 'kɛɛ ‑a këdhɛ gbɛ yaa kë ‑dhö ‑an ‑gɔ kö ‑waan ‑lo ‑a 'piö mɛ gbung ꞊va 'wo ‑kë mü bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","'Ö mɛ ‑nu ‑wo ‑an ‑bha nu ‑sü ‑wun ꞊blɛɛ Yesu ‑dhë 'wo‑ pö: «Ü dhe waa‑ ü dheglu 'në gɔɔn‑ ‑nu ‑wo plaan, ‑wa 'piö kö ‑wo wo 'yan dɔ ü ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'Yö Yesu ‑ya ‑pö ‑an ‑dhë: «N dhe waa‑ n dheglu 'në gɔɔn‑ ‑nu 'wo tɔɔ mɛ ‑nu 'wo wo 'to to ‑Zlan ‑wo ‑bha 'ö 'wo‑ ‑wo ‑kë.» ");
INSERT INTO dnj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yi do 'ka Yesu waa‑ ö bha ꞊guë' ‑nu ‑wo ‑da 'yitagɔ do 'gü, 'yö‑ pö ‑an ‑dhë: «‑Kwa 'yipuë 'kan 'kwa 'dho ‑a ꞊zlöö ꞊zian'!» 'Ö 'wo dho. ");
INSERT INTO dnj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","‑An ‑bha 'dho ‑sü 'ka, Yesu ‑yö yi zë. 'Kan 'wo‑ wo wo ‑ta ꞊nɛ kö 'buu 'gbee‑ ‑yö ziö ‑sü 'gü 'yipuë bhë ‑a ‑ta; 'yitagɔ ‑yö ‑kë pa ‑dhiadhö 'yi 'ka, 'ö‑ ‑dhɛ ‑yö to 'tee kö ‑wo ‑dho 'yi ꞊löö. ");
INSERT INTO dnj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo ꞊yɔɔn ‑a ‑bha 'wo pa ‑a ‑bha, 'wo‑ pö ‑a ‑dhë: «Yi ‑Gɔmɛ! Yi ‑Gɔmɛ! Kwa 'dhoë‑ ga ‑ɔ!» 'Ö Yesu ‑yö ‑büö, 'yö 'wun ꞊blɛɛ 'buu waa‑ 'yikpö ꞊vava ‑nu 'wo bhë ‑an 'ka 'gbee‑ 'ka, 'ö 'buu ‑yö dho sia‑, 'ö 'yi ‑yö ꞊gbaannu, 'ö ‑dhɛ ‑yö ga diindhö. ");
INSERT INTO dnj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «'Öö! Ka ‑bha ‑zo ‑yö n ‑ma ‑sü ‑yö 'më ꞊ɛ?» 'Kɛɛ 'suö ‑yö ‑da ‑an 'plɛ 'gü 'ö ‑an 'te ‑yö tun 'wo‑ pö wo 'ko ‑nu ‑dhë: «Dö ‑mü gɔɔn‑ 'ö ꞊nɛ ‑a 'ka, 'ö 'wun ꞊blɛɛ 'buu waa‑ 'yi gia‑ ‑de ‑an ‑dhë, 'ö 'wo 'wun ma ‑a ‑wo ‑ta ꞊nɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","꞊Dhɛ ‑kë 'dhö 'wo ‑lo Zelazeni ‑sɛ 'ö ‑ya ‑sü 'ka Galile ‑sɛ wöödhö 'yi ꞊zlöö ꞊zian' bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","꞊Dhɛ Yesu ‑yö ꞊yɔɔ, mɛ do ‑yö ‑go plöö ꞊zian' 'yö nu ‑a ‑gɔ zian‑. Mɛ 'ö bhë ‑zuu yaa ‑nu ‑wo ‑kë ‑a 'gü. ꞊Dhɛ 'ö yaa sɔ kë ö ‑bha ‑a ‑dhɛ ꞊ya ꞊glɔɔ. 'Yaa wɔ kɔɔ gbɔ, ‑a këdhɛ ‑nu 'wo tɔɔ blɔɔn‑ ꞊taa ‑dhɛ ‑nu. ");
INSERT INTO dnj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","꞊Dhɛ ꞊ya Yesu yö, ‑yö ‑gbla 'gbee‑ 'ka 'yö nu 'yö ‑gblü ‑a ꞊gɛɛndhö 'ö‑ pö 'gbee‑ 'ka ꞊nɛɛ: «‑Më ‑mü ‑i, ‑Zlan 'ö ‑ziö pë 'plɛ ‑ta ‑a Gbö Yesu? ꞊Bhɛa'‑ 'a‑ wo ü ‑dhë kö ꞊kun 'ü n ‑dɔ ‑gbɔudhö!» ");
INSERT INTO dnj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Pë ‑kë 'yö‑ pö 'dhö bhë ‑a ‑gɛn tɔɔ Yesu ‑ya ‑pö ‑zuu yaa 'ö mɛ 'ö bhë ‑a 'gü bhë ‑a ‑dhë 'dhiö ‑yö 'go ‑a 'gü. Mɛ bhë ꞊ya kë ‑wa ‑kɔ ‑nu ‑lö, 'ö 'wo‑ ‑gɛn ‑nu ‑lö ꞊yɔɔ' 'ka kö ‑waan kuënnu, 'kɛɛ ‑zuu yaa ꞊ya nu ‑a ‑ta, ‑yö ꞊yɔɔ' bhë ‑ya 'plɛ ꞊kaan 'ö‑ sü 'ö dhoë ‑dhɛ ‑nu 'ö mɛ gbɛ 'yaa‑ ‑bha ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","'Ö Yesu ‑ya ꞊dhɛɛ' kpɔ 'ö‑ pö: «Ü tɔɔ dö poo ꞊e?» 'Yö‑ ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «N tɔɔ yi ꞊va!» Pë ‑kë 'yö‑ pö 'dhö bhë 'ö tɔɔ ‑zuu yaa ‑nu ꞊plëëzë ‑wo ‑kë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","'Ö ‑zuu yaa ‑nu 'wo bhë 'wo ꞊bhɛa Yesu ‑dhë kö ꞊kun 'yö dho wo kë ‑waan 'dho ‑glu 'kpa 'dhi ꞊va 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","‑Bhɔtii ‑gbaa ‑nu ‑wo ‑kë wo ‑bha ‑bhöpë ‑nu ꞊mɛɛ' ꞊dhia ‑tɔn 'piö mü. 'Ö ‑zuu yaa ‑nu 'wo bhë 'wo ꞊bhɛa Yesu ‑dhë kö ‑yö 'we ‑a ‑bha ‑an ‑gɔ 'wo 'dho ‑bhɔtii ‑nu 'wo bhë ‑an 'gü. 'Yö ‑we ‑a ‑bha ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑zuu yaa ‑nu 'wo bhë 'wo go gɔɔn‑ bhë ‑a 'gü, 'wo dho ‑bhɔtii ‑nu ‑an 'gü. 'Ö ‑bhɔtii ‑gbaa ‑nu ‑blazë 'wo ꞊yɔɔ ‑tɔn ‑bha, 'yö ‑an 'plɛsɛn ‑wo dho 'wo ‑lo yiö 'töüdhö. ");
INSERT INTO dnj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","꞊Dhɛ ‑bhɔtii ‑nu ‑maakëmɛ ‑nu ꞊wa 'wun 'ö bhë ‑a yö, 'yö ‑an 'plɛ ‑wo ꞊duë 'wo dho 'wuntaɔ 'yö bhë ‑a 'ka ꞊plöö, 'ö 'wo dho bhlö‑ ‑gbaa 'gü ‑dhɛ ‑nu ‑bha ‑a ꞊blɛɛ' ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","'Ö mɛ ‑nu ‑wo ‑ziö, 'wo dho pë 'ö ‑kë bhë ‑a ‑ga ꞊dhia. ꞊Dhɛ 'wo dho, 'wo ‑lo Yesu 'piö ‑dhɛ gia‑ bhë ‑a ‑bha, 'ö mɛ 'ö ‑zuu yaa ‑nu ‑wo go ‑a 'gü bhë, 'wo‑ yö kö ‑yö ‑ya ‑sü 'ka Yesu ꞊gɛɛndhö kö ꞊ya ö bha sɔ ‑nu ‑da ö ‑bha, kö ꞊ya ö ‑de dɔ, 'ö 'suö ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pë ‑nu 'wo ‑kë bhë mɛ ‑nu 'wo ‑kë mü ‑a 'töng 'ka, ‑wo gɔɔn‑ 'ö bhë ‑a ‑bha ‑zuu yaa ‑nu ‑bho ‑a 'gü ‑kɔ bhë, ‑a ‑wun ‑blɛɛ mɛ ‑nu 'wo bhë ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","꞊Dhɛ ꞊ya kë 'dhö, mɛ ‑nu 'wo go Zelazeni ‑sɛ 'gü bhë, 'suö ‑yö ‑da ‑an 'gü 'wo ꞊bhɛa Yesu ‑dhë kö ‑yö 'go wo ꞊plöö. 'Ö Yesu ‑yö ‑da 'yitagɔ 'gü 'yö dho. ");
INSERT INTO dnj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","'Ö gɔɔn‑ 'ö ‑zuu yaa ‑nu ‑wo go ‑a 'gü ꞊sia bhë, 'yö ꞊bhɛa Yesu ‑dhë kö ‑yö 'we ‑a ‑bha 'yö 'to ‑a 'piö, 'kɛɛ Yesu ‑ya ‑pö ‑a ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«‑Bhö 'yɛ ü 'zü 'ü 'dho ü ‑gɔ kɔɔ kö pë 'ö ‑Zlan ‑ya ‑kë ü ‑dhë ꞊nɛ 'ü‑ ꞊blɛɛ'‑ ‑an ‑dhë.» 'Ö gɔɔn‑ bhë 'yö dho, 'ö pë 'ö Yesu ‑ya ‑kë ‑a ‑dhë bhë 'yö‑ ꞊blɛɛ plöödhɛ bhë ‑a ‑dhɛ 'saadhö ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","꞊Dhɛ 'ö Yesu ‑yö ‑lo 'yipuë ꞊zlöö zian gbɛ 'ka bhë, mɛ ‑gbaa ‑nu 'wo ‑kë ‑dɔ ‑a ‑gɔ ꞊dhia, 'yö 'wo ‑nu ‑a ‑gɔ zian‑ ‑kpɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","'Yö mɛ do 'wo‑ ‑dhɛ Zailusö 'yö ‑kë Zuifö ‑nu ‑bha ‑bhɔkuëgɔmɛ do 'ka bhë, 'yö nu 'yö ‑püö Yesu ꞊gɛɛndhö 'yö ꞊bhɛa ‑a ‑dhë kö ‑yö nu ö ‑gɔ kɔɔ, ");
INSERT INTO dnj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","'Ö tɔɔ ‑a 'dhu 'yö ‑kë ‑a ‑bha 'në do 'ka, 'ö‑ ‑kwɛ ꞊ya ‑mɔ 'gɔɔ‑ do ö ga ꞊plɛ ‑bha, ‑yö 'dhoë‑ ga. ꞊Dhɛ Yesu 'dhö 'dho ‑na ‑a ‑gɔ kɔɔ, mɛ ‑gbaa ‑nu ‑wo ‑ziö ‑a 'piö ‑glüü ‑a ‑bha ‑sü 'ka zian 'plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dhebɔ do 'ö fɛi yën ꞊yua' ꞊yaa‑ 'yënng bhɔ ‑kwɛ 'gɔɔ‑ do ö ga ꞊plɛ 'piö ‑yö ‑kë mü. Pë ‑nu 'wo ꞊naɔpë 'ka ‑a ‑gɔ kɔɔ, ꞊yaa‑ 'plɛ 'gü ꞊siö' ꞊dhɔngtrɔ ‑nu 'piö, 'kɛɛ mɛ gbɛ ‑kɔ yaa ‑mɔ ‑a ‑dhɛ bo ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","'Ö bɔ Yesu ꞊zlöö ꞊zian', 'yö pa ‑a ‑bha sɔ 'to 'dhiö 'ka, 'yö‑ ‑bha 'yua ‑yö bo ‑dhɛ do bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «Dö 'yö pa n 'ka bhë ꞊ɛ?» 'Yö ‑an 'plɛ ‑wa pö 'waa ‑mü. 'Ö Piɛɛ ꞊ya pö: «N ‑Gɔmɛ, bhi 'ö mɛ 'plɛ ꞊wa ꞊nië' ü ‑zü, ꞊wa ü ꞊nëng zian 'saadhö ‑a 'ka bhë 'ö 'ü ꞊dhɛɛ' kpɔ a?» ");
INSERT INTO dnj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'Yö Yesu ‑ya ‑pö: «Mɛ do ꞊ya pa n 'ka, bhii a‑ ꞊dɔa' ꞊nɛ 'piigbeedhɛ do 'bhaa ꞊ya 'go n 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","꞊Dhɛ dhebɔ 'ö bhë ꞊yaa‑ yö ꞊nɛ ö ‑ta 'ka 'dho ‑bin, 'yö nu 'yö ‑püö Yesu ꞊gɛɛndhö ꞊zluun ‑sü 'ka. Pë 'ö ‑kë 'ö pa Yesu ‑bha sɔ 'to 'dhiö 'ka, 'iin ‑kɔ 'yö‑ ‑bha 'yua ‑yö to mü 'ö boë bhë, 'yö‑ 'plɛ ꞊blɛɛ mɛ ‑nu wö 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","'Ö Yesu ‑ya pö ‑a ‑dhë: «N 'dhu, ü ‑bha ‑zo ‑yö n ‑ma ‑sü ꞊ya ü dha, ‑bhö 'dho ꞊zuöyagluu 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu ‑yö ‑to 'wun bhë ‑a ꞊blɛɛ' ‑sü 'gü, 'ö bɔmɛ do ‑yö ‑go Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑gɔmɛ ‑gɔ kɔɔ, 'yö‑ pö ‑a ‑dhë: «Kö ꞊kun 'ü ‑Gɔmɛ ꞊sëë' bho 'kpaan, ü 'dhu ꞊ya ga 'saadhö.» ");
INSERT INTO dnj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu ‑yö ‑wo bhë ‑a ‑ma; ꞊dhɛ ‑kë 'dhö 'ö‑ pö Zailusö ‑dhë: «Kö ꞊kun 'ö 'suö ‑yö ü ‑kë, ‑bhö ü ‑zo yö n ‑ma dosɛn, pë gbɛ 'ka 'dho ü 'dhu kë.» ");
INSERT INTO dnj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","꞊Dhɛ 'ö ꞊ya 'dho ꞊ya ‑lo kɔɔ, yaa 'we ‑a ‑bha kö mɛ gbɛ ‑yaan ziö ö 'piö ‑a 'ke yaa kë Piɛɛ 'dhö, Zan 'dhö, Zakö 'dhö waa‑ 'në bhë ‑a dë waa‑ ‑a dhe ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mɛ 'plɛ ‑wo ‑kë 'gbo bɔ ‑sü 'gü ‑wo ‑de ꞊maa 'ma ‑sü 'ka 'në bhë ‑a ‑wun 'gü. ꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑ya pö ‑an ‑dhë: «Kö ꞊kun 'ka 'gbo bɔ, 'në bhë yaa ga; 'kɛɛ yi ꞊nɛ 'ö‑ zë ‑na bhë.» ");
INSERT INTO dnj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","'Ö 'wo wo ‑wo ‑lo ‑a 'ka, bhii 'ö tɔɔ ‑an 'plɛ ‑wa ꞊dɔa' ꞊nɛ 'në bhë ꞊ya ga 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","꞊Dhɛ ‑kë 'dhö Yesu ‑yö ‑ya ‑a ‑kɔ ‑bha 'ö‑ pö ‑a ‑dhë 'gbee‑ 'ka ꞊nɛɛ: «'Nëdhezë, ‑bhö ꞊luu'‑!» ");
INSERT INTO dnj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'Ö‑ ‑zuu ‑yö ‑yɛ ö 'zü 'yö nu ‑a 'gü, 'yö to mü 'ö ꞊luu. 'Ö Yesu ‑ya pö ‑a ‑mɛ ‑nu ‑dhë: «‑Kaa gbaa ‑bhöpë 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","'Ö 'në bhë 'ö ‑a ‑mɛ ‑nu 'te ‑yö tun. 'Ö Yesu ‑ya pö ‑an ‑dhë kö ꞊kun 'wo 'wun 'yö‑ ‑kë bhë 'wo‑ ꞊blɛɛ mɛ gbɛ ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu ‑yö ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an ꞊dhɔɔ ‑kë, 'yö ‑kɔ ‑mɔ 'wun ‑bha ‑sü waa‑ ‑wogbiindhɛ nu ‑an ‑dhë kö ‑waan ‑zuu yaa ‑nu 'plɛ bho ‑a 'ka mɛ ‑nu 'gü, 'go mü kö ‑waan mɛ ‑nu ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","꞊Dhɛ ꞊ya kë 'dhö, 'yö ‑an bɔ kö 'wun 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑bha bhë ‑waan ‑a ꞊blɛɛ'‑ 'iin kö ‑waan 'yua ‑nu bho mɛ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","'Yö‑ pö ‑an ‑dhë: «Kö ꞊kun 'ka ‑taatalü ‑nu, 'tasübhɔɔ ‑nu, 'bluu‑ ‑nu, 'wëüga ‑nu, ‑dabhasɔ kë ꞊plɛ ‑naa ‑nu, ‑an gbɛ sü ka ‑bha 'ta 'sü ‑pë 'ka! ");
INSERT INTO dnj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","‑Dhɛ 'saadhö ‑bha, 'kɔ 'wo 'dhoë‑ ka ‑nia kun ‑a 'gü bhë, ‑ka 'to 'kɔ do bhë ‑a 'gü ‑yö 'dho ‑yö yöë ka ‑go mü ‑yi ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","'Ö pö‑ 'oo pö‑ 'ö 'wo 'ka dho ka ‑nia kun ‑a 'gü bhë, ‑ka 'go ‑a 'gü. 'Go mü, ka 'dho ‑na, ‑ka ka ‑gɛn ꞊kpënng ‑büö ‑bi ‑yö 'go ka ‑gɛn ‑nu ‑bha, ‑yö ‑dho kë ‑an ‑zo ‑büö ‑an ‑de ‑wun 'ka ‑sü ꞊duakëpë do ‑zɔn ‑an ‑dhë ‑sü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo dho 'wo bɔ 'wuntaɔsë ꞊blɛɛ' ‑sü waa‑ mɛ ‑nu ‑dha 'yua ‑gɔ ‑sü 'ka pödhɛ 'saadhö 'plɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","'Töng 'dhö bhë ‑a 'ka, Elɔdö 'ö ‑kë 'sɛdë 'ka, ‑yö pë ‑nu 'wo‑ ‑kë 'töüdhö bhë ‑a ‑ma; 'yö ‑ya ö ‑zo 'ta ‑sü ‑bha, bhii 'ö tɔɔ mɛ 'bhaa ‑nu ‑wa ‑pö: «Zan Batisö ꞊ya 'go ga 'gü!» ");
INSERT INTO dnj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","'Ö mɛ 'bhaa ‑nu ‑wa pö ꞊nɛɛ: «Eli 'ö ‑kë ‑Zlan ‑wodhiölomɛ 'ka 'kpa bhë yö ꞊nɛ 'ö nu bhë!» 'Ö mɛ 'bhaa ‑nu ‑wa pö 'zü ꞊nɛɛ: «‑Zlan ‑wodhiölomɛ ‑nu 'wo ‑kë 'dhiö bhë 'ö‑ mɛ do ‑yö go ga 'gü bhë!» ");
INSERT INTO dnj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","'Yö Elɔdö ‑ya ‑pö: «Zan 'pö 'ma‑ ‑gɔ 'kan 'saadhö, ꞊dhɛ ‑kë 'dhö ꞊nɛ gɔɔn‑ ‑mlë 'wo‑ ‑bha 'wun ‑nu ꞊blɛɛ' ‑na ‑kplawo ꞊nɛ ꞊ɛ?» ꞊Dhɛ ‑kë 'dhö 'yö‑ këdhɛ ꞊mɛɛ kö ‑yaan ‑kpën Yesu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu ‑bha ꞊guë' ‑nu ‑wo ‑yɛ wo 'zü, 'ö pë ‑nu 'wo‑ ‑kë 'ma 'töüdhö bhë 'wo‑ ꞊blɛɛ ‑a ‑dhë. 'Yö ‑an sü 'wo ‑ziö, 'wo dho wo ‑de 'sloo 'ka pö‑ do 'wo‑ ‑dhɛ Betesaida ‑a ‑zian 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","'Kɛɛ mɛ ‑gbaa ‑nu ‑wa ‑bha 'dho ‑sü ‑wun ‑ma, 'wo nu 'wo ‑ziö ‑a 'piö. 'Ö ‑an nu ‑sü 'yi ‑yö ‑kan Yesu 'dhi; 'yö yö ‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑blɛɛ ‑an ‑dhë ‑sü ‑bha, 'ö mɛ ‑nu 'ö 'yua ꞊ya ‑an ꞊sëë' bho, 'yö ‑an ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","꞊Dhɛ 'ö‑ ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ꞊waa‑ yö ꞊nɛ 'bin ‑yö 'më ‑na, 'wo ꞊yɔɔn ‑a ‑bha, 'wo‑ pö ‑a ‑dhë: «‑Bhö ü ꞊kwaa' mɛ gbung 'wo ꞊nɛ ‑an ‑zü kö ‑wo 'dho pödhɛ ‑nu waa‑ bhlö‑ ‑gbaa 'gü ‑dhɛ ‑nu ‑bha kwa ‑zü 'to kö ‑waan wɔdhɛ ‑nu waa‑ ‑bhöpë ‑nu ꞊mɛɛ'‑, bhii ‑dhɛ 'ö ꞊nɛ mɛ gbɛ 'yaa‑ ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'Ö Yesu ‑ya ‑pö ‑an ‑dhë: «Ka gia‑, ‑ka ‑bhöpë nu ‑an ‑dhë!» 'Wo‑ pö ‑a ‑dhë: «Pë 'ö yi ‑gɔ zö 'ö tɔɔ ꞊bluu'‑ bhɛ 'sɔɔdhu waa‑ 'yuö‑ ꞊plɛ. Ü‑ 'piö kö 'yi 'dho mɛ gbung 'ö ꞊nɛ ‑an ‑bha ‑bhöpë 'dhɔ ꞊dhia ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gɔɔn‑ ‑nu 'wo ‑kë mü ‑an ꞊tɛi' ‑kë ꞊nɛ mɛ ‑lü ‑vuu 'sɔɔdhu 'dhö. 'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «‑Kaa ‑an ‑ya kpöë ‑an dan ‑sü 'ka 'gɔɔ‑ 'sɔɔdhu 'gɔɔ‑ 'sɔɔdhu!» ");
INSERT INTO dnj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","'Ö 'wo‑ ‑kë 'dhö, 'wo ‑an 'plɛ ꞊yaannu. ");
INSERT INTO dnj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","꞊Dhɛ ‑kë 'dhö 'ö Yesu ‑yö ꞊bluu'‑ bhɛ 'sɔɔdhu waa‑ 'yuö‑ ꞊plɛ 'wo bhë ‑an sü, 'yö ö 'yan ꞊luu dhang‑ 'gü ꞊bhɛa' ‑sü 'ka, 'yö ‑Zlan zuö pö ‑bhöpë bhë ‑a ‑ta, 'yö ‑an 'klu ꞊kaan, 'ö‑ nu ö bha ꞊guë' ‑nu ‑dhë kö ‑waan ‑a ‑glu mɛ gbung bhë ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","‑An 'plɛ ‑wa ‑bhö 'ö ‑an 'gu ‑yö dɔ. ‑A 'kluklu ‑nu 'wo to, 'wo ꞊kpasɛn 'gɔɔ‑ do ö ga ꞊plɛ pa, 'wo dho ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yi do 'ka Yesu waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑dho wo 'sloo 'ka, 'ö Yesu ‑yö ‑bhɛa. 'Yö ö ‑bha ꞊guë' ‑nu ꞊dhɛɛ' kpɔ 'ö‑ pö: «Mɛ ‑nu ‑wa ‑pö dö ‑mü n 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Wo ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «Mɛ 'bhaa ‑nu ‑wa pö Zan Batisö ‑mü ü 'ka; mɛ 'bhaa ‑nu ‑wa ‑pö Eli ‑mü ü 'ka, 'ö mɛ 'bhaa ‑nu ‑wa pö 'zü ‑Zlan ‑wodhiölomɛ ‑nu 'wo 'dhiö bhë ‑a mɛ do 'yö go ga 'gü yö ‑mü ü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'zü 'ö‑ pö: «'Kɛɛ ka 'pö 'dhee, ka‑ ‑pö dö ‑mü n 'ka ɛ?» 'Ö Piɛɛ ‑ya ‑daa ‑kë 'ö‑ pö: «‑Zlan ‑bha ‑Yamɛ ‑mü ü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","'Ö Yesu ‑yö ‑an 'paan bho 'gbee‑ 'ka ꞊nɛ kö ꞊kun mɛ 'ö‑ 'ka 'wo‑ ꞊blɛɛ mɛ gbɛ ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","'Yö‑ pö 'zü ꞊nɛɛ: «Ma 'a Mɛgbö 'ka n 'yënng ‑dho bhɔ ꞊va, 'ö tɔɔ mɛ ziizii ‑nu, slabhomɛ ‑gɔmɛ ‑nu waa‑ tɔnggɔmɛ ‑nu waa 'dho 'we n ‑wun ‑bha; ‑wo ‑dho n zë; 'ö‑ ‑dhɛkpaɔyi kë ‑yaaga ‑naa bhë 'a goë ga 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö ‑an 'plɛ ‑dhë: «Mɛ 'ö‑ 'piö kö 'ö ziö n 'piö, kö ‑yö ö ꞊kwaa' ‑zo ‑ta ö ‑de ‑wun 'gü ‑sü ‑zü, ‑yö ö ‑bha ‑gaatalü 'sü ‑dhɛkpaɔyi 'saadhö 'ka, ‑yö ziö n 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bhii mɛ 'ö‑ 'piö kö 'ö ö ‑de ‑bha ‑tosiadhe kë ö ‑de ‑ta, ‑yö ‑dho ‑a 'gü ꞊siö'‑ 'kpaan, 'kɛɛ mɛ 'ö 'dhoë‑ ö bha ‑tosiadhe 'gü ꞊siö'‑ n ‑wun 'gü, ‑yö ‑dho dha ‑sü yö. ");
INSERT INTO dnj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","‑A ꞊truën ‑dho kë ‑më 'ka kö 'kpongtaapë 'plɛ ‑yö ‑kë mɛ ‑gɔ, 'kɛɛ kö ‑an 'gü ‑yö ꞊siö'‑ ‑sü 'ka ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","꞊Ya kë ꞊nɛ mɛ ꞊ya lë‑ kë n ‑gɔ 'iin n ‑wo ‑nu ‑gɔ, ma 'a Mɛgbö 'ka, ma ‑de 'pö a ‑dho lë‑ kë ‑a ‑gɔ yi 'a 'dhoë‑ nuë ma 'tɔbhɔdhe waa‑ n Dë waa‑ ‑a ‑bha bɔmɛ ‑nu 'slööslö 'wo n 'piö ‑an ‑bha 'tɔbhɔdhe 'ka ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: Mɛ ‑nu 'wo zö ꞊nɛ, ‑an 'bhaa ‑nu waa 'dho ga kö waa ‑Zlan ‑bha ‑gludëdhɛ yö ꞊kun.» ");
INSERT INTO dnj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","꞊Dhɛ 'ö‑ ‑dhɛkpaɔyi ‑kë ꞊nɛ pë 'slɛaga 'dhö kö ꞊ya yën 'wun ‑nu 'wo ꞊nɛ ‑an ꞊blɛɛ' ‑sü ‑bha bhë, 'ö Yesu ‑yö Piɛɛ 'dhö, Zan 'dhö waa‑ Zakö 'dhö ‑an kpa ö ‑bha, 'wo dho ‑tɔn tuö ꞊bhɛa' ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","‑Wo ‑kë ꞊bhɛa' ꞊dhia, 'ö‑ wöödhɛ ‑yö ꞊dhië ‑kwaa, 'ö‑ ‑bha sɔ ‑nu ‑wo ‑kë 'puu 'ö ꞊zië' ‑naa 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","꞊Dhɛ 'wo‑ ‑ga kö mɛ ꞊plɛ ꞊wa nu Yesu 'piö mü, kö wo ‑nu ‑wo 'wun ꞊blɛɛ' ‑na wo 'ko ꞊bhaa. Mɛ ꞊plɛ 'wo bhë 'wo tɔɔ Moizö waa‑ Eli 'wo dhang‑ 'gü 'wo nu ‑a 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","'Ö 'wo nu ‑dhɛpuudhɛ 'bhü ‑sü 'ö go dhang‑ 'gü bhë ‑a 'gü. Waa‑ Yesu ‑nu ‑wo 'wun ꞊blɛɛ wo 'ko ꞊bhaa ‑kɔ 'ö Yesu dho ö bha yuö 'dhiö ꞊mɔa' 'kuë ‑a ga ‑kɔ 'ka Zeluzalɛmë bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","'Yö Piɛɛ waa‑ ö 'bhamɛ ‑nu ‑wo ‑püö yië‑ ‑ziögɔüsüzë. 'Kɛɛ ꞊dhɛ ꞊wa ‑büö, ‑wo Yesu ‑bha ‑dhɛpuudhɛ 'bhü waa‑ mɛ ꞊plɛ 'wo ‑kë ‑a 'piö mü bhë ‑an ‑yö. ");
INSERT INTO dnj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","꞊Dhɛ mɛ ‑nu 'wo bhë 'wo 'go ‑na Yesu 'piö (kö waa 'dho ꞊gbiin ꞊kun), 'ö Piɛɛ ‑ya pö Yesu ‑dhë: «N ‑Gɔmɛ, ꞊yö ‑së kö 'kwa 'to zö, 'kwa sɔ 'kɔ ‑yaaga dɔ, ‑a do‑ kë ü ‑bha 'ka, ‑a do‑ kë Moizö ‑bha 'ka, ‑a do‑ kë Eli ‑bha 'ka!» 'Wun ‑nu 'yö‑ ꞊blɛɛ bhë yaa‑ gbɛ dɔ ö ‑de ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","‑Yö ‑to 'wun 'ö bhë ‑a ꞊blɛɛ' ‑sü 'gü, 'yö dha kpö ‑yö ‑nu ‑an ‑ta dhuö, 'yö‑ 'bin ‑yö sɔ ‑an ‑zü. 'Ö 'suö ‑yö ‑da ‑a ‑bha ꞊guë' ‑nu 'gü, dha kpö 'ö sɔ ‑an ‑ta bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","‑Wo do 'bhaa ‑yö ‑we dha kpö bhë ‑a 'gü, 'ö ‑we ꞊nɛɛ: «Mɛ 'ö ꞊nɛ 'ö tɔɔ n Gbö (do 'ö n ‑gɔ,) 'a‑ ‑ya; ‑ka ka 'to kë ‑a ‑wo ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","꞊Dhɛ 'ö ‑wo 'ö bhë ꞊ya yën, Yesu dosɛn 'kpaan ꞊nɛ 'wo‑ yö zlöö; 'yö ‑an 'dhi ‑yö kun. 'Ö go 'töng 'ö 'dhö bhë ‑a ‑bha, 'ö pë 'wo‑ yö bhë waa‑ ꞊blɛɛ'‑ mɛ gbɛ ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","‑Dhɛkpaɔyi mɛ 'ö yö ‑a 'piö, ‑wo ‑yɔɔ 'wo go ‑tɔn bhë ‑a tuö, 'ö mɛ ‑gbaa ꞊va ‑wo nu Yesu ‑gɔ zian‑. ");
INSERT INTO dnj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mɛ do ‑yö ‑kë mɛ ‑gbaa ‑nu ziën mü, 'ö yö 'gbla ‑sü ‑bha ꞊woë' ꞊nɛɛ: «N ‑Gɔmɛ, ꞊bhɛa'‑ 'a‑ wo ü ‑dhë, ‑bhö ma 'në 'ö ꞊nɛ ‑a ‑ga, ma 'në ga do 'kpaan ‑mü! ");
INSERT INTO dnj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","꞊Ya kë ‑zuu yaa ‑yö ‑püö ‑a ‑ta, 'ö ꞊gblaa gbla, 'go mü 'yö‑ ꞊zaan zan 'gbee‑, 'yö‑ 'dhee 'vuu ‑yö dɔ ‑gbɔudhö; 'yö‑ 'yënng bhɔ; 'ö ‑a ‑go ‑a 'gü ‑sü ‑yö ‑kë 'gbee‑. ");
INSERT INTO dnj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A‑ ‑bhɛa ü bha ꞊guë' ‑nu ‑dhë kö ‑waan ‑a bho ‑a 'gü, 'kɛɛ ‑an ‑kɔ yaa ‑mɔ ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","'Ö Yesu ‑ya pö: «Mɛ ‑nu 'ö ‑zo ‑yö n ‑ma ‑sü 'yaa ka ‑gɔ, 'ö ka këwun 'dhö ya, 'töng ꞊dhë 'a dho ‑a sü 'zü 'kwaan‑ kaa‑ kwa 'ko ꞊bhaa ꞊ɛ? 'Töng ꞊dhë 'a dho ‑a sü 'zü 'aan‑ dɔ ‑a 'ka ka ‑gban ‑gɔ ‑ɛ?» ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö mɛ 'ö bhë ‑a ‑dhë: «‑Bhö nu ü bha 'në bhë ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","꞊Dhɛ 'ö 'në bhë 'ö ꞊yɔɔn ‑na Yesu 'sɔɔ, 'ö ‑zuu yaa ‑ya ‑zuö sia‑, 'yö‑ ꞊zaan zan 'gbee‑ 'ka. 'Ö Yesu ‑yö 'wun ꞊blɛɛ 'gbee‑ 'ka ‑zuu yaa bhë ‑a 'ka, 'yö go 'në bhë ‑a 'gü, 'yö dha, 'yö‑ nu ö dë ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","'Ö ‑an 'te ‑yö tun ‑Zlan ‑bha 'piigbeedhɛ ‑kë ꞊va ‑sü ‑wun 'gü. ꞊Dhɛ ‑kë ꞊nɛ ‑an 'plɛ 'te ꞊ya 'tun pë 'saadhö 'ö Yesu ‑ya ‑kë ‑a ‑wun 'gü bhë, 'ö Yesu ‑ya ‑pö ö bha ꞊guë' ‑nu ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«‑Ka ka ‑zo kë 'wun ‑nu 'a‑ ꞊blɛɛ' ‑na ka ‑dhë ꞊nɛ ‑a 'piö: Ma 'a Mɛgbö 'ka, ‑wo ‑dho n dɔ mɛ ‑nu kwɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","'Kɛɛ 'wun 'ö Yesu ‑ya ꞊blɛɛ bhë, waa‑ ‑gɛn gbɛ dɔ; ‑a ‑gɛn giagia 'wo dho ‑a dɔ ‑yö ‑kë ‑bin ‑sü 'ka ‑an ‑gɔ; 'ö 'suö ‑yö ‑an ‑kë Yesu ꞊dhɛɛ' 'kpɔ ‑sü 'ka 'wun 'yö‑ ꞊blɛɛ bhë ‑a ‑gɛn ‑wun 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesu ‑bha ꞊guë' ‑nu ‑wo ‑yö za ‑ya wo 'ko ‑bha ‑sü 'gü mɛ 'ö dho kë mɛ ꞊va 'ka wo ziën ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","'Kɛɛ ‑an ‑bha ‑zotadhe bhë Yesu ‑ya ‑dɔ. ꞊Dhɛ ‑kë 'dhö, 'yö 'në 'tee do sü 'yö‑ dɔ ö 'sɔɔ, ");
INSERT INTO dnj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","'yö‑ pö ‑an ‑dhë: «Mɛ 'ö 'dhoë‑ 'në 'tee 'ö ‑kë ꞊nɛ mɛ ꞊nɛ ‑a 'dhö ‑a kun ‑së n ‑wun 'gü, kö ꞊ya ma gia‑ n 'kun ‑së; 'ö mɛ 'yö 'dhoë‑ n kun ‑së, kö ꞊ya mɛ 'ö n bɔ, ‑a 'kun ‑së 'pö; bhii mɛ 'ö ‑de ‑sü 'tee ‑mɛ 'ka ka 'plɛ ka ziën bhë ꞊nɛ 'ö tɔɔ kaa‑ mɛ ꞊va ‑Zlan wö 'dhiö.» ");
INSERT INTO dnj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zan ‑ya pö ‑a ‑dhë: «N ‑Gɔmɛ, yi mɛ do ‑yö kö ‑yö ‑zuu yaa ‑nu bho ‑na mɛ ‑nu 'gü ü 'tɔ 'ka, 'ö 'yi‑ pö ‑a ‑dhë kö ꞊kun 'ö‑ ‑kë 'dhö gbɔ, bhii 'yaa kwa 'piö.» ");
INSERT INTO dnj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","'Ö Yesu ‑ya ‑pö ‑a ‑dhë: «‑Ka ka ꞊kwaa' ‑a ‑zü, bhii mɛ yaa nu kwa ‑gɔ kö kwaa‑ mɛ ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","꞊Dhɛ 'ö Yesu ‑bha ‑dho dhang‑ 'gü ‑yi 'dho yö ‑na ꞊klöö', kö ‑dho Zeluzalɛmë ‑sü ꞊yaa‑ ‑kaan wo; 'yö ‑da zian‑. ");
INSERT INTO dnj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","꞊Dhɛ ‑kë 'dhö, 'yö mɛ ‑nu bɔ ö 'dhiö, 'wo dho 'wo ‑da Samali ‑pö do 'gü kö ‑waan ‑a ‑bha wɔdhɛ ‑wun 'yan bhɔ. ");
INSERT INTO dnj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'Kɛɛ pö‑ bhë ‑a 'gü ‑mɛ ‑nu waa 'we ‑a ‑bha ‑an ‑gɔ kö ‑wo wɔ ‑an ‑gɔ plöö, bhii ‑wo ‑kë 'dho ꞊dhia Zeluzalɛmë ꞊zian'. (Kë‑ wo 'dhö bhë ‑a ‑gɛn 'ö tɔɔ Samali ‑mɛ ‑nu waa‑ Zuifö ‑nu 'waa wo 'ko ‑dhë ‑së.) ");
INSERT INTO dnj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","꞊Dhɛ ‑kë 'dhö, Zakö waa‑ Zan 'wo‑ ‑bha ꞊guë' ‑nu 'ka bhë 'wo‑ pö: «Yi Dëmɛ, ü‑ 'piö kö 'yi 'siö ‑dhɛ 'yö go dhang‑ 'gü kö ‑yaan ‑an 'gü ꞊siö'‑ ‑a?» ");
INSERT INTO dnj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu ‑yö ‑dhië ‑an 'piö 'ö 'wun ꞊blɛɛ ‑an 'ka giagiawo, 'ö‑ pö: «‑Zuu 'ö ka 'gü 'ö 'ka pë kë ‑na ‑a ꞊kwaa' bhë 'kaa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","'Ö tɔɔ ma Mɛgbö, n 'ka nu kö mɛ ‑nu 'gü ‑yaan ꞊siö; 'kɛɛ a ‑nu kö ‑waan dha ꞊zian'.» 'Ö 'wo go mü, 'wo dho pödhɛ gbɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","‑Wo ‑kë zian ‑gbloo 'piö, 'ö mɛ do ‑ya ‑pö Yesu ‑dhë: «‑Dhɛ 'saadhö 'ü dho ‑a ‑bha, a ‑dho ziö ü 'piö.» ");
INSERT INTO dnj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ‑ya pö ‑a ‑dhë: «Ü‑ ꞊dua' ꞊nɛ diɔng ‑wɔ ‑a 'gü ‑du ‑yö ‑dhö, 'ö ‑ma ‑nu ‑wɔ ‑a 'gü ‑kɔ 'dhö ‑dhö, 'kɛɛ ma 'a Mɛgbö 'ka, ma ‑dhɛ do 'a dho wɔ ‑a ‑bha kö 'aan‑ n 'tɛɛ pa 'yaa ‑dhö.» ");
INSERT INTO dnj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","'Ö Yesu ‑ya pö mɛ do 'bhaa ‑dhë: «‑Bhö ziö n 'piö!» 'Kɛɛ mɛ 'ö bhë ‑ya ‑pö ‑a ‑dhë: «N Dëmɛ, ‑bhö 'we ‑a ‑bha n ‑gɔ, 'a 'dho poo ꞊kun 'a ‑ya n dë 'sɔɔ kö ‑yaan 'dho n 'yaan!» ");
INSERT INTO dnj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «‑Bhö ü ꞊kwaa' gamɛ ‑nu ‑zü, ‑wo wo 'ko ‑bin, bhi 'pö 'ü 'dho 'ü ‑Zlan ‑bha ‑gludëdhɛ ‑wun ꞊blɛɛ'‑ mɛ ‑nu ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mɛ do 'bhaa ‑ya pö 'zü ꞊nɛɛ: «A ‑dho ziö ü 'piö, n Dëmɛ; 'kɛɛ ‑bhö 'we ‑a ‑bha n ‑gɔ, 'a 'dho 'a n ‑wo ‑da n ‑mɛ ‑nu ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","'Ö Yesu ‑ya pö ‑a ‑dhë: «Mɛ 'ö ꞊ya ‑ya ‑dhɛ ‑ya ‑sü ‑bha, 'go mü 'ö ‑dhɛ ‑ga ‑na ö zlöö bhë, yaa ‑mɔa kö ‑yö yuö kë ‑Zlan ‑bha ‑gludëdhɛ ‑bha 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö ö bha ꞊guë' ‑nu 'bhaa ‑sü; ‑wo ‑kë 'gɔɔ‑ 'slaplɛ ö ga ꞊plɛ, 'yö ‑an dan ꞊plɛ ꞊plɛ, 'yö ‑an bɔ ö 'dhiö pödhɛ ‑nu 'saadhö waa‑ ‑dhɛ ‑nu 'töüdhö 'ö yö gia‑ 'ö dho bɔ ‑a ‑bha ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","'Yö‑ pö ‑an ‑dhë: «‑Mlü ꞊ya ga ꞊va, 'kɛɛ ‑a 'kanmɛ ‑nu ‑wo 'tee. ‑Ka ꞊bhɛa'‑ bhlö‑ dëmɛ ‑dhë kö ‑yö yuökëmɛ 'bhaa bɔ kö ‑waan ‑a ‑bha ‑mlü 'kan. ");
INSERT INTO dnj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","‑Ka 'dho! A ka ‑bɔ ꞊nɛ 'bhlanë ‑nu 'dhö ‑tɔn ‑bha gbɛn‑ ‑nu ziën. ");
INSERT INTO dnj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kö ꞊kun 'ka 'wëüga ‑nu gbɛ sü; kö ꞊kun 'ka 'ta 'sü ꞊bhɔɔ' ‑nu gbɛ sü; kö ꞊kun 'ka ‑sakpa gbɛ sü; kö ꞊kun 'ka ꞊gbaannu 'ka ‑mɛɛ ‑kë mɛ gbɛ 'ka zian ‑gbloo ‑nu ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","'Ö ꞊ya kë ꞊nɛ 'ka ‑da 'kɔ do 'gü, ‑kaa ‑a pö ‑blɛɛzë 'ka: ꞊Zuöyagluu ‑yö kë 'kɔ 'ö ꞊nɛ ‑a 'gü! ");
INSERT INTO dnj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","'Ö ꞊ya kë ꞊nɛ mɛ 'bhaa 'ö dho we ka ‑bha 'dhuë‑ ‑wun ‑bha ꞊ya kë mü, ka ‑bha 'dhuë‑ ‑yö 'to ‑a ‑ta; 'yaa 'pö ka ‑bha 'dhuë‑ bhë ‑yö 'to ka ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","‑Ka wɔ ka ‑nia ‑kun ‑a 'gü ‑kɔ 'gü 'ka ‑bhöpë ‑nu 'ö mɛ ‑nu 'dhoë‑ nu ka ‑dhë bhë 'ka‑ ‑bhö, bhii ‑yö yuökëmɛ ‑bha 'ka kö ‑waan ‑a ꞊saan' bho. Kö ꞊kun 'ka ‑nië kɔɔtodhɛ ‑nu ‑bha! ");
INSERT INTO dnj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","꞊Ya kë ꞊nɛ 'ka ‑da pödhɛ do 'gü, 'ö ꞊wa ka ‑nia 'kun, ‑ka ‑bhöpë ‑nu 'ö mɛ ‑nu dho nuë ka ꞊dhia bhë ‑an ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","‑Ka mɛ ‑nu ‑dhɛ bo pödhɛ bhë ‑a 'gü, 'go mü 'ka‑ pö pö‑ 'ö bhë ‑a 'gü ‑mɛ ‑nu ‑dhë: ‑Zlan ‑bha ‑gludëdhɛ ꞊ya yö ka 'ka ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Kɛɛ ꞊ya kë ꞊nɛ 'ka ‑da pödhɛ 'bhaa 'gü 'ö waa 'we ‑a ‑bha kö ‑wo ka ‑nia 'kun, ‑ka ‑da zian ‑ta 'ka‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Sɛ ‑de 'yö to yi ‑gɛn ‑bha bhë 'yi‑ bho ‑na yi ‑gɛn ‑bha pë 'ka‑ ‑kë bhë ‑a ‑wun 'gü ꞊nɛ, 'kɛɛ ‑kaa dɔa ꞊nɛ ‑Zlan ‑bha ‑gludëdhɛ ꞊ya yö ka 'ka ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A‑ ‑blɛɛ ka ‑dhë: ‑Zlan ‑bha zakanyi 'ka, pö‑ 'ö 'dhö bhë ‑a ‑bha 'klobhɔdhe ‑yö ‑dho kë ꞊va 'giasü 'ö ꞊zië' Sodɔmë ‑mɛ ‑nu 'ö 'wo ‑kë 'kpa ꞊zuö' yaa ‑mɛ ‑nu 'ka bhë ‑an ‑bha ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","'Yö Yesu ‑ya pö 'zü: «'Yena ‑wun ꞊ya kë ka 'ka, Kolazɛn ‑mɛ ‑nu! 'Yena ‑wun ꞊ya kë ka 'ka, Betesaida ‑mɛ ‑nu! Bhii ‑dhidhaapë ‑nu 'wo ‑kë ka ꞊plöö ꞊nɛ, ‑wo ‑kë Tii ‑dhɛ waa‑ Sidɔn ‑dhɛ ‑nu ‑an ‑bha ‑bezë, kö pödhɛ ‑nu bhë ‑an 'gü ‑mɛ ‑nu ꞊wa wo ‑bha ‑kë ‑a 'gü ‑sü ꞊dhië' ‑kwaa ‑a ‑dhɛ ꞊ya ꞊glɔɔ 'saadhö, 'iin kö ꞊wa ꞊bhɔɔ' 'kaazë ‑da wo ‑bha 'iin ꞊wa 'yoo ‑lo wo ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","‑A ‑wun 'gü, ‑Zlan ‑bha zakanyi 'ka, ka ‑bha 'klobhɔdhe ‑yö ‑dho kë ꞊va 'giasü 'ö ꞊zië' Tii ‑dhɛ waa‑ Sidɔn ‑dhɛ ‑an ‑bha ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","꞊Dhɛ ‑kë 'dhö bhi 'dhee, Kapɛɛnaɔmë, ‑yö ‑kë ü ‑de 'gü ꞊nɛ ü ‑gɔ ‑dho yö dhang‑ ‑bha! 'Kɛɛ ‑abi'! Ü ‑gɔ ‑dho ꞊yɔɔ'‑ ꞊glöötiaandhö 'siö 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","'Ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë 'zü: «Mɛ ꞊ya ö 'to kë ka ‑wo ‑bha, kö ꞊ya ö 'to kë n ‑wo ‑bha; mɛ yaa bɔ ka 'ka kö yaa bɔ n 'ka ꞊nɛ bhë; 'ö mɛ yaa bɔ n 'ka, kö mɛ 'ö n bɔ bhë ꞊nɛ yaa bɔ ‑a 'ka bhë.» ");
INSERT INTO dnj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","꞊Guë' ‑nu 'gɔɔ‑ 'slaplɛ ö ga ꞊plɛ 'wo bhë ‑wo ‑yɛ wo 'zü 'wo nu ꞊zuögludhi 'ka, 'ö 'wo‑ pö Yesu ‑dhë: «Yi Dëmɛ, ‑zuu yaa ‑nu ‑de 'yië 'wun ꞊blɛɛ'‑ ‑an 'ka ü 'tɔ 'gü, ‑wo 'wun ‑ma yi ‑ta 'wo go mɛ ‑nu 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","'Ö Yesu ꞊ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «A Satan ‑bha ‑go dhang‑ 'gü ‑sü 'yö ‑püö bhë ‑a ‑yö ꞊nɛ pë ‑bha 'yan bɔ ‑sü 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","'Kɛɛ ‑ka ka 'to 'to: A ‑kɔ ‑mɔ 'wun ‑bha ‑sü ‑nu ka ‑dhë kö 'kaan‑ ꞊taa'‑ ꞊mɛɛ ‑nu, gian ‑nu ‑an ‑ta, 'iin 'kaan‑ dü ‑bha 'piigbeedhɛ 'plɛ 'gü ꞊siö'‑; 'go mü pë gbɛ yaa 'dho pë 'dhiö‑ kë ka 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","'Kɛɛ kö ꞊kun 'ö ka ꞊zuö' 'glu ‑yö 'dhi, ‑zuu yaa ‑bha 'wun ‑ma ka ‑ta ‑sü ‑wun 'gü; ka ꞊zuögludhi ꞊zian' ka 'tɔ ‑bha ‑ya ‑Zlan ‑bha 'sëëdhɛ 'gü ‑sü ‑wun 'gü!» ");
INSERT INTO dnj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","'Töng gia‑ 'ö 'dhö bhë ‑a 'ka, Yesu ‑yö ‑pa ꞊zuögludhi 'ka ‑Zuu 'slööslö ꞊kwaa' 'yö‑ pö: «O n Dë, 'ü dhang‑ waa‑ 'kpongtaadhɛ ꞊kɔɔnmɛ 'ka, a ü zuö ‑pö pë 'ü‑ ‑bin mɛ ‑nu 'wo 'kpaakpa waa‑ 'wundɔmɛ ‑nu ‑an ‑gɔ, 'ü‑ ‑zɔn mɛ ‑nu 'wo wo ‑de ‑sü 'tee ‑an ‑dhë bhë ‑a ‑wun 'gü; ꞊ii‑, n Dë, ‑yö ‑kë ꞊nɛ ‑kɔ bhë ‑a 'dhö, bhii 'ö tɔɔ bhi gia‑ ü 'yi ‑kan ‑a ‑dhë ‑wun ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'Go mü 'yö‑ pö: «N Dë ‑yö pë 'plɛ ‑lo n kwɛɛ; mɛ gbɛ 'yaa ma 'a‑ Gbö 'ka n dɔ ‑a 'ke yaa kë n Dë 'ka. 'Ö go mü mɛ gbɛ 'yaa n Dë dɔ ‑a 'ke yaa kë ma 'a‑ Gbö 'ka waa‑ mɛ ‑nu 'ö 'a‑ ‑zɔn ‑na ‑an ‑dhë bhë ‑an 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","꞊Dhɛ Yesu waa‑ ö bha ꞊guë' ‑nu ꞊wa 'to wo 'sloo 'ka, 'yö‑ pö ‑an ‑dhë: «꞊Zuögludhi ‑yö kë ka ‑gɔ, pë ‑nu 'ö 'ka ‑an yö bhë ‑an ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","bhii a‑ ‑pö ka ‑dhë mɛdhɛvadhɛ 'wo ‑kë ‑Zlan ‑wodhiölomɛ ‑nu 'ka waa‑ ‑gludë ‑nu 'wo 'dhiö ‑be, ‑wa ‑dhɔ ‑kë kö n këpë ‑nu 'ö 'ka ‑an yö ‑na ꞊nɛ 'waan‑ ‑an yö 'kɛɛ waa ‑an yö; 'iin pë ‑nu 'ka ‑an ma ꞊nɛ 'waan‑ ‑an ma 'ö waa ‑an ma.» ");
INSERT INTO dnj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","꞊Dhɛ ꞊ya kë 'dhö, tɔnggɔmɛ do ‑yö ‑luu 'yö Yesu 'gü dan ‑a ꞊dhɛɛ' 'kpɔ ‑sü 'ka 'ö‑ pö: «N ‑Gɔmɛ, a ‑dho ‑a kë ꞊dhë kö ꞊toëpö ‑këdhösü ‑yaan kë n ‑gɔ ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Më 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha tɔng 'gü i? 'Bha ‑a pö, ü‑ ‑ma ‑kɔklë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","'Ö gɔɔn‑ bhë 'ö‑ pö ‑a ‑dhë: «Pë 'ö ꞊bɛɛn' ‑sü 'ka 'ö tɔɔ: ‑Bhö ü Dëmɛ ü ‑bha ‑Zlan ‑dhɔ kë ü ꞊zuöga 'plɛ 'ka, ü nii 'plɛ 'ka, ü ꞊faan' 'plɛ 'ka, ü ‑zo ‑ta 'gü ‑wun 'plɛ 'ka! 'Go mü, ‑bhö ü ‑ya 'yɔɔ ‑dhɔ kë ꞊nɛ ü ‑de 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya ‑pö ‑a ‑dhë: «Ü‑ ‑daa ‑kë ‑së, ‑bhö ‑a kë ꞊nɛ ‑kɔ 'ö bhë ‑a 'dhö, ü ‑dho kë ‑dhö ꞊toëpö 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","'Kɛɛ tɔnggɔmɛ 'ö bhë 'yaa‑ 'piö kö za ‑yö ö 'kun. ꞊Dhɛ ꞊ya kë 'dhö, 'yö Yesu ꞊dhɛɛ' kpɔ 'zü ꞊nɛɛ: «Dö tɔɔ n ‑ya 'yɔɔ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'wun ꞊zuan' ‑zɔn ‑a ‑dhë ‑sü 'ka, 'ö‑ pö: «Gɔɔn‑ do ‑yö ‑go Zeluzalɛmë, 'yö ‑kë 'dho ꞊dhia Zeliko. ꞊Dhɛ 'ö këpëyaamɛ ‑nu ꞊wa ‑lo ‑a ‑ta zian‑, 'wo‑ ‑bha pë ‑nu 'plɛ kun ‑a ‑gɔ 'wo‑ ‑ma, 'ö to ‑an kwɛɛ 'ö ꞊fuë. 'Wo‑ to sia‑ mü 'wo ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","‑Zlan ‑bha slabhomɛ do ‑yö ‑kë zian bhë ‑a ‑ta 'pö ziö ‑dhiadhö. ꞊Dhɛ ꞊ya gɔɔn‑ bhë ‑a yö, 'yö bɔ ‑kpinng 'to 'pian gbɛ ‑ta, 'ö ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","‑Kɔ do bhë ‑a 'ka 'ö mɛ do 'yö go Levi ‑nu ꞊suu'‑ 'gü 'yö nuë. ꞊Dhɛ ꞊ya yö ‑a ꞊tɛi' 'ka, 'yö ꞊yɔɔn gɔɔn‑ bhë ‑a ‑bha. ꞊Dhɛ 'ö ꞊yaa‑ yö, 'yö saan 'yö bɔ ‑kpinng 'to gbɛ ‑ta 'ö ‑ziö. ");
INSERT INTO dnj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","'Kɛɛ Samali (‑sɛ 'ö‑ 'gü ‑mɛ ‑nu waa‑ Zuifö ‑nu 'waa wo 'ko ‑dhë ‑së bhë ‑a) mi do 'yö ‑kë 'dho ꞊dhia 'ta 'gü; ‑yö ‑kë zian ‑gblooga do bhë ‑a ‑ta; 'yö ‑wo ‑a ‑ta mü. ꞊Dhɛ 'ö ꞊yaa‑ yö, 'yö‑ 'yena ‑yö ‑da ‑a 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","'yö ꞊yɔɔn ‑a ‑bha, 'yö ‑drɔɔn waa‑ 'yɔn yö ‑a ‑bha bhüö ‑nu 'gü, 'yö ‑an ‑lö sɔ 'pɛn 'ka. ꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ ‑ya ö bha ꞊soofang ꞊taa 'yö dhoë ‑wɔ ‑a 'gü ‑kɔ 'wo‑ ꞊saan' bho ‑na bhë ‑a do 'gü. ‑Dhɛ bhë ‑a 'gü, 'yö ö ‑zo ‑kë ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","꞊Dhɛ 'ö ‑a ‑tadhɛ ꞊ya 'po, 'yö dönie ꞊plɛ sü 'yö‑ nu ‑wɔ ‑a 'gü ‑kɔ bhë ‑a ‑gɔmɛ ‑dhë ‑a pö ‑a ‑dhë ‑sü 'ka ꞊nɛɛ: ‹‑Bhö ü ‑zo kë mɛ 'ö ꞊nɛ ‑a 'piö; ꞊ya kë ꞊nɛ a 'yɛ ‑na n 'zü a 'dho ‑na n ꞊plöö, pë ‑nu 'ü 'dhoë‑ kë ‑a ‑wun 'gü 'töüdhö bhë a ‑dho ü ‑bha ‑yɛ 'zü kë.› » ");
INSERT INTO dnj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","'Yö Yesu ‑ya pö ‑a ‑dhë 'zü: «꞊Ya kë 'dhö kö mɛ ‑yaaga 'wo bhë ‑a dö ‑zë 'yö tɔɔ mɛ 'ö këpëyaamɛ ‑nu ‑wa ‑ma bhë ‑a ‑ya 'yɔɔ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Ö tɔnggɔmɛ ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «'Ö tɔɔ mɛ 'ö‑ 'yena yö bhë.» ꞊Dhɛ ‑kë 'dhö Yesu ‑ya pö ‑a ‑dhë: «Kö ‑bhö 'dho 'ü‑ kë ꞊nɛ ‑kɔ bhë ‑a 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","꞊Dhɛ Yesu waa‑ ö bha ꞊guë' ‑nu ꞊wa ‑da zian ‑ta, ‑wo ‑dho 'wo ‑da pödhɛ do 'gü. Dhebɔ do ‑yö ‑kë mü, 'wo‑ ‑dhɛ Maatö; 'yö Yesu ‑nia kun ö ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","‑A dheglu 'nëdhe 'wo‑ ‑dhɛ Mali, ‑yö ‑kë ꞊yaannu ꞊süë' Dëmɛ ꞊gɛɛndhö ö 'to ‑to ‑a ‑bha ‑mɛ ꞊daan' ‑wo ‑bha ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maatö ‑yö ‑kë yuö ꞊plëëzë kë ꞊dhia, 'yö nu 'ö‑ pö: «N Dëmɛ, kö n dheglu ‑yö yuö ‑nu 'wo ꞊nɛ ‑ya 'plɛ 'to n ‑kɔ ‑ta ꞊nëdhö ꞊nɛ, 'yaa ü ‑dhë pë gbɛ 'ka a? ‑Bhöë pö ‑a ‑dhë ‑yö nu n ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","'Yö Dëmɛ ‑ya ‑pö ‑a ‑dhë ꞊nɛɛ: «Maatö, Maatö, ‑zo ‑ta 'wun 'gü ‑sü waa‑ pë ꞊plëëzë kë ‑dhɔ ‑yö ü ‑kë, ");
INSERT INTO dnj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","'kɛɛ 'wun do ‑yö mü, 'ö‑ ‑wun 'dhö 'gbee‑. Yö ꞊nɛ 'ö Mali 'dhoë‑ 'piö bhë; yaa 'dho 'go ‑a ‑gɔ gbɔ.» ");
INSERT INTO dnj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yi do 'ka Yesu ‑yö ‑dho ꞊bhɛa' ꞊dhia ‑dhɛ do 'gü. ꞊Dhɛ ꞊ya yën ꞊bhɛa' ‑sü ‑bha, 'yö‑ ‑bha ꞊guë' ‑nu mɛ do ‑ya pö ‑a ‑dhë: «N Dëmɛ, ‑bhö yi ꞊daan' ꞊bhɛa' ‑kɔ 'ka ꞊nɛ ‑kɔ 'ö Zan ‑yö ö bha ꞊guë' ‑nu ꞊daan ‑a 'ka bhë ‑a 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","'Ö Yesu ‑ya pö ‑an ‑dhë: «Ka 'dhoë‑ ꞊bhɛa'‑, ‑kaa pö: Yi Dë, ü 'tɔ 'slööslö bhë, mɛ ‑nu ‑wa ꞊bhlë ‑ya. Ü ‑bha ‑gludëdhɛ ‑yö kë 'kpongtaa. ");
INSERT INTO dnj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","‑Dhɛkpaɔyi 'saadhö 'ka, ‑bhöpë 'ö ‑mɔ yi ꞊tian' ‑a nu yi ‑dhë! ");
INSERT INTO dnj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","‑Bhö ziö yi ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta ꞊nɛ ‑kɔ 'yi ꞊zië' mɛ ‑nu ‑bha 'wun ꞊zaa' ‑sü ‑nu ‑ta bhë ‑a 'dhö. Kö ꞊kun 'ü ü ꞊kwaa yi ‑zü 'ö dü ‑yö yi ‑püö!» ");
INSERT INTO dnj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü ꞊nɛɛ: «‑Ka ka ‑zo 'ta 'wun 'ö ꞊nɛ ‑a 'gü, ꞊ya kë ꞊nɛ mɛ do ꞊ya kë ‑dhö ka ziën, ‑a 'bhamɛ ꞊ya kë ‑dhö, ꞊ya 'dho ‑a 'piö gbeng ziën ‑yaan pö ‑a ‑dhë: ‹N 'bhamɛ, ‑bhö 'bluu‑ bhɛ ‑yaaga 'pë dɔ n ‑ma, ");
INSERT INTO dnj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bhii 'ö tɔɔ n 'bhamɛ do 'yö go 'ta 'gü, 'yö ‑wo n ‑ta ꞊nɛ, pë gbɛ 'yaa n ‑gɔ kö 'aan‑ nu ‑a ‑dhë.› ");
INSERT INTO dnj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","'Ö ꞊ya kë ꞊nɛ, ‑a 'bhamɛ ꞊ya bɔ kɔɔ ꞊yaa‑ pö ‑a ‑dhë: ‹‑Bhö ü ꞊kwaa' n ‑zü 'sengdhö! 'Ma 'kwɛɛ ta 'saadhö ꞊lakele 'ka, yië‑ ma 'në ‑nu 'yië ꞊waannu, n ‑kɔ yaa ‑mɔ ‑a ‑bha kö 'a ꞊luu'‑ 'aan‑ 'bluu‑ nu ü ‑dhë!› ");
INSERT INTO dnj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","꞊Ao', a‑ ‑pö ka ‑dhë yaa 'dho ꞊luu' ‑yaan 'bluu‑ nu ‑a ‑dhë, ‑an ‑bha ‑kë 'kobaɔngzë 'ka ‑sü ‑wun 'gü, 'kɛɛ ‑yö ‑dho ꞊luu'‑ 'ö pë 'ö ‑dhɔ ꞊kaa' bhë 'ö‑ nu ‑a ‑dhë 'kwɛɛ ‑ta 'ö ‑ma ‑na ‑kplawo bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","꞊Dhɛ ‑kë 'dhö ma ‑zë a‑ ‑pö ka ‑dhë: ‑Ka pë ‑dhɛ ‑Zlan ‑gɔ, ‑yö ‑dho ‑a nu ka ‑dhë; ‑ka pë ꞊mɛɛ' ‑Zlan 'piö, ka ‑dho ‑a yö; ‑ka 'kwɛɛ ‑ta ‑ma, ‑Zlan ‑yö ‑dho 'kwɛɛ po ka ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bhii mɛ 'oo mɛ 'ö pë ‑dhɛ ‑Zlan ‑gɔ, ‑ya ‑nu ‑a ‑dhë; 'ö mɛ 'ö pë ꞊mɛɛ ‑a 'piö, 'yö‑ yö; 'ö 'kwɛɛ ‑po mɛ 'yö 'kwɛɛ ‑ta ‑ma ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","'Ö ꞊ya kë ꞊nɛ ka ziën mɛ do ‑yö ‑dhö 'ö‑ ‑bha 'në 'dho ‑dhö, ꞊ya 'yuö‑ ‑dhɛ ‑a ‑gɔ, ‑yö ‑dho ꞊mɛɛ nu ‑a ‑dhë ‑a? ");
INSERT INTO dnj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","'Iin ꞊ya pë ‑yan ‑dhɛ ‑a ‑gɔ, ‑yö ‑dho gian nu ‑a ‑dhë ‑a? ");
INSERT INTO dnj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","'Wunyaakëmɛ ‑nu 'ka dɔ ꞊nɛ, ka pë ‑së ‑nu kaa‑ 'në ‑nu ‑dhë ‑dhɛ ‑dɔ. ꞊Dhɛ 'ö 'dhö, ‑më 'yö ‑kë 'ö ka Dë 'yö ‑ya ‑sü 'ka dhang‑ 'gü, yaa 'dho ‑Zuu 'slööslö nu mɛ 'ö‑ ‑dhɛ ‑a ‑gɔ ‑a ꞊dhë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mɛ do ‑yö ‑kë 'tuunzë, bhii ‑zuu yaa ‑yö ‑kë ‑a 'gü. ꞊Dhɛ 'ö Yesu ‑ya bho ‑a 'gü, 'yö yö 'we ‑sü ‑bha. 'Ö mɛ gbung 'wo ‑kë mü bhë 'ö ‑an 'te ‑yö tun. ");
INSERT INTO dnj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","'Kɛɛ mɛ 'bhaa ‑nu ‑wo ‑kë mü 'wo‑ pö: «Bɛɛzebilö 'ö tɔɔ dü 'ö ‑zuu yaa ‑nu ‑gɔmɛ 'ka bhë, 'yö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu ‑a ‑dhë, 'ö ‑zuu yaa ‑nu kë ‑na ‑a 'ka bhë!» ");
INSERT INTO dnj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","'Ö mɛ 'bhaa ‑nu ‑wa ‑kë kö 'waan‑ ‑a 'gü dan 'wo‑ pö ‑a ‑dhë: «‑Bhö ‑dhidhaapë do 'yö dho ‑a ‑zɔn ꞊nɛ ü bha ‑kɔ ‑mɔ 'wun ‑bha ‑sü bhë ‑yö ‑go ‑Zlan 'piö ‑a kë!» ");
INSERT INTO dnj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu ‑yö ‑an ‑bha ‑zotadhe ‑dɔ. ꞊Dhɛ ‑kë 'dhö, 'yö‑ pö ‑an ‑dhë: «'Sɛgɔ ꞊suu'‑ 'oo ꞊suu'‑ 'wo 'ko zë ‑na wo 'ko 'ka ‑an 'dhiötodhɛ 'ö tɔɔ ‑an 'gü ꞊siö' ‑sü, ‑an ‑bha 'kɔ ‑nu ‑wo ‑dho ‑lo. ");
INSERT INTO dnj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","꞊Ya kë ꞊nɛ dü ꞊ya 'ko zë ö ‑de 'ka, ‑a ‑bha 'sɛgɔ ‑dho ꞊glɔɔ ‑kɔklë ꞊ɛ? Bhii ka‑ ‑pö ꞊nɛɛ a ‑zuu yaa ‑kë mɛ ‑nu 'gü, 'ö tɔɔ Bɛɛzebilö ꞊nɛ 'ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu n ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","꞊Ya kë 'dhö kö dö 'ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu ka ‑bha mɛ ‑nu ‑dhë 'wo ‑zuu yaa ‑kë ‑a 'ka ɛ? Ka ‑de ‑bha mɛ ‑nu ‑wa ‑zɔn ꞊nɛ za yaa ‑yö ka 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","'Wun gia‑ 'ka, ‑Zlan ‑bha 'piigbeedhɛ ꞊nɛ 'a ‑zuu yaa ‑kë ‑a 'ka, kö ‑Zlan ‑bha ‑gludëdhɛ ꞊ya nu ka 'piö 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Bhii ꞊ya kë ꞊nɛ gɔɔn‑ 'gügbeezë 'ö 'ko ꞊zaa' ‑piö 'dhoë‑ ‑gɔ, ꞊ya ö ‑zo kë ö bha 'kɔ 'piö, ‑a ‑bha kɔɔpë 'plɛ ‑dho ꞊waannu ‑së 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'Ö gɔɔn‑ do 'yö‑ 'gü 'dho 'gbee‑ 'yö ‑ziö ‑a ‑ta, ꞊ya ‑wo 'ö ꞊ya 'to ‑a 'gbee‑ 'ka ‑a ‑ta, ‑ya ‑bha 'ko ꞊zaa' ‑piö 'yö ö ‑zo yö ‑a ‑bha bhë ‑ya 'plɛ ‑sü ‑a ‑gɔ; 'go mü 'yö‑ ‑bha pë ‑nu 'yö‑ sü bhë, 'yö‑ ‑glu ö ‑bha mɛ ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","A‑ ‑pö ka ‑dhë: Mɛ 'yaa n 'piö, kö ma mɛ 'yaa ‑mü; 'go mü mɛ 'ö yaa nu n ‑dhë ma pë ‑kpɔ 'kuë‑ ‑sü 'gü, kö ‑yö ‑nu n ‑ma pë 'pɛn ꞊dhia.» ");
INSERT INTO dnj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","'Yö Yesu ‑ya pö: «‑Zuu yaa ꞊ya 'go mɛ ‑nu 'gü, 'yö dho 'ö ꞊nië nië ‑dhɛ 'ö mɛ gbɛ 'yaa‑ ‑bha ‑a ‑bha kö ‑yaan ö ‑yadhɛ ꞊mɛɛ'‑. ꞊Ya kë ꞊nɛ 'yaa‑ yö ‑na, 'yö‑ pö ö ‑de ‑dhë ꞊nɛɛ: ‹A ‑dho yɛ n 'zü 'a dho n ‑yadhɛ 'a go ‑a ‑bha bhë ‑a ‑bha.› ");
INSERT INTO dnj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","'Ö ‑yɛ ö 'zü 'yö nu; 'yö ‑dhɛ mɛ 'ö ‑kë ‑a ‑bha 'dhiö bhë ‑a yö kö ꞊ya kë ꞊nɛ 'kɔ 'ö ‑a 'gü ‑dhɛ 'dho go ‑sü 'ka, 'ö pë 'plɛ 'dho ‑dho 'kuë‑ ‑sü 'ka ‑a 'gü bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","꞊Ya kë 'dhö 'ö ‑zuu yaa 'slaplɛ 'ö ‑an këwun 'dho ya 'ö ꞊ziö' ‑a ‑ta bhë 'yö ‑an kpa ö ‑bha, 'ö wo 'plɛ 'wo nu 'wo wo ‑yadhɛ kun ‑dhɛ bhë ‑a ‑bha. ꞊Ya kë 'dhö zlöö kö gɔɔn‑ 'ö bhë ‑a ‑bha 'wun kë ‑kɔ ꞊ya kë ya, ꞊ya ziö ‑a mɛ 'ö 'dhiö ‑a ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","꞊Dhɛ Yesu ꞊ya yën 'wun 'ö bhë ‑a ꞊blɛɛ' ‑sü ‑bha, 'ö dhebɔ do ‑yö ‑bɔ mɛ gbung 'gü, 'yö‑ pö: «꞊Zuögludhi ‑yö kë dhebɔ 'yö ü ‑gu sü 'yö ü gbaa 'yɔn 'ka bhë ‑a ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'Ö Yesu ‑ya ‑pö ‑a ‑dhë: «꞊Zuögludhi ‑yö kë ꞊zian' mɛ 'wo ‑Zlan ‑wo ma 'ö 'wo‑ ꞊bhlë ‑ya ‑an ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","꞊Dhɛ 'ö mɛ ‑nu 'dho bhɔ ‑na 'kuë‑ ꞊va Yesu ‑zü, 'yö‑ pö ‑an ‑dhë: «Mɛ 'bhee‑ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü ꞊nɛ ‑an këwun 'yaa ‑së; wo 'ö 'wo 'dhö bhë, 'wo ‑dhidhaapë 'yö dho kë ꞊duakëpë 'yö go ‑Zlan 'piö 'wo‑ ꞊mɛɛ, 'kɛɛ ‑dhidhaapë gbɛ 'ka 'dho kë ‑a 'ke yaa kë Zonasö ‑bha ‑dha ga ‑gɔ ‑sü 'ka; ('kɛɛ kö ꞊ya ‑dhɛkpaɔyi ‑yaaga kë 'yuö‑ 'guu). ");
INSERT INTO dnj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","‑Kɔ do 'ö Zonasö ‑yö ꞊kaa' ꞊duakëpë do 'ka, mɛ ‑nu 'wo Ninivö ‑an ‑bha 'ka 'dhiö ‑be bhë, ‑kɔ do bhë ‑a 'ka 'ö ma 'a Mɛgbö 'ka 'a dho kaa mɛ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑an ‑bha ꞊duakëpë do 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","‑Zlan ‑bha zakanyi 'ka, ‑gludhe 'yö ‑kë Seba ‑sɛ ꞊kɔɔnmɛ 'ka bhë ‑yö ‑dho ꞊luu'‑ mɛ 'bhee‑ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü ‑an ‑gɔ, 'yö za ‑lo ‑an tuö; bhii 'ö tɔɔ ‑yö ‑go 'sɛ ꞊gbiin gbɛ ‑ta, 'yö nu 'yö ö 'to to Salomɔ ‑wo 'ö 'kpaakpadhɛ 'ö ‑Zlan ‑ya nu ‑a ‑dhë bhë ‑a ‑bha. Yö do bhë 'zü, ‑dhɛ 'ö ꞊nɛ ‑a 'gü mɛ do 'yö ꞊va 'ö ꞊zië' Salomɔ ‑ta ‑yö zö. ");
INSERT INTO dnj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","'Go mü ‑Zlan ‑bha zakanyi 'ka, mɛ ‑nu 'wo Ninivö ‑wo ‑dho ꞊luu'‑ mɛ 'bhee‑ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑an ‑gɔ, 'wo za ‑lo ‑an tuö, bhii 'ö tɔɔ ꞊dhɛ Zonasö ꞊ya ‑Zlan ‑wo ꞊blɛɛ'‑ ‑an ‑dhë, ‑wo wo ‑bha ‑kë ‑a 'gü ‑sü ꞊dhië ‑kwaa ‑Zlan 'piö, 'kɛɛ kö mɛ 'yö ꞊va 'yö ꞊zië' Zonasö ‑ta 'yö zö.» ");
INSERT INTO dnj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","'Ö‑ pö: «'Waa ꞊labang dɔ kö ‑waan ‑a ‑bin, 'iin kö ‑waan 'gbonggbo 'gblü ‑a ‑ta. ‑Abi'! ‑Wa ‑dɔ ꞊zian' ö ‑dɔ ‑a ‑ta dhuö ‑pë ‑ta; ‑yö ‑kë 'dhö kö mɛ ‑nu 'wo ‑da ‑na kɔɔ bhë ‑waan ‑dhɛpuudhɛ yö. ");
INSERT INTO dnj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mɛ 'yan ‑yö ‑kë ꞊nɛ mɛ bun ‑bha ꞊labang 'dhö. 'Ö ꞊ya kë ꞊nɛ ‑potaasü ꞊ya kë ‑an ‑gɔ, kö bun ‑yö ‑dhɛpuudhɛ 'gü; 'kɛɛ ꞊ya kë ꞊nɛ ‑potaasü 'yaa ‑an ‑gɔ kö bun ‑yö ‑dhɛtiidhɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","꞊Dhɛ 'ö 'dhö kö ‑ka ka ‑zo kë ka ‑de 'piö, kö ꞊kun 'ö ‑dhɛpuudhɛ 'yö ka 'gü bhë 'yö ‑kë ka ‑gɔ ‑dhɛtiidhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","'Ö ꞊ya kë ꞊nɛ ka bun ‑dhɛ 'saadhö ꞊ya 'bhü, 'ö ‑a ‑dhɛ gbɛ yaa 'to ‑dhɛtiidhɛ 'gü, ‑dhɛpuudhɛ ‑dho ‑a pa ꞊nɛ ‑kɔ 'ö ꞊labang 'dho ö bha 'bhü ‑sü yö ‑na ‑a 'ka kɔɔ bhë ‑a 'dhö 'papadhö.» ");
INSERT INTO dnj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","꞊Dhɛ Yesu ꞊ya yën 'wun ꞊blɛɛ' ‑sü ‑bha 'dhö, 'ö Falizi ‑mɛ do ‑ya ꞊dhɔɔ ‑kë ö ‑gɔ kɔɔ kö 'waan‑ pë ‑bhö. Yesu ‑yö ‑dho ‑a ‑gɔ kɔɔ, 'yö‑ ‑nia kun kö ‑waan pë ‑bhö. ");
INSERT INTO dnj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Falizi ‑mɛ bhë ‑a 'te ‑yö ‑tun ‑kɔ 'ö Yesu yaa‑ 'zlu ꞊nɛ ‑an ‑bha wɔ 'dhö ‑yaan ꞊tun pë ‑bhö ‑na bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","'Ö Dëmɛ ‑ya pö ‑a ‑dhë: «Pë 'ö Falizi ‑mɛ ‑nu, 'ka ‑a 'ka, ꞊ga 'ö ꞊nɛ: Ka 'yi mü ‑kɔɔ ‑nu waa‑ 'tia‑ ‑nu ‑an bun 'kpaan ‑zlu 'kɛɛ 'kaa ‑an 'gü ‑dhɛ 'zlu; ka ‑de ꞊zuö' 'piö, ka ‑ya ‑sü 'ka ꞊kwaan ‑sü waa‑ 'glu yaa ‑an ‑wuën! ");
INSERT INTO dnj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","'Wun ‑yö 'yaan ‑mɛ ‑nu 'ka ꞊nɛ! ‑Zlan 'yö pë plaan ‑dhɛ ‑pë ‑kë bhë, yö do kun 'ö pë 'gü ‑dhɛ ‑yuö ‑kë 'pö a? ");
INSERT INTO dnj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","‑Ka pë ‑nu nu ka ꞊zuöga 'plɛ 'ka ꞊zian', 'ka pë ‑nu 'wo ka ‑gɔ ‑an nu 'yenamɛ ‑nu ‑dhë; ꞊ya kë 'dhö ka ‑bha pë 'plɛ ‑dho kë 'slööslö. ");
INSERT INTO dnj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","'Yena ‑wun ‑dho kë ka 'ka, Falizi ‑mɛ ‑nu, 'ö tɔɔ ka ka ‑bha pë 'gɔɔ‑ do ‑naa ‑bho ka ‑bha 'too ꞊dhɛɛ' ‑pë 'sɛnsɛn 'plɛ 'ka, 'ö 'kaa ka ‑zo ‑kë ka ‑de 'piö, ‑kë kpengdhö ‑sü 'ka waa‑ ‑Zlan ‑dhɔ ‑ya ka ꞊zuö' 'piö ‑sü 'ka bhë. Pë 'ö 'ka dho ‑a kë ‑bezë 'ö bhë, kö ‑yaan 'to ‑an mɛ ‑nu 'wo to ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","'Yena ‑wun ‑dho kë ka 'ka, Falizi ‑mɛ ‑nu, 'ö tɔɔ ka‑ ‑dhɔ ‑kë ‑yadhɛ ꞊bhlëzë ‑nu 'ö 'wo ‑bhɔkuëkɔ ‑nu 'gü bhë ‑an 'ka 'iin kö mɛ ‑nu ‑wo ‑mɛɛ kë ka 'ka ꞊bhlë 'gü 'dhëëdhɛ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Yena ‑wun ‑dho kë ka 'ka, 'ö tɔɔ ka ‑kë ꞊nɛ blɔɔn‑ 'ö mɛ gbɛ 'yan 'yaa‑ yö 'ö 'wo ꞊taa ‑a ‑ta, 'waa ‑a ꞊tɛi' dɔ ꞊nɛ mɛ ꞊glöö 'buu ‑ya 'gü bhë ‑a 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","꞊Dhɛ ‑kë 'dhö 'ö tɔnggɔmɛ do ‑ya pö Yesu ‑dhë: «N ‑Gɔmɛ, ü 'wun ꞊blɛɛ' ‑na ꞊nɛ ‑kɔ bhë ‑a 'dhö kö 'si 'ü‑ bho ‑na yi ‑de 'pö yi ‑gɔ bhë!» ");
INSERT INTO dnj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «'Yena ‑wun ‑dho kë tɔnggɔmɛ ‑nu ka ‑de 'pö ka 'ka! Bhii 'ö tɔɔ ka ꞊kwɛɛ‑ ꞊va ‑sü 'ka‑ dɔ mɛ ‑nu tuö 'ö 'kaa nu ‑an ‑dhë 'bhe 'tee wo kö 'kaan‑ ‑an ‑bha ꞊kwɛɛ‑ ‑nu bho ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","'Yena ‑wun ‑dho kë ka 'ka! Bhii 'ö tɔɔ ‑Zlan ‑wodhiölomɛ ‑nu 'ö ka 'bhɛma ‑nu ‑wo ‑an zë bhë ka‑ blɔɔn‑ ‑ta dhuö ‑dhɛ ‑pë ‑kë. ");
INSERT INTO dnj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","‑A ‑kë 'dhö ‑sü 'gü ka‑ ‑zɔn ꞊nɛ ka 'bhɛma ‑nu ‑bha yuö kë ‑kɔ 'yi‑ ‑kan ka 'dhii! Bhii wo ‑zë ‑wo ‑an ‑zë, 'ö ka ‑zë 'ö 'ka 'kɔ ‑nu dɔ ‑an blɔɔn‑ ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bhii ‑Zlan ‑ya ‑blɛɛ ö ‑bha 'kpaakpadhɛ 'ka 'dhiö ‑be ꞊nɛɛ: A ‑dho ma ‑wodhiölomɛ ‑nu waa‑ ma bɔmɛ ‑nu bɔ ‑an ‑dhë; ‑wo ‑dho ‑a mɛ 'bhaa ‑nu zë 'ö 'wo‑ mɛ 'bhaa ‑nu 'klo bhɔ. ");
INSERT INTO dnj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'Kɛɛ pë dho kë 'ö tɔɔ mɛ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü bhë, ‑an 'klo ‑dho bhɔ ‑Zlan ‑wodhiölomɛ ‑nu 'wo ‑an zë 'ö sü 'kpongtaadhɛ züdɔyi ‑bha bhë ‑a ‑wun 'gü ");
INSERT INTO dnj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","'Ö sü Abɛlö zë ‑yi 'ö ‑kë mɛ zë ‑sü ‑blɛɛzë 'ka 'kpongtaa zö bhë ‑a ‑bha ‑yö yöë Zakali 'wo‑ zë sla‑ bho ‑dhɛ waa‑ ‑dhɛ 'slööslö ‑dhɛ ꞊duö ‑an ziën bhë ‑a ‑wun 'gü. A‑ ‑blɛɛ ka ‑dhë giagia 'ka ꞊nɛɛ: Mɛ ‑nu 'wo ꞊dɛɛ ꞊nɛ, ‑an 'klo ‑dho bhɔ mɛ zë 'ö ‑an 'bhɛma ‑nu ‑wa wo bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Yena ‑wun ‑dho kë ka 'ka, tɔnggɔmɛ ‑nu, bhii 'ö tɔɔ 'ka ꞊lakele 'yö dho 'kwɛɛ po mɛ ‑nu ‑gɔ kö ‑waan ‑Zlan ‑bha 'wun ‑nu dɔ bhë, 'ka‑ sü 'ö ka 'ö ka 'ka 'dho ‑da kɔɔ bhë, 'ka‑ ‑kë 'ö mɛ ‑nu 'wo‑ ‑dhɔ ꞊kaa' kö 'waan‑ ‑da kɔɔ bhë, 'kaa 'we ‑a ‑bha kö ‑wo ‑dakɔɔdhɛ yö.» ");
INSERT INTO dnj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","꞊Dhɛ 'ö Yesu ꞊ya 'go ‑dhɛ bhë ‑a 'gü, tɔnggɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu ‑wo yö ‑ziö ‑a 'piö ‑sü 'gü ‑naazuëdhe 'ka, 'ö 'wo ꞊dhɛɛ' ‑nu kpɔ ‑a ‑gɔ 'wun ‑nu ꞊plëëzë ‑gɛn 'ka; ");
INSERT INTO dnj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","'kɛɛ ‑yö ‑kë 'slë 'ka 'wo‑ ‑kan ‑a ‑gɔ ‑a këdhɛ ꞊mɛɛ' ‑sü 'ka kö ‑waan ‑a 'kun ö ‑wo ‑nu ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","‑A 'töng bhë ‑a 'ka, mɛ ‑nu ‑wo ‑dho wo 'ko ꞊bhaa ‑vuu ꞊plëëzë 'ka. 'Ö ꞊dhɛ to zlöö kö ‑wo ꞊taa' ‑na wo 'ko ‑nu ‑gɛn 'dhɛ ‑ta, 'ö Yesu ‑yö ꞊dhië ö bha ꞊guë' ‑nu 'piö, 'yö‑ pö ‑an ‑dhë: «‑Ka ka ‑zo kë ka ‑de 'piö Falizi ‑mɛ ‑nu 'ö ‑an ‑bha 'wun kë ‑kɔ ‑yö ‑kë ꞊nɛ ꞊bluubhɛɛpë 'dhö bhë ‑an ‑gɔ, 'ö tɔɔ mɛ 'yan ‑ta ‑wun kë ‑mɛ ‑nu ‑mü ‑an 'ka! ");
INSERT INTO dnj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pë 'yö ‑bin ‑sü 'ka ‑a 'plɛ ‑yö ‑dho yö ‑dhɛgbɛadhɛ 'gü; 'ö 'sloo 'ka ‑wun 'yö ‑bin ‑sü 'ka 'yö dho yö plaan. ");
INSERT INTO dnj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","‑A ‑wun 'gü, 'wun ‑nu 'ka dho ‑a ꞊blɛɛ'‑ ‑dhɛtiidhɛ 'gü, 'wo dho ‑a ma ‑dhɛ 'po ‑sü 'gü; 'ö 'wun ‑nu 'ka dho ‑an ꞊blɛɛ'‑ ka 'ko 'toodhö ka ‑gɔ kɔɔdhɛ ‑nu ‑bha, 'wo dho ‑a ꞊blɛɛ'‑ mɛ ‑nu ziën.» ");
INSERT INTO dnj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«'Wun mɛ 'ö ꞊nɛ a‑ ‑blɛɛ mɛ 'ka n 'bhamɛ ‑nu 'ka ka ‑dhë: Kö ꞊kun 'ka ‑suö mɛ ‑nu 'wo dho ka zë, 'ö 'go mü waa 'dho pë 'waa gbɛ kë gbɔ bhë ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","A ‑dho mɛ 'ka dho suö ‑a ‑dhë ‑a ‑zɔn ka ‑dhë: ‑Ka 'suö ‑Zlan 'ö ꞊ya mɛ 'sü 'ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü 'dhoë‑ ‑gɔ kö ‑yaan mɛ ‑zuö ꞊glöötiaandhö 'siö 'gü bhë ‑a ‑dhë. ꞊Ii‑, a‑ ‑pö ka ‑dhë: ‑Ka 'suö ‑a ‑dhë 'dhɛ! ");
INSERT INTO dnj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kë 'kwa‑ wo ꞊nɛ 'waa ꞊zöng' 'sɔɔdhu 'dhɔɔ dɔ 'wëü‑ 'tama ga ꞊plɛ ‑bha ‑a? 'Kɛɛ kö ‑Zlan ‑zlö 'yaa trö ‑a do ‑de ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","'Go mü 'ö ka tuö ‑wun 'plɛ 'dho ꞊dhong' ‑sü 'ka. Kö ꞊kun 'ö 'suö ‑yö ka ‑kë, ka ‑wun ꞊yö 'gbee‑ 'yö ꞊zië' ꞊zöng' ‑nu ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","'Ö‑ pö: «A‑ ‑pö ka ‑dhë: Mɛ 'oo mɛ 'yö 'dhoë‑ ‑a pö mɛ ‑nu ziën ‑yö n ‑ma 'ka, ma 'a Mɛgbö 'ka 'pö a ‑dho ‑a pö ‑Zlan ‑bha bɔmɛ ‑nu ‑dhë ‑yö n ‑ma 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'Kɛɛ mɛ 'oo mɛ 'ö 'dhoë‑ pö mɛ ‑nu ziën 'yaa n dɔ, ma 'a Mɛgbö 'ka 'pö, a ‑dho ‑a pö ‑Zlan ‑bha bɔmɛ ‑nu ‑dhë 'maa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mɛ 'oo mɛ 'ö 'dhoë‑ 'wun yaa ꞊blɛɛ'‑ ma 'a Mɛgbö 'ka n 'ka, ‑Zlan ‑dho ziö ‑a ‑bha 'wun yaa 'ö 'dhö bhë ‑a ‑ta; 'kɛɛ mɛ 'ö 'dhoë‑ 'wun yaa ꞊blɛɛ'‑ ‑Zuu 'slööslö ‑gɔ, yö 'ka 'dho ziö ‑a ‑bha 'wun yaa 'ö 'dhö bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","꞊Ya kë ꞊nɛ ꞊wa ka 'kun, 'to 'ka‑ wo ‑na n 'piö bhë ‑a ‑wun 'gü, 'ö ꞊wa 'dho ka 'ka Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü, 'iin 'dhiö ‑sü ‑mɛ 'ka ‑mɛ ‑nu, 'iin 'sɛ ꞊kɔɔnmɛ ‑nu ‑an 'dhiö kö ‑waan 'wun dɔ ka ‑bha, kö ꞊kun 'ka dɔ pë 'ka dho ‑a ꞊blɛɛ'‑ ‑a ‑wun ꞊zɔnng' ‑ta ka ‑de ‑gɔ ‑wun ꞊blɛɛ' ‑sü 'gü; ");
INSERT INTO dnj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","bhii ‑Zuu 'slööslö ‑dho 'wun 'ka dho ‑a ꞊blɛɛ'‑ ‑a ‑zɔn ka ‑dhë 'töng gia‑ bhë ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","'Töng bhë ‑a 'ka, mɛ do ‑yö ‑bɔ mɛ gbung ziën 'ö‑ pö Yesu ‑dhë: «N Dëmɛ, ‑bhö ‑a pö n dheglu ‑dhë, pë ‑nu 'ö yi dë ‑ya to yi ‑gɔ bhë 'yi ‑an ‑glu!» ");
INSERT INTO dnj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «Gɔɔn‑ ꞊nɛ, dö 'ö n ‑ya kö 'aan‑ kë ü bha za ‑nu 'kan ‑mɛ 'ka, 'iin 'aan‑ kaa‑ pë ‑nu ‑glu ka 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö ‑an 'plɛ ‑dhë: «Kö ꞊kun 'ka ‑klu ꞊bhɔɔpë ‑nu ‑bha, bhii mɛ ‑bha ‑kë ‑a 'gü ‑sü yaa 'dho yö ꞊bhɔɔpë ‑nu ‑bha ‑kë ‑a ‑gɔ ‑sü ‑bha, 'kö ‑kë ꞊nɛ ‑yö ꞊bhɔɔzë ꞊duö 'dhee.» ");
INSERT INTO dnj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Yö Yesu ‑yö 'wun ꞊zuan' do ‑zɔn ‑an ‑dhë 'ö‑ pö: «Gɔɔn‑ ꞊bhɔɔzë do 'ö tapë ‑nu ‑wo ‑kë ‑a ‑gɔ ꞊va ‑yö ‑kë ‑dhö; 'yö pë ‑yö ‑dhi ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","'Yö ö ‑zo ‑ta 'ö‑ pö ö ꞊zuö' 'piö ꞊nɛɛ: ‹A ‑dho ‑a kë ‑kɔklë ꞊oo? ꞊Dhɛ 'a dho ma pë ‑nu ‑lo ‑a ‑bha, 'maa‑ yö ‑na!› ");
INSERT INTO dnj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Yö‑ pö ö ꞊zuö' 'piö 'zü ꞊nɛɛ: ‹Pë 'a dho ‑a kë 'ö ꞊nɛ: A ‑dho ma 'slëëdhɛ ‑nu wü 'a‑ gbɛ ꞊va kë, 'ö 'a ma ‑mlü ‑nu waa‑ ma pë ‑sɛɛbɔ 'töüdhö 'a ‑lo ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","꞊Ya kë 'dhö kö ma pë 'plɛ 'dhiö ꞊ya ‑mɔ, bhii kö n ‑bhöpë ‑nu ꞊wa kë ꞊va ‑kwɛ ꞊plëëzë ‑bha 'ka, kö n ꞊yaannu ‑sü ‑mü 'aan‑ n 'tɛɛ pa, 'aan‑ ‑bhöpë ‑nu ‑bhö 'aan‑ müpë ‑nu mü ꞊zuögludhi 'ka.› ");
INSERT INTO dnj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'Kɛɛ ‑Zlan ‑ya ‑pö mɛ 'ö 'dhö bhë ‑a ‑dhë: ‹Gɔɔn‑ 'ö 'yaa‑ 'wun dɔ ꞊nɛ, gbeng ‑yi do 'ö ꞊dɛɛ ꞊nɛ ‑a 'gü ꞊nɛ ü bha 'të ‑sü ‑yö ‑dho ꞊gbaannu, ꞊ya kë 'dhö pë ‑nu 'ü ‑an ꞊waannu ü ‑bha 'ka ꞊nɛ, dö 'yö dho to ‑a ‑gɔ ‑ɛ?› » ");
INSERT INTO dnj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","'Ö Yesu ‑ya pö 'zü ꞊nɛɛ: «‑Kɔ do 'ö ꞊nɛ 'yö dho kë ‑a 'ka mɛ 'yö ö ‑bha ꞊bhɔɔpë ‑nu 'kpuɛ‑ 'kpɔ ‑na yö gia‑ ö ‑bha 'ka ö ‑de ‑yö ꞊bhɔɔzë ‑sü 'ka bhë ‑a 'ka, 'kɛɛ kö ‑yö 'fɛɛzë ‑Zlan wö 'dhiö.» ");
INSERT INTO dnj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «‑A ‑wun 'gü a‑ ‑pö ka ‑dhë: Kö ꞊kun 'ka dɔ ‑bhöpë 'ka dhoë ‑bhö 'kaan‑ ‑tosiadhe kë ‑a ‑ta ‑a ‑wun ꞊zɔnng' ‑ta, 'iin sɔ ‑nu 'ka dhoë ‑da ka ‑bha ‑an ‑wun ꞊zɔnng' ‑ta 'pö, ");
INSERT INTO dnj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","bhii ‑kë ‑a 'gü ‑sü ‑wun ꞊yö 'gbee‑ 'ö ꞊zië' ‑bhöpë ‑wun ‑ta, 'ö kwa bun ‑wun 'dho 'gbee‑ 'ö ꞊zië' sɔ 'ka dho ‑a ‑da ka ‑bha ‑a ‑wun ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","‑Ka mua‑ ‑nu ‑ga! 'Waa pë gbɛ ta ‑waan 'dho ‑a 'kan, 'ö ‑an ‑bha 'siödhɛ 'iin 'slëëdhɛ gbɛ 'yaa ‑dhö, 'kɛɛ ‑Zlan ‑yö ‑bhöpë ‑nu ‑an ‑dhë 'sa. Ka ‑wun ꞊yö 'gbee‑ 'ö ꞊zië' ‑ma ‑nu ‑ta! ");
INSERT INTO dnj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dö ‑mü ka ziën 'yö dho ‑mɔ ‑a ‑bha kö ‑yaan ö ‑de ‑bha yi ‑da 'dhiö ‑a ‑bha ‑dɔ ‑de ‑wun ꞊zɔnng' ‑ta ‑sü ‑wun 'gü i? ");
INSERT INTO dnj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","꞊Dhɛ 'ö ka ‑kɔ gbɛ 'ka 'dho ‑mɔ pë 'sɛnsɛn ‑nu 'wo ꞊nɛ ‑an kë ‑sü ‑bha ꞊nɛ, ‑më ‑kë 'ka dɔ ka ‑de ‑wun ꞊zɔnng' ‑ta pë ‑nu 'wo to ‑a ‑wun 'gü i? ");
INSERT INTO dnj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‑Ka 'lübin ‑kë ‑së ‑kɔ ‑nu ‑ga bhë 'dhɛ! 'Waa yuö gbɛ kë 'iin 'waa ꞊yee'‑ ꞊zloo'‑ ‑waan 'dho sɔ bɔ, 'kɛɛ a‑ ‑pö ka ‑dhë ka gia‑, ka Salomɔ 'ö ‑kë ‑gludë 'ka 'kpa bhë ‑a ‑bha ‑kë ꞊bhɔɔzë ‑kɔ ‑wun ‑dɔ. ‑Yö ‑kë 'dhö 'kɛɛ sɔ 'yö 'yan dho kë ‑së ꞊nɛ 'lübin ‑nu 'wo ꞊nɛ ‑an do 'dhö yaa kë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","꞊Ya kë ꞊nɛ 'lübin 'ö bhlö‑ lënng ꞊nɛ, ‑Zlan ꞊yaa‑ ‑kë ‑së, 'kɛɛ kö ꞊dhia' ‑wo ‑dho ‑a ‑güö, ‑më 'yö‑ ‑kë ka ‑de 'pö yaa 'dho ö ‑zo kë ka buënpë ‑nu ‑wun 'piö 'pö e? Ka ‑bha ‑zo ‑yö ‑Zlan ‑bha ‑sü bhë, kë 'ö‑ wo 'tee bhë yö ‑mü! ");
INSERT INTO dnj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kö ꞊kun 'ka dɔ pë 'ka dho ‑a ‑bhö waa‑ pë 'ka dho ‑a mü ‑a ‑wun ꞊zɔnng' ‑ta ‑an ꞊mɛɛ' ‑sü 'ka ‑kplawo, 'iin kö ꞊kun 'ka ka ‑zo ‑ta pë gbɛ ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","bhii 'kpongtaamɛ ‑nu 'ö 'waa ‑Zlan dɔ bhë ꞊nɛ 'ö‑ ‑wun 'gü 'wo pë ‑nu bhë 'wo ‑an ꞊mɛɛ' ‑na ‑kplawo bhë. 'Kɛɛ ka ‑zë ka Dë ‑ya ꞊tɛi' ‑dɔ ꞊nɛ pë ‑nu 'wo bhë ka ‑bha ‑wun ‑ya ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Wun ‑nu 'wo ‑gban ‑Zlan ‑bha, ‑kaa ‑an ꞊mɛɛ' 'dhiö ꞊kun; ꞊ya kë 'dhö, ‑yö ‑dho pë ‑nu 'wo to ‑an nu ka ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","'Ö‑ pö: «Ma ꞊guëzë ‑nu, 'kö ‑kë ꞊nɛ ka 'tee 'dhee, kö ꞊kun 'ö 'suö ‑yö ka ‑kë, bhii ‑yö ‑kë ka Dë ‑dhë ‑së kö 'ka kë ‑a ‑bha ‑gludëdhɛ 'gü ‑në ‑nu 'ka! ");
INSERT INTO dnj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ka ‑bha pë ‑nu 'wo ka ‑gɔ, ‑ka ‑an 'dhɔɔ dɔ, 'ka‑ ꞊naɔ ‑nu nu 'fɛɛmɛ ‑nu ‑dhë. ‑Ka ka ‑bha ꞊naɔ ‑da ‑a 'gü ‑pë ‑nu 'ö‑ 'gü 'yaa ꞊siö'‑ ‑a ‑yuö kë, 'ka ka ‑bha ꞊naɔ ‑nu ‑da dhang‑ 'gü ‑dhɛ 'ö‑ 'gü ‑yö 'ka 'dho ꞊siö'‑ 'gbɛɛdhö bhë ‑a 'gü, bhii ꞊kwaanmɛ gbɛ 'ka 'dho ‑wo 'ma 'iin 'lɔɔn ‑nu gbɛ 'yaa 'ma ‑yaan ‑a ꞊siö'‑. ");
INSERT INTO dnj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bhii ‑dhɛ 'ö ü bha ꞊naɔpë ‑nu 'dho ‑a ‑bha, 'ö ü ꞊zuö' 'dhoë‑ ‑bha 'pö.» ");
INSERT INTO dnj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","'Ö‑ pö: «‑Ka ‑zo kë ka ‑de 'piö, 'ka ka ‑bha ‑du kwi dɔ sɔ ‑ta, 'ka ka ‑bha ꞊labang dɔ! ");
INSERT INTO dnj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","‑Ka kë ꞊nɛ yuökëmɛ ‑nu 'wo ‑ya wo ‑gɔmɛ ‑gɔ ‑an 'dhö! 'Ö ꞊ya kë ꞊nɛ ‑an ‑gɔmɛ ꞊ya 'go 'wlaan‑ ‑ta ꞊ya nu yi 'oo yi 'ka, 'ö ꞊ya 'kwɛɛ ‑ta ‑ma kö ‑waan 'to mü ‑waan 'kwɛɛ 'po ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","꞊Zuögludhi ‑yö kë yuökëmɛ ‑nu 'ö ‑an ‑gɔmɛ ꞊ya nu, 'ö dho ‑an yö ‑ya 'yaan ‑sü 'ka ‑an ‑gɔ! Bhii a‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ‑an ‑gɔmɛ ‑yö ‑dho ö bha ‑du kwi dɔ sɔ ‑ta 'yö ‑yadhɛ nu ‑an ‑dhë kö ‑waan pë ‑bhö, 'yö ‑bhöpë nu ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Ö ꞊ya kë ꞊nɛ ꞊ya nu gbeng ziën 'iin 'töng gbɛ 'ka, ꞊ya ‑an yö ‑ya 'yaan ‑sü 'ka, kö ꞊zuögludhi ‑yö kë mɛ ‑nu 'wo 'dhö bhë ‑an ‑gɔ! ");
INSERT INTO dnj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","‑Yö kë ka 'yaan ꞊nɛ 'kɔdëmɛ ‑yö ꞊kwaanmɛ nu ‑yi ‑dɔ ‑bezë, yaa 'dho ö ꞊kwaa' ‑a ‑zü kö ‑yaan ‑da kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kö ka ‑de 'pö, ‑ka ka ‑zo kë ka ‑de 'piö, bhii ma 'a Mɛgbö 'ka, n ‑yɛ 'zü ‑yi 'a dho nuë bhë 'kaa‑ dɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","꞊Dhɛ ꞊ya kë 'dhö, Piɛɛ ‑ya ‑pö: «N Dëmɛ, 'wun ꞊zuan' 'ö ꞊nɛ ü‑ ‑zɔn yi ‑de 'sloo yi ‑dhë, 'iin ü‑ ‑kë mɛ 'saadhö yi ‑dhë e?» ");
INSERT INTO dnj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","'Ö Dëmɛ ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «Yuökëmɛ 'ö to ö ‑wo ‑ta 'yö 'wun dɔ, 'ö tɔɔ mɛ 'ö‑ ‑gɔmɛ 'dho 'wun 'plɛ ‑lo ‑na ‑a kwɛɛ kö mɛ ‑nu 'wo to ‑yaan ‑an ‑bha ‑bhöpë nu ‑an ‑dhë 'töng 'wo dho ‑bhöpë ꞊bhöë' ‑a 'ka bhë. ");
INSERT INTO dnj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","꞊Zuögludhi ‑yö kë yuökëmɛ 'ö‑ ‑gɔmɛ ‑yɛ 'zü 'töng 'ka ‑yaan nu ö ꞊plöö 'yö dho ‑a yö yuö ‑nu 'yö‑ nu ‑a ‑dhë bhë ‑a 'dhiö bhë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ‑A ‑gɔmɛ ‑yö ‑dho ö bha pë ‑nu 'saadhö ‑a 'kluën bho ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","'Kɛɛ ꞊ya kë ꞊nɛ yuökëmɛ 'ö 'dhö bhë ꞊yaa‑ pö ö ‑de 'gü ꞊nɛɛ: ‹N ‑gɔmɛ 'yaa nu ‑na 'siö‑›, 'ö ꞊ya ‑ya yuökëgɔɔn ‑nu 'iin yuökëdhoo ‑nu mɛ 'wo to ‑an ‑ma ‑sü 'gü, 'ö ‑ya ö ‑de nu pë ‑bhö ‑sü waa‑ ‑drɔɔn 'yi mü ‑sü ‑an ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","‑a ‑gɔmɛ ‑dho nu yi 'ö 'yaa‑ dɔ 'iin 'lɛlɛ 'yaa‑ dɔ 'pö ‑a 'ka. ‑Yö ‑dho yuökëmɛ 'ö bhë ‑a 'klo bhɔ 'gbee‑ 'ka, 'yö‑ ‑kë 'yö dho mɛ ‑nu 'ö 'waa ‑Zlan ‑bha mɛ 'ka ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yuökëmɛ 'ö pë 'yö‑ ‑gɔmɛ 'dho ‑a 'piö 'yö‑ dɔ, 'kɛɛ 'ö 'yaa‑ 'piö kö 'yö ‑an kë bhë, ‑a 'klo ‑dho bhɔ ‑klaa ‑yan ꞊plëëzë ‑sü ‑a ‑bha ‑sü 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","'Ö ꞊zië' yuökëmɛ 'ö pë 'ö‑ ‑gɔmɛ 'dhoë‑ 'piö 'yaa‑ dɔ, 'kɛɛ 'ö 'wun ‑nu 'ö 'waa ‑së 'ö ‑an ‑kë, 'ö‑ ‑bha ‑klaa ‑yan ‑dho kë 'tee bhë ‑a ‑ta. Mɛ 'ö 'wo pë nu ‑a ‑dhë ꞊va ꞊nɛ, 'wo dho pë ‑dhɛ ‑a ‑gɔ 'pö ꞊va. 'Ö mɛ 'wo pë 'kluën bho ‑a ‑bha ꞊va, 'wo dho ‑a ‑dhɛ ‑a ‑gɔ ꞊va 'zü!» ");
INSERT INTO dnj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","'Yö‑ pö 'zü: «A ‑nu 'siö ‑da ꞊dhia 'kpongtaa. ‑Më 'kpaan 'ö dho kë n ‑dhë ‑së ‑yaan zië ‑a ‑bha 'kun ‑sü ‑ta ‑ɛ! ");
INSERT INTO dnj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","'Kɛɛ 'dhiö ‑blɛɛzë a ‑dho bɔ 'yënngbhɔdhe 'gü; n ꞊zuö' ꞊ya ‑da ‑dewo ‑a 'yena 'gü ‑yaan 'dho ‑yaan yöë ‑a 'dhiö ‑mɔ 'kuë ‑yi ‑bha! ");
INSERT INTO dnj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","‑Yö ‑kë ka ‑zo 'piö ꞊nɛ a ‑nu ꞊zuöyagluu nu ꞊dhia 'kpongtaamɛ ‑nu ‑dhë ‑a? A‑ ‑pö ka ‑dhë: ‑Abi', 'kɛɛ 'gügludhe ‑da ka ziën ‑sü ‑mü ꞊zian', bhii 'ö tɔɔ mɛ 'bhaa ‑nu ‑wo ‑dho we n ‑wun ‑bha, 'ö ‑an 'bhaa ‑nu ‑wo ‑kɔ n ‑wun 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","꞊Dɛɛ ꞊nɛ ‑a 'gü zlöö, 'gügludhe ‑yö ‑dho ‑da 'kɔ do 'gü ‑mɛ ‑nu 'wo wo 'kuëdhö 'sɔɔdhu ‑an ziën; mɛ ‑yaaga ‑wo ‑dho ‑trö mɛ ꞊plɛ ‑bha, 'ö mɛ ꞊plɛ ‑wo ‑ya mɛ ‑yaaga ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","'Nëdë ‑dho dɔ ö bha 'në ‑gɔ 'yënng, 'ö 'në ‑de 'pö 'yö dɔ ö dë ‑gɔ 'yënng; 'ö dhe dho dɔ ö 'dhu ‑gɔ 'yënng, 'ö‑ 'dhu ‑de 'pö 'yö dho dɔ ö dhe ‑gɔ 'yënng. 'Në gɔɔn‑ dhe ‑dho dɔ ö bha 'në bɔɔ ‑gɔ 'yënng, 'ö 'në bɔɔ ‑de 'pö 'yö dɔ 'në gɔɔn‑ dhe ‑gɔ 'yënng.» ");
INSERT INTO dnj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ‑ya ‑pö 'zü mɛ gbung 'wo ‑kë mü ‑an ‑dhë: «'Sɛ 'ö ꞊nɛ ‑a 'gü, ꞊ya kë ꞊nɛ dha ꞊ya nu lan‑ ‑püö ꞊zian', 'ö 'ka to mü 'ka‑ pö dha 'dhoë‑ ban; ꞊ya kë 'ö‑ ‑de ‑kë. ");
INSERT INTO dnj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","'Ö 'ka‑ ma ꞊nɛ 'tëë ‑yö ‑piö ‑na lan‑ 'sian 'piö ꞊kwɛɛ‑ 'gü ꞊zian', 'ka‑ pö 'siö 'dhoë‑ dɔ, ꞊ya kë 'ö‑ ‑de ‑kë. ");
INSERT INTO dnj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","'Ö, mɛ 'yan ‑ta ‑wun kë ‑mɛ ‑nu! Ka ‑kɔ ‑yö ‑mɔ ‑a ‑bha 'ka ꞊duakëpë ‑nu 'wo dho kë sia‑ 'iin dhang‑ 'gü ‑an dɔ; ꞊dhɛ ꞊ya kë 'dhö, ‑më 'yö‑ ‑kë 'wun ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü bhë 'ö 'kaa‑ ‑gɛn kpinngdhö dɔ ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‑Më ‑kë ka gia‑ 'kaa 'wun 'ö kpengdhö ‑a ‑bho 'kou dɔ ꞊nɛɛ? ");
INSERT INTO dnj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","꞊Ya kë ꞊nɛ mɛ ꞊ya 'wun dɔ ü ‑bha, 'ka 'dho ‑na zakanmɛ ‑nu 'dhiö, ‑bhöë këdhɛ ꞊mɛɛ' ka ‑wo ‑yö ‑mɔ 'kuë kö ka ꞊tun zian ‑ta; ‑yö ‑kë 'dhö kö ꞊kun 'ö dho ü dɔ zakanmɛ ‑nu kwɛɛ, kö zakanmɛ ‑nu ‑de 'pö ‑waan ü dɔ 'dhasi ‑nu kwɛɛ, kö 'dhasi ‑nu ‑de 'pö ‑waan ü ‑zuö ‑kanso 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A‑ ‑pö ü ‑dhë ꞊nɛɛ: Ü'ka 'dho go ‑kanso 'kɔɔdhö ‑a 'ke ü 'ka ‑su ga 'pë 'ö to ü ‑bha bhë ‑a 'dhiö 'to nu ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","'Töng 'ö 'dhö bhë ‑a 'ka, mɛ 'bhaa ‑nu ‑wo ‑nu Yesu 'piö, 'wo‑ pö ‑a ‑dhë: «Pilatö ‑yö Galile ‑mɛ 'bhaa ‑nu ‑zë 'töng 'ö 'wo sla‑ bhoë ‑Zlan ‑dhë bhë ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Yö ‑kë ka 'gü ꞊nɛ mɛ ‑nu 'wo Galile 'wo ‑an zë bhë, ‑an ‑bha ꞊sɔɔn yaa ꞊yö ꞊va 'ö ꞊zië' Galile ‑mɛ ‑nu mɛ 'wo to bhë ‑an ‑ta, 'ö‑ ‑wun 'gü 'ö 'klobhɔdhe ꞊suu'‑ bhë 'ö nu ‑an ‑ta ‑a? ");
INSERT INTO dnj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","A‑ ‑pö ka ‑dhë: ‑Abi', 'kɛɛ ꞊ya kë ꞊nɛ kaa ka ‑bha ‑kë ‑a 'gü ‑sü ꞊dhië' ‑kwaa, ka 'plɛ ka ‑dho ga 'töüdhö ꞊nɛ ‑an 'dhö! ");
INSERT INTO dnj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'Iin ꞊dhɛ 'ka‑ ‑ga ‑a 'gü 'sengdhö bhë, mɛ ‑lü 'gɔɔ‑ do ö ga 'slɛaga 'ö böü‑ 'kplong 'ö Siloe 'ö ‑an zë 'töng 'ö ꞊loë' ‑a 'ka bhë 'wun ‑bha ‑to ‑an tuö ‑sü bhë, ‑yö ꞊gbaɔnsü 'yö ꞊zië' mɛ ‑nu mɛ 'wo to 'wo Zeluzalɛmë bhë ‑an ‑ta ‑wun ‑mü ‑a? ");
INSERT INTO dnj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A‑ ‑pö ka ‑dhë: ‑Abi', 'kɛɛ kaa ka ‑bha ‑kë ‑a 'gü ‑sü ꞊dhië' ‑kwaa, ka 'plɛ ka ‑dho ga ꞊nɛ ‑an 'dhö 'pö 'töüdhö!» ");
INSERT INTO dnj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","'Go mü, Yesu ‑yö 'wun ‑blɛɛ ‑an ‑dhë 'wun ꞊zuan' 'ka 'ö‑ pö: «Mɛ do ‑yö ö ‑bha figö ‑lü do ‑ta ö ‑bha lɛzɛn ꞊dhɛɛdhö; 'yö nu ‑kpɔɔ ‑a bhɛ ‑wun 'gü ꞊dhia, 'kɛɛ yaa‑ bhɛ gbɛ yö ‑a tuö. ");
INSERT INTO dnj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'Yö‑ pö yuö ‑kë ‑a 'gü ‑mɛ ‑dhë: ‹‑Bhö ‑dhɛ ‑ga 'dhɛ! Figö ‑lü 'ö ꞊nɛ, ꞊dhɛ 'a yö ‑kpɔɔ ‑a bhɛ ‑wun 'gü ‑sü ‑bha, ‑a ‑kwɛ kë ‑yaaga; 'kɛɛ n 'ka‑ bhɛ gbɛ yö ‑a tuö do. ‑Bhöë 'kan! ‑Më 'bhaa 'yö‑ kë ‑na ‑dhɛ 'ö dɔ ‑a ‑bha ꞊nɛ ‑a ‑bha ‑kplawo bhë ꞊ɛ?› ");
INSERT INTO dnj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","'Yö yuö ‑kë ‑a 'gü ‑mɛ ‑ya pö: ‹N ‑Gɔmɛ, ‑bhö ü ꞊kwaa' ‑a ‑zü ‑kwɛ mɛ 'ö ꞊nɛ ‑yö ziö, a ‑dho 'sɛ pɔn 'a ꞊nië ‑a 'ka ‑a ‑zü 'a 'dunng ‑lo ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","꞊Ya kë 'dhö 'ma ‑dhɛ ‑ga, ‑kwɛ mɛ 'ö 'dhoë‑ kë ꞊kwɛa, ‑yö ‑dho ö bhɛ ‑ya, 'ö ꞊ya kë ꞊nɛ yaa bha, to 'a‑ ꞊kaan.› » ");
INSERT INTO dnj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Zuifö ‑nu ‑bha ꞊glooyi do 'ka, Yesu ‑yö ‑kë mɛ ‑nu ꞊daan' ꞊dhia ‑an ‑bha ‑bhɔkuëkɔ do 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Dhebɔ do 'ö‑ 'tɔ‑ ‑siö ‑zuu yaa ꞊kwaa', 'ö‑ ‑kwɛ ꞊ya kë 'gɔɔ‑ do ö ga 'slɛaga, 'ö 'yaa ‑dɔ zɛnngdhö ‑dhɛ yö ‑yö ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","꞊Dhɛ 'ö Yesu ‑ya yö, 'yö‑ ꞊dhɔɔ ‑kë 'yö ö ‑kɔ ‑lo ‑a tuö ‑a pö ‑sü 'ka ꞊nɛɛ: «Dhebɔ, ü 'tɔsiödhɛ ꞊ya bo!» ‑Dhɛ do bhë 'wo to ‑a ‑bha, 'yö ‑po zɛnngdhö, 'yö yö 'tan ‑bho ‑Zlan 'tɔ 'piö ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Kɛɛ Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑gɔmɛ bhë, 'wun bhë yaa kë ‑a ‑dhë ‑së 'ö bhii kö Yesu ꞊ya mɛ ‑dhɛ bo 'ö‑ wo wo ‑bha ꞊glooyi 'ka bhë. 'Yö‑ pö mɛ gbung 'wo ‑kë mü bhë ‑an ‑dhë: «‑Dhɛkpaɔyi 'slado ꞊nɛ 'ö tɔɔ yuö kë ‑yi, ‑ka nu ‑a ‑bha kö ‑waan ka ‑dhɛ bo, kö ꞊kun 'ka nu ꞊glooyi 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","'Ö Dëmɛ ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «Mɛ 'yan ‑ta ‑wun kë ‑mɛ ‑nu 'ka ꞊nɛ! ꞊Glooyi 'ka, ka ka ‑bha ‑du ‑nu 'iin ꞊soofang ‑nu ‑po 'ka dho ‑an 'ka 'yi mü ꞊dhia! ");
INSERT INTO dnj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'Yö ꞊dhɛ 'ö 'dhö ꞊nɛ, ‑më ‑kë 'ö dhebɔ 'ö Ablaamö ꞊suu'‑ ‑ta ‑në 'ka 'ö Satan ‑ya ‑lö 'ö ‑kwɛ ꞊ya kë 'gɔɔ‑ do ö ga 'slɛaga ꞊nɛ, 'yaa ‑së kö 'a ꞊bhüö' 'wo ꞊löë' bhë ‑a 'po ꞊glooyi 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","‑A ‑daa 'ö Yesu ‑ya ‑kë bhë, ‑yö lë‑ ‑kpɔ ‑dɔ ‑a ‑gɔ 'yënng ‑mɛ ‑nu 'wo bhë ‑an ‑ta; 'ö mɛ gbung 'wo ‑kë mü bhë 'yö ‑an ꞊zuö' 'glu ‑yö dhi 'wun ‑sɛɛbɔ ‑nu 'ö ‑an kë bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu ‑dho 'dhiö ö bha mɛ ꞊daan' ‑sü 'ka, 'ö‑ pö: «‑Më 'ö ‑Zlan ‑bha ‑gludëdhɛ ‑yö bhɔ ‑a ‑bha ‑ɛ? 'Iin ‑më 'a dho ‑a ꞊zuan' ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","‑Yö ‑kë ꞊nɛ mutaadö 'ö bhɔ ꞊kplɔɔ' ga ‑bha, 'ö mɛ do ‑ya ‑da 'sɛidhö ö bha pë ta ‑dhiadhö ‑a 'dhö; 'yö bhɔ, 'ö ꞊kpɛa 'ö ‑ma ‑nu ‑wo wo 'kɔ dɔ ‑a ‑kɔ ‑nu ‑ta, ‑a ‑bha kë ꞊va ‑sü ‑wun 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu ‑ya ‑pö 'zü ꞊nɛɛ: «‑Më 'a dho ‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑zɔn ‑a 'ka ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A ‑dho ‑a ‑zɔn ꞊bluubhɛɛpë 'ö dhebɔ do 'dho ‑a ‑da ‑na 'bluubi 'kilong 'gɔɔ‑ ꞊plɛ ö ga 'sɔɔdhu 'piö 'ö ꞊yaa‑ 'yi bho 'ö ‑da ‑na bhë ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ‑yö ‑bɔ pödhɛ ꞊vava ‑nu waa‑ pödhɛ 'sɛɛn‑ ‑nu ‑an 'gü mɛ ‑nu ꞊daan' ‑sü 'ka, 'ö dhoë Zeluzalɛmë ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","'Yö mɛ do ‑ya ꞊dhɛɛ' kpɔ ꞊nɛɛ: «N ‑Gɔmɛ, mɛ ‑nu 'wo dho dhasü yö bhë, ‑wo 'teete ‑a?» 'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«‑Ka ka 'gü dɔ ka ‑de ‑gɔ 'gbee‑ 'ka ‑da kɔɔ 'kɔdhi 'sɔɔsɔ ‑bha, bhii a‑ ‑pö ka ‑dhë mɛdhɛvadhɛ ‑wo ‑dho ‑a kë ‑dhë ꞊mɛɛ', 'kɛɛ wo 'ka 'dho ‑mɔ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","'Kɛɛ ꞊ya kë ꞊nɛ 'kɔ dëmɛ ꞊ya ö bha 'kɔdhi ta ꞊lakele 'ka, ka ‑zë ka ‑dho to plaan 'ö 'ka yö 'kwɛɛ ‑ta ‑ma ‑sü 'gü ‑a pö ‑sü 'ka ꞊nɛɛ: ‹Yi Dëmɛ, ‑bhö 'kwɛɛ 'po yi ‑gɔ!› 'Kɛɛ ‑yö ‑dhoë pö ka ‑dhë: ‹'Maa ka dɔ!› ");
INSERT INTO dnj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","꞊Ya kë 'dhö ka ‑dho ‑a pö ‑a ‑dhë: ‹Kwa pë ‑bhö 'kwa müpë ‑nu mü kwa 'ko ꞊bhaa, 'ö 'ü yi ꞊daan ‑kpinngga ‑nu 'piö yi ‑gɔ pödhɛ ‑nu ‑bha!› ");
INSERT INTO dnj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","‑Yö ‑dhoë pö ka ‑dhë 'zü ꞊nɛɛ: ‹A‑ ‑pö ka ‑dhë 'maa ka dɔ; ‑ka bhɔ n ‑dhë ꞊taa'! 'Wunyaakëmɛ ‑nu ‑mü ka 'ka!› ");
INSERT INTO dnj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","'Ö yi 'ka dho Ablaamö 'dhö, Izaakö 'dhö, Zakɔbö 'dhö waa‑ ‑Zlan ‑wodhiölomɛ ‑nu 'töüdhö 'wo ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü ‑an yö, ka ‑zë ka ‑dho ꞊zong plaan, 'ö ‑dhɛ bhë ‑a ‑bha 'ka 'gbo ‑nu bɔ 'ka ka 'sɔn ‑nu ‑bhö mü. ");
INSERT INTO dnj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mɛ ‑nu ‑wo ‑dho go ‑dhɛ 'saadhö 'gü 'kpongtaa, 'ö 'wo ‑yadhɛ sü ‑Zlan 'piö ‑dhɛ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","‑Kaa dɔa ꞊nɛ mɛ 'bhaa ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü 'wo zlöö bhë 'wo dho kë mɛ ‑blɛɛzë 'ka, 'ö mɛ 'bhaa ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü 'wo mɛ ‑blɛɛzë 'ka bhë, 'wo dho kë ‑tozlöömɛ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","'Töng 'dhö bhë ‑a 'ka, Falizi ‑mɛ 'bhaa ‑nu ‑wo ꞊yɔɔn Yesu ‑bha, 'wo‑ pö ‑a ‑dhë: «‑Bhö 'go zö 'ü 'dho ‑dhɛ gbɛ 'gü, bhii 'ö tɔɔ Elɔdö ‑ya 'piö kö 'yö ü zë!» ");
INSERT INTO dnj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Ka 'dho 'ka‑ pö 'slëkanmɛ ‑gɔmɛ bhë ‑a ‑dhë: A ‑zuu yaa bho ‑na mɛ ‑nu 'gü, a 'wun ‑yö 'ko 'dhiö ‑sü ‑zë kë ‑na mɛ ‑nu ‑dhɛ bo ‑sü 'ka ꞊dɛɛ waa‑ ꞊dhia', 'ö‑ ‑dhɛkpaɔyi kë ‑yaaga ‑naa 'ka bhë 'a dho ma yuö 'dhiö to ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","‑Yö ‑kë ‑kɔ 'oo ‑kɔ ‑ta, a ‑dho ‑da zian ‑ta ꞊dɛɛ waa‑ ꞊dhia' 'ö dho 'ö yöë ‑dhɛkpaɔyi mɛ 'ö yö ‑a 'piö ‑a ‑bha. Bhii 'yaa ‑së kö ‑wo ‑Zlan ‑wodhiölomɛ zë ‑dhɛ gbɛ 'gü ‑a 'ke yaa kë Zeluzalɛmë plöö ‑dhɛ ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ pö: «Zeluzalɛmë ‑mɛ ‑nu, Zeluzalɛmë ‑mɛ ‑nu, ka 'ka ‑Zlan ‑wodhiölomɛ ‑nu zë, 'ka mɛ ‑nu 'ö ‑Zlan ‑yö ‑an bɔ ka ‑dhë 'ka ‑an zë ‑an ‑zuö ‑guö 'ka ‑sü 'ka ꞊nɛ, ‑a ‑gwaa ꞊ya kë ꞊plëëzë, 'ö 'ma‑ kë kö 'aan‑ ka ꞊kpaakpa 'kuë‑ ꞊nɛ ‑kɔ 'ö ‑tɔ mu 'dhö ö 'në ‑nu ꞊kpaakpa ‑na 'ka 'kuë‑ ö gban ꞊löö bhë ‑a 'dhö! 'Kɛɛ kaa 'we ‑a ‑bha! ");
INSERT INTO dnj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","꞊Dhɛ 'ö 'dhö, ‑Zlan ‑dho ö ꞊kwaa' ka ‑bha 'kɔ ‑nu ‑wun ‑zü zlöö ö 'plɛ 'ka. 'Kɛɛ ‑yö kë ka 'yaan ꞊nɛ kaa 'dho n yö gbɔ 'ö dho 'ö yöë yi 'ka ‑dho ‑a pö ‑a 'ka ꞊nɛɛ: ‹‑Zlan ‑yö 'dhuë‑ 'kpɔ mɛ 'ö 'dhoë‑ nu ‑a 'tɔ 'gü ‑a ‑bha!› » ");
INSERT INTO dnj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Zuifö ‑nu ‑bha ꞊glooyi 'ka, Yesu ‑yö ‑da Falizi ‑mɛ ‑nu ‑gɔmɛ do ‑gɔ kɔɔ kö ‑waan pë ‑bhö. Mɛ ‑nu 'wo ‑kë kɔɔ ‑an 'yan ‑yö to ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'Yö mɛ do 'ö ‑bhla ꞊yua' ‑ya ‑kë, 'yö ‑kë Yesu 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","'Ö Yesu ‑yö tɔnggɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu 'wo ‑kë mü bhë ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «Kwa ‑bha tɔng ‑ya 'piö kö 'kwa mɛ ‑dhɛ bo ꞊glooyi 'ka i, 'iin ꞊dhë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Kɛɛ ‑an 'dhi ‑yö ‑kun 'ö waa 'we ‑a ‑bha ‑waan ‑a ‑daa kë ‑a ‑gɔ. ꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö 'yuamɛ bhë ‑a ‑bha 'yua ‑bo 'ö‑ pö ‑a ‑dhë ‑yö 'dho. ");
INSERT INTO dnj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö ‑an ‑dhë: «'Ö ꞊ya kë ꞊nɛ ka ziën zö, mɛ do ‑bha 'në 'iin ‑a ‑bha ‑du ꞊ya ‑püö ‑klɔng ‑glu 'gü ꞊glooyi 'ka, yaa 'dho ‑a gan mü ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mɛ gbɛ ‑kɔ yaa ‑mɔ ‑a ‑bha kö ꞊dhɛɛ' 'yö‑ kpɔ bhë ‑yaan ‑a ‑daa kë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","꞊Dhɛ ꞊ya kë 'dhö, mɛ ‑nu ‑wo ‑nu pë ‑bhö ꞊dhia. Mɛ ‑nu 'wo ‑an ꞊dhɔɔ ‑kë 'wlaan‑ ‑ta bhë, ‑an ‑bha ‑yadhɛ ‑sɛɛbɔ 'sü ‑kɔ bhë, Yesu 'yan‑ ‑to ‑a 'piö. 'Yö‑ pö mɛ ‑nu 'wo ‑kë mü 'töüdhö bhë ‑an ‑dhë 'wun ꞊zuan' 'ka ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Mɛ ꞊ya ü ‑dhɛ dhe 'sü 'wlaan‑ ‑ta, kö ꞊kun 'ü dho 'ü ‑ya ‑yadhɛ ‑së ‑bha, bhii ꞊ya kë ꞊nɛ mɛ do 'bhaa 'ö‑ 'tɔ 'dhö ‑a ‑bha 'ö ꞊zië' ü ‑ta, ꞊waa‑ ꞊dhɔɔ kë 'pö, ꞊ya nu ");
INSERT INTO dnj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kö mɛ 'ö ka ꞊dhɔɔ ‑kë bhë ‑ya pö ü ‑dhë: ‹‑Bhö ꞊luu'‑ 'ü 'go mɛ ꞊nɛ ‑a ‑gɔ ‑gbloo 'gü, ‑yö ‑ya mü, bhi ‑zë 'dho 'ü ꞊yaannu zlöö ‑de!› ꞊Ya kë 'dhö kö lë‑ ꞊ya 'kpɔ ü ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","꞊Ya kë ꞊nɛ ꞊wa ü ꞊dhɔɔ kë 'wlaan‑ ‑ta, ‑bhö 'dho 'ü ‑ya ‑yadhɛ mɛ 'ö zlöö ‑a ‑bha. ꞊Ya kë ꞊nɛ mɛ 'ö ü ꞊dhɔɔ ‑kë bhë ꞊ya nu ꞊yaa‑ pö ü ‑dhë: ‹N 'bha, ‑bhö nu dhuö 'nö 'ü ‑ya ‑yadhɛ ‑së ‑dhɛ ‑bha!› ꞊Ya kë 'dhö ‑yö ‑dho kë ü ꞊bhlë 'kpɔ ‑wun ꞊va 'ka, mɛ ‑nu 'wo 'dhoë‑ kë ü 'piö pë ‑bhö ‑a ‑ta ꞊gba ‑ta bhë ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bhii mɛ 'oo mɛ 'ö ö ‑de ꞊luu', ‑yö ‑dho dho sia‑; 'ö mɛ 'yö 'dhoë‑ ö ‑de ꞊yɔɔn sia‑, 'ö dho ꞊luu'‑ 'dhuu.» ");
INSERT INTO dnj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","'Go mü 'ö Yesu ‑ya pö mɛ mɛ ꞊dhɔɔ ‑kë bhë ‑a ‑dhë: «'Bha mɛ ‑nu ꞊dhɔɔ kë kö 'kaan‑ pë ‑nu ‑bhö ka 'ko ꞊bhaa, kö ꞊kun 'ü ü 'bhamɛ ‑nu, ü dheglu 'në gɔɔn‑ ‑nu, mɛ ka ‑nu 'ka ‑mɛɛzë ‑nu 'iin ü dɔmɛ ꞊bhɔɔzë ‑nu gbɛ ꞊dhɔɔ ‑kë, bhii wo ‑de 'pö ‑wo ‑dho ü ꞊dhɔɔ kë 'pö; ꞊ya kë 'dhö kö 'wun ‑së 'ü‑ ‑kë bhë ꞊wa ü ‑bha ‑yɛ 'zü kë. ");
INSERT INTO dnj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'Kɛɛ ü 'dhoë‑ mɛ ꞊dhɔɔ kë ü bha 'wlaan‑ ‑ta, ‑bhö 'yenamɛ ‑nu, 'tɔsiömɛ ‑nu, 'yënngtiimɛ ‑nu ‑an ꞊dhɔɔ kë. ");
INSERT INTO dnj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ü ꞊zuö' 'glu ‑dho dhi, bhii 'ö tɔɔ waa 'dho ‑mɔ ‑a ‑bha kö ‑waan ü ‑bha ‑yɛ 'zü kë, 'kɛɛ ü ‑bha ‑yɛ 'zü ‑yö ‑dho kë yi 'ö mɛ ‑nu 'wo kpengdhö 'wo dho goë ga 'gü bhë ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","꞊Dhɛ 'ö 'wun ‑nu 'wo ꞊nɛ ꞊wa bhɔ ‑a ma ‑sü ‑bha, mɛ ‑nu 'wo ‑kë pë ‑bhö ꞊dhia bhë 'ö‑ mɛ do ‑ya pö Yesu ‑dhë: «'Gludhi ‑yö kë mɛ 'ö 'dhoë‑ ‑bhöpë ‑bhö ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü bhë ‑a ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","'Ö Yesu ‑ya pö ‑a ‑dhë: «Mɛ do ‑yö ö bha 'wlaan‑ ꞊va ‑yi ‑da 'dhuu, 'yö mɛ ‑nu ꞊dhɔɔ ‑kë ꞊va 'ka kö ‑waan nu ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","꞊Dhɛ 'ö pë ‑bhö 'töng ꞊ya ‑lo, 'yö ö bha yuökëmɛ bɔ mɛ ‑nu 'yö ‑an ꞊dhɔɔ ‑kë bhë ‑an 'piö kö ‑ya pö ‑an ‑dhë: ‹N ‑gɔmɛ ‑ya ‑pö 'ka nu, bhii pë 'plɛ 'dhiö ꞊ya ‑mɔ 'kuë!› ");
INSERT INTO dnj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","'Ö mɛ 'ö ‑dhö 'yö‑ pö ꞊nɛɛ: ‹‑A ‑bha 'gën ‑mü, n 'ka nu gbɔ.› 'Ö‑ mɛ ‑blɛɛzë ‑ya pö bɔmɛ bhë ‑a ‑dhë: ‹'Ma ma ꞊bhlöödhɛ do 'dhɔ, a ‑dho dho ‑wo mü ꞊dhia, ꞊bhɛa'‑ 'a‑ wo ‑a ‑dhë ‑yö 'dho ö 'dhiö!› ");
INSERT INTO dnj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","'Ö‑ mɛ do ‑ya pö 'zü: ‹'Ma ma ‑du 'gɔɔ‑ do 'dhɔ, a 'dho ‑na yuö kë ‑kɔ ‑ga ꞊dhia, ‑yö 'dho ö 'dhiö!› ");
INSERT INTO dnj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","'Ö mɛ do 'bhaa ‑ya pö 'zü: ‹A ‑go ma dhe 'sü ꞊dhia 'piöklöözë ꞊nɛ; ꞊dhɛ ‑kë 'dhö n 'ka 'dho nu, ‑yö 'dho ö 'dhiö!› ");
INSERT INTO dnj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","'Ö bɔmɛ ‑yö ‑yɛ ö 'zü, 'yö nu ‑a ‑yɛ 'zü 'ka ö ‑gɔmɛ ꞊dhia. 'Ö 'wun ‑yö na ‑gɔmɛ ‑zuë, 'ö‑ pö ö bha yuökëmɛ bhë ‑a ‑dhë: ‹‑Bhö 'dho 'siösiö 'dhɔɔkuëdhɛ ‑nu, plöö ‑kpinng 'piö ‑dhɛ ‑nu ‑bha, 'ü nu 'yenamɛ ‑nu, 'tɔsiömɛ ‑nu, 'yënngtiimɛ ‑nu ‑an 'ka!› ");
INSERT INTO dnj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","꞊Dhɛ 'ö 'töng 'bhe 'tee ꞊ya ziö, 'ö‑ ‑bha yuökëmɛ ‑yö nu 'yö‑ pö ‑a ‑dhë: ‹N ‑Gɔmɛ, ‑wo 'ü‑ pö bhë, ‑a 'plɛ ꞊ya kë, 'kɛɛ ‑yadhɛ 'bhaa ‑yö ꞊tun ‑dhö.› ");
INSERT INTO dnj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'Ö‑ ‑gɔmɛ ‑ya pö 'zü ö bha yuökëmɛ ‑dhë: ‹‑Bhö 'yɛ ü 'zü, 'ü 'dho zian ‑gbloo ‑nu 'piö, bhlö‑ ‑gbaa ‑nu 'gü; mɛ 'oo mɛ 'ü 'dhoë‑ ‑a yö, ‑bhö ‑gban ‑a ‑bha ꞊naazë 'ka ‑yö nu. ‑Yö ‑kë 'dhö kö ‑yadhɛ mɛ 'wo to bhë ‑waan pa. ");
INSERT INTO dnj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A‑ ‑pö ka ‑dhë: Mɛ ‑nu 'a ‑an ꞊dhɔɔ ‑kë 'dhiö bhë, ‑a mɛ gbɛ yaa 'dho ma ‑bhöpë 'ö ꞊nɛ ‑a ‑bhö gbɔ.› » ");
INSERT INTO dnj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mɛ ‑gbaa ꞊va ‑wo ‑kë ‑ziö Yesu 'piö ꞊dhia. 'Yö Yesu ‑yö ꞊dhië ö ‑zü 'yö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Mɛ 'ö nu n 'piö 'ö ꞊ya ö dë 'dhö, ö dhe 'dhö, ö bɔɔ 'dhö, ö bha 'në ‑nu 'dhö, ö dheglu 'në gɔɔn‑ ‑nu, 'nëdhoo ‑nu 'dhö, ö ‑de ‑wun gia‑ 'dhö ‑an ‑dhɔ kë ‑yaan ziö n ‑wun ‑ta, kö yaa 'dho kë ma ꞊guë' 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mɛ 'ö yaa ö bha ‑gaatalü 'sü, ‑yaan ziö n 'piö, kö yaa 'dho kë ma ꞊guë' 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bhii ꞊ya kë ꞊nɛ mɛ do ‑yö ‑dhö ka ziën, 'yö dho ö bha 'kɔ ꞊va do dɔ, ‑yö ‑dho ꞊yaannu poo ꞊kun 'yö ö ‑zo ‑ta ‑a ꞊sɔnng' ‑yö 'ko 'dhiö ‑sü 'ka; 'ö ꞊ya kë ꞊nɛ ꞊ya ‑dhɛ ‑ga ‑a 'gü 'sengdhö 'wëü‑ ꞊ya kë ‑a ‑gɔ ꞊va kö ‑yaan yuö 'ö bhë ‑a 'dhiö 'to, 'ö‑ yuö zü dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","'Yaa 'dhö ‑yö ‑dho 'kɔ zü ꞊luu'‑, 'ö‑ ‑kɔ yaa 'dho ‑mɔ ‑a ‑bha kö ‑yaan ‑a böü‑ 'kplong ꞊luu'‑. ꞊Ya kë 'dhö mɛ ‑nu ‑wo ‑dho wo 'dhi ‑sü ‑a 'gü 'wo‑ pö: ");
INSERT INTO dnj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‹꞊N n, gɔɔn‑ 'ö ꞊nɛ 'kɔ 'ö‑ zü dɔ bhë ‑a ‑kɔ yaa ‑mɔ ‑a 'dhiö 'to ‑sü ‑bha gbɔ!› ");
INSERT INTO dnj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","‑Kɔ do bhë ‑a 'ka, ‑gludë ‑yö 'dhoë‑ dho ‑glu gɔn ꞊dhia ö 'bha ‑gludë 'ka, ‑yö ꞊yaannu 'yö ö ‑zo ‑ta kö ‑yö ‑dho ‑mɔ ‑a ‑bha kö waa‑ ö bha mɛ ‑lü ‑vuu 'gɔɔ‑ do 'wo bhë ‑wo ‑dho ‑mɔ ‑a ‑bha kö 'waan‑ 'ko zë ö yaagümɛ 'ö nu ‑na ö ‑gɔ 'pö mɛ ‑lü ‑vuu 'gɔɔ‑ ꞊plɛ 'ka bhë ‑an 'ka ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Ö ꞊ya kë ꞊nɛ yaa 'dho ‑mɔ ‑a ‑bha, 'yö mɛ ‑nu bɔ ‑gludë mɛ 'ö nu ‑na ‑a ‑gɔ bhë ‑a ‑dhë kö ‑yö ꞊tun 'ma ꞊gbiin; ‑yö kë 'dhö, kö 'yö dhidhe ꞊mɛɛ'‑ ‑a 'piö.» ");
INSERT INTO dnj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'Ö Yesu ‑yö ö ‑wo ‑zuö ‑a ‑ta dhe ‑kë, 'ö‑ pö: «‑Yö 'dhö ‑kɔ do bhë ‑a 'ka 'dhö: Mɛ gbɛ yaa 'dho kë ‑dhö ka ziën ‑yaan kë ma ꞊guë' 'ka ‑a 'ke yaa ö ꞊kwaa' pë ‑nu 'ö‑ ‑wun 'dho ‑a ‑gɔ 'gbee‑ ‑a ‑wun ‑zü.» ");
INSERT INTO dnj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","'Ö Yesu ‑ya pö 'zü: «Kweezö ‑yö pë do ‑së 'ka, 'kɛɛ ꞊ya kë ꞊nɛ ‑a din ꞊ya 'go ‑a ‑bha kö ‑a këdhɛ yaa 'dho kë ‑dhö kö ‑yö kë ‑së gbɔ. ");
INSERT INTO dnj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wo 'ka 'dho ‑a ‑pɛn sia‑ 'püë‑ wo poo kö ‑yaan kë pëdhipë 'ka, 'kɛɛ ‑a ꞊zong' 'wo dho ‑a wo 'kpaan 'ka. ‑Ka ka 'to 'to, 'ö ꞊ya kë ꞊nɛ ka 'wun ma ‑to ‑yö ‑dhö kö 'kaan‑ ‑a ‑gɛn dɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","'Nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu waa‑ mɛ ‑nu 'ö ‑an 'tɔ ꞊ya ꞊siö'‑, ‑wo ‑yɔɔn Yesu ‑bha kö 'waan‑ wo 'to 'to ‑a ‑wo ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","‑Dhɛ bhë ‑a ‑bha Falizi ‑mɛ ‑nu waa‑ tɔnggɔmɛ ‑nu ‑wo 'wun ꞊blɛɛ wo ‑wo ꞊löö 'wo‑ pö: «Gɔɔn‑ 'ö ꞊nɛ ‑yö 'wunyaakëmɛ ‑nu 'yi ‑kan, 'ö wo ‑nu 'wo pë ‑bhö wo 'ko ꞊bhaa.» ");
INSERT INTO dnj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'Ö Yesu ‑yö 'wun ꞊blɛɛ ‑an ‑dhë 'wun ꞊zuan' 'ka 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Mɛ do ꞊ya kë ‑dhö ka ziën 'ö 'bhla ꞊këng' do ꞊ya kë ‑a ‑gɔ, 'ö‑ do ꞊ya ꞊dhɔng ‑an ziën, yaa 'dho ‑a 'gɔɔ‑ 'sɛisië ö ga 'sɛisië 'wo bhë ‑an to ‑an këdhɛ ‑bha ‑yaan 'dho ‑a do 'ö ꞊dhɔng bhë ‑a ꞊mɛɛ' ꞊dhia ‑yaan 'dho ‑yaan ‑a yö ꞊a? ");
INSERT INTO dnj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","꞊Ya kë ꞊nɛ ꞊yaa‑ yö, ꞊zuögludhi ‑yö ‑kë ‑a ‑gɔ, ꞊ya kë 'dhö, 'ö 'bhla bhë 'yö ‑da ö ‑gban ‑ta, ");
INSERT INTO dnj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","'yö nuë ö ‑gɔ kɔɔ, 'yö ö 'bhamɛ ‑nu, ö dɔmɛ ‑nu ꞊dhɔɔ ‑kë 'yö‑ pö ‑an ‑dhë: ‹‑Kwa ꞊zuö' 'glu ‑yö dhi, bhii 'ö tɔɔ ma 'bhla 'ö ꞊dhɔng bhë 'ma‑ yö!› ");
INSERT INTO dnj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","‑Kɔ do bhë ‑a 'ka, a‑ ‑pö ka ‑dhë: ꞊Zuögludhi ‑yö ‑dho kë dhang‑ 'gü mɛ do 'yö 'dhoë‑ go ö bha ꞊sɔɔn yaa 'gü ‑a ‑bha 'ka 'ö ‑ziö mɛ ‑lü 'gɔɔ‑ 'sɛisië ö ga 'sɛisië 'wo wo ‑de ‑sü kpengdhö 'ö 'waa wo ‑bha ‑kë ‑a 'gü ‑sü ꞊dhië' ‑Zlan 'piö bhë ‑an ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","'Ö‑ pö: «'Go mü 'zü ꞊ya kë ꞊nɛ dhebɔ do ꞊ya ö bha 'wëü‑ 'tama 'gɔɔ‑ do ꞊waannu, 'ö‑ do ꞊ya ꞊dhɔng, ‑yö ‑dho ꞊labang dɔ 'yö ‑dhɛ ‑go 'kɔbhongtodhɛ ‑nu 'plɛ ‑bha 'ö‑ ꞊mɛɛ ꞊naazë 'ka, 'yö dho 'ö‑ yö. ");
INSERT INTO dnj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","꞊Ya kë ꞊nɛ ꞊yaa‑ yö, 'yö ö 'bhamɛ ‑nu, ö dɔmɛ ‑nu ꞊dhɔɔ ‑kë 'ö‑ pö ‑an ‑dhë: ‹Kwa ꞊zuö' 'glu ‑yö dhi, bhii 'ö tɔɔ ma 'wëü‑ 'tama ga 'yö ꞊dhɔng bhë, 'ma‑ yö!› ");
INSERT INTO dnj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","‑Kɔ do bhë ‑a 'ka, a‑ ‑pö ka ‑dhë: ꞊Zuögludhi ‑yö ‑dho kë ‑Zlan ‑bha bɔmɛ ‑nu ‑gɔ, mɛ do 'kpaan 'yö 'dhoë‑ go ö bha ꞊sɔɔn yaa ‑nu 'gü bhë ‑a ‑wun 'gü!» ");
INSERT INTO dnj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","'Ö Yesu ‑ya pö 'zü ‑an ‑dhë: «Mɛ do ‑yö ‑kë ‑dhö, 'ö‑ ‑bha 'në ‑nu ꞊plɛ ‑wo ‑kë ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'Ö‑ 'teezë ‑ya pö ö dë ‑dhë: ‹N dë, pë ‑nu 'ü dho ‑a nu n ‑dhë 'dhiö ꞊zian' bhë, ‑bhö ‑an nu n ‑dhë ꞊klöödhö!› 'ö ‑an dë ‑yö pë 'ö‑ ‑bha pë 'ka bhë 'yö‑ ‑glu ö bha 'në ‑nu ‑peedë 'wo bhë ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","꞊Dhɛ 'töng pë 'bhle ꞊ya ziö, 'ö‑ 'teezë ‑yö ö bha pë ‑nu 'wo bhë 'yö ‑an 'plɛ sü, 'yö dho ‑a 'ka 'sɛgɔ ꞊gbiin gbɛ 'gü. 'Sɛ bhë ‑a 'gü 'yö ‑ya ꞊naɔ 'ö bhë ‑a 'gü ꞊siö' ‑sü ‑bha 'wun yaya ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","꞊Dhɛ pë ‑nu 'wo‑ ‑gɔ ꞊yaa‑ 'plɛ 'gü ꞊siö' 'töüdhö, 'ö din ‑yö ‑da 'sɛgɔ 'ö bhë ‑a 'gü, 'ö pë ‑wun ‑saan ‑yö yö ‑a kë ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","'Ö dho 'ö ‑da yuö 'gü 'sɛ bhë ‑a 'gü mi do 'piö, 'ö 'wo‑ bɔ ꞊bhlöö‑ kö ‑yaan ‑bhɔtii ‑nu ‑maa kë. ");
INSERT INTO dnj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","‑Ya ‑dhɔ ‑kë ‑a 'ka kö ‑bhöpë ‑nu 'wo‑ nu ‑na ‑a 'ka ‑bhɔtii ‑nu ꞊dhia bhë kö ‑waan ö ‑bha nu, 'kɛɛ mɛ gbɛ 'yaa‑ nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","꞊Dhɛ ‑kë 'dhö, 'ö ‑ya ö ‑zo 'ta ‑sü ‑bha ö ‑de kë ‑kɔ ‑wun 'gü, 'yö‑ pö ö ꞊zuö' 'piö ꞊nɛɛ: ‹‑Bhöpë ‑yö n dë ‑bha yuökëmɛ ‑nu ‑gɔ ꞊va, 'ö 'waa‑ 'plɛ ‑bhö, 'ö ma 'pö 'a 'dhoë‑ ga din ‑dhë zö 'kpaan ꞊nɛ! ");
INSERT INTO dnj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","A ‑dho dho n dë 'piö kö 'a‑ pö ‑a ‑dhë ꞊nɛɛ: N dë, 'ma ꞊sɔɔn yaa kë ‑Zlan 'ka, 'go mü, 'ma‑ kë ü 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","yaa n ‑ma 'kun gbɔ kö 'üën‑ n ‑dhɛ ü bha 'në, ‑bhö n 'sü zlöö ꞊nɛ ü bha yuökëmɛ do 'dhö!› ");
INSERT INTO dnj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","꞊Dhɛ ꞊ya ö ‑zo 'ta 'dhö, 'ö ꞊luu 'ö dho ö dë 'piö. ‑Yö ‑to ꞊gbiin, 'ö‑ dë ‑ya yö, 'ö‑ 'yena ‑yö ‑da ‑a 'gü, 'yö dho ‑a ‑gɔ zian‑ ‑bla 'ka 'ö wü ‑a ‑bha ‑a 'kpeng mü ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ gbö ‑ya pö ‑a ‑dhë: ‹N dë, 'ma ꞊sɔɔn yaa kë ‑Zlan 'ka, 'go mü 'ma‑ kë ü 'ka, yaa n ‑ma 'kun gbɔ kö 'ü n ‑dhɛ ü bha 'në!› ");
INSERT INTO dnj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'Yö‑ dë ‑ya ‑pö ö bha yuökëmɛ ‑nu ‑dhë: ‹‑Kaa kë 'siösiö 'ka nu sɔ ‑së do 'ka kö 'a‑ ‑da ‑a ‑bha, 'ka ‑vaaga do yö ‑a ‑kɔ ‑bha, 'ka ‑sakpa ‑nu yö ‑a ‑gɛn ‑bha! ");
INSERT INTO dnj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","‑Ka nu ‑du ‑gbɔng 'ö 'kwa‑ ‑to bhë ‑a 'ka, 'ka‑ zë, 'kwa 'wlaan‑ kë! ");
INSERT INTO dnj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bhii ma 'në 'ka‑ ‑ga ‑na ꞊nɛ, ‑yö ‑kë ꞊nɛ mɛ ꞊ya ga ‑a 'dhö, 'kɛɛ ꞊ya 'go ga 'gü; ‑yö ‑dhɔng 'kɛɛ 'ma‑ yö!› 'Ö ꞊zuögludhi 'wlaan‑ zü ‑yö dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","꞊Dhɛ 'wo‑ kë ‑na 'dhö kö mɛ bhë ‑a ‑bha 'në ‑blɛɛzë ‑yö ꞊bhlöö‑. ꞊Dhɛ 'yö 'go ‑na ꞊bhlöö‑, 'ö ꞊yɔɔn ‑na 'kɔ 'sɔɔ, 'ö 'tan bho ‑wo ‑nu, ꞊troo' ‑drinng ‑nu ma. ");
INSERT INTO dnj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'Ö yuökëmɛ do ꞊dhɔɔ ‑kë, 'yö‑ ꞊dhɛɛ' kpɔ pë 'wo‑ kë ‑na bhë ‑a ‑gɛn 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Ö yuökëmɛ ‑ya ‑daa ‑kë ‑a ‑gɔ ꞊nɛɛ: ‹Ü dheglu 'yö nu bhë, 'yö ü dë ‑yö ‑du 'në ‑gbɔng 'ö 'kwa‑ ‑to bhë 'yö‑ zë, 'ö tɔɔ ‑yö ö gbö ‑yö ‑potaasü 'ka.› ");
INSERT INTO dnj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","'Ö 'wun ‑yö na ‑a gbö ‑blɛɛzë ‑zuë, 'yö‑ pö ö 'ka 'dho ‑da kɔɔ. 'Ö‑ dë ‑yö yö plaan, 'yö ꞊bhɛa ‑a ‑dhë kö ‑yö nu kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'Kɛɛ ‑a gbö ‑ya ‑pö ‑a ‑dhë: ‹‑Bhö ü 'to 'to, ‑a ‑kwɛ ꞊plëëzë 'ö ꞊nɛ 'ö 'a yuö kë ‑na ü 'dhiö, 'ö ü ‑wo ‑nu 'ü‑ pö n ‑dhë 'ö n 'ka‑ gbɛ 'to, 'ö ü 'ka ‑bho 'në do gia‑ nu n ‑dhë kö yië‑ n 'bhamɛ ‑nu 'yiën‑ 'wlaan‑ kë yi 'ko ꞊bhaa ‑a 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","'kɛɛ ꞊ya kë ü gbö 'ö nu, 'ö ü bha 'kɔɔpë ‑nu 'plɛ ꞊siö ꞊sɔɔnkëdhe ‑nu ‑bha 'töüdhö bhë ‑a ‑bha 'ka, 'ü ‑du ‑gbɔng 'ö 'kwa‑ ‑to bhë 'ü‑ zë ‑a ‑dhë!› ");
INSERT INTO dnj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","'Ö‑ dë ‑ya pö ‑a ‑dhë: ‹Ma 'në, bhi 'pö ü n 'piö zö ‑kplawo, 'ö pë ‑nu 'wo n ‑ma 'ka, 'ö‑ 'plɛ 'dhö ü bha pë 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","'Kɛɛ kwa ꞊dua' ‑mü kö 'kwa ꞊zuögludhi 'wlaan‑ kë, 'go mü kwa ꞊zuö' 'glu ‑yö dhi, bhii ü dheglu 'ü‑ ‑ga ‑na 'ö ‑kë ꞊nɛ mɛ ꞊ya ga ‑a 'dhö bhë, ꞊ya 'go ga 'gü, ‑yö ‑dhɔng 'kɛɛ 'ma‑ yö!› » ");
INSERT INTO dnj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu ‑yö 'wun ‑blɛɛ 'ö ‑bha ꞊guë' ‑nu ‑dhë 'wun ꞊zuan' 'gü 'zü 'ö‑ pö: «꞊Bhɔɔmɛ do ‑bha ‑zo ‑kë ꞊naɔpë 'piö ‑mɛ do ‑yö ‑kë ‑dhö. 'Ö mɛ ‑nu ‑wo nu 'wo‑ ‑pö ꞊bhɔɔmɛ ‑dhë: ‹Ü ‑bha ‑zo ‑kë ü ‑bha ꞊naɔpë 'piö ‑mɛ 'yö bhë ‑yö ü ‑bha pë ‑nu ꞊siö' ‑na.› ");
INSERT INTO dnj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","'Yö‑ ꞊dhɔɔ ‑kë 'ö‑ pö ‑a ‑dhë: ‹‑Më ‑wun ‑nu 'a‑ ma ‑na ü 'piö ꞊nɛɛ ꞊ɛ? ‑Bhö pë ‑nu 'a‑ to ü ‑gɔ 'töüdhö bhë ‑kɔ 'ü‑ ‑kë ‑a 'ka ‑a 'kluën bho n ‑ma, bhii ü 'ka 'dho kë 'yan ‑to ma ꞊naɔpë ‑bha ‑mɛ 'ka gbɔ.› ");
INSERT INTO dnj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","'Ö ‑zo ‑kë ꞊naɔpë 'piö ‑mɛ ‑ya pö ö ‑de ꞊zuö' 'piö ꞊nɛɛ: ‹N 'gü 'yaa 'gbee‑ ꞊duö kö 'aan‑ yuö ‑nu kë ꞊bhlöödhɛ ‑nu ‑bha, 'ö pë ‑gba ‑dhɛ mɛ ‑nu ‑gɔ ‑sü dho kë n ‑dhë lëzë ꞊nɛɛ. ");
INSERT INTO dnj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Yö bhë! Pë 'a dho ‑a kë 'ö ꞊ya kë ꞊nɛ ꞊wa n bho ma ‑yadhɛ bhë ‑a ‑bha kö mɛ ‑nu ‑waan wo ‑kɔ 'kpɔ n ‑gɔ 'ma‑ yö!› ");
INSERT INTO dnj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","'Ö mɛ ‑nu 'ö‑ ‑gɔmɛ ‑bha 'pë 'dho ‑a ‑bha, 'yö ‑an ꞊dhɔɔ ‑kë do do; 'yö‑ pö ‑a mɛ ‑blɛɛzë ‑dhë: ‹N ‑gɔmɛ ‑bha ‑më 'ö 'pë 'dho ü ‑bha ‑ɛ?› ");
INSERT INTO dnj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Ö‑ pö ‑a ‑dhë: ‹'Yɔn ꞊baligo ꞊këng' do.› 'Ö ‑zo ‑kë ꞊naɔpë 'piö ‑mɛ ‑ya pö ‑a ‑dhë: ‹'Pë 'yö ü ‑bha bhë ‑a 'sëëdhɛ 'ö ꞊nɛ, ‑bhö ꞊yaannu 'siösiö 'ü 'gɔɔ‑ 'sɔɔdhu ‑ya!› ");
INSERT INTO dnj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","'Go mü 'yö‑ pö ‑a mɛ do 'bhaa ‑dhë ꞊nɛɛ: ‹Bhi ‑de 'pö, ü ‑bha ‑yö ꞊dhë ꞊ɛ?› 'Ö‑ pö ‑a ‑dhë: ‹'Blee‑ 'kaa ꞊bhɔɔ' ꞊këng' 'sɔɔdhu.› 'Ö ‑zo ‑kë ꞊naɔpë 'piö ‑mɛ ‑ya pö ‑a ‑dhë 'pö: ‹Ü bha 'pë 'ü dho ‑a bho 'ö bhë ‑a 'sëëdhɛ 'ö ꞊nɛ, ‑bhö ꞊këng' ‑yiisië ‑ya!› ");
INSERT INTO dnj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","'Ö ‑zo ‑kë ꞊naɔpë 'piö ‑mɛ 'ö ꞊flüübhömɛ 'ka bhë, ‑a ‑gɔmɛ ‑yö yö ‑a 'tɔ dhi ‑sü ‑bha ‑a ‑bha ‑kë ‑glengzë ‑sü ‑wun 'gü, bhii 'ö tɔɔ mɛ ‑nu 'waa ‑Zlan dɔ bhë, ‑wo wo ‑bha 'wun ‑nu ‑yö 'ko 'dhiö këdhɛ ‑dɔ wo 'ko ‑nu ziën 'wo ꞊zië' mɛ ‑nu 'wo ‑Zlan ‑bha 'ka ‑an ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","'Ö Yesu ‑yö ö ‑wo ‑zuö ‑a ‑ta dhe ‑kë ꞊nɛɛ: «Ma 'pö, a‑ ‑pö ka ‑dhë: ‑Ka 'bhadhɛ 'kun ꞊bhɔɔpë ‑nu 'wo 'kpongtaa zö ‑an 'ka, ‑yö ‑kë 'dhö kö yi 'ö dho yën ‑a 'ka ka ‑gɔ, kö ‑Zlan ‑yö ö ‑kɔ 'kpɔ ka ‑gɔ ꞊toëpö ‑tosiadhe këdhɛ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mɛ 'ö ‑to ö ‑wo 'gü ‑mɛ 'ka 'wun pë 'sɛɛn‑ ‑nu 'gü, ‑yö ‑to ö ‑wo 'gü 'pö 'wun ꞊vava ‑nu 'gü; 'ö mɛ 'yaa 'to ö ‑wo 'gü 'pö 'wun pë 'sɛɛn‑ ‑nu 'gü bhë, 'ö 'yaa 'to ö ‑wo 'gü 'pö 'wun ꞊vava ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","'Ö ꞊ya kë ꞊nɛ kaa kë 'kpëdhö ꞊naɔ ‑nu 'wo 'kpongtaa zö ‑a kë ‑kɔ ‑wun 'gü, dö 'yö dho ‑Zlan ‑bha ꞊naɔ ‑nu giagia 'kluën bho ka ‑bha ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Ö ꞊ya kë ꞊nɛ kaa kë 'kpëdhö mɛ gbɛ ‑bha pë ‑nu ‑wun 'gü, ‑Zlan ‑yö ‑dho pë 'ö‑ ‑ya ka ‑bha 'ka ‑a nu ka ‑dhë ‑kɔklë ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Yuökëmɛ yaa 'dho ‑mɔ ‑a ‑bha kö ‑yö yuö kë ‑gɔmɛ ꞊plɛ 'piö; ‑yö ‑dho 'yan ꞊ziö' kë ‑a mɛ do 'ka, 'ö‑ mɛ do ‑dhɔ ‑ya ‑kë; ‑yö ‑dho to ö ‑wo 'gü mɛ do ‑dhë, 'ö‑ 'yan ‑yö ‑ziö ‑a mɛ do 'gü. Mɛ gbɛ yaa 'dho ‑mɔ ‑a ‑bha kö ‑yö ‑Zlan waa‑ ꞊naɔ ‑an ‑dhɔ kpa 'kuë‑ do ö ꞊zuö' 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","꞊Dhɛ Yesu ‑wo bhë 'ö Falizi ‑mɛ ‑nu ꞊waa‑ ma, 'wo ꞊kaan ‑a ‑wo ‑bha, bhii 'ö tɔɔ ‑wo ‑kë mɛ 'dönggö ‑dönggö ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","'Ö Yesu ‑ya pö ‑an ‑dhë: «Ka mɛ ‑nu 'wo wo ‑de sü 'wun kpengdhö kë ‑mɛ 'ka ‑an 'ka mɛ ‑nu wö 'dhiö, 'kɛɛ kö ‑Zlan ‑yö ka ꞊zuögüdhɛ ‑dɔ; bhii pë 'ö mɛ ‑nu 'dho ‑a ‑ga ‑na ꞊nɛ pë ‑wun 'gbeezë 'dhö bhë, ‑Zlan ‑ya ‑san ‑zë. ");
INSERT INTO dnj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","'Töng 'ö ‑Zlan ‑yö tɔng nu ‑a 'ka Moizö ‑dhë bhë waa‑ ‑Zlan ‑wodhiölomɛ ‑nu ‑bha mɛ ꞊daan' ‑wo ‑yö ‑glɔɔ 'ö dho 'ö yöë Zan Batisö ‑bha nu ‑yi ‑bha. 'Ö sü 'töng 'ö 'dhö bhë ‑a ‑bha, 'wuntaɔsë 'yö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑wun ‑bha ‑yö ꞊blɛɛ' ‑sü 'gü; ‑a kë 'dhö ‑sü 'gü, mɛ 'ö ‑dhö ‑ya këdhɛ ꞊mɛɛ' ‑na 'gbee‑ 'ka kö ‑yö ‑da ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'ö bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","'Kɛɛ dhang‑ waa‑ 'sɛ ‑an ‑bha ziö ‑sü ‑yö ‑dho kë 'pëëpë 'ö ꞊zië' tɔng 'bin pë 'tee do ‑bha ziö ‑sü ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Gɔɔn‑ 'oo gɔɔn‑ 'ö 'dhoë‑ ö bɔɔ kë, 'go mü ‑yaan dhe gbɛ 'sü kö ꞊ya ‑da dhe 'piö; 'ö gɔɔn‑ 'ö 'dhoë‑ dhebɔ 'ö‑ ꞊gɔn ‑ya ‑kë ‑a sü ö bɔɔ 'ka kö ꞊ya ‑da dhe 'piö 'pö.» ");
INSERT INTO dnj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","'Ö‑ pö: «꞊Bhɔɔmɛ do ‑yö ‑kë ‑dhö, 'yö ꞊ya kë 'ö ö dhu sɔ ‑sɛɛbɔ 'ka. 'Ö yi 'saadhö ‑a 'ka, 'yö ‑kë ö bha 'gludhi kë ꞊dhia 'wlaan‑ kë ‑sü 'ka ‑kplawo. ");
INSERT INTO dnj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gɔɔn‑ 'yenazë do 'wo‑ ‑dhɛ Lazaa 'ö bhüö ‑yö ‑kë ‑lo ‑sü 'ka ‑a kwi ‑dhɛ 'saadhö 'gü, ‑yö ‑kë wɔ ꞊dhia 'pö ꞊bhɔɔmɛ 'ö bhë ‑a ‑gɔ 'kɔ 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","‑Bhöpë 'peepee ‑nu ꞊ya kë 'wo 'go ‑na ꞊bhɔɔmɛ ‑gɔ pë ‑bhö ‑a ‑ta ꞊gba ‑ta, 'wo ‑püö ‑na sia‑ bhë ꞊nɛ ꞊ya kë 'yö‑ ‑bhö. 'Go mü gbɛn‑ ‑nu ‑wo ‑nu 'wo‑ ‑bha bhüögüdhɛ ‑nu pa. ");
INSERT INTO dnj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","'Yenamɛ 'ö bhë ꞊dhɛ 'yö ga, ‑Zlan ‑bha bɔmɛ ‑nu ‑wa sü 'wo dho ‑a 'ka Ablaamö 'piö dhang‑ 'gü. 'Ö ꞊bhɔɔmɛ ‑de 'pö, 'yö ga 'wo‑ ‑bin. ");
INSERT INTO dnj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","꞊Bhɔɔmɛ 'klo ‑yö ‑kë bhɔ ꞊dhia ꞊glööbɔɔ, 'yö ‑dhɛ ꞊ya ‑ga dhuö ꞊zian', 'yö ‑dhɛ ‑ga 'ma ꞊gbiin, 'yö Ablaamö yö kö Lazaa ‑ya 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","'Yö ‑gbla 'gbee‑ 'ka ꞊nɛɛ: ‹N dë Ablaamö, ‑bhö n 'yena yö, 'ü Lazaa bɔ n ‑dhë kö ‑yö ö ‑kɔnëga zë 'yi 'ka ‑ya 'yɛ n nɛ‑ ‑bha kö ‑yaan n ꞊zuötadhɛ pë 'tee kë ‑saa, bhii n 'klo ‑yö bhɔ ‑sü 'gü 'siö 'gü zö yaa 'ka.› ");
INSERT INTO dnj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","'Ö Ablaamö ‑ya ‑pö ‑a ‑dhë: ‹Ma 'në, ü ‑zo ‑yö ‑büö ꞊nɛ ü ‑bha ‑kë ‑a 'gü ‑sü 'ka 'kpongtaa, ü pë ‑sɛɛbɔ ‑nu ‑yö, 'kɛɛ Lazaa ‑bha 'ka 'yena ‑yö ‑kpɔ ‑a ‑ta ꞊va; 'kɛɛ ꞊dɛɛ ‑yi 'ö ꞊nɛ 'ö tɔɔ ‑a 'yënng ꞊dhuë' ‑yi kö bhi 'pö, ü 'klo ‑yö bhɔ ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","'Go mü 'zü, 'ö ‑glu 'kpa 'dhi ꞊va 'dho kwa ziën; mɛ 'ö dho go zö ‑yaan nu ka 'piö 'yaa 'dhö, 'iin mɛ gbɛ yaa 'dho kë ‑dhö ‑yaan 'go ka 'piö 'ma ‑yaan nu ‑dhɛ 'yi‑ ‑bha 'nö ꞊nɛ ‑a ‑bha.› ");
INSERT INTO dnj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","'Ö ꞊bhɔɔmɛ ‑ya pö: ‹꞊Dhɛ 'ö 'dhö bhë, ꞊bhɛa'‑ 'a‑ wo ü ‑dhë, n dë, ‑bhö Lazaa bɔ n dë ‑gɔ kɔɔ ");
INSERT INTO dnj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","‑dhɛ 'ö n dheglu 'në gɔɔn‑ 'sɔɔdhu ‑nu 'wo‑ ‑bha bhë ‑a 'gü, kö ‑yö ‑an ‑zo ‑büö kö ꞊kun 'wo dho nu ‑dhɛ 'ö n 'klo 'dho bhɔ ‑na ‑a ‑bha ꞊nɛ ‑a ‑bha.› ");
INSERT INTO dnj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","'Ö Ablaamö ‑ya pö ‑a ‑dhë: ‹Ü dheglu 'në gɔɔn‑ ‑nu 'wo 'ma bhë, ‑Zlan ‑bha tɔng 'ö Moizö ‑ya nu waa‑ ‑Zlan ‑wodhiölomɛ ‑nu ‑bha 'sëëdhɛ ‑nu ‑wo ‑an 'piö kö ‑waan ‑an ‑zo ‑büö; ‑wo wo 'to 'to ‑an ‑wo ‑bha!› ");
INSERT INTO dnj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","'Ö ꞊bhɔɔmɛ ‑ya pö: ‹Yaa 'dho ‑mɔ, n dë Ablaamö, 'kɛɛ ꞊ya kë ꞊nɛ mɛ do ꞊ya 'go ꞊glööbɔɔ zö ꞊ya 'dho ꞊ya ‑an yö, ꞊ya kë 'dhö ‑wo ‑dho wo ‑bha ‑kë ‑a 'gü ‑sü ꞊dhië' ‑kwaa.› ");
INSERT INTO dnj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","'Kɛɛ Ablaamö ‑ya ‑pö ‑a ‑dhë: ‹'Ö ꞊ya kë ꞊nɛ waa wo 'to 'to Moizö waa‑ ‑Zlan ‑wodhiölomɛ ‑nu ‑bha 'sëëdhɛ ‑wo ‑bha, 'ö mɛ do ‑yö go ꞊glööbɔɔ 'ö dho ‑an 'piö 'dhee, waa 'dho we ‑a ‑wo ‑bha.› » ");
INSERT INTO dnj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ‑ya ‑pö ö bha ꞊guë' ‑nu ‑dhë: «Pë 'yö dho kë mɛ 'bhee‑ ‑nu ‑da ꞊sɔɔn yaa 'gü ‑pë 'ka, ‑yö ‑dho kë ‑kplawo, 'kɛɛ 'yena ‑wun ‑yö ‑dho kë mɛ 'ö dho bɔ ‑a ‑ta ‑a 'ka! ");
INSERT INTO dnj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","꞊Yö ‑së ‑a ‑bha 'ka kö ‑wo ‑guökpö ꞊va do dun ‑a bhɔ ‑bha, ‑wa ‑zuö 'yoo ꞊bhaa 'yö ꞊zië' ma mɛ ‑nu 'wo ꞊nɛ ‑a mɛ do ‑püö 'wun yaa 'gü ‑sü ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","‑Ka ka ‑zo kë ka ‑de 'piö ‑së 'ka! ꞊Ya kë ꞊nɛ ü dheglu ꞊ya 'wun yaa kë ü 'ka, ‑bhö 'wun ꞊blɛɛ'‑ ‑a ‑dhë ‑së 'ka. 'Ö ꞊ya kë ꞊nɛ ꞊ya 'gën nu ü ‑dhë, ‑bhö ziö ‑a ‑bha 'wun yaa ‑nu bhë ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Ö ꞊ya kë ꞊nɛ ꞊ya 'wun yaa kë ü 'ka ‑gwaa 'slaplɛzë ‑dhɛkpaɔyi do 'ka, 'ö go mü ‑gwaa 'slaplɛzë ꞊ya nu ꞊yaa‑ pö ü ‑dhë: ‹Ü bha 'gën ‑mü›, ‑bhö ziö ‑a ‑bha 'wun yaa ‑nu bhë ‑an ‑ta!» ");
INSERT INTO dnj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","'Ö Yesu ‑bha bɔmɛ ‑nu ‑wa pö ‑a ‑dhë: «‑Bhö yi ‑bha ‑zo ‑yö ‑Zlan ‑bha ‑sü ꞊taɔ' kë!» ");
INSERT INTO dnj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Ö Dëmɛ ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «'Kö kë ꞊nɛ ‑zo ‑yö ‑Zlan ‑bha ‑sü pë 'tee 'ö ‑kë ꞊nɛ mutaadö ga 'dhö ꞊ya kë ka ‑gɔ, ka ‑dho ‑a pö 'lü ꞊va 'ö ꞊nɛ ‑a ‑dhë: ‹'Lü ꞊va dɔ ꞊nɛ, ‑bhö wo 'ü 'dho 'ü ‑gban 'yoo ꞊bhaa!›, ‑yö ‑dho kë ka ‑wo 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","'Ö Yesu ‑ya pö 'zü ꞊nɛɛ: «꞊Ya kë ꞊nɛ ka ziën mɛ do ‑bha yuökëmɛ ꞊ya kë ‑dhö, ‑yö ‑kë ‑dhɛyamɛ 'ka o, 'iin ‑tuëmaakëmɛ 'ka o, ꞊ya kë ꞊nɛ ꞊ya 'go ꞊bhlöö‑ ꞊ya nu, ‑yö ‑dho ‑mɔ ‑a ‑bha 'yö‑ pö ‑a ‑dhë: ‹‑Bhö nu 'siösiö 'ü pë ‑bhö› ‑a? ");
INSERT INTO dnj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Kɛɛ ‑abi', ‑yö ‑dho ‑a pö ‑a ‑dhë ꞊zian' ꞊nɛɛ: ‹‑Bhö ma ‑bhöpë ‑yuö kë 'ü sɔ gbɛ 'sü 'ü‑ ‑da 'ü nu ma ‑bhöpë 'ka! ꞊Ya kë ꞊nɛ 'ma pë ‑bhö, 'ma 'yi mü 'ma yën 'üën‑ ꞊tun pë ‑bhö ‑na 'pö!› ");
INSERT INTO dnj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yaa 'dho yuö 'ö‑ nu ö bha yuökëmɛ ‑dhë 'ö‑ kë bhë ‑a zuö pö ‑a ‑wun 'gü, ꞊sua ‑mü ‑a? ");
INSERT INTO dnj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","‑Kɔ do bhë 'ö dho kaa ka ‑bha 'ka. ꞊Ya kë ꞊nɛ pë 'wo‑ pö 'ka‑ kë bhë, 'ka yën ‑a ‑bha, ‑kaa pö: ‹Yuökëmɛ 'kpaan ‑mü yi 'ka, pë yi ‑bha kö 'yiën‑ ‑a kë 'yi‑ ‑kë bhë.› » ");
INSERT INTO dnj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","꞊Dhɛ Yesu ꞊ya ‑da zian ‑ta kö ‑yö 'dhoë‑ Zeluzalɛmë, ‑yö ‑bɔ Samali ‑sɛ waa‑ Galile ‑sɛ ‑an ziën. ");
INSERT INTO dnj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","‑Yö ‑kë ‑da pödhɛ do 'gü ꞊dhia, 'ö ꞊weemɛ 'gɔɔ‑ do ‑wo dɔ ꞊gbiin 'wo‑ yö, ");
INSERT INTO dnj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","'wo yö 'gbla ‑sü 'gü ꞊nɛɛ: «Yesu, yi ‑Gɔmɛ, ‑bhö yi 'yena yö ꞊ee!» ");
INSERT INTO dnj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka 'dho 'ka ka ‑de ‑zɔn slabhomɛ ‑nu ‑dhë!» ꞊Dhɛ 'wo 'dho ‑na, 'ö ‑an 'plɛ ‑dhɛ ‑yö bo zian‑. ");
INSERT INTO dnj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","꞊Dhɛ 'ö‑ mɛ do ꞊yaa‑ yö ꞊nɛ ö ‑dhɛ ꞊ya bo, 'yö ‑yɛ ö 'zü 'ö nu ‑Zlan zuö pö ‑sü 'ka ö ‑wo ‑ta dhuö 'gbee‑ 'ka, ");
INSERT INTO dnj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","'yö‑ ‑püö Yesu ꞊gɛɛndhö 'yö ‑gblü 'sɛi ‑a zuö pö ‑sü 'ka. Mɛ 'ö 'dhö bhë ‑yö ‑kë Samali mi 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","'Ö Yesu ‑ya pö mɛ ‑nu 'wo ‑kë mü ‑an ‑dhë: «Mɛ 'gɔɔ‑ do 'wo bhë ‑an 'plɛ ‑dhɛ ‑yö ‑bo ‑kɛ, 'kɛɛ ‑a mɛ 'sɛisië 'wo to bhë, ‑wo më ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","‑A mɛ gbɛ ‑zo yaa ‑büö giawo ‑yaan 'yɛ ö 'zü yaa nu ‑yaan ‑Zlan zuö pö ‑a 'ke yaa kë ‑niagɔɔn 'ö ꞊nɛ ‑a 'ka a?» ");
INSERT INTO dnj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö ꞊luu'‑ 'ü 'dho, ü ‑bha ‑zo ‑yö n ‑ma ‑sü ꞊ya ü ‑dhɛ bo!» ");
INSERT INTO dnj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Falizi ‑mɛ ‑nu ‑wo Yesu ꞊dhɛɛ' ‑kpɔ 'wo‑ pö: «‑Zlan ‑bha ‑gludëdhɛ ‑yö ‑dho nu yi ‑mlë 'ka ɛ?» 'Yö‑ pö ‑an ‑dhë: «‑Zlan ‑bha ‑gludëdhɛ ‑bha nu ‑sü bhë 'yan ‑dɔ ‑a ‑bha ‑pë 'yaa ‑mü. ");
INSERT INTO dnj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Waa 'dhoë‑ pö: ‹‑Ka ‑dhɛ ‑ga, ‑yö zö!› 'iin ‹‑yö ‑dhɛ 'ö ‑de ‑a 'gü!›, bhii ‑kaa ꞊dɔa' ꞊nɛ ‑Zlan ‑bha ‑gludëdhɛ ‑yö ka ziën.» ");
INSERT INTO dnj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: «Yi do ‑yö nu ‑na 'ö 'ka dho ‑a ‑dhɔ kë kö ma 'a Mɛgbö 'ka, 'ka ka 'yan dɔ n ‑ma 'zü ‑dëüwo, 'kɛɛ ka 'ka 'dho n yö. ");
INSERT INTO dnj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","‑Wo ‑dho ‑a pö ka ‑dhë: ‹‑Ka ‑dhɛ ‑ga, ‑yö zö!› 'iin: ‹‑ka ‑dhɛ ‑ga, ‑yö ‑de!›, 'kɛɛ kö ꞊kun 'ka 'dho, kö ꞊kun 'ka ziö ‑an 'piö! ");
INSERT INTO dnj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","‑Kɔ 'ö dha 'dhö 'yan bhɔ ‑na ‑a 'ka, 'ö‑ 'bhü 'dho yö ‑na dhang‑ ‑dhɛ 'saadhö 'gü bhë, ‑kɔ do bhë 'ö ma 'a Mɛgbö 'ka 'ö n nu ‑sü dho kaa. ");
INSERT INTO dnj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","'Kɛɛ 'dhiö ꞊kun ‑yö n ‑ma kö n 'yënng ‑yö bhɔ ꞊va; mɛ ‑nu 'wo ꞊dɛɛ ꞊nɛ ‑a 'gü ‑wo ‑dho n ‑zuö wo ‑kɔ 'yan ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Pë 'ö ‑kë Noe ‑bha 'töng 'ka bhë, 'ö dho kë ma 'a Mɛgbö 'ka n nu ‑yi 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mɛ ‑nu ‑wo ‑kë pë ‑bhö ꞊dhia, müpë ‑nu mü ꞊dhia, dhe ‑nu 'sü ꞊dhia, 'go mü 'wo ‑kë wo ‑bha 'nëdhoo ‑nu ‑dɔ gwaan ꞊dhia, 'ö dho 'ö yöë Noe ‑bha ‑da 'yitagɔ ꞊va 'gü ‑yi ‑bha; 'ö ꞊dhɛ 'yi pa ‑sü ꞊ya nu, 'ö ‑an 'plɛ 'gü ‑yö ꞊siö. ");
INSERT INTO dnj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","‑Yö ‑dho kë 'zü ꞊nɛ Lɔtö ‑bha 'töng 'dhö: Mɛ ‑nu ‑wo ‑kë pë ‑bhö ꞊dhia, 'yi mü ꞊dhia, pë ‑nu 'dhɔ ꞊dhia, pë ‑nu 'dhɔɔ dɔ ꞊dhia, pë ‑nu ta ꞊dhia, 'iin 'kɔ ‑nu dɔ ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","'Kɛɛ yi 'ö Lɔtö ‑yö go ‑a 'ka Sodɔmë, 'siö waa‑ blɔɔn ‑wo ‑go dhang‑ 'gü 'wo ‑lo ‑an ‑ta ꞊nɛ dha ‑bha ban ‑sü 'dhö, 'ö ‑an 'plɛ 'gü‑ ꞊siö. ");
INSERT INTO dnj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","‑Kɔ do bhë 'yö dho kaa ma 'a Mɛgbö 'ka, ma nu ‑yi 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‑A yi 'dhö bhë ‑a 'ka, mɛ 'ö 'dhoë‑ kë ö ‑gɔ 'kɔ tuö, yaa 'dho ꞊yɔɔ'‑ ‑yaan 'dho kɔɔ ö bha pë ‑nu 'sü ꞊dhia. ‑Kɔ do bhë ‑a 'ka 'ö mɛ 'ö 'dhoë‑ kë ö ‑gɔ ꞊bhlöö‑ bhë, yaa 'dho yɛ ö 'zü ‑yaan nu ö ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ka ‑zo ‑yö ‑büö Lɔtö bɔɔ ‑wun 'ka! ");
INSERT INTO dnj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mɛ‑ 'piö kö ‑yö ö ‑de dha, yö 'ka 'dho ‑mɔ ‑a ‑bha; 'kɛɛ mɛ 'ö dhoë ö ꞊kwaa' ö ‑bha ‑tosiadhe ‑zü, ‑yö ‑dho ‑a yö. ");
INSERT INTO dnj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'Ö 'a‑ ꞊blɛɛ ka ‑dhë ꞊nɛɛ: ‑A gbeng 'ö 'dhö bhë ‑a 'ka, mɛ ꞊plɛ ‑wo ‑dho kë ꞊sɛɛ' do ‑ta, ‑a mɛ do ‑yö ‑dho sü 'ö‑ mɛ do ‑yö to. ");
INSERT INTO dnj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dhebɔ ꞊plɛ ‑wo ‑dho kë pë zɔn ‑dhiadhö, ‑a mɛ do ‑yö ‑dho sü 'ö‑ mɛ do ‑yö to. ");
INSERT INTO dnj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Gɔɔn‑ ‑nu ꞊plɛ ‑wo ‑dho kë ꞊bhlöö‑, ‑a mɛ do ‑yö ‑dho sü, 'ö‑ mɛ do ‑yö to.» ");
INSERT INTO dnj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'Ö‑ ‑bha ꞊guë' ‑nu ‑wa pö ‑a ‑dhë: «Yi Dëmɛ, ‑dhɛ ‑mlë 'ö pë ‑nu 'wo ꞊nɛ 'wo dho kë ‑a ‑bha ‑ɛ?» 'Ö‑ ‑daa ‑kë ‑an ‑gɔ 'ö ‑pö: «‑Dhɛ 'ö pë ꞊glöö 'dhoë‑ kë ‑a ‑bha bhë, 'ö 'gblübhaa ‑nu dho dho wo 'kuë‑ ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö 'wundankuëdhe do ‑kë ‑an ‑dhë 'wun ꞊zuan' 'ka, ‑yö kë 'dhö kö ‑wo ꞊bhɛa' ‑sü ‑wun 'kun 'gbee‑ 'iin kö ꞊kun 'ö ‑an 'gü ‑yö ga; 'ö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«Pödhɛ do 'gü, mɛ do 'ö ‑kë zakanmɛ 'ka 'ö 'yaa kë 'suö ꞊dhia ‑Zlan ‑dhë 'iin 'yaa kë mɛ gbɛ ꞊bhlë ‑ya ꞊dhia, ‑yö ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","'Ö pödhɛ bhë ‑a 'gü, ꞊gɛandhe do ‑yö ‑kë mü 'pö. 'Ö ꞊ya kë 'yö nu ‑a 'piö ‑kplawo kö ‑yaan ö bha za 'kan 'ö‑ pö ‑a ‑dhë: ‹A‑ 'piö 'ü za 'kan yië‑ n yaagümɛ ‑nu yi ziën.› ");
INSERT INTO dnj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","'Ö‑ wo 'dhö ‑kplawo, 'kɛɛ zakanmɛ 'ö bhë 'yaa‑ ‑daa kë ‑a ‑gɔ 'gbɛɛdhö; 'yö ꞊dhɛ 'ö yö mü 'ö zakanmɛ bhë 'yö‑ pö ö ꞊zuö' 'piö ꞊nɛɛ: ‹'Wun gia‑ 'ka, 'maa 'suö ‑Zlan ‑dhë 'iin 'maa mɛ gbɛ ꞊bhlë ‑ya, ");
INSERT INTO dnj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","'kɛɛ ꞊dhɛ ‑kë ꞊nɛ ꞊gɛandhe 'ö ꞊nɛ ‑yö n 'piö kë ‑na ‑kplawo ꞊nɛ, a ‑dho ‑a ‑bha za 'ö ꞊nɛ ‑a kan, 'yaa 'dhö ‑yö ‑dho nu 'dhö ‑kplawo 'ö n ‑kë 'muamua.› » ");
INSERT INTO dnj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","'Ö Dëmɛ ‑ya pö 'zü ꞊nɛɛ: «'Wun 'ö zakanmɛ yaa ‑ya ꞊blɛɛ bhë ka‑ ‑ma! ");
INSERT INTO dnj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","꞊Dhɛ ꞊ya kë 'dhö, mɛ ‑nu 'ö ‑Zlan ‑yö ‑an ‑ya ö ‑bha 'ka, ꞊wa 'we ‑a 'piö ‑kplawo bhë, yaa 'dho ‑an ‑bha pë ‑nu kë ‑an ‑dhë ꞊nɛ ‑kɔ 'ö‑ 'ka kpengdhö ‑a 'dhö ‑a? ‑Yö ‑dho ‑an ‑wo bho ö 'tou ‑kplawo ꞊a? ");
INSERT INTO dnj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A‑ ‑blɛɛ ka ‑dhë ꞊nɛɛ: ‑Abi', ‑yö ‑dho ‑an ‑bha 'wun ‑nu kë kpengdhö ‑an ‑dhë 'zodhö. 'Kɛɛ ma 'a Mɛgbö 'ka, n nu ‑yi 'ka, a ‑dho ‑zo ‑yö n ‑ma ‑sü gia‑ do yö 'kpongtaa 'gbödhö ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mɛ ‑nu 'wo ‑kë mü bhë, ‑an mɛ 'bhaa ‑nu 'wo wo ‑de yö kpengdhö ‑Zlan wö 'dhiö, 'wo ꞊zië' mɛ ‑nu 'wo to ‑an ‑ta ‑wo ‑kë ‑an ziën mü 'pö, 'wo yö ‑an ‑san zë ‑sü ‑bha. 'Ö Yesu ‑yö 'wun ‑gban ‑an ‑bha, ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Mɛ ꞊plɛ ‑wo ‑kë ‑Zlan ‑gɔ kɔɔ ꞊bhɛa' ꞊dhia. ‑A mɛ do ‑yö ‑kë Falizi ‑mɛ 'ka, 'ö‑ mɛ do ‑yö ‑kë 'nii‑ ꞊sɔnng' 'kun ‑mɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falizi ‑mɛ ‑yö ‑dɔ ‑gɛan, 'ö ꞊bhɛa ö ꞊zuö' 'piö ꞊nɛɛ: ‹Oo ‑Zlan, a ü zuö ‑pö, kë n 'ka‑ wo ꞊nɛ mɛ ‑nu 'wo to 'wo ‑kë ꞊kwaanmɛ ‑nu, mɛ këwunyaazë ‑nu, 'iin ‑dadhepiömɛ ‑nu ‑an 'dhö bhë ‑a ‑wun 'gü. A ü zuö ‑pö 'zü, kë n 'ka‑ wo ꞊nɛ 'nii‑ ꞊sɔnng' 'kun ‑mɛ 'ö ꞊nɛ ‑a 'dhö bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","A n ‑bɛn ‑to ‑dhɛkpaɔyi ꞊plɛ 'ka 'dhɔɔgɔ do 'gü, 'go mü pë ‑nu 'wo n ‑ma 'ka 'a‑ kë 'gɔɔ‑ do ‑naa ‑nu ü ‑dhë.› ");
INSERT INTO dnj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'Ö 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑de 'pö 'yö dɔ zian gbɛ 'ka, 'yaa ö wö ꞊luu'‑ ‑dewo dhang‑ 'gü, 'yö ö ‑tong ‑ta ‑ma 'ö ‑pö: ‹Oo ‑Zlan, ma 'pö a 'wunyaakëmɛ 'ka, ‑bhö n 'yena yö!› » ");
INSERT INTO dnj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Ö Yesu ‑yö ö ‑wo ‑zuöatadhe ‑kë ꞊nɛɛ: «A‑ ‑pö ka ‑dhë: Mɛ 'ö bhë ‑Zlan ‑yö ‑ziö ‑a ‑bha këwun yaa ‑nu ‑ta ‑yaan ꞊tun 'dho ‑na ö ‑gɔ kɔɔ, 'kɛɛ Falizi ‑mɛ ‑bha 'ka, ‑a ‑bha këwun ‑yö ‑to ‑a ‑bha. Bhii 'ö tɔɔ mɛ 'yö ö ‑de ꞊luu'‑, ‑a ‑gɔ ‑yö ‑dho dho sia‑, 'ö mɛ 'yö ö ‑de 'dho sia‑, 'ö‑ ‑gɔ dho ꞊luu'‑.» ");
INSERT INTO dnj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mɛ ‑nu ‑wo ‑nu 'në 'sɛɛn‑ ‑nu 'ka Yesu ꞊dhia kö ‑yaan 'dhuë‑ 'kpɔ ‑an ‑bha. ꞊Dhɛ Yesu ‑bha ꞊guë' ‑nu ꞊wa ‑an yö, 'wo yö 'wun ‑blɛɛ ‑an 'ka ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'Ö Yesu ‑ya ‑pö ö bha ꞊guë' ‑nu ‑dhë: «‑Ka ka ꞊kwaa' ‑an ‑zü, ‑wo nu n 'piö! Kö ꞊kun 'ka ‑an ‑kë! Bhii 'ö tɔɔ mɛ ‑nu 'wo wo ‑de ‑kë 'tee ꞊nɛ 'në 'sɛɛn‑ ‑nu 'wo ꞊nɛ ‑an 'dhö, ‑wo ‑dho ‑da ‑Zlan ‑bha ‑gludëdhɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: Mɛ 'ö yaa 'we ‑Zlan ‑wun ‑bha ö ‑de ‑kë 'tee ‑sü 'ka ꞊nɛ 'në 'sɛɛn‑ ‑nu 'wo ꞊nɛ ‑an 'dhö, yaa 'dho ‑da ‑Zlan ‑bha ‑gludëdhɛ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Zuifö ‑nu ꞊kɔɔnmɛ do ‑yö Yesu ꞊dhɛɛ' ‑kpɔ 'ö‑ pö: «N ‑Gɔmɛ këwunsëëzë, a ‑dho ‑a kë ꞊dhë kö 'a ꞊toëpö ‑kë ‑a 'gü ‑sü yö ꞊e?» ");
INSERT INTO dnj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Më 'yö ‑kë 'ü n ‑dhɛ këwun ‑së ‑mɛ ‑ɛ? Mɛ gbɛ këwun 'yaa ‑së ‑a 'ke yaa kë ‑Zlan dosɛn 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tɔng ‑nu 'wo ꞊bɛɛn' ‑sü 'ka 'wo ꞊nɛ: Kö ꞊kun 'ü ‑da dhe 'piö; kö ꞊kun 'ü mɛ gbɛ ‑bha gɔɔn‑ ꞊mɛɛ; kö ꞊kun 'ü mɛ zë; kö ꞊kun 'ü ꞊kwaan; kö ꞊kun 'ü ꞊sua ‑kë mɛ gbɛ ‑gɔ; ‑bhö ü dë waa‑ ü dhe ‑an ꞊bhlë 'kpɔ, ü ‑an ‑dɔ ‑a?» ");
INSERT INTO dnj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","'Ö gɔɔn‑ bhë 'ö‑ ‑daa ‑kë 'ö‑ pö: «Tɔng ‑nu 'wo bhë 'ö sü n 'tee 'gü ‑bha a ‑an 'plɛ ‑kun.» ");
INSERT INTO dnj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","'Ö Yesu ‑ya pö ‑a ‑dhë ꞊nɛɛ: «Pë do 'bhaa ‑wun ‑yö ꞊tun ü ‑bha: ‑Bhö ü ‑gɔ pë ‑nu 'plɛ 'dhɔɔ dɔ 'ü‑ 'wëü‑ ‑nu bhë 'ü‑ ‑glu 'fɛɛmɛ ‑nu 'ka; 'go mü 'ü nu 'ü ziö n 'piö! ꞊Ya kë 'dhö ü ‑dho ꞊bhɔɔpë ‑nu yö dhang‑ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","'Kɛɛ gɔɔn‑ 'ö bhë, ꞊dhɛ ‑wo 'ö ꞊nɛ ꞊yaa‑ ma, 'ö‑ wö ‑yö ꞊siö, bhii 'ö tɔɔ ‑yö ‑kë ꞊bhɔɔmɛ ꞊va 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","꞊Dhɛ 'ö Yesu ꞊yaa‑ yö ꞊nɛ gɔɔn‑ 'ö bhë ‑a wöödhɛ ꞊ya ꞊siö'‑, 'yö‑ pö: «‑Yö 'gbee‑ ꞊bhɔɔmɛ ‑nu ‑bha 'ka kö ‑waan ‑da ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","‑Yö 'pëëpë ‑yɔɔnmia ‑bha 'ka kö ‑yaan bɔ miiga 'dhi 'gü 'ö ꞊zië' ꞊bhɔɔmɛ ‑bha ‑da ‑Zlan ‑bha ‑gludëdhɛ 'gü ‑sü ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","'Yö mɛ ‑nu 'wo ‑kë wo 'to 'to ꞊dhia bhë 'wo‑ pö: «꞊Ya kë 'dhö kö dö 'yö dho dha ‑a 'gü 'sa?» ");
INSERT INTO dnj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu ‑ya ‑daa ‑kë 'ö‑ pö: «Pë 'ö mɛ ‑kɔ yaa ‑mɔ ‑a ‑bha bhë, ‑Zlan ‑kɔ ‑yö ‑mɔa.» ");
INSERT INTO dnj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","'Ö Piɛɛ ‑ya pö ꞊nɛɛ: «‑Dhɛ ‑ga, yi yi ‑bha pë ‑nu 'plɛ ‑to 'yi ziö ü 'piö!» ");
INSERT INTO dnj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","'Ö Yesu ‑ya pö ‑an ‑dhë ꞊nɛɛ: «A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: Mɛ ꞊ya ö bha 'kɔ 'dhö 'iin ö bha dhebɔ, ö 'zlaa‑ ‑nu, ö ‑mɛ ‑nu, ö bha 'në ‑nu 'to ‑Zlan ‑bha ‑gludëdhɛ ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","‑yö ‑dho ‑a ꞊truën ꞊va yö 'töng 'ö ꞊nɛ ‑a 'gü, 'go mü 'yö dho ꞊toëpö ‑kë ‑a 'gü ‑sü yö ‑dhɛ ꞊kpaɔ ꞊dhia' ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ‑yö ö bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an ‑sü ö 'piö 'ö‑ pö ‑an ‑dhë: «Kwa ‑da ‑sü ‑mü Zeluzalɛmë kö pë 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑wa ꞊bɛɛn ma 'a Mɛgbö 'ka n ‑wun 'gü bhë, ‑a 'dhiö ‑yaan ‑mɔ 'kuë. ");
INSERT INTO dnj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","‑Wo ‑dho n dɔ mɛ ‑nu 'waa ‑Zlan dɔ ‑an kwɛɛ, 'wo 'yee to n ‑ma, 'wo 'si bho n ‑gɔ, 'wo wo 'dhee ‑nu bho n ‑ma, ");
INSERT INTO dnj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","‑wo ‑dho n ‑ma ‑klaa 'ka, 'go mü 'wo n zë; 'ö‑ ‑dhɛkpaɔyi kë ‑yaaga ‑naa bhë 'a go ‑a 'ka ga 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","'Kɛɛ ‑a ‑bha ꞊guë' ‑nu waa‑ ‑gɛn gia‑ dɔ; bhii ‑yö ‑kë ‑bin ‑sü 'ka ‑an ‑gɔ, 'go mü 'ö 'wun 'ö Yesu ‑ya ꞊blɛɛ bhë waa‑ ‑gɛn 'zü dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","‑Wo ‑kë ꞊yɔɔn ꞊dhia Zeliko ‑dhɛ 'sɔɔ. 'Yënngtiimɛ do 'ö ‑kë ‑gba ‑dhɛ mɛ ‑nu ‑gɔ ꞊dhia, ‑yö ‑kë ꞊yaannu ꞊dhia zian 'sɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","꞊Dhɛ 'ö mɛ ‑gbaa ‑nu 'dho ziö ‑na, 'yö ‑an ꞊dhɛɛ' kpɔ ‑an ziö ‑gɛn 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","'Wo‑ pö ‑a ‑dhë: «Yesu 'go Nazalɛtë ꞊nɛ 'ö nu ‑na bhë.» ");
INSERT INTO dnj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Yö ‑gbla 'gbee‑ 'ka ꞊nɛɛ: «Yesu Davidö gbö, ‑bhö n 'yena yö ꞊ee!» ");
INSERT INTO dnj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","'Ö mɛ ‑nu 'wo ‑kë 'ta ꞊dhia Yesu 'dhiö bhë 'wo 'wun ꞊blɛɛ ‑a 'ka ‑a pö ‑sü 'ka‑ ‑dhë ‑yö ö 'dhi yö 'kuë‑, 'kɛɛ ‑yö ‑gbla 'zü 'gbee‑ 'ka ꞊nɛɛ: «Davidö gbö, ‑bhö n 'yena yö ꞊ee!» ");
INSERT INTO dnj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","'Ö Yesu ‑yö ꞊gbaannu 'ö‑ ‑pö ‑an ‑dhë ‑wo nu ‑a 'ka ö ꞊dhia. ꞊Dhɛ 'ö 'yënngtiimɛ 'ö bhë ꞊ya nu ‑a 'sɔɔ, 'ö Yesu ‑ya ꞊dhɛɛ' kpɔ 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«‑Më 'ü‑ 'piö kö 'a‑ kë ü ‑dhë ‑ɛ?» 'Ö 'yënngtiimɛ ‑ya pö ‑a ‑dhë: «N Dëmɛ, a‑ 'piö kö n 'yan ‑yö ‑dhɛ yö 'zü ‑dëüwo.» ");
INSERT INTO dnj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü 'yan 'dhi ‑yö 'po! Ü ‑bha ‑zo ‑yö n ‑ma ‑sü ꞊ya ü ‑dhɛ bo!» ");
INSERT INTO dnj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","‑Dhɛ do bhë ‑a 'gü, 'ö‑ 'yan ‑yö ‑po, 'ö ‑dhɛ yö, 'yö ‑ziö Yesu 'piö ‑Zlan 'tɔ kë ꞊va ‑sü 'ka. ꞊Dhɛ 'ö mɛ ‑gbaa ‑nu ‑de 'pö 'wun 'ö ꞊nɛ ꞊waa‑ yö, 'wo yö ‑Zlan zuö pö ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","꞊Dhɛ 'ö Yesu ꞊ya ‑da Zeliko plöö, ‑yö ‑kë ziö ‑sü 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","gɔɔn‑ ꞊bhɔɔzë do 'wo‑ ‑dhɛ Zase 'yö ‑kë 'nii‑ ꞊sɔnng' 'kun ‑mɛ ‑nu ‑gɔmɛ 'ka bhë 'yö ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'Yö‑ këdhɛ ꞊mɛɛ kö mɛ 'ö Yesu 'ka 'yaan‑ ‑a dɔ. 'Kɛɛ ꞊dhɛ 'ö kë ꞊nɛ ‑yö ‑kë ꞊klöö', yaa 'dho Yesu yö mɛ ‑gbaa ‑nu 'wo bhë ‑an ‑dhë bhë, ");
INSERT INTO dnj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","'Ö ‑bla sü 'ö dho ‑an 'dhiö 'ö ‑da 'lü do tuö, kö ꞊ya kë ꞊nɛ Yesu ‑yö ziö ‑na ‑dhɛ bhë ‑a ‑bha kö 'yaan‑ ‑a yö. ");
INSERT INTO dnj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","꞊Dhɛ Yesu ꞊ya ‑lo ‑dhɛ bhë ‑a ꞊tɛi' 'ka, 'yö ö 'yan ꞊luu 'ö‑ pö Zase ‑dhë: «‑Bhö ꞊yɔɔ'‑ 'siösiö, Zase, ꞊dɛɛ tɔɔ ꞊dɛɛ, a ‑dho dho ü ‑gɔ kɔɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'Ö Zase ‑yö ꞊yɔɔ ‑bla 'ka, 'yö‑ ‑nia kun ꞊zuögludhi 'ka ö ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mɛ ‑nu 'wo ‑kë mü ‑wo 'wun ‑blɛɛ wo ‑wo ꞊löö 'wo‑ pö: «Gɔɔn‑ 'ö ꞊nɛ ꞊ya 'dho ꞊ya wɔ 'wunyaakëmɛ ‑gɔ kɔɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'Ö Zase ‑yö ꞊luu 'ö‑ pö Dëmɛ ‑dhë: «N ‑Gɔmɛ, ‑bhö ü 'to 'to 'dhɛ! A ‑dho ma pë ‑nu 'wo n ‑gɔ, ‑a ‑kɔ 'pian do nu 'fɛɛmɛ ‑nu ‑dhë, 'go mü 'ö ꞊ya kë ꞊nɛ mɛ ‑yö ‑dhö 'a pë kun ‑a ‑gɔ ꞊flüü 'ka, 'a dho ‑a ‑bha ‑yɛ 'zü kë ‑gwaa ‑yiisië ‑zë.» ");
INSERT INTO dnj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","'Ö Yesu ‑ya pö ‑a ‑dhë: «Dha ‑sü ꞊ya ‑da ü ‑gɔ kɔɔ ꞊dɛɛ bhii 'ö tɔɔ ü Ablaamö ꞊suu'‑ ‑ta ‑mɛ do 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bhii ma 'a Mɛgbö 'ka, a ‑nu mɛ ‑nu 'ö ‑an nii ꞊ya dɔ 'gü ꞊siö' ‑zian ‑ta ‑an ꞊mɛɛ' ꞊dhia kö 'a ‑an dha.» ");
INSERT INTO dnj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesu ‑yö 'wun ‑blɛɛ 'wun ꞊zuan' 'ka mɛ ‑nu 'wo go 'wun 'ö‑ ꞊blɛɛ bhë ‑a ma ꞊dhia bhë ‑an ‑dhë. ꞊Dhɛ 'ö ‑kë ꞊nɛ kö ꞊ya ꞊yɔɔn Zeluzalɛmë ‑dhɛ 'sɔɔ bhë, ‑yö ‑kë ‑an ‑zo 'piö ꞊nɛ ‑Zlan ‑bha ‑gludëdhɛ ‑dhö to mü 'ö ‑lo wo ‑ta ꞊klöödhö. ");
INSERT INTO dnj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'Kɛɛ pë 'yö‑ pö ꞊ga ꞊nɛ: «‑Gludë ꞊suu'‑ ‑ta do 'gü ‑mɛ ‑yö ‑dho 'sɛ do ꞊gbiin 'gü kö ‑waan ‑a kë ‑gludë 'ka. ꞊Ya kë 'dhö kö ‑yaan 'yɛ ö ‑zü ‑yaan nu ö ‑gɔ 'sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","‑A kë ‑sü 'ka kö ‑yaan 'dho, ‑yö ö bha yuökëmɛ ‑nu 'gɔɔ‑ do ꞊dhɔɔ ‑kë, 'yö mɛ 'ö ‑dhö 'ö 'sënng 'wëü‑ 'tama ga do do nu ‑a ‑dhë ‑a ‑pö ‑an ‑dhë ‑sü 'ka ꞊nɛɛ: ‹‑Ka pë ‑nu 'dhɔ 'ka ‑an 'dhɔɔ dɔ 'wëü‑ 'a‑ nu ka ‑dhë bhë ‑a 'ka ‑yö 'dho ‑yö yöë n nu ‑yi ‑bha!› ");
INSERT INTO dnj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","'Kɛɛ ‑a ‑bha 'sɛgümɛ ‑nu ‑wa ‑san ‑zë, 'ö 'wo wo ‑bha bɔmɛ ‑nu bɔ ‑a 'piö kö ‑waan ‑a pö ‑a ‑dhë ꞊nɛɛ 'waa‑ 'piö kö ‑yö kë ‑gludë 'ka wo ‑gɔ 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","꞊Dhɛ 'ö ꞊ya 'yɛ ö 'zü ꞊ya nu kö ꞊waa‑ ‑ya ‑gludë 'ka ö ‑gɔ 'sɛ 'gü, 'yö ö bha yuökëmɛ ‑nu 'ö 'wëü‑ nu ‑an ‑dhë bhë ‑an ꞊dhɔɔ ‑kë kö mɛ 'ö ‑dhö pë 'yö‑ yö ‑yaan ‑a ‑zɔn. ");
INSERT INTO dnj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","'Ö mɛ ‑blɛɛzë ‑yö nu 'ö‑ pö: ‹N ‑Gɔmɛ, 'sënng 'tama 'gɔɔ‑ do 'a‑ yö, ‑a mɛ 'ü‑ nu n ‑dhë bhë ‑a ‑yö ‑a 'piö 'ka.› ");
INSERT INTO dnj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'Ö ‑gludë ‑ya pö ‑a ‑dhë: ‹꞊Yö ‑së, ma yuökëmɛ këwunsëëzë. ꞊Dhɛ ‑kë ꞊nɛ ‑wa ‑mɔa 'wo wo ‑zo tën ü ‑dhë pë ‑nu 'ö ‑an 'tɔ 'gian 'yaa ‑an ‑bha ‑an 'gü bhë, a ‑dho ü ‑ya pödhɛ 'gɔɔ‑ do ꞊kɔɔnmɛ 'ka.› ");
INSERT INTO dnj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","'Ö yuökëmɛ kë ꞊plɛ ‑naa ‑yö nu 'ö‑ pö: ‹N ‑Gɔmɛ, 'sënng 'tama 'sɔɔdhu 'a‑ yö ‑a mɛ 'ü‑ nu n ‑dhë bhë ‑a ‑yö ‑a 'piö 'ka.› ");
INSERT INTO dnj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","'Ö ‑gludë ‑ya pö ‑a ‑dhë: ‹Bhi ‑de 'pö, a ‑dho ü ‑ya pödhɛ 'sɔɔdhu ꞊kɔɔnmɛ 'ka.› ");
INSERT INTO dnj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","'Ö‑ ‑bha yuökëmɛ do 'bhaa ‑yö nu 'ö‑ pö: ‹N ‑Gɔmɛ, ü bha 'sënng 'wëüga bhë 'ö ꞊nɛ; a‑ ‑bin ‑ta wöödhö ‑sɔ 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","bhii a ‑suö ü ‑dhë, 'ö tɔɔ ü gɔɔn‑ 'dhiözë 'ka, pë 'ö ü 'ka‑ ꞊waannu ü ‑de ꞊kwaa' 'ü‑ ‑sü, 'ö pë 'ö ü 'ka‑ ta ü ‑de ꞊kwaa' 'ü‑ kan.› ");
INSERT INTO dnj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","'Ö ‑gludë ‑ya pö ‑a ‑dhë: ‹Yuökëmɛ yaa, ü ‑de ‑wo 'ü‑ pö bhë 'a dho ü ‑bha za kan ‑a ‑bha; bhi gia‑ ü‑ ꞊tɛi' dɔ ꞊nɛ a mɛ 'dhiözë 'ka, 'ö pë 'yaa n ‑ma 'ka, 'a‑ sü, 'iin pë 'ö n 'ka‑ ta n ‑de ꞊kwaa', 'a‑ ‑kan! ");
INSERT INTO dnj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","꞊Dhɛ 'ö 'dhö ꞊nɛ, ‑më ‑kë ü 'ka dho ma 'wëüga bhë ‑a 'ka ü 'ka‑ ‑da 'wëükɔ 'gü kö n nu ‑yi 'ka ma gia‑ 'aan‑ ‑a bho mü n ‑de ꞊kwaa' kö n ꞊truën ‑yaan kë ‑dhö ‑e?› ");
INSERT INTO dnj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","꞊Dhɛ ‑kë 'dhö 'ö ‑gludë ‑ya pö mɛ ‑nu 'wo ‑kë mü ‑an ‑dhë: ‹'Sënng 'wëüga do 'yö‑ ‑gɔ bhë, ‑kaa 'kun ‑a ‑gɔ 'ka‑ nu mɛ 'ö 'sënng ga 'gɔɔ‑ do 'dhö ‑a ‑gɔ bhë ‑a ‑dhë!› ");
INSERT INTO dnj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'Wo‑ pö: ‹Yi ‑Gɔmɛ, mɛ 'ö bhë ‑a 'gɔɔ‑ do ꞊ya nu ‑a ‑dhë 'saadhö!› ");
INSERT INTO dnj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Ö ‑gludë ‑ya pö: ‹A‑ ‑pö ka ‑dhë mɛ 'ö pë 'dhoë‑ ‑gɔ, ‑a ‑taɔ ‑dho kë; 'kɛɛ mɛ 'ö pë 'yaa‑ ‑gɔ ꞊va, ‑a 'bhe 'tee ‑de 'ö bhë ‑yö ‑dho kun ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","'Ö go mü, ‑ka mɛ ‑nu 'wo n yaagümɛ 'ka 'ö waa 'we ‑a ‑bha kö a ‑kë wo ‑bha ‑gludë 'ka bhë, ‑ka nu ‑an 'ka 'ka ‑an zë n 'dhiö zö!› » ");
INSERT INTO dnj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","꞊Dhɛ Yesu ꞊ya yën 'wun ꞊blɛɛ' ‑sü ‑bha 'dhö, 'ö zian 'ö dho Zeluzalɛmë 'yö ‑da ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","꞊Dhɛ 'ö ꞊yɔɔn ‑na Betefaze ‑dhɛ waa‑ Betani ‑dhɛ, 'ö ‑tɔn 'ö mü 'wo‑ ‑dhɛ Olivie ‑tɔn bhë ‑a 'sɔɔ, 'yö ö bha ꞊guë' ꞊plɛ bɔ ö 'dhiö, ");
INSERT INTO dnj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","'Ö‑ pö ‑an ‑dhë: «‑Ka 'dho pödhɛ 'ö kwa 'sian 'piö zö ꞊nɛ ‑a 'gü. 'Ka ‑lo ꞊sia, ka ‑dho ꞊soofang 'në do 'ö mɛ gbɛ yaa ‑ya ‑a ꞊taa do ꞊kun ‑a yö kö ‑yö ‑klu ‑sü 'ka, ‑kaa 'po 'ka nu ‑a 'ka! ");
INSERT INTO dnj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Ö ꞊ya kë ꞊nɛ mɛ 'bhaa ꞊ya ka ꞊dhɛɛ' 'kpɔ ꞊sia ꞊nɛɛ: ‹‑Më ‑kë 'ka‑ po ꞊e?›, ‑kaa pö ‑a ‑dhë: ‹Yi Dëmɛ ‑bha ‑wun ‑ya ‑bha›.» ");
INSERT INTO dnj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","'Yö bɔmɛ ‑nu ‑wo ‑dho; 'ö pë ‑nu 'wo bhë 'wo‑ yö ꞊nɛ ‑kɔ ‑de gia‑ 'ö Yesu ‑ya ꞊blɛɛ ‑a 'ka ‑an ‑dhë bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","‑Wo ‑to ꞊soofang 'në bhë ‑a 'po ꞊dhia, 'ö‑ dëmɛ ‑nu ‑wa pö: «‑Më ‑kë 'ka ꞊soofang 'në bhë 'ka‑ po ꞊e?» ");
INSERT INTO dnj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'Wo‑ pö ‑an ‑dhë: «Yi Dëmɛ ‑bha ‑wun ‑ya ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","'Ö 'wo nu ꞊soofang 'në bhë ‑a 'ka Yesu ꞊dhia, 'ö 'wo wo ‑bha gblang ‑nu ‑po ‑a ꞊taa, 'ö 'wo Yesu sü 'wo‑ ‑yaa ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","‑Yö ‑kë 'dho ꞊dhia, 'ö mɛ ‑nu ‑wo wo ‑bha gblang ‑kpɔ zian ‑gblooga ‑ta ‑a 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","꞊Dhɛ 'ö ꞊guë' ‑nu ‑gbaa bhë 'wo ꞊yɔɔn ‑na Zeluzalɛmë plöödhɛ 'sɔɔ, zian 'yö ꞊yɔɔ Olivie ‑tɔn 'piö ꞊zian' ‑a 'ka bhë, 'yö ꞊zuögludhi ‑yö ‑an pa; 'yö 'wo yö 'gɛi kë ‑sü 'gü ‑Zlan 'tɔ 'saa ‑blü ‑sü 'ka 'gbee‑ 'ka ‑dhidhaapë ‑nu 'yö ‑an ‑kë 'wo‑ yö bhë ‑an ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","'wo‑ pö: «Kwaa‑ 'yoo ‑mü! Kwaa‑ 'yoo ‑mü! 'Dhuë‑ ‑yö 'kpɔ ‑gludë 'ö nu Dëmɛ 'tɔ 'gü ‑a ‑bha, ꞊zuöyagluu ‑yö kë dhang‑ 'gü, 'go mü ‑Zlan 'tɔ‑ kë ꞊va!» ");
INSERT INTO dnj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","'Ö Falizi ‑mɛ 'bhaa ‑nu 'wo ‑kë mɛ ‑gbaa ‑nu 'wo ‑kë mü ‑an ziën bhë, 'wo‑ pö Yesu ‑dhë: «Yi ‑Gɔmɛ, ‑bhöë pö ü bha ꞊guë' ‑nu ‑dhë ‑wo wo 'dhi yö 'kuë‑ ‑ɛ!» ");
INSERT INTO dnj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'Ö Yesu ‑ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë: ꞊Wa wo 'dhi ‑yö 'kuë‑ ꞊sia, ‑guö ‑nu ‑wo ‑dho gbla!» ");
INSERT INTO dnj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","꞊Dhɛ 'ö Yesu ꞊ya ꞊yɔɔn pödhɛ 'sɔɔ, 'ö ꞊ya ö 'yan ‑da pö‑ ‑ta 'ö yö 'gbo bɔ ‑sü 'gü Zeluzalɛmë ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","'Ö‑ pö: «'Ö ꞊ya kë ꞊nɛ dɔ 'ö 'kwa‑ wo ꞊dɛɛ ꞊nɛ, pë 'yö dho ü gbaa ꞊zuöyagluu 'ka ü‑ ‑dɔ ‑bezë, kö ꞊yö ‑së ꞊dhɛɛ, 'kɛɛ yö ꞊ga ꞊ya ‑bin ü ‑gɔ bhë, ");
INSERT INTO dnj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","bhii yi ‑nu ‑wo ‑dho nu ü ‑bha 'ka, ü yaagümɛ ‑nu ‑wo ‑dho ꞊nië' ü ‑zü, 'wo pë ‑nu dɔ 'kuëdhö ‑waan bɔ böü‑ 'kplong ‑zü; ‑wo ‑dho sɔ ü ‑ta 'ö 'wo ü ‑nëng zian 'saadhö 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bhi 'dhö, ü 'gü ‑mɛ ‑nu 'dhö, ‑wo ‑dho ka 'gü ꞊siö'‑ 'fɛfɛdhö, ‑guö gbɛ yaa 'dho to ö 'bha ‑guö ‑ta zö. Bhii 'töng 'ö ‑Zlan ‑yö nuë ü ‑dhë bhë ü 'ka‑ dɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu ‑yö ‑da ‑Zlan ‑gɔ kɔɔ, 'ö yö 'dhɔɔdɔmɛ ‑nu 'wo ‑kë mü ‑an kë ‑sü 'gü ");
INSERT INTO dnj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","‑a pö ‑sü 'ka ꞊nɛɛ: «Pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ‑ya pö: Ma 'kɔ ‑yö ‑dho kë ‑bhɛa ‑a 'gü ‑kɔ 'ka, 'kɛɛ ka 'pö, 'ka‑ ‑kë ka ‑bha ꞊kwaanpë ‑bin ‑a 'gü ‑guö ꞊duudhɛ 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑ya mɛ ‑nu ꞊daan' ‑sü ‑bha ‑dhɛkpaɔyi 'saadhö 'ka ‑Zlan ‑gɔ kɔɔ. Slabhomɛ ‑gɔmɛ ‑nu, Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ mɛtɔzë ‑nu ꞊ya kë, ‑wa këdhɛ ‑mɛɛ kö 'waan‑ Yesu zë, ");
INSERT INTO dnj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'kɛɛ ‑a kë ‑kɔ 'wo dho ‑a kaa waa‑ dɔ, bhii 'ö tɔɔ mɛ ‑nu 'saadhö ‑wo wo 'to ‑to Yesu ‑wo ‑bha kpinngdhö wo ‑zo ‑kë ‑a 'piö ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","‑Dhɛkpaɔyi do 'ka Yesu ‑yö ‑kë mɛ ‑nu ꞊daan' ꞊dhia ‑Zlan ‑gɔ kɔɔ 'wuntaɔsë ꞊blɛɛ' ‑sü 'gü. 'Yö slabhomɛ ‑nu ‑gɔmɛ ‑nu, Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ mɛ ziizii ‑nu ‑wo ‑nu, ");
INSERT INTO dnj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'wo‑ pö ‑a ‑dhë: «Pë ‑nu 'ü‑ kë ‑na ꞊nɛ, dö 'ö‑ pö ü ‑dhë 'ü‑ kë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Ma ‑de 'pö, a ‑dho ꞊dhɛɛ' do kpɔ ka ‑gɔ: ");
INSERT INTO dnj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Dö 'ö Zan bɔ kö ‑yaan mɛ bɔ yiö ꞊e? ‑Zlan ‑mü ‑i, 'iin mɛ ‑nu ‑mü ‑i?» ");
INSERT INTO dnj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","'Kɛɛ ‑wo ‑yö 'wun ꞊blɛɛ' ‑sü 'gü wo 'ko ‑dhë 'wo‑ pö: «'Kwa‑ ‑daa kë ꞊sia ꞊nɛ ‑Zlan 'yö‑ bɔ, ‑yö ‑dhoë pö kwa ‑dhë ‑më ‑kë kwaa‑ ‑wo ‑dhɛ 'wun gia‑ ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'Iin 'kwa‑ pö ꞊sia 'zü ꞊nɛ mɛ ‑nu 'wo‑ bɔ, mɛ ‑nu 'töüdhö ‑wo ‑dho kwa ‑zuö ‑guö 'ka 'wo kwa zaa, bhii 'ö tɔɔ mɛ 'plɛ ‑wo Zan ‑ya 'ti ‑kë ‑Zlan ‑wodhiölomɛ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","꞊Dhɛ ꞊ya kë 'dhö, 'wo‑ pö: «Mɛ 'ö‑ bɔ kö ‑yaan mɛ bɔ yiö bhë 'yiëë‑ dɔ.» ");
INSERT INTO dnj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'Ö Yesu ‑ya pö ‑an ‑dhë: «꞊Dhɛ 'ö 'dhö bhë kö ma ‑de 'pö, mɛ 'ö‑ pö n ‑dhë 'a pë ‑nu 'wo ꞊nɛ ‑an kë bhë, n 'ka 'dho ‑a 'tɔ pö ka ‑dhë 'pö.» ");
INSERT INTO dnj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö 'wun ‑blɛɛ mɛ ‑nu ‑dhë 'wun ꞊zuan' 'ka 'ö ‑pö: «Gɔɔndë do ‑yö ö bha lɛzɛn ꞊dhɛɛdhɛ ‑kë, 'ö‑ ‑lo lɛzɛn ꞊dhɛɛdhɛ yuökëmɛ ‑nu kwɛɛ, 'ö‑ to 'ö dho 'ta 'gü ‑glɔɔ 'ma ‑dhiadhö. ");
INSERT INTO dnj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","꞊Dhɛ 'ö lɛzɛn bho ‑yi ꞊ya ‑lo, 'yö ö bha yuökëmɛ do bɔ lɛzɛn ꞊dhɛɛdhɛ yuökëmɛ ‑nu ‑dhë kö ‑waan ö ‑bha ‑kpa bɔ ö ‑dhë. 'Kɛɛ lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu ‑wa ‑kun 'wo‑ ‑ma 'wo‑ ‑yɛ 'zü ö ‑kɔ 'kpaan 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","'Ö lɛzɛn ꞊dhɛɛdhɛ dëmɛ ‑yö ö bha yuökëmɛ do bɔ 'zü, 'ö lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu ‑wa kun, 'wo‑ ‑ma, 'wo 'si ‑nu bho ‑a ‑gɔ, 'wo‑ ‑yɛ 'zü ö ‑kɔ 'kpaan 'ka 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'Yö ö ‑bha yuökëmɛ ‑gwaa kë ‑yaaga ‑naa bɔ; ‑a mɛ bhë ‑wa ‑gi 'wo‑ bho lɛzɛn ꞊dhɛɛdhö, 'wo‑ ‑zuö zian gbɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'Ö lɛzɛn ꞊dhɛɛdhɛ dëmɛ ‑ya pö: ‹‑Më 'a dho ‑a kë ꞊o? Dɔ, 'a n gbö ‑dhɔkaasüzë ꞊duö ꞊nɛ ‑a bɔ, ‑yö ‑kë yö ‑zë ‑wo ‑dho lë‑ ‑kë ‑a ‑gɔ.› ");
INSERT INTO dnj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'Kɛɛ ꞊dhɛ 'ö yuö ‑kë lɛzɛn ꞊dhɛɛdhö ‑mɛ ‑nu ꞊waa‑ yö, 'wo‑ pö wo 'ko ‑nu ‑dhë: ‹Mɛ 'ö pë ‑nu 'wo ꞊nɛ 'wo dho to ‑a ‑gɔ 'dhiö ꞊zian' ö ꞊ga 'ö ꞊nɛ! ‑Kwaa zë kö lɛzɛn ꞊dhɛɛdhɛ 'ö ꞊nɛ ‑yaan 'to kwa ‑gɔ!› ");
INSERT INTO dnj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Ö 'wo‑ kun, 'wo‑ bho lɛzɛn ꞊dhɛɛdhö 'wo‑ zë.» 'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «꞊Ya kë 'dhö, lɛzɛn ꞊dhɛɛdhɛ dëmɛ ꞊ya nu, ‑më 'yö dho ‑a kë ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A‑ ‑pö ka ‑dhë: Pë 'ö dho ‑a kë 'ö tɔɔ ‑yö ‑dho nu 'ö lɛzɛn ꞊dhɛɛdhɛ ‑yuökëmɛ ‑nu 'wo bhë 'yö ‑an zë, 'yö lɛzɛn ꞊dhɛɛdhɛ bhë 'yö‑ nu mɛ 'waa gbɛ ‑nu ‑dhë.» ꞊Dhɛ 'ö mɛ ‑nu ꞊waa‑ ‑wo 'ö bhë ‑a ma 'wo‑ pö: «'Wun mɛ 'ö ꞊suu'‑ 'dhö bhë kö ꞊kun 'ö‑ ‑kë!» ");
INSERT INTO dnj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","'Kɛɛ Yesu ‑yö ‑an ‑ga ‑piindhö 'ö‑ pö ‑an ‑dhë: «꞊Dhɛ 'ö ‑kë 'dhö, ‑më ‑kë 'ö ‑Zlan ‑bha 'sëëdhɛ ꞊bɛɛn' ‑wo ‑ya pö: ‑Guö 'ö 'kɔdɔmɛ ‑nu ‑wa ꞊zong 'dhiö ‑be bhë, yö gia‑ bhë 'ö ‑kë 'kɔ kuënnu ‑guö 'ka zlöö bhë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","'Ö Yesu ‑yö ꞊yɔɔn ö ‑wo ‑ta 'ö‑ pö: «Mɛ 'oo mɛ 'ö 'dhoë‑ ‑püö ‑guö 'ö bhë ‑a ‑ta, ‑yö ‑dho ö ‑de yɛ, 'ö mɛ 'oo mɛ 'ö ‑guö bhë ꞊ya ‑püö ‑a ‑ta, ‑yö ‑dho ‑a ꞊wüü'‑.» ");
INSERT INTO dnj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu waa‑ slabhomɛ ‑gɔmɛ ‑nu ‑wa këdhɛ ‑mɛɛ kö 'waan‑ Yesu 'kundhɛ gia‑ bhë ‑a 'gü, bhii 'ö tɔɔ wo gia‑ ‑wa ꞊dɔa' ꞊nɛ 'wun ꞊zuan' 'ö Yesu ‑ya ‑kë bhë ‑ö ‑gban lɛzɛn ꞊dhɛɛdhɛ waa‑ ö dëmɛ ‑nu ‑an ‑bha bhë, ‑yö ‑gban wo gia‑ wo ‑bha, 'kɛɛ 'suö ‑yö ‑an ‑kë 'sɛgümɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","'Yö 'wo yö naɔ ‑kë Yesu ‑bha ‑sü 'gü; 'wo mɛ ‑nu bɔ kö ‑waan naɔ kë ‑a ‑bha. Mɛ ‑nu 'wo bhë ‑wo wo ‑de ‑kë mɛ ‑nu këwunsëëzë 'ka kö 'waan‑ 'slë 'kan ‑a ‑gɔ ꞊dhɛɛ' ‑nu ‑kpɔ ‑a ‑gɔ ‑sü 'ka. Bhii pë 'yö dho kë ‑a ‑bɔ ‑a ‑ta 'ka kö 'waan‑ ‑a dɔ 'sɛ ꞊kɔɔnmɛ kwɛɛ bhë ꞊nɛ 'wo‑ ꞊mɛɛ'. ");
INSERT INTO dnj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","'Ö 'wo ꞊dhɛɛ' kpɔ Yesu ‑gɔ 'wo‑ pö: «Yi ‑Gɔmɛ, yi‑ ꞊dɔa' ꞊nɛ 'wun ‑nu 'ü‑ ꞊blɛɛ' ‑na bhë o, 'iin ü ‑bha mɛ ꞊daan' ‑wo bhë o, ‑an 'plɛ ‑wo kpengdhö; 'ö 'bhaa mɛ ‑nu zë 'gü kë, 'kɛɛ ü mɛ ‑daan 'ko 'trüün 'piö 'wun giagia 'ö ‑Zlan ‑bha zian ‑ta ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kwa ‑bha tɔng ‑ya ‑pö 'kwa 'nii‑ ꞊sɔnng' bho ‑gludë Sezaa ‑dhë e, 'iin kö ꞊kun 'kwa‑ bho ‑a ‑dhë e?» ");
INSERT INTO dnj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","'Kɛɛ Yesu ‑yö ‑an ‑bha 'slëkanwo bhë ‑a ꞊tɛi' ‑dɔ; 'yö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«‑Ka dönie ga do ‑zɔn n ‑dhë! Dö 'ö‑ 'tɔ waa‑ ‑a ‑gɔ 'bin 'dho ‑ya ‑sü 'ka ‑a ‑ta ꞊nɛɛ?» 'Ö 'wo‑ pö: «Sezaa ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «꞊Dhɛ 'ö 'dhö, pë 'ö Sezaa ‑bha 'ka, ‑kaa bho ‑a ‑dhë; 'ka pë 'ö ‑Zlan ‑bha 'ka, 'ka‑ bho ‑Zlan ‑dhë 'pö!» ");
INSERT INTO dnj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Waa‑ 'kundhɛ yö gbɔ ö ‑wo ‑ta 'wun 'yö‑ ꞊blɛɛ mɛ ‑nu wö 'dhiö bhë ‑a ‑wun 'gü, 'kɛɛ pë 'ö ‑kë ꞊zian' 'ö tɔɔ ‑an 'te 'yö tun 'wun ‑daa kë ‑kɔ ꞊suu'‑ 'ö Yesu ‑ya ‑kë bhë ‑a ‑wun 'gü; 'ö ‑dhɛ ‑yö ga ‑an ‑ta diindhö. ");
INSERT INTO dnj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saduse ‑mɛ 'bhaa ‑nu ‑wo ‑nu Yesu 'piö; wo ꞊nɛ 'wo‑ pö mɛ ꞊ya ga ö 'ka 'dho go ga 'gü gbɔ bhë, 'ö 'wo yö ‑a ꞊dhɛɛ' 'kpɔ ‑sü ‑bha ");
INSERT INTO dnj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","'wo‑ pö: «Yi ‑Gɔmɛ, tɔng 'ö Moizö ‑ya nu yi ‑dhë 'ö ꞊bɛɛn' ‑sü 'ka 'ö ꞊nɛɛ: ꞊Ya kë ꞊nɛ gɔɔn‑ do 'ö‑ dhe 'dho ‑a ‑gɔ ꞊ya kë ‑dhö, ‑a dheglu 'në gɔɔn‑ ꞊ya kë ‑dhö; waa‑ ö bɔɔ waa 'në 'kpɔ gbɔ, ꞊ya 'to 'dhö ꞊ya ga kö ‑a bɔɔ ꞊gɛandhe bhë ‑yö ‑dho to ‑a dheglu 'piö, 'ö 'wo 'në kpɔ ‑a pin ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","'Kɛɛ kö 'töng do 'ka bhë, dhegluzë 'slaplɛ ‑wo ‑kë ‑dhö; 'ö‑ mɛ ‑blɛɛzë ‑yö dhe sü, 'ö waa 'në gbɛ 'kpɔ 'ö ga. ");
INSERT INTO dnj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'Ö‑ bɔɔ ꞊gɛandhe ‑yö to ‑a mɛ kë ꞊plɛ ‑naa bhë ‑a 'piö, ");
INSERT INTO dnj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'ö to ‑a mɛ kë ‑yaaga ‑naa 'piö 'pö. ‑Kɔ do bhë ‑a 'ka 'ö ‑dhɛ 'wo‑ ‑bha 'slaplɛ 'wo‑ ‑kë ‑a 'ka, 'ö waa 'në gbɛ 'kpɔ, 'ö ‑an 'plɛ ‑wo ga. ");
INSERT INTO dnj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","'Ö dhebɔ ‑de 'pö 'yö ga. ");
INSERT INTO dnj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","꞊Ya kë 'dhö, yi 'ö gamɛ ‑nu dho go ‑a 'ka ga 'gü, ‑a dö 'yö dho kë ‑a ꞊gɔn 'ka kpinngdhö ꞊e? Bhii 'ö tɔɔ ‑dhɛ 'ö 'wo‑ ‑bha 'slaplɛ ‑wo ‑kë ‑a ꞊gɔn 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Gɔɔn‑ ‑nu, dhoo ‑nu ‑wo 'kpongtaa zö ‑wo wo 'ko ‑sü, ");
INSERT INTO dnj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'kɛɛ gɔɔn‑ ‑nu, dhoo ‑nu, mɛ 'ö ‑an ‑ma ꞊kun kö ‑waan 'go ga 'gü kö ‑waan ‑kë ‑a 'gü ‑sü mɛ 'ö zlöö ꞊toëpö 'ka ‑a yö bhë, waa 'dho wo 'ko sü, ");
INSERT INTO dnj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","wo 'ka 'dho ga gbɔ, bhii kö waa‑ ‑Zlan ‑bha bɔmɛ ‑nu ‑an ꞊suu'‑ ꞊ya kë do; kö ꞊wa kë ‑Zlan ‑bha 'në ‑nu 'ka, bhii 'ö tɔɔ ꞊wa 'go ga 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","'Go mü 'zü Moizö ‑ya ‑zɔn 'wun gia‑ 'ka ꞊nɛ gamɛ ‑nu ‑wo ‑dho go ga 'gü, bhii pë 'ö ꞊bɛɛn' ‑sü 'ka ‑a ‑bha 'sëëdhɛ 'gü, 'wun 'ö ‑gban 'ginngkpɔɔ ‑bha, 'ö tɔɔ ‑yö kwa Dëmɛ ‑dhɛ Ablaamö ‑bha ‑Zlan, Izaakö ‑bha ‑Zlan waa‑ Zakɔbö ‑bha ‑Zlan. ");
INSERT INTO dnj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kö ‑kaa dɔa ꞊nɛ ‑Zlan ‑yö mɛ 'bhee‑ ‑nu ‑bha ‑Zlan 'ka, 'yaa gamɛ ‑nu ‑bha ‑Zlan 'ka, bhii mɛ 'wo 'bhee‑ bhë ‑wo 'bhee‑ 'dhö ‑a ‑bha 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","'Yö Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu mɛ 'bhaa ‑nu ‑wa pö: «Ü‑ ‑blɛɛ ‑së, yi ‑Gɔmɛ!» ");
INSERT INTO dnj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bhii 'ö tɔɔ ꞊dhɛɛ' gbɛ 'kpɔ ‑dhɔ yaa ‑an kë ‑a ‑gɔ zlöö gbɔ. ");
INSERT INTO dnj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Yö ‑kɔklë 'wo‑ pö ‑Zlan ‑bha ‑Yamɛ 'pö ‑yö ‑go Davidö ꞊suu'‑ ‑ta 'gü i? ");
INSERT INTO dnj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","'Kɛɛ kö Davidö gia‑ ‑ya ‑pö 'Tan 'sëëdhɛ 'gü ꞊nɛɛ: N Dëmɛ (‑Zlan) ‑ya ‑pö n Dëmɛ ‑dhë: ‑Bhö ‑ya ‑yadhɛ ꞊bhlëzë 'gü ꞊zian' ");
INSERT INTO dnj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‑yö 'dho ‑ö yöë yi 'a dho ü yaagümɛ ‑nu kaa ü ‑gɛn ‑ta ‑a ‑ta dhuö ‑pë 'ka ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","꞊Dhɛ Davidö gia‑ ‑ya ‑dhɛ ö Dëmɛ, ‑yö ‑kɔklë 'ö ‑Zlan ‑bha ‑Yamɛ ‑yö ‑go ‑a ꞊suu'‑ ‑ta 'gü 'zü i?» ");
INSERT INTO dnj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Mɛ gbung 'wo ‑kë mü bhë ‑an 'plɛ 'to ‑ya ‑wo ‑bha. 'Yö Yesu ‑ya pö ö bha ꞊guë' ‑nu ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«‑Ka ka ‑zo kë ka ‑de 'piö Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu 'wo‑ ‑dhɔ kë ‑na ꞊nië gblang ꞊gbiin ‑nu 'ka ‑sü 'ka, 'ö 'wo‑ 'piö kö ‑wo ‑mɛɛ ‑nu kë wo 'ka ꞊bhlë 'gü 'dhëëdhɛ ꞊vava ‑nu ‑bha, 'ö 'wo ‑ya ‑gbloo ‑sɛɛbɔ ‑ta ‑an ‑gɔ ‑bhɔkuëkɔ ‑nu 'gü, 'wo ‑yadhɛ ‑sɛɛbɔ sü 'wlaan‑ ‑nu ‑ta; ");
INSERT INTO dnj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","wo bhë ‑wo ꞊gɛandhoo ‑nu ‑bha pë ‑nu 'ö ‑an ‑gɔ ‑a kun ‑an ‑gɔ, 'ö ꞊wa 'go mü 'wo ꞊bhɛa ꞊gbiin kö 'waan‑ kë mɛ ‑nu këwunsëëzë 'ka mɛ ‑nu wö 'dhiö. Bhii ‑wo ‑dho 'klobhɔdhe ꞊va ‑ziögɔüsüzë yö.» ");
INSERT INTO dnj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu ‑yö ‑dhɛ ‑ga ö ‑zü 'to, 'ö‑ 'yan ‑yö ‑da ꞊bhɔɔmɛ ‑nu 'wo wo ‑bha ꞊gbaapë ‑da ‑na ‑Zlan ‑gba ‑a 'gü ‑pë 'gü, ‑Zlan ‑gɔ kɔɔ bhë ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","'Ö‑ 'yan ‑yö ‑da 'zü ꞊gɛandhe 'fɛɛzë do 'bhaa ‑ta kö ‑yö 'wëü‑ 'sɛɛn‑ ga ꞊plɛ ‑da ‑na ‑Zlan ‑gba ‑a 'gü ‑pë 'ö bhë ‑a 'gü 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö mɛ ‑nu 'wo ‑kë mü bhë ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Dhebɔ 'fɛɛzë 'ö ꞊nɛ 'wëü‑ 'ö‑ ‑da mü bhë, ꞊yö ꞊va 'ö ꞊zië' mɛ ‑nu 'wo to 'saadhö ‑an ‑bha ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bhii mɛ ‑nu 'wo bhë 'wëü‑ 'ö‑ nu ‑sü 'yaa 'më ‑an 'ka bhë ꞊nɛ 'wo‑ ‑kë gbaɔ 'ka; 'kɛɛ yö 'pö, ‑a ‑bha 'fɛɛdhɛ 'gü pë 'ö to ‑a ‑gɔ ‑tosiadhe këpë 'ka bhë 'ö‑ 'plɛ ‑nu bhë.» ");
INSERT INTO dnj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mɛ 'bhaa ‑nu ‑wo 'wun ‑blɛɛ ‑Zlan ‑bha 'kɔ bhë ‑a ‑bha 'wo‑ pö: «‑Guö ‑nu 'wo 'kɔ dɔa ꞊nɛ ꞊wo ‑së ꞊dhɛɛ! 'Ö pë ‑nu 'wo‑ nu ꞊gbaapë 'ka 'wo‑ 'gü bhë, ‑wo ‑së 'pö ꞊dhɛɛ!» ");
INSERT INTO dnj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","'Ö Yesu ‑ya pö: «Pë ‑nu 'ka ‑an ‑ga ‑na bhë, yi do ‑yö nu ‑na, ‑guö gbɛ yaa 'dho to ö 'ko ‑ta dhuö mü, ‑an 'plɛ ‑wo ‑dho ‑lo.» ");
INSERT INTO dnj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","'Wo‑ pö ‑a ‑dhë: «Pë ‑nu 'wo 'dhö bhë ‑wo ‑dho kë yi ‑mlë 'ka ɛ? ꞊Duakëpë ‑mlë 'yö dho pë ‑nu 'wo bhë ‑an yi ‑zɔn ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","'Ö Yesu ‑ya pö: «‑Ka ka ‑zo kë ka ‑de 'piö! Kö ꞊kun 'ka ka ꞊kwaa' ka ‑de ‑zü 'wo ka ‑püö! Bhii mɛdhɛvadhɛ ‑wo ‑dho nu n 'tɔ 'gü, 'wo‑ pö: ‹Ma 'pö, ‑Zlan ‑bha ‑Yamɛ ‑mü n 'ka! Ma nu 'töng ꞊ya ‑lo!›, 'kɛɛ kö ꞊kun 'ka ‑ziö ‑an 'piö! ");
INSERT INTO dnj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","'Ka ‑glu gɔn ‑wun ‑nu 'iin ‑dɔ 'ko ‑gɔ 'yënng ‑wun ‑nu ma, kö ꞊kun 'ö 'siö ‑yö ‑kan ka 'gluu! Pë ‑nu 'wo 'dhö ‑wo ‑dho kë 'dhiö ‑blɛɛzë, 'kɛɛ yaa 'dho kë 'kpongtaadhɛ 'dhiö 'to ‑sü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","'Go mü 'yö‑ pö 'zü ꞊nɛɛ: «'Sɛgɔgümɛ ‑nu ‑wo ‑dho 'ko zë wo 'bha 'sɛgɔgümɛ ‑nu 'ka, ö ‑gludë dho ‑glu ‑da ö 'bha ‑gludë ‑ta; ");
INSERT INTO dnj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'sɛ ‑bha ꞊zluun ‑sü 'gbee‑ ‑dho kë ‑dhö, 'ö din ‑nu, ‑sü 'kuë‑ ꞊yua' ‑nu dho nu 'sɛgɔ 'bhaa ‑nu 'gü, 'siö ‑kan mɛ 'gluu ‑pë waa‑ ꞊duakëpë ‑wo ‑dho kë dhang‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","'Kɛɛ ‑a kë ꞊yië' kö pë ‑nu 'wo 'dhö bhë ‑waan kë, mɛ ‑nu ‑wo ‑dho ka kun, 'wo pë 'dhiö‑ ‑nu kë ka 'ka, 'wo ka dɔ mɛ ‑nu kwɛɛ Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑nu 'gü, 'wo dho ka ‑zuö ‑kanso 'gü ‑waan za dɔ ka ‑bha ‑gludë ‑nu waa‑ 'sɛ ꞊kɔɔnmɛ ‑nu ‑an 'dhiö n ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","‑Yö ‑dho kë ka ‑bha bɔdhɛ 'ka kö 'kaan‑ kë n ꞊goo‑ ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","‑Ka ka ‑zo ‑gban kö ꞊kun 'ka dɔ ka ‑de ‑wun ꞊zɔnng' ‑ta za 'ö dɔ ka ‑bha bhë, ka ‑bha ꞊blɛɛ' ‑sü ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","bhii ꞊ya kë ꞊nɛ mɛ ‑nu ꞊wa 'dho ka 'ka zakanmɛ ‑nu 'dhiö, ma gia‑, a ‑dho ‑wo 'ö 'kpaakpadhɛ 'ö ka yaagümɛ gbɛ 'ka 'dho ‑mɔ ‑a ‑bha 'iin ‑yaan dɔ ‑a ‑gɔ ‑a dɔ ka 'dhii. ");
INSERT INTO dnj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ka dë ‑nu, ka dhe ‑nu, ka dheglu ‑nu, ka mɛ ‑nu, ka 'bhamɛ ‑nu ‑de gia‑, ‑wo ‑dho ka dɔ mɛ ‑nu kwɛɛ, 'wo mɛ 'bhaa ‑nu zë ka 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mɛ 'saadhö ‑wo ‑dho ka ‑san zë n ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","'kɛɛ ka tuö ‑wun ga do 'ka 'dho ꞊dhɔng. ");
INSERT INTO dnj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","‑Ka ka 'gü dɔ 'gbee‑, 'ka‑ kë 'dhö, 'ka dho ka ‑bha ꞊toëpö ‑kë ‑a 'gü ‑sü yö.» ");
INSERT INTO dnj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","'Ö‑ pö: «Yi 'ka dho Zeluzalɛmë ‑dhɛ yöë kö ‑glugɔnmɛ ‑nu ꞊wa ꞊nië' ‑a ‑zü bhë, ‑kaa dɔa ꞊nɛ ‑a 'gü ꞊siö'‑ ‑yi ꞊ya yö ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","꞊Ya kë 'dhö mɛ ‑nu 'wo Zude ‑wo ‑dho ꞊duë, ‑wo 'dho ‑tɔn ‑nu 'piö ꞊zian'; mɛ ‑nu 'wo dho kë Zeluzalɛmë plöödhɛ ‑bha, ‑wo ‑dho go wo pin ‑bha; mɛ ‑nu 'wo dho kë zian ‑gbloo ‑nu 'piö, kö ꞊kun 'wo ‑da plöö, ");
INSERT INTO dnj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","bhii ‑yö ‑dho kë 'klobhɔdhe ‑yi 'ka. ‑Yö kë 'dhö, kö pë ‑nu 'wo ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ‑an 'dhiö ‑nu ‑waan ‑mɔ 'kuë. ");
INSERT INTO dnj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","‑Më 'yena ‑wun 'ö dho kë yi 'ö 'dhö bhë ‑a 'ka, dhoo ‑nu 'wo 'guzë waa‑ dhoo ‑nu 'wo 'bëë‑ 'ka ‑an ‑bha 'ka ‑oo! Bhii ꞊zuö' ‑da 'yenagüdhe ꞊va ‑yö ‑dho kë 'sɛ 'ö ꞊nɛ ‑a 'gü, 'ö 'wun ‑yö na ‑Zlan ‑zuë ‑a 'gü ‑mɛ ‑nu buëndhö. ");
INSERT INTO dnj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","‑Wo ‑dho ‑an zë ‑blaan 'ka, 'wo ‑an kun 'gan 'ka, 'wo dho ‑an 'ka 'sɛgɔ 'gü ‑dhɛ 'saadhö ‑bha, 'ö mɛ ‑nu 'waa ‑Zlan ‑bha mɛ ‑nu 'ka 'wo dho Zeluzalɛmë ‑pö ꞊siö' ‑yaan 'dho ‑yaan yöë 'töng 'ö ‑Zlan ‑ya nu ‑an ‑dhë bhë ‑a yën ‑yi ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","'Ö‑ pö: «꞊Duakëpë ‑nu ‑dho kë lan‑ 'gü, 'yö ‑kë 'su 'gü, 'yö ‑kë 'susongga ‑nu 'gü; 'ö sia‑ zö, 'kpongtaamɛ ‑nu ꞊zuö' dho ‑da ꞊wabhödhe 'gü, 'ö 'suö ꞊va dho ‑da mɛ ‑nu 'gü, 'yoo ‑drinng 'gbee‑ ‑bha dɔ ‑sü waa‑ 'yoo kpö ‑bha ‑ma ‑sü ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mɛ ‑nu ‑dho ga 'suö ‑dhë, ‑zo ‑ta ‑a 'gü ‑pë 'ö dho kë 'kpongtaa zö bhë ‑a ‑wun 'gü, bhii 'piigbeedhɛ ‑nu 'wo dhang‑ 'gü ‑wo ‑dho ꞊zluun. ");
INSERT INTO dnj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","꞊Ya kë 'dhö ‑wo ‑dho ma 'a Mɛgbö 'ka n yö kö a nu ‑na dha kpö ‑ta 'piigbeedhɛ waa‑ 'tɔbhɔdhe ꞊va 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","'Töng 'ö pë ‑nu 'wo bhë 'wo dho kaa, ‑ka ka ‑zo ‑gban 'ka ka ‑gɔ ‑nu ꞊luu'‑, bhii kö ka ‑bha ‑go 'gan 'gü ‑sü ꞊ya yö ꞊klöö'.» ");
INSERT INTO dnj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu ‑yö 'wun ꞊zuan' do ‑zɔn ‑an ‑dhë 'ö‑ pö: «‑Ka figö ‑lü waa‑ 'lü mɛ ‑nu 'wo to ‑an ‑ga! ");
INSERT INTO dnj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","'Ka ‑an 'dhɛ ‑dëü ‑nu yö, kö ꞊ya kë ka 'yaan ꞊nɛ ꞊kpɔɔ ꞊ya yö ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","‑Kɔ do bhë ‑a 'ka pë ‑nu 'wo bhë 'ka ‑an yö, ‑kaa dɔa ꞊nɛ ‑Zlan ‑bha ‑gludëdhɛ ‑bha nu ‑sü ꞊ya yö ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A‑ ‑blɛɛ ka ‑dhë 'wun gia‑ 'ka: Pë ‑nu 'wo 'dhö ‑wo ‑dho kë kö mɛ ‑nu 'wo 'töng ꞊nɛ ‑a 'gü ꞊nɛ ‑an 'plɛ waa ga ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dhang‑ waa‑ 'sɛ ‑wo ‑dho ziö, 'kɛɛ n ‑wo 'ka 'dho ziö 'gbɛɛdhö.» ");
INSERT INTO dnj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","'Ö‑ pö: «‑Ka ka ‑zo kë ka ‑de 'piö! Kö ꞊kun 'ö 'ka ka ‑de 'bɔn ‑kan ‑bhöpë ꞊vava ‑bhö ‑sü ‑nu, yɔ 'yi ꞊vava mü ‑sü ‑nu waa‑ ‑zo ‑ta 'kpongtaapë ‑wun 'gü ‑sü ‑an ꞊kwaa', 'yaa 'dhö n nu ‑yi ‑dho ‑wo ka tii 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Bhii ‑yö ‑dho ‑lo ka ‑ta ꞊nɛ 'kplö 'dhö 'kpongtaamɛ 'plɛ ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","‑Ka ‑ya ka 'yaan, ‑ka ꞊bhɛa'‑ 'töng 'saadhö ‑a 'ka, kö ka 'gü ‑yaan kë 'gbee‑ 'kaan‑ dha pë ‑nu 'wo 'dhoë‑ nu 'töüdhö bhë ‑an ‑gɔ, 'iin 'kaan‑ dɔ ka ‑gɛan ma 'a Mɛgbö 'ka n 'dhiö.» ");
INSERT INTO dnj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","꞊Dhɛ ꞊ya kë 'dhö yi 'saadhö 'ka, Yesu ‑yö mɛ ‑nu ‑daan ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü; 'yö 'bin ꞊ya 'më, 'yö dho Olivie ‑tɔn tuö ‑wɔ 'ma ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","'Ö ‑dhiadhiö 'ö mɛ ‑nu ‑wo ‑so 'wo nu ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü ‑waan wo 'to 'to ‑a ‑wo ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","'Bluu‑ 'ö‑ ꞊bhɛɛpë 'yaa‑ 'piö bhë ‑a 'wlaan‑ kë ‑yi 'wo‑ ‑dhɛ Paakö bhë, ꞊dhɛ 'ö‑ yi ꞊ya yö ꞊klöö', ");
INSERT INTO dnj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","'Ö slabhomɛ ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu ‑wa këdhɛ ꞊mɛɛ kö 'waan‑ Yesu zë, 'kɛɛ 'suö ‑yö ‑an ‑kë 'sɛgümɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","'Ö Zuda 'wo‑ ‑dhɛ Ikaliɔtö, 'yö ‑kë Yesu ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑a mɛ do 'ka bhë, 'ö Satan ‑yö ‑da ‑a ꞊zuö' 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","'Yö Zuda ‑yö ‑luu 'yö dho 'yan ‑to ‑Zlan ‑bha 'kɔ ‑bha ‑mɛ ‑nu ‑gɔmɛ 'piö 'ö ‑kɔ 'ö dhoë kaa kö 'yaan‑ Yesu dɔ ‑an kwɛɛ bhë, 'yö‑ ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Ö ‑an ꞊zuö' 'glu ‑yö ‑dhi giagiawo, 'wo 'wëüga 'tɔ go ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zuda ‑yö ‑we ‑a ‑bha; 'yö yö ‑a 'slë ꞊mɛɛ' ‑sü 'gü kö ‑yaan Yesu dɔ ‑an kwɛɛ ‑ziö ‑a 'piö ‑mɛ ‑nu tii. ");
INSERT INTO dnj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Paakö 'ö 'wlaan‑ ‑yi do 'ö ꞊ya kë 'wo 'bhlanë ‑gbɔng zë 'wo‑ ‑bhö ꞊bluu'‑ 'ö‑ ꞊bhɛɛpë 'yaa‑ 'piö ‑a yi 'ka bhë, ꞊dhɛ ꞊ya ‑lo, ");
INSERT INTO dnj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","'Ö Yesu ‑yö Piɛɛ waa‑ Zan ‑an bɔ 'ö‑ pö: «‑Ka 'dho 'ka kwa ‑bha pë 'kwa dho ‑a ‑bhö Paakö ‑ta, ‑a ‑yuö kë!» ");
INSERT INTO dnj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'Ö 'wo‑ pö ‑a ‑dhë: «꞊Dhɛ ‑mlë 'ü‑ 'piö kö 'yi‑ ‑yuö kë ‑a ‑bha ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","'Yö‑ pö ‑an ‑dhë: «‑Ka ka 'to 'to! Ka ‑bha ‑da Zeluzalɛmë plöö ‑sü 'ka, ka ‑dho ‑kpën gɔɔn‑ do 'ö 'yi ‑gbɔ 'dho ‑a ‑gɔ ‑a ‑bha. ‑Ka 'to ‑a 'piö, 'ka 'dho 'kɔ 'ö 'dhoë‑ ‑sɔ ‑a 'gü bhë, 'ka ‑sɔ ‑a 'gü ");
INSERT INTO dnj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","'ka‑ pö 'kɔ dëmɛ ‑dhë: ‹Yi ‑gɔmɛ ‑yö ꞊dhɛɛkpɔdhe do ‑dɔ yi ‑gɔ kö 'yiën‑ ‑a 'kpɔ ü ‑gɔ; ‑ya ‑pö 'kɔdhi ‑mlë 'ö waa‑ ö ‑bha ꞊guë' ‑nu 'wo dho Paakö ‑pë ‑bhö ‑a 'gü i?› ");
INSERT INTO dnj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","‑Yö ‑dho 'kɔdhi do ꞊va 'ö ‑dɔ kɔɔpë 'plɛ ꞊ya ‑mɔ ‑a 'gü ‑a ‑zɔn ka ‑dhë 'kɔ ‑ta dhuö ‑kɔ 'gü. ‑Dhɛ bhë 'ka dho ‑bhöpë ‑nu ‑yuö kë ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Ö 'wo dho 'wo pë ‑nu 'wo bhë 'wo ‑an yö ꞊nɛ ‑kɔ 'ö Yesu ‑ya ꞊blɛɛ ‑a 'ka ‑an ‑dhë bhë ‑a 'dhö; 'ö 'wo ‑bhöpë 'ö dho kë Paakö ‑ta bhë 'wo‑ ‑yuö ‑kë. ");
INSERT INTO dnj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","꞊Dhɛ 'ö 'töng ꞊ya ‑lo, 'ö Yesu waa‑ ö bha bɔmɛ ‑nu ‑wo dho pë ‑bhö ꞊dhia, ");
INSERT INTO dnj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","'yö‑ pö ‑an ‑dhë: «‑Yö ‑kë n ‑dhë ‑së ꞊duö kö 'kwa Paakö ‑bhöpë 'ö ꞊nɛ 'kwa‑ ‑bhö kwa 'ko ꞊bhaa n 'klo yaa ꞊tun bhɔ ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bhii a‑ ‑pö ka ‑dhë: N 'ka 'dho ‑a gbɛ ‑bhö gbɔ 'ö dho 'ö yöë Paakö sla‑ bho ‑sü 'ö bhë ‑a ‑gɛn ‑yö 'ko 'dhiö ‑yi ‑bha ‑Zlan ‑bha ‑gludëdhɛ ‑pö 'gü.» ");
INSERT INTO dnj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑drɔɔn ‑kɔɔ ‑yaan do sü 'ö ‑Zlan zuö pö ‑a ‑ta 'ö‑ nu ‑an ‑dhë 'ö‑ pö: «Pë ꞊nɛ, ‑kaa ‑a 'sü 'ka‑ ‑glu ka 'kuë 'ka‑ mü, ");
INSERT INTO dnj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","bhii a‑ ‑pö ka ‑dhë 'ö sü ꞊dɛɛ ‑bha n 'ka 'dho ‑drɔɔn mü gbɔ 'ö dho 'ö yöë ‑Zlan ‑bha ‑gludëdhɛ nu ‑yi ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","꞊Dhɛ ꞊yaa‑ pö 'dhö, 'yö 'bluu‑ sü; ꞊dhɛ ꞊ya ‑Zlan zuö pö ‑a ‑ta, 'yö‑ 'klu ‑kan 'yö‑ nu ‑an ‑dhë 'ö‑ pö: «Pë ꞊nɛ tɔɔ n bun, 'a‑ nu ka ‑wun 'gü. Ka‑ ‑bhö ‑na, ka ‑zo ‑yö ‑büö n ‑wun 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","‑Kɔ do bhë ‑a 'ka; 'ö ‑drɔɔn ‑kɔɔ ‑yaan do nuë ‑an ‑dhë kö ꞊wa yën pë ‑bhö ‑sü ‑bha, 'ö‑ pö ‑an ‑dhë: «‑Drɔɔn ‑kɔɔ ‑yaan 'ö ꞊nɛ 'ö tɔɔ ‑Zlan ‑bha ‑dhikuëdhe ‑dëü 'ö bɔ n fɛi ‑ta 'ö ‑lo ka ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","'Kɛɛ ‑ka ‑dhɛ ‑ga, mɛ 'ö dho n 'dhɔɔ dɔ, ‑yö n 'piö pë ‑bhö ꞊dhia zö! ");
INSERT INTO dnj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ma 'a Mɛgbö 'ka, a ‑dho ga ꞊nɛ ‑kɔ 'ö ‑Zlan ‑ya yö ‑a 'ka 'ko 'dhiö kö ‑yaan kaa ‑a 'dhö; 'kɛɛ gɔɔn‑ 'ö 'dhoë‑ n 'dhɔɔ dɔ bhë 'yena ‑wun ꞊ya kaa ꞊dhɛɛ!» ");
INSERT INTO dnj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo yö wo 'ko ‑nu ꞊dhɛɛ' 'kpɔ ‑sü ‑bha, mɛ 'ö dho 'wun ꞊suu'‑ 'ö 'dhö bhë ‑a kë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","‑A ‑bha ꞊guë' ‑nu ‑wo za ‑ya wo 'ko ‑bha, mɛ dho kë mɛ ꞊va 'ka wo ziën ‑a ‑wun ꞊blɛɛ' ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'Ö Yesu ‑ya pö ‑an ‑dhë: «'Kpongtaa zö, ‑gludë ‑nu ‑wo mɛ ‑nu ‑kɔɔn, mɛ ‑nu ꞊nuadhɛ ‑kë wo ‑sü 'ka, 'ö mɛ ‑nu 'ö ‑wogbiindhɛ 'dho ‑an ‑gɔ, 'wo ‑an ‑dhɛ mɛ këpësëëzë ‑nu, ");
INSERT INTO dnj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'kɛɛ ka ‑bha 'ka, yaa 'dho kë 'dhö. Pë 'ö dho kë ꞊zian' 'ö tɔɔ mɛ 'ö mɛ ꞊va 'ka ka ziën, kë 'ö dho ‑a wo ꞊nɛ 'në 'tee 'dhö; 'ö mɛ 'ö mɛ ꞊kɔɔnmɛ 'ka, 'yö dho kë ꞊nɛ yuö ‑kë mɛ 'dhiö ‑mɛ 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","꞊Dhɛ ‑kë 'dhö ꞊nɛ dö 'ö tɔɔ mɛ ꞊va ꞊ɛ? Mɛ 'ö pë ‑bhö ꞊dhia ꞊i, 'iin mɛ 'ö ‑an gbaa ‑na ‑bhöpë 'ka i? Mɛ 'ö pë ‑bhö ꞊dhia 'yaa ‑mü ‑a? 'Kɛɛ ma 'pö, a ka ziën ꞊nɛ mɛ 'dhi gbamɛ 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","'Ka ꞊glɔɔ n 'piö piindhö 'wun 'gbee‑ ‑nu 'wo nu n ‑ta ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","‑Kɔ do 'ö n Dë ‑yö ö ‑bha ‑gludëdhɛ ‑wun ‑lo ‑a 'ka n kwɛɛ bhë, 'ö 'a dho ka ‑da ‑a 'ka n 'piö, ");
INSERT INTO dnj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kö 'kwa pë ‑nu ‑bhö, 'kwa müpë ‑nu mü kwa 'ko ꞊bhaa ‑Zlan 'piö; 'go mü 'ka dho ‑ya 'gɔ ‑gbloo 'gü 'ö 'ka Izlaɛlö 'gunng ‑gɔ 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an ‑bha za kan.» ");
INSERT INTO dnj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","'Ö Yesu ‑ya pö Piɛɛ ‑dhë: «Simɔ, Simɔ, ‑bhö ü 'to 'to! Satan ꞊yaa‑ ‑dhɛ kö ‑yaan ka ꞊zaan 'zan ꞊nɛ mɛ ‑mlü ‑piö, ");
INSERT INTO dnj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","'kɛɛ 'ma ꞊bhɛa'‑ ü ‑wun 'gü, ‑yö kë 'dhö kö ꞊kun 'ö ü ‑bha ‑zo ‑yö n ‑ma ‑sü dho go ü ‑gɔ. ꞊Ya kë ꞊nɛ 'bha 'yɛ ü 'zü 'bha nu n 'piö, ‑bhö ü dheglu ‑nu ꞊faan' 'më!» ");
INSERT INTO dnj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","'Ö Piɛɛ ‑ya pö ‑a ‑dhë: «N Dëmɛ, n ‑mɔ ‑a 'gü ‑sü ‑mü kö mɛ 'plɛ ‑waan ko ‑da ‑kanso 'gü kö 'koën‑ ga ko 'kuë.» ");
INSERT INTO dnj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'Ö Yesu ‑ya pö ‑a ‑dhë: «A‑ ‑pö ü ‑dhë, Piɛɛ, ‑a kë ‑sü 'ka gbeng do 'ö ꞊nɛ ‑a 'gü kö ‑tɔgɔn ‑yaan 'we, ü ‑dho ‑a pö ‑gwaa ‑yaagazë ꞊nɛ 'bhaa n dɔ.» ");
INSERT INTO dnj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","'Ö Yesu ‑ya pö ‑an ‑dhë: «Ka bɔ 'a‑ wo 'dhiö ‑be, 'a‑ pö kö ꞊kun 'ka 'wëü‑ ‑da ‑a 'gü ‑pë ‑nu, ꞊bhɔɔ' ‑nu, ‑sakpa ‑nu gbɛ sü bhë, ꞊dhɛ 'ka 'dho, ‑më 'ö‑ ‑wun ‑yö ka ‑kë ‑ɛ?» 'Wo‑ pö ‑a ‑dhë: «‑Daa 'dee‑!» ");
INSERT INTO dnj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö ‑an ‑dhë: «'Kɛɛ zlöö ꞊nɛ bhë, mɛ 'ö‑ ‑bha 'wëü‑ ‑da ‑a 'gü ‑pë 'dhö ‑dhö ‑ya 'sü. ‑Kɔ do bhë 'ö mɛ 'ö‑ ‑bha ꞊bhɔɔ' 'dhö ‑dhö ‑ya 'sü, mɛ 'ö ‑blaan 'yaa‑ ‑gɔ, ‑yö ö bha gblang 'dhɔɔ dɔ, ‑yö ‑blaan do 'dhɔ! ");
INSERT INTO dnj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bhii a‑ ‑blɛɛ ka ‑dhë ‑yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: ‑Wa ‑kpa këpëyaamɛ ‑nu ‑bha. 'Wun ‑nu 'wo bhë ‑an 'plɛ 'dhiö ‑dho ‑mɔ 'kuë; pë 'ö ꞊bɛɛn' ‑sü 'ka n ‑wun 'gü, ‑a 'plɛ 'dhoë‑ kë.» ");
INSERT INTO dnj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","'Ö‑ ‑bha ꞊guë' ‑nu ‑wa pö ‑a ‑dhë: «Yi Dëmɛ, ‑blaan ꞊plɛ 'wo ꞊nɛ!» 'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Yö 'to 'pö.» ");
INSERT INTO dnj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu ‑yö ‑yö plaan, 'yö dho Olivie ‑tɔn tuö ꞊nɛ ‑kɔ 'yö‑ ꞊kaa' ‑kplawo bhë ‑a 'dhö. ‑A ‑bha ꞊guë' ‑nu ‑wo ‑ziö ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","꞊Dhɛ ꞊wa 'dho ꞊wa ‑lo ‑dhɛ bhë ‑a ‑bha, 'yö‑ pö ‑an ‑dhë: «‑Ka ꞊bhɛa'‑, ‑yö ‑kë 'dhö kö ꞊kun 'ö Satan dho ka ‑püö!» ");
INSERT INTO dnj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","꞊Dhɛ ꞊ya kë 'dhö, 'yö bhɔ ‑an ‑dhë ꞊taa' 'dɛdɛ 'ka, 'yö ‑lo ö kpɔn 'gü 'yö ꞊bhɛa ");
INSERT INTO dnj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","‑wo 'ö ꞊nɛ ‑a 'ka 'ö‑ pö: «N Dë, 'ö ꞊ya kë ꞊nɛ 'bha 'we ‑a ‑bha, ‑bhö 'yi 'güüzë 'ö ꞊nɛ ‑a bhɔ n ‑dhë ꞊taa', 'kɛɛ n 'ka‑ pö ma 'pö n ꞊dhɔɔbhaa ‑yö kë, bhi ‑zë, ü ‑zo 'kun ‑wun ‑yö kë ꞊zian'!» ");
INSERT INTO dnj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","'Ö ‑Zlan ‑bha bɔmɛ do ‑yö go dhang‑ 'gü 'yö nu kö ‑yaan ꞊faan' nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","'Ö‑ ꞊zuö' ‑yö ‑da ga 'siö ‑bha mɛ 'sü ‑sü 'gü, 'yö ‑bhɛa ö ꞊faan' 'plɛ 'ka, ꞊dhɛ 'to ‑na zlöö kö föyi 'yö go ‑na ‑a ‑bha, 'yö ban ‑na sia‑ bhë, ꞊ya kë fɛi 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","꞊Dhɛ 'ö ꞊ya yën ꞊bhɛa' ‑sü ‑bha, 'ö ꞊luu 'ö nu 'zü ö bha ꞊guë' ‑nu 'piö, 'yö ‑an yö kö ꞊wa yi zë ‑an ꞊zuö' 'yö ‑kaan 'kuë bhë ‑a ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","'yö‑ pö ‑an ‑dhë: «‑Më ‑kë 'ka yi zë ꞊ɛ? ‑Ka ꞊luu'‑ 'ka ꞊bhɛa'‑, ‑yö kë 'dhö kö ꞊kun 'ö Satan dho ka ‑püö!» ");
INSERT INTO dnj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu ‑yö ‑to 'wun ꞊blɛɛ' ꞊dhia, 'ö mɛ ‑gbaa ꞊va ‑wo nu. ‑A ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑a mɛ do 'wo‑ ‑dhɛ Zuda ꞊nɛ 'ö yö mɛ ‑gbaa 'wo bhë ‑an ‑dhë 'dhiö, 'ö ꞊yɔɔn Yesu ‑bha 'ö‑ 'kpeng mü (‑a ‑zɔn ‑an ‑dhë ‑sü 'ka). ");
INSERT INTO dnj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'Ö Yesu ‑ya pö ‑a ‑dhë: «Zuda, ma 'a Mɛgbö 'ka n ‑püö ‑kɔ 'ö tɔɔ n 'kpeng mü ‑sü ‑a?» ");
INSERT INTO dnj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","꞊Dhɛ mɛ ‑nu 'wo ‑kë Yesu 'piö ꞊waa‑ dɔa ꞊nɛ ‑wo ‑nu ‑a 'kun ꞊dhia, 'wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Yi Dëmɛ, 'yi ‑an ‑zë yi ‑bha ‑blaan ‑nu 'ka a?» ");
INSERT INTO dnj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","'Ö to mü ‑a mɛ do ‑yö slabhomɛ ‑nu ‑gɔmɛ ꞊va ‑bha yuökëmɛ zë ‑blaan 'ka, 'ö‑ ꞊kwɛɛ‑ 'gü 'tonëga ‑kan. ");
INSERT INTO dnj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'Ö Yesu ‑ya pö: «Ü ꞊kwaa' ‑a ‑zü, 'wun mɛ bhë ‑yö 'to 'dhö!» 'Ö Yesu ‑yö pa gɔɔn‑ bhë ‑a 'to 'ka 'yö‑ bo. ");
INSERT INTO dnj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö slabhomɛ ‑nu ‑gɔmɛ ‑nu, ‑Zlan ‑bha 'kɔ ‑maakëmɛ ‑gɔmɛ ‑nu, waa‑ mɛ ziizii ‑nu, 'wo nu ‑a 'kun ꞊dhia bhë ‑an ‑dhë: «‑Më 'ö ‑kë 'ka nu n ‑gɔ ‑blaan waa‑ 'lü 'klu ‑nu 'ka ꞊nɛ ꞊dhɛ 'wo‑ pö ‑a ‑bha 'kpa 'wunyaakëmɛ ‑mü n 'ka ‑a 'dhö e? ");
INSERT INTO dnj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","‑Dhɛkpaɔyi 'saadhö a ‑kë ka 'piö ‑Zlan ‑gɔ kɔɔ, 'ö kaa n ꞊mɛɛ' 'iin kaa n 'kun; 'kɛɛ yi 'ö ꞊nɛ 'ö tɔɔ yi 'ö ‑Zlan ‑ya ‑ya kö 'kaan‑ n kuën, ‑yö ‑dhɛtiidhɛ ‑bha 'piigbeedhɛ ‑zɔn ‑yi 'ka 'pö.» ");
INSERT INTO dnj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","‑Wo Yesu ‑kun 'wo dhoë slabhomɛ ‑gɔmɛ ꞊va ‑gɔ kɔɔ. Piɛɛ ‑yö ‑ziö ‑an 'piö ‑gɛntozlöödhe 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","‑Wo 'siö 'gba ‑ya 'kwɛandhɛ bhë ‑a ziëndhɛ gia‑ ‑bha. Piɛɛ ‑yö ‑kë mɛ ‑nu 'wo ‑kë ‑ya 'siö ‑blü ꞊dhia mü bhë ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yuökëdhe do ‑ya ‑yö kö ‑yö ‑ya ‑sü 'ka 'siö 'piö. ꞊Dhɛ 'ö‑ 'yan ꞊ya ‑da Piɛɛ ‑ta, 'ö‑ pö: «Gɔɔn‑ 'ö ꞊nɛ ‑yö ‑kë ‑a 'piö 'pö!» ");
INSERT INTO dnj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'Ö Piɛɛ ‑yö ꞊kploo 'ö‑ pö: «Dhebɔ, mɛ 'ü 'we ‑na ‑a 'ka bhë 'maa‑ dɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","꞊Dhɛ 'ö‑ ‑dhɛ pë 'tee ꞊ya ꞊glɔɔ, 'ö mɛ do 'bhaa 'yan ‑yö ‑da Piɛɛ ‑ta, 'yö‑ pö: «Bhi ‑de 'pö, ‑a ‑bha mɛ do ‑mü ü 'ka!» 'Ö Piɛɛ ‑ya pö gɔɔn‑ bhë ‑a ‑dhë: «‑Abi', 'maa ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","꞊Dhɛ 'ö pë 'yö ‑mɔ 'lɛlɛ do ‑bha ꞊ya ziö, 'ö mɛ do 'bhaa ‑yö pë do bhë 'ö‑ pö ‑wo 'gbee‑ 'ka ꞊nɛɛ: «'Wun gia‑ 'ka, gɔɔn‑ 'ö ꞊nɛ ‑yö ‑kë ‑a 'piö 'pö, bhii Galile mi ‑mü ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'Ö Piɛɛ ‑ya ‑daa ‑kë 'ö‑ pö: «Gɔɔn‑ ꞊nɛ, pë 'ü‑ ꞊blɛɛ' ‑na bhë 'wun gia‑ 'yaa ‑mü!» ‑Yö ‑to 'wun ꞊blɛɛ' ꞊dhia 'ö ‑tɔgɔn ‑yö ‑we. ");
INSERT INTO dnj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","'Ö Dëmɛ ‑yö ꞊dhië ö ‑zü 'ö Piɛɛ ‑ga piindhö. 'Ö Piɛɛ ‑zo ‑yö ‑büö Dëmɛ ‑wo 'ö‑ pö ‑a ‑dhë 'dhiö bhë ‑a 'ka ꞊nɛɛ «‑a kë ‑yi 'ka gbeng do 'ö ꞊nɛ ‑a 'gü kö ‑tɔgɔn ‑yaan 'we, ü ‑dho ‑a pö ‑gwaa ‑yaagazë ꞊nɛ 'bhaa n dɔ» 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","'Ö Piɛɛ ‑yö yö plaan 'gbo 'yenazë bɔ ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mɛ ‑nu 'wo wo 'yan ‑kë Yesu ‑bha bhë, ‑wo 'yee ‑nu ‑to ‑a ‑bha 'wo‑ ‑ma ‑nu wo, ");
INSERT INTO dnj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","'Ö 'wo sɔ ‑klu ‑a 'yan ‑bha 'wo‑ ꞊dhɛɛ' kpɔ 'wo‑ pö: «Mɛ 'ö ü ma bhë, ‑bhöë 'tɔ pö!» ");
INSERT INTO dnj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'Go mü 'wo 'si ‑nu bho ‑a ‑gɔ ꞊plëëzë 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","꞊Dhɛ 'ö ‑dhɛ ꞊ya 'po, Zuifö ‑nu ‑bha mɛ ziizii ‑nu 'wo 'sɛgɔ bhë 'wo‑ 'gü, slabhomɛ ‑gɔmɛ ‑nu waa‑ tɔnggɔmɛ ‑nu ‑wo ‑dho wo 'kuë‑ do 'wo‑ pö ‑wo 'dho Yesu 'ka zakanmɛ ꞊vava 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","'Ö 'wo yö Yesu ꞊dhɛɛ' 'kpɔ ‑sü ‑bha 'wo‑ pö: «꞊Ya kë ꞊nɛ ‑Zlan ‑bha ‑Yamɛ ‑mü ü 'ka, ‑bhö ‑a ꞊blɛɛ'‑ yi ‑dhë!» 'Ö Yesu ‑ya pö ‑an ‑dhë: «'Ö ꞊ya kë ꞊nɛ 'ma‑ pö ka ‑dhë ꞊ii‑, ka 'ka 'dhoë‑ ‑dhɛ 'wun gia‑, ");
INSERT INTO dnj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","'iin 'ma ꞊dhɛɛ' do 'kpɔ ka ‑gɔ 'wun 'ö ꞊nɛ ‑a ‑wun 'gü, ka 'ka 'dho ‑a ‑daa kë n ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","'Ö sü ꞊dɛɛ ‑bha, ma 'a Mɛgbö 'ka, n ‑ya ‑sü ‑mü ‑Zlan 'piigbeezë ‑bha ‑yadhɛ ꞊bhlëzë ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","꞊Dhɛ ‑kë 'dhö 'yö ‑an 'plɛ ‑wa pö ‑a ‑dhë: «꞊Ya kë 'dhö kö ‑Zlan Gbö ‑mü ü 'ka a?» 'Ö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «꞊Ii‑, ‑a Gbö ‑mü n 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","꞊Dhɛ ꞊ya kë 'dhö, 'wo‑ pö: «꞊Aa! Kwa gia‑ 'kwa‑ ‑de ‑wo ma; kwa 'ka 'dho ꞊goo‑ gbɛ ꞊mɛɛ' gbɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","꞊Dhɛ ‑kë 'dhö mɛ ‑nu 'wo dho wo 'ko ꞊bhaa bhë ‑wo ‑luu 'wo dho Yesu 'ka Pilatö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","꞊Dhɛ 'wo ‑lo, 'wo yö 'wun ‑dɔ ‑a ‑bha ‑sü ‑bha ‑a pö ‑sü 'ka ꞊nɛɛ: «Gɔɔn‑ 'ö ꞊nɛ, yi‑ ‑yö kö ꞊ya kwaa‑ wɔ ‑kɔ 'plɛ bho zian; ‑ya ‑pö mɛ ‑nu ‑dhë kö ꞊kun 'wo 'nii‑ ꞊sɔnng' bho ‑gludë Sezaa ‑dhë 'iin 'go mü ‑ya ‑pö yö gia‑ 'ö tɔɔ ‑Zlan ‑bha ‑Yamɛ 'ö ‑gludë 'ka.» ");
INSERT INTO dnj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","'Ö Pilatö ‑ya ꞊dhɛɛ' kpɔ 'ö‑ pö: «Zuifö ‑nu ‑bha ‑gludë ‑mü ü 'ka a?» 'Ö Yesu ‑ya ‑daa ‑kë 'ö‑ pö: «꞊Ii‑.» ");
INSERT INTO dnj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","꞊Dhɛ ꞊ya kë 'dhö, Pilatö ‑ya ‑pö slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ mɛ gbung 'wo bhë ‑an ‑dhë: «Mɛa‑, 'wun yaa 'ö mɛ 'ö ꞊nɛ dho ‑a kë kö ‑yaan kë ‑a 'klo bhɔ ‑gɛn 'ka 'yaa 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Kɛɛ ‑wo ‑yö 'wun ꞊blɛɛ' ‑sü 'gü ‑wo ꞊faan' 'ka 'wo‑ pö: «꞊Ya 'sɛgümɛ ‑nu ‑blü dɔ 'yënng ‑sü 'ka ö bha mɛ ꞊daan' ‑wo bhë ‑a 'ka, ‑ya zü ‑dɔ Galile 'ö bɔ ‑a 'ka Zude 'sɛgɔ 'saadhö 'gü, ö ꞊ga 'ö ꞊ya nu ꞊ya ꞊loë' zö bhë.» ");
INSERT INTO dnj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","꞊Dhɛ 'ö Pilatö ꞊ya ‑an ‑wo ma, 'yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «Gɔɔn‑ ꞊nɛ Galile mi ‑mü ‑a?» ");
INSERT INTO dnj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","'Ö ꞊dhɛ 'ö ꞊yaa‑ ma ꞊nɛ ‑yö go 'pian 'ö Elɔdö ‑ya ꞊kɔɔn bhë ‑a 'ka, 'ö‑ bɔ Elɔdö 'yö ‑kë Zeluzalɛmë 'töng 'ö 'dhö bhë ‑a 'ka bhë ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Elɔdö ꞊zuö' 'glu ‑yö ‑dhi kö waa‑ Yesu ‑waan ‑kpën wo 'kuë‑, bhii 'ö tɔɔ ‑yö Yesu 'tɔ ‑ma 'ö‑ ‑dhɛ ꞊ya ꞊glɔɔ. ‑Ya ‑ya ꞊zuö' 'piö kö ‑yaan ‑kpën ‑a ‑bha, ‑yö kë 'dhö kö ‑yaan ‑dhidhaapë do kë ö 'yaan 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","'Ö ꞊dhɛɛ' ꞊plëëzë kpɔ ‑a ‑gɔ, 'kɛɛ Yesu yaa‑ gbɛ ‑daa kë. ");
INSERT INTO dnj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Slabhomɛ ‑gɔmɛ ‑nu waa‑ Zuifö ‑nu ‑bha tɔnggɔmɛ ‑nu 'wo ‑kë mü, ‑wo ‑kë 'wun dɔ ꞊dhia Yesu ‑bha 'gbee‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Elɔdö waa‑ ö bha 'dhasi ‑nu ‑wo 'yan ꞊ziö' ꞊kaa', 'wo lë‑ ‑kpɔ ‑a ‑ta. ꞊Dhɛ 'ö ꞊wa sɔ do 'gianzë ‑së ‑da ‑a ‑bha, 'yö 'wo‑ bɔ Pilatö ‑dhë 'zü. ");
INSERT INTO dnj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Yi gia‑ 'ö bhë ‑a 'ka, 'ö Elɔdö waa‑ Pilatö 'wo kaa 'bhazë 'ka, 'kɛɛ 'dhiö ‑bezë, ‑siödhe ‑kë ‑an ziën. ");
INSERT INTO dnj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatö ‑yö slabhomɛ ‑gɔmɛ ‑nu, 'dhiö ‑sü mɛ 'ka ‑mɛ ‑nu, waa‑ 'sɛgümɛ ‑nu ‑an 'plɛ ꞊dhɔɔ ‑kë wo 'ko ꞊bhaa, ");
INSERT INTO dnj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","'yö‑ pö ‑an ‑dhë: «Gɔɔn‑ 'ö ꞊nɛ ka‑ ‑kun 'ka nuë n ꞊dhia, 'ö 'ka‑ pö ꞊nɛɛ ꞊ya 'sɛgümɛ ‑nu bho zian ‑ta, 'kɛɛ n dë, ‑a ꞊dhɛɛ' 'a‑ ‑kpɔ ka 'plɛ ka wö 'dhiö ꞊nɛ pë yaa 'yö dho ‑a kë kö ‑a ‑wun ‑yaan ‑lo ‑a tuö 'maa‑ yö ‑na. ");
INSERT INTO dnj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elɔdö ‑de 'pö yaa 'wun yaa gbɛ yö ‑a ‑bha. Pë ‑kë 'yö‑ bɔ kwa ‑dhë bhë. Kö gɔɔn‑ 'ö ꞊nɛ 'wun yaa gbɛ 'ö dho kë ‑a 'kun ‑gɛn ‑waan zë 'yaa 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","꞊Dhɛ 'ö 'dhö kö ‑yö ‑dho ‑ma ‑klaa 'ka kö 'aan‑ n ꞊kwaa'‑ ‑a ‑zü.» ");
INSERT INTO dnj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'Töng bhë ‑a 'ka, Paakö ‑yi 'saadhö 'ka, Pilatö ꞊dua' ‑mü kö ‑yö mɛ do bho ‑an ‑dhë ‑kanso 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'Yö ‑an 'plɛ ‑wo ‑gbla wo 'kuë ꞊nɛɛ: «Mɛ 'ö ꞊nɛ, ‑bhö ‑a zë 'ü Balaba ‑zë bho mü ꞊zian' yi ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba 'ö bhë ‑yö ‑dho ‑kanso 'gü dɔ 'yö‑ wo mɛ ‑nu ‑gɔ 'yënng pö‑ do 'gü waa‑ mɛ zë 'yö‑ wo bhë ‑an ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","꞊Dhɛ kë ꞊nɛ Pilatö ‑ya ‑kë kö 'yö ö ꞊kwaa' Yesu ‑zü bhë, 'yö 'wun ꞊blɛɛ 'zü ‑dëüwo mɛ gbung 'wo bhë ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'Kɛɛ ‑an 'plɛ ‑wo ‑we ‑a 'piö 'gbla ‑sü 'ka 'wo‑ pö: «‑Bhö ‑a dɔ ‑gaatalü ‑bha! ‑Bhö ‑a dɔ ‑gaatalü ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","'Ö Pilatö ‑ya pö ‑an ‑dhë ‑gwaa kë ‑yaagazë ꞊nɛɛ: «Pë yaa ‑mlë 'ö‑ ‑kë ‑ɛ? 'Wun yaa gbɛ 'ö dho kë ‑a zë ‑gɛn 'ka, 'maa‑ yö ‑na. A ‑dho ‑a kë 'wo‑ ‑ma ‑klaa 'ka kö 'aan‑ n ꞊kwaa'‑ ‑zü.» ");
INSERT INTO dnj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Kɛɛ ‑wa ‑pö ‑kplawo wo ‑wo 'gbee‑ 'ka ꞊nɛ Yesu ‑yö dɔ ‑gaatalü ‑bha. 'Ö ‑an ‑wo ‑yö dho 'ö to ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","'Ö Pilatö ‑yö ‑we ‑a ‑bha ‑an ‑gɔ kö pë 'wo‑ ‑dhɛ 'yaan‑ ‑a nu ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","'Ö gɔɔn‑ 'ö dɔ 'yënng 'go mü 'yö mɛ zë 'wo‑ 'tɔ pö bhë 'yö ö ꞊kwaa‑ ‑zü, 'yö Yesu dɔ ‑an kwɛɛ kö pë 'yö ‑dhi ‑an ‑dhë ‑waan kaa. ");
INSERT INTO dnj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","꞊Dhɛ 'wo 'dho ‑na Yesu 'ka, ‑wo ‑kpën mɛ do 'wo‑ ‑dhɛ Simɔ 'ö go Silɛnë ‑a ‑bha kö ‑yö 'go ‑na ꞊bhlöö‑; 'wo‑ kun 'gbeetadhɛ 'ka 'ö Yesu ‑dɔ ‑a ‑ta ‑lü bhë 'wo‑ nu ‑a ‑dhë kö ‑ya bun ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mɛ ‑gbaa ꞊va ‑wo ‑ziö ‑a 'piö, 'ö dhoo ‑nu 'wo ‑kë ‑an 'piö 'wo 'gbo bɔ wo ‑de ꞊maa 'ma ‑sü 'ka Yesu ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu ‑yö ꞊dhië dhoo ‑nu bhë ‑an 'piö, 'yö‑ pö ‑an ‑dhë: «Zeluzalɛmë dhoo ‑nu, kö ꞊kun 'ka 'gbo bɔ n ‑wun 'gü! ‑Ka 'gbo bɔ ꞊zian' ka gia‑ waa‑ kaa‑ 'në ‑nu ka ‑wun 'gü, ");
INSERT INTO dnj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","bhii yi ‑nu ‑wo ‑dho nu, 'ö 'töng 'dhö bhë ‑a 'ka mɛ ‑nu ‑dhoë pö: ‹Dhoo ‑nu 'wo 'bhüödhe 'ka 'ö waa 'në 'kpɔ 'ö waa 'yɔn ‑da 'në 'dhii ‑an 'glu ‑yö dhi!› ");
INSERT INTO dnj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","‑A yi 'ö 'dhö bhë ‑a 'ka, mɛ ‑nu ‑wo ‑dho ‑a pö ‑tɔn ‑nu ‑dhë: ‹‑Ka ‑püö yi ‑ta zö!› 'Wo‑ pö 'zü goo ‑nu ‑dhë: ‹‑Ka yi ‑ta ‑kpa!› ");
INSERT INTO dnj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bhii 'wun ꞊suu'‑ ꞊nɛ ‑a kë 'wo‑ wo ‑na 'lü ‑saa 'ka ꞊nɛ kö 'lü 'kpɛazë, ‑më wo 'ka 'dho kë ‑a 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","‑Wo ‑kë 'dho ꞊dhia gɔɔn‑ ‑nu ꞊plɛ këpëyaazë 'ka, 'wo ‑an kpa Yesu ‑bha kö ‑waan ‑an zë 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","꞊Dhɛ 'ö ꞊wa ‑lo ‑dhɛ 'wo‑ ‑dhɛ «mɛ ‑gɔ ‑klëë» ‑a ‑bha, 'wo Yesu dɔ ‑gaatalü ‑bha, 'wo ꞊taan ‑gban ‑a ‑kɔ ‑nu waa‑ ‑a ‑gɛn ‑nu ‑ta. ‑Wo këpëyaamɛ ꞊plɛ 'wo bhë ‑wo ‑an ‑dɔ ‑gaatalü ‑bha 'pö, ‑a mɛ do ‑yö ‑kë ‑a ꞊kwɛɛ‑ 'gü, 'ö‑ mɛ do ‑yö dɔ ‑a ꞊kwaa‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","'Ö Yesu ‑ya pö: «N Dë, ‑bhö ü ‑zo bho ‑an ‑bha ꞊sɔɔn yaa ‑nu 'piö, bhii pë ‑nu 'wo‑ kë ‑na bhë 'waa‑ dɔ wo ‑de ‑gɔ.» 'Wo‑ ‑bha sɔ ‑glu wo 'kuë 'töü‑ ‑bhö ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mɛ ‑nu ‑wo ‑kë mü ‑a ‑ga ‑sü 'gü, 'ö Zuifö ‑nu ‑gɔmɛ ‑nu ‑wo yö duö 'luu ‑sü ‑a ‑bha ‑sü 'gü, 'wo‑ pö: «Yö 'ö mɛ 'waa ‑nu dha ꞊nɛ, ꞊ya kë ꞊nɛ ‑Zlan ‑bha ‑Yamɛ 'ö‑ sü yö ‑mü ‑a 'ka kö ‑yö ö ‑de dha 'pö ee!» ");
INSERT INTO dnj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","'Dhasi ‑nu ‑de 'pö ‑wo duö 'luu ‑sü ‑a ‑bha, 'wo ‑drɔɔn ꞊gliisü 'yi sü 'wo ꞊yɔɔn ‑a 'ka, ‑a 'dhi 'sɔɔ, ");
INSERT INTO dnj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","'wo‑ pö ‑a ‑dhë: «'Ö ꞊ya kë ꞊nɛ Zuifö ‑nu ‑bha ‑gludë ‑mü ü 'ka, ‑bhö ü ‑de dha 'kwa‑ ‑ga!» ");
INSERT INTO dnj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","‑A ‑gɔ ‑ta dhuö ‑gaatalü ‑bha, pë 'wo‑ ꞊bɛɛn 'ö tɔɔ: «Mɛ ꞊nɛ 'ö tɔɔ Zuifö ‑nu ‑bha ‑gludë». ");
INSERT INTO dnj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Këpëyaamɛ ‑nu 'wo ‑an dɔ ‑gaatalü ‑bha bhë 'yö‑ mɛ do ‑yö ö 'dhi sü Yesu 'gü 'ö‑ pö: «Ü 'ka‑ pö ‑Zlan ‑bha ‑Yamɛ ‑mü ü 'ka a? ‑Bhö ü ‑de dha 'ü yi dha 'pö ee!» ");
INSERT INTO dnj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","'Yö‑ mɛ do ‑yö 'wun ‑blɛɛ ö 'bhamɛ bhë ‑a 'ka 'yö‑ pö ‑a ‑dhë: «Bhi 'ö 'klobhɔdhe do bhë 'ü‑ 'gü ꞊nɛ ‑a 'dhö, 'suö 'yaa ü kë ‑Zlan ‑dhë ‑a? ");
INSERT INTO dnj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ko ‑bha 'ka, koë‑ 'klobhɔdhe ‑yö ko ‑ma ‑kun, bhii 'ö tɔɔ pë ‑nu 'ko‑ ‑kë bhë 'ko‑ ꞊truën yö ‑na bhë; 'kɛɛ yö ‑zë, yaa pë yaa gbɛ kë.» ");
INSERT INTO dnj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö Yesu ‑dhë: «Yesu, ü ‑zo ‑yö ‑büö n 'ka 'töng 'ü 'dhoë‑ nuë ü bha 'tɔbhɔdhe 'gü bhë ‑a 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «A‑ ‑pö ü ‑dhë 'wun gia‑ 'ka: ‑Dhɛkpaɔyi gia‑ 'ö ꞊dɛɛ ꞊nɛ ‑a 'ka, 'ü dho kaa n 'piö 'tɛɛpadhɛ 'ö ‑Zlan 'piö ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","꞊Dhɛ 'ö lan‑ ꞊ya dɔ 'dhëë ziën, 'ö‑ ‑bha 'bhü ‑sü ‑yö ꞊gbaannu, 'ö ‑dhɛ ‑yö ‑trö 'sɛ ‑ta 'ö dho 'ö yöë 'wɔ 'yɛ ‑lan ‑bha; 'yö ‑dun 'kɔdhi ‑bha ‑sɔ 'ö ‑kë ‑Zlan ‑gɔ kɔɔ bhë 'yö ‑pɛ ziën. ");
INSERT INTO dnj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","'Ö Yesu ‑yö ‑gbla ‑wo 'gbee‑ 'ka 'ö‑ pö: «N Dë, 'ma n nii ‑lo ü kwɛɛ!» ꞊Dhɛ 'ö ꞊ya ö bo ‑wo 'ö bhë ‑a pö ‑sü 'ka, 'ö‑ ‑bha 'të ‑sü ‑yö ꞊gbaannu. ");
INSERT INTO dnj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","꞊Dhɛ 'wun bhë 'dhasi ‑gɔmɛ ꞊yaa‑ yö, 'ö yö ‑Zlan 'tɔ 'saa ‑blü ‑sü ‑bha 'ö‑ pö: «'Wun gia‑ 'ka, gɔɔn‑ 'ö ꞊nɛ 'wun 'kpaan 'wo‑ dɔ ‑a ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","'Ö mɛ ‑gbaa 'wo kë mü bhë 'ö 'wun ‑nu bhë 'ö ‑kë ‑an 'yaan. ꞊Dhɛ 'go mü, ‑wo ‑yɛ wo 'zü 'wo dho wo ‑gɔ kɔɔ wo ‑tong ‑ta ‑ma ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu 'bhamɛ ‑nu waa‑ dhoo ‑nu 'wo ‑kë ‑a 'piö kö ‑yö Galile bhë, ‑wo ‑dɔ ꞊gbiin 'ö pë ‑nu 'wo ‑kë bhë 'wo ‑an yö. ");
INSERT INTO dnj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mɛ do ‑yö ‑kë mü, 'wo‑ ‑dhɛ Zozɛfu 'yö go Zuifö ‑pö do 'wo‑ ‑dhɛ Alimate ‑a 'gü. Mɛ 'ö bhë ‑yö ‑kë mɛ këwunsëëzë 'ö kpengdhö ‑a 'ka 'ö dɔ mɛ 'ö ‑Zlan ‑ya ‑ya Mɛdhamɛ 'ka, ‑a ‑bha nu ‑sü ‑gɔ. ‑Yö ‑kë zakanmɛ ‑nu ꞊vava bhë ‑an mɛ do 'ka, 'kɛɛ ‑a ‑wo yaa kë zakanmɛ ‑nu 'wo 'dhö ‑an ‑wo 'yö kpɔ 'wun 'ö bhë ‑a kë ‑sü ‑bha bhë ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'Ö ‑ziö 'ö dho Pilatö 'piö, 'ö Yesu ꞊glöö ‑dhɛ ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ꞊glöö bho ‑gaatalü ‑bha, 'ö sɔ do ꞊ploo ‑a 'ka 'ö‑ sü 'yö‑ ‑da ‑guö ‑du do 'ö 'pɔn ‑sü 'ka, 'ö waa mɛ ꞊glöö gbɛ ‑da mü do ꞊kun ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","‑Yö ‑kë Zuifö ‑nu ‑bha ꞊glooyi ‑waamayi 'ö ‑an ‑bha ꞊glooyi züdɔyi 'ka bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Dhoo ‑nu mɛ 'wo go Galile ‑sɛ 'gü 'wo ‑ziö Yesu 'piö bhë, ‑wo ‑ziö Zozɛfu 'piö, 'wo ‑dhɛ ‑ga ‑glu 'ö bhë ‑a 'gü, 'ö ‑kɔ 'ö Yesu ꞊glöö ‑yö ꞊wɔa' bhë 'wo‑ yö. ");
INSERT INTO dnj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","꞊Dhɛ ꞊ya kë 'dhö, 'wo nu wo ꞊plöö 'wo 'yɔn ‑nu, pë 'yi 'tëë ‑sëëzë ‑nu ‑pë ‑kë kö 'waan‑ ‑lo Yesu ꞊glöö ‑ta. 'Ö ꞊glooyi 'ka 'wo wo 'tɛɛ pa ꞊nɛ ‑kɔ 'ö ‑an ‑bha tɔng 'dhö ‑a 'ka ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","꞊Dhɛ Zuifö ‑nu ‑bha ꞊glooyi ꞊ya ziö, ‑dhɛkpaɔyi mɛ 'ö yö ‑a 'piö bhë ‑a ‑dhiadhiö tii 'gü, dhoo ‑nu 'wo bhë ‑wo ‑dho ‑a blɔɔn‑ ꞊taa; ‑wo ‑dho 'yɔn ‑nu, pë 'yi 'tëë ‑sëëzë ‑nu, 'wo‑ ‑yuö ‑kë bhë ‑a 'ka; ");
INSERT INTO dnj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","'yö ꞊dhɛ ꞊wa ‑lo 'ma, 'wo ‑guö 'fa 'yö yö ‑glu bhë ‑a 'dhiö bhë 'wo‑ yö kö ꞊ya 'go ‑glu 'dhi 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'Ö 'wo ‑da ꞊gluudhö mü, 'kɛɛ waa Dëmɛ Yesu ꞊glöö yö. ");
INSERT INTO dnj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","꞊Dhɛ 'ö ꞊wa ‑dhɛ ‑ga 'wun bhë ‑a 'gü 'sengdhö 'ö 'waa‑ 'slë gbɛ yö ‑na wo ‑de ‑gɔ, 'ö gɔɔn‑ ‑nu ꞊plɛ 'ö sɔ 'bhü ‑sü 'dhö ‑an ‑bha bhë, 'wo ‑wo ‑an 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","'Ö 'suö ‑yö ‑da ‑an 'gü, 'ö 'wo wo ‑gɔ ‑gblü 'sɛi. 'Ö gɔɔn‑ ‑nu 'wo bhë 'wo‑ pö ‑an ‑dhë: «‑Më ‑kë 'ö mɛ 'ö 'bhee‑ 'ka‑ ꞊mɛɛ gamɛ ziën ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Yaa zö gbɔ ꞊ya 'go ga 'gü, ka ‑zo ‑yö ‑büö 'wun 'ö‑ ꞊blɛɛ ka ‑dhë kö ‑yö ꞊tun Galile bhë ‑a 'ka. Kë‑ wo bhë ‑ya pö: ");
INSERT INTO dnj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mɛgbö ‑dho dɔ 'wunyaakëmɛ ‑nu kwɛɛ kö ‑wa dɔ ‑gaatalü ‑bha. 'Go mü kö ‑yaan 'go ga 'gü ‑dhɛkpaɔyi kë ‑yaaga ‑naa 'ka!» ");
INSERT INTO dnj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","꞊Dhɛ ꞊ya kë 'dhö, 'yö ‑an ‑zo ‑yö ‑büö Yesu ‑wo 'ö bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","'Ö 'wo go ‑glu bhë ‑a 'gü, 'wo dho 'wo‑ ꞊blɛɛ ꞊guë' ‑nu 'gɔɔ‑ do ö ga do 'wo bhë waa‑ mɛ 'bhaa ‑nu 'wo to ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Dhoo ‑nu 'wo bhë 'wo tɔɔ Mali 'ö go Madala 'dhö, Zanë 'dhö waa‑ Mali Zakö dhe 'dhö, 'iin dhoo ‑nu 'bhaa ‑nu 'wo ‑kë ziö ꞊dhia ‑an 'piö bhë, wo 'plɛ 'wo 'wun 'ö ꞊nɛ 'wo‑ ꞊blɛɛ Yesu ‑bha bɔmɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","'Kɛɛ 'yö ‑kë ‑a ‑bha bɔmɛ ‑nu ꞊zuö' 'piö ꞊nɛ pë 'kpaandhö, waa ‑an ‑wo ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'Ö Piɛɛ ‑yö ꞊luu 'ö dho ‑bla 'ka blɔɔn‑ ꞊taa 'ma, 'yö ꞊kloo ö ‑dhɛ ‑ga kö sɔpɛn 'wo‑ ꞊ploo Yesu 'ka bhë ‑a 'flëë ꞊nɛ 'ö mü. 'Yö ‑yɛ ö 'zü 'yö nu ö ‑gɔ kɔɔ 'tetundhe ꞊va 'ka, pë 'yö ‑kë bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yi gia‑ bhë ‑a 'ka 'ö Yesu ‑bha ꞊guë' ꞊plɛ ‑wo ‑da zian 'ö dho Emaisö plöö ‑dhɛ 'ö 'go mü 'dho Zeluzalɛmë 'yö dho ‑mɔ 'kilong 'gɔɔ‑ do ö ga do ‑bha bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","‑An ‑bha 'dho ‑sü 'ka, 'wun ‑nu 'wo ‑kë 'saadhö bhë, ‑wo kë ‑a ‑ta 'dɔɔ dɔ ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","‑Wo ‑to 'wun ꞊blɛɛ' ꞊dhia, 'ö Yesu gia‑ ‑yö ‑yɔɔn ‑an ‑bha 'ö 'wo 'ta ‑da ‑bhüö 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","‑Wa ‑yö, 'kɛɛ pë do 'bhaa ‑ya ‑kë 'ö waa‑ dɔ ‑a ‑bha ‑kë Yesu 'ka ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'ö‑ pö: «‑Më ‑wun 'ö 'ka‑ ꞊blɛɛ' ‑na ka 'ko ‑dhë 'ka 'ta 'sü ‑sü 'ka ꞊nɛɛ?» 'Ö mɛ ꞊plɛ 'wo bhë, ‑an ꞊zuö' ‑yö ‑da 'yena 'gü, 'yö 'wo ꞊gbaannu. ");
INSERT INTO dnj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","'Ö‑ mɛ do 'wo‑ ‑dhɛ Kleopa bhë 'yö‑ pö ‑a ‑dhë: «Ü ‑dho kë do 'ö Zeluzalɛmë plöö, 'ö pë ‑nu 'wo kë yië ꞊plɛ ꞊nɛ 'ö 'bhaa‑ ꞊tɛi' dɔ ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","'Yö‑ pö ‑a ‑dhë: «‑Më ‑wun ‑nu 'wo ‑kë ‑ɛ?» 'Ö 'wo‑ pö ‑a ‑dhë: «Pë 'ö ‑kë Yesu 'go Nazalɛtë 'yö ‑kë ‑Zlan ‑wodhiölomɛ 'piigbeezë 'ka ö bha yuö ‑nu waa‑ 'wun ꞊blɛɛ' ‑wo ‑nu 'gü ‑Zlan waa‑ 'sɛgümɛ ‑nu ‑an 'dhiö bhë 'bhaa‑ dɔ ꞊a? ");
INSERT INTO dnj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yi ‑bha slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'dhiö ‑sü yi 'ka ‑mɛ ‑nu ‑wa ‑kun 'wo‑ dɔ 'sɛ ꞊kɔɔnmɛ ‑nu kwɛɛ 'wo‑ zë ‑a ‑dɔ ‑gaatalü ‑bha ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yi yi ‑zo ‑gɔn ‑be ꞊nɛ, mɛ 'ö dho Izlaɛlö bho 'gan 'gü 'yö ‑mü ‑bezë; 'kɛɛ ꞊dhɛ pë ‑nu 'wo bhë 'wo ‑kë ꞊nɛ ‑a ‑dhɛkpaɔyi ‑yaaga 'ö ꞊nɛ. ");
INSERT INTO dnj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","'Ö dhoo ‑nu 'bhaa ‑nu 'wo yi 'piö 'wo yi dɔ ‑gbɔudhö 'zü ꞊nɛɛ, 'ö bhii ꞊dhɛ ꞊wa ‑so ‑dhiadhiö tii 'gü ꞊wa 'dho ‑a blɔɔn‑ ꞊taa, ");
INSERT INTO dnj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","waa‑ ꞊glöö yö; 'yö 'wo nu 'wo‑ pö yi ‑dhë wo ‑Zlan ‑bha bɔmɛ ‑nu ‑yö, 'ö 'wo‑ pö wo ‑dhë ꞊nɛ ꞊ya 'go ga 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yö do bhë 'zü, gɔɔn‑ 'bhaa ‑nu 'wo yi kpö 'gü ‑wo dho 'wo ‑lo ‑a blɔɔn‑ ꞊taa 'ma 'ö pë ‑nu 'wo bhë 'wo‑ yö ꞊nɛ ‑kɔ 'ö dhoo ‑nu ‑wa ꞊blɛɛ ‑a 'ka bhë ‑a 'dhö, 'kɛɛ Yesu 'pö waa‑ yö.» ");
INSERT INTO dnj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «'Oo gɔɔn‑ ‑nu 'ö 'wunbhokoudɔdhe gbɛ 'yaa ‑an ‑gɔ, 'ö pë ‑nu 'ö ‑Zlan ‑wodhiölomɛ ‑nu 'dho ‑a ꞊blɛɛ' ‑na, 'ö 'kaa‑ ‑dhɛ 'wun gia‑ 'siö‑! ");
INSERT INTO dnj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","'Yaa 'dhö ꞊nɛ ‑Zlan ‑bha ‑Yamɛ 'yënng ‑dho bhɔ ‑yaan ꞊tun ‑da ‑na ö ‑bha 'tɔbhɔdhe 'gü a?» ");
INSERT INTO dnj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","꞊Dhɛ ꞊ya kë 'dhö, 'ö 'wun 'ö ‑gban ö ‑bha 'ö ꞊bɛɛn' ‑sü 'ka 'ö‑ zü ‑yö dɔ Moizö ‑bha 'sëëdhɛ 'gü 'ö dho 'ö yöë ‑Zlan ‑wodhiölomɛ ‑nu 'saadhö ‑an ‑bha 'sëëdhɛ ‑be ‑bha, 'yö‑ ‑gɛn pö ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","꞊Dhɛ 'ö 'wo ꞊yɔɔn ‑na pödhɛ 'wo 'dho ‑na ‑a 'gü bhë ‑a 'sɔɔ, 'ö Yesu ‑ya kë ꞊nɛ mɛ 'ö 'dhoë‑ pödhɛ gbɛ 'gü ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","'Yö 'wo‑ ‑gban ‑a ‑bha 'wo‑ pö ‑a ‑dhë: «‑Bhö 'to yi 'piö, lan‑ ꞊ya ‑püö 'saadhö, 'bin ꞊ya bhɔ 'më ‑sü ‑bha!» 'Ö to ‑an 'piö 'wo dho ‑an ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","꞊Dhɛ ꞊wa 'dho pë ‑bhö ꞊dhia, 'ö ꞊bluu'‑ sü, 'yö ‑Zlan zuö pö ‑a ‑ta, 'yö‑ 'klu kan 'ö‑ nu ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","꞊Dhɛ ꞊ya kë 'dhö, 'ö ‑an 'yan 'dhi ‑yö ‑po, 'ö 'wo‑ dɔa Yesu 'ka. 'Yö to mü 'yö ꞊dhɔng ‑an wö 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","'Wo yö ‑a ‑pö wo 'ko ‑dhë ‑sü ‑bha ꞊nɛɛ: «Pë ‑nu 'wo ꞊bɛɛn' ‑sü 'ka, ꞊dhɛ 'ö ‑an ‑gɛn pö ‑na ko ‑dhë zian ‑gbloo 'piö ꞊sia bhë, pë 'ö ‑kë ꞊nɛ ꞊zuögludhi 'dhö ‑a 'siö ‑yö ‑ya n ꞊zuö' 'gü, (꞊yaa‑ kë ü ‑gɔ 'dhö 'pö a)?» ");
INSERT INTO dnj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","꞊Dhɛ ꞊ya kë 'dhö, 'wo ꞊luu 'wo dho Zeluzalɛmë plöö, 'ö‑ ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga do 'wo bhë waa‑ wo 'bhamɛ ‑nu 'wo ‑an yö wo 'ko ꞊bhaa mü, ");
INSERT INTO dnj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'wo‑ pö mɛ ꞊plɛ 'wo bhë ‑an ‑dhë: «Dëmɛ ꞊ya 'go ga 'gü giagiawo, ‑yö ö ‑de ‑zɔn Simɔ ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","'Ö wo ‑de 'pö pë ‑nu 'wo ‑kë zian ‑gbloo 'piö waa‑ ‑kɔ 'wo Yesu dɔ ‑a 'ka kö ꞊ya ꞊bluu'‑ 'klu 'kan bhë, 'wo‑ ꞊blɛɛ ‑an ‑dhë 'pö. ");
INSERT INTO dnj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","‑Wo ‑to 'wun ꞊blɛɛ' ꞊dhia, 'ö Yesu gia‑ ‑yö ‑wo ‑an ziën mü, 'yö‑ pö ‑an ‑dhë: «꞊Zuöyagluu ‑yö kë ka ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","'Yö 'siö ‑yö ‑kan ‑an 'plɛ 'gluu, 'ö 'suö ‑yö ‑da ‑an 'gü, bhii pë 'ö ‑kë ‑an ꞊zuö' 'gü ‑bezë 'ö tɔɔ 'wa mɛ ‑zii yö. ");
INSERT INTO dnj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","'Ö Yesu ‑ya ‑pö ‑an ‑dhë: «‑Më ‑kë 'ö 'siö ‑yö ‑kan ka 'gluu i? ‑Më ‑kë 'ka dɔ 'dudhö ꞊e? ");
INSERT INTO dnj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","‑Ka n ‑kɔ ‑nu waa‑ n ‑gɛn ‑nu ‑an ‑ga 'dhɛ! ꞊Taanga pin ‑nu 'waa ‑mü ‑a? Ma gia‑ ‑mü! ‑Ka 'pa n 'ka, 'ka n ‑ga, bhii mɛ ‑zii kwi waa‑ ‑a ga 'waa ‑dhö ꞊nɛ ‑kɔ 'a‑ 'ka ꞊nɛ ‑a 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","'Wun bhë ‑ya ‑blɛɛ ‑an ‑dhë ö ‑kɔ ‑nu, ö ‑gɛn ‑nu ‑a ‑zɔn ‑an ‑dhë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","꞊Dhɛ 'ö‑ ꞊tɛi' dɔ ꞊nɛ ö ‑wun ‑dhɛ 'wun gia‑ ‑sü yaa kë ‑an ‑gɔ ‑së 'ka ꞊kun bhë, ꞊zuögludhi ꞊va waa‑ 'tetundhe 'yö ‑kë ‑an 'gü bhë ‑a ‑wun 'gü, 'yö‑ pö ‑an ‑dhë: «‑Bhöpë 'bhaa ‑yö ka ‑gɔ zö ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'Ö 'wo 'yuö‑ ‑pla ‑sü 'klu do nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","'Yö‑ sü 'ö‑ ‑bhö ‑an wö 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö ‑an ‑dhë: «Pë 'a‑ pö ka ‑dhë kö a ꞊tun ka 'piö yö ꞊ga 'ö ꞊nɛ: Pë 'yö ꞊bɛɛn' ‑sü 'ka n ‑wun 'gü tɔng 'ö Moizö ‑ya nu ‑a 'gü, ‑a mɛ 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑bha 'sëëdhɛ 'gü, ‑a mɛ 'ö 'Tan 'sëëdhɛ 'gü, ‑an 'plɛ 'dhiö ‑dho ‑mɔ 'kuë.» ");
INSERT INTO dnj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","'Ö ‑an ꞊zuö' 'dhi ‑po 'wunbhokoudɔdhe ‑gɔ kö ‑waan pë ‑nu 'wo ꞊bɛɛn' ‑sü 'ka bhë ‑an ‑gɛn dɔ. ");
INSERT INTO dnj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","'Ö‑ pö ‑an ‑dhë: «Pë 'yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü, yö kun tɔɔ: ‑Zlan ‑bha ‑Yamɛ 'yënng ‑dho bhɔ, 'ö ga, 'ö‑ ‑dhɛkpaɔyi kë ‑yaaga ‑naa bhë 'yö goë ga 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pë 'ö dho kë 'ö tɔɔ mɛ ‑nu ‑dho 'wuntaɔsë ꞊blɛɛ'‑ ‑a 'tɔ 'gü 'sɛgümɛ 'saadhö ‑an ‑dhë; ‑a zü ‑dho dɔ Zeluzalɛmë plöö ‑waan mɛ ‑nu ꞊dhɔɔ kë kö ‑waan wo ‑bha ‑kë ‑a 'gü ‑sü ꞊dhië' ‑Zlan 'piö kö ‑yaan ziö ‑an ‑bha ‑wun yaa ‑nu ‑ta. ");
INSERT INTO dnj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ka 'ka tɔɔ pë ‑nu 'wo ꞊nɛ ‑an ꞊goo‑. ");
INSERT INTO dnj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'Ö ma gia‑ 'a dho pë 'ö ‑Zlan ‑ya 'tɔ go ka ‑dhë bhë ‑a bɔ ka ‑dhë. 'Kɛɛ ‑ka 'to plöö zö ‑yö 'dho ‑yö yöë 'piigbeedhɛ 'ö go ‑Zlan 'piö ‑a ‑bha ‑yɔɔ ka ‑ta ‑yi ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö ‑an sü 'ö go ‑an 'ka plöö 'ö dho ‑an 'ka 'pian 'ö bɔ Betani ꞊zian' ‑a 'ka. ‑Dhɛ bhë ‑a ‑bha 'yö ö ‑kɔ ꞊luu 'ö 'dhuë‑ kpɔ ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","‑Yö ‑to 'dhuë‑ ‑kpɔ ‑an ‑bha ꞊dhia, 'ö go ‑an 'piö mü 'ö dho dhang‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wo 'pö ‑wa 'tɔ 'saa ‑blü, 'wo ‑yɛ wo 'zü, 'wo nu Zeluzalɛmë ꞊zuögludhi ꞊va 'ka; ");
INSERT INTO dnj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","‑wo ‑to zlöö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü ‑a 'tɔ 'saa ‑blü ‑sü 'ka.");
INSERT INTO dnj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","'Dhiö ‑blɛɛzë kö 'kpongtaadhɛ yaa kë ꞊kun, mɛ 'ö‑ 'tɔ ‑yö ‑kë ‑wo 'ka, ‑yö ‑kë ‑dhö. 'Yö ‑wo 'ö 'dhö bhë 'yö ‑kë ‑Zlan 'piö; kë‑ wo 'dhö bhë, ‑wo bhë ‑yö ‑kë ‑Zlan 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","꞊Ya kë 'dhö kö ‑wo 'ö bhë ‑yö ‑kë ‑dhö ‑Zlan 'piö 'kpa 'pë‑, ‑a züdɔyi 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","'Ö pë 'saadhö 'ö ‑Zlan ‑ya ‑da, ‑yö ‑bɔ ‑wo bhë ‑a ‑ta 'ö‑ 'plɛ ‑kë. Pë 'ö ‑Zlan ‑ya ‑da ‑yaan 'kun ‑a ‑kë ‑wo bhë ‑a 'ka ꞊süë' 'yaa 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","‑Wo 'ö bhë ꞊nɛ 'ö ‑këdhösü giagia 'dhoë‑ ‑gɔ; 'ö ‑këdhösü 'ö bhë 'pö, 'ö ‑kë mɛ 'bhee‑ ‑bha ‑dhɛpuudhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","'Kɛɛ kë‑ wo 'dhö bhë ‑dhɛpuudhɛ 'ö bhë ‑a 'bhü ‑yö ‑yö ‑dhɛtiidhɛ 'gü, 'yö mɛ ‑nu 'wo këdhɛ ‑dhɛtiidhɛ 'gü, waa 'we ‑a ‑wun ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","'Yö 'töng 'bhaa 'ka, 'yö ‑Zlan ‑yö gɔɔn‑ do bɔ. ‑A tɔɔ Zan; 'yö nu. ");
INSERT INTO dnj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Gɔɔn‑ bhë ‑yö ‑nu 'dhö kö ‑dhɛpuudhɛ 'ö bhë, 'wun 'ö ‑gban ‑a ‑bha, ‑yaan ‑tɔmɔdhe kë 'iin kö ‑a ꞊blɛɛ' ‑wun ‑bha, mɛ 'saadhö ‑waan ‑dhɛpuudhɛ 'ö bhë ‑a ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","'Kɛɛ kë‑ wo 'dhö bhë, yö gia‑ kun 'ö ‑kë ‑dhɛpuudhɛ 'ö 'dhö bhë ‑a 'ka; 'wun 'ö ‑gban ‑a ‑bha, yö ꞊nɛ 'ö‑ ꞊blɛɛ mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mɛ 'ö ‑dhɛpuudhɛ 'ka bhë, ‑dhɛpuudhɛ 'ö giagia, 'ö‑ ‑bha nu ‑sü 'ka, 'yö ‑dhɛ ‑po mɛ 'töüdhö ‑an ‑ta, yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","‑Wo 'ö bhë ‑yö ‑kë 'kpongtaa. Yö ꞊nɛ 'ö ‑Zlan ‑yö 'kpongtaadhɛ ꞊kaa'. 'Kɛɛ 'kpongtaamɛ ‑nu waa 'we ‑a ‑wun ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","‑Yö ‑nu ö ‑de ꞊plöö; 'yö‑ ‑de ‑mɛ ‑nu waa wo ‑kɔ 'kpɔ ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","'Kɛɛ kë‑ wo 'dhö bhë, mɛ kpö 'dɛdɛ ‑wo wo ‑kɔ ‑kpɔ ‑a ‑gɔ 'ö 'wo‑ ‑wun ‑dhɛ 'wun gia‑. ꞊Dhɛ ‑kë 'dhö, ‑wo bhë, 'yö‑ ‑kë 'ö 'wo ‑kë ‑Zlan ‑bha 'në 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kë 'wo‑ wo ‑Zlan ‑bha 'në ‑nu 'ka bhë yaa kë ꞊nɛ ‑kɔ 'ö‑ 'ka 'kpongtaa zö 'ö 'kwa‑ pö ‑na ‑a 'ka mɛ ꞊nɛ ‑yö gɔɔn‑ ꞊nɛ ‑a gbö 'ka bhë ‑a 'dhö. 'Wun 'ö go ‑Zlan ‑de ‑zo 'kun ‑wun 'gü yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","'Yö ꞊dhɛ ‑kë 'dhö, ‑wo bhë 'yö ‑kë mɛ 'bhee‑ 'ka, 'ö nu 'ö ‑kë kwa 'piö zö. ‑A 'glu ‑yö ‑kë ‑së. Yö 'ö bhë ‑yö ‑kë 'wun gia‑ ‑gɔgodhɛ 'ka. Yi 'yan ‑yö ‑dɔ ‑a ‑bha 'tɔbhɔdhe ‑bha. 'Tɔbhɔdhe 'ö 'dhö bhë, Dë ‑ya ‑nu ö Gbö do 'ö bhë ‑a ‑dhë. Pë 'ö‑ 'piö bhë, ꞊dhɛ 'yi‑ dɔ ‑a ‑bha ꞊nɛ ‑yö ‑go ‑a Dë 'piö, 'ö yö 'ö ö Dë ‑bha 'në dosɛn 'kpaan 'ka bhë 'ö‑ yö bhë 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yö ꞊nɛ 'ö Zan ‑yö 'wun ‑gban ‑a ‑bha 'ö‑ ꞊blɛɛ ‑dhoo bho ‑sü 'ka, 'ö‑ pö: «Yö ꞊nɛ 'ö 'wun 'ö ‑gban ‑a ‑bha, a‑ ‑blɛɛ 'dhiö ‑be ꞊nɛɛ: Mɛ do ‑yö nu ‑na n ꞊zlöö; ꞊yö ꞊va 'ö ‑ziö n ‑ta. 'Ö tɔɔ ‑yö ‑kë ‑dhö 'dhiö ‑be kö n 'ka bhɔ ꞊kun.» ");
INSERT INTO dnj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","‑Yö ö ‑bha 'wunsë ‑yö 'ko 'piö 'ö ‑kë kwa 'plɛ kwa ‑dhë 'ö 'dhuë‑ kpɔ kwa ‑bha ‑kplawo. ");
INSERT INTO dnj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kë‑ wo 'kpa bhë, tɔng 'ö ‑Zlan ‑ya dɔ kwa ‑dhë bhë, ‑yö ꞊bɔa' Moizö 'gü. 'Kɛɛ dɔ 'kwa‑ wo ꞊dɛɛ ꞊nɛ bhë, ‑a ‑bha 'glusë ‑wun waa‑ 'wun 'ö 'wun gia‑ 'ka 'ö ‑kë kwa ‑dhë bhë, ‑yö bɔa Yesu Klito 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","‑Zlan bhë mɛ gbɛ yaa ö 'yan dɔ ‑a ‑bha do. 'Kɛɛ ‑a Gbö dosɛn 'kpaan, Gbö 'ö ‑Zlan 'ka bhë, yö 'ö ‑ya ‑sü 'ka ö Dë 'sɔɔ bhë, ꞊yaa‑ kë 'kwa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","'Töng bhë ‑a 'ka, Zuifö ‑nu ‑gɔmɛ ‑nu 'wo Zeluzalɛmë, ‑wo slabhomɛ ‑nu waa‑ Levi ‑gɔ 'gunng 'gü ‑mɛ ‑nu 'ö 'wo yuö kë ‑na ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü bhë ‑an 'bhaa ‑nu ‑bɔ, 'wo nu 'wo ꞊dhɛɛ' kpɔ Zan ‑gɔ ꞊nɛɛ: «Dö ‑mü ü 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","'Kɛɛ yaa 'kun ‑a ‑daa kë ‑sü 'ka ‑an ‑gɔ, ‑a ‑ta pö ‑sü 'ka 'puu 'ka mɛ 'plɛ wö 'dhiö ꞊nɛɛ: «‑Zlan ‑bha ‑Yamɛ 'yaa ‑mü n 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","'Yö 'wo‑ ꞊dhɛɛ' kpɔ 'zü ꞊nɛɛ: «꞊Dhɛ 'ö 'dhö, kö dö ‑mü ü 'ka ɛ? Eli ‑mü ü 'ka a?» 'Yö‑ ‑daa ‑kë ꞊nɛɛ: «‑Abi'! 'Maa ‑mü.» 'Wo ꞊dhɛɛ' 'bhaa kpɔ ꞊nɛɛ: «‑Zlan ‑wodhiölomɛ 'ö yi 'yan 'dhoë‑ ‑gɔ bhë yö ‑mü ü 'ka a?» 'Yö‑ pö 'zü: «‑Abi'!» ");
INSERT INTO dnj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","'Wo‑ ꞊dhɛɛ' kpɔ zlöö ꞊nɛɛ: «꞊Ya kë 'dhö kö dö ‑mü ü 'ka ɛ? Bhi ‑de gia‑, ‑bhöë ‑daa 'kpëdhö ‑zë kë yi ‑dhë 'yi 'dho 'yi‑ pö yi bɔmɛ ‑nu ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","'Yö Zan ‑ya pö: «N tɔɔ gɔɔn‑ 'ö ‑dhoo bho ‑na 'yënng ꞊taa. Pë 'a‑ ‑dhoo bho ‑na 'ö tɔɔ: ‑Ka kwa Dëmɛ ‑bha zian ‑gbloo ‑pë kë; ‑yö dɔ kpengdhö ꞊nɛ ‑kɔ 'ö ꞊bɛɛn' ‑sü 'ka ‑a 'ka ‑Zlan ‑wodhiölomɛ Ezai ‑bha 'sëëdhɛ 'gü bhë ‑a 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mɛ ‑nu 'ö Zuifö ‑nu ‑wo ‑an bɔ 'wo nu ꞊dhɛɛ' 'kpɔ ꞊dhia Zan ‑gɔ bhë, Falizi ‑mɛ ‑nu ‑wo ‑kë ‑an ziën. ");
INSERT INTO dnj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Wo ‑de 'pö, ‑wo Zan ꞊dhɛɛ' ‑kpɔ, 'wo‑ pö: «꞊Dhɛ 'ö ‑Zlan ‑bha ‑Yamɛ 'yaa ‑mü ü 'ka, 'ö 'bhaa Eli 'ka, 'iin 'bhaa ‑Zlan ‑wodhiölomɛ 'ka ꞊nɛ, ü ‑dɔ ꞊dhë 'yö ü mɛ ‑nu bɔ yiö ꞊ee?» ");
INSERT INTO dnj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","'Yö Zan ‑ya ‑daa ‑kë ‑an ‑gɔ, 'ö‑ pö: «Ma 'pö, ka bɔ ꞊nɛ 'a‑ wo yiö; 'kɛɛ mɛ do ‑yö ka ziën 'ö 'kaa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","‑Yö nu ‑na n ꞊zlöö. 'Maa pë gbɛ 'ka ‑a 'dhiö ‑dewo poo kö 'aan‑ 'dho ꞊kloo'‑ ‑a 'dhiö 'aan‑ ‑bha ‑sakpa yun ꞊bhüö' 'po.» ");
INSERT INTO dnj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","'Wun ‑nu 'wo bhë, ‑wo ‑kë 'dhö Betani ‑pö mɛ 'ö 'yiga 'wo‑ ‑dhɛ Zuudɛn 'ö Zan ‑kë mɛ ‑bha ‑go ꞊sɔɔn yaa 'gü ‑bɔyiödhe kë ꞊dhia ‑a ꞊bhaa bhë ‑a ꞊zlöö ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya 'po, 'ö Zan ‑yö Yesu yö kö ‑yö nu ‑na ö 'piö, 'yö‑ pö: «'Bhlanë 'ö dho kë sla‑ 'ka kö ‑Zlan ‑yaan bho mɛ 'kpɛkpɛ ‑bha ꞊sɔɔn yaa ‑bho ‑an ‑bha ‑pë 'ka yö ꞊ga 'ö nu ‑na ꞊nɛ! ");
INSERT INTO dnj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yö ꞊nɛ 'a 'wun ‑gban ‑a ‑bha 'a‑ ꞊blɛɛ ꞊woë' ꞊nɛɛ: Mɛ do ‑yö nu ‑na n ꞊zlöö; ꞊yö ꞊va 'ö ꞊zië' n ‑ta, bhii ‑yö ‑kë ‑dhö n 'dhiö 'kpa 'pë‑ bhë, yö ꞊ga 'ö ꞊nɛ. ");
INSERT INTO dnj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","'Kɛɛ kë‑ wo 'dhö bhë yaa kë ꞊nɛ pë 'ö dho kaa, ‑a dɔ 'a‑ wo bhë yö ‑mü, 'kɛɛ a ‑nu mɛ ‑nu ‑bɔ yiö ꞊dhia kö Izlaɛlö ‑mɛ ‑nu ‑waan ‑a dɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","'Yö Zan ‑ya pö 'zü: «A ‑Zuu 'slööslö ‑yö kö ‑yö 'go ‑na dhang‑ 'gü. ‑Yö ‑kë ‑tönggö 'ka, 'yö nu 'yö ‑ya ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","'Kɛɛ ‑a kë ‑sü 'ka kö pë ‑nu bhë ‑waan kë, mɛ 'yö‑ 'ka, kö n 'ka‑ dɔ ꞊kun. 'Yö ‑Zlan 'ö n bɔ kö 'aan‑ mɛ ‑nu bɔ yiö bhë, 'ö‑ pö n ‑dhë: ‹Mɛ 'ü 'dhoë‑ ‑Zuu 'slööslö yö kö ‑yö ꞊yɔɔ' ‑na ‑a ‑ta ‑yaan 'to ‑a ‑ta bhë, yö ꞊nɛ 'ö dho mɛ ‑nu pa ‑Zuu 'slööslö 'ka.› » ");
INSERT INTO dnj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'Yö Zan ‑ya pö: «Pë 'ö 'dhö bhë a‑ ‑yö ('ö n 'yan ‑yö ‑da ‑a 'gü); a‑ ‑pö ꞊ya kë 'dhö kö mɛ bhë ‑Zlan Gbö ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya 'po; Zan waa‑ ö ‑bha ꞊guë' ‑nu bhë ‑an mɛ ꞊plɛ ‑wo ‑kë ‑dhɛ do bhë ‑a 'gü 'zü; ");
INSERT INTO dnj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","'wo Yesu yö kö ‑yö ziö ‑na; 'yö Zan ‑ya pö: «‑Ka ‑dhɛ ‑ga 'dhɛ! ‑Zlan ‑bha 'bhlanë ꞊ga ꞊nɛ!» ");
INSERT INTO dnj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Zan ‑bha ꞊guë' ‑nu ꞊plɛ 'wo bhë, ꞊dhɛ 'ö ‑wo bhë 'wo‑ ma, 'wo to mü 'wo ‑ziö Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","꞊Dhɛ 'ö Yesu ‑yö ꞊dhië ö ‑zü, 'ö ‑an yö kö ‑wo ziö ‑na ö 'piö, 'yö ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑Më 'ka‑ ꞊mɛɛ?» 'Ö ‑an ‑bha ‑daa ‑yö ‑kë ꞊dhɛɛ' 'ka 'wo‑ kpɔ ꞊nɛɛ: «Labi, ü ‑bha 'kwɛandhɛ ‑yö mɛɛ?» (Labi ‑gɛn 'ö tɔɔ «‑Gɔmɛ».) ");
INSERT INTO dnj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","'Yö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Ka nu 'kwa 'dho, kö 'ka‑ yö!» 'Yö 'wo to ‑a 'piö, 'wo dho 'wo wo 'yan dɔ ‑a ‑bha 'kwɛandhɛ ‑bha, 'ö 'wo to ‑a 'piö mü ꞊klöödhö ‑dhɛkpaɔyi mɛ bhë ‑a 'ka. (꞊Dhɛ 'ö pë ‑nu bhë 'wo kë ‑na 'dhö kö 'kwa dɔ 'wɔ 'yɛ ‑lan 'ka.) ");
INSERT INTO dnj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mɛ ꞊plɛ 'ö Zan 'wun ꞊blɛɛ' ‑wo bhë 'wo‑ ma 'ö 'wo ‑ziö Yesu 'piö bhë, ‑a mɛ do tɔɔ Andre 'ö ‑kë Simɔ Piɛɛ 'zlaa‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","꞊Dhɛ 'wo 'go ‑na Yesu ‑gɔ kɔɔ, Andre ‑blɛɛzë ꞊nɛ 'ö ö 'yan dɔ ö ꞊dhoo Simɔ Piɛɛ ‑bha; 'yö‑ pö ‑a ‑dhë: «'Yië yi 'yan dɔ Mesi ‑bha!» (꞊Waa‑ pö Mesi Eblö ‑wo 'gü, kö ‑wa ‑pö Glɛkö ‑nu ‑wo 'gü 'pö «Klito», ‑a ‑gɛn 'ö tɔɔ «‑Zlan ‑bha ‑Yamɛ».) ");
INSERT INTO dnj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","꞊Dhɛ ‑kë 'dhö, ‑yö ‑dho Simɔ 'ka Yesu 'piö. ꞊Dhɛ 'ö Yesu ‑yö Simɔ ‑ga ‑piindhö, 'yö‑ pö ‑a ‑dhë: «Ü tɔɔ Simɔ; Zan gbö ‑mü ü 'ka. 'Go ꞊dɛɛ ‑bha, ü tɔɔ Sefasö.» (꞊Waa‑ pö Sefasö Eblö ‑wo 'gü kö ‑wa ‑pö Glɛkö ‑nu ‑wo 'gü 'pö «Piɛɛ», ‑a ‑gɛn tɔɔ «‑guö gbɔng».) ");
INSERT INTO dnj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya 'po, 'ö Yesu ‑yö ‑da zian ‑ta kö ‑yaan 'dho Galile ‑sɛ 'gü; 'yö ‑kpën gɔɔn‑ do 'wo‑ ‑dhɛ Filipö ‑a ‑bha; 'yö‑ pö ‑a ‑dhë: «‑Bhö ziö n 'piö!» ");
INSERT INTO dnj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipö bhë, ‑yö ‑kë Betesaida mi 'ka. Betesaida ‑pö 'ö bhë ꞊nɛ 'ö Andre waa‑ Piɛɛ 'wo ‑kë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","꞊Dhɛ ꞊ya kë 'dhö, Filipö ‑yö ‑kpën Natanaɛlö ‑bha; 'yö‑ pö ‑a ‑dhë: «Mɛ 'ö Moizö ‑ya ‑bha 'wun ꞊blɛɛ tɔng 'sëëdhɛ 'gü, 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑wo 'wun ‑gban ‑a ‑bha 'wo‑ ꞊blɛɛ 'pö bhë, 'yië‑ yö; 'ö tɔɔ Zozɛfu gbö Yesu 'ö go Nazalɛtë bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","'Yö Natanaɛlö ‑ya pö ‑a ‑dhë: «Ü‑ ‑pö dö! Nazalɛtë ‑pö ꞊nɛ, 'wunsë 'godhɛ ‑mü ꞊a?» 'Yö Filipö ‑ya pö ‑a ‑dhë: «Bhi gia‑, ‑bhö nu 'ü ü 'yan dɔ ‑a ‑bha 'dhɛ!» ");
INSERT INTO dnj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","꞊Dhɛ 'ö Yesu ꞊ya Natanaɛlö yö kö ‑yö nu ‑na ö 'piö, 'ö 'wun ‑gban ‑a ‑bha 'ö‑ ꞊blɛɛ 'ö‑ pö: «Izlaɛlö 'në giagia ꞊ga ꞊nɛ, 'ö bhii 'wun yaa gbɛ 'yaa‑ 'gü!» ");
INSERT INTO dnj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","'Ö Natanaɛlö ‑ya ꞊dhɛɛ' kpɔ 'ö‑ pö: «Ü n ‑dɔ ‑kɔklë ꞊ɛ?» 'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «A ü ‑yö kö ü ‑ya ‑sü 'ka figö ‑lü ꞊löö kö Filipö yaa ü ꞊dhɔɔ kë ‑de wo ꞊kun.» ");
INSERT INTO dnj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","'Yö Natanaɛlö ‑ya pö ‑a ‑dhë: «N ‑Gɔmɛ, ‑Zlan Gbö ‑mü ü 'ka; bhi ꞊nɛ 'ü Izlaɛlö ‑mɛ ‑nu ‑bha ‑gludë 'ka!» ");
INSERT INTO dnj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","'Ö Yesu ‑ya ‑wo ‑daa ‑kë 'ö‑ pö: «꞊Dhɛ ‑kë ꞊nɛ 'ma‑ pö a ü ‑yö figö ‑lü ꞊löö bhë, 'ü n ‑wo yö 'wun gia‑ 'ka bhë ɔɔ‑; 'kɛɛ ‑yö kë ü 'yaan ꞊nɛ ü ‑dho 'wun 'gblüünzë ꞊plëëzë 'wo ‑ziö ‑a mɛ 'ö ꞊nɛ ‑a ‑ta ‑an yö.» ");
INSERT INTO dnj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","'Yö‑ pö 'zü: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: 'Ö sü ꞊dɛɛ ‑bha, ka ‑dho dhang‑ yö zlöö ‑bha kö ‑a 'dhi ꞊ya 'po kö ‑Zlan ‑bha bɔmɛ ‑nu ‑wo ‑da ‑na 'iin kö ‑wo ꞊yɔɔ' ‑na ma 'a Mɛgbö 'ka ꞊nɛ n ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","꞊Dhɛ 'ö 'wun ‑nu bhë ꞊wa kë 'dhö, 'ö‑ ‑dhɛkpaɔyi ꞊ya kë ‑yaaga, 'ö dhe 'sü 'wlaan‑ ‑yö ‑kë Galile pö‑ do 'wo‑ ‑dhɛ Kana ‑a 'gü. Yesu dhe ‑yö ‑dho 'wlaan‑ bhë ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu ‑de 'pö, yö 'dhö waa‑ ö ‑bha ꞊guë' ‑nu, ‑wo ‑naɔ ‑bɔ ‑an ‑gɔ 'pö kö ‑wo nu mü. ");
INSERT INTO dnj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","꞊Dhɛ 'ö 'wlaan‑ bhë 'wo‑ kë ‑na, 'ö kwa dɔ 'töng 'bhaa 'ka, 'ö yɔ ‑yö yën. ꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu dhe ‑yö Yesu ꞊dhɔɔ ‑kë plaan, 'ö‑ pö ‑a ‑dhë: «'Wun ꞊nɛ ‑wo ‑dho ‑a kë ꞊dhë 'pö ꞊nɛ! Yɔ 'yi 'plɛ ꞊ya yën.» ");
INSERT INTO dnj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","'Ö Yesu ‑ya pö ‑a ‑dhë: «Dheklöö, ü‑ ‑pö ꞊dhɛɛ? Ü ꞊kwaa' n ‑zü. N ‑ma 'töng yaa ‑lo ꞊kun!» ");
INSERT INTO dnj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","'Ö‑ dhe ‑yö yuökëmɛ ‑nu ꞊dhɔɔ ‑kë 'ö‑ pö ‑an ‑dhë: «‑Ka 'to zö; pë 'saadhö 'ö 'dhoë‑ pö ka ‑dhë, ‑kaa kë!» ");
INSERT INTO dnj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","‑Guö 'lɔɔ‑ ꞊fië' 'slado ‑wo ‑kë dɔ ‑sü 'ka ‑dhɛ bhë ‑a ‑bha. Yö ꞊nɛ 'ö ꞊ya kë 'ö Zuifö ‑wo 'yi sü ‑a 'gü 'wo‑ ‑kë wo ‑bha ꞊nɛ ‑kɔ 'ö‑ 'ka ‑an wɔ ‑kɔ 'gü bhë ‑a 'dhö. ‑A do bhë pë dhö ‑mɔ 'yi 'litrö 'gɔɔ‑ 'slɛaga 'iin ꞊këng' do ‑bha ‑wo ‑mɔ ‑a ‑bha ‑wa yö ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","'Yö ꞊dhɛ ‑kë 'dhö 'ö Yesu ‑ya pö yuökëmɛ ‑nu 'wo bhë ‑an ‑dhë: «‑Ka 'yi yö 'lɔɔ‑ ꞊fië' ‑nu 'wo ꞊nɛ ‑an 'gü, ‑yö ‑an pa!» 'Ö 'wo‑ ‑kë 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","'Yö‑ pö ‑an ‑dhë 'zü: «'Yi bhë ‑kaa pë 'bhle 'sü ‑kɔɔ 'gü 'ka dhoë mɛ 'ö 'wlaan‑ ꞊nɛ ‑a ‑gbaan 'ka bhë, ‑a ꞊dhia!» 'ö 'wo‑ ‑kë 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","(Kö ‑wa ‑kë ꞊dhë 'ma, 'iin kö ‑wa ‑pö ‑a ‑dhë ꞊dhë, 'kɛɛ) ꞊dhɛ 'wo ‑lo 'ma 'ö gɔɔn‑ bhë 'ö 'yi bhë 'ö‑ dan, kö ꞊ya 'gla yɔ 'gü. 'Kɛɛ kë‑ wo 'dhö bhë, ‑dhɛ 'ö yɔ bhë 'ö go ‑a ‑bha yaa‑ dɔ ö ‑de ‑gɔ. Yuökëmɛ ‑nu 'wo bhë, wo ‑zë ꞊dhɛ 'ö yɔ bhë 'ö go ‑a ‑bha ‑wa ‑dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","꞊Dhɛ ꞊ya 'go mü, 'yö dhe ꞊gɔn ꞊dhɔɔ ‑kë 'ö‑ pö ‑a ‑dhë: «Kë‑ wo ‑na ꞊nɛ, ꞊wa 'wlaan‑ kë 'ö 'wo dho yɔ yö mɛ ‑nu ‑dhë, ‑a din ‑sëëzë ꞊nɛ 'wo‑ nu ‑an ‑dhë, 'ö ꞊ya kë 'dhö zlöö, 'kwa dɔ 'töng 'bhaa 'ka kö mɛ ‑nu ꞊wa yɔ mü ꞊va 'ö 'wo‑ 'saadhö 'ö ‑dhö, 'wo‑ nu ‑an ‑dhë; 'kɛɛ bhi 'pö, yɔ ‑sëëzë ꞊nɛ 'ü‑ ꞊gbaannu ꞊nɛ, 'kwa‑ ma ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","‑Kɔ 'ö ꞊kaa' Kana, Galile ‑sɛ 'gü, 'ö Yesu ‑yö ö ‑bha ‑dhidhaapë ‑blɛɛzë ꞊kaa' 'ö bhë. ꞊Dhɛ 'ö bhë ꞊nɛ 'ö Yesu ‑yö ö ‑bha 'tɔbhɔdhe ‑zɔn ‑a ‑bha, 'ö‑ ‑bha ꞊guë' ‑nu ‑wo wo ‑zo yö ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","꞊Dhɛ 'ö 'wlaan‑ bhë ꞊ya yën, waa‑ ö dhe 'dhö, 'ö dheglu ‑nu waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑dho Kapɛɛnaɔmë 'ö 'wo ‑dhɛkpaɔyi kpö 'bhle kë mü. ");
INSERT INTO dnj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","꞊Dhɛ 'ö Zuifö ‑nu ‑bha Paakö 'wlaan‑ kë ‑yi ꞊ya yö ꞊klöö', Yesu ‑yö ‑luu 'ö dho Zeluzalɛmë. ");
INSERT INTO dnj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","꞊Dhɛ 'ö dho, 'ö ‑lo 'ma ('ö ‑da ‑Zlan ‑gba ‑a 'gü ‑kɔ 'dhëüdhö mü), kö ‑du ‑nu oo, 'bhla ‑nu oo, ‑tönggö ‑nu ('ö ꞊ya kë 'ö Zuifö ‑nu ‑wa dhɔ ‑waan kë woë‑ sla‑ ꞊bhoë' ‑pë 'ka bhë) ‑an 'dhɔɔdɔmɛ ‑nu waa‑ mɛ ‑nu 'wo ‑kë 'wëü‑ ‑ta ‑bɔ ꞊dhia ‑Zlan ‑gba ‑a 'gü ‑kɔ 'wëü‑ 'ka mü bhë ‑an 'ka bhë ‑an 'plɛ ꞊wa wo ‑yadhɛ 'kun mü. ");
INSERT INTO dnj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","꞊Dhɛ ꞊ya kë 'dhö, 'ö ꞊bhüöga ‑nu sü 'ö‑ ‑kë ‑klaaga 'ka, 'ö 'dhɔɔdɔmɛ ‑nu waa‑ wo ‑bha 'bhla ‑nu, ‑du ‑nu ‑an ‑kë; kö ‑yö 'wëü‑ ‑tabhɔmɛ ‑nu ‑bha 'wëü‑ ‑pɛn ‑na kö ‑yö ‑an ‑bha 'dhɔɔ dɔ ‑a ‑ta ꞊gba ‑nu yö ‑na ꞊gɔa'. ");
INSERT INTO dnj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","'Yö‑ pö ‑tönggö 'dhɔɔdɔmɛ ‑nu ‑dhë: «Pë ‑nu 'wo ꞊nɛ, ‑ka ‑an bho zö; kö ꞊kun 'ka n Dë ‑bha 'kɔ kë 'dhɔɔkuëdhɛ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","꞊Dhɛ 'ö pë ‑nu kë ‑na 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu ‑zo ‑yö ‑büö ꞊nɛ 'wun ‑yö ‑gban pë ‑nu 'wo ‑kë bhë ‑an ‑bha ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: «‑Zlan, ü ‑bha 'kɔ ‑dhɔ 'ö n ‑gɔ bhë ‑yö ‑mɔa ‑bha ‑dewo ‑yö n zë.» ");
INSERT INTO dnj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","'Yö Zuifö ‑nu ‑gɔmɛ ‑nu ‑wa pö ‑a ‑dhë: «‑Dhidhaapë do kë kö ‑ya ‑zɔn yi ‑dhë ꞊nɛ pë ‑nu 'ü‑ kë ‑na bhë ‑wo ü ꞊dua' 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ, 'ö‑ pö: «‑Zlan ‑bha 'kɔ ꞊nɛ, ‑kaa 'wü; a ‑dho ‑a gbɛ dɔ ‑dhɛkpaɔyi ‑yaaga ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","'Yö Zuifö ‑nu ‑gɔmɛ ‑nu ‑wa pö ‑a ‑dhë 'zü: «'Kɔ ü ‑ga ‑na ꞊nɛ, ‑kwɛ 'gɔɔ‑ ‑yiisië ö ga 'slado ‑yuö ‑mü; dö ‑mü ü 'ka kö 'üën‑ pö yi ‑dhë ü ‑dho ‑a dɔ ‑dhɛkpaɔyi ‑yaaga ‑bha ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","'Kɛɛ kë‑ wo 'dhö bhë, pë 'ö‑ ‑dhɛ ‑Zlan ‑bha 'kɔ ('ö mɛ ‑nu waa‑ ‑gɛn ma ‑a ‑gɔ) bhë 'ö tɔɔ yö ‑de gia‑ ö ‑lü. ");
INSERT INTO dnj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","'Kɛɛ ꞊dhɛ 'ö ꞊ya 'go ga 'gü, 'ö‑ ‑bha ꞊guë' ‑nu ‑zo ‑yö ‑büö zlöö ‑a ‑wo ‑nu 'ka, 'wo‑ ‑gɛn ma; 'ö pë ‑nu 'wo ‑gban ‑a ‑bha 'wo ‑kë ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü bhë 'wo‑ ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Paakö 'töng 'ö Yesu ‑ya ‑kë Zeluzalɛmë 'ma bhë, mɛ ‑nu ‑wo wo ‑zo ‑yö ‑a ‑bha ꞊plëëzë 'ka ‑dhidhaapë ‑nu 'ö‑ ‑kë bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","'Kɛɛ yö 'pö, ‑yö ö ‑de ‑kë 'slë 'ka ‑an ‑gɔ 'ö tɔɔ ‑yö ‑an ‑dɔ; ");
INSERT INTO dnj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","bhii ‑a ‑bha ‑wun yaa kë ‑a ‑bha kö ‑wo mɛ 'bhaa ‑wun ꞊blɛɛ' ö ‑dhë. Mɛ 'ö ‑dhö 'wun 'ö‑ ꞊zuö' 'piö ‑wun 'ka, ‑ya ‑dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Gɔɔn‑ do ‑yö ‑kë ‑dhö, 'wo‑ ‑dhɛ Nikodɛmö; ‑yö ‑kë Falizi ‑mɛ 'ka, 'go mü, ‑yö ‑kë Zuifö ‑nu ‑gɔmɛ do 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","'Yö gbeng ‑yi do 'ka, 'yö nu Yesu 'piö 'ö‑ pö ‑a ‑dhë: «N ‑Gɔmɛ, yi‑ ꞊tɛi' ‑dɔ ꞊nɛ bhi ꞊nɛ 'ö ‑Zlan ‑yö ü bɔ kö 'üën‑ yi ꞊daan'‑; 'yö tɔɔ mɛ gbɛ ‑kɔ 'ka 'dhö ‑mɔa kö ‑yö ‑dhidhaapë ‑nu kë ꞊nɛ ‑kɔ bhë ‑a 'dhö kö ‑Zlan 'yaa‑ ‑mɛ 'piö.» ");
INSERT INTO dnj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","'Ö Yesu ‑ya pö ‑a ‑dhë: «A‑ ‑pö ü ‑dhë 'wun gia‑ 'ka, mɛ 'ö yaa bhɔ ‑dëüwo, yaa 'dhö ‑da ‑Zlan ‑bha ‑gludëdhɛ këdhɛ ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","'Yö Nikodɛmö ‑ya pö ‑a ‑dhë: «Mɛ ‑dho ‑mɔa kö ‑yö bhɔ ‑kɔklë kö ꞊ya kë zii ‑ii, 'iin kë‑ wo bhë ‑da 'pö 'dhoë‑ wo 'zü ö dhe ꞊zuö' 'piö kö ‑yaan bhɔ bhë ee?» ");
INSERT INTO dnj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «A‑ ‑pö 'zü ü ‑dhë giagia 'ka, ꞊ya kë ꞊nɛ mɛ yaa bhɔ 'yi waa‑ ‑Zuu 'slööslö ‑an 'gü, yaa 'dhö ‑da ‑Zlan ‑bha ‑gludëdhɛ këdhɛ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","'Ö tɔɔ mɛ 'ö bhɔ mɛbheedhe ꞊suu'‑ 'gü, kö mɛ bhë, mɛdhɛ ꞊zuöga ꞊nɛ 'ö‑ ‑gɔ; 'kɛɛ mɛ 'ö‑ ‑bha ‑këdhösü ‑gɛn ꞊ya 'go ‑Zuu 'slööslö 'gü, kö mɛ bhë ‑yö ‑Zuu ꞊suu'‑ ‑ta ‑mɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kö ꞊kun 'ö ü 'te ‑yö tun ‑a pö 'a‑ wo ü ‑dhë: ‑Bhö bhɔ 'zü ‑dëüwo bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","'Tëë 'ö 'ka‑ ‑ga ‑na bhë, ꞊dhɛ 'ö ‑dhi ‑a ‑dhë ꞊nɛ 'ö ‑piö ‑a ‑bha, 'ö ꞊ya kë kwa‑ ‑drinng ma. 'Kɛɛ 'kaa‑ 'go ‑zian 'iin 'dho ‑zian gbɛ dɔ. Pë do bhë ꞊nɛ 'ö mɛ 'ö ꞊ya bhɔ ‑Zuu 'slööslö 'gü 'ö‑ 'ka 'pö.» ");
INSERT INTO dnj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","'Yö Nikodɛmö ‑ya pö ‑a ‑dhë 'zü: «‑Bhɔ ‑Zuu 'slööslö 'gü ‑sü 'ö bhë, ‑a kë ‑kɔ ‑yö ꞊dhë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «Bhi 'ü tɔnggɔmɛ ꞊va do 'ka Izlaɛlö 'sɛgɔ 'dhiö bhë, 'wun ꞊nɛ 'bhaa‑ dɔ ꞊a? ");
INSERT INTO dnj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","꞊Ɛɛ, a‑ ‑pö ü ‑dhë giagia 'ka: Pë 'yi‑ dɔ ꞊nɛ 'ö 'yi‑ ‑wun ꞊blɛɛ; 'ö pë 'ö yi 'yan ‑yö ‑da ‑a 'gü 'yi‑ ‑tɔmɔdhɛ ‑kë; 'kɛɛ 'kaa yi ‑wo ‑nu ‑dhɛ 'wun gia‑ 'sa! ");
INSERT INTO dnj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Pë ‑nu 'wo 'kpongtaa zö 'a ‑an ‑wun ꞊blɛɛ' ‑na bhë, ‑a ‑wun 'kaa‑ ‑dhɛ 'wun gia‑ ꞊nɛ, ‑a mɛ ‑nu 'wo dhang‑ 'gü bhë, a ‑dho ‑a ‑wun ꞊blɛɛ' ka ‑dhë 'ö 'ka‑ ‑wun ‑dhɛ 'wun gia‑ ‑kɔklë ꞊ɛɛ? ");
INSERT INTO dnj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A‑ ‑pö ü ‑dhë, mɛ gbɛ yaa 'dho dhang‑ 'gü, ‑a 'ke yaa kë ma 'a ‑Zlan Gbö 'ka, 'a ‑ya ‑sü 'ka dhang‑ 'gü, 'a ꞊yɔɔ bhë n 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","'Iin 'zü pë dho kë 'ö tɔɔ ‑wo Mɛgbö dɔ 'lü ‑bha dhuö ꞊nɛ ‑kɔ do gia‑ 'ö Moizö ‑yö zën ꞊mɛɛ 'në dun ‑a 'ka 'kpa 'lü ‑bha 'yënng ꞊taa bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","‑Yö kë 'dhö kö mɛ 'ö 'dhoë‑ ö ‑zo yö ‑a ‑bha, kö ‑këdhösü 'ö 'dhö ꞊toëpö 'ka bhë ‑yaan kë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","'Ö tɔɔ 'kpongtaamɛ ‑nu ‑dhɔ ‑yö ‑Zlan ‑kë giagiawo; 'yö‑ ‑wun 'gü 'ö ö Gbö dosɛn bhë 'ö‑ bɔ, ‑yö kë 'dhö kö mɛ 'oo mɛ 'ö 'dhoë‑ ö ‑zo yö ‑a ‑bha bhë, kö ‑yaan 'kun ga ‑sü 'ka; 'kɛɛ kö ‑këdhösü 'ö ‑dhö ꞊toëpö 'ka bhë ‑yaan kë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kë‑ wo 'dhö bhë ‑Zlan yaa ö Gbö bɔ 'kpongtaa kö ‑yaan za ‑lo 'kpongtaamɛ ‑nu ‑bha, 'kɛɛ ‑ya ‑bɔ ꞊zian' kö 'kpongtaamɛ ‑nu ‑waan bɔ ‑a ‑ta ‑waan dha ‑sü yö. ");
INSERT INTO dnj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","꞊Ya kë 'dhö kö mɛ 'ö ꞊yaa‑ ‑wun ‑dhɛ 'wun gia‑ kö za 'ka 'dhö ‑lo ‑a tuö; 'kɛɛ mɛ 'ö ꞊ya ‑kɔ ‑a ‑wun 'ka, kö za bhë, ‑a ‑bha ꞊ya ‑lo ‑a tuö 'saadhö ꞊nɛ bhë. 'Ö bhii yaa 'we ‑Zlan Gbö dosɛn 'kpaan 'ö‑ ‑gɔ bhë ‑a ‑wun ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Za ‑bha ‑lo mɛ tuö ‑gɛn ꞊ga ꞊nɛ: ‑Dhɛpuudhɛ ‑yö ‑nu 'kpongtaa ꞊zian', 'kɛɛ mɛ ‑nu ‑wo wo ‑ta ‑yö ‑a ‑bha, 'wo wo wö bɔ ‑dhɛtiidhɛ 'gü ‑pë ‑nu 'piö 'ö bhii ‑an këpë ‑nu ‑wo ‑kë yaya. ");
INSERT INTO dnj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","'Ö tɔɔ mɛ 'ö këpëyaamɛ 'ka, ‑yö ‑dhɛpuudhɛ ‑san ‑zë 'ö 'yaa nu mü, 'ö bhii kö ꞊kun 'ö‑ këwun ‑nu dhö yö ‑dhɛgbɛadhɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","'Ö mɛ 'ö 'wun gia‑ 'gü ‑mɛ 'ka 'ö‑ ‑dhɔ ‑kë ‑dhɛpuudhɛ 'ka ‑yö kë 'dhö kö mɛ 'kpɛkpɛ ‑wa yö ꞊nɛ ‑a këpë ‑nu bhë ‑wo ‑Zlan ‑zo 'kun ‑wun 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","꞊Dhɛ 'ö Yesu waa‑ ö ‑bha ꞊guë' ‑nu ꞊wa 'go mü, ‑wo wo ‑gɔ dɔ ꞊zian' Zude ‑sɛ 'gü. ‑Dhɛ bhë ꞊nɛ 'wo 'töng kpö 'bhle ‑kë ‑a ‑bha, kö ‑yö mɛ ‑nu bɔ ‑na yiö. ");
INSERT INTO dnj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Zan ‑de 'pö ‑yö ‑kë mɛ ‑nu bɔ yiö ꞊dhia 'pö pö‑ 'wo‑ ‑dhɛ Enɔɔ bhë ‑a 'gü Salimë ‑pö 'sɔɔ, 'ö tɔɔ 'yi ‑yö ‑kë mü ꞊va. 'Ö ꞊ya kë 'ö mɛ ‑nu ‑wo go ‑dhɛ 'saadhö 'gü, 'wo nu ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","'Töng bhë ‑a 'ka, kö waa Zan ‑zuö ‑kanso 'gü ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","'Yö yi do 'bhaa 'ka 'ö zaɔbhodhe ‑yö ‑da Zan ‑bha ꞊guë' ‑nu waa‑ Zuifö mi do ‑an ziën 'wun 'ö ‑gban bun ‑bha ‑kë 'slööslö ‑kɔ 'ö ‑Zlan ‑bha zian ‑ta, ‑a wɔ ‑kɔ 'gü bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","'Yö 'wo nu Zan 'piö, 'wo‑ pö ‑a ‑dhë: «Yi ‑Gɔmɛ, mɛ 'ö kwa ‑nu 'kwa‑ ‑kë Zuudɛn zlöö ‑dëü 'ka, 'ü‑ ‑tɔmɔdhɛ ‑kë bhë, mɛ ‑nu ‑wo 'dho ‑na ‑a 'piö, ‑yö ‑an bɔ ‑na yiö 'pö ‑oo!» ");
INSERT INTO dnj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","'Ö Zan ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Pë yaa 'dhö kë mɛ ‑gɔ 'kpaan 'ka kö ‑Zlan yaa‑ nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ka ‑de gia‑, ka n ꞊goo‑ 'ka, 'ö bhii a‑ ‑pö ka ‑dhë: 'Maa ‑Zlan ‑bha ‑Yamɛ 'ka, 'kɛɛ ‑Zlan ‑yö n ‑bɔ ‑a 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Dhe ‑gɔn ꞊nɛ 'ö tɔɔ mɛ 'ö dhe 'dhoë‑ ‑gɔ, 'kɛɛ mɛ 'ö dhe ‑gɔn 'bha 'ka, 'ö‑ 'to 'dhö ‑a ‑wo ‑bha, ‑a ꞊zuö' ‑yö ‑da 'gludhi ꞊va 'gü dhe ‑gɔn ‑wo 'ö‑ ma bhë ‑a ‑wun 'gü. ‑Kɔ 'ö n ꞊zuö' 'glu 'dhö dhi ‑na ‑a 'ka bhë 'ö bhë; 'ö‑ 'dhiö 'dhö ‑mɔ ‑sü 'ka 'kuë. ");
INSERT INTO dnj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pë dho kë tɔɔ ‑a ‑gɔ ‑dho ꞊luu 'ö ma ‑zë 'a dho sia‑. ");
INSERT INTO dnj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mɛ 'ö 'go ‑na dhuö bhë, ‑yö pë 'plɛ ‑gɔ ‑ta; 'ö mɛ 'ö 'kpongtaa zö bhë, 'ö 'kpongtaadhɛ ‑bha 'ka 'ö‑ 'wun ꞊blɛɛ ‑wo ‑nu ‑wo ‑kë 'kpongtaadhɛ ‑bha 'ka. ‑Yö 'dhö gia‑ 'ka ꞊nɛ mɛ 'ö go dhang‑ 'gü bhë, ‑yö pë 'plɛ ‑gɔ ‑ta, ");
INSERT INTO dnj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","'ö pë 'ö 'yan ‑ya yö 'ö‑ 'to ‑ya ma ꞊nɛ, 'ö‑ ‑tɔmɔdhɛ ‑kë; 'kɛɛ kö mɛ gbɛ 'to 'yaa‑ 'wun ꞊blɛɛ' ‑wo ‑bha 'sa. ");
INSERT INTO dnj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mɛ 'oo mɛ 'ö ꞊yaa‑ ‑bha ‑tɔmɔdhɛ kë ‑wo bhë ‑a ‑dhɛ 'wun gia‑ kö ‑Zlan ‑bha 'wun ꞊blɛɛ' ‑sü bhë, ꞊yaa‑ ‑dhɛ 'wun gia‑ ꞊nɛ bhë; ");
INSERT INTO dnj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","'ö bhii mɛ 'ö ‑Zlan ‑ya bɔ bhë, ‑Zlan ‑wo ꞊nɛ 'ö‑ ꞊blɛɛ 'ö tɔɔ ‑Zlan ꞊ya ‑Zuu 'slööslö ‑ya ‑a 'gü ö 'plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dë ‑yö ö Gbö ‑dhɔ ‑kë, yö ꞊ga 'ö Dë ꞊ya pë 'plɛ ‑lo ‑a kwɛɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kö mɛ 'ö ‑ya Gbö ‑wun ‑dhɛ 'wun gia‑, ꞊toëpö ‑këdhösü ‑ya ‑bha 'ka. 'Kɛɛ mɛ 'ö yaa Gbö ꞊bhlë ‑ya, yö 'ka 'dhö ‑da ‑këdhösü 'gü, 'kɛɛ ‑Zlan ‑bha ‑naazuëdhe ꞊nɛ 'ö dhoë‑ dɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","꞊Dhɛ ‑kë 'pö, Falizi ‑mɛ ‑nu ‑wa ‑ma ꞊nɛ Yesu ‑bha mɛ ‑nu ‑bɔ yiö ‑sü bhë, ꞊ya ziö Zan ‑bha ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","'Kɛɛ kë‑ wo 'dhö bhë, yaa kë ꞊nɛ pë 'wo‑ pö Yesu gia‑ ‑de ꞊nɛ 'ö mɛ bɔ yiö yö kun, 'kɛɛ ‑a ‑bha ꞊guë' ‑nu ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","'Yö ꞊dhɛ 'ö Yesu ꞊yaa‑ 'wun dɔ ꞊nɛ 'wun ‑nu 'wo bhë 'saadhö, Falizi ‑mɛ ‑nu ꞊waa‑ ma, 'yö go Zude, 'yö ‑yɛ ö 'zü, 'yö dho Galile. ");
INSERT INTO dnj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","'Kɛɛ kë‑ wo 'dhö bhë zian 'kpaan gbɛ 'ö dhoë sü ‑yaan 'kun ‑bɔ Samali ‑sɛ 'gü ‑süë 'yaa 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","‑A ‑bha ‑bɔ Samali ‑sɛ bhë ‑a 'gü ‑sü 'ka, ‑yö ‑lo pö‑ do 'wo‑ ‑dhɛ Sikaa ‑a 'sɔɔ. Pödhɛ 'ö bhë ‑yö dɔ ‑sü 'ka ꞊bhlöödhɛ 'ö Zakɔbö ‑ya nu ö gbö Zozɛfu ‑dhë bhë ‑a 'sɔɔ. ");
INSERT INTO dnj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","‑Dhɛ bhë ꞊nɛ 'ö ‑klɔng 'ö Zakɔbö ‑ya pɔn bhë 'ö ‑kë ‑a ‑bha. ‑Klɔng bhë ꞊nɛ 'ö Yesu ‑yö dho 'ö ‑ya ‑a 'kpong 'dhiö kö lan‑ ꞊ya dɔ mɛ ‑gɔ ziën, bhii kö 'ta 'ö‑ sü bhë ‑a ‑wun 'gü, ‑a 'gü ꞊ya ga. ");
INSERT INTO dnj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","'Yö dhebɔ do 'ö ‑kë Samali ‑dhe 'ka 'yö ‑wo mü ‑yaan 'yi 'tɔ. 'Ö Yesu ‑ya pö ‑a ‑dhë: «N gbaa 'yië 'a‑ mü!» ");
INSERT INTO dnj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","꞊Dhɛ kë ‑na 'dhö kö ‑a ‑bha ꞊guë' ‑nu ꞊wa 'dho plöö ‑bhöpë ‑nu 'dhɔ ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","'Ö dhebɔ bhë 'ö‑ pö ‑a ‑dhë: «‑Yö ‑kë ꞊dhë 'ö bhi 'ü Zuifö 'ka, 'ü 'yi ‑dhɛ n ‑gɔ, 'kɛɛ kö ma 'a ꞊nɛ Samali ‑dhe ‑mü n 'ka ꞊nɛ ꞊ɛ?» (Kë‑ wo 'dhö bhë 'ö tɔɔ Zuifö ‑nu 'waa 'we Samali ‑mɛ ‑nu 'piö.) ");
INSERT INTO dnj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","'Yö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «꞊Ya kë ꞊nɛ ü ‑Zlan ‑bha gbaɔ waa‑ mɛ 'ö 'yi ‑dhɛ ‑na ü ‑gɔ ꞊nɛ ü‑ ‑dɔ ‑be, kö bhi ꞊nɛ 'ü dho 'yi ‑dhɛ ‑a ‑gɔ ‑bezë. Kö 'yi 'ö ‑këdhösü 'dhoë‑ 'gü bhë, a ‑dhoë nu ü ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","'Yö dhebɔ bhë 'yö‑ pö: «N Dëmɛ, 'yi ꞊tɔa' ‑pë gbɛ 'yaa ü ‑gɔ 'ö ‑klɔng ‑glu 'dhö ꞊gbiin ꞊nɛ 'yi 'ö ‑këdhösü 'dhoë‑ 'gü bhë ü ‑dho ‑a tɔ 'më ɛɛ? ");
INSERT INTO dnj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","'Iin kë‑ wo ꞊nɛ, kë 'pö 'ü‑ wo ꞊va yi 'bhɛma Zakɔbö 'ö ‑klɔng ꞊nɛ 'ö‑ pɔn yi ‑dhë ‑a ‑bha 'pö bhë ee? 'Kɛɛ kö yö ‑de gia‑ ‑ya 'gü ‑yi ‑mü yö 'dhö, ö ‑bha 'në ‑nu waa‑ wo ‑bha ‑tuë ‑nu.» ");
INSERT INTO dnj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ ꞊woë' ꞊nɛɛ: «'Yi ꞊nɛ, mɛ 'oo mɛ 'ö ꞊yaa‑ mü, 'yi mü ‑dhɔ ‑yö ‑dho ‑a kë 'zü; ");
INSERT INTO dnj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","'kɛɛ 'yi 'a‑ nu ‑na mɛ ‑nu ‑dhë ꞊nɛ, mɛ 'ö ꞊ya ö ‑kɔ 'kpɔ ‑a ‑gɔ 'ö ꞊yaa‑ mü, 'yi mü ‑dhɔ 'ka 'dhoë‑ kë gbɔ. 'Ö tɔɔ 'yi 'a 'dhoë‑ nu ‑a ‑dhë bhë, ‑yö ‑dho kë ‑a ‑gɔ 'yigɔ 'ö dho bhɔ 'dhö ꞊toëpö ‑këdhösü 'gü ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","'Ö dhebɔ bhë 'ö‑ pö: «N Dëmɛ, 'yi bhë ‑a nu n ‑dhë kö 'aan‑ ‑a mü, kö ꞊kun 'ö 'yi mü ‑dhɔ dhö n kë 'zü 'ö 'a nu 'yi tɔ ꞊dhia zö.» ");
INSERT INTO dnj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","'Ö Yesu ‑ya pö ‑a ‑dhë: «'Dho 'ü ü ꞊gɔn ꞊dhɔɔ kë kö 'ka nu zö.» ");
INSERT INTO dnj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","'Ö dhebɔ bhë 'ö‑ pö: «'Maa gwaan.» 'Yö Yesu ‑ya pö ‑a ‑dhë: «‑A pö 'ü‑ wo 'bhaa gwaan bhë, ü‑ ‑pö ‑së; ");
INSERT INTO dnj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","'wun gia‑ ‑mü, 'ö bhii gɔɔn‑ 'ö 'ka ka 'ko 'piö bhë, ü ꞊gɔn 'yaa ‑mü. A‑ ꞊tɛi' dɔ 'pö ꞊nɛ kë‑ wo bhë 'bha 'dho gwaan ‑gwaa 'sɔɔdhu ‑zë wo.» ");
INSERT INTO dnj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","'Ö dhebɔ bhë 'yö‑ pö: «꞊Ee, ‑Zlan ‑wodhiölomɛ ‑mü ü 'ka a, n ‑Gɔmɛ! 'Ma ü dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kë‑ wo 'kpa bhë yi dë ‑nu ‑wo ‑Zlan ‑gba, ‑tɔn 'ö ꞊nɛ ‑a tuö; 'yö ka ‑zë, 'ka Zuifö 'ka, 'ka‑ pö, ‑dhɛ 'ö ‑Zlan gbadhɛ 'ka, ‑yö Zeluzalɛmë.» ");
INSERT INTO dnj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","'Ö Yesu ‑ya pö ‑a ‑dhë: «Dhebɔ, a‑ ‑pö ü ‑dhë, 'töng do 'bhaa ‑yö nu ‑na 'ö n Dë gbadhɛ yaa 'dhö kë ‑tɔn ꞊nɛ ‑a tuö 'iin Zeluzalɛmë. ");
INSERT INTO dnj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ka ‑zë pë 'ö 'kaa‑ dɔ ꞊nɛ 'ö 'ka‑ gba. Yi 'pö yi‑ ‑dɔ 'ö bhii dhasü 'ö 'ka‑ ‑ga ‑na bhë, ‑yö ‑go Zuifö ‑nu 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","'Kɛɛ 'töng 'bhaa 'ka, 'ö‑ ‑de ꞊ya ‑lo 'saadhö, mɛ ‑nu 'wo ‑Zlan gbamɛ ‑nu giagia 'ka, ‑wo ‑dho n Dë gba ‑Zuu 'slööslö waa‑ 'wun giagia ‑an 'gü. 'Ö tɔɔ n Dë gbamɛ ‑nu ꞊suu'‑ bhë ꞊nɛ 'ö ‑an ‑wun 'yi ‑yö kan ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","‑Zlan bhë ‑Zuu ‑mü. ꞊Ya kë 'dhö, kö mɛ ‑nu 'wo‑ 'piö kö ‑wa gba bhë, ‑an ꞊dua' ‑mü kö ‑wa gba ‑Zuu 'slööslö waa‑ 'wun giagia ‑an 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","'Yö dhebɔ bhë 'yö‑ pö ‑a ‑dhë: «A‑ ꞊tɛi' ‑dɔ ꞊nɛ Mesi 'wo‑ ‑dhɛ Klito 'ö ‑Zlan ‑bha ‑Yamɛ 'ka bhë, ‑yö ‑dho nu. ꞊Ya kë ꞊nɛ ꞊ya nu, yö ꞊nɛ 'ö ‑dho pë 'plɛ ‑zɔn kwa ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","'Ö Yesu ‑ya pö ‑a ‑dhë: «Ma ‑mü, ma 'a 'wun ꞊blɛɛ' ‑na ꞊nɛ!» ");
INSERT INTO dnj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","'Yö to mü 'ö‑ ‑bha ꞊guë' ‑nu ‑wo ‑lo; 'ö ‑an 'te ‑yö tun kö ‑wo Yesu yö kö waa‑ dhebɔ bhë ‑wo 'wun ꞊blɛɛ' ‑na wo 'ko ꞊bhaa. 'Kɛɛ kë‑ wo 'dhö bhë, mɛ yaa kë ‑dhö ‑an ziën kö pë 'wo ‑kë ‑a ‑ta ‑wun ꞊blɛɛ' ꞊dhia bhë, ‑ya ‑wun ꞊dhɛɛ' kpɔ ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","'Yö dhebɔ bhë, 'ö ö ‑bha 'yi ‑tɔ ‑a 'gü ‑gbɔ to sia‑ mü 'ö dho plöö 'ö‑ pö mɛ ‑nu ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«‑Ka nu 'dhɛ! Gɔɔn‑ do ‑yö ‑de. Pë ‑nu 'a‑ ‑kë 'töüdhö bhë, ꞊yaa‑ 'plɛ ꞊blɛɛ'‑. ‑Ka nu 'dhɛ, ‑yö ‑dho kë ‑Zlan ‑bha ‑Yamɛ 'wo‑ ꞊wɔɔn ‑na bhë ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","'Yö 'wo ‑ziö 'töüdhö, 'wo go plöö 'wo dho ‑dhɛ 'ö ‑kë ‑a ‑bha bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","‑A 'töng bhë ‑a 'ka, ‑a ‑bha ꞊guë' ‑nu ‑wo ‑kë ‑gban ‑a ‑bha ‑sü 'gü ꞊nɛɛ: «Labi, ‑bhö pë ‑bhö ‑ee!» (꞊Waa‑ pö «Labi» Eblö ‑wo 'gü kö ‑wa ‑pö «‑Gɔmɛ».) ");
INSERT INTO dnj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","'Kɛɛ ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Bhöpë 'ö 'kaa‑ dɔ ‑yö n ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","'Yö 'wo yö ‑a pö ‑süë wo 'ko ‑nu ‑dhë: «‑Yö ‑dho kë, mɛ 'bhaa ꞊ya nu ‑a ꞊dhia ‑bhöpë 'ka, ꞊yaa‑ ‑bhö.» ");
INSERT INTO dnj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","'Yö‑ pö ‑an ‑dhë: «Ma ‑bhöpë 'ö tɔɔ mɛ 'ö n bɔ bhë kö 'aan‑ ‑a ‑zo 'kun ‑wun kë 'iin kö pë 'ö n bɔ ‑a ‑wun 'gü bhë, 'aan‑ ‑a 'dhiö ‑mɔ 'kuë. ");
INSERT INTO dnj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ka ‑zë, ka‑ ‑pö: ‹'Su ‑yiisië 'ö ꞊tun ‑dhö kö 'kwaan‑ 'blee‑ ‑kpa 'kan›. 'Kɛɛ a‑ ‑pö ka ‑dhë: ‑Ka ‑dhɛ ‑ga 'dhɛ, 'blee‑ ꞊bhlödhɛ ‑nu ꞊wa ga 'saadhö; ‑an 'kan ‑sü ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mɛ 'ö pë ta ‑na ‑yö ‑dho ö ꞊saan' yö. 'Ö mɛ 'ö pë 'ö mɛ bhë 'ö‑ ta bhë, 'ö‑ 'kan ‑na, 'ö‑ 'kpɔ ‑na 'kuë‑ 'slëëdhö bhë, 'yö dho ö ꞊saan' yö 'pö. ‑Kɔ do bhë 'ö‑ 'ka, mɛ ‑nu 'wo ‑Zlan ‑bha yuö 'gü ꞊toëpö ‑këdhösü 'gbloo 'piö bhë ‑a 'gü 'pö 'ö ꞊ya kë 'ö ‑an ꞊zuö' 'glu ‑yö dhi; 'ö tɔɔ mɛ 'ö pë ta waa‑ mɛ 'ö pë ‑kan kö mɛ 'ö ‑dhö ꞊ya ö ꞊saan' yö. ");
INSERT INTO dnj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","'Wun ꞊blɛɛ' ‑wo do ‑ya ‑pö: ‹Mɛ do ꞊yaa‑ ‑ya, 'ö mɛ 'waa gbɛ ‑ya ‑kan›. ‑Wo bhë ‑yö 'wun gia‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","'Ö tɔɔ 'ma ka bɔ kö ‑dhɛ 'ö kaa kë ‑a ‑bha ‑a züdɔyi 'ka, 'kaan‑ ‑a ‑ya bhë, kö 'kaan‑ ‑a 'kan. Mɛ 'kpaan gbɛ ‑nu ‑bha yuö bhë ꞊nɛ 'ö 'ka ka ‑de ‑da ‑a 'gü bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","'Töng bhë ‑a 'ka, Samali ‑pö bhë ‑a 'gü ‑mɛ ‑nu ‑wo ‑kë ꞊va 'wo Yesu ‑wun ‑dhɛ 'wun gia‑; kë‑ wo 'dhö bhë, ‑yö ‑sü 'wun 'ö dhebɔ bhë 'ö‑ ꞊blɛɛ ‑an ‑dhë bhë ‑a ‑bha; 'ö tɔɔ ‑ya ‑pö ‑an ‑dhë: («Gɔɔn‑ ꞊nɛ,) pë ‑nu 'a‑ ‑kë 'dhiö 'saadhö bhë, ꞊ya bɔ ‑a 'plɛ 'gü ꞊yaa‑ ꞊blɛɛ'‑.» ");
INSERT INTO dnj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","'Yö ꞊dhɛ ꞊ya kë 'dhö, 'ö Samali ‑mɛ ‑nu ‑wo nu 'wo‑ pö ‑a ‑dhë wo ‑nu ‑wo wo 'bhle ꞊waannu. 'Yö Yesu ‑yö ‑dhɛkpaɔyi ꞊plɛ ‑kë ‑an 'piö mü. ");
INSERT INTO dnj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","‑Aa', kë‑ wo 'dhö zlöö bhë, mɛ ‑nu ‑wo ‑kë ꞊va giagiawo 'ö 'wo‑ ‑wun ‑dhɛ 'wun gia‑ ‑wo ‑nu 'wo ‑kë ‑go ‑a dhiö ꞊dhia bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","꞊Dhɛ ꞊ya 'go mü, 'wo‑ pö dhebɔ bhë ‑a ‑dhë: «Yi ‑zo yö ‑sü ‑mü gɔɔn‑ 'ö ꞊nɛ ‑a ‑bha ꞊nɛ yö 'ö tɔɔ 'kpongtaamɛ ‑nu Dhamɛ; 'yö 'dhö gia‑ 'ka; 'kɛɛ ꞊dhɛ 'yi‑ ‑ga ‑a 'gü zlöö bhë yaa kë ꞊nɛ 'wun ‑nu 'ü‑ ꞊blɛɛ yi ‑dhë bhë ꞊nɛ 'yi ‑gban ‑a ‑ta, 'ö bhii yi ‑de gia‑ ‑a ‑wo ‑nu ꞊wa ‑da yi 'toudhö, 'yië ‑an ma.» ");
INSERT INTO dnj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","꞊Dhɛ 'ö ‑dhɛkpaɔyi ꞊plɛ bhë, 'ö Yesu ꞊yaa‑ kë 'dhö mü, ‑yö ‑go mü 'ö dho Galile ‑sɛ 'gü ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kë‑ wo 'dhiö bhë, Yesu ‑ya ‑pö 'wun ꞊zuan' 'ka ꞊nɛɛ: «‑Zlan ‑wodhiölomɛ ꞊bhlë 'yaa 'dhö ‑a ‑de ‑sɛ 'gü» bhë, ");
INSERT INTO dnj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","꞊dhɛ ꞊ya 'dho ꞊ya ‑lo Galile ‑sɛ 'gü, 'ö 'wo‑ ‑nia kun ‑së 'ka giagiawo, 'ö bhii wo ‑de 'pö, Paakö 'wlaan‑ 'ö ‑kë Zeluzalɛmë bhë, ‑wo ‑kë ‑a ‑ta 'ö pë ‑nu 'ö‑ ‑kë 'töüdhö bhë 'ö ‑kë ‑an 'yaan 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","꞊Dhɛ ꞊wa ‑lo Galile ‑sɛ bhë ‑a 'gü, ‑wo ‑dho 'wo ‑da Kana plöö, ‑dhɛ 'ö 'yi ‑gla ‑a ‑bha yɔ 'gü bhë ‑a ‑bha. Pö‑ bhë ‑a 'gü, 'sɛdë ‑bha yuökëmɛ ꞊bhlëzë do ‑yö ‑kë mü. 'Yö gɔɔn‑ 'ö bhë 'ö‑ ‑bha 'në do ‑yö ‑kë 'yuazë; 'kɛɛ 'në bhë ‑yö ‑kë Kapɛɛnaɔmë. ");
INSERT INTO dnj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","'Yö ꞊dhɛ ꞊yaa‑ ma ꞊nɛ Yesu ꞊ya 'go Zude ‑sɛ 'gü ꞊ya nu Galile mü, 'yö dho ‑a 'piö 'ö ꞊bhɛa ‑a ‑dhë kö ‑yö 'dho Kapɛɛnaɔmë ‑yaan ö gbö 'ö ꞊ya bhɔ ga ‑sü ‑bha bhë ‑a ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","'Ö Yesu ‑ya pö ‑a ‑dhë: «Kaa ‑mɔa 'ka 'wun ‑dhɛ 'wun gia‑ 'kpaan 'ka kö kaa ‑dhidhaapë ‑nu yö 'iin ka 'yan yaa ‑da 'wun 'gblüünzë ‑nu 'gü a!» ");
INSERT INTO dnj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","'Yö gɔɔn‑ bhë 'yö‑ pö Yesu ‑dhë: «N dë, ‑dhɛ 'ö ma 'në yaa ga kun ꞊nɛɛ, ‑bhö nu ꞊ii!» ");
INSERT INTO dnj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","'Yö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö 'dho, ü ‑bha 'në 'ka 'dho ga.» 'Yö gɔɔn‑ bhë, 'ö Yesu ‑wo ‑dhɛ 'wun gia‑, 'ö ‑ziö 'ö dho. ");
INSERT INTO dnj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","‑Yö ‑kë 'dho ꞊dhia ö ꞊plöö, 'ö‑ ‑bha yuökëmɛ ‑nu ‑wo nu ‑a ‑gɔ zian‑, 'wo‑ pö ‑a ‑dhë: «Ü ‑bha 'në ‑yö 'bhee‑!» ");
INSERT INTO dnj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","'Yö ö ‑bha yuökëmɛ ‑nu ꞊dhɛɛ' kpɔ 'töng 'ö‑ gbö 'bhle ‑yö ꞊kaa' 'waa, ‑a ‑wun 'ka; 'ö 'wo‑ pö ‑a ‑dhë: «‑Yö ‑kë 'dhö kö lan‑ ꞊ya 'go kwa ‑gɔ ziën 'dɛdɛ 'ka yɛɛn, 'ö‑ kwigüdhɛ ‑yö kë ‑saa.» ");
INSERT INTO dnj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","'Yö gɔɔn‑ bhë 'ö‑ ‑zo ‑yö ‑lo 'töng 'ö Yesu ‑ya pö ‑a 'ka ‑a ‑dhë: «ü ‑bha 'në 'ka 'dho ga» ‑a ‑wun ‑ta; 'ö‑ yö ꞊nɛ 'wun ꞊plɛ 'wo bhë ‑wo ‑kë 'töng do 'ka. 'Yö 'wun bhë 'yö ‑kë ‑a ‑gɔ 'kɔɔmɛ ‑nu 'plɛ ‑bɔ ‑a ‑ta ‑wun 'ka 'yö 'wo Yesu ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","‑Dhidhaa ‑wun kë ꞊plɛ ‑naa 'ö Yesu ‑ya ‑kë kö ꞊ya 'go Zude ꞊ya nu Galile 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","꞊Dhɛ ꞊ya 'go mü, Zuifö ‑nu ‑bha 'wlaan‑ ‑yö ‑kë ‑dhö, 'ö Yesu ‑yö ‑ziö 'ö dho Zeluzalɛmë. ");
INSERT INTO dnj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pödhɛ bhë ‑a 'gü, 'pian mɛ 'ö 'bhla ‑tuë ‑nu ‑yö plaan ‑dhɛ 'ka bhë, 'yipuë 'ö mɛ ‑nu ‑wa dho 'kuë‑ ‑yö ‑kë ‑a ‑bha; yö ꞊nɛ 'ö‑ ‑dɔ dhɔngdhɛ ‑nu ‑bha ‑dhɛ 'dhi 'dhö 'sɔɔdhu. 'Yipuë bhë ꞊nɛ 'wo‑ ‑dhɛ Eblö ‑wo 'gü «Betesaida». ");
INSERT INTO dnj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","'Yipuë bhë, ‑a ‑da ‑a ꞊bhaa ‑zian 'sɔɔdhu 'wo bhë, 'yuamɛ ꞊plëëzë ‑nu 'wo ‑kë 'yënngtiimɛ ‑nu, ‑gɛntɔsiömɛ ‑nu, 'tinngmɛ ‑nu ‑an 'ka ‑wo ‑kë ‑lo ‑sü 'ka mü. Pë 'wo ‑ya ‑a ‑gɔ ‑dhɛ bhë ‑a ‑bha 'ö tɔɔ kö 'yi ‑yaan ꞊tuun'‑. ");
INSERT INTO dnj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kë‑ wo bhë 'ö tɔɔ, ꞊ya kë Dëmɛ ‑bha bɔmɛ do ‑yö ‑yɔɔ 'yi bhë ‑a ꞊bhaa 'ö 'yi ‑yö ꞊tuun. 'Ö ꞊ya kë 'dhö, 'yuamɛ ‑blɛɛzë 'ö ‑püö ‑na 'yi bhë ‑a ꞊bhaa bhë, 'yua ꞊suu'‑ 'oo ꞊suu'‑ 'ö‑ ‑bha, ‑yö ‑bo. ");
INSERT INTO dnj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","'Töng bhë ‑a 'ka, gɔɔn‑ do 'ö 'yua ꞊yaa‑ 'yënng bhɔ ‑kwɛ 'gɔɔ‑ ‑yaaga ö ga 'slɛaga 'piö ‑yö ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu ‑yö ‑kë ziö ꞊dhia, 'ö‑ 'yan ‑yö ‑kpën ‑a ‑bha. 'Ö ꞊dhɛ ꞊yaa‑ dɔa ꞊nɛ 'yua 'ö‑ ‑bha bhë ꞊yaa‑ 'kun ‑a ‑dhɛ ꞊ya ꞊glɔɔ bhë, 'yö‑ ꞊dhɛɛ' kpɔ ꞊woë' ꞊nɛɛ: «ü‑ 'piö kö ü ‑dhɛ ‑yö bo ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","'Yö 'yuamɛ bhë 'yö‑ pö: «N ‑Gɔmɛ, mɛ gbɛ 'yaa n ‑gɔ, kö ꞊ya kë ꞊nɛ 'yi ꞊ya ꞊tuun' kö ‑yaan n ‑zuö ‑a ꞊bhaa. 'Yi ꞊ya ꞊tuun 'dhö, ‑a kë ꞊yië' kö 'aan‑ ꞊bɔɔ 'bɔ ‑an songdhö 'aan‑ ‑püö ‑a ꞊bhaa kö mɛ gbɛ ꞊ya ‑püö ‑a ꞊bhaa 'saadhö n 'dhiö.» ");
INSERT INTO dnj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","꞊Dhɛ ‑kë 'dhö 'ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö ꞊luu'‑; ü ‑bha ꞊sɛɛ' 'sü 'ü 'ta.» ");
INSERT INTO dnj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","‑Dhɛ do bhë 'ö to ‑a ‑bha 'ö gɔɔn‑ bhë, 'ö‑ ‑dhɛ ‑yö bo; 'ö ö ‑bha ꞊sɛɛ' ‑be ‑kë 'ö yö 'ta 'sü ‑sü ‑bha. Yi 'Ö 'wun bhë 'ö ꞊kaa' bhë, ‑yö ‑kë Zuifö ‑nu ‑bha ꞊glooyi 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","'Yö ꞊dhɛ ‑kë 'dhö, 'ö Zuifö ‑nu ‑gɔmɛ ‑nu ‑wa pö gɔɔn‑ 'ö‑ ‑dhɛ ‑yö bo bhë ‑a ‑dhë: «꞊Glooyi kun tɔɔ ꞊dɛɛ ꞊a? 'Yö ꞊dhɛ ‑kë 'dhö ꞊nɛ ü ‑dɔ 'më 'ü ü ‑bha ꞊sɛɛ' bun ꞊i?» ");
INSERT INTO dnj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","'Yö‑ pö ‑an ‑dhë: «Mɛ 'ö n ‑dhɛ bo bhë ‑ya ‑pö n ‑dhë 'a n ‑ma ꞊sɛɛ' 'sü 'a 'ta.» ");
INSERT INTO dnj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","'Yö 'wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Mɛ 'ö‑ pö ü ‑dhë: ‹Ü ‑bha ꞊sɛɛ' 'sü, 'ü 'ta bhë› dö ‑mü poo ꞊e?» ");
INSERT INTO dnj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","'Kɛɛ kë‑ wo 'dhö bhë gɔɔn‑ bhë, mɛ 'ö‑ ‑dhɛ bo bhë yaa‑ dɔ gbɔ 'ö bhii kö Yesu ꞊ya ‑da mɛ kpö 'gü mü. ");
INSERT INTO dnj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","꞊Dhɛ 'ö pë ‑nu bhë ꞊wa kë 'dhö, ‑wo ‑dho ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü. ‑Dhɛ bhë Yesu 'yan ‑yö ‑dɔ 'zü gɔɔn‑ bhë ‑a ‑bha. 'Yö‑ pö ‑a ‑dhë: «‑Bhö ‑dhɛ ‑ga! Ü ‑dhɛ ꞊ya bo; ꞊ya kë 'dhö kö ꞊kun 'ü ꞊sɔɔn yaa ‑kë gbɔ, kö ꞊kun 'ö 'wun 'gbee‑ mɛ 'ö ‑ziö ‑a mɛ ꞊nɛ ‑a ‑ta 'ö dho ü yö.» ");
INSERT INTO dnj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","(‑Dhɛ bhë ꞊nɛ 'ö gɔɔn‑ bhë 'ö dɔa ‑bha ꞊nɛ Yesu ꞊nɛ 'ö‑ ‑dhɛ bo,) 'yö 'ö ‑ziö 'ö dho Zuifö ‑nu ‑gɔmɛ ‑nu 'piö 'ö‑ pö ‑an ‑dhë ꞊nɛɛ Yesu ꞊nɛ 'ö‑ ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","‑A ‑kë 'dhö ‑sü ‑wun 'gü, 'wo yö Yesu 'piö kë ‑sü 'gü kö ‑wo 'wun wɔ ‑a ‑ta 'ö bhii pë ‑nu 'ö‑ kë bhë ‑ya ‑kë 'dhö ꞊glooyi 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","'Yö Yesu ‑ya pö ‑an ‑dhë: «N Dë ‑yö ꞊tun yuö kë ‑sü 'gü ‑kplawo; 'ö ma ‑de, 'a yuö kë ‑sü 'gü 'pö.» ");
INSERT INTO dnj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","‑Wo ‑nu 'wo go Yesu dhiö 'dhö bhë ‑a ‑wun 'gü, Zuifö ‑nu ‑gɔmɛ ‑nu ‑wo ‑kë ‑a këdhɛ ꞊mɛɛ' ꞊dhia zlöö kö ‑waan Yesu zë. 'Ö bhii ꞊ya ‑an ‑bha tɔng 'ö ‑gban ꞊glooyi ‑bha bhë ‑a ‑lö 'gü, ꞊ya 'go mü ꞊ya ö ‑de ‑zɔn ‑Zlan 'ka, ‑a pö 'ö‑ wo yö ꞊nɛ 'ö tɔɔ ‑Zlan Gbö gia‑ bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ ꞊nɛɛ: «A‑ ‑blɛɛ ka ‑dhë 'wun giagia 'ka ꞊nɛ ma 'a ‑Zlan Gbö 'ka bhë 'maa 'wun gbɛ 'sü n ‑de 'gü 'maa‑ kë; pë 'a n Dë yö ‑a kë ꞊dhia ꞊nɛ 'ö 'a‑ ‑kë. Pë 'saadhö 'ö n Dë ‑ya ‑kë, a‑ ‑kë 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","'Ö bhii n Dë ‑yö n ‑dhɔ ‑kë, 'ö ö ‑de këpë ‑nu 'plɛ ‑zɔn n ‑dhë. ‑A këpë ‑nu 'wo ꞊va, 'wo ‑ziö ‑a mɛ ‑nu 'wo ꞊nɛ ‑an ‑ta bhë, ‑yö ‑dho ‑an ‑zɔn n ‑dhë kö ‑yaan kë; 'ö ka 'te dhö tun. ");
INSERT INTO dnj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","'Ö tɔɔ ‑kɔ do 'ö n Dë 'dhö gamɛ ‑nu bho ‑na ‑a 'ka ga 'gü 'ö ‑këdhösü nu ‑na ‑a 'ka ‑an ‑dhë bhë, 'ö 'a ‑këdhösü nu ‑a 'ka mɛ ‑nu 'a‑ 'piö kö 'a‑ nu ‑an ‑dhë bhë ‑an ‑dhë 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","N Dë 'ö 'ka‑ ‑ga ‑na bhë, 'yaa za ‑lo mɛ gbɛ ‑bha; 'kɛɛ ꞊ya ‑kɔ ‑mɔ 'wuën‑ ‑sü 'plɛ nu n ‑dhë kö 'aan‑ ‑a kë, ");
INSERT INTO dnj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","‑yö kë 'dhö kö mɛ 'plɛ ‑waan n ꞊bhlë ‑ya ꞊nɛ ‑kɔ 'wo n Dë ꞊bhlë ‑ya ‑na ‑a 'ka bhë ‑a 'dhö. ꞊Ya kë 'dhö, kö mɛ 'ö yaa n ꞊bhlë ‑ya, kö yaa n Dë 'ö n bɔ bhë ‑a ꞊bhlë ‑ya ꞊nɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","'Wun gia‑ 'ka, a‑ ‑pö ka ‑dhë: Mɛ 'ö ꞊ya ö 'to kë n ‑wo ‑bha, 'ö ꞊ya mɛ 'ö n bɔ bhë ‑a ‑wun ‑dhɛ 'wun gia‑, ꞊toëpö ‑kë ‑a 'gü ‑sü ‑ya ‑bha 'ka. Za 'ö dhö kan bhë, yö 'ka 'dho ‑lo ‑a tuö gbɔ; 'kɛɛ kö ꞊ya 'go ga 'gü 'saadhö ꞊nɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A‑ ‑pö ka ‑dhë 'zü 'wun gia‑ 'ka ꞊nɛ 'töng ‑yö nu ‑na, 'ö‑ ‑de ꞊ya nu 'saadhö, 'ö mɛ ‑nu ꞊wa ga 'ö 'wo dho ma 'a ‑Zlan Gbö 'ka n ‑wo ma; mɛ ‑nu 'ö 'töng bhë ‑a 'ka 'ö 'wo dho n ‑wo ma, ‑wo ‑dho dha. ");
INSERT INTO dnj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","'Ö bhii ‑kɔ do 'ö ‑kɔ ‑mɔ 'wuën‑ ‑sü 'dhoë‑ 'ka n Dë ‑gɔ kö ‑yaan ‑kë ‑a 'gü ‑sü nu ‑a 'ka mɛ ‑nu ‑dhë bhë, 'ö ꞊kaa' ‑a ‑dhë ‑së kö 'a‑ yö 'pö kö 'aan‑ ‑kë ‑a 'gü ‑sü nu ‑a 'ka mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","꞊Dhɛ ꞊ya kë 'dhö, 'yö ‑kɔ ‑mɔ 'wuën‑ ‑sü nu n ‑dhë kö 'aan‑ za 'kan; 'ö tɔɔ ma ꞊nɛ 'a tɔɔ Mɛgbö. ");
INSERT INTO dnj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kö ꞊kun 'ö ka 'te ‑yö tun; 'kɛɛ ‑a yi ‑yö nu ‑na 'ö gamɛ ‑nu 'plɛ 'wo ga ‑glu ‑nu 'gü, 'wo dho n ‑wo ma, ");
INSERT INTO dnj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kö ‑waan 'go ‑an 'gü ‑waan yö plaan. Mɛ ‑nu 'ö 'kpa, 'ö ‑an këwun ‑yö ‑kë ‑së, ‑wo ‑dho go ga 'gü ‑këdhösü 'ö ꞊toëpö 'ka ‑a 'gü; 'kɛɛ mɛ ‑nu 'ö ‑an këwun ‑yö ‑kë ya, ‑wo ‑dho go ga 'gü kö za ‑yaan ‑an 'kun ‑an 'klo ‑yaan bhɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","'Ö‑ pö 'zü: «Ka‑ ‑yö bhë ꞊a? ꞊Ya kë 'dhö kö n ‑kɔ yaa ‑mɔa ‑bha gbɔ 'a 'wun ‑nu 'sü n ‑de 'gü 'a‑ kë. Za 'a‑ dɔ ‑na bhë, ‑Zlan ꞊nɛ 'ö‑ pö n ‑dhë 'a‑ dɔ, 'ö‑ ‑de ma za 'a‑ dɔ ‑na bhë 'ö kpengdhö 'ö tɔɔ yaa kë ꞊nɛ n ꞊dhɔɔbhaa ‑wun 'a‑ ꞊mɛɛ'‑ kö 'aan‑ kë; 'kɛɛ mɛ 'ö n bɔ bhë ꞊nɛ 'a‑ ‑zo 'kun ‑wun ‑kë. ");
INSERT INTO dnj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","꞊Ya kë ꞊nɛ 'ma ‑tɔmɔdhɛ kë n ‑de ‑bha, yaa ‑mɔ kö n ‑gɔ ‑wun ‑yaan kë 'wun gia‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","'Kɛɛ mɛ gbɛ ꞊nɛ 'ö ‑tɔmɔdhɛ ‑kë n ‑ma, 'ö ma gia‑ 'a‑ dɔ ꞊nɛ ‑tɔmɔdhɛ 'ö‑ kë ‑na n ‑blü 'gü bhë, ‑yö 'wun gia‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kë‑ wo bhë, kaa mɛ ‑nu bɔ Zan 'piö kö ‑yaan n dɔ ‑kɔ ꞊blɛɛ ka ‑dhë ‑a? 'Ö ‑ka ‑dhɛ ‑ga bhë! ‑Tɔmɔdhɛ 'ö‑ kë bhë ‑yö 'wun gia‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma ‑zë, n ‑ma ‑wun 'yaa‑ 'ka mɛ ‑bha ‑tɔmɔdhɛ 'ka n ‑blü 'gü, 'kɛɛ 'wun ‑nu bhë a‑ ‑blɛɛ 'dhö kö 'kaan‑ dhasü yö. ");
INSERT INTO dnj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zan ‑yö ‑kë ꞊nɛ ꞊labang 'ö dɔ, 'ö 'bhü ‑na ‑a 'dhö. 'Ö 'ka‑ ꞊mɛɛ ꞊zian' kö 'ka ꞊zuögludhi kë ‑a ‑bha ‑dhɛpuudhɛ ‑bha 'töng kpö 'bhaa ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","'Kɛɛ ‑yö kë ka 'yaan ꞊nɛ n ‑ma ‑tɔmɔdhɛ ꞊yö ꞊va 'ö ‑ziö ‑a 'ka Zan ‑bha ‑ta; bhii 'wun ‑nu 'ö n Dë ‑ya ‑lo n kwɛɛ kö 'aan‑ ‑an kë bhë, 'ö 'wo bhë, wo ꞊nɛ 'ö 'wo ‑tɔmɔdhɛ ‑kë n ‑blü 'gü ꞊nɛ n Dë 'ö n bɔ. ");
INSERT INTO dnj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","‑A ‑de n Dë 'ö n bɔ bhë, yö ‑de gia‑ ꞊ya ‑tɔmɔdhɛ kë n ‑blü 'gü ꞊nɛ 'wun gia‑ ‑mü. Yö 'ö bhë, kaa‑ ‑wo ma do 'iin kaa‑ yö do. ");
INSERT INTO dnj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","'Kɛɛ ‑a ‑wo 'ö bhë, ‑yö kë ka 'yaan ꞊nɛ 'yaa ka 'gü 'ö bhii mɛ 'ö‑ bɔ ('ö n 'ka bhë), 'kaa n ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ka ‑kpɔɔ ‑Zlan ‑bha 'sëëdhɛ ‑nu 'gü, 'ö bhii ‑yö ka ‑zo 'piö ꞊nɛ wo ꞊nɛ 'wo dho ꞊toëpö ‑kë ‑a 'gü ‑sü nu ka ‑dhë; 'yö 'kaa‑ ꞊tɛi' dɔ 'sa ꞊nɛ wo ꞊nɛ 'wo ‑tɔmɔdhɛ ‑kë n ‑blü 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","'Ö 'ka dɔ bhë 'ö 'kaa nu n 'piö kö 'kaan‑ ‑kë ‑a 'gü ‑sü giagia yö bhë, ꞊ao'! ");
INSERT INTO dnj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‑Yö kë ka 'yaan ꞊nɛ, pë 'ö ‑kë ꞊bhlëyadhɛ 'ka 'ö go mɛ 'bhee‑ ‑nu 'gü bhë 'yaa ‑mü 'a‑ ꞊mɛɛ. ");
INSERT INTO dnj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","A ka ‑dɔ; 'ö tɔɔ a‑ ꞊tɛi' ‑dɔ ꞊nɛ ‑Zlan ‑dhɔ 'yaa ka 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","‑Ka ‑dhɛ ‑ga 'dhɛ! Ma 'a ꞊nɛ, nu 'a‑ wo bhë, n Dë ꞊nɛ 'ö n bɔ; 'ö 'kaa n 'kun ‑së. 'Kɛɛ mɛ 'waa gbɛ ꞊ya ‑nu, ꞊ya 'wun ‑nu 'sü ö ‑de 'gü ꞊yaa‑ kë, 'ö 'ka‑ kun ‑së. Ka‑ ‑yö bhë ꞊a? ");
INSERT INTO dnj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ka‑ ‑dhɔ ‑kë kö mɛ ‑nu ‑wo ka ꞊bhlë ‑ya kö ka ‑de 'pö 'kaan‑ ‑an ꞊bhlë ‑ya; 'ö pë mɛ 'ö ‑kë ‑kë ꞊bhlëzë ‑sü 'ö go ‑Zlan 'ö dosɛn ‑a 'piö ‑a 'ka bhë 'ö 'kaa‑ ꞊mɛɛ'‑. ꞊Ɛɛ, 'ö ꞊ya kë 'dhö ka ‑dho 'wun gia‑ ‑dhɛ 'wun gia‑ ‑kɔklë 'sa 'ö 'ka dɔa bhë ꞊ɛɛ? ");
INSERT INTO dnj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","'Kɛɛ kö ꞊kun 'ö ‑kë ka ‑zo 'piö ꞊nɛ ma ꞊nɛ 'a dho za ‑lo ka tuö n Dë wö 'dhiö; mɛ 'ö dho za ‑lo ka tuö 'ö tɔɔ Moizö 'ö ka ‑zo ‑dɔ ‑a ‑bha ‑wun ‑nu 'plɛ ‑wo go ‑a 'gü bhë. ");
INSERT INTO dnj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moizö 'ö bhë, ꞊ya kë ꞊nɛ ka‑ ‑wo ‑nu ‑dhɛ 'wun gia‑ ‑bezë (gia‑ 'ka) kö ka ‑dho ka ‑zo yö n ‑ma, 'ö bhii ma ꞊nɛ 'ö 'wun ‑gban n ‑ma, 'ö‑ ꞊bɛɛn 'sëëdhɛ 'gü ka ‑dhë bhë. ");
INSERT INTO dnj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","꞊Ɛɛ, 'ö ꞊ya kë ꞊nɛ 'kaa pë ‑nu 'ö ꞊bɛɛn 'sëëdhɛ 'gü ka ‑dhë bhë ‑a ‑dhɛ 'wun gia‑ kö ka ‑dho n ‑wo ‑nu ‑dhɛ 'wun gia‑ ‑kɔklë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","꞊Dhɛ 'wun ‑nu bhë ꞊wa kë 'dhö, Yesu ‑yö ‑go mü 'ö dho Galile 'yipuë ('wo‑ ‑dhɛ Tibeliasë 'yipuë bhë) ‑a ꞊zlöö ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mɛ ‑gbaa ꞊va ‑wo ‑ziö ‑a 'piö ‑dhidhaapë ‑nu 'yö ‑kë ‑a kë ꞊dhia bhë ‑a ‑wun 'gü, 'ö tɔɔ ‑yö ‑kë 'yuamɛ ‑nu ꞊plëëzë ‑dhɛ bo ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","'Yö Yesu ‑yö ‑da ‑tɔn do tuö, 'ö waa‑ ö ‑bha ꞊guë' ‑nu 'wo ꞊yaannu. ");
INSERT INTO dnj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","꞊Dhɛ pë ‑nu bhë 'wo kë ‑na 'dhö, kö Paakö 'ö ‑kë Zuifö ‑nu ‑bha 'wlaan‑ 'ka bhë, kö ‑a yi ꞊ya yö ꞊klöö'. ");
INSERT INTO dnj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","'Yö ‑dhɛ 'ö Yesu ‑ya ‑ga kö mɛ ‑gbaa ꞊va ‑wo nu ‑na ‑a 'piö; ꞊dhɛ ‑kë 'dhö 'ö‑ pö Filipö ‑dhë: «Mɛ ‑nu 'wo ꞊nɛ 'töüdhö, ‑dhɛ ‑mlë 'kwa dho ‑bhöpë yö ‑a ‑bha kö 'kwaan‑ 'dhɔ 'kwaan‑ nu ‑an ‑dhë ‑waan ‑bhö ‑ee?» ");
INSERT INTO dnj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Kë‑ wo 'dhö bhë, ꞊dhɛɛ' bhë ‑ya ‑kpɔ 'dhö kö ‑kɔ 'ö‑ 'ka Filipö ꞊zuö' 'gü kö ‑yaan ‑dhɛ yö ‑a 'gü; 'yaa 'pö, yö ‑zë ‑ya 'slë ‑dɔ ö ‑de ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","'Yö Filipö ‑ya pö ‑a ‑dhë: «'Kö ‑kë ꞊nɛ 'wëü‑ ꞊va 'ö dho ‑mɔ dönie ꞊këng' ꞊plɛ ‑bha ‑a ꞊bluu'‑ ‑mü 'kwa‑ ‑dhɔ ‑dewo, yaa 'dho pë gbɛ sü ‑an ‑bha, kö mɛ 'plɛ ‑waan ‑a 'klu yö.» ");
INSERT INTO dnj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","'Yö‑ ‑bha ꞊guë' ‑nu 'wo bhë, ‑a mɛ 'wo‑ ‑dhɛ Andre 'ö ‑kë Simɔ Piɛɛ 'zlaa‑ 'ka bhë, 'ö‑ pö ‑a ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«'Nëgɔɔnzë do ꞊ga 'ö dɔ ‑de, 'klën ꞊bluu'‑ bhɛ 'sɛnsɛn 'sɔɔdhu waa‑ 'yuö‑ ꞊plɛ ‑wa kwɛɛ. 'Kɛɛ ‑më tɔɔ ꞊bluu'‑ bhɛ 'sɛnsɛn 'sɔɔdhu waa‑ 'yuö‑ ꞊plɛ mɛ ‑gbaa ꞊va 'wo ꞊nɛ ‑an ‑bha 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","꞊Dhɛ ꞊ya kë 'pö, 'ö Yesu ‑ya pö: «‑Ka ‑yadhɛ nu mɛ 'plɛ ‑dhë!» 'Wo ꞊yaannu 'kpaa ‑ta mü, bhii ‑dhɛ bhë ꞊blëë' ‑yö ‑kë ‑a ‑bha ꞊va. Mɛ ‑nu 'wo bhë gɔɔn‑ ‑nu 'wo ‑kë ‑an 'piö ‑wo ‑dho ‑mɔ mɛ ‑lü ‑vuu 'sɔɔdhu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","'Yö Yesu ‑yö ꞊luu 'yö ꞊bluu'‑ bhɛ 'sɔɔdhu bhë ‑an sü. 'Yö ‑Zlan zuö pö ‑a ‑ta; 'yö‑ ‑glu mɛ ‑nu 'wo ‑kë ‑ya ‑sü 'ka mü bhë ‑an 'ka. ‑Kɔ do bhë 'ö‑ ꞊kaa' 'yuö‑ ꞊plɛ 'wo bhë ‑an 'ka 'ö ‑an ‑zo kun 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","꞊Dhɛ wo 'plɛ ꞊wa yën pë ‑bhö ‑sü ‑bha ‑së 'ka, 'ö Yesu ‑ya pö ö ‑bha ꞊guë' ‑nu ‑dhë: «꞊Bluu'‑ 'kluklu ‑nu 'wo to bhë, ‑ka ‑an 'dho 'kuë‑ kö ꞊kun 'ö‑ 'bhaa ‑yö ‑kë 'gü ꞊siö'‑ ‑pë 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'Wo‑ 'kluklu ‑nu 'wo to kö mɛ ‑nu ꞊wa yën pë ‑bhö ‑sü ‑bha bhë ‑an dho 'kuë‑, 'ö ꞊kpasɛn 'gɔɔ‑ do ö ꞊ga ꞊plɛ pa. ");
INSERT INTO dnj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","꞊Dhɛ mɛ ‑nu 'yan ꞊ya ‑da ‑dhidhaapë 'ö Yesu ‑ya ‑kë bhë ‑a 'gü, 'wo‑ pö: «Mɛ ꞊nɛ, ‑Zlan ‑wodhiölomɛ 'wo‑ pö ‑yö ‑dho nu 'kpongtaa bhë, yö ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ꞊yaa‑ yö ꞊nɛ ‑wa 'piö kö 'wo ö ‑ya ‑gludë 'ka 'gbeetadhɛ 'ka, 'yö ꞊luu ‑an ziën mü, 'ö ‑da ö 'sloo 'ka ‑tɔn bhë ‑a tuö. ");
INSERT INTO dnj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","꞊Dhɛ 'yiniadhɛ ꞊ya dɔ, 'ö Yesu ‑bha ꞊guë' ‑nu ‑wo ꞊yɔɔ, 'wo dho 'yipuë ꞊va bhë ‑a 'kpong 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","'Wo ‑da 'yitagɔ do 'gü kö ‑waan 'yi 'kan ‑waan 'dho Kapɛɛnaɔmë ꞊zian'. ꞊Dhɛ kë ‑na 'dhö kö ‑dhɛ ꞊ya trö, kö Yesu ‑de 'pö yaa nu ‑an 'piö ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","'Yi ‑yö ‑kë ‑ma ꞊dhiadhö 'gbee‑ 'ka, bhii 'buu ‑yö ‑kë ziö ꞊dhia 'gbee‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","'Yö ꞊dhɛ ꞊wa 'dho ꞊nɛ mɛ‑ dho 'kilong 'sɔɔdhu 'iin 'slado ‑naa ‑ta, ('wo dho ‑dhɛ ‑ga wo ꞊zlöö), kö Yesu ‑yö 'ta ‑na 'yi ‑ta, ꞊ya yö 'yitagɔ 'sɔɔ. 'Yö 'suö ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","'Ö Yesu ‑ya pö ‑an ‑dhë: «Kö ꞊kun 'ö 'suö ‑yö ka ‑kë, ma ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","'Wo‑ ‑kë ꞊nɛ mɛ dho ꞊gbaannu kö Yesu ‑yaan ‑da wo 'piö 'yitagɔ 'gü mü. 'Kɛɛ 'yitagɔ ‑yö ‑gban 'ö bhii kö ꞊wa ‑lo 'yi 'kpong 'dhiö, ‑dhɛ 'wo ‑kë 'dho ꞊dhia ‑a ‑bha bhë ‑a ‑bha 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","꞊Dhɛ 'ö ‑dhɛ ꞊ya 'po, mɛ ‑gbaa ‑nu mɛ 'wo to 'yipuë ꞊va bhë ‑a ꞊zlöö ꞊zian' bhë, ‑wa ‑yö ꞊nɛ kë 'wo‑ wo mü bhë, 'yitagɔ do ꞊nɛ 'ö ‑kë mü. 'Ö ꞊dhɛ 'ö Yesu ‑bha ꞊guë' ‑nu 'dho 'dho ‑na, Yesu gia‑ yaa kë ‑an 'piö 'yitagɔ 'gü mü, wo 'sloo ꞊nɛ 'wo dho. ");
INSERT INTO dnj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","'Kɛɛ kë‑ wo 'dhö bhë, 'yitagɔ gbɛ ‑nu ‑wo ‑go Tibeliasë plöö ꞊nɛ 'wo nu 'ö ‑dhɛ 'wo ꞊bluu'‑ ‑bhö ‑a ‑bha kö Yesu ꞊ya yën ‑bhɛa ‑Zlan ‑dhë ‑sü 'ka bhë 'wo ‑gban ‑a 'sɔɔ. ");
INSERT INTO dnj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","'Yö ꞊dhɛ mɛ ‑gbaa ꞊va 'wo bhë waa Yesu yö 'iin ‑a ‑bha ꞊guë' ‑nu yö ‑dhɛ bhë ‑a 'gü, 'wo ‑da 'yitagɔ ‑nu 'wo bhë ‑an 'gü 'ö 'wo dho Kapɛɛnaɔmë ‑a ꞊mɛɛ' ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","꞊Dhɛ ꞊wa 'dho ꞊wa ‑lo 'yipuë ꞊va bhë ‑a ꞊zlöö 'ma ꞊zian', ‑wo ‑kpën Yesu ‑bha 'ma; 'yö 'wo‑ ꞊dhɛɛ' kpɔ 'wo‑ pö: «Yi ‑Gɔmɛ, ü ‑nu 'nö ‑më yië ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","'Ö Yesu ‑ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: ‑Yö 'wun gia‑ 'ka ꞊nɛ ka ‑kë n ꞊mɛɛ' ꞊dhia; 'kɛɛ yaa kë ꞊nɛ ‑dhidhaapë ‑nu 'a‑ ‑kë bhë ‑a ‑wun ‑mü; n ꞊mɛɛ'‑ 'ka‑ wo ‑na bhë 'ö tɔɔ ka ꞊bluu'‑ ‑bhö 'ö ka 'gu ‑yö dɔ ‑së 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kö ꞊kun 'ka yuö ‑kë ‑bhöpë 'ö‑ 'gü dho ꞊siö'‑ bhë ‑a ‑wun 'gü; ‑ka yuö kë ꞊zian' pë mɛ 'ka dhoë‑ ‑bhö, 'ö dho ꞊glɔɔ kö ‑yaan kë ka ‑gɔ ꞊toëpö ‑kë ‑a 'gü ‑sü 'ka ‑a ‑wun 'gü. ‑Bhöpë 'ö bhë mɛ 'ö dhoë‑ nu ka ‑dhë 'ö tɔɔ Mɛgbö; 'ö tɔɔ kwa Dë ‑Zlan ꞊ya ö ‑bha ‑kɔ ‑mɔ 'wuën‑ ‑sü ꞊duakëpë ‑ya ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'Yö 'wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑Më 'yi dho ‑a kë kö 'yiën‑ ‑Zlan ‑bha yuö ‑nu kë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","'Yö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Pë 'ö ‑Zlan ‑bha yuö 'gbloo 'piö, 'ö tɔɔ kö mɛ 'ö‑ bɔ bhë, 'ka‑ ‑wun ‑dhɛ 'wun gia‑.» ");
INSERT INTO dnj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","'Yö 'wo‑ pö ‑a ‑dhë: «Kö ‑bhö ‑dhidhaapë do kë kö 'yiën‑ ü ‑wun ‑dhɛ 'wun gia‑ 'sa! ‑Më ‑yuö 'ü dhoë‑ kë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","'Ö ('wun bhë, 'wo‑ ꞊zuan' sü Moizö ‑bha kë 'ö‑ wo 'kpa wo 'bhɛma ‑nu ‑bha ‑zo ‑yö ‑a ‑bha ‑mɛ 'ka ‑sü, ‑dhidhaapë ‑nu 'ö ‑kë bhë ‑a ‑wun 'gü bhë ‑a ‑bha) 'wo‑ ‑wun ꞊blɛɛ ‑a ‑dhë, 'wo‑ pö: «Yi 'bhɛma ‑nu bhë, kë‑ wo 'kpa, ‑wo 'manë ‑bhö 'yënng ꞊taa. ‑A ‑dee 'wun 'ö ‑gban ‑a ‑bha, ‑yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: ꞊Bluu'‑ 'ö go dhang‑ 'gü ‑Zlan 'piö bhë, ‑Zlan ‑ya ‑nu ‑an ‑dhë 'wo‑ ‑bhö. » ");
INSERT INTO dnj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","'Ö Yesu ‑ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë giagia 'ka ꞊nɛ Moizö 'yaa ‑mü 'ö ꞊bluu'‑ 'ö go dhang‑ 'gü bhë 'ö‑ nu ka ‑dhë, 'kɛɛ n Dë ꞊nɛ 'ö ꞊bluu'‑ gia‑ 'ö go dhang‑ 'gü bhë 'ö ꞊ya kë 'ö‑ nu mɛ ‑dhë; ");
INSERT INTO dnj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","bhii ‑Zlan ‑bha ꞊bluu'‑ 'ö tɔɔ ‑a mɛ 'ö go dhang‑ 'gü 'ö ꞊yɔɔ kö ‑yaan ‑këdhösü nu 'kpongtaamɛ ‑nu ‑dhë bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","꞊Dhɛ ‑kë 'dhö, 'wo‑ pö ‑a ‑dhë: «Yi Dëmɛ, ꞊bluu'‑ bhë ‑a nu yi ‑dhë ‑kplawo 'sa.» ");
INSERT INTO dnj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","'Ö Yesu ‑ya pö ‑an ‑dhë: «Ma ꞊nɛ 'a tɔɔ ꞊bluu'‑ 'ö ‑këdhösü 'dhö n 'gü. Mɛ 'ö ꞊ya nu n 'piö, din 'ka 'dhoë‑ kë 'gbɛɛdhö, 'ö mɛ 'ö ꞊ya 'we n ‑wun ‑bha, 'yi mü ‑dhɔ 'ka 'dhoë‑ kë 'gbɛɛdhö. ");
INSERT INTO dnj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'Kɛɛ a‑ pö ‑na ka ‑dhë 'zü: 'Ka ka 'yan dɔ n ‑ma, 'kɛɛ 'kaa n ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","‑Yö kë 'pö‑ wo ka 'yaan ꞊nɛ mɛ ‑nu 'ö n Dë ‑ya nu n ‑dhë bhë, ‑a mɛ 'kö ‑dhö, ‑yö ‑dhö nu n 'piö; 'ö mɛ 'ö ꞊ya nu n 'piö, 'ö n 'ka 'dho ‑a ‑wun ‑zuö ‑kɔ ꞊taa 'gbɛɛdhö; ");
INSERT INTO dnj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","'ö tɔɔ a ‑go dhang‑ 'gü kö mɛ 'ö n bɔ bhë, 'aan‑ ‑a ‑zo 'kun ‑wun kë; n 'ka nu n ‑de ‑zo 'kun ‑wun kë ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mɛ 'ö n bɔ bhë, pë 'ö‑ ‑zo 'kun ‑wun 'ka 'ö‑ 'piö kö 'a‑ kë bhë 'ö tɔɔ mɛ ‑nu 'ö ‑an ‑wun ‑lo n kwɛɛ bhë, kö ꞊kun 'ö mɛ ‑yö ‑kë ‑an songdhö 'ö ‑kë 'gü ꞊siö' ‑mɛ 'ka, 'kɛɛ kö 'a ‑an 'plɛ bho ga 'gü yi ‑kaanta 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'Ö bhii ‑yö n Dë ‑zo 'kun ‑wun 'ka kö mɛ 'saadhö 'ö ‑an 'yan 'dhö dɔ ‑na ‑a Gbö ‑bha, 'ö 'wo‑ ‑wun ‑dhɛ ‑na 'wun gia‑ bhë, ‑wo ꞊toëpö ‑kë ‑a 'gü ‑sü yö kö 'aan‑ ‑an bho ga 'gü yi ‑kaanta 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","꞊Aa', 'wun bhë yaa dhi Zuifö ‑nu ‑dhë ‑a pö 'ö‑ wo ma ꞊nɛ 'a tɔɔ ꞊bluu'‑ 'a go dhang‑ 'gü bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","'Yö 'wo‑ pö: «Zozɛfu gbö do Yesu ꞊nɛ 'yaa ‑mü ‑a? Kwa‑ dhe ‑dɔ 'ö 'kwa‑ dë dɔ; 'ö ꞊dhɛ ‑kë 'dhö ꞊nɛ ‑dhɛ ‑mlë 'ö dɔ ‑a ‑bha 'ö‑ 'godhɛ ‑yö ‑kë dhang‑ 'gü ‑dhɛ 'ka ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka ka bo n ‑wun ꞊blɛɛ' ‑sü 'ka ka 'ko ‑nu ‑dhë ‑sü ‑wo ꞊löö; ");
INSERT INTO dnj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","mɛ yaa ‑mɔa ‑bha kö ‑yaan nu n 'piö ‑a 'ke n Dë 'ö n bɔ bhë, yaa‑ mɛ ‑dhɛ, kö ma 'pö, yi 'dhiötoyi 'ka, 'aan‑ bho ga 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","'Ö bhii pë 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑gɔ 'sëëdhɛ 'gü ‑ya ‑pö: 'Wun ‑nu 'wo ‑gban ‑Zlan ‑bha, ‑Zlan ‑yö ‑dho ‑an 'plɛ ꞊daan' ‑a 'ka. ꞊Ya kë 'dhö kö mɛ 'oo mɛ 'ö ꞊ya ö 'to kë n Dë ‑wo ‑bha 'ö ꞊ya ö ‑kɔ kpɔ ‑a ‑gɔ, ‑yö nu n 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kë‑ wo bhë yaa kë ꞊nɛ kö mɛ 'wo bhë, Dë yö 'wo‑ wo bhë yö ‑mü. ‑A ‑de mɛ do 'kpaan 'ö go ‑Zlan 'piö bhë, yö do bhë ꞊nɛ 'ö‑ yö. ");
INSERT INTO dnj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛ mɛ 'ö ꞊ya 'we n ‑wun ‑bha, kö ꞊ya ꞊toëpö ‑këdhösü yö. ");
INSERT INTO dnj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'Ö tɔɔ ma ꞊nɛ 'a tɔɔ ꞊bluu'‑ 'ö ‑këdhösü 'dhö n 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ka 'bhɛma ‑nu bhë, kë‑ wo 'kpa bhë, 'manë 'ö ‑kë 'yënng ꞊taa bhë, ‑wa ‑bhö 'kɛɛ ‑wo ‑ga. ");
INSERT INTO dnj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","꞊Ya kë 'dhö, kö ꞊bluu'‑ mɛ 'ö go (‑Zlan 'piö) dhang‑ 'gü bhë ‑yö ka ‑bha 'ka; kö mɛ 'ö ꞊yaa‑ ‑bhö, yö 'ka 'dho ga. ");
INSERT INTO dnj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ka‑ ‑yö bhë ꞊a! Ma ꞊nɛ 'a tɔɔ ꞊bluu'‑ 'a ‑këdhösü nu mɛ ‑nu ‑dhë, 'ö 'a go dhang‑ 'gü. ꞊Bluu'‑ 'a‑ 'ka bhë, mɛ 'ö ꞊ya n 'sü ö ‑bha 'ka, ‑këdhösü ‑yö ‑dho kë ‑a ‑gɔ ꞊toëpö 'ka. 'Ö ꞊bluu'‑ 'a dho ‑a nu bhë 'ö tɔɔ n ‑de nu 'a 'dhoë‑ wo kö 'kpongtaamɛ ‑nu ‑waan ‑këdhösü yö ‑a ‑ta bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","꞊Dhɛ 'ö Yesu ‑yö 'wun ꞊blɛɛ 'dhö, Zuifö ‑nu ‑wo ‑yö vundhe ma ‑sü 'gü wo 'ko ‑nu songdhö ‑a pö ‑sü 'ka: «'Yö, ‑më ‑kë 'ö mɛ ꞊nɛ 'ö 'wun ꞊blɛɛ ꞊nëdhö ꞊nɛɛ? ‑Më tɔɔ ‑yö ‑dho ö bun nu kwa ‑dhë ‑bhöpë 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","'Yö Yesu ꞊ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka, ꞊ya kë ꞊nɛ Mɛgbö bun 'ö nu ka ‑dhë ‑bhöpë 'ka bhë kaa ka ‑kɔ 'kpɔ ‑a ‑gɔ 'iin ‑a fɛi 'ö dhoë‑ nu bhë kaa‑ 'kun, kö ‑këdhösü bhë ꞊ya dha ka ‑gɔ ꞊nɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","'Ö tɔɔ mɛ 'ö ꞊ya ö ‑kɔ kpɔ n bun ‑gɔ 'ö ꞊ya n fɛi kun ‑yaan kë ö müpë 'ka, kö ‑këdhösü 'ö ‑dhö ꞊toëpö 'ka bhë, ꞊yaa‑ yö; 'ö kö mɛ bhë a ‑dho ‑a ‑bho ga 'gü yi ‑kaanta 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bhii n bun bhë ꞊nɛ 'ö tɔɔ ‑bhöpë giagia, 'ö n fɛi 'dhö müpë giagia 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","꞊Ya kë 'dhö kö mɛ 'ö ꞊ya ö ‑kɔ 'kpɔ n bun ‑gɔ ‑bhöpë 'ka 'ö ꞊ya n fɛi 'kun müpë 'ka kö ‑yö ‑klu ‑sü 'ka n ‑ma, 'ö ma ‑de 'pö, 'a ‑klu ‑sü 'ka ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kö ‑kɔ do 'ö n Dë 'ö 'bhee‑ 'ö n bɔ ‑a 'ka 'ö 'a‑ 'ka 'bhee‑ ‑a 'sɛa‑ 'gü bhë ꞊nɛ 'ö mɛ 'ö ꞊ya ö ‑kɔ kpɔa n bun ‑gɔ ‑bhöpë 'ka 'ö‑ 'ka 'bhee‑ n sɛa‑ 'gü 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","꞊Bluu'‑ 'ö go dhang‑ 'gü 'ö nu ka ‑ta bhë, ꞊ya ‑lo. 'Yaa ꞊nɛ ‑a mɛ 'ö ka 'bhɛma ‑nu ‑wa ‑bhö 'kpa bhë ‑a 'dhö, 'ö bhii ꞊dhɛ ‑kë 'dhö ‑wo ‑ga. ꞊Bluu'‑ 'ö ꞊nɛ bhë, mɛ 'ö ꞊ya ö ‑kɔ 'kpɔ ‑a ‑gɔ ‑bhöpë 'ka, ‑yö ‑dho ‑këdhösü yö ꞊toëpö 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","'Wun ‑nu 'wo ꞊nɛ Yesu ‑yö ‑bɔ ‑a 'gü 'dhö kö ‑yö mɛ ‑nu ꞊daan' ‑na Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü Kapɛɛnaɔmë. ");
INSERT INTO dnj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","꞊Dhɛ 'ö Yesu ꞊ya 'wun ꞊blɛɛ'‑ ꞊nɛ ‑kɔ bhë ‑a 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu mɛdhɛvadhɛ ‑wo yö ‑a pö ‑sü 'gü ꞊nɛɛ: «'Wun mɛ bhë ‑a ma ‑sü ‑dho kë 'gbee‑; dö dho ö 'to kë ‑a ‑bha ‑ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kë‑ wo bhë, pë 'ö‑ ‑bha ꞊guë' ‑nu ‑wo ‑kë ‑a pö ꞊dhia wo 'ko ‑nu ‑dhë bhë, ‑ya ‑ma. ꞊Dhɛ ‑kë 'dhö 'yö‑ pö ‑an ‑dhë: «'Wun bhë ꞊ya ka dɔ ‑gbɔudhö ꞊nɛ ‑kɔ bhë ‑a 'dhö, ");
INSERT INTO dnj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","yi 'ö ma 'a Mɛgbö 'ka 'a dho ‑da ‑a 'ka dhang‑ 'gü, ‑dhɛ 'a ‑kë ‑a ‑bha ‑be bhë ‑a ‑bha, ka ‑dho kë mü ꞊dhë 'ö 'ka dɔ 'dhö ꞊nɛɛ? ");
INSERT INTO dnj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","'Ö tɔɔ ‑Zuu 'slööslö ꞊nɛ 'ö ‑këdhösü nu mɛ ‑dhë; bun 'ö 'ka‑ ‑ga ‑na ꞊nɛ, ‑a ‑yö ‑a ‑bha ‑pë gbɛ 'yaa 'dhö. ꞊Ya kë 'dhö kö 'wun ꞊blɛɛ' ‑wo ‑nu 'ka‑ ma bhë ꞊nɛ 'wo ‑këdhösü 'ö go ‑Zlan 'piö bhë 'wo‑ nu mɛ ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","'ö mɛ 'bhaa ‑nu 'wo ka songdhö 'ö 'waa‑ ‑dhɛ 'wun gia‑ bhë.» ‑A pö 'ö Yesu ‑ya wo 'dhö bhë 'ö tɔɔ 'go ‑a züdɔyi ‑bha, mɛ ‑nu 'ö 'waa‑ ‑wo ‑nu ‑dhɛ 'wun gia‑ 'iin mɛ 'ö dho ö dɔ ö yaagümɛ ‑nu kwɛɛ bhë ‑yö ‑an dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö 'zü: «Pë 'ö ‑kë 'a‑ pö mɛ gbɛ yaa 'dhö ‑mɔa ‑yö nu n 'piö kö ‑Zlan yaa‑ ‑kɔ ‑mɔ 'wuën‑ ‑sü nu ‑a ‑dhë bhë 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","꞊Aa', ꞊dhɛ ‑kë 'dhö zlöö, 'ö sü 'töng bhë ‑a ‑bha, ‑a ‑bha ꞊guë' ‑nu 'wo bhë, ‑an ꞊plëëzë ‑wo ‑kan ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","‑Dhɛ ‑kë 'dhö, 'ö Yesu ‑ya pö ö ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑an ‑dhë: «Ka‑ 'piö 'ka 'dho 'pö a?» ");
INSERT INTO dnj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","'Yö Simɔ Piɛɛ ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «N Dëmɛ, dö 'kpaan 'yi dho dho ‑a 'piö ee? Bhi ꞊nɛ 'ö ‑wo 'ö ꞊wa bɔ ‑a ‑ta 'wo ꞊toëpö ‑këdhösü yö bhë 'ö ü ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yi ü ‑wo ‑nu ‑dhɛ 'wun gia‑ 'ö 'yi‑ dɔa ꞊nɛ bhi ꞊nɛ 'ü tɔɔ mɛ 'ö ‑Zlan ‑ya sü ö ‑bha 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","'Yö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Kë‑ wo bhë, mɛ 'gɔɔ‑ do ö ga ꞊plɛ 'ka bhë, ma kun 'a ka ꞊dhɔɔ ‑kë n 'piö a? 'Kɛɛ mɛ do ‑yö ka ziën 'ö dü ‑bha mɛ 'ka 'sa!» ");
INSERT INTO dnj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mɛ 'ö 'wun ‑gban ‑a ‑bha 'ö‑ ꞊blɛɛ bhë 'ö tɔɔ Zuda, Simɔ Ikaliɔtö gbö. Zuda 'ö bhë, ‑yö ‑kë Yesu ‑bha ꞊guë' ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë ‑a mɛ do 'ka 'dhö; 'kɛɛ yö ꞊nɛ 'ö ꞊dhɛ 'wo yö mü zlöö 'ö Yesu 'dhɔɔ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑nië Galile ‑sɛ 'gü; yaa‑ ‑dhɔ kë gbɔ kö ‑yaan 'dho Zude ‑sɛ 'gü 'ö tɔɔ Zuifö ‑nu ‑gɔmɛ ‑nu ‑wo ‑kë ‑a ꞊mɛɛ' ꞊dhia kö ‑waan ‑a zë. ");
INSERT INTO dnj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","꞊Dhɛ 'ö ‑kë ꞊nɛ Zuifö ‑nu ‑bha 'wlaan‑ ‑yi 'ö ‑kë sɔ 'kɔ ‑nu 'wlaan‑ ‑yi 'ka bhë, ꞊ya yö ꞊klöö', ");
INSERT INTO dnj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","'Ö Yesu dheglu 'në gɔɔn‑ ‑nu ‑wa pö ‑a ‑dhë: «‑Bhö 'dho Zude kö ü ‑bha ꞊guë' ‑nu (mɛ 'wo to 'ma) ‑waan ü këyuö ‑nu yö 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","'Ö tɔɔ mɛ 'ö‑ 'piö kö mɛ ‑nu ‑wa dɔ, 'yaa ö këyuö ‑nu ‑bin. ꞊Dhɛ ü këyuö ‑nu ꞊wa kë ꞊nëdhö bhë, kö ‑bhöë kë kö ‑an 'yan ‑yö dɔ ü ‑bha 'sa!» ");
INSERT INTO dnj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kë ‑de 'ö‑ wo bhë, ‑a dheglu ‑nu 'wo bhë, ‑a ‑wo ‑nu ‑dhɛ 'wun gia‑ ‑sü yaa kë ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","'Ö Yesu ‑ya pö ‑an ‑dhë: «Ka ‑zë 'töng 'saadhö ‑yö ka ‑bha 'töng ‑së 'ka, 'kɛɛ ma ‑zë n ‑ma yaa ‑lo ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'Ö bhii 'kpongtaamɛ ‑nu 'ka 'dho ka ‑san zë; 'kɛɛ ma ‑zë ‑wo n ‑san ‑zë, 'ö tɔɔ ma ꞊nɛ ꞊ya kë 'a‑ pö ‑an ‑dhë ꞊nɛ ‑an këpë ‑nu ‑wo ya. ");
INSERT INTO dnj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ka ‑zë, ‑ka 'dho 'wlaan‑ bhë ‑a ‑ta. N 'kaa dho 'ma, 'ö tɔɔ n ‑ma 'töng ‑së yaa ‑lo ꞊kun.» ");
INSERT INTO dnj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","꞊Dhɛ 'ö ꞊yaa‑ pö ‑an ‑dhë 'dhö, (yaa kpa ‑an ‑bha waa 'dho wo 'kuë 'wlaan‑ bhë ‑a ‑ta Zude,) ‑yö ‑to Galile. ");
INSERT INTO dnj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","꞊Dhɛ 'ö‑ dheglu 'në gɔɔn‑ ‑nu ꞊wa 'dho 'wlaan‑ bhë ‑a ‑ta, 'ö‑ ꞊zuö' ‑yö ꞊luu kö ‑yaan 'dho; 'ö yö ‑de 'pö, 'yö dho 'wlaan‑ bhë ‑a ‑ta; 'kɛɛ yaa ö ‑de ‑zɔn kö mɛ ‑nu ‑waan yö. ");
INSERT INTO dnj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Zuifö ‑nu ‑gɔmɛ ‑nu ‑wo ‑kë ‑a ꞊mɛɛ' ꞊dhia 'wlaan‑ bhë ‑a ‑ta ‑a pö ‑sü 'ka ꞊nɛɛ: «‑Yö 'më?» ");
INSERT INTO dnj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mɛ ‑nu ‑wo ‑kë ‑a ‑wun ꞊blɛɛ' ꞊dhia ‑wo ꞊löö ꞊va 'ka mɛ gbung 'gü mü ꞊nɛɛ: «Mɛ bhë 'wunsëkëmɛ ‑mü», kö mɛ 'bhaa ‑nu ‑wa pö ‑na: «‑Abi'!» kö mɛ 'bhaa ‑nu ‑wa pö ‑na: «Mɛ ‑nu ‑püö ‑mɛ ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","'Kɛɛ mɛ gbɛ yaa kë ‑dhö kö ‑zogbansü ‑yaan kë ‑a ‑gɔ kö ‑yaan ‑wun ꞊blɛɛ'‑, 'ö bhii 'suö ‑yö ‑an ‑kë Zuifö ‑nu ‑gɔmɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","꞊Dhɛ 'ö 'wlaan‑ bhë ꞊wa dɔ ‑a yi ziën, 'ö Yesu ‑yö dho ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'ö yö mɛ ‑nu ꞊daan' ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Zuifö ‑nu ‑gɔmɛ ‑nu ꞊zuö' 'bhaa ‑yö ‑bho, 'ö 'wo yö ‑a pö ‑sü 'gü wo 'ko ‑nu ‑dhë: «Mɛ 'ö yaa pë gbɛ ꞊daan' ꞊nɛ 'wun ꞊suu'‑ ‑nu 'wo ꞊nɛ ‑ya ‑dɔ ‑kɔklë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Mɛ ꞊daan' ‑wo ‑nu 'wo 'go ‑na n 'dhii bhë, waa 'go n 'gü 'kɛɛ ‑wo ‑go ‑Zlan 'ö n bɔ bhë ‑a kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mɛ 'ö ꞊ya ö ꞊zuö' 'dhi 'po kö ‑yaan ‑Zlan ‑zo 'kun ‑wun kë, ‑yö ‑dho ‑a 'wun dɔ kö ma mɛ ꞊daan' ‑wo ‑nu ‑wo ‑go ‑Zlan 'piö 'iin a‑ ‑sü n ꞊deë' 'a mɛ ꞊daan. ");
INSERT INTO dnj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mɛ 'ö ꞊luu' ‑na ö ꞊deë' 'ö mɛ ‑nu ꞊daan' ‑na bhë, 'tɔbhɔdhe ꞊nɛ 'ö‑ ꞊mɛɛ ö ‑de ‑bha 'ka; 'kɛɛ mɛ 'ö yuö kë ‑na mɛ 'ö‑ bɔ bhë ‑a 'tɔ ‑wun 'gü, 'wun gia‑ ꞊nɛ 'ö‑ ꞊blɛɛ, 'ö ꞊sua ‑wun 'yaa‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","‑Yö 'wun gia‑ 'ka ꞊nɛ Moizö ‑yö (‑Zlan ‑bha) tɔng ‑nu ‑nu ka ‑dhë. 'Kɛɛ ꞊dhɛ ‑kë 'dhö ꞊nɛ dö 'ö‑ kun ö 'kun ‑kɔ 'ka ɛɛ? ꞊Ya kë 'dhö ka‑ 'piö 'ka n zë ‑më ‑wun 'gü ii?» ");
INSERT INTO dnj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","꞊Dhɛ ‑kë 'dhö 'ö mɛ gbung ‑nu 'wo bhë 'wo‑ pö ‑a ‑dhë: «‑Zuu yaa ‑yö ü 'gü! 'Yaa 'dhö dö 'ö‑ 'piö 'ö ü zë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Pë do 'kpaan 'a‑ ‑kë ꞊glooyi 'ka bhë yö kun 'ö ꞊ya ka dɔ ‑gbɔudhö bhë ꞊a! ");
INSERT INTO dnj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kë‑ wo bhë Moizö yaa‑ pö ka ‑dhë 'ka gɔɔn‑ ‑nu zë 'bɔng a? ('Kɛɛ kö 'wun bhë ꞊dhɛ 'ö ‑da ‑na kö yaa bhɔ ‑dewo ꞊kun); 'ö 'ka ‑we ‑a ‑bha 'ö ꞊glooyi 'ka, 'ka mɛ ‑nu zë 'bɔng. ");
INSERT INTO dnj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ka 'ö ka 'we ‑a ‑bha kö 'ka mɛ ‑nu zë 'bɔng ꞊glooyi 'ka ꞊nɛ ‑kɔ 'ö 'ka Moizö ‑bha tɔng ‑nu 'gü ‑a 'dhö, kö ꞊kun 'ö 'ka dho kë tɔng ‑lö 'gü ‑mɛ ‑nu 'ka bhë, ‑më ‑kë 'ö 'ka ka wö ‑siö n ‑ma mɛ ‑dhɛ bo 'a‑ wo ꞊glooyi 'ka, ‑a mɛbheedhɛ 'gü 'iin ‑a nii 'gü bhë ‑a ‑wun 'gü 'sa? ");
INSERT INTO dnj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kö ꞊kun 'ka za dɔ mɛ ‑bha mɛ buënpë ‑wun 'gü, 'kɛɛ 'ka za ‑nu dɔ, ‑wo kë kpengdhö.» ");
INSERT INTO dnj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Zeluzalɛmë plöömɛ 'bhaa ‑nu ‑wo ‑kë ‑a pö ꞊dhia: «Gɔɔn‑ 'wo‑ ꞊mɛɛ' ‑na ‑waan zë ꞊nɛ kun ꞊nɛ ꞊a? ");
INSERT INTO dnj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yö ꞊ga 'ö mɛ ‑nu ꞊daan' ‑na mɛ gbung 'gü 'ö mɛ gbɛ 'yaa 'dhö kö ‑yö ꞊yɔɔn ‑a ‑bha ꞊nɛ! Kë‑ wo bhë, kwa ‑gɔmɛ ‑nu 'wo ꞊nɛ ‑a dɔ 'pö 'wo‑ wo ꞊nɛ yö 'ö tɔɔ ‑Zlan ‑bha ‑Yamɛ 'pö bhë ee? ");
INSERT INTO dnj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","‑Zlan ‑bha ‑Yamɛ 'ö bhë ꞊ya nu, mɛ gbɛ 'ka 'dho ‑a 'godhɛ dɔ, 'kɛɛ kö mɛ 'ö ꞊nɛ kwa‑ 'godhɛ ‑dɔ 'sa!» ");
INSERT INTO dnj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu ‑yö ‑kë mɛ ‑nu ꞊daan' ꞊dhia ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü. ꞊Dhɛ ꞊ya kë 'dhö, 'yö ‑gbla ꞊woë' ꞊nɛɛ: «‑Yö 'dhö 'wun gia‑ 'ka, ka n ‑dɔ, 'ö 'ka n 'godhɛ dɔ. 'Kɛɛ kë‑ wo 'dhö bhë n 'ka nu n ꞊deë'. Mɛ bhë ‑yö ‑dhö giagia 'ka; ‑zo ‑tën ‑a ‑dhë ‑mɛ ‑mü. Yaa kë ꞊nɛ a ‑nu n ꞊deë'. Mɛ 'ö bhë 'kaa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ma 'pö, 'a‑ dɔ 'ö tɔɔ a ‑go ‑a 'piö, 'ö yö ꞊nɛ 'ö n bɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","꞊Dhɛ ꞊ya kë 'dhö, 'wo‑ këdhɛ ꞊mɛɛ kö ‑waan ‑a 'kun; 'kɛɛ mɛ gbɛ yaa‑ 'kundhɛ yö, 'ö tɔɔ kö ‑a 'kun 'töng 'ö ‑Zlan ‑ya ‑ya ö ‑bha 'wun ‑nu ‑yö 'ko 'dhiö ‑kɔ 'ka bhë yaa ‑lo ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","'Kɛɛ kë‑ wo 'dhö bhë mɛ gbung 'gü mü, mɛ ‑nu ‑wo ‑kë ꞊va 'ö 'wo‑ ‑wun ‑dhɛ 'wun gia‑. ‑Wo ‑kë ‑a pö ꞊dhia: «‑Zlan ‑bha ‑Yamɛ 'ka‑ ‑wun ꞊blɛɛ' ‑na bhë, ꞊ya kë ꞊nɛ ꞊ya nu, ‑yö ‑dho ‑dhidhaapë ‑nu kë 'ö ‑ziö ‑a 'ka gɔɔn‑ ꞊nɛ ‑a ‑bha ‑ta ‑a?» ");
INSERT INTO dnj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","꞊Dhɛ 'ö ‑wo ‑nu 'ö mɛ ‑nu 'wo Yesu ‑wun ‑dhɛ 'wun gia‑ mɛ gbung 'gü mü, 'wo ‑kë ꞊blɛɛ' ꞊dhia ‑wo ꞊löö bhë 'ö ꞊ya ‑da Falizi ‑mɛ ‑nu 'toudhö, 'wo kpa slabhomɛ ‑nu ‑gɔmɛ ‑nu ‑bha, 'wo 'dhasi ‑nu bɔ ‑dhɛ bhë ‑a ‑bha kö ‑waan Yesu 'kun. ");
INSERT INTO dnj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","'Yö Yesu ‑ya pö: «A ꞊tun ka 'piö 'töng 'dɛdɛ 'ka; ꞊ya 'go mü kö n 'dho ‑sü ‑mü mɛ 'ö n bɔ bhë ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ka ‑dho n ꞊mɛɛ', 'kɛɛ ka 'ka 'dho n yö, bhii ka 'ka 'dho ‑mɔa 'kaan‑ 'dho ‑dhɛ 'a dho kë ‑a ‑bha bhë ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","'Yö Zuifö ‑nu ‑gɔmɛ ‑nu ‑wo yö wo 'ko ‑nu ꞊dhɛɛ' 'kpɔ ‑sü ‑bha ꞊woë' ꞊nɛɛ: «‑Dhɛ ‑mlë 'ö dho dho ‑a ‑bha kö 'kwaan‑ 'kun ‑a yö ‑sü 'ka 'ö‑ ‑wun ꞊blɛɛ' ‑na ꞊nɛ ‑oo? Kö 'dho 'pö dhoë‑ wo Zuifö ‑nu 'wo ‑pɛn ‑sü 'ka Glɛkö ‑sɛ 'gü ‑dhɛ ‑nu ‑bha bhë ‑an 'piö kö ‑yaan Glɛkö ‑nu ꞊daan' bhë ee? ");
INSERT INTO dnj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‑A pö ‑de 'ö‑ wo ‹ka ‑dho n ꞊mɛɛ' 'kɛɛ ka 'ka 'dho n yö 'ö tɔɔ ka 'ka 'dho ‑mɔa ‑bha kö ‑dhɛ 'a dho kë ‑a ‑bha, 'kaan‑ 'dho ‑a ‑bha› bhë, ‑a ‑gɛn tɔɔ ‑më poo ꞊ee?» ");
INSERT INTO dnj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Sɔ 'kɔ ‑nu 'wlaan‑ ‑yi ‑kaanta 'ö‑ ‑wun 'dhö 'gbee‑ bhë, ꞊dhɛ 'ö ꞊ya ‑lo, ‑a yi bhë ‑a 'ka, Yesu ‑yö ‑dɔ mɛ gbung 'dhiö 'ö‑ pö ‑wo 'gbee‑ 'ka ꞊nɛɛ: «Mɛ 'ö 'yi mü ‑dhɔ 'dhoë‑ kë ‑na, ‑yö nu n 'piö, ‑yö 'yi mü. ");
INSERT INTO dnj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bhii ‑yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: Mɛ 'ö ꞊ya n ‑wun ‑dhɛ 'wun gia‑, ‑kë ‑a 'gü 'yigɔ ‑nu ‑dho go ‑a ꞊zuö' 'gü 'wo ‑ziö.» ");
INSERT INTO dnj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","'Wun 'ö Yesu ‑ya ꞊blɛɛ 'dhö bhë ‑yö ‑gban ‑Zuu 'slööslö 'ö mɛ ‑nu 'wo‑ ‑wun ‑dhɛ 'wun gia‑, 'wo dho ‑a yö bhë ‑a ‑bha; 'ö tɔɔ pë ‑nu bhë, ꞊dhɛ 'wo kë ‑na 'dhö, kö ‑Zuu 'slööslö yaa nu ꞊kun mɛ 'bhee‑ ‑nu ‑dhë, 'ö bhii kö Yesu yaa ‑da ꞊kun 'tɔbhɔdhe 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","꞊Dhɛ mɛ ‑nu 'wo ‑kë mɛ gbung 'gü mü, 'ö ‑wo ‑nu 'wo bhë ꞊waa‑ ma, ‑wo ‑yö ‑a pö ‑sü 'gü: «Mɛ 'ö ꞊nɛ, 'wun gia‑ 'ka, ‑Zlan ‑wodhiölomɛ 'ö kwa 'yan 'dhoë‑ ‑gɔ bhë yö ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kö ‑an mɛ 'bhaa ‑nu ‑wa pö ‑na: «‑Zlan ‑bha ‑Yamɛ ‑mü!» Kö‑ mɛ 'bhaa ‑nu ('ö‑ ‑de, ‑a ‑bha ‑bhɔ Betelɛmë, Zude ‑sɛ 'gü ‑sü bhë 'ö 'waa‑ dɔ bhë), kö ‑wo bɔ ‑na ‑dhɛ do bhë ‑a 'gü ‑wa pö ‑na: «'Öö‑ 'öö, ‑Zlan ‑bha ‑Yamɛ bhë, mɛ dho go Galile yö ‑mü ‑a? ");
INSERT INTO dnj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","(Këpë 'yaa ‑mü,) 'ö tɔɔ pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ‑ya ‑pö: ‑Zlan ‑bha ‑Yamɛ bhë ‑yö ‑go Davidö ꞊suu'‑ 'gü, 'ö dho bhɔ Betelɛmë ‑pö 'ö Davidö (‑de gia‑) ‑yö ‑kë ‑a 'gü bhë ‑a 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","꞊Dhɛ ꞊ya kë 'dhö, ‑an ‑wo yaa 'dho ‑dhɛ do 'gü gbɔ 'wun ‑nu 'wo bhë ‑an ‑wun 'gü; 'yö 'gügludhe ‑yö ‑da ‑an ziën. ");
INSERT INTO dnj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mɛ 'bhaa ‑nu ‑wa ‑kë kö ‑waan ‑a 'kun 'kɛɛ waa‑ 'kundhɛ yö. ");
INSERT INTO dnj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","꞊Dhɛ 'wun ‑nu bhë ꞊wa kë 'dhö, 'dhasi ‑nu ‑wo ‑yɛ wo 'zü 'wo dho slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu 'piö; 'yö 'wo ‑an ꞊dhɛɛ' kpɔ 'pö ꞊nɛɛ: «‑Më ‑kë kaa‑ 'kun kaa nuë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","'Yö 'dhasi ‑nu ‑wa pö: «'Wun ꞊blɛɛ' ‑kɔ ꞊suu'‑ 'ö gɔɔn‑ bhë 'ö‑ wo bhë, ‑a ‑mɛ yaa kë ‑dhö do!» ");
INSERT INTO dnj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","'Yö Falizi ‑mɛ ‑nu ‑wa pö ‑an ‑dhë: «‑Më ‑nu 'ka dɔa ꞊nɛ; ‑a 'wun ꞊blɛɛ' ‑wo ‑nu ꞊wa ka ‑püö 'pö a? ");
INSERT INTO dnj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kwa ꞊kɔɔnmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu bhë, ‑a ‑ga 'ka‑ wo bhë, ‑a dö ‑zë 'pö 'ö 'wun ‑nu bhë 'ka‑ yö ꞊nɛ ꞊ya ‑an ‑dhɛ 'wun gia‑? ");
INSERT INTO dnj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'Yö ꞊dhɛ ‑kë 'dhö ꞊nɛ mɛ ‑nu 'wo bhë ‑wo ‑dɔ ꞊dhë 'ö 'wo wo ꞊kwaa wo ‑de ‑zü ‑ii? 'Waa pë gbɛ dɔ ‑Zlan ‑bha tɔng ‑bha ꞊dhɛɛ! ‑Zlan ‑bha 'dhangga ꞊ya ‑an 'kun.» ");
INSERT INTO dnj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Falizi ‑mɛ do ‑yö ‑kë mü 'pö, 'wo‑ ‑dhɛ Nikodɛmö. Kë‑ wo bhë, yö ꞊nɛ 'ö yi do 'ka 'ö dho Yesu 'piö 'dhiö ꞊zian'. ꞊Dhɛ 'wun ‑nu bhë ꞊wa kë 'dhö, 'ö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Kë‑ wo kwa ‑gɔ tɔng 'gü bhë, kwa ‑mɔa kö 'kwa za ‑lo mɛ tuö kö kwaa‑ ‑wo ‑nu ma 'iin kö pë ‑nu 'ö‑ kë ‑na kwaa‑ dɔ ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","'Yö 'wo‑ ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «‑Më 'ü dɔa ꞊nɛɛ! Galile ‑mɛ ꞊suu'‑ 'wo bhë ü ‑an 'piö 'pö a? ꞊Kpɔɔ'‑ ‑Zlan ‑bha 'sëëdhɛ ‑nu 'gü 'dhɛ! ‑Zlan ‑wodhiölomɛ ꞊ya 'go Galile do 'bha‑ ma ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","꞊Dhɛ ꞊ya kë 'dhö, 'wo ‑kan wo 'kuë‑ 'ö mɛ 'ö ‑dhö, 'ö dho ö ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑dho Olivie ‑tɔn tuö. ");
INSERT INTO dnj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya 'po, ‑a ‑dhiadhiö tii 'gü, ‑yö ‑dho ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'ö mɛ gbung ‑nu ‑wo ꞊nië ‑a ‑zü (‑waan wo 'to to ‑a ‑bha). 'Yö ꞊yaannu, 'ö yö ‑an ꞊daan' ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","'Yö tɔnggɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu 'wo nu dhebɔ do 'wo‑ kun gɔɔn‑ 'piö ‑a 'ka ‑a 'dhiö mɛ gbung 'gü mü. ");
INSERT INTO dnj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","'Ö 'wo‑ pö Yesu ‑dhë: «Yi ‑Gɔmɛ, dhebɔ 'ö ꞊nɛ yi‑ ‑kun gɔɔn‑ 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","'Yö pë 'ö ꞊bɛɛn' ‑sü 'ka Moizö ‑bha tɔng 'sëëdhɛ 'gü ‑ya ‑pö 'yi‑ ‑zuö ‑guö 'ka ‑yö 'to ‑a ꞊kwaa'. ‑Dhɛ 'ü‑ ‑ga ‑a 'gü bhë, 'yi‑ kë ꞊dhë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","꞊Dhɛɛ' bhë ‑wa ‑kpɔ ‑a ‑gɔ 'dhö 'kpënng‑ 'ka, kö ‑waan ‑a 'kundhɛ yö 'wun dɔ ‑a ‑bha ‑sü 'ka. 'Yö Yesu ‑yö ö ‑gɔ yö 'sɛi, 'ö yö pë ‑ya ‑sü ‑bha 'sia‑ ö ‑kɔnëga 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","'Wo ꞊dhɛɛ' kpɔ ‑a ‑gɔ ꞊naazë 'ka. ꞊Dhɛ ꞊ya kë 'dhö, 'ö ö ‑gɔ ꞊luu 'ö‑ pö ‑an ‑dhë: «Mɛ ‑nu 'ka nu 'saadhö ꞊nɛ, mɛ 'ö yaa ꞊sɔɔn yaa kë do, ‑yö ‑guö 'sü, dhebɔ ꞊nɛ ‑ya ‑zuö dɔ ‑a 'ka ‑sü zü dɔ 'kwee‑!» ");
INSERT INTO dnj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","꞊Dhɛ ꞊yaa‑ pö 'dhö, 'yö ö ‑gɔ ‑gban 'sɛi 'zü, 'ö yö pë ‑ya ‑sü ‑bha 'zü. ");
INSERT INTO dnj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","꞊Dhɛ mɛ ‑nu 'wo nu dhebɔ bhë ‑a 'ka, ꞊wa ‑wo ‑nu bhë ‑an ma 'dhö, 'yö 'wo ‑kan wo 'kuë‑ do do 'ka. ꞊Dhɛ 'ö mɛ ziizii ‑nu ꞊wa ziö 'dhiö, 'ö ‑dadhëü ‑nu ‑wo ‑ziö 'pö; 'ö Yesu waa‑ dhebɔ bhë, 'wo ‑an to 'sloo 'ka, kö yö ꞊tun dɔ ‑sü 'ka ‑a 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","'Yö ö ‑gɔ ꞊luu 'ö‑ pö dhebɔ bhë ‑a ‑dhë: «Dhebɔ, mɛ ‑nu 'wo bhë ꞊wa 'dho 'më 'töüdhö ꞊ee? Waa za ‑lo ü ‑bha gbɔ ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","'Ö dhebɔ bhë 'ö‑ pö ‑a ‑dhë: «N ‑Gɔmɛ, waa za ‑lo n tuö gbɔ.» 'Ö Yesu ‑ya pö ‑a ‑dhë: «Ma ‑de 'pö, n 'ka 'dho za ‑lo ü tuö 'pö; ‑bhö ü ‑bha 'dho wo; 'kɛɛ kö ꞊kun 'ü ꞊sɔɔn yaa ‑kë gbɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ö ‑bha ‑dho 'dhiö mɛ gbung ‑nu 'wo ꞊sia bhë ‑an ꞊daan' ‑sü 'ka, 'ö‑ pö: «Ma ꞊nɛ 'a tɔɔ 'kpongtaamɛ ‑nu ‑bha ‑dhɛpuudhɛ; mɛ 'ö ꞊ya ziö n 'piö, ‑dhɛpuudhɛ 'ö ‑kë ‑a 'gü ‑sü 'ka bhë, ‑yö ‑dho 'ta sü ‑a 'gü; yaa 'dho ta ‑dhɛtiidhɛ 'gü 'gbɛɛdhö.» ");
INSERT INTO dnj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","'Ö Falizi ‑mɛ ‑nu ‑wa pö ‑a ‑dhë: «Pë ‑nu 'ü‑ ꞊blɛɛ' ‑na bhë, ‑an ꞊bhlë gbɛ 'yaa 'dhö 'ö tɔɔ ü ‑de ‑gɔ ‑wun ꞊nɛ 'ü‑ ꞊blɛɛ' ‑na bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","'Ö Yesu ‑ya pö ‑an ‑dhë: «'Kö ‑kë ꞊nɛ ‑tɔmɔdhɛ 'a‑ kë ‑na bhë, ‑a ‑wun ‑yö ‑gban n ‑de ‑bha, ‑yö 'wun gia‑ 'ka, 'ö tɔɔ ‑dhɛ 'a go ‑a ‑bha, a‑ ‑dɔ n ‑de ‑gɔ, 'ö 'a n 'dhodhɛ dɔ; 'kɛɛ kö ka ‑zë, n 'godhɛ ‑nu, n 'dhodhɛ ‑nu 'kaa‑ gbɛ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ka ‑bha 'wun ‑yö 'ko 'dhiö ‑kɔ ‑nu ꞊ga 'wo ‑kë mɛ 'bhee‑ ‑bha 'ka bhë! ꞊Ao', ma 'pö 'maa za ‑lo mɛ gbɛ tuö. ");
INSERT INTO dnj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","'Kɛɛ ꞊ya kë ꞊nɛ 'ma‑ pö 'a za ‑lo mɛ tuö, kö ma za bhë ‑yö ö ‑wɔdhɛ ‑kun, 'ö tɔɔ za bhë 'maa‑ ‑lo mɛ tuö ‑mɛ 'ka 'dhö do. Yië‑ n Dë 'ö n bɔ bhë ꞊nɛ ꞊ya kë 'ö za bhë 'yi‑ ‑kan. ");
INSERT INTO dnj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","‑Yö ꞊bɛɛn' ‑sü 'ka ka ‑bha tɔng 'sëëdhɛ 'gü ꞊nɛ ‑tɔmɔdhɛ 'ö dho kë, ‑a kë ‑mɛ ‑nu ꞊wa kë ꞊plɛ kö ‑yö ꞊bhlëzë. ");
INSERT INTO dnj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ka gia‑, ‑ka ‑dhɛ ‑ga bhë 'dhɛ! Ma ‑de gia‑, a ‑tɔmɔdhɛ ‑kë n ‑de ‑bha, 'ö ꞊ya 'go mü 'ö n Dë gia‑ ‑de 'ö n bɔ bhë 'pö, 'yö ö ‑bha ‑kë n ‑ma.» ");
INSERT INTO dnj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","'Yö 'wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Ü dë ‑de 'kö ('ü‑ ‑wun ꞊blɛɛ' ‑na) bhë, ‑yö 'më poo ꞊ee?» 'Yö‑ pö ‑an ‑dhë: «'Kaa n Dë dɔ 'iin 'kaa n dɔ. ꞊Ya kë ꞊nɛ ka n ‑dɔ ‑bezë kö ka ‑dho n Dë dɔ 'pö.» ");
INSERT INTO dnj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","'Wun ‑nu bhë Yesu ‑yö ‑an ‑blɛɛ ö ‑bha mɛ ‑nu ꞊daan' ‑sü 'ka kö ‑yö ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'pian mɛ 'ö ꞊ya kë 'wo pë ‑nu gbaɔ ‑Zlan ‑dhë bhë ‑a ‑dhɛ ‑bha. 'Ö mɛ gbɛ yaa nu ‑yaan (pö ‑a ‑dhë ꞊ya 'wun ꞊zaa' ‑sü kë kö ‑yaan) ‑a 'kun, 'ö bhii kö 'töng 'ö ‑ya ‑a ‑bha 'ka bhë yaa ‑lo ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","'Yö Yesu ‑ya pö ‑an ‑dhë 'zü: «A 'dhoë‑ dho; ka ‑dho n ꞊mɛɛ'‑ 'kɛɛ ka 'ka 'dho n yö; ka ‑dho ga ka ‑bha ꞊sɔɔn yaa ‑nu 'gü, 'ö tɔɔ ‑dhɛ 'a dho dho ‑a ‑bha bhë, kaa 'dho ‑mɔa 'kaan‑ ‑da ‑a ‑dhɛ ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","'Yö Zuifö ‑nu ‑gɔmɛ ‑nu ‑wo yö ‑a pö ‑sü ‑bha wo 'ko ‑nu ‑dhë: «‑A pö 'ö‑ wo ‹ka 'ka 'dho ‑da ‑dhɛ 'a dho dho ‑a ‑bha bhë ‑a ‑dhɛ ‑bha› ꞊nɛ kö ꞊ya kë 'dhö kö ö ‑de zë 'pö dhoë‑ wo bhë ee?» ");
INSERT INTO dnj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ, 'ö‑ pö: «Ka 'pö, ka 'kpongtaa zö, kaa 'go dhang‑ 'gü; 'kɛɛ ma ‑zë, 'maa 'kpongtaamɛ 'ka, a ‑go dhang‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pë 'ö ‑kë 'a‑ pö ka ‑dhë, ka ‑dho ga ka ‑bha ꞊sɔɔn yaa ‑nu 'gü bhë 'ö bhë; 'ö bhii ꞊ya kë ꞊nɛ kaa‑ ‑wun ‑dhɛ 'wun gia‑ ꞊nɛ ma ꞊nɛ 'a tɔɔ ‹mɛ 'ö ‑dhö›, kö ka ‑dho ga 'gbönggböng ka ‑bha ꞊sɔɔn yaa ‑nu 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","'Yö 'wo‑ pö ‑a ‑dhë: «Dö ‑mü ü 'ka ɛɛ?» 'Yö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «'Go ‑a züdɔyi ‑bha 'ö yö ꞊dɛɛ ‑bha ꞊nɛ, 'wun ‑nu 'a‑ ꞊blɛɛ bhë, waa ka ‑zo 'kun a? ");
INSERT INTO dnj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'Wun ‑yö n ‑gɔ ꞊va kö 'aan‑ ꞊blɛɛ'‑ ka ‑blü 'gü. 'Kɛɛ ‑yö kë 'püë‑ wo ka 'yaan ꞊nɛ mɛ 'ö n bɔ bhë ‑yö 'wun gia‑ ‑blɛɛ; 'ö pë 'a‑ ꞊daan ‑a 'piö ꞊nɛ 'a 'kpongtaamɛ ‑nu ꞊daan ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","'Wun bhë ‑a ꞊blɛɛ'‑ 'ö‑ wo 'dhö bhë, ‑an ꞊zuö' yaa yö ‑a Dë 'ö kwa ‑bha ‑Zlan 'ka bhë ‑a ‑bha ꞊nɛ yö 'ö‑ ‑wun ꞊blɛɛ' ‑na bhë. ");
INSERT INTO dnj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","'Yö Yesu ‑ya pö ‑an ‑dhë: «Yi 'ö 'ka dho Mɛgbö dɔa ‑gaatalü ‑bha bhë, ‑a yi bhë ‑a 'ka ka ‑dho ‑a dɔa ꞊nɛ ma 'a tɔɔ ‹mɛ 'ö ‑dhö›; yi bhë ‑a 'ka, ka ‑dho ‑a ‑dhɛ yö ꞊nɛ pë ‑nu 'a ‑an kë ‑na ꞊nɛ, yaa 'go n ‑de 'gü. Pë ‑nu 'ö n Dë ‑yö n ꞊daan ‑a 'ka bhë ꞊nɛ 'a‑ ꞊blɛɛ' ‑na ꞊nɛ. ");
INSERT INTO dnj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mɛ 'ö n bɔ bhë ‑yö n 'piö. Yaa n 'to 'sloo 'ka 'ö bhii pë 'ö‑ ‑zo 'kun ‑wun 'ka ꞊nɛ ꞊ya kë 'a‑ ‑kë.» ");
INSERT INTO dnj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","'Wun bhë ‑a ꞊blɛɛ'‑ 'ö Yesu ‑ya wo 'dhö bhë, ‑yö ‑ya mɛ ꞊plëëzë ꞊zuö' ‑bha 'ö 'wo‑ ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö mɛ ‑nu 'wo Zuifö 'ka 'wo‑ ‑wun ‑dhɛ 'wun gia‑ bhë ‑an ‑dhë: «'Ö ꞊ya kë ꞊nɛ ma mɛ ꞊daan' ‑wo ‑nu 'a mɛ ꞊daan' ‑na ‑an 'ka bhë, 'ka‑ 'kun ö 'kun ‑kɔ 'ka kpinngdhö, ka ‑dho kë ma ꞊guë' ‑nu gia‑ 'ka; ");
INSERT INTO dnj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","꞊ya kë 'dhö, ka ‑dho 'wun gia‑ dɔ; 'ö‑ ‑wun 'gü, 'ka dho kë ‑potaasü.» ");
INSERT INTO dnj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","'Yö 'wo‑ pö ‑a ‑dhë: «Yi Ablaamö ꞊suu'‑ ‑ta ‑nu 'ka; ꞊ya kë 'dhö kö yiëë kë do mɛ gbɛ ‑gɔ 'gan 'gü. ꞊Ya kë 'dhö kö yi ‑bha ‑go 'gan 'gü ‑sü kö ‑potaasü ‑yaan kë yi ‑gɔ bhë ‑yö ‑go 'më 'wun bhë ‑a 'gü ii?» ");
INSERT INTO dnj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","'Yö Yesu ‑ya pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Mɛ 'kö ꞊sɔɔn yaa ‑kë, kö ‑yö ꞊sɔɔn yaa ‑gɔ ꞊nuadhɛ 'gü ꞊nɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","꞊Nua 'ö 'ka‑ ‑ga ‑na bhë, mɛ ‑mɛ 'yaa ‑mü. Mɛ 'ö mɛ ‑mɛ 'ka 'ö tɔɔ Mɛgbö; 'ö dho toë 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'Ö ꞊ya kë ꞊nɛ mɛ 'ö mɛ ‑mɛ 'ka, 'kwa ‑we ‑a 'ka ‑Zlan Gbö 'ka bhë, ꞊ya kë ꞊nɛ ꞊ya ka bho ꞊nuadhɛ 'gü, kö ‑potaasü giagia ꞊ya kë ka ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kë‑ wo bhë a‑ ꞊tɛi' ‑dɔ ꞊nɛ Ablaamö ꞊suu'‑ ‑ta ‑nu ‑mü kaa. 'Kɛɛ ka‑ 'piö 'ka n zë 'sa! 'Ö tɔɔ 'kaa ka ‑kɔ 'kpɔ ma mɛ ꞊daan' ‑wo ‑nu ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pë ‑nu 'ö n Dë ‑ya ‑zɔn n ‑dhë bhë ꞊nɛ 'a ‑we ‑a 'ka; 'kɛɛ ka ‑zë, pë ‑nu 'ö ka dë ‑ya pö ka ‑dhë bhë ꞊nɛ 'ka‑ ‑kë.» ");
INSERT INTO dnj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","'Yö 'wo‑ pö ‑a ‑dhë: «Yi dë 'ö tɔɔ Ablaamö.» 'Ö Yesu ‑ya pö ‑an ‑dhë: «꞊Ya kë ꞊nɛ ka ‑kë Ablaamö ‑bha 'në ‑nu gia‑ 'ka ‑be, ka ‑dho ‑a këpë ‑nu kë. ");
INSERT INTO dnj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","'Kɛɛ dɔ 'kwa‑ wo ꞊nɛ, 'kö ‑kë ꞊nɛ 'wun gia‑ 'a goë ‑Zlan 'piö bhë a‑ ‑blɛɛ ka ‑dhë, pë do 'ö ka ꞊zuö' 'piö 'ö tɔɔ 'ka n zë. ‑A ꞊ga 'ka‑ wo bhë, Ablaamö bhë, kë‑ wo ꞊nɛ ‑yö 'wun ꞊suu'‑ bhë ‑a ‑kë ‑a? ");
INSERT INTO dnj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","꞊Ɛɛ, 'ö 'ka‑ ‑yö bhë ꞊a! Mɛ 'ö ka dë 'ka bhë ꞊nɛ 'ka 'to ‑a pin 'piö, 'ka pë ‑nu kë ‑na 'dhö bhë.» 'Yö 'wo‑ ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «'Yiëë 'në ‑nu 'ö mɛ ‑nu ‑wo ‑mɔa ‑wa pö ‑gbloo 'gü ‑në ‑nu ‑mü yi 'ka ‑an 'ka; yi dë ‑yö do ‑Zlan 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «‑Zlan 'ka‑ ꞊wɔɔn ‑na bhë, ꞊ya kë ꞊nɛ ‑yö ka dë 'ka 'wun gia‑ 'ka ‑bezë, n ‑dhɔ ‑yö ‑dho ka kë, 'ö tɔɔ nu 'a‑ wo zö ꞊nɛ, ‑Zlan ꞊nɛ 'ö n bɔ, 'a go ‑a 'piö 'a nu; yaa kë ꞊nɛ a ‑nu n ꞊deë' 'dhö, yö kun; yö ꞊nɛ 'ö n bɔ. ");
INSERT INTO dnj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","꞊Ya kë 'dhö kö 'wun ‑nu 'a‑ ꞊blɛɛ' ‑na ka ‑dhë ꞊nɛ ‑a ma 'kaa‑ wo n ‑gɔ bhë 'ö tɔɔ n ‑wo ‑nu ma ‑to ꞊ya ta ka ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ka dë 'ö tɔɔ dü. Pë 'ö 'ka‑ 'piö 'ö tɔɔ ka dë 'ö bhë ‑a ‑zo 'kun ‑wun kë ‑sü. 'Go ‑a züdɔyi ‑de ‑bha, mɛ zë ꞊nɛ 'ö‑ wo ‑kplawo. Yaa dɔ 'wun gia‑ 'gbloo 'piö do, 'ö bhii 'wun gia‑ 'yaa‑ 'gü. ꞊Ya kë ꞊nɛ ꞊ya ꞊sua ‑wun ‑nu ꞊blɛɛ', 'yaa pë gbɛ 'ka yö ꞊ga ꞊suamɛ ‑mü ‑a 'ka, 'ö ꞊sua dë 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","'Kɛɛ ma ‑zë, 'wun gia‑ ꞊nɛ 'a‑ ꞊blɛɛ; pë 'ö ‑kë 'ö 'kaa n ‑wo ‑nu ‑dhɛ 'wun gia‑ 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","꞊Dhɛɛ' do ꞊ga ꞊nɛ: Dö ‑mü ka songdhö 'ö dho ‑mɔa kö ‑yaan ‑zɔn ꞊nɛ 'ma ꞊sɔɔn yaa kë ꞊ɛɛ? 'Ö ꞊ya kë 'dhö kö ‑më ‑kë 'ö 'ma 'wun gia‑ ꞊blɛɛ'‑, 'ö 'kaa‑ ‑dhɛ 'wun gia‑ ꞊nɛɛ? ");
INSERT INTO dnj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","'Kɛɛ kë‑ wo bhë ‑yö kë ka 'yaan ꞊nɛɛ: Mɛ 'ö ‑Zlan ‑bha mɛ 'ka, ‑yö ö 'to ‑kë ‑Zlan ‑wo ‑bha. Ka 'ö 'ka bhë, 'kaa ‑Zlan ‑bha mɛ 'ka bhë yö ꞊ga 'ö‑ kë ‑kɔ 'dhö bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","'Yö Zuifö ‑nu ‑wa pö ‑a ‑dhë: «‑A pö 'yi‑ wo Samali mi ‑mü ü 'ka, 'iin 'ö ‑zuu yaa ‑yö ü 'gü bhë, bhi gia‑, ‑dhɛ 'ü‑ ‑ga ‑a 'gü bhë, ꞊sua 'yi‑ ‑kë ‑a?» ");
INSERT INTO dnj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","'Yö Yesu ‑ya pö ‑an ‑dhë: «‑Zuu yaa 'yaa n 'gü. Pë 'a‑ ‑kë 'ö tɔɔ n Dë ꞊bhlë ‑ya 'a‑ wo; 'kɛɛ ka ‑zë, ka ‑kɔ n ꞊bhlë ‑ya ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Maa 'tɔbhɔdhe ꞊mɛɛ'‑ n ‑de ‑bha 'ka; mɛ 'ö 'tɔbhɔdhe ꞊mɛɛ' ‑na n ‑ma 'ka bhë ‑yö ‑dhö. Yö ꞊nɛ ꞊ya kë 'ö za kan bhë. ");
INSERT INTO dnj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'Kɛɛ a‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: Mɛ 'ö ꞊ya n ‑wo ‑nu ꞊bhlë ‑ya, yö 'ka 'dho ga 'gbɛɛdhö.» ");
INSERT INTO dnj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","'Yö Zuifö ‑nu ‑wa pö ‑a ‑dhë: «‑Aa ‑ba, 'yië ü ‑dhɛ yö 'sabla! ‑Zuu yaa do ‑yö ü 'gü! Ablaamö ꞊ya ga; ‑Zlan ‑wodhiölomɛ ‑nu ꞊wa ga; 'kɛɛ bhi ‑zë, ü‑ pö: ‹Mɛ 'ö ꞊ya n ‑wo ‑nu ꞊bhlë ‑ya, yö 'ka 'dho ga 'gbɛɛdhö.› ");
INSERT INTO dnj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Yi dë Ablaamö bhë ꞊ya ga; ‑Zlan ‑wodhiölomɛ ‑nu 'wo bhë ꞊wa ga 'pö. ꞊Ya kë 'dhö kö kë 'pö 'ü‑ wo ꞊va ‑an ‑bha 'pö bhë ee? ꞊Ya kë 'dhö kö ‑më ‑mü ü 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","'Ö Yesu ‑ya ‑daa ‑kë 'ö‑ pö: «꞊Ya kë ꞊nɛ n ‑de 'sü 'a‑ wo ꞊va ‑be, kö ‑a ‑yöë ‑pë gbɛ 'yaa ‑dhö. 'Kɛɛ mɛ 'ö n 'sü ‑na ꞊bhlëzë bhë 'ö tɔɔ n Dë 'ö 'ka‑ pö ‑na ‑yö ka ‑bha ‑Zlan 'ka bhë. ");
INSERT INTO dnj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","'Kɛɛ kö 'kaa‑ dɔ 'sa! Ma ‑zë a‑ ‑dɔ. ꞊Ya kë ꞊nɛ a‑ ‑pö ‑bezë 'maa‑ dɔ kö ꞊sua 'a‑ ‑kë ꞊nɛ ka 'dhö. 'Kɛɛ a‑ ‑dɔ ‑së 'ka, 'ö 'a‑ ‑wo ‑nu ꞊bhlë ‑ya. ");
INSERT INTO dnj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ka dë Ablaamö 'ö bhë, kë‑ wo 'kpa bhë, pë 'ö‑ ‑zo ‑kë ‑a ‑dhë 'ö tɔɔ kö 'ö ö 'yan dɔ n ‑ma. 'Ö‑ ꞊zuö' 'glu ‑yö dhi nu 'a dho ‑a wo bhë ‑a ‑wun 'gü; 'ö ꞊dhɛ ꞊yaa‑ yö 'ö‑ ꞊zuö' 'glu ‑yö ‑dhi.» ");
INSERT INTO dnj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","'Yö Zuifö ‑nu ‑wa pö ‑a ‑dhë: «Bhi 'ö ü ‑kwɛ yaa 'gɔɔ‑ 'sɔɔdhuzë ꞊kun bhë, 'ü ü 'yan ‑kpën Ablaamö ‑bha ‑sü ‑wun ꞊blɛɛ 'fɛfɛ 'ka 'dhö a?» ");
INSERT INTO dnj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","'Yö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: Ablaamö bhë ‑a kë ꞊yië' ‑dewo kö ‑yaan bhɔ kö a ‑dhö, 'ö 'a ꞊tun ‑dhö ꞊nɛ.» ");
INSERT INTO dnj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","꞊Dhɛ ꞊yaa‑ pö 'dhö, 'wo ‑guö ‑lö kö ‑waan ‑a ‑zuö ‑a 'ka. 'Kɛɛ Yesu ‑yö ‑bin 'ö ‑ziö 'ö go ‑Zlan ‑gba ‑a 'gü ‑kɔ mü 'ö dho. ");
INSERT INTO dnj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu ‑yö ‑kë ziö ꞊dhia yi do 'ka, 'ö ‑kpën gɔɔn‑ do 'ö‑ 'yënng ‑yö ‑kë tii 'ö bhɔa ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","'Yö‑ ‑bha ꞊guë' ‑nu ‑wa ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Yi ‑Gɔmɛ, ‑më ‑kë 'ö gɔɔn‑ ꞊nɛ 'ö‑ 'yënng ‑kë tii 'ö bhɔa ꞊ɛɛ? Kö kë‑ wo bhë, ‑yö ‑sü ‑a ‑de ꞊sɔɔn ‑bha ꞊ii, 'iin ‑yö ‑sü ‑a ‑mɛ ‑nu ꞊sɔɔn ‑bha ꞊ii?» ");
INSERT INTO dnj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","'Ö Yesu ‑ya pö ‑an ‑dhë: «Yaa yö ‑a ꞊sɔɔn 'iin ‑a ‑mɛ ‑nu ꞊sɔɔn ‑wun ‑bha. ‑Yö ‑bhɔ 'yënngtiimɛ 'ka 'dhö ‑yö kë 'dhö kö ‑Zlan ‑yaan bɔ ‑a 'gü ‑yaan pë ‑nu kë. ");
INSERT INTO dnj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","꞊Dhɛ 'ö‑ ‑dhɛ 'dhö ꞊tun 'po ‑sü bhë, kwa ꞊dua' ‑mü kö mɛ 'ö n bɔ bhë, kwa‑ ‑bha yuö kë. Gbeng ‑yi 'yaa ꞊gbiin gbɔ, 'ö bhii 'kwa dɔ gbeng ꞊sia, kwa yuökëdhɛ gbɛ 'ka dho kë ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","'Töng 'a‑ 'ka 'kpongtaa ꞊nɛ, a ‑dhɛpuudhɛ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","꞊Dhɛ ꞊yaa‑ pö 'dhö, 'yö ö 'dhee bho; 'yö‑ ꞊kaan 'sɛ 'ka 'ö‑ ꞊glüü gɔɔn‑ 'ö bhë ‑a 'yënngdhö, ");
INSERT INTO dnj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","'ö‑ pö ‑a ‑dhë: «'Dho 'ü ü wöödhɛ 'zlu Siloe 'yi ‑glu ꞊bhaa.» (꞊Waa‑ pö Siloe kö ‑wa ‑pö «mɛ 'wo‑ bɔ».) 'Yö ꞊dhɛ gɔɔn‑ bhë ꞊ya 'dho ꞊ya ö wöödhɛ 'zlu, 'yö nu kö ‑a 'yan ꞊ya ‑dhɛ yö. ");
INSERT INTO dnj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","'Yö gɔɔn‑ bhë ‑a ‑zü 'to mɛ ‑nu 'wo ‑an ‑gɔ 'gunng 'gü bhë, ꞊dhɛ ꞊waa‑ yö, 'wo‑ pö: «Gɔɔn‑ ꞊nɛ 'yaa ‑mü 'ö ‑kë ꞊yaannu ‑sü 'ka ‑de, ‑gba ‑dhɛ ‑sü 'ka ꞊naa?» ");
INSERT INTO dnj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kö mɛ 'bhaa ‑nu ‑wa pö ‑na: «Yö ‑mü.» Kö mɛ 'bhaa ‑nu ‑wa pö ‑na: «‑Abi', 'yaa ‑mü; 'kɛɛ ‑yö ‑bhɔ ‑a ‑bha.» ꞊Dhɛ ꞊ya kë 'dhö, 'ö gɔɔn‑ bhë 'ö‑ pö ‑an ‑dhë: «Ma gia‑ ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","'Yö 'wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑A kë ‑kɔ ‑yö ‑kë ꞊dhë 'ö 'ü ‑dhɛ yö ꞊ee?» ");
INSERT INTO dnj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","'Yö‑ ‑daa kë 'ö‑ pö: «Gɔɔn‑ 'wo‑ ‑dhɛ Yesu bhë ꞊nɛ 'ö pë ‑kë ꞊nɛ 'yɔɔ 'dhö 'ö‑ sü 'ö‑ ꞊glüü n 'yënggdhö, 'ö‑ pö n ‑dhë: ‹‑Bhö 'dho Siloe 'yi ‑glu ꞊bhaa 'ü ü wöödhɛ 'zlu›; 'yö ꞊dhɛ 'a yën n wöödhɛ 'zlu ‑sü ‑bha 'ö n 'yan ‑yö ‑dhɛ yö.» ");
INSERT INTO dnj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","'Yö 'wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Gɔɔn‑ bhë, ‑yö 'më ɛɛ?» 'Yö‑ pö ‑an ‑dhë: «‑Dhɛ 'ö‑ ‑bha 'maa‑ dɔ ‑ɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","꞊Dhɛ 'wun ‑nu bhë ꞊wa kë 'dhö, 'ö gɔɔn‑ bhë 'wo dhoë Falizi ‑mɛ ‑nu ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","‑A ‑gɛn tɔɔ 'töng 'ö Yesu ‑yö ö ‑kɔ ‑ziö ‑a 'ka ö 'dhee 'gü 'sɛ ‑kaan ‑a 'ka ‑sü 'ka kö ‑yaan gɔɔn‑ bhë ‑a 'yan 'dhi poë bhë, ‑yö ‑kë Zuifö ‑nu ‑bha ꞊glooyi 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","'Yö gɔɔn‑ bhë 'wo‑ ꞊dhɛɛ' kpɔ ‑kɔ 'ö ꞊kaa' bhë ‑a ‑wun 'ka kö wo gia‑ ‑waan yö. 'Yö‑ pö: «'Yɔɔ pë 'tee 'ö‑ bho 'ö ꞊glüü n 'yënngdhö, 'a dho 'a n wöödhɛ ‑zlu, 'yö n 'yan ‑yö ‑po ꞊nɛ.» ");
INSERT INTO dnj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","'Yö Falizi ‑mɛ 'bhaa ‑nu ‑wo yö ‑a pö ‑sü 'gü ꞊nɛɛ: «Mɛ 'ö 'wun ‑kë ꞊nɛ ‑Zlan ‑bha mɛ 'yaa ‑mü bhii yaa ꞊glooyi ‑bha tɔng 'kun.» Kö ‑a mɛ 'bhaa ‑nu ‑wa pö ‑na: «‑A ꞊ga 'ka‑ wo bhë ꞊sɔɔnyaamɛ ‑yö ‑mɔa kö ‑yö ‑dhidhaapë ꞊suu'‑ ꞊nɛ ‑a kë ꞊a?» 'Yö 'wun bhë ‑a ‑wun 'gü 'ö 'gügludhe ‑yö ‑da ‑an ziën. ");
INSERT INTO dnj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","꞊Dhɛ ꞊ya kë 'dhö, 'ö Falizi ‑mɛ ‑nu ‑wo ꞊dhɛɛ' 'bhaa kpɔ gɔɔn‑ 'ö‑ 'yan ‑yö bo bhë ‑a ‑gɔ ꞊nɛɛ: «Bhi gia‑ ‑de 'ö gɔɔn‑ bhë 'ö ü 'yan po bhë, 'bha ‑dhɛ ‑ga 'wun bhë ‑a 'gü, gɔɔn‑ bhë dö ‑mü ‑a 'ka ɛ?» 'Yö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Zlan ‑wodhiölomɛ ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","'Kɛɛ 'wun bhë yaa Zuifö ‑nu ‑gɔmɛ ‑nu ‑zo 'kun ꞊nɛ gɔɔn‑ bhë ‑yö kë 'dhiö ꞊zian' ‑be 'yënngtiimɛ 'ka, kö 'töng bhë ‑a 'ka ‑yö kë ‑dhɛ yö ‑mɛ 'ka. 'Wo‑ ‑mɛ ‑nu ꞊dhɔɔ ‑kë; ");
INSERT INTO dnj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","'wo ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Mɛ 'ö ꞊nɛ kaa‑ 'në ‑mü ‑a? ꞊Dhɛ 'ö bhɔ bhë ‑a 'yënng‑ ‑kë tii ꞊a? ‑Më ‑wun 'ö ‑kë 'ö‑ 'yan ꞊ya 'po ꞊nɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","'Yö‑ ‑mɛ ‑nu ‑wa ‑daa ‑kë ‑an ‑gɔ 'wo‑ pö: «Pë do 'yi‑ dɔ 'ö tɔɔ yi ‑bha 'në ‑mü, 'ö‑ 'yënng ‑kë tii 'ö bhɔa. ");
INSERT INTO dnj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","‑A mɛ 'ö ‑kë gɔɔn‑ 'ö‑ ‑dhɛ bo waa‑ ‑kɔ 'ö ꞊kaa' zlöö 'ö‑ 'yan 'dhi ‑yö ‑po bhë 'yiëë‑ gbɛ dɔ. Ka gia‑, ‑kaa ꞊dhɛɛ' kpɔ 'dhɛ, ‑yö ‑mɔa ‑yö ö ‑de ‑ta ‑wun ꞊blɛɛ'; ꞊ya kë zii!» ");
INSERT INTO dnj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pë ‑kë 'ö‑ ‑mɛ ‑nu ‑wo 'wun ‑daa ‑kë 'dhö bhë, 'ö tɔɔ ‑wo ‑suö Zuifö ‑nu ‑gɔmɛ ‑nu ‑dhë, bhii tɔɔ Zuifö ꞊wa ‑mɔa 'gü 'saadhö kö mɛ 'oo mɛ 'ö 'dhoë‑ pö Yesu tɔɔ ‑Zlan ‑bha ‑Yamɛ ‑waan kë ‑yaan 'go wo songdhö wo ‑bha ‑bhɔkuëkɔ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pë ‑kë 'wo‑ pö: «꞊Ya kë zii 'saadhö; ‑yö ‑mɔa kö ‑yö ö ‑de ‑ta ‑wun ꞊blɛɛ'‑; ‑kaa ꞊dhɛɛ' kpɔ!» 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","꞊Dhɛ ꞊ya kë 'dhö, 'ö Falizi ‑mɛ ‑nu ‑wo gɔɔn‑ 'ö‑ 'yënng ‑yö ‑kë tii 'dhiö bhë ‑a ꞊dhɔɔ ‑kë 'zü ‑dëüwo 'wo‑ pö ‑a ‑dhë: «'Wun gia‑ ꞊blɛɛ'‑ ‑Zlan wö 'dhiö; gɔɔn‑ 'ö ü ‑dhɛ bo bhë yi‑ ꞊tɛi' ‑dɔ ꞊nɛ ꞊sɔɔnyaakëmɛ ‑mü ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","'Yö‑ pö ‑an ‑dhë: «‑Yö ꞊sɔɔnyaamɛ 'ka oo, 'yaa‑ 'ka oo, 'maa‑ gbɛ ‑naa dɔ. Pë do 'a‑ dɔ 'ö tɔɔ a ‑kë 'yënngtiimɛ 'ka ‑be, 'kɛɛ ꞊dɛɛ ꞊nɛ 'ma ‑dhɛ ‑yö zlöö.» ");
INSERT INTO dnj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","'Wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑Më 'ö‑ ‑kë ü 'ka ɛɛ? ‑Yö ü 'yan ‑po ‑kɔklë ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","'Yö‑ pö ‑an ‑dhë: «Ka 'to 'pö kaa‑ kë n ‑ma bhë ꞊ee, 'iin ꞊dhë, 'yaa 'pö 'ma bɔ ‑a 'gü 'saadhö ka ‑dhë. ‑Më 'ö 'ka‑ 'piö kö 'a bɔ ‑a 'gü 'zü do ka ‑dhë ꞊nɛɛ 'iin 'ka‑ 'piö kö 'ka kë ‑a ‑bha ꞊guë' ‑nu 'ka 'pö bhë ee?» ");
INSERT INTO dnj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","'Wo yö 'wun ‑blɛɛ ‑a 'ka ‑sü ‑bha 'wo‑ pö: «Bhi ꞊nɛ 'ü tɔɔ gɔɔn‑ bhë ‑a ‑bha ꞊guë'. Yi ‑zë yi Moizö ‑bha ꞊guë' ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yi‑ ꞊tɛi' dɔ ꞊nɛ kë‑ wo 'kpa bhë, ‑Zlan ‑yö 'wun ‑blɛɛ Moizö ‑dhë; 'kɛɛ mɛ ꞊suu'‑ ꞊nɛ 'yiëë‑ 'godhɛ ‑dee dɔ!» ");
INSERT INTO dnj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","꞊Dhɛ ꞊ya kë 'dhö, 'ö gɔɔn‑ bhë 'ö‑ pö ‑an ‑dhë: «꞊Aan'‑, ka gia‑ ka‑ ‑yö bhë ꞊aa! Mɛ 'te 'tun ‑wun do kun bhë ꞊a; 'kaa‑ 'godhɛ dɔ, 'kɛɛ ꞊ya n ‑dhɛ bo 'sa! ");
INSERT INTO dnj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kwa‑ ꞊tɛi' dɔ ꞊nɛ ‑Zlan 'yaa ö 'to kë ꞊sɔɔnyaamɛ ‑nu ‑bha, 'kɛɛ ‑yö ö 'to ‑kë mɛ 'ö‑ ꞊bhlë ‑ya, 'ö‑ ‑zo 'kun ‑wun ‑nu ‑kë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","'Ka‑ ma do ꞊nɛ mɛ ꞊ya kë ‑dhö ꞊ya mɛ 'ö 'yënng 'dhö tii 'ö bhɔa ‑a 'yan 'dhi 'po ꞊a? ");
INSERT INTO dnj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Gɔɔn‑ 'ö bhë ꞊ya kë ꞊nɛ yaa 'go ‑Zlan 'piö ‑be, yö 'ka 'dho pë gbɛ kë.» ");
INSERT INTO dnj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","'Yö 'wo‑ pö ‑a ‑dhë: «‑Më 'ü dɔa ꞊nɛɛ, bhi 'ü ꞊sɔɔn yaa 'gü ü ‑de 'böü 'ka 'ü bhɔa bhë, ü‑ 'piö 'ü yi ꞊daan'‑ 'pö a?» ꞊Dhɛ ꞊ya kë 'dhö, 'wo‑ ‑kë 'ö go ‑an ‑bha ‑bhɔkuëkɔ 'gü mü. ");
INSERT INTO dnj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","'Wun bhë Yesu ‑ya ‑ma ꞊nɛ gɔɔn‑ bhë ꞊waa‑ kë. ꞊Dhɛ ꞊ya kë 'dhö, 'yö dho ‑a 'piö 'yö‑ ꞊dhɛɛ' kpɔ ꞊woë' ꞊nɛɛ: «Ü Mɛgbö ‑wun ‑dhɛ 'wun gia‑ ‑a?» ");
INSERT INTO dnj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","'Ö gɔɔn‑ bhë 'yö‑ pö: «N ‑Gɔmɛ, mɛ bhë dö ‑mü ‑ii kö 'aan‑ ‑a ‑wun ‑dhɛ 'wun gia‑ ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","'Ö Yesu ‑ya pö ‑a ‑dhë: «Yö ‑de gia‑ 'ö 'wun ꞊blɛɛ' ‑na ü ‑dhë ꞊nɛ!» ");
INSERT INTO dnj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","'Yö gɔɔn‑ bhë 'ö yö ö kpɔn 'gü Yesu 'dhiö, 'ö‑ pö ‑a ‑dhë: «A ü ‑wun ‑dhɛ 'wun gia‑, n Dëmɛ.» ");
INSERT INTO dnj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑a ‑dhë: «A ‑nu 'kpongtaa zö za 'kan ‑wun 'ka, kö 'yënngtiimɛ ‑nu ‑waan ‑dhɛ yö, 'iin kö mɛ ‑nu 'wo ‑dhɛ yö kö ‑an 'yënng ‑yaan trö.» ");
INSERT INTO dnj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Falizi ‑mɛ ‑nu 'wo ‑kë mü 'pö bhë, ꞊dhɛ 'ö‑ mɛ 'bhaa ‑nu ꞊waa‑ ‑wo bhë ‑a ma, 'wo‑ ꞊dhɛɛ' kpɔ, 'wo‑ pö: «Yi ‑de 'pö yi 'yënngtiimɛ ‑nu 'ka a?» ");
INSERT INTO dnj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","'Ö Yesu ‑ya pö ‑an ‑dhë: «꞊Ya kë ꞊nɛ ka ‑kë 'yënngtiimɛ ‑nu 'ka ‑bezë kö za 'ka 'dho ka kun; 'kɛɛ ꞊dhɛ ‑kë ꞊nɛ ka‑ ‑pö ka ‑de ‑dhë ꞊nɛ ka 'yan ‑yö 'po ‑sü 'ka bhë, yö ꞊ga 'ö za ꞊ya ka kun bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü ꞊nɛɛ: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Mɛ 'ö dho ‑da ‑tuë ‑nu wɔdhɛ ‑bha, 'ö yaa bɔ ‑a 'dhi ‑bha, 'ö ꞊ya ‑lö ‑gla ‑zü, kö mɛ bhë ꞊kwaanmɛ ‑mü ‑a 'ka, kö këpëyaamɛ ‑mü ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","'Kɛɛ mɛ 'ö ꞊ya bɔ 'kɔdhi ‑bha 'ö ꞊ya ‑da mü, kö ‑tuë ‑nu 'wo bhë ‑an ‑maakëmɛ ‑mü ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","꞊Ya kë 'dhö 'ö 'kɔ ‑maakëmɛ ‑yö 'kɔdhi ‑po ‑a ‑gɔ 'ö ‑da mü. ꞊Ya kë 'dhö 'ö ‑tuë ‑nu ‑wo 'wun ma ‑a ‑ta. Yö ꞊nɛ 'ö ꞊ya ‑tuë ‑nu 'wo bhë ‑an ꞊dhɔɔ kë ‑a mɛ 'ö ‑dhö ‑a 'tɔ 'ka, 'ö 'wo ‑ziö ‑a 'piö 'ö dho ‑an 'ka plaan. ");
INSERT INTO dnj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wo 'plɛ ꞊wa yö plaan, 'ö yö ‑an ‑dhë 'dhiö, 'wo ‑ziö ‑a 'piö 'ö bhii ‑wo wo ‑maakëmɛ ‑wo ‑dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","'Kɛɛ waa 'dhö ‑mɔa ‑wo ziö mɛ 'ö 'waa‑ dɔ ‑a 'piö. ꞊Duë ꞊nɛ 'wo dho ‑a wo ‑a ‑dhë; 'ö tɔɔ 'waa‑ ‑wo dɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","'Wun ꞊zuan' bhë ꞊dhɛ Yesu ꞊yaa‑ ‑zɔn ‑an ‑dhë 'dhö, waa‑ ‑gɛn ma. ");
INSERT INTO dnj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü: «A‑ ‑pö ka ‑dhë giagia 'ka ꞊nɛ ‑tuë ‑nu ‑bha 'kɔ bhë ‑a kpong wɔdhɛ ‑yö ‑a 'dhi ‑bha ‑pë 'ö tɔɔ ma. ");
INSERT INTO dnj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mɛ ‑nu 'wo nu n 'dhiö 'saadhö bhë, ꞊kwaanmɛ ‑nu ‑mü ‑an 'ka; këpëyaamɛ ‑nu ‑mü ‑an 'ka. 'Kɛɛ ‑tuë ‑nu waa 'to ‑an ‑wo ‑nu 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ma ꞊nɛ 'a tɔɔ ‑yö 'kɔdhi ‑bha kpong. Mɛ 'ö ꞊ya bɔ n ‑ta ꞊ya ‑da kɔɔ, ‑yö ‑dho dha. ꞊Ya kë 'dhö, ‑yö ‑dho ‑mɔa ‑yö ‑da kɔɔ 'iin ‑yö yö plaan; ‑yö ‑dho ö ‑bha ‑bhöpë yö. ");
INSERT INTO dnj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","꞊Kwaanmɛ 'ö 'ka‑ ‑ga ‑na bhë, ‑yö ‑nu kö ‑yaan ö ‑bha ꞊kwaan, ‑yaan mɛ zë, ‑yaan pë 'gü ꞊siö'‑. ‑A ‑bha yuö ꞊nɛ bhë. 'Kɛɛ ma ‑zë a ‑nu kö ‑këdhösü ‑yaan kë mɛ 'bhee‑ ‑nu ‑gɔ ö 'plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ma ꞊nɛ 'a tɔɔ ‑tuëmaakëmɛ giagia. ‑Tuëmaakëmɛ giagia 'ö bhë ‑yö ö ‑de ‑nu ö ‑bha ‑tuë ‑nu ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'Kɛɛ mɛ 'ö yuö ‑kë kö ‑waan ‑a ꞊saan' bho, 'ö 'yaa ‑tuëmaakëmɛ giagia 'ka bhë; ‑tɔan gbɛn‑ ꞊ya ‑wo yö, 'ö ‑tuë ‑nu 'wo bhë ‑an ‑dhë 'dhiö bhë, ‑yö ‑duë 'ö dho 'ö ‑tɔan gbɛn‑ ‑yö kan ‑an 'gü 'ö 'bhla ‑nu ‑wo ‑pɛn. ");
INSERT INTO dnj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","꞊Duë 'ö‑ wo bhë 'ö tɔɔ pë 'ö‑ ‑yuö kë ‑na bhë 'ö tɔɔ 'wëü‑; 'yaa ö ‑zo 'ta 'bhla ‑nu ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ma ꞊nɛ 'a tɔɔ ‑tuëmaakëmɛ giagia. ‑Kɔ do 'ö n Dë ‑yö n dɔa, 'ö ma ‑de 'pö 'a‑ dɔa bhë 'ö‑ 'ka 'pö yië‑ ma 'bhla ‑nu yi songdhö 'ö 'a n ‑de ‑nu ‑an ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","‑Tuë 'bhaa ‑nu ‑wo n ‑gɔ 'ö 'waa ‑tuë wɔdhɛ 'ö ꞊nɛ ‑a ‑bha. ꞊Yö ‑së kö 'a yö ‑an ‑dhë 'dhiö kö ‑wo ‑da mü 'pö. ‑Wo ‑dho n ‑wo ma, 'ö ‑an dho 'kuë‑ ‑sü ‑yö ‑kë do, 'ö ‑an ‑maakëmɛ ‑yö ‑kë do. ");
INSERT INTO dnj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","N Dë ‑yö n ‑dhɔ ‑kë; 'ö tɔɔ a n ‑ma ‑tosiadhe ‑nu kö ‑këdhösü ‑yaan kë n ‑gɔ 'zü. ");
INSERT INTO dnj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yaa kë ꞊nɛ n 'gbee‑ ‑ta 'wo‑ bho. A‑ ‑sü n ‑de 'gü 'a n ‑ma ‑tosiadhe nu. ‑Kɔ ‑mɔ 'wuën‑ ‑sü ‑yö n ‑gɔ kö 'aan‑ ‑a nu 'iin kö 'aan‑ ‑a yö 'zü. Pë 'ö n Dë ‑yö n bɔ ‑a ‑wun 'ka 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","'Wun 'ö‑ ꞊blɛɛ' ‑kɔ ꞊suu'‑ ‑yö ‑kë 'dhö bhë, ‑yö 'gügludhe ‑da Zuifö ‑nu ziën 'zü. ");
INSERT INTO dnj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","‑An mɛ ꞊plëëzë ‑wo ‑kë ‑a pö ꞊dhia: «‑Zuu yaa do ‑ya 'gü! ‑Yö 'blɔɔnzë! Ka ka 'to ‑to ‑a ‑bha ‑më ‑wun 'gü ii?» ");
INSERT INTO dnj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","‑An mɛ 'bhaa ‑nu ‑wo ‑kë ‑a pö ꞊dhia 'pö: «Mɛ 'ö ‑zuu yaa 'dhoë‑ 'gü, ‑a 'wun ꞊blɛɛ' ‑wo yaa kë ‑dhö. Kë‑ wo bhë, 'ka‑ ma do ꞊nɛ ‑zuu yaa ꞊ya 'yënngtiimɛ 'yan 'po do 'ka‑ yö ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","(꞊Dhɛ 'ö 'töng 'bhaa ꞊ya ziö,) mɛ ‑nu ‑wo ‑nu wo 'ko ꞊bhaa Zeluzalɛmë kö ‑Zlan ‑gba ‑a 'gü ‑kɔ kë 'wo‑ wo 'slööslö 'kpa bhë ‑a 'wlaan‑ 'wo‑ kë ‑na ‑kwɛ ‑bha bhë, ‑waan ‑a wo 'zü. ‑Yö ‑kë 'dhö 'nɛnɛ 'töng 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu ‑yö ‑kë ꞊ziö' 'ziö ꞊dhia ‑Zlan ‑gba ‑a 'gü ‑kɔ 'pian mɛ 'ö Salomɔ ‑bha ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑gban 'lü 'dhoë‑ 'ka bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","'Ö Zuifö ‑nu ‑wo ꞊nië ‑a ‑zü, 'wo‑ pö ‑a ‑dhë: «‑Më 'ü dɔ ‑a ‑gɔ kö 'üën‑ ü dɔ ‑kɔ ꞊blɛɛ' yi ‑dhë ɛɛ? ꞊Ya kë ꞊nɛ bhi ꞊nɛ 'ü ‑Zlan ‑bha ‑Yamɛ 'ka, ‑a pö yi ‑dhë do ꞊klöödhö kö yi ꞊zuö' 'go yi ꞊zlöö.» ");
INSERT INTO dnj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑A mɛ 'kö bhë, 'ma‑ ꞊blɛɛ' ka ‑dhë 'saadhö; kë‑ wo 'ö 'kaa n ‑wo ‑dhɛ 'wun gia‑ bhë yö ‑mü. Pë ‑nu 'a‑ kë ‑na n Dë 'tɔ 'gü bhë ‑wa ‑zɔn ꞊nɛ n ‑gɔ ‑wun ‑yö 'wun gia‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","'Kɛɛ n ‑wun ‑dhɛ 'kaa‑ wo ‑na 'wun gia‑ bhë 'ö tɔɔ ma 'bhla ‑tuë ‑nu bhë 'kaa ‑an kpö 'gü ‑mɛ ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","'Ö bhii ma 'bhla ‑nu 'wo bhë ‑wo wo 'to ‑to n ‑wo ‑bha. A ‑an ‑dɔ, 'ö ꞊ya kë 'ma ‑an ꞊dhɔɔ kë, 'wo nu n ꞊dhɔɔ ‑wo ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A ‑dho ꞊toëpö ‑këdhösü nu ‑an ‑dhë; waa 'dho ga 'gbɛɛdhö, 'iin 'ö mɛ gbɛ 'ka 'dho ‑an bho n kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","N Dë 'ö pë nu n ‑dhë bhë ‑yö ꞊va 'ö ‑ziö pë 'plɛ ‑ta. Mɛ gbɛ 'ka 'dho pë gbɛ bho ‑a kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ma 'dhö, n Dë 'dhö, yi dosɛn.» ");
INSERT INTO dnj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","꞊Dhɛ ꞊ya kë 'dhö, 'ö Zuifö ‑nu ‑wo ‑guö ‑lö; 'wo‑ dho 'kuë‑ kö ‑waan ‑a ‑zuö ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","'Ö Yesu ‑ya pö ‑an ‑dhë: «Kë 'a‑ wo zö ka ziën bhë, a 'wunsë ‑nu ‑kë ꞊va 'ka; 'ö 'a‑ ‑kë 'dhö n Dë ‑bha 'piigbeedhɛ ꞊kwaa'. 'Wun ‑nu 'wo bhë ‑a ‑mlë ‑zë 'ö‑ ‑wun 'gü 'ka‑ 'piö 'ka n zë ‑guö 'ka ꞊nɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","'Ö Zuifö ‑nu ‑wa pö: «Yaa kë ꞊nɛ 'wun ‑së 'ü‑ ‑kë bhë ꞊nɛ 'yi‑ 'piö 'yi ü zë ‑guö 'ka ‑a ‑wun 'gü; 'kɛɛ 'wun yaa 'ü‑ ꞊blɛɛ' ‑na ‑Zlan ‑gɔ bhë ‑a ‑wun ‑mü. 'Ö tɔɔ bhi 'ü mɛ 'bhee‑ 'kpaan 'ka bhë, ‑dhɛ 'kwa yö 'më 'ü ü ‑de ‑kë ‑Zlan 'ka ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Yö ꞊bɛɛn' ‑sü 'ka ka ‑bha tɔng 'sëëdhɛ 'gü ꞊nɛɛ: ‑Zlan ‑ya ‑pö: Ka ‑zlan ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","'Ö kwa gia‑ 'kwa‑ ꞊tɛi' dɔ ꞊nɛ pë mɛ 'kö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü kö ‑a ‑bho mü ‑dhɛ 'yaa 'dhö. Mɛ ‑nu 'ö ‑Zlan ‑yö 'wun ‑blɛɛ ‑an ‑dhë bhë ꞊nɛ 'ö ‑an ‑dhɛ ‑zlan ‑nu. ");
INSERT INTO dnj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma ‑zë, ‑Zlan ‑yö n ‑sü 'ö n bɔ 'kpongtaa. ꞊Ya kë 'dhö kö ‑yö ‑kë ‑kɔklë zlöö 'ö 'ka‑ pö 'wun yaa ꞊blɛɛ'‑ 'a‑ wo ‑Zlan ‑gɔ ‑ɛ, ꞊dhɛ kë ꞊nɛ 'ma‑ pö ‑Zlan Gbö ‑mü n 'ka bhë ee? ");
INSERT INTO dnj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","꞊Ya kë ꞊nɛ 'maa n Dë ‑bha yuö ‑nu kë, kö kö ꞊kun 'ka n ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","'Kɛɛ ꞊ya kë ꞊nɛ a n Dë ‑bha yuö ‑nu ‑kë, 'ö 'kaa n ‑wun ‑dhɛ 'wun gia‑; kö pë ‑nu 'wo bhë ka ‑an ‑wun ‑dhɛ 'wun gia‑ 'püë‑ wo ꞊nɛ ‑wo ‑go ‑Zlan 'piö kö ꞊ya 'go mü 'kaan‑ ‑a ꞊tɛi' dɔ zlöö ꞊nɛ a ‑go n Dë 'gü, 'ö n Dë 'dhö ‑ya ‑sü 'ka n 'gü i.» ");
INSERT INTO dnj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","'Yö 'wo yö ‑a 'slë ꞊mɛɛ' ‑sü ‑bha kö ‑waan ‑a 'kun, 'kɛɛ waa‑ këdhɛ gbɛ yö. ‑Yö ‑dha ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö dho Zuudɛn zlöö ꞊zian' 'zü ‑dëüwo, 'pian mɛ 'ö Zan ‑yö mɛ bɔ yiö ‑a 'ka 'dhiö ꞊zian' bhë ‑a 'ka; ‑dhɛ bhë ꞊nɛ 'ö to ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mɛ ‑nu ‑wo ‑nu ‑a 'piö ꞊va 'ka. Pë 'ö ‑kë ‑an ‑wo 'ka 'ö tɔɔ: «Zan bhë kë‑ wo bhë, yaa ‑dhidhaapë gbɛ kë; 'kɛɛ 'wun ‑nu 'ö‑ ꞊blɛɛ 'saadhö gɔɔn‑ ꞊nɛ ‑a ‑blü 'gü bhë 'wun gia‑ ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","‑Dhɛ bhë mɛ ‑nu ‑wo ‑kë ꞊va 'zü, 'wo Yesu ‑wun ‑dhɛ 'wun gia‑ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gɔɔn‑ do ‑yö ‑kë ‑dhö, 'wo‑ ‑dhɛ Lazaa. ‑Yö ‑kë Betani. 'Yö 'yua ‑ya ‑kë. Waa‑ ö dheglu 'nëdhezë ꞊plɛ 'wo ‑an ‑dhɛ Mali waa‑ Maatö ‑wo ‑kë pö‑ bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mali bhë ꞊nɛ, 'ö 'dhiö bhë 'ö 'yi 'tëë ‑sëëzë sü 'ö‑ ‑lo kwa Dëmɛ ‑gɛn ‑nu ‑bha, 'ö ö ‑bha wun ‑nu sü 'ö‑ ‑ziö ‑a ‑gɛn ‑nu ‑bha. Yö ꞊nɛ 'ö 'kwa 'we ‑na ‑a dheglu Lazaa 'ka bhë. ");
INSERT INTO dnj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","'Yö dheglu 'nëdhezë ꞊plɛ 'wo bhë 'wo mɛ bɔ Yesu ‑dhë ꞊woë' ꞊nɛɛ: «Yi Dëmɛ, ‑bhö nu; 'yua ‑yö ü 'bhamɛ Lazaa kë ‑na!» ");
INSERT INTO dnj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","꞊Dhɛ ‑naɔ bhë ꞊waa‑ bɔ Yesu ‑gɔ 'dhö, 'yö‑ pö ‑an ‑dhë: «'Yua 'ö Lazaa ‑bha bhë, yaa 'dho pë gbɛ kaa. ‑Yö ‑yaa ‑bha 'dhö kö ‑Zlan ‑bha 'tɔbhɔdhe ‑yaan yö ‑dhɛgbɛadhɛ 'gü; 'wun bhë ꞊nɛ 'ö dho kë ‑Zlan Gbö ‑bha 'tɔbhɔdhe ‑bɔ ‑a ‑ta 'ka 'pö.» ");
INSERT INTO dnj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mali waa‑ ö dheglu Maatö 'wo bhë waa‑ Lazaa ‑de gia‑, ‑an ‑dhɔ ‑yö Yesu ‑kë 'dhö, ");
INSERT INTO dnj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","'kɛɛ kë‑ wo 'dhö bhë, ꞊dhɛ 'ö‑ ma ꞊nɛ 'yua ‑yö Lazaa kë ‑na, yaa ꞊luu'‑ yaa 'dho, ‑yö ‑to ‑dhɛ 'ö ‑kë ‑a ‑bha bhë ‑a ‑bha, 'ö ‑dhɛkpaɔyi ꞊plɛ ‑kë mü, ‑yaan ꞊tun 'dho ‑na ‑an 'piö Betani. ");
INSERT INTO dnj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'Yö‑ pö ö ‑bha ꞊guë' ‑nu ‑dhë: «‑Kwa 'yɛ kwa 'zü 'kwa dho Zude ‑sɛ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","'Yö‑ ‑bha ꞊guë' ‑nu ‑wa pö ‑a ‑dhë: «Yi ‑Gɔmɛ, ‑a ‑dhɛ yaa ꞊glɔɔ ꞊kun, Zuifö ‑nu ‑wo ‑kë ‑a 'slë ꞊mɛɛ' ꞊dhia kö ‑waan ü zë ‑guö 'ka, 'ö bhi 'ü bhë 'ü‑ 'piö kö 'kwa 'dho 'ma 'zü a?» ");
INSERT INTO dnj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","'Ö Yesu ‑ya pö ‑an ‑dhë: «'Lɛlɛ 'yaa 'gɔɔ‑ do ö ga ꞊plɛ ‑dhɛkpaɔyi do 'gü a? Mɛ ꞊ya 'ta 'sü ‑dhɛ 'po ‑sü 'gü ‑a ‑gɛn 'yaa zuö bhë kun tɔɔ ‑a 'yan ‑yö ‑dhɛ ‑yö ‑dhɛ 'po ‑sü 'ö 'kpongtaa zö bhë ‑a 'gü a. ");
INSERT INTO dnj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","'Kɛɛ mɛ ꞊ya 'ta 'sü gbeng, ‑a ‑gɛn ‑yö ‑zuö 'ö bhii ‑dhɛ 'yaa 'po ‑sü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","꞊Dhɛ Yesu ꞊ya 'wun ꞊blɛɛ'‑ ‑an ‑dhë 'dhö, 'yö‑ pö 'zü: «Kwa dheglu Lazaa ꞊ya yi zë; 'kɛɛ ‑kwa 'dho kö 'aan‑ 'pa ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","'Yö‑ ‑bha ꞊guë' ‑nu ‑wa pö ‑a ‑dhë: «Yi Dëmɛ, ꞊ya kë ꞊nɛ ꞊ya yi zë kö ‑a 'bhle ꞊ya kë 'waa; ‑a ‑dhɛ ‑dho bo.» ");
INSERT INTO dnj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kë‑ wo 'dhö bhë, ‑a pö 'ö Yesu ‑ya wo Lazaa ꞊ya yi zë bhë, ‑a ‑bha ꞊guë' ‑nu waa‑ ‑gɛn ma. ‑Wo wo ‑zo ‑to yi 'kpaan ꞊ya kë 'kwa‑ zë ‑na ꞊nɛ ‑a ‑dhë, 'kɛɛ kö ga 'ö Lazaa ‑ya wo bhë ꞊nɛ 'ö Yesu ‑yö ‑we ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","꞊Dhɛ ‑kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë 'puu 'ka zlöö: «Lazaa ꞊ya ga. ");
INSERT INTO dnj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","N ꞊zuö' 'glu dhi ‑sü ‑mü kë 'ö kaa‑ wo 'ma bhë ‑a ‑wun 'gü. ꞊Ya kë 'dhö, ka ‑dho n ‑wo ‑dhɛ 'wun gia‑; 'kɛɛ ‑kwa 'dho 'ma.» ");
INSERT INTO dnj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","꞊Dhɛ ꞊ya kë 'dhö, 'ö Toma 'wo‑ 'tɔ kpɔ «‑Flɛan» 'ka bhë 'ö‑ pö ö 'bhamɛ ꞊guë' ‑nu 'wo to bhë ‑an ‑dhë: «‑Kwa 'dho kö kwa ‑de 'pö, kwaa‑ kwa ‑Gɔmɛ ‑nu 'kwaan‑ ga 'pö!» ");
INSERT INTO dnj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","꞊Dhɛ Yesu waa‑ ö ‑bha ꞊guë' ‑nu ꞊wa 'dho ꞊wa ‑lo 'ma, kö ꞊wa Lazaa ‑bin 'saadhö ‑a ‑dhɛkpaɔyi ꞊ya kë ‑yiisië. ");
INSERT INTO dnj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","'Go Betani 'ü 'dho Zeluzalɛmë ‑yö ‑kë ꞊nɛ 'kilong ‑yaaga 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","‑A ‑wun 'gü, Zuifö ‑nu ‑wo ‑nu ꞊va Maatö waa‑ Mali ‑an ꞊plöö kö ‑waan ‑an ꞊zuö' ꞊dhuë'‑ ‑an dheglu 'ö ga bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","꞊Dhɛ 'ö Maatö ‑ya ma ꞊nɛ Yesu ‑yö zian ‑ta nu ꞊dhia, 'ö ꞊luu 'ö dho ‑a ‑gɔ zian‑. Mali ‑zë ‑yö ‑to kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","'Ö Maatö ‑ya pö Yesu ‑dhë: «N Dëmɛ, ü ‑kë zö ‑bezë, n dheglu 'ka 'dho ga. ");
INSERT INTO dnj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","꞊Ɛɛ, 'kɛɛ a‑ ꞊dɔa' ꞊nɛ dɔ ‑de 'kwa‑ wo ꞊nɛ pë 'oo pë kö 'ü‑ ‑dhɛ ‑Zlan ‑gɔ, ‑yö ‑dho ‑a nu ü ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü dheglu ‑yö ‑dho go ga 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","'Ö Maatö ‑ya ‑daa ‑kë ꞊woë' ꞊nɛɛ: «‑Yö n 'yaan 'ka 'püë‑ wo ꞊nɛ gamɛ ‑nu ‑bha ‑go ga 'gü ‑yi 'ka yi ‑kaanta 'ka, ‑yö ‑dho go ga 'gü 'pö.» ");
INSERT INTO dnj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","'Ö Yesu ‑ya pö ‑a ‑dhë: «Ma ꞊nɛ 'a tɔɔ mɛ ‑bho ga 'gü ‑mɛ waa‑ ‑këdhösü ‑nu mɛ ‑dhë ‑mɛ. Mɛ 'ö ꞊ya n ‑wun ‑dhɛ 'wun gia‑, ‑yö ‑dho kë ‑dhö 'kö ‑kë ꞊nɛ ‑yö ‑ga 'dhee; ");
INSERT INTO dnj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","'Ö mɛ 'ö‑ ‑bha ‑tosiadhe kë ‑sü 'gü, 'ö ꞊ya n ‑wun ‑dhɛ 'wun gia‑ 'ö yö 'ka 'dho ga gbɔ. 'Wun bhë, ü‑ ‑dhɛ 'wun gia‑ ‑a?» ");
INSERT INTO dnj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","'Ö‑ ‑daa ‑kë 'ö‑ pö: «꞊Ii‑, n Dëmɛ, a‑ ‑wun ‑dhɛ 'wun gia‑ ꞊nɛ bhi ꞊nɛ 'ü tɔɔ ‑Zlan ‑bha ‑Yamɛ, 'ü ‑Zlan Gbö 'ö 'wo‑ pö ‑yö ‑dho nu 'kpongtaa bhë ‑a 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","꞊Dhɛ Maatö ꞊ya 'wun ꞊blɛɛ'‑ ꞊nɛ ‑kɔ bhë ‑a 'dhö, 'ö ‑ziö 'ö dho 'ö ö dhegludhe Mali ꞊dhɔɔ ‑kë, 'ö‑ pö ‑a ‑dhë 'saan 'gü: «‑Gɔmɛ ꞊ya nu, ‑yö zö; ‑ya ‑pö 'ü nu.» ");
INSERT INTO dnj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","꞊Dhɛ 'ö Mali ꞊ya ‑naɔ bhë ‑a ma, 'yö ‑ziö ‑bla 'ka 'ö dho Yesu 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","꞊Dhɛ kë ‑na 'dhö kö Yesu yaa ‑da plöö ꞊kun. 'Kɛɛ ‑dhɛ do 'ö Maatö ‑ya to ‑a ‑bha bhë 'ö to ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","꞊Dhɛ 'ö Zuifö ‑nu 'wo ‑kë Mali ‑gɔ kɔɔ ‑a ꞊zuö' ꞊dhuë' ꞊dhia bhë ꞊waa‑ yö ꞊nɛ ziö 'ö‑ wo bhë, ‑yö ‑kë ‑bla ‑ta, 'wo ‑ziö ‑a 'piö. ‑Yö ‑kë ‑an ‑zo 'piö ꞊nɛ ‑yö ‑kë 'dho ꞊dhia blɔɔn‑ ꞊taa kö ‑yaan 'gbo bɔ. ");
INSERT INTO dnj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","꞊Dhɛ 'ö Mali ꞊ya ‑lo ‑dhɛ 'ö Yesu ‑yö ‑kë ‑a ‑bha bhë ‑a ‑bha, 'ö‑ 'yan ‑yö ‑da ‑a ‑ta, 'yö ö ‑de ‑zuö sia‑ ‑a ꞊gɛɛndhö 'ö‑ pö: «N Dëmɛ, ü ‑kë zö ‑bezë, n dheglu 'ka 'dho ga.» ");
INSERT INTO dnj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","'Yö Yesu ‑ya yö ꞊nɛ ‑yö ‑kë 'gbo bɔ ꞊dhia, 'ö Zuifö ‑nu 'ö wo ‑nu 'wo nu bhë wo ‑de 'pö, ‑wo ‑kë 'gbo bɔ ꞊dhia; 'ö ‑wɛɛ ‑yö ‑lo ‑a ‑ta, 'ö‑ ꞊zuö' ‑yö ‑da 'yena 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","꞊Dhɛ ‑kë 'dhö, 'yö ‑an ꞊dhɛɛ' kpɔ, 'ö‑ pö: «Ka‑ ‑bin mɛɛ?» 'Yö 'wo‑ pö ‑a ‑dhë: «Yi Dëmɛ, ‑ko 'dho 'yi‑ ‑zɔn ü ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","'Ö Yesu ‑yö 'gbo bɔ. ");
INSERT INTO dnj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","'Yö Zuifö ‑nu ‑wo yö ‑a pö ‑sü 'gü: «'Oo nenu, ‑a ‑dhɔ ‑ya ‑kë ꞊duö ꞊dhɛɛ!» ");
INSERT INTO dnj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","'Kɛɛ mɛ 'bhaa ‑nu ‑wo ‑kë ‑an ziën mü 'pö, 'wo ‑kë ‑a pö ꞊dhia: «Yö 'ö 'yënngtiimɛ 'yan ‑po ꞊nɛ, ka‑ ‑pö ‑a ‑kɔ 'pö yaa 'dhö ‑mɔa kö ꞊ya kë kö Lazaa ‑yö 'kun ga ‑sü 'ka 'pö a?» ");
INSERT INTO dnj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","'Yö ‑wɛɛ ‑yö ‑lo Yesu ‑ta 'zü; ꞊dhɛ ‑kë 'dhö kö ‑yö 'dho ‑na blɔɔn‑ ꞊taa. ‑Yö ‑kë ‑guö ‑du 'ka 'ö 'wo ‑guö 'fa yö ‑a 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","꞊Dhɛ ꞊wa 'dho ꞊wa ‑lo 'ma 'ö Yesu ‑ya pö: «‑Guö 'fa ꞊nɛ, ‑kaa bho ‑a 'dhiö!» 'Ö Lazaa 'ö ga bhë ‑a dheglu Maatö ‑ya pö Yesu ‑dhë: «N Dëmɛ, ‑dhɛ 'wo‑ ‑bin bhë ‑a ‑dhɛkpaɔyi ꞊ya kë ‑yiisië; ‑a 'tëë ‑dhö kë dɔ ‑sü 'gü zlöö ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","'Ö Yesu ‑ya pö ‑a ‑dhë: «N 'ka‑ pö ü ‑dhë, ꞊ya kë ꞊nɛ ‑zoyösü ꞊ya kë ü ‑gɔ, ü ‑dho ‑Zlan ‑bha 'piigbeedhɛ yö ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","꞊Dhɛ 'ö ꞊wa ‑guö 'fa bhë ‑a bho mü, 'ö Yesu ‑yö ‑dhɛ ‑ga dhang‑ 'gü, 'ö‑ pö: «N Dë, a ü ꞊sɛɛ‑ ‑pö 'ö tɔɔ ü ü 'to ‑kë n ‑wo ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A‑ ꞊tɛi' ‑dɔ ꞊nɛ ü ü 'to ‑kë n ‑wo ‑bha ‑kplawo; 'kɛɛ a‑ ‑pö 'dhö mɛ ‑nu 'wo ꞊nië n ‑zü 'to ꞊nɛ ‑an ‑wun 'gü, ‑yö kë 'dhö kö ‑waan ‑a ‑wun ‑dhɛ 'wun gia‑ ꞊nɛ bhi ꞊nɛ 'ü n bɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","꞊Dhɛ ꞊yaa‑ pö 'dhö, 'yö ‑gbla 'gbee‑ 'ka 'ö‑ pö: «Lazaa, yö plaan!» ");
INSERT INTO dnj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","꞊Dhɛ 'wo‑ ‑ga kö mɛ 'ö ga bhë ‑yö yö ‑na plaan, 'kɛɛ sɔ 'pɛn ‑nu 'wo‑ ꞊glöö bho ‑a 'ka bhë ‑wo ‑kë ‑a ‑kɔ ‑nu, ‑a ‑gɛn ‑nu, ‑a wöödhɛ ‑nu ‑an ‑bha. 'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Kaa 'po 'ka ka ꞊kwaa'‑ ‑zü 'kwa ziö!» ");
INSERT INTO dnj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mɛ ‑nu 'wo nu Mali 'yënng ‑bha bhë, Zuifö ‑nu 'wo ‑kë ‑an ziën bhë, ꞊dhɛ 'ö pë ‑nu 'ö Yesu ‑ya ‑kë bhë, ‑an 'yan ꞊ya ‑da ‑a 'gü, ‑an ꞊plëëzë ‑wo Yesu ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","'Kɛɛ mɛ 'bhaa ‑nu ‑wo ‑kë ‑an kpö 'gü 'wo ‑ziö 'wo dho Falizi ‑mɛ ‑nu 'piö, 'ö pë ‑nu 'ö Yesu ‑ya ‑kë 'töüdhö bhë 'wo‑ ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","'Wun bhë ‑a ‑wun 'gü 'ö Falizi ‑mɛ ‑nu waa‑ slabhomɛ ‑gɔmɛ ‑nu 'wo ‑ya 'kuë‑ ‑kë. Wo ꞊nɛ 'ö 'wun ꞊vava ‑nu ꞊wa kë ‑dhö 'ö‑ ‑wun dho yö plaan, 'ö ꞊ya kë 'wo‑ ‑ya 'kuë‑ ‑kë. 'Yö 'wo‑ pö: «Kwa ‑dhoë kë ꞊dhë 'ö gɔɔn‑ ꞊nɛ 'ö ‑dhidhaapë ꞊plëëzë ‑nu kë ‑na ꞊nɛɛ? ");
INSERT INTO dnj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","꞊Ya kë ꞊nɛ 'kwa kwa ꞊kwaa'‑ ‑a ‑zü ꞊nɛ ‑kɔ bhë ‑a 'dhö, mɛ ‑nu 'saadhö ‑wo ‑dho ‑a ‑wun ‑dhɛ 'wun gia‑; 'ö ꞊ya kë zlöö 'ö 'sɛkɔɔnmɛ ‑nu ('ö 'kwa ‑an ‑kɔ ꞊löö 'ö) 'wo Wlɔmë ‑sɛ 'ka bhë, 'wo ‑dho kwa ‑bha ‑Zlan ‑gba ‑a 'gü ‑kɔ ꞊nɛ ‑a wü 'ö 'wo kwa ‑bha 'sɛ wü 'dhɛ!» ");
INSERT INTO dnj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","‑An mɛ do ‑yö ‑kë mü 'wo‑ ‑dhɛ Kaifö. ‑Kwɛ bhë ‑a 'ka, yö ꞊nɛ 'ö ‑kë slabhomɛ ꞊va 'ka. 'Yö‑ pö ‑an ‑dhë: «'Kaa ‑dhɛ yö 'wun bhë ‑a 'gü bhë yö ‑mü! ");
INSERT INTO dnj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","'Kaa‑ ꞊tɛi' dɔ ꞊nɛ ‑yö 'gianzë kö mɛ do ‑yö ga 'sɛgümɛ ‑nu ‑wun 'gü, ‑yö ꞊zië' kwaa‑ 'sɛgümɛ ‑nu ‑todhösü 'gü ꞊siö' ‑sü ‑ta ‑a?» ");
INSERT INTO dnj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","'Wun bhë ‑ya ‑blɛɛ 'dhö ö tii ‑bha 'kpaan 'ka; 'kɛɛ kë‑ wo 'dhö bhë, ‑yö ‑kë slabhomɛ ꞊va 'ka ‑kwɛ bhë ‑a 'ka, 'ö‑ ‑wun 'gü, 'ö ‑kë ‑Zlan ‑wo 'dhiö ‑lo ꞊dhia ꞊nɛ Yesu ‑yö ‑dho ga Zuifö ‑nu ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","'Kɛɛ kë‑ wo 'dhö bhë yaa kë ꞊nɛ mɛ ‑nu 'wo 'sɛgɔ ꞊nɛ 'wo‑ 'gü ‑an ‑wun 'sloo ‑mü; ‑yö ‑Zlan ‑bha 'në ‑nu 'wo ‑pɛn ‑sü 'ka ‑dhɛ 'saadhö ‑bha ‑an ‑dho 'kuë‑ ‑sü 'ka bun do 'gü bhë ‑an ‑wun ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","'Kan yi bhë ‑a ‑bha zlöö, Zuifö ‑nu ‑wo ‑kë ‑a këdhɛ ꞊mɛɛ' ꞊dhia zlöö kö ‑waan Yesu zë. ");
INSERT INTO dnj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","‑A ‑wun 'gü ꞊nɛ 'ö Yesu ‑yö ‑kan zlöö ꞊ziö' 'ziö ‑sü ‑bha mɛ gbung ‑nu 'gü Zuifö ‑nu ziën. 'Yö ꞊dhɛ ꞊ya kë 'dhö, 'yö ꞊luu 'yö dho pödhɛ 'wo‑ ‑dhɛ Eflaimë 'ö 'yënngtaadhɛ 'sɔɔ bhë ‑a 'gü. ‑Dhɛ bhë ꞊nɛ 'ö waa‑ ö ‑bha ꞊guë' ‑nu 'wo to ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Paakö 'wlaan‑ kë ‑yi bhë, ꞊dhɛ ꞊ya yö ꞊klöö', mɛ ‑nu ‑wo ‑dho ꞊va 'ka Zeluzalɛmë kö ‑waan wo ‑de kë 'slööslö. ");
INSERT INTO dnj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","‑Wo ‑kë Yesu ꞊mɛɛ' ꞊dhia ‑dhɛ bhë ‑a 'gü. 'Yö ꞊dhɛ ꞊wa ‑da ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'wo wo 'ko ‑nu ꞊dhɛɛ' 'kpɔ ꞊woë' ꞊nɛɛ: «‑Yö ka ‑zo 'piö ꞊nɛ ‑yö ‑dho nu 'wlaan‑ 'ö ꞊nɛ ‑a ‑ta ‑a?» ");
INSERT INTO dnj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","'Töng bhë ‑a 'ka, slabhomɛ ‑gɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu ‑wa ‑pö mɛ ‑nu ‑dhë ꞊nɛ mɛ ꞊ya kë ‑dhö kö ‑dhɛ Yesu 'dhoë‑ ‑bha ‑ya ‑dhɛ dɔ, kö ꞊ya kë kö ‑wa 'kun. ");
INSERT INTO dnj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","꞊Dhɛ 'ö Paakö 'wlaan‑ kë ‑yi ꞊ya 'to ꞊nɛ pë 'slado 'dhö, Yesu ‑yö ‑dho Betani ‑pö 'ö Lazaa bho ga 'gü ‑a ‑bha bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","'Yö 'wo pë ‑kpa ‑a ‑dhë 'ö Maatö ‑yö nuë ‑a ꞊dhia. Mɛ ‑nu 'wo ‑kë Yesu 'piö pë ‑bhö ꞊dhia mü bhë, Lazaa ‑yö ‑kë ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","(‑Wo ‑kë pë ‑bhö ꞊dhia) 'ö Mali ‑yö pë 'yi 'tëë ‑sëëzë ꞊sɔnng' 'gbeezë 'wo‑ ‑kë 'lüdhɛ 'wo‑ ‑dhɛ 'naa‑ ‑a 'ka 'ö dho ‑mɔ litrë 'gbu ‑bha ‑a sü 'ö‑ ‑lo Yesu ‑gɛn ‑nu ‑ta. 'Yö ꞊kloo, 'yö ö ‑bha wun sü, 'yö‑ ꞊taa ‑a ‑bha. 'Kɔ bhë ‑yö ‑pa pë 'yi bhë ‑a 'tëë 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yesu ‑bha ꞊guë' ‑nu bhë ‑a mɛ do ‑yö ‑kë mü, 'wo‑ ‑dhɛ Zuda Ikaliɔtö. Yö ꞊nɛ 'ö ꞊dhɛ 'kwa yö mü, 'ö dho Yesu 'dhɔɔ dɔ. 'Yö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«꞊Öööö', pë 'yi 'tëë ‑sëëzë ꞊nɛ ꞊yö ‑së ‑be kö ‑wa 'dhɔɔ dɔ dönie 'wëüga bhɛ 'ö dho ‑mɔ ꞊këng' ‑yaaga ‑bha ‑a ‑bha kö ‑a 'wëü‑ bhë ‑wa ‑glu 'fɛɛmɛ ‑nu 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kë‑ wo 'dhö bhë yaa kë ꞊nɛ 'wun bhë ‑ya ‑blɛɛ ö ‑wo 'kpɔ ‑sü 'ka 'fɛɛmɛ ‑nu ‑wun 'gü yö kun! ‑Ya ‑blɛɛ 'dhö ö ‑bha ‑kë ꞊kwaanmɛ 'ka ‑sü ‑wun 'gü. 'Ö tɔɔ 'wëü‑ ‑nu 'wo ‑kë ‑an ‑gɔ bhë, yö ꞊nɛ 'ö ‑kë ‑a ꞊waannumɛ 'ka; 'ö ꞊ya kë 'dhö 'ö ö ‑kɔ ‑da ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","'Yö Yesu ‑ya pö ‑a ‑dhë: «Ü ꞊kwaa' ‑a ‑zü! Ü ꞊kwaa' ‑a ‑zü kö pë mɛ 'ö ‑dhi ‑a ‑dhë ‑ya ꞊waannu n ‑ma 'ka yi 'ö 'wo dho n ꞊glöö bhoë bhë ‑a ‑gɔ 'sa! ");
INSERT INTO dnj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","'Fɛɛmɛ ‑nu 'ka ‑an ‑ga ‑na bhë, ‑wo ka 'piö yi 'saadhö 'ka; 'kɛɛ ma ‑zë, n 'ka 'dho to ka 'piö zö ‑kplawo.» ");
INSERT INTO dnj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Zuifö ‑nu gbung ꞊va 'wo ‑kë mü bhë, ‑wa ‑ma ꞊nɛ Yesu ꞊ya nu Betani. 'Yö 'wo dho 'ma. 'Kɛɛ yaa kë ꞊nɛ Yesu do 'sloo ꞊nɛ 'wo‑ ‑bha 'dho wo bhë; Lazaa 'ö Yesu ‑ya bho ga 'gü bhë 'wo dho kö ‑waan wo 'yan dɔ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","(꞊Dhɛ ꞊wa 'dho ꞊wa wo 'yan dɔ ‑a ‑bha 'dhö,) 'ö slabhomɛ ‑nu ‑gɔmɛ ‑nu ‑wa ‑yö 'ko 'dhiö ‑kë ꞊nɛ ‑wo ‑dho Lazaa zë 'pö, ");
INSERT INTO dnj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","'ö tɔɔ ‑a ‑wun 'gü Zuifö ‑nu ‑wo ‑kë ꞊va 'ö ꞊ya kë 'wo Yesu ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","꞊Dhɛ pë ‑nu bhë ꞊wa kë 'dhö, 'ö‑ ‑ta ‑dhɛ ꞊ya 'po, 'ö mɛ gbung ‑nu 'wo nu Paakö ‑ta bhë 'wo‑ ma 'zü ꞊nɛ Yesu ‑yö ‑dho nu Zeluzalɛmë. ");
INSERT INTO dnj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","'Yö 'wo ꞊glaa‑ ‑paa ‑nu bho, 'wo dho ‑a 'ka ‑a ‑gɔ zian‑. 'Wo yö 'gɛi kë ‑sü 'gü ‑a pö ‑sü 'ka ꞊nɛɛ: «Kwaa‑ 'yoo ‑mü! Kwaa‑ 'yoo ‑mü! ‑Zlan 'tɔ‑ kë ꞊va! Mɛ 'ö nu Dëmɛ 'tɔ 'gü bhë, ‑Zlan ‑yö 'dhuë‑ 'kpɔ ‑a ‑bha! Izlaɛlö ‑mɛ ‑nu ‑bha ‑gludë bhë, ‑Zlan ‑yö 'dhuë‑ 'kpɔ ‑a ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu 'yan ‑yö ‑kpën ꞊soofang 'në ‑gbɔng do ‑bha; 'yö ‑ya ‑a ꞊taa ꞊nɛ ‑kɔ 'ö pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö‑ ꞊blɛɛ ‑a 'ka bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‑Yö ꞊bɛɛn' ‑sü 'ka ꞊nɛɛ: Siɔn 'gü ‑mɛ ‑nu, kö ꞊kun 'ö 'suö ‑yö ka ‑kë! ‑Ka ‑dhɛ ‑ga 'dhɛ, ka ‑bha ‑gludë ‑yö nu ‑na, ‑yö ‑ya ‑sü 'ka ꞊soofang 'në ‑gbɔng ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","'Wun ‑nu 'wo bhë 'saadhö, ‑wo ‑kë 'dhö 'kɛɛ ‑a ‑bha ꞊guë' ‑nu waa ‑dhɛ gbɛ yö ‑an 'gü. 'Kɛɛ ꞊dhɛ 'ö ‑Zlan ꞊ya 'tɔbhɔdhe ‑nu Yesu ‑dhë, 'ö ‑an ‑zo ‑yö ‑büö pë 'ö ‑kë ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü bhë ‑a 'ka, kö ‑a 'dhiö ꞊ya ‑mɔ 'kuë. ");
INSERT INTO dnj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mɛ ‑nu 'ö 'wo ‑kë Yesu 'piö yi 'ö Yesu ‑yö Lazaa ꞊dhɔɔ ꞊kaa' blɔɔn‑ ꞊taa kö ‑yö yö plaan 'ö ‑kë Lazaa ‑bho ga 'gü ‑sü 'ka bhë, pë ‑nu 'wo ‑kë bhë ‑wo ‑kë ‑an ꞊blɛɛ' ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","'Yö‑ ‑wun 'gü 'ö mɛ ‑nu ‑wo nu ‑a ‑gɔ zian‑ ꞊va 'ka, 'ö bhii kö ꞊waa‑ ma ꞊nɛ yö ꞊nɛ 'ö ‑dhidhaapë bhë 'ö‑ ‑kë. ");
INSERT INTO dnj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","'Yö Falizi ‑mɛ ‑nu ‑wo yö ‑a pö ‑sü 'gü wo 'ko ‑nu ‑dhë: «‑Ka ‑dhɛ ‑ga bhë 'dhɛ, ka ‑kɔ gbɛ yaa ‑mɔa ‑bha 'ö bhii mɛ 'saadhö ‑wo ziö ‑na ‑a 'piö!» ");
INSERT INTO dnj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Glɛkö ‑mɛ ‑nu kpö 'bhle 'dɛdɛ 'ö waa kë Zuifö 'ka ‑wo ‑kpa mɛ ‑nu 'wo ‑nu Zeluzalɛmë 'wlaan‑ 'töng 'ka bhë ‑an ‑bha, 'ö 'wo nu kö ‑waan ‑Zlan gba 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","'Yö ꞊dhɛ 'wun ‑nu bhë ꞊wa kë 'dhö, 'wo ꞊yɔɔn gɔɔn‑ do 'ö go Betesaida, Galile ‑sɛ 'gü, 'wo‑ ‑dhɛ Filipö bhë ‑a ‑bha, 'wo‑ pö ‑a ‑dhë: «N Dë, yi‑ 'piö kö 'yi yi 'yan dɔ Yesu ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","'Yö Filipö ‑yö dho 'yö‑ ꞊blɛɛ Andre ‑dhë, 'ö mɛ ꞊plɛ 'wo bhë 'wo kpa wo 'kuë‑ 'wo dho 'wo‑ ꞊blɛɛ Yesu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","'Ö Yesu ‑ya pö ‑an ‑dhë: «'Töng 'ö ‑ya kö Mɛgbö ‑yaan 'tɔbhɔdhe yö ‑a 'ka bhë ꞊ya ‑lo. ");
INSERT INTO dnj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: 'Blee‑ ga 'ö 'ka‑ ‑ga ‑na bhë ‑yö ‑mɔa ‑yö 'to do 'ka ꞊nɛ ‑kɔ 'ö 'ka‑ suö ‑a 'dhö; 'kɛɛ kö yaa 'pa 'sɛ 'ka, 'iin kö yaa ga. 'Kɛɛ kë‑ wo 'dhö bhë ꞊ya ga, ‑yö ‑dho ö ga 'bhaa ‑nu kë ꞊va 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mɛ 'ö‑ ‑dhɔ ‑kë ‑tosiadhe 'ö 'kpongtaa zö ‑a 'ka, ‑yö ‑dho ꞊siö'‑ ‑a ‑gɔ; 'kɛɛ mɛ 'ö‑ ‑bha ‑tosiadhe 'ö 'kpongtaa zö, 'ö 'yaa‑ ‑dhë pë gbɛ 'ka bhë, ‑yö ‑dho ‑a yö ‑këdhösü 'ö‑ 'yaa yën bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mɛ ꞊ya kë ‑dhö, 'ö‑ 'piö kö 'ö yuö kë n ‑dhë, kö ‑yö 'to n 'piö. ‑Kɔ bhë ꞊nɛ 'ö ‑dhɛ 'a dho dho ‑a ‑bha bhë, 'ö yö ‑de 'pö 'ö dho kë ‑a ‑bha n 'piö 'pö. Mɛ 'ö yuö kë ‑na n ‑dhë bhë, n Dë ‑ya ꞊bhlë ‑ya.» ");
INSERT INTO dnj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","'Yö‑ pö ‑an ‑dhë 'zü: «'Kɛɛ dɔ 'a‑ wo ꞊nɛ, n ꞊zuö' ꞊ya ꞊kaan' 'kuë. ꞊Ɛɛ, 'ö ꞊ya kë 'dhö, ‑a pö 'pö 'a dhoë‑ wo: N Dë, 'wun 'gbee‑ 'ö nu ‑na ꞊nɛ, ‑bhö n dha ‑a ‑gɔ 'pö bhë ee? 'Kɛɛ kö pë 'a nu ‑a ‑wun 'gü 'ö bhë 'sa! A ‑nu kö 'wun 'gbee‑ 'ö bhë 'aan‑ bɔ ‑a 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","'Yö‑ pö: «N Dë, ‑bhöë kë kö ü 'tɔ ‑yö bhɔ!» 'Yö ‑wo do ‑yö we dhang‑ 'gü 'ö‑ pö: «'Ma 'tɔbhɔdhe nu ‑a ‑dhë 'saadhö, 'kɛɛ a ꞊tun ‑a nu ‑a ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mɛ gbung 'wo ‑kë mü bhë ‑wo bhë ‑wa ‑ma; 'wo‑ pö: «Dha 'we ‑wo ‑mü 'dhɛ!» Mɛ 'bhaa ‑nu ‑wo ‑kë ‑a pö ꞊dhia: «‑Zlan ‑bha bɔmɛ do ꞊nɛ 'ö 'wun ꞊blɛɛ ‑a ‑dhë bhë!» ");
INSERT INTO dnj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Wo bhë yaa 'we n ‑dhë; ‑yö ‑we ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","'Töng 'ö ‑ya kö za ‑yaan 'kan 'kpongtaadhɛ ‑bha bhë ꞊ya ‑lo. Mɛ 'ö ‑kë ka ‑gɔ ꞊taa 'kpongtaa zö bhë, 'dho 'ö ‑Zlan 'dhoë‑ kë bhë. ");
INSERT INTO dnj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","'Kɛɛ ma ‑zë, ꞊ya kë ꞊nɛ n Dë ꞊ya n ꞊luu'‑, 'ma 'go 'kpongtaa zö, a ‑dho mɛ 'plɛ gan n ꞊bhaa.» ");
INSERT INTO dnj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","'Wun bhë ‑a ꞊blɛɛ' 'ö‑ wo 'dhö bhë ‑yö ‑kë ö ‑bha ga ‑kɔ ‑wun ꞊blɛɛ' ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","'Yö mɛ gbung 'wo ‑kë mü bhë, 'wo‑ pö ‑a ‑dhë: «Pë 'yi‑ ꞊daan yi ‑gɔ tɔng 'sëëdhɛ 'gü ‑ya ‑pö ꞊nɛɛ ‑Zlan ‑bha ‑Yamɛ 'ö dho nu bhë, ‑yö ‑dho kë ‑dhö ꞊toëpö 'ka. ꞊Ya kë 'dhö, ‑dhɛ ‑mlë 'kwa yö ‑a ‑bha 'ü‑ pö Mɛgbö ‑yö ‑dho ꞊luu' ꞊ii? Dö ‑de 'pö tɔɔ Mɛgbö bhë poo ꞊ee?» ");
INSERT INTO dnj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","'Ö Yesu ‑ya pö ‑an ‑dhë: «‑Dhɛpuudhɛ ‑yö ꞊tun ka ziën zö; 'kɛɛ yaa 'dho to zö ꞊glɔɔsü gbɔ. ‑Ka ꞊luu' 'ka 'ta, ꞊dhɛ 'ö ‑dhɛ 'dhö ꞊tun 'puu ‑a 'ka, ꞊kun ‑kë 'ö ‑dhɛtiidhɛ dhö ‑lo ka tii ꞊ii. 'Ö tɔɔ mɛ 'ö 'ta ‑na ‑dhɛtiidhɛ 'gü, 'yaa ö 'dhodhɛ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","꞊Dhɛ 'ö ‑dhɛpuudhɛ 'ö ꞊tun ka ‑gɔ ꞊nɛ, ‑ka ka ‑kɔ 'kpɔ ‑a ‑gɔ kö 'kaan‑ kë mɛ ‑nu 'wo ‑dhɛpuudhɛ 'gü ‑an 'ka ɛ.» ꞊Dhɛ 'ö Yesu ꞊ya 'wun ꞊blɛɛ'‑ ꞊nɛ ‑kɔ bhë ‑a 'dhö, 'yö ‑ziö 'ö dho ‑dhɛ do 'bhaa 'gü ‑an 'ka ꞊gbiin, 'ö ‑bin. ");
INSERT INTO dnj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu ‑yö ‑dhidhaapë ꞊plëëzë ‑kë ‑an wö 'dhiö mü, 'kɛɛ waa Yesu ‑wun ‑dhɛ 'wun gia‑; ");
INSERT INTO dnj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","'kɛɛ pë ‑nu bhë ‑wo ‑kë 'dhö ꞊nɛ ‑kɔ 'ö‑ pë 'ö ‑Zlan ‑wodhiölomɛ Ezai ‑ya ꞊blɛɛ 'ö ꞊bɛɛn' ‑sü 'ka ‑a ‑wun 'gü ‑Zlan ‑bha 'sëëdhɛ 'gü bhë, 'ö‑ 'ka bhë ‑a 'dhö. ‑Ya ‑pö: Dëmɛ, dö 'ö yi ‑wo ‑nu ‑dhɛ 'wun gia‑ ‑ɛɛ? Dö ‑nu 'pö Dëmɛ ‑yö ö ‑bha ‑kɔ ‑mɔ 'wuën‑ ‑sü ‑zɔn ‑an ‑dhë ‑ɛɛ? ");
INSERT INTO dnj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yesu ‑wun 'ö waa‑ ‑dhɛ 'wun gia‑ bhë ‑yö ‑kë 'dhö 'zü ꞊nɛ ‑kɔ 'ö Ezai ‑ya pöë bhë ‑a 'dhö ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‑Zlan ꞊ya ‑an 'yënng trö, ꞊ya ‑an ‑bha 'wundɔdhe 'dhi ta, ‑yö kë 'dhö kö ꞊kun 'ö ‑an 'yan ‑yö ‑dhɛ yö 'iin 'wo 'wun ‑nu 'gü dɔ, kö ‑waan 'kun ‑dhië ‑an 'piö ‑sü 'ka, kö ‑yaan ‑an ‑dhɛ bo. ");
INSERT INTO dnj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","'Wun 'ö Ezai ‑ya ꞊blɛɛ 'dhö bhë 'ö tɔɔ kö ꞊ya Yesu ‑bha 'tɔbhɔdhe yö; 'ö‑ ‑wun 'gü 'ö 'wun ‑gban ‑a ‑bha 'ö‑ ꞊blɛɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","'Kɛɛ kë‑ wo 'dhö bhë, Zuifö ‑gɔmɛ ‑nu ziën, mɛ ‑nu ‑wo ‑kë ꞊va 'ö 'wo Yesu ‑wun ‑dhɛ 'wun gia‑. 'Kɛɛ ꞊dhɛ ‑kë ꞊nɛ ‑wo ‑suö Falizi ‑mɛ ‑nu ‑dhë, ‑wo wo ‑de ‑kë 'slë 'ka, kö ꞊kun 'wo dho wo kë ‑waan 'go ‑an ‑bha ‑bhɔkuëkɔ ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pë mɛ 'ö 'wo to ‑a 'piö bhë 'ö tɔɔ 'wun 'ö mɛ ‑zo 'kun ‑wun 'ka 'ö ꞊zië' ‑a mɛ 'ö ‑Zlan ‑zo kun ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","'Yö ꞊dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑yö 'wun ꞊blɛɛ 'gbee‑ 'ka ꞊woë' ꞊nɛɛ: «Mɛ 'ö ꞊ya n ‑wun ‑dhɛ 'wun gia‑ kö ma do 'sloo kun 'ö n ‑wun ‑dhɛ 'wun gia‑ bhë; 'kɛɛ mɛ 'ö n bɔ bhë ꞊nɛ 'ö‑ ‑wun ‑dhɛ 'wun gia‑ 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","'Ö mɛ 'ö ꞊ya n yö, kö mɛ 'ö n bɔ bhë ꞊yaa‑ yö ꞊nɛ bhë 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma 'a ‑dhɛpuudhɛ 'ka, a ‑nu 'kpongtaa, ‑yö kë 'dhö kö mɛ 'ö ꞊ya n ‑wun ‑dhɛ 'wun gia‑ ‑yaan kë ‑dhɛpuudhɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mɛ 'ö ꞊ya n ‑wo ‑nu ma 'ö yaa 'wun ma ‑a ‑ta, kö ma kun 'a dho za ‑lo ‑a tuö; ‑a ‑de n 'ka nu kö 'aan‑ za ‑lo 'kpongtaamɛ ‑nu tuö, 'kɛɛ a ‑nu kö 'aan‑ ‑an dha ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mɛ 'ö ꞊ya n 'sü ‑kɔ 'bhaa 'gü, 'ö ꞊ya n ‑wo ‑nu bho yunng kö pë 'ö dho za ‑lo ‑a tuö 'ö tɔɔ mɛ ꞊daan' ‑wo ‑nu 'wo go n dhiö bhë. Yö ꞊nɛ 'ö dho za ‑lo ‑a tuö yi ‑kaanta 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","'Ö tɔɔ n ‑wo ‑nu 'wo bhë waa 'go n ‑de 'gü, 'kɛɛ ‑wo ‑go n Dë 'ö n bɔ bhë ‑a kwɛɛ. Yö ꞊nɛ 'ö pë ‑nu 'a dho ‑a ꞊blɛɛ' 'ö ‑an ‑ya n 'dhii. ");
INSERT INTO dnj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kë‑ wo 'dhö bhë, ma ‑de gia‑ a‑ ꞊dɔa' ꞊nɛ pë ‑nu 'ö‑ pö n ‑dhë 'a ‑an kë bhë ꞊nɛ 'wo ꞊toëpö ‑këdhösü nu mɛ ‑nu ‑dhë. Kö ‑yö kë ka 'yaan ꞊nɛ pë ‑nu 'wo go ‑na n 'dhii bhë, n Dë (‑Zlan) ꞊nɛ 'ö ‑an dɔ n 'dhii.» ");
INSERT INTO dnj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","꞊Dhɛ 'kwa dɔ 'töng bhë ‑a 'ka, kö Paakö 'wlaan‑ ꞊ya 'to ꞊nɛ ꞊dhia 'dhö, kö Yesu ꞊yaa‑ ꞊tɛi' dɔ ꞊nɛ ö 'go ‑sü ‑mü 'kpongtaa zö ‑yaan 'dho ö Dë 'piö. ‑A ‑bha mɛ 'wo 'kpongtaa zö bhë ‑an ‑dhɔ ‑yö ‑kë ‑a ‑bha ‑kplawo; 'ö‑ ‑de ‑yö ‑kë ‑a ‑gɔ 'dhö 'ö ꞊toë' 'dhö 'ö yöë ‑a ‑bha ‑tosiadhe 'dhiötoyi ‑bha zö. ");
INSERT INTO dnj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑kë 'yinia 'piö ‑pë ‑bhö ꞊dhia, 'kɛɛ kö ‑a ‑bha ꞊guë' ‑nu 'wo bhë ‑a mɛ 'wo‑ ‑dhɛ Zuda 'ö ‑kë Simɔ Ikaliɔtö gbö 'ka bhë, kö dü ꞊yaa‑ 'sü ö ‑bha 'ka kö ‑yaan Yesu 'dhɔɔ dɔ ö yaagümɛ ‑nu ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","'Kɛɛ kë‑ wo 'dhö bhë, Yesu ‑de gia‑ ‑ya ꞊tɛi' dɔ ꞊nɛ ö ‑go ‑Zlan 'piö; ꞊ya 'go mü, ‑yö ‑dho yɛ ö 'zü 'ö dho ‑Zlan 'piö, 'ö bhii ‑ya dɔ ꞊nɛ ‑Zlan ‑ya pë 'plɛ ‑lo ö kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","꞊Dhɛ ꞊ya kë 'dhö, 'ö ꞊luu 'ö ö ‑bha sɔ ‑ta ‑sɔ bho ö ‑bha, 'ö 'zlu ‑sɔ do sü ö‑ ‑klu ö vɛɛdhö. ");
INSERT INTO dnj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","'Yö 'yi sü 'ö‑ ‑lo 'tia‑ 'gbɛa do 'gü, 'ö yö ö ‑bha ꞊guë' ‑nu ‑gɛn 'zlu ‑sü ‑bha. 'Ö‑ mɛ 'ö ꞊ya yën ‑a ‑gɛn 'zlu ‑sü ‑bha, 'ö 'zlu ‑sɔ 'ö‑ vɛɛdhö ꞊sia bhë, 'ö‑ sü 'ö‑ ‑ziö ‑a ‑gɛn ‑nu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","'Ö ꞊dhɛ ꞊ya yö Simɔ Piɛɛ ‑bha, 'ö Simɔ ‑ya pö ‑a ‑dhë: «N Dëmɛ, bhi ꞊nɛ 'ü dho n ‑gɛn ‑nu zlu ꞊a, ‑abi'!» ");
INSERT INTO dnj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","'Ö Yesu ‑ya pö ‑a ‑dhë: «Pë 'a‑ ‑kë ‑a ‑dhë 'dhö bhë, 'bhaa‑ ‑gɛn dɔ, 'kɛɛ 'dhiö ꞊zian' ü ‑dho ‑a ‑gɛn dɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","'Ö Piɛɛ ‑ya pö ‑a ‑dhë: «N 'ka 'we ‑a ‑bha, ü 'ka 'dho n ‑gɛn zlu 'gbɛɛdhö!» 'Yö Yesu ‑ya pö ‑a ‑dhë: «꞊Ya kë ꞊nɛ n 'ka ü ‑gɛn ‑nu 'zlu, ü 'ka 'dho pë gbɛ yö n kwɛɛ gbɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","'Ö Piɛɛ ‑ya pö: «꞊Ya kë ꞊nɛ ‑yö 'dhö 'wɛa‑, kö ꞊kun ‑kë 'ü n ‑gɛn ‑nu 'sloo zlu, ‑bhö n ‑kɔ ‑nu waa‑ n ‑gɔ ‑an 'plɛ 'zlu ꞊klöödhö ‑wa!» ");
INSERT INTO dnj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","'Ö Yesu ‑ya pö ‑a ‑dhë: «Mɛ 'ö ꞊ya ö zlu ‑be 'saadhö, 'yaa‑ ‑bha kö ‑yö ö ‑de 'böü 'zlu 'zü; bhii ꞊ya kë ꞊nɛ ꞊ya ö ‑gɛn 'zlu, kö ꞊ya bhɔ 'papadhö ꞊nɛ bhë. Dɔ 'ka‑ wo bhë, 'ka bhɔ ‑Zlan wö 'dhiö ꞊nɛ bhë; 'kɛɛ ka 'plɛ kun 'ö 'ka bhɔ ‑sü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","‑A pö 'ö Yesu ‑ya wo «'kɛɛ ka 'plɛ kun 'ö 'ka bhɔ ‑sü 'ka» bhë 'ö tɔɔ mɛ 'ö dho ‑a 'dhɔɔ dɔ ö yaagümɛ ‑nu ‑gɔ bhë ‑ya ‑dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","꞊Dhɛ Yesu ꞊ya yën ‑an ‑gɛn ‑nu 'zlu ‑sü ‑bha, 'ö ꞊luu 'ö ö ‑bha sɔ ‑ta ‑sɔ ‑nu ‑da ö ‑bha; ꞊dhɛ ꞊ya 'dho ꞊ya ‑ya ö ‑bha ꞊guë' ‑nu 'piö pë ‑bhö ‑a ‑ta ꞊gba 'dhiö, 'ö‑ pö ‑an ‑dhë: «Pë 'a 'go ‑na ‑a kë ꞊dhia bhë, ka‑ ‑gɛn ‑dɔ ‑a? ");
INSERT INTO dnj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ka n ‑dhɛ ka ‑Gɔmɛ, 'ö 'ka n ‑dhɛ ka Dëmɛ; ‑yö 'wun gia‑ 'ka, a‑ ‑de 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","‑Ka ‑dhɛ ‑ga bhë 'dhɛ! Ma 'a ka Dëmɛ, ka ‑Gɔmɛ 'ka bhë, 'ma ka ‑gɛn ‑nu 'zlu ꞊nɛ ‑kɔ bhë ‑a 'dhö, kö ‑yö ka ‑bha kö 'ka ka 'ko ‑nu ‑gɛn 'zlu. ");
INSERT INTO dnj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","‑A kë 'a‑ wo 'dhö bhë, ‑yö 'wun ꞊zuan' 'ka, 'a‑ ‑kë 'dhö kö 'ka 'to ‑a kë ‑sü 'piö ka 'ko ‑nu ziën. ");
INSERT INTO dnj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛ yuökëmɛ 'yaa ꞊va ö ‑gɔmɛ ‑bha, 'iin bɔmɛ yaa ꞊va mɛ 'ö‑ bɔ bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","꞊Dhɛ 'wun mɛ bhë 'ka‑ dɔ zlöö bhë, ‑yö n 'gü ꞊nɛ 'ka‑ 'kun ‑a 'kun ‑kɔ 'ka ꞊zuögludhi ‑dho kë ka ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","'Yö‑ pö 'zü: «'Wun 'a‑ ꞊blɛɛ bhë, yaa yö ka 'saadhö ka ‑bha; mɛ ‑nu 'ö 'wo n ‑ma 'ka 'ö 'a ‑an sü, a ‑an ‑dɔ. 'Kɛɛ kë‑ wo 'dhö bhë, 'wun bhë ‑yö ‑kë 'dhö kö pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü, ‑a 'dhiö ‑yaan ‑mɔ 'kuë. ‑Yö ꞊bɛɛn' ‑sü 'ka ꞊nɛɛ: Mɛ 'ö yi ‑nu 'yi pë ‑bhö ‑kplawo yi 'ko ꞊bhaa bhë, ꞊ya dɔ n ‑gɔ 'yënng. ");
INSERT INTO dnj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","'Wun bhë a‑ ‑to 'dhiö 'a‑ ꞊blɛɛ ‑yö kë 'dhö kö yi 'ö ‑a 'gü ‑pë dho kaa bhë, 'kaan‑ ‑a ‑dhɛ 'wun gia‑ ꞊nɛ ma ꞊nɛ 'a tɔɔ mɛ 'ö ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: Ma bɔmɛ bhë, mɛ ꞊yaa‑ ‑nia 'kun, kö ma ꞊nɛ 'ö n ‑nia kun bhë; 'ö mɛ 'ö ꞊ya n ‑nia 'kun bhë; 'ö mɛ 'ö ꞊ya n ‑nia 'kun, kö mɛ 'ö n bɔ bhë ꞊nɛ 'ö‑ ‑nia kun bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","꞊Dhɛ Yesu ꞊ya yën 'wun ꞊blɛɛ' ‑sü ‑bha 'dhö, 'ö‑ ꞊zuö' ‑yö ‑kaan 'kuë, ꞊dhɛ ‑kë 'dhö 'ö‑ pö: «A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: Mɛ do ‑yö ka ziën 'ö dho n 'dhɔɔ dɔ n yaagümɛ ‑nu kwɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","'Ö‑ ‑bha ꞊guë' ‑nu ‑wo yö wo 'ko ‑ga ‑sü 'gü 'wun 'ö‑ ꞊blɛɛ bhë ‑a ‑wun 'gü, 'ö bhii waa‑ ‑gɛn gbɛ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","꞊Dhɛ kë ‑na 'dhö, Yesu ‑bha ꞊guë' ‑nu 'wo bhë ‑a mɛ 'ö‑ ‑dhɔ ‑ya ‑kë ꞊duö bhë, ‑yö ‑kë Yesu 'sɔɔ. ");
INSERT INTO dnj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","'Yö Simɔ Piɛɛ ‑yö ö 'yan zë ‑a ‑dhë kö ‑yö Yesu ꞊dhɛɛ' kpɔ mɛ 'ö bhë ‑a ‑wun 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","꞊Dhɛ ꞊ya kë 'dhö, 'ö mɛ bhë 'ö ö ‑gɔ ꞊yɔɔn Yesu ‑bha, 'ö‑ pö ‑a ‑dhë 'saan 'gü: «N Dëmɛ, dö ‑mü ‑ii?» ");
INSERT INTO dnj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö n ‑ga 'dhɛ! A ‑dho ꞊bluu'‑ 'klu sü 'a‑ zë 'too 'ka 'tia‑ 'gü; mɛ 'a 'dhoë‑ nu ‑a ‑dhë bhë 'ö tɔɔ mɛ bhë.» 'Yö Yesu ‑yö ꞊bluu'‑ 'klu sü, 'ö‑ zë 'too 'ka, 'ö‑ nu Zuda 'ö ‑kë Simɔ Ikaliɔtö gbö 'ka bhë ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","꞊Dhɛ Zuda ‑yö ö ‑kɔ kpɔ ꞊bluu'‑ 'klu bhë ‑a ‑gɔ, 'ö‑ kun, 'ö Satan ‑yö ‑da ‑a ꞊zuö' 'piö. 'Ö Yesu ‑ya pö ‑a ‑dhë: «Pë 'ü dhoë‑ kë bhë, ‑bhöë kë 'siö‑ siö‑!» ");
INSERT INTO dnj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","'Kɛɛ kë‑ wo 'dhö bhë, ‑a ‑bha ꞊guë' ‑nu waa 'wun gbɛ dɔ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","꞊Dhɛ ‑kë ꞊nɛ Zuda ꞊nɛ 'ö ‑kë ‑an ‑bha 'wëü‑ ‑kɔ 'dhiö 'ka bhë, 'yö ‑kë ‑an ‑zo 'piö ꞊nɛ Yesu ‑ya ‑pö ‑a ‑dhë ‑yö 'dho ‑bhöpë 'wo dho 'wlaan‑ kë ‑a 'ka ‑a 'dhɔ ꞊dhia 'iin 'zü ꞊nɛ ‑yö 'dho ‑yö gbaɔ kë 'fɛɛmɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","'Yö Zuda ‑yö ꞊bluu'‑ 'klu bhë ‑a sü 'ö to mü 'ö yö plaan. ‑Dhɛ ‑yö ‑kë tii. ");
INSERT INTO dnj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","꞊Dhɛ 'ö Zuda ꞊ya yö plaan, 'ö Yesu ‑ya pö: «'Go 'töng ꞊nɛ ‑a ‑bha, ma Mɛgbö, n 'tɔbhɔsü ‑mü zlöö; 'ö ‑Zlan ‑bha 'tɔbhɔdhe dhö bɔ ‑a ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'Ö ꞊ya kë ꞊nɛ ‑Zlan ‑bha 'tɔbhɔdhe ꞊ya bɔ Mɛgbö 'ö bhë ‑a 'gü kö ‑Zlan ‑de gia‑ ‑yö ‑dho ‑a kë 'ö‑ Gbö ‑bha 'tɔbhɔdhe ‑yö bɔ ö ‑ta. Pë 'ö‑ ‑de dho kë ‑dëü yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ma 'në ‑nu, 'töng 'ö n ‑gɔ 'a‑ 'ka ka 'piö zö bhë ꞊ya 'to 'teete 'kpaan. Ka ‑dho n ꞊mɛɛ', 'kɛɛ ‑dhɛ 'a dho dho ‑a ‑bha bhë, kaa 'dho ‑mɔa ‑bha 'ka ‑da mü. Ka gia‑ ka‑ ꞊tɛi' ‑dɔ. ‑A mɛ 'kö bhë 'ma‑ ꞊blɛɛ' Zuifö ‑nu ‑dhë 'dhiö 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","'Kɛɛ a ka 'paan bho ‑na, ‑yö tɔng ‑dëü 'ka, 'a‑ dɔ ꞊nɛɛ: ‑Ka ka 'ko ‑nu ‑dhɔ kë. Ka ꞊dua' ‑mü 'ka ka 'ko ‑nu ‑dhɔ kë ꞊nɛ ‑kɔ 'a ka ‑dhɔ ꞊kaa' bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","꞊Ya kë ꞊nɛ 'ka ka 'ko ‑nu ‑dhɔ kë, mɛ 'saadhö ‑wo ‑dho ‑a ‑dhɛ yö ꞊nɛ ka ma ꞊guë' ‑nu 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","꞊Dhɛ Yesu ꞊ya 'wun ꞊blɛɛ'‑ ꞊nɛ ‑kɔ bhë ‑a 'dhö, 'ö Piɛɛ ‑ya ꞊dhɛɛ' kpɔ ꞊nɛɛ: «N Dëmɛ, ü ‑dho mɛɛ?» 'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Bhö 'to bhë! ‑Dhɛ 'a 'dho ‑na ‑a ‑bha bhë, ü ‑kɔ yaa ‑mɔa ‑bha kö 'ü 'to n 'piö 'ko 'dho mü, 'kɛɛ ü ‑dho ziö n 'piö 'dhiö ꞊zian'.» ");
INSERT INTO dnj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","'Ö Piɛɛ ‑ya pö ‑a ‑dhë: «N Dëmɛ, ‑më ‑kë 'ö n 'ka dho ziö ü 'piö 'töng mɛ ꞊nɛ ‑a 'ka ɛɛ? N ‑mɔa 'gü ‑sü ‑mü kö 'a ziö ü 'piö 'kö ‑kë ꞊nɛ ‑wo ‑dho n zë 'dhee!» ");
INSERT INTO dnj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","'Ö Yesu ‑ya ꞊dhɛɛ' kpɔ, 'ö‑ pö: «Ü ‑dho pë 'saadhö kë 'kö ‑kë ꞊nɛ ‑wo ‑dho ü zë ‑a 'ka a? ꞊Ao'! A‑ ‑pö ü ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: ‑A kë ‑yi 'ka kö ‑tɔ gɔn ‑yaan 'we, ü ‑dho ‑a pö ‑gwaa ‑yaagazë ꞊nɛ 'bhaa n dɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü: «Kö ꞊kun 'ö ka ꞊zuö' ‑yö to zlöö. ‑Ka ka ‑zo yö ‑Zlan ‑bha, 'ka n ‑wun ‑dhɛ 'wun gia‑ 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","‑Yadhɛ 'ö n Dë 'piö dhang‑ 'gü ‑yö ꞊va; a 'dho ‑na kö 'aan‑ ka ‑bha ‑pë kë. ꞊Ya kë ꞊nɛ 'yaa 'wun gia‑ 'ka ‑bezë, n 'ka 'dho ‑a ‑wun ꞊blɛɛ' ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","꞊Ya kë ꞊nɛ 'ma 'dho, 'ma ka ‑yadhɛ ‑pë kë, a ‑dho yɛ n 'zü 'a nu ka 'sü ‑dhiadhö kö 'kwaan‑ 'dho 'ma; ‑yö kë 'dhö kö ka ‑de 'pö 'kaan‑ kë ‑dhɛ 'a‑ ‑bha ‑a ‑dhɛ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","‑Dhɛ 'a 'dho ‑na ‑a ‑bha bhë, ka‑ ‑zian ‑dɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","꞊Dhɛ ꞊ya kë 'dhö, 'ö Toma ‑ya pö ‑a ‑dhë: «N Dëmɛ, 'yiëë ü 'dhodhɛ dɔ. ꞊Ya kë 'dhö yi ‑dho ‑a ‑zian dɔ ‑kɔklë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","'Yö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «Ma ꞊nɛ 'a tɔɔ zian 'ö dho ‑Zlan 'piö, 'wun gia‑ ‑gɔ 'godhɛ waa‑ ꞊toëpö ‑këdhösü ‑nu mɛ ‑dhë ‑mɛ. Mɛ yaa 'dho ‑mɔa ‑bha kö ‑yö 'dho n Dë 'piö kö yaa bɔ n ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","꞊Ya kë ꞊nɛ ka n ‑dɔ kö ka ‑dho n Dë dɔ 'pö. ‑A ‑de dɔ 'kwa‑ wo ꞊nɛ 'ka‑ yö, 'ö 'ka‑ dɔ 'saadhö.» ");
INSERT INTO dnj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","'Ö Filipö ‑ya pö ‑a ‑dhë: «N Dëmɛ, kwa Dë 'ö bhë, ‑bhöë ‑zɔn yi ‑dhë kö yi ꞊zuö' ‑yaan 'dho sia‑ ‑ɛ.» ");
INSERT INTO dnj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","'Ö Yesu ‑ya pö ‑a ‑dhë: «Filipö, 'kwa ꞊glɔɔ kwa 'kuë‑ ꞊duö 'ö 'bhaa n dɔ ꞊nɛ, ‑yö 'yenazë ꞊dhɛɛ! Mɛ 'ö ꞊ya n yö kö ꞊ya ö 'yan dɔ n Dë ‑bha. ꞊Dhɛ ‑kë 'dhö ꞊nɛ ‑më tɔɔ ‹kwa Dë 'ö bhë ‑bhöë ‑zɔn yi ‑dhë› ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'Bhaa‑ ‑wun ‑dhɛ 'wun gia‑ ꞊nɛ a n Dë 'gü 'ö n Dë 'dhö n 'gü a? 'Wun ‑nu 'a‑ ꞊blɛɛ' ‑na ka 'saadhö ka ‑dhë ꞊nɛ ‑a gbɛ yaa 'go n ‑de 'gü. N Dë 'ö ‑ya ‑sü 'ka n 'gü bhë ꞊nɛ 'ö bɔ ‑na n 'gü 'ö ö ‑de ‑gɔ ‑yuö ‑nu kë ‑na bhë. ");
INSERT INTO dnj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","‑A pö 'a‑ wo ‑na ka ‑dhë a n Dë 'gü 'ö n Dë 'dhö ‑ya ‑sü 'ka n 'gü bhë, ‑kaa ‑dhɛ 'wun gia‑. 'Ö‑ ‑de kë ꞊nɛ 'yaa 'dhö, ka ‑mɔa yuö ‑nu 'ö bɔ ‑na n 'gü 'ö‑ kë ‑na bhë ‑a ‑wun 'gü, ka‑ ‑dhɛ 'wun gia‑ 'püë‑ wo ꞊nɛ Dë ‑yö ‑ya ‑sü 'ka n 'gü 'ö ma ‑de 'pö 'a‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: Mɛ 'oo mɛ 'ö ꞊ya n ‑wo ‑nu ‑dhɛ 'wun gia‑, pë ‑nu 'a‑ kë ‑na ꞊nɛ ‑yö ‑dho ‑an kë 'pö. 'Ö‑ ‑de 'ö dho pë ‑nu kë 'ö ‑ziö ‑a 'ka mü, bhii a 'dho ‑na n Dë 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pë 'saadhö 'ka dho ‑a ‑dhɛ n 'tɔ 'gü, a ‑dho ‑a 'plɛ kë ‑yö kë 'dhö kö ma 'a‑ Gbö 'ka bhë, ‑yaan kë n ‑ma n Dë 'tɔ kë ꞊va ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pë 'oo pë 'ka dhoë‑ ‑dhɛ n ‑gɔ, kwa ‑nu kwa ‑bha ‑klu 'kuë‑ ‑sü ‑wun 'gü, a ‑dho ‑a kë.» ");
INSERT INTO dnj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","'Ö Yesu ‑ya pö 'zü: «꞊Ya kë ꞊nɛ n ‑dhɔ ‑yö ka ‑kë, kö ‑ka ma tɔng ‑nu 'kun. ");
INSERT INTO dnj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","'Kɛɛ kë‑ wo 'dhö bhë, a ‑dho ‑a ‑dhɛ n Dë ‑gɔ kö ‑yö mɛ 'waa gbɛ bɔ ka ‑dhë kö ‑yaan nu ka ‑dhë. Mɛ bhë 'ö tɔɔ ‑Zuu 'ö 'wun gia‑ ‑yö go ‑a 'gü. Yö ꞊nɛ 'ö dho kë ka 'piö ‑kplawo. ");
INSERT INTO dnj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'Kpongtaamɛ ‑nu 'ka 'dhö ‑mɔa kö ‑wo wo ‑kɔ 'kpɔ ‑a ‑gɔ wo ꞊zuö' 'gü; 'ö tɔɔ waa 'dho wo 'yan dɔ ‑a ‑bha kö ‑waan 'dhoë‑ dɔ. 'Kɛɛ ka ‑zë ka‑ ‑dɔ; 'kɛɛ ka ‑zë, ka ‑nu ka ka 'ko 'piö, 'ö ‑ya ‑sü 'ka ka 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'Yö‑ pö: «N 'ka 'dho ka to 'sloo 'ka; a ‑dho yɛ n 'zü 'a nu ka 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'Töng 'yaa ꞊gbiin gbɔ kö 'aan‑ 'go 'kpongtaamɛ ‑nu 'yan 'dhiö; 'kɛɛ ka ‑zë, ka ‑dho ka 'yan dɔ n ‑ma, 'ö tɔɔ a 'bhee‑, 'ö ka ‑de 'pö, 'ka dho kë 'bhee‑. ");
INSERT INTO dnj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Yi 'ö bhë ꞊ya kë ꞊nɛ ꞊ya ‑lo, ka ‑dho ‑a ‑dhɛ yö ꞊nɛ a ‑ya ‑sü 'ka n Dë 'gü, 'go mü, 'ka ‑ya ‑sü 'ka n 'gü; 'ö ma ‑de 'pö, 'a ka 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mɛ 'ö ꞊ya ma tɔng ‑nu 'kun, kö mɛ bhë n ‑dhɔ ‑ya ‑kë. Mɛ bhë ꞊nɛ 'ö n Dë ‑ya ‑dhɔ ‑kë. Ma ‑de 'pö, ‑a ‑dhɔ ‑dho n kë 'ö 'a n ‑de ‑zɔn ‑a ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu bhë ‑a mɛ 'wo‑ ‑dhɛ Zudë bhë, (n 'ka‑ pö Zuda Ikaliɔtö,) 'ö Yesu ꞊dhɛɛ' kpɔ 'ö‑ pö: «N Dëmɛ, ‑yö ‑kë ꞊dhë 'ö 'ü dho ü ‑de ‑zɔn yi ‑dhë, 'ö ü 'ka 'dhoë‑ wo 'kpongtaamɛ ‑nu ‑dhë ‑ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","'Ö Yesu ‑ya pö ‑a ‑dhë: «Mɛ 'ö n ‑dhɔ 'dhoë‑ 'gü, ‑yö ‑dho n ‑ma tɔng ‑nu kun. Mɛ bhë n Dë ‑dhoë ‑dhɔ kë, 'ö ma 'dhö, n Dë 'dhö, 'yi kpa yi 'kuë‑ 'ö 'yi dho 'yi ‑ya ‑a ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yö ꞊ga 'ö mɛ 'ö n ‑dhɔ 'yaa‑ 'gü 'pö, 'ö 'yaa n ‑wo ‑nu ꞊bhlë ‑ya. ‑Wo ‑nu 'wo 'go ‑na n dhiö 'ka‑ ma ‑na bhë, waa 'go n ‑de 'gü; 'kɛɛ n Dë 'ö n bɔ bhë ꞊nɛ 'wo go ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‑Wo ‑nu 'wo bhë 'saadhö ꞊nɛ 'töng 'ö ꞊tun n ‑gɔ ka 'piö zö bhë, 'a ka ꞊daan ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mɛ 'ö dho nu kö ‑yaan nu ka ‑dhë, ‑wo ‑nu 'wo bhë, ka ‑zo ‑büö ‑sü 'iin ka ‑daan ‑an 'ka ‑sü 'ka bhë 'ö tɔɔ ‑Zuu 'slööslö 'ö n Dë dhoë‑ bɔ ka ‑dhë n 'tɔ 'gü bhë. ");
INSERT INTO dnj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","N 'dho ‑sü ‑mü; 'kɛɛ ꞊zuöyagluu 'a‑ nu ka ‑dhë. ‑Yö n ‑de ‑bha ꞊zuöyagluu 'ka, 'a‑ nu ka ‑dhë. 'Yaa ꞊nɛ ‑a mɛ 'ö 'kpongtaa zö ‑a 'dhö. Kö ꞊kun 'ö ka ꞊zuö' ‑yö to zlöö 'iin 'ö 'siö ‑yö ‑kan ka 'gluu. ");
INSERT INTO dnj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","'Wun 'a‑ ꞊blɛɛ ka ‑dhë ꞊nɛɛ ‹a 'dho ‑na, 'kɛɛ a ‑dho yɛ n 'zü› bhë, ka‑ ma ‑a! ꞊Ya kë 'dhö, ꞊ya kë ꞊nɛ n ‑dhɔ ‑yö ka ‑bha ‑be, kö ka ꞊zuö' 'glu ‑dho dhi ‑a ma ‑sü 'ka ꞊nɛ a ‑dho n Dë 'piö 'ö bhii n Dë ‑yö ꞊va n ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","'Wun ‑nu 'wo bhë a ‑an ‑to 'dhiö 'a ‑an ‑wun ꞊blɛɛ ka ‑dhë, ‑yö kë 'dhö kö yi 'ö 'wo dho kë ‑a 'ka bhë 'kaan‑ n ‑wo ‑nu ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Töng 'yaa n ‑gɔ ꞊va gbɔ kö 'kwaan‑ ‑ya kwa 'ko ꞊bhaa ꞊nɛ ‑kɔ ꞊suu'‑ ꞊nɛ ‑a 'dhö, kö 'aan‑ 'wun ‑nu ꞊blɛɛ' ka ‑dhë, 'ö tɔɔ ‑gludë 'ö 'kpongtaamɛ ‑nu ꞊kɔɔn ‑na bhë ‑yö nu ‑na. 'Kɛɛ kë‑ wo 'dhö bhë ‑a ‑kɔ 'yaa ‑mɔ n ‑ma. ");
INSERT INTO dnj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","'Kɛɛ a‑ 'piö kö 'a pë 'ö n Dë ‑ya pö 'a‑ kë bhë 'aan‑ kë; 'yaa n 'gbee‑ ‑ta bho ‑sü 'ka; ‑yö ‑kë 'dhö kö 'kpongtaamɛ ‑nu ‑waan ‑a dɔa ꞊nɛ n Dë ‑dhɔ ‑yö n ‑kë. ꞊Ao', ‑ka ꞊luu', 'kwa ziö!» ");
INSERT INTO dnj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","꞊Dhɛ Yesu ꞊ya 'wun ꞊blɛɛ'‑ ‑an ‑dhë 'dhö, 'yö 'wun ꞊zuan' do 'bhaa ‑zɔn ‑an ‑dhë ꞊nɛɛ: «'Ma 'wun 'sü lɛzɛn 'wo ‑drɔɔn kë ‑na 'ka bhë ‑a ‑bha ꞊nɛ ma 'a tɔɔ lɛzɛn ‑lü giagia 'ö n Dë 'dhö ‑a tamɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","꞊Dhɛ ꞊ya kë 'dhö, 'ö n Dë ‑yö nu, 'ö lɛzɛn ‑lü 'a‑ 'ka bhë 'ö‑ ‑kɔ ‑nu mɛ 'ö 'waa wo ‑kpa ‑ya bhë 'ö ‑an ‑kan 'ö ‑an bho mü; 'ö‑ mɛ ‑nu 'ö ‑an ‑kpa dhö ‑dhö bhë 'ö ‑an ‑ta ‑kan ‑yö kë 'dhö kö ‑an ‑kpa 'bhaa ‑yaan ‑ya 'zü. ");
INSERT INTO dnj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","‑Ka ‑dhɛ ‑ga bhë 'dhɛ: Mɛ ꞊daan' ‑wo ‑nu 'a‑ nu ka ‑dhë bhë waa ka kë ꞊nɛ pë ‑ta 'kan ‑sü 'dhö kaa kë 'slööslö ‑a? ");
INSERT INTO dnj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","‑Ka 'to ‑klu ‑sü 'ka n ‑ma ꞊nɛ ‑kɔ 'a‑ 'ka ka ‑bha bhë ‑a 'dhö. ꞊Dhɛ 'ka‑ ‑ga 'wun bhë ‑a 'gü bhë, ka ‑mɔa 'ka‑ pö lɛzɛn ‑lü ‑kɔ ‑yö ‑mɔa ‑a ‑kpa ‑yö ‑ya 'sloo 'ka kö 'yaa ‑gban ‑sü 'ka ö 'lü gia‑ ‑bha ‑a? ꞊Ɛɛ, 'ö ‑kɔ do bhë 'ö‑ 'ka 'pö kaa ‑mɔa ka ‑yö ‑a ‑bha ‑pë ‑yö kë ‑dhö ‑Zlan ‑bha zian ‑ta kö kaa 'to ‑klu ‑sü 'ka n ‑ma. ");
INSERT INTO dnj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ma ꞊nɛ 'a tɔɔ lɛzɛn ‑lü, 'ö ka ꞊nɛ 'ka tɔɔ lɛzɛn ‑lü 'ö bhë ‑a ‑kɔ ‑nu. Mɛ ꞊ya 'to ‑klu ‑sü 'ka n ‑ma kö 'aan‑ kë ‑klu ‑sü 'ka ‑a ‑bha, ‑a ‑yö ‑a ‑bha ‑pë ‑nu ‑dho kë ꞊plëëzë 'ka ‑Zlan ‑bha zian ‑ta ꞊nɛ ‑kɔ 'ö lɛzɛn ‑lü bhë 'ö‑ ‑kpa ‑nu 'dhoë‑ 'ka bhë ‑a 'dhö, 'ö bhii kaa ‑mɔa 'ka pë gbɛ kë kö kaa 'to ‑klu ‑sü 'ka n ‑ma. ");
INSERT INTO dnj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mɛ 'ö yaa 'to ‑klu ‑sü 'ka n ‑ma, ‑yö ‑dho kë ‑zuö plaan ‑mɛ 'ka ꞊nɛ ‑kɔ 'ö‑ 'ka 'lü ‑kɔ 'ö 'yaa ö ‑lü ‑bha ‑a 'dhö; 'ö ꞊ya kë 'ö 'kpɛa kun. Ka gia‑ ka‑ ‑dɔ ꞊nɛ 'lü ‑kɔ 'kpɛa ‑nu bhë ꞊wa ‑an 'dho 'kuëdhö, kö 'dho 'wo 'dhoë‑ ‑an güö bhë. ");
INSERT INTO dnj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","꞊Ya kë ꞊nɛ 'ka 'to ‑klu ‑sü 'ka n ‑ma, 'ö n ‑wo ‑nu ꞊wa ‑ya ka 'gü, pë 'oo pë 'ö 'ka dhoë‑ ‑dhɛ, ka ‑dhoë yö. ");
INSERT INTO dnj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","N Dë ‑bha 'tɔbhɔdhe 'ö bhë ‑a ‑wo ‑kɔ ꞊ga 'ö bhë; 'ö bhii ꞊ya kë ꞊nɛ ka ‑yö ‑a ‑bha ‑pë ꞊ya kë ‑dhö ‑Zlan ‑bha zian ‑ta ꞊nɛ ‑kɔ 'ö lɛzɛn ‑kpa ‑nu 'dho ‑ya ‑na ‑a 'ka bhë ‑a 'dhö kö 'ka‑ ‑zɔn ꞊nɛ ka n ‑ma ꞊guë' ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","A ka ‑dhɔ ‑kë ꞊nɛ ‑kɔ 'ö n Dë ‑yö n ‑dhɔ ꞊kaa' bhë ‑a 'dhö. ‑Ka 'to ma ‑dhɔ 'gü! ");
INSERT INTO dnj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","‑A kë ‑kɔ ꞊ga ꞊nɛ: ꞊Ya kë ꞊nɛ 'ka ma tɔng ‑nu 'kun, ka ‑dho to ma ‑dhɔ 'gü ꞊nɛ ‑kɔ 'ö ma ‑de 'pö 'a n Dë ‑bha tɔng ‑nu kuën 'ö‑ ‑wun 'gü, 'a‑ 'ka ‑a ‑bha ‑dhɔ 'gü bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","'Wun bhë a‑ ‑blɛɛ ka ‑dhë 'dhö ‑yö kë 'dhö kö ꞊zuögludhi 'ö n ‑gɔ bhë ‑yö ‑ya ka 'gü kö 'go mü ka ꞊zuö' 'glu ‑yaan dhi 'fɛfɛdhö. ");
INSERT INTO dnj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma tɔng bhë 'ö tɔɔ: ‑Ka ka 'ko ‑nu ‑dhɔ kë ꞊nɛ ‑kɔ 'ö 'a ka ‑dhɔ kë ‑na ‑a 'ka ꞊nɛ ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ka gia‑, ka‑ ꞊tɛi' ‑dɔ ꞊nɛ pë 'kö mɛ dhoë‑ kë kö ‑yaan ‑zɔn ö 'bha ‑dhë ꞊nɛ 'ö‑ ‑dhɔ ‑kë ꞊duö 'ö tɔɔ 'we 'ö dho ‑a wo ‑a ‑bha kö ‑yaan ga ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","꞊Ya kë ꞊nɛ pë ‑nu 'a‑ pö ka ‑dhë 'töüdhö bhë 'ka‑ 'kun, kö ka n 'bhamɛ ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","N 'ka 'dho ka ‑dhɛ ‑dewo poo ma yuökëmɛ ‑nu zlöö, 'ö tɔɔ mɛ 'ö yuö ‑kë ö ‑gɔmɛ ‑dhë, pë ‑nu 'ö‑ ‑gɔmɛ 'dhoë‑ kë ‑na 'yaa‑ dɔ. A ‑dho ka ‑dhɛ zlöö n 'bhamɛ ‑nu, bhii pë ‑nu 'a‑ ꞊daan 'saadhö n Dë 'piö bhë, 'ma‑ 'plɛ ‑zɔn ka ‑dhë, 'ka‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ka kun 'ka n sü; 'kɛɛ ma ꞊nɛ 'a ka ꞊dhɔɔ ‑kë n ꞊bhaa, 'ö 'a‑ pö ka ‑dhë 'ka 'dho kö 'ka yuö kë, ‑a ‑yö ‑a ‑bha ‑pë ‑nu ‑wo kë ‑Zlan ‑bha zian ‑ta ꞊nɛ ‑kɔ 'ö lɛzɛn ‑lü ‑kpa 'dhö kë ‑na ‑a 'ka bhë ‑a 'dhö. 'Ö ka këyuö ‑nu 'wo bhë 'ö ‑an ‑yö ‑a ‑bha ‑pë ‑nu 'wo bhë 'wo dho ꞊glɔɔ. ꞊Dhɛ ‑kë 'dhö, pë 'oo pë 'ka‑ ‑dhɛ n Dë ‑gɔ n 'tɔ 'gü, ‑yö ‑dho ‑a nu ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","'Kɛɛ pë 'ö 'a‑ ‑dhɛ ka ‑gɔ 'ö tɔɔ kö 'ka ka 'ko ‑nu ‑dhɔ kë.» ");
INSERT INTO dnj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","'Yö Yesu ‑ya pö ‑an ‑dhë 'zü: «꞊Ya kë ꞊nɛ 'kpongtaamɛ ‑nu ꞊wa ka ‑san zë kö ‑yö kë ka 'yaan ꞊nɛ ‑wo n ‑san ‑zë 'dhiö ‑be ‑waan ꞊tun yö ‑na ka ‑bha bhë. ");
INSERT INTO dnj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","꞊Ya kë ꞊nɛ ka ‑kë 'kpongtaamɛ ‑nu 'ka 'pö ‑be, ‑wo ‑dho ka ‑dhɔ kë, 'ö bhii kö ka ‑an ‑mɛ 'ka. 'Kɛɛ 'ma ka 'sü, 'ma ka bho 'kpongtaamɛ ‑nu ziën; 'kaa 'kpongtaamɛ ‑nu 'ka gbɔ; pë 'ö‑ ‑wun 'gü 'ö 'wo ka ‑san zë ‑na 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kë‑ wo bhë n 'ka‑ pö ka ‑dhë 'dhiö ꞊nɛɛ yuökëmɛ 'yaa ꞊va ö ‑gɔmɛ ‑bha ‑a? ꞊Ɛɛ, 'ö ꞊dhɛ ꞊wa n 'klo bhɔ bhë, kö ‑yö kë ka 'yaan ꞊nɛ ‑wo ‑dho ka 'klo bhɔ 'pö. ꞊Ya kë ꞊nɛ ꞊wa 'wun ma n ‑ma mɛ ꞊daan' ‑wo ‑nu ‑ta, kö ‑yö kë ka 'yaan ꞊nɛ ‑wo ‑dho 'wun ma ka ‑bha ‑nu ‑ta 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","'Kɛɛ kë‑ wo 'dhö bhë, pë ‑nu 'wo dhoë‑ kë ka 'ka 'dhö bhë, ‑wo ‑dho ‑a kë kaa n ‑wun 'gü, 'ö bhii mɛ 'ö n bɔ bhë 'waa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","꞊Ya kë ꞊nɛ n 'ka nu ‑be kö 'aan‑ 'wun ꞊blɛɛ' ‑an ‑dhë, za ‑bha ‑an 'kun ‑sü gbɛ 'ka 'dho kë ‑dhö, ‑an ‑bha ꞊sɔɔn yaa ‑nu ‑wun 'gü. 'Kɛɛ dɔ 'kwa‑ wo ꞊nɛ (꞊wa yën n ‑wo ‑nu ma ‑sü ‑bha; ꞊ya kë 'dhö,) ‑a 'slë gbɛ 'ka 'dho kë ‑an ‑gɔ gbɔ ‑an ‑bha ꞊sɔɔn yaa ‑nu ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mɛ 'ö ꞊ya n ‑san zë, kö ꞊ya n Dë ‑san zë ꞊nɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","꞊Ya kë ꞊nɛ pë ‑nu 'a‑ ‑kë 'kpɛɛdhö, 'ö mɛ gbɛ yaa‑ kë do kun bhë, n 'ka‑ kë 'dhö ‑bezë, za 'ka 'dhö ‑an kun. 'Kɛɛ ꞊dɛɛ, ‑an 'yan ꞊ya ‑da n këyuö ‑nu 'gü; yö ꞊ga 'ö 'wo ma 'dhö, n Dë 'dhö, yi ‑san zë ‑na bhë. ");
INSERT INTO dnj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'Kɛɛ pë ‑nu 'wo bhë ‑wo ‑kë 'dhö kö pë ‑nu 'wo ‑ya ‑sü 'ka ‑an ‑bha tɔng 'sëëdhɛ 'gü ‑an 'dhiö ‑yaan ‑mɔ 'kuë. Pë 'ö ꞊bɛɛn' ‑sü 'ka ‑ya ‑pö: ‑Wo n ‑san ‑zë 'kpaan 'ka; ‑a ‑gɛn gbɛ 'yaa 'dhö. » ");
INSERT INTO dnj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","'Yö‑ pö: «Mɛ 'ö dho nu ka ‑dhë bhë, ‑yö ‑dho nu. 'Yö tɔɔ ‑Zuu 'slööslö 'ö go n Dë 'piö; yö ꞊nɛ 'ö tɔɔ 'wun gia‑ ‑gɛn 'godhɛ. Ma ꞊nɛ 'a dho ‑a bɔ ka ‑dhë. 'Kɛɛ ‑yö ‑go n Dë 'piö. Yö ꞊nɛ 'ö dho n ‑wun ꞊blɛɛ' ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","꞊Ya kë 'dhö, ka ‑de 'pö, 'ka n ‑wun ꞊blɛɛ' mɛ ‑nu 'wo to ‑an ‑dhë, 'ö bhii ka ꞊nɛ 'ö 'ka ‑kë n 'piö ‑a züdɔyi 'ka 'ö yöë ꞊dɛɛ ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","'Yö Yesu ‑ya pö 'zü: «A‑ ‑pö ka ‑dhë 'dhö, ‑yö kë 'dhö kö ꞊kun 'ka dho ka bo ‑zo ‑yö n ‑ma ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","‑Wo ‑dho ka kë, 'wo ka bho ‑an ziën wo ‑bha ‑bhɔkuëkɔ ‑nu 'gü. ‑A ‑de 'töng 'bhaa 'ka, mɛ ‑nu ‑wo ‑dho ka zë ‑a pö ‑sü 'ka wo ‑de ꞊zuö' 'piö ꞊nɛ ‑wo ‑Zlan ‑dhi ‑a ‑dhë ‑wun kë ‑na. ");
INSERT INTO dnj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","‑A kë 'wo dhoë‑ wo 'dhö bhë 'ö tɔɔ waa n Dë dɔ 'iin waa n dɔ. ");
INSERT INTO dnj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","‑A pö 'a‑ wo ‑na ka ‑dhë 'dhö bhë 'ö tɔɔ kö yi 'ö ‑an ‑bha 'töng dho ‑lo ‑a 'ka kö ‑waan pë ‑nu kë ka 'ka ꞊nɛ ‑kɔ bhë ‑a 'dhö, kö ka ‑zo ‑yaan ‑büö ꞊nɛ 'ma‑ 'to 'dhiö 'ma‑ ꞊blɛɛ' ka ‑dhë 'saadhö. 'Wun ‑nu 'wo bhë ‑a ꞊blɛɛ' 'ö n 'ka‑ wo ka ‑dhë 'dhö ‑blɛɛzë 'ka bhë 'ö tɔɔ kö a ꞊tun ka 'piö.» ");
INSERT INTO dnj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","'Yö Yesu ‑yö dhoë 'dhiö, 'ö‑ pö ‑an ‑dhë: «'Kɛɛ ꞊dhɛ 'ö ‑kë ꞊nɛ n 'dho ‑sü ‑mü mɛ 'ö n bɔ ‑a 'piö bhë ꞊nɛ, 'a 'wun ꞊blɛɛ ka ‑dhë 'dhö bhë. ‑A ‑wun 'gü 'ka ‑ya diindhö, 'ö mɛ 'yaa ‑dhö ka ziën kö ‑yö n ꞊dhɛɛ' 'kpɔ ꞊nɛɛ: ‹Ü ‑dho mɛɛ?› 'ka bhë, ");
INSERT INTO dnj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'ö tɔɔ ‑wɛɛ ꞊ya 'kpɔ ka ‑ta 'wun ‑nu 'wo bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'Kɛɛ kë‑ wo 'dhö bhë, a‑ ‑pö ka ‑dhë 'wun gia‑ 'ka ꞊nɛɛ: ꞊Yö ‑së ka ‑bha 'ka kö 'a 'dho ka 'dhiö, 'yaa 'dhö mɛ 'ö dho nu kö ‑yaan nu ka ‑dhë bhë yaa 'dho ‑lo ka ‑ta. ꞊Ya kë ꞊nɛ 'ma 'dho, yö ꞊nɛ 'a dho ‑a bɔ ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yö bhë ꞊nɛ 'ö ꞊ya nu, 'ö dho ‑a ‑zɔn 'kpongtaamɛ ‑nu ‑dhë ꞊nɛ 'wun 'ö ‑gban ꞊sɔɔn yaa ‑wun ‑bha, 'wun 'ö ‑gban pë 'ö kpengdhö ‑a ‑bha, 'wun 'ö ‑gban ‑Zlan ‑bha za 'ö dho ‑a dɔ ‑a ‑bha, ‑kɔ 'ö‑ 'ka ‑an ꞊zuö' 'piö bhë 'yaa 'dhö; wo ‑de ‑püö 'wo‑ wo ‑na bhë. ");
INSERT INTO dnj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wo ‑de ‑püö 'wo‑ wo ‑na 'wun 'ö ‑gban ꞊sɔɔn yaa ‑bha ‑a ‑wun 'ka bhë 'ö tɔɔ 'waa n ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Wo ‑de ‑püö 'wo‑ wo ‑na 'wun 'ö ‑gban pë 'ö kpengdhö ‑a ‑wun 'ka bhë 'ö tɔɔ n 'dho ‑sü ‑mü n Dë 'piö; ka 'ka 'dho n yö gbɔ; ");
INSERT INTO dnj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","'iin 'zü, wo ‑de ‑püö 'wo‑ wo ‑na 'wun 'ö ‑gban ‑Zlan ‑bha za 'ö dho ‑a kan ‑a ‑wun 'ka bhë 'ö tɔɔ 'kpongtaamɛ ‑nu ꞊kɔɔnmɛ bhë ‑a ‑bha za ꞊ya 'kan 'saadhö, ‑a ‑gɔ ꞊ya 'toë‑ 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'Yö‑ pö ‑an ‑dhë 'zü: «'Wun ‑yö n ‑gɔ ꞊va kö 'aan‑ ꞊blɛɛ'‑ ka ‑dhë; 'kɛɛ 'ma ‑dhɛ ‑ga ‑a 'gü ‑së 'ka, ‑an 'plɛ 'ka 'dho to ka 'toë‑, dɔ 'kwa‑ wo ꞊nɛ ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","‑Zuu 'ö 'wun gia‑ ‑go ‑a 'gü ‑mɛ 'ka bhë ꞊ya nu, yö ꞊nɛ 'ö dho yö ka ‑dhë 'dhiö 'wun gia‑ ‑zian ‑ta. Yö ꞊nɛ ꞊ya nu, 'ö pë ‑nu 'ö‑ ma 'iin pë ‑nu 'wo dho kë, 'ö dho ‑an 'plɛ ꞊blɛɛ' ka ‑dhë. 'Kɛɛ kë‑ wo 'dhö bhë, yaa 'dho kë yö ‑de 'sloo ‑a ‑de ‑ta ‑wun 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","‑Yö ‑dho n 'tɔ kë ꞊va, 'ö tɔɔ ma ꞊nɛ 'a dho n ‑wo ‑nu ‑lo ‑a kwɛɛ kö ‑yaan nu ‑yaan ꞊blɛɛ'‑ ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pë 'saadhö 'ö n Dë ‑bha 'ka, kö ma pë ‑mü. Pë 'ö ‑kë 'a‑ pö ‑Zuu 'slööslö 'ö bhë a ‑dho n ‑wo ‑nu ‑lo ‑a kwɛɛ kö ‑yaan nu ‑yaan ꞊blɛɛ'‑ ka ‑dhë 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","'Yö‑ pö ‑an ‑dhë 'zü: «'Töng 'ö n ‑gɔ ka 'piö zö bhë 'yaa ꞊va gbɔ; n ‑go ka 'yan 'dhiö ‑sü ‑mü kö 'aan‑ 'dho; 'ö ꞊ya 'go mü, ‑a ‑dhɛ yaa 'dhö ꞊glɔɔ 'ö 'ka ‑kpën n ‑ma 'zü.» ");
INSERT INTO dnj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ ‑bha ꞊guë' ‑nu 'bhaa ‑nu ‑wo yö ‑a pö ‑sü ‑bha wo 'ko ziën ꞊nɛɛ: «‑Wo ‑nu 'ö‑ ꞊blɛɛ 'saadhö ꞊nɛ ‹'töng 'ö n ‑gɔ ka 'piö zö bhë yaa ꞊va gbɔ; n ‑go ka 'yan 'dhiö ‑sü ‑mü kö 'aan‑ 'dho, 'ö ꞊ya 'go mü, ‑a ‑dhɛ 'ka 'dho ꞊glɔɔ 'ö 'ka ‑kpën n ‑ma 'zü›, 'ö‑ 'bhaa ‑nu ‑wo ‑kë ‹'ö tɔɔ n 'dho ‑sü ‑mü n Dë 'piö› 'wo bhë 'saadhö, ‑an ‑gɛn tɔɔ ‑më, 'kwa dɔa ꞊nɛɛ? ");
INSERT INTO dnj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‹'Töng 'yaa ꞊va gbɔ› ‑de 'kö‑ pö ‑na ꞊nɛ ‑a ‑gɛn tɔɔ ‑më poo ꞊ee? Pë ‑nu 'ö‑ pö ‑na 'saadhö bhë, 'kwaa‑ ‑gɛn ma 'sa!» ");
INSERT INTO dnj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","꞊Dhɛ Yesu ꞊yaa‑ ‑dhɛ yö ꞊nɛ ‑wa 'piö 'wo ꞊dhɛɛkpɔdhe kë ö ‑gɔ, 'ö‑ pö ‑an ‑dhë: «A‑ ‑pö ka ‑dhë: 'Töng 'ö n ‑gɔ ka 'piö zö bhë 'yaa ꞊va gbɔ; n 'go ‑sü ‑mü ka 'yan 'dhiö kö 'aan‑ 'dho, ꞊ya 'go mü, ‑a ‑dhɛ yaa 'dhö ꞊glɔɔ 'ö 'ka ‑kpën n ‑ma 'zü; 'wun bhë 'pö 'ka‑ ‑ta ꞊dhɛɛ' kpɔ ka 'ko ‑nu ‑gɔ bhë ee? ");
INSERT INTO dnj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Ka ‑dho 'gbo ‑nu bɔ 'yenazë 'ka; 'kɛɛ 'kpongtaamɛ ‑nu ꞊zuö' 'glu ‑dho dhi. Ka ‑dho kë 'yenazë 'dhö, 'kɛɛ ka ‑bha 'yena ‑wun bhë ‑yö ‑dho gla ꞊zuögludhi ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","‑Ka ‑dhɛ ‑ga 'dhɛ! 'Wun bhë ‑a ꞊tɛi' ꞊ga ꞊nɛ: Koyiga ꞊ya dhebɔ 'kun, ‑a ꞊zuö' ‑yö ‑kaan 'kuë; 'ö tɔɔ 'töng 'ö‑ 'yënng dho bhɔa bhë ꞊ya ‑lo. 'Kɛɛ ꞊ya yën 'bë bho ‑sü ‑bha, 'ö‑ ‑zlö ‑yö ‑trö 'yënngbhɔdhe bhë ‑a 'ka, 'ö tɔɔ ‑a ꞊zuö' 'glu ꞊ya dhi mɛ 'bhee‑ 'ö‑ ‑da 'kpongtaa bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","‑Kɔ do gia‑ bhë 'ö‑ 'ka 'pö ꞊dɛɛ. 'Ö tɔɔ ka ‑de 'pö ka ꞊zuö' ꞊ya ꞊kaan' 'kuë. 'Kɛɛ a ‑dho yɛ n 'zü. ‑Yö n 'gü ꞊nɛ ‑a yi bhë ‑a 'ka, ka ꞊zuö' 'glu ‑dho dhi; mɛ gbɛ ‑kɔ 'ka 'dho ‑mɔa kö ꞊zuögludhi 'ö dho kë ka ‑gɔ bhë, ‑ya 'kun ka ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Yi bhë ꞊ya kë ꞊nɛ ꞊ya ‑lo, ꞊dhɛɛkpɔdhe gbɛ 'ka 'dho kë ‑dhö 'wun gbɛ ‑wun 'gü gbɔ. A‑ ‑pö ka ‑dhë 'wun gia‑ 'ka: Pë 'oo pë 'ka‑ ‑dhɛ n Dë ‑gɔ n 'tɔ 'gü, ‑yö ‑dho ‑a nu ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","'Ö yö ꞊dɛɛ ‑bha, kaa pë gbɛ ‑dhɛ n Dë ‑gɔ do n 'tɔ 'gü ꞊kun. ‑Ka pë ‑gba ‑dhɛ 'dhɛ! Ka ‑dho ‑a yö; ꞊ya kë 'dhö ka ‑bha ꞊zuögludhi ‑dho ‑mɔ 'kuë.» ");
INSERT INTO dnj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","'Ö Yesu ‑ya pö ‑an ‑dhë 'zü: «'Wun ‑nu 'a‑ ꞊blɛɛ ka ‑dhë 'saadhö bhë, a ‑an ‑kë 'dhö 'wun ꞊zuan' 'ka. 'Kɛɛ ‑a 'töng ‑yö nu ‑na 'ö n 'ka 'dho 'wun ꞊zuan' ‑zɔn ka ‑dhë, 'wun ‑blɛɛ ka ‑dhë ‑sü 'ka; ‑a yi bhë ‑a 'ka, 'wun ‑nu 'wo ‑gban n Dë ‑bha, a ‑dho ‑an ꞊blɛɛ'‑ ka ‑dhë 'puu 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Yi bhë ꞊ya kë ꞊nɛ ꞊ya ‑lo, ka ‑dho pë ‑nu ‑dhɛ n Dë ‑gɔ n 'tɔ 'gü; n ‑ma ‑wun 'ka 'dho kë ‑a ‑bha ‑dewo kö 'a ꞊bhɛa' ‑a ‑dhë 'zü pë 'ka‑ ‑dhɛ bhë ‑a ‑wun 'gü kö ‑yaan ꞊tun ‑a nu ‑na ka ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","'Ö tɔɔ n Dë ‑de gia‑ ‑yö ka ‑dhɔ ‑kë. Ka ‑dhɔ ‑ya ‑kë, 'ö tɔɔ n ‑dhɔ ‑yö ka ‑kë, 'ö 'ka‑ ‑dhɛ 'wun gia‑ ꞊nɛ a ‑go ‑Zlan 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A ‑go n Dë 'piö, 'a nu 'kpongtaa zö. 'Kɛɛ a 'go ‑na 'kpongtaa, a 'dho ‑na n Dë 'piö.» ");
INSERT INTO dnj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ ‑bha ꞊guë' ‑nu ‑wa pö ‑a ‑dhë: «꞊Nnn'‑, 'wun ꞊ga 'ü‑ ꞊blɛɛ' ‑na 'puu 'ka bhë. ‑A mɛ bhë 'yaa 'wun ꞊zuan' 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Dɔ 'kwa‑ wo ꞊nɛ, ꞊ya kë yi 'yaan 'sabla ꞊nɛ ü pë 'plɛ ‑dɔ, 'ö ü ‑bha ‑wun 'yaa‑ ‑bha kö 'yi ü ꞊dhɛɛ' 'kpɔ 'zü 'wun 'bhaa ‑wun 'ka. ‑A ‑wun 'gü, yi‑ ‑dhɛ 'wun gia‑ ꞊nɛ ü ‑go ‑Zlan 'piö 'ü nu.» ");
INSERT INTO dnj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ ꞊nɛɛ: «'Ka‑ ‑wun ‑dhɛ 'wun gia‑ 'sabla ‑a? ");
INSERT INTO dnj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","꞊Ao'; 'kɛɛ ‑a yi ‑yö nu ‑na, 'ö‑ ‑de ꞊ya ‑lo 'saadhö, 'ö 'ka dho kan n ‑zü, mɛ 'ö ‑dhö, ‑yaan 'dho ö ꞊plöö kö 'kaan‑ n 'to 'sloo 'ka. 'Kɛɛ kë‑ wo 'dhö bhë, 'maa n 'sloo 'ka, 'wun gia‑ 'ka, bhii n Dë ‑yö n 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Pë ‑nu 'wo bhë, a‑ ‑pö ka ‑dhë 'dhö 'saadhö ‑yö kë 'dhö kö ka ‑bha ‑klu n ‑ma ‑sü 'gü, ꞊zuöyagluu ‑yaan kë ka ‑gɔ. Ka 'yënng ‑dho bhɔ 'kpongtaa zö. 'Kɛɛ ‑ka ka 'gü dɔ 'gbee‑! 'Ma 'to ‑a 'gbee‑ 'ka ‑gludë 'ö 'kpongtaa zö bhë ‑a ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","꞊Dhɛ ꞊ya 'wun ꞊blɛɛ'‑ ‑an ‑dhë 'dhö, 'ö ‑dhɛ ‑ga dhang‑ 'gü ꞊zian', 'ö‑ pö: «N Dë, 'töng 'ü‑ ‑ya bhë ꞊ya ‑lo. ‑Bhö 'tɔbhɔdhe nu ü Gbö ‑dhë kö ü Gbö ‑yaan 'tɔbhɔdhe nu ü ‑dhë 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Bhii 'bha ‑kɔ ‑mɔ 'wuën‑ ‑sü nu ‑a ‑dhë mɛ 'kpɛkpɛ ‑ta, ‑yö kë 'dhö kö mɛ ‑nu 'ü ‑an nu ‑a ‑dhë 'saadhö bhë ‑yaan ꞊toëpö ‑këdhösü nu ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","꞊Toëpö ‑këdhösü 'ö bhë 'ö tɔɔ kö ‑waan ü dɔ, bhi 'ü ‑Zlan dosɛn 'ö giagia 'ka bhë 'iin kö Yesu Klito 'ü‑ bɔ bhë ‑waan ‑a dɔ 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","'Ma‑ kë, ü 'tɔ ꞊ya bhɔ 'kpongtaa. Yuö 'ü‑ dɔ n kwɛɛ kö 'aan‑ kë bhë ꞊ya yën. ");
INSERT INTO dnj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","'Kɛɛ n Dë, 'tɔbhɔdhe 'ö ‑kë n ‑gɔ ü 'piö 'ma kö 'kpongtaadhɛ ‑de yaa kë ꞊kun bhë, ‑a nu n ‑dhë ü wö 'dhiö zö. ");
INSERT INTO dnj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mɛ ‑nu 'ü ‑an bho 'kpongtaa 'ü ‑an nu n ‑dhë bhë, 'ma‑ kë ꞊wa ü dɔ. ‑Wo ‑kë ü ‑bha 'ka ‑be; 'ö ꞊dhɛ 'bha ‑an nu n ‑dhë bhë, ꞊wa ü ‑wo ‑nu ꞊bhlë ‑ya. ");
INSERT INTO dnj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","꞊Ya kë ‑an 'yaan ꞊nɛ pë ‑nu 'ü‑ nu n ‑dhë 'saadhö bhë ‑yö ‑go ü 'piö, ");
INSERT INTO dnj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","bhii ‑wo ‑nu 'ü‑ 'kluën bho n ‑ma ‑an ‑bha 'ka bhë, ‑a 'plɛ ꞊ya ‑lo ‑an ‑ta; 'yö ꞊wa wo ‑kɔ 'kpɔ ‑a ‑gɔ. ꞊Dhɛ ‑kë 'dhö ꞊waa‑ yö 'wun gia‑ 'ka ꞊nɛ a ‑go ü 'piö, bhi ꞊nɛ 'ü n bɔ. ");
INSERT INTO dnj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","A ‑bhɛa ü ‑dhë ‑an ‑wun 'gü. N 'ka‑ pö 'kpongtaamɛ ‑nu. A‑ ‑pö mɛ ‑nu 'ü ‑an nu n ‑dhë bhë, bhii ‑wo ü ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pë ‑nu 'wo n ‑gɔ 'saadhö, ‑wo ü ‑bha 'ka; 'ö pë ‑nu 'wo ü ‑gɔ 'pö 'saadhö, 'wo n ‑ma 'ka. 'Go mü 'ö n ‑ma 'tɔbhɔdhe ‑yö bɔ ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","'Maa 'kpongtaa zö gbɔ, 'kɛɛ wo ‑zë, ‑wo ꞊tun zö. A nu ‑na ü 'piö 'ma. ꞊Dhɛ 'ö 'dhö, n Dë 'slööslö, ü ‑zo kë ‑an 'piö, ü 'tɔ 'piigbeezë bhë ‑a 'ka, ‑yö kë 'dhö kö ‑waan kë do ꞊nɛ ‑kɔ 'ö 'ko‑ 'ka do bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","꞊Dhɛ 'a ꞊tun ‑an 'piö, 'tɔ 'ü‑ nu n ‑dhë bhë ꞊nɛ 'a n ‑zo ‑kë ‑an 'piö ‑a ‑bha 'piigbeedhɛ 'ka. A n ‑zo ‑kë ‑an 'piö, 'ö ‑an mɛ gbɛ yaa ꞊dhɔng, ‑a 'ke yaa kë mɛ 'ö dho kë dhɔng ‑mɛ 'ka bhë ‑a 'ka, ꞊nɛ ‑kɔ 'ö pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö‑ pöë bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","'Kɛɛ a nu ‑na ü 'piö 'ma. 'Wun ‑nu 'wo ꞊nɛ a ‑an ‑blɛɛ 'dhö ꞊dhɛ ‑kë ꞊nɛ a ꞊tun 'kpongtaa zö bhë, ‑yö kë 'dhö kö ma ꞊zuögludhi 'ö 'fɛfɛdhö bhë ‑yö kë ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","‑Wo ‑nu 'ü‑ 'kluën bho n ‑ma bhë ꞊nɛ 'a‑ ‑lo ‑an kwɛɛ. Yö ꞊ga 'ö 'kpongtaamɛ ‑nu 'dhö ‑an ‑san zë ‑na bhë, bhii ‑dhɛ 'ö ꞊wa wo ‑kɔ 'kpɔ ‑a ‑gɔ bhë, 'waa 'kpongtaadhɛ ‑bha 'ka gbɔ ꞊nɛ ‑kɔ do 'a‑ 'ka bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A ‑bhɛa ü ‑dhë. N 'ka‑ pö 'ü ‑an ‑bho 'kpongtaamɛ ‑nu ziën, 'kɛɛ a‑ ‑pö 'ü ‑an ‑maa kë dü ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","'Waa 'kpongtaadhɛ ‑bha 'ka ꞊nɛ ‑kɔ gia‑ 'ö 'maa‑ 'ka 'kpongtaadhɛ ‑bha 'ka bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","‑Bhöë kë kö ‑wo kë ü ‑bha 'ka ö 'plɛ 'ka, ü ‑wo 'ö 'wun gia‑ 'ka bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","'Ma ‑an bɔ 'kpongtaamɛ ‑nu ziën ꞊nɛ ‑kɔ 'ö 'ü n bɔa 'kpongtaa bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","'Ma n ‑de nu ü ‑dhë n 'plɛ 'ka (kö pë 'ö ‑dhi ü ‑dhë 'ü‑ kë n 'ka), ‑an ‑bha 'wun ‑së ‑wun 'gü, ‑yö kë 'dhö kö wo ‑zë ‑wo ‑ya ‑de ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","꞊Bhɛa' 'a‑ wo ‑na ꞊nɛɛ, 'yaa wo do 'sloo ‑an ‑wun 'gü; a ‑bhɛa mɛ ‑nu 'ö 'wo dho n ‑wun ‑dhɛ 'wun gia‑, ‑an 'wun ꞊blɛɛ' ‑wo ‑bha bhë ‑an ‑wun 'gü 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","A ꞊bhɛa kö wo 'saadhö ‑wo kë mɛ ‑lü do 'ka. N Dë, ‑bhöë kë kö ‑wo kpa kwa ‑bha, 'kwa kë ꞊nɛ mɛ ‑lü do 'dhö ꞊nɛ ‑kɔ 'ü‑ 'ka ‑ya ‑sü 'ka n 'gü, 'ö ma ‑de 'pö 'a‑ 'ka ü 'gü bhë ‑a 'dhö. ‑Wo kë do kö 'kpongtaamɛ ‑nu ‑waan ‑a ‑dhɛ 'wun gia‑ ꞊nɛ bhi ꞊nɛ 'ü n bɔ. ");
INSERT INTO dnj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","'Tɔbhɔdhe 'ü‑ nu n ‑dhë bhë, 'ma‑ nu ‑an ‑dhë ‑yö kë 'dhö kö ‑waan kë do ꞊nɛ ‑kɔ 'ö bhi 'dhö, ma 'dhö, 'ko‑ 'ka bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","'Ö bhii a ‑ya ‑sü 'ka ‑an 'gü, 'ö bhi ‑de 'pö, ü ‑ya ‑sü 'ka n 'gü kö ‑waan kë mɛ ‑lü do 'ka 'iin kö 'kpongtaamɛ ‑nu ‑waan ‑a yö ‑an ‑gɔ ꞊nɛ bhi ꞊nɛ 'ü n bɔ 'ö 'ü ‑an ‑dhɔ ‑kë ꞊nɛ ‑kɔ 'ö 'ü n ‑dhɔ ꞊kaa' bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","N Dë, 'bha ‑an nu n ‑dhë. ‑Yö 'dhö, 'kɛɛ a‑ 'piö kö ‑dhɛ 'a dho ‑da ‑a ‑bha bhë, ‑wo ‑da mü, kö 'tɔbhɔdhe 'ü‑ nu n ‑dhë bhë ‑waan ‑a ‑dhɛ yö, 'ö tɔɔ ü n ‑dhɔ ‑kë ‑a ‑de kö 'kpongtaadhɛ yaa kë ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","N Dë, bhi 'ü kpengdhö, 'kpongtaamɛ ‑nu 'waa ü dɔ; 'kɛɛ ma ‑zë, a ü ‑dɔ. 'Go mü mɛ ‑nu 'ü‑ nu n ‑dhë, 'ö 'wo ꞊nɛ bhë, ‑wa ꞊tɛi' ‑dɔ ꞊nɛ bhi ꞊nɛ 'ü n bɔ. ");
INSERT INTO dnj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Ma‑ kë ꞊wa ü dɔ 'ö 'a dho dhoë 'dhiö, ‑yö kë 'dhö kö ‑dhɔ 'ö ü ‑gɔ n buëndhö bhë, ‑yö kë ‑an 'gü 'iin kö ma ‑de gia‑ 'aan‑ ‑ya ‑an 'gü.» ");
INSERT INTO dnj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","꞊Dhɛ Yesu ꞊ya 'wun ꞊blɛɛ'‑ 'dhö, yö 'dhö, ö ‑bha ꞊guë' ‑nu 'dhö, ‑wo ‑ziö 'wo dho 'yiga 'wo‑ ‑dhɛ Sedrɔn bhë ‑a ꞊zlöö ꞊zian'. 'Lüdhɛɛdhɛ do ‑yö ‑kë 'ma ('ö ꞊ya kë 'ö mɛ ‑nu ‑wo dho wo 'tɛɛ pa ꞊dhia ‑a 'gü). ‑Dhɛ bhë ꞊nɛ 'ö Yesu waa‑ ö ‑bha ꞊guë' ‑nu 'wo dho ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesu ‑bha ꞊guë' ‑nu 'wo bhë ‑a mɛ 'wo‑ ‑dhɛ Zuda, 'ö yö ꞊nɛ 'ö Yesu 'dhɔɔ dɔ bhë, ‑dhɛ bhë ‑ya ‑dɔ 'pö, 'ö tɔɔ 'dhiö ꞊zian', waa‑ Yesu ‑nu ꞊ya kë ‑wo ‑dho mü ‑kplawo wo 'kuë. ");
INSERT INTO dnj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","'Yö Zuda ‑yö dho 'lüdhɛɛdhɛ bhë ‑a ‑bha, yö 'dhö, 'dhasi ‑nu 'dhö, waa‑ ‑dhɛ ‑maakëmɛ ‑nu 'ö slabhomɛ ‑gɔmɛ ‑nu waa‑ Falizi ‑mɛ ‑nu ‑wa yö ‑an 'piö bhë ‑nu, 'wo dho. 'Gbia ‑nu, ꞊labang ‑nu, ‑piö ‑nu, ‑wo ‑kë ‑an kwɛɛ 'wo dhoë. ");
INSERT INTO dnj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kë‑ wo 'dhö bhë, pë ‑nu bhë Yesu ‑yö ‑an 'plɛ ‑naa ‑dɔ. ꞊Dhɛ ꞊ya kë 'dhö, 'ö ꞊yɔɔn ‑an ‑bha, 'ö ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Dö 'pö 'ka‑ ꞊mɛɛ' ‑na bhë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","'Wo‑ ‑da ‑kë ‑a ‑gɔ, 'wo‑ pö: «Nazalɛtë mi 'wo‑ ‑dhɛ Yesu bhë 'yi‑ ꞊mɛɛ' ‑na bhë.» 'Ö Yesu ‑ya pö ‑an ‑dhë: «Ma ꞊ga 'a ꞊nɛ!» Zuda 'ö‑ 'dhɔɔ dɔ bhë, ‑yö ‑kë mɛ 'wo nu bhë ‑an 'piö mü 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","꞊Dhɛ Yesu ‑ya pö ‑an ‑dhë «ma ꞊ga 'a ꞊nɛ,» 'yö 'wo bhɔ wo züë 'ö 'wo ‑püö sia‑. ");
INSERT INTO dnj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","'Ö Yesu ‑yö ‑an ꞊dhɛɛ' kpɔ 'zü ‑dëüwo ꞊nɛɛ: «Dö 'pö 'ka‑ ꞊mɛɛ' ‑na bhë?» 'Wo‑ pö: «Nazalɛtë mi 'wo‑ ‑dhɛ Yesu.» ");
INSERT INTO dnj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","'Ö Yesu ‑ya pö ‑an ‑dhë: «'Ma‑ pö ka ‑dhë 'saadhö ꞊nɛ ma ‑mü. ꞊Ɛɛ, 'ö ꞊ya kë ꞊nɛ ma 'ka n ꞊mɛɛ' ‑na bhë kö ‑ka ka ꞊kwaa'‑ mɛ ‑nu 'wo to ꞊nɛ ‑an ‑zü ‑wo 'dho.» ");
INSERT INTO dnj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","'Wun ꞊blɛɛ' ‑kɔ ꞊suu'‑ bhë, Yesu ‑ya ‑wo 'dhö ‑yö kë 'dhö ‑a ‑de ‑wo 'ö‑ pö 'dhiö 'ö ‑kë: «N Dë, mɛ ‑nu 'ü‑ nu n ‑dhë bhë, n 'ka n ꞊kwaa'‑ ‑an ‑zü ‑an mɛ do ‑de 'gü yaa ꞊siö'‑» 'ka bhë, kö ‑a 'dhiö ‑yaan ‑mɔ 'kuë. ‑Kɔ bhë ꞊nɛ 'ö ꞊kaa', 'ö ‑Zlan 'dhi ‑wo pö ‑wo bhë 'ö‑ ‑wun 'dhiö ‑yö ‑mɔ ‑a 'ka 'kuë. ");
INSERT INTO dnj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","꞊Dhɛ 'ö 'wun ‑nu bhë 'wo kë ‑na 'dhö, ‑blaan do ‑yö ‑kë Simɔ Piɛɛ ‑gɔ. ꞊Dhɛ ꞊ya kë 'dhö, 'ö‑ ‑gan; ‑a ‑zuö 'ö‑ wo bhë 'ö slabhomɛ ꞊va ‑bha yuökëmɛ 'wo‑ ‑dhɛ Maakisö bhë 'ö ‑a ꞊kwɛɛ‑ 'gü 'tonëga 'kan 'wa 'dödhö. ");
INSERT INTO dnj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö Piɛɛ ‑dhë: «‑Bhö ü ‑bha ‑blaan ‑da ö ‑kloo 'gü. ‑Yö ü ‑zo 'piö ꞊nɛ 'yënngbhɔdhe 'yi ‑kɔɔ 'ö n Dë ‑ya nu n ‑dhë bhë n 'ka 'dhoë‑ mü ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","꞊Dhɛ ꞊ya kë 'dhö, 'yö 'dhasi ‑nu 'wo nu bhë waa‑ wo ‑gɔmɛ 'dhö, 'yan ‑kë ‑dhɛ ‑bha ‑mɛ ‑nu 'wo bhë 'dhö, wo 'plɛ 'wo ‑lo Yesu ‑bha, 'wo‑ ‑lö ꞊bhüö' 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","'Wo dho ‑a 'ka Anë ‑gɔ kɔɔ ‑blɛɛzë 'ka. Anë bhë, Kaifö 'ö ‑kë slabhomɛ ꞊va 'ka ‑kwɛ bhë ‑a 'ka bhë ‑a bɔɔ dë ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","'Yö Kaifö bhë, yö ‑de 'pö, kë‑ wo 'dhiö bhë, yö ꞊nɛ 'ö‑ pö Zuifö ‑nu ‑gɔmɛ ‑nu ‑dhë ꞊nɛɛ: «꞊Yö ‑së kö mɛ do ‑yö ga 'ö ꞊zië' 'sɛgɔ ‑todhösü 'gü ‑mɛ ‑nu ꞊siö' ‑sü ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","꞊Dhɛ 'wo 'dho ‑na Yesu 'ka, Simɔ Piɛɛ waa‑ ꞊guë' ‑nu 'wo bhë ‑a mɛ do ‑wo ‑to ‑an 'piö. Mɛ 'ö waa‑ Piɛɛ 'wo to wo 'ko 'piö 'wo dho bhë, slabhomɛ ꞊va ‑ya ‑dɔ. Pë ‑kë 'ö ‑dhɛ 'wo ‑da ‑na Yesu 'ka 'kwɛandhö mü, 'ö yö ‑de 'pö 'ö ‑da kɔɔ 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","'Kɛɛ Piɛɛ ‑yö ‑to plaan 'kɔ 'dhiö; 'ö ꞊guë' mɛ 'ö ‑da kɔɔ ꞊sia bhë, 'ö dho 'yan ‑to 'kɔdhi ‑bha ‑dhe 'ö ‑kë mü ‑a 'piö plaan, 'ö 'wun ꞊blɛɛ ‑a ‑dhë, 'ö ‑da Piɛɛ 'ka 'kwɛandhö mü. ");
INSERT INTO dnj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","'Yö dhebɔ bhë 'yö Piɛɛ ꞊dhɛɛ' kpɔ ꞊woë' ꞊nɛɛ: «Bhi ‑de 'pö, gɔɔn‑ ꞊nɛ ‑a ‑bha ꞊guë' ‑nu bhë ‑an do kun ü 'ka a?» 'Ö Piɛɛ ‑ya pö ‑a ‑dhë: «‑Abi', 'maa‑ 'piö.» ");
INSERT INTO dnj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","꞊Dhɛ 'ö 'nɛnɛ 'dhö kë ‑na 'gbee‑, 'ö yuökëmɛ ‑nu waa‑ 'kɔdhi ‑maakëmɛ ‑nu ‑wo 'siö 'gba ‑da 'ö wo 'plɛ 'wo dho ‑a ‑maa 'nɛnɛ bho ꞊dhia. Piɛɛ ‑yö ‑kë ‑an 'piö mü 'pö 'nɛnɛ bho ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","꞊Dhɛ ꞊ya kë 'dhö, 'ö Anë 'ö ‑kë slabhomɛ ꞊va zii 'ka bhë, 'yö Yesu ꞊dhɛɛ' kpɔ ‑a ‑bha ꞊guë' ‑nu ‑wun waa‑ ‑a ‑bha mɛ ꞊daan' ‑wo ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","'Ö Yesu ‑ya pö ‑a ‑dhë: «A 'wun ‑blɛɛ 'dhëëdhɛ ‑nu 'gü mɛ 'plɛ ‑dhë; ‑dhɛ ‑nu ꞊ya kë 'ö Zuifö ‑wo dho ‑a ‑bha 'kuëdhö ꞊nɛ ‑Zlan ‑gba ‑a 'gü ‑kɔ 'iin ‑bhɔkuëkɔ ‑nu 'gü ‑dhɛ ‑nu 'dhö bhë ꞊nɛ ꞊ya kë 'a 'wun ‑nu ꞊blɛɛ ‑an ‑bha. N 'ka 'wun gbɛ ꞊blɛɛ'‑ ‑bin ‑blü. ");
INSERT INTO dnj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","꞊Ya kë 'dhö, ‑më ‑wun ü‑ ꞊dhɛɛ' ‑gban n ‑ma 'gbödhö ꞊ee? Mɛ ‑nu 'wo wo 'to to n ‑wo ‑nu ‑bha bhë ‑an ꞊dhɛɛ' 'kpɔ 'dhɛ! 'Wun ‑nu 'a‑ ꞊blɛɛ, ‑wa ‑dɔ ‑së 'ka.» ");
INSERT INTO dnj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","‑Yö ‑to 'wun ꞊blɛɛ' ꞊dhia 'ö 'yan ‑to 'kɔdhi ‑bha ‑mɛ do ‑ya ‑gɔ ‑ma 'wa 'gböüdhö, ‑a ‑kë 'fɛfɛ ‑sü 'ka, 'ö‑ pö: «'Wun ‑daa kë ‑kɔ ꞊suu'‑ bhë ü‑ ‑wo 'dhö ꞊dhë slabhomɛ ꞊va ‑gɔ ꞊ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","'Ö Yesu ‑ya pö ‑a ‑dhë: «‑Wo ‑mlë 'ö 'wun ‑daa kë ‑kɔ yaa 'ka mü ii? ‑A ‑zɔn n ‑dhë, 'yaa 'dhö kö ü n ‑gɔ ‑ma 'kpaan?» ");
INSERT INTO dnj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","'Wun bhë ‑a ‑gɔ yaa kë ‑dhö gbɔ, 'ö Anë ‑ya to ‑lö ‑sü 'ka 'dhö 'ö‑ bɔ Kaifö 'ö ‑kë slabhomɛ ꞊va 'ka ‑kwɛ bhë ‑a 'ka bhë ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","꞊Dhɛ pë ‑nu bhë 'wo kë ‑na 'dhö, kö Piɛɛ ‑yö 'nɛnɛ bho ꞊dhia. 'Wo‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Bhi ‑de 'pö 'bhaa gɔɔn‑ ꞊nɛ ‑a ‑bha ꞊guë' ‑nu do 'ka a?» 'Ö Piɛɛ ‑yö ꞊kploo ꞊woë' ꞊nɛɛ: «‑Abi', 'maa‑ 'piö.» ");
INSERT INTO dnj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gɔɔn‑ do ‑yö ‑kë mü, 'ö ‑kë slabhomɛ ꞊va ‑bha yuökëmɛ do 'ka. Yö ꞊nɛ 'ö Piɛɛ ‑ya dheglu 'tonëga 'klu ‑kan bhë. 'Yö Piɛɛ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Kaa‑ gɔɔn‑ bhë ka ‑nu kaa kë ka 'ko 'piö 'lüdhɛɛdhö; 'yaa 'dhö a?» ");
INSERT INTO dnj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","'Yö Piɛɛ ‑ya ‑daa ‑kë ‑a ‑gɔ 'zü ꞊nɛɛ: «'Wun gia‑ 'yaa ‑mü.» ‑Dhɛ do bhë 'wo to ‑a ‑bha 'ö ‑tɔ gɔn ‑yö ‑we. ");
INSERT INTO dnj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","꞊Dhɛ ꞊ya kë 'dhö, 'wo go Yesu 'ka Kaifö ‑gɔ kɔɔ, 'wo dho ‑a 'ka 'sɛ ꞊kɔɔnmɛ 'ö Wlɔmë ‑mɛ ‑nu ‑wa ‑ya 'sɛgɔ 'ö bhë ‑a ‑ta bhë ‑a ‑gɔ 'kwɛandhö. ꞊Dhɛ 'wun ‑nu bhë 'wo kë ‑na 'dhö, kö 'kwa dɔ ‑dhiadhiö tii 'gü. ‑A ‑kë 'dhö ‑sü 'ka, Zuifö ‑gɔmɛ ‑nu waa ‑da ‑a 'ka Pilatö ‑gɔ kɔɔ mü 'ö bhii kö ꞊wa wo ‑de kë ‑dhiizë ‑be wo ‑bha wɔ ‑kɔ 'gü ‑Zlan wö 'dhiö; kö wo 'ka 'dho Paakö 'wlaan‑ ‑bhöpë ‑bhö ꞊nɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","'Ö‑ ‑wun 'gü, 'ö 'sɛ ꞊kɔɔnmɛ Pilatö ‑yö yö plaan, 'ö dho ‑an ‑gɔ zian‑, 'ö ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «‑Më ‑wun 'ö 'ka‑ dɔ gɔɔn‑ ꞊nɛ ‑a ‑bha ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","'Wo‑ ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «Yaa kë këpëyaamɛ 'ka ‑bezë, yi 'ka 'dho nuë ü ꞊dhia.» ");
INSERT INTO dnj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","'Ö Pilatö ‑ya pö ‑an ‑dhë: «Ka ‑de gia‑ ka dhoë, 'ka‑ ‑wun ꞊blɛɛ'‑ ꞊nɛ ‑kɔ 'ö ka ‑bha tɔng ‑nu 'dhoë‑ 'ka bhë ‑a 'dhö.» 'Ö Zuifö ‑nu ‑gɔmɛ ‑nu ‑wa pö ‑a ‑dhë: «Tɔng yaa‑ pö yi ‑dhë 'yi mɛ zë.» ");
INSERT INTO dnj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kë‑ wo 'dhiö ꞊zian' bhë, Yesu ‑yö 'wun ‑gban ö ‑bha ga ‑kɔ ‑bha 'ö‑ ꞊blɛɛ; yö ꞊nɛ 'ö ‑de 'dhoë‑ kë bhë. ");
INSERT INTO dnj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","'Yö Pilatö ‑yö ‑sɔ kɔɔ, 'ö Yesu ꞊dhɔɔ ‑kë, 'ö‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Ü Zuifö ‑nu ‑bha ‑gludë 'ka a?» ");
INSERT INTO dnj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","'Ö Yesu ‑ya ‑daa ‑kë 'ö‑ pö: «‑A pö 'ü‑ wo 'dhö bhë ü ‑zo 'pö 'ü‑ ‑ta 'wun bhë ‑a 'gü yö ‑mü 'iin ü‑ ‑pö ꞊nɛ ‑kɔ 'wo‑ ꞊blɛɛ ‑a 'ka ü ‑dhë ‑a 'dhö ee?» ");
INSERT INTO dnj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","'Ö Pilatö ‑ya ‑daa ‑kë 'ö‑ pö: «'Maa Zuifö 'ka; bhi gia‑ ü‑ ‑yö; 'kɛɛ ü ‑sɛgümɛ ‑nu waa‑ slabhomɛ ‑gɔmɛ ‑nu ‑wo nu ü 'ka 'wo ü dɔ n kwɛɛ 'sa; ꞊ya kë 'dhö kö ‑më 'ü‑ ‑kë ‑ɛɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","'Ö Yesu ‑ya ‑daa ‑kë 'ö‑ pö: «Ma ‑gludëdhɛ yaa 'go 'kpongtaa zö. ꞊Ya kë ꞊nɛ ma ‑gludëdhɛ ‑yö ‑go 'kpongtaa zö ‑bezë, ma yuökëmɛ ‑nu ‑wo ‑dho 'ko ‑zë ‑be mɛ ‑nu 'wo nu kö ‑waan n 'kun bhë ‑an 'ka, kö ꞊kun 'wo dho n dɔ 'sɛ ꞊kɔɔnmɛ ‑nu kwɛɛ. 'Kɛɛ ‑abi', ma ‑gludëdhɛ yaa 'go 'kpongtaa zö.» ");
INSERT INTO dnj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","'Ö Pilatö ‑ya ꞊dhɛɛ' kpɔ ꞊woë' ꞊nɛɛ: «꞊Ya kë 'dhö kö ‑gludë ‑mü ü 'ka a?» 'Ö Yesu ‑ya pö: «꞊Ii‑, ‑gludë ‑mü n 'ka. A ‑bhɔ 'a nu 'kpongtaa zö kö 'aan‑ 'wun gia‑ 'gü ‑wun ꞊blɛɛ'‑ mɛ ‑nu ‑dhë. Mɛ 'ö 'ta sü 'wun gia‑ 'gü, ‑yö ö 'to ‑kë n ‑wo ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","'Yö Pilatö ‑ya pö: «‑Më tɔɔ 'wun gia‑ 'gbödhö ꞊e?» ꞊Dhɛ Pilatö waa‑ Yesu ꞊wa 'dɔɔ 'bhle dɔ 'dhö, 'ö Pilatö ‑yö yö plaan Zuifö ‑nu 'piö, 'ö‑ pö ‑an ‑dhë: «'Maa 'wun 'ö dho kë ga ‑za ‑lo gɔɔn‑ 'ö ꞊nɛ ‑a tuö ‑gɛn 'ka ‑a yö ‑na. ");
INSERT INTO dnj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","'Kɛɛ ꞊dhɛ ‑kë ꞊nɛ ‑kwɛ 'saadhö 'ka, ka‑ ‑dhɛ n ‑gɔ kö 'a mɛ do bho ‑kanso 'gü ka ‑dhë ka ‑bha Paakö 'wlaan‑ ‑yi 'ka bhë, ka‑ 'piö kö Zuifö ‑nu ‑bha ‑gludë bhë 'a n ꞊kwaa' ‑a ‑zü ka ‑dhë ‑a?» ");
INSERT INTO dnj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","꞊Aa', 'wo yö ꞊gblaa 'gbla ‑sü ‑bha ꞊nɛɛ: «‑Abi', ‑abi', 'yiëë‑ 'piö! ‑Bhö Balaba ‑zë bho mü yi ‑dhë!» Balaba 'ö bhë, kë‑ wo bhë, ‑yö ‑kë këpëyaamɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","꞊Dhɛ ꞊ya kë 'dhö, 'ö Pilatö ‑ya pö 'dhasi ‑nu ‑dhë ‑wo 'dho Yesu 'ka, ‑wa ‑ma ‑klaa 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","'Yö 'dhasi ‑nu ‑wo 'ginng 'gɔ ꞊gblaa' ‑pë ‑kë 'wo‑ ‑ya Yesu tuö; 'wo gblang nuɛazë do sü 'wo‑ ‑da ‑a ‑bha (‑gludëdhɛ ‑kwaa). ");
INSERT INTO dnj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","꞊Dhɛ ꞊waa‑ kë 'dhö, 'wo ꞊yɔɔn ‑a ‑bha 'wo‑ pö ‑a ‑dhë: «Zuifö ‑nu ‑bha ‑gludë, 'bha ꞊büee!» ꞊Waa‑ kë 'dhö, ꞊waa‑ kë 'dhö, 'wo‑ ‑gɔ ‑ma. ");
INSERT INTO dnj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","'Ö Pilatö ‑yö yö plaan 'zü ‑dëüwo, 'ö‑ pö mɛ gbung 'wo ‑kë mü bhë ‑an ‑dhë: «‑Ka ka 'to 'to, a 'dhoë‑ nuë ka ꞊dhia plaan zö kö ka ‑de 'kaan‑ yö ꞊nɛ 'maa za ‑lo ‑a tuö ‑gɛn yö ‑na kö ‑yaan kë ‑a zë ‑gɛn 'ka bhoo‑!» ");
INSERT INTO dnj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","'Wo nu Yesu 'ka ‑an 'dhiö mü; 'gɔ ꞊gblaa' ‑yö ‑kë ‑a tuö, sɔ nuɛazë ‑yö ‑kë ‑a ‑bha. 'Ö Pilatö ‑ya pö ‑an ‑dhë: «Yö ꞊ga ꞊nɛ! ‑Kaa ‑ga bhë 'dhɛ!» ");
INSERT INTO dnj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","'Yö ꞊dhɛ slabhomɛ ‑nu ‑gɔmɛ ‑nu waa‑ 'yan ‑to 'kɔdhi ‑bha ‑mɛ ‑nu ꞊waa‑ yö, 'wo yö ꞊gblaa 'gbla ‑sü ‑bha ꞊woë' ꞊nɛɛ: «‑A dɔ ‑gaatalü ‑bha! ‑A dɔ ‑gaatalü ‑bha!» 'Ö Pilatö ‑ya pö ‑an ‑dhë: «꞊Ɛɛ, ka gia‑ ‑kaa 'kun, 'ka dhoë, 'ka‑ dɔ ‑gaatalü ‑bha, 'ö bhii ma ‑zë 'maa‑ zë ‑gɛn yö ‑na.» ");
INSERT INTO dnj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","'Yö Zuifö ‑nu ‑wa pö ‑a ‑dhë: «Tɔng do ‑yö yi ‑gɔ 'ö ꞊yaa‑ ‑lö 'gü; yö ꞊nɛ 'ö tɔɔ ‑a zë ‑gɛn; 'ö bhii ‑ya pö yö ꞊nɛ 'ö tɔɔ ‑Zlan Gbö.» ");
INSERT INTO dnj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","꞊Dhɛ ‑wo bhë Pilatö ꞊yaa‑ ma, 'ö 'suö ‑yö ‑kan ‑a 'gluu. ");
INSERT INTO dnj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","'Yö ‑da kɔɔ 'ö Yesu ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Ü ‑go 'më 'ü nu ꞊ii?» 'Kɛɛ Yesu yaa ‑daa gbɛ kë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","'Ö Pilatö ‑ya pö ‑a ‑dhë: «Ü 'ka 'dho we n ꞊woë' ꞊a? 'Kɛɛ ‑yö kë ü 'yaan ꞊nɛ ma do ꞊nɛ, ‑dhɛ 'ü dɔ ‑a ‑bha zlöö ꞊nɛ 'a ‑mɔ ‑a ‑bha kö 'a ‑potaasü nu ü ‑dhë 'iin 'a‑ pö mɛ ‑nu ‑dhë ‑wo ü dɔ ‑gaatalü ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü ‑kɔ 'yaa ‑mɔ pë gbɛ ‑bha ‑a 'ke yaa kë 'wun ‑nu 'ö ‑Zlan ‑yö ‑an ‑wun ‑lo ü kwɛɛ ‑an 'ka. Pë 'ö ‑kë 'ö mɛ 'ö n dɔ ü kwɛɛ bhë 'ö za ‑bha ‑lo ‑a tuö ‑sü bhë 'ö ‑ziö ü ‑bha ‑ta 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","꞊Dhɛ Yesu ‑yö 'wun ꞊blɛɛ 'dhö zlöö, Pilatö ‑yö ‑kë ‑a 'slë ꞊mɛɛ' ꞊dhia zlöö kö ‑yaan ‑potaasü nu Yesu ‑dhë. 'Kɛɛ ꞊dhɛ ꞊ya 'dho Zuifö ‑nu 'dhiö 'zü 'wun do bhë ‑a 'ka 'yö 'wo yö ꞊gblaa 'gbla ‑sü ‑bha ꞊woë' ꞊nɛɛ: «꞊Ya kë ꞊nɛ mɛ bhë 'bha ü ꞊kwaa'‑ ‑a ‑zü, kö 'bhaa ‑gludë ꞊va 'bhamɛ 'ka gbɔ! 'Ö bhii mɛ 'oo mɛ 'ö‑ pö ö ‑gludë 'ka kö ꞊ya kë ‑gludë ꞊va 'ö Wlɔmë bhë ‑a yaagümɛ 'ka ꞊nɛ bhë!» ");
INSERT INTO dnj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","꞊Dhɛ Pilatö ꞊ya ‑wo ‑nu bhë ‑an ma 'dhö, 'ö‑ pö ‑wo nu Yesu 'ka 'dhëëdhö. 'Ö yö ‑zë 'ö ꞊yaannu zakanmɛ ‑bha ‑gbloo 'gü. ‑Dhɛ bhë ‑wa ‑dhɛ Eblö ‑wo 'gü «Gabata». ");
INSERT INTO dnj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","‑Yö ‑kë Paakö ‑waamayi 'ka, kö lan‑ ꞊ya dɔ mɛ ‑gɔ ziën. 'Yö Pilatö ‑ya pö Zuifö ‑nu ‑dhë: «Ka ‑bha ‑gludë bhë ꞊ga ꞊nɛ!» ");
INSERT INTO dnj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","'Yö 'wo yö ꞊gblaa 'gbla ‑sü ‑bha 'zü ꞊woë' ꞊nɛɛ: «‑A zë! ‑A zë! ‑A dɔ ‑gaatalü ‑bha!» 'Yö Pilatö ‑yö ‑an ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Ka‑ 'piö kö 'a ka ‑bha ‑gludë dɔ ‑gaatalü ‑bha ‑a?» 'Ö slabhomɛ ‑nu ‑gɔmɛ ‑nu ‑wa ‑daa ‑kë ‑a ‑gɔ ꞊nɛɛ: «꞊Ya 'kan ‑gludë ꞊va 'ö Wlɔmë ‑a ‑bha, ‑gludë gbɛ 'yaa yi ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","꞊Dhɛ ꞊ya kë 'dhö, 'ö Pilatö ‑yö Yesu dɔ ‑an kwɛɛ kö ‑wo 'dho ‑a 'ka, ‑wa dɔ ‑gaatalü ‑bha. 'Wo dho Yesu 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu gia‑ ꞊nɛ 'yö ö ‑bha ‑gaatalü bun kö ‑wo 'dho ‑na pö‑ ꞊taa. 'Wo dho 'wo ‑lo ‑dhɛ do 'wo‑ ‑dhɛ Eblö ‑wo 'gü «Gɔɔgota» bhë ‑a ‑bha (꞊waa‑ pö 'dhö kö ‑wa ‑pö «mɛ ‑gɔ ‑klëë ‑lo ‑dhɛ»). ");
INSERT INTO dnj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","‑Dhɛ bhë ꞊nɛ 'ö 'dhasi ‑nu ‑wo Yesu dɔ ‑a ‑bha ‑gaatalü ‑bha. Mɛ ꞊plɛ 'waa gbɛ ‑wo ‑kë mü, 'ö 'wo ‑an dɔ ‑gaatalü ‑bha 'pö; 'wo mɛ do dɔ Yesu ꞊kwɛɛ‑ 'gü, 'wo‑ mɛ do dɔ ‑a ꞊kwaa‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","'Yö Pilatö ‑ya pö ‑wo 'lü 'fa 'sü ‑wa zë ‑gɛn ‑yaa ‑ta kö ‑wo ꞊taanga ‑gban ‑a ‑ta ‑a ‑gɔ dhuö zian ꞊woë' ꞊nɛɛ: «Yesu, Nazalɛtë mi, Zuifö ‑nu ‑bha ‑gludë.» ");
INSERT INTO dnj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Zuifö ‑nu ‑wo ‑kë ꞊va 'ö ‑wo bhë 'wo‑ pö 'ö bhii ‑dhɛ 'wo Yesu dɔ ‑a ‑bha ‑gaatalü ‑bha bhë, yaa kë pö‑ 'ka ꞊gbiin; 'ö pë 'wo‑ ‑ya 'pö bhë 'ö ‑kë Eblö ‑wo 'gü, 'wo‑ ‑ya Latɛn ‑wo 'gü, 'wo‑ ‑ya Glɛkö ‑wo 'gü 'zü. ");
INSERT INTO dnj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","꞊Dhɛ ꞊ya kë 'dhö, 'ö slabhomɛ ‑nu ‑gɔmɛ ‑wo dho Pilatö 'piö 'wo‑ pö ‑a ‑dhë: «‑Wo 'ü‑ ‑ya ‹Zuifö ‑nu ‑bha ‑gludë› 'ka bhë, kö ꞊kun 'ü‑ to 'dhö; pë 'ü dhoë‑ ‑ya ‑be 'ö tɔɔ ‹gɔɔn‑ ꞊nɛ ‑ya ‑pö: Ma ꞊nɛ 'a tɔɔ Zuifö ‑nu ‑bha ‑gludë›.» ");
INSERT INTO dnj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","'Ö Pilatö ‑ya pö ‑an ‑dhë: «Pë 'ö 'ma‑ ‑ya 'saadhö, ‑yö ‑dho to ‑ya ‑sü 'ka 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","꞊Dhɛ 'dhasi ‑nu ꞊wa yën Yesu ‑dɔ ‑gaatalü ‑bha ‑sü ‑bha, 'wo‑ ‑bha sɔ ‑nu sü 'wo‑ ‑kan 'kou ‑yiisië, 'ö mɛ 'ö ‑dhö 'ö ö ‑bha sü. 'Yö 'wo‑ ‑bha gblang sü 'pö. Gblang 'ö bhë ‑a ‑wɔ ‑pin gbɛ yaa kë ‑a ‑bha. ‑Yö ‑kë bɔ ‑sü 'ka 'dhö do 'ö goë dhuö 'ö yöë sia‑. ");
INSERT INTO dnj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","'Yö ꞊dhɛ ꞊waa‑ ‑dhɛ yö 'dhö, 'wo‑ pö wo 'ko ‑nu ‑dhë: «‑Ka dɔ; sɔ mɛ ꞊nɛ, kö ꞊kun 'kwa‑ ‑blë, 'kɛɛ ‑kwa 'töü‑ ‑bhö kö mɛ 'ö dho to ‑a ‑gɔ, 'kwaan‑ dɔ.» ‑Kɔ bhë ꞊nɛ 'ö pë 'ö ‑kë ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü, 'ö‑ 'dhiö ‑mɔ ‑a 'ka 'kuë, 'ö bhii ‑yö ꞊bɛɛn' ‑sü 'ka ꞊nɛɛ: ‑Wo ma sɔ ‑nu ‑glu wo 'kuë, 'wo 'töü‑ ‑bhö ma sɔ ‑ta. ");
INSERT INTO dnj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","꞊Dhɛ 'wo Yesu dɔ ‑gaatalü ‑bha, ‑a dhe 'dhö, ‑a dhe dheglu 'nëdhe 'dhö, Mali 'ö ‑kë Kleopasö bɔɔ 'ka bhë 'dhö, waa‑ Mali 'ö go Madala ‑wo ‑kë dɔ ‑sü 'ka ‑a 'sɔɔ. ");
INSERT INTO dnj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑yö ‑kpën ö dhe ‑bha kö ‑a ‑bha ꞊guë' ‑nu 'wo bhë ‑a mɛ 'ö‑ ‑dhɔ ‑ya ‑kë ꞊duö ‑yö dɔ ‑sü 'ka ‑a 'sɔɔ mü, 'yö‑ pö ö dhe ‑dhë: «N dhe, ü gbö ꞊ga dɔ bhë.» ");
INSERT INTO dnj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","'Yö‑ pö 'pö ꞊guë' 'ö bhë ‑a ‑dhë: «Ü dhe ꞊ga 'ö bhë.» ‑Dhɛ 'ö go ‑a ‑bha 'ö ꞊guë' 'ö bhë 'ö Yesu dhe kpa ö ‑bha, 'ö to ‑a ꞊plöö zlöö 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","꞊Dhɛ 'wun ‑nu bhë ꞊wa kë 'dhö, 'ö Yesu yö ‑de gia‑ ꞊yaa‑ yö ꞊nɛ pë 'plɛ 'dhiö ꞊ya ‑mɔ 'kuë 'ö‑ pö: «A ‑dho 'yi mü» ꞊nɛ ‑kɔ 'ö ꞊bɛɛn' ‑sü 'ka ‑a 'ka (‑Zlan ‑bha 'sëëdhɛ 'gü) ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","‑Guö 'lɔɔ‑ ꞊fië' do 'ö ‑drɔɔn 'yi ‑ya pa ‑yö ‑kë mü. 'Wo 'lü 'wo‑ ‑dhɛ izɔpö bhë 'wo‑ ‑kɔ 'në sü, 'wo ꞊fuu'‑ ‑ya ‑a 'dhiö. ꞊Dhɛ ꞊waa‑ zë ‑drɔɔn 'yi bhë ‑a 'ka, 'wo‑ ‑zɔn ‑a 'dhi ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","'Ö ‑yɛ ‑a nɛ‑ ‑bha, 'ö‑ pö: «Pë 'plɛ 'dhiö ꞊ya ‑mɔ 'kuë.» ꞊Dhɛ ꞊yaa‑ pö 'dhö, 'ö‑ ‑gɔ ꞊yɔɔ, 'ö ga. ");
INSERT INTO dnj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","'Wun ‑nu bhë ‑wo ‑kë 'dhö Zuifö ‑nu ‑bha ꞊glooyi ‑waamayi 'ka, 'ö waa 'we ‑a ‑bha kö Yesu waa‑ mɛ ‑nu 'wo bhë ‑wo 'to ‑gaatalü ‑bha mü kö ꞊glooyi ‑yö ‑lo ‑a 'ka; 'ö tɔɔ ꞊glooyi mɛ 'ö bhë ‑a ‑wun ‑yö ‑kë ‑an ‑gɔ 'gbee‑. 'Yö 'wo dho Pilatö 'piö 'wo‑ pö ‑a ‑dhë ‑ya pö ö ‑bha 'dhasi ‑nu ‑dhë ‑wo mɛ ‑nu 'wo dɔ ‑sü 'ka ‑gaatalü ‑bha bhë ‑an 'gban 'yɛ, kö ꞊ya kë ꞊nɛ ꞊wa ga, ‑waan ‑an bho ‑gaatalü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'Yö ö ‑bha 'dhasi ‑nu bɔ, 'wo dho; 'yö ꞊dhɛ mɛ ꞊plɛ 'wo ‑an dɔ ‑gaatalü ‑bha Yesu 'sɔɔ bhë 'ö ꞊wa ‑an 'gban 'yɛ. ");
INSERT INTO dnj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","'Ö ꞊wa yö Yesu ‑bha, 'wo‑ yö ꞊nɛ ꞊ya ga 'saadhö. ꞊Dhɛ ‑kë 'dhö, waa‑ ‑a ‑gɛn ‑nu 'yɛ gbɔ. ");
INSERT INTO dnj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","'Kɛɛ 'dhasi do ‑yö ö ‑bha 'dü ‑gban ‑a 'sɛn 'piö 'ö‑ zlɔa 'Ö to mü 'yi waa‑ fɛi 'wo go ‑a 'sɛn 'piö 'wo ‑lo. ");
INSERT INTO dnj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mɛ 'ö pë ‑nu 'wo ꞊nɛ 'ö ‑an ‑ya ꞊nɛ, ‑wo pë ‑nu bhë ‑a ‑kë ‑a 'yaan 'ka; 'ö pë ‑nu 'ö ‑an ‑ya bhë, 'ö 'wo 'wun gia‑ 'ka. Yö gia‑ ‑ya ꞊tɛi' dɔ ꞊nɛ 'wun gia‑ ‑mü. 'Ö ‑an ‑ya 'dhö kö ka ‑de 'pö 'kaan‑ bɔ ‑a ‑ta 'kaan‑ ‑a ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bhii pë ‑nu 'wo bhë ‑wo kë 'dhö kö pë 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ‑a 'dhiö ‑yaan ‑mɔ 'kuë. 'Ö tɔɔ ‑yö ꞊bɛɛn' ‑sü 'ka ꞊nɛɛ: Waa 'dho ‑a dɔ gbɛ yɛ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","'Yö ꞊bɛɛn' ‑sü 'ka ‑dhɛ 'bhaa 'gü 'zü ꞊nɛɛ: Mɛ 'ö 'wo‑ zlɔa 'dü 'ka ‑a 'sɛn ‑bha bhë ꞊nɛ 'ö ‑an 'yan dho to ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","꞊Dhɛ pë ‑nu bhë ꞊wa kë 'dhö, gɔɔn‑ do ‑yö ‑kë ‑dhö 'wo‑ ‑dhɛ Zozɛfu, 'ö ‑kë Alimate mi 'ka; ‑yö ‑nu Pilatö 'piö 'ö Yesu ꞊glöö ‑dhɛ ‑a ‑gɔ kö ‑yaan 'dho ‑yaan ‑a ‑bin. Zozɛfu 'ö bhë ‑yö ‑kë ‑to Yesu 'piö ‑mɛ do 'ka, 'kɛɛ ‑ya ‑kë 'dhö ‑bindhɛ 'gü, 'ö tɔɔ ‑yö ‑suö Zuifö ‑nu ‑gɔmɛ ‑nu ‑dhë. 'Ö Pilatö ‑yö ‑we ‑a ‑bha ‑a ‑gɔ. 'Ö dho 'ö Yesu ꞊glöö sü 'ö ‑ziö ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Gɔɔn‑ do ‑yö ‑kë mü 'pö 'wo‑ ‑dhɛ Nikodɛmö. Yö ꞊nɛ 'ö dho yi do 'ka Yesu 'piö gbeng ꞊dhɛɛ' 'ka bhë. Yö ‑de 'pö, yi ‑de gia‑ bhë ‑a 'ka, 'yɔn 'wo‑ 'kpɔ ‑na wo ‑bha ꞊nɛ ‑a ꞊suu'‑ do 'bhaa ꞊sɔnng' 'gbeezë 'ö ‑kë aloɛ waa‑ 'miilö ‑an 'ka bhë, ‑ya 'kilong 'gɔɔ‑ ‑yaaga ‑sü 'ö dho ‑a 'ka Zozɛfu 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","'Yö 'wo ‑lo 'kuë‑ 'wo pë 'yi bhë 'wo‑ sü, 'wo sɔ 'pɛn sü, 'wo Yesu ꞊glöö ꞊baa ‑a 'ka ꞊nɛ ‑kɔ 'ö 'wo‑ kë ‑na ‑a 'ka Zuifö ‑nu wɔ ‑kɔ 'gü bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","꞊Dhɛ 'ö 'wo Yesu dɔ ‑a ‑bha ‑gaatalü ‑bha bhë, 'lüdhɛɛdhɛ do ‑yö ‑kë ‑a 'sɔɔ mü. 'Lüdhɛɛdhɛ bhë ꞊nɛ 'ö ‑guö ‑du do ‑dëü 'ö waa mɛ ‑bin ‑a 'gü do ꞊kun ‑yö ‑kë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","꞊Dhɛ ‑kë ꞊nɛ ‑yö ‑kë Zuifö ‑nu ‑bha ꞊glooyi ‑waamayi 'ka, 'ö ‑guö ‑du bhë yaa kë 'ma ꞊gbiin, 'wo dho Yesu ꞊glöö 'ka 'wo‑ ‑wɛɛ bho. ");
INSERT INTO dnj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","꞊Dhɛ 'ö Zuifö ‑nu ‑bha ꞊glooyi ‑ta ‑dhɛ ꞊ya 'po, 'ö Mali 'go Madala ‑yö ‑so ‑dhiadhiö tii 'gü, 'ö dho blɔɔn‑ ꞊taa. ꞊Dhɛ ꞊ya 'dho ꞊ya ‑lo 'ma, 'ö‑ yö ꞊nɛ ‑guö 'fa 'ö 'wo‑ yö ‑guö ‑du bhë ‑a 'dhiö bhë, ꞊ya 'go ‑a 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","'Yö ‑ziö ‑bla 'ka 'ö dho Simɔ Piɛɛ waa‑ ꞊guë' mɛ 'ö‑ ‑dhɔ ‑yö Yesu ‑kë ꞊duö bhë ‑an 'piö, 'ö‑ pö ‑an ‑dhë: «꞊Wa kwa Dëmɛ bho ‑a blɔɔn‑ 'gü ꞊wa dhoë ‑dhɛ gbɛ 'gü, 'ö 'kwaa‑ ‑dhɛ dɔ 'pö 'sa.» ");
INSERT INTO dnj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","'Yö Piɛɛ waa‑ ꞊guë' mɛ bhë 'wo ‑ziö, 'wo dho blɔɔn‑ ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","'Dho 'wo ‑kë ‑a wo ꞊dhia bhë, ‑yö ‑kë ‑bla 'ka 'wo‑ sü; 'kɛɛ ꞊guë' 'ö bhë ‑yö ö ‑bha ‑sü 'gbee‑ 'ka 'ö dhoë Piɛɛ 'dhiö blɔɔn‑ ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","꞊Dhɛ ꞊ya ‑lo 'ma, 'yö ꞊kloo 'ö ‑dhɛ ‑ga ‑guö ꞊duudhö mü. 'Yö sɔ 'pɛn ‑nu 'wo‑ ꞊ploo Yesu 'ka bhë, 'yö‑ yö sia‑ mü. 'Kɛɛ yaa 'to mü yaa ‑da kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","'Ö Simɔ ‑yö ‑lo mü, 'yö ‑da blɔɔn‑ 'gü; 'yö sɔ 'pɛn ‑nu bhë ‑an yö sia‑ mü. ");
INSERT INTO dnj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sɔ 'wo‑ kpa Yesu ‑gɔ ‑bha 'pö bhë ‑yö ‑kë mü 'pö, 'kɛɛ yaa kë sɔ 'pɛn ‑nu 'wo bhë ‑an 'piö. ‑Yö ‑kë ‑ya ‑sü 'ka kpöë ‑de ‑ta ‑dhɛ gbɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","꞊Dhɛ ꞊ya kë 'dhö, 'ö ꞊guë' mɛ 'ö ‑lo 'dhiö ꞊sia bhë, 'ö ‑da blɔɔn‑ 'gü mü 'pö. ꞊Dhɛ 'ö‑ 'yan ‑ya ‑da pë ‑nu 'wo bhë ‑an ‑ta 'dhö, 'ö‑ ꞊tɛi' dɔ ö ꞊zuö' 'gü ꞊nɛ Yesu ꞊ya 'go ga 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","'Kɛɛ kë‑ wo 'dhö bhë, ‑Zlan ‑bha 'sëëdhɛ ꞊bɛɛn' ‑yan 'ö ‑kë Yesu ‑yö ‑dho go ga 'gü 'ka bhë, ꞊guë' ‑nu 'wo bhë kö waa‑ ‑gɛn ma ‑a ‑gɛn ma ‑kɔ gia‑ 'ka ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","꞊Dhɛ ꞊ya kë 'dhö, 'ö ꞊guë' ‑nu ꞊plɛ 'wo bhë 'wo ‑yɛ wo 'zü, 'wo dho wo ꞊plöö. ");
INSERT INTO dnj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","꞊Dhɛ pë ‑nu 'wo bhë ꞊wa kë 'dhö, Mali 'go Madala bhë, ‑yö ‑dho 'ma 'zü; 'ö dɔ plaan 'gbo bɔ ‑sü 'ka. 'Yö ꞊kloo kö ‑yaan ‑dhɛ ‑ga blɔɔn‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","'Yö‑ 'yan ‑yö ‑da ‑Zlan ‑bha bɔmɛ ‑nu ꞊plɛ ‑ta kö ‑wo ‑ya ‑sü 'ka ‑dhɛ 'ö Yesu ꞊glöö ‑yö ‑kë ‑a ‑bha bhë ‑a ‑bha; sɔ 'puu ‑yö ‑kë ‑an ‑bha. ‑A mɛ do ‑yö ‑kë ‑dhɛ 'ö bɔ Yesu ‑gɔ bɔ ‑dhɛ 'ka bhë ‑a ‑bha, 'ö‑ mɛ do 'bhaa ‑yö ‑kë 'pian 'ö Yesu ‑gɛn ‑yö bɔa bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","'Ö ‑Zlan ‑bha bɔmɛ ‑nu ‑wa ꞊dhɛɛ' kpɔ ꞊woë' ꞊nɛɛ: «Dhebɔ, ‑më 'ü‑ ‑gbo bɔ ꞊ɛ?» 'Ö‑ ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «N Dëmɛ bho 'wo‑ wo zö ꞊nɛ, ‑dhɛ 'wo dhoë ‑a ‑bha, 'maa‑ dɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","'Yö ꞊dhɛ ꞊yaa‑ pö 'dhö, 'yö ‑dhɛ ‑ga ö ꞊zlöö; 'ö Yesu yö kö ‑yö ꞊gbaannu ꞊süë' mü, 'kɛɛ yaa‑ ꞊tɛi' dɔ ꞊nɛ Yesu ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","'Ö Yesu ‑ya ꞊dhɛɛ' kpɔ 'ö‑ pö: «Dhebɔ, ‑më 'ü‑ ‑gbo bɔ ‑na ꞊nɛ ꞊ɛ? Dö 'ü‑ ꞊mɛɛ?» ꞊Dhɛ ‑kë 'dhö, ‑yö ‑kë ‑a ‑zo 'piö ꞊nɛ 'lüdhɛɛdhɛ bhë ‑a ‑yuökëmɛ ‑mü; 'yö‑ pö ‑a ‑dhë: «꞊Ya kë ꞊nɛ bhi ꞊nɛ 'ü‑ sü 'ü ‑ziö ‑a 'ka, ‑bhöë pö n ‑dhë kö 'aan‑ dho 'aan‑ 'sü.» ");
INSERT INTO dnj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","'Ö Yesu ‑ya pö ‑a ‑dhë: «Mali!» ꞊Dhɛ ‑kë 'dhö 'ö ꞊luu 'ö ꞊sië ‑a 'piö, 'ö‑ pö ‑a ‑dhë Eblö ‑wo 'gü: «Labuni!» (꞊Waa‑ pö 'dhö kö ‑wa ‑pö «‑Gɔmɛ».) ");
INSERT INTO dnj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","'Ö Yesu ‑ya pö ‑a ‑dhë: «Kö ꞊kun 'ü n kuënnu, bhii n 'ka dho n Dë 'piö dhuö ꞊kun. 'Kɛɛ ‑bhö 'dho 'ü‑ pö n dhegluzë ‑nu ‑dhë a 'dho ‑na n Dë 'ö ka Dë 'ka, n ‑ma ‑Zlan 'ö ka ‑bha ‑Zlan 'ka 'pö bhë ‑a 'piö.» ");
INSERT INTO dnj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","꞊Dhɛ ꞊ya kë 'dhö, 'ö Mali 'ö go Madala bhë 'ö ‑ziö, 'ö dho ꞊guë' ‑nu 'piö 'ö‑ pö ‑an ‑dhë: «'Ma Dëmɛ yö!» 'Ö 'wun ‑nu 'ö‑ ꞊blɛɛ ‑a ‑dhë bhë 'ö‑ 'plɛ ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Yi gia‑ bhë ‑a 'yinia 'piö, Yesu ‑bha ꞊guë' ‑nu ‑wo ‑kë wo 'kuë‑ 'kɔ do 'gü. 'Yö 'wo 'kɔdhi ‑nu ‑zuö wo ‑blü bhii 'suö ‑yö ‑an ‑kë Zuifö ‑nu ‑dhë. ꞊Dhɛ 'wo dho ‑a ‑ga kö Yesu ꞊ya ‑wo ‑an ziën mü. 'Yö‑ pö ‑an ‑dhë: «꞊Zuöyagluu ‑yö kë ka ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","꞊Dhɛ ꞊ya 'wun ꞊blɛɛ'‑ ‑an ‑dhë 'dhö, 'ö ö ‑kɔ ‑nu waa‑ ö 'sɛn 'piö ‑dhɛ ‑zɔn ‑an ‑dhë. 'Ö ‑an ꞊zuö' 'glu ‑yö dhi Dëmɛ yö 'wo‑ wo bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","'Yö Yesu ‑ya pö ‑an ‑dhë 'zü: «꞊Zuöyagluu ‑yö kë ka ‑gɔ! ‑Kɔ do gia‑ 'ö n Dë ‑yö n bɔ ‑a 'ka 'a nuë ka 'piö bhë, ma ‑de 'pö 'ma ka bɔ.» ");
INSERT INTO dnj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","꞊Dhɛ ꞊ya ‑wo ‑nu 'wo bhë ‑a pö ‑an ‑dhë 'dhö, 'ö 'tëë ‑piö ‑an ‑bha 'ö‑ pö: «‑Zuu 'slööslö 'a‑ nu ka ‑dhë bhë! ");
INSERT INTO dnj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mɛ ‑nu 'ö 'ka 'dhoë‑ ziö ‑an ‑bha ꞊sɔɔn yaa ‑nu ‑ta, ‑Zlan ‑dho ziö ‑an ‑bha ꞊sɔɔn yaa 'ö bhë ‑a ‑ta; mɛ ‑nu 'ö 'ka dho ‑an ‑bha ꞊sɔɔn yaa ‑wun ‑nu ‑lo ‑an tuö, ‑Zlan 'ka 'dhö ziö ‑an ‑bha ꞊sɔɔn yaa 'ö bhë ‑a ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","꞊Dhɛ 'ö pë ‑nu bhë 'wo kë ‑na 'dhö, kö Yesu ꞊ya nu ö ‑bha mɛ ‑nu ziën bhë, ꞊guë' ‑nu 'gɔɔ‑ do ö ꞊ga ꞊plɛ 'wo bhë ‑a mɛ 'wo‑ ‑dhɛ Toma 'wo‑ 'tɔ kpɔ ‑Flɛan 'ka bhë, yaa kë mü. ");
INSERT INTO dnj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","꞊Dhɛ ꞊ya 'yɛ ö 'zü ꞊ya nu, 'ö‑ 'bhamɛ ‑nu ‑wa pö ‑a ‑dhë: «'Yië kwa Dëmɛ yö.» 'Yö Toma ‑ya pö: «꞊Ya kë ꞊nɛ ꞊taanga pin ‑nu 'wo‑ ‑kɔ ‑nu ‑bha n 'ka n 'yan dɔ ‑an ‑bha, 'ö n 'ka n ‑kɔnëga ‑sɔ ‑a pin ‑nu 'wo bhë ‑an 'piö, 'iin ‑a 'sɛn 'piö ‑dhɛ 'wo‑ zlɔa bhë 'ö n 'ka n ‑kɔ ‑sɔ ‑a 'piö, kö pë 'ka‑ pö ‑na bhë n 'ka‑ ‑dhɛ 'wun gia‑.» ");
INSERT INTO dnj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","꞊Dhɛ 'dhɔɔgɔ do ꞊ya ziö, Yesu ‑bha ꞊guë' ‑nu ‑wo ‑kë wo 'kuë‑ 'zü 'kɔ bhë ‑a 'gü kö ꞊wa 'kɔdhi ‑nu ‑zuö wo ‑blü, 'ö Yesu ‑yö ‑da ‑an 'piö kɔɔ 'ö dɔ ‑an ziën. Toma ‑yö ‑kë ‑an 'piö yi bhë ‑a 'ka. 'Yö Yesu ‑ya pö ‑an ‑dhë: «꞊Zuöwaannudhe ‑yö kë ka ‑gɔ!» ");
INSERT INTO dnj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'Yö‑ pö Toma ‑dhë: «‑Dhɛ ‑ga zö 'dhɛ! Ü ‑kɔnëga 'pa ma bhüö pin ‑nu 'ka n kwɛɛ 'dhɛ! Ü ‑kɔ ‑sɔ n 'sɛn 'piö 'dhɛ! ‑Bhö ü bo ‑kɔ pë ‑nu 'wo bhë ‑an ‑dhɛ 'wun gia‑ ‑sü 'ka 'ü n ‑wun ‑dhɛ 'wun gia‑!» ");
INSERT INTO dnj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","'Yö Toma ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «N Dëmɛ, ma ‑Zlan!» ");
INSERT INTO dnj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","'Ö Yesu ‑ya pö ‑a ‑dhë: «꞊Dhɛ ‑kë ꞊nɛ 'bha n yö bhë, 'ü n ‑ma ‑go ga 'gü ‑sü ‑wun ‑dhɛ 'wun gia‑ bhë ɔɔ? 'Kɛɛ mɛ ‑nu 'ö waa n yö 'ö 'wo n ‑wun ‑dhɛ 'wun gia‑ bhë, ‑an ‑bha ꞊yö ‑së!» ");
INSERT INTO dnj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Kë‑ wo bhë Yesu ‑yö ‑dhidhaapë ꞊plëëzë 'bhaa ‑nu ‑kë ö ‑bha ꞊guë' ‑nu 'yan 'dhiö, 'kɛɛ 'waa ‑ya ‑sü 'ka 'sëëdhɛ ꞊nɛ ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","'Kɛɛ ‑an mɛ ‑nu 'wo ‑ya ‑sü 'ka zö bhë, ‑wo ‑ya 'dhö kö Yesu ‑bha ‑kë ‑Zlan ‑bha ‑Yamɛ, ‑a Gbö 'ka ‑sü 'ö bhë 'kaan‑ ‑dhɛ 'wun gia‑, 'iin kö ‑zo ‑yö ‑a ‑bha ‑sü do 'ö bhë 'kaan‑ bɔ ‑a ‑ta kö ꞊toëpö ‑këdhösü bhë 'kaan‑ ‑a yö. ");
INSERT INTO dnj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","꞊Dhɛ 'töng 'bhaa ꞊ya ziö, Yesu ‑yö ö ‑de ‑zɔn 'zü ö ‑bha ꞊guë' ‑nu ‑dhë, Tibeliasë 'yipuë 'kpong 'dhiö. ‑Kɔ 'ö 'wun bhë 'ö ꞊kaa' ꞊ga ꞊nɛɛ: ");
INSERT INTO dnj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Yi bhë ‑a 'ka, Simɔ Piɛɛ 'dhö, Toma ('wo‑ 'tɔ kpɔ ‑Flɛan 'ka) 'dhö, Natanaɛlö ('ö ‑kë Kana mi 'ka Galile) 'dhö, Zebede gbö ‑nu 'dhö waa‑ Yesu ‑bha ꞊guë' ꞊plɛ 'bhaa ‑wo ‑kë wo 'ko 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","'Ö Simɔ Piɛɛ ‑ya pö: «'Ma 'dho 'kplö ‑zuö ꞊dhia.» 'Yö 'wo‑ pö ‑a ‑dhë: «Kwa ‑nu 'plɛ 'kwa dho dho.» 'Ö wo 'plɛ 'wo dho 'wo ‑da 'yitagɔ 'gü. 'Kɛɛ ꞊dhɛ ꞊wa 'kplö ‑zuö gbeng ‑yi bhë ‑a 'ka, waa pë gbɛ 'sü. ");
INSERT INTO dnj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","꞊Dhɛ 'ö‑ ‑dhɛ 'dhö 'po ‑na, 'ö Yesu ‑yö nu 'yi 'kpong 'dhiö mü. 'Kɛɛ ꞊guë' ‑nu waa‑ ꞊tɛi' dɔ ꞊nɛ yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","'Yö Yesu ‑ya pö ‑an ‑dhë: «‑Dadhëü ‑nu 'ka ‑de, ka 'yuö‑ ‑sü ‑a?» 'Wo‑ pö ‑a ‑dhë: «‑Abi'!» ");
INSERT INTO dnj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","'Yö‑ pö ‑an ‑dhë: «Ka 'kplö ‑zuö 'yitagɔ ꞊kwɛɛ‑ 'gü ꞊zian' 'dhɛ, ka ‑dho 'yuö‑ sü.» 'Yö 'wo 'kplö ‑zuö, 'kɛɛ ‑an ‑kɔ yaa ‑mɔa ‑bha gbɔ kö ‑wa 'gan yiö bhii kö 'yuö‑ ꞊yaa‑ pa. ");
INSERT INTO dnj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","꞊Dhɛ ꞊ya kë 'dhö, 'yö ꞊guë' mɛ 'ö‑ ‑dhɔ Yesu ‑kë ꞊duö bhë, 'ö‑ pö Piɛɛ ‑dhë: «Dëmɛ ‑mü!» ꞊Dhɛ Simɔ Piɛɛ ꞊yaa‑ ma 'dhö, 'ö ö ‑bha gblang ‑da ö ‑bha ‑bla 'ka, 'ö ‑püö 'yiëë‑, 'ö nu 'kpong 'dhiö ꞊zian'. ");
INSERT INTO dnj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","꞊Guë' ‑nu mɛ 'wo to bhë 'wo nu zlöö 'yitagɔ 'gü 'kplö 'ö 'yuö‑ ‑ya pa bhë ‑a 'gan ‑sü 'ka, 'ö bhii ‑dhɛ 'wo ‑kë ‑a ‑bha bhë ‑yö ‑mɔa ‑yö ‑lo ‑gɛn wang ꞊këng' do ‑naa ꞊taa 'yi 'kpong 'dhiö ‑dhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","꞊Dhɛ ꞊wa ‑lo 'kpong 'dhiö, kö 'siö ‑yö ‑da ‑sü 'ka, kö 'yuö‑ waa‑ ꞊bluu'‑ 'klu ‑wo siöö. ");
INSERT INTO dnj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","'Ö Yesu ‑ya pö ‑an ‑dhë: «'Yuö‑ ‑nu 'ka 'go ‑na ‑an 'sü ꞊dhia bhë, ‑ka nu ‑a 'bhaa ‑nu 'ka 'kwee‑!» ");
INSERT INTO dnj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","'Yö Simɔ Piɛɛ ‑yö dho 'ö 'kplö 'ö 'yuö‑ ꞊vava ‑nu ‑wa pa bhë, 'ö‑ ‑gan sia‑; ‑wo ‑kë 'yuö‑ bhɛ ꞊këng' do ö ‑kɔ 'sɔɔdhu waa‑ 'yuö‑ ‑yaaga ‑an 'ka. 'Kɛɛ mɛ 'te 'tun ‑wun 'ö ‑kë mü 'ö tɔɔ 'yuö‑ bhë ‑yö ‑kë ꞊va giagiawo, 'kɛɛ 'kplö bhë yaa 'blë 'sa. ");
INSERT INTO dnj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","꞊Dhɛ ꞊ya kë 'dhö, 'ö Yesu ‑ya pö ‑an ‑dhë: «‑Ka nu 'kwa pë ‑bhö.» 'Kɛɛ mɛ gbɛ yaa kë ‑dhö ‑an ziën kö ‑yaan ꞊dhɛɛ' 'kpɔ ꞊nɛɛ: «Dö ‑mü ü 'ka ɛ?» 'Ö tɔɔ kö ꞊waa‑ ꞊tɛi' dɔ ꞊nɛ Dëmɛ ‑mü. ");
INSERT INTO dnj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","'Yö Yesu ‑yö dho, 'yö ꞊bluu'‑ bhë 'ö‑ sü, 'ö‑ nu ‑an ‑dhë; 'ö 'yuö‑ nu ‑an ‑dhë 'pö. ");
INSERT INTO dnj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","꞊Dhɛ 'ö Yesu ‑yö go ga 'gü bhë, ‑a ‑bha ö ‑de ‑zɔn ö ‑bha ꞊guë' ‑nu ‑dhë ‑sü kë ‑yaaga ‑naa ꞊nɛ 'wo ꞊kaa' bhë. ");
INSERT INTO dnj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","꞊Dhɛ ꞊wa yën pë ‑bhö ‑sü ‑bha, 'ö Yesu ‑ya pö Simɔ Piɛɛ ‑dhë: «Simɔ, Zan gbö, n ‑dhɔ ‑yö ü ‑kë 'ö ‑ziö ‑a 'ka mɛ ‑nu 'wo to ‑an ‑ta ‑a?» 'Ö Simɔ ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «꞊Ii‑, n Dëmɛ; bhi ‑de gia‑ ü‑ ꞊tɛi' ‑dɔ ꞊nɛ ü ‑dhɔ ‑yö n ‑kë.» 'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü ‑zo kë ma 'bhla 'në ‑nu 'piö.» ");
INSERT INTO dnj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","'Yö‑ pö ‑a ‑dhë 'zü ‑gwaa kë ꞊plɛ ‑naa wo: «Simɔ, Zan gbö, n ‑dhɔ ‑yö ü ‑kë ‑a?» 'Ö Piɛɛ ‑ya ‑daa ‑kë 'ö‑ pö: «꞊Ii‑, n Dëmɛ; bhi gia‑ ü‑ ꞊tɛi' ‑dɔ ꞊nɛ ü ‑dhɔ ‑yö n ‑kë.» 'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü ‑zo kë ma 'bhla ‑nu 'piö.» ");
INSERT INTO dnj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","'Yö Yesu ‑ya pö ‑a ‑dhë 'zü ‑gwaa kë ‑yaaga ‑naa wo: «Simɔ, Zan gbö; n ‑dhɔ ‑yö ü ‑kë ‑a?» 'Ö Piɛɛ ‑yö ‑da ꞊zuötozlöödhe 'gü 'tetundhe 'ka ‑a pö 'Ö Yesu ‑ya wo ‑a ‑dhë ‑gwaa ‑yaaga ‑naa wo «n ‑dhɔ ‑yö ü ‑kë ‑a?» bhë ‑a ‑wun 'gü. 'Kɛɛ ‑ya ‑daa ‑kë 'ö‑ pö: «N Dëmɛ, ü pë 'plɛ ‑dɔ; ü‑ ꞊tɛi' ‑dɔ ꞊nɛ ü ‑dhɔ ‑yö n ‑kë.» 'Ö Yesu ‑ya pö ‑a ‑dhë: «Ü ‑zo kë ma 'bhla ‑nu 'piö. ");
INSERT INTO dnj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A‑ ‑pö ü ‑dhë gia‑ 'ka ꞊nɛɛ: ꞊Dhɛ 'ü ꞊tun ‑dadhëü 'ka, (yi mɛ ꞊ya dhi ü ‑dhë,) 'bha ü ‑bha ‑du kwi ‑klu sɔ ‑ta, kö ü 'dho ‑sü ‑mü ‑dhɛ 'ö ‑dhi ü ‑dhë ‑a ‑bha; 'kɛɛ 'bha kë ꞊klöö ꞊sia, ü ‑dho ü ‑kɔ ꞊luu'‑ 'ö mɛ 'kpaan gbɛ ‑yö nu 'ö ü ‑bha ‑du kwi ‑klu ü vɛɛdhö. ꞊Ya kë 'dhö, ‑yö ‑dho dho ü 'ka ‑dhɛ 'ö 'yaa ü ‑zuë ‑a 'ka ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","'Wun bhë ‑a ꞊blɛɛ' 'ö Yesu ‑ya wo 'dhö bhë, ‑yö ‑kë ‑kɔ 'ö Piɛɛ dhö gaa waa‑ ‑a ‑gɔ ‑wun ‑bha ‑kë ‑Zlan 'tɔ bhɔ ‑gɛn 'ka ‑sü ‑wun ꞊blɛɛ' sü 'ka. ꞊Dhɛ ꞊ya kë 'dhö, 'yö‑ pö ‑a ‑dhë: «Ziö n 'piö!» ");
INSERT INTO dnj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","꞊Dhɛ Piɛɛ ꞊ya ꞊dhië' ö ‑zü, 'ö ꞊guë' mɛ 'ö‑ ‑dhɔ ‑yö Yesu ‑kë ꞊duö bhë 'ö‑ yö kö ‑yö nu ‑na wo 'piö. Yö bhë ꞊nɛ kë‑ wo 'töng 'bhaa 'ka kö ‑wo pë ‑bhö ‑na bhë, 'ö waa‑ Yesu 'wo wo ‑gɔ dun, 'ö ꞊dhɛɛ' kpɔ Yesu ‑gɔ 'saan 'gü ꞊nɛɛ: «N Dëmɛ, dö 'ö dho ü 'dhɔɔ dɔ ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","꞊Dhɛ Piɛɛ ꞊yaa‑ yö 'dhö kö ‑yö nu ‑na wo 'piö, 'ö‑ pö Yesu ‑dhë: «N Dëmɛ, mɛ mɛ 'ö ꞊nɛ 'dhe, ‑më 'ö dho kë ‑a 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","'Ö Yesu ‑ya ‑daa ‑kë ‑a ‑gɔ 'ö‑ pö: «꞊Ya dhi n ‑dhë kö ‑a 'yan ‑yö 'to ‑a 'gü ‑yö 'dho ‑yö yöë n ‑yɛ 'zü ‑sü ‑bha, ü ‑bha ‑më ‑wun 'ö‑ 'gü i? Bhi ‑zë, ‑bhö ziö n 'piö!» ");
INSERT INTO dnj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kö dö 'pö dho 'ö ‑taɔ ‑pɛn 'iin kö ‑wa ‑kë ꞊dhë, 'kɛɛ ‑wa ‑pö ‑yö ‑kë dhegluzë ‑nu 'wo bhë ‑an ziën ꞊nɛ ꞊guë' mɛ 'ö bhë yö 'ka 'dho ga. 'Kɛɛ kö Yesu yaa‑ pö Piɛɛ ‑dhë: «Yö 'ka 'dho ga,» 'kɛɛ ‑ya pö ꞊zian': «꞊Ya dhi n ‑dhë kö ‑a 'yan ‑yö 'to ‑a 'gü ‑yö 'dho ‑yö yöë n ‑yɛ 'zü ‑sü ‑bha, ü ‑bha ‑më ‑wun 'ö‑ 'gü i?» ");
INSERT INTO dnj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","꞊Guë' gia‑ bhë ꞊nɛ 'ö 'wun ‑nu 'wo bhë 'saadhö 'ö‑ ‑ya 'sëëdhɛ ꞊nɛ ‑a 'gü; kë‑ wo 'dhö bhë, kwa‑ ꞊tɛi' ‑dɔ ꞊nɛ pë ‑nu 'ö‑ ‑gɛn bho 'saadhö bhë ‑wo 'wun gia‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu ‑yö 'wun ꞊plëëzë 'bhaa ‑nu ‑kë. ꞊Ya kë ꞊nɛ 'kwa‑ pö ‑a 'plɛ ‑yö ‑ya 'sëëdhɛ 'gü, ‑yö ‑kë n 'gü ꞊nɛ ‑a 'sëëdhɛ ‑be ‑nu 'wo bhë ‑an ‑dadhɛ 'ka 'dho kë ‑dhö 'kpongtaa.");
INSERT INTO dnj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","N dheglu Teofilö, ma 'sëëdhɛ ‑be ‑blɛɛzë 'a‑ ꞊bɛɛn ‑a mɛ 'ö ꞊nɛ ‑a 'dhiö bhë Yesu këyuö ‑nu 'töüdhö waa‑ ‑a ‑bha mɛ ꞊daan' ‑wo ‑nu 'wo bhë ꞊nɛ, 'a ‑an ‑ya ‑a 'gü, 'ö sü ‑a ‑bha yuö züdɔyi ‑bha ");
INSERT INTO dnj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","'ö yöë yi 'ö ‑Zlan ‑ya ꞊luu ‑a 'ka 'ö dhoë dhang‑ 'gü ‑a ‑bha, a‑ 'plɛ ‑blɛɛ 'sëëdhɛ ‑be bhë ‑a 'gü. ꞊Dhɛ 'ö 'dhoë‑ dho dhang‑ 'gü, ‑yö ö ‑wo ‑to mɛ ‑nu 'ö ‑an sü ö bha bɔmɛ ‑nu 'ka sia‑ zö bhë ‑an ‑gɔ ‑Zuu 'slööslö ‑bha 'piigbeedhɛ ꞊kwaa'. ");
INSERT INTO dnj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","꞊Dhɛ ꞊ya 'go ga 'gü, ‑yö ö ‑de ‑zɔn ‑an ‑dhë ꞊plëëzë 'ka kpinngdhö, ‑dhɛkpaɔyi 'gɔɔ‑ ‑yiisië 'piö ‑a ‑zɔn ‑sü 'ka ‑an ‑dhë ꞊nɛ ö 'bhee‑. 'Wo‑ yö 'ö 'wun 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ ‑bha 'ö‑ ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yi do 'ka kö Yesu ꞊ya nu ‑an 'piö 'zü ‑dëüwo, wo ‑nu ‑wo ‑kë wo 'ko ꞊bhaa pë ‑bhö ꞊dhia, 'ö‑ pö ‑an ‑dhë: «‑Ka 'to Zeluzalɛmë zö, 'ka ka 'yan 'to pë 'ö n Dë ‑ya 'tɔ go ka ‑dhë, 'a‑ ‑wun ꞊blɛɛ ka ‑dhë bhë ‑a ‑gɔ! ");
INSERT INTO dnj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bhii Zan ‑yö mɛ ‑nu ‑bɔ yiö 'yi 'ka, 'kɛɛ ka ‑zë, ‑a yi 'yaa ꞊gbiin gbɔ, ‑Zlan ‑dho ‑a kë 'ö ka pa ‑Zuu 'slööslö 'ka!» ");
INSERT INTO dnj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","'Yö mɛ ‑nu 'ö waa‑ Yesu ‑nu 'wo ‑kë wo 'ko ꞊bhaa bhë, 'wo‑ ꞊dhɛɛ' kpɔ 'wo‑ pö: «Yi Dëmɛ, ü‑ ‑pö ‑a yi ꞊ya ‑lo kö 'üën‑ ‑gludëdhɛ nu Izlaɛlö 'në ‑nu ‑dhë kö ‑wo 'sɛ 'bhaa ‑nu ꞊kɔɔn ‑a 'ka 'zü ‑dëüwo ꞊a?» (꞊Dhɛɛ' 'ö bhë, ‑wa ‑kpɔ 'dhö 'ö tɔɔ ‑a 'töng bhë ‑a 'ka, ‑wo ‑kë Wlɔmë ‑mɛ ‑nu ‑kɔ ꞊löö.) ");
INSERT INTO dnj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","'Ö Yesu ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «‑Abi', 'go mü 'zü ka ꞊dua' 'yaa ‑mü kö 'ka‑ yi ‑nu waa‑ ‑an 'töng ‑nu 'kaan‑ ‑an dɔ, 'ö tɔɔ n Dë ‑de 'sloo ꞊nɛ 'ö 'wun bhë 'ö‑ kë ‑yi ‑nu, ‑a kë 'töng ‑nu 'plɛ dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","'Kɛɛ ꞊ya kë ꞊nɛ ‑Zuu 'slööslö ꞊ya nu ka ‑ta ꞊sia, ‑Zlan ‑yö ‑dho 'piigbeedhɛ nu ka ‑dhë, kö 'wun 'ö ‑gban n ‑ma 'kaan‑ ‑a ꞊blɛɛ'‑ mɛ ‑nu 'wo Zeluzalɛmë zö, Zude ‑sɛ 'saadhö 'gü ‑mɛ ‑nu waa‑ mɛ ‑nu 'wo Samali ‑sɛ 'gü 'ö dho 'ö yöë 'sɛ ‑nu 'wo 'ma ꞊gbiin ‑an 'gü ‑mɛ ‑nu ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","꞊Dhɛ Yesu ‑yö yën 'wun ‑nu 'wo bhë ‑an ꞊blɛɛ' ‑sü ‑bha, 'ö ꞊luu ‑Zlan ‑bha 'piigbeedhɛ ꞊kwaa' 'ö dho dhang‑ 'gü. ‑Wo ‑to ‑a ‑ga ꞊dhia 'ö dha kpö do ‑yö sɔ ‑a ‑zü. ");
INSERT INTO dnj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","‑An 'yan ‑yö ‑to dhuö, zian 'ö Yesu ‑yö dhoë bhë ‑a 'ka ‑piindhö. ꞊Dhɛ 'wo ‑ga zlöö wo 'sɔɔ, kö ‑Zlan ‑bha bɔmɛ ‑nu ꞊plɛ ‑wo ꞊gbaannu ꞊süë' mü. ");
INSERT INTO dnj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","'Ö ‑Zlan ‑bha bɔmɛ ‑nu ꞊plɛ 'wo bhë 'wo‑ pö ‑an ‑dhë: «Galile ‑mɛ ‑nu 'ka ꞊nɛ, ‑më 'ö ‑kë 'ö 'ka ‑dhɛ ‑ga ‑na dhang‑ 'gü ‑kplawo ꞊nɛ ꞊ɛ? Yesu 'ö 'go ‑na ka ziën 'ö 'dho ‑na dhang‑ 'gü bhë, ‑yö ‑dho yɛ ö 'zü 'ö nu ꞊nɛ ‑kɔ gia‑ 'ö 'dho ‑na ‑a 'ka 'ö 'ka‑ ꞊gaa' ‑a 'ka bhë ‑a 'dhö.» ");
INSERT INTO dnj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","꞊Dhɛ ꞊ya kë 'pö Yesu ‑bha bɔmɛ ‑nu ‑wo ‑go ‑tɔn 'wo‑ ‑dhɛ Olivie ‑tɔn bhë ‑a tuö, 'wo ‑yɛ wo 'zü, 'wo dho Zeluzalɛmë plöö. 'Go Zeluzalɛmë 'ü 'dho Olivie ‑tɔn bhë ‑a tuö ‑yö ‑mɔ 'kilong do ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","꞊Dhɛ 'ö ꞊wa ‑lo Zeluzalɛmë, 'wo dho 'kɔ ‑ta dhuö, 'kɔdhi 'ö ꞊dhɛ ꞊tun 'dhiö, ꞊ya kë 'wo dho wo 'ko ꞊bhaa ‑a 'gü bhë ‑a 'gü. Mɛ 'wo dho mü bhë ‑an 'tɔ ꞊nɛ: Piɛɛ, Zan, Zakö, Andre, Filipö, Toma, Batelemi, Matiö, Zakö 'ö ‑kë Alefe gbö 'ka, Simɔ 'ö 'wo‑ ‑dhɛ 'yënngsiömɛ waa‑ Zudë 'ö Zakö gbö 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","꞊Dhɛ 'wo‑ ‑bha 'saadhö, ‑an ꞊zuö' ‑kë do ꞊bhɛa' ‑sü 'gü ‑kplawo wo 'ko ꞊bhaa. Yesu dhe Mali oo, Yesu dhegluzë ‑nu waa‑ dhoo ‑nu 'bhaa ‑nu ‑wo ‑kë ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yi do 'ka kö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo dho ‑mɔ mɛ ‑lü ꞊këng' do ö ‑kɔ ꞊plɛ ‑bha ꞊wa 'dho 'ko ꞊bhaa bhë, 'ö Piɛɛ ‑yö ꞊luu ‑an 'plɛ 'dhiö mü 'ö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«N dhegluzë ‑nu, pë 'ö ‑Zuu 'slööslö ‑ya ꞊blɛɛ 'dhiö 'ö bɔa Davidö ‑ta 'ö ꞊bɛɛn' ꞊süë' ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö ‑gban Zuda 'ö 'dhiö sü mɛ ‑nu 'wo Yesu kun ‑an 'ka ‑a ‑bha bhë pë 'ö dho kë yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Zuda 'ö bhë ‑yö ‑kë mɛ ‑nu 'kwa ‑kë Yesu 'piö bhë ‑a mɛ do 'ka, 'ö tɔɔ Yesu ‑ya ‑sü kö kwa ‑nu kwa ‑bha yuö 'kwa dho ‑a kë ‑Zlan ‑dhë kö ‑yaan kë do. ");
INSERT INTO dnj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","'Wëüga 'ö ‑kë ‑a ‑bha mɛ zë ꞊saan' 'ka bhë, ‑yö ꞊bhlöödhɛ do ‑dhɔ ‑a 'ka. ꞊Dhɛ ꞊ya kë 'pö, 'ö dho ö ‑gɔ bhlöödhɛ 'ö bhë ‑a ‑bha, ('ö ö ‑de dun). ꞊Dhɛ ꞊ya kë 'dhö, ‑yö ‑püö sia‑, 'ö‑ bun ‑yö wü, 'ö‑ gblëën‑ 'plɛ ‑yö ‑lo plaan 'ö ga. ");
INSERT INTO dnj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mɛ ‑nu 'wo Zeluzalɛmë 'töüdhö, ‑wo 'wun 'ö bhë ‑a ma. Pë 'ö ‑kë 'ö ꞊bhlöödhɛ 'ö bhë 'wo‑ ‑dhɛ wo ‑wo 'gü Akɛlödama (‑a ‑gɛn 'ö tɔɔ ꞊bhlöödhɛ 'ö mɛ fɛi ‑yö ‑lo ‑a 'gü). ");
INSERT INTO dnj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bhii 'wun 'ö ‑gban Zuda ‑bha ‑yö ‑kë ꞊bɛɛn' ‑sü 'ka 'Tan 'sëëdhɛ ‑bha 'sëëdhɛ 'gü 'dhiö ‑a pö ‑sü 'ka ꞊nɛɛ: ‑Wo wo ꞊kwaa'‑ ‑a ‑bha 'kɔ ‑wun ‑zü, 'ö tɔɔ 'kɔ bhë ‑a ꞊kɔɔnmɛ 'yaa 'dhö gbɔ. 'Ö ꞊bɛɛn' ‑sü 'ka 'zü ꞊nɛɛ: Mɛ do ‑yö yö ‑a piën‑! » ");
INSERT INTO dnj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","'Yö Piɛɛ ‑ya pö 'zü: «꞊Dhɛ 'ö 'pö, kö mɛ do ‑yö kpa kwa ‑bha kö ‑yaan kë kwa Dëmɛ Yesu ‑bha ‑go ga 'gü ‑sü ꞊goo‑ do 'ka. Mɛ 'ö 'dhö bhë ‑yö kë mɛ 'ö ‑kë kwa ziën 'töng 'saadhö 'ö kwa Dëmɛ Yesu ‑ya ‑kë 'ö bɔa 'sɛ ‑nu 'gü, 'ö sü yi 'ö Zan ‑ya ‑bɔa yiö 'ö yöë yi 'ö goë kwa ziën 'ö ‑Zlan ‑ya ꞊luu ‑a 'ka dhang‑ 'gü ‑a ‑bha bhë ‑a mɛ do 'ka.» ");
INSERT INTO dnj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","꞊Dhɛ ꞊ya kë 'dhö, 'wo mɛ ꞊plɛ 'tɔ sü: ‑A mɛ do tɔɔ Zozɛfu 'wo‑ ‑dhɛ Baasaba 'wo‑ 'tɔ kpɔ Zutusö 'ka waa‑ Matiasö. ");
INSERT INTO dnj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","꞊Dhɛ 'ö ꞊ya kë 'dhö 'wo ꞊bhɛa, 'wo‑ pö: «Yi Dëmɛ, bhi 'ü mɛ ‑nu 'saadhö ‑an ꞊zuö' dɔ, ‑bhö mɛ ꞊plɛ 'wo ꞊nɛ ‑a mɛ 'ü‑ sü ‑a ‑zɔn yi ‑dhë ");
INSERT INTO dnj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kö ‑yaan yö Zuda piën‑! Bhii 'ö tɔɔ Zuda ‑yö ‑go ö ‑bha yuö 'ö ‑kë ü ‑bha bɔmɛ ‑yuö 'ka bhë ‑a 'dhiö, 'ö dho ‑dhɛ 'ö‑ ꞊tɛi' 'ka bhë ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","'Ö 'wo 'töü‑ ‑bhö, kö mɛ ꞊plɛ 'wo bhë, mɛ 'ö 'töü‑ ꞊yaa‑ 'sü kö ‑waan 'sü. 'ö 'töü‑ ‑yö ‑püö Matiasö ‑ta, 'ö ‑da Yesu ‑bha bɔmɛ ‑nu 'gɔɔ‑ do ö ga do 'wo bhë ‑an 'piö ('wo ‑kë 'zü 'gɔɔ‑ do ö ga ꞊plɛ). ");
INSERT INTO dnj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","꞊Dhɛ 'ö Zuifö ‑nu ‑bha 'wlaan‑ ‑yi 'wo‑ ‑dhɛ Pantëkɔtö ‑yi bhë ꞊ya ‑lo, Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'saadhö ‑wo ‑kë wo 'ko ꞊bhaa 'kɔ do 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","‑Dhɛ do bhë 'wo to ‑a ‑bha 'ö ‑zuö 'ö‑ ‑vinng ‑yö ‑kë ꞊nɛ 'buu 'gbee‑ ‑vinng 'dhö bhë 'ö go dhang‑ 'gü ꞊zian', 'ö mɛ ‑nu 'wo ‑kë 'kɔ bhë ‑a ‑dhɛ 'saadhö 'gü, wo 'plɛ 'wo‑ ma 'gbee‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","'Ö pë ‑nu 'wo ‑kë ꞊nɛ 'siö nɛ‑ ‑nu 'dhö bhë 'wo‑ yö, 'ö ‑ya ‑an tuö do do 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","'Ö ‑Zuu 'slööslö ‑yö ‑da ‑an 'gü, 'ö ‑an 'plɛ pa, 'wo yö 'wun ꞊blɛɛ' ‑sü ‑bha ‑wo 'waa gbɛ ‑nu 'gü ‑a ‑bha 'piigbeedhɛ ꞊kwaa'. ");
INSERT INTO dnj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","‑A yi bhë ‑a 'ka, Zuifö ‑nu 'wo go Zeluzalɛmë plöö waa‑ ‑an mɛ ‑nu 'wo go 'sɛ 'saadhö 'gü 'wo ‑kë ‑Zlan gbamɛ ‑nu 'ka, ‑wo ‑kë Zeluzalɛmë mü. ");
INSERT INTO dnj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","꞊Dhɛ ‑zuö 'ö bhë ꞊waa‑ ma, 'ö‑ mɛ gbung ꞊va ‑wo nu 'kɔ bhë ‑a 'dhiö mü, ‑zuö 'ö dɔ ‑na kɔɔ bhë ‑a ‑wun 'gü. ꞊Dhɛ 'wo‑ ‑bha 'saadhö 'wo ‑da 'tetundhe ꞊va 'gü, bhii 'ö tɔɔ ‑wo Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑yö kö ‑a mɛ 'ö ‑dhö ‑yö 'wun ꞊blɛɛ' ‑na mɛ 'ö ‑dhö ‑a ‑de ‑wo 'gü do do 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","'Yö 'wo‑ pö wo 'ko ‑nu ‑dhë: «'E, ‑ka ka 'to 'to 'dhɛ! Mɛ ‑nu 'wo 'wun ꞊blɛɛ' ‑na ꞊nɛ, Galile ‑mɛ ‑nu 'waa ‑mü ‑an 'ka a? ");
INSERT INTO dnj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","꞊Dhɛ 'ö ‑kë 'pö ꞊nɛ ‑yö ‑kɔklë 'ö 'wo 'wun ꞊blɛɛ' ‑na kwa ‑dhë, ‑dhɛ 'kwa‑ ‑bha 'töüdhö kwa ‑de ‑wo 'gü do do 'ka ꞊nɛɛ? ");
INSERT INTO dnj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","'Kɛɛ kö kwa ziën, mɛ 'bhaa ‑nu ‑wo ‑go 'sɛgɔgüdhɛ ‑nu 'wo ‑kë Paatö ‑sɛ, Medi ‑sɛ, Elamë ‑sɛ, Mezopotami ‑sɛ, Zude ‑sɛ, Kapadɔsö ‑sɛ, Pɔng ‑sɛ, Azi ‑sɛ, ");
INSERT INTO dnj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Flizi ‑sɛ, Panfili ‑sɛ, Ezitö ‑sɛ waa‑ Libi ‑pö ‑nu 'wo Silɛnë ‑pö ‑zü 'to ‑an 'gü. Mɛ ‑nu 'wo go Wlɔmë ‑nu, ");
INSERT INTO dnj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","mɛ ‑nu 'wo Zuifö giagia 'ka ‑nu, mɛ ‑nu 'wo wo ꞊zuö' ꞊dhië Zuifö ‑nu ‑bha ꞊bhɛa' ‑kɔ 'gü ‑nu, mɛ ‑nu 'wo go Klɛtö waa‑ Alabi ‑dhɛ ‑an ‑bha ‑nu, 'ö mɛ ‑nu 'wo 'wun ꞊blɛɛ' ‑na bhë 'kwa ‑an ‑wo ma kwa ‑de ‑wo ‑nu 'gü kö ‑Zlan këwun ‑nu ‑së 'wo bhë ‑wa ‑wun ꞊blɛɛ' ‑na bhë ‑ɔɔ.» ");
INSERT INTO dnj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","‑An 'plɛ ‑wo ‑kë pa ‑sü 'ka 'tetundhe 'ka, 'ö pë 'wo dho ‑a ꞊blɛɛ waa‑ dɔ. 'Ö 'wo‑ pö wo 'ko ‑nu ‑dhë: «꞊Ya kë 'dhö kö 'wun 'ö ꞊nɛ ‑a ‑gɛn 'ö tɔɔ ‑më ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","'Kɛɛ mɛ 'bhaa ‑nu ‑wo ‑kë duö 'luu 'sü ꞊dhia, Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo bhë ‑an ‑bha ‑a pö ‑sü 'ka ꞊nɛɛ: «'Ma, yɔ ꞊ya ‑an 'kun!» ");
INSERT INTO dnj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","'Yö Piɛɛ waa‑ Yesu ‑bha bɔmɛ ‑nu 'gɔɔ‑ do ö ga do 'wo to 'wo dho mɛ gbung ‑nu 'wo bhë ‑an 'dhiö, 'ö Piɛɛ ‑yö ‑ya 'wun ꞊blɛɛ' ‑sü ‑bha ‑wo 'gbee‑ 'ka 'ö‑ pö: «Mɛ ‑nu 'ka Zeluzalɛmë zö 'saadhö waa‑ ‑mɛ ‑nu 'ka go ‑dhɛ gbɛ 'gü 'ka nu, ‑ka ka 'to 'to n ‑ma ‑së 'ka kö 'wun 'ö kë ‑na bhë 'a‑ ‑gɛn pö ka ‑dhë! ");
INSERT INTO dnj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bhii 'ö tɔɔ 'töng 'kwa dɔa ꞊nɛ ‑yö 'lɛlɛ 'sɛisië 'ka ‑dhiadhiö; gɔɔn‑ ‑nu 'wo ꞊nɛ yɔ yaa ‑an kë ꞊nɛ ‑kɔ 'ö 'ka ka ‑zo ꞊taa' bhë ‑a 'dhö ('lɛlɛ 'sɛisië ‑naa 'ka ‑dhiadhiö bhë 'ö tɔɔ Zuifö ‑nu ‑bha ꞊bhɛa' 'töng kö waa pë gbɛ ‑bhö ꞊kun. ‑A 'tɔ ꞊va ‑yaan 'dho kë yɔ ‑mü ‑sü 'ka kö yɔ ‑yaan ‑an kë). ");
INSERT INTO dnj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","'Kɛɛ pë 'ö ‑Zlan ‑yö bɔa ö ‑wodhiölomɛ Zoɛlö ‑ta 'ö‑ ꞊blɛɛ 'dhiö bhë 'ö‑ ‑de 'dho kë ‑na ꞊dɛɛ bhë. ");
INSERT INTO dnj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","'Ö tɔɔ ‑Zlan ‑ya ‑pö pë 'ö dho kë 'töng ‑kaanta 'gü 'ö ꞊nɛɛ: ‑Ya ‑pö ö ‑dho ö ‑bha ‑zuu ‑da mɛ ꞊suu'‑ 'oo ꞊suu'‑ ‑an 'gü 'töüdhö, kö ka gbö ‑nu, ka 'dhu ‑nu ‑waan ö 'dhi ‑wo ꞊blɛɛ'‑, kö kaa‑ ‑dadhëü ‑nu ‑waan 'yanpiöpë 'ö ‑gban ‑Zlan ‑bha 'wun giagia ‑bha ‑a yö; 'go mü 'zü, ka ‑bha mɛ zii ‑nu ‑wo ‑dho ‑Zlan ‑bha 'wun giagia ‑nu yö yiö. ");
INSERT INTO dnj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","'Yö‑ pö ‑a ‑de ‑a yi 'ö 'dhö bhë ‑a 'ka, ö ‑dho ö ‑bha ‑zuu ‑da ö ‑bha yuökëgɔɔn ‑nu waa‑ ö ‑bha yuö kë ‑dhoo ‑nu ‑an 'gü kö ‑waan ö 'dhi ‑wo ꞊blɛɛ'‑. ");
INSERT INTO dnj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","'Ö dho pë 'gblüünzë ‑nu kë dhuö dhang‑ 'gü, 'ö ‑dhidhaapë ‑nu ‑kë 'kpongtaa. Fɛi ‑nu, 'siö ‑nu waa‑ 'siɔn 'tëë ‑nu ‑wo ‑dho kë ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lan‑ ‑dho trö, 'ö 'su ‑yö ‑kë nuɛazë ꞊nɛ fɛi 'dhö, 'dhiö kö yi 'ö kwa Dëmɛ ‑Zlan ‑ya ‑ya ö ‑de ‑zo 'kun ‑wun 'ka kö ‑yaan ö ‑bha za kaan bhë ‑yaan ꞊tun ‑lo ‑na. Yi bhë ‑yö ‑dho kë yi ꞊va 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","꞊Ya kë 'dhö mɛ ꞊ya kwa Dëmɛ ‑dhɛ, ‑yö ‑dho nu ‑a ‑dhë kö ‑ya dha.» ");
INSERT INTO dnj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","'Ö Piɛɛ ‑yö 'wun ꞊blɛɛ 'ö dho ‑a 'ka 'dhiö 'ö‑ pö: «Izlaɛlö ‑mɛ ‑nu, ‑ka ka 'to 'to n ‑wo ‑bha! Yesu 'ö 'go Nazalɛtë bhë, ‑Zlan 'yö‑ bɔ kwa ‑dhë. 'Ö ‑dhidhaapë ‑nu waa‑ pë 'gblüünzë ‑nu ‑kë, ‑bɔ ‑a ‑ta ‑sü 'ka, ‑a ‑zɔn ‑sü 'ka ꞊nɛ yö giagia 'ö‑ bɔ kwa ‑dhë. Pë ‑nu 'wo bhë ka gia‑ ka‑ ‑dɔ 'ö tɔɔ ‑yö ‑kë kwa ziën. ");
INSERT INTO dnj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","'Kɛɛ ka ka ‑kɔ ‑bho ‑a ‑loo 'gü, 'ka‑ dɔ ꞊sɔɔnyaamɛ ‑nu kwɛɛ, 'ka‑ ‑kë 'wo‑ zë ‑a ‑dɔ ‑gaatalü ‑bha ‑sü 'ka. 'Kɛɛ kë‑ wo 'dhö, mɛ bhë ‑a dɔ 'wo‑ wo ka kwɛɛ bhë, ‑yö ‑kë ꞊nɛ ‑kɔ 'ö bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","'Kɛɛ ꞊dhɛ 'ö ꞊wa yën ‑a 'klo bhɔ ‑sü ‑bha 'ö ꞊ya ga, ‑Zlan ‑ya ‑bho ga 'gü, bhii ‑a këdhɛ gbɛ 'yaa ‑dhö kö ga ‑bha 'piigbeedhɛ ‑ya kuënnu ");
INSERT INTO dnj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","꞊nɛ ‑kɔ 'ö Davidö ‑ya ꞊blɛɛ ‑a 'ka 'dhiö bhë ‑a 'dhö. ‑Ya ‑pö: A‑ ꞊tɛi' ꞊dua' ꞊nɛɛ n Dëmɛ ‑yö n 'piö ‑kplawo, 'ö n ‑maa kë ‑na. ꞊Dhɛ ‑kë 'pö kö n yaagümɛ ‑nu 'ka 'dho pë 'dhiö‑ gbɛ kë n 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","‑A ‑wun 'gü, n 'gludhi ‑sü ‑mü, 'ö 'a 'wun ‑nu ꞊blɛɛ 'gludhi 'ka. Ma 'a dho ga ‑dhɛkpaɔyi do 'ka bhë, a n ‑zo 'tën ‑na ‑kplawo pë 'ö ‑Zlan ‑ya pö ö ‑dho ‑a kë n ‑dhë bhë ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","'Ö tɔɔ a‑ ‑pö ‑Zlan ‑dhë: Ü 'ka 'dho ü ꞊kwaa'‑ n nii ‑wun ‑zü ꞊glööbɔɔ, 'ö 'go mü 'zü, ü 'ka 'dho we ‑a ‑bha kö ü ‑bha yuökëmɛ 'slööslö bun ‑yö 'bu. ");
INSERT INTO dnj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","'Bha ꞊toëpö ‑këdhösü ‑zian 'po n ‑dhë. N ꞊zuögludhi ‑sü ꞊va ‑mü ‑kplawo, ü ‑bha ‑kë n 'piö ‑sü bhë ‑a ‑wun 'gü. » ");
INSERT INTO dnj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","'Ö Piɛɛ ‑yö 'wun ꞊blɛɛ 'ö dhoë 'dhiö ‑a pö ‑sü 'ka ꞊nɛɛ: «N dhegluzë ‑nu, ‑ka 'we ‑a ‑bha n ‑gɔ kö 'wun 'ö ‑gban kwa 'bhɛma ‑wungbeezë Davidö ‑bha 'a‑ ꞊blɛɛ'‑ ka ‑dhë 'kpakpadhö. 'Ö tɔɔ Davidö 'ö bhë ‑yö ‑ga, 'wo‑ ‑bin, 'ö‑ blɔɔn‑ ‑de 'dhö kwa ‑gɔ zö. ");
INSERT INTO dnj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","'Kɛɛ kö ‑yö ‑kë ‑Zlan ‑wodhiölomɛ 'ka, 'ö‑ dɔa ꞊nɛ ‑Zlan ‑yö 'wun ‑blɛɛ ö ‑dhë ‑wo ‑bhö ‑sü 'ka ꞊nɛ yö ‑dho ‑a ꞊suu'‑ ‑ta 'gü ‑mɛ ‑nu do ‑ya ‑a ‑bha 'gɔ ‑gbloo 'gü, ‑gludë 'ka ꞊nɛ Davidö 'dhö 'pö. ");
INSERT INTO dnj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ka ‑dhɛ ‑yö bhë ꞊a! ‑Kɔ 'ö Davidö ‑yö pë ‑nu 'wo dho kë ꞊nɛ ‑a ꞊tɛi' dɔa 'dhiö bhë yö ‑ga 'ö bhë. 'Yö‑ ‑wun 'gü, 'ö 'wun 'ö ‑gban ‑Zlan ‑bha ‑Yamɛ ‑bha ‑go ga 'gü ‑sü ‑bha bhë 'yö‑ ꞊blɛɛ 'ö‑ pö: ‑Zlan yaa ö ꞊kwaa' ‑a ‑wun ‑zü ꞊glööbɔɔ kö ‑a bun ‑yaan 'bu. ");
INSERT INTO dnj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","‑Zlan ‑bha Yesu 'a‑ ‑bha 'wun ꞊blɛɛ' ‑na ꞊nɛ ‑a ‑bho ga 'gü ‑sü bhë, mɛ 'plɛ 'yi‑ ꞊goo‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","'Ö ‑Zlan ‑ya ‑kë 'gianzë 'ö‑ ‑ya ö ‑bha ‑yadhɛ ꞊bhlëzë ‑bha ö 'sɔɔ. 'Ö Yesu ‑yö ‑Zuu 'slööslö 'ö‑ Dë ‑Zlan ‑ya 'tɔ go bhë ‑a yö, 'ö‑ ꞊yɔɔ yi ‑ta ꞊dɛɛ. ‑Kɔ 'ö ꞊kaa' 'ö 'ka pë ‑nu 'wo ꞊nɛ 'ka ‑an yö ‑na 'iin 'ka ‑an ma ‑na bhë 'ö bhë. ");
INSERT INTO dnj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Bhii Davidö yaa ‑da dhang‑ 'gü ꞊nɛ Yesu 'dhö; 'kɛɛ ‑ya ‑pö ‑a ‑wun 'gü ꞊nɛɛ: N Dëmɛ ‑Zlan ‑ya ‑pö n dëmɛ ‑dhë: ‑Bhö ‑ya ma ‑yadhɛ ꞊bhlëzë 'ö ꞊nɛ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","‑Yö toë 'dhö ‑yö yöë yi 'a dho ü toë ‑a 'gbee‑ 'ka ü yaagümɛ ‑nu ‑ta bhë ‑a ‑bha! ");
INSERT INTO dnj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","꞊Dhɛ ꞊ya kë 'dhö 'ö‑ pö: Izlaɛlö ‑mɛ ‑nu 'saadhö, ‑kaa dɔa giagia 'ka ꞊nɛɛ: Yesu 'ö 'ka‑ dɔ ‑gaatalü ‑bha bhë, yö ꞊nɛ 'ö ‑Zlan ‑ya ‑kë mɛ 'plɛ Dëmɛ 'ka. Yö ꞊nɛ 'ö tɔɔ ‑a ‑bha ‑Yamɛ.» ");
INSERT INTO dnj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","꞊Dhɛ ꞊wa Piɛɛ ‑wo ma, 'ö ‑yɛ ‑an ꞊zuö' ‑bha ꞊nɛ 'siö 'dhö, (bhii kö ꞊waa‑ ꞊tɛi' dɔa ꞊nɛ 'wa 'wun yaa kë ‑Zlan 'ka). 'Ö Piɛɛ waa‑ Yesu ‑bha bɔmɛ ‑nu 'wo to bhë 'wo ‑an ꞊dhɛɛ' kpɔ 'wo‑ pö: «Dhegluzë ‑nu, ‑më 'yi dhoë‑ kë ꞊ɛ?» ");
INSERT INTO dnj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","'Ö Piɛɛ ‑ya ‑daa ‑kë ‑an ‑gɔ 'ö‑ pö: «Mɛ 'ö ‑dhö, ‑yö 'go ö ‑bha ꞊sɔɔn yaa ‑nu 'gü, ‑yö ꞊dhië'‑ ‑Zlan 'piö, ‑wa bɔ yiö Yesu 'tɔ 'ka kö ‑Zlan ‑yaan ziö ‑a ‑bha ꞊sɔɔn yaa ‑nu ‑ta! ꞊Ya kë 'dhö ‑Zuu 'slööslö 'ö ‑Zlan ‑ya gbaɔ ‑kë bhë ka ‑dho ka ‑bha yö. ");
INSERT INTO dnj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bhii ‑Zlan ‑ya 'tɔ ‑go ꞊nɛ ‑yö ‑dho ‑Zuu 'slööslö bɔ ka 'dhö, kaa‑ 'në ‑nu 'dhö ka ‑dhë. ‑Ya 'tɔ ‑go 'dhö 'pö mɛ ‑nu 'wo 'ma ꞊gbiin ‑an ‑dhë 'wo tɔɔ mɛ ‑nu 'töüdhö 'ö kwa Dëmɛ kwa ‑bha ‑Zlan dho ‑an ꞊dhɔɔ kë ‑waan kë ‑a ‑bha 'në ‑nu 'ka bhë.» ");
INSERT INTO dnj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piɛɛ ‑yö 'wun ꞊blɛɛ ‑an ‑dhë 'zü ꞊va 'ka, ‑dhio ‑dɔ ‑an ‑dhë ‑sü, ‑an ꞊faan' 'më ‑sü 'ka kö ꞊ya kë ꞊nɛ ꞊wa 'we dha ‑sü ‑wun ‑bha, ‑waan 'go ꞊sɔɔnyaamɛ ‑nu 'wo Yesu zë 'ö ‑an 'klo‑ dho bhɔ bhë ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","‑Zlan ‑wo 'ö Piɛɛ ‑ya pö bhë mɛdhɛvadhɛ ‑wa ‑dhɛ 'wun gia‑, 'ö 'wo ‑an ‑bɔ yiö Yesu 'tɔ 'ka. 'Ö mɛ ‑lü ‑vuu ‑yaaga ‑wo ‑da Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'piö yi do gia‑ 'ö bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","꞊Faan' ‑yö ‑kë ‑an 'plɛ ‑gɔ ‑kplawo 'to ‑to mɛ ꞊daan' ‑wo ‑nu 'ö Yesu ‑bha bɔmɛ ‑nu 'wo ‑kë ‑an ꞊daan' ꞊dhia ‑a 'ka bhë ‑a ‑bha. 'Ö ‑an ꞊zuö' ‑yö ‑kë do. 'Wo pë ‑nu ‑bhö wo 'ko ꞊bhaa. 'Go mü 'wo ꞊bhɛa' ‑nu wo ‑Zlan ‑dhë wo 'ko ꞊yöë'. ");
INSERT INTO dnj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","'Suö ‑yö ‑kë mɛ 'saadhö 'gü, 'ö 'wo Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ꞊bhlë ‑ya, bhii 'ö tɔɔ Yesu ‑bha bɔmɛ ‑nu ‑wo ‑kë ‑dhidhaapë ꞊plëëzë kë ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑wo ‑kë wo 'ko ꞊bhaa dosɛn. 'Ö ‑an ‑gɔ ‑pë 'plɛ ‑wo ‑kë do. ");
INSERT INTO dnj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","꞊Ya kë ꞊nɛ mɛ do ‑bha ‑wun ꞊ya yö pë 'bhaa ‑bha ‑an ziën 'ö mɛ 'bhaa ‑nu ‑wo wo ‑bha ꞊bhlöödhɛ ‑nu 'iin 'kwɛandhɛ ‑nu waa‑ pë ‑nu 'ö ‑an ‑gɔ ‑pë ‑nu 'ka ‑nu, 'wo ‑an 'dhɔɔ dɔ, 'ö mɛ 'ö‑ ‑bha ‑wun ‑yö yö pë ‑bha bhë, 'wo pë 'ö ‑mɔ ‑a ‑bha ‑a ꞊tian' 'wo‑ nu ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","'Ö ‑dhɛkpaɔyi 'saadhö 'ka 'wo dho wo 'ko ꞊bhaa, ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü; 'ö 'wo pë ‑nu ‑bhö wo 'ko 'piö wo ‑gɔ kɔɔ, ꞊zuögludhi waa‑ ꞊zuö' ‑së 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","‑Wo ‑Zlan 'tɔ ‑blü, 'ö 'go mü 'sɛgümɛ ‑nu ‑wo ‑an ‑dhɔ ‑kë. 'Ö ‑dhɛkpaɔyi 'saadhö 'ka 'ö mɛ ‑nu 'ö kwa Dëmɛ Yesu 'dho ‑an dha ‑na bhë 'ö ‑an ‑da ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yi do 'ka Piɛɛ waa‑ Zan ‑wo ‑kë 'dho ꞊dhia ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'wɔ 'yɛ ‑lan 'ö ‑kë 'sɛgümɛ ‑nu ‑bha ꞊bhɛa' 'töng 'ka bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","'Wo ‑gɛnlomɛ do yö kö ‑yö ꞊yaannu ‑sü 'ka 'kɔdhi mɛ 'wo‑ ‑dhɛ 'kɔdhi ‑sëëzë bhë ‑a 'dhiö. Gɔɔn‑ 'ö bhë ‑yö ‑bhɔ 'yua bhë ‑a 'ka. 'Ö ‑dhɛkpaɔyi 'saadhö ‑a 'ka, 'wo nuë 'wo‑ ‑ya mü, kö ‑yaan 'wëü‑ ‑gba ‑dhɛ, mɛ ‑nu 'wo ‑da ‑na ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü bhë ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","꞊Dhɛ 'ö Piɛɛ waa‑ Zan ‑an yö kö ‑wo 'dhoë‑ ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'yö ‑gba ‑dhɛ ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","'Ö Piɛɛ waa‑ Zan 'wo‑ ‑ga ‑piindhö, 'ö Piɛɛ ‑ya pö ‑a ‑dhë: «‑Bhö yi ‑ga!» ");
INSERT INTO dnj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","'Yö gɔɔn‑ bhë 'ö ‑an ‑ga ‑së 'ka, bhii ‑a 'yan ‑yö pë 'wo dho ‑a nu ‑a ‑dhë zlöö ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","'Ö Piɛɛ ‑ya pö ‑a ‑dhë 'zü: «'Wëü‑ 'yaa n ‑gɔ kö 'aan‑ nu ü ‑dhë, 'kɛɛ pë 'bhaa ‑yö n ‑gɔ, 'a dho ‑a nu ü ‑dhë; ö tɔɔ: Yesu Klito 'ö go Nazalɛtë bhë ‑a 'tɔ 'gü, ‑bhö ꞊luu'‑ 'ü 'ta 'sü!» ");
INSERT INTO dnj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","꞊Dhɛ ꞊ya kë 'pö 'ö ‑ya ‑a ꞊kwɛɛ‑ 'gü ‑kɔ ‑bha 'ö‑ ꞊luu. ꞊Dhɛ do bhë 'wo to ‑a ‑bha 'ö gɔɔn‑ 'ö bhë 'ö‑ ‑gɛn ‑nu ‑wo ‑po, 'wo ‑kë 'gɛngɛn. ");
INSERT INTO dnj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","'Ö ꞊luu 'budhö, 'ö dɔ ö ‑gɛan, 'ö yö 'ta 'sü ‑sü ‑bha. 'Ö waa‑ Yesu ‑bha bɔmɛ ‑nu 'wo ‑da wo 'kuë ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü kö ‑yö 'ta 'sü ‑na ꞊löö 'lö ‑sü 'ka ‑Zlan 'tɔ ‑blü ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mɛ ‑nu 'wo ‑kë mü 'töüdhö ‑wa ‑yö kö ‑yö 'ta 'sü ‑na ‑Zlan 'tɔ ‑blü ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","꞊Dhɛ ꞊waa‑ ‑ga 'ö 'wo‑ dɔ 'sabla ꞊nɛ gɔɔn‑ 'ö ‑kë ‑ya ‑sü 'ka ‑Zlan ‑gba ‑a 'gü ‑kɔ 'kɔdhi ‑sëëzë 'dhiö, ‑gba ‑dhɛ ‑sü 'ka bhë yö ‑mü. 'Ö ‑dhɛ 'wo‑ ‑bha 'saadhö 'wo pa 'suö waa‑ 'tetundhe ‑an 'ka, pë 'ö ‑kë ‑a ‑dhë bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Gɔɔn‑ 'ö bhë yaa 'go Piɛɛ waa‑ Zan ‑an 'piö. 'Ö mɛ ‑gbaa 'wo ‑kë ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü bhë, 'ö ‑an 'te ‑yö tun, 'ö ‑an 'plɛ 'wo ‑bla sü 'wo nuë ‑an 'piö, 'kɔdɔɔdɔdhɛ ꞊vaazë 'wo‑ ‑dhɛ Salomɔ ‑bha 'kɔdɔɔdɔdhɛ bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","꞊Dhɛ mɛ ‑nu 'wo bhë 'ö Piɛɛ ꞊ya ‑an yö, 'ö‑ pö ‑an ‑dhë: «Izlaɛlö ‑mɛ ‑nu, ‑më ‑kë ka 'te‑ tun mɛ 'ö ꞊nɛ ‑a ‑dhɛ 'ö bo ꞊nɛ ‑a ‑wun 'gü i? ‑Më 'ö ‑kë 'ö 'ka yi ‑ga ꞊nɛ pë 'wo‑ pö yi ꞊nɛ 'yi gɔɔn‑ 'ö ꞊nɛ 'yi‑ ‑dhɛ bo yi ‑de ‑bha 'piigbeedhɛ waa‑ yi ‑bha ‑klu ‑Zlan ‑bha ‑sü ‑wun 'gü ‑a 'dhö e? ");
INSERT INTO dnj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ablaamö 'dhö, Izaakö 'dhö waa‑ Zakɔbö ‑an ‑bha ‑Zlan 'ö kwa 'bhɛma ‑nu ‑bha ‑Zlan 'ka bhë, yö ꞊nɛ 'ö 'tɔbhɔdhe nu ö ‑bha yuökëmɛ Yesu ‑dhë. Yesu bhë ꞊nɛ 'ö Zuifö ‑nu ka gia‑ 'ka‑ kun, 'ka‑ dɔ kaa‑ mɛ ‑nu 'ö ‑wogbiindhɛ 'dhö ‑an ‑gɔ ‑an kwɛɛ, 'ö 'ka 'wun yaa ‑nu dɔ ‑a ‑bha Pilatö 'dhiö, 'kɛɛ kö Pilatö ‑zë, ‑yö ‑kë ‑a 'piö kö 'ö ö ꞊kwaa'‑ ‑zü. ");
INSERT INTO dnj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","'Yö mɛ 'ö 'slööslö, 'ö kpengdhö ‑Zlan wö 'dhiö bhë, kaa 'we ‑a ‑wun ‑bha, 'ö mɛ 'ö ‑kë mɛzëmɛ 'ka bhë, 'ka‑ ‑dhɛ Pilatö ‑gɔ kö ‑ya bho ‑kanso 'gü ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mɛ 'ö ‑kë ‑a 'gü ‑sü gia‑ nu mɛ 'kpɛkpɛ ‑dhë bhë, ‑a kë ‑kɔ 'ka‑ ‑kë 'ka‑ zë bhë yö ꞊ga 'ö bhë. 'Kɛɛ ‑Zlan ‑ya ‑bho ga 'gü 'ö 'yi‑ ꞊goo‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","‑Zo ‑yö Yesu 'tɔ 'piigbeezë ‑bha ‑sü 'ö ꞊faan' nu, gɔɔn‑ 'ka‑ dɔ 'ö 'ka‑ ‑ga ‑na ꞊nɛ ‑a ‑dhë. ‑Zo ‑yö Yesu ‑bha ‑sü bhë 'ö gɔɔn‑ ꞊nɛ 'ö‑ ‑dhɛ bo ö 'plɛ 'ka, ka 'plɛ 'töüdhö ka 'yaan 'ka ꞊nɛ. ");
INSERT INTO dnj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","꞊Dhɛ ‑kë 'dhö bhë, n dhegluzë ‑nu, a‑ dɔa ꞊nɛ 'wun yaa 'ka‑ ‑kë Yesu 'ka 'dhö bhë, ka ‑nu oo, ka ‑gɔmɛ ‑nu oo, kaa‑ ‑gɛn dɔ bhë yö ‑mü. ");
INSERT INTO dnj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","'Kɛɛ ‑kɔ 'ö bhë ‑a 'ka, 'ö pë 'ö ‑Zlan ‑ya pö 'dhiö ‑be 'ö bɔa ö ‑wodhiölomɛ ‑nu 'saadhö ‑ta, 'ö‑ ꞊blɛɛ yö ‑mü; 'ö‑ ‑kë 'dhö kö ‑yaan 'dhiö ‑yaan ‑mɔ 'kuë bhii ‑ya pö ö bha ‑Yamɛ 'klo‑ ‑dho bhɔ. ");
INSERT INTO dnj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","‑A ‑wun 'gü ‑ka ka ‑bha ‑tosiadhe ꞊dhië' ‑kwaa, 'ka ꞊dhië'‑ ‑Zlan 'piö kö ‑yö ziö ka ‑bha ꞊sɔɔn yaa ‑nu ‑ta. ");
INSERT INTO dnj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","'Go mü 'zü kö ‑yaan 'tɛɛpadhe ‑nu nu ka nii ‑nu ‑dhë kö ‑a ‑bha ‑Yamɛ 'ö ꞊yaa‑ 'sü ka ‑bha 'ka 'saadhö, 'ö Yesu 'ka bhë, ‑yaan ‑a bɔ ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","'Go mü 'zü pë dho kë 'ö tɔɔ Yesu Klito ‑dho to dhang‑ 'gü ꞊kun 'ö dhoë 'ö yöë 'töng 'ö ‑Zlan dho pë 'plɛ kaa ‑dëü ꞊nɛ ‑kɔ 'ö‑ ꞊blɛɛ ‑a 'ka 'ö bɔa ö ‑wodhiölomɛ 'slööslö ‑nu ‑ta 'ö‑ ‑dhɛ ꞊ya ꞊glɔɔ bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","'Wun 'ö ‑gban Yesu ‑wun ‑bha, Moizö ‑ya ꞊blɛɛ 'yö‑ pö: Kwa Dëmɛ, kwa ‑bha ‑Zlan ‑yö ‑dho ö ‑wodhiölomɛ 'ö ‑kë ꞊nɛ n 'dhö, 'yö dho go ka ꞊suu'‑ ‑ta 'gü 'ö‑ bɔ ka ‑dhë. 'Wun ‑nu 'saadhö 'ö 'dhoë‑ ꞊blɛɛ' ka ‑dhë bhë, ‑kaa ma ‑a ‑ta! ");
INSERT INTO dnj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mɛ 'oo mɛ 'ö yaa dho 'wun ma ‑a ‑ta, ‑yö ‑dho go ‑Zlan ‑bha mɛ ‑nu ziën, 'ö 'wo‑ zë. ");
INSERT INTO dnj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","‑Zlan ‑wodhiölomɛ ‑nu 'töüdhö 'ö goë Samiɛlö ‑bha 'ö yöë ꞊dɛɛ ‑bha, ‑an 'plɛ 'wun 'ö ‑gban yi 'ö 'kwa‑ 'gü ꞊nɛ ‑a ‑bha, ‑wa ꞊blɛɛ. ");
INSERT INTO dnj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pë 'ö ‑Zlan ‑ya 'tɔ go 'ö bɔa ö ‑wodhiölomɛ ‑nu ‑ta bhë, ‑yö ka ‑bha 'ka, 'ö 'go mü ‑dhi 'kuë 'ö ‑Zlan ‑ya ‑da waa‑ ka 'bhɛma ‑nu wo ziën, 'ö ka ‑bha 'ka 'pö; 'ö tɔɔ ‑Zlan ‑ya ‑pö Ablaamö ‑dhë: ‹A ‑dho 'dhuë‑ kpɔ ü ꞊suu'‑ ‑ta 'në ‑nu ‑bha, 'ö 'a dho bɔ ‑an 'gü kö 'aan‑ 'dhuë‑ kpɔ 'kpongtaamɛ ‑nu 'saadhö ‑bha.› ");
INSERT INTO dnj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","‑Kɔ 'ö ꞊kaa' 'ö ‑Zlan ‑yö ö bha yuökëmɛ Yesu sü 'ö‑ bɔa ka ‑dhë 'dhiö ꞊kun bhë 'ö bhë. ‑Ya ‑bɔ 'dhö kö ‑yaan 'dhuë‑ 'kpɔ ka ‑bha 'ö‑ ‑kë kö mɛ 'ö ‑dhö ‑yö 'go ö ‑bha këpë yaa ‑nu ‑zian ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piɛɛ waa‑ Zan ‑wo ‑to 'wun ꞊blɛɛ' ꞊dhia 'sɛgümɛ ‑nu ‑dhë, 'ö slabhomɛ ‑nu, 'yan ‑to ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑bha ‑mɛ ‑gɔmɛ ‑nu waa‑ Saduse ‑mɛ ‑nu ‑wo ‑wo. ");
INSERT INTO dnj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yaa dhi ‑an ‑dhë kö Yesu ‑bha bɔmɛ ꞊plɛ 'wo bhë ‑wo 'sɛgümɛ ‑nu ‑daan, ‑a ‑pö ‑an ‑dhë ‑sü 'ka ꞊nɛ Yesu Klito ‑yö ‑go ga 'gü, kö ‑a ‑gɛn ‑yaan kë ꞊nɛ gamɛ ‑nu ‑wo ‑dho go ga 'gü. (Bhii 'ö tɔɔ Saduse ‑mɛ ‑nu 'waa ‑go ga 'gü ‑sü ‑wun ‑dhɛ 'wun gia‑.) ");
INSERT INTO dnj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","'Wo ‑an kun 'wo ‑an ‑zuö ‑kanso 'gü 'wo ‑wɔ mü 'ö ‑dhɛ ‑yö ꞊kpaɔ ‑a 'ka. Bhii 'ö tɔɔ ꞊dhɛ 'wo ‑an 'kun ‑na kö 'bin ꞊ya 'më 'saadhö. ");
INSERT INTO dnj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","꞊Dhɛ 'ö kë ‑na 'dhö kö 'wuntaɔsë 'ö Piɛɛ waa‑ Zan 'wo‑ ꞊blɛɛ bhë mɛ ‑nu 'wo‑ ma, ‑an mɛdhɛvadhɛ ꞊wa Yesu ‑wun ‑dhɛ 'wun gia‑. 'Ö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑kpa 'kuë‑ ‑sü ‑yö ‑kë ꞊va 'ö dho 'ö yöë mɛ ‑lü ‑vuu 'sɔɔdhu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","꞊Dhɛ 'ö‑ ‑ta ‑dhɛ ꞊ya 'po, Zuifö ‑nu ‑gɔmɛ ‑nu waa‑ ‑an ‑bha mɛ ziizii ‑nu, waa‑ tɔnggɔmɛ ‑nu ‑wo ‑dho wo 'ko ꞊bhaa Zeluzalɛmë plöö. ");
INSERT INTO dnj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","'Ö ‑dhɛ bhë ‑a 'gü slabhomɛ ꞊va 'wo‑ ‑dhɛ Anë waa‑ Kaifö 'dhö, Zan 'dhö, Alezandrë 'dhö waa‑ slabhomɛ ꞊va ‑gɔ 'kɔɔmɛ ‑nu 'töüdhö 'dhö ‑wo ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","'Ö 'wo nu Yesu ‑bha bɔmɛ ‑nu 'wo bhë ‑an 'ka ‑an 'dhiö, 'ö 'wo ‑an ꞊dhɛɛ' kpɔ 'wo‑ pö: «‑Gɛnlomɛ 'ö ꞊nɛ 'ka‑ ‑dhɛ ‑bo ‑kɔklë ꞊ɛ? 'Piigbeedhɛ ‑mlë 'ö 'ka 'yua ꞊nɛ 'ka‑ boë ꞊ɛ? Dö ‑de 'ka 'yua ꞊nɛ 'ka‑ bo ‑a 'tɔ 'gü i?» ");
INSERT INTO dnj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","'Ö to mü ‑Zuu 'slööslö ‑yö Piɛɛ pa, 'ö‑ pö ‑an ‑dhë: «'Sɛ ꞊kɔɔnmɛ ‑nu, mɛ ziizii ‑nu, ");
INSERT INTO dnj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","'ka nu yi 'ka ꞊dɛɛ zakanmɛ 'dhiö zö, nu 'yi‑ wo ‑gɛnlomɛ 'ö ꞊nɛ ‑a ‑dhë ‑a ‑dhɛ bo ‑sü 'ka bhë ‑a ‑wun 'gü, 'go mü 'ö ‑kɔ 'ö dha ‑a 'ka, 'ö 'ka‑ ꞊dhɛɛ' 'kpɔ ‑na yi ‑gɔ bhë. ");
INSERT INTO dnj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","'Kɛɛ pë 'ö dho kë 'ö tɔɔ ka 'dhö, Izlaɛlö ‑sɛgümɛ ‑nu 'dhö, ka 'plɛ ka‑ dɔa ꞊nɛɛ gɔɔn‑ 'ö ꞊nɛ ꞊ya ‑potaasü yö 'fɛfɛdhö Yesu Klito 'go Nazalɛtë 'ö 'ka‑ zë ‑a ‑dɔ ‑gaatalü ‑bha ‑sü 'ka, 'ö ‑Zlan ‑ya bho ga 'gü bhë ‑a 'tɔ 'piigbeezë bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu bhë ꞊nɛ 'ö 'wun ‑yö ‑gban ‑a ‑bha 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü ꞊nɛɛ: ‑Guö 'ö 'kɔdɔmɛ ‑nu 'ka‑ ꞊zong bhë, ꞊ya 'yɛ 'zü ꞊ya kë 'kɔ ‑gɛn ‑gban ‑a ‑ta ‑guö gia‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yö dosɛn 'kpaan ꞊nɛ 'ö dhasü ‑yö go ‑a 'gü. Bhii 'tɔ 'waa gbɛ 'ö ‑Zlan dho ‑a nu mɛ ‑nu ‑dhë 'kpongtaa kö 'kwaan‑ bɔ ‑a ‑ta 'kwaan‑ dha 'yaa ‑dhö.» ");
INSERT INTO dnj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","꞊Dhɛ ꞊wa Piɛɛ waa‑ Zan ‑an ‑bha 'wun ꞊blɛɛ' ‑kɔ 'ö ‑kë ‑zo ‑gban ‑sü 'gü bhë ‑a yö, 'ö ‑an 'te ‑yö ꞊tun, 'ö tɔɔ ‑wo ‑kë ꞊nɛ 'sɛgümɛ ‑nu mɛ 'wo to ‑an 'dhö, 'waa mɛ ‑nu 'wo dhoë‑ pö ‑kwaa ‑an ꞊bhlë ‑ya ‑an 'ka 'pö 'sa. 'Go mü 'zü waa ‑an ꞊daan'‑ kö ‑waan 'wunbhokou dɔ. 'Ö 'wo ‑an dɔ ꞊nɛ ‑wo ‑kë Yesu 'piö ‑be. ");
INSERT INTO dnj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","'Yö 'wo gɔɔn‑ 'ö‑ ‑dhɛ ‑yö bo bhë ‑a yö kö ‑yö dɔ ‑sü 'ka ‑an 'sɔɔ mü, 'ö pë 'wo dho ‑a ꞊blɛɛ'‑ waa‑ dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","꞊Dhɛ ꞊ya kë 'pö 'wo‑ pö Piɛɛ waa‑ Zan ‑an ‑dhë ‑wo yö plaan. ꞊Dhɛ ꞊wa 'kan wo 'kuë‑, 'ö zakanmɛ ‑nu 'wo wo 'ko yö, pë 'wo dho ‑a kë Piɛɛ waa‑ Zan ‑an 'ka ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","'Wo‑ pö wo 'ko ‑nu ‑dhë: «‑Më 'ö 'kwa dho ‑a kë mɛ 'wo ꞊nɛ ‑an 'ka ɛ? Bhii mɛ ‑nu 'saadhö 'wo Zeluzalɛmë plöö zö, ‑wa ꞊dua' ‑së 'ka ꞊nɛ, ‑dhidhaapë 'gblüünzë 'ö ‑kë ꞊nɛ wo ꞊nɛ 'wo‑ ‑kë, 'ö kwa gia‑ kwa 'ka 'dho ‑a ꞊kploo wo. ");
INSERT INTO dnj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","'Kɛɛ ‑kwa yö ‑an ‑gɔ 'sɛi ‑a ‑pö ‑an ‑dhë ‑sü 'ka kö ꞊kun 'ö 'wo 'wun ꞊blɛɛ mɛ gbɛ ‑dhë gbɔ Yesu 'tɔ 'ka, ‑yö kë 'dhö kö ꞊kun 'ö 'wun ꞊nɛ, 'ö‑ ‑taɔ ‑yö ‑pɛn.» ");
INSERT INTO dnj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","'Ö 'wo Piɛɛ waa‑ Zan ‑an ꞊dhɔɔ ‑kë, 'wo‑ pö ‑an ‑dhë, ‑wo wo bo ö 'plɛ 'ka 'wun ‑blɛɛ mɛ ‑nu ‑dhë ‑sü waa‑ ‑an ꞊daan' Yesu 'ö bhë ‑a 'tɔ 'ka ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","'Yö Piɛɛ waa‑ Zan 'wo‑ pö ‑an ‑dhë: «Ka gia‑, 'ka ‑dhɛ ‑ga ‑a 'gü, ꞊yö ‑së ‑Zlan wö 'dhiö kö 'yi ka ꞊bhlë 'kpɔ 'yi ziëë ‑Zlan ‑ta ‑a? ");
INSERT INTO dnj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","‑Abi', yi 'ka 'dho ‑mɔa 'yi yi bo 'wun 'yi‑ yö, 'yi‑ ma bhë ‑an ꞊blɛɛ' ‑sü 'ka!» ");
INSERT INTO dnj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","'Ö zakanmɛ ‑nu ‑wo 'suö ‑da ‑an 'gü 'zü 'ö ꞊zië' ‑a mɛ 'wo‑ ‑da ‑an 'gü 'dhiö bhë ‑a ‑ta, 'ö 'wo wo ꞊kwaa ‑an ‑zü, 'ö 'wo dho. 'Ö waa këdhɛ gbɛ yö kö ‑waan ‑an 'klo bhɔ 'ö tɔɔ 'sɛgümɛ ‑nu 'saadhö ‑wo ‑kë ‑Zlan 'tɔ ‑blü ꞊dhia, pë 'ö ‑kë bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gɔɔn‑ 'ö‑ ‑dhɛ ‑yö bo ‑dhidhaazë 'ka bhë, ‑a ‑kwɛ ‑yö ‑ziö 'gɔɔ‑ ‑yiisië 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","꞊Dhɛ 'ö ꞊wa wo ꞊kwaa' ‑an ‑zü, 'ö Piɛɛ waa‑ Zan 'wo dho woë‑ mɛ ‑nu 'piö, 'ö 'wun ‑nu 'ö slabhomɛ ‑gɔmɛ ‑nu waa‑ mɛ ziizii ‑nu 'wo‑ ꞊blɛɛ ‑an ‑dhë bhë, 'wo bɔ ‑a 'plɛ 'gü 'wo‑ ‑gɛn bho ‑an ‑dhë 'pö. ");
INSERT INTO dnj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","'Yö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑wo ꞊bhɛa ‑Zlan ‑dhë ꞊zuö' do 'ka 'wo‑ pö: «Yi ‑Gɔmɛ, bhi ꞊nɛ 'ö dhang‑ 'dhö, 'sɛ 'dhö, 'yi waa‑ ‑an 'gü ‑pë ‑nu 'saadhö ‑an ‑kë. ");
INSERT INTO dnj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bhi ꞊nɛ 'ö ‑Zuu 'slööslö ꞊kwaa' 'ü bɔ yi 'bhɛma ü ‑bha yuökëmɛ 'ö ‑kë Davidö 'ka bhë ‑a ‑ta 'ü‑ pö: ‑Më 'ö ‑kë 'ö mɛ 'waa Zuifö 'ka 'ö ‑naadhe ꞊va ꞊suu'‑ 'ö ꞊nɛ 'ö ‑da ‑an 'gü ‑desüvadhe 'ka ɛ? 'Ö 'wo 'slë 'ö‑ ‑yöë ‑bha ‑pë gbɛ 'yaa 'dhö bhë 'wo‑ kan kwa Dëmɛ ‑gɔ ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","'Kpongtaa ‑gludë ‑nu ꞊wa dɔ ‑a ‑gɔ 'yënng. 'Go mü mɛ ꞊kɔɔnmɛ ‑nu ꞊wa 'dho wo 'ko ꞊zlöö kwa Dëmɛ ‑Zlan waa‑ ö ‑bha ‑Yamɛ ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","‑Yö 'wun giagia 'ka ꞊nɛ Elɔdö 'dhö, Pɔnsö Pilatö 'dhö, mɛ 'bhaa ‑nu 'waa Zuifö 'ka waa‑ Izlaɛlö ‑mɛ ‑nu 'dhö, ‑an 'plɛ 'töüdhö, ‑wo ‑dho wo 'kuë‑, pödhɛ bhë ‑a 'gü, ü bha yuökëmɛ 'slööslö Yesu 'ö ü ‑bha ‑Yamɛ ka bhë ‑a ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","‑Kɔ 'ö bhë ‑a 'ka, ‑wo pë 'saadhö 'ü ‑we ‑a ‑bha 'dhiö ü ‑bha 'piigbeedhɛ 'ka kö ‑yaan kë ü ‑dhi ‑a ‑dhë ‑wun 'ka bhë ‑wa ‑kë. ");
INSERT INTO dnj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","꞊Dhɛ 'ö 'pö bhë, n Dëmɛ, ‑an ‑bha 'suö ‑da mɛ 'gü ‑wo ‑nu ꞊nɛ ‑bhöë ma, ‑bhö 'we ‑a ‑bha yi 'yi ‑kë ü ‑bha yuökëmɛ ‑nu 'ka bhë yi ‑gɔ, kö 'yi ü ‑bha 'wun ꞊blɛɛ'‑ ‑zo ‑gban ‑sü 'ka! ");
INSERT INTO dnj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","‑Bhö ü ‑bha 'piigbeedhɛ ‑zɔn mɛ ‑nu ‑dhë, mɛ ‑dhɛ bo ‑sü waa‑ ‑dhidhaapë ‑nu kë ‑sü 'ka, ü ‑bha yuökëmɛ 'slööslö Yesu 'tɔ 'ka.» ");
INSERT INTO dnj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","꞊Dhɛ 'ö ꞊wa yën ꞊bhɛa' ‑sü ‑bha, 'ö ‑dhɛ 'wo ‑kë ‑a ‑bha bhë, 'ö yö ꞊zluun ‑sü ‑bha; 'ö ‑Zuu 'slööslö ‑yö ‑an pa 'töüdhö 'ö 'wo yö ‑Zlan ‑wo ꞊blɛɛ' ‑sü ‑bha ‑zogbandhe 'ka mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu gbung 'wo bhë ‑an ‑zo ‑ta ‑a 'gü ‑wun waa‑ ‑an ‑dhi ‑an ‑dhë ‑wun ‑yö ‑kë do. Mɛ do gbɛ 'yaa‑ pö: «Pë ‑së ‑nu 'wo ꞊nɛ, ma do ma pë ‑mü.» 'Kɛɛ mɛ 'ö ‑dhö ‑yö ö ‑gɔ ‑pë ‑nu ‑glu mɛ 'kpaan ‑nu 'wo to ‑an 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","'Piigbeedhɛ ꞊nɛ 'ö Yesu ‑bha bɔmɛ ‑nu ‑wo kwa Dëmɛ Yesu ‑bha ‑go ga 'gü ‑sü ‑tɔmɔdhɛ ‑kë ‑a 'ka. 'Ö ‑Zlan ‑yö 'dhuë‑ kpɔ ‑an ‑bha ꞊va 'ka 'töüdhö. ");
INSERT INTO dnj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","'Ö ‑an ziën pë ‑wun ‑saan 'yaa mɛ gbɛ kë. Bhii 'ö tɔɔ ꞊ya kë ꞊nɛ mɛ ‑nu 'ö ꞊bhlöödhɛ ‑nu, 'kɔ ‑nu 'dhö ‑an ‑gɔ, ꞊waa‑ 'dhɔɔ dɔ ");
INSERT INTO dnj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","'wo dho 'wëü‑ 'ö bhë ‑a 'ka Yesu ‑bha bɔmɛ ‑nu ꞊dhia, 'wo‑ ꞊waannu kö ‑waan ‑glu mɛ ‑nu 'ka. 'Ö mɛ 'ö ‑dhö, ‑kɔ 'ö‑ ‑bha ‑wun ‑yö yöë 'wëüga ‑bha 'ö‑ ꞊blɛɛ 'ö‑ mɛ 'ö‑ ꞊tian' 'wo‑ gbaa ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","‑A ‑de Zozɛfu 'ö ‑kë Levi ‑bha 'gunng 'gü 'në do 'ka, 'ö bhɔ Siplë 'ö Yesu ‑bha bɔmɛ ‑nu ‑wa 'tɔ kpɔ Baanabasö 'ka (‑a ‑gɛn 'ö tɔɔ Glɛkö ‑wo 'gü «gɔɔn‑ 'ö mɛ ꞊faan' më»), ");
INSERT INTO dnj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","‑yö ö ‑bha ꞊bhlöödhɛ do 'dhɔɔ ‑dɔ, 'yö nu ‑a 'wëüga bhë ‑a 'ka Yesu ‑bha bɔmɛ ‑nu ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gɔɔn‑ do 'wo‑ ‑dhɛ Ananiasö waa‑ ö bɔɔ 'wo‑ ‑dhɛ Safila ‑wo ‑kë ‑an kpö 'gü ‑mɛ ‑nu 'ka 'pö. 'Ö yö 'dhö waa‑ ö bɔɔ 'dhö 'ö ‑an ‑wo ‑yö ‑kë do, 'wo wo ‑bha ‑dhɛ do 'dhɔɔ dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","'Ö‑ 'wëü‑ bhë 'ö‑ 'bhaa sü 'ö‑ ‑bin ö ‑bha 'ka, 'ö‑ mɛ to, 'ö dhoë Yesu ‑bha bɔmɛ ‑nu ꞊dhia; ‑yö ‑kë ‑a bɔɔ 'yaan 'ka ‑wun 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","꞊Dhɛ ꞊ya kë 'pö 'ö Piɛɛ ‑ya pö ‑a ‑dhë: «Ananiasö, ‑më ‑kë 'ü ü ‑kwaa dü ‑zü 'ö ‑ya ü ꞊zuö' 'piö 'ö 'ü ꞊sua ‑kë ‑Zuu 'slööslö ‑gɔ, 'ö ‑dhɛ 'ü‑ 'dhɔɔ dɔ bhë 'ü‑ 'wëüga 'bhaa ‑bin ‑i? ");
INSERT INTO dnj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Dö 'ö ü 'gbee‑ ‑ta bho kö 'üën‑ ü bha ‑dhɛ 'dhɔɔ dɔ ꞊ɛ? ‑A 'wëüga bhë, ü bha ‑pë 'yaa ‑mü ‑a? ‑Më 'ö ‑kë 'ö 'slë ꞊suu'‑ 'ö bhë 'ö ‑da ü 'gü i? ꞊Sua 'ö ꞊nɛ ü 'ka‑ kë mɛ 'bhee‑ ‑gɔ, ‑Zlan ꞊nɛ 'ü‑ ‑kë ‑a ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","꞊Dhɛ 'ö ‑wo bhë Ananiasö ꞊yaa‑ ma, 'ö to mü 'ö ‑püö sia‑ 'ö ga. 'Ö mɛ 'saadhö 'wo 'wun bhë 'wo‑ ma, 'ö 'suö ꞊va ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","'Ö ‑dadhëü 'në gɔɔn‑ ‑nu ‑wo nu 'wo sɔ më ‑a ‑bha 'wo dhoë 'wo‑ ‑bin. ");
INSERT INTO dnj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","꞊Dhɛ 'ö pë ‑mɔ 'lɛlɛ ‑yaaga ‑bha ꞊ya ziö, 'ö Ananiasö ‑bha dhebɔ ‑yö ‑da kɔɔ. 'Wun 'ö ‑kë bhë yaa‑ gbɛ ꞊tɛi' dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","'Ö Piɛɛ ‑ya ꞊dhɛɛ' kpɔ 'ö‑ pö: «‑Bhö 'wun gia‑ ꞊blɛɛ'‑ n ‑dhë! 'Wëüga 'ö 'ka ka ‑bha ‑dhɛ 'dhɔɔ dɔ ‑a ‑bha bhë 'ö ꞊nɛ ꞊a?» 'Ö‑ pö ‑a ‑dhë: «꞊Ii‑, ‑a 'wëü‑ 'ö bhë.» ");
INSERT INTO dnj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","'Ö Piɛɛ ‑ya pö ‑a ‑dhë ꞊nɛɛ: «‑Më ‑kë ka ꞊zuö' ‑yö ‑kë do kö 'kaan‑ ‑Zlan ‑bha ‑Zuu 'gü dan ꞊ɛ? ‑Dhɛ ‑ga, mɛ ‑nu 'wo go ü ꞊gɔn ‑bin ꞊dhia, ‑wo 'kɔ 'dhiö kö ‑waan 'dho ü 'ka 'pö.» ");
INSERT INTO dnj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","‑Yö ‑to ‑dhɛ do bhë ‑a 'gü 'pö, 'ö ‑püö Piɛɛ ꞊gɛɛndhö mü, 'ö ga. 'Ö 'në gɔɔn‑ ‑nu 'wo ꞊sia 'zü, 'wo ‑da kɔɔ 'wo‑ yö kö ꞊ya ga 'pö; 'ö 'wo dhoë 'wo‑ ‑bin ‑a ꞊gɔn 'sian 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","꞊Dhɛ 'ö 'wun 'ö ꞊nɛ 'ö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'saadhö waa‑ mɛ ‑nu 'wo to 'ö ꞊waa‑ ma, 'suö ꞊va ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesu ‑bha bɔmɛ ‑nu ‑wo ‑dhidhaapë ꞊plëëzë ‑nu ‑kë 'sɛgümɛ ‑nu wö 'dhiö. Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ꞊ya kë ‑wo ‑dho wo 'ko ꞊bhaa 'kɔdɔɔdɔdhɛ ꞊va mɛ 'wo‑ ‑dhɛ Salomɔ ‑bha 'kɔdɔɔdɔdhɛ bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mɛ ‑nu 'waa Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'ka bhë, ‑a ‑dhɔ 'yaa kë ‑an ‑bha kö ‑wo 'dho ‑an 'piö, kö 'wo kpa ‑an ‑bha. ‑Yö ‑kë 'dhö 'kɛɛ ‑wo ‑an 'tɔ ‑blü ‑an këwun ‑nu ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","'Ö mɛ gbung ‑nu, gɔɔn‑ ‑nu, dhoo ‑nu ‑wo nu; ‑wo kë ꞊va 'ö 'wo kwa Dëmɛ ‑wun ‑dhɛ 'wun gia‑, 'ö 'wo ‑da Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo bhë ‑an ‑bhüö 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","‑Dhidhaapë 'ö Yesu ‑bha bɔmɛ ‑nu ‑wo ‑kë ‑a kë ꞊dhia bhë ‑an ‑wun 'gü mɛ ‑nu ‑wo nu wo ‑bha 'yuamɛ ‑nu 'ka, zian ‑gblooga 'ö Piɛɛ dho bɔ ‑a ‑ta bhë ‑a 'piö, 'wo ‑an ‑da ꞊gba ‑nu, ꞊sɛɛ' ‑nu ‑ta kö ꞊ya kë ꞊nɛ Piɛɛ ‑yö ziö ‑na kö ‑a 'bin 'kpaan ‑ya kpa 'yuamɛ ‑nu 'wo bhë ‑an mɛ 'bhaa ‑nu ‑ta kö ‑an ‑dhɛ ‑yaan bo. ");
INSERT INTO dnj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mɛ ‑gbaa ꞊va 'wo go 'pö pödhɛ ‑nu 'wo Zeluzalɛmë ‑zü ‑zü 'to ‑dhɛ ‑nu ‑bha ‑an 'gü, 'wo nu wo ‑bha 'yuamɛ ‑nu waa‑ mɛ ‑nu 'ö ‑zuu yaa ‑nu ‑kë ‑an 'gü ‑an 'ka, 'ö ‑an 'plɛ ‑dhɛ ‑yö bo; ‑zuu yaa ‑nu ‑wo ‑go ‑an 'gü 'pö. ");
INSERT INTO dnj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","꞊Dhɛ ꞊ya kë 'pö slabhomɛ ꞊va waa‑ ö mɛ ‑nu 'wo ‑kë Saduse ‑mɛ ‑nu 'ka, ‑wo pa ꞊druɛi 'ka Yesu ‑bha bɔmɛ ‑nu 'wo bhë ‑an buëndhö. 'Wo‑ pö ‑wo ‑dho pë 'bhaa kë ‑an 'ka; ");
INSERT INTO dnj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","'wo Yesu ‑bha bɔmɛ ‑nu kun, 'wo ‑an ‑da ‑kanso 'kɔɔdhö. ");
INSERT INTO dnj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","꞊Dhɛ 'ö ꞊wa dɔ gbeng, 'ö ‑Zlan ‑bha bɔmɛ do ‑yö nu 'yö ‑kanso 'kɔdhi ‑po ‑an ‑gɔ, 'ö ‑an yö plaan, 'ö‑ pö ‑an ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«‑Ka 'dho ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü, 'ka ‑tosiadhe kë ‑kɔ ‑dëü ‑zian 'ö bhë ‑a ‑wun ꞊blɛɛ'‑ mɛ ‑nu ‑dhë!» ");
INSERT INTO dnj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","'Ö Yesu ‑bha bɔmɛ ‑nu ‑wo 'wun ma ‑a ‑wo ‑ta. 'Ö ‑dhiadhiö tii 'gü 'wo dho ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü 'wo yö mɛ ‑nu ꞊daan' ‑sü ‑bha. 'Ö slabhomɛ ꞊va waa‑ mɛ ‑nu 'saadhö 'wo ‑kë ‑a 'piö, 'wo Zuifö mɛ ziizii ‑nu 'saadhö ꞊dhɔɔ ‑kë wo 'ko ꞊bhaa kö ‑waan ‑ya 'kuë‑ kë. ('Yan ‑to ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑bha ‑mɛ ‑nu ‑gɔmɛ ‑yö ‑kë ‑an ziën mü 'pö.) ꞊Dhɛ ꞊ya ‑kë 'pö, 'wo 'dhasi ‑nu bɔ kö ‑waan 'dho Yesu ‑bha bɔmɛ ‑nu 'wo bhë ‑an ‑dhɛ ꞊dhia ‑kanso 'kɔɔdhö. ");
INSERT INTO dnj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","'Kɛɛ ꞊dhɛ ꞊wa 'dho ꞊wa ‑lo ‑kanso 'kɔɔdhö, waa ‑an yö. 'Wo ‑yɛ wo 'zü 'wo nu, 'ö 'wun 'ö ‑kë 'ma bhë 'wo‑ ꞊blɛɛ, ");
INSERT INTO dnj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","'wo‑ pö: «꞊Dhɛ 'yi ‑lo 'ma, yi ‑kanso 'kɔdhi ‑nu ‑yö kö ‑wo ta ‑sü 'ka ‑së 'ka. 'Yi 'yan ‑to 'kɔdhi ‑bha ‑mɛ ‑nu yö kö ‑wo dɔ ‑sü 'ka ‑kanso 'kɔdhi ‑nu ‑bha. 'Kɛɛ ꞊dhɛ 'yi 'kwɛɛ ‑po 'yi ꞊kpɔɔ kɔɔ, yië mɛ gbɛ yö.» ");
INSERT INTO dnj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","꞊Dhɛ 'ö 'yan ‑to ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑bha ‑mɛ ‑nu ‑gɔmɛ waa‑ slabhomɛ ‑gɔmɛ ‑nu ꞊wa 'wun bhë ‑a ma, 'ö‑ ‑wun ‑yö ‑an 'te tun, Yesu ‑bha bɔmɛ ‑nu ‑bha ꞊dhɔng 'wo‑ wo ‑kanso 'kɔɔdhö bhë ‑a ‑wun 'gü. 'Ö pë 'wo dho ‑a kë waa‑ dɔ. 'Ö 'wo‑ pö wo 'ko ‑nu ‑dhë: «‑Më 'ö 'dhoë‑ kë bhë ‑o?» ");
INSERT INTO dnj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","‑Wo ‑to mü, 'ö mɛ do ‑yö ‑wo, 'ö‑ pö ‑an ‑dhë: «‑Ka dɔ! Mɛ ‑nu 'ö 'ka ‑an kun, 'ka ‑an ‑da ‑kanso 'gü bhë, ‑wo ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü ‑de, mɛ ‑nu ꞊daan' ꞊dhia!» ");
INSERT INTO dnj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","꞊Dhɛ ꞊ya kë 'dhö, 'ö 'yan ‑to ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑bha ‑mɛ ‑nu ‑gɔmɛ waa‑ ö bha mɛ ‑nu 'wo ‑kë ‑an ziën mü bhë 'wo dho 'wo ‑an kun, 'wo nu ‑an 'ka. 'Kɛɛ waa pë 'dhiö‑ gbɛ kë ‑an 'ka, bhii ‑wo ‑suö kö ꞊kun 'ö 'sɛgümɛ ‑nu dho wo ‑zuö ‑guö 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","꞊Dhɛ 'ö ꞊wa ‑lo, 'wo dho ‑an 'ka ‑yakuëkëmɛ ‑nu 'dhiö. 'Ö slabhomɛ ꞊va ‑yö ‑an ꞊dhɛɛ' kpɔ, ");
INSERT INTO dnj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","'ö‑ pö ‑an ‑dhë: «Yiëë ka tɔng dɔ, yiëë‑ pö kö ꞊kun 'ka mɛ gbɛ ꞊daan gbɔ mɛ 'ö bhë ‑a 'tɔ 'ka a? 'Yö ꞊dhɛ ‑kë 'dhö, ‑më 'ö 'ka‑ kë ‑na ꞊nɛ ꞊ɛ? 'Ka ka ‑bha mɛ ꞊daan' ‑wo ‑nu sa Zeluzalɛmë plöö ‑dhɛ 'plɛ 'gü; 'yö gɔɔn‑ 'ö bhë ‑a ‑bha ga ‑sü bhë 'ka‑ 'piö kö 'kaan‑ ‑a ‑wun ‑lo yi tuö.» ");
INSERT INTO dnj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","'Ö Piɛɛ waa‑ Yesu ‑bha bɔmɛ ‑nu 'wo to, 'wo ‑daa ‑kë ‑a ‑gɔ 'wo‑ pö: «Yi ‑dho 'wun ma ‑Zlan ‑ta 'ö ꞊zië' mɛ 'bhee‑ ‑ta! ");
INSERT INTO dnj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesu 'ka‑ zë, ‑a ‑dɔ ‑gaatalü ‑bha ‑sü 'ka bhë, kwa 'bhɛma ‑nu ‑bha ‑Zlan ꞊yaa‑ bho ga 'gü, ");
INSERT INTO dnj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","꞊yaa‑ ꞊luu' ö 'piö ꞊yaa‑ ‑ya ö bha ‑yadhɛ ꞊bhlëzë ‑bha. 'Go mü 'ö‑ ‑ya ‑Gɔmɛ waa‑ Mɛdhamɛ 'ka, 'ö‑ ‑kë kö Izlaɛlö 'sɛgümɛ ‑nu ‑waan bɔ ‑a ‑ta ‑waan wo ‑bha ‑tosiadhe ꞊dhië' ‑kwaa kö ‑wo ꞊dhië'‑ ‑a 'piö kö ‑Zlan ‑yaan ziö ‑an ‑bha ꞊sɔɔn yaa ‑nu ‑ta. ");
INSERT INTO dnj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","'Wun ‑nu 'wo bhë yi ‑an ‑tɔmɔ 'ka. 'Ö ‑Zuu 'slööslö 'ö ‑Zlan ‑ya nu mɛ 'wo 'wun ma ‑a ‑ta ‑an ‑dhë bhë, 'ö‑ ‑tɔmɔ 'ka 'pö.» ");
INSERT INTO dnj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","꞊Dhɛ 'ö ‑yakuëkëmɛ ‑nu ꞊wa ‑wo 'ö bhë ‑a ma, 'ö 'wun ‑yö na ‑an ‑zuë ꞊duö, 'ö 'wo ‑kë ‑a 'piö kö 'wo Yesu ‑bha bɔmɛ ‑nu zë. ");
INSERT INTO dnj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","'Kɛɛ ‑an ziën, Falizi ‑mɛ do 'wo‑ ‑dhɛ Gamaliɛlö 'ö ‑kë tɔnggɔmɛ do 'ö 'sɛgümɛ ‑nu ‑wa ꞊bhlë ‑ya ꞊va 'ka ‑a 'ka, ‑yö ‑kë mü. 'Ö ꞊luu ‑yakuëkëmɛ ‑nu ziën, 'ö‑ pö ‑an ‑dhë ‑wo Yesu ‑bha bɔmɛ ‑nu yö plaan. ");
INSERT INTO dnj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","꞊Dhɛ ꞊ya kë 'pö, 'ö‑ pö ‑yakuëkëmɛ ‑nu 'wo bhë ‑an ‑dhë: «Izlaɛlö ‑mɛ ‑nu, ‑ka ka ‑zo kë ka ‑de 'piö, pë 'ka dho ‑a kë mɛ ‑nu 'wo ꞊nɛ ‑an 'ka bhë ‑a ‑wun 'gü 'dhɛ! ");
INSERT INTO dnj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","‑A ‑dhɛ yaa ꞊glɔɔ ꞊kun 'ö mɛ 'wo‑ ‑dhɛ Tëuda bhë, ‑yö nu 'ö ö ‑de sü mɛ 'gianzë 'ka. 'Ö mɛ 'wo ‑mɔ mɛ ‑lü ꞊këng' ‑yiisië ‑bha 'wo ‑ziö ‑a 'piö. 'Kɛɛ ‑wa ‑zë. 'Ö ꞊dhɛ ꞊waa‑ zë 'ö mɛ 'töüdhö 'wo ‑kë ‑a 'piö 'wo ‑pɛn 'ö ‑an 'plɛ ‑wo ‑kan wo 'kuë‑. ");
INSERT INTO dnj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","꞊Dhɛ ꞊ya kë 'dhö, mɛ ꞊dhong' ‑kwɛ 'töng 'ka 'zü, 'ö Galile mi 'wo‑ ‑dhɛ Zuda, 'ö nu 'ö mɛ ꞊plëëzë ‑gan ö 'piö, 'ö 'wo‑ zë 'pö; 'kɛɛ mɛ ‑nu 'saadhö 'wo ‑ziö ‑a 'piö bhë 'wo ‑pɛn 'zü. ");
INSERT INTO dnj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","꞊Dhɛ 'ö ‑kë 'dhö ꞊nɛ, a‑ ‑pö ka ‑dhë: ‑Ka ka ‑zo bho gɔɔn‑ ‑nu 'wo bhë ‑an 'piö, 'ka ka ꞊kwaa'‑ ‑an ‑zü, ‑wo 'dho! Bhii 'ö tɔɔ ꞊ya kë ꞊nɛ ‑an ‑bha 'slë waa‑ ‑an këyuö ‑nu bhë ‑wo ‑go mɛ 'bhee‑ 'gü, kö ‑yö ‑dho wü. ");
INSERT INTO dnj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","'Kɛɛ ꞊ya kë ꞊nɛ ‑yö ‑go gia‑ wo ‑Zlan 'piö, ka ‑kɔ 'ka 'dho ‑mɔa kö 'ka‑ 'gü ꞊siö'‑. ‑Kaa kë 'slë 'ka kö ꞊kun 'ka 'ko zë ‑Zlan 'ka!» 'Ö ‑yakuëkëmɛ ‑nu 'wo bhë 'wo ‑we Gamaliɛlö ‑wo ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","'Ö 'wo Yesu ‑bha bɔmɛ ‑nu 'wo bhë 'wo ‑an ꞊dhɔɔ ‑kë. 'Wo‑ pö 'dhasi ‑nu ‑dhë ‑wo ‑an ‑ma. ꞊Dhɛ ꞊wa ‑an ‑ma, 'wo‑ pö ‑an ‑dhë kö ꞊kun 'wo 'wun ꞊blɛɛ mɛ ‑nu ‑dhë gbɔ Yesu 'tɔ 'ka; 'ö 'wo wo ꞊kwaa ‑an ‑zü. ");
INSERT INTO dnj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","'Ö Yesu ‑bha bɔmɛ ‑nu ‑wo go ‑ya 'kuë‑ bhë ‑a ‑ta, ꞊zuögludhi ꞊va 'ka, bhii ‑yö wo ‑ma 'kun ‑wun 'ka kö wo 'klo ‑yaan bhɔ Yesu 'tɔ ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","'Ö yi 'saadhö 'ka, ‑Zlan ‑gba ‑a 'gü ‑kɔ ‑dhɛ waa‑ kɔɔdhɛ ‑nu ‑bha, 'wo mɛ ‑nu ꞊daan ‑kplawo 'wuntaɔsë 'ö ‑gban Yesu 'ö ‑Zlan ‑bha ‑Yamɛ 'ka ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","꞊Dhɛ 'ö 'töng 'bhaa ꞊ya ziö, kö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑wo kë ‑na ꞊va ‑kplawo, 'wun ‑blɛɛ ‑wo ꞊löö ‑sü ‑yö ‑da Zuifö ‑nu 'wo bhë ‑an mɛ ‑nu 'wo Glɛkö ‑wo ma 'wo bhɔ 'sɛ gbɛ 'gü waa‑ Zuifö 'në giagia ‑nu ‑an ziën. ‑An mɛ ‑nu 'wo bhɔ 'sɛ gbɛ 'gü bhë ‑wo ‑kë ‑a pö ꞊dhia 'waa ‑bhöpë nu wo ‑bha ꞊gɛandhoo ‑nu ‑dhë ꞊nɛ ‑kɔ 'wo‑ nu ‑na ‑a 'ka ‑a mɛ 'wo to ‑an ‑dhë bhë ‑a 'dhö, pë ꞊bhöü‑ 'wo‑ ‑glu ‑na yi 'saadhö 'ka bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","'Ö Yesu ‑bha bɔmɛ ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo bhë 'wo ‑to Yesu 'piö ‑mɛ ‑nu ‑dho 'kuë‑ ‑sü ꞊dhɔɔ ‑kë wo 'ko ꞊bhaa, 'wo‑ pö ‑an ‑dhë: «Yi dhegluzë ‑nu, yaa 'dho kë ‑së kö 'yiën‑ yi ꞊kwaa'‑ ‑Zlan ‑wo ꞊blɛɛ' ‑sü ‑zü kö 'yiën‑ yi ‑zo kë ‑bhöpë ‑wun 'piö! ꞊Dhɛ ‑kë 'pö, ‑ka mɛ 'slaplɛ 'ö mɛ 'plɛ ‑wo ‑an 'tɔ ‑së to 'ö ‑Zuu 'slööslö 'dhö ‑an pa ‑sü 'ka, 'ö 'kpaakpadhɛ 'dho ‑an ‑gɔ ‑an 'sü ka ziën kö 'yiën‑ yuö 'ö bhë ‑a kpɔ ‑an kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","꞊Ya kë 'pö, 'yi ‑dho ‑mɔa kö 'yiën‑ 'töng 'plɛ 'sü 'yiën‑ dhoë 'dhiö, ꞊bhɛa' ‑sü waa‑ ‑Zlan ‑wo ꞊blɛɛ' ‑sü 'ka.» ");
INSERT INTO dnj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","'Ö ‑an 'saadhö 'plɛ ‑wo ‑we ‑an ‑wo bhë ‑a ‑bha. ꞊Dhɛ ‑kë 'dhö 'wo Etiɛnë 'ö pa ‑sü 'ka ‑zo ‑yö ‑Zlan ‑bha ‑sü waa‑ ‑Zuu 'slööslö 'ka bhë, 'wo‑ sü. 'Wo Filipö sü, 'wo Plokɔlö sü, 'wo Nikanɔɔ sü, 'wo Timɔ sü, 'wo Paamenasö sü, 'ö Nikola 'ö go Antiɔsö 'ö ö ꞊zuö' ꞊dhië Zuifö ‑nu ‑bha ꞊bhɛa' ‑kɔ 'gü 'dhiö ‑be bhë, 'wo‑ sü. ");
INSERT INTO dnj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","'Wo ‑an ‑zɔn Yesu ‑bha bɔmɛ ‑nu ‑dhë; 'wo ꞊bhɛa ‑an ‑wun 'gü wo ‑kɔ ‑kpa ‑an ‑ta ‑sü 'ka, ‑yö kë 'dhö kö ‑wo ‑ya ‑de ‑ta ‑Zlan ‑bha 'ka yuö bhë ‑a kë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","‑Zlan ‑wo ‑yö ‑kë 'dho ꞊dhia 'dhiö, kö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑dho 'kuë‑ ‑sü ‑yö kë ꞊dhia ꞊va ‑kplawo Zeluzalɛmë plöö; slabhomɛ ‑dhɛ ꞊va ‑dhɛ ‑wo ‑we ‑a ‑bha kö ‑wo wo ‑zo yö Yesu ‑bha 'pö. ");
INSERT INTO dnj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiɛnë 'ö ‑Zlan ‑bha 'dhuë‑ waa‑ ‑bha 'piigbeedhɛ ‑yö ‑kë ‑a ‑gɔ bhë, ‑yö ‑dhidhaapë ꞊vava ‑nu ‑kë mɛ ‑nu wö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","'Yö Zuifö ‑mɛ ‑nu ‑bha ‑bhɔkuëkɔ 'gü ‑mɛ ‑nu 'ö 'wo ‑an ‑dhɛ «‑go 'gan 'gü ‑mɛ ‑nu» 'wo go Silɛnë ‑sɛ 'gü 'dhö oo, ‑a mɛ ‑nu ‑wo go Alezandri ‑sɛ 'gü waa‑ Zuifö mɛ 'bhaa ‑nu gbɛ 'ö 'wo go Silisi ‑dhɛ waa‑ Azi ‑dhɛ ‑an 'gü 'wo yö zaɔdhe kë ‑sü ‑bha Etiɛnë 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","'Kɛɛ ‑an 'dhi ‑yö ‑kun 'ö ‑an ‑kɔ yaa ‑mɔa ‑bha kö ‑waan 'wun ꞊blɛɛ'‑ 'zü, bhii Etiɛnë ‑yö 'wun ‑blɛɛ 'kpaakpadhɛ 'ö ‑Zuu 'slööslö ‑ya nu ‑a ‑dhë bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","꞊Dhɛ ‑kë 'dhö, 'wo më mɛ ‑nu 'piö 'wëü‑ 'ka kö ‑waan ‑a pö: «Yi‑ ‑wo ‑ma kö ‑yö 'wun ꞊blɛɛ' ‑na Moizö waa‑ ‑Zlan ‑an ‑gɔ.» ");
INSERT INTO dnj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","‑Kɔ 'ö 'wo 'sɛgümɛ ‑nu, mɛ ziizii ‑nu waa‑ tɔnggɔmɛ ‑nu 'wo ‑an zü ꞊blüë' bhë 'ö bhë. 'Ö 'wo ‑lo Etiɛnë ‑ta 'wo‑ kun 'wo dho ‑a 'ka zakanmɛ ꞊va ‑nu 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","'Yö 'wo nu mɛ ‑nu 'wo dho ꞊sua ‑wun dɔ Etiɛnë ‑bha bhë ‑an 'ka 'ö mɛ ‑nu bhë 'wo‑ pö: «Gɔɔn‑ 'ö ꞊nɛ 'yaa ö bo 'wun ꞊blɛɛ' kwa ‑bha ‑Zlan ‑gba ‑a 'gü ‑kɔ 'slööslö waa‑ Moizö ‑bha tɔng ‑nu ‑bha ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Yi‑ ‑wo ‑nu ‑ma ꞊nɛ Yesu 'ö go Nazalɛtë bhë ‑yö ‑dho ‑Zlan ‑gba ‑a 'gü ‑kɔ 'gü ꞊siö' 'ö kwa wɔ ‑kɔ 'ö Moizö ‑ya nu kwa 'bhɛma ‑nu ‑dhë bhë 'ö‑ bho piin.» ");
INSERT INTO dnj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Mɛ ‑nu 'saadhö 'wo ‑kë za 'kënng 'gü mü, 'wo wo 'yan bɔ Etiɛnë 'piö, 'wo‑ ‑ga ‑piindhö 'ö 'wo‑ wöödhɛ yö kö ‑yö 'bhü ‑na ꞊nɛ ‑Zlan ‑bha bɔmɛ wöödhɛ 'dhö. ");
INSERT INTO dnj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","꞊Dhɛ ꞊ya kë 'dhö, 'ö slabhomɛ ꞊va ‑yö Etiɛnë ꞊dhɛɛ' kpɔ 'ö‑ pö ‑a ‑dhë: «'Wun ‑nu 'wo‑ pö ü‑ ‑blɛɛ bhë, ü‑ ‑blɛɛ 'dhö gia‑ 'ka a?» ");
INSERT INTO dnj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","'Ö Etiɛnë ‑ya ‑daa ‑kë 'ö‑ pö: «N dë ‑nu, n dhegluzë ‑nu, ‑ka ka 'to 'to! ‑Zlan 'tɔbhɔsüzë ‑yö ö ‑de ‑zɔn kwa 'bhɛma Ablaamö ‑dhë kö ‑yö ꞊tun Mezopotami ‑sɛ 'gü kö ‑yaan ꞊tun 'dho ‑na ‑ya ꞊dhia pödhɛ 'wo‑ ‑dhɛ Kalan bhë ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","'Ö ‑Zlan ‑ya ‑pö Ablaamö ‑dhë: Bhi 'dhö, ü bha 'kɔɔmɛ ‑nu 'dhö, ‑ka 'go kaa‑ 'kɔɔmɛ ‑nu waa‑ kaa‑ 'sɛgümɛ ‑nu ‑an 'piö, 'ka 'dho 'sɛ 'a 'dhoë‑ ‑a ‑zɔn ka ‑dhë bhë ‑a 'gü! ");
INSERT INTO dnj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","꞊Dhɛ ꞊ya kë 'dhö, Ablaamö ‑yö ‑go Kalidee ‑sɛ 'gü, 'ö dho 'ö ‑ya Kalan. ‑Dhɛ 'ö bhë 'ö Ablaamö dë ‑yö ga ‑a ‑bha. 'Ö ‑Zlan ‑yö Ablaamö bɔ 'sɛ 'ö 'ka‑ 'gü zlöö ꞊nɛ ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","‑Zlan yaa ‑dhɛ gbɛ nu ‑a ‑dhë mü. ‑Dhɛ pë 'tee gia‑ 'ö dho kë ꞊nɛ kwa ‑gɛn pin 'dhö yaa‑ do nu ‑a ‑dhë kö ‑yaan kë ‑a ‑de ‑bha 'ka. 'Kɛɛ ‑Zlan ‑yö pë 'tɔ ‑go ‑a ‑dhë ꞊woë' ꞊nɛ ‑yö ‑dho 'sɛgɔ bhë ‑a nu ‑a ‑dhë, 'ö‑ nu ‑a ꞊suu'‑ ‑ta 'në ‑nu ‑dhë 'pö. 'Kɛɛ kö ‑a 'töng 'dhö bhë ‑a 'ka kö 'në gbɛ yaa kë Ablaamö ‑gɔ ꞊kun. ");
INSERT INTO dnj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","‑Wo 'ö ‑Zlan ‑ya ꞊blɛɛ ‑a ‑dhë yö ꞊ga 'ö ꞊nɛ: Ü ꞊suu'‑ ‑ta 'gü ‑mɛ ‑nu ‑wo ‑dho ‑tosiadhe kë ‑nia ‑dhɛ 'gü 'sɛ gbɛ ‑ta. ‑Wo ‑dho kë ꞊nua 'ka mü; 'ö mɛ ‑nu ‑wo ‑an 'klo bhɔ ‑kwɛ ꞊këng' ‑yiisië 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","'Kɛɛ a ‑dho 'klobhɔdhe ‑da 'sɛgümɛ ‑nu 'wo 'dhoë‑ ‑an kë wo ‑bha ꞊nua 'ka bhë ‑an ‑ta. ꞊Ya kë 'dhö, ‑wo ‑dho go 'sɛ 'wo ‑kë ‑a 'gü bhë ꞊nua 'ka bhë ‑a ‑bha kö ‑waan nu zö n gba ꞊dhia. » ");
INSERT INTO dnj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","'Ö Etiɛnë ‑yö dho 'wun ꞊blɛɛ' ‑sü 'ka 'dhiö 'ö‑ pö: «꞊Dhɛ ꞊ya kë 'dhö, ‑Zlan ‑yö ‑dhikuëdhe ‑kun Ablaamö 'ka, 'ö‑ ꞊dua' ‑yö ‑kë 'bɔn zë ‑sü 'ka. 'Ö Ablaamö ‑yö ö gbö Izaakö kpɔ, 'ö‑ zë 'bɔng kö ‑ya bhɔ ‑a ‑dhɛkpaɔyi ꞊ya kë 'slɛaga. ‑Kɔ do bhë ‑a 'ka 'pö, 'ö Izaakö ‑yö Zakɔbö zaa 'bɔng, 'ö Zakɔbö ‑de 'pö 'ö ö ‑bha 'në ‑nu 'gɔɔ‑ do ö ga ꞊plɛ 'wo ‑kë kwa 'bhɛma ‑wun 'gbeezë 'ka 'ö ‑an zaa 'bɔng. ");
INSERT INTO dnj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","'Yö kwa 'bhɛma ‑nu ‑wo ꞊druɛi ‑kë wo dheglu Zozɛfu ‑bha, 'wo‑ 'dhɔɔ dɔ kö ‑yaan kë ꞊nua 'ka Ezitö ‑sɛ 'gü. 'Kɛɛ ‑Zlan ‑yö ‑kë ‑a 'piö, ");
INSERT INTO dnj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","'ö‑ bho ‑a ‑bha ꞊sëëbhodhe 'plɛ 'gü, 'ö 'kpaakpadhɛ nu ‑a ‑dhë 'ö 'sla kpɔ ‑a ‑ta Falaɔn 'ö Ezitö ‑mɛ ‑nu ‑bha ‑gludë 'ka bhë ‑a 'dhiö. 'Ö Falaɔn ‑yö Zozɛfu ‑ya Ezitö ‑sɛ waa‑ ‑a ‑bha ꞊bhɔɔpë 'plɛ ꞊kɔɔnmɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","'Ö din ‑yö ‑da Ezitö ‑sɛ waa‑ Kana ‑sɛ ‑an 'gü. 'Ö ꞊sëëbhodhe ‑yö ‑kë ꞊gbaɔnsü, 'ö pë kwa 'bhɛma ‑nu 'wo dho ‑a yö ‑waan ‑bhö yaa kë ‑dhö. ");
INSERT INTO dnj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","꞊Dhɛ 'ö Zakɔbö ꞊yaa‑ ma ꞊nɛ 'blee‑ 'wo‑ ꞊bluu'‑ kë ‑na bhë ‑yö ꞊tun Ezitö ‑sɛ 'gü, 'ö ö bha 'në ‑nu 'wo kwa 'bhɛma ‑nu 'ka bhë ‑an bɔ 'ma kö ‑waan 'blee‑ 'dhɔ. ");
INSERT INTO dnj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","‑A kë ‑peedë ‑naa 'wo dhoë zlöö bhë 'ö Zozɛfu ‑yö ö ‑de ‑zɔn ö dhegluzë ‑nu 'wo bhë ‑an ‑dhë, 'ö Falaɔn ‑yö Zozɛfu ‑bha 'kɔɔmɛ ‑nu dɔ 'sabla. ");
INSERT INTO dnj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","꞊Dhɛ ꞊ya kë 'pö 'ö Zozɛfu ‑yö ‑naɔ dɔ ö dhegluzë ‑nu 'wo bhë ‑an ‑gɔ kö ‑waan dɔ wo dë Zakɔbö ‑gɔ kö ‑an dë waa‑ ö bha 'kɔɔmɛ ‑nu 'ö ‑an ‑dho 'kuë‑ ‑sü ‑yö ‑kë mɛ ‑lü 'gɔɔ‑ 'slaplɛ ö ga 'sɔɔdhu 'ka bhë kö ‑waan nu. ");
INSERT INTO dnj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","꞊Dhɛ 'ö ‑naɔ bhë ꞊waa‑ dɔ wo dë ‑gɔ, 'ö ‑an dë Zakɔbö waa‑ ö bha 'kɔɔmɛ ‑nu 'wo dho Ezitö ‑sɛ 'gü. 'Ö Zakɔbö ‑nu 'wo bhë 'wo to 'sɛ bhë ‑a 'gü 'ö yöë ‑an ‑bha ga ‑yi ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","꞊Dhɛ 'ö Zakɔbö ‑nu ꞊wa ga 'wo dho ‑an ꞊glöö 'ka Ablaamö ‑bha mɛ ‑bin ‑dhɛ 'ö‑ dhɔ Emɔɔ ‑bha 'në ‑nu ‑gɔ, Sikɛmë ‑pö 'gü bhë ‑a ‑bha. ‑Dhɛ do bhë 'wo kwa 'bhɛma ‑nu ‑bin ‑a ‑bha 'pö. ");
INSERT INTO dnj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","꞊Dhɛ pë 'ö ‑Zlan ‑ya 'tɔ go Ablaamö ‑dhë, 'ö‑ yi 'dhö 'to ‑na 'tee kö ‑yaan kë, kö kwa 'bhɛma ‑nu ‑wo ꞊bhɛɛ ‑na. 'Yö 'wo ‑kë ꞊plëëzë Ezitö ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","꞊Dhɛ ꞊ya kë 'pö, ‑gludë gbɛ 'ö yaa Zozɛfu dɔ ꞊nɛ Falaɔn 'dhö bhë 'ö yö Falaɔn pin ꞊taa Ezitö ‑sɛ ꞊kɔɔn ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","'Ö ‑gludë mɛ bhë 'yö kwa 'bhɛma ‑nu ‑püö 'ö ‑an 'klo bhɔ, 'ö ‑an 'gbeedhɛ bho kö ‑waan wo ‑bha 'në 'puu ‑nu ‑lo blöö, ‑wo wo ꞊kwaa'‑ ‑an ‑zü ‑wo ga. ");
INSERT INTO dnj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","'Töng gia‑ bhë ‑a 'ka 'ö Moizö ‑yö bhɔa. ‑Yö ‑kë 'në 'puu ‑së ꞊duö 'ö‑ ‑wun 'yi ‑yö ‑kan ‑Zlan ‑dhë ‑a 'ka. 'Ö‑ 'kpɔmɛ ‑nu ‑wa to kɔɔ 'su ‑yaaga 'piö 'wo wo ‑zo ‑kë ‑a 'piö ‑bin ‑blü kö ꞊kun Falaɔn dho ‑a ꞊tɛi' dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","꞊Dhɛ 'ö‑ 'kpɔmɛ ‑nu ꞊wa 'në bhë ꞊waa‑ dɔ blöö, ꞊wa wo ꞊kwaa'‑ ‑a ‑wun ‑zü, 'ö Falaɔn 'dhu ‑yö ‑kpën ‑a ‑bha 'ö‑ sü 'ö dhoë 'ö‑ ‑kë ö ‑bha 'në 'ka, 'ö ö ‑zo ‑kë ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","꞊Dhɛ ꞊ya kë 'dhö, 'wo Moizö ꞊daan Ezitö ‑mɛ ‑nu ‑bha 'wunbhokoudɔdhe 'saadhö 'plɛ 'ka, 'ö‑ 'pii ‑yö ‑kë 'gbee‑ ö 'dhi ‑wo waa‑ ö këpë ‑nu 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","꞊Dhɛ 'ö Moizö ‑kwɛ ꞊ya kë 'gɔɔ‑ ‑yiisië, 'ö‑ ꞊zuö' ‑yö ꞊luu kö ‑yaan 'dho ö dhegluzë ‑nu 'ö 'wo Izlaɛlö ‑mɛ ‑nu 'ka bhë ‑an 'piö kö ‑an ‑kë ‑a 'gü ‑kɔ ‑nu 'wo bhë ‑yaan dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","꞊Dhɛ 'ö dho, kö Ezitö mi do ‑yö mɛ ‑nu 'wo bhë ‑a mɛ do 'klo bhɔ ‑na 'kpaan; 'yö dho mɛ 'wo‑ 'klo bhɔ ‑na bhë ‑a ‑dhë, ‑a ‑zo bho ‑sü 'ka 'yö Ezitö mi bhë 'yö‑ zë. ");
INSERT INTO dnj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","‑Yö ‑kë ‑a ‑zo 'piö ‑bezë ꞊nɛ ö dheglu ‑nu 'wo Izlaɛlö ‑mɛ ‑nu 'ka bhë ‑wo ‑dho ‑a ‑gɛn dɔ ꞊nɛ, ‑Zlan ‑yö ‑dho bɔ ö ‑ta 'ö ‑an bho 'gan 'gü; 'kɛɛ waa ‑dhɛ gbɛ yö 'wun bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","‑A ‑dhɛ mɛ 'ö ‑po ‑a 'piö bhë Moizö ‑yö Izlaɛlö ‑mɛ ꞊plɛ ‑yö kö ‑wo 'ko zë ‑na 'ö‑ ‑kë kö 'ö ‑an dhi 'kuë ‑a ‑pö ‑an ‑dhë ‑sü 'ka: ‹Mɛ 'ka ꞊nɛ, ‑abi', kö ꞊kun 'ka 'ko zë ka 'kuë! 'Ö tɔɔ dhegluzë ‑mü ka 'ka!› ");
INSERT INTO dnj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","'Kɛɛ ‑a mɛ 'ö‑ ‑bha za 'dhö ya bhë ‑yö Moizö ‑kë ꞊woë' ꞊nɛɛ: ‹Yö 'ma ‑zian 'dhɛ! Dö 'ö ü ‑ya ‑gɔmɛ 'ka 'iin zakanmɛ 'ka yi ‑ta ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ü‑ 'piö kö 'ü n zë ꞊nɛ ‑kɔ 'ü Ezitö mi zaa yɛɛn bhë ‑a 'dhö a?› ");
INSERT INTO dnj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","‑Wo bhë ꞊dhɛ 'ö ‑da Moizö 'toodhö, 'yö ꞊duë 'ö dho 'ö ‑ya Madian ‑sɛ 'gü. ‑Dhɛ 'ö bhë ꞊nɛ 'ö to ‑a ‑bha 'ö 'në gɔɔn‑ ꞊plɛ kpɔ. ");
INSERT INTO dnj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","꞊Dhɛ 'ö ‑kwɛ 'gɔɔ‑ ‑yiisië ꞊ya ziö, 'ö ‑Zlan ‑bha bɔmɛ do ‑yö ö ‑de ‑zɔn Moizö ‑dhë 'yënngtaadhɛ 'ö ‑kë Sinai ‑tɔn 'sɔɔ bhë ‑a ‑bha; 'siö 'ö ‑kë ‑kpɔɔ kpö do 'güö ꞊dhia bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","'Yö Moizö 'te ‑yö tun, pë 'ö‑ yö bhë ‑a ‑wun 'gü. ꞊Dhɛ 'ö ꞊yɔɔn ‑na ‑kpɔɔ kpö 'ö bhë ‑a 'ka ꞊klöö' kö ‑yaan ‑a ‑ga 'papadhö, 'ö kwa Dëmɛ ‑Zlan ‑wo ma kö ‑ya pö ‑na: ");
INSERT INTO dnj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ma 'a tɔɔ ü 'bhɛma ‑nu ‑bha ‑Zlan, Ablaamö ‑bha ‑Zlan, Izaakö ‑bha ‑Zlan waa‑ Zakɔbö ‑bha ‑Zlan. 'Ö Moizö ‑yö yö ꞊zluun ‑sü ‑bha 'suö ‑dhë. 'Ö ‑dhɛ ‑ga 'ma ‑sü ‑yö ‑kë ‑a ‑dhë ‑ziizë. ");
INSERT INTO dnj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","'Ö kwa Dëmɛ ‑ya pö ‑a ‑dhë: ‹‑Bhö ü bha ‑sakpa bho ü ‑gɛan, bhii ‑dhɛ ü dɔ ‑a ‑bha bhë ꞊yö 'slööslö. ");
INSERT INTO dnj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","'Yënngbhɔdhe kë ‑na ma mɛ ‑nu ‑gɔ Ezitö ‑sɛ 'gü bhë, a‑ ‑yö, a ‑an 'gbo ‑wo ‑ma; pë ‑kë 'a ꞊yɔɔ 'aan‑ ‑an bho 'gan 'gü bhë 'ö bhë. ‑Bhö nu, ‑a yi ꞊ya ‑lo kö 'aan‑ ü bɔ Ezitö ‑sɛ 'gü 'sabla!› » ");
INSERT INTO dnj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","'Ö Etiɛnë ‑yö dho 'wun ꞊blɛɛ' ‑sü 'ka 'dhiö 'ö‑ pö: «Moizö 'ö Izlaɛlö ‑mɛ ‑nu waa 'we ‑a ‑wun ‑bha 'ö 'wo‑ pö ‑a ‑dhë: ‹Dö ü ‑ya yi ‑gɔmɛ waa‑ yië zadɔmɛ 'ka› bhë, yö do gia‑ bhë ꞊nɛ 'ö ‑Zlan ‑ya bɔ kö ‑yaan kë ‑an ‑bho 'gan 'gü ‑mɛ waa‑ ‑an ‑gɔmɛ 'ka. ‑Zlan ‑bha bɔmɛ 'ö ö ‑de ‑zɔn ‑a ‑dhë, ‑kpɔɔ kpö 'ö kë 'güö ꞊dhia ‑a 'gü bhë, yö ꞊nɛ 'ö nu ‑a ‑dhë kö ‑yaan kë Izlaɛlö ‑mɛ ‑nu ‑gɔmɛ waa‑ ‑an ‑bho 'gan 'gü ‑mɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moizö ꞊nɛ 'ö Izlaɛlö ‑mɛ ‑nu bho Ezitö ‑sɛ 'gü ‑dhidhaapë ‑nu kë ‑sü 'ka 'sɛ 'ö bhë ‑a 'gü, 'yoo nuɛazë 'dhiö waa‑ ‑kwɛ 'gɔɔ‑ ‑yiisië kë ‑sü 'ka 'yënng ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moizö bhë 'zü ꞊nɛ 'ö‑ pö Izlaɛlö ‑mɛ ‑nu ‑dhë: ‑Zlan ‑yö ‑dho ö ‑wodhiölomɛ do 'ö dho kë ꞊nɛ n 'dhö 'ö dho go ka ꞊suu'‑ 'gü ‑a bɔ ka ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moizö bhë 'zü ‑yö ‑kë Izlaɛlö ‑mɛ ‑nu ziën 'yënng ꞊taa. Yö ꞊nɛ 'töng 'wo‑ ꞊kaa' mü bhë 'ö ‑kë ‑Zlan ‑bha bɔmɛ waa‑ kwa 'bhɛma ‑nu ziën, 'ö ꞊ya kë 'ö ‑Zlan ‑wo 'ö ꞊toëpö ‑këdhösü nu mɛ ‑nu ‑dhë bhë 'ö ꞊yaa‑ ma 'dhö Sinai ‑tɔn tuö 'ö ꞊ya kë 'ö nu 'ö‑ 'dhiö ‑lo kwa 'bhɛma ‑nu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","'Kɛɛ kwa 'bhɛma ‑nu waa 'we ‑a ‑bha kö 'wo 'wun ma Moizö ‑ta. 'Ö 'wo ‑kɔ Moizö 'ka; 'wo‑ ‑dhɔ ꞊kaa' kö 'wo 'yɛ wo 'zü, 'wo 'dho Ezitö ‑sɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","'Ö 'wo‑ pö Aalɔn ‑dhë: ‹‑Bhö kwa ‑bha gbapë ‑nu 'wo dho 'ta sü kwa 'dhiö ‑an kë! Bhii Moizö 'ö kwa bho Ezitö ‑sɛ 'gü bhë, pë 'ö ‑kë ‑a 'ka 'kwaa‑ dɔ!› ");
INSERT INTO dnj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","'Ö 'wo 'sënng ‑du 'në do ‑kë 'ö 'wo sla‑ bho wo ‑bha gbapë bhë ‑a ‑dhë. 'Ö wo ꞊kwaa' ‑pë bhë, 'wo‑ 'wlaan‑ ‑kë. ");
INSERT INTO dnj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","'Ö ‑Zlan ‑yö ö ‑ta yö ‑an ‑bha 'ö ‑an ‑bha ‑yɛ 'zü ‑yö ‑kë 'susong ‑nu gba ‑sü 'ka ꞊nɛ ‑kɔ 'ö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑wodhiölomɛ ‑nu ‑bha 'sëëdhɛ 'gü bhë ‑a 'dhö ꞊nɛɛ: ‑Zlan ‑ya ‑pö: Izlaɛlö ‑mɛ ‑nu, ka wü ‑zë 'ka sla‑ ‑nu bhoë ‑kwɛ 'gɔɔ‑ ‑yiisië 'piö 'yënng ꞊taa, 'kɛɛ n ‑ma sla‑ 'yaa ‑mü. ");
INSERT INTO dnj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ka ‑bha ‑zlan Mɔlɔkö 'yö 'ka‑ ‑bha sɔ 'kɔ sü, 'ka dhoë ‑dhɛ 'plɛ 'ö 'ka dho ‑a ‑bha ‑a 'ka, 'ö kaa‑ ‑zlan 'ö‑ 'tɔ ‑kë Lefan 'ka 'ö‑ ꞊dua' ‑yö ‑kë 'susong 'bin 'ka bhë, 'ka‑ sü 'pö. Gbapë ‑nu 'wo bhë ka ‑an ‑kë ka ꞊kwaa'; 'ö 'ka ‑an gba. ‑A ‑wun 'gü a ‑dho ‑a kë kö ‑waan 'dho ka 'ka ꞊gbiin Babilɔnë ‑dhɛ ꞊zlöö. ");
INSERT INTO dnj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","꞊Dhɛ 'ö kwa 'bhɛma ‑nu ‑wo ‑kë 'yënng ꞊taa bhë, sɔ 'kɔ 'ö‑ ‑zɔn ‑an ‑dhë ꞊nɛ ‑Zlan ‑yö wo 'piö, 'ö ‑guö 'fa ‑nu 'ö tɔng dɔ ‑wo ‑nu 'dhö ꞊bɛɛn' ‑sü 'ka ‑a ‑ta ‑wo ‑kë ‑a 'gü bhë ‑yö ‑kë ‑an ‑gɔ mü. Sɔ 'kɔ 'ö bhë ‑wa ‑kë ꞊nɛ ‑kɔ 'ö ‑Zlan ‑ya ꞊blɛɛ ‑a 'ka Moizö ‑dhë, 'ö‑ ‑zɔn ‑a 'ka ‑a ‑dhë bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","'Ö sɔ 'kɔ bhë 'ö dɔ 'pö kwa 'bhɛma ‑nu 'wo yö ‑an 'piö bhë ‑an kwɛɛ. 'Ö Zozue ‑yö yö ‑an ‑dhë 'dhiö, 'wo sɔ 'kɔ bhë 'wo‑ sü 'wo dhoë Kanaa ‑sɛ 'gü. ‑An ‑lo mü ꞊yië', kö ‑Zlan ‑ya 'sɛ bhë ‑a 'gü ‑mɛ ‑nu kë ‑an 'dhiö; 'yö 'wo ‑an ‑bha 'sɛ kun ‑an ‑gɔ. 'Ö sɔ 'kɔ bhë 'ö to ‑an ‑gɔ, 'sɛ 'wo‑ kun bhë ‑a 'gü, 'ö dhoë 'ö yöë Davidö ‑bha yi ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davidö ‑wun ‑yö ‑Zlan ‑zo ‑kun. 'Ö Davidö ‑ya ‑dhɛ ö ‑bha ‑Zlan 'ö ‑kë ö 'bhɛma Zakɔbö ‑bha ‑Zlan 'ka bhë ‑a ‑gɔ kö ‑yaan ‑a ‑bha 'kɔ dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","'Kɛɛ Salomɔ ꞊nɛ 'ö 'kɔ bhë 'ö‑ dɔ zlöö. ");
INSERT INTO dnj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","'Kɛɛ a‑ ꞊blɛɛ ka ‑dhë giagia 'ka ꞊nɛ ‑Zlan 'yö ꞊va, 'yaa ‑ya 'kɔ ‑nu 'ö mɛ 'bhee‑ ‑nu 'wo‑ dɔ ‑an 'gü ꞊nɛ ‑kɔ 'ö‑ ‑wodhiölomɛ ‑ya ꞊blɛɛ ‑a 'ka bhë ‑a 'dhö ꞊nɛɛ: Kwa Dëmɛ (‑Zlan) ‑ya ‑pö: ");
INSERT INTO dnj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Dhang‑ 'gü ‑dhɛ 'ö tɔɔ ma 'gɔ ‑gbloo 'gü ‑dhɛ, 'ö 'sɛ 'dhö n ‑gɛn ‑gban ‑a ‑ta ‑pë 'ka. ꞊Dhɛ 'ö 'pö, 'kɔ ꞊suu'‑ ‑mlë 'ö 'ka dho ‑a dɔ n ‑dhë ‑ɛ? 'Iin ‑dhɛ ‑mlë 'a dho n 'tɛɛ ‑nu pa ‑a ‑bha ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ma ‑de kun 'a pë ‑nu 'wo bhë 'a ‑an 'plɛ ‑kë ‑a? » ");
INSERT INTO dnj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","'Go mü 'zü 'ö Etiɛnë ‑ya pö: «꞊Dhɛ 'ö ‑kë 'dhö ꞊nɛ mɛ ꞊gɔü' 'gbeezë 'ka ꞊nɛ, 'ö ka ꞊zuö' ‑nu, ka 'to ‑nu, ꞊wa ta ‑Zlan ‑wo ‑gɔ, 'ö 'kaa 'we ‑a ‑bha kö 'kaan‑ 'wun ma ‑Zuu 'slööslö ‑ta ‑kplawo bhë, ka bhɔ ka 'bhɛma ‑nu ‑bha giagiawo ꞊dhɛɛ! ");
INSERT INTO dnj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","‑Zlan ‑wodhiölomɛ ‑nu 'wo bhë, ‑a dö ‑zë 'ö ka 'bhɛma ‑nu waa ‑a 'klo bho ꞊ɛ? 'Ö mɛ ‑nu 'wo mɛ kpengdhö do ‑bha nu ‑sü ‑wun ꞊blɛɛ'‑ bhë, 'wo ‑an zë. Mɛ kpengdhö 'ö bhë 'ö 'ka‑ dɔ mɛ ‑nu kwɛɛ, 'wo‑ zë. ");
INSERT INTO dnj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","‑Zlan ‑yö tɔng ‑nu ka ‑dhë 'ö bɔa ö ‑bha bɔmɛ ‑nu ‑ta; 'ö tɔng 'dhö bhë kaa‑ ꞊bhlë 'kpɔ.» ");
INSERT INTO dnj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","꞊Dhɛ zakanmɛ ‑nu ꞊wa Etiɛnë 'wun ꞊blɛɛ' ‑wo ma, 'yö 'wun ‑yö ‑na ‑an ‑zuë ꞊gbaɔnsü. ");
INSERT INTO dnj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","'Kɛɛ Etiɛnë 'ö ‑Zuu 'slööslö ‑ya pa bhë 'ö ‑dhɛ ‑ga dhang‑ 'gü, 'ö ‑Zlan ‑bha 'tɔbhɔdhe 'bhü yö; 'ö Yesu yö kö ‑yö dɔ ‑sü 'ka ‑Zlan ‑bha ‑dhɛ ꞊bhlëzë ‑bha, ");
INSERT INTO dnj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","'ö‑ pö: «‑Ka dɔ 'dhɛ, dɔ 'a‑ wo ꞊nɛ, 'ma ‑kpën dhang‑ ‑nu ‑bha, ‑an 'dhi ‑yö 'po ‑sü 'ka; Mɛgbö 'ö dɔ ꞊süë' ‑Zlan ‑bha ‑dhɛ ꞊bhlëzë ‑bha bhë a‑ ‑yö 'pö.» ");
INSERT INTO dnj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","꞊Dhɛ ‑kë 'dhö 'wo yö ‑gbla 'gbee‑ 'ka ‑sü ‑bha, 'wo wo ‑kɔ yö wo 'toë‑, wo 'to ta ‑sü 'ka (kö ‑waan 'kun 'wun 'ö‑ ꞊blɛɛ bhë ‑a ma ‑sü 'ka ‑a ‑zɔn ‑sü 'ka ꞊nɛ pë 'ö‑ ꞊blɛɛ' ‑na bhë ‑yö ‑Zlan ‑sü ya ‑sü 'ka). 'Ö ‑an 'plɛ ‑wo ꞊luu wo 'kuë, 'wo dho 'wo ‑lo Etiɛnë ‑ta. ");
INSERT INTO dnj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","'Wo‑ ꞊gblëë 'wo dhoë pö‑ ꞊taa ‑bha 'wo yö ‑a ꞊zëë ‑zë ‑guö 'ka ‑sü 'gü kö ‑waan ‑a zë. 'Ö mɛ ‑nu 'wo ‑tɔmɔdhɛ ‑kë Etiɛnë ‑bha zadɔyi 'ka bhë, 'wo wo ‑bha ‑da sɔ ‑ta dhuö ‑sɔ bho wo ‑bha, 'wo‑ nu 'nëgɔɔnzë ‑dadhëü 'wo‑ ‑dhɛ Sɔlö bhë ‑a ‑dhë kö ‑yaan ö 'yan 'to ‑a ‑bha kö 'woë‑ wo ‑bha ‑guö ‑zuö ‑dhɛ yö. ");
INSERT INTO dnj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","꞊Dhɛ 'wo Etiɛnë zë ‑na ‑guö 'ka bhë, ‑yö ‑bhɛa 'ö‑ pö: «N Dëmɛ Yesu, 'ma n ‑de ‑wun ‑lo ü kwɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","꞊Dhɛ 'ö ‑kë 'pö 'ö ‑lo ö kpɔn 'gü 'ö ‑gbla 'gbee‑ 'ka ꞊nɛɛ: «N Dëmɛ, ü ‑bha 'gën ‑mü; ü ‑zo bho ‑an ‑bha ꞊sɔɔn yaa bhë ‑a 'piö!» ꞊Dhɛ 'ö‑ pö 'dhö 'ö‑ ‑zo ‑yö dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Etiɛnë zë ‑sü bhë, Sɔlö ‑zo ‑yö ‑we ‑a ‑bha. 'Ö mɛ ‑nu 'wo ‑Zlan ꞊bhlë ‑ya 'wo Etiɛnë ‑bin, 'ö 'wo 'gbo bɔ ꞊va ‑a ‑wun 'gü. Yi gia‑ bhë ‑a 'ka, ‑Zlan ‑bha mɛ ‑nu 'wo Zeluzalɛmë 'ö ‑an ‑bha 'klobhɔdhe ꞊va zü yö dɔa. 'Ö ‑kan Yesu ‑bha bɔmɛ ‑nu ‑bha, Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'plɛ ‑wo ‑pɛn, 'wo dho Zude ‑sɛ waa‑ Samali ‑sɛ 'gü ‑dhɛ ‑nu ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sɔlö ‑zë, ‑yö ö ꞊faan' sü kö ‑yaan ‑Zlan ‑bha mɛ ‑nu 'tiin yën. 'Ö ‑sɔ kɔɔdhɛ ‑nu ‑bha, 'ö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu, gɔɔn‑ ‑nu, dhoo ‑nu ‑an kun 'ö ‑an ‑zuö ‑kanso 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo ‑pɛn bhë, ‑wo 'wuntaɔsë ‑blɛɛ 'wo dhoë ‑dhɛ 'plɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipö ‑yö ‑dho Samali ‑pö do 'gü, 'ö ‑Zlan ‑bha ‑Yamɛ ‑wun ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mɛ gbung ‑nu 'wo ‑kë mü bhë, 'wun 'ö Filipö ‑yö ‑kë ‑a ꞊blɛɛ' ꞊dhia bhë, ‑an 'plɛ 'töüdhö ‑wo ‑kë wo 'to 'to ꞊dhia ‑a ‑bha ‑së 'ka, ‑dhidhaapë ‑nu 'ö ‑kë ‑a kë ꞊dhia 'ö 'wo ‑an yö bhë ‑an ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bhii 'ö tɔɔ mɛ ‑nu 'ö ‑zuu yaa ‑yö ‑kë ‑an 'gü bhë, ‑zuu yaa ‑nu 'wo bhë ‑wo ‑kë ‑go ‑an 'gü ꞊dhia ꞊gblaa 'gbla ‑sü 'ka 'gbee‑ 'ka; 'tinngmɛ ‑nu waa‑ ‑gɛntɔsiömɛ ‑nu 'wo ‑kë mü bhë 'ö ‑an ‑dhɛ ‑yö bo 'pö. ");
INSERT INTO dnj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","'Ö pö‑ bhë ‑a 'gü ‑mɛ ‑nu 'glu ‑yö ‑dhi ꞊va 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gɔɔn‑ do 'wo‑ ‑dhɛ Simɔ ‑yö ‑kë pödhɛ bhë ‑a ‑bha. ‑Yö ‑kë ‑dɛbɔmɛ 'gbee‑ do 'ka, ‑a ‑wun kë ‑kɔ ‑wun 'gü, 'ö Samali ‑sɛgümɛ ‑nu 'te tun, 'yö ö ‑de ‑kë ꞊bhlëzë. ");
INSERT INTO dnj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","'Ö mɛ ‑nu 'wo plöö mü 'töüdhö, 'ö yöë mɛ 'giangian ‑nu ‑ta, 'wo wo 'to to ‑a ‑bha ‑së 'ka 'wo‑ pö: «Kwa ‑bha ‑Zlan ꞊va bhë ꞊nɛ 'ö‑ ‑bha 'piigbeedhɛ ‑yö ‑kë Simɔ 'ka 'ö ꞊yɔɔ kwa 'piö bhë.» ");
INSERT INTO dnj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","‑Wo wo 'to ‑to Simɔ ‑bha ‑së 'ka. 'Ö‑ ‑bha ‑dɛ 'ö‑ bɔ ‑na mü ‑kplawo 'ö‑ ‑dhɛ ꞊ya ꞊glɔɔ bhë, 'ö‑ ‑wun ‑yö ‑an 'te tun. ");
INSERT INTO dnj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","'Kɛɛ ꞊dhɛ 'ö 'wuntaɔsë 'ö ‑gban ‑Zlan ‑bha ‑gludëdhɛ waa‑ Yesu Klito ‑an ‑bha, 'ö Filipö ꞊yaa‑ ꞊blɛɛ'‑ ‑an ‑dhë, 'ö gɔɔn‑ ‑nu, dhoo ‑nu 'bhaa ‑nu 'wo plöö mü, 'wo‑ ‑wun ‑dhɛ 'wun gia‑, 'ö 'wo ‑an bɔ yiö Yesu 'tɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","'Ö Simɔ ‑de gia‑ 'pö, 'yö Yesu Klito ‑wun ‑dhɛ 'wun gia‑. 'Ö 'wo‑ bɔ yiö. 'Yö to Filipö 'piö; ‑dhidhaapë ꞊vava ‑nu 'ö Filipö 'dhö ‑an kë ‑na bhë 'ö ‑an yö 'ö‑ ‑wun ‑ya 'te tun. ");
INSERT INTO dnj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","꞊Dhɛ 'ö Yesu ‑bha bɔmɛ ‑nu 'wo ‑kë Zeluzalɛmë ‑wa ma ꞊nɛ mɛ ‑nu 'wo Samali, ꞊wa ‑Zlan ‑wo ‑dhɛ 'wun gia‑, 'wo Piɛɛ waa‑ Zan ‑an bɔ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","꞊Dhɛ mɛ 'wo bhë ꞊wa 'dho ꞊wa ‑lo Samali ‑sɛ 'gü, 'ö 'wo ꞊bhɛa Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑wun 'gü, ‑yö kë 'dhö kö ‑waan ‑Zuu 'slööslö yö. ");
INSERT INTO dnj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bhii 'ö tɔɔ kö waa ‑Zuu 'slööslö yö ꞊kun. ‑An bɔ 'wo‑ wo yiö 'kpaan 'ka kwa Dëmɛ Yesu 'tɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","꞊Dhɛ ꞊ya kë 'dhö, 'ö Piɛɛ waa‑ Zan 'wo wo ‑kɔ kpa ‑an ‑ta, 'ö 'wo ‑Zuu 'slööslö yö. ");
INSERT INTO dnj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","꞊Dhɛ 'ö Simɔ ‑ya yö ꞊nɛ ‑Zlan ꞊ya ‑Zuu 'slööslö nu Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑dhë, Yesu ‑bha bɔmɛ ‑nu ‑bha ‑kɔ 'wo‑ ‑kpa ‑an ‑ta bhë ‑a ‑wun 'gü, 'ö 'wëü‑ nu Piɛɛ waa‑ Zan ‑an ‑dhë, ");
INSERT INTO dnj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","'ö‑ pö ‑an ‑dhë: «‑Kɔ ‑mɔ 'wuën‑ ‑sü bhë, ‑kaa nu n ‑dhë, ‑yö kë 'dhö kö mɛ 'a 'dhoë‑ n ‑kɔ kpa ‑a ‑ta ‑yaan ‑Zuu 'slööslö yö 'pö!» ");
INSERT INTO dnj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","'Yö Piɛɛ ‑ya ‑pö ‑a ‑dhë: «Bhi 'dhö, ü ‑bha 'wëü‑ 'dhö, ka 'gü ‑yö ꞊siö'‑! 'Ö tɔɔ ü ü ‑zo ‑ta ꞊nɛ 'bha 'wëü‑ nu yi ‑dhë, ‑Zlan ‑dho ‑kɔ ‑mɔ 'wuën‑ ‑sü nu ü ‑dhë, 'wëü‑ bhë ‑a ꞊truën 'ka kö 'üën‑ ‑Zuu 'slööslö nu ‑a 'ka mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ü ‑bha 'wun gbɛ 'yaa pë ‑nu 'wo ꞊nɛ ‑an ‑wun 'gü. Bhii 'ö tɔɔ 'bhaa 'kpëdhö ‑Zlan wö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","‑Bhö ü ‑ta yö ‑zo ‑ta ‑a 'gü ‑wun yaa ‑nu ‑bha 'ü ꞊bhɛa'‑ kwa Dëmɛ ‑dhë kö ‑yaan ziö ü ‑bha ‑zo ‑ta ‑a 'gü ‑wun yaa ‑nu 'ö 'wo 'dhö bhë ‑an ‑ta! ");
INSERT INTO dnj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bhii a‑ ‑yö ꞊nɛɛ ü pa ‑sü 'ka 'wun yaa ꞊va 'ka. 'Go mü ü ꞊sɔɔn yaa ‑gɔ 'gan 'gü.» ");
INSERT INTO dnj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","'Ö Simɔ ‑ya pö Piɛɛ waa‑ Zan ‑an ‑dhë: «Ka gia‑, ‑ka ꞊bhɛa' Dëmɛ ‑dhë n ‑wun 'gü, kö ꞊kun 'ö pë ‑nu 'ka‑ ꞊blɛɛ' ‑na bhë 'ö‑ gbɛ dho kë n 'ka!» ");
INSERT INTO dnj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","꞊Dhɛ 'ö Piɛɛ waa‑ Zan pë 'wo‑ dɔ Yesu Klito ‑wun 'gü ꞊waa‑ ꞊blɛɛ'‑ mɛ ‑nu ‑dhë, 'ö ꞊wa kwa Dëmɛ ‑bha 'wuntaɔsë ꞊blɛɛ'‑, 'wo ‑yɛ wo 'zü, 'wo dho Zeluzalɛmë. 'Ö ꞊dhɛ 'wo 'dho ‑na, 'wo 'wuntaɔsë ꞊blɛɛ pödhɛ ‑nu 'wo ‑kë bɔ ꞊dhia ‑an 'gü Samali bhë ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","(Filipö ‑yö ‑kë Zeluzalɛmë, 'ö) kwa Dëmɛ ‑bha bɔmɛ ‑ya pö Filipö ‑dhë: «‑Bhö 'dho goo ꞊zian', ‑kpinngga 'ö go Zeluzalɛmë 'ö dho Gaza bhë ‑a 'ka! ‑Kpinngga 'ö bhë 'yaa mɛ ‑nu 'gbloo 'ka ꞊duö gbɔ.» ");
INSERT INTO dnj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","'Ö Filipö ‑yö ꞊luu 'ö dho. 'Ö‑ ‑bha 'dho ‑sü 'ka, 'ö yö gɔɔn‑ do 'ö 'yaa ‑gbabhö ‑a ‑bha zian‑. Gɔɔn‑ 'ö bhë ‑yö ‑kë ꞊lamɛ ꞊va do 'ö go Etiopi ‑sɛ 'gü 'ö ö ‑zo ‑kë Etiopi ‑sɛ ꞊kɔɔndhe 'wo‑ ‑dhɛ Kandasö bhë, ‑a ‑bha ꞊bhɔɔpë ‑nu 'saadhö ‑an 'piö ‑a 'ka. ‑Yö ‑nu Zeluzalɛmë ‑Zlan gba ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","‑Yö ‑kë ‑ya ‑sü 'ka ö ‑bha ‑yaagüpë 'ö ꞊soo ‑nu ‑wa ‑gan ‑a 'gü kö ‑yö 'dho ‑na ö ꞊plöö. ‑Yö ‑kë ‑Zlan ‑wodhiölomɛ Ezai ‑bha 'sëëdhɛ ‑be pö ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","'Ö ‑Zuu 'slööslö ‑ya pö Filipö ‑dhë: «‑Bhö 'dho ‑yaagüpë bhë ‑a 'sɔɔ!» ");
INSERT INTO dnj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","'Ö Filipö ‑yö ‑dho ‑bla 'ka 'ö yö Etiopi mi 'ö bhë ‑a ‑bha. 'Ö Ö‑ ‑wo ma kö ‑yö ‑Zlan ‑wodhiölomɛ Ezai ‑bha 'sëëdhɛ ‑be pö ‑na. 'Ö‑ ꞊dhɛɛ' kpɔ ꞊nɛɛ: «Pë 'ü‑ pö ‑na bhë 'ü‑ ‑gɛn ‑ma ‑a?» ");
INSERT INTO dnj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","'Ö gɔɔn‑ bhë 'ö‑ ‑daa ‑kë 'ö‑ pö ‑a ‑dhë: «꞊Ya kë ꞊nɛ mɛ gbɛ yaa‑ ‑gɛn pö n ‑dhë, a ‑dho ‑a dɔ ‑kɔklë ꞊ɛ?» 'Ö‑ pö Filipö ‑dhë: «‑Bhö ‑da n 'piö!» 'Ö Filipö ‑yö ‑da ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Pë 'ö ‑kë ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü, 'ö Etiopi mi ‑yö ‑kë ‑a pö ꞊dhia dhö bhë ‑ya pö: ‑Yö ‑kë ꞊nɛ 'bhla 'wo 'dho ‑na ‑a 'ka ‑a zë ꞊dhia ‑a 'dhö. 'Ö ‑kë ꞊nɛ 'bhlanë 'ö 'wo‑ kaa‑ bho ‑na ‑a ‑bha 'ö 'yaa 'we ‑a 'dhö. Yaa ö 'dhi 'po. ");
INSERT INTO dnj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mɛ ‑nu ‑wo 'yan ꞊ziö' ꞊kaa' ö waa 'wun gia‑ ꞊blɛɛ'‑, ‑a ‑bha za dɔ ‑sü 'gü. Mɛ gbɛ 'yaa ‑mɔa ‑bha kö ‑ya ꞊suu'‑ ‑ta 'në ‑nu ‑wun ꞊blɛɛ'‑, bhii ‑wa ‑zë. ");
INSERT INTO dnj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","'Ö Etiopi mi 'ö bhë 'ö Filipö ꞊dhɛɛ' kpɔ 'ö‑ pö: «꞊Bhɛa' 'a‑ wo ü ‑dhë, dö 'ö ‑Zlan ‑wodhiölomɛ ‑yö 'wun ‑gban ‑a ‑bha 'ö‑ ꞊blɛɛ ꞊nɛɛ? Yö gia‑ 'yö ö ‑de ‑wun ꞊blɛɛ e, 'iin 'wun 'ö bhë ‑yö ‑gban mɛ gbɛ ‑bha e?» ");
INSERT INTO dnj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","'Ö Filipö ‑yö dɔ 'wun kpö 'ö‑ pö bhë ‑a ‑ta, 'ö 'wuntaɔsë 'ö ‑gban Yesu ‑bha 'ö‑ ꞊blɛɛ ‑a ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","‑Wo ‑kë 'dho ꞊dhia 'ö 'wo yö 'yipuë do 'sɔɔ; 'ö Etiopi mi 'ö bhë 'ö‑ pö: «'Yi ꞊ga ꞊nɛ; ‑më 'bhaa 'ö n ‑ma 'zü 'ö dhoë‑ kë kö 'üën‑ 'kun n ‑bɔ yiö ‑sü 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","'Ö Filipö ‑ya pö ‑a ‑dhë: «'Ö ꞊ya kë ꞊nɛ Yesu ‑wun ‑dhɛ 'wun gia‑ ‑sü ꞊ya kë ü ‑gɔ ü ꞊zuöga 'plɛ 'ka, kö ü ‑dho ‑mɔa ‑bha 'ü ‑bɔ yiö.» 'Ö gɔɔn‑ 'ö bhë 'ö‑ pö: «A‑ ‑dhɛ 'wun gia‑ ꞊nɛ Yesu Klito bhë ‑Zlan Gbö ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","꞊Dhɛ ꞊ya kë 'pö 'ö Etiopi mi 'ö bhë 'ö‑ pö mɛ 'ö ‑yaagüpë ‑blü ‑na bhë ‑a ‑dhë ‑yö ꞊gbaannu. ꞊Dhɛ 'ö ꞊gbaannu, 'ö Etiopi mi waa‑ Filipö 'wo yö sia‑, 'ö ‑dhɛ 'wo‑ ‑bha ꞊plɛ 'wo ꞊yɔɔ 'yi ꞊bhaa, 'ö Filipö ‑yö Etiopi mi ‑bɔ yiö Yesu 'tɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","꞊Dhɛ 'ö ꞊wa 'go yiö 'ö ‑Zuu 'slööslö ‑yö Filipö sü ‑dhɛ do bhë ‑a 'gü 'ö dho ‑a 'ka. 'Ö Etiopi mi 'ö bhë yaa‑ yö gbɔ. 'Kɛɛ yö ‑zë, ‑yö ‑dho ö ‑bha 'ta 'ka 'dhiö 'gludhi 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipö ‑zë ꞊dhɛ 'ö dho ‑a ‑ga kö ‑yö Azo ‑pö 'gü. ꞊Dhɛ ‑kë 'dhö 'ö dho ö ‑bha 'ta 'ka 'dhiö, 'ö 'wuntaɔsë ꞊blɛɛ pödhɛ ‑nu 'gü 'ö dhoë 'ö ꞊loë' Sezale plöö. ");
INSERT INTO dnj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","'Töng 'ö bhë ‑a 'ka, Sɔlö ‑yö ‑kë 'suö ‑da ꞊dhia kwa Dëmɛ ‑bha ꞊guë' ‑nu 'gü, ‑an zë ‑sü ‑wun 'ka ‑kplawo. ");
INSERT INTO dnj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","'Ö dho slabhomɛ ꞊va 'piö, 'yö 'wo wo ‑kɔ pin ‑kë 'sëëdhɛ ‑nu ‑ta kö ‑ya ‑zɔn ꞊nɛ ‑an ‑zo 'kun ‑wun ‑mü kö 'yaan‑ dhoë Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑gɔmɛ ‑nu 'wo Damasö plöö ‑an ꞊dhia. ‑Yö ‑kë 'dhö ꞊ya kë ꞊nɛ 'ya gɔɔn‑ ‑nu 'iin dhoo ‑nu ‑an yö kwa Dëmɛ ‑bha zian ‑ta kö 'yaan‑ ‑an 'kun 'yaan‑ nu ‑an 'ka Zeluzalɛmë. ");
INSERT INTO dnj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","'Ö ‑da zian 'ö dho Damasö ‑a ‑ta. ꞊Dhɛ 'ö ꞊yɔɔ' ‑na pödhɛ bhë ‑a 'sɔɔ, 'kan 'ö‑ wo ‑ta 'ö ‑dhɛpuudhɛ 'ö go dhang‑ 'gü ‑a 'bhü ꞊ya ꞊nië' ‑a ‑zü. ");
INSERT INTO dnj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","'Ö go ö ‑bha ꞊soo ꞊taa 'ö ‑püö sia‑. 'Ö mɛ do ‑wo ‑ya pö ‑a ‑dhë: «Sɔlö, Sɔlö, ‑më 'ö ‑kë 'ü n 'yënng bhɔ 'dhö e?» ");
INSERT INTO dnj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","'Ö Sɔlö ‑ya ꞊dhɛɛ' kpɔ, 'ö‑ pö: «Dö ‑mü ü 'ka ɛ, n Dëmɛ?» 'Ö kwa Dëmɛ Yesu ‑ya pö ‑a ‑dhë: «Ma Yesu, 'ü n 'yënng bhɔ ‑na bhë 'ko zë 'ü‑ wo ‑na n 'ka bhë, pë 'dhiö 'ü‑ kë ‑na ü ‑de 'ka bhë ‑ɔɔ!» 'Ö 'suö ꞊va ‑yö ‑da ‑a 'gü, 'yö yö ꞊zluun ‑sü ‑bha, 'ö‑ pö: «N Dëmɛ, ‑më 'ü‑ 'piö kö 'a‑ kë ꞊ɛ?» 'Ö kwa Dëmɛ ‑ya pö ‑a ‑dhë: ");
INSERT INTO dnj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","«‑Bhö ꞊luu'‑ 'ü 'dho pödhɛ 'ö ü 'dhiö bhë ‑a ‑bha! Pë 'ü dhoë‑ kë bhë, ‑dhɛ bhë ꞊nɛ 'wo ‑dho ‑a ꞊blɛɛ'‑ ü ‑dhë ‑a ‑bha.» ");
INSERT INTO dnj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Gɔɔn‑ ‑nu 'ö waa‑ Sɔlö ‑nu 'wo ‑kë 'dho ꞊dhia bhë, ‑an 'te ‑yö ꞊tun 'ö pë 'wo dho ‑a kë waa‑ dɔ, bhii ‑wo 'ö ‑kë we ꞊dhia bhë ‑wa ‑ma, 'kɛɛ waa mɛ gbɛ yö. ");
INSERT INTO dnj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔlö ‑yö ‑luu sia‑, 'yö ö 'yan ‑po; 'kɛɛ yaa ‑dhɛ yö. 'Wo ‑yaa ꞊kwɛɛ' ‑bha, 'ö 'wo dho ‑a 'ka Damasö plöö. ");
INSERT INTO dnj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","‑A 'yënng ‑yö ‑to trö ‑sü 'ka ‑dhɛkpaɔyi ‑yaaga 'piö. 'Töng 'dhö bhë ‑a 'ka, yaa pë gbɛ ‑bhö 'iin yaa 'yi mü. ");
INSERT INTO dnj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","‑Dhɛ 'ö Damasö bhë, Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ do 'wo‑ ‑dhɛ Ananiasö ‑yö ‑kë mü. 'Ö kwa Dëmɛ ‑yö 'wun ‑blɛɛ ‑a ‑dhë 'yanpiöpë 'gü, 'ö‑ pö: «Ananiasö!» 'Yö Ananiasö ‑ya pö: «Ma ꞊ga 'a ꞊nɛ, n Dëmɛ!» ");
INSERT INTO dnj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","'Ö kwa Dëmɛ ‑ya pö ‑a ‑dhë: «‑Bhö ꞊luu'‑ 'ü 'dho ‑kpinngga 'ö 'wo‑ ‑dhɛ ‑kpinngga 'ö dɔ kpengdhö ‑a ‑ta, 'ü 'dho 'ü ‑da Zuda ‑gɔ kɔɔ, 'ü gɔɔn‑ 'ö go Taasö, 'wo‑ ‑dhɛ Sɔlö bhë 'ü‑ ꞊mɛɛ'‑! ‑Yö kɔɔ mü ꞊bhɛa' ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","꞊Ya 'yanpiöpë yö. ‑A ‑bha 'yanpiöpë bhë ‑a 'gü, ꞊ya gɔɔn‑ do 'wo‑ ‑dhɛ Ananiasö ‑a yö kö ꞊ya ‑da ‑a ‑gɔ kɔɔ; ꞊ya ö ‑kɔ kpa ‑a ‑ta, ‑yö kë 'dhö kö ‑yö ‑dhɛ yö 'zü ‑dëüwo.» ");
INSERT INTO dnj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","'Ö Ananiasö ‑ya ‑daa ‑kë 'ö‑ pö: «N Dëmɛ, mɛdhɛvadhɛ ꞊wa 'wun 'ö ‑gban gɔɔn‑ 'ö bhë ‑a ‑bha ‑a ꞊blɛɛ'‑ n ‑dhë, 'ö 'wun yaa ꞊suu'‑ 'ö‑ ‑kë ü ‑bha mɛ ‑nu 'wo Zeluzalɛmë ‑an 'ka, ‑wa 'plɛ ‑blɛɛ n ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","‑A ‑bha ‑nu zö ‑sü 'ka, slabhomɛ ‑gɔmɛ ‑nu ‑wo ‑wogbiindhɛ ‑nu ‑a ‑dhë kö ‑yaan mɛ ‑nu 'wo ꞊bhɛa ü 'tɔ 'ka ‑an 'kun ‑yaan ‑an ‑da ‑kanso 'gü.» ");
INSERT INTO dnj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","'Yö kwa Dëmɛ ‑ya ‑pö Ananiasö ‑dhë: «‑Bhö 'dho 'dhɛ! Bhii gɔɔn‑ bhë, 'ma‑ 'sü kö ‑yaan n ‑wun ꞊blɛɛ'‑, 'sɛgɔgümɛ ‑nu 'ö 'waa Zuifö 'ka waa‑ wo ‑bha 'sɛ ꞊kɔɔnmɛ waa‑ Izlaɛlö ‑sɛgümɛ ‑nu ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma gia‑, 'yënngbhɔdhe ‑nu 'ö dho bɔ ‑an 'gü n 'tɔ ‑wun 'gü bhë, a ‑dho ‑an ‑wun ꞊blɛɛ' ‑a ‑dhë, 'ö ‑an dɔ.» ");
INSERT INTO dnj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","꞊Dhɛ ꞊ya kë 'pö 'ö Ananiasö ‑yö dho. 'Yö dho 'ö ‑lo 'kɔ bhë ‑a 'gü, 'yö ö ‑kɔ kpa Sɔlö ‑ta 'ö‑ pö ‑a ‑dhë: «Sɔlö, n dheglu, kwa Dëmɛ Yesu 'ö ö ‑de ‑zɔn ü ‑dhë zian ‑gblooga 'ü nuë bhë ‑a ‑ta bhë, yö ꞊nɛ 'ö n bɔ ü 'piö kö 'üën‑ ‑dhɛ yö 'zü ‑dëüwo, 'go mü kö 'ü pa ‑Zuu 'slööslö 'ka.» ");
INSERT INTO dnj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","‑Dhɛ do bhë ꞊nɛ 'wo to ‑a ‑bha, 'ö pë ‑nu 'ö 'wo ‑kë ꞊nɛ 'yuö‑ ꞊kia' ‑nu 'dhö 'ö 'wo go Sɔlö 'yënngdhö, 'wo ‑lo sia‑; 'ö ‑dhɛ yö 'zü 'ö 'wo‑ ‑bɔ yiö Yesu 'tɔ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","꞊Dhɛ ꞊ya kë 'pö 'ö pë ‑bhö, 'ö ꞊faan' sü 'zü ‑dëüwo. Waa‑ Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑wo ‑dhɛkpaɔyi kpö ‑kë wo 'ko ꞊bhaa Damasö mü. ");
INSERT INTO dnj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sɔlö ‑yö ‑to ‑dhɛ bhë ‑a 'gü, 'ö yö ‑Zlan ‑wo ꞊blɛɛ' ‑sü 'gü Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑nu 'gü, ‑a pö ‑sü 'ka ꞊nɛ Yesu ‑yö ‑Zlan Gbö 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Mɛ ‑nu 'saadhö 'wo‑ ‑wo bhë 'wo‑ ma, 'tetundhe ‑yö ‑da ‑an 'gü, 'wo‑ pö: «Gɔɔn‑ ꞊nɛ yö kun 'ö ‑kë mɛ ‑nu 'wo Yesu 'piö ‑an zë ‑sü 'gü Zeluzalɛmë ꞊nɛ ꞊a? Yaa nu zö ‑yaan ‑an 'kun ‑yaan 'dho ‑an 'ka slabhomɛ ‑gɔmɛ ‑nu ꞊dhia ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","'Kɛɛ Sɔlö ‑yö ‑Zlan ‑wo ‑blɛɛ ‑kplawo 'piigbeedhɛ 'ka. ꞊Dhɛ 'ö ꞊yaa‑ ‑zɔn Zuifö ‑nu 'wo ‑kë Damasö ‑an ‑dhë ꞊nɛ Yesu ‑yö ‑Zlan ‑bha ‑Yamɛ 'ka, 'ö pë 'wo dho ‑a kë waa‑ dɔ wo ‑de ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","꞊Dhɛ 'ö ‑dhɛkpaɔyi kpö 'bhle ꞊ya ziö, 'ö Zuifö ‑nu ‑wo dho wo 'ko ꞊bhaa, 'ö ‑an ‑wo ‑yö ‑kë ‑a 'gü do kö 'wo Sɔlö zë. ");
INSERT INTO dnj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","'Ö 'wo wo 'yan to böü‑ 'kplong 'dhi ‑nu 'ö mɛ ‑nu ‑wo ‑da ‑a 'ka plöö bhë ‑a ‑bha, lënng ‑nu, gbeng ‑nu 'plɛ 'ka kö ꞊ya kë ꞊nɛ ꞊wa Sɔlö yö kö ‑yö bɔ ‑na ‑a 'ka, ‑waan 'kun ‑waan zë. 'Kɛɛ mɛ 'bhaa ‑nu ‑wo Sɔlö ‑zo ‑büö Zuifö ‑nu ‑bha 'slë 'wo‑ ‑kan ‑a ‑gɔ bhë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","꞊Dhɛ ꞊ya kë 'pö, Sɔlö waa‑ ö ‑bha ꞊guë' ‑nu ‑wo ‑da böü‑ 'kplong 'ö ꞊nië pö‑ ‑zü bhë ‑a tuö gbeng, 'wo Sɔlö ‑da ꞊kpasɛn 'gü, 'wo‑ ꞊yɔɔ ‑a ꞊zlöö ꞊zian' 'Ö Sɔlö ‑yö dho. ");
INSERT INTO dnj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","꞊Dhɛ Sɔlö ꞊ya ‑lo Zeluzalɛmë, ‑ya këdhɛ ‑mɛɛ kö 'yaan‑ 'dho Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'piö, 'kɛɛ 'suö ‑yö ‑kë Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo bhë ‑an 'gü, bhii 'ö tɔɔ Sɔlö ‑bha ‑kë Yesu ‑bha ꞊guë' 'ka ‑sü bhë waa‑ ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","'Ö Baanabasö ‑ya sü 'ö wo ‑nu 'wo dho Yesu ‑bha bɔmɛ ‑nu 'piö, 'yö ‑kɔ 'ö Sɔlö ‑yö kwa Dëmɛ yöë Damasö ‑kpinngga 'piö waa‑ ‑kɔ 'ö kwa Dëmɛ ‑yö 'wun ꞊blɛɛ ‑a 'ka ‑a ‑dhë bhë 'ö Baanabasö ‑ya 'plɛ ꞊blɛɛ ‑an ‑dhë. 'Ö ko 'zü, ‑kɔ 'ö Sɔlö ‑yö 'wun ꞊blɛɛ ‑a 'ka, ‑zo ‑gban ‑sü 'ka, Yesu 'tɔ 'ka Damasö ‑mɛ ‑nu ‑dhë bhë 'ö‑ ꞊blɛɛ 'zü ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","'Yö sü ‑a yi 'ö 'dhö bhë ‑a ‑bha, Sɔlö ‑yö ‑kë ‑an 'piö zlöö ‑kplawo, 'wun 'saadhö 'plɛ 'gü ‑Zlan ‑wo ꞊blɛɛ' ‑sü 'ka kwa Dëmɛ 'tɔ 'gü ‑zogbandhe 'ka Zeluzalɛmë plöö. ");
INSERT INTO dnj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Waa‑ Zuifö ‑nu mɛ 'wo Glɛkö ‑wo ma, ‑wo zaɔdhe ‑kë wo 'ko 'ka 'siösiö, 'kɛɛ wo ‑zë ‑wo ‑kë ‑a 'piö kö 'wo‑ zë. ");
INSERT INTO dnj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","꞊Dhɛ 'ö‑ dhegluzë ‑nu ꞊waa‑ zë ‑wun ma, 'wo dho ‑a 'ka Sezale ‑pö 'gü 'wo‑ bɔ 'ö dho Taasö plöö. ");
INSERT INTO dnj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","꞊Zuöyagluu ‑yö ‑kë Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑dho 'kuë‑ ‑sü 'wo Zude ‑dhɛ ‑nu, Galile ‑dhɛ ‑nu, Samali ‑dhɛ ‑nu 'gü ‑an ‑gɔ. ꞊Faan' ‑yö ‑kë ‑an ‑gɔ, 'wo wo ‑bha ‑tosiadhe ‑kë kwa Dëmɛ ꞊bhlë ‑ya ‑sü 'ka, kö ‑Zlan ‑bha mɛ ‑nu ‑wo kë ‑na ꞊va, 'ö dhoë 'dhiö, ‑Zuu 'slööslö ‑bha ‑nu ‑an ‑dhë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piɛɛ ‑yö ‑kë ꞊nië'‑ ꞊dhia, 'sɛ bhë ‑a ‑dhɛ 'saadhö 'gü. Yi do 'ka ‑yö ‑dho Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo Lida plöö ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","'Ö gɔɔn‑ do 'wo‑ ‑dhɛ Ene 'ö 'tinng ꞊yua' ‑ya ‑kë 'ö‑ ‑kwɛ ꞊ya kë 'slɛaga bhë 'ö‑ yö kö ‑yö ꞊waannu ‑sü 'ka ꞊gba ‑ta. ");
INSERT INTO dnj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","'Ö Piɛɛ ‑ya pö ‑a ‑dhë: «Ene, Yesu Klito ꞊ya ü ‑dhɛ bo. ‑Bhö ꞊luu'‑, 'ü ü ‑bha ꞊gba 'dho 'kuë‑ dhö!» ‑Dhɛ do bhë ‑a 'gü 'ö Ene ‑yö ꞊luu ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","'Ö mɛ ‑nu 'saadhö 'wo ‑kë Lida ‑pö waa‑ Salɔn ‑sɛ 'gü, 'wo‑ yö 'wo wo ꞊zuö' ꞊dhië kwa Dëmɛ 'piö 'wo Yesu ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Yesu ‑wun ‑dhɛ 'wun gia‑ ‑dhe do 'wo‑ ‑dhɛ Tabita 'ö Glɛkö ‑mɛ ‑nu ‑wa ‑dhɛ wo ‑wo 'gü «Dɔɔkasö» ‑a ‑gɛn 'ö tɔɔ «‑zloo» ‑yö ‑kë Zope ‑pö 'gü. ‑Yö 'wun ‑së ‑kë mɛ ‑nu ‑dhë ꞊va, 'go mü ‑yö ‑nu 'fɛɛmɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","'Ö 'töng gia‑ bhë ‑a 'ka, 'ö dho ‑a 'ka sia‑ 'yua 'ka; 'ö ga. ꞊Dhɛ ꞊wa yën ‑a ꞊glöö 'zlu ‑sü ‑bha, 'wo‑ ‑da 'kɔdhi do 'ö 'kɔ ‑ta dhuö bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo ‑kë Zope, ‑wa ‑ma ꞊nɛ Piɛɛ ‑yö Lida ‑dhɛ 'ö Zope ‑dhɛ 'sɔɔ mü bhë ‑a 'gü, 'wo mɛ ꞊plɛ bɔ 'ma ‑naɔ ‑dɔ ‑an ‑gɔ ‑sü 'ka kö ‑wa pö Piɛɛ ‑dhë ꞊nɛɛ: «Yi ‑bhɛa ü ‑dhë, kö 'ü nu yi ‑gɔ plöö 'nö 'zodhö; kö ꞊kun 'ü ꞊glɔɔ 'ma!» ");
INSERT INTO dnj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piɛɛ ‑yö ‑to mü 'yö ‑ziö ‑an 'piö 'wo dho. ꞊Dhɛ 'ö ꞊wa 'dho ꞊wa ‑lo, 'wo dho ‑a 'ka 'kɔdhi 'ö dɔ 'kɔ ‑ta dhuö bhë ‑a 'gü. ꞊Gɛandhoo ‑nu ‑wo ꞊yɔɔn Piɛɛ ‑bha 'ö 'wo sɔ 'në ‑nu, sɔ ‑ta dhuö ‑sɔ ‑nu 'ö Dɔɔkasö ‑yö ‑an ‑wɔ 'ö ‑an nu ‑an ‑dhë kö ‑yö ꞊tun 'bhee‑ ꞊kun bhë ‑a ‑zɔn ‑a ‑dhë 'gbo bɔ ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","'Yö Piɛɛ ‑yö mɛ 'plɛ ‑yö plaan. 'Ö ‑lo ö kpɔn 'gü, 'ö ꞊bhɛa ‑Zlan ‑dhë. 'Go mü 'ö ꞊dhië ꞊glöö ꞊kpëü 'piö ꞊zian' 'ö‑ pö: «Tabita, ‑bhö ꞊luu'‑!» 'Yö ö 'yan ‑po. ꞊Dhɛ 'ö ꞊ya Piɛɛ yö, 'ö ‑ya ö ‑gɛan. ");
INSERT INTO dnj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","'Ö Piɛɛ ‑yö ö ‑kɔ ‑da ‑a 'gü 'ö‑ ꞊luu. 'Ö ꞊gɛandhoo ‑nu waa‑ Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo to bhë, 'ö ‑an ꞊dhɔɔ ‑kë 'kɔ 'ö bhë ‑a 'gü, 'ö dhebɔ 'ö ga bhë 'ö‑ ‑zɔn ‑an ‑dhë kö ꞊yö 'bhee‑. ");
INSERT INTO dnj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","'Wun 'ö bhë ‑wa ‑ma Zope ‑pö 'plɛ 'gü, 'ö mɛdhɛvadhɛ ‑wo kwa Dëmɛ Yesu ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","꞊Dhɛ ‑kë 'dhö, Piɛɛ ‑yö ꞊glɔɔ Zope plöö, wü kwi ‑yuökëmɛ do 'wo‑ ‑dhɛ Simɔ bhë ‑a ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gɔɔn‑ do ‑yö ‑kë Sezale ‑pö 'gü, 'wo‑ ‑dhɛ Kɔɔnɛɛ. ‑Yö ‑kë Wlɔmë 'dhasi ꞊këng' do ‑gɔmɛ 'ka, 'dhasi kpö ‑nu 'wo‑ ‑dhɛ Itali 'dhasi kpö bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Gɔɔn‑ 'ö bhë waa‑ ö ‑bha 'kɔɔmɛ ‑nu ‑wo ‑kë ‑Zlan gbamɛ 'ö 'wo ‑Zlan ꞊bhlë ‑ya ‑an 'ka; ‑yö ‑nu Zuifö ‑nu 'wo 'fɛɛzë 'sɛ 'ö bhë ‑a 'gü ‑an ‑dhë, 'ö ꞊bhɛa ‑Zlan ‑dhë ‑dhɛkpaɔyi 'saadhö 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Yi do 'ka bhë ꞊dhɛ 'kwa dɔ 'wɔ 'yɛ ‑lan 'ka, 'ö 'yanpiöpë do yö. 'Ö 'yanpiöpë bhë ‑a 'gü, 'ö ‑kpën ‑Zlan ‑bha bɔmɛ do ö ‑da ‑a 'piö kɔɔ ‑a ‑bha. 'Ö ‑Zlan ‑bha bɔmɛ bhë 'ö yö ‑a 'tɔ ‑bha, 'ö‑ pö: «Kɔɔnɛɛ!» ");
INSERT INTO dnj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","'Ö Kɔɔnɛɛ ‑ya ‑ga ‑piindhö, 'ö 'siö ‑yö ‑kan ‑a 'gluu, 'ö‑ pö: «Ü‑ ‑pö ꞊dhɛɛ, n Dëmɛ?» 'Ö ‑Zlan ‑bha bɔmɛ ‑ya pö ‑a ‑dhë: «‑Zlan ꞊ya ü ‑bha ꞊bhɛa' ‑wo ma, ‑a ꞊zuö' 'glu ꞊ya ‑dhi ü ‑bha ‑nu 'fɛɛmɛ ‑nu ‑dhë ‑sü ‑wun 'gü, 'ö ko 'zü, 'ö‑ ꞊zuö' ꞊ya nu ü 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","꞊Dhɛ ꞊ya kë 'dhö 'sabla, ‑bhö mɛ ‑nu bɔ Zɔpe ‑pö 'gü kö ‑waan pö gɔɔn‑ do 'wo‑ ‑dhɛ Simɔ 'wo‑ 'tɔ kpɔ Piɛɛ 'ka bhë ‑a ‑dhë kö ‑yö nu. ");
INSERT INTO dnj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","‑Yö wü kwi ‑yuökëmɛ 'wo‑ ‑dhɛ Simɔ 'ö‑ ‑bha 'kɔ ‑yö dɔ 'yoo 'sɔɔ bhë ‑a ‑gɔ kɔɔ.» ");
INSERT INTO dnj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","꞊Dhɛ ‑Zlan ‑bha bɔmɛ 'ö 'wun ꞊blɛɛ ‑a ‑dhë bhë ꞊ya ziö, 'ö Kɔɔnɛɛ ‑yö ö ‑bha yuökëmɛ ‑nu 'wo‑ ‑gɔ kɔɔ bhë ‑an ꞊plɛ waa‑ ö ‑bha 'dhasi ‑nu 'wo bhë ‑a mɛ do 'ö ‑Zlan ꞊bhlë ‑ya ‑an ꞊dhɔɔ ‑kë. ");
INSERT INTO dnj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","'Ö 'wun ‑nu 'wo ‑kë 'töüdhö bhë 'ö‑ ꞊blɛɛ ‑an ‑dhë. ꞊Dhɛ ꞊ya kë 'pö, 'ö ‑an bɔ Zɔpe. ");
INSERT INTO dnj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","‑A ‑dhɛ mɛ 'ö ‑po ‑a 'piö kö ꞊wa ‑da zian ‑ta, ‑wo ꞊yɔɔn ‑na Zɔpe ‑dhɛ 'sɔɔ, lënnggüdhɛ ꞊tɛi' 'ka, 'ö Piɛɛ 'ö to plöö bhë, 'yö ‑da 'kɔ ‑ta dhuö kö ‑yaan ꞊bhɛa'‑, (bhii 'ö tɔɔ 'kɔ 'ö bhë ‑a ‑ta dhuö ‑dhɛ ‑yö ‑kë 'gbɛgbɛ ‑së 'ka). ");
INSERT INTO dnj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Din ‑ya ‑kun, ‑dhɛ do bhë ‑a 'gü. Mɛ ‑nu 'ö ‑kë ‑an ‑gɔ kɔɔ bhë ‑wo ‑kë ‑a ‑bha ‑bhöpë ‑yuö kë ‑sü 'gü, 'yö 'yanpiöpë do ‑yö. ");
INSERT INTO dnj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","'Ö dhang‑ yö kö ‑a 'dhi ꞊ya 'po, kö pë do 'bhaa ‑yö 'go ‑na dhang‑ 'gü ‑yö ꞊yɔɔ' ‑na. Pë bhë ‑yö ‑kë ꞊nɛ sɔ ꞊va ꞊suu'‑ do 'bhaa 'ö‑ 'to 'dhiö ‑dhɛ ‑yiisië 'dhö mɛ kwɛɛ ‑a 'dhö, ‑yö ‑yɔɔ sia‑ 'sengdhö. ");
INSERT INTO dnj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","'Ö pë bhë ‑a 'gü, wü ꞊suu'‑ 'oo ꞊suu'‑ 'ö 'wo ‑kë ꞊soo ‑ta ‑wü ‑nu, ‑gblëë 'gu ‑ta ‑wü ‑nu, waa‑ ‑ma ‑nu ꞊suu'‑ 'kpɛkpɛ 'ka ‑wo ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","'Ö ‑wo do ‑yö ‑we 'ö‑ pö ‑a ‑dhë: «Piɛɛ, ‑bhö ꞊luu'‑, 'ü ‑an zë, 'ü ‑an ‑bhö!» ");
INSERT INTO dnj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","'Yö Piɛɛ ‑ya pö: «‑Abi', n Dëmɛ, pë 'ö yië‑ tɔng ‑ya pö kö ꞊kun 'yi‑ ‑bhö bhë, n 'ka‑ ‑bhö do ꞊kun.» ");
INSERT INTO dnj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","'Ö ‑wo do bhë 'ö‑ pö ‑a ‑dhë 'zü: «Pë mɛ 'ö ‑Zlan ‑ya pö ꞊yö ‑së kö ‑wa ‑bhö, kö ꞊kun 'ü‑ pö 'yaa ‑së kö ‑wa ‑bhö!» ");
INSERT INTO dnj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","‑Yö ‑kë 'dhö ‑gwaa ‑yaaga, 'ö pë ‑nu 'wo bhë 'wo ꞊luu, 'wo dho dhang‑ 'gü 'zü. ");
INSERT INTO dnj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piɛɛ ‑yö ‑kë ö ‑de ꞊dhɛɛ' 'kpɔ ‑dhiadhö 'yanpiöpë 'ö‑ yö bhë ‑a ‑gɛn ‑wun 'gü. 'Kɛɛ ‑a 'töng gia‑ bhë ‑a 'ka kö Kɔɔnɛɛ ‑bha bɔmɛ ‑nu ꞊wa ‑lo plöö, ‑wo Simɔ ‑bha 'kɔ ꞊dhɛɛ' 'kpɔ ‑na mɛ ‑nu ‑gɔ. 'Wo dho 'wo ‑lo Simɔ ‑gɔ 'kɔ 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","'Wo 'kɔdëmɛ ꞊dhɔɔ ‑kë, 'ö 'wo ꞊dhɛɛkpɔdhe ‑kë ‑a ‑gɔ ꞊nɛɛ: «Simɔ 'wo‑ 'tɔ kpɔ Piɛɛ 'ka bhë ‑yö zö ꞊a?» ");
INSERT INTO dnj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piɛɛ ‑yö ‑kë ö ‑zo 'ta ꞊dhia ‑kplawo, 'yanpiöpë 'ö‑ yö bhë ‑a ‑wun 'gü, 'ö to mü 'ö ‑Zuu 'slööslö ‑ya pö ‑a ‑dhë: «Dɔ, gɔɔn‑ ‑nu ‑yaaga ‑wo ü ꞊mɛɛ' ‑na. ");
INSERT INTO dnj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","‑Bhö 'go 'kɔ ‑ta dhuö, 'ü yö sia‑, 'ü ziö ‑an 'piö, kö ꞊kun ü ꞊zuö' ‑yö to zlöö, bhii 'ö tɔɔ ma ꞊nɛ 'a ‑an bɔ!» ");
INSERT INTO dnj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","꞊Dhɛ ꞊ya kë 'dhö, 'ö Piɛɛ ‑yö ꞊yɔɔ, 'ö dho mɛ ‑nu 'wo bhë ‑an 'piö. 'Ö‑ pö ‑an ‑dhë: «Mɛ 'ka‑ ꞊mɛɛ' ‑na bhë 'ö tɔɔ ma. ‑Më 'ö ‑kë ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","'Ö 'wo‑ pö ‑a ‑dhë: «‑Glukɔɔnmɛ Kɔɔnɛɛ ꞊nɛ 'ö yi bɔ. ‑Yö gɔɔn‑ 'kpëdhö 'ö ‑Zlan ꞊bhlë ‑ya ‑a 'ka. 'Go mü 'ö Zuifö ‑nu 'plɛ 'wo‑ ‑bha ‑tɔmɔdhɛ ‑së ‑kë. ‑Zlan ‑bha bɔmɛ do ‑ya ‑pö ‑a ‑dhë ‑ya pö ü ‑dhë 'ü nu ‑a ‑gɔ kɔɔ kö 'yaan‑ ö 'to 'to 'wun 'ü dho ‑a ꞊blɛɛ'‑ ‑a ‑bha!» ");
INSERT INTO dnj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","'Ö Piɛɛ ‑yö ‑an ‑da kɔɔ 'ö ‑an gbaa wɔdhɛ 'ka, 'wo ‑wɔ mü. ꞊Dhɛ 'ö ‑dhɛ ꞊ya 'po 'ö waa‑ Piɛɛ ‑nu 'wo ‑da zian ‑ta. 'Ö dhegluzë 'bhaa ‑nu 'wo go Zope mü, 'wo dho dɔ ‑an ‑gɔ ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","‑A ‑ta ‑dhɛ mɛ 'ö ꞊kpaɔ ‑a 'piö, 'wo ‑lo Sezale ‑pö 'gü. Kɔɔnɛɛ waa‑ ö dheglu ‑nu 'iin ö 'bhamɛ ‑nu kpinngdhö 'yö ‑an ꞊dhɔɔ ‑kë bhë wo 'plɛ ‑wo ‑kë ‑ya Piɛɛ ‑gɔ ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","꞊Dhɛ 'ö Piɛɛ 'dhö ‑da ‑na kɔɔ, Kɔɔnɛɛ ‑yö ‑dho ‑a ‑gɔ zian, 'yö yö ö kpɔn 'gü ‑a 'dhiö ‑a ꞊bhlë ‑ya ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","'Ö Piɛɛ ‑ya ꞊luu ‑a ‑pö ‑a ‑dhë ‑sü 'ka ꞊nɛɛ: «‑Bhö ꞊luu'‑, bhii mɛ 'bhee‑ ‑mü n 'ka 'pö ꞊nɛ ü 'dhö!» ");
INSERT INTO dnj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","꞊Dhɛ ꞊ya kë 'dhö, 'ö yö 'wun ‑blɛɛ Kɔɔnɛɛ ‑dhë ‑sü 'gü, 'wo dho 'wo ꞊daa' kɔɔ, 'ö‑ 'yan ‑yö ‑da mɛ ‑nu ꞊plëëzë 'wo ‑kë wo 'ko ꞊bhaa bhë ‑an ‑ta, ");
INSERT INTO dnj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","'ö‑ pö ‑an ‑dhë: «Ka gia‑ ka‑ ꞊tɛi' ‑dɔ ꞊nɛ Zuifö ‑nu ‑bha tɔng 'gü, waa‑ ‑nia ‑nu 'waa kë wo 'kuë‑, 'iin 'waa ‑da ‑an ‑gɔ kɔɔ. 'Kɛɛ ‑Zlan ‑ya ‑pö n ‑dhë ꞊nɛɛ kö ꞊kun 'a mɛ gbɛ sü mɛ yaa 'ka 'a ‑kan ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","'Ö tɔɔ 'wun 'ö ‑Zlan ‑ya ‑blɛɛ n ‑dhë ‑a ‑wun 'gü ꞊nɛ, ꞊dhɛ 'ö 'ka n ꞊dhɔɔ ‑kë, n 'ka ꞊dhɛɛ' gbɛ 'kpɔ, 'a nu. ꞊Dhɛ ‑kë 'dhö ꞊nɛ, ‑më 'ö 'ka n ‑dhɛ ‑a 'ka ɛ?» ");
INSERT INTO dnj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","'Ö Kɔɔnɛɛ ‑ya pö: «‑A ‑dhɛkpaɔyi ‑yaaga 'ö ꞊nɛ 'töng gia‑ ꞊nɛ ‑a 'ka, a ‑kë n ‑gɔ kɔɔ 'wɔ 'yɛ ‑lan ꞊bhɛa' ‑wo ꞊dhia, 'ö to mü 'ö gɔɔn‑ do 'ö sɔ 'bhü ‑sü 'dhö ‑a ‑bha, 'yö ‑wo n 'dhiö mü, ");
INSERT INTO dnj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","'ö‑ pö n ‑dhë: ‹Kɔɔnɛɛ, ‑Zlan ꞊ya ü ‑bha ꞊bhɛawo ma, 'ö ü ‑bha nu 'ü‑ wo ‑na 'fɛɛmɛ ‑nu ‑dhë bhë, ꞊yaa‑ yö 'pö. ");
INSERT INTO dnj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","꞊Dhɛ ꞊ya kë 'dhö, ‑bhö mɛ bɔ Zope kö mɛ 'wo‑ ‑dhɛ Simɔ 'wo‑ 'tɔ kpɔ Piɛɛ 'ka bhë kö ‑yö nu. ‑Yö Simɔ mɛ 'ö ‑kë wü kwi ‑yuökëmɛ 'ka, 'ö‑ ‑bha 'kɔ dɔ 'yoo 'dhiö bhë ‑a ‑gɔ kɔɔ!› ");
INSERT INTO dnj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pë ‑kë 'a mɛ bɔ vɛɛdhö ü 'piö, 'ö 'ü‑ ‑kë 'glusë 'gü 'ü nu bhë 'ö bhë. ꞊Dhɛ ꞊ya kë 'dhö, mɛ 'plɛ kwa ‑Zlan wö 'dhiö zö, yi 'to ‑yö ü ‑bha kö ‑wo 'ö kwa Dëmɛ ꞊ya dɔ ü 'dhii kö 'ü‑ ꞊blɛɛ'‑ yi ‑dhë.» ");
INSERT INTO dnj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","'Ö Piɛɛ ‑yö 'wun ꞊blɛɛ' ‑sü zü dɔ, 'ö‑ pö ‑an ‑dhë: «'Ma‑ dɔ giagia 'ka zlöö ꞊nɛ, ‑Zlan 'yaa mɛ gbɛ zë 'gü ö ‑bha 'wun ‑nu kë ‑sü 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mɛ 'oo mɛ 'ö go 'sɛ ꞊suu'‑ 'oo ꞊suu'‑ ‑ta 'ö ꞊yaa‑ ꞊bhlë ‑ya, 'go mü 'ö 'wun kpengdhö ‑nu kë ‑na bhë, ‑a ‑mɛ ‑yö ‑Zlan ‑dhë ‑së. ");
INSERT INTO dnj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","‑Wo 'ö ‑Zlan ‑ya bɔ Izlaɛlö ‑sɛgümɛ ‑nu ‑dhë bhë 'ka‑ ‑dɔ. Yö ꞊nɛ 'ö 'wuntaɔsë 'ö ‑gban ꞊zuöyagluu 'ö ‑Zlan ‑ya ‑kë yö ‑zë waa‑ mɛ 'bhee‑ ‑nu ‑an ziën, ‑bɔa Yesu Klito ‑ta ‑sü 'ka bhë 'ö‑ ꞊blɛɛ. Yesu Klito bhë ‑yö mɛ 'plɛ kwa Dëmɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","'Wun ‑gɔ ‑nu 'wo ‑kë ‑blɛɛzë 'ka Galile ‑sɛ 'gü 'ö ‑kë 'zü Zude ‑sɛ ‑dhɛ 'saadhö 'gü kö 'wun 'ö ‑gban ‑bɔyiödhe kë ‑sü 'ö Zan ‑ya ꞊blɛɛ ‑a ‑bha bhë ka‑ ‑dɔ. ");
INSERT INTO dnj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","'Go mü 'zü ‑kɔ ‑Zlan ‑yö Yesu 'go Nazalɛtë süë 'ö‑ ‑kë kö ‑Zuu 'slööslö ‑yö ‑da ‑a 'gü 'ö 'piigbeedhɛ nu ‑a ‑dhë bhë, ka‑ ‑yö. 'Ö 'go mü 'zü, ‑kɔ 'ö Yesu ‑yö ꞊nië ‑a 'ka kwaa‑ 'sɛ ‑ta, 'wun ‑së kë ‑sü waa‑ mɛ ‑nu 'ö dü ‑bha ‑kɔ ‑mɔ 'wuën‑ ‑sü 'dhö ‑an ‑ta, ‑an ‑dhɛ bo ‑sü 'ka bhë, 'ka‑ yö. 'Wun ‑nu 'wo bhë ‑a kë 'ö‑ wo 'dhö bhë 'ö tɔɔ ‑Zlan ‑yö ‑kë ‑a 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Pë ‑nu 'saadhö 'ö‑ ‑kë Zeluzalɛmë waa‑ Zuifö 'sɛgɔ ‑nu mɛ 'wo to ‑an 'gü, yi‑ ꞊goo‑ 'ka. Mɛ ‑nu ‑wo Yesu 'ö bhë ‑a ‑zë ‑a ‑dɔ ‑gaatalü ‑bha ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","'Kɛɛ ‑Zlan ‑ya ‑bho ga 'gü ‑a ‑dhɛkpaɔyi kë ‑yaaga ‑naa 'ka. 'Ö‑ ‑kë 'ö ö ‑de ‑zɔn ꞊nɛ ö 'bhee‑ mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mɛ ‑nu 'wo 'dhö bhë 'waa ‑mü 'sɛgümɛ ‑nu 'ka 'kɛɛ mɛ ‑nu 'ö ‑Zlan ‑yö yi sü 'dhiö 'ö yi ‑ya kö 'yiën‑ kë ‑a ꞊goo‑ 'ka ‑a yi 'ka bhë yö ꞊nɛ 'ö ö ‑de ‑zɔn yi ‑dhë. 'Ö ko 'zü, ꞊dhɛ 'ö ‑Zlan ‑ya bho ga 'gü, yi ‑bhöpë ‑nu ‑bhö, 'yi müpë ‑nu mü yi 'ko ꞊bhaa. ");
INSERT INTO dnj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","'Ö Yesu ‑ya pö yi ‑dhë 'yi 'wuntaɔsë ꞊blɛɛ' Zuifö ‑nu ‑dhë. 'Go mü 'yi‑ pö ‑an ‑dhë 'zü ꞊nɛɛ, yö ꞊nɛ 'ö ‑Zlan ‑yö ö ‑ya kö 'yaan‑ mɛ 'bhee‑ ‑nu 'wo 'kpongtaa zö waa‑ ‑an mɛ ‑nu 'ö ꞊wa ga ‑yaan ‑an ‑bha za 'kan. ");
INSERT INTO dnj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Yesu 'ö bhë ‑Zlan ‑wodhiölomɛ ‑nu 'plɛ ‑wo 'wun 'ö ‑gban ‑a ‑bha, 'wo‑ ꞊blɛɛ; 'wo‑ pö ꞊nɛɛ mɛ 'oo mɛ 'ö ꞊yaa‑ ‑wun ‑dhɛ 'wun gia‑ ‑a 'tɔ ‑wun 'gü, ‑Zlan ‑yö ‑dho ziö ‑a ‑bha ꞊sɔɔn yaa ‑nu ‑ta.» ");
INSERT INTO dnj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piɛɛ ‑yö ‑to 'wun ꞊blɛɛ' ꞊dhia 'ö ‑Zuu 'slööslö ‑yö ꞊yɔɔ mɛ 'saadhö 'wo ‑kë wo 'to ‑to ‑a ‑wo ‑bha ꞊dhia bhë ‑an ‑ta. ");
INSERT INTO dnj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Zuifö mɛ ‑nu 'wo Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'ka 'ö waa‑ Piɛɛ ‑nu 'wo nu bhë, ꞊dhɛ 'wun 'ö bhë ꞊waa‑ yö, 'yö 'tetundhe ‑yö ‑da ‑an 'gü ‑Zlan ‑bha ö ‑bha ‑Zuu 'slööslö nu 'ö‑ wo mɛ ‑nu 'ö 'waa Zuifö 'ka ‑an ‑dhë 'pö bhë ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bhii ‑wo ‑an ‑wo ‑ma kö ‑wo 'wun ‑nu ꞊blɛɛ' ‑na ‑wo 'waa gbɛ 'gü; 'go mü kö ‑wo ‑Zlan ‑bha ‑kë ꞊va ‑sü 'tɔ ‑blü ‑na. ꞊Dhɛ ꞊ya ‑kë 'pö 'ö Piɛɛ ‑ya pö: ");
INSERT INTO dnj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Mɛ ‑nu 'ö ‑Zuu 'slööslö ꞊ya nu ‑an ‑ta ꞊nɛ kwa 'dhö wo ꞊nɛ, kwa 'ka 'dho we ‑an ‑bha ‑bɔ yiö ‑sü ‑wun ‑bha ‑a?» ");
INSERT INTO dnj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","꞊Dhɛ ꞊ya kë 'pö, 'ö‑ pö ‑an ‑dhë ‑wo ‑an bɔ yiö Yesu Klito 'tɔ 'ka. 'Ö 'wo ‑an bɔ yiö. 'Ö mɛ ‑nu 'wo bhë 'wo‑ pö Piɛɛ ‑dhë ‑yö ‑dhɛkpaɔyi 'bhe 'tee kë wo 'piö mü. 'Ö Piɛɛ ‑yö ‑we ‑a ‑bha ‑an ‑gɔ. ");
INSERT INTO dnj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yesu ‑bha bɔmɛ ‑nu waa‑ ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo Zude ‑sɛ 'gü, ‑wa ‑ma ꞊nɛ mɛ ‑nu 'waa Zuifö 'ka ‑an mɛ 'bhaa ‑nu ꞊wa ‑Zlan ‑wo ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","꞊Dhɛ Piɛɛ ꞊ya 'yɛ ö 'zü ꞊ya nu Zeluzalɛmë 'ö Zuifö ‑nu 'wo Klito ‑bha mɛ ‑nu 'ka mü bhë, 'wo yö 'wun ‑blɛɛ ‑a 'ka ‑sü 'gü, ");
INSERT INTO dnj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","'wo‑ pö: «‑Da 'ü‑ wo mɛ ‑nu 'ö 'waa kwa ‑sɛgümɛ ‑nu 'ka ‑an ‑gɔ kɔɔ 'ö 'ka pë ‑bhö ka 'kuë‑ bhë, yaa yi ‑zo 'kun!» ");
INSERT INTO dnj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","'Yö 'wun ‑nu 'wo‑ ‑kë 'töüdhö bhë, Piɛɛ ‑yö bɔ ‑a 'plɛ 'gü, 'yö‑ ‑bho 'kou ‑kë ‑an ‑dhë 'ö‑ pö: ");
INSERT INTO dnj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«A ‑kë Zope plöö, 'ö ꞊dhɛ 'a ꞊bhɛa' ‑na, 'a 'yanpiöpë yö; 'ö pë do 'bhaa 'ö ‑kë ꞊nɛ sɔ ꞊va 'ö‑ 'to 'dhiö ‑dhɛ ‑yiisië, ‑wo ‑kë mɛ ‑nu kwɛɛ 'ö go dhang‑ 'gü 'yö ꞊yɔɔ 'sengdhö 'ö nu n 'sɔɔ mü, 'a‑ yö. ");
INSERT INTO dnj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","'Ö 'a ‑dhɛ ‑ga ‑a 'gü ‑së 'ka, 'ö n 'yan ‑yö ‑kpën ꞊soo ‑ta ‑wü ‑nu, 'blü ‑wü ‑nu, ꞊gblëë 'gu ‑ta ‑wü ‑nu, waa‑ ‑ma ‑nu ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","꞊Dhɛ ꞊ya kë 'dhö, 'ö 'we ‑wo do ‑ya pö n ‑dhë: ‹‑Bhö ꞊luu'‑, Piɛɛ, 'ü ‑an zë, 'ü ‑an ‑bhö!› ");
INSERT INTO dnj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","'Ö 'a‑ pö: ‹‑Abi', n Dëmɛ, bhii pë 'ö yië‑ tɔng ‑ya pö kö ꞊kun 'yi‑ ‑bhö, n 'ka‑ ‑bhö do ꞊kun.› ");
INSERT INTO dnj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","'Ö 'we ‑wo do bhë 'yö bɔ dhang‑ 'gü 'zü, 'ö‑ pö n ‑dhë: ‹Pë mɛ 'ö ‑Zlan ‑ya pö ꞊yö ‑së kö ‑wa ‑bhö, kö ꞊kun 'ü‑ pö 'yaa ‑së kö ‑wa ‑bhö!› ");
INSERT INTO dnj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","‑Yö ‑kë 'dhö ‑gwaa ‑yaagazë 'ö pë ‑nu 'wo bhë 'ö ‑an 'plɛ ‑wo ‑yɛ wo 'zü 'wo ‑da dhang‑ 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","‑A 'töng gia‑ bhë ‑a 'ka, 'ö mɛ ‑yaaga 'wo ‑an bɔ n ‑dhë 'wo go Sezale bhë, 'wo nu 'kɔ 'a ‑kë ‑a 'gü bhë ‑a 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","'Ö ‑Zuu 'slööslö ‑ya pö n ‑dhë 'a ziö ‑an 'piö 'yi 'dho, kö ꞊kun n ꞊zuö' ‑yö to zlöö. Gɔɔn‑ ‑nu 'slado 'ö yi ‑nu 'yi nu ꞊nɛ, ‑wo ‑ziö n 'piö 'yi dho Sezale, 'ö mɛ 'plɛ 'yi dho, 'yi ‑da Kɔɔnɛɛ ‑gɔ kɔɔ. ");
INSERT INTO dnj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","'Ö ‑kɔ 'ö ‑Zlan ‑bha bɔmɛ yöë ö ‑gɔ kɔɔ bhë, 'ö‑ ꞊blɛɛ yi ‑dhë. ‑Zlan ‑bha bɔmɛ bhë ‑ya ‑pö ‑a ‑dhë: ‹‑Bhö mɛ bɔ Zope, Simɔ 'wo‑ 'tɔ kpɔ Piɛɛ 'ka bhë ‑a ‑dhë, ‑yö nu; ");
INSERT INTO dnj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","kö ‑wo ‑nu, 'ö bhi 'dhö, ü ‑bha 'kɔɔmɛ ‑nu 'dhö, 'ka dho bɔ ‑a ‑ta 'kaan‑ dha ‑ya ꞊blɛɛ'‑ ü ‑dhë!› ");
INSERT INTO dnj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","꞊Dhɛ 'ö 'ma 'wun ꞊blɛɛ ‑sü zü dɔ, 'ö ‑Zuu 'slööslö ‑yö ꞊yɔɔ ‑an ‑ta ꞊nɛ ‑kɔ 'ö ꞊yɔɔ ‑a 'ka kwa ‑ta 'dhiö bhë ‑a 'dhö. ");
INSERT INTO dnj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","'Ö n ‑zo ‑yö ‑büö kwa Dëmɛ ‑wo 'ö‑ pö ꞊nɛɛ: ‹Zan ‑yö mɛ ‑nu ‑bɔ yiö 'yi 'ka, 'kɛɛ ka ‑zë, ka ‑dho pa ‑Zuu 'slööslö 'ka.› ");
INSERT INTO dnj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","‑Zlan ‑yö gbaɔ do 'ö bhë ‑a ‑kë ‑an ‑dhë ꞊nɛ ‑kɔ do 'ö‑ ꞊kaa' kwa ‑dhë kö 'kwa kwa Dëmɛ Yesu ‑wun ‑dhɛ 'wun gia‑ bhë ‑a 'dhö 'pö. ꞊Dhɛ ‑kë 'dhö, ‑më ‑mü n 'ka kö 'a dɔ ‑Zlan ‑bha pë ‑nu 'ö‑ 'piö kö 'ö‑ kë ‑an ‑gɔ ‑ɛ?» ");
INSERT INTO dnj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","꞊Dhɛ 'ö‑ ‑wo ‑nu 'wo bhë ꞊waa‑ ma, 'ö ‑dhɛ ‑yö ga ‑an ‑ta, 'wo yö ‑Zlan 'tɔ 'blü ‑sü 'gü ꞊nɛɛ: «‑Zlan ꞊ya 'we ‑a ‑bha, mɛ ‑nu 'ö 'waa Zuifö 'ka ‑an ‑gɔ 'pö kö ‑wo wo ꞊zuö' ꞊dhië' ö 'piö kö ‑waan ‑kë ‑a 'gü ‑sü giagia yö.» ");
INSERT INTO dnj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","'Klobhɔdhe 'ö ‑kë 'töng 'wo Etiɛnë zë ‑a 'ka bhë, ‑ya ‑kë 'ö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑wo ‑pɛn. 'Ö ‑an mɛ 'bhaa ‑nu ‑wo ‑dho Fenisi ‑sɛ 'gü, 'ö ‑an 'bhaa ‑nu ‑wo dho Siplë ‑sɛ 'gü, 'ö ‑an 'bhaa ‑nu ‑wo ‑dho Antiɔsö ‑pö 'gü, 'kɛɛ Zuifö ‑nu ‑de 'sloo ꞊nɛ 'wo Yesu ‑bha 'wuntaɔsë ꞊blɛɛ ‑an ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","꞊Dhɛ ꞊ya kë 'dhö, Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ do do ‑nu 'wo ‑kë Siplë ‑dhɛ waa‑ Silɛnë ‑dhɛ ‑an ‑bha, ‑wo ‑dho Antiɔsö plöö, 'wo yö 'wuntaɔsë 'ö ‑gban kwa Dëmɛ Yesu ‑bha ‑a ꞊blɛɛ, mɛ ‑nu 'ö 'waa Zuifö 'ka bhë ‑an ‑dhë ‑sü ‑bha 'pö. ");
INSERT INTO dnj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kwa Dëmɛ ‑bha 'piigbeedhɛ ‑yö ‑kë ‑an 'piö, 'ö mɛdhɛvadhɛ ‑wo Yesu ‑wun ‑dhɛ 'wun gia‑, 'ö 'wo wo ꞊zuö' ꞊dhië kwa Dëmɛ 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","꞊Dhɛ 'ö ‑Zlan ‑bha mɛ ‑nu ‑dho 'kuë‑ ‑sü 'ö Zeluzalɛmë ‑ya 'wun ‑taɔ 'ö bhë ‑a ma, 'wo Baanabasö bɔ Antiɔsö. ");
INSERT INTO dnj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","꞊Dhɛ ꞊ya 'dho ꞊ya ‑lo, ‑kɔ 'ö ‑Zlan ‑yö 'glusë ꞊kaa' Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo mü ‑an 'ka bhë ‑ya ‑yö. 'Ö‑ ꞊zuö' 'glu ‑yö ‑dhi; 'yö ‑an ꞊faan' më kö ‑wo wo ‑zo kë wo ‑de 'piö kwa Dëmɛ ‑bha zian ‑ta ‑a ‑wun ‑kun 'gbee‑ ‑sü 'ka wo ꞊zuö' 'plɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Baanabasö ‑yö ‑kë mɛ këwunsëëzë 'ö pa ‑sü 'ka ‑Zuu 'slööslö waa‑ ‑zo ‑yö ‑Zlan ‑bha ‑sü 'ka ‑a 'ka. 'Ö mɛdhɛvadhɛ ‑wo wo ꞊zuö' ꞊dhië kwa Dëmɛ 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","꞊Dhɛ ꞊ya kë 'dhö, Baanabasö ‑yö ‑dho Taasö plöö kö ‑yaan Sɔlö ꞊mɛɛ'‑. ");
INSERT INTO dnj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","꞊Dhɛ 'ö ꞊yaa‑ yö 'ö nu ‑a 'ka Antiɔsö. 'Ö ‑dhɛ 'wo‑ ‑bha ꞊plɛ waa‑ Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo Antiɔsö plöö, ‑wo ‑kwɛ do ‑kë wo 'ko ꞊bhaa mü. 'Ö Baanabasö waa‑ Sɔlö 'wo mɛdhɛvadhɛ ꞊daan 'wun ‑nu 'wo ‑gban ‑zo ‑yö ‑Zlan ‑bha ‑sü ‑nu ‑bha ‑an 'ka. Antiɔsö ‑dhɛ bhë ꞊nɛ 'ö 'wo Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑dhɛ ‑a ‑bha «Kletiɛn» (‑a ‑gɛn 'ö tɔɔ «‑to Klito 'piö ‑mɛ ‑nu»). Kletiɛn ‑tɔ 'ö bhë, ‑dhɛ 'ö Antiɔsö 'wo‑ kpɔ ‑a ‑bha ‑blɛɛzë. ");
INSERT INTO dnj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","‑A 'töng 'ö bhë ‑a 'ka, ‑Zlan ‑wodhiölomɛ ‑nu ‑wo ‑go Zeluzalɛmë 'wo nu Antiɔsö. ");
INSERT INTO dnj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mɛ do ‑yö ‑kë ‑an ziën 'wo‑ ‑dhɛ Agabusö; 'yö ꞊luu 'ö 'wun ꞊blɛɛ ‑Zuu 'slööslö ‑bha 'piigbeedhɛ ꞊kwaa' ꞊nɛ yi do 'ka, din ꞊va ‑yö ‑dho ‑da 'kpongtaadhɛ 'saadhö 'plɛ ‑bha. (Din 'ö 'dhö bhë ‑yö ‑da 'kpongtaa 'töng 'ö Klodö ‑yö ꞊kaa' ‑gludë 'ka bhë ‑a 'ka). ");
INSERT INTO dnj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","'Ö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑wo ‑yö ‑kë ‑a 'gü do wo ziën, kö mɛ 'ö ‑dhö, pë 'ö‑ ‑kɔ ‑yö ‑mɔa ‑bha ‑ya nu kö ‑waan nuë Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo Zude ‑sɛ 'gü ‑an ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","'Ö 'wo‑ ‑kë ꞊nɛ ‑kɔ gia‑ bhë ‑a 'dhö, 'ö 'wo gbaɔ bhë 'wo‑ dɔ Baanabasö waa‑ Sɔlö ‑an ‑gɔ, 'wo dhoë mɛ ziizii ‑nu 'wo Klito ‑bha mɛ ‑nu 'wo Zude ‑sɛ 'gü ‑an ziën bhë, ‑an ꞊dhia. ");
INSERT INTO dnj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","'Töng 'dhö bhë ‑a 'ka, 'yö ‑gludë Elɔdö ‑yö Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu mɛ 'bhaa ‑nu 'klo bhɔ ‑sü zü dɔa. ");
INSERT INTO dnj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","'Yö Zan dheglu Zakö ‑gɔ ‑kan. ");
INSERT INTO dnj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","'Go mü ꞊dhɛ 'ö ꞊yaa‑ yö ꞊nɛ Zakö zë ‑sü 'ö bhë ‑a ‑wun 'yi ‑yö ‑kan Zuifö ‑nu 'dhii, 'ö Piɛɛ kun 'pö. (‑Yö ‑kë Zuifö ‑nu ‑bha 'wlaan‑ 'ö 'wo‑ ‑dhɛ 'wlaan‑ 'wo ꞊bluu'‑ 'ö‑ ꞊bhɛɛpë 'yaa‑ 'piö 'wo‑ ‑bhö ‑na bhë ‑a 'töng 'ka.) ");
INSERT INTO dnj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","꞊Dhɛ 'ö ꞊wa Piɛɛ 'kun, 'ö Elɔdö ꞊yaa‑ ‑da ‑kanso 'gü, 'ö 'dhasi 'gɔɔ‑ do ö ga 'slado sü 'ö ‑an kpö dan ‑yiisië ‑yiisië 'ö 'wo wo 'ko ‑ta bho 'yan ‑to Piɛɛ ‑bha ‑sü 'ka do do 'ka. Bhii Elɔdö ‑yö ‑mɔa 'gü kö ꞊ya kë ꞊nɛ Paakö 'wlaan‑ ꞊ya zië kö ‑yaan 'dho ‑a 'ka 'sɛgümɛ ‑nu 'dhiö kö ‑wa zë ‑sü ‑za dɔ ‑a ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","'Dhasi ‑nu ‑wo ‑kë wo 'yan ‑to Piɛɛ ‑bha ꞊dhia, ‑kanso 'kɔɔdhö, 'kɛɛ 'töng 'ö bhë ‑a 'ka, Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu kpö ‑wo ‑kë ‑bhɛa ‑Zlan ‑dhë ꞊dhia ꞊faan' 'ka Piɛɛ ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yi 'ö Elɔdö dho dhoë Piɛɛ 'ka 'sɛgümɛ ‑nu 'dhiö bhë ‑a gbeng ‑yi bhë ‑a 'ka, Piɛɛ ‑yö ‑kë yi zë ꞊dhia 'dhasi ‑nu ꞊plɛ ziën. 'Dhasi ‑nu ꞊plɛ 'wo bhë, mɛ 'ö ‑dhö 'ö Piɛɛ ‑kɔ do ‑klu ö ‑bha ꞊yɔɔga 'ka, 'ö‑ ꞊bhüö' ‑klu ö ꞊kwɛɛ' dhö 'pö. 'Go mü 'dhasi 'bhaa ‑nu ‑wo ‑kë wo ‑dɔ ‑dhɛ ‑bha ‑kanso 'kɔdhi mɛ 'ö Piɛɛ ‑yö ‑kë ‑a 'gü bhë ‑a 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","'Ö to mü, kwa Dëmɛ ‑bha bɔmɛ do ‑yö ꞊gbëü, 'ö ‑dhɛpuudhɛ ‑yö bhü, ‑kanso 'kɔdhi bhë ‑a 'gü. 'Ö ‑Zlan ‑bha bɔmɛ ‑yö pa Piɛɛ ‑bha ‑a gban ‑ta ‑ma ‑sü 'ka 'ö‑ pö ‑a ‑dhë: «‑Bhö ꞊luu'‑ 'siösiö!» 'Ö to mü, 'ö ꞊yɔɔ' ‑nu ‑wo go ‑a ‑kɔ ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","'Ö ‑Zlan ‑bha bɔmɛ ‑ya pö Piɛɛ ‑dhë 'zü: «‑Bhö ü ‑bha ‑du kwi dɔ ü ‑bha sɔ ‑ta, 'go mü 'ü ü ‑bha ‑sakpa yö ü ‑gɛn ‑bha!» 'Ö Piɛɛ ‑ya ‑kë ꞊nɛ ‑kɔ bhë ‑a 'dhö. 'Ö ‑Zlan ‑bha bɔmɛ ‑ya pö ‑a ‑dhë 'zü: «‑Bhö ü ‑bha gblang 'sü 'ü‑ ‑da ü ‑bha 'ü ziö n 'piö!» ");
INSERT INTO dnj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","'Yö Piɛɛ ‑yö ‑ziö ‑Zlan ‑bha bɔmɛ bhë ‑a 'piö, 'wo goë ‑kanso 'kɔdhi bhë ‑a 'gü; ‑ya ‑pö ‑bezë ꞊nɛ pë ‑nu 'wo kë ‑na 'töüdhö bhë 'yanpiöpë ‑mü. ");
INSERT INTO dnj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","'Wo ‑ziö 'dhasi kpö ‑blɛɛzë ‑ta, 'ö 'wo dho 'wo ziö ‑an mɛ 'wo yö ‑an 'piö ‑an ‑ta, 'wo dho 'wo yö ‑piö kpong 'wo ‑kanso 'kɔdhi ta ‑na ‑a 'ka bhë ‑a ‑bha kö ‑waan yö plaan. 'Ö kpong 'ö bhë 'ö ‑po ö ꞊deë' ‑an wö 'dhiö, 'ö 'wo yö plaan. ꞊Dhɛ 'wo 'ta ‑na ‑kpinngga do 'piö, 'ö ‑Zlan ‑bha bɔmɛ ‑yö to mü 'yö ꞊dhong Piɛɛ ‑gɔ. 'Ö Piɛɛ ‑yö to ö ‑de 'sloo 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","꞊Dhɛ ꞊ya kë 'dhö, 'ö Piɛɛ ‑ya 'wun dɔ ꞊nɛ, pë 'ö ‑kë bhë 'yanpiöpë 'yaa ‑mü, 'kɛɛ 'wun giagia ‑mü, 'ö‑ pö: «'Ma‑ dɔa 'sabla giagia 'ka ꞊nɛ, n Dëmɛ 'yö ö ‑bha bɔmɛ bɔ kö ‑yaan n bho Elɔdö ‑bha ‑kɔ ‑mɔ 'wuën‑ waa‑ 'wun yaa 'ö Zuifö ‑nu 'wo‑ 'piö kö 'wo‑ kë n 'ka bhë ‑an kwɛɛ.» ");
INSERT INTO dnj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","꞊Dhɛ 'ö ꞊ya ö ‑de ‑kë ‑a 'gü ‑kɔ dɔ 'ö dho Zan 'wo‑ 'tɔ kpɔ Maakö 'ka bhë ‑a dhe Mali ‑gɔ kɔɔ. Mɛ ‑nu ‑wo ‑kë wo 'ko ꞊bhaa mü ꞊va 'ka ‑bhɛa ‑Zlan ‑dhë ꞊dhia, ‑a ‑wun 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","꞊Dhɛ Piɛɛ ꞊ya ‑lo, 'ö kpong ‑ta ‑ma; 'ö yuökëdhe do 'wo‑ ‑dhɛ Lɔdö bhë, 'yö ꞊yɔɔn kpong 'sɔɔ kö 'yaan‑ ꞊dhɛɛ' 'kpɔ ꞊nɛ dö 'ö kpong ‑ta ‑ma ‑ɛ? ");
INSERT INTO dnj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","'Ö Piɛɛ ‑wo dɔ, 'ö‑ ‑bha ꞊zuögludhi 'gü, kö ‑yö kpong 'po ꞊zian' bhë 'ö ‑bla sü 'ö dho kɔɔ 'ö‑ pö mɛ ‑nu 'wo ‑kë mü ‑an ‑dhë Piɛɛ ‑yö 'kɔdhi ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","'Ö 'wo‑ pö ‑a ‑dhë: «'Blɔɔn‑ 'ö ‑da ü 'gü a? Piɛɛ ‑yö ‑kanso 'kɔɔdhö, yaa ‑mɔa ‑bha kö ‑yö nu 'kɔdhi zö!» 'Yö‑ pö ‑an ‑dhë ‑yɔɔn ö ‑wo ‑ta ‑sü 'ka ꞊nɛ Piɛɛ ‑yö 'kɔ 'dhiö mü. ꞊Dhɛ ꞊ya kë 'dhö 'wo‑ pö: «‑Zlan ‑bha bɔmɛ 'ö bɔ Piɛɛ 'piö ‑kplawo bhë yö ‑mü.» ");
INSERT INTO dnj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","꞊Dhɛ kë ‑na 'dhö kö Piɛɛ ‑yö kpong ‑ta ‑ma ‑na ‑kplawo. ꞊Dhɛ 'ö ꞊wa kpong 'po zlöö, 'ö ‑an 'yan ‑yö ‑da ‑a ‑ta, 'ö 'tetundhe ꞊va ‑yö ‑da ‑an 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","'Ö Piɛɛ ‑yö ö ‑kɔ ‑ta zë ‑an ‑dhë kö ‑waan wo 'dhi yö 'kuë‑. 'Ö ‑kɔ 'ö kwa Dëmɛ ‑ya bhoë ‑kanso 'kɔɔdhö bhë 'ö‑ ꞊blɛɛ ‑an ‑dhë 'zü kö 'wun bhë, ‑wa ꞊blɛɛ'‑ Zakö waa‑ Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ mɛ ‑nu 'wo to ‑an ‑dhë. ꞊Dhɛ ꞊ya kë 'dhö, 'ö Piɛɛ ‑yö ‑ziö 'ö dho ‑dhɛ gbɛ 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","꞊Dhɛ 'ö‑ ‑dhɛ ꞊ya 'po, 'suö ꞊va ‑yö ‑da 'dhasi ‑nu 'wo ‑kë wo 'yan ‑to Piɛɛ ‑bha ꞊dhia, ‑kanso 'kɔɔdhö bhë ‑an 'gü, 'wo yö wo ‑de ꞊dhɛɛ' 'kpɔ ‑sü 'gü ꞊nɛ Piɛɛ ‑yö ‑bɔ 'më 'ö ꞊duë ꞊ɛ? ");
INSERT INTO dnj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Elɔdö ‑yö ‑ko 'zü 'ö Piɛɛ ꞊mɛɛ, 'kɛɛ yaa‑ yö. 'dhasi ‑nu 'wo wo 'yan to ‑a ‑bha bhë, 'ö ‑an ꞊dhɛɛ' kpɔ ‑a ‑wun 'ka. ꞊Dhɛ 'ö ‑dhɛ 'ö Piɛɛ 'dhö ‑a ‑bha waa‑ dɔ kpinngdhö, 'ö‑ pö 'dhasi gbɛ ‑nu ‑dhë ‑wo 'dhasi ‑nu 'wo bhë ‑an zë. ꞊Dhɛ ꞊ya kë 'dhö, 'ö Elɔdö go Zude ‑sɛ 'gü, 'ö dho Sezale plöö. ‑Dhɛ bhë ‑a 'gü 'ö 'töng 'dɛdɛ ‑kë mü. ");
INSERT INTO dnj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","‑Naadhe ꞊va ‑yö ‑kë Elɔdö 'gü, Tii ‑mɛ ‑nu waa‑ Sidɔn ‑mɛ ‑nu ‑an buëndhö. 'Ö mɛ ‑nu 'wo bhë 'wo wo ‑wo kpɔ 'kuë‑ do kö 'waan‑ wo ‑de ‑zɔn Elɔdö 'dhiö, 'ö 'wo bɔ ‑gludë ‑bha 'yan ‑to ‑a ‑bha 'kɔ ‑bha ‑mɛ ‑nu ‑gɔmɛ 'wo‑ ‑dhɛ Blatusö ‑a ‑ta, 'wo dho ‑gludë Elɔdö 'piö, 'wo dhidhe ‑da wo ‑nu wo ziën. Bhii 'ö tɔɔ ‑an ‑bha 'sɛgümɛ ‑nu ‑bha ‑bhöpë ‑yö ‑go ‑gludë kwɛɛ. ");
INSERT INTO dnj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","꞊Dhɛ 'ö yi 'ö Elɔdö ‑ya kpɔ bhë ꞊ya ‑lo, 'yö ö ‑bha ‑gludëdhɛ ‑sɔ ‑da ö ‑bha, 'ö dho 'ö ‑ya ö ‑bha 'gɔ ‑gbloo 'gü, 'ö yö 'wun ꞊blɛɛ' ‑sü ‑bha mɛ ‑nu 'plɛ wö 'dhiö mü. ");
INSERT INTO dnj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","'Ö 'sɛgümɛ ‑nu ‑wo ‑gbla 'gbee‑ 'ka ꞊nɛɛ: «Mɛ 'ö 'wun ꞊blɛɛ' ‑na bhë, mɛ 'bhee‑ 'yaa ‑mü, ‑zlan do 'bhaa ‑mü!» ");
INSERT INTO dnj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","'Kɛɛ ‑dhɛ do bhë 'ö to ‑a ‑bha 'ö kwa Dëmɛ ‑bha bɔmɛ do ‑ya ‑kë 'ö 'yua ‑yö Elɔdö kun, 'ö ꞊bhüö' 'në ‑nu ‑wa ‑bhö 'ö ga. Bhii 'ö tɔɔ ‑yö 'tɔbhɔdhe ‑nu ö ‑de ‑dhë, 'yö ö ‑de sü ‑Zlan 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","'Ö mɛdhɛvadhɛ ‑wo ‑Zlan ‑wo ma, 'ö 'wo Yesu ‑wun ‑dhɛ 'wun gia‑, 'wo dhoë 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","꞊Dhɛ 'ö Baanabasö waa‑ Sɔlö ꞊wa yën 'wun ‑nu 'ö 'wo ‑kë ‑a 'piö kö 'wo‑ kë bhë ‑a ‑yö 'ko 'dhiö kë ‑sü ‑bha Zeluzalɛmë, 'wo ‑yɛ wo 'zü 'wo dho Antiɔsö. 'Ö Zan 'wo‑ 'tɔ kpɔ Maakö 'ka bhë, 'wo‑ kpa wo ‑bha 'ö wo ‑nu 'wo dho. ");
INSERT INTO dnj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","‑Zlan ‑wodhiölomɛ ‑nu waa‑ Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ꞊daan' ‑mɛ ‑nu ‑wo ‑kë Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑dho 'kuë‑ ‑sü 'ö Antiɔsö plöö ‑a 'gü. Mɛ ‑nu 'wo bhë ‑an 'tɔ tɔɔ Baanabasö, Simɔ 'wo‑ 'tɔ kpɔ «mɛ tii» 'ka, Lusiusö 'ö go Silɛnë ‑sɛ 'gü, Manaɛ 'ö ‑kë ‑gludë Elɔdö 'bhamɛ kpinngdhö 'wo ꞊kpɛa wo 'kuë 'kɔ do 'gü ‑a 'ka, waa‑ Sɔlö 'dhö. ");
INSERT INTO dnj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Yi do 'ka, ‑wo ‑kë kwa Dëmɛ ‑bha yuö kë ‑sü 'gü, kö ‑wo wo ‑bɛn 'to ‑na bhë, 'ö ‑Zuu 'slööslö ‑ya pö ‑an ‑dhë: «‑Ka Baanabasö waa‑ Sɔlö ‑an ‑ya ‑de ‑ta kö yuö 'a ‑an ꞊dhɔɔ ꞊kaa' bhë ‑waan ‑a kë!» ");
INSERT INTO dnj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","꞊Dhɛ ꞊ya kë 'dhö, 'wo wo ‑bɛn to 'ö 'wo ꞊bhɛa, 'ö 'wo wo ‑kɔ ‑nu kpa ‑an ‑ta, 'dhuë‑ kpɔ ‑an ‑bha ‑sü 'ka, 'ö 'wo wo ꞊kwaa ‑an ‑zü, 'wo dho. ");
INSERT INTO dnj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Baanabasö waa‑ Sɔlö 'ö ‑Zuu 'slööslö ‑yö ‑an bɔ bhë, ‑wo ‑dho Selösi plöö. ‑Dhɛ bhë ꞊nɛ, 'wo ‑ya ‑a ‑bha 'yitagɔ 'gü, 'wo dho 'sɛgɔ ‑dhɛ 'ö ‑ya ‑sü 'ka 'yi ziën 'wo‑ ‑dhɛ Siplë bhë ‑a 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","꞊Dhɛ ꞊wa 'dho ꞊wa ‑lo Siplë, pö‑ do 'wo‑ ‑dhɛ Salaminö bhë ‑a 'gü, 'wo yö ‑Zlan ‑wo ꞊blɛɛ' ‑sü 'gü Zuifö ‑nu ‑bha ‑bhɔkuëkɔ ‑nu 'gü. Zan Maakö ‑yö ‑kë ‑an 'piö, ‑nu ‑an ‑dhë ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","'Sɛgɔ 'ö ‑ya ‑sü 'ka 'yi ziën bhë 'wo bɔ ‑a 'gü, 'wo dho 'wo loë Pafɔsö plöö. ‑Dhɛ bhë ‑a 'gü 'wo ‑kpën Zuifö mi do 'wo‑ ‑dhɛ Baa Yesu 'ö ‑kë ‑dɛbɔmɛ do 'ka ‑a ‑bha mü. Mɛ 'ö bhë ‑yö ö ‑de ‑sü ‑Zlan ‑wodhiölomɛ do 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","'Go mü 'zü ‑yö ‑kë 'sɛ ꞊kɔɔnmɛ 'wo‑ ‑dhɛ Sɛɛziusö Pɔlusö bhë ‑a 'bhamɛ 'ka. 'Sɛ ꞊kɔɔnmɛ bhë ‑yö ‑kë mɛ 'kpaakpa 'ka; 'yö Baanabasö waa‑ Sɔlö 'ö ‑an ꞊dhɔɔ ‑kë, bhii 'ö tɔɔ ‑ya 'piö kö 'ö ‑Zlan ‑wo ma. ");
INSERT INTO dnj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","'Kɛɛ ‑dɛbɔmɛ ('wo‑ 'tɔ kpɔ Glɛkö ‑wo 'gü «Elimasö») bhë yaa 'we ‑a ‑bha ‑an ‑gɔ; 'ö‑ këdhɛ ꞊mɛɛ kö 'yaan‑ 'sɛ ꞊kɔɔnmɛ ꞊zuö' bho ‑zo ‑yö Yesu ‑bha ‑sü ‑zian ‑ta. ");
INSERT INTO dnj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","꞊Dhɛ ꞊ya kë 'dhö, 'ö Sɔlö 'wo‑ 'tɔ kpɔ 'pö Pɔlö 'ka bhë, 'ö ‑Zuu 'slööslö ‑ya pa, 'yö ö 'yan ꞊dhië ‑a 'piö 'ö‑ ‑ga ‑piindhö, ");
INSERT INTO dnj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","'yö‑ pö ‑a ‑dhë: «'Yö Satan gbö, 'wun ‑sɛɛbɔ ‑nu yaagümɛ, 'ü pa ‑sü 'ka 'slë yaa ꞊suu'‑ 'kpɛkpɛ 'ka; këpëyaamɛ ‑mü ü 'ka! Bhi kun 'ü‑ pö mɛ ‑nu ‑dhë ꞊nɛ 'wun giagia 'ö ‑gban yi Dëmɛ ‑bha ‑yö ꞊sua 'ka a? ");
INSERT INTO dnj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Dɔ, ü 'to 'to! ‑A 'töng ꞊ya ‑lo kö yi Dëmɛ ‑yö ü 'klo bhɔ; ü 'yënng‑ ‑dho trö, ü 'ka 'dho ‑dhɛ yö 'töng 'bhaa 'piö!» ‑Dhɛ do bhë 'wo to ‑a ‑bha 'ö Elimasö 'yënng ‑yö ‑trö; 'yö ö ‑de yö ‑dhɛtiidhɛ 'gü. 'Ö ö ‑kɔ ‑ta ö ‑zü 'to kö mɛ 'ö dho zian bho ö 'ka 'yaan‑ ‑a yö. ");
INSERT INTO dnj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","꞊Dhɛ pë ‑kë Elimasö 'ka bhë 'ö 'sɛ ꞊kɔɔnmɛ ꞊yaa‑ yö, 'ö Yesu ‑wun ‑dhɛ 'wun gia‑, 'ö kwa Dëmɛ ‑bha mɛ ꞊daan' ‑wo bhë 'ö‑ ‑wun ‑ya 'te tun. ");
INSERT INTO dnj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pɔlö waa‑ ö 'bhamɛ ‑nu ‑wo ‑da 'yitagɔ 'gü Paafɔsö plöö, 'wo dho Pɛɛzö ‑pö 'ö Panfili ‑sɛ 'gü bhë ‑a 'gü; 'ö Zan Maakö ‑yö go ‑an 'piö 'ö ‑yɛ ö 'zü 'ö dho Zeluzalɛmë. ");
INSERT INTO dnj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","'Ö 'wo dho wo ‑bha 'ta 'ka 'dhiö, 'wo go Pɛɛzö plöö, 'wo dho 'wo ‑lo Antiɔsö ‑pö 'ö Pisidi ‑sɛ 'gü bhë ‑a 'gü. 'Ö Zuifö ‑nu ‑bha ꞊glooyi 'ka, 'wo ‑da ‑an ‑bha ‑bhɔkuëkɔ 'gü 'wo ꞊yaannu. ");
INSERT INTO dnj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","꞊Dhɛ ꞊wa yën ‑Zlan ‑bha tɔng ‑nu 'bhaa ‑nu waa‑ ‑Zlan ‑wodhiölomɛ ‑nu ‑wo 'bhaa ‑nu pö ‑sü ‑bha ‑Zlan ‑bha 'sëëdhɛ 'gü, 'ö ‑bhɔkuëkɔ ꞊kɔɔnmɛ ‑nu ‑wa ‑dhɛ Pɔlö waa‑ Baanabasö ‑an ‑gɔ ‑a ‑pö ‑an ‑dhë ‑sü 'ka ꞊nɛɛ: «Dhegluzë ‑nu, ꞊ya kë ꞊nɛ 'wun 'bhaa ‑yö ka ‑gɔ kö 'kaan‑ ‑a ꞊blɛɛ'‑ mɛ ‑nu 'wo dho wo 'kuë‑ ꞊nɛ ‑an ‑dhë ‑an ꞊faan' 'më ‑wo 'ka kö ‑potaasü ‑yö ka ‑gɔ 'sabla.» ");
INSERT INTO dnj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","꞊Dhɛ 'ö ‑kë 'pö, 'ö Pɔlö ‑yö ꞊luu 'ö ö ‑kɔ ‑ta zë ‑an ‑dhë, 'go mü 'ö‑ pö: «Izlaɛlö ‑mɛ ‑nu waa‑ mɛ ‑nu 'kaa Izlaɛlö ‑mɛ 'ka, 'ö 'ka ‑Zlan ꞊bhlë ‑ya, ‑ka ka 'to 'to n ‑ma! ");
INSERT INTO dnj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Izlaɛlö ‑mɛ ‑nu, kwa ‑bha ‑Zlan ‑yö kwa 'bhɛma ‑nu ‑sü 'ö ‑an ꞊bhɛɛ kö ‑wo ꞊tun ‑nia 'ka Ezitö ‑sɛ 'gü. 'Ö 'go mü 'zü 'yö ‑an bho Ezitö ‑sɛ 'gü ö ‑bha 'piigbeedhɛ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","'Yö ‑an bun 'töng 'ö ‑mɔ ‑kwɛ 'gɔɔ‑ ‑yiisië ‑bha ‑an 'piö 'yënng ꞊taa. ");
INSERT INTO dnj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","'Yö Kanaa 'sɛgɔ 'slaplɛ 'gü ꞊siö, ‑glu 'ö Izlaɛlö 'në ‑nu ‑wo nuë 'sɛgɔ 'ö bhë ‑a ‑gɔ bhë ‑a 'ka. 'Ö ‑an ‑bha 'sɛgɔ ‑nu 'wo bhë 'yö‑ nu kwa 'bhɛma ‑nu ‑dhë kö ‑waan kë mü. 'Ö 'wo ‑kwɛ ꞊këng' ‑yiisië waa‑ ‑kwɛ 'gɔɔ‑ 'sɔɔdhu ‑kë ‑a 'gü mü. ");
INSERT INTO dnj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","꞊Dhɛ ꞊ya kë 'dhö, 'ö zakanmɛ ‑nu ‑ya kwa 'bhɛma ‑nu ‑gɔ ‑ta, 'ö dho 'ö yöë ‑Zlan ‑wodhiölomɛ Samiɛlö ‑bha 'töng ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","'Ö 'wo ‑gludë do ‑dhɛ Samiɛlö ‑gɔ, 'ö ‑Zlan ‑yö Saulö 'ö ‑kë Kisö gbö 'ka 'ö go Bɛnzamɛ ‑gɔ 'gunng 'gü bhë ‑a nu ‑an ‑dhë. 'Ö Izlaɛlö ‑sɛ ꞊kɔɔn ‑kwɛ 'gɔɔ‑ ‑yiisië 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","꞊Dhɛ 'ö ‑Zlan ꞊ya ö ꞊kwaa' Saulö ‑wun ‑zü, 'ö ko 'zü 'yö Davidö nu ‑an ‑dhë ‑gludë 'ka. 'Ö‑ ‑bha ‑tɔmɔdhɛ ‑kë 'ö‑ pö: Zese gbö Davidö bhë, n ꞊dhɔɔbhaa ‑mɛ ‑mü. Yö ꞊nɛ 'ö dho n ꞊dhɔɔbhaa ‑wun 'plɛ kë. ");
INSERT INTO dnj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Davidö 'ö bhë ‑a ꞊suu'‑ ‑ta 'në do ꞊nɛ 'ö ‑Zlan ‑ya ‑ya Izlaɛlö ‑sɛgümɛ ‑nu Dhamɛ 'ka ꞊nɛ ‑kɔ 'ö‑ pöë bhë ‑a 'dhö. Mɛdhamɛ 'ö bhë 'ö tɔɔ Yesu. ");
INSERT INTO dnj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kö Yesu ‑yaan ꞊tun nu ‑na, Zan ‑yö ‑Zlan ‑wo ꞊blɛɛ, 'ö Izlaɛlö ‑sɛgümɛ ‑nu ꞊dhɔɔ ‑kë ö ‑wo 'ka ꞊nɛ ‑wo wo ꞊kwaa' wo ‑bha ꞊sɔɔn yaa ‑nu ‑zü kö ‑wo ‑an bɔ yiö. ");
INSERT INTO dnj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","꞊Dhɛ 'ö Zan ‑bha yi ꞊ya yö ꞊klöö' 'kpongtaa, 'yö‑ pö: ‹Ka ‑zo 'piö, dö ‑mü n 'ka ɛ? ‑Ka ka 'to 'to, 'maa mɛ ö 'ka ‑ya ‑a ‑gɔ bhë ‑a 'ka; 'kɛɛ mɛ 'ö bhë ‑yö nu ‑na n ꞊zlöö. Mɛ 'ö 'dhö bhë ‑a ꞊bhlë ꞊yö ꞊va 'ö ꞊zië' n ‑ta, 'ö n ‑kɔ yaa ‑mɔa ‑bha kö 'aan‑ ‑a ‑bha ‑sakpa yuun ‑bhüö ‑nu 'po 'aan‑ ‑a bho ‑a ‑gɛn ‑bha.› » ");
INSERT INTO dnj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","'Ö Piɛɛ ‑ya pö 'zü: «Dhegluzë ‑nu, ka 'ö 'ka ‑kë Ablaamö ꞊suu'‑ ‑ta 'në ‑nu 'ka, waa‑ mɛ ‑nu 'kaa Zuifö 'ka, 'ö 'ka ‑Zlan ꞊bhlë ‑ya, kwa ꞊nɛ 'ö 'wuntaɔsë 'ö ‑kë dha ‑sü 'ka bhë, 'ö yö kwa ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mɛ ‑nu 'wo Zeluzalɛmë waa‑ ‑an ꞊kɔɔnmɛ ‑nu waa Yesu dɔ wo Dhamɛ 'ka; 'ö 'go mü ‑Zlan ‑wodhiölomɛ ‑nu ‑wo 'wo‑ pö ‑na ꞊glooyi 'saadhö 'ka bhë, waa‑ ‑gɛn ma. 'Kɛɛ pë 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑wa ꞊blɛɛ 'ö ‑kë ‑a zë ‑sü ‑wun 'ka bhë ꞊nɛ 'wo‑ ‑kë. ");
INSERT INTO dnj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","‑A zë ‑gɛn gbɛ yaa kë ‑dhö, 'kɛɛ ‑wa ‑dhɛ Pilatö ‑gɔ kö ‑ya zë. ");
INSERT INTO dnj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","'Wun ‑nu 'wo ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ 'gü 'ö ‑gban Yesu ‑bha 'klobhɔdhe waa‑ ‑a ‑bha ga ‑sü ‑wun ‑bha, ꞊dhɛ 'ö ꞊wa ‑an 'plɛ 'dhiö ‑mɔ 'kuë, 'wo‑ bho ‑gaatalü ‑bha, 'ö 'wo‑ ‑da ‑guö ꞊duudhö. ");
INSERT INTO dnj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","'Kɛɛ ‑Zlan ‑ya ‑bho ga 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","'Ö ‑dhɛkpaɔyi ꞊plëëzë 'ka, 'yö ö ‑de ‑zɔn mɛ ‑nu 'wo ‑kë ‑ziö ‑a 'piö ‑mɛ ‑nu 'ka 'dhiö, 'wo goë Galile ‑sɛ 'gü, 'wo dho 'wo yöë Zeluzalɛmë bhë ‑an ‑dhë. Mɛ ‑nu 'wo 'dhö bhë, wo ꞊nɛ 'ö zlöö ꞊nɛ 'wo‑ ꞊goo‑ 'ka kö ‑waan Yesu ‑wun ꞊blɛɛ'‑ Izlaɛlö ‑sɛgümɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","'Ö yi gia‑, 'yi nu 'wuntaɔsë 'ka ka 'piö. 'Wuntaɔsë bhë 'ö tɔɔ pë 'ö ‑Zlan ‑ya 'tɔ go kwa 'bhɛma ‑nu ‑dhë 'dhiö bhë. ");
INSERT INTO dnj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","꞊Yaa‑ kë kwa 'ö 'kwa ‑an ‑bha 'në ‑nu 'ka kwa ‑dhë, Yesu ‑bho ga 'gü ‑sü 'ka ꞊nɛ ‑kɔ 'ö ꞊bɛɛn' ‑sü 'ka 'tan ꞊plɛ ‑naa 'ö 'Tan 'sëëdhɛ 'gü ‑a 'dhö ꞊nɛɛ: (‑Zlan ‑ya ‑pö Yesu ‑dhë:) Ü n Gbö 'ka. 'Ö n ‑ma ‑kë ü Dë 'ka ‑sü bhë ꞊dɛɛ 'a‑ ꞊blɛɛ mɛ 'plɛ ‑dhë 'töüdhö ‑a ‑zɔn ‑an ‑dhë ‑sü 'ka ꞊nɛɛ n Gbö ‑mü ü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","'Ö ‑Zlan ‑ya pö ꞊nɛ yö ‑dho ‑a bho ga 'gü; yö 'ka 'dho ga gbɔ. 'Yö‑ pö ꞊nɛɛ: A ‑dho 'dhuë‑ 'slööslö ‑nu 'ö 'a‑ 'tɔ go Davidö ‑dhë bhë ‑a kpɔ ka ‑bha. 'Dhuë‑ ‑nu 'wo bhë, a ‑dho ‑an kpɔ ka ‑bha 'wun gia‑ 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","'Wun 'ö bhë ‑yö ꞊bɛɛn' ‑sü 'ka ‑Zlan ‑bha 'sëëdhɛ ‑dhɛ 'bhaa 'gü 'pö, 'ö tɔɔ mɛ 'ö 'Tan 'sëëdhɛ ꞊bɛɛn bhë ‑ya ‑pö ‑Zlan ‑dhë: Ü 'ka 'dho we ‑a ‑bha kö ü ‑bha yuökëmɛ 'slööslö bun ‑yö 'bu. ");
INSERT INTO dnj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","‑Wo 'ö ꞊nɛ yaa Davidö ‑bha 'wun ꞊blɛɛ'‑, 'kɛɛ Davidö ‑zë, yuö 'ö ‑Zlan ‑ya ‑ya ‑a ‑bha 'ka ‑ya ‑kë. 'Go mü 'yö ga, 'yö 'wo‑ ‑bin ö 'bhɛma ‑nu 'piö, 'ö‑ bun ‑yö ‑bu. ");
INSERT INTO dnj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","'Kɛɛ mɛ 'ö ‑Zlan ‑ya bho ga 'gü bhë ‑a bun yaa 'bu. ");
INSERT INTO dnj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","N dhegluzë ‑nu, ka 'plɛ ‑kaa dɔa ꞊nɛɛ pë 'ö Yesu ‑ya ‑kë bhë ‑a ‑wun 'gü, yi ‑mɔa ‑bha kö 'yi‑ pö mɛ ‑nu ‑dhë ꞊dɛɛ ꞊nɛ ‑Zlan ‑yö ‑dho ziö ‑an ‑bha ꞊sɔɔn yaa ‑nu ‑ta. ");
INSERT INTO dnj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moizö ‑bha tɔng yaa 'dho ka kë kpengdhö ‑Zlan wö 'dhiö; 'kɛɛ 'ka Yesu ‑wun ‑dhɛ 'wun gia‑, 'ka dho kë kpengdhö ‑a wö 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","‑A ‑wun 'gü, ‑ka kë 'slë 'ka! ‑Yö kë 'dhö kö ꞊kun 'ö pë 'ö ‑Zlan ‑wodhiölomɛ ‑nu ‑wa ꞊blɛɛ bhë 'ö‑ ‑de dho kë ka 'ka: ");
INSERT INTO dnj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‑Zlan ‑wodhiölomɛ ‑nu ‑wa ‑pö: (‑Zlan ‑ya pö:) Mɛ ‑nu 'ö 'ka 'wun gia‑ ‑san zë ꞊nɛ, ‑ka ‑dhɛ ‑ga: 'Tetundhe ‑yö ‑dho ‑da ka 'gü, 'ka ga. Bhii ka ‑bha 'töng 'ka, a ‑dho yuö do 'ö ꞊waa‑ ‑wun ꞊blɛɛ'‑ ka ‑dhë, 'ö ka 'ka 'dho ‑a ‑dhɛ 'wun gia‑ bhë ‑a kë. » ");
INSERT INTO dnj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","43","꞊Dhɛ 'ö ꞊wa yën ‑bhɔ 'kuë‑ kë ‑sü ‑bha 'ö mɛ ‑nu ‑wa pö Pɔlö waa‑ Baanabasö ‑an ‑dhë ‑wo nu 'zü ꞊glooyi mɛ 'ö nu ‑na bhë ‑a 'ka kö 'wun ‑nu 'wo bhë ‑waan ‑an 'bhaa ꞊blɛɛ'‑ wo ‑dhë 'zü. ꞊Dhɛ 'ö Pɔlö waa‑ Baanabasö 'wo 'dho ‑na bhë 'ö Zuifö ꞊plëëzë waa‑ mɛ ‑nu 'wo wo ‑de ‑kë Zuifö 'ka ‑nu 'wo ‑ziö ‑an 'piö. Pɔlö waa‑ Baanabasö ‑wo 'wun ‑blɛɛ ‑an ‑dhë ‑an ꞊faan' 'më ‑sü 'ka kö ‑wo wo ‑bha ‑tosiadhe kë ‑Zlan ‑bha 'glusë 'gü kö ‑wo 'dhoë‑ 'dhiö. ");
INSERT INTO dnj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Zuifö ‑nu ‑bha ꞊glooyi mɛ 'ö yö ‑a 'piö, 'ö mɛ ‑nu ‑wo bhɔ 'kuë‑ ꞊va 'ö‑ ‑wun to 'tee kö pö‑ bhë ‑a 'gü ‑mɛ ‑nu mɛ gbɛ yaa 'to kɔɔ; ‑wo ‑nu wo 'ko ꞊bhaa 'dhö kö ‑waan kwa Dëmɛ ‑wo ma. ");
INSERT INTO dnj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","꞊Dhɛ Zuifö ‑nu ꞊wa mɛ gbung bhë ‑an yö, 'ö ꞊druɛi ‑yö ‑da ‑an 'gü 'ö 'wo‑ pö: «'Wun 'ö Pɔlö 'dhoë‑ ꞊blɛɛ' ‑na bhë ꞊sua ‑wun ‑mü.» 'Go mü 'zü 'wo 'wun yaa ꞊blɛɛ ‑a ‑gɔ mɛ ‑nu ‑dhë. ");
INSERT INTO dnj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","'Kɛɛ Pɔlö waa‑ Baanabasö ‑wo 'wun ‑blɛɛ Zuifö ‑nu ‑dhë ‑zogbandhe 'ka 'zü ꞊nɛɛ: «Pë mɛ 'ö këpë 'ka 'ö tɔɔ kö ‑Zlan ‑wo ‑yö ‑dho ꞊blɛɛ'‑ ka ‑blɛɛzë ka ‑dhë. 'Kɛɛ ꞊dhɛ ‑kë ꞊nɛ kaa 'we ‑a ‑wun ‑dhɛ 'wun gia‑ ‑sü ‑bha, 'ö 'ka‑ ‑zɔn ‑na ꞊nɛɛ yaa ka ‑ma 'kun kö 'ka ꞊toëpö ‑kë ‑a 'gü ‑sü yö bhë. ꞊Dhɛ ‑kë 'dhö bhë, yi ‑dho ziö 'yi dho mɛ ‑nu 'ö 'waa Zuifö 'ka ‑an 'piö. ");
INSERT INTO dnj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bhii pë 'ö kwa Dëmɛ ‑ya pö yi ‑dhë 'ö tɔɔ: A ü ‑ya 'sɛgümɛ ‑nu ‑bha ‑dhɛpuudhɛ 'ka. ‑Yö kë 'dhö kö 'ü 'dho dhasü 'ö bhë ‑a 'ka 'sɛ ‑dhɛ ‑nu 'wo 'ma ꞊gbiin ‑an 'gü. » ");
INSERT INTO dnj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","꞊Dhɛ 'ö mɛ ‑nu 'ö 'waa Zuifö 'ka, 'wo ‑an ‑wo bhë 'wo‑ ma, 'ö ‑an ꞊zuö' 'glu ‑yö dhi; 'ö 'wo‑ pö: «Kwa Dëmɛ ‑wo 'ö bhë ꞊yö ‑së!» 'Ö mɛ ‑nu 'saadhö 'ö ‑Zlan ‑yö ‑an sü kö ‑waan ꞊toëpö ‑kë ‑a 'gü ‑sü yö bhë, 'wo Yesu ‑wun ‑dhɛ 'wun gia‑. ");
INSERT INTO dnj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","'Ö kwa Dëmɛ ‑wo ‑yö ‑pɛn 'sɛgɔ 'ö bhë ‑a ‑dhɛ 'saadhö 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","'Kɛɛ mɛ ‑nu 'wo Zuifö 'ka, ‑wo dhebɔ ‑nu ꞊bhlëzë 'ö pö‑ bhë 'wo‑ 'gü 'ö ‑Zlan ‑dhɔ ‑yö ‑an ‑kë, waa‑ pö‑ ꞊kɔɔnmɛ ‑wo ‑an 'zü ‑blü 'ö 'wo‑ ‑kë kö mɛ ‑nu ‑wo Pɔlö waa‑ Baanabasö ‑an 'klo bhɔ; 'ö 'wo ‑an ‑kë, 'wo go 'sɛ ‑ta. ");
INSERT INTO dnj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","'Ö mɛ ꞊plɛ 'wo bhë 'wo 'sɛ 'ö go pö‑ 'ö bhë ‑a 'gü, 'wo‑ bho wo ‑gɛn ‑bha, ‑a ‑zɔn pömɛ ‑nu 'wo bhë ‑an ‑dhë ‑sü 'ka ꞊nɛ pë ‑nu 'wo‑ ‑kë bhë wo ꞊nɛ 'ö ‑an ‑bha 'wun 'dhö ‑mü. 'Ö 'wo dho Ikɔnë ‑pö 'gü. ");
INSERT INTO dnj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'wo Antiɔsö, ‑wo ‑kë pa ‑sü 'ka ꞊zuögludhi waa‑ ‑Zuu 'slööslö 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","꞊Dhɛ Pɔlö waa‑ Baanabasö ꞊wa ‑lo Ikɔnë plöö, 'wo ‑da Zuifö ‑nu ‑bha ‑bhɔkuëkɔ 'gü 'zü, 'ö 'wo Yesu ‑bha 'wuntaɔsë ‑blɛɛ mɛ ‑nu 'wo ‑kë mü ‑an ‑dhë. 'Ö Zuifö ‑nu waa‑ mɛ ‑nu 'ö 'waa Zuifö 'ka ‑an ‑dhɛ ꞊va ‑dhɛ ‑wo ‑kë Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","'Kɛɛ Zuifö 'bhaa ‑nu waa 'we‑ ‑bha kö ‑wo Yesu ‑wun ‑dhɛ 'wun gia‑, 'ö 'wo‑ pö mɛ 'waa Zuifö 'ka ‑an ‑dhë ‑wo dɔ Yesu ‑wun ‑dhɛ 'wun gia‑ ‑mɛ ‑nu ‑gɔ 'yënng. ");
INSERT INTO dnj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","'Kɛɛ Pɔlö waa‑ Baanabasö ‑wo ꞊glɔɔ Ikɔnë plöö, 'wo 'wun 'ö ‑gban 'wuntaɔsë 'ö ‑gban Yesu ‑bha 'wo kë ‑a ꞊blɛɛ' ꞊dhia ‑zogbandhe 'ka. Kwa Dëmɛ ‑ya ‑zɔn ‑an ‑dhë mɛ ‑nu wö 'dhiö ꞊nɛ 'wun ‑nu 'ö ‑gban ö ‑bha 'glusë ‑wun ‑bha 'wo‑ ꞊blɛɛ' ‑na bhë 'wun gia‑ ‑mü, 'ö ‑kɔ ‑mɔ 'wun ‑bha ‑sü nu ‑an ‑dhë kö ‑waan ‑dhidhaapë ‑nu kë ‑a 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","'Ö 'gügludhe ‑yö ‑da pömɛ ‑nu ziën, 'ö mɛ ‑kɔ 'pian do ‑yö ‑kë Zuifö ‑nu ‑bha 'ka, 'ö mɛ ‑kɔ 'pian do 'bhaa ‑yö ‑kë Yesu ‑bha bɔmɛ ‑nu ‑bha 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Zuifö ‑nu waa‑ mɛ 'waa Zuifö 'ka waa‑ wo ꞊kɔɔnmɛ ‑nu ‑an ‑wo ‑yö ‑mɔ ‑a 'gü kö 'waan‑ Pɔlö waa‑ Baanabasö ‑an zë ‑an ‑zuö ‑guö 'ka ‑sü 'ka. ");
INSERT INTO dnj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","꞊Dhɛ 'ö mɛ ꞊plɛ 'wo bhë ꞊waa‑ ꞊tɛi' dɔ 'wo ꞊duë, 'wo dho Lekaɔni ‑sɛ 'gü, pödhɛ 'wo‑ ‑dhɛ Litrë waa‑ Dɛɛbö, 'iin ‑an ‑zütodhɛ ‑nu ‑an ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","'Ö 'wo yö 'wuntaɔsë ꞊blɛɛ' ‑sü 'gü mü. ");
INSERT INTO dnj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","‑Dhɛ 'ö Litrë bhë gɔɔn‑ do ‑yö ‑kë ꞊yaannu ꞊süë' mü, bhii 'ö tɔɔ 'tinng ꞊yua' ‑yö ‑kë ‑a ‑gɛn 'gü, 'ö bhɔa, ");
INSERT INTO dnj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","‑yö ‑kë ö 'to 'to ꞊dhia 'wun 'ö Pɔlö ‑kë ‑a ꞊blɛɛ' ꞊dhia bhë ‑a ‑bha. ꞊Dhɛ 'ö Pɔlö ‑ya dɔa ꞊nɛ ‑zo ‑yö Yesu ‑bha ‑sü ‑ya ‑gɔ kö 'yaan‑ ‑a ‑dhɛ bo, 'yö‑ ‑ga ‑piindhö ");
INSERT INTO dnj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","'ö‑ pö ‑a ‑dhë ‑wo 'gbee‑ 'ka ꞊nɛɛ: «‑Bhö ꞊luu'‑ 'ü dɔ ü ‑gɛn ‑ta zengdhö!» 'Yö ꞊luu 'budhö, 'ö yö 'ta ‑sü ‑bha. ");
INSERT INTO dnj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","꞊Dhɛ pë 'ö Pɔlö ‑ya ‑kë bhë mɛ gbung ‑nu ꞊waa‑ yö, 'wo ‑gbla wo ‑bha 'sɛ 'gü ‑wo 'ö ‑kë Likaɔni ‑wo 'ka bhë ‑a 'gü 'wo‑ pö: «‑Zlan ‑nu ꞊wa mɛbheedhe bun 'sü, ꞊wa go dhang‑ 'gü, ꞊wa nu kwa 'piö!» ");
INSERT INTO dnj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","'Ö 'wo Baanabasö 'tɔ kpɔ wo ‑bha ‑zlan ꞊bhlëzë 'wo‑ ‑dhɛ Zösö bhë ‑a 'ka. 'Wo Pɔlö 'tɔ kpɔ 'pö wo ‑bha ‑zlan do 'bhaa 'wo‑ ‑dhɛ Ɛɛmɛs