﻿USE sofia;
DROP TABLE IF EXISTS sofia.dne_vpl;
CREATE TABLE dne_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES dne_vpl WRITE;
INSERT INTO dne_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chenje ndi kitabo cha maina gha lukolo lwa Yecho Kilichitu. Yecho Kilichitu akibha kibheluko cha Daude mulukolo lwa Ulahimo. ");
INSERT INTO dne_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ulahimo ajhakumpapa Isaka, Isaka ajhakumpapa Yakobu, Yakobu ajhakumpapa Yuda na akalongo mundo. ");
INSERT INTO dne_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda ajhakumpapa Pelese na Zela majhe gwabhe akibha Tamale, Pelese ajhakumpapa Hezilone, Hezilone ajhakumpapa Lame, ");
INSERT INTO dne_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lame ajhakumpapa Aminadabo, Aminadabo ajhakumpapa Nashone, Nashone ajhakumpapa Chelemane, ");
INSERT INTO dne_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Chelemane ajhakumpapa Boaze. Na majhe mundo Boaze akemitwa Laabo. Boaze akibha tate mundo Obede na Luse akibha majhe mundo Obede. Obede ajhakumpapa Yese. ");
INSERT INTO dne_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese ajhakumpapa munahota nkolongwa Daude. Daude ajhakumpapa Chelemane majhe mundo Chelemone akibha Batisheba mwikeghe jwa Uliya ");
INSERT INTO dne_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Chelemane ajhakumpapa Leoboamo, Leoboamo ajhakumpapa Abiya, Abiya ajhakumpapa Asa, ");
INSERT INTO dne_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Acha ajhakumpapa Yeochafate, Yeoshafate ajhakumpapa Yolamo, Yolamo ajhakumpapa Uziya, ");
INSERT INTO dne_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uchiya ajhakumpapa Yotamo, Yotamo ajhakumpapa Ahaze, Ahaze ajhakumpapa Ezekiya, ");
INSERT INTO dne_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiya ajhakumpapa Manase, Manase ajhakumpapa Amone, Amone ajhakumpapa Yosiya, ");
INSERT INTO dne_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya ajhakumpapa Yekoniya na akalongo mundo, gwenio ukibha machiko gha Akayahude pibhapelwikwa ku ughene mu kilambo chuku Babelone. ");
INSERT INTO dne_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Akayahude pubhajhawila ku ughene ku Babelone, Yekoniya ajhakumpapa Sheyalutiele, Chelutiele ajhakumpapa Zelubabele. ");
INSERT INTO dne_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zelubabele ajhakumpapa Abiude, Abiude ajhakumpapa Eliyakimo, Eliyakimo ajhakumpapa Azole, ");
INSERT INTO dne_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azole ajhakumpapa Sadoke, Sadoke ajhakumpapa Akimo, Akimo ajhakumpapa Eliude. ");
INSERT INTO dne_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliude ajhakumpapa Eleazale, Eleazale ajhakumpapa Matane, Matane ajhakumpapa Yakobu. ");
INSERT INTO dne_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakobu ajhakumpapa Uchupo, ungana mundo Maliya majhe mundo Yecho jhuikemwa Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Bhahe, kukibha na ibheluko makome na ncheche kuhumii kwa Ulahimo ade kwa Daude pibhatoilwa ku ughene ku Babelone, ibheluko makome kome na ncheche kuhumii kwa Daude patoilwa ku ughene ade machiko gha Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Bhahe, kubhelukwa kwa Yecho Kilichitu kukibha naha, Maliya, majhe mundo, akibha nchumba mundo Uchupo. Nambo akibha amela kutama pamonga ngita munalome na mwikeghe, Maliya abhonikina na ndumbo kwa likakala lya Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nhwalo Uchupo akibha jwaumbone palonge jha Chapanga, akapahi ndeka kubhehe na hone palonge jha bhando, peniya ajhakuwacha kunneka kinyemela. ");
INSERT INTO dne_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pakibha ihwacha lilobhe lyenio, ntumiche jwa Bhambo jwa kunane kwa Chapanga ajhakumpitila mulughono, ajhakunnobholela, “Uchupo mwana gwa Daude, nkota kujhoghopa kuntolela Maliya abhehe nhwana gwino, nhwalo abhii na ndumbo kwa likakala lya Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nabhelukwa mwana munalome, na mwenga namupela liina lyake Yecho, jwenio ndi nabhaghombola bhando bhake mu uhakaho gwabhe.” ");
INSERT INTO dne_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Bhahe, agha ghoha ghakapitile ili lilobhe lya Bhambo pililongila kwa kupete kwa nnondole, ");
INSERT INTO dne_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Dola, nchikana jwangakongana na munalome najhegha ndumbo, napapa mwana munalome, na bhene nabhampela liina lya Emanuele,” mana jhake, “Chapanga abhii pamo na twenga.” ");
INSERT INTO dne_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Peniya, Uchupo pajhimwika mulughono ajhakuhenga ngita ntumiche jwenio jwa Bhambo channobholile, ajhakuntola Maliya, nhwana mundo ukajhake. ");
INSERT INTO dne_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nambo akagholwike nako ndeka ngita mundo na nhwana mundo ade Maliya papapita mwana munalome na Uchupo ajhakuntina liina lyake Yecho. ");
INSERT INTO dne_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yecho akabhelwike ku muche gwa ku Betelehemo ku kilambo chuku Yudeya, machiko gheniya Helode akibha Munahota nkolongwa. Bhando bhubhamanya ghughapala kupitila kwa kulolekeya ndondwa kuhumii kulipitila lyobha bhajhakuhika ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bhajhakwakonya bhando, “Abhii kojhe mwana jwabhelwike abhehe Munahota Nkolongwa jwa Akayahude? Tuiwene ndondwa yake ikapitile kulipitila lyobha, na twenga tuhikite kunyinamila.” ");
INSERT INTO dne_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Munahota nkolongwa Helode pajhohina gheniya, ajhakubhehe ngolongondi, jwenio pamonga na bhando bhoha bha ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Bhahe, Helode ajhakwakema pamonga akapiya matambiko bhakolo bhoha na bhabhola bha Malaghalikilo, ajhakwakonya, “Kilichitu Nkomboche abhelwike kojhe?” ");
INSERT INTO dne_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na bhene bhajhakunnyanguu, “Ku bomane ku Betelehemo, ku muche gwa ku Yudeya ndi nnondole akajhandike. ");
INSERT INTO dne_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Mwe bhando bha ku Betelehemo, kumuche nkate jha kilambo chuku Yudeya, mwenga machokombe ndeka pakate jhumanyikana hake ku Yudeya. Nhwalo kwino nahika kilongoche jwalongocha bhando bhango, bhu ku Ichilahele.’ ” ");
INSERT INTO dne_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Peniya Helode ajhakwakema pakiyepela bheniya bhibhamanya ndondwa, ajhakwakonya lichaa lya ndondwa puipitila. ");
INSERT INTO dne_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Peniya ajhakwalaghalikiya bhajhende ku Betelehemo alongila, “Nnyendengane mukalole kwa uchakaka malobhe gha kilemba chenie. Anda mupatite unetele na nenga helahela nyende nikanyinamile.” ");
INSERT INTO dne_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pubhajhomalila kunyokanikiya munahota nkolongwa, bheniya bhubhaimanyilila ndondwa bhajhakubhokangana. Kwa kuhechuka kwa kuibhona ndondwa yela ibhaibhonita kulihumii lyobha ngailongolila kujhenda nu kujhema panane pabhii mwana. ");
INSERT INTO dne_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pubhaiwene ndondwa hela, bhajhakuhanganila hake. ");
INSERT INTO dne_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bhahe, bhajhakujhingii munyumba, bhajhakummona mwana jhola pamonga na Maliya majhe mundo bhajhakutama makilikite kunyinamila. Peniya bhajhakudindula mahako ghabhe na kumpela hupo. Hupo ya chaabo na mahuta gha petelele gha manemane na ubane. ");
INSERT INTO dne_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chapanga ajhakwakanikiya mulughono bhakota kukelebhuka kabhele kwa Helode peniya bhajhakujhenda ukajha kwabhe kupete ndela jhenge. ");
INSERT INTO dne_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Peniya akaghene bhala pubhabhokita, ntumiche jwa Bhambo jwa kunane ajhakumpitila Uchupo mulughono, ajhakunnobholela, “Jhimka mutole mwana pamonga na majhe mundo, mmutukile ku Michile. Ntame kwenio ade punipala kunnobholela, nhwalo Helode ipala kunkoma mwana jwenio.” ");
INSERT INTO dne_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Peniya, Uchupo ajhakujhimuka na kuntola mwana pamonga na majhe mundo, ajhakubhoka kilo, ajhakujhenda ku Michile. ");
INSERT INTO dne_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ajhakutama kwenio ade Helode pajhomwika. Lilobhe lyenio lihengika kulihenga lilobhe lyahengita Bhambo kwa ndela jha nnondole lipitile, “Nankema mwana mundo kubhoke ku Michile.” ");
INSERT INTO dne_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Helode pabhang'ang'anwika kubhehe bhala bhubhamanya ndondwa bhatekunkoloha, ajhakuyoma hake. Ajhakulaghalikiya yana yoha inalome ku muche gwa ku Betelehemo na mupelemupele jhake bhubhabhii na yaka ibhena amu pahe jhake bhakomwe. Akatehi naha kubhoke machiko ghalobholilwa kuhumii kwa bhala bhibhamanye ndondwa. ");
INSERT INTO dne_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndi ghatimile malobhe ghighalongilwa na jwakibha nnondole jwa Chapanga Yelemiya, ");
INSERT INTO dne_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lilobhe lijhokanikike kwenio ku Lama, kulela kwa lipyanda na kujhemba mihambo jha malelo, Lahele ilelela yana yakwe, ipala ndeka kupepechwa, nhwalo bhoha bhawile.” ");
INSERT INTO dne_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pajhomwika Helode, ntumiche jwa Bhambo Chapanga ajhakumpitila Uchupo mulughono kola ku Michile, ");
INSERT INTO dne_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ajhakunnobholela, “Jhimka mutole mwana pamonga na majhe mundo, nkelebhuke kabhele ku kilambo chuku Ichilahele, mana bhala bhibhapala kunkoma mwana jwenio bhawile.” ");
INSERT INTO dne_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bhahe, Uchupo ajhakujhimka, ajhakuntola mwana pamonga na majhe mundo ajhakukelebhuka ku kilambo chuku Ichilahele. ");
INSERT INTO dne_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nambo Uchupo ajhakujhoha Alikaelo mwana gwa Helode abhujhii unahota gwa kilambo chuku Yudeya, ajhakujhoghopa kujhenda kwenio. Kabhele ajhakukanikiwa mulugwenio na kulobholelwa ajhenda ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ajhakujhenda kutama ku muche ghukemwa ku Nachalete. Ndi ghakatimile malobhe ghighalongilwe kwa ndela jha milondole, “Na jwenio nakemwa mundo jwa ku Nachalete.” ");
INSERT INTO dne_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Machiko ghala Yohane Mbatichajhe ajhakujhenda na kutumbuu kutangacha kunjenga jha ku Yudeya. ");
INSERT INTO dne_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Alongila, “Muuleke uhakaho gwino nhwalo unahota gwa kunane uheghalile!” ");
INSERT INTO dne_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jhonjo Yohane ndi jhola Isaya jwakibha nnondole akalongila panane jhake palongila, “Mundo jwailela kanonoha kunjenga, ‘Munenganikiye Bhambo pala papala kupeta, nnyoche ndela jhake.’ ” ");
INSERT INTO dne_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane akawalite ngobho ikatengenichwe kwa mangoma gha kinyama jwakemitwa ngamiya na luhunga lwa limbendela mukibhuno chake. Na kulye madidima na bhuche. ");
INSERT INTO dne_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Bhahe, bhando kuhumii ku Yeluchalemo na kuhumii pande yoha ya ku Yudeya na chehemo yoha ya mupele jha lukemba lwa Yolodane bhajhakunnyendela, ");
INSERT INTO dne_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","pibhalongela bhene uhakaho gwabhe na jwenio Yohane ajhakwabaticha mulukemba lwa ku Yolodane. ");
INSERT INTO dne_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nambo ajhakwabhona Mapwalichayo na Machadukayo bhamahele bhitenda kunhikilila bhabatichwe, ajhakwalobholela, “Mangota kibheluko cha lijhoka! Bho, ghane jwapwepwile mihoto kulitila lilaka lya Chapanga lilihika? ");
INSERT INTO dne_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nnangiye kwa kuhenga kwino anda muulekite uhakaho. ");
INSERT INTO dne_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nkotoka kuwacha na kulonge, ‘Hoko gwito ndi Ulahimo!’ Ninobholela chakaka, jwenio Chapanga ahotola kughalambula maghanga aghagha na kubhehe yana ya Ulahimo. ");
INSERT INTO dne_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ngohe libhagho libhii pa libelengete lya nkongo, na nkongo ghoghoha gwangapambika uhohe naupengulwa na kutagwa ku mwotu.” ");
INSERT INTO dne_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nenga nibaticha kwa mache kulangiya ngita muulekite uhakaho. Nambo jwahika payeto jhango abhii na likakala kuliku nenga. Nenga nitope ndeka kujhegha maghubache ghake. Jwenio nabaticha kwa Uhuke gwa Chapanga na kwa mwotu. ");
INSERT INTO dne_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jwenio akamula kipalo mu lubhoko lwake cha kuhebhe ngano jhake, ngano jhamaha aibheka mu kikoko, na majhejheto naghajhochwa mwotu gwangahimika gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Machiko gheniya Yecho ajhakubhoka ku Galilaya ajhakuhika kulukemba lwa ku Yolodane ajhakunnyendela Yohane abatichwe. ");
INSERT INTO dne_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nambo Yohane ajhakujhigha kunkanila alongila, “Bho, nhwalo ghane mwenga mihika kwa nenga? Nenga ndi jhunipalwa kubatichwa na mwenga?” ");
INSERT INTO dne_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nambo Yecho ajhakunnyanguu, “Nnyeketele ibhehe kwa ngoheno, nhwalo tupalwa kuhenga ghala ghapahi Chapanga.” Peniya Yohane ajhakujheketela. ");
INSERT INTO dne_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Papa tugha pabatichwa Yecho, ajhakubhoka umache, papalapala kunane kumahunde kujhakudinduka ajhakubhona Uhuke gwa Chapanga ujhakuhuluka ngita ngunda na kutolela panane jhake Yecho. ");
INSERT INTO dne_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lilobhe likajhokanikike kuhumii kunane kwa Chapanga lilongila, “Jhonjo ndi mwanango jhunimpahile, anganichwe na mwenga.” ");
INSERT INTO dne_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Peniya uhuke gwa Chapanga ujhakunnongocha Yecho ade kunjenga ajhighanikilwe na Limbembela. ");
INSERT INTO dne_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ajhakuleka kulyegha pajhomolila machiko makome ncheche muhe na kilo, peniya ajhakubhona njala. ");
INSERT INTO dne_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bhahe, Limbembela lijhakuhika na kunnobholela, “Anda chakaka mwe ma mwana gwa Chapanga, longela maghanga agha ghabhehe mabumunda.” ");
INSERT INTO dne_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yecho ngajhangwila, “Ijhandikwe mu Majhandiko gha Chapanga, ‘Mundo nalama ndeka kwa mabumunda tugha, kwa lilobhe lililongelwa na Chapanga.’ ” ");
INSERT INTO dne_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Peniya Limbembela ajhakuntola Yecho ade ku Yeluchalemo, ku muche gwa nyahinyahi gwa Chapanga, ajhakummeka ku lulegheleghe lwa Nyumba jha Chapanga, ");
INSERT INTO dne_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ajhakunnobholela, “Anda mwenga mwana gwa Chapanga, kiponeya pahe, mana ijhandikwe mu Majhandiko gha Chapanga, ‘Chapanga nalaghalikiya akatumiche bhake bha kunane kwa Chapanga, nabhantola mu mabhoko ghabhe, nkotoka kukochoka mulighanga.’ ” ");
INSERT INTO dne_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yecho ajhakunnobholela, “Ijhandikwe mu Majhandiko gha Chapanga, ‘Nkotoka kunyigha Bhambo, Chapanga gwino.’ ” ");
INSERT INTO dne_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ndi Limbembela lijhakuntola ade kululegheleghe lwa kitombe kitandamaho, ajhakunnangiya unahota gwoha gwa pannema na ukolo gwake. ");
INSERT INTO dne_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ajhakunnobholela, “Nanipela henge yoha anda undamile makilikite na kunnyinamila.” ");
INSERT INTO dne_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Peniya, Yecho ajhakunnobholela, “Bhokela oko Limbembela ijhandikwe mu Majhandiko gha Chapanga. Namunyinamila Bhambo Chapanga gwino na kunhengela jwenio kanjika chake.” ");
INSERT INTO dne_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bhahe, Limbembela lijhakunneka Yecho, na akatumiche bha kunane kwa Chapanga bhajhakuhika, kunhengela. ");
INSERT INTO dne_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yecho pajhohina ngita Yohane atabhitwe mukipungo ajhakujhenda ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ajhakubhoka ku Nachalete, kujhenda ku Kapelenaumo, muche ghubhii mupele jha mbwane jha ku Genechalete, mupakane mwa kilambo cha Zabulone na Nafutale, ajhakutama kwenio. ");
INSERT INTO dne_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Lende litendika lilobhe lela lilongilwa na Isaya, jwakibha nnondole jwa Chapanga litimile, ");
INSERT INTO dne_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ku kilambo chuku Zabulone na ku kilambo chuku Nafutale, kujhendelela mumbwane kwiye jha lukemba lwa ku Yolodane, ku Galilaya, ku kilambo cha bhando bha ilambo henge! ");
INSERT INTO dne_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Bhando bhubhatamita palubhendo bhaluwene lumule lukolongwa. Nabhabhehe bhubhatamita ku kilambo cha lubhendo na kiyeka cha kuwegha, lumule lwamulikile.” ");
INSERT INTO dne_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kuhumii machiko gheniya Yecho akatumbwii kubhola atangicha, “Muuleke uhakaho gwino nhwalo unahota gwa kunane uheghalile!” ");
INSERT INTO dne_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yecho pakibha atyangita mupele jha lilabha lya ku Galilaya, ajhakwabhona akalongo bhabhele bhapyeya homba, Simone jwakemwa Petile na Anduleya nnongo gwake bhakibha bhapyeya homba kwa lwaho mulilabha nhwalo bhakibha bhapyeya! ");
INSERT INTO dne_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Bhahe, ajhakwalobholela, “Ungengame, na nenga nanimmola kwapyeya bhando kwa Bhambo ngita hele chimupyeya homba.” ");
INSERT INTO dne_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Papalapala bhajhakuleka lwaho lwabhe na kunkengama. ");
INSERT INTO dne_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ajhakujhenda palonge pandina, ajhakwabhona akalongo bhange bhabhele. Yakobu na Yohane, yana ya Zebedayo. Bheniya bhakibha nkate jha mungalabha pamonga na tate gwabhe Zebedayo, bhakibha bhitengenecha lwaho lwabhe, bhahe, Yecho ajhakwakema. ");
INSERT INTO dne_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Na bhene bhajhakuileka ngalabha pamonga na tate gwabhe, bhajhakunkengama. ");
INSERT INTO dne_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yecho akibha ijhenda kila chehemo jha ku Galilaya, ajhakubhola munyumba jha kukonganikii Akayahude na kutangacha Malobhe gha Mbone gha Unahota gwa Chapanga. Ajhakulamicha ulwalo ghoghoha ghubhakibha nabho bhando. ");
INSERT INTO dne_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bhando bhubhatamita kilambo choha chuku Siliya pibhajhoha gheniya. Bhibhalwalwa bhoha na bhando bhubhabhii na ulwalo na bhando bhibhalaghita. Bhibhachikilwe na michuka, bhubhabhii na kihinduhindu na bhando bhubhalemile bhakapelikwe kwa jwenie, na bhoha bhajhakulama. ");
INSERT INTO dne_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bhando bhamahele bhajhakunkengama, kuhumii ku Galilaya, na Dekapoli mana jhake miche kome, na ku Yeluchalemo, na ku Yudeya na kwiye jha lukemba lwa ku Yolodane. ");
INSERT INTO dne_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yecho pabhonita lilongo lya bhando, ajhakuhobhoka ku kitombe na kutama. Bhabholwa bhake bhajhakunkengama, ");
INSERT INTO dne_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na jwenio ajhakutumbuu kwabhola. ");
INSERT INTO dne_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bhina mota bhala bhubhahii akahocho bha ku mwojho nhwalo unahota gwa Chapanga ndi gwabhe. ");
INSERT INTO dne_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bhina mota bhubhabhii ngolongondi, nhwalo nabhahangana. ");
INSERT INTO dne_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bhina mota bhibhatokomile, nhwalo nabhapata kilambo. ");
INSERT INTO dne_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bhina mota bhubhabhii na njala na nyota jha kuhenga ghapala Chapanga, nhwalo Chapanga nabhatenda bhajhukute. ");
INSERT INTO dne_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bhina mota bhubhabhii na kiya kwa bhange, nhwalo nabhabhonelwa kiya. ");
INSERT INTO dne_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bhina mota bhubhabhii na mwojho gwa mbone nhwalo nabhamona Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bhina mota bhubhaleta uteeke, nhwalo nabhakemwa bhana bha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bhina mota bhibhapata malagho kwa kuhenga ghapala Chapanga, nhwalo Unahota gwa kunane kwa Chapanga ndi gwabhe.” ");
INSERT INTO dne_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Bhina mota mangota anda bhando bhannighite na pubhapala kung'aha na kuwalongela ilebhe lyanganandela kwa nhwalo gwa nenga. ");
INSERT INTO dne_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Unhanganile na nchobhele nhwalo ndweko jhino ndi ngolongwa kunane kwa Chapanga. Peniya ndi chibhang'ahite milondole bhubhakibha kabula jhino. ");
INSERT INTO dne_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mangota ndi mwinyo gwa pannema. Nambo mwinyo anda uhobhite kunogha kwake naulekelwa nike unoghe kabhele unogha ndeka kabhele, utagwa panja na kutimbwa na bhando. ");
INSERT INTO dne_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Mangota ndi lumule lwa pannema! Muche ghuchengwite panane jha kitombe uhotondeka kukihiya. ");
INSERT INTO dne_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Abhii jhe mundo jwahoto jwapamba kolobohi na kugubikila kibhegha, nambo ubheka panane jha kinala jhalangalile bhoha bhubhabhii nkate. ");
INSERT INTO dne_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Helahela lumule lwino lwalangalile palonge jha bhando bhaghabhone mahengo ghino gha mbone, bhannombwe Tate gwino jwa kunane.” ");
INSERT INTO dne_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ihikite jhe kubhoha Malaghalikilo gha Chapanga ghampekii Mucha na mabholo gha milondole bha Chapanga. Ihikite kughatenda ghapitile chakaka. ");
INSERT INTO dne_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ninnobholela chakaka, ade peniya kunane kwa Chapanga na nnema naghapeta, kibhii jhe hilu kichokombe chochoha chikibhokechwa mu Lilaghalikilo chikipala kuhobholela ade ghatimila ghoha. ");
INSERT INTO dne_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bhahe, mundo jhojhoha jwakanwa kunyeketela hilu nhilo nchokombe ghubhii mu Malaghalikilo ghoha, na kwabhola bhange kuhenga yenio, jwenio nabhaha nchokombe hake munahota nkolongwa gwa kunane kwa Chapanga. Nambo jhola jwajhokanikiya na kwabhola bhange bhatende yenio, nabhaha nkolongwa munahota gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndi nhwalo ninongelile, mijheketela na kuhenga ghapala Chapanga kuliku chibhatenda bhabhola bha Malaghalikilo na Mapwalichayo, anda nahajhe nanyingii ng'o munahota gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Nnyohine njwe bhando bha makacho bhakalobhalilwe, ‘Nkotoka kukoma! Nambo mundo jwakoma chakaka na jwenio nahadabulwa.’ ");
INSERT INTO dne_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nambo nenga ninobholela, jhojhoha jwanyomela nnongo mundo, chakaka nahadabulwa. Jwapucha nnongo natakalilwa pa nyumba jha mihalo. Jwankema nnongo mundo ‘Kupumbumuka.’ Itope kujhingila mu mwotu gwa machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Bhahe, anda mpelike litambiko lino palonge jha kachangwale ka litambiko na peniya nkombwike anda nnemwihine na nnongo gwino, ");
INSERT INTO dne_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Lileka hote litambiko lino palonge jha kachangwale, nnyenda hote mukajhelane na nnongo gwino, peniya nkelebhuka na mpiye litambiko lino.” ");
INSERT INTO dne_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nnyelelane na jwatakalile kajhombe pumubhehe undela kujhenda ade pa Bwalo jha mihalo. Chakaka jwatakalile jwino nampeleka kwa jwajhokanikiya mihalo, na jwenio nnyomola mihalo napeleka kwa akakomana ngondo, na mwenga natabhwa mukipungo. ");
INSERT INTO dne_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ninnobholela chakaka, namoke jhe mwenio ade nkung'unde chente jha kujhomolekeya.” ");
INSERT INTO dne_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mukajhohine bhando bhakalobholilwe, ‘Nkotoka kuhenga ngongola.’ ");
INSERT INTO dne_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nambo nenga ninobholela, kila mundo jwanolekeya mwikeghe kwa kumpala, atei ngongola ku mwojho gwake. ");
INSERT INTO dne_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Bhahe, anda liho lino lya ngejha lihobhiche, mulibhohe na kulitaghii kutale. Mbaha kwino kihobhelele kipande chimo cha payegha, kuliku yegha jhoha kutagwa mu mwotu gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Anda lubhoko lwino lwalelo luhobhecha, muluhekete na kulutaghii kutale. Mbaha kwino kuhobhecha kilebhe chimo cha yegha, kuliku yegha kujhingii mu mwotu gwangahimika gwa machiko ghoha.” ");
INSERT INTO dne_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nikanobholile njwe, mundo jhojhoha, ‘Jwanneka nhwana mundo ipala anyandikila baluwa jha kunneka.’ ");
INSERT INTO dne_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nambo nenga ninnobholela, mundo jhojhoha jwaneka nhwana mundo na kutolela, nambo kwa nhwalo jha ughone, antenda atende ngongola, na munalome anda antolile mwikeghe jwenio, jwenio atenda ngongola.” ");
INSERT INTO dne_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kabhele mukajhohine kubhehe bhando bha makacho bhakalobholilwe, ‘Nkotoka kutwekula kilapo chino, ipalwa mukihenge kilapo chino palonge jha Bhambo.’ ");
INSERT INTO dne_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nambo nenga ninobholela, mwangalapanikii ng'o hilu kwa kunane kwa Chapanga, nhwalo ndi kigoda cha unahota gwa Chapanga, ");
INSERT INTO dne_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","amu kulapa kwa nnema, nhwalo ndi kigoda chake cha kujheghemekeya makongono, amu ku Yeluchalemo, nhwalo ndi muche gwa mu Nahota nkolongwa. ");
INSERT INTO dne_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nkotoka kulapanikii kwa muto gwino, nhwalo mihoto ndeka kulitenda lijhunjo limo kubhehe liuho amu lipile. ");
INSERT INTO dne_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Anda nnongi, ‘Chakaka,’ bhahe ibhaha ‘Chakaka,’ na pumulongela, ‘Nahi jhe,’ bhahe ibhaha chakaka ‘Nahi jhe.’ Chochoha chikichocha hena kihuma kwa jhola jwanganandela.” ");
INSERT INTO dne_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nnyohine ghalongelwa, ‘Liho kwa liho, lino kwa lino. ");
INSERT INTO dne_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nambo nenga ninnobholela, nkotoka kulepechela kwa mundo jwanganandela. Anda mundo anapwile mbalamande litama lyuulelo lapu, mughalambukile na lenge. ");
INSERT INTO dne_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Anda mundo atakalile pa nyumba jha mihalo kupala kutola ngobho hino, munekele atole na likote lino. ");
INSERT INTO dne_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Anda mundo achokolikiye nghegha nhigho gwake kilomita jhimo, nnyeghe jhenge ibhele. ");
INSERT INTO dne_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jwannyopa mupela, nkotoka kughalambukila kihogho jwapala kujhahika kilebhe.’ ” ");
INSERT INTO dne_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nnyohine bhando bhakilongila, ‘Mupale nnyino, na kunchimwa likoko lino.’ ");
INSERT INTO dne_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nambo nenga ninnobholela, mwapale akamakoko bhino na kwajhopela bhala bhubhang'aha mangota, ");
INSERT INTO dne_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","naha namaha yana ya Tate gwino jwabhii kunane kwa Chapanga, nhwalo jwenio ubhalangalila lyobha bhando bhanganandela na bhambone, na kwakomela hula bhando bhambone palonge jha Chapanga na bhanganandela. ");
INSERT INTO dne_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bho, nanyambulila ndweko ghane kwa kwapala tugha bhabhala bhala bhubhampala mangota? Kibhii jhe! Nhwalo hilu bhiakatola kode bhatenda gheniya! ");
INSERT INTO dne_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Anda mwajhambwiche akalongo bhino tugha, bho, mutenda kilebhe chamaha kuliku bhando bhange? Hilu bhando bhangaumanya Chapanga bhene utenda helahela. ");
INSERT INTO dne_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bhahe, mipalwa nkota kupongokewa chochoha kuhenga gha mbone ngita Tate gwino jwa kunane chatenda gha umbone.” ");
INSERT INTO dne_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mukilolekehe nkotoka kuhenga mahengo ghamaha palonge jha bhando nhwalo mipala ntondobheywa na bhando. Anda nahajhe, Tate gwino jwabhii kunane kwa Chapanga napela ndeka ndweko.” ");
INSERT INTO dne_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Anda mwatangatile akahocho, nkotoka kwalobholela bhando. Nkotoka kutenda ngita jwakitenda jwaumbone ndi chibhatenda munyumba jha kukonganikii Akayahude na mundela bhapala bhando bhakwehe. Ninnobholela chakaka, bheniya bhapatite njwe ndweko yabhe. ");
INSERT INTO dne_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nambo mwenga pumuntangatila nhocho, mutangatile changamanya mundo jhojhoha. ");
INSERT INTO dne_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mmohe utangatilo gwino changamanya bhando, na Tate gwino jwanolekeya kumwojho, nampela ndweko.” ");
INSERT INTO dne_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pumunyopa Chapanga, nkotoka kubhehe anda bhando bhubhakitenda bhambone. Bhene upala kujhema kunyopa munyumba jha kukonganikii na mu malekano gha ndela bhabhonekane na bhando. Ninnobholela chakaka, bheniya bhapatite njwe ndweko yabhe. ");
INSERT INTO dne_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nambo mwenga pumunyopa Chapanga, nnyingile ku chumbe chino, na mpogheke nnyango gwino, peniya munyope Tate gwino jwangabhonekana, na jwenio Tate gwino jwalola ghumuhenga ghala kwa kinyemela ghughabhii nkate jha mwojho, nampela ndweko.” ");
INSERT INTO dne_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pumunyopa, nkotoka kuchobhela chobhela ngita bhando bhangaumanya Chapanga. Bhene bhahambuka kubhehe Chapanga nabhajhokanikiya nhwalo gwa kulonge malobhe twe ghangabhehe gha mbone.” ");
INSERT INTO dne_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nkotoka kuhwanana na bheniya, Tate gwino amanye chimipala kabula munatumbu jhe kunyopa. ");
INSERT INTO dne_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bhahe, naha ndi chimipala kulonge piminnyopa Chapanga. Tate gwito jhumii kunane kwa Chapanga, Liina lino lilombwe. ");
INSERT INTO dne_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Unahota nkolongwa gwino uhike. Limipala lihengeke pannema ngita kunane. ");
INSERT INTO dne_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mutupele chakulyegha chito cha kila lichiko. ");
INSERT INTO dne_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mutulekekehe uhakaho gwito, ngita twenga chitwalekekeya bhibhatulemwihe. ");
INSERT INTO dne_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nkotoka kutujhingiya mu majhighanikilo, nambo mutukombole na jhola jwanganandela. Nhwalo unahota ndi gwino, na likakala na ukolongwa kwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nhwalo anda twalekekekiye bhange bhubhalemwite, Tate gwito jwa kunane kwa Chapanga nanekekeya na mangota hele. ");
INSERT INTO dne_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nambo anda mwalekekiye ndeka bhando, na Tate gwino nanekekeya ndeka. ");
INSERT INTO dne_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pumukihibhilikiya kulyegha, nkotoka kubhehe ngita bhibhakitenda bhando bhambone. Bhene ukekenala kumiho jhabhe bhabhonekana palonge jha bhando bhatei kukihibhilikiya kulyegha. Ninnobholela chakaka, bhene bhalepitwe njwe ndweko jhabhe. ");
INSERT INTO dne_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nambo mwenga pumukihibhilikiya kulyegha, npakala muto gwino mahuta, na kumiho jhino nkuhe mache, ");
INSERT INTO dne_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","mundo jhojhoha ankotoka kumanya nnekite kulyegha, nambo umanyikane Tate gwino jwaghabhona kwa kinyemela. Na Tate gwino jwalolekeya ghughabhii nkate, nahupa. ");
INSERT INTO dne_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nkotoka kukibhekela kihukilo pannema pano, umeya uhoto kuhangabhana, bhibhakwatula ujhingii na kukwatula. ");
INSERT INTO dne_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nambo mukibhekele kihukilo chino kunane kwa Chapanga umeya na ukungo uhoto jhe kuhangabhana, hilu bhibhakwatula bhajhingii jhe kukwatula. ");
INSERT INTO dne_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nhwalo pala pukibhii kihukilo chino, ndi pupala kubhehe mwojho gwino. ");
INSERT INTO dne_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Liho lino ndi kolobohi jha yegha. Anda liho lino lyambone, yegha jhino jhoha naibhaha lumule. ");
INSERT INTO dne_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nambo anda liho lino libhoho, yegha jhino jhoha naibhaha lubhendo. Bhahe, anda lumule lulubhii nkate jhino ndi lubhendo, lono ndi lubhendo lwa kujhoghoha hake! ");
INSERT INTO dne_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Abhii jhe mundo jwahoto kwahengela akanahota mabhele. Nhwalo nachimwa jhumo na kupala jhola jhubhele, amu nanyeketela na jhumo na kupucha jhonge. Muhoto jhe kunhenge Chapanga na ilebhe pamonga. ");
INSERT INTO dne_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ndi nhwalo ninobholela, nkotoka kubhehe na kiholo natulya nike na natunywegha ipala ughome. Amu ngobho imipala kwa nhwalo gwa yegha jhino. Bho, yakulyegha ndi kilebhe kikolongo kupeta ughome? Na yegha, bho, chi kupeta kwa ngobho? ");
INSERT INTO dne_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mwalolekehe ijhune ya kumanyahe bhimicha ndeka hilu kuhuna amu bhakwete jhe kikoko. Pamonga na gheniya, Tate gwino jwa kunane kwa Chapanga nanicha. Bho, mangota bhamaha ndeka kuliku yenio ijhune? ");
INSERT INTO dne_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Bho, ghane pakate jhino jwabhii na kiholo hake jwahoto kukijhonjekeya machiko gha ughome gwake? ");
INSERT INTO dne_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Kwa nhwalo gwa ngobho mubhehe na kiholo? Mughalolekehe malobha gha kumanyahe chighahalalila. Ghihenga jhe lihengo hilu kuloka ngobho. ");
INSERT INTO dne_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Nambo ninobholela chakaka, hilu Solomone jwenio na ilebhe yake yoha akapatite jhe kuhwalichwa mbone ngita lilobha limo. ");
INSERT INTO dne_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Bhahe, anda Chapanga ulihwalicha naha lihamba lya mughonda deleno libhii na kilabho jhake ulitagha pa mwotu, bho, mangota nantendela jhe kupeta peniya? Mangota bhando bhumii na kihobholelo chandina! ");
INSERT INTO dne_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Bhahe, nkotoka kubhehe na kiholo, ‘Natulya nike, natunywa nike, natuhwala nike!’ ");
INSERT INTO dne_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nhwalo gheniya ghoha bhando bhangaumanya Chapanga bhang'ahikila gheniya. Tate gwino jwa kunane kwa Chapanga amanye kubhehe mighana ilebhe yenio yoha. ");
INSERT INTO dne_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nambo mupalahe hote Unahota gwa Chapanga na ghapala ghoha na gheniya ghoha nanyonjekewa. ");
INSERT INTO dne_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bhahe, nkotoka kubhehe na kiholo na ilebhe ya kilabho, kilabho ibhii na ilebhe yake. Malola gha lichiko limo ghakwela kwa lichiko lyenio. ");
INSERT INTO dne_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Nkotoka kwahadabuu bhange, na mangota nahadabulwa na Chapanga, ");
INSERT INTO dne_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","nhwalo chimahadabula bhange, ndi mangota nanhuadabulilwa kipemo cheche, chimwapemela bhange, ndi Chapanga nanhadabulila kwino. ");
INSERT INTO dne_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bho, nhwalo gwa nike mukibhona kipalamande chikibhii muliho lya nnongo gwino, nambo mulibhona jhe lijhola lilibhii muliho lino? ");
INSERT INTO dne_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Amu mihoto bhole kunongolela nnongo gwino, Nnongo, denda nimohe lipande muliho lino, kongo nkwete lijhola muliho lino? ");
INSERT INTO dne_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mwenga mukitenda mundo jwaumbone! Mulibhohe hote lijhola lilibhii muliho lino na peniya ndi nanola telatela na kuhoto kubhoha lijhola lilibhii muliho lya nnongo gwino.” ");
INSERT INTO dne_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nkotoka kwapela ghimbwa ilebhe ya Chapanga, bhahoto kughalambuka na kukachulana mangota amu nkotoka kwataghii magholobhe lwambo ya lulo bhahoto kughatimbatimba kwa magholo ghabhe. ");
INSERT INTO dne_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nnyope na mangota napelwa, mupalahangane nampata, nkong'onde litangala na mangota nadindulilwa. ");
INSERT INTO dne_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nhwalo gwenio mundo jhojhoha jwajhopa upelwa, na mundo jhojhoha jwapalaha napata, na jwakong'onda litangala nadindulilwa. ");
INSERT INTO dne_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bho, abhii jhojhoha pakate jhino jwanyopa mwana mundo libumunda, na jwenie napela lighanga? ");
INSERT INTO dne_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Amu bho, anda anyopite luhomba, nampela lijhoka? ");
INSERT INTO dne_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Anda yenio bhahe, mangota pamonga na gwanganandela gwino, mimanya kwaipela yana hino yambone, chakaka Tate gwino jwa kunane kwa Chapanga natenda kuchocha kwa peniya. Nabhapela ghambone bhala bhibhannyopa.” ");
INSERT INTO dne_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ghoha ghumipala bhando bhantendele mangota, mwatendele bheniya helahela. Naha ndi chililonge Lilaghalikilo lya Chapanga lyakampekiye Mucha na mabholo gha milondole bha Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nnyingile kwa kupete nnyango nkombaho. Kwa nhwalo ndela jhilongocha mukuwegha ndi ngolongwa, na litangala lya kujhingilila mwenio ndi ngolongwa, bhubhajhenda ndela jhenie bhabhii twe. ");
INSERT INTO dne_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nambo ndela jhijhenda mughome gwa machiko ghoha ndi ngombaho, na litangala lya kujhingilila hele likombaho, ndi bhando bhandina tugha bhihoto kuimanya ndela jhene.” ");
INSERT INTO dne_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mukilolekehe na milondole bhuwange. Bhene uhika kwino bhabhonekana ngita mambelele kwa panja, nambo kwa nkate mamehe. ");
INSERT INTO dne_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Namamanya kwa mahengo ghabhe. Bho, bhando upochomola mahuku mu mikongo jha mibha, amu ntine mu mikwanga? ");
INSERT INTO dne_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bhahe, nkongo gwambone upambika uhohe gwa mbone, na nkongo gwanganandela upambika uhohe gwanganandela. ");
INSERT INTO dne_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nkongo gwamaha uhoto ng'o kupambika uhohe gwangamanyika, hilu nkongo gwangamanyika uhoto jhe kupambika uhohe ghambone. ");
INSERT INTO dne_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kila nkongo gwangapambika uhohe gwambone naupengulwa na kutagwa pamwotu. ");
INSERT INTO dne_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kwa ngoheno, namamanya kwa mahengo ghabhe.” ");
INSERT INTO dne_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Chi kila mundo jwangema, ‘Bhambo, Bhambo,’ najhingila Munahota nkolongwa gwa kunane kwa Chapanga, nambo jhola tugha jwahenga ghala ghapala Tate gwango jwabhii kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bhando bhamahele nabhanongolela lichiko lela lya luhadabulo, ‘Bhambo, Bhambo!’ Kwa liina lino tukatangiche malobhe ghino, na kwa liina lino tukabhengite michuka na kuhenga ikangacho twe. ");
INSERT INTO dne_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Peniya nanikanila, ‘Niumanyingine ng'o mangota, mmokengane palonge jhango, mangota bhumutenda mabhoho.’ ");
INSERT INTO dne_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bhahe, kwa kila mundo jwajhokanikiya malobhe ghango na kughahenge lihengo, ahwanana na mundo jhuna malango, jwachengite nyumba jhake panane jha lindalabho. ");
INSERT INTO dne_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hula ijhakukoma, ngemba ijhakutwelela, kimbonga kijhapogha na kuhinyuanyua nyumba jhene. Nambo nyumba jhene ikagwii jhe nhwalo ikachengwite panane jha lindalabho. ");
INSERT INTO dne_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nambo mundo jhojhoha jwajhoha malobhe ghango changaghahenge lihengo, nalandana na mundo jwapumbumwike jwachengite nyumba jhake panane jha ncheke. ");
INSERT INTO dne_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hula ijhakukoma, ngemba ijhakuheluka mache, kimbonga kijhakunyuanyua nyumba jhene, na nyumba jhene ijhakugwegha, na kugwegha kwenio kujhabhehe kukolongwa.” ");
INSERT INTO dne_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yecho pajhomolila kulonge malobhe gheniya, lilongo lya bhando bhajhakukangacha kwa mabholo ghake. ");
INSERT INTO dne_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nhwalo akibha jhe anda bhabhola bheniya bha malaghalikilo, nambo abholita ngita jhuna ukindendeke. ");
INSERT INTO dne_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yecho pahelila ku kitombe, lilongo likolongwa lya bhando lijhakunkengama. ");
INSERT INTO dne_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bhahe, akahikite mundo jhuna malohe, akanyinamile alongila, “Bhambo, anda uhoto kunyelebhula, unyelebhulajhe!” ");
INSERT INTO dne_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yecho ajhakuhatambuu lubhoko lwake na kumpapaha na kulonge, “Nipala! Nnyelebhuke.” Papa mundo jwenio ajhakulama malohe gwake. ");
INSERT INTO dne_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bhahe, Yecho ajhakunnobholela, Dolokeya, “Nkotoka kunobhole mundo jhojhoha, nambo nnyende mukakilangiye kwa mupiya litambiko jwa Chapanga, na mpeleke litambiko lino kwa nhwalo gwa kujhelebhuka kwino ngita chalaghalikiye Mucha nhwalo gwa kwalangii bhando bhoha nnamite.” ");
INSERT INTO dne_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yecho pajhingila kubomane jha ku Kapelenaumo, nkolongwa jwa akakomana ngondo jhumo jwa ku Loma ajhakunyendelela Yecho na kumpembelekeya antangatile. ");
INSERT INTO dne_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Alongila, “Bhambo, ntumiche gwango agholwike unyumba, atengwike yegha na yegha jhoha ibhina.” ");
INSERT INTO dne_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yecho ajhakunnobholela, “Nahika kunnamicha.” ");
INSERT INTO dne_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jwenio nkolongwa jwa akakomana ngondo ajhakunnobholela, “Bhambo, itope ndeka mwenga kujhingila nkate jha nyumba jhango. Nambo unnobholele lilobhe tugha, na ntumiche jwango nalama. ");
INSERT INTO dne_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nhwalo nenga mii mundo pahe jha ukindendeke gwa bhange, ngwete akakomana ngondo pahe yango. Anda ninnobholile jhumo, ‘Jhenda!’ Na jwenio ujhenda, na ninnobholela jhonge ‘Ika!’ Na jwenio uhika. Anda ninnobholile ntumiche gwango, ‘Nhwenge lende.’ Na jwenio uhenga.” ");
INSERT INTO dne_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yecho pajhohina malobhe gheniya, akakangiche hake, ajhakwalobholela bhando bhubhakibha bhankengima, “Ninnobholela chakaka, nanapatajhe kulola mundo jhojhoha ku Ichilahele jhuna kihobholelo ngita chenje. ");
INSERT INTO dne_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bhahe, nalobholela bhando bhamahele nabhahika kuhumii kulipitii lyobha na kulitipikii lyobha, na bhene nabhatama pa unyagho gwa kulyegha pamonga na Ulahimo, Isaka na Yakobu mu Unahota gwa kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Nambo bhala bhubhapalwa kubhehe mu Unahota gwono ndi bhataghwii panja, kulubhendo, kweno nabhalela na kuyagha mino.” ");
INSERT INTO dne_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Peniya Yecho ajhakunnobholela nkolo jwa akakomana ngondo jweno, “Nnyende kajha, na ibhehe ngita chimuhobholela.” Ntumiche gwake ajhakulama lichaa lelela lela. ");
INSERT INTO dne_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yecho ajhakujhenda ukajha kwa Petile, ajhakunkola nkoano mundo mwikeghe Petile agholwike pakindanda, itenda kupyopa hake. ");
INSERT INTO dne_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bhahe, Yecho ajhakumpapaha majhe jwenio lubhoko, na ulwalo ukannekekiye, ajhakujhema na kutumbuu kwatelekela. ");
INSERT INTO dne_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pikihikita kimiye, bhakannetile bhando twe bhubhakibha na michuka, na jwenio, kwa malobhe ghake, ajhakubhenga michuka jhene. Ajhakwalamicha bhando bhoha bhubhalalwita. ");
INSERT INTO dne_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Akatei gheniya ghighalongilwa na nnondole Isaya ghatimile, “Jwenio atoile malola ghito, agheghite malola na malwalo ghito.” ");
INSERT INTO dne_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yecho pabhonita lilongo lya bhando lintindile, ajhakwalobholela, bhabholwa bhake bhajhende kwiye jha lilabha. ");
INSERT INTO dne_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mmola jhumo jwa Malaghalikilo akanyendile Yecho, akannobholile, “Mmola, nenga naninkengama mwenga kokoha kola kumijhenda.” ");
INSERT INTO dne_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yecho akannyangwile, “Mabweya ghabhii na mikwembe jhabhe na ijhune ibhii na mihuhe jhabhe, nambo Mwana gwa Mundo akwete ndeka pakujhebhelekeya lubhaho lwake.” ");
INSERT INTO dne_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Peniya mundo jhonge pakate jha bhabholwa bhake ajhakunnobholela, “Bhambo, nnyende hote kunchika tate gwango.” ");
INSERT INTO dne_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nambo Yecho ajhakunobholela, “Ungengame! Mwaleke bhubhawile bhachikane bhubhawile chika.” ");
INSERT INTO dne_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yecho ajhakujhingii mungalabha, na bhabholwa bhake bhajhakujhenda pamonga na jwenio. ");
INSERT INTO dne_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Peniya kijhakupeti kimbonga kikolongwa mulilabha, matuhe gha mache ghajhatumbu kuyekelela ngalabha. Yecho akibha agholwike lugwenio. ");
INSERT INTO dne_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bhabholwa bhakannyendile Yecho, bhajhakunyimuha bhalongila, “Bhambo, mutukombole, tuwegha!” ");
INSERT INTO dne_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yecho ajhakwalobholela, “Mangota bhumii na kihobholelo chandina, bho, nhwalo gwa nike mijhoghopa?” Bhahe, akajhinwike, ajhakukipwatalila kimbonga na matuhe gha mache ghala gha mulilabha lela ghajhakubhehe njelembo na teeke. ");
INSERT INTO dne_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bhando bhakakangiche hake, bhalongila, “Bho, ojho mundo ghane ade kimbonga kinnyeketela?” ");
INSERT INTO dne_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yecho akahikite ku kilambo cha bha Gelache kwiye jha lilabha, na kwono bhando bhabhele bhubhakibha na michuka bhakakonganiki nako bhahumila ku mambe. Bhando bheniya bhakibha bha kujhoghoha hake, abhii jhe mundo jwahotwila kupete ndela jhene. ");
INSERT INTO dne_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Na bhene bhakatumbwii kulalama, “Mipala nike kwa nenga mwenga Mwana gwa Chapanga? Bho, uhikite kutung'aha kongo lichiko linahika jhe?” ");
INSERT INTO dne_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pahina na peniya pakibha na lilongo likolongwa lya magholobhe ghighaluchitwa. ");
INSERT INTO dne_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Peniya michuka ikampembelikihe Yecho, “Anda mipala kutubhoha, bhahe, mutulekekehe tughajhingii magholobhe ghala.” ");
INSERT INTO dne_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yecho akabhalobhalile, “Chakaka, nnyendengane.” Peniya bhajhakubhoka kwa bhando bheniya, na kughajhingii magholobhe. Lilongo lyoha lya magholobhe lijhakutilila muluhelelo na kutumbukila mulilabha na kuhobholela mwenio. ");
INSERT INTO dne_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bhalucha magholobhe bhajhakutila na kujhenda kubomane. Kwalobholela bhando malobhe ghoha na mambu ghighapitile bhando bhala bhubhakibha na michuka. ");
INSERT INTO dne_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bhahe, bhando bhoha bha muche ghola bhajhakubhoka, bhakanyendilii Yecho, na kumpembelekeya, abhoke mu kilambo chabhe. ");
INSERT INTO dne_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yecho pakwelita mungalabha, ajhakujhomboka lilabha na kuhika mumuche gwake. ");
INSERT INTO dne_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Peniya bhando bhakannetile mundo jhumo jwatengwike yegha, aghonikichwe mu nchekacheka. Yecho palolita kihobholelo chabhe, ajhakunnobholela mundo jwatengwike, “Kangamala mwanango! Nnekekiwe uhakaho gwino.” ");
INSERT INTO dne_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bhabhola bhange bha Malaghalikilo gha mucha bhange bhakatumbwi kupwepwelana, “Mundo ojho innigha Chapanga!” ");
INSERT INTO dne_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yecho akamanye chibhahola, akalongi, “Nhwalo ghane mihwachila ghanganandela kumiojho jhino? ");
INSERT INTO dne_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nike chikijhojwike kulonge, ‘Uhakaho gwino ulekekiwe,’ amu kulonge, ‘Nnyeme ntyange?’ ");
INSERT INTO dne_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bhahe, nipala umanye, Mwana gwa Mundo akwete ukindendeke pannema gwa kwalekekeya bhando uhakaho.” Peniya ajhakunnobholela mundo jwenio jwatengwike, “Jhimuka, tola nchekacheka gwino, nnyende ukajha kwino.” ");
INSERT INTO dne_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mundo jwenio jwakatengwike akajhinwike, akajhawii ukajha. ");
INSERT INTO dne_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bhando bhoha pa lilongo lyenio pibhalolita gheniya, bhajhakukangacha na kujhoghopa, bhajhakunnomba Chapanga jwabhapekiye bhando ukindendeke gwa kuhenga gheniya. ");
INSERT INTO dne_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yecho ajhakubhoka peniya, na pabhokita, akamwene mundo jhumo jwakemitwa Matei, atamite munyumba jha kulepe kode. Bhahe, Yecho ajhakunnobholela, “Hika ungengame.” Matei akajhemite, ajhakunkengama. ");
INSERT INTO dne_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yecho pakibha ukajha kwa Matei, na atamite pahe kwa nhwalo gwa kulyegha, bhibhalepecha kode bhamahele na bhibhahenga mabhoho bhakahikite na kutama pamonga na jwenio na bhabholwa bhake. ");
INSERT INTO dne_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mapwalichayo pibhalolita gheniya, bhajhakwalobholela bhabholwa bhake, “Nhwalo ghane mmola gwino ilyegha pamonga na bhibhalepecha kode na bhibhahenga uhakaho?” ");
INSERT INTO dne_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yecho ajhakwajhoha, akalongi, “Bhando bhangalwalwa bhipala ndeka nng'anga, bhibhimpala ndi bhala bhibhalwalwa. ");
INSERT INTO dne_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bhahe, mukakibhole mana jha malobhe agha, ‘Nipala kiya, na chi litambiko.’ Nakahikite jhe kwakema bhando bhambone palonge jha Chapanga, nambo bhina uhakaho.” ");
INSERT INTO dne_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Peniya, bhabholwa bha Yohane Mbatichajhe bhakannyendile Yecho, bhakankonyite, “Twenga na Mapwalichayo tipunga kulyegha mala jhamahele, bho, nhwalo ghane bhabholwa bhino bhipunga ndeka?” ");
INSERT INTO dne_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yecho ajhakwajhanguu, “Bho, bhando bhibhalalikwe kuunyagho gwa ndowa ipalwa kubhehe ngolongondi na peniya nnyinamwale abhii pamonga na bhene? Ihoto ndeka kupunga! Nambo lichiko libhii kuhika nnyinamwale nabhoka pakate jhabhe, peniya ndi nabhapunga kulyegha. ");
INSERT INTO dne_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Bhando bhibheka ndeka kibhambo cha ngobho yono na kuchonolela mukindukotuko. Nhwalo kindukonduko chenie naijwepula ngobho jha makacho, na pala pupakibha pajwepwike napajhonjekeka. ");
INSERT INTO dne_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hilu bhando bhibheka ndeka divaye yono mulihako lya makacho lya limbendela. Anda bhatehi naha, lihako lyenio nalijwepuka na divaye naijhitika, na lihako yenio lya limbendela nailola. Bhando bhibheka divaye yono mulihako liyono, na yoha ibhena, lihako lya limbendela na divaye, naibhaha njelembo.” ");
INSERT INTO dne_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yecho palongila gheniya, nkolo jhumo Uyahude akahikite, akannyinamile na kulonge, “Nchikana gwango ahwii ngohengohe. Nambo chonde, tijhende ukamekele lubhoko lwino na jwenio nalama.” ");
INSERT INTO dne_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yecho ajhakulongohana na bhabholwa bhake, bhajhakunkengama helahela. ");
INSERT INTO dne_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Majhe jhumo, atehila kulwalwa ulwalo gwa pihe kwa yaka kome na ibhele, ajhakunkengama Yecho chakuyeto, akapapihe lilombolo lya ngobho jhake. ");
INSERT INTO dne_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ajhakukilobholela hote akahwachii ku mwojho gwake, “Anda mbapihe tugha ngobho jhake namaha njelembo.” ");
INSERT INTO dne_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bhahe, Yecho paghalambwika ajhakumona, ajhakunnobholela, “Nchikana gwango nkangamale mwojho, kihobholelo chino kinnamiche.” Nchikana jwenio akalamite papa peniya. ");
INSERT INTO dne_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Peniya Yecho akajhingii munyumba jha munahota jhola. Na kwabhona pibhahonita itolilo na lilongo lya bhando bhibhalela kongo bhayolayola pahe, ");
INSERT INTO dne_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","alongila, “Mmokangane pamba! Nchikana jhonjo ahwii ndeka, agholwike tugha.” Na bhene bhajhakunheka. ");
INSERT INTO dne_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Bhahe, lilongo lya bhando pibhabhokita, Yecho akajhingii nkate, akankamwii nchikana jhola lubhoko, na jwenio ajhakujhema. ");
INSERT INTO dne_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Malobhe gheniya ghajhakupechangana pa kilambo choha. ");
INSERT INTO dne_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yecho pibhabhokita peniya, pakibha ijhenda, bhangalola bhabhele bhajhakunkengama bhalalima, “Mwana gwa Daude, umonele kiya!” ");
INSERT INTO dne_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yecho pajhingila munyumba, bhando bhabhele bheniya bhajhakunnyendela, na jwenio ajhakwakonya, “Bho, minnyeketela ngita nihotola kunamicha?” Na bhene bhakanyangwile, “Chakaka, Bhambo.” ");
INSERT INTO dne_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Peniya, Yecho akapapihe miho ghabhe, alongila, “Na ibhaha kwino ngita chimuhobholela.” ");
INSERT INTO dne_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Miho ghabhe ghakadindwike. Na jwenio Yecho ajhakwakanakiya kwa lilaka, “Nkotoka kunnobholela mundo jhojhoha kilebhe eche.” ");
INSERT INTO dne_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Nambo bhene bhakabhokangine, na kughatangacha malobhe gha Yecho mu kilambo chela choha. ");
INSERT INTO dne_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bhando bhala pubhabhokingina, bhando bhange bhajhakunnetela Yecho mundo jhumo jwangalongela nhwalo akibha na nchuka. ");
INSERT INTO dne_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Papa peniya nchuka ghola pubhohitwa, mundo jwenio jwakibha ilonge ndeka akatumbwii kulonge kabhele. Bhando bhakakangiche na kulonge, “Lijhambu ngita elele likapiti ndeka mu Ichilahele!” ");
INSERT INTO dne_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nambo Mapwalichayo bhakibha bhalongila, “Abhenga michuka kwa likakala lya nkolo gwa michuka.” ");
INSERT INTO dne_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yecho akatyangile miche jhoha na muchenda, ajhakubhola munyumba jha kukonganikii Akayahude ajhakutangacha Malobhe gha Mbone gha Unahota gwa Chapanga na kulamicha ulwalo gwoha na kwabhokeha bhando malagho ghabhe. ");
INSERT INTO dne_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bhahe, pabhabhonita bhando ibhogha ibhogha, ajhakwabhone kiya nhwalo bhakibha bhatotokile na bhabhii na bhoghohe ngita mambelele ghangabhehe na nnuchajhe. ");
INSERT INTO dne_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Peniya ajhakwalobholela bhabholwa bhake, “Mahuno ghamahena, nambo bhahenga mahengo bhandina. ");
INSERT INTO dne_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bhahe, munnyope nkolo mahuno abhalete bhahenga mahengo ahuna mahuno ghake.” ");
INSERT INTO dne_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yecho ajhakwakema pamonga bhabholwa bhake kome na bhabhele, na kwapela ukindendeke gwa kubhenga michuka na kulamicha ulwalo na malagho ghoha. ");
INSERT INTO dne_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Maina gha akatenga bheniya kome na bhabhele ndi ghanga: Simone jwakemitwa Petile na unung'una mundo Anduleya, na Yakobu mwana gwa Zebedayo, na Yohane nnongo mundo, ");
INSERT INTO dne_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipu na Batulomayo, na Tomache na Matei jwalepicha kode, na Yakobu mwana gwa Alufayo, na Tadayo, ");
INSERT INTO dne_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simone mundo jwakikengelela kilambo chake, na Yuda Sikaliyote jwanyambila Yecho. ");
INSERT INTO dne_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yecho ajhakwatuma na kwapela ukindendeke bhabholwa kome na bhabhele bheniya, ajhakwalaghalikiya, “Nkotoka kujhenda kwa bhando bha ilambo henge. Hilu nkotoka kujhingii miche jhojhoha jha bha Samaliya. ");
INSERT INTO dne_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nambo mwajhendelele bhando bha ku Ichilahele, nhwalo bhabhii ngita mambelele ghighahobhalile. ");
INSERT INTO dne_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pumajhendelela mwatangachila naha, ‘Unahota gwa kunane kwa Chapanga nheghelile.’ ");
INSERT INTO dne_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mwalamiche bhibhalwalwa na mwayokeche bhubhawile na mwalamiche bhubhabhii na malohe na muhibhenge michuka. Mupatite jhajhe na mangota ntende jhajhe. ");
INSERT INTO dne_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nkotoka kughegha mu mahako ghino chaabo amu mbijha amu matobholo gha shaba. ");
INSERT INTO dne_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nkotoka kughegha lihako lya mwanja amu ngobho ya kujhangangana amu maghubache amu nkongocho. Nhwalo jwahenga lihengo atope malepo ghake kwa kila lichiko.” ");
INSERT INTO dne_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pumujhingi pamuche amu chenda jhojhoha, mpalahe mundo jwapala kumpokela, na mangota ntame kwa jwenio ade pumubhokangana kwenio. ");
INSERT INTO dne_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pumujhingii nkate mwajhambuche akolo muche, mwalobholela, ‘Uteeke ubhehe pa nyumba jhenjeno.’ ");
INSERT INTO dne_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Anda akolo muche gwenio nabhapokela mangota, uteeke gwino utame nako, nambo nabhampokejhe bhahe, uteeke gwenio naghumujhila mabhene. ");
INSERT INTO dne_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bhahe, anda mundo jhojhoha akanile kupokela amu kunyokanikiya mangota, pumubhoka munyumba jhene amu muche gwenio, nkung'unde lutukunda lulubhii mumagholo ghino. ");
INSERT INTO dne_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ninnobholela chakaka, lichiko lya Chapanga lya luhadabulo, muche gwenio nahubhaha mumalagho makolonga kuliku ghighapatite bhando bha ku Sodoma na ku Gomola! ");
INSERT INTO dne_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ngoheno mukilolekeye, nitumangana mangota ngita mambelele pakate jha mamehe. Nkola malango ngita lijhoka na ntokomala ngita ngunda. ");
INSERT INTO dne_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mukilolekehe na bhando, nhwalo nabhatakalila panyumba jha mihalo na kunkenyuu yato munyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nabhampeleka palonge jha ilongoche na akanahota kwa nhwalo jha nenga, kwa kwalobholela malobhe gha mbone, helahela kwa bhando bha ilambo ahenge. ");
INSERT INTO dne_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bhahe, pubhantakalila munyumba jha mihalo, nkotoka kubhehe na kiholo nanongila kilebhe ghane amu nanongela kwa ndela ghane, lichiko lyenio pulipalakuhika, namolwa gha kulonge. ");
INSERT INTO dne_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nhwalo mangota nanongela jhe kilebhe, nambo Uhuke gwa Tate gwino ghubhii nkate jhino ndi nalongela. ");
INSERT INTO dne_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nnongo nanyambila nnongo mundo akomwe na tate nanyambila mwana mundo, na yana yenio hele nabhakachulana akatate bhabhe na kwakoma. ");
INSERT INTO dne_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bhando bhoha nabhanchimwa mangota kwa nhwalo gwa unnyeketile nenga. Nambo jhola jwapala kuhimbilila ade kujhomolela jwenio naghombokoka. ");
INSERT INTO dne_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Bhando bhubhang'aha mmuche ghumo, ntilile muche ghonge. Ninobholela chakaka, nanyomolele jhe kuntindila mumiche jhoha jha ku Ichilahele kabula jha Mwana gwa Mundo anahika. ");
INSERT INTO dne_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Mmolwa ampeta ndeka mmola gwake, hilu ntumiche apeta jhe nkolo gwake. ");
INSERT INTO dne_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nambo ikwela kwa mmolwa kulandana na mmola mundo na kwa mmanda alandana na nkolo mundo. Anda bhankemite nkolo jwa nyumba, Belechebule, bho, nabhankema jhe bhando bhange bhubhabhii munyumba jhene mahina ghanganandela kupeta lyenele? ");
INSERT INTO dne_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bhahe, nkotoka kwajhoghopa bhando. Kilebhe chochoha chikiyekelilwe nakiyekulilwa, na kila kilebhe chikihihitwe nakibhaha mbegha. ");
INSERT INTO dne_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ghala ghunitangachila mulubhendo, mughalonge pakalamuhe na lininnobholila panga bhando mulilongele palonge jha bhando. ");
INSERT INTO dne_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nkotoka kwajhoghopa bhala bhibhahoto kukoma yegha, nambo bhahoto jhe kukoma uhuke, mbaha kunyoghopa jhola jwahoto kukoma yegha pamonga na uhuke na kuntaghii pa mwotu gwa machiko ghoha gwangahimika. ");
INSERT INTO dne_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Iyebhelele ibhele uchuluchwa kwa chenti jhimo jhandina. Nambo hilu jhumo pakate jhabhe agwejhe pahe changamanya Tate gwino. ");
INSERT INTO dne_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nambo kwa mangota, jwenio abhalinge majhunjo ghughabhii umuto gwino. ");
INSERT INTO dne_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ngohe, nkotoka kujhoghopa, nhwalo mangota bhambone kupeta iyebhelele twe! ");
INSERT INTO dne_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mundo jhojhoha jwanyeketela nenga palonge jha bhando, na nenga hele naninyeketela palonge jha Tate gwango jwabhii kunane. ");
INSERT INTO dne_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nambo mundo jhojhoha jwangana palonge jha bhando, na nenga hele nanikanila palonge jha Tate gwango jwabhii kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Mwangahambuka hikite pannema pano kuleta uteeke. Nenga hikite jhe pano kwatenda bhando bhatame kwa uteeke, nambo kuleta ngondo. ");
INSERT INTO dne_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nhwalo hikite kuleta bhulo pakate jha mundo na tate mundo, na nchikana na majhe mundo pakate jha nkohano na nkohano mundo mwikeghe, ");
INSERT INTO dne_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","na makoko bha mundo ndi bhando bha ukajhake. ");
INSERT INTO dne_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Jhola jwampala tate mundo amu majhe mundo kuliku nenga, jwamaha ndeka kubhehe mmolwa gwango. Mundo jwampala mwana amu nchikana kuliku nenga, jwamaha ndeka kubhehe mmolwa gwango. ");
INSERT INTO dne_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mundo jhojhoha jwanga ghegha nchalaba gwake na kungengama jwamaha ndeka kubhehe mmolwa gwango. ");
INSERT INTO dne_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nhwalo mundo jhojhoha jwaupala kulonda ughome gwake, nauhobhecha. Nambo jwauhobhecha ughome gwake kwa nhwalo gwa kunyeketela nenga naukombola kabhele. ");
INSERT INTO dne_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mundo jhojhoha jwampokela mangota, ambokela nenga helahela. Na jwenio jwambokela nenga ampokii jhola jwandumita. ");
INSERT INTO dne_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mundo jwapokela nnondole jwa Chapanga, nhwalo ndi nnondole jwa Chapanga, napokela ndweko jha ulondole gwa Chapanga. Mundo jwampokela mundo kwa nhwalo jwambone palonge jha Chapanga, napokela ndweko jha mundo jwambone palonge jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ninnobholela chakaka, mundo jhojhoha jwampela kimiche jha mache mahihimo kwa jhumo jwa bhando bhamba bhangamanyikana kwa nhwalo ndi mmolwa gwango, chakaka napokela ndweko yake.” ");
INSERT INTO dne_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yecho pajhomolila kwapela bhabholwa bhake kome na bhabhele malaghalikilo, ajhakubhoka peniya, akajhahwii kubhola na kwatangachila bhando Malobhe gha Mbone mu miche jhibhii pahina. ");
INSERT INTO dne_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yohane Mbatichajhe pakibha mukipungo akajhohine ghala ghahengita Yecho Kilichitu. Bhahe, Yohane akabhatumite bhabholwa bhake, ");
INSERT INTO dne_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bhankonye, “Bho, mwenga ndi jhola jwahika, amu tunnendele jhonge?” ");
INSERT INTO dne_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yecho ajhakwajhanguu, “Nnyendengane mukannobholele Yohane ghala ghumujhoha na kughabhona. ");
INSERT INTO dne_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bhangalola bhilola, bhubhalemile bhityanga, bhina na malohe bhilamichwa, bhangajhoha bhijhoha, bhubhawile bhiyokechwa na akahocho bhatangachilwa Lilobhe lya Mbone. ");
INSERT INTO dne_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jhuna mota mundo jhola jwanganeka kunyeketela nenga.” ");
INSERT INTO dne_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bhahe, bhabholwa bha Yohane pubhabhokita, Yecho akatumbwii kulongelela lilongo lya bhando malobhe gha Yohane, mkajhahwii kulola nike kola kunjenga? Bho, mukapaile kulinga matete ghighanyuha nyuha upepo? ");
INSERT INTO dne_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bhahe, mukajhawile kulola nike? Bho, Nnyahwila kunninga mundo jwawalite ngobho ichuluchwa kwa mbijha yamahele? Bhando bhibhahwala ngobho ya mbone utama munyumba jha unahota. ");
INSERT INTO dne_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nambo, unnobholele nike chimukajhawile kulinga? Bho, nnondole jwa Chapanga? Tela, chakaka jwenio ndi nkolongwa kupeta nnondole jwa Chapanga jhumoyobhalile. ");
INSERT INTO dne_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","“Yohane ndi jwalongelwa mu Majhandiko gha Chapanga, Chapanga alongila, ‘Dolokeya, nenga nintuma jumbe gwango alongolele, jwenio natengenecha ndela jhino.’ ");
INSERT INTO dne_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ninobholela chakaka, pakate jha yana yoha ya bhando, anahwahi jhe kutama jwabhii nkolo kuliku Yohane Mbatichajhe. Peniya jhola jwabhii nchokombe munahota gwa kunane kwa Chapanga, ndi nkolongwa kuliku jwenio. ");
INSERT INTO dne_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kuhumii mu machiko gha Yohane Mbatichajhe ade deleno, Unahota gwa kunane kwa Chapanga ukanwa kwa makakala, na bhando bhubhabhii na bhulo na makakala bhijhigha kuupoka kwa likakala. ");
INSERT INTO dne_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mabholo ghoha gha milondole bha Chapanga na Lilaghalikilo lya Chapanga lyapekiwe Mucha ade lichiko lya Yohane, ghoha ghakalotile unahota gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Anda mihoto kujheketela ghanga, bhahe, Yohane ndi Eliya jwahika. ");
INSERT INTO dne_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jwabhii na machikilo gha kujhoha na ajhohe! ");
INSERT INTO dne_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Bhahe, nikihwananicha kibheleko chenje na kilebhe ghane? Ngita yana ikibha itamite pa liguliho, bhibhakibha bhilongehana kibhogha chimo na chenge. ");
INSERT INTO dne_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ahona ng'oma nambo mukina ndeka! Tujhembite mihambo jha ungolongondi nambo mukalelite jhe!’ ");
INSERT INTO dne_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kwa nhwalo Yohane akahikite, ajhakupunga kulyegha anywila ndeka divaye, na bhene bhalongila, ‘Achikilwe nchuka.’ ");
INSERT INTO dne_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mwana gwa Mundo akahikita, alila na kunywegha, na bhene pibhalongila, ‘Nnolokehe hojho, kuhapatika na kulobhela, nkoche jwa akatola kode na bhibhabhii na uhakaho. Nambo malango gha Chapanga ghalangiwe ndi ghambone kwa mahengo ghake.’ ” ");
INSERT INTO dne_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Peniya Yecho akatumbwii kwapwatalila bhando bha miche jhela jhakahengite ikangacho yamahena mwenio, bhando bhake bhakapahi ndeka kuleka uhakaho. ");
INSERT INTO dne_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Nanola choto mwa Kolazine! Nanola choto mwenga mwa Betisaida! Nhwalo ikangacho itendika kwino, ngahitendika ku Tilo na ku Sidone, kuhumii makacho bhando bhake ngabhatumbwile kuwala ngobho ya majafafa na kutama paliho kulangiya bhamujhii Chapanga! ");
INSERT INTO dne_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Peniya, ninobholela, lichiko lya luhadabulo, mangota napata malagho makolongwa kuliku bhando bha ku Tilo na ku Sidone. ");
INSERT INTO dne_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mwenga, ma Kapelenaumo! Bho, namukikweya ade kunane kwa Chapanga? Oko naha ndeka, nabhahuluha ade ku kilambo cha bhando bhubhawile! Ngita ikangacho ihengika kwino ngaitendika kola ku Sodoma, muche gwenio na ngaubhii ade deleno. ");
INSERT INTO dne_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nambo ninnobholela, bhando bha ku Kapelenaumo lichiko lya luhadabulo nabhapata luhadabulo lukolongwa kuliku bhando bha ku Sodoma.” ");
INSERT INTO dne_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Machiko ghagha Yecho akalongile, “Nichengula mwe mwa Tate, Bhambo jwa kunane kwa Chapanga na pannema, kwa nhwalo mwahihite bhubhabhii na malango na bhando bhubhachomite malobhe ghanga na kwayekulila yana ichokombe. ");
INSERT INTO dne_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chakaka, Tate, ndi chimpata. ");
INSERT INTO dne_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Tate gwango ambekiye ilebhe yoha. Abhii ndeka jwaumanya Mwana nga Tate mundo, na abhii jhe jwaumanya Tate mundo nga Mwana na jhojhoha jwampahile mwana uyekulila. ");
INSERT INTO dne_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Hike kwa nenga mabhoha bhumilagha na kutotokela na mihigho, na nenga nanimpomoha. ");
INSERT INTO dne_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mukikonge lingolengole lyango, mukibhole kwa nenga, nhwalo nenga ndi natokomaho na natembekeho gwa mwojho, na nanintenda mupomolele miojho jhino. ");
INSERT INTO dne_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bhahe, lingolengole nimpela ndi lijhebhejhaho, na nhigho gwango nnyojhoho.” ");
INSERT INTO dne_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mu machiko gheniya, Yecho akibha ityanga mu mighonda jha ngano Lichiko lya Kupomolela. Bhahe, bhabholwa bhake bhajhakubhona njala, bhakatumbwii kutwekula manjwanjwane na kuyoghola ngano, bhakalile mbejho yake. ");
INSERT INTO dne_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mapwalichayo pibhalolita gheniya, bhajhakunnobholela Yecho, “Dolokeya, bhabholwa bhino bhihenga kilebhe chamaha jhe kuhenga Lichiko lya Kupomolela.” ");
INSERT INTO dne_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yecho ajhakujhanguu, “Bho, mukachomitejhe ghahengita Daude pamonga na ajhake pibhakibha na njala? ");
INSERT INTO dne_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jwenio akajhingii mu Nyumba jha Chapanga na kulyegha mabumunda ghighapihitwe kwa Chapanga. Jwenio na bhajhake bhakakanikiwe kulye mabumunda gheniya nhwalo mabumunda gheniya ghalilwa na akapiya matambiko tugha. ");
INSERT INTO dne_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Amu bho, nchomite ndeka mukitabo cha Malaghalikilo ngita Lichiko lya Kupomolela akapiya matambiko mu Nyumba jha Chapanga chakaka utwekula malaghalikilo gha Lichiko lya Kupomolela, nambo bhiholelela ndeka ngita bhalemwa. ");
INSERT INTO dne_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bhahe, ninnobholela pamba abhii nkolongwa kuliku Nyumba jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anda umanye mana jha malobhe agha, ‘Nipala kiya na chi litambiko,’ nga mwahadabwii ndeka bhando bhanga ulemwa. ");
INSERT INTO dne_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Peniya Mwana gwa Mundo abhii na Uhotolo panane jha Lichiko lya Kupomolela.” ");
INSERT INTO dne_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yecho akabhokite peniya, akajhahwii munyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mwenio kukibha na mundo jhumo jwatengwike lubhoko. Bhahe, bhando bhakankonyite Yecho, “Bho, ndi mbone kunnamicha mundo Lichiko lya Kupomolela?” Bhankonyita naha bhapaliya ndela jha kuntakalila. ");
INSERT INTO dne_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Nambo Yecho ajhakwalobholela, “Tulonge jhumo gwino abhii na limbelele lyake litumbukii mulibhomba, bho, nalipalaijhe na kunhobhola mulibhomba mu Lichiko lya Kupomolela? ");
INSERT INTO dne_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nambo, mundo abhii nkolongwa kuliku limbelele! Bhahe, ndi mbone kuhenga ghamaha Lichiko lya Kupomolela.” ");
INSERT INTO dne_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Peniya akannobhalile mundo jhola, “Hatambula lubhoko lwino.” Akahatambwile, na lujhakubhehe njelembo ngita longe lola. ");
INSERT INTO dne_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bhahe, Mapwalichayo bhakapitite panja, bhajhakupalaha ndela jha kunkoma Yecho. ");
INSERT INTO dne_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nambo Yecho akamanye lilobhe lyenio, ajhakubhoka peniya. Bhando bhamahele bhajhakunkengama, akalamiche bhibhalwalwa bhoha, ");
INSERT INTO dne_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ajhakwapwatalila bhakotoka kwalobholela bhando malobhe ghake. ");
INSERT INTO dne_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ateila naha ghala ghighalongilwe na Chapanga kwa ndela jha nnondole Isaya ghatimile. ");
INSERT INTO dne_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Dolokeya ntumiche gwango jhunihagwile, jhunimpala na jwandenda hangane hake mumwojho. Naniubheka Uhuke gwango panane jhake, na jwenio nalobholela bhando luhadabulo lwango pannema gwoha. ");
INSERT INTO dne_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nabhaha ndeka na mitaho hilu kuchobhela, hilu lilobhe lyake nalijhokanikika jhe mundela. ");
INSERT INTO dne_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nnahe gwayaghike naudenyuka ndeka, hilu utambe ghuhuka lyoi nauhima ndeka, ade nahenga luhadabulo lwa chakaka. ");
INSERT INTO dne_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bhahe, bhando bhoha bha nnema nabhanhobholela jwenio.” ");
INSERT INTO dne_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Peniya Yecho bhakannetile mundo jhumo jwangalola na akibha ahotwila jhe kulonge nhwalo akibha na nchuka. Yecho akannamiche ngahotwila kulonge na kulola. ");
INSERT INTO dne_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lilongo lyoha lya bhando likakangiche na kulonge, “Bho, pange jhonjo ndi Mwana gwa Daude?” ");
INSERT INTO dne_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nambo Mapwalichayo pibhajhohina gheniya, bhalongila, “Mundo ojho ibhenga nchuka kwa uhotolo gwa Belezebule, nkolo jwa nchuka.” ");
INSERT INTO dne_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yecho akamanye mahola ghabhe, ajhakwalobholela, “Unahota nkolongwa ghoghoha ghola anda upechengine gwene kwa gwene na kubhehe ibhogha ibhogha gwihoto ndeka kujhema, na bhando bha nyumba jhimo na muche ghoghoha amu nyumba jhojhoha chiibhaghanike ibhogha ibhogha jhiipengana, naugwaha. ");
INSERT INTO dne_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Anda Limbembela abhenga michuka jhake, napengelela jwenio. Bhahe Unahota gwake naujhema bho? ");
INSERT INTO dne_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mangota milonge nibhenga nchuka kwa likakala lya Belezebule, bho, bhabholwa bhino bhabhenga kwa likakala lya ghane? Nhwalo bhando bhino mabhene nabhahadabula mangota. ");
INSERT INTO dne_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nambo anda nibhenga nchuka kwa likakala lya Uhuke gwa Chapanga, bhahe, umanye Unahota nkolongwa gwa Chapanga uhikite kwino. ");
INSERT INTO dne_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Amu ihoto bho mundo kujhingii nyumba jha mundo jhuna likakala na kumpoka ilebhe yake, changa ntabha hote mundo jwenio jhuna likakala? Peniya ndi ihoto kumpoka ilebhe yake. ");
INSERT INTO dne_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Mundo jhojhoha jwangalongohana na nenga, jwenio angana nenga, mundo jhojhoha jhola jwangalundika pamonga na nenga, atenda kupechengana. ");
INSERT INTO dne_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nhwalo gwenio, ninobholela, bhando nabhalekekewa uhakaho ghoghoha na maligho ghabhe ghoha, nambo nabhalekekewa ndeka uhakaho gwa kunnigha Uhuke gwa Chapanga ");
INSERT INTO dne_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mundo jhojhoha jwalongela lilobhe lya kunkanila Mwana gwa Mundo jwenio nalekekewa. Nambo mundo jhojhoha jwalongela lilobhe lya kunkanila Uhuke gwa Chapanga, nalekekewa ndeka pannema pano, hilu kwa nnema ghola ghuhika. ");
INSERT INTO dne_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Na nkongo gwamaha upambika uhohe gwamaha, na nkongo gwanganandela upambika uhohe gwanganandela. Nkongo umanyikana kwa uhohe gwake. ");
INSERT INTO dne_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mangota kibheluko cha lijhoka! Mihoto bho kulonge malobhe ghambone na kongo mangota mwanganandela? Mundo ulonge ghala ghughatwelile kumwojho. ");
INSERT INTO dne_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mundo jwa mbone ubhoha malobhe ghambone mu kihukilo cha mwojho gwake, na mundo uhakaho ubhoha malobhe mahakaho kuhumii mu kihukilo cha mwojho gwake. ");
INSERT INTO dne_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Bhahe, ninnobholela, lichiko lya luhadabulo bhando nabhapalwa kujhangula kila lilobhe lyanganandela lyalongila. ");
INSERT INTO dne_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Peniya kwa malobhe ghino nannyeketelwa, na kwa malobhe ghino nauhadabulwa kubhehe na nnemwite jhe.” ");
INSERT INTO dne_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Peniya bhabhola bha Malaghalikilo na Mapwalichayo bhakannobhalile Yecho, “Mmola, tupala kulola ikangacho kuhumii kwino.” ");
INSERT INTO dne_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yecho akajhangwii, “Kibheluko cha bhando cha machiko ghanga chikibhii kibhoho na changannyeketela Chapanga! Mipala ikangacho, napelwa ng'o nambo napelwa ikangacho ya nnondole Yona. ");
INSERT INTO dne_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nhwalo Yona akapipikiye machiko matato muhi na kilo mulutumbo lwa luhomba nkolongwa, na Mwana gwa Mundo natama nkate jha mumambe machiko matato. ");
INSERT INTO dne_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bhando bha ku Ninabhe nabhajhema mulichiko lya luhadabulo, na bhene nabhalongela kibheleko chenje kibhii na ulemwa. Nhwalo bhando bha ku Ninabhe bhakaulekite uhakaho pubhajhohina ghighatangichwa na Yona, na kubhehe peniya abhii nkolongwa kupeta Yona! ");
INSERT INTO dne_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kwa lichiko lya kilongoche mwikeghe, jwahumile ku Cheba, najhema na kwahadabula bhando bha kibheleko chenje bhalemwite, nhwalo jwenio ahumila kutale na kujhenda kujhokanikiya malobhe gha malango gha nkolongwa Chelemane, na pamba abhii munahota nkolongwa kupeta Chelemane. ");
INSERT INTO dne_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nchuka anda abhengitwe kwa mundo, ityangatyanga kunjenga kujhomo ipalaha pa kupomolela anda apakolihi jhe. ");
INSERT INTO dne_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ukilongelela, ‘Nangelebhuka kajha jhango kuhumila.’ Nambo piibhujha na kukolela ndopo, ipyaghilwe na kukilimwa mbone, ");
INSERT INTO dne_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ujhenda kwatola michuka bhange chaba, bhanganandela kuliku jwenio, bhoha uhika na kunnyingii mundo jwenio. Na mundo jwenio ubhehe jwanganandela kuliku chakibha makacho. Ndi naibhaha kwa bhando bhamba bhanganandela.” ");
INSERT INTO dne_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yecho pajhendilila kulonge na lilongo lya bhando majhe na akalongo bhake bhakahikite na kujhema panja, bhipala kulonge na jwenio. ");
INSERT INTO dne_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bhahe, mundo jhumo ajhakunnobholela, “Majhe gwino na akalongo bhino bhabhii panja, bhipala kulonge na mwenga.” ");
INSERT INTO dne_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Nambo Yecho akannyangwii mundo jwenio, “Majhe gwango ndi ghane? Na akalongo bhango ndi akina ghane?” ");
INSERT INTO dne_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Peniya akahatambwii lubhoko lwake kwa bhabholwa bhake, alongila, “Bhamba ndi majhe gwango na akalongo bhango! ");
INSERT INTO dne_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Peniya mundo jhojhoha jwahenga lyalipala Tate gwango jwabhii kunane kwa Chapanga, jwenio ndi nnongo gwango na nnombo gwango na majhe gwango.” ");
INSERT INTO dne_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lichiko lelelalela, Yecho akapitite munyumba jhela, akajhahwii kutama paupele jha lilabha. ");
INSERT INTO dne_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ibhogha ikolongwa ya bhando ijhakuntindila peniya Yecho ajhakukwela mungalabha, jhakatamite. Bhando bhoha bhajhakujhema muupele jha lilabha, ");
INSERT INTO dne_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yecho ajhakwabhola na kwalobholela mambu ghamahele kwa nnandanikiho. “Unyokanikiye! Mundo jhumo akajhahwii kumicha mbejho. ");
INSERT INTO dne_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pamichita mbejho, mbejho henge ikahikii pandela, ijhune ijhakuhika na kuhonyola. ");
INSERT INTO dne_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Henge ikaponi mu ekendo undope ukibha ndeka gwamahele. Ijhakumela kajhombe kwa nhwalo undope ukibha ndeka gwamahele. ");
INSERT INTO dne_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lyobha lijhakubhala, ijhakutinika, kwa nhwalo mikegha jhake ikajhabhulile jhe pahe, mbejho yela ijhakulelebhala. ");
INSERT INTO dne_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Henge ikaponikiye mumikongo jha mibha, ikakolitejhe nhwalo ikahindamine mbejho ikapambike jhe. ");
INSERT INTO dne_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Henge ikaponikihe mu undope ghubholile, mbejho ijhakumela na kupambika. Henge ipambika mbejho makome kome, henge makome chita na henge makome matato. ");
INSERT INTO dne_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Jwabhii na machikilo gha kujhoha na ajhohe!” ");
INSERT INTO dne_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bhabholwa bhake bhakanyendile Yecho na kunkonya, “Nhwalo ghane milonge na bhando kwa milandanikiho?” ");
INSERT INTO dne_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yecho ajhakwalobholela, “Mangota mpatite kumanya chile jha Unahota gwa kunane kwa Chapanga, nambo bheniya bhayekulilwe ndeka. ");
INSERT INTO dne_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Peniya, jwabhii na kilebhe napelwa nachochokewa, nambo jhola jwangakola kilebhe, hilu chela chabhii nacho napokwa. ");
INSERT INTO dne_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ndi nhwalo nilonge nabho kwa milandanikiho, nhwalo bhilolekeya nambo bhilola ndeka, bhijhokanikiya nambo bhijhoha ndeka, hilu bhibangatuka ndeka. ");
INSERT INTO dne_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kwa bhene ghatimile ghighalongilwa na nnondole Isaya. ‘Kujhoha nabhajhoha, nambo nabhabangatuka ndeka. Kulola nanlola, nambo nannoli ndeka. ");
INSERT INTO dne_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Peniya malango gha bhando abhabha ghahubhite, bhahibhite machikilo ghabhe, bhadindite miho ghabhe. Anda nahijhe, ngabhalolite kwa miho ghabhe, ngabhajhohine kwa machikilo ghabhe, ngabhamanyite kwa malango ghabhe, na kung'alambukila, nenga, nganalamiche.’ ");
INSERT INTO dne_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nambo mina mota mangota, nhwalo miho ghino ghilola na machikilo ghino ghijhoha. ");
INSERT INTO dne_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ninnobholela chakaka, milondole twe na bhando bha Chapanga twe bhakapahile kughabhona ghala ghumujhokanikiya, bhakaghawene ndeka, na kughajhokanikiya ghala ghunyokonikihe, nambo bhakajhohine ndeka. ");
INSERT INTO dne_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Bhahe, mangota nnyokanikiye na kukibhola kwa nnandanikiho ogho gwa mmicha mbejho. ");
INSERT INTO dne_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bhando bhubhajhokanikiya malobhe gha Unahota gwa Chapanga changamanya, ngita mbejho ikaponii mundela, Jwanganandela uhika na kutola chela chikimichitwe kumiojho gwabhe. ");
INSERT INTO dne_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mbejho hela iponi mukihekendo, nnandanikiho gwa mundo jwalijhoha lilobhe na kulipokela kwa kuhangana. ");
INSERT INTO dne_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nambo nhwalo akwete jhe mikegha lilobhe lijhingii jhe mumwojho na ulikamulila pandina tugha, patendelwa ghanganandela kwa kung'ahika kwa nhwalo gwa lilobhe lyenio, papa peniya ulileka kulihobholela. ");
INSERT INTO dne_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mbejho hela ikaponikiye pakate jha mikongo jha mibha, nnandanikiho gwa mundo jhulijhoha lilobhe lyenio, nambo kiholo cha ughome gwito na kupala kubhehe na ilebhe mbwee, ulipopoteka lilobhe lyenio, na mundo uhenga jhe ghaghapala Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mbejho hela iponi mu undope ghubholile nnandanikiho gwa mundo jhulijhoha lilobhe na kupambika uhohe, jhumo makome kome, jhonge makome chita na jhonge matato.” ");
INSERT INTO dne_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yecho ajhakwalobholela bhando nnandanikiho ghonge, “Unahota gwa kunane kwa Chapanga ulandine na mundo jwamichite mbejho jha mbone mughonda gwake. ");
INSERT INTO dne_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nambo bhando bhakibha bhagholwike, makoko bhake bhajhakuhika, ajhakumicha mbejho ya manyahe ilandana ngita ngano pakate jha ngano, na kubhoka. ");
INSERT INTO dne_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Bhahe, mbejho ikamelite na kutumbuu kubheka njechele, manyahe ghajhakutumbuu kubhonekana. ");
INSERT INTO dne_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Akatumiche bha nkolo nghonda bhakannyendilile, bhajhakunnobholela, ‘Munahota, chi ukamichite mbejho yambone mung'onda gwino. Ngohe manyahe ghahumii kojhe?’ ");
INSERT INTO dne_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jwenio akajhangwii, ‘Akamakoko atendite naha.’ Bhahe, akahenga mahengo bhajhakunkonya, ‘Bho, mipala tujhende tukatupule?’ ");
INSERT INTO dne_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Jwenio akajhangwii, ‘Nahijhe, pumutupula manyahe, mutupu na ngano. ");
INSERT INTO dne_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ghaleka ghakole pamonga ade muda gwa mahuno. Muda gwenio nanalobholela bhibhihuna. Tupula hote manyahe mughatabhe ibhogha ibhogha ya kujhochwa mwotu. Nambo nhunangane ngano mukabheke mukikoko.’ ” ");
INSERT INTO dne_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yecho ajhakwalobholela bhando nnandanikiho ghonge, “Unahota gwa kunane kwa Chapanga ulandine na mbejho ya aladale yatoii mundo jhumo, akamichite kunghonda gwake. ");
INSERT INTO dne_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yene njokombe kuliku mbejho yoha, nambo anda imelite ubhehe mikolonga kuliku mbejho yoha, ukola na kubhehe nkongo, peniya ijhune ya kunane uhika na kuchenga mihuhe mu mandabhe ghake.” ");
INSERT INTO dne_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yecho akabhalobhalile nnandanikiho ghonge, “Unahota gwa kunane kwa Chapanga ulandine na ngedule yakatoii majhe jhumo, akahangaline na ukobha mikambo mibhele na nucho, ukobha ghoha ujhakututa.” ");
INSERT INTO dne_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yecho akabhalobhalii bhando gheniya ghoha kwa milandanikiho jhamahena. Akabhalobhalii ndeka chochoha changa longe kwa milandanikiho. ");
INSERT INTO dne_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Akatei naha, lilobhe lilongilwa na nnondole litimile, “Nanongela nabho kwa milandanikiho, naninnobholela mambu kuhumii mukupanganwa kwa nnema.” ");
INSERT INTO dne_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yecho ajhakwatabhuka bhando bhala, akajhingii munyumba. Bhabholwa bhake bhakanyendelile, bhakannobhalile, “Mutulongelele nnandanikiho gwa manyahe gha munng'onda.” ");
INSERT INTO dne_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yecho ajhakwalobholela, “Mmicha mbejho jha mbone ndi Mwana gwa Mundo. ");
INSERT INTO dne_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nghonda ghola ndi nnema. Mbejho yela yambone ndi bhando bhala Unahota ndi gwabhe. Nambo maghogho ghala ndi bhando bha Limbembela. ");
INSERT INTO dne_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Likoko jwamichita manyahe ndi Limbembela. Mahuno ndi pala nnema puupala kupehekeya, bhibhahuna ndi akatumiche bha kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ngita chibhajhola manyahe na kujhocha pamwotu, na ibhaha ndi pala puupala kuupehekeya nnema, ");
INSERT INTO dne_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mwana gwa Mundo nabhatuma akatumiche bha kunane kwa Chapanga makaponge kuhumii mu Unahota gwake bhala bhoha bhibhatenda bhando bhahenge uhakaho, na bhoha bhibhahenga uhakaho, ");
INSERT INTO dne_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","kwataghila mu litanule lya mwotu lipela, na kwenio nakubhaha kulela na kuyagha mino. ");
INSERT INTO dne_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Peniya bhando bha Chapanga nabhang'anyima ngita lyobha mu Unahota gwa Tate gwabhe. Jhuna machikilo na ajhohe! ");
INSERT INTO dne_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Unahota gwa kunane kwa Chapanga ulandine na kihukilo cha ilebhe ichuluchwa kwa mbijha yamahele ihihitwe kunng'onda. Mundo jhumo akaiwene, ajhakuhiya kabhele. Akahangine hake ajhakujhenda kuchulucha yoha yakibha nako, akahemele nng'onda ghola. ");
INSERT INTO dne_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Peniya, Unahota gwa kunane kwa Chapanga uwanine na jwachulucha ilebhe jwapalaha lulo jha mbone hake. ");
INSERT INTO dne_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Peniya papatita lulo jhimo halanao hake, akajhahwii, akachulwiche yoha jwakibha nayo, ahemelele lulo jhene. ");
INSERT INTO dne_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Helahela, Unahota gwa kunane kwa Chapanga ulandine na lwaho lutaghitwe mulilabha, na kujhonja homba kila namuna. ");
INSERT INTO dne_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lwaho lujhakutwelela, bhibhahutita lwaho kulilabha, bhakatamite, bhakahagwile homba yamaha bhakabhekite mu itandabhala yabhe, na yanganandela bhajhakutagha. ");
INSERT INTO dne_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ndi naibhaha pala pupala kupehekeya kwa nnema. Akatumiche bha kunane kwa Chapanga nabhajhenda, nabhataghila paupile bhando bhaghanandela na kwabheka paupele bhando bhambone, ");
INSERT INTO dne_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","na kwataghila bheniya bhanganandela mu litanule lya mu mwotu lipela. Kwenio nabhalela na kuyagha mino.” ");
INSERT INTO dne_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yecho ajhakwakonya, “Bho, umanyite mambu agha ghoha?” Bhakannyangwii, “Chakaka.” ");
INSERT INTO dne_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jwenio ajhakwalobholela, “Mmola jwa lilaghalikilo jwabhii mmolwa gwa Unahota gwa kunane kwa Chapanga, ihwanana na nkolo nyumba jwaibhoha mu kihukilo chake ilebhe iyono na ilebhe ya makacho.” ");
INSERT INTO dne_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yecho pajhomolila kulonge milandanikiho jhene ajhakubhoka peniya, ");
INSERT INTO dne_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ajhakukelebhuka ku muche gwake. Kwenio akibha abholita bhando munyumba jha kukonganikii Akayahude. Bhando bhubhajhohina bhakakangiche na bhakalongii, “Bho, mundo jhonjo apatite kojhe malango ghanga na ikangacho yenio? ");
INSERT INTO dne_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bho, ojho chi mwana gwa mmacha mikongo? Bho, majhe mundo chi ikemwa Maliya, na akalongo mundo chi Yakobu na Uchupo na Simone na Yuda? ");
INSERT INTO dne_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Akalombo mundo bho, chi bhoha bhabhii pamba pamonga na twenga? Bhahe, apatite kojhe agha ghoha?” ");
INSERT INTO dne_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bhahe, bhajhakunkanila. Nambo Yecho akalobholii, “Nnondole ajheketelwa koha, nambo ilendemwa ndeka ku kilambo chake, na ukajhake!” ");
INSERT INTO dne_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kwa nhwalo bhakibha jhe na kihobholelo, Yecho akatei jhe ikangacho twe peniya. ");
INSERT INTO dne_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Machiko gheniya, Helode jwakibha kilongoche jwa ku Galilaya akajhohine malobhe gha Yecho. ");
INSERT INTO dne_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Bhahe, ajhakwalobholela akatumiche bhake, “Mundo ojho ndi Yohane Mbatichajhe, ayokite kuhumii kubhawile, ndi mana likakala lya ikangacho lihenga lihengo nkate jhake.” ");
INSERT INTO dne_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Helode ndi akibha ankamwii Yohane akankongite minyololo na kummeka mukipungo kwa nhwalo gwa Helodiya, unhwana gwa Filipu, nnongo mundo ");
INSERT INTO dne_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nhwalo gwa kukamulwa kwa Yohane Mbatichajhe akibha annobholile Helode, “Chi mbone kutama na mwikeghe jwenio!” ");
INSERT INTO dne_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Helode akapahi kunkoma Yohane, nambo akajhogwipe bhando nhwalo bhakajheketile Yohane ndi nnondole gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nambo mu machiko gha kubhelukwa Helode, nchikana jwa Helodiya ajhakukina palonge jha akaghene. Helode ajhakuhanganila hake. ");
INSERT INTO dne_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ade akalaghine kwa kulapanikiya kumpela nchikana chochoha chapala. ");
INSERT INTO dne_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na jwenio kwa kunyokanikiya majhe mundo, ajhakujhopa, “Mbela pambano pano muto gwa Yohane Mbatichajhe mukipalo.” ");
INSERT INTO dne_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Munahota nkolongwa Helode ajhakubhehe ngolongondi hake, nambo nhwalo gwa kilapo chake palonge jha akaghene, akalongile nampela. ");
INSERT INTO dne_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bhahe, Helode akantumite mundo mukipungo kunheketa muto gwa Yohane. ");
INSERT INTO dne_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Muto gwake ukaletitwe mukipalo, bhakampekihe nchikana jhola, na jwenio akampelikile majhe mundo. ");
INSERT INTO dne_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bhabholwa bha Yohane bhakahikite, bhajhakutola yegha jhake, bhakajhahwii bhajhakuchika umambe. Peniya bhakajhahwii kunnobholela Yecho. ");
INSERT INTO dne_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yecho papatita lilobhe lyenio, ajhakubhoka peniya kwa ngalabha, ajhakujhenda panga bhando. Nambo bhando bhakapatite malobhe, bhajhakunkengama kwa magholo kuhumii mumiche yabhe. ");
INSERT INTO dne_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bhahe, Yecho pahulwika kumbwane, ajhakubhona lilongo likolongwa lya bhando, lijhakwabhone kiya, ajhakwalamicha bhibhalwalwa. ");
INSERT INTO dne_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Pukihikita kimiye, bhabholwa bhake bhajhakunnobholela Yecho, “Pambano tubhii panjenga, lichaa lya muhe lipetite. Bhahe, mwatabhuke bhando bhajhende muchenda bhakahemele yakulyegha.” ");
INSERT INTO dne_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yecho ajhakwalobholela, “Bho, nhwalo gwa nike bhajhende? Mwapele mangota yakulyegha.” ");
INSERT INTO dne_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nambo, bhene bhakannobhalile, “Tukwete mabumunda nhwano tugha na homba ibhena.” ");
INSERT INTO dne_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yecho ajhakwalobholela, “Unetele pamba.” ");
INSERT INTO dne_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ajhakwalobholela bhando bhatame mu manyahe. Peniya Yecho akatoi mabumunda ghala nhwano na homba ibhele, ajhakulola kunane kwa Chapanga, ajhakunchenguu Chapanga. Peniya ajhakumetula na kwabhaghanichila mabumunda gheniya, akapekii bhabholwa bhake, na bhene bhakapekii bhando. ");
INSERT INTO dne_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bhando bhoha bhakalile, na kujhukuta. Peniya, bhabholwa bhajhakujhola mahighiliko, bhakatwelii ichukilo kome na ibhele. ");
INSERT INTO dne_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bhando bhubhakalile bhakibha akanalome elufo nhwano changabhalangila akakeghe na yana. ");
INSERT INTO dne_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Peniya, ajhakwalobholela bhabholwa bhake bhajhingile mungalabha, bhalongolele kwiye jha lilabha, jwenio akibha atabhuka ibhogha ya bhando. ");
INSERT INTO dne_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pajhomolila kwatabhuka bhando, ajhakuhobhoka ku kitombe kanjika chake kunnyopa Chapanga. Pukihikita kimiye, jwenio akibha kwenio kanjika chake, ");
INSERT INTO dne_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","peniya ngalabha jhela ikibha pakate jha lilabha na upepo nkolongwa uteila kuinyuanyua. ");
INSERT INTO dne_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Pukubhandikila kuchegha, Yecho ajhakujhenda kwa bhabholwa bhake kongo ityanga panane jha mache. ");
INSERT INTO dne_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bhabholwa bhake pibhanolikiya panane jha mache bhajhakujhoghopa hake, bhalongila “Ndi lihoka!” Bhajhakuchobhela kwa bhoghohe. ");
INSERT INTO dne_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Peniya, Yecho akalongi nabho, “Tama nuu, ndi nenga. Nkotoka kujhoghopa!” ");
INSERT INTO dne_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petile ajhakunnobholela, “Bhambo, chakaka anda mwenga, dongela ndyange panane jha mache hike kwino.” ");
INSERT INTO dne_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yecho akalongii, “Chakaka, uhike.” Bhahe, Petile akahulwike kuhumii mungalabha, akatyangite panane jha mache, kunkengama Yecho. ");
INSERT INTO dne_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nambo pabhonita kimbonga chela, akajhogwipe, ajhakutumbula kumilwa, ajhakunonoha lilobhe, “Bhambo, ung'ombole!” ");
INSERT INTO dne_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Peniya, Yecho akahatambwile lubhoko lwake na kunkamuu na kunnobholela, “Mwenga mmii na kihobholelo chandina! Nhwalo ghane mmii na kiholo?” ");
INSERT INTO dne_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Peniya bhajhakuhobhokela mungalabha, na pajhakubhehe njelembo. ");
INSERT INTO dne_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bhoha bhubhakibha nkate jha ngalabha bhakannyinamile, bhalongila, “Chakaka mwenga ndi ma mwana bha Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bhajhakujhomboka lilabha, bhajhakuhika ku kilambo cha ku Genechalete. ");
INSERT INTO dne_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bhando bha kwenio pibhakammanye, bhakapechengine malobhe imbokotole yoha muchenda jhene. Bhahe, bhakannetile Yecho bhibhalwalwa bhoha, ");
INSERT INTO dne_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","bhajhakumpembelekeya abhalekekehe bhibhalwalwa kwa kwapapaha tugha lilombolo lya ngobho jhake. Bhoha bhibhakampapiye bhakalamite. ");
INSERT INTO dne_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Peniya Mapwalichayo na bhabhola bha Malaghalikilo kubhoke ku Yeluchalemo bhajhakunnyendelela Yecho na kunkonya, ");
INSERT INTO dne_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bho, nhwalo gwa nike bhabholwa bhino bhaghakengama ndeka malaghalikilo ghutupokii kuhumii kwa akahoko bhito? Bhakuha jhe mabhoko chipalwa kabula jha kulyegha!” ");
INSERT INTO dne_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yecho ajhakwakonya, “Bho, mangota nhwalo gwa nike mughajhokanikiya jhe malaghalikilo gha Chapanga na mikengama mabholo ghino mabhene? ");
INSERT INTO dne_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Chapanga akalongii, ‘Majhokanikiye tate gwino na majhe gwino,’ na ‘Na jwanigha tate mundo amu majhe mundo, nabhankoma.’ ");
INSERT INTO dne_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nambo mangota mibhola, anda mundo akwete kilebhe chikihoto kuntangatila tate mundo amu majhe mundo, nambo alongela, ‘Kilebhe chenje nikipiya kwa Chapanga,’ ");
INSERT INTO dne_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","bhahe, ndi ipalwa ndeka kabhele kuntangatila tate mundo kwa kilebhe chenie. Naha ndi chimulipucha lilobhe lya Chapanga kwa kukengama mabholo ghino mabhene. ");
INSERT INTO dne_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mangota mukitenda bhando bhaumbone! Ghalongila Isaya akalondwi mangota ngita chajhandike, ‘Bhando bhamba bhajhekete kwa milomo jhabhe tu, nambo miojho jhabhe ibhii kutale na nenga!’ ");
INSERT INTO dne_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Isaya akalondwi mangota ngita chajhandike, ‘Bhando bhamba bhajhekete kwa milomo jhabhe tu, nambo miojho jhabhe ibhii kutale na nenga. ");
INSERT INTO dne_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kunyinamila kwabhe ndi kwa jhajhe, nhwalo bhabhola mabholo gha bhando ngita ndi malaghalikilo ghango!’ ” ");
INSERT INTO dne_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bhahe, Yecho akalikemite kabhele lilongo lya bhando ajhakwalobholela, “Unyokanikiye na umanye kwa malobhe ghunipala kunnobholela! ");
INSERT INTO dne_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kilebhe chikinyingii munnomo mundo kihoto jhe kuntenda mundo akoto kujheketelwa palonge jha Chapanga. Nambo chela chikimpita pannomo gwake ndi chikintenda akoto kujheketelwa palonge jha Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Peniya bhabholwa bhake bhajhakunyendelela Yecho na kunkonya, “Bho, umanyite Mapwalichayo bhahyomita kwa nhwalo gwa malobhe ghenagha?” ");
INSERT INTO dne_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nambo Yecho ajhakwajhanguu, “Kila changamichwa na Tate gwango jwa kunane kwa Chapanga, nakitupulilwa.” ");
INSERT INTO dne_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Mwaleke! Bhene bhangalola na ilongoche yangalola. Na jwangalola antandaha jwangalola nnyake, bhoha nabhatumbukila mulibhomba.” ");
INSERT INTO dne_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peniya Petile ajhakulonge, “Mutulobholele mana jha nnandanikiho ghongo.” ");
INSERT INTO dne_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yecho ajhakwakonya, “Bho, na mangota helahela mwamela umanyingine ndeka ghangano? ");
INSERT INTO dne_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Umanyingine ndeka kubhehe kilebhe chalyegha mundo kupete pannomo ujhenda kulutumbo na kujhenda ku cholo? ");
INSERT INTO dne_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nambo mambu ghighapita munomo ghahuma kumwojho, na yenio ndi ghintenda mundo akoto kujheketelwa palonge jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nhwalo nkate jha mwojho gwa mundo upita mawacho mabhoho gha kukoma na ngongola malobhe gha kupala kutenda ngongola na mwihe na kulonge uwange na maligho. ");
INSERT INTO dne_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ilebhe yenio ndi intenda mundo akoto kujheketelwa palonge jha Chapanga. Nambo kulyegha changakuha mache mu mabhoko kuhoto jhe kuntenda mundo akanwe palonge jha Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bhahe, Yecho ajhakubhoka peniya na kujhenda ku kilambo chuku Tilo na ku Sidone kutama. ");
INSERT INTO dne_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Peniya majhe jhumo Nkanane jwa ku kilambo chenie ajhakunnyendelela Yecho kongo nganonwiya lilobhe, “Bhambo, Mwana gwa Daude ungolele kiya, nchikana gwango ang'ahika na nchuka!” ");
INSERT INTO dne_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Nambo Yecho akajhangwi jhe lilobhe. Bhahe, bhabholwa bhake bhajhakunyendelela Yecho na kunnobholela, “Munnobholele abhoke nhwalo atenda kutukengamila kengamila kongo atenda kuchobhela.” ");
INSERT INTO dne_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yecho ajhakwalobholela, “Ndumitwe tugha kwa bhando bha kilambo chuku Ichilahele, bhubhabhii ngita mambelele ghighahobhalile.” ");
INSERT INTO dne_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nambo majhe jhola ajhakutama makilikite palonge jhake Yecho na kunnobholela, “Bhambo, undangatile!” ");
INSERT INTO dne_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yecho ajhakunyanguu, “Yamaha ndeka kutola chakulya chibhalye yana na kukitaghii ghimbwa.” ");
INSERT INTO dne_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Majhe jhola ajhakulonge, “Chakaka Bhambo, gheniya ghumulongela gha chakaka. Nambo ghimbwa ilyegha imbolopolo igwegha kuhe pa mecha ya nkolo gwabhe.” ");
INSERT INTO dne_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Peniya Yecho ajhakujhanguu, “Mwe majhe, kihobholelo chino kikolonga. Itendeka kwino ngita chinyopite.” Nchikana jwake ajhakubhehe njelembo chaa jhejhe. ");
INSERT INTO dne_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Bhahe, Yecho ajhakubhoka peniya na kujhenda mupele jha lilabha lya ku Galilaya, na kukwela pakitombe na kutama pahe. ");
INSERT INTO dne_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Peniya lilongo lya bhando lijhakunyendelela, bhakampelikile bhando bhangalongela na bhibhalemile na bhangalola na bhilemi yegha na bhando twe bhubhabhii na ulwalo. Bhajhakumekela palonge jha magholo ghake, na jwenio Yecho ajhakwalamicha. ");
INSERT INTO dne_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bhahe, lilongo lela lya bhando lijhakukangacha pubhalolita mundo jwangalongela atenda kulonge na bhubhalemile bhabhe njelembo na bhangalola na bhene bhalola. Na bhene bhajhakunnomba Chapanga jwa bha Ichilahele. ");
INSERT INTO dne_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Peniya Yecho ajhakwakema bhabholwa bhake na ajhakwalobholela, “Nakole kiya bhando bheniya, hena, bhatamite na nenga kwa machiko matato changalyegha. Nipala jhe bhabhoke changalyegha, bhihoto kuhindukii undela kujhenda ukajhabhe.” ");
INSERT INTO dne_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bhabholwa bhake bhajhakunkonya, “Tubhii palundwanga pamba, bho, ghane natupela chakulyegha cha kukwela lilongo lene?” ");
INSERT INTO dne_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yecho ajhakwakonya, “Bho, nkwete mabumunda malenga?” Bhene bhajhakujhanguu. “Ghabhii mabumunda chaba na homba yandina njokonjoko.” ");
INSERT INTO dne_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Bhahe, Yecho ajhakwalobholela, mwatamike bhando pahe. ");
INSERT INTO dne_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Peniya Yecho ajhakutola mabumunda ghala na homba njokonjoko hela, ajhakunchenguu Chapanga, ajhakumetula na kwapekeya bhabholwa bhake bhaghabhanichile bhando bhala. ");
INSERT INTO dne_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bhoha bhakalile na kujhukuta. Peniya, bhabholwa bhajhakujhola mahighiliko, bhajhakutweleya ichukilo chaba. ");
INSERT INTO dne_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bheniya bhubhalila bhakibha akanalome elufo ncheche, changabhalangila akakeghe na yana. ");
INSERT INTO dne_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bhahe, Yecho ajhakwatabhuka bhando na ajhakujhingii mungalabha kujhenda ku kilambo chuku Magidane. ");
INSERT INTO dne_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bhahe, Mapwalichayo na Machadukayo bhajhakunyendelela Yecho, kwa bhajhakunnyigha bhapata nginyililo kuhumii kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nambo Yecho ajhakwajhanguu, “Pulitipika lyobha mangota mulonge, ‘Deleno nakubhaha kwa mbone nhwalo mahunde ndi makele.’ ");
INSERT INTO dne_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lukela mulonge, ‘Nahikoma hula nhwalo kumahunde kubhii pyuu na kabhele mahunde ghabhii tyoo!’ Bhahe, mangota umanyite hake kulolekeya chula jha kunane na kumanya ghighapala kupitila. Nambo umanyite jhe ikangacho ya machiko ghanga. ");
INSERT INTO dne_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Bhando bha kibheluko changanandela na changaumanya Chapanga, kipala kulola nginyililo? Nambo nakilangiwa ndeka nginyililo! Nga jhela jha nnondole jwa Chapanga Yona.” Bhahe, bhajhakunneka akijhendele. ");
INSERT INTO dne_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Peniya bhabholwa bhake pajhombwika kwiye jha lilabha, bhajhakujhehwa kughegha mabumunda. ");
INSERT INTO dne_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yecho ajhakwalobholela, “Mukilolekehe na ngedule ya Mapwalichayo na Machadukayo!” ");
INSERT INTO dne_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bhabholwa bhake bhajhakutumbula kukonyana bhene chika, “Alongila naha nhwalo tujhewite kughegha mabumunda.” ");
INSERT INTO dne_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Bhahe, Yecho akamanyite chibhaholela, ajhakwalobholela, “Mangota bhumii na kihobholelo chandina, nhwalo ghane bhikonyana pakate jhino nhwalo gwa kupelulwa mabumunda? ");
INSERT INTO dne_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bho, mwamela munabangatuka ndeka? Bho, nnyehwite pimaghanicha mabumunda nhwano ghala na kwalicha bhando elufo nhwano? Bho, mahighililo ghake ghakatwelile ichukilo ilenga? ");
INSERT INTO dne_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amu mabumunda chaba ghala ghikabhaghulilwe bhando elufo ncheche, bho, mukatweli ichukilo ilegha ya mahighiliko? ");
INSERT INTO dne_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Bho, nhwalo ghane mibangatuka ndeka, ninongelela jhe mangota malobhe gha mabumunda, nambo ninnobholela mukilolekeye na ngedule ya Mapwalichayo na Machadukayo!” ");
INSERT INTO dne_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bhahe, bhabholwa bhala bhajhakubangatuka abhalobholila bhakilolekehe chi na ngedule jha mabumunda, nambo mabholo gha Mapwalichayo na Machadukayo. ");
INSERT INTO dne_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yecho pahikita ku muche gwa ku Kaisaliya jha ku Filipu, ajhakwakonya bhabholwa bhake, “Bho, bhando bhinkema bhole Mwana gwa Mundo?” ");
INSERT INTO dne_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bhene bhajhakujhanguu, “Bhando bhange bhinkema mwa Yohane Mbatichajhe na bhange bhinkema manondole bha Chapanga Eliya na bhange bhinkema jhumo jwa nnondole jwa Chapanga Yelemiya.” ");
INSERT INTO dne_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yecho ajhakwakonya bhabholwa bhake, “Bho, mangota ungema nenga naghane?” ");
INSERT INTO dne_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simone Petile ajhakujhanguu, “Mwenga ndi Kilichitu Nkomboche, Mwana gwa Chapanga jhumii ghome.” ");
INSERT INTO dne_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bhahe, Yecho ajhakulonge, “Mina mota mwa Simone mwana gwa Yohane, nhwalo abhii jhe mundo jwanobholile lilobhe lende, nambo nga Tate gwango jwabhii kunane. ");
INSERT INTO dne_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na nenga ngoheno ninobholela, mwe ma Petile, mwenga malindalabho, na panane jha lindalabho lyenio nanjenga nyumba jha bhando bhibhanyeketela nenga, hilu likakala lya kuwegha nalihotola ndeka kulilepele. ");
INSERT INTO dne_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nikamuha pungulo ya Unahota gwa kunane kwa Chapanga, kilebhe chochoha chimipala kukikanikiya pannema, helahela nakikanikiwa kunane kwa Chapanga. Na kilebhe chochoha chikipalwa kujhogholelwa pannema, helahela nakijhogholelwa kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bhahe, Yecho ajhakwahibhilikiya bhabholwa bhake bhakotoka kunnobholela mundo jhonge kubhehe jwenio ndi Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","“Kuhumii peniya Yecho ajhakutumbu kwalobholela hotuhotu bhabholwa bhake ipala ajhende ku Yeluchalemo, na kwenio naghambambalakana mang'ahe ghamahele kuhumii kwa ighogholo na Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo. Nabhankoma, na machiko matato anda ghahikite peniya nayoka.” ");
INSERT INTO dne_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petile ajhakuntola Yecho paupele na kutumbuu kunpwatalila annobholila, “Bhambo, nkoto kulonge naha, mambu gheniya naghampambalaka ndeka!” ");
INSERT INTO dne_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nambo Yecho ajhakunghalambukila Petile na kunnobholela, “Mmoke palonge jhango, mwenga ma Limbembela! Mwenga kilebhe chikinhibhikiya nenga, nhwalo miwacha ndeka gha Chapanga, nambo miwacha kimundo.” ");
INSERT INTO dne_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Peniya Yecho ajhakwalobholela bhabholwa bhake, “Anda mundo jhojhoha jwapala kubhehe na nenga, akihila hote jwenio, na atole nchalaba gwake angengame. ");
INSERT INTO dne_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nhwalo mundo jwapala kuughombola ughome gwake, nauhobhecha, nambo mundo jhola jwapala kuhobhecha ughome kwa nhwalo gwa nenga, naukombola kabhele. ");
INSERT INTO dne_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bho, najhambulila nike mundo kubhehe na ilebhe mbwee ya pannema pano, nambo kongo ughome gwino uhobhalele? Nhwalo kibhiijhe kilebhe chahoto kupiya mundo kwa kuukombola ughome gwake. ");
INSERT INTO dne_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nhwalo Mwana gwa Mundo pabhandikila kuhika muukolo gwa Tate gwango pamonga na akatumiche bhake bha kunane kwa Chapanga na kunepa kila mundo ghala ghatehila. ");
INSERT INTO dne_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ninnobholela chakaka, bhabhii bhando bhange pambano pano nabhawejhe kabula jha kumona Mwana gwa Mundo akahika abhii mu Nahota nkolongwa.” ");
INSERT INTO dne_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pighapetita machiko chita, Yecho ajhakwatola Petile na Yakobu na Yohane unung'una mundo, bhajhakuhobhoka ade panane jha kitombe kitandamaho na kwenio bhakibha kanjika chabhe, ");
INSERT INTO dne_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","na kwenio Yecho ajhakughalambuka ubhonekano pamiho palonge jhabhe, ajhakung'anyima mbumbumbu, na ngobho yake ing'anyima ngita lumule. ");
INSERT INTO dne_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Peniya bhabholwa bhatato bhala bhajhakummona Mucha na Eliya bhakilongila na Yecho. ");
INSERT INTO dne_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bhahe, Petile ajhakunnobholela Yecho, “Bhambo, nibhona pambano pambone hake kutama twenga! Anda mipala nanjenga ichimba itato, chimo chino, chimo cha Mucha na chimo cha Eliya.” ");
INSERT INTO dne_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petile pajhendilila kulonge, dola lihunde lihuo lya mbumbumbu lijhakwayekelela, na lilobhe lijhakujhokanikika kuhumii kulihunde lyenio lilongila, “Jhonjo ndi Mwanango jhunimpahile jwatenda ghunipala, munyokanikiye!” ");
INSERT INTO dne_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bhabholwa pubhajhohina lilobhe lyenio, bhajhakubhehe na bhoghohe hake, na bhajhakugwegha na kuhikila mangukama. ");
INSERT INTO dne_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nambo Yecho ajhakwaheghelela, ajhakwapapaha na kwalobholela, “Jhemangana, nkotokujhoghopa!” ");
INSERT INTO dne_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pibhananwila miho ghabhe bhakamwene ndeka mundo jhonge, nambo nga Yecho kanjika chake. ");
INSERT INTO dne_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bhahe, pibhahelila kukitombe, Yecho ajhakwakanakiya, “Bhakotoka kunnobholela mundo jhojhoha ghamughahwene ade Mwana gwa Mundo papala kuyokechwa kuhumii mukuwegha.” ");
INSERT INTO dne_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Peniya bhabholwa bhake bhajhakunkonya, “Nhwalo gwa nike bhabhola bha Malaghalikilo bhilonge, nalongolela Eliya hote kuhika?” ");
INSERT INTO dne_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yecho ajhakwajhanguu, “Chakaka Eliya nalongolela kuhika, kulenganikiya ilebhe yoha. ");
INSERT INTO dne_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nambo ninnobholela mangota, Eliya ahikite njwe, bhando bhahumanyite ndeka nambo bhajhakuntendela ghoha ghubhaghapalita. Helahela Mwana gwa Mundo nang'ahika mu mabhoko ghabhe.” ");
INSERT INTO dne_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bhahe, peniya bhabholwa bhala bhajhakukomboka abhalongolila malobhe gha Yohane Mbatichajhe. ");
INSERT INTO dne_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yecho na bhabholwa bhake bhajhakuliheghelela lilongo lya bhando, mundo jhumo ajhakunheghelela Yecho na kutama makilikite palonge jhake, ");
INSERT INTO dne_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ajhakulonge, “Bhambo, mukolele kiya mwanango alagha na ulwalo gwa kihinduhindu. Kila pukihika kihinduhindu ugwelela pakihinja amu umache. ");
INSERT INTO dne_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nikaletii bhabholwa bhino nambo bhakahotwi ndeka kunnamicha.” ");
INSERT INTO dne_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yecho ajhakwajhanguu, “Mangota kibheleko changabhehe na kihobholelo na chikihobhalile! Bho, nandama na mangota ade ligha? Bho nanihimbilila mangota ade ligha? Munnete pamba kangombo jwenio.” ");
INSERT INTO dne_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bhahe, Yecho ajhakupwatalila nchuka ghola, na gwene ujhakummoka kwa mwana jhola papa ajhakubhehe njelembo. ");
INSERT INTO dne_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Peniya bhabholwa bhala bhajhakunyendela Yecho pangabhando na kunkonya, “Nhwalo gwa nike twenga tukahotwi ndeka kubhenga nchuka ghola?” ");
INSERT INTO dne_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yecho ajhakwajhanguu, “Nhwalo kihobholelo chino chandina. Ninobholela chakaka, ngamehe na kihobholelo chikibhii ngita lumbejho lwa lindebhele, mihoto kukilongolela kitombe chenje, ‘Bhoka pamba, unheghelele pala!’ Na chenie ngakijheketile. Nhwalo kibhii jhe changahoto kuhengeka kwino. ");
INSERT INTO dne_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nambo nchuka ngita ghongo nauhotola jhe kuchomoka nambo kwa kuleka kulyegha na kunyopa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bhabholwa pubhakonganika pamonga ku Galilaya, Yecho ajhakwalobholela, “Mwana gwa Mundo nabhankamuha mu mabhoko gha bhando bhanganandela, ");
INSERT INTO dne_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","na bhene nabhankoma, nambo lichiko lya utato nayokechwa.” Bhahe, bhabholwa bhajhakubhehe ngolongonde hake. ");
INSERT INTO dne_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yecho na bhabholwa bhake pubhahikita ku kilambo chuku Kapelenaumo, bhibhalepecha kode jha Nyumba jha Chapanga bhajhakunnyendelela Petile na kunkonya, “Bho, Mmola gwino alepa kode jha Nyumba jha Chapanga?” ");
INSERT INTO dne_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petile ajhakwajhanguu, “Chakaka, alepa.” Bhahe, Petile pajhingila nkate jha unyumba jha Chapanga anatumbu jhe kulonge kilebhe, Yecho ajhakunkonya, “Simone, mwenga mihola bhole? Akanahota bha nnema akatola kode kuhumii kwa ghane? Kuhuma kwa akolo kilambo amu akaghene?” ");
INSERT INTO dne_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petile ajhakwajhanguu, “Kuhuma kwa akaghene.” Na Yecho ajhakunnobholela, “Yamaha, akolo kilambo bhalepa ndeka. ");
INSERT INTO dne_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nambo yamaha ndeka kwatenda bhabhehe na lilaka. Nnyende kulilabha mukalopole. Na luhomba lwakutumbula kulopola, mulunanakule nnomo namwikolela mbijha. Mwitole yenio ikwela kulepe kode kwa twenga bhabhele.” ");
INSERT INTO dne_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Machiko ghala bhabholwa bhajhakunyendelela Yecho na kunkonya, “Bho, ndi ghane jwabhii nkolongwa Munahota gwa kunane kwa Chapanga?” ");
INSERT INTO dne_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bhahe, Yecho ajhakunkema mwana na kunnyemeka pakate jhabhe, ");
INSERT INTO dne_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na ajhakulonge, “Ninnobholela chakaka, changaghalambuka na kubhehe ngita yana henge, nanyingii ng'o mu Unahota nkolongwa gwa kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bhahe, kila mundo jwapala kubhehe unyenyekeho ngita mwana jhonjo, ndi jwabhii nkolongwa mu Unahota gwa kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jwenio jwampoke mwana kwa liina lyango, ambokii nenga. ");
INSERT INTO dne_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mundo jhojhoha jwapala kuhobhecha jhumo jwa bhamba bhana bhibhahobholela bhatende jwahenge uhakaho, mbaha kwa mundo jwenio bhantabhalila lwalwa lukolongwa pantandala na kuntaghii umbwane. Millstonejpgcol Bhando bhabhele bhiyagha kwa lwalwa 18:6 Millstone. jpgcol Bhando bhabhele bhiyagha kwa lwalwa ");
INSERT INTO dne_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nabhalola choto bhando bha nnema kwa nhwalo ibhii ilebhe twe ibhatenda bhando bhange bhahenge uhakaho! Ilebhe yenio ipalwa kupitila, nambo nalola choto kwa mundo jhola jwaileta ilebhe yenio! ");
INSERT INTO dne_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Anda lubhoko amu lugholo lwino luntenda nhenge uhakaho, mbaha muluhekete na kulutaghi oko! Mbaha kwino kujhingii mu ughome gwa machiko ghoha ghangapeta kongo mmii na lubhoko lumo amu mmii na lugholo lumo, kuliku kutaghilwa mu mwotu gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na liho lino anda lihobhiche, mulibhohe na kulitaghi oko! Mbaha kujhingii mu ughome gwa machiko ghoha kongo na liho limo, kuliku kubhehe na miho mabhele na kutagwa mu mwotu gwa machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mukilolekehe nkotoka kupucha jhumo jwa yana henge. Nhwalo akatumiche bhabhe bha kunane kwa Chapanga, bhubhabhii palonge jha Tate gwango jwa kunane kwa Chapanga machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nhwalo Mwana gwa Mundo ahikite kunkombola jhola jwahobhalile. ");
INSERT INTO dne_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mihola bhole, anda mundo abhii na mambelele makome kome, na limo pakate jhake lihobhalile. Naghaleka jhe mambelele makome ticha na ticha kughalucha na kujhenda kulipaha lilihobhalile lela? ");
INSERT INTO dne_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Anda alihwene limbelele lela, ninobholela chakaka, nalihanganila kuliku ghala makome ticha na ticha ghangahobhelela. ");
INSERT INTO dne_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Helahela Tate gwino jwa kunane kwa Chapanga apala ndeka jhumo jwa yana yandina ihobhelele. ");
INSERT INTO dne_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Anda nnongo gwino anemwiye, nnyende mukanangiye chalemwite, kongo mmii mabhele tugha. Na anda anyeketile namma mupatite nnongo gwino. ");
INSERT INTO dne_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nambo anda amekii lighoho, mutole mundo jhonge jhumo amu bhabhele nnyendengane pamonga, kwa malobhe gha bhando bhabhele amu bhatato bhubhalolite mihalo ihadabulilwe ngita chighalongela Majhandiko gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Anda abhakundii lighoho na bheniya, mwalobholele likunde lya bhando bhubhanyeketela Kilichitu. Helahela anda alikundii lighoho likunde lyenio, bhahe, mumalangila ngita mundo jwangaumanya Chapanga amu ntocha kode. ");
INSERT INTO dne_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ninnobholela chakaka, chochoha chipala kukanikiya pannema helahela nakikanikiwa kunane kwa Chapanga, na chochoha chikipalwa kujheketelwa pannema helahela nakijheketelwa kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kabhele ninnobholela, bhabhele pakate jhino bhajheketile kwa kilebhe chochoha pannema pano chiwapala kujhopa pamonga panane jha kilebhe chochoha, nabhahengelwa kilebhe chenie na Tate gwango jwa kunane. ");
INSERT INTO dne_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nhwalo popoha pubhakonganika bhabhele amu bhatato kwa liina lyango, na nenga mii papa peniya pakate jhabhe.” ");
INSERT INTO dne_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peniya Petile ajhakunyendelela Yecho na kunkonya, “Bhambo, bho anda nnongo gwango anemwihe, ninekekeya palenga? Bho, ninnekekeye mala chaba?” ");
INSERT INTO dne_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yecho ajhakujhanguu, “Naha tu jhe, ibhaha makome chaba mala chaba. ");
INSERT INTO dne_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ndi nhwalo Unahota nkolongwa gwa kunane kwa Chapanga ulandina naha. Munahota jhumo jwapata kubhalanga maghambo gha akatumiche bhake. ");
INSERT INTO dne_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Patumbwila kubhalanga maghambo ghake, bhajhakunetela mundo jhumo jwakibha na lighambo lya mamilione gha mbijha. ");
INSERT INTO dne_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na mundo jwenio akibhanacho jhe kilebhe cha kulepa, munahota gwake ajhakunnobholela, achuluchwe jwenio pamonga na nhwana mundo na yana mundo na ilebhe yake yoha. Achuluchwe ngita mmanda, pange lighambo lilepeke. ");
INSERT INTO dne_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bhahe, ntumiche jhola ajhakuntamii makilikite palonge jha nkolo gwake jhola na kulonge, ‘Nhimbilile hote, naninepa lighambo lino.’ ");
INSERT INTO dne_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Munahota jhola ajhakumwone kiya, ajhakunnekekeya lighambo lyake. Na kunneka ajhende. ");
INSERT INTO dne_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nambo ntumiche jhola pabhokita, ajhakukongana na mundo nnyake jwakibha na lighambo lyake lya mbijha lyandina tugha. Ajhakunkamula na kupyeneneka palikolomelo alongila, ‘Nnepe lighambo lino!’ ");
INSERT INTO dne_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ntumiche jhola ajhakutama makilikite na kumpembelekeya, ‘Unhimbilile hote naninepa lighambo lino!’ ");
INSERT INTO dne_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nambo akajheketindeka, ajhakupeleka kuntabha mu kipungo ade papala kulepa lighambo lyake. ");
INSERT INTO dne_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bhahe, akatumiche ajhake pubhalolita kilebhe chenie bhajhakubhehe ngolongonde hake. Bhajhakujhenda kunobholela munahota gwabhe mambu gheniya. ");
INSERT INTO dne_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Peniya munahota jhola ajhakunkema ntumiche jhola na kunnobholela, ‘Mwenga ndi matumiche bhukokotwike hake! Nhwalo nenga ukambembekiye nyakunekekeya lighambo lino lyoha. ");
INSERT INTO dne_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na mwenga bho, yamaha ndeka kunkolela kiya ntumiche nnyino ngita nenga chinikolii kiya?’ ");
INSERT INTO dne_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bhahe, munahota jhola ajhakubhehe nnomo nduu, ajhakupeleka ntumiche jhola mukipungo bhang'ahe ade papala kulepa lighambo lyake.” ");
INSERT INTO dne_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yecho ajhakukuntila kwa kulonge, “Helahela Tate gwango jwa kunane natendela hele mangota anda nanekekeya ndeka nnongo mundo kuhumii kumwojho.” ");
INSERT INTO dne_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yecho pajhomolila kulonge malobhe gheniya, ajhakubhoka ku Galilaya nu kujhenda ku Yudeya, kwiye jha lukemba lwa ku Yolodane. ");
INSERT INTO dne_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lilongo lya bhando lijhakunkengama na jwenio Yecho ajhakulamicha malwalo ghabhe. ");
INSERT INTO dne_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bhahe, Mapwalichayo bhange bhajhakunyendelela Yecho na kunkonya kwa kunnyambila, “Nhwalo gwa nike Lilaghalikilo lito linnyeketela munalome kunneka nhwana mundo kwa nhwalo ghoghoha ghola?” ");
INSERT INTO dne_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yecho ajhakujhanguu, “Bho, mukachomite ndeka Majhandiko gha Chapanga, kuhumii makacho Chapanga akapangine mundo munalome na mwikeghe? ");
INSERT INTO dne_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Peniya Chapanga alongela, ‘Kwa nhwalo ghongo munalome nanneka tate mundo na majhe mundo, nalombana na nhwana mundo, na bhoha bhabhele nabhabha yegha jhimo.’ ");
INSERT INTO dne_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bhahe, bheniya bhabhele jhe, nambo nabhabha yegha jhimo. Chalombaniche Chapanga, abhii jhe mundo jwakulekanicha.” ");
INSERT INTO dne_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mapwalichayo bhajhakunkonya Yecho, “Bho, nhwalo gwa nike Mucha akatulaghalikiye tujhandika baluwa jha kulekana na kuneka mwikeghe?” ");
INSERT INTO dne_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yecho ajhakwajhanguu, “Mucha akanyeketile mangota kulekana na akahana bhino nhwalo gwa miojho jhino kujhundupa. Nambo kuhumii kupanganwa kwa nnema ghakibha jhe ngita ghanga. ");
INSERT INTO dne_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nambo nenga ninobholela, kila mundo jwalekana na nhwana mundo na kutolela, nambo anda chi kwa ulemo gwa ngongola tugha, na kuntolela mwikegha jhonge, jwenio atenda ngongola.” ");
INSERT INTO dne_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bhabholwa bhake bhajhakunnobholela, “Anda mambu ghabhii naha kwa munalome na mwikeghe peniya ndi mbaha kutama nhwolo.” ");
INSERT INTO dne_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yecho ajhakujhanguu, “Chi bhoha bhahotola kuhimbilila libholo lende, nambo bhala tugha bhubhahaghulilwe na Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nhwalo ghabhii mambu ghamahele ghahoto kunhibhilikiya nkoto kutolela, bhange bhabhelwike yenio, na bhange bhatendwitwe yenio na bhando bhange na bhange bhakapai bhene kubhehe yenio kwa nhwalo gwa Unahota gwa kunane kwa Chapanga. Jwahotola kulighegha libhole lende, na aligheghe!” ");
INSERT INTO dne_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Peniya bhando bhange bhajhakuileta yana ichokombe kwa Yecho abhabhekele mabhoko na kwakuchulila. Nambo bhabholwa bhake bhajhakwapwatalila bhando bheniya. ");
INSERT INTO dne_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nambo Yecho ajhakwalobholela, “Muileke yana yandina ihike kwa nenga, mangaibhilikiya nhwalo Unahota gwa kunane kwa Chapanga gwa bhando bhubhabhii ngita yana henge.” ");
INSERT INTO dne_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bhahe, pajhomolila kwakuchulila, Yecho ajhakubhoka peniya. ");
INSERT INTO dne_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mundo jhumo ajhakunyendelela Yecho na kunkonya, “Mmola, bho, ndende nike chambone mme na ughome gwa machiko ghoha ghangapeta?” ");
INSERT INTO dne_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yecho ajhakunkonya, “Nhwalo gwa nike ungonyekeya kilebhe chambone? Abhii jhumo jwaumbone ndi Chapanga. Anda mipala kujhingii mu ughome, nkamule lilaghalikilo lya Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mundo jhola pakonyita, “Lilaghalikilo ghane kabhele?” Yecho panyangita, “Nkotoka kukoma, nkotoka kutenda ngongola na nkotoka kukwatula na nkotoka kwalobholela bhange uwange, ");
INSERT INTO dne_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mwatembekehe tate gwino na majhe gwino na mupale nnyino ngita chimukipala mabhene.” ");
INSERT INTO dne_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kangombo jhola ajhakunobholela, “Gheniya ghoha nighakamwile pumila mwana, bho, kilebhe ghane chenge chimbongokiwe?” ");
INSERT INTO dne_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yecho ajhakunnobholela, “Anda mwipala kubhehe ma mundo bhambone chakaka, nnyende mukachuluche ilebhe hino yoha, na makabhaghulile akahocho, na mwenga namaha na kihukilo kunane kwa Chapanga. Peniya ungengama.” ");
INSERT INTO dne_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nambo kangombo jhola pajhohina malobhe gheniya, ajhakukijhendela kongo abhii ngolongonde. Nhwalo akibha na ilebhe mbwe hake. ");
INSERT INTO dne_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bhahe, Yecho ajhakwalobholela bhabholwa bhake, “Ninobholela chakaka, ijhundwipe kwa mundo jwabhii na ilebhe mbwee kujhingila mu Nahota gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kabhele ninobholela, ijhojwike kwa kinyama chikikemwa ngamiya kuholota pa lihoto lwa luchungulo lwa mpacha, kuliku jwabhii na ilebhe twe kujhingii mu Unahota nkolongwa gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bhabholwa bha Yecho pubhajhohina malobhe gheniya, bhajhakubhehe hechu, bhajhakunkonya Yecho, “Bho, ghane ngohe nahotola kughombokoka?” ");
INSERT INTO dne_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yecho ajhakwapikiya miho, ajhakulonge, “Ilebhe henge kwa mundo ahoto jhe kuhenga, nambo kwa Chapanga ghoha ghiwechekana.” ");
INSERT INTO dne_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Peniya Petile ajhakunkonya Yecho, “Dolekeya! Na twenga bho? Ghoha tughalekite tunkengime mwenga, bho, natujhambulila nike kwino?” ");
INSERT INTO dne_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yecho ajhakwajhanguu, “Ninnobholela chakaka, Mwana gwa Mundo papala kutama pa kigoda chake cha ung'alicho cha ulongoche mu nnema nhyono. Mangota bhungengime nantamangana mwigoda kome na ibhele, mughahadabula makabila kome na mabhele gha Ichilahele. ");
INSERT INTO dne_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kila mundo jwahilekite nyumba jhake amu tate mundo amu majhe mundo amu nnongo mundo amu nnombo mundo amu yana mundo amu chaghila chake kwa nhwalo gwa nenga, napokela makome kome ngoheno na kupelwa ughome gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nambo bhubhalongolile nabhabha bhakujhomolela ngoheno, na bhakujhomolela nabhabhaha bhakutumbula ngoheno. ");
INSERT INTO dne_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Unahota gwa kunane kwa Chapanga ulandine na mundo jhumo jwabhii na nng'onda gwa michabibo. Jwalabhite lukela kwapalaha bhando bhakuhenga lihengo munng'onda gwake. ");
INSERT INTO dne_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ajhakughana nabho kwalepa mbijha kipande chimo cha madine gha feza kwa lichiko, peniya ajhakwapeleka kunng'onda gwake gwa michabibo. ");
INSERT INTO dne_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Puhikila chaa tato jha lukela, ajhakubhoka kabhele ajhakwabhona bhando bhange bhajemite mu maghuliho, bhakwete jhe chakuhenga. ");
INSERT INTO dne_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ajhakwalobholela, ‘Nnyende na mangota mukahenge lihengo munng'onda gwango gwa michabibo, na nenga naninepa.’ ");
INSERT INTO dne_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bhahe, bhajhakujhenda. Nkolo nng'onda jwenio ajhakubhoka kabhele puhikila chaa chita na chaa ticha, na ticha ajhakutenda helahela. ");
INSERT INTO dne_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Puhikila chaa kome na jhimo jha kimiye, ajhakujhenda kabhele, ajhakukongana na bhando bhange bhajhemangine palighuliho pala. Bhahe, ajhakwakonya, ‘Nhwalo ghane ngohe mpipikiye muhe jhoha changalihengo pambano?’ ");
INSERT INTO dne_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na bhene bhajhakunyanguu, ‘Nhwalo abhii jhe mundo jwatupikiye lihengo.’ Peniya ajhakwalobholela, ‘Mangota helahela nnyende mukahenge kunng'onda gwango gwa michabibo.’ ");
INSERT INTO dne_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pulitipika lyobha, nkolo nghonda ajhakunnobholela jwajhemelela jhola, ‘Mwakeme bhubhahengita lihengo na mwalepe malepo ghabhe, ntumbula kwa bhala bhakujhomolela ade kwa bhala bhibhalongolila.’ ");
INSERT INTO dne_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bhahe, bhala pibhatumbwila kuhenga chaa kome na jhimo jha kimiye, kila jhumo ajhakulepwa mbijha kipande chimo cha madine gha feza. ");
INSERT INTO dne_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na bhala bhibhakatumbwile kuhenga lukela bhahambwika nabhajhonjekewa mbijha henge, nambo nabhene bhajhakulepwa kipande chimo cha madine gha feza kila jhumo. ");
INSERT INTO dne_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pibhapokila malepo ghabhe bhajhakutumbuu kunkokolekeya nkolo nng'onda. ");
INSERT INTO dne_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bhalongila, ‘Bhando bhamba bhubhahikite kujhomolela bhahengite kwa lichaa limo tugha, nambo mwalepite ngita twenga bhutuhengita lihengo muhe jhoha pa lyobha?’ ");
INSERT INTO dne_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nkolo nng'onda jhola ajhakunnyanguu jhumo pakate jhabhe, ‘Makoche, niponjite ndeka kilebhe. Bho, tughalaghine ndeka malepo gha kipande chimo cha madine gha mbijha kwa lichiko? ");
INSERT INTO dne_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bhahe, npokele feza jhino nnyende. Nipala kupekeya jhonjo jhunimpeila lihengo lya kujhomolela ngita mwenga. ");
INSERT INTO dne_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bho, nihoto jhe kuhenga chochoha chinipala kwa ilebhe yango? Nhwalo gwa nike umeke wiho nenga naumbone?’ ” ");
INSERT INTO dne_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yecho ajhomolila kwa kulonge, “Ndi naibhaha, bhakujhomolela nabhabhaha bhakutumbula na bhakutumbuu nabhabhaha bhakujhomolela.” ");
INSERT INTO dne_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yecho pahohwika kujhenda ku Yeluchalemo, ajhakwaghegha bhabholwa bhake kome na bhabhele na kulonge nabho kongo bhakityanga mundela pangabhando na kwalobholela, ");
INSERT INTO dne_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ajhakwalobholela, “Unyokanikiye tujhenda ku Yeluchalemo na kwenio Mwana gwa Mundo nabhankamuha kwa Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo. Na bhene nabhanhadabulwa akomwe, ");
INSERT INTO dne_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","peniya napelekwa kwa bhando bha ilambo henge. Na bhene nabhantendela chanake na kunnapula yato na kumamba panane jha nchalaba, nambo lichiko lya utato nayokechwa.” ");
INSERT INTO dne_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Peniya majhe yana mundo Zebedayo pamonga na yana yake ibhele ajhakunyendela Yecho. Bhahe, majhe jhola ajhakutama makilikite palonge jha Yecho, kwa kunnyopa antendele chakipala. ");
INSERT INTO dne_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yecho ajhakunkonya, “Bho, mipala nike?” Na jwenio ajhakujhanguu, “Chonde mwalobholele kubhehe yana yango ibhele nabhatama jhumo lubhoko lwalelo na jhonge lubhoko lwa ngejha pumipala kubhehe mu Nahota gwino.” ");
INSERT INTO dne_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yecho ajhakwalobholela, “Umanyite jhe chimujhopa. Bho, mihoto kunywegha mukibaba cha malagho chininywegha nenga?” Na bhene bhajhakunyanguu, “Tuhotola.” ");
INSERT INTO dne_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yecho ajhakwalobhalela, “Ninongolela chakaka, naunywela kibaba chango cha malagho, nambo kutama lubhoko lwalelo amu lwa ngejha, lihengo lyango ndeka kupanga. Kilebhe i napelwa bhala bhubhalenganikilwe na Tate gwango.” ");
INSERT INTO dne_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bhala bhabholwa bhange kome pibhajhohina malobhe gheniya, bhajhakwayomela akalongo bheniya bhabhele. ");
INSERT INTO dne_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Bhahe, Yecho ajhakwakema bhoha na kwalobholela, “Umanye ilongoche ya nnema ulongocha bhando kwa makakala, na bhakolo bheniya ubhatenda bhando kubhehe bhabhe. ");
INSERT INTO dne_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nambo kwa mangota nahijhe, nambo jwapala kubhehe nkolongwa pakate jhino abhehe ntumiche jwa bhoha, ");
INSERT INTO dne_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","na jwapala kubhehe nkolongwa pakate jhino bhoha, ipalwa abhaha ntumiche jwino. ");
INSERT INTO dne_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ngita chabhii Mwana gwa Mundo jwenio ahikiti jhe kuhengelwa, nambo kunhengela na kubhoha ughome gwake kwakombola bhando bhamahele.” ");
INSERT INTO dne_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yecho na bhabholwa bhake pubhabhokita ku Yeliko, lilongo lya bhando lijhakwakengama. ");
INSERT INTO dne_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Bhahe, pakibha na bhando bhabhele bhangalola bhatamita muupele jha ndela. Pubhajhohina Yecho atenda kupeta bhajhakunonoha malobhe, “Bhambo, Mwana gwa Daude umonele kiya!” ");
INSERT INTO dne_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lilongo lya bhando lela lijhakwapwatalila, bhalongolila bhatame nuu. Nambo bhene bhajhakuchocha kulalama, bhalongila, “Bhambo, Mwana gwa Daude, mutubhone kiya!” ");
INSERT INTO dne_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yecho ajhakujhema na ajhakwakema na kwakonya, “Bho, mipala nintendele nike mangota?” ");
INSERT INTO dne_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na bhene bhajhakunyanguu, “Bhambo, tujhopa tulole!” ");
INSERT INTO dne_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bhahe, Yecho ajhakwabhonela kiya, ajhakupapaha miho ghabhe. Papa bhajhakulola, na kunkengama. ");
INSERT INTO dne_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yecho na bhabholwa bhake pubhabhandikila kuhika ku Yeluchalemo na kuhika ku Betifage pakitombe chuku Micheitune. Yecho ajhakwatuma bhabholwa bhake bhabhele, ");
INSERT INTO dne_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ajhakwalobholela, “Nnyende ade pachenda jha palonge jhino na namukolela liponda likongilwe na libhii na litohe lyake. Mulijhoghole na nhwike nako kwa nenga. ");
INSERT INTO dne_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Anda mundo ankonyite nhwalo gwa nike mutenda naha, munnobholele, ‘Bhambo alipala,’ na jwenio nanekekeya papa.” ");
INSERT INTO dne_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kilebhe chenie kitendika kupala ghakamilike ghighalongilwa na nnondole jwa Chapanga, ");
INSERT INTO dne_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mwalobholele bhando bha muche kwa ku Sayune Dolekeya, Munahota nkolongwa gwino atenda kuhika! Abhii nhihimo na atamite panane jha liponda. Ahika panane jha mwana liponda, kinyama chikijhegha mihigho.” ");
INSERT INTO dne_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bhahe, bhabholwa bhajhakujhenda na kutenda ngita Yecho chibhalaghalikiye. ");
INSERT INTO dne_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bhajhakunetela liponda Yecho pamonga na litohe lyake, bhajhakujhala ngobho panane jhabhe na Yecho ajhakutama panane jhake. ");
INSERT INTO dne_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bhahe, lilongo lya bhando lijhakujhala ngobho undela, bhange bhajhakujhala matuto gha mikongo mwenio undela. ");
INSERT INTO dne_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lilongo lya bhando likalongolile na lela lilikengima unyuma jhake bhajhakunonoha malobhe, “Ulombwe Mwana gwa Daude! Jhuna mota jwahika kwa liina lya Bhambo! Chapanga alombwe kunane!” ");
INSERT INTO dne_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yecho pajhingila ku Yeluchalemo bhando bhoha bhajhakubhehe ngenyangenya. Bhando bhajhakunkonya, “Jhonjo ngohe ndi ghane?” ");
INSERT INTO dne_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Bhahe, lilongo lya bhando ujhakujhanguu, “Jwenio ndi nnondole Yecho, ahumii ku Nachalete ku muche gwa ku Galilaya.” ");
INSERT INTO dne_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Peniya Yecho ajhakujhingii pa Nyumba jha Chapanga, na kutumbuu kwabhenga bhando bhoha panja bhibhachulwicha na kuhemela ilebhe mwenio. Helahela ajhakupendengula njangwale yabhe ibhajhanganganila mbijha na igoda ya bhala bhibhachulwicha ngunda. ");
INSERT INTO dne_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ajhakwalobholela, “Ijhandikwe naha mu Majhandiko gha Chapanga, ‘Nyumba jhango nahibha nyumba jha kunnyope Chapanga.’ Mangota mwenga uyohite nkwembe gwa kukwatulila ilebhe!” ");
INSERT INTO dne_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bhangalola na bhibhalemile bhajhakunyendelela Yecho pa Nyumba jha Chapanga, na jwenio ajhakwalamicha. ");
INSERT INTO dne_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bhahe, Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo bhajhakuyoma pubhalolita iiebhe yambone yatehila Yecho, na kujhoha yana ikachobhela pa Nyumba jha Chapanga ilongila, “Nnombwe mwenga, Mwana gwa Daude!” ");
INSERT INTO dne_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bhahe, bhajhakunkonya Yecho, “Bho, nnyohine malobhe ghibhalonge yana hengeno?” Yecho ajhakwajhanguu, “Chakaka, nnyohine. Nambo mukachomite ndeka mu Majhandiko gha Chapanga ghighalonge, ‘Kuhuma mumilomo jha yana napokela chipwa jhilenganile.’ ” ");
INSERT INTO dne_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bhahe, ajhakwaleka na kujhenda ku Betaniya na ajhakugholoka koko. ");
INSERT INTO dne_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lukala jhake Yecho pabhujhita ku Yeluchalemo, ajhakubhona njala. ");
INSERT INTO dne_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ajhakubhona nkongo gwa nkojho mupele jha ndela, ajhakuheghelela nambo ukapambike ndeka nga mahamba tebha. Yecho ajhakulapanikiya alongila, “Kubhoke ngoheno nkotoka kupambika uhohe kabhele!” Papalapala nkongo ghola ujhakujhoma. ");
INSERT INTO dne_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Bhabholwa pubhalolita kilebhe chenie bhajhakuhechuka hake na kukikonya, “Nhwalo gwa nike nkojho ghongo ujhomite kajhombe?” ");
INSERT INTO dne_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yecho ajhakwajhanguu, “Ninobholela chakaka, nkwete jhe kiholo, mihoto kuhenga chindeile kwa nkojho ghongo. Na kupeta kwa lyenio mihoto kukilobholela kitombe chenje, ‘Heghela hoko, mukitaghile kumbwane,’ nahitendeka hele. ");
INSERT INTO dne_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Anda mmii na kihobholelo, kilebhe chochoha chimujhopa mu kumnyopa Chapanga, nampelwa.” ");
INSERT INTO dne_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Peniya Yecho ajhakujhingii pa Nyumba jha Chapanga, atehila kubhola. Akapiya matambiko bhakolo pamonga na ighogholo bhajhakunyendelela na kunkonya, “Bho, muhenga ghangano kwa ukindendeke gwa ghane? Na ghane ngohe jwapekiye mwenga ukindendeke gwenio?” ");
INSERT INTO dne_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yecho ajhakwajhanguu, “Na nenga ninkonye kilebhe chimo. Anda unyangwii, helahela naninobholela nihenga kwa ukindendeke gwa ghane. ");
INSERT INTO dne_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Bho, ukindendeke gwa Yohane gwa kubaticha bhando uhumila kwa ghane, kwa Chapanga amu kwa bhando?” “Bhene bhajhakubhehe chwapu, anda tulongile ukindendeke gwake, ‘Uhumii kwa Chapanga,’ natukonya, ‘Nhwalo gwa nike ngohe minyeketela ndeka?’ ");
INSERT INTO dne_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Anda tulongile, ‘Uhumila kwa bhando,’ tujhoghopa lilongo lya bhando nhwalo bhoha bhajheketela kubhehe Yohane akibha nnondole jwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bhahe, bhajhakunnyanguu Yecho, “Tumanyite ndeka.” Na jwenio ajhakwalobholela, “Na nenga hele naninobholela ndeka nihenga kwa ukindendeke gwa ghane. ");
INSERT INTO dne_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Yecho ajhakuchocha kulonge, bho, mangota mihola nike panane jha ilebhe hengeno? Pakibha na mundo jhumo jwakibha na ichongolo ibhele, ajhakutumbula kunobholela mwana jwa kutumbula, ‘Mwanango, deleno mukahenge mughonda gwa michabibo.’ ");
INSERT INTO dne_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na mwana jhola jwa kutumbula ajhakujhanguu, ‘Mbahijhe,’ nambo paligha ajhakujheketela kujhenda kuhenga lihengo. ");
INSERT INTO dne_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tate mundo jhola ajhakunobholela mwana mundo jhubhele jhola ngita chanobholila jwatumbwila jhola. Na jwenio ajhakujhanguu, ‘Nijhenda tate!’ Nambo ajhenda ndeka. ");
INSERT INTO dne_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bho, ghane pakate jha bhabhele bhano jwateile ghaghapala tate gwabhe?” Bhajhakunyanguu, “Ndi jhola jwatumbwila kunobholela.” Bhahe, Yecho ajhakwalobholela, “Ninobholela chakaka, bhiakatola kode na bhibhatenda ngongola nabhannongolela mangota kujhingii mu Nahota gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nhwalo Yohane akahikite kwino kunangiya ndela jha chakaka jha kutama, na mangota mikanyeketi ndeka. Nambo akatola kode na bhatenda ngongola bhanyeketile. Pamonga na kulola ilebhe yoha yenio mangota mulekite ndeka uhakaho gwino na kunnyeketela.” ");
INSERT INTO dne_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Peniya Yecho ajhakwalobholela, “Nnyokanikiye nnandanikiho ghonge. Mundo jhumo ajhakulema nghonda gwa michabibo, ajhakutindikiya ubhegho, ajhakutengenecha chehemo jha kuminyila chabibo, na kuchenga kilendo kitandamaho. Ajhakwajhahikicha bhubhalema na jwenio kujhenda ku kilambo chukutale. ");
INSERT INTO dne_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pughahikita machiko gha mahuno, ajhakwatuma akatumiche bhake bhajhende kwa bhala bhubhajhahike mighonda, bhakatole lipungo lyake lya mahuno. ");
INSERT INTO dne_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nambo bhala bhubhajhahike mighonda bhajhakwakamula akatumiche bhala. Jhumo bhajhakuntyala, na jhonge bhajhakunkoma na jhonge bhajhakukong'onda maghanga. ");
INSERT INTO dne_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nkolo nghonda jhola ajhakwatuma akatumiche bhange bhamahele, nambo bhala bhubhajhahike mighonda bhajhakwetendela hele. ");
INSERT INTO dne_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na kujhomolela kwake ajhakuntuma mwana mundo kwabhene, ‘Kongo awachila, nabhanyeketela nhwalo mwanango.’ ");
INSERT INTO dne_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nambo bhubhalema bhala pubhamwenita mwana jhola, bhajhakupwepwelana, ‘Jhonjo ngoheno ndi nabhujhila mighonda, tunkome na nghonda ghongo tubhujhii twenga!’ ");
INSERT INTO dne_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bhahe, bhajhakunkamula, bhajhakunhutila kutale na nghonda gwa michabibo ghola na kunkoma.” ");
INSERT INTO dne_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Bho, ngohe nkolo nghonda papalakuhika, nabhatenda nike bhubhajhahike bhenabha?” ");
INSERT INTO dne_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Na bhene bhajhakunyanguu, “Nabhalobholela chakaka nabhakoma bhando bhanganandela bhene na nghonda gwenio nabhapela bhando bhange, ndi nabhampela lipungo lya mahuno ghake chiipalwa.” ");
INSERT INTO dne_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yecho ajhakwajhanguu, “Bho, mukachomite jhe kilebhe chenje mu Majhandiko gha Chapanga? ‘Lighanga lilikanwitwe na punde jwaichenga, ngoheno lihyokite lighanga lilipalwa hake kuliku ghoha. Ndi Bhambo, jwateii kilebhe chenje, nalyene ndi lya kukangacha hake kwito!’ ");
INSERT INTO dne_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kwa nhwalo ghongo,” “Unahota gwa Chapanga nahubhoka kwito na kupelwa bhando bha ilambo henge bhibhahenga ghapala Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mundo jhojhoha jwapala kugwelelwa na lighanga lyenio naheketwa imbembela imbembela, na lighanga lyenio anda ligwelikile mundo jhojhoha naliyogha yoghoyogho. ");
INSERT INTO dne_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Akapiya matambiko bhakolo na Mapwalichayo pubhajhohina milandanikiho jhene, bhajhakumanya kubhehe alongila panane jhabhe. ");
INSERT INTO dne_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bhahe, bhajhakupalaha ndela jha kukamuu Yecho, nambo bhajhogwipa bhando nhwalo bhene bhakanhwachile kubhehe jwenio ndi nnondole jwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yecho ajhakulonge nabho kabhele kwa milandanikiho, ");
INSERT INTO dne_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Unahota gwa Chapanga ulandine na nkolo jwakanenganikiye mwana mundo unyagho gwa kutolana. ");
INSERT INTO dne_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jwenio ajhakwatuma akatumiche bhake bhakakeme bhibhalalike bhala bhahike, nambo bhene bhajhakubhehe mbe kuhika. ");
INSERT INTO dne_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Peniya ajhakwatuma akatumiche bhange, ajhakwalobholela alongila, ‘Mwalongolele bhando bhinalalike kubhehe unyagho ubhii lengalenga ngohe. Lipongo lya ng'ombi na matohe gha ng'ombi ghighahatite njinjite, kila kilebhe kibhii telatela, nhwike ngane pa unyagho!’ ");
INSERT INTO dne_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nambo bhene bhakachitwike ndeka, kila jhumo ajhakujhenda kwakumanyite, jhumo kunghonda na jhonge kwachuluchila ilebhe yake, ");
INSERT INTO dne_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","na bhange bhajhakwakamula akatumiche na kwatyala na kwakoma. ");
INSERT INTO dne_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Munahota nkolongwa jhola ajhakuchimwa, ajhakwatuma akomana ngondo bhake. Bhakwakomelekeya bhubhakoma bhala na kuchonja muche gwabhe kwa mwotu. ");
INSERT INTO dne_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Peniya ajhakwalobholela akatumiche bhake, ‘Chakulya cha unyagho gwa kutolana ngoheno ubhii lengalenga, nambo bhinalalike bhakatopi ndeka kuhika. ");
INSERT INTO dne_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bhahe, nnyendengane mundela na jhojhoha jhola jhumipala kummona munete paunyagho gwa kutolana pano.’ ");
INSERT INTO dne_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Akatumiche bhala bhajhakujhenda mundela, bhajhakwakema bhoha bhubhakongina nabho, bhambone na bhanganandela, na nyumba jhene ijhakuhindamana ndi akaghene. ");
INSERT INTO dne_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Munahota nkolongwa pajhingila kwalolekeya akaghene, ajhakummona mundo jhumo akahwalite ndeka ngobho ya unyagho gwenio. ");
INSERT INTO dne_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Munahota jhola ajhakunkonya, ‘Mwakoche, nhwalo gwa nike nnyingii mombo changa ngobho ya unyagho gwa kutolana?’ Jwenio ajhakubhehe nuu. ");
INSERT INTO dne_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Peniya munahota nkolongwa jhola ajhakwalobholela akatumiche bhake, ‘Mutabhe magholo na mabhoko na mukataghii kulubhendo. Kwenio nalela na kuyagha mino.’ ” ");
INSERT INTO dne_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Peniya Yecho ajhakulonge, “Bhando bhunkemitwe bhamahele, nambo bhala bhibhahagwile ndi bhandina.” ");
INSERT INTO dne_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Peniya Mapwalichayo bhajhakubhoka na bhajhakulenganikila ndela jha kunyonja Yecho mu malobhe ghake. ");
INSERT INTO dne_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bhahe, Mapwalichayo bhajhakwatuma bhabholwa bhake pamonga bhabholwa bha kikunde cha Helode kwa Yecho. Bhajhakunkonya Yecho, “Mmola, tumanya mwenga ndi mundo jwa chakaka, na mibhola mabholo gha chakaka gha ndela jha Chapanga. Changannolekeya mundo kumiho helahela muloloke jhe hilu ukolo gwa mundo jhojhoha. ");
INSERT INTO dne_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ngoheno mutulobholele, bhole yamaha amu yamaha ndeka kulepa kode kwa munahota nkolongwa jwa ku Loma liina lyake Kaichale?” ");
INSERT INTO dne_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nambo Yecho akamanye ndela jhabhe jhanganandela, ajhakwajhanguu, “Mangota mukitenda bhando bhaumbone, Bho, munyighanikiya nhwalo gwa nike? ");
INSERT INTO dne_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Unangiye hote mbijha jhene jhimulepe kode.” Na bhene bhajhakunangiya litobholo lya mbijha. ");
INSERT INTO dne_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bhahe, Yecho ajhakwakonya, “Bho, chula jhenje na liina lilijhandikwe leno lya ghane?” ");
INSERT INTO dne_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bhajhakunyanguu, “Ndi lya munahota nkolongwa jwa ku Loma.” Yecho ajhakwalobholela, munahota nkolongwa jwa ku Loma mupele jwenio na ghughabhii gha Chapanga mupele jwenio Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pubhajhohina malobhe gheniya bhajhakukangachwa nako, bhajhakuneka, “Yecho na bhajhakubhoka peniya.” ");
INSERT INTO dne_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lichiko lele Machadukayo bhange bhibhalonge bhubhawile bhayoka jhe, bhajhakunyendelela Yecho, ");
INSERT INTO dne_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","bhajhakunkonya, “Mmola, Mucha akalongi, mundo jwatolile anda awile changaneka yana, nhwacha mundo ipalwa amujhila majhe jwenio lipwela apapila yana nnongo mundo jwawile. ");
INSERT INTO dne_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bhahe, pamba pito pakibha akalongo chaba. Jwakutumbula ajhakutolela na kuwegha changaleka mwana. Na nnongo mundo ajhakubhujhila lipwela lyenio, ");
INSERT INTO dne_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ijakubhehe hele kwa nnongo mundo jhubhele na jwa utato, ade jhola jwa chaba. ");
INSERT INTO dne_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bhakawii bhoha chaba, na mwikeghe jhola ajhakuwegha hele. ");
INSERT INTO dne_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bho, lichiko lya bhando lya kuyokechwa, mwikeghe jwenio nabhaha nhwana gwa ghane, nhwalo bhoha chaba bhakantolile?” ");
INSERT INTO dne_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yecho ajhakwajhanguu, “Mangota ntei kulemwa nhwalo gwangamanya Majhandiko gha Chapanga hilu likakala lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nhwalo bhando pubhapala kuyokechwa kuhumii kubhawile kutolela amu kutolelwa kubhii jhe, nabhabha ngita akatumiche bha kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na panane jha kuyokechwa kwa bhubhawile, bho, nchomite jhe malobhe ghannobholila na Chapanga? ");
INSERT INTO dne_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nenga na Chapanga jwa Ulahimo na Chapanga jwa Isaka na Chapanga jwa Yakobu.’ Yecho pajhendelila kwalobholela, jwenio chi Chapanga jwa bhando bhubhawile nambo Chapanga jwa bhando bhubhabhii ghome.” ");
INSERT INTO dne_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lilongo lya bhando ghola pubhajhohina mabholo gheniya, bhajhakuhechuka hake. ");
INSERT INTO dne_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Peniya Mapwalichayo pubhajhohina Yecho ajhakwahibha milomo Machadukayo, bhajhakukonganika pamonga. ");
INSERT INTO dne_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na jhumo jwa bhabhola bha Malaghalikilo, jwakibha mundo jwakaimanye Malaghalikilo mbone ajhakunyendelela Yecho na kunkonya kwa kunyighanikiya, ");
INSERT INTO dne_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mmola,” “Lilaghilo ghane likolongwa mu Malaghalikilo ghoha?” ");
INSERT INTO dne_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yecho ajhakujhanguu, “ ‘Mupale Bhambo Chapanga kwa mwojho gwii ghoha, na kwa uhuke gwii ghoha na malango ghii ghoha.’ ");
INSERT INTO dne_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lende ndi lilaghilo likolongwa na lya kutumbula. ");
INSERT INTO dne_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chubhele ilandana na lende, ‘Mupale nnyino ngita chimukipala mabhene.’ ");
INSERT INTO dne_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Malaghalikilo ghoha gha Chapanga ghapekiwe Mucha na mabholo ghoha gha milondole bha Chapanga ghahobholela mihilo jhenje mibhele.” ");
INSERT INTO dne_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Peniya Mapwalichayo pubhakonganika pamonga, Yecho ajhakwakonya, ");
INSERT INTO dne_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mangota miwacha bho panane jha Kilichitu Nkomboche? Bho, Jwenio ndi mwana jwa ghane?” Na bhene bhajhakunyanguu, “Jwenio ndi Mwana gwa Daude.” ");
INSERT INTO dne_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yecho ajhakwalobholela, “Peniya nhwalo gwa nike kwa likakala lya Uhuke gwa Chapanga Daude ankemi jwenio ‘Bhambo?’ Ndi nhwalo akalongi, ");
INSERT INTO dne_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bhambo, akanobholile Bhambo gwango. Ntame lubhoko lwango lwalelo, ade nabheke akamakoko bhino pahe jha magholo ghino.’ ");
INSERT INTO dne_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bhahe, anda Daude ankema Kilichitu Nkomboche, ‘Bhambo,’ ahoto bhole kubhehe mwana mundo?” ");
INSERT INTO dne_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bhahe, abhii jhe mundo jhojhoha jwakahotwii kujhanguu lilobhe. Kuhumii lichiko lyenio Na bhene bhakajhighite jhe kunkonya machwale ghange. ");
INSERT INTO dne_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Peniya Yecho ajhakulilobholela lilongo lya bhando pamonga na bhabholwa bhake, ");
INSERT INTO dne_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bhabhola bha Malaghalikilo na Mapwalichayo ndi bhakibha na ukindendeke gwa kuchimulila Lilaghalikilo lya Mucha lyapekiwe na Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bhahe, nkamule na kuhenga chochoha chibhannobholela, nambo nkotoka kwajhigha ghibhahenga, nhwalo bhihenga ndeka ghala ghibhalongela. ");
INSERT INTO dne_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Utabha mihigho mitopaho na kwatweka bhando mu mabhegha, nambo bhene bhapala ndeka kuhatambula hilu lukonje kwatangatila kughegha. ");
INSERT INTO dne_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nambo ghibhahenga ghoha bhapala bhabhonekane palonge jha bhando. Uhwala luhunga lukolongwa lwa ngobho lulujhandikwe majhandiko gha lilaghalikilo panane jha libhonge na mu mabhoko na ujhonjekeya ihundo ya luche itabhitwe mu malombolo gha ngobho yabhe. ");
INSERT INTO dne_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bhapala kutama mupwache ya palonge jha muunyagho gwa kulyegha, na mwighoda ya nkate jha nyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Upala kujhambuchwa kwa kutembekewa mu maghuliho na kupala kukemwa na bhando, ‘Mmola.’ ");
INSERT INTO dne_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nambo mangota nkotoka kujheketelwa kukemwa ‘Mmola,’ nhwalo Mmola gwino ndi jhumo na mangota bhoha makalongo. ");
INSERT INTO dne_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Amu nkotoka kunkema mundo jhojhoha ‘Tate jwa pannema,’ nhwalo abhii Tate jhumo jwabhii kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nkotoka kupala kunkemwa, ‘Kilongoche,’ nhwalo kilongoche jhino jhumo ndi Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jwabhii nkolongwa pakate jhino ajheketela kubhehe ntumiche jhino. ");
INSERT INTO dne_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na mundo jhojhoha jwakitenda nkolongwa, kubhehe kilebhe nacho, na jhojhoha jwakitenda kilebhe nacho nabhaha nkolongwa. ");
INSERT INTO dne_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nanola choto akabhola bha Malaghalikilo na Mapwalichayo, mangota mukitenda bhando bhaumbone! Midinda nnyango gwa Unahota gwa Chapanga bhando bhakoto kujhingila. Mangota mabhene mujhingii ndeka nkate, kabhele bhalekekeya jhe bhibhapala kujhingila bhajhingile. ");
INSERT INTO dne_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nanola choto bhabhola bha Malaghalikilo na Mapwalichayo, mangota mukitenda bhando bhaumbone! Nhwalo mupoka akanawela ilebhe yabhe na kukitenda mukilangila ndi bhando bhaumbone kwa kunnyopa Chapanga kwa malobhe ghamahele. Nhwalo gwenio luhadabulo lwino nalutenda kuchocha hake! ");
INSERT INTO dne_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nanola choto bhabhola bha Malaghalikilo na Mapwalichayo mukitenda bhando bhaumbone! Bhumutyanga kujhomboka umbwane na ku ilambo henge mipala kwang'alambula bhando, jwenio ajheketele mabholo ghino. Pajheketela mutenda abhehe na uhotolo bhabhe na kujhenda mu mwotu gwangahimika kwa machiko ghoha ghangapeta kuliku mabhene. ");
INSERT INTO dne_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nanola choto ilongoche yangalola bhumibhola! ‘Mangota milonge mundo anda akilapanikiye kwa Nyumba jha Chapanga, lulapanikiho lwenio lukwete jhe likakala, nambo mundo anda akilapanikiye kwa chaabo jhibhii nkate mu Nyumba jha Chapanga, lulapo lono lubhii na likakala.’ ");
INSERT INTO dne_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mangota mangalola na bhupumbumwike! Bho, nike kikolongwa chaabo amu Nyumba jha Chapanga jhiitenda jhene chaabo kubhehe nyahinyahi? ");
INSERT INTO dne_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kabhele milonge ‘Anda mundo alapanikihe kwa njangwale ya matambiko lulapanikiho lwenio lubhii jhe na likakala, nambo anda mundo akilapanikiye kwa tambiko jhibhekwitwe panane jha njangwale ya matambiko, kilapo chenie kibhii na likakala.’ ");
INSERT INTO dne_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Chakaka, mangota mangalola! Bho, nike chikibhii kikolongwa litambiko amu njangwale ya matambiko jhitenda litambiko kubhehe lya nyahinyahi? ");
INSERT INTO dne_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Mundo jwalapanikiya kwa njangwale ya matambiko, akilapaniki kwa njangwale yenio ya matambiko na kwa chochoha chikibhekitwe panane jhake. ");
INSERT INTO dne_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na jwalapanikii kwa Nyumba jha Chapanga akilapanikii kwa Nyumba jhene na kwa jwenio jwaatama nkate jhake. ");
INSERT INTO dne_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na jhola jwakilapanikii kunane kwa Chapanga akilapanikii kwa kigoda cha unahota nkolongwa cha Chapanga na kwa jwenio jwatama kunane jhake. ");
INSERT INTO dne_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nanola choto, mangota bhabhola bha Malaghalikilo na Mapwalichayo, mangota bhumukitenda bhaumbone! Kongo majhopa bhando chaka jha ndimbilo na mandebhele na mahamba ghange gha makolo. Na mahamba ghighanungulila mbone, na iliki na kalafuu kongo mighaleka gha chakaka ngita kiya na kihobholelo. Ghanga ndi ghighapalwa kuhengwa changaleka na gheniya ghange. ");
INSERT INTO dne_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mangota ilongoche yangalola! Mujhengulua mabhembe mu ilebhe hino ya kunywegha, nambo mumila ngamiya! ");
INSERT INTO dne_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nanola choto bhabhola bha Malaghalikilo na Mapwalichayo, mangota mukitenda bhando bha umbone! Mangota mukeya kibaba na chahane kwa panja, nambo kwa nkate kutwelii ilebhe ipatite ya uchojho. ");
INSERT INTO dne_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mwapwalichayo mwangalola! Ntumbula hote kukeya kibaba kwa nkate na panja napabhaha nyahinyahi. ");
INSERT INTO dne_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nanola choto bhabhola bha Malaghalikilo na Mapwalichayo, bhumukitenda bhando bhaumbone! Muwanana na mambe ikilimwe kwa undope nhuo kwa panja ghabhonekana ghambone, nambo nkate ghatwelii ihupa ya bhando bhubhawile na luku longe. ");
INSERT INTO dne_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pamonga na gheniya, mangota kwa panja mubhonekana ngita bhando bhumitenda ghapala Chapanga, nambo kwa nkate milandana na bhando bhubhakitenda bhaumbone na ubhoho. ");
INSERT INTO dne_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nanola choto bhabhola bha Malaghalikilo na Mapwalichayo! Muchengelela mambe ya milondole bha Chapanga na kulembekeya mambe ya bhando bhambone. ");
INSERT INTO dne_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kabhele milonge, ‘Anda twenga ngatubhehe mu machiko gha akahoko bhito, ngatujheketile ndeka kubhehe pamonga kwa kwakoma milondole bha Chapanga.’ ");
INSERT INTO dne_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bhahe, milonge hotuhotu mabhene kubhehe mangota ndi kibheleko cha bhando chibhakomita milondole bha Chapanga! ");
INSERT INTO dne_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chakaka, nnyomolele lihengo lela libhatumbulicha kuhenga akahoko bhino! ");
INSERT INTO dne_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mangota kibheluko cha lijhoka na yana ya lijhoka! Bho, nahotola bho kulubhambala luhadabulo lwa mwotu gwangahimika? ");
INSERT INTO dne_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kwa nhwalo gwenio, nenga naninetela milondole bha Chapanga na bhando bhubhabhii na malango na bhabhola bha Malaghalikilo. Mangota namakoma na bhange kwabhamba panchalaba na bhange kwakenyula yato munyumba jha kukonganikii Akayahude. Na bhange namabhutuha kubhoka muche ghumo na ghonge. ");
INSERT INTO dne_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bhahe, luhadabulo loha nalumpata kwa nhwalo jha miyahe jha bhando bha umbone jhijhitike panane jha nnema, nahibhaha panane jhino. Chakaka, kuhumii kukomwa kwa Abele jwangahenga kilebhe kibhoho, ade miyahe jha Zakaliya mwana gwa Bakaliya, jwakakomitwe pa lubhanja lwa Nyumba jha Chapanga pakate jha chehemo jha nyahinyahi na pakachangwale ka litambiko. ");
INSERT INTO dne_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ninobholela chakaka, luhadabulo kwa nhwalo gwa bhando bheniya bhubhakomitwe nahibhaha panane jha kibheluko chenje.” ");
INSERT INTO dne_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Mabhando bha ku Yeluchalemo, mabhando bha ku Yeluchalemo! Mikoma milondole bha Chapanga na kwakong'onda maghanga bhala bhibhatumitwe kwino. Palegha nnyighite kubheka mabhoko ghango panane jha bhando bhino, ngita ngoko chajhobhotela yana yake kwa mapapanilo ghake. Nambo mukapahii jhe! ");
INSERT INTO dne_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Dolekeya, ngoheno nyumba jhino jha Chapanga nailekwa mahundo. ");
INSERT INTO dne_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bhahe, ninobholela, naubhone jhe kabhele ade pumpala kulonge, ‘Jhuna mota jwahika kwa liina lya Bhambo.’ ” ");
INSERT INTO dne_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yecho ajhakupita pa Nyumba jha Chapanga, pakibha akijhendila. Bhabholwa bhake bhajhakuhikilila na kunangiya Nyumba jha Chapanga chichengwitwe. ");
INSERT INTO dne_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yecho ajhakwalobholela, “Chakaka, mihoto kughalolekeya ghanga ghoha. Ninnobholela chakaka, libhii jhe hilu lighanga limo lilipala kuhighalika panane jha lighanga lenge. Kila kilebhe nakiyangabhanwa.” ");
INSERT INTO dne_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Peniya Yecho pakibha atamite panane pa kitombe chuku Micheitune, bhabholwa bhake bhajhakunyendelela pangabhando na kunkonya, “Chonde mutulobholele ilebhe henge naihengeka ligha? Bho, na nginyililo ghane jhipala kulangiya kuhika kwino na upehekelo gwa machiko?” ");
INSERT INTO dne_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yecho ajhakwajhanguu, “Mukilolekehe mundo akoto kunkopokeya. ");
INSERT INTO dne_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nhwalo bhando bhamahele nabhahika na kulonge kila jhumo, ‘Nenga ndi Kilichitu!’ Na bhene nabhankopokeya bhando bhamahele. ");
INSERT INTO dne_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pumipala kujhoha malobhe gha ngondo na mbwepo ya ngondo, bhahe, nkotoka kujhoghopa, nhwalo gheniya ghipalwa kupitila. Nambo kujhomokela kwake kwamela. ");
INSERT INTO dne_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bhando bha kilambo chimo na akakomana na bhando bha kilambo chenge, unahota nkolongwa ghumo naukomana na unahota ghonge. Pamba na pala pabhaha na njala na nnindimilo gwa nnema. ");
INSERT INTO dne_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gheniya ghoha naghabhaha ngita kutumbuu kwa lipyanda lya kupapa mwana. ");
INSERT INTO dne_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Peniya nanyambilwa, na kung'ahichwa na kukomwa. Bhando bha ilambo yoha naichimwangana kwa nhwalo gwa kunyekete nenga. ");
INSERT INTO dne_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Machiko gheniya, bhamahele nabhakileka kihobholelo chabhe, nabhajhambilana bhene kwa bhene na kuchimwana. ");
INSERT INTO dne_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mu machiko gheniya nabhapitila milondole bhamahele bhuwange, na bhene nabhakuloha bhando twe. ");
INSERT INTO dne_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nhwalo kujhonjekeka kwa ghanganandela, upalo gwa bhando mabhahele nautundingila. ");
INSERT INTO dne_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nambo jwapala kuhimbilila ade kujhomolela jwenio naghombokoka. ");
INSERT INTO dne_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Lilobhe lya Mbone lya unahota gwa kunane kwa Chapanga nalitangachwa kwa bhando bha ilambo yoha ili bhando bhoha kwalangiya kabula jha kuupekeya kwa nnema. ");
INSERT INTO dne_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pumpala kubhona ‘Lijhambu lihakanaho lilihangabhana,’ lilongilwa na Daniele nnondole jwa Chapanga lijhemite chehemo jha nyahinyahi pa Nyumba jha Chapanga.” Jwachoma na amanye! ");
INSERT INTO dne_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Peniya bhubhabhii ku Yudeya bhabhutikila ku kitombe. ");
INSERT INTO dne_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bhahe, mundo jhojhoha jwapakubhehe pa kipaghalo akotoka kuhuluka kujhingii nkate na kutola ilebhe yake, na helahela jwabhii kunng'onda akotoka kubhujha kutola ilebhe yake. ");
INSERT INTO dne_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mundo jwabhii kunghonda akotoka kubhujha kutola ngobho yake. ");
INSERT INTO dne_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nakole kiya hake kwa akakeghe bhubhabhii na ndumbo na bhibhajhongecha nabhabha mumalagho kwa machiko gheniya. ");
INSERT INTO dne_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mbaha tunnyope Chapanga kuntila kwino kukota kubhehe machiko gha malile amu Lichiko lya Kupomolela! ");
INSERT INTO dne_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nhwalo machiko gheniya napabha na lung'ahe lukolongwa lyanapitii jhe kuhumii mukupanganwa nnema ade ngoheno, hilu nalipitijhe kabhele. ");
INSERT INTO dne_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na anda Chapanga nakupongocha jhe machiko gha malagho, abhii jhe hilu mundo jhumo nga ghombokwikwe, nambo machiko gheniya naipongochwa kwa nhwalo jha bhala bhubhahaghulilwe. ");
INSERT INTO dne_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bhahe, mundo anda anongalile, mangota kwa machiko gheniya, Kilichitu Nkomboche abhii pamba! amu Kilichitu Nkomboche abhii kola! Nkotoka kunyokanikiya. ");
INSERT INTO dne_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nhwalo nabhapitila bhakilichitu bhuwange na milondole bhauwange. Nabhalangiya nginyililo ngolongwa na ikangacho ya kuhotu kwakopokeya bhando hilu bhala bhubhahaghulilwe na Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Unyokanikiye chakaka, ninnobholile njwe mangota lichaa lyamela lyanghika. ");
INSERT INTO dne_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Bhahe, pubhapala kunnobholela mangota, ‘Dolekeya, abhii kunjenga!’ Nkotoka kujhenda kwenio, amu dolekeya, Kilichitu Nkomboche ajhobhite muchumbe! Mwangajhokanikiya. ");
INSERT INTO dne_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nhwalo nahibhaha ngita lumule lwa mbamba chilulangala kubhoka kulihumii lyobha ade kulitipikila lyobha. Ndi chipala kubhoneka kwa Mwana gwa Mundo papala kuhika lichiko lyenio. ");
INSERT INTO dne_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Pughakonganika matumbuhe, ndi pubhii ntuhe.” ");
INSERT INTO dne_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Papa pulupala kupeta lung'ahe lwa lichiko lyenio, lyobha nalibhaha lubhendo tyoo na mwehe naupiha jhe lilangamule. Ndondo nahigwaha kubhoka kumahunde, na makakala gha ilebhe ya kunane kwa Chapanga nainyukanyuka. ");
INSERT INTO dne_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Peniya nginyililo ya kuhika kwa Mwana gwa Mundo nahibhonekana kumahunde, bhahe, bhando bha makabila ghoha gha nnema naghalela. Mwana gwa Mundo nabhamona akahika pakate jha mahunde kuhumii kunane kwa Chapanga abhii jhuna likakala na ukolo twe. ");
INSERT INTO dne_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lipenenga nalilela kwa lilobhe likolongwa na jwenio nabhatuma akatumiche bhake bha kunane kwa Chapanga, kwa pande yoha ncheche ya nnema kwaponga bhubhahaghulilwe na Chapanga kuhumii mujhomokelo ghongo ade upeekeho gwa nnema.” ");
INSERT INTO dne_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mukibhole nnandanikiho ghongo kuhumii nkongo gwa nkojho, mandabhe gha nkongo ghabhii mabhehe utumbuu kupiya mahamba, umanye kubhehe machiko gha kuhuna ghabhandikile. ");
INSERT INTO dne_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Helahela kwa mangota pumipala kughabhona ghahengeka gheniya ghoha, umanya kubhehe lichaa libhandikile kuhika. ");
INSERT INTO dne_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ninobholela chakaka, kibheluko chenje nakipete jhe kabula jha kuhengeka ghanga. ");
INSERT INTO dne_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunane kwa Chapanga na nnema nahipeta, nambo malobhe ghango naghapeta ng'o.” ");
INSERT INTO dne_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nambo abhii jhe mundo jwamanya lichiko amu lichaa lyenio nalihika ligha, hilu akatumiche bha kunane kwa Chapanga. Hilu Mwana, nga Tate ndi jwamanya. ");
INSERT INTO dne_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ngita chikibha mu machiko gha Nuho, ndi naghatendika helahela kuhika kwake kwa Mwana gwa Mundo ");
INSERT INTO dne_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nhwalo lichiko lyenio nahikoma hula ngolongwa na mache kuheluka pannema ghoha, bhando nabhajhendelela kulyegha na kunywegha, kutolela amu kutolelwa ade Nuho pajhingila mungalabha ngolonga jhikemwa chapina. ");
INSERT INTO dne_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na bhene bhakamanyite jhe kilebhe chikipala kupitila ade hula ngolongwa na mache pughahelwika pannema poha, na kwakoma bhando bhoha. Ndi chikipala kupitila kwa Mwana gwa Mundo kuhika kwake. ");
INSERT INTO dne_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Machiko gheniya bhando bhabhele nabhabha mukulema, jhumo natolwa na jhonge nalekwa mwenio mughonda. ");
INSERT INTO dne_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akakeghe bhabhele nabhabhaha pa lwalwa kuyagha, jhumo natolwa na jhonge nalekwa papa. ");
INSERT INTO dne_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Chonde nkeluwe bhahe, mukilenganikiye nhwalo umanyitejhe lichiko lya kuhika kwa Bhambo gwino. ");
INSERT INTO dne_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nambo nkomboke lilobhe lendeno, nkolo nyumba ngamanya lichiko lya mwihe papala kuhika, ngailekiti jhe hilu nyumba jhake ihangabhanwe. ");
INSERT INTO dne_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bhahe, mangota helahela mukilenganikiye, nhwalo Mwana gwa Mundo nahika kwa lichaa lya kupwitikilila pwitu. ");
INSERT INTO dne_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Peniya Yecho pajhendilila kulonge, “Bho, ndi ghane ntumiche jwahobholeka na jhuna malango? Jhola munahota gwake nameka kwajhemelela akatumiche bhake, abhapekehe yakulyegha pulihika lichaa lyake. ");
INSERT INTO dne_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jhuna mota ntumiche jwabhii na munahota gwake papala kuhika nakolela akahenga gheniya. ");
INSERT INTO dne_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ninobholela chakaka, nkolo gwake nameka ntumiche jhola ajhemelele ilebhe yake yoha. ");
INSERT INTO dne_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nambo anda ntumiche ndi mundo jwanganandela, nakilongolela jwenio ku mwojho kubhehe ‘Bhambo abhii na kiyoto kubhujha,’ na atumbula kwakong'onda akatumiche bhajhake, ");
INSERT INTO dne_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na kulyegha na kunywegha pamonga na bhibhanywe ughembe. ");
INSERT INTO dne_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bhahe, munahota jwa ntumiche jhola nahika lichiko lyangalihobholela na lichaa lyangalimanya. ");
INSERT INTO dne_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na jwenio nabhatyala hake na kubheka likunde limo na bhando bhubhakitenda bhaumbone. Kwenio nakubha kulela na kuyagha mino. ");
INSERT INTO dne_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kwa machiko gheniya, Unahota gwa kunane kwa Chapanga naulandana na ichikana kome bhibhatohi kolobohi yabhe na kujhenda kumpoke nnyinamwale. ");
INSERT INTO dne_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nhwano pakate jhabhe bhatei kupumbumuka na nhwano bhakibha bhina malango. ");
INSERT INTO dne_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Bhibhapumbumwike bhala bhakatohi kolobohi yabhe, bhakatoijhe mahuta gha kihukilo. ");
INSERT INTO dne_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nambo bhina malango bhala bhakagheghita mahuta ghange mu chupa pamonga na kolobohi yabhe. ");
INSERT INTO dne_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nhwalo nnyinamwale akacheliwe kuhika, akachikana bhoha bhajhakutumbuu kuchichila na bhajhakugholoka. ");
INSERT INTO dne_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pakate jha uhiko, pajhakubhehe na njobhele, ‘Jhimuka, jhimuka! Nnyinamwale abhii kuhika, nnyende mukampokele!’ ");
INSERT INTO dne_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ichikana hela ijhakujhimuka yoha, na kulenganikiya kolobohi yabhe. ");
INSERT INTO dne_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ipumbumwike hela ijhakwalongolela bhala bhubhabhii na malango, ‘Mutupele mahuta ghandina nhwalo kolobohi hito ipala kuhima.’ ");
INSERT INTO dne_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nambo ichikana ibhii na malango hela ijhakulonge, ‘Ghakwela jhe kumpela mangota na twenga, mbaha nnyendengane mukahemele kubhachulucha.’ ");
INSERT INTO dne_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bhahe, ichikana ipumbumwike hela pubhajhawila kuhemela mahuta, nnyinamwale ajhakuhika, na hela ichikana ibhii na malango bhakibha telatela kujhingii pamonga na jwenio munyumba jha unyagho gwa ndowa na nnyango ujhakupungwa. ");
INSERT INTO dne_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Palonge pandina bhala akachikana bhibhapumbumwike bhajhakuhika na kukema, ‘Bhambo, mabhambo!’ Mutudindulile litangala! ");
INSERT INTO dne_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nambo jwenio ajhakwajhanguu, ‘Ninnobholela chakaka,’ nimanyingine jhe mangota.” ");
INSERT INTO dne_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Peniya Yecho ajhakulonge, “Nkeluwe, nhwalo mulimanyitejhe lichiko hilu lichaa papala kuhika Mwana gwa Mundo. ");
INSERT INTO dne_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Machiko gheniya naibhaha ngita mundo jhumo jwakapahi kujhenda mwanja, ajhakwakema akatumiche bhake na kwakamua ilebhe yake. ");
INSERT INTO dne_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ajhakumaghulila kila jhumo ngita uhotolo gwake, jhumo mbijha talanta nhwano na jhonge mbijha talanta ibhele na jhonge mbijha talanta jhimo, peniya ajhakujhenda. ");
INSERT INTO dne_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Papa jhola ntumiche jwakapatite mbijha talanta nhwano ajhakujhenda kuchuluchila na ajhakujhonjekeya henge nhwano. ");
INSERT INTO dne_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na jhonge jwakapatite mbijha talanta ibhele ijhakubhelekana henge ibhele. ");
INSERT INTO dne_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nambo ntumiche jwakapatite mbijha talanta jhimo ajhakujhenda kuhembe libhomba, na kuhibheka mwenio mbijha jha munahota gwake. ");
INSERT INTO dne_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Pighapetita machiko twe, nkolo jwa akatumiche bhala ajhakubhujha, na kutumbuu kubhalanga mbijha yake pamonga na bheniya. ");
INSERT INTO dne_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ntumiche jhola jwakakamwiwe mbijha talanta nhwano ibhelekine henge talanta nhwano, ajhakunobholela, ‘Bhambo! Ukambekii talanta nhwano, na ngoheno ibhelekine henge nhwano.’ ");
INSERT INTO dne_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Munahota jhola ajhakulonge, ‘Mwe ntei mbone, ntumiche mwaumbone na uhobholike!’ ‘Mwilebhe yandina, na ngohe nanimpela makolonga. Uhike nhwangane pamonga na nkolo gwino.’ ");
INSERT INTO dne_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ajhakuhika ntumiche jwakakamwiwe mbijha talanta ibhele, ajhakulonge, ‘Munahota, ukangamwiye mbijha talanta ibhele. Ngoheno ntole talanta ibhele ibhelekine.’ ");
INSERT INTO dne_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Munahota jhola ajhakunobholela, ‘Mbone, ntumiche jwa umbone na jhumuhobholeka!’ Uhobholike mwiilebhe yandina, na ngoheno nanikamua makolonga, ‘Uhike nhwangane pamonga na munahota gwino.’ ");
INSERT INTO dne_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nambo jhola jwakapatite mbijha talanta jhimo ajhakuhika, na kulonge, ‘Munahota, niumanye mwenga nkokotwike mwojho, muhuna pangamicha, mwiponga pangamicha. ");
INSERT INTO dne_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nikajhogwipe, nyakuhiya mbijha jhino mu undope. Ngoheno ntole mbijha jhino.’ ");
INSERT INTO dne_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Munahota jhola ajhakunobholela, ‘Mwenga ndi mantumiche manganandela na matotoho! Umanyi kubhehe nenga nihuna pangamicha, na niponga pangamicha. ");
INSERT INTO dne_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bhahe, impalita kubheka mbijha yango kwa bhando bhibhahemela na kuchulucha mbijha, na nenga ngandohile mbijha imekite na hela ijhonjikike. ");
INSERT INTO dne_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mupoke mbijha yenio na mukapela jhola jwabhii na mbijha talanta kome. ");
INSERT INTO dne_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nhwalo, jwabhii na kilebhe napelwa na kujhonjekewa. Nambo jhola jwangabhehe nacho, hilu chela chandina chabhii nacho napokwa. ");
INSERT INTO dne_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na kwa jwenio ntumiche jwangahenga lihengo lya kujhokekeha, mutaghile panja palubhendo, kwenio nakubhaha kulela na kuyagha mino.’ ");
INSERT INTO dne_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mwana gwa Mundo papala kuhika mu ukolongwa gwake na pamonga na akatumiche bhoha bha kunane kumahunde, peniya natama panane jha mu kigoda chake cha unahota gwa kwa Chapanga chikibhii na ung'alicho. ");
INSERT INTO dne_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bhando bha ilambo yoha naikonganika pamonga palonge jhake, na jwenio nabhahaghula bhando ngita nnuchajhe pahaghula mambelele na mbuhe. ");
INSERT INTO dne_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Naghabheka mambelele ngita bhando bhaumbone lubhoko lwake lwalelo na mbuhe ngita bhando bhanganandela lubhoko lwake lwa ungejha. ");
INSERT INTO dne_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Peniya, munahota nkolongwa nabhalobholela bhala bhubhabhii lubhoko lwalelo, ‘Uhikengane mangota bhupekiwe mota na Tate gwango, nnyingile munahota ghumekilwe kuhumii mukupanganwa kwa nnema. ");
INSERT INTO dne_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nhwalo, punikibha na njala mangota mukambekihe chakulya, na punikibha na nyota na mangota mukambekihe mache, na punikibha naghene na mangota mukambokii ukajhino, ");
INSERT INTO dne_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","punikibha makengele, mukahwachile ngobho, nikibha na ulwalo mukahikite kundangatila, punikibha mukipungo, mukahikite kunninga.’ ");
INSERT INTO dne_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Peniya bhando bhala bhaumbone nabhannyangula munahota jhola, ‘Bhambo, ligha tukamwene mmii na njala na twenga tujhakupekeya chakulya, amu pukibha na nyota tujhakupekeya mache? ");
INSERT INTO dne_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Bho, kojhe kutumwene mmii maghene na twenga tujhakupokela, amu kojhe kutukolila mmii makengele na twenga tujhakuhwalicha ngobho? ");
INSERT INTO dne_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Bho, ligha tukamwene pumukibha mukulwalwa amu pumukibha mukipungo tujhakuhika kuninga?’ ");
INSERT INTO dne_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Munahota nkolongwa nanyangula, ‘Ninobholela chakaka, kila kilebhe chimutendila jhumo jwa bhamba akalongo bhango bhachokombe ndi undendila nenga!’ ");
INSERT INTO dne_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Peniya nabhalobholela bhala bhubhabhii lubhoko lwa ngejha, ‘Mmokengane palonge jhango mangota bhunapanikilwe! Nnyendengane mu mwotu gwa machiko ghoha ghangapeta, gwabhekilwe Limbembela na akatumiche bhake! ");
INSERT INTO dne_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nhwalo punikibha na njala mangota mukambekii jhe chakulya, na punikibha na nyota mangota mukambekii jhe mache gha kunywegha. ");
INSERT INTO dne_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Punikibha naghene mangota mukambokii jhe punikibha makengele mangota mukahikiti jhe ngobho, punikibha mukipungo mangota mukahikite jhe kunninga.’ ");
INSERT INTO dne_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Na bhene nabhajhangula, ‘Bhambo, ligha tukamwene pumukibha na njala, amu punyohina nyota amu mmii maghene amu pumii makengele amu mitenda kulwalwa amu mupungwite, na twenga tukanhengii jhe?’ ");
INSERT INTO dne_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jwenio munahota nanyangula, ‘Ninobholela chakaka, kila pukanita kwatangatii ilebhe yenio pakate jha yandina henge, unganila kundangatila.’ ");
INSERT INTO dne_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bhahe, bhamba nabhajhenda mumalagho gha machiko ghoha, nambo bhambone nabhajhingila muughome gwa machiko ghoha ghangapeta.” ");
INSERT INTO dne_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yecho pajhomolila kulonge malobhe gheniya ghoha, ajhakwalobholela bhabholwa bhake, ");
INSERT INTO dne_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Umanyite ghahighalike machiko mabhele kubhehe na unyagho gwa Pachaka, Mwana gwa Mundo najhambilwa na kubhambwa pachalaba.” ");
INSERT INTO dne_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Machiko gheniya, akapiya matambiko bhakolo na akanahota bhajhakutama pa Bwalo jha Kayafa jwakibha nkolo jwa mpiya litambiko. ");
INSERT INTO dne_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na bhene bhajhakulonge nginyika jha kuchenjela jha kunkamuu Yecho bhankome. ");
INSERT INTO dne_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Nambo bhajhakulonge likotoka kuhengeka machiko gha unyagho gwa Pachaka, kuhoto kubhehe na bhulo pakate jha bhando.” ");
INSERT INTO dne_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yecho pakibha ku Betaniya, kajha kwa Simone, helahela akemitwa Simone malohe, ");
INSERT INTO dne_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mwikeghe jhumo ajhakunhikilila Yecho na chupa jhitengenichwe kwa lighanga lya alabachita jhikibha na mahuta ghighachuluchwa kwa mbijha yamahele. Ajhakunhikilila Yecho pakachangwale palila na ajhakunyitila mahuta gheniya Yecho pamuto. ");
INSERT INTO dne_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bhabholwa bhake Yecho pubhalolita gheniya bhajhakuhyoma na kulonge, “Nhwalo gwa nike ajhitana ilebhe ngita hengeno? ");
INSERT INTO dne_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mahuta ghanga ghighanungulili petelele ghahoto kuchuluchwa kwa feza ya madine twe na gheniya ngaghahotwi kwabhaghanichila akahocho!” ");
INSERT INTO dne_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yecho akamanye chibhawachila, ajhakwalobholela, “Nhwalo gwa nike mung'aha mwikeghe jhonjo? Jwenio andendile kilebhe chambone hake nenga. ");
INSERT INTO dne_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nhwalo nantama na akahocho machiko ghoha, nambo nenga namejhe na mangota machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mwikeghe jhonjo annyitii mahuta gha petelele kwa nhwalo gwa kulenganikiya yegha jhango kwa kuchikwa. ");
INSERT INTO dne_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ninobholela chakaka, popoha pannema Lilobhe lya Mbone nalitangachwa, kilebhe chateii majhe jhola nakilongelwa na kukombokwa jwenio.” ");
INSERT INTO dne_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Peniya Yuda Ichikaliyote, jhumo pakate jha bhabholwa bhala kome na bhabhele bha Yecho, ajhakujhenda kwa akapiya matambiko bhakolo, ");
INSERT INTO dne_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ajhakwalobholela, “Bho, nanyambulila nike anda ninyambii Yecho mu mabhoko gwino?” Bhahe, bhajhakumalangila ipande makome matato gwa feza, ");
INSERT INTO dne_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","na kuhumii papa Yuda ajhakutumbuu kupalaha ndela jha kunnyambila Yecho. ");
INSERT INTO dne_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lichiko lya kutumbula kwa unyagho gwa mabumunda ghangalekela ngedule, bhabholwa bhake bhajhakunyendelela Yecho na kunkonya, “Bho, mipala kojhe tukalenganikiye chakulya cha Pachaka?” ");
INSERT INTO dne_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na jwenio ajhakwajhanguu, “Nnyendengane ku muche gwa likambako limo na mukannobholele: ‘Mmola alonge, lichiko lyango libhandikile. Kwino nenga na bhabholwa bhango natulya Pachaka pamonga kajhino.’ ” ");
INSERT INTO dne_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Na bhene bhabholwa bhajhakuhenga ngita chabhalaghalikiye Yecho, bhajhakulenganikiya chakulye Pachaka. ");
INSERT INTO dne_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pihikila kimiye, Yecho ajhakutama pakulyegha pamonga na bhabholwa bhake bhoha kome na bhabhele. ");
INSERT INTO dne_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pubhakibha mukulyegha, Yecho ajhakwalobholela, “Ninnobholela chakaka, jhumo pakate jhino nandenda kunyambila.” ");
INSERT INTO dne_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bhahe, bhabholwa bhake bhajhakubhehe ngolongondi hake ku mwojho, bhajhakutumbuu kunkonya jhumo jhumo, “Bhambo, ndi nenga?” ");
INSERT INTO dne_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yecho ajhakwajhanguu, “Jwachwika libumunda pamonga na nenga mu bakule ndi jhonjo jwambala kunyambila. ");
INSERT INTO dne_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Chakaka, Mwana gwa Mundo nahwa ngita Majhandiko gha Chapanga chighalonge, nambo nalola choto mundo jhola jwapala kunnyambila Mwana gwa Mundo! Ngaibhii mbaha kwa jwenio ngabhelwike jhe!” ");
INSERT INTO dne_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yuda, ndi jhola jwapala kunyambila, ajhakunkonya, “Mmola, ndi nenga?” Yecho ajhakunyanguu, “Mabhene ndi milongila.” ");
INSERT INTO dne_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pubhalila, Yecho ajhakutola libumunda, na ajhakunchenguu Chapanga ajhakumetula na kwapela bhabholwa bhake alongila, “Ntolengane nnyakile, jhenje ndi yegha jhango.” ");
INSERT INTO dne_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Peniya ajhakutola kibaba cha divaye, helahela ajhakunnomba Chapanga na kwapela alongila, “Unywengane mabhoha, ");
INSERT INTO dne_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","nhwalo jhenje ndi miyahe jhango jhilangiya kubhehe lilaghano lya Chapanga na bhando ndi chakaka, miyahe jhijhitika kwa nhwalo gwa bhando twe nabhalekekewa uhakaho. ");
INSERT INTO dne_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ninobholela, nanywe jhe kabhele divaye jha chabibo ade lichiko lela pimpala kunywegha divaye yono na mangota mu Unahota gwa Tate gwango.” ");
INSERT INTO dne_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pubhajhomolila kujhemba nhwambo gwa kunnomba Chapanga, bhajhakubhoka na kujhenda ku kitombe chuku Micheitune. ");
INSERT INTO dne_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Peniya Yecho ajhakwalobholela bhabholwa bhake, “Uhiko ghongo mangota mabhoha namaha iholo na nenga, nhwalo Majhandiko gha Chapanga ghilonge, ‘Nanityala nnucha mambelele, na mambelele gha likunde naghapechengana.’ ");
INSERT INTO dne_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nambo pumbala kuyoka kuhumii kubhawile, naninongolela kujhenda ku Galilaya.” ");
INSERT INTO dne_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petile ajhakunnobholela Yecho, “Hata bhange bhabhehe na iholo na kunneke, nenga natubhaha pamonga, naninekajhe.” ");
INSERT INTO dne_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yecho ajhakunobholela, “Ninobholela chakaka, uhiko ghongone lijhogholo nakubhekajhe, mwenga naunganila patato.” ");
INSERT INTO dne_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petile ajhakunyanguu, “Nanikana ng'o hata kuwegha, natuhwa pamonga.” Na bhabholwa bhange bhala bhoha bhajhakulonge helahela. ");
INSERT INTO dne_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Peniya Yecho ajhakujhenda pamonga na bhabholwa bhake chehemo jhikemwa Getechemane, ajhakwalobholela bhabholwa bhake, “Ntamangane pamba nenga nijhenda palonge pala kunnyopa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ajhakulongohana na Petile na yana ibhele ya Chebedayo, ajhakutumbuu kubhehe ngolongonde na mang'ahiko kumwojho, ");
INSERT INTO dne_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","peniya, Yecho ajhakwalobholela, “Mwojho gwango ubhii ngolongonde ngita nipala kuwegha. Ntamengane pambano nkeluwe pamonga na nenga.” ");
INSERT INTO dne_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ajhakujhenda palonge pandina, na ajhakukigwiya pahe mangukama, ajhakunyopa Chapanga, “Tate gwango, anda iwechekana, kibaba chenjeno cha malagho kimambale, nambo chi chinipala nenga, nambo chimipala mabhene.” ");
INSERT INTO dne_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pabhajhendilila bhabholwa bhake, ajhakwakolela bhagholwike. Bhahe, ajhakunnyimuha Petile na kunkonya, “Ma Simone, ngholwike? Uhotwijhe kukeluha na nenga pamba nobe lichaa limo?” ");
INSERT INTO dne_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nkotoka kugholoka na munyopengane Chapanga amambahe nkotoka kujhingii mumajhighanikilo, nhwalo uhuke ndi upala, nambo yegha itotokalile. ");
INSERT INTO dne_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ajhakujhenda jha ubhele kunyopa Chapanga, “Tate gwango, anda ichindikine kibaba chenje cha malagho kumbeta nenga changanywegwa, bhahe, limipala lihengeka.” ");
INSERT INTO dne_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ajhakwajhendelela kabhele, ajhakwakolela bhamela bhagholwike, miho ghabhe ghamela ghina lugwenio. ");
INSERT INTO dne_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bhahe, Yecho ajhakwaleka, na kujhenda kunyopa Chapanga mala jha utato kulonge malobhe ghagha. ");
INSERT INTO dne_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Peniya ajhakwajhimuwa bhabholwa bhake na kwalobholela, “Bho, Mwamela ngholwike na kupomolela? Nnolekehe, lichaa lyenio libhandikile, ngoheno Mwana gwa Mundo nabhankamuwa mu mabhoko gha bhando bhubhabhii na uhakaho. ");
INSERT INTO dne_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nnyimukane, tijhangana. Dolekeya, ahika mundo jhola jwapala kunyambila.” ");
INSERT INTO dne_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bhahe, Yecho pajhandilila kulonge nabho papa ajhakuhika Yuda, jhumo pakate jha bhabholwa bhake kome na bhabhele. Pamonga jwenio bhakahikite bhando twe bhubhabhii na mapanga na indukwa bhibhakatumitwe na akapiya matambiko bhakolo na ighogholo ya bhando. ");
INSERT INTO dne_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Bhahe, Yuda jhola jwapala kunyambila Yecho, ajhakwalangiya nginyililo jhenje, “Mundo jhunimpala kunkumbatila ndi umanya jhojho, mukamula.” ");
INSERT INTO dne_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bhahe, Yuda ajhakuheghelela Yecho na kunobholela, “Mbukwa, Mmola.” Peniya ajhakunkumbatila. ");
INSERT INTO dne_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yecho ajhakunnobholela, “Makoche, unhenge chihikita kuhenga!” Papa bhando bhala bhajhakuhika na kukamula Yecho, na kumeka pahe jha ulonda gwabhe. ");
INSERT INTO dne_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jhumo jha bhala bhubhakibha na Yecho ajhakuholomola upanga gwake na kuheketa lichikilo lya ntumiche jwa Mpiya litambiko nkolongwa. ");
INSERT INTO dne_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yecho ajhakunnobholela Petile, “Mmujhiche upanga gwino kuntohila, nhwalo jhojhoha jwakoma kwa upanga, nahwa kwa upanga. ");
INSERT INTO dne_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bho, pimihambuka ngahotwiijhe kunyopa Tate gwango na jwenio nganetii papa makunde kome na mabhele gha akakomana ngondo ndi akatumiche bha kunane kwa Chapanga? ");
INSERT INTO dne_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bhahe, naghatimila bhole majhandiko gha Chapanga ghighalongela ghanga ghipalwa ghapitele?” ");
INSERT INTO dne_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lichaa lelelene Yecho ajhakulilobholela lilongo lya bhando lela, “Bho, nhwalo gwa nike uhikita kungamuu kwa mapanga na indukwa ngita nenga jwandwekwile lilaghalikilo? Machiko ghoha pumbipikiya pa Nyumba jha Chapanga kubhola, na mangota mukangamwii jhe. ");
INSERT INTO dne_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nambo ghatendika ghanga, malobhe ghighalongilwa na milondole bha Chapanga ghalenganile.” Peniya, bhabholwa bhake bhoha bhajhakunneka na kutila. ");
INSERT INTO dne_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bhahe, bhando bhubhakakamwii bhala bhajhakumupeleka Yecho ukajha kwa Kayafa, jwakibha Mpiya litambiko nkolo, kwenio bhakakonganike bhabhola bha Malaghalikilo na ighogholo. ");
INSERT INTO dne_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petile ajhakunkengamila Yecho chukutale ade ajhakujhingii nkate jha lwane lwa Nkolo jwa bhapiya litambiko. Ajhakujhingii nkate pamonga na akalonda apata alole ghighapala kutendeka. ");
INSERT INTO dne_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bhahe, akapiya matambiko bhakolo bha pa bwalo bhajhakupalaha matakalilo ghuwange panane jha Yecho bhankome, ");
INSERT INTO dne_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","nambo bhakaliwejhe lyalemwite, pamonga na kuhika kwa bhando twe bhibhalongila uwange. Na pakujhomolela bhajhakuhika bhando bhabhele, ");
INSERT INTO dne_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","bhalongila, “Mundo jhonjo alongila. ‘Nihoto kuitilulana Nyumba jha Chapanga na lichiko lya utato kulichenga kabhele.’ ” ");
INSERT INTO dne_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mpiya litambiko nkolo ajhakujhema palonge pa bwalo na kunkonya Yecho, “Bho, nhwalo gwa nike mitama nuu? Bho, bhando bhamba bhatakalila kwa kilebhe ghane?” ");
INSERT INTO dne_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nambo Yecho ajhakubhehe nuu. Mpiya litambiko nkolo ajhakunobholela, “Ninapanikii kwa liina lya Chapanga gwino jwabhii ghome, mutulobholele anda mwenga ndi Kilichitu Nkomboche, Mwana gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yecho ajhakujhanguu, “Mwenga ndi milongela. Nambo pamonga na gheniya, ninobholela mangota namumona Mwana gwa Mundo atamite lubhoko lwalelo lwa Bhambo jwabhii na likakala. Akahika mumahunde gha kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Peniya Mpiya litambiko nkolo ajhakujwepula ligwanda lyake, ajhakulonge, “Mundo jhonjo anigha Chapanga! Tupala ndeka mundo jhonge alongele, ngoheno mabhene nnyohine maligho ghake. ");
INSERT INTO dne_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mangota bho, mihola nike?” Na bhene bhajhakujhanguu, “Alemwite, ipalwa akomwe!” ");
INSERT INTO dne_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Peniya ndi bhajhakunhunii mata kumiho, bhajhakuntyala mbalamande lapu. Bhange pubhajhendilila kutyala, ");
INSERT INTO dne_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","bhalongila, “Ma Kilichitu! Nnotele ngoheno ghane jwatyalite!” ");
INSERT INTO dne_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petile akatamite mulwane. Bhahe, ntumiche jhumo mwikeghe ajhakunyendelela na kulonge, “Mwenga helahela mukibha pamonga na Yecho jwa ku Galilaya.” ");
INSERT INTO dne_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Petile ajhakukana palonge jha bhando bhoha alongila, “Chimulonge manyitejhe.” ");
INSERT INTO dne_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Petile papitita panja jha litangala lya ubhegho, ntumiche jhonge mwikeghe ajhakumona na kwalobholela bhala bhubhakibha pala, “Mundo jhonjo bhakibha bhoha na Yecho jwa ku Nachalete.” ");
INSERT INTO dne_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petile ajhakukana kabhele kwa kukilapanikiya, “Nikilapanikii nenga niumanye jhe mundo jhonjo.” ");
INSERT INTO dne_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lichaa lyandina, bhando bhubhakajhemite pala bhajhakunyendelela Petile na kunobholela, “Chakaka, mwenga ndi pakate jhabhe, nhwalo hilu malongelo ghino milandana!” ");
INSERT INTO dne_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Papa Petile ajhakutumbuu kukilongolela kwa kukilapanikiya alongila, “Mbamba ingome, niumanye jhe mundo jhonjo!” Na papa lijhogholo lijhakubheka. ");
INSERT INTO dne_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Petile ajhakukomboka malobhe ghalongila Yecho, “Lijhogholo nakubhekajhe naunganila patato.” Bhahe, ajhakupita panja, na kulela kwa ungolongonde hake. ");
INSERT INTO dne_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pukuchila tugha, akapiya matambiko bhakolo bhoha na akanahota bha bhando bhibhakajheketii Yecho akomwe. ");
INSERT INTO dne_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bhajhakunpyeneneka minyonyolo, na kutola na kumpeleka kwa Pilatu, jwakibha nduna jwa kilambo jwabhekitwe na nkolo jwa ku Loma. ");
INSERT INTO dne_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Peniya Yuda jhola jwanyambila Yecho, pamanyita njwe kubhehe Yecho bhahadabwile, ajhakulela na kwabhujhichila mbijha yabhe kwa akapiya matambiko bhakolo na anakahota ipande hela makome matato gha feza. ");
INSERT INTO dne_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ajhakwalobholela, “Nemwite kwa kunyambila mundo jwangalemwa akomwe!” Nambo bheniya bhajhakujhanguu, “Twenga tuhenge nike ngohe, bho, lyenio lino mwenga?” ");
INSERT INTO dne_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yuda ajhakutaghila ipande ya feza pa Nyumba jha Chapanga, ajhakupita na kujhenda kukikongela. ");
INSERT INTO dne_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Akapiya matambiko bhakolongwa bhajhakulokota mbijha hela nu kulonge, “Yamaha ndeka kuhangalana na mbijha ya Nyumba jha Chapanga mu kihukilo chimo, nhwalo ndi mbijha ipatikine kwa ndela jha miyahe.” ");
INSERT INTO dne_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bhahe, bhajhakujheketelana mbijha yenio, bhahemelela nng'onda gwa undope gwa ibhegha gwa kuchikila akaghene. ");
INSERT INTO dne_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ndi nhwalo ade deleno nghonda gwenio ukemwa, “Nng'onda ghupatikine kwa mbijha jha miyahe.” ");
INSERT INTO dne_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Naha ndi chighatimile malobhe gha Yelemiya jwakibha nnondole jwa Chapanga, “Bhakatoile ipande ya mbijha makome matato malepo ghibhabhekite bhando bha Ichilahele gha mundo jwenio, ");
INSERT INTO dne_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","bhajhakuhemelela nghonda gwa kubhombe ibhegha, anda Bhambo chanaghalikiye nenga.” ");
INSERT INTO dne_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yecho ajhakuhikichwa palonge jha Pilatu, jwakibha nduna jwabhekitwe na ulongoche gwa ku Loma. Bhahe, Pilatu ajhakunkonya, “Bho, mwenga ndi munahota nkolongwa jwa Akayahude?” Yecho ajhakunyanguu, “Mwenga ndi milongela.” ");
INSERT INTO dne_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nambo Akapiya matambiko bhakolo na ighogholo pubhakibha bhantakalila, Yecho akajhangwii jhe lilobhe. ");
INSERT INTO dne_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bhahe, Pilatu ajhakunkonya kabhele, “Bho, nnyohine jhe gheniya matakalilo ghibhalongela?” ");
INSERT INTO dne_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nambo Yecho akajhangwii jhe lilobhe, na Pilatu ndi nduna ajhakuhechuka hake. ");
INSERT INTO dne_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kila unyagho gwa Pachaka, Pilatu ipalwa kwadindulila mpungwa jhumo jhubhakampahile bhando. ");
INSERT INTO dne_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na mu machiko gheniya pakibha na mupungwa jhumo jwamanyikina hake, liina lyake Yecho Balaba. ");
INSERT INTO dne_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bhahe, bhando pubhakonganika pamonga, Pilatu ajhakwakonya, “Bho, mipala nidundulila ghane pakate jha bhamba bhabhele, Balaba amu Yecho, jwakemwa Kilichitu?” ");
INSERT INTO dne_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatu alongila naha akamanye hotu kubhehe bhapelika kwake nhwalo gwa wiho gwabhe. ");
INSERT INTO dne_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatu patamita pa kigoda cha luhadabulo, nhwana mundo ajhakunetela lilobhe, “Nkotoka kukihangalana pa mihalo jha mundo jwenio jwa umbone, nhwalo deleno naghite hake mukulotela kwa nhwalo gwake.” ");
INSERT INTO dne_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Akapiya matambiko bhakolo na anakahota bhajhakukokolekeya bhando bhanyope Balaba adindulilwe na Yecho akomwe. ");
INSERT INTO dne_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nambo Pilatu ajhakwakonya, “Bho, mipala nidindulile ghane pakate jha bhamba bhabhele?” Na bhene bhajhakunyanguu, “Mutudindulile Balaba!” ");
INSERT INTO dne_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatu ajhakwakonya kabhele, “Bho, ngoheno mipala ndende nike Yecho jwakemwa Kilichitu?” Bhoha bhajhakujhanguu bhalongila, “Abhambwe panchalaba!” ");
INSERT INTO dne_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nambo Pilatu ajhakwakonya kabhele, “Bho, kilebhe ghane chateile? Bho, kilebhe ghane kibhoho chateile?” Bhene bhajhakuchocha kuchobhela bhalongila, “Abhambwe panchalaba!” ");
INSERT INTO dne_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bhahe, Pilatu pamanyita nahotojhe kutenda kilebhe chochoha, na ihoto kupitila bhulo, ajhakuto mache kukuha mu mabhoko palonge jha lilongo lya bhando alongila, “Nenga mii ndela jhimojhe na mangota mukunkoma mundo jhonjo, gheniya ghino mabhene.” ");
INSERT INTO dne_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bhando bhoha bhajhakulonge, “Miyahe jhake ibhaha panane jhito na panane jha yana hito!” ");
INSERT INTO dne_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Peniya Pilatu ajhakwadindulila Balaba kuhumii mukipungo. Na kwalongolela bhakomana ngondo bhantyale yato Yecho na kummoha abhambwe panchalaba. ");
INSERT INTO dne_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Peniya akakomana ngondo bha Pilatu bhajhakunyingiya Yecho nkate jha Liboma lya nduna, na likunde lyoha lya akakomana ngondo bhajhakuntindila mwono. ");
INSERT INTO dne_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bhajhakuhula ngobho yake, na kuwalikiya ngobho ya unahota ya lange ngele. ");
INSERT INTO dne_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Peniya bhajhakuhingwa hingo jha mibha na kumeka pamuto, na bhajhakumekela nkongocho gwa nnahe lubhoko lwalelo, bhajhakutama makilikite palonge jhake kongo bhatendela chanake bhalongila, “Mbukwa munahota nkolongwa jwa Akayahude!” ");
INSERT INTO dne_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bhajhakunhunii mata, na kutola nnahe ghola na kunkong'ondela kumuto. ");
INSERT INTO dne_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pubhajhomolila kuntende chanake, bhakanhulite ngobho jhela jhibhakahwaliche, na kuhwalicha ngobho yake, bhahe, bhajhakumpeleka bhakamambe panchalaba. ");
INSERT INTO dne_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pubhakibha bhajhahwila, bhajhakummona mundo jhumo jwabhelukilwe ku chenda jha ku Kilene, liina lyake Simone, bhajhakukamulikiya augheghe nchalaba gwa Yecho. ");
INSERT INTO dne_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bhajhakuhikicha chehemo jhikemwa Goligota, mana jhake “Chehemo jha libhonge lya muto,” ");
INSERT INTO dne_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","bhajhakumpela divaye jhihangalwine na kilebhe chikibhabha. Nambo Yecho papahita, ajhakukana kunywegha. ");
INSERT INTO dne_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bhajhakumamba panchalaba, peniya bhajhakubhaghana ngobho yake kwa kahumbuumbu nnobhole. ");
INSERT INTO dne_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Peniya, bhajhakutama chukutale kunnonda. ");
INSERT INTO dne_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Panane jha nchalaba bhajhakubheka kibao chikijhandikwe naha, “Jhonjo ndi Yecho, mu Nahota nkolongwa jwa Akayahude.” ");
INSERT INTO dne_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Helahela pakibha na bhando bhabhele bhubhakibha bhatoila kwa makakala ilebhe ya bhando, bhakabhambitwe mu michalaba jhabhe. Jhumo lubhoko lwalelo lwa Yecho na jhonge lubhoko lwa ngejha lwa Yecho. ");
INSERT INTO dne_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bhando bhubhapetita peniya bhajhakunnigha maligho kongo bhakinicha muto jhabhe bhalongila, ");
INSERT INTO dne_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Mwenga jhunongila nantilulana Nyumba jha Chapanga na machiko matato nachenga! Ngohe mukikombole mabhene anda mwenga chakaka ndi Mwana gwa Chapanga! Mukihuluwe kuhumii pa nchalaba!” ");
INSERT INTO dne_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pamonga na gheniya Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo na akanahota bhajhakuntendela chanake Yecho bhalongila, ");
INSERT INTO dne_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Abhakombwila ajhake, nambo jwenio abhii chepa kukikombola! Jwenio ndi munahota nkolongwa jwa Akaichilahele, ngoheno ahuluke kuhumii pa nchalaba, na twenga natunyeketela. ");
INSERT INTO dne_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ahobholila Chapanga na alongila hote jwenio ndi Mwana gwa Chapanga, bhahe, ngoheno Chapanga ankombole anda chakaka ampahile.” ");
INSERT INTO dne_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Helahela bhubhapokita ilebhe kwa makakala pubhabhambitwa pabhandikii Yecho panchalaba bhajhakunigha. ");
INSERT INTO dne_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pihikila muhe jha chaa chita ade chaa ticha, lubhendo lujhakubhehe tyoo pa kilambo choha. ");
INSERT INTO dne_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Puhikita chaa ticha Yecho ajhakubohoma lilobhe likolongwa, “Eloe, Eloe, lama chabakitane,” mana jhake, “Chapanga gwango, Chapanga gwango nhwalo gwa nike uneka?” ");
INSERT INTO dne_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nambo bhando bhange bhibhakajhemite pahina pibhajhohina malobhe gheniya bhajhakulonge, “Inkema Eliya!” ");
INSERT INTO dne_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Papa jhumo pakate jha bhala ajhakubhutuka mbelo na kutola lidodoke, na kulichwiya mu divaye jhibhabha, na kuhibheka mu nahe. Ajhakutondobhekeya Yecho ajhakumpela anyweghe. ");
INSERT INTO dne_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nambo bhange bhajhakulonge, “Deka tulole, anda Eliya nahika kunkombola!” ");
INSERT INTO dne_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Bhahe, Yecho ajhakubohoma kabhele, na kuwegha. ");
INSERT INTO dne_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Papala lipanjiya lya Nyumba jha Chapanga lijhakujwepuka ipande ibhele kutumbulii kunane ade pahe, nnema ghoha ujhakulindimila, na mandalabho ghajhakumetukana, ");
INSERT INTO dne_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mambe ijhakubhehe mbe na bhando twe bha Chapanga bhubhakawile bhajhakuyokechwa, ");
INSERT INTO dne_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","na bhene, bhajhakupita mu mambe, pajhomolila kuyoka Yecho, bhajhakujhingii ku muche gwa Chapanga gwa nyahinyahi ndi Yeluchalemo, na bhando bhamahele bhajhakubhonekana. ");
INSERT INTO dne_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bhahe, nkolo jwa akakomana ngondo na bhala bhubhanondita Yecho pubhalolita nnindimilo gwa nnema na ghala ghoha ghighatendika, bhajhakujhoghopa hake bhajhakulonge, “Chakaka mundo jhonjo akibha Mwana gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chehemo jhene pakibha na akakeghe twe bhalingulila chukutale. Bheniya ndi bhala bhibhankengima Yecho kuhumii ku Galilaya, bhubhakibha bhanhengila. ");
INSERT INTO dne_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Pakate jhabhe bakibha Maliya jwa ku kilambo chuku Magidala, na Maliya majhe gwabhe Yakobu na Uchupo, na nhwana mundo Chebedayo. ");
INSERT INTO dne_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Puhikita kimiye, ajhakuhika mundo jwabhii na ilebhe mbwee, liina lyake Uchupo jwabhelwikilwe ku Alimataya. Jhonjo hele akibha mmolwa jwa Yecho. ");
INSERT INTO dne_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ajhakunyendelela Pilatu, kunyopa malelo gha Yecho. Bhahe, Pilatu ajhakunobholela, atole. ");
INSERT INTO dne_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Uchupo ajhakutola malelo ghala, na kubhilingilila chanda, ");
INSERT INTO dne_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Uchupo ajhakughoneka malelo gha Yecho umambe jhene yono jwenio Uchupo akakilenganikiye kwa kukihokonyolela mu lindalabho. Ajhakubhilimbiya lighanga likolongwa pa nnyango gwa mambe na ajhakubhoka. ");
INSERT INTO dne_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na Maliya jwa ku kilambo chuku Magidala na jhola Maliya jhonge bhajhakutama pala kuilolekeya mambe jhela. ");
INSERT INTO dne_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lichiko lilikengima, yane lichiko lya Kupomolela, akapiya matambiko bhakolo na Mapwalichayo bhajhakunyendelela Pilatu, ");
INSERT INTO dne_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","bhajhakunobholela, “Munahota, tukomboka jwatukolwiya akalongile pakibha ghome ete, ‘Mulichiko lya utato nayoka kabhele.’ ");
INSERT INTO dne_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bhahe, malobholela akalonda, bhakalonde mambe ade machiko matato. Ikoto kulekwa bhabholwa bhake bhankotoka kuhika na kunyibha na kwalobholela bhando ayokite. Uwange ghongo gwa kujhomolela nahubhaha gwanganandela kupeta ghola gwa kutumbula.” ");
INSERT INTO dne_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatu ajhakwalobholela, “Nkwete akalonda, nnyendengane mukalonde chimipala.” ");
INSERT INTO dne_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bhahe, bhajhakujhenda na kuilonda mambe, bhajhakubheka unepo panane jhake na kwaleka peniya akalonda mambe. ");
INSERT INTO dne_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lichiko lya Kupomolela pulipetita, putiputi lichiko lya lichiko lya jumapile, Maliya jwa ku kilambo chaku Magidala na Maliya jhonge jhola bhajhakujhenda kuilolekeya mambe jhela. ");
INSERT INTO dne_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pajhakupitila nnindimilo nkolongwa gwa nnema, ntumiche jwa kunane kwa Chapanga jwa Bhambo ajhakuhuluka kuhumii kunane. Ajhakulibhilimbiya lighanga paupele jha mambe jhela, na kulitamila. ");
INSERT INTO dne_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jwenio alangila ngita lumule lwa mbamba na ngobho yake ikibha nhuo ya mbuu. ");
INSERT INTO dne_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Akalonda bhubhalondita mambe bhala bhajhakuhechuka hake, bhajhakubhehe ngita bhatehi kuwegha. ");
INSERT INTO dne_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ntumiche jwa kunane kwa Chapanga jhola ajhakwalobholela akakeghe bhala, “Mangota nkotoka kuhechuka, nhwalo nimanya mipalaha Yecho jwakabhambitwe panane jha nchalaba. ");
INSERT INTO dne_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Abhii jhe pambano, nhwalo ayokite ngita chalongila. Nnolekehe pakagholwike. ");
INSERT INTO dne_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bhahe, nnyende kajhombe makalobholele bhabholwa bhake kubhehe Yecho ayokite kuhumii kubhawile, na jwenio nabhalongolela kujhenda ku Galilaya. Ndi nabhammona kwenio, hena, nenga nikannobhalile njwe mangota.” ");
INSERT INTO dne_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bhabhii mu jhoghopa na luhangano lukolongwa, akakeghe bhajhakubhoka kajhombe pa mambe na kubhutuka mbelo kwalobholela bhabholwa bhake. ");
INSERT INTO dne_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Papalapala Yecho ajhakwapitila pwitu akakeghe bhala na kwajhambucha, “Uteeke ubhaha kwino.” Akakeghe bheniya bhajhakuheghelela na kunkamuu magholo na kunyinamila. ");
INSERT INTO dne_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Peniya Yecho ajhakwalobholela, “Nkotoka kujhoghopa. Nnyende makalongolele akalongo bhango bhajhende ku Galilaya, ndi nabhamona koko.” ");
INSERT INTO dne_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Akakeghe bhala pubhakibha undela kukijhendela, bhange akalonda bha mambe jhela bhajhakujhenda ku muche kwalobholela Akapiya matambiko bhakolo ilebhe yoha ipitile. ");
INSERT INTO dne_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bhahe, bhakolo bha bhapiya matambiko bhajhakukongana pamonga na akanahota, pibhajhomolila kulonge, bhajhakwapekeya akalonda bha mambe bhala mbijha twe, ");
INSERT INTO dne_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na kwalaghalikiya bhalongila, “Mangota nnongela naha, bhabholwa bhake bhakahikite kilo kujhibha malelo ghake na twenga tukibha lughono tipitipi. ");
INSERT INTO dne_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na anda nduna ajhohine lilobhe lende, twenga natulongela nako na mangota name ndeka mu malagho.” ");
INSERT INTO dne_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bhahe, akalonda bhala bhajhakuitola mbijha hela, na bhajhakuhenga ngita chibhabholitwe. Malobhe gheniya ghajhakuchobhela pakate jha Akayahude na ade ngoheno. ");
INSERT INTO dne_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Peniya bhabholwa kome na jhumo bhala bhajhakujhenda ku kitombe chikibhii ku Galilaya, ngita chakabhalaghalikiye Yecho ");
INSERT INTO dne_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pibhammonita Yecho bhajhakunyinamila, nambo bhange pakate jhabhe bhakibha na kiholo. ");
INSERT INTO dne_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yecho ajhakwaheghelela pahina na kwalobholela, “Mbatite ukindendeke ghoha kunane kwa Chapanga na pannema pano. ");
INSERT INTO dne_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bhahe, nnyendengane mu ilambo yoha mukalitangache Lilobhe lya Chapanga kwa bhando bhoha, makatende kubhehe bhabholwa bhango, kongo mabaticha kwa liina lya Tate na lya Mwana na Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na kwabhola kughajheketela malobhe ghoha ngita chininaghalikiye mangota. Nenga mii pamonga na mangota kwa machiko ghoha, ade pukupehekeya nnema.”");
INSERT INTO dne_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ghangano ndi Malobhe gha Mbone gha Yecho Kilichitu, Mwana jwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ikatumbwii ngita chikajhandikwe mukitabo cha nnondole jwa Chapanga Isaya, dolokeya, “Chapanga akalongii, ‘Nanintuma jumbe gwango atengeneche ndela jhino.’ ");
INSERT INTO dne_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mundo ilalama kanonoho kunjenga, alongila, ‘Ntengeneche ndela jha Bhambo, nnyocha ndela jhake!’ ” ");
INSERT INTO dne_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yohane Mbatichajhe ajhakujhenda kunjenga, atangachila bhando na kwabaticha. Abhalobholila bhando, “Muuleke uhakaho na kubatichwa. Chapanga nanekekeya uhakaho gwino.” ");
INSERT INTO dne_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bhando bhamahele kuhumii ku kilambo chaku Yudeya na muche gwa ku Yeluchalemo bhakajhahwii kwa Yohane kunyokanikiya na kulonge uhakaho ghubhatehila na jwenio Yohane ajhakwabaticha mulukemba lwa ku Yolodane. ");
INSERT INTO dne_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane ahwalita magwanda ghighatenganichwe kwa mangoma gha kinyama jwakemitwa ngamiya na luhunga lwa limbendela mukibhuno chake. Na kulye madidima na bhuche. ");
INSERT INTO dne_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohane akatangachii bhando, “Jwahika ngohengohe payeto jhango, jhuna likakala kumbeta nenga, nitope ndeka kujhinama na kubhopo lughojhe lwa maghubache ghake. ");
INSERT INTO dne_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nenga nibaticha kwa mache, nambo jwenio jwahika chabaticha kwa Uhuke gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Machiko gheniya Yecho akahikite kubhoke ku Nachalete ku kilambo cha ku Galilaya, na kubatichwa na Yohane mulukemba lwa ku Yolodane. ");
INSERT INTO dne_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Papa tugha Yecho papitita umache, ajhakulibhona lihunde lidindwike, Uhuke gwa Chapanga ujhakuhuluka ngita ngunda. ");
INSERT INTO dne_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na lilobhe lya Chapanga kuhumii kunane kwa Chapanga, “Lilongila mwenga ndi ma Mwanango jhunimpahile, anganichwe na mwenga.” ");
INSERT INTO dne_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Papalapala, Uhuke gwa Chapanga ujhakunongocha kujhenda kunjenga. ");
INSERT INTO dne_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Akatamite kwenio machiko makome ncheche, ajhakujhighanikilwa na Limbembela akibha na inyama ya kumanyahe, nambo akatumiche bha kunane kwa Chapanga bhajhakuntangatila. ");
INSERT INTO dne_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yohane patabhitwa mukipungo, Yecho ajhakujhenda ku Galilaya, na kwatangachila bhando Malobhe gha Mbone gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Akalongii, “Machiko gwa Unahota gwa Chapanga ghahikite. Muuleke uhakaho gwino na kuhenga ghambone na kughahobholela Malobhe gha Mbone!” ");
INSERT INTO dne_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yecho patyangita umbwane jha ku Galilaya, ajhakwabhona akalongo bhabhele bhapyeya homba Simone na nnongo mundo Anduleya, bhapyehita homba kwa lwaho. ");
INSERT INTO dne_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yecho ajhakwalobholela, “Ungengame nenga nanimmola kwapyeha bhando ngita hele chimupyeya homba.” ");
INSERT INTO dne_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Papalapala bhajhakuleka lwaho lwabhe na kunkengama. ");
INSERT INTO dne_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yecho Pahikita palonge, ajhakwabhona Yakobu na Yohane nnongo mundo Zebedayo, bheniya bhakibha nkate jha mungalabha jhabhe bhalenganikila lwaho lwabhe. ");
INSERT INTO dne_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yecho ajhakwakema, na bhene bhajhakunneka tate gwabhe Zebedayo bhibhahenga mahengo mwenio mungalabha, na kunkengama. ");
INSERT INTO dne_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yecho na bhabholwa bhake bhakahikite pabomane jha ku Kapelenaumo, likibha Lichiko lya Kupomolela, ajhakujhingii munyumba jha kukonganikii Akayahude na kutumbuu kubhola Malobhe gha Mbone. ");
INSERT INTO dne_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bhando bhoha bhubhanyokanikiya bhakahechwike chabholita, nhwalo abholita ndeka ngita chibhabholita bhabhola bhabhe bha Malaghalikilo, nambo abholita ngita jhuna ukindendeke. ");
INSERT INTO dne_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Papalapala, mundo jhumo ajhakujhingii nkate munyumba jha kukonganikii Akayahude achikii nchuka, ajhakutumbuu kulalama. ");
INSERT INTO dne_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Alongila mmii na nike na twenga, mwenga Yecho bhuku Nachalete? Bho, uhikite kutukoma? Nimanyite mwenga maghane. Mwenga manyahinyahi kuhumii kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yecho ajhakuupwatalila nchuka alongila, “Tama nuu! Mummoke mundo jhonjo!” ");
INSERT INTO dne_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nchuka ajhakunyuanyua kwa makakala na kulela kanonoho, na kubhoka. ");
INSERT INTO dne_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bhando bhoha bhakakangiche, bhajhakukonyana, “Ghanga mambu ghane kabhele? Bho, mabholo mayono? Mundo hojho ukindendeke gwa kuipwatalila michuka na kunnyeketela!” ");
INSERT INTO dne_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bhahe, Malobhe gha Yecho ghajhakuchobhela kajhombe ku kilambo cha ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yecho na bhabholwa bhake, pubhapitita munyumba jha kukonganikii Akayaude, bhajhakujhenda kajha kwa Simone na Anduleya. Yakobu na Yohane bhakalongohine nabho. ");
INSERT INTO dne_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bhahe, nkohano mundo Simone, akibha agholwike pakindanda, atenda kulwalwa. Papalapala Yecho pahikita bhajhakunnobholela ulwalo gwa majhe. ");
INSERT INTO dne_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Papa Yecho ajhakujhenda kwa majhe jhola, ajhakukamuu lubhoko na kunyinua. Ulwalo ghola ajhakulama, na jwenio ajhakutumbuu kwatelekela. ");
INSERT INTO dne_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Palitipika lyobha kimihe, bhando bhajhakwaleta bhoha bhibhalwalwa na bhibhachikile na michuka kwa Yecho. ");
INSERT INTO dne_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Bhando bhamahele bha kubomane bhakakonganike palonge jha lubhanja lwa nyumba. ");
INSERT INTO dne_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yecho akalamiche bhando bhamahele na bhibhakibha na ulwalo ghoghoha, kabhele ajhakubhapiya bhibhakibha na michuka jhamahena, akabhapekii jhe pwache jha kulonge nhwalo bhakaumanyite jwenio ndi ghane. ");
INSERT INTO dne_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pantondogholo, kabula jha kuchegha, Yecho ajhakujhenda pakiyepela ajhakutumbu kunyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simone na ajhake bhakajhahwii kumpalaha Yecho. ");
INSERT INTO dne_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pubhammonita, bhakannobholile, “Kila mundo impalaha mwenga.” ");
INSERT INTO dne_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yecho abhalobholile, “Tujhende muchenda henge kutangacha Malobhe gha Chapanga, mana hikite kuhenga lihengo lyenio.” ");
INSERT INTO dne_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bhahe, ajhakujhenda kubomane jha ku Galilaya atangicha malobhe gha Chapanga munyumba jha kukonganikii Akayahude kongo abhengita nchuka. ");
INSERT INTO dne_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lichiko limo mundo jhumo jwakwete malohe akahikite kwa Yecho, ajhakutama makilikite, kumpembelekeya, “Anda mipala, unyelebhula nenga!” ");
INSERT INTO dne_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yecho ajhakummone kiya, ajhakuhatambuu lubhoko lwake, ajhakunkamula na kunongelela, “Nipala! Nnyelebhuke!” ");
INSERT INTO dne_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Papalapala malohe ajhakulama mundo jhola. ");
INSERT INTO dne_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bhahe, Yecho ajhakunnobholela, ajhende na kongo ankanikihe, ");
INSERT INTO dne_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Dolokeya, “Nkotoka kunobhole mundo jhojhoha, nambo nnyende mukakilangiye kwa mupiya litambiko jwa Chapanga, na mpeleke litambiko lino kwa nhwalo gwa kujhelebhuka kwino ngita chalaghalikie Mucha nhwalo gwa kwalangii bhando bhoha nnamite.” ");
INSERT INTO dne_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nambo mundo jhola ajhakujhenda na kutumbuu kutangacha malobhe kila chehemo, na kulonge mambu twe, na Yecho akibha pakiyepela. Akibha panja, bhando bhakannyendelile kuhumii kila kimbokotole. ");
INSERT INTO dne_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pughapitita machiko ghandina, Yecho akabhujhite ku Kapelenaumo, bhando bhakapatite malobhe Yecho abhii ukajha. ");
INSERT INTO dne_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bhahe, bhakahikite bhando bhamahele napwache ikibha jhe pannyango bhakatwelile ade panja. Yecho akibha atangacha Malobhe gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Papalapala bhakannetite mundo jwatengwike bhanyeghite bhando ncheche bhampelika kwa Yecho. ");
INSERT INTO dne_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nhwalo gwa kujholoka bhando, bhakahotwii ndeka kumandikii Yecho. Bhahe, bhakatenganiche lihoto panane jha pakipaghalo pabhii Yecho. Pubhajhomolila kuhotola bhajhakuhuluwa jwalwalwa mu mpacha gwake. ");
INSERT INTO dne_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yecho palolita kihobholelo chabhe, ajhakunnobholela mundo jwatengwike, “Mwanango, nnekekiwe uhakaho gwino.” ");
INSERT INTO dne_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bhabhola bhange bha Malaghalikilo gha Mucha bhibhakatamite bhajhakutumbuu kuwacha kumiojho jhabhe, ");
INSERT INTO dne_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nhwalo gwa nike mundo hojho kulonge naha? Atenda kulapanikiya anigha Chapanga! Abhii jhe mundo jwahoto kulekekeya uhakaho, nambo Chapanga kanjika ndo.” ");
INSERT INTO dne_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Papalapala Yecho akamanye chibhahola kumiojho jhabhe, ajhakwakonya, “Nike chimiwacha naha kumiojho jhino? ");
INSERT INTO dne_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Lihengo ghane lilijhojwike, kunongelela mundo hojho jwatengwike, ‘Uhakaho gwino ulekekiwe,’ amu kulonge, ‘Nnyeme! Tola mpacha gwino nnyende?’ ");
INSERT INTO dne_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bhahe, nipala umanye naha, Mwana gwa Mundo jhuna ukindendeke gwa kulelekeya uhakaho pannema.” Peniya anongalile mundo jwatengwike jhola, ");
INSERT INTO dne_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ninobholila, jhinuka, tola mpacha gwino nnyende kajhino!” ");
INSERT INTO dne_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na bhando bhoha pubhannolakiya jwakatengwike jhola akajhinuka, papalapala ajhakughegha mpacha gwake na kujhenda. Bhando bhoha bhajhakukangacha, bhajhakunnomba Chapanga. Bhalongila, “Tunawai jhe kulola ilebhe ngita henge!” ");
INSERT INTO dne_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yecho akajhahwii kabhele mupelemupele mwa lilabha. Bhando bhamahele bhakankengimile, na jwenio akatumbuu kwabhola malobhe gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pakibha atyangita, akamweine Lawe mwana gwa Alufayo, atamite panyumba jha kulepe kode. Yecho ajhakunnobholela, “Hika ungengame!” Lawe akajhemite, ajhakunkengama. ");
INSERT INTO dne_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Peniya Yecho pakibha atamite kajha kwa Lawe kulyegha. Akatola kode bhamahele na bhando bhibhakanwa bhibhakibha bhakankengime Yecho. Na bhamahele bhakatamite pamonga na Yecho bhalila na bhabholwa bhake. ");
INSERT INTO dne_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bhahe, Bhabhola bha Malaghalikilo bhibhakibha Mapwalichayo pubhalolita Yecho ilyegha pamonga na bhando bhina uhakaho, pamo na akatola kode, bhajhakwakonya bhabholwa bhake, “Bho, mulyegha na bhando ngita bhamba?” ");
INSERT INTO dne_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yecho akabhajhohine ajhakwalobholela, “Bhando bhangalwalwa bhipala ndeka nng'anga, bhibhalwalwa bhala tugha ndi bhibhamipala nng'anga. Nenga hikitejhe kwakema bhando bha umbone bhangengame, nambo bhando bhibhabhii akahakaho.” ");
INSERT INTO dne_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bhabholwa bha Yohane Mbatichajhe na bha Mapwalichayo bhakibha bhatehila kupunga kulyegha. Bhahe, bhando bhajhakunnyendela Yecho na kunkonya, “Nhwalo ghane bhabholwa bha Yohane na Mapwalichayo bhapungita, nambo mwenga bhino bhipunga ndeka?” ");
INSERT INTO dne_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yecho ajhakwajhanguu, “Bho, bhando bhibhalalikwe kuunyagho gwa ndowa bhahoto kupunga pamonga na nnyinamwale? Pubhabhii pamo na nnyinamwale ihoto ndeka kupunga. ");
INSERT INTO dne_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dolokeya lichiko nalihika nnyinamwale nabhejhe pamo, na lichiko lyenio nabhahotola kupunga. ");
INSERT INTO dne_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Abhii jhe mundo jwabhambakila kibhambo kubhoka mungobho nhyono na kuchonolela mukindukotuko. Anda atenda naha, kibhambo kiyono nakilombotoka kindukotuko chenie, na pala pupakibha pajwepwike napajhonjekeka. ");
INSERT INTO dne_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Abhii jhe mundo jwabheka divaye yono mulihako lilitukutwike. Anda atenda naha, divaye naitutumuka na kujwepula lihako lyenio, divaye naijhitika na lihako kujwepuka. Divaye yono ubheka mulihako liyono!” ");
INSERT INTO dne_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lichiko limo lya Kupomolela, Yecho pamonga na bhabholwa bhake bhajhakupeta mu mighonda jha mapemba. Pubhatyangita, bhabholwa bhake bhakatumbwii kukwanyula manjwanjwane gha mapemba. ");
INSERT INTO dne_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mapwalichayo bhajhakunnobholela Yecho, “Dolokeya! Bho, nhwalo gwa nike bhabholwa bhino bhihenga kilebhe chamaha jhe Lichiko lya Kupomolela?” ");
INSERT INTO dne_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yecho ajhakujhanguu, “Bho, mukachomitejhe ghahengita Daude pamonga na ajhake pubhakibha na njala? ");
INSERT INTO dne_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Daude akajhingii mu Nyumba jha Chapanga na kulyegha mabumunda ghighapihitwa litambiko kwa Chapanga. Lijhambu lende lihengika pakibha Abiatale Nkolo jwa Bhabhola. Bhibhatambika kanjika chabhe ndi bhalila mabumunda gheniya. Nambo Daude akalile, kabhele ajhakwapekeya akapiya matambiko ajhake.” ");
INSERT INTO dne_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bhahe, Yecho ajhakwalobholela, “Lichiko lya Kupomolela libhii kwatangatila bhando, chi bhando kulikengemila Lichiko lya Kupomolela. ");
INSERT INTO dne_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nambo Mwana gwa Mundo, ndi Bhambo jwa Lichiko lya Kupomolela.” ");
INSERT INTO dne_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kabhele Yecho ajhakujhingii munyumba jha kukonganikii Akayahude. Mwenio akibha mundo jwatengwike lubhoko. ");
INSERT INTO dne_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bhando bhange bhapaliya kihokola cha kunkamuu Yecho. Bhajhakuningulila anda chanamicha mundo Lichiko lya Kupomolela. ");
INSERT INTO dne_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yecho akannobholile mundo jwatengwike lubhoko jhola, “Nhwike palonge pano.” ");
INSERT INTO dne_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chakaka, akakonyite bhando, “Bho, nike chambone kuhenga Lichiko lya Kupomolela, kuntangatila amu kuntendela uhakaho? Kughombola ughome gwa mundo amu kunkoma?” Nambo bheniya bhakajhangwiijhe kilebhe. ");
INSERT INTO dne_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yecho akalolikii bhando kwa lilaka, peniya ajhakunyongeka kumwojho kwa kukokotoka kwa miojho jhabhe. Bhahe, Yecho akanobholile mundo jhola, “Atambula lubhoko!” Na jwenio ajhakuatambuu lubhoko lwake ajhakulama. ");
INSERT INTO dne_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Peniya Mapwalichayo bhakapitite panja, bhajhakukongana na bhando bha Helode na bhajhakupalaha ndela jha kunkoma Yecho. ");
INSERT INTO dne_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yecho pamonga na bhabholwa bhake, bhakajhahwii mupele mulilabha lya ku Galilaya na lilongo lya bhando likankengime, bhahumila ku Galilaya na ku Yudeya. ");
INSERT INTO dne_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bhando pubhajhohina ghoha ghateii, bhando mahena bhakahika kubhoka ku Yudeya na ku Yeluchalemo na ku Idumeya na chenda jhibhii kwiye jha lukemba lwa ku Yolodane na miche jha ku Tilo na ku Sidone. ");
INSERT INTO dne_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nhwalo gwa bhando kujholoka, Yecho akalobhalile bhabholwa bhake bhantengenechele ngalabha bhando bhakoto kunkangana. ");
INSERT INTO dne_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nhwalo alamiche bhando bhamahele, bhibhalwalwa bhoha bhajhakuheghelela bhapala kumpapaha. ");
INSERT INTO dne_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na bhando bhina michuka pubhamwonita, bhajhakugwegha palonge jhake na kulalama, “Mwenga ndi Mwana gwa Chapanga!” ");
INSERT INTO dne_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Nambo Yecho ajhakwapwatalila kwa likakala nchuka ukoto kwalobholela bhando jwenie ndi ghane. ");
INSERT INTO dne_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yecho akahobhike pakitombe, ajhakwakema jwabhapaii jwenio, na bhene bhajhakunyendela. ");
INSERT INTO dne_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jwenio akabhahagwii bhando kome na bhabhele, ajhakwakema akatenga. Ajhakwalobholela, “Nihagwii mangota mwenga kutama na nenga kwatangachii bhando Malobhe gha Mbone. ");
INSERT INTO dne_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Na mangota namaha na ukindendeke gwa kubhenga michuka.” ");
INSERT INTO dne_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bhamba ndi bhando kome na bhabhele bhakabhahagwii. Simone Yecho akampekihe liina lya Petile, ");
INSERT INTO dne_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobu na Yohane, bhana bha Chebedayo bheniya Yecho akabhapekihe liina Boanelige, mana jhake, “Bhando bhubhabhii ngita Ulumbilo na kwa malobhe ghange bhikemwa bhina kipyaho.” ");
INSERT INTO dne_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduleya na Filipu na Batulomayo na Matei na Tomache na Yakobu mwana gwa Alufayo na Tadayo na Simone jwakemita Chelote, mana jhake nkomanii kilambo chake. ");
INSERT INTO dne_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Na Yuda Ichikaliyote, jwanyambila Yecho. ");
INSERT INTO dne_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Peniya Yecho akajhahwii kajha, bhando bhamahele bhakakonganike kabhele ade Yecho na bhabholwa bhake bhakahotwii ndeka kulyegha. ");
INSERT INTO dne_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Akalongo bhake Yecho bhakajhohine malobhe, bhakajhahwii kuntola nhwalo bhalongela jhuna ngholoka. ");
INSERT INTO dne_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Na Bhabhola bha Malaghalikilo gha Mucha bhubhahumila ku Yeluchalemo bhakalongii, “Akwete Belezebule! Nkolo jwa michuka jwenio jwapiya likakala lya kubhenga michuka.” ");
INSERT INTO dne_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yecho akakemite, ajhakwalobholela kwa kulandanikiya, “Limbembela lihoto bho kummenga Limbembela? ");
INSERT INTO dne_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Unahota nkolongwa ghoghoha ghola anda upechengine gwenie kwa gwenie na kubhehe ibhogha ibhogha gwihoto ndeka kujhema, na bhando bha nyumba jhimo. ");
INSERT INTO dne_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Anda bhando bha nyumba bhapechangine ibhoghaibhogha, nyumba jhene nahigwa tugha. ");
INSERT INTO dne_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Anda Unahota gwa Limbembela upechengine ibhoghaibhogha, unahota gwonio naubhejhe na likakala.” ");
INSERT INTO dne_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Abhii jhe mundo jwapala kujhingii munyumba jha mundo jhuna likakala na kutolajhe ilebhe yake, ade antabhe mundo jwenio. Peniya nahotola kumpoka ilebhe yake.” ");
INSERT INTO dne_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ninnobholela chakaka, bhando nabhalekekewa uhakaho gwabhe na kulapanikiya kwabhe. ");
INSERT INTO dne_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nambo mundo jhojhoha jwauligha Uhuke gwa Chapanga nahotola ndeka kulekekewa uhakaho gwake, nahighalika na uhakaho gwake machiko ghoha ghangapeta.” ");
INSERT INTO dne_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yecho akalongii naha nhwalo gwa bhando bhakannobhalille, “Abhii na michuka.” ");
INSERT INTO dne_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Peniya majhe mundo Yecho na akalongo bhake bakahikite. Akalongo bhakajhemite panja, bhakantumite mundo kunkema Yecho. ");
INSERT INTO dne_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bhando bhamahele bakantindii Yecho, na mundo jhumo mmola akanobhalile, “Majhe gwino na akalongo bhino bhabhii panja, bhipalaha mwenga.” ");
INSERT INTO dne_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yecho ajhakwakonya, “Bho, majhe gwango na akalongo bhango akina ghane?” ");
INSERT INTO dne_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Peniya akalolakiye bhando bhubhantindii ajhakulonge, “Dolokeya! Nalobholela bhamba anda majhe gwango na akalongo bhango! ");
INSERT INTO dne_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mundo jhojhoha jwahenga ghapala Chapanga, jwenio ndi nnombo gwango na nhwacha gwango na majhe gwango.” ");
INSERT INTO dne_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yecho akatumbwii kubhola kabhele muupele jha lilabha. Bhando bhamahele bhakannendile ajhingii mungalabha na kutama mwenio. Na bhando bhoha bhakibha muupele jha lilabha. ");
INSERT INTO dne_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Akabholite ilebhe yamahena kwa kulandanikila, na pa mabholo ghake, akalobholile. ");
INSERT INTO dne_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Unyokanikiye! Mundo jhumo akajhahwii kunng'onda kumicha mbejho. ");
INSERT INTO dne_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pamichita mbejho, mbejho henge ikahikii pandela, ijhune ijhakuhika na kuhonyola. ");
INSERT INTO dne_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Henge ikaponi mu ihekendo, undope ukibha ndeka gwamahele. Ijhakumela kajhombe kwa nhwalo undope ukibha ndeka gwamahele. ");
INSERT INTO dne_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lyobha lijhakubhala, ijhakutinika, kwa nhwalo mikegha jhake ikajhabhulile jhe pahe, mbejho yela ijhakulelebhala. ");
INSERT INTO dne_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Henge ikaponikiye mu mikongo jha mibha, ikakolite jhe nhwalo ikahindamine mbejho ikapambike jhe. ");
INSERT INTO dne_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mbejho henge ikaponi muundope gwambone. Mbejho ijhakumela, ijhakukola na kupambika, makome matato, henge makome chita, na henge makome kome.” ");
INSERT INTO dne_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Peniya Yecho ajhakulonge, “Jhuna machikilo gha kujhoha na ajhohe!” ");
INSERT INTO dne_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yecho pakibha kanjika chake ndo, bhabholwa kome na bhabhele na bhando bhange kunkonya nhwalo jha nnandanikiho gwenio. ");
INSERT INTO dne_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yecho ajhakwalobholela, “Mangota mpatite kumanya chile jha Unahota nkolongwa gwa Chapanga hotuhotu. Nambo bheniya bhubhabhii panja bhakibhola kwa nnandanikiho tugha, ");
INSERT INTO dne_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","nambo, ‘Balinge bhakoto, nambo bhakoto kulola Bhajhohe bhakoto, nambo bhakoto kumanya, ngabhamanya ngabhang'alambukii Chapanga, na jwenio ngalekekiye bhando mahakaho ghabhe.’ ” ");
INSERT INTO dne_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Peniya Yecho ajhakwakonya, “Bho, mangota mukamanyite jhe mana jha nnandanikiho? Bho, naumanya nnandanikiho ghonge? ");
INSERT INTO dne_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mmicha mbejho umicha Lilobhe lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Bhando bhange bhakalandine na mbejho ikagwelile pandela pibhajhoha malobhe gha Chapanga, Limbembela uhika na kubhoha Lilobhe lya Chapanga ku mwojho gwabhe. ");
INSERT INTO dne_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Bhando bhange bhakalandine na mbejho iponi mukihekendo. Peniya pibhajhoha Lilobhe lya Chapanga, ujheketela kwa kuhangana. ");
INSERT INTO dne_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nhwalo gwanga mikegha kujhenda pahe. Uhimbilila pandina tugha anda ghapitii malola nhwalo gwa Lilobhe lya Chapanga peniya ulileka. ");
INSERT INTO dne_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bhando bhange bhakalandine na mbejho ikagwelii pa mibha. Bhalijhoha Lilobhe lya Chapanga, ");
INSERT INTO dne_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nambo iholo ya pannema ghongo, na kupalaha ilebhe henge, kupalaha ilebhe ya payegha, nabhene bhatenda ndeka chilipala Lilobhe. ");
INSERT INTO dne_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Bhando bhange ulandanakiwa na mbejho igweli paundope gwambone. Bhalijhoha Lilobhe lya Chapanga, ujheketele na kupambika uhohe, bhange makome matato na bhange makome chita na bhange makome kome.” ");
INSERT INTO dne_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yecho ajhakujhendelela kwalobholela, “Bho, abhii mundo jwapamba kolobohi na kugubikila kibhegha nkate amu kubheka kuhe kukindanda? Bho, ubheka panane jha kinala? ");
INSERT INTO dne_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bhahe, kilebhe chochoha chikihihitwe nakibhonekana na kilebhe chochoha chikiyekulilwe nakiyekulilwa. ");
INSERT INTO dne_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jhuna machikilo gha kujhoha na abangatuka!” ");
INSERT INTO dne_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Peniya ajhakwalobholela, “Unyokanikiye chininnobholela, Chapanga napemela kipemo cheche chimwapemela. Nantenda umanye kupeta gheniya. ");
INSERT INTO dne_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","jwabhii na kilebhe, jwenio najhonjekewa chenge, nambo jhola jwangabhehe nacho hote cheneche chakihobholela napokwa.” ");
INSERT INTO dne_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yecho ajhakujhendelela kwalobholela, “Unahota nkolongwa gwa Chapanga ulandanikiwe na mundo jwajhenda kumicha mbejho kunng'onda. ");
INSERT INTO dne_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kilo igholoka, muhe abhe miho mbejho imela na kukola. Jwenio amanyitejhe chikihengeka. ");
INSERT INTO dne_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Undope uitenda mbejho imele. Itumbuu kulingulila, upiya lihamba na njechele, peniya ndi upatika. ");
INSERT INTO dne_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mbejho puikomala, mundo jwenio najhenda kuhuna kwa kikwakwa, nhwalo muda gwa mahuno uhikite.” ");
INSERT INTO dne_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yecho ajhakwalobholela kabhele, “Bho, Unahota nkolongwa gwa Chapanga ulandine na nike? Bho, tulongela nike? ");
INSERT INTO dne_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ulengana na mbejho jhikemwa aladale, mbejho njokombe kupeta mbejho yoha, bhando umicha muundope. ");
INSERT INTO dne_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Anda imichitwe, ukola na kubhehe nkongo nkolongwa kupeta mikongo jhoha munng'onda. Na gwene ubhe na lindabhe likolongwa ijhune uhika kuchenga mihuhe.” ");
INSERT INTO dne_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yecho akatangachii Malobhe gha milandanikiho jhamahena, akabhalobhalii ngita chibhahotola kujhoha kwabhe. ");
INSERT INTO dne_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Akalongii nabho ndeka changa milandanikiho. Pakibha na bhabholwa bhake pakiyepela, akalobholii hotuhotu kila kilebhe. ");
INSERT INTO dne_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lichiko lele, kimihe, Yecho akalobholile bhabholwa bhake, “Tujhomboke kwiye ku lilabha.” ");
INSERT INTO dne_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bhahe, bhabholwa bhajhakulitabhuka lilongo lya bhando na kujhingii mungalabha na kubhoka pamo na Yecho. Helahela bhando bhange bhakajhingii mungalabha na kunkengama. ");
INSERT INTO dne_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Peniya kijhakupeti kimbonga kikolongwa na matuhe gha mache ghajhakutumbuu kuityala ngalabha na ikatumbwii kutwele mache. ");
INSERT INTO dne_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yecho akibha kuyeto jha ngalabha achaghamii nchaghamilo bhabholwa bhake bhajhakunyimua, bhanobholile, “Mmola, bho mutubhone jhe kiya twe kumilwa?” ");
INSERT INTO dne_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yecho akajhimwike, akapwatalii kimbonga kikolongwa na akakilobholi kimbonga, “Tama! Nuu!” Peniya kimbonga kijhakuleka na pajhakubhe teeke. ");
INSERT INTO dne_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Peniya ajhakwalobhalela bhabholwa bhake, “Nhwalo ghane mijhoghopa? Bho, nkwete jhe kihobholelo?” ");
INSERT INTO dne_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na bhene bhajhakujhoghopa hake, bhajhakukonyana, “Bho, jhonjo mundo ghane, ade kimbonga kinyeketela!” ");
INSERT INTO dne_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yecho na bhabholwa bhake bhakahikite kwiye mwa lilabha mu kilambo cha Akagelache, ");
INSERT INTO dne_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yecho papitita mungalabha, ajhakukongana na mundo jhuna michuka kuhumii kumambe. ");
INSERT INTO dne_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mundo hojho atamita ku mambe akibha jhe mundo jwahotwila kuntabha kabhele ata kwa minyololo. ");
INSERT INTO dne_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nhwalo bhatabhita mabhoko na magholo, akatopwii minyololo jhibhatabhita magholo ghake. Abhii jhe mundo jhuna likakala jwahotwila kunkamula. ");
INSERT INTO dne_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Muhe na kilo atyangita kumambe na kwitombe, kongo alalima na akihekita kwa maghanga. ");
INSERT INTO dne_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mundo jwenio pamonita Yecho chukutale, ajhakumutukila, na kutama makilikite. ");
INSERT INTO dne_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ajhakulela kwa Lilobhe likolongwa, alongila, “Yecho Mwana gwa Chapanga Jwa Kunane mipalaha nike kwa nenga? Kwa liina lya Chapanga, nkotoka kung'aha!” ");
INSERT INTO dne_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Alongila naha Yecho, “Nchuka mummoke mundo hojho!” ");
INSERT INTO dne_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yecho ajhakunkonya, “Liina lino ghane?” Na jwenio pajhangwila, “Liina lyango, ‘Lilongo,’ nhwalo tubhii twe.” ");
INSERT INTO dne_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Peniya ijhakumpembelekeya Yecho akoto kwabhenge panja jha kilambo chela. ");
INSERT INTO dne_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pakibha na lilongo likolongwa lya magholobhe ghalila muluhelelo lwa kitombe. ");
INSERT INTO dne_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Peniya michuka bhajhakumpembelekeya Yecho, “Mutulekekehe tughajhingii gheniya magholobhe.” ");
INSERT INTO dne_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yecho ajhakwalekekeya. Peniya michuka ijhakummoka mundo jhola na kujhingii magholobhe. Lilongo lyoha lya magholobhe ghakibha elufo ibhele bhajhakutilila muluhelelo na kutumbukii mulilabha na kuwelela mwenio. ");
INSERT INTO dne_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Akalucha magholobhe bhajhakutila na kwatangachila bhando bha kubomane na muchenda. Na bhando bhajhakujhenda kulolekeya chikipitile. ");
INSERT INTO dne_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pubhahikite kwa Yecho, bhajhakumona mundo jhola jhuna nchuka. Atamite pahe ahwalite ngobho na malango ghahengwite, na bhando bhoha bhajhakujhogopa. ");
INSERT INTO dne_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na bhando bhubhalolite lijhambu lyenio bhajhakwalobholela bhando bhange kilebhe chikimpitile mundo jhola jhuna nchuka na ghighapitii kwa magholobhe. ");
INSERT INTO dne_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Peniya bhajhakunnyopa Yecho abhoke mu kilambo chabhe. ");
INSERT INTO dne_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yecho pajhingila mungalabha, mundo jwakibha na nchuka ajhakumpembekeya bhajhende bhoha. ");
INSERT INTO dne_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nambo Yecho ajhakukana, ajhakunobholela, “Nnyende kajha kwa akalongo bhino, na mwalobholele ghantendi Bhambo kwa kumone kiya.” ");
INSERT INTO dne_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Peniya mundo jwenio ajhakujhenda, ku Miche Kome na kwatangachila bhando chantendii Yecho. Na bhando bhoha bhibhajhohina bhajhakuhechuka. ");
INSERT INTO dne_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Peniya Yecho pajhombwika kabhele kwiye jha lilabha kwa ngalabha, bhando bhamahele bhakakonganike na kuntindila. ");
INSERT INTO dne_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Peniya kilongoche jhumo jwa munyumba jha kukonganiki Akayahude liina lyake Jailu, pamonita Yecho ajhakutama makilikite pamagholo ghake. ");
INSERT INTO dne_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ajhakumpembekeya, alongila, “Nchikana gwango atenda kulwalwa tolatola. Chonde nhwike mu mekele mabhoko ghino alame na abhehe na ughome.” ");
INSERT INTO dne_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bhahe, Yecho ajhakulongohana nako. Lilongo likolongwa lijhakunkengama, na kuhindamana hindamana. ");
INSERT INTO dne_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Peniya pakibha na mwikeghe jhumo jhuna ulwalo gwa pihe jhangajhoma kwa yaka kome na ibhele. ");
INSERT INTO dne_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mwikeghe jwenio akalaghite kwele kujhenda kwa nghanga na kujhitana ilebhe yake, nambo akapatite jhe ulamo na akajhendelii kulwalwa. ");
INSERT INTO dne_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mwikeghe jwenio pajhohina Yecho ilamicha bhando, ajhakupekenyela palilongo, ajhakunyendela Yecho cha kuhyeto na kupapaha lilombolo lya ngobho jhake, ");
INSERT INTO dne_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ajhakukilobholela, “Anda hotwii kukamuu ngobho jhake, namite.” ");
INSERT INTO dne_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pakamwila ligwanda lyake Yecho, papalapala miyahe ijhakuleka kupita, na jwenio ajhakukijhoha payegha jhake palamite. ");
INSERT INTO dne_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Peniya Yecho akamanyite likakala lyake linnamiche mundo jwenio. Bhahe, ajhakulighalambukila lilongo lya bhando, kulikonya, “Ghane jwambapii ngobho yango?” ");
INSERT INTO dne_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bhabholwa bhake bhajhakunnyanguu, “Mibhona bhando chibhakangana kangana. Bho, minkonya ghane jwampapiye?” ");
INSERT INTO dne_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nambo Yecho akajhendelile kulolekeya aumanye ghane jwampapiye. ");
INSERT INTO dne_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Peniya ndi mwikeghe jwenio akamanyite kilebhe chakipatite, ajhakukilaha kongo atehila kulendema, ajhakutama makilikite palonge jha Yecho, peniya ajhakunnobholela chakaka ghoha. ");
INSERT INTO dne_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yecho ajhakunnobholela, “Nchikana gwango, kihobholelo chino kinamiche. Nnyende kwa uteeke, na ulwalo gwino ulame.” ");
INSERT INTO dne_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yecho pakibha amela akalonge, bhando bhange bhakahikite kuhumii kajha kwa Jailu kilongoche nkolo jwa nyumba jha kukonganikii Akayahude ajhakunnobholela, “Nchikana jwino ajhomwike. Bho, mijhendelela kuntotoha mmola?” ");
INSERT INTO dne_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yecho kwa kujhoha gheniya ghibhalongila, ajhakunobholela kilongoche nkolongwa jwa nyumba jha kukonganikii Akayahude, “Nkotoka kujhoghopa, mwe nnyohe.” ");
INSERT INTO dne_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yecho akapahi jhe mundo jhonge alongohane, nambo akajhahwii na Petile na Yakobu na Yohane nnongo mundo Yakobu. ");
INSERT INTO dne_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pibhahikita munyumba jha kilongoche Jailu, Yecho ajhakujhoha bhando bhalelita malelo. ");
INSERT INTO dne_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yecho akajhingii nkate, “Ajhakwalobholela, nhwalo ghane michobhela na kulela? Mwana ahwii jhe, nambo atekugholoka.” ");
INSERT INTO dne_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bhene bhajhakunheka kwa kumpucha. Nambo ajhakwapiya bhoha panja, ajhakuntola tate na majhe gwa mwana jwenio pamo na bhabholwa bhake bhatato, bhajhakujhingii pa bwalo pagholwike mwana. ");
INSERT INTO dne_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Akankamwii lubhoko na kulongole, “Talita kome,” mana jhake, “Nchikana, ninnobholela nnyimuke!” ");
INSERT INTO dne_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Papalapala mwana jhola ajhakujhimuka na kutyanga, mwana jwenio akibha na yaka kome na mibhele. Peniya bhando bhakahechwike hake. ");
INSERT INTO dne_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yecho ajhakwakanakiya kwa lilaka bhakoto kunnobholela mundo ilebhe ipitile, peniya ajhakwalobholela mukupile mwana jwenio. ");
INSERT INTO dne_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yecho ajhakubhoka peniya alongohine na bhabholwa bhake na kujhenda ku muche gwake. ");
INSERT INTO dne_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lichiko lya Kupomolela pulihikita, Yecho akatumbwii kubhola munyumba jha kukonganikii Akayahude, bhando bhamahele bhibhannyokanikiya bhakahechwike. Bhajhakukonya, “Ghanga ghoha apatite ko? Ichima ghane jhapatite mundo hojho ade atende ilebhe ya kukangacha? ");
INSERT INTO dne_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bho, jhonjo mwana jwa mmacha mibhoko, mwana gwa Maliya na nnongo mundo Yakobu na Uchupo na Yuda na Simone? Bho, akalombo mundo bhabhii pambajhe na twenga?” Peniya bhajhakunchimwa na kunkana. ");
INSERT INTO dne_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yecho ajhakwalobholela, “Nnondole jwa Chapanga bhanyokanikiya kila chehemo, nambo bhanyokanikiya ndeka pakilambo chake na akalongo bha kajha kwabhe.” ");
INSERT INTO dne_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yecho akatei ndeka ikangacho yoyoha pala, akabhekii mabhoko bhilwalwa bhandina, bhakalamite. ");
INSERT INTO dne_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yecho akakangiche nhwalo bhakibha jhe na kihobholelo. Peniya Yecho akajhahwii pachenda jhibhandikii na kubhola bhando. ");
INSERT INTO dne_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Akakemite bhabholwa bhake kome na bhabhele, ajhakwatuma bhabhele bhabhele na kwapeke ukindendeke gwa kubhenga michuka. ");
INSERT INTO dne_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Peniya ajhakwalobholela, “Pimijhenda nkoto kughegha kilebhe, nnyegha nkongocho. Nkoto kughegha chakulya, amu lihako, amu mbijha. ");
INSERT INTO dne_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Uhwale maghubache, nkoto kughegha ngobho henge. ");
INSERT INTO dne_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kabhele ajhakwalobholela nyumba jhojhoha jhipala kujhingila, ntame mwenio ade pupala kubhoka. ");
INSERT INTO dne_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pibhapala kukana kumpoke amu kunnyokanikiya, mmoke peniya na nkung'unde lutukunda lulubhii mumagholo ghino, kulangiya bhakanite lilobhe lya Chapanga!” ");
INSERT INTO dne_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bhahe, bhakajhahwii kutangachii bhando bhauleka uhakaho na bhang'alambukile Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bhakachomwii michuka twe. Bhakapakite mahuta bhibhalwalwa, bhajhakwalamicha. ");
INSERT INTO dne_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Munahota nkolongwa Helode pajhohina malobhe gheniya gha chipwa jha Yecho itapakii. Bhando bhange bhakalongii, “Jhonjo Yohane Mbatichajhe ayokite! Ndi mana likakala lya ikangacho lihenga lihengo nkate jhake.” ");
INSERT INTO dne_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bhange bhalongila, “Jhonjo ndi Eliya.” Na bhange bhalongila, “Jhonjo ndi jhumo jwa bhalondole bha Chapanga ngita milondole bha makacho.” ");
INSERT INTO dne_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nambo Helode pajhohina malobhe, alongila, “Yohane Mbatichajhe nikahekite muto ayokite!,” ");
INSERT INTO dne_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Akawachii naha nhwalo machiko gheniya Helode jwenio akalaghalikiye Yohane bhantabhe mukipungo. Akatehi naha nhwalo gwa Helodiya nhwana mundo, jwakibha nhwana mundo Filipu, nnongo mundo Helode. ");
INSERT INTO dne_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Machiko gheniya Yohane Mbatichajhe akankonyite Helode, “Chamaha jhe mwenga kuntolela mwikeghe jwa nnongo gwino.” ");
INSERT INTO dne_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Bhahe, Helodiya mwikeghe jwa munahota ajhakunchimwa Yohane na kupala kunkoma, nambo akahotwii ndeka. ");
INSERT INTO dne_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Helode atehila kunyoghopa Yohane kwa mana akibha mundo jwatehila mambu gha umbone na nyahinyahi, bhahe, ajhakunnyemelela. Apalita kunyokanikiya, pajhomolila kunyokanikiya mwojho uminita hake. ");
INSERT INTO dne_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lichiko limo, mwikeghe jwa munahota Helodiya akapatite pwache jha unyagho gwa kubhelukwa Helode. Helode akabhatendile unyagho akanahota akakomana ngondo na akanahota bha kilambo cha ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Peniya nchikana jwa Helodiya pajhingila ajhakukina, ajhakuhanganicha Helode na akaghene bhake. Peniya munahota nkolongwa ajhakunnobholela mwana jwenio, “Unyope kilebhe chochoha chimipala, nanimpela.” ");
INSERT INTO dne_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Mala jha ubhele akalapanikiye, “Chochoha chimpala, ata nucho jha Unahota gwango.” ");
INSERT INTO dne_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Peniya nchikana jhola ajhakubhoka, na kunkonya majhe mundo, “Nyope kilebhe ghane?” Na jwenio ajhakujhanguu, “Muto gwa Yohane Mbatichajhe.” ");
INSERT INTO dne_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nchikana jhola ajhakubhutuka ade kwa munahota nkolongwa, ajhakulonge, “Umbekehe muto gwa Yohane Mbatichajhe mukipalo!” ");
INSERT INTO dne_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Munahota Helode ajhakubhehe ngolongondi hake, akahotwii ndeka kukana, nambo nhwalo gwa kilapo chake palonge jha akaghene bhake. ");
INSERT INTO dne_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Papalapala akannaghalikiye nkomana ngondo akajhahwii kukipungo, kunheketa muto gwa Yohane, ");
INSERT INTO dne_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","peniya ajhakuleta muto gwenio mukipalo, ajhakumpekiya nchikana jwenio, na jwenio ajhakukamuha majhe mundo. ");
INSERT INTO dne_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bhabholwa bha Yohane pibhajhohina gheniya, bhajhakutola yegha jhake, bhajhakuchika umambe. ");
INSERT INTO dne_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Akatenga bhala bhajhakukelebhuka, bhakakonganike palonge jha Yecho, bhajhakunnobholela gheniya ghoha ghantei na kubhola. ");
INSERT INTO dne_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yecho ajhakwalobholela, “Tujhende pakiyepela tukapomolele.” Alongila naha nhwalo pakibha na bhando bhamahele bhubhahikita na kubhoka, ade Yecho na bhabholwa bhake bhakapatitejhe pwache jha kulyegha. ");
INSERT INTO dne_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Peniya, bhajhakubhoka mungalabha, bhajhakujhenda chehemo jhanga bhando. ");
INSERT INTO dne_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nambo bhando bhamahele bhajhakwabhona pibhabhokita, bhajhakumanya. Peniya bhajhakubhutuka kuhumii ku muche bhakatumbwii kuhika kabula jha Yecho. ");
INSERT INTO dne_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yecho na bhabholwa bhake pibhahulwika mungalabha, ajhakulibhona lilongo likolongwa lya bhando, ajhakwabhone kiya nhwalo bhabhonakina ngita mambelele ghangabhehe na nnuchajhe. Peniya ajhakwatumbuu kwabhola malobhe twe. ");
INSERT INTO dne_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pukihikita kimihe, bhabholwa bhake bhajhakunyende, bhajhakunobholela Yecho, “Pambano tubhii panjenga, na lyobha litipike. ");
INSERT INTO dne_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mwulitabhuke lilongo lya bhando leno bhajhende ku mighonda na chenda ibhandikile, bhakahemele yakulya.” ");
INSERT INTO dne_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nambo Yecho ajhakwalobholela, “Mangota mapekehe yakulya.” Bhajhakunkonya, “Bho, twapeke nike? Natupalwa kuhenga lihengo kwa miyehe jhamahele tipate mbijha ya kuhemela ilebhe ya kulyegha bhando bhamba?” ");
INSERT INTO dne_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yecho ajhakwakonya, “Bho nkwete mabumunda maligha? Nnyende mukalinge.” Pubhamanyita, bhajhakunnobholela, “Tukwete mabumunda nhwano tugha na homba ibhele.” ");
INSERT INTO dne_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Peniya Yecho ajhakwalobholela bhabholwa bhake, mabhona bhando bhakatamite muibhogha ibhele, pamanyahe mabhehe. ");
INSERT INTO dne_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Peniya bhajhakutama ibhoghaibhogha, apa makome kome na pala makome nhwano. ");
INSERT INTO dne_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bhahe, Yecho akatoii mabumunda nhwano na homba ibhele, ajhakulola kunane, ajhakunchenguu Chapanga na ajhakumetula. Ajhakwapekeya bhabholwa bhake bhapeke bhando. Helahela bhajhakwahekete bhando bhoha homba. ");
INSERT INTO dne_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bhando bhoha bhakalile na kujhukuta. ");
INSERT INTO dne_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Peniya bhabholwa bhake bhajhakujhola mahighiliko gha homba na mabumunda bhakatweli ichukilo kome na ibhele. ");
INSERT INTO dne_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Akanalome bhubhalile bhakibha elufo nhwano. ");
INSERT INTO dne_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Peniya ajhakwalobholela bhabholwa bhake bhajhingile mungalabha bhalongolele ku Betisaida kwiye jha lilabha. Jwenio akibha atabhuka ibhogha ya bhando. ");
INSERT INTO dne_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pajhomolila kwatabhuka bhando, ajhakujhenda pakitombe kunyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pukihikita kimihe, ngalabha ikibha pakate jha lilabha na Yecho akibha kanjika chake ndo mupele mwa lilabha. ");
INSERT INTO dne_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Akamwene bhabholwa bhake pubhalaghita mungalabha, nhwalo upepo gwatobhita kanonoho. Puibhandikila kuchegha, Yecho ajhakwajhende, akibha atyanga panane jha mache, apata kwapeta. ");
INSERT INTO dne_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nambo bhene pibhamwene ityanga panane jha mache, bhajhakuwacha lihoka, bhajhakulalama. ");
INSERT INTO dne_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bhoha pibhamwene bhajhakujhoghopa hake. Papalapala Yecho ajhakwalobholela, “Nkangamale! Ndi nenga. Nkotoka kujhoghopa.” ");
INSERT INTO dne_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Peniya ajhakuhobhokela mungalabha jhikibha na bhabholwa bhake, na upepo ujhakuleka. Bhabholwa bhake bhakakangiche hake. ");
INSERT INTO dne_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nhwalo bhakamanyitejhe chakatehii Yecho panane jha libumunda lela, miojho jhabhe ikibha mijhundapaho. ");
INSERT INTO dne_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bhajhakujhomboka lilabha bhajhakuhika ku kilambo cha ku Genechalete, bhajhakujhemeka ngalabha jhabhe. ");
INSERT INTO dne_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pibhapitita mungalabha, papalapala bhando bhajhakummanya Yecho. ");
INSERT INTO dne_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Peniya bhajhakutindila kajhombe mukilambo choha, bhajhakutumbuu kwatola bhibhalwalwa mumipacha na kwapeleka popoha pubhajhohina Yecho abhii. ");
INSERT INTO dne_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na kila pajhahwila muchenda, ku miche amu ku mighonda, bhajhakwabheka bhibhalwalwa mu maghuliho. Bhangalwalwa bhajhakumpembelekeya Yecho bhapapae lilombolo lya ngobho jhake, bhoha bhibhakampapiye bhakalamite. ");
INSERT INTO dne_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lichiko limo Mapwalichayo na Bhabhola bha Malaghalikilo kuhumii ku Yeluchalemo, bhakajhahwii kwa Yecho. ");
INSERT INTO dne_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Akahwene bhabholwa bhange bha Yecho bhalila changakuwa mache mu mabhoko ngita chilipata Lilaghalikilo lya Akayahude. ");
INSERT INTO dne_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nhwalo Mapwalichayo na Akayahude bhoha bhalyejhe changakuwa ade muhingongole, bhakakamwile mabholo ghubhapokii kuhumii kwa akahoko bhabhe. ");
INSERT INTO dne_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pubhahuma kulighuliho bhalyejhe kilebhe chochoha changakuwa ngita chibhakayobhalile. Helahela bhakakamwii mabholo ghange ghamahena gha kuchuka ikombe, ihulo na ibhegha. ");
INSERT INTO dne_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bhala Mapwalichayo na Bhabhola bha Malaghalikilo bhakankonyite Yecho, “Bho, bhabholwa bhino bhakengama ndeka mabholo kuhumii kwa ighogholo, bhalyegha kwa mabhoko mahakanaho?” ");
INSERT INTO dne_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yecho ajhakwajhanguu, “Mangota mukitenda bhaumbone! Jwakibha nnondole jwa Chapanga Isaya akalondwi mangota ngita chajhandike, ‘Bhando bhamba bhajhekete kwa milomo jhabhe tu, nambo miojho jhabhe ibhii kutale na nenga. ");
INSERT INTO dne_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na bhene bhanyinamii jhajhe, Bhabhola Malaghalikilo gha bhando, ngita hela lilaghalikilo lya Chapanga!’ ");
INSERT INTO dne_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mulilekite lilaghalikilo lya Chapanga, mughakamuu malaghalikilo ghibhampekiye akahoko bhino.” ");
INSERT INTO dne_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yecho ajhakujhendelela kulonge, “Nkwete ndela jhambone jha kukana malaghalikilo gha Chapanga nkamuu mabholo ghimpokii gha akahoko bhino! ");
INSERT INTO dne_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ngita lilaghalikilo lya Mucha, ‘Majhokanikiye tate gwino na majhe gwino,’ na ‘Na jwannigha tate mundo amu majhe mundo, nabhankoma.’ ");
INSERT INTO dne_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mangota mwenga mibhola, anda mundo akwete kilebhe chakuntangati tate mundo amu majhe mundo, nambo alonge, ‘Kilebhe chenje Kolibane,’ mana jhake hupo jha kumpekeya Chapanga, ");
INSERT INTO dne_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","peniya yamaha ndeka kuntangati tate mundo amu majhe mundo. ");
INSERT INTO dne_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Naha ndi chimulipucha lilobhe lya Chapanga kwa kukengama mabholo ghino mabhene. Na muhenga ghamahena ngita gheniya.” ");
INSERT INTO dne_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Peniya Yecho akalikemite kabhele lilongo lya bhando, ajhakwalobholela, “Mangota mwe bhoha unyokanikiye na umanye. ");
INSERT INTO dne_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kibhii jhe chakulyegha chalye mundo chikihotola kuntenda abhe na uhakaho. Nambo kilebhe chikimpeta mundo nkate, chenie ndi kintenda mundo abhe jwanganandela palonge jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mundo jwakwete machikilo gha kujhoha na abangatuke.” ");
INSERT INTO dne_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Palilekita lilongo lya bhando na kujhingii nkate, bhabholwa bhake bhajhakunkonya nnandanikiho gwenio. ");
INSERT INTO dne_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yecho ajhakwakonya, “Bho, mangota mwenga umanyite ndeka? Bho, umanya ndeka chakulyegha chikinnyingii mundo kuhumii panja ade kucholo kintenda ndeka kubhehe jwanganandela? ");
INSERT INTO dne_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nhwalo kijhingii ndeka kumwojho kijhingii kulutumbo, na kujhenda kucholo.” Kwa kulonge naha, Yecho ajhakulekekeya ilebhe yoha ilegwe. ");
INSERT INTO dne_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yecho ajhakujhendelela kulonge, “Kilebhe chikimpita mundo, kintenda kubhe jwanganandela. ");
INSERT INTO dne_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nhwalo nkate jha mwojho gwa mundo, ghibhoka mawacho mahakaho na ngongola na lukwatulo na kukoma na wiho gwa ngongola, ");
INSERT INTO dne_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ughone na uwange na upichade na wiho na maligho na kuloka na lighoho na kutokomala. ");
INSERT INTO dne_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ghanga ghoha na uhakaho ghahuma nkate mwa mundo, na gheniya ghantenda mundo kubhehe na uhakaho palonge jha Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bhahe, Yecho ajhakupeta peniya na kujhenda ku kilambo cha ku Tilo. Kwenio ajhakujhingii nkate na akapahi jhe mundo amanye, nambo akahotwii ndeka kukihiya. ");
INSERT INTO dne_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Peniya mwikeghe jhumo Nghilike jwakibha na mwana jhuna nchuka, akajhohine malobhe gha Yecho. Ajhakunnyendela, na kukigwiya pamagholo gha Yecho. ");
INSERT INTO dne_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Mwikeghe jwenio akibha Nghilike chi Uyahude, jwabhelwike ku kilambo cha ku Chilofoinike, ajhakunnyopa Yecho amwohe mwana mundo nchuka. ");
INSERT INTO dne_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yecho ajhakujhanguu, “Mwaleke yana ijhukute. Yamaha ndeka kutola chakulya chibhalye yana na kukitaghii ghimbwa.” ");
INSERT INTO dne_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Majhe jhola ajhakujhanguu, “Chakaka, Bhambo, nambo ghimbwa ibhii kuhi pa mecha ilye mahighililo gha yana.” ");
INSERT INTO dne_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yecho ajhakunnobholela, “Mwikeghe jhola, kwa gheniya ghunnyangwile, nnyende kajha. Nchuka ghummokite mwana!” ");
INSERT INTO dne_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Bhahe, mwikeghe ajhakujhenda kajhake ku Galilaya kupete ku Dekapoli, ajhakunkolela mwana agholwike pakindanda, na nchuka ummokite. ");
INSERT INTO dne_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Peniya Yecho pabhokita ku kilambo cha ku Tilo, kupete ku Sidone, kuhika kulilabha lya ku Galilaya kupete ku kilambo cha Miche Kome. ");
INSERT INTO dne_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bhando bhange bhakannetite mundo jwangajhoha machikilo na jhuna kimama, bhajhakunyopa Yecho amekele mabhoko anamiche. ");
INSERT INTO dne_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Peniya Yecho ajhakumeka kutale na lilongo lya bhando na kujhingii ngonje mu machikilo gha mundo jwangajhoha. Peniya ajhakuhuna mata pahe na kupapaa lulime lwa mundo jhola. ");
INSERT INTO dne_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Peniya Yecho ajhakulolekeya kunane kwa Chapanga, ajhakutweta kwa likakala ajhakulonge, “Efata,” mana jhake, “Dinduka!” ");
INSERT INTO dne_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Papalapala machikilo gha mundo jhola ghajhakudinduka, lulime lwake lujhakulegheleka, ajhakutumbuu kulonge maha. ");
INSERT INTO dne_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Peniya Yecho ajhakwalaghalikiya bhakoto kunongelela mundo jhojhoha ghighapitile. Pachochita kwakanikiya, bhajhakujhendelela kutangacha malobhe gheniya. ");
INSERT INTO dne_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bhando bhakakangiche hake, bhakalongii, “Atei ghoha ghambone. Bhangajhoha hilu machikilo bhajhoha, na bhina kimama bhalonge!” ");
INSERT INTO dne_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Machiko gheniya, lilongo likolongwa lya bhando likakonganike kabhele. Nhwalo bhakibha jhe na ilebhe ya kulyegha, Yecho ajhakwakema bhabholwa bhake, ajhakwalobhalela, ");
INSERT INTO dne_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nakole kiya bhando bheniya, hena, bhatamite na nenga kwa machiko matato changalyegha. ");
INSERT INTO dne_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nalobholila bhajhende kajhabhe na njala bhihoto kuhindukii undela, nhwalo bhange bhahuma kutale.” ");
INSERT INTO dne_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bhabholwa bhake bhajhakunkonya, “Bho, pamba palundwanga nabhapata ko chakulyegha kujhukuta bheniya bhoha?” ");
INSERT INTO dne_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yecho ajhakwakonya, “Bho, nkwete mabumunda malegha?” Bhajhakunyanguu, “Tubhii nagho chaba.” ");
INSERT INTO dne_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bhahe, Yecho ajhakwalobholela mwatamike bhando pahe. Ajhakutola mabumunda chaba ajhakunchenguu Chapanga, ajhakumetula na kwapekeya bhabholwa bhake bhaghabhanichile bhando, na bhene bhajhakwabhaghulila bhando. ");
INSERT INTO dne_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Helahela bhakibha na homba yandina. Yecho ajhakuilomba na kwalobholela bhabholwa bhake bhabhaghulile bhando. ");
INSERT INTO dne_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bhando bhakalile na kujhukuta, peniya bhabholwa bhake bhajhakulokota mahighililo gha mabumunda na homba, bhajhakutweleya ichukilo chaba. ");
INSERT INTO dne_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bhando bhubhalila bhakibha ngita elufo ncheche. Peniya Yecho ajhakwatabhuka. ");
INSERT INTO dne_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Papalapala ajhakujhingii mungalabha na bhabholwa bhake, ajhakujhenda ku kilambo chuku Dalimanuta. ");
INSERT INTO dne_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mapwalichayo bhange bhajhakunyendelela Yecho, na kutumbuu kutaungana nako, bhajhakunnyigha bhapata nginyililo kuhumii kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yecho ajhakubhehe ngolongondi, akalongii, “Nhwalo ghane kibheluko chenje kipala nginyililo chakaka ninnobholela, nakipelwajhe nginyililo jhojhoha.” ");
INSERT INTO dne_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Peniya ajhakwaleka, ajhakujhingii mungalabha, ajhakujhomboka kwiye mulilabha lya ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bhabholwa bhajhakujhehwa kughegha mabumunda ghamahele, nambo bhakibha na libumunda limo mungalabha. ");
INSERT INTO dne_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yecho ajhakwalobholela, “Mukilolekehe na ngedule ya Mapwalichayo na jha Helode.” ");
INSERT INTO dne_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bhabholwa bhajhakutumbuu kutaungana bhene kwa bhene, “Alongila naha nhwalo tukwete ndeka mabumunda.” ");
INSERT INTO dne_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yecho akamanyite chibhakibha bhalongila. Ajhakwakonya, “Bho, mutaungana nhwalo gwa mabumunda? Bho, mwamela mwangamanya? Bho, miwacha jhe ku mwojho? ");
INSERT INTO dne_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mina miho mulo ndeka, mina machikilo mujhoha ndeka? Bho, mikombokajhe, ");
INSERT INTO dne_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","pumetwila mabumunda nhwano na kwapekeya bhando elufo nhwano? Bho, mukatweli ichukilo ilegha ya mahighiliko?” Bhajhakunyanguu, “Tukatwelii itandabhala kome na ibhele.” ");
INSERT INTO dne_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jwenio ajhakwakonya kabhele, bho, “Pumetwila mabumunda chaba na kwapekiya bhando elufo ncheche, mukatweli ichukilo ilegha ya mahighiliko?” Bhajhakunyanguu, “Ichukilo chaba.” ");
INSERT INTO dne_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bhahe, ajhakwakonya, “Mwamela minamanyajhe?” ");
INSERT INTO dne_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yecho akahikite ku Betichaida pamonga na bhabholwa bhake. Bhando bhange bhajhakumpelekela Yecho mundo jwangalola, bhajhakumpembelekeya ampapahe anamiche. ");
INSERT INTO dne_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yecho ajhakunkamuu lubhoko lwa mundo jwangalola, ajhakumpiya panja jha chenda. Peniya ajhakuhunii mata kumiho, ajhakumekela mabhoko, ajhakunkonya, “Bho, mwihoto kulola kilebhe chochoha?” ");
INSERT INTO dne_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jwangalola ajhakulola na peniya ajhakulonge, “Nibhona bhando anda mikongo chityanga.” ");
INSERT INTO dne_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yecho ajhakummeke kabhele mabhoko pamiho jha mundo jwenio. Peniya miho ghajhakudinduka na jwenio ajhakulola maha. ");
INSERT INTO dne_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yecho ajhakunnobholela, abhujhe kajhake na ajhakunkanakiya kujhingii muchenda na kwalobholela bhando. ");
INSERT INTO dne_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yecho na bhabholwa bhake bhajhakujhenda ku chenda jha ku Kaisaliya jha ku Filipu. Undela Yecho ajhakwakonya, “Bho, bhando bhalonge nenga ndi ghane?” ");
INSERT INTO dne_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bhajhakunyanguu, “Bhange bhalonge mwenga mwa Yohane Mbatichajhe, na bhange bhalonge mwenga mwa Eliya, na bhange bhalonge mwenga ndi ma Nnondole jwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Peniya Yecho ajhakwakonya, “Mangota milonge nenga ndi ghane?” Petile ajhakunyanguu, “Mwenga ndi mwa Kilichitu, jhuhagulilwe na Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yecho ajhakwapwatalila, “Nkotoka kunnobholela mundo jhojhoha malobhe ghanga.” ");
INSERT INTO dne_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yecho ajhakutumbuu kwabhola bhabholwa bhake, ajhakwalobholela, “Mwana gwa Mundo nalunkolela lung'ahe lukolongwa na kukanwa na akanahota na akapiya matambiko bhakolo na Bhabhola bha Malaghalikilo. Nabhankoma, na machiko matato anda ghahikite peniya nayoka.” ");
INSERT INTO dne_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yecho ajhakwalobholela hotuhotu. Peniya, Petile ajhakuntola Yecho paupele, ajhakutumbuu kumpwatalila nkoto kulonge naha. ");
INSERT INTO dne_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nambo Yecho ajhakughalambuka, ajhakwalolekeya bhabholwa bhake, ajhakumpwatali Petile alongila, “Mmoke palonge jhango mwenga ma limbembela! Nhwalo miwacha ndeka gha Chapanga, nambo miwacha kimundo.” ");
INSERT INTO dne_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Peniya ajhakulikema lilongo lya bhando pamonga na bhabholwa bhake, ajhakwalobholela, “Mundo jhojhoha jwapala kubhehe na nenga akihila hote jwenio, atole nchalaba gwake, angengame. ");
INSERT INTO dne_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mana mundo jwapala kuughombola ughome gwake jwenio, nahuhobholela, mundo jwahobhecha ughome gwake nhwalo gwa nenga kwa Malobhe gha Mbone, naukombola. ");
INSERT INTO dne_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bho, Nakitangatila nike mundo kupata nnema ghoha na kuhobheya ughome gwa machiko ghoha? ");
INSERT INTO dne_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mundo napiha nike kupoke ughome gwa machiko ghoha kabhele? ");
INSERT INTO dne_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mundo anda amwone hone nenga na Malobhe ghango mu kibheluko changanandela na ngongola, Mwana gwa Mundo namonela hone papala kuhika muukolo gwa tate pamo na akatumiche bha Chapanga jwa kunane bhanyahinyahi.” ");
INSERT INTO dne_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yecho ajhakujhendelela kwalobholela, “Ninobholela chakaka, bhabhii bhando bhange pambano pano nabhawejhe kabula jha kubhona Unahota nkolongwa gwa Chapanga ukahika na likakala.” ");
INSERT INTO dne_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pighapetita machiko chita, Yecho ajhakwatola Petile na Yakobu na Yohane, panane jha kitombe kanjika chabhe. Kwenio Yecho ajhakughalambuka ubhonekano pamiho palonge jhabhe. ");
INSERT INTO dne_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Magwanda ghake ajhakung'anyima mbumbumbu, mupula ngobho jhojhoha pannema ahoto ndeka kupula ngita yenio. ");
INSERT INTO dne_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eliya na Mucha bhajhakupiti palonge jhabhe, na kulonge na Yecho. ");
INSERT INTO dne_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petile ajhakunnobholela Yecho, “Mmola, nibhona pambano pambone hake kutama twenga. Mbaha tuchenge ichimba itato, chimo chino, chimo cha Mucha na chimo cha Eliya.” ");
INSERT INTO dne_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Na jwenio Petile na ajhake bhakajhogwipe hake ata Petile akamanyitejhe cha kulonge. ");
INSERT INTO dne_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Peniya likahikite lihunde, na lijhakwayekelela, na lilobhe lijhakujhokanikika kuhumii kulihunde lyenio, “Jhonjo ndi Mwanango jhunimpahile, munyokanikiye!” ");
INSERT INTO dne_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Peniya bhabholwa bhajhakulolekeana kabhele, bhakamwene ndeka mundo, Yecho kanjika chake pamonga nabho. ");
INSERT INTO dne_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bhahe, pibhahelila kukitombe, Yecho ajhakwakanakiya bhakotoka kunnobholela mundo jhojhoha ilebhe ibhaihwene, ade Mwana gwa Mundo papala kuyoka. ");
INSERT INTO dne_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bhahe, bhakakamwii lilaghalikilo lyenio, bhajhakukonyana, bhene kwa bhene, “Kuyoka mana jhake nike?” ");
INSERT INTO dne_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bhabholwa bhajhakunkonya Yecho, “Bho, bhabhola bha Malaghalikilo bhilonge ade Eliya ahike?” ");
INSERT INTO dne_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na jwenio Yecho ajhakwajhanguu, “Chakaka, Eliya ahika kutengenecha ghoha. Peniya, kwa nhwalo ghane ijhandikwe mu Majhandiko gha Chapanga Mwana gwa Mundo chapata malagho twe na kupuchwa? ");
INSERT INTO dne_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nambo ninnobholela mangota, Eliya ahikite njwe, na jwenio bhakantendi chibhapata ngita chijhandikwe panane jhake.” ");
INSERT INTO dne_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yecho na bhabholwa bhala bhatato, bhajhakubhujha pubhabhii bhange, bhajhakulibhona lilongo likolongwa litindile na Bhabhola bhange bha Malaghalikilo bhakibha mukutaungana nabho. ");
INSERT INTO dne_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Papalapala lilongo lya bhando pubhamonita Yecho, bhakakangiche hake, bhajhakumutukila bhanyambuche. ");
INSERT INTO dne_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yecho ajhakwakonya bhabholwa bhake, “Bho, mutaungana nike?” ");
INSERT INTO dne_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Peniya mundo jhumo kuhumii mulilongo ajhakunyanguu, “Mmola, ninetite mwana gwango kwino, jhuna nchuka jhulindenda akoto kulonge. ");
INSERT INTO dne_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pahika na kuchikilwa, ung'wiya pahe na kuntenda apite lihulohulo munnomo, ayagha mino na kujhoma chwa yegha. Nakajhopite bhabholwa bhino bhabhohe nchuka, nambo bhakahotwi ndeka.” ");
INSERT INTO dne_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yecho ajhakwalobholela, “Mangota kibheleko changabhehe na kihobholelo! Nandama na mangota ade ligha? Nanihimbilila ade ligha? Munnete kwa nenga!” ");
INSERT INTO dne_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bhajhakumpeleka kangombo jwenio kwa Yecho. Nchuka pamonita Yecho, ajhakuntenda kangombo kihinduhindu, na kangombo ajhakugwe pahe ajhakuyolayola, na kupita lihulohulo munomo. ");
INSERT INTO dne_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yecho ajhakunkonya tate gwa kangombo, “Ghanga ghankoli kuhumii legha?” Na jwenio ajhakunyanguu, “Kuhuma umwana gwake. ");
INSERT INTO dne_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","nchuka gwenio ugwiya kangombo hojho pakihinja na umache unkome. Bhahe, anda uhoto, mutubhone kiya na mututangatile.” ");
INSERT INTO dne_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yecho ajhakunnobholela, “Nkoto kulonge ngita nihoto! Ghoha ghiwechekana kwa mundo jwabhii na kihobholelo.” ");
INSERT INTO dne_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Peniya, tate mundo jwenio ajhakulela kanonoha, “Nihobholela! Nambo kihobholelo chango kitocha ndeka, undangatile!” ");
INSERT INTO dne_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yecho palilolokiya lilongo lya bhando lijhonjekeka kajhombe palonge jhake, ajhakupwatalila nchuka ghola, “Nchuka jhumutenda kangombo jhonjo kuhoto ndeka kulonge na jwangajhoha machikilo, nimenga, muneke kangombo jhonjo na kunyingii jhe kabhele!” ");
INSERT INTO dne_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Peniya nchuka ujhakulalama, ujhakugwiya na kuntenda kangombo kihinduhindu, na kumoka. Kangombo ajhakubhonekana ngita atehi kuwegha, na bhange bhalongela, “Awile!” ");
INSERT INTO dne_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Peniya, Yecho ajhakunkamuu lubhoko kangombo, ajhakuntangatila kujhinula, na jwenio ajhakujhema. ");
INSERT INTO dne_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bhahe, Yecho pajhingila nkate, bhabholwa bhake bhajhakunkonya, “Bho, nhwalo gwa nike twenga tukahotwi ndeka kubhenga nchuka?” ");
INSERT INTO dne_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yecho ajhakwalobholela, “Nchuka ngita ghongo nhoto ndeka kubhoka ade kwa kunnyopa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yecho na bhabholwa bhajhakubhoka, kujhendelela na mwanja gwabhe kupete ku kilambo cha ku Galilaya. Yecho akapahi jhe bhando bhange bhamanye pabhile, ");
INSERT INTO dne_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","nhwalo akibha abholita bhabholwa bhake. Ajhakwalobholela, “Mwana gwa Mundo nabhankamuha mu mabhoko gha bhando na kunkoma. Nambo lichiko lya utato kubhoka mukuwegha nayoka.” ");
INSERT INTO dne_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nambo bhabholwa bhake bhakamanyitejhe nhwalo gwenio. Bhajhakunyoghopa kunkonya. ");
INSERT INTO dne_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bhahe, bhajhakuhika ku kilambo cha ku Kapelenaumo, na pakibha kajhake, Yecho ajhakwakonya bhabholwa bhake, “Nkomanila nike undela?” ");
INSERT INTO dne_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bhene bhajhakukotoka, undela bhataungina ndi ghane jwabhii nkolongwa pakate jhabhe. ");
INSERT INTO dne_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yecho ajhakutama pahe, ajhakwakema bhabholwa bhake kome na bhabhele, ajhakwalobholela, “Mundo jwapala kubhehe nkolongwa nabhaha jwandina na kubhehe ntumiche jha bhoha.” ");
INSERT INTO dne_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bhahe, Yecho ajhakuntola mwana jwandina ajhakunkumbatila, ajhakujhemeka pakate jhabhe, na kwalobholela, ");
INSERT INTO dne_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Jwampoke mwana ngita jhonjo kwa liina lyango, ambokii nenga. Na jwamboke nenga, ambokii nenga tujhe, ampoke jwandumita.” ");
INSERT INTO dne_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohane ajhakunnobholela Yecho, “Bhambo, tunkolile mundo abhenga michuka kwa liina lino na twenga tujhakunkelebhuha nhwalo jwenio abhii jhe pamonga na twenga.” ");
INSERT INTO dne_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yecho ajhakulonge, “Nkotoka kunkelebhuha, mana abhii jhe mundo jwahoto kuhenga gha kukangacha kwa liina lyango, na papa na kuhoto kulonge ghanganandela kwa nenga. ");
INSERT INTO dne_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nhwalo mundo jhojhoha jwangatukana, jwenio nnyito. ");
INSERT INTO dne_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ninobholela chakaka, mundo jhojhoha jwampekeya kibaba cha mache gha kunywegha, nhwalo mwenga ndi mundo jwa Kilichitu, chakaka nampokela ndweko yake. ");
INSERT INTO dne_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mundo jhojhoha jwapala kuhobhecha jhumo jwa bhamba bhana bhibhahobholela bhatende jwahenge uhakaho, mbaha kwa mundo jwenio kuntabhalila lwalwa pantandala na kuntaghii kumbwane kuliku malagho gha Chapanga lichiko lyenio. ");
INSERT INTO dne_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Lubhoko lwino anda luhobhecha kuhenga uhakaho, mbaha kuluheketa. Mbaha kujhingii mu ughome na lubhoko lumo, kuliku kujhingii mumwotu gwa machiko ghoha ghangapeta na mabhoko ghino. ");
INSERT INTO dne_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mwenio hunye ihwejhe mumwotu gwake uhimikajhe. ");
INSERT INTO dne_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Anda lugholo luhobhecha kuhenga uhakaho, mbaha kuluheketa. Mbaha kujhingii mu ughome na lugholo lumo. Kuliku kujhingii na magholo mabhele mumwotu gwa machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mwenio, hunye yake ihwe ndeka na mwotu gwake uhimajhe. ");
INSERT INTO dne_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na liho lino anda luhobhecha, mulibhohe! Mbaha kujhingii mu unahota nkolongwa gwa Chapanga mmii na liho limo, kuliku kubhehe na miho mabhele na kutaghwa mu mwotu gwa machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mwenio hunye yake ihwejhe, na mwotu uhimika jhe. ");
INSERT INTO dne_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Kila mundo najhelebhuka kwa mwinyo ngita kipeka pibhaleke mu mwotu. ");
INSERT INTO dne_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mwinyo gwambone, anda uhobhecha kunogha kwake, nabhalekela nike ade unoghe kabhele? “Mme na mwinyo gwa ukoche pakate jhino na ntame kwa uteeke.” ");
INSERT INTO dne_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yecho ajhakubhoka pachenda na kujhenda ku Yudeya, ajhakujhomboka kwiye mulukemba lwa ku Yolodane. Lilongo lya bhando lijhakunyendela kabhele, na jwenio ajhakwabhola kabhele ngita chayobhalile. ");
INSERT INTO dne_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bhahe, Mapwalichayo bhange bhajhakunyendelela Yecho kwa kunyambila bhajhakunkonya, “Bho, Lilaghalikilo lya Chapanga lijheketela munalome kuneka nhwana mundo?” ");
INSERT INTO dne_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yecho ajhakwajhanguu, “Bho, Mucha akanaghalikiye nike?” ");
INSERT INTO dne_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na bhene bhajhakulonge, “Mucha akalaghalikiye munalome anyandikila baluwa na kunneka nhwana gwino.” ");
INSERT INTO dne_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yecho ajhakwalobholela, “Mucha akajhandikile Lilaghalikilo lyenio nhwalo gwa kujhundupa kwa kubholekeka kwino. ");
INSERT INTO dne_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nambo Mucha akajhandike, kuhumii mukupangana nnema Chapanga akapangine munalome na mwikeghe. ");
INSERT INTO dne_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Peniya, munalome nanneka tate mundo na majhe mundo, nabhabha pamo, ");
INSERT INTO dne_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na bhene bhabhele nabhabha yegha jhimo. Na bhabhele kabhejhe, nabhabha yegha jhimo’ ");
INSERT INTO dne_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bhahe, chalombaniche Chapanga, abhii jhe mundo jwakulekanicha.” ");
INSERT INTO dne_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pibhajhingila nkate munyumba, bhabholwa bhake bhajhakunkonya nhwalo gwa lilobhe lyenio. ");
INSERT INTO dne_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na Yecho ajhakwalobholela, “Mundo jhojhoha jwaneka nhwana mundo na kutolela mwikeghe jhonge, atende ngongola nhwana mundo. ");
INSERT INTO dne_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na helahela mwikeghe jwanneka ungana mundo na kutolelwa na jhonge atende ngongola ungana mundo.” ");
INSERT INTO dne_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bhando bhange bhajhakunete Yecho yana ichokombe aipapahe, bhabholwa bhake bhajhakwipwatalila. ");
INSERT INTO dne_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yecho pabhonita gheniya, ajhakuyoma, ajhakwalobholela, “Muileke yana ihike kwa nenga, mangaibhilikiya, nhwalo Unahota gwa Chapanga ndi kwa bhando bhubhabhii ngita yana. ");
INSERT INTO dne_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ninobholela chakaka, mundo jhojhoha jwangapoke Unahota gwa Chapanga ngita yana ichokombe, nanyingii ng'o mwenio.” ");
INSERT INTO dne_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Peniya ajhakwapokela yana yenio, ajhakwabhekela mabhoko, na kuikuchulila kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yecho patumbwila kabhele mwanja gwake, mundo jhumo ajhakunhikilila lubhelo, ajhakutama makilikite palonge jhake, ajhakunkonya, “Mmola jwambone, ndende nike mme na ughome gwa machiko ghoha ghangapeta?” ");
INSERT INTO dne_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yecho ajhakunyanguu, “Bho, ungema nenga naumbone? Abhii jhe jwaumbone nga Chapanga kanjika chake. ");
INSERT INTO dne_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mulimanyite maha lilaghalikilo, ‘Nkotoka kutenda ngongola amu nkotoka kukoma amu nkotoka kujhibha amu nkotoka kulonge uwange na nkotoka kukopokeya na bhajhokanikiya tate gwino na majhe gwino.’ ” ");
INSERT INTO dne_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na mundo jwenio ajhakunyanguu, “Mmola, gheniya ghoha nighakamwii punikibha nakangombo.” ");
INSERT INTO dne_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yecho ajhakunnolekeya, ajhakumpala, ajhakunnobholela, “Kipongwike kilebhe chimo. Nnyende mukachuluche ilebhe hino inkwete, mbijha makabhaghulile akahocho, na mwenga namaha na kihukilo kunane. Peniya ndi uhika ungengame.” ");
INSERT INTO dne_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Paijhohine gheniya, ajhakuhechuka na kubhoka kongo abhii ngolongondi, nhwalo akibha mundo jhuna ilebhe twe, akapahi jhe kubhoha ilebhe yake. ");
INSERT INTO dne_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yecho ajhakulinga koha, ajhakwalobholela bhabholwa bhake, “Naibhaha kujhundupa kwa mundo jwabhii na ilebhe twe kumpekehe Chapanga anongoche ughome munahota nkolongwa gwake!” ");
INSERT INTO dne_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Bhabholwa bhake bhakakangiche malobhe ghake. Yecho ajhakwalobholela kabhele, “Yana yango, chakaka kujhundupa kujhingii mu nahota nkolongwa gwa Chapanga! ");
INSERT INTO dne_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ndi ijhojwike kwa kinyama chikikemwa ngamiya kuholota pa lihoto lwa luchungulo lwa mpacha, kuliku jwabhii na ilebhe twe kujhingii mu Unahota nkolongwa gwa Chapanga!” ");
INSERT INTO dne_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bhabholwa bhake bhakakangiche hake bhajha kukonyana, “Ndi ghane bhahe, bho, ghane ngohe nahotola kughombokoka?” ");
INSERT INTO dne_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yecho ajhakwalolekeya, ajhakwalongelela, “Kwa mundo iwechekana jhe, kwa Chapanga naha ndeka, nambo kwa Chapanga ghoha ghiwechekana.” ");
INSERT INTO dne_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peniya Petile ajhakunobholela, “Dolekeya! Na twenga bho? Ghoha tughalekite, tunkengime mwenga!” ");
INSERT INTO dne_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yecho ajhakunnobholela, “Ninobholela chakaka, kila mundo jwalekite nyumba, na nnongo mundo na nnombo mundo na majhe mundo na tate mundo na yana mundo na mighonda jhake nhwalo gwa nenga na Malobhe gha Mbone, ");
INSERT INTO dne_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","napokela mbwe ngoheno. Nyumba na akalongo na nnombo na majhe na yana na mighonda pamonga na malagho, na palonge nabhaha na ughome gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bhamahena bhibhawacha akanahota bha ngoheno nabhabha akachokombe, bhakujhomolela nabhabhaha bhakutumbula.” ");
INSERT INTO dne_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bhahe, bhabholwa bhake bhakibha undela kuhobhoka ku Yeluchalemo. Yecho ajhakwalobholela bhabholwa bhake bhakibha na bwaghaliya na bhando bhubhakengima na bhene bhakibha na bwaghaliya helahela. Yecho ajhakwatola bhabholwa panga bhando, ajhakutumbuu kwalongelela ghighapala kunkolela. ");
INSERT INTO dne_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ajhakwalobholela, “Unyokanikiye, tujhenda ku Yeluchalemo, na kwenio Mwana gwa Mundo nabhankamuha kwa akapiya matambiko bhakolo na bhabhola bha Malaghalikilo. Na bhene nabhahadabulwa bhankome na kunkamuya kwa bhando bha ilambo henge. ");
INSERT INTO dne_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na bhene nabhankinila na kuhunii mata na kunkuna yato na kunkoma. Nambo lichiko lya utato nayoka.” ");
INSERT INTO dne_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Peniya Yakobu na Yohane, yana mundo Chebedayo, bhajhakunjhendela Yecho, na kunobholela, “Mmola, tupala mututendele kilebhe chitupala kunyopa.” ");
INSERT INTO dne_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yecho ajhakwakonya, “Mipala nintendele nike mangota?” ");
INSERT INTO dne_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bhabholwa bhajhakujhanguu, “Pipala kutama pakigoda chino cha Unahota nkolongwa na ung'alicho gwino, tupala kutama na mwenga, jhumo lubhoko lwalelo na jhonge lubhoko lwa ngejha.” ");
INSERT INTO dne_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yecho ajhakwalobholela, “Umanyite jhe chimujhopa. Bho, mihotola kunywegha mukibaba cha malagho chininywegha nenga, amu kubatichwa ubaticho ngita ghunibatichwa nenga?” ");
INSERT INTO dne_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bhala bhabholwa bhajhakujhanguu, “Tuhotola.” Yecho ajhakwalobhalela, “Komiche jhimbala kunywegha naunywaha kwele, na mbatichwa ubaticho ngita chinibatichwa nenga. ");
INSERT INTO dne_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ndi ghane jwapala kubhehe kwa lelo amu kwa ngejha kwango. Nambo napwache jhango ndeka kupanga, nabhapelwa bhibhapangilwe na Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Bhala bhabholwa bhange kome pibhajhohina chibhajhopita, bhajhakutumbuu kwachimwa Yakobu na Yohane. ");
INSERT INTO dne_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Bhahe, Yecho ajhakwakema bhoha na kwalobholela, “Umanye bhala bhibhabhonekana bhakolo kwa bhando bha ilambo henge bhilongocha kwa likakala. Bhakolo bheniya bhina uhotolo ghoha kwa bhando bhabhe. ");
INSERT INTO dne_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nambo kwino mangota nahi jhe, jwapala kubhehe nkolongwa pakate jhino, abhehe ntumiche gwino. ");
INSERT INTO dne_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jwapala kubhehe nkolongwa kupeta bhoha, ipalwa abhaha ntumiche jwabhoha. ");
INSERT INTO dne_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mwana gwa Mundo, ahikitejhe kuhengelwa, nambo ahikite kwahengela, na kubhoha ughome gwake kwakombola bhando bhoha.” ");
INSERT INTO dne_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bhahe, bhakahikite ku Yeliko, na jwenio Yecho na bhabholwa bhake na lilongo lya bhando libhokita kumuche, mundo jhumo jwangalola jwankemitwa Batulomayo mwana gwa Timayo, atamita mupele mwa ndela kujhopajhopa. ");
INSERT INTO dne_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pajhohina Yecho jwa ku Nachalete atehila kupeta peniya, ajhakutumbuu kunonoha lilobhe, “Yecho! Mwana gwa Daude, umonele kiya!” ");
INSERT INTO dne_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bhando bhamahele bhajhakumpwatalila na kunnobholela akotoke, jwenio ajhakuchocha kunonoha lilobhe, “Mwana gwa Daude, umonele kiya!” ");
INSERT INTO dne_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yecho ajhakujhema, kulonge, “Munobholele ahike.” Bhahe, bhajhakunkema jwangalola, bhajhakunobholela, “Nkangamale mwojho! Jhema, ankema.” ");
INSERT INTO dne_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na jwenio ajhakutaghii kutale ngobho yake, ajhakuhomba, ajhakunnyendela Yecho. ");
INSERT INTO dne_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yecho ajhakunkonya, “Mipala nintendele nike?” Jwangalola ajhakunnobholela, “Mmola, nijhopa kulola.” ");
INSERT INTO dne_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yecho ajhakunobholela, “Nnyende, kihobholelo chino kinamiche.” Papalapala jwangalola ajhakulola na kunkengama Yecho. ");
INSERT INTO dne_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yecho na bhabholwa bhake pibhabhandikila kuhika ku Yeluchalemo bhajhakuhika ku Betifage na ku Betaniya, bhakabhandikii pakitombe cha ku Micheitune. Yecho ajhakwatuma bhabholwa bhake bhabhele, ");
INSERT INTO dne_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ajhakwalobholela, “Nnyende muchenda imuibhona. Na pumujhingila mu chenda yenio, namumona litole lya liponda bhalikongile, lyamela anatumbu jhe kutami mundo. Na mulibhopole na nhwike nalyo pamba. ");
INSERT INTO dne_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Anda mundo ankonyite, ‘Bho, mikabhopola?’ Munnobholele, ‘Bhambo ampala namujhicha kabhele ngoheno.’ ” ");
INSERT INTO dne_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bhahe, bhajhakujhenda, bhajhakunkolela kaponda bhakakongii pa nnyango gwa nyumba pandela. Pibhabhopwila, ");
INSERT INTO dne_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","bhando bhubhakibha bhajhemite peniya bhajhakwakonya, “Nhwalo gwa nike mukabhopo kaponda?” ");
INSERT INTO dne_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bhabholwa bhakajhangwii ngita Yecho chakabhalobhalile, na bhando bhala bhajhakwaleka bhajhende nako. ");
INSERT INTO dne_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bhabholwa bhajhakumpelekela Yecho kaponda. Bhajhakujhala ngobho yabhe panane jha liponda na Yecho ajhakuhobhokela na kutama panane jhake. ");
INSERT INTO dne_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bhando bhamahele bhajhakujhala ngobho yabhe mundela, bhange bhajhakujhala matuto gha mikongo ghibhakapengwii kumighonda. ");
INSERT INTO dne_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bhando bhoha bhibhakalongalile na bhibhankengima, bhajhakunonoha malobhe ghabhe bhalongela, “Ulombo kwa Chapanga! Tuhanganile jwenio jwahika kwa liina lya Bhambo! ");
INSERT INTO dne_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ghuna mota unahota nkolongwa ghuhika gwa tate gwito Daude. Ulombo kwa Chapanga jwa kunane!” ");
INSERT INTO dne_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yecho ajhakujhingii kubomane jha ku Yeluchalemo ajhakujhenda ade mu Nyumba jha Chapanga, ajhakulingukiya kila kilebhe. Nhwalo ikibha kimihe, ajhakujhenda ku Betaniya pamonga na bhabholwa bhake kome na bhabhele. ");
INSERT INTO dne_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lukela jhake, pubhabhokita ku Betaniya, Yecho ajhakubhona njala. ");
INSERT INTO dne_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bhahe, ajhakubhona nkongo gwa nkojho chakutale ubhii na mahamba ghamahena ajhakuheghelela alinge pange upambike uhohe. Pauheghelila, akaukoli upambike ndeka nga mahamba tugha, ukahikite ndeka muda gwa kupambika. ");
INSERT INTO dne_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Peniya ajhakuulongelela nkongo ghola, “Kutumbulii deleno na machiko ghoha mundo jhojhoha nalyejhe uhohe kuhumii munkongo hogho.” Na bhabholwa bhake bhakajhohine malobhe gheniya. ");
INSERT INTO dne_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bhahe, bhakahikite ku Yeluchalemo, Yecho ajhakujhingii mu Nyumba jha Chapanga na kutumbuu kwabhenga bhando panja bhibhachulwicha na kuhemela ilebhe mwenio. Ajhakupendengula njangwale ya bhando bhala bhubhakibha bhajhangangina mbijha, na igoda ya bhala bhibhachulwicha ngunda. ");
INSERT INTO dne_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Akabhakanakii bhando kupeta ndeka pulubhanja jwakapitite na kilebhe chochoha mu Nyumba jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Peniya ajhakwabhola, “Ijhandikwe, ‘Nyumba jhango nahibha nyumba jha kunnyope Chapanga kwa bhando bha ilambo yoha.’ Mangota mwenga uyohite nkwembe gwa kukwatulila ilebhe!” ");
INSERT INTO dne_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo pibhajhohina gheniya, bhakatumbwii kupalaha kihokola chakupala kunkoma. Bhakajhogwipe nhwalo gwa lilongo lya bhando ghukangicha mabholo ghake. ");
INSERT INTO dne_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pikihikita kimihe, Yecho na bhabholwa bhake bhakabhokite ku bomane. ");
INSERT INTO dne_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Putiputi, pubhapetita, bhajhakubhona nkongo gwa nkojho ghola ujhomite chwaa, mikegha ade kukilegheleghe chake. ");
INSERT INTO dne_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petile akaukombwike nkongo ghola, ajhakunobholela Yecho, “Mmola, dolekeya! Nkojho ghola ghumulapanikiya, ujhomite!” ");
INSERT INTO dne_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yecho ajhakwalobholela, “Muhobholele Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ninobholela chakaka, mundo anda akilobholile kitombe chenje heghela hoko, mukitaghile kumbwane, changakiholo ku mwojho gwake, anda ahobholela ghoha ghalongii naghatendeka, natendelwa kilebhe i. ");
INSERT INTO dne_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nambo ninobholela, piminyopa kilebhe chochoha Chapanga, na unhobholela nampokela. ");
INSERT INTO dne_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pimijhema na kunnyopa Chapanga, tunnekekehe kila mundo jwalemwite, Tate gwito jwa kunane kwa Chapanga nanekekeya na mangota hele ghunemwite. ");
INSERT INTO dne_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nambo changalekekeya bhange bhibhalemwite, na Tate gwino jwa kunane nannekekeya ndeka mangota mwe ghinnemwite.” ");
INSERT INTO dne_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bhahe, bhajhakuhika kabhele ku Yeluchalemo. Yecho pakibha atyangita pa Nyumba jha Chapanga, akapiya matambiko bhakolo, bhabhola bha Malaghalikilo na ighogholo bhajhakunyendelela, ");
INSERT INTO dne_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bhajhakunkonya Yecho, “Bho, mihenga ghanga kwa ukindendeke gwa ghane? Na ghane jwampekiye mwenga ukindendeke gwa kuhenga gheniya?” ");
INSERT INTO dne_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yecho ajhakwalobholela, “Nipala kunkonya kilebhe chimo. Anda unyangwii, na nenga naninobholela nihenga ilebhe henge kwa ukindendeke gwa ghane. ");
INSERT INTO dne_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bho, ukindendeke gwa Yohane gwa kubaticha uhumita ko, kunane kwa Chapanga amu kwa bhando? Unyangule.” ");
INSERT INTO dne_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bhajhakutumbuu kukonyana, “Anda tulongii, ‘Ghahuma kwa Chapanga,’ nalongela, ‘Bho, nhwalo ghane mukajheketii ndeka?’ ");
INSERT INTO dne_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Akakolo bha matambiko na bhabhola bha Malaghalikilo anda tulongii, ‘Uhumita kwa bhando,’ naibha bho?” Bhakalijhogwipe lilongo lya bhando bhakamanyite chakaka Yohane akibha Nnondole jwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bhahe, bhajhakunnyanguu Yecho, “Twenga timanyitejhe.” Na jwenio Yecho ajhakwalobholela, “Na nenga naninobholela ndeka nihenga ghanga kwa ukindendeke gwa ghane.” ");
INSERT INTO dne_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yecho ajhakutumbuu kulonge nabho kwa nnandanikiho alongila, Mundo jhumo akalemite nng'onda gwa michabibo. Ajhakutindikiya ubhegho, na pakate jhake ajhakutengenecha chehemo jha kuminyii chabibo, ajhakuchenga kichimba cha ulendo. Ajhakujhahikicha nghonda gwenio kwa bhando bhange, na kujhenda ku kilambo cha kutale. ");
INSERT INTO dne_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pughahikita machiko gha mahuno, akantumite ntumiche gwake kwa bhala bhubhajhahike mighonda, akannetee chehemo jha mahuno gha nghonda gwake. ");
INSERT INTO dne_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bhubhalema bhala bhajhakunkamuu ntumiche jhola, na bhajhakuntyala, bhajhakumenga mabhoko matopo. ");
INSERT INTO dne_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akantumite kabhele ntumiche jhonge. Jwenio bhajhakunkamuu na kuntende ilebhe ya kunnete hone ade kunkocholana muto. ");
INSERT INTO dne_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Peniya nkolo nghonda ajhakuntuma kabhele ntumiche jhonge na bhubhajhahikichwe mighonda bhajhakunkoma na jwenio. Na bhange bhamahele bhibhakatumitwe, bhakabhujhite jhe na bhange bhakakomitwe. ");
INSERT INTO dne_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pakahighilile na mundo jhumo, mwana jwampala. Na kujhomolela kwake ajhakuntuma jwenio alongila, Nabhanendema mwanango. ");
INSERT INTO dne_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Na bheniya bhubhalema bhajhakupwepelana, ‘Jhonjo ndi nabhujhila mighonda, bhahe, tunkome nghonda gwake ubhehe gwito!’ ");
INSERT INTO dne_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Na jwenio bhajhakunkamuu, na kunkoma na kuntaghii kutale jha mighonda jha chabibo.” ");
INSERT INTO dne_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Bhahe, nkolo nghonda natenda bho? Chahika kwakoma bhubhalema na kujhahikicha nng'onda gwenio gwa michabibo kwa bhando bhange. ");
INSERT INTO dne_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Bho, nchomitejhe Majhandiko ghanga? ‘Lighanga libhalikanite mapunde kuchenga, na ngoheno libhii lighanga likolo lya nchinge. ");
INSERT INTO dne_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bhambo ndi jwatehi kilebhe chenje, na lyenio lya kukangacha kwito!’ ” ");
INSERT INTO dne_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo na akahokolo bhakamanyite nnandanikiho ghongo gwalongi bhene. Peniya bhapata kujhigha kunkamuu, bhalijhogwipa lilongo lya bhando. Bhahe, bhajhakunneka, na bhene kujhenda. ");
INSERT INTO dne_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bhahe, Mapwalichayo na bhabholwa bha kikunde cha Helode bhakatumitwe bhanyambii Yecho kwa malobhe ghake. ");
INSERT INTO dne_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bhajhakunyendelela na kunnobholela, “Mmola, timanya mwenga mundo jwamaha jhumulonge chakaka, hilu minyoghopajhe mundo jhojhoha. Hilu ukolo gwa mundo kwino mwenga kilebhe nacho, mibhola chakaka ndela jha Chapanga. Tunkonye bho, ndi maha kulepa kode kwa munahota nkolongwa jwa ku Loma?, Tilepe amu tikoto kulepa?” ");
INSERT INTO dne_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nambo Yecho akamanye umbebhebhe gwabhe, ajhakwalobholela, “Bho, munyighanikiya nhwalo gwa nike? Unangiye mbijha.” ");
INSERT INTO dne_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bhajhakunnetela. Na jwenio ajhakwakonya, “Kumiho kongo kwa ghane?” Bhajhakunyanguu, “Kwa munahota nkolongwa jwa ku Loma.” ");
INSERT INTO dne_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Bhahe, Yecho ajhakwalobholela, “Yu munahota nkolongwa jwa ku Loma mupela munahota nkolongwa jwa ku Loma, na ya Chapanga mupela jwenio Chapanga.” Bhajhakukangachwa nako jwenio. ");
INSERT INTO dne_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Peniya Machadukayo bhubhalongi kuyoka kubhii jhe bhajhakunyendelela Yecho, bhajhakunkonya, ");
INSERT INTO dne_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mmola, Mucha akatulaghalikii, ‘Mundo anda awile na kuleka mwikeghe ntonga, nnongo mundo antole amujhi lipwela, ampapile nnongo mundo yana.’ ");
INSERT INTO dne_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bhahe, tulongele, pakibha na akalongo chaba. Jwakutumbula ajhakutolela mwikeghe, akawile changa mwana. ");
INSERT INTO dne_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jhubhena ajhakumujhii lipwela, na jwenio akawile changa mwana, na jwa utato akawile changa leka mwana. ");
INSERT INTO dne_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bhoha chaba bhakawii changa leka yana. Na kujhomolela lipwela ajhakuwegha. ");
INSERT INTO dne_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bhahe, lichiko lya bhando pibhapala kuyoka mwikeghe jwenio nabhaha nhwana gwa ghane? Bhoha chaba bhakantolile.” ");
INSERT INTO dne_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yecho ajhakwalobholela, “Mangota mwe nnemwite nhwalo mughamanyitejhe Majhandiko gha Chapanga hilu likakala lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bhando bhibhawile anda bhayokite bhatole ndeka amu kutolelwa, nabhabhaha ngita akatumiche bha kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kuyoka kwa bhubhawile, bho, nchomitejhe mukitabo cha Mucha chehemo jha kiheghejha chikitinika mwotu? Chapanga ajhakunnobholela Mucha, ‘Nenga na Chapanga jwa Ulahimo, Chapanga jwa Isaka na Chapanga jwa Yakobu.’ ");
INSERT INTO dne_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bhahe, jwenio chi Chapanga jwa bhando bhubhawile. Nambo Chapanga jwa bhando bhibhabhii na ughome. Mangota mwe nnemwite hake.” ");
INSERT INTO dne_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jhumo jwa bhabhola bha Malaghalikilo ajhakuhika, akajhohine mitaungano jhabhe, pamonita Yecho ajhangwii mbone, ajhakukilaa, na kunkonya, “Bho, Malaghalikilo ghoha ghahalile, lyoke lya kutumbula?” ");
INSERT INTO dne_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yecho ajhakunnyanguu, “Lya kutumbuu lende, ‘Nnyokanikiya bhando bha ku Ichilahele! Bhambo Chapanga gwito, kanjika chake Bhambo. ");
INSERT INTO dne_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mupale Bhambo Chapanga gwino kwa mwojho gwino ghoha, kwa ughome gwino ghoha, kwa malango ghino ghoha na kwa likakala lino lyoha.’ ");
INSERT INTO dne_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na jha ubhele jhenje, ‘Mupale nnyino ngita chimukipala mabhene.’ Libhiijhe lenge lilaghalikilo kupeta lyenio.” ");
INSERT INTO dne_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bhahe, mmola jwa malaghalikiho jhola ajhakunobholela, “Ghamaha mmola! Nnongii chakaka Chapanga jhumo abhii jhe jhonge ngita jwenio. ");
INSERT INTO dne_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mundo ampale Chapanga kwa mwojho gwake ghoha, kwa malango ghoha, na kwa likakala lyoha na kumpala nnyino ngita chimkipala mabhene. Lijhambu lyamaha kupeta litambiko lya kukomelekeya na kiyombo chenge.” ");
INSERT INTO dne_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yecho panolokiya mundo jwenio ajhangwii kwa kukikakamula, ajhakunobholela, “Mwenga mmi jhe kutale kunnekekeya Chapanga anongoche ughome gwino munahota nkolongwa.” Pajhomolila gheniya, Na bhene bhakajhighite jhe kunkonya machwale ghange. ");
INSERT INTO dne_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yecho pakibha abholita bhando pa Nyumba jha Chapanga, ajhakukonya, Bho, bhabhola bha Malaghalikilo bhilonge Kilichitu ndi mwana gwa Daude? ");
INSERT INTO dne_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daude jwenio alongwichwa na Uhuke gwa Chapanga alongila, Bhambo akanobholile Bhambo gwango, Ndame lubhoko lwalelo, ade nibhabheke akamakoko kuhe jha magholo ghino. ");
INSERT INTO dne_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Daude jwenio inkema Kilichitu nkomboche Bhambo. Bhahe, Kilichitu nabhe bho, mwana mundo?” Lilongo lya bhando ukibha unyokanikiya kwa kuhangana. ");
INSERT INTO dne_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mu mabholo ghake, Yecho akalongii, “Mukichunge na bhabhola bha Malaghalikilo upala kupetapeta kongo bhakiwalile makanjo matandamaho na kujhambuchwa kwa ichima mulighuliho. ");
INSERT INTO dne_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Helahela bhene upala kuhaghuu kutama mukigoda ya palonge pa nyumba jha kukonganikii Akayahude, na kutola pwache jha ichima muunyagho gwa kulyegha. ");
INSERT INTO dne_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Na kwajhibhila akakeghe akanawela kongo bhakilangiya kwa bhando kunnyopa Chapanga kwa malobhe gha mahena! Lichiko lya mwicho nabhabha mulung'ahe lukolongwa bhando bhene!” ");
INSERT INTO dne_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yecho pakibha abhandikii mukichukilo kichokombe cha kupekiya mbijha. Alolita bhando chibhalekela mbijha mukichukilo chikibhii nkate munyumba jha kunyope Chapanga. Bhando bhapihita yamahele ibhabhii nayo. ");
INSERT INTO dne_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Peniya ajhakuhika majhe jhumo nhocho nawela, ajhakupiya chente ibhena ya mbijha. ");
INSERT INTO dne_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Peniya Yecho ajhakwakema bhabholwa bhake, ajhakwalobholela, “Ninnobholela chakaka, majhe jhonjo jwanga kilebhe nawela alekii kilebhe kikolongwa mukichukilo cha kulekele mbijha kuliku bhange. ");
INSERT INTO dne_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bhando bhange bhoha bhapihite ilebhe kubhoka mu majhonjekeko ghabhe. Nambo majhe honjo nhocho, akung'winde ilebhe yake yoha yabhii nako, akwangalikii kila kilebhe chikintangatila abhehe ghome.” ");
INSERT INTO dne_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yecho pakibha apitita mu Nyumba jha Chapanga, jhumo jwa bhabholwa bhake ajhakunnobholela, “Mmola, dolekeya maghanga na majhumba ghanga chighabhii ghambone gha kukangacha!” ");
INSERT INTO dne_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yecho ajhakwalobholela, “Bho, mughahwene majhumba ghanga chighabhii makolongwa? Libhii jhe hilu lighanga limo lilipala kuhighalika panane jha lighanga lenge, kila kilebhe nakibhaha heghuheghu.” ");
INSERT INTO dne_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yecho pakibha atamite panane pa kitombe chuku Micheitune alolekiya Nyumba jha Chapanga, Petile na Yakobu na Yohane na Anduleya bhajhakunkonya pakiyepela, ");
INSERT INTO dne_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Chonde, mutulobholele ilebhe henge naihengeka ligha? Bho, na nginyililo ghane jhipala kulangiya kuhika kwino na upehekelo gwa machiko?” ");
INSERT INTO dne_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yecho ajhakutumbuu kwalobholela, “Mukilolekehe mundo akoto kuhika na kunkopokeya. ");
INSERT INTO dne_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bhamahena nabhahika kwa liina lyango, jhumo nalongela, jwenio ndi nenga! Na bhene nabhankopokeya bhando bhamahele. ");
INSERT INTO dne_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pumipala kujhoha mbwepo ya ngondo na bhando bhalonge malobhe gha ngondo, nkotoka kujhoghopa. Ilebhe yenio naipitila tugha, Nambo kujhomokela kwake kwamela. ");
INSERT INTO dne_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kilambo chimo na akakomana na kilambo chenge, unahota nkolongwa ghumo naukomana na unahota ghonge, kila chehemo napabha nnindimilo gwa nnema nailongohana na njala. Ilebhe henge ngita lipyanda lya kutumbuu kupapa.” ");
INSERT INTO dne_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mangota mwe mukilangiye mana bhando nabhatenda kuntakalila pa bwalo, na kunchwapula yato mu Nyumba jha kukonganikii Akayahude. Nabhampeleka palonge jha akanahota malongelele, ndi kwa nhwalo gwa nenga. ");
INSERT INTO dne_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nambo Malobhe gha Mbone naghatangachwa kwa ilambo yoha. ");
INSERT INTO dne_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na bhene pibhapala kunkamu na kuntakalila, nkoto kubhehe na kindondwa chimpala kulonge. Muda pupala kuhika nnongele chochoha chimpala kupelwa, mangota mwe ndeka jhumpala kulonge, nambo Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nnongo nanyambila nnongo mundo akomwe na tate nanyambila mwana mundo, na yana yenio hele nabhakachulana akatate bhabhe na kwakoma. ");
INSERT INTO dne_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bhando bhoha nabhanchimwa mangota nhwalo gwa liina lyango, nambo jwapala kuhimbilila ade kujhomolela jwenio naghombokoka mulung'ahe lwa machiko ghoha ghangapeta.” ");
INSERT INTO dne_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pumpala kubhona lijhambu lihakanaho lilihangabhana lijhemite pangapala kujhema.” Jwachoma na amanye. Peniya bhubhabhii pa Yudeya bhabhutikila ku kitombe. ");
INSERT INTO dne_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nambo mundo jhojhoha jwabhii pa kipaghalo akotoka kuhuluka kujhingii nkate na kutola ilebhe yake! ");
INSERT INTO dne_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Helahela jwabhii kunghonda akotoka kubhujha kajhake na kutola magwanda ghake. ");
INSERT INTO dne_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nakole kiya hake kwa akakeghe bhubhabhii na ndumbo na bhibhajhongecha nabhabhaha mumalagho kwa machiko gheniya! ");
INSERT INTO dne_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mbaha tunyope ilebhe yenio ikoto kupitii machiko gha malile. ");
INSERT INTO dne_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nhwalo machiko gheniya napabhaha na lung'ahe kuhumii Chapanga mukupanganwa nnema lunawahijhe kupitila na hilu naipitijhe kabhele. ");
INSERT INTO dne_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Peniya Bhambo nakupongocha jhe machiko gheniya abhii jhe mundo jwapala kughombokoka. Peniya nhwalo gwa bhando bhake, apongwiche machiko gheniya. ");
INSERT INTO dne_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Bhahe, mundo anda anongalile, ‘Dolekeya, Kilichitu abhii pamba,’ amu ‘Abhii kola,’ nkotoka kunyokanikiya. ");
INSERT INTO dne_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Nhwalo nabhapitila bhakilichitu bhuwange na milondole bhauwange. Nabhalangiya nginyililo ngolonga na ikangacho ya kuhotu kwakopokeya bhando bhake Chapanga anda nabhahotola. ");
INSERT INTO dne_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mangota mwe mukilolekeye. Nenga ninnobholile ghoha kabula jha kupitila. ");
INSERT INTO dne_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Machiko gheniya, pulupala kupeta lung'ahe lono, lyobha nalibhaha nkate mulubhendo na mwehe naupihajhe lilangamule. ");
INSERT INTO dne_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na ndondwa naigwaha kuhumii kunane kwa Chapanga, na ilebhe yoha na likakala lya kunane kwa Chapanga nainyukanyuka. ");
INSERT INTO dne_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Peniya naumona nenga, Mwana gwa Mundo, nikahika na mahunde na kwa makakala twe gha ukolo. ");
INSERT INTO dne_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Peniya nabhatuma akatumiche bhake bhajhende mu pande yoha ncheche ya nnema bhakabhatole bhando bhake bhubhahaghulilwe na Chapanga kuhumii mujhomokelo ghongo ade upeekeho gwa nnema.” ");
INSERT INTO dne_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mukibhole nnandanikiho ghongo kuhumii nkongo gwa nkojho, mandabhe gha nkongo ghabhii mabhehe utumbuu kupiya mahamba, umanye kubhehe machiko gha kuhuna ghabhandikile. ");
INSERT INTO dne_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Helahela kwa mangota pimpala kughabhona ghahengeka gheniya ghoha, umanya Mwana gwa Mundo abhandikii kuhika. ");
INSERT INTO dne_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ninnobholela chakaka, kibheluko chenje nakipete jhe kabula jha kuhengeka ghanga. ");
INSERT INTO dne_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kunane kwa Chapanga na ilambo yoha nahipeta, nambo Malobhe ghango naghapitila ngita chinilonge. ");
INSERT INTO dne_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nambo abhii jhe mundo jwamanya lichiko amu lichaa lyenio nalihika ligha, hilu akatumiche bha kunane kwa Chapanga. Hilu Mwana, nga Tate ndi jwamanya. ");
INSERT INTO dne_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mukilolekehe na kukilenganikiya nhwalo mulimanyitejhe lichiko hilu lichaa lya kuhika. ");
INSERT INTO dne_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Naibhaha anda mundo jwabhokite pakajha jhake kutumbu mwanja na kwalekela ukindendeke akatumiche bhubhahighalike kajha, kila jhumo na lihengo lyake na kunobholela nnonda jwa pakajha akotoka kugholoka. ");
INSERT INTO dne_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chonde nkeluwe bhahe, mukilenganikiye, nhwalo umanyitejhe nkolo nyumba nabhujha ligha. Pange kimihe amu uhiko amu putiputi amu lukela. ");
INSERT INTO dne_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chonde mukilolekeye na mukakilenganikiye, anda ahikite kwa kupwitikalila, kongo ankoli ngholwike. ");
INSERT INTO dne_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Malobhe ghuninnobholela mangota, chonde ninnobholela mabhoha. Mukilolekehe na mukilenganikiye!” ");
INSERT INTO dne_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ghakahighalike machiko mabhele kuhika unyagho gwa Pachaka gwa Kiyahude na unyagho gwa Mabumunda ghangangedule. Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo bhakolo bhapaliya ndela jha kukamuu kwa kupwepa jha kunkoma Yecho. ");
INSERT INTO dne_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Peniya bhajhakulonge, “Tukoto kuhenga yenio lichiko lya unyagho gwa Pachaka, bhando bhiwecha kubheka bhulo.” ");
INSERT INTO dne_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yecho pakibha ku Betaniya, kajha kwa Simone kangombo jwakanamiche ulwalo gwa malohe. Yecho patehila kulyegha, majhe jhumo jwakibha na chupa jhikatenganichwe kwa maghanga ghikemwa Alabasita jhikibha na mahuta gha kunungila petelele ghikemwa naludo bei jhake ngolonga. Ajhakudindu chupa jhene, ajhakunyitila mahuta gheniya Yecho pamuto. ");
INSERT INTO dne_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bhando bhange bhibhakibha peniya pibhalolita lyenio bhajhakuyoma, bhajhakupwepa, “Nhwalo gwa nike kuhobheha mahuta petelele ngita ghanga? ");
INSERT INTO dne_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mahuta gheniya ghiwecha kuchuluchwa kwa mbijha jha nchahala gwa mundo jwahenga lihengo kwa chaka chimo, kwabhaghanichila akahocho na bhala bhanga kilebhe!” Majhe jwenio bhajhakumpwatalila. ");
INSERT INTO dne_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nambo Yecho ajhakwalobholela, “Muneke! Nhwalo gwa nike kung'aa? Chatei chambone. ");
INSERT INTO dne_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bhando bhina nhocho bhabhii pamonga na mangota machiko ghoha, mihoto kwatangatila pimipala. Nenga namejhe pamonga mangota mwe. ");
INSERT INTO dne_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Majhe hojho ateile pahotwile. Ajhitii yegha jhango mahuta kubheka mbone yegha jhango kabula jha malelo ghango. ");
INSERT INTO dne_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ninnobholela chakaka, popoha pannema Lilobhe lya Mbone nalitangachwa, bhando chibhalobholela bhando bhange kilebhe chenie chakiteii majhe jhola nakilongelwa na kukombokwa.” ");
INSERT INTO dne_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Peniya Yuda Ichikaliyote, jhumo jwa bhabholwa kome na bhabhele, ajhakujhenda kwa akapiya matambiko bhakolo kunnyambii Yecho. ");
INSERT INTO dne_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Akapiya matambiko bhakolo bhakahangine pibhajhohina malobhe gheniya, bhajhakulaghana kumpeke mbijha. Peniya Yuda ajhakutumbuu kupalaha ndela jha kunnyambila Yecho. ");
INSERT INTO dne_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lichiko lya kutumbula kwa unyagho gwa Mabumunda ghangalekela ngedule, Mwana limbelele lya ilulo ya Pachaka uchinjwa, bhabholwa bhake bhajhakunkonya, “Mipala tujhende kojhe tukalenganikiye chehemo jha kulelela Pachaka?” ");
INSERT INTO dne_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bhahe, Yecho ajhakwatuma bhabhele pakate jha bhabholwa bhake ajhakwalobholela, “Nnyende kubomane, namunkolela likambako atwekii kihulo cha mache. Munkengame, ");
INSERT INTO dne_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","munobholele Nkolo nyumba munnobholela, ‘Mmola ankonya, chumbi cha akaghene kibhii kojhe, chakulyegha Pachaka pamonga na bhabholwa bhango?’ ");
INSERT INTO dne_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jwenio nanangiya chumbi kikolongwa cha ku gholofa, chikikilimwe mbone, mutulenganikila mwenio.” ");
INSERT INTO dne_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na bhabholwa bhajhakujhenda kubomane, na kukikolela kila kilebhe kipanginwe ngita chabhalaghalikiye Yecho. Bhajhakulenganikiya chakulye Pachaka. ");
INSERT INTO dne_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pukihikita kimihe, Yecho ajhakujhenda pamonga peniya na bhabholwa bhake kome na bhabhele. ");
INSERT INTO dne_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pubhakibha bhatamite pamonga mukulyegha, Yecho ajhakwalobholela, “Ninobholela chakaka, abhii jhumo jhutulye nako, nandenda kunyambila.” ");
INSERT INTO dne_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Peniya bhabholwa bhake bhajhakubhehe ngolongondi, jhumo jhumo bhajhakutumbuu kunkonya, “Bho, ndi nenga?” ");
INSERT INTO dne_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yecho ajhakwalobholela, “Ndi jhumo kuhumii pamangota mwe kome na bhabhele, jwachwika libumunda pamonga na nenga mu bakule. ");
INSERT INTO dne_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chakaka, Mwana gwa Mundo nahwa ngita Majhandiko gha Chapanga chighalonge. Chapata malagho mundo jhola nanyambila Mwana gwa Mundo! Mbaha kwa mundo jwenio ngabhelwikejhe!” ");
INSERT INTO dne_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pubhatehila kulyegha, Yecho ajhakutola libumunda ajhakunchenguu kunomba Chapanga, ajhakumetula na kwabhaghanichila bhabholwa bhake alongila, “Ntolangane, jhenje lilandanikilo lya yegha jhango.” ");
INSERT INTO dne_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Peniya ajhakutola kibaba cha divaye, ajhakunnomba Chapanga ajhakwapekiya bhoha bhajhakunywegha divaye mukibaba chenjeno chenio. ");
INSERT INTO dne_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ajhakwalobholela, “Jhenje miyahe jhango jhibheka lilaghano lya Chapanga, miyahe jhijhitika kwa nhwalo gwa kulekekeya uhakaho gwa bhando twe. ");
INSERT INTO dne_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ninnobholela chakaka, nanywe jhe kabhele divaye jha chabibo ade lichiko lela pimpala kunywegha mu unahota nkolongwa gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Peniya bhajhakujhemba nhwambo gwa kunnomba Chapanga, bhajhakubhoka, na kujhenda ku Kitombe chuku Micheitune. ");
INSERT INTO dne_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yecho ajhakwalobholela bhabholwa bhake, “Mangota mwe natila na kunneka nenga, kuhumii mu Majhandiko gha Chapanga, Chapanga alonge, ‘Naninkoma nnuchajhe, na gheniya mambelele naghapechengana.’ ");
INSERT INTO dne_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nambo pumbala kuyoka, naninongolela kujhenda ku Galilaya.” ");
INSERT INTO dne_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petile ajhakunobholela, “Hata bhange bhabhehe na iholo na kunneka, nenga natubhaha pamonga, naninekajhe!” ");
INSERT INTO dne_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yecho ajhakunobholela, “Ninobholela chakaka ma Petile, uhiko ghongone ghone, lijhogholo nakubhekajhe naunganila patato umanyitejhe nenga.” ");
INSERT INTO dne_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Nambo Petile ajhakughagha kulonge, “Hata kuwegha nyeketile kuwegha pamonga na mwenga, nanineka ng'o.” Bhabholwa bhoha bhajhakulonge helahela ngita chakalongile Petile. ");
INSERT INTO dne_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bhajhakuhika kunghonda gwandina ghunkemwa Getechemane, Yecho ajhakwalobholela bhabholwa bhake, “Ntamangane pamba nenga nijhenda kunnyopa Chapanga palapa.” ");
INSERT INTO dne_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ajhakulongohana na Petile na Yakobu na Yohane. Na jwenio Yecho ajhakubhehe ngolongonde na malagho. ");
INSERT INTO dne_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yecho ajhakwalobholela, “Mwojho gwango ubhii ngolongonde ngita nipala kuwegha. Ntamengane pambano nkeluwe.” ");
INSERT INTO dne_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yecho ajhakujhenda palonge, na ajhakukigwiya pahe mangukama, ajhakunnyopa Chapanga alongila, anda ipala lilagho limambale. ");
INSERT INTO dne_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ajhakulonge, “Tate gwango, gheniya ghoha ghiwechekana kwino mwenga. Nambo umokehe kibaba cha malagho ghanga. Nambo ngita chimipala mwenga, chi chinipala nenga.” ");
INSERT INTO dne_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pabhujhita kwa bhabholwa bhake bhala bhatato ajhakwakolela bhagholwike. Bhahe, ajhakunnyimuha Petile na kunkonya, “Ma Simone, ngholwike? Uhotwijhe kukeluha nobe lichaa limo?” ");
INSERT INTO dne_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yecho ajhakwalobholela, “Nkotoka kugholoka na munyopengane Chapanga nkotoka kujhingii mumajhighanikilo. Uhuke ndi upala, nambo yegha itotokalile.” ");
INSERT INTO dne_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ajhakujhenda kunyopa Chapanga kabhele abhujhila malobhe ghaghala ghala. ");
INSERT INTO dne_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ajhakubhujha, ajhakwakolela bhamela bhagholwike. Miho ghabhe ghamela ghina lugwenio. Bhakamanyitejhe lakujhanguu. ");
INSERT INTO dne_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pabhajhimuwa mala jhutato ajhakwalobholela “Ngholwike kabhele? Ngohe ikwela kujhimuka! Lichaa lyenio libhandikile! Mwana gwa Mundo nabhankamuwa kwa bhando bhubhabhii na uhakaho. ");
INSERT INTO dne_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nnyimukane, tijhangana. Dolekeya, mundo jhola jwapala kunyambila nenga abhandikile.” ");
INSERT INTO dne_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yecho pajhendelela kulonge, mmolwa jwake jhumo liina lyake Yuda ajhakupiti pamo na lilongo lya bhando ghugheghite mapanga na indukwa. Bhibhatumitwe na akapiya matambiko bhakolo na bhabhola bha Malaghalikilo pamonga na ighogholo. ");
INSERT INTO dne_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bhahe, Yuda jhola jwakanyambi Yecho, ajhakwalangiya nginyililo bhando bhala, “Mundo jhunimpala kunkumbatila, ndi umanya jhojho. Mukamula na kumeka pahe jha akakomana ngondo bhino.” ");
INSERT INTO dne_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pabhokita peniya Yuda, ajhakunyenda chomola kwa Yecho na kunobholela, “Mmola!” Peniya ajhakunkumbatila. ");
INSERT INTO dne_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Lilongo lela lijhakunkamuu Yecho na kumeka pahe jha ulonda gwabhe. ");
INSERT INTO dne_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jhumo jwa bhabholwa bhake jwakabhandike pakibha Yecho, ajhakuholomola upanga muchako, na kuheketa lichikilo lya ntumiche jhumo jwa Mpiya litambiko nkolo. ");
INSERT INTO dne_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yecho ajhakwalobholela, “Bho, nhwalo gwa nike uhikita kungamuu kwa mapanga na indukwa ngita nenga jwandwekwile lilaghalikilo? ");
INSERT INTO dne_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Machiko ghoha nikibha pamonga na mangota molita mu Nyumba jha Chapanga, hilu mukangamwiijhe. Ngoheno Majhandiko gha Chapanga ghalenganile.” ");
INSERT INTO dne_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Peniya bhabholwa bhake bhoha bhajhakunneka na kutila. ");
INSERT INTO dne_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ajhakupeta kangombo jhumo, jwawalite nkwinda tugha jwampaliya Yecho. Na jwenio bhajhakunkamula. ");
INSERT INTO dne_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Na jwenio ajhakwalema, Ajhakuulekekeya nkwinda gwake, na kutila matako matopo. ");
INSERT INTO dne_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bhajhakumpeleka Yecho kajha kwa Mpiya litambiko nkolo, bhakibha na bhene akapiya matambiko bhakolo na ighogholo na bhabhola bha Malaghalikilo bhakakonganike pamo. ");
INSERT INTO dne_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petile ajhakunkengamila Yecho kwa chukutale ade ajhakujhingii mulwane lwa Mpiya litambiko nkolo. Ajhakutama pamonga na akakomana ngondo, bhajhotita mwotu. ");
INSERT INTO dne_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Akapiya Matambiko bhakolo bha pa bwalo bhajhakupalaha matakalilo ghuwange panane jha Yecho bhankome, na bhene bhakapatitejhe. ");
INSERT INTO dne_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bhando bhamahele bhajhakulonge malobhe ghuwange, nambo malobhe ghabhe ghakalandine ndeka. ");
INSERT INTO dne_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na bhange bhajhakujhema, kulonge helahela malobhe ghuwange, bhalongila. ");
INSERT INTO dne_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Twenga tukajhohine chalongila, ‘Nenga nihoto kuitilulana Nyumba jha Chapanga jhichengwite na bhando na machiko matato na njenga jhenge jhangachengwa na bhando.’” ");
INSERT INTO dne_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pamonga na gheniya malobhe ghabhe ghajhakukanwa. ");
INSERT INTO dne_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mpiya litambiko nkolo ajhakujhema palonge pa bwalo na kunkonya Yecho, “Bho, mwenga mihoto ndeka kujhanguu matakalilo ghubhantakalile bhando palonge jhino?” ");
INSERT INTO dne_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yecho akajhangwii ndeka kilebhe, akibha nuu. Mpiya litambiko nkolo ajhakunkonya kabhele, “Mwenga ndi mwa Kilichitu, Mwana gwa Chapanga jhunombitwe?” ");
INSERT INTO dne_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yecho ajhakujhanguu, “Nenga ndi. Kabhele namummona Mwana gwa mundo atamite lubhoko lwalelo lwa Bhambo jwabhii na likakala. Nahika kuhumii kumahunde gha kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","peniya Mpiya litambiko nkolo ajhakujwepula ligwanda lyake, ajhakulonge, “Tupala ndeka mundo jhojhoha alongele malobhe gha kuntakalila mundo jhonjo.” ");
INSERT INTO dne_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Mangota mwenga nnyohine kuligha! Mangota bho, mihola nike?” Bhoha bhajhakulonge Yecho akomwe. ");
INSERT INTO dne_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bhahe, bhando bhange bhajhakunhunii mata, na bhange bhajhakunhibha miho, bhajhakuntyala mbalamande na kunnobholela, “Nnotele, ghane jwantyalite!” Na bhando bhange akatumiche mwenio bhajhakuntyala mbalamande. ");
INSERT INTO dne_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petile pakibha kuyeto ku lwane, ntumiche jhumo mwikeghe ajhakuhika kwa Mpiya litambiko nkolo. ");
INSERT INTO dne_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pamonita Petile ajhota mwotu, ajhakuningukiya hake, ajhakunnobholela, “Mwenga ntyangita pamonga na Yecho jwa ku Nachalete.” ");
INSERT INTO dne_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nambo Petile ajhaukana, “Alongela manyitejhe chimulongela!” Peniya Petile ajhakubhoka na kujhenda kuyeto ku lubhegho. Lijhogholo lijhakubheka. ");
INSERT INTO dne_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jhola ntumiche mwikeghe pamonita kabhele Petile, ajhakutumbula kwalobholela bhando bhubhakibha bhajhemite peniya, “Mundo jhonjo bhakibha pamo.” ");
INSERT INTO dne_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petile ajhakukana katakata. Bhando bhubhakabhandikile pajhemite Petile, bhajhakunobholela, “Chakaka mwenga ndi mundo jhumo jwakibha nabho, ata mwenga ndi mundo jwa ku Galilaya.” ");
INSERT INTO dne_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petile ajhakutumbuu, alongila umbele likoto anda nilonge uwange, “Nenga niumanyite jhe mundo jhonjo jhumulongela malobhe ghake.” ");
INSERT INTO dne_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Papalapala lijhogholo lijhakubheka kabhele, peniya Petile ajhakukomboka malobhe ghalongila Yecho, “Lijhogholo nakubhekajhe mala jha ubhele, naundenda kungana mala patato.” Petile ajhakugwiya pahe na kulela. ");
INSERT INTO dne_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Putiputi lukela, Akapiya matambiko bhakolo pamonga na anakahota, bhabhola bha Malaghalikilo na kibhogha cha pa bwalo ghoha bhajhakukonganika. Yecho bhajhakuntabha nganganga na kunchindikicha kwa Pilatu. ");
INSERT INTO dne_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatu ajhakunkonya Yecho, “Bho, mwenga ndi munahota nkolongwa jwa Akayahude?” Yecho ajhakujhanguu, “Chakaka, mwenga ndi milongela.” ");
INSERT INTO dne_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Akapiya matambiko bhajhakuntakalila Yecho kwa ilebhe twe. ");
INSERT INTO dne_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatu ajhakunkonya kabhele, “Bho, kibhii ndeka cha kulonge? Nnyohine matakalilo ghubhantakalile panane jhino.” ");
INSERT INTO dne_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nambo Yecho akajhangwii jhe, peniya Pilatu ajhakuhechuka. ");
INSERT INTO dne_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kila Unyagho gwa Pachaka, bhando bhakajhobhalile Pilatu kwadindulila mpungwa jhumo jhubhakampahile jwakatabhitwe. ");
INSERT INTO dne_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Muda gwenio, akibha mundo jhumo liina lyake Balaba, na jwenie akatabhitwe mukipungo pamonga na bhando bhange bhubhatehile majhoghe ghanganandela na kukoma bhando. ");
INSERT INTO dne_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na lilongo lya bhando lijhakunyendelela Pilatu na kunnobholela ngita chayobhalile bhannekekehe mundo jhumo. ");
INSERT INTO dne_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatu ajhakwakonya, “Bho, mipala ninyogholele jhonjo munahota nkolongwa jwa Akayahude?” ");
INSERT INTO dne_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jwenio akamanye akapiya matambiko bhakolo bhantakalila Yecho nhwalo gwa wiho gwabhe. ");
INSERT INTO dne_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Akapiya matambiko bhakolo bhajhakuchocha kukokelekeya lilongo lya bhando bhalongele bhannyogholele Balaba bhaneke Yecho. ");
INSERT INTO dne_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","14 Pilatu ajhakwakonya kabhele, “Bho, mipala ndende nike na mundo jhonjo jhubhankema munahota nkolongwa jwa Akayahude?” ");
INSERT INTO dne_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bhando bhajhakuchobholela bhalongila, “Mumambe panchalaba!” ");
INSERT INTO dne_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatu ajhakwakonya, “Nike chikichochite! Alemwite kilebhe ghane?” Bhene bhajhakuchocha kuchobhela kanonoha. Bhalongila “Abhambwe panchalaba!” ");
INSERT INTO dne_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatu ajhakujhigha kukongelekeya lilongo lya bhando, lijhakwadindulila Balaba. Na Yecho bhantyale yato lwa limbendela lya ndomondo, na kummoha abhambwe panchalaba. ");
INSERT INTO dne_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Peniya akakomana ngondo bhajhakumpeleka Yecho ade nkate jha liboma, gwa nyumba jha Pilatu, jwakibha nkolo jwa kilambo cha ku Yudeya, ujhakukonganika likunde lyoha lya akakomana ngondo. ");
INSERT INTO dne_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bhajhakupuka Yecho nngholole gwa lange jha jivihi ngita munahota nkolongwa, bhajhakuhinga hingo jha mibha, na kubheka pamuto gwake. ");
INSERT INTO dne_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bhajhakutumbuu kunyambucha kwa kunnongama, “Mbukwa munahota nkolongwa jwa Akayahude!” ");
INSERT INTO dne_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bhakantyalite kwa yato ya milahe kumuto kubhujhii na kubhujhila na bhajhakunhunii mata. Bhajhakutama makilikite na kunyinamila jwenio. ");
INSERT INTO dne_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pubhajhomolila kuntende chanake, bhakanhulite ngobho hela jhibhakahwaliche, na kuhwalicha ngobho yake, bhahe, bhajhakumpeleka bhakamambe panchalaba. ");
INSERT INTO dne_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mundo jhumo kuhumii ku kilambo cha ku Kilene, liina lyake Simone, tate gwabhe Alekichanda na Lufo. Ateila kupeta kujhingii kubomane ahumita kuchenda, akakomana ngondo bhajhakughaghalila Simone agheghe nchalaba gwakibha nagho Yecho. ");
INSERT INTO dne_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Peniya bhajhakumpeleka Yecho ade pa Goligota, mana jhake chehemo jhibhonekana ngita libhonge lya muto. ");
INSERT INTO dne_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na bhene peniya bhajhakumpekeya divaye jhihangalwine na ntela ghukemwa manemane, Yecho akanywii ndeka. ");
INSERT INTO dne_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bhahe, bhajhakummamba pa chalaba, na ngobho yake bhajhakubhaghana kwa kahumbuumbu nnobhole na bhamanye ghane natola ligwanda. ");
INSERT INTO dne_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pihikita cha tato lukela kujhakutumbukana kubhambwa kwa Yecho. ");
INSERT INTO dne_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na panane jha nchalaba bhakajhandike litakalilo lende, “MUNAHOTA NKOLONGWA JWA AKAYAHUDE.” ");
INSERT INTO dne_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Papalapala bhajhakubhambwa bhando bhabhele pa michalaba, bhibhapokita ilebhe kwa likakala, jhumo lubhoko lwalelo lwa Yecho na jhonge lubhoko lwa ngejha. ");
INSERT INTO dne_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na ghanga ghakamilike Majhandiko gha Chapanga ghighalongila, “Nahangalwanwa pamonga na bhibhatenda ghanganandela.” ");
INSERT INTO dne_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bhando bhubhapetita peniya bhajhakunnigha maligho kongo bhakinicha muto jhabhe, bhalongila “Oko! Mwenga nganongila nantilulana Nyumba jha Chapanga na kuchenga kwa machiko matato! ");
INSERT INTO dne_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bhahe, mukikombole mabhene! Na uhuluke pa nchalaba.” ");
INSERT INTO dne_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na bhene Akapiya Matambiko bhakolo pamonga na bhabhola bha Malaghalikilo bhajhakunongama bhalongila, “Jwenio abhakombwila bhajhake, jwenio abhii chepa kukikombola! ");
INSERT INTO dne_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Hote jhojho Kilichitu, munahota nkolongwa jwa Akaichilahele! ngoheno ahuluke kuhumii pa nchalaba tubhehe na kihobholelo.” Na bhala bhibhakibha mukubhambwa pabhandikii Yecho na bhene bhajhakunnigha. ");
INSERT INTO dne_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Pihikila muhe jha chaa chita ade chaa ticha lubhendo lujhakubhehe tyoo kilambo choha. ");
INSERT INTO dne_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Cha ticha pilibhandikila lyobha kutipika Yecho ajhakulela kanonoha, alongila “Eloi, Eloi, lama chabakitane?” Mana jhake, “Chapanga gwango, Chapanga gwango, mbone uneka kanjika?” ");
INSERT INTO dne_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bhando bhibhakajhemite pabhandikii Yecho pibhajhohina malobhe gheniya, bhajhakulonge, “Munyokanikiye! Inkema Eliya.” ");
INSERT INTO dne_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mundo jhumo ajhakubhutuka lubhelo kutola lidodoke na kulichwiya mu divaye jhibhabhite, na kubheka mu nahe, na kutondobhekeya ajhakumeke pannomo alongila, “Bhahe, munneke, tulole jwenio Eliya nahika kunhuluha kuhumii pachalaba!” ");
INSERT INTO dne_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Peniya Yecho ajhakubohoma kanonoha, na kuwegha. ");
INSERT INTO dne_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Papala lipanjiya lya Nyumba jha Chapanga lijhakujwepuka ipande ibhele kutumbulii kunane ade pahe. ");
INSERT INTO dne_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nkolo jwa akakomana ngondo, jwakatamite palonge jha nchalaba gwa Yecho, pajhohina lilobhe lya kukuluma na kuwegha kwake, ajhakulonge, “Chakaka mundo jhonjo akibha Mwana gwa Chapanga!” ");
INSERT INTO dne_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bhakibha akakeghe bhibhakibha bhalingulila chukutale, pakate jhabhe akibha Maliya mundo jwa kuhumii ku Magidala na Chalome na Maliya majhe gwabhe Yakobu unung'una mundo Yoche. ");
INSERT INTO dne_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Akakeghe bhamba bhakalongohine na Yecho pakibha ku Galilaya kwa nhwalo gwa kuntangatila. Na akakeghe bhange twe bhakahikite pamonga na jwenio ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pukihita kimiho, likibha lichiko lya kukibheka mbone kabula jha Lichiko lya Kupomolela. ");
INSERT INTO dne_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Peniya Uchupo jwa kilambo cha ku Alimataya, mundo munahota jwa pa bwalo jwakibha bhanendema hake. Na jwenio alendila kuhika kwa Unahota nkolongwa gwa Chapanga. Bhahe, Uchupo ajhakunyendelela Pilatu changajhoghopa, na kunnyopa ampele yegha jha Yecho. ");
INSERT INTO dne_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kongo Pilatu atehila kukangacha pajhohina Yecho ajhomwike. Ajhakunkema nkomana ngondo na kunkonya ngita Yecho ajhomwike mandahe. ");
INSERT INTO dne_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pilatu papatita malobhe kuhumii kwa nkomana ngondo jhola chakaka Yecho ajhomwike, ajhakumpekeya Uchupo yegha jha Yecho. ");
INSERT INTO dne_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Peniya Uchupo ajhakuhemela chanda na kubhilingilila malelo gha Yecho, na kujhenda kuhuluha yegha kuhumii panane jha nchalaba na kuibheka pahe, ajhakubhingilila ngobho jha malelo. Ajhakughoneka umambe lilikibha lihokonywilwe pa lindalabho, ajhakubhilimbiya kiyekelelo cha lighanga pa nnyango gwa mambe na kuhibha. ");
INSERT INTO dne_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na Maliya jwa ku kilambo chuku Magidala na Maliya majhe mundo Yoche bhakapawene peniya pibhaghonike yegha jha Yecho. ");
INSERT INTO dne_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lichiko lya Kupomolela pilijhomokila, Maliya mundo jwa ku kilambo chaku Magidala na Maliya majhe mundo Yakobu na Chalome bhajhakuhemela mahuta ghughanungila petelele na kujhenda kupaka yegha ya Yecho. ");
INSERT INTO dne_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lukala, jumapile, pulipitita lyobha, bhajhakujhenda ku mambe. ");
INSERT INTO dne_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Undela bhatehila kukonyana bhene kwa bhene, “Ndi ghane jwabhilimbiye lighanga kubhoka pa nnyango jha mambe?” ");
INSERT INTO dne_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pibhalolikiya, bhajhakulibhona lighanga lela likolongwa libhilimbiwe kubhoka panyango gwa mambe. ");
INSERT INTO dne_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pibhajhingila nkate mu mambe, bhajhakumona kangombo jhumo jwawalite ngobho nhuo ya mbuu, atamite lubhoko lwalelo, na bhene bhajhakuhechuka hake. ");
INSERT INTO dne_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kangombo jhola ajhakwalobholela, “Nkotoka kuhechuka. Mipalaha Yecho jwa ku Nachalete jwakabhambitwe panane. Ayokite! Abhii jhe pambano. Nnolekehe pakagholwike. ");
INSERT INTO dne_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nnyende makalobholele bhabholwa bhake pamonga na Petile, alongolile kujhenda ku Galilaya, kwenio ndi nabhamona, ngita chabhalobholila.” ");
INSERT INTO dne_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Peniya, bhajhakupita umambe jha Yecho na kubhutuka mbelo, kongo bwaghaliya na kikangacho chakamwile. Na bhene bhakalongii ndeka kwa mundo jhojhoha lilobhe lela nhwalo bhajhogwipa hake. ");
INSERT INTO dne_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yecho pahyokita putiputi lichiko lya jumapile, mundo jwatumbwila kumpitila akibha Maliya jwa kilambo cha Magidala, jhola jwakampihite michuka chaba. ");
INSERT INTO dne_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maliya jwa ku kilambo chaku Magidala ajhakujhenda, kwalobholela bhabholwa bhake bhubhakibha bhubhalongohina pamonga na Yecho, na bhene bhakibha bhalelita malelo. ");
INSERT INTO dne_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pubhajhohina Yecho abhi nghome na Maliya jwa Magidala akongine nako, bhene bhakajheketile ndeka. ");
INSERT INTO dne_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Yecho ajhakwapetela pakate ja bhabholwa bhake bhabhele bhubhakibha bhajhahwila kuchenda. Na bhene bhakamanyitejhe. ");
INSERT INTO dne_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na bhene bhajhakubhujha, kwalobholela bhabholwa bhajhabhe. Na bhene helahela bhakajheketii ndeka. ");
INSERT INTO dne_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pajhomolila, Yecho ajhakwapitii bhabholwa bhake kome na jhumo bhibhakibha bhatehila kulyegha. Ajhakwapwatalila nhwalo ghane gwangajheketela kwabhe na kujhundupa kwabhe, bhajhabhe bhibhakonginika nako kuhumii mu kuyoka. ");
INSERT INTO dne_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ajhakwalobholela, “Nnyendengane mu ilambo yoha, mukalitangache Lilobhe lya Chapanga kwa bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mundo jhojhoha jwapala kujheketela na kubatichwa, Chapanga nakombola. Na mundo jhojhoha jwangajheketela kubatichwa natenda kulagha. ");
INSERT INTO dne_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Na ikangacho henge nahilongohana na bhoha bhibhanyeketile. Kwa liina lyango nabhabhoha michuka, nabhalongela kwa lugha nhyono. ");
INSERT INTO dne_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Na bhakamula lijhoka kwa mabhoko na kunywegha kilebhe chochoha chikibhii na uchongo, na chabhahwe ndeka. Nabhabheka mabhoko panane jha muto kwa bhibhalwalwa, na Chapanga nabhalamicha.” ");
INSERT INTO dne_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Peniya Bhambo Yecho pajhomolila kulonge nabho, ajhakutolwa kujhenda kunane kwa Chapanga. Na kutama pamonga na Chapanga mihotolo gwake. ");
INSERT INTO dne_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Peniya bhabholwa bhajhakujhenda kila kimbokotole kutangacha Lilobhe lya Mbone. Bhambo ajhakuhenga lihengo pamonga na bhene, ajhakuhenga ikangacho twe, ili kulangiya lilobhe lyake la jwenio ndi lya chakaka.");
INSERT INTO dne_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Munahota Teofilu. Bhando bhamahele bhajhighite ngita chibhahotwila kujhandika mbone malobhe ghighatendika pakate jhito twenga, ");
INSERT INTO dne_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","na bhajhandike malobhe ghibhachimulilwa na bhala bhubhalolita kwa miho ghabhe bhene kuhumii makacho pighatumbukina, na kwa bhala bhibhatangicha malobhe gheniya. ");
INSERT INTO dne_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kwa gheniya Makolongwa, na nenga pinyomolila kuhingukiya kwa uchakaka gwake, mwene mbaha ninyandikile na mwenga ngita chighapitila mambu gheniya. ");
INSERT INTO dne_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ndehila naha, kupala hele umanye kwa uchakaka mwe mabhene mambu ghoha ghubhammolita. ");
INSERT INTO dne_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Machiko gha Helode pakibha munahota nkolongwa jwa ku Yudeya, peniya pakibha na mundo jhumo jwakemitwa Zakaliya jwa kibhogha cha akapiya matambiko cha Abiya. Nhwana mundo Zakaliya liina lyake Elizabete helahela na jwenio ahumila kulukolo lwa mpiya litambiko lwa Halune. ");
INSERT INTO dne_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kwa bhoha bhabhele bhabhonekina bhambone na kuhalalicha palonge jha Chapanga kwa kukamuu mbone Malaghalikilo na malobhe ghoha ghakanikiya Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nambo bhakibha jhe na mwana, nhwalo Elizabete akibha ntonga, na bhoha bhabhele bhakibha bhaghoime. ");
INSERT INTO dne_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lichiko limo, Zakaliya pakibha mu chamo jhake jha kuhenga lihengo lyake lya kupiya litambiko mu Nyumba jha Chapanga, ");
INSERT INTO dne_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ngita chibhakayobhalile mpiya litambiko, Zakaliya ajhakuhaghulilwa kwa ndela jha kula kujhingii nkate mu Nyumba jha Bhambo kwa lihengo lya kuhukulukiya ubane. ");
INSERT INTO dne_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Machiko ghenagha Zakaliya lichaa lya kututukiya ubane pilihikita, bhando bhamahele bhakonganika panja kongo bhanyopita Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bhahe, ntumiche jwa kunane kwa Bhambo Chapanga ajhakupwitikilila pwitu Zakalilya mwenio nkate na kujhema lubhoko lwalelo lwa luchangwale lwa kututukiya ubane. ");
INSERT INTO dne_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakaliya panolekiya, ajhakujhoghopa na kilendemo kijhakubhehe twe. ");
INSERT INTO dne_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nambo ntumiche jwa kunane kwa Chapanga jhola nganongolila “Ma Zakaliya! Nkotoka kulendema, Chapanga ajhohine kujhopa kwino. Hote nhwana gwino Elizabete napapila mwana munalome, na mabhene namutina liina lyake Yohane. ");
INSERT INTO dne_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mabhene ndi nanuluta hake na bhando bhamahele nabhahekelela, kwa nhwalo gwa kubhelukwa kwa mwana jwenio. ");
INSERT INTO dne_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Hote nabhaha ntumiche nkolongwa palonge jha Bhambo, jwenio nanywe jhe divaye hilu ughembe. Nalongochwa na Uhuke gwa Chapanga kuhumii mulutumbo lwa majhe mundo. ");
INSERT INTO dne_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Helahela nalongocha bhando bhamahele bhu ku Ichilahele, kumujhiii Bhambo Chapanga gwabhe, ");
INSERT INTO dne_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","nanongolela Bhambo, kongo abhii na likakala na uhuke ngita gwa Eliya jwakibha nnondole jwa Chapanga. Naighalambula miojho jha katate jhaholelele yana yabhe na kwatenda bhibhankana Chapanga bhabhehe na mawacho ghambone gha kunyekete Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaliya pakonyita ntumiche jwa kunane kwa Chapanga, “Kilebhe cheneche nakimanyikana bhole kongo ne na nhwana gwango tughogholwike?” ");
INSERT INTO dne_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ntumiche jwa kunane kwa Chapanga panyangwila, “Liina lyango na Gabuliele, jhunijhema palonge jha Chapanga andumite kwino mwenga, nipwepwele lilobhe lya mbone leno. ");
INSERT INTO dne_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nambo ngoheno nahuighalika nuu changalonge, ade lichiko lya pighapala kupitii mambu gheniya, nhwalo gwangajheketela malobhe ghango ghighapala kuhengeka kwa machiko ghake.” ");
INSERT INTO dne_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Machiko ghenagha bhando bhibhanendelila panja Zakaliya, bhatehila kukangacha kwa kutamikiya naha mu Nyumba jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bhahe, Papitita panja, Zakaliya ahotwila ndeka kulonge nabho. Ajhake bhala bhakamanye kibhii chakiwene mwenio kuhumii kwa Chapanga. Nhwalo gwangalongela, ndi alongila kwa kulaha mabhoko. ");
INSERT INTO dne_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Machiko ghake ghakuhenga mahengo mu Nyumba jha Chapanga, pighajhomokila abhujhita kajhake. ");
INSERT INTO dne_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Bhahe, machiko ghandina pighapetita, nhwana mundo Elizabete jhola ajhakubhehe na ndumbo. Ajhakughongela kwa miyehe nhwano, kongo apipikiya totolo kajhake. ");
INSERT INTO dne_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kongo Elizabete alongila, “Bhambo anolokiye na andangatile, na ngohe amohite hone jhango pamiho jha bhando!” ");
INSERT INTO dne_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pamwehe gwa chita gwa ndumbo jhake Elizabete, Chapanga ajhakuntuma ntumiche gwake jwa kunane jwankemitwa Gabuliele ajhende kubomane jha ku Nachalete jhibhii ku kilambo chuku Galilaya. ");
INSERT INTO dne_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kwa nchikana jhumo jwangakongana na munalome jwakemitwa Maliya, jwenio apalwa kutolelwa na mundo jhumo liina lyake Uchupo, jwahumii mulukolo lwa Daude. ");
INSERT INTO dne_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bhahe, ntumiche jwa kunane kwa Bhambo Chapanga jhola ajhakuhika kwa Maliya na kunyambucha, “Mwenga jhunangiwe umbone na Chapanga na antwelii mota hake!” ");
INSERT INTO dne_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Papalapala Maliya pajhohina malobhe gheniya, ajhakuhechuka hake na ahololila chakumwojho, nhwalo gwa nike anyambwiche naha? ");
INSERT INTO dne_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ntumiche jwa kunane kwa Chapanga, ajhakunyanguu, “Maliya nkotoka kujhoghopa, Chapanga anangiye umbone gwake. ");
INSERT INTO dne_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mwenga nanng'egha ndumbo, na kupapa mwana munalome na mabhene namutina liina lyake Yecho. ");
INSERT INTO dne_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jwenio nabhaha nkolongwa, hote nakemwa Mwana jwa Chapanga, na Bhambo Chapanga chantenda kubhehe munahota nkolongwa, ngita chabhii munahota nkolongwa hoko mundo Daude. ");
INSERT INTO dne_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Hote jwenio nabhaha ndi munahota nkolongwa jwa kibheleko cha Yakobu kwa machiko ghoha, na unahota nkolongwa gwake ghangapeta!” ");
INSERT INTO dne_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Bhahe, Maliya ajhakunobholela ntumiche jwa Chapanga jhola, “Ghenagha naghatendeka bhole, na nenga ninakongana jhe na munalome?” ");
INSERT INTO dne_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ntumiche jwa kunane kwa Chapanga ajhakunyanguu, “Uhuke gwa Chapanga nahulukiya panane jhino, na uhotolo gwa Chapanga Nkolongwa naghuyekelela. Nhwalo Mwana jwenio jwapalwa kubhelukwa, nakemwa mwana jwa Jwanyahinyahi, Mwana jwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dola nnongo gwino Elizabete abhii na ndumbo mughogholo gwake, na ngohe ndumbo jhake itamii mu mwehe gwa chita, jwenio jwamanyikina na bhando ntonga. ");
INSERT INTO dne_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nhwalo kibhii ndeka chikilimba kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maliya ngalongila, “Nanjino natumiche jwa Bhambo, nijhopa undendele ngita chimulonge.” Peniya ntumiche jhola ajhakukibhokela. ");
INSERT INTO dne_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ghakapetite ndeka machiko ghamahele, Maliya ajhakutenda mwanja gwa kubhutuka gwa kujhenda ku kilambo cha kubomane jhibhii kwiitombe yaku Yudeya. ");
INSERT INTO dne_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pahikita kwenio, ajhakuhikila munyumba jha Zakaliya na kunyambucha Elizabete. ");
INSERT INTO dne_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabete pajhohina tu Maliya inyambucha, kamwana kamulutumbo lwa Elizabete kajhakuomba, na kongo Elizabete atwelii Uhuke gwa Chapanga twe, ");
INSERT INTO dne_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","alongila kunonoho, “Nkwete mota Elizabete kupeta akakeghe bhoha, na jwenio jhumumpala kumpapa hele jhuna mota! ");
INSERT INTO dne_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nenga njochite kilebhe ghane, hilu majhe gwa Bhambo gwango kuhika kulebhata palubhanja lwango pano? ");
INSERT INTO dne_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nanjino ninnobholele, pinyohina lilobhe lino punyambwicha pala, king'enya cha mulutumbo lwango kijhakuomba kwa kuhangana. ");
INSERT INTO dne_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Chapanga ampekiye mota mwenga nhwalo nnyeketii malobhe ghala ghimilongolelwa na Bhambo kubhehe naghatendeka!” ");
INSERT INTO dne_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maliya ngajhembita, “Mwojho gwango unnomba Bhambo, ");
INSERT INTO dne_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","na uhuke gwango gwihanganii Bhambo, nhwalo ndi nkomboche gwango. ");
INSERT INTO dne_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nhwalo anolokiye nenga natumiche jwake jwangaloka! Kuhumii ngohe ibheleko yoha naingema jhumbekiwe mota na Chapanga, ");
INSERT INTO dne_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nhwalo nabhajhoha ilebhe henge yandendile nenga Chapanga ikolongwa, na jwenio liina lyake ndi Nyahinyahi. ");
INSERT INTO dne_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ulangii kiya jhake kwa bhando bhibhabhii na kiholo na jwenie, kuhumii kibheleko ade kibheleko, ");
INSERT INTO dne_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","na ulangii makakala ghake kwa kuhenga makolongwa, na ubhapechangana bhibhaloka mimwojho jhabhe. ");
INSERT INTO dne_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abhahululwiye akanahota akakolongwa bhina makakala kuhumii mu igoda yabhe ya ulongoche, na kwabhatondobheya bhangaloka. ");
INSERT INTO dne_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abhalicha bhina njala, kwa ilebhe yambone, na bhibhabhii na ilebhe yamahele abhabhengite mabhoko matopo. ");
INSERT INTO dne_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Atangatii ntumiche gwake Ichilahele, kwa kuikomboka kiya jhake, ");
INSERT INTO dne_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ngita chabhalongolila akahoko bhito Ulahimo na kibheleko chake, kwa machiko ghoha ghangapeta!” ");
INSERT INTO dne_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliya akatamite kwenio ukajha kwa Elizabete ibhandikii miyehe mitato, peniya ndi pabhujhita ukajhake. ");
INSERT INTO dne_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pighabhandikila machiko gha kupapa gha Elizabete, ajhakupapa mwana munalome. ");
INSERT INTO dne_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Bhando bhibhabhii pahina jhake na akalongo mundo bhoha pibhajhohina Bhambo antendii ilebhe ikolonga Elizabete, bhoha bhajhakuhanganila pamonga na jwenio. ");
INSERT INTO dne_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lichiko lya nane bhakahikite kunyingii jando mwana, na bhapata kuntina liina lya Zakaliya, liina lya tate mundo. ");
INSERT INTO dne_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nambo majhe mundo ajhakulonge, “Mbahi ndeka! Jweniojho mukema Yohane.” ");
INSERT INTO dne_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bhene bhajhakunongolela, “Mulukolo lwake, abhii jhe mundo jwakemwa liina ngita lyenio!” ");
INSERT INTO dne_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Bhahe, bhajhakukonya tate mundo kwa kulaha mabhoko, bhamanye apala kuntina liina ghane. ");
INSERT INTO dne_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaliya ajhakujhopa lijhola lya kujhandikila, ajhakujhandika, “Jhonjone liina lyake Yohane.” Bhando bhoha bhajhakuhechuka! ");
INSERT INTO dne_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Papalapala Zakaliya ajhakutumbuu kulonge kabhele, ajhakutumbuu kunomba Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Peniya kila mundo jwakibhanako ajhakubhehe na bhoghohe, malobhe gheniya ghoha ghajhakuchobhela mu kilambo choha cha mwitombe yaku Yudeya. ");
INSERT INTO dne_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bhahe, bhando bhoha pibhajhohina ilebhe ipitile kwenioko, bhajhakuholelela chakumwojho na kukikonya, “Bho, mwana hojho apala kubhehe bhole?” Nhwalo gwa makakala gha Bhambo ghakibha pamonga na jwenio. ");
INSERT INTO dne_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakaliya tate gwake Yohane, ajhakutwelela Uhuke gwa Chapanga, na jwenio ajhakutumbuu kulonge kwa ulondole. ");
INSERT INTO dne_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Alumbililwe Bhambo, Chapanga jwa ku Ichilahele! Kwa nhwalo ahikite kwatangatila bhando bhake na kwakombola. ");
INSERT INTO dne_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Atuleti Nkomboche jhuna makakala, kuhumii muchokolo gwa Daude ntumiche mundo, ");
INSERT INTO dne_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","na ngita chalongila makacho, kupete kwa akalondole bhake bha nyahinyahi. ");
INSERT INTO dne_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Natukombola kuhumii mu mabhoko gha akamakoko bhito, na kutubhoha mu mabhoko gha bhando bhoha bhibhituchimwa. ");
INSERT INTO dne_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Akalongii nabhabhonela kiya akahoko bhito, na abhii kulikomboka lilaghano lya nyahinyahi. ");
INSERT INTO dne_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Akanapanikiye tate gwito Ulahimo, kubhehe natutangatila twenga, ");
INSERT INTO dne_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tughombokoke kuhumii mu mabhoko gha akamakoko bhito, na tunhengele lihengo Chapanga changapwelela. ");
INSERT INTO dne_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kongo tubhii bhaumbone palonge jhake na kuhenga ghighanhalalila Chapanga, kwa machiko ghoha gha ughome gwito. ");
INSERT INTO dne_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mwanango jhonjo, nakemwa nnondole jwa Chapanga Nkolongwa, kongo namunongolela Bhambo, kunenganikiya lukwalo lwake, kunenganikiya ndela jhake, ");
INSERT INTO dne_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","na kwatangachii bhando bhoha nabhaghombokoka, kwa kulekekewa uhakaho gwabhe. ");
INSERT INTO dne_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chapanga gwito jwaumbone na jhuna kiya ngolongwa, natumulikila lilangamule lyake lya ughombokeko kuhumii kunane, ");
INSERT INTO dne_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","na kwamulikila bhoha ndaa bhibhabhii mulubhendo lwa kuwe kwabhe, na kutulongoya matyangilo ghito muughome gwa uteeke.” ");
INSERT INTO dne_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Peniya mwana jhola ajhakuchocha kuyoloka, na kukangamala makakala gha uhuke. Akibha atamita kunjenga ade lichiko lela pakilangiya pamiho jha bhando bhu ku Ichilahele. ");
INSERT INTO dne_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Machiko ghala, munahota nkolongwa jwa ku Loma jwakemitwa Aguchitino, akalaghalikiye naha, bhando bhoha bhibhatamita muukolongwa gwa mu ilambo ya ku Loma bhakajhandikichwe. ");
INSERT INTO dne_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kujhandikichwa kwenio kukibha kwa kutumbula. Machiko gheniya Kolineliyo akibha kilongoche jwa kilambo chuku Siliya. ");
INSERT INTO dne_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kila mundo, akajhenda ku kilambo chake kukijhandikicha. ");
INSERT INTO dne_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Helahela Uchupo ajhakubhoka kubomane jha ku Nachalete jhibhii ku kilambo chuku Galilaya, akajhenda kubomane jha ku Betelehemo jhibhii ku kilambo chuku Yudeya, kwabhelekilwe munahota nkolongwa Daude. Nhwalo jweniojho akibha mu kibheluko cha Daude. ");
INSERT INTO dne_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akalongihine pamonga na jwapala kuntolela Maliya kukujhandikichwa kwenio. Kongo Maliya abhii na ndumbo. ");
INSERT INTO dne_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pibhakibha kwenio ku Betelehemo, lichiko lya kupapa lya Maliya lijhakuhika, ");
INSERT INTO dne_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","na ajhakupapa mwana mundo jwakutumbulila munalome, ajhakumilingilila winda ya mwana, peniya bhakanghonike mu kibhajha cha ng'ombe, nhwalo bhakapatite jhe pwache munyumba jha akaghene. ");
INSERT INTO dne_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pakilambo chela pakibha na bhando bhibhaluchita mambelele kumighonda, bhakelwiya miho kulonda mambelele ghabhe. ");
INSERT INTO dne_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ntumiche jwa kunane kwa Chapanga ajhakwapwitikilila pwitu na lumule lwa ungalicho lukolongwa kuhumii kwa Bhambo lulangila poha ndaa. Bhoha bhajhakujhoghopa hake, ");
INSERT INTO dne_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","nambo ntumiche jwa kunane kwa Chapanga jhola ajhakwalobholela, “Nkotoka kujhoghopa! Ninetii Malobhe gha Mbone gha kuhalalila kwa bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Dola, deleno kumuche gwa munahota Daude abhelwike Nkomboche gwito, ndi Kilichitu Bhambo. ");
INSERT INTO dne_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bhahe, naibhaha nginyililo jhino, namkolela mwana bhamilingile winda na bhaghonike mu kipoto cha kulele ng'ombe.” ");
INSERT INTO dne_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Papa peniya, lilongo lya akatumiche bha kunane kwa Chapanga bhajhakuhika na kukonganika na ntumiche jhola jwa kunane jwalongalile, na bheniya bhannombita Chapanga, bhalongila, ");
INSERT INTO dne_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ung'alicho kwa Chapanga jwa kunane, na uteeke ubhaha pannema pano kwa bhando bhabhapahii hake!” ");
INSERT INTO dne_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pabhokita ntumiche jwa kunane kukelebhuka kunane kwa Chapanga, na bhibhaluchita bhala na bhene bhajhakuchimulilana bhene chika, “Tujhende hote ku Betelehemo tukalinge ghanga ghighapitii ghatulongolilwe na Bhambo.” ");
INSERT INTO dne_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bhahe, bhajhakutyanga kajhombe, bhajhakunkolela Maliya na unganamundo Uchupo na mwana jhola jwabhelwike bhabhii mu lipoto lya kulele ng'ombe. ");
INSERT INTO dne_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bhibhaluchita bhala pibhajhomolela kunninga mwana jhola, bhajhakwalobholela bhando bhoha malobhe ghibhajhohina kuhumii kwa akatumiche bha kunane kwa Chapanga ghibhalongila gha mwana jwenio. ");
INSERT INTO dne_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bhahe, bhoha bhibhajhokanikiya ghighalongilwa na bhibhalucha bhala, bhajhakuhechuka, ");
INSERT INTO dne_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","nambo Maliya ajhakughabheka kumwojho gwake malobhe na kuhiololela ilebhe yeneye. ");
INSERT INTO dne_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bhahe, bhibhaluchita bhala bhajhakukelebhuka, kongo bhapetita kunnomba Chapanga kwa ghoha ghibhajhohine na kulola kwa miho ghabhe, ngita chibhalongila akatumiche bha kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pighahikita machiko nane, machiko gha mwana kujhingii jando, bhajhakuntina liina Yecho. Liina lyenele likapihitwe na akatumiche bha kunane kwa Chapanga, majhe mundo na ndumbo jhe. ");
INSERT INTO dne_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pilihikita lichiko lya Uchupo na Maliya kujhelebhulwa bhajheketelwe palonge jha Chapanga ngita libholo lya Lilaghalikilo lya Chapanga lyapatite Mucha chilipata, peniya ndi pibhapelika mwana jhola ku Yeluchalemo kumeka palonge jha Bhambo. ");
INSERT INTO dne_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ngita lilaghalikilo lya Bhambo chilijhandikwe, “Kila mwana munalome jwatumbuu kubhelukwa, nabhekwa palonge jha Bhambo.” ");
INSERT INTO dne_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Helahela bhakajhahwii bhapihe litambiko kwa Chapanga, na bhapalitwa bhapihe ngunda ibhele amu mapupo mabhele gha njebha, ngita chiijhandikwe mulibholo lya Malaghalikilo gha Bhambo. ");
INSERT INTO dne_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Machiko ghenagha, ku Yeluchalemo kola akibha mundo jhumo, liina lyake Simeone, jwenio atehila ghapata Chapanga. Alendelila kwa lichiko lela Chapanga kuhika kuhengechwa kwa miyojho jha bhando bhu ku Ichilahele. Na Uhuke gwa Chapanga ubhii twe pamonga na jwenio. ");
INSERT INTO dne_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Uhuke gwa Chapanga ujhakuyekulila Chimeone kubhehe ihwe ndeka ade amone Kilichitu Nkomboche jwenio jwa Bhambo. ");
INSERT INTO dne_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bhahe, pala akatate bha Yecho pibhampeleka mwana gwabhe mu Nyumba jha Chapanga bhantendele ngita lilaghalikilo lya Mucha lyapatite na Chapanga. Peniya ndi Simeone palongwichwa na Uhuke gwa Chapanga kujhingii mu Nyumba jha Chapanga, ");
INSERT INTO dne_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","peniya Simeone ajhakupakata mu mabhoko mwana jhola, kone annombita Chapanga alongila, ");
INSERT INTO dne_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ngohe Bhambo ntehile ngita chiunongolila, unekite, nenga natumiche gwino nyenda kwa uteeke. ");
INSERT INTO dne_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kwa miho ghango namwete niuwene ughombokeko gwino, ");
INSERT INTO dne_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mutehile abhonekane kwa bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Lilangamule nalyalangalila bhando bha ilambo henge, na ukolo kwa bhando bhino bhu ku Ichilahele.” ");
INSERT INTO dne_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Akatate bha Yecho bhajhakuhechuka na malobhe gha Simeone ghalongila kupete mwana. ");
INSERT INTO dne_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeone ajhakwajhopela mota kwa Chapanga, na kunongolela Maliya, majhe mundo Yecho, “Mwana jhonjo ahuagwile Chapanga kwa kugwegha na kujhinuka kwa bhando twe bhu ku Ichilahele. Nabhaha nginyililo kuhumii kwa Chapanga, naikanalilwa na bhando twe, ");
INSERT INTO dne_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","helahela naghayekula mahako gha bhando bhamahele naghabhonekana pakongoloho. Na mabhene lipyanda lilihokonyola ngita kihembe, chikihokonyola ku mwojho gwino.” ");
INSERT INTO dne_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Helahela pakibha na mwikeghe kighogholo hake, na liina lyake Ana, akibha nnondole jwa Chapanga. Mwikeghe jwenio liina lyake Ana mwana gwa Fanuele jwahumii mulikabila lya Ashele. Akatamite muhano yaka chaba kuhumii mukutolwe kwake. ");
INSERT INTO dne_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bhahe, ajhakutama unholo ade mughogholo gwake gwa yaka makome nane na ncheche. Machiko ghoha apipikiya kutama mu Nyumba jha Chapanga, ahwelita kunyinamila Chapanga na kuleka kulyegha kilo na muhe jhoha. ");
INSERT INTO dne_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Machiko ghagha Ana ajhakwajhendelela Maliya na Uchupo, na kunchenguu Chapanga, kwalongolela bhando bhoha bhibhalendelila kulekwa mahulo ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Uchupo na Maliya pibhajhomolila kuhenga mahengo ghoha ghighalaghalikiwe mu mabholo gha Malaghalikilo gha Bhambo, bhajhakukelebhuka kajhabhe ku Nachalete jhibhii ku kilambo chuku Galilaya. ");
INSERT INTO dne_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mwana jhola pachochita kukola na kujhonjekeka makakala, kongo atwelii malango na umbone gwa Chapanga ubhii pamonga na jwenio. ");
INSERT INTO dne_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kila chaka, tate na majhe mundo Yecho bhakayobhalile kujhenda ku Yeluchalemo kuunyagho gwa Pachaka. ");
INSERT INTO dne_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Peniya Yecho pahikicha yaka kome na mibhele, bhajhakulongohana na jwenio kujhenda kwenio ku Yeluchalemo, kuunyagho gwa Pachaka ngita chibhakayobhalile. ");
INSERT INTO dne_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Unyagho pujhomolila, bhajhakubhujha kajhabhe, nambo mwana Yecho bhajhakujhehwa koko ku Yeluchalemo bhene changamanya. ");
INSERT INTO dne_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bhene bhahambwika jwenio bhalongohine na lilongo lya bhando bhibhatyangita mwanja gwa muhe jhoha. Ndi pibhatumbwikina kulyunga kwa kumpalaha, kwa akalongo mundo pamonga kwa akakoche mundo bhoha bhyehe. ");
INSERT INTO dne_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nhwalo bhakamwehi jhe, bhajhakukelebhuka ku Yeluchalemo kumpalaha. ");
INSERT INTO dne_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lichiko lyutato lya kumpalaha, bhajhakukolela nkate mu Nyumba jha Chapanga, abhii pakate jha bhabhola bha Malaghalikilo, atenda kwajhokanikiya na kwakonya machwale. ");
INSERT INTO dne_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bhoha bhajhakuhechuka na uhotolo gwake nkolongwa gwa kumanya na majhangulilo ghambone. ");
INSERT INTO dne_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Akatate mundo pibhammonita bhajhakuhechuka. Majhe mundo Maliya ajhakukonya, “Nhwalo gwa nike tajhino mutung'aha naha? Tate gwino na nenga tukibha miho pyuu kumpalaha mwenga.” ");
INSERT INTO dne_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Papalapala Yecho ajhakunyanguu, “Bho, kilebhe ghane chiumbalakiya? Bho, umanyite jhe nenga imbala mbipikiya mu Nyumba jha Tate gwango?” ");
INSERT INTO dne_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Nambo akatate mundo bhakamanyite jhe mana jha malobhe ghala ghabhalongalila. ");
INSERT INTO dne_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Peniya Yecho ajhakulongohana nabho pamonga kubhujha ku Nachalete, kongo abhii kwajhokanikiya. Na majhe mundo ajhendelila kuiholela ilebhe yenio umwojho. ");
INSERT INTO dne_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yecho pachochita kukola na kubhehe na malango, helahela kupalwa na Chapanga pamonga na bhando. ");
INSERT INTO dne_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kikibha chaka cha kome na nhwano cha unahota gwake munahota nkolongwa jwa ku Loma jwakemitwa Tibeliyo, machiko ghagha Pontiyo Pilatu akibha kilongoche jwa ku itombe ya ku Yudeya. Helode akibha alongwicha ku kilambo chuku Galilaya, na nnongo mundo Filipu akibha kilongoche jwa ku Ituleya ku kilambo chuku Tilakonite. Lusaniya akibha kilongoche jwa ku Abilene. ");
INSERT INTO dne_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anase na Kayafa akapiya matambiko bhakolo bha Chapanga, lichiko lyenio pilihikila lilobhe lya Chapanga Yohane, mwana gwa Zakaliya ku njenga. ");
INSERT INTO dne_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bhahe, Yohane ajhakujhenda ku kilambo choha chikibhii mupele jha lukemba lwa ku Yolodane. Kongo akibha abhatangachila bhando, “Muuleke uhakaho na kubatichwa. Chapanga nanekekeya uhakaho gwino.” ");
INSERT INTO dne_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngita chibhajhandike mukitabo cha Isaya jwakibha nnondole jwa Chapanga, “Mundo jwalalama kunjenga, ‘Mnenganikiye Bhambo ndela jhake, nnyoche mwaipala kupeta. ");
INSERT INTO dne_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kila likemba lipalwa kuyelelwa, kitombe kikolongwa na lihugholo nalibhaha heghuheghu, na ndela jhipembetile naighololwa, na ndela jhimong'onywike nailinganikilwa mbone. ");
INSERT INTO dne_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na, bhando bhoha nabhaubhona ughombokeko kuhumii kwa Chapanga!’ ” ");
INSERT INTO dne_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bhahe, Yohane ajhakwalobholela bhando bhamahele bhibhahikita kubatichwa, “Mangota kibheluko cha lijhoka! Bho, ghane jwapwepwile mihoto kulitila lilaka lya Chapanga lilihika? ");
INSERT INTO dne_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nnangie kwa kuhenga kwino anda muulekite uhakaho. Nkotoka kukilongolela kumwojho tu, ‘Hoko gwito ndi Ulahimo!’ Ninobholela chakaka, jwenio Chapanga ahotola kughalambula maghanga aghagha na kubhehe yana ya Ulahimo. ");
INSERT INTO dne_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ngohe libhagho libhii pa libelengete lya nkongo, na nkongo ghoghoha gwangapambika uhohe naupengulwa na kutagwa ku mwotu.” ");
INSERT INTO dne_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bhando bhajhakunkonya, “Bho, ngohe tuhenge nike?” ");
INSERT INTO dne_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohane ajhakujhanguu, “Mundo jwakwete ngobho ibhele jhimo amaghulila nnyake, jwangabhenako, na jwakwete yakulyegha helahela amaghulila jwangabhenacho.” ");
INSERT INTO dne_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Akatola kode na bhene bhajhakunyendelela Yohane kupala kubatichwa, ndi pibhankonyita, “Mmola, na twenga tuhenge nike?” ");
INSERT INTO dne_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ajhakwalobholela, “Nkotoka kutola kode kupetelecha chibhanaghalikiye.” ");
INSERT INTO dne_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Akakomana ngondo na bhene bhankonyita, “Bho, na twenga helahela tuhenge nike?” Ajhakwalongelela, “Nkotoka kupoka mbijha kwa mundo jhojhoha na kwatakalila bhando changalemwa na ntocheka na chimipata.” ");
INSERT INTO dne_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Peniya bhando bhoha bhalolila kuhika kwa Nkombola, bhajhakutumbuu kukikonya kumwojho gwabhe, pange Yohane ndi Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohane, ajhakwalobholela bhando bhoha, “Nenga nibaticha kwa mache, nambo jwahika jhuna likakala kumbeta nenga, hilu nitope ndeka kubhopo ng'ojhe ya maghubache ghake. Jwenio nabaticha kwa Uhuke gwa Chapanga na kwa mwotu. ");
INSERT INTO dne_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mumabhoko ghake akamula kipalo cha kuhebhe ngano jhake, jhambone naibhaha pamonga mu kikoko, na majhejheto naghajhochwa mwotu gwangahimika gwa machiko ghoha ghangapeta.” ");
INSERT INTO dne_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kwa malobhe ghange twe, Yohane abhalobholila bhando Malobhe gha Mbone na kwachokolekeya bhahenge ghamaha ghapala Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nambo Yohane ajhakumpwatalila kilongoche Helode, kwa nhwalo gwa kuntolela Helodiya mwikeghe jwa nnongo mundo na, helahela kwa ilebhe henge yanganandela yatehila. ");
INSERT INTO dne_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Peniya ndi Helode pachochita kuhenga yanganandela, kwa kuntabha Yohane, mukipungo. ");
INSERT INTO dne_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bhando bhoha pubhajhomolila kubatichwa, na jwenio Yecho ajhakubatichwa. Na panyopita Chapanga, kunane kujhakudinduka, ");
INSERT INTO dne_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","peniya ndi, Uhuke gwa Chapanga ujhakuhulukila panane jhake ngita ngunda, na lilobhe lijhakujhokanikika kuhumii kunane kwa Chapanga, “Mwenga ndi ma mwanango jhunimpala. Mwenga jhunhalalilwe nako.” ");
INSERT INTO dne_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yecho patumbwila kuhenga lihengo lyake, akahikicha muyaka makome matato. Na bhando pubhampapakiya pange mwana jwa Uchupo, na Uchupo akibha mwana jwa Hele, ");
INSERT INTO dne_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hele akibha mwana jwa Matate, Matate akibha mwana jwa Lawe na Lawe akibha mwana jwa Melike, Melike mwana jwa Yanae, Yanae akibha mwana jwa Uchupo, ");
INSERT INTO dne_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","na Uchupo akibha mwana jwa Matatiya, Matatiya akibha mwana jwa Amose, Amose akibha mwana jwa Nahumo, Nahumo akibha mwana jwa Helise, Helise akibha mwana jwa Nagaye, ");
INSERT INTO dne_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaye akibha mwana jwa Mahate, Mahate akibha mwana jwa Shemene, Amose akibha mwana jwa Shemene, Shemene akibha mwana jwa Yoseke, Yoseke akibha mwana jwa Yuda. ");
INSERT INTO dne_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yuda akibha mwana jwa Yohanine, Yohanine akibha mwana jwa Lesa, Lesa akibha mwana jwa Zelubabele, Zelubabele akibha mwana jwa Sheyalitele, Sheyalutiele akibha mwana jwa Nele, ");
INSERT INTO dne_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nele akibha mwana jwa Melike, Meleke akibha mwana jwa Ade, Ade akibha mwana jwa Kosamo, Kosamo akibha mwana jwa Elimadamo, Elimadamo akibha mwana jwa Hele, ");
INSERT INTO dne_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na Hele akibha mwana jwa Yochuwa, Yochuwa akibha mwana jwa Eliezele, Eliezele akibha mwana jwa Yolimo, Yolimo akibha mwana jwa Matate na Matate akibha mwana jwa Lawe, ");
INSERT INTO dne_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawe akibha mwana jwa Simone, Simone akibha mwana jwa Yuda, Yuda akibha mwana jwa Yolimo, Yolimo akibha mwana jwa Uchupo, Uchupo akibha mwana jwa Yonamo, Yonamo akibha mwana jwa Eliyakimo, ");
INSERT INTO dne_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakimo akibha mwana jwa Meleya, Meleya akibha mwana jwa Mena, Mena akibha mwana jwa Matata, Matata akibha mwana jwa Nachane, Nasane akibha mwana jwa Daude, ");
INSERT INTO dne_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na Daude akibha mwana jwa Yese, Yese akibha mwana jwa Obede, Obede akibha mwana jwa Boache, Boaze akibha mwana jwa Sulemane, Sulemane akibha mwana jwa Nashone, ");
INSERT INTO dne_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashone akibha mwana jwa Aminadabo, Aminadabo akibha mwana jwa Adimine, Adimine akibha mwana jwa Hezilone, Hezilone akibha mwana jwa Pelese, Pelese akibha mwana jwa Yuda, ");
INSERT INTO dne_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na Yuda akibha mwana jwa Yakobu, Yakobu akibha mwana jwa Isaka, Isaka akibha mwana jwa Ulahimo, Ulahimo akibha mwana jwa Tela, Tela akibha mwana jwa Nahole, ");
INSERT INTO dne_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahole akibha mwana jwa Seluge, Seluge akibha mwana jwa Leo, Leo akibha mwana jwa Pelege, Pelege akibha mwana jwa Ebele, Ebele akibha mwana jwa Sala, ");
INSERT INTO dne_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na Sala akibha mwana jwa Kenane, Kenane akibha mwana jwa Alifakisade, Alifakisade akibha mwana jwa Shemo, Shemo akibha mwana jwa Nuho, Nuho akibha mwana jwa Lameke, ");
INSERT INTO dne_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na Lameke akibha mwana jwa Metusela, Metusela akibha mwana jwa Henoke, Henoke akibha mwana jwa Yelede, Yelede akibha mwana jwa Mahalalele, Mahalalele akibha mwana jwa Kenane, ");
INSERT INTO dne_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenane akibha mwana jwa Enoshe, Enoshe akibha mwana jwa Sete, Sete akibha mwana jwa Adamo, na Adamo akibha mwana jwa Chapanga jwenio. ");
INSERT INTO dne_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yecho pabhujhita kuhumii kulukemba lwa ku Yolodane, kongo atwelii twe Uhuke gwa Chapanga na kulongochwa nako ade kunjenga, ");
INSERT INTO dne_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","na kweni Limbembela lijhakujhighanikila kwa machiko makome ncheche. Kwa machiko gheniya ghoha atamita changalye kilebhe, na pighajhomokila machiko gheniya njala ijhakumina. ");
INSERT INTO dne_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bhahe, Limbembela lela lijhakunnobholela, “Anda chakaka mwe ma Mwana gwa Chapanga, longela lighanga lendeno libhehe libumunda.” ");
INSERT INTO dne_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nambo Yecho palongolila, “Majhandiko gha Chapanga ghilonge, ughome gwa ‘Mundo naupitila ndeka mukulye mabumunda.’ ” ");
INSERT INTO dne_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ndi Limbembela, lijhakuntola Yecho ade kululegheleghe lwa kitombe, na kunaha unahota gwa pannema ghoha kwa mala jhimo. ");
INSERT INTO dne_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Peniya Limbembela nganongolila, “Unahota nkolongwa na ulumbililo ghongo ghoha nanipela henge yoha mwenga kubhehe gwino nhwalo bhambekii ghoha nenga. Na nihoto kumpekiya mundo jhojhoha jhunimpala. ");
INSERT INTO dne_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Anda nnyeketile kunyinamila nenga, naibhaha hino.” ");
INSERT INTO dne_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yecho panyangwila, “Majhandiko gha Chapanga ghilonge, ‘Jwakunyinamila ndi Bhambo Chapanga, abhii jhe jhonge!’ ” ");
INSERT INTO dne_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ndi Limbembela, ajhakuntola ade ku Yeluchalemo, na kunnyemeka ku lulegheleghe lwa Nyumba jha Chapanga na kunnobholela, “Anda mwe ma Mwana gwa Chapanga, kiponeya pahe, ");
INSERT INTO dne_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","mana ijhandikwe mu Majhandiko gha Chapanga ghilonge, ‘Chapanga nalaghalikiya akatumiche bhake bha kunane bhanonde.’ ");
INSERT INTO dne_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na kabhele, ‘Hote nantolela mu mabhoko ghabhe, nkotoka kukochoka mulighanga.’ ” ");
INSERT INTO dne_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nambo Yecho pajhangwila, “Majhandiko gha Chapanga ghilonge, ‘Nkotoka kunyighanikiya Bhambo Chapanga gwino.’ ” ");
INSERT INTO dne_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Limbembela pajhomolila kunyighanikiya Yecho kwa ndela yoha, lijhakunekekeya kwa machaa. ");
INSERT INTO dne_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Peniya Yecho ajhakubhujha ku Galilaya kongo atwelii twe Uhuke gwa Chapanga. Na malobhe ghake ghajhakuchobhela pa Galilaya na mu ilambo yoha ibhii pahina. ");
INSERT INTO dne_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bhambo Yecho patehila kubhola bhando munyumba jha kukonganikii Akayahude, kone alumbililwa na bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bhahe, Yecho ajhakujhenda ku Nachalete, ndi kwakolila. Pilihikita Lichiko lya Kupomolela, ajhakujhingii nkate munyumba jha kukonganikii Akayahude, ngita chibhakayobhalile. Pakibha mwenio ajhakujhema na apata kwachomela Majhandiko gha Chapanga kanonoha, ");
INSERT INTO dne_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ajhakupelwa kitabo chikijhandikwe na Isaya jwakibha nnondole jwa Chapanga, ajhakukiyekula na kupalaha chehemo jhijhandikwe. ");
INSERT INTO dne_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Uhuke gwa Bhambo ubhii panane jhango, ahagwii nenga kwalobholela akahocho Malobhe gha Mbone. Andumite kwalobholela bhibhabhii mu kipungo kudindulilwa kwabhe, na bhangalola, na bhene bhahotola kulola kabhele, andumite kwakombola bhoha bhibhabhonelwa. ");
INSERT INTO dne_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Machiko ghahikite, gha Bhambo kwakombola bhando bhake.” ");
INSERT INTO dne_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bhahe, pajhomolila kuchoma ajhakukighubika kitabo chela, na kumujhichila ntumiche na kutama pahe. Bhando bhoha bhibhakibha nkate jha munyumba jha kukonganikii Akayahude, bhajhakupikiya miho, ");
INSERT INTO dne_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jwenio ajhakwalobholela, “Lijhandiko lende litimile deleno punyokanikiya likachomwa.” ");
INSERT INTO dne_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bhando bhoha bhajhakuhutilwa nako na kuhechuka nhwalo gwa Malobhe gha Mbone ghabhalongolila. Bhajhakukonyana, “Bho, jwenio mwana gwa Uchupo ndeka?” ");
INSERT INTO dne_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yecho ajhakwalobholela, “Manyite naunongolela nnandanikiho ghongo, ‘Nghanga mukilamicha mabhene!’ Malobhe ghoha ghitujhohina ghuhengita kwenio kukapelenaumo, mughahenge peniya pa muche gwito.” ");
INSERT INTO dne_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yecho pajhendilila kwalongolela, “Ninnobholela chakaka, abhii jhe nnondole jwa Chapanga jhubhakung'ila pa muche gwake.” ");
INSERT INTO dne_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Nambo unyokanikiya ninongolela, chakaka bhakibha akanawela bhamahele pa kilambo chuku Ichilahele machiko gwa Eliya, machiko ghenagha hula ikalekite kukoma kwa yaka itato na miyehe chita, pajhakubhehe na njala ngolongwa pakilambo choha. ");
INSERT INTO dne_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nambo Eliya akatumitwe ndeka kujhenda kwa mwikeghe nawela jhojhoha jhola, nga kwa jhumo jwatamita kumuche gwa ku Cheleputa, ku kilambo chuku Sidone. ");
INSERT INTO dne_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mu machiko gha Elicha jwakibha nnondole jwa Chapanga, pakibha na bhando twe bhibhakibha na malohe ku Ichilahele, akibha ndeka mundo jwakajhelebhuka, nga Naamane, mundo jwa ku Siliya.” ");
INSERT INTO dne_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bhando bhoha bhibhakibha nkate munyumba jha kukonganikii Akayahude mola, bhajhakuyoma hake pibhajhohina ghenagha. ");
INSERT INTO dne_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bhajhakujhema, na kunghaghahana panja jha muche gwabhe ghuchengwite panane jha kitombe. Bhajhakuhutila ade mupele mwa ling'engo lya kitombe bhapata bhakangii pahe. ");
INSERT INTO dne_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nambo Yecho ajhakuholota pakate jha lilongo lela, ajhakukijhendela. ");
INSERT INTO dne_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Peniya Yecho pahelila ade kubomane jha ku kapelenaumo, ku kilambo chuku Galilaya. Na lichiko lya Kupomolela abholita bhando. ");
INSERT INTO dne_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bhakahechwike hake na mabholelo ghake, na malobhe ghake ghina ukindendeke. ");
INSERT INTO dne_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Peniya ndi, nkate munyumba jha kukonganikii Akayahude mola, akibha mundo jhumo jwabhii na nchuka. Ajhakulalama alongila, ");
INSERT INTO dne_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oko! Mwe ma Yecho bhuku Nachalete mipala nike kwito? Ko! Bho, uhikite kutukoma? Nenga, nimanyite mwenga maghane, Mwenga manyahinyahi bha Chapanga!” ");
INSERT INTO dne_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yecho ajhakuupwatalila nchuka alongila, “Tama nuu! Mumoke mundo jhonjo!” Na nchuka ujhakugwiya pahe mundo jhola, changa hingondokondo. ");
INSERT INTO dne_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bhando bhoha bhakakangiche, bhajhakulongelana malobhe bhene chika mabholo ghanga ghabhii bhole? “Mundo hojho abhii na ukindendeke na makakala gha kuhilobholela michuka ibhoke, na jhene ikabhoka!” ");
INSERT INTO dne_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Malobhe ghake Yecho ghajhakuchobhela pa kilambo choha. ");
INSERT INTO dne_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yecho papitita munyumba jha kukonganikii Akayahude, ajhakujhenda ukajha kwa Simone. Kwenio akibha nkohano mundo Simone mwikeghe atehila kulwalwa, bhajhakunyopa Yecho anamiche. ");
INSERT INTO dne_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yecho, ajhakujhenda pabhii majhe jhola, ajhakujhinama na kuupwatalila ulwalo ghola, papalapala majhe ajhakulama, ajhakujhinuka na kutumbuu kwatelekela. ");
INSERT INTO dne_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lyobha pulitumbwila kutipika, bhando bhoha bhibhalwalwa ulwalo ghoghoha ghola, bhabhutwiya ade kwa Yecho, na jwenio abhabhekila mabhoko kwa kila jhumo jwiilwalwa, ajhakulamicha bhoha. ");
INSERT INTO dne_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bhahe, michuka ijhakwachomoka bhando bhamahele, ilongila, “Mwenga ma Mwana bha Chapanga!” Nambo Yecho ajhakwapwatalila, alekita jhe kulonge, nhwalo bhamanyite jwenio ndi Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Patondogholo lukela jhake, Yecho ajhakujhenda pangabhando. Bhando bhatehila kumpalaha kwabhile, na pubhamwonita bhajhakuhibhilikiya akotoka kubhoka. ");
INSERT INTO dne_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nambo jwenie Yecho ajhakwalobholela, “Imbala kutangacha Malobhe gha Mbone gha Unahota nkolongwa gwa Chapanga kwa miche jhenge helahela, ndumitwe kwa nhwalo ghogho.” ");
INSERT INTO dne_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Peniya ndi ajhakujhendelela kutangacha Malobhe gha Mbone munyumba jha kukonganikii Akayahude jha ku Yudeya jhoha. ");
INSERT INTO dne_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lichiko limo, Yecho pakibha ajhemite pahina jha lilabha lya ku Genechalete, lilongo lya bhando lijhakuntindikiya na kukangana kangana, bhajhokanikiya lilobhe lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ajhakuhibhona ngalabha ibhele ijhebhelekiwe pahina jha lilabha, na bhapyeya homba bhene bhalenganikiya lwaho yabhe. ");
INSERT INTO dne_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yecho ajhakujhingii mungalabha jha mundo jhumo liina lyake Simone, ajhakunnobholela aheghekeye pupamila pandina kuhumii kupele mwa lilabha. Yecho ajhakutama mungalabha mwenio na kubhola lilongo lya bhando. ");
INSERT INTO dne_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pajhomolila kubhola, ajhakunobholela Simone, “Nheghekeye ngalabha jhino pupanyolike hake, peniya mukahuluhe lwaho lwino lwa kupyeke homba na ntumbula kupyeya.” ");
INSERT INTO dne_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simone ajhakujhanguu, “Bhambo, tughaghite kuhenga lihengo kilo jhoha kibhii jhe kilebhe chitujhambulile. Nambo nhwalo gwa mwenga nnongile, nahuluwa lwaho.” ");
INSERT INTO dne_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Peniya pibhahulwiha lwaho lwabhe, ndi bhajhakuponga homba yamahele hake, ade lwaho lujhakutwelela na kutumbuu kunochokana. ");
INSERT INTO dne_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bhajhakwakema bhajhabhe bhibhakibha mungalabha jhenge, bhahike kwatangatila. Bhakahikite, bhajhakutweleya ngalabha yoha ibhele homba ade ngalabha ipata kumilwa. ");
INSERT INTO dne_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simone Petile palolita gheniya, ajhakutama makilikite palonge jha Yecho alongila, “Bhambo mmoke palonge jhango, nenga ngwete uhakaho!” ");
INSERT INTO dne_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simone pamonga na bhajhake bhakahechwike kwa kuponga homba twe ngita yenio. ");
INSERT INTO dne_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Helahela Yakobu na Yohane yana ya Chebedayo, bhibhakibha akakoche bha Simone, na bhene bhakahechwike. Yecho pannobholila Simone, “Nkotoka kulendema, kuhumii ngoheno na kujhendelela namapyeha bhando ngita chimuleta homba ukajha.” ");
INSERT INTO dne_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bhahe, pibhajhomolila kubheka ngalabha yabhe muupele jha mulilabha, bhajhakubhoka bhoha na kunkengama Bhambo Yecho. ");
INSERT INTO dne_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Lichiko limo Yecho akibha ku muche ghumo gwa kwenio, mundo jhumo jhuna malohe yegha jhoha ajhakunhikilila. Pamonita Yecho ajhakukigwiya pahe mangukama na kunnobholela, “Bhambo, anda uhoto kunyelebhula, unyelebhulajhe!” ");
INSERT INTO dne_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yecho ajhakuhatambuu lubhoko lwake na kumpapaha na kulonge “Nipala, nnyelebhuke!” Papalapala malohe ghajhakummoka. ");
INSERT INTO dne_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yecho ajhakunaghalakiya, “Nkotoka kunnobhole mundo jhojhoha, nambo nnyende mukakilangiye kwa mupiya litambiko jwa Chapanga, na mpeleke litambiko lino kwa nhwalo gwa kujhelebhuka kwino ngita chalaghalikie Mucha nhwalo gwa kwalangii bhando bhoha nnamite.” ");
INSERT INTO dne_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nambo lilobhe lya Yecho lijhakuchocha kuchobhela poha, bhando bhamahele hake bhajhakukonganika kujhokanikiya na kulamichwa malwalo gwabhe. ");
INSERT INTO dne_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nambo Yecho pipipi ajhahwila chehemo jhanga bhando, kwa nhwalo gwa kunnyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lichiko limo, Yecho pakibha mukubhola, Mapwalichayo bhange na bhabhola bha Malaghalikilo, kuhumii mukila chenda jha ku Galilaya na ku Yudeya na ku Yeluchalemo bhakatamite pamonga. Na makakala gha Bhambo ghajhakubhehe pamonga na jwenio, kwa kulamicha bhibhalwalwa. ");
INSERT INTO dne_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ndi papa bhajhakuhika bhando bhangheghite mundo jwatengwike yegha jhoha mu nchekacheka, bhapata kujhinginako nkate, bhameke palonge jha Yecho. ");
INSERT INTO dne_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nambo nhwalo gwa kujholoka kwa bhando, bhakahotwii ndeka kujhingii nako nkate. Bhahe, bhajhakuhobhokela ku kipaghalo kupekenyela lihoto bhajhakuhuluwa pamonga na nchekacheka gwake, bhajhakumeka palonge jha Yecho. ");
INSERT INTO dne_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yecho palolita kihobholelo chabhe, ajhakunongolela jwalwalwa jhola, “Makoche bhango, nnekekiwe uhakaho gwino.” ");
INSERT INTO dne_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mapwalichayo na bhabhola bha Malaghalikilo, bhajhakutumbuu kukikonya, “Mwe maghane jhumunigha Chapanga! Abhii jhe mundo jwahoto kulekekeya uhakaho nga Chapanga kanjika!” ");
INSERT INTO dne_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yecho akamanye chibhahola ngakonyita, “Nhwalo gwa nike miwacha gheniya kumiojho jhino? ");
INSERT INTO dne_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nike chikijhojwike kulonge, ‘Uhakaho gwino ulekekiwe,’ amu kulonge, ‘Nnyeme ntyange?’ ");
INSERT INTO dne_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bhahe, nipala umanye kubhehe Mwana gwa Mundo akwete ukindendeke pannema gwa kulekekeya bhando uhakaho gwabhe.” Ajhakunnobholela jwatengwike jhola, “Ninobholela jhema, tola kindengato chino, nnyende kajhino!” ");
INSERT INTO dne_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Papalapala mundo jhola ajhekujhema palonge jha bhando bhoha, ajhakuto mpacha gwake na kujhenda kajhake kone annombita Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bhando bhoha bhakahechwike na kubhehe na bwaghaliya. Bhajhakunomba Chapanga, bhalongila, “Deleno tuibhwene ilebhe yakukangacha!” ");
INSERT INTO dne_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pighapetita gheniya, Yecho akapita panja na kumwona ntola kode jhumo liina lyake Lawe, jwatamita panyumba jha kulepe kode. Bhahe, Yecho ajhakunobholela, “Hika ungengame.” ");
INSERT INTO dne_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jwenio ajhakuleka kila kilebhe, na kukengama. ");
INSERT INTO dne_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Peniya, Lawe ajhakutendela unyagho nkolongwa gwa kulyegha Yecho kajhake, na lilongo lya akatola kode na bhando bhange bhakatamite pamonga nabho. ");
INSERT INTO dne_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nambo Mapwalichayo na bhabhola bha Malaghalikilo bhajhakwakokolekeya bhabholwa bhake Yecho, bhalongila, “Bho, nhwalo gwa nike mulye na kunywegha pamonga na akatola kode na bhibhabhii na uhakaho?” ");
INSERT INTO dne_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yecho pabhalongolila, “Bhando bhangalwalwa bhipala ndeka nghanga, nambo bhibhalwalwa nabhampala nghanga. ");
INSERT INTO dne_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nenga hikite jhe kwakema bhando bhaumbone bhangengame palonge jha Chapanga, nambo bhando bhibhabhii akahakaho, bhauleke na kughalambukila Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bhando bhange bhannobholila Yecho, “Bhabholwa bha Yohane Mbatichajhe na bha Mapwalichayo pipipi bhakibha bhapungite kulyegha na bhanyopita Chapanga. Nambo bhabholwa bhino bhikapii tugha.” ");
INSERT INTO dne_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yecho ajhakwajhanguu, “Bho, bhibhalalikwe kuunyagho gwa ndowa nnyinamwale munalome bhala paunyagho bhaleka kulyegha pubhabhehe pamonga na jwenio? Naha ndeka! ");
INSERT INTO dne_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nambo machiko ghabhikuhika gha nyinamwale munalome kubhoka pakate jhabhe, peniya ndi nabhapunga kulyegha.” ");
INSERT INTO dne_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yecho ajhakwalobholela nnandanikiho ghongo, “Abhii jhe mundo jwajwepula kibhambo cha ngobho yono na kuchonolela mukindukotuko. Anda atenda naha, najwepula ngobho nhyono na kibhambo nakiwanana ndeka na ngobho jhela jhitukutwike. ");
INSERT INTO dne_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Abhii jhe mundo jwabheka divaye hyono mulihako lilitukutwike lya limbendela. Anda ateii naha, divaye nhyono nahijwepula lihako lyenio na kujhitika. ");
INSERT INTO dne_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nambo divaye nhyono ubhekwa mulihako lya limbendela lya kubheke divaye nhyono. ");
INSERT INTO dne_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Abhii jhe mundo jwaipala kunywehe divaye nhyono anda akayobhalile kunywe jha makacho! Nhwalo ulonge ‘Jha makacho ndi lwengo hake.’ ” ");
INSERT INTO dne_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lichiko limo lya Kupomolela, Yecho atehila kupeta kutyanga mu mighonda jha mapemba na bhabholwa bhake bhajakutumbula kutwekula manjwanjwane gha mapemba, bhajhakuyogha kwa mabhoko na mbonje yake bhajhakumemena. ");
INSERT INTO dne_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nambo Mapwalichayo bhange bhajhakwakonya, “Bho, nhwalo gwa nike mihenga kilebhe chikikanikiwe kuhenga Lichiko lya Kupomolela?” ");
INSERT INTO dne_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yecho ajhakujhanguu, “Bho, mangota mukachomite ndeka chakatehile Daude na akajhake pubhakibha na njala? ");
INSERT INTO dne_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Daude akajhingii nkate pa Nyumba jha Chapanga, ajhakutola mabumunda ghighapihitwe kwa Bhambo, ajhakulyegha na ghange kwabhaghulila akajhake. Bhando bhange bhakanikiwa kulye jhe mabumunda gheniya nga mupiya matambiko bha Chapanga tugha.” ");
INSERT INTO dne_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ajhakwalobholela, “Mwana gwa Mundo abhii na uhotolo panane jha Lichiko lya Kupomolela.” ");
INSERT INTO dne_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lijhakuhika lichiko lenge lya Kupomolela, Yecho ajhakujhingila munyumba jha kukonganikii Akayahude atehila kubhola. Mwenio pakibha na mundo jhulukangamile lubhoko lwalelo. ");
INSERT INTO dne_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bhabhola bha Malaghalikilo na Mapwalichayo bhapaliya kihikola cha kuntakalila Yecho, bhatehila kulolela anda nanamicha mundo jhola Lichiko lya Kupomolela. ");
INSERT INTO dne_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nambo Yecho akamanyite chibhaholila, ajhakunnobholela jhulukangamile lubhoko jhola, “Nnyinuke, nnyeme pakate.” Mundo jhola ajhakujhema pakate jhabhe. ");
INSERT INTO dne_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Peniya ndi Yecho pabhalobholila, “Nikonye hote mangota, kilebhe ghane chambone ndeka kuhenga lichiko lya Kupomolela? Kuhenga lyamaha amu uhakaho? Kuukombola ughome gwa mundo amu kuukoma?” ");
INSERT INTO dne_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ajhakwalolekeya bhando bhoha bhibhakibha peniya, ajhakunobholela jhulukangamale lubhoko jhola, “Nhwatambule lubhoko lwino.” Na jwenio ajhakutenda yenio, lubhoko lwake lujhakulama njelembo. ");
INSERT INTO dne_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nambo bhene bhajhakuhyoma hake, bhajhakupwepwelana chakuntendela Yecho. ");
INSERT INTO dne_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bhahe, lichiko limo Yecho ajhakujhenda ku kitombe kunyopa Chapanga, ajhakukeluha kilo choha kujhopa. ");
INSERT INTO dne_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pukuchila ajhakwakema bhabholwa bhake bhoha, pakate jhabhe akabhahagwile kome na bhabhele ndi akabhatei akatenga. ");
INSERT INTO dne_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Bhakahaghulilwe ndi Simone Yecho ankemita Petile na unung'una mundo Anduleya na Yakobu na Yohane na Filipu na Batulomayo. ");
INSERT INTO dne_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matei na Tomase na Yakobu mwana gwa Alufayo pamonga na Simone jwankemitwa Zelote. ");
INSERT INTO dne_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yuda mwana gwa Yakobu na Yuda Iskaliyote, ndi jwanyambila Yecho. ");
INSERT INTO dne_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yecho pahelila kuhumii ku katombe pamonga na akatenga bhake, ajhakujhema pandika. Chehemo jhene pakibha na bhabholwa bhake pamonga na bhando bhange bhamahele bhibhahumila ku Yudeya na ku Yeluchalemo na bhange bhahumita kumbwane jha ku Tilo na ku Sidone. ");
INSERT INTO dne_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bhando bhene bhakahikite kunyokanikiya Yecho pamonga na kulamichwa ulwalo ghubhabhii nagho. Na kwalamicha bhando bhoha bhubhang'aichwa na michuka. ");
INSERT INTO dne_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bhahe, bhando bhoha bhaghaghalila kumpapaha Yecho, nhwalo gwa likakala lilipitita nkate jhake na kwalamicha bhoha. ");
INSERT INTO dne_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yecho ajhakwaghalambukila bhabholwa bhake, na kwalobholela, Mmii na luheko mangota makahocho, Nhwalo Unahota gwa Chapanga ndi gwabhe. ");
INSERT INTO dne_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mmii na luheko mangota bhumujhoha njala ngoheno, palonge nanyukuta. Mmii na luheko mangota bhumuulua mahole ngoheno, namukikajhula kiheko cha kuhangana. ");
INSERT INTO dne_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bhina mota na luhangano mangota bhando bhubhanchimwa, na pubhakanila na bhannighite na pibhanongela mangota mabhoho kwa nhwalo gwa Mwana gwa Mundo. ");
INSERT INTO dne_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Gheniya pughapala kupitila, nhwanganile na kukina, chakaka Chapanga nampela ndweko ngolongwa kunane kwa Chapanga. Nhwalo akahoko bhabhe bhakabhatendile milondole bha Chapanga hele naha. ");
INSERT INTO dne_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nanola choto mangota bhunkwete ilebhe mbwe, nhwalo nnyomwi kuhengwa miojho jhino. ");
INSERT INTO dne_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nanola choto mangota bhunywikwite ngoheno, nhwalo machiko gha palonge najhikwemba njala, “Nanola choto mangota bhumuhangana na kuheka ngoheno, nhwalo machiko gha palonge nanyemba mihambo jha malelo na kulela. ");
INSERT INTO dne_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Nanola choto mangota ngita bhibhanumbalila na bhando, nhwalo akahoko bhabhe bhakatendile milondole bha uwange helahela. ");
INSERT INTO dne_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Nambo ninnobholela bhumunyokanikiya. Mwapale akamakoko bhino, mwatendele ghambone bhando bhibhanchimwa. ");
INSERT INTO dne_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Majhopele mota bhoha bhubhannapanikiya, mwajhopele ghamaha bhubhantendela ghangana ndela. ");
INSERT INTO dne_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mundo anda anapwile litama limo lapu, mughalambukile na lenge. Na mundo anda apokite likote lino munekele na likanjo. ");
INSERT INTO dne_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bhahe, mundo jhojhoha jwanyopa mupela, na jhonge anda ampokite kilebhe chino mwangapala amujhichile. ");
INSERT INTO dne_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Helahela mwatendele bhando, ngita chimpala mangota kuhengelwa. ");
INSERT INTO dne_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Anda mwapala bhabhala bhala bhubhampala mangota, bho, nanyambulila ndweko ghane? Na bhubhatenda uhakaho hele bhapala bhala bhubhabhapala. ");
INSERT INTO dne_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kabhele, anda mwatendile ghambone tugha bhubhantendela mangota, nanyambulila ndweko ghane? Hilu jwatenda uhakaho, hele uhenga hele. ");
INSERT INTO dne_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kabhele anda mwajhahikicha bhala bhubhamanya nabhalepa, bho, nanyambulila ndweko ghane? Na bhubhahenga uhakaho ubhajhahikicha bhina uhakaho bhajhabhe kongo mipala kulepwa ngita chibhapemite. ");
INSERT INTO dne_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nambo mangota mwapale akamakoko bhino bhubhanchimwa na mwatendele ghamaha, majhahikiche changahobholela kubhujhichilwa, ndweko hino naibha ngolongwa, na mangota namaha yana ya Chapanga jwabhii Kunane. Nhwalo gwa Jwenio jwambone kwa bhanganchengula na bhahako. ");
INSERT INTO dne_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mma na kiya ngita Tate gwino chabhii na kiya. ");
INSERT INTO dne_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nkotoka kwahadabuu bhando bhange, na Chapanga nabhahadabula ndeka mangota. Nkotoka kwalongolela bhange ghanganandela, na mangota nanongolelwa, mwalekekehe bhibhalemwa, na mangota nanekekewa hele. ");
INSERT INTO dne_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mapele bhando ilebhe, na mangota nanipela. Ndi, nanpokela kipemo chikitwelile mu mabhoko ghino, na kuhindilila, kuheluka ade kujhitika. Nhwalo gwa kipemo cheche chimapemi bhajhino na Chapanga napemela ngita cheche kumpemela mangota.” ");
INSERT INTO dne_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kabhele Yecho ajhakwalobholela nnandanikiho ghongo “Bho, jwangalola nahotola kuntandaha jwangalola nnyake. Anda atei naha, bhoha bhabhele nabhatumbukila mulibhomba.” ");
INSERT INTO dne_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mmolwa ampeta ndeka mmola gwake, nambo mmolwa ahotola kulandana mmola anda ajhomwile mabholo ghake. ");
INSERT INTO dne_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bho, nhwalo gwa nike mukibhona kapalamande chikibhii muliho lya nnongo gwino, kongo mukibhonajhe lijhola lino? ");
INSERT INTO dne_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nahotola bhole kunnobholela nnongo gwino, ‘Chonde, malongo bhango denda nimohe hote lipande muliho liho.’ Na kone mulibhonajhe lijhola libhii muliho lino? Mwenga mukitenda jwaumbone! Ntumbula hote kubhoha lijhola lilibhii muliho lino, peniya ndi nauhotola kulola telatela na kubhoha lipalamande lilibhii muliho lya nnongo gwino. ");
INSERT INTO dne_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ubhii jhe nkongo gwambone ghupambika uhoe ghanganandela, helahela nkongo gwanganandela upambika ndeka uhoe gwambone. ");
INSERT INTO dne_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nhwalo kila nkongo umanyikana kwa uhohe gwake. Bhando bhipochomola ndeka mahuko kuhumii mu mikwanga, hilu kupochomola mbingapinga kuhumii munjanyanda. ");
INSERT INTO dne_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Helahela mundo jwamaha ubhoha ilebhe yambone kuhumii mu kihukilo chikibhii kumwojho gwake, na mundo upiya ilebhe yanganandela kuhumii kukihukilo cha mwojho gwake. Nhwalo mundo ilongela ilebhe hela itwelile kumwojho gwake. ");
INSERT INTO dne_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nhwalo gwa nike mingema, ‘Bhambo, Bhambo,’ na kongo muhenga ndeka ghuninaghalikiye nhwenge? ");
INSERT INTO dne_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Naninangiya nnandanikiho gwa mundo jwahika kwa nenga, jwaghajheketela malobhe ghango na kughahenge lihengo, ");
INSERT INTO dne_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","peniya ndi nahwanana na mundo jwachenga nyumba, jwahemba nchinge mulindalabho, na kuchenga nyumba jhene peniya. Hula ngolongwa puikomita mache pughaeluka na kuikangakanga nambo ikagwii ndeka, nhwalo ikachengwite mbone. ");
INSERT INTO dne_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nambo mundo jhojhoha jwajhoha malobhe na kughaleka changahenge lihengo, jwenio nalandana na mundo jwachengite nyumba panane jha ncheke pangahemba nchinge. Mache pughaheluka uhinyua nyua nyumba jhene na kugwegha na kubhehe tilutilu!” ");
INSERT INTO dne_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yecho pajhomolila kulonge nabho bhando, ajhakujhenda ku Kapelenaumo. ");
INSERT INTO dne_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kwenio akibha kilongoche jhumo jwa akakomana ngondo jwa ku Loma, jwakibha na ntumiche gwake jwanhobholila hake. Na ntumiche jwenio atehila kulwalwa tepekatepeka abhandikila kuwegha. ");
INSERT INTO dne_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nkolo jwa akakomana ngondo jhola pajhohina malobhe panane jha Yecho, ajhakwatuma ighogholo ya Akayahude, bhajhende bhakannyope Yecho ahike kunamicha ntumiche gwake. ");
INSERT INTO dne_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ighogholo hela pubhahikita kwa Yecho, bhajhakumpembelekeya hake chonde Bhambo tunyopa mkantangatile kilongoche jwa akakomana ngondo jhola, bhalongila, “Mundo jhonjo itopile kuhengelwa kilebhe chenie, ");
INSERT INTO dne_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kwa nhwalo abhapala hake bhando bha ilambo hito, kabhele atuchengile nyumba jha kukonganikii Akayahude kwa nhwalo gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bhahe, Yecho ajhakulongohana nabho, pubhaheghelila pa nyumba jha nkolo jhola, ndi nkolo jhola ajhakwatuma akakoche mundo bhanobholele Yecho, “Bhambo, chonde nkotoka kuking'aha nenga itope ndeka mwenga kujhingila nkate jha nyumba jhango. ");
INSERT INTO dne_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nambo nenga ndopi ndeka kuhika kwino. Nambo unobholele lilobhe tugha, na ntumiche jwango nalama. ");
INSERT INTO dne_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Helahela namwete ndi mundo jhumii na ukindendeke, ngwete akakomana ngondo bhinalongocha. Anda ninobholile jhumo, ‘Jhenda!’ Na jwenio ujhenda, na ninobholela jhonge ‘Ika!’ Na jwenio uhika. Anda ninobholile ntumiche gwango, ‘Uhenge lende.’ Na jwenio uhenga.” ");
INSERT INTO dne_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yecho pajhohina malobhe gheniya akakangiche hake, ajhakughalambukila lilongo lya bhando gwakalongihine nagho, ajhakulobholela, “Ninalola ndeka jhuna kihobholelo ngita chenje, hilu pakate jha kilambo choha chuku Ichilahele!” ");
INSERT INTO dne_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Peniya bhando bhala bhubhakajhenda kwa Yecho pubhabhujhita ukajha kwa kilongoche jwa ku Loma bhakankolile ntumiche jhola alamite. ");
INSERT INTO dne_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pajhomolila peniya, Yecho ajhakujhenda kubomane jha ku Naine, bhabholwa bhake na lilongo lya bhando bhakalongohine pamonga na jwenio. ");
INSERT INTO dne_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Paheghelila litangala lya kujhingilila pa bomane jhela, ajhakukongana nabho bhando bhubhagheghite malelo mukindanda cha kugheghe malelo bhajhenda kumambe. Jwenio jwakawile akibha nchongolo, mwana jwabhelwike kanjika kwa majhe mundo. Na bhando bhamahele bha pabomane jhela bhakibha pamonga na jwenio majhe. ");
INSERT INTO dne_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bhambo Yecho pamonila kiya majhe nawela jhola, ajhakunobholela “Nkotoka kulela.” ");
INSERT INTO dne_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Peniya, ajhakujhenda palonge jha nchekacheka gwa kugheghe malelo ajhakupapaha, na bhubhagheghite malelo bhajhakujhema nuu. Na Yecho ajhakulonge, “Nchongolo! Ninobholela, nnyimuke!” ");
INSERT INTO dne_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nchongolo jwakawile jhola, ajhakutama na kutumbuu kulonge, na Yecho ajhakukamuha kwa majhe mundo. ");
INSERT INTO dne_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bhando bhoha bhajhakukamulwa na kiholo, na bhene bhajhakunomba Chapanga, bhalongila, “Nnondole nkolo apitile kwito, Chapanga ahikite kwaghombola bhando bhake.” ");
INSERT INTO dne_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Malobhe gheniya ghajhakuchobhela ku kilambo chuku Yudeya choha na ilambo henge ya pahina. ");
INSERT INTO dne_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Bhabholwa bha Yohane Mbatichajhe bhajhakunnobholela Yohane ilebhe yoha ipitila. Na jwenio Yohane, ajhakwakema bhabholwa bhake bhabhele, ");
INSERT INTO dne_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na kwatuma bhajhende kwa Bhambo Yecho bhakankonye, “Bho, mwenga ndi jhola jwahika, amu tunendelele jhonge?” ");
INSERT INTO dne_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Peniya bhabholwa bhala bhajhakujhenda kwa Yecho, bhajhakunnobholela, “Yohane Mbatichajhe atitume kwino mwenga tunkonye, bho, mwenga ndi jhola jwahika, amu tunendelele jhonge?” ");
INSERT INTO dne_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Machiko ghagha, pubhakibha bhankonyita Yecho akibha makwalamicha bhando bhamahele bhibhabhii na ulwalo, bhubhachikilwe na michuka, helahela bhangalola bhahoto kulola. ");
INSERT INTO dne_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bhahe, Yecho ajhakwajhanguu, “Nnyendengane mukannobholele Yohane ghoha ghumujhoha na kughabhona. Bhangalola bhilola, na bhubhalemile bhityanga, bhina malohe bhilamichwa na bhangajhoha bhijhoha na bhubhawile bhiyokechwa na akahocho bhatangachilwa Lilobhe lya Mbone. ");
INSERT INTO dne_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jhuna mota mundo jhola jwanganeka kunyeketela nenga!” ");
INSERT INTO dne_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bhabholwa bha Yohane pubhabhokita, Yecho ajhakutumbula kulilongolela lilongo lya bhando malobhe panane jha Yohane, “Punyahwila kunjenga nnyabhila kulola nike? Bho, nnyabhila kulinga litete pulipogha pogha upepo? ");
INSERT INTO dne_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bhahe, mukajhawile kulola nike? Nnyahwila kuninga mundo jwawalite ngobho ichuluchwa kwa mbijha yamahele? Bhando bhibhahwala ngobho ngita yenio na kutama kwa kuhanganila, utama majhumba gha akanahota na kukipala hake bhene! ");
INSERT INTO dne_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bhahe, unobholele nike chimukajhawile kulinga? Bho, nnondole jwa Chapanga? Tela, chakaka jwenio ndi nkolongwa kupeta nnondole jwa Chapanga jhumoyobhalile. ");
INSERT INTO dne_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jwenio Yohane ndi jwalongelwa mu Majhandiko gha Chapanga, alongila, ‘Dola nintuma ntumiche gwango anongolele, palonge jhino anenganikihe ndela jhino.’ ” ");
INSERT INTO dne_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yecho pajhomolila kulonge, “Yohane Mbatichajhe ndi nkolongwa pakate jha bhando bhubhapapitwe na mwikeghe. Helahela jhojhoha jwabhii jwandina munahota gwa Chapanga ndi nkolongwa kupeta Yohane.” ");
INSERT INTO dne_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bhando bhoha, pamonga na akatola kode pubhajhohina gheniya, bhakajheketile kubhehe ndela jha Chapanga ndi telatela na bheniya ndi bhala bhubhakabatichwe na Yohane. ");
INSERT INTO dne_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nambo Mapwalichayo na bhabhola bha Malaghalikilo bhajhakukana mpangu gwa Chapanga ghukibha gwabhe, bhahe bhajhakukana kubatichwa na Yohane. ");
INSERT INTO dne_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Bhahe, Yecho pajhendilila kulonge, “Bho, ninandanikiye bhando bha kibheleko chenje na kilebhe ghane? Nnandine na nike? ");
INSERT INTO dne_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ngita ichongolo ikibha itamingine paliguliho na kujhangulana kibhogha chimo na chenge, ‘Tunhonile kitolilo! Nambo mangota nkinite ndeka. Tunyembile mihambo jha malelo, nambo mangota nnelite ndeka!’ ");
INSERT INTO dne_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kwa nhwalo Yohane Mbatichajhe akahikite, atehila kupunga na anywila ndeka divaye, na mangota nnyakulonge, ‘Achikilwe nchuka!’ ");
INSERT INTO dne_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jwenio Mwana gwa Mundo pahikita, alila na kunywegha, na mangota punongila, ‘Munolekehe mundo hojho chajhenda kuhapatika na kulobhela, nkoche jwa akatola kode na bhibhabhii na uhakaho!’ ");
INSERT INTO dne_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nambo malango gha Chapanga ghalangiwe kubhehe ghambone kwa bhoha bhibhanyeketela.” ");
INSERT INTO dne_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Bhahe, mundo jhumo Mpwalichayo ajhakunalika Yecho ajhende kajhake akalyeghe ndalilo. Ndi ajhakujhenda munyumba jha Pwalichayo jhola na kutama kulyegha. ");
INSERT INTO dne_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Bhahe, pakibha na mwikeghe jhumo pamuche gwenio jwabhii na uhakaho. Mwikeghe jwenio pajhohina Yecho abhii nkate mwa Pwalichayo atenda kulyegha, ajhakujhenda na chupa jhitengenichwe kwa lighanga lya alabachita nkate mwenio ghakibha mahuta ghighanungila petelele, ");
INSERT INTO dne_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","peniya mwikeghe jhola ajhakuhika na kujhema kuyeto, na kubhandikila makongono gha Yecho, kongo atehila kulela na mahole ghake ghandonyikila mu makongono gha Yecho. Peniya ajhakuhungula makongono gha Yecho kwa majhunjo ghake na kuchopa makongono ghala na kughapaka mahuta ghakibha nagho. ");
INSERT INTO dne_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pwalichayo jhola jwanalike Yecho palolita naha, ajhakuwacha kumwojho gwake, “Chakaka mundo hojho ngabhehe nnondole jwa Chapanga, ngaumanyite mwikeghe hojho chabhile, kubhehe jhuna uhakaho!” ");
INSERT INTO dne_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Peniya Yecho ajhakunyangula jwenio Pwalichayo, alongila, “Simone, ngwete kilebhe cha kunobholela.” Na jwenio Simone ngajhangwila, “Chakaka mmola, dongela.” ");
INSERT INTO dne_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yecho ndi palongila, “Bhahe, pakibha na bhando bhabhele bhakajhenda kunnyahika mundo jhumo jwahenga lihengo lya kujhahikicha mbijha. Jhumo akajhahike mbijha makome amuchine na jhonge akajhahike mbijha makome nhwano. ");
INSERT INTO dne_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bhoha bhabhele pubhalepila kulepa maghambo ghabhe, mundo jwenio jwajhahikicha mbijha ajhakwalekekeya bhoha bhabhele. Bho, ndi ghane pakate jha bhabhele bheniya jwapala kumpala hake jhola jwajhahikicha?” ");
INSERT INTO dne_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simone ajhakujhanguu, “Puniwacha jwalekekiwe lighambo likolongwa jhola ndi nampala hake jwenio.” Yecho ajhakunobholela, “Unyangwii mbone.” ");
INSERT INTO dne_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Peniya Yecho ajhakughalambukila mwikeghe jhola na kunobholela Simone, “Bho, mumwene mwikeghe jhonjo, naha ndeka? Bhahe, nenga punyingila pakajha pino mukambekihe ndeka mache gha kughololela makongono ghango, nambo mwikeghe jhonjo akagholwile makongono ghango kwa mahole ghake na kuhunguu kwa majhunjo ghake. ");
INSERT INTO dne_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mwenga unyambwiche ndeka kwa kunjopa, nambo mwikeghe jhonjo punyingila tuu pambano alekite jhe kuchopa makongono ghango. ");
INSERT INTO dne_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nambo mwenga ukambakijhe mahuta pamuto gwango, mwikeghe jhonjo ambakite mahuta gighanungilila petelele makongono ghango. ");
INSERT INTO dne_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bhahe, ninobholela mwikeghe jhonjo chakaka alekekekiwe uhakaho gwamahele ndi nhwalo alangie ughano nkolongwa, nambo jwalekekewa pandina, jwenio upala pandina.” ");
INSERT INTO dne_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Papalapala Yecho ajhakughalambukila mwikeghe jhola, “Uhakaho gwino ghoha ulekekiwe.” ");
INSERT INTO dne_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bhando bhala bhakibha nabho pakulyegha bhajhakukonyana, “Bho, ndi mundo ghane hojho jwahoto kulekekeya uhakaho?” ");
INSERT INTO dne_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jwenio Yecho ajhakunobholela mwikeghe jhola, “Kihobholelo chino kikombwile, nnyende kwa uteeke.” ");
INSERT INTO dne_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Puipetita ilebhe yenio, Yecho ajhakubheghela bheghela pabomane na muchenda kutangacha Malobhe gha Mbone gha Unahota nkolongwa gwa Chapanga. Na bhabholwa bhake kome na bhabhele bhala bhakalongohine na jwenio pamonga, ");
INSERT INTO dne_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","helahela pakibha na akakeghe bhubhakabhohitwe michuka na kulamichwa ulwalo, mulilongo lyenio akibha Maliya Magidalena jwahumila ku Magidala, na jwenio akalamichwe ulwalo pamonga na kubhoha michuka chaba jhakibha najho. ");
INSERT INTO dne_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yoane nhwana gwa Kucha, jwenio Kuza akibha kilongoche nkolo jwa akatumiche bha nyumba jha nkolongwa Helode, na suzana pamonga na akakeghe bhange bhapihita ilebhe yabhe kuntangatila Yecho na bhabholwa bhake. ");
INSERT INTO dne_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bhando bhamahele bhakibha bhanyendilila Yecho kuhumii ku miche jhamahele bhakajhenda na kukonganika pamonga. Likunde likolongwa pulikongina pamonga ajhakwalobholela mana jha nnandanikiho gwenio. ");
INSERT INTO dne_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mundo jhumo akajhenda kumicha mbejho yake kung'onda. Pamichita mbejho yenio, mbejho henge ikaponile pahupele jha ndela na bhando bhajhakutimba timba na ijhune ijhakuhonyola. ");
INSERT INTO dne_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bhahe, mbejho henge ikaponi mumaghanga undope ukibha ndeka kihekendo ghubhii panane jha lindalabho, na yenio puhitumbwila kulingulila ilomo lomo, ijhakunyala nhwalo gwangabhehe ubhehe mundope. ");
INSERT INTO dne_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Henge ikaponikiye pakate jha mikwanga, jhene mikwanga piimelita ijhakuhindimana. ");
INSERT INTO dne_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Henge ikaponile mu undope ghubholile. Ijhakumela na kupambika pochii kupeta henge yamichita.” Pajhomolila kulonge gheniya, Yecho ajhakunonoha lilobhe, alongila, “Jwabhii na machikilo gha kujhoha na abangatuka!” ");
INSERT INTO dne_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Peniya bhabholwa bhake bhakanyendile Yecho na kunkonya, nhwalo gwa nnandanikiho gwenio. ");
INSERT INTO dne_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yecho ajhakwalobholela, “Mangota mpatite kumanya chile jha unahota nkolongwa gwa Chapanga hotuhotu, nambo kwa bhando bhange naha ndeka, bhene bhalongolelwa kwa milandanikiho bhakopela na bhakotoka kulola na bhajhoha na bhakotoka kubangatuka.” ");
INSERT INTO dne_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Bhahe, nnandanikiho ghongo mana jhake. Mbejho ndi lilobhe lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbejho hela iponi mundela, ndi ulandanikiwa na bhando bhubhajhoha lilobhe lya Chapanga, peniya Limbembela uhika na kulikotopola kuhumii kumwojho gwabhe, bhakotoka kubhehe na kihobholelo na kughombokoka. ");
INSERT INTO dne_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Hela iponi mukihekendo, nnandanikiho gwa mundo jwalijhoha lilobhe lya Chapanga na kulipokela kwa kuhangana, nambo bhabhehe jhe na mikegha, bhalihobholela lilobhe lyenio pandina tugha, malola anda ghahikilile kihobholelo chenie ukileka kolya. ");
INSERT INTO dne_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mbejho hela ikaponikiye pa mibha ulandanikiwa na bhando bhala bhubhajhokanikiya lilobhe lya Chapanga, nambo pubhajhendelela lilobhe lyenio, uhindimana na iholo na ilebhe ya pannema pano. Bhando bhamba bhihotola ndeka kuhenga chochoha chamaha kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nambo mbejho iponi pa undope ghubholile, ndi ulandanikiwa na bhando bhala bhibhajhokanikiya lilobhe lya Chapanga na kulichokolekeya kwa mwojho gwa umbone. Kabhele uhimbilila na kujhendelela kuhenga ghapala Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Bhando bhipamba ndeka kolobohi na kuhibheka nkate mukihulo hilu kubheka kuhe jha kindanda. Nambo ubheka panane jha kinala, bhando pubhajhingii nkate bhalola mbone. ");
INSERT INTO dne_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Na kilebhe chochoha chikihihitwe chenie nakihumbuka, na kilebhe chochoha chikiyatalilwe na chenie nakimanyikana mbegha. ");
INSERT INTO dne_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Bhahe, mukilolekeye na malobhe ghumijhoha, mundo jwabhii na kilebhe, jwenio najhonjekewa chenge, nambo jwangabhenacho, napokwa hilu chenie chandina chahola abhii nacho.” ");
INSERT INTO dne_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Majhe mundo na akalongo bhake Yecho bhakajhabhii kunninga, nhwalo gwa lilongo lya bhando kujholoka, bhakahotwii ndeka kuhuheghelela. ");
INSERT INTO dne_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mundo jhumo ajhakunnobholela Yecho, “Majhe gwino na akalongo bhino bhajhemite panja bhapala kumona mwenga.” ");
INSERT INTO dne_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nambo Yecho ajhakwalobholela bhoha, “Majhe gwango na akalongo bhango ndi bhala bhibhajhoha lilobhe lya Chapanga na kulihenge lihengo.” ");
INSERT INTO dne_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Peniya lichiko limo Yecho ajhakujhingila mungalabha pamonga na bhabholwa bhake, ajhakwalobholela, “Tujhende tujhomboke ade kwiye jha lilabha.” Bhahe, bhajhakutumbuu mwanja. ");
INSERT INTO dne_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bhahe, pubhakibha mumwanja, Yecho ajhakugholoka mungalabha mola, chwechelele kimbonga kikolongwa kijhakupogha, na mache ghajhakutumbula kujhingila nkate jha ngalabha, na bhene bhatumbwila kumilwa. ");
INSERT INTO dne_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bhabholwa bhake bhala bhajhakunyendelela Yecho, bhajhakunyimuwa bhalongila, “Bhambo, Bhambo! Tanjino kuwegha!” Yecho ajhakung'ang'anuka na kukipwatalila kimbonga kikolongwa na matuhe gha mache ghala, ghajhakuleka, ndi pajhakubhehe njelembo. ");
INSERT INTO dne_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Papalapala ajhakwakonya bhabholwa bhake, “Bho, kibhii kojhe kihobholelo chino?” Nambo bhene bhajhakukangacha na kujhoghopa kone bhapwepwelina, “Mundo hojho abhii bhole, ahoto kukipwatalila kimbonga kikolongwa na matuhe gwa mache, na yenio ikanyeketela!” ");
INSERT INTO dne_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yecho na bhabholwa bhake bhakajhendilile na mwanja na kuhika kumuche gwa ku Kilambo cha Akagelache ghubhii kwiye jha lilabha lya ku Galilaya, ");
INSERT INTO dne_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yecho pahulwika mungalabha, ajhakukongana na mundo jhumo haikilila kuhumii pabomane jwakibha na michuka. Mundo jwenio kwa machiko ghamahele ahwalitajhe ngobho hilu kutama pakajha, nambo jwenio ahwelita ku mambe. ");
INSERT INTO dne_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mundo jhola pamwonita Yecho, ajhakulalama kanonoha na kukigwiya pahe palonge jhake na kulonge kanonoha, “Yecho, Mwana gwa Chapanga Nkolongwa, kibhii nike na nenga? Nijhopa, chonde ungotoka kung'aha!” ");
INSERT INTO dne_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Alongila naha nhwalo gwa Yecho akibha aupwatalile nchuka ghola umoke mundo jwenio. Nchuka gwenio uchikilicha mundo jwenio lihwelita machiko ghoha. Bhando bhamekita nkate na kunkonga ngojhe ya minyololo na pingo mumakongono na mu mabhoko, nambo ahwelita kunocholana, na nchuka gwitutuhana ade kunjengane. ");
INSERT INTO dne_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bhahe, Yecho ajhakukonya, “Bho, liina lino ghane?” Na jwenio ajhakujhanguu, “Liina lyango ndi, ‘Lilongo,’ ” nhwalo akibha na michuka twe bhubhakajhingile. ");
INSERT INTO dne_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nambo michuka jhela ijhakumpembelekeya Yecho, inongolila, chonde nkotoka kutukangila ku libhomba lyanga upekeho na kuhobhelela kwenio. ");
INSERT INTO dne_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pahina jhake pakibha na lilongo lya magholobhe ghalila mupele mwa kitombe. Michuka jhela ijhakumpembelekeya Yecho bhajhende bhakajhingile magholobhe, na Yecho ajhakwalekekeya ghajhingile magholobhe. ");
INSERT INTO dne_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bhahe, michuka jhela pwichomwika mundo jhola, ijhakujhenda kwa magholobhe ghala, na lilongo lyoha lijhakulubheha lubhelo kutumbukila mulilabha na kuwelela mwenio. ");
INSERT INTO dne_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Peniya bhalucha magholobhe bhoha pubhalolita ghughapitile, bhajhakujhenda lubhelo kwalongolela bhando malobhe kubomane na muchenda. ");
INSERT INTO dne_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bhahe, bhando bhamahele bhakahikite kulolekeya ghughapitile. Pubhahikita pabhii jha Yecho bhajhakunkolela mundo jwabhii na michuka jhola, abhii pahina na Yecho, kongo ahwalite ngobho na malango ghake ghahengwite! Bhakajhogwipe hake. ");
INSERT INTO dne_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bhando bhala bhubhalolita ghughatendika, ajhakulonge mundo jhola chalamichwe. ");
INSERT INTO dne_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Peniya bhando bhu ku kilambo cha Wagelache jhoha, bhajhakubhehe na bwaghaliya bhajhakunyopa Yecho abhoke peniya na ajhende konge. Yecho ajhakujhingila mungalabha na kubhoka. ");
INSERT INTO dne_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Bhahe, mundo jhubhanchomwila michuka jhola ajhakunnyopa Yecho bhajhende bhoha, nambo Yecho ajhakuntabhuka, anobholila, ");
INSERT INTO dne_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nnyende kajhino mukalongele ilebhe yoha ikolongwa yantendile Chapanga.” Bhahe, peniya mundo jwenio ajhakujhenda, na kwatangachila bhando bha pabomane bhoha makolongwa ghatendilwe na Yecho. ");
INSERT INTO dne_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bhahe, Yecho pabhujhita kabhele kwiye jha lilabha, ajhakulikolela lilongo lya bhando lijhakumpokela kwa ilulo, kongo bhatehila kunnendela. ");
INSERT INTO dne_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bhahe, ajhakuhika kilongoche jhumo jwa nyumba jha kukonganikii Akayahude, liina lyake Jailu, ajhakutama makilikite palonge jha Yecho na kumpembelekeya ajhende kajhake. ");
INSERT INTO dne_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nhwalo nchikana gwake jwakanjika, jwakibha na yaka kome na mibhele, atehila kulwalwa tepekatepeka abhandikila kuwegha. Peniya Yecho pajhahwila kajha kwa Jailo, lilongo lya bhando lijhakuhindamana kwenio. ");
INSERT INTO dne_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Bhahe, pakibha na mwikeghe jhumo pakate jha lilongo lela, mwikeghe jwenio alwalita ulwalo gwa pihe kwa yaka kome na mibhele. Kabhele akataghine ilebhe yake yoha kwa akaghanga, nambo abhii jhe jwakahotwii kunamicha. ");
INSERT INTO dne_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mwikeghe jwenio ajhakunyendela Yecho cha kuhyeto na kupapaha lilombolo lya ngobho jhake. Papalapala ulwalo gwake gwa pihe, ajhakulama. ");
INSERT INTO dne_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yecho ajhakwakonya, “Bho, ghane jwambapihe?” Bhando bhoha pubhakanita, Petile ajhakulonge, “Bhambo, lilongo lya bhando bhubhahindamine na bhikanganakangana!” ");
INSERT INTO dne_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nambo Yecho ajhakulonge, “Abhii mundo jwambapapihe, nikijhoha likakala lyango imokite.” ");
INSERT INTO dne_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Peniya mwikeghe jhola palepelila kujhendelela kujhobha, ajhakukilaha kongo atehila kulendema, ajhakutama makilikite palonge jha Yecho. Ajhakunnobholela pa bhando bhoha, nhwalo ghundumite kumpapaha Yecho na chinamichwe papa. ");
INSERT INTO dne_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yecho ajhakunnobholela, “Nchikana gwango, kihobholelo chino kinamiche, nnyende kwa uteeke.” ");
INSERT INTO dne_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yecho pajhendelila kulonge, ajhakuhika ntumiche jhumo kuhumii kajha kwa Jailu, ajhakunobholela Jailu, “Nchikana jwino ajhomwike, nneke kujhendelela kuntotoha Mmola.” ");
INSERT INTO dne_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nambo pajhomwila Yecho gheniya, ajhakunnobholela Jailo, “Nkotoka kujhoghopa, uhobholele tugha, nchikana jwino nalama.” ");
INSERT INTO dne_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pahikita pakajha pa Jailo, Yecho ajhakuhibhilikiya mundo jhonge kujhingila nkate nga Petile na Yohane na Yakobu pamonga na tate na majhe jwa nchikana jhola. ");
INSERT INTO dne_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Bhando bhoha bhakibha bhalelita malelo gha nchikana jwenio, nambo Yecho ajhakwalobholela, “Nkotoka kulela, nchikana ahwii ndeka, abhii mugholoka tugha!” ");
INSERT INTO dne_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nambo bhene bhajhakunheka Yecho, nhwalo bhakamanye nchikana jhola ajhomwike. ");
INSERT INTO dne_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bhahe, Yecho ajhakukamula lubhoko na kunkema, “Mwe mwana, jhimuka!” ");
INSERT INTO dne_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ughome gwake ujhakumujhila kabhele, papalapala ajhakujhimuka. Ndi Yecho ajhakwalobholela bhankupile chakulyegha. ");
INSERT INTO dne_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tate na majhe gwa nchikana jhola bhajhakuhechuka hake, nambo Yecho ajhakwakanikiya bhakotoka kunnobholela mundo jhojhoha ilebhe yoha itendika peniya. ");
INSERT INTO dne_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yecho ajhakwakema bhabholwa bhake kome na bhabhele, ajhakwapekeya makakala pamonga na ukindendeke panane jha michuka jhoha na kulamicha ulwalo ghoghoha, ");
INSERT INTO dne_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","peniya ndi ajhakwatuma bhajhende bhakatangache Malobhe gha Unahota nkolongwa gwa Chapanga na kulamicha bhibhalwalwa. ");
INSERT INTO dne_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ajhakwalobholela papalapala, alongila, “Nkotoka kughegha kilebhe chochoha mu mwanja gwino, hilu nkongocho, hilu lihako na ilebhe ya kulyegha amu mbijha amu ngobho ya kujhangangana. ");
INSERT INTO dne_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bhahe, pa nyumba jhojhoha jhipala kujhingila na kupokelwa, ntame mwenio ade pupala kubhoka. ");
INSERT INTO dne_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bhando anda bhakanite kumpokela, ndi mumokengane pa muche gwenio, na pumpala kukitabhuka makung'undila lutukunda lwa mu magholo gwino kwalangiya nginyililo kubhehe bhakajhonikiye jhe.” ");
INSERT INTO dne_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bhahe, bhajhakubhoka na kujhenda chenda jhimo na jhenge kwalobholela bhando Lilobhe lya Mbone na kwalamicha bhibhalwalwa kila chehemo. ");
INSERT INTO dne_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nkolongwa Helode jwa ku Galilaya pajhohina ilebhe yoha itendika, ajhakubhehe na kiholo nhwalo bhando bhange bhalongila, “Yohane Mbatichajhe ayokite!” ");
INSERT INTO dne_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bhange bhalongila, Eliya apitile na bhange bhalongila jwenio ndi jhumo jwa bhalondole bha Chapanga, bhibhakibha makacho ayokite. ");
INSERT INTO dne_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nambo Helode akalongile, “Yohane nikahekite muto bho, Yohane ghane kabhele jhubhanongela?” ");
INSERT INTO dne_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Akatenga bhala pubhabhujhita, bhajhakunobholela Yecho ghoha ghubhatehile. Yecho ajhakwatola na kujhenda nabho ade ku muche gwa ku Betisaida bhabhii kanjika chabhe. ");
INSERT INTO dne_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Peniya lilongo lya bhando pulimanyita kwajhingilile Yecho, bhajhakunkengama. Yecho ajhakwapokela na kulonge nabho ilebhe ya Unahota gwa Chapanga, na helahela kwalamicha bhubhalwalita. ");
INSERT INTO dne_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lyobha pulitumbwila kutipika, akatenga bhala kome na bhabhele bhajhakunnobholela Yecho, “Mwulitabhuke lilongo lya bhando leno bhajhende mu chenda ya pahina bhakapalahe yakulyegha na pakugholoka nhwalo putubhii pano tubhii panjenga.” ");
INSERT INTO dne_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nambo Yecho ajhakwalobholela, “Mangota mapelengane ilebhe yakulyegha bheniya.” Bhene ngabhajhangwila, “Tukwete mabumunda nhwano tugha na homba ibhele. Anda naha tujhende tukahemele ilebhe yakukwela kulyegha lilongo lyoha leno.” ");
INSERT INTO dne_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bhahe, bhakibha akanalome elufo nhwano. Yecho ajhakwalobholela bhabholwa bhake, “Bhatame muibhogha ya bhando makome nhwano.” ");
INSERT INTO dne_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bhabholwa bhala bhajhakutenda ngita chibhalaghalikiye, bhajhakwalobholela bhando bhoha bhatame pahe. ");
INSERT INTO dne_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Peniya Yecho ajhakutola mabumunda nhwano ghala na homba ibhele. Ajhakulola kunane kwa Chapanga ajhakunchenguu Chapanga, ajhakumetulana na kwapekeya bhabholwa bhake bhapekehe bhando bhala. ");
INSERT INTO dne_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bhando bhoha bhakalile na kujhukuta. Na bhabholwa bhakujhola mahighiliko gha chakulya yoha, ijhakutwelela ichukilo kome na ibhele. ");
INSERT INTO dne_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lichiko limo Yecho anyopita Chapanga kanjika chake, panga bhando, na bhabholwa bhake bhakibha pahina jhake, peniya ndi ajhakwakonya, “Bho, bhando bhalonge nenga na ghane?” ");
INSERT INTO dne_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bhabholwa bhala bhajhakunyangu, “Bhando bhilongela mwenga ndi mwa Yohane Mbatichajhe na bhange bhilongela mwenga ndi mwa Eliya na helahela bhando bhange bhilongela mwenga ndi jhumo jwa milondole bha makacho bha Chapanga uyokite.” ");
INSERT INTO dne_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Papalapala Yecho ajhakwakonya, “Bho, mangota mwenga mihola nenga na ghane?” Nambo Petile ngajhangwila, “Mwenga ndi Kilichitu jhuhumite kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bhahe, Yecho ajhakwapwatalila bhakotoka kunnobholela mundo jhonge malobhe gheniya. ");
INSERT INTO dne_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yecho pajhendilila kulonge, “Mwana gwa Mundo nalunkolela lung'ahe lukolongwa na kukanwa na ighogholo na Akapiya matambiko bhakolo pamonga na bhabhola bha Malaghalikilo. Nabhankoma, na machiko matato anda ghahikite peniya nayoka.” ");
INSERT INTO dne_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Peniya ajhakwalobholela bhando bhoha, “Mundo jhojhoha jwapala kubhehe na nenga, akihila hote jwenio na ilebhe yake, nambo atole nchalaba gwake angengame kila lichiko. ");
INSERT INTO dne_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nhwalo mundo jhojhoha jwapala kuukombola ughome gwake nahuobhecha, nambo jwahuobhecha ughome kwa nhwalo gwa Yecho, naghombokoka mu ughome gwa machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nakitangatila nike mundo kupata ilebhe mbwe ya pannema pano, kongo ahuobhiche ughome gwake? ");
INSERT INTO dne_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mundo jhojhoha jwangolela hone nenga na mabholo ghango, helahela Mwana gwa Mundo, nakolela hone mundo jwenio machiko pughapala kuhika mu ung'alicho gwake na ung'alicho gwa Tate na gwa akatumiche bha kunane kwa Chapanga bhanyahinyahi. ");
INSERT INTO dne_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nambo ninnobholela chakaka, bhabhii bhando bhange pambano pano nabhawejhe kabula jha kubhona Unahota nkolongwa gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ghakapetite machiko nane Yecho palongela gheniya, ndi ajhakwatola Petile na Yohane na Yakobu kujhenda ku itombe kunyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pakibha anyopita Chapanga, kumiho kwake kujhakughalambuka, na ngobho ijhakubhehe unho ya mbumbumbu na kung'anyima ng'anyima ngita lumule lwa mbamba. ");
INSERT INTO dne_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Papalapala bhando bhabhele bhabhonikina akalongela nabho, bhakibha Mucha na Eliya. ");
INSERT INTO dne_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bhene bhabhonikina bhabhii na ukolo gwa Chapanga, ndi bhalonginako Yecho chela chikipala kujhomolela lihengo lyake ngita chapala Chapanga, kwa jwenio kuwegha kukupala kutendeka ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petile na bhajhake bhukakibha mulughono tipitipi, pibhang'ang'anwika bhakauwene ung'alicho gwa Yecho, na bhando bhala bhabhele bhakajhemite nabho. ");
INSERT INTO dne_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bhahe, Mucha na Eliya pubhabhokita, Petile ajhakunobholela Yecho, “Bhambo, nibhona pambano pambone hake kutama twenga! Mbaha tuchenge ichimba itato, chimo chino, chimo cha Mucha na chimo cha Eliya.” Nambo Petile akamanyite ndeka chalongila. ");
INSERT INTO dne_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petile pajhendilila kulonge gheniya, papa lihunde lijhakwayekelela, na lihunde lyenio palibhaheghelila bhabholwa bhala, na bhene bhajhakujhoghopa hake. ");
INSERT INTO dne_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Peniya lilobhe kuhumii kulihunde lela, “Jhonjo ndi Mwanango jhunihagwile, munyokanikiya jwenio.” ");
INSERT INTO dne_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lilobhe lela pulikotwika kulonge, Yecho abhonikina kanjika chake. Bhabholwa bhake bhakaliyalite lilobhe lyenio kumwojho gwabhe changannobholela mundo jhonge ghoha ghughatendika kwenio. ");
INSERT INTO dne_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kilabho jhake, Yecho pamonga na bhabholwa bhake bhatato bhala pubhahelila kuhumii ku katombe kola, bhakakonganike na lilongo lya bhando. ");
INSERT INTO dne_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Peniya akibha mundo jhumo kuhumii palilongo lela alalima na kulonge, “Mmola, chonde uningukiye mwanango! ");
INSERT INTO dne_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Machiko gwamahele uchikilwa na kuntenda alalame, kugwiya pahe na kuntenda kihinduhindu na lihulohulo upita munnomo, na ujhendelela kung'ahicha ade akochokane. ");
INSERT INTO dne_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nambo nakajhopite bhabholwa bhino bhahibhohe michuka jhene, nambo bhakahotwi ndeka.” ");
INSERT INTO dne_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yecho pajhangwila, “Mangota kibheleko changabhehe na kihobholelo, nandama na mangota mwenga nanihimbilila ade ligha? Ndi ajhakunnobholela mundo jhola, munete mwana gwino pambano.” ");
INSERT INTO dne_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Papalapala mwana jhola panheghelila Yecho, nchuka ghola ujhakugwiya pahe na kuntenda kihinduhindu. Nambo Yecho ajhakuhupwatalila na kuhubhenga nchuka na kunamicha mwana jhola, na kukamuya kwa tate mundo. ");
INSERT INTO dne_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bhando bhoha bhakakangiche hake uhotolo nkolongwa gwa Chapanga. Bhando bhala pubhajhendilila kukangacha ilebhe itendike, Yecho ajhakwalobholela bhabholwa bhake, ");
INSERT INTO dne_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Unyokanikiye mbone malobhe ghinipala kunnobholela ghano, Mwana gwa Mundo natendwa kujhambilwa na kubhekwa mu mabhoko gha bhando.” ");
INSERT INTO dne_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nambo bhabholwa bhake bhakamanyite ndeka chela chabhalongolila. Lilobhe lyenio likatei kuhihywa bhakoto kumanya, bhene bhajhakunyoghopa kunkonya Yecho panane jha lyenio. ");
INSERT INTO dne_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Peniya bhabholwa bhake bhajhakutumbula kutaungana bhene chika, ghane nkolongwa pakate jhabhe. ");
INSERT INTO dne_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nambo Yecho akamanyite chibhahola kumwojho gwabhe. Ndi ajhakuntola mwana nchokombe ko, ajhakummeka pahina jhabhe, ");
INSERT INTO dne_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na peniya kwalobholela, “Mundo jwampokela mwana nchokombe ngita jhonjo kwa liina lyango, jwenio ambokii nenga, na jhojhoha jwambokii nenga, apokile jwandumita, anda mundo nchokombe abhii pakate jhino, jwenio ndi nkolongwa.” ");
INSERT INTO dne_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohane ajhakujhangila kulonge, “Bhambo, tunkolile mundo abhenga michuka kwa liina lino na twenga tujhakunkelebhuya nhwalo jwenio abhii jhe pamonga na twenga.” ");
INSERT INTO dne_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yecho ajhakwalobholela, “Nkotoka kuhibhilikiya, nhwalo mundo jhojhoha jwangatukana abhii pamonga na twenga.” ");
INSERT INTO dne_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Machiko gha Yecho gha kutolwa kujhenda kunane kwa Chapanga pughabhandikila, Yecho ajhakughagha hake kujhenda ku Yeluchalemo, ");
INSERT INTO dne_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","bhahe, ajhakwatuma bhando bhanongolele, bhene bhajhakujhenda na kujhingila pachenda jhimo jha ku Samaliya, bhakalenganikiye kila kilebhe kibhehe telatela. ");
INSERT INTO dne_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bhahe, akolo chenda bha peniya, bhakapahii jhe kunpokela Yecho nhwalo bhakamanyite Yecho ajhenda ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nambo bhabholwa bhake, Yakobu na Yohane pubhalolita gheniya, bhajhakunobholela, “Bhambo, bho, mipala tulaghalikihe mwotu kuhumii kunane kwa Chapanga gwakomelekeye?” ");
INSERT INTO dne_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Papalapala Yecho ajhakwaghalambukila, na kwapwatalila, ");
INSERT INTO dne_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","peniya Yecho na bhabholwa bhake bhajhakubhoka na kutyangila chenda jhenge. ");
INSERT INTO dne_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pubhatyangita undela, mundo jhumo ajhakunnobholela Yecho, “Naninkengama mwenga kokoha kola kumijhenda.” ");
INSERT INTO dne_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yecho panyangwila, “Mabweya ghabhii na mikwembe jhabhe na ijhune ibhii na mihuhe jhabhe, nambo Mwana gwa Mundo akwete ndeka pakujhebhelekeya lubhaho lwake.” ");
INSERT INTO dne_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nambo Yecho ajhakunnobholela mundo jhonge, “Ungengame.” Na mundo jhola ajhakujhanguu, “Bhambo, uneke nyende hote kajha, nikachike tate gwango.” ");
INSERT INTO dne_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yecho ajhakunnobholela, “Mwaleke bhubhawile bhachikane bhene chika, mwenga nnyende mukatangache Unahota nkolongwa gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Papalapala mundo jhonge helahela ajhakulonge, “Bhambo, naninkengama, nambo nyenda hote kajha kwatabhuka akalongo bhango.” ");
INSERT INTO dne_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nambo Yecho panyangwila, “Mundo jhojhoha jwakamula lighela kulema, kongo ighalambuka na kulola kuhyeto, jwenio chatangatila kibhiijhe mu Unahota nkolongwa gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pighajhomwikila gheniya, Bhambo Yecho ajhakwahaghula bhabholwa bhange makome chaba na bhabhele, ajhakwatuma bhabhele bhabhele bhannongolele muchenda na chehemo yapala kujhenda. ");
INSERT INTO dne_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ajhakwalobholela, mahuno ghamahena, nambo bhakuhuna bhandina, munyope nkolo nng'onda antume akahenga lihengo bhakahune munng'onda gwake. ");
INSERT INTO dne_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ngoheno nnyendengane! Nitumangana mangota ngita mambelele pakate jha limehe. ");
INSERT INTO dne_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nkotoka kubhehe na lilombolo lya mbijha hilu lihako hilu maghubache na undela nkotoka kunyambucha mundo jhojhoha jhola. ");
INSERT INTO dne_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Na nyumba jhojhoha jhipala kujhingila, ntumbula hote kwajhambucha, ‘Uteeke ubhehe pa nyumba jhenjeno.’ ");
INSERT INTO dne_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Anda abhii mundo mwenio jwapala uteeke, peniya nautama na jwenio, anda mundo jwenio apala jhe uteeke, na uteeke gwino utame nako. ");
INSERT INTO dne_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ntamangane panyumba jhejhe, mukinywagha na kulyegha chibhampela, nhwalo jwahenga lihengo atope malepo ghake. Nkotoka kubheka mahame kubhoka nyumba jhimo na jhenge. ");
INSERT INTO dne_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nambo muche ghumipala kuhikila na bhando bhake bhapokile, nnyakila ibhanenganikiye. ");
INSERT INTO dne_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mwalamiche bhibhalwalwa bhibhabhii kwenio na kwalobholela bhando, ‘Unahota nkolongwa gwa Chapanga ubhandikile kwino.’ ");
INSERT INTO dne_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nambo pujhingila pa muche ghoghoha ghola na bhando bhampoki ndeka, mumokengane, na uhike pandela nnongela, ");
INSERT INTO dne_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Hilu lutukunda lwa pa muche gwino lulung'ang'anile mumakongono ghito, tupyatila mabhene. Nambo umanyengane, Unahota nkolongwa gwa Chapanga nheghelile!’ ");
INSERT INTO dne_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ninnobholela chakaka, lichiko lya luhadabulo lwa Chapanga bhando kwa bha muche gwa ku Sodoma nahijhojhoka kutama mumalagho gheniya! ");
INSERT INTO dne_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Nanola choto mwa Kolachine! Nanola choto mwenga mwa Betichaida! Nhwalo ikangacho itendika kwino, ngahitendika ku Tilo na ku Sidone, kuhumii makacho bhando bhake ngabhatumbwile kuwala ngobho ya majafafa na kutama paliho kulangiya bhamujhii Chapanga! ");
INSERT INTO dne_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mulichiko lya luhadabulo lwa Chapanga mangota bhando bhu ku Tilo na ku Sidone nabhalongela itopela kubhehe lilagho lende. ");
INSERT INTO dne_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mwenga, ma Kapelenaumo! Bho, namukikweya ade kunane kwa Chapanga? Oko naha ndeka, nabhahuluha ade ku kilambo cha bhando bhubhawile!” ");
INSERT INTO dne_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yecho ajhakwalobholela, “Mundo jwenio jwanyokanikiya mangota, anyokanikiya na nenga na mundo jhojhoha jwakana kumpokela mangota, jwenio angana kumbokela nenga. Na jhojhoha jwangana kumbokela nenga, ankana kumpokela jhola jwandumita.” ");
INSERT INTO dne_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bhabholwa bhala makome chaba na bhabhele pubhabhujhita kwa kuhanganila, bhalongila, “Bhambo,” michuka na jhene ghajhokanikiye lilaghilo lito kwa liina lino! ");
INSERT INTO dne_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nambo Yecho ajhakwalobholela, “Nikamwene Limbembela pagwila kuhumii kunane kwa Chapanga ngita lumule lwa mbamba. ");
INSERT INTO dne_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chakaka! Nipelangana ukindendeke gwa kuntimba lijhoka na kipyelele, ukindendeke gwa makakala ghoha gha likoko kibhii jhe kilebhe chakumengwa. ");
INSERT INTO dne_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nambo nkotoka kuhanganila nhwalo michuka inyokanikiye, ndi uhekelele nhwalo mahina gwino ghajhandikwe kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Machiko ghagha, Yecho atwelile kiheko kwa ndela jha Uhuke gwa Chapanga, ajhakutumbula kulonge, “Nichengula mwe mwa Tate, Bhambo jwa kunane kwa Chapanga na pannema, kwa nhwalo mwahihite bhubhabhii na malango na bhando bhubhachomite malobhe ghanga, na kwayekulila yana ichokombe. Chakaka Bhambo, Tate naha ndi chipalita!” ");
INSERT INTO dne_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ajhakujhendelela kulonge, “Tate gwango ambekihe ilebhe yoha. Abhii ndeka jwaumanya Mwana nga Tate mundo, na abhii jhe jwaumanya Tate mundo nga Mwana na jhojhoha jwampahile mwana uyekulila.” ");
INSERT INTO dne_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Peniya ajhakwaghalambukila bhabholwa bhake, ajhakulonge nabho pakiyepela, “Chapanga abhapekiye mota bhando bhibhalola ilebhe imulola mangota! ");
INSERT INTO dne_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ninnobholela chakaka, bhalondole bha Chapanga twe na akanahota bhakaghanite kulola gheniya ghumulola, bhalepelile, na kughajhokanikiya malobhe gheniya, bhene bhakajhohine ndeka.” ");
INSERT INTO dne_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jhumo jwa bhabhola bha malaghalikilo, ajhakuhika kwa Yecho, na kunkonya kwa kunyighanikiya, “Mmola, ndende nike mme na ughome gwa machiko ghoha ghangapeta?” ");
INSERT INTO dne_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nambo Yecho panyangwila, “Kijhandikwe nike mulilaghalikilo la Mucha, mwiimanye bhole?” ");
INSERT INTO dne_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mundo jhola ajhakunyangula Yecho, “Mupale Bhambo Chapanga jwino kwa mwojho gwi ghoha na kwa ughome gwii ghoha na kwa makakala ghii ghoha na kwa malango ghii ghoha. Na mupale nnyino ngita chimukipala mabhene.” ");
INSERT INTO dne_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yecho ajhakunnobholela, “Unyangwi mbone! Ntende gheniya na mwenga namma na ughome.” ");
INSERT INTO dne_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nambo mundo jhola jwamanya malaghalikilo apata kukilangiya jwambone, ndi ajhakunkonya Yecho, “Na, nnyango jwenio ndi ghane?” ");
INSERT INTO dne_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yecho ajhakunyangula, “Akibha mundo jhumo jwahumita ku Yeluchalemo na kujhenda ku Yeliko, undela ajhakukongana nako bhando bhibhipoka ilebhe kwa makakala. Na bhajhakunhombela na kunkong'onda, na kunhula ngobho na kunpoka ilebhe yake, ndi bhajhakunneka papa kongo abhii tolatola. ");
INSERT INTO dne_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Paligha mupiya litambiko jhumo ajhakupeta ndela jhejhe, pamonita mundo jhola agholwike, ajhakumambala na kujhenda. ");
INSERT INTO dne_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Helahela ajhakupeta mundo jhonge, Nnabhe paheghelila penepa ajhakumwona, na jwenio ajhakubhambala na kujhenda, ");
INSERT INTO dne_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","nambo Nsamaliya jhumo jwakibha atyangita mwanja gwake, jwapetita ndela jhejhe, pamonita mundo jhola, ajhakummonela kiya. ");
INSERT INTO dne_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ajhakuheghelela, ajhakugholola ilonda yake kwa kumpakala mahuta na divaye na kuinyembelela maha. Peniya ajhakunkwelekeya mu liponda lyake na kujhenda nako ade ku nyumba jha kugholoka akaghene, na kunwaha. ");
INSERT INTO dne_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lukela jhake, Nchamaliya jhola ajhakupiya mbijha na kunnekela jwajhemelela nyumba jha akaghene, na kunnobholela, ‘Munwahe mundo jhonjo ade pumbala kubhujha mbeta kulepa lighambo lilipala kujhonjekeka.’ ” ");
INSERT INTO dne_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yecho ajhakunkonya, “Bho, kwa bhoha bhatato abha, ndi ghane pumihola jwabhii nnyake kwa mundo jhola jhubhankong'indwe?” ");
INSERT INTO dne_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jwamanya lilaghalikilo ajhakujhanguu, ndi jhola jwamonile kiya. Yecho ajhakunobholela, “Nnyende mukahenge hele naha.” ");
INSERT INTO dne_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yecho na bhabholwa bhake pubhatehila kutyanga, bhajhakuhika pa chenda jhimo, peniya mwikeghe jhumo liina lyake Macha, ajhakumpokela kajhake. ");
INSERT INTO dne_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Macha jhola, akibha na nnombo mundo liina lyake Maliya, na Maliya akatamite pahina jha Bhambo Yecho na kujhokanikiya malobhe ghake. ");
INSERT INTO dne_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Nambo Macha akakalikina kanjika mahengo twe. Ndi ajhakunyendelela Yecho, na kunnobholela, “Bhambo, mumona nnombo gwango aneki mahengo ghoha kanjika chango? Ngoheno munnobholele ahike andangatile.” ");
INSERT INTO dne_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bhambo ajhakujhanguu, “Macha, Macha! Mwenga nkotoka kuking'aha na ilebhe yamahele. ");
INSERT INTO dne_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nambo chikipalwa kilebhe chimo tugha. Maliya ahagwi kilebhe chambone na abhii jhe mundo jwakupoka.” ");
INSERT INTO dne_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lichiko limo Yecho akibha pakiyepela anyopita Chapanga. Pajhomolila kujhopa, mmolwa gwake jhumo ajhakunnobholela, “Bhambo, mutubhole na twenga kunnyopa Chapanga ngita Yohane chabholita bhabholwa bhake.” ");
INSERT INTO dne_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yecho ajhakwalobholela, “Piminnyopa Chapanga, nnongila naha, ‘Tate gwito! Liina lino lya ukolo litembekelwe, Unahota nkolongwa gwino uhike. ");
INSERT INTO dne_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mutupele chakulyegha chito cha kila lichiko. ");
INSERT INTO dne_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mutulekekeye uhakaho gwito, ngita twenga chitwalekekeya bhibhatulemwiye. Nkotoka kutujhingiya mu majhighanikilo.’ ” ");
INSERT INTO dne_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Peniya Yecho ajhakwalobholela bhabholwa bhake, “Kwa nnandanikiho, pakate jhino jwajhenda ku nyumba jha nkoche mundo, uhiko gwa kilo na kunnobholela, ‘Makalongo bhango, chonde unyahike ipande ya mabumunda itato, ");
INSERT INTO dne_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","nhwalo nkoche gwango abhetukile pakajha kuhumii ku mwanja gwake na nenga ngwete jhe kilebhe chakunabhuya.’ ");
INSERT INTO dne_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nkoche gwino jwabhii nkate jhola nganyangwii, ‘Chonde ungotoka kung'aha! Nindite nnyango gwango. Nenga na yana yango tugholwike nijhimuka ndeka kumpekeya kilebhe chochoha chela!’ ");
INSERT INTO dne_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ninnobholela chakaka, nikitopotola ndeka kujhimuka kumpela chakulyegha nhwalo mwenga mwakoche bhake, nambo paligha najhimuka na kumpela kilebhe chinyopita kwa nhwalo mukibha jhe na hone jha kujhendelela kunnyopa.” ");
INSERT INTO dne_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ninnobholela, nnyope na mangota napelwa, mupalahe mipata, nkong'onde litangala na mangota nadindulilwa. ");
INSERT INTO dne_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nhwalo gwenio mundo jhojhoha jwajhopa upelwa, na mundo jhojhoha jwapalaha napata, na mundo jhojhoha jwakong'onda litangala nadindulilwa. ");
INSERT INTO dne_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tate ghane pakate jhino jwampekeya mwana mundo lijhoka kone anyopite luhomba? ");
INSERT INTO dne_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Bho, anda anyopite lihombe, ma tate mundo namupela kipyelele? ");
INSERT INTO dne_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pamonga na kukokotoka kwino mangota, mimanya kwapela yana hino yambone, chakaka Tate gwino jwa kunane kwa Chapanga natenda kuchocha kwa peniya, bho, Tate gwino jwa kunane napelangana ndeka Uhuke gwa Chapanga kwa bhoha bhibhannyopa?” ");
INSERT INTO dne_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lichiko limo Yecho pabhengita nchuka jhughuntenda mundo jhumo jwateile abhehe jwangalongela. Bhahe, nchuka ghola puchomwika, mundo jhola pahotwila kulonge, dola lilongo lya bhando lijhakuhechuka hake. ");
INSERT INTO dne_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nambo bhando bhange bhalongila, “Jwenio atenda naha kwa likakala lya Belezebule, nkolongwa jwa michuka.” ");
INSERT INTO dne_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bhando bhange bhapata bhanyighe Yecho, bhajhakunyopa abhalangiye nginyililo anda likakala lihumii kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bhahe, Yecho akamanyite chibhahola, ajhakwalobholela, “Unahota nkolongwa ghoghoha ghola anda upechengine gwenie kwa gwenie na kubhehe ibhogha ibhogha gwihoto ndeka kujhema, na bhando bha nyumba jhimo anda bhapechengine nabhakikomelekeya.” ");
INSERT INTO dne_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Limbembela anda libhii na ibhogha ibhogha ikomana yenio kwa yenio, Unahota gwake nahujhema bho? Ninnobholela naha nhwalo mangota mwinnobholela nenga nibhenga michuka kwa likakala lya Belezebule. ");
INSERT INTO dne_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Anda nenga nibhenga nchuka kwa likakala lya Belezebule, bho, bhabholwa bhino bhabhenga kwa uhotolo gwa ghane? Bhando bhino mabhene nabhahadabula mangota. ");
INSERT INTO dne_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nambo anda nibhenga nchuka kwa likakala lya Chapanga, ngohe Unahota nkolongwa gwa Chapanga uhikite kwino. ");
INSERT INTO dne_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mundo jwabhii na likakala, pailonda nyumba jhake kwa nkoha, ilebhe yake yoha ibhehe teeke. ");
INSERT INTO dne_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nambo mundo jhonge jhuna likakala kupeta jwenio nahotola kuntyala, na kumpoka chilaha yake yaihobholela na kupechengana ilebhe yampokite.” ");
INSERT INTO dne_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Mundo jhojhoha jwangalongohana na nenga, jwenio angana nenga, mundo jhojhoha jhola jwangalundika pamonga na nenga, atenda kupechengana.” ");
INSERT INTO dne_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nchuka anda abhengitwe kwa mundo, ityangatyanga kunjenga kujhomo ipalaha pa kupomolela anda apakolihi jhe. ");
INSERT INTO dne_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mikilobholela, ‘Nangelebhuka kajha jhango kuhumila.’ Nambo piibhujha na kukolela ndopo, ipyaghilwe na kukilimwa mbone, ");
INSERT INTO dne_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","peniya, ujhenda kwatola michuka bhange chaba, bhina likakala kupeta jwenio. Na bhene uhika na kutama na mundo jwenio. Na ughome gwa mundo jwenio ubhehe jwanganandela hake kuliku chakibha makacho.” ");
INSERT INTO dne_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yecho palongila naha, mwikeghe jhumo kuhumii pakate jha lilongo lya bhando lela, ajhakunonoha lilobhe kwa Yecho, “Ahanganilwe mwikeghe jwampapite na jwanyongiche!” ");
INSERT INTO dne_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nambo Yecho ajhakujhanguu, “Bhahanganilwe bhoha bhibhajhoha lilobhe lya Chapanga na kulikamula!” ");
INSERT INTO dne_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Lilongo lya bhando pulijhonjikika, Yecho pajhendelila kulongolela, “Kibheleko eche ndi kikokotwike, kipala nginyililo. Nambo nakipelwa ndeka nginyililo jhojhoha kupeta jhela jha Yona. ");
INSERT INTO dne_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nhwalo Yona akibha nginyililo kwa bhando bhu ku Ninabhe, na helahela Mwana gwa Mundo nabhaha nginyililo kwa kibheleko chenje. ");
INSERT INTO dne_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kwa lichiko lya kilongoche mwikeghe, jwahumile ku Cheba, najhema na kwahadabula bhando bha kibheleko chenje bhalemwite, nhwalo jwenio ahumila kutale na kujhenda kujhokanikiya malobhe gha malango gha nkolongwa Selemane, na pamba abhii munahota nkolongwa kupeta Chelemane. ");
INSERT INTO dne_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bhando bha ku Ninabhe nabhajhema mulichiko lya luhadabulo, na bhene nabhalongela kibheleko chenje kibhii na ulemwa. Nhwalo bhando bha ku Ninabhe bhakaulekite uhakaho pubhajhohina ghighatangichwa na Yona, na kubhehe peniya abhii nkolongwa kupeta Yona!” ");
INSERT INTO dne_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Abhii jhe mundo jwapamba kolobohi na kuhiya hilu kugubikila kibhegha. Nambo kolobohi anda ipambwitwe ubheka panane jha kinala, bhando pubhajhingii nkate bhalola mbone. ");
INSERT INTO dne_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Liho lino ndi kolobohi jha yegha jhino. Anda liho lino lyambone, yegha jhino jhibhii mululanga. Nambo liho lino anda litochwike, helahela yegha jhino jhoha ibhii mulubhendo. ");
INSERT INTO dne_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chakaka mukilolekeye mbone, kolobohi ibhii nkate jhino ikotoka kubhehe mulubhendo. ");
INSERT INTO dne_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Peniya ndi, anda yegha jhino jhoha ibhii mululanga, na lubhii jhe lubhendo, yegha jhoha naing'anyima ngita pulumulikila mabhene lumule lwake.” ");
INSERT INTO dne_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yecho pajhomolila kulonge gheniya, Pwalichayo jhumo ajhakunnalika Yecho ajhende kajhake akalye. Ndi Yecho ajhakujhingii nkate, na kutama pahe kulyegha. ");
INSERT INTO dne_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pwalichayo jhola ajhakukangacha hake, pamonita Yecho ilyegha changakuha mache. ");
INSERT INTO dne_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Peniya Bhambo ajhakunnobholela, “Mangota maka Mapwalichayo, mijhoha kibaba na libechene kwa panja, nambo kwa nkate mwino mutwelii lukwatulo na ukokotoko. ");
INSERT INTO dne_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mangota mwenga kupumbumuka! Bho, jwabhombite ilebhe kwa panja jhojho ndeka jwabhombite na nkate? ");
INSERT INTO dne_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nambo mwapekiye akahocho ilebhe ya nkate jha miojho, na henge yoha naibhaha yambone kwino palonge jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nanola choto mangota Mapwalichayo! Kongo majhopa bhando chaka jha ndimbilo na mandebhele na mahamba ghange gha makolo. Nambo muleka kwatendela bhando ghambone palonge jha Chapanga. Ntumbula kubhehe bhambone changaleka na ghange. ");
INSERT INTO dne_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nanola choto mangota maka Mapwalichayo! Nhwalo mipala kutama mighoda ya palonge munyumba jha kukonganikii Akayahude na kujhambuchwa na bhando kwa makilikite pa maghuliho. ");
INSERT INTO dne_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nanola choto mangota, kwa nhwalo muwanana na mambe ihitwe, na bhando bhatyanga panane jhake changamanya.” ");
INSERT INTO dne_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mubhola jhumo jwa Malaghalikilo ajhakunnobholela, “Mmola, pumulongela naha helahela mutuligha na twenga.” ");
INSERT INTO dne_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yecho ajhakunyangula, “Helahela bhabhola bha Malaghalikilo nanola choto! Nhwalo mwagheghecha bhando mihigho mitopaho, na kone ighegheka ndeka. Mabhene mihoto ndeka kujhinula kwa lukonje lumo kwatangatila. ");
INSERT INTO dne_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nanola choto mangota! Muchenga mambe ya milondole bha Chapanga, bhibhakomitwe na akahoko bhino. ");
INSERT INTO dne_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nambo mabhene mighawene na kujheketela mahengo ghubhatehila akatate bhino, bhene bhakomite milondole bha Chapanga, na mangota michengelela mambe yabhe. ");
INSERT INTO dne_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nhwalo malango gha Chapanga ghilongela naha, ‘Nanatuma kwino milondole na akatenga, bhange nabhakomwa na bhange nabhabha mu lung'ahe.’ ");
INSERT INTO dne_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndi tela na bhando bha kibheleko chenje, nabhabha mulung'ahe kwa nhwalo gwa miyahe jha milondole bhoha jhijhitike kuhumii mu kupanganwa kwa nnema, ");
INSERT INTO dne_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","na kutumbulila pakomitwe Abele ade Zakaliya, jwakakomitwe pakate jha kachangwale na chehemo jha nyahinyahi. Chakaka, ninobholela, kibheleko chenje naking'ahichwa nhwalo gwa kukoma! ");
INSERT INTO dne_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Nanola choto mangota akabhola bha Malaghalikilo! Kwa nhwalo muhuhite upungulo gwa litangala lya kukibholela. Mangota mabhene mujhingii ndeka, na mahibhilikiye bhando bhibhapala kujhingila!” ");
INSERT INTO dne_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yecho pabhokita kwenio, Mapwalichayo na bhabhola bha Malaghalikilo bhala bhajhakutumbula kuchobhelela na kunkonya machwale ghamahele, ");
INSERT INTO dne_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bhanyonje kwa kilebhe chochoha chalongela. ");
INSERT INTO dne_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lilongo lya bhando tyee lyangabhalangika, lijhakukonganika na kutumbula kulebhatana, Yecho ajhakwalobholela hote bhabholwa bhake, “Mukilolekehe na ngedule jha Mapwalichayo, kwenio ndi kulyambingana kwabhe. ");
INSERT INTO dne_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kila kilebhe chikighubikwe chenie nakiyekulilwa, na chochoha chikihihitwe hote nakibhaha mbegha pakalamuhe. ");
INSERT INTO dne_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ghala ghumpwepwita palubhendo, nabhaghajhoha pakalamuhe na ghala ghumpwepita nkate, naghamanyikana panane jha kipaghalo.” ");
INSERT INTO dne_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ninnobholela mangota akakoche bhango, nkotoka kunyoghopa jhola jwakoma yegha, kone anda ajhomwili ahoto ndeka kujhonjekeya kuhenga chenge changanandela. ");
INSERT INTO dne_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nambo naninangiya ghane jwakunyoghopa. Munyoghope jhola anda ajhomolile kunkoma, ihoto kuntaghila yaka yoha kumwotu gwangahimika gwa machiko ghoha. Ninnobholela, jwenio ndi jwakunyoghopa!” ");
INSERT INTO dne_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Umanyite jhe kubhehe iyebhelele nhwano uchuluchwa kwa chenti jhimo jhandina? Nambo palonge jha Chapanga abhii jhe hilu kiyebhelele chimo nakilibhilila. ");
INSERT INTO dne_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nambo majhunjo gha umuto gwino gwabhalwingwe. Nkotoka kujhoghopa, mangota ntopii hake kupeta iyebhelele twe!” ");
INSERT INTO dne_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ninnobholela chakaka, mundo jhojhoha jwanyeketela nenga palonge jha bhando, Mwana gwa Mundo helahela nanyeketela palonge jha ntumiche jwa kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nambo mundo jhojhoha jhola jwangana palonge jha bhando, na Mwana gwa Mundo nakanila palonge jha akatumiche bha kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mundo jhojhoha jhola jwanongela lilobhe lyangamanyika kwa Mwana gwa Mundo, jwenio nalekekewa, nambo mundo jhojhoha jwauligha Uhuke gwa Chapanga, jwenio nalekekewa ng'o. ");
INSERT INTO dne_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pubhapala kunpeleka mangota palonge jha nyumba jha kukonganikii Akayahude na palonge jha ilongoche bhina kindendeke, nkotoka kubhehe na iholo namukikengelela bhole. ");
INSERT INTO dne_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nhwalo kwa lichaa lyenio Uhuke gwa Chapanga nahumola chakulonge.” ");
INSERT INTO dne_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mundo jhumo kuhumii mulilongo lya bhando lela ajhakunnobholela Yecho, “Mmola, munnobholele unung'una gwango tubhaghane ilebhe yatulekile tate gwito.” ");
INSERT INTO dne_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yecho ajhakunyangula, “Makoche bhango, bho, ghane jwamekite nenga maghaniche ilebhe hino?” ");
INSERT INTO dne_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yecho ajhakujhendelela kwalongolela bhoha, “Mukilolekehe na uloho gwa kupala ilebhe! Nhwalo ughome gwa mundo ubhii ndeka milebhe yabhii nako.” ");
INSERT INTO dne_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","“Peniya Yecho ajhakwalobholela nnandanikiho ghongo, akibha mundo jhumo jwakibha na ilebhe mbwe, jhuna nghonda ghubholile upiya mahuno ghamahele. ");
INSERT INTO dne_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jwenio ajhakuwacha kumwojho gwake, ‘Ngohe nandenda nike na kongo pwache jha kubheke mahuno ghango ibhii jhe?’ ");
INSERT INTO dne_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Peniya ajhakulonge, ‘Ndi nandenda naha, nandilulana kikoko chango na kuchenga chenge kikolongwa. Na mwenio naghakwela mahuno ghango ghoha na ilebhe henge.’ ");
INSERT INTO dne_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Papa nanikilongolela namwete, ‘Mwe mwojho gwango! Ngwete ilebhe yamahele yakukwela kwa yaka yoha! Mpomolele unomenekehe hote, na kunywelekeya na kuhanganila.’ ” ");
INSERT INTO dne_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nambo Chapanga ajhakunnobholela, “Mwenga kupumbumuka kwenio! Na deleno uhiko ughome gwino upalwa, na malundiko ghoha gha mota hino nabhujhila ghane?” ");
INSERT INTO dne_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yecho ajhakujhomolela kwa kulonge, “Chenie ndi nakipitila kwa mundo jhola jwakibhekii malundiko gha ilebhe yake jwenio, nambo palonge jha Chapanga mibhalangika kilebhe nacho.” ");
INSERT INTO dne_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Peniya Yecho ajhakwalobholela bhabholwa bhake, “Nkotoka kubhehe na kiholo natulya nike kwa chimukighana nname, hilu ngobho imuhighana ya kuwala payegha jhino. ");
INSERT INTO dne_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Nhwalo ughome gwitopela kupeta yakulyegha, na yegha jhitopela kupeta ngobho. ");
INSERT INTO dne_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nambo dolekeya likongolo, bhimicha ndeka hilu kuhuna amu bhakwete jhe kikoko. Nambo Chapanga ahipela yakulyegha, na mangota mitopela kupeta ijhune! ");
INSERT INTO dne_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Bho, ghane pakate jhino kwa kuking'aha jwahoto kukijhonjekeya hilu lichaa limo la ughome gwake? ");
INSERT INTO dne_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Anda chepa kuhenga kilebhe kichokombe ngita chenie, nhwalo gwa nike muking'aha na ilebhe henge? ");
INSERT INTO dne_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mughalolekehe malobha gha mughonda chighatundula, ghihenga ndeka lihengo lya kukilokila hilu ngobho. Nambo ninobholela chakaka, Solemane jwenio na ilebhe yake yoha akapatite jhe kuhwalichwa mbone ngita lilobha limo. ");
INSERT INTO dne_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bhahe, anda Chapanga ulihwalicha naha lihamba lya mughonda, deleno libhii na kilabho jhake ulitagha pa mwotu, bho, mangota mwenga natendela ndeka kuchocha kwa pamba? Bho, mabhando bhumii na kihobholelo chandina! ");
INSERT INTO dne_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Bhahe nkotoka kung'ahikila ku mwojho gwino, chakulyegha hilu kunywegha. Nkotoka kujhoghopa panane jha gheniya. ");
INSERT INTO dne_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bhando bhangaumanya Chapanga ndi bhibhang'ahikila ilebhe yenio yoha. Na Tate gwino jwa kunane kwa Chapanga aimanya ilebhe imuipala. ");
INSERT INTO dne_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nambo mupalahe hote Unahota nkolongwa gwa Chapanga, na gheniya ghange napelwa. ");
INSERT INTO dne_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nkotoka kujhoghopa mangota lilongo lyandina, Tate gwino jwa kunane kwa Chapanga ahanganile kumpekeya Unahota nkolongwa gwake. ");
INSERT INTO dne_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nchuluchangane ilebhe hino na mbijha mapekehe akahocho. Mukilenganikiye mahako gha mbijha ghangatukutuka, na kukibhekela kihukilo chino kunane kwa Chapanga kwenio nakijhomoke jhe. Kwenioko lukwatulo lubhii ndeka, hilu umeya uhoto jhe kuhotolana. ");
INSERT INTO dne_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nambo pala pukibhii kihukilo chino, ndi pupala kubhehe mwojho gwino.” ");
INSERT INTO dne_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mukilenganikiye kwa kukonga luhunga mukibhuno, na kongo kolobohi jhino ipeta kujhaka, ");
INSERT INTO dne_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","mme ngita akatumiche bhibhanendelela munahota gwabhe jwahuma kunyagho gwa ndowa. Paibhujha na kukong'onda litangala tugha, papa bhadindulila. ");
INSERT INTO dne_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bhahanganile akatumiche bhala munahota gwabhe pahibhujha abhakole bhabhii miho! Ninobholela chakaka, munahota jwenio nakonga luhunga mukibhuno, nabhatamangane pabwalo na jwenio nabhatelekela. ");
INSERT INTO dne_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bhahanganile akatumiche bhala, munahota gwabhe anda abhakolile bhakilinganikiya hilu uhiko gwa kilo. ");
INSERT INTO dne_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nambo manye nhwalo ghongo, anda nkolo nyumba ngamanya lichiko lya mwihe papala kuhika, ngagholwike ndeka. Ngailekite jhe nyumba jhake ihangabhanwe. ");
INSERT INTO dne_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mangota, helahela mukilenganikiye, nhwalo Mwana gwa Mundo nahika lichaa lyanganandela.” ");
INSERT INTO dne_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petile ajhakunkonya, “Bhambo, nnandanikiho ghongo mutulongolela twe tu amu mutulongolela twabhando bhoha?” ");
INSERT INTO dne_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bhahe, Bhambo nganyangwila, “Ndi ghane jwabhii na ntumiche jwahobholeka jhuna malango jwabhekitwe na nkolo gwake kwajhemelela akatumiche bhange na kwapela chakulyegha kwa lichaa lyake? ");
INSERT INTO dne_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jhuna mota ntumiche jhola, munahota gwake paibhujha nakolela akahenga gheniya. ");
INSERT INTO dne_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ninnobholela chakaka, nkolo jwenio nameka ntumiche jhola kubhehe na ukindendeke panane jha ilebhe yake yoha. ");
INSERT INTO dne_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nambo anda ntumiche jwenio, anda akiwachile jwenio kumwojho gwake, ‘Bhambo abhii na kiyoto kubhujha,’ na atumbula kwakong'onda akatumiche bhajhango, ichongolo na ichikana, na kulye na kunywegha ade kulobhela. ");
INSERT INTO dne_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Munahota jwa ntumiche jhola nahika lichiko lyangalihobholela na lichaa lyangalimanya. Munahota jwenio naheketa ntumiche jwenio imbembela na kumeka lilundo limo na bhanga kihobholelo.” ");
INSERT INTO dne_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na ntumiche amanya ghoha ghapala munahota gwake ahenga, nambo ntumiche jwenio akilenganikii ndeka, nachwapulwa hake. ");
INSERT INTO dne_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nambo ntumiche jhola jwangamanya ilebhe yapala munahota gwake atende, na jwenio ahenga kilebhe changamanya chikipala luhadabulo, ntumiche jwenio nachwapulwa pandina. Na jhola jwapokii yamahele, na jwenio nabhujhicha yamahele. Na kwa mundo jhojhoha jwalombokilwe na jwenio helahela nabhujhicha lombilombi. ");
INSERT INTO dne_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Hikite kukokelekeya mwotu pannema pano, ndi nganoghii anda ngaujhakite kuhumii makacho! ");
INSERT INTO dne_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Minagho ubaticho gwa lung'ahe ghumbala kutendelwa, nenga nilyunga nako ade ubhaha lengalenga! ");
INSERT INTO dne_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bho, pumihambuka hikite pannema pano kuleta uteeke tugha? Naha ndeka hikite kwapechengana bhando. ");
INSERT INTO dne_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kutumbuli ngohe, bhando nhwano bha nyumba jhimo nabhapechangana, bhatato nabhang'aulana na bhabhele na bhabhele nabhang'aulana na bhatato. ");
INSERT INTO dne_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Na bhapechengana kichongolo na tate mundo, na mwana mundo napechengana na tate mundo, nchikana napechengana na majhe mundo, na majhe mundo napechengana na nchikana, nayalane mundo napechengana na kamwana mundo na mwana mundo napechengana na nayalana mundo.” ");
INSERT INTO dne_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yecho ajhakulilobholela lilongo lya bhando, “Pumpala kubhona lihunde likahembuka kulitipikila lyobha mikilongolela hula anda jhakoma, chakaka hula ikoma. ");
INSERT INTO dne_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pumipala kubhona upepo ukapogha kuhumii kuupande gwa kuchine, mulongela, ‘Deleno kupala kubhehe lihuke,’ chakaka kupitili helahela. ");
INSERT INTO dne_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mangota nginyika! Mihotola kumanya ilebhe kwa kuilolekeya nnema na mahunde chighabhile lyobha nalijhaka. Bho, mihoto ndeka kumanya ilemelo itibhii nako ngoheno? ");
INSERT INTO dne_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nhwalo gwa nike mabhene mihoto ndeka kumanya ilebhe yambone ya kuhenga? ");
INSERT INTO dne_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Anda mundo atakalile, atutuhine ade pa Bwalo jha mihalo. Mbaha undela ntende chochoha chela nnyelane nako, kabula jha kujhingila pa Bwalo jha mihalo. Anda nahajhe, jwajhokanikiya mihalo nampeleka kwa akakomana ngondo na bhene bhatabhe mukipungo. ");
INSERT INTO dne_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chakaka namoke jhe mwenio kukipungo, ade pupala kujhomolela njwe kulepa chente jha kujhomolekeya.” ");
INSERT INTO dne_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Papalapala, bhakahikite bhando kumpwepela Yecho, ilebhe ya bhando bhu ku Galilaya, bhibhakomitwe na Pilatu, pubhakibha bhampikiya Chapanga litambiko lyabhe. ");
INSERT INTO dne_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yecho ajhakwakonya, “Bho, mangota pimihambuka bhu ku Galilaya bhala bhakibha na uhakaho kupeta Akagalilaya bhange, nhwalo bhang'ahitwa naha? ");
INSERT INTO dne_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Naha ndeka ninnobholela chakaka, changaleka uhakaho, chakaka na mangota helahela nakomelekewa ngita bheniya chibhakomelekeya! ");
INSERT INTO dne_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Bho, bhando bhala kome na nane, bhibhakawile pulutengwika lukelekete lya nyumba jhikibha ku Siloamo? Bho, pimihambuka bhenabha, bhakatehi uhakaho kupeta bhando bhange bhubhatama ku Yeluchalemo? ");
INSERT INTO dne_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nahi jhe, ninnobholela chakaka, nambo na mangota changaleka uhakaho gwino, helahela na mangota nakomelekewa.” ");
INSERT INTO dne_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Peniya Yecho ajhakwalobholela nnandanikiho ghongo, “Mundo jhumo akibha na nkongo gwa nkojho mughonda gwake. Ajhakujhenda kulinga uhoe mu kongo gwenio, nambo akabhujhite mabhoko matopo. ");
INSERT INTO dne_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Papalapala ajhakunnobholela nhenga lihengo jwa munng'onda jhola, ‘Dola hote mabhene! Yaka itato ngoheno nihikahika nihukole hele changapambika uhoe nkongo ghongo, kibhiijhe chinijhambulila. Ngohe mupengule! Nhwalo ghane ujhendelele kulalicha nng'onda gwango jhajhe?’ ");
INSERT INTO dne_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nambo ntumiche jwa mughonda jhola ajhakujhanguu, ‘Bhambo, tulolele hote chaka chenje, na nenga naniukulughila na kulekelela mabule gha mbuhe twe. ");
INSERT INTO dne_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Peniya anda upambike uhoe pa chaka, naibhaha tela! Nambo nakupambikajhe, ndi mupengula.’ ” ");
INSERT INTO dne_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mulichiko limo lya Kupomolela, Yecho atehila kubhola munyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Mwenio akibha mwikeghe jhumo jwakibha na nchuka jwatehila kulwalwa kwa yaka kome na minane. Yegha jhake ijhakubhehe na chombe, ahotwila ndeka kujhinuka. ");
INSERT INTO dne_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yecho pamonita, ajhakunkema mwikeghe jwenio na kunnobholela, “Majhe, nnamite ulwalo gwino!” ");
INSERT INTO dne_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Peniya Yecho ajhakumekela mabhoko mwikeghe jwenio, na papa yegha jhake ijhakugholekeka, na ajhakutumbuu kunnumbalila Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nambo kilongoche nkolongwa jwa nyumba jha kukonganikii Akayahude, ajhakuyoma, nhwalo gwa Yecho kunamicha mwikeghe jwenio, Lichiko lya Kupomolela. Bhahe, ajhakwalobholela bhando bhibhakibha peniya, “Nkwete machiko chita gha kuhenga mahengo ghino. Uhike machiko gheniya kulamichwa ulwalo gwino, nambo nkotoka kuhika Lichiko lya Kupomolela kulamichwa!” ");
INSERT INTO dne_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bhambo ajhakujhanguu, “Mangota mwenga mukitenda bhaumbone! Bho, pakate jhino ngahotwi ndeka kudindulila ng'ombi amu liponda lyake mukibhajha na kupelika kuloche kunywe mache Lichiko lya Kupomolela? ");
INSERT INTO dne_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nchikana jhonjo ahumii mukibheleko cha Ulahimo, jwatabhitwe na Limbembela kwa yaka kome na minane. Bho, chamaha ndeka kumopola Lichiko lya Kupomolela?” ");
INSERT INTO dne_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yecho palongila gheniya, bhubhabhekita mitaho bhajhakubhehe na hone twe, nambo bhando bhange bhoha bhajhakuhanganila kwa ilebhe ya kukangacha yatendita Yecho. ");
INSERT INTO dne_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yecho ajhakukonya, “Bho, Unahota nkolongwa gwa Chapanga ubhii bhole? Bho, naniulandanikiya na kilebhe ghane? ");
INSERT INTO dne_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ulandine na mbonje njokombe ikemwa haladale yakatoi mundo jhumo na kuimicha mughonda gwake. Mbejho hela ijhakubhehe nkongo nkolongwa, na ijhune ijhakuhika na kuchenga mihuhe jhabhe pakate jha mandabhe ghake.” ");
INSERT INTO dne_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yecho ajhakukonya kabhele, “Bho, Unahota nkolongwa gwa Chapanga, niulandanikiye na kilebhe ghane? ");
INSERT INTO dne_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ulandine na ngedule yakatoii majhe jhumo na kuhangalana mukobha madoo mabhele pamonga ujhakututa.” ");
INSERT INTO dne_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Peniya Yecho pajhendilila na mwanja gwake gwa ku Yeluchalemo. Pakibha undela akabhetukile mumiche na muchenda, kongo abholita bhando. ");
INSERT INTO dne_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mundo jhumo ajhakunkonya Yecho, “Bhambo, bho, bhando bhandina ndi bhibhapala kughombokoka?” Yecho ajhakunyangula, ");
INSERT INTO dne_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nkangamala jhe kujhingii nkate kupetela nnyango nkombaho, nhwalo bhando twe nabhapala kujhingila nkate nambo nabhahotola ndeka. ");
INSERT INTO dne_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nkolo nyumba najhema na kudinda litangala. Na mangota nanyema panja na kutumbula kulikong'onda nnyango kwa kulonge, ‘Bhambo, mutudindulile litangala.’ Na jwenio najhangula, ‘Nimanyingine ndeka, hilu kumuhumila!’ ");
INSERT INTO dne_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mangota natumbula kulonge, ‘Twenga ndi bhala bhitulila na kunomenekeya pamonga na mwenga, na mwenga mutubholita hotuhotu ku muche gwito.’ ");
INSERT INTO dne_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nambo Yecho nalongela kabhele, ‘Nimanyangine ndeka mangota, hilu kumuhumangana. Mumokengane pamba, mangota mabhoha bhumuhenga ghanganandela!’ ");
INSERT INTO dne_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ndi milela na kuyagha mino, machiko gheniya namumona Ulahimo na Isaka na Yakobu na milondole bhoha bha Chapanga bhabhii mu Unahota nkolongwa gwa Chapanga, nambo mangota bhataghii panja! ");
INSERT INTO dne_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bhando nabhahika kuhumii kulihembukii lyobha na kulitipikii lyobha, pandi jha kunane na pandi jha pahe, na kutama pa unyagho gwa kulyegha pamonga mu Unahota nkolongwa gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Peniya bhando bhibhabhii bha kujhomolela nabhabha bha kutumbula, bhakujhomolela nabhabhaha bhakutumbula na bhakutumbuu nabhabhaha bhakujhomolela.” ");
INSERT INTO dne_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Machiko ghagha gheniya Mapwalichayo bhange bhajhakunyendelela Yecho kunnobholela, “Unyogholoke pamba na nnyende pachenda jhenge, Helode ipala kunkoma.” ");
INSERT INTO dne_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yecho ajhakujhanguu, “Nnyendengane na mukalilobholele libweya lyenio naha, ‘Deleno na kilabho namenga michuka na kwalamicha bhando na pamalabho nanyomolela mahengo ghango.’ ");
INSERT INTO dne_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nambo imbala deleno, kilabho na pamalabho kujhendelela na mwanja gwango, kongo ihalali ndeka kwa nnondole jwa Chapanga akomwe panja jha ku Yeluchalemo! ");
INSERT INTO dne_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yeluchalemo! Mangota mabhando bhu ku Yeluchalemo! Makoma akamilondole bha Chapanga, na kwakong'onda maghanga akatumiche bhibhatumitwe kwino! Nikapahile kwajhobhatila yana hino pamonga ngita ngoko, chajhobhotela kwa mapapanilo ghake, nambo mukapahijhe. ");
INSERT INTO dne_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Dolekeya, ngoheno nyumba jhino nailekwa ukebha. Nambo ninobholela nahumonajhe kabhele ade pumpala kulonge, ‘Jhuna mota jhola jwahika kwa liina lya Bhambo.’ ” ");
INSERT INTO dne_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lichiko limo lya Kupomolela, Yecho ajhakujhenda kajha kwa kilongoche jwa Pwalichayo jhumo, ajhakutama na kulyegha kongo lilongo lya bhando liteila kuningukiya. ");
INSERT INTO dne_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bhahe, mundo jhumo jwalwalwa ulwalo gwa kutupanila yegha akibha palonge jha Yecho, ");
INSERT INTO dne_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yecho ajhakwakonya Makapwalichayo na bhabhola bha Malaghalikilo, “Bho, lilaghalikilo lito lipala kunnamicha mundo jwailwalwa Lichiko lya Kupomolela amu nahi jhe?” ");
INSERT INTO dne_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nambo bhene bhajhakubhehe miho nduu kunyanguu. Papalapala Yecho ajhakuntola mundo jwailwala jhola na kunamicha na kunnekekeya akijhendele. ");
INSERT INTO dne_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Peniya Yecho ajhakwakonya, “Ndi ghane pakate jhino jwabhii na mwana mundo amu ng'ombi jhake jhitumbukii mukilibha Lichiko lya Kupomolela channeka mweniomo changaunhobhola?” ");
INSERT INTO dne_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bhahe, bhene bhajhakubhehe miho nduu kujhangula. ");
INSERT INTO dne_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yecho atehila kwalolekeya akaghene bhibhalalikwe bhange bhala pubhatehila kukihaghulila igoda ya palonge ya kutama ya kutembekewa, ndi ajhakwalobholela nnandanikiho ghongo, ");
INSERT INTO dne_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Anda mundo analike pa unyagho gwa ndowa, nkotoka kutama kigoda cha palonge cha utembekeho. Pange mundo jwenio analike jhonge ntopaho kupeta mwenga. ");
INSERT INTO dne_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Mundo jwanalikingine mangota mabhoha, nahika na kunobholela, ‘Nnyeme mwenga na atame jhonjo.’ Na peniya ndi nakola hone twe na kujhenda kutama kunyuma. ");
INSERT INTO dne_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nambo mwenga ntende naha pumulalikwa paunyagho, mwenga uhaghula pakutama kukigoda chakunyuma, na nnyina mwale jhola pamona nanongolela, ‘Makoche bhango, nnyeme peniya, na nhwike ntame pa kigoda cha palonge chenio.’ Peniya ndi namonekana ntopile pajhino bhando bhutamangine nabho pamonga. ");
INSERT INTO dne_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nhwalo mundo jhojhoha jwakikweya nahuluwa na mundo jhojhoha jwakihuluwa nakweywa.” ");
INSERT INTO dne_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Peniya nanobholela mundo jwanalike jhola, “Anda nnenganikiye chakulyegha pa muhe amu kimihe, nkotoka kwalalika akakoche bhino hilu akalongo bhibhantindila hilu bhajhino bhubhii na ilebhe mbwe. Anda ntei naha bhihoto kunalika kajhabhe na kumujhichila ngita ghimwahengile. ");
INSERT INTO dne_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nambo anda pumulenganikiya unyagho, mwalalika bhando akahocho na bhibhalemii na bhangatyanga pamonga na bhangalola, ");
INSERT INTO dne_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","mwenga nahuna mota, nhwalo bhumalalike bhoha bhakwete jhe chakunnepa. Chapanga nannepa ndweko hino lichiko lya bhando bhaumbone pubhapala kuyoka.” ");
INSERT INTO dne_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mundo jhumo jwakatamite na Yecho pakulyegha, ajhakulonge, “Ahanganile mundo jhola jwapala kunomenekeya pakulyegha mu Unahota nkolongwa gwa Chapanga!” ");
INSERT INTO dne_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yecho ajhakunnyangula, “Mundo jhumo akalenganikiye unyagho nkolongwa gwa kulyegha na ajhakwalalika bhando bhamahele. ");
INSERT INTO dne_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lichaa lya kulyegha pulihikita, mundo jhola ajhakuntuma ntumiche gwake ajhende akakeme bhibhalalikwe, ‘Uhikangane, kila kilebhe kilenganikiwe!’ ");
INSERT INTO dne_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nambo bhoha jhumo nga pa jhonge bhajhakutumbula kupomoha, nhwalo kila jhumo akibha na lihengo lyake. Mundo jhumo ajhakunnobholela ntumiche jhola, ‘Nanjino hemii nng'onda, mbala nnyende kuulolekeya, chonde nihika ndeka.’ ");
INSERT INTO dne_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mundo jhubhele ajhakulonge, ‘Nanjino hemii ng'ombi ya kulemela kome, nijhenda kuhijhighanikiya anda ihoto kulema, chonde nihika ndeka.’ ");
INSERT INTO dne_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Helahela mundo jhonge ajhakulonge, ‘Nanjino nihuma kutolela machiko ghangano, chonde nihika ndeka.’ ");
INSERT INTO dne_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ntumiche jhola nabhujha kajha na kunnobholela kilongoche jwantumita jhe ilebhe yoha. Nkolo nyumba pajhohina naha ajhakuyoma, ajhakunnobholela ntumiche gwake, ‘Nyendengane kajhombe mundela na mumiwacho jha miche jhoha mwakatole akahocho na bhangatyanga na bhangalola na bhibhalemii yegha bhahike.’ ");
INSERT INTO dne_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Peniya ntumiche jhola ajhakunnobholela, ‘Bhambo, ghoha ghunaghalikiye ndehile, nambo pwache ihighalike jhakupomolela bhando.’ ");
INSERT INTO dne_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Peniya munahota ajhakunobholela ntumiche gwake, ‘Nnyende mundela ya panja yoha na miwacho jha miche na chenda, mwakaghaghahane bhando bhahike na kujhingila nyumba jhango itwelile. ");
INSERT INTO dne_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ninnobholela chakaka, mangota mabhoha bhuninalakine, abhii jhe hilu mundo jhumo pakate jhino, nahotola kupaha chakulyegha paunyagho gwango!’ ” ");
INSERT INTO dne_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Malongo makolongwa gha bhando ghighalongohina na Yecho, bhahe, Yecho ajhakughalambukila na kwalobholela bhando, ");
INSERT INTO dne_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Na mundo jhojhoha jwahika kwa nenga impala atumbula hote kumbala nenga kuliku tate mundo amu majhe mundo amu nhwana mundo amu yana yake amu nnongo mundo amu akalombo mundo pamonga na ughome gwake, chakatenda gheniya, nahotola ndeka kubhehe mmolwa gwango. ");
INSERT INTO dne_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mundo jhojhoha jhola jwanga ghegha nchalaba gwake jwenio na kungengama nenga, jwenio ahoto ndeka kubhehe mmolwa gwango.” ");
INSERT INTO dne_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bho, ghane pakate jhino jwahipala kuchenga nnala, changatama hotejhe pahe na kumanya mbijha yakwete, anda mbijha yenio naikwela kuchengela? ");
INSERT INTO dne_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Anda ichindikine, nabhujhila kuchenga nchinge kanjika, na anda ahotwi ndeka kujhomolela, bhando bhoha pubhalola nabhatumbula kuheka kwa chanake. ");
INSERT INTO dne_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Peniya nabhalongela, mundo hojho atumbwii kuchenga nambo ajhomolile ndeka lihengo lyake! ");
INSERT INTO dne_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Bho, unahota nkolongwa ghane ghuhipala kujhenda kukomana ngondo na unahota nkolongwa ghonge, changatama hotejhe pahe kukikonya, akakomana ngondo bhake elufo kome bhihotola kukomana nabho na unahota ghola ghuhika na akakomana ngondo elufo ichiline? ");
INSERT INTO dne_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Anda chepa kukomana nako, natuma akatumiche bhake bhajhende kwa munahota nkolongwa jwenio bhakapomohe tuhoto ndeka kukomana, kone bhajhope kwa malongoche gha uteeke bhamela kutale. ");
INSERT INTO dne_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Helahela, mundo anda ahoto ndeka kuleka ilebhe yabhii nako, ahoto ndeka kubhehe mmolwa gwango!” ");
INSERT INTO dne_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mwinyo ndi gwambone, nambo mwinyo anda uhobhihe kunogha kwake, nabhalekela nike ade unoghe kabhele ngita chiukibha? ");
INSERT INTO dne_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yamaha ndeka kubheka munng'onda amu kuhangalana na mabule gha mbuhe, bhando nabhakutulila pahe. Mundo jwabhii na machikilo gha kujhoha na abangatuka!” ");
INSERT INTO dne_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lichiko limo akatola kode na bhando bhibhitenda uhakaho bhajhakujhenda kunnyokanikiya Yecho. ");
INSERT INTO dne_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nambo Akapwalichayo na bhabhola bha Malaghalikilo bhajhakutumbula kukokoleka, “Mundo honjo abhapokila bhando bhibhitenda uhakaho na kulye nabho!” ");
INSERT INTO dne_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Peniya Yecho ajhakwalobholela nnandanikiho ghongo. ");
INSERT INTO dne_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Anda mundo pakate jhino jwabhii na mambelele makome kome, amanyite limo lihobhalile, bho, natenda nike, naghalekii jhe mambelele ghange ghala makome ticha na ticha kughalucha na kujhenda kulipalaha limo lilihobhalile ade alibhone? ");
INSERT INTO dne_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Anda alihwene nahanganila na kulipepa ade pakilembele, ");
INSERT INTO dne_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na kulihikicha ukajha. Peniya nabhakema akakoche mundo na bhando bhubhandikile kwalobholela, ‘Nhwangane pamonga na nenga, nhwalo limbelele lyango lilihobhita lela niliwene!’ ");
INSERT INTO dne_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Helahela ninnobholela, kunane kwa Chapanga ndi nakuhangana, kwa mundo jhumo pauleka uhakaho gwake, kuliku bhando makome ticha na ticha bhibhabhii bhambone palonge jha Chapanga, na bhangapala kunghalambukila Chapanga gwabhe.” ");
INSERT INTO dne_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Mwikeghe jhumo jwakibha na mbijha chente kome, na chente jhimo ijhakuhobholela. Bho, peniya nakipitila nike? Nachonja kolobohi na kupyaghila chumbi na kughungulukana ade haibhone? ");
INSERT INTO dne_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bhahe, pahibhona chente jhela, nabhakema akakoche mundo bhubhamandikile pahina na kwalobholela, ‘Nhwangane pamonga na nenga, chente jhango jhihobhita jhela, niwene!’ ");
INSERT INTO dne_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Helahela ninnobholela, akatumiche bha kunane kwa Chapanga nabhahangana hake, kwa mundo jhumo pauleka uhakaho, na kunghambukila Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yecho ajhendelila kulonge, akibha mundo jhumo jwakibha na yana ibhele. ");
INSERT INTO dne_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Bhahe, unung'una jhola ajhakunnobholela tate mundo, tate, umaghulile ilebhe yango ya uliche. Peniya tate jhola ajhakwabhaghanichila lengalenga yana yoha ilebhe yake. ");
INSERT INTO dne_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ghakapetite ndeka machiko ghamahele, unung'una jhola ajhakuchulucha ilebhe yake. Peniya ajhakubhoka kajhake na kujhenda ku kilambo chukutale, kwenio ajhakunomenekeya mbijha njwe kwa ilebhe yanganandela. ");
INSERT INTO dne_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pakwangalikiya mbijha yake, pajhakupitila na njala nkolongwa pa kilambo choha na jwenio ajhakutumbuu kulagha. ");
INSERT INTO dne_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Peniya ajhakujhenda kujhopa lihengo kwa mundo jhumo jwabhelwikile peniya, mundo jhola ngapelika kunghonda kulichikiya magholobhe ghake. ");
INSERT INTO dne_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ajhakubhehe noghinoghi kulye mangabha ghubhalila magholobhe, nambo akapitile ndeka mundo jwakampekihe kilebhe chakulyegha. ");
INSERT INTO dne_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Patumbwila kubhangatuka malango, ajhakuwacha jwenio, tate gwango akwete bhubhahenga mahengo twe, bhibhalyegha na kujhukuta na kukilepela, na nenga nihwe na njala pambano! ");
INSERT INTO dne_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Helahela nanyinuka na kujhenda kwa tate gwango na kunnobholela, “Matate nanjino nintendi uhakaho Chapanga na mwenga helahela. ");
INSERT INTO dne_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nitopela ndeka kungema na mwana gwino, utende ngita unhenga lihengo gwino.” ");
INSERT INTO dne_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Peniya ajhakujhinuka na kutumbuu mwanja gwa kubhujha kwa tate mundo nambo pakibha chakutale. “Tate mundo ajhakumona kongo abhii mwojho gwa kiya, ajhakumutukila na kunyambucha kwa kukumbatila. ");
INSERT INTO dne_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bhahe, mwana jhola ajhakunobholela, ‘Tate gwango, nitendii uhakaho Chapanga na mwenga matate helahela. Nitopendeka kungema na mwana gwino.’ ");
INSERT INTO dne_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nambo tate mundo jhola ajhakwakema akatumiche bhake na ajhakwalobholela, ‘Nnyombiane!’ Munetele ngholole gwambone mupuke. Muwalikiya na lupete mulukonji lwake na maghubache mumakongono ghake! ");
INSERT INTO dne_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mukatole litohe lya ng'ombi lilihatite mukalichinja. Deka tukine unyagho na tuhanganila! ");
INSERT INTO dne_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nhwalo mwana jhonjo hambwika awile, nambo amela ghome, akahobholile, ngohe abhonike. Peniya bhajhakutumbuu kuhanganila pamonga.” ");
INSERT INTO dne_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Unyagho pujhendilila, nhwacha mundo akibha kunng'onda. Paheghelila pakajha, ajhakujhoha ilulo na ng'oma ikahonwa. ");
INSERT INTO dne_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ndi pankemita jhumo jwa akatumiche bhala na kunkonya, ‘Pakajha kipitii nike?’ ");
INSERT INTO dne_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ntumiche jhola nganyangwila, ‘Unung'una gwino jhola abhujhite ukajha, na tate gwino achinjile litohe lya ng'ombi lilihatite, nhwalo apitile amela ghome ko.’ ” ");
INSERT INTO dne_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Bhahe, nhwacha mundo jhola ajhakubhehe na lilaka na ajhakukana kujhingila nkate. Ndi tate mundo ajhakupita panja na kutumbula kumpembelekeya ajhingile nkate. ");
INSERT INTO dne_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nambo jwenio panyangwila tate mundo, ‘Dola, nihuhengii mahengo yaka yoha yeno, ngita ntumiche jwino changapucha malaghalikilo ghino nambo ukambekehejhe katohe kambuhe na nenga ndende kaunyagho na akakoche bhango! ");
INSERT INTO dne_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nambo mwana gwino hojho, amemenikiye ilebhe hino pamonga na akakeghe bhibhatenda ngongola, pabhujhite muchinji litohe lya ng'ombi lilihatite!’ ");
INSERT INTO dne_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tate mundo jhola ajhakunyangula, ‘Ma mwanango, mwenga mukibha pamonga na nenga machiko ghoha, na chiminako nenga ndi chino mwenga. ");
INSERT INTO dne_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nambo itupala tukine na kuhangana, nhwalo unung'una gwino tulongila awile, nambo ngoheno amela ghome na akahobholile, nambo ngoheno abhonikine.’ ” ");
INSERT INTO dne_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yecho ajhakwalobholela bhabholwa bhake, “Mundo jhumo jwakibha na ilebhe mbwe, na jwenio akibha na mundo jhumo jwajhemelela lihengo lyake. Mundo jwenio jwajhemelela bhajhakupyambanikila kwa nkolo ilebhe atenda kupechengana ilebhe yake. ");
INSERT INTO dne_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nkolo ilebhe jhola ajhakunkema nkate na kunnobholela, ‘Malobhe ghunijhoha panane jhino mwenga ndi gha chakaka? Umalangile ilebhe yoha impokile na ipihite, nhwalo nipahii jhe kabhele kujhemelela lihengo lyango.’ ");
INSERT INTO dne_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bhahe, jwajhemelela jhola ajhakuwacha kumwojho gwake, ‘Bhambo gwango ambomwiye lihengo. Bho, ngoheno nandenda nike nenga? Likakala lya kulema ngwete ndeka, na nenga nikola hone kujhopajhopa. ");
INSERT INTO dne_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ngoheno nimanya kilebhe chakuhenga papala kumbomoa lihengo! Bhando nabhambokela tugha kajhabhe.’ ");
INSERT INTO dne_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bhahe, ajhakwakema bhoha bhibhabhii na maghambo gha Bhambo gwake. Ajhakunkonya jwalongolile kuhika, ‘Bho, nkolo gwake lighambo lyake chilinge ile kwino?’ ");
INSERT INTO dne_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jwenio ajhakunyangula, ‘Ihulo makome kome ya mahuta gha micheitune.’ Jwajhemelela lihengo jhola ndi palongila, ‘Ntole likalatache lino lya lighambo ntame pahe nnyandike, ihulo makome amuchine.’ ");
INSERT INTO dne_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Peniya ajhakunkonya mundo jhubhele, ‘Bho, gwenga lighambo lino chilinge ile?’ Na jwenio ngajhangwila, ‘Maghunila gha ukobha gwa ngano makome kome.’ Na jwajhemelela lihengo jhola nganongolila, ‘Deta likalatache lino lya maghambo, jhandika makome nane.’ ");
INSERT INTO dne_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bhahe, munahota jhola ajhakunkweya nnyemelela lihengo jhola jwanganandela, nhwalo atehila kwa kukalamuka. Kwa bhando bha pannema pano utenda kwa kukalamuka ilebhe yabhe, kuliku bhando bhibhabhii mulumule.” ");
INSERT INTO dne_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yecho pajhendilila kulonge, “Ninnobholela mangota, mukipalakiya akakoche kupetela ilebhe ya pannema, nambo puhipala kujhomokela, nabhampokela pakajha pa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mundo jhojhoha jwahobholeka mwilebhe yandina, nahobholeka mulilundo lya ilebhe, na mundo jhojhoha jwangahobholeka mwilebhe yandina nahobholeka ndeka mwilebhe yamahele. ");
INSERT INTO dne_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Anda mangota mulonda ndeka ilebhe ya pannema pano, bho, ghane nahotola kumpelangana ilebhe hela ya uchakaka? ");
INSERT INTO dne_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Anda mangota chepa kuhobholeka muilebhe ya mundo jhonge, bho, ghane nahotola kukamuha ilebhe hino mabhene? ");
INSERT INTO dne_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Abhii jhe ntumiche jwahotola kwahengela akanahota mabhele pamonga, nhwalo nanipala jhumo na kuchimwa jhonge, amu nalongohana na jhumo na kupucha jhonge. Mihoto ndeka kunhengela Chapanga na kongo mihengele mbijha pamonga.” ");
INSERT INTO dne_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mapwalichayo bhubhapala mbijha pubhajhohina gheniya, bhajhakumpucha Yecho. ");
INSERT INTO dne_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yecho ajhakwalobholela, “Mangota mukitenda bhaumbone, nambo Chapanga ahimanyite miojho jhino. Kwa kilebhe chikibhonekana chambone kwa bhando, kwa Chapanga kibhonekana kilebhe nacho. ");
INSERT INTO dne_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Lilaghalikilo lya Mucha na majhandiko gha milondole bha Chapanga ghakalongilwe ade machiko gha Yohane Mbatichajhe. Kutumbulila peniya, Lilobhe lya Mbone lya Unahota nkolongwa gwa Chapanga ghalongelwa, na kila mundo ujhingii kwa makakala. ");
INSERT INTO dne_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nambo ijhojwike kunane kwa Chapanga na pannema kuhobholela, kuliku kilebhe chandina kuhobholela mu Lilaghalikilo lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Likambako lyolyoha jwahineka nhwana mundo na kutolela mwikeghe jhonge, jweniojho atenda ngongola na likambako jwantolela mwikeghe jwanekite nnyake na jwenio helahela atenda ngongola. ");
INSERT INTO dne_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Pakibha na mundo jhumo jwakibha na ilebhe twe na jwawalita ngobho ichulwicha kwa mbijha yamahele na atehila kunomenekeya kwa machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na pa litangala lyake likolongwa, abhekwitwa mundo nhocho liina lyake Lachalo jhuna ilonda yegha jhoha, ");
INSERT INTO dne_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","anoghilwa kulyegha imbolopolo iponila pahe kuhumii pakachangwale ka jwabhii na ilebhe yamahele. Na hilu ghimbwa ihikita kunnamba lamba ilonda yake! ");
INSERT INTO dne_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Lichiko limo nhocho jhola ajhakuwegha, akatumiche bha kunane kwa Chapanga bhajhakunghegha, ade pahina jha Ulahimo. Helahela jwakibha na ilebhe mbwe jhola, ajhakuwegha na bhajhakuyelela umambe. ");
INSERT INTO dne_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jwakibha na ilebhe mbwe jhola, pakibha ku kilambo cha bhando bhubhawile atehila kung'ahika hake. Palolita kunane, akamwene Ulahimo chukutale na Lachalo abhii pahina jhake. ");
INSERT INTO dne_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bhahe, ajhakukema kwa lilobhe lya kulalama, ‘Tate Ulahimo ungolele kiya! Mutume Lachalo achwiye lukonje lwake umache na alukongolekeye lulime lwango, nanjii ndenda kung'ahika kumwotu!’ ” ");
INSERT INTO dne_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nambo Ulahimo nganyangwila, ‘Ma mwanango nkomboke, mukapokile ilebhe yambone pumukibha na ughome gwino na Lachalo akapokile ilebhe yanganandela. Nambo ngoheno Lachalo apomolile pamaha na mwenga mung'ahika mwenio.’ ");
INSERT INTO dne_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pamonga na ghenagha, pakate jhito na mwenga pabhii na ling'engo likolongwa, hilu mundo jwapala kujhomboka kuhika kwino alepelele, helahela abhii jhe mundo jwahotola kujhomboka kubhoka kwino kuhika kwa twenga. ");
INSERT INTO dne_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bhahe, jwakibha na ilebhe twe jhola ngalongila, ‘Chonde Tate Ulahimo ninnyopa, mutume Lachalo ajhende kajha jhango, ");
INSERT INTO dne_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ngwete akalongo nhwano kwenio. Muneke ajhende akabhakelebhuye bhakoto kuhika palung'ahe pano.’ ” ");
INSERT INTO dne_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Nambo Ulahimo nganyangwila, ‘Akalongo bhino bhabhii na Mucha na milondole bha Chapanga, mwaleke bhajhokanikiye bheniya.’ ");
INSERT INTO dne_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bhahe, jwakibha na ilebhe twe ajhakulonge, ‘Nahindeka Tate Ulahimo! Anda mundo jwayokite abhajhendilile kuhumii kubhawile, nabhaleka uhakaho gwabhe.’ ");
INSERT INTO dne_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nambo Ulahimo ajhakulonge, ‘Anda nakwajhokanikiya jhe Mucha na milondole bha Chapanga, nabhanyeketala jhe mundo jhojhoha hilu ayoke kuhumii kubhawile.’ ” ");
INSERT INTO dne_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Peniya Yecho ajhakwalobholela bhabholwa bhake, “Naipitila ilebhe intenda mundo atende uhakaho, nambo nalola choto mundo jhola jwatenda ipitile. ");
INSERT INTO dne_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ngahibhii mbaha kwa mundo jwenio bhankonge lwalwa lukolongwa pantandala gwake na kutumbukii kumbwane, kuliku kuntenda mwana nchokombe atende uhakaho. ");
INSERT INTO dne_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mukilolekeye! “Anda nnongo gwino anemwiye mupwatalile, anda ajheketile na kuleka ulemo gwake, munekekeye. ");
INSERT INTO dne_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Anda anemwiye mala chaba kwa lichiko limo, na ahukilile na mahole chwii, ‘Nyeketile kuleka ulemo gwango,’ na mwenga ipalwa munekekeye.” ");
INSERT INTO dne_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Akatenga bhajhakunnobholela Bhambo, “Mutujhonjekeye kihobholelo.” ");
INSERT INTO dne_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bhambo ajhakulonge, “Ngankola kihobholelo chino ngita mbejho njokombe ikemwa haladale, ngahotwii kulongolela nkongo gwa nkojho hogho, ‘Tupuka, mukamele kumbwane!’ Na gwenie ngaujheketile.” ");
INSERT INTO dne_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Helahela Yecho ajhakulonge “Kwa nnandanikiho, pakate jhino abhii mundo jhumo jwakwete ntumiche jwannemela nng'onda gwake amu jwachungila mambelele. Paibhujha kulihengo jwenio ntumiche bho, munahota nannobholele jhe, ‘Atame pahe, ahike alyeghe?’ ");
INSERT INTO dne_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nahibha naha ndeka! Nannobholela, ‘Unenganikiye chakulyegha, ntumbula kundelekela ade pumbala kujhomolela kulyegha na kunywelekeya mache, ndi mwenga pumulyegha na kunywelekeya!’ ");
INSERT INTO dne_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bho, namunchengujhe jwenio ntumiche nhwalo gwa ghoha ghumunaghalikiye kuhenga? ");
INSERT INTO dne_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Helahela na mangota, anda nyomolile kuhenga chela chinaghalikiwe, ipala kulonge ‘Twenga twakatumiche twanga nandela. Tuhengite ngita itupala kuhenga.’ ” ");
INSERT INTO dne_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yecho pajhendilila na mwanja gwake gwa kujhenda ku Yeluchalemo, ajhakupeta pakate jha ku Samaliya na ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bhahe, pahikita pa chenda jhimo ajhakukonganika na bhando kome bhibhalwalwa ulwalo gwa malohe. Na bhene bhakajhemite chukutale. ");
INSERT INTO dne_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Na bhene bhajhakunonoha malobhe ghabhe, bhalongila, “Yecho! Ma Bhambo! Mutukole kiya twenga!” ");
INSERT INTO dne_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yecho pabhalolikiya ajhakwalobholela, “Nnyendangane mukakilaye kwa akapiya matambiko.” Pubhakibha mundela kujhenda kwenio, ndi bhajhakujhelebhulwa. ");
INSERT INTO dne_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jhumo pakate jhabhe pabhonita ajhelewike, ajhakukelebhuka kongo anumbalila Chapanga kwa lilobhe likolongwa. ");
INSERT INTO dne_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ajhakulita palonge jha makongono gha Yecho na kunumbalila. Mundo jweniojho akibha Nsamaliya. ");
INSERT INTO dne_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yecho pakonyita, “Bho, chi bhando kome bhibhakajhelebhilwe? Bho, bhando bhala bhubhahighalike ticha bhabhii kojhe? ");
INSERT INTO dne_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bho, abhii jhe hilu jhonge jwahikite kunumbalila Chapanga, nga nghene kanjika?” ");
INSERT INTO dne_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Peniya Yecho ajhakunnobholela mundo jhola, “Jhinuka nnyende, kihobholelo chino kinamiche.” ");
INSERT INTO dne_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mapwalichayo pubhankonyita Yecho, “Bho, Unahota nkolongwa gwa Chapanga nauhika ligha kwa twenga?” Na jwenio ngabhajhangwila, “Unahota nkolongwa gwa Chapanga nahuhika ndeka kwakulolokeya kwa miho. ");
INSERT INTO dne_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Abhii jhe mundo nahotola kulonge, ‘Ghongo pambano!’ Amu ‘Ghologho pala!’ Nhwalo Unahota nkolongwa gwa Chapanga ubhii nkate jhino.” ");
INSERT INTO dne_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Peniya Yecho ajhakwalobholela bhabholwa bhake, “Machiko ghabhikuhika naunoghilwa kuibhona lichiko limo lya Mwana gwa Mundo, nambo namulibhone jhe. ");
INSERT INTO dne_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bhando nabhannobholela, ‘Dolekeya, jholojho pala!’ Amu ‘Dolekeya abhii pambano!’ Nambo mangota nkotoka kukengamila. ");
INSERT INTO dne_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwa nhwalo ngita lumule lwa mbamba, chilupitila na kukenulila kunane kumahunde kuhumii upandi ghumo ade ghonge, ndi Mwana gwa Mundo nabhaha hele mu lichiko lyake. ");
INSERT INTO dne_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nambo impala atumbula kung'ahika hake, na kukanilwa na bhando bha kibheleko chenje. ");
INSERT INTO dne_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Na ngita chikibha mu machiko gha Nuho, helahela ndi chipala kubhehe kwa Mwana gwa Mundo. ");
INSERT INTO dne_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bhando bhajhendilila kulyegha na kunywelekeya, kutolela na kutolelwa ade Nuho pajhingila mungalabha ngolongwa jhikemwa chapina, mache ghajhakuheluka na kwakoma bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nahibha telatela ngita machiko gha Luto. Bhando bhajhendelila kulyegha na kunywelekeya, kongo bhachulwicha na kuhemela ilebhe, kumicha mbejho na kuchenga. ");
INSERT INTO dne_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nambo lichiko lela Luto pabhokita ku Sodoma, lola mwotu na maghanga ghughajhaka mwotu ghahaghambwika kuhumii kunane kumahunde na kwatiniya bhando bhoha likiliki. ");
INSERT INTO dne_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ndi chikipala kupitila kwa Mwana gwa Mundo chaipalwa kuyekulilwa. ");
INSERT INTO dne_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Na lichiko lyenio, mundo jhojhoha jwapakubhehe pa kipaghalo akotoka kuhuluka kujhingii nkate na kutola ilebhe yake, na helahela jwabhii kung'onda akotoka kubhujha kutola ilebhe yake. ");
INSERT INTO dne_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mikomboka ghighankolila nhwana gwa Luto! ");
INSERT INTO dne_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mundo jhojhoha jwahipala kuughombola ughome gwake nahuhobhecha, na jhojhoha jwahuhobhecha ughome gwake naughombola. ");
INSERT INTO dne_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ninongolela chakaka uhiko gwenio, bhando bhabhele bhagholwike pamonga, jhumo natolwa na jhonge nalekwa papa.” ");
INSERT INTO dne_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akakeghe bhabhele nabhabha pamonga pakuyagha palwalwa, jhumo natolwa na jhonge nalekwa papa. ");
INSERT INTO dne_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bhando mabhele nabhabha mukulema, jhumo natolwa na jhonge nalekwa papa. ");
INSERT INTO dne_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Peniya bhabholwa bhake bhajhakunkonya, “Bho, kojhe Bhambo naghapitila gheniya?” Jwenio Yecho ngabhalongolila, “Pighakonganika matumbuhe, peniya ndi pubhii ntuhe.” ");
INSERT INTO dne_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bhahe, Yecho ajhakwachimulila bhabholwa bhake nnandanikiho gwa kwabhola bhajhope machiko ghoha changaleka. ");
INSERT INTO dne_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ngalongila, “Pamuche ghumo pakibha na nnyomola mihalo, jwenio anyogwipa ndeka Chapanga hilu kwapala bhando. ");
INSERT INTO dne_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Helahela pakibha na nawela jhumo pamuche gwenio, jwanyendelila nnyomola mihalo jwenio kila lichiko, ‘Antangatile kuntengekela na likoko lyake!’ ");
INSERT INTO dne_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kwa machiko ghamahele nnyomola mihalo jhola akapala ndeka kuntangatila nawela jwenio. Nambo kujhomolela kwake ajhakuwachila kumwojho gwake, ‘Pamonga na nenga ninyoghopa ndeka Chapanga amu kwapala bhando, ");
INSERT INTO dne_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nambo nhwalo gwa nawela jhonjo ing'aha nenga nanitangatila apata chikibhii chake, anda naha ndeka najhendelela kuhikahika, na kundotoha nenga!’ ” ");
INSERT INTO dne_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bhahe, Bhambo ajhakujhendelela kulonge, “Nnyokanikiye chalongile nnyomola mihalo jwanganandela. ");
INSERT INTO dne_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bho, Chapanga nabhakengela ndeka bhando bhake bhabhahagwile, bhubhanelila muhe na kilo? Bho, natenda kiyoto kwatangatila? ");
INSERT INTO dne_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ninnobholela chakaka, nabhakengela kajhombe. Pamonga na gheniya ghoha, Mwana gwa Mundo papala kuhika, bho, nabhakolela bhando bhabhii na kihobholelo pannema?” ");
INSERT INTO dne_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Peniya Yecho ajhakwalobholela nnandanikiho kwa bhando bhala bhibhakibhona umbone na kwapucha bhange. ");
INSERT INTO dne_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Bhahe, bhando bhabhele bhajhopita pa Nyumba jha Chapanga ku Yeluchalemo. Jhumo akibha Mpwalichayo, na jhonge ntola kode. ");
INSERT INTO dne_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Mpwalichayo jhola ngajhemita, kunyopa Chapanga chakumwojho mwojho, alongila, ‘Ninchenguu Chapanga, nhwalo nenga mmi ndeka ngita bhando bhange, bhibhatola ilebhe ya bhando kwa makakala amu bhatenda ghanganandela amu ngongola na ngita jhonjo ntola kode.’ ");
INSERT INTO dne_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nenga nipunga machiko mabhele kwa lijuma limo, nipiya chaka kwa Chapanga ilebhe yango yoha inipata.” ");
INSERT INTO dne_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Nambo ntola kode jhola na jwenio ajhakujhema chukutale changajhinula miho ghake kunane kwa Chapanga, nambo akitobhita tobhita panganga kongo abhii ngolongonde, alongila, ‘Mwe ma Chapanga, ungolele kiya nenga mii na uhakaho!’ ” ");
INSERT INTO dne_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yecho ajhakwalobholela, “Hojho ntola kode pabhujhita kajhake kone alekekiwe uhakaho na Chapanga. Nambo jhonge jhola akalekekiwe jhe. Nhwalo jhola jwakitenda kubhehe jwandina nabhaha nkolongwa na jhola jwakitenda nkolongwa nabhaha jwandina.” ");
INSERT INTO dne_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bhando bhange bhajhakunnete Yecho yana ichokombe abhabhekele mabhoko na kuhikuchulila. Bhabholwa bhake pubhalolita naha, bhajhakwipwatalila. ");
INSERT INTO dne_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nambo Yecho ajhakwakema yana bhanhuheghelele, “Muileke yana yandina ihike kwa nenga, mangaibhilikiya. Nhwalo Unahota nkolongwa gwa Chapanga ndi kwa bhando bhibhabhii ngita bheniya. ");
INSERT INTO dne_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ninnobholela chakaka! Mundo jhojhoha jwangaupokela Unahota nkolongwa gwa Chapanga ngita mwana nchokombe, jwenio nanyingii ng'o mu Unahota nkolongwa gwa kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nkolo jhumo jwa Akayahude ajhakunkonya Yecho, “Mmola maumbone, ndende nike mme na ughome gwa machiko ghoha ghangapeta?” ");
INSERT INTO dne_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yecho ajhakunkonya, “Nhwalo gwa nike ungema nenga naumbone? Abhii jhe jwaumbone nga Chapanga kanjika. ");
INSERT INTO dne_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mulimanyite maha lilaghalikilo, ‘Nkotoka kutenda ngongola amu nkotoka kukoma, nkotoka kulonge uwange amu nkotoka kujhibha na mwatembekeya tate na majhe gwino.’ ” ");
INSERT INTO dne_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na jwenio pajhangwila, “gheniya ghoha nighakamwii punikibha nakangombo.” ");
INSERT INTO dne_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yecho pajhohina gheniya ajhakunnobholela, “Kihighalike chimo nhwengite jhe mwenga. Mukachuluche ilebhe hino inkwete, mbijha yenio makabhaghulile akahocho, na mwenga nama na ilebhe mbwe kunane kwa Chapanga. Peniya ndi uhika ungengame.” ");
INSERT INTO dne_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nambo mundo jhola pajhohina gheniya, ajhakubhehe ngolongonde hake nhwalo akibha na ilebhe mbwe. ");
INSERT INTO dne_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yecho pamonita jwenio abhii ngolongonde, ajhakunnobholela, “Dolekeya chinonwipe kwa mundo jwabhii na ilebhe twe kujhingii mu Unahota nkolongwa gwa Chapanga! ");
INSERT INTO dne_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nhwalo ijhojwike kwa kinyama chikikemwa ngamiya kuholota pa lihoto lwa luchungulo lwa mpacha, kuliku jwabhii na ilebhe twe kujhingii mu Unahota nkolongwa gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bhando bhala pubhajhohina gheniya, bhajhakulonge, “Bho, ghane ngohe nahotola kughombokoka?” ");
INSERT INTO dne_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yecho pajhangwila, “Kilebhe chikibhii chepa kwa mundo, kwa Chapanga kijhojhoho.” ");
INSERT INTO dne_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peniya Petile ajhakulonge, “Dolekeya! Na twenga tulekite ilebhe yoha na tunkengime mwenga!” ");
INSERT INTO dne_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yecho ajhakwalobholela, “Ninobholela chakaka, mundo jhojhoha jwahilekite nyumba jhake amu nhwana mundo amu nnongo mundo amu tate na majhe mundo na yana yake kwa nhwalo gwa Unahota nkolongwa gwa Chapanga, ");
INSERT INTO dne_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","napokela twe kwa machiko ghanga, na ughome gwa machiko ghoha ghangapeta ghuhika palonge.” ");
INSERT INTO dne_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yecho ajhakwatola bhabholwa bhake kome na babhele na kwalongolela, “Unyokanikiye mbone! Tujhenda ku Yeluchalemo, na kila kilebhe chikijhandikwe na milondole bha Chapanga cha Mwana gwa Mundo nakipitila. ");
INSERT INTO dne_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nhwalo nabhakumua kwa bhando bha ilambo henge. Na bhene nabhantendela chanake, nabhannigha maligho na kuhunii mata, ");
INSERT INTO dne_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","nabhachwapula yato na kunkoma. Nambo lichiko lya utato nayoka.” ");
INSERT INTO dne_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nambo bhabholwa bhake bhakamanyite jhe kilebhe chenie. Bhakahihitwe mana jha ilebhe yenio, bhakibha chehwe chikilongelwa na Yecho. ");
INSERT INTO dne_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yecho pabhandikila kuhika ku Yeliko, pakibha na mundo jhumo jwangalola jwatamita muupele mwa ndela lihengo lyake kwajhopa bhapeta ndela. ");
INSERT INTO dne_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pajhohina lilongo lya bhando litenda kupeta ngakonyita, “Bho, kibhii nike?” ");
INSERT INTO dne_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ngabhannyangwila, “Yecho jwa ku Nachalete itenda kupeta.” ");
INSERT INTO dne_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jwenio nganonwiya lilobhe alongila, “Yecho! Mwana gwa Daude, umonele kiya!” ");
INSERT INTO dne_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bhando bhala bhubhalongolila bhajhakupwatalila bhannobholila ntame nuu, nambo jwenio ajhakuchocha kunonoha lilobhe, “Yecho mwana gwa Daude, umonele kiya!” ");
INSERT INTO dne_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yecho ajhakujhema, ajhakwalaghalikiya bhando bhannete pabhii jwenio. Jwangalola paheghilila pahina, Yecho pankonyita, ");
INSERT INTO dne_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Bho, mipala nintendele nike?” Ngajhangwila, “Bhambo, nijhopa kulola.” ");
INSERT INTO dne_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yecho ajhakunnobholela, “Nnole! Kihobholelo chino kinamiche.” ");
INSERT INTO dne_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Papalapala jwangalola jhola ajhakulola, ajhakunkengama Yecho kongo abhii mukunomba Chapanga. Bhando bhoha bhubhalolita gheniya, na bhene helahela bhajhakunnomba Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yecho ajhakujhingila ku Yeliko, apetita pakate jha muche gwenio. ");
INSERT INTO dne_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kwenio pakibha na mundo jhumo liina lyake Zakayo, nkolo jwa akatola kode, na jwenio akibhe na ilebhe twe hake. ");
INSERT INTO dne_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jwenio, apata ahumanye Yecho ndi ghane, nambo nhwalo gwa kujholoka kwa bhando helahela akibha nnyipe, akahotwii jhe. ");
INSERT INTO dne_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Peniya pabhutwika kulonge jha lilongo lya bhando, na kuhobhokela munkongo gwa nkojho annole Yecho, nhwalo apetita ndela jhejhe. ");
INSERT INTO dne_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yecho paheghelila peniya, ajhakummona Zakayo abhii kunane jha nkongo, ngannobholila, “Zakayo, huluka kajhombe, nhwalo deleno nenga mbala kupipikiya kajhino.” ");
INSERT INTO dne_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Peniya Zakayo ngahulwike kajhombe, na kumpoke Yecho kwa kuhanganii nu kujhenda nako kajhake. ");
INSERT INTO dne_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bhando bhoha pubhalolita gheniya bhajhakutumbuu kukokoleka na bhalongila, “Ajhenda kutama kajha kwa mundo jwabhii na uhakaho!” ");
INSERT INTO dne_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nambo Zakayo ajhakujhema, na kulongole Yecho, “Dolekeya Bhambo, nenga nibhaghula nucho ya ilebhe yango na kwapekeya akahocho na anda nikatohile kilebhe cha mundo kwa kukopokeya nanimujhichila mala ncheche.” ");
INSERT INTO dne_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yecho ajhakwalobholela, “Deleno ughombokeko ujhingile unyumba jhino, na nenga helahela lukolo lwa Ulahimo. ");
INSERT INTO dne_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nhwalo Mwana gwa Mundo ahikite kupalaha na kwaghombola bhando bhibhahobhalile.” ");
INSERT INTO dne_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bhando pubhajhendelila kujhokanikiya gheniya, Yecho akabhalobhalile nnandanikiho, nhwalo abhandikila kuhika ku Yeluchalemo, na bhene bhahambwika, Unahota Nkolongwa gwa Chapanga ubhandikile kupetela. ");
INSERT INTO dne_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Peniya akabhalobhalile, “Akibha mundo jhumo jwa lukolo lwa unahota nkolongwa, jwakajhenda ku kilambo chukutale, akatendwe kubhehe Munahota nkolongwa na pakelebhuka ukajha. ");
INSERT INTO dne_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bhahe, papala kutumbuu mwanja akabhakemite akatumiche bhake kome, na kwabhaghulila mbijha kila jhumo na kwalobholela, ‘Kila jhumo ahengela lihengo lya kuhemelecha na kuchulucha ilebhe ade pumbala kubhujha.’ ");
INSERT INTO dne_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nambo bhando bha pa muche gwake bhakampahi ndeka jweniojho, peniya ndi pubhatumita akatenga na kujhenda bhakanongolele, ‘Tumpahi ndeka mwenga kubhehe kilongoche gwito.’ ");
INSERT INTO dne_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Paupokila unahota nkolongwa gwake, akalaghalikiye akatumiche bhake kome bhibhakabhaghulilwe mbijha bhala, bhannobholele amanye kila mundo ajhonjikii mbijha ilegha. ");
INSERT INTO dne_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ntumiche jhumo akakutumbuu kujhenda na kulonge, ‘Bhambo, mbijha yumaghulile hela ibhelekine makome ghange kome kuhumii mumbijha yumaghulile.’ ");
INSERT INTO dne_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ngalongila, ‘Mwe ntei mbone, mwenga ntumiche mwaumbone! Nhwalo uhobholike mwilebhe yandina, ngohe nanimpela ulongoche gwa miche kome.’ ");
INSERT INTO dne_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Akanheghelile ntumiche jhubhele, ngalongila, ‘Bhambo, mbijha yumaghulile, ijhonjikike henge nhwano kuhumii yela yumaghulile.’ ");
INSERT INTO dne_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Munahota jhola ngannobholila, ‘Na mwenga hele ninhaghuu kubhehe kilongoche jwa miche nhwano.’ ");
INSERT INTO dne_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Peniya ntumiche jwa utato ngahikita na kulonge, ‘Bhambo, mbijha hino jhenje nikatabhite mulilombolo. ");
INSERT INTO dne_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nhwalo, nenga ndeila kunyoghopa, mwenga nkokotwike. Miponga ilebhe na kongo hino ndeka, na muhuna pangamicha.’ ");
INSERT INTO dne_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bhahe, munahota jhola nganongolila, ‘Mantumiche malimbyeta! Nanihadabula kwa malobhe ghino. Ukamanyite njwe anda nenga ngokotwike, nhwalo nitola yangabhehe yango na kuhuna pangamicha. ");
INSERT INTO dne_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nhwalo gwa nike mukabhekitejhe mbijha yango ku bhenke?’ Na punibhujha ngambatite mbijha ijhonjikike. ");
INSERT INTO dne_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ajhakwalobholela bhubhakajhemite peniya, ‘Mupoke mbijha yenio, mukannyonjekehe jhola jwapatite mbijha kome.’ ");
INSERT INTO dne_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bhene bhakannobholile, ‘Nambo Bhambo, jweniojho apatite mbijha makome kome!’ ");
INSERT INTO dne_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jwenio ngajhangwila, ‘Ninnobholela, mundo jhojhoha jwabhii na kilebhe, jwenio najhonjekelwa chenge, nambo jhola jwangabhehe na kilebhe ata chabhi nacho napokwa. ");
INSERT INTO dne_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ngohe, makoko ghango bhambahi jhe nenga kubhehe na munahota gwabhe, unetela pambano, na makome palonge jhango!’ ” ");
INSERT INTO dne_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yecho pajhomolila kulonge gheniya, akalongolile kujhenda ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pabhandikila kuhika ku Betifage na ku Betaniya, pahina jha Kitombe chuku Micheitune, akabhatumite bhabholwa bhake bhabhele, ");
INSERT INTO dne_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ajhakwalobholela “Nnyende muchenda imuibhona. Na pumupala kujhingii muchenda jhene, namumona litohe lya liponda bhalikongile, lyamela anatumbujhe kutami mundo. Na mulibhopole na uhike nako pamba. ");
INSERT INTO dne_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Anda mundo ankonyite, nhwalo gwa nike mulibhopo litohe lya liponda, munnobholele, ‘Alipala Bhambo.’ ” ");
INSERT INTO dne_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bhahe, bhajhakujhenda, na kulikolela litohe lya liponda ngita Yecho chakabhalobhalile. ");
INSERT INTO dne_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pubhalibhopwila litohe lya liponda, jwenio nkolo liponda ajhakwakonya, “Nhwalo gwa nike mulibhopo liponda lyango?” ");
INSERT INTO dne_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bhene ngabhajhangwila, “Alipala Bhambo.” ");
INSERT INTO dne_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bhahe, ndi bhakampelekile Yecho litole lyenio, bhakatoi ngobho nu kujhala mbone panane jha liponda na Yecho nganhobhokla nu kutama panane jhake. ");
INSERT INTO dne_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yecho pajhendilila na mwanja gwake, bhando bhajhendilila kujhala ngobho yabhe mundela. ");
INSERT INTO dne_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pabhandikii kuhika ku Yeluchalemo, paluhelelo lwa kitombe chuku Micheitune, lilongo lyoha lya bhando na bhabholwa bhake bhajhakutumbuu kululuta na kunnomba Chapanga kwa lilobhe likolongwa nhwalo gwa ilebhe ikolongwa yoha ibhahihwene. ");
INSERT INTO dne_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bhalongila, “Jhuna mota Munahota nkolongwa jwahika kwa liina lya Bhambo! Uteeke ubhaha kunane kwa Chapanga na ung'alicho kunane kwa Chapanga!” ");
INSERT INTO dne_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mapwalichayo bhange bhibhakibha mulilongo lela lya bhando bhakannobholile Yecho, “Mmola, malobholele bhabholwa bhino bhatame nuu!” ");
INSERT INTO dne_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yecho pajhangwila, “Ninnobholela, anda bhamba bhatamiti nuu, chakaka maghanga naghatondobheya lilobhe.” ");
INSERT INTO dne_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yecho pabhandikii muche gwa ku Yeluchalemo na kuulolekeya muche, ajhakwalele bhando bha muche gwenio, ");
INSERT INTO dne_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","alongila, “Anda ngaumanye deleno mambu ghighaleta uteeke! Nambo ngohe mihotojhe kughamanya! ");
INSERT INTO dne_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chakaka machiko ghabhii kuhika, akamakoko bhino nabhandindikiya ubhegho tii ngote, nakumpopoteka kila chehemo. ");
INSERT INTO dne_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nabhahindilikiya mwenga na yana hino mulipamanda lino. Nabhannekekeya ndeka ade lighanga limo lighelekane palinge, nhwalo bhamanyite ndeka lichaa lya Chapanga pahikilila kwino!” ");
INSERT INTO dne_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Peniya, ndi pajhingila pa Nyumba jha Chapanga na kutumbuu kwabhengela bhando panja bhibhahemila na kuchulucha ilebhe mwenio. ");
INSERT INTO dne_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Alongila, “Ijhandikwe, ‘Nyumba jhango naibha Nyumba jha kunnyope Chapanga.’ Nambo mangota mwenga uyohite nkwembe gwa kukwatulila ilebhe!” ");
INSERT INTO dne_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yecho ahwelita kubhola pa Nyumba jha Chapanga machiko ghoha. Nambo Akapiya Matambiko bhakolo na bhabhola bha Malaghalikilo na ilongoche ya bhando, bhapaliya ndela jha kunkomelekeya, ");
INSERT INTO dne_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","nambo bhakabhehe bwaghala chakuhenga, nhwalo gwa bhando bhoha bhakibha bhannyokanikiya. ");
INSERT INTO dne_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lichiko limo Yecho patehila kubhola pa Nyumba jha Chapanga ku Yeluchalemo na kwalobholela bhando Lilobhe lya Mbone. Akapiya Matambiko bhakolongwa na bhabhola bha Malaghalikilo, na akanahota bha Kiyahude, bhakannyendile Yecho, ");
INSERT INTO dne_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ngabhannobholila, “Bho, mutulobholele mihenga ilebhe henge kwa ukindendeke gwa ghane? Na ghane jwampekiye ukindendeke gwenio?” ");
INSERT INTO dne_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yecho ajhakwalobholela, “Na nenga nipala kunkonya kilebhe chimo. ");
INSERT INTO dne_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Bho, ukindendeke gwa Yohane gwa kubaticha bhando uhumila kojhe? Bho, ukindendeke gwenio uhumila kwa Chapanga amu kwa bhando?” ");
INSERT INTO dne_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nambo bhakalolakeine bhene kwa bhene, “Anda tulongi uhumita kwa Chapanga, natukonya, ‘Bho, nhwalo gwa nike mukannyeketi jhe Yohane?’ ");
INSERT INTO dne_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Anda tulongii uhumita kwa bhando, umanye lilongo lyoha nalitukoma kwa maghanga, nhwalo bhoha bhakamanye Yohane akibha chakaka ndi nnondole jwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bhahe, bhakanyangwile, “Twenga tumanyite ndeka ukindendeke gwake kuhumile.” ");
INSERT INTO dne_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yecho ngabhalobholila, “Na namwete ninnobholela ndeka nihenga ghanga kwa ukindendeke gwa ghane.” ");
INSERT INTO dne_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yecho pajhendilila kwalobholela nnandanikiho ghonge, “Mundo jhumo akibhe na ng'onda gwake gwa michabibo. Na akabhajhahikiche bhubhalema, na jwenio akatumbuu mwanja ade ku kilambo chukutale, na kwenio ajhakutama kwa machiko ghamahele. ");
INSERT INTO dne_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pughahikita machiko gha kuhuna, mundo jwenio ajhakuntuma ntumiche gwake kwa bhubhalema bhala akatole mahuno gwa ng'onda gwake. Nambo bhubhalema bhala bhajhakuntyala ntumiche jhola na bhakammengite mabhoko matopo. ");
INSERT INTO dne_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nkolo nng'onda jhola ajhakuntuma helahela ntumiche jhonge. Nambo jwenio hele bhajhakuntyala na kuntendela ilebhe ya hone na kubhujhicha mabhoko matopo, ");
INSERT INTO dne_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ajhakuntuma ntumiche jhonge jwa utato, na jwenio ndi bhajhakunkocholana na kumenga. ");
INSERT INTO dne_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Peniya nkolo nng'onda jhola ajhakukikonya, ‘Ngohe nandenda bhole nenga? Nanintuma mwana gwango jwa pamwojho. Pange nabhanendema!’ ");
INSERT INTO dne_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nambo bhubhalema bhala pubhamwenita, bhajhakupwepwelana jweniojho ndi nabhujhila mighonda, ‘Denda tunkome, na ng'onda gwake ubhehe gwito!’ ");
INSERT INTO dne_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bhahe, bhajhakunhutila panja jha mighonda jha michabibo, bhajhakunkoma.” Bhahe, Yecho ajhakwakonya bho, nkolo ng'onda nabhatenda nike bhubhajhahike mighonda bhala? ");
INSERT INTO dne_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Nahika na kwakoma bhubhalema bhala, na kwapekeya bhange ng'onda gwenio.” Na bhando pubhajhohina ghenagha, bhajhakulonge, “Naha ndeka, gheniya ghakotoka kupitila!” ");
INSERT INTO dne_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nambo Yecho ajhakwalolekeya na kwakonya, “Bho, Majhandiko ghanga gha Chapanga mana jhake nike? ‘Lighanga lilikanwitwe na bhibhachenga, ngoheno ndi lighanga likolongwa lya nchinge!’ ");
INSERT INTO dne_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mundo jhojhoha anda agwelile panane jha lighanga lyenio naheketwa imbembela imbembela, na lighanga lyenio anda ligwelikile mundo jhojhoha naliyogha yoghoyogho.” ");
INSERT INTO dne_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bhabhola bha Malaghalikilo na Akapiya matambiko bhakolo, bhapata bhankamulikii papa, nhwalo bhakamanye apiita nnandanikiho gwenio gwakochita kumwojho. Nambo bhajhogwipa bhando. ");
INSERT INTO dne_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bhahe, bhajhakupalaha lichaa lya mbone. Bhajhakwatuma bhando bhakitende bhaumbone kwa chwinda, bhanyonje Yecho kwa machwale, na bhahoto kunkamula na bhapeleke kwa munahota nkolongwa jwa ku Loma. ");
INSERT INTO dne_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bhando bhala bhajhakunkonya Yecho, “Mmola, tumanyite chimulongela na mibhola ilebhe ya uchakaka, hilu miningukiya ndeka mundo pamiho, nambo mibhola kwa uchakaka ndela jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bhahe, tunkonye, bhole yamaha amu yamaha ndeka kulepa kode kwa munahota nkolongwa jwa ku Loma liina lyake Kaichale?” ");
INSERT INTO dne_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nambo Yecho akamanye nginyika yabhe, ajhakwalobholela, ");
INSERT INTO dne_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Unangiye chente jha mbijha. Bho, chula jhenje na liina limulihwene lya ghane?” Ngabhanyangwila, “Ndi Kaichaile nkolongwa jwa ku Loma.” ");
INSERT INTO dne_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Peniya Yecho ajhakwalobholela, “Chikibhii cha nkolongwa jwa ku Loma munekele jwenio nkolongwa jwa ku Loma, na chikibhii cha Chapanga munekele jwenio Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bhakannyonjite ndeka kwa lilobhe lyolyoha kuhumii palonge jha bhando. Na bhajhakukangachwa nako majhangulo ghake. ");
INSERT INTO dne_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Machadukayo bhange, bhilongela bhubhawile nabhayoka ndeka, bhajhakunnyendelela Yecho na kunkonya, ");
INSERT INTO dne_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mmola, Mucha akatujhandikile, ‘Anda nnongo jwa mundo awile na annekite nhwana mundo changa mwana, ipalwa nnongo mundo amujhila nawela jwenio, apapila yana nnongo mundo.’ ");
INSERT INTO dne_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bhakibha akalongo mundo chaba. Jhola jwakutumbula ajhakubhujhila lipwela lela na paligha kuwegha changaleka mwana. ");
INSERT INTO dne_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jhubhele kubhelukwa, na jwenio ajhakumujhila lipwela lela, ajhakuwegha changa mwana hele, ");
INSERT INTO dne_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Peniya jwa utato jhola ajhakumujhila lipwela lela, helahela akampapii jhe mwana, bhoha chaba bhakawile, changapapa yana. ");
INSERT INTO dne_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kukutila kwake, mwikeghe jhola na jwenio helahela ajhakujhomoka. ");
INSERT INTO dne_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ngohe bhole, machiko gha kuyokechwa pughapala kuhika, mwikeghe jwenio nabhaha nhwana gwa ghane? Nhwalo bhoha chaba bhakantolile.” ");
INSERT INTO dne_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yecho ngabhajhangwila, “Bhando bha nnema ghongo bhitolela na kutolelwa. ");
INSERT INTO dne_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nambo kwa bhala Chapanga abhabhone bhihoto kujhingii munnema ghuhika na muyokecho nabhatolela jhe amu kutolelwa. ");
INSERT INTO dne_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Chakaka, nabhawe ndeka kabhele, nhwalo nabhalandana na akatumiche bha kunane kwa Chapanga, bheniya ndi yana ya Chapanga, nhwalo bhayokichwe kuhumii kubhawile. ");
INSERT INTO dne_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nambo kulonge kuyoka kwa bhando bhubhawile na bhene nabhayokichwa, Mucha akatulongalile mu Majhandiko gha Chapanga. Pa kiheghejha chikijhakita mwotu, ajhakulonge Bhambo Chapanga ngita, Chapanga jwa Ulahimo na Chapanga jwa Isaka na Chapanga jwa Yakobu. ");
INSERT INTO dne_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bhahe, jwenio Chapanga jwa bhando bhubhawile ndeka, nambo jwenio ndi Chapanga jwa bhando bhibhabhii na ughome nhwalo bhilama na jwenio.” ");
INSERT INTO dne_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bhabhola bha Malaghalikilo bhange bhajhakulonge, “Mmola, nnongii hotuhotu hake!” ");
INSERT INTO dne_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Na bhene bhakajhighite jhe kunkonya machwale ghange. ");
INSERT INTO dne_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Peniya Yecho ajhakwakonya, “Bhando bhilonge bhole, Kilichitu ndi mwana gwa Daude?” ");
INSERT INTO dne_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","“Nhwalo Daude jwenio alongii mbone mukitabo chake cha Zabule, ‘Bhambo akannobholile Bhambo gwango, Ntame mu lubhoko lwango lwalelo, ");
INSERT INTO dne_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ade nabheke makoko bhino pahe jha makongono ghino ngita kigoda cha kujheghemekeya makongono.’ ");
INSERT INTO dne_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Anda Daude ankema jwenio, ‘Bhambo,’ ngohe nahibhaha bhole Kilichitu kubhehe Mwana mundo?” ");
INSERT INTO dne_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yecho ajhakwalobholela bhabholwa bhake, palonge jha bhando bhoha, ");
INSERT INTO dne_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mukichunge na bhabhola bha Malaghalikilo, upala kupetapeta kongo bhakiwalile makanjo matandamaho na kujhambuchwa kwa kutembekewa mumaghuliho, na kutama migoda ya utembekeho munyumba jha kukonganikii Akayahude, helahela bhipala kutama migoda ya utembekeho ya muunyagho gwa kulyegha. ");
INSERT INTO dne_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na kwajhibhila akakeghe akanawela, na kukikopokeya kwa kukitenda bhaumbone, kongo bhakilangiya kwa bhando kunnyopa Chapanga kwa malobhe gha mahena. Bheniya nabhahadabulwa kupeta bhange!” ");
INSERT INTO dne_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yecho palolokiya kulingukiya ajhakwammona mundo jwabhii na ilebhe yamahele palekila mbijha mukichukilo chu kubheke litambiko pa Nyumba jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Helahela ajhakummona majhe jhumo nawela, nhocho ajhakupiya chente ibhele ya mbijha. ");
INSERT INTO dne_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yecho ajhakwalobholela bhabholwa bhake, “Ninnobholela chakaka, nawela jwenio, apihite kuliku bhange. ");
INSERT INTO dne_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Nhwalo bhoha bhapihite kubhoka mu majhonjekeko ghabhe, nambo majhe hojho nhocho akung'winde yoha yabhii nako.” ");
INSERT INTO dne_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bhabholwa bhange bhalongila panane jha Nyumba jha Chapanga, chichengwite kwa maghanga ghambone, helahela bhalongila matambiko ghighapihitwa na bhando kwa Chapanga. Nambo Yecho ajhakulonge, ");
INSERT INTO dne_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ghanga ghoha ghubhaghabhona, machiko ghabhikuhika, libhiijhe hilu lighanga lilipala kuhighalika panane jha lenge, kila kilebhe nakiyangabhanwa.” ");
INSERT INTO dne_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bhahe, bhando bhajhakunkonya Yecho, “Mmola, naghapitila legha mambu ghanga? Bho, na nginyililo ghane jhipala kulangiya kuhika kwino?” ");
INSERT INTO dne_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yecho ajhakwajhanguu, “Mukilolekeye bhakotoka kunkopokeya. Nhwalo bhamahele nabhahika kwa liina lyango, nabhalongela, ‘Jwenio ndi nenga!’ Na ‘Machiko ghala ghabhandikile!’ Nambo mwangakengama. ");
INSERT INTO dne_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bhahe, pumipala kujhoha malobhe gha ngondo na lihangambwela, mangajhoghopa, nhwalo ilebhe yenio naitumbula kupitila, Nambo kujhomokela kwake kwamela.” ");
INSERT INTO dne_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Peniya Yecho pajhendilila kulonge, “Kilambo chimo na akakomana na bhando bha kilambo chenge, na unahota nkolongwa ghumo naukomana na unahota ghonge. ");
INSERT INTO dne_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Napapitila mindimilo mikolongwa pannema na njala na malwalo. Naghapitila mambu gha kujhoghopwa na nginyililo ngolongwa kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nambo naghalapiti hote jhe gheniya, nabhankamula na kuung'aha na kupelekangana mu Nyumba jha kukonganikii Akayahude na kutabhangana mukipungo, nabhampeleka palonge jha akanahota na ilongoche, kwa nhwalo gwa liina lyango. ");
INSERT INTO dne_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jhenje ndi pwache jha kwalangiya Lilobhe lya Mbone bheniya. ");
INSERT INTO dne_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nambo nkotoka kubhehe na kiholo ku mwojho nanongela nike kabula jha kukikengelela. ");
INSERT INTO dne_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nhwalo namwete naninpela malobhe gha kulonge na malango. Hilu makoko bhino nabhahotola ndeka kukwima na kukana ghala ghumulongela. ");
INSERT INTO dne_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mangota nanyambilwa na akatate bhino na akalongo bhino na akakoche bhino, na bhange pakate jhino nabhakomwa. ");
INSERT INTO dne_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bhando bhoha nabhanchimwa mangota nhwalo gwa liina lyango. ");
INSERT INTO dne_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nambo, hilu lijhunjo limo lya pamuto gwino nalihobhelela ndeka. ");
INSERT INTO dne_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kwa kuhimbilila kwino namukombola ughome gwino. ");
INSERT INTO dne_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pumpala kwabhona akakomana ngondo bhautindile muche gwa ku Yeluchalemo, umanya kubhehe machiko ghabhandikile gha kutilulwana kwake. ");
INSERT INTO dne_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Peniya bhando bhubhabhii ku Yudeya bhabhutikila ku kitombe na bhando bhibhabhii pakate jha muche bhatilila panja jha muche na bhando bhibhabhii kunghonda bhakotoka kujhingila ku bomane. ");
INSERT INTO dne_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nhwalo machiko gheniya ndi machiko gha kuhadabulwa, ghoha ghighajhandikwe mu Majhandiko gha Chapanga ghalenganike. ");
INSERT INTO dne_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nakole kiya bhubhii na ndumbo na bhibhajhongecha kwa machiko gheniya! Nhwalo napabhehe na mang'ahiko makolongwa na lilaka lya Chapanga nabhahadabula bhando bheniya. ");
INSERT INTO dne_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bhange nabhakomwa kwa upanga na bhange nabhapukilwa ngita akapungwa na kupechenganwa mu ilambo yoha. Helahela bhando bhangabhehe bhu ku Yeluchalemo nabhalebheta ade lichiko lyabhe pulipala kuhika. ");
INSERT INTO dne_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Peniya napabhaha nginyililo mu lyobha na mu mwehe na mu ndondwa. Bhando bha pannema nabhabha na malagho kwa nhwalo gwa bhoghohe ghuletwa kuhumii mu milindimilo jha mbwane na matuhe ghake gha mache. ");
INSERT INTO dne_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bhando nabhahinduka kwa bhoghohe, bhakilola nike chikipala kuukolela nnema, nhwalo ilebhe yoha ya kunane kwa Chapanga nainyukanyuka kwa makakala. ");
INSERT INTO dne_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Peniya ndi, nabhamona Mwana gwa Mundo akahuluka mumahunde, na makakala na ulumbililo nkolongwa. ");
INSERT INTO dne_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Puhipala kutumbula kupitila ilebhe yenio, nnyemengane na kujhinula mabhonge ghino kunane, nhwalo ughombokeko gwino ubhandikile.” ");
INSERT INTO dne_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Peniya Yecho ajhakwalobholela nnandanikiho ghongo, “Mulolekehe nkongo gwa nkojho na mikongo jhenge jhoha. ");
INSERT INTO dne_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Putumbula kutundula mahamba, mabhene umanye mahuno ghabhandikile. ");
INSERT INTO dne_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Helahela mangota pumipala kubhona ilebhe yenio ikahengeka umanya kubhehe ndi unahota nkolongwa ubhandikile. ");
INSERT INTO dne_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ninnobholela chakaka, bhando bha kibheluko chenje nabhawe ndeka ade ilebhe yenio ipitile. ");
INSERT INTO dne_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kunane kwa Chapanga na nnema nakupeta, nambo malobhe ghango naghapeta ng'o. ");
INSERT INTO dne_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mme miho! Miojho jhino jhikotoka kukamulwa na kuhapa, kulobhela na kupikiya miho ilebhe ya mukilambo mone. Na lichiko nalihikilila kwa kupwitikilila pwitu ngita ntambo pugwijhonja. ");
INSERT INTO dne_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nhwalo nalyapwitikilila ngita ntambo bhando bhoha bhibhatama kila chehemo jha nnema. ");
INSERT INTO dne_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mukilolekeye na nnyope machiko ghoha na kubhehe likakala lya kujhomboka njelembo kwa mambu gheniya ghoha ghighapala kupitila, na kujhema palonge jha Mwana gwa Mundo.” ");
INSERT INTO dne_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Machiko ghoha Yecho akibha mukubhola bhando pa Nyumba jha Chapanga, na kilo ajhahwila ku kitombe chuku Micheitune na kutama kwenio. ");
INSERT INTO dne_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bhando bhoha bhatehila kulabha kujhenda pa Nyumba jha Chapanga kunnyokanikiya Yecho. ");
INSERT INTO dne_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Unyagho gwa mabumunda ghangaleke ngedule, jhikemitwa Pachaka piheghelila. ");
INSERT INTO dne_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo bhapaliya ndela jha kinyemela jha kunkoma Yecho, nambo bhajhogwipa bhando. ");
INSERT INTO dne_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bhahe, Limbembela lijhakunyingilila Yuda, jwakemitwa Isikaliyote, ndi jhumo jwa bhabholwa bhake bhala kome na bhabhele. ");
INSERT INTO dne_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yuda ajhakujhenda kwa akapiya matambiko bhakolo na akalonda Nyumba jha Chapanga, ajhakulonge nabho ndela jha kunnyambii Yecho. ");
INSERT INTO dne_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bhene bhajhakuhanganila hake na kulaghalana na Yuda nabhampela mbijha kwa lihengo lyenio. ");
INSERT INTO dne_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yuda ajhakujheketila, peniya ndi patumbwila kupalaha ndela jhamaha jha kunnyambila Yecho, lilongo lya bhando changamanya. ");
INSERT INTO dne_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bhahe, lichiko lya mabumunda ghangalekela ngedule pulihikita. Lichiko lyenio ndi lichiko lya kuchinja katole kalimbelele kakulye pa Unyagho gwa Pachaka. ");
INSERT INTO dne_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Peniya Yecho ajhakwatuma Petile na Yohane, ajhakwalobholela, “Nnyendengane mukatulinganikiye chakulye Pachaka.” ");
INSERT INTO dne_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bhahe, na bhene pubhankonyita, “Mipala tujhende kojhe tukalenganikiye?” ");
INSERT INTO dne_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yecho ajhakwalobholela, “Unyokanikiye, pumujhingila pabomane nankongana na likambako jwatwekile kihulo cha mache. Jwenio ndi mukengemila ade munyumba jhajhingila. ");
INSERT INTO dne_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nkolo nyumba munnobholela, ‘Mmola ankonya, chumbi cha akaghene kibhii kojhe, chakulyegha Pachaka pamonga na bhabholwa bhango?’ ");
INSERT INTO dne_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jwenio nanangiya chumbi kikolongwa cha ku gholofa chikikilimwe mbone, nnenganikila mwenio.” ");
INSERT INTO dne_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bhahe, bhajhakujhenda, na kukikolela kila kilebhe telatela ngita chabhalaghalikiye Yecho, na bhene ndi pibhatumbwila kulenganikiya chakulye Pachaka. ");
INSERT INTO dne_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lichaa lya kulyegha puliikita, Yecho ajhakwatola akatenga bhake na kutama nako kulyegha. ");
INSERT INTO dne_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ajhakwalobholela bheniya, “Noghii hake kulye Pachaka pamonga na mangota, kabula jha mang'ahiko ghango. ");
INSERT INTO dne_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ninnobholela chakaka, nilye ndeka kabhele ade puipala kulenganikiya mu Unahota nkolongwa gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yecho ajhakutola kibaba cha divaye, na kunchenguu Chapanga, alongila, “Mmaghana mabhoha. ");
INSERT INTO dne_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ninobholela, kutumbulii ngohe, nanywe jhe kabhele divaye jhenje, ade Unahota nkolongwa gwa Chapanga pala puupala kuhika.” ");
INSERT INTO dne_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bhahe, ajhakutola libumunda, ajhakunchenguu Chapanga, ajhakumetula na kwabhaghanichila, alongila, “Jhenjeno ndi yegha jhipelwa mangota. Ntenda naha kwa kungomboka nenga.” ");
INSERT INTO dne_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Helahela akatei ndalilo, “Ajhakwapekeha kibaba cha divaye alongela, chenjeno ndi kibaba cha lilaghano liyono lya Chapanga lilijhemelelwa na miyahe jhango, jhijhitika kwa nhwalo gwino mangota. ");
INSERT INTO dne_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Nambo, umanye! Mundo jwambala kunyambila nenga minako pakiheneko pano! ");
INSERT INTO dne_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chakaka Mwana gwa Mundo nahwa ngita chilengankilwe, nambo nalola choto mundo jhola jwapala kunnyambila!” ");
INSERT INTO dne_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bhajhakutumbula kukonyana achi bhene chika, ndi ghane pakate jhito jwahipala kuhenga kilebhe chenie. ");
INSERT INTO dne_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Helahela bhabholwa bhake Yecho bhajhakutumbula mitabho pakate jhabhe ghane jwaholelelwa kubhehe nkolongwa kuliku bhange. ");
INSERT INTO dne_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yecho ajhakwalobholela, “Akanahota akakolonga bha bhando bha ilambo henge ubhalongocha bhando kwa makakala, na bhala bhina ukolonga ukitina liina lya ‘Akakoche bha bhando.’ ");
INSERT INTO dne_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nambo mangota ghakotoka kulandana na bheniya. Nambo jwabhii nkolongwa pakate jhino abhaha jwandina kuliku bhoha, na kilongoche abhaha mundo jwabhahengela bhoha. ");
INSERT INTO dne_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bho, ndi ghane jwabhii nkolongwa? Bho, jwaitama pakulyegha amu jwalenganikiya chakulyegha? Chakaka jhola jwaitama pakulyegha. Nambo nenga mii pakate jhino ngita natumiche.” ");
INSERT INTO dne_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mangota ndi bhuhighalike pamonga na nenga mumang'ahiko ghango.” ");
INSERT INTO dne_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngita Tate, chahagwii nenga kulongocha ngita munahota nkolongwa, na nenga nipelingine mangota hele unahota nkolongwa. ");
INSERT INTO dne_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Peniya, nanyakila na kunomenekeya pamonga munahota nkolongwa gwango na kutama muigoda ya unahota nkolongwa na kulongocha makabila kome na mabhele gha Ichilahele. ");
INSERT INTO dne_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yecho palongila, “Ma Simone, Ma Simone! Jhokanikiya! Limbembela apala kunyembeluya ngita mponga. ");
INSERT INTO dne_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nambo nenga ninyope mwenga Simone, hilu kihobholelo chino kikotoka kuhokeka. Na mwenga pumpala kumujhila kabhele matangatila akalongo bhino.” ");
INSERT INTO dne_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petile ajhakunnobholela, “Bhambo, nanjino nyeketile kupungwa na mwenga amu bhatukoma tugha pamonga kilebhe jhe!” ");
INSERT INTO dne_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yecho ngalongila, “Ninnobholela ma Petile, lijhogholo nakubhekajhe naunganila patato.” ");
INSERT INTO dne_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Peniya Yecho ajhakwakonya bhabholwa bhake, “Bho, punitumingina changaghegha mbijha amu lihako amu changahwala maghubache nike mukapongokiwe?” Bhajhakujhanguu, “Tukapongokiwe ndeka kilebhe.” ");
INSERT INTO dne_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yecho ajhakwalobholela, “Nambo kutumbuli ngoheno, mundo jwabhii na mbijha aghegha, na jwabhii na lihako helahela aghegha. Na jhola jwanga mbopo akachuluche ngobho yake na ajhende akahemela mbopo jhimo. ");
INSERT INTO dne_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nhwalo ghabhii lengalenga mu Majhandiko gha Chapanga ghilonge, ‘Na jwenio nabhalangilwa pamonga na bhando bhibhatenda ghanganandela.’ Ninnobholela ghoha ghughajhandikwe kwa nhwalo gwa nenga ghapile ghapitile.” ");
INSERT INTO dne_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bhabholwa bhake ngabhanongolila, “Bhambo, dola pambano ibhii mbopo ibhele.” Jwenio Yecho ngajhangwila, “Bhahe, ikwela!” ");
INSERT INTO dne_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yecho ajhakubhoka ngita chakayobhalile, na kujhenda ku kitombe chuku Micheitune na bhabholwa bhake bhajhakubhehe pamonga. ");
INSERT INTO dne_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pubhahikita kwenio, ajhakwalobholela bhabholwa bhake, “Munyopengane Chapanga, nkotoka kujhingii mumajhighanikilo.” ");
INSERT INTO dne_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Peniya ajhakwaleka, na kujhenda kutale ngita mundo ajhuhite lighanga kuliponile. Na kutama makilikite anyopa Chapanga, ");
INSERT INTO dne_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","alongila, “Ma Tate, anda mipala umokehe kibaba chenjeno cha malagho. Nambo chi ngita chinipala nenga, nambo ngita chimipala mabhene.” ");
INSERT INTO dne_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bhahe, ntumiche jwa kunane kwa Chapanga, ajhakupitila na kukangamalicha. ");
INSERT INTO dne_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yecho nhwalo akibha mulipyanda, ajhakunyopa hake Chapanga. Lihuke lyake likibha ngita mandonye gha miyahe ghahololila pahe. ");
INSERT INTO dne_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pajhomolila kunnyopa Chapanga, ajhakwajhendela bhabholwa bhake. Ajhakwakolela bhagholwike, nhwalo gwa ungolongonde. ");
INSERT INTO dne_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yecho ajhakwalobholela, “Nhwalo gwa nike migholoka? Jhimukana munyopengane Chapanga, nkotoka kujhingii mumajhighanikilo.” ");
INSERT INTO dne_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Pajhendilila kulonge, lilongo lya bhando lijhakupitila kongo lilongochwa na Yuda, jwakibha jhumo jwa bhabholwa bhake bhala kome na bhabhele. Ajhakuheghelela Yecho na kunkumbatila. ");
INSERT INTO dne_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nambo Yecho ajhakunnobholela, “Yuda, nhwalo gwa nike munyambi Mwana gwa Mundo kwa kunkumbatila?” ");
INSERT INTO dne_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bhabholwa bhake bhala bhalolikiya ghughapala kupitila bhajhakunnobholela, “Bhambo, bho, twapyeke kwa mbopo?” ");
INSERT INTO dne_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jhumo pakate jhabhe ajhakuntyala ntumiche jwa Mpiya litambiko nkolo, na kuheketa lichikilo lyake lya lubhoko lwalelo. ");
INSERT INTO dne_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nambo Yecho palongila, “Nkoto kuhenga kabhele!” Ajhakupapaa lichikilo lya mundo jhola, ajhakulama. ");
INSERT INTO dne_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Peniya Yecho ajhakwalobholela Akapiya matambiko bhakolo na ilongoche ya ulonda gwa Nyumba jha Chapanga na ighogholo bhubhakahikite kunkamula, “Bho, uhikingine na indukwa na mbopo, pimihambuka nenga nipoka ilebhe kwa makakala? ");
INSERT INTO dne_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Machiko ghoha ndamita na mangota mwenga pa Nyumba jha Chapanga mukangamwi ndeka. Nambo lende ndi lichaa lya makakala gha lubhendo, kulongocha.” ");
INSERT INTO dne_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Peniya bhajhakunkamula Yecho na kujhenda nako ade ku nyumba jha Mpiya litambiko nkolo. Petile akengemila kachoko chukutale. ");
INSERT INTO dne_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pakate jha mulwane lwa nyumba bhakakungine mwotu, na bhoha bhajhakutamangana peniya kujhota, na jwenio Petile akibha pakate jhabhe. ");
INSERT INTO dne_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ntumiche jhumo mwikeghe pamonita Petile aheghelii pahina jha mwotu, ajhakuningukiya na kulonge, “Mundo hojho chakaka akibha pamonga na Yecho!” ");
INSERT INTO dne_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nambo Petile ajhakunkanila, alongila, “Gwe majhe, niumanyite jwenio!” ");
INSERT INTO dne_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Machaa pughachochita kujhenda, mundo jhonge, ajhakubhona Petile na jwenio ngalongila, “Mwenga ndi jhumo pakate jhabhe!” Nambo Petile pajhangwila, “Munahota, ne ndeka!” ");
INSERT INTO dne_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lichaa limo pulipetita, mundo jhonge ajhakupitila na kulonge helahela, “Chakaka mundo jhonjo bhahwelita pamonga na jwenio, helahela ahumii ku Galilaya!” ");
INSERT INTO dne_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nambo Petile pajhangwila, “Gwe mundo, chimulongela nikimanyi ndeka!” Palongela gheniya, lijhogholo lijhakubheka. ");
INSERT INTO dne_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bhambo Yecho ajhakughalambukila na kunnolekeya Petile. Peniya ndi Petile pakombwika malobhe ghalongila Bhambo ghala, “Deleno lijhogholo na kubhekajhe, naungannila patato.” ");
INSERT INTO dne_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petile ajhakupita panja jha ubhegho na kulela kwa ungolongonde. ");
INSERT INTO dne_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bhando bhubhanendelila Yecho bhala, bhajhakuntende chanake na bhajhakuntyala. ");
INSERT INTO dne_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bhahibhite miho kwa kitambala, kone bhankonyita, “Nnotele! Bho, ghane jwatyalite?” ");
INSERT INTO dne_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Peniya bhajhakulonge malobhe twe gha kunigha. ");
INSERT INTO dne_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pukuchila tugha, ighogholo na akapiya matambiko bhakolo na bhabhola bha Malaghalikilo bhajhakukonganika pamonga, bhajhakumpeleka Yecho pa bwalo jha Kiyahude. ");
INSERT INTO dne_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ngabhannobhalila, “Bho, mutulobholele, mwenga ndi Kilichitu Nkomboche?” Nambo Yecho ngabhajhangwila, “Hilu ninnobholele, mangota naunyangula jhe. ");
INSERT INTO dne_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Anda nikonyite, naunyangula ndeka. ");
INSERT INTO dne_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nambo kutumbuli ngoheno na kujhendelela, Mwana gwa Mundo natama lubhoko lwalelo lwa Chapanga jwabhii na makakala.” ");
INSERT INTO dne_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Peniya bhoha bhajhakunkonya, “Bho, mwenga ndi Mwana gwa Chapanga?” Jwenio Yecho ngabhajhangwila, “Chakaka, ngita chimulongela.” ");
INSERT INTO dne_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bhene bhajhakulonge, “Bho, tupala mundo jhonge alonge panane jha mambu ghake? Twabhete tujhohine malobhe ghalongila jwenio!” ");
INSERT INTO dne_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bhahe, lilongo lyoha lya bhando bhajhakumpeleka Yecho palonge jha Pilatu. ");
INSERT INTO dne_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bhajhakutumbula kuntakalila bhalongila, “Tumwehine mundo hojho abhahobhecha bhando bhito. Na kabhele abhahibhilikiya bhando bhakotoka kupiya kode kwa munahota nkolongwa jwa ku Loma, na jwenio akikema ndi Kilichitu, Munahota nkolongwa.” ");
INSERT INTO dne_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatu ajhakunkonya Yecho, “Bho, mwenga ndi Munahota nkolongwa jwa Akayahude?” Yecho ngajhangwila, “Chakaka mwenga ndi milongela.” ");
INSERT INTO dne_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Peniya Pilatu ajhakwalobholela akapiya matambiko bhakolo na lilongo lya bhando, “Nikihwene ndeka chalemwite mundo jhonjone.” ");
INSERT INTO dne_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nambo bhene bhajhakukangamala bhalongila, “Kwa mabholo ghake abhakokolekeya bhando bhataungane na unahota nkolongwa gwa ku Yudeya. Atumbulii ku Galilaya ade kongo.” ");
INSERT INTO dne_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatu pajhohina gheniya, ajhakukonya Yecho, “Bho, mundo jhonjo jwa ku Galilaya?” ");
INSERT INTO dne_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilatu pamanyita Yecho ahumii ku kilambo chikilongochwa na Helode, ndi ajhakupeleka kwa Helode, jwakibha ku Yeluchalemo kwa machiko gheniya. ");
INSERT INTO dne_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Helode pamwonita Yecho akahanganii hake nhwalo kwa machiko ghamahele apata ammone, akajhohine malobhe ghake, akibha ahobholila Yecho ahenge ilebhe ya kukangacha. ");
INSERT INTO dne_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bhahe, Helode ajhakunkonya machwale ghamahele, nambo Yecho akajhangwii jhe. ");
INSERT INTO dne_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Akapiya matambiko bhakolo na bhabhola bha Malaghalikilo bhubhajhemita peniya, bhajhakughagha kwa likakala Yecho atakalilwe. ");
INSERT INTO dne_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bhahe, Helode na akakomana ngondo bhake bhajhakuntendela Yecho ghanganandela na chanake, peniya bhajhakuwalicha ngobho yambone ngita munahota nkolongwa na kumujhicha kwa Pilatu. ");
INSERT INTO dne_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kuhumii peniya, Helode na Pilatu bhajhakubhehe maghumba nde, nambo makacho bhakibha mu maghonga. ");
INSERT INTO dne_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatu ajhakwakema pamonga akapiya matambiko bhakolo na ilongoche ya bhando, ");
INSERT INTO dne_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","peniya ajhakwalobholela, “Munetite mundo jhonjo kwa nenga ngita mundo jwahobhecha bhando bhakomane na unahota nkolongwa gwa ku Loma. Nenga nikonyite palonge jhino, nambo kibhiijhe chalemwite mu matakalilo ghake. ");
INSERT INTO dne_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jwenio Helode atubhujhichile helahela twenga, nhwalo akiwejhe chalemwite. Peniya mundo hojho atehi ndeka kilebhe chochoha chikimpala akomwe. ");
INSERT INTO dne_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Bhahe, nanichwapula luyato lwa ndomondo na kunekekehe ajhende.” ");
INSERT INTO dne_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nhwalo Pilatu achokolikiya adindulile mpungwa jhumo paunyagho gwa Pachaka. ");
INSERT INTO dne_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nambo lilongo lyoha lya bhando lijhakunonoha malobhe, “Mumohe pamba! Na mutudindulile Balaba!” ");
INSERT INTO dne_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balaba akatabhitwe mukipungo kwa kuhenga majhoghe ghighakapitile kubomane helahela nhwalo gwa kukoma bhando. ");
INSERT INTO dne_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bhahe, Pilatu akapahile kunekekeya Yecho, peniya ndi ngalongila nabho kabhele. ");
INSERT INTO dne_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nambo bhene bhajhakuchocha kunonoha malobhe, “Mumambe panchala! Mumambe pachalaba!” ");
INSERT INTO dne_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bhahe, Pilatu ajhakulonge mala jha utato na kwakonya, “Bho, nhwalo gwa nike? Bho, kilebhe ghane chalemwihe mundo hojho? Nikihwe ndeka chalemwite chikimpala akomwe. Bhahe, nanichwapula luyato lwa ndomondo na kunekekeya ajhende.” ");
INSERT INTO dne_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Nambo bhajhakujhendelela kuchobhela hake, bhapata Yecho abhambwe panchalaba. Na kwa kuchobhela kwabhe bhajhakuntenda Pilatu ajheketele. ");
INSERT INTO dne_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bhahe, Pilatu ajhakulonge, unhenge ngita chimipala kuhenga. ");
INSERT INTO dne_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ajhakwadindulila mundo jhola jhubhampalita, jwakibha mukipungo kwa nhwalo gwa kuhenga majhoghe na kukoma, na kumpiya Yecho bhantende ngita chibhapala. ");
INSERT INTO dne_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pibhakibha bhampelika, bhajhakukongana na mundo jhumo liina lyake Simone jwabhelekilwe kuchenda jha ku Kilene, jwahumila kunng'onda. Bhajhakunkamula na kungheghecha nchalaba pahyeto jha Yecho. ");
INSERT INTO dne_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lilongo likolongwa lya bhando lijhakunkengama Yecho, pamonga na akakeghe bhibhakibha bhakwindikina na kunnelela Yecho. ");
INSERT INTO dne_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nambo Yecho ajhakwaghalambukila na kwalobholela, “Makakeghe bhu ku Yeluchalemo! Nkotoka kunelela nenga, mukilelela mabhene na yana hino. ");
INSERT INTO dne_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nhwalo machiko naghabhandikila, bhando nabhalongila, ‘Mbaha kwa mwikeghe jhola jwangamwana, na ntonga, hilu mabhele ghangajhongecha!’ ");
INSERT INTO dne_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lichaa lyenio, ndi bhando nabhatumbula kulonge, itombe, ‘Mututilukile!’ Na ihogholo ‘Mutuyekelele!’ ");
INSERT INTO dne_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Anda bhando bhautendi naha nkongo mmehe, bho, naibhaha bhole kwa nkongo nnyomo?” ");
INSERT INTO dne_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Helahela bhajhakwatola bhando bhabhele bhibhatenda ghanganandela, bhakapelikwe bhakomwe pamonga na Yecho. ");
INSERT INTO dne_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pubhahikita chehemo jhikemwa, “Libhonge lya muto,” peniya ndi bhajhakumamba Yecho pamonga na bhibhatehila ghanganandela kila jhumo na nchalaba gwake, jhumo lubhoko lwalelo na jhonge lubhoko lwa ngejha lwa Yecho. ");
INSERT INTO dne_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yecho palongila, “Tate gwango, mwalekekehe nhwalo bhamanyite jhe chibhatenda.” Peniya akalonda bhala bhajhakubhaghana ngobho yake kwa kahumbuumbu nnobhole. ");
INSERT INTO dne_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bhando bhibhakajhemite peniya kulolekeya, na bhene ilongoche ya Kiyahude bhantendela chanake. Bhalongila, “Abhakombwila bhando bhange, akikombole jwenio, anda jwenio ndi Kilichitu Nkomboche jwahaghulilwe na Chapanga!” ");
INSERT INTO dne_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Helahela akakomana ngondo bhajhakuntendela chanake, bhajhakuheghelela na kumpekeya divaye jhibhabha, ");
INSERT INTO dne_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","bhalongila, “Anda chakaka mwenga ndi Munahota nkolongwa jwa Akayahude, mukikombole mabhene!” ");
INSERT INTO dne_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na panane jha nchalaba gwake pakajhandikwe malobhe ghanga, “Jhonjo ndi Munahota Nkolongwa jwa Akayahude.” ");
INSERT INTO dne_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mwihe jhumo pakate jha bhala bhabhele ajhakunigha Yecho, alongila, “Bho, mwenga ndi Kilichitu? Mukikombole mabhene na mutukombole na twenga!” ");
INSERT INTO dne_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Nambo mwihe jhonge jhola ajhakupwatalila nnyake anongolila, “Gwe bhole, munendema jhe Chapanga? Na mabhene bhahadabwii ngita jwenio. ");
INSERT INTO dne_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mwenga na nenga bhatuadabwii chipalwa, tupokile malepo ghaghala ghutuhengita. Nambo mundo hojho kibhiijhe kilebhe chalemwite.” ");
INSERT INTO dne_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Peniya nganongolila Yecho, “Yecho, ungotoka kunyehwa pumipala kubhehe Munahota nkolongwa gwino!” ");
INSERT INTO dne_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yecho ngajhangwila, “Ninobholela chakaka, kutumbulii ngoheno, natubhaha pamonga na nenga chehemo jha kukangacha jhikemwa ku pepo.” ");
INSERT INTO dne_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bhahe, Pihikila muhe jha chaa chita, lubhendo lujhakukamulana tyoo pa kilambo choha ade chaa ticha. ");
INSERT INTO dne_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Peniya lipanjiya lilihibhikiya pa Nyumba jha Chapanga lijhakujwepuka jwee ipande ibhele kutumbulii kunane ade pahe. ");
INSERT INTO dne_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yecho ajhakubohoma kanonoha, “Tate gwango, mu mabhoko ghino nibheka uhuke gwango!” Palongila gheniya, ajhakubhehe kakalile. ");
INSERT INTO dne_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jhola nkolo jwa bhakomana ngondo palolita ghighatendika peniya, ajhakunnomba Chapanga alongila, “Chakaka mundo jhonjo akibha jwaumbone!” ");
INSERT INTO dne_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bhahe, lilongo lyoha lya bhando pubhalolita ghighakatindike, bhajhakujhenda bhabhii ngolongonde hake. ");
INSERT INTO dne_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nambo bhando bhoha bhubhakamanyite Yecho bhalingulila chukutale, bhaghalolekehe mambu ghanga. Pakate jhabhe bhakibha akakeghe bhalongohina nabho kuhumii ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Pakibha na mundo jhumo liina lyake Uchupo, kuhumii ku muche gwa Alimataya ku chenda jha ku Yudeya. Akibha jhumo jwa nkolo jwaumbone pa Bwalo jha Akayahude. ");
INSERT INTO dne_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nambo ahumii ku Alimataya, akajheketii jhe mambu gha pa Bwalo jha Akayahude pubhapata kunkoma Yecho na pubhalenganikiya kuhenga lyenio. Jwenio alolila machaa gha Chapanga pantumita munahota nkolongwa gwake kuhika kulongocha. ");
INSERT INTO dne_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bhahe, Uchupo ajhakujhenda kwa Pilatu kunnyopa atole malelo gha Yecho. ");
INSERT INTO dne_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ajhakuhulua malelo ghala kuhumii panane jha panchalaba, ajhakubhilingilila chanda ajhakughoneka umambe jhibhahokonyolile palindalabho, na mambe jhene ikibhajhe na malelo. ");
INSERT INTO dne_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iikibha lichiko lya Ijumaa ndi libhandikila lichiko lya kutumbula Kupomolela. ");
INSERT INTO dne_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akakeghe bhala bhubhalongohina na Yecho kuhumii ku Galilaya bhajhakunkengama Uchupo na bhajhakubhona mambe na yegha jha Yecho chibhekwite. ");
INSERT INTO dne_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Peniya pibhakelewika kajhabhe bhakalenganikiye mahuta ghighanungalila petelele. Na Lichiko lya Kupomolela, bhajhakutama hele ngita Lilaghalikilo chililaghalikiye. ");
INSERT INTO dne_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lichiko lya jumapile, putiputi akakeghe bhajhakughegha mahuta ghighanungila petelele ghibhakalenganikiye na kujhenda nagho ku mambe. ");
INSERT INTO dne_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bhajhakulikolela lighanga lela lya kuyekelela mambe libhilimbiwe kuupele jha mambe. ");
INSERT INTO dne_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nambo pubhajhingila nkate mu mambe, bhakaiwe ndeka yegha jha Bhambo Yecho. ");
INSERT INTO dne_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pubhajhendilila kukangacha nhwalo gwa kilebhe chenie, pahina jhabhe papa bhakajhemite bhando bhabhele bhibhawalalii ngobho nhuo ya mbuu. ");
INSERT INTO dne_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Akakeghe bhala bhajhakutumbula kulendema, bhajhakulita pahe. Peniya bhando bhala pubhalongila, “Nhwalo gwa nike mipalaha jwabhii na ughome pakate jha bhubhawile? ");
INSERT INTO dne_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Abhii jhe pambano, ayokite! Nkomboke channobholila pakibha amela ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Mwana gwa Mundo nakamulwa na bhando bhibhabhii na uhakaho, na bhene nabhamamba pa nchalaba na lichiko lyutato nayoka.’ ” ");
INSERT INTO dne_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Peniya, ndi akakeghe bhala pibhakombwika malobhe ghalongila Yecho, ");
INSERT INTO dne_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","pubhabhujhita kuhumii ku mambe, bhajhakulonge mambu ghanga ghoha ghughapitile kwa bhabholwa bhake kome na jhumo bha Yecho na bhando bhange. ");
INSERT INTO dne_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Akakeghe bhubhahikita kulonge gheniya kwa akatenga, akibha Maliya jwahumila ku kilambo chaku Magidala na Yoane na Maliya majhe mundo Yakobu, pamonga na akakeghe bhange bhubhakalongohine nabho. ");
INSERT INTO dne_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nambo bhabholwa bhala bhajhakughapucha malobhe. Bhahe, bhakajheketile jhe. ");
INSERT INTO dne_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Nambo Petile akajhenda mbelo ade ku mambe. Ajhakulita kulingukiya nkate, ajhakubhona nga ngobho jha malelo tugha. Peniya ngabhujhita ukajha kongo abhii hechu kwa gheniya ghughapitile. ");
INSERT INTO dne_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lichiko lele, bhabholwa bhabhele bha Yecho bhakibha mu kutyanga bhajhawila kuchenda jhimo jhikemwa ku Emau chikibhii utale kilomita kome na jhimo kuhumii ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bhakibha na malongeche gha ilebhe yoha itendike. ");
INSERT INTO dne_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Pubhajhendilila na malongeche ghabhe na kukikonya, Yecho jwenio ndi pabhandikila na kulongohana nabho pamonga. ");
INSERT INTO dne_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bhene bhakamwene kwa miho ghabhe, nambo bhakaumanyite jhe. ");
INSERT INTO dne_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yecho ajhakwakonya, “Mangota milongolelana nike, kongo mmii mu kutyanga?” Na bhene bhajhakujhema, kumiho jhabhe kujhakungamala kwa ungolongonde. ");
INSERT INTO dne_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mundo jhumo pakate jhabhe, liina lyake Kiliopa, ajhakunyangula, “Bho, mwe maghene kanjika chino pa muche gwa ku Yeluchalemo, umanyite ndeka ilebhe itendike machiko gha pahina ghano?” ");
INSERT INTO dne_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jwenio ngakonyita, “Ilebhe ghane kabhele?” Na bhene ngabhajhangwila, “Ilebhe ipambalikine Yecho jwa ku Nachalete. Mundo jwenio akibha nnondole jhuna likakala lya kuhenga na kubhola palonge jha Chapanga na kwa bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Akapiya matambiko na ilongoche hito bhajhakukamua kwa bhakolo bhu ku Loma bhahadabwii akomwe, na bhene bhajhakumamba panchalaba. ");
INSERT INTO dne_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nambo twenga tukahobholile jwenio ndi jwa kuhighombola Ichilahele! Kuchocha kwa gheniya deleno ndi lichiko lyutato kuhumii pubhatehila ilebhe yenio. ");
INSERT INTO dne_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Helahela akakeghe bhange kuhumii pakate jhito bhajhakutukangacha. Putiputi bhajhakujhenda ku mambe, ");
INSERT INTO dne_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","nambo bhakaikoli ndeka yegha jha Yecho. Bhajhakukelebhuka na kutulongelela bhapitilwe na akatumiche bha kunane kwa Chapanga, alongila Yecho abhii ghome. ");
INSERT INTO dne_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bhajhito bhange bhakajhenda ku mambe bhajhakulola ghala ghighalongilwa na akakeghe, nambo jwenio bhakamwe ndeka.” ");
INSERT INTO dne_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yecho ajhakwalobholela, “Mangota mwenga mupumbumwike naha! Mijheketela kachoko kachoko ghoha ghighalongoleka na milondole bha Chapanga! ");
INSERT INTO dne_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bho, ikampala ndeka Kilichitu kubhehe mulung'ahe, na peniya ndi ajhingila mu ukolo gwake?” ");
INSERT INTO dne_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bhahe, peniya ndi pajhendilila kwachimulila mbone mambu ghoha gwa jwenio hotuhotu ghughabhii mu Majhandiko gha Chapanga, kutumbulila itabo ijhandikwe na Mucha ade mu itabo henge ya milondole bha Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pubhabhandikila kuhika pa chenda jhene, Yecho ajhakutenda anda atenda kupetelecha. ");
INSERT INTO dne_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nambo bhene bhajhakupembelekeya chonde, “Uhighalike pamonga na twenga, nhwalo lyobha litipike na lubhendo lutumbwile.” Ajhakujhenda nkate na kutama. ");
INSERT INTO dne_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Patamita pahe na kulye nabho, ajhakutola libumunda na kunchenguu Chapanga, na kuumetula na kwapekeya ajhake. ");
INSERT INTO dne_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Papalapala miho ghabhe ghajhakudindulilwa, bhajhakumanya, nambo jwenio ajhakwaghala pakate jhabhe. ");
INSERT INTO dne_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bhahe, bhajhakukonyana, “Bho, miojho jhito ikananamwike jhe pakibha achimulila mu Majhandiko gha Chapanga mundela mola?” ");
INSERT INTO dne_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Papalapala bhajhakubhoka na kubhujha ku Yeluchalemo. Bhajhakwakolela bhabholwa kome na jhumo bha Yecho na bhando bhange bhibhakibha pamonga na bhene. ");
INSERT INTO dne_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bhalongila, “Chakaka Bhambo ayokite! Akongine na Simone!” ");
INSERT INTO dne_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bhahe, bhando bhala bhabhele bhajhakulonge ilebhe ipitile undela, na pubhamanyita Yecho pametwila libumunda. ");
INSERT INTO dne_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pubhakibha mukulonge gheniya, Yecho jwenio akajhemite pakate jhabhe na kwalobholela, “Ntamengane kwa uteeke.” ");
INSERT INTO dne_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bhene bhajhakuchituka hake na kujhoghopa bhahambwika pange bhalihwene lihoka. ");
INSERT INTO dne_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nambo Yecho ngalongila, “Nhwalo gwa nike mijhoghopa? Nhwalo gwa nike mme na kiholo kumwojho gwino? ");
INSERT INTO dne_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nninge mabhanga gha mu mabhoko ghango na mabhanga gha mu makongono ghango, naumanya kubhehe ndi nenga. Umbapahe mmone, nhwalo lihoka likwetejhe yegha hilu mihupa ngita chiunolekeya.” ");
INSERT INTO dne_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Pajhomolila kulonge naha, ajhakwalangiya mabhanga gha mu mabhoko pamonga na mabhanga gha mu makongono ghake. ");
INSERT INTO dne_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pubhakibha bhamela nakujheketela nhwalo gwa mukuhangana na kukangacha kwabhe. Yecho pakonyita, “Bho, kibhii chakulyegha pambano?” ");
INSERT INTO dne_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bhahe, bhajhakupekeha kimbembela chuluhomba lubhatutwihe. ");
INSERT INTO dne_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ajhakutola na kulyegha, kongo bhoha bhabhii kulola. ");
INSERT INTO dne_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Peniya ajhakwalobholela, “Ghangano ndi mambu ghininongolila punikibha na mangota: Imbalita kutimila ghala ghoha ghighajhandikwe kwa nenga mu lilaghalikilo lya Mucha, na mu itabo ya milondole bha Chapanga, na Zabule.” ");
INSERT INTO dne_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bhahe, ajhakwatenda malango ghabhe ghahoto kumanya mbone Majhandiko gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ajhakwalobholela, “Ijhandikwe naha, Kilichitu Nkomboche natendwa kung'ahichwa na pa lichiko lya utato nayoka. ");
INSERT INTO dne_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kwa liina lyake, ilambo yoha kutumbulila ku Yeluchalemo itangachilwe kubhehe bhando bhipalwa kuleka na kulekekewa uhakaho. ");
INSERT INTO dne_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mangota mipalwa kwalobholela bhando kubhehe mambu ghanga ndi uchakaka. ");
INSERT INTO dne_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Namwete naninetelangana jhola Tate gwango jhalaghalikiye kuntuma. Nambo uhighalike pa muche ade papala kumpekehe likakala kuhumii kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Peniya Yecho pabhalongwicha bhabholwa bhake kuhumii ku Yeluchalemo ade ku Betaniya, ajhakujhinula mabhoko ghake na kwape mota. ");
INSERT INTO dne_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pakibha mu kwape mota, ajhakwaleka, ajhakutolwa kujhenda kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bhene bhajhakunyinamila, kabhele bhajhakukelebhuka ku Yeluchalemo, kongo bhabhii mu kuhangana hake. ");
INSERT INTO dne_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Helahela bhajhendilila kupipikiya pa Nyumba jha Chapanga, kongo bhannombita Chapanga.");
INSERT INTO dne_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Peniya makacho kabula jha kupanganwa kwa ilebhe, jhumo jwakemitwa Lilobhe akibha. Na jwenio Lilobhe atamita na Chapanga, na jwenio akibha ndi Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kuhumii makacho atamita na Chapanga kabula jha Chapanga kupangana kilebhe chochoha. ");
INSERT INTO dne_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chapanga akapangine ilebhe yoha kupete kwa jwenio, changabhehe jwenio kibhii jhe kilebhe chochoha chikapanginwe. ");
INSERT INTO dne_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jwenio akibha lihembuko lya ughome, na gwenio ughome uletite lumule kwa bhando. ");
INSERT INTO dne_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na lwenio lumule lung'ala pa lubhendo, na lubhendo luluhotwi ndeka kuluhima. ");
INSERT INTO dne_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Chapanga akatumite mundo jhumo, liina lyake Yohane. ");
INSERT INTO dne_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yohane akahikite kwalobholela bhando malobhe gha lumule, bhando bhoha bhajhohe na bhalujheketii lumule lwenio. ");
INSERT INTO dne_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohane jwenio akibha lumule jhe, nambo akahikite kwalobholela bhando mana jha lumule lwenio. ");
INSERT INTO dne_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Lwenio lumule lwa uchakaka, ndi lumule luluhika pannema pano na kwamulikila bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lilobhe jhola akibha pannema na kupete kwa jwenio Chapanga akapangine nnema, nambo bhando bha pannema bhakaumanyite ndeka. ");
INSERT INTO dne_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akahikite kwa bhando bhake jwenio, nambo bhando bhake bhakankanite. ");
INSERT INTO dne_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nambo bhando bhoha bhibhampokii na kunyeketela, ajhakwape ukindendeke gwa kubhehe yana ya Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Bhabhii yana ya Chapanga chi kwa kubhelukwa ngita bhando chibhabhelukwa, amu kwa likakala lya yegha, amu chi kwa uhotolo gwa mundo, nambo kwa uhotolo gwa Chapanga jwenie. ");
INSERT INTO dne_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na Lilobhe jwenio ajhakubhehe mundo, na jwenio ajhakutama pamonga na twenga. Na twenga tumwene ung'alicho gwake, ung'alicho gwa Mwana jwa kanjika, jwahikite kuhumii kwa Tate Chapanga, atwelii hoko umbone na uchakaka. ");
INSERT INTO dne_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohane akalongile malobhe gha mundo jwenio, alongila kwa lilobhe likolongwa, “Jhonjo ndi jhuninongila panane jhake, ‘Ahika mundo jhumo kuyeto jhango ndi nkolongwa kupeta nenga, nhwalo akibha nenga nandumbo jhe.’ ” ");
INSERT INTO dne_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kwa nhwalo gwa umbone gwake gwamahele, twenga tuchochite kupoke mota hake. ");
INSERT INTO dne_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Chapanga akatupekiye Lilaghalikilo lyake kwa kupete Mucha, nambo na umbone na uchakaka utuhikilila kupete kwa ndela jha Yecho Kilichitu. ");
INSERT INTO dne_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Abhii ng'o mundo jhojhoha jwamwene Chapanga. Nambo Mwana jwa kanjika jwabhii Chapanga na jwapahilwe na Tate, ndi jwatulobholila malobhe gheniya gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ghanga ndi malobhe ghalongila Yohane Mbatichajhe, pakibha na ilongoche ya Akayahude ku Yeluchalemo kola pabhatumitwa akapiya matambiko na Akalawe, bhankonye Yohane, “Mwenga ndi ma ghane?” ");
INSERT INTO dne_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohane ajhakujheketela na ajhakujhanguu hotuhotu changayatila, ajhakulonge, “Nenga na Kilichitu Nkomboche ndeka.” ");
INSERT INTO dne_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bhajhakunkonya, “Bhahe, mutulobholele mwenga ndi ma ghane? Bho, mwenga ndi ma Eliya?” Yohane ajhakujhanguu, “Nai jhe, ne ndeka.” Bhajhakunkonya kabhele. “Bho, mwenga ndi jhola nnondole jwa Chapanga?” Na jwenio pajhangwila, “Ne jhe!” ");
INSERT INTO dne_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bhahe, bhajhakunkonya, “Bho, ngohe majhito maghane? Bho, ngohe mabhene milonge nike panane jhino? Mutulobholele, na twenga twalobholela bhala bhibhatutumita tunkonye.” ");
INSERT INTO dne_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohane ajhakujhanguu ngita chalongila nnondole jwa Chapanga Isaya, “Nenga ‘Ndi lilobhe lya mundo jwaikema kunjenga, Nnenganikiye ndela jha Bhambo jhaipala kupeta.’ ” ");
INSERT INTO dne_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Peniya Mapwalichayo bhibhakatumitwe, ");
INSERT INTO dne_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","bhajhakunkonya Yohane, “Anda mwe ma Kilichitu amu ma Eliya jhe amu jhola nnondole jwa Chapanga jhe, nhwalo gwa nike mibaticha bhando?” ");
INSERT INTO dne_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohane ajhakujhanguu, “Nenga nibaticha kwa mache, nambo pakate jhino abhii mundo jhumo manaumanya jhe. ");
INSERT INTO dne_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ndi jwenio jwahika kuyeto jhango, nambo nenga nitope ndeka hilu kubhopo lughojhe lwa maghubache ghake.” ");
INSERT INTO dne_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ghanga ghoha ghatendika ku muche gwa ku Betaniya, kwiye jha lilabha lya ku Yolodane, kwakibha Yohane abaticha. ");
INSERT INTO dne_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kilabho jhake, Yohane ajhakummona Yecho auhikilila, ajhakulonge, “Jhonjo ndi litohe lya limbelele lya Chapanga, jwatola uhakaho gwa bhando bha nnema! ");
INSERT INTO dne_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jhonjo ndi jhunongila malobhe panane jhake, nongila ‘Kuyeto jhango ahika mundo nkolongwa kupeta nenga, nhwalo akibha nenga nandumbo jhe.’ ");
INSERT INTO dne_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nenga namwete nikaumanyi jhe, nambo hikite kubaticha kwa mache nipala bhando bha ku Ichilahele bhaumanye.” ");
INSERT INTO dne_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohane akalongi malobhe ghala ghaghawene, “Nimwene Uhuke gwa Chapanga ahuluka ngita ngunda kuhumii kunane kwa Chapanga na kutolela panane jhake. ");
INSERT INTO dne_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nenga hele nikaumanye jhe, nambo jhola jwandumita kwabaticha bhando kwa mache jwanobholile naha, ‘Mundo jhola jhumipala kummona Uhuke gwa Chapanga kuhumii kunane kwa Chapanga na kubhehe panane jhake, jwenio ndi jwabaticha kwa Uhuke gwa Chapanga.’ ” ");
INSERT INTO dne_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Peniya Yohane ajhakulonge, “Nenga nolite kwa miho ghango na chakaka ninnobholela kubhehe jhonjo ndi Mwana jwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lichiko lyubhele jhake, Yohane akibha ajhemite peniya pamonga na bhabholwa bhake bhabhele chehemo jwenio. ");
INSERT INTO dne_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pamonita Yecho akityanga, ajhakulonge, “Dola, jhonjo ndi Litohe lya Limbelele lya Chapanga!” ");
INSERT INTO dne_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bhabholwa bhabhele bhala pibhannyohina Yohane akalongila naha, bhajhakunkengama Yecho. ");
INSERT INTO dne_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bhahe, Yecho ajhakughalambuka, ajhakwabhona bhabholwa bheniya bhitenda kunkengama, ajhakwakonya, “Bho, mipala nike?” Na bhene bhajhakunyanguu, “Labe, kajhino kojhe?” Labe mana jhake Mmola. ");
INSERT INTO dne_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yecho ajhakwajhanguu, “Nhwike mupalinge.” Jhakibha cha kome jha kimihe bhabholwa pibhajhahwila kupalinga chehemo jhatamita Yecho, bhajhakupipikiya bhoha lichiko lyenio. ");
INSERT INTO dne_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Anduleya, nnongo mundo Simone Petile, akibha jhumo jha bhala bhabhele bhibhakanyohine Yohane akalongila gheniya, ajhakunkengama Yecho. ");
INSERT INTO dne_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anduleya ajhakumpalaha nhwacha mundo Simone, ajhakulonge, “Tumwehine Machiya.” Ndi kulonge Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Peniya Anduleya ajhakuntola Simone na ajhakumpeleka kwa Yecho. Yecho ajhakunnolekeya na ngalongila, “Mwenga ndi ma Simone mwana gwa Yohane, nambo ngohe nankemwa Kefa.” Kefa kwa Kigilike Petile, ndi kulonge lindalabho. ");
INSERT INTO dne_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lichiko lyubhele jhake Yecho ajhakubhoka na kujhenda ku Galilaya. Na kwenio ajhakummona Filipu, ajhakunnobholela, “Ungengame.” ");
INSERT INTO dne_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jwenio Filipu akibha abhelukilwe ku muche gwa ku Betisaida, muche gwahumii Anduleya na Petile. ");
INSERT INTO dne_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipu ajhakummona Natanaele, ajhakunnobholela, “Tumwene mundo jhola Mucha jwakanyandike mukitabo cha Lilaghalikilo, na helahela milondole bha Chapanga bhakajhandike malobhe ghake. Jwenio ndi Yecho, jwahumii ku muche gwa ku Nachalete Mwana jwa Uchupo.” ");
INSERT INTO dne_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Bhahe, Natanaele ajhakunkonya Filipu, “Bho, pumihambuka kilebhe chambone kihoto kubhoke ku Nachalete?” Filipu ngajhangwila, “Nhwike nninge.” ");
INSERT INTO dne_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yecho pamonita Natanaele itende kuhikilila, ajhakulonge, “Dola, jwenio ndi mwi Ichilahele jwa chakaka, anawahi jhe kunkopokeya mundo jhojhoha!” ");
INSERT INTO dne_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaele ajhakunkonya, “Umanyita bhole nenga?” Yecho ajhakujhanguu “Kabula jha Filipu kunkema nikamwene pimikibha pahe jha nkongo gwa nkojho.” ");
INSERT INTO dne_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Peniya Natanaele ajhakunyanguu, “Mmola, mwenga chakaka ndi Mwana gwa Chapanga! Mwenga Manahota Nkolongwa jwa ku Ichilahele!” ");
INSERT INTO dne_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yecho ajhakujhanguu, “Bho, unnyeketela nhwalo pininnobholila nikamwene pahe jha nkongo gwa nkojho? Namughabhona makolongwa kupeta ghanga!” ");
INSERT INTO dne_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yecho pajhendilila kulonge, “Ninnobholela chakaka, nanola kunane kwa Chapanga kukadinduka na akatumiche bha kunane kwa Chapanga nabhakwela nu kuhuluka panane na Mwana gwa Mundo.” ");
INSERT INTO dne_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na lichiko lyutato pakibha na unyagho gwa ndowa kwenio ku Kana, ku muche gwa ku Galilaya, na majhe mundo Yecho akibha papa. ");
INSERT INTO dne_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yecho na bhabholwa bhake helahela bhakalalikwe ku unyagho gwa ndowa gwenio. ");
INSERT INTO dne_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Bhahe, divaye puijhomokila, majhe mundo Yecho ajhakunnobholela, “Bhakwete jhe divaye.” ");
INSERT INTO dne_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yecho ajhakunyanguu, “Nkotoka kumola lyakuhenga. Lichaa lyango lyamela.” ");
INSERT INTO dne_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Peniya majhe mundo Yecho ajhakwalobholela akatumiche, “Lyolyoha lyapala kunnobholela, nhenga.” ");
INSERT INTO dne_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Bhahe, pakibha na ihulo chita ya maghanga, itwelii mache, ikabhekwite peniya ngita chibhayobhalile Akayahude gha kukijhelebhula kwa kunyopa Chapanga. Kila kihulo chimo kikahotwii kujhingii mikambo ncheche amu nhwano. ");
INSERT INTO dne_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yecho ajhakwalobholela akatumiche, “Ntwelengane ihulo yenio mache.” Na bhene bhajhakutweleya lombilombi. ");
INSERT INTO dne_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Peniya ajhakwalobholela, “Ngoheno nteke mupele nkolo unyagho.” Na bhene bhakatehile ngita chabhalongalile. ");
INSERT INTO dne_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jhola nkolo jwa unyagho pabhonjita mache gheniya ghajhakughalambuka na kubhehe divaye. Na jwenio akamanyite jhe kwihumile, nambo akatumiche bhubhatekilila mache bhakamanye. Peniya nkolo jwa unyagho ajhakunkema nnyina mwale paupele, ");
INSERT INTO dne_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ajhakunnobholela, “Kila mundo atumbula kwapekeya akaghene divaye jhamaha. Peniya akaghene pibhanywila nu kukola, upiya divaye jhanganogha. Nambo mwenga nibhekite divaye jhinogha ade ngoheno!” ");
INSERT INTO dne_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yecho ndi nginyililo jhake jha kukangacha jha kutumbula kulangiya pakibha ku Kana, ku muche gwa ku Galilaya. Kwenio ajhakulangiya ung'alicho gwake na bhabholwa bhake bhajhakunyeketela. ");
INSERT INTO dne_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pajhomolila gheniya, Yecho ajhakuhelela na majhe mundo, na nnongo mundo pamonga na bhabholwa bhake, kujhenda ku muche gwa ku Kapelenaumo na ajhakuhighalika kwa machiko ghandina kwenio. ");
INSERT INTO dne_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Unyagho gwa Akayahude ghu ukemwa Pachaka pubhandikila, Yecho ajhakuhobhoka kujhenda ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Bhahe, Yecho ajhakwakolela bhando pa Nyumba jha Chapanga bhakichulucha ng'ombi na mambelele na ngunda, bhubhajhangangana mbijha bhabhii panane jha njangwale bhatamangine. ");
INSERT INTO dne_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Papa, Yecho ajhakupota luyato lwa lughojhe, ajhakwabhenga bhando bhoha panja pa Nyumba jha Chapanga bhoha pamonga na ng'ombi na mambelele. Helahela ajhakupendengula njangwale na mbijha yabhe ijhakupechengana yoha. ");
INSERT INTO dne_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Peniya ajhakwalobholela bhala bhubhachulwicha ngunda, “Mmohengane ilebhe henge! Nkotoka kuhighalambula nyumba jha Tate gwango lighuliho!” ");
INSERT INTO dne_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bhabholwa bhake bhajhakukomboka Majhandiko gha Chapanga ghighalonge, “Mwe ma Chapanga, upalo gwango kwa nyumba jhino undiniya kumwojho gwango ngita mwotu.” ");
INSERT INTO dne_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Bhahe, bhakolo Akayahude bhajhakunkonya Yecho, “Bho, nanangiya nginyililo ghane kabhele jha kukangacha kubhehe nkwete uhotolo gwa kuhenga ghangano ghoha?” ");
INSERT INTO dne_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yecho ajhakwajhangu, “Ntilulane Nyumba jha Chapanga, na nenga nanjenga kabhele kwa machiko matato.” ");
INSERT INTO dne_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Peniya Akayahude bhajhakulonge, “Nyumba jhende jha Chapanga ikachengwite machiko makome ncheche na chita, mwenga nahotola bhole kujhichenga kwa machiko gheniya matato?” ");
INSERT INTO dne_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nambo Nyumba jha Chapanga jhalongela Yecho, ikibha ndi yegha jhake. ");
INSERT INTO dne_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bhahe, Yecho payokita kuhumii kubhawile, bhabholwa bhake bhajhakukomboka chela chalongila. Bhajhakujheketela Majhandiko gha Chapanga na malobhe ghange ghalongila Yecho. ");
INSERT INTO dne_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bhahe, Yecho pakibha ku Yeluchalemo ku unyagho gwa Pachaka, bhando bhamahele bhakaihwene nginyililo yatehila, bhajhakunnyeketela. ");
INSERT INTO dne_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nambo Yecho akabhajheketii ndeka, nhwalo akamanye bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Akapahi jhe mundo jhojhoha annobholele malobhe gha bhando, nhwalo Yecho akaghamanye ghughabhii nkate jha miojho jhabhe. ");
INSERT INTO dne_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Bhahe, pakibha na kilongoche nkolongwa jhumo jwa Akayahude, mundo jwa likunde lya Mapwalichayo, liina lyake Nikodemo. ");
INSERT INTO dne_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lichiko limo uwiko Nikodemo ajhakunyendelela Yecho, ajhakunnobholela, “Mmola, tumanye kubhehe mwenga ndi Mmola jhutumitwe na Chapanga. Nhwalo abhii jhe mundo jhojhoha jwahotola kuhenga nginyililo yumuhenga mwenga anda Chapanga nakubhehe jhe pamonga.” ");
INSERT INTO dne_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yecho ajhakujhanguu, “Ninnobholela chakaka, abhii jhe mundo nahotola kujhingila mu Nahota nkolongwa gwa Chapanga anda abhelwike ndeka mala jhubhele.” ");
INSERT INTO dne_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo ajhakunkonya Yecho, “Bho, mundo nkolongwa ihoto bho kubhelukwa mala jhubhele? Chakaka iwechekana jhe mundo ajhingii mulutumbo lwa majhe na kubhelukwa kabhele!” ");
INSERT INTO dne_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yecho ajhakujhanguu, “Ninnobholela chakaka, abhii jhe mundo jwa kujhingii mu Nahota Nkologwa gwa Chapanga anda abatichwe kwa mache na Uhuke gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mundo jwabhelwike kwa yegha kuhumii kwa majhe na tate mundo, nambo chikibhelwike kwa Uhuke ndi kihuma kwa Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nkotoka kukangacha nhwalo ninnobholela nipala mmelukwe mala jhubhele. ");
INSERT INTO dne_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Upepo upogha kupala kupoghela, mujhoha puupogha, nambo muumanye jhe kuhumii hilu kupoghela. Ndi chikipitila kwa kila mundo jwabhelwike kwa Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo ajhakunkonya, “Bho, ilebhe naihotola kupitila?” ");
INSERT INTO dne_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yecho ajhakunyanguu, “Mwenga mwa mmola nkolongwa jwa ku Ichilahele, na mwenga muhimanyite jhe ilebhe hengeno?” ");
INSERT INTO dne_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Chakaka ninnobholela, twenga tulonge ilebhe itumanya na natilongela ilebhe ituhwene kwa miho ghito, nambo mangota mwamela mujheketela ndeka malobhe ghito. ");
INSERT INTO dne_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mukannyeketii ndeka puninnobholila ilebhe ya pannema pano, bhole nanyeketela jhe anda ninnobholile ilebhe ya kunane kwa Chapanga? ");
INSERT INTO dne_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Abhii jhe mundo jwajhihwii kunane kwa Chapanga, nambo Mwana gwa Mundo jwahumite kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ngita Mucha panyinwila lijhoka lya chaba kwa luyato kunjenga kola, helahela Mwana gwa Mundo ipalwa ajhinwulilwa, ");
INSERT INTO dne_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kila mundo jwannyeketela abhehe na ughome gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwa nhwalo Chapanga akapahile hake bhando bha pannema, ade ajhakummoha Mwana jwa kanjika, kila mundo jwanyeketela akotoka kuhobha, nambo abhaha na ughome gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nhwalo Chapanga akantumite ndeka Mwana mundo pannema pano kwahadabula bhando, nambo nnema aughombole kwa kupete jwenio. ");
INSERT INTO dne_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mundo jhojhoha jwanyeketile Mwana bhihadabu ndeka, nambo mundo jhojhoha jwangannyeketela akihahadabwii njwe, nhwalo anyekite ndeka Mwana jwa kanjika jwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Naha ndi chimpala kuhadabulwa, lumule luhikite pannema, nambo bhando bhipala lubhendo na kululeka lumule, nhwalo ghibhahenga mabhoho. ");
INSERT INTO dne_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kila mundo jwaitenda mabhoho aluchimwa lumule, na jwenio hukana kuhika palumule, nhwalo ijhoghopa mabhoho naghabhonekana mbegha. ");
INSERT INTO dne_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nambo mundo jhola jwaitenda gha chakaka ujhenda palumule, kupala ghala ghahenga ghabhonekena mbegha kwa kunyokanikiya Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pughajhomokila gheniya, Yecho na bhabholwa bhake bhajhakujhenda ade ku muche gwa ku Yudeya, ajhakubhehe kwenio ajhakutama nako, kwenio abaticha bhando. ");
INSERT INTO dne_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Helahela Yohane akibha abaticha ku Ainoniya, pahina na ku Salemo, nhwalo peniya pakibha na mache twe. Bhando bhamahele bhanyendilila, na jwenio ajhakwabaticha. ");
INSERT INTO dne_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ghanga ghatendika Yohane pakibha atabhitwe mukipungo. ");
INSERT INTO dne_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bhahe, pajhakubhehe na mitaungano pakate jha bhabholwa bha Yohane na Akayahude mambu gha kukijhelebhula kwa kunyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bhabholwa bheniya bhajhakunyendelela Yohane na kunnobholela, “Mmola, mundo jhola jhumukibha pamonga na mwenga kwiye jha ku Yolodane, na jhumutulobholila malobhe ghake, ngoheno jwenio abaticha na bhando bhinyendelela.” ");
INSERT INTO dne_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohane ajhakwajhanguu, “Abhii jhe mundo jwahoto kupokela kilebhe changapelwa na Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mangota mabhene umanye puninnobholila, ‘Nenga na Kilichitu Nkomboche jhe, nambo ndei kutumwa kulongolela.’ ");
INSERT INTO dne_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jwabhii na nnyina mwale mwikeghe ndi jwake nnyina mwale munalome. Nambo njeche jwa nnyina mwale ajhema pahina na kujhokanikiya, nhwangana pahijhoha lilobhe lya nnyina mwale munalome akilongela. Naha ndi chibhii kwa nenga ngoheno luhangano lwango pulukamilika. ");
INSERT INTO dne_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bhahe, jwenio Yecho ipala abhaha nkolongwa na nenga maha jwandina.” ");
INSERT INTO dne_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jwenio jwahika kuhumii kunane kwa Chapanga ndi nkolongwa kuliku bhoha. Mundo jwa pannema pano apitii pannema na ulongela ilebhe ya pannema, nambo jwahika kuhumii kunane kwa Chapanga ndi jwalongocha ghoha. ");
INSERT INTO dne_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jwenio alongela ghala ghaghahwene na kughajhoha, nambo abhii jhe hilu mundo jhumo jwajheketela malobhe ghalongila. ");
INSERT INTO dne_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nambo mundo jhojhoha jwanyeketela malobhe ghake, chakaka ilangiya Chapanga ndi uchakaka. ");
INSERT INTO dne_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jhola jwatumitwe na Chapanga, ulonge malobhe gha Chapanga, nhwalo Chapanga untwelekeya lombilombi mundo jwenio Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tate impala Mwana mundo na akamwii ilebhe yoha mu mabhoko ghake. ");
INSERT INTO dne_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mundo jhojhoha jwanyeketela Mwana abhii na ughome gwa machiko ghoha ghangapeta, nambo mundo jhojhoha jwanga nnyeketela Mwana akwete jhe ughome, najhendelela kubhehe pahe jha luchwapulo lwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mapwalichayo bhakajhohine Yecho akwete bhando bhamahele kubhehe bhabholwa na kubaticha kupeta Yohane. ");
INSERT INTO dne_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nambo Yecho jwenio akabatiche ndeka bhando, nambo bhabholwa bhake ndi bhakabatiche bhando. ");
INSERT INTO dne_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bhahe, Yecho pajhohina gheniya, ajhakubhoka ku Yudeya na kubhujha ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Mu mwanja gwake impalita apetele ku Samaliya. ");
INSERT INTO dne_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bhahe, ajhakuhika ku muche gwa ku Samaliya, ghuukemwa Sukale, ghuheghelile na nng'onda ghola gwa Yakobu gwakampekiye mwana mundo jwakemwita Uchupo. ");
INSERT INTO dne_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Peniya pakibha na kilibha cha Yakobu, na Yecho nhwalo gwa kutotokela kwa mwanja, ajhakutama pahina jha kilibha. Ikibha chaa chita jha muhe. ");
INSERT INTO dne_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Bhahe, mwikeghe jhumo Nsamaliya ajhakuhika kuteka mache. Yecho ajhakunnobholela, “Nijhopa mache nyweghe.” ");
INSERT INTO dne_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yecho akibha kanjika, bhabholwa bhake pubhajhahwile kubomane kuheme ilebhe ya kulyegha. ");
INSERT INTO dne_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Mwikeghe jhola ajhakunnobholela Yecho, “Mwenga ma Yahude na nenga ndi Nasamaliya. Nhwalo ghane unyopa mache gha kunywegha?” Alongila naha nhwalo Akayahude na Akasamaliya bhilye ndeka pamonga. ");
INSERT INTO dne_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yecho ajhakunyanguu, “Anda ngaumanya hupo ya Chapanga na ndi ghane jwannyopa mache gha kunywegha, ngamunyopite na jwenio ngampekiye mache ghighaleta ughome.” ");
INSERT INTO dne_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Mwikeghe jhola ajhakunnobholela, “Bhambo, nkwete jhe nteko gwa kuteke mache na kilibha kibhii nnyoli. Bho, ngoheno namughakolela kojhe mache ghighaleta ughome? ");
INSERT INTO dne_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Amu pange mwenga mukitenda mwanahota kuliku tate gwito Yakobu? Jwenio akatupekii twenga kilibha chenje helahela na jwenio na yana mundo na inyama yake bhanywila mache gha kilibha chenje.” ");
INSERT INTO dne_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yecho ajhakunyanguu, “Jwanywegha mache ghanga najhohii jhe nyota kabhele. ");
INSERT INTO dne_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nambo jwapala kunywegha mache ghakumpekeya nenga, nabhe jhe na nyota kwa ughome gwa machiko ghoha ghangapeta. Mache ghunimpela kumpekiya ghunimpela nkate jhino naghabha chembwe cha mache ghighaleta ughome na kumpela ughome gwa machiko ghoha ghangapeta.” ");
INSERT INTO dne_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mwikeghe jhola ajhakunnobholela, “Bhambo, umbekehe mache gheniya! Ngotoka kubhehe na nyota kabhele, na ngotoka kuhika kabhele kuteka mache pamba.” ");
INSERT INTO dne_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yecho ajhakunnobholela, “Nnyende mukankeme ungana gwino, na nhwike nako pamba.” ");
INSERT INTO dne_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jwenio mwikeghe ajhakunnobholela, “Nenga ndoline jhe.” Yecho ajhakunnobholela, “Unywagwii mbone, nkwete ndeka munalome. ");
INSERT INTO dne_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nhwalo mukibha na akanalome nhwano na munalome jhutama nako ngoheno jwii ndeka. Chakaka nnongii maha.” ");
INSERT INTO dne_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Bhahe, mwikeghe jhola ajhakunnobholela, “Bhambo, nibhona mwenga ndi ma nondole bha Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Akahoko bhito bhanyinamila Chapanga pakitombe chenje, nambo mangota Akayahude milongela ku Yeluchalemo ndi kwa kunyope Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yecho ajhakunyanguu, “Mwe majhe unyeketele chinilonge, machiko ghabhii kuhika bhando nabhanyinamila ndeka Tate panane jha kitombe chenje amu kola ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mangota mwaka Samaliya, munyinamila Chapanga jhola jwangaumanya, nambo twenga Akayahude tunyinamila Chapanga jhutummanye, nhwalo gwa ughombokeko uhumii kwa Akayahude. ");
INSERT INTO dne_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nambo machiko ghabhii kuhika, kabhele ghahikite, bhibhanyinamila Chapanga jwa uchakaka na bhanyopa Tate kuhumii muhuke gwa Chapanga na uchakaka. Nhwalo Tate abhapala bhando ngita bheniya bhannyinamile. ");
INSERT INTO dne_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Chapanga ndi Uhuke na bhando bhibhanyopa ibhapala bhanyinamila Chapanga kwa kulongochwa na Uhuke gwa Chapanga na uchakaka.” ");
INSERT INTO dne_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mwikeghe jhola ajhakunnobholela, “Nimanya Machiya Nkomboche, jhuikemwa Kilichitu abhii kuhika. Papala kuhika na natulobholela hotuhotu kila kilebhe.” ");
INSERT INTO dne_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yecho ajhakunnobholela, “Nenga jhunilongela na mwenga, ndi nenga.” ");
INSERT INTO dne_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Papa bhabholwa bhake bhajhakubhujha, bhajhakukangacha hake kubhona akilongela na mwikeghe jhola. Nambo abhii jhe mundo jwakankonyite, “Mipala nike?” Amu “Nhwalo gwa nike milongela na mwikeghe jwenio?” ");
INSERT INTO dne_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Bhahe, mwikeghe jhola ajhakuuleka nkambo ghola papa na kubhujha kubomane kwalongelela bhando, ");
INSERT INTO dne_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Tijha mukanole mundo jwanobholile ilebhe yoha indehila. Bho, pange ihoto kubhehe jwenio ndi Kilichitu Nkomboche?” ");
INSERT INTO dne_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bhahe, bhando bhajhakubhoka ku bomane nu kujhenda kunninga Yecho. ");
INSERT INTO dne_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Muda ghogho bhabholwa bhake bhampembelikiya Yecho bhalongila, “Mmola, nlyeghe!” ");
INSERT INTO dne_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nambo Yecho ajhakujhanguu, “Nenga ngwete cha kulyegha mangota mukimanyitii jhe.” ");
INSERT INTO dne_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bhahe, bhabholwa bhake bhajhakukonyana, “Bho, abhii mundo jwannetile chakulyegha?” ");
INSERT INTO dne_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yecho ajhakwalobholela, “Chinilyegha ndi kuhenga ghapala jhola jwandumita na kujhomola lihengo lyambekii kuhenga. ");
INSERT INTO dne_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mangota mulonge, ‘Jhamela miyehe ncheche tugha, na mahuno naghatumbula.’ Nambo ninnobholela, dolokeya mighonda chilenganikilwe kwa mahuno. ");
INSERT INTO dne_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mundo jwahuna alepitwe njwe malepo ghake na jwaponga mahuno kwa nhwalo jha ughome gwa machiko ghoha ghangapeta, hele jwamicha na jwahuna nabhahangana pamonga. ");
INSERT INTO dne_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nhwalo luhumo londo chakaka ‘Mundo jhumo umicha na mundo jhonge jwakuhuna.’ ");
INSERT INTO dne_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nenga nitumingine mukahune mu mighonda jhangalema, bhando bhange bhakahengite lihengo, nambo mangota mwenga minong'omenekeya kwa lihengo lyabhe.” ");
INSERT INTO dne_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Akasamaliya twe bha ku bomane jhela ngabhanyeketila Yecho kwa nhwalo gwa majhe jhola, “Anobholile ilebhe yoha indehila.” ");
INSERT INTO dne_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bhahe, Akasamaliya bhajhakunyendelela Yecho, bhajhakunnyopa bhatame nako, na jwenio ajhakutama kwa machiko mabhele. ");
INSERT INTO dne_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bhando bhamahele bhajhakunnyeketela Yecho nhwalo gwa malobhe ghala ghalongila. ");
INSERT INTO dne_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bhajhakunnobholela majhe jhola, “Twenga ngoheno tujheketile, chi kwa nhwalo kwa chela chinongela, nambo nhwalo twabhete tujhohine na tumanya mundo jhonjo chakaka Nchengula jwa bhando bhoha bha pannema.” ");
INSERT INTO dne_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pighapetita machiko mabhele Yecho ajhakubhoka kwenio, na kujhenda ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nhwalo Yecho jwenio alongila hotuhotu, “Nnondole jwa Chapanga ilendemwa ndeka ku kilambo chabhelukilwe.” ");
INSERT INTO dne_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bhahe, pahikita ku Galilaya, bhando bhamahele bhajhakumpokela nhwalo bhene bhakajhenda ku Unyagho gwa Pachaka kwenio ku Yeluchalemo, na bhakaihwene yoha yatehila Yecho pa unyagho gwenio. ");
INSERT INTO dne_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yecho pajhahwila kabhele ku Kana ghubhii ku muche gwa ku Galilaya, kwenio kwaghalambwiya mache kubhehe divaye. Kwenio pakibha na munahota jhumo mwana mundo atehila kulwalwa ku muche gwa ku Kapelenaumo. ");
INSERT INTO dne_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bhahe, munahota jwenio pajhohina Yecho ahikite ku Galilaya kuhumii ku Yudeya ajhakunnyendelela na kunnyopa anamiche mwana mundo jwakibha tepekatepeka. ");
INSERT INTO dne_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yecho ajhakunnobholela, “Mangota bhando changalola nginyililo na ikangacho minyekete jhe Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Munahota jwenio ajhakunnobholela, “Bhambo, chonde tujhende mwanango kabula jha kuwegha.” ");
INSERT INTO dne_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yecho ajhakunnobholela, “Nnyende tugha mwana gwino nabhaha ghome!” Mundo jhola ajhakujheketela malobhe gha Yecho, ajhakujhenda. ");
INSERT INTO dne_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Munahota jhola pakibha undela kubhujha, akatumiche bhake ajhakukongana nako na kunnobholela mwana gwino abhii ghome njwe. ");
INSERT INTO dne_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Na jwenio ajhakwakonya muda ghane patumbwila kubhehe mbaha, na bhene ngabhanyangwila, “Dicho cha chaba jha muhe punekikiya ulwalo.” ");
INSERT INTO dne_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tate jhola ajhakukomboka lichaa lelelalela pannobholila Yecho, “Mwana gwino amela ghome.” Bhahe, jwenio na nyumba jhake jhoha bhajhakunyeketela Yecho. ");
INSERT INTO dne_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ikibha nginyililo jhubhele jha kukangacha jhatehila Yecho pahumita ku Yudeya na kujhenda ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pughajhomokila gheniya, Yecho ajhakuhobhoka ku Yeluchalemo ku unyagho ghonge gwa Akayahude. ");
INSERT INTO dne_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na kwenio ku Yeluchalemo pahina na litangala likolongwa lilikemwa Nnyango gwa Limbelele, pakibha na litanda lilikemwita kwa Kiebulaniya Bethichata pahina na litanda pakibha na udamo nhwano. ");
INSERT INTO dne_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Bhando bhamahele bhakibha muudamo bhibhalwalwa, na bhangalola, na bhibhalemile na bhibhatengwike. ");
INSERT INTO dne_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bhando bhubhalendila mache ghatimbughanwe, nhwalo ntumiche jwa kunane kwa Chapanga ahikita kutimbughana mache. Jwalwalwa jhojhoha jwalongolela kutumbukila mu mache ghughatimbughinwe, alamita ulwalo ghoghoha gwabhii nako. ");
INSERT INTO dne_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Bhahe, peniya pakibha na mundo jhumo jwakibha alwalwita ulwalo gwa kutenguka kwa yaka makome matato na nane. ");
INSERT INTO dne_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yecho pammonita jwalwalwa jwenio agholwike peniya, akamanye akibha alwalwita kwa machiko ghamahele, peniya ajhakunkonya jwalwalwa jhola, “Bho, mwipala kulama?” ");
INSERT INTO dne_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jwalwalwa jhola ajhakunnyanguu, “Bhambo, nenga ngwete ndeka mundo jwakunyingii mu litanda pubhatimbukana mache. Kila punijhigha kutumbukila, mundo jhonge alongalile.” ");
INSERT INTO dne_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Peniya Yecho ajhakunnobholela, “Jhema, tola mpacha gwino, nnyende.” ");
INSERT INTO dne_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Papa peniya mundo jhola ajhakulama, ajhakutola mpacha gwake nu kujhenda. Kilebhe chenje kitendika Lichiko lya Kupomolela lya Akayahude. ");
INSERT INTO dne_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nhwalo gwenio Akakolo bha Akayahude bhajhakunnobholela mundo jwalamichwe jhola, “Deleno Lichiko lya Kupomolela, lilaghalikilo likanakiya kutola mpacha gwino.” ");
INSERT INTO dne_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nambo mundo jwenio ajhakwajhanguu, “Mundo jwanamiche jhola ndi jwannobholila, ‘Tola mpacha gwino na nnyende.’ ” ");
INSERT INTO dne_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bhahe, bhajhakunkonya, “Bho, ndi mundo ghane jwanobholile mwenga ntole mpacha gwino nnyende?” ");
INSERT INTO dne_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nambo mundo jhola jwalamichwe akahumanyi jhe Yecho akibha ghane, nhwalo bhando bhakibha bhamahele na Yecho akabhokite mandahe. ");
INSERT INTO dne_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pighapetita gheniya, Yecho ajhakummona jhola jwanamiche pa Nyumba jha Chapanga, ajhakunnobholela, “Jhokanikiya, ngoheno nnamite. Nkotoka kubhujhila kuhenga uhakaho kabhele, anda ntehi uhakaho nakipambalakana kilebhe kibhoho kupeta cheneche.” ");
INSERT INTO dne_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Peniya mundo jhola ajhakujhenda kwalobholela ilongoche ya Akayahude kubhehe Yecho ndi jwanamiche. ");
INSERT INTO dne_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nhwalo Yecho akahengite kilebhe chenie Lichiko lya Kupomolela, Akayahude bhajhakutumbula kunchimwa. ");
INSERT INTO dne_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bhahe, Yecho ajhakwalobholela, “Tate gwango ahenga mahengo machiko ghoha na nenga helahela imbala henga.” ");
INSERT INTO dne_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kwa nhwalo gwa malobhe gheniya, ilongoche ya Akayahude bhapaliya ndela bhankome Yecho, chi kwa nhwalo akalipuchite Lilaghalikilo lya Lichiko lya Kupomolela tugha, nambo nhwalo akankemite Chapanga ndi Tate mundo, na ajhakukiwananicha alandine na Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yecho ajhakwalobholela, “Ninnobholela chakaka, Mwana ihoto ndeka kuhenga kilebhe chochoha kanjika chake, Mwana ihotola kuhenga chela chamwona Tate mundo akihenga, nhwalo chahenga Tate, helahela Mwana ihenga.” ");
INSERT INTO dne_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nhwalo Tate impala Mwana, na unangiya kila kilebhe chahenga jwenio. Peniya nanangiya ilebhe ikolongwa kupeta henge, na mangota nankangacha. ");
INSERT INTO dne_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ngita Tate chabhayoha bhubhawile na kwapela ughome, helahela Mwana abhapela ughome bhando bhabhapahile. ");
INSERT INTO dne_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Na kabhele Tate ahuadabu jhe mundo jhojhoha, nambo ampela Mwana ukindendeke gwa kwahadabuu bhando bhoha, ");
INSERT INTO dne_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kupala bhando bhoha bhanyokanikiye Mwana ngita chibhanyokanikiya Tate. Mundo jhojhoha jwakana kunyokanikiya Mwana, ankana Tate jwandumita. ");
INSERT INTO dne_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ninnobholela chakaka, jwajhoha lilobhe lyango, na kunyeketela jhola jwandumita, abhii na ughome gwa machiko ghoha. Na jwenio nahadabulwa ndeka nhwalo ajhombwike kuhumii mu kuwegha na kujhingii muughome. ");
INSERT INTO dne_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ninnobholela chakaka, lichiko libhii kuhika, na ngoheno lihikite, bhando bhubhawile nabhalijhoha lilobhe lya Mwana gwa Chapanga, na bhala bhubhapala kujhoha nabhabha na ughome gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ngita Tate chabhii lihembuko lya ughome, helahela anteii Mwana mundo lihembuko lya ughome. ");
INSERT INTO dne_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kabhele ampekiye ukindendeke gwa kuhadabula nhwalo jwenio Mwana gwa Mundo. ");
INSERT INTO dne_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nkotoka kukangacha kwa malobhe ghanga, nhwalo lichiko libhii kuhika bhubhawile bhoha bhubhabhii mu mambe nabhajhoha lilobhe lyake, ");
INSERT INTO dne_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","nabhayoka kuhumii mu mambe yabhe, bhala bhubhatehi ghambone na kubhehe na ughome, nambo bhala bhubhatei uhakaho nabhayoka na kuhadabulwa. ");
INSERT INTO dne_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Nenga nihoto ndeka kuhenga lihengo kwa uhotolo gwango namwete. Nihadabula ngita chinaghalikiwe kuhumii kwa Tate, nihadabuu chakaka. Nhwalo nihenga ndeka chinipala, nihenga chela chapala jwandumita.” ");
INSERT INTO dne_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Punikilobholela malobhe ghango namwete, malobhe ghango ndi ghuwange. ");
INSERT INTO dne_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nambo abhii jhonge jwalongela malobhe panane jhango, nimanya kila kilebhe chalongela ndi chakaka. ");
INSERT INTO dne_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mangota mwenga makatumite bhando bhajhende kwa Yohane Mbatichajhe, na malobhe ghango ghalongila ndi gha chakaka. ");
INSERT INTO dne_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nipala ndeka mundo jhonge alongela panane jhango, nambo nilonge ghanga nipala mangota mwenga nghombokoke. ");
INSERT INTO dne_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohane akibha ngita kolobohi jhijhaka na kulangala ndaa, na mangota mkahagwile machiko ghandina gha kuhanganila. ");
INSERT INTO dne_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nambo nenga namwete malobhe ghighanjimulila makolongwa kupeta ghala gha Yohane. Nhwalo lihengo limbekiwe na Tate nijhomole lihengo linihenga, ndi inangiya hotuhotu Tate jwandumite. ");
INSERT INTO dne_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tate jwandumita helahela ulongela malobhe ghango. Mukajhohine jhe lilobhe lyake amu kummona pamiho jhake chipabhii, ");
INSERT INTO dne_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","na malobhe ghake ghatama jhe nkate jhino, nhwalo mukanyeketii ndeka jhola jwandumita. ");
INSERT INTO dne_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mangota mughachoma hake Majhandiko gha Chapanga pimihambuka nkate jhake napata ughome gwa machiko ghoha ghangapeta, kone Majhandiko gheniya gha Chapanga ndi ghighalonge malobhe ghango! ");
INSERT INTO dne_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nambo mangota mipala jhe kuhika kwa nenga mme na ughome gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nenga nipala ndeka bhando bhangweya. ");
INSERT INTO dne_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nambo nimmanya mangota, nkwete jhe upalo gwa Chapanga kumiojho jhino. ");
INSERT INTO dne_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nenga ihikite kwa ukindendeke gwa Tate gwango mingana kumbokela, nambo mundo jhonge anda ahikite kwa ukindendeke gwake jwenio, namupokela. ");
INSERT INTO dne_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bhole, nahotola kunyeketela kone mangota mipala kukikweya mabhene, nambo mwikana kupokela chipwa kuhumii kwa Chapanga jwenio? ");
INSERT INTO dne_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nkotoka kuwachila nenga nanipyambanikiya kwa Tate. Mucha jhumuhobholela mangota ndi jhojho natakalila. ");
INSERT INTO dne_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Anda chakaka ngamunyeketela Mucha, ngaunyeketile na nenga hele, nhwalo Mucha akajhandike malobhe panane jhango. ");
INSERT INTO dne_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nambo anda mughajheketela ndeka ghala ghighajhandikwe na Mucha, nanhotola bhole kughajheketela malobhe ghango?” ");
INSERT INTO dne_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pajhomolila kulonge gheniya, Yecho ajhakujhomboka kwiye jha lilabha lya ku Galilaya, helahela likemwa lilabha lya Tibeliya. ");
INSERT INTO dne_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lilongo likolongwa lya bhando lijhakunkengama Yecho nhwalo bhakalolite nginyililo yatehila ya kwalamicha bhibhalwalwa. ");
INSERT INTO dne_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yecho ajhakukwela ku kitombe, ajhakutama pahe kwenio pamonga na bhabholwa bhake. ");
INSERT INTO dne_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Unyagho gwa Pachaka jha Akayahude ukibha ubhandikile. ");
INSERT INTO dne_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Bhahe, Yecho palyangatika ajhakubhona lilongo likolongwa lya bhando libhii titili likanhikilila, ajhakunkonya Filipu, “Bho, natuhemela kojhe chakulye bhando bhamba?” ");
INSERT INTO dne_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yecho alongila naha anyighe Filipu, nhwalo akamanye chakuhenga. ");
INSERT INTO dne_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipu ajhakunnyanguu, “Imbembela ya mbijha makome mabhele gha madine gha feza ghakwela jhe kuhemelela mabumunda kila mundo.” ");
INSERT INTO dne_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jhumo pakate jha bhabholwa bhake liina lyake Anduleya, unung'una mundo Simone Petile, ajhakunnobholela Yecho, ");
INSERT INTO dne_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Abhii pamba nchongolo, jwakwete mabumunda nhwano gha chayile na homba ibhele, nambo nabhajhukuta bhole bhando kwa ilebhe henge yandina?” ");
INSERT INTO dne_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yecho ajhakwalobholela bhabholwa bhake, “Mwatamike bhando pahe mwihibhogha ibhogha.” Peniya pakibha na manyahe titili bhahe, bhando bhoha bhakahikii elufo nhwano, bheniya akanalome tugha. ");
INSERT INTO dne_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Bhahe, Yecho ajhakutola mabumunda gha chayile, na ajhakunchenguu Chapanga, na kwabhaghanichila bhando bhubhatamite pahe. Na homba ajhakuhibhaghanichila ibhogha yoha hele ngita chibhapalita. ");
INSERT INTO dne_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bhando bhoha bhajhukuta, Yecho ajhakwalobholela bhabholwa bhake, “Nnyolangane mahighiliko ghighahighilike changahobhelela chochoha.” ");
INSERT INTO dne_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Bhahe, bhabholwa bhajhakujhola mahighiliko gha mabumunda gha chayile bhajhakutwelela ichukilo kome na ibhele ya mahighiliko. ");
INSERT INTO dne_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bhando bhoha pubhalolita nginyililo itehilwa na Yecho bhajhakulonge, “Chakaka jhonjo ndi nnondole jwalongilwa nahika pannema pano!” ");
INSERT INTO dne_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yecho akamanye bhando bhipala bhantende munahota nkolongwa kwa likakala, peniya ajhakujhenda ku katombe kanjika. ");
INSERT INTO dne_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pulitipika lyobha, bhabholwa bhake bhajhakuhuluka ade ku lilabha, ");
INSERT INTO dne_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","bhajhakujhingila mungalabha na kujhomboka lilabha bhajhakujhenda ade ku Kapelenaumo. Pakibha na lubhendo na Yecho amela anakongana nako jhe. ");
INSERT INTO dne_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lilabha lijhakutumbuu kutimbuka nhwalo gwa upepo nkolongwa ghupoghita. ");
INSERT INTO dne_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bhabholwa bhake pubhatyangita utale gwa maile itatu amu ncheche, bhajhakummona Yecho ityanga panane jha mache, akibhandikila ngalabha, bhabholwa bhajhakujhoghopa hake. ");
INSERT INTO dne_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yecho ajhakwalobholela, “Nkotoka kujhoghopa, ndi nenga!” ");
INSERT INTO dne_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Bhahe, bhabholwa bhapata bhayungii Yecho mungalabha, papalapala ngalabha ikahikite pandumba pibhajhahwila. ");
INSERT INTO dne_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kilabho jhake lilongo likolongwa lya bhando likahighilike kwiye jha lilabha bhakamanye ibhii ngalabha jhimo tugha. Na bhakamanye Yecho akajhingi jhe mungalabha na bhabholwa bhake, nambo bhabholwa bhake bhakajhenda kanjika chabhe. ");
INSERT INTO dne_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Na ngalabha henge ijhakujhonjekeka kuhumii ku Tibeliya ijhakuhika pahina na pala lilongo likolongwa lya bhando pubhalila mabumunda, Bhambo panombita Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Bhahe, bhando bheniya pibhang'amwila kubhehe Yecho na bhabholwa bhake bhabhii jhe peniya, bhajhakujhingii mungalabha na kujhenda ku Kapelenaumo kwapalaha. ");
INSERT INTO dne_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bhando pibhamonita Yecho kwiye jha lilabha bhajhakunkonya, “Mmola, mwenga nhwikite ligha kongone?” ");
INSERT INTO dne_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yecho ajhakwajhanguu, “Ninnobholela chakaka, chiumbalakiya chi nhwalo mukahwene nginyililo, nhwalo gwa mabumunda ghukapita ghala nu kujhukuta. ");
INSERT INTO dne_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nkotoka kukipikiya miho chakulya chikibhola, nambo mukipikihi miho chakulya chikitamikiya na kileta ughome gwa machiko ghoha ghangapeta. Mwana gwa Mundo napelangana mangota chakulya chenie, nhwalo Tate Chapanga anangiye kunhaghula na kunyeketela.” ");
INSERT INTO dne_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Peniya bhajhakunkonya Yecho, “Bho, tuhenge nike tuhoto kuhenga ghala ghapala Chapanga tuhenge?” ");
INSERT INTO dne_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yecho pajhangwila, “Chenje ndi chapala Chapanga mukihenge, munyeketele jhola jwatumita.” ");
INSERT INTO dne_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bhahe, bhajhakunkonya, “Bho, natenda nginyililo ghane tupala tulole na twenga tunyeketele? Bho, naunhenga nike? ");
INSERT INTO dne_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Akahoko bhito bhakalile chakulya chikikemitwa mana kunjenga, ngita chighalonge Majhandiko gha Chapanga, ‘Akabhapekiye libumunda lilihulwika kuhumii kunane kwa Chapanga.’ ” ");
INSERT INTO dne_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yecho ajhakwalobholela, “Ninnobholela chakaka, chi Mucha jwakampeki libumunda kuhumi kunane kwa Chapanga, nambo Tate gwango ndi jwapekiya mabumunda gha chakaka kuhumi kunane. ");
INSERT INTO dne_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nhwalo libumunda lya Chapanga ndi ghola ghuhulwika kuhumii kunane kwa Chapanga na kwapela ughome bhando bha pannema.” ");
INSERT INTO dne_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bhahe, bhajhakunnobholela, “Bhambo, machiko ghoha mutupela libumunda lya machiko ghoha.” ");
INSERT INTO dne_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yecho ajhakwalobholela, “Nenga ndi chakulya chikileta ughome. Bhala bhubhahika kwa nenga nabhabhehe ng'o na njala na jhola jwanyeketela nabhehe ng'o na nyota jha mache kabhele. ");
INSERT INTO dne_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ngita chininnobholila umwene nambo minyekete jhe. ");
INSERT INTO dne_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bhoha bhampela Tate nabhahika kwa nenga, mundo jhojhoha jwahika kwa nenga nanimmenga ng'o. ");
INSERT INTO dne_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Uhulwike kuhumii kunane kwa Chapanga chi kuhenga ghinipala namwete, nambo kutenda ghapala jhola jwandumita. ");
INSERT INTO dne_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jhola jwandumita apala naha, ngotoka kuhobhecha hilu jhumo pakate jha bhala bhambekiye, nambo nayokecha bhoha mukuwegha lichiko lya mwicho. ");
INSERT INTO dne_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nhwalo chapala Tate gwango kila mundo jwamona Mwana na kunyeketela nabhaha na ughome gwa machiko ghoha ghangapeta, na nenga naniyokecha lichiko lya mwicho.” ");
INSERT INTO dne_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bhahe, Akayahude bhajhakutumbu kukokolekeya nhwalo akalongi, “Nenga ndi libumunda lilihuluke kuhumii kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Na bhene bhajhakulonge, “Bho, jhonjo Yecho chi mwana gwa Uchupo ndeka tate na majhe mundo twamanye? Ahoto bhole kulonge ahulwike kuhumii kunane kwa Chapanga?” ");
INSERT INTO dne_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yecho ajhakwalobholela, “Mwileke ngokoleko pakate jhino. ");
INSERT INTO dne_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Abhii ndeka mundo jwahoto kuhika kwa nenga, ngita Tate jwandumite chaunhutila kwa jwenio, na nenga nanihyokecha mundo jwenio lichiko lya mwicho. ");
INSERT INTO dne_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Milondole bha Chapanga bhajhandikwe, ‘Bhando bhoha nabhabholwa na Chapanga.’ Kila mundo jwannyokanikiya Tate na kukibhola kuhumii kwa jwenio, nahika kwa nenga. ");
INSERT INTO dne_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Abhii jhe mundo jhojhoha jwamwene Tate nga jhola jwahumila kwa Chapanga, ndi jwenio tugha jwamwene Tate. ");
INSERT INTO dne_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ninnobholela chakaka, mundo jhojhoha jwanyeketela abhii na ughome gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nenga ndi chakulya cha ughome. ");
INSERT INTO dne_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Akahoko bhino bhakalile mana kunjenga, nambo bhakawile. ");
INSERT INTO dne_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nambo lende ndi libumunda lilihulwike kuhumii kunane kwa Chapanga, jhojhoha jwalyegha nahwejhe. ");
INSERT INTO dne_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nenga ndi libumunda lya ughome lilihulwike kuhumii kunane kwenio. Mundo jhojhoha anda alile, nabhaha na ughome gwa machiko ghoha ghangapeta. Na libumunda ndi yegha jhango, jhinipiya kwa nhwalo gwa bhando bha pannema bhoha bhabhehe na ughome.” ");
INSERT INTO dne_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bhahe, Akayahude bhajhakutumbuu kutaungana kwa lilaka pakate jhabhe, “Bho, mundo jhonjo nahotola bhole kutupekeya yegha yake tulyeghe?” ");
INSERT INTO dne_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yecho ajhakwalobholela, “Chakaka ninnobholela, na kulye jhe yegha jha Mwana gwa Mundo na kunywegha miyahe jhake, ughome nahubhehe jhe nkate jhino. ");
INSERT INTO dne_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mundo jhojhoha jwalyegha yegha jhango na kunywegha miyahe jhango abhii na ughome gwa machiko ghoha ghangapeta, na nenga nanihyokecha lichiko lya mwicho. ");
INSERT INTO dne_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nhwalo yegha yango ndi ndalilo jha chakaka, na miyahe jhango ndi kinywelekelo chakaka. ");
INSERT INTO dne_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mundo jhojhoha jwalyegha yegha jhango na kunywe miyahe jhango, jwenio natama nkate jhango, na nenga nitama nkate jhake. ");
INSERT INTO dne_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ngita Tate jwabhii na ughome andumite, na nenga nitama kwa nhwalo gwake, helahela mundo jwalyegha yegha jhango nalama kwa nhwalo jha nenga. ");
INSERT INTO dne_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bhahe, chenje ndi chakulya chikihulwike kuhumii kunane kwa Chapanga, chi ngita mana ibhalila akahokolo bhino na bhajhakuwegha. Nambo mundo jwalyegha libumunda lende nabhaha na ughome gwa machiko ghoha ghangapeta.” ");
INSERT INTO dne_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yecho alongila malobhe gheniya pabholita munyumba jha kukonganikii Akayahude ku Kapelenaumo. ");
INSERT INTO dne_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bhahe, bhando bhamahele pakate jha bhabholwa bhake pubhajhohina malobhe gheniya, bhajhakulonge “Mabholo ghanga ghanonwipe! Bho, ghane nahotola kughajheketela?” ");
INSERT INTO dne_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yecho akamanye kubhehe bhabholwa bhake bhatehila kukokoleka panane jha malobhe gheniya, bhahe, ajhakwakonya, “Bho, nhwalo gwa nike mabholo ghanga ghauhengelecha mwojho? ");
INSERT INTO dne_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Naibhaha bhole, pala pumpapala kummona Mwana gwa Mundo akikelebhuka kwahumila kunane kwa Chapanga? ");
INSERT INTO dne_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Uhuke gwa Chapanga ndi jwaleta ughome, nambo likakala lya mundo kilebhe nacho. Malobhe gheniya ghuninnobholela ghihuma kwa Uhuke gwa Chapanga na ghileta ughome gwa machiko ghoha gwangapeta. ");
INSERT INTO dne_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nambo bhange pakate jhino bhanyekete jhe.” Yecho alongela gheniya akamanye kuhumii makacho bhala bhangannyeketela, na hele jhola jwapala kunyambila. ");
INSERT INTO dne_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yecho ajhendilila kulonge, “Kwa nhwalo ghongo nikannobholile abhii jhe mundo jwapala kuhotola kuhika kwa nenga ade atangatilwe na Tate gwango.” ");
INSERT INTO dne_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bhahe, kwa nhwalo gwa malobhe gheniya, pakate jha bhabholwa bhala bhamahele kuhengeleka mwojho, na bhakankengime jhe kabhele. ");
INSERT INTO dne_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yecho ajhakwakonya bhabholwa bhake kome na bhabhele bhala, “Na mangota mwenga mipala kubhoka helahela?” ");
INSERT INTO dne_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simone Petile ajhakujhanguu, “Bhambo, na tujhenda kwa ghane? Mwenga milongela malobhe gha ughome gwa machiko ghoha gwangapeta. ");
INSERT INTO dne_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Twenga tujheketile na tumanyite mwenga ndi Mwanyahinyahi jhuhumii kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yecho ajhakwakonya, “Bho, nikahaghuline ndeka mangota kome na bhabhele? Nambo jhumo pakate jhino ndi Limbembela!” ");
INSERT INTO dne_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Malobhe gheniya Yecho alongila panane jha Yuda, mwana gwa Simone Isikaliote, pakate jha bhala bhabholwa kome na bhabhele ndi jhonjo jwapala kunyambila Yecho. ");
INSERT INTO dne_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pughajhomokila gheniya, Yecho atyangita kwenio ku Galilaya, akapahi jhe kujhenda ku Yudeya, nhwalo gwa bhakolo bha Akayahude bhapala kunkoma. ");
INSERT INTO dne_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Unyagho ghumo gwa Akayahude ghunkemwa unyagho gwa Ichimba ukabhandikile. ");
INSERT INTO dne_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Akalongo mundo Yecho bhajhakunnobholela, “Mmoke pamba na nnyende ku Yudeya, bhibhankengama bhakalolekeye mahengo ghimihenga. ");
INSERT INTO dne_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Abhii jhe mundo jwaitenda ilebhe kwa kukihiya anda apala amanyikane pa bhando. Mwenga muhenga mahengo ghanga, mukilangiye palonge jha bhando bhoha!” ");
INSERT INTO dne_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Helahela na akalongo mundo bhakannyeketile jhe. ");
INSERT INTO dne_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Bhahe, Yecho ajhakwalobholela, “Lichiko lyango lyamaha lyamela lyanahika jhe, nambo kwino mangota kila lichiko telatela. ");
INSERT INTO dne_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bhando bha nnema ghongo bhahoto jhe kunchimwa mangota, nambo nenga bhanjimwite nhwalo gwa kwalobholela ilebhe yubhatenda yambone jhe. ");
INSERT INTO dne_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mangota nnyendengane tugha kuunyagho gwenio. Nenga nijhenda jhe kuunyagho gwenio, nhwalo lichiko lyango lyambone lyamela.” ");
INSERT INTO dne_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Alongila malobhe gheniya, peniya ajhakuhighalika koko ku Galilaya. ");
INSERT INTO dne_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Akalongo mundo pubhajhahwila kuunyagho gwenio, na jwenio Yecho helahela ajhakujhenda kwenio, nambo akilangiya jhe hotuhotu nambo akajhahwi kwa kugwala. ");
INSERT INTO dne_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pa unyagho gwenio bhakolo bha Akayahude bhakibha bhampaliya Yecho, na bhajhakunkonya, “Bho, abhii kojhe mundo jhola?” ");
INSERT INTO dne_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kuhumi pa likunde lela pajhakubhehe mbwepombwepo yamahele panane jha Yecho. Na bhange bhalongila, “Ndi mundo jhonjo jwaumbone hake.” Na bhange bhalongila, “Nahijhe, jwenio abhahobhecha bhando.” ");
INSERT INTO dne_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nambo abhii jhe mundo jwakalongile hotuhotu panane jha Yecho, nhwalo bhajhogwipa bhakolo bha Akayahude. ");
INSERT INTO dne_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Unyagho gwenio puheghelila kujhomokela, Yecho ajhakujhingila pa Nyumba jha Chapanga, na kutumbuu kubhola. ");
INSERT INTO dne_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Bhahe, bhakolo bha Akayahude bhajhakukangacha na kulonge, “Bho, mundo jhonjo apatite koo mabholo ghanga na jwenio anabholwa jhe na mundo jhojhoha?” ");
INSERT INTO dne_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Peniya Yecho ajhakujhanguu, “Mabholo ghinibhola ghango jhe, ghahuma kwa jhola jwandumita. ");
INSERT INTO dne_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mundo jwapala kuhenga ghala ghapala Chapanga, namanya ngita mabholo ghango ghihumi kwa Chapanga, amu nilonge kwa ukindendeke gwango namwete. ");
INSERT INTO dne_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jwenio jwabombolokana ipalaha kukikweya jwenio, nambo jwapalaha chipwa kwa jhola jwandumite, jwenio ndi jwantembekeya, na nkate jhake ubhii jhe uwange ghoghoha. ");
INSERT INTO dne_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bho, Mucha akapehi ndeka Lilaghalikilo? Pamonga na gheniya, abhii jhe hilu jhumo pakate jhino jwakamwile Lilaghalikilo. Kilebhe ghane chiumbala kungomela?” ");
INSERT INTO dne_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lilongo lya bhando bhajhakunyangula, “Mwenga ntehi kuchikilwa michuka! Ghane jwapala kunkoma mwenga?” ");
INSERT INTO dne_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yecho ajhakwajhanguu, “Nakatehi kikangacho chimo na mangota mikangacha. ");
INSERT INTO dne_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mucha akanaghalikiye majhingiye yana hino jando, pamo na Mucha amu akahoko bhino bhakatumbuliche lilaghalikilo lyenio, na mabhene kujhingii jando mwana Lichiko lya Kupomolela. ");
INSERT INTO dne_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bhahe, anda kujhingii jando mwana Lichiko lya Kupomolela lya Akayahude nhwalo gwa kulikamula lilaghalikilo lya Mucha kilebhe ghane chumbihikiya miho nduu, kunamicha mundo Lichiko lya Kupomolela? ");
INSERT INTO dne_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nkotoka kuhadabula kwa kunolekeya pamiho tugha, nambo ntende luhadabulo lwa mbone.” ");
INSERT INTO dne_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bhahe, bhando bhange bha ku Yeluchalemo bhajhakutumbu kukikonya, “Bho, jhola mundo ilongoche jhubhapala kunkoma jhonjo jhe? ");
INSERT INTO dne_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dolokeya abhii pamba! Abhapwatalila pakongoloho, abhii jhe hilu mundo jwannobholela lilobhe. Bho, ilongoche bhito bhamanye kubhehe jhonjo ndi Kilichitu Nkomboche? ");
INSERT INTO dne_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nambo Kilichitu papala kuhika abhii jhe mundo jwapala kumanya nahumila kojhe, nambo twenga tumanya kwahumii mundo jhonjo.” ");
INSERT INTO dne_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Bhahe, Yecho pabholita pa Nyumba jha Chapanga ajhakulonge kanonoha, “Bho, chakaka umanye na umanye kuhumile? Ihikite jhe kwa ukindendeke gwango namwete, nambo jhola jwandumita nenga ndi jwa chakaka. Mangota umanyi jhe, ");
INSERT INTO dne_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","nambo nenga nimanya nhwalo nihuma kwa jwenio, na jwenio ndi jwandumite.” ");
INSERT INTO dne_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Peniya bhando bhajhakupala kunkamula, nambo abhii jhe mundo jwakatondobhiye lubhoko lwake kunkamula, nhwalo lichiko lyake likibha lyamela. ");
INSERT INTO dne_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nambo bhando bhamahele kubhoke palilongo lya bhando bhakanyeketile, bhalongila, “Kilichitu Nkomboche pahika, bho, natenda nginyililo kupeta yatehila mundo jhonjone?” ");
INSERT INTO dne_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mapwalichayo bhajhakujhoha bhando bhakipwepa malobhe panane jha Yecho. Bhahe, akapiya Matambiko na Mapwalichayo bhajhakwatuma akalonda bha Nyumba jha Chapanga bhakapyeneneke Yecho. ");
INSERT INTO dne_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yecho ajhakwalobholela, “Natama na mangota kwa machiko ghandina tugha, peniya nanyenda kwa jhola jwandumita. ");
INSERT INTO dne_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Naumbalaha, nambo naummona ndeka, nhwalo nauhoto jhe kuhika pala pumii nenga.” ");
INSERT INTO dne_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Akakolo bha Akayahude bhalongila bhene kwa bhene, “Bho, mundo ojho najhenda kojhe ade natuhotola jhe kumona kabhele? Bho, najhenda kwa Akayahude bhubhapechingine pakate jha miche jha Akagilike, na kwabhola Akagilike? ");
INSERT INTO dne_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nhwalo gwa nike alongila, ‘Naumbalaha, nambo naumona ndeka, nhwalo nauhoto jhe kuhika pala pumii nenga?’” ");
INSERT INTO dne_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lichiko lya kujhomolela unyagho gwenio likibha lichiko likolongwa. Yecho ajhakujhema, ajhakulonge kwa lilobhe likolongwa, “Mundo jhojhoha jwabhii na nyota ahike kwa nenga anyweghe. ");
INSERT INTO dne_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngita chighalonge Majhandiko gha Chapanga, ‘Mundo jhojhoha jwanyeketela nenga, ngemba ya mache ileta ughome naghakokola kuhumii nkate jhake.’ ” ");
INSERT INTO dne_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yecho palongila malobhe gha Uhuke gwa Chapanga, bhubhapala kumpokela bhando bhala bhubhannyeketile. Ade lichiko lyenio bhando bhakapokii jhe Uhuke gwa Chapanga. Nhwalo Yecho akibha amela analombwa jhe na Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bhando bhange pakate jha lilongo lela bhakajhohine malobhe gheniya, bhajhakulonge, “Chakaka mundo jhonjo ndi jhola nnondole jwa Chapanga!” ");
INSERT INTO dne_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Na bhange bhajhakulonge, “Jhojhone ndi Kilichitu Nkomboche!” Nambo na bhando bhange bhajhakukikonya, “Bho, Kilichitu Nkomboche ihoto kubhelukilwa ku Galilaya? ");
INSERT INTO dne_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bho, Majhandiko gha Chapanga ghakalongii jhe, Kilichitu nahumila kulukolo lwa munahota nkolongwa Daude, na nabhelukila ku muche gwa ku Betelehemo, kwatamita Daude!” ");
INSERT INTO dne_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Bhahe, bhando bhajhakupechangana nhwalo gwa Yecho. ");
INSERT INTO dne_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bhando bhange bhapata kunkamula, nambo abhii jhe jwakajhighite kunkamula. ");
INSERT INTO dne_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Akalonda bha Nyumba jha Chapanga pibhakelehwika, akapiya Matambiko na Mapwalichayo bhajhakwakonya, “Bho, nhwalo gwa nike munkamwii jhe Yecho na kuhika nako pamba?” ");
INSERT INTO dne_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Akalonda bhala bhajhakujhanguu, “Akibha jhe mundo jwahotwila kulonge kupeta mundo jhonjo!” ");
INSERT INTO dne_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bhahe, Mapwalichayo bhajhakwakonya, “Bho, na mangota helahela ankolwiye?” ");
INSERT INTO dne_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Bho, abhii kilongoche amu Pwalichayo jhumo jhumumwene anyeketile? ");
INSERT INTO dne_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nahijhe bhalimanyiti jhe Lilaghalikilo lya Mucha lilongo lene, nambo peniya alapanikiwe na Chapanga!” ");
INSERT INTO dne_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemo, jhola jwannyendila Yecho, akibha jhumo jwa Mapwalichayo bhubhakibha peniya. Bhahe, ajhakwalobholela, ");
INSERT INTO dne_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Lilaghalikilo lito lilongela, tuhoto ndeka kuhadabuu mundo jhojhoha anda na kunyokanikii jhe na kumanya alemwite nike. ");
INSERT INTO dne_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Na bhene bhajhakunyangula, “Bho, na mwenga hele jwa koko ku Galilaya? Mukalingukiye Majhandiko gha Chapanga, naumanya abhii jhe nnondole jwa Chapanga jwahumii ku Galilaya.” ");
INSERT INTO dne_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bhahe, kila mundo ajhakujhenda kajhake. ");
INSERT INTO dne_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pughajhomokila gheniya, Yecho ajhakujhenda ku Kitombe cha ku Micheitune. ");
INSERT INTO dne_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kilabho jhake putiputi ajhakujhenda kabhele pa Nyumba jha Chapanga. Bhando bhoha bhajhakuntindila Yecho, na jwenio ajhakutama pahe na kutumbuu kwabhola. ");
INSERT INTO dne_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bhahe, bhabhola bha Malaghalikilo na Mapwalichayo bhajhakunnetela mwikeghe jhumo jwankamwilwe akihenga ngongola. Na kunyemeka palonge jhabhe. ");
INSERT INTO dne_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Peniya, bhajhakunnobholela Yecho, “Mmola, mwikeghe jhonjo tunkamwii akihenga ngongola. ");
INSERT INTO dne_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mulilaghalikilo lito, Mucha akatulaghalikii naha, mwikeghe ngita jhonjo akong'ondwe maghanga ade ahweghe. Ngohe mwenga milonge bhole?” ");
INSERT INTO dne_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bhalongila naha bhanyonje Yecho bhabhehe na kihokola cha kuntakalila. Nambo Yecho ajhakulita, na kutumbuu kujhandika pahe kwa lukonje lwake. ");
INSERT INTO dne_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pubhajhendelila kunkonya, Yecho ajhakujhinuka na kwalobholela, “Mundo jhojhoha jwangabhehe na uhakaho pakate jhino atumbule kunkong'onda lighanga.” ");
INSERT INTO dne_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Peniya Yecho ajhakulita kabhele na kujhandika pahe. ");
INSERT INTO dne_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bhando bhala pubhajhohina malobhe gheniya, bhajhakutumbu kupechengana jhumojhumo, bhatumbwila ighogholo kubhoka. Ajhakuhighalika Yecho na mwikeghe jhola ajhemite papa. ");
INSERT INTO dne_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yecho pajhinuka, ajhakunkonya mwikeghe jhola, “Bho majhe, bhando bhibhakamwila bhala bhabhii kojhe? Bho, abhii jhe hilu mundo jhumo jwahadabwile?” ");
INSERT INTO dne_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mwikeghe jhola ajhakujhanguu, “Bhambo, abhii jhe mundo jwahadabwile.” Yecho ajhakunnobholela, “Nenga helahela ninhadabu ndeka. Nnyende nambo nkotoka kuhenga kabhele uhakaho.” ");
INSERT INTO dne_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yecho ajhakwalobholela bhando kabhele, “Nenga ndi lumule lwa bhando bha pannema. Mundo jhojhoha jwangengama nenga natyange jhe mulubhendo, nambo nabhaha na lumule lwa ughome.” ");
INSERT INTO dne_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bhahe, Mapwalichayo bhajhakunnobholela, “Malobhe ghino mikilongelele mabhene tugha, malobhe ghimilonge gha chakaka ndeka.” ");
INSERT INTO dne_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yecho ajhakwajhanguu, “Anda nikilongolile panane jhango namwete, malobhe ghango gha chakaka nhwalo manyite kunihuma na kunijhenda. Nambo mangota kibhii jhe chiumanya kojhe kunijhenda na kojhe kunihumila.” ");
INSERT INTO dne_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mangota mihadabu ngita bhando chibhahadabu, nambo nenga ninhadabu jhe mundo. ");
INSERT INTO dne_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nambo anda nihadabula, nihadabuu chakaka, nhwalo nihadabuu jhe kanjika, Tate jwandumita abhii pamonga na nenga. ");
INSERT INTO dne_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ijhandikwe Mulilaghalikilo lino bhando bhabhele bhilonge kwa kujheketelana chibhakihwene, bhahe, lilobhe lyenio ndi uchakaka. ");
INSERT INTO dne_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nenga nikilongelela chakaka namwete malobhe ghango na Tate jwandumita helahela inongelela chakaka panane jhango. ");
INSERT INTO dne_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bhahe, bhajhakunkonya, “Bho, Tate gwino abhii kojhe?” Yecho ajhakwajhanguu, “Umanyite jhe nenga hilu Tate gwango. Ngaumanya nenga, helahela ngamumanyite Tate gwango.” ");
INSERT INTO dne_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yecho alongila malobhe gheniya pakibha abholita pa Nyumba jha Chapanga, pahina na kihukilo cha mbijha. Akapitii jhe mundo jwa kunkamula nhwalo lichiko lyake likibha lyamela. ");
INSERT INTO dne_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yecho ajhakwalobholela kabhele, “Nenga ndenda kukibhokela, mangota naumbalaha, nambo nauhwa nako uhakaho gwino. Kunijhenda nenga mangota mihoto jhe kuhika.” ");
INSERT INTO dne_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bhahe, ilongoche ya Akayahude ijhakulonge, “Ilonge ihoto jhe kujhenda kwajhenda bho, apala kukikoma jwenio?” ");
INSERT INTO dne_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nambo Yecho ajhakwalobholela, “Mangota bha pannema pano jhibhii pahe, nambo nenga jwa kunane kwa Chapanga. Mangota bhando bha pannema ghongo, nambo nenga jwa pannema pano jhe. ");
INSERT INTO dne_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kwa nhwalo ghongo nikannobholile nauhwa muwakaho gwino. Changanyeketela, ‘Nenga ndi Jhumile.’ Nauhwa muuhakaho gwino.” ");
INSERT INTO dne_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bhajhakunkonya Yecho, “Mwe mwa ghane?” Yecho ajhakwajhanguu, “Nenga ndi Jhojho, ngita chinikannobholile kuhumii makacho. ");
INSERT INTO dne_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ngwete ghamahele gha kulonge panane jha kuhadabula. Nambo jhola jwandumita jwa chakaka, na chinyohine kuhumii kwa jwenio ndi nikilonge kwa bhando bhoha bha pannema.” ");
INSERT INTO dne_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Bhakamanyi jhe kubhehe Yecho akibha alongila malobhe panane jha Chapanga Tate mundo. ");
INSERT INTO dne_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bhahe, Yecho ajhakwalobholela, “Pumipala kuntondobheya Mwana gwa Mundo panchalaba, peniya ndi pumpala kubangatuka, ‘Nenga ndi Jhojho.’ Peniya naumanya nihenga jhe kilebhe chochoha kanjika, nilonge ghala ghamolita Tate gwango. ");
INSERT INTO dne_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jhola jwandumita tubhii maghumba nde na nenga, annekite jhe kanjika nhwalo machiko ghoha nihenga ghahanganila.” ");
INSERT INTO dne_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bhando bhamahele bhubhanyokanikiya Yecho palongila malobhe gheniya bhajhakunnyeketela. ");
INSERT INTO dne_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Bhahe, Yecho ajhakwalobholela bhala Akayahude bhubhannyeketile, “Anda mughakengama mabholo ghango, na mangota namma bhabholwa bhango chakaka. ");
INSERT INTO dne_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na mangota namuumanya uchakaka naghunekekeya.” ");
INSERT INTO dne_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bhajhakunnyanguu Yecho, “Twenga twakachokolo bha Ulahimo, tunabhejhe akabhanda kwa mundo jhojhoha jhola. Nhwalo gwa nike milonge, ‘Na bho, milonge natulekekewa?’” ");
INSERT INTO dne_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yecho ajhakwajhanguu, “Ninnobholela chakaka, kila mundo jwatenda uhakaho ndi mmanda jwa uhakaho. ");
INSERT INTO dne_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mmanda ahoto jhe kutamikiya pakajha machiko ghoha, nambo mwana atamikiya pakajha machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mwana gwa Mundo anda anekekiye nanekekeya chakaka. ");
INSERT INTO dne_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nimanya mangota lukolo lwa Ulahimo. Umbala kungoma nhwalo mughakana mabholo ghango. ");
INSERT INTO dne_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nenga nilonge ghala ghanangiya Tate gwango, nambo mangota muhenga ghala ghunobholilwe na tate gwino.” ");
INSERT INTO dne_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bhajhakunyanguu, “Tate gwito Ulahimo.” Yecho ajhakwalobholela, “Mangota ngamehe yana ya Ulahimo, nganteile ghahengita Tate gwino Ulahimo. ");
INSERT INTO dne_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nenga ninnobholela chakaka ghala ghinyohine kuhumii kwa Chapanga, nambo mangota mwamela mumbala kungoma. Ulahimo akatehi jhe yenio! ");
INSERT INTO dne_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","“Mangota muhenga ghaghala ghala ghatehila tate gwino.” Bhajhakunyanguu, “Twenga twayana ya pakituto jhe, tubhii na Tate gwito ndi Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yecho ajhakwalobholela, “Anda Chapanga ngabhehe Tate gwino, ngaumbahi na nenga, nhwalo na nenga nhumi kwa Chapanga na ngoheno mii pambano. Ikite jhe kwa ukindendeke gwango namwete nambo kwa jhola jwandumita.” ");
INSERT INTO dne_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nhwalo gwa nike mibangatuka jhe ghuninobholela? Nhwalo mangota mwipala jhe kujhokanikiya malobhe ghango. ");
INSERT INTO dne_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mangota yana ya tate gwino Limbembela, na muhenga ngita tate gwino chaipala. Kuhumi makacho akakomite bhando, jwenio atamajhe muchakaka nhwalo ubhii jhe uchakaka kwa jwenio. Pailongela uwange alonge ngita chayobhalile, nhwalo ndi jwa uwange na tate jwa uwange ghoha. ");
INSERT INTO dne_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nhwalo nilongela gha uchakaka, ndi mana mangota minyeketela ndeka. ");
INSERT INTO dne_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ghane pakate jhino jwahotola kulonge nenga ngwete uhakaho? Anda nilongela chakaka, nhwalo ghane mwinyeketela ndeka? ");
INSERT INTO dne_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mundo jwa Chapanga ajhokanikiya malobhe gha Chapanga. Nambo mangota mighapala ndeka, nhwalo mangota chi bhando bha Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Akayahude bhajhakunkonya Yecho, “Bho, tukalongii jhe chakaka mwenga kubhehe mwa Samaliya, na hele nkwete nchuka?” ");
INSERT INTO dne_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yecho ajhakujhanguu, “Nenga ngwete jhe nchuka, nenga nintembekeya Tate gwango nambo mangota mitenda jhe yenio. ");
INSERT INTO dne_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nenga nikipalakihi jhe ung'alicho gwango namwete, amu abhii jhumo jwambalakiya ung'alicho gwenio na jwenio ndi nnyomola mihalo. ");
INSERT INTO dne_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chakaka ninnobholela, jwachokolekeya mabholo ghango nahwe jhe natama machiko ghoha.” ");
INSERT INTO dne_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bhahe, Akayahude bhajhakunnobholela Yecho, “Ngohe chakaka mwenga nkwete nchuka! Ulahimo na milondole bha Chapanga bhawile, nambo mulonge mundo jhojhoha jwaunyokanilikiya malobhe ghino nahwejhe. ");
INSERT INTO dne_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bho, mwenga munahota kupeta hoko gwito Ulahimo jwawile? Helahela milondole bha Chapanga bhakawile. Bho, mwenga nchochite kilebhe ghane?” ");
INSERT INTO dne_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yecho ajhakwajhanguu, “Anda nikikwehite namwete, ukolo gwango kilebhe nacho. Tate gwango jhuminkema Chapanga gwino ndi jwenio jwanomba. ");
INSERT INTO dne_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mangota mwenga muumanyite jhe, nambo namwete ndi niumanyite. Na anda nongile numanye ndeka, namaha nawange ngita mangota. Nambo nenga nimanye na nikamula lilobhe lyake. ");
INSERT INTO dne_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tate gwino Ulahimo akahanganii kulibhona lichiko lya kuhika kwango, na jwenio akaliwene, na ajhakuhanganila.” ");
INSERT INTO dne_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bhahe, Akayahude bhajhakunnobholela, “Mwenga, nhwikiche jhe yaka makome nhwano, kojhe, kumumwene Ulahimo?” ");
INSERT INTO dne_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yecho ajhakwalobholela, “Chakaka ninnobholela, Ulahimo nakubhelukwa jhe, nenga nikibha.” ");
INSERT INTO dne_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kwa nhwalo gwa malobhe gheniya, bhajhakulokota maghanga bhapata bhankong'onde Yecho, nambo Yecho ajhakujhobha na kupita panja pa Nyumba jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yecho pakibha apetita muupele mwa ndela, ajhakummona mundo jwangalola kuhumi mukubhelukwa kwake. ");
INSERT INTO dne_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bhahe, bhabholwa bhake bhajhakunkonya, “Mmola, ghane jwatehi uhakaho ade jhonjo abhelwike jwangalola? Mundo jhonjo amu akatate mundo?” ");
INSERT INTO dne_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yecho ajhakujhanguu, “Chi mundo jhonjo amu akatate mundo bhatei uhakaho, nambo ghapitili naha ili limanyikane likakala lya Chapanga likahenga lihengo muughome gwake. ");
INSERT INTO dne_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nhwalo kwamela muhe tujhendelele kuhenga lihengo lya jhola jwandumita. Kilo kibhikuhika mundo nahotojhe kuhenga lihengo. ");
INSERT INTO dne_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Punibhehe namela pannema, nenga ndi lumule lwa bhando bha pannema.” ");
INSERT INTO dne_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yecho pajhomolila kulonge gheniya, ajhakuhunii mata pahe, na ajhakuhinyata mandakale na kukilima kumiho kwa jwangalola jhola. ");
INSERT INTO dne_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yecho ajhakunnobholela, “Jhenda mukakuwe kumiho jhino ku litanda lya Siloamo.” Siloamo mana jhake “Jwatumitwe.” Bhahe, jwangalola ajhakujhenda na kukuwa kumiho, na peniya pabhujhita kongo abhii kulola. ");
INSERT INTO dne_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bhahe, bhubhamandikile na bhala bhubhamonita makacho atehila kujhopa jhopa tugha, bhajhakukikonya, “Bho, mundo jhonjo chi ndi jhola jwajhopita?” ");
INSERT INTO dne_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bhando bhange bhakalongii, “Jhojho ndi jwenio.” Nambo bhange bhalongila, “Jhonjo jhe nambo bhatehi kulandana.” Nambo jwenio ajhakulonge, “Ne ndi jhojhola jhola jhunyopita.” ");
INSERT INTO dne_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Bhahe, bhajhakunkonya, “Bho, nhotwi bhole kulola?” ");
INSERT INTO dne_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na jwenio ajhakwajhanguu, “Mundo jhola jwakemwa Yecho ajhakuhinyata mandakale na kungilima pamiho, na kunnobholela nyende kulitanda lya ku Siloamu nikakuwe kumiho jhango. Peniya nyakujhenda, papalapala punguhita kumiho jhango nyakulola.” ");
INSERT INTO dne_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bhajhakunkonya, “Bho, abhii kojhe mundo jwenio?” Na jwenio ajhakwajhanguu, “Nenga manyite jhe kwajhingilile.” ");
INSERT INTO dne_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bhahe, bhajhakumpeleka mundo jwangalola kuhumii makacho kwa Mapwalichayo. ");
INSERT INTO dne_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lichiko lyenio Yecho pahinyita mandakale na kunnamicha jwangalola jhola, likibha Lichiko lya Kupomolela. ");
INSERT INTO dne_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bhahe, Mapwalichayo bhajhakunkonya kabhele mundo jwenio pahotwila kulola. Ajhakwajhanguu, “Akangilime mandakale kumiho jhango, na nenga nyakukuwa kumiho jhango, na ngoheno nilola.” ");
INSERT INTO dne_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Mapwalichayo bhange bhajhakulonge, “Mundo jwenio jwatehi naha ahumi ndeka kwa Chapanga, nhwalo akalikengime jhe lilaghalikilo lya Lichiko lya Kupomolela.” Nambo bhange bhalongila, “Bho, mundo jwabhii na uhakaho nahotola bhole kuhenga nginyililo ngita yenio?” Peniya bhajhakupechengana. ");
INSERT INTO dne_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Peniya Mapwalichayo bhajhakunkonya kabhele jwakibha jwangalola jhola, “Milonge anamiche miho ghino. Ngoheno mabhene munchimulila bhole mundo jwenio?” Na jwenio ajhakwajhanguu, “Mundo jwenio ndi nnondole jwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nambo bhakolo bha Akayahude bhakajheketii ndeka kubhehe mundo jwenio alolita jhe na ngoheno alola, ade bhakakemite akatate mundo. ");
INSERT INTO dne_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Akayahude bhajhakwakonya bhala akatate mundo, “Bho, jhonjo mangota mwana gwino jhumulonge abhelwikwe jwangalola? Na ngohe ahotwi bhole kulola?” ");
INSERT INTO dne_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Akatate mundo bhala bhajhakwajhanguu, “Tumanya chakaka jhonjo mwana gwito, na tumanya akabhelwikwe changalola. ");
INSERT INTO dne_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nambo tumanyite jhe chahotwila kulola, hilu tumanyite jhe mundo jwannamiche miho ghake. Munkonye hote jwenio, nhwalo ndi nkolongwa, nahotola kunnobholela!” ");
INSERT INTO dne_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tate na majhe mundo bhalongila naha, nhwalo bhajhogwipa bhakolo bha Kiyahude na kabhele bhakolo bhene bhakalaghine kubhehe mundo jhojhoha jwanyeketila Yecho ndi Kilichitu Nkomboche nabhamengela panja kuhumii mu Nyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndi nhwalo tate na majhe mundo bhalongila naha, “Jwenio nkolongwa, munkonye jwenio!” ");
INSERT INTO dne_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bhahe, Akayahude bhajhakunkema kabhele jwakibha abhelwikwe jwangalola jhola, bhajhakunnobholela, “Mukilapanikiye kwa Chapanga anda milonge chakaka! Twenga tumanya kubhehe mundo jwannamiche jhola abhii na uhakaho.” ");
INSERT INTO dne_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mundo jwenio ajhakujhanguu, “Anda abhii na uhakaho amu akwetii jhe kwale. Nenga nikimanya kilebhe chimo nikabhelwikwe nangalola, na ngoheno nilola cheche tugha.” ");
INSERT INTO dne_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Peniya bhajhakunkonya kabhele, “Bho, akantendi nike kwino? Akatehi bhole ade kunnamicha miho ghino?” ");
INSERT INTO dne_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Mundo jwenio ajhakwajhanguu, “Ninnobholile njwe, nambo mukapala jhe kunyokanikiya. Nhwalo gwa nike mipala kujhoha kabhele kilebhe chenje? Na mangota helahela mipala kubhehe bhabholwa bhake?” ");
INSERT INTO dne_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bhahe, bhajhakunnigha maligho bhalongila, “Mwenga ndi mabholwa jwa mundo jwenio, nambo twenga bhabholwa bhake Mucha. ");
INSERT INTO dne_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Twenga tumanye ngita Chapanga akalongile na Mucha, nambo mundo jhonjo tumanyite jhe kwahumile!” ");
INSERT INTO dne_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Na jwenio ajhakwajhanguu, “Mangota mingangacha! Mangota umanyite jhe kwahumii, nambo anamiche miho ghango! ");
INSERT INTO dne_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tumanye Chapanga abhajhokonikiya ndeka bhando bhubhabhii na uhakaho, nambo Chapanga unyokanikiya mundo jhola jwannyoghopa hake kuhenga chapala ahenge. ");
INSERT INTO dne_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kuhumii kupanganwa kwa nnema inajhokanikika jhe kubhehe mundo jhojhoha anamiche mundo jwabhelukwe jwangalola. ");
INSERT INTO dne_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Anda mundo jwenio ahumi jhe kwa Chapanga, ngahotwi jhe kuhenga chochoha.” ");
INSERT INTO dne_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bhajhakunnyanguu, “Mwenga mmelwikwe na kukolela muuhakaho. Nauhotola bhole kutubhola twenga?” Bhahe, Akayahude bhajhakumpikiya panja pa Nyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yecho pajhohina malobhe kubhehe jwangalola jhola bhamengite mu Nyumba jha kukonganikii Akayahude. Bhahe, pammonita ajhakunkonya, “Bho, mwenga munyeketela Mwana gwa Mundo?” ");
INSERT INTO dne_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mundo jwenio ajhakukonya, “Bhambo, mundo jwenio ndi ghane? Unobholele mbala kunyeketela!” ");
INSERT INTO dne_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yecho ajhakunyanguu, “Ngoheno mumwene, ndi jhonjo jumulonge nako.” ");
INSERT INTO dne_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bhahe, mundo jhola ajhakulonge, “Bhambo, ninyeketile!” Na jwenio ajhakunyinamila Yecho. ");
INSERT INTO dne_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yecho ajhakulonge, “Nenga ikite munnema mwenio kwahadabuu bhando, bhangalola bhalole na bhando bhibhalola bhankoto kulola.” ");
INSERT INTO dne_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mapwalichayo bhange bhubhakibha pamonga na Yecho bhakajhohine palongila naha, bhajhakunkonya “Bho, twenga hele twangalola?” ");
INSERT INTO dne_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yecho ajhakwalobholela, “Ngamehe mwangalola, ngamonikini jhe mmii na uhakaho, nambo nhwalo miloka milonge twenga tulola, mangota mwamela muuhakaho.” ");
INSERT INTO dne_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yecho ajhakwalobholela, “Ninnobholela chakaka, mundo jhojhoha anda ajhingii jhe mukibhajha cha mambelele kwa kupete pa nnyango, nambo ajhingila kwa chehemo jwaimanyite jwenio, jwenio ndi mwihe na atenda kupoka. ");
INSERT INTO dne_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nambo mundo jwajhingila kupete pa nnyango, jwenio ndi nnucha mambelele. ");
INSERT INTO dne_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nnonda jwa nnyango gwa kibhajha udindulila, na mambelele ulijhokanikiya lilobhe lyake. Na jwenio ughakema mambelele ghake kila jhumo kwa liina lyake, na kwalongocha panja. ");
INSERT INTO dne_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Paghajhogholela mambelele ghake jwenio ulongolela, na ghene mambelele ghakengimila nhwalo bhalimanye lilobhe lyake. ");
INSERT INTO dne_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nambo mambelele gheniya ghihoto jhe kunkengama mundo jwangaumanya, nabhankana nhwalo bhalimanyite jhe lilobhe lyake.” ");
INSERT INTO dne_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yecho abhalobhalila nnandanikiho gwenio, nambo bhene bhakamanyite jhe chabhalobhalila. ");
INSERT INTO dne_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bhahe, Yecho ajhakwalobholela kabhele, “Ninnobholela chakaka, nenga ndi nnyango gwa kibhajha cha mambelele. ");
INSERT INTO dne_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bhando bhoha bhubhakalongalile bhakibha akamwihe na bhatenda kupoka, nambo mambelele ghakajhokanikiye ndeka. ");
INSERT INTO dne_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nenga ndi nnyango. Mundo jhojhoha jwajhingila kwa kupete kwa nenga naghombokoka. Najhingila na kupita, na kubhehe na undinde. ");
INSERT INTO dne_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mwihe uhika kujhibha, kukoma na kuhangabhana. Nambo nenga ikite kwatenda bhando bhabhehe na ughome gwa chakaka lombilombi. ");
INSERT INTO dne_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nenga nnucha jwaumbone. Nnucha jwaumbone ubhoha ughome gwake kwa nhwalo gwa mambelele ghake. ");
INSERT INTO dne_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mundo jwalucha kwa kulepwa chi nnucha, hilu nkolo mambelele jhe. Palibhona limehe likahika, ughaleka mambelele na kutila. Peniya limehe ughakamula mambelele na kughapechengana. ");
INSERT INTO dne_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mundo jwenio natila nhwalo mundo jwenio jwa malepo naghahola jhe mambelele gheniya. ");
INSERT INTO dne_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nenga nnucha jwaumbone. Nighamanya mambelele ghango, na ghene ghamanya nenga, ");
INSERT INTO dne_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ngita Tate chamanya nenga, na nenga nimanye Tate. Na nenga niubhoha ughome gwango kwa nhwalo gwa mambelele. ");
INSERT INTO dne_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ghabhii mambelele ghange gheniya ghabhii jhe mukibhajha chenje. Helahela nipala kwahaka na kwaleta kwa Chapanga. Helahela na bheniya nabhalijhoha lilobhe lyango, naghabhaha mungumbo ghumo na nnucha jhumo. ");
INSERT INTO dne_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tate ambahile ndi nhwalo niubhoha ughome gwango na kabhele naniupokela. ");
INSERT INTO dne_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Abhii jhe mundo nahotola kumboka ughome gwango. Nambo nenga niubhoha namwete kwa kupala kwango. Mi na uhotolo gwa kukibhoha kuwegha na ukindendeke gwa kubhehe na ughome kabhele. Ndi Tate gwango channaghalikiye ndende.” ");
INSERT INTO dne_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kwa nhwalo gwa malobhe gha Yecho ghajhakwatenda Akayahude bhapechengane kabhele. ");
INSERT INTO dne_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bhamahena bhajhakulonge, “Atehi kuchikilwa michuka na abhii na ngholoka! Nhwalo gwa nike kunyokanikiya?” ");
INSERT INTO dne_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nambo bhange bhajhakulonge, “Mundo jwabhii na nchuka ihoto jhe kulonge malobhe naha. Bho, nchuka uhoto kunnamicha mundo jwangalola?” ");
INSERT INTO dne_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kwenio ku Yeluchalemo kukibha na Unyagho gwa kuibheka Nyumba jha Bhambo palonge jha Chapanga, ukibha muda gwa malile. ");
INSERT INTO dne_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yecho akibha atyangita pa Nyumba jha Chapanga, pa Bwalo jha Chelemane. ");
INSERT INTO dne_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bhahe, Akayahude bhajhakuntindila na kunkonya, “Namutuleka changa umanya ade ligha? Anda mwe ndi Kilichitu Nkomboche, mutulobholele hotuhotu.” ");
INSERT INTO dne_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yecho ajhakwajhanguu, “Nikanobholile chakaka, nambo mangota minyekete jhe. Mahengo ghinihenga nenga kwa liina lya Tate gwango ghinangiya nenga ndi. ");
INSERT INTO dne_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Nambo mangota minyekete jhe nhwalo mangota mambelele ghango jhe. ");
INSERT INTO dne_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mambelele ghango ulijhoha lilobhe lyango. Bhamanya na bhene ungengama nenga. ");
INSERT INTO dne_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nenga nipekeya ughome gwa machiko ghoha ghangapeta, na bhene nabhahwe jhe, amu abhii jhe mundo nahotola kumboka mu mabhoko ghango. ");
INSERT INTO dne_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tate gwango jwambekiye mambelele ghanga ndi nkolongwa kupeta bhoha, abhii jhe mundo jwahotola kumboka kubhoka mu mabhoko gha Tate gwango. ");
INSERT INTO dne_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nenga na Tate gwango, tubhii maghumba nde.” ");
INSERT INTO dne_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bhahe, Akayahude bhajhakulokota maghanga kabhele kupala bhankome Yecho, ");
INSERT INTO dne_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","nambo Yecho ajhakwalobholela, “Ninangiye mahengo ghamahele kuhumii kwa Tate. Bho, lihengo ghane lyambone lintenda ungome kwa maghanga?” ");
INSERT INTO dne_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Akayahude bhajhakunnyanguu, “Tunkoma jhe kwa maghanga kwa nhwalo gwa mahengo ghambone, nambo kwa nhwalo gwa kunapanikiya Chapanga! Mwenga mwa mundo tugha, nambo mukilonge ma Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yecho ajhakwajhanguu, “Ikajhandikwe jhe mu Lilaghalikilo lino, Chapanga akalongile, ‘Mangota ndi ichapanga.’ ");
INSERT INTO dne_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Chapanga akaikemite ichapanga yela bhubhakamanye malobhe ghake, na twenga tumanya kubhehe Majhandiko gha Chapanga ghilonge chakaka machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ngoheno Tate gwango anhagwii na kunduma pannema pano. Nhwalo gwa nike milonge ninighite Chapanga, nhwalo nongile kubhehe nenga ndi Mwana gwa Chapanga? ");
INSERT INTO dne_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Anda nihenga jhe mahengo gha Tate gwango, nkotoka kunnyeketela. ");
INSERT INTO dne_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nambo anda nihenga jhe mahengo ghake, na mwamela minyekete jhe, mughajheketele mahengo ghango, peniya nabangatuka chakaka anda Tate abhii nkate jhango, na nenga nkate jha Tate.” ");
INSERT INTO dne_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Peniya bhajhakujhigha kumpyeneneka kabhele, nambo Yecho ajhakwanyelembuka mu mabhoko ghabhe na kwaleka. ");
INSERT INTO dne_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Peniya Yecho ajhakujhomboka kabhele kwiye jha lukemba lwa ku Yolodane, kola Yohane kwabatichila bhando na kutama kwenio. ");
INSERT INTO dne_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bhando bhamahele bhajhakunyendelela Yecho na kunnobholela, “Yohane akatehi jhe nginyililo hilu jhimo, nambo ghoha ghalongila Yohane panane jha mundo jhonjo ndi chakaka chika.” ");
INSERT INTO dne_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bhando bhamahele bhubhakibha peniya bhajhakunnyeketela Yecho. ");
INSERT INTO dne_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pakibha na mundo jhumo liina lyake Lachalo, jwabhelwikilwe ku muche gwa ku Betaniya atehila kulwalwa. Na kwenio ku Betaniya bhatamita pamonga na akalombo mundo Macha na Maliya. ");
INSERT INTO dne_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maliya jwenio ndi jhojho jwampakita mahuta ghighanungila petelele mu magholo gha Bhambo Yecho na kunhunguu kwa majhunjo ghake, na nhwacha mundo Lachalo akibha nga pahe nhwalo atehila kulwalwa. ");
INSERT INTO dne_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bhahe, akalombo mundo bhoha, bhajhakutuma lilobhe kwa Yecho, bhalongila, “Bhambo, nkoche gwino jhumumpahile abhii nga pahe tugha.” ");
INSERT INTO dne_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yecho pajhohina tu malobhe gheniya, ajhakulonge, “Ulwalo ghongo naunkome jhe Lachalo, nambo ulwalo ghongo upitile kwa ung'alicho gwa Chapanga, na Mwana gwa Chapanga alombwe kupete ulwalo ghongo.” ");
INSERT INTO dne_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yecho akabhapahi Macha na nnombo mundo Maliya pamonga na Lachalo. ");
INSERT INTO dne_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Yecho pajhohina Lachalo abhii nga pahe, ajhakujhonjekeya machiko mabhele gha kutama kwenio kwakibha. ");
INSERT INTO dne_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bhahe, Yecho ajhakwalobholela bhabholwa bhake, “Tubhujhe kabhele ku Yudeya.” ");
INSERT INTO dne_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bhabholwa bhala ngabhannobholila, “Mmola, machiko ghandina tugha ghughapetite Akayahude bhapata bhankome kwa maghanga, nhwalo gwa nike mipala kujhenda kabhele kwenio?” ");
INSERT INTO dne_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yecho ngabhajhangwila, “Bho, muhe ubhii jhe na machaa kome na mabhele? Bhahe, mundo anda atyanga machaa gheniya akobhondoka jhe nhwalo alubhona lumule lwa nnema ghongo. ");
INSERT INTO dne_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nambo anda mundo atyanga uhiko ukobhondoka, nhwalo ubhii jhe ukalamuhe.” ");
INSERT INTO dne_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yecho pajhomolila kulonge gheniya, ajhakwalobholela, “Nkoche gwito Lachalo abhii lughono, nambo nanyenda kung'ang'anula.” ");
INSERT INTO dne_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bhabholwa bhake ngabhannobholila, “Bhambo, anda atehi kugholoka, bhahe, nalama.” ");
INSERT INTO dne_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yecho alongila naha, mana jhake Lachalo ajhomwike, nambo bhabholwa bhake bhahambwika Lachalo agholwike lughono tugha. ");
INSERT INTO dne_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Bhahe, Yecho ajhakwalobholela hotuhotu, “Lachalo ajhomwike, ");
INSERT INTO dne_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","nambo kwa nhwalo gwenio nihanganila, nhwalo nenga nikibha jhe kwenio kupala nnyeketele. Bhahe, tujhende hote kwatamita.” ");
INSERT INTO dne_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Peniya Tomache, pange akemitwa Mabhela ajhakwalobholela bhabholwa bhajhake, “Tujhendengane na Mmola, tukawe na Yecho!” ");
INSERT INTO dne_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yecho pahikita ku Betaniya, ankolila yegha jha Lachalo ibhekwitwe umambe machiko ncheche ghighapetite. ");
INSERT INTO dne_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kuhumii pa chenda jha ku Betaniya ade ku Yeluchalemo, utale gwa kilomita itato tugha, ");
INSERT INTO dne_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","na Akayahude bhamahele bhajhakujhenda kwapepecha malelo Macha na nnombo mundo Maliya nhwalo gwa kuhwelelwa na nhwacha gwabhe. ");
INSERT INTO dne_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bhahe, Macha pajhohina Yecho abhii undela kuhika, ajhakujhenda kupengelela koko kundela, nambo Maliya unung'una mundo ajhakuhighalika ukajha. ");
INSERT INTO dne_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Macha ajhakunnobholela Yecho, “Bhambo, ngamehe pamba, nhwacha gwango ngajhomwike ndeka! ");
INSERT INTO dne_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nambo nimanya, ade ngoheno Chapanga nampela chochoha chumunyopa.” ");
INSERT INTO dne_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yecho ngannobholila, “Nhwacha gwino nayoka.” ");
INSERT INTO dne_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Macha nganyangwila, “Nimanya, nayokechwa kabhele lichiko lela Chapanga nabhayokecha bhubhawile.” ");
INSERT INTO dne_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yecho ajhakunnobholela, “Nenga ndi nayokecha bhando na kwapela ughome gwenio. Mundo jwanyeketela nenga, anda awile abhehe na ughome, ");
INSERT INTO dne_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","na kila jwabhii na ughome na kunyeketela, nahwe ng'o. Bho, gheniya mughajheketela?” ");
INSERT INTO dne_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Macha ajhakunyanguu, “Chakaka Bhambo! Nenga nyeketile kubhehe mwenga ndi mwa Kilichitu, Mwana gwa Chapanga, jhuhikite pannema.” ");
INSERT INTO dne_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Macha pajhomolila kulonge malobhe gheniya, ajhakujhenda nkate kunkema Maliya nnombo mundo pakiyepela, ajhakunnobholela “Mmola ahikite pamba, na atenda kunkema.” ");
INSERT INTO dne_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maliya pajhohina gheniya, ajhakujhinuka kajhombe na kunyendelela Yecho. ");
INSERT INTO dne_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yecho akibha amela anajhingii ndeka pachenda, akibha koko kwapengelile Macha. ");
INSERT INTO dne_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bhahe, Akayahude bhubhakibha nkate bhapepicha Maliya, pubhammonita Maliya ajhinuka kajhombe na kubhoka, bhajhakunkengamila bhahambwika ajhenda kulela ku mambe. ");
INSERT INTO dne_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bhahe, Maliya pahikita pabhii Yecho na pammonita, ajhakuntamii makilikite na kunnobholela, “Bhambo, ngamehe pamba, nhwacha gwango ngahwii ndeka!” ");
INSERT INTO dne_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yecho panolokiya Maliya abhii mahole chwii, na bhala Akayahude bhubhalongohine helahela bhabhii mahole tyee, Yecho mwojho gwake ujhakubhehe ngolongonde na ajhakuhechuka. ");
INSERT INTO dne_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Peniya Yecho ajhakwakonya, “Mumekite kojhe?” Bhajhakunyanguu, “Bhambo, nhwike nnole.” ");
INSERT INTO dne_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yecho ajhakubhehe mahole chwii. ");
INSERT INTO dne_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bhahe, Akayahude bhajhakulonge, “Dolokeya, chakampahi Lachalo!” ");
INSERT INTO dne_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nambo bhando bhange bhalongila, “Jhonjone jwakanamiche jwangalola jhola, bho, alepelile nike kunhibhilikiya Lachalo akoto kuwegha?” ");
INSERT INTO dne_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Bhahe, Yecho pakibha amela na ungolongonde kabhele kumwojho gwake, ajhakujhenda ade kumambe, mambe jhela ikibha nkwembe, na iyekelilwe kwa lighanga. ");
INSERT INTO dne_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yecho ngalongila, “Kangila hoko lighanga lende!” Macha, ndi nhwacha mundo jwajhomwike jhola, ajhakulonge, “Bhambo, nambo anunga njii nhwalo, machiko ncheche mukuwe kwake!” ");
INSERT INTO dne_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Peniya Yecho ajhakunnobholela, “Bho, nikanobholile jhe anda nnyeketele namubhona ung'alicho gwa Chapanga?” ");
INSERT INTO dne_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Bhahe, bhajhakulikangila lighanga kuhupele. Peniya, Yecho ajhakulola miho ghake kunane, ajhakulonge, “Tate, ninomba nhwalo mwenga unyokinikiya nenga. ");
INSERT INTO dne_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nimanya machiko ghoha unyokanikiya, nambo nilonge ghanga nhwalo jha bhando bhubhajhemite bhamba, nipala bhanyeketele kubhehe mwenga ndi jhundumita.” ");
INSERT INTO dne_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yecho pajhomolila kulonge gheniya, ajhakunonoha lilobhe likolongwa ankemita, “Lachalo, mpite panja!” ");
INSERT INTO dne_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na jwenio jwakawile ajhakupita panja kongo mabhoko na magholo ghake ghabhilingilwe chanda ade kumiho. Yecho ajhakwalobholela, “Mumopole ngobho yenio, na muneke ajhende.” ");
INSERT INTO dne_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bhahe, Akayahude bhamahele bhubhakahikite kwa Maliya, pubhalolita ilebhe yatehila Yecho, bhajhakunyeketela. ");
INSERT INTO dne_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nambo bhange pakate jhabhe bhajhakujhenda kwa Mapwalichayo, bhajhakwalobholela mambu ghatehila Yecho. ");
INSERT INTO dne_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bhahe, akapiya matambiko bhakolo na Mapwalichayo bhajhakutama pa Bwalo jha mihalo jha Akayahude na kukonyana, “Tuhenge nike? Mundo jhonjo atehi nginyililo yamahele! ");
INSERT INTO dne_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Anda tunekite ajhandelele naha, kila mundo nanyeketela, na peniya bhakolo bha ku Loma nabhahika kutilulana Nyumba jha Chapanga na kilambo chito na bhando bhito!” ");
INSERT INTO dne_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mundo jhumo pakate jhabhe, liina lyake Kayafa, jwakibha Mpiya Litambiko Nkolongwa kwa chaka chenie, ajhakulonge, “Mangota mwenga kutundungila kwenio! ");
INSERT INTO dne_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mlola jhe mbaha jhumo akihwelele kwa nhwalo jha bhando bhoha, kuliku kilambo choha kihobhelele?” ");
INSERT INTO dne_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Alongila naha chi kwa kuwacha jwenio, nambo nhwalo akibha Mpiya litambiko nkolongwa kwa chaka chenie, akalondwii Yecho nahwaa kwa nhwalo gwa Akayahude bha kilambo chenie. ");
INSERT INTO dne_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na kuwee kwake chi nhwalo gwa Akayahude tugha, nambo helahela nabhabheka pamonga bhando bha Chapanga bhibhapechengine bhabhaha pamonga. ");
INSERT INTO dne_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kuhumii lichiko lyenio, bhakolo bha Kiyahude bhajhakupalaha nginyika jha kunkoma Yecho. ");
INSERT INTO dne_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Bhahe, Yecho atyangita jhe kwa kukilangiya hotuhotu pakate jha Akayahude. Ajhakubhoka kwenio na kuheghelela pahina na njenga, ku muche ghukemitwa ku Efulahimo. Ajhakutama kwenio pamonga na bhabholwa bhake. ");
INSERT INTO dne_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Unyagho gwa Akayahude gwa Pachaka pubhandikila, bhando bhamahele bhajhakubhoka kuchenda na kuhobhoka kujhenda ku Yeluchalemo bhakajhelebhulwe bhibhanyope Chapanga kabula jha unyagho gwa Pachaka. ");
INSERT INTO dne_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bhahe, bhampaliya Yecho. Nabhakonganika pa Nyumba jha Chapanga, bhajhakukikonya, “Muwacha bho? Bho, nahika paunyagho ghongo?” ");
INSERT INTO dne_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nambo akapiya matambiko bhakolo na Mapwalichayo bhajhakulaghalikiya kwa mundo jhojhoha jwapamanye pabhii Yecho alonge, bhakampyeneneke. ");
INSERT INTO dne_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bhahe, ghakahighalike machiko chita kabula jha unyagho gwa Pachaka, Yecho ajhakujhenda ku Betaniya kwatamita Lachalo, jhola mundo jwakayokiche. ");
INSERT INTO dne_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kwenio bhakanenganikiye Yecho ndalilo, Macha ndi jwabhatelikila. Lachalo akibha pakate jwa bhala bhubhalila pamonga na Yecho. ");
INSERT INTO dne_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bhahe, Maliya ajhakutola nucho jha chupa jha mahuta ghighanungila petelele ghighahumile mukongo ghuukemwa nalido, na kupakaya mumagholo gha Yecho, na kunhungula kwa majhunjo ghake. Na nyumba jhoha ijhakubhehe petelele kwa mahuta gheniya. ");
INSERT INTO dne_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nambo Yuda Isikaliote, jhumo jwa bhabholwa bhala kome na bhabhele, ndi jwampala kunyambila Yecho ajhakukonya, ");
INSERT INTO dne_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nhwalo gwa nike mahuta ghangano ghachuluchwe jhe kwa imbembela ya feza ya madine makome chelachine gha mbijha na yenio kwabhaghanichila akahocho?” ");
INSERT INTO dne_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yuda alongila naha chi nhwalo gwa kwabhone kiya akahocho, nhwalo akibha mwihe. Helahela jwenio ndi ntucha kihukilo cha kubheke mbijha na akibha akwatwila mbijha kuhumi mwenio mukihukilo. ");
INSERT INTO dne_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nambo Yecho ajhakwalobholela, “Nkotoka kung'aha majhe jhonjo! Atehi naha kulenganikiya lichiko lya malelo ghango. ");
INSERT INTO dne_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nantamangana na akahocho machiko ghoha, nambo nenga name jhe na mangota kwa machiko ghoha.” ");
INSERT INTO dne_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lilongo likolongwa lya Akayahude bhajhakujhoha kubhehe Yecho abhii ku Betaniya bhajhakujhenda kwenio, chi bhakajhahwii kunninga Yecho tugha helahela bhakajhahwii kuninga Lachalo, mundo jhola Yecho jwayokiche kuhumii kumambe. ");
INSERT INTO dne_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bhahe, bhapiya matambiko bhakolo bhatehila nginyika jha kunkoma Lachalo, ");
INSERT INTO dne_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","nhwalo chela chikimpeti Lachalo, Akayahude bhamahele bhakanyendilii Yecho na kunnyeketela. ");
INSERT INTO dne_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kilabho jhake lilongo likolongwa lya bhando bhakahikite ku Unyagho gwa Pachaka, bhajhakujhoha Yecho abhii undela kuhika ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bhahe, bhajhakutola matuto gha mikongo jha mitende na kujhenda kunpokela, kongo bhachobhila kanonoho bhalongila, “Tunnombe Chapanga! Jhuna mota jwenio jwahika kwa liina lya Bhambo! Jwenio jhuna mota Munahota Nkolongwa jwa Akaichilahele!” ");
INSERT INTO dne_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yecho ajhakummona litohe lya liponda na kuhobhokela panane jhake, ngita chighalongila Majhandiko gha Chapanga, ");
INSERT INTO dne_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Nkotoka kulendema, bhando bha ku Sayune! Dolokeya, Munahota Nkolongwa gwino atenda kuhika, ahobhokii panghongo gwa litohe lya liponda.” ");
INSERT INTO dne_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kutumbuli bhabholwa bhake bhakamanyite jhe malobhe gheniya. Nambo Yecho payokita na kupelwa ung'alicho, ndi bhabholwa pibhakombwika Majhandiko gha Chapanga kubhehe gheniya ghoha ghakajhandikwe panane jhake na bhando bhakantendi mambu gheniya. ");
INSERT INTO dne_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lilongo likolongwa lya bhando lilikalongohine na Yecho pankemita Lachalo apite umambe na kuyoka, bhakalongile ghala ghughapitile. ");
INSERT INTO dne_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lilongo lyenio lyoha lijhakujhenda kunpokela nhwalo bhoha bhakajhohine nginyililo yatehila Yecho. ");
INSERT INTO dne_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Bhahe, Mapwalichayo bhajhakukonyana, “Nnolite, tuhoto ndeka hilu kuhenga kilebhe chochoha! Bhando bhoha bha pannema bhankengama!” ");
INSERT INTO dne_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bhahe, pakibha na Akaghilike bhamahele pakate jha bhala bhando bhubhakahikite ku Yeluchalemo kunnyinamila Chapanga pa Unyagho gwa Pachaka. ");
INSERT INTO dne_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bheniya bhajhakunyendelela Filipu, mundo jwabhelwikilwe ku Betisaida ku kilambo cha ku Galilaya na bhajhakunnobholela, “Munahota, tupala kummona Yecho.” ");
INSERT INTO dne_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipu ajhakunnobholela Anduleya, na peniya bhoha bhajhakujhenda kwa Yecho kunnobholela. ");
INSERT INTO dne_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yecho ajhakwalobholela, “Lichaa lihikite lya Mwana gwa Mundo kulombwa. ");
INSERT INTO dne_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ninnobholela chakaka, lumbonje lwa mponga anda lugwelii muundope na kuwegha, naluhighalika hele lumo tugha. Nambo luhwii na kumela naibhaha mbwee. ");
INSERT INTO dne_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mundo jwaupala ughome gwake nauhobhecha, na mundo jwauchimwa ughome gwa pannema ghongo, jwenio ndi napelwa ughome gwa machiko ghoha ghangapeta. ");
INSERT INTO dne_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Anda mundo ambala kundelekela angengama, ntumiche gwango nabhaha pamonga pumii nenga. Mundo anda andelekile, Tate gwango nannyeketela. ");
INSERT INTO dne_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ngoheno mwojho gwango ubhii ngolongondi, na nenga nonge bhole? Nonge, ‘Bho, Tate, naungombola pa lichaa lende?’ Nahi ndeka, ndi mana ihikite kwa nhwalo ghogho, mbete mulichaa lende lya malagho. ");
INSERT INTO dne_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“Tate, liina lino lilombwe!” Peniya lilobhe kuhumii kunane kwa Chapanga lijhakujhokanikika lilongila, “Nililombite, na nanililomba kabhele.” ");
INSERT INTO dne_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bhahe, lilongo lyoha lya bhando lilikajhemite peniya likajhohine malobhe gheniya na bhange ngabhalongila, “Ndi nnindimilo gwa mbamba.” Na bhange bhalongila, “Ntumiche jwa kunane kwa Chapanga jwalongila nako!” ");
INSERT INTO dne_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nambo Yecho ajhakwalobholela, “Malobhe gheniya ghinyohine chi kwa nhwalo gwa nenga, lihikite kwa nhwalo gwino mangota. ");
INSERT INTO dne_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ndi lichaa lya bhando bha nnema ghongo kuhadabulwa, ngoheno limbembela kilongoche jwa nnema ghongo nabhengwa. ");
INSERT INTO dne_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nambo nenga pumbala kujhinuliwa kuhumii panane jha pannema nanahuta bhando kuhika kwa nenga.” ");
INSERT INTO dne_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yecho alongila gheniya alangiya chapala kuwegha. ");
INSERT INTO dne_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Bhahe, lilongo lya bhando lijhakunkonya, “Twenga tulobholilwe na lilaghalikilo lito kubhehe Kilichitu nabhehe na ughome gwa machiko ghoha. Nhwalo gwa nike mulonge ete Mwana gwa Mundo ipala ajhinulilwe kunane? Na jwenio Mwana gwa Mundo ndi kilebhe ghane?” ");
INSERT INTO dne_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Peniya Yecho ajhakwalobholela, “Nantama mulubhendo kwa machiko ghandina. Ntyange na kongo kubhii kuloleka, kabula jha lubhendo lunankolela ndeka. Mundo jwatyanga mulubhendo amanyite jhe kwajhenda. ");
INSERT INTO dne_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Bhahe, mulunyeketela lumule nhwalo mminalo kupala mme bhando bha pakalamuhe.” Pajhomolila kulonge gheniya Yecho, ajhakujhenda kukihiya bhakoto kummona. ");
INSERT INTO dne_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pamonga na Yecho kuhenga nginyililo yamahele palonge jhabhe, nambo bhakanyeketii ndeka. ");
INSERT INTO dne_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bhahe, malobhe ghighalongilwa na jwakibha nnondole jwa Chapanga Isaya ghatimile, “Bhambo, ghane najheketela malobhe ghito? Bho, na uhotolo gwa Bhambo uyekulilwe kwa ghane?” ");
INSERT INTO dne_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndi nhwalo bhakanite kujheketela, helahela nnondole jwa Chapanga Isaya akalongi kabhele, ");
INSERT INTO dne_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Chapanga abhatochwi miho ghabhe, abhabhoghaniche malango ghabhe, Bhakotoka kulola kwa miho ghabhe, hilu bhakotoka kumanya kwa malango ghabhe, na bhakotoka kung'alambukila nenga, na kwalamicha.” ");
INSERT INTO dne_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya alongila gheniya, nhwalo akauwene ung'alicho gwa Yecho na kulonge malobhe panane jhake. ");
INSERT INTO dne_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pamonga na gheniya ilongoche yamahele ya Kiyahude bhakanyeketile Yecho. Nambo nhwalo gwa Mapwalichayo bhakalongile ndeka hotuhotu palonge jhabhe bhajhogwipa kubhengwa munyumba jhakukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nhwalo bhene bhaghanita kukweywa na bhando kuliku kukweywa na Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Bhahe, Yecho ajhakulonge kwa lilobhe likolongwa, “Mundo jhojhoha jwannyeketela nenga, chi anyeketela nenga kanjika helahela anyeketela na jhola jwandumita. ");
INSERT INTO dne_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mundo jhojhoha jwamwene nenga helahela amwene jhola jwandumita. ");
INSERT INTO dne_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nenga nhikite mee lilangamule kwa bhando bha pannema, mundo jhojhoha jwanyeketile akoto kubhehe mulubhendo. ");
INSERT INTO dne_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mundo anda ajhohine malobhe ghango changaghahenge lihengo, ne ndeka jhunipala kunhadabula. Nhwalo hikitejhe kwahadabula bhando bha nnema nambo hikite kwakombola. ");
INSERT INTO dne_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jhola jwangana nenga na malobhe ghango, jwenio akwete jwa kunhadabula. Lilobhe lilinongolila ndi nalinhadabula lichiko lya mwicho! ");
INSERT INTO dne_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nhwalo nenga nikalongi ndeka kwa ukindendeke gwango namwete, nambo Tate gwango jwandumita ndi anaghalikiya nike cha kulonge na nike chakwalobhole bhando. ");
INSERT INTO dne_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nenga nimanya kubhehe lilaghalikilo lyake libhehe na ughome gwa machiko ghoha. Bhahe, nenga nongile ghala tugha ghanaghilikiya Tate nongele.” ");
INSERT INTO dne_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Likahighalike lichiko limo kujhimukila Unyagho gwa Pachaka. Yecho akamanyite chaa jhake jha kubhoka pannema pano nu kujhenda kwa Tate mundo lihikite. Akajhendilile kwapala bhando bhake pannema ghongo, akabhapahile kwa upalo gwangajhomoka. ");
INSERT INTO dne_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Bhahe, Yecho na bhabholwa bhake pubhalalila kimiye. Limbembela akanyingii Yuda mwana gwa Simone Chikaliote na kumpela mawacho gha kunnyambila Yecho. ");
INSERT INTO dne_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yecho akamanyite kubhehe Tate mundo ankamwii ukindendeke gwa kila kilebhe, na akamanye ahumila kwa Chapanga na akamanye nakelebhuka kabhele kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bhahe, Yecho ajhakubhoka pakiheneko, ajhakuhula ngobho jha panja jhake, kutabha nkunge pakibhuno. ");
INSERT INTO dne_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Peniya ajhakubheka mache mkambo na kutumbuu kwagholola bhabholwa bhake magholo na kwahungulila kwa ngobho jhakungite nkunge jhela. ");
INSERT INTO dne_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bhahe, Yecho pahikita kwa Simone Petile, Petile ajhakunnkonya, “Bhambo, bho, mwenga migholola magholo ghango?” ");
INSERT INTO dne_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yecho panyangwila, “Ngoheno naumanyiijhe chinihenga, nambo palonge nabangatuka.” ");
INSERT INTO dne_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petile ajhakunnobholela, “Mbahijhe mangang'olole jhe magholo ghango!” Yecho panyangwila. “Anda nkanikiye kungholola magholo ghino namme ndeka mabholwa bhango.” ");
INSERT INTO dne_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simone Petile ajhakunnobholela, “Bhambo, nkotoka kugholola magholo ghango tugha helahela ung'olola mabhoko na muto gwango!” ");
INSERT INTO dne_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yecho panyangwila, “Mundo jwajhoghite njwe yegha jhoha abhii nyahinyahi ipalwa jhe kugholola magholo, mangota mmii nyahinyahi nambo mabhoha ndeka.” ");
INSERT INTO dne_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yecho akaumanye jwapala kunnyambila jhola, ndi nhwalo alongila yenio, “Mangota mmii nyahinyahi nambo mabhoha ndeka.” ");
INSERT INTO dne_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yecho pajhomolila kwagholola magholo, ajhakuhwala ngobho na kubhujha kabhele pakatamite. Ajhakwakonya, “Bho, umanye ghunitendile?” ");
INSERT INTO dne_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Mangota ungema nenga mmola na Bhambo, na mwitenda chamaha, nhwalo ndi chimile. ");
INSERT INTO dne_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nenga Mmola na Bhambo gwino, ning'olwile mangota magholo ghino, na mangota helahela nng'ololane magholo mabhene. ");
INSERT INTO dne_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nenga ninangiye nnandanikiho mangota, na mangota ntende yenio ngita chinitendi nenga. ");
INSERT INTO dne_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ninnobholela chakaka, mmanda ahoto ndeka kubhehe munahota, hilu mundo jwatumwa chi nkolongwa kuliku jhola jwantumita. ");
INSERT INTO dne_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bhahe, nhwalo mughamanye gheniya, Chapanga annombe kwa kuhenga gheniya! ");
INSERT INTO dne_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ghunilonge ghano chi ghoha ghino mabhoha, namanyite bhala bhinahaghwile. Nambo Majhandiko gha Chapanga ghatimile ghighalongela, ‘Mundo jhola jhunilye nako kiheneko chimo ndi jwapala kunnyambila.’ ");
INSERT INTO dne_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nenga ninnobholela kabula jha kupitila palonge, kupala pughapala kutendeka mbala umanye na nnyeketela kubhehe ‘Nenga ndi Jhumile.’ ");
INSERT INTO dne_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ninnobholela chakaka, mundo jwampokela jhola jhunituma, jwenio ambokii nenga helahela, na mundo jwamboke nenga, ampokii jhola jwandumita.” ");
INSERT INTO dne_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yecho pajhomolila kulonge malobhe gheniya, ajhakubhehe ngolongondi ku mwojho gwake na ajhakwalobholela, “Ninnobholela chakaka, jhumo pakate jhino nandenda kunyambila.” ");
INSERT INTO dne_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bhabholwa bhake bhajhakulolehana kumiho, nambo bhakamanyite jhe annonge ghane. ");
INSERT INTO dne_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jhumo jwa bhabholwa bhake, jwakapahilwe na Yecho akatamite pahina jha Yecho. ");
INSERT INTO dne_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Bhahe, Simone Petile ajhakunkinyulila jhola mmola nnyake na kulonge, “Munkonye annonge ghane.” ");
INSERT INTO dne_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mmolwa jwenio ajhakuheghelela pahina na Yecho, ajhakunkonya, “Bhambo, minnonge ghane?” ");
INSERT INTO dne_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yecho ajhakwajhanguu, “Mundo jhola jhunipala kunyakiya libumunda linichwiya mubakule ndi jhojho.” Bhahe, Yecho ajhakutola kimbembela cha libumunda na kuchwiya mubakule na kumpekeya Yuda mwana gwa Simone Ichikaliote. ");
INSERT INTO dne_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Papalapala Yuda papokila tugha kimbembela chela cha libumunda, Limbembela lijhakunyingila. Bhahe, Yecho ajhakunnobholela, “Nhwenga kajhombe chipala kuhenga!” ");
INSERT INTO dne_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nambo akibha jhe hilu jhumo pakate jha bhala bhubhakibha pakiheneko jwakamanyite nhwalo gwa nike Yecho akannobholi naha. ");
INSERT INTO dne_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nhwalo Yuda akibha abhekita kihukilo cha mbijha, bhabholwa bhange bhahambwika Yecho anobholile akahemele ilebhe ya unyagho gwa Pachaka amu kwabhaghanichila akahocho ilebhe. ");
INSERT INTO dne_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Papalapala Yuda papokila tugha kimbembela chela cha libumunda, ajhakupita panja. Ikibha kilo. ");
INSERT INTO dne_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yuda papitita panja, Yecho palongila, “Ngoheno Mwana gwa Mundo alombitwe, na jwenio Chapanga alombitwe kupetela jwenio. ");
INSERT INTO dne_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Anda Chapanga alombwite nkate jha Mwana gwa Mundo, na Chapanga helahela nanomba Mwana gwa Mundo nkate jhake na jwenio nannomba changakiyoto. ");
INSERT INTO dne_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yana yango, nandama na mangota kwa machiko ghandina. Mangota naundenda kumbalaha, nambo ngoheno ninnobholela chela chinalobholila bhakolo bha Akayahude, ‘Kunijhenda mwihoto jhe kuhika.’ ");
INSERT INTO dne_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ngoheno nimpela lilaghano liyono, mpalane mabhene kwa mabhene. Ngita chinipala nenga na mangota helahela mpalane. ");
INSERT INTO dne_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Anda mpaline, bhando bhoha nabhamanya mangota ndi bhabholwa bhango.” ");
INSERT INTO dne_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simone Petile ajhakunkonya, “Bhambo, kojhe kumijhenda?” Yecho ajhakujhanguu, “Kunijhenda mihoto ndeka kungengama ngoheno nambo naungengama panyuma jhango.” ");
INSERT INTO dne_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petile ajhakunnobholela kabhele, “Bhambo, nakilimba nike kunkengama ngoheno?, Nenga nnyeketile kuwegha kwa nhwalo gwino!” ");
INSERT INTO dne_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yecho pajhangwila, “Bho, mwenga naunhwa kwa nhwalo jha nenga? Ninnobholela chakaka, naunganila patato lijhogholo nakubheka jhe.” ");
INSERT INTO dne_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yecho ajhakwalobholela bhabholwa bhake, “Nkotoko kubhehe ngolongondi kumiojho jhino, munyeketii Chapanga na unyeketela nenga helahela. ");
INSERT INTO dne_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nkate pa nyumba jha Tate gwango, ibhii chumbe twe anda nahijhe, nganinnobholile jhe nyenda kunenganikiya mangota yumbe hino. ");
INSERT INTO dne_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nenga pumbala kujhomolela kunenganikiya mangota pwache jhino, nahika kuntolangana, pumii nenga na mangota ntama papa. ");
INSERT INTO dne_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mangota mwiimanye ndela jha kuhika kwenio kunijhenda.” ");
INSERT INTO dne_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Bhahe, Tomache ajhakunkonya Yecho, “Bhambo, tukumanyi jhe kumijhenda, ngoheno natumanya bhole ndela jhene?” ");
INSERT INTO dne_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yecho ajhakunyanguu, “Nenga ndi ndela na uchakaka na ughome. Abhii jhe mundo najhenda kwa Tate changapete kwa nenga. ");
INSERT INTO dne_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ngaumanya nenga, helahela ngaumanye Tate gwango. Kutumbulii ngoheno mumanyite na umwene.” ");
INSERT INTO dne_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipu ajhakunnobholela, “Bhambo, mutulangiye Tate gwino na jwenio jhutumpala.” ");
INSERT INTO dne_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yecho ajhakunnobholela, “Filipu nikibha na mangota kwa machiko ghoha, bho, umanyite jhe nenga? Mundo jhojhoha jwamwene nenga amwene Tate. Nhwalo gwa nike mulonge, ‘Mutulangiye Tate?’ ");
INSERT INTO dne_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Bho, Filipu unyekete ndeka Tate nkate jhango na nenga nkate jhake? Malobhe gheniya ghuninnobholela chi kwa ukindendeke gwango, nhwalo Tate jwatama nkate jhango ndi jwahenga lihengo lyake. ");
INSERT INTO dne_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Unyeketele puninnobholela nenga mii nkate jha Tate na Tate abhii nkate jha nenga. Anda minyekete jhe malobhe bhahe, nnyeketele kwa mahengo ghinihenga. ");
INSERT INTO dne_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ninnobholela chakaka, mundo jwanyeketela nenga nahenga mahengo ngita ghunihenga nenga. Chakaka, nahotola kuhenga kupeta ghanga, nhwalo nenga nijhenda kwa Tate gwango. ");
INSERT INTO dne_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bhahe, nnyope chochoha chumipala kwa liina lyango nahenga, Tate alombwe kupete Mwana. ");
INSERT INTO dne_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Anda unyopite kilebhe chochoha kwa liina lyango, chanihengela.” ");
INSERT INTO dne_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Anda naumbala, nakamula malaghalikilo ghango. ");
INSERT INTO dne_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nenga naninyopa Tate gwango, Jwenio nampela ntumiche jhonge, jwapala kutama na mangota machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jwenio ndi Uhuke gwa Chapanga, jwatuyekula uchakaka panane jha Chapanga. Bhando bha nnema bhihoto ndeka kumpokela, nhwalo bhahoto ndeka kummona hilu kuumanya. Nambo mangota muumanye nhwalo atama na mangota na abhii nkate jhino.” ");
INSERT INTO dne_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Pumbala kubhoka nanineki jhe mangota ngita makakebha, nanimujhila kabhele. ");
INSERT INTO dne_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pahighalii pandina bhando bha pannema nabhammona jhe kabhele, nambo mangota naumona. Nhwalo nenga mii na ughome, na mangota helahela mmii maghome. ");
INSERT INTO dne_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mu machiko gheniya, naumanya nenga mii nkate jha Tate gwango, na mangota mmii nkate jhango, na nenga nkate jhino. ");
INSERT INTO dne_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Mundo jhola jwaghapokela malaghilo ghango na kughakamula, mundo jwenio ndi ambahile. Tate gwango nampala mundo jhola jwambahi nenga, helahela nenga nanikilangiya kwa jwenio.” ");
INSERT INTO dne_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yuda, chi Yuda Chikaliote ajhakunnobholela, “Bhambo, nhwalo ghane mukilangiya kwa twenga tugha na chi kwa bhando bha pannema ghoha?” ");
INSERT INTO dne_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yecho panyangwila, “Mundo anda ambahi nenga nabhaha chokochoko na mabholo ghango. Tate gwango napala, Tate na nenga natuhika na kutama nkate jhake.” ");
INSERT INTO dne_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mundo jhojhoha jwangambala aghakamuu ndeka mabholo ghango. Mabholo ghunyohina gha ne jhe, ghahumi kwa Tate gwango jwandumita. ");
INSERT INTO dne_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ninnobholela malobhe ghanga punikibha pamonga na mangota mwenga. ");
INSERT INTO dne_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tate gwango nantumila Ntumiche kwa liina lyango ndi Uhuke gwa Chapanga, namolangana umanya kila kilebhe na kunkombocha ghoha ghuninnobholila. ");
INSERT INTO dne_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Niuleka uteeke kwino, nimpela uteeke gwango. Nimpela ndeka uteeke ngita bhando bha nnema chibhatenda. Nkotoka kubhehe ngolongondi kumiojho jhino hilu bwaghaliya. ");
INSERT INTO dne_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mukajhohine puninnobholila, ‘Ndenda kukibhokela, nambo namujha kabhele.’ Anda ngaumbala ngauhanganile nenga nijhenda kwa Tate, nhwalo Tate gwango nkolongwa kuliku nenga. ");
INSERT INTO dne_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ninnobholile gheniya ngoheno kabula jha kupitila, nambo pughapala kupitila nnyeketela. ");
INSERT INTO dne_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nanongela ndeka malobhe ghamahele na mangota, nhwalo limbembela kilongoche jwa nnema ghongo abhii kuhika kwa nenga akwete jhe likakala lyolyoha, ");
INSERT INTO dne_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","nambo mbala bhando bha nnema bhamanye anda nimpala Tate. Nenga nihenga chechelachela ngita chanaghalikiye Tate gwango. “Ngoheno nnyemengane tubhoke! ");
INSERT INTO dne_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nenga ndi nchabibo gwa chakaka, na Tate gwango ndi jwalema. ");
INSERT INTO dne_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jwenio ulipengula lindabhe lyangapambika uhohe, na ulipatulila kila lindabhe lilipambika uhohe libhehe pochii. ");
INSERT INTO dne_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mangota mmii nyahinyahi nhwalo mughakamwile mabholo ghango ghuninnobholila. ");
INSERT INTO dne_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ntame nkate jhango, na nenga nandama nkate jhino. Libhii jhe lindabhe lilihoto kupambika lyenio, lipala lihighalika mulibelengete lya nchabibo. Helahela mangota mihoto ndeka kupambika uhohe changatama nkate jhango.” ");
INSERT INTO dne_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nenga ndi nchabibo gwenie, na mangota ndi mandabhe. Mundo jwatama nkate jhango na nenga ndame nkate jhake jwenio napambika uhohe pochii, nhwalo changa nenga mihoto ndeka kuhenga kilebhe chochoha. ");
INSERT INTO dne_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mundo jhojhoha changatama nkate jhango, abhehe ngita lindabhe lilitagwitwe na kujhoma. Mandabhe gheniya ujholwa, na kutagwa pamwotu na kubhehe ngaliho. ");
INSERT INTO dne_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Bhahe, anda ntamite nkate jhango na malobhe ghango ghabhii nkate jhino, nnyope chochoha chimukipala, na mangota nanipelangana. ");
INSERT INTO dne_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Anda mupambike uhohe pochii, Tate gwango jwa kunane nalombwa na mangota namma bhabholwa bhango. ");
INSERT INTO dne_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nenga nimpahi mangota ngita Tate chambahi nenga. Ngohe ntamengane umanye kongo nimpahile. ");
INSERT INTO dne_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Anda mulichokolikiye lilaghalikilo lyango, nantama muupalo gwango, anda nenga chingamwulikiye lilaghalikilo lya Tate gwango na kutama muupalo gwake.” ");
INSERT INTO dne_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nikannobholile mangota ghanga ghoha kupala luhangano lwango lubhaha nkate jhino na lukota kujhomoka. ");
INSERT INTO dne_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Lende ndi lilaghalikilo lyango, mpalane ngita chinipalita nenga. ");
INSERT INTO dne_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Abhii jhe jwabhii na upalo nkolongwa ngita ghongo kwa mundo kubhoha ughome gwake kwa nhwalo gwa akakoche mundo. ");
INSERT INTO dne_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mangota ndi makakoche bhango anda ntehi chela chininnaghalikiya. ");
INSERT INTO dne_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nikema jhe kabhele mangota makatumiche nhwalo ntumiche amanyitii jhe lihengo lya munahota gwake. Nambo ninkema akakoche bhango mangota, nhwalo ninnobholile ghoha ghunyohina kuhumii kwa Tate gwango. ");
INSERT INTO dne_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mangota mwenga jhe jhunhagwila nenga, nambo nenga ndi nikahaghuline mangota kupala ntende ilebhe yamahele yahanganii Chapanga, na gheniya mahengo naghatamikiya kwa machiko ghoha. Peniya Tate nampela kilebhe chochoha chumunyopa kwa liina lyango. ");
INSERT INTO dne_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Bhahe, lilaghalikilo lyango kwino lende pambano, mupalane. ");
INSERT INTO dne_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Anda bhando bha nnema bhachimwite mangota, umanye bhakatumbwi kunjimwa nenga. ");
INSERT INTO dne_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nga mme mabhando bha pannema ghongo, bhando bha nnema ngabhampahile ngita bhando bhake. Nambo nenga nihaghuline mangota kuhumii pannema papa na mangota mwenga chi bhando bha pannema ghongo kabhele, kwa nhwalo gwenio bhando bha nnema ghongo bhanchimwa. ");
INSERT INTO dne_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Bhahe, nkomboke malobhe ghuninnobholila, ‘Mmolwa ampeta ndeka mmola gwake.’ Anda bhando bhang'ahite nenga, na mangota nabhang'aha helahela, anda mughakamwii mabholo ghango, helahela nabhaghakamula mabholo ghino. ");
INSERT INTO dne_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nambo nabhahengela gheniya ghoha nhwalo mangota mabhando bhango, nhwalo bhaumanyitii jhe jhola jwandumita nenga. ");
INSERT INTO dne_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nakuhika jhe na kulonge nabho, ngabhabhii ndeka na uhakaho, nambo ngoheno bhahotola jhe kukikengelela panane jha uhakaho. ");
INSERT INTO dne_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mundo jwanjimwa nenga, helahela anchimwa Tate gwango. ");
INSERT INTO dne_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Anda nakuhenga jhe nginyililo inatendwa jhe na mundo jhonge, ngohe ngabhabhii jhe na uhakaho. Nambo ngoheno bhalolite nginyililo indehila nambo bhamela bhanjimwa nenga na Tate gwango. ");
INSERT INTO dne_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nambo ipitile nhwalo ghala ghighajhandikwe Mulilaghalikilo lyabhe ghabhii chakaka, ‘Nabhanjimwa jhajhe.’ ");
INSERT INTO dne_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nambo papala kuhika jwenio Ntumiche jhunimpala kuntuma kwino kuhumii kwa Tate, jwenio ndi Uhuke gwa Chapanga, jwenio nalongela chakaka panane jha Chapanga. Jwenio ahumi kwa Tate nannobholila malobhe ghango. ");
INSERT INTO dne_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mangota helahela namalobholela bhando malobhe panane jha nenga. ");
INSERT INTO dne_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ninnobholile malobhe ghanga, mbala nkotoka kuhobhecha kihobholelo chino. ");
INSERT INTO dne_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bhando nabhahibhilikiya kujhingii munyumba jha kukonganikii Akayahude. Naghahika machiko nabhankomangana nabhahambuka bhintende Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bhando nabhantendela ghenagha nhwalo gwangaumanya Tate hilu nenga. ");
INSERT INTO dne_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nambo ninnobholile ghanga, lichaa pulihika nkomboke ghala ghuninnobholile. “Kutumbulii makacho nikannobholi jhe ghanga nhwalo mukibha pamonga na namwete. ");
INSERT INTO dne_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nambo ngoheno nijhenda kwa jhola jwandumita, abhii jhe hilu jhumo jwangonya pakate jhino, ‘Nijhenda kojhe?’ ");
INSERT INTO dne_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nhwalo ninnobholila gheniya ghoha, ntwelile ungolongondi twe kumiojho jhino. ");
INSERT INTO dne_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nambo nenga ninnobholela gha chakaka, mbaha nenga moke, nhwalo nakubhoka jhe nenga jwenio Ntumiche nahikii jhe kwino mangota. Nambo anda nyahwii nanintuma kwino. ");
INSERT INTO dne_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jwenio papala kuhika, nabhalobholela bhando bha nnema ghongo bhamanyitii jhe uchakaka panane jha uhakaho na panane jha kuhadabulwa na Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bhamanyite ndeka uchakaka panane jha uhakaho, nhwalo bhanganite nenga, ");
INSERT INTO dne_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","bhamanyiti jhe uchakaka gwa bhando kujheketelwa palonge jha Chapanga nhwalo ndenda kukijhabhulila kwa Tate gwango. Mangota natukongane jhe kabhele, ");
INSERT INTO dne_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","uchakaka panane jha Chapanga kwahadabuu bhando, limbembela kilongoche jwa pannema pano bhahadabwii njwe. ");
INSERT INTO dne_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ngwete malobhe ghamahele ghakunnobholela, nambo ngoheno uhotolo gwino gwa kuhimbilila gwandina. ");
INSERT INTO dne_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nambo Uhuke gwa Chapanga papala kuhika, nannobholela chakaka na kunnongocha panane jha muchakaka gwa Chapanga gwoha. Nhwalo nalongela ndeka kwa ukindendeke gwake jwenio, nalongela ghapala kujhoha kuhumii kwa Tate na kuntangachii mangota ghighahika. ");
INSERT INTO dne_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Bhahe, jwenio nannomba nenga, kwa nhwalo nabhola ghoha ghapatite kwa nenga. ");
INSERT INTO dne_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Yoha yabhii nako Tate ya nenga. Ndi nhwalo nongile kubhehe jwenio Uhuke gwa Chapanga natangachila ghighahuma kwa nenga. ");
INSERT INTO dne_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ghahighalike machiko ghandina mangota naumoni jhe, anda ghapetite gheniya naumona kabhele.” ");
INSERT INTO dne_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Bhahe, bhabholwa bhake bhange bhajhakukonyana, “Ghahighalike nhwalo gwa nike patulobholela ghamela ‘Machiko ghandina mangota naumoni jhe kabhele?’ Anda ghapetite gheniya naumona kabhele. Helahela alonge, ‘Bho, Nhwalo nijhenda kwa Tate gwango?’ ");
INSERT INTO dne_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Bhene pubhajhendilila kukonyana, ‘Machiko gwandina’ nike mana jhake? Tumanyitii jhe chalonge!” ");
INSERT INTO dne_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yecho akamanyite bhapala kunkonya, bhahe, ajhakwalobholela, “Bho, mwamela mukakonyana panane jha malobhe ghunongila ghala, ghahighalike nhwalo gwa nike patulobholela ghamela ‘Machiko ghandina, mangota mwenga naumoni jhe kabhele anda ghapetite gheniya naumona kabhele?’ ");
INSERT INTO dne_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ninnobholela chakaka, nannela mahole chwii mangota na kulela, nambo bhando bha pannema nabhahanganila. Nama ungolongonde nambo ungolongonde gwino naughalambuka na kubhehe kiheko. ");
INSERT INTO dne_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Mwikeghe nabhaha na lipyanda lya kupapa, ulijhoha lipyanda lya kupapa nhwalo machaa gha kubhina ghahikite, nambo anda mwana abhelwikwe ghoha ajhehwite na lipyanda lyenio, nhwalo ahekelela king'enya chikibhelwike pannema. ");
INSERT INTO dne_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na mangota helahela mmii mungolongonde umwojho, nambo nanaibhona kabhele, na mangota nauhanganila, abhii jhe mundo jhojhoha nahotola kumpoka luheko lwino.” ");
INSERT INTO dne_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Mu lichiko lyenio naunyope jhe kilebhe chochoha. Ninnobholela chakaka, chochoha chimukijhopa kwa Tate kwa liina lyango nenga, Tate napelangana. ");
INSERT INTO dne_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ade ngoheno munajhopa jhe kilebhe chochoha kwa liina lyango nnyope. Mangota napelwa, na kiheko nakibhaha telatela. ");
INSERT INTO dne_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ninnobholile mangota malobhe gheniya kwa nnandanikiho. Machiko naghahika nanongela ndeka kabhele na mangota kwa milandankiho, nambo nanongela hotuhotu panane jha Tate. ");
INSERT INTO dne_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lichiko lyenio namnyopa Tate kwa liina lyango, na nenga ninnobholela jhe anda naninyopela mangota kwa Tate, ");
INSERT INTO dne_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","nhwalo jwenio Tate apalangine mangota mwenga. Ampala mangota nhwalo unyeketile nenga kubhehe uhumii kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nenga humila kwa Tate, nyakuhika pannema, na ngoheno niuleka nnema nikelebhuka kwa Tate.” ");
INSERT INTO dne_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Bhahe, bhabholwa bhake bhajhakunnobholela, “Oko! Ngoheno mulongela hotuhotu changa milandanikiho. ");
INSERT INTO dne_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ngoheno tubangatwike kubhehe mwenga umanye ghoha, tupala jhe mundo akonye kabhele. Ndi nhwalo tujheketile kubhehe mwenga nhumii kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yecho ajhakwakonya, “Bho, ngoheno minyeketela? ");
INSERT INTO dne_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lichaa libhii kuhika, ngoheno lihikite, ndi mangota mabhoha napechanganwa kila mundo najhenda kajhake. Nenga nauneka kanjika. Nambo chi nahighalika kanjika, nhwalo Tate gwango abhii pamonga na nenga. ");
INSERT INTO dne_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ninnobholile malobhe gheniya nipala mme na uteeke kwa kulombona na nenga. Nama mumang'ahe munnema mone. Nambo nkangamale! Nhwalo nenga niulepalile ndeka nnema!” ");
INSERT INTO dne_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yecho pajhomolila kulonge malobhe gheniya, ajhakujhinuu miho ghake kunane kwa Chapanga na ngalongila, “Tate, lichaa lyango lihikite. Munombe Mwana gwino na Mwana helahela anombe mwenga.” ");
INSERT INTO dne_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nhwalo mupekiye Mwana gwino ukindendeke panane jha bhando bhoha, abhapeke ughome gwa machiko ghoha kwa bhoha bhumupekiye. ");
INSERT INTO dne_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ghongo ndi ughome gwa machiko ghoha ghangapeta, mwenga kanjika chino ndi Chapanga jwa chakaka na bhaumanye Yecho, Kilichitu jhumutumite ");
INSERT INTO dne_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nenga ninombite mwenga pannema, kwa nhwalo nyomwile lihengo liumbekiya kuhenga. ");
INSERT INTO dne_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tate gwango! Ngoheno unombe, kwa ung'alicho palonge jhino ghoghola ghola ghunikibha nagho kabula jha kupanganwa kwa nnema. ");
INSERT INTO dne_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nitehi umanyikane kwa bhando bhala bhumbekiye kuhumii pannema. Bhando bheniya bhakibha bhino na mwenga unyakumbeke nenga, na bheniya ndi bhalikamwile lilobhe lino. ");
INSERT INTO dne_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ngoheno bhabangatwike ghoha umbekiye ghahumii kwino mwenga. ");
INSERT INTO dne_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nhwalo umbekiye malobhe ghala na bhene bhajheketile. Bhamanya chakaka nhumii kwino, na bhanyeketele mwenga ndi jhundumita. ");
INSERT INTO dne_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Najhope bheniya. Najhope jhe bhando bha pannema nambo najhope bhando bhumbekiye, nhwalo bhando bhamba ndi bhino. ");
INSERT INTO dne_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Bhando bhoha bhungwete ndi bhino, na bhando bhoha bhinkwete ndi bhango, na ung'alicho gwango ubhonikine kwa bhando bheniya bhumbekiye. ");
INSERT INTO dne_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nitama jhe kabhele pannema pano, nambo bhamba bhamela pannema. Ma Tate manyahinyahi! Mwalonde kwa likakala lya liina lino, bhatame mulilongo limo ngita nenga na mwenga chitubhii maghumba nde. ");
INSERT INTO dne_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Punikibha nabho pamonga, nalondita kwa likakala lya liina lino. Abhii jhe hilu mundo jhumo pakate jhabhe jwahobhalile, nambo jhola jwahaghulilwe kuhobhelela Majhandiko gha Chapanga ghatimile. ");
INSERT INTO dne_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Bhahe, ngoheno nihika kwino, nilongela malobhe ghanga namela pannema bhatwelele luheko lwango kumiojho jhabhe. ");
INSERT INTO dne_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nenga napekiye lilobhe lino, na bhando bha pannema bhajhakwachimwa, nhwalo bhene chi bhando bha nnema ghongo jhe, ngita nenga chimile jwa pannema ghongo jhe. ");
INSERT INTO dne_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nijhopa nkotoka kwakangila panja na nnema ghongo, nambo nijhopa mwalonde na Limbembela jhola. ");
INSERT INTO dne_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bhene chi bhando bha nnema ghongo, ngita nenga chimile jwa pannema ghongo jhe. ");
INSERT INTO dne_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mwatende bhabhehe bhando bhino bhanyahinyahi kwa ndela jha uchakaka. Nhwalo lilobhe lino ndi lya uchakaka. ");
INSERT INTO dne_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ngita hele nenga chiundumita pannema, na nenga helahela natuma pannema. ");
INSERT INTO dne_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kwa nhwalo jha bheniya nenga namwete nikibhoha kwa nhwalo jhabhe, na bhene bhakibhohe chakaka kwa nhwalo gwino. ");
INSERT INTO dne_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Najhope bheniya tuijhe, nambo helahela najhope bhando bhoha bhubhapala kunyeketela kwa mabholo ghango. ");
INSERT INTO dne_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nijhopa bhoha bhabhehe maghumba nde. Tate, Nijhopa bhatama nkate jhito ngita mwenga chimitama nkate jhango na nenga nkate jhino. Bhando bhoha bha pannema ghongo bhamanye chakaka undehi kunduma. ");
INSERT INTO dne_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nenga napekiye ukolongwa ghoghola ghola ghumbekiya, bhabhehe pamo ngita twenga chitubhii pamonga. ");
INSERT INTO dne_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Bhahe, nenga mme nkate jhabhe, na mwenga mme nkate jhango, nijhopa bhabhaha pamonga nde. Bhando bha pannema bhamanya mwenga ndi jhundumita, na napahile ngita chiumbala nenga. ");
INSERT INTO dne_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tate! Nijhopa bhando bhumbekiye bhamba bhatame pamonga na nenga pala punibhegha, na bhaubhone ung'alicho gwango ghola ghumbekiya kabula jha kupanganwa kwa nnema. ");
INSERT INTO dne_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tate jwaumbone, bhando bha pannema bhaumanyite jhe, nambo nenga niumanye, na bhando bhamba bhamanye mwenga ndi jhundumita. ");
INSERT INTO dne_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nitehi umanyikane kwa bhando bhoha, nanyendelela kutenda bhaumanye, upalo gwino kwa nenga utame nkate jhabhe, na nenga ndame nkate jhabhe.” ");
INSERT INTO dne_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yecho pajhomolila kunnyopa Chapanga, jwenio na bhabholwa bhake bhajhakujhomboka kwiye jha lukemba lwa ku Kedulone. Peniya pakibha na buchitane jha Michaitune, Yecho na bhabholwa bhake bhajhakujhingii mwenio. ");
INSERT INTO dne_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yuda jwanyambila Yecho jhola, akapamanye peniya, nhwalo Yecho ahwelita na bhabholwa bhake. ");
INSERT INTO dne_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Peniya Yuda ajhakujhenda pabuchitane jha Michaitune pamonga na akakomana ngondo bha kilume na pamonga akalonda bha nyumba jha Chapanga bhibhatumitwe na akapiya matambiko bhakolongwa na Mapwalichayo, bhajhakuhika na lumule na limbolembole na indukwa na mikowa. ");
INSERT INTO dne_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yecho akamanyite ghoha ghimpala kunkolela, ajhakwajhendelela na kwakonya, “Bho, mangota mipalaha ghane?” ");
INSERT INTO dne_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ngabhanyangwila, “Yecho jwa ku Nachalete.” Yecho ajhakwalobholela, “Ndi nenga.” Yuda jwanyambila Yecho akajhemite pahina na bheniya. ");
INSERT INTO dne_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yecho pabhalobholila, “Nenga ndi,” bhajhakubhujha kihenga nyuma na kugwegha pahe puuu. ");
INSERT INTO dne_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yecho ajhakwakonya kabhele, “Mangota mipalaha ghane?” Pibhajhangwila, “Yecho jwa ku Nachalete.” ");
INSERT INTO dne_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yecho pabhalongalila, “Nikanobholile kubhehe ndi nenga, na anda nenga ndi jhumumbalaha, mwaleke bhamba bhajhende.” ");
INSERT INTO dne_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Alongila naha ghalongila makacho ghalenganile ghighalongila, “Tate, bhando bhumbekiya nikahobhiche ndeka hilu jhumo.” ");
INSERT INTO dne_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Bhahe, Simone Petile nganholomwila upanga muchako, ajhakutondobheya na kuheketa lichikilo lya lubhoko lwalelo lya ntumiche jwa Mpiya Litambiko Nkolongwa. Ntumiche jwenio liina lyake Malukuse. ");
INSERT INTO dne_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Bhahe, Yecho ajhakunnobholela Petile, “Mmujhiche upanga gwino kuntohila! Bho, mipala ngotoka kunywegha mukibaba cha malagho nganenganikiye Tate gwango?” ");
INSERT INTO dne_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Bhahe, lilongo lya akakomana ngondo bha Kilume na nkolo jwabhe na akalonda bha Nyumba bha Chapanga jha Akayahude bhajhakunkamula Yecho, na kuntabha pyee, ");
INSERT INTO dne_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","bhajhakutumbuu kumpeleka kwa Anase. Anase akibha nkohano mundo Kayafa, Kayafa akibha Mpiya litambiko nkolo kwa chaka chenie. ");
INSERT INTO dne_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ndi jhojholajhola jwabhalongolila bhakolo bha Akayahude, mbaha mundo jhumo ahweghe kwa kwaghombokola bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simone Petile pamonga na mmolwa jhonge bhajhakunkengamila Yecho. Nhwalo mmolwa jhola jhonge akamanyikine na Mpiya Litambiko Nkolo, peniya bhajhakujhingii pamonga na Yecho pa Bwalo. ");
INSERT INTO dne_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nambo Petile ajhakujhema panja jha nnyango. Peniya mmolwa jwamanyikina na Mpiya litambiko nkolo ajhakupita panja na kulonge na mwikeghe nnonda jwa nnyango, peniya mwikeghe jhola ajhakunekekeya Petile ajhingii nkate. ");
INSERT INTO dne_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nchikana jhola nnonda jwa nnyango ajhakunkonya Petile, “Bho, mwenga chi jhumo jwa mmolwa jwa mundo jhonjo?” Petila pajhangwila, “Nahijhe nenga chi mmolwa gwake.” ");
INSERT INTO dne_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nhwalo kukibha na malile akatumiche na akalonda bhajhakukungana mwotu na kujhota. Na jwenio Petile akajhemite pamonga nabho ajhotita mwotu. ");
INSERT INTO dne_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Bhahe, Mpiya litambiko nkolo ajhakunkonya Yecho panane jha bhabholwa na mabholo ghake. ");
INSERT INTO dne_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yecho ngalongila, “Nongila hotuhotu na bhando, molita munyumba jha kukonganikii Akayahude na pa Nyumba jha Chapanga, pubhakonganika Akayahude bhoha, kibhiijhe kilebhe chindehila mungwapa. ");
INSERT INTO dne_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nhwalo ghane chiungonya nenga naha? Mwakonyekehe bhando bhala ghabhajhohine. Mwakonye chanalobhalile, nhwalo bhamanye chinongile.” ");
INSERT INTO dne_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yecho palongila malobhe gheniya, nnonda jhumo akibha pahina jhake ajhakunapula mbalamande lapu alongila, “Nhwalo ghane munyanguu Mpiya litambiko nkolo!” ");
INSERT INTO dne_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yecho pajhangwila, “Anda nyangwii mbone ndeka nnongele kilebhe chenie palonge jha bhando. Nambo anda nyangwii mbone, nhwalo gwa nike umatwii mbalamande?” ");
INSERT INTO dne_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Peniya Anase ajhakuntutuhana Yecho kongo bhantabhite pyee ade kwa Kayafa ndi Mpiya litambiko nkolo. ");
INSERT INTO dne_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Bhahe, Simone Petile akibha ajhemite peniya ajhota mwotu, bhando bhajhakunkonya, “Bho, na mwenga helahela chi mmolwa jwa mundo jhonjo?” Nambo Petile ajhakukana alongila, “Ne ndeka.” ");
INSERT INTO dne_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ntumiche jhumo jwa Mpiya litambiko nkolo, nnongo jwa jhola jwakapyekwitwe lichikilo na Petile, ajhakunkonya, “Bho, mbona nikamwene mundo jhonjo pamonga kubuchitane jha Micheitune kola?” ");
INSERT INTO dne_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Nambo Petile ajhakukana kabhele, papalapala lijhogholo lijhakubheka. ");
INSERT INTO dne_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pukuchila tugha putiputi bhajhakuntola Yecho kubhoka ku munyumba jha Kayafa na kunhikicha ku liboma lya nduna jwa Loma. Bhakolo bha Akayahude bhakajhingii ndeka nkate jha liboma lyenio, nhwalo bhapata bhabhehe nyahinyahi palonge jha Chapanga bhalyeghe chakulya cha Pachaka. ");
INSERT INTO dne_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bhahe, Pilatu ajhakupita panja na kwakonya, “Mundo jhonjone alemwite nike ade mtakalile?” ");
INSERT INTO dne_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ngabhajhangwila, “Anda mundo jhonjo nakulemwajhe ngatuhikiche jhe kwino mwenga.” ");
INSERT INTO dne_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatu ajhakwalobholela, “Mtutuhane mabhene na mukahadabule kulenganii lilaghalikilo lino.” Akayahude pibhajhangwila, “Twenga tukwete jhe ukindendeke gwa kuhadabula na kukoma mundo jhojhoha.” ");
INSERT INTO dne_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Itendika naha lilobhe lya Yecho lilongila, kwalangiya chajhenda kuwegha. ");
INSERT INTO dne_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Peniya Pilatu ajhakujhingii nkate jha liboma kabhele na kunkema Yecho na kunkonya, “Bho, mwenga ndi Munahota nkolongwa jwa Akayahude?” ");
INSERT INTO dne_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yecho ajhakunkonya, “Bho, malobhe gheniya ghihuma nkate jhino amu bhando bhange bhanongolile malobhe ghango?” ");
INSERT INTO dne_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatu ngajhangwila, “Bho, mihambuka nenga Nayahude? Bhando bha kilambo chino na akapiya matambiko ndi bhibhantutuhine kwa nenga. Bho, nnemwite nike?” ");
INSERT INTO dne_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yecho pajhangwila, “Unahota Nkolongwa gwango chi pannema pano. Unahota Nkolongwa ngaubhehe gwa pannema, bhando bhubhakibha bhibhankengima ngabhakengilile ngotoka kukamulwa na bhakolo bha Akayahude. Nambo unahota nkolongwa gwango gwapamba ndeka!” ");
INSERT INTO dne_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Peniya Pilatu pankonyita, “Bho, mwenga ndi munahota nkolongwa?” Yecho ngajhangwila, “Mabhene ndi milonge nenga munahota nkolongwa. Nenga melwike kwa nhwalo gwenio na kuhika pannema pano kwalobholela bhando malobhe gha uchakaka, bhando bhibhapala uchakaka ujhokanikiya malobhe ghango.” ");
INSERT INTO dne_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bhahe, Pilatu ajhakunkonya Yecho, “Uchakaka ndi kilebhe ghane?” Pilatu pajhomolila kulonge gheniya ajhakupita panja kabhele kwalobholela Akayahude, “Nenga nikihwe ndeka chalemwite ade kunhadabula mundo jhonjo. ");
INSERT INTO dne_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nambo kulengana na nikayobhalikiye mangota kudindulila mpungwa jhumo machiko gha Unyagho gwa Pachaka. Bho, mipala ninyogholele jhonjo Munahota Nkolongwa jwa Akayahude?” ");
INSERT INTO dne_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Peniya bhajhakutumbuu kuchobhela, “Nahi jhe jwenio ndeka! Tupala mutudindulile Balaba!” Balaba akibha apokita ilebhe ya bhando kwa makakala. ");
INSERT INTO dne_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bhahe, Pilatu ajhakwalobholela bhantole Yecho, bhankenyule yato ya limbendela lya ndomondo. ");
INSERT INTO dne_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bhene akakomana ngondo bhajhakuhinga hingo jha mibha na kuwalikiya pamuto. Helahela bhajhakuwalikiya ngholole gwa unahota nkolongwa. ");
INSERT INTO dne_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bhajhakunyendelela palonge jhake na kunyambucha bhalongila, “Mbukwa, Munahota Nkolongwa jwa Akayahude!” Bhamatwila mbalamande jha umatama lapu. ");
INSERT INTO dne_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatu ngapitita panja kabhele na kwalobholela Akayahude, “Dolekeya, nipiya panja na umanyengane nikihwejhe cha kunhadabula mundo jhonjo.” ");
INSERT INTO dne_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bhahe, Yecho ajhakupita panja kongo ahwalite hingo jha mibha na ngholole gwa unahota nkolongwa. Pilatu ajhakwalobholela, “Munolekehe! Mundo jwenio ndi jhonjo!” ");
INSERT INTO dne_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Akapiya matambiko na akalonda bha Nyumba jha Chapanga pibhammonita Yecho, bhajhakunonoha njobhelo bhalongila, “Mumambe panchalaba! Mumambe panchalaba!” Pilatu ajhakwalobholela, “Mtolangane mabhene mukamambe panchalaba, nenga nilihwe ndeka lyalemwite lilemo lyolyoha.” ");
INSERT INTO dne_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Akayahude bhajhakunnyangula, “Twenga tubhii na lilaghalikilo, lilaghalikilo lyenio lilongela limpala akomwe, nhwalo jwenio alongila Mwana jwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilatu pajhohina lilobhe lyenio, ajhakujhoghopa hake. ");
INSERT INTO dne_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Papa ngajhingila kabhele mu liboma lyake na kunkonya Yecho, “Bho, mwenga nhumi kojhe?” Nambo Yecho akajhangwii jhe. ");
INSERT INTO dne_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nambo, Pilatu ajhakunnobholela Yecho, “Bho, umeke maghonga kulonge na nenga? Umanyite ndeka nenga ngwete ukindendeke gwa kunyogholela amu kumamba panane jha nchalaba.” ");
INSERT INTO dne_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yecho ajhakunyangula, “Mwenga ukindendeke kunhadabuu nenga nhwalo ukindendeke gwenio mpatite na Chapanga. Jhola jwanetite kwino ndi jwabhii na uhakaho twe.” ");
INSERT INTO dne_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kubhoke peniya, Pilatu apaliya ndela jha kunnekekeya Yecho. Nambo Akayahude bhajhakutumbuu kuchobhela kanonoha bhalongila, “Anda munekikiye mundo jhonjo, mwenga makoche jhe jwa munahota nkolongwa jwa ku Loma! Mundo jhojhoha jwakitenda munahota nkolongwa jwa ku Loma!” ");
INSERT INTO dne_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Bhahe, Pilatu pajhohina malobhe gheniya ajhakumpiya Yecho panja, peniya Pilatu ajhakutama pa kigoda cha luhadabulo pipikemwa “Lubhanja lwa maghanga.” Kiebulaniya bhikema Gabatha. ");
INSERT INTO dne_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pihikila chaa chita jha muhe, lichiko lya kulenganikiya Pachaka. Pilatu ajhakwalobholela Akayahude, “Ndi Munahota Nkolongwa gwino jhonjo!” ");
INSERT INTO dne_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nambo Akayahude bhajhakunonoha njobhelo bhalongila, “Mukome! Mukome! Mumambe panane jha nchalaba!” Pilatu ajhakwakonya, “Mipala nimambe munahota nkolongwa gwino?” Akapiya matambiko bhakolo bhajhakujhanguu, “Twenga tukwete jhe munahota nkolongwa jhonge nambo munahota nkolongwa jwa ku Loma!” ");
INSERT INTO dne_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Peniya, Pilatu ajhakwakamuha Yecho mu mabhoko gha akakomana ngondo bhamambe panane jha nchalaba. Peniya akakomana ngondo bhajhakuntola Yecho. ");
INSERT INTO dne_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yecho ajhakubhoka pa muche kongo agheghite nchalaba gwake, ade chehemo jhikemitwa “Libhonge lya Muto,” kwa Kiebulaniya bhikema Goligota. ");
INSERT INTO dne_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Peniya ndi pibhamambita Yecho panchalaba, helahela bhakabhambitwe bhando bhange bhabhele, jhumo lubhoko lwalelo na jhonge lwa ngejha, na Yecho pakate. ");
INSERT INTO dne_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatu ajhakujhandika litangacho na kulibheka panane jha nchalaba gwa Yecho, “Yecho jwa ku Nachalete ndi Munahota Nkolongwa jwa Akayahude.” ");
INSERT INTO dne_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pala pibhammambita Yecho panchalaba pakibha pahina na muche. Bhahe, Akayahude bhamahele bhahwelita kuchoma majhandiko gha litangacho lyenio, na ghakajhandikwe kwa Kiebulaniya na Kilatine na Kigilike. ");
INSERT INTO dne_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bhahe, akapiya matambiko bhakolo bhajhakunnobholela Pilatu, “Nkotoka kujhandika naha, ‘Munahota nkolongwa jwa Akayahude,’ nambo jwenio alongila naha, ‘Nenga ndi Munahota Nkolongwa jwa Akayahude.’ ” ");
INSERT INTO dne_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatu ngalongila, “Ghunyandike, nihoto jhe kughalambula.” ");
INSERT INTO dne_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Akakomana ngondo pubhajhomolila kummamba Yecho panane jha panchalaba, bhajhakutola ngobho yake na bhajhakuhibhaghana malundiko ncheche, kila lipungo kwa akakomana ngondo jhumo. Helahela bhajhakutola ade likanjo lyake na lyenio lyangachonwa, jhikalokwite kuhumii kunane ade pahe. ");
INSERT INTO dne_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Akakomana ngondo bhajhakulongolelana, “Tukotoka kujhepula likanjo lende, nambo tuhenge kahumbuhumbu nnobhole tumanye nalibhaha lyaghane.” Itendika naha kupala ghatimile Majhandiko gha Chapanga ghighalongila, “Bhakabhaghine ngobho yango, nambo likanjo lyango bhajhakulitendela kahumbuumbu nnobhole.” Naha ndi chibhakatenda bheniya akakomana ngondo. ");
INSERT INTO dne_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pahina jha pa nchalaba gwa Yecho bhakajhemite akamajhe mundo, majhe mundo Yecho na Maliya nhwana mundo Kiliopa na Maliya jwahumila ku kilambo cha ku Magidala. ");
INSERT INTO dne_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yecho pammonita majhe mundo na mmolwa gwake jhola jwapalita hake, ajhakunnobholela majhe mundo, “Majhe, jwenio ngoheno ndi mwana gwino.” ");
INSERT INTO dne_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Peniya ajhakunnobholela mmolwa jhola, “Ngoheno, jwenio ndi majhe gwino.” Kuhumi peniya, mmolwa jwenio ajhakunghegha Maliya, ajhakutama nako kajhake. ");
INSERT INTO dne_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yecho akamanyite ghoha ghakamilike, Majhandiko gha Chapanga ghabhii telatela, Yecho ajhakulonge, “Nijhoha nyota.” ");
INSERT INTO dne_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pahina jhake pakibha na kilebhe chikitwelile divaye jhibhabha. Bhahe, akakomana ngondo bhajhakuchwiya mu lidodoke mu divaye jhibhabha jhela, na kuhomeka mulundwatwabhe lwa hichopo, nakumekela Yecho pannomo. ");
INSERT INTO dne_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Bhahe, Yecho papekiwa divaye jhene jhibhabhite ajhakulonge, “Ghoha ghatimile!” Peniya ajhakujhinamicha muto gwake, na kuwegha. ");
INSERT INTO dne_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lichiko lyenio likibha lichiko lya kukilenganikiya, na lichiko lilikengima likibha lichiko lya Kupomolela lya Akayahude. Nhwalo ghongo bhakolo bha Kiyahude bhakapahi jhe malelo ghahighalike panane pa nchalaba mulichiko lya Kupomolela, nhwalo Lichiko lya Kupomolela likibha lichiko likolongwa kwabhe. Akayahude bhajhakunyopa Pilatu makongono gha bhando bhubhabhambitwe imetulwanwe na malelo ghabhe ghanhuluhwe. ");
INSERT INTO dne_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Bhahe, akakomana ngondo bhajhakujhenda, bhajhakung'onyolana makongono gha mundo jwalongolile kubhambwa na Yecho peniya bhajhakung'onyola magholo gha mundo jhuubhele bhubhakabhambitwe pamonga na Yecho panane jha panchalaba. ");
INSERT INTO dne_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nambo pubhanhikila Yecho, bhankolila ahwii njwe, bhakang'onywii jhe magholo ghake. ");
INSERT INTO dne_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nambo nkomana ngondo jhumo ajhakunyundukula Yecho nkowa gwa mu lubhaho, papalapala ijhakupita miyahe na mache. ");
INSERT INTO dne_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mundo jwalolita chenie chikipitila, ndi jwatulongolila na chalongila chakaka. Na chenie chaghalongila ndi chakaka, na mangota nnyeketele. ");
INSERT INTO dne_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Itendika naha Majhandiko gha Chapanga ghabhehe telatela, “Kibhii jhe kihupa chake chikipalwa kumetulwa.” ");
INSERT INTO dne_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Peniya Majhandiko gha Chapanga ghilonge kabhele, “Nabhanolekeya mundo jhola jhubhanywundukwile nkowa.” ");
INSERT INTO dne_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pughajhomokila gheniya, Uchupo jwa ku kilambo cha Alimataya, ajhakunyopa Pilatu yegha jha Yecho atole. Uchupo akibha mmolwa gwa Yecho jwa kukihiya hiya nhwalo abhajhogwipa bhakolo bha Akayahude. Pilatu ajhakunnobholela Uchupo ahuluwe yegha jha Yecho panane jha nchalaba, bhahe, Uchupo ajhakujhenda kuhuluwa yegha jha Yecho. ");
INSERT INTO dne_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Uchupo akalongohine na Nikodemo, mundo jhola peniya makacho akanyendilila Yecho lichiko limo uhiko. Nikodemo akaletite piche nhwano jha ntela ghukemitwa manemane ghuhangalwine na ubane. ");
INSERT INTO dne_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bhahe, bhoha bhabhele bhajhakutola yegha jha Yecho bhajhakubhilingilila ngobho jha malelo pamonga na mahuta ngita chibhayobhalile Akayahude pakuchika. ");
INSERT INTO dne_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pala pubhamambita Yecho pakibha na kijhongo, mu kijhongo chenio pakibha na mambe yono, abhii jhe mundo jwakaghonikwe mwenio. ");
INSERT INTO dne_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nhwalo ikibha Lichiko lya Akayahude lya Kupomolela, na nhwalo mambe ikibha pahina, bhajhakubheka mwenio yegha jha Yecho. ");
INSERT INTO dne_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Lichiko lya jumapile putiputi kwamela kunakongola jhe maha, Maliya jwahumii ku kilambo chaku Magidala ajhakujhenda ku mambe na kuikolela lighanga lela liliyekelile mambe likangitwe. ");
INSERT INTO dne_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bhahe, ajhakubhutuka ade kwa Simone Petile na mmolwa jhonge jhola jwapalitwa hake na Yecho na kwalobholela, “Bhayungite yegha jha Bhambo umambe, na tumanyii jhe bhamekite kojhe!” ");
INSERT INTO dne_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peniya Simone Petile na mmolwa nnyake jhola bhajhakujhenda ku mambe. ");
INSERT INTO dne_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bhoha bhabhele bhabhutwika, nambo mmolwa jhonge ajhakuchocha kulubheya kuliku Petile, ajhakulongolela kuhika ku mambe. ");
INSERT INTO dne_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pahikita ajhakujhinama na kulingukiya nkate jha mambe, ajhakuhibhona ngobho jha malelo, nambo akajhingii ndeka nkate. ");
INSERT INTO dne_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Bhahe, Simone Petile jwankengima unyuma, ajhakuhika ajhakujhingii mu mambe. Ajhakuhibhona ngobho jhela jha malelo. ");
INSERT INTO dne_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Helahela ajhakuibhona chanda na chanda jhela jhakabhilingililwe Yecho kumuto. Ngobho jhene jhikibha pakanjika, nambo kikabhilwingwe maha na kubhekwa pakanjika. ");
INSERT INTO dne_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Peniya mmolwa jwakatumbwii kuhika ku mambe, helahela ngajhingila mwenio, ajhakujheketela. ");
INSERT INTO dne_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bhakamanyitii jhe Majhandiko gha Chapanga chighalongila, Yecho ipala ayoke. ");
INSERT INTO dne_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bhahe, bhabholwa bhajhakukelebhuka ukajha. ");
INSERT INTO dne_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maliya akajhemite panja jha mambe kongo abhii mahole chwii. Pakibha alelita, ajhakulita na kulingulila nkate jha umambe, ");
INSERT INTO dne_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ajhakwabhona akatumiche bha kunane kwa Chapanga bhabhele bhubhahwalita ngobho nhuo ya mbumbumbu, bhakibha pala pukabhekwite yegha jha Yecho, jhumo upandi gwa ku muto na jhonge upandi gwa ku magholo. ");
INSERT INTO dne_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bhahe, akatumiche bha kunane kwa Chapanga bhala bhajhakunkonya Maliya, “Majhe, milela nike?” Maliya ajhakwajhanguu, “Bhayungite Bhambo gwango, na kwale bhamekite kojhe!” ");
INSERT INTO dne_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maliya palongila malobhe gheniya, ajhakughalambuka kuyeto na ajhakummona Yecho ajhemite peniya, nambo akaumanyi ndeka ngita akibha ndi Yecho. ");
INSERT INTO dne_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yecho pankonyita, “Majhe, nhwalo gwa nike milela? Mipalaha ghane?” Maliya ahambwika alonge na ntunja buchitane, ajhakunnobholela, “Munahota, anda mutoile, unnobholele, kojhe kumumekite, nyende nikantole.” ");
INSERT INTO dne_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yecho ajhakunnobholela, “Maliya!” Maliya ajhakughalambuka ajhakunnobholela kwa Kiebulaniya, “Rabone!” Mana jhake, “Mmola.” ");
INSERT INTO dne_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yecho ajhakunnobholela, “Ungotoka kungamula, nhwalo namela ninajhenda jhe kunane kwa Tate gwango. Nambo nnyende kwa akalongo bhango na makalobholele, nijhenda kunane kwa Chapanga kwa Tate gwango na mangota helahela Tate gwino, Chapanga gwango helahela Chapanga gwino.” ");
INSERT INTO dne_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Bhahe, Maliya jwa ku kilambo chaku Magidala ajhakukelebhuka na kwalobholela bhabholwa anda akongine na Bhambo, akabhalobhalile ngita chela Yecho channobholile. ");
INSERT INTO dne_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kimiye jhela lichiko lya jumapile, bhabholwa bhakakonganike munyumba na kongo milyango idinditwe, nhwalo bhajhogwipa bhakolo bha Akayahude, Yecho ajhakupitila pwitu na kujhema pakate jhabhe, ajhakwalobholela, “Uteeke ubhaha kwino.” ");
INSERT INTO dne_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pajhomolila kulonge malobhe gheniya, Yecho ajhakwalangiya mabhanga gha mu mabhoko na gha mu lubhaho lwake. Bhabholwa bhajhakuhangana hake nhwalo bhamwene Bhambo. ");
INSERT INTO dne_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yecho ajhakwalobholela kabhele, “Uteeke ubhaha kwino. Ngita Tate chandumite nenga, na nenga helahela nitumangana mangota.” ");
INSERT INTO dne_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Palongila malobhe gheniya, ngabhapulichila na kulonge, “Mupokele Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Anda mundo mumohikiye uhakaho gwake, mundo jwenie abhohikilwe uhakaho, na changamohekeya uhakaho mundo jwenie nahotojhe kubhohekelwa uhakaho.” ");
INSERT INTO dne_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomache ndi jhumo jwa bhabholwa kome na bhabhele jwankemitwa Mabhela, akibha jhe pahikita Yecho. ");
INSERT INTO dne_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bhahe, bhabholwa ajhake bhajhakunnobholela, “Tumwene Bhambo!” Nambo Tomache ajhakwalobholela, “Changalola mabhanga gha michumale gha mu mabhoko ghake na kubheka lukonji lwango mu mabhanga gheniya, na kubheka lubhoko lwango mu lubhaho lwake, nijhekete ndeka.” ");
INSERT INTO dne_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pighapetita machiko nane bhabholwa bhajhakukongana kabhele munyumba jhejhe jhene, na Tomache akibha pamonga na bhene. Pamonga na milyango kudindwa, nambo Yecho ajhakwapitila pwitu na kujhema pakate jhabhe, ajhakulonge, “Uteeke ubhaha kwino.” ");
INSERT INTO dne_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Peniya Yecho ajhakunnobholela Tomache, “Tola lukonji lwino mmeke pamba, nninge mabhoko ghango, peniya tondobheya lubhoko lwino mumeke mu lubhaho lwango. Nkotoka kubhehe na kiholo pange nnyeketele!” ");
INSERT INTO dne_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomache pajhangwila, “Bhambo gwango na Chapanga gwango!” ");
INSERT INTO dne_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yecho pankonyita, “Bho, nnyeketile nhwalo umwene? Bhina mota bhando bhala bhubhajheketela kongo bhanalola jhe!” ");
INSERT INTO dne_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yecho akatehi nginyililo twe palonge pakibha na bhabholwa bhake, nambo yoha ikajhandikwe ndeka mukitabo mwenio. ");
INSERT INTO dne_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nambo ilebhe henge ijhandikwe tujhendelele kunyeketele kubhehe Yecho ndi Kilichitu Nkomboche, Mwana gwa Chapanga na kwa kunnyeketela jwenio mme na ughome gwa chakaka kwa likakala lya liina lyake. ");
INSERT INTO dne_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pighapetita mambu gheniya, Yecho ajhakwapitila kabhele kwa bhabholwa mupele jha lilabha lya ku Tibeliya. Akapitii naha, ");
INSERT INTO dne_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simone Petile, na Tomache jwakemitwa Mabhela, na Natanaele jwabhelwikilwe ku Kana jha ku Galilaya, na yana ibhele ya Zebedayo, na bhabholwa bhange bhoha bhakibha pamonga na Yecho. ");
INSERT INTO dne_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Bhahe, Simone Petile, ajhakwalobholela ajhake, “Nijhenda kupyeya homba.” Na bhene bhajhakunnobholela, “Na twenga tupala tulongohane koko kukupyeya.” Bhahe, bhajhakujhenda kuhobhokela ngalabha bhoha, nambo kilo choha chibhakelwiya kibhii jhe chibhakajhambulile. ");
INSERT INTO dne_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Putiputi, Yecho ajhemite chakutale paupele jha lilabha, nambo bhabholwa bhake bhakaumanyite ndeka kubhehe ndi Yecho jwenio. ");
INSERT INTO dne_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Bhahe, Yecho ajhakwakonya, “Makoche bhango, mupongite homba yenio?” Bhanyanguu, “Kilebhe nacho, tupatite jhe homba.” ");
INSERT INTO dne_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Peniya Yecho ajhakwalobholela, “Ntaghile lwaho lwino lubhoko lwalelo lwa ngalabha, naponga homba.” Bhajhakutaghila lwaho umache na bhakahotwi ndeka kuhuta lwaho nhwalo gwa kuhindimana kwa homba. ");
INSERT INTO dne_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Peniya mmolwa, jwapalitwa na Yecho ajhakunnobholela Petile, “Jhonjo ndi Bhambo!” Papalapala Simone Petile pajhohina malobhe kubhehe jhola ndi Bhambo, ajhakuhwala likanjo lyake lya panja nhwalo akibha ahulite. Peniya ajhakuhombela umache. ");
INSERT INTO dne_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bhabholwa bhange bhajhakuhika na ngalabha, kongo bhahutita lwaho luluhindimine homba, nhwalo bhakibha kutale jhe kuhika pandumba, bhakahighalile pandina ngita kilomita itato kuhika kwenio. ");
INSERT INTO dne_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pubhahikita pandumba jha lilabha, bhajhakubhona mwotu gwa makalakala na homba na libumunda panane jhake. ");
INSERT INTO dne_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yecho ajhakwalobholela, “Umaghulile homba ipyehita ngoheno.” ");
INSERT INTO dne_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Peniya Simone Petile ajhakujhingila mungalabha, na kuluhuta lwaho loha ade pandumba jha lilabha, lwaho lukapongite homba ya mpapakacha 150. Nambo pamonga na kuhindamana kwa homba lwaho lukakenjwike ndeka. ");
INSERT INTO dne_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yecho ajhakwalobholela, “Nhwike nnabhukane hote.” Akapitii ndeka hilu mmolwa jhumo jwankonyite, “Mwe maghane?” Nhwalo bhakaumanye ndi Bhambo. ");
INSERT INTO dne_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yecho ajhakuhika na kutola libumunda kwapela na helahela ajhakutenda kwa homba na kwapekeya. ");
INSERT INTO dne_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jhenje ndi jhutato kwa Yecho kwapitila bhabholwa bhake kuhumii mukuyoka kwake. ");
INSERT INTO dne_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pubhajhomolila kulyegha, Yecho ajhakunkonya Simone Petile, “Ma Simone mwana gwa Yohane, bho, umbahile nenga kuliku bhambano?” Simone Petile ajhakunyanguu, “Chakaka, Bhambo umanye mwenga nipahile.” Yecho ajhakunnobholela, “Nnyemelele matohe gha mambelele ghango.” ");
INSERT INTO dne_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yecho ngankonyita kabhele, “Simone mwana gwa Yohane, bho, umbahile?” Petile ngajhangwila, “Chakaka, Bhambo umanye mwenga nipahile.” Yecho ajhakunnobholela, “Nnyemelele mambelele ghango.” ");
INSERT INTO dne_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Peniya Yecho ajhakunkonya mala jhutato, “Simone Petile mwana gwa Yohane umbahile?” Peniya Simone Petile ajhakubhehe ngolongonde nhwalo Yecho ankonyite mala jhutato na akannobholile, “Bho, umbahile?” Ajhakunnyanguu, “Bhambo, mwenga umanyite ilebhe yoha, umanye kubhehe nimpahile!” Yecho ngalongila kabhele, “Nnyemelele mambelele ghango. ");
INSERT INTO dne_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ninnobholela chakaka, punikibha kangombo mukahyobhalile kukikonga nkunge pyee mabhene na kubheghela kokoha kupalita, nambo pumughogholoka nanhatambula mabhoko ghino na mundo jhonge nakonga na kunchindikicha pangapala kujhenda.” ");
INSERT INTO dne_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yecho alongila naha, kunangii Petile chapala kuwegha na kunnomba Chapanga. Peniya Yecho ajhakunnobholela Petile, “Ungengame!” ");
INSERT INTO dne_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petile paghalambwika, ajhakummona mmolwa jhola jwapalitwa na Yecho atenda kunkengama. Mmolwa ndi jhola jwakamandikile Yecho pubhalalila bhoha chakulya cha Pachaka na ajhakunkonya, “Bhambo, ghane jwapala kunnyambila mwenga?” ");
INSERT INTO dne_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bhahe, Petile pammonita jwenio mmolwa, ajhakunkonya Yecho, “Bhambo nakimpitila nike mundo jhonjone?” ");
INSERT INTO dne_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yecho panyangwila, “Anda nipala atame na ughome ade pumbala kubhujha, mwenga mipala nike? Mwenga ungengame!” ");
INSERT INTO dne_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Bhahe, malobhe gheniya ghajhakubhehe mbegha kwa bhando bhibhanyeketii Kilichitu kubhehe mmolwa jwenio nahwe jhe. Nambo Yecho akalongi ndeka mmolwa jwenio nahwe jhe, nambo akalongi “Anda nipala atame na ughome ade kubhujha, mwenga mipala nike?” ");
INSERT INTO dne_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jhonjo mmolwa jwalolita mambu ghanga kwa miho ghake na ndi ngajhandika. Twenga tumanye ghanga ghighalongolike ndi gha uchakaka. ");
INSERT INTO dne_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ghabhii ghamahele ghakatehi Yecho. Anda ghoha ngaghajhandikwa limo nga pa lenge, punihambuka nnema ghoha ngaukwelite ndeka kubheke itabo ijhandikwe.");
INSERT INTO dne_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Makolongwa Teofilo. Mukitabo chango chinongolila kujhandika nikajhandike mambu ghoha ghatehila Yecho na kubhola kuhumii mu mahengo ghake, ");
INSERT INTO dne_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ade lichiko lela lyatolitwa kujhenda kunane kwa Chapanga. Palonge jha kutolwa kujhenda kwa Chapanga, akalaghalikiye kwa ndela jha Uhuke gwa Chapanga kwa bhando bhakabhahagwile kubhehe akatenga bhake. ");
INSERT INTO dne_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Makome ncheche kubhoke pu kuwegha. Yecho ajhakukilangiya kabhele kwabhe na kulonge nabho mambu gha Unahota nkolongwa gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lichiko limo Yecho palila nabho pamonga na bhabholwa bhake ajhakwalaghalikiya naha, “Nkotoka kubhoka ku Yeluchalemo, nambo ntamengane pamba kulendelela ndweko jhela jhalaghalikiye Tate gwango ndi Uhuke jhumunyokanikiya nikalongela malobhe ghake. ");
INSERT INTO dne_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohane ajhakwabaticha kwa mache, nambo machiko ghandina palongolo nabatichwa kwa Uhuke gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bhahe, akatenga pubhakonganika pamonga na Yecho, bhajhakunkonya, “Bhambo, bho, machiko gheniya ndi machiko gwa kwabhujhichila bhando bhu ku Ichilahele unahota nkolongwa gwabhe?” ");
INSERT INTO dne_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nambo Yecho ajhakwajhanguu, “Machiko gheniya ghabhii mu kindendeke gwa Tate kanjika chake ndi amanya lichiko lyenio. ");
INSERT INTO dne_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nambo Uhuke gwa Chapanga puhulukiya kwino, chipokela makakala, na mangota chamalongolela bhando bhu ku Yeluchalemo, na mu ilambo yu ku Yudeya yoha na ku Samaliya na mu ilambo yoha mwipehikiye nnema.” ");
INSERT INTO dne_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pajhomolila kulonge gheniya, ajhakutolwa kujhenda kunane kwa Chapanga na kongo bhando bhatehila kunnolekeya, peniya lihunde lijhakuyekelela bhene bhakamwene jhe kabhele. ");
INSERT INTO dne_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pubhajhendelila kulolekeya kunane kwa Chapanga Yecho pajhahwila, papalapala bhajhakupitila bhando bhabhele bhubhahwalite ngobho nhuo ya mbumbu bhajhemite pahina jhabhe, ");
INSERT INTO dne_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bhando bhala bhajhakwalobholela, “Mangota bhu ku Galilaya! Bho, nhwalo gwa nike nnyemite kongo mulolekeya kunane kwa Chapanga? Jwenio Yecho jwatolitwe kuhumi kwino kujhenda kunane kwa Chapanga, chabhujha hele ngita chimmumona akijhenda kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Peniya, akatenga bhajhakubhujha ku Yeluchalemo kuhumi ku kitombe cha ku Micheitune, ubhandikila kuhikila kilomita jhimo kuhumii ku bomane. ");
INSERT INTO dne_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pubhahikita kubomane, bhajhakujhingila muchumbi chikibhii ku gholofa chibhatamita. Na bhene bhakibha Petile na Yohane na Yakobu na Anduleya na Filipu na Tomache na Batulomayo na Matei na Yakobu mwana gwa Alufayo na Simone jwa kibhogha cha Wazelote na Yuda mwana gwa Yakobu. ");
INSERT INTO dne_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bhoha bhamba bhakonganika pamonga mukunyopa Chapanga pamonga na akakeghe bhange, na Maliya majhe mundo Yecho na akalongo mundo. ");
INSERT INTO dne_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lichiko limo palonge, Petile ajhakujhema pakate jha bhando bhala bhibhannyeketii bhubhakonganike, bhando bheniya bhakibha 120. ");
INSERT INTO dne_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Petile ajhakulonge, makalongo bhango bhunyeketile. Ikachokalikiye Majhandiko ghatimile, kwa chehemo Uhuke gwa Chapanga akalongile kupete Daude, Daude akalotile panane jha Yuda, jhola jwabhalongwicha bhando bhala bhubhakankamwila Yecho.” ");
INSERT INTO dne_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yuda akibha pamonga na twenga mukibhogha chito, na jwenio akahaghulilwe na Yecho kuhenga lihengo lende. ");
INSERT INTO dne_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yuda ajhakuhemelela nng'onda kwa mbijha hela yatehila uhakaho, ajhakugwe pahe mwenio puuu, na matumbo ghajhakuchejhebhuka panja. ");
INSERT INTO dne_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bhando bhoha bha ku Yeluchalemo bhajhakujhoha mambu gheniya bhajhakukema chehemo jhene, “Akelidama,” mana jhake “Nng'onda ghupatikine kwa mbijha ya kukoma.” ");
INSERT INTO dne_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petile ajhakulonge, “Nhwalo ijhandikwe mukitabo cha Zabule, ‘Chehemo jhene napahighalika mahundo, mundo jhojhoha akotoka kutama mwenio.’ Helahela ijhandikwe kabhele, ‘Mundo jhonge atola lihengo lya kulongocha.’ ");
INSERT INTO dne_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Bhahe, ipalwa mundo jhumo pakate jha bhala bhubhakalongohina na twenga kwa machiko ghoha na Bhambo Yecho pakibha pamonga na twenga, ");
INSERT INTO dne_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kutumbulila ubaticho gwa Yohane ade lichiko lela lyatolitwa Bhambo Yecho kubhoke kwito kujhenda kunane kwa Chapanga. Mundo jwenio ipalwa abhaha jhumo jwalolita kuyoka kwa Yecho kuhumi kumambe.” ");
INSERT INTO dne_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bhahe, bhajhakuhaghula mahina mabhele, jhumo Uchupo, jwakemitwa Balisaba helahela na akemitwa Yusito, na jhonge Matiya. ");
INSERT INTO dne_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Peniya, bhajhakunnyopa Chapanga, “Bhambo, mwenga umanye miojho jha bhando bhoha. Ngoheno mutulangiye mundo ghane jhumuhagwile pakate jha bhamba bhabhele, ");
INSERT INTO dne_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","atole lihengo lela lya utenga lililekitwe na Yuda, nu kujhenda chehemo jhake jwenio.” ");
INSERT INTO dne_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Peniya, bhajhakuhaghula kwa ndela jha kiumbuumbu nnobhole pakate jha bhando bhabhele bhala, na kiumbuumbuu nnobhole kijhakugwelela Matiya na jwenie ajhakujhonjekewa pakate jha akatenga kome na jhumo bhala. ");
INSERT INTO dne_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lichiko lya Pendekochite pulihikita, bhibhakanyeketii Yecho bhakakonganike pamonga. ");
INSERT INTO dne_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Papalapala bhando bhajhakulijhoha lilobhe kuhumi kunane kwa Chapanga ngita kimbonga, na kutweleya nyumba jhoha jhubhakatamite. ");
INSERT INTO dne_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Peniya, ijhakupitila ilebhe ngita ndetelekana ya mwotu, na yenio ijhakupechengana panane jha kila mundo. ");
INSERT INTO dne_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Bhando bhoha bhajhakuhindililwa Uhuke gwa Chapanga, na kila jhumo ajhakutumbuu kulonge, kila jhumo lugha yono ngita Uhuke gwa Chapanga chatangatila. ");
INSERT INTO dne_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kwenio ku Yeluchalemo, pakibha na Akayahude bhubhakibha bhahobholila Chapanga bhibhahumila ilambo yoha ya pannema. ");
INSERT INTO dne_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pubhajhohina lilobhe lyenio, lilongo lya bhando lijhakukonganika pamonga. Bhoha bhajhakukangacha nhwalo kila mundo akajhohine chakajhake bhakalongela milondole bha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Bhajhakuhechuka na kukangacha bhalongila, “Bho, bhando bhamba bhoha bhibhalonge naha bhabhelukii pa Galilaya pano jhe? ");
INSERT INTO dne_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ngoheno ibhii bhole kila jhumo pakate jhito ijhoha ilonge chukajha? ");
INSERT INTO dne_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Bhange bhahumila ku kilambo chu ku Pasiya na ku Mediya na ku Elamo na ku Misopotamiya na ku Yudeya na ku Kapadokiya na ku Ponto na ku Asiya, ");
INSERT INTO dne_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","na bhange kuhumii ku Fuligiya na ku Pamfiliya na ku Michile na ku Libiya ibhii pahina na ku Kilene, helahela bhange ndi akaghene kuhumii ku Loma. ");
INSERT INTO dne_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na Akayahude na bhando bhange bha ilambo henge bhibhajhingila mu dine jha Akayahude, na bhange bhahumila ku Kulete na Alabiya. Nambo twabhoha twenga twajhohine bhando chibhalongela kwa lugha jhabhe mambu makolongwa gha Chapanga!” ");
INSERT INTO dne_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Bhando bhoha bhajhakukangacha, kone bhakonyina, “Mambu ghanga mana jhake nike?” ");
INSERT INTO dne_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nambo bhando bhange bhajhakwatendela chanake bhalongila, “Bhando bhamba bhatehi kulobhela!” ");
INSERT INTO dne_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Peniya, Petile ajhakujhema pakate jha akatenga bhabhii pamonga na twenga ajhakutumbuu kulonge kanonoha, “Makalongo bhango Akayahude na bhando bhange bhumitama pa Yeluchalemo, deka ninnobholele na unyokanikiya mbone chinilonge.” ");
INSERT INTO dne_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Bhando bhamba bhalobhii ndeka, nhwalo ngoheno chaa tato jhu lukela. ");
INSERT INTO dne_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Chakaka lijhambu lende ndi lela lalongila jwakibha nnondole jwa Chapanga Yoele: ");
INSERT INTO dne_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Chapanga ilonge mu machiko ghukujhomolela, bhando bhoha nanajhitila Uhuke gwango. Yana hino ingombo na ichikana nabhalongela malobhe ghango, ingombo hino nabhalola maloto, na akahoko bhino nabhalotela. ");
INSERT INTO dne_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chakaka, hilu akatumiche akanalome na akakeghe, nanajhitila Uhuke gwango machiko gheniya, na bhene nabhalotela malobhe ghango. ");
INSERT INTO dne_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nandenda ikangacho kunane kwa Chapanga, na nginyililo pahe pannema. Napabhaha na miyahe, mwotu na lyoi litopaho. ");
INSERT INTO dne_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lyobha chilibhekwa lubhendo, na lubhala mwehe nalubhaha lukele ngita miyahe, kabula jha kupitila lichiko likolongwa lya ulumbililo gwa Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mundo jhojhoha jwajhopa kwa liina lya Bhambo, nakombolwa. ");
INSERT INTO dne_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Petile pajhendilila kulonge, “Bhando bha kilambo chu ku Ichilahele nnyokanikiye malobhe ghanga! Yecho jwa ku Nachalete akibha mundo jhuna ukindendeke gwa Chapanga na jwamanyikine kwino kwa ndela jha ikangacho, na nginyililo ya Chapanga yatehila pakate jhino ngita chiumanya. ");
INSERT INTO dne_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yecho akapihitwe kwino nhwalo Chapanga jwenio akapangite njwe Yecho akamulwe mu mabhoko ghino bhibhahenga uhakaho, na mangota nnyakukoma kwa kwaleka bhando bhubhabhiii na uhakaho bhamambe panane jha nchalaba. ");
INSERT INTO dne_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nambo Chapanga ngayokicha Yecho kuhumii ku bhubhawile, akankombwile kuhumi mulipyanda lya kuwegha kwa mana ngaiwechekine jhe kuwegha kuntabhe. ");
INSERT INTO dne_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nhwalo Daude akalongile naha panane jha Yecho. ‘Nikamwene Bhambo palonge jhango machiko ghoha, nhwalo abhii pahina jhango, nanyukenyuke ndeka. ");
INSERT INTO dne_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kwa gheniya mwojho gwango uhangina, na kabhele lulime lwango nalukajhula kilulo. na nenga yegha jhango, naibhaha mulihobholelo, ");
INSERT INTO dne_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","nhwalo namulekii jhe Uhuke gwango ku kilambo cha bhando bhubhawile, hilu kuneka jwa nyahinyahi jwino abhole. ");
INSERT INTO dne_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Unangiye ndela jha ughome, undweliye luhangano nhwalo mmii pamonga na nenga.’ ");
INSERT INTO dne_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Makalongo bhango bhu ku Ichilahele, deka ninobholele hotuhotu panane jha tate gwito nkolongwa Daude. Jwenio akawile na kuyelelwa na mambe jhake ibhii pamba kwito ade deleno. ");
INSERT INTO dne_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nambo nhwalo Daude akibha nnondole jwa Chapanga, akamanyite kubhehe Chapanga akanapanikiye kilapo nantenda jhumo pakate jha kibheluko chake kubhehe munahota nkolongwa ngita jwenio Daude. ");
INSERT INTO dne_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Daude akalongolile ghughabhona mambu ghanga ghighapalwa kutendwa na Chapanga, ndi palongila panane jha kuyokechwa kwa Kilichitu pala palongila, ‘Akalekitwe ndeka ku kilambo cha bhando bhubhawile, hilu yegha jhake ikabholite jhe.’ ");
INSERT INTO dne_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Bhahe, Chapanga ndi jwayokicha jwenio Yecho, na twenga ndi jhutulolita mambu gheniya kwa miho ghito. ");
INSERT INTO dne_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yecho patondobhiwa na kutama lubhoko lwalelo lwa Chapanga, ajhakupokela Uhuke gwa Chapanga ngita chatulaghila. Peniya ajhakutujhila jwenio Uhuke na chenie ndi chimukibhona ngoheno na kukijhoha. ");
INSERT INTO dne_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nhwalo Daude jwenio, akatolitwe ndeka kujhenda kunane kwa Chapanga, nambo jwenio akalongile, ‘Bhambo akannobholile Bhambo gwango. Ntame lubhoko lwango lwalelo, ");
INSERT INTO dne_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ade natende akamakoko bhino kigoda cha magholo ghino.’ ");
INSERT INTO dne_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kwa nhwalo ghongo bhando bhoha bha kilambo chu ku Ichilahele bhipala bhamanye uchakaka Yecho jhumumambite panane jha nchalaba, ndi jwenio Chapanga jwatehile kubhehe Bhambo na Kilichitu Nkomboche!” ");
INSERT INTO dne_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bhahe, bhando pubhajhohina malobhe gheniya, ghakochite kumwojho, bhajhakunkonya Petile na akatenga bhange, “Bho, akalongo bhito, ngoheno tuhenge nike?” ");
INSERT INTO dne_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petile ajhakwajhanguu, “Kila mundo jhumo ajheketele na kuleka uhakaho gwake na abatichwe kwa liina lya Yecho Kilichitu na Chapanga nanekekeya uhakaho gwino. Na mangota napokela lilaghano lya Chapanga ndi Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nhwalo, lilaghilo lela lya Chapanga likibha lino, kwa yana hino, na kwa bhando bhoha bhubhabhiii kutale, na kwa kila mundo Bhambo Chapanga gwito nankema.” ");
INSERT INTO dne_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kwa malobhe twe Petile ajhakangamalicha bhando alongila, “Mukikombole kuhumi mu kibheluko chenje kibhoho!” ");
INSERT INTO dne_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bhando bhamahele bhibhajheketile malobhe gha Petile, bhajhakubatichwa. Na lichiko lela bhando elufo itato bhakajhonjekeka mukikunde chela. ");
INSERT INTO dne_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Na bhene bhoha bhajhendilila kubholwa na akatenga, bhatamita pamonga ngita lukolo, bhametwila libumunda na bhanyinamila Chapanga pamonga. ");
INSERT INTO dne_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kila mundo jhumo ajhakujhingilwa na bhoghohe, nhwalo gwa ikangacho na nginyililo yamahele ibhatehila akatenga bhala. ");
INSERT INTO dne_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bhibhanyeketii bhoha bhatamita pamonga na kujhendelela kubhaghana ilebhe yabhe pamonga. ");
INSERT INTO dne_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bhakibha bhachulwicha ilebhe yabhe na kubhaghana mbijha yabhe kwa kila mundo jhumo ngita chibhapalita. ");
INSERT INTO dne_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bhajhendilila kukongana mu Nyumba jha Chapanga machiko ghoha. Nambo pubhametwila libumunda, bhakonganika munyumba yabhe bhalila yenio kwa kuhangana na mwojho nhuo gwa mbumbu. ");
INSERT INTO dne_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Bhajhakunnomba Chapanga, na kupalwa na bhando bhoha. Na kila lichiko Bhambo ajhonjikiya bhando bhibhakombolilwa. ");
INSERT INTO dne_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lichiko limo Petile na Yohane bhajhahwila pa Nyumba jha Chapanga chaa ticha kunnyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Machiko gheniya bhando bhangheghita mundo jhumo jwalemile kuhumii mukubhelukwa kwake. Kila lichiko bhando bhangheghita mundo jwenio na kummeka pa nnyango gwenio ghukemitwa, “Nnyango gwa mbone,” ajhope mbijha kwa bhando bhubhajhingila mu Nyumba jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Mundo jhola pabhabhonita Petile na Yohane bhajhingila nkate mu Nyumba jha Chapanga, ajhakwajhopa, bhampele mbijha! ");
INSERT INTO dne_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Petile na Yohane bhajhakupihikiya miho, peniya Petile ajhakunnobholela, “Tulolekeya twenga!” ");
INSERT INTO dne_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Mundo jhola ajhakwalolekeya, ahobholila napata kilebhe chochoha kuhumi kwabhe. ");
INSERT INTO dne_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nambo Petile ajhakunnobholela, “Ngwete ndeka madine gha feza hilu chaabo, nambo chinimpela kilebhe chiminako. Kwa liina lya Yecho Kilichitu jwa ku Nachalete, jhinuka na ntyange!” ");
INSERT INTO dne_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peniya, Petile ajhakunkamula lubhoko lwalelo na ajhakuntangatila kunyinula. Papalapala makongono na majhugho gha mundo jwenio ghajhakubhehe na likakala. ");
INSERT INTO dne_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ajhakuhomba kwa makongono ghake na kutumbuu kutyanga. Peniya, ajhakujhingila nabho mu Nyumba jha Chapanga, akibha atyangita na kuhomba homba kongo annumbilila Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bhando bhoha pubhamonita akityanga na kunnomba Chapanga, ");
INSERT INTO dne_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","pubhaumanyita kubhehe ndi jhola jwawelita kujhopa jhopa pa nnyango gwa Nyumba jha Chapanga ghukemitwa “Nnyango gwa mbone,” bhajhakuchituka na kukangacha hake mambu gheniya ghughapitile. ");
INSERT INTO dne_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Bhando bhoha bhajhakuhechuka Petile na Yohane pubhajhahwila mu Bwalo jha Selemane, kongo mundo jwenio bhalongohi nako. ");
INSERT INTO dne_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petile pabhalolikiya bhando bheniya, ajhakwalobholela, “Bhando bhu ku Ichilahele, nhwalo ghane mukangacha naha kilebhe chenje? Nhwalo gwa nike mutupihikiya miho ngita mundo jhonjo atyangite kwa ukindendeke gwa twenga amu twaumbone palonge jha Chapanga? ");
INSERT INTO dne_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Chapanga jwa Ulahimo na Isaka na Yakobu na Chapanga jwa akahoko bhito, antondobhiye ntumiche gwake Yecho jwabhii na ukolongwa. Jwenio ndi jhola jhumupukila nukumpeka kwa akanahota na kunkana palonge jha Pilatu, Pilatu ndi palongila jhonjo munekekeye. ");
INSERT INTO dne_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Akibha jwanyahinyahi palonge jha Chapanga na jwahengita ghapala Chapanga, nambo mangota nnyakunkana, nnyakunyopa Pilatu amopolele mundo jwakomita bhando. ");
INSERT INTO dne_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bhahe, mangota mukakomite jhola jwabhii chembwe cha ughome. Nambo Chapanga ajhakuyowa kuhumi kubhawile, na twenga tulolite kwa miho gwito lijhambu lyenio. ");
INSERT INTO dne_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kwa kulijheketela liina lya Yecho, mundo hojho jhumumwona na kuumanya apatite likakala. Kwa liina na kihobholelo chikihuma kwa jwenio Yecho ndi kinamiche njelembo mundo jhonjo jhumumwona. ");
INSERT INTO dne_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ngohe makalongo bhango, nimanya kubhehe mangota na akanahota bhino mukantendite gheniya nhwalo gwa kupumbumuka kwino. ");
INSERT INTO dne_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nambo Chapanga akatangiche malobhe ghake kuhumi makacho kwa ndela jha milondole bhake, ipalitwa Kilichitu ang'ahike. ");
INSERT INTO dne_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ngoheno, munyeketele na kuuleka uhakaho gwino na mung'alambukile Chapanga anekekeye uhakaho gwino, ");
INSERT INTO dne_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","anda ntehi yenio nanyonjekewa makakala gha Uhuke kuhumi kwa Bhambo, na jwenio natuma Kilichitu jwahagwile ndi Yecho. ");
INSERT INTO dne_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Na jwenio ipalwa ahighalika koko kunane kwa Chapanga ade Chapanga papala kuitenda ilebhe yoha iyono. Ngita chalongila kuhumii makacho kwa milomo jha milondole bhake bha nyahinyahi. ");
INSERT INTO dne_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwa nhwalo Mucha akalongile, ‘Bhambo Chapanga gwino nanetelangana milondole ngita nenga, jwenio nahumila pakate jhino mabhene, mipalwa kunyokanikiya kila kilebhe channobholela. ");
INSERT INTO dne_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mundo jhojhoha jwangannyokanikiya nnondole jwenio jwa Chapanga, chabhambalwa kutale na bhando bhake na kukomelekelwa.’ ");
INSERT INTO dne_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Petile pajhendilila kulonge, milondole bhoha bha Chapanga kutumbulila Samwele na bhala bhubhahikita panyuma jhake, bhatangicha mambu ghughatendeka machiko ghanga. ");
INSERT INTO dne_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kwa lilaghano lela lyabhekita Chapanga kwa ndela jha milondole bhake ndi hino mangota, na helahela lilaghano lyatehila Chapanga na hoko gwino Ulahimo ndi lino. Ngita channobholila Ulahimo, ‘Kupete ibheluko hino, na bhando bhoha bha pannema nabhabha na mota.’ ");
INSERT INTO dne_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bhahe, Chapanga payohita Yecho na akatumbwii kuntuma kwino, anetele mota na antende kila jhumo gwino na kughalambula ndela jhino jhanganandela.” ");
INSERT INTO dne_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petile na Yohane pubhajhendilila kwatangachii bhando, akapiya matambiko na kilongoche nkolongwa jwa akalonda bha Nyumba jha Chapanga pamonga na Masadukayo bhange bhajhakwahikilila. ");
INSERT INTO dne_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bhahe, bhakayomite hake nhwalo gwa akatenga bhabhele bhala pubhabholita Yecho ayokite kuhumi mu kuwegha. Na lyenio lilongela hotuhotu kubhehe bhubhawile hele nabhayoka. ");
INSERT INTO dne_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Peniya, nhwalo ikibha kimiho bhajhakwakamula na kwapunga mukipungo ade lichiko lyubhele. ");
INSERT INTO dne_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nambo bhando bhamahele pakate jhabhe bhajhakujheketela malobhe gha Petile na Yohane, na bhando bhoha bhubhakajheketii bhakahikii elufo nhwano mulilongo lyenio. ");
INSERT INTO dne_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lukela jhake, ilongoche ya Akayahude, na ighogholo na bhabhola bha Malaghalikilo bhajhakukonganika ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Helahela bhakakonganike na Mpiya Litambiko nkolongwa Anase, na Kayafa, na Yohane na Alekizanda na bhando bhange bhoha bhu lukolo lwa Mpiya litambiko Nkolongwa. ");
INSERT INTO dne_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pubhajhemika Petile na Yohane palonge yabhe, bhajhakwakonya, “Bho, mangota mihenga naha kwa likakala lya ghane amu kwa liina lya ghane?” ");
INSERT INTO dne_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peniya, Petile atwelii Uhuke gwa Chapanga twe, ajhakwajhanguu, “Ilongoche na ighogholo ya bhando. ");
INSERT INTO dne_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Anda mutukonya deleno panane jha mambu ghaumbone ghatendwilwe mundo jhola jwakalemile na alamichwe, ");
INSERT INTO dne_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ngohe, mangota pamonga na bhando bhu ku Ichilahele bhoha umanye kubhehe mundo jhonjo ajhemite palonge jhino, alamite njelembo, kwa likakala lya liina lya Yecho Kilichitu jwa ku Nachalete, jhola mangota jhumukamambite panane jha nchalaba, nambo Chapanga akayokiche kuhumi ku bhubhawile. ");
INSERT INTO dne_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jwenio ndi Majhandiko gha Chapanga ghilonge panane jhake. ‘Lighanga lela limulikanite mapunde kuchenga, ngohe liyokite lighanga likolongwa lya nchinge.’ ");
INSERT INTO dne_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ughombokeko upatikana ndeka kwa mundo jhonge jhojhoha, kwa mana pannema poha, libhii jhe liina lenge lyapatite mundo lilihoto kughombokoka nako.” ");
INSERT INTO dne_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bhahe, akanahota bha pa bwalo bhajhakukangacha hake kwabhona Petile na Yohane bhalongila changajhoghopa nhwalo bhachomite jhe, bhajhakumanya kubhehe bhando bhabhii mulilongo lya Yecho. ");
INSERT INTO dne_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nambo pubhamonita mundo jhola jwalamichwe ajhemite pamonga nabho, bhakahotwi ndeka kunanuu nnomo gwabhe. ");
INSERT INTO dne_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bhahe, bhajhakwalobholela bhapite panja jha chumbi cha Udamo, na bhene bhajhakuhighalika nkate bhalongila kiyepela. ");
INSERT INTO dne_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Bhalongila, “Tutende nike na bhando bhamba? Kila mundo jwatama ku Yeluchalemo amanye kikangacho chikitendike, na twenga tuhoto ndeka kuhibhilikiya lijhambu lende. ");
INSERT INTO dne_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nambo kulihibhilikiya lijhambu lende likotoka kuchobhela kwa bhando bhange, twakanikiye bhakotoka kulonge na mundo jhojhoha kwa liina lya Yecho.” ");
INSERT INTO dne_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Peniya, bhajhakwakema kabhele nkate, bhajhakwakanikiya bhakotoka kulonge kabhele palilongo lya bhando, hilu kubhola kwa liina lya Yecho. ");
INSERT INTO dne_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nambo Petile na Yohane bhajhakwajhanguu, “Mabhene nahadabulwa, anda chakaka palonge jha Chapanga kunyokanakii mangota kuliku kunyokanakii Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwa mana tuhoto ndeka kuleka kulonge panane jha mambu ghala ghutughawene na kughajhoha.” ");
INSERT INTO dne_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Peniya, akanahota bha pa Bwalo bhala bhajhakuchocha kwajhoghowa kwa lilaka, bhajhakwalekekeya bhajhende. Bhakahotwi ndeka kwang'aha nhwalo bhando bhoha bhanumbilila Chapanga kwa nhwalo gwa lijhambu lyenio. ");
INSERT INTO dne_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mundo jhola jwakalamichwe, akahikile panane jha yaka makome ncheche. ");
INSERT INTO dne_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Papalapala Petile na Yohane pubhalekekiwa tugha, bhajhakubhujha kwa bhajhabhe na bhajhakwalobholela mambu ghoha ghibhalongila akapiya matambiko na ighogholo. ");
INSERT INTO dne_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Na bhene pubhajhohina gheniya, bhajhakulombana pamonga mukunnyopa Chapanga, bhalongila, Bhambo, mwenga ndi bhupangina kunane kwa Chapanga na nnema, mbwane pamonga na yoha ibhii mwonio! ");
INSERT INTO dne_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ndi mwenga jhumunteile ntumiche gwino, tate gwito Daude alongele kwa likakala lya Uhuke gwa Chapanga, akalongi, Kwa nhwalo ghane bhando bha nnema bhatenda bhulo, na nhwalo gwa nike bhando bhatenda mipangu jha jhajhe? ");
INSERT INTO dne_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bhahe, akanahota bhakolongwa bha pannema bhakibha miho, bhakolongwa bhibhalongocha bhakakongine pamonga, bhapala kunyambila Bhambo, na Kilichitu jwahaghulilwe. ");
INSERT INTO dne_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Chakaka, chakaka munahota nkolongwa Helode na Pontiyo Pilatu bhando bhu ku Ichilahele na bhando bhange chibhajhakonganike papa peniya pabomane, kwa kunkanila Yecho ntumiche gwino jhumunteile kubhehe Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bhene bhakapahile kuhenga ghala ghupata ghahengeka kuhumi makacho kwa likakala lino na kwa upalo gwino. ");
INSERT INTO dne_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nambo ngohe, Bhambo dolekeya kuyenga kwabhe. Bhahe, mutupekeye akatumiche bhino likakala kutangacha lilobhe lino changa kiholo. ");
INSERT INTO dne_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bhahe, nntondobhehe lubhoko mwalamicha bhando. Ntende nginyililo na ikangacho kwa liina lya Yecho ntumiche gwino jwa Nyahinyahi.” ");
INSERT INTO dne_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pubhajhomolila kunnyopa Chapanga, chehemo jhela jhibhakibha ijhakunyukanyuka, na bhoha bhene bhajhakuhulukiwa Uhuke gwa Chapanga. Na bhajhakutumbula kutangacha lilobhe lya Chapanga changa kiholo. ");
INSERT INTO dne_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Lilongo lyoha lilijheketila likibha lyabhe limo na mwojho ghumo. Akibhiijhe hilu jhumo jwakiteila chake kilebhe chochoha, nambo bhabhaghina yoha ibhakibha nayo pamonga. ");
INSERT INTO dne_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Akatenga bha Chapanga bhakajhendilii kulonge kwa makakala gha kuyoka kwa Bhambo Yecho, na jwenio Chapanga ajhakwapekeya mota hake. ");
INSERT INTO dne_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Akibha ndeka mundo jhojhoha jwapongokiwa kilebhe, nhwalo bhange bhubhakibha na mighonda amu nyumba bhatehila kuchulucha na kuleta mbijha, ");
INSERT INTO dne_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","na kwakamuha akatenga mbijha yenio, na bhene bhajhakwabhaghanichila bhando bhoha ngita chibhapalita. ");
INSERT INTO dne_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pakibha na Nnabhe jhumo, jwabhelukilwe ku Kipulo, jwakemitwa Uchupo, na helahela akatenga bhankemita kwa liina lenge Banaba, mana jhake, “Mundo jwaleke mwojho.” ");
INSERT INTO dne_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jwenio hele akibha na nng'onda gwake, ajhakuchulucha, ajhakupata mbijha na kwakamuha akatenga. ");
INSERT INTO dne_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Helahela akibha mundo jhumo liina lyake Ananiya, pamonga na nhwana mundo Safila bhajhakuchulucha nng'onda gwabhe. ");
INSERT INTO dne_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nambo mbijha henge ajhakuwininika mukwinda na ihighalike bhajhakuipeleka kwa akatenga. Nhwana mundo akamanyite mambu gheniya ghoha. ");
INSERT INTO dne_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bhahe, Petile ajhakunkonya, “Ananiya, Limbembela anyighite ko ade kulonge uwange palonge jha Uhuke gwa Chapanga na kuhiya mbijha yupatite kwa kuchulucha nghonda gwino? ");
INSERT INTO dne_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pukibha gwamela gwangachulucha nghonda, bho, chi ukibha gwino? Bho, puchulwicha, mbijha imukapatite ngahuotwi jhe kulyegha ngita chipata? Bhahe, nhwalo gwa nike nnenganikiye kumwojho kutenda naha? Mwakopokiye bhando jhe, nambo mukopokii Chapanga!” ");
INSERT INTO dne_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiya pajhohina malobhe gheniya, papa ajhakugwegha pahe puu na kuwegha. Na bhoha bhubhajhohina malobhe gheniya bhajhakujhoghopa hake. ");
INSERT INTO dne_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Peniya ingombo ijhakuhika, yegha yake bhajhakubhilingila ngobho jha malelo na kujhenda kuyelela kumambe. ");
INSERT INTO dne_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pughapetita machaa matato naha palonge, nhwana mundo ajhakuhika kongo amanyite jhe chikipitile nkate mola. ");
INSERT INTO dne_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petile ajhakunkonya, “Unongolele, puchulwicha nng'onda gwino, bho, mbijha henge ndi ipatite?” Mwikeghe jhola ajhakujhanguu, “Chakaka.” ");
INSERT INTO dne_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peniya Petile ajhakunobholela, “Nhwalo gwa nike mukalenganikiye kunyighanikiya Uhuke gwa Chapanga? Dolekeya! Bhala bhibhahuma kuyelela ungana gwino bhabhii pannyango, nabhene helahela nabhampeleka hele.” ");
INSERT INTO dne_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Papalapala Safila ajhakugwiya pahe palonge jha Petile na kujhomoka. Ingombo hela bhajhakujhingila nkate na kunkolela ajhomwike njwe. Bhahe, bhajhakunghegha yegha jhake na kuyelela pahina na ungana mundo. ");
INSERT INTO dne_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Peniya bhoghohe nkolongwa ujhakwakamula bhando bhoha bhibhanyeketile Kilichitu na bhoha bhubhajhohina malobhe gha mambu gheniya. ");
INSERT INTO dne_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Chapanga akatangatile akatenga kuhenga ikangacho na nginyililo pakate jha bhando. Bhibhajheketila bhoha bhakayobhalile kukonganika pamonga pa Bwalo jha Solomone. ");
INSERT INTO dne_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pakibha ndeka na mundo jhojhoha jwangabhehe pamonga mukibhogha chabhe jwapalita kubhehe pamonga bhatehila kujhoghopa. Nambo bhando bhange bhangabhehe pamonga mu kihobholelo bhajhakwakweya. ");
INSERT INTO dne_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bhando twe bhibhakajheketile Kilichitu bhajhakujhonjekeka kwa Bhambo, akanalome na akakeghe bhachochita hake, ");
INSERT INTO dne_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","kwa mambu gheniya ghoha ghughapitile, bhando bhajhakwatutuhana bhibhalwalwa mundela, bhajhakwaghonecha munjangwale na mmipacha, Petile papala kupeta, pange kiyeka chake chapetele. ");
INSERT INTO dne_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bhando twe kuhumii ku miche ya mupele jha ku Yeluchalemo, bhajhakwaleta bhibhalwalwa, na bhando bhibhang'ahika na michuka na bhoha bhajhakulamichwa. ");
INSERT INTO dne_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mpiya Litambiko nkolongwa na bhando bhake bhoha, bhando bha kibhogha cha Machadukayo, bhajhakwabhonela wiho akatenga. ");
INSERT INTO dne_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bhahe, bhajhakwakamula na kwatabha mukipungo. ");
INSERT INTO dne_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nambo uhiko gwa kilo ntumiche jwa Bhambo jwa kunane kwa Chapanga ajhakujhoghola milyango jha kipungo, ajhakwapiya akatenga panja na kwalobholela, ");
INSERT INTO dne_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nnyende mukajheme mu Nyumba jha Chapanga na kwalobholela bhando malobhe gha ughome nhyono.” ");
INSERT INTO dne_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na bhene akatenga bha Yecho bhajhakujhenda putiputi na kujhingila nkate mu Nyumba jha Chapanga, na kutumbula kubhola bhando. Mpiya litambiko nkolongwa na bhala bhange pubhahikita, bhajhakwakema bhando bha pa bwalo nkolongwa na ighogholo yoha yu ku Ichilahele, peniya bhajhakwatuma bhando bhakatole akatenga bhala. ");
INSERT INTO dne_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nambo akalonda bhala bhibhakatumitwe pubhahikita, bhakakolile ndeka akatenga mukipungo. Bhahe, bhajhakubhujha nu kulonge malobhe ghanga, ");
INSERT INTO dne_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","bhakalongi naha, “Tukoli nnyango gwa kipungo udinditwe nganganga na akalonda bhabhii mukulonda, nambo putujhogwila tumwe jhe mundo nkate.” ");
INSERT INTO dne_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nkolongwa jwa akalonda bha Nyumba jha Chapanga na bhakolongwa bha akapiya matambiko pubhajhohina malobhe ghala, bhajhakubhehe na kiholo, bhajhakukikonya nike chikipitile kwa akatenga. ");
INSERT INTO dne_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Peniya mundo jhumo ajhakuhika, na kwalobholela, “Unyokanikiye! Bhando bhala bhumatabhite bhabhii pa Nyumba jha Chapanga bhajhemite nu kubhola bhando!” ");
INSERT INTO dne_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Bhahe, nkolongwa jwa akalonda bha Nyumba jha Chapanga ajhakujhenda pamonga na akatumiche bhake, ajhakwaleta akatenga. Nambo bhakakamwi ndeka kwa makakala, nhwalo bhajhogwipa bhando bhakotoka kwabula maghanga. ");
INSERT INTO dne_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bhahe, pubhaletita, bhajhakwajhemika palonge jha udamo nkolongwa. Mpiya litambiko Nkolongwa ajhakutumbula kwakonya, ");
INSERT INTO dne_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ajhakwalobholela, “Tukakanikiye hotuhotu nkotoka kubhola kabhele kwa liina lya mundo jhonjo. Na ngohe ntumbwile mabholo ghino mu Yeluchalemo jhoha, na mangota mipala miyahe jha mundo hojho ibhehe panane jha twenga.” ");
INSERT INTO dne_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petile na akatenga bhange bhala, bhajhakujhanguu, “Ituchokolekeya twenga kunnyokanikiya Chapanga na chi bhando! ");
INSERT INTO dne_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Chapanga jwa akahoko bhito akayokiche Yecho, jhola mangota munkomite kwa kumamba panane jha nchalaba. ");
INSERT INTO dne_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Chapanga akampekiye ung'alicho na kubhehe lubhoko lwalelo, abhehe kilongoche na Nkomboche. Bhando bha ku Ichilahele bhajheketela na kuuleka uhakaho gwabhe na Chapanga nabhalekekeya uhakaho gwenio. ");
INSERT INTO dne_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Na twenga ndi bhitulolita mambu gheniya, helahela Uhuke gwa Chapanga ndi ijheketela mambu gheniya kwa bhala bhubhanyeketela.” ");
INSERT INTO dne_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Bhando bha pa Bwalo nkolongwa pubhajhohina malobhe gheniya, bhajhakuyoma hake na bhajhakwakoma akatenga bhala. ");
INSERT INTO dne_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nambo Pwalichayo jhumo, liina lyake Gamaliele, jwakibha mmola jwa Malaghalikilo na jwajhokanikilwa hake na bhando, ajhakujhema nu kulonge, akatenga bhapite hote panja kandina. ");
INSERT INTO dne_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Peniya ajhakwalobholela bhando bha pa bwalo, “Mangota bha ku Ichilahele, dolekeya mbone lijhambu lyenio limipala kwatendela bhando bhamba. ");
INSERT INTO dne_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ikapetite ndeka yaka yamahele ajhakupitila mundo jhumo jwankemitwa Teuda. Jwakikwehita kubhehe mundo nkolongwa, na bhando ngita mamiya ncheche bhajhakunkengama jwenio. Nambo ajhakukomwa, peniya bhabholwa bhake bhoha bhajhakupechengana na kibhogha chenie kijhakuhobhelela. ");
INSERT INTO dne_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Papetita jwenio, ajhakuhika Yuda jwa ku Galilaya. Jwenio Kolineliyo na jwenio akibha na bhando bhamahele. Nambo jwenio helahela akakomitwe na bhabholwa bhake, bhoha hele bhajhakupechengana. ");
INSERT INTO dne_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kwa mihalo jhenje ninobholela mangota mwaleke bhando bhamba bhajhende. Kwa mana anda lihengo lende litumbulichwa na bhando lichiko limo nalihobhelela. ");
INSERT INTO dne_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nambo anda litumbulichwe na Chapanga, nauhotola ndeka kwahibhalikiya. Bhahe, mukilolokeye mbone nkotoka kubhonekana mikomana na Chapanga. Bhahe, bhando bha pa bwalo bhajhakujheketela malobhe gha Gamaliele!” ");
INSERT INTO dne_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Peniya ajhakwakema akatenga bhala, bhajhakwachwapula yato na kwahibhilikiya bhakotoka kubhola kabhele kwa liina lya Yecho. Peniya bhajhakwalekekeya bhajhende. ");
INSERT INTO dne_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bhahe, akatenga bhala bhajhakubhoka pa Bwalo, bhakihanganila hake, nhwalo Chapanga akabhapekiye ichima kwa lihengo lya kupuchwa na kung'ahika kwa nhwalo gwa liina lya Yecho. ");
INSERT INTO dne_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kila lichiko, bhakalekiti jhe kubhola na kutangacha Lilobhe lya Mbone mu Nyumba jha Chapanga na nyumba henge kubhehe Yecho ndi Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu machiko ghala, bhabholwa bha Yecho pubhachochita kujhonjekeka, pakapitile lukokoleko Akayahude bhibhalongila Kigilike na Akayahude bhibhalongila Kiebulaniya. Na bhala bhibhalongila Kigilike bhakakokalike nhwalo akanawela bhabhe bhajhewitwe mukughabhilana ilebhe ya kila lichiko. ");
INSERT INTO dne_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Akatenga kome na bhabhele bhala bhajhakukonganika pamonga na lilongo lyoha lya bhabholwa, na kwalobholela, “Ihalalila ndeka twenga kuleka kutangacha Lilobhe lya Chapanga na kuhenga lihengo lya kubhaghana ilebhe ya kulyegha. ");
INSERT INTO dne_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bhahe, akalongo mahaghule akanalome chaba pakate jhino bhambone, na bhibhatweli Uhuke gwa Chapanga na bhina malango twebheke kwa lihengo lende. ");
INSERT INTO dne_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na twenga natuhighalika mukunyopa na kutangacha lilobhe lyake Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Lilongo lyoha lijhakuhutilwa na nhwalo gwenio. Na bhene bhajhakwahaghula bhando bhamba, Sitefano, mundo jwakibha na kihobholelo kikolonga na jwatwelile Uhuke gwa Chapanga na Filipu na Pulokolo na Nikaola na Timone na Palimena na Nikolao, mundo jwa ku Antiyokiya jwaghalambukile kihobholelo cha Kiyahude kuhumii makacho. ");
INSERT INTO dne_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Peniya bhajhakwabheka palonge jha akatenga, na bhene bhajhakujhopa kwa kubheka mabhoko panane jhabhe. ");
INSERT INTO dne_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bhahe, lilobhe lya Chapanga lijhakuchocha kuchobhela kwenio ku Yeluchalemo na bhabholwa bhajhakujhonjekeka hake na bhapiya matambiko twe bhajhakubhehe na kihobholelo. ");
INSERT INTO dne_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Chapanga ampekiye mota twe Sitefano na akibha na likakala twe, na jwenio ajhakuhenga mambu gha nginyililo na gha ikangacho pakate jha bhando. ");
INSERT INTO dne_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nambo bhajhakupitila bhando bhibhahumile ku nyumba jha kukonganikii Akayahude jhikemitwa bhando hulu na bha Akakilene na bha Alekichandaliya na helahela Akayahude bhange kuhumii ku Kilikiya na bha ku Siliya na bhaku Asiya bhajhakutaungana nako Sitefano, ");
INSERT INTO dne_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","nambo bhakahotwi ndeka nhwalo gwa Uhuke gwa Chapanga ukampekiye malango palongila. ");
INSERT INTO dne_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Peniya bhajhakwapekeye chwinda bhando bhalongele, “Bhanyohine Sitefano akilongela malobhe gha kuntondola Mucha pamonga na Chapanga!” ");
INSERT INTO dne_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bhahe, bhajhakwakokwelekeya bhando bhayome, ighogholo na bhabhola bha Malaghalikilo. Na bhene bhajhakunkamula Sitefano na kuhikicha pa Bwalo nkolongwa. ");
INSERT INTO dne_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Peniya bhajhakwaleta bhibholongila uwange bhalongila, “Mundo hojho atotoke jhe kulonge malobhe gha maligho gha nyumba jha Chapanga pamonga na Malaghalikilo gha Mucha. ");
INSERT INTO dne_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tukajhokaniye akilongela hojho Yecho jwa ku Nachalete chatilulana Nyumba jhenje jha Chapanga kulighalambuwa Lilaghalikilo litulipokile kuhumi kwa Mucha.” ");
INSERT INTO dne_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Na bhoha bhubhakahikite pa Bwalo ghola bhajhakumpihikiya miho Sitefano, bhajhakulola kumiho jhake ihwanana ngita ntumiche jwa kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Bhahe, Mpiya Litambiko nkolongwa ajhakunkonya Sitefano, “Bho, malobhe ghanga ghabhalongii gha uchakaka?” ");
INSERT INTO dne_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na jwenio Sitefano ajhakujhanguu: “Makalongo bhango na akatate bhango, unyokanikiye! Kabula jha hoko gwito Ulahimo kupitilwa na Chapanga pakibha ku Misopotamiya kabula kujhenda kutama ku Halane. ");
INSERT INTO dne_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Chapanga ajhakunobholela, ‘Mmoke mu kilambo chino, na mwaleke akalongo bhino, na nnyende ku kilambo chinipala kunangiya.’ ");
INSERT INTO dne_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Bhahe, Ulahimo ajhakubhoka mu kilambo chuku Kalodayo, nu kujhenda kutama ku kilambo chuku Halane pajhomwika tate mundo. Kabhele Chapanga ajhakuntola Ulahimo kubhoka ku Halane na kunneta mu kilambo chenje chimitama ngoheno. ");
INSERT INTO dne_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kwenio Chapanga akampekii ndeka Ulahimo kilambo kibhehe chake, akampeki jhe hilu chehemo jha kubheka lugholo lwake, nambo akabhekite lilaghano Ulahimo na kibheleko chake, machiko gheniya Ulahimo akibha jhe na mwana. ");
INSERT INTO dne_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Chapanga akannobholile naha, ‘Ibheluko hino na ijhende ku kilambo cha akaghene kutama, na kwenio nabhatendwa akabhanda na kutendelwa ghanganandela kwa yaka mamiya ncheche. ");
INSERT INTO dne_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nambo nenga chanahadabula bhando bha kilambo chenie bhibhantendela mangota naha. Peniya nanikibhoha kibheluko chino kuhumi mu kilambo chenie nabhahika kunyinamila chehemo jhino.’ ");
INSERT INTO dne_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bhahe, Chapanga ajhakutenda nako lilaghano lya kujhingii jando. Na Ulahimo ajhakunyingiya jando Isaka pahichikicha lichiko lya nane kuhumii mu kubhelukwa. Na jwenio Isaka ajhakutenda hele, panyingiya jando Yakobu. Helahela Yakobu ajhakutenda hele kwa akahoko bhito kome na bhabhele bhala. ");
INSERT INTO dne_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Akahoko bhito bhamonela wiho Uchupo, bhajhakuchulucha mubhanda ku Michile. Nambo Chapanga ajhakubhehe pamonga na jwenio, ");
INSERT INTO dne_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ajhakunghombola kuhumi mu malola ghoha. Chapanga ajhakumpekeya mota na malango gha kupalwa palonge jha Falao, munahota nkolongwa jwa ku Michile, na Falao ajhakumpekeya ulongoche gwa kilambo chela na nyumba jha unduna. ");
INSERT INTO dne_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Bhahe, ijhakupitila njala nkolongwa mu kilambo choha cha ku Michile na ku Kanane, jhiletita lung'ahe lukolongwa. Akahoko bhito bhakahotwi ndeka kubhehe na chakulyegha chochoha. ");
INSERT INTO dne_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakobu pajhohina ku kilambo chuku Michile kibhii na malombe, ajhakwatuma yana mundo, ndi akahoko bhito, bhajhende kwenio kwa kutumbulila. ");
INSERT INTO dne_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kwa mwanja gwabhe gwa ubhele, Uchupo ajhakwatenda akalongo mundo bhaumanye, na jwenio Munahota Falao ajhakwamanya akalongo mundo Uchupo. ");
INSERT INTO dne_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Peniya Uchupo ajhakulaghalikiya kwa tate mundo Yakobu na akalongo mundo bhoha, bhakahikile bhando makome chaba na nhwano, bhajhende ku Michile. ");
INSERT INTO dne_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Bhahe, Yakobu ajhakujhenda ku Michile, kwenio jwenio na akahoko bhito bhakawelile. ");
INSERT INTO dne_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yegha yabhe ikaletitwe ade ku muche gwa Shekemu, na mambe jhake ikahemilwe na Ulahimo kuhumi kulokolo lwa Hamole kwa mbijha yandina naha. ");
INSERT INTO dne_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Pughahikila machiko gha Chapanga kulenganikiya lilaghano lyake kwa Ulahimo, bhando bhito bhubhakibha ku Michile bhajhakujhonjekeka na kubhehe lilongo likolongwa hake. ");
INSERT INTO dne_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Peniya, pajhakupitile na munahota nkolongwa jhumo jwangamunya Uchupo na kutumbuu kulongocha kwenio ku Michile. ");
INSERT INTO dne_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Munahota nkolongwa jwenio ajhakwatendela uhakata bhando bhito, na kwang'aha akohoko bhito, helahela kwachokolekeya bhahitaghe yana yabhe ing'enya panja jha nyumba ihweghe. ");
INSERT INTO dne_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Machiko gheniya ndi pabhelwikwa Mucha, akahali hake mwana jwenio. Akalelitwe munyumba jha akatate mundo kwa miyehe mitato, ");
INSERT INTO dne_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","pubhampihita panja, nchikana jwa Munahota nkolongwa Falao jwa ku Michile ajhakuntola na kuntenda ngita mwana mundo jwakupapa. ");
INSERT INTO dne_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mucha akabholitwe mambu ghoha gha malango gha Akamichile, ajhakubhehe mundo jwamanyikine kwa mukulonge na matendelo gwake. ");
INSERT INTO dne_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Mucha pahikicha yaka makome ncheche, ajhakwapalaha akalongo mundo bha ku Ichilahele bhibhalagha. ");
INSERT INTO dne_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kwenio ajhakumona nnongo mundo mu Michile akitentendela ghanganandela na jwenio ajhakujhenda kunkengelela kwa kulepechela kunkoma mu Michile jhola. ");
INSERT INTO dne_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mucha ahambwika akalongo mundo nabhamanya atumitwe na Chapanga kwakombola bheniya kupete jwenio, nambo bhakabangatwike ndeka. ");
INSERT INTO dne_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kilabho jhake Mucha ajhakwabhona Akaichilahele bhabhele bhatehila kukomana, na jwenio ajhakukanakiya, ajhakulonge, ‘Akakoche bhango, mangota malukolo, ngohe nhwalo ghane mikocholana mabhene kwa mabhene?’ ");
INSERT INTO dne_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Nambo jhola jwakunita nnyake jhola ajhakunkangila Mucha paupele alongila, ‘Ghane jwamekite mwenga kubhehe kilongoche na makenga bhulo gwito? ");
INSERT INTO dne_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bho, umbala kungoma nenga ngita chimukomita dicho mu Michile jhola?’ ");
INSERT INTO dne_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mucha pajhohina malobhe gheniya, ajhakulubheya lubhelo na kujhenda kutama ngita nghene ku kilambo cha ku Midiane na kwenio ajhakupapa yana ibhele. ");
INSERT INTO dne_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Puipetita yaka makome ncheche, ntumiche jwa Bhambo ajhakumpitila Mucha pa kiheghejha chikijhaka mwotu ku njenga kola, chikibhii pahina na ku kitombe cha ku Chinae. ");
INSERT INTO dne_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mucha ajhakuhechuka hake palolita lyenio, ajhakuheghelela pahina alingukii mbone, papa ajhakujhoha lilobhe lya Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Lilongila, ‘Nenga ndi Chapanga jwa hokolo gwino, Chapanga jwa Ulahimo, Isaka na Yakobu.’ Peniya Mucha ajhakulendema na kujhoghopa nambo akajhendilile ndeka kulingukiya kabhele. ");
INSERT INTO dne_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Papalapala Bhambo ajhakunobholela, ‘Ula maghubache ghino, nhwalo pambano punyemite chehemo jha nyahinyahi. ");
INSERT INTO dne_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Chakaka nolite bhando bhango bha ku Ichilahele bhabhii mu malagho mu kilambo cha ku Michile. Ninyohine kulela kwabhe, na nenga hikite kwakombola. Ngohe nanipeleka mwenga ku Michile kola.’ ");
INSERT INTO dne_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mucha jhonjo ndi jhola bhando bha ku Ichilahele jhubhankanite, jwalongila, ‘Ghane jwamekite mwenga kubhehe kilongoche na makenga mihalo jhito?’ Kwa ndela jha ntumiche jwa Bhambo jwapitila pa kiheghejha chikijhakita mwotu, nambo kitinika jhe, Chapanga akatumite jwenio Mucha abhehe kilongoche na nkomboche ghino. ");
INSERT INTO dne_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jwenio ndi jwabhalongwicha bhu ku Ichilahele kubhoka ku Michile kwa kuhenga mambu gha kukangacha mu kilambo chela, ku mbwane ngele na ku njenga kwa yaka makome ncheche. ");
INSERT INTO dne_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ndi jhola Mucha jwabhalobholila bhando bhu ku Ichilahele, Chapanga chahaghulila mangota milondole ngita nenga, jwenio kuhumi kwa akalongo bhino mabhene. ");
INSERT INTO dne_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Machiko gheniya bhando bhu ku Ichilahele bhakonganike ku njenga, jwenio Mucha akibha kwenio pamonga na akahoko bhito na jhola ntumiche jwa Chapanga jwalongila nako ku kitombe cha ku Chinae. Ndi jwenio jwayekulilwe lilobhe lya Chapanga lilibhii na ughome na kutupe twenga. ");
INSERT INTO dne_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Nambo jwenio Mucha ndi jwakangitwa paupele na akahoko bhito kwa kukana kunyokanikiya, na kupala kubhujha kabhele ku Michile. ");
INSERT INTO dne_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bhajhakunobholela Halune, ‘Mutulenganikiye inyagho ya kutulongocha undela, nhwalo tumanyite jhe ghighankolile Mucha hojho jwatubhohita twenga ku Michile.’ ");
INSERT INTO dne_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Peniya ndi bhajhakutengenechela inyagho ibhonikina ngita litohe lya ng'ombi, bhajhakukitambikila na kukitendela unyagho, ndi mahengo gha mabhoko ghabhe bhene. ");
INSERT INTO dne_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bhahe, Chapanga ajhakwaleka pakate jhabhe na kujhenda kutale, na kwaleka bhaijhinamila ndondwa na lyobha na mwehe. Ngita chijhandikwe mukitabo cha milondole bha Chapanga, pubhalongila, Mangota bhando bha ku Ichilahele, chi nenga jhuhumbikiya litambiko na matambiko ghange, kwa yaka makome ncheche ku njenga kola. ");
INSERT INTO dne_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ntyangita kongo ngheghite ichimba ya kichapanga gwino Moleke, na kinyagho cha ndondwa ya kichapanga gwino Lefane. Mukakitengenechile kinyagho nhwalo mukijhinamila. Ngohe nanimpeleka kuluhamilo ku kilambo chuku Babelone. ");
INSERT INTO dne_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Kola ku njenga akahoko bhito bhakibha na kichimba cha nyahinyahi, chikilenganikilwe ngita Chapanga chanaghalikiya Mucha na akalenganikiya ngita chalangiwe. ");
INSERT INTO dne_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Peniya akahoko bhito bhajhakujhangangana bhene kwa bhene ade ulongoche gwa Yochuwa, pubhatoila kilambo kubhoka kwa bhando jwenio Chapanga akabhengite palonge jhabhe. Peniya kichimba chenie kijhakutama ade machiko gha Daude. ");
INSERT INTO dne_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Chapanga akampahi hake Daude, na jwenio ajhakunnyopa Chapanga anchengele chehemo jha kutama kwa nhwalo gwa Chapanga jwa Yakobu. ");
INSERT INTO dne_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nambo Chelemane ndi jwakanchengile Chapanga nyumba jhene. ");
INSERT INTO dne_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Nambo Chapanga Nkolongwa atama ndeka munyumba jhichengitwe na bhando ngita chalongela nnondole jwa Chapanga: ");
INSERT INTO dne_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Bhambo ilongela, ‘Kunane kwa Chapanga ndi kigoda chango cha unahota nkolongwa, na pannema ndi kigoda chango cha kubheke makongono. Bhahe, nyumba ghane nauhotola kunchenge nenga? Amu pwache ghane nauhotola kutama nenga? ");
INSERT INTO dne_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bho, ne ndeka jhundeila gheniya ghoha?’ ");
INSERT INTO dne_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Mangota bhando mina lighoho! Mangota miyojho na machikilo ghino ghanonwipe ngita bhando bhangajheketela!” Mmii ngita akahoko bhino machiko ghoha mukundii lighoho Uhuke gwa Chapanga! ");
INSERT INTO dne_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bho, abhii nnondole jwa Chapanga jhojhoha akahoko bhino bhakaung'ahite ndeka? Bhakakomitwe bheniya na jwenio Chapanga akatumite akatangache kuhika jhola jwajheketelwa palonge jha Chapanga. Na mangota mukanyambi kwa kunkoma. ");
INSERT INTO dne_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Chapanga akampekii mangota lilaghalikilo lyake kwa ndela jha akatumiche bhake bha kunane, nambo mukajheketii ndeka. ");
INSERT INTO dne_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Akanahota bha pa Udamo nkolongwa pubhajhohina malobhe gheniya, bhajhakubhehe na lilaka hake, na bhajhakuyagha mino kwa lilaka. ");
INSERT INTO dne_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Nambo Sitefano akibha atwelii twe Uhuke gwa Chapanga, ajhakulolekeya kunane kwa Chapanga, ajhakulola ung'alicho gwa Chapanga na jwenio Yecho atamite kulubhoko lwalelo lwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jwenio Sitefano palongila, “Dolekeya! Nikuwene kunane kwa Chapanga kudindwike, na jwenio Mwana gwa Mundo ajhemite kulubhoko lwalelo lwa Chapanga!” ");
INSERT INTO dne_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bhahe, bhando bha pa bwalo bhala bhajhakuchobhela kanonoha na kuhibha machikilo kwa mabhoko ghabhe, na bhoha bhajhakuyenganila kwa pamonga, ");
INSERT INTO dne_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","bhajhakututuana kumpeleka kutale na muche, na kutumbu kumbula kwa maghanga. Na bhala bhubhalolita bhajhakughabheka makanjo ghabhe kwa kangombo jhumo jwalondita, jwamanyikina kwa liina lya Saule. ");
INSERT INTO dne_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Bhajhendilila kumbula Sitefano kwa maghanga kwenio anyopita Chapanga, ajhakulonge, “Bhambo Yecho mupokele mwojho gwango!” ");
INSERT INTO dne_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Peniya ajhakutama makilikite na kulalama kwa lilobhe likolongwa, alongila, “Bhambo, nkotoka kwabhalangila uhakaho ghongo.” Pajhomolila kulonge, ajhakuwegha. ");
INSERT INTO dne_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saule na jwenio akajheketile kukomwakwa Sitefano ndi tela. Lichiko lelela lela lilongo lya bhando lilinyeketii Kilichitu lilibhii ku Yeluchalemo lijhakubhehe mulung'ahe lukolongwa. Bhibhajheketila bhoha bhajhakupechengana ku Yudeya na ku Samaliya, na kwaleka akatenga tugha. ");
INSERT INTO dne_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bhando bhange bhubhampahila Chapanga, bhajhakuyelela Sitefano na kulela hake malelo ghake. ");
INSERT INTO dne_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nambo Saule akatumbwii kwang'aha lilongo lya bhando lilinyeketii Kilichitu, ajhakujhingila nyumba ade nyumba, na kwakamula bhibhajheketii bhoha, akanalome na akakeghe, na kujhenda kwatabha mukipungo. ");
INSERT INTO dne_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bhala bhibhajheketii bhange bhapechengine, na kone patangicha Lilobhe lya Mbone. ");
INSERT INTO dne_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipu na jwenio ajhakujhenda ku muche nkolongwa gwa ku Samaliya na kutangachii bhando bha peniya mambu gha Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lilongo lya bhando pubhajhohina malobhe ghala Filipu ghalongila na kulola ikangacho na nginyililo hela ipitila, chakaka bhajhakunyokanikiya. ");
INSERT INTO dne_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nhwalo michuka jhibhachikilwa bhando ijhakulalama kwa lilobhe likolongwa, na bhando bhamahele bhibhatengwike pamonga na bhibhalemile helahela bhakalamichwe. ");
INSERT INTO dne_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Bhahe, bhando bha muche ghola bhajhakubhehe na kiheko hake. ");
INSERT INTO dne_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pakibha na mundo jhumo jwakemitwa Simone, jwenio abhakangicha bhando bhu ku Samaliya kwa mambu gha uhabhe. Akilokita jwenio ndi nkolongwa kuliku bhange, ");
INSERT INTO dne_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","bhando bhoha, kutumbulila yana na ighogholo bhakanyokanikiye kwa uchakaka, bhalongila, “Mundo hojho ndi likakala lela lya ki chapanga, lilikemwa, ‘Likakala Likolo.’ ” ");
INSERT INTO dne_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Chakaka bhakautilwe hake kwa ikangacho ya uhabhe gwake kwa machiko ghamahele. ");
INSERT INTO dne_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nambo pibhanyeketila Filipu kwa Malobhe gha Mbone gha unahota nkolongwa gwa Chapanga, na liina lya Yecho Kilichitu, akanalome na akakeghe bhajhakubatichwa. ");
INSERT INTO dne_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simone jwenio akajheketile gheniya, ajhakubatichwa na bhalongohina bhoha na Filipu, na jwenio ajhakukangacha hake palolita mambu makolo gha kukangacha ghighahengika. ");
INSERT INTO dne_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Akatenga bhubhakibha ku Yeluchalemo pubhajhohina bhando bhu ku Samaliya bhajhakujheketela lilobhe lya Chapanga, akwatuma Petile na Yohane bhajhende kwenio. ");
INSERT INTO dne_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pubhahikita ku Samaliya, bhajhakwabhekela mabhoko bhapokele Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kwa machiko gheniya Uhuke gwa Chapanga akahulukile ndeka kwa jhojhoha pakate jhabhe, bhakabatichwe kwa liina lya Bhambo Yecho kanjika. ");
INSERT INTO dne_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peniya Petile na Yohane bhajhakwabheke mabhoko panane jhabhe bhibhannyeketii, na bhene bhajhakupoke Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simone panga'amwila kwa kubhekelwa mabhoko na akatenga bhakapekiwe Uhuke gwa Chapanga. Bhahe, apala kwapekeya mbijha Petile na Yohane alongila, ");
INSERT INTO dne_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Umbekehe na nenga helahela uhotolo gwenio, jhojhoha jhumbala kumeke mabhoko apokele Uhuke gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nambo Petile ajhakujhanguu, “Mwe mmoke oko na mbijha hino, pimihola mihoto kuheme kitoi cha Chapanga kwa ndela jha mbijha! ");
INSERT INTO dne_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mwenga mmii jhe na chino hilu mundo jwaumbone palonge jha Chapanga kwa jhojhoha mu lijhambu lende, kwa nhwalo mwojho gwino gwaumbone jhe palonge jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bhahe, nnyeketele na muuleke uhakaho gwino na munyope Bhambo, pange channekekeya. ");
INSERT INTO dne_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nhwalo nibhona ntwelii lipyanda hake na mwenga mupungitwe na uhakaho.” ");
INSERT INTO dne_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Peniya Simone ajhakwanobholela Petile na Yohane, “Unyopele kwa Bhambo, ghangotoka kungolela malobhe gheniya ghunongile.” ");
INSERT INTO dne_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bhahe, kwalangiya ghubhaghawene na kutangacha lilobhe lya Bhambo, Petile na Yohane bhajhakubhujha ku Yeluchalemo kongo bhatangicha Lilobhe lya Mbone mu chenda yamahele ya ku Samaliya. ");
INSERT INTO dne_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ntumiche jwa Bhambo jwa kunane kwa Chapanga ajhakunobholela Filipu, “Mukilenganikiye kujhenda upandi gwa kuchine kupetela ndela jhihumile ku Yeluchalemo na kujhenda ku muche gwa Gacha.” Ndela jhipetela ku njenga. ");
INSERT INTO dne_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bhahe, Filipu ajhakutumbuu mwanja. Papalapala pakibha na Mwichopiya jhumo, jwenio akibha agwelii palindalabho atehila mwanja gwa kubhujha kajhake. Jwenio akibha jwajhemilila kihukilo cha mbijha cha Kandake, kilongoche mwikeghe jwa ku Ichopiya. Jwenio mundo jwajhawile ku Yeluchalemo kunyinamila Chapanga na pabhujhita atyangitila mutuka jhihutitwa liponda, ");
INSERT INTO dne_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","na ngohe pakibha mumwanja gwa kubhujha kajhake kongo atamite mu mutuka jhake achomita kitabo cha nnondole jwa Chapanga Isaya. ");
INSERT INTO dne_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Uhuke gwa Chapanga ujhakunobholela Filipu, “Nnyende pahina na mutuka jhene.” ");
INSERT INTO dne_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipu ajhakujhenda lubhelo pahina na litolole lilihutitwa na liponda, na jwenio ajhakunyoha mundo jhola akachoma mukitabo cha nnondole Isaya. Filipu ajhakunkonya, “Mughamanye ghighajhandikwe mwenio?” ");
INSERT INTO dne_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Na mundo jhola pajhangwila, “Chamanya bhole changanongoya mundo?” Bhahe, ajhakunobholela Filipu ahobhokele mumutuka mola na atame pahina jhake. ");
INSERT INTO dne_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Bhahe, pachomita mu Majhandiko gha Chapanga ghalongila naha, “Abhii ngita limbelele lilijhenda kuchinjwa, abhii nuu ngita limbembele puliheketwa mangoma. jwenio akapihitejhe lilobhe hilu pandina. ");
INSERT INTO dne_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Abhonikina antope jhe na kunyima ghala ghaghanita kupata abhii jhe nahotola kulonge panane jha kibheluko chake, nhwalo ughome gwake ubhokite pannema ghoha.” ");
INSERT INTO dne_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mwichopiya jhola ajhakunkonya Filipu, “Nanjino unobholele, nnondole jwenio alonge panane jha nike amu malobhe gheniya akilongolela jwenio amu mundo jhonge?” ");
INSERT INTO dne_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Bhahe, Filipu ajhakutumbuu kulonge atumbulila chehemo jha Majhandiko gha Chapanga pachomita, ajhakunobholela Malobhe gha Mbone panane jha Yecho. ");
INSERT INTO dne_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Pubhajhendilila na mwanja ghola, bhajhakuhika chehemo jhina mache, munahota jhola ajhakulonge, “Pamba pina mache, kibhii kilebhe chochoha chikihibhilikiya ngotoka kubatichwa?” ");
INSERT INTO dne_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipu ajhakunobholela, “Anda nnyeketele kwa mwojho gwii ghoha, mihoto kubatichwa.” Na jwenio pajhangwila, “Chakaka, nyeketile kubhehe Yecho Kilichitu ndi Mwana gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Bhahe, ajhakujhemeka mutuka jhihutitwa na liponda. Filipu na jhola munahota bhajhakuhuluka bhoha bhabhele nkate na kutumbuki umache, na Filipu ajhakumbaticha. ");
INSERT INTO dne_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Pubhabhokita umache mola, papalapala Uhuke gwa Bhambo Chapanga ujhakuntola Filipu na munahota jhola akamwe ndeka kabhele, nambo ajhakujhendelela na mwanja gwake kongo abhii mukuhanganila. ");
INSERT INTO dne_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipu pabangatwika abhii ku muche gwa ku Azoto. Peniya ajhakupeta mu miche jhoha kutangacha Malobhe gha Mbone, ade pahikita ku Kaisaliya. ");
INSERT INTO dne_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Mu machiko ghala, Saule achochita kuyenga kukoma bhabholwa bha Bhambo. Lichiko limo ajhakunyendelela Mpiya litambiko nkolongwa, ");
INSERT INTO dne_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","na baluwa jhene inangiye Saule kujhingii munyumba jha kukonganikii Akayahude bha kola ku Damasiko, na kwenio anda akongine na akanalome amu akakeghe bhubhii mundela jhene, abhakamule na kwa bhujhicha ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nambo pubhakibha pahina kuhika ku Damasiko, papalapala lilangamule ndaa kuhumii kunane kwa Chapanga lijhakuntindila. ");
INSERT INTO dne_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nyakugwegha pahe puu, na kulijhoha lilobhe lya Bhambo linobholila, “Saule, Saule, nhwalo gwa nike ung'aha nenga?” ");
INSERT INTO dne_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jwenio ajhakukonya, “Majhango ma ghane, bho, ma Bhambo?” Bhambo ajhakujhanguu, “Nenga ndi Yecho jhuming'aha naha. ");
INSERT INTO dne_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nambo jhema ngohe, nnyingile mubomane, na kwenio nanobholelwa chimipalwa kuhenga.” ");
INSERT INTO dne_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bhando bhala bhubhakibha mumwanja pamonga na Saule bhajhakujhema nuu nhwalo bhakahotwi ndeka kulonge chochoha, nhwalo bhakajhohine lilobhe lela, nambo bhakamwe ndeka mundo jwenio. ");
INSERT INTO dne_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saule ajhakujhema, payekwila miho ghake nambo ahotwila ndeka kulola. Peniya bhajhakunkamula lubhoko na kuntandala ade nkate jha ku muche gwa Damasiko. ");
INSERT INTO dne_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ajhakuhighalika kwa gwa machiko matato changa lola, na jwenio akatamite changa lyegha hilu kunywegha kilebhe chochoha. ");
INSERT INTO dne_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Bhahe, na kola ku Damasiko kukibha na mmolwa jhumo jwa Yecho jwakemitwa Ananiya. Bhambo ajhakuyekulila mu uloto, ajhakunkema alongila, “Ananiya!” Ananiya ajhakujhanguu, “Nenga Bhambo.” ");
INSERT INTO dne_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bhambo ajhakunobholila, “Nnyende ndela jhikemwa ‘Ndika,’ mukajhingii nkate munyumba jha Yuda, na mwenio namunkolela mundo jwa muche gwa ku Taliso liina lyake Saule, namukolela inyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Jwenio alotile mundo jhumo muuloto jwakemitwa Ananiya, akijhingila nkate jha nyumba na kumeke mabhoko panane jhake alole kabhele.” ");
INSERT INTO dne_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nambo Ananiya ajhakujhanguu, “Bhambo, nyohine kwa bhando bhamahele bhakilongela malobhe gha mundo jhonjo, bhalongila ghanganandela ghabhatendile bhando bhino bhibhapalwa na Chapanga kwenio ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na kongo ahikite abhii na ukindendeke gwakamwiwe kuhumii kwa akapiya matambiko bhakolo kwakamula bhoha bhibhajhopa kwa liina lino.” ");
INSERT INTO dne_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nambo Bhambo ajhakunobholela, “Nnyende tugha, kwa nhwalo ninhagwile mundo hojho kubhehe chombu chango, na atangache liina lyango kwa ilambo na kwa akanahota na kwa bhando bhu ku Ichilahele. ");
INSERT INTO dne_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Na nenga nanilangiya ghoha chapala kung'ahika kwa nhwalo gwa liina lyango.” ");
INSERT INTO dne_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Bhahe, Ananiya ajhakujhenda na kujhingila nkate jha nyumba jhabhii Saule, ajhakumeke mabhoko panane jhake na kunnobholela, “Malongo Saule, Bhambo Yecho jwenio jwakamupitile pumukibha undela kuhika pamba, andumite kwino nnole kabhele na kutweleywa Uhuke gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Papalapala ilebhe ngita majhobhotelo gha homba ghajhakupona pahe kuhumii mu miho gha Saule, na jwenio ajhakuhotola kulola kabhele. Peniya ajhakujhema na kubatichwa. ");
INSERT INTO dne_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Peniya ajhakulyegha, na likakala lijhakumujhila kabhele. Saule akatamite machiko ghandina na bhabholwa bhubhakibha kwenio ku Damasiko. ");
INSERT INTO dne_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Peniya ajhakutumbuu kutangacha munyumba jha kukonganikii Akayahude, ajhakwatangachila kubhehe Yecho ndi Mwana gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bhoha pubhajhohina bhajhakukangacha, bhalongila, “Mundo hojho chi jhola jwakomita bhando pa Yeluchalemo bhubhalikema liina lya Yecho? Chakaka ahikite kwatabha bhando ngita bhala na kwapeleka kwa akakolongwa bha matambiko?” ");
INSERT INTO dne_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Nambo Saule ajhakujhendelela kubhehe na likakala lya kutangacha, na kwapeta Akayahude bhubhatamita ku Damasiko kwenio ajhakulonge hotuhotu Yecho ndi Kilichitu. Na Akayahude bha kwenio bhakahotwi ndeka kukanila. ");
INSERT INTO dne_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pughapitita machiko ghamahele, Akayahude bhajhakukonganika pamonga na kubheka mipangu jha kukoma Saule, ");
INSERT INTO dne_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","nambo Saule akahiumbwile mipangu jhene. Na bhene kilo na muhe bhatehila kunyobhela panyango gwa kujhingilila mu muche bhankome. ");
INSERT INTO dne_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","nambo lichiko limo kilo bhabholwa bhake Saule bhajhakuntola, bhajhakummeka mu kichukilo na kunhuluwa pa lubhanja. ");
INSERT INTO dne_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saule pahikita ku Yeluchalemo, ajhighita kukonganika na bhabholwa bhange, nambo bhoha bhajhakunyoghopa, nhwalo bhakajheketile ndeka chakaka Saule aghalambuke na kubhehe mmolwa. ");
INSERT INTO dne_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bhahe, Banaba ajhakuntola Saule na kunhikicha kwa akatenga. Ajhakwanobholela Saule chakongina na Bhambo undela na jwenio Bhambo chakalongila nako. Helahela ajhakunobholela Saule chatangachila bhando kwa liina lya Yecho changa kujhoghopa ku muche gwa ku Damasiko. ");
INSERT INTO dne_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saule ajhakutama pamonga nabho, ajhakutyangila muche gwa ku Yeluchalemo jhoha na kutangacha Malobhe gha Bhambo changajhoghopa. ");
INSERT INTO dne_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Helahela ajhakulonge na kutaungana na Akayahude bhubhakibha bhalongila Kigilike, nambo bhene bhajhakupalaha ndela jha kunkoma. ");
INSERT INTO dne_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bhando bhibhanyeketii Kilichitu pubhajhohina malobhe gheniya, bhajhakuhutila panja na mu muche gwa ku Kaisaliya, na bhajhakuneka ajhende ku muche gwa ku Taliso. ");
INSERT INTO dne_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Machiko gheniya ghoha, bhando bhibhanyeketii Kilichitu bhajhakubhehe na uteeke mu Yudeya jhoha, mu Galilaya na mu Samaliya. Bhando bhibhanyeketii Kilichitu, na kwa ndela jha kutangatilwa na Uhuke gwa Chapanga bhakangamalichwe na kujhonjeka ngita chibhajhendilila kuntembekeya Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petile pakibha atyangila kila chehemo jha miche jhene, lichiko limo ajhakujhenda kwa bhando bhibhapalwa na Chapanga bhubhatamita bhu ku Lida. ");
INSERT INTO dne_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kwenio ajhakukongana na mundo jhumo jwatengwike yegha kwa yaka nane jwakemitwa Aineya apitita ndeka panja. ");
INSERT INTO dne_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bhahe, Petile ajhakunobholela, “Aineya, Yecho Kilichitu inamicha. Jhema atambula mpacha gwino.” Papalapala Aineya ajhakujhema. ");
INSERT INTO dne_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bhando bhoha bhu ku Lida na ku Solane pubhalolita mambu gheniya bhajhakughalambukila Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ku muche gwa ku Yopa kukibha na mmolwa jhumo mwikeghe liina lyake Tabita kwa Kigilike ndi “Dolika,” mana jhake “Mbabhala.” Mwikeghe jwenio akibha atehila mambu ghamahele ghambone na kwatangatila akahocho. ");
INSERT INTO dne_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mu machiko ghala atehila kulwalwa, na jwenio ajhakuwegha. Bhando pubhajhomolila kujhoha yegha jhake, bhajhakughonecha kuchumbi cha ku gholofa. ");
INSERT INTO dne_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nhwalo muche gwa ku Yopa ubhii kutale ndeka na muche gwa ku Lida, bhabholwa pubhajhohina Petile abhii kwenio, ajhakwatuma akatenga bhabhele bhajhende bhakanobholele Petile, “Chonde ajhomboteke kuhike kongo.” ");
INSERT INTO dne_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Papalapala Petile ajhakujhenda pamonga nabho. Na jwenio pupahikita kola bhajhakumpeleka nkate jha chumbi cha ku gholofa. Akanawela bhamahele bhajhakuntindila Petile, bhalelita na kongo bhanangiya makanjo na ngobho yatenginicha Dolika pakibha ghome. ");
INSERT INTO dne_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petile ajhakwanobholela bhando bhoha mupitengane panja, ajhakutama makilikite na kunyopa Chapanga. Na kughalambukila malelo ghala, alongila, “Tabita, jhema!” Peniya Tabita ajhakuyekula miho, pamonita Petile ajhakujhimuka na kutama. ");
INSERT INTO dne_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petile ajhakunkamula lubhoko na kuntangatila kujhema, peniya ajhakwakema bhabholwa na akanawela, ajhakwakamua kwabhe kongo abhii mu ughome. ");
INSERT INTO dne_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na malobhe ghanga ghajhakuchobhela mu muche ghoha gwa ku Yopa, na bhando bha mahele bhajhakunyeketela Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petile ajhakutama machiko ghamahele kwenio ku Yopa kwa punde jhumo jwatenginicha ilebhe ya mambendela, liina lyake Simone. ");
INSERT INTO dne_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pakibha na mundo kwenio ku Kaisaliya liina lyake Kolineliyo. Jwenio akibha nkolongwa jwa lilongo lya akakomana ngondo lilikemitwa, “Lilongo lya Italiya.” ");
INSERT INTO dne_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jwenio akibha mundo jwaumbone, na jwenio pamonga na akalongo mundo bhatembekiya hake Chapanga. Ateila ghamahele kwa kwatangatila akahocho bha Akayahude, na jwenio akibha anyopita hake Chapanga machiko ghoha. ");
INSERT INTO dne_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lichiko limo, chaa ticha jha muhe, ajhakulola mu uloto. Ntumiche jwa kunane kwa Chapanga akijhingila kwa jwenio na kunobholela, “Kolineliyo!” ");
INSERT INTO dne_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kolineliyo ajhakupihikiya miho kongo atehila kujhoghopa, ajhakunkonya, “Bhambo nike?” Ntumiche jwa kunane kwa Chapanga jhola ajhakujhanguu, “Chapanga ahalalilwe na kujhopa kwino na chimwatangatila akahocho hilu nawejhe. ");
INSERT INTO dne_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Bhahe, matume bhando bhajhende ku Yopa bhakankeme mundo jhumo liina lyake Simone na kwa liina lenge Petile. ");
INSERT INTO dne_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jwenio abhii ukajha kwa Simone, punde jwatengenecha ilebhe ya mambendela, nyumba jhake ibhii mupele jha mbwane.” ");
INSERT INTO dne_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jhola ntumiche jwa Chapanga palongila na Kolineliyo ajhakubhoka, Kolineliyo ajhakwakema bhando bhabhele bhakajhake na jhonge jhumo jwa nkomana ngondo gwake jwahengelake jwenio Kolineliyo na jwakibha na kiholo hake na Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Peniya ajhakwalobholela mambu ghoha ghughapitile, na ajhakwatuma ku Yopa. ");
INSERT INTO dne_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kilabho jhake, bhando bhala bhatato pubhabhandikila kuhika ku Yopa, muhe Petile ajhakuhobhokela padale kunyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Na jwenio ijhakumina njala, na ajhakupala chakulyegha. Pubhakibha mukulenganikiya chakulyegha, uloto ujhakuhikilila. ");
INSERT INTO dne_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Awena kunane kwa Chapanga kudindwike, na kilebhe chimo ngita ngholole nkolongwa, ukibha uhelilwe ade pahe, ikamwilwe muimbokotole yoha ncheche ya nnema. ");
INSERT INTO dne_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na nkate jhake mukibha na inyama yoha ibhii na makongono ncheche na inyama ikwabha na ijhune. ");
INSERT INTO dne_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Peniya ajhakulijhowa lilobhe lilinobholila, “Petile, jhema, nchinje ulyeghe!” ");
INSERT INTO dne_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nambo Petile ajhakujhanguu, “Nahijhe Bhambo! Nenga mbahite ndeka kilebhe chochoha chikibhii kihako, hilu chochoha changajheketelwa palonge jha Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Na lilobhe lela lijhakubhujhila kabhele lilongila, “Ilebhe yajheluwiye Chapanga kuikema ndeka ihako.” ");
INSERT INTO dne_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na mambu gheniya ghakatendike patato, peniya ngobho yela ijhakubhujhichwa kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petile pajhendilila kukangacha mana jha uloto, ajhakukikonya mana jha uloto gwenio, papa peniya bhando bhala bhakatumitwe na Kolineliyo pibhaimanyita nyumba jha Simone bhajhakujhenda ade pa nnyango. ");
INSERT INTO dne_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Bhajhakukema kanonoha, “Bho, abhii nghene mombone liina lyake Simone Petile?” ");
INSERT INTO dne_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petile akibha amela mukuwacha mana jha uloto ghola, na Uhuke gwa Chapanga ujhakunnobholela, “Jhokanikiya! Bhando bhatato bhabhii pamba bhinpalaha mwenga. ");
INSERT INTO dne_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Bhahe, jhimka na huluka pahe nkotoka kubhehe na kiholo kujhenda nabho pamonga, nenga ndi natumite.” ");
INSERT INTO dne_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Bhahe, Petile ajhakuhuluka pahe na kwalobholela bhando bhala, “Ndi nenga jwambaliya. Nike chiumbalikiya?” ");
INSERT INTO dne_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Na bhene bhajhakujhanguu, “Nkolongwa Kolineliyo ndi mundo jwaumbone na jwanyopa Chapanga, na jwenio ajheketilwa na Akayahude bhoha atutumite. Jwenio akalalikwe na ntumiche jwa kunane kwa Chapanga jwa nyahinyahi anyokanikiye chimipala kulonge.” ");
INSERT INTO dne_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peniya Petile ajhakwakemela nkate, na kwa kwalobholela bhatame mwenio kilo jhela. Kilabho jhake Petile ajhakutumbu mwanja pamonga nabho. Na bhando bhange bhibhajheketii Kilichitu bhubhatamita ku Yopa bhajhakulongohana pamonga. ");
INSERT INTO dne_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na lichiko lya ubhele bhajhakuhika ku muche gwa ku Kaisaliya. Kolineliyo atehila kwalendelela pamonga na akalukolo bhake na akakoche mundo bhakalalike. ");
INSERT INTO dne_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petile pajhingila nkate jha nyumba, Kolineliyo ajhakujhenda kumpokela, ajhakutama makilikite na kulita ade pahe pu kunyinamila. ");
INSERT INTO dne_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nambo Petile ajhakunyinula Kolineliyo na kunobholela, “Jhema, nenga na mundo ngita mwenga.” ");
INSERT INTO dne_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Petile ajhakujhingila nkate kongo abhii mumalongecho na Kolineliyo, na nkate mola bhajhakwakolela bhando bhamahele bhatamite. ");
INSERT INTO dne_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ajhakwalobholela, “Mangota chakaka ngita Malaghalikilo gha dine ikanakiye kwa Uyahude kubhehe pamonga na mundo jwa kilambo chenge. Nambo Chapanga anangiye ngotoka kunwachila kubhehe mundo jhojhoha jwangajheketelwa palonge jha Chapanga hilu kumwona nhako. ");
INSERT INTO dne_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kwa nhwalo gwenio, pungemita nikahikite changa kiholo, bho, nikonyengane kilebhe ghane chiungemila?” ");
INSERT INTO dne_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kolineliyo ajhakujhanguu, “Machiko matato unyuma, nenga punikibha mukunyopa Chapanga nkate mwa nyumba jhango chaa ticha. Papalapala nyakumona mundo ahwalite ngobho jhing'anyime ajhemite palonge jhango, ");
INSERT INTO dne_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ajhakunobholela, ‘Kolineliyo, kujhopa kwino na chadaka hino Chapanga ajheketile kwa bhando akahocho. ");
INSERT INTO dne_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Bhahe, matume bhando bhajhende ku Yopa bhakankeme mundo jhumo liina lyake Simone kwa liina lenge Petile. Na jwenio abhii ukajha kwa Simone ntengenecha ilebhe ya mambendela pahina jha mbwane.’ ");
INSERT INTO dne_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nakatumite bhando kwino, na mwenga ntei mbone kuhika. Ngohe, twenga twabhoha tubhii pamba palonge jha Bhambo Chapanga kujhokanikiya mambu ghoha ghatumite mutulobholele.” ");
INSERT INTO dne_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Bhahe, Petile ajhakutumbu kulonge, “Ngohe manyite chakaka Chapanga akwetii jhe ubaghuche, ");
INSERT INTO dne_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mundo jwa kilambo chochoha jwantembekeya Chapanga na kuhenga ghughabhii tela, chapokelelwa na jwenio. ");
INSERT INTO dne_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ghanga ndi malobhe gha Chapanga ghapelika kwa bhando bhu ku Ichilahele, atangicha Malobhe gha Mbone ghighaleta uteeke kwa ndela jha Yecho Kilichitu, ndi Bhambo jwa bhando bhoha. ");
INSERT INTO dne_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mangota umanya mambu ghoha ghighakapitile ku kilambo cha ku Yudeya jhoha, ghatumbulila ku Galilaya puupetita ubaticho gwa Yohane. ");
INSERT INTO dne_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Helahela mangota umanye Chapanga paanhagwila Yecho jwa ku Nachalete na Uhuke gwa Chapanga na makakala. Na jwenio akapetite kila chehemo, atehila ghambone na kwalamicha bhando bhoha bhubhabhiii pahe jha Limbembela. Ghatendike gheniya nhwalo Chapanga akibha pamonga na jwenio. ");
INSERT INTO dne_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Na twenga tukalolite mambu gheniya ghatehila Yecho ku kilambo cha Akayahude na ku Yeluchalemo. Na bhajhakunkoma kwa kumamba panane jha nchalaba, ");
INSERT INTO dne_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","nambo Chapanga ajhakuyokecha kuhumii kumambe lichiko lya utato na kuntenda abhonekane, ");
INSERT INTO dne_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","abhonikina chi kwa bhando bhoha, hilu kwa bhando bhala bhubhahaghulilwe na Chapanga kubhehe bhaghawene na kulonge. Ndi twenga bhutulila na kunywegha pamonga na jwenio pala payokita kuhumii mukuwegha. ");
INSERT INTO dne_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na atulaghalikiye kutangacha Malobhe gha Mbone kwa bhando bhoha na kwalobholela kubhehe jwenio ndi jwahaghulilwe na Chapanga kubhehe jwakuhadabula bhando bhubhabhiii na ughome na bhala bhibhawile. ");
INSERT INTO dne_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Milondole bhoha bha Chapanga bhalongila mambu gha Yecho kubhehe jwampokela nalekekewa uhakaho gwake ghoha kwa likakala lya liina lyake.” ");
INSERT INTO dne_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petile pajhendilila kulonge malobhe gheniya, Uhuke gwa Chapanga ujhakuhika panane jha bhoha bhibhajhokanikiya malobhe gheniya. ");
INSERT INTO dne_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Na bhala bhabholwa bha Kiyahude bhibhahikita pamonga na Petile kuhumii ku Yopa bhajhakukangacha hake kulola Chapanga abhapela bhoha hupo jha Uhuke gwa Chapanga ata kwa bhando bha ilambo henge. ");
INSERT INTO dne_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Nhwalo bhajhohina bhalongila kwa lugha yono bhanumbalila Chapanga. Bhahe, Petile ajhakulonge, ");
INSERT INTO dne_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ndi ghane jwahoto kwakanakiya bhando bhamba bhibhapokii Uhuke gwa Chapanga ngita twenga, ghane natenda bhamba bhakoto kubatichwa kwa mache?” ");
INSERT INTO dne_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Bhahe, ajhakwalobholela bhabatichwe kwa liina lya Yecho Kilichitu. Na bhajhakunyopa Petile atame papa pito machiko ghandina. ");
INSERT INTO dne_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bhahe, akatenga na akalongo bhubhakibha ku Yudeya bhakajhohine bhando bha ilambo henge bhapokii Lilobhe lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na Petile pabhujhita ku Yeluchalemo, bhabholwa bhala bha Kiyahude bhibhachokolikiya bhando bhange Akayahude bhatehila kutaungana kujhingii jando, ");
INSERT INTO dne_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","bhalongila, “Mukibha maghene nkate munyumba jha bhando bhangajhingii jando na mwenga mukalinabho pamonga” ");
INSERT INTO dne_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Peniya Petile ajhakwalobholela mambu ghighatendika hotuhotu kuhumii makacho. ");
INSERT INTO dne_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Alongila, “Nenga punikibha mukunyopa Chapanga ku muche gwa ku Yopa nyakubhona uloto. Monita kilebhe ngita ngholole nkolongwa ukahuluchwa kuhumii kunane kwa Chapanga ikamwilwe malombolo ghoha ncheche, ijhakubhekwa pahina jhango. ");
INSERT INTO dne_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Puningukiya kwa uchakaka nkate jhake, nyakubhona inyama ibhii na makongono ncheche, inyama ikolekwa na inyama ya kwanyahe na ijhune. ");
INSERT INTO dne_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kabhele nyakujhoha lilobhe lilongela, ‘Petile, jhema, nchinje ulyeghe.’ ");
INSERT INTO dne_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nambo nyakujhanguu, ‘Nahi jhe Bhambo! Nyakii jhe kilebhe changajheketelwa palonge jha Chapanga chikibhii kihako pannomo gwango.’ ");
INSERT INTO dne_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Na lilobhe lela lijhakujhokanikika kabhele kuhumi kunane kwa Chapanga lilongila, ‘Ilebhe yela yatei Chapanga kubhehe ijheketelwe, kone kibhehe kikoto kujheketelwa kubhehe kihalanao.’ ");
INSERT INTO dne_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Bhahe, ghanga ghakatendike patato, na ilebhe yela ijhakubhujhichwa kabhele kwihiumita kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Papalapala bhando bhatato bhibhakatumitwe kwa nenga bhahumila ku muche gwaku Kaisaliya bhajhakuhika pa nyumba jhindamita. ");
INSERT INTO dne_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Uhuke gwa Chapanga ajhakunnobholela nyende nabho changakiholo. Na bhamba akalongo chita, tukalongohine na nenga kujhenda ku Kaisaliya na kujhingii munyumba jha Kolonelo. ");
INSERT INTO dne_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Na jwenio ajhakutulobholela chamonita ntumiche jwa kunane kwa Chapanga ajhemite nkate jha nyumba jhake na kunnobholela, ‘Muntume mundo ajhende ku Yopa akankeme Simone, kwa liina lenge Petile. ");
INSERT INTO dne_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Jwenio ajhakutulobholela mambu gha kuhenga mwenga pamonga na bhando bha nyumba jhino nabhaghomboka.’ ");
INSERT INTO dne_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nenga pundumbwila kulonge, Uhuke gwa Chapanga ujhakwahulukila panane jhabhe ngita putuhulukila twenga. ");
INSERT INTO dne_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Peniya nyakukomboka malobhe ghanga Bhambo ghalongila, ‘Yohane ajhakwabaticha kwa mache, nambo mangota chabaticha kwa Uhuke gwa Chapanga.’ ");
INSERT INTO dne_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bhahe, anda Chapanga abhapeke bhando hupo jhela jha Uhuke gwa Chapanga atupekii na twenga putunyeketile Bhambo Yecho Kilichitu, ne na ghane ade nnyighe kumambala Chapanga?” ");
INSERT INTO dne_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pubhajhohina gheniya, bhajhakuleka kutaungana, na kunnomba Chapanga, bhalongila, “Chapanga abhapeki pwache bhando bha ilambo henge kujheketela na kuuleka uhakaho gwabhe bhabhehe na ughome gwa machiko ghoha gwangapeta!” ");
INSERT INTO dne_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mang'ahe ghighapitila kwa machiko ghakomitwa Sitefano, bhabholwa bhajhakupechengana. Na bhange bhajhakujhenda ade ku kilambo cha ku Foinike na Kipulo na kuhika ku muche gwa ku Antiyokiya. Na kola bhatangicha malobhe ghala gha Chapanga, kwa Akayahude kanjika chabhe. ");
INSERT INTO dne_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nambo bhabholwa bhange, bhibhaumila ku Kipulo na kilambo cha ku Kilene, bhakajhenda ku Antiyokiya. Na bhene bhajhakutumbu kutangacha Malobhe gha Mbone gha Bhambo Yecho. ");
INSERT INTO dne_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Likakala lya Bhambo likibha pamonga bheniya na bhando bhamahele bhajhakujhonjekeka bhubhanyeketila na kughalambukila Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Bhando bhibhanyeketii Kilichitu bha ku Yeluchalemo pubhajhohina malobhe gheniya, bhajhakuntuma Banaba ajhende ku Antiyokiya. ");
INSERT INTO dne_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Na jwenio pahikita kwenio na kulola Chapanga chabhapekii mota bhando bhala, ajhakuhangana na kwakangamalicha, bhatame kwa mwojho ghoha kwa Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banaba akibha mundo jwaumbone, jwatwelii Uhuke gwa Chapanga na kihobholelo kikolongwa. Bhando twe bhajhakujhonjekeka kwa Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Bhahe, Banaba ajhakubhoka kwenio na kujhenda ku Taliso kumpalaha Saule. ");
INSERT INTO dne_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Na jwenio pibhapatita, ajhakuneta ku Antiyokiya. Na bhoha bhabhele bhajhakutama na lilongo lela kwa chaka choha bhalibholita lilongo lya bhando bhibhannyeketii Kilichitu. Na kwenio ku Antiyokiya pubhatumbwila bhabholwa bha Yecho kukemwa Akakilichitu. ");
INSERT INTO dne_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Mu machiko ghagha gheniya, milondole bha Chapanga bhakahikite ku Antiyokiya kuhumii ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Bhahe, jhumo jwabhe, jwakemitwa Agabo ajhakujhema, na kwa ukindendeke gwa Uhuke gwa Chapanga ajhakuyekulilwa nakupitila na njala ngolongwa pannema ghoha. Nahipitila machiko gha ulongoche gwa Kilaudiyo. ");
INSERT INTO dne_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bhabholwa bhajhakulaghana kilebhe chochoha chibhakwete kwatangatila bhabholwa bhajhabhe bhubhatamita ku muche gwa ku Yudeya. ");
INSERT INTO dne_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bhahe, bhajhakwakamu Banaba na Saule ilebhe yabhe, na bhene bhajhakuitola kwa akanahota bha bhando bhibhanyeketii Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Machiko ghagha munahota nkolongwa Helode patumbwila kwang'aha bhando bhibhannyeketii Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ajhakunkoma kwa libhagho Yakobu, nnongo mundo Yohane. ");
INSERT INTO dne_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Bhahe, pajhohina lijhambu lela Akayahude bhalihekilila, panyendilila Petile na kunkamula. Mambu gheniya ghatendika pu unyagho gwa mabumunda ghangahechulila ngedule. ");
INSERT INTO dne_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pibhankamula Petile, na kuntabha mukipungo, bhajhakumeka pahe jha ulonda gwa akakomana ngondo ncheche. Helode akahobholile kumpiya pa bhando pu unyagho gwa Pachaka. ");
INSERT INTO dne_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bhahe, Petile ajhakutama mukipungo, nambo bhando bhibhanyeketii Kilichitu bhakajhendelile kunyope kwa Chapanga changa kutotokelela. ");
INSERT INTO dne_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Uhiko ghola, kabula jha lichiko lela Helode laheghili kumpiya Petile pa bhando, Petile akibha mulugwenio pakate jha akakomana ngondo bhabhele. Na kongo akongwitwe minyololo mibhele, na akakomana ngondo bhakelwiya pa nnyango nkolongwa gwa kipungo. ");
INSERT INTO dne_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Papalapala ntumiche jwa kunane kwa Bhambo ajhakupitila pahina na jwenio na lilangamule ndaa lijhakubhehe mu chumbi chela. Ntumiche jwa Chapanga ajhakumpapaa mu lubhaho lwa Petile na kunnyimua, ajhakunobholela, “Jhema kajhombe!” Na minyololo jhela ijhakunopokana na kupone pahe. ");
INSERT INTO dne_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Peniya ntumiche jwa Chapanga ajhakunobholela, “Wala luhunga lwino na maghubache ghino.” Petile ajhakuhenga hele, na jwenio ntumiche jwa Chapanga ajhakunobholela kabhele, “Wala likanjo lino na ungengame nenga.” ");
INSERT INTO dne_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petile ajhakunkengama ade panja jha kipungo. Nambo akamanyite jhe mambu gheniya ghakateilwe na jwenio ntumiche jwa Chapanga ghakibha gha chakaka, jwenio ahambwika mang'amo ng'amo. ");
INSERT INTO dne_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bhahe, bhajhakutumbuu kupeta likunde limo lya akakomana ngondo ade lyuubhele, na kuhika panyango nkolongwa gwa choma gwa kujhingilii nkate jha muche. Pubhahikita peniya nnyango gwenio ujhakudinduka gwene palonge jhabhe, na bhene bhajhakupita panja na kutyanga ndela jhimo na ntumiche jwa Chapanga jhola. Papalapala ntumiche jwa Chapanga ajhakunneka Petile kanjika chake ajhende. ");
INSERT INTO dne_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Petile pabangatwika mambu ghughapitile ndi gha uchakaka, ajhakulonge, “Ngohe manyite chakaka Bhambo antumite ntumiche gwake kung'ombola mu mabhoko gha Helode na mu mambu ghoha gha Akayahude bhibhahobholila ghapitile kwa nenga.” ");
INSERT INTO dne_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pabangatwika mambu gheniya ghighatendike, ajhakujhenda kwa Maliya, majhe mundo Yohane jwakemitwa Maluku. Mwenio bhakibha bhando bhamahele bhakonganike bhanyopita Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petile ajhakukema pa nnyango gwa panja, ntumiche jhumo mwikeghe jwakemitwa Loda ajhakuhika pa nnyango kujheketela. ");
INSERT INTO dne_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na nchikana jhola pamanyita lilobhe lela likibha lya Petile, ajhakuhangana hake na kujhebhwa kudindula litangala na kubhujha kabhele nkate kwalobholela Petile ajhemite panja. ");
INSERT INTO dne_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Na bhene bhajhakunobholela, “Mwe mwilwalwa ngholoka!” Nambo pachochita kulonge chakaka abhii panja. Bhahe, bhajhakulonge, “Jwenio ndi ntumiche jwa kunane kwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petile pajhendilila kukong'onda pa nnyango, na pubhanyogholile nnyango bhajhakumona, na kunkangacha hake. ");
INSERT INTO dne_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Na jwenio Petile ajhakwalobholela bhatame nuu, palobholila Bhambo champihite mukipungo. Ajhakwalobholela kabhele, “Mwanobholele Yakobu na akalongo bhange malobhe gheniya.” Peniya Petile ajhakubhoka na kujhenda chehemo jhenge. ");
INSERT INTO dne_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pukuchila, akakomana ngondo bhajhakubhehe na kiholo kikolongwa kumwojho gwabhe. Bhajhakukonyana, kilebhe ghane chikinkolile Petile. ");
INSERT INTO dne_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helode ajhakwalobholela bhatende mmengo, nambo bhakamwe jhe Petile. Peniya ajhakulonge bhakomwe akalonda bhala, Helode ajhakubhoka ku Yudeya na kujhenda ku muche gwa ku Kaisaliya na kutama kwenio. ");
INSERT INTO dne_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Helode akayomichwe hake na bhando bha muche gwa ku Tilo na ku Sidone. Nambo bhajhakunyendelela kwa lilongo kukonganika nako. Bhahe, bhajhakutumbuu kulonge nako Bulasito, jwakibha nnonda nkolongwa jwa nyumba jha munahota nkolongwa. Peniya bhajhakujhopa lilaghano lya uteeke kwa munahota Helode, nhwalo kilambo chabhe chikihobholela kilambo cha munahota jwenio Helode kwa kutangatilwa yakulyegha. ");
INSERT INTO dne_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bhahe, lichiko limo lilihaghulilwe, Helode ajhakuwala ngobho yake ya unahota, na kutama pakigoda chake cha unahota, na kulonge na bhando. ");
INSERT INTO dne_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na bhene bhando bhajhakuchobhela bhalongila, “Chakaka jhenje ndi lilobhe lya Chapanga, na lya mundo jhe!” ");
INSERT INTO dne_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Papalapala ntumiche jwa Bhambo jwa kunane kwa Chapanga ajhakugwiya pahe jha Helode, nhwalo akampekihejhe Chapanga chipwa yenio. Peniya Helode ajhakukamulwa na njwina ajhakuwegha. ");
INSERT INTO dne_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nambo Lilobhe lya Chapanga lijhakujhendelela kuchobhela na kukola. ");
INSERT INTO dne_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banaba na Saule pubhajhomolela lihengo lyabhe, bhajhakubhoka kabhele ku Yeluchalemo, bhajhakulongohana pamonga na Yohane jwakemitwa Maluku. ");
INSERT INTO dne_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kwa bhando bhibhannyeketii Kilichitu bha ku Antiyokiya kukibha na milondole na bhabhola. Bhando bhamba bhakibha Banaba na Simone jwakemitwa Mpile, Lusiya jwa Kilene, Manaene jwalelwitwa na munahota Helode na Saule. ");
INSERT INTO dne_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lichiko limo pubhakibha mukunyopa Chapanga, kongo bhapungite, Uhuke gwa Chapanga ajhakulonge, “Mahaghule Banaba na Saule kwa lihengo linakemile.” ");
INSERT INTO dne_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bhahe, bhajhakupunga, na kujhopa peniya bhajhakwabhekela mabhoko panane jhabhe na kutuma bhajhende. ");
INSERT INTO dne_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bhahe, Banaba na Saule bhajhakujhenda ade ku Seleukiya kongo bhalongwichwa na Uhuke gwa Chapanga kwenio bhajhakujhingila mumele na kujhenda ade ku kilendela cha ku Kipulo. ");
INSERT INTO dne_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na bhene pubhahikita kumuche gwa Salami, bhajhakutangacha Lilobhe lya Chapanga munyumba jha kukonganikii Akayahude. Yohane jwakemitwa Maluku jwakibha utangatilo gwabhe. ");
INSERT INTO dne_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bhajhakutyanga mukilendela choha, bhajhakuhika kumuche gwa ku Pafo. Kola bhajhakukongana na mundo jhumo Mu yahude nhwabhe jwakitehi nnondole jwa uwange jwa Chapanga, liina lyake Balayecho. ");
INSERT INTO dne_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jwenio akibha nkoche jwa nkolongwa jwa kilendela chela jwakemitwa Selugiyo Pauli, jwakibha na malango hake, ajhakwakema Banaba na Saule bhajhende kwa jwenio nhwalo apata kujhokanikiya lilobhe lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nambo nhabhe jhola ngita chibhinkema kwa Kigilike Elima, ajhakujhigha kuhibhilikiya nkolongwa jwa kilendela chela akotoka kujhokanikiya lilobhe lya Chapanga na kubhehe Nkilichitu. ");
INSERT INTO dne_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Bhahe, Saule jwakemitwa Pauli, atwelilwe na Uhuke gwa Chapanga, ajhakupikiya miho nduu nhwabhe jwenio, ");
INSERT INTO dne_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","nu kulonge, “Mwenga ndi mwana gwa limbembela na mwakobhowe na uwange nkolongwa! Mwenga mwalikoko kwa kila kilebhe chambone, ntotoke ndeka kughalambula ndela jha Bhambo jha uchakaka kubhehe jha uwange! ");
INSERT INTO dne_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Na ngohe, Bhambo nachwapulwa pyaa, na mwenga miho naghalola jhe, hilu chiuhotola kulola kwa muda.” Papalapala miho ghajhakubhehe ngita ngongobhe na lubhendo kwa jwenio, na jwenio ajhakutumbu kupapaha kumpalaha mundo jwa kunongocha. ");
INSERT INTO dne_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nkolongwa jwa kilendela jhola palolita mambu gheniya ghughapitile ajhakujheketela, ajhakuhechuka kujhokanikiya mabholo gha Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Peniya Pauli na bhajhake bhajhakujhingila mumele, bhajhakubhoka ku muche gwa ku Pafo na kujhenda ku muche gwa ku Peliga ku kilambo cha ku Pamfiliya. Pubhahikita kola Yohane jwakemitwa Maluku ajhakwaleka bhajhake na kubhujha ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nambo bhene bhajhakujhendelela na mwanja kubhoka ku Peliga na kuhika ade ku muche gwa ku Antiyokiya kilambo cha ku Pichidiya. Pulihikita Lichiko lya Kupomolela, bhajhakujhingila munyumba jha kukonganikii Akayahude na kutama mwenio. ");
INSERT INTO dne_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pubhachomita Lilaghalikilo lya Mucha na majhandiko gha milondole, ilongoche ya nyumba jha kukonganikii Akayahude bhajhakutuma mundo na kwalobholela, “Makalongo bhango na akalombo bhito anda nkwete lilobhe lya kwaleke mwojho bhando abha, nnongele.” ");
INSERT INTO dne_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bhahe, Pauli ajhakujhema, ajhakuhatambula lubhoko na kwalobholela bhatame nuu. Patumbwila kulonge, “Unyokanikiye majhango bhu ku Ichilahele, na bhando bha ilambo henge bhumunyopa Chapanga! ");
INSERT INTO dne_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Chapanga jwa kilambo cha bhando bha ku Ichilahele akabhahagwile akahoko bhito, na jwenio ajhakwatenda bhabhehe bhando bhamahele hake pubhakibha bhatamita kuughene mu kilambo cha ku Michile. Na Chapanga ajhakwabhoha kwenio kwa likakala lyake likolongwa, ");
INSERT INTO dne_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ajhakwahimbilila ku njenga kwa muda gwa yaka makome ncheche. ");
INSERT INTO dne_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ajhakughatiniya makunde chaba gha Kanaane ajhakwapekeya bheniya kilambo kibhehe chabhe. ");
INSERT INTO dne_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mambu gheniya ghoha ghakatendike mu yaka ya makome mamiya ncheche na makome nhwano.” “Peniya Chapanga ajhakwapekeya nyomola mihalo jwakwalongocha ade machiko gha nnondole Samwele. ");
INSERT INTO dne_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Bhando bhajhakujhopa bhapelwe munahota nkolongwa. Bhahe, Chapanga ajhakwapekeya Saule, mwana gwa Kishi, jwalikabila lya Benjamine abhehe munahota gwabhe alongoche kwa yaka makome ncheche. ");
INSERT INTO dne_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pubhamohita Saule, Chapanga ajhakummeka Daude kubhehe munahota nkolongwa gwabhe. Na jwenio Chapanga ajhakulonge panane jhake alongila, ‘Nimwene Daude mwana gwa Yese, ndi mundo jhilengana na mwojho gwango. Jhonjo ndi nahenga mambu ghoha ghinipala.’ ");
INSERT INTO dne_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mulubheleko lwa mundo jhonjo, Chapanga ngita chakabhekite lilaghano lyake, abhapelikile bhando bhu ku Ichilahele Nkombola Yecho, ");
INSERT INTO dne_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kabula jha kuhika Yecho ajhakutumbula lihengo, Yohane ajhakwatangachila bhando bhu ku Ichilahele jhoha bhaghalambuke kwa kuuleka uhakaho na kubatichwa. ");
INSERT INTO dne_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Yohane paheghelila kujhomolela lihengo lyake, ajhakulonge bhando, ‘Pimihambuka apa, nenga ndi ghane? Nenga chi jhola jwumonnolela kuhika. Nambo dolekeya jwenio jwahika, ata nenga nitope ndeka kunhula maghubache ghake.’ ” ");
INSERT INTO dne_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Makalongo bhango, mangota bha kibheluko cha Ulahimo na mangota mwenga bhando bha ilambo henge bhumunyopa Chapanga, ndi kwa nhwalo gwa twenga lilobhe hele lya kughombokoka lihikite! ");
INSERT INTO dne_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bhando bha ku Yeluchalemo na bhakolo bhabhe bhakamanyite jhe jwenio Yecho kubhehe Nchengula, hilu majhandiko gha milondole gha Chapanga ghighachomwa kila Lichiko lya Kupomolela. Nambo bhajhakutimicha majhandiko kwa ndela jha kunkoma. ");
INSERT INTO dne_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pakibha jhe na nhwalo gwa kunkoma, nambo bhajhakunyopa Pilatu abhapekiye luhucha lwa kukomwa. ");
INSERT INTO dne_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pubhajhomolela kutimicha ghoha ghighajhandikwe panane jhake, bhajhakunhulua pahe jha nchalaba na kunyelela ku mambe. ");
INSERT INTO dne_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nambo Chapanga akayokiche kuhumi mukuwegha. ");
INSERT INTO dne_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kwa machiko ghamahele ajhakubhonekana kwa bhando bhubhakibha pamo mu mwanja kubhoka ku Galilaya kujhenda ku Yeluchalemo. Ngohe bheniya ndi bhibhalolite na bhubhalongile palonge jha bhando bha ku Ichilahele. ");
INSERT INTO dne_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na twenga tutangacha Lilobhe lya Mbone kwino, lela Chapanga lalaghila kwa akahoko bhito, ");
INSERT INTO dne_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","atimiche kwa nhwalo gwa twenga na ibheluko hito, kwa kuyokecha Yecho ngita majhandiko ghanga gha Zabule jhubhele jhighalonge, ‘Mwenga ndi ma mwanango, deleno nenga mmi tate gwino.’ ");
INSERT INTO dne_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Panane jha kuyokechwa kwa Yecho, akotoko kuhighalika koko na kubhola, Chapanga alongila, ‘Chakaka chanimpela mota ya nyahinyahi, ya ninnaghalikiye Daude.’ ");
INSERT INTO dne_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Chakaka, ijhandikwe kabhele Mu majhandiko ghange gha Zabule, ‘Namunneke jhe ntumiche gwino jwa nyahinyahi abhole.’ ” ");
INSERT INTO dne_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Nambo Daude pajhomolela kuhenga lihengo lya Chapanga mu kibheluko, ajhakuwegha na kuyelelwa kumambe pahina na akahoko mundo, na yegha jhake ijhakubhola. ");
INSERT INTO dne_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nambo jhola jwayokichwe na Chapanga, akabhola jhe. ");
INSERT INTO dne_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bhahe, kwa gheniya umanye makalongo bhango, chakaka kwa ndela jha mundo jhonjo, lijhambu lya lilobhe lya kulekekewa uhakaho litangachwa kwino. ");
INSERT INTO dne_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Na mundo jwanyeketela Yecho alekekewa uhakaho ghoha, lijhambu ngalihotwilike ndeka kubhohekewa uhakaho kwa ndela jha kukamula lilaghalikilo lya Mucha. ");
INSERT INTO dne_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bhahe, mu kilolekeye mbone, malobhe ghighalangilwa na milondole bha Chapanga ghakotoka kumpitila mangota, ");
INSERT INTO dne_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Unyokanikiye mangota bhimiloka! Nkangache uhobholele! Nhwalo chinihenga ngohe mu machiko ghino, cha nihenga kilebhe changakajheketela, ata mundo ahike kunobholela mangota, chanyekete ndeka!’ ” ");
INSERT INTO dne_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pauli na Banaba pibhapitita nkate jha nyumba jha kukonganikii Akayahude, bhando bhala bhajhakwajhopa bhahike lichiko lenge lya Kupomolela bhalongele maha panane jha mambu gheniya. ");
INSERT INTO dne_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pubhajhomolila malongeche ghabhe, Akayahude bhamahele na bhando bha ilambo henge bhubhakajhingile mu dine jha Kiyahude, bhajhakwakengama Pauli na Banaba. Na bhene bhabhele bhajhakulonge nabho kwa kwakangamalicha miojho na bhajhendelele kutama muumbone gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pulihikita lichiko lenge lya Kupomolela, bhando bhamahele bha muche ghola bhakakonganike kunyokanikiya lilobhe lya Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nambo Akayahude pubhalilolikiya lilongo lya bhando, bhajhakubhehe na wiho hake, na bhene bhajhakupucha malobhe ghighalongilwa na Pauli na kunigha. ");
INSERT INTO dne_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Helahela Pauli na Banaba bhajhakwalobholela changa kiholo, bhalongila, “Tuchokolikiya lilobhe lya Chapanga linhikilile hote mangota. Nambo nhwalo ntei kulikanangana na kukibhona mutope jhe kubhehe na ughome gwa machiko ghoha ghangapeta, bhahe, tuneka na kuhenga lihengo mu ilambo henge. ");
INSERT INTO dne_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Nhwalo Bhambo atulaghalikiye naha, ‘Nimekite kubhehe lilangamule lya ilambo, mwalete bhando bha nnema ghoha ughombokeko.’ ” ");
INSERT INTO dne_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bhando bha ilambo henge pubhajhohina malobhe gheniya bhajhakuhanganila, bhajhakulumbulila lilobhe lya Chapanga, na bhala bhoha bhibhahaghulilwe kupokela ughome gwa machiko ghoha ghangapeta, bhajhakujheketela. ");
INSERT INTO dne_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Lilobhe lya Bhambo lijhakuchobhela mbegha mu ilambo yoha. ");
INSERT INTO dne_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nambo Akayahude bhajhakwakokelekeya akakeghe bhibhannyeketii bhibhakibha na ilebhe mbwe na helahela bhubhakibha na kiholo cha Chapanga, na akanalome ilongoche bha muche ghola, bhajhakutumbu kwang'aha Pauli na Banaba na kwabhenga bhabhoke pa bomane jhabhe. ");
INSERT INTO dne_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bhahe, akatenga bhala bhajhakupyata lutukunda lulubhii mumagholo ngita nhwilo, na bhajhakubhoka nu kujhenda ku muche gwa ku Ikonilo. ");
INSERT INTO dne_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Na bhibhannyeketii bhubhakibha kwenio ku Antiyokiya bhatweli luhangano pamonga na Uhuke gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pauli na Banaba pubhahikita ku muche gwa ku Ikonilo, bhajhakujhingila munyumba jha kukonganikii Akayahude. Bhajhakutangacha kwa uhotolo gwa Lilobhe lya Chapanga na lilongo lya Akayahude na Akagilike ngabhajheketela. ");
INSERT INTO dne_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nambo Akayahude bhangajheketela bhajhakwakokolekeya bhando bha ilambo henge na kwapela mawacho ghanganandela bhakanile bhando bha ilambo henge. ");
INSERT INTO dne_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pauli na Banaba bhajhakutama ku Ikonilo kwa machiko ghamahele. Bhajhakulonge changa kiholo panane jha Bhambo, Chapanga jwenio ajhakukilangiya kwa uchakaka panane jha umbone gwake kwa kwatenda kuhenga nginyililo na ikangacho. ");
INSERT INTO dne_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Papalapala bhando bha muche ghola bhajhakupechengana, lilongo limo lyakengimila Akayahude na lenge lyakengima akatenga bhala. ");
INSERT INTO dne_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Peniya Akayahude na bhando bha ilambo henge pamonga na ilongoche yabhe, bhajhakutenda nginyika jha kwakoma akatenga kwa kong'onda maghanga. ");
INSERT INTO dne_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pauli na Banaba pubhamanyita gheniya, bhajhakubhoka na kubhutukii ku muche gwa ku Lusita na ku Delibe nkate jha mu bomane jha ku Likuniya na chehemo jha pahina jhake, ");
INSERT INTO dne_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kwenio bhajhendilila kutangacha Lilobhe lya Mbone. ");
INSERT INTO dne_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kwenio ku Lusta kukibha na mundo jhumo jwalemile kuhumi mukubhelukwa. Mundo jwenio akahotwi ndeka kutyanga. ");
INSERT INTO dne_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Jwenio akibha anyokanikiya Pauli palongila. Na Pauli ajhakubhehe tolatola na mundo jhola, ajhakubhona kihobholelo cha mundo jhola kihoto kulamichwa na Chapanga, ");
INSERT INTO dne_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ajhakulonge lilobhe likolongwa, “Jhema kwa makongono ghino!” Mundo jhola ajhakujhema na kutumbuu kutyanga. ");
INSERT INTO dne_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lilongo lya bhando pubhalolita ghatehi Pauli, bhajhakulonge kwa lugha jhabhe jha Kilikaoniya, “Mahoka ghahikite ghibhonekana ngita mundo!” ");
INSERT INTO dne_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banaba ajhakuntinwa liina lya Zelu, na Pauli jwalongila mambu gheniya ajhakukemwa Helume. ");
INSERT INTO dne_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na jwenio mpiya litambiko jwa Chapanga jwa Nyumba jha Chapanga jha Zelu, ajhakuneta lipongo lya ng'ombi na malobha palonge jha nnyango nkolongwa. Nhwalo jwenio na lilongo lya bhando bhapata kwatambikila akatenga bhala. ");
INSERT INTO dne_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nambo Pauli na Banaba pubhajhohina gheniya, bhajhakujwepula ngobho, bhajhakujhingila pakate jha lilongo lya bhando, nu kulonge, ");
INSERT INTO dne_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Makalongo, nhwalo ghane muhenga mambu ngita ghanga? Twenga ndi bhando ngita mangota, na tubhii pamba kutangachii mangota Lilobhe lya Mbone, muileke inyagho hino ya jhajhe na mung'alambukile Chapanga jwabhii na ughome, jwenio ndi jwapangina kunane kwa Chapanga na nnema, mbwane na ilebhe yoha ibhii mwenio. ");
INSERT INTO dne_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Makacho Chapanga ajhakwaleka bhando bha ilambo yoha bhakengame kila jhumo chikipala. ");
INSERT INTO dne_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Helahela Chapanga akalekite ndeka kukilangiya kwa ndela jha kuhenga ilebhe ya umbone. Abhaletila hula kuhumi kunane kwa Chapanga, abhapekiya mahuno kwa machiko ghake, na papa peniya jwenio lupekeya chakulyegha na kuitwelila miojho jhino uhangano.” ");
INSERT INTO dne_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pamonga na akatenga bhala kulonge malobhe gheniya ghoha, bhakahotwi ndeka kwakanakiya lilongo lya bhando bhakoto kutambikilwa. ");
INSERT INTO dne_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nambo Akayahude bhange bhajhakuhika kubhoka ku muche gwa ku Antiyokiya na ku Ikonilo. Bhajhakukihangalana na bhando bhala pamonga. Bhajhakumbula Pauli maghanga na kunhuta kindalaha ade panja jha muche, bhahambwika awile. ");
INSERT INTO dne_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nambo bhabholwa pubhakonganika na kunolekeya, ajhakujhimuka na kubhujha nkate jha muche kabhele. Kilabho jhake Pauli pamonga na Banaba bhajhakujhenda ku muche gwa ku Delibe. ");
INSERT INTO dne_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pauli na Banaba kutangacha Malobhe gha Mbone ku muche gwa ku Delibe na kwaponga bhabholwa bhamahele, bhajhakubhujha ku muche gwa ku Antiyokiya kupete ku Lusita na ku Ikonilo na Pisidiya. ");
INSERT INTO dne_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kola bhajhakwalinganikiya bhabholwa na kwakangamalicha kwa likakala bhatame mu kihobholelo kongo bhalobholila, “Twabhoha natupete mu mang'ahe twe kabula jha kujhingii mu unahota nkolongwa gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bhajhakwahaghula akahoko bha bhando bhibhannyeketii Kilichitu. Nhwalo gwa kupunga kulyegha na kunnyopa Chapanga, bhajhakwabheka palonge jha Bhambo Chapanga jhubhahobholile. ");
INSERT INTO dne_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pubhapetila ku kilambo cha ku Pisidiya na kuhika ku kilambo cha ku Pamfiliya. ");
INSERT INTO dne_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pubhajhomolila kutangacha Lilobhe lya Chapanga kwa bhando bha muche gwa ku Peliga, bhajhakujhenda ku muche gwa ku Ataliya. ");
INSERT INTO dne_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pubhabhokita kwenio bhajhakujhingila mumele kubhujha ku Antiyokiya kabula jhake bhakabhekwite pahe jha ulonda gwa umbone gwa Chapanga kwa nhwalo gwa mahengo ghabhe na ngoheno bhajhomolile kuhenga. ");
INSERT INTO dne_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pubhahikita ku Antiyokiya, bhajhakukonganika na bhando bhibhanyeketii Kilichitu na kwalobholela mambu ghoha Chapanga ghahengita pamonga na bhene, na bhando bha ilambo henge chibhajheketile Malobhe gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Na bhene bhajhakutama pamonga na bhibhanyeketii Kilichitu kwa machiko ghamahele. ");
INSERT INTO dne_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bhahe, bhando bhange kuhumi ku Antiokiya kujhenda ku Yudeya, na bhene bhajhakutumbuu kwabhola bhibhajheketile bhala, bhalongila, “Nahotola ndeka kughombokoka nhwalo nnyingii ndeka jando ngita lilaghalikilo lya Mucha chililongela.” ");
INSERT INTO dne_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Lilobhe lende lijhakuleta mataungano hake, Pauli na Banaba kulonge nabho, peniya bhibhajheketile bhala bhakalongile Pauli na Banaba bhajhende ku Yeluchalemo bhakakonye akatenga na ighogholo panane jha lilobhe lyenio. ");
INSERT INTO dne_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Bhahe, bhibhannyeketii Kilichitu bhajhakwapekiya ilebhe kwa nhwalo gwa mwanja, na bhene bhajhakupeta ku kilambo cha ku Foinike na ku Samaliya. Na mwenio bhajhakwalobholela bhando bha ilambo henge chibhampokii Chapanga. Malobhe gheniya ghajhakukongolekeya hake miojho jhabhe. ");
INSERT INTO dne_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pubhahikita ku Yeluchalemo, bhajhakupokelwa na bhando bhubhakajheketile Kilichitu pamonga na akatenga na akanahota, na bhene bhakalobholile mambu ghoha Chapanga ghabhatendile. ");
INSERT INTO dne_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nambo bhibhanyeketii Kilichitu bhange bha kibhogha cha Mapwalichayo bhakajhemite na kulonge, “Bhachokolekeya bhando bha ilambo henge bhajhingii hote jando na ndi bhalikamula Lilaghalikilo lya Mucha.” ");
INSERT INTO dne_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Bhahe, akatenga na akanahota bha bhando bhibhakajheketile Kilichitu bhajhakukonganika kwa kulingukiya lijhambu lyenio. ");
INSERT INTO dne_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pubhakibha mukutaungana, Petile ajhakujhema na kulonge, “Makalongo bhango, umanye Chapanga akanhagwii nenga ndangache Lilobhe lya Mbone kwa bhando bhoha na kwa ilambo henge bhibhanyokanikiya na kunyeketela. ");
INSERT INTO dne_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na jwenio Chapanga amanye chibhawacha bhando bhamba, abhajheketele bhando bha ilambo henge kwa ndela jha kwapekeya Uhuke gwa Chapanga ngita chatupekii twenga. ");
INSERT INTO dne_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Chapanga akwete jhe ubaghuche pakate jha Akayahude na bhangabhehe Akayahude, nhwalo ajhelewiye miojho jhabhe kwa kihobholelo. ");
INSERT INTO dne_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bhahe, nhwalo ghane mipala kunyigha Chapanga kwa kwagheghecha mihigo ata akahoko bhino, ata twabhete tuhoto ndeka kughegha? ");
INSERT INTO dne_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nkoto kubhehe naha, nhwalo twenga ngita bheniya helahela, natughombokoka kwa ndela jha umbone gwa Bhambo Yecho.” ");
INSERT INTO dne_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Bhahe, lilongo lyoha lijhakubhehe nuu kujhokanikiya malobhe gha Pauli na Banaba panane jha ikangacho yoha na nginyililo ya Chapanga yahengita pakate jha bhando bha ilambo henge. ");
INSERT INTO dne_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Na bhene pubhajhomolila kulonge, Yakobu akalongile, “Makalongo bhango, unyokanikiye!” ");
INSERT INTO dne_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simone alongila Chapanga pahengita lihengo na bhando bha ilambo henge, na kwahaghula bhando bhange kubhehe bhake. ");
INSERT INTO dne_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Na malobhe ghanga ghalinginii njwe na ghala gha milondole bha Chapanga, ngita chighajhandikwe mu Majhangiko gha Chapanga ghilonge, ");
INSERT INTO dne_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Anda ghapetite mambu ghanga chamujha kabhele, pa kichimba chela cha munahota nkolongwa Daude, chanenganikiya mahame, ghajheme kabhele. ");
INSERT INTO dne_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Na bhando bhange bhoha bhang'alambukile Bhambo, bhando bha ilambo henge bhabhehe bhando bhango. ");
INSERT INTO dne_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ndi chalongila Bhambo, yatehila mambu ghabhehe mbegha kuhumii makacho. ");
INSERT INTO dne_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakobu pubhajhendilila kulonge, “Ndi kwa nhwalo ghongo, yamaha ndeka kwachumbuwa bhando bhibhanyeketile Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nambo ihalalile kunyandikila kwa kwalobholela ntame kutale na ilebhe ya kutambikila inyagho, mmambale ngongola na nkotoka kulye kinyama chikiwii chenie hilu miyahe jhake. ");
INSERT INTO dne_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mana kuhumii makacho Lilaghalikilo lya Mucha litangichwa na kuchomwa kila Lichiko lya Kupomolela munyumba jha kukonganikii Akayahude.” ");
INSERT INTO dne_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Peniya akatenga na ighogholo, pamonga na bhando bhibhanyeketii Kilichitu bhoha, bhajhakuhaghu bhando bhange kuhumii pakate jha bhene na bhajhende ku Antiyokiya, mwenio akibha Pauli na Banaba. Bhahe, ajhakuhaghulwa Yuda jwakemitwa kwa liina lya Balusaba na Sila bhakibha ilongoche ya bhando bhibhanyeketii Kilichitu, ");
INSERT INTO dne_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","na bhene bhajhakwakamuya baluwa jhela, ijhandikwe naha: “Twenga ndi akatenga na akanahota bha bhando bhibhanyeketii Kilichitu na makalongo bhino, tunyambucha makalongo bhito bhangabhehe Akayahude bha muche gwa ku Antiyokiya na gwa ku Siliya na ku Kilikiya. ");
INSERT INTO dne_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tujhohine bhando bhantindighine kwa malobhe ghabhe, bhajhakwapekeya bhoghohe mimwojho na iholo. Nambo bhatehi naha changalaghalikiya. ");
INSERT INTO dne_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Twenga twahagwii bhando bhange na kwatuma kwino. Bhando bhene bhitwapahile ndi Pauli na Banaba, ");
INSERT INTO dne_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","bhibhajheketii kuwegha kwa kuhenga lihengo lya Bhambo Yecho Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Bhahe, twatuma kwino Yuda na Sila na bhene chibhanobholela chakaka malobhe ghighabhii mwenio. ");
INSERT INTO dne_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nhwalo Uhuke gwa Chapanga atulaghalikiye na twenga tujheketile tukotoka kwatweka mihigho mitopaho kuliku mambu ghanga ghighapalwa, ");
INSERT INTO dne_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nkotoka kulye ilebhe itambikilwe kwa inyagho na nkotoka kunywe miyahe helahela nkoto kulye chikiwii chenie na mmambale ngongola. Nkotoka kunywe miyahe hilu kinyama chikiwii chenie na nkotoka kutenda ngongola. Naibhaha mbone anda ntehi jhe mambu gheniya.” ");
INSERT INTO dne_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bhahe, akatenga bhala pubhatabhika na kujhenda ku Antiyokiya. Bhajhakwakema bhoha bhibhajheketii Kilichitu na kwakamuya baluwa jhela. ");
INSERT INTO dne_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Na bhene pubhaichomita bhajhakuhanganila nhwalo gwa malobhe ghala ghakwaleke mwojho ghighajhandikwe nkate ya baluwa. ");
INSERT INTO dne_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yuda na Sila bhakibha milondole bha Chapanga, bhajhakulonge nabho kwa machaa ghamahele na kwakangamalicha mwojho na kwachenga. ");
INSERT INTO dne_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pubhatamita kwenio kwa machiko, kwa akalongo bha ku Antiyokiya bhajhakwatabhuka na kwalekela uteeke na bhajhakubhujha kwa bhala bhibhatumita. ");
INSERT INTO dne_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nambo Sila ajhakuhighalika koko. ");
INSERT INTO dne_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pauli na Banaba bhajhakuhighalika ku Antiyokiya, bhene pamonga na bhando bhange bhajhakubhola na kutangacha lilobhe lya Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pighapetita machiko ghandina, Pauli ajhakunnobholela Banaba, “Tubhujhe kwa akalongo bhito twakalinge bhibhannyeketii kila muche ghututangicha Malobhe gha Bhambo Chapanga chibhajhendelela.” ");
INSERT INTO dne_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banaba apata bhajhenda pamonga na Yohane, jwakemitwa Maluku. ");
INSERT INTO dne_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nambo Pauli akawe ndeka yamaha kujhenda na Yohane nhwalo akalekine nabho ku kilambo cha ku Pamfiliya, na kukana kujhenda nabho mu lihengo. ");
INSERT INTO dne_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bhahe, Pauli na Banaba bhajhakutaungana hake ade kulekana ndela. Banaba ajhakubhoka na Maluku, bhajhakujhingila mumele na kujhenda ku Kipulo. ");
INSERT INTO dne_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Nambo Pauli ajhakuhaghula Sila, na bhando bhibhannyeketii Kilichitu bhajhakwabheka palonge jha umbone gwa Bhambo Chapanga, bhajhakubhoka. ");
INSERT INTO dne_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Na bhajhakupeta ku kilambo cha ku Siliya na ku Kilikiya, na kwenio bhaghakangamalicha bhando bhibhannyeketii Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pauli ajhakuhika ku Delibe na ku Lusta, kwenio atamita mmolwa jhumo liina lyake Timocheyo, majhe mundo akibha Nnyahude, helahela akibha Uyunane, nambo tate mundo akibha Ngilike. ");
INSERT INTO dne_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Na jwenio Timocheyo ngabhatangichilaa mbone bhando na akalongo bhibhannyeketii Kilichitu bha ku Lusta na bhu ku muche gwa ku Ikonilo. ");
INSERT INTO dne_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pauli apata bhalongohana pamonga na Timocheyo mu mwanja gwake. Bhahe, kujhingii jando, nhwalo Akayahude bhakamanyite tate mundo Timocheyo akibha Ngilike. ");
INSERT INTO dne_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na mu miche jhela jhibhapetita ajhakwapela bhabholwa malaghalikilo ghakalongilwe na akatenga na ighogholo ya bhando bhibhanyeketii Kilichitu bha ku Yeluchalemo, bhalongolila bhaghakamule. ");
INSERT INTO dne_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Malongo gha bhando bhibhanyeketii Kilichitu ghakajhendelile kubhehe nganganga mu kihobholelo, na bhabholwa bhajhakujhonjekeka lichiko ade lichiko. ");
INSERT INTO dne_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bhajhakupetela ku kilambo cha ku Fuligiya na ku Galatiya nhwalo Uhuke gwa Chapanga akabhahibhilile kutangacha Lilobhe lya Chapanga ku kilambo cha ku Asiya. ");
INSERT INTO dne_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Na bhene pubhahikita ku bomane jha ku Bisiniya, pubhajhighita kujhenda ku kilambo cha ku Betaniya, nambo Uhuke gwa Yecho ujhakwahibhilikiya. ");
INSERT INTO dne_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Bhahe, bhajhakupete ku Besiniya, bhakujhenda chomola ade ku muche gwa ku Tiloya. ");
INSERT INTO dne_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kilo chela, Pauli ajhakubhona uloto. Ajhakumona mundo jhumo jwa ku kilambo cha ku Makedoniya ajhemite palonge jhake kumpembelekeya, “Jhomboka kongo, ku Makidoniya mututangatile.” ");
INSERT INTO dne_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Papalapala Pauli papatita uloto ghola tujhakubhoka na kujhenda ku Makedoniya, nhwalo tukamanyite chakaka Chapanga atukemite kola kwatangacha Malobhe gha Mbone. ");
INSERT INTO dne_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Bhahe, tukatumbwii mwanja kwa mele kubhoka ku Tiloya na kujhenda ku Samotilake, na kilabho jhake tukahikite ku Neapole. ");
INSERT INTO dne_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kubhoka kola tukahikite ade ku Filipu, muche nkolongwa gwa ku Makedoniya ukibha pahe jha kilongoche jwa ku Loma. Tukatamikiye ndeka pa bamone jhene. ");
INSERT INTO dne_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lichiko lya Kupomolela pulihikita tukabhokite mu muche ghola nu kujhenda pahina na lukemba lumo tuhambwika natupata chehemo jha kunyope Chapanga. Tukatamite na kulonge nabho akakeghe bhubhakonganika peniya. ");
INSERT INTO dne_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pakate jha bheniya, akibha mwikeghe jhumo liina lyake Lidiya, jwa muche gwa ku Tiyatila. Jwenio akibha achulwicha ngobho ya mbijha yamahele ya chambalau na kunyinamila Chapanga. Mwikeghe jhola akatujhokanikiye nhwalo Bhambo akaujhughilwe mwojho gwake na kughapokela malobhe gha Pauli. ");
INSERT INTO dne_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Peniya jwenio na bhando bha munyumba jhake bhajhakubatichwa. Na jwenio ajhakulonge, “Anda chakaka umanye nenga ninnyeketii Bhambo, bhahe, chonde uhike na kutama kajhango.” Ajhakutupembelekeya twenga tujhende, na twenga tujhakujhenda. ");
INSERT INTO dne_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lichiko limo putukibha pwa pwache jha mukunyopa Chapanga, tukakonganike na ntumiche jhumo, mwikeghe jwakibha na michuka jha kulondola nkate jhake. Nchikana jwenio abhapekiya bhakolongwa mbijha twe nhwalo gwa ughanga gwake, akakipatile mbijha yamahele kwa kwalondolela mambu gha palonge chighapitila. ");
INSERT INTO dne_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Bhahe, mwikeghe jwenio akajhendilile kunkengama Pauli na twenga, kongo alongila, “Bhando abha ndi akatumiche bha Chapanga Nkolongwa. Bhantangachila mangota ndela jha ughokombokoke.” ");
INSERT INTO dne_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Na jwenio ahwelita kuhenga naha kwa machiko ghamahele, na lichiko limo Pauli ajhakuyoma. Peniya ajhakughalambukila na kulobholela nchuka ghola, “Ninobholela kwa liina lya Yecho Kilichitu, bhoka nkate jha mundo hojho!” Papalapala nchuka ghola ujhakubhoka nkate jhake. ");
INSERT INTO dne_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bhahe, akanahota bha mwikeghe jhola pubhalolita nabhapatii jhe kabhele mbijha kubhoka kwa mwikeghe jwenio. Bhajhakwapyeneneka Pauli na Sila na kwaghaghahana kwapeleka palonge jha akakolongwa bha muche pibhakonganikila. ");
INSERT INTO dne_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pubhahikita kwa ilongoche ya ku Loma, bhajhakwatakalila, bhalongila, “Bhando bhamba Akayahude, bhatuletii bhulo pa muche gwito. ");
INSERT INTO dne_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bhatubhola mambu gha Kiyahude kwa twenga lilaghalikilo lya Loma litukaniya kupokela hilu kughakengama.” ");
INSERT INTO dne_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Bhahe, lilongo lya bhando lilikibha peniya lijhakwapyeneneka Pauli na Sila, na bhajhomola mihalo bhajhakwahula ngobho yabhe kwa makakala na kwalobholela bhatyalwe yato. ");
INSERT INTO dne_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pubhajhomolila kwatyala hake, bhajhakwatola na kwabheka mukipungo ajhakulaghalikilwa kwabheke ulonda nkale. ");
INSERT INTO dne_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Bhahe, kuhumii mu malaghilo gheniya nnonda jhola ajhakwabheka mu chumbi cha nkate na kwapunga makongono ghabhe mu kipeke peke. ");
INSERT INTO dne_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pakate jha kilo, Pauli na Sila pubhakibha mukunyopa na mu kunnomba Chapanga kwa mihambo, na bhala bhapungwa bhange bhatehila kujhokanikiya. ");
INSERT INTO dne_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Papalapala kijhakupitila kimbonga kikolongwa ade nchinge gwa nyumba jha kipungo ijhakunyukanyuka. Bhahe, milyango jhoha ijhakudinduka na minyololo jha bhapungwa bhoha ijhakubhopoka. ");
INSERT INTO dne_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nnonda jwa kipungo pajhimwika, na jwenio ajhakubhona milyango ibhii hwaa, ahambwika akapungwa bhatehi kunyogholoka na ajhakutola upanga akikome jwenio. ");
INSERT INTO dne_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nambo Pauli ajhakulalama kwa lilobhe likolongwa, alongila, “Nkotoka kukikocholana mabhene! Twenga tubhii pamba!” ");
INSERT INTO dne_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Bhahe, nnonda jwa kipungo jhola ajhakujhopa bhannetele lumule, ajhakubhutikila nkate, ajhakugwiya palonge jha Pauli na Sila, kongo alendima kwa kiholo. ");
INSERT INTO dne_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Bhahe, ajhakwalongoya panja na kwakonya, “Akanahota, nenga henge nike Ng'ombokoke?” ");
INSERT INTO dne_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Na bhene bhajhakujhanguu, “Mupokele Bhambo Yecho, chang'ombokoka mabhene na akalongo bhino.” ");
INSERT INTO dne_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Bhahe, bhajhakuntangachila Lilobhe lya Bhambo jwenio pamonga na bhando bhoha bha nyumba jhake. ");
INSERT INTO dne_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Papalapala nnonda jhola ajhakwatola uhiko ghoghola ghola na kujhoha mabhanga ghabhe uhiko, na jwenio ajhakubatichwa pamonga na bhando bhake bhoha. ");
INSERT INTO dne_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Bhahe, ajhakwapeleka Pauli na Sila kajhake na kwapekeya chakulyegha. Jwenio pamonga na bhando bha nyumba jhake jhoha bhajhakuhanganila hake nhwalo bhanhobholile Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lichiko lyubhele lukela, ilongoche bhajhakutuma akatumiche kwa jhola nnonda jwa kipungo bhakanobholele, “Abhapiye bhando bhala.” ");
INSERT INTO dne_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nnonda jhola ajhakunobholela Pauli, “Akanahota, bhatumite lilobhe mpite mukipungo. Na ngohe nnyenda kwa uteeke.” ");
INSERT INTO dne_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Nambo Pauli nganyangwila munahota jhola, “Nonge nike, bhatutyalite yato palonge jha bhando twe na twenga kone twa bhando bha ku Loma! Kabhele ngabhatutabhita mukipungo na ngohe bhatupiya kwa chile, ichata ndeka umuto! Mwaleke bhahike bhene bhatupiye mombo mukipungo.” Twenga tuhoto ndeka! ");
INSERT INTO dne_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Akanahota bhala bhajhakubhujha na kwalobholela bhajhomola mihalo malobhe ghala. Na bhene pubhajhohina Pauli na Sila ndi bhando bha ku Loma, bhajhakujhoghopa hake. ");
INSERT INTO dne_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bhahe, bhajhakujhenda kwakamuu lukongono, na kwabhoha panja na kwajhopa bhabhoke panja jha muche ghola. ");
INSERT INTO dne_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pauli na Sila pubhapitita nkate mukipungo, bhajhakujhenda kwa Lidiya. Kwenio bhakonganike na akalongo bhibhanyeketii Kilichitu na kwakangamalicha miojho, bhajhakubhoka. ");
INSERT INTO dne_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pauli na Sila bhajhakujhendelela na mwanja, bhajhakupeta ku muche gwa ku Amufipole na ku Apoloniya, nu kuhika ku Tesolonike. Kola kukibha na nyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ngita chibhayobhalile, Pauli ajhakujhingila munyumba jhela. Kwa machiko matato gha Kupomolela, bhajhakutaungana na bhando bhubhabhiii mola, kongo atumila Majhandiko gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Abhalobholila na kwalangiya Kilichitu ikachokolikiye aweghe na kuyoka kuhumii kumambe. Ninobholela, “Hojho Yecho jhunintangacha nenga kwino ndi Kilichitu Nkomboche.” ");
INSERT INTO dne_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Akayahude bhange bhakajheketile na kubhehe pamonga na Pauli na Sila. Helahela lilongo likolongwa lya Akagilike bhubhanyinamila Chapanga pamonga na akakeghe bhamahele bhubhakibha na ilebhe mbwe bhakajheketila. ");
INSERT INTO dne_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Nambo Akayahude bhajhakubhehe na wiho, bhajhakutola bhando bha bhulo, peniya bhajhakutumbuu majhoghe pa muche. Bhajhakuleta bhulo munyumba jha Yosani, bhampaliya Pauli na Sila bhapeleke palonge jha bhando. ");
INSERT INTO dne_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nhwalo bhakakolii jhe, bhajhakupeleka Yosani pamonga na bhala bhibhanyeketii Kilichitu bhange palonge jha akanahota bha muche. Bhalongila, “Bhando bhamba bhatenda bhulo kila chehemo ngohe bhahikite pano. ");
INSERT INTO dne_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Na jwenio Yachoni abhapokile bhatame pakajhake. Bhando abha bhatenda mambu ghalengana ndeka na lilaghalikilo lya munahota nkolongwa jwa ku Loma bhalongela abhii munahota jhonge liina lyake Yecho.” ");
INSERT INTO dne_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kwa malobhe gheniya bhaletite kiholo kwa akanahota bha muche na kibhogha cha bhando. ");
INSERT INTO dne_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bhahe, akanahota bha muche bhabheke dhamana ya mbijha kubhoka kwa Yachoni na bhajhake, na bhajhakwaleka bhajhende. ");
INSERT INTO dne_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ikibha kilo, bhibhanyeketii Kilichitu bhajhakwapeleka Pauli na Sila ku Beloya. Na bhene pubhahikita kwenio, bhajhakujhingi munyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bhando bha kwenio bhakibha bhajhokanikiya kuliku bhala bhaku Tesolonike, bhajhakupokela Lilobhe lya Chapanga kwa kilolo hake. Kila lichiko bhajhakughalingukiya Majhandiko gha Chapanga bhamanye malobhe ghalongila Pauli na Sila ghabhii chakaka. ");
INSERT INTO dne_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bhahe, Akayahude bhamahele bhibhanyeketii Kilichitu pamonga na akakeghe bhamahele Akaghilike bhabhii na utembekeho, helahela na akanalome bhamahele bhakajheketii Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nambo Akayahude bha muche gwa ku Tesolonike bhajhakunyokanikiya Pauli patangicha Lilobhe lya Chapanga helahela ku muche gwa ku Beloya. Bhahe, bhajhakujhenda kwenio na kutumbuu majhoghe na kukokolekeya bhando. ");
INSERT INTO dne_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bhahe, bhubhajheketila Kilichitu bhala bhajhakunchindikicha Pauli ade ku mbwane, nambo Sila na Timocheyo bhajhakuhighalika koko ku Beloya. ");
INSERT INTO dne_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bhando bhala bhubhanchindikicha Pauli bhakaikite ade ku muche gwa ku Atene. Peniya bhajhakubhujha pamonga na malaghilo gha Pauli ku Beloya na kunnobholela Timocheyo na Sila bhankengame kajhombe. ");
INSERT INTO dne_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pauli pabhalendila Sila na Timocheyo kwenio ku Atene, mwojho gwake ujhakuyoma hake kubhona muche ghola utwelii inyagho. ");
INSERT INTO dne_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Akibha mu mataungano na Akayahude munyumba jha kukonganikii pamonga na bhando bha ilambo henge bhubhakibha mukunyinamila Chapanga. Helahela ajhakutaungana kila lichiko na bhando bhange mulighuliho bhubhapitila. ");
INSERT INTO dne_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bhabholwa bha lilongo lya Akaepikilo na lya Akasitoiko, bhibhachomikii hake bhajhakutumbuu kutaungana na Pauli. Bhange bhajhakukonya, “Hojho jhuna kihakambo cha malobhe ipala kulonge nike?” Bhange bhalongila, “Abhonekana atangachila bhando inyagho ya chapanga jha kighene.” Bhakalongile naha nhwalo Pauli akibha atangicha panane jha Yecho. ");
INSERT INTO dne_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Peniya bhajhakunkamula Pauli, na kumpeleka palonge jha Udamo Nkolongwa ukemitwa “Aleopago,” Bhajhakunkonya, “Tupala kumanya, bho, uhoto ghukulonge mana jha mabholo ghanga? ");
INSERT INTO dne_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ghamahele tujhohine kwa machikilo ghito, nhwalo mutuletii ilebhe ya kukangacha. Bhahe, ngoheno tupala kumanya mana ghake.” ");
INSERT INTO dne_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Bhando bha ku Atene pamonga na akaghene bhubhatamita pakate jhabhe, machiko ghoha bhachimulila na kunyokanikiya mabholo mayono. ");
INSERT INTO dne_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bhahe, Pauli ajhakujhema palonge jha udamo gwa Aleopago na kulonge, “Mangota mwenga bhando bha ku Atene, nibhona mangota ndi bhando mihutilwa hake na inyagho ya ichapanga. ");
INSERT INTO dne_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nhwalo pundyangita pa muche gwino nolokiya inyagho hino pa chehemo jha kunnyope Chapanga na kachangwale kakupikiya matambiko kajhandikwe naha, ‘Kwa Chapanga jwangamanyikana.’ Bhahe, jwenio jhumunyopa changamanya ndi jhola jhunitangacha kwino. ");
INSERT INTO dne_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Chapanga jwapangina ilebhe yoha, Bhambo jwa kunane kwa Chapanga na pannema, atama ndeka munyumba jha kunyopela jwenio ichengwite na bhando. ");
INSERT INTO dne_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Jwenio Chapanga apala ndeka mahengo ghakubhoka mu mabhoko gha bhando, nhwalo jwenio ndi aletita kupomola na ughome na ilebhe yoha. ");
INSERT INTO dne_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kuhumi kwa mundo jhumo, jwenio akapangine bhando bhoha bha pakilambo. Abhapekiye lichaa lya kutama na mipaka jha kutama popoha pubhapala kutama. ");
INSERT INTO dne_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Chapanga atehila naha, bhando bhoha bhankengame, ata kwa kupapaha papaha, bhahoto kunhikilila. Chakaka Chapanga abhii jhe kutale na kila mundo, ");
INSERT INTO dne_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ngita chalongila mundo jhumo, ‘Nkate jhake twenga tutama na tutyanga na tubhile.’ Tukihotola, na tubhii ngita nnyemba ngungo chalongila, ‘Twenga ndi twayana yake.’ ");
INSERT INTO dne_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Bhahe, nhwalo twenga ndi kibheluko cha Chapanga, tukotoka kuwacha Chapanga ihoto kutengenechwa kwa chaabo amu mbijha amu lighanga lilibhachwa kwa malango gha bhando. ");
INSERT INTO dne_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Chapanga atehila ngita alola jhe machiko ghala bhando pubhakibha mandindilima. Nambo ngoheno, alaghalikiya kwa bhando bhoha, bhajheketele na bhauleke uhakaho gwabhe. ");
INSERT INTO dne_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Nhwalo apangite njwe machiko gha kwahadabula bhando bha nnema ngita chikipalwa kwa ndela jha mundo jhumo, jhola jwahagwile kwa lihengo lela. Na jwenio Chapanga akilangiye hotuhotu kubhehe mambu ghanga ndi chakaka jwayokite mundo jwenio kwa mundo kuhumii kubhawile.” ");
INSERT INTO dne_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Na bhene pubhajhohina Pauli alongela panane jha kuyoka kwa bhubhawile, bhange bhajhakukikajhula kiheko nambo bhange bhajhakulonge, “Tupala kunyokanikiya kabhele panane jha lilobhe lende.” ");
INSERT INTO dne_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Peniya Pauli ajhakwaleka pakate jhabhe. ");
INSERT INTO dne_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nambo bhando bhange bhajhakulongohana na jwenio Pauli. Bhajhakubhehe bhando bhibhannyeketii Kilichitu. Pakate jhabhe akibha mundo jhumo jwakemitwa Dionisiyo jwa ku Aleopago, na mwikeghe jhumo jwakemitwa Damale na bhando bhange. ");
INSERT INTO dne_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pughapetita mambu gheniya, Pauli ajhakubhoka ku Atene, nu kujhenda ku muche gwa ku Kolintu. ");
INSERT INTO dne_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kola ajhakukonganika na Nnyahude jwakemitwa Akula, jwabhelukilwe ku kilambo cha ku Ponto, na liina lya nhwana mundo akemitwa Pilisila. Kwa machiko ghagha bhakahite kubhoke ku kilambo cha ku Italiya, nhwalo kilongoche Kilaudiyo akalaghalikiye Akayahude bhoha bhabhoke ku Loma. Pauli ajhakujhenda kwalola kwenio, ");
INSERT INTO dne_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na jwenio akatamite na kuhenga lihengo pamonga nabho, nhwalo bhoha bhakibha mapunde bha kutengenecha ichimba. ");
INSERT INTO dne_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kila Lichiko lya Kupomolela, Pauli alongila nabho munyumba jha kukonganikii Akayahude na kujhigha kwapata Akayahude na Akagilike. ");
INSERT INTO dne_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila na Timocheyo pubhahikita kuhumii ku Makedoniya, Pauli ajhakutumila machaa ghoha kwa kutangacha Lilobhe lya Chapanga, alongila kwa Akayahude Yecho ndi Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nambo Akayahude pubhakibha mu kutaungana na Pauli na kunnigha, ngakung'inda ngobho yake na kulonge palonge jhabhe, alongila, “Kuhobha kwino kwale mabhene! Nenga kibhii jhe chinemwite. Kuhumii ngoheno najhendelela bhando bha ilambo henge.” ");
INSERT INTO dne_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Bhahe, Pauli ajhakubhoka pala, ajhakujhenda kutama ku nyumba jha mundo jhumo jwakemitwa Titu Yusito, jwakibha anyinamila hake Chapanga. Nyumba jha mundo hojho ikabhandikile pa nyumba jha kukonganikii Akayahude. ");
INSERT INTO dne_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kilisipo, kilongoche jwa nyumba jha kukonganikii Akayahude, akanyeketile Bhambo jwenio pamonga na bhando bhoha bha ku nyumba jhake. Na bhene Akakolintu bhamahele bhakajhokanikiye lilobhe lyenio, na bhajhakujheketela na kubatichwa. ");
INSERT INTO dne_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lichiko limo kilo, Bhambo akannobholile Pauli mu uloto, “Nkotoka kujhoghopa, nnyendelele tugha kutangacha malobhe gha Bhambo, nkotoka kukotoka. ");
INSERT INTO dne_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nhwalo nenga mii pamonga na mwenga. Abhii jhe mundo jwa muche ghoghoha nahotola kuyenganila na kukocholana mwenga, nhwalo upandi gwito bhabhii bhando bhamahele.” ");
INSERT INTO dne_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pauli akatamite kwenio na kubhola Lilobhe lya Chapanga kwa chaka chimo na miyehe chita. ");
INSERT INTO dne_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nambo Galiyo pakibha kilongoche jwa kilambo cha ku Akaya, Akayahude bhajhakuyenganila Pauli kwa pamonga kunkamula na kuhikicha palonge jha nyumba jha mihalo. ");
INSERT INTO dne_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","na bhajhakulonge, “Tutakalila mundo hojho nhwalo, abhalobholile bhando bhannyinamile Chapanga kwa ndela jhangalandana na lilaghalikilo lito.” ");
INSERT INTO dne_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pauli nakutumbu jhe kulonge, Galiyo ajhakwalobholela Akayahude, “Ngita chimipala kuntakalila mundo jhonjo panane jha lilobhe lya lukwatulo amu ngalibhii lyanganandela likolongwa nganyeketile kunyokanikiya mangota. ");
INSERT INTO dne_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nambo anda panane jha mitaungano jha malobhe na mahina na lilaghalikilo lino, bhahe, nhenge mabhene. Nenga mbahijhe kubhehe nnyomola mihalo gwino.” ");
INSERT INTO dne_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Bhahe, ajhakwabhenga kubhoka pa nyumba jha mihalo. ");
INSERT INTO dne_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Na bhene bhajhakunkamula Sositenese, kilongoche nkolongwa jwa nyumba jha kukonganikii Akayahude, na kutyala palonge jha nyumba jha mihalo. Nambo Galiyo ajhakwapucha chibhahengita panane jha lijhambu lela. ");
INSERT INTO dne_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pauli akajhendelile kutama na bhala bhibhanyeketii Kilichitu kwa machiko ghamahele ku Kolintu. Peniya ajhakutabhuka nabho akalongo bhake, na kuhobhokela mele kutumbuu mwanja na kujhenda ku kilambo cha ku Siliya. Na bhene Pilichila na Akula bhakibha pamonga na jwenio. Kwenio ku Kenikuleya Pauli ajhakuchekula majhunjo kwa nhwalo gwa nachile lyakabhekite. ");
INSERT INTO dne_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pubhahikita ku Epecho, Pauli ajhakwaleka bhajhake bhala Pilichikila na Akula kola. Na jwenio ajhakujhingi nkate jha nyumba jha kukonganikii Akayahude na kulongelelana. ");
INSERT INTO dne_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Na bhene bhakanobholile atame nabho kwa machiko gha mahele, nambo akapahi jhe. ");
INSERT INTO dne_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Pubhalaghina nabho, ajhakwanobholela, “Anda Chapanga napala chanhika kabhele.” Ajhakubhoka ku Epecho kwa mele. ");
INSERT INTO dne_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pahikita ku muche gwa ku Kaisaliya, mele ijhakujhema. Pauli ajhakujhenda ku Yeluchalemo kulijhambucha lilongo lya bhando bhubhanyeketii Kilichitu. Peniya ajhakujhenda ku Antiyokiya. ");
INSERT INTO dne_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ajhakutama kwenio kwa machiko ghandina, ajhakubhoka na kujhendelela na mwanja kwa kupetela chehemo kwa chehemo kuhumii ku kilambo cha ku Galatiya ade ku kilambo cha ku Fuligiya, na kwenio ajhakwangamalicha bhibhanyeketii Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Machiko gheniya, Akayahude jhumo, liina lyake Apolu, jwabhelukilwe ku muche gwa Alekichandaliya, ahikite ku muche gwa ku Epecho. Akibha mundo jwabhii na uhotolo gwa kulonge na kumanya mbone Majhandiko gha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mundo jwenio akabholitwe ndela jha Bhambo, na jwenio akibha mpyoompyoo hake, na abholita malobhe gha Yecho kwa uchakaka. Nambo akapatite ubaticho gwa Yohane tugha. ");
INSERT INTO dne_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Bhahe, Pilisila na Akula pubhanyohina akilongela changa kiholo munyumba jha kukonganikii Akayahude. Bhajhankutola kajhabhe na kummola ndela jha Chapanga kwa uchakaka hake. ");
INSERT INTO dne_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolu akapahile kujhenda ku kilambo cha ku Akaya, akalongo bhala bhajhakunkangalamicha mwojho na bhene bhajhakwajhandikila baluwa bhabholwa bha kola bhampokele mbone. Na pakahikita kwenio, kwa utangatilo gwa umbone gwa Chapanga, akabhatangatile akalongo bhibhannyeketii Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Nhwalo akajhendelile kwa uhotolo changa kiholo kwa Akayahude palonge jha bhando bhoha na kubhehe panane jhabhe. Alangiya kwa ndela jha Majhandiko gha Chapanga Yecho ndi Kilichitu Nkomboche. ");
INSERT INTO dne_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolu pakibha ku Kolintu, Pauli akibha mumwanja apetila ku kilambo cha itombe na kuhika ku Epecho. Kola ajhakwakolela bhabholwa, ");
INSERT INTO dne_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ajhakwakonya, “Bho, mangota mukapokii Uhuke gwa Chapanga pinnyeketila?” Na bhene bhajhakujhanguu, “Ko! Tujhohine ndeka ngita ubhii Uhuke gwa Chapanga.” ");
INSERT INTO dne_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pauli ajhakwakonya, “Ngohe mbatichwe kwa ubaticho ghane?” Bhajhakujhanguu, “Tukabatichwe kwa ubaticho gwa Yohane.” ");
INSERT INTO dne_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pauli ajhakwalobholela, “Yohane akabatiche bhala bhibhajheketii na bhauleke uhakaho na kwalobholela bha ku Ichilahele bhahobholele jhola jwahika panyuma jhake, na jwenio ndi Yecho.” ");
INSERT INTO dne_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Pubhajhohina malobhe gheniya, bhajhakubatichwa kwa liina lya Bhambo Yecho. ");
INSERT INTO dne_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bhahe, Pauli ajhakubheka mabhoko panane jhabhe, na Uhuke gwa Chapanga ajhakwahulukila panane jhabhe, na bhene bhajhakutumbuu kulonge kwa lugha yono na kutangacha lilobhe lya Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bhoha bhakibha bhabhandikila akanalome kome na bhabhele mulilongo lyabhe. ");
INSERT INTO dne_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kwa miyehe mitato Pauli ajhakujhingila munyumba jha kukonganikii Akayahude na kulonge mwenio changa kiholo kongo akilongela nabho ajhighita kwahutila mu Unahota nkolongwa gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nambo bhange bhakapahi jhe kujheketela, bhakajheketii ndeka, bhajhakutumbuu kulonge mambu ghanganandela gha Bhambo palilongo lya bhando. Peniya Pauli ajhakulekana nabho, ajhakujhenda na bhabholwa bhange. Na kila machiko alongila nabho mulijhumba lya kukibholela jhikemitwa Tilano. ");
INSERT INTO dne_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Akajhendelii kuhenga yenio kwa yaka ibhele Akayahude na Akagilike bhubhatamita mu kilambo cha ku Asiya bhalijhohe lilobhe lya Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chapanga akajhendelile kuhenga nginyililo ya kukangacha kwa ndela jha Pauli. ");
INSERT INTO dne_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bhando bhajhakutola itambala na ngobho yahengila lihengo Pauli, bhajhakwapelekela bhibhalwalwa, na bhene bhajhakulama na michuka ijhakuchomoka kwa bhando bhubhakina najho. ");
INSERT INTO dne_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pakibha na Akayahude bhubhatyangita tyangita kongo na kola kubhoha michuka. Bhando bhala bhakajhighite kutumila liina lya Bhambo Yecho kwa bhala bhubhachikilwe, bhajhakwalobholela, “Mumoke kwa liina lya Yecho, jhola jwatangichwa na Pauli.” ");
INSERT INTO dne_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bhahe, yana chaba ya mundo jhumo jwakemitwa Sikewa, jwakibha Nkolongwa jwapiya matambiko jwa Akayahude ndi jwatehila naha. ");
INSERT INTO dne_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nambo nchuka ghola ujhakujhanguu, “Nimanya Yecho na Pauli, ngohe mangota maghane?” ");
INSERT INTO dne_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Na jhola mundo jwakachikilwe ajhakwahombela, ajhakwapeta kwa makakala. Na yana ya Sikewa yela ijhakubhutuka kuhumii munyumba makengela na mabhanga twe. ");
INSERT INTO dne_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bhando bhoha bha ku Epecho na Akayahude na Akagilike, bhakamanyite malobhe gheniya. Peniya bhoha bhajhakujhogopa na kulilumbila liina lya Bhambo Yecho. ");
INSERT INTO dne_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bhando twe bhibhannyeketii Kilichitu bhakahikite palonge jha bhando na kulonge ghibhatehila. ");
INSERT INTO dne_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Na bhando bhamahele bhubhakibha na uhabhe bhajhakutola itabo yabhe, na kuichonja mwotu palonge jha bhando bhoha. Pubhabhalinga malepo gha itabo yenio ikahikile ipande elufo hamuchine ya madine gha feza. ");
INSERT INTO dne_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Peniya lilobhe lya Bhambo lijhakujhendelela kujhenela na kubhehe na makakala hake. ");
INSERT INTO dne_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pughapitita mambu gheniya, Pauli ajhakupanga kujhenda ku Yeluchalemo kupete ku Makedoniya na ku Akaya. Ajhakuwacha ku mwojho gwake alongila, “Anda ikite kwenio, helahela nambala kujhenda ku Loma.” ");
INSERT INTO dne_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bhahe, ajhakwatuma bhando bhabhele bhubhantangatila, Timocheyo na Elachito bhannongolele kujhenda ku Makedoniya. Na jwenio natama pandina ku kilambo cha ku Asiya. ");
INSERT INTO dne_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Machiko gheniya ndi puitumbukina kijhonga kikolongwa kwenio ku Epecho nhwalo gwa ndela jhene jha Bhambo. ");
INSERT INTO dne_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kukibha na mundo jhumo jwayanita ilebhe ya madine gha feza, liina lyake Demetiliyo. Akibha atengenicha nnandanikiho gwa nyumba jha chapanga mwikeghe jwa uwange liina lyake Atemi. Lihengo lyenio limpekiya jwayanita ilebhe ya madine gha feza twe. ");
INSERT INTO dne_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Bhahe, ajhakwatola bhubhayanita bhoha pamonga na bhando bhange bhubhahengita lihengo lyenio na kwalobholela, “Makalongo bhango, umanya twenga tupata ilebhe yamahele kwa ndela jha lihengo lende. ");
INSERT INTO dne_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ngoheno, tughalolokeye hote mambu ghatenda Pauli na kughajheketela twabhete, chi pamba tugha pa Epecho, na ku kilambo choha cha ku Asiya. Pauli abhakokolikiye bhando bhaghalambuke kubhoka muinyagho ilenganikiwe na bhando na chi chapanga ata pandina. ");
INSERT INTO dne_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ibhii ngondo kubhehe lihengo lito kupelwa liina libhoho, hele tujhe ata nyumba jha chapanga mwikeghe Atemi, naibhalangilwa ndeka kubhehe kilebhe nacho. Kujhomolela ulumbililo gwake jwenio na bhando bhoha bha ku Asiya na nnema ghoha bhibhainyinamila nahijhomokela!” ");
INSERT INTO dne_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Bhando bhala pubhajhohina gheniya, bhajhakuyoma na kutumbuu kulalama bhalongila, “Atemi jwa ku Epecho nkolongwa!” ");
INSERT INTO dne_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Chwechelele kijhonga kijhakujhenela bomane jhoha. Bhajhakwakamula Gayo na Alisitako bhando bhubhahumii kilambo cha ku Makedoniya bhubhakibha pamonga na Pauli. Na bhene bhoha bhajhakwatutuhana ade pa lubhanja lwa kukina. ");
INSERT INTO dne_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pauli apata kujhenda palonge jha lilongo lya bhando, nambo bhabholwa bhajhakukanakiya. ");
INSERT INTO dne_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Akakolongwa bha ku bomane jha ku Asiya, bhakibha akakoche mundo bhakampembelikii nkotoka kujhenda mu lubhanja lwenio. ");
INSERT INTO dne_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Bhahe, bhando bhajhakulalama kila jhumo alopwika lyake, bhalongela lende na bhange lela, ade pa lubhanja loha lujhakupechengana. Bhamahele bhakamanyite jhe nhwalo gwa kukongana kwenio. ");
INSERT INTO dne_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Akayahude bhajhakuntenda Alekichanda apitile palonge, bhando bhahambwika jwenio ndi jwatumbulicha gheniya mulilongo lela, bhahe, Alekichanda ajhakwalobholela bhatame nuu akikengelele palonge jha lilongo lela. ");
INSERT INTO dne_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nambo pubhamanyita jwenio ndi Myahude hele, bhoha bhajhakulalama kwa pamonga kwa machaa mabhele, bhalongila, “Nkolongwa Atemi jwa ku Epecho!” ");
INSERT INTO dne_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Bhahe, mundo jhumo kilongoche jwa muche ajhakwapomoha alongila, “Mangota bha kilambo cha ku Epecho, bhando bhoha bhamanya bhando bha ku Epecho ndi bhajhemelela nyumba jha chapanga Atemi na inyagho yake ikaponite kuhumii kunane kwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Bhahe, abhii jhe mundo jwahotola kukana malobhe ghanga, ntame nuu hilu nkotoka kuhenga kilebhe chochoha changaholelela. ");
INSERT INTO dne_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nhwalo mwaletite bhando bhamba pamba, bhachonjwii ndeka nyumba jha chapanga hilu, kunnigha chapanga gwito mwikeghe. ");
INSERT INTO dne_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bhahe, anda Demetiliyo na bhubhayanita bhala bhabhii mu matakalilo panane jha bhando bhamba, ghabhii pa nyumba jha mihalo, na ilongoche ya bomane bhahoto kutakalilana kwenio. ");
INSERT INTO dne_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Na anda nkwete malola ghange, mughapeleke pabwalo jha muche. ");
INSERT INTO dne_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Nhwalo kwa mambu ghakapitite, ngabhahotwi kutakalilwa kwa nhwalo gwa kijhonga cha deleno. Kabhele kijhonga chenie changanandela ngatuhotwi ndeka kulonge nhwalo ngatuhotwii kulonge nike kihokola cha kijhonga chenje.” ");
INSERT INTO dne_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Bhahe, kilongoche jwenie pajhomolila kulonge gheniya, ajhakulitabhuka lilongo lyoha. ");
INSERT INTO dne_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kijhonga cha ku Epecho pikijhomokila, Pauli ajhakukonganika na bhabholwa bhake na ajhakwangamalicha mwojho. Peniya ajhakulaghana nabho, ajhakujhendelela na mwanja kujhenda ku Makedoniya. ");
INSERT INTO dne_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ajhakupeta ku kilambo chela kongo ajhakwalobholela bhabholwa bhake malobhe ghamahele gha kwakangamalicha mwojho. Peniya ajhakuhika ku Gilike, ");
INSERT INTO dne_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","na kutama kwa miyehe mitato. Pakibha akilenganikiya kujhenda ku kilambo cha ku Siliya, ajhakumanya kubhehe Akayahude bhantendile nginyika. Bhahe, ajhakuwacha kumwojho abhujhe, kwa ndela jha ku Makedoniya. ");
INSERT INTO dne_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Na abha ndi bhando bhubhakibha pamonga na jwenio, Sopatili mwana gwa Pilo jwauhumila ku Beloya, ku Alisitako na ku Sekundo bhando bha ku Tesolonike na ku Gayo mundo jwa ku Delibe na bhene Timocheyo na Tikiko na Tilofimo bha kilambo lya ku Asiya. ");
INSERT INTO dne_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bhando abha bhajhakulongolela kujhenda ku Tiloya, na kutulendela kwenio. ");
INSERT INTO dne_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nambo puupetita unyagho gwa mabumunda ghangaleka ngedule, twenga tukakujingii mu mele kuhumii ku muche gwa ku Filipu na machiko matato tujhakuhika ku Tiloya. Peniya lichiko lya nhwano tukakolile ku Tiloya, tukatamite kola kwa machiko chaba. ");
INSERT INTO dne_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lichiko lya Kupomolela kimiye, kutamangana pamonga kulyegha libumunda. Pauli ajhakwatangachila bhando ade uhiko ghola na apata kubhoka kilabho jhake. ");
INSERT INTO dne_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Na kuchumbi cha ku gholofa pakibha na kolobohi twe ijhakita. ");
INSERT INTO dne_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kangombo jhumo, jwakemitwa Eutiko, akibha akatamite pa lidilicha. Kongo Pauli pajhendilila kubhola, Eutiko ajhakutumbuu kuchichila kachoko kachoko na lugwenio ujhakukolanika, kugwiya pahe kuhumii ku chumbi chutato cha ku gholofa. Pubhanokwita ahwii njwe. ");
INSERT INTO dne_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Nambo Pauli ajhakuhuluka pahe, ajhakunyinama na kunkumbatila alonge, “Nkotoka kubhehe na kiholo, amela ghome!” ");
INSERT INTO dne_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Peniya Pauli ajhakuhobhokela kabhele panane jha chumbi chela chakibha, ajhakumetula libumunda na kulyegha. Ajhakujhendelela kulonge malobhe kwa machaa ghamahele ade putiputi, peniya ajhakubhoka. ");
INSERT INTO dne_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bhando bhala bhajhakunghegha kangombo jhola ade ukajha, akibha na ughome gwake, na kumwojho kwabhe bhajhakubhehe jhojwa hake. ");
INSERT INTO dne_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Twenga tukajhingile mumele kujhenda ku Aso. Kwenio ngankoli Pauli ndi chakapangite, nhwalo akapahile kujhenda kwenio kwa makongono. ");
INSERT INTO dne_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Bhahe, putukongina ku Aso, akajhingii nkate jha mumele na kujhenda ku Mileto. ");
INSERT INTO dne_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Kuhumii kwenio tukahikite chehemo pipakemitwa Kio tujhakujhendelela na mwanja na kuhika ku Shamo. Kilabho jhake tujhakujhombokela ku Mileto. ");
INSERT INTO dne_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pauli akapahile kujhendelela na mwanja na mele changapetela ku Epecho akotokota kutamikiya ku Asiya. Nhwalo akibha kajhombe kuhika ku Yeluchalemo lichiko lya unyagho gwa Pendekochite anda ngahotwii. ");
INSERT INTO dne_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kubhoke ku Mileto, Pauli ajhakwakema akanahaota ilongoche ya bhando bhibhanyeketii Kilichitu bhhajhende ku Epecho bhakakongane. ");
INSERT INTO dne_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Na bhene pubhahikita, ajhakwalobholela, “Umanyite chindamita na mangota machiko ghoha, kuhumii lichiko lela lindumbwila ku kilambo cha ku Asiya.” ");
INSERT INTO dne_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Umanye chinihengila Bhambo kwa utembekeho ghoha, kwa mahole chwii na majhighanikilo ghoha ghighangolila nhwalo gwa nginyika ya Akayahude. ");
INSERT INTO dne_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Umanye kubhehe nyogwipe ndeka hilu pandina kutangacha malobhe kwa uchakaka, munyumba hino na kubhola chochoha cha kuntangatila mabhene. ");
INSERT INTO dne_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nikapwatalile Akayahude na bhando bha ilambo henge kujheketela na kuuleka uhakaho na kung'alambukila Chapanga na kunyeketela Bhambo Yecho Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ngohe unyokanikiye nenga ninyeketela Uhuke gwa Chapanga, nijhenda ku Yeluchalemo changamanya chikipala kungolela kwenio. ");
INSERT INTO dne_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nambo kilebhe chimo chimanya mu kila muche, Uhuke gwa Chapanga anobholela ipungo na mang'ahe ndi ghanendelela palonge jhango. ");
INSERT INTO dne_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nambo niubhalangila ndeka ughome gwango kubhehe kilebhe chambone kwa nenga. Chinipala nenga ndi kuhika mwicho gwa kuhenga lihengo limbekilwe na Bhambo Yecho, kutangacha Lilobhe lya Mbone lya umbone gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Pundyangita tyangita kwino mangota bhoha kutangacha Unahota nkolongwa gwa Chapanga. Nambo ngoheno, nimanya abhii jhe mundo jhojhoha pakate jhino jwambala kummona nenga kabhele. ");
INSERT INTO dne_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ndi mana nilongela palonge jhino deleno anda ahobhite jhumo pakate jhino, nenga ngwete jhe ulemo gheniya kwale mabhene. ");
INSERT INTO dne_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nhwalo nikajhoghipe ndeka ata pandina kuntangachila mangota ghoha ghapala Chapanga kwa uchakaka. ");
INSERT INTO dne_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Mangota mukilolekeye mabhene, na mulilonde lilongo lela lyoha Uhuke gwa Chapanga amekite mangota kubhehe ilongoche yake. Malolekeye bhando bhibhanyeketii Kilichitu bhibhahemelilwe kwa miyahe jhake jwenio. ");
INSERT INTO dne_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nimanya mbone kubhoka kwa nenga, mamehe ghighakokotwike naghajhingilila pakate jhino, na bhene nabhabhehe jhe na kiya kwa lilongo lyenio. ");
INSERT INTO dne_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Pakate jhino chibhapitila bhando bhakubhola bhange mambu ghuwange bhibhannyeketii Kilichitu bhahobholele kwa kwakengama bheniya. ");
INSERT INTO dne_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bhahe, ntame miho kukomboka kwa yaka itato kilo na muhe nikalekite ndeka kummola mangota kwa mahole chwii. ");
INSERT INTO dne_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Bhahe, ngoheno nanimeka pahe jha ulonda gwa Chapanga na lilobhe lyake lya umbone. Jwenio akwete uhotolo kunchenga na kupekeya mota bhando bhake bhoha. ");
INSERT INTO dne_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nenga nikahipai jhe ipande ya madine ya feza, hilu chaabo hilu ngobho jha mundo jhojhoha. ");
INSERT INTO dne_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mangota mabhene umanye hengita lihengo kwa mabhoko ghango kwa kupata ilebhe yoha inighanita na ya bhando bhange. ");
INSERT INTO dne_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mambu gheniya ghoha ghihengita, nikanangiye kwa nandanikiho naha kwatangatila bhando akahocho, putukomboka malobhe gha Bhambo Yecho, alongila, ‘Mbaha kupiya kuliku kupokela.’ ” ");
INSERT INTO dne_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pauli pajhomolela kulonge malobhe gheniya, ajhakutama makilikite pamonga jhabhe na kunyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Bhoha bhajhakulela hake, kongo bhatawika kwa kunkumbatila na kunchopachopa. ");
INSERT INTO dne_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Lijhambu lilatehila bhabha ngolongondi, lela nhwalo lyabhalobholila nabhamwona jhe kabhele. Bhajhakunchindikicha ade mu mele. ");
INSERT INTO dne_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Putujhomolila kutabhuka nabho, tujhakungii mumele na kujhenda chomola ade ku Kosi. Kilabho chake tujhakuhika ku muche gwa ku Lode, na kubhoke kwenio tujhakuhika ku muche gwa ku Patala. ");
INSERT INTO dne_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Kwenio tujhakuikolela mele jha kujhenda ku Foinike, tujhakujhingii mwenio na kutumbuu mwanja. ");
INSERT INTO dne_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Putuhotwila kuibhona Kipulo, tukapetile kwa upandi gwa kuchine na kujhenda ku kilambo cha ku Siliya. Tujhakujhema pabomane jha ku Tilo na kuhuluya mihigho jhigheghitwe. ");
INSERT INTO dne_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kola tujhakukonganika na bhabholwa, na kutama nabho kwa machiko chaba. Na bhene kwa kulongochwa na Uhuke gwa Chapanga bhajhakunnobholela Pauli nkotoka kujhenda ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nambo pulihikita lichiko lya kubhoka na kujhendelela na mwanja. Bhibhajheketii bhoha pamonga na akakeghe na yana yabhe bhajhakutuchindikicha ade panja jha muche. Putuhikita ku mbwane twenga twabhoha tujhakutama makilikite na kunnyopa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Peniya tujhakutabhuka nabho, na twenga tujhakujhingii mu mele, na bhene bhajhakubhujha kajhabhe. ");
INSERT INTO dne_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Twenga tujhakujhendelela na mwanja gwito kubhoke ku Tilo na kuhika ku Tolemai. Na pala tujhakwajhambucha akalongo bhito, na kutama nabho lichiko limo. ");
INSERT INTO dne_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kilabho jhake tujhakubhoka na kuhika ku muche gwa ku Kaisaliya. Tujhakutama munyumba jha ntangacha Lilobhe lya Chapanga liina lyake Filipu, jwenio akibha jhumo jwa bhala bhando chaba bhibhakahaghulilwe ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Jwenio Filipu akibha na ichikana ncheche yanga tolelwa na bhibhapiya ulondole gwa Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Pututamita kwenio kwa machiko ghamahele, nnondole jhumo jwa Chapanga, jwakemitwa Agabo, ajhakuhika kubhoke ku Yudeya. ");
INSERT INTO dne_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ajhakuhika kwito, ajhakutola luhunga lwa Pauli, ajhakukikonga mu magholo na mabhoko ghake na kulonge, Uhuke gwa Chapanga akalongii naha, Akayahude bha ku Yeluchalemo chibhankonga hele mundo jwa luhunga londo na kummeka mu mabhoko gha bhando bha ilambo henge. ");
INSERT INTO dne_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Bhahe, putujhohina malobhe gheniya, twenga pamonga na bhando bha bhubhakibha peniya tujhakupembelela Pauli akotoka kujhenda ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nambo Pauli ajhakujhanguu, “Mipala kuhenga nike? Mipala kutwekula mwojho gwango kwa maholechwii? Nyeketile kupungwa chi tu ku Yeluchalemo, nambo ata kuwegha kwa nhwalo gwa liina lya Bhambo Yecho.” ");
INSERT INTO dne_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Putukalepelile kulonge nako, tujhakutama nuu na ata kulonge, “Lyapala Bhambo lihengeka.” ");
INSERT INTO dne_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Bhahe, tukatamikii ndeka peniya, tujhakutabha mihigho jhito, na kujhenda ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bhabholwa bhange kubhoka ku muche gwa ku Kaisaliya tujhakubhehe ndela jhimo ade tujhakuhika kajha kwa Munasoni, mundo jwa Kipulo, jwakibha ajheketii kwa machiko ghamahele, ndi tutame kajhake. ");
INSERT INTO dne_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Putuhikita ku Yeluchalemo, akalongo bhibhannyeketii Chapanga bhajhakutupokela kwa kuhanganila hake. ");
INSERT INTO dne_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Kilabho jhake tujhakujhenda pamonga na Pauli kunyambucha Yakobu, na akanahota bhoha bha bhando bhibhanyeketii Kilichitu bhibhakibha. ");
INSERT INTO dne_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bhahe, Pauli pubhanyambwicha na ajhakutumbuu kwalobholela mambu ghala ghoha, Chapanga ghahengite kwa ilambo henge kupete mulihengo lyake. ");
INSERT INTO dne_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Na bhene pubhajhohina malobhe gheniya, bhajhakunumbalila Chapanga. Peniya bhajhakunnobholela Pauli, “Mabhona Akayahude bhamahele bhibhannyeketii Kilichitu, na bhoha bhakamwile lilaghalikilo. ");
INSERT INTO dne_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nambo bhajhohine malobhe panane jhino mubhola bhando bhakamule lilaghalikilo lya Mucha. Mwakanikiye bhakotoka kujhingii jando yana yabhe ata kukengama mambu gha Akayahude. ");
INSERT INTO dne_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bhahe, mambu ghanga nahibhaha bhole? Chakaka bhando bhala chibhajhoha mii pamba. ");
INSERT INTO dne_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ngohe nhenge chenje. Pamba tubhii na bhando ncheche bhubhabhekite nachile palonge jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Nnyende na bhando bheniya pamonga kuunyagho gwa kujhelebhuka, mukalepe ghoha ghighipalwa, peniya mwachekule majhunjo ghabhe. Bhando nabhamanya mambu ghala ghighalongilwe panane jhino ghabhii na kihukilo chambone, na mabhene mujheketela na kukengama Malaghalikilo gha Mucha. ");
INSERT INTO dne_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nambo kwa bhando bha ilambo henge, tujhandike panane jha mambu agha. Twalobholile bhakoto kulyegha ilebhe ihipiitwe kwa litambiko lya inyagho, bhakoto kulyegha miyahe ata kinyama chikiwii chenie, na bhakotoka kutenda ngongola.” ");
INSERT INTO dne_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bhahe, kilabho jhake Pauli ajhakujhenda na bhando bhala ncheche, na kuhenga ujhelubhulo pamonga nabho. Peniya ajhakujhingila nkate jha Nyumba jha Chapanga na kutangacha lichiko lya mwicho lya kukijhelebhula kwa kila jhumo jwabhe. ");
INSERT INTO dne_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nambo machiko chaba pughabhandikila kujhomwokela, Akayahude bha kubhoke ku kilambo cha ku Asiya bhajhakummona Pauli mu Nyumba jha Chapanga. Peniya bhajhakwakwelekeya bhando bhabhehe na lilaka, bhajhakunkamula. ");
INSERT INTO dne_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Kongo bhajhakulalama kwa njobhelo! Bhalongila, “Mangota bhando bhu ku Ichilahele, mututangatile! Mundo hojho ndi jwabhola bhando ilambo yoha, na ghughapucha mambu gha kilambo chito, Lilaghalikilo lya Mucha, na Nyumba jha Chapanga. Abhajhingiye bhando bha ilambo henge na kupahakaya chehemo jha nyahinyahi!” ");
INSERT INTO dne_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","akanobholile naha nhwalo mkamwene Tilofimo jwabhelukilwe ku muche gwa ku Epecho, abhii na Pauli kubomane, bhene bhahambwika Pauli anyingiye mu Nyumba jha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Muche ghoha ukatwelii kijhonga na bhando bhajhakukonganika peniya. Bhajhakunkamula Pauli na kuntutuhana panja jha Nyumba jha Chapanga, na papa milyango ijhakudindwa. ");
INSERT INTO dne_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bhakajheketile kunkoma Pauli, nambo akanalome bhajhakuhikilila nkolongwa jwa akakomana ngondo jwa ku Loma kubhehe muche ghoha gwa ku Yeluchalemo utweli kijhonga. ");
INSERT INTO dne_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Papalapala, nkolongwa jwa akakomana ngondo ajhakwatola akakomana ngondo bhabhele na kubhutukila kola, ajhakulikenga lilongo lela lya bhando. Na bhene pubhamonita nkolongwa pamonga na akakomana ngondo bhake, bhajhakuleka kumbula Pauli. ");
INSERT INTO dne_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Peniya nkolongwa jwa nkomana ngondo ajhakunheghelela Pauli, ajhakunkamula na kwa kulaghalikiya, Pauli bhatabhe minyololo mibhele. Peniya ajhakukonya, “Bho, mundo hojho ndi ghane? Bho, alemwite nike?” ");
INSERT INTO dne_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Kila jhumo atehila kuchobhela, jhonge achobhila naha, bhange bhalongela lela. Bhahe, nhwalo gwa kijhonga chela, nkolongwa jwa nkomana ngonda akamanyite jhe chikipitile, ajhakwalaghalikiya bhampeleke Pauli nkate jha nyumba jha akakomana ngondo. ");
INSERT INTO dne_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Pauli pakahikita pa ngache, akakomana ngondo bhajhakuyunga nhwalo gwa bhando bhakatehi kuchocha kutenda kijhonga. ");
INSERT INTO dne_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Nhwalo lilongo likolongwa lya bhando linkengima panyuma kongo bhatehila kuchobhela, “Akomwe!” ");
INSERT INTO dne_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Akakomana ngondo bhapata bhanyingiye Pauli nkate, Pauli ajhakunkonya nkolongwa, alongila, “Nihoto kumpwepwela lilobhe mwenga?” Jhola nkolongwa jwa akakoma ngondo ajhakunyanguu, “Bho, umanye kulonge Kigilike? ");
INSERT INTO dne_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mwenga chi ma mundo bha ku Michile, lichana tu mukatumbuliche bhando bhalikane lilaghalikilo na kwalongocha akakomana ngondo elufo ncheche ade kunjenga?” ");
INSERT INTO dne_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pauli ajhakujhanguu, “Nenga ndi Nayahude, jhumelukilwe ku muche gwa ku Taliso, mu kilambo cha ku Kilikiya. Nihumii ku muche nkolongwa hake. Chonde nijhopa nongele na bhando bhamba.” ");
INSERT INTO dne_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Jhola nkolongwa jwa akakomana ngondo ajhakumpekeya pwache jha kulonge. Bhahe, Pauli ajhakujhema panane jha ngache, ajhakujhinuu lubhoko na kwalobholela bhatame nuu. Na bhando pubhakibha nuu, Pauli ajhakulonge nabho kwa lugha jha Kiebulaniya. ");
INSERT INTO dne_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Makalongo bhango na akatate bhango, unyokanikiye ngohe punikikengelela palonge jhino!” ");
INSERT INTO dne_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Pibhanyohina akilonge nabho kwa lugha jha Kiebulaniya bhajhakuchocha kubhehe nuu. Peniya Pauli ajhakulonge. ");
INSERT INTO dne_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nenga Nayahude, jhumelekilwe ku Taliso, ku kilambo cha ku Kilikiya. Nambo nelitwe pambano pano ku Yeluchalemo. Nenga nikibha mmolwa jwa Gamaliele, na nikabholitwe kulikamuu mbone mabholo ghoha gha akahoko bhito. Hengita lihengo kwa mwojho gwango ghoha kwa Chapanga ngita hela mangota chimuhenga deleno. ");
INSERT INTO dne_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nenga nikang'ahite na ata kwakoma bhando bhibhakengama ndela jha Bhambo. Nakakamwile akanalome na akakeghe na kwatabha mukipungo. ");
INSERT INTO dne_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mpiya litambiko Nkolongwa pamonga na udamo ghoha gwa akanahota bhahoto kumanya kwa uchakaka lijhambu lyenio. Kuhumii kwa bheniya nikapokii baluwa jhibhajhandikilwa Akayahude ajhito bhubhatamita ku Damasiko. Nikajhawile ku Damasiko kwakamula bhando bhibhanyeketii Kilichitu na kwaleta ku Yeluchalemo bhahadabulwe. ");
INSERT INTO dne_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Pumandikila kuhika ku Damasiko chaa chita jha muhe, papalapala lumule lukolongwa kubhoke kunane kwa Chapanga lujhakuntindila. ");
INSERT INTO dne_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nyakugwegha pahe puu, nyakujhoha lilobhe linobholila, ‘Saule, Saule nhwalo gwa nike ming'aha?’ ");
INSERT INTO dne_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Na nenga nyakukonya, ‘Mwe ma ghane, Bhambo?’ Jwenio ajhakunyanguu, ‘Nenga ndi Yecho jwa ku Nachalete jhuming'aha naha.’ ");
INSERT INTO dne_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bhala ajhango bhakaluwene lumule lola, nambo bhakajhohine lilobhe lya jhola jwalongila na nenga. ");
INSERT INTO dne_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Bhahe, nenga ngangonyita, ‘Bhambo, henge nike?’ Na jwenio ajhakujhanguu, ‘Jhema, nnyende ku Damasiko, na kwenio nannobholelwa mambu ghimipalwa kuhenga.’ ");
INSERT INTO dne_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nhwalo gwa lumule lola kubhehe ndaa hake, nikahotwi jhe kulola kabhele na peniya ajhango bhala bhajhakundandaha kwa kungamuu lubhoko ade ku muche gwa Damasiko. ");
INSERT INTO dne_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Kola ku Damasiko kukibha na mundo jhumo jwakemitwa Ananiya, mundo jwampalita hake Chapanga, na kukamula lilaghalikilo lito. Na Akayahude bhoha bhatembikiya hake. ");
INSERT INTO dne_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Jwenio akahikite kuninga, ajhakujhema pahina na nenga na kunnobholela, ‘Nnongo gwango Saule, nnole kabhele!’ Papalapala nyakuhoto kulola kabhele. ");
INSERT INTO dne_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Peniya Ananiya ajhakulonge, ‘Chapanga jwa hoko gwito umanye chakipala jwenio na kumwona jhola ntumiche jwake jwahanganicha Chapanga, na jwanyokanikiya jwenio akilongela. ");
INSERT INTO dne_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Chamalongolela bhando mambu ghala ghimaghawene na kughajhoha. ");
INSERT INTO dne_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ngoche milinde nike? Jhema mbatichwe na nnekekewe uhakaho gwino kwa liina lya Bhambo Yecho.’ ” ");
INSERT INTO dne_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Pumujhita kuhumii ku Yeluchalemo, na punikibha mukujhopa mu Nyumba jha Chapanga, nyakupata uloto. ");
INSERT INTO dne_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nikamwene Bhambo, na jwenio anobholila, ‘Mmoke kajhombe ku Yeluchalemo, nhwalo bhando bhamba nabhajhekete ndeka malobhe ghimulongela panane jhango.’ ");
INSERT INTO dne_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Na nenga nyakujhanguu, ‘Bhambo, bhando abha bhimanya chakaka nikibha mbetita munyumba jha kukonganikii Akayahude nakwapunga na kwabula bhando bhala bhibhanyeketila liina lino. ");
INSERT INTO dne_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ntumiche gwino Sitefano pakomitwa, na nenga nikibha papalapala, na nenga nikajheketile mambu ghala. Helahela kulonda ngobho ya bhala bhubhankomita.’ ");
INSERT INTO dne_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Peniya Bhambo akanobholile, ‘Nnyende, nhwalo chanintuma kutale kwa bhando bha ilambo henge.’ ” ");
INSERT INTO dne_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ade pambano, lilongo lya bhando lilinyokanikiya Pauli akilongela malobhe ghala. Nambo palongila malobhe ghanga bhakalalime hake, “Munkome mundo jwenio! Nhwalo tupala ndeka abhonekane pannema abhii ghome!” ");
INSERT INTO dne_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bhajhakujhendelela kuchobhela chobhela kongo bhanyuhita makote ghabhe na bhauchita lutukunda kunane. ");
INSERT INTO dne_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nkolongwa jwa akakomana ngondo ajhakwalobholela bhando bhake bhampeleke Pauli nkate jha nyumba jha akakomana ngondo. Ajhakwalaghalikiya bhantyale yato na akonywe, nhwalo gwa nike Akayahude bhachobhii kwa nhwalo gwake. ");
INSERT INTO dne_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nambo pubhakibha bhankongite kwa kuntyala, Pauli ajhakunkonya nkolongwa jwa akakomana ngondo jhumo, “Bho, chakaka lilaghalikilo lilongela kutyala mundo jwa ku Loma kabula jha kuhadabulwa?” ");
INSERT INTO dne_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nkolongwa jwa ngondo pajhohina malobhe gheniya, ajhakunyendela munahota gwake na kunkonya, “Bho, mipala kuhenga nike? Bho, mundo jhonjo jwa ku Loma!” ");
INSERT INTO dne_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Bhahe, na jwenio munahota nkomana ngondo ajhakunyendela Pauli na kunkonya, “Unobholele chakaka, mwenga ndi mundo jwa ku Loma?” Pauli ajhakujhanguu, “Chakaka.” ");
INSERT INTO dne_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Peniya nkolongwa jwa akakomana ngondo ajhakulonge, “Nenga hele jwa ku Loma hemile kwa mbijha yamahele kubhehe mundo jwa ku Loma.” Pauli ajhakunnobholela, “Nenga melekilwe ku Loma.” ");
INSERT INTO dne_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Papalapala bhando bhala bhubhapata kuningukiya Pauli bhajhakuhobhelela. Ata nkolongwa jwa akakomana ngondo jhola ajhakujhoghopa akamanyite Pauli mundo jwa ku Loma na akibha akongitwe minyololo. ");
INSERT INTO dne_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kilabho jhake, akakomana ngondo akapahile kumanya matakalilo gha Akayahude panane jha Pauli. Bhahe, ajhakumopola Pauli minyololo jhela, na kwalobholela bhakolo bha akapiya matambiko pamonga na udamo ghoha bhakongane. Peniya ajhakuneta Pauli na ajhakunyemeka palonge jha udamo. ");
INSERT INTO dne_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pauli ajhakwapikiya miho bhando bhala bha pa Bwalo nkolongwa na kwalobholela, “Makalongo bhango, ndamite kwa mwojho ghunangiya ngwete jhe ulemo palonge jha Chapanga ade deleno jheno.” ");
INSERT INTO dne_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Mpiya litambiko Nkolongwa Ananiya, ajhakwalobholela bhala bhubhakajhemite pahina na Pauli bhanapule mbalamande jha pannomo. ");
INSERT INTO dne_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Peniya Pauli ajhakwalobholela, “Chapanga jwenio nanapula mbalamande, mwenga mmonekana panja ngita lipamanda lilikilimwe kwa undope nhuo! Mwenga mabhene ndi mulitwekwile lilaghalikilo. Nambo mwenga mabhene mwalobholela bhando bhametule kwa kupengana na Lilaghalikilo!” ");
INSERT INTO dne_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bhando bhubhakibha pahina na Pauli bhajhakunnobholela, “Bho, mwenga munnigha Mpiya litambiko Nkolongwa jwa Chapanga?” ");
INSERT INTO dne_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pauli ajhakulonge, “Makalongo bhango, nikamanyite jhe hojho ndi Mpiya litambiko Nkolongwa. Nhwalo ikajhandikwe mu Majhandiko gha Chapanga, ‘Nkotoka kulonge ghangana ndela kwa kilongoche jwa bhando.’ ” ");
INSERT INTO dne_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Peniya Pauli pakamanyite mu Bwalo mola bhakibha Machadukayo na bhange Mapwalichayo. Bhahe, ngalongila kanonoha, “Makalongo bhango, nenga ndi Mpwalichayo, mwana gwa Mpwalichayo. Nenga nitakalilwa nhwalo nimanya bhando bhubhawile nabhayoka.” ");
INSERT INTO dne_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Pajhomolila kulonge gheniya, ujhakupitila ntaungano pakate jha Mapwalichayo na Machadukayo, na bhando bhoha bhajhakubhehe muibhogha ibhogha. ");
INSERT INTO dne_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Nhwalo gweno ukibha naha, Machadukayo bhalongila, bhando bhubhawile bhayokechwa ndeka, helahela abhii jhe ntumiche jwa kunane kwa Chapanga hilu uhuke na gwenio ubhii jhe. Nambo Mapwalichayo ujheketela mambu matato ghano. ");
INSERT INTO dne_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Bhahe, njobhelo ijhakuchocha, na bhabhola bha Malaghalikilo bhubhakibha mukibhogha cha Mapwalichayo bhajhakujhema na kutaungana hake, bhajhakulonge, “Tukibhona ndeka kibhoho kwa mundo hojho. Pange uhuke amu ntumiche jwa kunane kwa Chapanga alongi nako!” ");
INSERT INTO dne_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Bhulo pujhonjekika kujhenela, nkolongwa jwa akakomana ngondo ajhakujhoghopa akamanyite bhando bhala chibhahanjana Pauli imbembela. Peniya ajhakwalobholela akakomana ngondo bhajhende pakate jha lilongo na kumwoha Pauli kwa likakala na kumpeleka nkate jha nyumba jha akakomana ngondo. ");
INSERT INTO dne_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Na kilo jhela, Bhambo ajhakujhema pahina na Pauli, ajhakwalobholela, “Kangamala! mwakalangiye bhando bha ku Yeluchalemo panane jhango, helahela mwakalangiye bhando bha ku Loma.” ");
INSERT INTO dne_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kilabho jhake puhikita, Akayahude bhajhakutama pa Bwalo kwa chile, bhajhakulapilana chibhalye ndeka hilu kunywegha ade tunkome Pauli. ");
INSERT INTO dne_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bhando bhakatamite pa Bwalo jwenio bhakahikile bhando makome ncheche. ");
INSERT INTO dne_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bhahe, bhajhakujhenda kwabhona akapiya Matambiko bhakolongwa na akanahota, na kwalobholela, “Twenga tukilapanikiye, natulya jhe kilebhe chochoha ade tunkome Pauli. ");
INSERT INTO dne_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Bhahe, mangota pamonga na Bwalo Nkolongwa ntume lilobhe kwa nkolongwa jwa akakomana ngondo anete Pauli kwino, mukikokeya naha mipala kunyokanikiya malobhe mbone panane jhake. Na twenga natunkomela undela nakubhandiki jhe.” ");
INSERT INTO dne_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Nambo nnjomba mundo Pauli ajhakupata malobhe ghala. Peniya ajhakujhenda nkate jha chumbi cha akakomana ngondo na kunnobholela Pauli malobhe ghala. ");
INSERT INTO dne_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bhahe, Pauli ajhakunkema jhumo jwa akakomana ngondo na kunnobholela, “Mupeleke kangombo jhojho kwa mwanahota jwa akakomana ngondo nkolongwa nhwalo abhii na kilebhe cha kunnobholela.” ");
INSERT INTO dne_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Jwenio nkolo jwa ngondo jhola ajhakujhenda pamonga na kangombo kwa nkolongwa jwa akakomana ngondo na kunnobholela, “Jwatabhite jhola Pauli angemite na kunyopa ninete kangombo jhojho kwino nhwalo abhii na lilobhe lya kunnobholela.” ");
INSERT INTO dne_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nkolongwa jwa akakomana ngondo ajhakunkamula lubhoko kangombo jwenio, ajhakujhenda na jwenio pakiyepela, na kunkonya, “Kilebhe ghane chimipala kunnobholela?” ");
INSERT INTO dne_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kangombo jhola ajhakulonge, “Akayahude bhapatine kunyopa muhikiche Pauli pa Bwalo Nkolongwa. Na bhene nabhakikopokeya bhakolongwa bha pa Bwalo bhapala bhapele malobhe gha mbone panane jhake. ");
INSERT INTO dne_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nambo mwenga nkotoka kujheketela, nhwalo bhabhii bhando makome ncheche bhanyobhile na kunnendelela bhankome. Bhando abha bhalongile nabhalye jhe hilu kunywegha ade bhankome Pauli, ngohe bhalendelela luhadabulo lwino tugha.” ");
INSERT INTO dne_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nkolongwa jwa akakomana ngondo jhola ajhakuneka ajhende kangombo kongo anobholila nkotoka kunnobholela mundo malobhe gheniya. Peniya bhajhakulaghana na jwenio. ");
INSERT INTO dne_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Peniya nkolongwa jwa akakomana ngondo ajhakwakema akakomana ngondo bhabhele na kwalobholela, “Mwalenganikiye akakomana ngondo mamiya mabhele, akakomana ngondo bhubhahobhokila mu falache makome chaba, na akakomana ngondo kwa mikoha mamiya mabhele, kujhenda ku Kaisaliya uhiko gwa deleno chaa tato. ");
INSERT INTO dne_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Helahela munenganikiye liponda lya kunghegha Pauli, na mukahikiche kwa Feliki abhii njelembo, kwa nduna jwa liboma.” ");
INSERT INTO dne_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Na nkolongwa jwenio panyandikila baluwa Feliki. ");
INSERT INTO dne_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nenga Kilaudiyo Lusiya, ninyandikila mwenga nduna Feliki, ninyambucha ajhango. ");
INSERT INTO dne_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Akayahude bhakankamwile mundo jhonjo na kupala kunkoma. Nambo nenga pujhohina mundo jhonjo ndi mu Loma, nyakujhenda na lilongo lya akakomana ngondo na kukombola. ");
INSERT INTO dne_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nhwalo nipala kumanya nhwalo gwa nike Akayahude bhapala kuntakalila, peniya nyakumpeleka palonge jha Bwalo jhabhe Nkolongwa. ");
INSERT INTO dne_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nikahumbwii chibhantakalile nhwalo gwa mataungano gwabhe panane jha lilaghalikilo lyabhe, nambo akatehi ndeka yangana ndela yoyoha ade bhankome amu bhapunge mukipungo. ");
INSERT INTO dne_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Na pumanyita malobhe gha Akayahude bhatehi mipangu jha kunkoma, papa na nenga nyakuneta kwino mwenga, na nenga nyakwalobholela bhubhantakalile bhalete matakalilo ghabhe palonge jhino mwenga.” ");
INSERT INTO dne_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bhahe, akakomana ngondo bhajhakunghegha Pauli ngita chibhalobholilwe, bhajhakupeleka uhiko ghoghola ghola ade ku Antipatile. ");
INSERT INTO dne_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kilabho jhake akakomana ngondo bhubhatyangita kwa magholo bhajhakubhujha kunyumba jhabhe. Bhajhakwaleka akakomana ngondo bha liponda bhajhendelila mwanja na Pauli. ");
INSERT INTO dne_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Na bhene pubhahikita ku Kaisaliya, bhajhakupekeya nduna jwa boma baluwa jhela na kummeka Pauli pahe jwa ukindendeke gwake. ");
INSERT INTO dne_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nduna Feliki paichomita baluwa jhela ajhakunkonya Pauli, mwenga uhumii kuboma ghane? Pamanyita jwenio ahumii ku Kilikiya, ");
INSERT INTO dne_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ajhakunobholela, “Nanyokanikiya mihalo jhino pubhapala kuhika bhala bhubhantakalile mwenga.” Peniya ajhakunaghalikiya Pauli abhehe pahe jha ulonda mwatama munahota nkolongwa Helode. ");
INSERT INTO dne_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pughapetita machiko nhwano, Mpiya Litambiko Ananiya ajhakujhenda ku Kaisaliya pamonga na ighogholo na mundo jwamanyite lilaghalikilo jwakemitwa Telitulo. Na bhene bhajhakujhenda palonge jha nduna Feliki kunnobholela matakalilo gha Pauli. ");
INSERT INTO dne_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Pankemitwa Pauli, Telitulo ajhakutumbuu kuntakalila. Alongila, “Nduna Feliki, kwa malango gha ulongoche gwino tuhanganile kubhehe na uteeke. Na ntengeniche ndela jha maha kwa nhwalo gwa bhando bha kilambo chito. ");
INSERT INTO dne_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tulipokii lijhambu lende kila chehemo na kwa ndela jhojhoha kwa kuhanganila na machiko ghoha tulihanganila kone tuchenguu. ");
INSERT INTO dne_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nambo tupala ndeka kulonge kwa machaa twe, tumpembelekeya kwa umbone gwino mutujhokanikiye pandina tugha ghitulongela. ");
INSERT INTO dne_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Tumanyite mundo hojho ndi akokotwike hake, aletite kijhonga kwa Akayahude bhoha mu nnema. Kabhele jwenio ndi kilongoche jwa kikunde cha ku Nachalete. ");
INSERT INTO dne_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Na jwenio ajhighita kuitenda Nyumba jha Chapanga ikotokubhehe jha nyahinyahi, na twenga tujhakukamula. Tukapahile bhahadabule kwa lilaghalikilo lito. ");
INSERT INTO dne_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nambo nkolongwa jwa akakomana ngondo Lusiya ajhakutola mu mabhoko ghito kwa likakala. Peniya ajhakulonge bhubhantakalile bhahike palonge jhino. ");
INSERT INTO dne_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Na anda munkonyite mwenga mabhene naumanya mambu ghoha ghututakalile hojho.” ");
INSERT INTO dne_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Akayahude bhajhakubhehe pamonga mu matakalilo gheniya, bhalongila jwenio ahengita gheniya kwa uchakaka. ");
INSERT INTO dne_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Peniya, nduna Feliki jwa Boma ajhakunangiya Pauli nginyililo kwa lubhoko alongila, na jwenio Pauli ajhakulonge. “Nimanya mwenga ndi mmii nnyomola mihalo jwa kilambo chenje kwa yaka yamahele. Nihangana kukikengelela palonge jhino. ");
INSERT INTO dne_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Mihoto kumanya mabhene kijhojhoho tugha ghakapitite jhe machiko kome na mabhele nyakujhenda ku Yeluchalemo kunyinamila Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Akayahude bhakangoli ndeka nikataungana na mundo jhojhoha mu Nyumba jha Chapanga hilu kukwelekeya bhando munyumba jha kukonganikii Akayahude amu chehemo jhenge jhojhoha. ");
INSERT INTO dne_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Nambo bhene bhakahotwi ndeka kulangiya ilebhe ibhandakalile palonge jhino ndi chakaka. ");
INSERT INTO dne_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Chinijheketela kukikengelela palonge jhino chenje, nenga ninyinamila Chapanga jwa akahoko bhito nikengama ndela jhela bhene bhikema ndela jhuwange. Nenga nijheketela malobhe ghoha ghighajhandikwe mukitabo cha lilaghalikilo na mu itabo ya milondole bha Chapanga. ");
INSERT INTO dne_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nenga nihobholela Chapanga, na bhene bhabhii mu kihobholelo chenie, bhando bhaumbone na bhanganandela bhoha chibhayokichwa. ");
INSERT INTO dne_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Na nenga nikangamala machiko ghoha kulangiya mwojho gwanga ulemo palonge jha Chapanga na palonge jha bhando. ");
INSERT INTO dne_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Punyomolila kutama kutale kwa yaka twe, nikabhujhite ku Yeluchalemo kwatangatila bhando bha kilambo chango na kupiya litambiko. ");
INSERT INTO dne_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Punyomolila kuhenga unyagho gwa ujhelebhulo ndi pibhangolila mu Nyumba jha Chapanga nikahenga gheniya. Likibha ndeka lilongo lya bhando hilu kijhonga. ");
INSERT INTO dne_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Nambo bhakibha Akayahude bhange bhabhokila ku Asiya, na bhene ndi bhapalitwa palonge jhino anda bhakwete lilobhe lyolyoha panane jhango. ");
INSERT INTO dne_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Amu, mwaleke bhando pamba bhalonge hotuhotu ulemo ghane ghubhauwene kwa nenga punyemita palonge jha udamo Nkolongwa, ");
INSERT INTO dne_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","nga malobhe ghanga tugha ghinongile nyemite palonge jhabhe ngoheno: ‘Nhadabula deleno nhwalo nihobholela kubhehe bhubhawile nabhayokechwa.’ ” ");
INSERT INTO dne_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Peniya, Feliki jwakamanyite mbone mambu gha ndela jha Bhambo, ajhakuijhemeka mihalo yenio alongila, “Nahadabula mihalo jhene, nkolongwa jwa akakomana ngondo Lusiya papala kuhika pambano.” ");
INSERT INTO dne_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Peniya, ajhakunnobholela jhola nkolongwa jwa akakomana ngondo ameke Pauli muulonda, nambo abhehe na pwache pandina na akakoche mundo bhakotoka kuhibhilikilwa kuntangatila. ");
INSERT INTO dne_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pighapetita machiko ghandina, Feliki ajhakuhika pamonga na nhwana mundo liina lyake Dulusila akibha Nhyahude. Ajhakulaghalikiya bhankeme Pauli, na jwenio ajhakunyokanikiya malobhe ghalongila kwa kunyeketela Yecho Kilichitu. ");
INSERT INTO dne_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nambo Pauli patumbwila kulonge ilebhe yapala Chapanga, na kukihibhilikiya namwete na lichiko lya luhadabulo luluhika. Feliki ajhakujhoghopa na kulonge, “Ngoheno mihoto kujhenda, chininkema kabhele anda mbatite pwache.” ");
INSERT INTO dne_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Machiko ghagha akibha ahobholila Pauli nahonga mbijha. Kwa nhwalo gwenio Pauli akemitwa pipipi kulonge nako. ");
INSERT INTO dne_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Puipetita yaka ibhele, Polikiyo Fesito ajhakutola pwache jha Feliki kubhehe nduna. Nhwalo Feliki akapahii kubhehe nkoche jwa Akayahude, ajhakuneka Pauli mukipungo mwenio. ");
INSERT INTO dne_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pighapetita machiko matato Fesito ajhakubhoka ku Kaisaliya nu kujhenda ku Yeluchalemo. ");
INSERT INTO dne_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kola bhakolo bha Matambiko na ilongoche ya Akayahude bhajhakuntakalila Pauli palonge jhabhe, bhajhakumpembelekeya Fesito. ");
INSERT INTO dne_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Abhatendele lijhambu lyambone kwa kumpeleka Pauli ku Yeluchalemo, nhwalo bhakatehi mpangu bhankome undela. ");
INSERT INTO dne_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nambo Fesito ajhakujhanguu, “Pauli nahighalika mukipungo koko ku Kaisaliya, na nenga nikilenganikiya kujhenda kwenio. ");
INSERT INTO dne_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bhahe, mwaleke ilongoche bhino tulongohane na nenga ku Kaisaliya na bhene bhakalongele matakalilo panane jhake anda kibhii kibhoho chalemwite.” ");
INSERT INTO dne_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fesito ajhakutama nabho kwa machiko nane amu kome, na ajhakubhujha ku Kaisaliya. Kilabho jhake ajhakutama nkate jha nyumba jha mihalo na kwalobholela bhannete Pauli palonge jhake. ");
INSERT INTO dne_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Pubhanetita Pauli, Akayahude bhubhaumila ku Yeluchalemo bhala bhajhakuntindindila na kubhoha matakalilo ghamahele panane jha Pauli nambo bhakahotwi j