﻿USE sofia;
DROP TABLE IF EXISTS sofia.djr_vpl;
CREATE TABLE djr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES djr_vpl WRITE;
INSERT INTO djr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dhuwandja yarraṯaŋur wäwa'mirriŋuwal, ga yan bili ga gäthu'mirriŋuwal, ga yan bili ga märi'mumirriŋuwal, ga yan bili ga yuṯawalnha bäpa'mirriŋuwal. Dhuwandja Djesuny yarraṯaŋur, ŋunhi ŋayi Maŋutji-dhunupayanhawuy God-Waŋarrwuŋ, ŋunhi ŋayi mala-bunhawuynydja Daybitkuŋ, ga ŋayiny Daybittja mala-bunhawuy Yipurayimguŋun. ");
INSERT INTO djr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ga ŋayiny Yipurayimdja bäpa'mirriŋu Yitjakkun, ga ŋayiny Yitjaktja bäpa'mirriŋu Djaykupku, ga Djaykuptja bäpa'mirriŋu Djudaw, ga wäwa'mirriŋuw walalaŋ nhanukalaŋaw, ");
INSERT INTO djr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ga Djudany bäpa'mirriŋu Beratjku ga Djeraw ŋunhi maṉḏaŋ ŋäṉḏi'mirriŋuny Dayma, ga Beratjtja bäpa'mirriŋu Yitjurungu, ga Yitjurundja bäpa'mirriŋu Rämgu, ");
INSERT INTO djr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ga Rämdja bäpa'mirriŋu Minadapku, ga Minadaptja bäpa'mirriŋu Nätjungu, ga Nätjundja bäpa'mirriŋu Djalmangun, ");
INSERT INTO djr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ga Djalmandja bäpa'mirriŋu Bawatjku ga Rayap nhanŋu Bawatjkuny ŋäṉḏi'mirriŋu, ga ŋayiny Bawatjtja bäpa'mirriŋu Wopitku ga ŋäṉḏi'mirriŋuny nhanŋu Ruth, ga Wopittja bäpa'mirriŋu Djitjiw, ");
INSERT INTO djr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Djitjiny bäpa'mirriŋu Daybitkun, ŋunhi ŋayi Ŋurruḏawalaŋu buŋgawa. Ga Daybittja ŋunhi bäpa'mirriŋu Djalamangun, ga ŋäṉḏi'mirriŋuny nhanŋu Djalamangu yäku Bätjiba ŋunhi ŋäthilnydja ŋayi ŋunhiyiny miyalk ḏirramuw yäkuw Yuriyaw. ");
INSERT INTO djr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ga Djalamandja bäpa'mirriŋu Riyapawamgu, ga ŋayiny Riyapawamdja bäpa'mirriŋu Yabitjaw, ga Yabitjany bäpa'mirriŋu Yätjaw, ");
INSERT INTO djr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ga Yätjany bäpa'mirriŋu Djutjapatku, ga Djutjapattja bäpa'mirriŋu Djoramgu, ga Djoramdja bäpa'mirriŋu Yutjayaw, ");
INSERT INTO djr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ga Yutjayany bäpa'mirriŋu Djothamgu, ga Djothamdja bäpa'mirriŋu Yayatjku, ga Yayatjtja bäpa'mirriŋu Yitjakayaw, ");
INSERT INTO djr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ga Yitjakayany bäpa'mirriŋu Manatjaw, ga Manatjany bäpa'mirriŋu Yämungu, ga Yämundja bäpa'mirriŋu Djawtjayaw, ");
INSERT INTO djr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ga Djawtjayany bäpa'mirriŋu Djiyawtjingu ga wäwa'mirriŋuw mala nhanukalaŋaw, ga balanyamirriyyin ŋunhi Djotjiya ga nhanŋu gäthu'mirriŋu walal gan nhinan ŋunhili Yitjural bala yan miriŋun walalaŋ bunan, bala bumarnha Yitjuralnhany bäpurruny, yindin dhika mari malŋ'thurr, ga wiripuwurrunhany gan ŋunhi yolŋuny walalany djaw'-djawyurra balan bitjarra wäŋalil yäkulil Babilunlila. ");
INSERT INTO djr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ga beŋuryiny dhurrwaraŋur, walalnydja ŋunhi Yitjuralpuynhany yolŋuny walalany gan ŋaŋ'ŋaŋ'thurra balan Babilunlila wäŋalil yäkulil. Dhiyaŋuwurruyiny ga mala-ŋurrkanhayŋuy maŋutji-lakaram ŋanyanhan Djesu-Christnhan dhawal-guyaŋanhawuynha. Yo, manymak ŋayiny Djiyawtjiny bäpa'mirriŋu Djiyalṯiyalwu, ga ŋayiny Djiyalṯiyalnydja bäpa'mirriŋu Djirabaybulwu, ");
INSERT INTO djr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ga Djirabaybulnydja bäpa'mirriŋu Yabiyutku, ga Yabiyuttja bäpa'mirriŋu Yiliyakimgu, ga Yiliyakimdja bäpa'mirriŋu Yätjuw, ");
INSERT INTO djr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ga ŋayiny Yätjuny bäpa'mirriŋu Djädukku, ga Djäduktja bäpa'mirriŋu Yaykimgu, ga Yaykimdja bäpa'mirriŋu Yiliwutku, ");
INSERT INTO djr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ga Yiliwuttja bäpa'mirriŋu Yiliyatjaw, ga ŋayiny Yiliyatjany bäpa'mirriŋu Mathan'ku, ga Mathan'tja bäpa'mirriŋu Djaykupkun. ");
INSERT INTO djr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ga ŋayiny Djaykuptja bäpa'mirriŋu Djawutjipkun, ŋunhi ŋayi Meriwnha dhuway'mirriŋu, ga Meriny ŋäṉḏi'mirriŋu nhanŋu Djesuwnha, ŋunhi ŋayi Maŋutji-dhunupayanhawuynha. ");
INSERT INTO djr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ga 14-mirr walal mala-ŋurrkanhamin nhanŋuny Yipurayimguny djamarrkuḻi', ga yan bili-i-i ga Daybitkal wapthurr, ga beŋur Daybitkalnydja walal bulu 14-mirryi yan mala-ŋurrkanhamin, yan bili-i-i ga ŋunhi walu ŋayathaŋal ŋunhi walalany Yitjuralnhan bäpurruny miriŋuynha mala djaw'-djawyurr balan wäŋalil yäkulil Babilunlila. Ga bulu beŋuryiny muka walal dhurrwaraŋur 14-mirryi yan mala-ŋurrkanhamin, ga yan bili ga ŋayin Garraynha dhawal-guyaŋan Djesu-Christnha ŋunhi ŋayi Maŋutji-dhunupayanhawuynha. ");
INSERT INTO djr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ga ŋäṉḏi'mirriŋuny nhanŋu ŋunhi Djesuw Meriny, miyalktja ŋayi ŋunhi dhawu'mirrnydja ḏirramuw yäkuw Djawutjipku, ga yurrnha maṉḏa ŋunhi märranhaminany, ŋayiny ŋunhi Meriny ŋäthil yan marŋgithinany ŋunhi ŋayi yothumirriyinany Dhuyu-Birrimbirrwuŋ. ");
INSERT INTO djr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ga ŋayiny ŋunhi Djawutjiptja dhuway'mirriŋuny nhanŋu Meriw, dhuwurr-dhunupa balanya yolŋu ga bitjarra ŋayi gan ŋunhi guyaŋanany ŋayi dhu yaka gora gurrupan ŋanya Meriny bukmakkal nhakun yolŋuwal walalaŋgal bala ganarrthaman ŋanya, bala ŋayi balaŋ gayulnha ŋunhi djämany bitjanayiny. ");
INSERT INTO djr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ga ŋunhi ŋayi gan bitjarryiny guyaŋan, God-Waŋarrwuny dhäwu-gänhamirrnydja bunanan nhanŋu Djawutjipkuny mäwa'wurra, ga bitjarr ŋayi ŋunhi nhanukal waŋanany, “Djawutjip mala-bunhawuy Daybitkuŋ, yaka barrari märranharaw Meriwnydja. Märranhamirra maṉḏa, märr nhuŋu ŋayi dhu miyalknha, bili ŋunhiyiny yothu ŋayi ga gäma beŋur Dhuyu-Birrimbirrwuŋ gurrupanawuy. ");
INSERT INTO djr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ga Meriwuŋuny dhu dhawal-guyaŋany yothuny ḏirramun, ga yäku-gurrupananawuynydja dhu ŋayi ŋunhi Djesu. Ga ŋayin dhu ga ŋunhi Djesuynha walŋakumany yolŋunhany walalany nhanŋuwuy ŋayi beŋurnydja ŋunhi walalaŋgiyingal dhuwurr-yätjŋurnydja romŋur,” bitjarra ŋayi gan ŋunhi ŋuriŋiyiny dhäwumirriynydja lakaraŋal Djawutjipkuny. ");
INSERT INTO djr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ga bitjarrnydja dhuwal maḻŋ'thurr, märr walalnydja dhu yolŋuynydja walal dharaŋana dhuwali yuwalkkuman yan, ŋunhi ŋäthil gan God-Waŋarr waŋan ŋuliwitjarr djawarrkmirriwal bitjarr, ");
INSERT INTO djr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ga yuṯa dhu ḻuni miyalk yothumirriyirr, ga ḏirramun nhanukuŋ dhu ŋunhi yothuny dhawal-guyaŋi, ga yäku-lakaramany walal ŋanya dhu ga Yimannyuwal, mayali' God-Waŋarrnydja dhuwanna limurruŋgal.” ");
INSERT INTO djr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ga ŋunhi ŋayi Djawutjip rur'yurrnydja yakurrŋurnydja, bala ŋayi märraŋal Merinhany wäŋalila nhanukiyingal ŋayi, bitjarr yan bili nhakun ŋunhi God-Waŋarrwal dhäwu-gänhamirriymirriy gan lakaraŋal nhanukal. ");
INSERT INTO djr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Yo, ŋunhi maṉḏa märranhaminany, yurr ŋäthilnydja maṉḏa ŋunhi bäyŋu ŋula ŋorranha waŋganyŋurnydja ga ŋula galŋa-ŋayathanhaminya, yan bili ga yothu nhanŋu ḏirramu dhawal-guyaŋan. Bala Djawutjipthuny ŋanya yäku-nhirrparnydja Djesun. ");
INSERT INTO djr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yo, Djesuny ŋunhi dhawal-guyaŋan wäŋaŋur Bithiliyam, makarrŋurnydja Djudiya, balanyamirriy waluy ŋunhi ŋayi gan ŋurruḏawalaŋu nhinan yäku Yarit ŋunhi ŋunhiyiny wäŋa makarr nhanukal djägaŋur. Ga balanyamirriy bili yan, gali'-dhimurruŋurnydja barrkuŋurnydja wäŋaŋur, ḻiya-djambatjmirrnydja yolŋu walal marrtjindhi, yurr walal ŋunhi djambatjnha ḻiyany mala-djarr'yunarawnydja ganyuwnydja malaŋuw. ");
INSERT INTO djr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ga ŋunhi walal gan marrtjinany, ŋunhiwurryiny ḏirramuwurr gaḏamanmirrnydja, bala bunanan wäŋaŋur Djurutjalamnha, ga ŋunhiliyi walal dhä-birrka'yurr bitjarr, “Wanha dhika yuṯany buŋgawa be ŋurruḏawalaŋuny Djuw-malawnydja? Ŋunhi ŋayi barpuru dhawal-guyaŋa, wanha wäŋaŋurnydja? Bili napurr barpuru dhuwal nhäma nhanŋu ganyu garrwarthinyawuy ŋunhal gali'-dhimurruŋur, bala ŋanapurr dhuwal marrtjinan rälin, märr napurr dhu buku-ŋal'yun nhanŋu ŋurikiyi yuṯaw ŋurruḏawalaŋuw.” ");
INSERT INTO djr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ga ŋunhi ŋayi ŋurruḏawalaŋuynydja Geŋ-Yaritthuny ŋäkulnydja walalaŋguŋ dhäwuny, bala yan ŋayi mirithinan dhika ŋoy-dhärranany, ga walal ŋunhi yolŋu walal wäŋa Djurutjalambuy ga bitjarryi bili maḏakarritjthin. ");
INSERT INTO djr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Bala ŋayi Yaritthuny ḻuŋ'maraŋala walalany waŋganylila ŋunhiyiny ŋunhi ŋurruŋu djirrikaymirrinhany walalany, ga Rom-marŋgikunhamirrinhany walalany ŋunhi walal ŋuli ganha marŋgikunha Mawtjitjkalaŋawnha Romgu, bala ŋayi gan dhä-birrka'yurra walalany bitjarra, “Wanhal dhika ŋayi dhu be Maŋutji-dhunupayanhawuynydja dhawal-guyaŋa?” ");
INSERT INTO djr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ga walalnydja buku-bakmaraŋal balany nhanŋuny bitjarra, “God-Waŋarrwuŋuny dhawu'mirriyanhawuy dhu dhawal-guyaŋa ŋunhal wäŋaŋur yäkuŋur Bithiliyam makarrŋurnydja Djudiya. Bili baman'tja God-Waŋarrwal djawarrkmirriy dhäwu rulwaŋdhurr bitjarr gam', ");
INSERT INTO djr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Dhuwaliyi Bithiliyamdja wäŋa makarrŋur Djudiyany, bäydhi ŋayi dhuwali nyumukuṉiny'tja wäŋa, yurr mirithirr dharrpal maŋutjiŋur Djudiyapuyŋuwalnydja buŋgawawal malaŋuwal; bili dhiyaliyin dhu ŋunhi wäŋaŋur ŋurru-warryunayŋuny maḻŋ'thun, ga mala-warryundja ŋayi dhu ga ŋarrakun yolŋunhany walalany Yitjuralnhan malany.’” ");
INSERT INTO djr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bala ŋayi Yarittja wäthurra gayulnha yan ŋurikiyiny gaḏamanmirriwnydja ḏirramuwurruŋ, ŋunhi walal gali'-dhimurruwuy wäŋapuy, ga dhä-birrka'yurra ŋayi walalany bitjarra, “Nhätha ŋayi ŋunhi yuwalktja ŋunhiyiny ganyuny maḻŋ'thun? Nhaliy waluynydja.” ");
INSERT INTO djr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bala yan ŋayi djuy'yurra walalany balan Bithiliyamlila. “Gatjuy marrtjin walal ŋini, ga ḻarruŋun ŋurikiyin yothuwnha, ga ŋuli nhuma dhu maḻŋ'maramany ŋanya, ga räliyi nhuma dhu roŋiyirr ga lakaram ŋarrakalnydja marŋgikum ŋarrany, märr ŋarrany muka dhu buku-ŋal'yun nhanŋu,” ga bitjarr ŋayi waŋanany walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bala walal ŋuriŋiwurruyyiny gaḏamanmirriynydja ganarrthaŋala Djurutjalamdja wäŋa, bala yan marrtjinan. Ga bulu nhakun ŋunhiyi bili ganyu maḻŋ'thurr, ŋunhi walal ŋäthil nhäŋal garrwarthinyawuy ŋunhal gali'-dhimurruŋur, ga ŋayipiny gan ŋunhi ganyuny marrtjin ŋurruŋun, ga walalnydja marrtjin ŋapa-munguyurra ŋanya ganyunhan, ga yan bili-i-i, ga gulyurrnydja ŋayi ŋunhi ganyuny ŋunhilin bili yan wäŋaŋurnydja, ŋunhi wanhal gan yothu Djesu ŋorran. ");
INSERT INTO djr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ga mirithinan walal ŋunhi ŋoy-djulŋithinan goŋmirriyinan manapar ŋunhi walal nhäŋalnydja ŋunhiyi ganyunhany. ");
INSERT INTO djr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bala yan walal gulŋi'-gulŋiyinan ŋunhiwiliyin bala'lila, bala walal yan bun'kumu-djipthurra, ga buku-ŋal'yurra nhanŋu yothuwnha. Ga yurrnha walal bathiny mala walalaŋguwuy walal dhäny-ḻapḻapmaraŋal, bala marrtjin gurruparnha ŋanya yothunhany mundhurrnha mala, mel-wiḏi'mirr bulay, ga wiripuny buŋgan bäw yäku biraygintjan', ga wiripuny merr, balanya nhakun wiyika' ŋäminminyawuy buŋgan bäwthi yan. ");
INSERT INTO djr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ga ŋunhi walal dhawar'yurrnydja mundhurrŋurnydja mala gurrupanaŋur, bala ŋayiny God-Waŋarrnydja waŋanan walalaŋgal mäwa'wurrnydja bitjarrnha, “Yakan nhuma dhu balayiny roŋiyirr Yaritkalnydja.” Bala yan walal ŋunhi roŋiyinany walalaŋgiyingalnydja wäŋalil wiripuŋuwurra dhukarrkurrnydja. ");
INSERT INTO djr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ga ŋuliŋuryiny dhurrwaraŋur ŋunhi walal gaḏamanmirriynydja ganarrthaŋalnydja ŋanya Merinhany ga Djawutjipnhany, bala God-Waŋarrwuny dhäwu-gänhamirrnydja maḻŋ'thurra Djawutjipkuny mäwa'kurra, ga waŋan ŋayi gan nhanukal bitjarr, “Rur'yurra. Märraŋun dhuwali yothunhany ga ŋäṉḏi'mirriŋunhany, bala marrtjin. Yurr bondin nhuma dhu marrtjiny balan bitjanna wäŋalil makarrlil yäkulil Yetjiplila, ga ŋunhilin nhuma dhu ga nhinany galkundja, ga bäy ŋarra dhu boŋguŋ dhäruk djuy'yurr nhumalaŋ, bili Yarittja dhu ḻarruŋun dhiyakiyiny yothuwnydja bunharawnha.” ");
INSERT INTO djr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bala yan ŋayi Djawutjiptja rur'yurra, ga gaḏaymar ŋayi ŋäṉḏi'mirriŋuny ga yothunhany, ga ŋuriŋi bili yan munhay walal walalaŋguwuynydja wäŋa ganarrthaŋal, bala ŋurruyirr'yurra marrtjinan balan makarrlil yäkulil Yetjiplila. ");
INSERT INTO djr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ga nhinanany walal gan ŋunhiliyin Yetjipnha makarrŋur wäŋaŋur, ga yan bili-i-i, ga bäy ŋayi Yarit dhiŋgaŋal. Bili be bala ŋäthil baman', God-Waŋarr dhäruk gurrupanmin nhanukalaŋuwal djawarrkmirriwal bitjarr gam', “Wäthurrnydja ŋarra ŋunhi gäthu'mirriŋuwnydja ŋarrakalaŋaw dhawaṯmaraŋalnydja ŋanya beŋura Yetjipŋura wäŋaŋur.” ");
INSERT INTO djr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ga ŋunhiliny Djurutjalamdja ŋayiny Yarittja gan galkurra dhäwuwnha buku-roŋanmaranharaw gaḏamanmirriwuŋun yolŋuwuŋ walalaŋguŋ, yurr walalnydja bäyŋun roŋiyinya nhanukal, bala yan ŋayiny ŋunhi Yarittja mirithinan dhika maḏakarritjthinany. Bala ŋayi djuy'yurra djämamirrinhan mala nhanŋuwuy balayin Bithiliyamlila, ga wiripu wäŋa mala ŋunhi walal gan galkiwatj dhärran, ḻarruŋalnha walal gan ḏirramuwurruŋgun djamarrkuḻiw' bunharawnha, dhuḏi-wapthunamirriw walalaŋ, ga gaḻ'yunamirriw walalaŋ, ga djaṉ'tjaṉmirriw, bili ŋunhiyiny djamarrkuḻi' dhawal-guyaŋanhawuy balanyamirriwuy yan bili walupuynydja rrambaŋiwuy ŋunhi walal gaḏamanmirriy ŋäthil nhäŋal ganyu. ");
INSERT INTO djr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ŋäthilnydja baman'tja God-Waŋarrwal djawarrkmirriy yäkuy Djirimayay dhäruk nhirrpar bitjarr gam', ");
INSERT INTO djr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ŋunhal Rämaŋurnydja wäŋaŋur gan dhawaṯthurr yindin mirithirra rirrakay nyä'yunminyawuynha milkarrin. Ga miyalk yäku Ratjul-nydja gan ŋäthinan nhanukiyingalaŋawnydja ŋayi djamarrkuḻiw' warwuyurra gan, ga yakan ŋayi gan ŋunhi djälthinany ŋanya dhu ŋayaŋu-mulka'kumany, ga ŋäthinany ŋayi gan ŋunhi bili nhanŋu ŋunhi djamarrkuḻiny' bukmaknha dhiŋga'-dhiŋgaŋala.” ");
INSERT INTO djr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ga dhäŋur beŋuryiny ŋunhi ŋayi Geŋ-Yarittja dhiŋgaŋal, ga maṉḏany gan ŋunhi Djawutjiptja ga Meriny baḏak yan nhinan ŋunhili banydjin yan Yetjip makarrŋur wäŋaŋur. Bala ŋayiny God-Waŋarrwuny dhäwu-gänhamirrnydja bunanan nhanŋuny Djawutjipkuny mäwa'wurra, ");
INSERT INTO djr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ga waŋan ŋayi nhanukal bitjarr, “Djawutjip, rur'yurra. Märraŋun yothunhany ga ŋäṉḏi'mirriŋunhany, bala marrtjin roŋiyinan balan wäŋalil Yitjuralilnha, bili ŋunhiwurryiny yolŋu walal ŋunhi walal gan djälthin bunharaw dhiyakiyi yothuw, bilin walal rakunydhinan.” ");
INSERT INTO djr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bala yan ŋayi Djawutjiptja rur'yurra, ga märraŋal ŋayi yothuny ga ŋäṉḏi'mirriŋuny, bala yan walal marrtjinan roŋiyinan balayin Yitjurallila. ");
INSERT INTO djr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ga ŋunhi walal galki Yitjuralnydja wäŋa ŋayathaŋal, bala ŋayi ŋäkula Djawutjipthuny Yätjilatj-nhany yäkuny Yaritkuny gäthu'mirriŋuny, ŋunhi ŋayin yuṯany ŋurruḏawalaŋu gan nhinan ŋurikiyiny wäŋaw makarrwu Djudiyapuywuny, ga ŋayiny ŋunhi Djawutjiptja märr barrarindhi ŋurikiyiny wäŋaw nhinanharaw. Ga bulu beŋuryi dhurrwaraŋur Garraywal dhäwumirriy lakaraŋal nhanŋu Djawutjipku mäwa'kurryi yan bitjarr, “Gatjuy marrtjin bala yan, ga nhininy ŋunhilin wäŋaŋur makarrŋur yäkuŋur Galalin.” Bala walal marrtjinan yan, ");
INSERT INTO djr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ga nhinanany walal wäŋayaŋalnydja ŋunhilin Nätjuritjnha wäŋaŋur makarrŋurnydja Galalin. Bili ŋäthilnydja baman'tja God-Waŋarrwal djawarrkmirriy lakaraŋal bitjarr gam', “Walal ŋanya dhu ga lakaramany Nätjuritjpuynha yolŋu.” Ga bitjarryiny ŋunhi yuwalknha yan maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ga ŋula nhämunha' dhuŋgarra djuḻkthurr, bala ŋayiny Djondhuny ŋunhi ŋayi walalany gan ḻiya-ḻupmaraŋal yolŋu'-yulŋuny ŋurruyirr'yurra marrtjin djawarrkthurra ŋunhiliny gawarrka'ŋurnydja wäŋaŋur ḏiltjiŋurnydja yäkuŋur Djudiyany. ");
INSERT INTO djr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ga bitjarra ŋayi gan ŋunhi lakaraŋalnydja walalaŋ gam', “Way walal bilyurra walal, bala yan ganarrthula nhumalaŋguwuy nhuma dhuwurr-yätjkurrnydja rom mala, bili God-Waŋarrwuny ŋunhi rom galki dhu maḻŋ'thunna.” ");
INSERT INTO djr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ŋäthilnydja baman'tja God-Waŋarrwal djawarrkmirriy yäkuy Yitjayay gan lakaraŋal waŋganynha yolŋuny yäkuny Djonnha, ŋunhi ŋayi dhu yalalaŋumirr marrtji dhuḏitj. Ga bitjarra ŋayi gan ŋunhi wukirriny gam', “Ŋunhalnydja nharaŋurnydja wäŋaŋur ḏiltjiŋurnydja yolŋu dhu boŋguŋ djawarrkthurr, yurr waŋiny ŋayi dhu gi ŋunhiliyi biyakun gam', ‘Walal, girri'-ŋamathin ga dhukarr-buŋun Garraywuny, ga dhukarrnydja nhanŋu marrtjinyarawnydja biyakun dhunupayaŋun!’” Yo, ga yuwalknha yan ŋayi gan ŋunhi Djondhuny bitjarryiny lakaraŋal ŋunhiliny ŋayilpi'ŋurnydja wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ga dhaṯthunminany ŋayi gan ŋunhi girriyny'tja gamuḻwal bulkay', ga biralyuny ŋayi gan ḏapmaranhamin ga barrwaṉ'thuyi yan, ga ḻukanhany ŋayi ŋuli ganha rumbal-ḏetjthinyan ga wiripuny guku. ");
INSERT INTO djr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ga dharrwan dhika yolŋuny walal marrtjin ŋänharawnydja nhanŋu beŋur Djurutjalamŋur ga beŋur bala Djudiyaŋur makarrŋur wäŋaŋur, ga beŋur wäŋaŋur galki Djodan mayaŋ'ŋur, ga ḻika'-ḻikanŋurnydja yolŋu walal marrtjindhi nhänharaw nhanŋu Djongu. ");
INSERT INTO djr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ga dharrwan gan ŋunhi yolŋuny walal waŋan bitjarr, “Yuwalk muka ŋarrany dhuwal dhuwurr-yätjkurr yolŋu. Ŋarrany dhu dhuwal bilyunna, bala yan ganarrthaman ŋarrakuwuy ŋarra dhuwurr-yätjkurrnydja mala.” Bala ŋayi gan Djondhuny buku-ḻupmaraŋala walalany ŋunhilin Djodannha mayaŋ'ŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ga bitjarryi bili walalnydja ŋunhi Baratjiny mala marrtjin nhanukal Djongal, ga wiripuny yolŋu walal yäku Djatutji mala balayi marrtjindhi nhanukal buku-ḻupmaranharaw. Ga ŋunhi ŋayi walalanhany Djondhu nhäŋal, bala yan ŋayi waŋanany bitjarra walalaŋ gam', “Nhumany dhuwal bäpin mala, mayali'-ganhamirra mala. Yolthu nhumalany dhuwal waŋanany balanyarawyiny, yanbi nhuma dhu waṉḏirr winya'yun God-Waŋarrwalaŋaŋurnydja, ŋunhi ŋayiny dhu galki bunan, dhä-gir'yunarawnha nhumalaŋ? ");
INSERT INTO djr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Ma'! nhumany bilyurra yuwalkkuŋun yan, bala djäman yan manymaknha. Yakan waŋi biyakuny, ‘God-Waŋarryuny ŋarranhany dhu bäyŋu warray dhä-gir'yurr, bili ŋarrakuny dhuwal mala-ŋurrkanhayŋu Yipurayim warray.’ Yaka yan nhuma dhu ga ŋunhi bitjandhiny lakaranhamirr ŋapatjkunhamirrnydja nhumalanhawuynha nhuma. Bili God-Waŋarryun ga ŋunha ganydjarrnydja ŋayatham, ŋayi balaŋ märraŋ dhuwal guṉḏa mala, bala ŋayi balaŋ djäman bilmaraŋun yolŋukuŋun dhipuŋurnydja ŋunhi guṉḏaŋurnydja, bala walalnha balaŋ djamarrkuḻiny' nhanŋu Yipurayimguny. ");
INSERT INTO djr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","God-Waŋarrnydja ga dhärra girri'-ŋamathinyawuynha, bitjan nhakun yolŋu ŋuli ga dhärra goŋ-ḏakulmirr djatthunarawnha, ŋayi dhu djatthunna dhä-mälkum yan yuṯuŋgurrwurr, dharpanhany malaŋuny. Ga ŋunhiyiny dharpa malany borummiriwnhany, ŋayi dhu bitjandhi bili yan djatthun bala ŋayi dhu ŋurrkaman gurthalila.” ");
INSERT INTO djr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Bala ŋayiny Djondhuny lakaraŋal balany walalaŋguny bitjarr, “Ŋarrany ŋuli ga dhuwal nhumalany gapuy warray yan waŋganydhu buku-ḻupmaram, ŋunhi ga maŋutji-lakaram ŋunhi nhumany bilin gan bilyurra beŋurnydja ŋunhi dhuwurr-yätjŋurnydja romŋur nhumalaŋgiyingal nhuma. Ŋany ŋula yol dhu boŋguŋ yalalany dhurrwaraŋur ŋarrakalnydja buni mirithirra yindi, ganydjarr-ḏumurra djuḻkmaraman ŋayi ga ŋarranhany. Ga yaka ŋarra dhuwal ganany' dhapathuŋ'kuny gänharaw nhanukalaŋaw. Ŋayiny nhumalany dhu gi ḻiya-ḻupmaraŋ Dhuyu-Birrimbirryun ga gurthaynha. ");
INSERT INTO djr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ga ŋayin dhu ga ŋunhiyin yolŋu dhärriny girri'-ŋamathinyawuynydja, mala-djarr'yunarawnydja barrkuwatjkunharawnydja yolŋuwnydja walalaŋ. Bitjanna ŋayi dhu ŋunhi marrtji rurr'rurryundja nhakun ŋuli marrtji yolŋuy djalk-djalkthun ŋatha birrali maŋutji, ŋunhi ŋayi ŋuli ga gänaŋ'maraman barrkuwatjkuman beŋurnydja ŋunhi dhukunŋurnydja. Bala ŋayi dhu ŋathany ŋunhi ḏarrtjalktja rulwaŋdhunna balan nhanukiyingala ŋayi wäŋalil, ga ŋunhi dhukundja ŋunhiŋuwuyyi ŋathapuynydja ŋayi dhu djalkthunna gurthalila, ŋunhiwiliyin gurthalil ŋunhi ga nhäran bitjanna bili yan bulŋuyukthinyamiriwnha.” Ga bitjarryin ŋayi gan ŋunhi Djondhuny lakaraŋalnydja yolŋu'-yulŋuwalnydja. ");
INSERT INTO djr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yo, Djesuny gan ŋunhi baḏak nhinan ŋunhiliyi makarrŋur wäŋaŋur yäkuŋur Galali. Ga beŋuryin wäŋaŋur ŋayi balany marrtjin Djodinlilnydja mayaŋlil, märr ŋayi dhu Djondhuny ŋanya Djesunhany ḻiya-ḻupmaraman ŋunhiliyin mayaŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yurr ŋayiny nhanŋu Djondja bitjarr warray waŋan Djesuwnydja gam', “Nheny dhuwal ŋarrakal warray marrtjin buku-ḻupmaranharaw? Nhe balaŋ dhuwal yuwalktja ŋarrany muka ḻiya-lupmaranhany.” ");
INSERT INTO djr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ga ŋayiny Djesuny waŋan nhanukal Djongalnydja bitjarra, “Nhen dhu ŋarranhany buku-ḻupmaram dhiyaŋun bala, bili dhuwaliyin ŋunhi dhunupany dhukarr ŋunhi ŋayi God-Waŋarryuny Bäpaynydja nhirrpar.” Bala ŋayiny yan Djondja yoraŋalnha nhanŋu Djesuwnydja, bala yan ḻiya-lupmaraŋalnha ŋanya ŋunhilin mayaŋ'ŋura. ");
INSERT INTO djr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ga ŋunhi ŋanya Djondhu buku-ḻupmaraŋalnydja, ga ŋunhi ŋayi Djesu dhawaṯthurrnydja gapuŋurnydja, ga dhunupan yan ŋunhany garrwarnydja wäŋa ḻapthurra, bala ŋayi Djesuynydja nhäŋal Birrimbirrnha God-Waŋarrwuny ŋayi marrtjin yarrupthurr räli beŋur ŋunhi God-Waŋarrwal yirralkaŋur, rumbalnydja ŋayi ŋunhi balanya nhakun murryil, dhuryurrnydja ŋayi marrtjin räli-i-i, bala yan nhinanan Djesuwala. ");
INSERT INTO djr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bala walal yan ŋäkula rirrakaynydja, ŋayi gan waŋanany beŋura ŋunhi djiwarr'ŋurnydja bitjarra gam', “Dhuwaliyin ŋarrakuwuynydja Gäthu'mirriŋu marrkapthunamirrnydja, mirithirra yan ŋarra ga dhuwal goŋmirriyirrnydja nhanukal.” Bitjarra ŋayi gan ŋunhi God-Waŋarryu Bäpaynydja ŋanya lakaraŋal Djesunhany. ");
INSERT INTO djr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ga dhäŋur beŋuryiny ŋunhi ŋayi Djesu ḻiya-ḻupthurrnydja, bala ŋanya yan Dhuyu-Birrimbirryuny mel-warryurra balan bitjarra ḏiltjilila gapu-ranhdhaklila wäŋalil, märr ŋanya dhu ŋunhiliyiny buŋgawaynydja Mokuyyu guwaḻ-ṉirr'maraman birrka'yunna manapan. ");
INSERT INTO djr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ga nhinanany ŋayi gan ŋunhi Djesuny ŋunhiliyiny gapu-ranhdhakŋurnydja wäŋaŋur märr wiyinnha 40-walu ga munha, bala yan ŋayi Djesuny mirithinan dhika djaṉŋarrthinany. ");
INSERT INTO djr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Bala ŋayiny ŋunhi Mokuynydja dhunupan yan bunanan nhanŋu Djesuwnydja, bala yan bitjarra nhanŋu waŋan gam', “Ŋuli nhe be God-Waŋarrwuny Gäthu'mirriŋu, ma' bilmaraŋun dhuwal guṉḏanhany mala ŋathakuŋun, dhiyaŋiyi dhärukthu yan nhokiyingal nhe.” ");
INSERT INTO djr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yurr ŋayiny Djesuny waŋan buku-bakmaraŋal nhanŋuny bitjarr warray gam', “Yaka. Bili ŋunha dhuyuynydja djorray' ga dhuwal lakaram bitjan, ‘Yaka dhu ga dhuwal yolŋuny nhina walŋa ŋathaynydja yan waŋganydhuny. Ŋany bukmakthu yan God-Waŋarrwal dhärukthu ŋunhi ŋuli ga dhawaṯthun nhanukal dhurrwarakurr, ŋuriŋiyin dhu dhuwal ga yuwalktja yolŋuny nhina walŋany.’” ");
INSERT INTO djr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ga dhäŋur beŋuryiny ŋayi ŋanya ŋunhi buŋgawaynydja Mokuyyu garr'yurra Djesunhany, balan ŋunhi dharrpallila wäŋalil Djurutjalamlila, ga nhirrparnydja ŋayi ŋanya ŋunhiwilin ŋunhi buku-ŋal'yunamirrilila buṉbulilnydja, yurr garrwarlila dhika. ");
INSERT INTO djr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Bala ŋayi gan waŋanan ŋunhiyiny Mokuynydja bitjarra gam', “Ŋuli nhe be God-Waŋarrwuny Gäthu'mirriŋu, ma' mak wapthurr dhipuŋuryiny garrwarŋurnydja bala'ŋur balan ŋoylila munatha'lila. Bili ga ŋunha Djorrayny'tja lakaram bitjan warray gam', ‘Ŋayiny dhu God-Waŋarrnydja dhäruk-gurrupanmirra djiwarr'puywalnydja yolŋuwal walalaŋgal dharraykuman nhuŋu, märr nhe dhu yakan galkirriny, ga ḻukuny ŋula burakirr guṉḏaynydja. Ma' biyakun wapthurra balan ŋoylila munatha'lila.’” ");
INSERT INTO djr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ga ŋayiny Djesuny bitjarr warray nhanŋu buku-roŋanmaraŋal waŋan gam', “Yaka nhe dhu dhuwal Garraynhany birrka'yun, ŋunhi ŋayiny nhuŋu God-Waŋarr.” ");
INSERT INTO djr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ga dhäŋur beŋuryiny bala ŋayi ŋanya ŋuriŋiyi Mokuyyuny garr'yurra balan bitjarra bukulila wäŋalil djinmir'lila, ga ŋunhiliny ŋayi milkuŋal nhanukal Djesuwalnydja bukmaknhan bäpurruny malaŋuny wäŋalil ga wäŋalil, ŋunhi nhäthinya dhuwal wäŋa buku-ḻiw'maram ga dhärra manymak mirithirr ga ganydjarr malany walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ga bitjarra ŋayi nhanŋu ŋunhi mokuynydja waŋan, “Dhuwandja ŋarra dhu bukmaknha yan nhäny mala nhokalnha goŋlil gurrupan, ŋuli nhe dhu ŋunhi ŋarrakuny buku-ŋal'yun.” ");
INSERT INTO djr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Bala ŋayiny Djesuynydja waŋanan ŋaŋ'ŋaŋ'thurra ŋanya ŋunhi Djaytinnhany bitjarra, “Gatjuy waṉḏin. Bili ŋunha ga God-Waŋarrwalnydja Djorray' lakaram bitjan warray gam', ‘Nheny dhu nhanŋuwuynha yan waŋganygun bun'kumu-djipthundja Garraywun, ŋunhi ŋayi nhuŋu God-Waŋarr, buku-ŋal'yundja nhe dhu nhanŋuwuynha yan waŋganygun ga dhäruktja märram.’” ");
INSERT INTO djr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bala ŋayi ŋanya ŋunhi ŋuriŋiyiny buŋgawaynydja Mokuyyu ganarrthaŋala Djesunhany. Ga beŋuryiny dhurrwaraŋur, bala walalnydja ŋunhi God-Waŋarrwuny dhäwu-gänhamirrnydja yolŋu walal bunanan nhanŋu Djesuwnydja, bala yan guŋga'yurra ŋanya ŋunhiliny ŋayilpi'ŋurnydja wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ga beŋuryiny dhurrwaraŋur, ŋunhi ŋayi Djesuy ŋäkulnydja Djongalaŋuwuynydja dhäwu, ŋunhi walal ŋanya galkar dharruŋgulil, bala ŋayi roŋiyinan dhunupan balayin Galalililnha makarrlila wäŋalil. ");
INSERT INTO djr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Bala ŋayi ganarrthaŋal Nätjuritjtja wäŋa, bala marrtjinan balan bitjarra wäŋalil yäkulil Gapuniyamlila, ŋunhi dhuwandja wäŋa gan dhärran raŋiŋur ḻaypa ŋurikiyi yindiw gapuw guḻungu yäkuw Galaliw, ŋunhili makarrŋurnydja wäŋaŋur Djapalan ga Napalin, ga ŋunhiliyin ŋayi gan ŋunhi Djesuny nhinan. ");
INSERT INTO djr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bili ŋäthilnydja baman'tja God-Waŋarrwal djawarrkmirriy yäkuy Yitjayay wukirri bitjarr, ");
INSERT INTO djr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nhuma yolŋu walal ŋunhi nhuma ga nhina Djapalan ga Napali wäŋaŋur, ŋunha gali'ŋur Djodan mayaŋ'ŋur, ga ŋunhili dhukarrŋur ŋunhi marrtji ŋorra bala guḻunlil gapulil yäkulil Galalilil; Nhuma Djan'tayilyuny mala yolŋuy walal ŋäkun dhuwandja dhäruk gam'. ");
INSERT INTO djr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ga nhuma, ŋunhi nhuma ga buku-munha'ŋur romŋur nhina, nhumany dhu nhäman yindin mirithirra djarraṯawun'tja. Ga nhumalaŋgalnydja ŋunhi nhuma ga nhina dhuwali dhiŋganhamirriŋur wäŋaŋur. Yurr nhumalaŋgalnydja dhu ŋunhi yuṯan walu djaḏaw'yun dhiyaliyiny.” ");
INSERT INTO djr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ga beŋuryiny dhurrwaraŋur bala ŋayi Djesuny ŋurruyirr'yurra djawarrkthurra marrtjin, dhäwun lakaraŋal yolŋu'-yulŋuwnha bitjarra gam', “Bilyurra walal bala ganarrthula nhumalaŋguwuy nhuma dhuwurr yätjtja mala, bili God-Waŋarrwuny Rom dhuwal galkin.” ");
INSERT INTO djr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Waŋganymirrnydja waluy ŋayi Djesuny gan marrtjin ḻäy-ŋupara bala raŋikurra, galki guḻunkurr yäkukurr Galali, ga ŋunhili ŋayi nhäŋal märrmany' wäwa'manydjiny yäkuny Djäymannha ŋunhi wiripuny ŋayi yäku Beta ga wiripuny Wanduruny, maṉḏa gan ganybu djalkthurr guyaw, bili maṉḏa ŋunhi marŋgi mirithirr guya djämamirr maṉḏa. ");
INSERT INTO djr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Bala yan ŋayiny Djesuny waŋanan maṉḏaŋ bitjarrnha gam', “Way! Maṉḏa go marrtjin maṉḏa ŋarrakun malthurr, märr ŋarrany dhu nhumalany marŋgikuman nhaltjan nhuma dhu ga yolŋunhan walalany gaṯmaram.” ");
INSERT INTO djr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ga dhunupan bala yan maṉḏany ŋunhi wäwa'manydjiynydja ganarrthaŋala yan ŋunhiyi ganybuny, bala yan malthurra nhanŋun Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ga bulu ŋayi Djesu marrtjin waṉḏin bala raŋi-ŋupar, dharr'nha ŋayi nhäŋal wiripuŋunhany muka wäwa'manydjiny maṉḏany Djayimnhan ga Djonnhan ŋunhi dhuwaliyinyiny maṉḏa gäthu'mirriŋu ḏirramuw yäkuw Djibidiwnha. Yurr bukmakthu yan walal gan ŋunhi bäpa'manydjikurruwurrnydja gärrin marthaŋayŋur djinawa', djetjiraŋal marrtjin ganybu, galki balaŋ walal ŋunhi marrtjinyan guyalila. Bala ŋayiny Djesuny maṉḏaŋguny muka waŋan Djayimguny ga Djonguny, bitjarryi bili malthunaraw nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bala dhunupan maṉḏany muka Djayimdja ga Djondja malthurra nhanŋun Djesuwnha, bala maṉḏa ganarrthaŋalnha maṉḏaŋguwuy maṉḏa bäpa'mirriŋunhany ŋunhiwilin banydji yan marthaŋaylila. ");
INSERT INTO djr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ga beŋuryiny dhurrwaraŋur, bala ŋayi yan Djesuny gan buku-ḻiw'maraŋala marrtjin ŋulatjarryiny Galaliwurrnydja makarrkurr wäŋakurr. Yo, dhäwun marrtjin lakaraŋal manymaknha nhanukalaŋawuynha God-Waŋarrwalaŋawuynha rombuy, marŋgi-gurrupara marrtjin manapar walalany ŋunhilin ŋunhi Djuw-malawal buku-ḻuŋ'maranhamirriŋur buṉbuŋur ŋunhi marrtjin dhärra'-dharran. Ga nhämunha ŋunhi rerri malany nyumukuṉiny ga yindi, ŋayiny gan ŋunhi Djesuynydja warrpam'nha yan ḏukmaraŋal. ");
INSERT INTO djr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ga ŋunhiliny makarrŋur wäŋaŋur yäkuŋur Djiriyany, dhäwuny gan ŋunhi nhanukalaŋawuynydja Djesuwalaŋawuynydja ḻatjuwarr'yurra dhika mirithinan. Ga bulu walalnydja muka gäŋal rerrimirrinhany mala nhanukal Djesuwal, wiripuny rerri yätjkurra mirithirra marrmarryunamirra rerri, ga wiripuny bundhurrmirra marrtjin nhanukal ḏukmaranharaw. Ga wiripuwurrnydja marrtjin Djesuwal ŋunhiwurrnha ŋunhi wakinŋumirra birrimbirrmirr mala, ḻiya-bawa'mirra mala. Yurr ŋayiny gan ŋunhi Djesuynydja bukmaknhan yan walalany ḏukmaraŋal beŋuryiny rerriŋurnydja malaŋuŋur. ");
INSERT INTO djr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ga dharrwan mirithirra gan ŋunhi yolŋuny walal malthurr nhanŋu Djesuwnydja, beŋur Galaliŋur wäŋaŋur ga wiripuny beŋura bala makarrŋur wäŋaŋur yäkuŋur Dikabulatjŋura ga wiripuny Djurutjalamŋur ga Djudiyaŋur, ga ŋunha gali'puynha mayaŋbuy Djodinbuynha. ");
INSERT INTO djr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ga waŋganydhuny waluy ŋayi Djesuy nhäŋalnha dharrwanhan yolŋuny walalany, walal marrtjin wäŋgaŋal guwatjmar ŋanya. Bala ŋayipiny Djesuny marrtjinan bukulila, bala ŋayi gan nhinanany ŋunhiliyin bukuŋura. Ga walalnydja ŋunhi malthunamirrnydja mala nhanŋu yolŋu walal marrtjinan, bala nhinanany walal ŋunhi galkin yanan nhanukal, ḻiw'maraŋala ŋanya. ");
INSERT INTO djr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Bala yan ŋayi ŋurruyirr'yurra marŋgikuŋala walalany bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nheny dhu ga ŋunhi nhina yuwalkkuman yan ŋayaŋu-ŋamathirra. Ŋuli nhe dhu ga ŋunhi yuwalkkumany lakaranhamirr nhunapinya nhe ŋayaŋu-waŋarany, dhäparŋ'tja, ŋula nhämiriwnydja, bili ŋunha djiwarr'puynydja rom God-Waŋarrwuny nhumalaŋgun!” ");
INSERT INTO djr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Ŋunhi nhe ŋuli ga nhina ŋayaŋu-ŋonuŋmirrnydja ŋäthinyaraynydja, yurr ŋayipin nhuna dhu marrtji ŋunhi God-Waŋarryun yan ŋayaŋu-marrparaŋgumany, dharraḏayamany, ga yuwalktja ŋayaŋu-ŋamatham!” ");
INSERT INTO djr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Ga ŋuli nhe dhu ŋunhi nyilŋ'maranhamirrnydja nhunapinya nhe, nheny dhu ga ŋunhi yuwalknha nhinany ŋayaŋu-ŋamakurra, bili märramany nhe dhu ŋunhi bukmaktja ŋula nhäny malany ŋunhi manymaktja nhanukuŋun God-Waŋarrwuŋun wäwungunhawuynydja!” ");
INSERT INTO djr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nheny dhu ga ŋunhi yuwalknha yan nhina ŋayaŋu-djulŋithirra ŋuli nhe dhu ga ŋunhi mirithirrnydja nhakun djälthirr dhunupawnydja nhinanharaw, bili God-Waŋarryuny dhu ŋunhi dhaŋaŋguman nhuŋu ŋayaŋuny dhuwurr-dhunapaynha romdhuny!” ");
INSERT INTO djr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Ŋuli nhe mel-wuyunamirrnydja yolŋu wiripuwurruŋguny yolŋuw walalaŋ, ga ŋayiny dhu God-Waŋarrnydja bitjandhi bili mel-wuyundhi nhuŋuny, bala nhe dhu ga ŋunhi ŋayaŋu-ŋamathirra nhinany!” ");
INSERT INTO djr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Ga ŋuli nhe yolŋu ŋayaŋu-ḏarrtjalktja, ŋunhiyiny nhe yolŋu dhu ga ŋoy-djulŋithirra, bili nheny dhu nhäman ŋanya God-Waŋarrnhany!” ");
INSERT INTO djr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Ŋuli nhe ŋuli ga mägayayam yolŋuny walalany waŋgany-manapanarawnydja nhinanharaw, ŋunhiyiny nhe yolŋu yuwalknha ga ŋoy-ŋamathirr nhina, bili God-Waŋarryuny dhu lakaram nhuna ŋunhi nheny nhanŋun gäthu'mirriŋun!” ");
INSERT INTO djr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Ŋunhi nhe ŋuli ga djäma rom malany ŋunhi nhaku ŋayi ŋuli ga God-Waŋarr djälthirr, bala walalnydja ŋuli marrtji ŋunhi wiripuwurruynydja yolŋu'-yulŋuy ŋayaŋu-yätjaman nhuna, yurr nheny gi mukthurra yan nhini ŋoy-ŋamathin, bili God-Waŋarrwuŋuny rom ŋunhi djiwarr'puynydja nhumalaŋgun!” ");
INSERT INTO djr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ŋunhi nhumalany ŋuli yolŋuy walal waŋa ŋula nhaliynydja dhärukthu, warku'yundja, ga yan ŋoy-yätjamany nhumalany, ga nyäḻ'yundja dhäwu gänhamirr nhumalaŋgalaŋuwuy, ŋunhiŋuwuy ŋunhi nhumany ŋarraku warray malthunamirr mala, yurr nhumany dhu ga bitjanna bili yan mukthunna nhinany ŋoy-ŋamathirra. ");
INSERT INTO djr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yo, nhininy walal gi ŋoy-ŋamathin yan ga märr-yiŋgathin gi mirithin, bili ŋunha djiwarr'ŋurnydja God-Waŋarryuny ga ŋayatham manymaknha mirithirra ga yindin nhumalaŋguny. Ga bitjarryi bili walal gan be ŋäthilnydja God-Waŋarrwuny dhäwu-gänhamirriny yolŋuny walalany warku'yurryi wiripuwurruynydja yolŋuy walal, ga mari walalaŋ walal gan djäma.” Mathuyu 5.13-16 Ga bulu ŋayi Djesu waŋan walalaŋ bitjarr, ");
INSERT INTO djr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nhumany dhuwal balanya nhakun dje'la, bukmakkun yan yolŋu'-yulŋuwnydja. Ga ŋunhi ŋuli dje'la dhäkaymiriwyirrnydja, ga bäyŋun dhu buluny nhakun ŋunhiyi ḏamurruŋgumany. Ga walalnydja ŋuli yolŋuynydja walal ŋunhiyiny dje'lany ŋurrkaman, bala marrtji dhurrpa'-dhurrparaman ḻukuynha.” ");
INSERT INTO djr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ga balanya nhuma dhuwal nhakun baḏayala' bukmakku yan yolŋuw walalaŋ. Balanya nhakun ŋunhi buṉbu mala dhuḻ'yunawuy bukuŋur marrtji dhärra'-dharra, ga bukmakthun ŋuli ŋunhi yolŋuynydja walal nhämany ŋunhiyi buṉbuny mala. ");
INSERT INTO djr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ga ŋuli dhu ŋunhi ŋula yolthu yolŋuy dhuŋgur'yun lanhdhirrany, ga yakan ŋayi dhu ŋunhi buluny nhakun ŋula banikin'thuny ŋapa-monygum, ŋany gaykarraŋlila ŋayi dhu ŋunhi nhirrpandja, märr dhu ga ŋunhiyi bala'nhany djeŋarra'yaman, bukmakkun nhänharaw. ");
INSERT INTO djr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yo! Ga nhumany dhu ŋunhi bitjandhi bili yan walŋa baḏayala'mirriyirryi milma nhakun yolŋu'-yulŋuwala, märr walal dhu nhäman nhumalaŋgal ŋunhi manymaktja djäma malany, bala yan walal dhu wokthunna Bäpa'mirriŋuwnydja nhumalaŋgalaŋaw, ŋunhi ŋayi ga nhina ŋunha djiwarr'ŋur.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋ. Mathuyu 5.17-20 Ga bulu ŋayi Djesu waŋan bitjarr, ");
INSERT INTO djr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Yaka nhuma dhu dhuwal guyaŋa bitjandja gam', yanbi ŋarrany dhuwal räli marrtjinya beŋur romgu malaŋuw buwayakkunharawnha, ŋunhi Mawtjitjthu rom rulwaŋdhurr, ga God-Waŋarrwal djawarrkmirriy malaŋuy gan marŋgikuŋal yolŋuny walalany. Ŋany dhuwal ŋarrany bunan dhiyalnydja, märr dhu ŋunhi marŋgikunhawuynydja walalaŋguŋ maḻŋ'thunna rumbalthirra. ");
INSERT INTO djr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ga guyaŋa nhuma dhu ga dhuwandja. Yakan dhu ŋunhi God-Waŋarrwuŋuny rom rulwaŋdhunawuy buwayakkum ŋula nhaliynydja mala, bäydhi ŋunhi dhu dhuwal djiwarrny'tja ga munathany' wäŋa dhä-dhawar'yun, yurr bäyŋun dhu ŋunhi ŋula nhä waŋgany nyumukuṉiny rom buwayakthi ŋuliŋuryiny nhanukalaŋuŋurnydja Godkalaŋuŋurnydja romŋur malaŋuŋur; bukmaknha dhu gi ŋunhi dhärrin yan, ga yan bili-i-i ga yalalaŋumirriynha dhu ŋunhiyi warrpam'nha maḻŋ'thurrnydja.” ");
INSERT INTO djr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Ga ŋuli ŋayi dhu ŋula yolthu yolŋuy märr-yuḻkthundja ŋunhiyiny God-Waŋarrwuŋuny dhäruk-nhirrpanawuy rom malany, bäydhi ŋunhi ŋula nyumukuṉiny'tja rom, ga ŋuli ŋayi dhu ŋunhi wiripuwurrunhany yolŋu'-yulŋuny marŋgikum djarrpi'kumany ŋunhiyiny rom malany God-Waŋarrwuny, märr dhu walalnydja ŋunhi yolŋuynydja walal bitjandhi bili ga guyaŋa bala märr-yuḻkthuna, ḏaḏawyunna manapan dhipuŋuryiny romŋur, ga ŋayiny dhu ŋunhiyiny yolŋu dhuḏiŋun ŋunhalnydja God-Waŋarrwalnydja romŋur, yalalany ŋunhalnydja djiwarr'ŋurnydja. Ga ŋuli dhu ŋayi ŋula yolthu yolŋuy dhäruktja märram nhanŋu God-Waŋarrwuny, bala ŋayi dhu ga ŋayathamany baṯ-bitjanna yan, ga ŋuli ŋayi dhu marŋgikum walalany wiripuwurrunhany yolŋu'-yulŋuny balanyarawyi romgu ŋayathanharaw, ŋayiny dhu ŋunhiyiny yolŋu ŋurruŋun God-Waŋarrwalnydja romŋur, yalalany ŋunhalnydja djiwarr'ŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Guyaŋi ŋathil walal dhuwal gam'; Rom-marŋgikunhamirriy malaŋuy ga Baratjiy malaŋuy ŋuli ga dhuwal God-Waŋarrwuny rom baṯ-bitjan yan ŋayatham. Yurr nhumany walalany dhu ŋunhi djuḻkmaraman nhäthinya ŋunhi walalaŋguŋ rom ŋayathanhawuy, ŋuli nhuma djäl gärrinyaraw balany ŋunhi God-Waŋarrwalnydja romlil.” Ga bitjarr ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ga bulu ŋayi Djesuy lakaraŋal walalaŋgal bitjarr gam', “Bili muka nhuma dhuwal marŋgi, ŋunhi ŋurruḏawalaŋuy malaŋuy rom-rulwaŋdhurr raypirri'yunawuy ŋäthil bitjarr gam', ‘Yaka nhe dhu yolŋuny buma murrkay'kum. Ga ŋuli nhe dhu ŋunhi ŋula yolthu yolŋuy buma wiripuŋuny yolŋuny murrkay'kumany, ŋunhiny nhe dhu gumurrŋura dhärri mala-djarr'yunarawnha.’ ");
INSERT INTO djr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yurr dhiyaŋuny bala ŋarra nhumalaŋ dhu dhuwal lakaram bitjanna gam', Ŋuli nhe dhu ga ŋula yol yolŋu ŋoy-murryundja wiripuŋuwnydja yolŋuw Garraywalaŋumirriw, ŋunhiny nhe bilin waṉa-waŋanan nhuŋuwuy nhe, marilila galkanmin. Ga ŋuli nhe dhu nhuŋuwuy wäwa'mirriŋuny bitjandja lakaram gam', ‘Nheny dhuwandja bäyŋun, bawa'mirra balanyan,’ bitjandja, walalnydja dhu ŋunhiyiny yolŋuny gäman balan ŋurikalnha rom-djägamirriwala malaŋuwal mala-djarr'yunarawnha. Ga ŋuli nhe dhu ŋunhi wiripuŋuny yolŋuny waŋa bitjandja, ‘Nheny dhuwandja nyalmiri yolŋu,’ bitjandja ŋanyanhany dhu ŋunhiyiny yolŋuny waŋgapunuŋun yan gurthaynha, ŋunhala ŋunhi dhä-gir'yunamirriŋura wäŋaŋur.” ");
INSERT INTO djr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Yo. Ga ŋuli nhe dhu ŋunhi mundhurrnydja gäma God-Waŋarrwalnydja buṉbulil nhakun gurrupanarawnydja nhanŋu, ga ŋunhiliyiny nhe dhu guyaŋan ŋunhi wiripuŋunhan yolŋuny ŋunhi ŋayi ga ŋula nhä ŋayatham nhuŋu dhaŋariny, ga nheny yaka yänayiny gurrupul dhuwaliyiny mundhurr God-Waŋarrwuny; ");
INSERT INTO djr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ŋany rulwaŋdhun nhe dhu ŋunhiwiliyi banydji yan djimuku'lil bulaymirrilil, ga guwatjmul ŋathil ŋunhiyi yolŋuny ga gumurrkunhamirr ŋathil maṉḏa, ga dhäruk maṉḏa rulwaŋdhurr dhunupa yan, ga dhäŋur beŋuryin nhe dhu roŋiyirrnydja balany God-Waŋarrwalnydja buṉbulil, ga yurrnha gurrupulnydja mundhurrnydja nhanŋuny God-Waŋarrwuny.” ");
INSERT INTO djr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ga ŋuli nhuna ŋayi dhu ŋula yolthu yolŋuy marilil galkan romgurr, ga ŋuli ŋayi dhu nhuna djarrma-gäma bitjandja gam', ‘Dhiyaŋuny bala ŋarra dhu nhuna gäman balan ŋärra'lila, märr walal dhu nhuna dhä-gir'yunna,’ nheny bondi ŋanya galki-ŋayathul ga waŋanhamirr maṉḏa dhunupan yan dhärukthuny ḏälyun, ga ŋuli bäyŋuny ga ŋayiny dhu ŋunhi ŋuriŋiyiny yolŋuy goŋ-gurrupanna nhuna ḏilakkala ŋunhi ŋayi romgu mala-djarr'yunamirr, ga dhäŋur beŋuryiny bala ŋayi nhuna dhu ŋunhi goŋ-gurrupanna ŋamakuli'ŋuwalnha, märr ŋayi dhu nhuna galkanna dharruŋgulila. ");
INSERT INTO djr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ga yuwalk ŋarra ga dhuwal nhuŋu lakaramany, ga nhinany nhe dhu ga ŋunhilin bili yan djinawan' dharruŋguŋura ga yan warray, ga bäy nhe dhu bukmak doy' mala gurrupan buku-roŋanmaram ŋunhiŋuwuyyi dhä-gir'yunawuy.” Ga bitjarra ŋayi gan Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ga bulu ŋayi Djesu waŋan bitjarr gam', “Bili muka nhuma dhuwal marŋgi, ŋunhi walal gan ŋurruḏawalaŋuy mala rom-rulwaŋdhurr ŋäthil bitjarr gam', Yaka nhuma dhu ga ŋunhi marrambany' djäma. ");
INSERT INTO djr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yurr ŋarrany dhu dhuwal nhumalaŋ lakaram balanyan gam', Ŋuli nhe dhu ŋunhi ŋula yolthu ḏirramuy nhäma wiripuŋuny miyalknha nhokiyingal nhe maŋutjiy, ga ŋuli nhe ŋoynydja waŋan bitjarra gam', ‘Ye-e-e djäl ŋarra dhuwal ŋuruk miyalkku yindi bay, märr linyu dhu rom djäma,’ yurr ŋunhiyiny nhe dhuḏitjnha bitjarryiny guyaŋan; nheny ŋunhi ŋäthil warray ŋoy-ŋorranany nhanŋu nhokiyingal nhe ŋayaŋuynydja, ga ŋunhiyiny nhakun nhe bitjarryiny marramban' djäma. ");
INSERT INTO djr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ga ŋuli ŋayi dhu nhuna dhunupaŋuynydja maŋutjiy nhokal mel-warryun nhuna bala yätjkurrulilnydja romlil, nheny ḏulŋurr'yurrmirra nhunapinya nhe ŋunhiyiny maŋutjiny bala yan ŋurrkuŋun, bäydhi nhe dhu ga ŋunhi melyu waŋganydhuny nhina, bili ŋunhiyiny nhuŋu manymaknha mirithirra. Yurr ŋuli nhe dhu ŋunhi yakany ŋurrkam ŋunhiyi maŋutji, ŋunhiny ŋayiny dhu God-Waŋarryuny nhuna rumbal manapula ŋurrkuŋ balayin ŋunhi dhiŋganhamirrilila wäŋalil. ");
INSERT INTO djr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ga ŋuli nhokal dhu ŋunhi dhunupa'ŋuy goŋdhu mel-warryun nhuna bala dhuwurr-yätjlil romlil, ga nheny biyakiyi bili gulkmaranhamirr nhunapinya ŋunhiyiny goŋ, bala yan ŋurrkuŋun, bäydhi nhe dhu ga ŋunhi marrtji'-marrtji goŋ waŋganymirrnydja, bili ŋunhiyiny nhuŋu manymaknha mirithirra. Yurr ŋuli nhe dhu ŋunhi yakany nhakun ŋurrkam nhuŋuwuy nhe dhunupa'ŋuny goŋ, ŋunhiny ŋayi nhuna dhu God-Waŋarryuny rumbal manapula ŋurrkuŋ balayin ŋunhi dhiŋganhamirrilila wäŋalil.” ");
INSERT INTO djr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ga bulu ŋayi Djesuy lakaraŋal walalaŋ bitjarr gam', “Bili muka nhumalaŋ gan ŋunhi ŋurruḏawalaŋuynydja mala God-Waŋarrwuny maḏayin' lakaraŋal nhumalaŋgal bitjarr gam', Ŋuli nhe dhu ŋunhi ŋula yolthu ḏirramuy ganarrthamany nhuŋuwuy nhe miyalknhany, nheny ŋathil dhu goŋ-nhirrpanmirr djorra'lil nhunapinya nhe, ganarrthanharawnydja nhanŋu ŋurikiyiny miyalkku. ");
INSERT INTO djr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yurr ŋarrany ga dhuwal lakaram nhumalaŋ bitjanna gam', yaka yan nhe dhu ḏirramuy ganarrtham nhuŋuwuy nhe miyalknha. Yurr ŋuli ŋayi ŋunhi marramba'-ḏumurrnydja miyalk ŋayiny dhu ḏirramuynydja nhanukal mak ganarrthaman ŋanya djorra'kurra. Ga ŋuli nhe dhu ganandja nhuŋuwuy nhe miyalknhany ŋunhiyiny nhe dhu ŋanya ŋuriŋiyiny romdhu barrkukuman, ŋayi dhu marramban' ga djäma. Ga ŋuli ŋayi dhu ŋanya ŋunhi wiripuŋuynydja ḏirramuy märram, ŋayiny ŋunhi ŋunhiyiny ḏirramu ga balanya bili yan marramba' djämamirryi.” ");
INSERT INTO djr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ga bulu ŋayi Djesuy marŋgi-wurrupar walalany, ga bitjarra ŋayi waŋanany gam', “Ga wiripuny nhuma bili marŋgi romgu ŋunhi God-Waŋarryu gan lakaraŋal limurruŋgalaŋuwal mala-ŋurrkanhawuywal walalaŋgal bitjarr gam', ‘Ŋuli nhe dhu ŋunhi ŋula yolthu yolŋuy wäwun'kumany wiripuŋunhany yolŋuny God-Waŋarrwalnydja yäkuy, ga guyaŋan yan nhe dhu ga dhuwali wäwun'tja, yakan moŋuny.’ ");
INSERT INTO djr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yurr ŋarrany dhu dhuwal lakaraman nhumalaŋgal balanyan gam', Ŋuli nhe dhu wäwun'kumany ŋula yolnhany, yaka bäki ŋula yolnha yäku. Ga yakayi yan nhe dhu yäku-lakaram djiwarrny'tja wäŋa, bili ŋunhiyiny nhanŋu God-Waŋarrwu nhinanharawnha wäŋa; ");
INSERT INTO djr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ga yakayi yan yäku-lakaraŋ dhuwal munathany' wäŋa, bili dhuwandja wäŋa munathany' ḻuku-ŋal'yunaraw muka nhanŋu God-Waŋarrwu. Ga yaka yan nhe dhu wäwun'kum ŋuruŋuny Djurutjalamdhuny yäkuy, bili ŋunhiyiny wäŋa Djurutjalamdja God-Waŋarrwu warray, ŋuriki ŋurruḏawalaŋuw ga ḏumurruw. ");
INSERT INTO djr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ga yakayi nhe dhu wäwun'kum ŋula yolnha yolŋuny nhokiyingal nhe ḻiyaynydja, bili nhepiny dhuwal ganydjarrmiriw warray, bäyŋu nhe gi dhuwal ŋula ganydjarr ŋayathul balanyarawyi bilmaranharaw miny'tjiw waŋganygu marwatku nhokiyingalaŋaw nhe, molkunharaw nhä mak watharrkunharaw. ");
INSERT INTO djr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ga ŋuli nhe dhu wäwun'kumany ŋula yolnhany, ga ŋula nhuŋu ga ŋayaŋuny yoraman, nheny yanan yoraŋun, ga ŋuli nhuŋu ga ŋayaŋu waŋa yaka'yundja, nheny yaka'yurra yan. Ga ŋuli nhe dhu ŋunhi wiripuŋuynha dhärukthu malaŋuy yäku-lakaram, ŋunhiyiny yakan dhunupa nhuŋu waŋanharaw; ŋunhiyiny ŋuli ga balanyayiny guyaŋanhawuy mala dhawaṯthun beŋura nhanukuŋun mokuywuŋun.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ga bulu ŋayi Djesuy marŋgi-wurrupar walalany, bitjarr gam', “Yo bili muka nhuma dhuwal ŋurikiyiny romgu marŋgi ŋunhi ŋayi God-Waŋarryu gan lakaraŋal limurruŋgalaŋuwal mala-ŋurrkanhawuywal walalaŋgal bitjarr gam', ‘Ŋuli nhuna dhu ŋunhi ŋula yolthu yolŋuy waŋgany maŋutji dharpum, ga nheny ŋanyanhany biyakiyi bili maŋutji dharpuŋdhi yan. Ga ŋuli ŋayi dhu nhuna waŋgany ḻirra bakmaram, ga nheny ŋanyanhany biyakiyi bili yan bakmaraŋdhi ḻirra.’ ");
INSERT INTO djr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yurr ŋarrany dhu dhuwal lakaram nhumalaŋgal bitjanna gam', bäydhi nhuna ŋayi dhu ŋunhi ŋula yolthu yolŋuy galŋa-yätjamany, ga nheny dhu nhanŋuny balany yakan buku-roŋanmaram. Ga ŋuli ŋayi dhu nhuna ŋula yolthu yolŋuy dhunupa'ŋuny dhakal bartjunmaram, ga nheny bulu nhanukal wiṉ'kuŋuny muka dhakal gurrupanmirr. ");
INSERT INTO djr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ga ŋuli dhu nhuna ŋula yolthu yolŋuy gäma ŋurruḏawalaŋuwalnydja walalaŋgal dhä-birrka'yunarawnydja, ga ŋunhiliyiny ŋayi dhu romŋurnydja ŋuriŋiyiny yolŋuy gombuman nhuna ŋunhi gumurrpuynydja girri', bala nheny dhu yanan dhayuŋanna nhanukal märryu dhapinyaynha, ga bulu wiripuny muka mala girri' nhuŋuwuy nhe dhu gurrupandhi nhanukal. ");
INSERT INTO djr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ga ŋuli dhu nhuna ŋula yolthu waŋganydhu miriŋuy gorrwumany nhanukiyingalaŋaw ŋayi girri'mirriwnydja bathiwnydja gänharaw märr gurririŋuwnydja yan gurrukanharaw, yurr nhepiny wiyin-märraŋun gäŋu bathiny nhanŋu girri'mirrnydja. ");
INSERT INTO djr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ga ŋuli ŋayi dhu ŋula yolthu nhuna ŋäŋ'thun ŋula nhakuny, nheny dhu yanan gurrupanna nhanŋu. Ga ŋunhi ŋayi dhu waŋa nhuŋu bitjandja, ‘Way, nhawi ŋarra nhuŋu dhu girri' dhuwal gäma yan wärriku,’ nheny yanan dhayuŋulnha nhanukal ŋayaŋuynydja dhapinyaynha.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ga bulu ŋayi Djesu waŋan bitjarr, “Yo bili muka nhuma gan ŋunhi ŋäkulnydja ŋäthil yan ŋunhi walal ŋurruḏawalaŋuy malaŋuy gan bitjarr lakaraŋal gam', ‘Märr-ŋamathirrnydja nhuma dhu ŋunhi ŋurikiwurruŋgun bili yan yolŋuwnydja walalaŋ ḻundu'mirriŋuwnha walalaŋ nhumalaŋgalaŋaw, ga ŋuyulkthirrnydja nhuma dhu ga miriŋuwnha mala nhumalaŋgalaŋaw.’ ");
INSERT INTO djr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yurr ŋarrany dhu dhuwal lakaram nhumalaŋ bitjanna gam', ‘Nhumany dhu ga märr-ŋamathirryi nhumalaŋgiyingalaŋaw miriŋuwnydja malaŋuw, ga bukumirriyaman nhuma dhu ga ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi walal nhumalany gan ŋoy-yätjaŋal.’” ");
INSERT INTO djr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","“Ga ŋuli nhuma ŋuli ga ŋunhi märr-ŋamathirrnydja nhumalaŋgiyingalaŋaw miriŋuwnydja malaŋuw, ga bukumirriyam nhuma ŋuli ga walalaŋ, nhuman ŋunhi yuwalktja djamarrkuḻi' nhanŋuny Djiwarr'puywuny Bäpaw. Bili God-Waŋarryuny ŋunhi djäma walunhany baḏayala'kunharawnydja bukmakku yan yolŋuwnydja walalaŋ dhuwurr-manymakmirriw ga dhuwurr-yätjmirriw. Ga bitjarryi bili ŋayi djäma waltjaṉdja bukmakku yan, manymakmirriw yolŋuw walalaŋ ga ŋurikiwurruŋ yolŋuw walalaŋ ŋunhi walal ŋuli marrtji yätjkurr bala djäma. ");
INSERT INTO djr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ga wiripuny mak nhe ŋuli ga dhuwal märr-ŋamathirr ḻundu'mirriŋuw yan nhokiyingalaŋaw nhe, ŋurikiwurruŋgun yan ŋunhi walal ŋuli ga märr-ŋamathirr nhuŋu; bala nhe ŋuli ga guyaŋany bitjanna gam', yanbi ŋayi nhuŋu dhu God-Waŋarrnydja wokthuna ŋunhiŋuwuyyiny. Yakan ŋayi nhuŋu dhu ŋunhi wokthun balanyarawyiny märr-ŋamathinyawuywu, bili dhuwaliny rom balanyayi bili nhakun ŋunhi walal ŋuli ga rrupiya-märranhamirr gapmangu yolŋu walal märr-ŋamathirr walalaŋgiyingalaŋaw ḻundu'mirriŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ga wiripuny mak nhe ŋuli ga guwatjman ŋunhin bili yan nhuŋuwuynha yan nhe gurruṯumirriny mala, ga bilin. Ga nhaltjanna nhe ga guyaŋany, yanbi nheny mirithirra dhuwurr-manymaknha yolŋu, djuḻkmaraman ga wiripuwurrunhany yolŋuny walalany? Bäyŋu warray. Bili ŋunha walalnydja Djan'tayilnydja yolŋu mala, ŋuli ga guwatjmanmirr warray. ");
INSERT INTO djr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ga nhumany dhu rom-ŋamathirra ga dhuwurr-dhunupayirra bitjandhi bili yan nhakun nhumalaŋ Bäpa'mirriŋu ŋunha djiwarr'ŋur ga nhina.” Ga bitjarrnha ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ga wiripuny ŋayi Djesuy bitjarr lakaraŋal walalaŋ gam', “Djäga nhumalaŋguwuy nhuma: Yaka nhuma dhu ga ŋunhi milkunhaminyawurrnydja romgurr djäma dhuwurr-manymaktja rom milmany nhakun yolŋuwalnydja walalaŋgal, bili ŋayiny dhu ŋunhi Bäpa'mirriŋuynydja nhumalaŋgal ŋunhi djiwarr'wuyyuny dhu bäyŋun nhumalaŋguny yaŋara'-bakmaram balanyawuyyiny djämapuy.” ");
INSERT INTO djr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ga ŋuli nhuma dhu ŋunhi gurrupan rrupiyany nhä mak ŋathany ŋunha ŋurruwuykmirrnhany, yakan nhuma dhu ŋunhi milkunhamirrnydja nhumalanhawuynha nhuma wetjtja gurrupanawuynydja, milmany nhakun wiripuwurruŋgalnydja yolŋuwal walalaŋgal, bitjandja nhakun ŋunhiwurrnydja yolŋu mala ŋunhi walal ŋuli ga gurrupan gali'-märrmay' romdhu ŋunhal ŋunhi Djuwskal buku-ḻuŋ'maranhamirriŋur buṉbuŋur, ga wiripuny ŋulawitjan dhukarrkurr, märr dhu ga ŋunhi bukmaktja yolŋu'-yulŋu wokthunna walalaŋ. Yurr ŋarrany nhumalaŋ ga lakaram, ŋunhiyiny wokthunawuy yolŋuwuŋuny, ŋunhiyiny ŋunhin bili yan walalaŋ, bili bäyŋun walalany dhu ŋunhi ŋayiny God-Waŋarryuny yaŋara'-bakmaramaŋ ŋunhiŋuwuyyiny djämapuy.” ");
INSERT INTO djr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Ga ŋunhin nhe dhu ga guŋga'yundja yolŋunhany gam', ŋunhi ŋayi ga yuwalknha dhäparŋ' nhina, ŋanyanhan guŋga'yurrnydja, yurr gayulnha, märr ŋayi dhu ŋunhi galkipuynydja nhuŋu gurruṯumirr yakayi yan marŋgithirr. ");
INSERT INTO djr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bala walal dhu ŋunhi yolŋu'-yulŋuny bäyŋun marŋgithirr ŋurikiyi wetjkuny nhokalaŋaw. Yurr nhokal djiwarr'puyyuny Bäpa'mirriŋuy ŋuli ga nhuna nhäma warray ŋunhiwiliyi gayullilnydja wetjlil, bala ŋayi dhu ŋunhi God-Waŋarryuny yaŋara'-bakmaraman nhuŋuny.” ");
INSERT INTO djr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ga ŋuli nhuma dhu ga ŋunhi bukumirriyamany, yaka bukumirriyaŋ biyakuny nhakun ŋunhiwurrnydja yolŋu walal ŋunhi gali'-märrmany' mala. Walalnydja ŋuli ga ŋunhi dhuwalawurryiny dhärra gumurrŋur warray, ŋunhalnydja ŋunhi Djuw malawalnydja buku-ḻuŋ'maranhamirriŋur buṉbuŋur, ga ḻikanŋur dhukarrŋur, märr dhu ga bukmakthuny yolŋuy walal nhäman walalany. Bili ŋarrany nhumalaŋ gan ŋunhi lakaraŋal, ŋunhi ŋunhiyiny wokthunawuy yolŋuwuŋuny, ŋunhiyiny ŋunhin bili walalaŋ, bili bäyŋun walalany dhu ŋunhi ŋayiny God-Waŋarryuny yaŋara'-bakmaramaŋ ŋunhiŋuwuyyiny djämapuy.” ");
INSERT INTO djr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Ga ŋuli nhe dhu ŋunhi bukumirriyamany, nheny dhu marrtji bala gärrin nhokiyingal nhe wäŋalila, bala dhurrwarany dhaḻ'maraŋun, bala bukumirriyaŋun nhokalaŋuwal Bäpa'mirriŋuwalnydja, ŋurikalnydja ŋunhi nhe ŋuli gi bäyŋun ŋanya nhäŋu nhokiyingal nhe melyu. Yurr ŋayipiny ŋuli ga nhäma nhuna ŋunhi nhaltjan nhe ŋuli ga gayul bukumirriyam, ga märr-yuwalk yan ŋayi nhuŋu dhu ŋunhi yaŋara'-bakmaramany ŋunhiŋuwuyyiny.” ");
INSERT INTO djr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ga ŋunhi nhe dhu bukumirriyamany God-Waŋarrwalnydja, yaka gi waŋi dharrwany dhäruk mayali'miriwnydja, biyakuny nhakun ŋunhiwurr ŋunhi Djan'tayil yolŋu mala ŋunhi walal ŋuli ga wiyin waŋa wiripuŋuwal waŋarrwal, yanbi walalany ŋayi dhu ŋäma ŋuriŋiyiny wiripuŋuynydja waŋarryu balanyawuyyiny wiyinbuynydja bukumirriyanhawuy. ");
INSERT INTO djr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yaka bukumirriyaŋ biyakuny nhakun walalnydja. Biyak bukumirriyaŋuny gurririy dhärukthuny ga mayali'mirriyaŋ. Bili ŋayiny ŋunha nhuŋuny Bäpa'mirriŋu ŋäthil warray marŋgi ŋunhi nhaku nhe ŋuli ga ŋunhi djälthirr, yorrnha nhe dhu ŋanya ŋäŋ'thundja.” ");
INSERT INTO djr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ga bitjan yanbi nhuma dhu ga ŋunhi bukumirriyamany gam', ‘Bäpa ŋanapurruŋ, ŋunhi nhe ga nhina dhuwaliyi djiwarr'ŋur, Nheny yäku yindi warray, ga wokthunamirr. ");
INSERT INTO djr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Napurr nhuna ga dhuwal ŋäŋ'thundja nhe dhu dhanuŋdhunna nhuŋuwuy nhe God-Waŋarrwuny rom ŋayaŋulila ŋanapurruŋgal, märr ŋanapurr dhu ga djämany dhiyalnydja munatha'ŋurnydja wäŋaŋur nhokiyingalaŋuwurra yan djälkurrnydja, bitjan yan bili nhakun walal ŋuli ga djäma dhiyaliyi djiwarr'ŋur nhokiyingalaŋuwurr yan djälkurr. ");
INSERT INTO djr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ŋatha ŋanapurruny maranhu-gurrupul dhiyak bala waluw. ");
INSERT INTO djr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bäy-lakaraŋun ŋanapurruŋ yätjkurruwuynydja djämapuy, biyak yan bili nhakun napurr ŋuli ga bäy-lakaram ŋurikiwurruŋ ŋunhi wiripuwurruŋ yolŋu'-yulŋuw ŋunhi walal ŋuli ŋanapurruny ŋayaŋu-yätjam. ");
INSERT INTO djr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yaka ŋanapurruny gäŋu gumurr-ḏälkurrnydja romgurr birrka'yunarawnydja. Gunguŋ ŋanapurruny, märr ŋanapurruny dhu bäyŋun yätjkurruynydja birrimbirryu djuḻkmaram, ŋunhi napurruny ŋayi ŋuli marrtji guwaḻ-ṉirr'maramany.’ Ga bitjanna nhuma dhu ga ŋunhi bukumirriyamany nhanukalnydja God-Waŋarrwalnydja.” ");
INSERT INTO djr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ga ŋuli nhuma dhu ŋunhi bäy-lakaramany wiripuwurruŋguny yolŋu'-yulŋuw, ŋurikiwurruŋguny ŋunhi walal ŋuli nhumalany ŋoy-yätjam, ga nhumalaŋgalnydja dhu Bäpa'mirriŋuy djiwarr'puyyuny bitjandhi bili bäy-lakaramdhi nhumalaŋguny. ");
INSERT INTO djr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ga ŋuli nhuma dhu yakany walalaŋ bäy-lakaram ŋurukuwurruŋdhi ŋunhi nhumalany walal ŋoy-yätjaŋal, ga bitjandhi bili yan nhumalaŋgalnydja dhu Bäpa'mirriŋuy djiwarr'puyyuny yakayi nhumalaŋguny bäy-lakaram, ŋunhiŋuwuyyiny dhuwurrpuy yätjkurruwuynydja mala.” ");
INSERT INTO djr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ga ŋunhi nhuma ŋuli ga ŋoy-ŋathamiriwnydja nhina, yaka gi dhakatjurrnydja nhini, biyak nhakun ŋunhiwurrnydja yolŋu walal ŋunhi rom gali'-märrmany' mala. Walalnydja ŋuli ga ŋunhi nhina nhakun ŋula nhän, yakan walal ŋuli gi djägany walalaŋguwuy walal marwatkuny, bukuwnydja, ga rumbalwuny, ŋunhiyiny nhakun walal ŋuli ga milkunhamirra wiripuwurruŋgala yolŋuwal walalaŋgal ŋunhiŋuwuynha ŋathapuynha gananawuy, märr ŋuli ŋunhi wiripuwurruynydja yolŋuy walal nhämany walalany dharaŋana yan ŋunhiwiliyiny. Yurr ŋarrany nhumalaŋ ga dhuwal lakaram, ŋunhiyiny wokthunawuy yolŋuwuŋuny, ŋunhiyiny ŋunhin bili yan walalaŋ, bili bäyŋun walalany dhu ŋunhi ŋayiny God-Waŋarryuny yaŋara'-bakmaraŋ ŋunhiŋuwuyyiny djämapuy. ");
INSERT INTO djr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ga nhumany dhu walal yaka bitjandhi milkunhamirr, bitjan nhakun ŋunhiwurryi yolŋu walal, ŋuli nhumany dhu ga ŋunhi nhina ŋoy-ŋathamiriw. Biyak yan bukuny rurrwuyunmirra gi, ga marwattja gi dhunupayaŋun nhunapinya nhe, ");
INSERT INTO djr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","märr nhuna dhu yolŋu'-yulŋuynydja yakan ga dharaŋan ŋunhiŋuwuynydja ŋunhi nhe ŋuli ga nhina ŋoy-ŋathamiriw. Yurr ŋayipin dhu nhuŋu waŋganynha Bäpa'mirriŋun djiwarr'puynha marŋginy, ŋunhiyin ŋunhi nhe ŋuli gi bäyŋun ŋanya nhäŋu nhokiyingal nhe maŋutjiy. Yo! Bala ŋayi dhu nhokal Bäpa'mirriŋuynydja buku-roŋanmaraman nhuŋuny ŋunhiŋuwnydja ŋunhi gayulpuynydja djämapuy.” ");
INSERT INTO djr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ga bulu ŋayi Djesuy lakaraŋal walalaŋgal bitjarr: “Yaka nhe dhu ga ḻukunydja'kunhamirr nhunapinya nhe ŋula nhaliy malaŋuy dhuwalaŋuwuyyu, bili ŋayi ŋuli wiripuny mala nhuŋu girri' bäynha gi ŋula gälkalyun ḻuki, ga wiripuny mala girri' ŋuli dhulwirmirriyin, ga wiripuny mala ŋuli bäynha gi ŋula manaŋa-ḏilkurruynha yolŋuy mala djaw'-djawyurr. ");
INSERT INTO djr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ŋany ḻukunydja'kunhamirrnydja gi ŋuriŋiyin malaŋuy ŋunhi Djiwarr'puyyun ŋula nhaliynydja malaŋuy manymakthun. Bili ŋunhiyiny mala ŋamakurr God-Waŋarrwuŋuny dhu yakan dhawar'yurr ga dhulwirmirriyi, ga gälkalyu dhu gi bäyŋun ḻuki, ga bäyŋun dhu gi manaŋa-ḏilkurruy nhuŋu djaw'-djawyurr.” ");
INSERT INTO djr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","“Bili ŋayaŋuny nhuŋu dhu ga ŋunhi bitjanna bili ŋunhilin ŋorra, ŋunhi nhe ŋuli ga mirithirr mulwaṯkum nhuŋuwuy nhe ŋula nhä malany mel-wiḏimirr dhuwalaŋuwuy munatha'wuy.” ");
INSERT INTO djr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Melnydja maṉḏany dhuwali nhuŋu balanya nhakun baḏayala' rumbalwu nhokalaŋaw. Ga ŋunhi nhe ŋula mel-ḏarrtjalktja, ga ŋunhiyiny nhakun nhuŋu walŋany baḏayala'mirra. ");
INSERT INTO djr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ga ŋunhi nhuŋu maŋutji yätjkurrnydja, ga ŋunhiyiny nhakun nhuŋu walŋany buku-munhan warrpam'nha. Ŋuli balaŋ nhe dhu ga guyaŋanhamirr nhunapinya nhe bitjanmirrnydja, yanbi nheny ŋayaŋu baḏayala'mirr, yurr yuwalktja nhuŋu ŋayaŋuny dhuwali buku-munhan', ŋunhiyiny nhakun nhuŋu bukmaknha yan ŋayaŋuny bilin buku-munha'yinan.” ");
INSERT INTO djr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yo. Bäyŋun nhe dhu ŋunhi djämamirr märrmawny'tja buŋgawaw, bili ŋunhi nhe dhu ga waŋganyguny märr-ŋamathirr, ga wiripuŋuwnydja nhe dhu buŋgawaw ŋuyulkthirra. Ga wiripuny nhe dhu ga ŋunhi dhäruk-märram ŋanyanhan yan ŋunhi waŋganynhan buŋgawany, ga wiripuŋunhany nhe dhu ga märr-yuḻkthunna. Ga bitjandhi bili nhumany dhu ga yakayi ŋunhi buku-ŋal'yun märrmawny'tja maṉḏaŋ, God-Waŋarrwuny ga rrupiyawnydja.” ");
INSERT INTO djr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ga balanyan dhuwal dhäwuny' gam' ŋarra dhu lakaraman nhumalaŋ. Yaka nhuma dhu ga warwuyun mirithirr ŋathawnydja ḻukanharaw ga gapuwnydja ŋunhi nhä nhumalaŋgal ŋayaŋuŋur manymak walŋaw nhinanharaw. Ga yaka warwuyurr girriwny'tja nhä malany nhe dhu ga gäma nhokiyingal nhe rumbalyu. Yaka dhuwal ŋayi nhuna God-Waŋarryu djäma ŋathawnydja yan ḻukanharaw ga girriwny'tja yan gänharaw. ");
INSERT INTO djr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nhäŋu ŋunha warrakan'nha malaŋuny buṯthunawuy. Yaka walal ŋuli gi ŋunhi warrakan'thuny malaŋuy ŋula nhä djäma ŋatha malany lämu-nhirrpul, ga bäyŋuyi yan walal ŋuli gi ŋunhi ŋathany mala maŋutjiny gulkthurr ga rarr'yurr ŋuli marrtji buṉbulilnydja. Yurr nhumalaŋguny Bäpa'mirriŋu ŋunha djiwarr'puynydja ŋuli ga djäga yan walalaŋ ŋurikiyiny warrakan'kuny malaŋuw. Ga nhumany ga dhuwal yolŋuynydja walal djuḻkmaraman ŋunhiyi warrakan'nhany malaŋuny.” ");
INSERT INTO djr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","“Ŋuli nhe dhu ga ŋunhi mirithirrnydja nhakun warwuyun ŋula nhakuny malaŋuw, ga nhaltjanna ŋayi dhu ŋuriŋiyiny djambin God-Waŋarrwuny ŋayaŋu nhuŋuny, märr nheny dhu ga baḏaknha yan walŋan marrtji? ");
INSERT INTO djr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ga nhaku nhuma ŋuli ga dhuwal warwuyun girriwny'tja malaŋuw gurrukanharaw? Nhäŋu ŋunha wurrkiny' malaŋuny, ya ŋunha, dhamany'tjunalil; yaka walal ŋuli gi girri' mala walalaŋguwuy djäma barrtjurr. ");
INSERT INTO djr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ga be ŋäthil buŋgawa yäku Djalaman gan nhinan, ŋunhi ŋayi gan nhinan mirithirr ḻukunydja ga guŋgurrkuŋgurr girriy' mala ga ŋula nhaliy malaŋuy. Yurr ŋunha wurrkiny' mala bulun dhika latjun' mirithirra, djuḻkmaraman ga girriny' mala nhanŋuny Djalamanguny. ");
INSERT INTO djr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yo. God-Waŋarryu ŋayipi ŋuli ga ŋunhi mulmunhany mala ŋuthanmaram manymakkumany, bäydhi ŋuli ga ŋunhi gurririny ŋayi walŋa dhärra. Nhakun dhiyaŋ bala ga dhuwal mala mulmu dhärra walŋa, ga bulu nhakun ŋayi ŋuli räwakthirryi, bala ŋuli yolŋu'-yulŋuynydja dhuŋgur'yunna ŋunhiyi mulmunhany. Yurr yolŋuny dhuwal mirithirr ŋurruŋu God-Waŋarrwalnydja ŋayaŋuŋur, djuḻkmaraman ga ŋunha mulmunhany; ga yuwalk ŋayi dhu ga djäga nhumalaŋ manymakkumany. Ga nhä nhumalaŋguny dhuwal yolŋuwnydja walalaŋ, märr-nhirrpanminyawuy nhanukalnydja God-Waŋarrwalnydja mirithirr nyumukuṉiny muka?” ");
INSERT INTO djr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Ga yaka walal gi warwuyurrnydja nhumalaŋguwuy nhuma, ga yaka nhuma dhu ga ŋunhi waŋa bitjandja, ‘Way, wanhaŋur ŋarra dhu dhuwal ŋathany märram, ga gapuny, ga girriny' malany?’ ");
INSERT INTO djr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bitjandhiny ŋuli ga ŋunhi mirithirrnydja warwuyun ŋunhiwurrnha yolŋu walal ŋunhi Djan'tayilnha mala. Nhumany dhu ga yaka bitjandhi warwuyun, bili ŋunhan ŋayipin Bäpa'mirriŋun nhumalaŋ djiwarr'puynha mirithirrnydja marŋgi, nhaku nhuma ŋuli ga ŋunhi djälmirriyirr. ");
INSERT INTO djr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yo. Yaka nhuma dhu ga warwuyun dhiyakiyiny malaŋuw. Ŋurrulilnydja nhirrpul God-Waŋarrwu yan rom, ga biyak bili gi djämany nhanŋuwuynha yan ŋamakurrnha romdja malany, bala ŋayiny dhu nhuŋu gurrupan bukmaknha yan nhä malany manymaknha.” ");
INSERT INTO djr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“Ga yaka warwuyurr ŋurikiny ŋunhi dhu nhä malany maḻŋ'thurr goḏarr' wiripuy waluy, bili ŋunhiyiny warwu malany yaka nhokal goŋŋur. Ga yaka marrtji mana'-manapulnydja bukulil ŋal'-ŋalmaraŋ warwuny mala nhuŋuwuy nhe, ŋunhi ga ŋuriŋiyi waluy gäma, balanya nhakun mari ga ŋula nhä malany. Yakan biyakiyiny guyaŋi.” Ga bitjarrnha ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ga balanya wiripuny Djesuw dhäruk, lakaraŋal ŋayi walalaŋgal bitjarr gam', “Yaka rom-nyamir'yurr wiripuŋuny yolŋuny, märr ŋayi dhu God-Waŋarryuny yakayi nhunanhany boŋguŋ rom-nyamir'yurr. ");
INSERT INTO djr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bili ŋayiny dhu ŋunhi God-Waŋarryuny nhunanhany mala-djarr'yurr biyakiyi muka bili, nhakun nhe ŋuli ga ŋunhi mala-djarr'yun ŋunha wiripuwurruny yolŋu'-yulŋuny. Ga ŋuli nhe dhu nhirrpan rom ḏäl mirithirr ŋunha wiripuwurruŋ yolŋu'-yulŋuw, ŋayiny dhu God-Waŋarryuny ŋunhi nhuŋuny bitjandhi bili yan nhirrpandhi ḏäl mirithirr rom.” ");
INSERT INTO djr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nhaku nhe ŋuli ga ŋunhi nhäma ŋunha wiripuŋuwalnydja yolŋuwal nyumukuṉiny dhukun ŋunhi ŋuli ga gärri nhanukal maŋutjiŋur? Nhe ŋathil dhu nhänhamirr nhunapinya nhe maŋutji; dhuwali nhokalnydja ga gärri maŋutjiŋur yindi warray dharpa. ");
INSERT INTO djr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Yol nheny dhuwal, ŋuli nhe dhu ga ŋunhi bitjandja waŋa ŋunha wiripuŋuwnydja yolŋuw gam', ‘Go! Marrtjin … ŋarra dhu wilaŋ'thunna dhuwali nyumukuṉiny'tja dharpa maŋutjiŋurnydja nhokal dhawaṯmaraman bitjanna,’ ŋunhi nhokiyingalnydja ga maŋutjiŋur gärri yindi warray dharpa. ");
INSERT INTO djr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nhä nhe dhuwal yolŋuny, dhuwurr dharrwa? Ŋurruŋuny ŋathil ŋurrkuŋ dhuwali yindi dharpa dhipuŋuryi nhokiyingal nhe maŋutjiŋur, märr nhe ŋathil dhu nhäma ŋamathamany, ga yurrnha nhe dhu nhäma nhaltjan nhe dhu dhawaṯmaram ŋunha wiripuŋuwal yolŋuwal maŋutjiŋur nyumukuṉiny dhukun.” ");
INSERT INTO djr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ga bitjarryi bili ŋayi wiripuny dhäwu Djesuy lakaraŋal, yurr mayali'kurra ŋayi ŋunhi dhawar'maraŋalnydja lakaraŋal bitjarrnha gam', “Nhä mala ŋunhi God-Waŋarrwu dharrpal rom mala, ŋunhiyiny nhe dhu bäyŋun yan gurrupan ŋurukuny ŋunhi wuŋganguny malaŋuw. Walal balaŋ bäynha bilyurr bala ḻäwuŋun nhuna. Ga yakayi ŋurrkuŋ ŋunhi mirithirrnydja mel-wiḏi'mirr ŋula nhä malany bikibikiwalnydja malaŋuwal gumurrlil, walal dhu ŋunhiyiny marrtji yanan bala wawun dhurrpa'-dhurrparaman.” ");
INSERT INTO djr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ŋäŋ'thurra God-Waŋarrnhany ŋula nhakuny malaŋuw, märr ŋayi dhu nhuna gurrupanna. Ga ḻarruŋun, märr nhe dhu maḻŋ'maraman. Ga dhurrwarany wutthu'-wutthurra, märr dhu God-Waŋarryuny nhuŋu dhurrwarany ḻapmaraman, gumurr-ŋamathirra manapan nhuŋu. ");
INSERT INTO djr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bili ŋuli ŋayi dhu ŋula yolthu ŋanya ŋäŋ'thun God-Waŋarrnha, bala walal dhu yan nhanukuŋuny märraman, ga ŋunhi yolŋu ŋunhi ŋayi ŋuli ga yuwalkkum yan ḻarrum, ŋayiny dhu God-Waŋarrwuŋuny maḻŋ'maraman. Ga ŋunhi yolŋu ŋunhi ŋayi ŋuli ga bitjan bili dhurrwara wutthu'-wutthun bala ŋayiny dhu God-Wäŋarryuny nhanŋu ḻapmaraman, galkikuman manapan ŋanya nhanukiyingalnha ŋayi. ");
INSERT INTO djr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nhuma ŋunhi bäpa'mirriŋu walal, ŋunhi nhumalany ŋuli gäthu'mirriŋuy walal nhumalaŋgal ŋäŋ'thun ŋathaw, ga nhä nhumany ŋuli gurrupan walalaŋguny … guṉḏa? Ŋany nhä?” ");
INSERT INTO djr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","“Ga ŋuli ŋayi dhu nhuna nhokal yothuy ŋäŋ'thun guyawnydja, ga nheny dhu nhän nhanŋuny gurrupan … bäpin? ");
INSERT INTO djr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yurr bäydhi nhuma ŋunhi djäga-yätjkurrmirrnydja mala bäpa'mirriŋu walal, yurr nhuma ŋuli ga ŋunhi gurrupandja nhumalaŋgalaŋaw gäthu'mirriŋuwnydja walalaŋ manymak yan ŋula nhäny mala. Ga nhumalaŋguny ŋunhi Bäpa'mirriŋu djiwarr'puynydja bulu warray wetj-ḏumurr; djuḻkmaram warray ŋuli ga nhumalanhany, nhanukiyingalnydja ŋayi wetjthu, ŋunhi limurr ŋuli ŋäŋ'thundja ŋanya.” ");
INSERT INTO djr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ŋuli nhe dhu ga ŋunhi ŋula nhaku malaŋuw djälmirriyirr walal dhu ga ŋunha wiripuwurruy yolŋuy walal djäma nhuŋu, ga nheny dhu ga ŋunhi bitjandhi bili yan walalaŋguny djämayi ŋula nhä malany. Ga balanya ŋunhi mayaliny' Mawtjitjkuŋuny rom nhirrpanawuy ga Djawarrkmirriwuŋuny walalaŋguŋ marŋgi-wurrupanawuy.” Mathuyu 7.13-14 Ga dhuwandja ŋayi Djesuy lakaraŋal wiripun dhäwu mayali'kurr bitjarrnha gam', ");
INSERT INTO djr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Märrma' yan ga dhuwal dhurrwarany dhärra gärrinyarawnydja nhumalaŋ. Yo waŋganydja ŋunhiyi dhurrwara yindi mirithirr, yurr ŋunhiyiny dhurrwara gumurr-yalŋgi gärrinyaraw, ga dhukarrnydja ŋunhiyi yindin marrtji ŋorra balan bitjanna wäŋalil dhä-gir'yunamirrilila. Ga dharrwan ŋuli ga ŋunhi yolŋuny walal wäŋgam ŋuliwitjandhiny dhukarrkurr. ");
INSERT INTO djr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ga wiripuny dhurrwara nyumukuṉiny'nha mirithirra, yurr mirithirra ŋunhi gumurr-ḏälnha ŋunhiyi dhukarr ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi walal ŋuli ga djälthirr marrtjinyaraw balayiny wäŋalil walŋamirrililnydja. Yurr ḻurrkun'thun yan yolŋuynydja walal ŋuli ŋunhi maḻŋ'maramany ŋunhiyiny dhukarr.” Mathuyu 7.15-20 Ga wiripuny ŋayi Djesu dhäruk waŋan bitjarr gam', ");
INSERT INTO djr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Way walal, djäga walal gi nyäḻmirriwnydja djawarrkmirriw walalaŋ. Ŋayiny dhu ŋunhiyi yolŋu maŋutjiŋurnydja nhumalaŋgal yanbi ŋayi dhuwurr-dhunupan, yanbi ŋayi manymaknha yolŋu, yal'yunan, balanya nhakun bimbin. Yurr yuwalktja nhanŋu ŋunhi ŋayaŋuny balanya nhakun wärraŋnha.” ");
INSERT INTO djr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“Nhuma dhu nhämany dharaŋana ŋanya nhäthinya nhanukuŋ djämapuy gakal'. Bili djämapuynydja walalaŋguŋ ŋunhi mirithirra yätjkurra. Balanya nhakun borum yalman ŋuli dhakal ŋuthan yalmanŋur yan dharpaŋur; bäyŋun nhuma dhu maḻŋ'maram yalmannha dhakal ŋula wiripuŋuwalnydja dharpawal ḏirriṯirriwalnydja. Ga muthirny'tja borum ŋuli yaka ŋuthul guḻumunyu'ŋurnydja dharpaŋur; ŋany muthirny'tja ŋuli ŋuthan nhanukiyingal muthir'ŋur yan yaŋara'ŋur. ");
INSERT INTO djr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ŋuli ŋayi dharpa manymaktja, ga dhakalnydja nhanŋu borumdja dhu ŋunhiŋuwuyyi ga manymakthi yan. Ga ŋuli ŋayi dharpa yätjkurrnydja, ga dhakalnydja dhu borumdja balanyayi bili yätjkurryi yan. ");
INSERT INTO djr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Bili manymakŋurnydja dharpaŋur nhe dhu bäyŋun ŋula yätjkurrnydja borum maḻŋ'maram, ga yätjkurrŋurnydja dharpaŋur nhe dhu bäyŋun ŋula maḻŋ'maram manymaktja borum. ");
INSERT INTO djr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ga ŋuli ŋayi borumdja ŋunhiŋuwuy dharpapuy yakany manymak, bala ŋayi dhu djämamirrnydja marrtjin, bala walal dhu djatthunna ŋunhiyi dharpany, bala yan ŋurrkaman gurthalila. ");
INSERT INTO djr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yo. Ga ŋunhiwurrunhany ŋunhi nyäḻ'mirrinhany djawarrkmirriny mala, nhumany dhu ŋunhi dharaŋana walalany, ŋuruŋun ŋunhi nhäthinya walalaŋguŋ djämapuy mala.” Ga bitjarra ŋayi gan Djesuy marŋgikuŋalnydja walalany. Mathuyu 7.21-23 Wiripuny ŋayi Djesu dhäruk nhirrpanmin bitjarrnha gam', ");
INSERT INTO djr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Dharrwaynha ŋuli ga dhuwal yolŋu'-yulŋuynydja ŋarranhany yäku-lakaram bitjandja gam', ‘Garray! Garray!’ bitjandja. Yurr bäyŋun walal dhu ŋunhi gärriny boŋguŋ ŋunhawalnydja ŋunhi God-Waŋarrwalnydja yirralkalil. Ŋunhiwurrnha bili dhu ŋunhi yolŋuny walal gärri ŋunhi walal dhäruk-märranhamirra mala ŋarrakalaŋawnha Bäpa'mirriŋuw djiwarr'puywun. ");
INSERT INTO djr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yo. Ŋuriŋiyiny waluy dhä-dhawar'yunamirriynydja, dharrwaynha dhu ŋunhi yolŋuynydja walal waŋiny ŋarranhany biyakun, ‘Garray, ḻapmaraŋ ŋarraku dhurrwara. Ŋarrany ŋuli ganha ŋunhi dhäwu lakaranha nhokiyingalaŋuwurr yan yäkukurr, ga bulu nhokal yäkuynydja ŋarra ŋuli ganha wakinŋunhany mala birrimbirr dhawaṯmaranha yolŋuwalaŋaŋurnydja. Ga nhokiyingalaŋuwurryi yan yäkukurr ŋarra ŋuli ganha djäma yindiny rom ŋunhi ŋoy-ganyim'thunamirrnydja mala.’ Ga biyakiyin dhu boŋguŋ ŋunhi wiripuwurrnydja yolŋu walal lakaranhamirr.” ");
INSERT INTO djr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Bala ŋarrany dhu waŋin walalaŋ biyakun gam', ‘Gatjuy gundupuŋun walal, nhuma rom-djarrpi'mirrnydja yolŋu mala. Yaka ŋarra dhuwal nhumalaŋ marŋgi.’” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja. Mathuyu 7.24-29 Ga bulu ŋayi Djesuy dhawurrpunuŋalnydja dhäwu lakaraŋal walalaŋ bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Yo. Bilin dhuwal. Bili muka nhuma ŋarrany gan ŋula ŋäkulnydja dhäruktja malany, nhaltjarr ŋarra gan lakaraŋal nhumalaŋgal. Ŋuli nhe dhu ga dhärukku malthun ŋarrakuny, ga nheny dhu ŋunhiyiny balanyan nhakun gaḏamannha yolŋu, ŋunhi ŋayi dhuḻ'yurr balany' nhanŋuwuy ŋayi wäŋalil guṉḏamirrilil. ");
INSERT INTO djr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Bala waltjaṉdja yindin marrtjin dharyurr, ga gapuny mayaŋdja marrtjin yindithinan, ga yan warray bili-i-i ga wäŋa ŋunhi warrpam' buku-ḻupmaraŋal, ga watany yindin gan biw'yurr mirithinan dhika, yurr bäyŋun ŋunhiyi balany' ŋula galkirrinya; ḏälnha gan yan dhärran, bili ŋayi ŋuriŋiyi yolŋuy dhuḻ'yurrnydja nhanŋuwuy balany' guṉḏamirrilila wäŋalil.” ");
INSERT INTO djr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ga ŋuli nhe dhu ŋula yolthu yolŋuy ŋämany ŋarrany dhäruk bäykarraramany, märr-yuḻkthundja manapan, ga nheny dhu ŋunhiyiny balanyan nhakun ŋunhi ḻiya-dhumuknha yolŋu, ŋunhi ŋayi dhuḻ'yurr nhanŋuwuy ŋayi bala' munatha'lil wäŋalil, ");
INSERT INTO djr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","bala waltjaṉdja marrtjin yindin dharyurr, ga gapu mayaŋ marrtjin yindithinan, ga yan warray bili ga wäŋa ŋunhi warrpam' ŋurruthin, bala wäŋiny yindin biw'yurra mirithinan dhika, bala ŋunhiyi bala'nhany ḏaw'maraŋala, bala ŋayi galkirrinan, buḻ'waŋdhurra warrpam'nha.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja yolŋu'-yulŋuwalnydja. ");
INSERT INTO djr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ga ŋunhi ŋayi Djesu dhawar'yurrnydja lakaranhaŋurnydja, bala dharrwaynha yolŋuynydja walal ŋäkula ŋanya, nhakun walal ganyim'thurra manapar nhanŋu, ŋurikiyin ŋunhi nhaltjarr ŋayi gan marŋgi-wurrupar walalany. ");
INSERT INTO djr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bili dhuwandja yolŋu yaka warray balanya nhakun wiripuwurr rom-marŋgikunhamirr walal. Ŋayiny dhuwal Djesuny gäna warray, ga dhäruktja nhanŋu bulu dhika ganydjarrmirr. ");
INSERT INTO djr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ga ŋunhi ŋayi marrtjin Djesu yarrupthurrnydja beŋurnydja ŋunhi bukuŋurnydja, ga yolŋuny walal nhanŋu marrtjin malthurrnydja dharrwan dhika mirithirra. ");
INSERT INTO djr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ga bondi yan muka waŋganydja yolŋu ŋunhi ŋayi gan burrunhdhiya' rerri ŋayathaŋal bunanan nhanŋu Djesuwnydja, marrtjinany ŋayi ŋunhi yolŋuny, bala yan bun'kumu-djipthurra gumurrŋura nhanukal Djesuwalnydja, bala yan waŋanany bitjarra, “Yolŋu marrkapmirr, dhuwal nhe ga ŋayatham ganydjarr nhe dhu ḏukmaram ŋarrany, yurr nhokiyingal yan djällilnydja ŋarra dhu ganarrtham,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Bala ŋayi yan Djesuny goŋ-djarryurra bala ŋayathaŋala ŋanya ŋunhiyi yolŋunhany, bala yan bitjarra waŋan nhanukal gam', “Yo! Djäl ŋarra, dhiyaŋuny bala nhe dhu ḏukthunna dhipuŋuryiny rerriŋur.” Ga dhunupan bala yan nhanŋu ŋunhi ḏirramuwnydja burrunhdhiyany rerri winya'yurra dhika! ");
INSERT INTO djr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Bala ŋayi Djesuny waŋan nhanŋu bitjarra gam', “Yaka nhe dhu dhuwalaŋuwuynydja ŋula yolkal lakaram ŋini, balan yan nhe dhu dhunupan marrtjiny djirrikaymirriwalnha yolŋuwalnydja, ga ŋayin nhuna dhu nhämany rumbalnydja ŋunhi nheny dhuwal ḏäwalan. Bala beŋuryiny nhe dhu mundhurrnha gäma balan buku-ŋal'yunamirrilila buṉbulil, bitjan yan bili nhakun ga ŋunha Mawtjitjku rom barraŋga'yun, ŋurikiyin bili yan nhe dhu malthundja. Ga ŋunhi nhe dhu mundhurr-gurrupandja, bala walalnydja dhu ŋunhi yolŋuny walal marŋgithirra ŋunhi nheny dhuwal bilin ḏukthurra burrunhdhiyaŋurnydja rerriŋur.” ");
INSERT INTO djr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ga beŋuryiny ŋayi ŋunhi Djesuny marrtjin balan bitjarra wäŋalil yäkulil Gapuniyamlila, ga ŋunhi ŋayi bunanany ŋunhiliyiny wäŋaŋur, bala ŋayiny ŋunhi waŋganydja ḏirramu dhunupan bunanan nhanŋu, yurr ŋayi ŋunhi ŋurru-warryunayŋu miriŋuw balanya. Bala yan ŋayi ŋunhi bitjarra nhanŋu Djesuwnydja waŋan gam', ");
INSERT INTO djr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Garray! Ŋunha ŋarraku djämamirr ga rerrikthun mirithirr, yurr ŋunha banydji ŋayi wäŋaŋur yulŋuny, balayi ŋarra ŋanya ganarrthaŋalnydja, ga dhaŋga-ḏirryundja ŋayi ga ŋunha mirithirra ŋuriŋiyi rerriynydja, yakan ŋayi ga ŋunha bilyu'-bilyundja, yan ŋayi ga ŋunha dharraḏan ŋorrany.” ");
INSERT INTO djr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Yo! Ŋarra dhu marrtji ga ḏukmaram ŋanya,” bitjarr ŋayiny Djesuny buku-bakmaraŋal nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yurr ŋayiny ŋunhi ḏirramuny nhanŋu bitjarr warray waŋan gam', “Garray, nhämirr balaŋ nhe dhu dhäruknha yan gurrupanmirr, bala ŋayiny dhu ŋunha djämamirrnydja ŋarraku ḏukthuna, ŋuriŋin bili yan dhärukthun nhokal. Bili yaka ŋarra dhuwal gana' nhuŋu, ŋuli balaŋ nhe dhu ŋarrakalnydja wäŋalil marrtji. ");
INSERT INTO djr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ŋunha ŋarraku buŋgawa mala ga nhina'-nhina, ŋunhi walal ŋuli djäma gurrupandja ŋarrany, ŋarrany ŋuli yan dhunupan djäman, ŋunhi nhaku walal ŋuli dhäruk-gurrupanmirr. Ga wiripuny ŋunhayi miriŋu mala, ŋunhi walalnydja ŋarrakalnha goŋŋur, ŋarran walalaŋ buŋgawany, ŋunhi ŋarra ŋuli gorrwumany walalany ŋula nhakuny djämaw, walalnydja ŋuli dhunupan djäman yan. Ga ŋunhi ŋarra dhu waŋa bitjan gam', ‘Go, räli marrtji,’ ŋayiny dhu dhunupan marrtjin yan. Ga wiripuŋuwnydja ŋarra ŋuli waŋa bitjan, ‘Gatjuy marrtjin,’ ŋayiny dhu ŋunhi marrtjin yan. Ga djämamirriwnydja ŋarra ŋuli waŋa bitjan, ‘Ŋay' dhuwal djäma,’ ŋayiny dhu ŋunhi djäman yan, yakan ŋayi ŋarrany dhu märr-yuḻkthundja.” ");
INSERT INTO djr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ga ŋunhi ŋayi Djesuy ŋäkulnydja ŋanya ŋunhiyi ḏirramunhany, balanyawuyyiny waŋanhawuy, bala yan ŋayi mirithinan ṉirr'yurrnydja, nhanŋu ŋurikiyi ŋurruḏawalaŋuwnydja miriŋuw ḏirramuw. Bala ŋayi dhunupan bala yan Djesuny bilyurrnydja, bala yan waŋanan ŋurikiwurruŋguny yolŋuwnydja walalaŋ, ŋunhi walal gan malthurr nhanŋu, bitjarra gam', “Bäyŋu ŋarra dhuwal maḻŋ'maranha märr-yuwalkthinyawuy ŋunhi yindi mirithirr, ŋula waŋganygu yolŋuw dhiyalnydja wäŋaŋur ŋarakaŋur Yitjuralnydja, balanyany nhakun dhiyakuny gay'yi yolŋuw ḏirramuw miriŋuw! ");
INSERT INTO djr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Dhuwandja yuwalk nhumalaŋ dhäwu ŋarra ga lakaram. Yo, ŋunhawalnydja ŋunhi God-Waŋarrwalnydja yirralkalil yalalaŋumirriynydja dhu dharrwan mirithirra yolŋuny walal marrtji buku-ḻuŋ'thurrnydja beŋur dhimurruŋur gali'ŋur ga bärra'ŋur ga ḻuŋgurrmaŋur ga djalathaŋŋur. Bala walal dhu gi ŋunhi ŋathan ḻukiny yindin mirithirra, rrambaŋin walal Yipurayimdhu, Yitjakthu ga Djaykupthun. ");
INSERT INTO djr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yurr ŋarrakuwuynydja mala ŋunhi Djuw malany, ŋunhi walal balaŋ muka ŋunhi yuwalktja gulŋiyi balayiny God-Waŋarrwalnydja romlil. Walalnydja dhu gi ŋunhi warraŋulnha nhini, ŋunhala buku-munha'ŋura, dhawa-dhawaṯmaraŋun walalany dhu, beŋuryiny ŋunhi ŋathamirriŋurnydja wäŋaŋur. Bala walal dhu gi ŋunhi ḻirra-ḻäwunhamirra ŋunhiliny wäŋaŋur, dhäkay-ŋäkuny walal dhu gi ŋunhi dhaŋga-ḏirrnha ga mur'murnha rumbalyuny walalaŋgiyingal walal.” ");
INSERT INTO djr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ga beŋuryiny dhurrwaraŋur, bala yan ŋayi Djesuny bitjanna nhanŋu waŋa gam' ŋurikiyi ŋurru-warryunayŋuwnydja miriŋuw, “Gatjuy marrtjin roŋiyin wäŋalila nhokiyingal nhe, bili nhokal märr-nhirrpanminyaray ŋarrakal, ŋarrany dhu djäman bala yan nhuŋuny ŋayaŋuw, nhaku nhe ga dhuwali djälthirr.” Ga ŋunhi ŋayi Djesu dhäruk-gurrupanmirrnydja bitjandhiny, bala dhunupan bala yan ŋayiny ŋunhi djämamirrnydja nhanŋu yolŋu, ḏukthurra ŋuriŋi bili yan waluynydja. ");
INSERT INTO djr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ga dhäŋur beŋuryiny, bala ŋayi Djesuny balan marrtjin Betawala wäŋalil. Ga ŋunhilin wäŋaŋur ŋayi Djesuy nhäŋal waŋganynha rerrimirriny miyalknha, yurr ŋayi ŋunhi miyalktja mukul'mirriŋu nhanŋuny Betawnydja yurr rumaru'. Rirrikthurrnydja ŋayi gan ŋunhi miyalktja, mirithin dhika ḏälyu yan gorrmur'yu, yurr ŋayi gan ŋunhi ḻäy-ŋorranan yan ŋunhili miṉdhalaŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Bala ŋayiny ŋunhi Djesuny marrtjinan bala yan goŋnha ŋanya ŋayathaŋal ŋunhiyi miyalknhany, ga dhunupan bala yan ŋayiny ŋunhi rerriynydja gorrmur'yuny ŋanya ganarrthaŋala yan, bala yan ŋayi dhunupan rur'yurra bala dhärranan, bala ŋathan marrtjin djäma nhanŋun Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ga ŋunhi ŋayi marrtji waluny gärrin, walalnydja marrtjin ŋunhi yolŋu'-yulŋuynydja gäŋa'-gäŋala yolŋunhan mala ŋunhi walalaŋgal gan wakinŋu birrimbirr mala gärrin, dharrwan dhika mirithirra yolŋu'-yulŋu. Yurr ŋayiny walalany gan ŋunhi Djesuynydja dhärukthun yan waŋganydhun ŋaŋ'ŋaŋ'thurr, ŋunhiwurrunhany ŋunhi yätjkurrunhany birrimbirrnha malaŋuny, ŋunhi walal gan gärrin ŋurikiwurruŋgal yolŋuwal walalaŋgal. Ga yol mala gan ŋunhi rerrikthurr, ŋayiny gan ŋunhi Djesuynydja walalany ḏukmaraŋala bitjarryi bili bukmaknha yan. ");
INSERT INTO djr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yo. Ga bitjarryin ŋayi gan ŋunhi Djesuy djämany, märr ŋunhiyiny ŋunhi ŋayi God-Waŋarryu ŋäthil dhawu'-nhirrpar ŋunhal ŋäthiliŋuŋur djorra'ŋur yuwalknha yan maḻŋ'thurrnydja, ŋunhi ŋayi gan djawarrkmirriy yäkuy Yitjayay ŋäthil lakaraŋal bitjarr gam', “Ga rerriny mala ŋanapurruŋ ŋayi ḏukmaraŋal yan, ga nhinanany ŋanapurr gan ŋunhi ḻayurra nhanukuŋ,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ga ŋunhi ŋayi Djesuy nhäŋal dharrwanhany mirithirrnydja yolŋuny walalany, ŋunhi walal marrtjin ḻuŋ'thurrnydja nhanukal, bala yan ŋayi dhäruk-gurrupanminan nhanukiyingalaŋuwalnydja ḻundu'mirriŋuwal walalaŋgal bitjarra, “Limurr marrtjin, buḏapthunna dhiyakuny guḻunguny ŋunha gali'lila.” Bala yan walal ŋunhi buḏapthurra marthaŋayyun ŋurikiyi guḻun'kuny yäkuw Galaliwnydja. ");
INSERT INTO djr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ga ŋunhi walal buḏapthurrnydja ŋurikiyi yindiwnydja guḻun'ku, bala ŋayiny waŋganydja ḏirramu marŋgikunhamirr dhunupan marrtjinan guwatjmara ŋanya Djesunhan. Yurr ŋayi ŋunhi marŋgi mirithirr Mawtjitjkalaŋawnydja romgu. Ga bitjarra ŋayi ŋunhi waŋanany ŋanya Djesunhany gam', “Way! Marŋgikunhamirr, ŋarrany nhuŋu dhu dhuwal malthunna bay! Ŋuli nhe dhu ŋula nhälil djälthirr marrtjinyaraw, ŋarrany dhu malthunna yan nhuŋu.” ");
INSERT INTO djr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yurr ŋayiny Djesuny bitjarr warray nhanŋu waŋan gam', “Ŋunha wärraŋguny malaŋuw ga dhärra ŋarŋga', ga wiripuny warrakan'ku malaŋuw ŋunhi buṯthunamirriw, walalaŋguny ga dhärra yalu'. Yurr nhanŋuny ŋunhi Yolŋuwnydja Gäthu'mirriŋuw bäyŋu warray gi dhärri ŋula wäŋa, ŋunhi ŋayi dhu ŋir'yunmirr ga ŋorra ŋunhili wäŋaŋur nhanukiyingal ŋayi.” ");
INSERT INTO djr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ga waŋgany yolŋu nhanŋu malthunamirr waŋan nhanŋu Djesuw bitjarr, “Garray baḏak ŋathil, ga bäy ŋarra dhu bäpa'mirriŋuny ŋarrakuwuy dholkum.” ");
INSERT INTO djr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yurr ŋayiny Djesuny bitjarr warray nhanŋu buku-bakmaraŋal gam', “Nheny dhu ŋarrakun malthun, ga ŋunhi dhiŋganhawuynhany yolŋuny walalany dhu dholkum ŋuriŋiwurruynha bili yan ŋunhi birrimbirr-rakunymirriynha yolŋu'-yulŋuy.” ");
INSERT INTO djr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ga beŋuryiny dhurrwaraŋur bala ŋayi Djesuny ga ŋunhi malthunamirrnydja mala nhanŋu marrtjinan marthaŋayyun. ");
INSERT INTO djr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ga dhunupan bala yan, yindin mirithirra watany walalaŋ bunan, bala gan ḏowuny ŋal'yurra, galki balaŋ ŋunhi marthaŋaynydja ḻupthunan. Yurr ŋayiny Djesuny marrtjin yakurrnha ŋorran ŋunhilin marthaŋayŋura djinawan'. ");
INSERT INTO djr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bala walalnydja ŋunhi malthunamirrnydja mala, dhunupan yan marrtjinan nhanukala Djesuwala bala gan dhirr'yurra ŋanya, ga waŋan walal nhanukal bitjarra, “Way! Garray, dhuwal limurr dhu ḻupthunna, go walŋakuŋ limurruny.” ");
INSERT INTO djr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yurr ŋayiny Djesuny bitjarr warray walalaŋ buku-bakmaraŋal gam', “Nhaku nhuma ga dhuwal barrarirrnydja, … nhä nhumalaŋ dhuwal märr-yuwalkthinyawuynydja nyumukuṉiny' yan muka?” Bala yan ŋayi Djesuny rur'yurrnydja bala waŋanan gulmaraŋala ḏälyun dhärukthuny ŋunhiyi watanhany ga ḏowunhany, ga dhunupan bala yan ŋunhi warrpam'nha wapurarryinan. ");
INSERT INTO djr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bala walalnydja ŋunhi ḏirramuwurrnydja ŋunhili marthaŋayŋurnydja mirithinan dhika ŋoy-ganyim'thurrnydja makmakthurra manapar nhanŋu Djesuwnydja bala walal waŋanhaminany bitjanminan gam', “Yol dhuwal ŋayi yulŋuny? Ŋunhi ga dhuwal wataynydja ga ḏowuynydja dhäruk-märram warray ŋanya.” ");
INSERT INTO djr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ga beŋuryiny dhurrwaraŋur bala walal ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu buḏapthurra yan manymakkuŋala marthaŋayyuny ŋunha gali'lilnydja, ga dhawaṯthurrnydja walal ŋunhi galkin yanan ŋunhiliyin wäŋaŋurnydja yäkuŋur Gadaran, bala yan walal marrtjin wäŋgala dhukarr-ŋupara bala. Ga dhunupan bala yan märrmany' ḏirramu maṉḏa wakinŋumirr birrimbirrmirr maṉḏa guwatjmara ŋanya räli Djesunhany, yurr beŋur maṉḏa gan ŋunhi marrtjinany molumirriŋur. Ga rumbalnydja maṉḏa ŋunhi dhakaṉnha dhika mirithirra ga maḏakarritjnha, ŋunhi bäyŋun ganha yolŋu walal marrtjinya ŋuliwitjanayi ŋäthilnydja bili maṉḏaŋgun walal ŋuli ganha barrarinya. ");
INSERT INTO djr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ga dhunupan maṉḏa marrtjin ŋunhi ḏirramuny waŋanany yatjurra dhika bitjarra gam', “Djesu, Gäthu'mirriŋu God-Waŋarrwu, nhaku nhe djälnydja? Dhuwal nhe räliny marrtjin nhe dhu dhä-gir'yunna napurruny muka?” ");
INSERT INTO djr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ga ŋunhili galki yan yaka barrkuny, dharrwa gan bikibiki mala dhärra'-dharran, mulmu walal marrtjin ḻukan. ");
INSERT INTO djr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bala yan ŋuriŋiwurruynydja ŋunhi wakinŋumirriynydja birrimbirryu mala, waŋanan ŋanya Djesunhany bitjarra gam', “Buku-djulŋi ŋuli nhe dhu ŋunhi ŋaŋ'ŋaŋ'thundja dhawaṯmaramany napurruny, balan ŋanapurruny nhe dhu djuy'yundja bikipikiwala malaŋuwal!” ");
INSERT INTO djr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Bala ŋayiny yan Djesuynydja waŋanan ŋunhiwurrnhany ŋunhi wakinŋunhany birrimbirrnhany malaŋuny, bala yan bikipikiwalnha malaŋuwal walalany djuy'yurr. Ga dhunupan bala yan walalnydja ŋunhi bikipikiny mala bukmaknha gan gudupuŋalnydja balan bitjarra gapulila guḻunlila gan dhaḻwirrirriyurr, ga warrpam'nha walal ŋunhi dhiŋgaŋalnydja ŋunhilin gapuŋura. ");
INSERT INTO djr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bala walalnydja ŋunhi bikipiki djägamirrnydja mala waṉḏi'-waṉḏinan balan wäŋalila, bala marrtjin lakaraŋala yolŋu'-yulŋuwala dhäwun, ŋunhi nhaltjarr walalaŋ maḻŋ'thurr. Ga mirithinany walal marrtjin lakaraŋal ŋunhi nhaltjarr ŋayi Djesuy dhawaṯmaraŋal ŋunhiyi wakinŋuny birrimbirrnha mala ŋurikalyi ḏirramuwal maṉḏaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ga bukmaknha gan ŋunhi yolŋu'-yulŋuny marrtjin balayin nhanukala Djesuwala. Ga ŋunhi walal nhäŋalnydja ŋanya bala yan walal ŋanya waŋanan mirithinan, ŋayi dhu marrtjin ganarrthaman walalany, beŋuryiny ŋunhi walalaŋgalaŋaŋurnydja wäŋaŋur bala bitjanna wiripuŋulila wäŋalil. ");
INSERT INTO djr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Bala ŋayi Djesuny wapthurra marthaŋaylila bala yan buḏapthurra balayin wäŋalil ŋunhi ŋayi gan ŋäthil nhinan. ");
INSERT INTO djr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ga ŋunhiliny walal yolŋu'-yulŋuynydja marrtjin gäŋalnha nhanukal Djesuwalnydja bundhurrnhan yolŋuny, yurr djaṉdjaṉdhurr walal marrtjin ŋanya ŋunhi yulŋuny wiṉiṉdhu, yurr mata'maranhawuy dharpalil märrma'lil. Ga ŋunhi ŋayi Djesuy nhäŋalnydja walalany, bala yan ŋayi makmakthurra walalaŋ, ŋunhi walal gan märr-yuwalkthin nhanŋu. Bala yan ŋayi bitjarra ŋunhi waŋanany ŋurikiyiny gaṉuŋguny yolŋuw gam', “Way! Gäthu, yaka warwuyurr! Bilin nhuŋu dhuwurr-yätjtja rom malany bäy-lakaranhawuynha.” ");
INSERT INTO djr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ga ŋunhili gan dhärra'-dharran rom-marŋgikunhamirr mala, ŋunhi walal ŋuli ga marŋgikum ŋäthiliŋu rom Mawtjitjkuŋ gurrupanawuy. Ga ŋunhi walal ŋäkulnydja ŋanya Djesunhany balanyawuynydja waŋanhawuy, bala walal bitjarra gan waŋanhaminany gam', “Nhä ŋayi ŋunha Djesuny God-Waŋarrnha muka!” ");
INSERT INTO djr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yurr ŋayiny Djesuny marŋgithin walalaŋ ŋunhi nhaltjarr walal gan guyaŋan, bala yan ŋayi bitjarra walalaŋ waŋanany gam', “Nhaltjan nhuma ga dhuwal bitjandja djarrpi'kumany guyaŋa ŋarraku? ");
INSERT INTO djr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","… nhä ŋunhi manymaktja, nhaltjanna balaŋ ŋarra ŋunhi yuwalktja waŋanha dhiyak ḏirramuwnydja? Ŋayi balaŋ yan rur'yunan bala yan marrtjinyan balan wäŋalila wo lakaram yan nhanŋu ŋunhi dhuwurr-yätjkurrnydja mala rom nhanŋu bilin bäy-lakaranhawuynha? ");
INSERT INTO djr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yurr ŋarrany dhu milkuman nhumalaŋ, ŋunhi Yolŋuwnydja Gäthu'mirriŋuw dhuwal dhunupa yan ŋayi dhu bäy-lakaram yolŋuw walalaŋ dhuwurr-yätjkurr rom malany dhiyal munatha'ŋurnydja wäŋaŋur.” Bala yan ŋayi Djesuny waŋanan nhanukal ŋurikalyiny gaṉuŋgalnydja ḏirramuwal bitjarra gam', “Gatjuy rur'yurra, ga märraŋun nhuŋuwuy nhe miṉdhalany bala yan marrtjin wäŋalila.” ");
INSERT INTO djr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bala yan ŋayiny ŋunhi ḏirramuny rur'yurrnydja bala yan marrtjinan wäŋalila. ");
INSERT INTO djr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ga ŋunhi walal yolŋu'-yulŋuynydja nhäŋal, ŋunhi nhä ŋunhiliyi maḻŋ'thurr, bala yan walal mirithinan dhika barrarinany, bala yan walal gan wokthurra God-Waŋarrwuny ŋunhi nhaltjarr ŋayi gan ganydjarr gurrupar walalany yolŋu'-yulŋuny mala. ");
INSERT INTO djr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ga ŋunhi ŋayi Djesuy ganarrthaŋalnydja ŋunhiyiny wäŋa, bala ŋayi yan nhäŋala ḏirramunhan yäkuny Mathuyunhan ŋayi gan nhinan, rrupiya marrtjin gombu'-gumbuŋal yolŋuny walalany, bili nhanŋu ŋunhiyi djäma buŋgaway mala djäma gurrupar ŋanya. Bala ŋayiny Djesuny nhanŋu bitjarra waŋan gam', “Nheny dhu ŋarrakun malthun!” bitjarr, bala ŋayiny ŋunhi Mathuyuny dhunupan rur'yurrnydja, bala yan malthurra nhanŋun Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ga beŋuryiny ŋayiny Djesuynydja ga malthunamirriynydja mala nhanukal gan ŋathan ḻukan ŋunhiliyin nhanukala Mathuyuwala wäŋaŋur. Ga ŋunhili wäŋaŋurnydja nhanukal dharrwan mirithirra rrupiya-märranhamirrnydja gapmangu yolŋu walal ḻuŋ'thurr, ga wiripuny dhuwurr-yätjmirra mala ḻuŋ'thurr balayi. ");
INSERT INTO djr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bala walalnydja ŋunhi wiripuwurruynydja Baratjiynydja malay, dhä-birrka'yurra ŋunhiwurrunhan ŋunhi Djesuwnha malthunamirriny mala, bitjarra gam', “Way! Nhaku muka ŋayi ŋuli ga ŋunha nhumalaŋgal marŋgikunhamirriynydja ŋatha ḻuka mala-manapan ŋurikiwurruŋgalnydja ŋunhi rrupiya-märranhamirriwalnydja yolŋuwal walalaŋgal ga dhuwurr-yätjmirriwalnydja?” ");
INSERT INTO djr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yurr ŋayiny ŋunhi Djesuynydja ŋäkul walalany bala yan ŋayi bitjarra waŋanany walalaŋ buku-bakmaraŋalnydja gam', “Wäy, ŋunhiwurrnydja yolŋu walal ŋunhi ḏäwalamirrinhany rerrimiriwnhany mala ŋuli bäyŋu warray nhäma marrŋgitjthu. Ŋany nhämany ŋayi dhu ŋunhiwurruny bili yan rerrimirrinhan mala. ");
INSERT INTO djr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gatjuy marrtjin walal ga bulu marŋgithi Dhuyuw Djorraw' ŋunha Ŋäthiliŋuŋur gali'ŋur, ga maḻŋ'maram yan nhuma dhu mayali' ŋunhi ga dhäruk ŋunhili waŋa bitjan gam', ‘Yaka yan gi mundhurr-gurrupulnydja ŋarraku, ŋarrany dhuwal djäl nhuma dhu ŋathil mel-wuyun ŋunha wiripuwurruŋ yolŋuw walalaŋ.’” “Ŋarrany dhuwal yaka marrtjinya räli ŋarra dhu manymakmirrinhany yan märram malthunamirriny ŋarrakuwuy, ŋany ŋunhiwurruny yolŋuny walalany wiripuny ŋunhi walal dhuwurr-yätjmirr mala.” ");
INSERT INTO djr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Waŋganymirrnydja waluy malthunamirr mala Djongu ŋunhi ŋayi gan buku-ḻupmaraŋal yolŋuny walalany gapuy, marrtjin nhanukal Djesuwal, bala walal dhä-birrka'yurra ŋanya bitjarra gam', “Dhuwal napurrnydja, ga ŋunhawurr ŋunhi Baratjiny mala, dharrwamirr ŋuli ga ŋoy-ŋathamiriw warray nhina ŋunhi ŋanapurr ŋuli buku-ŋal'yundja nhanŋu God-Waŋarrwuny. Yurr nhuŋuny ŋunhi malthunamirr mala yaka ŋuli gi biyakiyi ŋoy-ŋathamiriw nhini.” ");
INSERT INTO djr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bala ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarra gam', “Ŋunhi ŋuli dhiyaŋ bili muka ḏirramuy märram nhanŋuwuy ŋayi miyalknha, ga walalnydja ŋuli ŋunhi ḻundu'mirriŋuynydja mala nhanukal ŋathany marrtji ḻukan dhika ŋoy-djulŋithirra manapan, balanyamirriynydja waluy ŋunhi maṉḏa ŋuli märranhamirrnydja. Ga bäy ŋayi dhu ŋunhi dhuway'mirriŋuny nhakun marrtjin, ganarrthaman walalany, bala yorrnha walalnydja dhu ŋunhi dhuḏitjnha ŋoy-ŋathamiriwnydja nhina ḻundu'mirriŋuny mala nhanŋu.” ");
INSERT INTO djr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Yo, marŋgi muka nhuma ŋunhi girriwny'tja. Ŋuli dhu ŋula yolthu yolŋuy dharpum girri', bäyŋun ŋayi dhu ŋunhi yuṯany girri' dharpum balany ŋunhi ŋäthiliŋulilnydja dhä-manapan, ŋayi balaŋ bäynha ŋunhiyi yuṯany girri' dhurŋ'thurra, bala yan yarrar'yurra, bala ŋuli ŋunhi ŋarŋgany yindithin mirithin.” “Ga wiripuny dhäwu, ŋunhi limurr marŋgi mirithirr. ");
INSERT INTO djr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bäyŋun yanbi limurr dhu ga ŋunhi yuṯany borum wiyika' leŋumirr rarryun balany ŋunhi ŋäthiliŋulilnydja bathilil, ŋunhi walal ŋuli mindapum ŋunhiyi bathi beŋur warrakan'kal galŋaŋur. Bili ŋunhi balaŋ ŋayi mirithiny dhaŋaŋdhi ŋunhiyi yuṯany borum wiyika', bala ŋayi balaŋ yan yarrar'maraŋun ŋunhiyi ŋäthiliŋuny bathi gararrkararrnydja bala ŋuli yan yätjin buruŋgulkthin, bala wiyikany' balaŋ ŋunhi yan djalkthunmirra. Yurr ŋunhi limurr djäl ŋurikiyi bathiw ga borumgu wiyikaw', limurrnydja dhu ŋunhi yuṯany borum wiyika rarryun balan yan ŋunhi yuṯalila bathilil.” ");
INSERT INTO djr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ga baḏak yan ŋayi gan ŋunhi Djesuny waŋan, dhäwuny lakaraŋal, bala yan ŋayiny ŋunhi waŋganydja ḏirramu, ŋunhi ŋayi ŋurruḏawalaŋu gapman Djuw-malaw marrtjin nhanukal Djesuwal bala yan bun'kumu-djipthurra gumurrŋura nhanukal. Bala ŋayi ŋunhi waŋanany bitjarra gam', “Ŋunha ŋarraku dhiyaŋ bili wirrkuḻ gäthu'mirriŋu dhiŋgaŋal! Buku-djulŋi marrtji ŋathil balayi ga goŋ-ŋal'yurr nhanukal, märr ŋayi dhu bulu walŋathirr.” ");
INSERT INTO djr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Bala yan ŋayiny Djesuny ga malthunamirrnydja mala nhanŋu rur'yurrnydja, bala malthurra nhanŋu ŋurikiyiny ḏirramuwnydja. ");
INSERT INTO djr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ga waŋgany miyalk gan rerrikthurr 12-nha dhuŋgarra, maŋgu' nhanŋu ŋuli ganha waṉḏinya bitjana bili. Yo! Marrtjinany ŋayi gan ŋunhi miyalktja ŋapa-munguyurra marrtjin bala ŋanyanhan Djesunhan, bala yan ŋayi baḏatjnha ŋayathaŋal nhanŋu girrin' Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bili bitjarra ŋayi marrtjin ŋunhi miyalktja waŋanhaminany gam', “Ŋuli balaŋ ŋarra dhu dhuwal yan ŋayatham nhanŋu girriny', ŋarrany dhu ŋunhi ḏukthunna yan.” ");
INSERT INTO djr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bala yan ŋayiny Djesuny bilyurrnydja dharrnha nhäŋal ŋanyanhan ŋunhiyin miyalknhan. Bala yan ŋayi waŋanany nhanŋu bitjarra gam', “Yaka warwuyurr! Bilin nhe dhuwali ḏukthurra dhipuŋuryiny rerriŋurnydja, bili nhe märr-yuwalkmirriyin.” Ga dhunupan ŋayi ŋunhi miyalktja ḏukthurra ŋuriŋi bili yan waluynydja. ");
INSERT INTO djr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ga ŋunhi ŋayi gan Djesu marrtjinany bala, ŋunhiwiliny wäŋalil ŋunhi wanhami gan ŋunhiyi ŋurruḏawalaŋu gapman Djuw-malaw nhinan. Bala yan ŋayi nhäŋala yolŋunhany walalany walal marrtjin nyä'yunminan ga buŋgulnha dhika djäma, manikaynha. ");
INSERT INTO djr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ga ŋunhi ŋayi Djesuy nhäŋalnydja walalany, bala yan ŋayi bitjarra waŋanany walalaŋ gam', “Way walal, gatjuy gundupuŋun walal dhipuŋurnydja! Yaka ŋayi dhuwali dhiŋganha, yan ŋayi ga dhuwali ŋorra yakurr.” Yurr walalnydja ŋunhi yolŋu'-yulŋuny gitkitthunmin warray nhanŋu Djesuwnydja. ");
INSERT INTO djr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ga bäy walalany ŋayi bukmaknha yan yolŋu'-yulŋuny dhawaṯmaraŋal beŋuryi wäŋaŋur, bala ŋayi Djesuny gärrinan, bala marrtjinan balayin ŋunhi wanhal ŋayi gan ŋunhiyi wirrkuḻ miyalk ŋorran. Bala yan ŋayi ŋanya Djesuynydja dhunupan goŋnha ŋayathaŋal bala yan guŋga'yurra ŋanya rur'maraŋala. ");
INSERT INTO djr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ga dhunupan gan ŋunhi dhäwuny ŋunhiŋuwuyyiny ḻatjuwarr'yurra warrpam'thurra dhika, ŋuliwitjarryiny wäŋakurr malaŋuwurr. ");
INSERT INTO djr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ga ŋunhi ŋayi Djesu marrtjin waṉḏinany bala, bala yan maṉḏany märrmany' ḏirramu maṉḏa, yurr bambay maṉḏa malthurra yan nhanŋu, ga waŋanany maṉḏa marrtjin ŋunhi yatjurrnha bitjarra gam', “Daybitku Gäthu'mirriŋu, wuyurr linyalaŋ!” ");
INSERT INTO djr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ga bäy ŋayi Djesu djuḏupthurr wäŋalil, bala yan maṉḏany ŋunhi bambaynydja ḏirramu maṉḏa bunanan nhanŋu. Bala ŋayiny Djesuny bitjarra maṉḏaŋ waŋan gam', “Märr-yuwalkmirriyirr muka nhuma ga dhuwal yulŋuny, ŋunhi ŋarra dhu ḏukmaramany nhumalany?” “Yo! Garray,” bitjarr maṉḏany waŋan nhanŋu buku-bakmaraŋal. ");
INSERT INTO djr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bala yan ŋayiny Djesuynydja melnha maṉḏany ŋayathaŋal, ga bitjarra ŋayi waŋanany, “Dhiyaŋiyi nhumalaŋgal märr-yuwalkthinyaraynydja, nhumany dhu ḏukthunna yan.” ");
INSERT INTO djr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bala maṉḏany ŋunhi dhunupan bala yan nhäŋala, maŋutjiny maṉḏaŋ ḻapthurra. Yurr ŋayiny Djesuny dhäruk-gurrupanminan maṉḏaŋgal, maṉḏa dhu yakan yan lakaram bawalamirriwalnydja yolŋuwal walalaŋgal ŋunhiŋuwuyyiny. ");
INSERT INTO djr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yurr ŋunhi ŋayi Djesuy, maṉḏany ganarrthaŋalnydja bala yan maṉḏa marrtjin dhäwuny birrŋ'maraŋala bawalamirriwala yolŋuwalnydja walalaŋgal bukmakkurra yan wäŋakurrnydja malaŋuwurr. ");
INSERT INTO djr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ga ŋunhi walal marrtjin Djesu ga malthunamirr mala nhanŋu wäŋgaŋalnydja bala, bala walalnydja ŋunhi wiripuwurruynydja yolŋu'-yulŋuy gäŋal nhanukal Djesuwal ḏirramuny matha-dhumuknhan, bili nhanukal gan ŋunhi wakinŋu birrimbirr gärrin. ");
INSERT INTO djr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ga ŋunhi ŋayi gan Djesuy dhawaṯmaraŋalnydja ŋunhi wakinŋunhany birrimbirrnha nhanukal, bala yan ŋayiny ŋunhi ḏirramuny dhunupan waŋanan marrtjin dhika. Ga walalnydja ŋunhi yolŋu'-yulŋuynydja mirithinan dhika ŋoy-ganyim'thurra ŋurikiny romgu, bala yan walal bitjanminan marrtjin lakaranhaminany gam', “Bäyŋu limurruŋgal gan dhuwal ŋäthilnydja balanya mala rom maḻŋ'thurr, dhiyalnydja wäŋaŋur Yitjuralnydja!” ");
INSERT INTO djr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yurr walalnydja ŋunhi Baratjiny mala yolŋu'-yulŋu, bitjarr warray waŋan walalaŋ gam', “Ŋunha ga ŋanya buŋgaway wakinŋuy birrimbirryu ganydjarr-gurrupan, märr ŋayi dhu ga ŋaŋ'ŋaŋ'thun, ga dhar'-dhar-wurrupan ŋunha wiripuwurruny wakinŋumirriny birrimbirrnha mala.” ");
INSERT INTO djr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yo, ŋayiny gan ŋunhi Djesuny marrtjin ḻiw'maraŋala wäŋakurra malaŋuwurr marŋgikuŋala marrtjin yolŋunhan walalany ŋunhiliyin ŋunhi Djuw malawal buku-ḻuŋ'maranhamirriŋur buṉbuŋur mala, dhäwun gan lakaraŋal manymaknha God-Waŋarrwalaŋuwuynha rombuy. Ga bitjarryi bili ŋayi gan ŋunhi ḏukmaraŋalnydja ga walŋakuŋalnydja yolŋunhany walalany ŋula nhäŋurnydja mala rerriŋur. ");
INSERT INTO djr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ga dharrwan mirithirra yolŋuny walal marrtjin nhanukal ḻuŋ'thurr, bala ŋayi ŋunhi Djesuynydja nhäŋalnydja walalany, ga mirithinan yan ŋayi ŋunhi warwuyurrnydja walalaŋ, bili walalnydja ŋunhi warwumirra mala ga ganydjarrmiriwnha mala, balanyan nhakun ŋunhi warrakan'nha bimbin mala djägamiriwŋurnha ŋuli ga nhina. ");
INSERT INTO djr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yo nhäŋalnydja ŋayi ŋunhi walalany Djesuynydja, bala ŋayi waŋanan nhanukalaŋuwal malthunamirriwalnydja mala bitjarra, “Dharrwan dhuwal mirithirra yolŋuny walal, ŋunhi walal ga djälthirr Godkalaŋawnydja yuwalkkuny romgu, galkunna walal ga God-Waŋarrwun, bitjanna nhakun borum ŋunhi ŋatha dhakal ŋuli ga galkun gulkthunarawnha yanan. Ga yolthun dhu ŋunhi gulkthundja, ḻuŋ'maramany Garraywalnydja? Bili djämamirrnydja mala dhuwal ḻurrkun' yan. ");
INSERT INTO djr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Gatjuy, waŋi ŋäŋ'thurr God-Waŋarrnha Bäpany, märr ŋayi dhu djuy'yundja dharrwanhan djämamirrinhany walalany ḻundukunharawnydja ŋurikiyiny borumguny malaŋuw.” Bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ga dhäŋur beŋuryiny bala ŋayi Djesuynydja ḻuŋ'maraŋala nhanŋuwuy ŋayi ŋunhi 12-nhany malthunamirriny walalany. Bala yan ŋayi gan gurrupara walalaŋ ganydjarrnydja, märr walal dhu ga dhawaṯmaraman ŋunhi yätjkurrunhany birrimbirrnha mala ga ḏukmaraman walal dhu ga bukmak yan nhä malany rerri. ");
INSERT INTO djr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ga ŋurruŋuny Djuy'yunawuy ŋunhi beŋuryi malaŋur 12-ŋur, yäku Djäyman ŋunhi wiripuny ŋayi yäku Beta. Ga wiripuny Djuy'yunawuy nhanŋu wäwa'mirriŋu Betaw yäku Wanduru, ga wiripuny mala dhuwalawurra gam', Djayim ga Djon ŋunhi maṉḏa gäthu'mirriŋu Djibidiw. ");
INSERT INTO djr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ga Bilip, Bäthalamiyaw, Dumatj, Mathuyu ŋunhi ŋayi rrupiya-märranhamirr yolŋu gapmangu, Djayim Yalpayatjku gäthu'mirriŋu, ga Dhadayatj. ");
INSERT INTO djr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ga wiripuny Djäyman ŋunhi ŋayi rom-ḏälmirr ḏirramu, ga Djudatj-Gariyatnha, ŋunhi yalalaŋumirriynydja ŋayi Djesuwnydja ḏiltji-bilyurra. ");
INSERT INTO djr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bala ŋayi Djesuy ḻuŋ'maraŋala nhanŋuwuy ŋayi 12-nhany galkipuynhany malthunamirriny walalany, bala yan djuy'yurra walalany djämawnha, ga bitjarra ŋayi ŋunhi waŋanany walalaŋ gam', “Gatjuy marrtjin walal, yurr yaka walal balany marrtji ŋunhi Djan'tayilwalnydja yolŋuwal walalaŋgal, ga bäyŋu yan gärri ŋurikiwurruŋgalnydja wäŋalil Djamaritinbuywalnydja yolŋuwal walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Balan yan nhuma dhu marrtjiny wäŋa-Yitjuralpuywalnha yolŋu'-yulŋuwalnydja, bili walal ŋunhi balanya nhakun winya'yunawuynha bimbi mala. ");
INSERT INTO djr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ŋunhi nhuma dhu marrtjiny ga bitjanna nhuma dhu marrtji ŋunhi dhäwuny walalaŋ lakaram gam', ‘God-Waŋarrwuny ŋunhi rom galki dhu bunan!’ ");
INSERT INTO djr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ga rerrimirrinhany yolŋuny nhuma dhu yan ḏukmaraman, ga dhiŋganhawuynhany yolŋuny nhuma dhu yan walŋakuman. Ga burrunhdhiya'mirrinhany mala nhuma dhu bitjandhi bili yan ḏukmaram, ga wakinŋunhany birrimbirrnha nhuma dhu ga ŋaŋ'ŋaŋ'thunna dhawaṯmaraman, märr walal dhu ganarrthaman ŋunhi yolŋunhany walalany. Yo, dhuwal nhuma märraŋal ŋarrakuŋ ganydjarr wuŋiḻi'yunamiriw, ga bitjandhi bili yan nhumany dhu gurrupan wiripuwurruŋguny, märr walalnydja muka dhu yakayi yan wuŋiḻi'yun nhumalaŋguŋuny gurrupanawuy. ");
INSERT INTO djr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ga yaka gi gäŋu ŋula mel-wiḏi'mirr bulay ga djilbany mala gutjikaŋ'thuny nhokiyingal nhe. ");
INSERT INTO djr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ga bathiny nhuŋuwuy nhe ganarrthul, yaka galki gäŋu, … märramany nhe dhu ŋunhiyi bili yan girriny' ga ḻukupuynydja ŋunhi nhe ga dhuwali gäma, ga marrtjinyapuynydja dharpa nhuŋuwuy nhe dhu bäyŋuyi yan gäma. Bili ŋayiny dhu ga ŋunhi djämamirriynydja yolŋuy märram yan ŋula nhä malany, yaka ŋayi dhu ga ŋunhi waŋarany yan djäma.” ");
INSERT INTO djr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ŋuli nhe dhu ŋunhi bunany ŋunhili wäŋaŋurnydja malaŋuŋur nyumukuṉiny'ŋur wo yindiŋur, dhunupan bala yan marrtjiny ga ḻarruŋuny ŋurikiyin yolŋuwnydja ŋunhi ŋayi ga gumurr-ŋamathirr, ga gana' ŋayi djägaw nhuŋu, nhini nhanukal gi wäŋaŋurnydja-a-a ga yan bili ga marrtji nhe dhu. ");
INSERT INTO djr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ŋuli nhe dhu ŋunhi gärriny ŋunhiwili wäŋalilnydja ga bitjanna nhe dhu ŋunhi waŋany gam', ‘God-Waŋarrwu mägayany rom nhokalnha.’” ");
INSERT INTO djr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","“Ga ŋuli walal dhu ŋunhi ŋunhili wäŋaŋur nhuŋu gumurr-ŋamathirrnydja nheny yanan gurrupula nhuŋuwuy nhe mägayamirrnydja rom walalaŋ. Yurr ŋunhi walal dhu yakany nhuŋu gumurr-ŋamathirr, nheny dhu yakan walalaŋ gurrupan ŋunhiyi mägayamirrnydja rom ŋayathula gi yan. ");
INSERT INTO djr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ga ŋuli dhu ŋunhi bukmaktja yolŋu walal nhuŋu ŋuyulkthirr wäŋa manapandja, yaka nhakun dhu gumurr-ŋamathirr nhuŋu, ga buthuru-djaw'yunmirrnydja dhu nhokalaŋaw dhäwuwnydja, nheny yanan ganarrthula ŋunhiyiny wäŋa, bala yan ḻukupuynha nhuŋuwuy nhe dhapathuŋ'tja ḏawaṯawayurra ḏuŋgul djalkthurra bala yan marrtjin ganarrthula walalany. ");
INSERT INTO djr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Märr-yuwalk yan dhuwandja ŋarra ga lakaram nhumalaŋ balanyamirriynydja ŋunhi Dhä-dhawar'yunamirriynydja Waluy ŋurikiny dhu wäŋaw malaŋuw ga yolŋu'-yulŋuw ŋunhi walal gan ŋuyulkthin ga buthuru-djaw'yunmin nhumalaŋgalaŋaw dhäwuw, walalaŋguny dhu boŋguŋ ŋunhi mirithirra yätjkurra walu ŋoy-gärrinyamirra, bulun ga djuḻkmaram ŋunhi dhä-gir'yunamirr rom ŋunhi maṉḏa märraŋal ŋäthil ŋuriŋi maṉḏa wäŋay yäkuy Djudumdhu ga Gumuray!” ");
INSERT INTO djr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Yo! Ŋäkuny walal ŋamathaŋ yan. Dhuwal ŋarra ga djuy'yunna nhumalany, ga bitjanna nhuma dhu ga ŋunhi nhinany nhakun bimbi mala malaŋurnydja wärraŋgala mala. Yurr nhumany dhu ga bitjan nhinany nhakun bäpi, ŋunhi ŋayi gaḏaman mirithirr, ga wiripuny nhuma dhu ga bitjan nhina nhakun murruyil ŋunhi ŋayi gurrum'. ");
INSERT INTO djr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ga djäga nhuma dhu ga nhumalaŋguwuy nhuma wiripuwurruŋgalnydja yolŋu'-yulŋuwal, bili walalnydja dhu nhumalany ŋunhi ḏapḏapmaraŋun bala ŋärra'lila gäŋu rom-djägamirriwala malaŋuwal dhä-birrka'yunarawnha, bala walal dhu gi nhumalany bartjunmaraŋun burruṯiŋuynha ŋunhilin ŋunhi Djuw-malawalnha buku-ḻuŋ'maranhamirriŋura buṉbuŋur. ");
INSERT INTO djr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bili nhumany dhuwal ŋarraku warray yolŋu walal, bala walalnydja dhu gi ŋunhi nhumalany yurrnha gäŋu balany ŋunhi nhuma dhu gi dhärrin gumurrŋura walalaŋgal ŋurikiwurruŋgalyin mala ŋunhi walal buŋgawa wäŋaw-ŋayathanharaw ga buŋgawan ŋurruḏawalaŋun mala. Bala nheny dhu gi ŋunhi dhäwun walalaŋ lakaraŋ ŋarrakalaŋawuynha, ga wiripuny nhe dhu gi ŋunhi ŋurikiwurruŋgun lakaraŋ ŋunhi Djan'tayilwun mala yolŋu'-yulŋuw. ");
INSERT INTO djr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ŋunhi nhumalany walal dhu ḏapmaraŋuny, nhumany dhu yakan warwuyurr ŋunhi nhalayak nhuma dhu gi waŋi walalaŋ. Bili balanyamirriynydja waluy ŋayin dhu boŋguŋ ŋunhi Dhuyu-Birrimbirryun gurrupulnydja nhumalaŋ dhäruktja waŋanharawnydja, yakan nhuma dhu gi ŋunhi gänany waŋi. ");
INSERT INTO djr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yuwalktja yakan dhu gi ŋunhi nhumapiny waŋi, ŋany ŋayin dhu gi ŋunhi Dhuyu-Birrimbirrnha God-Waŋarrwuŋun djuy'yunawuy waŋiny lakaraŋuny nhumalaŋ nhalayak nhuma dhu gi ŋunhi waŋi.” ");
INSERT INTO djr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ga balanyamirriyyiny waluy walalnydja dhu gi ŋunhi yapa'manydjiwurrnydja ga wäwa'manydjiwurrnydja mirithin ŋaramurrthinyamirr walalaŋguwuy walal bala walal dhu gi ŋunhi djarrman djäma bunharawnha walalaŋguwuy walal rakunythinyarawnha yan. Ga walalnydja muka dhu biyakiyi bili yan Bäpa'mirriŋuny ga Ŋäṉḏi'mirriŋuny mala ḏiltji-bilyurra walalaŋgalaŋaw djamarrkuḻiwny'tja, ga walal djamarrkuḻiny' dhu biyakiyi bili yan ŋapa-bilyurr Bäpa'mirriŋuwnydja ga Ŋäṉḏi'mirriŋuwnydja mala walalaŋgalaŋaw, bala yan walalany dhu goŋ-gurrupula miriŋuwalnha walalaŋgal bunharawnha yan rakunykunharawnha. ");
INSERT INTO djr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ga bukmaktja dhu gi ŋunhi yolŋu walal ŋaramurryin nhumalaŋguny, bili nhumany dhuwal ŋarrakalaŋumirra mala. Yurr ŋunhi balaŋ nhuma dhu ga dhärra ḏälnydja yan, yän bili ga dhä-dhawar'yunamirriynydja waluy nhumany dhu ŋunhi walŋathin. ");
INSERT INTO djr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ga ŋuli nhumalaŋ walal dhu ŋunhi mariny djäma waŋganyŋurnydja ŋula wäŋaŋur, nhumany dhu ŋunhi bondin yan marrtji wiripuŋulila wäŋalil. Yo! Dhuwandja yuwalk yan ŋarra ga lakaram nhumalaŋ, yurrnha nhuma dhu ŋunhi warrpam'tja wäŋa mala ŋayatham dhiyal wäŋaŋur ŋarakaŋur Yitjuralnydja, bala ŋayiny dhu ŋunhi Yolŋuny Gäthu'mirriŋu bunan.” ");
INSERT INTO djr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Yo! Ŋayiny ŋunhi malthunamirrnydja yolŋu yakan ŋayi garrwar nhanukalnydja ŋunhi marŋgikunhamirriwalnydja yolŋuwal, ga djämamirr dhuwal yolŋu yaka garrwar buŋgawa'mirriŋuwal nhanukalaŋuwal. ");
INSERT INTO djr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yurr gana' warray nhanŋu ŋurikiyi malthunamirriwnydja yolŋuw ŋayi dhu bitjandja ganda' nhakun ŋunhi marŋgikunhamirrnydja nhanŋu, ga balanya bili nhanŋu djämamirriwnydja ŋayi dhu bitjandhi bili yan ganda' ŋupanayŋu yan nhakun ŋunhiyi buŋgawa'mirriŋu nhanŋu. Ga ŋuli dhu ga ŋunhi yolŋuynydja walal lakaram ŋunhi ŋurruḏawalaŋunhany ŋurikiyi gurruṯumirriw walalaŋ bitjandja gam', ‘Ŋayiny ŋunha Beltjibul,’ bitjandja. Ga nhaltjanna walal dhu ga ŋunhi wiripuwurruŋguny ŋuriki yolŋuw walalaŋ gurruṯumirriw waŋa nyamir'yundja manapan.” ");
INSERT INTO djr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ga Bäyŋu yan nhuma dhu ga ŋunhi ŋula wiripuwurruŋguny yolŋu'-yulŋuw bukmakkuny barrarirr! Bili nhä malany ŋunhi bukmak ga dhiyaŋ bala djuḻuḻ'yun ŋorra, ga nhä malany dharrpal, ŋunhiyiny dhu boŋguŋ maḻŋ'thurra warraŋulthin. ");
INSERT INTO djr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ga ŋunhi nhaltjarr ŋarra gan waŋan nhuŋu ŋunhal buku-munha'ŋur yurr nheny dhu ŋunhi bukmakkala yan yolŋuwalnydja walalaŋgal lakaram, yurr walupuynha ḻarr'yunaraynha. Ga ŋunhi ŋarra gan nhä ŋula gayul nhokal waŋan yawyawyurr, yurr nheny dhu ŋunhi mirithin yan yatjurrnha lakaraŋuny djawarrkthurra manapul, beŋurnha ŋunhi garrwarŋura ŋapaŋura buṉbuŋur. ");
INSERT INTO djr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ga yaka walal gi barrariny ŋula yolkuny yolŋuw ŋunhi ŋayi dhu nhunany bumany murrkay'kumany; ŋunhiyiny walal nhunany dhu rumbal yan buwayakkumany waŋgany, ga bilin. Yurr bäyŋun walal dhu ŋunhi mirritjalnydja nhuŋu ŋayatham. Yuwalktja nhuma dhu ga ŋunhi barrarirrnydja nhanŋuwuynha yan God-Waŋarrwun, bili ŋayipin ga waŋganydhun ŋunhi ganydjarrnydja ŋayatham rakunygunharawnydja bala ŋurrkanharawnha balan ŋunhi dhä-gir'yunamirrilila wäŋalilnydja. ");
INSERT INTO djr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nyumukuṉiny'tja ŋunhi warrakan' djikayny'tja yäku märr gaŋga, ga ŋunhi ŋuli yolŋuy bäyim märrma' djikay' nyumukuṉiny'thu rrupiyay, waŋganydhu yan ŋarakaynydja, yurr ŋayiny dhu God-Waŋarryuny yakan ŋula waŋganynhany djikay'nha moma, ŋunhi ŋayi dhu galkirriny bala munatha'lilnydja. ");
INSERT INTO djr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ga balanyayi bili, nhuŋuwuynydja ŋayi ŋunha God-Waŋarr marŋgiyi yan bukmakku, balanya nhakun ŋayi marŋgi nhokalaŋaw marwatku, nhämunha' nhuŋu marwat ga gorrum ḻiyaŋur. ");
INSERT INTO djr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Yaka nheny barrari. Dhuwal nhumany yolŋuny walal goŋmirr warray God-Waŋarrwal yan goŋŋur, bulu warray ga djuḻkmaram ŋunha djikay'nhany mala.” ");
INSERT INTO djr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ga ŋuli nhe dhu ga ŋunhi wiripuwurruŋgalnydja yolŋuwal walalaŋ lakaranhamirr ŋunhi nheny dhuwal ŋarraku warray yolŋu. Bala ŋarrany nhuna dhu ŋunhi bitjandhi bili yan lakaramdhi ŋarrakalaŋuwalnydja Bäpa'mirriŋuwal ŋunhi ŋayi ga nhina ŋunha Djiwarr'ŋur, ŋunhi nheny dhuwal ŋarraku warray malthunamirr. ");
INSERT INTO djr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yurr ŋuli nhe dhu ga ŋunhi ŋarrany bukuy-ŋurrkamany, ŋarrany dhu biyakiyi bili lakaraŋ yan nhuna ŋarrakalaŋuwalnydja Bäpa'mirriŋuwal ŋunhi ŋayi ga nhina ŋunha Djiwarr'ŋur, ŋunhi nheny dhuwal yaka warray ŋarrakalaŋumirr.” ");
INSERT INTO djr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yaka nhuma dhu bitjandja guyaŋa yanbi ŋarra dhuwal mägayany yan rom nhumalaŋ gäŋal dhipalnydja munatha'lilnydja! Marrtjinany ŋarra dhuwal gäŋalnydja nhumalaŋ mari yaka burrmiḏiny rom. ");
INSERT INTO djr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ŋarrany dhuwal marrtjin märr dhu ŋayiny gäthu'mirriŋuny mala ŋapa-bilyuna bäpa'mirriŋuwnydja mala, ga walalnydja dhu waku'mirriŋuny mala bitjandhi bili ŋapa-bilyun ŋäṉḏi'mirriŋuwnydja mala, ga ŋayiny dhu ga mukul'mirriŋuny morrumurrun nhanukalaŋaw miyalkkuny gäthu'mirriŋuw ga barrkuwatjnha maṉḏa dhu ga ŋunhi nhinany. ");
INSERT INTO djr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mirithiny dhu gi ŋunhi nhuŋu miriŋuyi, ŋunhin bili yan ŋunhi galkipuynha nhuŋu gurruṯumirr mala.” ");
INSERT INTO djr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ŋuli nhe dhu ga ŋunhi mirithirrnydja märr-ŋamathirr nhokalaŋaw bäpa'mirriŋuwnydja ga ŋäṉḏi'mirriŋuwnydja ga ŋunha waku'mirriŋuwnydja ga gäthu'mirriŋuwnydja, ga ŋarrakuny nhe dhu ga gaŋgan märr-ŋamathirr, ŋunhiyiny nhe yakan gana' malthunaraw ŋarrakuny. ");
INSERT INTO djr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ga ŋuli nhe dhu ḻaw'maram nhuŋuwuy nhe dharpa mälakmaranhawuy bala malthunna ŋarrakun, ŋunhiyin nhe yuwalktja ŋarrakuny malthunamirr. ");
INSERT INTO djr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ga ŋuli nhe dhu ga gänany nhakun birrka'yun walŋaw nhuŋuwuy nhe nhinanharaw, nheny dhu ŋunhi moman yan nhuŋuwuy nhe walŋany gupaḏalnha yan. Yurr ŋuli nhe dhu ŋunhi walŋa gurrupanmirr ŋarrakuny yäkuw, nheny dhu ŋunhi maḻŋ'maraman walŋathinyamirrnydja rom.” ");
INSERT INTO djr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ga ŋuli dhu ŋunhi ŋula yol yolŋu nhuŋu gumurr-ŋamathirr, ŋunhiny ŋayi dhu nhakun ŋarrakun gumurr-ŋamathirr. Ga balanyayi bili ŋuli dhu ŋunhi ŋula yol ŋarrakuny gumurr-ŋamathirr, ŋunhiyiny balanyan nhakun ŋayi dhu ŋunhi Djiwarr'puywun ŋarrakalaŋaw Bäpa'mirriŋuw gumurr-ŋamathirr. ");
INSERT INTO djr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ga ŋuli dhu ŋula bawalamirr yolŋu gumurr-ŋamathirr ŋurikiny ŋunhi ŋayi djawarrkmirriwnydja yolŋuw, ŋayiny dhu ŋunhi gumurr-ŋamathinyamirriynydja yolŋuy balanya bili mundhurr märram nhakun ŋuriŋiyi djawarrkmirriy yolŋuy. Ga balanya bili ŋuli dhu ŋunhi ŋula yol manymakkuny yolŋuw gumurr-ŋamathirr, bili ŋayi ŋunhi manymak mirithirr yolŋu, ga ŋayiny dhu ŋunhi manymakthi bili yan mundhurr märram ŋuriŋiyiny ŋunhi gumurr-ŋamathinyamirriynydja yolŋuy. ");
INSERT INTO djr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Märr-yuwalk ŋarra ga dhuwal nhumalaŋ lakaramany, ŋuli dhu ŋayi ŋula yolthu yolŋuy ŋula yan ḻurrkun' gapu gurrupan nhuna ḻukanharaw, bili nheny ŋunhi ŋarraku warray malthunamirr, bäydhi ŋunhi nhe ŋarraku ŋurruwuyuktja balanya malthunamirr, ŋayiny dhu God-Waŋarryuny nhanŋuny ŋurikiny yolŋuw buku-roŋanmaram bulun dhika. ");
INSERT INTO djr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ga ŋunhi ŋayi Djesu dhawar'yurrnydja waŋanhaŋurnydja malthunamirriwalnydja mala nhanukalaŋuwal, bala ŋayi yan dhunupan marrtjinan, bala ŋurruyirr'yurra marrtjin dhäwun lakaraŋal marŋgikuŋala walalany wäŋakurra malaŋuwurr. ");
INSERT INTO djr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ga ŋayiny Djondja balanyamirriyyiny ŋunhala gan dharruŋguŋura djinawan' nhinan, ga beŋuryin ŋayi gan ŋunhi dhäwuny ŋäkul nhanukalaŋuwuynydja Djesuwalaŋuwuynydja ŋunhi nhä ŋayi gan djäma. Bala ŋayi Djondhuny djuy'yurra nhanŋuwuynydja ŋayi malthunamirriny walalany, ");
INSERT INTO djr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","märr walal dhu ŋanya ŋäŋ'thun Djesuny bitjan, “Muka nhe dhuwal ŋunhiyiny yolŋu ŋunhi ŋanapurr ŋuli ga dhukarr-nhämany, … nhuŋun? Wo baḏak yan ŋanapurr dhu ga galkun wiripuŋuw yolŋuw?” ");
INSERT INTO djr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bala ŋayi Djesuny waŋanan bitjarra, “Gatjuy marrtjin ga lakaraŋun nhanukal Djongalnydja ŋunhi nhä nhuma ŋäkul ga nhäŋal. ");
INSERT INTO djr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bilin ga dhuwal bambayyuny nhäman, ga gaṉuŋdja ga marrtjin. Burrunhdhiya'mirrnydja yolŋu walal dhuwal bilin ḏukthunawuynha, ga buthuru-dhumukthuny ga ŋäman. Dhiŋganhawuynydja ga yolŋu walŋathirra, ga ŋurruwuykthuny ga ŋäman dhäwu manymaktja. ");
INSERT INTO djr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","God-Waŋarryuny dhu ŋunhi dhaŋaŋguman nhanukiyingala ŋayi manymakthuny ŋunhiwurrunhany yolŋuny walalany ŋunhi walal ŋuli gi yaka ŋapiri-ŋurrkuŋ ŋarrany, dhuwalaŋuwuy ŋunhi nhä ŋarra ga djäma.” ");
INSERT INTO djr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ga ŋunhi walal Djongu ḻundu'mirriŋuny mala marrtjinany, bala ŋayiny Djesuny waŋanan yolŋuwalnydja walalaŋ dhäwun lakaraŋal Djongalaŋuwuynha, “Nhäthinya ŋayi ŋunhiyiny yolŋu, ŋunhi nhuma nhäŋal ŋanya ŋunhalnydja gapu-ranhdhakŋurnydja wäŋaŋur? Nhäthinya ŋayi ŋunhi balanya nhakun djaka'-wiyin mulmu ŋunhi ŋanya gan watay boy'yurr bala-räli'? ");
INSERT INTO djr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nhäthinya ŋayi ŋunhiyiny yolŋuny nhuma nhäma? Ŋula nhuma nhäŋalnydja ŋanya manymaklil girri'lilnydja? Bitjandhiyiny ŋuli ga ŋunhi yolŋu walal dhaṯthunmirr manymakthuny girriy' ŋunhaŋuwuynha manymakpuynha yan wäŋapuy. ");
INSERT INTO djr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nhaku nhuma ŋunhi yuwalktja marrtjin balayiny nhänharaw? Nhä ŋayi ŋunhi yolŋuny djawarrkmirr muka? Yo, yuwalk muka. Ŋarra nhumalaŋ lakaraman. Ŋunhiyiny yolŋu bulun ŋayi ga djuḻlkmaram djawarrkmirrinhany yolŋuny. ");
INSERT INTO djr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ŋunhany ŋunhi djorra'ŋurnydja God-Waŋarryuny ga lakaram ŋanya bitjanna, ‘Ŋarrany ga dhuwal ŋurruŋuny djuy'yun dhäwumirriny, märr ŋayi dhu ŋäthilmirriyaman dhukarrnha-yäkthun nhuŋun.’” ");
INSERT INTO djr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Dhuwandja ŋarra nhumalaŋ dhu lakaram yuwalknha yan: Djondhuny ga dhuwal djuḻkmaram bukmaknha nhämunharany yolŋuny ŋunhi ga nhina dhiyal wäŋaŋur munatha'ŋur. Yurr ŋunhiwurrnydja yolŋu walal ŋunhi walal dhu ga ŋämany ŋarrany dhäruktja, ga nhinany ŋayi dhu ga ŋunhiyiny yolŋu God-Waŋarrwala yan romŋurnydja, ŋuriŋiyin ga ŋunhi yolŋuy buluny djuḻkmaram ŋanyanhany Djonnhany, bäydhi ŋayi ŋunhi ŋunhiyiny yolŋu ŋula gali'puynydja, wakinŋuny balanyany.” ");
INSERT INTO djr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Balanyamirriy waluy ŋunhi Djon Ḻiya-ḻupmaranhmirr gan nhinan, ga yan bili-i-i ga dhiyaŋun bala waluy dhuwanna, mari-ḏilkurrnydja gan yolŋu walal mirithinan yan djälthin walal dhu ga rom djuḻkthunna ŋunhi God-Waŋarrwalaŋuwnydja Romgu dhar'thar-gurrupanaraynha. ");
INSERT INTO djr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bukmakthu gan djorray' mala lakaraŋal, ŋunhi djawarrkmirriy mala gan wukirri, ga Mawtjitjkal Romdhu gan lakaraŋalyi ŋunhiyi, ŋunhi nhaltjan dhu ga rom mala maḻŋ'thun, ga yan bili-i-i-i ga ŋayin ŋunhiyin yolŋu Djonnha bunan. ");
INSERT INTO djr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ga ŋuli nhuma ga nhakun märr-yuwalkthirra ŋunhi ŋayiny Djondja ŋunhiyin yolŋu yäku Yilaydjan, ŋunhiyin djawarrkmirr ŋunhi nhuma ga galkunna nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ga ŋuli nhuma buthurumirrnydja walal gatjuy ŋäkuny walal manymakkuŋun.” ");
INSERT INTO djr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nhumany dhuwal dhuwalawurrnydja balanya nhakun djamarrkuḻi', ŋunhi walal ŋuli marrtji nhina dhukarr-djaw'yun, ");
INSERT INTO djr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","wäthunmirr ŋuli marrtji wakallil. ‘Napurrnydja gan buḻ'yurr yiḏakiy galŋa-djulŋithinyamaraŋal nhumalany, yurr nhumany yaka ŋula rur'yuna ga giritjinya. Ga wiripuny napurr gan ḏar'ṯaryurr manikay mala mokuylil bäpurrulil, ŋäthin manapar, ga nhumany bäyŋu warray mala-manapar ŋanapurruŋgal ga ŋäthinyamin.’” ");
INSERT INTO djr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Ga ŋunhi ŋayiny gan Djondja marrtjin dhuwalatjarr, ga bäyŋu warray ŋayiny marrtjinya ŋula nhä ḻukanha ŋatha wo ŋänitji, ga nhumany nhanŋu bitjarr warray waŋan, ‘Dhuwandja ḏirramu yätjkurrwalaŋumirr birrimbirrmirr.’ ");
INSERT INTO djr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yurr ŋayiny ga ŋunha Yolŋuny Gäthu'mirriŋu marrtji ga ḻuka ŋayi marrtji ŋatha ga gapu, ga bitjanna nhuma ga nhanŋuny waŋa gam', ‘Dhiyaŋuny ga yolŋuy mirithirra ḻuka. Ga wiripuny ŋayi dhuwal ḻundu'mirriŋu ŋurukurruŋgun ŋunhi rrupiya-märranhamirriwnha mala, ga dhuwurr-yätjmirriwnha.’ Yurr God-Waŋarrwuŋuny ŋunhi djambatj guyaŋanhawuy bulu warray dhika barrkun mirithirra.” ");
INSERT INTO djr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ga ŋunhiliyiny wäŋaŋur mala ŋunhi ŋayi gan Djesuy dharrwany nhakun djäma yindiny malany rom ŋayaŋu-ganyim'thunamirrnydja, ga yolŋuny mala ŋunhi wäŋa ŋunhiŋuwuyyiny mala bäyŋun ga djälthin bilyunaraw God-Waŋarrwalnydja. Bala ŋayiny Djesuny walalaŋ ŋunhi maḏakarritjthinan, ga bitjarra ŋayi walalaŋ waŋanany, ");
INSERT INTO djr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Nhumany dhuwalawurrnydja yolŋu walal Guritjinbuynydja ga Bithdjaydawuynydja wäŋapuy mariŋura. Ga ŋuli balaŋ ŋayi ganha dhuwaliyi rom mala ŋunhi ŋayaŋu-ganyim'thunamirr mala maḻŋ'thuna ŋunhalnydja wäŋaŋur Däyany ga Djaydandja, ga walalnydja balaŋ ganha ŋunhi yolŋuny walal bilyunan God-Waŋarrwalnydja ŋäthil muka yan. Ga nhirrpanany walal balaŋ ŋunhi ŋäthiliŋun girriny' mala barrŋbarrŋnha, ga ḻiyany walal balaŋ ŋunhi dholkunhaminya ganuy'nha. ");
INSERT INTO djr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ga yalalaŋumirriynydja ŋunhi mala-djarr'yunamirriynydja waluy, walalnydja dhu ŋunhi Däyapuyŋuynydja ga Djaydanbuyŋuynydja yolŋu'-yulŋuy dhä-gir'yunawuynydja märraŋ nyumukuṉiny'nha yan. ");
INSERT INTO djr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ga nhuma ŋunhi yolŋu walal Gapuniyambuy mala, nhumany ga guyaŋa yanbi nhumalaŋguny walal dhu gi ŋunhalnydja djiwarr'ŋurnydja wokthurra? Dhuwal nhumany dhu boŋguŋ marrtji balan biyakun burralkulila. Ga ŋuli balaŋ ŋunhi ŋayaŋu-ganyim'thunamirr rom maḻŋ'thuna ŋunhalnydja Djudumdja, ŋayiny balaŋ ganha ŋunhi ŋunhiyiny wäŋa balanyaraynydja baḏak yan dhärranha. ");
INSERT INTO djr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ŋarra nhumalaŋ lakaraman. Balanyamirriynydja ŋunhi dhä-gir'yunamirriynydja waluy, walalnydja dhu ŋunhi wäŋa Djudumbuyyuny yolŋuy walal dhä-gir'yunawuynydja märraŋ nyumukuṉiny'nha yan.” ");
INSERT INTO djr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ga balanyamirriyyiny ŋayi Djesu waŋan bitjarra, “Bäpa ŋarraku, ŋunhi nhe Garray djiwarr'wu wäŋaw ga dhiyak munathaw', ŋarrany dhuwal nhuna buku-gurrpara ŋunhi nhe gan dhuwaliyi rom mala djuḻuḻ'maraŋal gaḏamangalnydja yolŋuwal ga djambatjkalnydja, ga milkuŋalnydja nhe gan ŋunhi dhuŋamirriwala. ");
INSERT INTO djr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yo Bäpa, dhiyaŋiyin ŋunhi nhunanhany märr-ŋamathaŋal.” ");
INSERT INTO djr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ŋarrakalnydja dhuwal Bäpay gurrupar nhä mala warrpam' yan ŋarrakal, ga ŋayipin ŋunhi waŋganynha yan marŋginy ŋurikiyiny ŋunhi Gäthu'mirriŋuwnydja. Yurr ŋayiny ga ŋunha Gäthu'mirriŋuny djälthirr ŋayi dhu milkuman warraŋulkuman Bäpa'mirriŋuwalaŋuwuynydja, märr walal dhu nhanŋuny marŋgithirryi.” ");
INSERT INTO djr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ga ŋuli nhe ga ŋula yolŋu djawaryundja ŋonuŋdhuny gänharay, rälin walal marrtji go ŋarrakala, ga ŋarrany dhu nhumalany buŋgaṯmaraman. ");
INSERT INTO djr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Märraŋun marrtji ŋarrakuŋuny djämapuy bala yan marŋgithin. Bili ŋarrany dhuwal mel-wuyunamirr warray ga ŋayaŋu-gurrum', ga maḻŋ'maramany nhe dhu ŋunhi yal'yunan ŋayaŋuwnydja nhokiyingalaŋaw nhe. ");
INSERT INTO djr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ŋarrakuŋuny dhuwal djäma gurrupanawuy gumurr-yalŋgi, ga rom ŋunhi ŋarrakuŋuny yaka warray galŋa djawaryunamirr.” ");
INSERT INTO djr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Waŋganymirrnydja ŋuriŋiyi waluy Nhinanhamirriy, walalnydja ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu marrtjin wäŋgaŋala ŋuliwitjarryin ŋunhi birralimirriwurra wäŋakurr. Bala nhanŋu ŋunhi malthunamirrnydja mala djaṉŋarrthinan, bala walal marrtjin wapmaraŋala, bala ḻukanan birralin dhakalnha. ");
INSERT INTO djr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ga walalnydja ŋunhi Baratjiny mala waŋan nhanukal Djesuwal bitjarra, “Nhaku walal marrtji dhuwal malthunamirriynydja mala nhokal ŋathany dhakalnydja wapmaram birraliny dhiyaŋuny ŋunhi waluy Nhinanhamirriynydja? Yaka yanbi walal ganha bitjana, yakan ŋunhiyiny dhunupa balanyarawyiny djämaw!” ");
INSERT INTO djr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Bala ŋayiny Djesuny buku-bakmaraŋal bitjarra, “Bili mak nhuma ŋuli ga ŋunhi dhäwuny ŋäma Daybitkalaŋuwuynydja, ŋunhi ŋayi ga ḻundu'mirriŋu mala nhanŋu bitjandhiyi marrya'yirr. ");
INSERT INTO djr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ŋayiny ŋunhi Daybittja gulŋiyin balan ŋunhi God-Waŋarrwala buṉbulil, bala walal yan ḻukan ŋunhi dhuyuny ŋatha, ŋunhi walalawuynha ŋuli ga djirrikaymirriynha yan mala ḻuka, ga yakan walalaŋ ŋunhi dhunupany nhakun. ");
INSERT INTO djr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Muka bäyŋu nhuma ŋuli gi ŋunhiny dhäwu maŋutji-ḻaw'maraŋ, ŋunhi ŋayi ga lakaram ŋunhiliyi djorra'ŋur ŋunhi Mawtjitjkuŋ rom mala wukirriwuy, ŋunhi dhuwal djirrikaymirriynha mala dhu ga djämany ŋunhalnydja ŋunhi buku-ŋal'yunamirriŋura buṉbuŋur balanyarayyiny waluy ŋunhi Nhinanhamirriynydja?” Yurr bäyŋun ŋuli gi ŋunhi nhumany walalanhany biyakiyi rom-nyamir'yurr, ga rom-bakmaranhamirr lakaraŋ walalanhany. ");
INSERT INTO djr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Märr-yuwalk ŋarra ga nhumalaŋ dhuwal lakaram. Waŋgany yan dhikayi ŋunhi ŋayi ga bulun djuḻkmaram dhuwandja ŋunhi buku-ŋal'yunamirrinhany buṉbuny. ");
INSERT INTO djr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Muka yaka yan nhuma dhuwal marŋginy ŋunhi nhaltjan ŋayi ga ŋunha djorra'ŋur waŋa, ŋunhi ŋayi ga waŋa bitjan gam', “Bänŋayin, Yakan nhuma dhu ga mundhurrnydja ŋarrany gurrupan, ŋany djälnydja ŋarra dhuwal nhuma dhu ga mel-wuyunna ŋunha wiripuwurruŋgun yolŋuw walalaŋ.” Ga ŋuli balaŋ nhuma dhiyakiyi romgu marŋginy, nhumany balaŋ ŋunhi yakan rom-nyamir'yuna dhuwalawurrunhany ŋunhi ḻundu'mirriŋunhany mala ŋarraku. ");
INSERT INTO djr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bili Yolŋun dhuwal Gäthu'mirriŋu buŋgawany dhiyakiyiny ŋunhi Nhinanhamirriwnydja waluw. ");
INSERT INTO djr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Bala ŋayi Djesuny marrtjinan, ga gulŋiyin ŋayi Djuw malawal buku-ḻuŋ'maranhamirrilil buṉbulil, ");
INSERT INTO djr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ga ŋunhiliyiny gan ḏirramu nhinan yurr goŋ-dhoṯ. Ga walalnydja gan ŋunhi Baratjiny mala rukitjthin warray nhanŋu, märr walal dhu rom-nyamir'yun ŋanya. Ga bitjarra walal ŋunhi waŋanany dhä-birrka'yurrnydja ŋanya gam', “Nhä ŋunhi dhunupa ŋayi dhu yolŋuy ḏukmaram dhiyaŋuny ŋunhi Nhinanhamirriynydja Waluy?” ");
INSERT INTO djr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ga ŋayiny Djesuny walalaŋ buku-bakmaraŋal bitjarr, “Ŋuli balaŋ nhuŋu waŋgany bimbi gulŋiyi ŋarŋgalil balanyaray ŋunhi Nhinanhamirriynydja Waluy, yakan balaŋ nhe ŋanya ŋunhi dhawaṯmaraŋuny? ");
INSERT INTO djr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yolŋuynydja ga dhuwal bulu djuḻkmaram bimbinhany mala, ga manymak ŋunhi, ŋunhi ŋayi dhu yolŋuy djäma bitjandhiyi manymak rom balanyaraynydja ŋunhi Nhinanhamirriynydja Waluy.” ");
INSERT INTO djr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Bala ŋayi Djesuny waŋanan ŋurikiyiny ḏirramuwnydja bitjarra, “Go goŋ djarryurra.” Bala ŋunhi ḏirramuny yan goŋ-djarryurra, bala dhunupan ŋayi goŋdja manymakthinan ḏukthurra. ");
INSERT INTO djr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bala walalnydja ŋunhi Baratjiynydja mala marrtjinan ganarrthaŋala ŋunhiyiny wäŋa, bala walal gan dhukarrnha maḻŋ'maraŋal waŋanhaminan Djesuwnha bunharaw. ");
INSERT INTO djr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ga ŋunhi ŋayi Djesu marŋgithinany ŋunhi walal gan ŋayan'tharranany nhanŋu, bala yan ŋayi marrtjinan, ga dharrwan ŋunhi mirithirra yolŋuny mala nhanŋu malthurrnydja. Ga dharrwanhan ŋayi gan ŋunhi rerriŋurnydja ḏukmaraŋal, ");
INSERT INTO djr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yurr ŋayi walalany gan dhurrwara-mukmaraŋala lakaranhaŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bala ŋunhi God-Waŋarrwu dhawuny' yuwalkthinan yan maḻŋ'thurrnydja, ŋunhi ŋayi gan djawarrkmirriy ḏirramuy yäku Yitjayay ŋäthil lakaraŋal bitjarr gam', ");
INSERT INTO djr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Dhuwaliyin ŋarraku ŋunhi djarr'yunawuynydja djämamirr! Ga märr-ŋamathirra ŋarra nhanŋu ga dhuwal yulŋuny, ŋayiny ŋarrany ŋuli ga ŋunhi ŋayaŋu-ŋamatham. Ŋarrany dhu dhuwal gurrupanna ŋarrakuwuynydja ŋarra walŋa nhanukala, ga ŋayin dhu ŋunhi ŋarranhany lakaram Djan'tayilwalnydja yolŋuwal walalaŋgal, ŋunhi ŋarran dhu mala-djarr'yurr bukmaknhany yolŋuny walalany ŋuriŋin ŋunhi romdhu-dhunupaynha. ");
INSERT INTO djr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ga bäyŋun yan ŋayi dhu gi marrtji dhukarr-ŋupulnydja, waŋiny dhu marrtji djawarrkthurrnydja ŋarrtjurrnydja yolŋunhany walalany, bäyŋun yan. ");
INSERT INTO djr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ga yakan ŋayi dhu marrtji ŋunhi dhurrpa'-dhurrparaŋuny ŋunhi bakthunawuynhany bewiyany, ga yakayi yan ŋayi dhu ŋunhi bulŋuyukuŋuny rirriwulnhany gurthany, ga bäy ŋayi dhu boŋguŋ rom-dhunupa yan djuḻkthurr. ");
INSERT INTO djr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ga bukmaktja dhu ga ŋunhi Djan'tayilnydja mala ŋayaŋu-gorrumany nhanukiyingala yan.” ");
INSERT INTO djr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Manymak, yolŋuy mala gäŋal Djesuwal waŋganynha ḏirramuny yurr bambaynha ga dhärukmiriwnha, bili nhanukal gan wakinŋu birrimbirr gulŋiyin. Ga ŋayiny Djesuynydja ḏukmaraŋal yan ŋanya ŋunhiyiny ḏirramuny, ga dhunupan bala ŋayi ŋunhi nhäŋala ga waŋanan. ");
INSERT INTO djr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ga walalnydja gan ŋunhi yolŋuynydja mala nhäŋalnydja ŋayaŋu-ganyim'thurra manapar, bala walal gan dhä-birrka'yunminan bitjanminan, “Muka Djesuny dhuwal Daybitku gäthu'mirriŋu?” ");
INSERT INTO djr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ga walalnydja gan ŋunhi Baratjiynydja mala ŋäkul walalany bala walal bitjarra waŋan, “Dhuwaliyiny ŋayi ŋuli ga wakinŋunhany mala birrimbirrnha dhawaṯmaram ganydjarryu Beltjibulwal, ŋunhi ŋayi buŋgawa ŋurikiyi birrimbirrwu malaŋuw!” ");
INSERT INTO djr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ga ŋayiny ŋunhi Djesuny dhunupa yan marŋgithinan ŋunhi nhaltjarr walal gan guyaŋan, bala yan ŋayi waŋanan bitjarra walalaŋ, “Ŋuli dhu ga ŋunhi yolŋu walal bunhamirr bala-räli'yunmirr ŋunhiŋuwuyyi waŋganybuy wäŋapuy, walalnydja dhu ŋunhi malany dhawar'yunna. Ga ŋuli dhu ga ŋunhi gurruṯumirr mala bitjandhi bunhamirr walalawuynha walal, bala dhu ŋunhiyiny bäpurru dhawar'yunna yan.” ");
INSERT INTO djr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","“Ga ŋuli dhu ga ŋunhi Djaytindhu buma djaytinnhany mala, walalnydja dhu ŋunhi malany dhawar'yunna yan. ");
INSERT INTO djr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ga ŋuli nhakun ga ŋarrany dhuwal ganydjarr bäki nhanŋuny Beltjibulwuny, dhawaṯmaranharaw ŋurukuny wakinŋumirriwnydja birrimbirrwu malaŋuw, ga yolkal ganydjarryu ŋunhi nhumalaŋgalnydja malthunamirriy mala ŋuli ga ŋunhiyiny birrimbirrnha malany dhawaṯmaram? Yo, nhumalaŋgiyingal yan malthunamirriy mala nhumalanhany dhu yätjkurr-lakaram. ");
INSERT INTO djr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ga ŋuli dhu ŋunhi ŋarrany nhakun wakinŋunhany birrimbirrnha dhawaṯmaram nhanukalnydja ganydjarryu God-Waŋarrwalnydja Birrimbirryu, ŋuriŋiyiny ga ŋunhi maŋutji lakaram ŋunhi God-Waŋarrwuny Rom bilin maḻŋ'thurra dhuwaliyin nhumalaŋgala. ");
INSERT INTO djr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nhalayakkun balaŋ dhuwal ŋula yol yolŋu gärri ḏälwalnydja ḏirramuwal buṉbulil, ŋula nhakuny girriwny'tja manaŋinyaraw. Ŋurruŋuny balaŋ ŋayi ŋanya ŋunhiyiny ḏälnhany ḏirramuny ga garrwi'-garrwiyurr ŋathil rakiy', ga yorrnha ŋayi balaŋ manaŋinyarawnydja gulŋiyi.” ");
INSERT INTO djr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ŋuli nhe yolŋu yakany ŋarrakal gali'ŋur ŋunhiny nhe ŋarraku miriŋun. Ga ŋuli nhe gi yakany djäma waŋganyŋurnydja ŋaliny, ḻuŋ'maraŋuny marrtji, ŋunhiny nhe yolŋu balanyayiny barrkuwatjkunhamirra, ḻatjuwarr'maraman nhe ga yan yolŋunhan.” ");
INSERT INTO djr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","“Dhuwal ŋarra nhumalaŋ dhu lakaraman. Ŋuli dhu ga ŋunhi ŋula yolthu yolŋuy djäma yätjkurr ga waŋa ŋayi dhu yätjkurr matha, God-Waŋarryuny nhanŋu dhu bäy-lakaram. Wiripuny mak ŋayi dhu ŋunhi dhä-wiripuŋuyirr waŋa nhanŋu Yolŋuw Gäthu'mirriŋuw, ga ŋayiny dhu ŋunhi bäy-lakaram nhanŋu ŋunhiŋuwuyyi. Yurr ŋuli ŋayi dhu ŋula yol yolŋu waŋa dhä-wiripuŋiyirr Dhuyu-Birrimbirrwuny, ŋayiny dhu God-Waŋarryuny bäyŋun nhanŋu bäy-lakaram, ga ŋorran nhanukal dhu ga ŋunhi wiyinŋumirra yakaŋuwnha yan bäy-lakaranharaw, dhiyaŋ bala walŋay ga bulu ŋuruk bala walŋaw ŋunhi yalalaŋumirriw.” ");
INSERT INTO djr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Manymakŋurnydja dharpaŋur ŋuli ga dhuwal borum mala ŋuthan manymaknha yan, ga nhäŋiniŋ'ŋurnydja dharpaŋur ŋuli ŋuthan nhäŋiniŋ'nha borum mala. Nhäma nhuma dhu ga dharpa mala borummirrnydja dharaŋan, ŋuruŋ dhu ga borumdhu mala maŋutji-lakaram.” ");
INSERT INTO djr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Ga nhumany dhuwalawurrnydja dhuwurr-yätjmirr yolŋu walal nhakun bäpin. Ga nhakun nhuma ŋuli ga ŋunhi waŋa manymakkumany? ");
INSERT INTO djr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Manymakthuny ŋuli ga yolŋuy ruwamŋuyam manymaknhan yan nhä malany nhanukiyingalnydja ŋayi ŋayaŋulil, bala ŋuli ga dhäruktja dhawaṯthun nhanukal manymaknha yan. Ga yätjkurrnydja ŋuli ga dhäruk dhawaṯthun yätjkurruwalnha yan yolŋuwal.” ");
INSERT INTO djr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ga dhuwal ŋarra nhumalaŋ dhu lakaraman, “Bukmaknhany dhu ŋunhi yolŋuny mala-djarr'yurra, nhäŋun dhu boŋguŋ marrtji nhämunha'mirr ŋayi yolŋu waŋan yätjkurruyaŋal. ");
INSERT INTO djr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ga ŋuli gan yolŋu waŋan manymakkuŋal dhärukthu nhanukiyingal ŋayi, ŋunhiyiny ŋayi dhu God-Waŋarryu yolŋuny manymak-lakaraŋun, ga ŋunhi ŋayi gan yolŋu waŋan yätjkurruyaŋalnydja yan, ŋanyanhany dhu God-Waŋarryu yätjkurr-lakaraŋun balanyamirriynydja ŋunhi dhä-dhawar'yunamirriynydja waluy.” ");
INSERT INTO djr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ga ŋaḻapaḻmirr yolŋu mala Rom-marŋgikunhamirr walal ga Baratji mala marrtjin Djesuwal, ga waŋan walal bitjarr, “Go mak milkuŋ ŋanapurruŋgal nhuŋuwuy nhe djiwarr'wuynydja ganydjarr.” ");
INSERT INTO djr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarr, “Nhumany ga dhuwal djälthirr nhuma dhu nhäma yindi mala rom, bala nhuma dhu ga märr-yuwalkmirriyirra, bili nhuma dhuwal dhuwurr-yätjmirr ga märr-yuwalkthinyamiriw mala. Ŋarrany dhu dhuwal milkuman nhumalaŋgal waŋganynhan yan djawarrkmirriny yäkuny Djawunanhan.” ");
INSERT INTO djr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Ŋayiny gan ŋunhi yindiwalnydja ŋarirriwal guḻunŋur gulŋiyin ḻurrkun' walu ga ḻurrkun' munha, ga bitjandhin dhu ŋunhi Yolŋuny Gäthu'mirriŋu ŋorra moluŋurnydja ḻurrkun' walu ga ḻurrkun' munha.” ");
INSERT INTO djr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ga yalalany ŋunhi Dhä-dhawar'yunamirriynydja, walalnydja dhu boŋguŋ ŋunhi wäŋa Ninipawuynydja yolŋu walal dhärriny gumurrŋura nhanukal God-Waŋarrwalnydja bala walal dhu gi yätjkurr-lakaraŋun nhumalanhany. Bili walalnydja bilyurr warray ganarrthaŋal walalaŋguwuynydja yätjkurr malany rom, ŋunhi ŋayi gan Djawunaynydja dhäwu walalaŋ lakaraŋal. Ga dhuwandja nhumany ga märr-yuḻkthun ŋunhiyinhan ŋunhi ŋayi ga djuḻkmaraman ŋanyanhany Djawunanhany. ");
INSERT INTO djr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ga buŋgawa miyalk wäŋa Djepawuy marrtjin ŋayi gan barrkuŋur wäŋaŋur, ŋänharaw ŋurikiyi ḻiya-djambatjku yolŋuw yäkuw Djalamangu, bili ŋayi gan ŋunhi mirithin yan djälthin marŋgithinyaraw. Ga yalalaŋumirriynydja ŋayi dhu boŋguŋ ŋunhiyiny miyalk dhärriny, bala ŋayi dhu waŋin yätjkurr-lakaraŋun nhumalany, bili waŋgany yolŋu dhiyal dhiyaŋ bala ŋunhi ŋayi mirithirra yan ḻiya-djambatjnha djuḻkmaraman ŋayi ga Djalamannhany, yurr nhumany gi yaka warray ŋanya ŋäku dharaŋul.” ");
INSERT INTO djr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Ŋunhi ŋuli wakinŋunhany mokuynha dhawaṯmaram yolŋuwalnydja ŋayaŋuŋur, bala ŋayi ŋuli ga ŋunhi marrtjin ḻarruman wiripuŋuwnha wäŋaw, wanhal ŋayi dhu maḻŋ'maram wäŋa bala yan nhinan. Ga ŋuli ŋayi dhu ŋuriŋiyi wakinŋuy birrimbirryu bäyŋuny maḻŋ'maram ŋula wäŋa, ");
INSERT INTO djr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","bala ŋayi dhu waŋan bitjanna, ‘Ŋarrany dhu dhuwal balayi bili wäŋalil roŋiyirr, ŋunhi ŋarra ganarrtham.’ Ga ŋunhi ŋayi ŋuli roŋiyirrnydja ga maḻŋ'maramany ŋayi ŋuli ŋunhi wäŋany manymaknha dhikan ḏarrtjalknha ga yolŋumiriwnha, ");
INSERT INTO djr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","bala ŋayi ŋuli ŋunhi dhunupan marrtjin ga märram ŋayi dhu bulu wiripuwurruny 7-nha wakinŋumirriny birrimbirrnha mala, ŋunhi walalnydja ŋunhiwurryiny bulun dhika ganydjarr-ḏilkurra. Bala walal dhu ŋunhi bukmaknha wäŋgamany ga wäŋaramany ŋurikalyin bili yan yolŋuwal ŋayaŋuŋur, ga ŋayiny dhu ŋunhi ŋunhiyiny yolŋu ŋayaŋu-waṯaŋuny mirithirra yätjirr ŋayathanharaynydja walalaŋgal, djuḻkmaraman dhu ŋunhi nhäthinya ŋayi gan ŋunhiyi yolŋu ŋäthil nhinan. Ga bitjandhin ŋayi dhu ga ŋunhi nhumalaŋgalnydja djäma, dhuwurr-yätjmirriwalnydja yolŋuwal walalaŋgal, ŋunhi nhuma ga dhiyaŋ bala nhina.” ");
INSERT INTO djr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ga ŋunhi ŋayi gan Djesu baḏak yan waŋan ŋurikiwurruŋgalyi yolŋuwal walalaŋgal, bala walalnydja nhanŋu ŋunhi ŋäṉḏi'mirriŋuny ga yukuyuku'mirriŋuny mala bunanan, yurr dhärra'-dharranany walal gan ŋunhi ŋunhal banydji yan warraŋul buṉbuŋur, bili walal gan ŋunhi djälthin nhanŋu Djesuw waŋanharaw. ");
INSERT INTO djr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Bala ŋayi ŋunhi waŋganydhuny yolŋuy lakaraŋala Djesuwalnydja bitjarra, “Wäy! ŋunha nhuŋu ŋäṉḏi'mirriŋu ga yukuyuku'mirriŋu mala ga galkun warraŋul, djälthirr walal ga waŋanharaw nhuŋu.” ");
INSERT INTO djr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ga ŋayiny Djesuny buku-bakmaraŋal bitjarra, “Yol ŋayi dhika ŋarraku ŋäṉḏi'mirriŋuny ga yukuyuku'mirriŋuny mala?” ");
INSERT INTO djr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bala ŋayi dhunupamirriyaŋala ŋunhi malthunamirrinhan mala nhanŋuwuy, bala ŋayi waŋanan bitjarra, “Dhuwalawurr dhuwal ŋarrakuny ŋäṉḏi'mirriŋu mala ga yukuyuku'mirriŋu mala! ");
INSERT INTO djr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ŋuli ŋayi ŋula yol yolŋu dhäruk-märranhamirr ŋarrakalaŋawnydja Bäpaw djiwarr'wuywuny, ŋunhiyin ŋayi yolŋu ŋarrakuny yapa'mirriŋu ga wäwa'mirriŋu nhä mak ŋäṉḏi'mirriŋu.” ");
INSERT INTO djr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ga ŋuriŋiyi bili yan waluy bala ŋayi Djesuy ganarrthaŋala ŋunhiyiny buṉbuny, bala yan ŋayi marrtjinan yarrupthurra raŋilila, ga ŋunhiliyin ŋayi gan marŋgikuŋalnydja yolŋunhany walalany. ");
INSERT INTO djr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ga dharrwan mirithirra marrtjin ŋunhi yolŋuny walal ḻuŋ'thurr ga bäyŋun nhanŋuny dhaḻakarr, bala ŋayi ŋal'yurra marthaŋaylila ga ŋunhiliyin ŋayi gan nhinanany. Ga walalnydja ŋunhi yolŋu'-yulŋuny gan baḏak yan dhärran ŋunhili bili yan raŋiŋur. ");
INSERT INTO djr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ga dhäwuny ŋayi gan ŋunhi lakaraŋal dharrwa mirithirr, ga waŋganydja ŋayi dhäwu walalaŋ lakaraŋal bitjarra gam', “Waŋganydhu ḏirramuy gätni-djämamirriy marrtjin djalkthurr ŋatha mala maŋutji birrali munatha'lil. ");
INSERT INTO djr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ga ŋunhi ŋayi marrtjin djalkthurrnydja, ga wiripuny marrtjin galkirrin dhukarrlila, ga warrakan'tja mala ŋunhi buṯthurr bala yan ḻukanan. ");
INSERT INTO djr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ga wiripuny ŋatha mala maŋutji galkirrinan guṉḏamirrilila munatha'lil, munatha' ḏaŋawuklila ga dhunupan yan ŋunhi ŋathany maŋutjiny dhamany'tjurra. Yurr ŋayi ŋunhi munathany' gaŋga manymak ŋathawnydja ŋuthanaraw. ");
INSERT INTO djr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ga ŋunhi ŋayi waluny garramatthin ḏälthinany, bala ŋunhi waluynydja nhäŋala räwakuŋala, bili wärrurrny'tja mala nhanŋu ŋunhi märr-ḻurrkun' yan. ");
INSERT INTO djr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ga wiripuny ŋunhi maŋutji ŋatha mala galkirrin ḏirriṯirrimirrilila munatha'lil, bala gan ŋunhi ŋuriŋiyiny ḏirriṯirriynydja mala garrwi'yurra ŋunhiyiny ŋunhi ŋathany mala maŋutjiny birraliny, bala warrpam'nha ŋunhi räwakthinany.” ");
INSERT INTO djr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Ga ḻurrkun'nha yan ŋunhi ŋatha maŋutji galkirrin manymaklilnydja munatha'lil, ga ŋunhiliyiny munatha'ŋur maŋutjiny ŋathany ŋuthar manymakthinan dharrwathinan, waŋganybuy yaŋarapuy 100 maŋutji ŋatha, ga wiripuny beŋuryi yaŋaraŋur 60 maŋutji ŋatha, ga wiripuny 30 maŋutji ŋatha.” ");
INSERT INTO djr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Ŋuli nhe buthurumirrnydja dharraḏayin ga ŋäkuny ŋamathaŋun.” ");
INSERT INTO djr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ga dhurrwaraŋur beŋuryiny Djesuw malthunamirrnydja mala marrtjinan ga bunan walal nhanŋu, bala walal ŋanya gan dhä-birrka'yurra bitjarra, “Wäy! Nhaku nhe ŋuli ga dhuwal dhäwu lakaram bitjandhiny mayali'mirriyamany yolŋu'-yulŋuwnydja?” ");
INSERT INTO djr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarr, “Nhumany dhuwal bilin marŋgin ŋurukuny ŋunhi Godkalaŋuwnydja Romgu ŋurukuny ŋunhi djinawa'wuywuny mayaliw', bilin ŋarra gan ŋunhi lakaraŋala nhumalaŋgalnydja warralkuŋala. Yurr walalnydja ŋunhawurrnydja yaka warray marŋgi, bili bäyŋu ŋarra walalaŋgalnydja ŋula milkunha God-Waŋarrwu rom malany. ");
INSERT INTO djr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ŋuli ŋayi ga ŋula yolthu yolŋuy ŋayathamany yan ŋunhi God-Waŋarrwuŋuny nhä mala gurrupanawuy, ŋayiny dhu ŋunhi God-Waŋarryuny buluyi gurrupan ŋapa-ŋal'maram ŋurikiyiny yolŋuw. Ga ŋuli ŋayi ga yolŋu nhina dhaparŋ'tja yan, nhanŋuny dhu ŋurikiyiny yolŋuw nhä malany winya'yunna bäydhi ŋunhi ŋayi ga ŋayatham ŋula nhä nyumukuṉiny'tja mirithirrnydja. ");
INSERT INTO djr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yo waŋany ŋarra ŋuli ga ŋunhi mayali'kurrnydja walalaŋgalnha. Bili walal ŋuli ga nhäma walalaŋgiyingal maŋutjiy, yurr bäyŋun walal ŋuli ŋunhi yuwalkkuŋuny dharaŋul. Ga ŋunhi walal ŋuli ga ŋämany, ga bäyŋun walal ŋuli ŋunhi yuwalktja dharaŋan. ");
INSERT INTO djr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yo God-Waŋarrwu dhawuny' ŋunhi maḻŋ'thurr yuwalkthinan yan, ŋunhi ŋayi gan djawarrkmirriy yäkuy Yitjayay lakaraŋal bitjarr gam', ‘Dhiyaŋuwurruynydja dhu ga yolŋuy walal ŋäma yan, ga bäyŋun walal dhu ŋunhi yuwalkkumany ŋäma dharaŋandja. Ga nhäma warray walal dhu ga, yurr walal dhu bäyŋun yuwalkkumany nhäma dharaŋan. ");
INSERT INTO djr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bukmakkun walalaŋ dhuwaliyi ḻiyany bilin gunganhawuynha ga buthuruny walalaŋ dhaḻ'yunawuynha. Ga maŋutjiny walalaŋ dhuwaliyi bilin bambaykunhawuynha, bäyŋun walal dhu ga nhäma, ga ŋäma, ga dharaŋan yuwalkkumany. Ŋuli walal balaŋ ganha dharaŋanany, walalnydja balaŋ ŋunhi bilyunan muka ŋarrakala, bala ŋarrany balaŋ ŋunhi ḏukmaranhan walalany.’” ");
INSERT INTO djr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Yurr nhumany dhuwalawurrnydja goŋmirra mala yolŋu'-yulŋu God-Waŋarrwalnydja, bili nhumany ga nhäman ga ŋäman God-Waŋarrwuny Rom. ");
INSERT INTO djr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Dharrwa gan ŋunhi djawarrkmirr yolŋu mala ga bulu wiripu yolŋu mala manymakmirr djälthin mirithin yan nhänharaw dhiyak mala ŋunhi nhä nhuman ga dhiyaŋun bala nhäma. Ga mirithin yan walal gan djälthin ŋänharaw dhiyakuny mala dhäwuw ŋunhi nhä mala nhuma ga dhiyaŋun bala ŋäma. Yurr bäyŋun walalnydja gan ŋunhi ŋuriŋiwurruyiny nhäŋal ga ŋäkul.” ");
INSERT INTO djr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ŋäkun walal dhuwal dhuḏin mayalin' nhanŋu dhiyakiyiny dhäwuw ŋunhi nhaltjarr ŋayi gan gätni-djämamirriy ŋatha mala djalkthurr maŋutji.” ");
INSERT INTO djr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Yo maŋutji mala ŋatha ŋunhi gan galkirrin dhukarrlilnydja ga maŋutji-lakaram ŋunhin yolŋuny ŋunhi ŋayi ŋuli ŋäma warray dhäwu Godkalaŋuwuy rombuy, yurr ŋayi ŋuli ŋunhi yakan dharaŋulnydja. Bala ŋayi ŋuli ŋunhi yätjkurrnydja birrimbirr marrtjiny bala yan djaw'yunna nhanukal dhäwuny' ŋayaŋuŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ga ŋunhiny ŋatha maŋutji ŋunhi marrtjin galkirrin munatha'-ḏaŋawuklilnydja guṉḏamirrililnydja, ŋuriŋiyiny ga maŋutji-lakaram ŋunhin yolŋuny ŋunhi ŋayi ŋuli märram ŋunhiyi dhäwu mala manymakkum ŋayaŋuy nhanukiyingal ŋayi, balanyamirriy ŋunhi ŋayi ŋuli ŋämany ŋunhiyi dhäwuny. ");
INSERT INTO djr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Yurr yakan ŋayi ŋuli ŋunhi dhäwuny nhakun gärri ŋunha djinawa'lilnydja ŋayaŋulilnydja bala ŋuli ŋunhi yakan dhäwuny wiyindja ŋorri. Bili ŋunhi ŋuli ŋula nhä ŋayaŋu-wutthunamirrnydja rom maḻŋ'thun, ga dhunupan ŋayi ŋuli ŋunhi gulyunna God-Waŋarrwalnydja märr-nhirrpanminyaŋur. ");
INSERT INTO djr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ga wiripuny ŋunhi ŋatha maŋutji galkirrin ḏirriṯirrimirrililnydja, ŋuriŋiyiny ga maŋutji-lakaram ŋunhin yolŋuny ŋunhi ŋayi ŋuli bili muka ŋämany God-Waŋarrwuny dhäruk, yurr ŋayi ŋuli ga ŋunhi mirithirra dhika warwuyundja ŋula nhakun malaŋuw dhuwalaŋuwuywun, ŋunhi ŋayi ŋuli ga buku-manguman ŋayi dhu ga ḻukunydjan' yan nhina. Ga dhiyaŋiyin malaŋuy romdhu ŋuli ga ŋunhi nyumukuṉiny'kumany God-Waŋarrwuny dhäruk, ga yakan ŋayi ŋuli ŋunhiyi yolŋu ŋuthandja ŋamathamany. Ga balanyan walalnydja ŋunhi nhakun yaŋaran borumgun, yaŋaran yan waŋganynha burumun'miriwnha. ");
INSERT INTO djr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ga wiripuny ŋunhi ŋatha maŋutji galkirrin manymaklil munatha'lil, ŋuriŋiyiny ga maŋutji-lakaram ŋunhin yolŋuny ŋunhi ŋayi ŋuli ga ŋäma God-Waŋarrwu dhäruk manymakkum yan dhika, ga märram walal ŋuli marrtji yuwalkkum yan dhäruk God-Waŋarrwu. Ga dhaŋaŋdhirra walal ŋuli ŋunhi God-Waŋarrwalnydja ŋula nhaliy malaŋuy, bitjanna nhakun ŋunhi dharpa baṉa' ŋuli ga dhärra borummirr dhirrimukmirr.” ");
INSERT INTO djr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ga buluny ŋayi Djesuy wiripuny muka dhäwu lakaraŋal bitjarr gam', “God-Waŋarrwuny dhuwal Rom balanya nhakun lämu-nhirrpanamirr yolŋu ŋunhi ŋayi ŋuli marrtji djalkthun manymak ŋatha maŋutji munatha'lil. ");
INSERT INTO djr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ga ŋunhi bukmaktja yolŋu walal ŋuli ga wawun ŋorra, bala ŋayiny ŋuli ŋunhi miriŋuny marrtjin bala djalkthunna marrtji ḏimiṯimirrnydja mulmu mala ŋunhiwiliyin munatha'lila maŋutji-manapanna bala yan ganarrthaman.” ");
INSERT INTO djr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Ga ŋunhi ŋayi ŋathany ŋuthar dhakalmirriyinany, bala ŋunhi djämamirriynydja mala nhäŋala ŋunhiyiny ḏimiṯimirrnydja mala, maṉḏa gan rrambaŋin ŋutharnydja. ");
INSERT INTO djr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bala walalnydja ŋunhi djämamirrnydja mala ŋunhi ŋurikiyiny lämu-nhirrpanamirriwnydja ḏirramuw marrtjinan bala yan bunanan nhanŋu ŋurikiyiny ḏirramuwnydja, bala waŋanan nhanukal bitjarrnha, ‘Way! Ŋunhany muka nhe ŋunhi maŋutjiny ŋathany djalkthun manymak birrali yan, ga wanhaŋuwuynha ŋunha ḏimiṯimirrnydja mala?’” ");
INSERT INTO djr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Bala ŋayiny ŋunhiyiny ḏirramuny bitjarra waŋan, ‘Dhuwaliyiny ŋunhi bitjarryiny djäma miriŋuynha yan,’ bitjarr.” “Ga walalnydja ŋunhi djämamirrnydja mala waŋan bitjarra, ‘Muka djäl nhe, napurr dhu ḏulŋurr'-ḏulŋurryunna ŋunha ŋunhi ḏimiṯimirrnydja mulmu mala?’” ");
INSERT INTO djr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ga ŋayiny ŋunhi ḏirramuny waŋan bitjarra, ‘Yaka! Nhuma ŋuli bäynha ḏulŋurr'yurr rrambaŋin manymaknha ŋathany birralinhan. ");
INSERT INTO djr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ganarrthul ŋathil, ga bäy maṉḏa dhu marrtji rrambaŋi bala ŋuthan, ga gulkthunamirriynha waluy ga balanyamirriynha. Bala ŋarra dhu waŋin djämamirrinhany mala walal dhu boŋguŋ marrtji ḻuŋ'maraŋun ŋunhi ḏimiṯimirrnydja mala mulmu, bala yan bathulnha gurthaynha. Ga manymaktja ŋatha birraliny ŋarra dhu marrtji rarr'yurra balan biyakun buṉbulila ŋarrakiyingal ŋarra.’” ");
INSERT INTO djr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ga buluny ŋayi Djesuy lakaraŋal wiripun dhäwu bitjarr gam', “God-Waŋarrwuny dhuwal Rom balanya gam', nhakun ŋuli ŋunhi yolŋu gätni djämamirr marrtji bala ŋayi ŋuli lämu-nhirrpanna maŋutjin ŋathan genydjan'. ");
INSERT INTO djr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ga nyumukuṉiny ŋayi ŋunhi mirithirr yulŋuny maŋutjiny, yurr ŋuthandja ŋuli ŋunhi yindithirra dhika mirithirra, djuḻkmaraman ŋuli ga ŋunhi wiripunhany dharpany mala. Bala ŋuli ŋunhi warrakan'tja mala buṯthundja bala yalun walalaŋguwuy djäma waṉa-waṉalilnydja ŋunhiwiliyi dharpalil.” ");
INSERT INTO djr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ga bulu ŋayi Djesuy lakaraŋal bitjarr: “God-Waŋarrwuny dhuwal Rom balanya nhakun ŋuli miyalkthu märram banikin' ga dharrwan ŋayi ŋuli ŋunhi dämbany rarryun ŋunhiwiliyi. Bala ŋayi ŋuli ḻurrkun'nha yan djalkthun ŋathawuynydja ḏambakunhawuy ŋunhiwiliyiny ŋunhi maŋutji-manapan dämbalilnydja. Ga yaka wiyindja bala ŋuli ŋunhi dämbany marrtji ḏulul'yunna ŋuthanna yindithirra.” ");
INSERT INTO djr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ga dharrwamirr ŋayi gan Djesuy bitjarryiny dhäwu lakaraŋal mayali'mirriyaŋalnydja yolŋu'-yulŋuwalnydja. ");
INSERT INTO djr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bala ŋunhi dhawuny' yuwalkthinan yan maḻŋ'thurr, ŋunhi ŋayi gan God-Waŋarrwal djawarrkmirriy bitjarr lakaraŋal gam', “Ŋarrany dhu gi dhuwal dhäwu lakaraŋ ŋarrakuwuynydja ŋarra mayali'mirriyaŋ yolŋuwalnydja walalaŋgal, ga lakaraŋuny ŋarra dhu gi ŋunhi dhawaṯmaraŋun yan, ŋunhiny mala dhäwu ŋunhi gan ŋorran djuḻuḻ'yurr, ŋunhal bala ŋunhi ŋurruyirr'yunamirriy waluy.” ");
INSERT INTO djr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ga ŋunhi ŋayi Djesuy ganarrthaŋalnydja yolŋunhany walalany bala ŋayi beŋuryiny dhurrwaraŋur marrtjinan gulŋiyinan buṉbulila, ga walalnydja ŋunhi malthunamirrnydja mala nhanŋu marrtjin nhanukal ga waŋan walal ŋanya bitjarr, “Go mak napurruŋguny dhunupayaŋun lakaraŋ warraŋulkuŋun, ŋunhiny dhäwu ŋunhi ḏimiṯimirrwuynydja ga birralipuynydja.” ");
INSERT INTO djr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarr, “Ŋunhiny ḏirramu ŋunhi ŋayi marrtjin ga dholkuŋal manymaktja maŋutji ŋatha, ŋunhiyiny Yolŋun Gäthu'mirriŋu, ");
INSERT INTO djr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ga ŋunhi dhulmu-gaykarraŋdja munatha', ŋunhiyiny nhakun dhuwanna ŋayipin wäŋan ŋarakan munathan'. Ga ŋunhi manymaktja ŋatha maŋutji ŋuriŋiyiny ga maŋutji-lakaram ŋunhiwurrunhan yolŋuny walalany ŋunhi walal ŋuli ga nhina God-Waŋarrwal yan Romŋur. Ga ŋunhi ḏimiṯimirriynydja ga mulmuy maŋutji-lakaram dhuwanna ŋunhi yolŋuny walalany ŋunhi walal ga yätjkurruwal birrimbirrwal romŋur nhina, ");
INSERT INTO djr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ga ŋunhiny yolŋu ŋunhi ŋayi ŋuli ga ḻatjuwarr'maramany ŋunhiyiny ŋayipin ŋunhin buŋgawan Mokuy. Ga ŋunhi ŋatha-ŋamakuli'mirrnydja walu ŋuriŋiyiny ga maŋutji-lakaram dhawar'yunamirra walu, ŋunhi walal dhu boŋguŋ God-Waŋarrwuny dhäwu-gänhamirrnydja mala marrtjin bala yan ḻuŋ'maraŋun marrtji yolŋunhany walalany.” ");
INSERT INTO djr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ga ḏimiṯimirrnydja mulmu dhu marrtji ŋunhi ḻuŋ'maraŋun, bala yan dhuŋgur'yurra. Ga biyakiyin ŋayi dhu boŋguŋ ŋunhi yalalaŋumirriynydja maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ŋayiny dhu boŋguŋ Yolŋuynydja Gäthu'mirriŋuy djuy'yurra nhanŋuwuynydja ŋayi djiwarr'punhany djämamirriny walalany, bala walal dhu marrtji ŋunhi ḻuŋ'maraŋun yolŋunhany walalany bukmaknhan yan beŋurnydja ŋunhi God-Waŋarrwalnydja yolŋu'-yulŋuwal, ŋunhiwurrunhany ŋunhi walal ŋuli ga djäma yätjkurr, ga ŋunhiwurruny wiripuwurruny yolŋuny walalany ŋunhi walal ŋuli ga wiripuŋuny yolŋuny walalany dhar'thar-gurrupan yätjkurrulil. ");
INSERT INTO djr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ga djalkthurrnydja ŋayi walalany dhu dhä-gir'yunamirrilila wäŋalilnydja, ŋunhawalnha yanan gurthalila, ŋunhi dhu gi ŋunhiliyiny yolŋu walal ḻirra-ḻäwunhamirra baḏarratjtjurra manapul. ");
INSERT INTO djr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ga ŋunhiny mala yolŋu mala ŋunhi walal gan djäma manymaktja yan, walalnydja dhu gi ŋunhi nhini ŋunhala Bäpa'mirriŋuwala walalaŋgalaŋuwal wäŋaŋur, djarraṯawun'mirriyin nhakun walu ŋuli ga ŋunhi dhärra ḏämbuy waluy. Ŋuli nhuma buthurumirrnydja mala ŋäkuny ŋamathaŋun!” ");
INSERT INTO djr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“God-Waŋarrwuny dhuwal Rom balanya nhakun ŋunhi yolŋu ŋuli marrtji bala ŋayi ŋuli maḻŋ'maraman ŋula nhän bulayi mel-wiḏi'mirra yurr dholkunhawuynha ŋunhi wiripuwuŋ yolŋuwuŋ. Ga ŋunhi ŋayi ŋuli maḻŋ'maramany ga buluyi ŋayi ŋuli balayi dholkum bala ŋayi ŋuli marrtjin wäŋalila ga marrtjiny ŋayi ŋuli ŋunhi galŋany djulŋithirra dhika mirithirra yan goŋmirriyirr. Ga marrtjiny ŋayi ŋuli, ga nhä mala nhanŋu wäŋaŋur ga ŋorra'-ŋurra ŋunhiny ŋayi ŋuli warrpam'nha djalim rrupiyawnha, märr ŋayi dhu ŋunhi rrupiyany märram ŋunhiŋuwuyyiny bala ŋayi dhu bäyimnha ŋunhiyin wäŋan munathan' ŋunhi ŋayi djuḻuḻ'maraŋal ŋunhiyi bulayi mel-wiḏimirr.” ");
INSERT INTO djr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“God-Waŋarrwuny dhuwal Rom balanya nhakun, ŋunhi ŋuli waŋgany yolŋu djälthirr ŋayi dhu bäyim muthiyarra yurr latju'mirr mirithirr. ");
INSERT INTO djr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ga ŋunhi ŋayi ŋuli maḻŋ'maramany ŋunhiyiny latjuny' mirithirrnydja muthiyarra, bala ŋayi ŋuli djalimnha nhäny mala nhanŋuwuy ŋayi bukmaknha yan, märr ŋayi dhu märraman ŋunhiyin muthiyarran.” ");
INSERT INTO djr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“God-Waŋarrwuny dhuwal Rom balanya gam', nhakun ŋuli bitjan maḻŋ'thun, yolŋuy ŋuli ŋurrkam ganybu gapulil guḻunlil, ga gulŋiyirrnydja ŋuli ga ŋunhi ŋarirriny mala ganybulilnydja wiripu wiripun mala. ");
INSERT INTO djr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ga ŋunhi ŋuli ganybuny ŋunhi dhaŋaŋdhirr guyaynydja, bala walal ŋuli marrtji warryunna dhawaṯmaraman ganybuny ŋarirrimirrnydja raŋilila, bala ŋuli walalnydja ŋunhi ŋarirri djämamirrnydja mala nhinan bala marrtji mala-wulkmaraman barrkuwatjkuman, yätjkurrnydja mala ŋarirri walal ŋuli marrtji djalkthunna, ga rulwaŋdhundja walal ŋuli marrtji manymakmirra ŋarirri.” ");
INSERT INTO djr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Ga biyakiyin ŋayi dhu boŋguŋ ŋunhi yalalaŋumirriynydja maḻŋ'thurr dhä-dhawar'yunamirriynydja waluy. Walalnydja dhu ŋunhi God-Waŋarrwuny dhäwu-gänhamirr mala marrtjiny bala marrtji mala-wulkmaraŋun manymakmirrinhany yolŋuny walalany beŋurnydja ŋunhi yolŋuwal walalaŋgal dhuwurr-yätjkurrumirriwalnydja. ");
INSERT INTO djr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Bala dhu boŋguŋ ŋunhi dhuwurr-yätjkurrumirrinhany yolŋuny walalany djalkthurra gurthalila, ga ŋunhiliyin walal dhu gi ŋunhi ŋäthinyamirrnydja ḻirra-ḻäwunhamirrnydja.” ");
INSERT INTO djr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bala ŋayi Djesuy dhä-birrka'yurra ḻundu'mirriŋunhan mala nhanŋuwuy wanha walal ganha ŋunhi dharaŋana ŋunhiyi mala dhäwu warrpam'. Ga walalnydja yoraŋal, “Ŋe bili muka.” ");
INSERT INTO djr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bala ŋayi waŋanan walalany bitjarra, “Nhuma bukmak, ŋunhi nhuma gan marŋgithin ŋäthiliŋuw djorraw' ga romgu nhanukalaŋaw, nhumany ŋunhi malthunamirra mala Godkalaŋawnha Romgu djiwarr'puywun. Bili nhuma ŋuli ga ŋunhi nhakun dhawaṯmaraman yuṯany ga ŋäthiliŋuny ŋula nhä malany mel-wiḏi'mirr beŋura ŋunhi buṉbuŋur ŋunhi walal ŋuli ga galkan ŋula nhä malany walalaŋguwuy walal.” ");
INSERT INTO djr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ga ŋunhi ŋayi Djesu dhawar'yurrnydja dhäwuŋurnydja lakaranhaŋur, ");
INSERT INTO djr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","bala ŋayi ganarrthaŋala ŋunhiyiny wäŋa bala yan marrtjinan roŋiyinan balayin nhanukiyingala ŋayi wäŋalil. Bala yan ŋayi gan marŋgikuŋala yolŋunhan walalany ŋunhilin ŋunhi Djuw malawal buku-ḻuŋ'thunamirriŋur buṉbuŋur. Ga ŋuriŋiwurruy ŋunhi walal gan ŋäkul ŋanya, walalnydja ŋunhi mirithinan dhika ṉirr'yurrnydja nhanŋu ŋunhi nhaltjarr ŋayi gan marŋgi-gurrupar. Bala walal gan ŋunhi dhä-birrka'yunminan bitjanminan, “Way, nhaliy ŋayi gan dhuwal marŋgithinany, ga wanhaŋur ŋayi gan dhuwal balanyayiny guyaŋanhawuy märraŋal, ga djämaw ŋayaŋu-ganyim'thunamirriwnydja romgu?” ");
INSERT INTO djr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Dhuwandja dhuwal ŋunhi warray bala'-dhuḻ'yunamirriw gäthu'mirriŋu muka, ga ŋäṉḏi'mirriŋuny nhanŋu ŋunhi Meri muka. Ga wäwa'mirriŋuny mala nhanŋu ŋunhi Djayim ga Djawutjip ga Djäyman ga Djudatj, ");
INSERT INTO djr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ga yapa'mirriŋuny mala nhanŋu ŋuli ga ŋunhi dhiyal muka nhina limurruŋgala wäŋaŋur.” ");
INSERT INTO djr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bala ŋunhi yolŋuny walal gan yakan gumurr-ŋamathinany nhanŋu, ŋurru-bil'-bilyurra walal gan nhanŋu. Yurr ŋayiny Djesuny waŋan bitjarr, “Djawarrkmirrnydja yolŋu ŋuli ŋunhi marrtji wiripulilnydja wäŋalil, ga walalnydja ŋuli ŋunhi wäŋa ŋunhiŋuwuyyiny yolŋuy mala dhäruk ŋanya märram ga märr-ŋal'yun nhanŋu. Yurr ŋayi ŋuli ŋunhi nhanukiyingalnydja wäŋalil marrtji nhanukiyingalaŋuwalnydja yolŋuwal walalaŋgal gurruṯumirriwalnydja, walalnydja ŋuli ŋunhi yakan ŋanya dhäruk-märraŋ ga märr-ŋal'yurr nhanŋuny bäyŋun.” ");
INSERT INTO djr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ga bäyŋun ŋayi ŋunhi Djesuynydja ŋoy-ganyim'thunamirrnydja rom djäma ŋunhiliyiny wäŋaŋur bili bäyŋun walalaŋ ŋunhi märr-yuwalkthinyawuynydja. ");
INSERT INTO djr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ga balanyamirriynydja waluy ŋayiny ŋunhi buŋgawaynydja Yaritthuny ŋäkula dhäwuny Djesuwalaŋuwuynydja, ");
INSERT INTO djr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","bala ŋayi lakaraŋala ŋunhi nhanukiyingalaŋuwala ŋurruḏawalaŋuwala gapmangal mala bitjarra, “Dhuwaliyiny Djonnha ŋunhiyin Ḻiya-ḻupmaranhamirra yolŋu. Ga buluyi ŋayi barpuru dhuwal walŋathirr rakunyŋurnydja, bala ŋayi ga dhuwaliyi ganydjarrnydja ŋayathaman balanyarawyiny djämaw malaŋuw ganydjarr-ḏumurruwnydja romgu.” ");
INSERT INTO djr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Bili ŋayiny ŋunhi Yaritthuny ŋäthil yan muka ŋanyanhany Djonnhany ḏapmaram, garrwi'-garrwiyurrnydja rakiyny'tja bala yan galkanna dharruŋgulila, ga bitjandhiny ŋayi ŋunhi Yaritthu djäma bili ŋayi Djondhu ŋanya waŋa ŋurru-dhunupa bitjan, “Yaka nhuŋu dhuwal dhunupa nhe dhu dhuwaliyi miyalknha yäkuny Yirutikany märram bili ŋayi dhuwaliyi yukuyuku'mirriŋuw nhokalaŋaw miyalk Bilipku.” ");
INSERT INTO djr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bala ŋayiny gan ŋunhi Yarittja bunharawnha yan nhanŋu Djonguny djälthin murrkay'kunharawnha yan, yurr yaka yan ŋayi ŋanya ŋunhi yänayiny bunha bili ŋayi gan ŋunhi barrarin yolŋuw walalaŋ, bili walalnydja gan ŋunhi yolŋuynydja walal guyaŋan yanbi ŋayi ŋunhi Djondja djawarrkmirra yolŋu. ");
INSERT INTO djr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ga ŋunhi nhanŋu Yaritkuny waluny bunan, ŋunhi walal dhu ŋathan nhanŋu ḻuka dhawal-guyaŋanhawuynha nhanukalaŋuwuy, bala gan ŋunhi yothuny nhanŋu ŋurikiyi miyalkkuny yäkuw Yuritikawnydja burr'yurra ŋunhiliyin yolŋuwnha walalaŋ djuwun'. Ga ŋayipiny ŋunhi Yarittja ");
INSERT INTO djr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","mirithinan yan galŋa-djulŋithinany ŋuriŋiyiny buŋgulyuny nhanukal, bala ŋayi yan ŋanya dhawu'-nhirrpara ŋunhiyiny yothunhany ŋayi dhu gurrupanna yan ŋanya ŋula nhäny ŋunhi ŋayi dhu ŋanya ŋuriŋiyi miyalkthu yothuy ŋäŋ'thun. ");
INSERT INTO djr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ga ŋayiny ŋuriŋiyiny ŋäṉḏi'mirriŋuynydja waŋa ŋanya ŋunhiyiny yothunhany miyalknhany ŋayi dhu waŋany bitjanna, “Djälnydja ŋarra dhuwal Djongalaŋaw ŋunhi Ḻiya-ḻupmaranhamirriw muḻkurrwu! Yurr bilkpilkthu banikin'thu nhe dhu gämany ŋanya ŋarrakal.” ");
INSERT INTO djr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bala ŋayi ŋunhi buŋgawany Yarittja galŋa-miḏikirra ḻiya-ŋarrtjunmirra manapan ŋunhiŋuwuynha ŋunhi ŋayi ŋanya ŋunhiyi yothuny dhawu'-nhirrpan milma nhakun yolŋu'-yulŋuwala. Yurr yakan ŋayi gan ŋunhi djälthin ŋayi dhu bakmaramany ŋunhiyi dhawuny'. ");
INSERT INTO djr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Bala yan ŋayi dhäruk-gurrupanminan djämamirriwala mala nhanukalaŋuwal, walal dhu marrtji bala dharruŋgulil ga muḻkurrnha gulkthun Djonnhany. ");
INSERT INTO djr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ga muḻkurrnydja walal ŋunhi Djonnhany rulwaŋdhurrnydja bilkpilklila banikin'lilnydja, bala walal gäman ŋurikalyin miyalkkala yothuwala, ga ŋayiny ŋunhi yothuynydja gurrupan ŋäṉḏi'mirriŋuwala. ");
INSERT INTO djr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ga walalnydja ŋunhi Djongalnydja ḻundu'mirriŋuy mala märramany Djonnha rumbalnydja bala walal dholkuman. Ga yorrnha walal ŋunhi dhäwu gäma Djesuwnydja bala lakaraman nhanukal. ");
INSERT INTO djr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ŋunhi ŋayi Djesuy dhäwuny ŋäkul Djongalaŋuwuynydja, bala ŋayi marrtjinan buḏapthurra ŋurikiyiny Galaliwuywuny guḻun'ku, märr ŋathil ŋayi dhu ga gäna nhina yolŋumiriw. Yurr walalnydja ŋunhi yolŋuny walal marŋgithin nhanŋu bala yan ganarrthala walalaŋguwuynydja wäŋa, bala yan dhurputjnha marrtjin djalkiriynha ḻarruŋala nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ga ŋunhi ŋayi gan Djesu wapthurrnydja marthaŋayŋurnydja, bala yan ŋayi nhäŋala yolŋunhany walalany dharrwanhan dhika mirithirra. Bala yan ŋayi walalaŋ ŋayaŋu-warwumirriyinan, bala ŋayi gan yan ḏukmaraŋala bukmaknhan yan ŋunhi rerrimirrinhany mala. ");
INSERT INTO djr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ga ŋuruŋun ḻäy-bilyunaraynha bala walalnydja ŋunhi malthunamirrnydja mala nhanŋu Djesuw marrtjinany bala waŋanany bitjarrnha, “Wäy ŋayilpi'yinan dhuwal wäŋany, galki ŋayi dhu dhuwal munhany-yupthunna. Dhuwandja yolŋunhany mala djuy'yurra walal marrtjin wäŋalila, märr walal dhu ŋunha ŋathan marrtji walalaŋguwuy märra'-marram.” ");
INSERT INTO djr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarr, “Yaka walalany djuy'yurr. Nhämirr balaŋ dhu nhumany walalany gurrupan ŋula nhä ḻukanharaw?” ");
INSERT INTO djr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ga walalnydja waŋan bitjarr, “Bäyŋun dhuwal goŋ-waŋgany yan dämbany ga märrma' yan ŋarirriny.” ");
INSERT INTO djr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ga ŋayiny Djesuynydja waŋan ŋunhi ḻundu'mirriŋunhany mala nhanŋuwuy ŋayi bitjarr, “Go räli walal gäŋu dhuwaliyi ŋathany,” ");
INSERT INTO djr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","bala ŋayi yolŋunhany walalany dhunupan yan waŋanan nhinanhamaraŋala mulmulila. Bala ŋayi Djesuynydja märraŋala ŋunhi goŋ-waŋganydja dämbany mala ga ŋarirriny maṉḏany, bala yan ŋayi dhupuŋala djiwarr'lila, bala buku-wurrpara ŋurikiyi ŋathawnydja. Bala ŋayi bakmaraŋala ŋunhiyi ŋathany, bala ŋayi gurrupara malthunamirriwala mala nhanukalaŋuwal, ga walalnydja gurrupar marrtjin ŋunha yolŋunhan walalany. ");
INSERT INTO djr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ga bäy walal marrtjin ḻukan ga maranhuyin yan bukmak, bala ŋunhi Djesuwal ḻundu'mirriŋuynydja mala marrtjin wapmaraŋala bäythinyawuynydja bathilila, ga dhaŋaŋguŋalnydja walal ŋunhi 12 bathiny bäythinyawuyyuny ŋathay. ");
INSERT INTO djr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ga dhaŋaŋ ŋunhi mirithirr ḏirramuwurrnydja ŋula nhämunha mala 5,000, ga yaka walal bothurru' miyalkkurruwurrunhany ga djamarrkuḻi'nhany. ");
INSERT INTO djr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ga dhurrwaraŋur beŋuryiny, bala yan ŋayi dhunupan Djesuynydja waŋanan ŋunhi malthunamirrinhany mala nhanŋuwuy djuy'yurra ŋäthila marthaŋayyun. Yurr ŋayipiny ŋunhi ŋunhiliyin banydjin ŋurr'yurr, ga baḏak ŋathil ŋayi gan yolŋuny walalany djuy'yurr wäŋalil roŋanmaraŋal. ");
INSERT INTO djr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bala ŋayi ḏuwaṯthurra bukulila ga ŋunhiliyin ŋayi gan gänan nhinanany bukumirriyaŋala, ga yan bili-i-i ga munha yupthurr. ");
INSERT INTO djr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ga ŋayiny ŋunhi balanyamirriyyiny marthaŋaynydja ŋunhala barrkun dhulmuŋura, bala ŋunhi wäŋiny walalaŋ bunanan yindin dhikan mirithirra bumara marrtjin ŋunhi marthaŋaynhany, bala gan ŋunhi marthaŋaynhany ḏowuynydja gäŋala bala-rälin. ");
INSERT INTO djr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ga baḏak yan ŋayiny gan ŋunhi munhany gorruŋal yurr goḏarr'mirra, bala ŋayiny gan ŋunhi Djesuny marrtjinan ŋapakurra gapukurr balayin guwatjmara walalany marthaŋaylila. ");
INSERT INTO djr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ga ŋunhi walal ŋanya nhäŋalnydja bala yan walal barrarinan ŋapa-ŋayathaŋala yatjunminan, bili walalanydja ŋunhi guyaŋan yanbi gan mokuyyun walalany guwatjmar. ");
INSERT INTO djr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yurr ŋayiny Djesuny waŋanan walalaŋgal bitjarra, “Way ŋoy-ḏälthi walal. Yaka barrari! Dhuwandja ŋarra muka,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bala ŋayi Betany waŋan bitjarra, “Garray ŋuli dhuwaliyi yuwalktja nheny, dhäruk-gurrupanmirra ŋarraku, märr ŋarrany dhu marrtjin dhipaliyin nhokalnha.” ");
INSERT INTO djr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Bala ŋayi Djesuny wäthurra nhanŋu, “Go marrtjin,” bitjarra. Bala ŋayi Betany wapthurra marthaŋayŋurnydja bala gan djartjaryurra gapukurra gumurr'yurra Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ga ŋunhi ŋayi gan Beta marrtjinany, bala ŋayi nhäŋala ḏowunhan ga watanhan ŋayi marrtjin yindithin, bala yan ŋayi ŋoy-gärrinan ga dhunupan ŋayi ŋunhi guḻwuḻyurra yulŋuny gapulila. Bala ŋayi wäthurra, “Wäy Garray, walŋakuŋ ŋarrany,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ga dhunupan ŋayiny Djesuny goŋ-djarryurra nhanŋu bala yan ŋayathaŋala ŋanya. Bala ŋayi waŋanan nhanŋu bitjarra gam', “Nhä dhuwal nhuŋu märr-yuwalkthinyawuynydja nyumukuṉiny yan? Nhaku nhe ŋuli ga dhuwal märr-yuḻkthundja?” ");
INSERT INTO djr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ga ŋunhi maṉḏa Beta ga Djesu wapthurrnydja marthaŋaylilnydja bala ŋunhi watany gulyurra, ga wäŋany wapurarryinan. ");
INSERT INTO djr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bala ŋunhi ḻundu'mirriŋuny mala nhanŋu Djesuw buku-ŋal'yurra gan nhanŋu, bitjarra, “Yuwalk muka nhe dhuwal God-Waŋarrwuny Gäthu'mirriŋu.” ");
INSERT INTO djr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Manymak walalnydja ŋunhi Djesuny ga ḻundu'mirriŋuny mala nhanŋu buḏapthurra ŋurikiyiny guḻun'kuny, ga dhawaṯthurrnydja walal ŋunhilin wäŋaŋur yäkuŋur Ginitjarathnha. ");
INSERT INTO djr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ga dhunupan walalnydja ŋunhi yolŋuynydja walal nhäŋal ŋanya Djesunhany ŋunhi ŋayi ŋunhiliyiny bunan wäŋaŋur, bala walal dhunupan marŋgithinan yol ŋayi ŋunhi yolŋu, bala gan yolŋuny walal dhäwu gänhaminan ŋunhiliyiny ŋarakaŋur wäŋaŋur. Bala walal marrtjin yolŋuynydja walal gäŋa'-gaŋala rerrimirrinhan yolŋuny walalany balayin nhanukala Djesuwala. ");
INSERT INTO djr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bala walal gan waŋanan ŋanya mirithinan dhika buku-ḏuwaṯthurra nhanŋu walal balaŋ ŋunhi rerrimirriynydja mala yan girrin' yan nhanukalaŋumirr ŋayathanha yurr djinmir'nha. Ga ŋunhi walal gan bitjarryiny djäma girriny' yan nhanŋu ŋayathaŋal, walalnydja gan yan ŋunhi dhunupan ḏukthurra rerriŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ga balanyamirriynydja waluy walalnydja ŋunhi Baratjiny mala ga Marŋgikunhamirr mala ŋunhi Mawtjitjkalaŋawnydja Romgu wäŋgaŋala walal beŋurnydja Djurutjalamŋurnydja. Bala walal dhä-birrka'yurra ŋanya Djesunhany bitjarra, ");
INSERT INTO djr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nhaku ŋuli ga ŋunhi nhuŋuny malthunamirr mala bäyŋuny romgu malthurr ŋurikiyiny romgu ŋunhi ŋäthiliŋuwnydja, ŋunhi nhaltjarr walal gan limurruŋgal ŋaḻapaḻmirriy mala marŋgi-wurrupar limurruny? Bäyŋun walal ŋuli gi dhuwal goŋdja rurrwuyunmirr bay ŋathawnydja ḻukanharaw.” ");
INSERT INTO djr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarr, “Ga nhaku nhuma ŋuli ga ŋunhi rom bakmaram nhanŋuny God-Waŋarrwuny dhäruk-gurrupanminyawuy, bala nhuma ŋuli ga ŋunhi malthundja nhumalaŋgiyingalaŋawnha yan romguny ŋäthiliŋuwnha mala ŋurrŋgitjkun. ");
INSERT INTO djr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Muka bäyŋu ŋayi ŋunhi God-Waŋarryu nhumalany waŋanha nhuma dhu ga märr-ŋal'yun nhumalaŋgiyingalaŋaw ŋäṉḏi'mirriŋuwnydja ga bäpa'mirriŋuwnydja? Ga ŋuli dhu ga ŋunhi ŋula yolthu yolŋuy gumurr-dhar'yun ŋäṉḏi'mirriŋunhany nhanŋuwuy ŋayi ga bäpa'mirriŋunhany, ŋanyanhany dhu ŋunhi ŋunhiyinhany yolŋuny buman yan murrkay'kuman? ");
INSERT INTO djr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Yurr nhumany walalany ŋuli ga ŋunhi nhäman yan bay'nha, bili bäyŋun walal ŋuli gi ŋunhi yuwalkkuŋuny guŋga'yurr walalaŋguwuy gurruṯumirrinhany mala. Bala nhuma ŋuli ŋunhi ŋulthu'maraman walalany, märr walalnydja ŋuli ŋunhi bitjanna waŋany gam', ‘Ŋarrany dhu dhuwal mundhurr gurrupan God-Waŋarrwun nhanŋuwuynha dhulŋuŋun.’ Ga ŋunhi walal ŋuli ga bitjandhiny waŋa, nheny ŋuli ga ŋunhi manymak lakaraman walalany. Yurr nhuma ŋuli ga ŋunhi yakan nhakun guŋga'yurrnydja ŋäṉḏi'mirriŋunhany ga bäpa'mirriŋunhany nhumalaŋguwuy nhuma. Ga bitjandhin nhuma ŋuli ga ŋunhi God-Waŋarrwuny dhäruk gali'lila ŋurrkam, bala nhuma ŋuli ga ŋunhi djarrpi'kuman marŋgikumany wiripuwurrunhany yolŋuny walalany, märr walal dhu ga ŋunhi mirithirrnydja malthun ŋurikiyin bili yan nhumalaŋgiyingalaŋawnha ŋurrŋgitjkun romguny ŋäthiliŋuwnha. ");
INSERT INTO djr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nhä nhuma dhuwal rom-gali'märrma' yolŋuny walal. Märr-yuwalk muka ŋayi ŋunhi djawarrkmirriynydja yäkuy Yitjayaynydja wukirri dhäruktja ŋanya God-Waŋarrnha ŋäthilnydja bitjarrnydja gam', ");
INSERT INTO djr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nhumany ŋuli ga dhuwal wokthun ŋarrakuny dhärukthu yan waŋganydhu, ga bäyŋun nhuma ŋuli gi dhuwal yuwalkkuŋuny guyaŋi ŋarranhany. ");
INSERT INTO djr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ga ŋunhi nhuma ŋuli buku-ŋal'yundja ŋarraku, ŋarrany ŋuli ŋunhi yakan nhumalaŋ buthuru-bitjun. Bili nhuma ŋuli ga dhuwal romdja ŋayatham baṯ-bitjandja ŋunhiyin yolŋuwuŋun guyaŋanhawuynydja. Yakan God-Waŋarrwuŋuny.’” ");
INSERT INTO djr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Bala ŋayi Djesu wäthurra bukmakkun yolŋuw walalaŋ waŋganylila ḻuŋ'maraŋal, bala ŋayi waŋanan bitjarra, “Ŋäkuny walal ŋamathaŋun yan ga yuwalkkuŋun yan dharaŋulnydja ŋunhi nhaltjan ŋarra dhu dhuwal lakaram. ");
INSERT INTO djr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yolŋuny dhu dhuwal yaka ŋayaŋu-yätjirr ŋula nhaliy ŋunhi ŋayi ŋuli galkan ŋula nhä malany dhurrwarakurr nhanukiyingal ŋayi, ŋany ŋayaŋuny ŋayi ŋuli yätjirr ŋuriŋin ŋunhi nhä nhanukal ŋuli yätjkurr dhurrwarakurr dhawaṯthun.” ");
INSERT INTO djr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ga walalnydja ŋunhi malthunamirrnydja mala nhanŋu marrtjin nhanukal ga dhä-birrka'yurr walal ŋanya bitjarr, “Marŋgi nhe. Dhuwaliyiny nhe bitjarryiny waŋan ŋayaŋu-wuthurra walalanhan ŋunha Baratjinhan walalany?” ");
INSERT INTO djr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ga ŋayiny Djesuny buku-bakmaraŋal bitjarr, “Ga bukmak ŋunhi dharpa mala, ŋunhi ŋarrakal Djiwarr'wuyyu Bäpa'mirriŋuy yaka lämu-nhirrpanna, ŋunhiyiny ŋayi dhu ḏulŋurr'yurra bala yan ŋurrkuŋun. ");
INSERT INTO djr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yaka walal galkithi dhiyakurruŋgalnydja Baratjiwalnydja mala, bili walalnydja dhuwaliyi bambaymirra mala. Ga ŋunhiny yolŋu mala ŋunhi walal ŋuli ga malthun walalaŋ romgu, walalnydja ŋunhiwurryiny balanyayi bili bambaymirryi, ga rrambaŋin maṉḏa dhu ŋunhi galkirriny ŋarŋgalilnydja, ŋayi maŋutji-warryunamirr ga ŋayi malthunamirr yolŋu.” ");
INSERT INTO djr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ga ŋayiny Betany waŋan bitjarr, “Nhä ŋayi dhuwaliyi mayaliny', ŋunhi nhe waŋan bitjarrnydja, ‘Yolŋuny dhu ŋunhi yaka ŋayaŋu-yätjirr ŋula nhaliy ŋunhi nhanukal dhu dhurrwarakurr gulŋiyirr,’ bitjarrnydja.” ");
INSERT INTO djr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ga ŋayiny Djesuny buku-bakmaraŋal nhanŋu bitjarr, “Muka yaka yan nhuma gi dhuwal dharaŋulnydja ŋunhi nhaltjan ŋarra ga dhuwal waŋa dhiyaŋ bala? ");
INSERT INTO djr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","18","Muka yaka yan nhuma dhuwal marŋginy, ŋunhi nhuma ŋuli ŋula nhä ŋathany ḻuka dhurrwarakurrnydja galkan, bala ŋuli ŋunhi ŋathany mala dhawaṯthunna rumbalŋurnydja nhumalaŋgalaŋaŋur? Ga nhä mala dhäruk ŋunhi ŋuli ga dhawaṯthun dhuwalatjandhi dhurrwarakurr nhumalaŋgalaŋawurr, ŋunhiny ŋuli ga dhawaṯthun beŋura ŋayaŋuŋura nhumalaŋgal. Ga ŋuriŋiyin mala ŋuli ga ŋunhi nhumalany ŋayaŋuny yätjkurrkum, nhuma dhu ga yakan ŋunhi märr-ŋal'yun God-Waŋarrwuny manymakkumany. ");
INSERT INTO djr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dhipuŋuryin ŋuli ga ŋunhi ŋayaŋuŋura dhawaṯthun yätjkurrnydja mala balanyany mala nhakun: djarrpi'kunhawuynydja guyaŋanhawuy, murrkay'-wutthunamirrnydja rom, marrambany', ḻäy-ŋarr'ŋarrnydja rom, manaŋany, mayali'miriwnydja rom, ŋayaŋu-miḏikumanamirrnydja rom ga nyäḻny'tja mala. ");
INSERT INTO djr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dhiyaŋiyin mala ŋuli ga ŋunhi ŋayaŋuny mala nhumalaŋ yätjkurrkum. Ŋuli nhuma dhu ŋunhi ŋathany ḻuka goŋdhu rurrwuyunamiriwyuny, dhiyaŋiyiny nhumalany dhu ŋunhi yakan gulmaram God-Waŋarrwalnydja buku-ŋal'yunaŋur.” ");
INSERT INTO djr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Bala ŋayi Djesuy ganarrthaŋala ŋunhiyiny wäŋa, ga marrtjinany ŋayi balan ŋarakalil wäŋalil galki ŋunhi gan märrma' yindi maṉḏany wäŋa dhärran yäku Däya ga Djaydan. ");
INSERT INTO djr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Manymak marrtjinan ŋayi gan ŋunhi Djesuny dhukarrkurra, ga ŋunhiliyiny dhukarrŋurnydja miyalknha nhanŋu marrtjin wäthurr Djesuwnydja, yurr ŋayi ŋunhi miyalktja ŋunhaŋuwuy Gaynanbuy, ga wäthurrnydja ŋayi marrtjin ŋunhi mirithinan yan dhika bitjarrnha, “Way Garray, Gäthu'mirriŋu Daybitku, mel-wuyurr ŋarraku. Yothu ŋarraku ŋunha miyalk, yurr ŋayi ga ŋunha nhinany dhaŋaŋnha wakinŋumirrnydja birrimbirrmirr.” ");
INSERT INTO djr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yurr ŋayiny Djesuynydja ŋäkul ŋanya ganarrthaŋal, ga mukthurr yan bala ŋayi gan marrtjin dhärukmiriw. Ga ŋayiny ŋunhi miyalktja gan malthurr yan nhanŋu yatjurr marrtjin bala. Ga walalnydja ŋunhi malthunamirriynydja mala nhanukal Djesuwal waŋanan ŋanya Djesunhany ŋayi dhu ŋaŋ'ŋaŋ'thunna ŋanya ŋunhiyiny miyalknhany. ");
INSERT INTO djr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ga ŋayiny Djesuny waŋanan bitjarrnha, “Ŋarrany dhuwal marrtjin räli Yitjuralpuyŋuw yan yolŋuw walalaŋ walŋakunharaw. Bili walal dhuwal balanya nhakun bimbi mala winya'yunawuy.” ");
INSERT INTO djr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ga ŋayiny ŋunhi miyalktja marrtjin galkithin nhanukal bala yan ŋayi bun'kumu-djipthurra bala gan ŋäŋ'thurra ŋanya Garraynhany bitjarra, “Garray marrkapmirr ŋathil guŋga'yurr ŋarrany!” ");
INSERT INTO djr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ga ŋayiny Djesuny buku-bakmaraŋal nhanŋu bitjarr, “Yaka dhuwal dhunupa ŋunhi dhu yolŋuy märram ŋatha ŋunhi djamarrkuḻiwny'tja bala ŋayi dhu djalkthunna wuŋgangun.” ");
INSERT INTO djr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ga ŋayiny ŋunhi miyalktja waŋan bitjarra gam', “Yuwalk dhuwaliyiny Garray. Yurr ŋayiny ŋuli ŋunhi wuŋgandhuny muṉguynha ḻuka, beŋurnha ŋunhi Buŋgawalnha ḻukanhaŋur.” ");
INSERT INTO djr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Bala ŋayiny Djesuny buku-bakmaraŋal nhanŋuny bitjarra, “Gumurrtjararrk miyalk, yuwalk muka nhuŋu dhuwal märr-nhirrpanminyawuynydja yindi mirithirr, nheny dhu dhuwal märraman yan ŋunhi nhaku nhe gan ŋäŋ'thurr.” Ga balanyamirriyi bili yan nhanŋu ŋunhi yothuny ŋurikiyi miyalkkuny ḏukthurra. ");
INSERT INTO djr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ga ganarrthaŋal ŋayi ŋunhiyiny wäŋa Djesuy bala ŋayi beŋuryiny gan marrtjin raŋikurra ŋunha Galaliwurra. Ga marrtjinany ŋayi gan ŋunhi-i-i, dhutnha nhinan bukuŋura. ");
INSERT INTO djr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ga dharrwan ŋunhi mirithirra yolŋuny walal bunanany nhanŋu ŋunhiliyiny, ga dharrwany yan walal gan ŋunhi gäŋal rerrimirrinhany mala nhanukal Djesuwalnydja balanya nhakun bundhurrmirriny ga gaṉuŋnha ga bambaynha ga dhärukmiriwnhany yolŋuny walalany. Ga gäŋalnydja walal gan ŋunhi walalany bala rarr'yurrnydja gumurrlila nhanukal Djesuwalnydja. Ga bukmaknhan yan ŋunhi rerrimirrinhany yolŋuny walalany ŋayi gan Djesuynydja ḏukmaraŋala. ");
INSERT INTO djr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ga walalnydja ŋunhi wiripuwurruynydja yolŋuy walal gan nhäŋalnydja ga ŋäkulnydja ganyim'thurra, bili ŋunhiny yolŋu ŋunhi ŋayi ŋäthilnydja dhärukmiriwnydja ŋunhiny ŋayi gan waŋanan dhärukmirriyinan ga maṉḏany gan gaṉuŋdja ga bundhurrnydja bilin marrtjinan, ga bambayyuny gan nhäŋala. Ga bukmaknha walal gan ŋunhi wokthurrnydja nhanŋu God-Waŋarrwuny, ŋurikiyiny God-Waŋarrwu Yitjuralpuyŋuwnydja. ");
INSERT INTO djr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Bala ŋayi Djesuny wäthurra nhanukalaŋaw malthunamirriwnydja mala, ga waŋanany ŋayi walalany bitjarra, “Dhuwal ŋarra ŋayaŋu-wuyurra bay, dhiyakurruŋgun yolŋuwnha walalaŋ. Bilin walal gan dhuwal malthurrnydja ŋarraku ḻurrkun'nha waluny, ga bäyŋun walalaŋ dhuwal ŋula ŋathany ḻukanharawnydja. Ga yakan ŋarra gi dhuwal djälthi djuy'yunarawnydja walalaŋ walal ŋuli bäynha ŋula marryay'nha dhiŋgu'-dhiŋguŋ gandarrŋura.” ");
INSERT INTO djr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ga walalnydja ŋunhi malthunamirrnydja mala nhanŋu waŋan bitjarr, “Wäy, dhuwandja dhuwal wäŋa ŋayilpin' balanyan ŋathamiriwnha. Wanhala bili dhu ŋula ŋathany maḻŋ'maram maranhuny gurrupanarawnydja walalaŋ dhiyakiwurruŋguny?” ");
INSERT INTO djr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ga ŋayiny Djesuynydja dhä-birrka'yurr walalany bitjarr, “Nhämunha nhumany ga dhikayiny ŋatha ŋayatham?” Ga walalnydja waŋan, “Dämbany dhuwal djabin yan ga märr ḻurrkun' nyumukuṉiny mala ŋarirriny'.” ");
INSERT INTO djr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ga ŋunhi ŋayi gan Djesuy waŋanany yolŋunhany walalany nhinanhamaraŋalnydja, ");
INSERT INTO djr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","bala ŋayi märraŋala ŋunhiyiny dämbany mala ga ŋarirriny' ḻurrkun'tja, bala yan ŋayi buku-wurrpara God-Waŋarrnhan ŋurikiyi. Bala yan ŋayi bakmaraŋala ŋunhiyi dämbany mala ga ŋarirriny', bala goŋ-gurrupara malthunamirriwala mala nhanukalaŋuwal, ga walalnydja marrtjin gurrupara ŋunha yolŋu'-yulŋunhan mala. ");
INSERT INTO djr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ga bukmakthun ŋunhi ḻukanany maranhuyinan yan, ga bäythinyawuyyuny mala ŋathay walal dhaŋaŋguŋal djabin yindimirr mala nyäḻka. ");
INSERT INTO djr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ga nhinanany gan ŋunhi ŋunhiliyiny 4,000 ḏirramuwurrnydja, yaka walal miyalkkurruwurrunhany ga djamarrkuḻi'nhany bothurru'. ");
INSERT INTO djr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ga ŋunhi ŋayi gan Djesuy djuy'yurrnydja yolŋunhany walalany roŋanmaraŋalnydja, bala yan ŋayi marrtjinan, wapthurrnydja ŋayi marthaŋaylilnydja bala yan buḏapthurra ŋurikiyiny guḻunguny. Ga dhawaṯthurrnydja ŋayi ŋunha galin' galki wäŋaŋur yäkuŋur Makatannha. ");
INSERT INTO djr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ga waŋganymirrnydja yolŋu walal Baratji ga Djatutji mala marrtjin Djesuwal, bala walal gan ŋäŋ'thurra ŋanya ŋayi balaŋ milkunha walalaŋ ganydjarr ŋurukuwuy djiwarr'wuy, yan nhakun walal ŋanya gan birrka'yurr. ");
INSERT INTO djr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ga ŋayiny walalaŋgal lakaraŋal bitjarra, “Ŋuli nhuma dhu ŋunhi nhäma dhipal bala gali' bärra'lil ŋayi dhu wärrarra-gorrum, nhumany dhu marŋgithirr yan ŋunhi ŋayi dhu bäyŋun dharyun. ");
INSERT INTO djr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ga ŋuli nhuma dhu nhäma dhipal bala gali'lil bulwunulil ŋayi dhu maŋanmirriyirr wäŋa, nhumany dhu mak ŋunhi bitjanna waŋa; nhaltjan dhu dhuwandja gäthurnydja dharyun. Ŋuruŋ bili yan nhuma dhu ga marŋgithirr ŋunhi nhä mala nhuma dhu ga nhäma. Ga bäyŋun nhumany gi dhuwal dharaŋul ŋunhi nhä marrtji dhiyaŋ bala maḻŋ'thun. ");
INSERT INTO djr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nhumany ga dhuwal djälthirr nhuma dhu nhäma ganydjarr ŋurukuwuy djiwarr'wuy, bili nhuma dhuwal dhuwurr-yätjmirr yolŋu walal, ga bäyŋun nhuma dhu ŋunhi märr-yuwalkthirrnydja! Ga nhämany nhuma dhu ga romdja ŋunhin bili yan ŋunhi nhä maḻŋ'thurr ŋurikiyi yolŋuw yäkuw Djawunaw.” Bala yan ŋayi Djesuy ganarrthaŋala ŋunhiyiny wäŋa bala marrtjinan. ");
INSERT INTO djr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ga ŋunhi walal buḏapthurrnydja ŋurikiyiny guḻun'kuny, ga walalnydja ŋunhi malthunamirriynydja mala nhanukal meṉguman ŋathawnydja gänharaw. ");
INSERT INTO djr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Bala ŋayiny Djesuynydja walalany waŋanan djägakuŋala bitjarra, “Djägan walal nhumalaŋguwuy nhuma yulŋuny ŋurukurruŋgalnydja ŋunhi Baratjiwalnydja walalaŋgal ga Djatutjiwalnydja mala, walal ŋuli bäynha nhumalany mayali'-gäŋu bala wiripuyaŋun nhumalany waṉa-gäŋu.” ");
INSERT INTO djr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yurr walalnydja ŋunhi malthunamirrnydja mala nhanŋu gan waŋanhaminan dhä-birrka'yunminan walalawuynha bitjanminan, “Dhuwaliyiny ŋayi mak bitjarryiny waŋan, bili limurr bäyŋu ŋula ŋatha märranha.” ");
INSERT INTO djr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ga ŋayiny ŋunhi Djesuny dhunupa yan marŋgithinan ŋunhi nhaltjarr walal bitjarryi guyaŋan, bala ŋayi waŋanan bitjarra, “Yuwalk muka nhumalaŋ dhuwal märr-nhirrpanminyawuynydja nyumukuṉiny yan! Nhäpuy nhuma ga dhuwal waŋanhamirrnydja, bili nhuma yaka ŋatha gänha? ");
INSERT INTO djr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Yaka yan nhuma gi dhuwal dharaŋulnydja? Muka meṉguman nhuma dhuwal ŋunhi yolŋunhany walalany 5,000-nhany malany ga nhämunha ŋunhi bathi bäythinyawuyyu ŋathay nhuma dhaŋaŋgum? ");
INSERT INTO djr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ga wiripuny muka ŋunhi 4,000-nha yolŋu'-yulŋuny, ga bäythinyawuyyuny ŋathay nhuma dhaŋaŋgum djabin bathi mala. ");
INSERT INTO djr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yaka yan nhuma gi dhuwal dharaŋulnydja? Yaka ŋarra gi dhuwal waŋi nhumalany dhiyakuwuyyi ŋathapuy. Waŋany ŋarra nhumalany ga dhuwal djägakumany ŋurukurruŋgala Baratjiwala mala ga Djatutjiwala mala, walal ŋuli bäynha nhumalany waṉa-gäŋu wiripuyaŋun.” ");
INSERT INTO djr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ga yorrnha walal ŋunhi malthunamirriynydja mala nhanukal dharaŋan ŋunhi ŋayi ga Djesuny yaka waŋa ŋathapuynydja ḏambakunhawuy, ŋany waŋany ŋayi ga ŋunhi djägakumany walalany märr walal dhu yaka malthun walalaŋ Baratjiw ga Djatutjiw mala marŋgithinyawuywu. ");
INSERT INTO djr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ga ŋunhi walal marrtjin Djesu ga malthunamirr mala nhanŋu wäŋgaŋalnydja bala-a-a, ga galki wäŋaŋur yäkuŋur Djitjariya Bilipaynha, bala ŋayi waŋanan dhä-birrka'yurra walalany bitjarra, “Yolnhan ŋuli ga ŋunhi yolŋuynydja walal lakaram ŋarranhany?” ");
INSERT INTO djr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ga walalnydja ŋunhi malthunamirriynydja mala nhanukal buku-roŋanmaraŋal nhanŋu bitjarr gam', “Wiripuwurruynydja yolŋuy walal ŋuli ga lakaram nhuna, yanbi nhe dhuwal Djonnha ŋunhi Ḻiya-ḻupmaranhamirra yolŋu, ga Yilaydja ga wiripuny Djirimaya, nhä mak wiripun ŋula djawarrkmirr yolŋu.” ");
INSERT INTO djr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ga ŋayiny Djesuynydja dhä-birrka'yurr walalany bitjarr, “Ga nhumany ŋuli ga nhaltjan guyaŋa ŋarranhany? Yol bili ŋarrany dhuwal yolŋu?” ");
INSERT INTO djr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bala ŋayiny Djäyman-Betany waŋan bitjarra, “Nheny dhuwal ŋunhiyin yolŋu Maŋutji-dhunupayanhawuynha, Gäthu'mirriŋu ŋurikiyin God-Waŋarrwu ŋunhi ŋayi ga nhina Walŋa-ḏikṯiknha.” ");
INSERT INTO djr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Bala ŋayiny Djesuny waŋan nhanŋu bitjarra, “Djäyman gathu'mirriŋu Djawunaw, gay'yi muka! God-Waŋarrwuny ŋamakuliny' rom dhuwaliyin nhokala. Bili bäyŋun balaŋ nhe ŋunhi gänany dhuwaliyi maḻŋ'maranha nhokiyingalnydja nhe guyaŋanhawuyyu. Dhuwaliyiny nhokal warralkuŋal ŋarrakala Bäpay djiwarr'wuyyun. ");
INSERT INTO djr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ga dhuwandja ŋarra nhuna dhu yäku nhirrpandja Betan, ŋunhi ga mayaliy' lakaram guṉḏan. Ga dhipaliyin ŋunhi guṉḏalil ŋarra dhu dhuḻ'yundja ŋarrakuwuy buṉbuny, ŋunhi ŋayi dhu ga djuḻkmaraman dhiŋganhamirriwnydja romgu ganydjarr. ");
INSERT INTO djr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bala ŋarra dhu dhuwal gurrupanna nhokal gonydjiŋdja ŋurukuwuynydja djiwarr'wuywuny romgu. Ga ŋuli nhe dhu ŋunhi dhäruk nhirrpan ḏälkum ŋula nhäpuy dhiyal munatha'ŋurnydja, ŋayiny dhu ga ŋunhi dhärran yan ḏälkunhawuynha yurr ganydjarrmiriw yan, ga ŋayiny dhu ŋunhi ŋunhiyi bili yan dhäruk God-Waŋarryuny Bäpaynydja ḏälkuman yan. Ga ŋuli nhe dhu ŋunhi nhokiyingal nhe dhärukthu ŋula nhä yanan bala dhayaḻakuman, ga ŋayiny dhu ŋunhi God-Waŋarryuny ŋunhalnydja djiwarr'ŋurnydja bitjandhiyi bili dhayaḻakumdhi.” ");
INSERT INTO djr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Bala ŋayi Djesuy waŋanan ŋunhiwurrunhany ŋunhi malthunamirrinhany mala nhanŋuwuy märr walal dhu ŋunhi yakan lakaram wiripuwurruŋgalnydja yolŋuw walalaŋgal, ŋunhi ŋayiny ŋunhiyin yolŋu Maŋutji-dhunupayanhawuynha. ");
INSERT INTO djr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ga beŋuryiny ŋayi gan Djesuy dhäwun lakaraŋal ŋurikiwurruŋdhin malthunamirriwnha mala nhanukalaŋuw ŋunhi nhä nhanŋu dhu maḻŋ'thun. Ga bitjarra ŋayi gan ŋunhi lakaraŋalnydja gam', “Ŋarrany dhu dhuwal marrtjin balan Djurutjalamlila. Ga ŋunhiliyin walal dhu ŋunhi ŋurru-warryunayŋuynydja yolŋuy walal ga ŋurruŋu djirrikaymirriynydja walal, ga ŋunhi Romgu marŋgikunhamirriynydja walal dhä-gir'yundja ŋarrany mirithirra yan. Ga bumany ŋarrany walal dhu ŋunhi murrkay'nha dhiŋganhamaraman yan. Ga ḻurrkun' dhu walu djuḻkthurr bala ŋarrany dhu walŋathin.” ");
INSERT INTO djr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bala ŋayiny Betaynydja waṉan ŋanya ŋayathaŋal Djesunhany bala gali'lila nhirrpar nhanukiyingal ŋayi, bala ŋayi waŋanan ŋanya raypirri'yurra, ŋayi dhu ga yaka bitjandhiyi waŋa. Ga bitjarr ŋayi ŋunhi waŋanany nhanukal, “Garray, yaka nhuna dhu dhuwal God-Waŋarryu bitjandhiyi dhayuŋan dhiŋganharaw.” ");
INSERT INTO djr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ga ŋayiny Djesuny bilyurr nhanukal Betawal bala ŋayi bitjarra nhanŋu waŋan, “Way nhe Djaytin waṉḏi ŋarrakalaŋaŋur. Nheny ga dhuwal guyaŋa bitjan yan bili nhakun ga dhuwal wiripuwurruy guyaŋa, yaka dhuwaliyiny God-Waŋarrwuŋ guyaŋanhawuy.” ");
INSERT INTO djr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bala ŋayi Djesuny waŋanan malthunamirriwnydja mala nhanukalaŋaw bitjarrnha, “Ŋuli dhu balaŋ ŋula yol yolŋu djälthirr ŋarrakuwuynydja yan malthunaraw, ŋayiny dhu meṉgunhamirra ŋanyapinyany ŋayi, bala ŋayi dhu ḻaw'maraman nhanŋuwuy ŋayi dharpa-mälakmaranhawuynydja bala malthunna ŋarrakun. ");
INSERT INTO djr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ga ŋuli nhe gi yaka djälthi dhiŋganharaw, ŋunhiny nhe ga bunhamirra nhunapinyan nhe. Ga ŋuli nhe dhu yan marrtji dhuwalatjandhi ŋunhi dhiŋganhamirriwurr romgurr ŋarrakuny yäkuw, nheny dhu maḻŋ'maraman walŋa wiyinŋuwnydja nhinanharaw. ");
INSERT INTO djr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ŋuli nhe dhu ga ŋunhi ḻuŋ'maram nhä mala nhokiyingal nhe, nhä mak nhe dhu wiripuny dhuwanna wäŋanhan ŋarakanhan märram, bala nhe ga ŋunhiyiny nhakun bunhamirra nhunapinya nhe, ga nhän nhe dhu ŋunhi märramany ŋurukuwuyyiny. Nhän balaŋ nhe ŋunhi gurrupulnydja walŋawnydja nhokalaŋaw roŋanmaranharaw?” ");
INSERT INTO djr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Galkin ŋayi dhu ŋunhi Yolŋuny Gäthu'mirriŋu gumurr-roŋiyirra, ga marrtjiny ŋayi ga ŋunhi ŋuriŋiyin nhanukalaŋuwal Bäpa'mirriŋuwalnha djeŋarrayny'tja, ga bulu rrambaŋin walal ŋunhi djiwarr'wuynha dhäwu-gänhamirra mala, bala walal dhu marrtji gurrupula buku-roŋanmaraŋun waŋga'-waŋganygun yan yolŋu'-yulŋuwnydja ŋunhiŋuwuynha ŋunhi nhä mala walal gan djäma.” ");
INSERT INTO djr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Ga dhuwandja ŋarra ga yuwalk yan lakaramany, wiripuny mala nhuma dhuwalawurr dhärra ga, bäyŋu nhuma dhu boŋguŋ yänayiny dhiŋguŋ, ga bäy ŋathil nhuma dhu boŋguŋ nhäŋu Yolŋuny Gäthu'mirriŋuny ŋayi dhu boŋguŋ yarrupthurr räli djiwarr'wuyyun romdhu.” ");
INSERT INTO djr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ga 6 walu djuḻkthurr, bala ŋayi Djesuynydja garr'yurra nhanŋuwuy ŋayi ḻundu'mirriŋunhany mala nhanŋuwuy ḻurrkun'nhany Betanhany ga Djayimnhany ga Djonnhany, bala ŋayi walalany maŋutji-warryurra balan bitjarra garrwarlila bukulila. ");
INSERT INTO djr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ga ŋunhalnydja ŋunhi bukuŋurnydja bala ŋayi Djesuny wiripuŋuyirra dhika latju'yirra maŋutjiŋurnydja walalaŋgal. Ga girriny' nhanŋu ŋunhi bitjarryi bili miḻŋ'miḻŋdhurryi wiripuŋuyinan dhika watharrthinan mirithinan. ");
INSERT INTO djr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ga balanyamirriyyi bili yan bala maṉḏany ŋunhi märrmany' yolŋu maṉḏa Yilaydjany ga Mawtjitjtja maḻŋ'thurra ŋunhiliyiny walalaŋgal, bala maṉḏa gan ŋunhi waŋanan nhanukala Djesuwalnha. ");
INSERT INTO djr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ga ŋayiny Betany waŋan Djesuwalnydja bitjarra, “Way Garray! Manymaknha dhuwaliyiny, ŋunhi napurrnydja nhakun dhuwal dhiyal dhiyaŋ bala. Ŋula balaŋ muka napurr dhu djäma nhumalaŋ ḻurrkun' warraw', waŋganydja nhakun nhuŋuwuy, ga waŋganydja Mawtjitjku, ga waŋganydja Yilaydjaw.” ");
INSERT INTO djr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ga ŋunhi ŋayi gan Betany baḏak yan waŋan, bala ŋayiny dhunupan maŋannha maḻŋ'thurr watharrnha dhika mirithirra, bala marrtjin dhurrthurryurra walalany. Ga beŋuryiny ŋunhi maŋanŋurnydja rirrakaynydja gan dhawaṯthurr, waŋanany bitjarrnha, “Dhuwaliyin ŋunhi ŋarrakuwuynydja Gäthu'mirriŋu, marrkapmirrnydja. Buthuru-bitjurra walal nhanŋu manymakkuŋun.” ");
INSERT INTO djr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ga ŋunhi walal nhanukal malthunamirriynydja mala ŋäkulnydja rirrakaynydja bala yan walal mirithinan dhika ŋoy-gärrinany, bala walal galkirrinan munatha'lila. ");
INSERT INTO djr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ga ŋayiny Djesuny marrtjin bala ŋayi ŋayathaŋala walalany ga waŋan ŋayi walalaŋ bitjarr, “Rur'yurra walal, yakan walal barrari!” ");
INSERT INTO djr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ga ŋunhi walal ḏawa'-ḏawayurrnydja nhäŋalnydja ŋanyapinyan Djesunhan, ŋayipin gan dhärranany ŋunhiliyiny walalaŋgalnydja. ");
INSERT INTO djr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ga ŋunhi walal marrtjin bala wäŋgaŋalnydja yarru'-yarrupthurrnydja roŋiyinany beŋurnydja ŋunhi bukuŋurnydja, bala ŋayiny Djesuynydja waŋanan walalany mirithinan yan bitjarra, “Yaka yan nhuma dhu lakaramany ŋula yolkalnydja yolŋuwal ŋunhi nhä mala nhuma gan nhäŋal, ga bäy ŋayi dhu boŋguŋ Yolŋu Gäthu'mirriŋu walŋathi dhiŋganhaŋur.” ");
INSERT INTO djr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bala walal ŋanya ŋunhi malthunamirriynydja mala nhanukal Djesuwal dhä-birrka'yurra ŋanya bitjarra, “Nhaku walal ŋuli ga ŋunhi Rom-marŋgikunhamirriynydja mala yolŋuy walal bitjandja lakaram, ‘Yilaydja ŋathil dhu ŋurruŋuny buni.’” ");
INSERT INTO djr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarr, “Yuwalk walal gan ŋunhi bitjarryiny lakaraŋal ŋunhi ŋayiny Yilaydjany dhu ŋurruŋu buna, bala wäŋa-ḻerr'yunna. ");
INSERT INTO djr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yuwalk yan ŋarra dhu nhumalaŋ dhuwal lakaramany. Bili muka ŋayiny ŋunhiyiny yolŋu Yilaydjany bunan, ga walalnydja yolŋuynydja walal yaka warray ŋanya dharaŋana, baku-ŋayathaŋal walalnydja nhanŋu burrpu'thin warray. Ga bitjandhi bili walal dhu ŋunhi Yolŋuwnydja Gäthu'mirriŋuw burrpu'yirr ga nyalmiriyirr.” ");
INSERT INTO djr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Bala walal yorrnha ŋunhi malthunamirriynydja mala nhanukal dharaŋar, ŋunhi ŋayi gan Djesuynydja lakaraŋal ŋanyanhan Djonnhan ŋunhi ḻiya-ḻupmaranhamirrinhan yolŋuny. ");
INSERT INTO djr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Manymak, wäŋgaŋala walal marrtjin bala-a-a, Djesu ga ŋunhiwurryi ḻundu'mirriŋu mala nhanŋu ḻurrkun' yarru'-yarrupthurra balan wiripuwurruŋgala yolŋu'-yulŋuwal. Ga ŋayiny waŋgany ḏirramu ŋunhiliyi malaŋur marrtjin bala bun'kumu-djipthurra nhanukal, ");
INSERT INTO djr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","bala ŋayi yan bitjarra waŋanany nhanŋu, “Garray, wuyurr ŋarrakalaŋaw gäthu'mirriŋuw, bili ŋayi ga dhuwal rerri ŋayatham marrmarryunamirr. Wiripuny ŋayi ŋuli dhuwal marrtji bala gurthalila ŋurrkanhamirr ga wiripuny ŋayi ŋuli marrtji, bala gapulila yan ḻupthun. ");
INSERT INTO djr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ga waŋan ŋarra gan dhuwal malthunamirriny mala nhuŋu, yurr walalnydja yaka warray ŋanya ḏukmaranha.” ");
INSERT INTO djr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Bala ŋayi Djesuny waŋanan bitjarra, “Nhä nhuma dhuwal yolŋuny walal? … märr-yuwalkthinyamiriw mala ga djarrpi'mirr mala? Nhämunha'mirra ŋarra nhumalaŋgal dhu buluny nhina? Go rälin ŋanya gäŋu dhuwaliyiny yothunhany.” ");
INSERT INTO djr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bala yan ŋayiny Djesuny waŋanan ŋurikiyiny ŋunhi wakinŋuwnydja birrimbirr dhawaṯmaraŋal ŋanya ŋayi beŋuryiny ŋunhi yothuwalnydja, ga dhunupan yan ŋunhi yothuny ḏukthurra, ŋuriŋi bili yan waluynydja. ");
INSERT INTO djr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bala walalnydja ŋunhi malthunamirriynydja mala nhanukal Djesuwal dhä-birrka'yurra ŋanya bitjarrnha, yurr gänan yan walalawuynha ŋapa. “Wäy nhaku ŋunhi ŋanapurrnydja yaka ŋanya dhawaṯmaranha ŋunhiyi wakinŋuny birrimbirrnha, ga nhaku ŋayi yakany dhawaṯthunna, ŋunhi napurr ŋanya gan ŋaŋ'ŋaŋ'thurrnydja ŋunhiyiny birrimbirrnha?” ");
INSERT INTO djr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ga ŋayiny Djesuny waŋan walalaŋ buku-bakmaraŋal bitjarra, “Bili märr-nhirrpanminyawuynydja nhumalaŋ dhuwaliyi nyumukuṉiny' yan. Yurr ŋarra dhu nhumalany dhuwanna dhawu'-nhirrpandja gam' Ŋuli nhe ga märr-nhirrpanminyawuy ŋayatham ŋunhi yutjuwaḻany mirithirrnydja, balanyany nhakun ŋunhi nyumukuṉiny' genydja' maŋutji, nheny balaŋ waŋi dhuwal bukuny dhathar'yunaraw ŋunhawal bala, ŋayiny balaŋ ŋunhi djäman yan biyakiyi. Ga bäyŋun nhuŋu dhu ŋunhi gumurr-ḏälthirrnydja.” ");
INSERT INTO djr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ga beŋuryiny bala ŋayi Djesuynydja ga malthunamirriynydja mala nhanukal ganarrthaŋala ŋunhiyiny wäŋa, bala walal marrtjinany gan ŋulatjarryin Galaliwurra wäŋakurrnydja. ");
INSERT INTO djr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ga bitjarra ŋayi gan ŋunhi walalaŋgal Djesuy lakaraŋalnydja gam', “Yolŋunhany Gäthu'mirriŋuny walal dhu dhuwal galkin goŋ-gurrupanna yolŋu'-yulŋuwala mala, walal dhu buman ŋanya murrkay'kuman. Yurr dhurrwaraŋur ŋunhi ḻurrkun' dhu walu djuḻkthurr bala ŋayi dhu buluyi walŋathi rakunyŋurnydja.” Ga ŋuriŋiyiny ŋunhi dhäwuy walalnydja ŋunhi malthunamirrnydja mala nhanŋu bukmaknha yan galŋa-miḏikinany. ");
INSERT INTO djr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ga ŋunhi walal Djesu ga malthunamirrnydja mala nhanŋu bunanany ŋunhalnydja ŋunhi Gapuniyamdja wäŋaŋur, bala ŋunhi rrupiya-märranhamirrnydja yolŋu walal ŋunhi gapmanguny beŋur Buku-ŋal'yunamirriŋurnydja buṉbuŋur marrtjinan, bala walal dhä-birrka'yurra Betanhan bitjarra, “Way, muka ŋunha marŋgikunhamirriy nhumalaŋgal ŋuli ga ŋula bäyim rrupiya gapmannha ŋurukuwuynydja ŋunhi buku-ŋal'yunamirriwuynydja buṉbupuy?” ");
INSERT INTO djr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ga ŋayiny Betany buku-bakmaraŋal bitjarr, “Ŋe, gurrupan ŋayi ŋuli ga rrupiya ŋurikiyi.” Ga ŋayiny Djesuny marrtjin balayi nhanukal Betawal, bala ŋayi dhä-birrka'yurra ŋanya bitjarrnha, “Djäyman, nhaltjan nhe ga ŋula guyaŋany? Nhaltjan walal ŋuli ga ŋunhi buŋgawaynydja mala dhiyakuwuyyuny munatha'wuyyuny mala märram rrupiya walalaŋgiyingalaŋuwalnydja yolŋuwal walalaŋgal, wo mulkuruwal yan yolŋuwal walalaŋgal?” ");
INSERT INTO djr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ga ŋayiny Betany nhanŋu buku-bakmaraŋal bitjarr, “Mulkuruy yan yolŋuy walal ŋuli ga bäyim ŋunhiŋuwuyyiny wäŋapuy.” Bala ŋayiny ŋunhi Djesuny buku-bakmaraŋala nhanŋuny bitjarra gam', “Ga nhän ŋunhi walalaŋguwuynydja yolŋu'-yulŋu ga nhina baḻanydjarratjarran muka, warwumiriwnha? ");
INSERT INTO djr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Yurr yaka ŋanapurr dhuwal djäl napurr dhu ga mari-bunany nhumalaŋ. Ga gatjuy marrtjin ŋurrkuŋun nhuŋuwuy rakiny' ŋunhawalnha guḻunlila gapulila, ga ŋarirrin räkuŋ. Ga ḻapmaram nhe dhu ŋanya dhurrwara bala nhe dhu ŋunhi maḻŋ'maraman rrupiyan, bala nhe dhu bäkin ŋunhiyiny rrupiyany märr nhe dhu bäyimnha walalany nhuŋuwuy ga ŋarraku.” ");
INSERT INTO djr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ga balanyamirriy bili yan bala walalnydja ŋunhi malthunamirriynydja mala nhanukal Djesuwal dhä-birrka'yurra ŋanya, yol boŋguŋ ŋunhi buŋgawayi ŋunhal God-Waŋarrwal yirralkaŋur. ");
INSERT INTO djr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bala ŋayi Djesuny gawaw'yurra yothuwnha ga nhirrparnydja ŋayi ŋanya galkin yanan nhanukiyingala ŋayi. ");
INSERT INTO djr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Bala ŋayi yan waŋanan bitjarra, “Dhuwandja ŋarra nhumalaŋ dhu yuwalknha yan lakaram. Ŋuli nhuma dhu ŋunhi yakany bilyun ga bitjandja nhina nhakun dhuwal yothuny, nhumany dhu ŋunhi bäyŋun yan gärri balany ŋunhi God-Waŋarrwalnydja yirralkalil. ");
INSERT INTO djr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yurr ŋuli nhuma dhu ga ŋunhi nyilŋ'maranhamirrnydja nhumalanhawuynha nhuma nhakun dhuwal yothu, ŋunhiny nhuma ŋurruŋun mirithirra ŋunhalnydja God-Waŋarrwalnydja yirralkaŋur. ");
INSERT INTO djr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ga ŋuli nhe dhu ŋunhi gumurr-ŋamathirr balanyarawnydja nhakun dhiyak yothuw ŋarrakalnydja yäkuy, ŋunhiyiny nhe ŋarrakun gumurr-ŋamathin.” ");
INSERT INTO djr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Yätjkurra dhu ŋunhi mirithirra yan maḻŋ'thurr ŋurikiyiny yolŋuw ŋunhi ŋayi dhu bilmaram ŋula waŋganynhany yothuny ŋarrakalaŋumirriny bala ŋunhi yätjkurrulil romlil. Manymaktja ŋunhi balanyarawyiny mala yolŋu'-yulŋuw ŋoy-burrpuwny'tja, walalany dhu yan mayaŋnha garrwi'yun rakiy'nha guṉḏamirriyaman, bala yan ŋurrkaman balan dhulmulila gapulila. ");
INSERT INTO djr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dhuwandja wäŋa munathany' dhu mariŋura, bili ŋayi ŋuli ga yolŋuny walalany waṉa-gäma yätjkurrulil dhukarrlil. Ga ŋorra ŋayi ga dhuwaliyi balanyayiny rom mala yätjkurrnydja, bitjan bili, ga mel-warryun ga bala dhuwurr-yätjlil. Yurr ŋunhi ŋayi dhu ga ŋula yolthu yolŋuy bitjandhiny djäma, ŋayiny dhu ŋuriŋiyiny yolŋuy märraŋ yindin yan mirithirra mari.” ");
INSERT INTO djr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Yo, ŋuli ŋayi nhuna goŋdhu nhokal nhä mak ḻukuy nhokal gäŋal nhuna bala yätjkurrulilnydja romlil, nheny yanan gulkmaranhamirra nhunapinya nhe goŋdja ga ḻukuny bala yan ŋurrkuŋun, bili manymaktja ŋunhi nhuŋu, nhe dhu balany ŋunhi gärri walŋamirrililnydja wäŋalil, bundhurrnha ga gaṉuŋnha, yakan goŋmirrnydja ga ḻukumirrnydja. Märr nhunanhany dhu ŋunhi yakan ŋurrkuŋ balany ŋunhi gurthalilnydja, ŋunhi ŋuli bäyŋun yaŋara'-dhawar'yurr.” ");
INSERT INTO djr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Ga ŋuli nhokal waŋganydhu maŋutjiy nhuna bilmaraŋal yätjkurrulil, nheny yanan ŋunhiyiny melnydja nhunupinya nhe waŋganydja wilaŋ'thunmirra bala yan ŋurrkuŋun. Bili ŋunhiny nhuŋu manymaknha, ŋuli nhe dhu ŋunhi waŋganymirrnydja yan melmirr gärri ŋunhawalnydja ŋunhi walŋamirrililnydja wäŋalil, yakan märrmayny'tja melyu, nhuna balaŋ ŋunhiyiny balan ŋurrkuŋ, dhä-gir'yunamirrilila wäŋalil.” ");
INSERT INTO djr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ga bulu ŋayi Djesu bitjarr waŋan, “Yaka walal ŋula wakinŋu-ŋupul dhuwalawurrunhany djamarrkuḻiny ŋini! Bili walal ga ŋunha djägaŋurnydja nhina ŋurukurruŋgala ŋunhi God-Waŋarrwala dhäwu-gänhamirriwalnydja malaŋuwal, ŋunhi walal ŋuli ga nhinan dhunukuŋura ŋarrakalaŋuwala Bäpa'mirriŋuwal ŋunhala djiwarr'ŋura.” ");
INSERT INTO djr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Yo, ŋarra dhu ŋäŋ'thun nhumalany dhuwal gam', nhalayakun balaŋ nhuma ŋunhi, ŋunhi balaŋ nhuma gi ŋayathul 100-dja bimbi mala, ga ŋunhi balaŋ ŋula waŋganydja bimbi winya'yurr? Ŋula balaŋ nheny muka ganarrthul ŋunhiyiny ŋunhi 99-dja bimbi mala ŋunhili bukuŋur, bala nhe balaŋ yan marrtjin ḻarruŋun ŋurikiyin waŋganygun winya'yunawuywun bimbiw?” ");
INSERT INTO djr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“Yo, ŋunhi nhe dhu maḻŋ'maramany ŋunhiyiny waŋganynhany bimbiny winya'yunawuynhany, bala nhe balaŋ ŋunhi mirithin yan dhika galŋa-djulŋithiny ŋurikiyiny waŋganyguny bimbiw, bulun ga djuḻkmaram ŋunhi 99-guny bimbiw mala, ŋunhi walal bäyŋu winya'yurr. ");
INSERT INTO djr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ga balanyayi bili nhumalaŋ ŋunha Djiwarr'puynydja Bäpa'mirriŋu. Yaka yan ŋayi djäl nhuma dhu nhanŋuny djamarrkuḻi' winya'yun nhanukalaŋaŋurnydja goŋŋur.” ");
INSERT INTO djr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ŋuli ŋayi dhu ŋula waŋganydhu yolŋuy malthunamirriy ŋarrakal, ŋayaŋu-miḏikuman nhuna, nheny marrtji balayi guwatjmul ŋanya ga nhina nhanukal ga maḻŋ'maraŋ nhanukal, nhä ŋunhi nhanukal miḏikin. Yurr nhumapi ŋathil ŋurruŋuny waŋanhamirr maṉḏa gayul. Ga ŋuli ŋayi dhu nhuŋu buthuru-bitjundja, ŋunhiny nhakun nhe ŋanya märraŋala ŋayaŋu-roŋanmaraŋala, nhuŋu wäwa'mirriŋunhany ŋunhi Garraywalaŋumirrinhany. ");
INSERT INTO djr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yurr ŋunhi ŋayi dhu yakany nhuŋu buthuru-bitjun, nheny marrtjin ga garr'yurra wiripuwurrunhan yolŋuny walalany. Bili ŋunha ga Dhuyuŋurnydja Djorra'ŋur ga lakaram bukmak yan, ŋuli nhe dhu ŋunhi nyamir'yun wiripuŋunhany yolŋuny. Bala beŋuryiny ŋayiny dhu ŋunhi ŋuriŋiyiny yolŋuy garr'yun bulu waŋganynha yolŋuny, wo ŋula nhämunhany, märr walal dhu bukmakthun yan ŋanya dhäruktja ŋäma waŋanhawuynydja. ");
INSERT INTO djr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ga ŋuli ŋayi dhu ŋunhi yakany buthuru-bitjun ŋurikiwurruŋguny ŋunhi bukmakkuny yolŋuw walalaŋ, nheny balan gäŋu ŋunhiyiny gämurru', ŋunhi bukmakkalnha yan Garraywalaŋumirriwalnha yolŋu'-yulŋuwal walalaŋgal. Ga ŋuli ŋayi dhu ŋunhi ŋula yolthu yolŋuy märr-yuḻkthundja ga ŋunhi Garraywalaŋumirrinhany mala, bala nhumany dhu ŋunhinhany yolŋuny bitjanna nhäma nhakun ŋayi Djan'tayilnha yolŋu, wo rrupiya-märranhmirra yolŋu gapmangun mala.” ");
INSERT INTO djr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Dhuwandja ŋarra nhumalaŋ ga märr-yuwalknha yan lakaram. Ŋuli nhuma dhu ŋunhi ŋula nhaku malaŋuw yoranhamirr dhiyalnydja munatha'ŋurnydja wäŋaŋur, ŋayiny dhu ŋunhi God-Waŋarrnydja bitjandhi bili yan yoramdhi ŋunhalnydja djiwarr'ŋurnydja. Ga ŋuli nhuma dhu ŋunhi yakany dhayuŋanmirr dhiyal munatha'ŋur, ŋayiny dhu ŋunhi bitjandhi bili yan yakayi dhayuŋan ŋunhal djiwarr'ŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ga märr-yuwalk, ŋarra ga nhumalaŋ dhuwal lakaramany, ŋuli nhuma dhu ŋunhi märrma' yolŋu maṉḏa Garraywalaŋumirr maṉḏa yoranhamirrnydja ŋula nhakuny malaŋuw, ga ŋuli maṉḏa dhu ŋunhi ŋäŋ'thundja bukumirriyamany, ŋayiny dhu ŋunhi ŋarrakalnydja Bäpa'mirriŋuy djiwarr'puyyuny djäman bala yan nhumalaŋguny. ");
INSERT INTO djr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ga ŋuli nhuma dhu ŋunhi waŋgany-manapanmirrnydja ŋarrakalnydja yäkuy, ŋarrany dhu ŋunhiliyin nhumalaŋgalnha.” ");
INSERT INTO djr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bala ŋayi yan Betany marrtjinan Djesuwalnha bala ŋayi ŋanya dhä-birrka'yurra bitjarra, “Nhämunhamirr ŋarra dhu dhika yuwalktja bäy-lakaram ŋula yolkuny yolŋuw, ŋuli ŋayi dhu ŋarrany ŋayaŋu-miḏikumandja? Muka gana' ŋunhi ŋarra dhu 7-mirrnydja yan bäy-lakaram nhanŋu?” ");
INSERT INTO djr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ga ŋayiny Djesuny bitjarr buku-bakmaraŋal nhanŋu, “Yaka yan nhe dhu 7-mirrnydja bäy-lakaram nhanŋu, ŋany ŋula nhämunhamirra yan dharrwamirra mirithirra!” ");
INSERT INTO djr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Yo, Dhiyaŋuny dhäwuy nhunany dhu guŋga'yun nhäthinya ŋunhi God-Waŋarrwu Djiwarr'puy Rom. Yo! Ga ŋunhili gan nhinan waŋgany Buŋgawa Ŋurruḏawalaŋu wäŋaŋur. Ga waŋganymirrnydja waluy bala ŋayi wäthurra djämamirriwnha mala nhanukalaŋaw, märr walal dhu buku-roŋanmaraman nhanŋu ŋunhiyi bili yan rrupiya ŋunhi nhämunha nhanukal goŋŋur walal ŋäthil märraŋal. Bala ŋayi yan wäthurra walalaŋ waŋga'-waŋganygun. ");
INSERT INTO djr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Manymak ga ŋunhi ŋayi marrtjin dhä-birrka'yurrnydja walalany. Bala walal waŋganynhany djämamirriny gärrinyamaraŋala, ŋunhi ŋayi ga gan dhukarrarrayurr ŋanya dharrwan dhika mirithirra rrupiya mala 50,000,000-nha. ");
INSERT INTO djr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Yurr bäyŋun ŋayi gan ŋunhi balanyamirriyiny ŋula rrupiyany ŋayathaŋal buku-roŋanmaranharawnydja. Bala ŋayiny ŋunhi yan buŋgawany waŋanan djalimgun ŋurikiyiny ḏirramuwnydja ga miyalkkuny nhanukalaŋaw ga djamarrkuḻiwny'tja nhanukalaŋaw, ga bukmak yan nhä malany ŋayi gan dhukarrarrayurr, märr ŋayi dhu ŋunhi yaŋara'-bakmaraman ŋunhiyin rakunynhan rrupiyany. ");
INSERT INTO djr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bala ŋayiny ŋunhiyiny djämamirrnydja yolŋu ŋurrkanhamirra ŋurikalyiny buŋgawawalnydja gumurrlila, bala gan waŋanan dhä-wurrupuruŋala, ‘Buku-djulŋi ŋathil wuyurr ŋarraku, ŋarra nhuŋu dhu ŋunhi buku-roŋanmaraŋuny bukmak yan rrupiyany malany, ŋunhi ŋarra nhuna dhukarrarrayurr!’” ");
INSERT INTO djr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","“Bala ŋayiny ŋunhi buŋgawany nhanŋu mirithirra yan wuyundja ga bäy-lakaramany nhanŋu ŋayi bukmakpuynha yan ŋunhiŋuwuyyiny malaŋuwuy, bala yan ŋayi ŋanya djuy'yurrnydja ŋayaŋuynydja-manymakthun, ga waŋan ŋayi ŋanya ŋayi dhu yakan ŋunhiyiny rrupiyany buku-roŋanmaram.” ");
INSERT INTO djr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ga ŋunhi ŋayi marrtjin ŋunhiyi djämamirr dhawaṯthurrnydja, bala maṉḏa gumurr-bunanhaminan wiripun yolŋu djämamirr, ŋunhi maṉḏa ŋäthil bitjarryi dhukarrarrayunmin. Bala ŋayi yan dhunupan ŋanya mayaŋnha ŋayathaŋal, baṯ-bitjandhi galki balaŋ ŋayi ŋunhi wiripuny ḏirramu ŋoy-wulkthuna muka, ga bitjanna ŋayi nhanŋu ŋunhi waŋany gam', ‘Dhuwandja nhe dhu ŋarraku buku-roŋanmaraŋ yan ŋunhiyiny ŋunhi 100-dja ŋaraka rrupiya, ŋunhi nhe ŋarrany dhukarrarrayurra!’” ");
INSERT INTO djr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Bala ŋayi ŋunhi wiripuny yolŋu djämamirr gumurrlila ŋurrkanhamirr nhanukal bala waŋan bitjarra dhä-wurrupuruman, ‘Buku-djulŋi, bulnha ŋathil ŋarrany galkurr, ŋarra boŋguŋ nhuŋu rrupiya ŋunhi buku-roŋanmaraŋ,’ bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yurr ŋayiny ŋunhiyiny ŋurruŋuny djämamirr, bäyŋun ŋayaŋu-wuyuna nhanŋuny ŋurikiyiny wiripuŋuwnydja djämamirriw. Ŋany yanan ŋayi ŋanya galkanna dharruŋgulila, ga bäy ŋayipi-i-i ga buku-roŋanmaraŋal yan ŋayi nhanŋu ŋunhiyi rrupiya.” ");
INSERT INTO djr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ga ŋunhi walal wiripuwurruynydja djämamirriy walal ŋäkul nhä ŋunhi maḻŋ'thurr, bala walal yan wuyurra dhika ŋurikiyiny wiripuŋuwnydja yolŋuw djämamirriw ŋunhi ŋayi gan gulŋiyin dharruŋguŋur. Bala walal yan lakaraŋala buŋgawawalnha. ");
INSERT INTO djr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ga ŋayiny ŋunhi buŋgawany wäthurra ŋurikiyiny ŋunhi ŋurruŋuwnydja djämamirriw, bala waŋan bitjarra, ‘Nheny dhuwal dhuwurr-yätj yolŋu. Nheny marrtjin ŋarranhany dhä-gurrupuruŋuyaŋal waŋan, ga ŋarrany nhuŋuny wuyurr warray, ŋurikiwuyyiny ŋunhi dhaŋaŋbuynydja rrupiyawuy, ga bäyŋun nhe ŋunhi ŋarranhany gurrupana buku-roŋanmaranha ŋula waŋganydja yan nyumukuṉiny'tja rrupiya. ");
INSERT INTO djr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ga nheny muka balaŋ dhuwal bitjanayi bili ŋunhi wiripuŋuwnydja yolŋuw ŋayaŋu-wuyuna muka, nhämirr ŋarrany nhuŋuny ŋayaŋu-wuyurr?’ ");
INSERT INTO djr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Bala ŋayi ŋunhi buŋgawany mirithirra yan maḏakarritjthirrnydja nhanŋu bala yan ŋayi dhäruk-gurrupara djämamirriwalnha, ŋanya walal dhu dhä-gir'yundja mirithirra yan dhika dhaŋga-ḏirryunna manapan, ŋunhilin dharruŋguŋura, ga bäy ŋayipi-i-i, ga bukmak yan ŋayi dhu roŋanmaram ŋunhi nhämunha' ŋayi dhukarrarrayurr. ");
INSERT INTO djr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ga biyakiyin dhu boŋguŋ ŋunhi ŋarrakalnydja Bäpa'mirriŋuy djiwarr'puyyuny milkuŋ balanyayin rom ḏälnha yan mirithirra, bawalamirriwydja yolŋuw walalaŋ, ŋunhi ŋayi dhu yakany nhakun bäy-lakaram wiripuŋuwnydja yolŋuw ŋunha gal'ŋu ŋayaŋuynydja nhanukiyingal ŋayi.” ");
INSERT INTO djr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ga beŋuryiny dhurrwaraŋur ŋayi Djesuy ganarrthaŋala ŋunhiyiny wäŋa Galaliny, bala ŋayi marrtjinan Djudiyalila makarrlil wäŋalil, ga buḏapthurr ŋayi Djodangu mayaŋ'ku. ");
INSERT INTO djr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ga dharrwan marrtjin ŋunhi yolŋuny walal ḻuŋ'thurr nhanukal, bala ŋayi gan ŋunhi ḏukmaraŋala rerrimirrinhany yolŋuny walalany. ");
INSERT INTO djr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ga walal ŋunhi Baratjiny mala yolŋu'-yulŋu marrtjindhi nhanukal Djesuwal, bala walal ŋanya gan dhä-birrka'yurra, yan nhakun gan mayali'-gäŋal ŋanya, ga bitjarr walal ŋanya ŋunhi dhä-birrka'yurrnydja gam', “Way, nhaltjan ga ŋunhi romdhuny limurruŋgal lakaram? Muka dhunupa ŋunhi yolŋuw ŋayi dhu ganan nhanŋuwuy ŋayi miyalknha, bala yan djuy'yunna ŋanya?” ");
INSERT INTO djr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Bala ŋayiny Djesuny buku-bakmaraŋal bitjarra, “Muka yaka yan nhuma dhuwal marŋginy ŋunhi ŋayi God-Waŋarryu ŋurruŋuny ŋamaŋamayurr ḏirramuny ga miyalknha ŋunhalnydja ŋunhi ŋurruyirr'yunamirriynydja waluy? ");
INSERT INTO djr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ga dhiyakun ŋunhi märrwuny ŋayi dhu ŋunhi ḏirramuynydja ganarrthaman nhanŋuwuy ŋayi ŋäṉḏi'mirriŋunhany ga bäpa'mirriŋunhany, bala maṉḏa dhu waŋgany-manapanmirra miyalknha nhanŋu. Ga ŋunhi ŋayi ŋuli märramany miyalknhany ŋunhiny maṉḏa bäyŋun buluny barrkuwatj waŋganynha maṉḏa rumbal. ");
INSERT INTO djr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ga bäyŋun dhu ŋunhi ŋula yolthuny yolŋuy maṉḏany buluny nhakun barrkuwatjkum, bili God-Waŋarryun ŋunhi ŋayipin waŋgany-manaparnydja maṉḏany.” ");
INSERT INTO djr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ga walalnydja bulu ŋanya Djesuny dhä-birrka'yurr bitjarr, “Nhaku ŋayi ŋunhi Mawtjitjthu rom-rulwaŋdhurr bitjarrnydja gam', Manymak warray ŋayi dhu ŋunhi dhuway'mirriŋuy miyalknhany nhanŋuwuy ŋayi djuy'yun, yurr ŋayi dhu ŋurruŋuny djorra' ŋathil wukirri bala goŋ-gurrupanna nhanukal bala yan djuy'yunna ŋanya.” ");
INSERT INTO djr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarr, “Ŋunhiny ŋayiny Mawtjitjthuny bitjarryi nhumalaŋ rom rulwaŋdhurr, bili nhumany dhuwaliyi ŋayaŋu-wuṉḏaŋarrmirr, Yurr beŋur bili yan ŋurruyirr'yunaŋur ŋunhi ŋayi God-Waŋarryu dhuwal munathany' wäŋany ŋamaŋamayurr, bäyŋun nhanukal gan ŋunhi gänaŋ'maranhamirrnydja rom ŋorran ŋayaŋuŋur. ");
INSERT INTO djr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ga dhuwandja ŋarra nhumalaŋ dhu dhuwanna lakaramany gam', Ŋuli ŋayi dhu miyalkthu nhokal yaka djäma ŋula nhä marramba', nheny ḏirramuynydja yakayi ŋanya ganarrthul, märr yanbi nheny dhu ŋunha wiripunhan miyalknha märram, ŋunhiyiny nhe ga bitjandhiny marramban' djäma. Yurr ŋunhi ŋayi dhu nhokal miyalkthu yuwalktja marramba' djäma, nheny ŋanya dhu ŋunhi ḏirramuynydja ganarrthaman, bala yan wiripuŋunhan miyalknha märram, ŋunhiyiny nhe yakan marramba' djäma.” ");
INSERT INTO djr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ga walalnydja ŋunhi malthunamirrnydja mala nhanŋu bitjarra waŋan gam', “Nhä dhuwal ḏälnydja rom way. Mak manymaktja maṉḏa dhu miyalk ga ḏirramu yakan yan märranhamirr.” ");
INSERT INTO djr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarr, “Yaka nhumalaŋ dhuwal bukmakkuny manymak nhinanharaw ḻuniwnydja. Ga balanyayi bili yan miyalkkuny, ŋuli ŋayi dhu ganan nhanŋuwuy ŋayi dhuway'mirriŋunhany ga märram ŋayi dhu ŋunha wiripunhan ḏirramuny, ŋunhiyiny ŋayi ga marramban' djäma. Yurr manymaktja dhuwal nhakun ŋurikiwurruŋgun bili yan yolŋu'-yulŋuw ŋunhi ŋayi God-Waŋarryu ŋayipi gurrupar walalaŋ mundhurr, ḻuniwnydja nhakun nhinanharaw. ");
INSERT INTO djr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yo! Wiripuwurrnydja dhu ga ŋunhi yolŋu walal nhina ḻunin yan, bili walalaŋ ŋunhi rumbalnydja beŋur bili yan ŋunhi walal dhawal-guyaŋan, yakan nhakun manymak märranhaminyaraw. Ga wiripuny walal gan ŋunha wiripuwurruy yolŋu'-yulŋuy miḏikumar rumbal, bala gan ŋunhi ŋuriŋiyin malaŋuy gumurr-ḏälkuŋal walalaŋ märranhaminyarawnydja. Ga wiripuny ŋayi dhu ga ŋunhi ḏirramu nhina ḻunin yan, bili ŋayi dhu ga ŋunhi ḻay-ḻayyundja ŋuriŋiyin bili yan, God-Waŋarrwala djiwarr'puyyun romdhu. Yo, ŋuli ŋayi ga dhuwal dhäruk waŋa nhuŋuny, nheny dhu yanan djämamirriyaman dhuwal dhäruktja. Ga balanya.” ");
INSERT INTO djr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ga beŋuryiny walal yolŋu'-yulŋuy gäŋa'-gaŋal djamarrkuḻi'nhan mala nhanukal Djesuwal, märr ŋayi dhu ga walalaŋgal goŋ-ŋal'yunna ga bukumirriyaman walalaŋ. Ga walalnydja bay ŋunhi malthunamirriynydja mala nhanukal ŋaŋ'ŋaŋ'thurra walalany ḏälyun dhärukthuny. ");
INSERT INTO djr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ga ŋayiny ŋunhi Djesuynydja nhäŋal, bala yan ŋayi maḏakarritjthinan, bala ŋayi waŋan ŋurikiyiny malthunamirriwnydja mala nhanukalaŋaw bitjarrnha, “Go, manymak walal dhu marrtji ŋarrakal, yaka walalany gulmaraŋ. Bili God-Waŋarrwuny ŋunhi rom balanyarawnha nhakun dhiyakurruŋgun gay'yi djamarrkuḻiw'nha.” ");
INSERT INTO djr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Bala ŋayi Djesuny marrtjin goŋ-ŋal'yurra walalaŋgal. Bala yan ŋayi marrtjinan. ");
INSERT INTO djr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Manymak ga ḏirramu ŋunhiliyi bunan Djesuw, yurr ŋayi ŋunhi ḻukunydja', bala ŋayi ŋanya dhä-birrka'yurra bitjarra, “Marŋgikunhamirr nhä dhika ŋarra dhu ŋula manymaktja djäma märr ŋarra dhu walŋa-wiyinŋumirrnydja märram?” ");
INSERT INTO djr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ga ŋayiny Djesuny waŋan nhanŋu balany bitjarra, “Nhaku bili nhe ga dhuwal ŋarranhany dhä-birrka'yun manymakpuynydja? Bäyŋun dhuwal ŋula yol yolŋu manymak; ŋayipin yan dhuwal God-Waŋarrnha manymaktja. Ga ŋuli nhe djäl nhe dhu märram walŋa wiyinŋumirr, nheny ŋathil dhu ga ŋunhi dhäruk-nhirrpanminyawuynydja rom nhanŋu ŋayathaman baṯ-bitjanna.” ");
INSERT INTO djr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ga ŋayiny ŋunhi ḏirramuny waŋan bitjarr, “Nhäthinya bili dhikayiny rom mala?” Ga ŋayiny Djesuny buku-bakmaraŋal nhanŋu bitjarr, “Dhuwal mala ŋunhi romdja gam', Yaka buŋu yolŋuny murrkay'kuŋ, ga yaka marramba'yi ga yaka manaŋi, ga yaka nyäḻyurr lakaraŋ. ");
INSERT INTO djr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Märr-ŋal'yurr gi yan ŋäṉḏi'mirriŋuwnydja nhokalaŋaw ga bäpa'mirriŋuwnydja, ga märryuny gi ḏapmaraŋ nhuŋuwuy nhe miyalknhany. Ga märr-ŋamathin gi wiripuwurruŋguny yolŋuw biyak nhakun nhe ŋuli ga ŋunhi nhuŋuwuynha nhe märr-ŋamathirr.” ");
INSERT INTO djr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bala ŋayiny ŋunhiyiny ḏirramuny waŋan bitjarrnha, “Way Garray dhuwaliyiny ŋunhi rom mala ŋarra gan ŋayathaŋal beŋur bili, ŋunhi ŋarrany yothu yan muka,” ga bitjarr ŋayiny. ");
INSERT INTO djr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ga ŋayiny Djesuny waŋan nhanŋu bitjarra, “Ŋuli nhe yuwalktja djäl manymakkunharawnydja yan nhinanharaw, nheny marrtjin bala ŋula nhäny mala girriny' mala nhuŋuwuy nhe djalimnha ga rrupiyany nhe dhu gurrupan nhuŋuwuy nhe ŋunha ŋurruwuykmirriwnha yolŋuw walalaŋ. Bala ŋayiny dhu God-Waŋarryuny nhuŋuny gurrupan nhä mala bulun dhika manymaknha ŋunhaŋuwuynha djiwarr'puynha. Gatjuy marrtjin, ga djämany nhe dhu bitjandhiyin, bala roŋiyiny, bala malthurra ŋarrakun.” ");
INSERT INTO djr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ga ŋunhi ŋayi ŋuriŋiyi yolŋuy ŋäkulnydja bala yan ŋayi mirithinan dhika ŋurru-yupthurrnydja, bili ŋayi ŋunhi ḻukunydja' mirithirr. ");
INSERT INTO djr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Bala yan ŋayi Djesuny bilyurrnydja, bala ŋayi waŋanan nhanukalaŋaw malthunamirriwnydja mala bitjarra, “Ḏäl dhuwal ḻukunydjawny'tja yolŋuw gulŋiyinyaraw ŋunhawalnydja ŋunhi God-Waŋarrwalnydja Romlil.” ");
INSERT INTO djr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bala walalnydja ŋunhi malthunamirriynydja mala nhanukal ŋäkulnydja ṉirr'yurra dhäruktja ŋanya Djesunhany. Ga bulu ŋayi Djesu waŋan walalaŋgal bitjarr, “Djamarrkuḻi' ŋarraku, yuwalk dhuwal yulŋuny ḏäl yan gärrinyaraw God-Waŋarrwalnydja Romlil. Ŋula muka nhuma ŋuli gamuḻnhany nhäma, ŋayi ŋuli bäpiwalnydja ŋarŋga'lil gärri, wo bäyŋu? Ga bulun gal'ŋu ŋunhi mirithirra gumurr-ḏälnha ḻukunydjawny'tja yolŋuw gulŋiyinyaraw ŋunhawalnydja ŋunhi God-Waŋarrwalnydja Romlil.” ");
INSERT INTO djr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ga walalnydja ŋunhi malthunamirriynydja mala nhanukal ŋäkulnydja ganyim'thurra yan mirithinan, bala walal gan waŋanhaminan bitjanminan, “Yolnha dhika dhu ga walŋany nhina?” ");
INSERT INTO djr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bala ŋayiny Djesuynydja dhunupan yan nhäŋala walalany ga waŋanany ŋayi bitjarra, “Yolŋuynydja dhu ŋunhi bäyŋun bitjandhiyi djäma. Yurr ŋayiny dhu ŋunhi God-Waŋarryuny djäman bala yan.” ");
INSERT INTO djr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ga ŋayiny Betany waŋan buku-bakmaraŋal bitjarr, “Garray napurrnydja ŋunhi ganarrthaŋal nhä mala ŋanapurruŋguwuynydja napurr bukmak yan, bala napurr ŋunhi nhuŋun malthurr. Ga nhän napurrnydja dhu märram?” ");
INSERT INTO djr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Bala ŋayi Djesuny waŋan walalaŋ bitjarra, “Yo yuwalk muka nhuma ŋunhi bitjarryiny djäma, bala yan nhuma gan ŋunhi ŋarrakun malthurrnydja. Ga yalalaŋumirriynha ŋunhalnydja bala yuṯaŋurnydja wäŋaŋur, ŋarrany dhu gi ŋunhi ŋurruŋun nhini buŋgawan, ŋurikiyiny ŋunhi djeŋarra'mirriwnydja romgu. Ga dhuwanna ŋarra nhumalaŋ ga lakaraman yulŋuny. Nhumany dhu boŋguŋ ŋarrakuny malthunamirr walal gi nhini ŋarrakalnha gali'ŋurnydja, ŋurruŋuyin nhuma dhu, ga ŋurruŋuyiny nhuma dhu boŋguŋ ŋunhi mala-djarr'yunarawnha waŋga'-waŋganygun yan barrkuwatjkun malawnydja Yitjuralpuyŋuwnydja yolŋu'-yulŋuw. ");
INSERT INTO djr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","30","Ŋuli ŋayi dhu ŋunhi ŋula yolthu yolŋuy ganandja nhanŋuwuy ŋayi wäŋanhany, ga miyalknhany, ga djamarrkuḻiny' ga yapa'mirriŋuny walalany ga wäwa'mirriŋuny mala, ga bäpa'mirriŋuny ga ŋäṉḏi'mirriŋuny, bala ŋayi dhu malthundja ŋarrakun, nhanŋuny dhu ŋurikiyiny yolŋuw God-Waŋarryuny gurrupan dhiyaŋuny bala dhiyalnydja munatha'ŋurnydja wäŋaŋur, dharrwan dhika mirithirra bulun ga djuḻkmaram, ŋula nhä malany ŋunhi manymak mirithirr. Yo, ga wiripuny walal dhu ŋunhi märraŋ walŋa-wiyinŋumirra. Ga ŋunhiwurrnydja ŋunhi nhuma dhiyaŋ bala ga ŋurruŋu nhina, ga yalalaŋumirriynydja nhuma dhu gi ŋunhi nhini ŋunhalnydja bala dhurputjnha. Ga dharrwa dhuwal mirithirr yolŋu'-yulŋu ŋunhi nhuma ga dhiyaŋ bala nhina dhurputj, yurr yalalaŋumirriy nhumany dhu gi ŋurruŋun nhini.” ");
INSERT INTO djr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Waŋganymirrnydja Djesuy gan dhäwu lakaraŋal mayali'kurr bitjarr gam', “God-Waŋarrwuny dhuwal rom balanya nhakun waŋgany ḏirramu wäŋa-waṯaŋu borum ŋuthanmaranhamirr.” “Waŋganymirrnydja ŋayi ŋunhiyiny ḏirramu marrtjinan munhawumirra, bili ŋayi gan djälthi ŋayi dhu yolŋuny walalany garr'yun balayi djämaw. ");
INSERT INTO djr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Manymak marrtjinany ŋayi gan ŋunhi bala ŋayi nhäŋala yolŋunhany walalany, walal marrtjin dhärra'-dharran djämamiriw mala, bala ŋayi waŋanan walalany bitjarra, ‘Nhämirr nhumany ŋuli dhuwal marrtji ga djäma ŋarrakun ŋunhala. Ga gurrupandja ŋarra nhumalany dhu waŋga'-waŋganynhany barrwaṉ diyin-dula ŋurikiwuyyiny waŋganybuynydja walupuy djämapuy.’ ");
INSERT INTO djr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ga märr ŋayi gaŋga walu ŋal'yurr, ga bulu ŋayi ŋuriŋiyi ḏirramuy nhäŋal wiripuwurrunhany muka yolŋuny walalany walal gan dhärra'-dharran djämamiriw mala. Ga waŋan ŋayi walalany garr'yurr balayi djämalil nhanukiyingal wäŋalil, ");
INSERT INTO djr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ga dhäwu-nhirrpar ŋayi walalany rrupiyaw gurrupanaraw. ");
INSERT INTO djr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ga yuwalkthi walalnydja wäŋgaŋala balayin.” “Ga bulu ŋayi ŋunhiyi ḏirramu marrtjin ḻäy-bilyunaraynha, ga bitjarryi bili yan garr'yurr wiripuwurrunhany muka yolŋuny walalany, ga waŋan ŋayi walalany dhawu'-nhirrpar rrupiyaw gurrupanaraw. ");
INSERT INTO djr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ga buluny ŋayi marrtjin ŋuruŋun bäyipthun waluy balayi bili wäŋalil, ga bitjarrnydja dharr-nhäŋal wiripuwurrunhany muka yolŋuny walalany, walal gan dhärra'-dharran. Ga waŋan ŋayi walalany bitjarr, ‘Nhaku nhumany ga dhuwal wirwiryundja dhuwalatjandja djämamiriwnydja.’ ");
INSERT INTO djr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ga walalnydja nhanŋu buku-bakmaraŋal bitjarr, ‘Bili bäyŋu napurruny ŋula yolthu yolŋuy waŋanha djämaw.’ Bala ŋayiny walalany ŋuriŋiyiny ḏirramuynydja garr'yurra balayin nhanukiyingala wäŋalil djämawnha.” ");
INSERT INTO djr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Manymak djämany walal gan ŋunhi bukmakthun ŋuriŋiyiny mala, ga yan bili-i-i ga walu-gärrinyaraynha, bala ŋayi ŋunhi wäŋa-waṯaŋuny ḏirramu wäthurra waŋganygun djägamirriwnha yolŋuw. Bala ŋayi waŋanan nhanukal bitjarra, ‘Ŋay'yi dhuwanna rrupiyany, Gatjuy wäthurra walalaŋ ŋurikiwurruŋguny djämamirriwnydja mala, bala gurrupula buku-roŋanmaraŋun walalaŋ djämapuynydja. Ŋurruŋuny nhe dhu gurrupan ŋurikiwurruŋ ŋunhi walal dhä-dhuḏitj ŋurruyirr'yurr djäma. Ga biyakiyin marrtji bala-a-a ga ŋunha wapthurr ŋurikiwurruŋgal ŋunhi ŋarra walalany ŋurruŋu garr'yurr räli munhawumirr.’ ");
INSERT INTO djr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Bala yan ŋayi ŋunhi djägamirrnydja ḏirramu wäthurra ŋunhi djämamirriwnydja mala, bala yan marrtjin walalany rrupiyany gurru'-gurrupara waŋga'-waŋganygu diyin-dula yan mala barrwaṉ'.” ");
INSERT INTO djr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","“Manymak. Ga walalnydja ŋunhi ŋurru'-ŋurruŋuynydja djämamirriy walal guyaŋan yanbi balaŋ walalanhany gurrupana märr yindin rrupiya ŋurikiwurruŋgalnydja ŋunhi walal dhä-gandarrkurr ga dhuḏi'-dhuḏiŋuy djäma. Ga ŋunhi walal nhäŋalnydja balanya warray bili nhakun ŋunhi wiripuwurruy gan djämamirriy walal märraŋal, ");
INSERT INTO djr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ga ŋaramurryinany walal ŋunhi mirithinan yan dhika bala walal gan ŋanya gupa-waŋanan, ga lakaraŋalnydja walal ŋunhi nhanukala ŋurikalyin wäŋa-waṯaŋuwalnha yolŋuwalnydja. ");
INSERT INTO djr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ga bitjarra walal gan ŋunhi waŋanany, ‘Way buŋgawa, walalnydja ŋunhi dhiyaŋurruynydja gay'yi yolŋuy walal djäma märr-dhumbuḻ yan walu, nyumukuṉiny' dhu walal waluy ŋurruyirr'yurr, ga napurrnydja gan dhuwal djäma beŋur bili yan munhawumirriŋur, dhärran gan djäma walu ŋupar ga muk munhawuyin. Ga nhaku nhe walalany dhuwal balanyany bili rrupiya gurrupar nhakun dhuwal napurruŋguny?’” ");
INSERT INTO djr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Bala ŋayi ŋunhi wäŋa-waṯaŋuny buku-bakmaram bitjanna, ‘Ŋarrany ŋuli gi dhuwal yaka maŋutji-yarrkthurr gurrupul bukmaknha yan yolŋuny. Bili muka nhe ŋunhi yoraŋalnydja ŋurikiyiny rrupiyaw diyin-dulawnydja, nhe dhu waŋganypuynydja walupuy djämapuy märram dhuwaliyin rrupiya diyin-dulan yan, ");
INSERT INTO djr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ga bilin nhakun nhe dhuwaliyi märraŋala rrupiyany, gatjuy marrtjin wäŋalila. Ŋarrany dhuwal djäl ŋarra dhu balanyayi bili yan dhuḏi'-dhuḏiŋuwnydja yolŋuw walalaŋ gurrupan ŋupanayŋuyi yan nhakun ŋunha ŋurru'-ŋurruŋuw yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Bili dhuwandja ŋunhi ŋula nhä mala ŋarrakuwuy yan, ŋarrapi yan dhu marrtji gurrupan ŋarrakiyingal djälyu. Ga nhakun nheny ga dhuwal maŋutji-ḏiy'yun ŋarrany dhipalnydja ŋunhi ŋayaŋu-dhapinyalilnydja romlil?’” ");
INSERT INTO djr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bala ŋayi Djesu dhawar'maraŋalnydja waŋan bitjarra, “Yo walalnydja dhu ŋunhi dhuḏi'-dhuḏiŋuny ŋurruŋun ga ŋurru'-ŋurruŋuny dhu dhuḏiŋun.” ");
INSERT INTO djr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yo. Walalnydja marrtjin ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu wäŋgaŋala ḏuwaṯthurra bala dhukarr-ŋupara Djurutjalamlila. Bala ŋayi Djesuynydja ḻuŋ'maraŋala walalany waŋganylila ŋunhi 12-nhany nhanŋuwuynydja ŋayi malthunamirriny malany, bala ŋayi lakaraŋala walalaŋgal gayulnha ŋunhi nhaltjan nhanŋu dhu maḻŋ'thun ŋunhal Djurutjalam. ");
INSERT INTO djr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ga bitjarra ŋayi marrtjin walalaŋgal ŋunhi lakaraŋalnydja gam', “Ŋämany nhuma dhu manymakkum yan walal. Limurrnydja ga dhuwal marrtji balan Djurutjalamlila, ga ŋunhaliyin walal dhu ŋunhi Yolŋunhany Gäthu'mirriŋuny märramany bala gäman goŋ-gurrupanna ŋurruŋu djirrikaymirriwala mala ga rom-marŋgikunhamirriwala malaŋuwal märr walal nhanŋu dhu waŋanhamirra bunharawnha, ");
INSERT INTO djr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","bala walal dhu goŋ-gurrupanna ŋanya Djan'tayilwalnha yolŋuwal malaŋuwal. Walalnha ŋanya dhu ga ŋunhi warku'yundja, dhupthundja ŋanya, ga bartjunmaramany burruṯiŋuynydja, ga bumany ŋanya walal dhu murrkay'kuman. Yurr ŋayi dhu ŋunhi buluyi nhakun walŋathiyi ḻurrkun'thuny waluy.” Ga bitjarr ŋayi gan Djesu lakaranhaminany ŋanyapinya ŋayi. ");
INSERT INTO djr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ga beŋuryiny, ŋayiny ŋunhi ŋäṉḏi'mirriŋuny maṉḏaŋguny Djayimguny ga Djonguny marrtjinan guwatjmara ŋanya Djesunhany, ga gäŋal ŋayi ŋunhi maṉḏany yulŋuny. Manymak marrtjinany ŋayi ŋunhi miyalktja bala bun'kumu-djipthurra Djesuwala. Bala ŋayi waŋanan bitjarra, “Way Garray, waŋa ŋarra dhu dhuwal nhuna bay.” ");
INSERT INTO djr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ga ŋayiny waŋan, “Go bay waŋin,” bitjarr. Bala ŋayi waŋanan ŋunhi miyalktja ŋäṉḏi'mirriŋuny, “Ŋunhi nhe dhu ŋurruŋuyirr ŋurukuny ŋunhi nhokiyingalaŋuwnydja nhe romgu, ŋarrany dhuwal djäl maṉḏaŋguny dhiyakuny maṉḏaŋ maṉḏa dhu gi nhininy ŋurruŋun, galkin yanan nhokalnha, waŋgany dhunupa'ŋuŋur gali'ŋur ga waŋgany wiṉ'kuŋuŋur gali'ŋur.” ");
INSERT INTO djr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bala ŋayiny Djesuny waŋan bitjarra, “Maṉḏa, yaka nhuma dhuwal marŋgi nhaku nhuma ga dhuwal ŋäŋ'thun. Nhä bili balaŋ nhuma dhuwal ŋuḻkthurr dhipuŋurnydja banikin'ŋur, ŋunhi ŋarra dhu ŋuḻkthun?” Ga maṉḏany Djayimdja ga Djondja buku-bakmaraŋal nhanŋu bitjarr, “Yo Garray! Linyuny dhu ga dhuwal malthunna yan nhuŋu, bäydhi ŋunhi burakinyamirriwurrnydja romgurr.” ");
INSERT INTO djr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ga ŋayiny Djesuny buku-bakmaraŋal bitjarr, “Yuwalk muka nhuma dhu dhuwal galŋa-miḏikirrnydja bitjan yan bili nhakun ŋarra. Yurr ŋarrany dhu dhuwal yaka ŋarrapiny djarr'yun ŋula yolnhany yolŋuny ŋurruŋuthinyarawnydja nhinanharaw ŋunhawalnydja ŋunhi galki ŋarrakalnydja. Ŋayipi yan dhu ŋunhi God-Waŋarryu djarr'yun ŋula yolnhany yolŋuny ga ŋurruŋukumany dhu nhirrpan ŋunhiwurrunhany yolŋuny walalany ŋunhi ŋayi ŋäthil walalany bili djarr'yurr.” ");
INSERT INTO djr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ga ŋunhi walal wiripuwurruynydja ḻundu'mirriŋuy walal ŋäkul walalany waŋanhaminyawuynydja, bala yan walal mirithinan maḏakarritjthinany ŋurikiyiny maṉḏaŋ wäwa'manydjiwnydja. ");
INSERT INTO djr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yurr ŋayiny Djesuny walalaŋ wäthurr buku-manapar walalany, bala ŋayi waŋanan, “Marŋgi muka nhuma ŋunhi romgu walalaŋguny Djan'tayilwuny malaŋuw, ŋunhi ŋurru'-ŋurruŋu mala walalaŋ ŋuli ga buŋgawakunhamirr, ga balanyayin walalaŋ ŋunhi romdja walal dhu ga ŋunha wiripuwurrunhan yolŋunhany walalany dhar'thar-gurrupandja nhakun djämamirrinhan mala walalaŋguwuy. ");
INSERT INTO djr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yurr nhumany yaka biyakiyi walalanhany gi wanaŋguŋ. Ga ŋuli nhe ŋula yol yolŋu djäl ŋurruŋuyinyarawnydja nhinanharaw, nheny yakan buŋgawa lakaranhamirr. Biyakun nyilŋ'maranhamirra nhunapinya nhe ga djäman gi yan guŋga'yurra wiripuwurrunhany yolŋuny walalany, nhakun dhu nhen djämamirrnydja walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ga nheny ŋunhi nhe ga djälthirr nhe dhu ŋurruŋuyirr, nheny ŋathil djämamirriyanhamirr, bukmakkun yan yolŋuw. ");
INSERT INTO djr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bili balanyarawyi muka dhuwal ŋarrany bunan dhiyal, Yolŋuny Gäthu'mirriŋu. Yaka ŋarra dhuwal räli marrtjinya walal dhu ga yolŋuy walal ŋarrany guŋga'yun, ga djäma walal dhu ga ŋarraku. Ŋarrany dhuwal marrtjin räli dhipalnydja, ŋarra dhu ga djäma yolŋuw walalaŋ, ga bitjandhiyi bili ŋarra dhu walŋany walalaŋ gurrupanmirr walalaŋguny walŋakunharaw.” Ga bitjarra ŋayi gan ŋunhi Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ŋunhi walal marrtjin Djesu ga ḻundu'mirriŋu mala nhanŋu wäŋgaŋalnydja bala-a-a, baṯnha ŋayathaŋal Djarikawnydja wäŋa yäku. Ga ŋunhi walal ganarrthaŋal ŋunhiyiny wäŋa, ga walalnydja ŋunhi dharrwan mirithirra yolŋuny mala malthurr dhukarr-ŋuparnydja. ");
INSERT INTO djr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ga ŋunhili gali'ŋur dhukarrŋurnydja gan nhinan yolŋu maṉḏa yurr bambay maṉḏa, Ga ŋunhi maṉḏa ŋäkul Djesunhany ŋayi gan ŋulawitjarryiny dhukarrkurr marrtjin, bala maṉḏa wäthurra, “Way, Garray! Gäthu'mirriŋu Daybitku, wuyurr linyalaŋ go,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bala walalnydja ŋunhi dharrwaynha yolŋuynydja mala mukmaraŋalnydja maṉḏany, yurr maṉḏany mirithinan dhika yatjurr, “Garray! Gäthu'mirriŋu Daybitku, wuyurr linyalaŋ go,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ga ŋunhi ŋayi Djesuy ŋäkulnydja maṉḏany, bala yan ŋayi gulyurra bala dhä-birrka'yurra bitjarra, “Nhaku nhuma djälnydja nhaltjan ŋarra nhumalaŋ dhu yulŋuny?” ");
INSERT INTO djr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ga maṉḏany buku-bakmaraŋal bitjarr, “Garray linyuny dhuwal djäl, linyu dhu nhäman!” ");
INSERT INTO djr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Bala yan ŋayi Djesuny maṉḏaŋ wuyurra. Ga dhunupan maṉḏa ŋunhi maŋutjimirriyinan nhäŋala maṉḏa gan, bala maṉḏa gan malthurra nhanŋu Djesuwnha dhukarr-ŋupara bala. ");
INSERT INTO djr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yo, ga ŋunhi ŋayi gan Djesu ga malthunamirr mala nhanŋu wäŋgaŋalnydja bala-a-a, ga ŋunhi walal marrtjin bukuy-märraŋal Djurutjalamdja wäŋa ga balan walal ŋunhi marrtjinany Batpatjlila, bukuŋura galkin Wolipnha, ŋunhiyiny wäŋa galkin mirithirra ŋunhan Djurutjalamnha wäŋa. Bala ŋayi Djesuynydja märrma'nhan yolŋuny maṉḏany nhanŋuwuy djuy'yurr ŋäthila, ");
INSERT INTO djr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ga bitjarr ŋayi marrtjin waŋanany maṉḏaŋgal gam', “Gatjuy nhumany ŋäthil marrtji ŋini, bala biyak ŋunhiyi nyumukuṉiny wäŋa ga dhärra ŋäthil. Ga ŋunhi nhuma dhu dhuwal marrtjiny, ga maḻŋ'maramany nhuma dhu warrakan'nha yäkuny duŋ'kiny ga yothuny nhanŋu. Yupmaramany nhuma dhu maṉḏaŋgal rakiny' bala gäman maṉḏany rälin ŋarrakalnha. ");
INSERT INTO djr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ga ŋuli nhumalany dhu ŋula yolthu yolŋuy dhä-birrka'yundja nhumany dhu bitjan lakaram, Garray dhuwal djälthin dhiyak, bala yan ŋayi dhu ŋunhi djuy'yunna duŋ'kinhany maṉḏany.” ");
INSERT INTO djr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ga yuwalknha yan ŋayi ŋunhi dhawuny' maḻŋ'thurra warraŋulthinan ŋunhi ŋayi gan God-Waŋarrwal djawarrkmirriy ŋäthil bitjarr lakaraŋal gam', ");
INSERT INTO djr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Waŋin lakaraŋun ŋunhawalnydja yolŋu'-yulŋuw Djurutjalamlilnydja wäŋalil, Dhuwal nhumalaŋ ga Buŋgawany marrtjin rälin nhumalaŋgala. Ŋayiny dhuwal ŋayaŋu wurrkurrum'nha, ga nhinany ŋayi marrtji dhuwal duŋ'kiwal yuṯawal ŋapaŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bala yan maṉḏa ŋunhi malthunamirrnydja maṉḏa märrmany' marrtjinan, ga djäma maṉḏa ŋunhi bili yan ŋunhi nhaku ŋayi maṉḏany Djesuy djäma gurrupan. ");
INSERT INTO djr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bala maṉḏa gäŋala ŋunhi duŋ'kinhany ga yothunhany nhanŋu balayin nhanukala Djesuwalnha. Ga ŋunhalnydja walal ŋunhi marrtjin girrin' mala walalaŋguwuy ḻarrmaraŋal, bala marrtjin rarr'yurra ŋapalila ŋurikalyin yuṯawala duŋ'kiwal, bala ŋayipiny Djesuny wapthurra ŋurikalyiny warrakan'kalnydja ḏiltjilila. ");
INSERT INTO djr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bala marrtjin dharrwaynha yolŋuynydja walal girriny' mala walalaŋguwuy walal gaya'-gayanhdhaŋal balayin dhukarrlila. Ga wiripuwurruynydja marrtjin yolŋuy walal marran dharpan ḏiwirrkthurr, bala marrtjin rarr'yurra dhukarrlila. ");
INSERT INTO djr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ga ŋunhiwurrnydja yolŋu walal ŋunhi walal marrtjin wäŋgaŋal gumurrkurr nhanukalaŋuwurr, ga munguyurr walal ŋanya marrtjin, yatjunminan walal marrtjin ŋunhi nhanŋu yulŋuny, bitjarra, “Napurrnydja nhuŋu dhuwal wokthurrnydja mirithinan. Nheny dhuwal ŋunhiyin beŋura ŋunhi Daybitkala yarraṯaŋur, ga marrtjiny nhe ga dhuwaliyi Garraywal yan yäkuynydja. Ŋanapurr dhuwal buku-wurrparnydja God-Waŋarrnhan nhuŋu, wokthurrnydja manapar.” Ga bitjarra walal marrtjin ŋunhi yatjunminany. ");
INSERT INTO djr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ga ŋunhi ŋayi Djesu bunanany Djurutjalamdja, bala walal ŋunhi wiripuwurruynydja yolŋuy walal gan ganyim'thurra nhäŋal ga ŋäkul, bala walal marrtjin waŋanany bitjarra, “Yol bili ŋayi ga dhika marrtjiny räliny? … yol?” ");
INSERT INTO djr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ga walalnydja ŋunhi walal gan malthurr nhanŋu buku-bakmaraŋal bitjarra, “Dhuwandja dhuwal Djesun, ŋunhiyin djawarrkmirra yolŋu ŋurukuwuynha Nätjuritjpuynha wäŋapuy, makarrwuynydja Galaliwuynha.” ");
INSERT INTO djr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Manymak wäŋgaŋalnydja walal marrtjin bala-a-a burnha bunan Djurutjalamnha. Ga dhunupan yan ŋayiny Djesuny marrtjinan balayin ŋunhi buku-ŋal'yunamirrilila Buṉbulil God-Waŋarrwalnha, ga ŋunhiliyi djinawany' yolŋuy walal wiripuŋuwuy wäŋapuy gan buku-djuḻkmaranhamin djambi rrupiya, ga djalim walal gan warrakan' mala ŋunhiliyi. Bala dhunupan ŋayi marrtjin ŋunhi Djesuynydja djalkthurra rrupiya djambimirriwnydja daybuḻnydja mala, ga ŋunhi nhinanhawuy mala warrakan' djalimmirriw mala. ");
INSERT INTO djr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Bala ŋayi waŋanany bitjarra, “Ŋunha ga ŋunhi God-Waŋarrwalnydja djorra'ŋur lakaram bitjan, ‘Ŋarrakuny dhu ga buṉbu dhärra buku-ŋal'yunaraw yan waŋganygu.’ Ga nhumany dhuwal buṉbuny wakalkuŋal warray, bitjarra nhakun dhuwandja wäŋa manaŋa-ḏilkurruwnha djuḻuḻ'yunaraw, bitjarryin nhumany dhuwal.” ");
INSERT INTO djr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Bala walal gan ŋunhi rerrimirrnydja yolŋu walal, balanya nhakun bambaynydja ga gaṉuŋdja ga bulu wiripuwurr rerrimirr mala marrtjinan Djesuwala ŋunhiwiliyin buku-ŋal'yunamirrilila buṉbulilnydja, bala ŋayi walalany gan yan ḏukmaraŋala. ");
INSERT INTO djr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ga walalnydja ŋunhi Rom-marŋgikunhamirrnydja mala ga ŋurruŋu djirrikaymirrnydja mala nhanŋu maḏakarritjthinan mirithinan, bili walal nhäŋal ŋanya Djesuny ŋayi gan djäma ŋayaŋu-ganyim'thunamirra romdja ŋunhiliyiny ŋunhi buku-ŋal'yunamirriŋurnydja buṉbuŋur. Ga bukmaknha gan ŋunhi djamarrkuḻiny' ŋunhiliyi yatjunminan yindiynha dhika rirrakayyuny wokthurra walal gan ŋurikiyin yolŋuw ŋunhi ŋayi Daybitkal yarraṯaŋur. ");
INSERT INTO djr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ga walalnydja ŋunhi ŋaḻapaḻmirrnydja waŋan, “Muka bäyŋu nhe gi dhuwal ŋunha djamarrkuḻi'nhany ŋäku, nhaltjan walal marrtji ŋunha waŋa?” Ga ŋayiny Djesuny buku-bakmaraŋal bitjarr, “Ŋe, bili muka ŋarra walalany ga dhuwal ŋäma,” bitjarr ŋayi. Ga bulu ŋayi waŋan, “Muka bäyŋu nhumany ŋuli gi dhuwal maŋutji-ḻaw'maraŋ ŋunhi God-Waŋarrwuny djorra', ŋunhi ga ŋayi bitjan waŋa gam'. ‘Walalnydja dhu ŋunhi djamarrkuḻiny', yumurrkuny bitjandhi bili yan wokthun ŋarraku.’” ");
INSERT INTO djr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bala ŋayi Djesuny marrtjinan ganarrthaŋala ŋunhiyiny wäŋa, balan ŋayi marrtjin Bithinilila wäŋalil, ga ŋunhiliyin ŋayi ŋorranany. ");
INSERT INTO djr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ga djaḏaw'yurr wiripun walu, bala ŋayi Djesuny djaṉŋarrthinan. Ga balayi ŋayi roŋiyindhi marrtjin Djurutjalamlil, ");
INSERT INTO djr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ga ŋunhi ŋayi gan Djesu marrtjinany bala dhukarr ŋuparnydja, bala ŋayi nhäŋala dharpan muthir'nha ŋayi gan dhärran galki dhukarrŋur. Bala ŋayi marrtjin galkithinan balayin dharpalila wanha ŋayi balaŋ maḻŋ'maranha ŋatha dhakal ŋunhiliyi. Yurr bäyŋun ŋayi ŋunhi maḻŋ'maranhany dhakalnydja, marwatnha yan gan gorruŋal. Bala ŋayi Djesuny waŋanan ŋurikiyi dharpawnydja bitjarrnha, “Bäyŋun nhe dhu buluny boŋguŋ dhakalmirriyi.” Bala dhunupan yan ŋunhi dharpany räwakthinan. ");
INSERT INTO djr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ga walalnydja ŋunhi malthunamirriynydja mala nhanukal nhäŋalnydja ŋunhiyi ganyim'thurra, bili bondin yan ŋayi ŋunhi dharpany räwakthin. ");
INSERT INTO djr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Bala ŋayi Djesuny bilyurra bala waŋanan walalaŋ bitjarra, “Märr-yuwalk yan ŋarra ga nhumalaŋ dhuwandja lakaram. Ŋuli nhe ga ŋula yolthu yolŋuy ŋayatham märr-nhirrpanminyawuynydja, ga yakany nhe ŋuli gi märr-dhumbal'yurr, nheny dhu bitjandhiyin waŋa dhäruknha yan nhakun dhuwal ŋarra waŋan dhiyak dharpaw, bala yan ŋayiny dhu nhuna ŋäman. Yaka yan dhuwaliyi bili, ŋany wiripu mala nhe balaŋ biyakiyi bili djäma. Wiripuny nhe balaŋ waŋi dhuwal bukuny wäŋany ŋayi balaŋ marrtji ga gapulila ḻupthurr, ŋayiny balaŋ nhuna ŋäku yan ga marrtji balaŋ ŋayi ga ḻupthurr yan gapuŋur. ");
INSERT INTO djr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ga ŋuli nhe dhu ŋäŋ'thun God-Waŋarrnha bukumirriyanhawurr, nheny dhu ŋunhi märraman yan ŋula nhä ŋuli nhe dhu ga märr-yuwalkmirriyirrnydja.” ");
INSERT INTO djr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yo marrtjinany walal gan ŋunhi bala-a-a, ga yan bili ga Djurutjalamnha, bala ŋayi Djesuny dhunupan gärrinan buku-ŋal'yunamirrilila buṉbulil bala ŋayi gan marŋgikuŋala yolŋunhan walalany. Ga walalnydja ŋunhi ŋurruŋu djirrikaymirrnydja yolŋu walal, ga rom-marŋgikunhamirrnydja mala, ga ŋunhi rom-djägamirrnydja mala marrtjinan nhanukal balayin. Bala walal gan dhä-birrka'yurra ŋanya Djesunhany bitjarrnha, “Gatjuy mak lakaraŋun napurruŋgal, yolthu nhuna dhuwal waŋanany balanyarawyiny djämaw? Ga yolthu nhuna dhuwal nhirrparnydja dhiyakiyiny djämaw?” ");
INSERT INTO djr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bala ŋayiny Djesuny buku-bakmaraŋal balany walalaŋguny bitjarra, “Ŋurruŋuny ŋathil dhu ŋarra nhumalany dhä-birrka'yun. Ga ŋuli nhuma dhu lakaram ŋarraku, ga yorrnha ŋarrany dhu nhumalaŋguny lakaram ŋunhi yolthu ŋarrany waŋan dhiyak djamaw. ");
INSERT INTO djr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yolthu ŋunhi nhirrpar Djonnhany yolŋuny? Ga yolthu ŋanya ŋunhi waŋan ḻiya-ḻupmaranharawnydja yolŋuwnydja walalaŋ? God-Waŋarryu? Ŋany yolŋuy walal?” Bala walalnydja ŋunhi ŋurruḏawalaŋuny mala waŋanhaminan bitjanminan, “Way, nhaltjanna dhika limurrnydja dhu lakaram balany nhanŋuny buku-bakmaram? Ŋuli limurr dhu ŋunhi bitjandja lakaram, ‘God-Waŋarryu ŋayipi yan ŋunhi Djonnhany waŋan,’ bitjandja, bala ŋayiny dhu ŋunhi waŋa limurruŋguny bitjanna, ‘Nhakun nhuma ŋunhi yakany märr-yuwalkthinya nhanŋuny Djonguny dhärukku?’ ");
INSERT INTO djr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ga ŋuli limurr dhu dhuwal lakaram nhanukal bitjandja, ‘Yolŋu'-yulŋuy ŋanya ŋunhi waŋa ŋurikiyi djämaw,’ bitjandja, ga walalnydja dhu ŋunhi wiripuwurrnydja yolŋu walal maḏakarritjthirrnydja limurruŋgun. Bili walalnydja ga ŋunha bitjan märr-yuwalkthirr ŋunhi ŋayiny Djondja djawarrkmirra yolŋu.” ");
INSERT INTO djr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Bala walal waŋanan Djesuwnydja bitjarra, “Yaka dhuwal napurrnydja marŋgi bay, yolthu ŋanya ŋunhi Djonnha nhirrpar ŋurikiyi djämaw.” Ga ŋayiny Djesuny waŋan walalaŋguny bitjarra, “Yo. Ga ŋarrany dhu bitjandhi bili yan yakayi nhumalaŋguny lakaram, ŋunhi yolthu ŋarrany dhiyak djämaw nhirrpar.” Ga bitjarra ŋayi gan Djesuny waŋan walalaŋguny. ");
INSERT INTO djr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ga buluny ŋayi Djesu waŋan bitjarra gam', “Dhuwandja ŋarra nhumalaŋ dhu dhäwu lakaram ŋunhi ḏirramu gan nhinan ga märrma' gäthu'mirriŋu maṉḏa nhanŋu. Manymak waŋganymirrnydja ŋayiny ŋunhi bäpa'mirriŋuny marrtjinan yothuwala nhanukalaŋuwal maḻamarrwala, ga waŋan ŋayi ŋanya bitjarr, ‘Way gäthu, yalalany nhe dhu marrtji bala ŋarrakal wäŋalil djämaw, ŋuthanmaram nhe dhu borum mala ŋarraku,’ bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ga ŋayiny ŋunhi maḻamarrnydja gäthu'mirriŋu nhanŋu waŋan yaka'yurr, yurr yalalany bala ŋayi ḻiya-bilmaranhaminan, bala ŋayi marrtjinan balayin bäpa'mirriŋuwala nhanukalaŋuwal djämawnha. ");
INSERT INTO djr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ga bulu ŋayi ŋuriŋiyi bäpa'mirriŋuy waŋan malpuranhany muka gäthu'mirriŋuny djämaw, ga ŋayiny ŋunhi malpurany gäthu'mirriŋu waŋan bitjarr, ‘Yo manymak ŋarra dhu nhuŋu djäma bitjandhiyi.’ Ga bäyŋun ŋayi ŋunhi yuwalktja marrtjinya balayiny djämalilnydja bäpa'mirriŋuwalnydja nhanukalaŋuwal.” ");
INSERT INTO djr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bala ŋayi beŋuryiny Djesuy dhä-birrka'yurra walalany bitjarrnha, “Ga yolthun ŋunhi yothuy dhäruktja märraŋal bäpa'mirriŋunhany?” Ga walalnydja buku-bakmaraŋal bitjarr, “Ŋuriŋiyin muka dhuwal maḻamarryun gäthu'mirriŋuy ŋanya dhäruktja märraŋal bäpa'mirriŋunhany.” Bala ŋayiny Djesuynydja walalaŋ bitjarrnha lakaraŋal, “Walalnha dhu ŋunhi dhuwurr-yätjmirra ga rrupiya-märranhamirra yolŋu walal ŋunhi gapmangun, ga marramba'mirra mala ŋurruŋuny gulŋiyi God-Waŋarrwalnydja Romlil nhumalaŋguny dhu ŋurruŋu-djuḻkthurr. ");
INSERT INTO djr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bili ŋayiny gan ŋunhi ŋuriŋiyiny Djondhuny yäkuy ḻiya-ḻupmaranhamirriynydja bili muka dhukarrnydja nhumalaŋgal lakaraŋal dhunupa yan, ga nhumany yaka warray nhanŋu märr-yuwalkthinya. Ga walalnha ŋunhi dhuwurr-yätjmirriynha dhäruktja ŋanya märraŋal, bala walal gan yan bilyurra yätjkurruŋurnydja romŋur mala.” “Yo, ga bili muka nhuma gan ŋunhi nhäŋalnydja walalany bilyunawuynydja, yurr nhumany ŋunhi yaka warray bilyuna nhumalaŋgiyingalaŋaŋurnydja guyaŋanhawuyŋur ga märr-yuwalkmirriyinya nhuma nhanukalaŋawnydja dhäwuw bäyŋun yan.” ");
INSERT INTO djr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ga dhäŋur beŋuryiny ŋayi nhakun Djesuy bulu lakaraŋal dhäwu mayali'kurr ŋurikiwurruŋgalyi yolŋuwal walalaŋgal, ga dhuwal ŋayi ŋunhi dhäwuny' lakaraŋal gam', “Ŋunhiliyi yolŋu gan nhinan wäŋa-waṯaŋu, ga ŋayiny ŋunhiyiny yolŋu wäŋa-waṯaŋuny gan djälthin ŋayi dhu ŋuthanmaram ŋamakurr mala borum. Bala ŋayi lämu-nhirrpara ŋunhiwiliyiny wäŋalil borumnha mala dharpan. Ga djäma ŋayi munatha' ŋurikiyi ŋathaw buḻŋu'kuŋal bala ŋayi ḻoḻuwunuŋala ŋunhiyi wäŋany. Ga djämayi ŋayi wäŋa mil'ŋuwnydja yolŋuw nhinanharawnydja. Ga dhäŋur beŋuryiny ŋayi djarr'yurra yolŋunhan walalany ŋurukiyin djägawnha, djägamirriyaŋala walalany. Bala ŋayi marrtjinan ŋunhiyiny wäŋa-waṯaŋuny yolŋu wiripuŋulila wäŋalil.” ");
INSERT INTO djr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Yo. Nhinanany ŋayi gan ŋunhiyi wäŋa-waṯaŋuny yolŋu, yan bili ga walu marrtjin galkithinan borumguny ŋuriki borumdhinyarawnha, bala ŋayi wäthurra ḻurrkun'ku yolŋuw walalaŋ djämamirriw mala, bala ŋayi walalany djuy'yurra, märr walal dhu märraman wapmaraman nhanŋuny borum mala. ");
INSERT INTO djr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ga walalnydja ŋuriŋiwurruynydja borum-djägamirriynydja walal nhäŋal walalany ŋunhiwurrunhany, bala yan walalany ŋayathaŋala bumarnha marrtjin, waŋganynha bat-ŋurrkaŋal, ga waŋganynhany walal muḻkurr wutthurr guṉḏay rakunygu yan, ga waŋganynhany walal dhä-murrkay'wun wutthurr.” ");
INSERT INTO djr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Ga bitjarryi bili ŋayi wiripuwurrunhany yolŋuny walalany djämamirriny walalany djuy'yurr, yurr märr dharrwanhan. Ga walalnydja ŋunhi ŋuruŋiwurruyyi bili yan bumar walalany bitjarryi bili yan murrka'-murrkay'kuŋal.” ");
INSERT INTO djr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Bala ŋayi ŋuriŋiyi wäŋa-waṯaŋuynydja yolŋuy djuy'yurr bulu waŋganynhan yolŋuny, ŋunhiyin gäthu'mirriŋunhan nhanŋuwuy ŋayi waŋganynhan, märr walal dhu nhanŋun märr-ŋal'yundja, bili ŋayi gan bitjarr guyaŋan yanbi walal balaŋ ŋanya nhänha bay'. ");
INSERT INTO djr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ga ŋunhi walal nhäŋalnydja ŋanya ŋuriŋiwurruyyiny ŋunhi borum-djägamirriynydja yolŋuy walal, bala walal waŋanhaminany bitjanminan, ‘Go, limurr ŋanya buman murrkay'kuman, märr dhu boŋguŋ dhuwandja wäŋa limurruŋguwuynha.’ ");
INSERT INTO djr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Bala yan walal ŋanya ŋunhi ŋayathaŋala, ga bumarnydja walal ŋanya ŋunhi dhiŋganhamaraŋala yan, ga rumbalnydja walal ŋanya ŋunhi ŋurrkaŋala dhawaṯmaraŋala warraŋullila, beŋuryiny ŋunhi borummirriŋurnydja wäŋaŋur.” ");
INSERT INTO djr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Bala ŋayi dhäŋur beŋuryiny Djesuy dhä-birrka'yurra walalany bitjarra, “Nhaltjanna ŋayi dhu ŋunhi ŋuriŋiyi wäŋa-waṯaŋuynydja ŋunhiwurrunhany ŋunhi djämamirrinhany walalany?” ");
INSERT INTO djr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ga walalnydja ŋunhi ŋurruŋu djirrikaymirrnydja mala ga rom djägamirrnydja mala buku-bakmaraŋal bitjarr gam', “Bitjanna ŋayi dhu ŋunhi gam'. Marrtjiny ŋayi dhu ŋunhi, ga dhunupan ŋayi dhu buman murrkay'kuman ŋunhiwurrunhany yolŋuny walalany djägamiriwnhany mala, bala ŋayi dhu ŋunhiyiny wäŋa gurrupan wiripuwurruŋgalnha yolŋuwal walalaŋgal djägalil, ga walalnha dhu ŋunhi nhanŋuny wäŋa-waṯaŋuwnydja gurrupan borum mala, balanyamirriynydja ŋunhi dhu ŋathany mala borumdhi warrpam'tja.” ");
INSERT INTO djr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Bala ŋayi dhawar'maraŋalnydja Djesu waŋan bitjarra, “Bili muka nhuma dhuwal marŋgi ŋunhi ga ŋunha djorrayny'tja lakaram bitjan gam', ‘Bala'-dhuḻ'yunamirriy mala yolŋu'-yulŋuy marrtjin guṉḏa ŋal'maraŋal, walal dhu dhuḻ'yun bala', ga ŋunhiyi waŋganydja guṉḏa walal nhäŋal, bala nyamir'yurra, bala walal yan ŋurrkaŋalnha. Yurr God-Waŋarryuny walalaŋguŋ ŋunhiyiny guṉḏa ŋurrkanhawuynydja märraŋala, bala nhirrpara balaw'nha ŋunhiyiny djalkirin yuṯuŋgurrwun dhärranharawnha. Ga bitjarryin ŋayi gan ŋunhi God-Waŋarryu djämany, ga ŋunhiyiny nhakun mirithirra yan ŋayaŋu-ganyim'thunamirra limurruŋguny nhänharaw.’” Ga bitjarr ŋayi gan ŋunhi Djesuy lakaraŋalnydja mayali'wurrnydja. ");
INSERT INTO djr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ga bulu ŋayi bitjarr waŋan Djesu gam', “Yuwalk ŋarra ga dhuwal lakaramany nhumalaŋ, ŋayiny dhu ŋunhi God-Waŋarrwuny rom nhumalaŋgalaŋaŋurnydja yan djaw'yurra, bala ŋayi dhu gurrupulnydja ŋurikiwurruŋgun ŋunhi walal ŋuli ga yuwalkkum yan ŋanya dhäruk märram. ");
INSERT INTO djr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ga ŋuli dhu ŋunhi ŋula yolnha yolŋuny gaṯmaramany ŋuriŋiyiny guṉḏay, ŋunhiny dhu ŋanya yan binydjitjkuman dhurrparaman. Ga ŋuli ŋayi dhu ŋunhiyi guṉḏa, ŋula yolkalnydja yolŋuwal galkirri, ŋunhiny dhu ŋanya yan buḻwaŋ'maraman monyguman.” ");
INSERT INTO djr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ga ŋunhi walal ŋuriŋiwurruyyi ŋurruŋu djirrikaymirriynydja yolŋuy walal ga Baratjiynydja mala, ŋäkulnydja ŋunhiyi dhäwuny mala, bala walal yan dharaŋarnha ŋunhi mayaliny', ŋunhi ŋayi gan Djesuynydja lakaraŋal walalanhan. ");
INSERT INTO djr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bala walal dhunupan gan dhukarrwun ḻarruŋal nhaltjan walal dhu buma ŋanya Djesuny murrkay'kum. Yurr bäyŋun, bili walal gan ŋunhi barrarinan yolŋuwnha walalaŋ, bili walalnydja gan ŋunhi yolŋu'-yulŋuynydja bitjarra guyaŋan, ŋunhi ŋayiny God-Waŋarrwun djawarrkmirra yolŋu. ");
INSERT INTO djr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ga bulu nhakun ŋayi Djesuy lakaraŋal walalaŋ dhäwu, märr ŋayi dhu yolŋuny walalany marŋgikum. ");
INSERT INTO djr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Yo! Balanya dhuwal God-Waŋarrwuny Rom gam'; nhakun dhu Buŋgaway Ŋurruḏawalaŋuy djäma ŋäthilmirriyam latjukum dhika ŋatha dharrwa mirithirr, yurr djämany ŋayi dhu ŋunhi ŋathany balanyamirriy ŋunhi nhanukal dhu ḏirramuy gäthu'mirriŋuy märram miyalknha.” ");
INSERT INTO djr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","“Bala ŋayi ŋuriŋiyi buŋgawaynydja ŋurruḏawalaŋuynydja djämamirrinhan mala nhanŋuwuy ŋayi djuy'yurr rälimirriyanharawnha yolŋuwnha walalaŋ ŋunhi nhanukalaŋumirr ŋayaŋumirr, walal dhu ŋathan ḻuka märr-yiŋgathirra manapan nhanukalaŋaw gäthu'mirriŋuwnha ŋunhi ŋayi miyalknha märraŋal. Yurr walalnydja ŋunhi bukmaktja yolŋu walal ŋayaŋumirrnydja mala, ŋuyulkthin warray marrtjinyarawnydja balayiny ŋathawnydja ḻukanharaw.” ");
INSERT INTO djr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ga bulu ŋayi wiripuwurrunhany muka djämamirriny mala djuy'yurr walalaŋgal ga bitjarra ŋayi waŋanany gam', ‘Ŋathany dhuwal bilin galkunna ga! Dhuwal bulikiny ga bukmak ŋarraku ŋunhi yothu-yothuny buliki mala bilin mitmitthunawuynha, ga ŋamathaŋala gan ŋunha nhäranany guṉḏirryun, bilin napurr dhuwal goŋ-dhawar'yurra ŋathaŋurnydja ŋamaŋamayunaŋur. Go marrtjin walal rälin limurr ŋathan ḻuka, ŋunhi ŋarra ŋamaŋamayurr ŋarrakalaŋaw gäthu'mirriŋuw, bili ŋayi ga dhuwal miyalknhan märram.’” ");
INSERT INTO djr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Yurr ŋunhi walal ŋuriŋiwurruy yolŋu'-yulŋuynydja dhäwuny ŋäkul ŋunhi walalany ŋayi gan ŋuriŋiyi Buŋgaway gaḏaymar ŋathaw ḻukanharaw, walalnydja ŋunhi yan buthuru-djaw'yunminan walalaŋ ŋurikiwurruŋguny ŋunhi dhäwu-gänhamirriwnydja walalaŋ. Bala yan walal ŋunhi yolŋu'-yulŋuny balan bitjarra marrtjin walalaŋgiyingalnha djämalil malaŋulil ŋula nhäkurra. Wiripuwurrnydja marrtjin balan bitjarra walal dhu ga djägan walalaŋguwuy walal gätniwnha, ga wiripuwurrnydja warrakan'kun malaŋuw walalaŋgiyingalaŋaw. ");
INSERT INTO djr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ga wiripuwurruynydja gan ŋunhi yolŋu'-yulŋuy bumara ŋunhi djämamirrinhany mala murrkay'kuŋala yan.” ");
INSERT INTO djr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Ga dhiyaŋuny dhäwuy ŋayiny ŋunhi Buŋgawany Ŋurruḏawalaŋuny mirithinan dhika maḏakarritjthinany, bala yan ŋayi miriŋunhan mala nhanŋuwuy ŋayi djuy'yurr bunharawnha rakunykunharawnha yan, ga bulu walal dhu bathan walalaŋ wäŋa ŋurikiwurruŋ yolŋu'-yulŋuw ŋunhi walal bumar rakunyguŋal nhanŋu djämamirriny mala.” ");
INSERT INTO djr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ga dhäŋur beŋuryiny bala ŋayiny ŋunhi Ŋurruḏawalaŋuny Buŋgawany waŋanan wiripuwurruŋguny djämamirriw mala bitjarra gam', ‘Go! Marrtjin walal, bilin dhuwal waluny, limurr dhu ŋurruyirr'yuna ŋathany ḻukan ŋarrakalaŋaw gäthu'mirriŋuwnydja ŋunhi ŋayi dhu märraman nhanŋuwuy ŋayi miyalknhany. Ga walalnydja ŋunhi ŋarra walalaŋ ŋurruŋu dhäruk-djuy'yunmin ŋathaw ḻukanharaw walalnydja dhu yakan yan marrtji räli, bili walal ŋunhi yaka gana'. ");
INSERT INTO djr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bala ŋayi yan bitjarra waŋanany. Ga nhumany dhu balan marrtji dhukarr-ŋupanna ga nhämunha nhuma dhu ŋunhi maḻŋ'maram ŋula yolnha yolŋuny ŋunhili, yanan gaḏaymula ŋanya rälin, yo, ga bitjandhin nhuma dhu ga ŋunhi lakaramany bukmakkun yan yolŋuwnydja walalaŋ.’ ");
INSERT INTO djr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bala walal ŋunhi djämamirrnydja mala dhunupan yan marrtjinan dhukarr-ŋupara ḻarruŋala marrtjin walal bawalamirriwnha yolŋu'-yulŋuw, yolnha walal dhu ŋunhi maḻŋ'maram. Bala yan walal marrtjin gaḏaymarnha walalany, manymaknha ga yätjkurruny ga ŋurruwuyknha. Ga ŋuriŋiwurruynha ŋunhi, ŋunhiyi wäŋany ŋathamirrnydja dhaŋaŋguŋal.” ");
INSERT INTO djr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Dhäŋur beŋuryiny bala ŋayiny ŋunhi Buŋgawany Ŋurruḏawalaŋuny marrtjinan bala nhäŋalnha marrtjin walalany ŋunhiwurrunhany yolŋu'-yulŋunhany, dharrnha ŋayi nhäŋal waŋganynha yolŋuny ŋayi gan yaka gäŋal girri' ŋunhi dhunupa ŋurikiyi ŋathaw ḻukanharaw nhanukalaŋaw gäthu'mirriŋuwal ŋunhi ŋayi dhu miyalknha märram. ");
INSERT INTO djr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bala yan ŋayi ŋanya ŋunhi Buŋgawaynydja Ŋurruḏawalaŋuynydja dhä-birrka'yurra bitjarra gam', ‘Way! Yolŋu nhaku nhe dhuwal yakany dhaṯthunmin manymakkunhamin dhiyak buŋgulwuny ŋarrakalaŋaw gäthu'mirriŋuwnydja ŋunhi ŋayi dhu dhuwal miyalknhan märram?’ Yurr ŋayiny ŋunhi yolŋuny bäyŋun ŋula nhanŋu buku-bakmaranhany.” ");
INSERT INTO djr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Bala yan ŋayi ŋunhi Buŋgawaynydja Ŋurruḏawalaŋuynydja waŋanan nhanŋuwuy ŋayi djämamirrinhany mala, walal dhu garrwi'-garrwiyunna ŋanya ŋunhiyi yolŋunhany rakiy'nha goŋdja ga ḻukuny maṉḏany, bala yan ŋurrkaman ŋanya balan warraŋullila ŋunhi buku-munha'lila, ŋunhiwilin wäŋalil ŋunhi walal ŋuli ga yolŋu mala ḻirra-ḻäwunhamirra ŋäthinyamirra dhaŋga-ḏirryurra manapan. ");
INSERT INTO djr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dharrwa ŋunhi yolŋuny mala gawa'yunawuynydja yurr ḻurrkun'nha yan ŋunhi djarr'yunawuynydja.” Bitjarr ŋayi ŋunhi Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","16","Bala walal ŋunhi Baratjiny yolŋu mala marrtjinan bala walal gan ŋayan'mirra nhinanany nhanŋu Djesuwnydja. Bala yan walal djuy'yurra wiripuwurrunhan ḏirramuwurruny, ŋunhiwurrunhan ŋunhi Rom-marŋgikunhamirrinhan mala yolŋu'-yulŋuny ga bulu djuŋga'-djuŋgaya Yaritkun, märr walal ŋanya dhu ga mayali'-gäma dhä-birrka'yun, märr ŋayi dhu ŋunhi ŋayipiny dhä-maraŋgunhamirra. Bala walalnydja ŋunhi ŋurruḏawalaŋuwnydja mil'ŋuny mala marrtjinan malthurra nhanŋun Djesuwnha. Ga waŋanany walal ŋunhi nhanŋu Djesuwnydja bitjarrnha, “Way Marŋgikunhamirr, napurrnydja dhuwal marŋgi nhuŋu, ŋunhi nheny ŋuli ga dhuwal waŋa dhunupan yan dhäruk, ga dhunupa mala-djarr'yunamirr dhuwal nhe, bili nheny ŋuli ga ŋunhi yaka warray barrkuwatjkum bukmaknhany yolŋu'-yulŋuny. Ga marŋgikumany nhe ŋuli ga ŋunhi yuwalk yan God-Waŋarrwu dhukarrnydja. ");
INSERT INTO djr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Go mak lakaraŋun napurruŋgal. Nhä dhuwal dhunupa limurruŋ ŋunhi limurr dhu ga rrupiyany gurrupan mundhurryu-wumany ŋanyanhany ŋunhi ŋurruŋunhany buŋgawany Rawumbuywuny wäŋaw yäkuny Djetjanhany? Nhaltjan limurr dhu yulŋuny? Gurrupan? Ŋany nhaltjan?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yurr ŋayipiny Djesuny marŋgithin walalaŋ ŋäthil yan, ŋunhi nhaltjarr walal gan ŋanya mayali'-gäŋal dhä-birrka'yurr, bala ŋayiny Djesuny waŋanan bitjarrnha, “Nhä nhuma dhuwal bäpi mala muka, gali'-märrma mala. Nhaku nhuma ŋarrany ga dhuwal birrka'yundja mayali'-gämany. ");
INSERT INTO djr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Go gurrupul walal ŋarrakal rrupiya ŋaraka, ŋunhi nhuma ŋuli ga bäyim gapmannha, ŋarra mak nhäma.” Bala walal gurrupara nhanukal. ");
INSERT INTO djr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Bala ŋayiny Djesuynydja dhä-birrka'yurra walalany bitjarra, “Yol dhuwal wuŋuḻiny' ga yäkuny dhiyalnydja gay'yi rrupiyaŋur ŋarakaŋur?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ga walalnydja buku-bakmaraŋal bitjarr, “Dhuwaliny yäku ga mali' ŋunhiyin ŋurruŋun buŋgawa Rawumbuywun wäŋaw yäku Djetjan,” bitjarr. Ga ŋayiny Djesuny walalaŋ bitjarra waŋan, “Nhumany roŋanmaraŋun gurrupul nhä malany nhanŋuny ŋurikiyiny buŋgawaw, ga biyakiyi bili roŋanmaraŋdhi God-Waŋarrwuny ŋunhi ŋula nhä malany nhanŋuny.” ");
INSERT INTO djr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Bala walal ŋuriŋiwurruyyiny mayali'-gänhamirriynydja yolŋuy walal ŋäkulnydja ŋanya Djesunhany dhäruktja ṉirr'yurra. Bala walal ŋanya yan ganarrthaŋala Djesunhany, bala yan marrtjinan. ");
INSERT INTO djr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Manymak walalnydja gan ŋunhi Djatutjiynydja malay yaka märr-yuwalkmirrinya ŋunhi dhu gi yolŋu walal walŋathi beŋur ŋunhi dhiŋganhaŋur. Ga ŋuriŋi bili yan waluy, bala walal dhuwalawurryiny mala marrtjinan balan Djesuwala ga waŋan walal ŋanya bitjarra, ");
INSERT INTO djr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Way Marŋgikunhamirr, Mawtjitjthuny ŋunhi rom rulwaŋdhurr bitjarr warray, ‘Ŋunhi dhu ḏirramuny dhiŋgam yothumiriwnydja, nhakun bäyŋuny nhanŋu ŋula walkur, bala nhanukal dhu ŋunhi yukuyuku'mirriŋuynha märram nhanŋu ŋunhi miyalknhany? … märr ŋayi dhu ŋuriŋiyiny miyalkthu yothuny gäma ŋuriki bili yan dhiŋganhawuywu ḏirramuwnydja.’ ");
INSERT INTO djr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Manymak waŋganymirrnydja ḏirramuwurr gan wäwa'manydjiwurr nhinan goŋ-waŋgany ga märrma' bäythinyawuy dhiyal napurruŋgal, ga ŋayiny ŋuriŋiyiny maḻamarryuny wäwa'mirriŋuy märraŋal miyalknhan, bala ŋayi dhiŋgaŋala ŋunhi yothumiriw yan. Bala ŋayi ŋunhi ganarrthaŋalnydja ŋunhiyi miyalknhany nhanukalaŋaw yukuyuku'mirriŋuwnha. ");
INSERT INTO djr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bala beŋuryiny malpuraynha märraŋal ŋunhiyiny miyalknhany, ga ŋayiny ŋunhi bitjarryi bili yan dhiŋgaŋal yothumiriwyi yan. Ga bitjarryi bili ŋunhi maḻŋ'thurr nhanŋuny dhä-gandarrpuywuny. Ga bitjarra bili yan walalaŋ gan ŋunhi bukmakkun maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ga yalalan dhuḏi-yapalan ŋayiny miyalktja dhiŋgaŋal. ");
INSERT INTO djr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ga ŋunhi dhu yolŋuny walal walŋathi dhiŋganhaŋurnydja, bala yolkun ŋayi dhu ŋunhi miyalktja? … bili ŋayi gan ŋunhi nhinanany beŋur bili ŋurruŋuwal wäwa'mirriŋuwalaŋaŋur ga yukuyuku'mirriŋuwal ŋurrkaŋal.” ");
INSERT INTO djr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Bala ŋayiny Djesuny buku-bakmaraŋal bitjarrnha, “Bukmak yan nhuma dhuwal djarrpi'mirr! Bäyŋu yan nhuma dhuwal marŋginy ŋunhi nhaltjan ga ŋunha djorray' ŋuli marŋgikum. Ga yaka yan nhuma marŋgi ŋurikiyiny ŋunhi Godkalaŋawnydja ganydjarrwu. ");
INSERT INTO djr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ŋunhi ŋayi dhu boŋguŋ God-Waŋarryu walŋakuŋuny gi yolŋunhany walalany dhiŋganhaŋurnydja, bäyŋun walal dhu gi ŋunhi buluny märranhamirr. Ŋunhiny walal dhu balanyan nhakun ŋunhi God-Waŋarrwun dhäwu-gänhamirra mala. ");
INSERT INTO djr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ga dhuwandja ŋunhi gämurru' ŋunhi dhu yolŋu walal walŋathi beŋur ŋunhi dhiŋganhaŋurnydja, bäyŋu yan muka nhuma dhuwal ŋäkulnydja dhäwuny, ŋunhi nhaltjarr ŋayi gan God-Waŋarryu lakaraŋal, ŋunhi ŋayi bitjarrnydja waŋan gam', ");
INSERT INTO djr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ŋarrany dhuwal God-Waŋarr Yipurayimgu ga Yitjakku ga Djaykupku.’ Yaka ŋayi ŋunhi God-Waŋarr rakunymirriwnydja yolŋuw walalaŋ, ŋany walŋamirriw yan.” ");
INSERT INTO djr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bala walalnydja ŋunhi yolŋu'-yulŋuny mirithinan dhika ganyim'thurrnydja, ŋäkulnydja ŋanya Djesunhany ŋunhi nhaltjarr ŋayi gan marŋgikuŋal. ");
INSERT INTO djr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ga dhäŋur beŋuryiny ŋunhi ŋayi gan Djesuy ḻiya-wutthurrnydja walalany dhärukthuny nhanukiyingal ŋayi ŋunhi Djatutjinhany mala, bala walalnydja muka Baratjiny mala ḻuŋ'maranhamin, ŋunhi walal ŋäkul dhäwuny nhanukalaŋawuy Djesuwalaŋawuynydja. ");
INSERT INTO djr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Manymak. Ŋunhiliyi gan waŋgany yolŋu nhinan, ŋunhi ŋayi marŋgi mirithirr romgu Djuw-malaw. Bala ŋayi ŋunhi yan birrka'yurra ŋäŋ'thurra ŋanya Djesunhany yan nhakun gan maḻŋ'maraŋal nhanukal bitjarr, ga bitjarra ŋayi ŋanya ŋunhi ŋuriŋiyi ḏirramuynydja ŋäŋ'thurr gam', ");
INSERT INTO djr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Way Marŋgikunhamirr. Nhä dhuwal mirithirrnydja gal'ŋu ŋurruŋuny dhäruk-nhirrpanminyawuy rom ŋunhi ga ŋorra ŋunha romŋurnydja limurruŋgal,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ga ŋayiny Djesuny buku-bakmaraŋal nhanŋuny bitjarra gam', “Märr-ŋamathi gi nhokalaŋaw Garraywuny God-Waŋarrwuny bukmakthu yan nhokiyingal nhe ŋayaŋuynydja ga mirritjalyuny ga guyaŋanhawuyyuny.” ");
INSERT INTO djr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dhuwanna ŋayi ŋunhi mirithirrnydja gal'ŋu ŋurruŋuny dhäruk-nhirrpanminyawuy rom. ");
INSERT INTO djr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","“Ga beŋuryiny dhuwanna rom ŋunhi ŋurruŋuwalnydja bitjanna ga waŋa gam', ‘Märr-ŋamathi gi ŋunha wiripuwurruŋguny yolŋuw walalaŋ, biyak nhakun nhe ŋuli ga ŋunhi nhuŋuwuy nhe märr-ŋamathirr.’ ");
INSERT INTO djr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bili bukmak ŋunhi nhämunha rom nhanukuŋuny Mawtjitjkuŋuny gurrupanawuy ga wiripu mala djorra' ŋunhi djawarrkmirriwuŋ wukirriwuy. Dhipuŋuryin ga ŋunhi märrma'ŋura maṉḏanyŋuŋur romŋur dhä-barrkuwatjthirrnydja ga märrma'lila yan dhäruk-nhirrpanminyawuylil romlil dhä-manapan, ga bilin.” ");
INSERT INTO djr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ga baḏak yan walal gan ŋunhi Baratjiny mala nhinan ŋunhili banydji yan, bala ŋayiny Djesuynydja dhä-birrka'yurra walalany bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Nhaltjan nhuma ga guyaŋany ŋanya ŋunhi Maŋutji-dhunupayanhawuynhany yolŋuny? Yolkal yarraṯaŋur ŋayi dhu bunanany?” Bala walalnydja bitjarr warray buku-bakmaraŋal gam', “Beŋur ŋayi dhu ŋunhi yarraṯaŋurnydja Geŋ-Daybitkal.” ");
INSERT INTO djr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Bala ŋayiny Djesuny bitjarra buku-bakmaraŋal gam', “Ga nhakun ŋunhi ŋayiny Dhuyu-Birrimbirryuny ganydjarr gurrupar ŋanyanhany Daybitnhany ŋunhi ŋayi bitjarrnydja lakaraŋal ŋanya ŋunhi Maŋutji-dhunupayanhawuynhany ŋunhi ŋayiny nhanŋu Garray? Bili ŋayi bitjarra ŋunhi Daybittja waŋan gam', ");
INSERT INTO djr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bala ŋayi Garraynydja waŋan ŋarrakalaŋuwal Garraywal bitjarra: Dhiyala nhininy ŋarrakala dhunupaŋura gali'ŋurnydja ga bäy ŋarra dhu miriŋuny mala nhuŋu ḻukulila nhokal rulwaŋdhun ŋoylila.’” ");
INSERT INTO djr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ga ŋuli ŋayi ŋunhi Daybitthu lakaraŋal ŋunhi nhanŋu ŋayi Maŋutji-dhunupayanhawuynydja Garray, ga nhäpuynha ŋayiny ŋunhi Maŋutji-dhunupayanhawuynydja nhanŋuny be Geŋ-Daybitkuny gäthu'mirriŋu?” ");
INSERT INTO djr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ga bäyŋun ŋula waŋganydhu buku-bakmaranha dhäruk nhanŋu Djesuw, ga bäyŋun ŋanya ŋula buluny yolŋuy rrorru' dhärukthu nhanukiyingal. ");
INSERT INTO djr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Bala yan ŋayi Djesuny waŋanan ŋurikiwurruŋguny dharrwawnydja yolŋu'-yulŋuw ga wiripuny nhanukiyingalaŋuw malthunamirriw walalaŋ, bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ŋunha walalnydja Baratjiny mala ŋaḻapaḻmirr ga ŋunhawurr ŋunhi Rom Marŋgikunhamirrnydja mala mirithirr walal gaḏaman ŋurukuny ŋunhi Mawtjitjkalaŋawnydja Romgu malaŋuw. ");
INSERT INTO djr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ga nhumany dhu ga walalany dhäruk-märram bukmakŋur yan ŋunhi nhaltjan walal dhu ga marŋgi-wurrupan nhumalany, yurr yakan walalaŋ romguny walal malthurr, bili walal ŋuli ga ŋunhi milkumany wiripun dhika romdja malany, yakan ŋamakurr ga dhunupa, gänaŋ'thunna ga beŋurnydja ŋunhi dhuwurr-lakaranhaŋurnydja walalaŋgiyingalaŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ŋunha walal ŋuli ga mirithirr ŋonuŋ rom malany ḻambarrlil ŋal'maram yolŋuwal walalaŋgal, yurr bäyŋun walal ŋuli gi ŋula goŋ-djarryurrnydja ga yuwalkkuŋuny walalany guŋga'yurr bäyŋun yan. ");
INSERT INTO djr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Bukmak yan nhä malany walal ŋuli ga ŋunhi djäma, ŋunhiyiny walal ŋuli ga djämany melwu yan yolŋuw, yan nhakun ga ḻay-ḻaymaranhamirra. Wiripuny walal ŋuli ga mirithirra yan ḻanydjatmaranhamirr, ŋunhi walal ŋuli marrtji nhirrpanna God-Waŋarrwuny dhäruk mala muḻkurrlila walalaŋgiyingal ga wiripuny waṉalila ga gämany walal ŋuli ga yindin mala bukumirriyanhawuynydja manydjarrka' mala, märr dhu ga yolŋuynydja walal nhäman walalany. ");
INSERT INTO djr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ga ŋunhalnydja ŋunhi yindiŋurnydja buŋgulŋur malaŋuŋur, yindi walal djäl walal dhu ga märram manymak yan nhinanhawuy mala, ŋunhalnydja ŋunhi Djuw malawalnydja buku-ḻuŋ'thunamirriŋurnydja buṉbuŋur mala. ");
INSERT INTO djr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ga ŋunhi walal ŋuli balany marrtji girriwny'tja märranharaw ga ŋathawnydja, walalnydja ŋunhiwurrnydja yindi djäl walalaŋ dhu ga yolŋu walal gumurr-ŋamathirr, ga buŋgawan lakaram walalany ga wiripuny marŋgi-gurrupanamirra ga lakaram.” ");
INSERT INTO djr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Yurr nhumany dhu ga ŋunhi yakan lakaranhamirr yanbi nhuma dhuwal marŋgi-wurrupanamirr mala. Bili waŋgany yan nhumalaŋ dhuwal marŋgi-wurrupanamirrnydja. Bili nhumany dhuwal warrpam' balanyan nhakun wäwa'manydjiwurra ga yapa'manydjiwurra. ");
INSERT INTO djr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ga bäyŋu yan nhuma dhu ga dhiyalnydja munatha'ŋurnydja ŋula yolnhany Bäpa'yun, bili waŋgany yan nhumalaŋ dhuwal bukmakku Bäpa'mirriŋuny ŋunhi ŋayi ga nhina ŋunha Djiwarr'ŋur. ");
INSERT INTO djr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ga bäyŋu yan nhuma dhu ga ŋurruḏawalaŋu lakaranhamirrnydja, bili waŋgany yan nhumalaŋ dhuwal ŋayipi ŋurruḏawalaŋuny ŋunhiyi ŋunhi ŋayi Maŋutji-dhunupayanhawuy. ");
INSERT INTO djr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ga ŋunhi ŋayi dhu ga ŋula yol yolŋu buŋgawakunhamirrnydja ŋurruŋuny ŋathil ŋayi dhu djämamirriyirr. ");
INSERT INTO djr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ga ŋuli nhe dhu ga garrwarkunhamirrnydja nhunapinya nhe wiripuwurruŋguny, nheny dhu ŋunhi yarrupthunna. Yurr ŋuli nhe dhu ŋunhi nyilŋ'maranhamirrnydja nhunapinya nhe, nheny dhu ŋunhi märraman wokthunamirrnydja rom.” ");
INSERT INTO djr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Yo, nhuma ŋunhi Baratjiny yolŋu mala, ga rom-marŋgikunhamirrinydja mala, ŋunhi nhuma ŋuli ga marŋgikum rom malany Mawtjitjkuŋ nhirrpanawuy, nhumany dhuwal mariŋura! Bäyŋun nhuma dhuwal ḻanydjat-ḏilkurra mala balanyan. Dhuwal nhuma ŋuli ga dhaḻ'-dhaḻyun yolŋuw walalaŋ gärrinyaraw bala ŋunhi God-Waŋarrwal romlil. Ga nhumapiny dhu ŋunhi yaka warray gulŋiyi ŋunhiwiliyiny wäŋalil, wiripuwurruŋ yan nhumany ŋuli ga nhina baku-ŋayathanharaw, märr walal dhu yaka märram ŋunhiyi manymak rom.” ");
INSERT INTO djr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Yo, nhuma Baratjiny yolŋu mala ga rom-marŋgikunhamirrinydja mala, ŋunhi nhuma ŋuli ga marŋgikum rom malany Mawtjitjkuŋ nhirrpanawuy, nhumany dhuwal mariŋura! Bäyŋun nhuma dhuwal ḻanydjat-ḏilkurra mala balanyan. Dhuwal nhuma ŋuli ga ḏiltjikurrnydja marrtji ga buḏapthun gapukurrnydja nhaku, waŋganygu yan yolŋuw märranharaw, ŋayi ŋuli bilyun ga märram Garraynha nhanukiyingal ŋayi walŋay. Ga ŋunhi nhuma ŋuli dhawar'yundja nhanukalaŋaŋur, bala nhuma ŋuli ga ŋanyanhany muka waŋa raypirri'yun märr ŋayiny muka dhu nhäri gurthaŋur ŋunhiliny dhä-gir'yunamirriŋurnydja wäŋaŋur.” ");
INSERT INTO djr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Bilin muka yindiŋura nhuma mariŋur! Nhä nhuma dhuwal yulŋuny bambaymirr mala? Be muka nhuma balaŋ ganha dhuwal ŋunha wiripuwurrunhany yolŋu'-yulŋuny waṉa-gänhany manymaklila romlil. Ga dhuwal nhuma ŋuli ga marŋgi-wurrupandja walalany yanbi dhuwal manymak yolŋuw ŋayi dhu guykthun ŋuruŋ yäkuy ŋunhi buku-ŋal'yunamirriynydja buṉbuy. Ga waŋany nhuma ŋuli ga bitjanna gam', ‘Bäydhi manymak ŋunhi ŋayi dhu ŋula yolthuny guykthun ŋuruŋuny ŋunhi mel-wiḏi'mirriynydja bulayyu yäku-ḻakaranharay ŋunhiŋuwuyyi Buku-ŋal'yunamirriwuynydja Buṉbupuyyu.’ ");
INSERT INTO djr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nhä dhuwal nhuma bambaymirr? … bawa'mirr mala! Nhä ŋayi ŋunhi mirithirrnydja gal'ŋu mel-wiḏi'mirr? … ŋunhiyi bulay wo ŋunha Buku-ŋal'yunamirra Buṉbu Ŋärran', ŋunhi ŋayi ŋuli ga dhuyukuman ŋunhiyi bulaynhan?” ");
INSERT INTO djr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ga wiripuny nhuma ŋuli ga bitjan marŋgi-wurrpan yolŋuny mala, yanbi ŋunhi manymak, ŋayi dhu yolŋuy guykthun ŋuruŋuny ŋunhi bulaymirriynydja djimukuy'. Yurr nhumany ŋuli ga ŋunhi bitjan warray waŋa, bäydhi manymak ŋunhi dhu ga yolŋuy guykthun ŋuruŋuny ŋunhi mundhurryuny ŋunhi ga gorrum ŋunhili djimuku'ŋur bulaymirriŋur ŋunha buku-ŋal'yunamirriŋur buṉbuŋur. ");
INSERT INTO djr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nhä nhuma dhuwal bambaymirr mala muka? Nhä ŋayi ŋunhi mirithirrnydja gal'ŋu ŋurruŋu, ŋunhiyi mundhurr? … wo ŋunhiyi djimuku' bulaymirr? … ŋunhi ŋayi ŋuli ga ŋunhiyin mundhurrnha ŋorra ŋunhiliyin? ");
INSERT INTO djr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ŋuli ŋayi dhu ŋunhi ŋula yolthu yolŋuy guykthundja ŋuriŋiyiny ŋunhi djimukuy' bulaymirriynydja, ŋunhiyiny nhakun ŋayi dhu bukmakkuman yan guykthun ŋunhi nhä malany ga ŋorra ŋunhiliyi buku-ŋal'yunamirriŋur buṉbuŋur, ");
INSERT INTO djr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ga wiripuny ŋayi ŋunhi guykthurr ŋanyanhan God-Waŋarrnhan ŋunhi ŋayi ŋuli ga nhinan nhakun ŋunhiliyin. ");
INSERT INTO djr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ga ŋuli ŋayi dhä-wapthurr ga guykthurr ŋayi ŋuruŋuny djiwarr'yuny wäŋay, ŋunhiny nhakun ŋayi guykthurryi nhanukalnydja God-Waŋarrwalnydja nhinanhawuyyu, ga wiripuny ŋurikalnha ŋunhi ŋayi ŋuli ga nhina ŋunhiliyin nhinanhawuyŋura. ");
INSERT INTO djr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nhumany dhuwalawurrnydja ḻanydjat-ḏilkurr mala, melwun yan nhuma ŋuli ga dhuwal djämany yolŋuwnha walalaŋ. Dhuwal nhuma ŋuli ga God-Waŋarrwuny gurrupan ŋula nhä malany ŋathaw bathanaraw dhäkaymirriyanharaw mala, ga wiripuny nyumukuṉiny man'tjarr mala ŋathaw dhäkaymirriyanharaw, ga mirithirr nyumukuṉiny'nha maŋutji yäku gamin, yurr mala-wulkmaranhawuy ŋayi ŋunhi yulŋuny goŋ-märrma'lil beŋurnydja ŋunhi gätniŋurnydja mala nhumalaŋgal. Yurr ŋunhany ŋunhi ŋurruŋuny mala gämurru' nhuma ŋuli ga baykarraraman ga gali'lila nhirrpan, balanyany mala gam', nhakun dhuwurr-dhunupany rom, ga mel-wuyunamirrnydja rom ga märr-ŋal'yunamirrnydja rom, ga rom ŋunhi maḏayin'kurr ŋuli ga djäma ga mägayakurr. Dhuwanna mala ŋunhi ŋurruŋuny gämurru' mala, nhumany balaŋ ganha ŋunhiyiny mala djäma yan, bitjanayi bili bukmakkunha yan, yaka balaŋ nhuma ganha ḻurrkun' yan djäma, ga wiripuny mala dhärun ganarrthanha. ");
INSERT INTO djr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nhumany dhuwal bambaymirr mala waṉa-gänhamirr mala! Dhuwal nhuma ŋuli nyumukuṉiny'nhany wurruḻuḻnha gaṯmaram yan, yurr yindinhany warrakan'nha gämuḻnhany nhuma ŋuli ḻukan mamuḻyunna.” ");
INSERT INTO djr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nhumany dhuwal Baratjiny mala ga rom-marŋgikunhamirrnydja mala ḻanydjat-ḏilkurra mala, melwun yan nhuma ŋuli ga dhuwal djäma yolŋuwnha walalaŋ, ga mariŋurnydja nhuma dhuwal yindiŋura! Yo, rurrwuyundja nhuma ŋuli ga dhuwal banikin' mala nhumalaŋguwuy nhuma dhuwal ŋapaŋur yan warraŋul yan, yurr djinawany' nhumalaŋgal ŋayaŋuŋurnydja ḻäy-ḏälnha ga wanaŋa-ḏumurruyinyamirra rom ga lalkalnha. ");
INSERT INTO djr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bambaymirr mala nhuma Baratji mala, ŋunha ŋathil djinawa' banikin'tja nhuŋuwuy nhe rurrwuyurr bala ŋayiny dhu ŋunha warraŋulnydja ga bitjandhi bili ḏarrtjalkthirryi.” ");
INSERT INTO djr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nhumany Baratjiny mala ga marŋgikunhamirrnydja mala, mariŋura muka nhuma! Bäyŋu nhuma dhuwal ḻanydjat-ḏilkurra mala balanyan, melwun yan nhuma ŋuli ga dhuwal djäma yolŋuwnha walalaŋ. Balanyan dhuwal nhumany nhakun ŋunha molu mala rurrwuyunawuynha be ḏarrtjalkkunhawuynha biḏi'yunawuynha yuṯan miny'tji ŋal'yurr. Ŋunhany warraŋulnydja latjun dhika, buŋgawayirra ga dhärra, yurr ŋunhany djinawany' ga dharrwan mirithirra ŋaraka mala ŋorra'-ŋurra ga barrpan'. ");
INSERT INTO djr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ga balayanyin nhumany dhuwal, nhakun ŋunhiyin molun mala. Warraŋulnydja nhuma manymak mirithirr, yurr ŋunhany djinawany' ŋayaŋuny nhumalaŋ yätjkurra barrpan', dhuwurr-yätjnha, ga yänan nhuma ŋuli ga ŋunhi ḻay-ḻaymaranhamirra manymak-lakaranhamirrnydja.” ");
INSERT INTO djr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nhumany dhuwal Baratjiny ga marŋgikunhamirrnydja mala ḻanydjat-ḏilkurra yan, ga mariŋura nhuma dhuwal yulŋuny. Dhuwal nhuma ŋuli ga dhuḻyun molu malany wuŋiḻi'mirriyam ŋunhi ŋäthiliŋuwalnydja djawarrkmirriwal mala, ga bitjandhi bili nhuma ŋuli djäma latju'-latjukumdhi molu ŋunhi manymakmirriwnydja yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Bala nhuma ŋuli ga ŋunhi lakaranhamirra, ŋunhi nhumany dhuwal yaka balanya ŋayaŋu mala nhakun ŋunhi mala-ŋurrkanhayŋu mala nhumalaŋ, ŋunhi walal gan bumar murrkay'kuŋal ŋunhiyi djawarrkmirriny mala. ");
INSERT INTO djr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yurr yuwalknha yan nhuma ŋuli ga ŋunhi milkunhamirrnydja nhumalanhawuynha nhuma, ŋunhi nhumany dhuwal gurruṯumirr mala ŋurikiwurruŋdhin yolŋuw walalaŋ ŋunhi walal gan bumar ŋunhiwurruny djawarrkmirriny mala. ");
INSERT INTO djr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gatjuy biyakiyin bili yan romdja, nhakun walal gan nhumalaŋgal mala-ŋurrkanhaŋuy mala djäma. ");
INSERT INTO djr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bäyŋun nhuma dhuwal bäpin mala, ga djamarrkuḻiny' nhuma dhuwal ŋurikiwurruŋdhin bäpiwnha mala. Nhumany ga dhuwal bitjanna guyaŋa yanbi nhuma dhu boŋguŋ bäyŋu marrtji bala ŋunhi dhä-gir'yunamirrililnydja wäŋalil? ");
INSERT INTO djr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ŋarrany dhu dhuwal djuy'yurr djawarrkmirrinhan mala nhumalaŋgal ga ḻiya-djambatjmirrinhan ga gaḏamannhan mala ŋuruk ŋunhi Mawtjitjkalaŋawnydja romgu lakaranharaw. Yurr nhumany dhu buŋu warray walalany murrkay'kuŋ, wo dharpalil ŋal'maraŋ mälakmaranhawuylil, wiripuny nhuma dhu marrtji buŋu walalany ŋunhilin ŋunhi Djuw malawalnha buku-ḻuŋ'maranhamirriŋura buṉbuŋur malaŋuŋur, ga ŋupulnydja muka walalany ŋaŋ'ŋaŋ'thurrnydja gi wäŋaŋurnydja malaŋuŋur birrka'mirriŋura yan. ");
INSERT INTO djr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ga dhiyakiyin märrwu nhumany nhakun dhuwal moṉu'-muṉuŋun ŋunhi manymakmirriwnydja yolŋuw walalaŋ, ŋurruyirr'yun ga nhanukal manymakkal yolŋuwal yäkuwal Waybulwal. Ga wiripuny nhanŋu Baratjiyaw gäthu'mirriŋu Djakaraya, ŋunhi nhuma ŋanya murrkay'kuŋal wutthurr ŋunhili ṉapuŋga' galki buku-ŋal'yunamirr buṉbu ga djimuku' bulaymirr gan dhärran. ");
INSERT INTO djr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Märr-yuwalk ŋarra nhumalany ga dhuwal dhawu'-nhirrpandja dhä-gir'yunarawnydja nhumalaŋ dhiyakuwurruŋguny yolŋuw walalaŋ gay'yi bukmakpuy yan ŋunhi nhä malany nhuma gan yätjkurr malany djäma.” ");
INSERT INTO djr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Djurutjalam Djurutjalam! Nhuma yolŋu walal wäŋa-Djurutjalambuy, dhuwal nhuma gan bumar rakunyguŋal yan djawarrkmirriny mala, ga bulu nhuma gan guṉḏanydja muka bumar ŋunhi djuy'yunawuynhany mala. Ga ŋarrany gan ŋunhi mirithin yan djälthinany ḻuŋ'maranharawnydja nhumalaŋ bitjan nhakun djukitjukiy ŋuli ga ḻuŋ'maram nhanŋuwuy ŋayi yothuny mala binbarryu nhanukiyingal ŋayi. Yurr nhumany gan ŋunhi yaka warray djälthinya ŋarraku ŋarra dhu ga djäga nhumalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ga dhiyaŋuny bala nhuŋu dhu buku-ŋal'yunamirrnydja buṉbu ga dhärra wiraŋnha yan yolŋumiriwnha.” ");
INSERT INTO djr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","“Ga yakan nhuma dhu buluny ŋarrany nhäŋu, ga yan bili ga balanyamirriynha waluy ŋunhi nhuma dhu biyakun waŋi gam', ‘Yo! Marrkapmirr, dhuwanna ŋayi ŋunhiyiny ŋunhi ŋayi ga marrtjin rälin Garraywala yäkuynydja.’” ");
INSERT INTO djr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ga ŋunhi ŋayi Djesuy ganarrthaŋalnydja ŋunhi buku-ŋal'yunamirrnydja buṉbu, ga walalnydja nhanŋu ŋunhi malthunamirrnydja mala waŋan bitjarra, “Way Marŋgikunhamirr, nhäŋu ŋathil dhuwal buṉbu ya dhuwal. Nhän dhuwandja buṉbu yindin mirithirra ga latjun' muka?” ");
INSERT INTO djr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ga ŋayiny Djesuny waŋan walalaŋ bitjarr, “Nhäma nhuma ga dhuwaliyi yindi mirithirr buṉbu mala. Galki dhu dhuwaliyiny ḏaw'yurra buḻ'waŋdhurra dhu. Ga bäyŋun dhu ga ŋula waŋganydja guṉḏa dhärra ŋapa-ŋal'-ŋalmaranhawuynydja.” ");
INSERT INTO djr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ga dhäŋur beŋuryiny ŋayiny gan Djesuny ŋunhi nhinanan ŋunhalnha bukuŋura yäkuŋur Wolipnha, ŋunhi maṉḏa gan ḻaypa'yunmin God-Waŋarrwu buku-ŋal'yunamirr buṉbu. Bala walalnydja ŋunhi malthunamirrnydja mala nhanŋu marrtjinan guwatjmara ŋanya, bala walal dhä-birrka'yurra ŋanya gayulnha bitjarra, “Way nhätha dhika ŋayi dhu bitjandhiny maḻŋ'thun? Nhä dhika ŋanapurr dhu nhämany, ŋunhi ŋayi dhu maŋutji-lakaramany nhuŋuny bunanharaw, ga dhiyakuny wäŋawnydja dhawar'yunaraw?” ");
INSERT INTO djr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ga ŋayiny Djesuny buku-bakmaraŋal bitjarra, “Bira'yurra walal gi nhininy, märr nhumalany dhu yakan ŋula yolŋuynydja mayali'-gama. ");
INSERT INTO djr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Dharrwan dhu ga ŋunhi yolŋuny walal lakaranhamirrnydja nhumalaŋgal yanbi walalnydja ŋarran, ga lakaranhamirr walal dhu ga yanbi walal ŋunhiyin Maŋutji-dhunupayanhawuynha. Ga bäkiny walal dhu gi ŋunhi yäkuny ŋarranhan, ga bawa'-gurrupulnydja walal dhu gi ŋunhi dharrwanhan yolŋunhany walalany. ");
INSERT INTO djr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ga ŋuli nhuma dhu ga ŋunhi bunhaminyawuynydja ŋäma, yaka walal ŋuriŋiyiny mala ŋoy-gärri. Balanyayi mala dhu marrtji ŋunhi ŋurruŋuny maḻŋ'thun, yurr ŋunhiyiny yaka yan dhä-dhawar'yunamirrnydja walu. ");
INSERT INTO djr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yo, bawalamirriŋura wäŋaŋur ŋarakaŋur dhu marrtji ŋunhi bäpurruny mala bunhamirra, ga nhä mala ŋunhi rom dhuwalaŋuwuy munatha'wuy bitjandhi bili dhu marrtji bunhamirra. Ga yolŋuny walal dhu marrtji ŋunhi marryayny'tja murrmurryurra. ");
INSERT INTO djr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yurr dhuwaliyiny ŋurruyirr'yunna ga ŋunhi ŋayaŋu-yätjinyamirra rom mala.” ");
INSERT INTO djr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Nhumalanhany walal dhu ŋunhi gäŋuny balan dhä-birrka'yunarawnha, bala walal dhu gi nhumalany bartjunmaraŋun ga wiripuny nhumalany walal dhu buŋun murrkay'kuŋun, ga bukmakthun dhu gi ŋunhi yolŋuynydja walal nhumalany nyamir'yurra, ga ŋaramurryin gi nhumalaŋguny, bili nhumany dhuwal ŋarrakalaŋumirr mala. ");
INSERT INTO djr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dharrwan dhu ŋunhi yolŋu walal ŋarrakuny ḏiltji-gurrupanmirr, bilyurra ŋarrakalaŋaŋurnydja bala walal dhu gulyurra märr-yuwalkthinyaŋurnydja ŋarrakal, bala walal dhu gi nyamir'yunmirra. ");
INSERT INTO djr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ga dharrwan dhu ŋunhi nyäḻny'tja djawarrkmirr mala maḻŋ'thurr ga bawa'-gurrupulnydja walal dhu gi ŋunhi dharrwa'nhan yan yolŋunhany walalany. ");
INSERT INTO djr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yo yätjkurrnydja dhu rom ŋunhi ḻatjuwarr'yurra bawalamirrilila, ga dharrwan dhu gi ŋunhi yolŋuny walal yakan nhakun buluny märr-ŋamathi wiripuwurruŋguny yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ga ŋunhi ŋayi dhu ga ŋula yolthu yolŋuy ŋarranhany yan ŋayatham baṯ-bitjandja, ga yan bili-i-i-i ga dhä-dhawar'yunamirriy waluy, ŋayiny dhu ŋunhi ŋunhiyiny yolŋu walŋathirra. ");
INSERT INTO djr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ga ŋurruŋuny ŋathil dhu gi ŋunhi dhäwu manymak God-Waŋarrwalaŋuwuy rombuy ḻatjuwarr'yurr bawalamirrilil yan wäŋalil, ga bukmakthu yan bäpurruynydja dhu ŋunhi ŋäkuny ŋarrakalaŋawuynydja, ga yorrnha dhu ŋunhi dhä-dhawar'yunamirrnydja walu maḻŋ'thurr.” ");
INSERT INTO djr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Yo bawalamirriynydja nhuma dhu ŋunhi nhäŋun ‘Ŋunhiyinhany Yätjkurrunhany’ ŋayi dhu gi dhärriny ŋunhiliyin dhuyuŋura buṉbuŋurnydja. Ga maḻŋ'thurrnydja ŋayi dhu ŋunhi biyak yan bili ŋunhi nhaltjarr ŋayi ŋäthil God-Waŋarrwal djawarrkmirriy yäkuy Danyulyu wukirri. Ŋuli nhe ga ŋula yolthu maŋutji-ḻaw'maramany dhuwal dhäruktja, marŋgithin yan ga dharaŋula.” ");
INSERT INTO djr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Yo ŋunhi nhuma dhu gi nhini Djudiyany wäŋaŋur balanyamirriyiny, waṉḏi'-waṉḏin walal balan bukulila. ");
INSERT INTO djr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ga ŋuli nhe dhu ga nhina warraŋul ŋapaŋur wäŋaŋur nhokiyingal nhe, yakan roŋiyi buṉbulilnydja ŋula nhäny girriny' mala nhuŋuwuy nhe wapmaraŋ, bäyŋun. ");
INSERT INTO djr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ga ŋuli nhe ga djäma ŋatha guḻun'ŋur, yakan roŋiyi girriwny'tja nhokalaŋaw. ");
INSERT INTO djr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ga yätjkurra dhu boŋguŋ ŋunhi mirithirra ŋurikiny miyalkku ŋunhi ŋayi dhu gi guḻundhu gäŋu yuṯa yothu, ga bulu yothu-yalŋgimirriwnydja miyalkkurruwurruŋ. ");
INSERT INTO djr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bukumirriyaŋun gi God-Waŋarrwala, märr ŋayi dhu yaka ŋunhi mala maḻŋ'thurr dharratharramirriynydja waluy wo Nhinanhamirriynydja Waluy. ");
INSERT INTO djr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bili dhuwaliyiny ŋunhi mari dhu boŋguŋ maḻŋ'thurr yindin yan mirithirra ŋoy-gärrinyamirra, ŋunhi ŋayi bäyŋu ŋäthil balanyayi maḻŋ'thurr ŋuruŋ bala waluy ŋunhi ŋayi God-Waŋarryu ŋurruŋu bokmar dhuwal wäŋany. Ga bäyŋun bulu ŋayi dhu boŋguŋ balanyayi mari yindi maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ga ŋuli ŋayi dhu boŋguŋ God-Waŋarryu yakany ŋunhi walu dhumbuḻ'kuŋ, ŋayiny dhu boŋguŋ ŋunhi bäyŋun ŋula yol waŋgany yolŋu nhini walŋa. Yurr God-Waŋarryuny boŋguŋ ŋunhiyiny walu gandarr-wutthurr dhumbuḻ'kuŋ, bili ŋayi ga nhäma ŋunhi yolŋuny mala nhanŋuwuy ŋayi djämamirriny walalany.” ");
INSERT INTO djr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ga ŋuli dhu ŋula yol waŋi biyakuny gam', ‘Way, dhuwanna ŋunhiyiny Maŋutji-dhunupayanhawuynydja yolŋu,’ wo ‘Ŋunhan bala ya ŋunha,’ biyakuny, yakan nhanŋu ŋurikiyiny märr-yuwalkthi. ");
INSERT INTO djr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yolŋuny walal dhu ŋunhi nyäḻnydja maŋutji-dhunupayanhawuy mala ga djawarrkmirr mala maḻŋ'thurra, ga marrtjiny walal dhu ŋunhi bala djäman gi ŋayaŋu-ganyim'thunamirra romdja mala, ŋunhi dhu gi bilmaraŋun bawalamirrinhan yolŋunhany walalany, ga wiripuny Garraywalaŋumirrinhan mala. ");
INSERT INTO djr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bala ŋarra ga dhuwal nhakun djägakuman nhumalanhany dhä-ŋäthilyi.” ");
INSERT INTO djr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ga ŋuli walal nhumalaŋ dhu lakaram ŋunhi Maŋutji-dhunupayanhawuynhany yolŋuny balany ŋunha gapu-ranhdhaklilnydja wäŋalil, nheny yakan balayiny marrtji. Ga ŋuli walal nhuŋu dhu lakaram ŋanya ŋula wanhawalnydja wäŋalil, nheny yakan yan märr-yuwalkthi. ");
INSERT INTO djr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nhanŋuny dhu boŋguŋ ŋunhi Yolŋuwnydja Gäthu'mirriŋuw walu maḻŋ'thurr biyakun nhakun ŋuli ŋunhi baḏayala' djaḻkarr'yun.” ");
INSERT INTO djr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Ŋunhi wanha dhu ga barrpa' ŋorra, ŋunhiwiliyin dhu ga ŋunhi wäktja mala ḻuŋ'thun.” ");
INSERT INTO djr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Manymak, beŋurnydja ŋunhi dhurrwaraŋur yindiŋurnydja mariŋur ŋayiny dhu waluny munha'yurra, ga ŋaḻindiny dhu ŋunhi bäyŋun buluny djeŋarra'yi, ga ganyuny mala dhu warrpam'thurra burrul'yurra. Ga bukmaknha dhu ŋunhi ganydjarrnydja mala ŋunhany ŋunhi garrwarŋurnydja wäŋaŋur dhu marrtji ḻarryurra winya'-winyayurra dhu, dhawaṯmaraŋun walalany dhu wäŋaŋurnydja mala walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ga dhunupan dhu ŋunhi Yolŋuny Gäthu'mirriŋu yarrupthurra rälin. Ga bukmaknha dhu ŋunhi yolŋuny walal marrtji ŋäthinyamirra, ŋunhi walal dhu nhäŋuny ŋanya Yolŋunhany Gäthu'mirriŋuny ŋayi dhu marrtji yarrupthurrnydja räli maŋandhuny ganydjarryuny yindiynha ga djeŋarra'mirriynha. ");
INSERT INTO djr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bala dhu ŋunhi djiwarr'wuynydja yiḏaki ḏopthurra, bala ŋayi dhu djuy'yurra nhanŋuwuy ŋayi djämamirrinhany walalany djiwarr'wuynhany mala walal dhu boŋguŋ marrtjin bala marrtji ḻuŋ'maraŋun nhanŋuny yolŋuny walalany gänaŋ'maranhawuynhany walalany dhipuŋurnydja wäŋaŋur munatha'ŋurnydja ḻika-ḻikanŋurnydja beŋur dhimurruŋur ga bala bärra'lil ga beŋur bala ḻuŋgurrmaŋur ga djalathaŋŋur bukmakkuŋun yan warrpam'thurra.” ");
INSERT INTO djr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Bala ŋayi Djesuy lakaraŋala dhäwun mayali'kurra bitjarra gam', “Guyaŋi ŋathil dharpany ŋunhi genydjany'. Ŋunhi nhe ŋuli nhäma yuṯany marwat dhamany'tjunawuynydja bala nhe ŋuli yan marŋgithirra ŋunhi waluny galkin borummirra. ");
INSERT INTO djr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ga balanyawuyyin nhe dhu ŋunhi nhämany, bala nhe dhu yan marŋgithirra ŋunhi waluny bilin galkin. ");
INSERT INTO djr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yorrnha nhuma dhu marrtji ŋunhi dhuwalawurrnydja dhiŋgu'-dhiŋguŋ, ŋayiny dhu gi ŋunhi dhuwandja rom mala milma yan nhumalaŋgal maḻŋ'thurr ŋunhi nhä ŋarra gan lakaraŋal nhumalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dhuwandja dhu ŋunhi garrwarnydja wäŋa ga dhuwal munathany' dhu buwayakthin, yurr dhäruktja ŋarraku dhu bäyŋun buwayakthi.” ");
INSERT INTO djr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Bäyŋun dhuwal yolŋu bukmak marŋgi ŋurikiyiny waluw. Ŋunha ŋunhi God-Waŋarrwu dhäwu-gänhamirr mala ga ŋayi Gäthu'mirriŋu Yolŋu bäyŋuyi yan marŋgi, ŋayipin yan ŋunhi Bäpa'mirriŋun marŋgi ŋurikiyiny waluw. ");
INSERT INTO djr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ŋuli dhu boŋguŋ ŋunhi Yolŋuwnydja Gäthu'mirriŋuw waluny buni, ŋunhiny ŋayi balanyan bili yan nhakun Nawamirriynha waluy dhu maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Manymak, yolŋuny walal gan ŋunhi ḻay-ḻayyurra ḻukanan gan ŋathan ga märranhaminan gan, yän bili ga ŋunhin walu bunan ŋunhi ŋayi ḻupmaraŋala dhuwandja munatha'nhany wäŋany, bala ŋayiny Nawany gulŋiyinan ŋunhiwiliyin yindilila marthaŋaylil. ");
INSERT INTO djr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Bäyŋun walal gan ŋunhi nhäŋal dharaŋar ŋunhi nhä marrtjin maḻŋ'thu-maḻŋ'thurr ga yän bili ga gapu ŋunhi yindi bunan, bala yan walalany ḻupmaraŋala djaw'yurr warrpam'nhan. Ga biyakiyin ŋayi dhu boŋguŋ ŋunhi Yolŋuwnydja Gäthu'mirriŋuw walu maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Märrmaynydja dhu gi ḏirramuy djäma waŋganyŋur guḻunŋur ŋathamirriŋur, yurr waŋganynhan yan ŋayi dhu djaw'yurrnydja, ga wiripunhany ŋayi dhu ganarrthula dhipala banydji. ");
INSERT INTO djr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ga märrmay' miyalkthu maṉḏa dhu gi djäma ŋatha buḻŋu'kuŋ, ga waŋganynhan yan ŋayi dhu djaw'yurrnydja ga wiripunhany ŋayi dhu ganarrthula dhipala banydji.” ");
INSERT INTO djr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Gatjuy bira'yurra gi nhininy, bili yakan nhe marŋgi ŋurikiyiny waluw ŋunhi dhu Garraynydja buni. ");
INSERT INTO djr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Buṉbu waṯaŋuny dhuwal yolŋu yaka marŋgi ŋunhi nhätha nhanukal dhu ŋunhi manaŋa-ḏumurr yolŋu gulŋiyirr wäŋalil, bala ŋayi ŋuli ga ŋunhi bira'yunna yan nhinany djägan ga wäŋawnha nhanukiyingalaŋaw, märr ŋayi dhu yakan ŋunhiyiny yolŋu manaŋa-ḏumurrnydja gulŋiyirr. ");
INSERT INTO djr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gatjuy biyakun bili gi nhininy bira'yurra yan, bili yakan nhe dhuwal marŋgi ŋunhi nhätha ŋayi dhu ŋunhi Yolŋuny Gäthu'mirriŋu roŋiyirr.” ");
INSERT INTO djr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Yolnha, mala dhika djambatjtja ga malthunayŋuny djämamirr walal. Yolkal malaŋuwal ŋayi dhu dhika Buŋgawa'mirriŋuynydja dhayuŋan djämany nhanŋuwuy ŋayi, märr walal dhu ga guŋga'yun ŋunha ŋunhi wiripuwurruny mala djämamirriny mala, märr walal dhu ga ŋathany ḻuka ŋuriŋiyi bili yan waluynydja dhunupay, ga bäyŋun walal dhu ga ŋunhi marryany' nhina? ");
INSERT INTO djr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ga balanyamirriynydja waluy yalalaŋumirriynydja ŋurikiwurruŋguny djämamirriw mala, ŋunhi ŋayi dhu Buŋgawa'mirriŋuynydja maḻŋ'maraŋuny walalany ŋunhiwili bili yan djämalil malaŋulil ŋayipi walalany gan djäma-gurrupar. Walalnydja dhu ŋunhi manymaknha mirithirra rom märraŋ nhanukuŋuny. ");
INSERT INTO djr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ga dhuwandja yuwalk yan dhäwu, ŋunhi ŋayi manymaktja djämamirr malthunayŋuny balanyany yolŋu, ŋunhiyinhan djämamirriny ŋayiny dhu ŋunhi boŋguŋ Buŋgawa'mirriŋuynydja nhirrpul ŋurruŋuyaŋuny, märr ŋayi dhu ga djägan nhanukalaŋaw girriw'nha ga ŋula nhakun malaŋuw, ŋunhi ŋayi ga ŋayatham. ");
INSERT INTO djr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yurr mak ŋayi dhu ŋula waŋganydhuny djämamirriy bitjanna guyaŋa ŋunhi nhanŋu dhu ga buŋgawa'mirriŋuny wiyinnha ḏapthun ga baman'nha ŋayi dhu buna. ");
INSERT INTO djr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Bala ŋayi dhu ŋunhi ŋuriŋiyi dhuwurr-yätjthuny djämamirriy marin djäma ŋunha wiripuwurruŋguny djämamirriw mala, ga wiripuny ŋayi dhu ga ŋänitjin ḻuka ga ŋathan ŋurikiwurruŋgala mala manapanna ŋunhi dhä-ŋanitjimirriwala yolŋu'-yulŋuwal. ");
INSERT INTO djr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bala ŋayi dhu ŋunhi Buŋgawa'mirriŋuny nhanŋu ŋurikiyi djämamirriwnydja buni, balanyamirriy waluy ŋunhi ŋayi ga ŋunhiyi djämamirr yaka nhanŋu dhukarr-nhäma, bili nhanŋuny ŋunhi walu gäna yan nhanŋuwuy, yaka ŋayi marŋgi nhanŋu roŋiyinyaraw. ");
INSERT INTO djr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bala ŋayi dhu ŋunhi Buŋgawa'mirriŋuynydja ŋunhiyinhany djämamirriny djäl-ganuŋumirrinhany dhä-gir'yurrnydja mirithin yan dhika, bala yan ŋurrkuŋun ŋanya warraŋullila, ŋunhi walal dhu gi nyäyunmirra ḻirra-ḻäwunhamirra ga mirithin yan walal dhu dhaŋga-ḏirryurrnydja, rrambaŋin walalnha ŋunhiwurrnha ŋunhi walal gan nyäḻyurr djäma nhanŋu ŋuriki Buŋgawa'mirriŋuw.” ");
INSERT INTO djr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ga buluny ŋayi Djesu waŋan bitjarra, “Ŋunha God-Waŋarrwuny rom balanyan gam', ŋarra nhumalaŋ dhu dhäwun' lakaram dhulmu-mayali'mirra ŋunhi nhaltjarr walalaŋ maḻŋ'thurr goŋ-märrmaw' miyalkkurruwurruŋ waŋganydhu munhay, ŋunhi walal märra'-marraŋal walalaŋguwuy walal wiyika' lanhdhirrapuy, bala yan marrtjinan balayin buŋgullila ŋunhi ŋuli miyalk ga ḏirramu märranhamirr, walal manapan dhu nhäman ŋanya ŋunhi ḏirramunhan dhuway'mirriŋunhan. ");
INSERT INTO djr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","3","Yurr ŋunhili malaŋur ŋunhi goŋ-märrma' miyalkkurruwurr, wiripuwurruy miyalkkurruwurruy goŋ-waŋganydhu gäŋal gan galki wiyika' lanhdhirrapuy walalaŋguwuy walal bili walal ŋunhi gaḏamanmirr, ga wiripuwurruynydja goŋ-waŋganydhu miyalkkurruwurruy bäyŋu märranha bäythinyawuy wiyikany' bili walal ŋunhi ḻiyamiriw mala balanya bawa'mirr mala. ");
INSERT INTO djr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ga ŋunhiwurrnydja ŋunhi goŋ-waŋganydja miyalkkurruwurr ḻiyamirrnydja mala, walalnydja gäŋal walalaŋguwuy walal bäythinyawuy wiyika' lanhdhirrapuy, märr ŋayi dhu ga ŋunhi nhära yan lanhdhirrany walalaŋ.” ");
INSERT INTO djr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“Yurr ŋayiny ŋunhiyiny ḏirramu dhuway'mirriŋuny bäyŋu warray bunanha bondiny. Ga walalnydja ŋunhi miyalkkurruwurrnydja nhinanan ga-a-an, bala yan yakurrnha walalaŋ bunan dhukarr-nhänharaynydja. Bala dhunupan yan walal ŋorra'-ŋurranan.” ");
INSERT INTO djr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ga yalalaŋumirriynha djeḏan balaŋun waluy, bala yan ŋula yol yolŋu waŋan yatjurr yindiynha rirrakayyu bitjarra gam', ‘Dhuwanna ŋayi ŋunhi yolŋuny, bilin bunanan! Go marrtjin rälin walal gumurr'yurra nhanŋu!’ ");
INSERT INTO djr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ga ŋunhi goŋ-märrmany' miyalkkurruwurrnydja dhunupan rur'yurra, bala dhuŋgur'yurra marrtjin walalaŋguwuy walal lanhdhirrany malany. ");
INSERT INTO djr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ga walalnydja ŋunhi ḻiya-dhumukmirriynydja miyalkkurruwurruy ŋäŋ'thurra wiyikaw'nha ŋunhi wiripuwurrunhany goŋ-waŋganynhany miyalkkurruwurruny bitjarra gam', ‘Way walal, go gurrupul ŋanapurruny nhumalaŋguwuy wiyika dhipal ŋanapurruŋgal lanhdhirralil malaŋulil, bili bäyŋun dhuwal ŋanapurruŋguny,’ bitjarr.” ");
INSERT INTO djr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Bala walal ŋunhi ḻiyamirrnydja miyalkkurruwurr waŋan bitjarra, ‘Nhaka yaka! Dhuwandja wiyika dhuwanna bili, ganan' yan ŋanapurruŋguwuynha. Gatjuy, marrtji ŋathil walal wuŋiḻi'yurr nhumalaŋguwuy wiyika.’ ");
INSERT INTO djr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bala walal yan marrtjinan märranharawnha wiyikaw'nha walalaŋguwuy walal.” “Ga ŋunhi nhakun walalnydja gan baḏaknha wuŋuḻi'yurra, bala ŋayiny ŋunhiyiny yolŋuny bunanan miyalkkun nhanukiyingalaŋawnha ŋayi märranharawnha. Ga ŋunhiwurrnydja ŋunhi miyalkkurruwurr ŋunhi walal gan ŋäthilmirriyanhamin ŋamaŋamayunmin, walalnydja marrtjin ŋunhi galkithinan nhanukal, bala walal gärrinan nhakun nhanukal wäŋalilnydja. Bala yan ŋayiny ŋunhalnydja dhurrwarany ŋunhi balany' dhaḻ'yurra. Ga ŋunhiwurryiny ŋunhi goŋ-waŋganydja miyalkkurruwurr, goŋmirriyinany walal dhika mirithinan yan nhanukal ŋurikal dhuway'mirriŋuwalnydja ḏirramuwal.” ");
INSERT INTO djr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ga yaka wiyin, bala walalnydja ŋunhi ḻiya-dhumukmirrnydja miyalkkurruwurr bunanany dhuḏitjnha, bala walal ŋunhi maḻŋ'maraŋalnydja dhurrwarany dhaḻ'yunawuynha. Bala walal gan ŋunhi dhärranan, yurr wäthurra walal gan ŋunhi bitjarrnha, ‘Way Garray! Garray! ḻapmaraŋ ŋanapurruŋ dhurrwara!’ Bitjarra walal gan ŋunhi waŋanany ŋunhalnydja warraŋulnydja.” ");
INSERT INTO djr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Bala ŋayiny ŋunhi dhuway'mirriŋuny ḏirramuny waŋan bitjarra, ‘Märr-yuwalk ŋarra ga dhuwal lakaramany, yaka ŋarra dhuwal nhumalaŋ marŋgi.’” ");
INSERT INTO djr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bala ŋayi Djesuny waŋanan walalaŋ, djägakuŋalnydja walalany bitjarrnha, “Nhumany dhu ga dhuwalawurrnydja djägan nhumalaŋguwuy nhuma, bira'yurra gi, bili yaka nhuma marŋgi waluwnydja ŋunhi nhätha dhu dhuwal malany rom maḻŋ'thun.” ");
INSERT INTO djr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Bala ŋayi Djesuy lakaraŋal wiripun dhäwu mayali'mirra, bitjarra gam', “Yo, nhininy gi gatjpu'yurr yan, djäga yan gi, bili God-Waŋarrwuny dhu ŋunhi rom maḻŋ'thurr biyakun gam'; Yolŋu wäŋa-waṯaŋu marrtjin wiripuŋulil wäŋalil yan nhakun guwarr. Yurr ŋurruŋuny ŋathil ŋayi wäthurr ḻuŋ'maraŋal ŋunhi djämamirriny mala nhanŋuwuy ŋayi ḻurrkun'nha, bala yan ŋayi ŋunhi dhayuŋarnha walalaŋgal balanya nhakun mayawala', waŋga'-waŋganygalnha yan djägalilnydja yurr romgurr ŋayi ŋunhi gurruparnydja. ");
INSERT INTO djr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Waŋganygalnydja yolŋuwal ŋayi ŋunhi dhayuŋar djägalil goŋ-waŋganymirr bathimirr mala yurr mel-wiḏi'mirr guṉḏa mala, ga wiripuŋuwal ŋayi gurrupar märrma'mirr bathimirr balanyayi guṉḏa mala mel-wiḏi'mirr, ga wiripuŋuwalnydja yolŋuwal ŋayi gurrupar waŋganymirra yan bathimirr balanyayi guṉḏa mala mel-wiḏi'mirr. Yo, dhayuŋarnydja ŋayi gan ŋunhi walalaŋgal djägalilnydja, bili ŋayi ŋunhi marŋgi walalaŋ gakal'wu mala ŋunhi nhaltjan walal dhu ga djäma ŋuriŋiyi mala, bala yan ŋayi dhunupan marrtjinan.” ");
INSERT INTO djr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Ga ŋayiny ŋuriŋiyiny yolŋuy ŋunhi ŋayi märraŋal goŋ-waŋganymirrnydja bathimirr mel-wiḏi'mirr guṉḏa malany, bala yan ŋayi ŋunhi dhunupan marrtjin balan ŋunhi buku-djuḻkmaranhamirrilila romlil, ŋuriŋiyiny mel-wiḏi'mirriy guṉḏay malaŋuy. Ga ŋuriŋiyiny romdhu ŋayi märraŋal märr dharrwan guṉḏa malany mel-wiḏi'mirr. Ga ŋunhiwiliyiny ŋayi bukulilnydja ŋal'maraŋal ga märr dhaŋaŋnha guṉḏa malany mel-wiḏi'mirr, bala ŋayi yan ŋunhi waŋgany-manaparnha, ga yindithinan ŋunhi mirithinan yulŋuny. ");
INSERT INTO djr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ga bitjarryi bili ŋunhi wiripuŋuynydja djämamirriy ŋunhi ŋayi märraŋal märrma'mirrnydja bathimirr mel-wiḏi'mirr guṉḏa, ga djäma ŋayi gan ŋuriŋiyi, ga bitjarryi bili yan ŋayiny bukulil-ŋal'maraŋal ga märr-dhäkaymirryi yan.” ");
INSERT INTO djr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","“Yurr ŋayiny ŋunhi ŋuriŋiyi wiripuŋuynydja djämamirriy yolŋuy ŋunhi ŋayi märraŋal waŋganymirrnydja yan bathimirr mel-wiḏi'mirr guṉḏa malany, ŋayiny ŋunhi ŋuriŋiyiny yolŋuy munathan' yaw'yurr, bala yan dholkuŋalnha, djuḻuḻ'maraŋala munatha'lila.” ");
INSERT INTO djr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ga bäy ŋayi baman'thin walu, bala ŋayi ŋunhi wäŋa-waṯaŋuny yolŋu roŋiyinan walalaŋgal. Ga dhunupan ŋayi walalaŋ ŋunhi wäthurra ŋurikiwurruŋdhiny djämamirriwnydja mala, märr ŋayi dhu maḻŋ'maraman walalaŋgal, nhaltjarr walal gan ŋuriŋiyi mel-wiḏi'mirriy guṉḏay malaŋuy djäma, ŋunhi ŋayi dhayuŋar walalaŋgal djägalil ŋäthil.” ");
INSERT INTO djr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","“Bala ŋayi ŋunhiny ḏirramu ŋunhi ŋayi gan djäga goŋ-waŋganyguny bathimirriw mel-wiḏi'mirriw guṉḏaw malaŋuw, marrtjinan guwatjmara ŋanya. Bala ŋayi yan milkuŋalnha ŋunhi wäŋa-waṯaŋuwalnydja yolŋuwal bitjarrnha, ‘Wäy, dhuwal nhe ŋunhi ŋarrakalnydja gurrupar djägalil bathi malany goŋ-waŋganydja. Yurr ŋarrapiny gan ŋunhi djäma yan, bukulil ŋal'maraŋal marrtjin ga dhaŋaŋguŋal.’” ");
INSERT INTO djr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Bala ŋayi ŋunhi wäŋa-waṯaŋuny yolŋu waŋanan nhanukal bitjarrnha, ‘Nheny dhuwal djäma-manymakmirr, ga malthunayŋu yan yolŋu. Ŋarrany nhuna ŋunhi waŋanany djägakuŋalnydja ḻurrkun'ku yan, yurr nheny gan ŋunhi djämany manymakkuŋal warray. Ŋarrany nhakun dhu dhuwal gurrupandja bulun warray nhokalnydja djägalil. Go nhininy dhiyalnha ŋarrakalnha märr-ŋamathinyamirriŋura.’” ");
INSERT INTO djr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ga bitjarryi bili ŋuriŋiyi wiripuŋuynydja djämamirriy, ŋuriŋiyiny ŋunhi ŋayi nhanukal gurrupar märrma'mirr bathimirr, marrtjinany ŋayi ŋunhi, ga dhunupan yan ŋayi ŋunhi nhanukal milkuŋalnha bitjarrnha, ‘Ŋay', Buŋgawa, dhuwal ŋunhi nhe ŋarrakalnydja gurrupar, yurr ŋarrapiny gan ŋunhi djä-ä-äma, ga dhuwanna, bukulil-ŋal'maraŋal ŋarra djäma märr dhäkaymirr.’” ");
INSERT INTO djr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Bala ŋayiny ŋunhi wäŋa-waṯaŋuynydja yolŋuy waŋan ŋanya bitjarrnha, ‘Nheny dhuwal manymak yan djämamirr, malthunayŋu yolŋu. Ŋarrany ŋunhi gurruparnydja märr ḻurrkun' yan djägalilnydja nhokal, bala nheny gan ŋunhi djämany manymakkuŋal warray. Ga ŋarrany dhu gurrupan bulun nhakun nhokalnydja djägalil. Go, nhininy gi dhiyala ŋarrakalnha märr-ŋamathinyamirriŋurnha.’” ");
INSERT INTO djr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ga buluny ŋunhi dhuḏiŋun yolŋu marrtjin, ŋunhiyin yolŋu ŋunhi ŋayi märraŋal waŋganymirr yan bathimirr mel-wiḏi'mirr guṉḏa mala. Bala ŋayi yan waŋanany nhanukal bitjarrnha, ‘Wäy. Ŋarrapiny gan nhuŋu ŋunhi märr-barrarin warray, bili nhe dhuwal gumurr-ḏälnha mirithirra. Ŋunhi nhe ŋuli marrtji, ga gulkthun nhe ŋuli ŋatha malany dharrwa mirithirr, ŋunhiny yaka nhokuŋuny lämu-nhirrpanawuy, ga ḻundukum nhe ŋuli marrtji ŋunhiny mala ŋatha ŋunhi yaka nhakun nhokuŋuny djalkthunawuy. ");
INSERT INTO djr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ŋay', dhuwandja ŋunhiyi bili yan waŋganymirr yan bathimirr ŋunhi nhe ŋarrakal dhayuŋan djägalil ŋäthil, ga djuḻuḻ'maraŋalnydja ŋarra dhuwali munatha'lilnydja bili ŋarra märr-barrarin, märr ŋayi ŋunhi yakan winya'yurrnydja. Dhuwanna nhuŋu ŋunhi guṉḏany mala ŋunhi mel-wiḏi'mirrnydja roŋanmaraŋala ŋarra nhokal.’” ");
INSERT INTO djr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Bala ŋayi ŋunhi wäŋa-waṯaŋuny yolŋu nhanŋu waŋan bitjarrnha, ‘Nhä nhe dhuwal, yätjkurrnydja djämamirr, ḏuŋḏuŋnydja! Marŋgithin yan nhe dhuwal muka, ŋunhi ŋarra ŋuli marrtji gulkthun dharrwany mirithirrnydja ŋatha malany, ŋunhiyiny yaka ŋarrakuŋuny lämu-nhirrpanawuy, ga ḻundukum ŋarra ŋuli ŋatha malany maŋutji ŋunhiny yaka nhakun ŋarrakuŋuny djalkthunawuy. ");
INSERT INTO djr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nhaku nhe gan ŋunhi yakany djäma ŋamathaŋal, ŋuriŋiyiny ŋunhi mayawalay' ŋunhi ŋarra nhokal dhayuŋar? Nheny balaŋ ŋunhi goŋ-gurrupanany balan ŋunhi rrupiya-djägamirriwala mala, märr balaŋ ŋarrany ŋunhi märranha mala-bukmaknha yan, ga bulu ŋunhi mala-bunhaminyawuynha rrupiya, ŋunhi ŋarra dhuwal roŋiyinany nhakun räliny. Ga nheny dhuwal ŋula nhämirr warray yolŋu, nhäŋiniŋ'nha djämamirr.’” ");
INSERT INTO djr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Bala yan ŋayi ŋunhi wäŋa-waṯaŋuny bilyurrnydja, ga waŋan ŋayi ŋunhi wiripuwurruŋguny bitjarrnha, ‘Ma', gatjuy djaw'yurra märraŋun ŋunhany ŋunhi waŋganymirrnydja bathimirr balanydja dhiyakalnydja gay'yi yolŋuwal, ga gurrupulnydja ŋurukala bala yolŋuwal ŋunhi ŋayi ga ŋayatham yindin mirithirra ŋonuŋnha balanydja. ");
INSERT INTO djr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yo. Ŋuli ŋayi dhu ga ŋunhi yolŋuy ŋayatham ŋula nhämunhany' ŋarrakuŋuny dhayuŋanawuy, ŋurikiyiny yolŋuw ŋarrany dhu ŋunhi dhayuŋan bulun ŋunhiwiliyiny ŋapa-ŋal'maram. Ga ŋunhi dhu ga yolŋu dhäparŋ'tja nhina, bäyŋuny ŋayi gi ŋayathul ŋula nhä ŋarrakuŋ dhayuŋanawuy, bala ŋarrany dhu ŋurikalyiny yolŋuwal yänan djaw'yunna märraman ŋunhi ŋula nhä ŋayi ga ŋayatham nyumukuṉiny'. ");
INSERT INTO djr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gatjuy djaw'yurra ŋanya dhuwaliny ŋunhi nhäŋiniŋ'nhany djämamirriny, bala yan ŋurrkuŋuny ŋanya warraŋullila, balan biyakun buku-munha'lila, ga ŋunhilin ŋayi dhu ga ŋäthiny ḻirra-ḻawunhamirrnydja dhaŋga-ḏirryunna manapan.’” Ga bitjarra ŋayi gan ŋunhi Djesuy dhäwuny lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Bala ŋayi Djesuy lakaraŋal dhäwu ŋunhiŋuwuynha ŋunhi nhaltjan ŋayi dhu Gäthu'mirriŋu Yolŋu buna. Ga bitjarr ŋayi lakaraŋalnydja gam', “Yolŋuny dhu Gäthu'mirriŋu buni ŋurruḏawalaŋun ga buŋgawan, ga dharrwan dhu ŋunhi mirithirra God-Waŋarrwuny dhäwu-gänhamirrnydja mala malthurrnydja nhanŋu, bala ŋayi dhu nhinin ŋurruŋuyin ŋunhiliyin nhanukiyingala ŋayi manymakŋura romŋurnydja djeŋarra'mirriŋura. ");
INSERT INTO djr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bala yolŋuny walal dhu ŋunhi bukmaknha yan ḻuŋ'maranhamirra marrtji nhanukal Garraywala gumurrlilnydja, bäpurru ga bäpurru ga bäpurru, wiripun wiripun mala, bala dhärrin walal dhu gi ŋunhiliyin. Bala ŋayi dhu marrtji Garrayyuny mala-wulkmaraŋun, barrkuwatjkuŋun märrma'lila malalilnydja, biyak yan bili nhakun ŋunhi wäyin-djägamirriy yolŋuy ŋuli marrtji mala-wulkmaram warrakan'nha malaŋuny, nanikutnha gäna ga bimbiny mala gäna. ");
INSERT INTO djr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yo. Biyakiyin ŋayi boŋguŋ nhirrpulnydja marrtji, bimbiny mala dhunupa'ŋulila gali'lil ga nanikutnha mala wiṉ'kuŋulil gali'lil. ");
INSERT INTO djr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bala ŋayi dhu ŋunhi Ŋurruḏawalaŋuny Buŋgawa boŋguŋ waŋin ŋurikiwurruŋguny ŋunhi dhunupa'ŋuŋurnydja gali'ŋur nhanukal biyakun gam', ‘Go marrtjin walal rälin, bili ŋarrakalnydja Bäpay nhumalany manymak lakaraŋala. Go marrtjin walal bala yan märraŋun dhuwandja ŋunhi rom dharrpalnydja ŋarrakuny, ŋunhi gan ŋorran ŋamaŋamayunawuy beŋur bili yan baman'ŋur ŋurruṉaŋgalŋur, yurrnha ŋayi gan dhuwal munathany' wäŋany God-Waŋarryuny bokmar. ");
INSERT INTO djr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bili ŋunhi ŋarra gan djaṉŋarrnydja nhinan, ga nhumany ŋarrany gan maranhu-gurrupar warray. Ga ŋunhi ŋarra gan nharaŋdhin, ga nhumany ŋarrany gapu gurrupar. Ga ŋunhi ŋarra yolŋumiriwnydja mulkuruny, bala nhumany ŋarraku gumurr-ŋamathin warray nhumalaŋgiyingalnydja wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ga ŋunhi ŋarra gan nhinan ŋula nhämiriwnydja girri'miriwnydja, bala nhumany ŋarrany dhaṯthurr warray; rirrikthurr ŋarra gan, ga nhumany ŋarraku gan djäga. Ga ŋunhi ŋarra gan dharruŋguŋurnydja gärrin, ga nhumany ŋarrany gan gumurr-guwatjmar bitjarr bili.’ Ga biyakun ŋayi dhu ŋunhi Ŋurruḏawalaŋuny waŋi yolŋuw walalaŋ ŋunhi walal ga dhunupa'ŋuŋurnydja gali'ŋur nhina.” ");
INSERT INTO djr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Bala ŋuriŋiwurruynydja yolŋuy walal dhu dhä-birrka'yurr ŋanya Garraynhany biyakun, ‘Wäy, wanhal dhika ŋanapurr nhuna nhäŋal balanyawuyyiny mala, wanhal bili napurr nhuna nhäŋal djaṉŋarrthinyawuynydja ga nharaŋdhinyawuynydja, bala ŋanapurr gan be nhuna maranhu-gurrupara? ");
INSERT INTO djr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ga nhätha ŋanapurr nhuna nhäŋal girri'miriwnydja, warraŋulnydja, bala ŋanapurr nhuna gan dhaṯthurra. ");
INSERT INTO djr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ga nhätha nhe gan be rirrikthurrnydja, ga ŋanapurrnydja nhuŋu gan djägan? Ga be nhe gan dharruŋguŋurnydja gärrin ga ŋanapurrnydja nhuna guwatjmar?’” ");
INSERT INTO djr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Bala ŋayi dhu ŋunhi ŋurruḏawalaŋuny buŋgawany waŋin buku-bakmaraŋun biyakun, ‘Märr-yuwalk ŋarra ga dhuwal lakaram nhumalaŋ. Nhäŋal nhuma gan ŋunhiny yolŋuny wuyunayŋunhany gumurr-djararrknhany, ŋarraku ŋunhiyiny yukuyuku'mirriŋu walal, bala nhuma gan guŋga'yurra walalany. Ŋunhi nhuma gan bitjarryiny nhakun guŋga'yurrnydja ŋarrakuny yukuyuku'mirriŋuny walalany, ŋunhiyiny nhakun nhuma gan ŋarrakuny djägayi.’ Ga biyakiyin ŋayi dhu boŋguŋ Garraynydja waŋi.” ");
INSERT INTO djr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ga dhäŋur beŋuryiny bala ŋayi dhu Garraynydja bilyurra, bala waŋin ŋurikiwurruŋgalnydja yolŋuwal walalaŋgal ŋunhi walal dhu gi wiṉ'kuŋuŋurnydja gali'ŋur nhanukal nhini biyakun. ‘Gatjuy gundupuŋun walal, nhumany dhuwalawurrnydja, bilin nhuma dhuwal gumurr-dhar'yunawuynha mala. Marrtjin bala yan walal ŋunhiwiliyin wäŋalil dhä-gir'yunamirrilila, ŋunhiwilin ŋunhi ga gurtha nhäran yan bitjanna bili, ŋunhiyin ŋayi ŋunhi God-Waŋarryuny ŋäthilmirriyamany ŋurikiyiny buŋgawawnydja Mokuywu ga malawnydja nhanukalaŋaw. Bili nhumany gan ŋunhi yaka warray djäga ŋarraku. ");
INSERT INTO djr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ŋunhi ŋarra gan djaṉŋarrnydja nhinan, ga nhumany ŋarrany yaka warray maranhu-gurrupanna. Ga ŋunhi ŋarra gan nharaŋdja nhinan, ga nhumany ŋarraku bäyŋu gurrupana gapu. ");
INSERT INTO djr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ga ŋunhi ŋarra mulkuruny ga yolŋumiriwnydja, ga nhumany yaka warray ŋarraku gumurr-ŋamathinya ga märranha ŋarrany nhumalaŋgiyingal wäŋalil. Ga warraŋul ŋarra gan nhinan, ga nhumany ŋarrany yaka dhaṯthuna. Ga ŋunhi ŋarra gan rirrikthurrnydja, ga dharruŋguŋurnydja gan gärrin, ga nhumany ŋuli ganha yaka warray gurul'yuna ŋarrany ga guŋga'yuna.’” ");
INSERT INTO djr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ga walalnydja dhu ŋuriŋiwurruynydja yolŋuy walal waŋi dhä-birrka'yurr ŋanya biyakun, ‘Way Garray, wanhal dhika ŋanapurr nhuna gan nhäŋal balanyawuyyiny, ga yakany nhuna guŋga'yunna? Nhätha dhika ŋanapurr nhuna nhäŋal djaṉŋarrthinyawuynydja ga nharaŋdhinyawuynydja ga mulkuruny, ga nhätha napurr nhuna nhäŋal warraŋulnydja nhä mak rerrimirrnydja, nhä mak dharruŋguŋurnydja nhe gan nhinan?’” ");
INSERT INTO djr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Bala dhu ŋayiny ŋunhi ŋurruḏawalaŋuny buŋgawany boŋguŋ waŋin buku-bakmaraŋun biyakun, ‘Märr-yuwalk ŋarrany nhumalaŋ dhu dhuwal lakaram. Ŋunhi nhuma gan nhäŋal ŋula yolnha yolŋuny wuyunayŋunhany, gurrupuruŋunhany, yurr bäyŋun nhuma gan ŋunhi guŋga'yurrnydja ŋanya, ŋunhiyiny nhakun nhuma gan ŋarranhan yaka guŋga'yurr.’” ");
INSERT INTO djr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bala ŋayi Djesuny bitjarra waŋan gam', “Ŋuriŋiwurruynydja ŋayaŋu-djarrpi'mirriynydja yolŋuy walal dhu yindin mirithirra dhä-gir'yunawuynydja märraŋ ŋunhi dhä-dhawar'yunamiriwnha. Yurr ŋuriŋiwurruynydja ŋunhi walal gan ŋayaŋu-manymakkuŋal yan God-Waŋarrnha walalnydja dhu ŋunhi märraŋ walŋa-wiyinŋumirra.” ");
INSERT INTO djr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ŋunhi ŋayi Djesu dhawar'yurrnydja marŋgi-gurrupanaŋurnydja walalaŋgal, bala ŋayi yan waŋanan nhanukalaŋuwal malthunamirriwalnydja walalaŋgal bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Marŋgi muka nhuma dhuwal, ŋunhi ga dhuwal märrman' yan buluny walu ŋorra bala dhu ŋunhiyiny walu yäku Ḻäy-Djuḻkmaranhamirrnydjabunan. Ga balanyamirriynha walal dhu ŋanya ŋunhi Yolŋunhany Gäthu'mirriŋuny dhayuŋulnydja balany ŋunhi miriŋuwalnydja goŋlil bala yan walal dhu ŋanya dhuḻ'yurra dharpalila mälakmaranhawuylila.” ");
INSERT INTO djr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ga balanyamirriyyi bili yan waluy walalnydja ŋunhi ŋurruŋu djirrikaymirriynydja mala ga ŋurru-warryunayŋuny mala, ga rom-marŋgikunhamirrnydja mala ŋurikiyiny wäŋaw malaŋuw, gan dhäruknha-bakmaraŋal waŋanhaminan ŋunhiliyin nhanukalnha ŋurruḏawalaŋu djirrikaymirriwala yolŋuwal Gäyapatjkala wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Bala walal gan ŋunhi ḻarruŋala dhukarrwun, wanhawitjan walal dhu ŋunhi dhukarrkurr ŋayatham ŋanya Djesuny, bala yan dhu buman ŋanya murrkay'kuman. ");
INSERT INTO djr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ga bitjarra walal gan ŋunhi waŋanhaminany gam', “Yaka limurr dhu ŋanya yänayiny ḏapmaram, bili dhuwal Ḻäy-djuḻkmaranhamirra waluny, walal balaŋ bäynha yolŋun walal maḏakarritjthi limurruŋgun, bala yan buŋun marrtji limurrunhany,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ga balanyamirriynydja ŋayiny gan ŋunhi Djesuny nhinan ŋunhalnha Bithinin wäŋaŋur, yolŋuwal yäkuwal Djäymangal, ŋurikalyin yolŋuwal ŋunhi ŋayiny ŋunhiyiny yolŋu gan ŋäthilnydja nhinan burrunhdhiya'mirr yan. Ga ŋunhi ŋayi gan Djesuy ḻukanany ŋathany, ");
INSERT INTO djr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","bala ŋayiny bäy miyalk gulŋiyin goŋ-buthuḻumirr ŋunhiwiliyi guwatjmar ŋanya, ga gäŋalnydja ŋayi marrtjin ŋunhi buŋgan-bäw buthuḻumirr, yurr buŋgan-bäwny'tja ŋunhi rrupiya yindimirra dhika. Ga dhunupan bala yan ŋayi ŋunhi rarryurra ŋunhiyiny buŋgan-bäwny'tja wiyika muḻkurrlila nhanukal Djesuwalnha. ");
INSERT INTO djr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yurr ŋunhi walal malthunamirriynydja mala nhanukal nhäŋalnydja ŋunhiyi, bala walal yan maḏakarritjthinan nhanŋu ŋurikiyiny miyalkkuny, ga bitjarra walal ŋunhi waŋanany gam', “Nhaku ŋayi ga ŋunha buŋgan-bäwny'tja djalkthun? ");
INSERT INTO djr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ŋayi balaŋ ŋunha djalimnha rrupiyawnha yindiwnha, märr balaŋ ŋayi ŋunhi rrupiyany gurrupanna ŋunha ŋurruwuykmirriwnha yolŋuw walalaŋ.” ");
INSERT INTO djr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ga ŋayiny ŋunhi Djesuny marŋgithin, ŋunhi nhaltjarr walal gan guyaŋan, bala yan ŋayi walalaŋ waŋanany bitjarrnha, “Ganarrthul walal ŋanya. Nhaku nhuma ga dhuwal ḻay-ḻaymaramany dhuwali miyalknhany? Dhuwandja ŋayi bitjarryiny djäma ŋarraku, ŋunhiny latjun' mirithirra. ");
INSERT INTO djr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ŋunhany ŋunhi ŋurruwuykmirrnydja yolŋu walal dhu gi nhina yan nhumalaŋgal biyak bili, yurr ŋarrany ga dhuwal gurririn yan nhina nhumalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ŋunhi ŋayi ŋuruŋ miyalkthuny wiyikany' rarryurr buŋgan-bäwny'tja ŋarrakal rumbalilnydja, ŋunhiyiny nhakun ŋayi ŋäthilmirriŋala ŋamaŋamayurra ŋarrany ŋurukun ŋunhi moluwnha. ");
INSERT INTO djr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Märr-yuwalk ŋarra nhumalaŋ ga dhuwal lakaramany. Ŋunhi walal dhu yolŋu'-yulŋuynydja ŋäkuny dhuwal dhäwuny buku-ḻiw'maraŋuny wäŋakurrnydja mala, bala walal dhu guyaŋin dhuwal miyalknhany, ŋunhi nhä ŋayi ŋarraku djäma,” bitjarra ŋayi Djesuy walalaŋgal lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ga ŋayiny Djudatj-Gariyattja ŋunhi ŋayi beŋuryi malaŋur 12-kalnydja, marrtjinan balan ŋunhi ŋurruŋu djirrikaymirriwalnha malaŋuwal. ");
INSERT INTO djr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ga bitjarr ŋayi ŋunhi waŋanany walalaŋgal, “Wäy, ŋarrany dhu dhuwal Djesunhany goŋ-gurrupanna nhumalaŋgala goŋlil, nhän nhuma dhu ŋarranhany gurrupan,” bitjarr. Bala walal yan wuŋiḻi'yurra ŋanya 30-y mel-wiḏi'mirriy guṉḏay mala. ");
INSERT INTO djr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ga beŋuryiny dhurrwaraŋur ŋayi gan Djudatjthuny dhukarrnha maḻŋ'maraŋal wanhawitjan ŋayi dhu Djesuny gurrupan goŋlil walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ga balanyanyaray bili waluy ŋurruyirr'yunamirriy, ŋunhi walal ŋuli Djuw malay ŋathan ḻukanha ḏambamiriwnha, bala walalnydja ŋunhi malthunamirrnydja mala nhanŋu Djesuwnydja marrtjinan guwatjmara ŋanya, bala walal bitjarra waŋan gam', “Wanhawal dhika nhe ŋanapurruŋ djälnydja ŋäthilmirriyanharaw wäŋawnydja, märr nhe dhu ḻukan ŋunhiny ŋatha Ḻäy-djuḻkmaranhamirra.” ");
INSERT INTO djr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Bala ŋayi Djesuny bitjarra walalaŋ waŋan, “Balan nhuma dhu marrtjiny yindilila wäŋalil, ga ŋunhili nhuma dhu maḻŋ'maram waŋganynha yolŋuny, bala nhuma dhu bitjanna nhanŋu waŋany. Bitjarr ŋunha ŋanapurruŋ Marŋgikunhamirrnydja waŋan gam', ‘Ŋarraku waluny dhuwal bilin bunanan! Djälnha ŋarra dhuwal, ŋarra dhu ḻukan ŋunhiny ŋatha Ḻäy-djuḻkmaranhamirrnydja, ŋanapurr ŋarrakal malthunamirriy mala. Dhiyaliyin ŋunhi nhokala wäŋaŋurnydja.’” ");
INSERT INTO djr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Bala yan walal dhunupan djäman ŋunhi nhaltjarr ŋayi Djesuy walalaŋ gan lakaraŋal, bala walal yan ŋäthilmirriyaŋala ŋamaŋamayurra ŋunhiyiny ŋatha yäku Ḻäy-djuḻkmaranhamirrnydja. ");
INSERT INTO djr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Ga ŋunhi marrtjin wäŋany munhawuyin bala ŋayiny Djesuny marrtjinan bala nhinanan, bala ŋathan ḻukan walalnha rrambaŋin ŋuriŋiwurruynha malthunamirriynha mala nhanukal. Ga ŋunhi walal marrtjin ŋathany ḻukan, bala ŋayiny Djesuny waŋanan bitjarra, “Märr-yuwalk ŋarra nhumalaŋ ga dhuwal lakaramany, dhiyal gay'yi nhumalaŋgal malaŋur, waŋganydhuny ŋarrany dhu ŋunhi goŋ-gurrupanna miriŋuwala goŋlil,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bala walalnydja ŋunhi malthunamirrnydja mala nhanŋu mirithinan dhika galŋa-miḏikinany ŋuriŋiyiny dhärukthuny nhanukal, bala walal yan waŋga'-waŋganydhuny gan Djesunhan dhä-birrka'yurr bitjarra gam', “Wäy, Garray yol way! Muka ŋarra?” ");
INSERT INTO djr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ga ŋayiny Djesuny walalaŋ buku-bakmaraŋal bitjarr, “Waŋganydhuny dhu dhipuŋur malaŋur nhumalaŋal ŋathan ḻupmaram banikin'lila rrambaŋin linyu. Ŋunhiyin ŋunhi yolŋuny ŋunhi ŋayi ŋarrany dhu goŋ-gurrupandja. ");
INSERT INTO djr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ŋayiny dhu ŋunhi Yolŋuny Gäthu'mirriŋu rakunydhirr, bitjan yan bili nhakun ŋunha ga ŋäthiliŋuŋur djorra'ŋur dhärra wukirriwuy. Yurr ŋurikiny yolŋuw ŋunhi ŋayi ŋarrany dhu goŋ-gurrupandja, ŋurikiyiny dhu mirithirra ŋoy-gärrinyamirra rom maḻŋ'thurr. Ga manymaktja nhanŋu ŋurikiyiny yolŋuw, ŋayi balaŋ ŋunhi yakan yan dhawal-guyaŋanha.” ");
INSERT INTO djr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Bala ŋayiny yan Djudatjtja waŋan bitjarra, “Way! Marŋgikunhamirr, muka ŋarrany nhe ga dhuwal lakaramany?” “Ŋe nhe dhuwali lakaranhamin.” Bitjarr warray ŋayiny Djesuny buku-bakmaraŋal nhanŋu. Bala yalalaŋumirrnydja ŋayiny ŋunhi yuwalknha yan Djudatjthuny ŋanya goŋ-gurruparnydja miriŋuwalnydja. ");
INSERT INTO djr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yo baḏak yan walal marrtjin ŋunhi ŋathany ḻukan, bala ŋayi Djesuynydja märraŋala ŋathany bala buku-gurrpara God-Waŋarrnhany bala bakmaraŋala, bala marrtjin gurru'-gurrupara nhanukalaŋuwal malthunamirriwala walalaŋgal. Ga bitjarra ŋayi marrtjin waŋanany gam', “Ŋay'! Märraŋ ga ḻuki. Dhuwandja ŋarra rumbalnha.” ");
INSERT INTO djr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ga bitjarryi bili ŋayi märraŋal banikin' wiyika'mirr ga buku-gurrpar God-Waŋarrnha, bala gurrupara marrtjin walalany, ga bitjarra ŋayi waŋanany gam', “Bukmakthu yan nhuma dhu ḻukany dhipuŋuryi.” ");
INSERT INTO djr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ga waŋan ŋayi Djesu bitjarr, “Dhuwandja ŋarraku maŋgun', ŋunhi ŋayi dhuwal gumurrkunhaminyawuy rom God-Waŋarrwuŋun gurrupanawuy, bili ŋarrakuny dhu ŋunhi gulaŋ-waṉḏirr bukmakkun yan yolŋuwnydja walalaŋ, buwayakkunharaw walalaŋ dhuwurr-yätjkurruwnydja romgu.” ");
INSERT INTO djr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","“Yurr, dhipuŋurnydja dhurrwaraŋur, ŋarrany dhu ŋunhi bäyŋun buluny ḻuka dhuwaliyiny wiyika' borum, ga yan bili-i-i, ga balanyamirriynha waluy ŋarra dhu buluny ḻuki ŋunhala ŋunhi Bäpa'mirriŋuwalnha ŋarrakalaŋuwal romŋur, ŋunhiyin ŋunhi yuṯan wiyika' borum limurra rrambaŋin.” ");
INSERT INTO djr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ga dhäŋur beŋuryiny ŋunhi, bala walal manikaynha ḏar'ṯaryurr, bala yan walal marrtjinan bukulila yäkulil Woliplila. ");
INSERT INTO djr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yo, wäŋgaŋala walal marrtjin bala dhukarr-ŋupara, Djesu ga ḻundu'mirriŋu mala nhanŋu. Bala ŋayi ŋunhiliyiny dhukarrŋurnydja Djesuny waŋanan bitjarra, “Gäthurnydja munhawu, nhumany dhu ŋarrany dhiyaŋuwurruynydja ganana, bukmakthu yan, bili ŋäthil yan walal ŋunhi wukirriny dhäwuny, ŋunhi ŋayi ga waŋa bitjan gam' ‘Ŋarrany dhu wutthuna ŋunhi djägamirrinhany yolŋuny, bala dhu ŋunhi warrakan'tja bimbiny mala nhanŋu ḻatjuwarr'yunna barrkuwatjthirra.’ ");
INSERT INTO djr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ga ŋunhi ŋarrany dhu God-Waŋarryu walŋakuŋuny dhiŋganhaŋurnydja, bala ŋarra boŋguŋ marrtjiny ŋäthila Galalilila.” ");
INSERT INTO djr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ga ŋayiny Betany waŋan bitjarra, “Ŋarrany boŋguŋ nhuna bäyŋu yan ganarrthul. Dhiyaŋuwurruy mak nhuna dhu ganarrthulnydja, ŋarrany dhu yaka warray nhuna ganarrthul.” ");
INSERT INTO djr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ga ŋayiny Djesuny waŋan Betawnydja bitjarra, “Märr-yuwalk ŋarra nhuŋu dhu dhuwal lakaramany. Dhiyaŋuny bala munhawu yalalany, nheny dhu buku-ḻurrkun'mirr ŋarraku dhumbal'yun, ga yorrnha ŋayi dhu ŋunhi guḻawurrnydja waŋa.” ");
INSERT INTO djr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Yurr ŋayiny Betany bulu waŋan bitjarr, “Yakan dhu dhuwal ŋarrany nhuŋu dhumbal'yun. Bäydhi ŋunhi walal ŋarrany dhu bumany, yurr ŋarrany dhu dhiŋgam yan nhuŋu ŋalin rrambaŋin.” Ga walalnydja ŋunhi wiripuwurrnydja malthunamirr mala bitjarryi bili waŋa'-waŋan. ");
INSERT INTO djr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Bala ŋayi Djesuny marrtjinan walal rrambaŋin malthunamirra mala nhanŋu balayin ŋunhi wäŋalil yäkulil Githtjamanilila. Ga ŋunhi walal bunanany ŋunhiliyiny wäŋaŋurnydja, bala ŋayi Djesuynydja walalany waŋanan bitjarra, “Nhini walal dhiyal, ŋarra dhu bala bitjan marrtji bukumirriyanharaw,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ga garr'yundja ŋayi Betanhan ga märrmany' gäthu'mirriŋuny maṉḏany Djibidiw, bala walal marrtjinan, wäŋgaman balan bitjanna. Ga ŋunhalnydja ŋayi ŋunhi Djesuny mirithinan dhika ŋoy-gulŋiyinany, ");
INSERT INTO djr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","bala ŋayi waŋan lakaranhamirra walalaŋgal bitjanmirra, “Walal ŋayaŋuny ŋarraku dhuwal mirithinan yan ŋonuŋdhinany, nhakun ŋarra dhu dhuwal dhiŋgaman. Nhini walal dhiyal, … yurr bira'yurr gi, … limurr muka rrambaŋi,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Bala ŋayi Djesuny buluyi marrtjin bala bitjarr märr barrkulil, ga ŋunhiliny bala ŋayi yan ŋurrkanhaminan bukuny munatha'lila, bala yan ŋayi bukumirriyaman bitjanna gam', “Bäpa ŋarraku marrkapmirr, nheny dhu ŋunhi djäman bala yan, djaw'yurra ŋarrakal dhuwandja ŋunhi galŋa-rirrikthunamirrnydja rom. Märr ŋarra dhu yakan ḻuka dhuwal dhaŋga-ḏirrmirrnydja rom dhiyakumirrnydja banikin'mirr. Yurr ŋarrapiny dhu ga dhuwal nhuŋuwuynha yan märrwuny malthun yakan ŋarrakuwuynydja,” bitjarra ŋayi gan ŋunhi Djesu bukumirriyaŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ga dhäŋur beŋuryiny ŋayi marrtjin balayi roŋiyindhi malthunamirriwal mala nhanukalaŋuwal, ga maḻŋ'maraŋalnydja ŋayi walalany yakurrnhan. Ga waŋan ŋayi Betawal bitjarr, “Bäyŋu nhuma gi dhuwal ŋula bira'yurrnydja muka? Yän ŋula märr gurririny ŋarrakalnydja manapul? ");
INSERT INTO djr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Biyak walal bira'yurr yulŋuny, ga bukumirriyaŋ muka gi, märr nhumalany dhu yaka muka ŋula nhaliynydja dharrwunum. Bili ŋayaŋuny nhuŋu ga dhuwaliyi djälthirr nhe dhu ga dhärra ḏäl yan ŋarrakal, yurr galŋany nhuŋu dhuwaliyi ganydjarrmiriwyinan yalŋgithinan,” bitjarr ŋayi. ");
INSERT INTO djr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ga buluyi ŋayi Djesu balayi bili roŋiyindhi bukumirriyanharaw, bala ŋayi yan bitjarra waŋanany gam', “Bäpa ŋarraku marrkapmirr, ŋuli ŋayi gi bäyŋuny wiripu dhukarr ŋorri, ŋarrany dhu ŋunhi märraman yanan, ŋunhiyiny ŋunhi rom dhaŋga-ḏirryunamirrnydja. Bala ŋarra dhu djäman yan ŋunhi nhaku nhe ŋarraku ga djälthirr.” ");
INSERT INTO djr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ga roŋiyirryi ŋayi Djesu beŋur bukumirriyanhaŋur ga maḻŋ'maram ŋayi walalany yakurrlil, yakurryun walalany yindiynha dhurrparam. ");
INSERT INTO djr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ga buluyi ŋayi ganarrthaŋal walalany, ga buluyi bukumirriyaŋal bitjarryi yan bili nhakun ŋunhi ŋäthil. ");
INSERT INTO djr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ga ŋunhi ŋayi buluny roŋiyirr balayi malthunamirriwal mala nhanukalaŋuwal, bala yan ŋayi ŋunhiyiny bitjarra waŋan gam', “Baḏak yan nhuma ga dhuwal ŋorra'-ŋurra muka ŋaraka galkunmirr? Bilin dhuwal waluny bunanan, ŋunhi ŋayi dhu ŋuriŋiyiny ḏirramuy goŋ-gurrupanna ŋanya Yolŋunhany Gäthu'mirriŋuny dhuwurr-yätjkurrumirriwala romlil. ");
INSERT INTO djr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Rur'yurra walal, dhiyaŋun bala ma! Limurr marrtjin. Nhäŋun walal, dhuwanna ŋayi ŋunhiyiny yolŋu ŋunhi ŋayi dhu moṉuŋuyirrnydja, bilin ŋayi bunanan,” bitjarra ŋayi Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ga baḏak yan ŋayiny gan ŋunhi Djesuny waŋan, bala ŋayiny ŋunhiyiny ḏirramu gali'-märrmany' Djudatjtja yäku bunanan nhanŋu, ŋunhi ŋayiny ŋunhiyiny ḏirramu ŋuliŋuryin muka malaŋur 12-gala, malthunamirra nhanŋun Djesuwnha. Ga dharrwan gan ŋunhi yolŋuny mala malthurrnydja nhanŋu, gäŋalnydja walal gan ŋunhi yikin mala ga birkun' mala. Ga djuy'yurrnydja walalany gan ŋunhi ŋunhiwurrunhany yolŋuny walalany ŋuriŋiwurruynha ŋunhi ŋurruŋu djirrikaymirriynha mala ga ŋurru-warryunayŋuynha mala ga rom-djägamirriynha mala. ");
INSERT INTO djr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yurr ŋayiny ŋunhi Djudatjthuny ŋäthil walalany waŋan bitjarr gam', “Nhämany nhuma dhu ŋarrany balanyalil gam', ŋunhi ŋarra dhu marrtji, ga wälkum ŋarra ŋanya dhu dhakal, ŋunhiyiny ŋarra dhu ŋanya lakaraman nhumalaŋgala. Bala nhumany dhu yan ŋanya ŋayathaman,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ga dhunupan bala yan ŋayi Djudatjtja marrtjinan bala yan dhärranan nhanukal Djesuwalnydja galkin, bala ŋayi bitjarra waŋanany nhanŋu, “Nhämirr Marŋgikunhamirr?” Bala yan ŋayi ŋanya wälkuŋala. ");
INSERT INTO djr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ga ŋayiny Djesuny nhanŋu buku-bakmaraŋal bitjarr, “Ḻundu ŋarraku, nhaku nhe dhuwal räliny marrtjin.” Bala yan walalnydja ŋanya ŋayathaŋala Djesunhany rambuŋala, bala yan ḏapmaraŋala ŋanya. ");
INSERT INTO djr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ga ŋunhi walal gan dhärra'-dharranany ŋunhiliyiny ga ŋayiny nhakun waŋganydhuny yolŋuy dhawaṯmaraŋal yikin nhanŋuwuy ŋayi, bala djatthurra waŋganynhany ḏirramuny, gulkmaraŋala ŋanya buthurun. Ŋunhiyiny djämamirr ŋurikiyin ŋunhi ŋurruḏawalaŋuwnha djirrikaymirriw yolŋuw. ");
INSERT INTO djr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yurr ŋayiny Djesuny bitjarr warray waŋan nhanŋu gam', “Mandjawak dhuwali nhuŋuwuy nhe rulwaŋdhurr. Ŋuli nhe mari-ḏumurrnydja yolŋu nheny dhu ŋunhi rakunydhirr ŋunhilin bili yan mariŋura nhokiyingal nhe. ");
INSERT INTO djr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yaka yan nhuma dhuwal marŋginy, ŋarra balaŋ dhuwal waŋi ŋarrakuwuy ŋarra Bäpa'mirriŋuny, ga dhunupan bala yan ŋayiny ŋunhi djuy'yurr nhanŋuwuy ŋayi dhäwu-gänhamirrinhany mala ŋula nhämunhan yan dharrwan dhika mirithirra guŋga'yunarawnydja ŋarraku? ");
INSERT INTO djr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Yurr bäydhi, märr ŋayi dhu ŋunhi dhäruk mala ŋunha ŋäthiliŋuŋur dhuyuŋur djorra'ŋur, maḻŋ'thun yan yuwalkthirr!” ");
INSERT INTO djr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Bala ŋayi Djesuny yan waŋanan walalaŋ ŋurikiwurruŋguny ŋunhi yolŋu'-yulŋuwnydja bitjarra gam', “Nhaku muka nhuma dhuwal räliny marrtjin birku'mirrnydja ga galiwaŋmirrnydja ga yikimirrnydja, ga ḏapmaranharawnydja ŋarraku, nhakun ŋarrany ŋula nhän rom-bakmaranhamirra yolŋu? Ga ŋunhi ŋarra ŋuli ganha bitjana bili walu-ŋupana nhinanha ŋunhalnydja ŋunhi buku-ŋal'yunamirriŋurnydja buṉbuŋur marŋgikuŋalnydja gan yolŋunhany walalany, ga yaka warray nhumany ŋunhi balanyamirriynydja ŋarrany ḏapmaranha? ");
INSERT INTO djr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yurr bäydhi ŋayi dhuwali bitjarryiny maḻŋ'thurr, märr ŋayi dhu ŋunhi djawarrkmirriwuŋuny walalaŋguŋ wukirripuynydja maḻŋ'thunna yuwalkthirra.” Bala yan walalnydja ŋunhi malthunamirrnydja mala nhanŋu Djesuwnydja waṉḏi'-waṉḏinan bukmaknha yan, ga ganarrthaŋalnydja walal ŋunhi ŋanyapinyan yan Djesunhan. ");
INSERT INTO djr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ga beŋuryiny dhurrwaraŋur ŋunhi walal Djesuny ḏapmaraŋalnydja, bala walal yan balan ŋanya ŋunhi gämany wäŋalilnydja ŋurikalyin ŋurruḏawalaŋuwala djirrikaymirriwala yolŋuwalnydja yäkuwal Gäyapatjkala, ga bukmak ŋunhi ŋurru-warryunayŋu mala, ga Rom-marŋgikunhamirr mala, ŋunhi walal ŋuli ga Mawtjitjku rom marŋgikum, ḻuŋ'thurra marrtjin walal balayin, dhärukkun bakmaranharaw. ");
INSERT INTO djr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Yurr ŋayiny gan ŋunhi Betany marrtjin dhuḏikurr, yurr märr-barrku, munguyurryi ŋanya marrtjin bala. Bala ŋayi ŋunhi Betany gulŋiyinan ŋunhiwiliyiny ŋunhi ŋurruḏawalaŋuwala djirrikaymirriwal ŋärra'lil yurr märr warraŋul yan. Bala ŋayi dhunupan marrtjinan, dhutnha nhinan miriŋuwala mala, märr ŋayi dhu ga nhäma galkiŋur nhä mala dhu ga maḻŋ'thun. ");
INSERT INTO djr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ga ŋunhalnydja ŋunhi djinawany' buṉbuŋurnydja walalnydja gan ŋunhi ŋurruŋu djirrikaymirrnydja mala ga bukmak ŋunhi rom-djägamirrnydja mala buku-manapanminan, bala walal gan ŋunhi djälthinany walal dhu Djesunhany dhiŋganhamaraman yan. Ga yolŋuny walal gan dhabi-dhä-birrka'yurr, märr walal dhu ga ŋula dhäwu lakaram nyäḻ nhanukalaŋawuy Djesuwalaŋawuy ŋunhal ŋunhi ŋärra'ŋur. ");
INSERT INTO djr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Yurr bäyŋun walal ŋula waŋganynha yolŋuny maḻŋ'maranha, ŋayi balaŋ nyäḻ'yuna dhäwu lakaranha nhanukalaŋawuy Djesuwalaŋawuy, bäydhi ŋunhi dharrwany gan nhakun yolŋu mala marrtjin balayiny, ga wiripuwurruynydja gan nyäḻyurra dhäwu lakaraŋal nhanukalaŋawuy ŋunhili djinawa' ŋärra'ŋur. Ga beŋuryiny bala walal ŋunhi märrma'nhan ḏirramuny maṉḏany gäŋal balayin ŋärra'lila, bala maṉḏan ŋunhi bitjarra lakaraŋalnydja gam', ");
INSERT INTO djr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Dhiyaŋuny gan ḏirramuy lakaraŋal yanbi ŋayi dhu ḻarrmaraŋ ŋunha ŋunhi God-Waŋarrwu buku-ŋal'yunamirr buṉbu, ga buluyi ŋayi dhu dhuḻyurr, bäy dhu ḻurrkun' munha djuḻkthurr.” ");
INSERT INTO djr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Bala ŋayiny ŋunhi ŋurruḏawalaŋuny djirrikaymirr dhärranany bala dhä-birrka'yurra ŋanya Djesunhany bitjarra gam', “Muka ŋula nhe dhu waŋa gunganhamirr nhunapinya nhe ŋurukuny dhäwuw, wo bäyŋun? Dharaŋan muka nhe ga dhuwal yulŋuny ŋunhany dhäwu?” ");
INSERT INTO djr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yurr ŋayipiny gan ŋunhi Djesuny mukthurra dhärran yan. Bala yan ŋayiny ŋuriŋiyi ŋurruḏawalaŋuynydja djirrikaymirriy ŋanya bitjarra gam', “Ŋarrany nhuna dhu nhunany dhuwal buku-guykthuna bili ŋayi ga dhuwal walŋaynydja God-Waŋarryu nhäman nhuna, nhe dhu yuwalknha yan dhäwuny lakaram. Go! Mak lakaraŋun napurruŋgal, muka nhe dhuwal ŋunhi Maŋutji-dhunupayanhawuynydja yolŋu, Gäthu'mirriŋu God-Waŋarrwuny?” ");
INSERT INTO djr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“Nhokal ga dhuwaliyiny matha dhawaṯthun.” Bitjarr warray ŋayiny Djesuny buku-bakmaraŋal. Ga bulu ŋayi bitjarrnydja muka waŋan gam', “Märr-yuwalk ŋarra nhumalaŋ ga dhuwal bukmakku yan lakaramany, galki nhuma dhu nhäman ŋanya Yolŋunhany Gäthu'mirriŋuny, ŋayi dhu ga nhinan ŋunhala dhunupa'ŋuŋura gali'ŋunydja nhanukalnha God-Waŋarrwalnha ŋunhi ŋayi Bukmak Yan Ganydjarr-Ḏumurr. Ga yarrupthurrnydja ŋayi dhu marrtji räliny maŋandhun beŋurnydja djiwarr'ŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Bala ŋayiny ŋunhi ŋurruḏawalaŋuny djirrikaymirr yolŋu mirithinan yan maḏakarritjthinany, bala marrtjin girrin' nhanŋuwuy ŋayi barr'parrmaraŋal, bala yan ŋayi waŋanany bitjarra, “Dhuwandja ḏirramu ga God-Waŋarrkunhamirra. Bilin, yakan limurr dhu buluny yolŋuwuŋ ŋäma dhäwu nhanukalaŋawuy? Bilin nhuma ŋanya ŋäkula dhäruktja waŋanhawuynydja. ");
INSERT INTO djr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nhaltjanna nhuma ga guyaŋany?” bitjarr. Ga walalnydja bukmaktja waŋan bitjarra, “Dhä-gir'yunna yan limurr dhu, märr ŋayi dhu dhiŋgaman yan!” bitjarra walal gan ŋunhi waŋanany nhanŋu Djesuwnydja. ");
INSERT INTO djr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bala marrtjin ŋunhi yolŋuynydja walal Djesunhany dhupthurra bukun, bala gan bumara bartjunmaraŋala, ga djäkurrun ŋanya goŋdhun walalaŋgiyingal walal. ");
INSERT INTO djr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ga waŋanany walal gan nhanŋu bitjarra, “Ma lakaraŋ yolthu nhuna wutthurrnydja, be muka nhe dhuwal Maŋutji-dhunupayanhawuy yolŋu?” ");
INSERT INTO djr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ga ŋunhiliyi warraŋulnha ŋärra'ŋur ŋayiny gan ŋunhi Betany nhinan, ga ŋayiny bäy waŋgany miyalk djämamirr marrtjin bala nhäŋala ŋanya ŋunhiwiliyi, bala ŋayi waŋanan ŋanya dhä-birrka'yurra bitjarra, “Way, nhe dhuwal wiripuny muka, ŋunhi nhuma gan malthurr nhanŋu Djesuw? … ŋurikiyi ŋunhi wäŋa Galalipuywu?” ");
INSERT INTO djr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yurr ŋayiny Betany milma yan bukmakkal yolŋuwal walalaŋgal bitjarr warray waŋan gam', “Nyäḻnydja bay! Yaka ŋarra marŋgi nhäpuy nhuma ga dhuwaliyi waŋa.” ");
INSERT INTO djr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ga ŋunhi ŋayi Beta dhawaṯthurrnydja bala dhurrwaralilnydja, ga wiripuynydja muka djämamirriy miyalkthu ŋanya nhäŋal bala waŋanan wiripuwurruŋgala yolŋu'-yulŋuwal, ŋunhi walal marrtjin dhärra'-dharran' ŋunhili bitjarra, “Dhuwal ŋunhi waŋganydja ḏirramu, ŋunhi ŋayi gan malthurr nhanŋu Djesuw wäŋa-Nätjuritjpuywu.” ");
INSERT INTO djr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ga ŋayiny Betany bulu dhumbal'yurr, yurr dhiyaŋuny bala ŋayi märr ḏälnha dhäruk waŋan bitjarra, “Märr-yuwalk! Yaka ŋarra nhanŋu dhuwal marŋgi!” ");
INSERT INTO djr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ga yaka wiyin ga wiripuwurrnydja yolŋu walal ŋunhi walal gan dhärra'-dharran ŋunhili, marrtjin nhanukal Betawal ga waŋan nhanŋu bitjarr, “Marŋgi napurr dhuwal, ŋunhi nhe dhuwal waŋganydja beŋuryi malaŋur. Bili nhe dhuwali gandany ga dhäruktja ga waŋa nhakun ŋunhaŋuwuynha wäŋa-Galilipuynha.” ");
INSERT INTO djr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bala ŋayiny ŋunhi Betany mirithinan yan waŋan gumurr-dhar'yunminan ŋanyapinya ŋayi ḏälyun dhärukthuny dhika bitjarra gam', “God-Waŋarrnha dhuwal ŋarrakuny marŋgi, ŋunhi ŋarrany dhuwal dhuŋan ŋurikiyiny ḏirramuw, yolnha nhuma ga dhuwali lakaram?” Ga ŋunhi ŋayi ga bitjandhiny waŋa, bala dhunupan ŋunhi gurrwawuny ŋäthin. ");
INSERT INTO djr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bala yan ŋayi guyaŋan ŋunhi nhaltjan nhanŋu Djesu waŋa bitjan, “Ga yorrnha ŋayi dhu ŋunhi gurrwawuny waŋa buku-märrma'mirrnydja, nheny ŋathil ŋarraku dhu dhumbal'yun buku-ḻurrkun'mirr.” Bala yan ŋayi Betany dhawaṯthurrnydja, bala yan ŋäthinan dhika murruy'-murruyyurra. ");
INSERT INTO djr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","2","Yo wiripuynha waluy yurr goḏarrmirra, walalnydja ŋunhi ŋurruŋu djirrikaymirrnydja yolŋu mala ga ŋaḻapaḻmirrnydja ga Rom-marŋgikunhamirrnydja mala ganydjarryun yan waŋanhaminany. Ga garrwi'yurr walal Djesuny goŋ, bala maŋutji-warryurra balan Bäylitkala, ŋunhi ŋayi buŋgawa wäŋaw-ŋayathanharaw makarrwu Djudiyaw. ");
INSERT INTO djr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ga ŋunhi ŋayi Djudatjthu ŋäkulnydja ŋunhi Djesunhany walal dhä-gir'yurrnydja dhiŋganharawnha yan, bala ŋayi ḻiya-gulinybunhaminan, bili ŋayi ŋunhi djäma mirithirr yätjkurr rom nhanŋu, galkar ŋanya marilil. Bala yan ŋayi ŋunhi 30-ny ŋaraka rrupiya mala roŋanmaraŋala ŋurikiwurruŋguny ŋunhi ŋurruŋu djirrikaymirriwnydja mala ga ŋurru-warryunayŋuwnydja yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Bala ŋayi ŋunhi Djudatjtja bitjarra waŋan gam', “Dhuwal ŋarra mirithirr yan yätjkurr djäma rom, djarrma'-gäŋal ŋarra yolŋuny ŋunhi ŋayi bäyŋu djäma ŋula nhä yätjkurr.” Yurr walalnydja ŋunhiwurrnydja ŋunhi ḻiya-ŋärra'mirrnydja mala ga rom-djägamirrnydja mala nhanŋu bitjarr warray buku-bakmaraŋal, “Ga nhakun nhe ga napurruŋgalnydja lakaram, dhuwaliny nhuŋun warwu yakan ŋanapurruŋ.” ");
INSERT INTO djr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Bala ŋayi ŋunhi Djudatjthuny rarr'yurrnydja ŋunhiyi rrupiyany balayin ŋunhi buku-ŋal'yunamirrilila buṉbulilnydja, bala yan ŋayi marrtjinan dhawaṯthurra bala mayaŋ'nha ŋanyapinya ŋayi garrwi'yunmin rakiy'nha rakunygunhaminan yan. ");
INSERT INTO djr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bala walal ŋunhi ŋurruŋu djirrikaymirriynydja walal märraŋala ŋunhiyi rrupiyany bala bitjarra waŋanany, “Dhuwandja rrupiya mala ŋoy-dhaḻ'nha, yolŋuny limurr bumar, yakan limurruŋ dhuwal dhunupa limurr dhu balayiny roŋanmaram ŋunhi buku-ŋal'yunamirrililnydja buṉbulil, ŋunhi ga wiripu mala rrupiya ŋorra.” ");
INSERT INTO djr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ga beŋuryiny bala walal waŋanhaminan walal dhu wäŋa ŋaraka märram beŋur ŋunhi yolŋuwal ŋunhi ŋayi ŋuli ga djäma banikin' mala ḏilkurr dhoḻuy, märr walal dhu ŋunhi wäŋany bäki molukuman ŋurikiwurruŋgun ŋunhi mulwu'-mulwurwun yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ŋunhi gan bitjarryiny maḻŋ'thurr walalaŋ, dhiyakun gämurruw' ŋunhi dhiyaŋ bala baḏak walal ŋuli ga yolŋu'-yulŋuy lakaram ŋunhiyi wäŋa bitjan “Maŋgu'mirr Wäŋa” ");
INSERT INTO djr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Bala nhanŋuny ŋunhi djawarrkmirriwnydja yäkuw Djirimayawnydja dhäruk rumbalthinan, ŋunhi ga bitjan waŋa gam', “Bala walal märraŋala ŋunhiyiny 30-ny ŋaraka rrupiya, ŋunhi walal ŋuriŋiyi wuŋiḻi'yurr yolŋuw beŋur malaŋur ŋunhi Yitjuralwal bäpurru'ŋur. ");
INSERT INTO djr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bala walal ŋunhiyin wäŋany ŋarakany märraŋala ŋunhi ŋayi ŋuli ga ŋuriŋiyi yolŋuy djäma dhoḻu mala banikin' yindimirr.” ");
INSERT INTO djr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Bala walal ŋanya Djesunhany gäŋala Bäylitkala ŋunhi ŋayi buŋgawa wäŋaw-ŋayathanharaw dhä-birrka'yunarawnha, ga bitjarra ŋayi ŋunhi dhä-birrka'yurrnydja gam', “Nhä nhe dhuwal Buŋgawa Ŋurruḏawalaŋu Djuw bäpurruw?” Ga ŋayiny Djesuny bitjarr warray waŋan, “Nhuŋu dhuwaliny dhäruk.” ");
INSERT INTO djr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ga dharrway mirithirr gan ŋunhi rom-nyamir'yurrnydja ŋanya, dhäwuny mala gan lakaraŋal djarrpi'kuŋalnydja nhanukalnydja Bäylitkalnydja, ŋuriŋiwurruynydja ŋunhi ŋurruŋu djirrikaymirriynydja mala ga ŋurru-warryunayŋuynydja mala, yanbi ŋayi gan djäma yätjkurra mala rom. Yurr ŋayiny Djesuny gan mukthurra yan dhärran. ");
INSERT INTO djr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ga buluyi ŋayi Bäylitthu ŋanya dhä-birrka'yurr bitjarr, “Ŋäma muka nhe ga, ŋunha walal ga lakaraman nhokalaŋawuy, nhä malany yätjkurr rom nhe gan djäma?” ");
INSERT INTO djr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yurr ŋayiny Djesuny bäyŋun ŋula waŋanha, bala ŋayiny ŋunhi Buŋgawany wäŋawnydja ŋayathanharaw Bäylittja mirithinan dhika märr-maŋmaŋdhurr nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ga balanyamirriy waluy ŋunhi Ḻäy-djuḻkmaranhamirriynydja, bitjanna bili dhuŋgarra-ŋupanna, Bäylitthu ŋunhi ŋayi buŋgawa wäŋaw-ŋayathanharaw, ŋuli dhawaṯmaranha waŋganynha yolŋuny beŋur dharruŋguŋur, yolku walal djäl yolŋu'-yulŋuw mala dhawaṯmaranharaw. ");
INSERT INTO djr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ga balanyamirriyyi gan gärrin yolŋu yäku Barabatj, ŋunhiliyi dharruŋguŋur. Ga yäkuny ŋayi yindi, bili nhanukal ŋuli ganha malay ḻikandhu ŋurrkanha buŋgawany mala ga Gapmannha mala yolŋu'-yulŋuny. ");
INSERT INTO djr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Manymak ŋunhi walal marrtjin yolŋu'-yulŋuny ḻuŋ'thurrnydja, bala ŋayiny Bäylithuny ŋäŋ'thurra walalany, bitjarra gam', “Yolnha ŋarra dhu dhawaṯmaramany dhika, yolku nhumany djäl dhawaṯmaranhaw? Dhiyak yolŋuw yäkuw Barabatjku wo Djesuw ŋunhi ŋayi wiripuny yäku Maŋutji-dhunupayanhawuy?” ");
INSERT INTO djr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ga baman' ŋayi ŋunhi Bäylittja marŋgithin ŋunhi walal ŋanya Djesunhany gäŋal balayiny nhanukalnydja bili walal gan ŋanya ŋunhi mel-ḏiy'yurr ŋuriŋiwurruy ŋunhi ŋurruḏawalaŋuy mala. ");
INSERT INTO djr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ga ŋunhi ŋayi gan baḏak muka yan Bäylitthuny mala-djarr'yurr ŋunhiyi rom, bala ŋayi yan dhäwun märraŋal nhanukalaŋawuŋ miyalkkuŋun, ga bitjarra ŋayi gan ŋunhi lakaraŋalnydja gam', “Dhuwaliny ḏirramu dhä-marimiriw, yaka ŋanya dhä-gir'yurr, ganarrthul ŋanya. Bili ŋarrany gan dhuwal ŋula nhän mäwa'yurrnydja yätjkurra yan mirithirra galŋa-yätjinyamirra, bili nhuma ga ŋanya dhuwali dhä-gir'yun.” ");
INSERT INTO djr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yurr walalnydja ŋunhi ŋurruŋu djirrikaymirriynydja ga ŋurru-warryunayŋuynydja mala ŋaḻapaḻmirriy gan gur'kur-gurruparnha yolŋunhany walalany, walal dhu ŋäŋ'thundja Bäylitnhany nhanŋun Barabatjkun dhawaṯmaranharawnydja. Ga ŋanyanhany Djesunhany dhu buman rakunyguman yan. ");
INSERT INTO djr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ga ŋayiny bulu Bäylitthuny walalany ŋäŋ'thurr ŋunhi ŋayi buŋgawa wäŋaw-ŋayathanharaw bitjarr gam', “Yolku dhika nhuma djälnydja, ŋarra dhu dhawaṯmaramany, ŋanya, dhuwal Barabatjnha wo Djesuny?” “Barabatjnha!” Ga walalnydja bitjarr warray waŋan, bukmaktja yolŋu walal. ");
INSERT INTO djr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ga bulu ŋayi Bäylitthu waŋan walalany bitjarr, “Ga nhaltjanna ŋarra dhu dhuwandja gay'yi ḏirramuny Djesunhany, ŋunhi ŋayi wiripuny yäku Maŋutji-dhunupayanhawuy?” Ga walalnydja bukmak yan waŋan yatjunmin bitjarr, “Dhuḻ'yurra ŋanya dharpalila!” ");
INSERT INTO djr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ga ŋayiny Bäylittja waŋan, “Nhä ŋayi ŋula miḏikumarnydja djäma?” “Dhuḻ'yurra yan ŋanya dharpalilyaŋun,” bitjarr warray walalnydja yatjunmin mirithinan yan dhika. ");
INSERT INTO djr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ga ŋayiny Bäylittja marŋgithinan, ŋunhi ŋayi buluny ganydjarrmiriwyinan, bili ŋayi nhäŋalnydja ŋunhi yolŋu'-yulŋunhany walal ganydjarr bunanan marrtjin mariwnha djämaw. Bala yan ŋayi gapun märraŋal, bala ŋayi goŋnha rurrwuyunmin gumurrŋura walalaŋgal, ga waŋanany ŋayi bitjarra gam', “Bilin dhuwal, ŋarrany dhu yakan mala-manapan nhumalaŋgal, dhuwandja ḏirramu nhumalaŋgalnha goŋŋur. Nhuman dhu bumany ŋanya rakunygumany!” ");
INSERT INTO djr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ga walalnydja bukmak yan buku-bakmaraŋal bitjarr gam', “Ŋanapurruny ga mala-bunhawuynhan mala ŋanapurruŋguŋ, nhuma dhu gi ŋunhi dhuwalaŋuwuynydja maŋutji-gäŋu, ŋunhi ŋanapurrnha dhiyakuny ḏirramuw yoraŋal dhiŋganharawnydja.” ");
INSERT INTO djr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Bala ŋayi yan Bäylitthuny Barabatjnhany ḏirramuny dhawaṯmaraŋala. Ga beŋuryiny ŋayi waŋanan miriŋunhany mala nhanŋuwuy ŋayi, bunharawnha nhanŋu Djesuwnydja ga bartjunmaranharawnha ŋuriŋiyin burriṯiŋuynha, ga dhuḻyunarawnha dharpalila mälakmaranhawuylila. ");
INSERT INTO djr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bala walal ŋunhi miriŋuynydja mala nhanukal Bäylitkalnydja ŋunhi ŋayi buŋgawa wäŋaw-ŋayathanharaw, gäŋalnydja ŋanya Djesunhany balan bitjarra djinawa'lilnha wäŋalila nhanukala Bäylitkala. Ga wäthurr walal wiripuwurruŋ miriŋuw mala bukmakku yan. ");
INSERT INTO djr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bala walal yan ḻarrmaraŋala girriny' nhanŋu Djesuwnydja, ga nhirrparnydja walal nhanukal wiyinnha dhika girriny' miku'mirra miny'tjiny. ");
INSERT INTO djr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ga ḻiyaw gurrukanharaw walal nhanŋu djäma ḏirriṯirrin, bala yan nhirrparnha nhanukal. Ga dhunupa'ŋulilnydja goŋlil walal nhanukal gurrupar dharpan, ŋayathanharawnha nhanŋu. Bala walal gan ŋunhi miriŋuynydja mala warku'yurra ŋanya Djesunhany, dhika nhaltjarra bun'kumu-djipthurra nhanukal, nyäḻyurra gan buku-ŋal'yurr nhanŋu, bala gan yatjurra waŋanany bitjarra gam', “Yo! Ŋurruḏawalaŋu, Buŋgawa Djuw-malaw!” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Bala walal gan dhupthurra ŋanya beŋuryiny. Ga dharpa walal ŋanya gombuŋal, bala muḻkurrnha ŋanya ŋuriŋiyiny dharpaynydja wutthurr. ");
INSERT INTO djr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ga ŋunhi walal miriŋuny mala dhawar'yurrnydja warku'yunaŋurnydja nhanukal Djesuwalnydja, bala walal yupmaraŋala nhanukal ŋunhi wiyindja girri' miku'mirrnydja miny'tji, bala yan nhanŋuwuynha girri' nhirrpar nhanukal. Ga beŋuryiny bala walal ŋanya marrtjin warryu'-warryurra balan bitjarra dhuḻyunarawnha dharpalila mälakmaranhawuylila. ");
INSERT INTO djr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ga ŋunhi walal gan marrtjinany bala-a-a, ga gandarrŋurnydja bala walal nhäŋal ḏirramunhan beŋura wiripuŋura wäŋaŋur yäkuŋur Djäriniŋura. Ga yäkuny ŋayi ŋunhi yolŋuny Djäyman. Bala walal ŋunhi miriŋuynydja mala dharrwunuŋala ŋanya, märr ŋayi dhu dharpa ŋunhiyi gäma mälakmaranhawuy nhanŋu Djesuw. Ga yuwalkthi ŋayiny djäman yan. ");
INSERT INTO djr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Marrtjinany walal gan, bala yan bunanan ŋunhilin wäŋaŋur yäkuŋur Gulkathan, ga mayaliny' ŋayi ŋunhiyi wäŋany yäku, “Ḻiya Ŋaraka Wäŋa”. ");
INSERT INTO djr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ga ŋunhiliny walal ŋanya gurrupar Djesuny wiyika borum mel-manapanawuy mirritjin'mirr, märr ŋayi dhu ŋuriŋiyi guŋga'yun burrumunuŋgum ŋunhiyi rerri nhanŋu. Yurr ŋayiny ŋunhi Djesuynydja dhäkaynydja ḻukan ŋunhiyiny wiyikany', bala yan ŋayi yaka'yurra ŋurikiyi wiyikawny'tja. ");
INSERT INTO djr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bala walal ŋanya miriŋuynydja mala dhuḻyurra dharpalila mälakmaranhawuylila. Ga beŋuryiny bala walal gan buḻ'yurra namban mala, girriw'nha nhanŋu Djesuw yolthu dhu märram ŋunhiyi. ");
INSERT INTO djr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Bala walal gan ŋunhi nhinanan ŋunhilin bili yan djägan manapar nhanŋun Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ga garrwarlilnydja dharpalil walal ŋal'maraŋal dhärukmirra dharpa, ŋunhi gan maŋutji-lakaraŋal nhaku ŋanya walal ŋunhi dhuḻyurr ŋunhiwiliyi dharpalil mälakmaranhawuylil, ga bitjarra gan ŋunhi dhäruktja waŋan, “Dhuwandja Djesu, ŋunhi ŋayi Buŋgawa Ŋurruḏawalaŋu Djuw malaw.” ");
INSERT INTO djr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ga bitjarryi bili walal ŋunhi märrma'nhany ḏirramuny maṉḏany rom-bakmaranhamirrinhany maṉḏany ŋal'maraŋalyi dharpalil, waŋganynhany walal ŋal'maraŋal dhunupa'ŋulil, ga waŋganynhany ga wiṉ'kuŋulila gali'lil. ");
INSERT INTO djr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ga ŋunhi gan yolŋu mala marrtjin djuḻkmaraŋalnydja ŋanya Djesunhany, ga ḏawaḏawa'yurr walal gan, warku'yurr manapar ŋanya. ");
INSERT INTO djr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ga bitjarra walal gan ŋunhi waŋanany nhanŋu yatjurrnydja gam', “Wäy! Be muka nheny dhu dhuwal bakmaraŋun ŋunha ŋunhi buku-ŋal'yunamirrnydja buṉbu, ga buluyi nhe dhu dhuḻ'yurryi ḻurrkun'thuny waluy! Ŋuli nhe be God-Waŋarrwuny Gäthu'mirriŋu, biyakun walŋakunhamirra nhunapinya nhe, ga yarrupthurra dhipuŋuryiny dharpaŋur mälakmaranhawuyŋurnydja!” ");
INSERT INTO djr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ga ŋuriŋiwurruy ŋurruŋu-djirrikaymirriy mala ga ŋurru-warryunayŋuynydja ŋaḻapaḻmirriy mala, ga rom-marŋgikunhamirriynydja mala, ŋunhi walal ŋuli ga marŋgikum Mawtjitjkuŋ Rom malany, walalnydja gan ŋunhi bitjarryi bili warku'yurryi ŋanya Djesuny. Ga bitjarra walal gan ŋunhi waŋanany, ");
INSERT INTO djr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Way, dhuwandja ŋayi gan walŋakuŋalnydja ŋunha wiripuwurruny? Ga yakan ŋayi dhu dhuwal ŋanyapinyany ŋayi walŋakunhamirr? Ŋuli ŋayi be Buŋgawany Ŋurruḏawalaŋuny Yitjuralwuny bäpurruw, ŋayiny balaŋ yan yarrupthurra beŋurnydja dharpaŋurnydja! Bala limurrnydja dhu nhanŋu märr-yuwalkthirra. ");
INSERT INTO djr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Be muka ŋayi gan nhanukal God-Waŋarrwal märr-nhirrpanmin, ga ŋuli ŋayi djälnydja ŋayi dhu ŋanya ŋayipi yan God-Waŋarryu walŋakumany. Bili wiripuny ŋayi gan ŋunhi lakaranhamin be yanbi ŋayi God-Waŋarrwun Gäthu'mirriŋu.” ");
INSERT INTO djr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ga maṉḏany muka ŋuriŋiyiny ŋunhi rom-bakmaranhamirriynydja maṉḏa warku'yurryi ŋanya Djesuny. ");
INSERT INTO djr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yo. Ga ḏämbuynha waluy, bala wäŋany ŋunhi buku-munha'yinan warrpam'thurra yan, ga dhärranany gan ŋunhi buku-munhan', ga yan bili, ga ŋuruŋun ḻäy-bilyunaraynha waluy, 3-ynha ḏaykun'thu. ");
INSERT INTO djr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bala ŋayi balanyamirriyyiny waluy Djesuny ŋayipiny yatjurra mirithinan dhika, bitjarrnha gam', “Yelay! Yelay! Lama djabakthani?” Ŋunhiyiny dhäruk mayali' balanyawuynha gam', “God-Waŋarr ŋarraku! God-Waŋarr ŋarraku! Nhaku ŋarrany nhe dhuwal ganarrthaŋalnydja?” ");
INSERT INTO djr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ga wiripuwurruynydja yolŋuy walal ŋunhi walal gan dhärra'-dharran ŋunhili, ŋäkulnha ŋanya Djesunhany balanyawuyyiny waŋanhawuy, bala walal waŋanhaminan bitjanminan, “Ŋunha ŋayi ga wäthunna Yilaydjawnha!” ");
INSERT INTO djr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ga dhunupan ŋayiny waŋganydja ḏirramu waṉḏin bala yan manydjarrkan' märraŋal, bala ŋayi yan ḻupmaraŋala wiyika'lila borumlila, bala marrtjin dharpaynha garramatkuŋal nhanukala Djesuwalnha. ");
INSERT INTO djr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yurr wiripuwurrnydja waŋan bitjarra gam', “Baḏak limurr galkun, wanha balaŋ ŋayi dhu Yilaydja marrtji, ga walŋakum ŋanya.” ");
INSERT INTO djr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ga dhäŋur beŋuryiny, ŋayiny buluyi Djesuny, yatjurr mirithinan dhika, bala ŋayi yan dhiŋgaŋalnha. ");
INSERT INTO djr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ga dhunupan bala yan ŋunhi manydjarrkany' ŋunhi gan gorruŋal ŋunhal ŋunhi God-Waŋarrwal buku-ŋal'yunamirriŋur buṉbuŋur, ŋunhiyiny yan barr'yurra beŋur bili bukuŋur ga yan bili-i-i ga ŋoylil ŋurrkaŋal, bala ŋunhi manydjarrkany' maṉḏany barrkuwatjthinan. Ga munathany' marrtjin dhuwandja wäŋany marrmarryurra, ga guṉḏany mala marrtjin barr'parryurra. ");
INSERT INTO djr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ga moluny mala marrtjin ŋunhi dhurrwarany-ḻapḻapthurra, ga dharrwan gan ŋunhi mirithirra God-Waŋarrwuny yolŋu walal rur'yurrnydja walŋathinany beŋurnydja ŋunhi dhiŋganhaŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ga dhäŋur beŋuryiny ŋunhi ŋayi Djesu walŋathinany beŋur dhiŋganhaŋurnydja, bala walalnydja ŋunhiwurrnydja yolŋu'-yulŋu ŋunhi walal moluŋur rur'yurr, walalnydja ŋunhi yan marrtjinan balan ŋunhi dharrpallila wäŋalil Djurutjalamlila. Ga ŋunhilin walalany gan ŋunhi dharrwaynydja yolŋuy walal nhäŋal. ");
INSERT INTO djr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ga ŋunhili gan dhärran dhuḏiŋur dharpaŋur ŋurru-warryunayŋu miriŋuw malaŋuw, ga wiripuwurr miriŋu mala, ŋunhi walal gan djäga Djesuw. Ga dhäkay-ŋäkul walal ŋunhi bukmakthu yan ŋunhi ŋayi gan dhuwal munathany' wäŋa marrmarryurra. Ga bulu walal nhäŋal bukmakthu yan nhä malany gan ŋunhi maḻŋ'thurr walalaŋ balanyamirriy. Bala walal ŋunhi mirithinan yan barrarinany, bala bitjarra walal waŋanany gam', “Yuwalk muka dhuwandja yolŋu God-Waŋarrwu yan Gäthu'mirriŋu!” ");
INSERT INTO djr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ga wiripuny miyalkkurruwurr gan ŋunhiliyi dhärran, yurr märr barrku walal gan ŋunhi dhärra'-dharranany, nhäŋalnydja. Yo ŋunhiwurryiny ŋunhi miyalkkurruwurr ŋunhi walal gan Djesuwnha malthurr beŋura Galaliŋura guŋga'yunaraw nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ga dhuwalawurr ŋunhi yäkuny miyalkkurruwurrnydja gam', Meri Magdalawuy, ga wiripuny Meri, ŋäṉḏi'mirriŋu maṉḏaŋ Djayimgu ga Djawutjipku. Ga wiripuny maṉḏaŋ ŋäṉḏi'mirriŋu Djongu ga Djayimgu. Dhuwalawurryi, ga bulu wiripun mala miyalkkurruwurr gan dhärran ŋunhili. ");
INSERT INTO djr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ga ŋunhi ŋayi marrtjin milmitjpayinany. Bala ŋayi ŋunhi ḻukunydjany' yolŋu malthunamirr yäku Djawutjiptja, ŋunhi wäŋa Yaramathiyawuynydja, marrtjinan ");
INSERT INTO djr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","bala ŋayi ŋäŋ'thurra ŋanya Bäylitnhany rumbalwun nhanukalaŋaw Djesuwnha. Bala ŋayiny Bäylittja yan yoraŋalnha nhanŋu Djawutjipkuny märranharawnydja nhanŋu Djesuwnydja rumbalwuny. ");
INSERT INTO djr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ga ŋunhi ŋayi Djawutjipthu märraŋalnydja rumbalnydja ŋanya Djesunhany, bala yan ŋayi marrtjin garrwi'-garrwiyurra ŋanya yuṯaynha dhomalaynydja. ");
INSERT INTO djr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bala ŋayi yan Djawutjipthuny märrkitjkuŋalnydja ŋanya rumbalnydja ŋunhiwilin ŋunhi nhanukiyingalnha ŋayi molulilnydja, yurr mathirra ŋunhi yulŋuny. Bili yuṯa yan ŋunhiyi moluny mathirrany, dhiyaŋ bili ŋayi yaw'yun. Ga beŋuryiny ŋayi yindin guṉḏa warryurr bala yan dhaḻ'yurra ḏälkuŋala ŋunhiyi dhurrwarany mathirrany, bala yan marrtjinan. ");
INSERT INTO djr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ga maṉḏany Meri Magdalawuy, ga wiripuny Meri, ŋunhili maṉḏa gan galki nhinan molumirriŋura. ");
INSERT INTO djr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ga wiripuŋuynha waluy, ŋunhi Djarratin, bala walalnydja ŋunhi ŋurruŋu djirrikaymirrnydja ga Baratjiny mala marrtjin rrambaŋin balany nhanukalnydja Bäylitkalnydja. ");
INSERT INTO djr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bala walal bitjarra waŋanany nhanŋu gam', “Yo! Marrkapmirr Buŋgawa, napurr ga dhuwal guyaŋa ŋunhi nhaltjarr ŋayi ŋuriŋiyi nyäḻ-ḏumurruy yolŋuy gan lakaraŋal balanyamirriy ŋunhi baḏak yan ŋayi gan walŋa nhinan. Ga bitjarra ŋayi gan ŋunhi waŋanany, yanbi beŋur ŋunhi dhiŋganhaŋurnydja, ḻurrkun' walu dhu djuḻkthurr bala ŋayi dhu bulu nhakun walŋathi. ");
INSERT INTO djr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Buku-djulŋi, dhiyakiyin dhuwal gämurruwnydja napurr ga nhuna dhu dhuwal waŋany, märr nhe dhu dhäruk-gurrupan ŋunha miriŋuw mala nhokalaŋaw, walal dhu ga djäga mirithirr yan märrma' munha ŋurukuny ŋunhi moluwnydja mathirrawnydja. Ŋuli nhe dhu yakany djäga, bala walalnydja dhu mak ŋunhi malthunamirrnydja mala nhanŋu marrtjiny bala djaw'yunna nhanŋu rumbalnydja, bala walal dhu ga ŋunhi bitjanna dhäwuny lakaram yolŋu'-yulŋuwnydja, yanbi ŋayi rur'yurra dhiŋganhaŋurnydja, ga dhuwandja dhu dhäwu ŋayi mirithirra djarrpi'thirr beŋurnydja ŋunhi ŋurruŋuŋurnydja dhäwuŋur, bala dhu nyäḻnydja mala dhäwu ŋunhi dharrwathin mirithin.” ");
INSERT INTO djr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bala ŋayiny Bäylittja bitjarra waŋan balany walalaŋguny, “Yo! Manymak, Gatjuynha märraŋun nhumalaŋguwuy nhuma djägamirrinhany mala, ga miriŋunhany mala, bala gi djägan ŋurikiyi mathirrawnydja ŋamathaŋun yan.” ");
INSERT INTO djr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bala yan walal mirithinan dhika ḏälku'-ḏalkuŋalnydja, ga mam'maraŋal rakiy'nha ŋunhiyi dhurrwarany mathirrany ga miriŋunhany mala muka nhirrpar balayi djägawnydja. ");
INSERT INTO djr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yo ŋunhiyiny Nhinanhamirrnydja walu djuḻkthurra, ga wiripuŋuynha waluy Djandin, yurr munhawumirra dhika yurrnha ŋayi marrtjin waluny djaḏaw'yurr, bala maṉḏany yan märrmany' miyalk maṉḏa, Meri Magdalawuynydja ga wiripuny Meri, marrtjinan maṉḏa balayin mathirralila, ŋunhi wanhawal walal Djesuny rumbal märrkitjkuŋal. ");
INSERT INTO djr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ga dhunupan bala yan, ŋunhi wäŋany munathany' marrtjin marrmarryurra dhika mirithinan. Bala beŋuryiny God-Waŋarrwuny dhäwu-gänhamirrnydja yolŋu yarrupthurra beŋurnydja djiwarr'ŋurnydja, bala yan ŋayi ŋunhi yindiny guṉḏa mathirraŋurnydja dhurrwarany giṯmaraŋala gali'lila bala ŋayi gan nhinanan ŋunhiliyin guṉḏaŋura. ");
INSERT INTO djr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ga rumbalnydja ŋayi ŋunhiyi djiwarr'puynydja yolŋu wiripun dhika, mirithirra djeŋarran' balanya nhakun maykarraṉ ŋuli ŋunhi milŋ'thun. Ga girriny' nhanŋu ŋunhi mirithirra dhika watharr. ");
INSERT INTO djr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ga walalnydja ŋunhi miriŋuny mala, ŋunhi walal gan djäga ŋurikiyi moluw mathirraw, walalnydja gan ŋunhi marrmarryurra walalaŋgiyingal barrariynydja, bala yan walal galkirrinan munatha'lila, ga bitjarra walal gan ŋunhi ŋorranany nhakun rakunymirra yolŋu'-yulŋu. ");
INSERT INTO djr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bala ŋayi ŋunhi God-Waŋarrwuny dhäwu-gänhamirrnydja waŋanan ŋuriki miyalkkuny maṉḏaŋ bitjarra gam', “Yaka maṉḏa barrari! Ŋarra marŋgi ŋunhi nhuma ga dhuwal ḻarrum Djesuw, ŋunhi walal ŋanya dharpalil mälakmaranhawuylil dhuḻyurr. ");
INSERT INTO djr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Bäyŋun ŋayi dhuwandja! Bilin ŋanya God-Waŋarryuny rur'maraŋala dhiŋganhaŋurnydja, walŋakuŋala, bitjarr yan bili nhakun ŋayi lakaraŋal nhumalaŋ ŋäthil. Go, go, muka marrtji walal ga nhäŋu wanhami nhanŋu gan rumbal ŋunhi ŋorran. ");
INSERT INTO djr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gatjuy, bondin walal yan marrtjiny! Bala yan lakaraŋun walalaŋgal ŋunhi malthunamirriwalnydja mala nhanukalaŋuwal, ŋunhi ŋanya God-Waŋarryuny bilin rur'maraŋala beŋur dhiŋganhaŋurnydja, ga walŋan ŋayi ga nhinany! Ga balan ŋayi ga dhuwal marrtjiny Galalilila. Balayin nhuma dhu ŋunhi marrtjiny, bala nhuma dhu ŋunhi ŋunhilin ŋanya nhämany.” ");
INSERT INTO djr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ga maṉḏany ŋunhi miyalktja maṉḏa mirithinan barrarinany, yurr djinawany' maṉḏaŋ ŋayaŋuny ŋunhi mirithinan yan dhika ŋoy-djulŋithinany, bala yan maṉḏa ŋunhi bondin yan waṉḏinany balany lakaranharawnydja nhanukalaŋuwal malthunamirriwalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ga ŋunhi maṉḏa miyalktja maṉḏa ŋurruyirr'yurrnydja marrtjinany, bala ŋayiny Djesuny dhunupan yan maṉḏaŋ bunanan ŋunhilin bili yan. Bala yan ŋayi Djesuny gumurr-ŋamathirra maṉḏaŋ. Ga maṉḏany ŋunhi marrtjinan yan nhanukal, bala marrtji ḻukun ŋanya ŋaya'-ŋayatham, buku-ŋal'yunna manapan. ");
INSERT INTO djr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Bala ŋayiny Djesuny bitjanna maṉḏaŋ waŋa, “Yaka maṉḏa barrariny! Yanan lakaraŋun ŋarrakalaŋuwal malthunamirriwalnydja walalaŋgal biyakun, walal dhu balan marrtjiny Galalilila, ga ŋunhilin walal dhu ŋarranhany nhäma.” ");
INSERT INTO djr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ga baḏak yan maṉḏany gan ŋunhi miyalktja maṉḏa marrtjin bala ŋunhi malthunamirriwalnha walalaŋgal, dhäwuwnha lakaranharaw. Ga walalnydja ŋunhi miriŋuny mala, ŋunhi walal gan djäga ŋurikiyi moluw mathirraw balan marrtjin yindilila wäŋalil, ŋunhi wanhal gan ŋurruŋu djirrikaymirr mala ga rom-marŋgikunhamirr mala nhinan. Bala yan walal marrtjin lakaraŋala bukmaknha yan dhäwuny mala ŋunhi nhä gan maḻŋ'thurr walalaŋ ŋunhili mathirraŋur. ");
INSERT INTO djr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bala walal ŋunhi ŋurruŋu djirrikaymirrnydja mala ga ŋurru-warryunayŋuny ŋaḻapaḻmirr mala ḻuŋ'maranhaminan, bala walal gan ḻiya-ŋamaŋamayunminan walal dhu dhä-mukmaraman rrupiyaynha ŋunhiwurrunhany ŋunhi miriŋunhany mala. ");
INSERT INTO djr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ga bitjarra walal gan ŋunhi waŋanany walalaŋ miriŋuwnydja mala gam', “Bitjanna nhuma dhu ga ŋunhi lakaramany ŋunhi Djesuw malthunamirr mala marrtjin munhawu, bala yan djaw'yurra nhanŋu rumbalnydja, balanyamirriy ŋunhi napurrnydja gan yakurr yan ŋorran. ");
INSERT INTO djr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ga ŋuli ŋayi dhu dhuwal ŋuriŋiyi Buŋgawaynydja ŋäma dhäwu ŋunhi nhanukal dhuwal goŋŋur wäŋa, limurrnydja dhu yan lakaraman nhanukal. Napurr dhu ŋanya bilmaram ŋunhi nhumany dhuwal wäwunŋu malany. Yurr nhumany dhu yakan warwuyun.” ");
INSERT INTO djr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Bala yan walal ŋuriŋiwurruynydja miriŋuynydja mala märraŋalnydja ŋunhi rrupiyany mala, bala walal yan djämamirriyaŋala ŋunhi nhaltjarr walalaŋ gan buŋgawa'mirriŋu waŋan walalaŋ. Ga baḏak yan dhiyaŋ bala walalnydja ŋuli ga ŋunhi Djuw malany lakaranhamirr yan dhuwalaŋuwuyyiny dhäwu. ");
INSERT INTO djr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yo walalnydja ŋunhi malthunamirrnydja mala nhanŋu Djesuw 11-dja, marrtjinan walal balan Galalilila, ŋunhawalnha ŋunhi bukulila ŋunhi ŋayi Djesu gan waŋan walalaŋ, djuy'yurr ŋäthil marrtjinyaraw ŋunhiwiliyi. ");
INSERT INTO djr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ga ŋunhiliyin walal ŋunhi ŋanya nhäŋalnydja, bala yan walal buku-ŋal'yurra nhanŋu. Yurr wiripuwurruynydja baḏak yan gan märr-yuḻkthurr ŋanya. ");
INSERT INTO djr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Bala ŋayipiny ŋunhi Djesuny marrtjin galkithinan walalaŋgal, ga waŋanany ŋayi bitjarrnha, “Bilin dhuwal God-Waŋarryuny ŋarranhany nhirrparnha ŋurruŋuyaŋalnha ŋurukuny ŋunhi djiwarr'puywuny wäŋaw ga dhiyakuny ŋunhi munatha'wuywuny wäŋaw; bukmak ŋula nhä malany warrpam'nha ŋunhiyiny ŋarrakiyingalnha goŋŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gatjuynha marrtjin walal ga lakaraŋun ŋarrakalaŋuwuynydja dhäwu bukmakkun yan bäpurruwny'tja malaŋuw, märr walalnydja dhu ŋunhi bitjandhi bili gurrupanmirryi ŋarrakal, ga malthundhi walal dhu ŋarrakalaŋawnydja dhärukku ga romgu. Ga bitjandhi bili nhuma dhu ga buku-ḻupmaramany walalany yäkukurrnydja Bäpawalaŋuwurr ga Gäthu'mirriŋuwalaŋuwurr ga Dhuyu-Birrimbirrwalaŋuwurr. ");
INSERT INTO djr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yo. Bitjandhi nhuma dhu ga ŋunhi lakaramany marŋgikumany bukmakku yan bäpurruwny'tja, märr walalnydja dhu djäma bitjandhi bili yan ŋunhi nhaltjarr ŋarra gan lakaraŋal nhumalaŋgal. Guyaŋin walal gi dhuwandja gam'. ‘Ŋarrany dhu ŋunhi nhumalaŋgalnydja bitjan warray bili, ga yan bili ga wäŋa dhu dhuwal dhä-dhawar'yurr.’” Ga bitjarr ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dhuwanna ŋunhi ŋurruŋuny dhäwu ŋarra ga nhumalaŋgal lakaraman ŋunhiyiny, ŋunhi yuwalktja ga manymaktja dhäwu Djesuwalaŋuwuynydja, ŋunhi ŋayiny Maŋutji-dhunupayanhawuy Gäthu'mirriŋu God-Waŋarrwu. ");
INSERT INTO djr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ŋäthilnydja baman'tja dhäwu-gänhamirriy yolŋuy yäkuy Yitjayay wukirri dhuwal dhäruk bitjarr gam', “God-Waŋarrnydja waŋan bitjarr, ‘Dhuwanna ŋarraku dhäwu-gänhamirrnydja yolŋu, ŋarrany djarr'yurr. Djuy'yundja ŋarra ga ŋanya dhuwal ŋäthil, märr ŋayi dhu ŋäthilmirriyaman dhukarrnha djäma nhuŋun.’ ");
INSERT INTO djr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ŋunha gapu-ranhdhakŋurnydja wäŋaŋur ḏiltjiŋurnydja ga yolŋu waŋa djawarrkthunna mirithirra, lakaramany ŋayi ga ŋunha waŋany bitjanna: ‘Ŋamaŋamayunmirra nhunapinya nhe dhunupayanhamirra, ga djäman riwal'yurra dhukarrnydja Garraywuny, bili galki ŋayi dhu bunan, biyakun dhunupayaŋun nhanŋu dhukarrnydja djäma marrtjinyarawnydja.’” ");
INSERT INTO djr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ga dhäruk ŋunhiyiny yuwalkthinan yan maḻŋ'thurr. Ŋunhiyiny ŋunhi ḏirramu Djonnha, ŋunhi ŋayi gan djawarrkthurr dhäwu lakaraŋal ŋunhiliyi gapu-ranhdhakŋur wäŋaŋur, ga bulu ŋayi gan buku-lupmaraŋalnydja muka yolŋunhany mala mayaŋurnydja. Ga lakaraŋalnydja ŋayi gan ŋunhi walalaŋgal bitjarra, “Way bilyurra walal yätjkurruŋurnydja nhumalaŋgiyingal nhuma, bala buku-ḻupthurra, bala ŋayi dhu God-Waŋarryuny nhumalaŋ bäy-lakaraman yätjkurruwuynydja.” ");
INSERT INTO djr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ga dharrwan mirithirra yolŋuny walal gan ŋunhi marrtjin, wäŋaŋur ga wäŋaŋur mala ŋänharawnydja nhanŋu Djonguny, beŋur Djudiyaŋur makarrŋur wäŋaŋur, ga beŋur bala Djurutjalamŋur wäŋaŋur. Ga ŋunhi walal gan ŋäkulnydja dhäruktja ŋanya Djonnhany balanyawuyyiny waŋanhawuy, bala walal marrtjin lakaranhaminany bitjanminan walalawuynhany walal, “Yuwalk muka yan ŋarra dhuwal dhuwurr-yätjkurrnydja yolŋu.” Bala dhunupan yan walal gan ŋunhi bilyurra walalaŋgiyingalaŋaŋur yätjkurruŋurnydja dhuwurrŋur, bala ŋayi Djondhuny gan walalany buku-ḻupmaraŋala ŋunhiliyin mayaŋurnydja yäkuŋur Djodannha. ");
INSERT INTO djr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yo, ŋayiny ŋunhiyiny yolŋu Djondja ŋuli ganha dhaṯthunminya gamuḻwal bulkayny'tja yurr djämapuyyun. Ga guwaḻnydja ŋayi gan ḏapmaranhamin nhakun biralyuny ga warrakan'kalyi yan bulkay'; ga ŋathany ŋayi gan ḻukan ḏiltjipuynha yan balanya nhakun ḏetjthinyan mala, ga gukun. ");
INSERT INTO djr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ga wiripuny ŋayi gan walalaŋ bitjarra dhäwu lakaraŋal gam', “Ŋarrany dhuwal yolŋu märr ŋuli waliwaliŋu, ga dhikayi wiripuny ga yolŋu marrtji ŋapa-ŋupan ŋarranhany ŋunhiyiny yolŋu bulun dhika ganydjarr-ḏumurra djuḻkmaraman ŋayi ga ŋarranhany. Ga ŋarrany dhuwal yolŋu yaka yan gana' ŋurukuny ŋunhi dhapathuŋ'kuny nhanukalaŋuw yupmaranharaw. ");
INSERT INTO djr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ŋarrany ŋuli ga nhumalany buku-ḻupmaram gapuy yan, ga dhuwaliyiny ŋunhi yolŋu ŋunhi ŋayi ga marrtji dhuḏikurrnydja, ŋayiny dhu nhumalany ḻupmaram Dhuyu Birrimbirryun.” ");
INSERT INTO djr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yo ŋayiny gan ŋunhi Djesuny balanyamirriynydja nhinan ŋunhala Nätjuritjnha wäŋaŋur, makarrŋurnydja ŋunhiliyin Galalin, yurr marrtjinany ŋayi beŋuryiny ŋunhi nhanukiyingalaŋuŋurnydja wäŋaŋur, bala ŋanya ŋayi ŋunhi Djondhuny ŋunhiliyin ḻiya-ḻupmaraŋalnydja Djodannha mayaŋŋur. ");
INSERT INTO djr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ga ŋunhi ŋayi Djesu ḏämbu-ḻupthurrnydja, ga dhawaṯthurr ŋayi ŋunhi beŋurnydja gapuŋurnydja, bala dhunupan ŋayi nhäŋala djiwarrny'tja ḻapthunawuynha, ga bulu ŋayi nhäŋal God-Waŋarrwun Garrkuḻuknhan Birrimbirrnha, ŋayi marrtjin räli dhuryurr, ga rumbalnydja ŋayi ŋunhi balanya nhakun warrakan' yäku murryil, dhuryurrnydja ŋayi marrtjin ŋunhi, bala yan ŋayi nhinanan nhanukal Djesuwala. ");
INSERT INTO djr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ga dhunupan ŋayi ŋäkula rirrakaynha waŋanhawuynha balanyawuynha, “Nheny dhuwal ŋarrakuwuynha yan marrkapmirra Gäthu'mirriŋu, ga mirithirra yan ŋarra ga dhuwal nhokal goŋmirriyirrnydja.” ");
INSERT INTO djr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ga dhäŋur beŋuryiny ŋayi ŋuruŋiyi God-Waŋarrwalnydja Dhuyuy Birrimbirryuny gäŋala ŋanya Djesunhany balan ŋunhi gapu-ranhdhaklila wäŋalilnydja ḏiltjilila, ");
INSERT INTO djr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ga nhinanany ŋayi gan ŋunhiliyiny 40-n munhany. Ga balanyamirriyyiny ŋayiny gan ŋunhi Djaytindhuny dharrwunuŋala ŋanyanhany Djesunhany. Yo, nhinanany ŋayi gan ŋunhi Djesuny ŋunhiliyiny wäŋaŋur gänan yan yolŋumiriwŋura, wakinŋumirriwala yan warrakan'kal malaŋuwal. Ga walalnydja ŋunhi djiwarr'puynydja dhäwu-gänhamirrnydja yolŋu walal marrtjinany bala guŋga'yurra ŋanya. ");
INSERT INTO djr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ga dhäŋur beŋuryiny yolŋu walal miriŋu marrtjin bala ŋayathaŋala ŋanyanhany Djonnhany, bala galkara dharruŋgulila. Ga beŋuryiny dhurrwaraŋur ŋayi Djesuny dhunupan marrtjinan balayin Galalilila makarrlil wäŋalil, ga ŋunhiliyin ŋayi gan marrtji'-marrtjinany ḻiw'maraŋalnydja, dhäwun marrtjin manymaknha lakaraŋal beŋura nhanukuŋun God-Waŋarrwuŋun. ");
INSERT INTO djr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ga bitjarra ŋayi gan ŋunhi dhäwuny lakaraŋal yolŋu'-yulŋuwalnydja gam', “Waluny dhuwal bilin bunanan. God-Waŋarrwuny Rom ŋunhi bilin dhuwanna. Bilyurra walal. Ganarrthula nhumalaŋguwuy nhuma ŋunhi yätjkurrnydja rom mala, ga biyakun märr-yuwalkmirriyin dhiyakun bili yan manymakkun dhäwuwny'tja.” ");
INSERT INTO djr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ga waŋganymirrnydja waluy ŋayi marrtjin Djesu waṉḏin bala raŋi-ŋupar ŋuliwitjarryi gali' guḻun'kurr yäkukurr Galaliwurr, bala ŋayi nhäŋala märrma'nhan wäwa'manydjiny ŋarirri'-djämamirrinhan maṉḏany, Djäymannha, ga Wanduruny, maṉḏa gan ŋarirri bumar ganybuy. ");
INSERT INTO djr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Bala ŋayi Djesuny gulyurra, bala ŋayi waŋanan bitjarra, “Way maṉḏa, malthurra maṉḏa ŋarrakun go. Ŋarrany nhumalany dhu dhuwal marŋgikum djämawnha, nhuma dhu ga gaṯmaraman yolŋunhan mala.” ");
INSERT INTO djr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ga dhunupan bala yan maṉḏany ŋunhi ganarrthaŋala ganybuny, bala yan maṉḏa malthurra Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Manymak waṉḏin ŋayi marrtjin bala Djesuny ga-ga-ga-ga-a-a-a, ga bulu ŋayi nhäŋal märrmany'thi yan wäwa'manydjiny, Djayimnha ga Djonnha, maṉḏany ŋunhiyiny maṉḏa gäthu'mirriŋu Djibidiw, ga djäma maṉḏa gan ŋunhi rrambaŋi yan walal bäpa'mirriŋuy maṉḏaŋgal, ganybu maṉḏa marrtjin dhunu'-dhunupayaŋal räkunharawnha ŋunhiliyi marthaŋayŋur walalaŋgiyingal. ");
INSERT INTO djr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ga ŋunhi ŋayi Djesuy nhäŋalnydja maṉḏany, bala ŋayi dhunupan wäthurra maṉḏaŋ. Ga dhunupan maṉḏany ŋunhi ganarrthaŋala bäpa'mirriŋunhany maṉḏaŋguwuy maṉḏa balayin bili yan marthaŋaylila, wiripuwurruŋgala djämamirriwal mala. Bala maṉḏany yan malthurra nhanŋun Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ga beŋuryiny ŋayi ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu marrtjinan, bala bunanan walal wäŋaŋur yäkuŋur Gapuniyamnha. Nhinanan walal gan ŋunhiliyin, ga yan bili-i-i; ga wiripuŋuynha Nhinanhamirriy waluy, bala ŋayi Djesuny marrtjinan ŋunhiwilin Djuw malawalnha buku-ḻuŋ'maranhamirrilila buṉbulil, bala yan ŋayi dhunupan ŋurruyirr'yurra marŋgikuŋala gan walalany. ");
INSERT INTO djr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ga ŋunhi nhakun walal gan ŋanya ŋäkulnydja Djesunhany balanyawuyyiny waŋanhawuy ŋunhi nhaltjarr ŋayi gan walalany marŋgikuŋal, bala walal nhanŋu märr-maŋmaŋdhurrnydja mirithinan yan, ganyim'thurra manapar. Bili nhanukuŋuny ŋunhi Djesuwuŋuny dhäwu marŋgi-wurrupanawuy dhulmu-ganydjarrmirra, gänaŋ'thurra gan beŋurnydja ŋunhi wiripuwurruŋgalnydja rom-marŋgikunhamirriwal walalaŋgal, ŋunhi walal ŋuli ganha marŋgikunha rom beŋur ŋunhi Mawtjitjkuŋ wukirriwuy. ");
INSERT INTO djr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ga dhunupan bala yan ŋunhi ḏirramuny yätjkurr-birrimbirrmirrnydja gärrinan Djuw malawalnha buku-ḻuŋ'maranhamirrilila buṉbulil, yurr dhä-rirrakaymirra ŋayi ŋunhi gulŋiyinany; bala ŋayi marrtjin ŋunhi bitjarra yatjurrnydja gam', ");
INSERT INTO djr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Way, Djesu wäŋa-Nätjuritjpuy! Nhaku nhe dhuwal räliny wapthurr ŋanapurruŋgalnydja? Nhaku ŋanapurruŋ baḏuwaḏuyunaraw? Ŋarrany dhuwal marŋgi yan nhuŋuny. Nheny dhuwal ŋunhiyin, Dharrpalnha Yolŋu, God-Waŋarrwuŋun djuy'yunawuy.” ");
INSERT INTO djr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bala yan ŋayi dhunupan Djesuny dhäruk-gurrupanminan ŋurikiyiny yätjkurruwnydja birrimbirrwu bitjarra, “Way, mukthurra! Ga dhawaṯthurra, dhipuŋuryiny yolŋuwalnydja ganarrthula ŋanya!” ");
INSERT INTO djr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bala ŋayi ŋuriŋiyiny mokuywalnydja birrimbirryu rurr'rurryurra marrtjin ŋunhiyiny ḏirramunhany mirithinan dhika, ga dhawaṯthurrnydja ŋayi nhanukalaŋaŋur dhä-rirrakaymirra. ");
INSERT INTO djr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ga walalnydja gan ŋunhi yolŋuynydja walal ŋunhiliyiny buṉbuŋurnydja nhäŋalnydja ganyim'thurra, märr-maŋmaŋdhurra manapar. Bala walal marrtjin waŋanhaminany dhä-birrka'yunminany bitjanminan, “Nhä ŋayi ga dhuwal limurruny marŋgi-gurrupandja? Wiripuynha ŋayi ga dhuwal limurruny yuṯaynha romdhuny marŋgikumany bay! Dhuwal ŋayi ga wiripuny ganydjarr ŋayatham dhäruk-gurrupanminyaraw nhanŋuwuy ŋayi ŋunha yätjkurruwnha birrimbirrwu dhawaṯmaranharaw, ga dhunupan yan walalnydja ga dhuwal dhäruktja ŋanya märraman.” ");
INSERT INTO djr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bala gan ŋunhi dhäwuny marrtjinan ḻatjuwarr'yurra Djesuwalaŋuwuynydja, ŋunhi nhaltjarr ŋayi gan djäma manymak rom mala ŋunhiliyi wäŋaŋur ŋarakaŋur Galali. ");
INSERT INTO djr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ga ŋunhi walal ganarrthaŋalnydja ŋunhiyiny Djuw-malawnydja buku-ḻuŋ'maranhamirrnydja buṉbu, bala dhunupan walal wäŋgaŋalnydja balan Djäymangala ga Wanduruwala wäŋalilnydja, ga maṉḏa ŋunhi Djayim ga Djon malthurryi walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ga ŋunhiliyi gan wäŋaŋur ŋorran waŋgany miyalk rerrimirr, Djäymangu mukul'mirriŋu rumaru', ga rirrikthurrnydja ŋayi gan ŋunhi gorrmur'yu. Ga ŋunhi ŋayi Djesu gulŋiyinany balayi wäŋalilnydja, bala walalnydja lakaraŋala nhanukal ŋunhiyin miyalknhan rerrimirrinhan. ");
INSERT INTO djr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ga ŋayiny ŋunhi Djesuny marrtjin, ga baṯnha ŋayathaŋal ŋanya goŋnha, bala rur'maraŋala, ga dhunupan yan ŋuruŋiyi rerriynydja ŋanya ganarrthaŋala, bala yan ŋayiny ŋunhi miyalktja galŋarrarrayurra ŋathawnha walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ga ŋunhi ŋayi marrtjin munhawuyinany, bala walalnydja marrtjin ŋunhi bukmaknhan yan rerrimirrinhany mala ga wakinŋumirrinhany birrimbirrmirriny yolŋuny walalany gäŋa'-gaŋal balayin nhanukala Djesuwala. ");
INSERT INTO djr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ga dharrwan mirithirra dhika ŋunhiŋuwuynydja wäŋawuy yolŋu'-yulŋu marrtjin ḻuŋ'thurra balayiny bala'lil. ");
INSERT INTO djr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Bala ŋayi gan Djesuynydja ḏukmaraŋala ŋunhi yolŋu'-yulŋunhany mala dharrwanhan yanan, yurr wiripu wiripuŋura ŋunhi rerriŋurnydja ŋayi walalany gan walŋakuŋalnydja. Ga bitjarryi bili ŋayi gan dharrwayi yan dhawaṯmaraŋal wakinŋunhany birrimbirrnha mala yolŋu'-yulŋuwalnydja, yurr ŋayi gan walalany ŋunhi dhä-mukmaraŋala ŋunhiyiny birrimbirrnhany mala, bäyŋu ŋayi walalany dhayuŋana ŋula waŋanharaw, bili walalnydja nhanŋu ŋunhi marŋgithindhi yol ŋayi ŋunhi Garray. ");
INSERT INTO djr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ga be yan djeḏa ŋayi rur'yurrnydja, bala ganarrthaŋala ŋunhiyiny wäŋa, bala ŋayi marrtjinan yolŋumiriwlila wäŋalil, ga ŋunhiliyin ŋayi gan bukumirriyaŋalnydja Bäpawalnydja. ");
INSERT INTO djr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Manymak ŋayiny Djäymandja ga wiripuwurrnydja nhanŋu ḻundu'mirriŋu mala bira'yurrnydja bala ḻarruŋala nhanŋu Djesuwnydja. ");
INSERT INTO djr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ḻarru'-ḻarruŋal wala-a-al, yan bili ga maḻŋ'maraŋal walal ŋanya, bala walal lakaraŋalnydja nhanukal bitjarra, “Way Garray, dhuwal nhuŋu ga yolŋuny walal ḻarruman.” ");
INSERT INTO djr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ga ŋayiny walalaŋ waŋan bitjarr, “Be muka limurr dhu ga dhuwal bitjan marrtjiny, wiripulil, wiripulil wäŋalilnydja malaŋulil. Ŋarrany muka dhuwal dhu ga be lakaram dhäwu wäŋakurr malaŋuwurr, bili dhiyakiyi muka ŋarra ŋunhi räliny marrtjin dhipalnydja.” ");
INSERT INTO djr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bala ŋayi gan yan Djesuny marrtjinan, buku-ḻiw'maraŋala Galalikurra wäŋakurr, ga bukmakŋur yan wäŋaŋurnydja malaŋuŋur ŋayi gan ŋunhi lakaraŋalnydja yolŋu'-yulŋuwalnydja ŋunhi wanhal gan Djuw-malaw buku-ḻuŋ'maranhamirr buṉbu mala dhärra'-dharran. Ga bitjarryi bili ŋayi gan dhawaṯmaraŋal wakinŋunhany birrimbirrnha mala yolŋuwalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ga waŋgany ḏirramu burrunhdhiya'mirr marrtjin ga bunan ŋayi Djesuw, bala ŋayi bun'kumu-djipthurra nhanukal, ga bitjarra ŋayi nhanukal ŋunhi waŋanany, “Garray buku-djulŋi guŋga'yurr ŋarrany. Ŋuli nhe djälnydja, nhe dhu ŋarrany ḏarrtjalkkuman yan.” ");
INSERT INTO djr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Bala ŋayi Djesuny wuyurra nhanŋu, bala ŋayi goŋ-djarryurrnydja bala yan goŋ-ŋal'yurra nhanukal, ga bitjarra ŋayi Garray waŋanany nhanŋu, “Ŋarrany dhuwal djäl ŋarra dhu ḏukmaraman nhuna. Ma', ḏarrtjalkthin.” ");
INSERT INTO djr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bala dhunupan yan ŋayi ŋunhi ḏirramuny walŋathinan, ḏukthurra, bilin ŋanya rerriynydja ŋuruŋiyiny ganarrthaŋala, winya'yurra nhanukalaŋaŋur, bala yan ŋayi ŋunhi ḏarrtjalkthinan. ");
INSERT INTO djr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ga buluyi nhanŋu ŋayi Djesu waŋan ḏälyu dhärukthu, bala djuy'yurra ŋanya bitjarra, ");
INSERT INTO djr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Way, yaka lakaraŋ wiripuwurruŋgalnydja! Dhunupan nhe dhu dhuwal marrtjiny balan ŋunhi djirrikaymirriwala yolŋuwalnydja. Ga ŋunhi ŋayi nhuna dhu manymak-lakaramany, nheny dhu mundhurrnha gurrupan buku-gurrpanna God-Waŋarrnhan, bitjan yan bili nhakun ŋunhi Mawtjitjkal ga romŋur dhäruk-gurrupanminyawuy barraŋga'yun, märr dhu bukmaknha yolŋuny walal marŋgithirr nhuŋu, ŋunhi nheny dhuwali bilin ḏarrtjalknha.” ");
INSERT INTO djr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yurr ŋayiny ŋunhi ḏirramuny marrtjinany, bala ŋayi marrtjin dhäwuny birrŋ'maraŋala lakaraŋalnydja. Bala ŋayiny Djesuny yakan buluny marrtjinya balayiny ŋunhi yolŋu dharrwamirrililnydja wäŋalil, ŋunhilin bili yan ŋayi gan wäŋaŋurnydja nhinan ḏiltjiŋura yan, ga walalnydja gan ŋunhi yolŋuynydja mala wäŋaŋurnydja mala balayin ŋanya guwatjmar. ");
INSERT INTO djr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ga balayi ŋayi Djesuny roŋiyindhi Gapuniyamlil, ga ŋula nhämunha' munha, bala marrtjin yolŋuny walal lakaranhaminan Djesuwalaŋuwuynydja ŋunhi ŋayiny bilin ŋunhiliyin wäŋaŋura gan nhinan. ");
INSERT INTO djr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bala marrtjin ŋunhi dharrwan yolŋuny mala ḻuŋ'thurrnydja ŋunhiwiliny wäŋalil, ga wäŋany ŋunhi warrpam'nha gungaŋala, ga dhurrwara ŋunhi bala'puy gungaŋalyi yolŋu'-yulŋuy yan malay. Ga ŋayiny gan Djesuynydja marŋgikuŋala dhäwun lakaraŋal ŋurikiwurruŋgun yolŋuwnha walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","4","Ga balanyamirriyyi bili ḏämbumiriw ḏirramuwurr bunan ŋunhiliyi, ga gäŋalnydja walal marrtjin ŋunhi djaṉdjaṉdhurrnydja gaṉuŋnha ḏirramuny. Ga djälthinany walal gan ŋunhi, walal balaŋ ŋunhi marrtjinya dhunupa bala yan Djesuwal, yan walalaŋ dhaḻakarrnha dhawar'yurr gärrinyarawnydja. Yo, ga balany' gan ŋunhi dhärran bilkpilk yan ḻaparra balanya, bala walal ŋarŋgan djäma ŋunhalnydja garrwarnydja dhunupa yan ŋunhiwili bili ŋunhi wanhal gan ŋayi Djesu dhärran. Bala walal ŋuliwitjarra bili yan ŋarŋgakurra yaluyalkmaraŋalnydja marrtjin ŋunhi gaṉuŋnhany yolŋuny balan ŋoylila gayanh'thamirriny yan. ");
INSERT INTO djr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ga ŋayiny Djesuynydja nhäŋal walalany ŋunhiwurrunhany ŋunhi walal gan mirithin yan märr-yuwalkthin, bala ŋayi waŋanan ŋurikalyiny gaṉuŋgalnydja bitjarra gam', “Way, marrkapmirr ḻundu ŋarraku, Nhuŋu yätjkurrnydja dhuwurr dhuwal bilin bäy-lakaranhawuynha.” ");
INSERT INTO djr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ga walalnydja marrtjin ŋunhiliyi nhina'-nhinan ŋaḻapaḻmirr mala Rom-marŋgikunhamirr mala, bala walal gan rom-nyamir'yurra Djesunhany, gayulnha gan guyaŋan bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Way. Yaka balaŋ ŋayi bitjana waŋanha. Nhaltjan ŋayi ga ŋunha guyaŋanhamirnydja yanbi ŋayi ŋunha God-Waŋarrnha? God-Waŋarryun ŋuli ga dhuwal ŋayipin waŋganydhun bäy-lakaramany yätjkurruwuynydja mala.” ");
INSERT INTO djr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yurr ŋayiny Djesuny walalaŋ marŋgithin ŋunhi walal gan rom-nyamir'yurr ŋanya, bala ŋayi waŋanan walalaŋ ŋurikiwurruŋguny ŋaḻapaḻmirriwnydja bitjarra, “Nhaku nhuma ga dhuwal rom-nyamir'yundja ŋarrany? ");
INSERT INTO djr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Nhaltjan dhika ŋarra dhu waŋany nhanŋu dhiyakuny gay'yi gaṉuŋguny yolŋuw, ‘Ma, bilin nhuŋu dhuwal dhuwurr-yätjtja rom bäy-lakaranhawuynha’, bitjan, wo ŋarra dhu bitjan gam' waŋa, ‘Ma, rur'yurra bala märraŋun nhuŋuwuy nhe gayanh'thany bala marrtjin’, bitjan ŋarra dhu waŋany? Nhä dhika ŋayi gumurr-yalŋginy dhäruk ŋarrakuny waŋanharaw? Dhuwal ŋarra dhu mel-wurrupanna nhumalaŋgal ŋunhi ŋarrany ga dhuwal ganydjarr ŋayatham ŋarra dhu bäy-lakaram bawalamirriw yan yolŋuw dhiyal munatha'ŋur.” Bala ŋayi bilyurrnydja, ga waŋan ŋurikalyiny ŋunhi gaṉuŋguny yolŋuw bitjarra, ");
INSERT INTO djr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ma', rur'yurra, ga märraŋun nhuŋuwuy nhe gayanh'thany, bala marrtjin wäŋalila.” ");
INSERT INTO djr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ga ŋunhili bili yan gumurrŋur walalaŋgal, ŋayi ŋunhi yolŋuny dhunupan yan rur'yurrnydja, ga gayanh'thany nhanŋuwuy ŋayi märraŋal, bala yan marrtjinan wäŋalila. Bala walalnydja ŋunhi yolŋu'-yulŋuny mirithinan yan ganyim'thurrnydja, bala yan walal wokthurra God-Waŋarrwuny, ga bitjarra walal gan ŋunhi waŋanany, “Bäyŋu muka limurr gan dhuwal ŋula ŋäthilnydja balanyawuy nhäŋal.” ");
INSERT INTO djr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Bala ŋayi beŋuryiny Djesu roŋiyin balayi gali' raŋilil wäŋalil, ga dharrwan ŋunhi mirithirra nhanukal yolŋu'-yulŋuny mala ḻuŋ'thurr, bala ŋayi walalany gan marŋgikuŋala. ");
INSERT INTO djr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ga ŋunhi ŋayi gan Djesu marrtjinany, bala ŋayi nhäŋala waŋganynhan yolŋuny Lebaynha gäthu'mirriŋu Yalpayatjku, nhinan ŋayi gan ŋunhiliyi rrupiya märranhamirriŋur wäŋaŋur. Bala ŋayi Djesuny waŋanan nhanŋu bitjarra, “Go malthurra ŋarrakun.” Bala ŋayi ŋunhi yolŋuny yan rur'yurra, bala yan malthurra Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yo. Yaka wiyin, bala ŋayi ŋunhi Djesuynydja gan ŋathan ḻukan maṉḏan rrambaŋin ŋuriŋiyin Lebayyun yolŋuy wäŋaŋura nhanukal. Ga walalnydja ŋunhi dharrwan mirithirra rrupiya-märranhamirrnydja yolŋu walal ŋunhi gapmanguny djämamirr mala, ga rom-bakmaranhamirrnydja yolŋu'-yulŋu gan nhina'-nhinan ŋunhiliyin rrambaŋin walalnha Djesun ga malthunamirra mala nhanŋu. Bili dharrwan mirithirra gan ŋunhi yolŋuny walal malthurr nhanŋuny Djesuwnydja. ");
INSERT INTO djr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ga walalnydja ŋunhi Rom-marŋgikunhamirriynydja mala ga Baratjiynydja mala nhäŋal ŋanya Djesunhany ŋayi gan ŋathan ḻukan ŋunhiliyin dhuwurr-yätjmirriwala yolŋuwal walalaŋgal, ga rrupiya-märranhamirriwala walalaŋgal. Bala walal waŋanan dhä-birrka'yurra ŋunhi malthunamirrinhan mala nhanŋu bitjarra, “Wäy, nhaku ŋayi ga ŋunha dhuwurr-yätjmirriwalnydja ga rrupiya-märranhamirriwalnydja yolŋuwal walalaŋgal ŋatha ḻuka?” ");
INSERT INTO djr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ga ŋayiny Djesuynydja ŋäkul walalany, bala ŋayi walalaŋ waŋanan buku-bakmaraŋalnydja bitjarra gam', “Ŋuli nhuma ŋula yol mala yolŋu'-yulŋu ḏäwalamirrnydja rerrimiriwnydja, nhumany dhu yakan marrtji ḏukmaranharaw marrŋgitjkalnydja, ŋany ŋunhiyin bili dhu ŋunhi rerrimirra yan mala yolŋu walal marrtjiny nhanukal. Ŋarrany dhuwal yaka marrtjinya ŋurikiyiny yolŋuw ŋunhi ŋayi ga nhina dhuwurr-dhunupany; ŋarrany dhuwal räliny marrtjin dhuwurr-yätjmirriw yolŋuw walalaŋ.” ");
INSERT INTO djr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ga balanyamirriynydja waluy Djongu ŋunhi ḻiya-ḻupmaranhamirriw malthunamirr mala, ga Baratjiw mala ḻundu'mirriŋu walal gan bukumirriyaŋal ŋoy-ŋathamiriw. Ga walal wiripuwurrnydja yolŋu mala marrtjin bala Djesuwal, ga waŋan walal dhä-birrka'yurr ŋanya bitjarr gam', “Way, ŋunha ga Djonguny malthunamirr mala, ga ŋunha Baratjiwnydja malthunamirr walal ŋuli ga bukumirriyam ŋoy-ŋathamiriwnha. Yurr nhokalnydja malthunamirriy walal ŋuli ga dhuwal ḻuka yan ŋatha.” ");
INSERT INTO djr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Bala ŋayi Djesuny walalaŋ buku-bakmaraŋal balany bitjarra gam', “Ŋunhi ŋuli yolŋu walal marrtji waŋgany-manapanmirr ḻuŋ'maranhamirr gumurr-ŋamathirr ŋurikiyi yolŋuw ḏirramuw ŋunhi ŋayi ŋuli märraman miyalknhan nhanŋuwuy ŋayi, ga nhaltjanna walalnydja dhu ŋunhi? … yänan walal ŋuli ga ŋunhi nhinany ŋoy-ŋathamiriwnha? Bäyŋu, yan walal dhu marrtji ŋunhi ḻukan bitjanna goŋmirriyirra ŋurikalyin ḏirramuwala, ga yan bili-i-i, ga ganarrtham ŋayi dhu walalany ŋuriŋiyi ḏirramuy. ");
INSERT INTO djr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yurr yalalaŋumirrnydja ŋanyanhany dhu ŋunhi ḏirramunhany djaw'yunna nhanukal ḻundu'mirriŋuwalnydja mala, ga beŋuryin dhurrwaraŋur walal dhu ga ŋunhi ŋoy-ŋathamiriwnydja nhina.” ");
INSERT INTO djr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Bäyŋun ŋayi dhu ŋunhi ŋula yolthu yolŋuy djawar'yun ŋäthiliŋuny girri' balany yuṯalilnydja manapan, ŋunhi ŋayi dhu bitjandhiny djäma, ŋayiny dhu ŋunhi yuṯany manydjarrka' dhurŋ'thuna, ga ŋäthiliŋuny dhu ŋunhi yarrar'yuna.” ");
INSERT INTO djr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Ga bäyŋun dhu ŋunhi ŋula yolthu yolŋuy yuṯany wiyika' borum märram ga rarryun ŋayi dhu ŋunha ŋäthiliŋulilnydja bathilil, balanya nhakun ŋäthiliŋulilnydja ḏimbukalil, bili ŋayi dhu ŋunhi ŋäthiliŋuny bathi baw'yunna yarrar'yunna ŋuriŋiyiny yuṯaynydja wiyikay', bala dhu ŋunhi wiyikany' ḻurryundja marrtji dhawar'nha dhu, ga bathiny dhu ŋunhi miḏikirra buruŋgulkthirra. Yo, ga ŋunhi ŋayi dhu yolŋuy märram yuṯany yan borum wiyika', ga rarryun ŋayi dhu ŋunhi yuṯalilnydja yan bathilil, bala dhu ga ŋunhi wiyikany' borumdja ŋorran yan, bulyunna dhu ga, bäyŋun dhu baṉḏanydhirr. Ga balanyayi bili dhuwal yuṯany rom. Ŋunhi nhe dhu märram ŋarraku walŋamirr yuṯa rom, nheny dhu ga ŋunhi yuṯaŋura yan romŋurnydja nhina, yakan ŋäthiliŋulilnydja roŋiyi, märr dhu ŋunhi yuṯany walŋa yakan nhokal winya'yun.” Ga bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ga balanyamirriynydja ŋunhi Nhinanhamirriynydja waluy walalnydja ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu marrtji wäŋgaman dhukarr-ŋupanna, yurr dhukarrkurrnydja gali'wurrnydja marrtjin ŋunhi dhärra'-dharran ŋathan birralin. Bala walalnydja ŋunhi Djesuwalnydja malthunamirriy mala marrtjin gulk-gulkthurra ŋunhi ŋathan mala muḻkurrnha birralin. ");
INSERT INTO djr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ga walalnydja ŋunhi Baratjiynydja mala waŋanan Djesunhany bitjarra gam', “Way, ŋathil walalany nhäŋu dhuwaliyi malthunamirriny mala nhuŋuwuy nhe. Ŋunha walal ga romnha bakmaram. Dhuwaliyiny yakan yanbi dhunupa walalaŋ balanyarawyiny djämaw dhiyaŋuny ŋunhi Nhinanhamirriynydja waluy.” ");
INSERT INTO djr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Bala ŋayiny Djesuny buku-bakmaram waŋa walalaŋguny bitjanna, “Way walal, yaka yan nhuma dhuwal marŋginy muka dhäwuwny'tja? … ŋunhi nhaltjarr walal Daybit ga malthunamirr mala nhanŋu bitjarryi djaṉŋarrthin? ");
INSERT INTO djr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ŋayiny ŋunhi Daybittja dhunupan marrtjinan, bala gulŋiyinan ŋunhi God-Waŋarrwalnydja dhuyulil buṉbulil, bala ŋayi märraŋala ŋunhi dhuyuny ŋatha dämbany ŋunhi walal ŋuli rulwaŋdhunna gänaŋ'maranha mundhurr-wurrupanaraw nhanŋu God-Waŋarrwu. Ga romdhuny ga ŋunhi lakaram ŋurikiyi dhuyuwnydja ŋathaw djirrikaymirriwnha yan walalaŋ ḻukanharawnydja, yakan nhakun manymak bukmakkuny yolŋuw walalaŋ. Yurr ŋayiny Daybitthuny ḻukan yan ŋunhiyi dhuyu ŋatha, ga wiripuny ŋayi gurrupar ŋunha ḻundu'mirriŋuwnha mala nhanukalaŋaw. Yo, bitjarryiny ŋunhi maḻŋ'thurr balanyamirriy ŋunhi ŋayi gan yolŋu yäku Yabiyatha yan nhinan ŋurruḏawalaŋu djirrikaymirrnydja.” ");
INSERT INTO djr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bala ŋayi dhawar'maraŋalnydja waŋan Djesu bitjarra gam', “God-Waŋarryuny ŋunhi djäma rom yäku Nhinanhamirrnydja Walu yolŋu'-yulŋuw mala; yaka ŋayi ŋunhi djäma yolŋu'-yulŋunhany ŋurikiyiny romgu yäkuw Nhinanhamirriwnydja Waluw. ");
INSERT INTO djr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bili Yolŋuny Gäthu'mirriŋu dhuwal rom-waṯaŋuyi yan dhiyakiyiny ŋunhi romgu Nhinanhamirriwnydja Waluw.” ");
INSERT INTO djr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ga ŋunhi ŋayi Djesu buluny marrtjin balayi Djuw malawalnydja buku-ḻuŋ'maranhamirrilil buṉbulil, ga ŋunhiliyiny gan yolŋun nhinan goŋ-dhoṯnha. ");
INSERT INTO djr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ga walal gan ŋunhiliyi yolŋu walal nhinan Baratji mala, ga nhäŋal walal gan Djesuny, wanha balaŋ ŋayi dhu ḏukmaram ŋunhiyi ŋarambiya'-dhoṯnha ḏirramuny ŋuriŋiyi Nhinanhamirriy waluy, märr ŋanya walal dhu rom-nyamir'yunna. ");
INSERT INTO djr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yo, bala ŋayi ŋunhi Djesuny wäthurra ŋurikiyiny goŋ'-dhoṯkuny bitjarra, “Go marrtji räli ŋarrakal dhipal,” bitjarr. Bala ŋayi ŋunhi ḏirramuny rur'yurra, bala ŋayi marrtjinany ga dhutnha nhinan Djesuwala. ");
INSERT INTO djr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bala ŋayi Djesuynydja walalany waŋanan ŋunhi wiripuwurrunhany yolŋuny walalany dhä-birrka'yurra bitjarra, “Nhäthinya limurruŋ ŋunhi romdja ga barraŋga'yun dhiyakuny ŋunhi Nhinanhamirriwnydja waluw? Nhaltjan limurr dhu guŋga'yun muka yolŋunhany walalany? … ŋany nhaltjan? … ŋayaŋu-yätjkurrkuman walalany muka? … Walŋakum limurr dhu walalany? … ŋany nhaltjan? … buman walalany?” bitjarr. Ga walalnydja gan ŋunhi mukthurra yan nhinan. ");
INSERT INTO djr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bala ŋayi marrtjin ŋunhi Djesuynydja nhäŋala walalany, ŋoy-dhärranan manapar, ga buluyi ŋayi walalaŋ ŋayaŋu-warwumirriyin, bili walal ŋunhi ŋayaŋu-ḏälmirra balanyan. Bala ŋayi Djesuynydja waŋanan ŋunhi goŋ-dhoṯnhany yolŋuny bitjarr, “Ma', goŋdja djarryurra,” bitjarr. Bala dhunupan yan ŋayi ŋunhi yätjkurruŋuny goŋ djarryurra, bala yan manymakthinan. ");
INSERT INTO djr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bala walalnydja ŋunhi Baratjiny yolŋu mala marrtjinan yanan. Ga dhunupan yan bala walal ḻuŋ'maranhaminan, ŋunhiwurryiny yolŋu walal, ga wiripuny djuŋga'-djuŋgaya mala Yaritku. Bala walal gan nhanŋu waŋanhaminan Djesuwnydja bunharawnha murrkay'kunharawnha. ");
INSERT INTO djr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ga dhäŋur beŋuryiny walalnydja ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu marrtjinan roŋiyinan Galalilila guḻun'lil, ga dharrwan mirithirra ŋunhi yolŋuny mala gan malthurr nhanŋuny Djesuwnydja. Marrtjinany walal gan ŋunhi yolŋu'-yulŋuny beŋur makarrŋurnydja Galaliŋur ga Djudiyaŋur, ");
INSERT INTO djr_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ga wiripuny Djurutjalamŋur makarrŋur wäŋaŋur, ga Yidumiyaŋur, ga wiripuŋura mala gali'ŋur wäŋaŋur ŋunhaŋuwuynha bala djuḻkmaraŋala Djodandja. Ga wiripuny yolŋu'-yulŋu marrtjin Däyaŋura ga Djäydanŋura, ga wiripuŋuŋura mala yumurrku'ŋura wäŋaŋur ŋunhi gan ḻiw'maraŋal ŋunhiyi wäŋany, marrtjinany walal gan ŋunhi nhanukal, bili walal ŋäkul ŋunhi nhaltjarr ŋayi gan Djesuy djäma. ");
INSERT INTO djr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yo, walalnydja marrtjin ŋunhi yolŋu'-yulŋuny ḻuŋ'thurrnydja balayin raŋilila, ga wäŋany walal ŋunhi gungaŋal, bala marrtjin ŋunhi yolŋuny walal giṯthurra, galki walal balaŋ ŋunhi dhä-monygunhan Djesunhany, ga bäyŋuthinan nhanŋuny ŋunhi Djesuwnydja dhaḻakarr nhinanharawnydja. Bala ŋayi waŋanan nhanŋuwuy ŋayi malthunamirrinhany mala bitjarra, “Way, marthaŋay walal ŋarrakal märraŋ, märr ŋarrany dhu ga ŋunhiliyin nhina dhäwuny lakaram marthaŋayŋura,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ga dharrwany ŋayi gan ŋunhi yolŋunhany mala ḏukmaraŋal, ga bulu walalnydja marrtjin wiripuwurrnydja muka rerrimirr yolŋu walal giṯthurr ḏur'-ḏuryunminan marrtjin, bitjarryi bili walalnydja gan ŋunhi djälthin ŋayathanharaw nhanŋu Djesuw rumbalwu. ");
INSERT INTO djr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ga ŋunhi walal gan yätjkurruynydja birrimbirryu mala nhäŋalnydja ŋanya, ga dhunupan walal marrtjin ŋunhi galkirrinany gumurrlila nhanukal, bala marrtjin waŋanan yatjurra bitjarra, “Nheny dhuwal Gäthu'mirriŋu God-Waŋarrwu.” ");
INSERT INTO djr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ga dhunupan ŋayi gan Djesuny waŋan ḏälyun dhärukthuny ŋurikiyiny birrimbirrwuny mala, “Mukthurra. Yakan nhuma dhu ŋarrany lakaramany yolŋuwalnydja walalaŋgal ŋunhi yol ŋarra dhuwal,” bitjarra. ");
INSERT INTO djr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ga dhäŋur beŋuryiny ŋayi Djesu marrtjin bukulila, ga wäthurr ŋayi ḻurrkun'ku yan malthunamirriw walalaŋ, bala walal marrtjinan nhanukal galkin walal gan nhanŋu malthurr. ");
INSERT INTO djr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ga ŋunhiliyiny ŋayi djarr'yurrnydja 12-nhan yan, märr walal dhu ga djäma galkin yanan nhanukala, ga marrtji walal dhu ga wiripulila wäŋalil mala dhäwun gäma. ");
INSERT INTO djr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ga gurrupar ŋayi walalany gan ganydjarr märr walal dhu ga wakinŋumirriny birrimbirrnha mala dhawaṯmaram yolŋuwal walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ga dhuwalawurruny ŋayi ŋunhi djarr'yurrnydja gam', Djäymannha, ŋunhi ŋayi ŋanya yäku nhirrpar Beta, ");
INSERT INTO djr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ga Djayim, ga yukuyuku'mirriŋu nhanŋu Djon, Djipitiw maṉḏany gäthu'mirriŋu, ga ŋayiny maṉḏany ŋunhi Djesuynydja yäku nhirrpar Bawunatj, mayali' “Murryu'murryunamirr maṉḏa.” ");
INSERT INTO djr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ga bitjarryi bili ŋayi djarr'yurr Wanduruny, ga Bilipnha, ga Bäthalamiyawnha, ga Mathuyuny, Dumitjnha, ga Djayimnha Yalpayatjku gäthu'mirriŋuny, ga Dhadayatj, ga wiripuny Djäymannha ŋunhi walal gan lakaraŋal ŋanya rom-ḏälmirr ḏirramu, ");
INSERT INTO djr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ga Djudatj-Gariyatnhan, ŋunhiyin yolŋu ŋunhi ŋayi Djesuny goŋ-gurrupar miriŋuwala. Ga dhuwalawurrunhan ŋayi ŋunhi djarr'yurrnydja nhanŋuwuynydja ŋayi malthunamirriny mala. Dhäŋur beŋuryiny, bala ŋayi marrtjinan wäŋalila. ");
INSERT INTO djr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ga bulu ŋunhiwiliyiny muka yolŋu walal marrtjin ḻuŋ'thurr dharrwan mirithirra nhanukal Djesuwal, ga bäyŋun yan nhakun walalaŋ ŋunhi waluny ŋathawnydja ḻukanharaw, Djesuwnydja ga ḻundu'mirriŋuwnydja nhanukalaŋaw. ");
INSERT INTO djr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ga walalnydja ŋunhi Djesuwalnydja gurruṯumirriy mala ŋäkul, bala walal marrtjinan märranharawnha nhanŋu, bili walal gan lakaraŋal yanbi ŋayi gan bawa'yurra. ");
INSERT INTO djr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ga walalnydja ŋunhi Rom-marŋgikunhamirriynydja yolŋu'-yulŋuy Djurutjalambuyyuny lakaraŋal gan Djesunhany be yanbi nhanukal gan wiripun birrimbirr gärrin. Ga bitjarra walal gan ŋunhi lakaranhaminany, “Ŋunhany ŋayi ga ganydjarrnydja ŋayatham nhanukuŋun Beltjibulwuŋun, ŋunhi ŋayi buŋgawan ŋurikiyin ŋunhi wakinŋuwnha birrimbirrwu malaŋuw, ga ŋuriŋiyin ŋayi ga ŋunhi ganydjarryuny dhawaṯmaram ŋunhi birrimbirrnhany mala.” ");
INSERT INTO djr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bala ŋayi Djesuny wäthurra ḻuŋ'maraŋala ŋunhi yolŋunhany walalany, bala ŋayi yan dhäwun walalaŋ lakaraŋal mayali'kurra bitjarra gam', “Nhaltjanna dhu ŋunhi Djaytindhuny dhawaṯmaram Djaytinnhany? ");
INSERT INTO djr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ga ŋuli dhu ga ŋunhi yolŋu'-yulŋu waŋganybuynydja wäŋapuy bunhamirr, walalnydja dhu ŋunhi malany dhawar'yunna. ");
INSERT INTO djr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ga ŋuli dhu ga yolŋu walal ŋunhi walal gurruṯumirr mala walalaŋguwuy bunhamirrnydja, walalnydja dhu ŋunhi malany dhawar'yunna. ");
INSERT INTO djr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ga ŋuli dhu ga ŋunhi Djaytindja mala yan bunhamirr, nhanŋuny dhu ŋunhi rom dhawar'yunna yan buwayakthirra dhu.” ");
INSERT INTO djr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Yakan dhu ŋunhi ŋula yol yolŋu marrtji ḏälwalnydja ḏirramuwal wäŋalil, bala dhu yan marrtji djaw'-djaw'yunna ŋunhi ŋula nhäny mala wäŋaŋurnydja nhanukal. Ŋurruŋuny ŋathil ŋayi dhu ŋunhi marrtji ga garrwi'yun ŋanya ḏälkum yan ŋunhiyiny ḏälnhany ḏirramuny, ga yorrnha ŋayi dhu marrtjiny wäŋalilnydja nhanukal manaŋinyarawnydja.” ");
INSERT INTO djr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Yo, yuwalk yan ŋarra nhumalaŋ dhu dhuwandja lakaram. Ŋuli dhu ŋunhi ŋula yolthu yolŋuy djäma ŋula nhäny yätjkurrnydja mala, ga waŋa ŋayi dhu ga dhä-wiripuŋuyirr God-Waŋarrwuny, ga ŋayiny dhu ŋunhi God-Waŋarryuny nhanŋu bäy-lakaram ŋunhiŋuwuyyi. ");
INSERT INTO djr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yurr bäyŋuny ŋayi dhu bäy-lakaram ŋurikin yolŋuw ŋunhi ŋayi dhu ga dhä-wiripuŋuyirr waŋa nhanŋun Dhuyu-Birrimbirrwun, ga ŋunhiny ŋayi dhu muŋbunuman yan dhä-gir'yunawuynydja märram, bili nhakun ŋayi ŋunhi rom-bakmaranhamirra balanyan yolŋu.” ");
INSERT INTO djr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yo, ŋunhiny ŋayi gan Djesuynydja lakaraŋal bitjarryiny, bili walal gan lakaraŋal yanbi nhanukal gan yätjkurra birrimbirr gärrin. ");
INSERT INTO djr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Manymak, bala walalnydja bunanan ŋunhiliyi ŋäṉḏi'mirriŋuny nhanŋu ga yukuyuku'mirriŋuny mala, bala walal gan dhärra'-dharranany ŋunhilin warraŋulnha buṉbuŋura, ga dhäruk-djuy'yunmin walal nhanŋu Djesuw ŋayi dhu marrtji walalaŋgal balayi dhawaṯthun. ");
INSERT INTO djr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yurr dharrwan mirithirra gan ŋunhi yolŋuny walal nhinan ḻiw'maraŋala ŋanyanhany Djesunhany, bala walal waŋanan ŋanya Djesunhany bitjarra, “Ŋunhan nhuŋu ŋäṉḏi'mirriŋuny ga yukuyuku'mirriŋuny mala dhärra'-dharra marrtji ya ŋunha warraŋul, djälthirr walal ga nhuŋu nhe dhu bala dhawaṯthun walalaŋgal.” ");
INSERT INTO djr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ga ŋayiny Djesuny waŋan bitjarra, “Yol dhika ŋarraku ŋäṉḏi'mirriŋuny ga yukuyuku'mirriŋu mala?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bala ŋayi marrtjin nhäŋala mala-djarr'yurra yolŋunhan walalany, ŋunhi walal gan nhina'-nhinan galki nhanukal, buthuru-bitjurr walal gan nhanŋu, bala ŋayi waŋan bitjarra, “Dhuwalawurr dhuwal ŋarrakuny ŋäṉḏi'mirriŋu ga yukuyuku'mirriŋu mala. ");
INSERT INTO djr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ŋuli dhu ga ŋunhi ŋula yolthu yolŋuy djäma Godkalaŋuwurrnydja yan ŋayaŋuwurr, ŋunhiyin ŋayi yolŋu ŋarrakuwuynydja yan ŋäṉḏi'mirriŋu ga yukuyuku'mirriŋu, ŋunhin bili yan ŋunhi dhäruk-märranhamirra yolŋu,” ga bitjarra ŋayi Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ga bulu nhakun ŋayi Djesuy ŋurruyirr'yurr dhäwu lakaraŋal, yolŋuwal walalaŋgal ŋunhili galki yindiŋur guḻunŋur yäkuŋur Galali, yurr raŋiŋura. Ga yolŋuny walal ŋunhi ḻuŋ'thurrnydja dharrwan mirithirra nhanukal balayiny. Bala ŋayiny Djesuny ŋal'yurra marthaŋaylila. Bala ŋayi gan nhinanan marthaŋayŋura, yurr märr barrku gumurrŋurnydja wäŋaŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ga marŋgikuŋalnydja ŋayi walalany gan ŋunhi wiripu ga wiripun romdja malany, yurr dhäwuny mala ŋunhi dhulmu-mayali'mirra, bitjarra ŋayi gan ŋunhi lakaraŋalnydja walalaŋ gam', ");
INSERT INTO djr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yo. Ŋäkuny walal ŋamathaŋun yan: Waŋganydhuny waluy yolŋu marrtjin gätni-djämamirr lämu-nhirrpanaraw maŋutjiw ŋathaw birraliw. ");
INSERT INTO djr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ga ŋunhi ŋayi marrtjin djalkthurrnydja ŋathany mala maŋutjiny, wiripuny maŋutji ŋatha malany galkirrin ḏällila munatha'lil dhukarrlila, ga ŋunhi warrakan'tja mala marrtjin, bala yan ḻukanan. ");
INSERT INTO djr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ga wiripuny maŋutji mala ŋatha galkirrin guṉḏamirrilila wäŋalil, ŋunhiwilin ŋunhi munatha' ḏaŋawuklila. Ga bondin yan ŋayi ŋunhi ŋutharnydja ḏukitjmirriyinany. ");
INSERT INTO djr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ga ŋunhi nhakun waluny dhawaṯthurr bala yan räwakkuŋala ŋunhi ḏukitjtja, bili ŋuriki ḏukitjkuny wärrurrny'tja ŋunhi bäyŋu yan muka ŋula ŋuthanany ṉiṉ'thunany. ");
INSERT INTO djr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ga wiripuny maŋutji ŋatha malany galkirrin ḏimiṯimirrmirrilila, yurr dhamany'tjurrnydja maṉḏa ŋunhi ḏukitjtja rrambaŋin birralin ga ḏimiṯimirrnha. Bala ŋayiny ŋunhi ḏimiṯimirrmirrnydja mulmu ŋuthar mirithinan, bala ganydjarrnha dhawar'maraŋal ŋurikiyiny birraliwnydja, ga bäyŋun ŋayi ŋunhi ŋathany ŋuthana maŋutjimirriyinyany manymakthinyany. ");
INSERT INTO djr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ga wiripuny mala maŋutji ŋatha galkirrin manymaklila munatha'lil, bala ŋayiny ŋunhi ḏukitjtja ŋuthar buṯ bitjarra ŋamathinan yan, bala borummirriyinan dhaŋaŋdhinan dhika mirithinan, giḻyurra gan ŋathany, wiripuny märr dhaŋaŋ, ga wiripuny märr mirithirra dharrwa, ga wiripuny gan gurrwurr'yurra.” Ga balanyan ŋayi gan ŋunhi dhäwuny lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ga bulu ŋayi Djesu waŋan dhawar'maraŋalnydja bitjarra gam', “Ŋäma muka nhuma ga? Ga buthuru-bitjurrnydja walal ŋamathaŋun, märr nhuma dhu ŋämany dharaŋana ŋuyan dhiyak dhäwuw.” ");
INSERT INTO djr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ga beŋuryiny ŋayi gan Djesuny nhinan gänan, ga walalnydja ŋunhi 12-dja ḻundu'mirriŋuny mala nhanŋu ga wiripuwurrnydja yolŋu walal marrtjinan nhanukal bala walal ŋanya dhä-birrka'yurra bitjarra, “Way! Garray, mak napurruŋ mayali' lakaraŋ ŋunhiŋuwuyyi dhäwupuy,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ga ŋayiny Djesuny waŋan bitjarra, “Nhumany dhuwalawurrnydja ŋunhi ŋarrakuny ḻundu'mirriŋu mala yanbi marŋgimirra ŋurukuny ŋunhi Godkalaŋawnydja djinawa'wuywuny ŋuyaw, bilin ŋayi gan ŋunhi God-Waŋarryuny nhumalaŋgal warralkuŋala. Yurr lakaramany ŋarra ga dhuwal mayali'mirriyamany ŋurikiwurruŋgun yolŋuw walalaŋ, ŋunhi walal yaka yan gulŋiyinya God-Waŋarrwal Romlil.” ");
INSERT INTO djr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ga dhiyak ŋunhi gämurruwny'tja gam. “Dhiyaŋuwurruyyiny yolŋuy walal dhu ga nhäma warray, yurr bäyŋun walal dhu ŋunhi maḻŋ'maramany. Ga ŋunhi walal dhu ga ŋämany ga buthuru-bitjundja, yurr bäyŋuyi yan walal dhu ŋunhi dharaŋandja. Ga ŋunhi walal balaŋ ŋänhany be dharaŋanany, walalnydja balaŋ ŋunhi bilyunan God-Waŋarrwala, märr ŋayiny balaŋ walalaŋ ŋunhi bäy-lakaranhan.” ");
INSERT INTO djr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Bala ŋayi Djesuy lakaraŋala walalaŋ bitjarra, “Yaka yan nhuma ga dhuwal dharaŋandja muka? Dhuwandja ŋunhi dhäwu mayali'mirrnydja? Ŋuli nhuma ga yakany dharaŋul dhuwal dhäwu, ga nhaltjanna nhuma dhu ŋunhi dharaŋan wiripuny mala dhäwu. ");
INSERT INTO djr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yolŋu ŋunhi ŋayi ŋuli ga dhäwu lakaram Godkalaŋuwuynydja, ŋunhiyiny ŋayi balanya nhakun gätni-djämamirra, ŋunhiny ŋayi ŋuli ga ŋathan mala maŋutjin lämu-nhirrpan, ŋunhi ŋarra lakaraŋal nhumalaŋ ŋäthil. ");
INSERT INTO djr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ga wiripuwurruynydja yolŋuy walal ŋuli ga ŋunhi ŋäma warray ŋunhiyi God-Waŋarrwuny Dhäruk, yurr ŋayaŋuynydja balanyaraynha nhakun ŋunhi dhukarr gumurr-ḏäl munatha', ŋunhi ŋayi gan ŋatha mala maŋutji galkirrin ŋunhiliyi wäŋaŋur. Yo. Ŋäma warray nhuma ŋuli ŋunhi God-Waŋarrwuny dhäruk, yurr dhunupan ŋayiny ŋuli ŋunhi Djaytindja marrtjiny bala djaw'yunna nhanukalaŋuŋur ŋayaŋuŋurnydja ŋunhiyiny God-Waŋarrwuny dhäruk. ");
INSERT INTO djr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ga wiripuwurruynydja yolŋuy ŋuli ga ŋunhi dhäruk ŋäma, ŋayaŋuynydja balanyaraynha nhakun ŋunhi wäŋa munatha' guṉḏamirr, ŋunhi ŋuli ŋathany mala maŋutjiny galkirri ŋunhiwiliyiny wäŋalil munatha'lil, ga ŋäma warray ŋayi ŋuli ŋunhiyi dhäruktja, bala dhunupan ŋayi ŋuli ŋunhi märramany gumurr-ŋamathinyawurra. ");
INSERT INTO djr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Yurr yakan ŋayi ŋuli ŋunhi dhäruktja gärri mirithiny nhakun ṉiṉ'thurrnydja; yan walal ŋuli ŋunhi guwarr yan ŋurikiyi goŋ-djarryundja. Ga ŋunhi nhakun walal ŋuli gärri ŋayaŋu-miḏikinyamirrililnydja romlil ga ŋulnyirrlilnydja, ga dhunupan bala yan walal ŋuli nhakun gananna, gulyunna beŋuryiny Godkalaŋuŋurnydja dhärukŋur.” ");
INSERT INTO djr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ga wiripuwurruynydja yolŋuy walal ŋuli ga ŋäma dhäwu balanyaraynha ŋayaŋuy nhakun ŋunhi munatha' ḏimiṯimirrmirr. ");
INSERT INTO djr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Yurr ŋayaŋuŋurnydja walalaŋgal ŋuli ŋunhi dhaŋaŋdhirrnydja ŋula nhän mala wiripun; balanya nhakun warwun mala dhuwalaŋuwuynha munatha'wuynha. Ga bitjanna walal ŋuli ga ŋunhi guyaŋany yanbi walal dhu ga ŋayaŋu-djulŋithirrnydja ga gana'yirrnydja ḻukunydja'kunhaminyaraynha yan romdhuny. Ga djälthirrnydja walal ŋuli ga mirithirrnydja ŋula nhakun yan mala. Yo, dhiyaŋiyin malaŋuy ŋuli ŋunhi ŋapa-dhurrthurryundja, nhakun gungamany God-Waŋarrwuny dhäruk ŋuthanaŋurnydja yolŋuwalnydja walŋaŋur, ga yakan nhakun ŋuli ŋunhi walŋany nhanŋu ŋuthul borummirriyiny. ");
INSERT INTO djr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ga wiripuwurruynydja yolŋuy walal ŋuli ga ŋunhi ŋäma dhäwu balanyaraynha ŋayaŋuy nhakun ŋunhi munatha' buḻŋu'kunhawuy. Ŋunhi walal ŋuli nhakun ŋämany Godkalaŋuwuynydja dhäwu, bala ŋuli ŋunhi dhäruktja ŋuthanna nhanukal, bala borummirriyirra; wiripuny märr ḻurrkun', ga wiripuny märr gaŋga dharrwa, ga wiripuny dharrwan yänan walalaŋgal ŋuli ŋuthan.” Ga bitjarryin ŋayi gan ŋunhi Djesuy dhuwurr-lakaraŋalnydja ŋunhiyiny dhäwu ŋunhi dhulmu-mayali'mirrnydja. ");
INSERT INTO djr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ga bulu ŋayi Djesu waŋan bitjarr, “Ŋunhi ŋuli yolŋuy lanhdhirrany dhuŋgur'yun, ga wanhawala ŋayi ŋuli ŋunhi nhirrpandja? … ŋoylila djuḻuḻ'maram? … ŋany dhurrthurryunna ŋayi ŋuli banikin'thun muka? … dhurrparaman ŋunhiyiny? Bäyŋu. Yan ŋayi dhu ŋunhi märramany, bala ŋal'maraman garrwarlila. ");
INSERT INTO djr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yo, nhä ga ŋunhi ŋorra djuḻuḻ'maranhawuy, ŋunhiyiny dhu dhawaṯthurra warraŋullila gaykarraŋlila, ga nhä ga ŋunhi ŋorra dharrpanawuynydja dhu maḻŋ'thurra warraŋulthin.” ");
INSERT INTO djr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“Yo, buthuru-bitjurrnydja walal yuwalkkuŋun yan ŋurikin ŋunhi djinawa'wuywun dhäwuw, märr nhe dhu ŋunhi ŋämany dharaŋana yan.” ");
INSERT INTO djr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Manymakkuŋ yan gi guyaŋiny ŋunhi nhä nhe ga ŋäma. Ŋayiny dhu nhuna ŋunhi mel-dhunupan yan waŋiny, biyak yan bili nhakun nhe ŋuli ga ŋunhi wiripuwurruny yolŋuny walalany wiripuŋuyam nhäma. Ga mirithin yan ŋayi dhu ŋunhi nhunanhany dhä-gir'yurr. ");
INSERT INTO djr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bili ŋunhi ŋayi ga ŋula yolthu yolŋuy ŋayatham Garraywuŋuny gurrupanawuy ŋula nhä malany, ŋayiny dhu God-Waŋarryuny ŋanya bulun gurrupan bukulila ŋal'maram. Ga ŋuli dhu ga yolŋuy yakany ŋayatham God-Waŋarrwuŋuny ŋula nhä malany, ŋunhiyiny ŋayi dhu warrpam'nha yan djaw'yurr.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ga bulu ŋayi Djesu waŋan bitjarr, “God-Waŋarrwuny Rom dhuwal balanya nhakun ŋunhi gätni-djämamirr, ŋunhi ŋayi ŋuli marrtji lämu-nhirrpan ŋatha mala maŋutji. ");
INSERT INTO djr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Manymak munhawuny ŋayi ŋuli ga ŋunhi yolŋuny ŋorran, ga rur'yundja ŋayi dhu ŋunhi goḏarrny'tja bala ŋayi ŋuli djämany wiripun, wiripuŋuynha ŋayi ŋuli ḻay-ḻayyun djämay. Yurr ŋunhi lämu-nhirrpanawuynydja ŋathany ŋuli marrtji biṯthunna, ŋuthandja ŋuli ŋunhi yindithirra dhika, ga ŋayiny ŋunhiyiny yolŋuny yakan marŋgi nhaliy ŋayi gan ŋunhi ŋuthar. ");
INSERT INTO djr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yo, dhiyaŋ bili yan ŋayi ŋuli ga ŋunhi munathay' ŋuthanmaramany ŋunhi ŋathany lämu-nhirrpanawuynhany. Ŋurruŋuny ŋathil ŋayi ŋuli ŋunhi ŋuthanmaram ŋunha wärrurr, bala ŋuli ḏukitjtja dhawaṯthunna, ga bitjanna bili ŋayi ŋuli marrtji ŋunhi ŋuthandja yindithirra muḻkurrmirryirra, ga yan bili-i-i-i ga muḻkurr ŋayi dhu ŋunhi ŋathamirriyirr borummirryirr. ");
INSERT INTO djr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ga ŋunhi ŋayi dhu ŋunhi ŋathany dhakalnydja borumdhirr, bala ŋayiny ŋuli ŋunhi yolŋuynydja dhunupan yikin märram, bala ŋayi dhu marrtji gulkthunna, bili ŋayi ŋunhi ŋatha-ŋamakuli'yan waluny.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ga bulu ŋayi Djesu waŋan dhä-birrka'yurr walalany bitjarr, “Yo, nhäthinya bili ŋunhi God-Waŋarrwuny Rom? Nhä dhika limurr dhu mayaliny' lakaram yolŋu'-yulŋuwnydja dharaŋanaraw? ");
INSERT INTO djr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","God-Waŋarrwuny dhuwal Rom walŋa warray ga ŋuthanamirr, balanya dhuwal nhakun ŋunhi genydja' nyumukuṉiny maŋutji borum. Bäyŋun gi ŋula wiripuŋuwnydja dharpaw mala maŋutji balanyayiny dhärri nyumukuṉiny'tja mirithirrnydja. Ga ŋunhi ŋuli yolŋuy lämu-nhirrpandja ŋunhiyiny maŋutji munatha'lilnydja, ");
INSERT INTO djr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","bala ŋayi ŋuli ŋunhiyi ŋuthandja marrtji yindithirra mirithirra, ga waṉany mala nhanŋu ŋunhi bitjarryi bili yan ŋuthar yindithindhi. Bala walalnydja ŋuli warrakan'tja mala marrtjiny bala djäman walalaŋguwuy walal yalun' mala waṉa'lilnydja malaŋulil.” ");
INSERT INTO djr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yo, lakaraŋalnydja ŋayi gan ŋunhi Djesuynydja dharrwa mirithirr dhäwuny mala mayali'mirriyaŋalnydja, märr walal gan marŋgithinan, bala yan dharaŋara. ");
INSERT INTO djr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bitjarr bili yan ŋayi gan ŋunhi dhäwuny mala walalaŋ lakaraŋal mayali'kurra yan. Ga nhanukalaŋuwala yan malthunamirriwal walalaŋgal ŋayi gan warraŋulkuŋalnydja lakaraŋal mayaliny' dhäwupuynydja mala, märr walalnydja gan ŋunhi yuwalknha yan marŋgithin ga dharaŋar. ");
INSERT INTO djr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ga ŋuriŋiyi bili waluy yurr munhawun, ŋayiny marrtjin waluny gärrinan, bala ŋayi Djesuny waŋanan bitjarra malthunamirriwalnydja mala nhanukalaŋuwal, “Go limurr marrtjin, buḏapthunna ŋunha-gali'lila,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bala walal ŋunhi ḻundu'mirriŋuny mala marrtjinan, ga ŋunhi yolŋu'-yulŋunhany mala walal ganarrthaŋala, ga Djesunhany walal gaḏaymara, bala walal buḏapthurra. Ga wiripu marthaŋay mala marrtjin malthurryi walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Ga watany walalaŋ ŋunhi yindin bunanany, yurr ŋayiny marrtjin Djesuny ŋunhi yakurrnha ŋorran ŋunhiliyiny marthaŋayŋurnydja, ḻiya ŋayi ŋal'yurr ḏämbupuylil, bala marrtjin ŋorranan. Bala gan gapuny rur'yurra mirithinan, bala marrtjin ŋunhi gapuny wapthurra balayin marthaŋaylila, galki balaŋ ŋunhi marthaŋaynydja guḻwuḻyunan. Yurr ŋayiny marrtjin mukthurra bala Djesuny ŋorran dhuḏiŋurnydja marthaŋayŋur ḻiya-gorruŋal marrtjin ḏämbupuyŋur. Bala walalnydja ŋunhi ḻundu'mirriŋuny mala nhanŋu marrtjin, bala dhirr'yurra ŋanya, “Way, Garray. Rur'yurr! Dhuwal limurr dhu dhiŋga'-dhiŋgaman,” bitjarr. “Muka bäyŋu nhe gi dhuwal warwuyurrnydja. Nhaku nhe marrtji dhuwal ŋorrany? Dhiŋgaman limurr dhu dhuwal.” Bitjarr walal ŋunhi ḻundu'mirriŋuny mala nhanŋu waŋan. ");
INSERT INTO djr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bala ŋayi Djesuny rur'yurrnydja, bala dhunupan waŋanany dhärukthuny ḏälyun watawnydja bitjarra, “Ma', gulyurra!” ga gapuwnydja muka ŋayi waŋan bitjarr, “Way mukthurra,” bala gapuny ŋunhi nyimdhurra wapurarryinan. ");
INSERT INTO djr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bala beŋuryiny ŋayi bilyurrnydja, bala waŋan bitjarra, “Nhaku nhuma ga dhuwal barrarirrnydja? Yaka nhuma gi dhuwal märr-yuwalkthiny muka? Baḏak yan nhuma dhu ga dhuwal ŋarrakuny märr-dhumbal'yun?” ");
INSERT INTO djr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bala walalnydja nhanŋu ŋunhi ḻundu'mirriŋuny mala mirithinan yan ŋoy-gärrinany, ga waŋanhaminany walal bitjanminan, “Yol ŋayi dhuwal yolŋuny? … märr ŋayi ga dhuwal waŋa gapunhany ga watanhany, ga dhunupan ŋanyanhany dhu ŋunhi dhäruk märraman.” Bitjarra walal gan ŋunhi ḻundu'mirriŋuny mala waŋanhamin. ");
INSERT INTO djr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Djesuny ga malthunamirrnydja mala nhanŋu buḏapthurra ŋurikiyiny ŋunhi guḻungu Galalipuywuny, ga dhawaṯthurrnydja walal ŋunha galin' galki wäŋa yäku Garatjinnha. ");
INSERT INTO djr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ga ŋunhi ŋayi Djesu wapthurrnydja marthaŋayŋurnydja bala yolŋuny nhanŋu ŋunhiliyiny bunanan yätjkurrumirra birrimbirrmirr, ga waṉḏinany ŋayi gan ŋunhi guwatjmarnydja rälin ŋanyanhan Djesunhan, yurr dhawaṯthurrnydja ŋayi ŋunhi beŋuryi banydji ");
INSERT INTO djr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","moluŋur ŋunhi ŋayi gan nhinan ŋunhiliyi wiyinŋumirr. ");
INSERT INTO djr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ga dharrwamirr gan yolŋuy walal birrka'yurr garrwi'yurr ŋanya rakiy' mala, ga wiripuny djimukuy' ŋuli ḻuku maṉḏany ḏapmaranha ḏälkunha dhika mirithinya, yurr gulkurun, ŋayiny gan ḻarrmaraŋal bakmaraŋal gan yan. Ga bäyŋun ŋayi gan ŋunhi ŋula yolkalnydja yolŋuwal ganydjarrŋur nhinan. ");
INSERT INTO djr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Bitjarr bili munha-ŋupar ga walu-ŋupar ŋayi gan ŋunhi buku-wirwiryurrnydja ŋulatjarryiny bukukurrnydja molumirrikurrnydja yatjurr, ga mitmitthunmin guṉḏay djinbulkthu. ");
INSERT INTO djr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ga ŋunhi ŋayi ŋuriŋiyi ḏirramuy nhäŋal Djesunhany ŋunhawal yan muka barrkulil, bala yan ŋayi waṉḏinan gumurr'yurra bala bun'kumu-djipthurra gumurrŋura nhanukal. ");
INSERT INTO djr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Bala yan ŋayi waŋanany yatjurra bitjarra, “Djesu, Gäthu'mirriŋu God-Waŋarrwu, ŋunhi ŋayiny ŋunhaŋuwuy djiwarr'wuy, nhaltjanna nhe dhu dhuwal ŋarrany yulŋuny? God-Waŋarrwal yäkuy ŋarra nhuna ga dhuwal ŋäŋ'thundja, yaka ŋarrany ŋayaŋu-miḏikumulnydja.” ");
INSERT INTO djr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ga bitjarryiny ŋayi ŋunhi waŋan, bili ŋayiny ŋunhi Djesuynydja ŋäthil yan muka waŋanany ŋaŋ'ŋaŋ'thurrnydja ŋunhiyiny yätjkurrunhany birrimbirrnha nhanukal ŋurikalyiny ḏirramuwalnydja. ");
INSERT INTO djr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Bala ŋayi Djesuynydja dhä-birrka'yurra ŋanya bitjarra, “Yol bili nhe dhuwal yäkuny?” bitjarr. Ga ŋayiny lakaranhamin bitjanmin, “Ŋarrany dhuwal yäku ‘Dharrwa,’ bili dharrwa mirithirr ŋarrakal ga dhuwal yätjkurrnydja birrimbirr mala nhina,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ga waŋanany ŋayi gan ŋunhiyi ḏirramuny mirithinan yan Djesunhany ŋayi dhu yaka yan walalany ŋaŋ'ŋaŋ'thundja wiripulilnydja wäŋalil. ");
INSERT INTO djr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ga ŋunhiliyi bili bukuŋur gan bikipiki mala dhärra'-dharran, yurr dharrwa mirithirr, ḻukan walal marrtjin mulmu. ");
INSERT INTO djr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Bala ŋunhi yätjkurruynydja birrimbirryu mala gan waŋanany mirithinan Djesunhany bitjarra, “Way balan ŋanapurruny djuy'yurrnydja, märr napurr dhu gärriny bikipikiwalnha malaŋuwal,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bala ŋayi Djesuynydja gan dhawaṯmaraŋala walalany beŋuryiny ḏirramuwalnydja, ga gundupuŋalnydja walal gan ŋunhi balan bikipikiwalnha malaŋuwal. Bala walalnydja gan ŋunhi bikipikiny mala gundupuŋalnydja yarrupthurra gapulila, bala gan ḻupthurra, ga bukmaknha ŋunhi bikipikiny mala guḻwuḻyurra. Ga bukmaktja walal ŋunhi malany bikipikiny, ga 2,000. ");
INSERT INTO djr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ga ŋunhi bikipiki djämamirrnydja mala waṉḏi'-waṉḏinan balan bitjarra wäŋalila, bala walal marrtjin lakaraŋala dhäwuny birrŋ'maraŋala warrpam'lila yan wäŋalilnydja mala. Bala gan ŋunhi dharrwan yolŋuny walal balayin wäŋgaŋalnydja, djälthinan walal gan nhänharawnha ŋunhi nhä ŋunhiliyi maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ga ŋunhi walal marrtjinany Djesuwalnydja, bala walal nhäŋala ŋunhiyi ḏirramunhany ŋunhi nhanukal gan ŋäthil nhinan dharrwa mirithirr wakinŋu birrimbirr mala. Ga nhinanany ŋayi gan ŋunhi girri'mirra dhaṯthunawuynha ḻiya-ŋamakulin, bala yan walal barrarinan. ");
INSERT INTO djr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ga ŋunhi maŋutji-marŋgimirriynydja gan dhäwun lakaraŋal wiripuwurruŋguny yolŋu'-yulŋuw, ŋurikalaŋuwuyyin ḏirramuwalaŋuwuynha ga bikipikiwuynha mala. ");
INSERT INTO djr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bala walalnydja ŋunhi yolŋu'-yulŋuny mirithinan barrarinany, bala mirithinan gan waŋan Djesunhany marrtjinyarawnha yan. ");
INSERT INTO djr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ga ŋunhi ŋayi Djesu wapthurrnydja marthaŋaylilnydja, bala ŋayiny ŋunhiyiny ḏirramu ŋunhi nhanukal gan ŋäthil wakinŋu birrimbirr mala gulŋiyin, waŋanany gan mirithinan yan giriŋ'thurra malthunarawnha yan. ");
INSERT INTO djr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yurr ŋayiny Djesuny yaka'yurr nhanŋu, ga waŋan ŋayi nhanŋu bitjarr, “Gatjuy nheny balayi roŋiyi gurruṯumirriwal nhokalaŋuwal, ga lakaraŋ walalaŋgal ŋunhi nhä nhuŋu Garrayyu manymak djäma, ga nhaltjarr ŋayi nhuŋu wuyurr.” ");
INSERT INTO djr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bala ŋayi ŋunhi ḏirramuny marrtjinan roŋiyinan ŋunhiwilin makarrlil wäŋalil Dikapulitjlila, bala yan marrtjin lakaraŋala bukmakkala, ŋunhi nhaltjarr ŋayi Djesuy djäma nhanŋu. Ga bukmakthuny gan ŋunhi dhäwuny ŋäkul ganyim'thurra nhanukuŋ. ");
INSERT INTO djr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ga buluyi ŋayi Djesu wapthurr marthaŋaylil, bala marrtjinan buḏapthurra ŋurikiyiny ŋunhi Galalipuywuny guḻungu. Manymak wapthurr ŋayi marthaŋayŋurnydja bala gan dhärranan raŋiŋura, bala dharrwan mirithirra yolŋuny walal marrtjin dhärranany ḻiw'maraŋala ŋanya. ");
INSERT INTO djr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ga yolŋu yäku Djäratj gan ŋunhiliyi dhärran ŋunhi ŋayi ŋurruḏawalaŋu gapman Djuw malaŋuw buku-ḻuŋ'maranhamirriw buṉbuw. Ga ŋunhi ŋayi nhäŋal Djesunhany, bala yan ŋayi marrtjinan bala ŋayi ŋurrkanhaminan munatha'lila ḻukuŋura nhanukal. ");
INSERT INTO djr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Bala ŋayi gan waŋanan ŋanya mirithinan yan guŋga'yunarawnha. Ga bitjarr ŋayi ŋunhi waŋanany gam', “Yothu ŋarraku ŋunha miyalk rirrikthun ga, galki ŋayi dhu ŋunha dhiŋgaman! Buku-djulŋi yan ŋathil nhe dhu marrtji ga goŋ-ŋal'yun nhanukal märr ŋayi dhu ḻayyunna, ga yakan dhiŋgamany.” ");
INSERT INTO djr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bala ŋayiny Djesuny malthurra nhanŋu Djäratjkuny. Ga dharrwan gan ŋunhi yolŋuny walal wäŋgaŋal ḏur'-ḏuryunminan marrtjin Djesuwalaŋuwurra. ");
INSERT INTO djr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Manymak ga ŋunhiliyi malaŋur miyalk gan marrtjindhi, yurr ŋayi gan ŋunhi gulaŋ waṉḏin yan 12-nha dhuŋgarrany ŋupar. ");
INSERT INTO djr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dharrwamirr ŋayi gan birrka'yurr marrtjin marrŋgitjkal malaŋuwal, märr walal balaŋ ŋanya djäma ḏukmaranha, yurr gulkurun, bäyŋu yan ŋayi walalaŋguŋ ŋamathinany, yan warray ŋayiny gan rirrikthurra yan walalaŋguŋ. Dharrwan mirithirra nhakun ŋayi gan ŋunhi rrupiyany djalkthurr wuŋiḻi'yurrnydja gan walalany. Yurr bäyŋu ŋayi ŋunhi yuwalktja manymakthina. Yan ŋayiny marrtjin ŋunhi rerriny nhanŋu bala yindithin warray. ");
INSERT INTO djr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ga ŋunhi ŋayi ŋuriŋiyi miyalkthu ŋäkul Djesunhany, bala yan ŋayi marrtjinany ḏiltjikurra nhanukalaŋuwurr, dhaḻakarr-yarpuŋal yolŋuwal walalaŋgal malakurr. ");
INSERT INTO djr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ga bitjarr ŋayi marrtjin ŋunhi waŋanhaminany, “Ŋuli ŋarra dhu dhuwal ŋula girriny' yan nhanŋu ŋayatham, ŋarrany dhu manymakthirra.” ");
INSERT INTO djr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ga dhunupan yan ŋayi goŋ-djarryurrnydja baṯnha ŋayathaŋal girrin' nhanŋu, bala dhunupan nhanŋu ŋunhi maŋguny' gulyurra waṉḏinyaŋurnydja, bala yan ŋayi ŋunhi manymakthinan. ");
INSERT INTO djr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ga balanyamirriy bili yan ŋayiny Djesuynydja dhäkay-ŋäkula nhanukiyingal ŋayi rumbalŋurnydja ŋayi ganydjarrnydja dhawaṯthurra ganarrthaŋala ŋanya. Bala yan ŋayi gumurr-bilyurrnydja, bala ḏawa'yurra ga waŋanany ŋayi dhä-birrka'yurrnydja yolŋu'-yulŋunhany bitjarra, “Yolthu ŋarraku girriny ŋayathaŋal?” ");
INSERT INTO djr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ga walalnydja ŋunhi malthunamirrnydja mala nhanŋu waŋan bitjarra, “Nhäŋu ŋathil dhuwal yolŋuny walalany mala ŋapa-ŋal'-ŋalmaranhamirr marrtji ḏur'-ḏuryunmirr nhokalaŋuwurr, nhaku nhe bitjarryiny waŋan, dharrwan dhuwal mirithirra yolŋuny walal,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bala ŋayi Djesuny ḏawa'yurrnydja dharrnha nhäŋal ŋunhiyin yan yolŋunhany ŋunhi ŋayi girri' nhanŋu ŋayathaŋal. ");
INSERT INTO djr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ga dhunupan yan ŋayi ŋunhi miyalktja marŋgithinan bala barrarinan, marrmarryurra marrtjin barrariynydja nhanukiyingal ŋayi, bala yan ŋayi bun'kumu djipthurrnydja ŋunhilin bili gumurrŋura nhanukal Djesuwal, ga dhunupan ŋayi ŋunhi dhäwun nhanŋu lakaraŋalnydja nhanukiyingalaŋuwuy ŋayi. ");
INSERT INTO djr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Bala ŋayi Djesuny waŋanan ŋurikalyiny miyalkkalnydja bitjarrnha, “Way gäthu, nheny dhuwal bilin ḏukthurra märr-yuwalkthinyaraynha nhokiyingal nhe. Gatjuy marrtjiny ŋoy-ŋamathin, bilin nhe dhuwal manymakthinan rerriŋurnydja,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ga ŋayiny gan ŋunhi Djesuny baḏak yan waŋan, bala walalnydja ŋunhi yolŋuny walal bunanan ŋunhiliyiny dhäwumirrnydja mala beŋurnydja Djäratjkalnydja wäŋaŋur, bala walal lakaraŋalnydja bitjarrnha, “Way Djäratj, bilin ŋunha gäthu'mirriŋuny nhuŋu rakunydhinan. Yakan ŋanyanhany Marŋgikunhamirrinhany buluny ḻay-ḻaymaraŋ,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ga ŋayiny Djesuynydja ŋäkul walalany, bala ŋayi bitjarra Djäratjkuny waŋan, “Yaka barrari, yan märr-nhirrpanmirra,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bala ŋayi Djesuynydja garr'yurrnydja Betanhan yan, ga maṉḏanhan wäwa'manydjinhan Djayimnhan ga Djonnhan, ga bilin. ");
INSERT INTO djr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bala walal marrtjinan balayin Djäratjkala wäŋalil. Ga nhäŋalnydja walal yolŋunhany walalany ŋäthinyaminyalila yindiynha rirrakayyuny yatjunminan walal gan. ");
INSERT INTO djr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bala Djesuny gulŋiyinan ŋunhiwiliyiny buṉbulilnydja, bala ŋayi waŋanan yolŋuwnydja walalaŋ bitjarra, “Nhaku nhuma ga dhuwal yatjunmirrnydja ŋäthi? Yaka ŋayi dhuwal rakuny, dhuwaliyiny ŋayi ga ŋorra yan yakurr.” ");
INSERT INTO djr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ga walalnydja ŋunhi yolŋu'-yulŋuynydja warku'yurr warray ŋanya gitkitthunmin nhanŋu. Bala ŋayi gan Djesuynydja dhawaṯmaraŋala bukmaknhan yan yolŋunhany walalany warraŋullila, ga garr'yurrnydja ŋayi Djäratjnhan yan ga miyalknhan nhanŋu, ga ŋunhiyin ḻurrkun'nhan ḻundu'mirriŋunhan nhanŋuwuy ŋayi, bala walal gulŋi'-gulŋiyinan ŋunhiwiliyin ŋunhi wanhal gan ŋayi ŋunhi yothu wirrkuḻ ŋayathanhamin. ");
INSERT INTO djr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","42","Bala ŋayi Djesuynydja goŋnha ŋanya ŋayathaŋal ŋunhi wirrkuḻnhany dhuŋgarra 12-mirrinhany, bala waŋanan, “Dalitha gom,” mayali' “Wirrkuḻ miyalk rur'yurra.” Ga dhunupan yan ŋayiny ŋunhi wirrkuḻnydja rur'yurra, bala yan ŋayi marrtji'-marrtjinan. Ga bukmakthuny gan ŋunhi nhäŋalnydja ganyim'thurra. ");
INSERT INTO djr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bala ŋayi Djesuynydja waŋanan walalany dhä-mukmaraŋala yakaŋuwnha lakaranharaw, ŋunhi nhä ŋunhiliyi maḻŋ'thurr. Bala ŋayi Djesuny waŋanan, “Gatjuy ŋula nhä walal ŋanya gurrupul ŋayi ḻukan,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Bala ŋayi Djesuny marrtjinan ganarrthaŋala ŋunhiyiny wäŋa, yurr ŋayi ŋunhi marrtjinany roŋiyinany balan nhanukiyingala wäŋalil, ga walalnydja malthunamirrnydja mala nhanŋu malthurryi. ");
INSERT INTO djr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ga wiripuŋuynha Nhinanhamirriy waluy, ŋayiny gan ŋunhi Djesuynydja marŋgikuŋala dhäwun lakaraŋal yolŋu'-yulŋuwnha ŋunhilin ŋunhi Djuw malawal buku-ḻuŋ'maranhamirriŋura buṉbuŋur. Ga dharrwaynha gan ŋunhi yolŋuynydja walal ŋäkulnydja ṉirr'yurra dhäwuny nhanukuŋ, bala walal gan ŋunhi dhä-birrka'yunminan, “Way, wanhal ŋayi gan dhuwal marŋgithinany? Wanhaŋur ŋayi gan dhuwal balanyayiny mala guyaŋanhawuy märraŋal, djämaw ŋayaŋu-ganyim'thunamirriwnydja romgu? ");
INSERT INTO djr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dhuwandja dhuwal ŋunhi bala'-dhuḻ'yunamirr warray, Meriw waku'mirriŋu. Ga wäwa'mirriŋuny mala nhanŋu ŋunhi Djayim ga Djawutjip ga Djudatj ga Djäyman, ga yapa'mirriŋuny mala nhanŋu ŋuli ga dhiyal muka nhina limurruŋgala wäŋaŋur ŋaraka.” Bala gan ŋunhi yolŋuny walal yakan nhanŋu gumurr-ŋamathinany ŋurru-bil'bilyurra walal gan nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yurr ŋayiny Djesuny waŋan bitjarr, “Ŋunhi ŋuli djawarrkmirrnydja yolŋu marrtji wiripuŋulilnydja wäŋalil, ga walalnydja ŋuli ŋunhi ŋunhiŋuwuyyiny wäŋapuyyu yolŋuy mala dhäruk ŋanya märram muka ga märr-ŋal'yun nhanŋu. Yurr ŋunhi nhakun ŋayi ŋuli nhanukiyingalnydja wäŋalil marrtji nhanukiyingalaŋuwalnydja yolŋuwal walalaŋgal gurruṯumirriwalnydja mala walalnydja ŋuli ŋunhi yakan ŋanya dhäruk-märraŋ ga märr-ŋal'yurr nhanŋuny bäyŋun.” ");
INSERT INTO djr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ga buluny ŋayi gan Djesuy bäyŋun djäma ganydjarrmirrnydja rom ŋunhiliyiny, yänan ŋayi marrtjin waŋga'-waŋganygala yan yolŋuwalnydja walalaŋgal goŋ-ŋal'yurr yurr ḻurrkun'kala yan rerrimirriwala mala yan, bala walalnydja gan yan ḏukthurra. ");
INSERT INTO djr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ga nhäŋalnydja ŋayi gan ŋunhi yolŋunhany walalany ganyim'thurra, bili walalaŋ ŋunhi märr-nhirrpanminyawuynydja bäyŋuthinan. Mäk 6.7-13 Bala ŋayi marrtjin Djesuynydja marŋgikuŋalnydja yolŋu'-yulŋunhany buku-ḻiw'maraŋala wäŋakurra malaŋuwurr. ");
INSERT INTO djr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ga ḻuŋ'maraŋal ŋayi Djesuy ŋunhi 12-nha malthunamirriny walalany nhanŋuwuy ŋayi, bala ŋayi gäna'-ganaŋ'maraŋala walalany marrtjin märrma'-marrmanhan. Bala ŋayi gan ganydjarrnydja gurrupara walalaŋgal yätjkurruwnydja birrimbirrwu dhawaṯmaranharaw. ");
INSERT INTO djr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ga bitjarr ŋayi ŋunhi waŋanany walalaŋgal, “Dharpa yan nhuma dhu märramany gaṉdji'yunminyaraw. Ga yakan walal ŋula nhäny gäŋu dharrwany mirithirrnydja girri', ga ŋula nhä ŋatha ga rrupiya, ga bathi. ");
INSERT INTO djr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ga dhapathuŋ'nha yan nhirrpulnydja ḻukulila, ga yakan wiripuny gäŋu girri' nhirrpanaraw. ");
INSERT INTO djr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ga ŋuli walal nhuŋu dhu wäthundja gumurr-ŋamathinyawurrnydja nheny yanan nhinin walalaŋgal ŋunhiliyiny wäŋaŋur, ga yan bili ga ganan nhe dhu ŋunhiyi wäŋa. ");
INSERT INTO djr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ga ŋuli nhuŋu walal dhu yakany gumurr-ŋamathirr, bili walal dhu ŋunhi yaka ga djälthirr dhäwuw ŋänharaw, nhumany dhu ganarrthaman yan ŋunhiyiny wäŋa, bala ḏawaṯawayurra munathany' ḻukuŋurnydja nhokiyingal nhe bala marrtjin, märr walalnydja dhu marŋgithirra walalaŋguwuy walal yätjkurruwnydja.” ");
INSERT INTO djr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Manymak, marrtjinany walal gan ŋunhi buku-ḻiw'maraŋala wäŋakurrnydja malaŋuwurr waŋanan marrtjin yolŋunhan walalany bilyunarawnha God-Waŋarrwal. ");
INSERT INTO djr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ga dharrwanhan mirithirra walal gan ŋunhi wakinŋunhany birrimbirrnha mala dhawaṯmaraŋal yolŋuwalnydja walalaŋgal. Ga dharrwany rerrimirriny yolŋuny walalany walal gan biḏi'yurr wiyikay', bala walalnydja gan yan ḏukthurra. ");
INSERT INTO djr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ga balanyamirriynydja waluy yolŋu gan buŋgawany nhinan ŋunhiliyiny yäku Geŋ-Yarit. Bala ŋayi ŋuriŋiyi buŋgawaynydja ŋäkula dhäwuny Djesuwalaŋuwuynydja, bili dhäwuny ŋunhi nhanukalaŋuwuy gan ḻatjuwarr'yurra bawalamirrilila wäŋalilnydja. Wiripuynydja gan yolŋuy walal guyaŋan bitjarra, “Dhuwandja Djonnha ŋunhiyin yolŋu ḻiya-ḻupmaranhamirra, buluyi nhakun ŋayi walŋathirr rakunyŋurnydja, ga dhiyaŋiyin mak ŋayi ga dhuwal ganydjarrnydja ŋayatham balanyarawyiny djämaw.” ");
INSERT INTO djr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ga wiripuwurrnydja gan waŋanhamin lakaranhamin bitjanminan, “Dhuwandja mak bäy Yilaydjan. Mak wiripun ŋula yolŋu djawarrkmirr baman'ŋuwuynha.” ");
INSERT INTO djr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ga ŋunhi ŋayi Yaritthu ŋäkul Djesuwalaŋuwuynydja dhäwu, bala ŋayi waŋanany bitjarra, “Ŋunhiyiny dhuwal Djonnha yan yolŋu, bili ŋarra barpuru muka ŋanya ŋunhi gupany gulkthun ga dhuwandja ŋayi buluyi walŋathindhi rakunyŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Yo, yuṯa'-yuṯaŋumirriynydja ŋayi Yaritthuny märram miyalknha yäkuny Yirutiyany, ga miyalktja ŋayi ŋunhi manaŋinany yukuyuku'mirriŋuw nhanukalaŋuw Bilipku. Manymak, ŋayiny Djondja marrtjin bala gan waŋanan dhunupan nhanŋu Yaritkuny bitjarra, “Way yaka dhuwal nhuŋu dhunupa nhe djaw'yurr yukuyuku'mirriŋuw nhokalaŋaw miyalk.” Bala ŋayiny ŋunhi miyalktja ŋoy-dhärranan nhanŋu Djonguny, ga djälthinany ŋayi gan bunharawnha nhanŋu murrkay'kunharawnha yan, yurr bäyŋu. Ga ŋayiny Yarittja waŋan yaka'yurr, yaka ŋayi djälthin nhanŋu bunharaw, bili ŋayi gan nhanŋu barrarin, ga marŋgi ŋayi nhanŋu ŋunhi ŋayiny Djondja yolŋu dhuwurr-dhunupan ga dharrpalnha, manymaknha yan yolŋu. Bala ŋayi ŋanya ŋunhi walŋakuŋala, bili ŋayi gan ŋunhi dhumbal'yurra nhanukal, ga dhäwuwny'tja ŋayi gan ŋunhi mirithinan yan djälthinany ŋänharawnydja nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bala Yaritku waluny bunanan ŋunhi dhawal-guyaŋanhawuynydja, bala ŋayi waŋanan dharrwanhan yolŋunhany walalany gaḏaymarnydja balayiny ŋathalilnydja, balanya mala nhakun ŋunhi ŋurruḏawalaŋu gapman djämamirr mala, ga ŋurruḏawalaŋu miriŋu mala. Yo, manymak ḻukanan walal marrtjin ŋunhi ŋathany ga gapuny, ");
INSERT INTO djr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ga ŋunhiliyi gan miyalk yothu burr'yurr, yurr ŋayi ŋunhi Yirutiyaw waku'mirriŋuny. Manymak burr'yurrnydja ŋayi gan ŋunhi yothuny miyalktja latju'kuŋala dhika. Bala walalnydja ŋunhi Yaritthuny ga yolŋu'-yulŋuynydja mala ŋunhiliyiny mirithinan ŋanya buku-wurrparnydja ŋunhiŋuwuyyiny buŋgulpuynydja burr'yunawuy. Bala ŋayi ŋunhi Yarittja waŋanan nhanŋu bitjarra, “Ŋuli nhe ŋarrany dhu ŋäŋ'thun ŋula nhaku nhe djäl, ŋarrany nhuna dhu gurrupanna yan. ");
INSERT INTO djr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ga ŋuli nhe djälnydja ŋarra dhu mala-wulkmaraman ŋunhi warrpam'nha yan nhä malany ŋarra ga ŋayatham, … ŋarra dhu gulkmaraman nhuŋun, ga ŋarrakuwuynha. Nhaku nheny djäl?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ga ŋayiny ŋunhi yothuny miyalktja waṉḏin ŋathil ga ŋäṉḏi'mirriŋuny nhanŋuwuy ŋayi dhä-birrka'yurr bitjarr, “Nhaku ŋarra ŋanya dhu ŋäŋ'thundja,” bitjarr. Bala ŋayiny ŋunhi ŋäṉḏi'mirriŋuynydja dhäruk gurrupar nhanukal bitjarra, “Waŋiny ŋanya ŋäŋ'thurrnydja Djongalaw muḻkurrwu.” ");
INSERT INTO djr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bala ŋayiny ŋunhi miyalktja yothuny dhunupan waṉḏinany Yaritkala, bala ŋayi bitjarra waŋanany, “Djälnydja ŋarra, nhe dhu muḻkurr gulkthun Djonnha ŋunhi ḻiya-ḻupmaranhamirriny yolŋuny dhiyaŋun bala, bala rulwaŋdhurrnydja ŋanya muḻkurrnydja bilkpilklila banikin'lilnydja, bala nhe dhu gurrupandja ŋarrakala,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ga ŋunhi ŋayi ŋuriŋiyi buŋgaway balanyawuyyiny ŋäkul, bala yan ŋayi mirithinan galŋa-miḏikinany ga ḻiya-ŋarrtjunminan manapar. Yurr yakan ŋayi gan ŋunhi djälthinany ŋayi balaŋ dhawuny' nhanŋuwuy ŋayi bakmaranha nhanukal, bili ŋayi ŋunhi dhawu'-nhirrparnydja ŋanya buthurumaran dharrwawalnha yolŋuwalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bala yan ŋayi ŋunhi buŋgawany dhäruk-gurrupanminan miriŋuwalal yolŋuwal gupawnha gulkthunaraw nhanŋuny Djonguny. ");
INSERT INTO djr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Bala ŋayiny ŋunhi djämamirrnydja yolŋu dhunupan yan marrtjinany dharruŋgulila, ŋunhi wanhal gan Djon nhinan, bala yan ŋayi dhunupan ŋanya gupany gulkthurra. Bala ŋayi ŋunhi muḻkurrnydja märraŋala Djonnhany bilkpilklilnydja banikin' rulwaŋdhurr bala gäŋalnydja ga gurruparnydja ŋurikalyin yothuwala miyalkkala. Ga ŋayiny ŋunhi ŋuriŋiyiny miyalkthuny yothuynydja gurrupar ŋäṉḏi'mirriŋuwala nhanukalaŋuwal. ");
INSERT INTO djr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ga ŋunhi walal Djongal ḻundu'mirriŋuy walal dhäwuny ŋäkul nhanukalaŋuwuy, bala walal yan marrtjinan ga märraŋala walal nhanŋu rumbalnydja bala yan molulila märrkitjkuŋal. ");
INSERT INTO djr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yo, ga ŋunhi walal Garraywu djuy'yunawuynydja mala roŋiyinany beŋurnydja ŋunhi walal gan marrtjin buku-ḻiw'maraŋal wäŋakurr malaŋuwurr, balany Djesuwalnydja, bala walal dhäwun gan lakaraŋal nhanŋu, ŋunhi nhaltjarr walal gan djäma ga nhä walal gan lakaraŋal marŋgikuŋal yolŋu'-yulŋuny. ");
INSERT INTO djr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ga dharrwan gan ŋunhi yolŋuny walal marrtjinany balayiny guwatjmarnydja walalany, ga bäyŋun nhanŋuny Djesuwnydja ga ḻundu'mirriŋuwnydja nhanukalaŋaw walu ŋathawnydja ḻukanharaw. Bala ŋayi Djesuynydja waŋanan garr'yurra ḻundu'mirriŋunhany mala nhanŋuwuy ŋayi bitjarra, “Go ŋathil limurr wäŋgam ŋula wanhawal wäŋalil, märr limurr dhu ŋathil ŋula ŋir'yunmirr.” ");
INSERT INTO djr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bala walal dhunupan yan marrtjinan marthaŋayyun buḏapthurra gänaŋulila wäŋalil märr walal dhu ga gäna nhina. ");
INSERT INTO djr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ga walalnydja gan ŋunhi yolŋu'-yulŋuynydja nhäŋala goyurrnha marthaŋaynhan nhälil ŋayi ŋunhi marrtjin buḏapthurr, bala walal yan marŋgithinan ŋunhi nhälil walal gan marrtjin. Bala walal ŋunhi yolŋuny walal dhunupan wäŋgaŋala buku-ḏaw'yurra, ḻiw'yurra ŋurikiyiny guḻunguny Galalipuywuny, ga walalnha ŋunhi ŋurruŋuny bunan ŋunhiliyiny wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ga ŋunhi ŋayi Djesu dhawaṯthurrnydja ga wapthurrnydja gan marthaŋayŋurnydja, bala ŋayi nhäŋala yolŋunhany walalany walal gan galkurra nhanŋu, yurr dharrwan ŋunhi mirithirra dhika. Ga nhäŋalnydja ŋayi ŋunhi walalany, bala yan ŋayi dhunupan walalaŋ warwuyurra mirithinan, bili walal ŋunhi balanya nhakun bimbi mala djäkamiriwŋur. Bala ŋayi gan dhäwun walalaŋ lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ga ŋuriŋiyi bili yan waluy yurr milmitjpan, bala walalnydja ŋunhi malthunamirrnydja mala waŋanan nhanŋu Djesuwnydja bitjarra, “Way milmitjpan dhuwal wäŋany, ga wäŋany dhuwal ŋayilpi'yinan. ");
INSERT INTO djr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Djuy'yurra walalany dhuwandja yolŋu'-yulŋunhany wäŋalila, märr walal dhu marrtji ga ŋula ŋatha walalaŋguwuy märra'-marram ḻukanharaw muka.” ");
INSERT INTO djr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ga ŋayiny Djesuny waŋan bitjarr, “Nhuma walalany dhu maranhu-gurrupan.” Ga walalnydja waŋan dhä-birrka'yurr manapar ŋanya bitjarr, “Nheny ga dhuwal djälthirr, napurr dhu marrtji ga 200-tja ŋaraka rrupiya djalkthun ŋathawnha yan märranharaw, märr napurr dhu dhuwalawurrunhan yolŋunhan walalany maranhu-gurrupan?” ");
INSERT INTO djr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ga ŋayiny Djesuynydja waŋan walalany bitjarr, “Gatjuy ŋathil walal maḻŋ'maraŋ nhämunha' ga dhikayi nhumany ŋatha ŋula ŋayatham.” Bala walal marrtjinan ga maḻŋ'maraŋalnydja walal bala lakaraŋala nhanukal bitjarra, “Goŋ-waŋgany dhuwal dämbany yurr yumurrku', ga guyany märrma'.” ");
INSERT INTO djr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bala ŋayi Djesuynydja waŋanan ḻundu'mirriŋunhany mala nhanŋuwuy ŋayi bitjarra, “Gatjuy yolŋunhany walalany waŋin walal dhu nhinan malaŋur malaŋur.” ");
INSERT INTO djr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bala marrtjin ŋunhi yolŋu'-yulŋuny nhinanan malaŋur, malaŋur, malaŋur. Wiripu malaŋur nhinan 100 yolŋu'-yulŋu, ga wiripuny ga 50 bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bala ŋayi Djesuynydja märraŋala ŋunhi goŋ-waŋganydja dämba mala yumurrkuny ga guyany maṉḏany, bala ŋayi buku-garrwarthinan djiwarr'lila, bala buku-wurrpara God-Waŋarrnhan ŋurikiyin ŋathawnha. Bala ŋayi bak-bakmaraŋala ŋunhi ŋathany mala dämbany bala gurrupara malthunamirriwal mala nhanukalaŋuwal, ga walalnydja märraŋal bala marrtjin yolŋunhan walalany gurrupar. Ga bitjarryi bili ŋayi guyany märraŋal ga gandarr-wulkmaraŋal bala marrtjin gurrupara yolŋu'-yulŋuwala mala. ");
INSERT INTO djr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ga bukmakthun marrtjin ŋunhi yolŋuynydja walal ḻukanany ŋathany, ga yan bili-i-i ga gana'yin yan walal bukmak. ");
INSERT INTO djr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bala walalnydja marrtjin ŋunhi ḻundu'mirriŋuynydja mala nhanukal Djesuwalnydja wapmaraŋala bäythinyawuynydja ŋatha mala ga guyany. Ga ŋuriŋiyiny ŋunhi bäythinyawuyyuny ŋathay bathiny mala dhaŋaŋguŋal 12-nha. ");
INSERT INTO djr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ga dharrwan ŋunhi mirithirra yolŋuny walal ḏirramuwurrnydja 5,000-nha malany bukmaktja. ");
INSERT INTO djr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ga dhurrwaraŋur beŋuryiny bala ŋayi Djesuynydja waŋanan ŋunhi malthunamirrinhany mala nhanŋuwuy ŋayi bitjarra, “Gatjuy nhumany marrtjin marthaŋayyun ŋunha gali'lila Bithdjaydalila,” bitjarr. Bala walalnydja dhunupan yan marrtjinan, ga ŋayipiny Djesuny ŋurr'yurra ŋunhiliyin banydjin, djuy'yurra ŋayi gan yolŋunhan walalany roŋanmaraŋala wäŋalila. ");
INSERT INTO djr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ga dhurrwaraŋur beŋuryiny, bala ŋayi marrtjinan balan bukumirrilila wäŋalila, märr ŋayi dhu ga bukumirriyam gänan. ");
INSERT INTO djr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ga ŋunhi marrtjin munhawuyinany wäŋany, ga walalnydja ŋunhi ḻundu'mirriŋuny mala nhanŋu balanyamirriy ŋunhal yan banydji gapuŋur yurr dhulmuŋura, ga ŋayiny Djesuny gan gänan nhinan ŋunhalnydja ḏiltjiŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ga nhäŋal ŋayi walalany Djesuy ḻundu'mirriŋunhany mala nhanŋuwuy ŋayi ŋunhawal yan banydji gapulil ḻiw'yurra walal gan mirithinan dhika, bili yindiynha walalany gan ŋunhi wataynydja gulmaraŋal. Yo manymak, ḻiw'yurrnydja walal gan ŋunhi ga galki djaḏaw'yunaraynha, bala ŋayiny Djesuny walalaŋ bunanan, yurr marrtjinany ŋayi gan ŋunhi gapukurra ŋapakurra. Ga ŋunhi ŋayi marrtjin galkithinany, ga galki balaŋ ŋayi walalany ḻäy-djuḻkmaranhan. ");
INSERT INTO djr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ga ŋunhi walal ḻundu'mirriŋuynydja mala nhanukal nhäŋalnydja ŋanya, ŋayi gan marrtjin räli gapukurrnydja, bala walal guyaŋanany yanbi ŋayi ŋunhi mokuynha, bala walal yatjunminan, bili walal ŋunhi nhäŋalnydja ŋanya bukmakthun, ");
INSERT INTO djr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","bala walal barrarinany mirithinan yan. Ga dhunupan ŋayi Djesuny waŋanan walalaŋgal bitjarrnha, “Way, ŋayaŋu-ḏälthi walal. Ŋarra dhuwal! Yaka walal barrari!” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bala yan ŋayi wapthurra ŋunhiwiliyin marthaŋaylila walalaŋgala, bala yan dhunupan ŋunhi watany gulyurra galkirrinyaŋurnydja. Ga walalnydja ŋunhi ḻundu'mirriŋuny mala nhanŋu märr-dhumbal'yurra. ");
INSERT INTO djr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Muḻkurrnydja walalaŋ ŋunhi gungaŋala ga yakan walal ŋunhi yuwalkkunhany dharaŋana mayaliny' ŋurikiwuyyiny ŋunhi ŋathaypuynydja. ");
INSERT INTO djr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Manymak buḏapthurra walal ŋurikiyiny guḻunguny, ga dhawaṯthurrnydja walal wäŋaŋur yäkuŋur Ginitjarathan, bala walal baḻaŋuny ŋurrkaŋala, mata'maraŋalnydja marthaŋaynydja bay'nha. ");
INSERT INTO djr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ga ŋunhi walal dhawaṯthurrnydja marthaŋayŋurnydja, bala dhunupan walalnydja ŋunhi yolŋu'-yulŋuynydja ŋunhiliyiny wäŋaŋur nhäŋala Djesunhany dharaŋara, ");
INSERT INTO djr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","bala walal marrtjin gäŋa'-gaŋala rerrimirrinhan mala nhanukal miṉdhalamirrinhan mala. ");
INSERT INTO djr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ga bitjarra bili gan ŋunhi yolŋuynydja walal ŋanya ŋurru-ḻiw'-ḻiwmaraŋala, nhäkurr ŋayi gan marrtjin, walalnydja ŋunhiliyi yolŋuny walal, gäŋal marrtjin wiripuny yolŋuny rerrimirriny ḏukmaranharaw nhanukal. Ga waŋan walal gan ŋanya walal balaŋ ganha ŋunhi rerrimirriynydja yolŋuy walal girrin yan nhanŋu ŋayathanha yurr djinmir' yan. Ga bukmakthu ŋunhi yolthu walal nhanŋu gan girri' nhanukalaŋumirr ŋayathaŋal walalnydja gan yan ḏukthurra. ");
INSERT INTO djr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ga balanyamirriynydja waluy yolŋu walal ŋunhi Baratji mala ga märr ḻurrkun' Rom-marŋgikunhamirr mala wäŋa Djurutjalambuy mala, marrtjin walal balayi guwatjmar ŋanya Djesuny. ");
INSERT INTO djr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bala walal nhäŋala ŋunhi Djesuw malthunamirrinhany mala walal gan ŋunhi ŋathany ḻukan, goŋdhuny rurrwuyunamiriwyun. ");
INSERT INTO djr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yo, walalnydja ŋunhi Baratji mala ga bukmak yan Djuw mala, ŋurruŋuny ŋathil walal ŋuli goŋ maṉḏany rurrwuyunminya ga yorrnha walal ŋuli ŋunhi ŋathany ḻukanha. Bili ŋunhiyiny rom ŋäthiliŋu ŋurrŋgitj walal gan marŋgithin beŋur ŋunhi ŋaḻpaḻmirriwuŋ walalaŋgiyingalaŋawuŋ. ");
INSERT INTO djr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ga ŋunhi walal ŋuli ŋatha ŋula märranha ŋunhal buku-djuḻkmaranhamirriŋur wäŋaŋur, ga ŋurruŋuny walal ŋuli ḏarrtjalkkunhaminya walalanhawuynha walal, ga yorrnha walal ŋuli ŋunhi ŋathany ḻukanha. Ga dharrwa muka mirithirr walal gan ŋunhi romdja malany ŋayathaŋal, balanya nhakun walal ŋuli banikin' rurrwuyunna ŋunhi walal ŋuli gapu wo ŋula nhä ŋuḻkthunna ŋuruŋiyi, ga bathanawuy banikin', ga ḻupthunawuy banikin' mala walal ŋuli ḏarrtjalkkunha ŋuliwitjanna bili yan romgurr wukiṉḏiwurr. ");
INSERT INTO djr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bala walal ŋunhi Baratjiynydja ga Rom-marŋgikunhamirriynydja mala dhä-birrka'yurra ŋanya Djesuny bitjarra, “Nhaku ŋuli ga dhuwal nhokalnydja malthunamirriy mala ŋunhiyiny rom mala yaka ŋayathul, ŋunhi walalaŋgal gan ŋaḻapaḻmirriy mala limurruŋgal marŋgi-wurrupar? Ga nhaku walal ŋuli ga ŋunhi ŋathany ḻuka goŋdhu-rurrwuyunamiriwyuny, bitjan nhakun ga ŋunha ŋurrŋgitj rom waŋa wukiṉḏi?” ");
INSERT INTO djr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ga ŋayiny Djesuny waŋany bitjarra, “Nhumany dhuwalawurrnydja yolŋu walal ḻiya-dharrwa mala. Dhunupa muka ŋunhi ŋuriŋiyiny yolŋuy yäkuy Yitjayaynydja gan lakaraŋal nhumalanhany baman'tja, ŋunhi ŋayi gan bitjarrnydja dhäruk ḻakaraŋal God-Waŋarrnhany gam', ‘Dhuwalawurrnydja ŋarraku ŋuli ga dhärukthu yan waŋganydhu wokthun, bili ŋayaŋuny ŋunha walalaŋ ben bala barrkun ŋarrakalaŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bäyŋun walal ŋuli gi ŋunhi yuwalkkuŋuny ŋarrakuny buku-ŋal'yurr, bili walal ga ŋunha baṯ-bitjandja ŋayatham ŋunhiyin romdja malany ŋunhi yolŋuwuŋun guyaŋanhawuy, yanbi ŋunhiyiny God-Waŋarrwuŋun rom-gurrupanawuy.’” ");
INSERT INTO djr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Ga nhanŋuny nhuma ŋuli ŋunhi God-Waŋarrwuny dhäruk-nhirrpanminyawuy rom ŋurrkam gali'lila, ga ŋayathamany nhuma ŋuli ga ŋunhi baṯ-bitjandja ŋunhiyin yolŋuwuŋun walalaŋguŋ marŋgikunhawuynydja ga lakaranhawuynydja.” ");
INSERT INTO djr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ga bulu ŋayi Djesu waŋan bitjarr, “Nhumany ŋuli ga ŋunhi bil'-bilmaram God-Waŋarrwuny dhäruk-gurrupanminyawuy, bala nhuma ŋuli ga ŋunhi lakaramany djarrpi'kuman wiripuŋuyaman, märr nhuma dhu ga ŋunhi malthundja ŋurikiyin bili yan nhumalaŋgiyingalaŋawnha yan marŋgi-wurrupanawuywuny. ");
INSERT INTO djr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bili ŋunhi God-Waŋarryuny rom-lakaraŋal Mawtjitjkalnydja bitjarr muka gam', ‘Nhumany dhu ga ŋunhi märr-ŋal'yun nhumalaŋgiyingalaŋaw bäpa'mirriŋuwnydja walalaŋ ga ŋäṉḏi'mirriŋuwnydja walalaŋ’, ga bulu ŋayi lakaraŋal bitjarr, ‘Ŋuli dhu ga ŋunhi ŋula yolthu yolŋuy gumurr-dhar'yun ŋäṉḏi'mirriŋunhany nhanŋuwuy nhä mak bäpa'mirriŋunhany, ŋunhiyinhany yolŋuny nhuma dhu buman rakunyguman.’ Yo, bitjandhin ga ŋunhi God-Waŋarrwalnydja romdhu lakaram. ");
INSERT INTO djr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yurr nhumany ŋuli ga ŋunhi lakaramany bitjanna gam', ‘Ŋuli dhu ŋula yol yolŋu waŋa nhanukiyingalaŋaw ŋayi ŋäṉḏi'mirriŋuwnydja nhä mak bäpa'mirriŋuwnydja bitjandja gam', “Ŋarra balaŋ nhuna dhuwal gurrupanna muka ŋula nhä mala ŋarrakuŋ, guŋga'yunaraw nhuŋu, yurr dhuwandja dhuyun nhakun. Ŋarrany barpuru dhuwal bilin wäwunguman God-Waŋarrnhan.” ’ ");
INSERT INTO djr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nhumany ŋuli ga marŋgikumany ŋanya balanyarawyin waŋanharaw, ga bulu nhuma ga gulmaram ŋanya djägaŋur ŋayi dhu ga yakan djäga ŋäṉḏi'mirriŋuwnydja ga bäpa'mirriŋuwnydja.” ");
INSERT INTO djr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","“Ga bitjandhin nhuma ŋuli ga ŋunhi God-Waŋarrwuny dhäruk rommiriwnha lakaram, bala nhuma ŋuli ga nhumalaŋguwuynha rom mala marŋgikumany yolŋunhany walalany, märr walalnydja dhu marrtji marŋgikum walalaŋguwuynhan walal djamarrkuḻiny'. Ga wiripuny nhuma ŋuli ga ŋunhi dharrwayyi djäma ŋula nhä malany yätjkurryi yan nhakun dhuwal malany.” Ga bitjarryin ŋayi gan ŋunhi Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ga dhäŋur beŋuryiny ŋayi Djesuynydja ḻuŋ'maraŋala ŋunhi yolŋu'-yulŋunhan, bala ŋayi walalany waŋanan bitjarra, “Ŋäkuny walal ŋarrany, ga dharaŋula yanan. ");
INSERT INTO djr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Yolŋuny dhu dhuwal yaka dhuwurr-yätjirr ŋula nhaliy ŋunhi ŋuli nhanukal dhurrwarakurr gärri, ŋany rom-yätjirrnydja ŋayi dhu yolŋuny ŋuriŋiyin bili yan ŋunhi nhä nhanukal ŋuli yätjkurr mala dhäruk dhurrwarakurr dhawaṯthun.” ");
INSERT INTO djr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ga dhäŋur beŋuryiny ŋunhi ŋayi Djesuy ganarrthaŋalnydja yolŋunhany walalany, bala ŋayi marrtjinan buṉbulila gärrin, ga walalnydja malthunamirriynydja mala nhanukal dhä-birrka'yurra ŋanya ŋurikin ŋunhi nhä ŋayi gan ŋuriŋiyi mayaliy' lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ga ŋayiny walalaŋ Djesuny buku-bakmaraŋal bitjarr, “Way! Muka bäyŋu yan nhuma gi dhuwal dharaŋulnydja, ŋunhi nhä ŋarra gan nhumalaŋgal lakaraŋal? Yolŋuny dhu dhuwal yaka dhuwurr-yätjirr ŋuriŋiyiny ŋunhi ŋayi dhu galkan ŋula nhä mala. ");
INSERT INTO djr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bili ŋunhi ŋuli yolŋuy ŋathany ḻuka, ga gärriny ŋuli ŋunhi ŋathany balan guḻunlila, bala beŋuryiny ŋayi ŋuli dhawaṯthunna yan; yaka ŋayi ŋuli ŋunhi ŋatha balany ŋayaŋulilnydja marrtji.” Yo, Ga bitjarryiny ŋayi gan ŋunhi Djesuy lakaraŋal, bili ŋathany mala dhuwal bukmak yan manymak ḻukanharaw. ");
INSERT INTO djr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ga bulu ŋayi Djesu waŋan bitjarr gam', “Yolŋuny dhu dhuwal ŋayaŋu-yätjirr ŋuriŋin bili yan ŋunhi nhä mala ŋuli ga dhawaṯthun nhanukal beŋur ŋayaŋuŋur. ");
INSERT INTO djr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Ga ŋuli dhu ga ŋunhi yolŋuy ŋayatham baṯ-bitjandja ŋayaŋuy nhanukiyingal ŋayi yätjkurrnydja mala, bala ŋayi ŋuli ga ŋunhi ŋuriŋiyiny yolŋuy guyaŋany ga djarrpi'kuman yan, ga djämany ŋayi ŋuli ga ŋunhi yätjkurrnha yan mala mirithirra romdja, balanyan nhakun dhuwanna mala gam', Manaŋirra ŋayi dhu djaw'yunna, ga ŋaramurryirra ga yolŋuwnha, bala ŋayi ŋuli marrtjiny bala yan buman murrkay'kuman ŋunhiyiny wiripunhany yolŋunhany. Ga bulu nhakun ŋayi ŋuli marramban' djäma. Yo, ga wiripuny ŋayi ŋuli ga nyäḻ'yunna lakaram ga djirri-waŋan dhu ga, ga bulu gupa-waŋany ŋunha wiripuwurrunhany yolŋuny walalany. Ga wiripuny ŋayi ŋuli ga wanaŋa-ḏumurruyirra ŋula nhakun malaŋuw, ga mel-ḏiy'yunna dhu ga wiripunhan yolŋuny mala, ga nyamir'yunna dhu ga, ga garrwarkunhamirra ŋayi dhu ga ŋanyapinya ŋayi, ga ḏalwurthirra ŋayi dhu ga. Dhuwanna mala ŋunhi yätjkurra yan mirithirra romdja mala ŋayi ŋuli ga djämany, bili yätjkurrnydja mala ga ŋorra ŋunhan ŋayaŋuŋura nhanukal. ");
INSERT INTO djr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Yo, bukmak dhuwaliyi yätjkurrnydja mala ŋuli ga dhawaṯthun yolŋuwala ŋayaŋuŋurnydja, ga dhiyaŋiyin mala ŋayi ŋuli ga ŋunhi rom yätjirrnydja,” bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ga beŋuryiny dhurrwaraŋur Djesuny marrtjinan balan ŋunhi wäŋalil galki Däya wäŋa yäku, ga ŋunhiliyin ŋayi gan nhinanany, bili yaka ŋayi djälthinya yolŋu'-yulŋuw mala walal dhu marŋgithirr nhanŋu ŋunhi ŋayiny ŋunhiliyin gan wäŋaŋur nhinan. Yurr walalnydja ŋanya maḻŋ'maraŋal yan. ");
INSERT INTO djr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ga ŋunhiliyi wäŋaŋur waŋgany gan miyalk nhinan, yurr ŋayi ŋunhi Djan'tayil yolŋuny, wäŋa-ŋunhaŋuwuy Bänitjawuy, makarrpuy Djiriyawuy, ga yothuwal nhanukalaŋuwal miyalkkal gan nhinan yätjkurr birrimbirr. Ga ŋunhi ŋayi ŋäkul ŋuriŋiyi Djan'tayilyuny miyalkthu ŋanya Djesunhany, ŋunhi ŋayi gan nhinan ŋunhiliyiny wäŋaŋur, bala dhunupan ŋayi marrtjinan nhanukal bala ŋurrkanhaminan bun'kumu-djipthurra ḻukulila nhanukal. Bala ŋayi gan waŋanan mirithinan Djesunhany ŋurikiyiny wakinŋuwnydja birrimbirrwu dhawaṯmaranharaw beŋuryiny ŋunhi yothuwalnydja nhanukal. ");
INSERT INTO djr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yurr ŋayiny Djesuny waŋan buku-bakmaraŋal nhanŋu bitjarr, “Way, ŋurruŋuny ŋathil ŋarra dhu maranhu-gurrupan dhuwal ŋarrakuwuy ŋarra djamarrkuḻiny'. Yaka dhuwal manymak ŋunhi dhu yolŋuy märram djamarrkuḻiwny'tja ŋatha, bala dhu djalkthunna wuŋgangun,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ga ŋayiny ŋunhi miyalktja buku-bakmaraŋal bitjarr, “Yo Garray. Ga ŋunhi ŋuli djamarrkuḻiyny'tja ga ŋathany ḻuka, bala muṉguynydja ŋunhi ŋatha ŋuli marrtji ḻarryunna munatha'lila, ga ŋayiny ŋuli ŋunhi wuŋgandhuny ḻuka ŋunhiyin bäythinyawuynha ŋatha,” ga bitjarra ŋayi ŋunhi mulkuruny miyalk waŋan. ");
INSERT INTO djr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Bala ŋayiny Djesuny nhanukal waŋan bitjarra, “Dhiyaŋiyi nhokal dhärukthuny ŋarranhany ŋayaŋu-ŋamathaŋala. Gatjuy marrtjin. Bilin ŋayi ŋunhi wakinŋuynydja birrimbirryu ganarrthaŋala nhuŋu yothunhany.” ");
INSERT INTO djr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ga marrtjinany ŋayi ŋunhi miyalktja roŋiyinany wäŋalilnydja, nhäŋalnydja ŋayi ŋunhiyi yothunhany nhanŋuwuy ŋayi, ŋayi gan ŋorranany manymaknha, bilin ŋayi ŋunhi birrimbirrnydja waṉḏinan nhanukalaŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","32","Ga beŋuryiny ŋayi Djesuy ganarrthaŋala ŋunhiyiny wäŋa Däyany, bala ŋayi marrtjinan ŋulatjarr bala buku-ḏaw'yurr ga ŋunhal Djäydan, ga ḻäynha ŋayi djuḻkmaraŋal ŋunhi guḻundja ŋunhany Galalipuynydja, yurr balan ŋayi gan ŋunhi marrtjinany yindilila wäŋalil ŋarakalil Dikapulitjlila. Bala walalnydja ŋunhiliyiny yolŋu'-yulŋuynydja gäŋal Djesuwalnydja yolŋunhan buthurumiriwnhan ga dhärukmiriwnhan. Bala walal waŋanan nhanukal bitjarra, “Buku-djulŋi, ŋathil goŋ-ŋal'yurr dhiyakal yolŋuwal,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Bala ŋayiny Djesuynydja dhunupan yan garr'yurra ŋanya ŋunhiyiny yolŋunhany gänaŋulila beŋuryiny ŋunhi wiripuwurruŋgalnydja yolŋuwal walalaŋgal malaŋur. Ga goŋ ŋayi gulŋiyin buthurulil nhanukal ŋurikalyi yolŋuwal, ga bulu ŋayi goŋlil dhupthurr nhanukiyingal ŋayi, bala mam'maraŋal ŋäṉarrlila ŋurikalyin ḏirramuwala. ");
INSERT INTO djr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bala ŋayi beŋuryiny Djesuy dhupuŋala djiwarr'lila, bala yan ŋayi mirithinan ŋir'yurrnydja ŋorr'yurra manapar, bala waŋanan nhanukal bitjarra, “Yipatha,” ga bitjarr ŋayi ŋunhi mayaliny' waŋan, “Ma' ḻapthurra,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ga dhunupan ŋayi ŋunhi yolŋuny buthuruny ḻapthurra, bala ŋayi yan ŋäkula, ga mathany nhanŋu ŋunhi dhayaḻayinan, ga dhunupan ŋayi ŋunhi waŋanany manymakkuŋala. ");
INSERT INTO djr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bala ŋayi Djesuynydja waŋanan ŋunhi wiripuwurrunhany yolŋuny walalany bitjarra, “Yaka nhuma dhu lakaram dhuwalaŋuwuy wiripuwurruŋgalnydja yolŋu'-yulŋuwal,” bitjarr. Yurr walalnydja marrtjin ŋunhi yolŋuny walal mukthurra bala lakaranhaminan, gulkurun ŋayi gan walalany ŋunhi gulmaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ga walalnydja ŋunhi yolŋuynydja walal mirithinan yan ṉirr'yurra nhäŋalnydja bala walal gan waŋanhaminan bitjanminan, “Nhä dhuwal ŋayi ga latju'kumany djäma way. Dhuwandja ŋayi ga wiripuny ŋunhan ŋunhi dhärukmiriwnhan ga buthurumiriwnha yolŋuny walalany ḏukmaram.” Bitjarra walal gan ŋunhi lakaranhaminany. ");
INSERT INTO djr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Waŋganydhuny waluy walal bitjarryi bili dharrwayi yan dhika yolŋu walal ḻuŋ'thurr Djesuwal. Ga bäyŋun walal gan ŋunhi ŋula nhäny ŋathany mala gäŋal ḻukanharawnydja walalaŋguwuy. Bala ŋayi Djesuny wäthurra ŋurikiyiny malthunamirriwnydja mala nhanukalaŋaw bitjarra, ");
INSERT INTO djr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Wäy! Ŋayaŋu-wuyurra ŋarra dhuwal mirithinan dhiyakuny yolŋuwnydja walalaŋ. Wiyinŋumirra walal dhuwal ḻurrkun'nha walu malthundja ŋarraku. Bäyŋun walalaŋ dhuwal ŋula nhäny ŋathany maranhuny. ");
INSERT INTO djr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ŋuli ŋarra dhu walalany dhuwal djuy'yundja ŋoy-ŋathamiriwnhany walalany bala wäŋalilnydja mala walalaŋgiyingal, bala walalnydja dhu dhuwal ŋula gandarrŋurnydja yalŋgithirra mirithirra, bili wiripuny mala barpuru ga dhuwal marrtji barrkuŋura wäŋaŋur.” ");
INSERT INTO djr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ga walalnydja ŋunhi malthunamirrnydja mala nhanŋu waŋan bitjarra, “Wäy, nhän limurr dhu dhuwandja yolŋunhany walalany maranhu-gurrupan, dhiyalnydja barrakawukŋurnydja wäŋaŋur?” ");
INSERT INTO djr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ga ŋayiny walalany Djesuynydja dhä-birrka'yurr bitjarr, “Nhämunha' nhumany ga dhikayiny ŋatha ŋayatham?” Ga walalnydja nhanukal lakaraŋal bitjarr, “Djabin yan dhuwal ŋathany mala dämbany.” ");
INSERT INTO djr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bala ŋayi Djesuynydja waŋanan walalany nhinanhamaraŋala. Ga märraŋal ŋayi Djesuy ŋunhiyiny ŋathany mala bala buku-wurrpara God-Waŋarrnhan ŋurikiyi, bala bak-bakmaraŋala ŋathany bala gurru'-gurruparnydja marrtjin malthunamirriwala mala nhanukalaŋuwal, bala walalnydja marrtjin gurrupar yolŋunhan walalany. ");
INSERT INTO djr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ga wiripuny walal gan guya mala yumurrku ŋayathaŋal, ga bitjarryi bili ŋayi Djesuy buku-wurrpar ŋurikiyiny guyawnydja mala, ga gurru'-gurrupar ḻundu'mirriŋuwala mala nhanukalaŋuwal, bala walalnydja marrtjin gurrupar ŋunha yolŋunhan walalany. ");
INSERT INTO djr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Bala walal marrtjin ḻukanan ŋathany, ga bukmaknha walal ŋunhi maranhuyinany. Bala marrtjin nhanukal ḻundu'mirriŋuynydja mala bäythinyawuynydja ŋatha wapmaraŋala, ga dhaŋaŋguŋalnydja walal ŋunhi 7-nha bathiny mala. Ga ŋula nhämunha' ŋunhi yolŋuny walal 4,000-nha bukmaktja. Ga dhurrwaraŋur beŋuryiny ŋathaŋurnydja ḻukanhaŋur, bala ŋayi gan Djesuynydja djuy'yurra yolŋunhany walalany wäŋalila malaŋulil. ");
INSERT INTO djr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ga dhurrwaraŋur beŋuryiny bala ŋayi Djesuny ga malthunamirrnydja mala nhanŋu wapthurra gan marthaŋaylila, bala yan walal marrtjinan wiripulila wäŋalil yäkulil Dalmanathalila. ");
INSERT INTO djr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ga ŋunhiliyiny wäŋaŋur yolŋu walal nhanŋu bunan Baratji mala, bala walal gan waŋanan nhanŋu dhä-ḏälthinan ŋoy-marraŋala ŋanya. Ga waŋanany walal gan ŋunhi birrka'yurr manapar ŋanya bitjarr, “Way nhämirr nhe dhu djäma ŋula nhä yindi mirithirr rom ŋurukuwuy djiwarr'wuy, märr napurr dhu nhäma, ga märr-yuwalkthirr nhuna.” ");
INSERT INTO djr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bala ŋayiny Djesuny mirithinan yan dhika ŋorr'yurrnydja galŋa-miḏikinan manapar, ga waŋanany ŋayi bitjarra, “Nhaku nhumany ŋuli ga dhuwal djälthirr nhänharaw, ŋoy-wilwilyunamirriwnydja romgu? Märr-yuwalk ŋarra nhumalaŋ ga dhuwal lakaramany, bäyŋu yan ŋarra nhumalaŋ dhu ŋula nhä yindi djäma yän nhänharawnydja nhumalaŋ.” ");
INSERT INTO djr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bala yan ŋayi Djesuynydja ganarrthaŋala ŋunhiyiny wäŋa, wapthurrnydja marthaŋaylilnydja, bala marrtjinan buḏapthurra wiripuŋulila gali'lil wäŋalil. ");
INSERT INTO djr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yo, marrtjiny walal ŋunhi buḏapthunna, yurr walalnydja ŋunhi malthunamirriynydja mala nhanukal meṉguman dharrwawnydja ŋathaw gänharaw, ga waŋganynha marrtji ŋunhi ŋathany ŋorra dämban ŋunhiliyiny marthaŋayŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bala ŋayi ŋunhi balanyamirriynydja Djesuynydja waŋanan djägakuŋala walalany bitjarra, “Marŋgi muka nhuma dhuwal ŋurikiyiny ŋunhi ḏulul'maranhawuywuny, ŋunhi ŋuli ḏulul'maram dämbany. Balanyayin ŋunhi marŋgikunhawuy Baratjiwnydja mala ga Yaritkuny nhakun ŋunhiyi ḏulul'maranhawuy ŋathapuy, ga nhumany dhu djägan ŋurikiny.” Ga bitjarryin ŋayi marrtjin ŋunhi lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bala walalnydja marrtjin waŋanhaminan dhä-birrka'yunminan bitjanminan, “Dhuwandja ŋayi mak bitjarrnydja waŋan bili limurr dhuwal ŋula bäyŋu dharrwany ŋatha märraŋal.” ");
INSERT INTO djr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ga ŋayiny ŋunhi Djesuny marŋgithin yan walalaŋ nhaltjarr walal marrtji waŋanhamin, bala ŋayi walalany dhä-birrka'yurra bitjarra, “Nhaku nhuma ga dhuwal waŋanhamirrnydja? Yaka yan nhuma gi dhuwal dharaŋulnydja muka? Nhä nhumalaŋ dhuwal muḻkurrnydja dhumuk yan? ");
INSERT INTO djr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Maŋutjimirr mala nhuma dhuwal yulŋuny, ga wanha balaŋ nhuma gi nhäŋun. Ga buthurumirr mala nhuma dhuwal yulŋuny ga wanha balaŋ nhuma gi dhuwal ŋäkun. Yaka yan nhuma gi dhuwal guyaŋiny ŋunhi, ");
INSERT INTO djr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","nhämunharay bathiy nhuma bäythinyawuyyu ŋathay dhaŋaŋgum ŋunhi ŋarra ḏaw'ṯawmaramany goŋ-waŋganydja ŋatha, ŋunhi 5,000-guny yolŋuw?” Ga walalnydja waŋan bitjarra. “Ŋe! 12 muka ŋunhi bathiny,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ga bulu ŋayi dhä-birrka'yurr walalany bitjarr, “Ŋunhi ŋarra 7-dhuny yan ŋathay maranhu-wurrupan 4,000-nhany yolŋuny walalany, ga nhämunha' ŋunhi bäythinyawuyyuny ŋathay bathiny nhuma dhaŋaŋgum?” Ga walalnydja buku-bakmaram nhanŋu bitjan, “7-dhu bathiy.” ");
INSERT INTO djr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Bala ŋayi Djesuynydja waŋanan walalany bitjarra, “Yaka yan nhuma gi dhuwal dharaŋulnydja muka?” ");
INSERT INTO djr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Manymak, marrtjinany walal gan ŋunhi Djesuny ga ḻundu'mirriŋuny mala nhanŋu ga bunan walal Bithdjaydan wäŋaŋur yäkuŋur. Ga ŋunhiliyiny wäŋaŋur yolŋuy walal gäŋal bambaynha yolŋuny nhanukal Djesuwal, bala walal waŋanan ŋanya bitjarra, “Buku-djulŋi ŋathil goŋ-ŋal'yurr dhiyakal bambaywal yolŋuwal.” ");
INSERT INTO djr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Bala ŋayi Djesuynydja goŋnha ŋanya ŋayathaŋal ŋunhiyiny bambaynhany yolŋuny bala garr'yurra ŋanya gänaŋulila. Ga dhunupan yan ŋayi Djesuynydja dhupthurra mellila nhanukal, bala goŋ-ŋal'yurra nhanukala, bala ŋayi waŋanan dhä-birrka'yurra ŋanya bitjarra, “Ŋula nhe ga nhäma ŋula nhäny mala?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ga ŋayiny ŋunhiyiny yolŋuny maŋutji-garrwarthin bala bitjarra waŋan, “Ŋe, Nhäman ŋarra ga dhuwal yolŋunhany walalany walal ga marrtji'-marrtji, yurr buwayak yan, nhakun ga dharpa mala wuŋi-wuŋiḻi'yun.” ");
INSERT INTO djr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ga bulu ŋayi Djesu goŋ-ŋal'yurr ŋurikalyi bambaywal yolŋuwal, bala yan ŋayi ŋunhi maŋutjiny mirithinan ḻapthurr, ga buluny ŋayi ŋuriŋiyi yolŋuy nhäŋal manymakkuŋala. ");
INSERT INTO djr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bala ŋayi Djesuynydja waŋanan ŋanya djuy'yurra wäŋalila bitjarra, “Marrtjiny nhe dhu dhunupan wäŋalila nhokiyingal nhe, yakan nhe dhu balany bitjandja yolŋu dharrwamirrililnydja wäŋalil marrtji.” ");
INSERT INTO djr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ga beŋuryiny dhurrwaraŋur walalnydja ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu marrtjin balan ŋunhi wäŋalil galki Djitjariya-Bilipaylila. Ga ŋunhi walal marrtjin bala wäŋgaŋalnydja dhukarr-ŋuparnydja, bala ŋayi Djesuynydja walalany dhä-birrka'yurra bitjarra, “Wäy yolnhan dhika ŋuli ga ŋunhi yolŋuynydja walal lakaram yanbi ŋarrany yolnha?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ga walalnydja buku-bakmaraŋal nhanŋu bitjarr, “Wiripuwurruynydja ŋuli ga dhuwal yolŋuy walal nhuna lakaram yanbi nhe dhuwal Djonnha ŋunhi Ḻiya-ḻupmaranhamirra yolŋu. Ga wiripuwurruy nhuna ŋuli ga lakaram yanbi nhe dhuwal Yilaydjan, ga wiripuwurruynydja nhuna ŋuli ga lakaram yanbi nhe dhuwal ŋunhin yolŋu djawarrkmirra baman'ŋuwuynha.” ");
INSERT INTO djr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ga bulu ŋayi walalany waŋan dhä-birrka'yurr bitjarra, “Ga nhaltjan nhumany ŋuli ga ŋunhi guyaŋa, yanbi yol dhuwal ŋarrany yolŋu?” Ga ŋayiny Betany buku-bakmaraŋal nhanŋu bitjarra, “Nheny dhuwal ŋunhiyin yolŋu Maŋutji-dhunupayanhawuynha.” ");
INSERT INTO djr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bala ŋayi Djesuynydja dhä-mukmaraŋala walalany märr walal dhu yakan yan lakaram ŋula yolkuny yolŋuw nhanukalaŋuwuynydja. ");
INSERT INTO djr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bala ŋayi Djesuny lakaranhaminan walalaŋgal bitjanminan, “Ŋayiny dhu dhuwal Yolŋuny Gäthu'mirriŋu mirithirra yan dhaŋga-ḏirryundja ŋunhi ŋula nhaliyinydja malaŋuy romdhu. Ga walalnydja dhu ŋunhi ŋaḻapaḻmirriynydja mala ga ŋurru-warryunayŋuynydja mala ga ŋurruŋu-djirrikaymirriynydja mala ga rom-marŋgikunhamirriynydja mala ŋanya ḻikandhu-ŋurrkaman, bala walal ŋanya dhu ŋunhi goŋ-gurrupanna bunharawnha murrkay'kunharawnha. Yurr ḻurrkun' waluny dhu ŋunhi djuḻkthurr bala ŋayi dhu ŋunhi walŋathin beŋurnydja ŋunhi dhiŋganhaŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yo lakaraŋalnydja ŋayi gan ŋunhi bitjarryiny dhawaṯmaraŋala warraŋulkuŋala yan. Bala ŋayiny Betaynydja Djesunhany märraŋala galkikuŋala nhanukiyingala ŋayi, bala ŋayi dhärukthuny ḏälyun waŋanany nhanŋu bitjarra, “Yaka gi biyakiyi waŋi.” ");
INSERT INTO djr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bala ŋayi Djesuny bilyurra bala marrtjin nhäŋala ŋunhi malthunamirrinhan mala nhanŋuwuy ŋayi, bala ŋayi waŋanan Betawnydja bitjarra, “Way nhe Djaytin, gatjuy waṉḏi ŋarrakalaŋaŋur.” Ga bulu ŋayi waŋan nhanukal Betawal bitjarr, “Guyaŋanhawuynydja nhokuŋ dhuwali yakan God-Waŋarrwuŋuny gurrupanawuy, ŋany yolŋuwuŋun.” ");
INSERT INTO djr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bala ŋayi Djesuynydja ḻuŋ'maraŋala wiripuwurrunhany yolŋuny walalany ga malthunamirriny mala nhanŋuwuy galkikuŋala nhanukiyingala ŋayi, bala ŋayi waŋanan walalaŋ bitjarra, “Ŋuli nhe dhu ŋula yol yolŋu djälthirr ŋarrakuny malthunaraw, nheny dhu monhamirra nhunapinya nhe. Ŋunhiyiny nhakun nhe dhu ganarrthaman yan ŋula nhäny mala nhuŋuwuy nhe, ga ḻaw'maramany nhe dhu ŋunhin dharpa mälakmaranhawuynha nhuŋuwuy nhe bala dhu malthunna ŋarrakun. ");
INSERT INTO djr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ga ŋuli nhe dhu ŋula yol waŋa bitjandja, ‘Ŋarrany ga dhuwal djälthirr walŋawnha yan nhinanharaw,’ bala ŋayiny dhu ŋunhiyiny yolŋu dhiŋgaman yan. Ga ŋuli ŋayi dhu ŋula yol waŋa bitjandja, ‘Ŋarrany dhu dhuwal dhiŋgam yan Djesuwnydja ga dhärukkuny nhanukalaŋaw,’ ŋunhiyin dhu ŋunhi yolŋu walŋathirrnydja. ");
INSERT INTO djr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ga ŋuli ŋayi dhu marrtji ŋula yolthu yolŋuy ḻuŋ'maramany buku-mangumany nhanukiyingallilyamany ŋayi ŋula nhä malany bukmak dhuwalaŋuwuynydja ŋunhi munatha'wuynydja, bala ŋayi dhu ŋunhi walŋany nhanŋuwuy ŋayi baḏatjunna, ga wiripuny mala ŋayi dhu ga ŋunhi ŋula nhä malany ŋayatham yan baḏak? ");
INSERT INTO djr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ŋuli dhu ŋunhi ŋula yolku yolŋuw walŋa buwayakthirrnydja, ga nhän ŋayi dhu ŋunhi ŋula gurrupandja, märr ŋayi dhu buluyi roŋanmaramdhi märram ŋunhiyi walŋany nhanŋuwuy ŋayi. ");
INSERT INTO djr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yo, yakan walal goriny ŋarrakalnydja nhakun yäku-lakaranharay, ga dhäwuy ŋarrakalaŋawuyyuny, dhiyakurruwurruŋgalnydja yolŋuwal walalaŋgal ŋunhi walal ga wawu yan nhina, yätjkurra yan ga djäma rom malany mirithirra ga milnyaŋ'mirra. Ga ŋayiny dhu ŋunhi Yolŋuny Gäthu'mirriŋu biyakiyi bili yan gori nhumalaŋguny ŋunhi ŋayi dhu roŋiyiny räliny beŋurnydja djiwarr'ŋurnydja nhanukalaŋuwalnydja Bäpa'mirriŋuwal djeŋarray', ga God-Waŋarrwalnydja dharrpalwalnydja dhäwu-gänhamirriwal walalaŋgal,” bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ga buluyi ŋayi Djesu waŋan walalaŋ bitjarr, “Märr-yuwalk ŋarra ga dhuwal nhumalaŋ lakaramany. Wiripuny nhuma, ŋunhi nhuma ga dhärra dhuwal dhiyal malaŋur, yorrnha nhuma dhu dhiŋguŋuny, nhumany ŋathil dhu boŋguŋ nhäŋu God-Waŋarrwu Rom ŋayi dhu yarrupthurr ganydjarrmirr.” ");
INSERT INTO djr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ga 6 walu djuḻkthurr, bala ŋayi Djesuynydja garr'yurra nhanŋuwuy ŋayi ŋunhi ḻurrkun'nhany ḻundu'mirriŋuny, Betanhany ga Djayimnhany ga Djonnhany, bala walalany ŋayi maŋutji-warryurra marrtjinan bukulila mirithirra dhiŋgilila. Ga ŋunhalnydja ŋunhi bukuŋurnydja bala nhanŋu Djesuw rumbalnydja wiripuŋuyinan dhika latju'yinan maŋutjiŋurnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ga girriny' nhanŋu ŋunhi bitjarryi bili yan miḻŋ'-miḻŋdhurr watharrthinan dhika mirithinan, djuḻkmaraman ga ŋula yolkuŋ yolŋuwuŋ djämapuy watharrkunhawuy dhiyal ŋunhi munatha'ŋur wäŋaŋur ŋarakaŋur. ");
INSERT INTO djr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ga balanyamirriyyi bili yan bala maṉḏany märrmany' yolŋu maṉḏa Yilaydjany ga Mawtjitjtja maḻŋ'thurra ŋunhiliyiny walalaŋgal, bala maṉḏa gan waŋanan nhanukala Djesuwala. ");
INSERT INTO djr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bala ŋayi Betany waŋanan Djesuwalnydja bitjarra, “Way Marŋgikunhamirr! Nhän dhuwandja manymaknha mirithirra maḻŋ'thurr napurruŋ muka. Ŋula balaŋ muka napurr dhu djäma ḻurrkun' warraw', nhumalaŋ, waŋganydja nhakun nhuŋuwuy, ga waŋganydja Mawtjitjku, ga waŋganydja Yilaydjaw.” ");
INSERT INTO djr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yurr ŋayiny ŋunhi Betany yaka marŋgi nhaltjarr ŋayi gan ŋunhi waŋan, bili ŋayiny ŋunhi, ga wiripuny maṉḏa ḻundu'mirriŋu maṉḏa mirithinan yan dhika barrarinany. ");
INSERT INTO djr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bala ŋayiny dhunupan molnydja maŋan maḻŋ'thurra bala yan dhurrthurryurra walalany. Ga beŋuryiny ŋunhi maŋanŋurnydja rirrakaynydja dhawaṯthurr waŋanany gan bitjarra, “Dhuwaliyin ŋunhi ŋarrakuwuynydja Gäthu'mirriŋu, marrkapmirrnydja. Buthuru-bitjurrnydja walal gi nhanŋuwuynha yan.” Ga bitjarra ŋayi gan ŋunhi rirrakaynydja waŋan walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ga dhäŋur beŋuryiny bala walalnydja ŋunhi ḻundu'mirriŋuny mala nhanŋu ḏawa'yurrnydja nhäŋalnydja ŋanyapinyan Djesunhan, ŋayipin gan dhärranany ŋunhiliyiny walalaŋgalnydja. ");
INSERT INTO djr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ga ŋunhi walal marrtjin wäŋgaŋalnydja roŋi'-ruŋiyinany yarru'-yarrupthurrnydja beŋuryiny ŋunhi bukuŋurnydja, bala ŋayi Djesuynydja waŋanan walalany mirithinan yan bitjarra, “Yaka yan nhuma dhu lakaramany ŋula yolkalnydja yolŋuwal ŋunhi nhä mala nhuma gan nhäŋal, ga bäy ŋayi dhu boŋguŋ Yolŋu Gäthu'mirriŋu walŋathi dhiŋganhaŋur.” ");
INSERT INTO djr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bala bäyŋun yan walal ŋunhi ŋula yolkuny yolŋuw lakaranha ŋunhiŋuwuyyiny dhäwu. Yurr walal marrtjin waŋanhaminan ŋunhi yulŋuny nhä dhuwal mayali' ŋunhi balanyany gam', “Ŋarrany dhu boŋguŋ dhuwal walŋathi yan beŋurnydja moluŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bala walalnydja ŋunhi ḻundu'mirriŋuynydja mala nhanukal dhä-birrka'yurra Djesunhany bitjarra, “Nhaku walal ŋuli ga ŋunhi Rom-marŋgikunhamirriynydja mala yolŋuy walal bitjandja lakaram, ‘Yilaydja ŋathil dhu ŋurruŋuny buni.’” ");
INSERT INTO djr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋ bitjarra, “Yuwalk walal gan ŋunhi bitjarryiny lakaraŋal ŋunhi ŋayiny ŋathil dhu Yilaydjany buni, märr ŋayi ŋathil dhu ŋäthilmirriyam waŋany dhukarrnydja yäkthun. Ga yaka yan nhuma dhuwal marŋgi ŋunhi ŋayi ga wiripuny dhäruk ŋunha waŋa, ŋunhi ŋayi dhu Yolŋuny Gäthu'mirriŋu mirithirra yan dhaŋga-ḏirryundja bili dhu ga ŋunhi yolŋuynydja walal ŋanya bukuy-ŋurrkaman, yakan walal dhu ga nhanŋu djälthirr.” ");
INSERT INTO djr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yuwalk yan ŋarra dhu nhumalaŋ dhuwal lakaramany, “Bili muka ŋayiny ŋunhiyiny yolŋu Yilaydjany bunan, ga walalnydja yolŋuynydja walal bumar warray ŋanya, bitjan yan bili nhakun nhaltjarr walal wukirri nhanukalaŋuwuy ŋäthil.” ");
INSERT INTO djr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Manymak, wäŋgaŋala walal marrtjin bala-a-a, Djesu ga ŋunhiwurryi malthunamirr mala nhanŋu ḻurrkun' yarru'-yarrupthurra balan wiripuwurruŋgala malthunamirriwal walalaŋgal, bala walal nhäŋala yolŋunhan walalany dharrwanhan, ga walal gan ŋunhi ŋunhiwurryi Rom-marŋgikunhamir mala dhä-ḏälthin waŋan walalaŋ ŋunhiliyi wiripuwurruŋ yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ga ŋunhi walal nhäŋalnydja yolŋuynydja walal ŋanyanhany Djesunhany ŋayi gan marrtjinany räli, bala walal dhika mirithinan yan ṉirr'yurrnydja, bala yan walal waṉḏi'-waṉḏinan gumurr'yurra nhanŋu gumurr-ŋamathinan manapar. ");
INSERT INTO djr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bala ŋayi Djesuynydja dhä-birrka'yurra ŋunhi ḻundu'mirriŋunhany mala nhanŋuwuy ŋayi bitjarra, “Wäy, nhäpuy nhuma ga dhuwal waŋanhamirrnydja dhä-ḏälthinyamirrnydja.” ");
INSERT INTO djr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ga ŋayiny waŋganynha ḏirramu ŋunhiliyi malaŋur waŋanany nhanŋu buku-bakmaraŋalnydja bitjarra, “Marŋgikunhamirr, dhuwal ŋarra yothuny ŋarrakuwuy ŋarra gäŋal nhokal bili wakinŋuy birrimbirr ŋanya ŋuli ga dhuwal dhärukmiriwyam. ");
INSERT INTO djr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ga wiripuny ŋayi ŋuli dhuwal ŋanya dhiyaŋiyi birrimbirr ŋayatham bala yan ŋurrkaman ŋanya munatha'lila, bala ŋayi ŋuli ga ḻirra-ḻäwunhamirra, ga dhurrwarakurrnydja ŋuli marrtji nhanukal ŋälnydja gatjkatjtjunna ga rumbalnydja nhanŋu ŋuli marrtji ḏälthirra, burrumunuŋdhirra. Ga waŋanany ŋarra gan dhuwal malthunamirrinhany mala nhuŋu dhawaṯmaranharawnydja dhiyakuny ŋunhi birrimbirrwuny, ga gulkurun.” ");
INSERT INTO djr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bala ŋayiny Djesuny waŋanan bitjarr, “Nhä nhuma dhuwal yolŋuny walal? … märr-yuwalkthinyamiriw mala? Nhämunha'mirra ŋarra nhumalaŋgal dhu buluny nhina? Go rälin ŋanya gäŋu dhuwaliyiny yothunhany,” ");
INSERT INTO djr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","bala yan walal gäŋala ŋanya ŋunhiyiny yothunhany Djesuwala. Ga ŋunhi ŋayi ŋuriŋiy yätjkurruynydja birrimbirryu nhäŋal Djesunhany, bala yan ŋayi dhunupan ŋunhi yothunhany rurr'rurryurra bala yan ŋurrkaŋala ŋanya munatha'lila, bala ŋayi marrtjin ŋunhi yothuny ḏur'yunminan ga dhurrwarakurrnydja marrtjin ŋälnydja gatjkatjtjurra. ");
INSERT INTO djr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Bala ŋayiny Djesuynydja dhä-birrka'yurra ŋunhiyiny bäpa'mirriŋunhany bitjarra, “Nhämunha'mirr ŋayi gan dhuwal bitjarryiny?” Ga ŋayiny ŋunhiyiny bäpa'mirriŋuny buku-bakmaraŋal bitjarr, “Dhuwandja ŋayi gan bitjarrnydja beŋur bili yan yothuŋur muka yan, ga yan bili-i-i ga dhuwanna bala. ");
INSERT INTO djr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ga wiripuny ŋayi ŋuli ŋuriŋiyi yätjkurruy birrimbirryurr ŋurrkam ŋanya gurthalil, ga wiripuny gapulil, rakunygunhan ganha bitjana. Garray wuyurra linyalaŋ, ga guŋga'yurra. Ŋuli nhe ga ganydjarrnydja ŋayatham.” ");
INSERT INTO djr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ga ŋayiny Djesuny waŋan bitjarr, “Nhaku nhe bitjarryiny waŋan. Ŋuli ŋayi ga ŋula yol yolŋu märr-yuwalkthirrnydja, ŋayiny dhu ŋunhi djäman bala yan.” ");
INSERT INTO djr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ga dhunupan yan ŋayiny ŋunhi bäpa'mirriŋuny yatjurra waŋan, “Ŋarrany ga dhuwal märr-yuwalkthirr. Go guŋga'yurra ŋarrany, märr ŋarra dhu yakan nhuna märr-yuḻkthundja.” ");
INSERT INTO djr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ga ŋunhi ŋayi Djesuy nhäŋalnydja ŋunhi yolŋunhany walalany walal marrtjin ḻuŋ'thurra galkithinan, bala yan ŋayi dhunupan waŋanan dhäruk-gurrupanminan ŋurikiyiny yätjkurruwnydja birrimbirrwu dhawaṯmaraŋala bitjarra, “Nhe buthuru-dhumuk ga dhärukmiriw birrimbirr, ma' dhawaṯthurra dhiyakalnydja yothuwalnydja dhiyaŋun bala yan, ga yakan nhe dhu buluny gärri nhanukal.” ");
INSERT INTO djr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Bala ŋayi ŋunhi yätjkurrnydja birrimbirr dhunupan yatjurra bala marrtjin marrmarrmaraŋala ŋunhiyiny yothunhany mirithinan yan dhika, bala yan ŋayi dhawaṯthurra nhanukal. Bala ŋayi gan ŋunhi yothuny ŋorranan nhanukuŋ ganydjarrpuynydja dharraḏan nhakun dhiŋganhawuynha. Ga walalnydja ŋunhi wiripuwurruynydja yolŋuy walal nhäŋalnydja bala walal yatjunminan bitjanminan, “Wäy rakunydhinan ŋayi ŋunha,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ga dhunupan ŋayiny Djesuny goŋ-djarryurra baṯnha ŋanya ŋayathaŋal goŋnha bala rur'maraŋala, bala ŋayi yan ŋunhi dhärranan. ");
INSERT INTO djr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ga beŋuryiny dhurrwaraŋur ŋayiny Djesuny gulŋiyinan buṉbulila, bala walal ŋunhi malthunamirriynydja mala nhanukal dhä-birrka'yurra ŋanya bitjarr, “Wäy nhaku ŋunhi ŋanapurrnydja ŋanya yaka dhawaṯmaranha ŋunhiyi yätjkurruny birrimbirrnha. Nhaku ŋunhi ŋanapurrnydja gan waŋan ŋanya, ga ŋayiny yaka warray dhawaṯthunna.” ");
INSERT INTO djr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ga ŋayiny Djesuny waŋan walalaŋ buku-bakmaraŋal bitjarr, “Waŋganydhun yan ŋayi dhu balanyayiny birrimbirr dhawaṯthun, bukumirriyanhawurra yan.” ");
INSERT INTO djr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ga dhurrwaraŋur beŋuryiny bala ŋayi Djesuynydja ga ḻundu'mirriŋuynydja mala nhanukal ganarrthaŋala ŋunhiyiny wäŋa, bala walal marrtjinan Galaliwurra wäŋakurr, ga yaka ŋayi gan Djesu djälthin walal dhu bukmaktja yolŋu marŋgithirr. ");
INSERT INTO djr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ga bitjarra ŋayi gan ŋunhi malthunamirrinhany walalany nhanŋuwuy marŋgikuŋal gam', “Yolŋunhany Gäthu'mirriŋuny dhu dhuwal goŋ-gurrupanna yolŋu'-yulŋuwala mala. Bala walal dhu buman ŋanya murrkay'kuman. Ga ŋunhi walal ŋanya dhu bumany, ga ḻurrkun' dhu walu djuḻkthun, bala ŋayi dhu buluyi walŋathirr.” ");
INSERT INTO djr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yurr walalnydja ŋunhi malthunamirriynydja mala nhanukal yaka yan ŋanya dharaŋana ŋunhi nhaltjarr ŋayi gan waŋan, ga yakan walal gan djälthin dhä-birrka'yunarawnydja nhanŋu, bili walal gan ŋunhi rum'rumdhurra nhanŋu ŋäŋ'thunarawnydja. ");
INSERT INTO djr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yo, … wäŋgaŋala walal marrtjin Djesu ga ḻundu'mirriŋu mala nhanŋu ga-ga-ga baṯnha ŋayathaŋal Gapuniyamnha wäŋa, bala gärrinan buṉbulila. Bala ŋayi ŋunhiliyiny walalany Djesuy dhä-birrka'yurra bitjarra, “Walal nhäpuy nhuma marrtjin ŋunhi waŋanhaminany dhä-ŋurrkanhaminany räli dhukarr-ŋuparnydja?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ga walalnydja ŋunhalnydja mukthurra bukmaknha goranan nhanŋu, bili walal marrtjin ŋunhi dhukarrkurrnydja waŋanhamin, yol dhu ŋunhi beŋuryi ŋurrukŋur walalaŋgal buŋgawayi. ");
INSERT INTO djr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Bala ŋayi Djesuny nhinanan, bala wäthurra ŋunhi 12-kuny djuy'yunawuywuny walalaŋ, bala ŋayi waŋanan bitjarra, “Ŋuli nhe ŋula yol yolŋu djäl buŋgawathinyarawnydja, nhe dhu ŋurruŋuyirr wiripuwurruŋguny yolŋuw walalaŋ, nheny dhu ŋathil nyilŋ'maranhamirr nhunapinya nhe, ga guŋga'yun nhe dhu ga walalany, ŋunhiny nhakun nheny dhu djämamirrnydja ŋurikiwurruŋguny wiripuwurruŋguny yolŋuw walalaŋ.” ");
INSERT INTO djr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bala ŋayi Djesuny gawaw'yurra yothuwnha ga nhirrparnydja ŋayi ŋanya gumurrlil yan walalaŋgal ṉapuŋga'lila, bala ŋayi dhangi'yurra ŋanya, bala ŋayi waŋanan ḻundu'mirriŋuwnydja mala nhanukalaŋaw bitjarr, ");
INSERT INTO djr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ŋuli nhe dhu ŋula yol yolŋu gumurr-ŋamathirr balanyarawnydja gay'yi yothuw ŋarrakalnydja yäkuy, ŋunhiyiny nhe ŋarrakun gumurr-ŋamathin. Ga ŋuli nhuma ga ŋula yolnydja mala ŋarrakuny gumurr-ŋamathirr, nhumany ŋunhiny ga gumurr-ŋamathirr ŋurikin ŋunhi yolthu ŋarrany djuy'yurr,” bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Bala ŋayi Djondja waŋanan bitjarra, “Way Marŋgikunhamirr, ŋunha ŋanapurr yolŋuny nhäŋal ŋayi gan wakinŋuny birrimbirrnha dhawaṯmaraŋal nhokal yäkuy, ga ŋanapurrnydja ŋanya waŋan ḏaḏawmaraŋala, bili ŋayi ŋunhi yaka dhipuŋurnydja limurruŋgalnydja malaŋur.” ");
INSERT INTO djr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ga ŋayiny Djesuny waŋan buku-bakmaraŋal bitjarr, “Ganarrthul ŋanya ŋunhiyiny yolŋuny, bäy ŋayi dhu ga djäma. Ŋuli dhu ga ŋunhi ŋula yolthu yolŋuy djäma ŋoy-ganyim'thunamirrnydja rom ŋarrakalnydja yäkuy, ga bäyŋun ŋayi dhu ŋunhi bilyundja bala waŋany yätjkurr-lakaramany ŋarrany. ");
INSERT INTO djr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ga ŋunhi ŋayi ŋula yol yolŋu yakany nhakun limurruŋguny baku-ŋayathanhamirr, ŋayiny ŋunhiyiny yolŋu guŋga'yunamirra limurruŋ. ");
INSERT INTO djr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Märr-yuwalk ŋarra ga dhuwal nhumalaŋ lakaramany, ŋuli dhu nhuna ŋula yolthu yolŋuy gurrupan gapuny ḻukanharawnydja, bili nheny ŋunhi ŋarraku malthunamirr, ga ŋayiny dhu God-Waŋarryuny gurrupandhi buku-roŋanmaram ŋurikiyiny yolŋuw.” ");
INSERT INTO djr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ga bulu ŋayi Djesu waŋan bitjarr, “Ga ŋuli ŋayi dhu ŋula yolthu yolŋuy bilmaram ŋunhi waŋganynha malthunamirriny ŋarrakalaŋuŋurnydja märr-yuwalkthinyaŋur, ga manymaktja ŋunhi mirithirrnydja nhanŋu ŋurikiyiny yolŋuw ŋunhi ŋoy-burrpuwny'tja nhanukalnydja dhu garrwi'yunna yindin yan guṉḏany mayaŋlila nhanukal bala ŋurrkaman ŋanya dhulmulila gapulil. ");
INSERT INTO djr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","47","Ŋuli ŋayi nhuna goŋdhuny nhokal yätjkurrulilnydja romlil gäŋal, nheny dhunupan gulkmaranhamirra. Bili ŋunhiyiny nhakun manymaknha mirithirra nhuŋu nhe dhu yuṯany walŋa märram goŋ-waŋganymirriynha yan, ga ŋuli nhe märrma'mirrnydja yan goŋmirr nhunanhany dhu gurthalila ŋurrkuŋ balan ŋunhi dhä-gir'yunamirrilila wäŋalil. Ga ŋuli ŋayi nhuna ḻukuynydja nhokal yätjkurrulil romlil gäŋal, nheny dhunupan gulkmaranhamirra. Bili manymaktja nhuŋu nhe dhu yuṯany walŋa märraŋ djalkiri waŋganymirriynha. Ga ŋuli nhe märrma'mirrnydja djalkirimirr, nheny dhu gurthalila marrtji ŋunhiwilin ŋunhi ŋuli ga nhäran yan bitjanna bili. Ga ŋuli ŋayi melyuny nhuna yätjkurrulil romlil gäŋal, nheny yanan maŋutjiny nhunapinya nhe ḏulŋurr'yunmirra. Bili manymaktja mirithirrnydja nhuŋu nhe dhu gärri bala God-Waŋarrwalnydja romlil mel waŋganymirra yan, ga ŋuli nhe mel märrma'mirrnydja yan, nhunanhany dhu ŋurrkuŋ balan gurthalila, balan ŋunhi dhä-gir'yunamirrilila wäŋalil. ");
INSERT INTO djr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yo, ŋunhiliyiny ŋunhi wäŋaŋur dhu ga barrpany' gaḻ'kaḻyunna yan walŋan, ga gurthany dhu ŋunhi bäyŋun yaŋara'-dhawar'yun.” ");
INSERT INTO djr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ga buluny ŋayi Djesu waŋan bitjarra, “Bukmaknhan yan dhu ŋunhi yolŋunhany walalany waŋgapunuŋuny gurthaynha.” ");
INSERT INTO djr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Yo, dje'lany dhuwal ŋamakurr yan. Ga ŋuli ŋayi dhu ŋunhi dhäkaymiriwyirrnydja, ga nhaliynha ŋayi dhu ŋunhi buluny nhakun dhäkaymirriyirr? Yo, nhumany dhu dhäkaymirriyanhamirra, märr nhuma dhu ga nhinany manymakkuman yan ga mägayan.” ");
INSERT INTO djr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ga dhurrwaraŋur beŋuryiny ŋayi Djesuy ganarrthaŋala ŋunhiyiny wäŋa, bala ŋayi marrtjinan Djudiyalila makarrlil wäŋalil, ga buḏapthurr ŋayi maniw Djodanbuywu, ga buluyi marrtjin ŋunhi yolŋuny walal ḻuŋ'thurr nhanukal dharrwan dhika mirithirra, bulu nhakun ŋayi walalany gan marŋgikuŋal, bitjarr yan bili nhakun ŋayi ŋuli ganha marŋgikunha yan walalany. ");
INSERT INTO djr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ga walalnydja ŋunhi Baratjiny mala yolŋu'-yulŋu marrtjindhi nhanukal Djesuwal, bala walal gan dhä-birrka'yurra ŋanya, yan nhakun gan birrka'yurr ŋanya. Ga bitjarr walal gan ŋanya ŋunhi dhä-birrka'yurrnydja gam', “Way, nhaltjan ga ŋunhi limurruŋgalnydja romdhu lakaram? … Muka dhunupa ŋunhi yolŋuw ŋayi dhu miyalknhany nhanŋuwuy ŋayi ganan, bala yan djuy'yunna ŋanya?” ");
INSERT INTO djr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ga ŋayiny Djesuny buku-bakmaraŋal bitjarr, “Nhaltjan ga ŋunhi Mawtjitjthuny rom ḻakaraŋal nhumalaŋguny?” ");
INSERT INTO djr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ga walalnydja nhanŋu buku-bakmaraŋal bitjarr, “Mawtjitjthuny ŋunhi bitjarr rom nhirrpar gam', manymak warray ŋayi dhu dhuway'mirriŋuy miyalknhany nhanŋuwuy ŋayi djuy'yun, yurr ŋathil ŋayi dhu ŋurruŋuny djorra' wukirri, ga yorrnha ŋayi dhu ŋunhi miyalknhany djuy'yun muŋbunumany.” ");
INSERT INTO djr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bala ŋayi Djesuny waŋan walalaŋ buku-bakmaraŋal bitjarra, “Ŋunhiny ŋayiny Mawtjitjthuny rom nhirrpar nhumalaŋ ŋäthil bitjarryiny, bili nhuma dhuwali ŋayaŋu-wuṉḏaŋarrmirr mala. ");
INSERT INTO djr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bili God-Waŋarryu ŋunhi baman'tja ŋurruṉaŋgalnydja ŋamaŋamayurr bukmak yan nhä malany, ga djämayi ŋayi ŋunhi yolŋunhany maṉḏany miyalknhany ga ḏirramunhany. ");
INSERT INTO djr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ga balanyarawyin ŋunhi gämurruw' ŋayi ŋuli ŋunhi ḏirramuynydja ganarrthaman nhanŋuwuy ŋayi ŋäṉḏi'mirriŋunhany ga bäpa'mirriŋunhany, bala maṉḏa dhu nhakun märranhamirra miyalknha nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ga rumbalnydja maṉḏa ŋunhi waŋganynha. Yakan maṉḏa ŋunhi buluny barrkuwatj, ŋany waŋganyŋura yanan. ");
INSERT INTO djr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ga bäyŋun dhu ŋunhi ŋula yolthuny yolŋuy maṉḏany barrkuwatjkumany, bili God-Waŋarryun ŋunhi ŋayipin waŋgany-manaparnydja maṉḏany,” bitjarra ŋayi gan Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ga dhurrwaraŋur beŋuryiny bala walal ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu marrtjinany bala buṉbulila gulŋi'-gulŋiyin, bala walal ŋanya ŋunhi dhä-birrka'yurra ŋunhiŋuwuyyin. ");
INSERT INTO djr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ga ŋayiny Djesuynydja lakaraŋal walalaŋ bitjarr, “Ŋuli ŋayi dhu ŋunhi ḏirramuy ganan nhanŋuwuy ŋayi miyalknhany, ga märram ŋayi dhu wiripuŋunhan, ŋunhiyiny ŋayi ga bitjandhiny marramban' djäma. ");
INSERT INTO djr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ga balanyayi bili yan miyalkkuny, ŋuli ŋayi dhu ganan nhanŋuwuy ŋayi dhuway'mirriŋuny ga märram ŋayi dhu ŋunha wiripuŋunhan ḏirramuny, ŋunhiyiny ŋayi ga bitjandhi bili yan marramba'yi yan djäma,” bitjarra ŋayi gan Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ga beŋuryiny bala walalnydja yolŋu'-yulŋuynydja marrtjin gäŋa'-gaŋal djamarrkuḻi'nhan nhanukal Djesuwala, märr ŋayi dhu walalaŋgal goŋ-ŋal'yun. Ga walalnydja bäy ŋunhi malthunamirriynydja mala nhanukal ŋaŋ'ŋaŋ'thurra walalany ḏälyun dhärukthuny. ");
INSERT INTO djr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ga ŋayiny ŋunhi Djesuynydja nhäŋal, bala yan maḏakarritjthinan, bala ŋayi waŋanan malthunamirriwnydja mala nhanukalaŋaw bitjarra, “Manymak walal dhu ŋunhi marrtji räli ŋarrakal, yaka walalany gulmaraŋ. Bili God-Waŋarrwuny rom ŋunha balanyarawnha nhakun dhiyakurruŋgun djamarrkuḻiw'nha.” ");
INSERT INTO djr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Märr-yuwalk ŋarra nhumalaŋ ga dhuwal lakaramany. Ŋuli dhu ŋunhi ŋula yolthu yolŋuy yakany märram God-Waŋarrwuny Rom, ŋayiny dhu ŋunhiyiny yolŋu bäyŋun gärri ŋunhiwiliyiny nhanukalnydja Romlil God-Waŋarrwalnydja, ŋany bäy ŋathil nhe dhu gumurr-ŋamathirr bitjan nhakun dhuwalawurr djamarrkuḻi' gumurr-ŋamathin ŋarraku. ");
INSERT INTO djr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bala ŋayi Djesuynydja marrtjin ḻaw'-ḻawmaraŋala ŋunhiyiny djamarrkuḻi'nhany, bala ŋayi marrtjin goŋ-ŋal'yurra walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Manymak, ga ŋunhi ŋayi gan Djesu gurku'yurrnydja marrtjinyarawnha wiripulila wäŋalil, bala ŋayiny bäy ḏirramu nhanŋu bunan ŋunhiliyi, yurr ḻukunydja' ŋayi ŋunhi mirithirr. Waṉḏinany ŋayi ŋunhi bala yan bun'kumu-djipthurra gumurrlila nhanukal, bala ŋayi waŋanany bitjarra, “Garray nheny dhuwal manymak yan marŋgikunhamirr. Nhaltjan dhika ŋarra dhu yulŋuny märr ŋarra dhu märramany ŋunhi walŋa wiyinŋumirrnydja?” ");
INSERT INTO djr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ga ŋayiny Djesuny waŋan nhanŋu bitjarr, “Nhaku nhe dhuwal ŋarrany manymak lakaraŋalnydja? Bäyŋun dhuwal ŋula yol yolŋu manymak; ŋayipin yan dhuwal God-Waŋarrnha manymaktja. ");
INSERT INTO djr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Marŋgi muka nhe ŋunhi dhiyakuny dhäruk-nhirrpanminyawuywuny romgu gam', ‘Yaka buŋu yolŋuny murrkay'kuŋ, ga yaka marramba'yi, ga yaka manaŋi, ga yaka nyäḻyurr lakaraŋ. Märr-ŋal'yurr gi yan nhokalaŋaw ŋäṉḏi'mirriŋuwnydja ga bäpa'mirriŋuwnydja.’” ");
INSERT INTO djr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bala ŋayiny ŋunhiyiny ḏirramuny waŋan bitjarra, “Way Garray dhuwaliyiny ŋunhi rom mala ŋarra gan ŋayathaŋal beŋur bili, ŋunhi ŋarrany yothu yan muka,” ga bitjarr ŋayiny. ");
INSERT INTO djr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ga ŋayiny ŋanya gan Djesuynydja nhäŋala dharr-bitjarra ŋayaŋuynydja märr-ŋamathinyaraynha, bala ŋayi waŋanan nhanŋu bitjarra, “Nheny dhuwandja yolŋu girri' dharrwamirr, ga waŋganynha nhe dhu buluny djäma. Gatjuy djalimnha nhuŋuwuy nhe girriny' mala warrpam'thurra, ga gurrupula rrupiyany ŋunha ŋurruwuykmirriwnha yolŋuw walalaŋ, bala ŋayiny dhu God-Waŋarryuny nhuŋuny gurrupan nhä mala bulun dhika manymak ŋunhaŋuwuynha djiwarr'puynha. Gatjuy marrtjin, ga djämany nhe dhu bitjandhiyin, bala roŋiyiny, bala malthurra ŋarrakun.” ");
INSERT INTO djr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ga ŋunhi ŋayi ŋuriŋiyi yolŋuy ŋäkulnydja, bala yan ŋayi mirithinan dhika ŋurru-yupthurrnydja, bala yan ŋayi ŋunhi marrtjinany dhärukmiriwnha, bili ŋayi ŋunhi ḻukunydja' mirithirr. ");
INSERT INTO djr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bala ŋayi Djesuny bilyurra, ga waŋan ŋayi ŋunhi malthunamirriwnydja mala nhanukalaŋaw bitjarra, “Ḏäl dhuwal mirithirr bay', ḻukunydjawny'tja yolŋuw gulŋiyinyaraw ŋunhawalnydja ŋunhi God-Waŋarrwalnydja Romlil.” ");
INSERT INTO djr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ga walalnydja ŋunhi malthunamirriynydja mala nhanukal ŋäkulnydja ŋanya dhäruktja ṉirr'yurra. Ga bulu ŋayi Djesu waŋan walalaŋgal bitjarr, “Djamarrkuḻi' ŋarraku, yuwalk dhuwal yulŋuny ḏäl yan gärrinyaraw God-Waŋarrwalnydja Romlil! ");
INSERT INTO djr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ḏälnha dhuwal gamuḻwuny gulŋiyinyaraw ŋurukuny ŋunhi nyumukiny'kuny dhurrwaraw, ga bulun gal'ŋu dhuwal gumurr-ḏäl ŋunhi ḻukunydjawny'tja yolŋuw gulŋiyinyaraw ŋunhawalnydja ŋunhi God-Waŋarrwalnydja Romlil.” ");
INSERT INTO djr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ga walalnydja ŋunhi ḻundu'mirriŋuynydja mala nhanukal ŋäkul ganyim'thurra yan mirithinan, bala walal gan waŋanhaminan bitjanminan, “Yolnha dhika dhu ga yolŋu walŋany nhina?” ");
INSERT INTO djr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Bala ŋayiny Djesuynydja nhäŋala marrtjin walalany ga waŋan ŋayi bitjarra, “Yolŋuny dhu ŋunhi bäyŋun walŋakunhamirr ŋanyapinya ŋayi gänany. Yurr ŋayiny dhu ŋunhi God-Waŋarryuny djäman bala yan.” ");
INSERT INTO djr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ga ŋayiny Betany waŋan buku-bakmaraŋal bitjarr, “Garray napurrnydja ŋunhi ganarrthaŋal nhä malany ŋanapurruŋguwuynydja bukmak yan, bala napurr nhuŋun malthurr.” ");
INSERT INTO djr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ga ŋayiny Djesuny waŋan bitjarra, “Märr-yuwalk yan ŋarra nhumalaŋ dhu dhuwandja lakaram. Ŋunhi ŋayi dhu ŋula yolthu yolŋuy ganan wäŋany nhanŋuwuy ŋayi, ga wäwa'mirriŋuny, ga yapa'mirriŋuny, ga ŋäṉḏi'mirriŋuny, ga bäpa'mirriŋuny, ga djamarrkuḻiny' nhanŋuwuy ŋayi, märr ŋayi dhu ga ŋarrakuwuynha yan malthundja lakaraman dhu marrtji dhäwun wiripuwurruŋgala yolŋuwal walalaŋgal, ");
INSERT INTO djr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","bala ŋayiny dhu God-Waŋarryuny gurrupan ŋanyanhany dhiyakuny bala walŋaw dhiyalnydja munatha'ŋurnydja, bulun dhika wäŋa mala, wäwa'mirriŋu mala, ga yapa'mirriŋu mala, ga ŋäṉḏi'mirriŋu, ga djamarrkuḻi'. Bäydhi walalany dhu marrtji ŋunhi wiripuwurruynydja yolŋuy mala baḏuwaḏuyun. Ga bulu yalalaŋumirriynydja ŋayi dhu gi ŋunhi ŋunhiyiny yolŋu ŋunhalnydja djiwarr'ŋurnydja nhini walŋan yan, biyakun bili yan wiyinŋumirra. ");
INSERT INTO djr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ga ŋunhi ŋula nhämunha yolŋu walal, ŋunhi walal ga djälthirr dhiyaŋ bala ŋurruŋuyinyaraw, walalnydja dhu ŋunhi ŋunhalnydja dhuḏi-yapalan, ga ŋunhi ŋula nhämunha' yolŋu walal dhuḏi'-dhuḏiŋuny dhu ŋurruŋun.” Ga bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yo. Walalnydja marrtjin ŋunhi Djesuny ga ḻundu'mirriŋuny mala nhanŋu wäŋgaŋala ḏuwaṯthurra balan dhukarr-ŋupara Djurutjalamlila. Ga wiripuwurrnydja yolŋu walal wäŋgaŋal marrtjin dhuḏikurra, ŋapa-ŋupara walalany. Yurr ŋayiny gan ŋunhi Djesuny marrtjin ŋurruŋun, bala walalnydja ŋunhi malthunamirrnydja mala nhanŋu märr-dhumbal'yurra, ga wiripuwurrnydja mala ŋunhi yolŋu walal barrarinan. Bala ŋayi Djesuynydja ḻuŋ'maraŋala ḻundu'mirriŋunhany mala nhanŋuwuy 12-nhany waŋganylila, bala ŋayi lakaraŋala walalaŋgal ŋunhi nhaltjan dhu maḻŋ'thun nhanŋu ŋunhal Djurutjalam wäŋaŋur. Ga bitjarra ŋayi walalaŋ waŋanany, ");
INSERT INTO djr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Ŋämany nhuma dhu manymakkum yan walal. Limurrnydja ga dhuwal marrtjin Djurutjalamlil, ga ŋunhiliyiny walal dhu Yolŋunhany Gäthu'mirriŋuny märraman bala gäman goŋ-gurrupanna ŋurruŋu djirrikaymirriwala walalaŋgal ga Rom-marŋgikunhamirriwala walalaŋgal, märr walalnha dhu ŋunhi mala-djarr'yundja bunharawnydja nhanŋu, bala walal dhu goŋ-gurrupanna ŋanya balan Djan'tayilwala yolŋuwal walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Walalnha ŋanya dhu ŋunhi warku'yundja, ga dhupthundja ga bartjunmaramany burruṯiŋuynha, ga bumany ŋanya walal dhu murrkay'kuman. Yurr ŋayi dhu ŋunhi buluyi nhakun walŋathiyi ḻurrkun'thuny waluy.” Ga bitjarra ŋayi gan ŋunhi waŋanany. ");
INSERT INTO djr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ga beŋuryiny, maṉḏany Djayimdhuny ga Djondhuny guwatjmara ŋanya Djesunhany, ŋuriŋiny maṉḏa ŋunhi maṉḏa gäthu'mirriŋu Djibidiw. Bala maṉḏa ŋanya waŋanan bitjarra, “Dhuwandja nhe dhu linyalaŋ yoram yan, ŋunhi linyu dhu nhuna dhuwal ŋäŋ'thundja.” ");
INSERT INTO djr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ga ŋayiny Djesuny waŋan bitjarr, “Nhaku bili nhuma ŋarrany dhu ŋäŋ'thundja?” ");
INSERT INTO djr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ga maṉḏany buku-bakmaraŋal nhanŋuny Djesuwnydja bitjarra, “Ŋunhi nhe dhu ga nhina ŋurruŋuny nhokiyingalnydja nhe nhinanhawuyŋur, ŋunhiliyiny ŋunhi manymakŋurnydja romŋur djeŋarra'mirriŋurnydja, linyuny dhuwal djäl linyu dhu ga nhina galki yan nhokal gali'ŋur, waŋganydja dhu ga nhina dhunupa'ŋuŋur gali'ŋur, ga waŋganydja wiṉ'kuŋuŋur gali'ŋur.” Bitjarra maṉḏa gan ŋunhi waŋanany ŋanya Djesunhany. ");
INSERT INTO djr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ga ŋayiny Djesuny waŋan maṉḏaŋ bitjarr, “Maṉḏa, dhuwal nhuma ga ŋoy'mukmirriw romgu ŋäŋ'thun. Nhä bili balaŋ nhuma dhuwal ŋuḻkthurr yan beŋurnydja ŋunhi ŋarrakalaŋuŋurnydja banikin'ŋur. Ga ŋula balaŋ muka nhuma dhuwal märraŋ dhuwandja ŋunhi buku-ḻupmaranhawuy rom ŋunhi ŋarra ga märram dhiyaŋun bala?” ");
INSERT INTO djr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ga maṉḏany waŋan, nhanŋuny buku-bakmaraŋal bitjarr, “Linyuny dhu dhuwal djäman yan.” Ga ŋayiny Djesuny waŋan bitjarr, “Ma! Ga yuwalknha yan nhuma dhu dhuwal dhipuŋurnydja banikin'ŋur ŋuḻkthun, ga bitjandhi bili nhuma dhu märramdhi dhuwal buku-ḻupmaranhawuynydja, ŋunhi ŋarra dhu dhuwal märram. ");
INSERT INTO djr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yaka dhuwal ŋarrakuny dhunupa, ŋarra dhu yoram yolŋuw walalaŋ ŋunhi walal dhu bitjandhiyiny ŋäŋ'thun. Ŋayipi yan dhu dhuwal God-Waŋarryu nhirrpandja dhipalnydja ŋunhiwurruny yolŋuny walalany ŋunhi ŋayi ŋäthilmirriyaŋal wäŋa walalaŋ ŋunha.” Ga bitjarra ŋayi gan ŋunhi Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ga wiripuwurruynydja ḻundu'mirriŋuy mala nhanukal ŋäkul maṉḏany Djayimnha ga Djonnha ŋunhi maṉḏa gan djälthin, ga waŋan maṉḏa gan Djesuny ŋurruŋuyinyaraw, bala walal ŋunhi maḏakarritjthinan maṉḏaŋ. ");
INSERT INTO djr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Bala ŋayi Djesuynydja ḻuŋ'maraŋala ḻundu'mirriŋunhany mala nhanŋuwuy ŋayi, bala ŋayi lakaraŋalnydja walalaŋgal bitjarra gam', “Way, marŋgi muka nhuma dhuwal ŋurukuwurruŋguny ŋunhi Djan'tayilwuny yolŋuw walalaŋ romgu, ŋunhi walal ŋuli ga buŋgawakunhamirr, yanbi walal buŋgawan yolŋuwnha mala ga wäŋawnha mala walalaŋgalaŋaw. Bala ŋuli ga ŋunhi buŋgawaynydja mala yolŋunhany mala dhar'thar-gurrupanna, nhakun walalnydja djämamirra mala walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yurr nhumany dhu ga ŋunhi yaka bitjandhi. Ŋuli nhe ŋula yol yolŋu djäl buŋgawayinyarawnydja, nheny ŋathil dhu djämamirriyirr. ");
INSERT INTO djr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ŋuli nhe ga ŋula yol yolŋu djälthirr ŋurruŋuyinyarawnydja, nheny ŋathil dhu wiripuwurruŋguny yolŋu walalaŋ djämamirr. ");
INSERT INTO djr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bili balanyarawyi muka ŋunhi ŋayiny Yolŋuny Gäthu'mirriŋu bunan dhiyalnydja, ŋayi dhu yan djämamirr yolŋu, ga walŋa-gurrupanmirr ŋayi dhu wiripuwurruŋ yolŋuw walalaŋ walŋakunharaw. Yaka ŋayi ŋunhi buŋgawathinyarawnydja räli marrtjin.” Ga bitjarra ŋayi gan ŋunhi Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ŋunhi walal marrtjin Djesu ga malthunamirr mala nhanŋu wäŋgaŋalnydja bala-a-a, baṯnha ŋayathaŋal Djarikawnydja wäŋa yäku. Ga ŋunhi walal ganarrthaŋal ŋunhiyiny wäŋa, ga walalnydja ŋunhi dharrwan mirithirra yolŋuny mala malthurr dhukarr-ŋuparnydja. Ga ŋunhili gali'ŋur dhukarrŋurnydja gan nhinan yolŋu yäku Bätimayatj, yurr ŋayi ŋunhi bambay ga baḻ'-yalŋgi, ga gäthu'mirriŋuny ŋayi ŋunhi Dimayaw. ");
INSERT INTO djr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ga ŋunhi ŋayi ŋäkul rirrakaynydja ŋanyanhany Djesunhany wäŋa Nätjuritjpuynhany bala ŋayi dhunupan yatjurra bitjarra, “Way, Djesu Gäthu'mirriŋu Daybitku, wuyurr ŋarraku go,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bala walalnydja dharrwaynha yan yolŋuynydja mala way'yurr ŋanya mukmaraŋal, yurr ŋayiny bäyŋun mukthunna; baḏaknha yan ŋayiny gan yatjurr mirithinan dhika, “Djesu, gäthu'mirriŋu Daybitku, wuyurr ŋarraku,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bala ŋayi Djesuny gulyurra, bala ŋayi waŋanan, “Wäthurr nhanŋu.” Bala walal waŋanan ŋurikiyiny bambaywuny bitjarra, “Nheny galŋa-djulŋithin, ga go marrtjin rur'yurra.” ");
INSERT INTO djr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bala dhunupan yan ŋayiny ŋunhi bambaynydja yolŋu wapthurra bala ŋurrkaŋala ŋunhi gumurrpuynydja nhanŋuwuy mulkany' girri', bala yan djartjaryurra Djesuwala. ");
INSERT INTO djr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Bala ŋayi Djesuynydja waŋanan ŋanya dhä-birrka'yurra, “Nhaku nhe djälnydja? Nhaltjan ŋarra dhu nhuna, … guŋga'yun?” bitjarr. “Marŋgikunhamirr nhänharawnha ŋarra dhuwal djäl,” ga bitjarr ŋayiny ŋunhiyiny bambaynydja yolŋu buku-bakmaraŋal nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Gatjuy marrtjin. Nhokal märr-yuwalkthinyaraynydja nhe dhuwali ḏukthurra,” bitjarra ŋayi Djesuny nhanŋu waŋan. Ga dhunupan ŋayi ŋunhi melnydja ḻapthurra bala yan ŋayi nhäŋala, bala ŋayi marrtjin ŋunhi malthurra bala Djesuwnydja dhukarr-ŋupara. ");
INSERT INTO djr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yo, Djesuny ga malthunamirrnydja mala nhanŋu marrtjin ŋunhi wäŋgaŋala bala. Ga ŋunhi walal marrtjin bukuy-märraŋal Djurutjalamdja wäŋa. Ga ŋuliwitjarryin walal gan ŋunhi marrtjinany märrma'kurra wäŋakurr yäkukurr Batpatjkurra ga Bithinikurra, ga bunanany walal ŋunhala bukuŋura wäŋaŋur yäkuŋur Wolipnha. Bala ŋayipiny Djesuynydja märrma'nhany ḻundu'mirriŋuny maṉḏany nhanŋuwuy ŋayi djuy'yurra ŋäthila, ");
INSERT INTO djr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ga bitjarr ŋayi waŋanany maṉḏaŋgal gam', “Gatjuy nhumany ŋäthil marrtji ŋini, balan ḻaypalila wäŋalil ŋunha gali'lila. Ga ŋunhi nhuma dhu dhuwal marrtjiny, ga maḻŋ'maramany nhuma dhu warrakan'nha yäkuny duŋ'kiny, garrpinawuy ŋayi dhu ga ŋunhi dhärrany. Yurr yaka ŋayi ŋunhi ŋula ŋäthiliŋuwuynydja buŋganmirriyanhawuy; bäyŋu yan ŋunhi yolŋu ŋunhiwili ŋal'yurr. Nhumany dhu marrtjiny, bala rakiny' yapmaraman bala rälin gäma. ");
INSERT INTO djr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ga ŋuli nhumalany dhu ŋula yolthuny yolŋuy dhä-birrka'yundja, ‘Way maṉḏa, nhaku nhuma ga dhuwal yapmaramany?’ Ga nhumany dhu bitjan waŋa, ‘Garray dhuwal dhiyak djälthin, ga yalalan ŋayi dhu roŋanmaramany nhumalaŋ,’ biyak lakaraŋuny walalaŋgal.” ");
INSERT INTO djr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ga ŋunhi maṉḏa marrtjinany, bala maṉḏa maḻŋ'maraŋala warrakan'nhany garrpinawuynha raki'mirra, ŋayi gan dhärran dhukarrŋur, galki ŋunhili dhurrwaraŋur buṉbuŋur. Bala yan maṉḏa ŋunhi rakiny' yupmaraŋala. ");
INSERT INTO djr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ga walalnydja wiripuwurrnydja yolŋu walal ŋunhi walal marrtjin galki dhärra'-dharran, waŋan walal bitjarra, “Way maṉḏa nhaku nhuma ga dhuwal rakiny' yupmaram dhipuŋuryiny duŋ'kiwalnydja.” ");
INSERT INTO djr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bala maṉḏany buku-bakmaraŋal walalaŋguny balany bitjarra, “Garray dhuwal dhäruk djuy'yunmin dhiyak.” Bala yan walalnydja ŋunhi yolŋuynydja walal dhayuŋara. ");
INSERT INTO djr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bala maṉḏa ŋunhi gäŋala warrakan'nhany Djesuwala. Ga ŋunhalnydja walalnydja marrtjin ŋunhi girrin' mala walalaŋguwuy ḻarrmaraŋal, bala ŋal'maraŋala ŋapalila duŋ'kiwala gayanh'than, bala ŋayipiny Djesuny ŋal'yurra ŋurikalyiny warrakan'kalnydja ḏiltjilila, bala marrtjin nhinanan. ");
INSERT INTO djr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ga dharrwaynha yolŋuynydja walal marrtjin ŋunhi girriny' mala walalaŋguwuy gayanh'thaŋala ŋunhawalnydja ŋunhi dhukarrlilnydja. Ga wiripuwurruynydja yolŋuy walal marrtjin marran dharpan ḏiwirrkthurr, ŋulatjarryin wäŋakurra, ga bitjarryi bili walal marrtjin ŋunhi rarr'yurr gayanh'thany balany dhukarrlilnydja. ");
INSERT INTO djr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ga ŋunhiwurrnydja yolŋu walal ŋunhi walal marrtjin wäŋgaŋal gumurrkurrnydja nhanukalaŋuwurr, ga munguyurr walal ŋanya marrtjin, yatjunminan walal marrtjin ŋunhi yulŋuny, märr-yiŋgathinan, goŋmirriyinan nhanukal bitjarra, “Yo, yo-o-o Marrkapmirr! Go walŋakuŋun ŋanapurruny. Bili nheny ga dhuwali marrtji Garraywala yäkuynydja, ŋuriŋin God-Waŋarrwala ŋayaŋu-yal'maranhamirriynha romdhuny. ");
INSERT INTO djr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Galkin ŋanapurr dhu dhuwal nhinany ŋunhiliyin manymakŋura romŋurnydja, bitjarr nhakun ŋunhi ŋanapurruŋ gan mala-ŋurrkanhayŋu Geŋ-Daybit nhinan. Go limurr märr-yiŋgathirra, goŋmirriyirra God-Waŋarrwala,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yurr ŋayipiny gan ŋunhi Djesuny marrtjin yan baḏak, ga yan bili, ga ŋunhala Djurutjalamnha bala yan ŋayi gulŋiyinan buku-ŋal'yunamirrilila buṉbulil. Ga ŋunhalnydja ŋunhi djinawany' ŋayi marrtjin nhäŋala ḻiw'maraŋala warrpam'thurra. Yurr ŋunhi waluynydja ŋuruŋun ḻäy-bilyunaraynha nyumukuṉiny'thun waluy. Bala yan ŋayi Djesuny ga malthunamirrnydja mala nhanŋu 12-tja roŋiyinan Bithinilila. ");
INSERT INTO djr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ga djaḏaw'yurr wiripun walu, bala walal ḻaw'yurra beŋuryiny Bithiniŋurnydja, ga ŋayiny Djesuny balanyamirriy djaṉŋarrthinan. ");
INSERT INTO djr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bala ŋayi nhäŋala dharpan muthir'nha ŋayi gan dhärran galki dhukarrŋur; yuṯan gan ḏukitjtja marrany ŋuthar, ga ŋunhi ŋayi nhäŋalnydja Djesuynydja, bala ŋayi marrtjin galkithinan balayin dharpalila wanha balaŋ ŋayi ŋula maḻŋ'maranha ŋatha dhakal ŋunhiwiliyi. Yurr bäyŋun ŋayi ŋunhi maḻŋ'maranhany dhakalnydja, marwatnha yan marrtjin gorruŋal, bili bäyŋu yan muka nhanŋu ŋurikiny dharpaw waluny galkithinya borumdhinyarawnydja. ");
INSERT INTO djr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bala ŋayi Djesuny waŋanan ŋurikiyiny dharpawnydja bitjarra, “Bäyŋun dhu boŋguŋ ŋula yolthuny yolŋuy buluny ḻuki nhokuŋuny borum.” Bitjarra ŋayi ŋunhi Djesu dhäruk-gurrupanminany ŋurikiyi dharpawnydja. Ga walalnydja ŋunhi malthunamirriynydja mala nhanukal ŋäkul ŋanya ŋunhi nhaltjarr ŋayi waŋan. ");
INSERT INTO djr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Manymak, wäŋgaŋalnydja walal marrtjin bala-a-a-a burnha bunan Djurutjalamnha, Ga dhunupan yan ŋayiny Djesuny marrtjinan balayin ŋunhi buku-ŋal'yunamirrilila Buṉbulil God-Waŋarrwala. Ga ŋunhiliyi yolŋu walal gan wiripuŋuwuy wäŋapuy buku-djuḻkmaranhamin rrupiya, ga djalim walal gan mundhurr-gurrupanaraw warrakan' mala. Bala dhunupan ŋayi marrtjin ŋunhi Djesuynydja djalkthurra rrupiya-djambimirriwnydja daybuḻnydja mala, ga nhinanhawuynydja mala yolŋuwnydja walalaŋ warrakan' djalimmirriwnydja mala. ");
INSERT INTO djr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ga gulmaraŋala ŋayi gan ŋunhi yolŋunhany walalany ŋunhi walal gan gäŋal ŋula nhä mala ŋuliwitjarryi ŋunhi buku-ŋal'yunamirriwurr buṉbukurr. ");
INSERT INTO djr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bala ŋayi gan ŋunhi marŋgikuŋala yolŋu'-yulŋunhany bitjarra, “Dhuwandja God-Waŋarrwalnydja ga djorray' lakaram bitjan warray gam', ‘Ŋarrakuny dhu ga buku-ŋal'yunamirr buṉbu dhärra buku-ŋal'yunaraw yan waŋganygu, märr dhu ga bukmak bäpurru mala marrtji ga bukumirriyam walal dhu ga dhiyal.’ Ga nhumany dhuwandja buṉbuny wakalkuŋal warray, bitjarra nhakun dhuwandja buṉbu ḻuŋ'maranhaminyarawnha manaŋa-ḏilkurruwnha djuḻuḻ'yunaraw, bitjandhin nhumany ga dhuwal.” ");
INSERT INTO djr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ga walalnydja ŋunhi ŋurruŋu djirrikaymirriynydja yolŋuy walal ga rom-marŋgikunhamirriynydja mala gan ŋäkula ŋanya Djesuny balanyawuyyiny waŋanhawuy, bala walal gan waŋanhaminan dhurrwara-ŋurrkanhaminan wanhawitjan dhukarrkurr walal dhu buma ŋanya Djesuny. Yurr walal gan ŋunhi nhanŋuwuynydja Djesuwnydja barrarin. Ga walalnydja gan ŋunhi yolŋuynydja walal Djesunhany ṉirr'yurra ŋäkul ŋunhi nhaltjarr ŋayi walalany gan marŋgikuŋal. ");
INSERT INTO djr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga ŋunhi marrtjin wäŋany munhawuyin, bala walal ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu marrtjinan beŋuryiny Djurutjalamŋurnydja wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ga wiripuŋuynha waluy, yurr munhawumirra, walal marrtjin bala wäŋgaŋala, dhukarrkurra. Bala walal nhäŋala ŋunhiyiny dharpa muthirny'tja räwaknha gan dhärran warrpam'nha ḻuku manapara. ");
INSERT INTO djr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bala ŋayi Betaynydja guyaŋanan, bala ŋayi waŋanan bitjarra, “Way Garray nhäŋu ŋathil ya-dhuwali, dhuwaliyin ŋunhi dharpany ŋunhi nhe dhä-waŋa, dhuwaliyin ŋayi yulŋuny räwaknha warrpam'nha,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ga ŋayiny Djesuny nhanŋu waŋan bitjarr, “Märr-yuwalkthi God-Waŋarrwal. ");
INSERT INTO djr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Märr-yuwalk ŋarra ga dhuwal lakaramany nhumalaŋ, ŋuli nhe dhu waŋa bukunhany ŋula wäŋanhany bitjandja gam', ‘Ma! rur'yurra nheny dhuwaliyiny bukuny wäŋa ga giṯthurra balan gapulila ḻupthurra,’ bala ŋayiny dhu ŋunhi dhunupan ŋunhiyiny bukuny giṯthunna yan. Ga ŋuli nhe dhu ŋunhi ŋula yol yolŋu waŋa ŋayaŋuy märr-yuwalkthinyaraynydja, ga yakan nhe dhu ŋunhi ŋula märr-dhumbal'yundja, nheny dhu nhäman ŋunhi nhuŋuny ŋayi dhu balanyayiny rom maḻŋ'thunna yan. ");
INSERT INTO djr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ga dhiyakiyin ŋunhi märrwu ŋarra ga nhumalaŋgal dhuwal lakaramany bitjandja gam', ŋuli nhe dhu ga bukumirriyamany God-Waŋarrwalnydja ŋäŋ'thundja ŋanya ŋula nhakuny, yanan biyakun märr-yuwalkthin, ga biyakun guyaŋiny ‘Ŋarrany dhuwal bilin nhanukuŋ ŋunhiyiny märraŋala,’ bala God-Waŋarryuny nhuna dhu gurrupanna yan ŋunhiny mala ŋunhi nhaku nhe ŋanya ŋäŋ'thurr.” ");
INSERT INTO djr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Ga ŋuli nhe dhu ŋunhi bukumirriyanharawnydja djälthirr, nheny ŋathil ŋurruŋuny bäy-lakaraŋ ŋurikiyi yolŋuw ŋunhi ŋayi nhuna ŋayaŋu-miḏikumar, ga yorrnha nhe dhu ŋunhi bukumirriyamany, märr ŋayi dhu nhokal djiwarr'puyyuny Bäpa'mirriŋuy bäy-lakaramdhi nhuŋuny. ");
INSERT INTO djr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ga ŋuli nhe dhu ŋunhi yakany bäy-lakaram wiripuŋuwnydja yolŋuw, ŋayiny dhu ŋunhi God-Waŋarryuny bäyŋuyi yan bäy-lakaram nhuŋuny yätjkurruwuy djämapuy.” ");
INSERT INTO djr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yo marrtjinany walal gan bala-a-a, ga yan bili ga Djurutjalamnha, bala ŋayi Djesuny dhunupan gärrinan ŋunhiwiliyin buku-ŋal'yunamirrilila buṉbulil. Ga walalnydja ŋunhi ŋurruŋu djirrikaymirrnydja yolŋu walal ga ŋurru-warryunayŋuny yolŋu mala ga rom-marŋgikunhamirriynydja mala, guwatjmara ŋanya Djesunhany. ");
INSERT INTO djr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bala walal gan dhä-birrka'yurra ŋanya bitjarra, “Go mak lakaraŋ napurruŋgal, … yolthu nhuna dhuwal waŋanany balanyarawyiny djämaw? Ga yolthu nhuna dhuwal waṉa-nhirrparnydja?” ");
INSERT INTO djr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Bala ŋayiny Djesuny buku-bakmaraŋal balany walalaŋguny bitjarra, “Ŋurruŋuny ŋathil ŋarra dhu nhumalany dhä-birrka'yun. Nhuma ŋathil dhu lakaramany ŋarraku, ga yorrnha ŋarrany dhu nhumalaŋ lakaram ŋunhi yolthu ŋarrany waŋan dhiyak djamaw. ");
INSERT INTO djr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yolthu ŋunhi nhirrpar Djonnhany yolŋuny? Ga yolthu ŋanya ŋunhi waŋan ḻiya-ḻupmaranharaw yolŋuwnydja walalaŋ? God-Waŋarryu? Ŋany yolŋuy walal muka?” ");
INSERT INTO djr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bala walalnydja ŋunhi ŋurruḏawalaŋuny mala waŋanhaminan bitjanminan, “Way, nhaltjanna dhika limurrnydja dhu lakaram balany nhanŋuny buku-bakmaram? Ŋuli limurr dhu ŋunhi bitjandja lakaram gam', ‘God-Waŋarryu ŋayipi yan Djonnhany waŋan,’ bitjandja, bala ŋayiny dhu ŋunhi waŋa limurruny bitjanna, ‘Nhakun nhumany ŋunhi yakany märr-yuwalkthinya nhanŋuny Djongalaŋuwnydja dhärukku?’ bitjanna ŋayiny dhu. ");
INSERT INTO djr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ga ŋuli limurr dhu ŋunhi lakaram nhanukal bitjandja, ‘Yolŋu'-yulŋuy ŋanya ŋunhi waŋan ŋurikiyiny djämaw,’ bitjandja, ga walalnydja dhu ŋunhi wiripuwurrnydja yolŋu walal maḏakarritjthirra limurruŋgun. Bili walalnydja ga ŋunha bitjan märr-yuwalkthirr ŋunhi ŋayiny Djondja dhuwal God-Waŋarrwu warray djawarrkmirr.” ");
INSERT INTO djr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bala walal waŋanan Djesuwnydja bitjarra, “Yaka dhuwal napurrnydja marŋgi bay, yolthu ŋanya ŋunhi Djonnha nhirrpar ŋurikiyiny djämaw.” Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋguny bitjarra, “Yo. Ga ŋarrany dhu yakayi nhumalaŋguny lakaram, ŋunhi yolthu ŋarrany dhiyak djämaw nhirrpar.” Ga bitjarra ŋayi ŋunhi Djesuny waŋan walalaŋguny. ");
INSERT INTO djr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ga dhäŋur beŋuryiny ŋayi Djesuy buluyi nhakun lakaraŋal dhäwu mayali'kurr ŋurikiwurruŋgalyi yolŋuwal walalaŋgal, ga dhuwal ŋayi gan ŋunhi dhäwuny' lakaraŋal gam', “Ŋunhiliyi yolŋu gan nhinan wäŋa-waṯaŋu, bala yan ŋayi ŋunhiyiny yolŋu wäŋa-waṯaŋuny djälthinan ŋayi dhu ga ŋuthanmaram ŋamakurr borum mala. Bala ŋayi lämu-nhirrpara ŋunhiwiliyiny wäŋalil borumnha mala dharpan. Ga djäma ŋayi ŋunhi munatha' ŋurikiyi ŋathaw buḻŋu'kunharaw, bala ŋayi ḻoḻuwunuŋala ŋunhiyi wäŋany. Ga djämayi ŋayi wäŋa mil'ŋuwnydja yolŋuw nhinanharawnydja. Ga dhäŋur beŋuryiny ŋayi djarr'yurra yolŋunhan walalany ŋurukiyin djägawnha, djägamirriyaŋala walalany, märr walal dhu ga djäman, ga bäkin ŋunhiyiny nhä mala bukmak yurr guwarr yan, märr ŋayi dhu ŋunhiyiny wäŋa-waṯaŋuny yolŋu marrtjin wiripuŋulila wäŋalil, yurr märr wiyinnha ŋayi dhu ŋunhi marrtjiny. Bala ŋayi waŋanany djägamirriwalnydja walalaŋgal bitjarra, ‘Dhiyakuny nhuma dhu ga djäga ŋamatham yan ŋarrakalaŋaw, ga ŋunhi ŋayi dhu balwurthirrnydja borumdja mala, ga nhumany dhu ŋunhi mala-wulkmaraman ŋarrakuny gänaŋulila.’ Bala yan ŋayi marrtjinan ŋunhiyiny wäŋa-waṯaŋuny yolŋu wiripuŋulila wäŋalil.” ");
INSERT INTO djr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Yo. Nhinanany ŋayi gan ŋunhiyi wäŋa-waṯaŋuny yolŋu, yan bili ga walu marrtjin galkithin borumguny ŋurikiny borumdhinyarawnha, bala ŋayi wäthurra waŋganygun yolŋuw djämamirriwnha, bala ŋayi ŋanya djuy'yurra, märr ŋayi dhu märraman wapmaraman nhanŋuny borum mala. ");
INSERT INTO djr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ga walalnydja ŋunhi ŋuriŋiwurruynydja borum-djägamirriynydja walal nhäŋala ŋanya ŋunhiyiny yolŋuny, bala yan walal ŋanya ŋayathaŋala bumara ŋanya marrtjin, ga djuy'yurrnydja walal ŋanya roŋanmaraŋalnydja dhäparŋ'nha goŋ-waŋaran.” ");
INSERT INTO djr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Ga bitjarryi bili ŋayi wiripuŋunhany yolŋuny djämamirriny djuy'yurr. Ga walalnydja ŋanya ŋuruŋiwurruyyi bili yan bumar bururr'yurr dhika, muḻkurr yan walal ŋanya wutthurr maŋgu'wu. Bala walal ŋunhi djuy'yurrnydja ŋanya bitjarryi bili yan goŋ-waŋarayi yan. ");
INSERT INTO djr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ga bulu ŋayi djuy'yurr wiripuŋunhany muka djämamirriny, ga walalnydja ŋanya bumar dhä-murrkay'kuŋala yan dhiŋganhamaraŋala. Ga märr dharrwanhan walal gan ŋunhi bitjarryiny bumar, wiripuwurruny walŋakuŋal, ga wiripuwurrunhany rakunyguŋala yan, warrpam'thurr yan walalany bumar.” ");
INSERT INTO djr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Bala ŋayi ŋuriŋiyi wäŋa-waṯaŋuynydja yolŋuy djuy'yurr bulu waŋganynhan yolŋuny, ŋunhiyin gäthu'mirriŋunhan nhanŋuwuy ŋayi waŋganynhan yan, märr walal dhu nhanŋun märr-ŋal'yundja. ");
INSERT INTO djr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ga ŋunhi walal nhäŋalnydja ŋanya ŋuriŋiwurruyyiny borum-djägamirriynydja yolŋuy walal, bala walal waŋanhaminany bitjanminan, ‘Way, dhuwandja ŋunhi yolŋu ŋunhiyin muka? … gäthu'mirriŋun ga räli marrtji, go limurr ŋanya buman murrkay'kuman, märr dhu dhuwandja wäŋa limurruŋguwuynha,’ bitjanminan. ");
INSERT INTO djr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bala walal yan ŋunhiyiny gäthu'mirriŋunhany nhanŋu ŋayathaŋala, ga bumarnydja walal ŋanya ŋunhi dhiŋganhamaraŋala yan, ga rumbalnydja walal ŋanya ŋunhi ŋurrkaŋala dhawaṯmaraŋala warraŋullila, beŋuryiny ŋunhi borummirriŋurnydja wäŋaŋur.” ");
INSERT INTO djr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bala ŋayi dhäŋur beŋuryiny Djesuy dhä-birrka'yurra walalany bitjarra, “Nhaltjanna ŋayi dhu ŋunhi ŋuriŋiyi wäŋa-waṯaŋuynydja? Bitjanna ŋayi dhu ŋunhi gam', marrtjiny ŋayi dhu ŋunhi, ga dhunupan ŋayi dhu buman murrkay'kuman ŋunhiwurrunhany yolŋuny walalany djägamiriwnhany mala, bala yan ŋayi dhu ŋunhiyiny wäŋany gurrupan wiripuwurruŋgala yolŋuwal walalaŋgal djägalil.” ");
INSERT INTO djr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Bitjan muka ŋayi ga ŋunha djorra'ŋurnydja lakaram gam', ‘Bala'-dhuḻ'yunamirriy mala yolŋu'-yulŋuy marrtjin ŋal'maraŋal guṉḏa, walal dhu dhuḻ'yun bala', ga ŋunhiyi waŋganydja guṉḏa walal nhäŋal, bala nyamir'yurra, bala walal yan ŋurrkaŋala. Yurr God-Waŋarryuny walalaŋguŋ ŋunhiyiny guṉḏa ŋurrkanhawuynydja märraŋal, bala nhirrpara balaw'nha ŋunhiyiny ḻukun yuṯuŋgurrwun dhärranharawnha. ");
INSERT INTO djr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ga bitjarryin ŋayi gan ŋunhi God-Waŋarryu djämany, ga ŋunhiyiny nhakun mirithirra yan ŋayaŋu-ganyim'thunamirra limurruŋguny nhänharaw.’” Ga bitjarr ŋayi gan ŋunhi Djesuy lakaraŋalnydja mayali'wurrnydja. ");
INSERT INTO djr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ga walalnydja ŋunhi ŋuriŋiwurruyyiny ḏilkurruwurruynydja yolŋuy walal dharaŋara yan ŋunhi mayaliny', ŋunhi ŋayi gan Djesuy lakaraŋalnydja walalanhan, bala yan walal dhunupan guyaŋanan ŋayathanharawnha nhanŋu Djesuwnydja. Ga birrka'yurr walal gan ŋunhi ŋayathanharaw nhanŋu, yurr bäyŋun, bili walal gan ŋunhi barrarinan yolŋuwnha walalaŋ. Bala yan walal ŋanya ganarrthaŋala, bala wäŋgaŋala. ");
INSERT INTO djr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bala walalnydja gan ŋunhi Baratjiny yolŋu walal ŋayan'mirra nhinan nhanŋuny Djesuwnydja. Bala yan walal djuy'yurra wiripuwurrunhan ḏirramuwurruny, ŋunhiwurrunhan ŋunhi djuŋga'-djuŋgayany Yaritkun, märr walal ŋanya dhu ga mayali'-gäma dhä-birrka'yun, märr ŋayipiny dhu ŋunhi dhä-maraŋgunhamirra. ");
INSERT INTO djr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bala walal ŋunhi wäŋgaŋalnydja balayin nhanukala Djesuwala. Ga waŋanany walal nhanŋu Djesuwnydja bitjarra, “Way Marŋgikunhamirr, napurrnydja dhuwal marŋgi nhuŋu, ŋunhi nheny ŋuli ga waŋa dhunupan yan dhäruk, ga dhunupa mala-djarr'yunamirr nhe yolŋu, bili nheny ŋuli ga ŋunhi djäma rrambaŋiyam yan nhä mala bukmakku. Ga marŋgikumany nhe ŋuli ga ŋunhi yuwalk yan God-Waŋarrwu warray dhukarrnydja. Go mak napurruŋgal lakaraŋun. Nhä dhuwal dhunupa limurruŋ ŋunhi limurr dhu ga rrupiyany gurrupan mundhurryu-wumany ŋunhiyiny ŋunhi ŋurruŋunhany buŋgawany Rawumbuywuny wäŋapuywu mala yäkuny Djetjanhany? Nhaltjan limurr dhu yulŋuny? Gurrupan? Ŋany nhaltjan?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yurr ŋayipiny Djesuny marŋgithin walalaŋ ŋäthil yan, ŋunhi walal gan mayali'-wilkthurr ŋanya, bala ŋayi waŋanan walalaŋ bitjarra, “Nhaku nhuma ŋarrany ga dhuwal birrka'yundja. Go gurrupul walal ŋarrakal rrupiya ŋaraka, ŋarra mak nhäma.” ");
INSERT INTO djr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bala walal gurrupara nhanukal. Bala ŋayiny Djesuynydja dhä-birrka'yurra walalany bitjarra, “Yol dhuwandja wuŋuḻi' ga yäku dhiyalnydja gay'yi rrupiyaŋur ŋarakaŋur?” bitjarr. Ga walalnydja buku-bakmaraŋal nhanŋuny bitjarr, “Dhuwaliny yäku ga mali' ŋunhiyin ŋurruŋun buŋgawa yäku Djetjan,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ga ŋayiny Djesuny walalaŋ bitjarra waŋan, “Nhumany roŋanmaraŋun gurrupul nhä malany nhanŋuny ŋurikiyiny ŋurruŋuwnydja buŋgawaw, ga biyakiyi bili roŋanmaraŋdhi gurrupul ŋunhi ŋula nhä malany nhanŋuny God-Waŋarrwuny.” Bala walal ŋuriŋiwurruyyiny mayali'-gänhamirriynydja yolŋuy walal ŋäkulnydja ŋanya Djesunhany dhäruktja ṉirr'yurra. ");
INSERT INTO djr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Manymak walalnydja gan ŋunhi Djatutjiynydja yolŋuy walal yaka märr-yuwalkmirrinya ŋunhi dhu gi yolŋu walal walŋathi beŋur ŋunhi dhiŋganhaŋur. Bala walal dhuwalawurryiny yolŋu walal marrtjinan balan Djesuwala ga waŋan walal ŋanya bitjarr, ");
INSERT INTO djr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Way Marŋgikunhamirr, Mawtjitjthuny ŋunhi rom rulwaŋdhurr bitjarr warray gam', ‘Ŋunhi dhu ḏirramuny dhiŋgam yothumiriwnydja, nhakun bäyŋuny nhanŋu ŋula walkur, bala nhanukal dhu ŋunhi yukuyuku'mirriŋuynha märram nhanŋu ŋunhi miyalknhany? … märr ŋayi dhu ŋuriŋiyiny miyalkthuny yothuny gäma ŋuruki bili yan ŋunhi dhiŋganhawuywu ḏirramuwnydja.’ ");
INSERT INTO djr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Manymak. Waŋganymirrnydja ḏirramuwurr gan wäwa'manydjiwurra nhinan 7, ga ŋayiny ŋuriŋiyiny maḻamarryuny wäwa'mirriŋuynydja märraŋal miyalknhan, bala ŋayi ŋunhi ḏirramuny dhiŋgaŋala yothumiriw yan. ");
INSERT INTO djr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ga beŋuryiny wiripuŋuynha yukuyuku'mirriŋuynha malpuraynha märraŋal ŋunhiyi miyalknhany, bala ŋayiny muka bitjarryi bili yan dhiŋgaŋal yothumiriwyi yan. Ga bitjarryi bili ŋunhi maḻŋ'thurr nhanŋuny dhä-gandarrpuywuny. ");
INSERT INTO djr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ga balanya bili yan walalaŋ gan ŋunhi maḻŋ'thurrnydja. Ga yalalan dhuḏi-yapalan ŋayiny miyalktja dhiŋgaŋal. ");
INSERT INTO djr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ga ŋunhi dhu boŋguŋ God-Waŋarryu walŋakuŋuny yolŋunhany walalany beŋurnydja ŋunhi dhiŋganhaŋurnydja, bala yolkun ŋayi dhu ŋunhi miyalktja? … bili ŋayi gan ŋunhi nhinanany beŋur bili ŋurruŋuwal wäwa'mirriŋuwal ga yukuyuku'mirriŋuwal wapthurr.” ");
INSERT INTO djr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Bala ŋayiny Djesuny buku-bakmaraŋala walalaŋ bitjarra, “Bukmak yan nhuma dhuwal djarrpi'mirr! Bäyŋu yan nhuma marŋgi ŋunhi nhaltjan ga djorray' ŋuli marŋgikum. Ga yaka yan nhuma marŋgi ŋurikiyiny ŋunhi ganydjarrwu Godkalaŋawnydja. ");
INSERT INTO djr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ŋunhi ŋayi dhu boŋguŋ God-Waŋarryu walŋakuŋuny gi yolŋunhany walalany dhiŋganhaŋurnydja, ga bäyŋun walal dhu gi ŋunhi buluny nhakun märranhamirr. Ŋunhiyiny walal dhu balanyan nhakun ŋunhan ŋunhi God-Waŋarrwun djiwarr'puynha yolŋu walal nhanŋun djämamirr mala. ");
INSERT INTO djr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Marŋgi muka nhuma dhuwal bili, ŋunhi dhu gi yolŋuny walal walŋathi dhiŋganhaŋurnydja. Ga marŋgi nhuma ŋunhi dhäwuw Mawtjitjkalaŋuwuynydja ŋunhi ŋayi nhäŋal gurtha ŋäṉarr ŋayi gan nhäran marraŋur dharpaŋur. Ŋunhiny ŋayi God-Waŋarr waŋan bitjarra gam', ‘Ŋarrany dhuwal God-Waŋarr Yipurayimgu ga Yitjakku ga Djaykupku.’ ");
INSERT INTO djr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yaka ŋayi ŋunhi God-Waŋarr rakunymirriwnydja yolŋuw walalaŋ, ŋany walŋamirriwnha yan. Guyaŋanhawuynydja nhumalaŋguŋ dhuwal djarrpi' warrpam'.” ");
INSERT INTO djr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Manymak ŋunhiliyi gan waŋgany yolŋu Rom-marŋgikunhamirr nhinan, ŋäkul ŋayi gan Djesuny ŋunhi nhaltjarr ŋayi gan buku-roŋanmaraŋal walalaŋ Djatutjiw malaŋuw, bala ŋayi bitjarra guyaŋanany, “Manymak nhanukuŋ dhuwal dhäruktja buku-roŋanmaranhawuynydja.” Bala ŋayi dhä-birrka'yurra Djesunhany bitjarra, “Nhä dhuwal ŋurruŋuny gal'ŋu dhäruk-nhirrpanminyawuy ga dharrpalnydja mirithirrnydja rom?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ga ŋayiny Djesuny waŋan bitjarra gam, “Ŋäkun nhumany Yitjuralyuny bäpurruy yolŋuy walal. Garraynydja limurruŋ ŋunha waŋgany yan ŋayipi God-Waŋarrnydja. ");
INSERT INTO djr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nheny dhu ga ŋunhi märr-ŋamathirrnydja nhanŋu Garraywuny God-Waŋarrwuny bukmakthu yan nhokiyingal nhe ḏoṯurrkthuny ga walŋaynydja ga ganydjarryuny ga guyaŋanhawuyyuny.” ");
INSERT INTO djr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ga wiripuny ŋunhi dharrpal dhäruk-nhirrpanminyawuy rom dhuwanna gam', “Märryu-ḏapmaraŋ, ga märr-ŋamathi gi ŋunha wiripuwurruŋguny yolŋuw walalaŋ, biyak nhakun nhe ŋuli ga ŋunhi märr-ŋamathirr nhuŋuwuy nhe. Bäyŋun gi ŋunhi ŋula wiripuny dhäruk-nhirrpanawuy rom mala dhambay-manapul dhiyakalnydja maṉḏaŋgal, bili dhuwanna maṉḏany ŋunhi märrman' buluny gal'ŋu mirithirrnydja ŋurruŋu ga dharrpal rom.” ");
INSERT INTO djr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bala ŋunhi Rom-marŋgikunhamirrnydja yolŋu waŋanan bitjarra Djesuwnydja, “Marŋgikunhamirr dhunupa nhe ga dhuwaliyi waŋa bitjandhiyiny. ");
INSERT INTO djr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yuwalk yan napurr dhu ga ŋunhi märr-ŋamathirrnydja God-Waŋarrwuny bukmakthu yan napurruŋgal ḏoṯurrkthuny ga ṉurrkuynydja ga ganydjarryuny. Ga bitjandhi bili napurr dhu ga ŋunhi märr-ŋamathirryi ŋunha wiripuŋuwnydja yolŋuw walalaŋ, bitjan nhakun napurr ŋuli ga napurruŋguwuy napurr märr-ŋamathirr. Dhuwanna ŋunhi mirithirrnydja ŋurruŋuny rom maṉḏany, ŋunhi ga bulun djuḻkmaram nhä mala ŋunhi limurr ŋuli djäma mundhurr-wurrupan God-Waŋarrwu.” ");
INSERT INTO djr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ga ŋunhi ŋayi Djesuy ŋäkulnydja ŋunhi ḏirramunhany ŋayi gan waŋan dhärukthu djambatjthuny, bala ŋayi nhanŋu bitjarra buku-bakmaraŋalnydja, “Nheny dhuwal yakan barrku beŋurnydja ŋunhi Godkalaŋaŋurnydja Romŋur.” Ga bäyŋun walal ŋula buluny dhä-wapthuna waŋanha ŋanya. ");
INSERT INTO djr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ga ŋunhi ŋayi gan Djesuy marŋgikuŋalnydja ŋunhiliyiny buku-ŋal'yunamirriŋurnydja buṉbuŋur, ga waŋan ŋayi bitjarr, “Nhaku walal ŋuli ga ŋunhi Rom-marŋgikunhamirriynydja walal lakaram ŋunhi dhuwal Maŋutji-dhunupayanhawuynydja yolŋu maḻŋ'thurr beŋur Daybitkal yarraṯaŋur? ");
INSERT INTO djr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bili ŋayi ŋunhi Dhuyu-Birrimbirrnydja waŋan nhanukalnydja Daybitkalnydja, bitjarr, ‘God-Waŋarrnydja waŋan ŋarrakalaŋuwalnydja Garraywal bitjarr, “Nhininy dhiyala dhunupa'ŋuŋura gali'ŋurnydja, ga bäy ŋarra dhu miriŋuny mala nhuŋu galkirrinyamaram warrpam', bala nhe dhu ga ḻuku-worruman walalaŋgal.” ’” ");
INSERT INTO djr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Ga ŋayiny gan ŋunhi Daybitthuny ŋunhiyinhany Maŋutji-dhunupayanhawuynhany yäku lakaraŋal ‘Garray’ bitjarr, yurr nhakun ŋayiny nhanŋu ŋunhi Maŋutji-dhunupayanhawuynydja Daybitkuny Gäthu'mirriŋu.” Ga walalnydja gan ŋunhi wiripuwurruynydja yolŋuy walal dharrwaynydja ŋäkulnydja ŋanya Djesunhany waŋanhawuynydja, bala walal yan mirithinan dhika galŋa-djulŋithinany dhärukthuny nhanukal. ");
INSERT INTO djr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ga ŋunhi ŋayi gan Djesuy baḏak yan marŋgi-gurrupar walalany, bala ŋayi bitjarra waŋan. “Djäga nhuma dhu ga ŋunhi Rom-marŋgikunhamirriwnydja yolŋuw walalaŋ. Walalnydja ŋunhi djäl walal dhu ga wäŋgam girri' wiyinmirr mala dhukarrkurr, märr dhu ga yolŋu mala walalaŋ wokthun. ");
INSERT INTO djr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ga ŋunhi walal ŋuli marrtji Djuw malawal buku-ḻuŋ'maranhamirrililnydja buṉbulil, walalnydja ŋuli ŋunhi nhinany manymakŋura yanan nhinanhawuyŋurnydja. Ga bitjandhi bili walal ŋuli ŋunhi ḻuŋ'maranhamirr marrtji ŋathalilnydja, walalnydja ŋuli nhinany manymakŋura yan nhinanhawuyŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yurr walal ŋuli ga ŋunhi manaŋirra yulŋuny buku-gurthapuywun miyalkkurruwurruŋ ŋula nhäny mala. Bala beŋuryiny walal ŋuli ga bukumirriyamany wiyinnha dhika, yan ga milkunhamirra walalawuynha walal. Ga ŋayiny dhu boŋguŋ ŋunhi God-Waŋarryuny walalany dhä-gir'yurrnydja mirithin yan.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ga beŋuryiny ŋayi gan Djesuny nhinan ŋunhala Buku-ŋal'yunamirriŋura buṉbuŋur, ŋunhiliyin galkin yanan ŋunhi gan banikin' maṉḏany dhärran rrupiyapuy, nhäŋala ŋayi gan yolŋunhan walalany walal marrtjin rrupiya djalkthurr mundhurrnha nhanŋun God-Waŋarrwun. Ga dharrwa gan yolŋu ḻukunydja mala wäŋgaŋal ga rarr'yurr walal marrtjin rrupiya ŋunhiwiliyi banikin'lil dharrwa mirithirr. ");
INSERT INTO djr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Manymak, ga ŋayiny waŋgany miyalk yurr ŋurruwuyk marrtjin ga rulwaŋdhurr ŋayi märrma' yan ŋaraka rrupiya yurr nyumukuṉiny maṉḏany yaka ŋula yindi. ");
INSERT INTO djr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bala ŋayi Djesuynydja ḻuŋ'maraŋala nhanŋuwuy ŋayi malthunamirrinhany mala bala ŋayi lakaraŋalnydja bitjarra, “Märr-yuwalk ŋarra nhumalaŋ dhu dhuwandja lakaram. Dhiyaŋuny miyalkthu bulu warray rulwaŋdhurr, djuḻkmaraŋal ŋayi wiripuwurruŋguŋuny gurrupanawuy. ");
INSERT INTO djr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bili ŋayiny dhuwandja ŋunhi mirithirra yan ŋurruwuyknha, ga gurruparnydja ŋayi ŋunhi warrpam'thurra yanan. Ga bäyŋun gi ŋula ŋorri nyumukuṉiny'tja nhanŋuwuynydja nhakun.” ");
INSERT INTO djr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ga ŋunhi ŋayi Djesu marrtjinany ganarrthaŋalnydja ŋunhiyiny buku-ŋal'yunamirrnydja buṉbu, ga ŋayiny waŋganydja nhanŋu malthunamirr waŋan bitjarra, “Way Marŋgikunhamirr, nhäŋu ŋathil dhuwal buṉbu ya-dhuwal. Nhän dhuwandja yindin mirithirra ga latjun' muka?” ");
INSERT INTO djr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ga ŋayiny Djesuny waŋan bitjarr, “Nhäma nhuma ga dhuwal yindimirr buṉbu mala. Galki dhu dhuwal yolŋuynydja ḏaw'maraman buḻ'waŋmaraman. Bäyŋun dhu ga ŋula waŋganydja guṉḏa ŋorra ŋapa-ŋal'-ŋalmaranhawuynydja.” ");
INSERT INTO djr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ga dhäŋur beŋuryiny ŋayi Djesuny gan nhinanan ŋunhala bukuŋura yäkuŋur Wolipnha, ŋunhi maṉḏa gan ḻaypa'yunmin ŋunhiyi buku-ŋal'yunamirr buṉbu. Bala walalnydja Betany ga Djayimdja ga Djondja ga Wanduruny marrtjinan guwatjmara ŋanya, bala walal dhä-birrka'yurra ŋanya gayulnha bitjarra, ");
INSERT INTO djr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Way, Marŋgikunhamirr, nhätha ŋayi dhu dhuwaliyi mala bitjandhiyiny maḻŋ'thun?” ");
INSERT INTO djr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Bala ŋayiny Djesuny waŋan buku-bakmaraŋalnydja bitjarrnha, “Gatjuy bira'yurra walal gi nhininy, märr nhumalany dhu yaka muka ŋula yolŋuynydja mayali'-gamany. ");
INSERT INTO djr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Dharrwan dhu gi ŋunhi yolŋuny walal lakaranhamirrnydja nhumalaŋgalnydja yanbi walalnydja ŋarran. Ga bäkiny walal dhu gi ŋunhi yäkuny ŋarranhan, ga bawa'-gurrupulnydja walal dhu gi dharrwanhan yolŋunhany walalany.” ");
INSERT INTO djr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Ga ŋuli nhuma dhu ga miriŋuwuynydja bunhaminyawuy mala ŋäma dhipal banydjiwal, ga ŋunhawal bala barrkulil, yaka walal ŋuriŋiyiny mala ŋoy-gärri. Balanyayin mala dhu marrtji ŋunhi ŋurruŋuny maḻŋ'thun, yurr ŋunhiyiny yaka yan dhä-dhawar'yunamirrnydja walu. ");
INSERT INTO djr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yo, bawalamirriŋura wäŋaŋur ŋarakaŋur dhu marrtji ŋunhi bäpurruny mala bunhamirra, ga nhä mala ŋunhi rom dhuwalaŋuwuy munatha'wuy bitjandhi bili dhu marrtji bunhamirra. Ga yolŋuny walal dhu marrtji ŋunhi djaṉŋarryuny romdhu murrmurryurra. Yurr dhuwaliyiny ga ŋunhi ŋurruyirr'yunna ŋunhiyin ŋayaŋu-yätjinyamirra rom mala.” ");
INSERT INTO djr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Djägan nhumalaŋguwuy nhuma! Nhumalanhany walal dhu ŋunhi gäŋuny balan dhä-birrka'yunarawnha, bala walal dhu gi ŋunhi nhumalany bartjunmaraŋun ŋunhiliyin ŋunhi Djuw malawalnydja buku-ḻuŋ'maranhamirriŋur buṉbuŋur. Ga waŋiny nhuma dhu gi ŋunhi dhärriny gumurrŋura buŋgawawala walalaŋgal ŋunhi walal ga ŋayatham wäŋa malany, ga wiripuny buŋgawa ŋurruḏawalaŋun mala, bala nhuma dhu gi ŋunhi lakaraŋun nhumalaŋgiyingalaŋawuynha märr-nhirrpanminyawuynha, bili nhumany ŋuli ga ŋunhi ŋarraku warray malthun. ");
INSERT INTO djr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yurr, ŋurruŋuny ŋathil nhuma dhu lakaram dhäwu ŋarrakalaŋuwuy birrŋ'maram bukmakkal yan bäpurruwal, ga yorrnha dhu ŋunhi dhä-dhawar'yunamirrnydja walu buni.” ");
INSERT INTO djr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Ga ŋuli walal dhu ŋunhi nhakun ḏapmaramany nhumalany dhä-birrka'yunarawnydja, yaka warwuyurr ŋunhi nhaltjan nhe dhu waŋa, bili God-Waŋarryu nhunanhany dhu ŋunhi dhäruk gurrupan waŋanharaw. Yakan nhe dhu ga ŋunhi waŋa nhokiyingalnydja nhe dhärukthu, ŋunhiny dhu ga ŋayin Dhuyu Birrimbirrnha waŋa nhokalaŋawurrnydja dhärukkurr.” ");
INSERT INTO djr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Yo, ga wäwa'manydjiwurrnydja ga yapa'manydjiwurrnydja dhu gi gumurryu-gänhamirra walalanhawuynha miriŋuwala goŋlil. Ga biyakiyi bili walalnydja dhu gi ŋunhi bäpa'mirriŋuynydja mala ga ŋäṉḏi'mirriŋuynydja gi goŋ-gurrpulyi djamarrkuḻi'nhany mala walalaŋguwuy walal. Ga walalnydja dhu ŋunhi djamarrkuḻiny' biyakiyi bili yan ḏiltji-bilyurr ŋäṉḏi'mirriŋuwnydja ga bäpa'mirriŋuwnydja mala walalaŋgalaŋaw, bala walal dhu ŋunhi goŋ-gurrupulnydja maṉḏany bunharawnha rakunygunharawnha. ");
INSERT INTO djr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yo, bawalamirra dhu gi ŋunhi yolŋuny walal morrumurrun nhuŋuny, bili nhepiny dhuwali ŋarrakuwuynha yan yolŋu. Ga ŋuli nhe yolŋu dhu ga dhärra ḏälnydja yan, ga yan bili-i-i ga dhä-dhawar'yunamirriynha waluy, nheny dhu ŋunhi ŋunhiyiny yolŋu walŋathirra.” ");
INSERT INTO djr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Yo yalalaŋumirriynydja nhuma dhu ŋunhi nhäŋun ŋanyanhany ‘Ŋunhiyinhany Yätjkurrunhany’ ŋayi dhu dhawaṯthurra ŋunhi yaka muka ŋayi balaŋ yuwalktja maḻŋ'thunna ŋunhiliyiny.” (Ŋuli nhe ga nhämany dhuwandja dhäruk: birrka'yurr yan marŋgithi ga dharaŋul ŋunhi nhaltjan ŋarra ga mayaliy' lakaram!) “Yo ŋuli nhuma dhu gi ŋunhi nhini ŋunhalnydja Djudiyany wäŋaŋur balanyamirriyyiny waluy, nhumany dhu yanan waṉḏi'-waṉḏin balan bukulila. ");
INSERT INTO djr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ga ŋuli nhe dhu gi ŋunhi nhini warraŋulnydja wäŋaŋurnydja nhokiyingal nhe, yakan roŋiyiny gulŋiyi buṉbulilnydja ŋula nhäny girriny' mala nhuŋuwuy nhe wapmaraŋ, bäyŋun. ");
INSERT INTO djr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ga ŋuli nhe dhu gi ŋunhi djäma ŋatha guḻun'ŋurnydja, nheny dhu yakan roŋiyirr girriwny'tja nhokalaŋaw. ");
INSERT INTO djr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ga yätjkurrnydja dhu ŋunhi mirithirrnydja guḻunmirriwnha walalaŋ, ga bulu yothu-yalŋgimirriwnha mala. ");
INSERT INTO djr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gatjuy bukumirriyaŋun gi God-Waŋarrwala, märr ŋayi dhu ŋunhi yaka muka ŋunhiyiny mala maḻŋ'thurr dharratharramirriynydja waluy. ");
INSERT INTO djr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bili dhuwaliyiny ŋunhi mari dhu boŋguŋ maḻŋ'thurr yindin yan mirithirra, ŋunhi ŋayi bäyŋu balanyayi ŋäthil maḻŋ'thunna ŋuruŋ bala waluy ŋunhi ŋurruyirr'yunamirriy ŋunhi ŋayi God-Waŋarryu ŋamaŋamayurra dhuwal wäŋany munathany'. Ga dhäŋur beŋuryiny bala ŋayi dhu ŋunhi yakan buluny balanyayiny mari maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ga ŋuli ŋayi dhu boŋguŋ ŋunhi Garrayyu yakany waluny dhumbuḻ'kuŋ, ŋayiny dhu boŋguŋ ŋunhi bäyŋun ŋula yolnydja yolŋu gi walŋany nhini. Yurr God-Waŋarryuny boŋguŋ ŋunhiyiny walu gandarr-wutthurr dhumbuḻ'kuŋ, bili ŋayi ga nhäma ŋunhi yolŋuny mala nhanŋuwuy ŋayi gänaŋ'maranhawuynha walalany.” ");
INSERT INTO djr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ga ŋuli ŋayi dhu ŋula yol waŋi biyakuny gam', ‘Way, dhuwanna ŋunhiyiny Maŋutji-dhunupayanhawuynydja Yolŋu, nha' ŋunhan bala ya ŋunhan,’ biyakuny, yakan nhanŋu ŋurikiyiny märr-yuwalkthi. ");
INSERT INTO djr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bili dharrwan dhu ŋunhi nyäḻny'tja maŋutji-dhunupayanhawuy mala ga djawarrkmirr mala maḻŋ'thurr, ga marrtjiny walal dhu gi ŋunhi bala djäman marrtji ŋayaŋu-ganyim'thunamirra romdja mala, ŋunhi dhu gi bawalamirrinhan yolŋunhany walalany bilmaraŋ, ga wiripuny Garraywalaŋumirrinhan mala. ");
INSERT INTO djr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bili muka ŋarra ŋunhi nhumalaŋ dhuwalaŋuwuynydja ŋäthil yan lakaraŋal. Märr nhumany dhu ga ŋunhi djägan nhumalaŋguwuynydja nhuma manymakkuman.” ");
INSERT INTO djr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Manymak beŋurnydja ŋunhi dhurrwaraŋur yindiŋurnydja mariŋur; ŋayiny dhu ŋunhi waluny munha'yurra, ga ŋaḻindiny dhu gi ŋunhi bäyŋun buluny djeŋarra'yi. ");
INSERT INTO djr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ga ganyuny mala dhu ŋunhi warrpam'thurra burrul'yurra. Ga bukmaktja nhä malany ganydjarr ŋunha ŋunhi garrwarnydja dhu ḻarryurra marrtji, dhawaṯmaraŋun walalany dhu ŋunhi wäŋaŋurnydja mala walalaŋgal.” ");
INSERT INTO djr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ga dhunupan limurr dhu ŋunhi Yolŋunhany Gäthu'mirriŋuny nhäŋun ŋayi dhu marrtji yarrupthurrnydja räliny maŋandhun, yurr ganydjarryuny mirithirra yindiynha, ga djeŋarray'mirriynha djarraṯawun'dhuny. ");
INSERT INTO djr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bala ŋayi dhu gi djuy'yurra nhanŋuwuy ŋayi djämamirrinhany mala djiwarr'wuynhany mala, walal dhu marrtjin buku-ḻiw'maraŋun wäŋakurra malaŋuwurr bawalamirriwurra, ḻuŋ'maraŋun walal dhu marrtji yolŋunhan walalany, ŋunhiwurrunhan ŋunhi gänaŋ'maranhawuynhan mala.” ");
INSERT INTO djr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Bala ŋayi Djesuy lakaraŋala mayali'wurra bitjarra gam', “Guyaŋi ŋathil dharpany ŋunhi genydjany': Ŋunhi nhe ŋuli nhäma yuṯany marwat dhamany'tjunawuynydja, bala nhe ŋuli yan dhunupan marŋgithirra ŋunhi waluny galkin borummirra. ");
INSERT INTO djr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ga balanyawuyyin nhe dhu ŋunhi nhämany, bala nhe dhu yan marŋgithirra ŋunhi waluny bilin galkin. ");
INSERT INTO djr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yorrnha nhuma dhu marrtji ŋunhi dhiŋgu'-dhiŋguŋuny nhumany dhuwalawurrnydja, ŋayiny ŋathil dhu gi ŋunhi ŋurruŋuny dhuwaliyi rom mala maḻŋ'thurr ŋunhi nhä mala ŋarra nhumalaŋgal gan ŋurruŋu lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dhuwandja dhu garrwarnydja wäŋa ga dhuwal munathany' dhu ŋunhi buwayakthin, yurr dhäruktja ŋarraku dhu bäyŋun buwayakthi.” ");
INSERT INTO djr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Bäyŋun bukmak yolŋu marŋgi ŋurikiyiny waluw. Ŋunha God-Waŋarrwu dhäwu-gänhamirr mala, ga ŋayi Gäthu'mirriŋu Yolŋu bäyŋuyi yan marŋgi, ŋayipin yan ŋunhi Bäpa'mirriŋun marŋgi ŋurikiyiny waluw. ");
INSERT INTO djr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Gatjuy bira'yurra gi nhininy, dhukarr-nhäŋun gi, bili yakan nhe marŋgi ŋurikiyiny waluw.” ");
INSERT INTO djr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Bala ŋayi Djesuy walalaŋ dhulmu-mayali'mirra dhäwu lakaraŋal bitjarra gam', “Yolŋu wäŋa-waṯaŋu marrtjin wiripulil wäŋalil, bala ŋayi ŋunhi djämamirrinhany yolŋuny walalany djägakuŋala wäŋawnha nhanukiyingalaŋaw ŋayi, ga gurru'-gurrupar ŋayi marrtjin djämany mala walalaŋgal bala ganarrthaŋala walalany. Ga bitjarryi bili ŋayi dhurrwara-djägamirrinhany yolŋuny waŋan djägakuŋalyi yan. ");
INSERT INTO djr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gatjuy nhumany gi djägan dhukarr-nhäŋun gi, bili yaka nhe marŋgi ŋurikiyiny wäŋa-waṯaŋuwnydja nhätha ŋayi dhu ŋunhi roŋiyirr. Mak ŋayi dhu milmitjpa buni, mak djeḏa, nhä mak munhawumirr. ");
INSERT INTO djr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bira'yurr gi nhininy, märr ŋayi dhu yaka muka nhuna maḻŋ'maram yakurrlilnydja. ");
INSERT INTO djr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yo dhuwanna ŋarra ga waŋan nhumalany yulŋuny, gatjuy djägan walal gi.” ");
INSERT INTO djr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Märrman' gan ŋunhi buluny walu ŋorran bala ŋunhiny walu walalaŋ guyaŋanhamirra yäku Ḻäy-Djuḻkmaranhamirra, ŋunhi walal ŋuli ganha ŋatha ḻukanha ḏambamiriw. Ga walalnydja ŋunhi ŋurruŋu djirrikaymirrnydja yolŋu mala ga rom-marŋgikunhamirrnydja mala gan dhukarrwun ḻarruŋal wanhawitjan walal dhu ŋunhi ŋayatham ŋanya Djesuny yurr gayul, bala buman ŋanya murrkay'kuman. ");
INSERT INTO djr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ga bitjarra walal gan ŋunhi waŋanhaminany gam', “Yaka limurr dhu ŋanya buma dhuwalatjandhiny romgurr, walal ŋuli bäynha yolŋun walal maḏakarritjthi limurruŋgun, bala limurruny walal ŋuli gi dhuwal buŋun,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ga balanyamirriynydja ŋayiny gan ŋunhi Djesuny nhinan ŋunhala Bithinin wäŋaŋur, yolŋuwal yäkuwal Djäymangal, ŋurikalyin yolŋuwal ŋunhi ŋayi ŋäthilnydja gan burrunhdhiya'mirr yan nhinan. Ga ŋunhi ŋayi gan Djesuy ŋathany ḻukan ŋunhiliyiny, bala ŋayiny bäy miyalk marrtjin gulŋiyin ŋunhiwiliyi goŋ buthuḻumirr guwatjmar ŋanya, ga gäŋalnydja ŋayi marrtjin ŋunhi buŋgan bäwny'tja, yäku nät, yurr buŋgan bäwny'tja ŋunhi rrupiya yindimirra. Ga dhunupan ŋayi ŋunhi buthuḻuny bakmaraŋala, bala ŋayi ŋanya biḏi'yurra ŋuriŋiyiny buŋgan bäw'yuny wiyikay' Djesunhany muḻkurrnha. ");
INSERT INTO djr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ga walalnydja ŋunhi wiripuwurrnydja yolŋu walal maḏakarritjthinan nhanŋu, bala walal gan ŋunhi waŋanhaminan bitjanminan, “Nhaku ŋayi ga ŋunhiyiny djalkthun buŋgan bäwny'tja wiyika'? ");
INSERT INTO djr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ŋayi balaŋ ŋunha djalimnha rrupiyawnha yindiwnha 300-gun ŋarakaw, märr balaŋ ŋayi ŋunhi rrupiyany gurrupanna ŋunha ŋurruwuykmirriwnha yolŋuw walalaŋ, yurr ŋayiny gan ŋunha djalkthurra yulŋuny,” ga bitjarra walal gan ŋunhi waŋanhaminany ŋarrtjurra manapar ŋunhiyin miyalknhan. ");
INSERT INTO djr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ga ŋayiny ŋunhi Djesuny waŋanan walalaŋguny bitjarra, “Ganarrthul walal ŋanya. Nhaku nhuma ga dhuwal ḻay-ḻaymaramany ŋanya dhuwandja ŋayi ŋunhi bitjarryiny djäma ŋarraku, ŋunhiny latjun mirithirra. ");
INSERT INTO djr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ŋunhany ŋunhi ŋurruwuyktja yolŋu walal dhu gi nhini yan dhiyal nhumalaŋgal biyak muka bili, bawalamirriy waluy nhuma walalany dhu gi guŋga'yurr. Yurr ŋarrapiny ga dhuwal nhina nhumalaŋgal gurrurin yan dhiyal. ");
INSERT INTO djr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ga dhuwanna bili ŋayin dhuwal dhiyaŋun miyalkthun djämany, nhakun ŋayi dhuwal djäman yan bala. Dhuwandja ŋunhi buŋgan bäw' ŋayi rarryurr ŋarrakal ŋäthilmirriyaŋala ŋurikin ŋunhi ŋarranhany walal dhu boŋguŋ molulilyaŋun. ");
INSERT INTO djr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Märr-yuwalk ŋarra nhumalaŋ ga dhuwal lakaramany. Ŋunhi walal dhu gi yolŋu'-yulŋuy dhuwandja dhäwu marrtji lakaraŋ buku-ḻiw'maraŋuny wäŋakurrnydja mala, ga ŋäku yan walal dhu ŋunhi dhiyakalaŋuwuynydja miyalkkalaŋuwuynydja dhäwu, ŋunhi nhä ŋayi djäma ŋarraku, ga guyaŋin yan walal dhu gi,” bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ga dhäŋur beŋuryiny ŋayiny ŋunhi waŋganydja yolŋu yäku Djudatj-Gariyattja beŋuryiny malaŋur ŋunhi 12-kalnydja malthunamirriwal walalaŋgal marrtjinan. Manymak marrtjinany ŋayi ŋunhi balan guwatjmarnydja ŋunhiwurrunhan ŋunhi ŋurruŋu djirrikaymirrinhan mala, märr ŋayin dhu ŋunhi guŋga'yundja walalany ŋunhiwurrunhany … rälimirriyamany Djesunhany goŋ-gurrupanaraw miriŋuwalnydja goŋlil. ");
INSERT INTO djr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ga walalnydja ŋunhi ŋäkulnydja ŋanya dhäruktja ŋayaŋu-goŋmirriyanan dhika, bala yan ŋanya walal rrupiyan dhawu'-nhirrparnydja. Ga dhurrwaraŋur beŋuryiny ŋayiny gan ŋunhi Djudatjthuny dhukarrnha mala-djarr'yurr wanhawitjan dhukarrkurr ŋayi dhu ŋunhi Djesuny goŋ-gurrupan walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Manymak ŋunhiyiny walu bilin bunanan ŋurikiny ŋunhi ḏambamiriwwuny ŋathaw ḻukanharaw. Ŋäthilnydja baman'tja ŋunhi walal ŋuli nhakun balanyarayyi bili waluy warrakan'nhan wutthunna bimbiny bala ḻukanhan walal ŋuli balanyamirriy waluy Ḻäy-djuḻkmaranhamirriy, yurr ŋuruŋ ŋurruyirr'yunamirriy yan waluynydja. Bala walalnydja ŋunhi malthunamirriynydja mala waŋanan ŋanya Djesunhany balanyamirriyyiny waluy bitjarra, “Wanhal wäŋaŋur dhika ŋanapurr dhu ŋathany ŋunhi Ḻäy-djuḻkmaranhamirrnydja ŋäthilmirriyam.” ");
INSERT INTO djr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bala ŋayi Djesuynydja djuy'yurra ŋunhi märrma'nhan malthunamirriny maṉḏany nhanŋuwuy ŋayi, ga bitjarra ŋayi ŋunhi waŋanany maṉḏaŋgal, “Gatjuy marrtjin maṉḏa balan ŋunhi buṉbu-dharrwamirrilila wäŋalil yäkulil Djurutjalamlila, ga ŋunhiliyiny nhuma dhu maḻŋ'maramany waŋganynha ḏirramuny ŋayi dhu ga ḻambarryu gäma banikin' gapumirr, bala nhuma dhu yan malthunna nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ga ŋunhi ŋayi dhu gulŋiyirrnydja buṉbulilnydja bala nhuma dhu waŋan ŋunhi buṉbu-waṯaŋunhany bitjanna, ‘Way, bitjarr ŋunha Marŋgikunhamirrnydja waŋan, wanha gi ŋula mungurr dhärri, märr ŋayi dhu ŋatha ḻuka ŋunhi Ḻäy-djuḻkmaranhamirr, walal rrambaŋi ḻundu'mirriŋuy mala nhanukal.’ Bitjanna nhuma dhu waŋany. ");
INSERT INTO djr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ga ŋayiny nhumalaŋgal dhu ŋuriŋiyiny ŋunhi yolŋuynydja milkuman ŋunhan gal'ŋu ŋunhi garrwarnha yindin mungurr, ga ŋunhiliyin nhuma dhu ŋäthilmirriyamany ŋathany ŋilimurruŋ.” ");
INSERT INTO djr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bala yan ŋunhi malthunamirrnydja maṉḏa marrtjinan. Ga ŋunhi maṉḏa gärrinanany ŋunhiliyiny Djurutjalamdja wäŋaŋur, ga maḻŋ'maraŋalnydja maṉḏa ŋunhi, ŋunhi bili yan ŋunhi nhaltjarr ŋayi gan Djesuy lakaraŋal maṉḏaŋgal. Ga dhunupan yan maṉḏa ŋunhi ŋäthilmirriyaŋala ŋathan ŋunhiliyiny ŋunhi Ḻäy-djuḻkmaranhamirra. ");
INSERT INTO djr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","Ga ŋunhi marrtjin wäŋany munhawuyin bala ŋayiny Djesuny ga malthunamirrnydja mala nhanŋu ŋunhi 12-tja marrtjinan balayin wäŋalil. Ga ŋunhi walal marrtjin ŋathany ḻukan, bala ŋayiny ŋunhi Djesuny waŋanan bitjarra, “Märr-yuwalk ŋarra nhumalaŋ dhu dhuwal lakaramany. Dhiyal gäthur malaŋur dhuwal limurr ga nhina ga ŋatha ḻuka, waŋganydhuny yolŋuy ŋarrany dhu ŋunhi goŋ-gurrupanna miriŋuwal goŋlil,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bala walalnydja ŋunhi ḻundu'mirriŋuny mala nhanŋu galŋa-miḏikinan ŋuriŋiyiny dhärukthuny nhanukal, bala walal bukmakthun yan dhä-birrka'yurrnydja bitjarra, “Wäy, yolthu … ŋarra muka Garray bitjarr.” ");
INSERT INTO djr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ga ŋayiny Djesuny walalaŋ buku-bakmaraŋal bitjarr, “Waŋganydhuny dhu dhipuŋurnydja malaŋur nhumalaŋgalnydja ŋathan ḻupmaram banikin'lila rrambaŋin linyun, ga ŋuriŋiyin dhu ŋunhi goŋ-gurrupandja ŋarrany. ");
INSERT INTO djr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yuwalk yan dhuwal yulŋuny, ŋunhi dhu Yolŋuny Gäthu'mirriŋu rakunydhirra, bitjan yan bili nhakun walal gan ŋäthil baman' wukirri nhanukalaŋawuy. Ga yindin dhu ŋunhi mirithirra ŋurikiny yolŋuw mari ŋunhi ŋayi ŋarrany dhu goŋ-gurrupandja. Yurr manymaktja nhanŋu ŋunhi ŋurikiyiny yolŋuw ŋayi balaŋ ŋunhi bäyŋun yan dhawal-guyaŋanha,” bitjarra ŋayi gan Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yo baḏak yan walal marrtjin ŋunhi ŋathany ḻukan, bala ŋayiny ŋunhi Djesuynydja märraŋala ŋathany bala buku-gurrpara God-Waŋarrnhany bala bakmaraŋala, bala marrtjin gurru'-gurrupara, ga waŋanany marrtjin bitjarra, “Ŋay'! Märraŋ ga ḻuki, dhuwandja ŋarraku rumbal.” ");
INSERT INTO djr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ga bitjarryi bili ŋayi märraŋal banikin' wiyika'mirr ga buku-gurrpar God-Waŋarrnha, bala gurrupara marrtjin, ḻukanan walal marrtjin. ");
INSERT INTO djr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bala ŋayi Djesuny waŋan bitjarra, “Dhuwanna ŋarraku maŋguny'. Ŋunhi ŋayi dhuwal gumurrkunhaminyawuynha rom God-Waŋarrwun yolŋu'-yulŋuwnha, bili ŋarrakuny dhu ŋunhi gulaŋ-waṉḏirr bukmakkun yan yolŋuwnydja walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Dhuwandja ŋarra dhu yuwalknha nhumalaŋ lakaram; Dhäŋur dhipuŋurnydja gay'yi ŋarrany dhu ŋunhi bäyŋun buluny ḻuki ŋunhi yuṯany wiyika borum, ga yän bili ga balanyamirriynha waluy, ŋarra dhu buluny ḻuki yalalan ŋunhala God-Waŋarrwala romŋur,” ga bitjarr ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ga balanyamirriy bili yan bala walal manikaynha ḏar'ṯaryurr ga dhäŋur beŋuryiny walal marrtjinan balan bukulila yäkulil Woliplila. ");
INSERT INTO djr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yo, wäŋgaŋala walal marrtjin bala dhukarr-ŋupara, Djesu ga ḻundu'mirriŋu mala nhanŋu, bala ŋayi ŋunhiliyiny dhukarrŋurnydja Djesuny waŋanan bitjarr, “Nhumany dhu ŋarrany ŋunhi dhiyaŋuwurruynydja ganana bukmakthun yan, bili ŋäthil yan walal ŋunhi wukirriny dhäwuny, ŋunhi ga waŋa bitjan gam', ‘Ŋarrany dhu wutthuna dhuwal bimbi-djägamirrinhany yolŋuny, bala nhanŋu dhu ŋunhi warrakan'tja mala ḻatjuwarr'yunna barrkuwatjthirra.’” ");
INSERT INTO djr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Yurr ŋunhi ŋayi ŋarrany dhu God-Waŋarryu walŋakuŋuny dhiŋganhaŋurnydja, bala ŋarrany dhu boŋguŋ ŋunhi marrtjiny ŋäthila Galalilila.” ");
INSERT INTO djr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ga ŋayiny Betany waŋan bitjarra, “Ŋarrany nhuna dhu dhuwal bäyŋu yan ganarrtham. Bäydhi mak nhuna dhu ŋunhi dhiyaŋuwurruynydja ganarrtham, yurr ŋarrany yaka.” ");
INSERT INTO djr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ga ŋayiny Djesuny waŋan Betawnydja bitjarr, “Märr-yuwalk ŋarra nhuŋu dhu dhuwal lakaramany. Dhiyaŋuny bala gäthurrnydja munhay yalalany, nheny dhu buku-ḻurrkun'mirr ŋarraku dhumbal'yun, ga yorrnha ŋayi dhu ŋunhi gurrwawuny waŋa ḏämbu märrma'mirrnydja.” ");
INSERT INTO djr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Yurr ŋayiny Betany bulu waŋan buku-ḏuwaṯthurr bitjarr, “Yakan dhu dhuwal ŋarrany nhuŋu dhumbal'yun! Bäydhi ŋunhi ŋarra dhu rakunydhirrnydja!” Ga walal ŋunhi wiripuwurr bitjarryi bili waŋan marrtjin dharaŋana yan dhäruk mala. ");
INSERT INTO djr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Manymak wäŋgamany walal marrtji bala-a-a, ga wäŋany ŋunhiyiny ŋayatham Githtjamaniny yäku, bala ŋayi Djesuynydja waŋanan walalany bitjarra, “Nhini walal dhiyal, ŋarra dhu bukumirriyam,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ga garr'yurrnydja ŋayi Betanhan ga Djayimnhan ga Djonnhan, bala walal marrtjinan balan bitjarra. Ga ŋunhalnydja ŋayi ŋunhi Djesuny mirithinan dhika ŋoy-gulŋiyinany, ");
INSERT INTO djr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","bala ŋayi waŋanan lakaranhaminan walalaŋgal bitjarra, “Walal ŋayaŋuny ŋarraku dhuwal mirithinan yan ŋonuŋdhinany nhakun ŋarra dhu dhuwal dhiŋgaman. Nhini walal dhiyal, yurr bira'yurr gi,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Bala ŋayi walalany ganarrthaŋala ŋunhiwiliyin, ga ŋayiny gänan bala yan marrtjin bukumirriyanhalilnydja. Ga marrtjinany ŋayi märr-gurriri bala yan ŋayi ŋurrkanhaminan munatha'lila bala ŋayi gan bukumirriyaŋala bitjarra, “Bäpa ŋarraku marrkapmirr, bäyŋun ŋunhi nhuŋuny mirithirr ḏäl ŋula nhakuny malaŋuw djämaw. Bäpa djälnha ŋarra dhuwal nhe dhu djaw'yunna ŋarrakal dhuwandja ŋunhi galŋa-ŋonuŋdhinyamirrnydja rom. Yurr ŋarrapiny dhu ga dhuwal nhuŋuwuynha yan märrwuny malthun yakan ŋarrakuwuynydja ŋarra,” bitjarra ŋayi gan ŋunhi Djesu bukumirriyaŋalnydja. ");
INSERT INTO djr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ga dhäŋur beŋuryiny ŋayi marrtjin balayi roŋiyindhi malthunamirriwal mala nhanukalaŋuwal, ga maḻŋ'maraŋalnydja ŋayi walalany yakurrmirra. Bala ŋayi waŋan Betawalnydja bitjarra, “Wäy Djäyman, nhaltjan nhe ga dhuwal ŋorra yulŋuny? Yaka nhuma dhu dhuwal ŋula märr gurririny yan bira'yun. ");
INSERT INTO djr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Biyak walal gi bira'yurr nhininy, ga bukumirriyaŋ muka gi yulŋuny, märr nhumalany dhu yaka muka ŋula nhaliynydja dharrwunum. Bili ŋayaŋuny nhuŋu ga dhuwaliyi djälthirr nhe dhu ga dhärra ḏäl yan ŋarrakal, yurr galŋany nhuŋu dhuwaliyi ganydjarrmiriwyinan yalŋgithinan,” bitjarra ŋayi waŋanany walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ga buluyi ŋayi Djesu balayi bili roŋiyin dharapullil, ga buluyi ŋayi bukumirriyaŋal balanya bili yan dhäruk ŋunhi nhaltjarr ŋayi gan ŋäthil bukumirriyaŋal. ");
INSERT INTO djr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ga roŋiyindhi ŋayi beŋur ŋunhi bukumirriyanhaŋur ga maḻŋ'maraŋal walalany yakurrlil yan, yakurryun walalany yindiynha monyguŋal. Ga ŋunhi walal ḏurryurrnydja, bala yan walal goranan, ga bäyŋun walal nhanŋu ŋunhi ŋula waŋanany buku-roŋanmaranhany. ");
INSERT INTO djr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Ga ŋunhi ŋayi bulu ḻurrkun'mirrnydja roŋiyin, ga waŋanany ŋayi walalaŋgal bitjarra, “Bilin ma! yakurrŋurnydja walal gulyurra? Waluny dhuwal galkin, ŋayi dhu ŋuriŋiyiny ḏirramuy goŋ-gurrupanna ŋunhi Yolŋunhany Gäthu'mirriŋuny dhuwurr-yätjkurrumirriwala romlil dhiyaŋun bala. Ma'! Rur'yurra walal limurr marrtjin. Nhäŋun dhuwanna ŋayi ŋunhiyiny yolŋu dharrwununhamirrnydja bilin ŋayi bunanan.” ");
INSERT INTO djr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ga ŋayiny gan ŋunhi Djesuny baḏak yan waŋan balanyamirriynydja, bala ŋayiny ŋunhiyiny ḏirramu gumurr-märrmany' Djudatjtja yäku bunanan, ŋunhi ŋayiny ŋunhiyiny ḏirramu beŋuryi muka walalaŋgal ŋurrukŋur 12-gal. Ga dharrwan gan ŋunhi yolŋuny mala malthurrnydja nhanŋu, ga wäŋgaŋalnydja walal gan ŋunhi malkarr. Ga djuy'yurrnydja walalany gan ŋunhi ŋunhiwurrunhany yolŋuny walalany ŋuriŋiwurruy ŋunhi ŋurruŋu djirrikaymirriy yolŋuy walal, ga Rom-marŋgikunhamirriy mala. ");
INSERT INTO djr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yurr ŋayiny ŋunhi Djudatjthuny ŋäthil walalany waŋan bitjarr gam', “Nhämany nhuma dhu ŋunhi ŋarrany balanyalil gam', ŋunhi ŋarra dhu marrtji, ga dhärra nhanukal galki bala wälkuman ŋanya burumun'nha ŋunhiny ŋarra dhu ŋanya lakaraman nhumalaŋgal. Bala nhumany dhu yan ŋanya ŋayathaman, ga gäŋuny ŋanya goŋdhun yan,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ga ŋunhi ŋayi Djudatj bunanany ŋunhiliyiny, bala dhunupan yan ŋayi gumurr-ganarrthaŋala walalanhany bala dhärranan Djesuwala ga waŋan ŋayi nhanŋu bitjarr, “Marŋgikunhamirr,” bitjarrnydja, bala yan ŋayi wälkuŋala ŋanya. ");
INSERT INTO djr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bala dhunupan yan walalnydja ŋayathaŋala Djesunhany rambuŋala. ");
INSERT INTO djr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ga ŋunhi walal gan dhärra'-dharranany ŋunhiliyiny ga ŋayiny ŋunhi waŋganydhuny yolŋuy dhawaṯmaraŋala yikin nhanŋuwuy ŋayi, bala gulkthurra buthurun waŋganynhan ḏirramuny. Ŋunhiyiny ḏirramu djämamirr ŋurikiyin ŋunhi ŋurruḏawalaŋuwnha djirrikaymirriw yolŋuw. ");
INSERT INTO djr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bala ŋayi Djesuny waŋanan walalaŋ bitjarra, “Nhaku nhuma dhuwal marrtjin malkarrnydja ŋarraku? Nhä dhika ŋarrany rom-bakmaranhamirr yolŋu? ");
INSERT INTO djr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ŋarrany gan ŋunhi bitjarr warray bili walu-ŋupar nhinan ŋunhalnydja ŋunhi buku-ŋal'yunamirriŋurnydja buṉbuŋur marŋgikuŋalnydja gan yolŋunhany walalany, yurr yaka warray nhuma ŋunhi balanyamirriynydja marrtjinya ga ŋayathanha ŋarrany. Yurr bäydhi. Bili bitjandhiyi muka ŋayi ga ŋunha dhärra wukirriwuynydja ŋunhi baman'puynydja,” ga bitjarra ŋayi Djesu waŋanany walalaŋ. ");
INSERT INTO djr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bala walalnydja ŋunhi ḻundu'mirriŋuny mala nhanŋu waṉḏi'-waṉḏinan bukmaknha yan ganarrthaŋala ŋanyanhany Djesunhany. ");
INSERT INTO djr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Ga waŋganydhu yolŋuy gurrmulyu marrtjin munguyurr ŋanya Djesuny, ga garrpinminany ŋayi ŋunhi djarritjarriy yan. Ga ŋunhi walal ŋanya ŋayathaŋalnydja bala yan ŋunhiyi manydjarrkany' nhanukal yupthurra, bala ŋayi gan waṉḏinany warraŋulnha. ");
INSERT INTO djr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bala walal ŋunhi Djesunhany gäŋalnydja balan ŋurikalyin ŋunhi ŋurruḏawalaŋuwala djirrikaymirriwala yolŋuwal wäŋalil. Ga bukmak ŋunhi ŋurruŋu djirrikaymirrnydja mala ga Rom-marŋgikunhamirrnydja mala ga wiripuwurr ŋaḻapaḻmirr mala ḻuŋ'thurra marrtjin. ");
INSERT INTO djr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ga ŋayiny gan ŋunhi Betany marrtjin dhuḏikurr, yurr märr-barrku, munguyurr walalany marrtjin bala. Ga ŋunhi ŋayi Beta gulŋiyinany ŋunhiwiliyiny ŋunhi ŋurruḏawalaŋuwalnydja djirrikaymirriwal ŋärra'lil, bala yan ŋayi dhunupan marrtjinany, dhutnha nhinan walalnha rrambaŋin ŋunhi miriŋun mala, galkin yan gurthaŋura ḻithanmaranhaminan. ");
INSERT INTO djr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ga ŋunhalnydja ŋunhi djinawany' buṉbuŋurnydja walalnydja gan ŋunhi bukmakthun yan ŋurruŋu djirrikaymirriynydja ga rom djägamirriynydja mala dhäwun mala nhanukalaŋuwuy maḻŋ'maraŋal Djesuwalaŋuwuynha, märr walal dhu ŋanya yan dhä-gir'yunna ŋunhiŋuwuyyin yätjkurruyanhawuynha djämapuy, yurr bäyŋu warray walal maḻŋ'maranhany nhanukal ŋula nhäny yätjkurrnydja. ");
INSERT INTO djr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yo dharrwaynha gan ŋunhi yolŋuynydja walal nyäḻ'yurrnydja dhäwu mala lakaraŋal nhanukalaŋawuynydja Djesuwalaŋuwuynydja, yurr dhäwuny mala walal gan ŋunhi lakaraŋalnydja dhä-barrkuwatjnha. ");
INSERT INTO djr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","59","Bala beŋuryiny wiripuwurrnha ḏirramuwurr dhärra'-dharran bala walal lakaraŋalnydja nyäḻ'yurra bitjarra, “Dhuwandja yolŋuny ŋanapurr dhäruk ŋäma balanyawuy waŋanhawuy gam', be ŋayi dhu dhuwandja ŋunhi yolŋuwuŋuny goŋbuy djämapuy buku-ŋal'yunamirr buṉbu bakmaraŋun muṉguykuŋun. Ga bulu ŋayi bitjan waŋa be ŋayi dhu boŋguŋ buluyi ŋunhiyi buṉbuny dhuḻ'yurryi ḻurrkun'thuny waluy, ŋunhi ŋanya dhu bäyŋun wiripuŋuynydja yolŋuy guŋga'yurr.” Ga bitjarra walal gan ŋunhi lakaranhaminany ŋanya Djesunhany. Yurr baḏak yan walalaŋguŋ gan ŋunhi dhäwuny mala marrtjin dhä-barrkuwatj yan yaka ŋula dhunupany waŋganygurrnydja. ");
INSERT INTO djr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bala ŋayiny ŋunhi ŋurruḏawalaŋuny djirrikaymirr rur'yurra, bala ŋayi waŋanan Djesuwnydja bitjarra, “Bäyŋun dhu dhuwal nheny dhäwu lakaram muka, ŋula dhawaṯmaranhamirrnydja nhunapinya nhe?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yurr ŋayiny gan ŋunhi Djesuny dhärran mukthurra yan, yakan ŋayi ŋula waŋganydja dhäruk waŋanha. Ga buluyi ŋayi ŋuriŋiyi ŋurruḏawalaŋuy djirrikaymirriy dhä-birrka'yurr ŋanya bitjarr, “Ma' lakaraŋun napurruŋgal. Muka nhe dhuwal ŋunhiyiny ŋunhi Maŋutji-dhunupayanhawuynydja Yolŋu! … God-Waŋarrwuny Gäthu'mirriŋu?” ");
INSERT INTO djr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bala ŋayi Djesuny buku-bakmaraŋala bitjarra, “Yo, Ŋarra muka dhuwal ŋunhiyiny. Ga dhipuŋurnydja gay'yi dhurrwaraŋur nhuma dhu nhäman Yolŋunhany Gäthu'mirriŋuny ŋayi dhu gi nhininy ŋunhalnydja ŋurruḏawalaŋun, gali'ŋurnydja God-Waŋarrwala nhanukiyingalnha ganydjarryuny. Ga marrtjiny ŋayi dhu roŋiyiny räliny beŋurnydja ŋunhi djiwarr'ŋurnydja maŋandhun, ga balanyawuyyin nhuma dhu ŋunhi nhäŋuny ŋanya.” ");
INSERT INTO djr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Bala ŋayiny ŋunhi ŋurruḏawalaŋuny djirrikaymirr yolŋu mirithinan dhika maḏakarritjthinany, bala marrtjin girrin' nhanŋuwuy ŋayi barr'parrmaraŋal, ga waŋanany ŋayi ŋunhi yatjurra bitjarra gam', “Yakan limurr dhu buluny nhanukuŋ dhäwu ŋäma. ");
INSERT INTO djr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bilin limurr dhuwal ŋanya ŋäkula gan dhäruktja bukmakthun, waŋanhawuynydja ŋunhi ŋayi waŋan dhä-wiripuŋuyin God-Waŋarrwun. Nhaltjanna limurr dhu ŋanya?” bitjarr. Ga walalnydja ŋunhi bukmaktja yolŋu walal yoranhaminan yan nhanŋu bunharawnha murrkay'kunharawnha. ");
INSERT INTO djr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ga walal marrtjin ŋunhi wiripuwurruynydja yolŋuy walal Djesunhany dhupthurra bukun. Ga maŋutji walal ŋanya garrwi'yurr manydjarrkay', bala gan bumara ŋanya bartjunmaraŋala, ga waŋan walal gan nhanŋu bitjarr, “Ma lakaraŋ yolthu nhuna wutthurr?” Ga walal ŋunhi wiripuwurruynydja miriŋuy mala ŋunhi walal gan nhanŋu djäga walalnydja gan ŋanya bumara. ");
INSERT INTO djr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ga ŋunhiliyi warraŋulnydja ŋärra'ŋur ŋayiny gan ŋunhi Betany baḏaknha nhinan ḻithanmaranhamin ŋayi gan ŋanyapinya ŋayi gurthaŋura. Ga ŋayiny waŋgany miyalk ŋunhi ŋayi djämamirr ŋurikiyi ŋurruḏawalaŋuw djirrikaymirriw marrtjin bala ");
INSERT INTO djr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","dharrnha nhäŋal ŋanya ŋunhiwiliyin, ŋayi gan ḻithanmaranhamin, bala ŋayi waŋanan ŋanya dhä-birrka'yurra bitjarra, “Way, nheny dhuwal ḻundu'mirriŋu Djesuw muka? … ŋurikiyi ŋunhi yolŋuw wäŋa Nätjuritjpuywu?” ");
INSERT INTO djr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ga ŋayiny Betany buku-bakmaraŋal bitjarr, “Yaka dhuwaliyi dhunupa. Yaka ŋarra marŋgi nhäpuy nhe ga dhuwaliyi waŋa.” Bala yan ŋayi dhawaṯthurra dhurrwarakurra, ga dhunupan ŋayiny ŋunhi ŋunhalnydja gurrwawuny ŋäthinan. ");
INSERT INTO djr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ga buluyi ŋayi ŋunhi ŋuriŋiyi djämamirriy miyalkthu nhäŋal ŋanya Betany, ga waŋan ŋayi ŋurikiwurruŋgal yolŋuwal walalaŋgal ŋunhi walal marrtjin dhärra'-dharran bitjarr, “Dhuwanna ŋunhi waŋganydja yolŋu beŋuryiny ŋunhi malaŋur.” ");
INSERT INTO djr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ga ŋayiny Betany waŋan bitjarr, “Bäyŋu … Yaka ŋarrany!” Ga yaka wiyin ga wiripuwurrnydja muka yolŋu walal waŋan bitjarr, “Nhepi yan dhuwal yolŋuny. Dhuwandja nhe wäŋa Galalipuy!” ");
INSERT INTO djr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ga buluny ŋayi ŋunhi Beta waŋan mirithinan yan dhäruk-wiripuŋuyinan bitjarra, “God-Waŋarr dhuwal ŋarrakuny marŋgi, ŋunhi ŋarrany dhuwal dhuŋa nhanŋu ŋurikiyi ḏirramuw, yolnha nhuma ga dhuwali lakaram!” ");
INSERT INTO djr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ga ŋunhi ŋayi bitjarryiny waŋan, bala dhunupan ŋayiny gurrwawuny ŋäthinan, ŋunhiny buku-märrma'thinan. Bala yan ŋayi Betaynydja guyaŋan ŋunhi nhaltjarr ŋayi Djesu waŋan nhanukal bitjarr, “Ga yorrnha ŋayi dhu ŋunhi gurrwawuny waŋa buku-märrma'mirrnydja, nheny ŋathil ŋarraku dhu dhumbal'yun buku-ḻurrkun'mirr.” Bala yan ŋayi Betany ŋäthinany mirithinan dhika murruy'-murruyurra. ");
INSERT INTO djr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yo wiripuŋuynha waluy yurr goḏarrmirra, walalnydja ŋunhi ŋurruŋu djirrikaymirrnydja yolŋu mala ga ŋurru-warryunayŋuny yolŋu walal ga Rom-marŋgikunhamirrnydja, ga ŋunhi rom-djägamirrnydja mala bunanhaminan waŋanhaminyarawnha. Ga garrwi'yurr walal ŋunhi Djesunhany goŋ, bala warryu'-warryurra marrtjin balan Bäylitkala. ");
INSERT INTO djr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ga ŋayiny Bäylitthuny dhä-birrka'yurr Djesuny bitjarr, “Nhä nhe dhuwal buŋgawa Djuw-bäpurruw?” Ga ŋayiny Djesuny waŋan, “Dhuwaliyin bili yan dhäwuny,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ga walalnydja gan ŋunhi ŋurruŋu djirrikaymirriynydja mala lakaraŋalnydja dharrwan mirithirra dhäwuny mala Bäylitkalnydja, rom-nyamir'yurra manapar be yätjkurruwuynha mala djämapuy. ");
INSERT INTO djr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ga buluyi ŋayi ŋunhi Bäylitthu ŋanya dhä-birrka'yurr bitjarr, “Ŋula muka nheny dhu waŋa buku-roŋanmaram? Yaka nhe gi ŋunha ŋäkuny, ŋunha walal ga lakaramany nhokalaŋuwuy be yätjkurruwuynha djämapuynydja mala?” ");
INSERT INTO djr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yurr ŋayiny ŋunhi Djesuny bäyŋun waŋanha, bala ŋayiny gan Bäylittja makmakthurra nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ga balanyamirriy bili yan ŋunhi Ḻäy-djuḻkmaranhamirriy waluy bitjanna bili dhuŋgarra-ŋupanna ŋayiny ŋuli ŋunhi Bäylitthuny dhawaṯmaranha waŋganynha yan yolŋuny beŋur dharruŋguŋur, yurr ŋunhiyi bili yan yolŋunhany ŋunhi yolku walal ŋuli djälthinya. ");
INSERT INTO djr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ga balanyamirriyyiny gan gärrin yolŋu yäku Barabatj, ŋunhiliyi dharruŋguŋur. Ŋanya ŋunhiyi, ga wiripuwurruny yolŋuny walalany walal galkar, bili walal ŋuli ganha ŋunhi yolŋuny walalany bunha murrkay'kunha. ");
INSERT INTO djr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Manymak walalnydja ŋunhi Djuw malany yolŋu'-yulŋu marrtjinan bala ŋäŋ'thurra ŋanya Bäylitnhany waŋganygun yolŋuw ḏapmaranhawuywu dhawaṯmaranharaw, bitjarr yan nhakun ŋayi gan ŋunhi ŋäthil djäma. ");
INSERT INTO djr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bala ŋayi Bäylitthuny waŋanan walalany bitjarra, “Djäl nhuma ŋarra dhu dhuwanna dhawaṯmaramany nhumalaŋ! … Ŋurruḏawalaŋunhan, Djuw malawnha?” ");
INSERT INTO djr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ga ŋayiny ŋunhi Bäylittja ŋäthil yan walalaŋ marŋgithin ŋunhi walal ŋurruŋu djirrikaymirriynydja mala gäŋalnydja ŋanya Djesunhany balayiny nhanukalnydja, bili walal ŋanya gan ŋunhi mel-ḏiy'yurr. ");
INSERT INTO djr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Yurr walalnydja ŋunhi ŋurruŋu djirrikaymirriynydja mala dhar'thar-gurruparnydja gan yolŋunhany walalany walal dhu ŋäŋ'thundja Bäylitnhany nhanŋun Barabatjkun dhawaṯmaranharawnydja. ");
INSERT INTO djr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ga buluyi ŋayi Bäylitthu dhä-birrka'yurr ŋunhi yolŋuny walalany bitjarr, “Nhaltjanna ŋarra dhu dhuwandja ḏirramuny, ŋunhi nhuma ŋuli ga lakaram buŋgawa Djuw malawnydja?” ");
INSERT INTO djr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ga walalnydja bukmak yan waŋan yatjunmin bitjarr, “Dhuḻ'yurra ŋanya dharpalila!” ");
INSERT INTO djr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ga ŋayiny Bäylittja waŋan, “Nhä ŋayi nhumalaŋ ŋula miḏikumarnydja djäma?” “Buŋun ŋanya dharpalila ŋal'maraŋ,” bitjarr walalnydja yatjunmin dhika mirithinan yan. ");
INSERT INTO djr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bala ŋayiny Bäylitthuny djäl-ŋamathaŋala walalany ŋunhi yolŋunhan walalany. Bala yan ŋayi Barabatjnhany dhawaṯmaraŋala. Ga waŋan ŋayi miriŋunhany mala bunharawnha nhanŋuny Djesuwnydja bartjunmaranharawnha, bala dhu gäman ŋanya, ga dhuḻ'yunna ŋanya dharpalila mälakmaranhawuylila. ");
INSERT INTO djr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ga balanyamirriyiny waluy walalnydja ŋunhi miriŋuynydja mala Djesunhany gäŋala balan djinawa'lila Bäylitkala wäŋalil, ŋunhi ŋayi buŋgawa wäŋaw-ŋayathanharaw, ga wäthurr walal wiripuwurruŋ miriŋuw mala bukmakku yan, ga dhärranany walal gan ŋunhi ḻiw'maraŋala ŋanya Djesunhany. ");
INSERT INTO djr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bala nhirrparnydja walal nhanukal wiyinnha dhika girriny' miku'mirra miny'tjiny, ga bulu walal nhanŋu djäma ḏirriṯirri ḻiyaw ŋal'maranharaw, bala walal nhirrpara nhanukal. ");
INSERT INTO djr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bala walal marrtjin waŋanany bitjarra nhanŋu, warku'yurrnydja ŋanya, “Way, nheny dhuwal ŋurruḏawalaŋu Djuw malaw,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ga wutthurr walal ŋanya muḻkurr dharpay bala gan dhupthurra ŋanya. Ga bulu nhakun walal gan warkuyurr ŋanya, bun'kumu-djipthurr nhanukal buku-ŋal'yurr nhanŋu. ");
INSERT INTO djr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ga ŋunhi walal nhanukal warku'yunaŋurnydja dhawar'yurr, bala yan walal yupmaraŋala nhanukal ŋunhi miny'tjimirrnydja girri' ga nhirrparnydja walal nhanukal nhanŋuwuynha yan girriny' Djesuwnha, bala walal ŋanya miriŋuynydja mala marrtjin gäŋala dhawaṯmaraŋala dhuḻ'yunarawnha dharpalilnha. ");
INSERT INTO djr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ga balanyamirriy waluy yolŋu ḏirramu yäku Djäyman gan marrtjin beŋur ḏiltjiŋur, yurr wäŋapuynydja ŋayi ŋunhi Djäriniwuy. Ga bäpa'mirriŋuny ŋayi ŋunhi maṉḏaŋ Yaliktjandaw ga Ropatjku. Ga walalnydja ŋunhi miriŋuynydja mala waŋan ŋanyanhan Djäymannhan dharpawnydja ŋurikiyi mälakmaranhawuywuny ḻaw'maranharaw. ");
INSERT INTO djr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bala walal ŋunhi miriŋuynydja mala marrtjin gäŋal Djesunhany balan Gulkathalila, ŋunhi ga ŋuriŋiyiny mayaliy' lakaram ŋunhiyiny wäŋa Gulkathany, “Ḻiya Ŋarakan wäŋa”. ");
INSERT INTO djr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ga ŋunhiliyiny wäŋaŋur walal gurrupara ŋanya Djesuny wiyika borum mel-manapanawuy mirritjin'mirr yäku merr. Yurr ŋayipiny Djesuynydja yakan ḻukanha ŋunhiyiny wiyika. ");
INSERT INTO djr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bala walal ŋanya Djesunhany ŋal'maraŋala, dharpalila mälakmaranhawuylila. Ga ŋunhiliyiny walal gan dhuḏiŋurnydja dharpaŋur ḏäpthurr miriŋun mala, buḻ'yurra walal gan dopulun Djesuwalaŋuwnha girriw'. ");
INSERT INTO djr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ga ŋal'maraŋalnydja walal ŋanya ŋunhi dharpalilnydja waluynydja 9-dhu yurr goḏarrmirr yan. ");
INSERT INTO djr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bala walal ŋunhi bukulilnydja dharpalil ŋal'maraŋal dhäruknha, märr walal gan ŋunhi yolŋuny walal marŋgithinan yan ŋunhi nhaku walal ŋanya ŋunhi gämurruw' dhuḻ'yurr balayi. Ga bitjarr gan ŋunhili dhäruktja barraŋga'yurr gam', “Ŋurruḏawalaŋu Djuw malaw,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ga bitjarryi bili walal ŋunhi märrma'nhany ḏirramuny maṉḏany rom-bakmaranhmirrinhany maṉḏany ŋal'maraŋalyi, waŋganynhany walal ŋal'maraŋal dhunupa'ŋulil gali'lil nhanukal Djesuwal, ga waŋganynhany walal ŋal'maraŋal ga wiṉ'kuŋulila gali'lil. ");
INSERT INTO djr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ga ŋunhi gan yolŋu mala marrtjin djuḻkmaraŋal ŋanya, ga ḏawaḏawa'yurr walal gan, warku'yurr manapar ŋanya. Ga bitjarr walal gan nhanŋu ŋunhi waŋanany gam', “Wäy! Be muka nheny dhu dhuwal bakmaraŋun ŋunhany ŋunhi buku-ŋal'yunamirrinhany buṉbuny, ga buluyi nhe dhu dhuḻ'yurryi ḻurrkun'thuny waluy. ");
INSERT INTO djr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Gatjuy mak walŋakunhamirra nhunapinya nhe, bala yupthurra dhipuŋuryiny dharpaŋur mälakmaranhawuyŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ga bitjarryi bili walalnydja ŋanya gan ŋunhi ŋurruŋu djirrikaymirriynydja mala ga rom-marŋgikunhamirriynydja yolŋuy mala warku'yurryi ŋanya Djesuny. Ga bitjarr walal gan ŋunhi waŋanhaminany gam', “Way, dhuwandja ŋayi gan walŋakuŋalnydja ŋunha wiripuwurruny? … ga yakan ŋayi dhu dhuwal ŋanyanhawuynhany ŋayi walŋakunhamirr?” ");
INSERT INTO djr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ŋuli ŋayi dhuwal be Maŋutji-dhunupayanhawuynydja Yolŋu, ga Buŋgawany Yitjuralwuny bäpurruw, nhämirr ŋayi dhu yupmaranhamirra ŋanyapinya ŋayi beŋurnydja dharpaŋur mälakmaranhawuyŋurnydja, märr limurrnydja dhu nhäman bala yan märr-yuwalkthirra nhanŋu. Ga maṉḏa gan ŋunhi manaŋa-ḏumurruy maṉḏa bitjarryi bili waŋan yätjkurruyaŋal nhanŋu warku'yurr ŋanya. ");
INSERT INTO djr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yo. Ga ḏämbuynha waluy, bala wäŋany ŋunhi buku-munha'yinan warrpam'thurra, ga dhärranany gan ŋunhi buku-munhan', ga yan bili-i-i, ga ḻäy-bilyunaraynha waluy. ");
INSERT INTO djr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bala ŋayi balanyamirriyyiny waluy Djesuny ŋayipiny yatjurra mirithinan Arramayikkurra dhärukkurrnydja bitjarra gam', “Yeluy! Yeluy! Lama djabakthani?” Ŋunhiyiny dhäruk mayali' balanyawuynha gam', “God-Waŋarr ŋarraku! God-Waŋarr ŋarraku! Nhaku nhe ŋarrany dhuwal ganarrthaŋalnydja?” ");
INSERT INTO djr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ga wiripuwurruynydja yolŋuy walal ŋunhili, ŋäkula ŋanya balanyawuyyiny waŋanhawuy bala walal waŋanhaminan bitjanminan, “Way walal, mukthurr walal. Ŋunha ŋayi ga wäthun Yilaydjawnha!” ");
INSERT INTO djr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ga ŋayiny waŋganydhuny ḏirramuy manydjarrkan' märraŋal bala mam'maraŋal dharpalila ga ḻupmaraŋal ŋayi borumlil wiyika'lil, bala yan marrtjin garramatkuŋala, ga mam'maraŋal dhurrwaralila nhanukal Djesuwal. Bala ŋayi waŋanan ŋunhi yolŋuny bitjarra, “Baḏak limurr galkun ŋathil wanha balaŋ ŋayi dhu Yilaydja marrtji, ga yupmaram ŋanya dhipuŋur dharpaŋur.” ");
INSERT INTO djr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ga dhäŋur beŋuryiny, bala yan ŋayipiny Djesuny yatjurr mirithinan bala yan ŋayi dhiŋgaŋala. ");
INSERT INTO djr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ga balanyamirriyyi bili ŋayiny ŋunhi manydjarrkany' ŋunhalnydja ŋunhi buku-ŋal'yunamirriŋurnydja buṉbuŋur barr'yurra beŋur bili bukuŋur ga yan bili-i-i ga ŋoylil ŋurrkaŋal, bala ŋunhi manydjarrkany' maṉḏany barrkuwatjthinan. ");
INSERT INTO djr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ga ŋunhiliyi gan yolŋu dhärran ŋunhi ŋayi ŋurru-warryunayŋu miriŋuw walalaŋ, ga nhäŋal ŋayi gan ŋanya ŋuriŋiyi yolŋuy Djesuny dhuḏiŋur dharpaŋur ŋunhi ŋayi milma yan dhiŋgaŋal, bala ŋayi waŋanan bitjarra, “Yuwalk muka dhuwandja yolŋu God-Waŋarrwu yan Gäthu'mirriŋu.” ");
INSERT INTO djr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ga wiripuny gan miyalkkurruwurr ŋunhiliyi dhärra'-dharran, yurr märr barrku walal gan ŋunhi dhärranany. Ŋunhiwurryiny miyalkkurruwurr ŋunhi walal ŋuli ganha Djesuw malthuna ga guŋga'yuna ŋanya ŋunhal Galali. Ga dhuwalawurr mala ŋunhi miyalkkurruwurrnydja gam', Meri Magdalawuy, Djalumi, ga wiripu Meri, ŋäṉḏi'mirriŋu maṉḏaŋ gurrmulwu maṉḏaŋ Djayimgu ga Djawutjipku. ");
INSERT INTO djr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ga balanyamirriy bili yan ŋuruŋun ḻäy-bilyunaraynha, yurr waluynydja ŋunhi galki ŋamaŋamayunaminyaraynha ŋunhi walal ŋuli ŋamaŋamayunminya ŋurikin ŋunhi Nhinanhamirriwnha waluw. ");
INSERT INTO djr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Bala ŋayiny ŋunhi yolŋu yäku Djawutjiptja wäŋa Yaramathiyawuynydja bunanan Bäylitkuny, bala ŋayi ŋäŋ'thurra ŋanya Djesuwalaŋuwnha rumbalwun. Ŋayiny ŋunhiyiny yolŋu manymak yan mirithirr. Ga walalnydja ŋanya ŋuli ganha ŋunhi bukmakthuny rom-djägamirriynydja mala manymak lakaranha, ga nhinan ŋayi gan dhukarr-nhäŋal ŋurikiyi bili yan Godkalaŋuwnha Romguny maḻŋ'thunaraw. ");
INSERT INTO djr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ga ŋunhi ŋayi Bäylitthu ŋäkulnydja ŋanya Djesunhany bondiŋuwuynha dhiŋganhawuynydja, bala ŋayi mirithinan dhika ganyim'thurrnydja, bala ŋayi wäthurra ŋurikin yan yolŋuw ŋunhi ŋayi ŋurru-warryunayŋu miriŋuwnha, bala ŋayi gan dhä-birrka'yurra dhäwun maḻŋ'maraŋal nhanukal Djesuwalaŋuwuynha ŋunhi ŋayiny ŋäthilmirr yan rakunydhinany. ");
INSERT INTO djr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ga ŋunhi ŋayi Bäylitthu ŋäkulnydja dhäwuny nhanukuŋ ŋunhi ḏirramuwuŋuny, bala ŋayi dhayuŋara rumbalnydja ŋanya Djesunhany Djawutjipkala. ");
INSERT INTO djr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ga ŋayiny Djawutjipthuny märraŋal manydjarrkan', bala rumbalnydja ŋanya Djesunhany yupmaraŋala beŋuryiny ŋunhi dharpaŋurnydja. Bala ŋayi ŋuriŋiyin manydjarrkay'nha ŋanya dhurrthurryurrnydja bala ŋayi rulwaŋdhurrnydja ŋanya mathirralila, ŋunhiwiliyin ŋunhi walal ŋäthil gan mitthurr ŋunhiyi guṉḏany. Bala ŋayi gaḻ'kaḻmaraŋalnydja yindin yan guṉḏany dhurrwarawnydja gunganharaw. ");
INSERT INTO djr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ga maṉḏany gan ŋunhi Meri Magdalawuyyuny ga Meriy ŋunhi Djawutjipkalnydja ŋäṉḏi'mirriŋuy nhäŋal, ŋunhi wanhawal walal rumbal nhanŋu Djesuw märrkitjkuŋal. ");
INSERT INTO djr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ga bäy ŋayi ŋunhi nhinanhamirr walu djuḻkthurra, bala dhurrwaraŋur beŋuryiny bala walalnydja Meri Magdalawuyyuny ga Djalumiynydja ga Meriynydja Djayimgalnydja ŋäṉḏi'mirriŋuy ŋamaŋamayurra marrtjin buŋgan bäwnha mala, Djesuwnha rumbalwun biḏi'yunarawnha. ");
INSERT INTO djr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Djandin marrtjin walu djaḏaw'yurr, yurr goḏarr'mirra walu goŋ-djalkthunminyaraynha, walalnydja ŋunhi ŋunhiwurryiny miyalkkurruwurrnydja marrtjinan balayin mathirralila. ");
INSERT INTO djr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ga gandarrŋurnydja bala walal marrtjin dhä-birrka'yunminan, “Wäy! Yolthun limurruŋgal dhu dhuwal ŋunha guṉḏany gaḻ'kaḻmaram beŋurnydja ŋunhi dhurrwaraŋurnydja mathirraŋur.” ");
INSERT INTO djr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yurr yuṯa muka walal bitjarr buku-garrwarthinany, bala walal nhäŋalnydja ŋunhi guṉḏany biliŋuwuynha giṯmaranhawuynha gan dhärran. Ga yindi ŋunhi mirithirr guṉḏany! ");
INSERT INTO djr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bala yan walalnydja ŋunhi miyalkkurruwurrnydja gulŋi'-gulŋiyinan ŋunhiwiliyin mathirralila, ga dhunupa'ŋulilnydja gali'lil walal nhäŋal gurrumulnha ḏirramuny girri' watharrmirrinhan ŋayi gan nhinan. Bala yan walal ŋunhi mirithinan dhika barrarinany. ");
INSERT INTO djr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ga ŋayiny ŋunhi gurrmulnydja waŋan bitjarra, “Yaka walal barrari! Dhuwandja nhuma ga ḻarrumany Djesuw muka wäŋa Nätjuritjpuywun, ŋunhi walal dhuḻ'yun ŋanya dharpalil. Bilin ŋanya dhuwal God-Waŋarryuny walŋakuŋala, ga bäyŋun ŋayi dhuwandja. Nhäŋun! Dhuwanna ŋunhi wäŋany ŋunhi wanhawal ŋanya walal rumbal märrkitjkum. ");
INSERT INTO djr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gatjuy dhäwuny walal dhuwal gäŋun ŋurikiyin malthunamirriwalnha mala nhanukalaŋuwal ga wiripuny Betawal. Ŋayiny dhu dhuwal marrtjin ŋurruŋu-djuḻkthunna nhumalaŋguny balan Galalilila. Ŋunhiliyin nhuma dhu boŋguŋ ŋanya nhäŋuny, ŋunhiyi bili yan dhäruk ŋunhi nhaltjan ŋayi waŋa nhumalaŋgal.” ");
INSERT INTO djr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ga ŋunhi walal waṉḏi'-waṉḏirrnydja beŋurnydja ŋunhi mathirraŋurnydja ŋunhiwurrnydja miyalkkurruwurrnydja ga marrmarryunna walal marrtji ŋunhi barrariynydja. Ga barrarirra walal ŋunhi mirithirra lakaranharawnydja, ŋunhi nhä walalaŋgal maḻŋ'thun ŋunhiliyi. ");
INSERT INTO djr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ga dhäŋur beŋuryiny ŋunhi ŋayi Djesu rur'yundja dhiŋganhaŋurnydja, bala ŋayi milkunhamirra Meri Magdalawala, ŋurikalyin ŋayi ŋunhi miyalkkal dhä-ŋäthilnydja dhawaṯmaram djabindja wakinŋumirriny birrimbirrnha mala. ");
INSERT INTO djr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bala yan ŋayi ŋunhi marrtjinany ga lakaraŋalnydja ŋayi ḻundu'mirriŋuwala mala nhanukalaŋuwal ŋunhi walal marrtjin ŋäthinyamin. ");
INSERT INTO djr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ga bäydhi walal ŋunhi dhäwuny bilin nhakun ŋäkula Djesuwalaŋuwuynydja walŋathinyawuy, ga ŋunhi ŋayi Meriy ŋanya nhäŋalnydja, yurr bäyŋun yan walal nhanŋu ŋunhi märr-yuwalkmirriyinyany. ");
INSERT INTO djr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ga dhäŋur beŋuryiny bala ŋayi Djesuny wiripuyaŋal muka maŋutji-gurrupanmin märrma'walnydja malthunamirriwal nhanukalaŋuwal balanyamirriynydja ŋunhi maṉḏa marrtjin waṉḏin ḏiltjikurr. ");
INSERT INTO djr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ga ŋunhi maṉḏa dhäwuny lakaraŋal ŋunhi nhaltjarr maḻŋ'thurr, ga balayi maṉḏa roŋiyin ga lakaraŋal walalaŋgal wiripuwurruŋgal. Yurr walalnydja ŋunhi wiripuwurruynydja bäyŋun märr-yuwalkthinya. ");
INSERT INTO djr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ga dhurrwaraŋur beŋuryiny bala ŋayiny Djesuny milkunhamirra ŋanyapinya ŋayi ŋurikalyin ŋunhi 11-galnha ḻundu'mirriŋuwal nhanukalaŋuwal, walal marrtjin ŋathan ḻukan. Bala ŋayi waŋanan walalany ŋarrtjurra, bili walalnydja ŋunhi ŋayaŋuny-gunganhaminan dhäwuwny'tja märr-yuwalkthinyaraw, ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi walal ŋanya nhäma dhurrwaraŋur walŋathinyaŋur. ");
INSERT INTO djr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bala ŋayi waŋanany walalany bitjarra, “Gatjuy marrtjin! … ga lakaraŋun dhäwuny manymaktja bukmakkala yan yolŋuwalnydja walalaŋgal dhuwal buku-ḻiw'maraŋun wäŋakurra malaŋuwurr. ");
INSERT INTO djr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ga ŋuli ŋayi dhu ŋula yol yolŋu märr-yuwalkthirrnydja ŋarraku, ga märram ŋayi dhu ŋunhi buku-ḻupthunawuynydja, ŋayiny dhu yan walŋathirra. Yurr ŋuli ŋayi dhu ŋunhi ŋuyulkthirrnydja, yakany ŋarraku märr-yuwalkthirr, ŋanyanhany dhu ŋunhi ŋunhiyinhany yolŋuny dhä-gir'yunna. ");
INSERT INTO djr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ga bukmak ŋunhi yolŋu, ŋunhi walal dhu ga märr-yuwalkmirriyirr ŋarrakuny, walalnydja dhu ga djäma latjun mirithirra romdja malany ŋoy-ganyim'thunamirra. Ga yäkuny walal dhu ga ŋunhi bäkiny ŋarranhan wakinŋumirriwnydja birrimbirrwu dhawaṯmaranharaw, ga waŋany walal dhu ga ŋunhi wiripun yuṯan dhäruktja. ");
INSERT INTO djr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ga ŋuli walal dhu ŋunhi ŋayatham bäpinhany, ŋayiny dhu bäyŋun walalany ḏarrkthun. Ga ŋula nhä walal dhu ḻuka botjin', ga bäyŋun walal dhu ŋunhi rirrikthundja. Ga goŋ-ŋal'yundja walal dhu ga ŋunhi rerrimirriwalnydja yolŋuwal walalaŋgal, ga walalnydja dhu ga yan ḏukthunna.” ");
INSERT INTO djr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ga ŋunhi ŋayi gan Djesu waŋanany ḻundu'mirriŋuwalnydja mala nhanukalaŋuwal, bala ŋanya dhunupan djaw'yurra beŋuryiny djiwarr'lil, bala ŋayi nhinanany galkin yanan nhanukala God-Waŋarrwalnydja dhunupaŋuŋura gali'ŋurnydja. ");
INSERT INTO djr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bala walalnydja ŋunhi ḻundu'mirriŋuny mala nhanŋu marrtjinan. Bala walal marrtjin dhäwun lakaraŋal buku-ḻiw'maraŋala. Ga ŋayiny Garraynydja ŋunhiliyi galki yan walalaŋgal, djäman ŋayi marrtjin walalaŋgal ganydjarryuny yindiynha ŋayaŋu-ganyim'thunamirriynha, ŋunhi gan ŋuriŋiyiny maŋutji-lakaraŋala ŋunhi dhäwuny mala walal gan lakaraŋalnydja yuwalknha yan. Yo Yow. ");
INSERT INTO djr_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","Yurr walalnydja ŋunhi dhäwu lakaraŋal Betawalnydja ga wiripuwurruŋgalnydja ŋunhiŋuwuynha ŋunhi yan bukmakpuynha ŋunhi nhä walalaŋgal gan lakaraŋal. Ga dhurrwaraŋur beŋuryiny, bala ŋayi Djesuynydja gan djuy'yurra ŋunhi walŋamirrnydja dhäwu ḻundu'mirriŋuwalaŋuwurra mala nhanukalaŋuwurr. Ga djuy'yurrnydja ŋayi walalany bala bulwunulil ga bala bärra'lil. Ga ŋunhiyiny ŋunhi walŋamirrnydja dhäwu ga dhuyuny dhu bäyŋun dhawar'yun. ");
INSERT INTO djr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dhuwandja dhäwu ŋarrakuŋ Lukkuŋ* wukirriwuy, yurr nhuŋu dhuwal yulŋuny, Dhiyapalatj. Dharrwaynha gan dhuwal yolŋuynydja walal bilin wukirrin dhäwuny mala djorra'lilnydja malaŋulil, ŋunhiny dhäwu ŋunhi nhaltjarr ŋäthil maḻŋ'thurr limurruŋgal bukmakkal. ");
INSERT INTO djr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yo. Bilin nhakun walal gan dhuwal wukirrin yulŋuny, ŋunhi napurrnydja gan ŋäkulyi dhuwaliyi dhäwu walalaŋguŋuny ŋunhi maŋutji-marŋgimirriwuŋuny ga djämamirriwuŋuny mala, ŋunhi nhä mala walal gan nhäŋal ga ŋäkul ŋunhal bala ŋurruyirr'yunamirriy, bala walal gan ŋunhi lakaraŋala napurruŋgala. ");
INSERT INTO djr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yo, marrkapmirr buŋgawa. Ga ŋarrany marrtji dhuwal bulnha muka yan buthuru-bitjun walalaŋ bukmakku yan dhäwuwny'tja warrpam'ku beŋur bili yan ŋunhi ŋurruyirr'yunaŋur Djesuwalaŋuwnydja dhäwuw. Ga ŋarrapiny ga dhuwal guyaŋa, ŋarra dhu ga djäma bulnha yan bukmakkum dhäwuny' nhuŋu. ");
INSERT INTO djr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ŋarrany ga dhuwal nhuŋu dhäwu djäma yuwalk yan, märr nheny dhu ga guyaŋan yuwalkkuman, ŋunhi bili yan dhäwuny waŋgany ŋunhi nhe märraŋal ga ŋäkul wiripuwurruŋguŋ yolŋuwuŋ walalaŋguŋ. ");
INSERT INTO djr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yo. Balanyamirriyyiny waluy gan nhinan ŋurruḏawalaŋu buŋgawa yolŋu yäku Yarit* Djudiyapuywuny* wäŋaw. Ga ŋuriŋi bili waluy djirrikaymirrnydja gan ŋunhiliyi nhinan yolŋu yäku Djakaraya.* Ga nhanukalnydja ŋunhi Djakarayawalnydja yarraṯaŋur yolŋu walal gan bukmaknha djirrikaymirriyinan, ga mala-ŋurrkanhayŋuny walalaŋ ŋurikiwurruŋdhi yolŋu yäku Yabitja.* Ga Djakarayaw miyalktja ŋunhi yäku Litjipit,* ga ŋayiny ŋunhi Litjipittja yarraṯaŋur balanyayi bili yan nhanukalnha Yärangalnha. ");
INSERT INTO djr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Maṉḏany ŋunhi ŋunhiny maṉḏa yolŋu maṉḏa Djakarayany ga miyalktja nhanŋu dhuwurr-dhunupa gan nhinan God-Waŋarrwalnydja maŋutjiŋur, ga dhärukku malthurr maṉḏa gan ŋurikiyi bili yan God-Waŋarrwalaŋuw dhäruk-nhirrpanminyawuywu; bäyŋu maṉḏa ŋula djäma yätjkurr rom. ");
INSERT INTO djr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Yo nhinanany maṉḏa gan ŋunhi Djakarayany ga miyalktja nhanŋu yothumiriw yan, bäyŋu nhanŋu ŋayi ŋula Litjipitthu yothuny gänha, ga yän bili ga worruŋuyin maṉḏa rrambaŋi yan yothumiriw maṉḏa. ");
INSERT INTO djr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Manymak waŋganydhuny waluy Djakaraya ga mala nhanŋu marrtjin ŋunhiwiliyi dhuyulil buṉbulil, wiripuwurruŋ nhakun walal djirrikaymirriw malaŋuw djäma djaw'yurr. ");
INSERT INTO djr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yo, djirrikaymirriw walalaŋ gan ŋorran rom mala-djarr'yunminyaraw walalaŋguwuy walal, nhaltjanna walal ŋuli märranha waŋganynha ŋunhi yolŋuny djirrikaymirriny, märr ŋayi ŋuli gärrinyan ŋunhiyiny waŋganydja yolŋu ŋärra'lila, bala dhuŋgur'yunan ŋuli buŋgan-bäwny'tja djimuku'lila, märr ŋayi ŋuli warrpuruny dhawaṯthunna ŋamakurrnha God-Waŋarrwuny nhumanaraw. Ga balanyamirriyyiny waluy walal märraŋal djirrikaymirrnydja ŋanyanhan Djakarayanhan gärrinyarawnydja. Bala ŋayi yan gärrinan Djakarayany God-Waŋarrwalnha ŋärra'lil. ");
INSERT INTO djr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ga ŋuriŋiyi bili yan ŋayi Djakarayaynydja dhuŋgur'yurra wiyikan' buŋgan bäwnha ŋunhiliyiny djinawany' buṉbuŋur, bala walalnydja marrtjin ŋunhalnydja yolŋuny walal bukmaknha bukumirriyaŋala ŋunhiliny warraŋulnydja, dhurrwaraŋurnydja ŋärra'ŋur. ");
INSERT INTO djr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bala God-Waŋarrwuny dhäwu-gänhamirrnydja yolŋu maḻŋ'thurra nhanukal Djakarayawalnydja ŋunhiliyi banydji yan djinawa', ga dhärranany ŋayi gan ŋunhiyi yolŋuny dhunupa'ŋuŋura gali'ŋurnydja ŋunhiliyin ŋunhi gan djimuku' dhärran bulaymirr. ");
INSERT INTO djr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ga ŋunhi ŋanya ŋayi Djakarayay nhäŋalnydja ŋunhiyiny ŋunhi dhäwu-gänhamirrinhany yolŋuny dhärranhawuynydja, bala yan ŋayi mirithinan dhika ganyim'thurrnydja, barrarinan manapar. ");
INSERT INTO djr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yurr ŋayiny ŋunhi God-Waŋarrwuny dhäwu-gänhamirrnydja yolŋu waŋan nhanŋu Djakarayawnydja bitjarr warray, “Way Djakaraya, yaka barrari! Bilin nhokuŋ God-Waŋarryuny ŋäkulnha bukumirriyanhawuynydja, ga nhokalnydja dhu miyalkthu yothuny gäma ḏirramun, nhuŋuwuynha yan walkur. Ga yäku-nhirrpandja nhe ŋanya dhu ŋunhi yothunhany Djon. ");
INSERT INTO djr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ga nhepiny dhu ŋunhi mirithirra yan ŋoy-djulŋithirrnydja ga goŋmirriyirrnydja, ga wiripuwurrnydja dhu ŋunhi yolŋu walal bitjandhi bili djulŋithirryi ŋuriŋiny ŋunhi nhanukal dhawal-guyaŋanharaynydja ŋurikalyiny yothuwalnydja, ");
INSERT INTO djr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","bili ŋayi dhu boŋguŋ ŋunhi ŋurruŋuyin Garraywalnydja maŋutjiŋur. Ga ŋuriŋiyiny ḏirramuy, yaka ŋayi dhu boŋguŋ ḻuki ŋula nhäny ḏälnydja leŋumirrnydja gapu. Ga beŋur bili ŋunhi ŋayi dhu boŋguŋ dhawal-guyaŋi, marrtjiny ŋayi dhu gi ŋunhi Dhuyu-Birrimbirrwalaŋumirrnydja dhaŋaŋmirra yan. ");
INSERT INTO djr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ga dharrwanhan yolŋunhany walalany ŋayi dhu gi ŋunhi gäŋuny roŋanmaraŋuny Yitjuralpuynhany* Djuw malanhany balan Garraywala, walalaŋgiyingalaŋuwalnha God-Waŋarrwal. ");
INSERT INTO djr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ŋayi ŋathil boŋguŋ ŋunhi Djon ŋurruŋuny marrtji, dhukarrmirriyaŋuny, ga yurrnha dhu ŋayiny Garraynydja buni. Ŋayiny dhu gi ŋunhi Djondhuny ŋayathul ganydjarrmirryi yan birrimbirr balanya bili yan nhakun gan ŋunhi djawarrkmirriy yolŋuy yäkuy Yilaydjay ŋayathaŋal ŋäthil. Ga bilmaraŋuny ŋayi dhu gi ŋunhi dharrwanhan bäpa'mirriŋunhany walalany, walal dhu märr-ŋamathin walalaŋgiyingalaŋaw djamarrkuḻiwny'tja yuwalkkuŋun yan. Ga ŋunhiwurrnydja yolŋu walal ŋunhi walal ŋuli ga malthun walalaŋgiyingalaŋawnydja romgu malaŋuw ga dhukarrwu, ŋayiny dhu gi ŋunhi Djondhuny walalany bilmaraŋun beŋuryiny romŋur balan biyakun manymaklila dhukarrlil, märr walal dhu gi guyaŋiny ŋunhiyin bili yan dhunupan dhukarrnydja. Yo, ŋayin dhu marrtji ŋunhi Djondhun ŋamaŋamayurrnydja ŋäthilmirriyaŋuny walalany Djuw malanhany nhanukalnydja Garraywalnydja.” Ga bitjarra ŋayi gan ŋunhi djiwarr'puynydja yolŋu waŋan nhanukalnydja Djakarayawalnydja. ");
INSERT INTO djr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ga ŋayiny Djakarayany waŋan buku-bakmaraŋal ŋurikiny djiwarr'puywuny dhäwu-gänhamirriwnydja yolŋuw, märr-yuḻkthurr warray ŋanya bitjarr, “Nhaltjan dhika ŋarra dhu marŋgithirrnydja? Yuwalk muka nhe ga dhuwal lakaramany? Ŋarrapiny dhuwal worruŋun yolŋu, ga ŋunha miyalk ŋarraku balanyayi bili yan worruŋuyi.” ");
INSERT INTO djr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Way, ŋarrany dhuwal Gaybiril yäku,” ga bitjarr ŋayiny ŋunhiyiny dhäwu-gänhamirrnydja yolŋu djiwarr'puynydja yäku-lakaranhamin nhanukal Djakarayawalnydja. “Ŋarrany ŋuli ga dhuwal dhärra God-Waŋarrwal warray gali'ŋur, djämamirr nhanŋu. God-Waŋarryu ŋarrany dhuwal djuy'yurrnydja räliny waŋanharawnydja nhuŋu, ga dhuwanna ŋarra ga lakaraman nhokal ŋunhi manymaktja dhäwu. ");
INSERT INTO djr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yurr nheny yaka warray ŋarraku märr-yuwalkmirriyinya, dhiyakiyiny ŋunhi dhäwuw ŋunhi ŋarra nhokal gan lakaraŋal. Dhuwaliyiny ŋunhi dhäruk ŋunhi dhu boŋguŋ yuwalknha yan maḻŋ'thurrnydja God-Waŋarrwala yan waluynydja. Yurr dhipuŋurnydja gay'yi dhurrwaraŋur, nheny dhu muŋmuŋdhirra, dhärukmiriwyirra, ga yan bili ga maḻŋ'thurr ŋayi dhu boŋguŋ ŋunhiyi yothu nhuŋu. Yo. Bäyŋun nhe dhu gi ŋunhi waŋiny ga yan bili ga maḻŋ'thurr dhu boŋguŋ. Ga balanya nhuŋu dhuwal dhäwuny'.” Ga bitjarryin ŋayi gan ŋunhi djiwarr'puynydja yolŋu waŋan. ");
INSERT INTO djr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ga balanyamirriy bili waluy ŋayipiny gan ŋunhi Djakarayany nhinanan ŋunhiliyin banydjin yan djinawan' ŋärra'ŋura, ga walalnydja gan ŋunhalnydja warraŋulnydja yolŋuny walal wiyinnha nhanŋu galkurrnydja. Bala walal guyaŋanan bitjarra, “Way, nhaltjanna ŋayi ga ŋunha ŋärra'ŋurnydja? Wiyinnha ŋayi ŋunha gulŋiyinany.” ");
INSERT INTO djr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ga ŋunhi nhakun ŋayi Djakaraya dhawaṯthurrnydja beŋuryiny ŋunhi ŋärra'ŋurnydja muŋmuŋnha, dhärukmiriwnha, yakan ŋayi ganha waŋanhany walalaŋ. Waŋanany ŋayi walalaŋ gan waṉa'-waṉa'yurra yan, bala walalnydja yolŋuny walal ŋunhalnydja maŋutji-nhänhaminan nhanŋu, bala yan walal dharaŋara ŋanya ŋunhi ŋayi nhäŋal maŋutji-djurthin ŋula nhä ŋunhal djinawa' ŋärra'ŋur. ");
INSERT INTO djr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Manymak. Ga ŋunhi nhakun ŋayi Djakarayay dhawar'maraŋalnydja djämany mala ŋunhili dhuyuŋurnydja buṉbuŋur, bala yan ŋayi marrtjinan roŋiyinan wäŋalila. ");
INSERT INTO djr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Dhäŋur beŋuryiny bala nhanŋu ŋunhi miyalktja Litjipittja dhunupan yan yothumirriyinan. Ga goŋ-waŋganydhuny ŋaḻindiy bala ŋayi Litjipittja ŋayipiny ŋurru-wiḏi'yurra yolŋuwalnydja walalaŋgal, bäyŋun ganha yolŋuynydja walal ŋanya bukuny nhänha, nhinanan yan ŋayi gan djinawan buṉbuŋura. ");
INSERT INTO djr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Bala ŋayi gan Litjipittja waŋanhaminan bitjanminan, “Yaka bilin? Garraywuŋ guŋga'yunawuy ŋarra ga dhuwal gäman yothun? Ŋäthilnydja ŋarra gan ŋunhi yolŋuwalnydja walalaŋgal nhinan goramirriyin, ŋunhi ŋarra yothumiriwnydja yan. Ga dhiyaŋuny bala ŋarraku dhuwal bilin gorany djaw'yunawuynha Garraywuŋuny.” ");
INSERT INTO djr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","28","Yo. Ga waŋgany miyalk yäku Meri* gan nhinan ŋunhili wäŋaŋur yäkuŋur Nätjuritj* makarrŋurnydja Galali,* yurr Meriny ŋunhi wirrkuḻ yan ga ḻuni; yaka ŋayi ŋula ŋäthilnydja ḏirramuwal ŋorranha. Yurr ŋayi ŋunhi dhawu'mirrnydja Meriny ḏirramuw yäkuw Djawutjipku,* ga yarraṯaŋurnydja ŋayi ŋunhiyi Djawutjiptja ŋurruḏawalaŋuwal yäkuwal Daybitkal.* Ga balanyamirriy yan waluy ŋayiny gan Litjipitthuny* yothunhany gurrukaŋala guḻundhun, yurr ŋaḻindiny nhanŋu ŋunhi goŋ-waŋganynha ga waŋgany bäythinyawuy, bala God-Waŋarryuny djuy'yurra dhäwu-gänhamirrinhany yolŋuny yäkuny Gaybirilnhany balan wäŋalil Nätjuritjlila. Ga ŋunhiyi dhäwu-gänhamirrnydja bunanan Meriwnydja, bala ŋayi waŋanan nhanukal bitjarra, “Way Meri! Biyakun ŋoy-ŋamathin! Garrayyuny nhuna dhuwal djarr'yurra, gänaŋ'maraŋala, ga märr-ŋamathirrnydja ŋayi nhuŋu ga ŋunha mirithirra yan. Garraynydja nhokal galki.” ");
INSERT INTO djr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Yurr ŋayiny ŋunhi Meriynydja ŋathil gan guyaŋan ŋupar ŋunhiyi dhäruk. “Nhaku dhuwal ŋayi bitjarryiny ŋarraku waŋan?” Ga bitjarr warray ŋayiny Meriynydja ŋäkul ganyim'thurr, märr-dhumbal'yurra manapar. ");
INSERT INTO djr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ga ŋayiny ŋunhi God-Waŋarrwuny dhäwu-gänhamirrnydja yolŋu waŋan nhanukal bitjarra, “Meri, yaka ŋoy-gärri. Garraynydja nhuŋu ŋunha mirithin goŋmirriyin, bala ŋayi ŋunha djarr'yurra nhuna. ");
INSERT INTO djr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nheny dhu dhuwal yothumirriyirra, ga dhawal-guyaŋiny ŋayi boŋguŋ ŋunhi ḏirramu yothuny nhokuŋ, bala nhe dhu ŋanya yäku-nhirrpulnydja Djesun. ");
INSERT INTO djr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ŋayiny dhu boŋguŋ ŋunhi yindin mirithirra ga ŋurruŋun, ga lakaraŋuny ŋanya walal dhu gi ŋunhi biyakun, Gäthu'mirriŋu nhanŋu God-Waŋarrwu, ŋuriki ŋunhi ŋayiny ŋurruŋu warray Waŋarr. God-Waŋarryuny ŋanya dhu ŋurruŋuyaŋun, ga ŋayiny dhu Djesuny buŋgawathin balanyan bili yan dharaŋana nhakun mala-ŋurrkanhayŋu nhanŋu Geŋ-Daybit. ");
INSERT INTO djr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ga ŋayin dhu ŋunhiyin yolŋu ŋurruḏawalaŋuny Djaykupkuŋuny mala-bunhawuy, bitjanna bili dhu; ga bäyŋun nhanŋu dhu ŋunhi romdja dhawar'yurr, dhärran dhu ga bitjanna bili yan wiyinŋumirra.” ");
INSERT INTO djr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ga ŋayiny Meriny buku-ḏuwaṯthurr ŋurikiyiny djiwarr'wuywuny dhäwu-gänhamirriw yolŋuw bitjarr, “Nhaltjan dhika dhu yulŋuny? Wanhawitjan dhika dhu bitjandhiny maḻŋ'thun ŋunhi ŋarrany dhuwal ḏirramumiriw warray?” ");
INSERT INTO djr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ga ŋayiny ŋunhi God-Waŋarrwuny dhäwu-gänhamirrnydja waŋan nhanŋu buku-bakmaraŋal bitjarra, “Dhuyu-Birrimbirrnydja dhu marrtjin nhokal, ga nhanukal God-Waŋarrwalnydja ganydjarryu dhu dhurrthurryunna nhuna, ga dhiyaŋiyin dhu ŋunhi yothuny dhawal-guyaŋa nhokuŋuny, ga yothunhany dhuwali walal dhu ga lakaramany dharrpal Gäthu'mirriŋu nhanŋuwuy yan God-Waŋarrwu. ");
INSERT INTO djr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nhe ŋathil guyaŋi nhuŋuwuy nhe gurruṯumirriny yolŋuny yäkuny Litjipitnha. Dhiyaŋuny bala ŋayi ŋunha worruŋun miyalk, ga dhalwaŋiny muka ŋayi ŋunhi ŋäthilnydja. Yurr dhiyaŋuny bala ŋayi ŋunha Litjipittja yothumirra, ga goŋ-waŋgany ga waŋgany bäythinyawuy ŋaḻindiny ŋurikiyi yothuwnydja ŋunhi ŋayi ga gämany ŋunhayi. ");
INSERT INTO djr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bäyŋun ŋunhi ŋula nhä gumurr-ḏäl God-Waŋarrwuny djämaw.” Ga bitjarra gan ŋunhi dhäwumirrnydja waŋan Meriwalnydja. ");
INSERT INTO djr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Bala ŋayi yan Meriny waŋanan buku-bakmaraŋala bitjarra, “Dhuwandja ŋarrany nhanŋuwuynha yan Garraywun djämamirr. Garrayyun dhu ŋunhi ŋayipin bitjandhiny ŋarrakal djäma, nhakun nhe ga dhuwaliyi lakaram.” Yo, bitjarryin ŋayiny gan ŋunhi Meriny waŋan. Bala ŋuriŋiyiny God-Waŋarrwalnydja dhäwu-gänhamirriynydja yolŋuy Merinhany ganarrthaŋala. ");
INSERT INTO djr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ga dhäŋur beŋuryiny ŋunhi ŋayi djiwarr'puyyuny yolŋuy ganarrthaŋalnydja ŋanya Merinhany, bala ŋayiny Meriny dhunupan rur'yurra, bala marrtjinan ganydjarryun yan balan Litjipitkala wäŋalil. Yurr maṉḏany gan ŋunhi Litjipittja ga dhuway'mirriŋuny nhanŋu Djakarayany nhinan ŋunhiliyin bukumirriŋura wäŋaŋur, makarrŋurnydja wäŋaŋur yäkuŋur Djudiyan. Bala ŋayi marrtjinan Meriny ŋunhiwiliyin wäŋalil, bala yan bunanan Litjipitkuny. ");
INSERT INTO djr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bala yan ŋayi dhunupan gärrinan bala'lila djinawa'lila, ga ŋunhiliyin maṉḏa ŋunhi djinawan' bunanhaminany. ");
INSERT INTO djr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ga ŋunhi nhakun ŋayi Litjipitthu ŋäkulnydja ŋanya Merinhany rirrakay, bala nhanŋu ŋunhi Litjipitkuny yothuny ŋunha djinawany' guḻunŋurnydja ŋärawayinan, yurr mirithinan dhika, bala nhanŋu ŋunhi Litjipitkuny ŋayaŋuny dhaŋaŋdhinan Dhuyu-Birrimbirryun. ");
INSERT INTO djr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bala ŋayi mirithinan waŋanany Meriwnydja bitjarra gam', “Nheny dhuwal gänaŋ'maranhawuy warray God-Waŋarrwuŋ, ŋurukuwurruŋgalnydja ŋunhi wiripuwurruŋgalnydja miyalkkurruwurruŋgal. Nhuŋun ŋayi ga ŋunhi God-Waŋarrnydja mirithirrnydja marrkapthun; ga bitjandhi bili ŋayi ga marrkapthundhi dhiyakiny yothuwnydja nhokalaŋaw ŋunhi ŋayi dhu dhawal-guyaŋiny nhokuŋ. ");
INSERT INTO djr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nheny dhuwal ŋäṉḏi'mirriŋu ŋarrakalaŋawnha Garraywu; ga nhaku nhe dhuwal räliny ŋarrakalnydja marrtjin? Yaka warray ŋarrany dhuwal goŋmirr miyalk. ");
INSERT INTO djr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ŋunhi ŋarra ŋäkulnydja nhuna rirrakaynydja, bala ŋarraku dhuwal yothuny guḻunŋurnydja ŋarrakal ŋärawayinan, goŋmirriyinan mirithinan. ");
INSERT INTO djr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ga nheny yaka warray märr-yuḻkthunna ŋanya Garraynha; yänan nhe ŋanya ŋunhi dhäruktja märraŋala, märr-yuwalkthinan manapar, bala Garrayyuny dhu ŋunhi djäman bala yan ŋunhi nhä ŋayi nhuna wäwunguŋal.” Ga bitjarra ŋayi gan ŋunhi Litjipittja waŋan Meriwalnydja. ");
INSERT INTO djr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Bala ŋayi Meriny waŋanan goŋmirriyinan manapar bitjarra, “Ŋarrany dhuwal dhu wokthundja Garraywun; ga yäku-lakaramany ŋarra ŋanya dhu yindikuman. ");
INSERT INTO djr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ŋayaŋu-ŋamathinany ŋarra dhuwal mirithinan dhika, goŋmirriyinan manapar, bili God-Waŋarrnydja ŋunha ŋarraku warray Walŋakunhamirr Garray. ");
INSERT INTO djr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ŋarrany dhuwal gänaŋuwuy miyalk, ḻäypuy balanya, yaka ŋarra dhuwal ṉapuŋga'wuynydja ŋula goŋmirrnydja, yurr ŋayipiny ŋarrany ŋunhi God-Waŋarryuny manymak-lakaraŋala, ŋunhi ŋarrany dhuwal nhanŋuwuynha yan djämamirrnydja. Ga dhipuŋurnydja gay'yi dhurrwaraŋur walalnydja dhu ga yolŋuynydja walal bukmakthun yan yäku-lakaramany ŋarranhany bitjanna, ‘Dhuwandja gay'yi miyalk maŋutji-dhunupayanhawuy God-Waŋarrwuŋ.’ Bitjandhin walal dhu ga ŋunhi lakaramany ŋarrany bitjanna bili yan wiyinŋumirra. ");
INSERT INTO djr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bili yuwalk warray ŋayi ŋarrany ŋunhi God-Waŋarryuny guŋga'yurr, ga djämany ŋayi ŋarrakal ŋunhi yindin mirithirra ŋayaŋu-ganyim'thunamirra romdja. Ŋayiny ŋunhi God-Waŋarr Ŋutu' Ḏäl, ga yäkuny ŋayi ŋunhi ḏarrtjalknha yan, dhuyun dhika, gänaŋ'thunna ga ŋula yolkalnydja yäkuŋur. ");
INSERT INTO djr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ga bulu ŋayi ŋuli ga ŋunhi mel-wuyun ŋurikiwurruŋ yolŋuw walalaŋ, ŋunhi walal ŋuli ga ŋurruŋuyam ŋanya, ga buku-ŋal'yun, barrarirr manapan nhanŋu. Yo, maŋutji-wuyundja ŋayi dhu ga ŋunhi walalaŋguwuynha yan ŋurikiwurruŋdhin, ga walalaŋgalaŋaw mala-bunhawuywun. ");
INSERT INTO djr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ŋayiny ŋunhi God-Waŋarrnydja ganydjarr-ḏumurr warray, ga limurrunhany ŋayi ŋunhi guŋga'yurr ŋuriŋiyi bili yan nhanukiyingal ŋayi ganydjarryuny, ga ŋaŋ'ŋaŋ'thurr ŋayi waṉḏinyamaraŋal ŋunhiwurruny yolŋuny walalany, ŋunhi walal ŋuli ga lakaranhamirr bitjanmirr, yanbi walal ganydjarr-ḏilkurra. ");
INSERT INTO djr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wiripuwurrnydja yolŋu walal ŋuli ga ŋunhi ŋurruḏawalaŋun lakaranhamirr, yanbi walal be buŋgawan mala ganydjarr-ḏilkurra, yurr ŋayipiny walalany ŋunhi God-Waŋarryuny nyumukuṉiny'kuŋal warray, nyilŋ'maraŋala walalany. Ga garrwarkuŋalnydja ŋayi ŋunhiwurrunhan yolŋunhany walalany, ŋurruwuykmirrinhan, goŋ-gänaŋunhan mala yolŋuny walalany. ");
INSERT INTO djr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ga ŋunhiwurrnydja yolŋu walal ŋunhi walal gan nhinan ŋula nhämiriw, goŋ-waŋarany, ga ŋayiny walalany gan ŋunhi God-Waŋarryuny gurruparnydja nhanŋuwuynha ŋayi manymaktja malany, ga yan bili ga bäy walal gana'yin ŋayaŋu-bakthurr. Yurr ŋunhiwurrunhany yolŋuny walalany ḻukunydja'mirrinhany, ŋayi ŋuli ganha ŋaŋ'ŋaŋ'thuna, walal ŋuli marrtjinyany yänan bala goŋ-waŋaran, dhäparŋ'nha dhika. ");
INSERT INTO djr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yo. Guŋga'yurrnydja ŋayi gan limurrunhawuynha yan, ŋunhi nhanŋuwuy yan djämamirriny Yitjuralnha malany. Mel-wuyurrnydja ŋayi gan ŋunhi limurruŋ mirithin yan, ");
INSERT INTO djr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","bili ŋayi gan guyaŋan ŋunhiyi wäwun'-nhirrpanawuy, ŋunhi ŋayi wäwunguŋal be ŋäthil limurruŋgalaŋuwal mala-ŋurrkanhayŋuwal Yipurayimgal. Bitjarr ŋayi ŋunhi wäwun'tja nhirrpar gam', Ŋarran nhuŋu dhu ga ŋunhi maŋutji-wuyundja, Yipurayim, ga nhokalaŋuw gäthu'mirriŋuwnydja walalaŋ, ga nhokalaŋuw marratja'mirriŋuwnydja walalaŋ, bitjanna bili yan. Yo, ŋayathaŋalnydja ŋayi gan ŋunhi baṯ-bitjarra ŋunhiyi wäwun'tja nhanukiyinguŋ ŋayi; ga dhiyaŋuny bala ŋunhiyi litjalaŋgalaŋumirrnydja wäwun'mirr maḻŋ'thurra dhu, dhiyala limurruŋgalnha, guŋga'yunawuynydja God-Waŋarrwuŋun.” Ga bitjarra ŋayi gan ŋunhi Meriynydja yäku-lakaraŋal ŋanya God-Waŋarrnhany manikaywurrnydja, wokthurrnydja manapar nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Bala ŋayi gan Meriny nhinanan ŋunhilin banydjin yan Litjipitkala wäŋaŋurnydja, ga yan bili ga ḻurrkun' ŋaḻindi djuḻkthurr. Ga dhäŋur beŋuryiny bala ŋayi roŋiyinan nhanukiyingala ŋayi wäŋalil. ");
INSERT INTO djr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Balanyamirriyyiny ŋayi ŋunhi Litjipittja yothumirriyinan, bala ŋayi gan marrtjinany yuṯuŋgurr-ŋonuŋnha, ga yan bili ga yothuw nhanukalaŋaw walu galkithin dhawal-guyaŋanharaw. Bala nhanukuŋ ŋunhi dhawal-guyaŋanany ḏirramun yothuny. ");
INSERT INTO djr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ga walalnydja ŋunhi nhanukiyingalnydja gurruṯumirriy walal ga bulu nhakun wiripuwurruy yolŋuy walal ŋunhi walalaŋ marrtjin wäŋa mala dhärra'-dharran galkiwatj, ŋäkula walal ŋunhi Litjipitkalaŋuwuynydja dhäwu ŋunhi ŋayi God-Waŋarr mel-wuyurr nhanŋu, bala nhanukuŋ ŋunhi yothuny dhawal-guyaŋanan ḏirramun yothuny. Ga mirithinan walal ŋunhi dhika goŋmirriyinany Litjipitkuny ŋoy-djulŋithinan manapar. ");
INSERT INTO djr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ga goŋ-waŋgany ga märrma' bäythinyawuy munha djuḻkthurr, bala walal marrtjin ḻuŋ'maranhaminan ḏarrtjalkkunharawnha nhanŋu ŋurikiyin yothuwnha. Ga yäku-nhirrpanany walal balaŋ ŋanya ŋunhi Djakaraya muka, bäpa'mirriŋuwal yan yäku. ");
INSERT INTO djr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bala ŋayiny ŋäṉḏi'mirriŋuny nhanŋu Litjipittja waŋan bitjarra, “Yaka! Dhuwal ŋayi yäku Djon.” ");
INSERT INTO djr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ga walalnydja nhanŋu buku-bakmaraŋal bitjarr warray, “Wäy, wanhaŋuwuynha dhuwaliny yäku maḻŋ'thurr? Bäyŋun gi dhuwal balanyayiny yäku dhärri dhiyalnydja nhanukiyingalnydja gurruṯumirriwal walalaŋgal.” ");
INSERT INTO djr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ga walalnydja ŋuriŋi yolŋuynydja walal dhä-birrka'yurr ŋanya Djakarayanhany goŋdhun yan bitjarra, “Nhä nheny dhu ŋanya yäku-nhirrpan?” ");
INSERT INTO djr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bala ŋayi Djakarayaynydja ŋäŋ'thurra walalany guṉḏawnha bilkpilkkun, bala ŋayi ŋunhi wukirriny bitjarra gam', “Dhuwal ŋayi dhu ga yäkuny dhärra Djon.” Ga walalnydja ŋunhi yolŋuny walal mirithinan yan märr-maŋmaŋdhurrnydja. ");
INSERT INTO djr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ga dhunupan yan ŋayiny ŋunhi Djakarayany waŋanan, dhärukmirriyinan, bala yan märr-yiŋgathinany God-Waŋarrwuny mirithinan yan dhika. ");
INSERT INTO djr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ga ŋunhiwurrnydja yolŋu walal ŋunhi walalaŋ gan wäŋa dhärran galki maṉḏaŋgal Litjipitkal ga dhuway'mirriŋuwal nhanukalaŋuwal, walalnydja ŋunhi mirithinan yan ganyim'thurrnydja, märr-maŋmaŋdhurra manapar. Ga ŋulawitjarryiny wäŋakurr bukukurrnydja nhakun buku-ḻiw'maraŋalnydja Djudiyawurrnydja makarrkurr, yolŋuny walal marrtjin dhäwu-gänhaminan lakaranhaminan ŋunhiŋuwuyyiny ŋunhi gan nhä malany maḻŋ'thurr maṉḏaŋ Djakarayaw ga Litjipitku. ");
INSERT INTO djr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ga ŋuriŋiwurruynydja ŋunhi walal gan bilin nhakun ŋäkula dhäwuny', walalnydja gan ŋunhi guyaŋanan, bala gan ŋäŋ'thunminan walalanhawuynha walal waŋga'-waŋganynha yan bitjanminan, “Way! Nhalayak ŋayi dhu dhuwal yulŋuny, ŋunhi ŋayi boŋguŋ ŋunha yothuny yindithiny ŋuthul? Nhän boŋguŋ ŋayi gi balanyamirriyyiny waluy djäma?” Ŋunhi walal gan bitjarryiny waŋanhamin, bili walal ŋunhi nhäŋala ŋamathaŋala God-Waŋarrwun ganydjarr ŋuliwitjarryin yothuwalaŋuwurra. ");
INSERT INTO djr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ga ŋayiny ŋunhi Djakarayany, bäpa'mirriŋuny nhanŋu ŋurikiyiny yothuw Djonguny, ŋayaŋuny nhanŋu ŋunhi dhaŋaŋdhinan Dhuyu-Birrimbirryun, bala ŋayi waŋanany dhunupan yan dhäruktja God-Waŋarrwuŋun gurrupanawuynydja. Bitjarra ŋayi gan ŋunhi Djakarayay lakaraŋalnydja gam', ");
INSERT INTO djr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Go limurr wokthunna Garraywun, ŋuriki Garraywu ŋunhi ŋayi Waŋarr Yitjuralwu malaw! Go limurr buku-ŋal'yunna nhanŋu, bili ŋayi yarrupthurrnydja räliny limurruŋ muka, bala ŋayi gan roŋanmaraŋala limurrunhany dhipala ŋunhi baḻanydjarratjarralila romlilnydja. ");
INSERT INTO djr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Garrayyuny limurruny ŋunhi gurrupar Walŋakunhamirriny warray, ga Ŋutu' Ḏälnha, ŋunhi ŋayiny yarraṯaŋur beŋur yan Daybitkal, ŋurikalyi yolŋuwal ŋunhi Godkalaŋuwal djämamirriwal. ");
INSERT INTO djr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ŋäthilnydja baman'tja be God-Waŋarryu wäwunguŋal limurruny ŋurikiwurruŋgalaŋuwurryi ŋunhi nhanukiyingalaŋuwal ŋayi ŋayaŋu-ḏarrtjalkmirriwal djawarrkmirriwal walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bitjarr ŋayi ŋunhi God-Waŋarryu wäwunguŋalnydja gam', ŋayi dhu dhawaṯmaraman limurrunhany ŋurikiwurruŋgalnydja goŋŋur ŋunhi walalnydja miriŋu limurruŋ; ŋurikiwurruŋgalyiny ŋunhi walal ŋuli ga ŋaramurryirr limurruŋ. Yo, Garrayyuny dhu ŋunhi limurrunhany walŋakuman. ");
INSERT INTO djr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ŋayiny ŋunhi limurruŋguny wuyurr bitjarr yan bili nhakun ŋayi wäwunguŋal baman' ŋäthil limurruŋ mala-ŋurrkanhayŋuny, ga bäyŋun ŋayi dhu ŋunhi limurruny momany ŋurikiwuyyiny ŋunhi ŋayi djäma nhanŋuwuy ŋayi dharrpal gumurrkunhaminyawuy rom limurruŋgal. ");
INSERT INTO djr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Yo. Ga waŋanany ŋayi gan ŋunhi God-Waŋarryuny ŋäthilnydja, mirithin yan djägakuŋalnydja ŋunhiyiny yolŋuny limurruŋguny mala-ŋurrkanhayŋunhany yäkuny Yipurayimnhany. Ga bitjarr ŋayi ŋunhi wäwun'tja nhanukal gurrupar gam', limurrunhany ŋayi dhu märraman dhawaṯmaraman beŋurnydja ŋunhi miriŋuwalnydja goŋŋur, märr limurrnydja dhu ga buku-ŋal'yundja nhanŋuwuynha yan. Ga yakan limurr dhu ŋunhi barrarirrnydja ŋula nhakuny malaŋuw; ga buku-ŋal'yundja limurr dhu ga ŋunhi Garraywuny barrarimiriwnha yan ŋula nhämiriwnha. ");
INSERT INTO djr_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Gänaŋ'thunna yan limurr dhu ga nhinany, märr-dhunupan ga ŋayaŋu-ḏarrtjalknha, nhanŋuwuynha yan bitjanna bili, ga yan bili ga walŋa dhu limurruŋ dhä-dhawar'yun dhiyal munatha'ŋur. ");
INSERT INTO djr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ga nhunahany ŋarrakuny yothu, walal dhu gi lakaraŋ biyakun ŋunhi nheny God-Waŋarrwun djawarrkmirr, ŋurikiyin ŋunhi ŋayi ga nhina be bala barrku mirithirr ŋunha bala djiwarr'ŋur. Nhen dhu ŋunhi ŋurruŋu-djuḻkthundja, märr nhe dhu dhukarrnha yäkthun ŋäthilmirriyaman nhanŋun Garraywun. ");
INSERT INTO djr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nheny dhu ga ŋunhi lakaraman yolŋuwalnydja walalaŋgal, märr walalnydja dhu marŋgithirra Garraywuny walalaŋgalaŋaw ŋunhi Walŋakunhamirriwnydja, ŋunhi ŋayi dhu Garrayyuny walalany walŋakuman, ŋunhiny ŋayi dhu bäy-lakaraman ga buwayakkuman walalaŋ dhuwurr-yätjkurra rom, bala ŋayi dhu märraman walalany dhawaṯmaraman beŋuryiny ŋunhi yätjkurruŋurnydja romŋur. ");
INSERT INTO djr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bili limurruŋguny dhuwal God-Waŋarr märr-ŋamathinyamirr warray, ga mel-wuyunamirr. Bili ŋayi dhu ŋunhi marrtji räliny limurruŋgalnydja, bitjanna nhakun ŋuli ŋunhi baṉumbirryu djaḏaw'maram wäŋany, bala ŋayi ŋuli munhany winya'yunna. ");
INSERT INTO djr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nhanukalnydja baḏayalay' dhu ga djeŋarra'yaman beŋurnydja ŋunhi djiwarr'ŋurnydja, bala dhu djarraṯawun'mirriyaman ŋilimurrunhany, ŋunhiwurrunhany ŋunhi limurr ga nhina buku-munhaŋur, dhiŋganhamirriŋur yan romŋur, bala ŋayi dhu nhirrpandja limurruny romlilnydja manymaklila dhikan, mägayalila, märr limurr dhu ga marrtjiny nhanukiyingalaŋuwurra yan romgurrnydja.” Ga bitjarra ŋayi gan ŋunhi Djakarayay lakaraŋalnydja God-Waŋarrwuny dhäruk. ");
INSERT INTO djr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yo. Bala ŋayi ŋunhiyi yothuny yäku Djondja ŋutharnydja yindithinan rumbal ŋayi ga guyaŋanhawuy nhanŋu. Bala ŋayi ŋunhi marrtjinany balan nharaŋlila wäŋalilnydja wiraŋlila, yolŋumiriwlila, ga nhinanany ŋayi gan ŋunhiliyiny bitjarrnha bilin yan, ga yan bili ga walu nhanŋu galkithin, ŋayi dhu milkunhamirra ŋanyapinya ŋayi walalaŋgala Yitjuralwal malawal. ");
INSERT INTO djr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Yo. Balanyamirriynydja waluy ŋayi ŋurruŋu buŋgawa wäŋa Rawumbuy yolŋu yäku Yokatha* dhäruk-djuy'yunminan yolŋuwnha walalaŋ bukmakkun yan, ŋunhiwili wäŋalil malaŋulil ŋunhi nhanukal gan wäŋa malany goŋŋur dhärran, ga bitjarra ŋayi ŋunhi dhäruk djuy'yunminany walalaŋ gam', “Way yolŋu walal, wäŋgam nhuma dhu bala nhumalaŋgiyingala wäŋalil malaŋulil yirralkalil, ŋunhi wanhami nhuma gan waka'-ŋurrkanhamin, dhipuŋuryiny wäŋaŋur malaŋuŋur ŋunhi nhuma ga dhuwaliyi nhina dhiyaŋ bala, ga ŋunhiliyi nhuma dhu yäku-nhirrpanmirr djorra'lil malaŋulil, märr napurr dhu nhumalany bothurru'.” Ga balanyamirriy bili, dhä-gandarrpuyyu buŋgaway yäkuy Guriniyay* gan ŋayathaŋal wäŋa makarr yäku Djiriya. ");
INSERT INTO djr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bala bukmaknha ŋunhi yolŋuny walal marrtjinany ŋunhiwiliyin walalaŋgiyingala walal wäŋalilnydja malaŋulil yäku-nhirrpanminyarawnha. ");
INSERT INTO djr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ga ŋunhiyi ḏirramu yäku Djawutjiptja* gan nhinan wäŋaŋur yäkuŋur Nätjuritj,* makarrŋurnydja Galali,* yurr ŋayi ŋunhi yarraṯaŋurnydja ŋurruḏawalaŋuwal yäkuwal Daybitkal,* ga ŋunhiyiny baman'ŋuwuynydja buŋgawa yäku Daybittja ŋurikiwuyin wäŋapuy maḻŋ'thunawuy Bithiliyambuynha,* makarrŋurnydja Djudiya. Bala ŋayi Djawutjiptja marrtjinan balayin wäŋalil Bithiliyamlila yäku-nhirrpanminyarawnha nhanŋuwuy ŋayi, bili nhanŋun ŋunhiyiny wäŋa Djawutjipkun, ŋunhi ŋayi Daybitkal yarraṯaŋur. ");
INSERT INTO djr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ga marrtjinany ŋayi ŋunhi Djawutjiptja goŋ-Meriwalaŋumirra, bili nhanŋu muka ŋayi ŋunhi miyalktja dhawu'mirrnydja. Yurr ŋayi ŋunhi Meriny balanyamirriynydja galŋa-ŋonuŋnha. ");
INSERT INTO djr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ga ŋunhi maṉḏa gan nhinanany ŋunhiliyiny wäŋaŋur Bithiliyamdja, bala nhanukalaŋaw yothuwnydja waluny galkithinan dhawal-guyaŋanharawnha. ");
INSERT INTO djr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bala nhanukuŋ ŋunhi Meriwuŋuny yothuny maḻamarrnydja dhawal-guyaŋanany ḏirramun, ga ŋayiny ŋanya Meriynydja garrpir girriy'nha, bala ŋanya ŋayi yorrkuŋalnydja ŋunhi yothunhany ŋunhiwilin bala'palalilnydja mulmumirrilila, ŋunhi gan ŋatha malany ŋorran warrakan'ku malaŋuw ŋunhiliyi. Ga ŋunhiny buṉbu ŋunhi ŋuli ganha yolŋu walal ŋorra'-ŋurranha, ŋunhiliyiny buṉbuŋur dhaŋaŋdhin ŋäthil yan, ga bäyŋuthinan ŋunhi maṉḏaŋguny dhaḻakarr ŋorranharaw, bala ŋanya ŋayi Meriynydja yorrkuŋala yothunhany warrakan'kala nyumukuṉiny'lila bala'palalilnydja. ");
INSERT INTO djr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","9","Ga ŋunhili bili yan waŋganyŋur wäŋaŋur, yurr ḏiltjiŋura, warrakan'-djägamirr mala gan djäga walalaŋgiyingalaŋaw bimbiw malaŋuw. Ga ŋuriŋi bili munhay, God-Waŋarrwu dhäwu-gänhamirrnydja yolŋu walal maḻŋ'thurra walalaŋgal ŋunhiliyiny warrakan-djägamirriwalnydja malaŋuwal, ga baḏayalayny'tja walalany ŋunhi Garraywalnydja ḻiw'maraŋala djeŋarra'yaŋal, ga barrarinany walal ŋunhi mirithinan yan dhika. ");
INSERT INTO djr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ga ŋayiny ŋunhi God-Waŋarrwuny dhäwu-gänhamirrnydja yolŋu waŋan walalaŋ bitjarr, “Yaka walal barrari. Ŋarrany dhuwal marrtjin räli gäŋal mirithirr manymak dhäwu nhumalaŋ, ga dhiyaŋiyin dhu ŋunhi dhäwuyny'tja galŋa-djulŋithinyamaramany yolŋunhany walalany bukmaknhan yan. ");
INSERT INTO djr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bili dhiyaŋuny bala munhay gäthurnydja nhumalaŋ Walŋakunhamirrnydja bilin dhawal-guyaŋanan ŋunhan Daybitkala wäŋaŋurnydja, yurr ŋayi ŋunhi Maŋutji-dhunupayanhawuynha Garray. ");
INSERT INTO djr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ga dhuwalatjanna nhuma ŋanya dhu ŋunhi dharaŋandja, maḻŋ'maramany nhuma dhu ŋanya ŋunhiyi yothunhany garrpinawuynha girri'mirra, ga ŋorrany ŋayi ga ŋunha warrakan'kala mulmumirriŋura bala'palaŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ga dhäŋur beŋuryiny, dharrwan mirithirra ŋunhi God-Waŋarrwuny dhäwu-gänhamirrnydja yolŋu walal gan maḻŋ'thurrnydja, ḻiw'maraŋala walalany walal ŋunhi dhärranany. Ga bukmak yan ŋunhi djiwarr'puynydja yolŋu mala gan mirithinan dhika märr-yiŋgathinany God-Waŋarrwuny, ga ḏar'ṯaryurrnydja walal gan ŋunhi manikaynydja bitjarra, ");
INSERT INTO djr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“God-Waŋarrnydja dhuwal bulu warray ŋayiny garrwar, ga latju' ŋayi mirithirr dhika djeŋarra'mirr; ŋunhalnydja ŋunhi djiwarr'ŋurnydja ŋanapurrnydja ŋuli ga wokthun warray nhanŋu, buku-ŋal'yun manapan. Ga dhiyal munatha'ŋurnydja wäŋaŋur nhumany dhu ga ŋunhi yolŋuny walal nhina mägayamirriŋura romŋur, bili God-Waŋarrnydja ga nhumalaŋ dhuwal mirithirr yan märr-ŋamathirr, bala ŋayiny nhumalany dhu ŋunhi walŋakuman.” ");
INSERT INTO djr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ga ŋunhi walal manikayŋurnydja ḏar'ṯaryunaŋur dhawar'yurr bala walal ŋunhi God-Waŋarrwuny dhäwu-gänhamirrnydja yolŋu walal roŋiyinan djiwarr'lila beŋuryiny ŋunhi warrakan'-djägamirriwalnydja walalaŋgal. Bala walal gan ŋunhi warrakan'-djägamirrnydja walal waŋanhaminan bitjanminan, “Go limurr marrtjin Bithiliyamlila, limurr dhu maḻŋ'maram ŋunhi nhaltjarr ŋayi gan Garrayyu lakaraŋal limurruŋgal.” ");
INSERT INTO djr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bala walal yan gundupuŋalnydja ganydjarryun, ga maḻŋ'maraŋalnydja walal Meriny ga Djawutjipnha ga yothuny, ŋayi gan ŋorran mulmumirriŋur bala'palaŋur. ");
INSERT INTO djr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ga ŋunhi walal nhäŋalnydja, ga dhunupan bala yan walal marrtjin dhäwuny lakaraŋala birrŋ'maraŋala ŋunhiŋuwuyyiny ŋunhi nhaltjarr walalaŋgal gan djiwarr'puyyu dhäwumirriy lakaraŋal ŋurikalaŋuwuyyi yothuwalaŋuwuy. ");
INSERT INTO djr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ga bukmakthun gan ŋunhi yolŋuynydja walal ŋäkulnydja ganyim'thurra dhäwuny', ŋunhi walalaŋgal gan warrakan'-djägamirriy yolŋuy walal lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yurr ŋayipiny gan ŋunhi Meriynydja ŋayathaŋala ŋunhiyiny mala dhäruktja ŋayaŋuynha nhanukiyingal ŋayi murrŋan gan warr'warryurr. ");
INSERT INTO djr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ga ŋunhi walal warrakan'-djägamirrnydja mala roŋiyinany gan ŋunhi bimbiwalnydja malaŋuwal, bala walal marrtjin ŋunhi wäŋgaŋalnydja lakaranhaminan märr-yiŋgathinan manapar mirithinan, ga yäku-ḏumurruyaŋala God-Waŋarrnhany Bäpanhany. Märr-yiŋgathinany walal marrtjin ŋunhi mirithinan yan, ga wokthurra ŋurikiny ŋunhi walal ŋäkul dhäwu, ga bulu nhakun walal ŋanya yothuny nhäŋal, bili walal maḻŋ'maraŋalnydja bukmak yan nhäny mala ŋunhi ŋayi gan nhaltjarr djiwarr'puyyu dhäwumirriy lakaraŋal walalaŋgal ŋäthil. ");
INSERT INTO djr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ga goŋ-waŋgany ga ḻurrkun' bäythinyawuy munha djuḻkthurr, ga waluny ŋunhi galkin ŋurikiyiny yothuwnydja ḏarrtjalkkunharawnha. Rom gan dhärran walalaŋ Djuw malaw, ŋunhi ŋuli goŋ-waŋgany ga ḻurrkun' bäythinyawuy walu djuḻkthunna, ŋunhiyiny walalaŋgalaŋaw djamarrkuḻiw'nha ḏirramuwurruŋgun walu ḏarrtjalkkunharawnha. Bala walal ŋanya ŋunhi yothunhany ḏarrtjalkkuŋala, ga ŋuriŋiyi bili yan waluy banydjiŋuryi bala walal ŋanya yäku-nhirrparnydja Djesun, ŋunhiyi bili yan yäku ŋunhi ŋayi God-Waŋarrwal dhäwu-gänhamirriy ŋäthil Meriwal lakaraŋal, ga yurrnha ŋayi ŋunhi yothumirriyinany. ");
INSERT INTO djr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","God-Waŋarrwuŋuny ŋunhi rom Mawtjitjthuny rulwaŋdhurr ŋäthilnydja bitjarr gam'. Ŋunhi dhu yothuny dhawal-guyaŋa, ga bäy dhu märrma' ŋaḻindi djuḻkthun, bala maṉḏany dhu bäpa'mirriŋuny ga ŋäṉḏi'mirriŋuny marrtji balan God-Waŋarrwala buṉbulilnydja buku-ŋal'yunamirrilila, maṉḏa dhu warrakan'nha mundhurr-wurrupan bala bathanna ŋunhiliyin God-Waŋarrwala buṉbuŋur. Ga dhuwaliyiny mayali' nhakun dhu ŋayipiny ŋäṉḏi'mirriŋuny gurrupanmirryi nhanukal God-Waŋarrwal, märr ŋanya ŋayi dhu ḏarrtjalkkuman nhanŋu ŋayaŋun ŋunhiŋuwuyyin ŋunhi yätjkurruwuynha rombuy mala. Dhuwaliyin ŋayi ŋunhi Mawtjitjthu romdja nhirrpar ŋäthilnydja. Yo. Ga ŋunhi nhakun Meriwnydja walu galkithin dhawaṯthunarawnha beŋurnydja ŋunhi yothuwalnydja gänhaŋur, bala maṉḏa Meriny ga Djawutjiptja marrtjinan balan Djurutjalamlila, ga ŋunhiliyiny maṉḏa mundhurrnha gurrupar warrakan'nha God-Waŋarrwun. Ga beŋuryiny maṉḏa dhayuŋara ŋunhiyi yothunhany Garraywala goŋlil, bitjarr yan bili nhakun ga ŋunhi rom barraŋga'yurr bitjarr gam', “Ŋurruŋuny dhuwaliyi yothu ḏirramu nhanŋuwuy yan Garraywu.” ");
INSERT INTO djr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ga bitjarryi bili maṉḏa gurruparyi ŋunhi warrakan'tja bathanarawnydja, mak murryil, nhä mak märrma' yuṯa muykandi maṉḏany, bili balanyayi gan ŋunhi romdja Garraywuny dhärran. ");
INSERT INTO djr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ga ŋunhili Djurutjalamdja* wäŋaŋur, ḏirramu gan nhinan yäku Djimiyan, yurr ŋayi ŋunhi dhuwurr-dhunupa ḏirramuny, ga märr-ŋamathinany ŋayi gan ŋunhi mirithinan yan Garraywuny. Yurr bitjarra bili ŋayi gan ŋunhi Djimiyandja dhukarr-nhäŋala gatjpu'yurra ŋurikiyin ŋunhi dhu Walŋakunhamirra buna, bala ŋayi dhu dhawar'maraman warwun walalaŋgal Yitjuralwalwun malaw. Ga Dhuyu Birrimbirrnydja gan nhinanan nhanukalnydja Djimiyangalnydja. ");
INSERT INTO djr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ga ŋuriŋiyi Dhuyu-Birrimbirryu lakaraŋal Djimiyangal bitjarr, “Nheny dhu dhuwal yaka dhiŋgam yänayiny; baḏak ŋathil nhe dhu ga galkun ga bäy nhe dhu nhäma Garraynha ŋunhi ŋayiny Maŋutji-dhunupayanhawuy God-Waŋarrwuŋun.” ");
INSERT INTO djr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ga waŋganydhuny waluy ŋayi Dhuyu-Birrimbirryu garr'yurra ŋanya Djimiyannhany balan God-Waŋarrwala buku-ŋal'yunamirrilila buṉbulil, ga ŋuriŋiyi bili yan waluy maṉḏany Djawutjipthuny ga Meriynydja gäŋala ŋanya yothunhany Djesunhany ŋunhiwiliyi bili yan buku-ŋal'yunamirrilil buṉbulil, märr maṉḏa dhu ŋanya goŋ-gurrupanna Garraywala goŋlil. ");
INSERT INTO djr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bala ŋayi ŋanya Djimiyandhuny nhäŋala ŋunhiyi yothunhany, bala ḻaw'maraŋala ŋanya, bala dhangi'yurra ŋayi ŋanya waṉaynha nhanukiyingal ŋayi, bala ŋayi buku-gurrpara God-Waŋarrnhany bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Garray, nheny gan ŋunhi ŋayathaŋal yan nhuŋuwuy nhe dhawuny', ŋunhi nhe wäwunguŋal ŋäthil. Go märraŋun ŋarrany, nhuŋuwuynydja nhe djämamirriny, ŋarra dhu dhiŋgamany burrmiḏiynha romdhuny. ");
INSERT INTO djr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bilin ŋarra dhuwal nhäŋala ŋarrakiyingala ŋarra maŋutjiynydja ŋunhi Walŋakunhamirrinhany, nhokiyinguŋuny djuy'yunawuynha, ");
INSERT INTO djr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ŋunhi nhe ŋanya Garraykuŋal ŋäthilmirriyaŋal bukmakku yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ŋayin ŋunhi dhuwanna baḏayalany', baḏayala'kunharawnydja walalaŋ ŋurikiwurruŋguny Djan'tayilwuny yolŋuw walalaŋ bukmakku yan malaw, märr walal dhu marŋgithirra nhokalaŋawnydja märrwu. Ga nhanukalaŋuwurra Walŋakunhamirriwalaŋuwurra nhuma dhu ŋunhi Yitjuralpuyyuny yolŋuy walal märram märr-ŋal'yunawuynydja.” Ga bitjarra ŋayi gan ŋunhi Djimiyandja waŋan. ");
INSERT INTO djr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ga maṉḏany ŋunhi ŋäṉḏi'mirriŋuny ga bäpa'mirriŋuny nhanŋu mirithinan dhika ganyim'thurrnydja, märr-maŋmaŋdhurra manapar, ŋunhi nhaltjarr ŋayi gan Djimiyandhu lakaraŋal ŋunhiŋuwuyyi yothuwalaŋuwuy. ");
INSERT INTO djr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Bala ŋayi Djimiyandhuny ŋäŋ'thurra God-Waŋarrnhan walalaŋ, Meriwnydja ga Djawutjipkuny ga yothuwnydja, märr walalnydja dhu nhanukala goŋŋur. Bala ŋayi waŋanan ŋäṉḏi'mirriŋuwalnydja bitjarra, “Dhuwandja yothuny ŋayi God-Waŋarryu djuy'yurr märryu dhapinyay, märr dhu ŋunhi dharrwan yolŋuny walal Yitjuralpuynydja mala dhärran dhiyakuny ŋunhi Godkalaŋawnydja romgu. ");
INSERT INTO djr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ŋayiny ŋunhi Djesuny maŋutji-dhunupayanhawuy lakaranhawuy God-Waŋarrwuŋun, yurr dharrwan dhu ŋunhi yolŋuny walal nhanŋu ŋuyulkthiny, bala walal dhu yaka'yurra nhanŋu, ga ŋurikiwurruŋguŋ ŋunhi yolŋuwuŋuny walalaŋguŋ dhu guyaŋanhawuynydja boŋguŋ dhawaṯthurrnydja warraŋulthin yuwalknha yänan. Ga ŋayaŋuny nhuŋu dhu ŋunhi boŋguŋ dharpuŋ, Meri, ŋayaŋu-miḏikumul dhu nhuna warwuynydja, biyak nhakun mandjawakthu nhuna dhu ŋunhi ŋayaŋuny dharpuŋ.” Ga bitjarra ŋayi gan ŋunhi Djimiyandhu lakaraŋalnydja nhanŋu Meriwnydja. ");
INSERT INTO djr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ga waŋgany djawarrkmirr miyalk gan nhinan ŋunhiliyi yäku Yana,* yurr gäthu'mirriŋuny ŋayi ŋunhi Banyuwalwu,* ŋunhi ŋayi yarraṯaŋurnydja Yatjawal. Ga Yanany ŋunhi miyalk worruŋu, yurr ŋäthilnydja ŋayi gan nhinanany nhanukiyingalaŋuwal ŋayi dhuway'mirriŋuwalnydja waŋgany goŋ ga märrma' bäythinyawuy dhuŋgarra, ga dhäŋur beŋuryiny bala nhanŋu ŋunhi dhuway'mirriŋuny dhiŋgaŋala. ");
INSERT INTO djr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bala beŋuryiny ŋunhi dhurrwaraŋur ŋayi gan nhinanan gänan yan, ga yan bili-i-i ga worruŋuyin ŋayi, 84-mirriyinany ŋayi gänan. Ga bitjanna bili ŋayi ŋuli ganha marrtjinya yan ŋunhi buku-ŋal'yunamirrililnydja buṉbulil; walupuy ga munhawu ŋayi ŋuli ganha bukumirriyanha God-Waŋarrwal ŋunhiliyi, yurr wiripuny ŋayi ŋuli ganha ŋoy-ŋathamiriwnha bukumirriyanha. ");
INSERT INTO djr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ga balanyamirriy bili waluy ŋayiny Yanany bunanan ŋunhiliyin God-Waŋarrwala buku-ŋal'yunamirriŋura buṉbuŋurnydja, ga maṉḏany Meriynydja ga Djawutjipthuny gäŋala yothunhany gurrupanaraw God-Waŋarrwala goŋlil, bala walal yan bunanhaminan ŋunhiliyiny wäŋaŋur. Bala ŋayi Yanaynydja bukumirriyaŋala buku-gurrpara God-Waŋarrnhan ŋurikiyin yothuwnha. Bala ŋayi dhäwuny' marrtjin lakaraŋala birrŋ'maraŋala ŋunhiŋuwuyyiny yothuwalaŋuwuynydja yolŋu'-yulŋuwala bukmakkala, ŋunhi walal ŋuli ganha gatjpu'yuna ga dhukarr-nhänha ŋurikiyi, ŋunhi dhu God-Waŋarryu dhawaṯmaraman ŋunhiyiny wäŋany garrpinamirriŋura romŋur malaŋuŋur, märr dhu ga Djurutjalamdja wäŋa dhärra mägayan yan. ");
INSERT INTO djr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ga ŋunhi nhakun maṉḏa Djawutjip ga Meri dhawar'yurrnydja beŋuryiny romŋur Garraywalnydja mundhurr-gurrupanaŋur, bala maṉḏa roŋiyinan maṉḏaŋgiyingala wäŋalil Nätjuritjlila,* makarrŋurnydja Galali. ");
INSERT INTO djr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Bala ŋayi yothuny ŋunhiliyiny wäŋaŋur ŋuthara yindithinan, guyaŋanhawuynydja nhanŋu ḻiyany ḏälthinan, ga God-Waŋarrnydja nhanŋu gan ŋunhi mirithinan marrkapthurr, ga nhinanany ŋayi gan ŋunhi nhanukalnha djägaŋurnydja. ");
INSERT INTO djr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ga bitjarr bili dhuŋgarra-ŋupara maṉḏa gan ŋunhi Djesuwnydja ŋäṉḏi'mirriŋu ga bäpa'mirriŋu marrtjin balany Djurutjalamlilnydja, buŋgullilnydja yäkulil Ḻäy-djuḻkmaranhamirrililnydja. ");
INSERT INTO djr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ga ŋunhi nhakun ŋayi Djesu gurrmulthinany, rumbalnydja ḏirramuthinan, dhuŋgarra 12-mirriyinany, ga bulu nhakun maṉḏany ŋunhi Meriny ga Djawutjiptja marrtjin balayi buŋgullil, ga ŋayiny ŋunhi Djesuny maṉḏaŋ malthurra. ");
INSERT INTO djr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ga dhäŋur beŋuryiny buŋgulŋurnydja dhawar'yunaŋur, bala yan maṉḏa roŋiyinan maṉḏaŋgiyingala wäŋalil. Yurr ŋayipiny ŋunhi Djesuny wäŋa-ŋurr'yurra ŋunhiliyin banydjin yan Djurutjalamnha. Ga maṉḏany gan ŋunhi ŋäṉḏi'mirriŋuny ga bäpa'mirriŋuny dhuŋan marrtjin, ");
INSERT INTO djr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","maṉḏany marrtjin guyaŋan yanbi ŋayi gan malthurr ŋunha wiripuwurruŋ yolŋuw walalaŋ. Ga ŋuparnydja maṉḏa ŋunhi waluny waŋgany yan, ga ŋuruŋun milmitjpan ḻäy-bilyunaraynha, bala yan maṉḏa Djesuwnydja maŋutji-ḻarruŋala. Bala maṉḏa marrtjin dhä-birrka'yurra yolŋunhan walalany gurruṯumirrinhan walalany ga ḻundu'mirriŋunhan walalany, yurr bäyŋu warray. Ga balayi maṉḏany roŋiyindhi Djurutjalamlilyi. ");
INSERT INTO djr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ḻarruŋalnydja maṉḏa gan ŋunhi ḻiw'maraŋala Djurutjalamgurrnydja wäŋakurr, yurr bäyŋun maṉḏa ŋanya ŋunhi maḻŋ'maranhany. ");
INSERT INTO djr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ga yalalan ŋunhan wiripuŋuynha waluy bala maṉḏa ŋanya maḻŋ'maraŋala ŋunhilin buku-ŋal'yunamirriŋura buṉbuŋurnydja, nhinanany ŋayi gan ŋunhi malaŋurnydja ḏilkurruwurruŋgala, marŋgi-gurrupanamirriwala mala buthuru-bitjurra ŋayi gan walalaŋ, bala yan ŋayi walalany dhä-birrka'yurra, yan nhakun mayali' maḻŋ'maraŋal walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ga walalnydja gan ŋunhi yolŋuynydja walal ŋaḻapaḻmirriynydja ŋäkulnydja ŋanya dhäruktja ganyim'thurra, bili ŋayi gan ŋunhi waŋanany balanyan bili yan nhakun ŋaḻapaḻnha yolŋu gaḏamannha, ga dhäruktja mala ŋayi gan walalaŋ ŋunhi buku-roŋanmaraŋalnydja dhunupan yan. ");
INSERT INTO djr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ga ŋunhi maṉḏa ŋäṉḏi'mirriŋuynydja ga bäpa'mirriŋuynydja nhäŋalnydja ŋanya, bala maṉḏa ganyim'thurra nhanŋu mirithinan. Bala ŋayi ŋäṉḏi'mirriŋuynydja waŋanan ŋanya bitjarra, “Way waku, nhaku nhe linyalany ga dhuwal bitjandhiny waṉa-gäma? Linyuny dhuwal bäpa'mirriŋuny nhuŋu mirithinan warwuyurr, ḻarrumany linyu barpuru nhuŋu dhuwal ḻiw'maraman bawalamirrikurra wäŋakurrnydja.” ");
INSERT INTO djr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Bala ŋayiny Djesuny waŋanan maṉḏaŋguny buku-roŋanmaraŋal bitjarra, “Nhaku nhuma ga dhuwal ŋarrakuny ḻarrum? Yaka yan nhuma dhuwal marŋginy muka? Ŋarrany ŋuli ga dhuwal ḻay-ḻayyun dhiyaŋ malaŋuy romdhu ŋunhi Bäpa'mirriŋuwal ŋarrakalaŋuwal.” ");
INSERT INTO djr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yurr maṉḏany ŋanya ŋunhi dhäruktja bäyŋu ŋula dharaŋana, ŋunhi nhaltjarr ŋayi gan mayali' waŋan. ");
INSERT INTO djr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ga beŋuryiny dhurrwaraŋur walal marrtjinan roŋiyinan balayi Nätjuritjlila wäŋalil, ga ŋunhiliyin wäŋaŋur ŋayi gan ŋunhi wiyindja nhinan. Ga bitjarra bili ŋayi gan ŋunhi Djesuynydja dhäruktja maṉḏany märraŋala yan. Yurr ŋayiny ŋäṉḏi'mirriŋuynydja nhanukal gan guyaŋanan yan ŋunhin bili dhäruktja mala ŋunhi nhaltjarr gan maḻŋ'thurr, murrŋan gan yan warr'warryurr. ");
INSERT INTO djr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Bala ŋayi Djesuny marrtjin ŋuthara yindithinan ḏirramuyinan, ga guyaŋanhawuynydja nhanŋu ŋunhi ŋutharyi bulun dhika ḏälthinan. Bala gan God-Waŋarrnydja nhanŋu mirithinan marrkapthurr, ga bitjarryi bili walalnydja gan ŋunhi yolŋuny walal nhanŋu marrkapthurryi. ");
INSERT INTO djr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ga balanyamirriyyi bili yan waluy yolŋu gan nhinan ŋurruŋu buŋgawa yäku Daypiriya,* yurr buŋgawany ŋayi ŋunhi ŋuriki bukmakku yan wäŋawnydja malaŋuw. Ga märr wiyinnha ŋayi gan ŋunhi buŋgawany nhinan, 15-nha dhuŋgarrany. Ga wiripuwurrnydja ḏirramuwurr nhanukal ŋurikalyiny buŋgawawal ŋoyŋura gan nhinan Daypiriyawalnydja yolŋuwal yäkuwal, waṉan mala nhanŋu, ga waŋganydja yäku Bundiyatj-Bäylittja,* buŋgawa Djudiyapuywu* wäŋaw. Ga ŋayiny Yarittja* buŋgawa ŋuruk Galalipuywu* wäŋaw, ga ŋayiny Yaritkuny yukuyuku'mirriŋu yäku Biliptja,* ŋayiny buŋgawa märrmaw'nha wäŋaw, Yituriyawuywun* wäŋaw ga Durakanitjkun* wäŋaw. Ga ŋayiny Lutjaniyany* yolŋu yäku buŋgawa Yapaliniyawuywun wäŋaw. ");
INSERT INTO djr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ga balanyamirriyyi bili waluy, märrma' gan yolŋu maṉḏa nhinan ŋunhi maṉḏa ŋurruḏawalaŋu djirrikaymirra maṉḏa, dhuwal maṉḏa yäku gam', Yanatj* ga Gäyapatj.* Ga balanyamirriyyi bili ŋunhi Djondja yolŋu, gäthu'mirriŋu Djakarayawnydja, gan nhinanan ŋunhiliyin nharaŋŋura wäŋaŋur. Bala ŋayi God-Waŋarrnydja waŋanan nhanukal Djongalnydja, djuy'yurra ŋayi ŋanya lakaranharawnha dhäwuwnha birrŋ'maranharaw. ");
INSERT INTO djr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bala ŋayi Djondja gan marrtjinany wäŋalila ga wäŋalila, buku-ḻiw'maraŋala ŋuliwitjarryiny wäŋakurr mayaŋgurrnydja Djodingurrnydja. Ga bitjarra ŋayi gan ŋunhi lakaraŋalnydja yolŋuwalnydja walalaŋgal gam', “Way walal, bilyunna nhuma dhu dhipuŋuryiny yätjkurruŋurnydja nhumalaŋgiyingalaŋaŋur, bala nhuma dhu ḻiya-ḻupthunna, bala ŋayiny dhu God-Waŋarryuny nhumalaŋ bäy-lakaraman yätjkurruwuynydja.” Bitjarrnha ŋayi gan ŋunhi Djondja waŋan walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ŋäthilnydja baman'tja yolŋuy djawarrkmirriy yäkuy Yitjayay gan wukirri dhuwal dhäruk bitjarr gam', “Ŋunhalnydja nharaŋŋurnydja wäŋaŋur ḏiltjiŋurnydja yolŋu dhu boŋguŋ djawarrkthurr, yurr waŋiny ŋayi dhu gi ŋunhi biyakun gam', ‘Girri-ŋamathin walal, ga dhukarr-buŋun Garraywuny, bili galkin ŋayi dhu bunan. Dhunupayaŋun biyakun dhukarrnydja nhanŋu marrtjinyarawnydja. ");
INSERT INTO djr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bukuny mala ŋunhi wäŋa bukmaknha dhu yarrpalanydhirra, ga ŋunhiyi yarrpalanydja dhu wäŋa bukmaknha rur'yunna, märr dhu ŋunhiyiny warrpam'thunna yarrpalanydhirr. Biyakun ŋunhiyiny buku-wirwiryunamirrnydja dhukarr dhunupayaŋun waŋganyguŋun, ga djämayi ŋunhi ḻunguḻungu'mirrnydja dhukarr buyuwuyukuŋun. ");
INSERT INTO djr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bili Garraynydja dhu ŋunhi marrtjin rälin, bala dhu bukmakthun yolŋuynydja walal nhäŋuny ŋunhi nhalayak ŋayi dhu God-Waŋarryu yolŋu'-yulŋuny walŋakuŋ.’” Ga bitjarra ŋayi gan ŋunhi Yitjayaynydja lakaraŋal ŋäthilmirriyaŋalnydja ŋunhi Djonguny dhäwu, ŋunhi ŋayin dhu ga yalalany Djondhun bitjandhiny lakaram. ");
INSERT INTO djr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ga beŋuryiny dhurrwaraŋur bala gan ŋunhi dharrwaynha mirithirra yolŋuynydja walal guwatjmarnydja ŋanya Djonnhany, märr ŋayi walalany gan ḻiya-ḻupmaramaŋala. Yurr wiripuwurruynydja ŋanya ŋunhi guwatjmar, yan nhakun guyaŋanharay walalaŋgiyingal walal yanbi walal manymakmirra, bala ŋayi Djondja walalaŋ gan waŋanan bitjarra, “Nhumany dhuwal yolŋu'-yulŋu be nhän mala yan, mayali'-wilkthunamirra mala. Yolthu nhumalany dhuwal waŋanany balanyarawyiny, yanbi nhuma dhu waṉḏirr winya'yun Godkalaŋaŋuŋurnydja, ŋunhi ŋayiny dhu galki bunan, dhä-gir'yunarawnha nhumalaŋ? ");
INSERT INTO djr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ma', bilyurra walal biyakun yuwalkkuŋun yan, bala djäman yan ŋamakulin' romdja. Yaka gi waŋi biyakuny, ‘Ŋarranhany dhu dhuwal God-Waŋarryu bäyŋu warray dhä-gir'yun, bili ŋarrakuny dhuwal mala-ŋurrkanhayŋu Yipurayim warray.’ Bäyŋun yan nhuma dhu ga ŋunhi bitjandhiny lakaranhamirr ŋapatjkunhamirrnydja nhumalanhawuynha nhuma. Bili God-Waŋarryu warray ga dhuwal ganydjarrnydja ŋayatham ŋula nhakuny malaŋuw djämaw; ŋayiny balaŋ märraŋun dhuwanna ŋunhi guṉḏan mala, bala ŋayi ŋuli yan djäman bilmaraŋun yolŋukuŋun dhipuŋurnydja ŋunhi guṉḏaŋurnydja, bala walalnha balaŋ ŋunhi djamarrkuḻiny' nhanŋun Yipurayimguny. ");
INSERT INTO djr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","God-Waŋarrnydja ga dhärra girri'-ŋamathinyawuynha, bitjanna nhakun yolŋu ŋuli ga dhärra goŋ-ḏakulmirr djatthunarawnha, ŋayi dhu djatthundja dhä-mälkum yan yuṯuŋgurrwurr dharpanhany malaŋuny. Ga ŋunhiyiny dharpa malany borummiriwnhany, ŋayi dhu yan djalkthunna gurthalila. Yo. Bitjandhin ŋayi dhu ŋunhi God-Waŋarryu yolŋunhany dhä-gir'yun ŋayaŋu-waŋaranhany.” ");
INSERT INTO djr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bala walal dhä-birrka'yurra ŋanya Djonnhany bitjarra, “Nhaltjan dhika napurr dhu yulŋuny?” ");
INSERT INTO djr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ga ŋayiny walalaŋ buku-bakmaraŋal bitjarr, “Djämany gi ŋamakurrnha yan ga dhunupan romdja. Ŋuli nhe ga ŋayatham märrmany' gumurrpuy, waŋganydja nhe dhu gurrupan ŋurikin yolŋuw ŋunhi ŋayi gi bäyŋun ŋayathul gumurrpuy. Ga ŋuli nhe ga ŋathamirrnydja nhina, nheny dhu gurrupan ŋurikin ŋunhi wiripuŋuwnha yolŋuw, ŋunhi ŋayi ga ŋathamiriw nhina.” Ga bitjarra ŋayi gan ŋunhi Djondhu lakaraŋalnydja walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ga wiripuny ŋunhi rrupiya-märranhmirra yolŋu walal gapmangun marrtjin balayi ḻiya-ḻupthunaraw, bala walal dhä-birrka'yurra ŋanya Djonnhany bitjarra, “Way Marŋgikunhamirr, nhaltjan dhika ŋanapurrnydja dhu?” ");
INSERT INTO djr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ga ŋayiny walalaŋ waŋan Djondja bitjarr, “Ŋunhi nhuma dhu ga yolŋu'-yulŋunhany mala rrupiyany gombu'-gombum ŋurikiny ŋunhi buŋgawawnydja, yurr ŋunhi bili yan dhunupa nambany rrupiyany lakaraŋ; yakan buluny gombuŋ ḏämbulilnydja ŋal'maraŋ, ga goŋ-djuḻuḻ'yurrnydja nhumalaŋguwuynydja nhuma.” ");
INSERT INTO djr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ga wiripuny ŋunhi yolŋu walal marrtjin miriŋun mala nhanukal Djongal, ga dhä-birrka'yurr walal ŋanya bitjarr, “Nhä dhika ŋanapurrnydja dhu djäma?” bitjarr. Ga ŋayiny Djondja waŋan walalaŋgal bitjarr, “Yaka nhuma dhu ŋula yolnha yolŋuny dharrwunum rrupiyawnydja ŋula nhakuny märranharaw, ga yaka nyäḻ'yurrnydja lakaraŋ ŋula yolnhany yolŋuny djarrma-gäŋuny. Ga ŋunhi nhuma dhu märramany rrupiyany nhumalaŋguwuy nhuma djämapuynydja, yakan nyumukuṉiny' lakaraŋuny ŋunhiyiny rrupiya.” ");
INSERT INTO djr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Yo. Ga wiyinnha walal gan ŋunhi Yitjuralnydja bäpurru galkurr ŋurikiyiny ŋunhi Maŋutji-dhunupayanhawuywuny yolŋuw, ŋunhi ŋayi God-Waŋarryu dhawu'mirriyaŋal be ŋäthil. Ga buluny walal nhakun ŋunhi ŋäkul ŋanyanhan Djonnhan, bala walal yan mirithinan goŋmirriyinany dhika, ga waŋanhaminany walal gan ŋunhi bitjanminan, “Dhuwaliyin mak ŋayi ŋunhiyiny yolŋu bäy Maŋutji-dhunupayanhawuynydja?” ");
INSERT INTO djr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bala ŋayiny Djondhuny lakaraŋal balany walalaŋ bitjarra, “Yaka dhuwal ŋarrany ŋunhiyi. Ŋarrany ŋuli ga dhuwal nhumalany gapuy warray waŋganydhu buku-ḻupmaram. Yurr dhikayi ga wiripuny yolŋu marrtji mirithirra yindi, ganydjarr-ḏumurra, djuḻkmaraman ŋayi ga ŋarranhany. Ga yaka ŋarra dhuwal dhuwurr-dhunupany djämawnydja nhanukalaŋaw ŋula nhakuny malaŋuw, balanyarawnydja nhakun dhapathuŋ'kuny nhanukalaŋaw yupmaranharaw. Ŋayiny nhumalany dhu gi ŋunhi ḻiya-ḻupmaraŋ Dhuyu-Birrimbirryun ga gurthaynha ŋäṉarryun. ");
INSERT INTO djr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ga ŋayin ga ŋunhiyin yolŋu dhärra girri'-ŋamathinyawuynha, mala-djarr'yunarawnha barrkuwatjkunharawnha yolŋuwnha walalaŋ. Biyakun ŋayi dhu marrtji ŋunhi rurr'rurryurra ŋathany birraliny yan maŋutji, gänaŋ'maraŋun beŋurnydja ŋunhi dhukunŋurnydja. Bala ŋayi dhu ŋunhi ḏarrtjalktja ŋatha rulwaŋdhurra balan nhanukiyingala ŋayi wäŋalil, ga ŋunhi dhukundja ŋunhiŋuwuyyi ŋathapuy ŋayi dhu djalkthurra gurthalila, ŋunhiwiliyin gurthalil ŋunhi ga nhäran bitjanna bili yan bulŋuyukthinyamiriwnha.” Ga bitjarryin ŋayi gan ŋunhi Djondhu lakaraŋalnydja yolŋu'-yulŋuwalnydja. ");
INSERT INTO djr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ga dharrwakurr dhukarrkurr ŋayi gan ŋunhi Djondhuny lakaraŋal ŋunhi manymaktja dhäwu yolŋuwnydja walalaŋ Djesuwalaŋuwuynydja. Yurr ŋayi gan ŋunhi waŋanany walalany mirithinan yan raypirri'yurra gan ḏälyun dhärukthuny, bilmaraŋala ŋayi walalany gan beŋura ŋunhi walalaŋgalaŋaŋur ŋäthiliŋuŋura romŋur. ");
INSERT INTO djr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ga ŋanyanhany ŋayi Djondhu ŋunhi buŋgawanhany yolŋuny yäkuny Yaritnhany,* waŋandhi ŋurru-dhunupa yan bili ŋayi miyalknha djaw'yurr wäwa'mirriŋuw nhanukiyingalaŋuw ŋayi yäkuny Yirutiyany. Ga bulu ŋayi gan djämayi ŋula nhä malany wiripu wiripu yätjkurr mirithirr rom malany. ");
INSERT INTO djr_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ga buluny ŋayi ŋunhi Yaritthu djäma yätjkurr ŋapalil ŋal'maraŋal nhanŋuwuy ŋayi ŋunhi ŋayi Djonnhan galkar dharruŋgulila. ");
INSERT INTO djr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ga dhäŋur beŋuryiny ŋunhi ŋayi gan Djondhu ḻiya-ḻupmaraŋalnydja yolŋunhany walalany, bala ŋayipiny Djesuny marrtjinan balan Djongala, bala yan ŋayi ŋanya Djondhuny buku-ḻupmaraŋala. Ga dhäŋur beŋuryiny, bala ŋayi Djesuny gan dhärranan bukumirriyaŋala ŋunhiliyin. Bala ŋayiny ŋunha djiwarrny'tja wäŋa dhunupan ḻapthurra, ");
INSERT INTO djr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","bala ŋunhi Dhuyu-Birrimbirrnydja marrtjin dhuryurrnydja räliny yuwalknha yänan, yurr rumbalnydja ŋunhi balanya nhakun murryil, bala ŋayi nhinanan nhanukal Djesuwalnydja. Ga dhunupan ŋayiny God-Waŋarrnydja waŋanan beŋur djiwarr'ŋurnydja bitjarra, “Nheny dhuwal ŋarrakuwuy warray Gäthu ŋunhin marrkapmirra. Ga ŋarrany nhokal dhuwal mirithinan yan ŋayaŋu-djulŋithinany.” ");
INSERT INTO djr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ga ŋunhi ŋayi Djesu 30-mirriyinany dhuŋgarramirriyin, bala ŋayi ŋurruyirr'yurra gan djawarrkthurra dhäwun lakaraŋal. Ga yolŋuynydja walal gan ŋunhi guyaŋanany ŋanya Djesunhany bitjarra, yanbi ŋayi ŋunhi Djawutjipkun* gäthu'mirriŋu; ga yuwalknha ŋayi ŋunhi Djawutjipthuny ŋanya goŋdhu-märraŋalnydja ŋanya Djesunhany, bala ŋayi nhanŋu ŋunhi bäpayinan. Yo, ŋayiny ŋunhi Djawutjiptja gäthu'mirriŋu Yeliw, ");
INSERT INTO djr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ga ŋayiny Yeliny ŋunhi gäthu'mirriŋu Mathatku,* ga ŋayiny Mathattja yolŋu yäku gäthu'mirriŋu Lebaywu,* ga ŋayiny Lebaynydja gäthu'mirriŋu Milkiw,* ga Milkiny gäthu'mirriŋu Djanaywu,* ga ŋayiny Djanaynydja gäthu'mirriŋu wiripuŋuw yolŋuw Djawutjipku, ");
INSERT INTO djr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ga ŋayiny ŋunhiyiny Djawutjiptja yolŋu yäku gäthu'mirriŋu Matathiyatjku,* ga ŋayiny Matathiyatjtja ŋunhi gäthu'mirriŋu Waymutjku,* ga Waymutjtja gäthu'mirriŋu Näyamgu,* ga ŋayiny Näyamdja ŋunhi gäthu'mirriŋu Yitjiliw,* ga Yitjiliny gäthu'mirriŋu Naykiw, ");
INSERT INTO djr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ga Naykiny gäthu'mirriŋu Mäyatku,* ga ŋayiny Mäyattja gäthu'mirriŋu nhanŋu Matathayaw,* ga ŋayiny ŋunhiyi yolŋu Matathayany yäku gäthu'mirriŋu Djiminiw,* ga ŋayiny Djimininy ŋunhi gäthu'mirriŋu Djotjikku,* ga ŋayiny Djotjiktja gäthu'mirriŋu Djodaw, ");
INSERT INTO djr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ga Djodany ŋunhi gäthu'mirriŋu Djowanangu,* ga ŋayiny Djowanandja yolŋu yäku gäthu'mirriŋu Ritjaw,* ga Ritjany Djirabaybulwu,* ga ŋayiny Djirabaybulnydja gäthu'mirriŋu Djiyaltiyalwu,* ga ŋayiny Djiyaltiyalnydja ŋunhi gäthu'mirriŋu Neriw, ");
INSERT INTO djr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ga ŋayiny Neriny yolŋu yäku gäthu'mirriŋu Milkiw,* ga ŋayiny Milkiny ŋunhi gäthu'mirriŋu Yatiw,* ga Yatiny gäthu'mirriŋu Gutjamgu,* ga ŋayiny Gutjamdja gäthu'mirriŋu Yilmatamgu,* ga ŋayiny Yilmatamdja gäthu'mirriŋu Yuwaw, ");
INSERT INTO djr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ga Yuwany ŋunhi gäthu'mirriŋu Djatjuwaw,* ga ŋayiny Djatjuwany gäthu'mirriŋu Läyitjaw,* ga Läyitjany ŋunhi gäthu'mirriŋu Djorimgu,* ga ŋayiny Djorimdja yolŋu yäku gäthu'mirriŋu Mathatku,* ga Mathattja gäthu'mirriŋu Lebaywun. ");
INSERT INTO djr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Yo. Ga Lebaynydja ŋunhi gäthu'mirriŋu nhanŋun Djimiyangun,* ga ŋayiny Djimiyandja ŋunhi gäthu'mirriŋu Djudawnha,* ga Djudany gäthu'mirriŋu Djawutjipku,* ga ŋayiny Djawutjiptja ŋunhi gäthu'mirriŋu Djonamgu,* ga ŋayiny Djonamdja gäthu'mirriŋu Yiliyakimgu. ");
INSERT INTO djr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ga ŋayiny Yiliyakimdja ŋunhi gäthu'mirriŋu Meliyaw,* ga Meliyany gäthu'mirriŋu Menaw,* ga ŋayiny ŋunhi Menany yäku yolŋu gäthu'mirriŋu Matathaw,* ga ŋayiny Matathany gäthu'mirriŋu Naythangu,* ga ŋayiny Naythandja gäthu'mirriŋu Daybitku. ");
INSERT INTO djr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ga ŋayiny Daybittja yäku yolŋu gäthu'mirriŋu Djitjiw,* ga Djitjiny gäthu'mirriŋu Wopitku,* ga ŋayiny Wopittja gäthu'mirriŋu Bawatjku,* ga ŋayiny Bawatjtja gäthu'mirriŋu Djalmangu,* ga ŋayiny Djalmandja gäthu'mirriŋu nhanŋu Nätjungu. ");
INSERT INTO djr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ga Nätjundja yolŋu yäku gäthu'mirriŋu Minadapku, ga ŋayiny Minadaptja ŋunhi gäthu'mirriŋu Yadmingu, ga ŋayiny Yadmindja gäthu'mirriŋu Yäniw,* ga Yäniny gäthu'mirriŋu Yitjurungu,* ga ŋayiny Yitjurundja gäthu'mirriŋu Beratjku,* ga Beratjtja gäthu'mirriŋu Djudaw.* ");
INSERT INTO djr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ga ŋayiny Djudany yolŋu yäku gäthu'mirriŋu Djaykupku,* ga ŋayiny Djaykuptja ŋunhi gäthu'mirriŋu Yitjakku,* ga Yitjaktja gäthu'mirriŋu nhanŋu Yipurayimgu,* ga ŋayiny Yipurayimdja gäthu'mirriŋu Djeraw,* ga ŋayiny Djerany ŋunhi gäthu'mirriŋu Näyuw. ");
INSERT INTO djr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ga Näyuny ŋunhi gäthu'mirriŋu Djerakku,* ga ŋayiny Djeraktja gäthu'mirriŋu Reyuw,* ga ŋayiny Reyuny yolŋu yäku gäthu'mirriŋu Biliyakku,* ga ŋayiny Biliyaktja gäthu'mirriŋu Yepaw,* ga ŋayiny Yepany gäthu'mirriŋu Djelaw. ");
INSERT INTO djr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ga Djelany yolŋu yäku gäthu'mirriŋu Gayinangu,* ga ŋayiny Gayinandja gäthu'mirriŋu Yäpakatku,* ga ŋayiny Yäpakattja gäthu'mirriŋu Djimgu,* ga ŋayiny Djimdja ŋunhi gäthu'mirriŋu Nawaw,* ga ŋayiny Nawany gäthu'mirriŋu Lamikku. ");
INSERT INTO djr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ga ŋayiny Lamiktja yolŋu yäku gäthu'mirriŋu Mathitjilaw,* ga ŋayiny Mathitjilany gäthu'mirriŋu Yenukku,* ga ŋayiny Yenuktja gäthu'mirriŋu Djäritku,* ga Djärittja ŋunhi gäthu'mirriŋu Mayalaliw,* ga ŋayiny Mayalaliny gäthu'mirriŋu Genangu. ");
INSERT INTO djr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ga ŋayiny Genandja yolŋu yäku gäthu'mirriŋu Yenutjku,* ga ŋayiny Yenutjtja gäthu'mirriŋu Djäpku,* ga ŋayiny Djäptja gäthu'mirriŋu Yadamgu, ŋunhi ŋayiny Yadamdja yolŋu yäku gäthu'mirriŋu nhanŋuwuynha yan God-Waŋarrwun Bäpawnha. ");
INSERT INTO djr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ga ŋunhi ŋayi Djesu roŋiyinany beŋurnydja ŋunhi buku-ḻupthunaŋurnydja Djodinŋurnydja, ŋunhiny ŋayi roŋiyinany dhaŋaŋnha Dhuyu-Birrimbirrwalaŋumirra. Bala ŋanya ŋayi yan ŋuriŋi Dhuyu-Birrimbirryuny Djesunhany mel-warryurrnydja balan nharaŋlila wäŋalilnydja, gapu-ranhdhaklila. ");
INSERT INTO djr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ga ŋunhiliyiny ḏiltjiŋurnydja wäŋaŋur, bala ŋanya ŋayi gan guwaḻ-ṉirr'maraŋala ŋuriŋiyiny buŋgawaynydja Mokuyyu, birrka'yurra ŋayi ŋanya gan Djesunhan, yanbi balaŋ ŋayi ŋunhi nhanŋu malthuna. Ga nhinanany ŋayi gan ŋunhi Djesuny ŋunhiliyiny 40 munhany ga 40 waluny, yurr ŋoy-ŋathamiriwnha. Bala yan ŋayi dhunupan marrya'yinan. ");
INSERT INTO djr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Bala ŋayi ŋanya ŋunhi Mokuyyuny waŋanan Djesunhany bitjarra, “Ŋuli nhe be God-Waŋarrwuny Gäthu'mirriŋu, gatjuy mak waŋi dhuwal guṉḏany, märr ŋayi dhu bilyun ŋathathirr nhuŋu.” ");
INSERT INTO djr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yurr ŋayiny Djesuny waŋan buku-bakmaraŋal bitjarr, “Yaka. Bili ŋunha dhuyuynydja djorray' ga lakaram bitjan, ‘Bäyŋun dhu dhuwal yolŋu walŋathirr ŋathaynydja yan waŋganydhuny.’” ");
INSERT INTO djr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ga dhäŋur beŋuryiny bala yan ŋayi ŋanya ŋunhi ŋuriŋiyi Mokuyyuny garr'yurra Djesunhany balan bitjarra garrwarlila wäŋalil dhiŋgilila, ga ŋunhiliyiny ŋayi gan bukuŋurnydja wäŋaŋur milkuŋala nhanukal Djesuwalnydja wäŋanhan ŋarakanhan malany ga bukmaknhan bäpurruny yolŋuny walalany. ");
INSERT INTO djr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bala yan ŋayi ŋunhi buŋgawany Mokuy waŋanan nhanukal bitjarra, “Nhäma nhe ga ŋunha wäŋa mala? Ŋunhayiny wäŋa mala bukmaknha yan ŋarra dhu gurrupanna nhuŋun, nhen dhu ŋurikiyiny malaŋuw wäŋaw buŋgawa, ga walalnydja dhu ga ŋunhi yolŋuny mala goŋmirriyirrnydja nhuŋun. Ŋunhayiny ŋunhi wäŋa malany ŋarrakiyingala goŋŋur, ga ŋuli balaŋ ŋarra dhu djälthirr gurrupanarawnydja ŋula yolkuny, ŋarrany dhu ŋunhi gurrupanna yan nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yo. Yurr ŋarra dhu dhuwal gurrupandja nhuŋun bukmakkuman yan, ŋuli nhe dhu bun'kumu-djipthun ga buku-ŋal'yun ŋarrakuny.” ");
INSERT INTO djr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bala ŋayiny Djesuny waŋanan bitjarra, “Dhuyuŋurnydja djorra'ŋur ga ŋunha dhäruktja waŋa bitjan warray, ‘Nheny dhu bun'kumu-djipthun, ga buku-ŋal'yun ŋuriki bili yan waŋganygu Waŋarrwu, nhokiyingalaŋaw yan Garraywu God-Waŋarrwu; ŋanyapinya yan waŋganynha nhe dhu ga dhäruktja märram.’” ");
INSERT INTO djr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ga dhäŋur beŋuryiny ŋayi ŋuriŋiyi Mokuyyuny garr'yurra Djesunhany balan Djurutjalamlila, bala ŋayi ŋanya Djesunhany nhirrparnydja ŋunhiwilin buku-ŋal'yunamirrilila buṉbulilnydja, ŋunhawala gal'ŋu garrwarlila mirithirra, bala ŋayi waŋanan nhanŋu bitjarra, “Ŋuli nhe be God-Waŋarrwuny Gäthu'mirriŋu, gatjuy mak ŋurrkanhamirr nhunapinya nhe dhipuŋur bala ŋoylil, munatha'lil ya ŋunhawal. ");
INSERT INTO djr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bili ŋunha dhuyuŋurnydja djorra'ŋur ga waŋa bitjan gam', ‘Ŋayiny dhu ŋunhi God-Waŋarryuny waŋan nhanŋuwuynydja ŋayi djiwarr'puynhany dhäwu-gänhamirriny yolŋuny walalany guŋga'yunarawnha nhuŋu. ");
INSERT INTO djr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Guŋga'yunna walal nhuna dhu goŋdhun ŋayatham walalaŋgiyingal, märr nhe dhu yakan galkirriny ga ŋula burakirrnydja ḻukuny guṉḏaynydja.’” ");
INSERT INTO djr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ga ŋayiny Djesuny buku-roŋanmaraŋal nhanŋu bitjarra, “Wiripuny ga ŋunha God-Waŋarrwu Dhäruk waŋa bitjan, ‘Yaka nhuŋuwuy nhe God-Waŋarrnha birrka'yurr.’” ");
INSERT INTO djr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ga ŋunhi ŋayi ŋunhiyi buŋgawany Mokuy ḏaḏawyurrnydja birrka'yunaŋurnydja nhanukal, bala ŋayi yan ŋanya ganarrthaŋala, yurr märr-gurriri ŋanya ŋayi ŋunhi ganarrthaŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Dhäŋur beŋuryiny bala ŋayi Djesuny marrtjinan roŋiyinan Galalilila wäŋalil. Ga ŋuriŋiyi Dhuyu-Birrimbirrmirriy ganydjarryu ŋayi gan marrtjinany dhaŋaŋnha. Bala ŋayi gan djämany mirithirra yan ganydjarrmirra romdja. Ga dhäwuny' nhanukalaŋuwuy gan ŋunhi ḻatjuwarr'yurra bawalamirra ŋunhiliyiny Galaliny wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ga marŋgikuŋalnydja ŋayi gan ŋunhi yolŋunhany walalany ŋunhiliyin ŋunhi Djuw malawalnha buku-ḻuŋ'maranhamirriŋura buṉbuŋurnydja mala. Ga walalnydja gan ŋunhi yolŋuny walal bukmaknha wokthurrnydja nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ga dhäŋur beŋuryiny bala ŋayi Djesuny roŋiyinan nhanukiyingala ŋayi wäŋalil Nätjuritjlila, ŋunhiwili wäŋalil ŋunhi ŋayi Djesu ŋuthar. Ga balanyamirriynydja ŋunhi Nhinanhamirriynydja Waluy, bala yan ŋayi Djesuny dhunupan marrtjinan balan Djuw malawalnha buku-ḻuŋ'maranhamirrilila buṉbulil, bili ŋayi ŋuli ganha bitjana muka bili marrtjinya yan ŋunhiwiliyiny wäŋalil. Bala ŋayi dhunupan dhärranan maŋutji-ḻaw'maranharawnha dhuyuwnha djorraw'. ");
INSERT INTO djr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bala walal goŋ-gurruparnydja nhanukal ŋunhiyin djorrany' ŋunhi djawarrkmirriwuŋun wukirriwuynydja Yitjayawuŋun. Bala ŋayi ŋunhiyi dhoṯkunhawuynydja djorra' ḻapmaraŋala, bala ŋayi maḻŋ'maraŋalnydja ŋunhin dhäruktja ŋunhi gan waŋan bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Walŋamirrnydja Birrimbirr Garraywuny dhuwanna ŋarrakala, bili Garrayyu ŋunhi ŋarranhany djarr'yurr; ŋayipi yan ŋunhi ŋarranhany djuy'yurr, ŋarra dhu marrtjin, ga lakaraman, dhuwaliyin ŋunhi ŋamakurrnha dhäwu yolŋuwalnha walalaŋgal ŋurruwuykmirriwala. Ŋayi ŋunhi ŋarranhany djuy'yurr ŋurikiwurruŋgalnydja ŋunhi yolŋuwal walalaŋgal ŋunhi walal ga nhina garrpinamirriŋur romŋur, märr dhu ŋarra lakaraman walalaŋgal ŋunhi ŋayiny Garrayyuny walalany bilin dhawaṯmaraŋala. Ga bulu ŋayi ŋarrany djuy'yurr bambaymirriwal yolŋuwal walalaŋgal, märr ŋarra walalany dhu maŋutjimirriyaman. Ga bulu ŋayi ŋarrany djuy'yurr ŋurikiwurruŋgal ŋunhi walal ga nhina baku-ŋayathanhamirriŋur romŋur, märr ŋarra dhu dhawaṯmaraman walalany beŋuryiny ŋunhi garrpinamirriŋurnydja romŋur. ");
INSERT INTO djr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yo. Ga bulu ŋayi ŋarrany djuy'yurr bukmakkala yan yolŋuwal walalaŋgal dhäwuwnha lakaranharaw, bili dhuwanna ŋunhi waluny ŋayi dhu Garrayyuny marrtji walŋakuman ŋunhiwurrunhany ŋunhi nhanŋuwuynydja yolŋuny walalany.” Ga dhuwaliyiny ŋunhi dhäruk ŋayi Djesuy maŋutji-ḻaw'maraŋal beŋura ŋunhi ŋäthiliŋuŋur djorra'ŋur, Yitjayawuŋun wukirriwuy. ");
INSERT INTO djr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ga ŋunhi nhakun ŋayi dhawar'yurrnydja djorra'ŋurnydja maŋutji-ḻaw'maranhaŋur, bala ŋayi ŋunhi djorrany' dhoṯkuŋala, bala gurrupara roŋanmaraŋala ŋurikala yolŋuwal ŋunhi ŋayi ŋuli ga djäga ŋurikiyi djorraw' malaŋuw. Bala ŋayi nhinanan. Ga walalnydja gan ŋunhi yolŋuynydja walal nhäŋala ŋanya, galkurra manapar walal gan nhanŋu waŋanharawnha. ");
INSERT INTO djr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bala ŋayipiny Djesuny waŋanan walalaŋgal bitjarra, “Dhuwaliyiny dhäruk ŋunhi nhuma ŋäkul maŋutji-ḻaw'maranhawuy beŋur yan God-Waŋarrwal djorra'ŋur, ga dhuwaliyin ŋunhi yuwalknha yan maḻŋ'thurrnydja dhiyala nhumalaŋgala gäthurnydja. Bili dhiyaŋiyiny ga dhäwuy lakaram ŋarranhan.” ");
INSERT INTO djr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ga walalnydja gan ŋunhi yolŋuynydja walal bukmakthun ŋäkulnydja ŋanya ṉirr'yurra, märr-maŋmaŋdhurra bitjarra dhärukkun nhanŋu bala walal gan dhä-birrka'yunminan, “Nhaka dhuwandja ŋayi gan buŋgawayaŋala waŋan. Yol bili ŋayi ŋunha, ŋunhi Djawutjipku gäthu'mirriŋu muka?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ga ŋayiny Djesuny walalaŋ buku-bakmaraŋal bitjarr, “Wiripuny mak nhuma dhu ŋunhi waŋa ŋarrakuny bitjanna, ‘Way marrŋgitj, ŋathil ḏukmaranhamirr nhunapinya nhe. Napurrnydja nhuna gan dhuwal ŋäkul ŋunhi nhe gan djäma yindiy ganydjarryu ŋunhalnydja Gapuniyamdja wäŋaŋur. Gatjuy mak, biyakiyi bili djäma dhiyalnydja nhokiyingalnydja nhe wäŋaŋur.’ Bitjanna nhuma dhu ŋunhi wiripuny waŋa. ");
INSERT INTO djr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yuwalknha yan ŋarra dhu dhuwandja nhumalaŋ lakaram. Ŋuli ŋayi dhu yolŋu djawarrkmirr marrtji nhanukiyingalnydja ŋayi wäŋalil, ga walalnydja dhu ŋunhi nhanŋuwuynydja yolŋu walal yakan gumurr-ŋamathirr nhanŋu, ga yakan walal dhu ŋunhi nhanukuŋ dhäwuny märram. ");
INSERT INTO djr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ŋäkun walal ŋarrany. Ŋäthil be baman' balanyamirriy waluy ŋunhi gan Yilaydja* nhinan, dhuwandja gan wäŋa dhärran baṉḏanynha, räwaknha ga ŋathamiriwnha, bili wiyinnha gan dhuwal wäŋany dhärran waltjaṉmiriwnha, ḻurrkun'nha dhuŋgarrany. Ga dharrwa gan miyalkkurruwurr buku-gurthapuy mala nhinan ŋunhiliyi wäŋaŋur Yitjural, balanyamirriyyiny. ");
INSERT INTO djr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Yurr ŋayiny ŋunhi God-Waŋarryuny yaka djuy'yunna ŋanya Yilaydjanhany ŋula yolkalnydja miyalkkal wäŋa-Yitjuralpuywalnydja, djuy'yurrnydja ŋayi ŋanya ŋunhi balan bitjarra mulkuruwala miyalkkal, ŋunhi ŋayi gan nhinan ŋunhala Djarapatnha* wäŋaŋur, makarrŋur wäŋaŋur yäkuŋur Djäydan. Ga ŋayiny nhanŋu ŋunhiyiny miyalk mulkuruny gumurr-ŋamathinan yan. ");
INSERT INTO djr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ga balanyamirriy waluy ŋunhi ŋayi gan djawarrkmirr yolŋu yäku Yilaydja* nhinan, ga dharrwa gan ŋunhi mirithirr Yitjuralnydja mala yolŋu walal burakin burrunhdhiyay'nha balanyamirriyyiny. Yurr bäyŋun ŋunhi ŋula waŋgany yolŋu baḏarraŋdhinyany beŋuryiny rerriŋur, ŋany waŋganynha yan yolŋu mulkurun ḏirramu yäku Naymannha* yan baḏarraŋdhinany ŋunhiliyiny wäŋaŋur, ŋunhi ŋayi ŋunhiyiny yolŋu wiripuŋuwuynha, wäŋapuy makarrpuy Djiriyapuynha.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ga ŋuriŋiyiny dhärukthuny nhanukal Djesuwalnydja walalanhany ŋunhi ŋoynha dharpuŋal, bala walal gan bukmaknha ŋunhiliny ŋunhi Djuw malawalnydja buku-ḻuŋ'maranhamirriŋurnydja buṉbuŋur ŋaramurryinan nhanŋuny mirithinan yan dhika. Yakan walal ga ŋunhi buluny djälthin dhäwuwnydja buthuru-bitjunaraw. ");
INSERT INTO djr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ga dhunupan walal ŋunhi dhärranany bala walal ŋanya ŋayathaŋala yan bala marrtjin warryu'-warryurra ŋanya beŋuryiny ŋunhi buṉbuŋur balan bitjarra bukulila wäŋalil, ŋunhi marrtjin bala' malany dhärra'-dharran, walal balaŋ ŋanya ḏur'yunan rakunygunhan ŋunhiliyin bukuŋura. ");
INSERT INTO djr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ga ŋayiny ŋunhi Djesuny bilyurr, bala yan djartjaryurra ṉapuŋga'wurra walalaŋgalaŋuwurr marrtjinan ŋayi wiripuŋulila wäŋalil. ");
INSERT INTO djr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ga dhäŋur beŋuryiny ŋunhi, bala ŋayi Djesuny marrtjinan ga yan bili ga bunanany ŋayi Gapuniyamnha* wäŋaŋur, makarrŋurnydja Galalin wäŋaŋur. Ga balanyamirriyyiny ŋunhi Nhinanhamirriynydja waluy ŋayi marrtjinan ŋunhiwilin buṉbulila buku-ḻuŋ'thunamirrilila, ga ŋunhiliyin ŋayi gan ŋunhi marŋgikuŋalnydja yolŋunhany walalany. ");
INSERT INTO djr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ga walalnydja gan ŋunhi yolŋuny walal mirithinan yan buthuru-bitjurrnydja, ganyim'thurra manapar bitjarr, bili ŋayi gan ŋunhi waŋanany dhärukthuny ganydjarrmirriynha. ");
INSERT INTO djr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ga ŋunhiliyi gan Djuw malawal buku-ḻuŋ'maranhamirriŋur buṉbuŋur yolŋu nhinan ḏirramu yätjkurr birrimbirrmirr. Bala yan ŋayi ŋunhiyi birrimbirrnydja waŋanan nhanukal ŋurikalyiny ḏirramuwalnydja dhärukkurra, yurr mirithinan ŋayi ŋunhi waŋanany yatjurra bitjarrnha, ");
INSERT INTO djr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Way Djesu, wäŋa-Nätjuritjpuy! Nhaltjanna nhe dhu napurruny dhuwal yulŋuny? Nheny dhuwal räli marrtjin, nhe dhu napurruny baḏuwaḏuyuna muka? Ŋarrany dhuwal nhuŋu marŋgi, nheny dhuwal ŋunhiyin dhäwu-gänhamirra yolŋu, djuy'yunawuynha God-Waŋarrwuŋun beŋura djiwarr'ŋura.” ");
INSERT INTO djr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bala ŋayiny Djesuny dhunupan waŋanan ŋurikiyiny yätjkurruwnydja birrimbirrwu bitjarra, “Mukthurra ma' waŋanhamiriwnha! Gatjuy dhawaṯthurra dhiyakalnydja yolŋuwal rumbalŋur,” bitjarr. Bala ŋayi ŋuriŋiyi birrimbirryuny ŋurrkaŋalnydja ŋunhi ḏirramunhany gumurrlila yan walalaŋgal, bala yan waṉḏinan dhawaṯthurra. Yurr ŋayi ŋunhiyi ḏirramuny yakan ŋula burakinyany nhanukuŋ ŋurrkanhawuynydja. ");
INSERT INTO djr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bala walalnydja gan ŋunhi yolŋuynydja walal nhäŋalnydja ganyim'thurra, ga waŋanhaminany walal gan ŋunhi bitjanminan, “Way nhän dhuwandja? Yuṯan ganydjarr muka? Waŋany ŋayi ga dhuwal dhärukthuny ganydjarrmirriynha ŋurukuny yätjkurruwnydja birrimbirrwu malaŋuw, ga walalnydja ga ŋunha dhäruktja ŋanya märraman yan, bala dhunupan yan dhawa-yawaṯthunna.” ");
INSERT INTO djr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ga dhäwuny' gan ŋunhi ḻatjuwarr'yurra Djesuwalaŋuwuynydja, warrpam'nha ŋunhi wäŋany ŋarakany Galaliny ŋayathaŋala. ");
INSERT INTO djr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yo. Ga dhunupan ŋayi ŋunhi Djesuynydja ganarrthaŋala ŋunhiyiny Djuw-malawnydja buku-ḻuŋ'maranhamirrnydja buṉbu, bala ŋayi marrtjinany Djäymangala wäŋalil. Ga ŋunhiliyi bala'ŋur gan ŋorran rerrimirr miyalk, yurr ŋayi ŋunhi mukul'mirriŋu rumaru' nhanŋu Djäymangu. Ga rirrikthurrnydja ŋayi gan ŋunhi gorrmur'yu rerriynydja. Bala walal waŋanan ŋanya Djesunhany bitjarra, “Way buku-djulŋi, ŋathil guŋga'yurr ŋanya go.” ");
INSERT INTO djr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ga ŋayiny ŋunhi Djesuny marrtjin, bala yan dhärranan nhanukal galkin, ga dhunupan ŋayi waŋanan nhanukal ŋaŋ'ŋaŋ'thurra yarrkmaraŋala ŋunhiyi gorrmur'nhany rerriny. Bala yan dhunupan nhakun ŋuriŋiyi rerriynydja ŋanya ganarrthaŋala, bala ŋayi yan ḏäwalayinan. Ga dhunupan ŋayi ŋunhi miyalktja rur'yurra, bala galŋarrarrayurra ŋathawnha walalaŋgalaŋaw, ga djägan ŋayi gan walalaŋ, ŋathan walalany gurrupar. ");
INSERT INTO djr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ga dhäŋur walu-gärrinyaŋurnydja, bala walalnydja ŋunhi yolŋuynydja walal dharrwaynha marrtjin gäŋa'-gaŋal rerrimirrinhany walalany, ḻundu'mirriŋunhany walalaŋguwuy walal balan nhanukala Djesuwala, yurr dharrwan mirithirra ŋunhiyi yolŋuny walal. Ga rerriny mala walalaŋ ŋunhi barrkuwatj walal gan ŋayathaŋal. Bala ŋayi Djesuny marrtjin goŋ-ŋal'yurra walalaŋgal waŋga'-waŋganygala yan, bala walal marrtjin walŋathinan bukmaknha. ");
INSERT INTO djr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ga märr dharrwawala ŋayi gan ŋunhi yolŋuwalnydja walalaŋgal wakinŋunhany birrimbirrnha mala dhawaṯmaraŋal, yurr dhä-rirrakaymirra gan ŋunhi dhawaṯthurrnydja. Ga yatjurrnydja walal marrtjin ŋunhi bitjarra, “Nheny dhuwal Gäthu'mirriŋu God-Waŋarrwu muka?” Bala dhunupan ŋayiny gan ŋunhi Djesuynydja waŋanan dhäruk-mukmaraŋala walalany ŋunhiyi birrimbirrnhany mala, märr walal yakan lakaranhany ŋanya ŋunhi yolŋuwalnydja walalaŋgal, bili walalnydja ŋunhiwurryiny yätjkurrnydja mala birrimbirr marŋgithinan yan nhanŋuny Djesuwnydja, ŋunhi ŋayiny ŋunhiyin Walŋakunhamirra yolŋu beŋura God-Waŋarrwuŋun, yäku Maŋutji-dhunupayanhawuynha. ");
INSERT INTO djr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ga ŋunhi wiripuny walu djaḏaw'yurr, bala ŋayi Djesuynydja ganarrthaŋala ŋunhiyiny wäŋa, ga marrtjinany ŋayi ŋunhi balan bitjarra gänaŋulila wäŋalilnydja. Ga ŋunhiliyiny banydji wäŋaŋurnydja walalnydja gan ŋunhi yolŋuny walal ḻarruŋala nhanŋu, ga yan bili ga maḻŋ'maraŋal yan walal ŋanya. Bala walal waŋanan nhanukal bitjarra, “Way, nhämirr nhe ŋuli gi dhuwal nhini dhiyala banydjin ŋanapurruŋgala?” ");
INSERT INTO djr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ga ŋayiny walalaŋ bitjarr waŋan, “Dhuwal, ŋarrany dhu ga dhuwal lakaraman ŋunhi manymaknha dhäwu Godkalaŋuwuynha rombuy, bawalamirriŋura wäŋaŋur malaŋuŋur, bili dhiyakiyi muka ŋarrany ŋayi ŋunhi God-Waŋarryuny djuy'yurr räliny.” ");
INSERT INTO djr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ga dhäŋur beŋuryiny ŋayi gan marrtjinan wäŋakurra malaŋuwurr, dhäwun' marrtjin lakaraŋal birrŋ'maraŋala ŋunhilin ŋunhi Djuw malawalnha buku-ḻuŋ'maranhamirriŋura buṉbuŋur mala, ŋunhiliyiny makarrŋur Djudiyany. ");
INSERT INTO djr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Waŋganymirrnydja waluy ŋayi gan Djesu dhärranan raŋiŋura, yurr guḻun ŋunhiyi wäŋany yäku Ginitjara,* wiripuny ŋayi yäku Galali. Ga walalnydja marrtjin yolŋu'-yulŋuny dharrwan nhanukal ḻuŋ'thurrnydja, giṯthurra marrtjin yolŋuny walal, ŋapa-ŋal'maranhaminan marrtjin bitjarra ḏur'-ḏuryunminan, bili walal gan ŋunhi djälthin Godkalaŋawnha dhärukkun ŋänharaw. ");
INSERT INTO djr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bala ŋayi yan Djesuynydja nhäŋala märrman' marthaŋay maṉḏa gan dhärran raŋiŋura, ga walalnydja ŋunhi guya-djämamirrnydja yolŋu walal gan ḏiltjiŋura nhina'-nhinan raŋiŋura, ŋäthil yan walal ŋunhi marthaŋayŋurnydja ḏuwa-ḏuwaṯthurr, bala walal gan ganybun mala rurrwuyurr ŋunhiliyin raŋiŋura. ");
INSERT INTO djr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bala ŋayipiny ŋunhi Djesuny wapthurra waŋganylila marthaŋaylil, yurr ŋunhiyi waŋganydja marthaŋay Djäymangu. Bala ŋayi Djesuynydja waŋanan ŋanya Djäymannhany bitjarra, “Dhuwal nhe dhu marthaŋay märr gaŋga dhathar'maram märr-dhulmulil,” bitjarr. Ga beŋuryin ŋayi gan ŋunhi marthaŋayŋura Djesuny waŋan marŋgikuŋalnydja gan yolŋunhany walalany, bili yolŋuny walal ŋunhi mirithinan dhika dhaŋaŋdhinan ŋunhiliyiny raŋiŋurnydja. ");
INSERT INTO djr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ga dhäŋur beŋuryiny ŋunhi ŋayi dhäwuŋurnydja lakaranhaŋur dhawar'yurr, bala ŋayi waŋanan Djäymangalnydja bitjarra, “Go nheny wapthurra rälin dhipala marthaŋaylila, ga dhathar'maramany nhe dhu balan bitjanna dhulmulila, nhe ga ŋuriŋiwurruy ŋunhi guŋga'yunamirriy mala nhokal, bala ŋurrkamany nhuma dhu ganybuny ŋunhiliyin. Bala nhuma dhu ŋunhi gaṯmaraman guyany mala dharrwan mirithirra.” ");
INSERT INTO djr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ga ŋayiny Djäymandja waŋan, “Buŋgawa, bili muka ŋanapurr gan dhuwal munha-ŋupar djalkthurrnydja, ga bäyŋu ŋanapurr ŋula guya märranha. Yurr ŋarra dhu dhuwal bulu nhakun birrka'yun ŋurrkam, bili nhen dhuwali buluny nhakun waŋan.” ");
INSERT INTO djr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ga bulu walal dhathar'maraŋal bala bitjarr märr-dhulmulila bala walal ŋurrkaŋala ganybuny. Ga dhunupan ŋunhi ganybuny dhaŋaŋdhinan guyaynydja, dharrwan mirithirra dhika ŋula nhämunan', galki balaŋ ŋunhiyi ganybuny gulk-gulkthunan. ");
INSERT INTO djr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bala walal gan ŋunhi beŋuryiny marthaŋayŋur waṉa'yurra, wäthurra balan bitjarra wiripuŋuwnha marthaŋaywu, guŋga'yunarawnha. Ga ŋunhi ŋayi wiripuny marthaŋay marrtjin ga bunan walalaŋ, ga märrma'yinan ŋunhi marthaŋaynydja maṉḏany dhaŋaŋguŋal guyaynydja malaŋuy, galki balaŋ ŋunhi marthaŋaynydja maṉḏany guḻwuḻyunan. ");
INSERT INTO djr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ga ŋunhi ŋayi Djäyman Betay nhäŋalnydja, bala yan ŋayi bun'kumu-djipthurra nhanukal Djesuwalnydja ḻukulila, ga waŋanany ŋayi ŋunhi nhanukal bitjarra, “Garray, barrkun ŋarrakalaŋuŋur! Bili ŋarrapiny dhuwal yätjkurra yolŋu, yakan ŋamakurr.” ");
INSERT INTO djr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yo. Yurr ŋaypiny ŋunhi Djäymandja ga wiripuwurrnydja djämamirr walal mirithinan märr-maŋmaŋdhurrnydja ŋuriŋiyi guyaynydja malaŋuy, bili dharrwan ŋunhi mirithirra dhika. ");
INSERT INTO djr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ga bitjarryi bili maṉḏany ŋunhi Djäymangalnydja guŋga'yunamirriy maṉḏa ganyim'thurryi yan nhäŋal maṉḏany Djayimdhuny* ga Djondhuny,* yurr maṉḏa ŋunhi gäthu'mirriŋuny maṉḏa Djipitiw. Bala ŋayi Djesuynydja waŋanan Djäymannhany bitjarra, “Way, yaka barrariny ŋini? Dhipuŋurnydja gay'yi dhurrwaraŋur nhe dhu gaṯmaram yolŋunhan walalany ŋarraku.” ");
INSERT INTO djr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ga dhäŋur beŋuryiny walal ŋunhi marthaŋaynhany warryurra balan ḏuwaṯmaraŋala ḏiltjilila, bala walal yan ganarrthaŋala bukmak yan ŋunhi nhäny mala, bala malthurra nhanŋun Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Waŋganydhuny waluy ŋayi Djesu bunan buṉbu-dharrwamirriŋura wäŋaŋur, ga ŋunhili gan wäŋaŋur waŋgany yolŋu nhinan burrunhdhiya'mirr. Ga ŋunhi nhakun ŋayi nhäŋalnydja ŋanya Djesunhany, bala ŋayi yan dhunupan bun'kumu-djipthurra nhanukal, ga waŋanany ŋayi dhä-gurrupuruŋala bitjarra, “Buŋgawa, ŋuli nhe djälnydja ŋarraku guŋga'yunarawnydja, nheny dhu ŋarrany ḏukmaraman yan.” ");
INSERT INTO djr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Bala ŋayi yan Djesuny dhunupan goŋ-djarryurra ŋayathaŋalnydja ŋanya bala ŋayi nhanŋu bitjarra waŋanany, “Yo, djäl ŋarra dhuwal nhuŋu guŋga'yunaraw. Ma', walŋathin!” Bala dhunupan yan ŋayi ŋunhiyi ḏirramuny walŋathinan; rerriynydja ŋanya ganarrthaŋala. ");
INSERT INTO djr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Bala ŋayi beŋuryiny Djesuny bilyurra, ga waŋan ŋayi nhanukala dhäruk-gurrupanmin, raypirri'yurra manapar ŋanya bitjarra, “Way, yakan lakaraŋ ŋula yolkalnydja yolŋuwal,” bitjarr. “Ga gatjuy marrtjin dhunupan yan ŋunhiwilin buku-ŋal'yunamirrilila buṉbulilnydja, märr ŋayi nhuna dhu ŋunhi djirrikaymirriynydja yolŋuy nhäman ŋunhiliyin. Ga ŋuli nhuna ŋayi dhu ŋunhi manymak-lakaramany nhäma, nheny dhu mundhurrnha bathan God-Waŋarrwun, buku-gurrpanna ŋanya, biyak yan bili nhakun ŋunhi Mawtjitjthu rom-nhirrpar ŋäthil, märr dhu bukmakthuny yolŋuy walal nhämany nhuna, bala manymak-lakaraman ŋunhi nheny dhuwali bilin walŋathinan.” ");
INSERT INTO djr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yo. Ga dhäwuny' gan ŋunhi bilin nhakun ḻatjuwarr'yurra bukmakkurra yan wäŋakurrnydja malaŋuwurr nhanukalaŋawuynydja Djesuwalaŋuwuynydja, bala yolŋuny walal marrtjin dharrwan ḻuŋ'maranhaminany, bili walal ŋunhi mirithinan djälthin nhanŋu Djesuwnydja ŋänharaw, ga wiripuny walal bitjarryi bili djälthindhi nhanŋu Djesuw, ŋayi dhu walalany walŋakuman rerriŋura. ");
INSERT INTO djr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yurr bitjana bili ŋayi ŋuli ganha ŋunhi Djesuny marrtjinya yan balany ŋunhi ŋayilpi'lilnydja wäŋalil, ga ŋunhiliyin ŋayi ŋuli ganha ŋunhi bukumirriyanhany God-Waŋarrwalnydja gänan. ");
INSERT INTO djr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yo. Waŋganymirrnydja ŋayi gan Djesuy marŋgikuŋala yolŋunhan walalany, ga ŋunhiliyi gan nhinan ŋaḻapaḻmirr yolŋu walal Baratji mala, ga rom-marŋgikunhamirr mala, ŋäkul walal gan ŋanya Djesuny dhäwulil lakaranhalil, ga wäŋgaŋalnydja walal gan ŋunhi barrkuwatjŋur wäŋaŋurnydja mala beŋur makarrŋur Galaliŋur ga Djudiyaŋur, ga wiripuny beŋura bala Djurutjalamŋura wäŋaŋur. Ga God-Waŋarrwuny ŋunhi ganydjarr nhanukalnydja Djesuwalnydja bilin dhaŋaŋdhinan ḏukmaranharawnydja ŋurikiwurruŋdhiny rerrimirriwnydja yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Ga ŋuriŋiyi bili yan waluy ḏämbumiriwyu ḏirramuwurruy marrtjin djaṉdjandhurr gaṉuŋnha ḏirramuny, yurr gäŋalnydja walal ŋanya marrtjin ŋunhi miṉdhalaynha. Yurr walal gan ŋunhi djälthinany walal balaŋ gänhany ŋanya djinawa'lil yan buṉbulil, ga rulwaŋdhuna balaŋ walal ŋanya gumurrlil yan nhanukal Djesuwal. Yurr dhaḻakarrnha walalaŋ ŋunhi bäyŋuthinany gärrinyarawnha, bili dharrwathinan gan ŋunhiliyiny yolŋun walal. Ga balany' gan ŋunhi dhärran ḏämbuny bilkpilk, bala walal ŋunhiwurryiny ḏämbumiriwnydja yolŋu walal dhunupan yan ŋal'yurra ŋapalila buṉbulil, bala walal ḻapmaraŋala ŋunhin balan' ŋapan, bala walal ŋuliwitjarryiny ŋarŋgakurrnydja yupmaraŋala marrtjin ŋunhiyin gaṉuŋnhan yolŋuny gayanh'thamirrinhan yan, ga rulwaŋdhurrnydja walal ŋanya ŋunhi galkin yänan gumurrlila nhanukal Djesuwal. ");
INSERT INTO djr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ga ŋunhi ŋayi Djesuy nhäŋalnydja walalany ŋunhiwurrunhany ŋunhi ḏirramuwurrunhany ŋunhi walal gan nhanukal mirithin märr-nhirrpanmin, bala ŋayi Djesuny waŋanan ŋurikalyiny ŋunhi rerrimirriwalnydja yolŋuwal bitjarra gam', “Ḻundu ŋarraku marrkapmirr, nhuŋu yätjkurrnydja dhuwurr dhuwal bilin bäy-lakaranhawuynha.” ");
INSERT INTO djr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bala walalnydja gan ŋunhi rom-marŋgikunhamirriynydja walal ga Baratjiynydja mala guyaŋanany bitjarra, “Yol dhuwal ŋayi yolŋuny? Nhäŋu ŋathil ŋanya, dhuwal ŋayi ga dhä-wiripuŋuyirra waŋa God-Waŋarrwun bitjandhiny. Ŋayipin ŋuli ga dhuwal waŋganydhun yan God-Waŋarryun bäy-lakaramany yätjkurruwuynydja dhuwurrpuy, yakan ŋula yolthuny yolŋuy.” ");
INSERT INTO djr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yurr ŋayiny ŋunhi Djesuny ŋäthil yan marŋgithin, nhaltjarr walal gan guyaŋan, bala ŋayi waŋanan ŋunhi ŋaḻapaḻmirriwnydja bitjarra, “Nhaku nhuma dhuwal bitjarryiny guyaŋan? Nhaltjan nhuma ga guyaŋany? ");
INSERT INTO djr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nhä dhuwal gumurr-ḏäl ŋarrakuny waŋanharaw? Ŋunhi ŋarra dhu bitjandja waŋa gam', ‘Bilin nhuŋu dhuwal yätjkurrnydja rom bäy-lakaranhawuynha?’ Ŋany nhä dhika ga nhumalaŋgalnydja gumurr-ḏälthirr? Nhaltjan dhika ŋarra dhu waŋany? … bitjan gam', ‘Go rur'yurra bala marrtjin,’ bitjanna. ");
INSERT INTO djr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dhuwalatjanna nhuma dhu ŋunhi marŋgithirrnydja gam'. Ŋarrany nhumalaŋgal dhu dhuwal milkuman, ŋunhi ŋarrakuny dhuwal dhunupa warray Yolŋuwnydja Gäthu'mirriŋuw ŋarra dhu bäy-lakaram yätjkurruwuynydja dhuwurrpuy dhiyalnydja munatha'ŋurnydja. Bala ŋayi Djesuny bilyurra, bala waŋanan ŋurikalyiny gaṉuŋgalnydja yolŋuwal bitjarra gam', ‘Ma', nheny rur'yurra, ga märraŋun nhuŋuwuy nhe gayanh'thany, bala marrtjin wäŋalila.’” ");
INSERT INTO djr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bala ŋayi ŋunhi gaṉuŋdja yolŋu dhunupan rur'yurra, ga märraŋal nhanŋuwuy ŋayi gayanh'thany, bala djartjaryurra bala nhanukiyingala wäŋalila, yurr ŋayi marrtjin ŋunhi waṉḏinany bala, märr-yiŋgathinan wokthurra manapar God-Waŋarrwun. ");
INSERT INTO djr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bala walalnydja gan ŋunhi yolŋu'-yulŋuynydja ŋanya wiyinnha nhäŋal märr-maŋmaŋdhurra nhanŋu, barrarinan manapar. Ga bitjarra walal gan ŋunhi märr-yiŋgathinany God-Waŋarrwalnydja gam', “Nhän dhuwandja ŋamakurrnha rom limurr nhäŋal gäthurnydja, muka?” ");
INSERT INTO djr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ga dhäŋur beŋuryiny bala ŋayi gan Djesuny marrtjinan dhukarr-ŋupara, bala yan ŋayi nhäŋala rrupiya-märranhamirrinhan yolŋuny gapmangun, yäkuny Lebaynha, ŋayi gan nhinan ŋunhiliyi djämamirriŋur wäŋaŋur nhanukiyingal. Bala ŋayi Djesuny waŋanan nhanŋu bitjarra, “Way yolŋu, go malthurra ŋarrakun.” ");
INSERT INTO djr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Bala yan ŋayiny ŋunhi yolŋuny dhunupan rur'yurra, ganarrthaŋala ŋayi bukmaknha yan ŋunhi nhäny malany, bala malthurra nhanŋun Djesuwnha. ");
INSERT INTO djr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ga dhäŋur beŋuryiny bala ŋayi gan ŋuriŋiyiny Lebayyuny ḏirramuy ŋäthilmirriyaŋala djäman dharrwan ŋatha wäŋaŋur nhanukiyingala ŋayi. Ga dharrwan ŋunhi rrupiya-märranhamirrnydja yolŋu walal marrtjin balayiny wäŋalilnydja nhanukal, ga wiripuwurrnha yolŋu walal, nhinanan walal marrtjin ŋathan ḻukan walalnha rrambaŋin Djesuynha. ");
INSERT INTO djr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bala walalnydja ŋunhi Baratjiynydja walal ga rom-marŋgikunhamirriynydja walal gan gupa-waŋanan ŋanyanhany Djesunhany malthunamirriwala mala nhanukalaŋuwal bitjarra, “Nhaku nhuma ga dhuwal ŋatha ḻuka rrambaŋiny ŋunha rrupiya-märranhamirriwalnydja yolŋuwal walalaŋgal, ga wiripuwurruŋgalnydja dhuwurr-yätjmirriwal?” Bitjarra walal gan waŋan. ");
INSERT INTO djr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bala ŋayiny Djesuynydja ŋäkula walalany, bala ŋayi waŋanan walalaŋ buku-bakmaraŋala bitjarra, “Ḏäwalamirrnydja yolŋu walal rerrimiriwnydja mala ŋuli yakan marrtji marrŋgitjkal ḏukmaranharaw, ŋany ŋunhin yolŋu rerrimirra yan ŋuli marrtjiny gänhamirrnydja ŋanyapinya ŋayi marrŋgitjkalnydja. ");
INSERT INTO djr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ŋarrany dhuwal yaka marrtjinya ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi walal ga nhina yanbi walal be dhuwurr-dhunupan mala. Ŋarrany dhuwal räli marrtjin dhuwurr-yätjmirriwnha yan yolŋuwnydja walalaŋ, märr walalnydja dhu bilyunna, bala gananna walalaŋguwuy dhuwurr-yätjkurrnydja rom mala, märr walalnydja dhu walŋathirra.” ");
INSERT INTO djr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wiripuwurrnydja yolŋu walal marrtjin bala Djesuwal, bala walal ŋanya gan waŋanan dhä-birrka'yurra bitjarra gam', “Way, ŋunha Djonguny malthunamirr walal ŋuli ga dharrwamirr bukumirriyam ŋoy-ŋathamiriwnha mala, ga wiripuny ŋunhawurr ŋunhi yolŋu walal Baratjiw malthunamirr mala, walalnydja ŋuli ga ŋunhi bitjandhi bili yan ŋoy-ŋathamiriwyi yan buku-ŋal'yun. Yurr nhokalnydja malthunamirriy walal ŋuli ga dhuwal bitjan warray bili ḻuka yan ŋatha ga gapu; bäyŋu walal ŋuli gi dhuwali ŋathamiriwnydja nhini. Nhaku walal ŋuli gi ŋunhi yakany malthurr ŋurikiyiny romgu, ga ŋathawnydja walal ŋuli gi ŋunhi bäyŋun yan gurr'yurr?” ");
INSERT INTO djr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Bala ŋayiny Djesuynydja buku-bakmaraŋala, lakaraŋala walalaŋ mayali'kurra dhäwu bitjarra gam', “Ŋunhi ŋuli yolŋuny walal marrtji ḻuŋ'thun waŋgany-manapanmirrnydja, gumurr-ŋamathinyarawnydja ŋurikiny yolŋuw ḏirramuw ŋunhi ŋayi dhu märraman nhanŋuwuy ŋayi miyalknhan, bala nhaltjanna walalnydja ŋuli ŋunhi yolŋuny walal? … ŋoy-ŋathamiriwnha ga nhina? Bäyŋu warray. Yänan walal ŋuli marrtji ŋunhi ḻukan bala ŋathany, goŋmirriyirra manapan ŋurikalyiny ḏirramuwala, ga yan bili ga ganan ŋayi dhu walalany. ");
INSERT INTO djr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ga ŋarrakuny dhuwandja malthunamirr walal balanyayi nhakun ŋunhiwurryi yolŋu walal, ga ŋarrany dhuwal balanyayin nhakun ŋunhi ḏirramun. Yo. Dhiyaŋuny bala walal ga dhuwal ŋayaŋu-djulŋithirr nhina, ga yalalaŋumirriynydja ŋunhi ŋarra walalany dhu ganarrthulnydja, bala walal dhu gi ŋunhi ŋoy-ŋathamiriwnha nhini biyakiyin bili yan, bili warwuynha walalany dhu ŋunhi ŋayathul.” ");
INSERT INTO djr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Bala ŋayi Djesuy wiripuny muka dhäwu lakaraŋal mayali'wurryi yan bitjarr gam', “Ŋäthiliŋuny dhuwal rom balanya nhakun ŋunhi gumurrpuy ŋäthiliŋu girri'. Ŋunhi ŋuli yolŋuw ŋäthiliŋuny gumurrpuy barr'yuna, ga yakan ŋayi dhu ŋunhi yuṯany girri' yarrar'maram, bala dhä-manapan mam'maram ŋunhawalnydja ŋunhi ŋäthiliŋulilnydja girri'lil, buluyi nhakun manymakkumany. Ŋuli ŋayi dhu ŋunhi dhä-manapandja rrambaŋikumany maṉḏany, ŋäthiliŋunhany ga yuṯanhany girriny', ŋunhiny nhakun ŋayi dhu miḏikumanna ŋunhi yuṯanhan girriny', ga ŋayiny dhu ŋunhiyiny ŋäthiliŋuny yakan ŋamathirr balanyarayyiny, bili ŋunhiyi yuṯany wiripun, gänaŋ'thuna ga beŋuryiny ŋunhi ŋäthiliŋuŋurnydja.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja, märr dhu yolŋuy yaka yuṯany romnha waŋgany-manapan ŋäthiliŋulilnydja rrambaŋiyamany maṉḏany. ");
INSERT INTO djr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ga wiripuny ŋayi Djesuy bitjarryi bili lakaraŋalyi mayali'mirryi yan dhäwu, dhuwal gam', “Ŋarrakuny dhuwal rom balanya nhakun ŋunhi yuṯa borum wiyika' djämapuy. Ŋunhi ŋuli yolŋuy djäma yuṯany borum wiyika', yakan ŋayi dhu ŋunhi rarryun ŋunha ŋäthiliŋulilnydja bathilil, balanyalilnydja nhakun ŋäthiliŋu bathi yäku ḏimbuka. Bili ŋunhiyiny ŋäthiliŋuny bathi mak dhu barr'yuna ŋuriŋiyiny yuṯaynydja wiyikay', bala dhu ŋunhi wiyikany' djalkthunmirra, dhawar'nha dhu, ga bathiny dhu ŋunhi yätjirra buruŋgulkthirra. ");
INSERT INTO djr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ga ŋuli ŋayi dhu yolŋuy märram yuṯany borum wiyika, ŋunhiny ŋayi dhu rarryundja yuṯalila yan bathililnydja.” ");
INSERT INTO djr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ga wiripuny ŋayi Djesuy lakaraŋal mayali'mirr dhäwu bitjarr gam', “Ŋunhi ŋuli yolŋuy ḻuka ŋäthiliŋuny borum wiyika, bala ŋayi ŋuli waŋany bitjanna gam', ‘Dhäkay-manymak dhuwal ŋäthiliŋuny wiyika bay. Yaka ŋarra djäl yuṯawnydja.’ Yo. Yolŋuynydja walal ŋuli yaka bondi ganurr ŋunhi ŋäthiliŋunhany romnha, bala marrtjin yuṯakurra romgurr.” Bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Waŋganydhuny waluy Djesuny ga nhanŋu malthunamirrnydja walal marrtjin wäŋgaŋala dhukarr-ŋupara, yurr ŋunhi waluynydja Nhinanhamirriynha. Ga gali'ŋurnydja gali'ŋurnydja marrtjin dhärran ŋathan mala birralin. Bala walalnydja ŋunhi malthunamirriynydja mala nhanukal gulkthurra ŋunhi ŋathany mala burumun'tja, bala walal marrtjin buryiwuryi'yurra goŋlila, barrwaṉ' djalkthurra, ga ŋunhi maŋutjiny walal marrtjin ḻukanan. ");
INSERT INTO djr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bala walalnydja ŋunhi Baratjiynydja yolŋuy walal nhäŋala walalany ŋunhiwiliyin nyaŋ'thunalila, ga dhunupan walal ŋunhi waŋanany nhanŋu Djesuwnydja ga ḻundu'mirriŋuwnydja mala nhanukalaŋaw bitjarra gam', “Way, nhaku nhuma ga dhuwal bitjandhiny djäma dhiyaŋuny ŋunhi Nhinanhamirriynydja waluy? Yaka yanbi dhuwal dhunupa ŋula yolkuny yolŋuw ŋayi dhu ga goŋdhuny djäma ŋula nhäny mala.” ");
INSERT INTO djr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bala ŋayipiny nhakun Djesuny buku-bakmaraŋala walalaŋ bitjarra, “Way walal. Yaka yan nhuma dhuwal dhäwuwny'tja marŋgi muka? … ŋunhi nhaltjarr ŋayi gan ŋäthil djäma ŋuriŋi ŋunhi ŋurruŋuy yolŋuy yäkuy Daybitthu? Waŋganymirrnydja ŋayi Daybittja ga ḻundu'mirriŋuny walal nhanŋu mirithinan djaṉŋarrthin, bäyŋun walalaŋ ŋula ŋathany. ");
INSERT INTO djr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bala dhunupan ŋayiny Daybittja gulŋiyinan ŋunhiwiliyin ŋunhi God-Waŋarrwala Buṉbulilnydja, bala ŋayi märraŋala ŋunhiyin dhuyun ŋathany, rrothin yäku, ŋunhi mundhurr rulwaŋdhunawuy God-Waŋarrwun. Ga ŋayiny ŋunhi Daybitthuny ŋunhiyiny dhunupan ḻukanan yan, ga bitjarryi bili ŋayi gurruparyi ŋunha malanhany nhanŋuwuy. Yurr yakan yanbi ŋunhi dhunupa bukmakkuny yolŋuw ḻukanharaw, bili ŋunha romdja ga waŋa, ŋunhiyiny ŋatha dhu ḻuka walalawuynha yan djirrikaymirriynha mala bäyŋun ŋula wiripuŋuynydja yolŋuy. Yurr walalnydja ḻukan yan ŋunhiyi dhuyu ŋatha.” ");
INSERT INTO djr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Bala ŋayi Djesuny waŋan dhawar'maraŋalnydja bitjarra gam', “Ŋarran dhuwal Yolŋun Gäthu'mirriŋu, buŋgawany gal'ŋu dhiyakiyiny ŋunhi Nhinanhamirriwnydja waluw.” Ga bitjarra ŋayi gan ŋunhi Djesu lakaranhaminany ŋanyapinya ŋayi. ");
INSERT INTO djr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ga bulu nhakun wiripuŋuynha Nhinahamirriy waluy, Djesuny ŋunhi marrtjinan balan Djuw malawalnha buku-ḻuŋ'maranhamirrilila buṉbulil, bala ŋayi gan marŋgikuŋala yolŋunhan walalany ŋunhiliyiny. Ga ŋunhiliyi gan yolŋu ḏirramu nhinan goŋ-dhoṯ, yurr dhunupa'ŋu ŋayi ŋunhi goŋdja miḏiku'ŋuny. ");
INSERT INTO djr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ga walalnydja ŋunhi wiripuwurrnydja rom-marŋgikunhamirr walal ga Baratji walal, nhinanan walal gan ŋunhiliyi djinawan' buṉbuŋura, nhäŋala walal gan ŋanyanhan Djesunhan rukitjthinan gan nhanŋu, nhaltjan ŋayi dhu walŋakum ŋunhiyi ḏirramuny ŋuriŋiyi Nhinanhamirriy waluy, märr walal ŋanya dhu rom-nyamir'yunna. ");
INSERT INTO djr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yurr ŋayipiny Djesuny ŋäthil yan walalaŋ marŋgithin, nhaltjarr walal gan ŋunhi guyaŋan, bala ŋayi wäthurra ŋurikiyiny goŋ-dhoṯkuny ḏirramuw, “Go, rur'yurra rälin marrtji dhipala,” bitjarr. Bala yan ŋayiny ŋunhiyiny goŋ-dhoṯtja ḏirramu rur'yurra bala guwatjmara Djesunhan. ");
INSERT INTO djr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ga ŋayiny Djesuny bilyurra, ga waŋan ŋathil ŋayi ŋurruŋuny dhä-birrka'yurr walalany bitjarr, “Nhä dhika limurruŋ ŋula romdja dhiyakiyiny waluw Nhinanhamirriwnydja? Nhaltjan limurr dhu guŋga'yun muka ŋula yolŋunhany walalany? Ŋany nhaltjanna … ŋayaŋu-yätjaman walalany muka? Nhaltjan dhika limurr dhu walŋakum walalany, wo yänan ga nhäman walalany ganarrthaman?” ");
INSERT INTO djr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bala ŋayi Djesuynydja marrtjin nhäŋala walalany ḻiw'maraŋala yanan, bala ŋayi waŋanan ŋurikiyiny goŋ-dhoṯkuny ḏirramuw bitjarra, “Ma', go, nheny goŋ-djarryurra rälin ŋarrakala.” Bala ŋayiny dhunupan yan goŋdja djarryurra, bala yan nhanŋu ŋunhi goŋdja dhunupayinan, ḏukthurra manapar. ");
INSERT INTO djr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ga walalnydja ŋunhi rom-marŋgikunhamirrnydja walal ga rom-ŋayathanhamirrnydja yolŋu mala, mirithinan nhanŋu Djesuwnydja maḏakarritjthin, bala walal marrtjin ŋunhi waŋanhaminan nhanŋu bunharawnha. ");
INSERT INTO djr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ga dhäŋur beŋuryiny bala ŋayi Djesuny marrtjinan balan bukulila bukumirriyanharawnha, ga ŋunhiliyin ŋayi gan bukumirriyaŋalnydja God-Waŋarrwalnydja munha-ŋupara. ");
INSERT INTO djr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ga ŋunhi ŋayi marrtjin waluny dhawaṯthurr dhiyaŋ muka bili yan, bala ŋayi Djesuynydja ḻuŋ'maraŋala ŋunhi malthunamirrinhany walalany nhanŋuwuy ŋayi, bala ŋayi beŋuryin ŋunhi malaŋur djarr'yurrnydja walalany 12-nhany galkipuynhany yan malthunamirriny mala nhanŋuwuy ŋayi, bala ŋayi waŋanan walalaŋgal bitjarra, “Nhumany dhu dhuwalawurrnydja Djuy'yunawuynha mala ŋarrakun.” ");
INSERT INTO djr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ga dhuwalawurr ŋunhi Djuy'yunawuynydja yolŋu walal yäku gam', Djäyman,* ŋunhi ŋayi Djesuy ŋanya yäku-lakaraŋal Beta,* ga wäwa'mirriŋu nhanŋu yäku Wanduru,* ga Djayim,* ga Djon,* ga Bilip* ga Bäthalamiyaw, ");
INSERT INTO djr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ga Mathuyu,* ga Dumitj,* ga wiripu Djayim,* ŋunhi ŋayi gäthu'mirriŋu Yalpayatjku, ga wiripuny ŋunhi yolŋu Djäyman* yäku, ŋunhi walal ŋuli ganha yäku-lakaranha ŋanya rom-ḏäl ḏirramu, ");
INSERT INTO djr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ga Djudatj* ŋunhi ŋayi gäthu'mirriŋu Djayimgu,* ga Djudatj-Gariyat, ŋunhin yolŋu ŋunhi ŋayi dhu goŋ-gurrupanna ŋanya Djesunhan miriŋuwala walalaŋgal goŋlil. Ga dhuwalawurrunydhi malanhany ŋayi ŋunhi Djesuynydja märraŋal gänaŋ'maraŋalnydja nhanŋuwuynydja ŋayi ḻundu'mirriŋuny walalany galkipuynhany. ");
INSERT INTO djr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yo. Ga dhäŋur beŋuryiny bala ŋayiny ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu ŋunhi 12-tja, marrtjinan yarrupthurra beŋuryiny ŋunhi bukuŋurnydja, bala walal gan dhärra'-dharranany ŋunhiliyin yarrpalanyŋura wäŋaŋurnydja, rrambaŋin walalnha ŋunhiwurrnha ŋunhi wiripuwurrnha malthunamirr mala nhanŋu. Ga beŋuryiny bulun dharrwan mirithirra dhika yolŋu walal marrtjin ḻuŋ'thurr walalaŋgal. Yurr guwatjmarnydja walalany gan ŋunhi yolŋuynydja walal wiripuŋuŋura wiripuŋuŋura wäŋaŋurnydja mala, beŋur Djudiyaŋur* ga Djurutjalamŋur* wäŋaŋur, ga beŋur bala gali'-moṉukŋur wäŋaŋur yäkuŋur Däyaŋur* ga wiripuny Djäydanŋura. ");
INSERT INTO djr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Dhuwalawurryiny marrtjin yolŋu walal ḻuŋ'thurr nhanukal Djesuwal buthuru-bitjunarawnha nhanŋu. Ga wiripuny walal gan ŋunhi djälthin nhanŋu Djesuw, ŋayi walalany dhu marrtji ḏukmaraman rerriŋura. Ga wiripuwurrnydja ŋunhi yolŋu walal marrtjin balayi yätjkurr birrimbirrmirra mala, bala ŋayi gan ŋunhi Djesuynydja walalany bukmaknhan ḏukmaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ga bukmaknha gan ŋunhi yolŋuny walal djälthinany nhanŋu Djesuwnydja ŋayathanharawnha, bili nhanukalaŋuŋur marrtjin ŋunhi dhawaṯthurrnydja yindin mirithirra ganydjarrnydja, bala bukmaknha yan walal marrtjin ŋunhi ḏukthurrnydja nhanukuŋ. ");
INSERT INTO djr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Bala ŋayi Djesuynydja marrtjin nhäŋala nhanŋuwuy ŋayi malthunamirrinhan walalany, bala ŋayi lakaraŋalnydja walalaŋ bitjarra, “Nhumany dhu ŋunhi ŋurruwuykmirrnydja yolŋu walal ga nhina ŋoy-ŋamathirra yan, bili God-Waŋarrwuŋuny rom ŋunhi nhumalaŋgun ŋurukuwurruŋdhin yolŋuw walalaŋ ŋunhi ŋurruwuykmirriwnha. ");
INSERT INTO djr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ga nhumany ŋunhi nhuma ga djaṉŋarrthirr dhiyaŋ bala, nhumany dhu ga ŋayaŋu-djulŋithirra, bili God-Waŋarryuny nhumalany dhu maranhu-gurrupanna yalalaŋumirriynydja ŋunhalnydja djiwarr'ŋurnydja. Ga nhuma ŋunhi nhuma ga galŋa-yätjirr dhiyaŋ bala ŋäthinyaray, biyakun walal ŋayaŋu-djulŋithin, bili yalalaŋumirrnydja nhuma dhu ŋunhi ŋunhalnydja gi mirithin yan ŋoy-ŋamathi.” ");
INSERT INTO djr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","“Yo. Ŋuli nhuma dhu ga ŋunhi malthundja Gäthu'mirriŋuwnydja Yolŋuw yuwalkkumany yan, bala walalnydja dhu ŋunhi wiripuwurrnydja yolŋu walal ŋuyulkthirra nhumalaŋguny, ŋaŋ'ŋaŋ'thunna walal dhu ga nhumalany, ga waŋany walal dhu ga ŋunhi nhumalany yätjkurr-lakaraman. Bala nhumalany walal dhu ga ŋunhi ŋayaŋu-yätjaman, bitjan yan bili nhakun walalaŋgal gan mala-ŋurrkanhayŋuy walal ŋayaŋu-yätjaŋal ŋunhi God-Waŋarrwu djawarrkmirriny yolŋuny walalany be ŋäthil. Yurr nhumapiny dhu ga ŋayaŋu-djulŋithirra, goŋmirriyirra manapan, bili nhumany ŋuli ga dhuwal nhinany nhanukala God-Waŋarrwala goŋŋurnydja. Yo, biyakun gi yänan ŋayaŋu-djulŋithin, märr-ŋamathin manapul, burr'yurra gi buŋgulnha djäma, ŋunhi walalnydja dhu ga bäynha nhuŋu mariny djäma, bili ŋunha djiwarr'ŋurnydja ga God-Waŋarryuny ŋayatham nhumalaŋguny bulu warray ŋamakurr yalalaŋumirriwnydja märranharaw.” ");
INSERT INTO djr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ga nhumany ŋunhiwurrnydja yolŋu walal ŋunhi nhuma ga dhiyaŋ bala nhina girri'-dharrwamirr, ga walŋany nhumalaŋ manymaknha mirithirra, yalalaŋumirriynydja ŋunhalnydja nhuma dhu boŋguŋ wakinŋun gi nhini, goŋ-waŋaran ŋula nhämiriwnha. ");
INSERT INTO djr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ga nhuma, ŋunhi nhuma ga dhiyaŋ bala maranhu nhina dharrway ŋathay, ga dhurrwaraŋur dhiŋganhaŋurnydja, ŋunhalnydja yalalany, nhumany dhu gi marryan' nhini dhäparŋ'nha yan ŋula nhämiriwnha. Ga nhuma wiripuwurr, ŋunhiwurr ŋunhi nhuma ŋuli ga dhiyaŋ bala gitkitthunmirr, ga beyarrmakthirr nhumalaŋgal ŋuli ga, ŋunhalnydja nhuma dhu boŋguŋ yalalaŋumirrnydja gi galŋa-miḏikin nhini, ŋäthinyamirra yan.” ");
INSERT INTO djr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Yo. Ga ŋuli nhumalany dhu ga ŋunhi bukmakthuny yolŋuy walal lakaram yanbi nhumany be manymakmirra, ŋunhiyiny yakan ŋamakurr, bili ŋäthilnydja ŋunhi walalaŋgal mala-ŋurrkanhayŋuy mala gan manymak-lakaraŋal ŋunhiwurruny djawarrkmirriny walalany ŋunhi nyäḻ'mirrinhan, ŋunhi walalnydja yakan yuwalk God-Waŋarrwu yolŋu walal. Ga ŋuli walal dhu ga nhumalanhany bitjandhi manymak-lakaram, ŋunhiyiny nhakun nhumany yakan yuwalk ŋarrakuny malthunamirr mala. Bala yalalaŋumirrnydja nhumany dhu ŋunhi galŋa-yätjiny mirithin yan.” Ga bitjarra ŋayi gan ŋunhi Djesuy marŋgikuŋalnydja walalany. ");
INSERT INTO djr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Yo ŋarrany dhu dhuwal lakaraman nhumalaŋ ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi nhuma ga buthuru-bitjun ŋarraku, ga dhuwanna ŋunhi dhäruktja gam'. Märr-ŋamathiny gi mirithin yan ŋurikiny yolŋuw ŋunhi ŋayi ŋuli ga nhuŋu mari djäma. Ga djämany gi manymaknha yan guŋga'yurra ŋunhiyiny yolŋuny ŋunhi ŋayi ŋuli ga ŋuyulkthirrnydja nhuŋu. ");
INSERT INTO djr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ga ŋuli dhu ŋula yol yolŋu nhuŋu waŋa gumurr-dhar'yundja nhuna, nheny nhanŋuny buku-roŋanmaraŋ ŋamakurrnha yan dhäruk, guŋga'yunamirra. Ga ŋuli nhuna dhu ŋula yolthu bumany, ga nheny dhu yänan nhanŋu ŋurikiyiny yolŋuw bukumirriyaman. ");
INSERT INTO djr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ga ŋuli nhuna dhu ŋula yolthu bartjunmaram waŋganydja dhakal, ga nheny wiripuny dhakal yänan gurrupanmirra nhanŋu. Ga ŋuli nhuŋu dhu ŋula yolthu yolŋuy djaw'yun gumurrpuynydja girri', nheny nhanukal yänan dhayuŋula, ga biyakiyi bili gurrupulyi nhanukal ŋunhi wiripuny girri' nhuŋuwuy nhe. ");
INSERT INTO djr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Biyakiyi bili gurrupulyi ŋurikiyiny yolŋuw ŋunhi ŋayi dhu ŋäŋ'thundja nhuna ŋula nhakuny malaŋuw. Ga ŋuli ŋayi dhu ŋula yolthu yolŋuy nhuŋu djaw'yundja ŋula nhäny mala, nheny yakan waŋi mirithi ŋupulnydja roŋanmaraŋuny ŋunhiyiny girriny' nhuŋuwuy nhe. ");
INSERT INTO djr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nheny djäl muka ŋunhi wiripuwurruynydja dhu ga djäma ŋamakurr nhuŋuny? Ga nheny biyakiyi bili walalaŋguny djämayi ŋamakurryi yan balany.” ");
INSERT INTO djr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ŋuli nhe ga märr-ŋamathirr ŋurikiwurruŋguny bili yan, ŋurikiwurruŋguny ŋunhi walal ŋuli ga märr-ŋamathirr nhuŋu, God-Waŋarryuny nhuŋu dhu bäyŋun buku-roŋanmaram balanyawuyyiny märr-ŋamathinyawuy. Ŋunhiwurrnydja yolŋu walal dhuwurr-yätjmirrnydja, walalnydja ŋuli ga ŋunhi märr-ŋamathirr muka ŋurikiwurruŋguny yolŋuw walalaŋ, ŋunhi walal ŋuli ga märr-ŋamathirr walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ga ŋuli nhe dhu ga djäma ŋamakurr ŋurukuwurruŋguny bili yan yolŋuw walalaŋ ŋunhi walal ŋuli ga djäma ŋamakurr nhuŋu, ga nhaltjanna ŋayiny dhu God-Waŋarryuny, gurrupan muka buku-roŋanmaram nhuŋuny ŋunhiŋuwuyyiny? Ŋuruŋurruynydja ŋuli ga ŋunhi dhuwurr-yätjmirriynydja yolŋuy walal djäma ŋamakurryi yan ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi walal ŋuli ga djäma manymakkum walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ga ŋuli nhe dhu ŋunhi guwarrnydja yan gurrupan ŋula nhä mala ŋurikiwurruŋguny yolŋu'-yulŋuw, ŋunhi nheny marŋgi walalaŋ walal dhu yalala nhuŋuny buku-roŋanmaramdhi, God-Waŋarrnydja dhu yakan nhuŋuny wokthun balanyawuyyiny djämapuy, bili bitjandhin ŋuli ga ŋunhi dhuwurr-yätjmirriynydja yolŋuy walal djäma. ");
INSERT INTO djr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yurr God-Waŋarrwuny dhuwal rom gäna warray, gänaŋ'thun ga beŋurnydja ŋunhi dhuwurr-yätjmirriwalnydja yolŋuwal walalaŋgal romŋur. God-Waŋarrwuny dhuwal rom balanya warray gam'. Märr-ŋamathi gi nhininy ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi walal ŋuli ga ŋayaŋu-yätjam nhuna, ga djämany nhe dhu ga ŋamakurra yan walalaŋguny. Gurrupulnydja walalaŋ gi wiripuwurruŋguny yolŋuw walalaŋ wetjthuny dhapinyaynha, ga yakan gi guyaŋiny ŋula yaŋara'-bakmaranharawnydja. Ŋuli nhuma dhu ga ŋunhi bitjandhiny djäma, ŋayiny dhu God-Waŋarryuny nhumalaŋ yaŋara'-bakmaraman nhanukiyingalnydja ŋayi wetjthu ŋayaŋuynydja dhapinyaynha yan, ga ŋunhiyiny nhakun nheny dhu nhanŋun gäthu'mirriŋuny God-Waŋarrwun, ŋurikiyin ŋunhi ŋayiny bulu warray dhika garrwar ga yindi. Bili ŋayiny ŋuli ŋunhi God-Waŋarryuny gurrupan yan nhä malany manymak ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi djäl-gänaŋumirriwnydja ga wiripuny ŋunha dhuwurr-yätjmirriw yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yo. Biyak gurrum'thurr marrtji mel-wuyurrnydja bukmakku yan, biyak nhakun ŋayipi ga Bäpa'mirriŋu nhumalaŋ djiwarr'puy ŋuli ga mel-wuyun bukmakku yan.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ga bitjarr ŋayi wiripuny Djesu waŋan gam', “Yaka gi wiripuŋunhany yolŋuny rom-nyamir'yurr, märr ŋayiny dhu God-Waŋarryuny yaka muka nhunanhany rom-nyamir'yun. Yaka gi wiripuŋunhany yolŋuny yätjkurr-lakaraŋ, märr ŋayiny dhu God-Waŋarryuny yakayi nhunanhany yätjkurr-lakaram. Nheny bäy-lakaraŋun wiripuwurruŋguny yolŋuw walalaŋ, märr dhu ŋayiny God-Waŋarryuny bäy-lakaramdhi muka nhuŋuny. ");
INSERT INTO djr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mukthurr marrtji bala gurrupulnydja walalany wiripuwurrunhany yolŋuny walalany biyak bili yan, bala ŋayiny dhu God-Waŋarryuny nhuŋuny yänan gurrupanna. Yo. Ŋayiny dhu ŋunhi God-Waŋarryuny nhuŋu gurrupan dhaŋaŋ warray mirithirr, dhurrwarakurrnydja dhu marrtji ŋunhi djalkthunmirra, märryuny dhapinyaynha yan. Ŋuli nhe dhu ga gurrupan märr-ŋuyulkmirriynydja, ga nyumukuṉiny'tja ŋula nhä malany, ga ŋayiny dhu God-Waŋarryuny bitjandhi bili yan nhunanhany gurrupan maŋutji-yarrkthundhi. Ga ŋuli nhe dhu gurrupan märryu-dhapinyaynydja, ga ŋayiny dhu God-Waŋarryuny nhuŋuny bitjandhi bili yan gurrupan märryu-dhapinyayyi yan, bukulil ŋal'maram dhu marrtji bala.” ");
INSERT INTO djr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yo. Ga dhäŋur beŋuryiny bala ŋayi Djesuynydja lakaraŋala walalaŋgal dhäwun' mayali'mirra bitjarra gam', “Ŋuli maṉḏa dhu ga ŋunhi bambaynydja yan yolŋu maṉḏa waṉa-ŋayathanhamirr, maṉḏany dhu ŋunhi rrambaŋin galkirriny ŋarŋgalilnydja. ");
INSERT INTO djr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yakan ŋayi dhu ŋunhi ŋula marŋgithinyamirriynydja yolŋuy djuḻkmaram nhanŋuwuy ŋayi marŋgikunhamirrinhany; bili ŋayiny ŋunhiyiny yolŋu marŋgithinyamirrnydja ŋoyŋura. Yurr ŋuli ŋayi dhu ga ŋunhi buthuru-bitjun ŋamathamany yan nhanukiyingalaŋaw ŋayi marŋgikunhamirriw, ŋunhiyiny nhakun ŋayi dhu marŋgithirra warrpam'nha nhanukuŋ ŋurukuŋunydhiny marŋgi-gurrupanamirriwuŋuny, ga yalalany ŋayi dhu ŋunhiyiny yolŋu marŋgin, balanyan bili yan nhakun ŋunhiyin yolŋu marŋgi-gurrupanamirra nhanŋu.” ");
INSERT INTO djr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nhaku nhe ŋuli ŋunhi nhäma wiripuŋuwalnydja yolŋuwal maŋutjilil ŋunhi nyumukuṉiny'tja dhukun? Nheny ŋathil dhu nhänhamirr nhunapinya nhe maŋutji; dhuwali nhokalnydja ga gulŋiyirryi maŋutjiŋur yindi warray dharpa. ");
INSERT INTO djr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ŋuli dhu ga yolŋuwal maŋutjiŋur gärri ŋula nhäny nyumukuṉiny'tja dhukun, ga dhuwali nhokalnydja ga gärri maŋutjiŋur yindiny, yakan nhanŋu nhe dhu ga ŋunhi waŋa bitjandja, ‘Go, ŋarra nhuŋu wilaŋ'thun, dhukun dhuwali dhawaṯmaraman maŋutjiŋur nhokal.’ Bitjandja nhe dhu yaka yan waŋa. Ŋurruŋuny ŋathil nhe dhu ŋurrkam dhuwali nhokiyingal nhe dhipuŋuryi maŋutjiŋur, märr nhe dhu ŋathil nhäma ŋamathamany, ga yurrnha nhe dhu ŋunhi ŋanyanhany guŋga'yun, märr dhu ŋayiny nhäma ŋamathaman yan.” ");
INSERT INTO djr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ga bulu ŋayi Djesuy lakaraŋal wiripun dhäwu mayali'mirr bitjarr gam', “Ŋuli dhu ga dharpa dhärra walŋany yan ga marramirrnydja, ga dhakalnydja dhu ga ŋunhi ŋathany ŋunhiŋuwuyyi dharpapuy ŋamathirryi yan ŋuthan; yakan dhu yätjirr. Ga ŋuli dhu ga dharpa ŋuthan yätjkurrthirrnydja, ga borumdja dhu ŋunhiŋuwuyyi miḏikirryi yan, yakan dhu ŋamathirr. ");
INSERT INTO djr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yo, nhäma nhuma dhu ga dharpa malany borummirrnydja dharaŋana, nhaltjan ga ŋunhi borum malany dharpaŋur ŋuthan, wanha manymak borum ga wanha yätjkurr borum. Bäyŋun nhuma dhu ŋunhi gäŋanhany borumnha maḻŋ'maram ŋayi dhu ga gorrum burrpu'ŋurnydja dharpaŋur, ga muthirny'tja ŋuli yakan ŋuthul ḏirriṯirriŋurnydja dharpaŋur. ");
INSERT INTO djr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Manymakthuny ŋuli ga yolŋuy ruwamŋuyam manymaknha yan nhä malany nhanukiyingal ŋayi ŋayaŋulil, bala ŋuli ga ŋunhi dhäruktja nhanukal dhawaṯthundja manymaknha yänan. Ga yätjkurrnydja ŋuli dhäruk dhawaṯthun yolŋuwal yätjkurruwala yan, bili ŋayi ŋuli ga ŋunhi ruwamŋuyamany yätjkurra yan ŋayaŋulilnydja nhanukiyingal ŋayi. Bili dhäruktja ŋunhi ŋayi ŋuli ga yolŋuny waŋa, balanyan bili yan dharaŋanan nhakun nhäthinya ŋayi ŋuli ga ŋunhi ŋayaŋuy nhanukiyingal ŋayi ŋayatham.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja marŋgikuŋalnydja walalany. ");
INSERT INTO djr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ga bulu ŋayi Djesu waŋan walalaŋgal bitjarr gam', “Nhaku nhuma ŋuli ga ŋunhi yäku-lakaramany ŋarrany bitjandja, ‘Garray! Garray!’ bitjandja, yurr yaka warray nhuma ŋuli gi djämany ŋunhi dhäruk-gurrupanminyawuynydja ŋarrakuŋ? ");
INSERT INTO djr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Dharr ŋäkun walal. Ŋarra nhumalaŋ dhu lakaraman dhäwun' mayali'mirra. Ŋuli nhe dhu ŋula yol yolŋu galkithirrnydja ŋarrakal, ga dhäruktja ŋarrany märram, ");
INSERT INTO djr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","nheny dhu ŋunhiyiny yolŋu balanyan nhakun ŋunhin yolŋu ŋunhi ŋayi dhuḻ'yurr bala' nhanŋuwuy ŋayi guṉḏamirrilil wäŋalil. Ŋurruŋuny ŋathil ŋayi yaw'yurr munatha' ḏandjakuŋal yan, ga yurrnha ŋayi ŋunhi ḻukuny rulwaŋdhurr ŋurikiyiny buṉbuwnydja dhärranharaw. Ga ŋunhi nhakun ŋayi gapuny riyala-waṉḏin, bala ŋayi gan ŋunhi buṉbunhany dhurrwuyurrnydja, galkirrinyamaraŋalnydja gulkurun, ŋayiny gan dhärranan ŋunhiyi buṉbuny ḏälnha mirithirra, bili buṉbuwalnydja gan yuṯuŋgurryuny ŋayathaŋal ŋunha guṉḏanhan. ");
INSERT INTO djr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ga ŋuli nhe ga ŋula yolthu yolŋuy ŋämany ŋarrany dhäruk bäykarraramany, yakany nhe dhu märram ŋunhiyi dhäruk ŋarrany, ŋunhiyiny nhe yolŋu balanyan nhakun ŋunhin yolŋu ŋunhi ŋayi buṉbu nhanŋuwuy dhuḻ'yurr djalkiri-munatha'lil, bili yaka ŋayi ŋula ŋäthil rulwaŋdhunna buṉbupuy ḻuku ŋunha djinawa'lil munatha'lil. Ga ŋunhi nhakun ŋayi gapuny waṉḏin mayaŋdja, bala wutthurra yan ŋunhiyi buṉbunhany, ga dhunupan nhakun ŋunhiyi buṉbuny buḻ'waŋdhurra, buku-ḻarryurra yan munatha'lila warrpam'thurra yan yindiynha dhika rirrakayyuny!” Ga bitjarra ŋayi gan Djesuy lakaraŋalnydja walalaŋ dhäwuny' ŋurikiwurruŋguny ŋunhi walal gan malthurr nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yo. Ga ŋunhi ŋayi Djesu dhawar'yurrnydja marŋgikunhaŋurnydja yolŋuwalnydja walalaŋgal, bala ŋayi marrtjinan Gapuniyamlila wäŋalil. ");
INSERT INTO djr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ga ŋunhiliyi wäŋaŋur yolŋu gan nhinan ŋunhi ŋayi ŋurru-warryunayŋu miriŋuw malaŋuw. Ga ŋuriŋiyi gan yolŋuy buŋgaway ŋayathaŋal djämamirriny nhanŋuwuy ŋayi, ga mirithin yan ŋayi gan ŋunhi ŋunhiyiny buŋgawany märr-ŋamathin nhanŋu ŋunhi djämamirriwnydja yolŋuw nhanŋuwuy ŋayi, yurr ŋayi gan ŋunhi djämamirrnydja yolŋu rirrikthurrnydja mirithinan; galki balaŋ ŋayi ŋunhi dhiŋganhan. ");
INSERT INTO djr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bala ŋayi ŋuriŋiyi buŋgawaynydja ŋäkula ŋanya Djesunhany, bala yan ŋayi djuy'yurra Djuw-nhan yolŋuny walalany ŋaḻapaḻmirrinhan balayin Djesuwnha garr'yunaraw, märr ŋayi dhu marrtji bala ḏukmaraman ŋunhiyin yolŋuny djämamirrinhan. ");
INSERT INTO djr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bala walal ŋunhi dhäwumirrnydja mala marrtjinan ga burnha bunan nhanŋu Djesuwnydja, ga waŋan walal bitjarr, “Wäy, marrkapmirr, buku-djulŋi, nhämirr nhe dhu marrtji ga guŋga'yun ŋanya ŋunha Rawumbuynha buŋgawany,” bitjarr. “Ŋamakurr yan ŋayi ŋunha yolŋuny, ŋunhiyiny buŋgawany. ");
INSERT INTO djr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ga mirithirr yan ŋayi ga märr-ŋamathirrnydja ŋilimurruŋguny Djuw-malawnydja, ga bitjarryi bili ŋayi buṉbuny dhuḻ'yurryi ŋilimurruŋ buku-ḻuŋ'thunamirrnydja.” Ga bitjarra walal gan ŋunhi lakaraŋalnydja nhanukal. ");
INSERT INTO djr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bala ŋayiny Djesuny malthurra yan walalaŋ. Yurr ŋayiny gan ŋunhi Djesuny marrtjin ŋunha märr-barrku yan, yuṯa muka ŋayi marrtjin bitjarr bukuy-märraŋal ŋunhiyin wäŋa ŋunhi ŋurikiyin ŋurru-warryunayŋuwnha miriŋuw, märr galkithinan marrtjin, ga ŋayiny nhakun ŋunhi ŋunhiyiny ŋurru-warryunayŋuny buluyi dhäruk djuy'yunmin nhanŋu Djesuwnydja nhanukiyingalaŋuwala ŋayi ḻundu'mirriŋuwala walalaŋgal. Ga bunan walal nhanŋu Djesuw, bala walal waŋanan nhanŋu bitjarra gam', “Buŋgawa, yaka ŋuyulkkunhamirrnydja nhunapinya nhe. Ŋarrany dhuwal yaka gana' nhuŋu ŋunhi nhe dhu marrtji räliny ŋarrakalnydja wäŋalil. ");
INSERT INTO djr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ga guyaŋanhamirr ŋarra ga dhuwal ŋunhi ŋarrapiny dhuwal yakayi yan gana' ŋarra dhu ŋarrapiny gänany marrtji guwatjmandja nhuna. Yaka ŋarra nhuna dhu ga dhuwal ŋuyulkkumany, ŋany yänan biyakun dhäruknha gurrupanmirr nhunapinya nhe, bala ŋarraku dhu ŋunhayi djämamirrnydja yolŋu walŋathirra. ");
INSERT INTO djr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ŋarrany dhuwal ŋurruŋu yolŋu waṉa-nhirrpanawuy ŋurukuŋun ŋunhi yindiwuŋun ŋurruḏawalaŋuwuŋ yolŋuwuŋ; bitjan bili ŋarra ŋuli ga dhuwal dhäruktja ŋanya märram yan ŋunhiyiny yolŋuny ŋarrakuwuynydja ŋarra buŋgawa'mirriŋuny. Ga ŋarrapiny dhuwal buŋgawayi muka ŋurukun yolŋuw walalaŋ ŋunhi miriŋuwnha malaŋuw. Ga dhäruktja ŋarrany walal ŋuli ga ŋuruŋurruydhiny märram yan. Ŋunhi ŋarra ŋuli waŋa ŋula yolku waŋganyguny yolŋuw bitjandja, ‘Gatjuy marrtjin,’ bitjandja, ŋayiny ŋuli marrtjin yan. Ga ŋunhi ŋarra ŋuli wiripuŋuw yolŋuw waŋa bitjan, ‘Go marrtjin rälin,’ bitjandja ga ŋayiny ŋuli dhunupan marrtjin yan guwatjmanna ŋarrany. Ga ŋunhi ŋarra ŋuli waŋa ŋarrakuwuy ŋarra ḏapmaranhawuynha yolŋuny bitjandja gam', ‘Ma', biyakun djäman,’ bala ŋayiny ŋuli djäman yänan. Ga nheny dhu bitjandhiyin dhäruknha yan waŋganynha gurrupanmirr, bala ŋayiny dhu ŋunhi rerrimirrnydja yolŋu ŋunhalnydja ḏukthunna.” ");
INSERT INTO djr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bala ŋayiny ŋunhi Djesuynydja ŋäkulnydja ṉirr'yurra ŋunhiyi dhäruktja ŋanya balanyawuyyiny waŋanhawuy, bala ŋayi bilyurra, ga waŋan ŋayi ŋurikiwurruŋgalnydja ŋunhi walal gan malthurr nhanŋu bitjarra, “Way, ŋuruŋuny dhuwal mulkuruynydja ḏirramuy ŋarrany mirithin warray märr-yuwalkthin, ŋunhi ŋayiny yaka warray Djuw mala. Ga yaka ŋarra maḻŋ'maranha balanyayi märr-nhirrpanminyawuy ŋula yolkal waŋganygal yolŋuwal Yitjuralpuywal ŋäthilnydja; bäyŋun ŋula waŋgany ŋarrakuwuynydja mala märr-nhirrpanminya ŋuli ganha bitjanayi.” ");
INSERT INTO djr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bala ŋunhi dhäwumirrnydja yolŋu walal roŋiyinan balayin ŋurikalyin buŋgawa'mirriŋuwala wäŋalil, ga maḻŋ'maraŋalnydja walal ŋunhi djämamirrinhany yolŋuny manymaknha, nhinanan gan ḏäwalan, bilin walŋathinan beŋuryiny ŋunhi rerriŋurnydja. ");
INSERT INTO djr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ga wiripuŋuynydja waluy ŋayi Djesuny ga malthunamirrnydja mala nhanŋu marrtjinan balan wäŋalil yäkulil Nayinlila, ga wiripuwurrnydja yolŋu walal malthurryi marrtjin nhanŋu Djesuw ŋula nhämunha' mala. ");
INSERT INTO djr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wäŋgaŋalnydja walal marrtjin bala-a-a, ga ŋunhiliny wäŋaŋur ṉapuŋgany', bala walal gumurr-bunanhaminan wiripuwurrnha yolŋu walal, gäŋal walal marrtjin yolŋuny rakunynha, dhawaṯmaraŋala rälin beŋura wäŋaŋura. Ga ŋayiny marrtjin miyalktja ŋäthin bala malthurr walalaŋ. Yurr ŋayi ŋunhiyi miyalktja ḻunin buku-gurthapuynha, ga ŋunhiyi ḏirramunhany walal marrtjin dhiŋganhawuynhany gäŋal, ŋurikiyin miyalkkun buku-gurthapuywun waku'mirriŋuny, yurr ŋunhin bili yan waŋganynha nhanŋu ŋunhi waku'mirriŋuny, ga bilin. Ga walalnydja marrtjin dharrwany yolŋu walal malthurryi nhanŋu ŋurikiyi miyalkkuny. ");
INSERT INTO djr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ga ŋunhi nhakun ŋayi Djesuy nhäŋalnydja ŋunhiyi ŋäṉḏi'mirriŋunhany ŋäthinyawuynydja, bala yan ŋayi wuyurra nhanŋu, ga waŋan ŋayi bitjarr, “Way miyalk, yaka ŋäthi!” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bala ŋayi Djesuny marrtjinan bala yan ŋayathaŋala ŋunhi bathin yolŋumirra, ga walalnydja ŋunhi yolŋu walal ŋunhi walal marrtjin gäŋal ŋunhiyi dhiŋganhawuynha yolŋuny gulyurra yan, bala gan dhärra'-dharranan dharraḏan. Bala ŋayi Djesuny dhunupan waŋanan ŋurikiyiny dhiŋganhawuyguny yolŋuw bitjarra, “Way ḏirramu, dhuwal ŋarra nhuŋu dhu waŋan. Go rur'yurra!” ");
INSERT INTO djr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ga dhunupan ŋayi ŋunhiyi dhiŋganhawuynydja ḏirramu rur'yurra, bala ŋayi yan waŋanan. Bala ŋayi Djesuynydja roŋanmaraŋala ŋanya ŋunhiyi ḏirramunhany balayin ŋäṉḏi'mirriŋuwala nhanukalaŋuwal. ");
INSERT INTO djr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ga bukmaknha gan ŋunhi yolŋuny walal märr-maŋmaŋdhurra, bala walal gan wokthurrnydja God-Waŋarrwuny bitjarra gam', “Dhuwandja ŋanapurruŋgal maḻŋ'thurr ŋunhiyin muka God-Waŋarrwun djawarrkmirr.” Ga wiripuwurruynydja gan yolŋuy walal lakaraŋal ŋanya bitjarra, “Dhuwandja ŋayipin God-Waŋarrnha muka yarrupthurr walŋakunharawnha nhanukiyingalaŋawnha ŋayi yolŋu'-yulŋuw!” ");
INSERT INTO djr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ga dhäwuny' gan ŋunhi nhanukalaŋuwuynydja Djesuwalaŋuwuynydja ḻatjuwarr'yurra bukmaklila wäŋalil, ga bukmaknha gan ŋunhi yolŋuny walal lakaranhaminan ŋunhiŋuwuyyiny manymakpuynydja rombuy, ŋunhi nhaltjarr ŋayi gan Djesuy djäma. ");
INSERT INTO djr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yo, ŋayiny ŋunhiyiny yolŋu Djondja gan gulŋiyinan dharruŋguŋura, yurr walalnha gan ŋunhi malthunamirriynha mala nhanukal Djongal lakaraŋalnydja dhäwuny' nhanŋuny Djonguny Djesuwalaŋuwuynydja, nhaltjarr ŋayi gan ŋunhi Djesuy djäma. ");
INSERT INTO djr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bala yan ŋayi Djondhuny djuy'yurra märrma'nhan malthunamirriny maṉḏany nhanŋuwuy ŋayi, ga waŋanany ŋayi gan ŋunhi maṉḏaŋgal bitjarra, “Gatjuy marrtjin maṉḏa balan Djesuwala, ga dhä-birrka'yun nhuma dhu ŋanya bitjan, ‘Yol dhuwal nheny yolŋu? Nheny dhuwal ŋunhiyin yolŋu muka? … ŋunhi God-Waŋarrwuŋun wäwungunhawuy? Ŋany dhika ŋanapurr dhu ga wiripuŋuw yolŋuw galkun?’” Bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bala maṉḏa yan dhunupan marrtjinan, ga dhä-birrka'yurrnydja maṉḏa ŋanya ŋunhi Djesunhany ŋanyapinyan Djonnhan dhäruktja wanaŋguŋal bitjarra, “Yol dhuwal nhe yolŋuny? Nheny dhuwal ŋunhiyi muka God-Waŋarrwuŋ wäwungunhawuy? … ŋunhi ŋanapurr ga dhuwal galkunna gatjpu'yunna nhanŋu? Ŋany yol nhe dhuwal yulŋuny? … Wo dhika ŋanapurr dhu ga baḏak yan galkun ŋula wiripuŋuw yolŋuw?” ");
INSERT INTO djr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ga balanyamirriyyiny waluy ŋayiny gan ŋunhi Djesuynydja ḏukmaraŋala yolŋunhany walalany rerriŋurnydja, ga wiripuwurruŋgalnydja yolŋuwal walalaŋgal ŋayi gan dhawaṯmaraŋal yätjkurrunhan birrimbirrnha mala, ga bulu ŋayi gan yolŋuny walalany maŋutjimirriyaŋal mel-bambaymirriny. Yurr ŋayi gan ŋunhi Djesuynydja djämany ŋula nhäny mala djalkthurr milman ŋurikalyiny maṉḏaŋgal märrma'wala ḏirramuwal, maṉḏany ŋanya gan nhäŋala ŋunhiwiliyiny djämalil. ");
INSERT INTO djr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bala ŋayi Djesuny waŋanan balany buku-roŋanmaraŋal ŋurikalyiny maṉḏaŋgal dhäwu-gänhamirriwalnydja yolŋuwal maṉḏaŋgal, ŋunhi ŋayi Djondhu maṉḏany djuy'yurr nhanukal Djesuwal, ga bitjarra, “Gatjuy roŋiyin maṉḏa ga lakaraŋun nhanukal Djongalnydja ŋunhi bili yan, nhä nhuma nhäŋal ga ŋäkul dhiyal. Bili bambaymirriynydja ga dhuwal nhäman, ga bundhurrnydja ga yolŋu walal marrtjin, ga burrunhdhiya'mirrnydja yolŋu walal gan ḏukthurra, ga buthuru-dhumukmirriynydja ga ŋäman, ga dhiŋganhawuynydja mala yolŋu walal gan walŋathinan, ga ŋurruwuykmirriynydja ga yolŋuy walal märraman manymaktja dhäwu. ");
INSERT INTO djr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ŋunhiyin yolŋu ŋuli ga dhuwal ŋayaŋu-djulŋithirrnydja nhina ŋunhi ŋayi ŋuli gi yakan märr-dhumbal'yurr ŋarraku. Maṉḏa bitjan nhuma dhu ŋunhi lakaramany nhanukal Djongalnydja.” Bitjarra ŋayi Djesu dhäruk-gurrupanminany maṉḏaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bala yan maṉḏa ŋuriŋiyi yolŋuynydja maṉḏa dhäwumirriynydja maṉḏa ganarrthaŋala Djesunhany, ga ŋayiny beŋuryiny Djesuny bilyurra ga waŋan ŋunhi yolŋunhan walalany, lakaraŋala ŋayi gan Djonnhan bitjarra, “Nhäthinya nhuma ŋunhiyiny yolŋuny nhäŋal ŋunhi nhuma marrtjinany nhanukal balayiny nharaŋlilnydja wäŋalil? Nhäthiny ŋayi ŋunhi yulŋuny, balany nhakun gupa-wiyin mulmu gupa-nyaḻwaŋ'thurr gan wäŋiwuŋ boy'yunawuy? ");
INSERT INTO djr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nhäthinyaraw yolŋu nhuma maŋutji-ḏukṯukmirriyinany nhänharawnydja? Nhä ŋayi be yolŋuny girri' manymakmirr ga latju'kunhamirr ŋayi ŋuli ga dhaṯthunmirrnydja? Balanyayiny dhuwal yolŋu walal girri' manymakmirrnydja mala ga wäŋa manymakmirrnydja mala ŋuli ga ŋal'yunmirr ŋunhan buŋgawawala gal'ŋu yindiŋura wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yolku bili nhuma ŋunhi nhänharawnydja marrtjin. Nhä bili ŋayi ŋunhi yolŋuny djawarrkmirr muka? Ŋe yuwalk warray ŋayi ŋunhi djawarrkmirrnydja yolŋu! Ŋarra nhumalaŋ lakaraman, yaka yan ŋayi ŋunhi djawarrkmirrnydja. ");
INSERT INTO djr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ŋunha ŋäthiliŋuŋurnydja djorra'ŋur God-Waŋarryuny ŋanya ŋunhi Djonnhany bitjarr lakaraŋal ŋunhi ŋayi nhanŋu dhäwu-gänhamirr, ga bitjarr ŋayi ŋanya ŋunhi lakaraŋalnydja gam', ‘Ŋurruŋuny ŋathil ŋarra dhu ŋunhi djuy'yun ŋarrakuwuy ŋarra yolŋuny dhäwu-gänhamirriny, ŋayi dhu ŋäthilmirriyaman dhukarrnha yäkthun nhuŋun.’” ");
INSERT INTO djr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ga bulu ŋayi Djesu waŋan bitjarr, “Yo, Djondhuny ga ŋunhi djuḻkmaram nhämunharany' yolŋuny walalany dhiyal munatha'ŋur. Yurr ŋunhiwurrnydja yolŋu walal ŋunhi walal ŋuli ga ŋäman ŋarrany dhäruknha, ga nhinan ŋayi dhu ga God-Waŋarrwala yan romŋur, ŋuriŋiyin dhu yolŋuy djuḻkmaram ŋanyanhany Djonnhany, bäydhi ŋayi ŋunhiyi yolŋu ŋula gali'puynydja, nhä mak wakinŋuny.” Bitjarra ŋayi Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Yo. Ga bukmakthun gan ŋunhi yolŋuynydja walal ŋäkula dhäwuny' ŋunhi ŋayi gan Djondhuny lakaraŋal. Ga walalnydja gan ŋunhi rrupiya-märranhamirriynydja yolŋuy mala, ga wiripuwurruynydja ŋunhi yolŋuy walal gali'puyyuny mala dhäruk-märraŋal warray, bala gan ḻiya-gulinybunhaminan bala gan bilyurra God-Waŋarrwala, ŋunhiwilin dhuwurr-dhunupalila romlil, ga dhunupan yan ŋayiny gan walalany Djondhuny ḻiya-ḻupmaraŋala. ");
INSERT INTO djr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Yurr walalnydja gan ŋunhi ḏilkurruwurruynydja Baratjiynydja mala ga rom-marŋgikunhamirriynydja yolŋuy walal, ŋapay-ŋurrkaŋal ŋunhiyi dhäwu; yaka walal gan djälthin ŋurikiyi romgu ŋunhi ŋayi God-Waŋarryu nhirrpar walalaŋ. Bala ŋayi Djondhuny yakan ganha ḻiya-ḻupmaranhany walalany.” ");
INSERT INTO djr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ga bulu ŋayi Djesuy marŋgikuŋal walalany bitjarr gam', “Ga nhumany ŋunhi dhuwalawurrnydja, dhuwal nhuma ga nhina dhiyaŋ bala, ");
INSERT INTO djr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","balanyan nhumany dhuwal nhakun ŋunhi djamarrkuḻi' ŋunha dhukarrŋur, ŋunhi walal ŋuli ga ŋuyulkthirr, yaka walal ŋuli gi djälthi buḻ'yunaraw. Ga walal wiripuwurr djamarrkuḻi' ŋuli ga waŋa walalaŋ bitjan ŋurukuwurruŋdhi, ‘Nhaku nhuma ga dhuwal djälthirrnydja? Napurrnydja gan buḻ'yurr yiḏakiy ga biḻmay, galŋa-djulŋithinyamaraŋal nhumalany, yurr nhumany yaka warray rur'yunna giritjinyaraw. Ga wiripuny ŋanapurr gan ḏar'ṯaryurr manikay mokuywal bäpurrulil, ŋäthin manapar, ga nhumany yaka warray ŋanapurruŋgal mala-manapanna ga ŋäthinyaminya,’ bitjanna. Nhän nhumany dhuwal yolŋu'-yulŋuny, nhakun ŋunhiwurryin muka djamarrkuḻin'? ");
INSERT INTO djr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ŋunhi ŋayi Djondja bunan dhiyalnydja, ŋayiny ŋuli ganha nhinanha galŋa-yätjinya, ŋoy-ŋathamiriw warray, ga ŋänitji-ḻukanhamiriw, bala nhumany ŋuli ganha lakaranhany ŋanya bitjana warray? ‘Ŋunhany nhanukal ga wakinŋun birrimbirr gulŋiyirr,’ bitjanan. ");
INSERT INTO djr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ga dhäŋur beŋuryiny ŋunhi ŋarrany Yolŋuny Gäthu'mirriŋu marrtjin räli, ga ḻukanany ŋarra gan ŋunhi ŋathany ga gapuny yolŋuwalnydja walalaŋgal, galŋa-djulŋithinany manapar walalaŋ, ga nhumany ŋarranhany ŋuli ga ŋunhi lakaranhamirr bitjanmirra, ‘Nhäŋu walal ŋunha yolŋuny! Ŋunhi ŋatha-dharrwamirriny ga ŋänitji-ḻukanhamirriny! Ga ḻundun ŋayi ŋunha yindin mirithirra ŋurukuwurruŋguny ŋunhi rrupiya-märranhamirriwnydja yolŋuw walalaŋ, ga dhuwurr-djarrpi'mirriwnydja.’ Ga bitjanmirra nhuma ŋuli ga ŋunhi lakaranhamirrnydja, nhakun nhuma ŋuli gi ŋunhiyiny yakan yuwalkkuŋuny djälthi linyalaŋgun, ŋarrakun ga Djongun.” ");
INSERT INTO djr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Yo. Yurr waŋany nhuma ŋuli ga ŋunhi bitjandhiyiny, bili yaka nhuma ŋuli gi ŋunhi yuwalkkuŋuny dharaŋul. Ga ŋunhiyiny yolŋu walal ŋunhi walal ŋuli ga märr-yuwalkthirr God-Waŋarrwuny, walalnydja ŋunhiwurryiny marŋgin ŋunhi ŋayiny God-Waŋarrnydja gaḏaman warray mirithirr, ga marŋgi walal ŋunhi nhanŋuny rom märr-yuwalk warray.” Ga bitjarr ŋayi gan Djesuny waŋan. ");
INSERT INTO djr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wiripuny yolŋu marrtjin Baratjin yäku Djäymannha, bala yan ŋayi Djesunhany garr'yurra wäŋalila nhanukiyingal ŋayi ŋathawnha ḻukanharaw. Bala yan ŋayi Djesuny marrtjinan. ");
INSERT INTO djr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ga ŋunhiliyi bili wäŋaŋur waŋgany miyalk gan nhinan, yurr ŋayi ŋunhiyi miyalktja dhuwurr-yätjkurr galŋa-marramba'mirr balanya; dhayuŋanminya ŋayi ŋuli ganha ŋanyapinya ŋayi ḏirramurruŋgala rrupiyaw. Bala ŋayi ŋuriŋiyi miyalkthuny ŋäkula ŋanya Djesunhany Djäymangala wäŋalilnydja, ga dhunupan yan ŋayi ŋunhi märraŋalnydja buŋgan bäw'nha wiyikan' manymakmirra yan banikin'mirrnydja. ");
INSERT INTO djr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Gärrinany ŋayi ŋunhi miyalktja ga dhärranany ŋayi ḏiltjiŋurnydja nhanukala Garraywala, galkin yänan ḻukuŋura nhanukal. Yurr ŋayi gan ŋunhi dhärranany ŋäthinan manapar ga milkarriny nhanŋu gan ŋunhi djuḻ'yurrnydja balan Djesuwala ḻukulilnydja. Bala ŋayi ŋuriŋiyi miyalkthuny ḻukuny ŋanya Garraynhany mulka'kuŋalnydja marwatthun nhanukiyingal ŋayi, bala ŋayi ŋanya ḻukuny wälkuŋala, bala wiyikan' nhanukal ŋayi rarryurr ḻukulilnydja. ");
INSERT INTO djr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ga ŋunhi ŋayi Djäymandhu nhäŋalnydja ŋanya ŋunhiyi miyalknhany, ŋuriŋiyiny yolŋuy bala'-waṯaŋuynydja, bala ŋayi gan ŋunhi gayulnha waŋanhaminany bitjanminan, “Way! Ŋuli balaŋ ŋayi dhuwal ḏirramu yuwalktja be God-Waŋarrwuŋuny djawarrkmirr, ŋayiny balaŋ yan marŋgithinyan nhanŋu dhiyakuny gay'yi miyalkku ŋunhi ŋayi ga ŋayatham ŋanya, bala ŋayi balaŋ djuy'yunan ŋanya, bili yätjkurra ŋayi dhuwandja miyalk mirithirra.” Ga bitjarra ŋayi gan ŋunhi guyaŋanany murrŋan Djäymandhuny. ");
INSERT INTO djr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Bala ŋayi Djesuny bilyurra ga waŋanany ŋayi Djäymangalnydja bitjarra, “Djäyman, ŋarra nhuŋu lakaraman.” Bala ŋayi Djäymandja waŋanan bitjarra, “Yo Marŋgikunhamirr, go lakaraŋun ŋarraku.” ");
INSERT INTO djr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Bala ŋayi Djesuynydja dhäwun' nhanŋu Djäymanguny lakaraŋal mayali'kurra bitjarra gam', “Waŋganymirrnydja waluy märrmay' ḏirramuy maṉḏa gombuŋal rrupiya waŋganynha ḏirramuny yolŋuny buŋgawany, yurr maṉḏa gan ŋunhi dhukarrarrayurr ŋanya; waŋganydhuny ŋanya dhukarrarrayurr 500 namba rrupiya, ga wiripuŋuynydja ḏirramuy dhukarrarrayurr ŋanya ga 50 namba rrupiya. ");
INSERT INTO djr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yurr maṉḏa gan ŋunhi ŋuriŋiyi ḏirramuynydja maṉḏa bäyŋun rrupiyany ŋayathaŋal ŋula yaŋara'-bakmaranharawnydja gurrupanaraw balany roŋanmaranharawnydja. Bala ŋayipiny ŋuriŋiyi buŋgawaynydja bäy-lakaraŋala maṉḏaŋ bukmakpuynha yan ŋunhiŋuwuyyiny rrupiyapuy. Ga ŋunhiyi ḏirramu maṉḏa märrma', yurr yolnha nhakun gan mirithinany märr-ŋamathin ŋuriki buŋgawawnydja yolŋuw? Ŋunhi yolŋu ŋunhi ŋayi ŋanya ŋäŋ'thurr yindi rrupiya 500, ŋany yol? Ŋunhi ḏirramu ŋunhi ŋayi ŋanya gombuŋal märr nyumukuṉiny' rrupiya, 50 yan?” Ga bitjarr ŋayi Djesuynydja ŋäŋ'thurr ŋanya ŋunhi Baratjinhany yäkuny Djäymannhany. ");
INSERT INTO djr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ga ŋayiny ŋuriŋiyi Baratjiynydja buku-bakmaraŋal nhanŋuny Djesuwnydja bitjarra gam', “Yaka! Ŋunhiyi yolŋu ŋunhi ŋanya ŋayi yindi rrupiya dhukarrarrayurr. Ŋayin nhakun gan ŋunhiyin yolŋu mirithinany märr-ŋamathin ŋurikiny buŋgawawnydja, bili ŋayi nhakun bäy-lakaraŋala nhanŋu ŋunhiŋuwuyyin yindipuynha rrupiyawuy, 5,000-buynha.” “Ma', lakaraŋun ŋarrakal,” bitjarr ŋayiny Djesuny. ");
INSERT INTO djr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bala ŋayi Djesuny dhunupan bilyurra ŋurikalyin miyalkkala, bala ŋayi waŋanan nhanŋu bitjarra, “Djäyman, nhäma nhe ga dhuwal miyalknha? Ŋarrany ŋunhi marrtjin räliny nhokalnydja wäŋalil, nheny bäyŋu warray ŋarraku gurrupana gapu ḻukuwnydja ḻupthunaraw. Ga ŋayin dhiyaŋun gay'yi miyalkthu ḻukuny ŋarrany ḻupmaraŋal milkarriynha nhanukiyingal ŋayi, ga bulu ŋayi ŋarrany mulka'kuŋalnydja muka ḻukuny marwatthuny nhanukiyingal ŋayi. ");
INSERT INTO djr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ga bulu nhe ŋarrany bäyŋu wälkunha ŋunhi ŋarra nhuŋu bunanany, ga ŋayiny ŋarrany dhiyaŋuny gay'yi miyalkthu ḻukuny wälkuŋal märr-wiyin warray, beŋur bili ŋunhi ŋarra bunan dhiyal, ga dhuwal baḏak.” ");
INSERT INTO djr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Limurruŋguny ŋunhi Djuw malawnydja rom balanya gam'. Ŋunhi dhu ŋurruḏawalaŋuny yolŋu buna dhiyalnydja ŋunhi limurruŋgalnydja wäŋaŋur, limurrnydja ŋathil dhu wiyika' rarryun ḻiyalil nhanukal. Ga ŋunhiyiny rom nhakun limurr dhu gumurr-ŋamathirra nhanŋu. Yurr bäyŋu warray nheny rarryuna ŋarrakalnydja ḻiyalil wiyika' ŋunhi ŋarra gärrinany räli. Ga dhiyaŋun ŋunhi miyalkthun ŋarrakal ḻukulilnydja rarryurr buŋgan bäwny'tja. ");
INSERT INTO djr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Dharr guyaŋin. Dhuwal ŋarra dhu lakaraman nhuŋu, Djäyman. Bilin ŋarra nhanŋu ŋunhi dhiyakuny miyalkku dhuwurr-yätjkurrnydja mala bäy-lakaraŋala, ga ŋayiny ŋunhi mirithinan yan ŋarrakuny märr-ŋamathin ŋunhiŋuwuyyiny. Ga nhokalnydja ga dhuwal Djäyman dhuwurr-yätjkurrnydja rom ŋorra yan, yurr bäyŋu nhe gi ŋula nhänhamirr nhunapinya nhe manymakkunhamirr, ga lakaranhamirr nhe gi ŋula ŋäŋ'thurr ŋarrany bäy-lakaranharaw bäyŋu. Nheny ŋuli ga dhuwal bäy-lakaranhawuynydja dhäkay-ŋäma gaŋgan ga yurrnha nhakun nhe ga dhuwal ŋarrakuny gaŋgany märr-ŋamathirr.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja nhanŋu Djäymanguny. ");
INSERT INTO djr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bala ŋayi Djesuny waŋanan ŋurikalyiny miyalkkalnydja bitjarra, “Nhuŋu dhuwurr-yätjkurrnydja dhuwal bilin bäy-lakaranhawuynha ŋarrakuŋuny,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ga walalnydja ŋuriŋiwurruynydja yolŋu'-yulŋuy ŋunhi walal marrtjin nhina'-nhinan galki Djesuwal, ŋäkula walal ŋanya gan, bala waŋanhaminany walal bitjanminan gam', “Yol dhuwal ŋayi yolŋuny? … ŋunhi ŋayi ŋuli ga bäy-lakaramany yätjkurruwnydja malaŋuw?” ");
INSERT INTO djr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Bala ŋayi Djesuny waŋanan bitjarra ŋurikiyiny miyalkkuny, “Bilin nhe dhuwal walŋathinan dhuwalatjarra ŋunhi nhe märr-yuwalkmirriyinan ŋarraku. Gatjuy marrtjin bala yan ŋoy-yal'yunan,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ga yalalan dhäŋur beŋuryiny ŋunhi, bala ŋayi gan Djesuny marrtjinan wäŋakurra malaŋuwurr, ga ŋunhiliyiny mala wäŋaŋur ŋayi gan lakaraŋala manymaknha mala dhäwu ŋunhi Godkalaŋuwuynha rombuy yolŋuwalnydja walalaŋgal. Ga walalnydja ŋunhi 12-tja malthunamirr walal gan malthurryi nhanŋu Djesuw. ");
INSERT INTO djr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ga wiripuny miyalkkurruwurr gan malthurr nhanŋu, ŋunhiwurrnha ŋunhi ŋayi gan ḏukmaraŋal walalany rerriŋura mala, ga wiripuny miyalkkurruwurr gan nhanŋu malthurr ŋunhiwurrnha ŋunhi ŋayi gan walalaŋgal dhawaṯmaraŋal yätjkurrunhan birrimbirrnha mala. Ga dhuwalawurr ŋunhi miyalkkurruwurrnydja yäkuny ŋunhi walal gan malthurrnydja nhanŋu, Meri, wäŋa-Maktalapuy, ŋurikalyiny miyalkkal ŋayi ŋunhi Djesuy dhawaṯmaraŋalnydja 7-nhany yätjkurruny birrimbirrnha ŋäthilnydja, ");
INSERT INTO djr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ga wiripuny yäku miyalk Djawina,* ŋunhi ŋayi miyalktja ḏirramuw yäkuw Djuwitjaw,* ŋunhi ŋayiny ŋunhiyiny ḏirramu ŋurruŋu djämamirr ŋurikin buŋgawawnha yäkuw Yaritkun,* ga wiripuny miyalk yäku Djotjana, ga wiripuwurr gan miyalkkurruwurr malthurryi nhanŋu. Yo. Yurr djämany walal gan ŋunhi malthurrnydja nhanŋu ŋunhi miyalkkurruwurruynydja walalaŋgiyingala rrupiyaynydja guŋga'yurrnydja marrtjin bala ŋanya Djesunhany ga malthunamirrinhany mala nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yo. Ga dharrwan mirithirra gan ŋunhi yolŋuny walal wäŋgaŋal guwatjmarnydja ŋanya Djesunhany wäŋaŋura ga wäŋaŋura bawalamirriŋura yan. Bala ŋayiny Djesuynydja lakaraŋala ŋunhiyin mayali'kurra dhäwuny' walalaŋgal bitjarra gam', ");
INSERT INTO djr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Waŋganydhu ḏirramuy gätni-djämamirriy marrtjin dholkuŋal ŋatha mala maŋutji birrali, ga djalkthurrnydja ŋayi marrtjin ŋunhi ŋathany mala maŋutjiny munatha'lila. Yurr wiripuny ŋunhi maŋutji ŋatha galkirrin ḏällil munatha'lil dhukarrlila, bala yolŋuynydja walal marrtjin ŋunhi dhurrpa'-dhurrparaŋala, ga warrakan' mala gan buṯthurr, bala marrtjin ḻukanan ŋunhi ŋathany mala maŋutjiny, ŋunhi marrtjin ŋorra'-ŋurran ŋunhili dhukarrŋur. ");
INSERT INTO djr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ga wiripuny ŋunhi maŋutji ŋatha galkirrin guṉḏamirrilila munatha'lil, munatha'-ḏaŋawuklila, ga dhunupan yan ŋunhiyi ŋathany dhamany'tjurra, bala ŋayiny waluynha ŋunhi nhäŋal räwakkuŋala, bili ŋunhi munathany' baṉḏanynha gapumiriwnha. ");
INSERT INTO djr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ga wiripuny marrtjin maŋutji birrali galkirrin ḏirriṯirrimirrilila munatha'lil, nhämunha' ŋunhi marrtjin ŋorra'-ŋurran ḏirriṯirri dhakal ŋunhiliyi. Bala maṉḏa ŋunhi ŋutharnydja marrtjin rrambaŋin. Ga ŋuriŋiyi ḏirriṯirriynydja garrpirnha ŋunhiyi birralinhany, bala ŋunhi birraliny warrpam'nha räwakthin. ");
INSERT INTO djr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ga wiripuny maŋutji birrali galkirrin marrtjin manymaklila munatha'lil dhika, ga ŋunhiliyiny maŋutji ŋatha ŋuthar manymakthinan dhika dharrwathinan, 100-nha burumun' waŋga'-waŋganyŋur yaŋara'ŋur.” Bala ŋayi dhawar'maraŋalnydja Djesu waŋan bitjarra, “Buthuru-bitjurrnydja walal manymakkuŋ yan ŋini?” ");
INSERT INTO djr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bala walalnydja ŋuruŋiwurruynydja ŋunhi malthunamirriynydja mala nhanukal Djesuwal dhä-birrka'yurrnydja ŋanya Djesunhany bitjarra gam', “Way Garray, nhä ga dhiyaŋ dhäwuy mayaliny' lakaram?” ");
INSERT INTO djr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ga ŋayiny Djesuny waŋan balany walalaŋguny bitjarra, “Nhumany dhuwal malthunamirrnydja mala ŋarraku, bilin nhumany dhuwal marŋgimirra ŋurukuny ŋunhi Godkalaŋawnydja romgu, ŋurikiyiny ŋunhi djinawa'wuywuny mayaliw', bili God-Waŋarryuny nhumalaŋgal gan ŋunhi bilin dhawaṯmaraŋala. Yurr wiripuwurruŋguny yolŋuw walalaŋ ŋunhi walal yaka gulŋiyinya dhipaliyi romlil God-Waŋarrwal, ŋurikiwurruŋdhin ŋarra dhu ga ŋunhi lakaram mayali'wurrnydja, yurr yaka ŋarra dhu dhawaṯmaramany lakaram walalaŋ. Nhäma warray walal dhu ŋunhi yulŋuny, yurr bäyŋun walal dhu ŋunhi dharaŋandja nhäma; ga ŋäma walal dhu ga, yurr bäyŋun dharaŋanarawnydja ŋänharaw.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Bala ŋayi Djesuynydja lakaraŋal walalaŋgal bitjarra, “Dhuwanna ŋunhi mayaliny' ŋurikiyiny dhäwuw gam'. Ŋathaynydja ŋuriŋiyi burumun'thuny ga mayaliy' maŋutji-lakaram God-Waŋarrwun dhäruk. ");
INSERT INTO djr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ga ŋunhi ŋatha mala maŋutji marrtjin galkirrin dhukarrlilnydja, ŋuriŋiyiny ga maŋutji-lakaram ŋunhiwurrunhan yolŋuny walalany ŋunhi walal ŋuli ŋäma God-Waŋarrwu dhäruk, bala dhunupan ŋayiny ŋuli ŋunhi buŋgawany Mokuy marrtjiny bala yan djaw'yunna ŋayaŋuŋurnydja walalaŋgalaŋaŋur ŋunhiyiny God-Waŋarrwuny dhäwu, märr walal ŋuli ŋunhi bäyŋun märr-yuwalkmirriyiny, ga walŋathiny ŋuriŋiyiny dhärukthuny. ");
INSERT INTO djr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ga ŋunhi wiripuny maŋutji mala galkirrin guṉḏamirrililnydja wäŋalil ŋuriŋiyiny ga ŋathay burumun'thu maŋutji-lakaram ŋunhiwurrunhan yolŋuny mala ŋunhi walal ŋuli nhakun bili ŋäma warray dhäwuny', bala ŋuli yan märraman ŋoy-djulŋithinyaraynha. Yurr yakayi ŋayi ŋuli ŋunhi yuwalkkuŋuny gärri ŋunhawalnydja ŋunhi ŋayaŋulilnydja walalaŋgal djinawa'lilnydja. Yaka walal ŋuli ŋunhi yuwalkkuŋuny märraŋ; gurriri yan walal ŋuli ŋunhi märr-yuwalkmirriyirrnydja. Ga ŋuli nhanŋu dhu ŋunhi mariny maḻŋ'thun, ga ŋayaŋu-miḏikinyamirrnydja rom, yan nhakun ŋanya birrka'yundja, ŋayiny ŋuli ŋunhi dhunupan gulyunna God-Waŋarrwalnydja märr-yuwalkthinyaŋur. ");
INSERT INTO djr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ga wiripuny ŋunhi ŋatha maŋutji galkirrin ḏirriṯirrimirrilila gunbukpukmirrilila munatha'lil, ŋuriŋiyiny ga dhunupamirriyam lakaram ŋunhin yolŋuny, ŋunhi ŋayi ŋuli ŋäma warray God-Waŋarrwu dhäruktja, yurr bitjanna bili ŋayi ŋuli ga ŋunhi ŋurruŋuyamany dhuwalaŋuwuynhan yan munatha'wuynhan ŋula nhäny mala, ga bitjanna bili ŋayi ŋuli ga buku-manguman girrin', dhika nhän, rrupiyan, dharrwan. Yo. Bala ŋuli ga ŋunhi dhiyaŋiyin mala romdhu nyumukuṉiny'kumany God-Waŋarrwuny dhäruk, ga yakan ŋayi dhu ga ŋunhi yolŋuny ŋuthan ŋamathamany; walalnydja ŋunhi balanya nhakun yaŋaran' borumgun burumun'miriwnha. ");
INSERT INTO djr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ga wiripuny mala ŋunhi ŋatha maŋutji galkirrin manymaklila mäniyalila munatha'lil, ga ŋuriŋiyiny ga ŋathay mayali' lakaram ŋunhiwurrunhan yolŋuny walalany ŋunhi walal ŋuli ga ŋäma God-Waŋarrwu dhäruk manymakkuman yan dhika, ga märram walal ŋuli ga yuwalkkum yan ŋanya dhäruk, bala ŋayathaman walal ŋuli ga ŋanya ŋunhi dhäruktja baṯ-bitjanna walalaŋgiyingal ŋayaŋuynydja. Ga nhinany walal ŋuli ga ŋunhi ŋunhiliyin manymakŋura romŋurnydja, ga yan bili-i-i ga borum ŋuli dharrwathirr.” Ga bitjarra ŋayi gan ŋunhi Djesuy rom lakaraŋalnydja, mayaliny' dhawaṯmaraŋal walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ga bulu ŋayi Djesu waŋan bitjarr, “Ŋunhi ŋuli yolŋuy lanhdhirrany dhuŋgur'yun, ga wanhawal ŋayi ŋuli ŋunhi nhirrpandja? Dhurrthurryunna ŋayi ŋuli banikin'thun? … ŋany gungaman ŋayi ŋuli muka ḻoḻuynha? Bäyŋu! Yan ŋayi dhu ŋunhiyi märramany, bala ŋal'maraman garrwarlila, märr dhu yolŋuynydja walal nhäman ŋunhiyi baḏayalany' ŋunhi walal dhu marrtji gärrinyamirrnydja.” ");
INSERT INTO djr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Nhä mala marrtji ŋorra djuḻuḻ'yunawuy, yalalany dhu gi ŋunhi gaykarraŋlila warraŋullila dhawaṯthurra. Ga nhä mala dhiyaŋ bala ga ŋorra ŋapa-dhurrthurryunawuynydja, ŋayiny dhu gi ŋunhiyiny milman maḻŋ'maraŋ yolŋuwal walalaŋgal, bala dhu djarraṯawun'lila dhawaṯmaraŋ.” ");
INSERT INTO djr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Yo. Buthuru-bitjurrnydja walal marrtji ŋamathaŋ yan ga yuwalkkuŋun, bili ŋuli ŋayi ga ŋula yolthu yolŋuy ŋayatham Garraywuŋuny marŋgi-gurrupanawuy, ŋayiny dhu ŋuriŋiyiny yolŋuy märraŋ bulun dharrwan mirithirra bukulil ŋal'maraŋ dhu marrtji. Ga ŋuli nhe ga ŋula yolthu yolŋuy bäyŋuny ŋayathul Garraywuŋ marŋgi-gurrupanawuy, ga ŋuli nhe ga guyaŋanhamirr yanbi nheny marŋgin, ŋayiny dhu gombuman nhuna, bäydhi ŋunhi nyumukuṉiny'tja.” Bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Baḏak yan ŋayi gan ŋunhi Djesuy dhäwuny' walalaŋ lakaraŋal, bala walalnydja nhanŋu ŋunhi ŋäṉḏi'mirriŋuny ga yukuyuku'mirriŋuny mala bunanan, yurr dhärra'-dharranany walal gan ŋunhi ŋunhal banydji yan warraŋul ŋunhili buṉbuŋurnydja, djälthin walal gan ŋunhi Djesuw nhänharaw. Yurr dharrwan gan ŋunhi yolŋuny mala nhinan ḻiw'maraŋal, gungaŋal ŋanya. ");
INSERT INTO djr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Bala ŋayi waŋganydhuny yolŋuy waŋanan ŋanya Djesunhany bitjarra, “Way Garray, ŋunha nhuŋu ŋäṉḏi'mirriŋu ga yukuyuku'mirriŋu walal, dhärra'-dharra walal ga warraŋul. Djälthirr walal ga nhuŋu nhänharaw.” ");
INSERT INTO djr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ga ŋayiny Djesuny waŋan bitjarr walalaŋgal bukmakkal yolŋu'-yulŋuwal, “Ŋarrakuwuynydja dhuwal ŋäṉḏi'mirriŋu ga yukuyuku'mirriŋu walal ŋunhiwurrnha yolŋu walal ŋunhi walal ŋuli ga ŋäman God-Waŋarrwun dhäruk, bala märraman ŋanya,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Waŋganydhuny waluy ŋayipiny ŋunhi Djesuny ga malthunamirrnydja mala nhanŋu ŋal'-ŋalyurra marthaŋaylila, bala ŋayi Djesuny waŋanan walalaŋgal bitjarra, “Go limurr marrtjin ŋunha gali'lila, buḏapthunna dhiyakuny guḻungu,” bitjarr. Bala walal yan dhunupan marrtjinan. ");
INSERT INTO djr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Marrtjinany walal gan ŋunhi bala-a-a, yurr ŋayipiny marrtjin Djesuny ŋunhi yakurrnha ŋorran balanyamirriyyiny ŋunhiliyiny marthaŋayŋurnydja. Ga dhulmuŋura ŋunhilin gandarrŋura bala ŋayiny marrtjin bäy watan yindin bunan, ga bulu ḏowu rur'yurr yindi mirithirr. Bala marrtjin ŋunhi gapuny wapthurra marthaŋaylilnydja; galki balaŋ ŋunhi marthaŋaynydja guḻwuḻyunan. Yurr ŋayiny marrtjin ŋunhi Djesuny baḏak yan ŋorran yakurr. ");
INSERT INTO djr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bala walalnydja ŋunhi malthunamirrnydja mala nhanŋu waṉḏinany, bala yan dhirr'yurra ŋanya. “Way Buŋgawa, Buŋgawa! Go rur'yurra! Galki limurr dhu dhuwal ḻupthunna bala dhiŋgaman!” bitjarr. Bala ŋayiny Djesuny rur'yurrnydja, bala dhunupan waŋanan ŋurikiyi watawnydja ga gapuwnydja bitjarra, “Way bilin gulyurra, dharraḏayin!” Bala yan ŋunhi wäŋiny ga ḏowuny gulyurra, wapurarryinan warrpam'thurra. ");
INSERT INTO djr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ga dhäŋur beŋuryiny ŋunhi, bala ŋayi ŋunhi Djesuny bilyurra, bala ŋayi waŋanany walalaŋguny bitjarra, “Wanha dhika nhumalaŋ märr-nhirrpanminyawuynydja? Nhaku nhuma bäyŋuny ŋarraku märr-yuwalkmirriyinya?” Bala walalnydja ŋunhi malthunamirrnydja mala nhanŋu märr-maŋmaŋdhuna, barrarinan manapar. Bala walal gan mel-nhänhaminan, ga waŋanhaminany walal ŋunhi bitjanminan, “Yol ŋayi dhuwal yuwalktja yolŋu? Ŋunhi ŋayi dhuwal dhäruk-gurrupanmin watawnydja ga ḏowuwnydja ga maṉḏany ŋanya dhuwal dhäruktja märraŋala yan?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Djesuny ga malthunamirrnydja walal nhanŋu wäŋgaŋal beŋurnydja ŋunhi Galaliŋurnydja wäŋaŋur, yurr buḏapthurra walal ŋunhi guḻunguny, balan ŋunha gali'lila ḻaypalila wäŋalil yäkulil Gadaralila. ");
INSERT INTO djr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ga ŋunhi ŋayi gan Djesu marthaŋayŋurnydja wapthurr, ga dhunupan ŋayiny ŋunhi yolŋuynydja ŋanya guwatjmara, wäŋa-ŋunhiŋuwuyyiny, yurr ŋanya gan ŋunhi ŋunhiyiny ḏirramunhany ŋayathaŋal wakinŋuy birrimbirryu malaŋuy. Wiyinnha ŋayi gan ŋunhiyi ḏirramuny nhinan warraŋulnydja girri'miriwnydja, ga yakan ŋayi gan ŋunhi nhinan waŋganyŋurnydja wäŋaŋur nhanukiyingalnydja; ŋany nhinanany ŋayi gan ŋunhala bili yan mathirraŋura, yurr molumirriŋur. ");
INSERT INTO djr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ga ŋunhi ŋayi nhäŋal Djesunhany, bala yan ŋayi yatjurrnydja mirithinan, ga ŋurrkanhaminany ŋayi ŋanyapinya Djesuwala ḻukulilanydja, bala ŋayi waŋanan nhanukal yindiynha rirrakayyuny bitjarra, “Djesu, Gäthu'mirriŋu Ŋurruḏawalaŋuw Waŋarrwu God-Waŋarrwu. Nhaltjanna nhe ŋarrany dhu dhuwal yulŋuny? Buku-djulŋi, yaka ŋarrany dhä-gir'yurrnydja ga ŋula ŋayaŋu-miḏikumulnydja!” ");
INSERT INTO djr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yo. Bitjarryiny ŋayi ŋunhi waŋan, bili ŋayipiny ŋunhi Djesuynydja bilin dhäruktja gurrupanminan ŋurikalyiny yätjkurruwnydja birrimbirrwu dhawaṯthunarawnha nhanukalaŋuŋur ŋurikalyiny ḏirramuwalnydja rumbalŋur. Yo bitjana bili ŋayi ŋuli ganha ŋunhi ŋuriŋiyi birrimbirryuny ŋanya bawa'-gurrupanan yan, bala walalnydja ŋuli yolŋu'-yulŋuynydja ŋanya garrwi'-garrwiyunan ganha rakiy'nha ga djimukuy'nha ḏälyun, ḻuku maṉḏany ḏapmaranha ga goŋ maṉḏany. Yurr ŋayiny ŋuli ganha ŋuriŋiyi yolŋuynydja bakmaranha werunha yan rakiny' ŋunhi ga djimukuny', bala ŋanya ŋayi ŋuli ga ŋuriŋiyi birrimbirryuny gänhan djaw'yunan balan ḏiltjilila, wäŋalil yolŋumiriwlila. ");
INSERT INTO djr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bala ŋayi Djesuynydja dhä-birrka'yurra ŋanya ŋunhiyi ḏirramunhany, “Yol bili nhe dhuwal yäkuny?” bitjarr. Ga ŋayiny lakaranhamin, “Ŋarrany dhuwal yäku dharrwa,” bitjarr, bili dharrwa nhanukal gan ŋunhi wakinŋuny mala birrimbirr gärrin. ");
INSERT INTO djr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bala ŋuriŋiyi birrimbirryuny malaŋuy gan waŋanany ŋanya ŋunhi Djesunhany mirithinan ŋayi dhu yaka walalany, “Djuy'yun balany wäŋalil dhä-gir'yunamirrililnydja.” ");
INSERT INTO djr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ga ŋunhiliyi bukuŋurnydja marrtji ḏäpthurr bikipikin mala dharrwa mirithirr, ḻukan walal marrtjin ŋatha. Bala walal ŋunhi birrimbirrnydja mala waŋanany nhanŋu Djesuwnydja bitjarra, “Way, balan napurruny djuy'yurrnydja ŋunha bikipikiwala mala.” Bala ŋayi yan Djesuny yoraŋal walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bala gan ŋunhi wakinŋuny birrimbirr mala dhawaṯthurra ŋurikalyiny ḏirramuwalnydja, ga gulŋiyinany gan ŋurikiwurruŋgalyin ŋunhi bikipikiwala mala. Bala walalnydja gan ŋunhi bikipikiny mala dhunupan yan gundupuŋala beŋuryiny ŋunhi bukuŋurnydja balan bitjarra, bala walal gan gapulila ḻupthurr, ga dhiŋgaŋalnydja ŋunhi warrpam'thurra yan. ");
INSERT INTO djr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ga walalnydja ŋunhi ŋuriŋiwurruy bikipiki-djämamirriynydja yolŋuy walal gan nhäŋal ŋunhi nhä gan maḻŋ'thurr, bala walal yan waṉḏi'-waṉḏinan roŋiyinan balayin wäŋalil, bala dhäwun' marrtjin lakaraŋal ḻiw'maraŋal. ");
INSERT INTO djr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ga yolŋuny walal gan ŋunhi dharrwan wäŋgaŋal balayiny nhänharawnydja. Ga ŋunhi walal marrtjinany nhanukal Djesuwalnydja, bala walal nhäŋala ŋunhiyiny ḏirramunhany, ŋayi gan nhinanany galkin yänan nhanukal Djesuwala. Yurr girri'mirra ŋayi gan ŋunhi nhinanany, ga ḻiya ḏatjunan ŋamakulin', bilin nhanukal ŋunhi wakinŋuny mala birrimbirr waṉḏinan. Ga nhäŋalnydja ŋanya walal gan ŋunhi, bala dhunupan yan walal ŋunhi barrarinan. ");
INSERT INTO djr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ga walalnydja gan ŋunhi maŋutji marŋgimirriynydja yolŋuy walal lakaraŋal walalaŋgal wiripuwurruŋgala yolŋu'-yulŋuwal, ŋurikalaŋuwuyyin ḏirramuwalaŋuwuynha, ŋunhi nhaltjarr ŋanya Djesuy ḏukmaraŋal. ");
INSERT INTO djr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bala walalnydja gan ŋunhi wäŋa-nininyŋuynydja yolŋuy walal waŋanan ŋanya Djesunhany ŋaŋ'ŋaŋ'thurra beŋuryiny wäŋaŋur, bili walal ŋunhi mirithinan barrarinany. Bala ŋayipiny Djesuny dhunupan marrtjinan, bala wapthurra marthaŋaylila, bala yan ganarrthaŋala ŋunhiyiny wäŋa. ");
INSERT INTO djr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ga yurrnha ŋayi ŋunhi Djesu marrtjinany beŋuryiny wäŋaŋur, ŋayiny ŋathil ŋanya ŋuriŋiyiny ḏirramuy guwatjmar ŋunhi ŋayi nhanukal gan Djesuy wakinŋuny birrimbirrnha dhawaṯmaraŋal, bala ŋayi waŋanan nhanukal bitjarra, “Way, ŋarrany dhuwal djäl ŋarra dhu nhuŋun malthun,” bitjarr. Ga ŋayiny ŋanya Djesuynydja roŋanmaraŋal waŋan bitjarr, ");
INSERT INTO djr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Gatjuy roŋiyi wäŋalil, ga lakaraŋ walalaŋgal biyak, ŋunhi nhaltjarr ŋayi nhuna God-Waŋarryu walŋakuŋal.” Bala ŋayi ŋunhiyiny ḏirramuny bilyurra, ga marrtjinany ŋayi gan ŋunhi ḻiw'maraŋala, lakaraŋalnydja marrtji bukmakkal yolŋuwalnydja walalaŋgal, ŋunhi nhaltjarr ŋayi ŋanya Djesuy walŋakuŋal. ");
INSERT INTO djr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ga ŋunhi ŋayi Djesu roŋiyinany beŋurnydja, ga ŋunhi wiripuŋuŋurnydja gali'ŋur wäŋaŋur. Bala yan ŋunhi yolŋuny walal nhanŋu gumurr-ŋamathinan, bili walal gan ŋunhi galkurr nhanŋu ŋunhiliyiny wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ga waŋgany yolŋu yäku Djäratjtja bunan nhanŋu Djesuwnydja, yurr ŋayi ŋunhi yolŋuny ŋurruḏawalaŋu gapman ŋuriki Djuw malaw buku-ḻuŋ'maranhamirriw buṉbuw. Bala yan ŋayi ŋurrkanhaminany ŋanyapinya ŋayi Djesuwala ḻukulilnydja, bala ŋanya ŋayi gan ŋäŋ'thurra mirithinan yan, “Buku-djulŋi Garray, go marrtji balan wäŋalil ŋarrakal, ");
INSERT INTO djr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bili waŋganynha yan ŋunha ŋarraku gäthu'mirriŋuny miyalktja, ga mirithirra yan ŋayi ga ŋunha rirrikthundja. Yurr ŋayi ŋunha 12-mirr yan dhuŋgarramirrnydja. Ga galki ŋayi dhu ŋunha dhiŋgaman yulŋuny,” bitjarr. Bala ŋayiny yan Djesuny malthurra nhanŋu ŋurikiyi ḏirramuwnydja, ga walalnydja marrtjin wiripuwurrnydja malthurryi maṉḏaŋ dharrwa mirithirr yolŋu walal, yurr walal marrtjin ḏur'-ḏuryunminan bala wäŋgaŋalnydja dhukarrkurrnydja. ");
INSERT INTO djr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ga ŋurikiwurruŋgalyi yolŋuwal walalaŋgal malaŋur waŋgany gan miyalk marrtjin, yurr ŋayi gan ŋunhi rirrikthurrnydja ŋurru-yätjthuny wiyinŋumirra; 12-nha dhuŋgarrany. Ga dharrwamirr ŋayi ŋuli ganha marrtjinya marrŋgitjkal walalaŋgal ḏukmaranharaw, yurr gulkurun. Ga yänan ŋayi gan ŋunhi djalkthurrnydja rrupiyan nhanŋuwuy ŋayi ŋurikiwurruŋgalyiny marrŋgitjkalnydja malaŋuwal. ");
INSERT INTO djr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bala ŋayi marrtjinan ŋapawnha malthurr nhanŋu Djesuwnydja, ga dhunupan ŋayi goŋ-djarryurrnydja, baṯnha ŋayathaŋal girrin' nhanŋu. Bala dhunupan yan nhanŋu ŋuriki miyalkkuny ŋurru-yätjtja gulyurra. ");
INSERT INTO djr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bala yan ŋayi Djesuynydja dhä-birrka'yurra walalany bitjarra, “Way walal, yolthu ŋarrany dhikany ŋayathaŋal?” Ga walalnydja wiripuwurrnydja yolŋu walal bäyŋu'yunmin. Ga ŋayiny Betany waŋan bitjarra, “Way Buŋgawa, dharrwan dhuwal mirithirra yolŋuny walal ŋapa-monygunhamirra ga dhärrany, ḻiw'maraŋala walal nhunanhany,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yurr ŋayiny Djesuny waŋan bitjarra, “Dhikayi waŋganydhu yolŋuy ŋarrany ŋayathaŋal, bili ŋarra dhäkay-ŋäkul ganydjarrny ŋayi dhawaṯthurra ŋarrakalaŋaŋur.” ");
INSERT INTO djr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bala ŋayiny ŋuriŋiyiny miyalkthuny nhäŋal dharaŋar ŋunhi ŋayipiny Djesuny marŋgithin nhanŋu, bala yan ŋayi marrtjin marrmarryurr mirithinan yan dhikan, bala ŋurrkanhaminan ŋanyapinya ŋayi ḻukulila nhanukal Djesuwalnydja. Ga ŋunhiliyin ŋayi ŋunhi lakaranhaminany ŋanyapiny ŋayi milman bukmakkal yolŋuwalnydja walalaŋgal, nhaku ŋayi ŋanya ŋunhi ŋayathaŋal, ga nhaltjarr ŋayi ŋunhi ḏukthurr beŋuryi rerriŋur balanyamirriy bili yan waluy. ");
INSERT INTO djr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Bala ŋayi Djesuny waŋanan nhanŋu ŋurikiyi miyalkkuny bitjarra, “Way gäthu ŋarraku, nheny dhuwal bilin manymakthinan, märr-nhirrpanminyaraynha nhokal. Gatjuynha, marrtjin mägayaynha romdhuny.” ");
INSERT INTO djr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ga ŋayiny gan ŋunhi Djesuny, baḏak yan waŋan, ga ŋayiny bäy dhäwumirrnydja yolŋu beŋurnydja ŋunhi Djäratjkalnydja wäŋaŋur bunanan, bala lakaraŋala nhanukal bitjarra, “Way dhuḏitjnha dhuwal. Gäthu'mirriŋuny nhuŋu ŋunha bilin dhiŋgaŋala. Yakan ŋanya Marŋgikunhamirrinhany ŋuyulkkuŋ.” ");
INSERT INTO djr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bala ŋayiny ŋunhi Djesuynydja ŋäkul, bala ŋayi waŋanan Djäratjkalnydja bitjarra, “Yaka barrari. Märr-nhirrpanmirra yan, bala ŋayiny dhu nhuŋu ŋunha gäthu'mirriŋuny walŋathirra.” ");
INSERT INTO djr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ga marrtjinany walal gan ŋunhi burnha bunan ŋunhiliyin wäŋaŋur Djäratjkala. Bala ŋayi Djesuynydja dharrwanhany yolŋuny walalany gulmaraŋala, ga garr'yurrnydja ŋayi walalanhan Betanhan* ga Djayimnhan* ga Djonnhan, ga ŋunhin maṉḏapin ŋäṉḏi'mirriŋun ga bäpa'mirriŋun ŋurikiyin yothuwnha, bala walal yan gärrinan. ");
INSERT INTO djr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ga ŋunhiliyiny wäŋaŋurnydja bukmaknha gan ŋunhi yolŋuny walal ŋäthinyaminan ŋurikiyiny yothuwnydja. Bala ŋayi Djesuny waŋanan bitjarra, “Yaka walal ŋäthinyamirr. Yaka ŋayi ŋunha rakuny; ŋunha ŋayi ga ŋorra yan yakurr.” ");
INSERT INTO djr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bala walalnydja ŋunhi yolŋuynydja walal warku'yurra ŋanya Djesunhany, bili walalnydja marŋgi ŋunhi ŋayi gan ŋorranany rumbalnydja dharraḏan rakunynha. ");
INSERT INTO djr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yurr ŋayipiny Djesuny galkithinan, bala goŋ-djarryurra baṯnha ŋanya goŋnha, ga bitjarra ŋayi waŋanany, “Way yothu rur'yurra!” ");
INSERT INTO djr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bala yan dhunupan ŋunhi yothuny rur'yurra walŋathinan. Ga dhäŋur beŋuryiny ŋayi Djesuny waŋanan walalaŋ bitjarra, “Ma', gurrupula walal nhanŋu ŋathan, ŋayi dhu ḻukan.” ");
INSERT INTO djr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ga maṉḏany ŋunhi bäpa'mirriŋuny ga ŋäṉḏi'mirriŋuny mirithinan ṉirr'yurr, ŋunhi maṉḏa nhäŋalnydja ŋunhiyi yothunhany walŋathinyawuynydja. Bala ŋayi Djesuynydja maṉḏany waŋanan dhä-mukmaraŋala, yakaŋuwnha lakaranharawnha ŋula yolkalnydja yolŋuwal. ");
INSERT INTO djr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ga waŋganymirrnydja waluy ŋayi Djesuy ḻuŋ'maraŋala nhanŋuwuy ŋayi ŋunhi 12-nhan malthunamirriny walalany, bala ŋayi gan ganydjarrnydja gurrupara walalaŋgal, märr walal dhu ga ŋunhi ŋuriŋiyiny ganydjarryuny nhanukal dhawaṯmaraman ŋunhi wakinŋunhan birrimbirrnha malaŋuny, ga bitjandhi bili walal dhu ga ŋunhi walŋakuman yolŋunhany walalany rerriŋurnydja. ");
INSERT INTO djr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bala ŋayi gan dhunupan djuy'yurra walalany lakaranharawnha God-Waŋarrwalaŋuwuynha rombuy, ga ḏukmaranharaw yolŋuwnha walalaŋ rerrimirriwnha mala. ");
INSERT INTO djr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ga bulu ŋayi waŋan walalaŋgal, “Yaka gäŋu dharpa gaṉdji'yunminyawuy, nhä mak ŋatha, nhä mak ŋula nhä rrupiya, nhä mak bathi rrupiyawuy, ga yaka gäŋu ŋula nhä mala bäythinyawuy girri'. ");
INSERT INTO djr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ga ŋunhi nhuma dhu bunany ŋula wanhaminy wäŋaŋur buṉbu-dharrwamirriŋurnydja, ga ŋuli nhumalaŋ dhu ŋula yol yolŋu wäthundja nhanukiyingalnydja ŋayi wäŋalil, nhumany dhu dhunupan marrtjin, bala nhinan ŋunhiliyin, ga yan bil-i-i ga ganan nhe dhu ŋunhiyi wäŋa. ");
INSERT INTO djr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ga ŋuli ŋayi dhu nhuŋu yolŋu yakany gumurr-ŋamathirr, nheny ganarrthula ŋunhiyiny wäŋa, bala ḏawaṯawayurra munathany' ŋunhiŋuwuyyiny wäŋapuy djalkiriŋurnydja nhokiyingal nhe bala yan marrtjin, märr walal dhu nhänhamirrnydja ŋulatjandhin.” Bitjarr ŋayi gan Djesu waŋanany walalaŋ. Bala walal marrtjinan. ");
INSERT INTO djr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Marrtjinany walal gan ŋunhi wiripuŋulila wäŋalilnydja wiripuŋulila, lakaraŋalnydja marrtjin dhäwuny' yolŋuwalnydja walalaŋgal. Ga bitjarryi bili walal marrtjin ŋunhi yolŋunhany bawalamirrinhany walŋakuŋal. ");
INSERT INTO djr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ga balanyamirriyyi waluy yolŋu gan nhinan buŋgawany yäku Yarit* ŋuriki Galalipuywuny wäŋaw. Bala ŋayi ŋuriŋiyi buŋgawaynydja ŋäkula Djesuwalaŋuwuynydja dhäwu ŋunhi nhä mala ŋayi gan djäma, yurr dharrwathinan nhanukal ŋunhi guyaŋanhawuynydja, bili wiripuwurruynydja gan yolŋuy walal lakaraŋal yanbi ŋunhi Djonnha ŋunhi Ḻiya-ḻupmarahamirra yolŋu walŋathin rakunyŋura. ");
INSERT INTO djr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ga wiripuwurruy gan ŋunhi lakaraŋal yanbi Yilaydjan walalaŋ bunan. Ga walal wiripuwurruy gan yolŋuy walal lakaraŋal, yanbi ŋunhi djawarrkmirra yolŋu baman'ŋuwuynha walŋathin. ");
INSERT INTO djr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ga ŋayipiny ŋunhi buŋgawany Yarittja waŋan bitjarra, “Way Djonnhany ŋunhi yolŋuny ŋarra bili muka gupa-gulkthun rakunynha ŋayi, ga yolnha ŋayi dhikayiny yolŋu, ŋunhi ŋarra ga dhuwal ŋämany nhanukalaŋuwuy dhäwuny mala?” Bala ŋayi gan ŋunhi Yarittja mirithinan yan djälthin nhänharawndja nhanŋu Djesuwnydja. ");
INSERT INTO djr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yo. Bala ŋunhiwurrnydja ŋunhi 12-tja dhäwu-gänhamirrnydja yolŋu walal gan gumurr-roŋiyinan. Bala walal gan Djesuwalnydja lakaraŋala ŋunhi nhaltjarr walal gan djäma. Bala ŋayi Djesuynydja garr'yurra walalany walalawuynhan yan wäŋalil yäkulil Bithdjaydalila. ");
INSERT INTO djr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ga ŋunhi walal yolŋuynydja walal ŋäkul, bala walal ḻarruŋala nhanŋu. Ga ŋayipiny walalaŋ Djesuny gumurr-ŋamathinan, bala ŋayi gan lakaraŋala walalaŋ God-Waŋarrwalaŋuwuynha rombuy, ga bitjarryi bili ŋayi gan ŋunhi walŋakuŋalyi rerrimirrinhany yolŋuny walalany ŋunhiliyiny. ");
INSERT INTO djr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ga ŋunhi ŋayi marrtjin waluny gulŋiyin, bala nhanŋu ŋunhi 12-tja malthunamirrnydja mala marrtjinan, bala walal waŋanan nhanŋu Djesuwnydja bitjarra, “Way! Djuy'yurra dhuwal yolŋunhany walalany, walal dhu marrtjin balan wäŋalila malaŋulil walalaŋgiyingal, ga bäyim walal dhu ŋatha walalaŋguwuy walal maranhuw, ga ŋula walal dhu wäŋa maḻŋ'maram walalaŋguwuy walal ŋorranharaw, bili dhuwandja wäŋa ŋayilpin' yolŋumiriwnha nhämiriwnha.” ");
INSERT INTO djr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ga ŋayiny Djesuny waŋan buku-bakmaraŋal bitjarra, “Nhumapi yan walalany maranhu-gurrupul,” bitjarr. Ga walalnydja ŋunhiwurryiny 12-tja yolŋu walal waŋan bitjarra, “Bäyŋun dhuwal ŋanapurr gi ŋula ŋathany ŋayathul ganany'. Goŋ-waŋgany yan napurr ga dhuwal ŋathany ŋayatham, ga märrma' guya, dhuwanna bili ga bilin. Nheny dhuwal djäl napurruŋ, napurr dhu marrtji ga bäyim ŋunha dharrwa ŋatha, märr napurr dhu maranhu-gurrupan bukmaknha yan walalany?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bili dharrwan ŋunhi mirithirra yolŋuny walal, 5,000-nha ḏirramuwurrnydja, ga miyalkkurruwurrnydja dharrwayi muka yan, ga djamarrkuḻiny'. Bala ŋayi Djesuny waŋanan walalaŋ ŋurikiwurruŋguny ŋunhi malthunamirriwnydja mala nhanukiyingalaŋaw ŋayi bitjarra, “Waŋi walal dhuwali yolŋuny walalany, walal dhu nhinany malaŋura ga malaŋura ga malaŋura,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bala walal marrtjin mala-gulk-gulkmaranhaminan ŋunhi yolŋuny walal malalila malaŋulil, nhinanan walal marrtjin bukmaknha yan. ");
INSERT INTO djr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bala ŋayi beŋuryiny Djesuynydja märraŋala ŋunhi goŋ-waŋganydja ŋatha ga märrmany' guya, bala ŋayi buku-garrwarthinan balan djiwarr'lila, bala ŋayi waŋanan buku-gurrparnydja ŋurikiyi ŋathawnydja God-Waŋarrnhan. Ga bakmaraŋal ŋayi ŋunhiyi ŋathany ga guya, bala marrtjin gurru'-gurrupara malthunamirriwala mala nhanukiyingalaŋuwal ŋayi, ga walalnydja marrtjin ŋunhi gurrupar ŋunhiwurrunhan ŋunhi yolŋunhan walalany. ");
INSERT INTO djr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ga bukmakthun walal marrtjin ŋunhi yolŋuynydja walal ḻukanany, ga yan bili ga maranhin walal warrpam'thurr yan. Bala walalnydja ŋunhi malthunamirriynydja walal marrtjin wapmaraŋala ŋunhi bäythinyawuynydja ŋatha malany ga guyany, ga bäythinyawuyyuny ŋuriŋiyi ŋathay muṉguyyuny dhaŋaŋguŋalnydja 12-nha bathiny. ");
INSERT INTO djr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Waŋganymirrnydja ŋayi gan Djesu bukumirriyaŋala gänan, ga walalnydja nhanŋu ŋunhi malthunamirrnydja mala galki yan ŋunhiliyi. Bala ŋayi walalany dhä-birrka'yurra bitjarra, “Yolnha ŋuli ga ŋunhi yolŋuynydja walal lakaram ŋarranhany?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ga walalnydja waŋan buku-bakmaraŋal bitjarr, “Wiripuwurruynydja ŋuli ga ŋunhi nhuna lakaram yanbi nhe Djonnha, ŋunhi Ḻiya-ḻupmaranhamirra yolŋu;* ga wiripuwurruynydja nhuna ŋuli ga ŋunhi lakaram yanbi nhe Yilaydjan yolŋu; ga wiripuwurruynydja nhuna ŋuli ga dhuwal lakaram bitjanna, yanbi nhe dhuwal be djawarrkmirra yolŋu baman'ŋuwuynha walŋathin dhiŋganhaŋura.” ");
INSERT INTO djr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ga bulu ŋayi dhä-birrka'yurr walalany bitjarr, “Ga nhumany ŋuli ga ŋunhi nhaltjanna guyaŋa, yanbi yolnha ŋarrany yolŋu dhuwal?” Ga ŋayiny Betany buku-bakmaraŋal bitjarra, “Nheny dhuwal ŋunhiyin yolŋu ŋunhi Walŋakunhamirra yäku Maŋutji-dhunupayanhawuynha, God-Waŋarrwuŋun djuy'yunawuy,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bala ŋayi dhäŋur beŋuryiny Djesuynydja waŋanan walalany mirithinan yan ḏälyun dhärukthuny bitjarra, “Yakan nhuma dhu lakaram ŋula yolkalnydja yolŋuwal,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ga dhäŋur beŋurnydja ŋunhi walal nhanŋu ḻundu'mirriŋuny mala bilin marŋgimirra, bala ŋayi Djesuny lakaranhaminan walalaŋgal, “Yolŋuny Gäthu'mirriŋu dhu ŋunhi mirithirra yan dhaŋga-ḏirryun. Walalnydja ŋanya dhu ŋunhi ŋurruŋu djirrikaymirriynydja yolŋuy walal, ga ŋurru-warryunayŋuynydja ŋaḻapaḻmirriy mala, ga rom-marŋgikunhamirriynydja mala; ŋapa-ŋurrkaman bala goŋ-gurrupanna bunharawnha murrkay'kunharawnha. Yurr ḻurrkun' dhu ŋunhi waluny djuḻkthurr, bala ŋayi dhu walŋathin dhiŋganhaŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ga buluyi ŋayi Djesu waŋan bitjarra, “Ŋuli nhe ŋula yol yolŋu djäl ŋarrakuny malthunaraw, nheny dhu monhamirra nhunapinya nhe, bala nhe dhu ḻaw'maraman nhuŋuwuy nhe dharpany mälakmaranhawuynydja bala malthunna ŋarrakun. ");
INSERT INTO djr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ga ŋuli nhe djäl nhe dhu walŋakum dhuwaliyiny ŋunhi walŋanhany nhuŋuwuy nhe, nheny dhu yan baḏatjunna nhuŋuwuy nhe walŋany. Ga ŋuli nhe dhu ŋunhi walŋa gurrupanmirr ŋarrakuny, nheny dhu yan walŋathirra.” ");
INSERT INTO djr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","“Yo, ŋuli ŋayi dhu marrtji ŋunhi ŋula yolthu yolŋuy ḻuŋ'maramany buku-mangumany nhanukiyingallilyamany ŋayi, ŋunhi ŋula nhä malany dhuwalaŋuwuynydja munatha'wuynydja, ŋayiny dhu ŋunhiyiny bäyŋun märram yuwalktja walŋa ŋunhalnydja God-Waŋarrwuŋuny gurrupanawuy. Bala ŋayi dhu ga ŋunhiyiny yolŋu ŋunhalnydja dhärra yalalany goŋ-waŋaran, ŋula nhämiriwnha; bäyŋun ŋayi dhu ga walŋany nhina ŋunhalnydja galkiny God-Waŋarrwalnydja. ");
INSERT INTO djr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yo, ŋuli ŋayi dhu ga ŋula yol yolŋu gorany ŋarrakalnydja yäku-lakaranharay, ga ŋuyulkthirr ŋayi dhu ga ŋarrakuny dhärukku, ga ŋarrany dhu ŋunhi bitjandhi bili yan goriyi nhanŋuny ŋurikiyiny yolŋuw. Yo, yalalaŋumirrnydja ŋarrany dhu ŋunhi Yolŋuny Gäthu'mirriŋu buluyi roŋiyi räli beŋur djiwarr'ŋurnydja, ŋarrakiyingalaŋuwala Bäpa'mirriŋuwal djeŋarrayny'tja manymakthun, ga walalnydja dhu ŋunhi God-Waŋarrwuny dharrpalnydja dhäwu-gänhamirr mala ga malthurryi ŋarraku. Ga balanyamirriyyin ŋarra dhu ŋunhi ḻiya-dhumukthiny yolŋuwnydja walalaŋ, ŋurikiwurruŋguny ŋunhi walal ŋuli ga dhiyaŋ bala ŋarraku ŋathil ŋuyulkthirr.” ");
INSERT INTO djr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Märr-yuwalknha ŋarra nhumalaŋ ga dhuwal lakaramany. Wiripuny nhuma, ŋunhi nhuma ga dhärra dhiyal malaŋur, nhumany boŋguŋ bäyŋu dhiŋguŋ yänayiny, ŋany bäy ŋathil nhuma dhu boŋguŋ nhäŋu God-Waŋarrwu latju' dhika ŋunhi rom, manymak mirithirr.” Bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ga wiripuŋuynha munhay waŋgany Djandi djuḻkthurr, bala ŋayi Djesuynydja gaḏaymara nhanŋuwuy ŋayi ḻundu'mirriŋunhany walalany ḻurrkun'nhany, Betanhany* ga Djayimnhany* ga Djonnhany, bala walal marrtjinan bukulila wäŋalil bukumirriyanharawnha. ");
INSERT INTO djr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ga ŋunhi ŋayi gan Djesu bukumirriyaŋalnydja, bala nhanŋu ŋunhi bukuny manymakthinan dhika wiripuŋuyinan, ga girriny' ŋunhi nhanŋu, mirithinan watharrthin dhika, djeŋarra'yinan. ");
INSERT INTO djr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Ga balanyamirriy bili yan, bala maṉḏany märrmany' yolŋu maṉḏa Mawtjitjtja* ga Yilaydjany* maḻŋ'thurra, yurr djiwarr'puyyu ŋunhi baḏayalayny'tja ga djeŋarrayny'tja maṉḏa maḻŋ'thurr, bala maṉḏa gan ŋunhi dhärranany galkin yänan nhanukal Djesuwala, ga lakaranhaminany walal gan ŋunhi ŋunhiŋuwuynha walupuynydja ŋunhi ŋayi dhu dhiŋguŋun ŋunhala Djurutjalamnha wäŋaŋur, ga ŋuliwiyakiyin boŋguŋ ŋunhi nhanukalaŋuwurra dhiŋganhawurrnydja warrpam'nha dhu dhawar'yurra nhäny mala ŋunhi ŋayi nhanŋu ŋäthil God-Waŋarryu nhirrpar. ");
INSERT INTO djr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ga walal Betany, Djayimdja ga Djondja ŋorranan walal gan yakurrnha. Ga ŋunhi walal bira'yurrnydja bala walal nhäŋala ŋanya Djesunhany wiripuŋuyinyawuynha rumbalnydja, dhärranany ŋayi gan dhika djeŋarran' wapthurra galumanyaŋnha, ga bitjarryi bili walal nhäŋalyi ŋunhi märrma'nhany yolŋunhany maṉḏany, maṉḏa gan dhärranany galkin yänan nhanukala Djesuwala. ");
INSERT INTO djr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ga yuṯa muka balaŋ maṉḏa bitjana ganarrthanhan ŋanya Djesunhany, bala ŋayiny Betany waŋanan nhanukal Djesuwalnydja bitjarra, “Way Garray! Manymaknha dhuwaliyiny, ŋunhi napurrnydja nhakun dhuwal dhiyal dhiyaŋuny bala. Napurrnydja dhu dhuwal ḻurrkun'nha warrawny'tja djäma, waŋganydja nhuŋuwuy, ga waŋganydja Mawtjitjku, ga waŋganydja Yilaydjaw.” Ga bitjarra ŋayi gan ŋunhi Betany waŋan, yurr waŋanany ŋayi gan ŋunhi guyaŋanharaynydja dharaŋanamiriwyun. ");
INSERT INTO djr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ga ŋunhi ŋayi gan baḏak yan Betany waŋan, bala ŋayiny yan dhunupan molnydja maŋan maḻŋ'thurra bala yan dhurrthurryurra walalany, ga walalnydja ŋunhi ḻundu'mirriŋuny mala nhanŋu Djesuwnydja ŋayaŋuny barrarinan mirithinan. ");
INSERT INTO djr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ga beŋuryiny ŋunhi maŋanŋurnydja rirrakaynydja gan dhawaṯthurr waŋanany bitjarra, “Dhuwaliyin ŋunhi ŋarrakuwuynydja Gäthu'mirriŋu, ga ŋarrakiyinguŋdhi yan ŋayi dhuwali gänaŋ'maranhawuynydja. Buthuru-bitjurra walal nhanŋu, bala yan märraŋun ŋanya walal gi dhäruktja.” Ga bitjarra ŋayi gan ŋunhi God-Waŋarrnydja waŋan walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ga dhäŋur beŋuryiny ŋunhi ŋayi rirrakaynydja winya'yurr, bala ŋayipin gan waŋganynha Djesun yan dhärranany ŋunhiliyiny walalaŋgal. Ga walalnydja ŋuriŋiwurruynydja ḻundu'mirriŋuynydja walal nhanukal gan ŋayathaŋalnydja ŋayaŋuynha yänan, gayulnha walalawuynha. Yakan walal balanyamirriyyiny lakaranha ŋula yolkalnydja ŋunhi nhä walal gan nhäŋal, nhaltjarr gan maḻŋ'thurr ŋunhiliyi bukuŋur. ");
INSERT INTO djr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ga wiripuŋuynydja waluy walalnydja ŋunhi Djesuny ga ḻundu'mirriŋu walal nhanŋu ŋunhi ḻurrkun' marrtjin yarru'-yarrupthurra beŋurnydja bukuŋurnydja, bala ŋunhi dharrwan yolŋuny walal gumurr-waṉḏinany nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ga ŋayiny waŋganydja ḏirramu beŋuryiny malaŋur waŋan yatjurra Djesuwalnydja bitjarra, “Marŋgikunhamirr buku-djulŋi, walŋakuŋ ŋarraku dhuwal ḏirramuny gäthu'mirriŋuny. Nhäŋu ŋathil ŋanya ŋunha, ya ŋunha, ŋunhan bili ŋarraku waŋganynha yan yothuny walkurnydja. ");
INSERT INTO djr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wiripuny ŋanya ŋuli ga dhuwal yätjkurr birrimbirryu mokuywal ŋayathaman, bala ŋayi ŋuli ŋunhiyi yothuny ga yatjundja mirithirra, bala ŋayi ŋuli ŋanya ŋurrkamany munatha'lila, bala nhanukal ŋuli ga dhurrwarakurrnydja nhakun ŋälnydja-waṉḏirra. Bitjanna bili ŋayi ŋuli ga dhuwal buman yan rerrikmaraman, ga bäyŋu ŋanya ŋayi ŋuli ŋula ganarrthulnydja. ");
INSERT INTO djr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ga waŋan ŋarra dhuwal ŋunhi malthunamirrinhany mala dhiyakiyi wakinŋuw birrimbirrwu dhawaṯmaranharaw, ga walalany gan ŋunhi birrka'yurr dhawaṯmaraŋal gulkurun.” ");
INSERT INTO djr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Bala ŋayi Djesuny waŋanan, “Nhä bili nhuma dhuwal? … märr-yuwalkthinyamiriwnydja mala? Baḏak yan nhuma ga dhuwal guyaŋany djarrpi'kum yan muka? Nhämunha'mirra ŋarra nhumalaŋ dhu dhiyalnydja nhina, galkundja nhumalaŋ? Nhäthan nhuma dhu märr-yuwalkthirrnydja?” Bala ŋayi Djesuny waŋanan ŋurikiyi bäpa'mirriŋuwnydja bitjarra, “Go gäŋun ŋanya rälin ŋarrakala dhuwaliyi gäthu'mirriŋunhany nhuŋuwuy nhe.” ");
INSERT INTO djr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ga ŋunhi ŋayi ŋanya gan bäpa'mirriŋuynydja gäŋal Djesuwalnydja, bala dhunupan ŋayiny ŋunhi ŋuriŋiyiny wakinŋuynydja birrimbirryu ŋurrkaŋala ŋunhiyi yothunhany balan munatha'lila, bala ŋayi gan ḏur'yunminan, ga dhäkurrnydja marrtjin ŋunhi ŋälnydja waṉḏinan. Bala yan ŋayi Djesuny dhunupan waŋanan dhawaṯmaraŋala ŋunhiyiny wakinŋunhany birrimbirrnha beŋuryiny yothuwalnydja. Ga dhunupan yan ŋayi ŋunhi yothuny walŋathinan, bala ŋanya ŋayi Djesuynydja gurrupara ŋunhiyiny yothunhany roŋanmaraŋala bäpa'mirriŋuwala goŋlil. ");
INSERT INTO djr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ga walalnydja gan ŋunhi yolŋuynydja walal nhäŋalnydja ganyim'thurra dhika mirithinan ŋunhi God-Waŋarrwuny ganydjarr yindiny. Ga walalnydja gan ŋunhi yolŋu'-yulŋuynydja baḏaknha guyaŋan, märr-maŋmaŋdhurra manapar, ŋurikiyin Djesuwnha manymakkun djämaw. Bala ŋayi Djesuny bilyurra, ga waŋan ŋayi nhanŋuwuy ŋayi malthunamirrinhan walalany bitjarra, ");
INSERT INTO djr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Buthuru-bitjurrnydja walal ŋamathaŋun yan dhiyakuny dhärukku ŋunhi ŋarra dhu lakaram, ga galkurra nhokiyingal nhe ḻiyalila. Waluny dhuwal galkin, ŋunhi walal dhu Gäthu'mirriŋunhany Yolŋuny goŋ-gurrupanna ŋurikiwurruŋgalnha ŋunhi yolŋuwala walalaŋgal ganydjarrlil,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yurr walalnydja nhanukal ŋunhi ḻundu'mirriŋuynydja walal yaka warray dharaŋana ŋunhiyi dhäruk, ŋunhi nhaltjarr ŋayi gan lakaraŋal walalaŋgal. Bili mayaliny' gan ŋunhi ŋorran djuḻuḻ'yurra; bäyŋun walal dharaŋana. Ga bäyŋun walal ŋanya ŋunhi dhä-birrka'yunany, bili walal gan ŋunhi rum'rumdhurra nhanŋu waŋanharawnydja. ");
INSERT INTO djr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ga dhäŋur beŋuryiny ŋunhi, walalnydja gan ŋunhi ḻundu'mirriŋuny mala nhanŋu Djesuwnydja waŋanhaminan dhä-ḏälthinyaminan, yol ŋunhi mirithirrnydja gal'ŋu ŋurruŋu ŋunhili walalaŋgal malaŋur. ");
INSERT INTO djr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Bala ŋayi Djesuny marŋgithinan yan walalaŋ nhaltjarr walal gan ŋunhi waŋanhamin, ga märraŋal ŋayi yothuny ḻaw'maraŋal, bala nhirrpara ŋanya nhanukiyingala ŋayi gali'lil. ");
INSERT INTO djr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ga dhunupan yan ŋayi ŋunhi waŋanan walalaŋgal bitjarra, “Ŋuli dhu ga ŋunhi ŋula yol yolŋu gumurr-ŋamathirr nyumukuṉiny'kuny yothuw balanyarawnydja nhakun dhuwal gay'yi, ŋarrakalnydja yäkuy, ŋunhiyiny nhakun ŋayi ga bitjandhi bili yan gumurr-ŋamathirryi ŋarrakuny; ga ŋuli ŋayi dhu ga ŋula yol yolŋu gumurr-ŋamathirr ŋarrakuny, ŋunhiyiny ŋayi ga bitjandhi bili yan gumurr-ŋamathirryi nhanŋuny ŋurikiyiny ŋunhi ŋayi ŋarrany djuy'yurr räli. Ga ŋunhi ŋayi dhu ga yolŋu nyilŋ'maranhamirrnydja, ga nyumukuṉiny'kunhamirrnydja ŋanyapinya ŋayi, ŋayiny dhu ŋunhiyin yolŋu yuwalktja ŋurruŋu.” ");
INSERT INTO djr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bala ŋayi Djondja waŋanan bitjarra, “Way Garray, ŋunha ŋanapurr yolŋuny nhäŋal, ŋayi gan dhawaṯmaraŋal wakinŋuny birrimbirrnha mala nhokal yäkuy. Ga ŋanapurrnydja ŋanya waŋan ḏaḏawmaraŋal, bili ŋayi ŋunhi yaka napurruŋgal malaŋur.” ");
INSERT INTO djr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ga ŋayiny Djesuny buku-bakmaraŋal waŋan walalaŋguny bitjarra, “Ganarrthul walal ŋanya, bäy ŋayi dhu ga djäma; yaka ŋanya ḏaḏawmaraŋ. Ŋunhiny yolŋu ŋunhi ŋayi ŋuli gi bäyŋu ṉuŋgaṯmaraŋ nhumalany, ŋunhiyiny yolŋu nhumalaŋgala gali'ŋur; guŋga'yunamirra nhumalaŋ.” ");
INSERT INTO djr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yo, waluny marrtjin ŋunhi djuḻkthurra, ga nhanŋuny walu Djesuwnydja marrtjin galkithinan ŋunhi ŋayi dhu God-Waŋarryuny ŋanya märraman balan djiwarr'lila. Bala yan ŋayi Djesuny ḻiya-ŋamaŋamayunminan, bala yan ŋayi marrtjinan balan Djurutjalamlila. ");
INSERT INTO djr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bala yan ŋayi djuy'yurr märrman'nha dhäwumirriny maṉḏany, maṉḏa dhu ŋäthilmirriyaman wäŋan nhanŋu Djesuwnha. Ga marrtjin maṉḏa ga bunan maṉḏa waŋganyŋur wäŋaŋur yäkuŋur Djamariyan ŋarakaŋur wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ga ŋunhiliyi wäŋaŋur yolŋuny walal ŋunhi yakan ganha djälthinya nhanŋu Djesuwnydja, bili walal marŋgithin nhanŋu ŋunhi ŋayi ḻiya-ŋamaŋamayunminan ŋayi dhu marrtjin balan Djurutjalamlila. ");
INSERT INTO djr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bäyŋun nhanŋu walal ŋunhi gumurr-ŋamathinyany, yänan walal ŋanya gan ŋunhi ḻikandhu ŋurrkaŋala, bala maṉḏany ŋunhi Djondja* ga Djayimdja mirithinan yan maḏakarritjthinany walalaŋ, bala maṉḏa waŋanan bitjarra Djesuwnydja, “Way Garray, nhämirr balaŋ linyu dhu wäthun gurthawnha ŋayi dhu rälin yarrupthun djiwarr'ŋurnydja, bala dhu bathanna dhuwal yolŋunhany walalany warrpam'thunna yan? Balanyarawnydja nhe ŋula djäl muka?” ");
INSERT INTO djr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ga dhunupan ŋayiny Djesuny bilyurrnydja, bala ḏaḏawmaraŋala maṉḏany bitjarra, “Yaka maṉḏa biyakiyi! Dhuwaliyiny yätjkurr,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Bala walal ganarrthaŋala ŋunhiyiny wäŋa, bala marrtjinan wiripuŋulila wäŋalil. ");
INSERT INTO djr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ga ŋunhi walal marrtjin Djesu ga ḻundu'mirriŋu mala wäŋgaŋalnydja bala dhukarrkurrnydja Djurutjalamlila, ga ŋunhiliyi gandarrŋurnydja bala ŋayi waŋganydhuny yolŋuy waŋanan ŋanya Djesunhany bitjarra, “Way Garray, ŋarrany dhuwal djälnha malthunarawnha nhuŋu, ŋunhi ŋula nhäkurr nhe dhu marrtji.” ");
INSERT INTO djr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ga ŋayiny Djesuny nhanŋu buku-bakmaraŋal waŋan bitjarr, “Ḏäl dhuwal yolŋuwnydja malthunaraw ŋarrakuny. Ŋunha wakinŋuwnydja warrakan'ku ga, wäŋa ŋarŋga' dhärra, wäŋamirr walal ŋunhi warrpam', ga buṯthunamirriwnydja warrakan'ku mala marrtji yalu' gorru'-gurrum. Yurr ŋarrakuwuynydja Yolŋuwnydja Gäthu'mirriŋuw bäyŋu ŋula wäŋa ŋorranharaw.” ");
INSERT INTO djr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ga bala ŋayi Djesu waŋan ŋunhi wiripuŋuw yolŋuw bitjarr, “Go malthurra ŋarrakun.” Yurr ŋayiny ŋunhi yolŋuny waŋan bitjarr, “Bulnha ŋathil, ga bäy ŋarraku dhu bäpa'mirriŋu dhiŋgam ga dholkuŋ ŋarra ŋanya dhu, ga dhäŋur beŋuryin ŋarra dhu malthurrnydja nhuŋu.” ");
INSERT INTO djr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ga ŋayiny Djesuny waŋan buku-bakmaraŋal nhanŋuny bitjarra, “Ŋuriŋiwurruynha yolŋuy walal dhu ga dholkum dhiŋganhawuynhany yolŋuny walalany, ŋunhi walal ga nhina dhiŋganhamirriŋura yan romŋur. Nheny dhu marrtjin, ga dhäwun' lakaram birrŋ'maraman yolŋuwala walalaŋgal, ŋunhi God-Waŋarrwalaŋuwuynha rombuy.” ");
INSERT INTO djr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ga wiripu yolŋu ḏirramu waŋan Djesuw bitjarr, “Garray, ŋarrany dhu dhuwal malthunna nhuŋun. Yurr ŋurruŋuny ŋathil ŋarra dhu balayi roŋiyirryi, ga waŋa ŋarra dhu walalany ŋunha ŋunhi gurruṯumirriny ŋarrakuwuy ŋarra, nhäma marrtji ŋarra dhu walalany, ga yurrnha ŋarra dhu malthundja nhuŋu.” ");
INSERT INTO djr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ga ŋayiny Djesuny waŋan nhanŋuny bitjarr, “Ŋuli ŋayi dhu yolŋuy ŋurruyirr'yun munathany' marrtji baw'maram, buḻŋu'kumany dhu marrtji bala, ŋayiny ŋathil dhu ŋurruŋuny nhäma bäkumirriyam, dhunupayam wanhawal ŋayi dhu ga ŋunhi marrtji. Ga ŋuli ŋayi dhu marrtji ŋunhi ḏawa'-ḏawa'yundja, roŋiyirryi marrtji nhäma balayi dhuḏitjthuny, balanyayiny yolŋu yakan nhakun gana' nhinanharaw ŋurukuny ŋunhi God-Waŋarrwalaŋuwnydja romgu.” Bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ga dhäŋur beŋuryiny ŋayi Djesuy gänaŋ'maraŋal wiripuwurrunhany ḏirramuwurruny, 72-ny ŋunhi malanhany, bala ŋayi gan djuy'yurr walalany märrma'-märrma'nhan. Bala walal nhakun ŋurruŋuny wäŋgaŋal bawalamirrilil yan wäŋalilnydja malaŋulil, ga yalalany dhä-dhuḏitjtja ŋayipin marrtjin Djesun. ");
INSERT INTO djr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ga yurrnha walal ŋunhi marrtjinany, ŋurruŋuny ŋathil ŋayi walalaŋ waŋan bitjarr gam', “Dharrwan mirithirra ga dhuwal yolŋuny mala nhina, gatjpu'yunna ga, galkunna ga Godkalaŋawnydja romgu. Ga balanyan walal ŋunhi yolŋuny walal nhakun ŋunhi borumnha mala, ḻami-borumnha, galki borumdhirra marrtji, galkundja walal ga gulkmaranharawnha, yurr märr ḻurrkun' dhika yolŋuny mala djämamirrnydja gulkthunarawnydja ŋurikiny borumguny, waŋgany-manapanarawnydja. Yänan biyakun bukumirriyaŋun, ŋäŋ'thurr God-Waŋarrnhan, märr ŋayi dhu djuy'yundja dharrwanhan yolŋuny walalany djämamirrinhany ŋurukuwurruŋdhiny ḻuŋ'maranharawnydja.” ");
INSERT INTO djr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Gatjuy nhumany marrtjin!” bitjarra ŋayi Djesuny waŋan walalaŋ. “Ŋarrany nhumalany dhu dhuwal djuy'yunna dhäwu-gänhamirra mala. Yurr wiripuwurrnydja yolŋu walal nhumalaŋ dhu ŋunhi maḏakarritjthirra, bitjanna nhakun ŋuli wakinŋu wuŋgan wärraŋ ŋayan'mirr ga dhärra boḏinymirriw warrakan'ku malaŋuw. ");
INSERT INTO djr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yo. Yurr yakan gi gäŋu ŋunhi bathiny nhuŋuwuy nhe rrupiyawuynydja, nhä mak wiripuny dhapathuŋ' nhuŋuwuy nhe ŋula. Ga yaka gandarrŋur gulmaraŋ ŋula yolŋuny, ga walu ḻuki, ŋunhi nhuma dhu gumurr-bunanhamirrnydja dhukarrŋurnydja. ");
INSERT INTO djr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ga ŋunhi nhe dhu bunany ŋunhiliyiny wäŋaŋur, ga gärri nhe dhu ŋula yolkal bala'lil, bala waŋiny biyakun, ‘Way walal! Märraŋun walal ŋoy-yal'yunamirrnydja rom God-Waŋarrwuŋuny!’ biyakun. ");
INSERT INTO djr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ga ŋuli ŋayi dhu ŋula yol yolŋu djälthirr ŋurikiyi ŋunhi Godkalaŋawnydja mägayawnydja romgu, bala ŋayiny dhu yänan märraman nhokuŋ. Ga ŋuli ŋayi gi ŋula yolŋu-yulŋu yakany djälthi ŋurikiyi romgu, ŋayiny dhu yakan märram ŋunhiyiny God-Waŋarrwuny mägayamirrnydja rom. ");
INSERT INTO djr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yo. Nhinany nhuma dhu ga ŋunhi ŋunhili bili yan waŋganyŋur bala'ŋurnydja, ga nyaŋ'thurr bawalamirr ŋunhi nha walal dhu nhuna gurrupan. Bili nhumany dhu ga ŋunhi djämamirriynydja walal märramdhi nhumalaŋgiyingalaŋuwuy djämapuynydja. Yaka gi marrtji ḻiw'maraŋuny bala'kurrnydja malaŋuwurr; nhininy gi waŋganyŋur yan dharapulŋur.” ");
INSERT INTO djr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Yo. Ŋunhi nhuma dhu buniny boŋguŋ ŋula wanhaminy wäŋaŋur, ga ŋuli walal dhu yolŋuny walal nhumalaŋ gumurr-ŋamathirrnydja bala gurrupanna nhumalany ŋathany, nhumany yänan ḻukin ŋunhi ŋula nhä malany nhumalany walal dhu gurrupan. ");
INSERT INTO djr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bala dhunupan walŋakuŋun rerrimirrinhany mala yolŋu'-yulŋuny wäŋa-ŋunhiŋuwuynhany mala, ga lakaraŋuny walalaŋgal biyakun, ‘God-Waŋarrwuny rom dhuwal dhiyaŋuny bala dhuwanna galkin. Nhininy walal nhanukala romŋurnydja.’ ");
INSERT INTO djr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ga ŋuli nhuma dhu ŋula wanhami wäŋaŋur buna, ga ŋuli walal dhu bäyŋuny nhumalaŋ gumurr-ŋamathirr, nhakun bäyŋun walal dhu djälthirr nhumalaŋgalaŋaw dhäwuw'nha, nhumany dhu yan rur'yunna, bala dhärrany dhukarrŋura, ga waŋiny walalaŋgal biyakun gam', ");
INSERT INTO djr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Linyuny dhu dhuwal gananna dhuwandja wäŋa, djalk-djalkthunna linyu ga dhuwal munathany' dhuwalaŋuwuynydja wäŋapuy ḻukuŋurnydja linyalaŋgiyingal linyu. Yurr guyaŋiny walal gi dhuwanna gam'. God-Waŋarrwuny dhuwal rom bilin galkithinan nhumalaŋgala.’” ");
INSERT INTO djr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Ga dhuwanna ŋunhi gam' ŋarra dhu lakaraman nhumalaŋgal; yalalaŋumirriynydja ŋunhi mala-djarr'yunamirriynydja waluy Godthuny boŋguŋ ŋunhi dhä-gir'yurra wäŋa Djudumbuynhany yolŋuny walalany yurr märr gaŋgan yan. Yurr mirithiny ŋayi dhu ŋunhi dhä-gir'yurr wäŋa dhuwalaŋuwuyyin yolŋuny walalany.” Ga bitjarra ŋayi gan Djesuy lakaraŋalnydja walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yo. Ga bulu ŋayi Djesu waŋan bitjarr, “Buthuru-bitjurrnydja walal ŋarraku manymakkuŋun yan, ga ŋäku walal nhumany yolŋu'-yulŋuy wäŋa Guratjinbuyyuny* ga Bithdjaydawuyyuny.* Yindin mirithirra nhumalaŋguny dhu mari maḻŋ'thurr. Bili muka nhuma gan ŋunhi nhäŋal ganydjarrnydja ŋarraku, ŋunhi ŋarra gan djäma ŋuriŋiyi ŋoy-ganyim'thunamirriy romdhu ŋunhiliny nhumalaŋgalnydja wäŋaŋur, yurr bäyŋu warray nhumany ganarrthanha ga ḏiltji-bilyuna nhumalaŋgiyingalaŋuŋur yätjkurruŋurnydja romŋur, bala bilyunan. Ga ŋunhi balaŋ ŋarra ganha djäma dhuwaliyi ŋayaŋu-ganyim'thunamirr rom ŋunhalnydja ŋunhi Däyany* wäŋaŋur ga Djäydandja, bitjana bili nhakun ŋarra gan ŋunhi dhiyaliyi djäma, ga walalnydja balaŋ ŋunhi wäŋa-ŋunhiŋuwuyyiny yolŋu walal bilyunan yätjkurruyŋurnydja romŋur mala, ga nhinanha walal balaŋ ganha ŋamathanhan. ");
INSERT INTO djr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yo. Ga ŋayiny dhu ŋunhi God-Waŋarryuny dhä-gir'yurr ŋunhayiny yolŋuny walalany wäŋa-Däyapuynhany ga wäŋa-Djäydanpuynhany märr gaŋgan yan, ga nhumalanhany ŋayi dhu dhä-gir'yurr mirithin yan balanyamirriynydja waluy ŋunhi mala-djarr'yunamirriynydja. ");
INSERT INTO djr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ga nhumany ŋunhi wäŋa-Gapuniyambuyyuny yolŋuy walal ga nhaltjanna guyaŋa? … garrwarkunhamirra nhumalanhawuynha nhuma ga balan djiwarr'lila? Yurr ŋayipiny dhu ŋunhi God-Waŋarryuny boŋguŋ ŋurrkuŋun nhumalany balan biyakun burralkulila.” ");
INSERT INTO djr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ga wiripuny ŋayi Djesuy lakaraŋal nhanukalaŋuwal ŋayi malthunamirriwal walalaŋgal bitjarr, “Ŋuli ŋayi dhu ga ŋula buthuru-bitjundja nhumalaŋgalaŋaw dhäwuwny'tja manymakkumany, ga märramany ŋayi dhu ga ŋunhiyiny dhäruktja ŋarranhany. Ga ŋuli ŋayi yolŋu bäyŋuny ga nhumalaŋgalaŋaw dhäwuw buthuru-bitjun, gänaŋ'maranhamirra ŋanyapinya ŋayi ga nhumalaŋgalaŋaŋur, ga ŋarrakalaŋuŋurnydja ŋayi ga ŋunhi bitjandhi bili yan yarrkmaranhamirryi. Ga bitjandhi bili ŋayi ga ŋunhi yarrkmaranhamirra ŋanyapinyan ŋayi God-Waŋarrwala, ŋurikala ŋunhi ŋayi ŋarrany djuy'yurr räli dhipal.” Ga bitjarra ŋayi gan ŋunhi Djesu dhäruk-gurrupanminany ŋanyapinya ŋayi walalaŋgalnydja ŋurikiwurruŋgalnydja ŋunhi 72-walnydja ḏirramuwurruŋgal. Bala walal yan wäŋgaŋalnha barrkuwatjthinan. ");
INSERT INTO djr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ga ŋunhi walal ŋunhiwurryiny ŋunhi 72-ny ḏirramuwurr roŋiyinany Djesuwalnydja, yurr walal ŋunhi mirithinan dhika goŋmirriyinany, bala walal gan ŋunhi lakaraŋalnydja bitjarra, “Way Garray! Ŋanapurrnydja gan dhuwal waŋan dhawaṯmaraŋal ŋunhi wakinŋunhany birrimbirrnha malany nhokala yäkuy, bala walalnydja gan ŋunhi dhunupan yan dhäruktja napurruny märraŋala, bala gan yan dhawaṯthurra yolŋuwalnydja walalaŋgal!” ");
INSERT INTO djr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Bala ŋayiny Djesuny waŋanan yoraŋala yan walalaŋ, “Yo, manymak!” bitjarra. “Bili ŋarrapiny ŋunhi nhäŋalyi Djaytinnhany, ŋayi marrtjin dhur'-dhuryurra beŋurnydja djiwarr'ŋurnydja rälin, bala ŋayi ŋunhi galkirrinany gut bitjarryi, bitjan nhakun ŋuli marrtji ŋunhi ganyu ḻarryun munatha'lil. ");
INSERT INTO djr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ŋäkuny walal ŋamathaŋun. Bilin ŋarra dhuwal ganydjarrnydja nhumalaŋgal gurrupara, bala nhumany dhu marrtji ŋunhi dhurrpa'-dhurrparaman bäpinhany mala ga buthuŋunhany. Ga djuḻkmaraman nhuma dhu ŋunhi ganydjarr ŋurikiny miriŋuwnydja nhumalaŋgalaŋaw Djaytinguny, yakan ŋayi dhu ŋunhi nhumalanhany bumany dhiŋganhamaramany nhä mak ḏaw'maramany, bili nhanŋuny ŋunhi ganydjarr bilin bakthunawuynha. ");
INSERT INTO djr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yo. Yuwalk warray walalnydja nhumalany dhu ga ŋunhi yätjkurruynydja birrimbirryu mala dhäruktja nhumalany märram, yurr yaka walal ŋuriŋiyiny galŋa-goŋmirriyi. Dhiyaŋun yan waŋganydhun gämurruy' nhuma dhu ŋunhi galŋa-goŋmirriynydja ŋunhi nhuma bilin yäkuny ga dhärran ŋunhany djiwarr'ŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ga balanyamirriyyiny nhanŋu ŋunhi Djesuwnydja ŋayaŋuny dhaŋaŋdhinan Dhuyu-Birrimbirryuny, mirithinan ŋayi ŋunhi goŋmirriyinany, bala ŋayi waŋanany bitjarra, “Bäpa, nheny Garray ŋuruk djiwarr'puywu wäŋaw, ga dhiyak munathaw'. Bäpa, ŋarrany nhuna dhuwal buku-gurrpara mirithinan yan, bili nhe maḻŋ'maraŋala warraŋulkuŋala nhuŋuwuy nhe romdja dhiyakuwurruŋgala ŋunhi märr-dhuŋamirriwala yolŋuwalnydja walalaŋgal, ŋunhiyin rom mala ŋunhi nhe gan djuḻuḻ'maraŋal be djambatjmirrwal ga marŋgimirriwal yolŋuwal walalaŋgal. Yo. Mäḻu' nheny ŋunhi milkunhaminany nhunapinya nhe dhiyakuwurruŋgala ŋunhi märr-dhuŋamirriwala, bili dhuwaliyin nhuŋu ŋunhi ŋayaŋuny.” ");
INSERT INTO djr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Yo. Bäpaynydja ŋarrakal ŋunhi dhayuŋar bukmaknha yan romdja malany ŋarrakala goŋlilnydja. Bäyŋun ŋunhi ŋula yol marŋgi Yolŋuwnydja Gäthu'mirriŋuw, yol ŋayi ŋunhi; ŋayipin yan ŋunhi Bäpan yan nhanŋu marŋginy. Ga balanyayi bili, bäyŋuyi yan dhuwal ŋula yol yolŋu marŋgi God-Waŋarrwuny Bäpawnydja, yol ŋayi ŋunhi; ŋarrapin yan dhuwal Gäthu'mirriŋun nhanŋu marŋginy mirithirr Bäpawnydja, ga ŋunhiwurrnha dhu yolŋuny walal marŋgithirr nhanŋu, ŋunhi ŋayin dhu Gäthu'mirriŋuynha warralkum ŋanya walalaŋgal, ŋurikiwurruŋgalnydja ŋunhi ŋarra walalaŋ ga djälthirr.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bala ŋayi beŋuryiny Djesuny bilyurra, bala waŋanan nhanŋuwuy ŋayi malthunamirrinhany walalany, gänan walalawuynha ŋapa, ga bitjarra ŋayi ŋunhi waŋanany gam', “Nhumany dhuwalawurrnydja yolŋu walal goŋmirra God-Waŋarrwalnydja, bili nhakun nhuma ga nhäman dharaŋana nhanŋu romdja mala.” ");
INSERT INTO djr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Märr-yuwalk ŋarra nhumalaŋ ga dhuwal lakaramany walal. “Ŋäthil baman' dharrwa mirithirr djawarrkmirr yolŋu walal, ga buŋgawa mala yolŋu walal gan djälthin nhänharaw dhiyakiyi mala, dhuwal nhuman ga nhäma dhiyaŋun bala, bili bäyŋu walalnydja ŋunhi nhänha. Ga mirithin yan walal gan ŋunhi djälthin ŋänharawnydja dhiyakuny dhäwuw, ŋunhi nhuman ga ŋäma dhiyaŋun bala, bili walalnydja gan ŋunhi bäyŋu balanyayi dhäwu mala ŋäkul.” Ga bitjarra ŋayi gan Djesuy lakaraŋalnydja walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Waŋganydhuny waluy rom-marŋgikunhamirr yolŋu marrtjin, bala ŋayi dhä-birrka'yurra ŋanya Djesunhan, yan nhakun ŋayi ŋanya gan birrka'yurr bitjarr, “Way Garray, nhaltjan dhika ŋarra dhu yulŋuny, märr ŋarra dhu ga walŋany yan nhina wiyinŋumirrnydja?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Bala ŋayiny Djesuynydja dhä-birrka'yurr balany ŋanyanhany bitjarra, “Nhä? Bili nhaltjan ga ŋunhi dhuyuŋurnydja djorrany' waŋa? Nhaltjan nheny ŋuli ga ŋunhi maḻŋ'maram ŋunhiyiny dhäruk?” ");
INSERT INTO djr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bala ŋayi ŋunhi yolŋuny waŋan bitjarra, “Ŋunha djorrayny'tja ga ŋunhi lakaram bitjan gam', ‘Märr-ŋamathirrnydja nhe dhu ga nhokiyingalaŋaw nhe Garraywuny God-Waŋarrwuny bukmakthu yan nhokiyingal nhe ŋayaŋuynydja ga walŋaynydja ga ganydjarryuny ga guyaŋanhawuyyuny, ga wiripuny nhe dhu ga ŋunhi märr-ŋamathirr yolŋuw walalaŋ wiripuwurruŋ, biyak yan bili nhakun nhe ŋuli ga ŋunhi märr-ŋamathirr nhuŋuwuy nhe. Biyakun guyaŋiny ŋunhiwurruny wiripuwurrunhany mulkurunhany yolŋuny walalany, nhakun walal nhuŋun galkipuynha yolŋu walal.’” ");
INSERT INTO djr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Yo, yuwalk dhuwaliyiny. Ŋuli nhe dhu ga ŋunhi bitjandhiyiny djäma, nheny dhu ga walŋan yan nhina.” Ga bitjarr ŋayiny Djesuny waŋan. ");
INSERT INTO djr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bala yan ŋayi ŋunhi rom-marŋgikunhamirrnydja yolŋu djälthinany mirithinan yan ŋayi dhu wiripuwurruŋgalnydja maŋutjiŋur dhuwurr-ŋamathirra. Ga bulu ŋayi dhä-birrka'yurr ŋanya Djesuny bitjarr, “Yol bili dhika ŋarraku galkipuynydja yolŋu?” ");
INSERT INTO djr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bala ŋayi Djesuynydja lakaraŋala nhanŋuny ŋurikiyi rom-marŋgikunhamirriwnydja yolŋuw mayali'kurra dhäwuny' bitjarrnha gam', “Waŋganydhuny waluy yolŋu gan marrtjin dhukarr-ŋupar beŋur Djurutjalamŋur* bala Djarikawlil wäŋalil, yurr Djuw mala ŋayi ŋunhi yolŋuny. Yo. Marrtjinany ŋayi gan ŋunhiyi dhukarr-ŋuparnydja, bala walalnydja ŋunhi ŋuriŋiwurruynydja manaŋa-ḏilkurruynydja yolŋuy walal ŋayathaŋala ŋanya, bumarnydja ŋanya walal gan ŋunhi-i-i, batnha ŋurrkaŋal, bala walal nhanŋu djaw'-djawyurra rrupiyany, ga girriny' walal gan ḻarrmaraŋala nhanukal, bala ganarrthaŋala ŋanya. Ga ŋorranany ŋayi gan ŋunhi gali'ŋura dhukarrŋurnydja, galki balaŋ ŋayi ŋunhi dhiŋganhan. ");
INSERT INTO djr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yaka wiyin, bala ŋayiny gan djirrikaymirrnydja yolŋu marrtjinan ŋuliwitjarryi bili yan dhukarrkurr. Ga nhäŋal ŋayi ŋunhiyi yolŋuny gaṯpurr'nhany, ŋayi gan ŋorranan, ga gilipuŋala ŋayi nhanŋu, djuḻkmaraŋal ŋanya, yaka ŋayi ŋanya guŋga'yunna. ");
INSERT INTO djr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ga yaka wiyin, ga wiripuny muka yolŋu marrtjin ŋunhi Lebaywalnydja yarraṯaŋur, ga ŋayiny ŋunhiyiny yolŋu Godkalaŋawnha buṉbu-djägamirra ga marrtjinany ŋayi ŋunhiyi yolŋuny galkikurra nhanukalaŋuwurr, bala ŋanya ŋayi nhäŋala ŋunhiyi gaṯpurr'nhany yolŋuny, ga yakayi ŋayiny ŋanya guŋga'yunna, nhäŋala ŋayi ŋanya ganarrthaŋala.” ");
INSERT INTO djr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ga bulu wiripuny muka yolŋu marrtjin, ga ŋayiny ŋunhiyiny yolŋu wiripuŋuwuynha wäŋapuy, wiripun bäpurru Djamariyapuynha. Bala ŋayi ŋanya nhäŋala ŋunhiyiny gaṯpurr'nhany ŋayi gan ŋorran, bala nhanŋu ŋayaŋuny-warwumirriyinan dhika mirithinan. ");
INSERT INTO djr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Bala ŋayi marrtjinan galkithinan nhanukal, ga rarryurr ŋayi nhanukal wiyikan' djetjilil malaŋulil, ga garrpi'yura ŋayi ŋanya marrtjin ŋunhi djetjiny mala manydjarrkay'nha, bala ŋayi ŋal'maraŋala ŋanya yarraman'lil nhanukiyingalnha ŋayi, bala yan dhunupan gäŋala ŋanya. Marrtjinan maṉḏa gan, ga yan bili ga bunan maṉḏa ŋunhili bala'ŋur ŋunhi walal ŋuli ganha dharrwa yolŋu walal ŋorranha buṉbuŋur. Ga ŋunhiliyin ŋayi ŋunhiyi Djamariyawuynydja yolŋu gan djägany nhanŋu ŋurikiyiny ŋunhi gaṯpurr'wuny ḏirramuw. ");
INSERT INTO djr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ga wiripuŋuynydja munhay ŋayi waŋan ŋanyanhan ŋunhin buṉbu-waṯaŋunhan yolŋuny bitjarra, ‘Ŋay', dhuwal rrupiyany märrma' ŋaraka. Gatjuy djägan nhe dhu ga dhiyakiyiny yolŋuw, ga ŋuli dhu dhuwaliyi rrupiya yakany gana'yirr nhokal, ga räliyi ŋarra dhu boŋguŋ roŋiyi, ga bulu ŋarra dhu gurrupul nhuna wuŋuḻi'yurr.’” Ga bitjarryin ŋayi gan ŋunhi Djesuy dhäwuny' lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Bala ŋayi Djesuny waŋanan ŋurikiyiny yolŋuw rom-marŋgikunhamirriwnydja bitjarrnha, “Yo, nhaltjanna nheny ga guyaŋa? Yolnha nhanŋu ŋunhi yolŋuthinany ŋurikiyiny yolŋuw ŋunhi walal gan manaŋa-ḏilkurruy bumar?” ");
INSERT INTO djr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Bala ŋayiny ŋunhi rom-marŋgikunhamirrnydja yolŋu buku-bakmaraŋala nhanŋu Djesuwnydja bitjarra, “Mak ŋunhiyi bäy, ŋunhi ŋayi wuyurr nhanŋu, bala guŋga'yurra ŋanya.” Bala ŋayiny Djesuny nhanŋu waŋan bitjarra, “Gatjuynha nheny dhu marrtjin, ga djämany nhe dhu bitjandhi bili yan, dhuwali bili yan romdja waŋgany.” ");
INSERT INTO djr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Dhäŋur beŋuryiny bala ŋayi Djesuny ga ḻundu'mirriŋuny walal nhanŋu marrtjin wäŋgaŋala, ga bunanany walal ŋunhala wäŋaŋur yäkuŋur Bithinin,* bala ŋayiny waŋganydhuny miyalkthu yäkuy Mäthaynydja gaḏaymara ŋanya Djesunhany nhanukiyingala ŋayi wäŋalil. ");
INSERT INTO djr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Bala ŋayi gärrinan, dhutnha nhinan, ga ŋayiny Mäthawnydja yapa'mirriŋu Meriny yäku marrtjin, ga nhinan galkin yan nhanukal Garraywala ḻukuŋur. Nhinanany ŋayi gan ŋunhi Meriny, buthuru-bitjurra gan nhanŋun Djesuwnha, ŋunhi ŋayi gan marŋgikuŋal dhäwu lakaraŋal ŋunhiliyi djinawa' buṉbuŋur. ");
INSERT INTO djr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ga ŋayiny gan Mäthaynydja gänan djäma ŋayipin, yurr dharrwathinan nhanukal ŋunhi gumurrŋurnydja djämany mala, bala yan ŋayi ŋoy-dhärranan, bala ŋayi waŋanan Djesuwalnydja, “Way Garray, yaka nhe gi dhuwal guyaŋi ŋarranhany? Dhuwal ŋayi yukuyuku'mirriŋuynydja ŋarrakal ganarrthaŋala djämany warrpam'nha ŋarrakiyingala yan. Waŋi ŋanya, ŋayi dhu guŋga'yun ŋarrany.” ");
INSERT INTO djr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bala ŋayi Djesuny waŋan nhanŋuny buku-bakmaraŋal yäku-lakaraŋala ŋanya bitjarra, “Mätha! Mätha!” bitjarr. “Nheny ga dhuwal ḻay-ḻayyun dharrway romdhu malaŋuy, ga dhiyakiyin mala nhe ga ŋunhi mirithirrnydja warwuyun, ga yurrnha nhakun nhe ga dhuwali ŋayaŋu-miḏikirrnydja. ");
INSERT INTO djr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yurr waŋgany yan dhuwal manymaktja ga ŋurruŋuny rom ŋula yolkuny yolŋuw, ga ŋayiny dhiyaŋuny gay'yi Meriynydja bilin djarr'yurra ŋunhi ŋamakurrnydja rom, ga yakan dhu ŋunhi ŋula yolthuny yolŋuy dhuwaliyi djaw'yundja nhanukal.” Ga bitjarra ŋayi gan ŋunhi Djesuny waŋan. ");
INSERT INTO djr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Waŋganydhuny waluy ŋayiny gan Djesuny bukumirriyaŋala ŋula wanhamin wäŋaŋur, ga ŋunhi ŋayi dhawar'yurrnydja bukumirriyanhaŋurnydja, bala ŋayiny waŋganydja malthunamirr nhanŋu waŋan bitjarra, “Way Garray, Djondhuny gan ŋunhi marŋgikuŋal nhanŋuwuynydja ŋayi malthunamirriny walalany ŋunhi nhaltjan walal dhu ga bukumirriyam. Ga nheny dhu napurrunhany marŋgikumdhi, ŋunhi nhaltjan napurr dhu ga bukumirriyam?” ");
INSERT INTO djr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ga ŋayiny Djesuny waŋan walalaŋguny bitjarra, “Ŋuli nhuma dhu bukumirriyamany ga, bitjanna nhuma dhu ŋunhi waŋany gam', ‘God-Waŋarr Mäḻu' ŋanapurruŋ, nheny ŋunhi yäku yindi warray, ga wokthunamirr. Ŋanapurr nhuna ga dhuwal ŋäŋ'thundja nhe dhu dhanuŋdhunna God-Waŋarrwuny rom ŋanapurruŋgala ŋayaŋulilnydja. ");
INSERT INTO djr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ŋathany ŋanapurruny maranhu-gurrupula dhiyakuny bala waluw. ");
INSERT INTO djr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bäy-lakaraŋ ŋanapurruŋ yätjkurruwuynydja djämapuy, biyak yan bili nhakun napurr ŋuli ga bäy-lakaram ŋurikiwurruŋ ŋunhi wiripuwurruŋ yolŋuw walalaŋ ŋunhi walal ŋuli ga ŋanapurruny ŋayaŋu-yätjam. Yaka ŋanapurruny gäŋu gumurr-ḏälkurrnydja romgurr, birrka'yurrnydja ŋanapurruny ga mala-djarr'yurrnydja. Ga bitjanna nhuma dhu ŋunhi bukumirriyamany.’” ");
INSERT INTO djr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ga bulu ŋayi Djesu waŋan nhanukiyingalaŋaw ŋayi malthunamirriw walalaŋ bitjarr, “Ŋuli balaŋ nhe dhu ŋunhi ŋula yol yolŋu marrtji nhokiyingalaŋuwal nhe ḻundu'mirriŋuwalnydja wäŋalil, ŋunhi ŋula nhaliynydja waluy mak djeḏany, ga ŋäŋ'thun nhe dhu ŋanya ŋula nhaku ŋathaw bitjan, ‘Way ḻundu marrkapmirr, ŋatha ŋarrany gurrupul go, ");
INSERT INTO djr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","bili ḻundu'mirriŋu ŋarraku ŋunha bunan beŋur barrkuŋur wäŋaŋur, ga ŋarrapiny dhuwal dhäparŋ'nha, ŋathamiriwnha.’ ");
INSERT INTO djr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ga ŋunhi ŋayi dhu ḻundu'mirriŋuny nhuŋu waŋa buku-bakmaram bitjandja, ‘Gatjuy waṉḏin, yaka ŋarrany yakurr dhirr'yurr! Dhurrwarany dhuwal bilin ḏälnha dhaḻ'yunawuynha, ga bulu napurr dhuwal yakurr yindin ga ŋorra, napurr djamarrkuḻi' ŋarraku ga ŋarrapi. Yakan ŋarra dhu rur'yun nhuŋu ŋula nhakuny gurrupanaraw.’ Ga bitjanna ŋayiny dhu ŋunhi ḻundu'mirriŋuny nhuŋu buku-bakmaram. ");
INSERT INTO djr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mak ŋayi dhu ŋunhi yakan djälthirr nhuŋu guŋga'yunaraw, ga gurrupan ŋayi nhuna dhu ŋula nhäny bäyŋun, bäydhi ŋayi ŋunhi galkipuynydja ḻundu'mirriŋu. Yurr rur'yun yan ŋayi dhu ŋunhiyiny yolŋu, bala ŋayi dhu gurrupanna nhuŋu ŋunhi nhaku nhe ga djälthirr, bili nheny dhu ga ŋunhi buku-ḏuwaṯthunna ŋäŋ'thun. ");
INSERT INTO djr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Walal, dhuwandja ŋarra nhumalaŋ dhu lakaraman. Ŋäŋ'thurr God-Waŋarrnhany ŋula nhakuny, märr ŋayi dhu nhuna gurrupanna yan. Gatjuy ḻarruŋun, bala nheny dhu maḻŋ'maraman. Ga dhurrwarany wutthu'-wutthurra, galkithin nhanukal, märr ŋayi dhu God-Waŋarryuny nhuŋu dhurrwarany ḻapmaraman, gumurr-ŋamathirra manapan nhuŋu. ");
INSERT INTO djr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bili ŋuli balaŋ dhu ŋula yolthu walal ŋäŋ'thundja ŋanya God-Waŋarrnhany, bala walalnydja dhu ŋunhi yänan märraman nhanukuŋuny, ga ŋunhiny yolŋu ŋunhi ŋayi ŋuli ga yuwalkkumany yan ḻarrum, ŋayiny dhu God-Waŋarrwuŋuny maḻŋ'maraman yan. Ga wiripuny ŋunhi yolŋu ŋunhi ŋayi ŋuli ga bitjan bili dhurrwara wutthu'-wutthun, ga galkithirr nhanukal, ŋayiny dhu God-Waŋarryuny nhanŋu ḻapmaraman, galkikuman manapan ŋanya nhanukiyingala ŋayi. ");
INSERT INTO djr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nhuma ŋunhi bäpa'mirriŋu walal, ŋunhi nhumalany ŋuli gäthu'mirriŋuynydja walal nhumalaŋgal ŋäŋ'thun guyawnydja, ga nhän nhumany ŋuli gurrupan walalaŋguny … bäpin? Ŋany nhä? ");
INSERT INTO djr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ga ŋuli ŋayi dhu nhuna yothuy nhokal ŋäŋ'thun mapuwny'tja, ga nheny dhu nhän nhanŋuny gurrupan? … buthuŋun? ");
INSERT INTO djr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yurr bäydhi nhuma ŋunhi dhuwurr-yätjkurrnydja bäpa'mirriŋu walal, yurr nhuma ŋuli ga ŋunhi gurrupandja nhumalaŋgalaŋaw gäthu'mirriŋuwnydja walalaŋ manymak yan nhäny mala. Ga nhumalaŋguny Bäpa'mirriŋu djiwarr'puynydja bulu warray wetj-ḏumurr, djuḻkmaraman ŋayi ga nhumalanhany nhanukiyingalnydja ŋayi wetjthu. Ga yuwalk yan ŋayi dhu ŋunhi gurrupandja ŋunhi Dhuyu-Birrimbirrnhany ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi walal dhu ga ŋäŋ'thundja ŋanya.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yo. Waŋgany yolŋu gan nhinan dhärukmiriw muŋmuŋ, yakan ŋayi ŋuli ganha ŋunhi waŋanhany, bili wakinŋuy birrimbirryu ŋanya gan ŋunhi ŋayathaŋalnydja dhärukmiriwyaŋalnydja. Yurr ŋayiny gan ŋunhi Djesuynydja ŋunhiyi birrimbirrnhany mala dhawaṯmaraŋala ŋurikalyiny ḏirramuwal, ga dhunupan ŋayi ŋunhiyi ḏirramuny dhärukmirriyinan, waŋanan gan dhika manymakkuŋala. Bala walalnydja ŋunhi yolŋuynydja walal gan ŋäkulnydja ŋanya ganyim'thurra waŋanhawuynydja. ");
INSERT INTO djr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ga walalnydja gan ŋunhi wiripuwurrnydja yolŋu walal waŋanhaminan lakaranhaminan bitjanminan, Ŋunhiny ŋayi gan ŋurikalyin Beltjibulwala ganydjarryu dhawaṯmaraŋal ŋunhiyiny wakinŋumirrinhany birrimbirrnha mala, ŋunhi ŋayi buŋgawan walalaŋ ŋurikiyin ŋunhi birrimbirrwun malaŋuw. ");
INSERT INTO djr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ga wiripuwurruy yolŋuy walal birrka'yurr ŋanya, yan walal gan maḻŋ'maraŋal nhanukal waŋan bitjarr, “Way, ŋuli nhe gi dhuwal God-Waŋarrwalnydja ganydjarryu djäma, gatjuy mak bulu nhe dhu djäma ŋuriŋiyi ŋoy-ganyim'thunamirriy romdhu märr napurr dhu nhäma.” ");
INSERT INTO djr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yurr ŋayipiny ŋunhi Djesuny marŋgithin walalaŋ, ŋunhi nhaltjarr walal gan guyaŋan djarrpi'kuŋal, bala ŋayi waŋanan walalaŋ bitjarra, “Nhalayak balaŋ ŋunhi mokuywalnydja ganydjarryu dhawaṯmaraŋ ŋunhi mokuynhany birrimbirrnha? Ŋuli dhu ga ŋunhi yolŋu walal mala-wulkmaranhamirrnydja waŋganyŋurnydja wäŋaŋur, bala walal dhu ga bunhamirra bala räli'yunmirra, bala dhu ŋunhi malany walal dhawar'yunna. Ga ŋuli dhu ga gurruṯumirr mala bitjandhi bili yan barrkuwatjkunhamirr, bala dhu ga bunhamirra nhakun, ŋunhiyiny walal dhu malany dhawar'yunna yan warrpam'nha. ");
INSERT INTO djr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ga ŋuli ŋayi dhu ga ŋunhi djaytindhu buma djaytinnhany yan, nhanŋuny dhu ŋunhi romdja dhawar'yunna, winya'yunna dhu. Ga nhumany ŋuli ga ŋunhi bitjan lakaram yanbi ŋarrany ŋuli gi ŋunhi dhawaṯmaraŋ ŋunha wakinŋunhany mala birrimbirrnha ŋurikalyin ganydjarryuny Beltjibulwalnha? ");
INSERT INTO djr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ga nhämirr ŋunhi nhumalaŋguwuynydja malthunamirr walal? Yolkal walalnydja ŋuli ga ŋunhi ganydjarryu bitjandhiyi djäma? Ŋurikalyi bili yan yätjkurruwal? Ŋany bäyŋu, muka? Yo. Ŋuriŋiwurruy bili yan nhumalaŋgal yan malthunamirriy walal ŋuli ga ŋunhi nhumalanhany yätjkurr-lakaram. ");
INSERT INTO djr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yo. Ŋarrany ŋuli ga dhuwal dhawaṯmaram ŋunhi wakinŋunhany birrimbirrnha mala ŋuriŋi bili yan waŋganydhu, God-Waŋarrwal yan ganydjarryuny, ga dhuwalatjandhin nhuma dhu ŋunhi dharaŋandja, ŋunhi God-Waŋarrwuny rom bilin maḻŋ'thurra dhiyalnydja nhumalaŋgalnydja.” ");
INSERT INTO djr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Yo. Ŋunhi ŋayi yolŋu ganydjarr-ḏumurrnydja, ŋayiny dhu ga dhärran girri'-ŋamathinyawuynha, goŋ-garamirra, ḏälnha, djägan ŋayi dhu wäŋawnydja nhanukiyingalaŋaw ŋayi ga girriwny'tja manymakkuman, ga yakan dhu ŋunhi nhanukalaŋuŋur ŋula djaw'yun yolthuny. ");
INSERT INTO djr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ga ŋunhiyi ḏirramu ganydjarr-ḏumurrnydja ŋunhi ŋayi ŋuli ga märr-yuwalkthirr, ga märr-nhirrpanmirr ŋurikiyin bili yan maripuywun girriw' nhanukiyingalaŋaw ŋayi. Ga ŋuli ŋayi dhu ŋunhi wiripu yolŋu marrtji bulun gal'ŋu ganydjarr-ḏumurr, ḏälnha mirithirra, bala ŋayi dhu buman ŋunhi wiripuŋunhany yolŋuny, ŋunhi ŋayi ŋuli ga guyaŋanhamirr ŋanyapinya ŋayi yanbi ŋayi ganydjarr-ḏumurra. Ŋayiny ŋanya dhu wiripuŋuynydja yolŋuy djuḻkmaraman, bala nhanŋu dhu ŋunhi girriny' mala maripuynydja djaw'-djawyunna, bukmaknha. Djaw'yunna ŋayi dhu ŋunhi girriny' mala nhanŋu, bala mala-wulkmaraman marrtji, bala dhu gurrupanna marrtji wiripuwurruŋgun yolŋuw walalaŋ.” ");
INSERT INTO djr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ga ŋuli ŋayi ŋula yol yolŋu yakany ŋarrakalnydja gali'ŋur, ŋayiny ŋunhiyiny marimirra ŋarraku. Ga ŋuli ŋayi dhu ga ŋula yolthu yolŋuy bäyŋuny ḻuŋ'maram räliny ŋarrakalnydja, ŋunhiyiny ŋayi yolŋu balanyayiny ḻatjuwarr'maranhamirra, ŋaŋ'ŋaŋ'thunna ga yolŋunhan walalany ŋarrakalaŋaŋurnha.” ");
INSERT INTO djr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ga dhäŋur beŋuryiny ŋayi Djesuy lakaraŋal bitjarra gam', “Ŋunhi ŋuli yätjkurrnydja birrimbirr dhawaṯthun yolŋuwalnydja ŋayaŋuŋur, bala ŋayi ŋuli ŋunhi marrtjin ḻarruman wiripuŋuwnha wäŋaw, wanhal ŋayi dhu maḻŋ'maram wiripun wäŋa bala nhinan. Ga ŋuli ŋayi dhu ŋunhi bäyŋuny maḻŋ'maram, bala ŋayi ŋuli waŋanhamirra ŋanyapinya ŋayi bitjanmirra, ‘Roŋiyirra ŋarra dhu dhuwal balayi bili wäŋalil ŋunhi wanhami ŋarra gan ŋäthil nhinan.’ ");
INSERT INTO djr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bala ŋayi ŋuli marrtjin roŋiyirra balayi bili wäŋalil, ga nhämany ŋayi ŋuli ŋunhiyi wäŋany manymaknha, ḏarrtjalknha ga yolŋumiriwnha, ŋayilpin', ");
INSERT INTO djr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","bala ŋayi ŋuli ŋunhi dhunupan marrtjin, bala wiripuwurrunhan garr'yun bulu 7-nhan yätjkurruny birrimbirrnha mala, ḏälmirra mirithirra. Ga ŋayiny dhu ŋunhiyiny yolŋu ŋayaŋu-waṯaŋuny mirithirra yätjirr walalaŋgal ŋayathanharaynydja, djuḻkmaraman ŋayi dhu ŋunhi nhäthinya ŋayi gan ŋäthil nhinan.” Ga bitjarra ŋayi gan ŋunhi Djesuynydja lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yo. Dharrwan ga ŋunhi mirithirra yolŋuny walal buthuru-bitjurrnydja nhanŋu Djesuwnydja. Ga ŋayiny bäy marrtjin waŋganydja miyalk yatjurr warray ŋunhiliyiny malaŋur bitjarr gam', “Nhuŋuny mak ŋuli ga dhuwal ŋäṉḏi'mirriŋu mirithirr ŋayaŋu-djulŋithirr, nhokal muka ŋunhi ŋayi gan gäŋal nhuna ga djäga nhuŋu ŋayi gan nyumukuṉiny'ku.” ");
INSERT INTO djr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ga ŋayiny Djesuny buku-bakmaraŋal balany bitjarra, “Yaka. Buluny ga mirithirrnydja ŋayaŋu-djulŋithirr ŋunhiwurrnha yolŋuny walal ŋunhi walal ŋuli ga ŋäman God-Waŋarrwun dhäruk, ga bulu walal ŋuli dhäruk nhanŋu märram, bala yan djäman.” ");
INSERT INTO djr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ga dharrwan mirithirra ŋunhi yolŋuny walal marrtjin ḻuŋ'thurr nhanukalnydja Djesuwalnydja, bala ŋayiny waŋanan walalany bitjarra, “Dhuwal nhuma yolŋu walal ŋunhi nhuma ga dhiyaŋ bala nhina dhiyal, dhuwandja nhumany dhuwurr-yätjmirra yan mirithirra, bili nhuma ganha ŋunhi yaka märr-yuwalkthinya ŋarraku. Nhumany ga dhuwal dhar'thar-gurrupan ŋarrany djämaw manymakku ŋoy-ganyim'thunamirriw romgu milkunharaw. Yurr ŋarrany dhu dhuwal yaka yänayiny djäma milkumany nhumalaŋgal. Ŋuriŋiwurruynydja yolŋuy walal ŋunhi wäŋa-Ninapawuyyuny* mala bilin gan nhäŋala, bala yan walal ŋunhi dharaŋara God-Waŋarrwuny ganydjarr, ŋunhi ŋayi Djawuna dhawaṯthurr beŋur ŋunhi ŋarirri'wal guḻunŋur walŋa yan. ");
INSERT INTO djr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yo, ŋuriŋiyin ŋayin gan Djawunaynha yolŋuy maŋutji-dhunupayaŋalnydja walalaŋguny Ninapalilnydja wäŋalil. Ga balanyayi bili nhakun ŋunhi Djawuna yolŋu, ŋayiny dhu ga Yolŋuynydja Gäthu'mirriŋuy lakaram dhunukthunukman nhumalanhan ŋunhiwurrunhan ŋunhi nhuma ga dhiyaŋun bala gäthurnha nhina. ");
INSERT INTO djr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ga be baman'tja ŋäthil buŋgawa miyalk wäŋa-Djepawuy* marrtjin beŋur barrkuŋur wäŋaŋur, ŋänharaw nhanŋu Djalamangu, bili ŋayi ŋunhi mirithirr ḻiya-djambatj balanya yolŋu ya, ga ŋayiny gan ŋunhiyi miyalktja mirithin yan djälthin marŋgithinyarawnydja nhanukalaŋaw dhäwuwny'tja. Ga balanyamirriy waluy dhä-dhawar'yunamirriynydja ŋunhi, ŋayiny boŋguŋ ŋunhiyiny miyalk wäŋa-Djepawuynydja dhärriny, bala ŋayi dhu waŋiny, yätjkurr-lakaraŋun nhumalanhan, ŋunhi nhuma ga dhiyaŋun bala nhina. Bili waŋgany yolŋu dhiyal nhumalaŋgal malaŋur mirithirra ŋayiny ḻiya-djambatj, djuḻkmaraman ŋayi ga ŋunhiyiny ḏirramuny yäkuny Djalamannhany, bala nhumany ga ŋapay-ŋurrkaman ŋanya, ŋuyulkthirra manapan nhanŋuny. ");
INSERT INTO djr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Yo. Ga walalnydja dhu ŋunhi wäŋa Ninipawuynydja yolŋu walal dhärriny nhuman rrambaŋin, bala walal dhu yätjkurr lakaraŋun nhumalanhany, bili walalnydja bilyurr warray walalaŋgiyingalnydja dhuwurr-yätjŋur romŋur ŋunhi walal ŋäkulnydja manymaktja dhäwu nhanukuŋuny Djawunawuŋuny lakaranhawuy. Ga waŋgany yolŋu dhiyal nhumalaŋgal malaŋur, ŋunhi ŋayi ga bulun gal'ŋu djuḻkmaram Djawunanhany, ga nhumany bäyŋu warray buthuru-bitjunna dhärukku.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja mayali'kurrnydja. ");
INSERT INTO djr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Yo. Ga ŋuli ŋayi dhu ŋula yolthu yolŋuy dhuŋgur'yun lanhdhirrany, ga yakan ŋayi dhu ŋunhi nhirrpan djuḻuḻ'maramany, nhä mak ŋurrwu'lilnydja nhirrpan; ŋany yänan ŋayi dhu ŋunhi gaykarraŋlila nhirrpandja, märr dhu ga bukmakkun yolŋuwnydja walalaŋ buṉbunhany djeŋarra'yamany.");
INSERT INTO djr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yo. Maŋutjiny maṉḏany dhuwal balanya nhakun baḏayala' nhuŋu rumbalwu. Ga ŋunhi nhe ŋula mel-ḏarrtjalktja, ŋunhiyiny nhakun nhuŋu walŋany baḏayala'mirra, rumbal manapanna warrpam'. Ga ŋunhi nhe maŋutji-yätjkurrnydja, ga ŋunhiyi nhe rumbalnydja buku-munhan' warrpam'nha. ");
INSERT INTO djr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gatjuy djägany nhuŋuwuy nhe gi manymakkuŋun yan. Yaka gi biyak wawuny nhini, ŋayaŋu-buku-munhany, yanbi nhe ŋayaŋu-djarraṯawun'mirra. ");
INSERT INTO djr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yo. Ga ŋuli nhuŋu dhu rumbal warrpam'nha baḏayala'mirr, ga bäyŋun nhokal dhu ga ŋula nhäny buku-munhany' gärri, ŋunhiyiny nhe ga nhina baḏayala'ŋura yan, bitjan bili yan nhakun ŋuli ga ŋuriŋi lanhdhirray nhuna djarraṯawun'kum.” Ga bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ga ŋunhi ŋayi Djesu dhawar'yurr waŋanhaŋurnydja, bala waŋganydja yolŋu Baratjiny marrtjinan, bala ŋayi garr'yurra ŋanya Djesunhany balan nhanukiyingala ŋayi wäŋalil ŋathawnha ḻukanharaw. Bala ŋayi Djesuny marrtjinan, djuḏupnha gärrin wäŋalila nhanukal, dhutnha nhinan ŋathawnha ḻukanharaw. ");
INSERT INTO djr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ga ŋayiny ŋuriŋiyiny yolŋuy Baratjiynydja ganyim'thurra ŋanya nhäŋalnydja, bili ŋayi ŋunhi Djesuynydja dhunupan yan ḻukanan, yakan ŋayi rurrwuyunminyany ŋanyapinya ŋayi goŋdja. Bili rom walalaŋ gan ŋunhiliyi ŋorran yäku goŋ-rurrwuyunminyawuy. ");
INSERT INTO djr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bala ŋayi Garraynydja waŋanan nhanukal bitjarra, “Nhuma Baratjiynydja yolŋuy walal ŋuli ga ŋayatham ŋunhiyi rom banikin'puy rurrwuyunawuy, yurr ŋunha ŋayaŋuny nhumalaŋ djinawany' yätjkurra yan mirithirra, ga bitjanna bili nhuma ŋuli ga ŋunhi djaw'-djawyunna yan wiripuwurruŋguny ŋula nhä malany. ");
INSERT INTO djr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nhä nhuma dhuwal, ḻiya-dhumukmirr yan muka? Ŋayipi muka ŋunhi God-Waŋarryu djäma dhuwal warraŋulnydja rumbal, ga ŋunha djinawa'puynydja rumbal. ");
INSERT INTO djr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gatjuy, ŋunha djinawany' djämayi ḏarrtjalkkuŋdhi. Biyakun wuyurra ŋurukuwurruŋguny ŋunhi gurrupuruŋumirriwnydja yolŋuw walalaŋ, ga yänan gurrupula walalaŋ ŋunhi nhe ga ŋula nhäny ŋayatham, bala dhu bukmaknha ŋunhi ŋula nhäny mala nhumalaŋ warrpam'thunna ḏarrtjalkthirra.” ");
INSERT INTO djr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Yo. Nhumany dhuwalawurrnydja ŋunhi Baratjiny yolŋu walal, mariny nhumalaŋ dhu yindin yan maḻŋ'thurr! Nhumany ŋuli ga dhuwal gurrupan God-Waŋarrwuny bukupuynha yan mala-wulkmaranhawuynha ŋunhi nhä nhuma ŋuli lämu-nhirrpan balanya nhakun ŋunhi ŋathapuy dhäkay-ŋamathinyawuy mala. Ga yakan nhuma ŋuli gi ŋunhi yolŋunhany walalany nhäŋu ŋamathaŋuny, ga yakayi nhuma ŋuli gi ŋunhi märr-ŋamathi nhanŋuny God-Waŋarrwuny. Nhumany yanbi dhu ga ŋunhi rom-dhunupayirra ga ŋayaŋu-wuyunna wiripuwurruŋguny yolŋuw walalaŋ, ga bitjan yan bili nhuma dhu ga ŋunhi mala-wulkmaram nhanŋuny God-Waŋarrwuny.” ");
INSERT INTO djr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Yo. God-Waŋarryuny dhu ŋunhi nhumalanhany Baratjinhany yolŋuny walalany dhä-gir'yurrnydja mirithin yan. Nhumany ga dhuwal guyaŋanhamirr yanbi nhumany be garrwarnha. Ŋunhi nhuma ŋuli marrtji balany ŋunhi Djuw malawalnydja buku-ḻuŋ'thunamirrililnydja buṉbulil, bala nhuma ŋuli ŋunhi nhinany ŋunhiwilin nhinanhawuylilnydja manymaklila, ga bitjandhi bili nhuma ŋuli ga djälthirr yolŋuwnydja walalaŋ, walal dhu ga waŋa märr-ŋal'yun nhumalaŋ ŋunha dhukarrkurr. ");
INSERT INTO djr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Yo. Yuwalk yan nhuma dhu ŋunhi mariny märraŋ yindin yan. Nhumany dhuwal balanya nhakun ŋunhi molu mala yolŋuw walalaŋ, ŋunhi ŋuli marrtji yolŋuynydja walal dhurrpa'-dhurrparamany wawun ŋunhiyiny moluny mala, bili ŋayi ŋuli ga ŋunhi nhämany warraŋul yan manymaktja, yurr djinawany' ŋunha ŋunhi yakan manymak. Ŋunhi ŋayi dhu ŋula yol yolŋu galkithirrnydja nhumalaŋgal, yanbi nhumany manymak, ga ŋunhiyiny nhakun ŋayi dhu ŋunhiyiny yolŋu barrkuthirra God-Waŋarrwala nhumalaŋgala yätjkurruy.” ");
INSERT INTO djr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ga ŋayiny wiripuŋuynydja waŋganydhuny yolŋuy rom-marŋgikunhamirriy waŋan Djesuny bitjarr, “Way Marŋgikunhamirr, ŋunhi nhe ŋuli bitjandhiny waŋa, ŋunhiyiny nhakun nhe ga yätjkurr-lakaramany napurrunhan bitjandhiny.” ");
INSERT INTO djr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Bala ŋayiny Djesuny waŋanan buku-bakmaraŋala balany nhanŋuny bitjarra, “Yo. Biyakiyi bili muka ŋayi dhu ŋunhi God-Waŋarryuny nhumalanhany rom-marŋgikunhamirrinhany mala dhä-gir'yurryi, bili nhuma ŋuli ga ŋunhi romnhan yindikumany, nhakun nhuma ŋuli ga ŋunhiyiny yolŋunhan walalany ḏiltjin ŋonuŋgum, ga bäyŋuyi nhumany ŋuli ŋunhi walalanhany guŋga'yurr. ");
INSERT INTO djr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yo. Yuwalk yan nhuma dhuwal yindiŋurnydja mariŋurnydja. Dhuwal nhuma gan latju'-latjukuŋal djäma moluny mala ŋunhi djawarrkmirriwnydja yolŋuw walalaŋ, ŋurikiwurruŋdhiny ŋunhi nhumalaŋgal gan mala-ŋurrkanhayŋuy walal bumar walalany murrkay'kuŋal yan ŋäthil, yanbi nhuma ŋuli gi ŋunhi märr-ŋal'yurra walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bala nhuma ŋuli ga ŋunhi waŋany bitjanna, ‘Manymaknha ŋunhiyiny. Murr' muka walalany gan bumar,’ bitjanna. Yurr djämany nhuma ŋuli ga ŋunhi mathirrany mala walalaŋ manymakkuman dhika mirithirra. ");
INSERT INTO djr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ga ŋurikin ŋayaŋuwnydja, ŋäthilnydja be baman'tja ŋayi God-Waŋarrnydja waŋan bitjarrnydja, ŋunhiyin God-Waŋarr ŋunhi ŋayi yäku Ḻiya-djambatjnha, ‘Ŋarrany dhu dhuwal walalaŋ dhäwu-gänhamirrinhan ga djawarrkmirrinhan malany djuy'yun, yurr wiripuwurrunhany walal dhu buman murrkay'kuman, ga wiripuwurrunhany walal dhu buma ŋayaŋu-yätjaman,’ bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Yo. Beŋur bili baman'ŋuŋur yolŋuy walal ŋuli ganha bunha murrkay'kunha ŋunhi djawarrkmirrinhany yolŋuny walalany, beŋur bili ŋurruyirr'yurr nhanukal Waybulwal ga yan warray bili ga wapthurr Djakarayawal, ŋunhi wala ŋanya bumar murrkay'kuŋal ŋunhal ŋunhi God-Waŋarrwala dhuyuŋura buṉbuŋura, ŋunhi gan djimuku' bulaymirr dhärran yurr ṉapuŋgan'. Yo. Dharrwan gan ŋunhi yolŋuny walal djawarrkmirrnydja mala gulaŋ-waṉḏinany, yurr ŋayin dhu nhumalanhany God-Waŋarryun dhä-gir'yurr, ŋunhi nhuma ga dhiyaŋ bala waluy dhuwal nhina; ŋayin boŋguŋ nhumalanhany dhä-gir'yurr ŋurikiwurruŋgalyiny bukmakkala yan, ŋunhi walal marrtjin dhiŋgaŋal beŋur bili ŋurruyirr'yunaŋur ga yan bili ga dhiyaŋun bala gäthura.” ");
INSERT INTO djr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ga nhumalanhany dhu ŋunhi rom-marŋgikunhamirrinhany walalany God-Waŋarryuny dhä-gir'yurr mirithiyi yan. Ŋunhi wiripuwurrnydja yolŋu walal djäl muka marŋgithinyaraw God-Waŋarrwuny, yurr nhumany gan djaw'-djawyurr ŋunhi gonydjiŋ walalaŋgalaŋuŋur, bala nhuma gan dhurrwarany dhaḻ'-dhaḻyurra, märr walalnydja dhu yakan gärri ga marŋgithirr. Nhumapiny dhuwal yaka warray gulŋiyinya; yan nhuma ŋuli ga gulmaram ŋunha wiripuwurruny, ŋunhi walal ŋuli ga djälthirr God-Waŋarrwu dharaŋanaraw.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋ dhärukthuny wuṉḏaŋarryun. ");
INSERT INTO djr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Dhäŋur beŋuryiny bala ŋayi Djesuynydja ganarrthaŋala ŋunhiyiny wäŋa, ga walalnydja ŋunhi rom-marŋgikunhamirriynydja yolŋuy walal ga Baratjiynydja walal gan ŋarrtjurra ŋanya, yätjkurruyaŋala. Ga dhäŋur beŋuryiny walal gan bitjarra bilin dhä-birrka'yurra ŋanya, yanbi balaŋ walal ŋanya bawa'-gurrupana, yan nhakun walal ŋanya gan warku'yurra, bili walal gan ŋunhi balanyamirriyyiny ŋayan'mirra mala nhinanany nhanŋu, yanbi balaŋ walal maḻŋ'maranha nhanukal ŋula nhä yätjkurr dhäruk. ");
INSERT INTO djr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ga dharrwan ŋunhi yolŋuny walal ŋula nhämunhan' mala marrtjin ḻuŋ'thurrnydja balayiny Djesuwalnydja, ŋapa-ŋal'maranhaminan marrtjin ḏur'-ḏuryunminan. Yurr ŋayipiny ŋathil Djesuny waŋan nhanukiyingalaŋuwnydja ŋayi malthunamirriw walalaŋ bitjarr gam', “Nhumany dhu walal djägan nhumalaŋguwuynydja nhuma, märr nhuma dhu bäyŋu malthun ŋurukuwurruŋguny romgu ŋunhi Baratjiwnydja walalaŋ, bili ŋunhiwurryin ŋunhi yolŋu walal rom gali'-märrma'mirrnydja. Bäyŋun nhumany dhu ga bitjandhi nhakun ŋunhawurryi yolŋu walal. ");
INSERT INTO djr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ŋuli nhe dhu ga ŋunhi ŋula nhä djuḻuḻ'maram dhiyaŋ bala, ga yalalany dhu ŋunhiyi warrpam'nha maḻŋ'thurr, warraŋulthin dhu. ");
INSERT INTO djr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ga ŋunhi nhe gan ŋula nhaltjarr waŋan buku-munhaŋur, ga yalalany dhu gi ŋunhi boŋguŋ nhuna ŋäkun waŋanhawuynydja walupuynha gaykarraŋŋura. Ga ŋunhi nhuma gan waŋanhamin ŋula gayulnydja yawyawyunminany djinawany' buṉbuŋurnydja dhurrwara-gunganhawuyŋurnydja, ga yalalany walal dhu gi ŋunhi ŋäkun mirithinyawuynha waŋanhawuy yatjunawuynha, ŋunhala garrwarnha ŋapaŋura buṉbuŋur.” ");
INSERT INTO djr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ḻundu walal ŋarraku, ŋarra nhumalaŋ lakaraman. Yaka walal barrari ŋula yolku yolŋuw ŋunhi ŋayi dhu nhunany buma murrkay'kum; ŋunhiyiny walal nhunany dhu rumbal yan buwayakkum waŋgany, ga bilin. ");
INSERT INTO djr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yuwalktja nhuma dhu ga ŋunhi barrarirrnydja nhanŋuwuynha yan God-Waŋarrwun, bili ŋayipin ga waŋganydhun ŋunhi ganydjarrnydja ŋayatham märrmaw'nha yan ŋurruwnydja, rakunygunharaw bala ŋurrkanharawnha balan ŋunhi dhä-gir'yunamirrilila wäŋalil. Yo. Barrariny gi waŋganygun God-Waŋarrwun yan nhanŋuwuynha ga bilin.” ");
INSERT INTO djr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","“Yo, nhumany dhuwal goŋmirr warray nhanukalnydja God-Waŋarrwalnydja. Nyumukuṉiny'tja dhuwal warrakan' djikayny'tja märr gaŋga, ga ŋunhi ŋuli yolŋuy bäyim goŋ-waŋganydja djikay' mala nyumukuṉiny'thuny rrupiyay, märrmayny'tja yan ŋarakay, yurr yakan ŋayiny ŋuli ŋunhi God-Waŋarryuny ŋunhi waŋganydja moŋu. Ga balanyayi bili nhuŋuwuynydja ŋayi God-Waŋarr marŋgiyi yan bukmakku, balanya nhakun ŋayi marŋgi marwatku nhokalaŋaw, nhämunha' nhuŋu marwat ga gorrum ḻiyaŋur. Yakan nheny barrari. Dhuwal nhumany yolŋu walal goŋmirr warray God-Waŋarrwal yan goŋŋur, bulu warray ga djuḻkmaram ŋunha warrakan'nhany mala.” ");
INSERT INTO djr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Märr-yuwalk ŋarra nhumalaŋ dhu dhuwal lakaramany. Ŋuli nhe dhu ga lakaranhamirr nhunapinya nhe yolŋuwalnydja walalaŋgal bitjanmirrnydja, ‘Ŋarrany dhuwal yolŋu Garraywalaŋumirr,’ bitjandja, bala ŋarrany nhuna dhu Yolŋuynydja Gäthu'mirriŋuy bitjandhi bili yan lakaram ŋurukuwurruŋgalnydja ŋunhi God-Waŋarrwalnydja dhäwu-gänhamirriwal walalaŋgal bitjanna, ŋunhi nheny dhuwal ŋarraku warray yolŋu. ");
INSERT INTO djr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ga ŋuli nhe dhu ga nhunapinya nhe yolŋuwal walalaŋgal lakaranhamirr bitjanmirrnydja, ‘Ŋarrany dhuwal yaka Garraywalaŋumirr,’ bitjandja, bala ŋarrany dhu nhuŋuny ŋunhi biyakiyi bili yan dhumbal'yurr milman yan gumurrŋura ŋurukuwurruŋgala ŋunhi djiwarr'wuywala dhäwu-gänhamirriwala walalaŋgal, bitjanna gam', ‘Dhuwandja yolŋu yaka ŋarraku,’ biyakun.” ");
INSERT INTO djr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ga ŋuli dhu ga ŋunhi ŋula yol yolŋu dhä-wiripuŋuyirr waŋa Yolŋuwnydja Gäthu'mirriŋuw, yurr ŋathil ŋayi dhu bilyun beŋuryi nhanukiyingal ŋayi yätjkurruŋur, bala ŋayiny dhu God-Waŋarryuny nhanŋu bäy-lakaraman ŋunhiŋuwuyyiny. Yurr bäyŋuny ŋayi dhu God-Waŋarryu bäy-lakaram ŋurikiyin yolŋuw ŋunhi ŋayi dhu dhä-wiripuŋuyirr waŋa Godkalaŋuwnha Dhuyu-Birrimbirrwun.” ");
INSERT INTO djr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Yo. Yakan nheny wilwilyurr ga warwuyurr ŋunhi walal nhuna dhu gämany balany ŋunhi Djuw malawalnydja buku-ḻuŋ'maranhamirrililnydja buṉbulil, ŋurruḏawalaŋuwalnydja walalaŋgal ga buŋgawawalnydja, märr walal dhu mariny nhuŋu djäma bili nheny dhuwal ŋarrakalaŋumirra. Yaka ŋurru-ḏakthurr ŋunhi nhaltjan nhe dhu ga waŋa, ");
INSERT INTO djr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","bili ŋayin dhu ŋuriŋin Dhuyu-Birrimbirryun nhunanhany gurrupan dhäruk waŋanharawnydja, balanyamirriy bili yan ŋunhi nhe dhu rur'yun waŋanharaw.” Ga bitjarr ŋayi gan Djesuny waŋan. ");
INSERT INTO djr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yo. Dharrwan gan ŋunhi mirithirra yolŋuny walal buthuru-bitjurrnydja nhanŋu Djesuwnydja. Ga ŋayiny bäy waŋgany ḏirramu waŋan nhanŋu Djesuw bitjarr gam', “Wäy Marŋgikunhamirr! Nhämirr nhe dhu marrtji ga waŋa ŋunha wäwa'mirriŋuny ŋarraku, ŋayi dhu mala-wulkmaraman ŋarrakuny ŋula nhä malany, ŋunhi ŋayi bäpa'mirriŋuy linyalaŋgal ganarrthaŋal.” ");
INSERT INTO djr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bala ŋayiny Djesuny waŋanan buku-roŋanmaraŋalnydja nhanŋu bitjarra, “Way ḏirramu! Nheny ga nhaltjan dhuwal ŋarranhany guyaŋa, yanbi ŋarrany dhuwal nhä, mala-djarr'yunamirra yolŋu? Bäyŋu warray ŋarraku dhuwali ŋula yolthuny yolŋuy gurrupar djäma mala-wulkmaranharawnydja.” ");
INSERT INTO djr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Bala ŋayi Djesuny bilyurra, ga waŋan bukmakkun yolŋuw walalaŋ bitjarra, “Guyaŋiny walal gi barrku-ḏakthurra, märr nhumalany dhu yakan garrwi'yun buku-mangunhamirriynydja romdhu. Bäyŋun nhe dhu ŋunhi girri'-dharrwamirriynydja yolŋuy wiyingum nhuŋuwuy nhe walŋany ŋuriŋiny rrupiyaynydja nhokiyingal nhe. Bäydhin nhe dhu gi ŋayathulnydja bukmaktja ŋula nhä malany ŋunhi dhuwalaŋuwuynydja munatha'wuynydja. Bäydhi mak nhe ŋunhi ŋula ḻukunydjany' yolŋu.” ");
INSERT INTO djr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ga dhäŋur beŋuryiny ŋayi Djesuy dhäwun' lakaraŋal mayali'kurra bitjarra gam', “Waŋganymirrnydja yolŋu gan nhinan ḻukunydja' mirithirr, yurr ŋayi ŋunhiyi yolŋuny ŋatha-lämu-nhirrpanamirr, ga ŋathany ŋunhi nhanukuŋ gan ŋutharnydja manymakthinan ga dharrwathinan. ");
INSERT INTO djr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bala ŋayi ŋuriŋiyi ḏirramuynydja guyaŋanan bitjarra, ‘Dhuwal ŋarraku buṉbuny ŋathapuynydja nyumukuṉiny' yan? Wanhawala ŋarra dhu dhuwal rulwaŋdhundja ŋathany mala ŋarrakuwuy ŋarra?’ ");
INSERT INTO djr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Bala ŋayi gan guyaŋana-a-any, bala ŋayi waŋanhaminan bitjanminan, ‘Dhuwal ŋarra dhu dhuwal bili wäŋa wutthun bakmaram, bala ŋarra dhu yindikuman djäma, märr ŋarra dhu ŋathany mala galkan balayin yindilila bala'lilnydja, ga wiripuny ŋarra dhu girri' mala ŋarrakuwuy ŋarra galkan ŋunhiwiliyi bala'lil. ");
INSERT INTO djr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bala ŋarra dhu ŋunhi waŋanhamirra ŋarranhawuynha ŋarra bitjanmirra: Ŋarrany dhuwal ḻukunydja' mirithirra. Bilin ŋarra gan rulwaŋdhurra ŋathany mala ga ŋula nhäny mala ŋarrakuwuy ŋarra, märr ŋarra dhu ga nhinany yänan. Ga ḻukany ŋarra dhu ga ŋathan yan ga gapun, ga nhinany ŋarra dhu ga goŋmirriyirra mirithirra bitjanna bili yan dhuŋgarra-ŋupanna,’ bitjarr.” ");
INSERT INTO djr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Yurr ŋayiny God-Waŋarrnydja waŋan ŋurikiyi ḏirramuwnydja bitjarra, ‘Nhä nhe dhuwal yolŋuny, bawa'mirra? Dhuwal nhe dhu dhiyaŋuny bala gäthurnydja dhiŋgaman. Ga yolnha dhika dhu nhokalnydja dharapulŋur ḻukunydja'yirr ŋurikiny ŋunhi nhe gan ŋäthil girri' malany märraŋal nhuŋuwuy nhe?’” ");
INSERT INTO djr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bala ŋayi Djesuny waŋan dhawar'maraŋalnydja bitjarra, “Ŋuli ŋayi dhu ga ŋula yol yolŋu ḻay-ḻayyun ŋula nhaliynydja malaŋuy munathawuyyuny, bukulilnydja ŋal'maram dhu marrtji ŋula nhä malany nhanŋuwuy ŋayi, ŋunhiyiny nhakun ŋayi balanyayiny yolŋu ḻiya-dhumuknha bawa'mirra, bili ŋunhalnydja ŋayi dhu gi ŋunhi God-Waŋarrwalnydja gumurrŋur boŋguŋ dhärri goŋ-waŋaran, dhäparŋ'nha.” ");
INSERT INTO djr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bala ŋayi Djesuynydja waŋanan nhanŋuwuy ŋayi malthunamirrinhany walalany bitjarra, “Ga balanyan dhuwal dhäwuny' ŋarra dhu lakaraman nhumalaŋ gam'. Yaka nhuma dhu ga ŋunhi warwuyun mirithirr ŋathawnydja ḻukanharaw maranhuyinyarawnydja, ga nhaltjan nhuma dhu ga nhina walŋa. Ga yakan gi warwuyurr girriwny'tja ŋunhi nhä malany nhe dhu ga gurrukam rumbalyu nhokiyingal nhe; ");
INSERT INTO djr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ŋany guyaŋany nhe dhu ga ŋanyapinyan God-Waŋarrnhan yan, ga nhanŋun ŋula nhä malany. Nheny dhuwal yolŋu, ga djäma ŋayi nhuna ŋunhi rumbal yolŋukuŋal yan, märr nheny dhu ga ŋunhi nhina walŋan yänan nhanukala goŋŋurnydja ŋamathaman yan. Yaka ŋayi nhuna ŋunhi djäma ŋathawnydja yan ḻukanharaw ga girriwny'tja dhaṯthunminyaraw, ga bilin. Ŋayiny nhuna ŋunhi djäma manymakku mala yan gämurruw'. ");
INSERT INTO djr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Guyaŋi ŋathil walal ŋunha ŋunhi warrakan'nha wäknha malaŋuny. Yaka walalnydja ŋuli gi ŋunhi munathany' buḻŋu'kuŋ, ga dholkuŋuny marrtji lämu-nhirrpulnydja ŋathany mala maŋutjiny, ga bulu marrtji gulkthurrnydja ŋunhi ŋathanhany, bala yan'thawuŋuny muka bala'lilnydja ŋurukuny wiripuŋuwnydja waluw. Yurr ŋayipi ŋuli ga ŋunhi God-Waŋarryu maranhu-gurrupandja walalany. Ga nhumany dhuwal yolŋu walal, djuḻkmaraman ga ŋunhayiny ŋunhi warrakan'nhany malaŋuny. ");
INSERT INTO djr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ŋuli nhe dhu ga ŋunhi warwuyundja yan ga guyaŋa nhe dhu ga bitjandja gam', ‘Ye-e-e, wanha balaŋ ŋarra gi dhuwal walŋan yan wiyinnha nhini dhiyalnydja wäŋaŋur?’ Ga nhaltjanna nhe dhu ga ŋunhi balanyarayyiny guyaŋanharay? Yuwalk muka nhe dhu ga ŋunhi walŋa-wiyindja nhina dhiyalnydja wäŋaŋur? ");
INSERT INTO djr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bäyŋu. Yaka nhe dhu ga walŋa nhuŋuwuy nhe wiyingum balanyarayyiny warwuyunaraynydja nhokiyingal nhe. Yaka nhuŋu dhuwal manymak warwuyunaraw, nhe dhu ga warwuyun ŋula nhaku malaŋuw. ");
INSERT INTO djr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ŋunha ŋathil nhäŋuny wurrkiny' mala ya ŋunha ŋuthanawuy. Bäyŋu walalnydja ŋuli gi ŋunha djäma, ga girri' mala walal ŋuli gi bäyŋuyi yan barrtjurr walalaŋguwuy walal. Ga be ŋäthil buŋgawa yäku Djalaman gan nhinan yurr ŋayi ŋunhi ḏirramuny mirithirr ḻukunydja' ga girriny' mala nhanŋu ŋunhi mirithirr yan latju'mirr dhika. Yurr bäydhi ŋayi ŋunhi yolŋu girri'-manymakmirrnydja, yurr wurrkin' mala ŋunhi buluny gal'ŋu latju', djuḻkmaraman ga ŋunhiyiny ŋunhi nhanŋuny Djalamanguny girri' malany. ");
INSERT INTO djr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Bili God-Waŋarryu ŋayipi ŋuli ga ŋunhi mulmunhany mala ŋuthanmaram, ga djägany ŋuli ga manymakkumany, bäydhi ŋuli ga ŋunhi gurririny ŋayi walŋa dhärra, nhakun dhiyaŋ bala ga dhärra walŋa, bala dhu ŋunhi mulmunhany dhuŋgur'yurra räwakkuŋun. Yurr yolŋuny dhuwal mirithirr warray ŋurruŋu God-Waŋarrwalnydja ŋayaŋuŋur, djuḻkmaraman ga mulmunhany, ga yuwalknha ŋayi dhu ga ŋunhi djägany nhumalaŋ manymakkumany. Ga nhä nhumany dhuwal, dhä-märr-yuḻk yan yolŋu walal? Gaŋga yan nhuma ŋuli ga dhuwal märr-nhirrpanmirr God-Waŋarrwalnydja muka?” ");
INSERT INTO djr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Yakan nheny dhu ga ŋunhi warwuyun ŋathawnydja ga gapuwnydja. ");
INSERT INTO djr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ŋunhiwurrnha dhuwal bäpurru yolŋu walal ŋuli ga mirithirrnydja warwuyun ŋunhi walal dhuŋamirra God-Waŋarrwu. Yo, ŋayiny ŋunhi nhuŋuny Bäpa'mirriŋu marŋgi warray mirithirr nhuŋuny, ŋunhi nhaku mala nhe ga dhuwaliyi djälthirr. ");
INSERT INTO djr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nheny gi ŋurruŋuyaŋuny God-Waŋarrwun yan romdja ga nhä malany ŋunhi nhanŋun; bala nhä malany ŋunhi bukmaktja dhu nhuŋun.” ");
INSERT INTO djr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Yo. Nhuma dhuwalawurr ŋunhi djamarrkuḻi' ŋarraku ḻurrkun', yaka walal barrariny, bili nhumalaŋgal djiwarr'puyyuny Bäpa'mirriŋuy nhumalany dhu gurrupanna nhanŋuwuynydja ŋayi rom nhumalaŋgun. ");
INSERT INTO djr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yaka gi ŋayathul baṯ-biyakuny ŋunhi dhuwalaŋuwuynhany munatha'wuynhany ŋula nhä malany; biyakun gurrupula marrtji ŋurikiwurruŋguny ŋunhi ŋurruwuykmirriwnydja yolŋuw walalaŋ, märr nheny dhu märram nhuŋuwuynydja nhe ŋunhi yuwalknha, ŋunhaŋuwuynha djiwarr'puynha ŋula nhä malany, ŋunhiyin ŋunhi dhu yakan ŋäthiliŋuyirr ga gararrkararryirr. Märryuny ŋupul gi ŋunhiyin bili yan djiwarr'puynha yan nhä malany. Ŋunhiyiny nhakun nhe dhu ga bukulila ŋal'maram nhuŋuwuy manymakmirr ŋunhaŋuwuynha djiwarr'puynha; ga ŋunhiyiny dhu ga nhä malany bitjanna bili yan ŋorran wiyinŋumirra. Yakan dhu ŋunhiyiny ŋula yolthuny djaw'yun, ga ŋula gälkalyuny dhu gi bäyŋun ḻuki. ");
INSERT INTO djr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ŋuli nhe dhu ga ḻuŋ'maram buku-mangum munatha'wuynydja yan ŋula nhä malany, ga ŋunhiyiny nhakun nhe dhu ga märr-ŋamathirrnydja dhuwalaŋuwuywun bili yan munatha'wuywun. Ga ŋuli nhe dhu ga guyaŋa ŋunhaŋuwuynydja bili yan djiwarr'puynydja ŋula nhä malany, ŋuriŋiyiny nhuŋu ga maŋutji-lakaram ŋunhiyiny nhakun nhe ga märr-ŋamathirrnydja ŋurikiyin bili wäŋawnydja, nhakun ŋunhiyin nhuŋuny wäŋa.” ");
INSERT INTO djr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Yo. Nhininy gi biyakun bira'yurra, dhaṯthunmirra gi girriyny'tja, ga lanhdhirrany nhuŋu dhu ga nhäran yan; dhärrin gi biyakun girri'-ŋamathin. ");
INSERT INTO djr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Dhärriny gi, biyakun nhakun ŋuli ga ŋunhi djämamirr yolŋu dhärra, galkunna ŋayi ŋuli ga nhanukiyingalaŋaw ŋayi buŋgawa'mirriŋuwnha, ŋunhi ŋayi dhu roŋiyirra rälin beŋura buŋgulŋura. Ga ŋunhi ŋayi nhanŋu dhu buŋgawa'mirriŋuny buna, bala ŋayi dhu dhurrwaran wutthu'-wutthun, ga dhunupan nhakun yan ŋayiny dhu ŋuriŋiyiny djämamirriynydja nhanukal dhurrwarany nhanŋu ḻapmaraman. ");
INSERT INTO djr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yo. Walalnydja dhu ŋunhiwurryiny ŋunhi djämamirrnydja mala mirithirra galŋa-djulŋithirrnydja, ŋunhi ŋayi dhu buŋgawa'mirriŋuny walalaŋ roŋiyirr ga maḻŋ'maramany walalany girri'-ŋamathinyawuynha ga bira'yunawuynha. Yuwalk yan ŋarra nhumalaŋ ga dhuwal lakaramany. Dhunupan yan ŋayi dhu ŋunhiyiny buŋgawa'mirriŋuny waŋany ŋurr'maraman walalany ŋunhiwiliyin nhanukiyingala ŋayi wäŋalilnydja, bala ŋayi dhu walalaŋ ŋathan djäma. ");
INSERT INTO djr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yo. Yurr ŋayi dhu mak ŋunhi bunany djeḏa, guwaḻyun munhay, nhä mak ŋayi dhu buna bäy galki djaḏaw'yunaraynha, bala walalnydja dhu ŋunhiwurrnydja djämamirrnydja mala ŋayaŋu-djulŋithirra yänan, ŋuli ŋayi dhu buŋgawa'mirriŋuynydja walalany maḻŋ'maram bira'yunalilnydja ga dhukarr-nhänhalilnydja. ");
INSERT INTO djr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Guyaŋa nhuma dhu dhuwal ŋunhi gam'. Ŋuli ŋayi dhu ŋunhi yolŋu wäŋa-waṯaŋu marŋgithirrnydja nhaliy waluy ŋayi dhu ŋunhi manaŋa-ḏumurr yolŋu buna, ŋayiny dhu ŋunhiyiny yolŋu bira'yundja ŋäthil yan, ga nhinany ŋayi dhu ga dhukarr-nhäman, märr ŋayi dhu yakan ŋunhiyiny manaŋa-ḏumurrnydja yolŋu gärri ga djaw'yun ŋula nhäny beŋuryiny wäŋaŋurnydja nhanukal. ");
INSERT INTO djr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ga bitjandhin nhumany dhu ga ŋunhi nhinany bira'yunna girri'-ŋamathinyawuynha, bili ŋunhiyiny Yolŋuny dhu Gäthu'mirriŋu bunany ŋuriŋiyin waluynydja ŋunhi nhuma gi yakan gatjpu'yurr nhanŋu bunanharawa.” Ga bitjarra ŋayi gan Djesuny waŋan. ");
INSERT INTO djr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ga ŋayi Betay dhä-birrka'yurr ŋanya Djesuny bitjarr, “Way Garray, yolku nhe ga dhuwal mayali'kurrnydja dhäwu lakaram? … ŋanapurruŋguwuy yan? … Ŋany yolku, dhiyakuwurruŋ bukmakku muka?” ");
INSERT INTO djr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bala ŋayi Djesuynydja lakaraŋal wiripun dhäwu mayali'mirryi yan bitjarr gam', “Ŋuli ŋayi dhu ŋunhi buŋgawany yolŋu märr-gurku'yun wiripuŋulilnydja wäŋalil, yan nhakun guwarr, ga yolkala goŋlil ŋayi dhu ŋunhi nhirrpan ŋunha ŋunhi wiripuwurrunhany djämamirrinhany mala nhanŋuwuy ŋayi? Yänan ŋayi dhu nhirrpandja walalany ŋurikala bili yan goŋlilnydja ŋunhi ŋayi ŋuli ga djäma yuwalkkum yan, ga malthunayŋu ŋayi; ŋayin dhu ga ŋunhiyin djägany walalaŋ manymakkumany, ga maranhu-gurrupandja ga walalany. ");
INSERT INTO djr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ga ŋunhi nhakun ŋayi dhu buŋgawa'mirriŋuny roŋiyirr ga bunany walalaŋ, bala ŋayi dhu ŋunhi maḻŋ'maramany djämamirrinhany yolŋuny ŋayi dhu ga djägany walalaŋ manymakkum yan, bala yan ŋayi dhu ŋunhi buŋgawa'mirriŋuny märr-ŋamathirra nhanŋu wokthunna manapan, ga ŋayiny dhu ŋunhiyiny yolŋu djämamirrnydja bitjandhi bili yan goŋmirriyirryi. ");
INSERT INTO djr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yo. Dhuwandja ŋarra ga märr-yuwalknha nhumalaŋ lakaram. Ŋuriŋiyiny buŋgawa'mirriŋuynydja dhu bukmaknha gurrupan nhanukiyinguŋuny ŋayi ŋula nhä malany warrpam'thunna yan ŋurikalyin djämamirriwala yolŋuwal djägalilnydja. ");
INSERT INTO djr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ga ŋuli ŋayi dhu ga ŋuriŋiyi djämamirriy yolŋuy guyaŋa bitjandja gam', ‘Dhika ŋunhi buŋgawa'mirriŋuny ŋarraku ga wiyinnha nhina muka, yakan ŋayi dhu ŋunhi bondiny roŋiyirr,’ bitjandja, bala yan ŋayi dhu ŋuriŋiyiny djägamirriynydja yolŋuy buman ga wiripuwurrunhany djämamirriny walalany, miyalkkurruwurruny ga ḏirramuwurruny, bala ŋayipiny dhu ga ŋunhi ḻay-ḻayyunna ŋathaŋura yan ḻukanhaŋur, ga leŋun ŋayi dhu ga, dhika nhaltjanna. ");
INSERT INTO djr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bala ŋayiny dhu ŋunhiyiny buŋgawa'mirriŋuny yolŋuny gumurr-roŋiyirrnydja ŋuriŋi bili yan waluynydja ŋunhi ŋayi gi yaka ŋanya guyaŋi, bili yakan ŋayiny marŋgi nhätha ŋayi dhu ŋunhiyi buŋgawa buna. Ga dhunupan ŋayi dhu ŋunhiyiny buŋgawa'mirriŋuny mirithirra maḏakarritjthirrnydja nhanŋu ŋurikiyiny yolŋuw djämamirriwnydja, bala dhu ŋayi ŋanya ŋunhi dhä-gir'yundja mirithirra yan; bili ŋayi ŋunhi dhäruk-märranhamiriw yolŋu.” ");
INSERT INTO djr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ga ŋuli ŋayi yolŋu djämamirr marŋginy ŋunhi nhaku ŋayi buŋgawa'mirriŋu nhanŋu djälthin djämaw, ga ŋuli ŋanya ŋayi dhu bäyŋuny dhäruk märram ŋunhiyiny ŋayi dhu ŋuriŋiyiny djämamirriynydja märram dhä-gir'yunawuynydja yindin mirithirra nhanukuŋ. ");
INSERT INTO djr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ga ŋuli ŋayi dhu ga ŋuriŋiyi djämamirriy yolŋuy djäma märr djarrpi'kumany, bili yaka ŋayi marŋgi nhaku ŋayi ŋunhi buŋgawa'mirriŋu nhanŋu djälthin djämaw, ŋayiny dhu ŋuriŋiyiny djämamirriy yolŋuy dhä-gir'yunawuynydja märraŋ märr gaŋga yan. Yo. Ga ŋuli nhe ŋuli ga märram dharrwany mirithirrnydja nhanukuŋ God-Waŋarrwuŋuny, ŋayiny ga God-Waŋarrnydja nhuŋu djälthirr, nheny dhu ga ŋunhi balanyayi bili yan dharrwayi yan gurrupan. Ga ŋunhi ŋayi dhu ga God-Waŋarryu gurrupan nhokalnydja djägalil dharrwany mirithirrnydja, ga ŋunhiyiny nheny dhu ga djäma God-Waŋarrwuny mirithirryi yan, bala ŋayi dhu waŋany nhuŋu bitjanna, ‘Nheny dhu ga balanyayi bili yan gurrupan dharrwayi yan mirithirr ŋarrakuny roŋanmaramany.’” ");
INSERT INTO djr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ga dhäŋur beŋuryiny ŋayi Djesu waŋan bitjarra, “Yo. Marrtjinany ŋarra dhuwal räliny dhipalnydja munatha'lilnydja märr ŋarra dhu dhuŋgur'yunna gurthan, ŋunhi ŋayi dhu nhärany bawalamirriwurra wäŋakurrnydja. Ye-e-e, wanha balaŋ ŋayi dhuwal ŋäthil yan nhäranha! ");
INSERT INTO djr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Galŋa-yätjinany ŋarra dhuwal mirithinan yan galŋa-ŋonuŋdhinan manapar, ga yan bili ga dhawar'yurr dhu boŋguŋ. ");
INSERT INTO djr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nhumany ŋuli ga guyaŋa yanbi ŋarrany ŋunhi marrtjin räliny, yanbi dhu ga ŋunhi yolŋuny walal nhina dhiyal munatha'ŋurnydja mägayan? Bäyŋu warray. Yolŋuny walal dhu ga ŋunhi ŋarrakalnydja yäkuy barrkuwatjkunhamirra. Yakan dhu ga ŋunhi bukmaktja djälthirr ŋarrakalaŋaw galkiwnydja nhinanharaw. ");
INSERT INTO djr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dhiyaŋuny bala gurruṯumirrnydja walal dhu ga ŋunhi mala-wulkmaranhamirra, ḻurrkun' yolŋu waŋganyŋur gali'ŋur, mak märrmany' dhu ŋunhala bala gali'ŋur, bitjanna dhu ga. ");
INSERT INTO djr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mak dhu ŋunhi bäpa'mirriŋuny dhiyala gali'ŋur ŋarrakala, ga gäthu'mirriŋuny nhanŋu dhu ŋunhala bala wiripuŋuŋura gali'ŋur. Nhä mak ŋayi dhu gäthu'mirriŋu nhanŋu ŋarrakalnydja gali'ŋur, ga ŋayiny mak dhu bäpa'mirriŋuny nhanŋu ŋunhala bala gali'ŋur, wiripuŋumin. Ga ŋäṉḏi'mirriŋuny dhu ga waŋganyŋur gali'ŋur, ga ŋayiny dhu mak yothuny miyalktja nhanŋu ŋunhala bala wiripuŋuŋura gali'ŋur. Ga ŋayi dhu mukul'mirriŋu waŋganyŋur gali'ŋur, ga ŋayiny dhu gäthu'mirriŋuny ga ŋunhala bala wiripuŋuŋura gali'ŋur. Yo, galkipuynha dhu ga ŋunhi gurruṯumirr walal bitjandhiny barrkuwatjkunhamirr, bili wiripuwurrnydja dhu ga ŋunhi djälthirr ŋarrakun malthunaraw, ga wiripuwurrnydja dhu ŋunhi bäyŋun ŋarraku malthun.” Ga bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ga wiripuny ŋayi Djesuy lakaraŋal bitjarra gam', “Ŋunhi nhuma ŋuli nhäma gurrŋan'thinyawuy maŋan dhiyal bala gali'-bärra'ŋur, bala nhuma ŋuli ŋunhi waŋany bitjanna, ‘Way, dhuwandja limurruny dhu dharyunna!’ Ga yuwalknha yan ŋayi ŋuli ŋunhi dharyundja. ");
INSERT INTO djr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ga wiripuny nhuma ŋuli dhäkay-ŋäma watany, ŋayi ŋuli galkirri beŋur bala gali'-djalathaŋŋur, bala nhuma ŋuli waŋan bitjanna, ‘Wäŋany dhu dhuwal gorrmur'yirra bäy?’ Bala yuwalknha ŋayi ŋuli ŋunhi gorrmuryirra wäŋany. ");
INSERT INTO djr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nhumany dhuwal dhä-warku'-ḏilkurr yan yolŋu walal. Ŋunhi nhuma ŋuli nhäma ŋunha djiwarrny'tja wäŋa ga dhuwandja munathany', bala nhuma ŋuli ga lakaranhamirra ga guyaŋany nhuma ŋuli ŋayi dhu ŋula nhän maḻŋ'thun, yanbi nhuma dhuwal ḻiya-djambatjnha mala. Yurr nhä nhuma dhuwal, dhuwal nhuma baḏak yan bambaymirr mala? Bili dhuŋamirr yan nhuma dhuwal, bäyŋu nhuma ga dharaŋan ŋunhi nhä mala marrtji maḻŋ'thunna dhiyaŋuny bala, ga nhä boŋguŋ ŋunhi maḻŋ'thurr yalalaŋumirriy.” ");
INSERT INTO djr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nhaku nhuma ŋuli gi dhuwal yakany guyaŋi ga mala-djarr'yurr nhä ŋunhi ŋamakurr ga dhunupa nhumalaŋ djämaw? ");
INSERT INTO djr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ga ŋuli ŋayi nhuna dhu ŋula yolthu marililnydja galkan romgurrnydja, nheny ŋathil ŋurruŋuny nhepi nhanŋu buni, ga waŋanhamirr maṉḏa dhunupayanhamirr ŋunhiyi djarrpi'kunhawuy nhumalaŋguŋ, biyakun ḻundukunhamirra maṉḏa, märr ŋayi dhu yaka muka nhuna gäma ŋärra'lilnydja. Ŋayi ŋuli bäynha nhuna ŋula ŋuriŋin ŋaḻapaḻyun romgu mala-djarr'yunamirriynha yolŋuy waŋi yätjkurr-lakaraŋun, bala ŋayi ŋuli goŋ-gurrupula nhuna balan ŋunhi ŋamakuli'ŋuwala, ga ŋayiny balaŋ nhuna galkurr dharruŋgulila. ");
INSERT INTO djr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ga ŋunhiliyin nhe dhu ga nhinany dharruŋguŋura, yakan yan nhe dhu ŋunhi beŋuryiny yänayiny dhawaṯthurr, ga bäy ŋathil nhe dhu gurrupul bukmak yan ŋula nhä malany buku-roŋanmaraŋ, yaŋara'-bakmaraŋ walalaŋ.” Bitjarra ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ga balanyamirriyyi waluy wiripuwurruynydja gan yolŋuy walal lakaraŋal Djesuwal bitjarrnha, “Ŋuriŋiny buŋgaway yäkuy Bäylitthuny* gan bumar rakunyguŋalnha yolŋunhany walalany wäŋa-Galalipuynhany mala, ŋuriŋi bili yan waluynydja ŋunhi walal gan mundhurr gurrupar God-Waŋarrwu warrakan'nha malaŋuny maŋgu', ŋunhiliyi djinawa' buku-ŋal'yunamirriŋur buṉbuŋur.” ");
INSERT INTO djr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ga ŋayiny Djesuny buku-bakmaraŋal balany walalaŋguny bitjarra, “Nhumany walalany ga guyaŋa ŋunhi walalnydja dhiŋgaŋal yanbi walal yätjkurra mirithirra muka? … wiripuwurruŋgalnydja wäŋa-Galalipuywal yolŋuwal walalaŋgal? ");
INSERT INTO djr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yurr bäyŋu warray. Märr-yuwalk ŋarra nhumalaŋ ga dhuwal lakaramany. Ŋuli nhuma dhu yakany bilyun nhumalaŋgal yätjkurruŋur romŋur, bala ganarrthaman ŋunhiyiny muŋbunumany, nhumany dhu bukmaknha dhiŋga'-dhiŋgaman bitjandhi bili yan nhakun ŋunhiwurryi ŋunhi yolŋu walal. ");
INSERT INTO djr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nhuma dhu guyaŋa ŋathil ŋunhiwurruny yolŋuny walalany 18-nha ŋunhi walal murrmurryurr ŋunhal wäŋaŋur Djurutjalam,* balanyamirriy waluy ŋunhi walalaŋ guṉḏa buku-wiyin dhuḻ'yunawuy yäku Djäylam buku-ḻarryurr, bala yan dhä-monyguŋalnha walalany. Nhä warray ŋunhiwurryiny dhiŋgaŋal? Nhumany mak ŋuli ga guyaŋa walalanhany, yanbi walalnydja gänan yätjkurra mirithirra wiripuwurruŋgalnydja ŋunhi wäŋa-Djurutjalambuywal yolŋuwal walalaŋgal, muka? ");
INSERT INTO djr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bäyŋu warray. Ŋarrany nhumalaŋ dhu dhuwal yuwalknha yan lakaramany. Ŋuli nhuma dhu dhuwal bäyŋuny bilyun nhumalaŋgiyingal nhuma yätjkurruŋur romŋur, bala ganarrthaman muŋbunuman, nhumany dhu boŋguŋ biyakiyi bili yan dhiŋgu'-dhiŋguŋ nhakun ŋunhiwurryi yolŋu walal.” Ga bitjarr ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bala ŋayi Djesuy dhuwandja dhäwu mayali'mirra lakaraŋal bitjarrnha gam', “Waŋgany yolŋu gätni-waṯaŋu gan nhinan, ga ŋunhiliyi nhanukal gätniŋurnydja gan dhärran dharpa gupa-borummirr. Ga waŋganymirrnydja ŋayi marrtjinan ŋunhiyin dharpan nhäŋal borumgun. Marrtjinany ŋayi ga-a-an, ga ŋunhi nhakun ŋayi nhäŋalnydja dharpany bäyŋu yan, waŋara borummiriw. ");
INSERT INTO djr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bala ŋayi waŋanan ŋurikalyiny djämamirriwalnydja nhanukiyingalaŋuwal ŋayi bitjarrnha, ‘Way, dhuwal ŋarra marrtjinany ḻurrkun'nha dhuŋgarrany mil'thurrnydja dhiyakuny borumguny, yan bäyŋu. Gatjuy djatthurra. Nhaku ŋayi ga dhuwal dharpa dhärra gupa-borummiriwnydja yänany waŋarany?’ ");
INSERT INTO djr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bala ŋayi djämamirrnydja waŋan bitjarrnha, ‘Ganarrthul ŋathil! Ŋayi dhu dhärra bulu waŋgany dhuŋgarra. Ŋarrany nhanŋu dhu ga djäga manymakkum dhiyakiyiny, munatha' ŋarra dhu ga yaw'yun ḻiw'maram, bala gapun ŋarra dhu ga rarryu'-rarryun, ga miniwany' muka ŋarra dhu djalkthun, ŋuthanmaramany ŋanya. ");
INSERT INTO djr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ga ŋuli ŋayi dhu ŋuthan borummirriyirrnydja dhiyaŋuny bala, ga ŋunhiyiny manymak warray. Ga ŋuli ŋayi dhu ga dhärra borummiriwnydja yan bitjandja bili, ga ŋunhiyin nhuŋu djatthunarawnydja.’” Ga bitjarr ŋayi gan Djesuy mayali'kurrnydja dhäwu lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ga waŋganymirrnydja waluy balanyamirriy ŋunhi Nhinanhamirriy, ŋayiny gan Djesuny nhinan ŋunhilin ŋunhi Djuw malawalnha buku-ḻuŋ'maranhamirriŋura buṉbuŋur, yurr ŋayi gan ŋunhi lakaraŋala marŋgikuŋala yolŋunhan walalany. ");
INSERT INTO djr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ga ŋunhiliyi buṉbuŋur gan waŋgany miyalk nhinan rerrimirr, yurr ŋayi gan ŋunhi rirrikthurrnydja wiyinŋumirra, 18-nha dhuŋgarrany, bili ŋuruŋiyi yätjkurruy birrimbirryu ŋanya gurrupar rerri ḏiltjilil; marrtjinany ŋayi gan ŋunhi ḏiltji-baḻwaḻyunan yan bitjarra bili, ga bäyŋun ŋayi ŋuli ganha dhärranha dhunupany. ");
INSERT INTO djr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bala ŋayi ŋunhi Djesuynydja nhäŋalnha ŋanya ŋunhiyi miyalknhany, bala ŋayi nhanŋu wäthurra, galkikuŋalnha ŋanya bitjarrnha, “Way miyalk, bilin nhe dhuwal dhiyaŋuny bala ḻayyurrnha beŋuryiny ŋunhi rerriŋurnydja,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bala ŋayi yan Djesuny goŋ-ŋal'yurra dhunupan ḏiltjilila nhanukal, bala yan ŋayi ŋunhiyiny miyalktja ḏiltjiny dhunupayinan, ga mirithinan nhakun ŋayi dhika buku-gurrparnydja, goŋmirriyinan manapar God-Waŋarrwuny. ");
INSERT INTO djr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bala ŋayiny ŋunhi ŋurruḏawalaŋuny gapman djägamirrnydja yolŋu ŋurikiyiny ŋunhi Djuw malawnydja buku-ḻuŋ'maranhamirriw buṉbuw mirithinan maḏakarritjthinany nhanŋu Djesuwnydja, bili ŋayi ŋunhi yolŋuny ḏukmaraŋal ŋuriŋiyin ŋunhi Nhinanhamirriynha waluynydja. Bala ŋayi ŋunhiyiny yolŋu waŋanany bukmakkun yolŋuwnydja walalaŋ bitjarrnha gam', “Waluny dhuwal djämawnydja waŋgany yan goŋ ga waŋgany bäythinyawuy. Ŋuli nhuma dhu ga ḏukmaranhaminyarawnydja nhumalaŋguwuy nhuma djälthirr, marrtjiny gi räliny dhipalnydja djämamirriy yan waluy. Ga nhinanhamirriynydja waluy nhe dhu yakan marrtji räli walŋakunharaw.” ");
INSERT INTO djr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bala ŋayipiny Garraynydja waŋanan buku-bakmaraŋal nhanŋu bitjarrnha, “Nhä nhuma dhuwal yolŋuny walal, rom gali'-märrma'? Ŋunhi balaŋ nhuŋu gi duŋ'ki nhä mak bulikiny dhärri garrpinawuynydja yan wäŋaŋurnydja nhokal, nheny balaŋ ŋunhi yakan rakiny' yapmaraŋ mayaŋŋurnydja nhanukal, ga gäŋuny ŋanya balany ŋunhi gapuwnydja gurrupanaraw ŋuriŋiyiny waluy Nhinanhamirriynydja? ");
INSERT INTO djr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ga dhuwandja ŋunhi miyalk beŋur warray yarraṯaŋur Yipurayimgal,* yurr ŋayi dhuwal ganydjarrpuynydja garrpinawuynydja mokuywuŋ, Djaytinguŋun yulŋuny, ŋayi ŋanya gan ŋayathaŋalnydja garrpirnydja wiyinnha, 18-nha dhuŋgarrany. Ga nhakun nhuma ga ŋarranhany gulmaram ŋunhi ŋarra dhu walŋakumany ŋanya dhuwal miyalknhany dhiyaŋuny ŋunhi Nhinanhamirriynydja waluy?” ");
INSERT INTO djr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ga dhiyaŋiyi dhärukthu nhanukiyingal ŋayi Djesuy gora-gurruparnydja ŋunhi, ŋunhiwurrunhany yolŋuny walalany ŋunhi walal gan rom-nyamir'yurr ŋanya Djesuny. Yurr wiripuwurrnydja yolŋu walal mirithinan goŋmirriyinan nhanukal Djesuwal, ŋunhi ŋayi gan djäma yindi mirithirr ganydjarr milkuŋal; latju' mirithirr dhika ŋula nhä malany gan maḻŋ'thurr nhanukalaŋuwurr. ");
INSERT INTO djr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ga bulu ŋayi Djesuy ŋäŋ'thurr bitjarr, “Nhäthinya dhika ŋunhi God-Waŋarrwuny rom? Yolkal ŋarra dhu ŋula munatha'wuywalnydja romlil mam'maram, dharaŋanarawnydja nhumalaŋ ");
INSERT INTO djr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","God-Waŋarrwuny dhuwal rom walŋa warray, ga ŋuthanamirr, balanya dhuwal nhakun ŋunhi genydja' nyumukuṉiny maŋutji borum. Yo. Genydjany' dhuwal maŋutji mirithirr nyumukuṉiny', ga ŋunhi ŋuli yolŋuynydja nhakun lämu-nhirrpandja ŋunhiyiny maŋutji munatha'lilnydja, bala ŋayi ŋuli ŋunhiyi maŋutjiny dhamany'tjunna, bala marrtji ŋuthanna yindithirra, bala walalnydja ŋuli warrakan'tja mala buṯthunna, bala marrtji nhinan ŋunhiwiliyiny dharpalil, ga djämany walal ŋuli wäŋan walalaŋguwuy walal yalun ŋunhiliny waṉaŋurnydja malaŋuŋur.” ");
INSERT INTO djr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ga bulu nhakun ŋayi Djesuy dhä-birrka'yurr bitjarr, “Nhaltjan bili ŋarra nhumalaŋgal dhu ŋunhi God-Waŋarrwuny rom dhuwurr-lakaram? ");
INSERT INTO djr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Balanya ŋayi dhuwal ŋunhiyiny rom nhakun miyalkthu ŋuli märram banikin', bala dharrwan ŋayi ŋuli ŋunhi rarryun ŋathany ŋunhiwiliyi banikin'lilnydja. Bala ŋayi ŋuli ŋunhi ŋathapuynydja ḏambakunhawuy djalkthun ḻurrkun'nha yan, mel-manapandja ŋunhiwiliyiny. Ga yaka wiyin, bala ŋayi ŋuli ŋunhi ŋathany ḏulul'yunna yindithirra ŋuli marrtji, wiripuŋuyirra, yurr ḏiku yan ŋunhi ŋathany.” Ga bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yo. Djesuny gan ŋunhi baḏak yan marrtjinany bala Djurutjalamlilnydja. Yurr gulŋi'-gulŋiyin ŋayi marrtjin wäŋalilnydja malaŋulil, bitjarr bili yan bala. Gärri'-gärrinany ŋayi marrtjin ŋunhi, marŋgikuŋal marrtjin yolŋuny walalany. ");
INSERT INTO djr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ga ŋayiny waŋganydhu yolŋuy ŋanya dhä-birrka'yurr bitjarr, “Way Garray, nhämunhan' dhu ŋunhi yolŋuny walŋathirr muŋbunumany? Märr-ḻurrkun' yan? Ŋany nhämunha', dharrwa mirithirr muka?” Bala ŋayiny Djesuynydja lakaraŋala nhanŋuny ŋurikiyiny yolŋuw balany bitjarra, ");
INSERT INTO djr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mirithi yan gi birrka'yurrnydja ŋurukuny ŋunhi gärrinyaraw Godkalaŋawnydja romgu, bili mirithirr ŋunhi nyumukuṉiny' dhurrwarany. Dharrwa warray dhu ga yolŋuny walal djälthirr gulŋiyinyarawnydja balany God-Waŋarrwalnydja wäŋalil, yurr yakan walal dhu ŋunhi gärriny, bili gumurr-ḏälnha nhakun walalaŋ ŋunhi balayiny gärrinyaraw. ");
INSERT INTO djr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bili ŋayiny dhu boŋguŋ ŋunhiyi wäŋa-waṯaŋuny yolŋu rur'yurrnydja, bala ŋayi dhu yan dhurrwarany gunguŋun. Mak nhumany dhu gi boŋguŋ ŋunhi dhärri'-dharriny ŋunhilin banydjin yan warraŋulnha, dhurrwaran mak nhuma dhu gi wutthu'-wutthurr, ga waŋiny nhuma dhu gi ŋunhi biyakun, ‘Way Garray! Ḻapmaraŋ ŋanapurruŋ dhurrwara!’ biyakun. Ga ŋayiny mak dhu ŋunhi buku-bakmaram nhumalaŋguny beŋurnydja djinawa'ŋurnydja biyakun, ‘Yaka ŋarra nhumalaŋ dhuwal marŋgi. Wanhaŋuwuy mala nhuma dhuwali?’ biyak. ");
INSERT INTO djr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ga nhumany dhu buku-bakmaraŋ balany nhanŋuny biyak, ‘Garray, bili muka napurr ŋunhi ŋathany ḻukan nhokal, ga gapuny. Ga marŋgikunhany nhe ŋuli ganha napurrunhany ŋunhal ŋunhi ŋanapurruŋgiyingal wäŋaŋur mala.’ ");
INSERT INTO djr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yurr ŋayiny dhu bulu boŋguŋ waŋi nhumalaŋguny biyakun, ‘Yakan dhuwal ŋarrany marŋgi nhumalaŋguny. Wanhaŋuwuy mala nhuma dhuwali? Gatjuy ḻatjuwarr'yurra walal ŋarrakalaŋaŋur, nhumany dhuwalawurryiny dhuwurr-yätjmirrnydja yolŋu walal bukmaknha yan.’ ");
INSERT INTO djr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Bala nhumany boŋguŋ gi ŋunhi ŋäthinyamirra mirithin yan, ḻirra-ḻawunhamirra manapul, bili nhumalanhany dhu ŋunhi djalkthurr balan ŋunhi warraŋullila, bili nhuma dhu boŋguŋ ŋunhi nhäŋun walalanhan Yipurayimnhan* ga Yitjaknhan* ga Djaykupnhan, ga wiripuwurruny ŋunhi djawarrkmirriny walalany, walal dhu gi ŋunhi nhininy ŋunhaliyin God-Waŋarrwalnha wäŋaŋurnydja. ");
INSERT INTO djr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yo. Yolŋuny walal dhu marrtji ŋunhi ḻuŋ'thurra bawalamirriŋura wäŋaŋurnydja malaŋuŋur ŋunhiwiliyin waŋganylila wäŋalilnydja; beŋur bala gali'-djalathaŋŋur, ga bärra'ŋur gali'ŋur, ga beŋur bala gali'-dhimurru'ŋur, ga ŋulaŋur bala ḻuŋgurrmaŋur gali'ŋur, gulŋiyin boŋguŋ marrtji dhaŋaŋnha God-Waŋarrwalnydja wäŋalil, bala marrtji dhu ŋathan ḻuki. ");
INSERT INTO djr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yo. Ga balanyamirriyyiny waluy boŋguŋ dhu ŋunhaliyiny ŋathamirriŋurnydja ŋurruŋuyiny ŋunhiwurrnha yolŋu walal ŋunhi nhuma ŋuli ga gali'puy lakaram walalany. Ga ŋunhiwurrnydja yolŋu walal ŋunhi walal ga dhiyaŋ bala ŋurruŋu dhärra, ga balanyamirriyyiny walalnydja dhu gi ŋunhiwurryiny dhuḏiŋun dhärri.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ga ŋuriŋi bili waluy yolŋu walal marrtjin ŋunhi Baratji mala, bala waŋanan ŋanya Djesuny bitjarrnha gam', “Way Garray, ganarrthaman nhe dhu dhuwandja wäŋa, bala marrtjin wiripuŋulila wäŋalil. Bili buŋgawany ŋunhi ŋurruḏawalaŋuny Yarittja yäku nhuŋu ga djälthirr bunharawnha.” ");
INSERT INTO djr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ga ŋayiny Djesuny waŋan bitjarr, “Gatjuy nhumany dhu lakaraman nhanukal ŋurikalyiny yolŋuwal ḻiya-dharrwawalnydja bitjanna, ‘Dhiyaŋuny bala waluy gäthurnydja ŋarrany dhu ga dhuwal djäman dhawaṯmaram ŋunhi wakinŋunhan birrimbirrnha malaŋuny yolŋuwalnydja walalaŋgal, ga rerrimirrinhany mala ŋarra dhu ga ḏukmaram. Ga boŋguŋ goḏarr' ŋarra dhu biyakiyi bili yan djäma. Ga ŋuriŋin bala wiripuŋuynha waluy, ŋunhiyiny ŋarra dhu goŋ-dhawar'yurra djämaŋurnydja.’ ");
INSERT INTO djr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yo. Marrtjinyarawnydja ŋarraku dhuwal dhiyaŋ bala gäthur ga boŋguŋ, ga ŋuriŋi bala waluy. Bili yaka dhuwal dhunupa God-Waŋarrwalaŋuwnydja djawarrkmirriw yolŋuw ŋayi dhu dhiŋgam ŋula bawalamirriŋurnydja wäŋaŋur ŋany ŋunhili bili yan ŋayi dhu dhiŋgam Djurutjalam yan.” ");
INSERT INTO djr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ga dhäŋur beŋuryiny ŋayi Djesu waŋan bitjarrnha, “Nhuma wäŋa-Djurutjalambuy yolŋu walal! Nhumany gan dhuwal bumar murrkay'kuŋal yan ŋunhi God-Waŋarrwuny djawarrkmirriny yolŋuny walalany, ga bitjarryi bili nhuma gan ŋunhi guṉḏaynydja bumar ŋunhiwurrunhany yolŋuny walalany ŋunhi ŋayi gan God-Waŋarryu djuy'yurr walalany nhumalaŋgal dhipaliyi. Yurr ŋarrapiny ga dhuwal mirithirr yan märryu-ḏapmaram ŋunhi Djurutjalamnhany wäŋany. Dharrwamirr muka ŋarra balaŋ ganha dhuwal nhumalany ḻuŋ'maranhany ŋarrakiyingalnydja ŋarra, bitjanan dhangi'yunan ganha nhumalany ŋarrakiyingalnha ŋarra waṉay, bitjan nhakun ŋuli ga ŋunhi gurrwawuy ḻuŋ'maram nhanŋuwuy ŋayi djamarrkuḻiny', ga binbarryuny ŋayi ŋuli ga galmuman ŋula nhäŋura malaŋuŋur. Yurr nhumany yaka warray gurrupanminya ŋarrakalnydja. ");
INSERT INTO djr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ŋarra balaŋ nhumalany ganha walŋakunha warray, yurr dhiyaŋuny bala ŋayi dhu God-Waŋarryuny ganarrthaman dhuwal nhumalaŋ buṉbuny buku-ŋal'yunawuynydja. Yakan nhuma dhu bulu nhäma ŋarranhany, yan bili ga walu ŋarraku dhu gilitji, ga balanyamirriyyin waluy nhuma dhu ŋunhi märr-dharaŋulnydja, gumurr-ŋamathiny manapul, bala nhuma dhu ŋunhi biyakuny waŋiny, ‘Dhuwanna ŋunhi yolŋuny marrtji ga yäkuynydja Garraywalnydja. Go limurr buku-ŋal'yunna nhanŋu.’” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja ŋunhi yalalaŋumirriwnydja waluw. ");
INSERT INTO djr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Waŋganydhu Nhinanhamirriy waluy, yolŋuy ŋurruḏawalaŋuy Baratjiy garr'yurr Djesuny nhanukiyingal ŋayi wäŋalil ŋathaw ḻukanharaw. Bala walalnydja gan wiripuwurrnydja yolŋu walal rukitjthinan nhanŋu Djesuw, yanbi balaŋ ŋayi djäma ŋula nhä yätjkurr. ");
INSERT INTO djr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bala ŋayiny waŋganynha yolŋu marrtjin rerrimirra nhanukal Djesuwal, waṉa-ḏulmuŋgurr'yunan ga yaŋara-ḏulmuŋgurr'yunna, rumbal-manapar ŋayi gan ŋunhi rirrikthurrnydja. ");
INSERT INTO djr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Bala ŋayi Djesuynydja waŋanan dhä-birrka'yurra ŋunhiwurrunhan ḏilkurruwurrunhan rom-marŋgikunhamirrinhan walalany ga Baratjinhan mala bitjarra, “Nhaltjan ga limurruŋguny rom waŋa? Muka manymak ŋunhi ŋarra dhu ga dhiyaŋuny ŋunhi waluy nhinanhamirriynydja ḏukmaram yolŋuny walalany? Ŋany nhä? … yakan muka?” ");
INSERT INTO djr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bala walalnydja marrtjin yänan ŋunhi ḏäpthurr muŋamuŋan dhärukmiriwnha. Bala yan ŋayiny Djesuynydja waṉan ŋayathaŋal ŋunhi yolŋunhan rerrimirrinhany, bala ŋanya ŋayi walŋakuŋalnha. Ga dhunupan yan ŋayi ŋanya djuy'yurra wäŋalila. ");
INSERT INTO djr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ga ŋayiny Djesuny waŋan walalaŋguny ŋurikiwurruŋguny ḏilkurruwurruŋguny bitjarrnha, “Ŋuli balaŋ nhumalaŋ yothu nhä mak bulikiny gulŋiyi maŋutjilil gapulilnydja balanyaraynydja ŋunhi Nhinanhamirriynydja waluy, yakan balaŋ nhumany ŋunhi warryurr ŋanya dhawaṯmaraŋuny walŋakuŋuny, bäydhi ŋunhi dhuyuynydja waluy?” Ga bitjarrnha ŋayi ŋunhi Djesuny waŋan walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bala walalnydja gan ŋunhi mukthurra yan nhinanany, waŋanhamiriwnha, bäyŋun walal ŋula dhäruktja maḻŋ'thuna waŋanha balany nhanŋuny buku-bakmaranha. ");
INSERT INTO djr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bala ŋayi Djesuynydja nhäŋalnha walalany ŋunhiwurrunhany yolŋuny walalany, ŋunhi walal marrtjin ŋunhiwiliyi wäŋalil ŋathaw ḻukanharaw. Walal marrtjin mala-djarr'yurr wäŋan mala nhinanharawnha, ga ŋunhi nhakun walal nhinanany ŋurikalnha yänan galkin wäŋa-waṯaŋuwalnha yolŋuwalnydja, ŋunhiwiliyi dharapullil ŋunhi ŋayi wäŋa-waṯaŋuy gänaŋ'maraŋal ŋula yolku balanyarawnha nhakun ŋurruŋuwnha yolŋuw. Bala ŋayiny Djesuny waŋan walalaŋgal bitjarrnha, ");
INSERT INTO djr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Way walal, ŋuli balaŋ nhumalany dhu yolŋuynydja garr'yun ŋathawnydja ḻukanharaw, yaka nhini balany ŋunhi ŋurruŋuwalnydja yolŋuwal walalaŋgal dharapul-djaw'yurr. Ŋayi ŋuli bäynha ŋula marrtji ŋunhi ŋurruŋun yolŋu, ŋunhi ŋayi ga djuḻkmaraman nhunanhany, ");
INSERT INTO djr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","bala ŋayiny dhu ŋunhiyiny yolŋu wäŋa-waṯaŋuny marrtjin, bala waŋany ŋayi dhu nhuna bitjanna, ‘Way, rur'yurra dhipuŋurnydja, ŋunhal bala nhini, bili dhuwandja wäŋa dharapul dhiyak yan yolŋuw ŋurruŋuw,’ bitjanna. Bala nheny dhu ŋunhi goran, bala nhe dhu dhathar'yunna, ga nhinany nhe dhu ŋunhala bala gali'ŋur. ");
INSERT INTO djr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yo. Ga ŋunhi nhe dhu gulŋiyirrnydja, yan nhe dhu marrtjiny nhinany ŋunhala bala gali'ŋurnydja wiripuŋumin, bala ŋayi dhu ŋunhi wäŋa-waṯaŋuny yolŋu marrtjin nhokal, ga waŋany ŋayi nhuna dhu bitjanna, ‘Way ḻundu rur'yurra, bala marrtjin biyakun bala, ŋurruŋuwala yolŋuwal dharapullilnydja nhini.’ Bala yurrnha dhu ŋunhi yolŋuynydja walal bukmakthuny nhämany nhuna dharaŋandja, bala dhu walal manymak-lakaraman nhuŋu. ");
INSERT INTO djr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bili ŋunhiyiny yolŋu ŋunhi ŋayi dhu ga garrwarkunhamirr ŋanyapinya ŋayi, God-Waŋarryuny ŋanya dhu ŋunhi nyilŋ'maraman ŋunhan ŋunhi ŋayaŋuny nhanŋu. Ga ŋuli ŋayi dhu ga ŋunhi yolŋu nyilŋ'maranhamirrnydja ŋanyapinya ŋayi, God-Waŋarryuny ŋanya dhu ŋunhiyiny yolŋuny rur'maraman garrwarkuman, bala dhu nhirrpanna ŋanya ŋunhawalnha ŋunhi garrwarlila.” Bitjarr ŋayi gan Djesuy lakaraŋalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bala ŋayi Djesuny bilyurra, ga waŋan ŋunhi wäŋa-waṯaŋunhan yolŋuny bitjarrnha, “Ŋuli nhe dhu ŋunhi ŋäthilmirriyamany ŋathany ga ŋula nhäny mala, yaka märraŋ yolŋunhany gurruṯumirrinhany yan nhuŋuwuy nhe, ga ŋula yolnhany yolŋuny ḻundu'mirriŋunhany nhuŋuwuy nhe, ga ŋunhi girri'-dharrwamirrinhany yolŋuny walalany; yaka walalany garr'yurr ŋunhiwiliyi, bili walalnydja dhu ŋunhi yalalany nhunanhany bitjandhi bili märram ŋathaw nyaŋ'thunaraw walalaŋgiyingalnydja wäŋalil. Ga bitjandhi bili dhu ŋunhi nhuŋuny yaŋara'-bakmaram walalnydja. ");
INSERT INTO djr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yo. Ŋunhi nhe dhu ŋäthilmirriyam ŋathany, marrtjiny nhe dhu ŋunhi, bala gaḏaymandja ŋunhiwurruny rerrimirrinhan ga bundhurrnhan malany yolŋu'-yulŋunhany, ga bambaymirrinhan, ga ŋurruwuykmirrinhan. ");
INSERT INTO djr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Maranhu-gurrupulnydja gi ŋunhiwurrunydhi yolŋunhany walalany, yolŋumiriwnhan malany ga djägamiriwnhan, bala nhepiny dhu galŋa-djulŋithirra. Bili ŋuriŋiwurruyyiny dhu yolŋuy walal yaka nhuŋuny yaŋara'-bakmaram. Yurr God-Waŋarryun dhu nhuŋuny ŋunhi buku-roŋanmaraŋ, balanyamirriynha waluy ŋunhi dhu gi dhuwurr-ŋamakuliny' yolŋu walal walŋathiny beŋur moluŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ga ŋayi waŋganydhu yolŋuy ŋanya Djesuny ŋäkul ŋunhi nhaltjarr ŋayi gan lakaraŋal walalaŋgal ŋunhiliyi ŋatha-ḻukanhamirriŋur bala'palaŋur. Ga waŋanany ŋayi nhanŋu Djesuwnydja bitjarrnha, “Ŋunhiwurrnydja yolŋu ŋunhi walal boŋguŋ ŋatha ḻuki ŋunhal God-Waŋarrwal wäŋaŋur, ŋunhiwurryin dhu ga mirithirrnydja ŋoy-djulŋithirr.” ");
INSERT INTO djr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Bala ŋayiny Djesuny buku-bakmaraŋala waŋanan dhärukthu mayali'mirriynha bitjarra, “Waŋganydhu yolŋuy guyaŋan ŋayi dhu ŋatha ŋäthilmirriyam djäma bukmakku yan yolŋuw walalaŋ. Bala ŋayi dhäwumirrinhan djuy'yurr wiripuwurruŋguny yolŋuw walalaŋ garr'yunarawnha, yurr ŋula nhämunhany' ŋunhi malany, walal dhu marrtji yalala ŋunhiwiliyi ŋuriki ŋathaw ḻukanharaw. ");
INSERT INTO djr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bala walal marrtjin djäman, ŋäthilmirriyaŋala ŋunhi ŋathan mala. Ga bulu nhakun ŋayi ŋuriŋiyi ḏirramuy djuy'yurr nhanŋuwuy ŋayi yolŋuny djämamirriny walalany ŋayi dhu marrtji ŋurukuwurruŋdhi bili yan yolŋuw walalaŋ ŋunhi ŋayi walalany ŋäthil gaḏaymar. Bala ŋayi ŋunhiyi djämamirrnydja yolŋu marrtjinan, ga waŋanany ŋayi bitjarrnha, ‘Go, ḻaw'yurra walal! Bili ŋunha ŋathany nhumalaŋ bilin ŋamaŋamayunawuynha ŋäthilmirriyanhawuynha ŋorran marrtji!’ bitjarr.” ");
INSERT INTO djr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Bala ŋunhiwurryiny yolŋuny walal bukmaknha waŋanany buku-bakmaraŋalnydja ŋurikiny djämamirriwnydja wiripun wiripun dhäruktja. Waŋganydja yolŋu waŋan yaka'yurr nhanŋu bitjarr, ‘Way marrkapmirr, bäydhi mak! Yakan ŋarrany dhu marrtji, bili ŋarra dhuwal märraŋalnydja rrupiyay manymaknha yan wäŋany ŋarakany. Dhuwandja ŋarra dhu marrtjin nhäman ŋunhan ŋunhi wäŋan ŋarrakuwuy ŋarra.’” ");
INSERT INTO djr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ga wiripuny yolŋu waŋan bitjarr, ‘Bäy-lakaraŋ ŋarraku? Yakan ŋarra dhu dhuwal marrtji, bili ŋarra ŋunha buliki' mala bäyim ŋarrakuwuy ŋarra gäthur, ŋarra dhu ga ŋunha djäman munathan' buḻŋu'kuman. Ŋarrany dhu marrtjin ga birrka'yunna ŋunhiyi bulikiny mala djämawnha.’” ");
INSERT INTO djr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ga wiripuny yolŋu waŋan bitjarr, ‘Ŋarrany barpuru dhuwal miyalk märram, ga dhiyaŋiyin ŋarra ga dhuwal ḻay-ḻayyundja,’ bitjarr.” ");
INSERT INTO djr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Bala ŋayiny ŋunhi djämamirrnydja yolŋu roŋiyinan, bala lakaraŋalnydja ŋurikin buŋgawa'mirriŋuwnydja yolŋuw bitjarrnha, ‘Ḻay-ḻayyunna walal ga ŋunha wiripuŋuynha wiripuŋuynha ŋula nhaliynha malaŋuy. Yakan walal dhu ŋunha marrtji räliny dhiyakuny ŋathawnydja ḻukanharaw ŋunhi nhe djäma ŋäthilmirriyaŋal walalaŋ.’ Bala ŋayiny ŋunhiyiny wäŋa-waṯaŋuny mirithinan ŋoy-dhärran, bala ŋayi waŋanan bitjarra, ‘Gatjuynha, dhipuŋurnydja nhe dhu marrtjin bondin yänan, ga garr'yurr ŋunhi bundhurrnhan malaŋuny yolŋuny walalany, ga ŋurruwuykmirrinhan, ga bambaymirrinhan yolŋu'-yulŋuny. Marrtjiny gi dhukarrkurrnydja bawalamirriwurr yan wäŋakurrnydja; ḻuŋ'maraŋuny marrtji ŋunhiwurrunhan bili yan yolŋunhany walalany ŋunhi walal ga nhina goŋ-gäna mala; walalnha dhu marrtjiny räliny dhiyakuny ŋathawnydja ḻukanharaw.’” ");
INSERT INTO djr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Marrtjinany ŋayi ŋunhi djämamirrnydja yolŋu, bala ḻuŋ'maraŋala marrtjin ŋunhin ŋurruwuykmirrinhan yolŋuny walalany dharrwanhan. Ga dhäŋur beŋuryiny nhakun ŋayi waŋan ŋurikin buŋgawawnha bitjarr, ‘Dharrwanhan ŋarra gan dhuwal yolŋunhany walalany ḻuŋ'maraŋalnydja, yurr dhuwal wiripuny dhaḻakarr ga dhärra bäynha bala bäythinyawuynydja.’” ");
INSERT INTO djr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ga bulu ŋayi ŋuriŋi buŋgawa'mirriŋuy djuy'yurr ŋanya ŋunhiyi djämamirriny nhanŋuwuy ŋayi bitjarr, ‘Gatjuy marrtjin bala yan wiripuŋulila ga wiripuŋulila wäŋalilnydja, mirithin yan waŋiny gaḏaymulnydja gi biyak bili yan gali'puynhan yolŋunhany walalany, walal dhu bukmaknha yan marrtjiny räli, ga bäy dhu dhuwal wäŋa ŋarraku dhaŋaŋdhirr yolŋuynha walal.’ ");
INSERT INTO djr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yo. Yuwalk muka ŋarra nhumalaŋ ga lakaramany dhuwal. Ŋunhiwurrnydja ŋäthiliŋuny ŋarrakuŋ garr'yunawuy yolŋu walal dhu yakan gulŋiyi ŋunhawalnydja ŋarrakalnydja wäŋalil; bäyŋun dhu waŋganydhuny beŋuryi malaŋur ŋatha ḻuki ŋarrakalnydja.” Ga bitjarrnha ŋayi gan Djesuny dhawar'maraŋalnydja waŋan. ");
INSERT INTO djr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Dhäŋur beŋurnydja ŋunhi ŋayi gan Djesu marrtjin räli dhukarr-ŋupar, yolŋu walal marrtjin dharrwa mirithirr malthurr nhanŋu. Bala ŋayi bilyurra ga waŋan bitjarra, ");
INSERT INTO djr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ŋuli nhe ŋula yol yuwalktja gi djälthi ŋarrakuny malthunaraw, nheny dhu ŋathil ŋunhiyiny ŋurruŋu-nhirrpandja ŋarrany, nhakun nhe dhu ŋunhiyiny ḏiltji-bilyuna ŋurikiwurruŋguny ŋunhi ŋäṉḏi'mirriŋuwnydja ga bäpa'mirriŋuwnydja nhokiyingalaŋaw nhe, ga galay'mirriŋuwnydja ga djamarrkuḻiwny'tja, wäwa'mirriŋuwnydja ga yapa'mirriŋuwnydja walalaŋ, ga bitjandhi bili nhe dhu ŋunhi ganandhi nhuŋuwuy nhe guyaŋanhawuynydja ŋunhi djälnydja. Ga ŋuli nhe dhu ga ŋunhi ŋurruŋuny dhäruk märram nhuŋuwuy nhe gurruṯumirrinhany walalany, ga malthun nhe dhu ga ŋunhi nhuŋuwuynydja yan nhe djälwu, ŋunhiyiny nhakun nhe yakan ŋarrakuny malthunamirr. ");
INSERT INTO djr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yo. Ga ŋuli nhe dhu ŋunhi bäyŋuny ganan nhuŋuwuy nhe djälnha, ga bäyŋuny nhe dhu ḻaw'maram dharpa nhuŋuwuy nhe mälakmaranhawuynydja, ga ŋuli nhe dhu ŋunhi yakany ga dhärukku malthun ŋarrakuny, ŋunhiyiny nhakun nhe balanyayiny yolŋu yakan yuwalktja ŋarrakuny malthunamirr.” ");
INSERT INTO djr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ŋunhi ŋayi ŋuli yolŋuy guyaŋa bitjandja, ŋayi dhu djäma wäŋa nhanŋuwuy ŋayi, ŋurruŋuny ŋathil ŋayi dhu ga nhina, bala bothurrun ŋayi dhu nhanŋuwuy ŋayi rrupiyan, nhämunha' nhanŋu ga rrupiya ŋorra, nhä gana' ga ŋorra, wo bäyŋu. Bitjandhi ŋathil ŋayi ŋuli ŋunhi ŋurruŋuny guyaŋa ŋuriŋiyiny yolŋuynydja, yurrnha ŋayi dhu ŋunhi ŋurruyirr'yundja dhuḻ'yundja, märr ŋayi dhu dhawar'maramany ŋunhiyi buṉbuny, ga yaka ŋula gandarrŋurnydja gulyun. ");
INSERT INTO djr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ŋuli ŋayi dhu ŋunhi ŋurruŋuny waŋgany yan ḻukuny nhirrpan, bala beŋuryiny nhanŋu dhu rrupiyany dhawar'yunna, bala walal dhu bukmakthuny yolŋuy walal nhäman ŋunhiyi, bala walalnydja dhu gitkitthunmirra nhanŋu, ga bitjanna walal dhu ŋunhi waŋany nhanŋu, ");
INSERT INTO djr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Dhiyaŋuny muka ŋunhi yolŋuy ŋurruyirr'yurr wäŋaw dhuḻ'yunaraw, yurr yakan ŋayi dhu ŋunhiyi dhawar'maramany. Wanhan dhika be nhanŋu wäŋany manymaktja yuṯany?’” ");
INSERT INTO djr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Yo. Ga ŋuli ŋayi dhu ŋuriŋiyi buŋgawaynydja ŋurruḏawalaŋuynydja ŋämany wiripuŋunhany buŋgawany, ŋunhi ŋayi dhu ga marrtji räli dharrwamirr dhika mirithirr ŋapa-miriŋumirr, ga ŋurruŋuny ŋathil ŋayi dhu ŋunhiyi buŋgawany nhina, ga mala-djarr'yun, ga bothurru' nhanŋuwuy ŋayi miriŋuny malany. ");
INSERT INTO djr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ga ŋuli ŋayi dhu maḻŋ'maram nhanŋuwuynydja ŋayi malany märr ḻurrkun'tja, ŋunhiyiny mak ŋayi dhu ga yakan marrtji balany marililnydja; gulyunna ŋayi dhu. Yan ŋayi dhu djuy'yunna dhäwumirrinhan ŋurukuny bala ŋunhi wiripuŋuwnydja buŋgawaw balanyarawyiny bili ŋapa-malamirriw, ŋunhi ŋayiny be muka banydji yan ḏapthun ga baḏak, bala ŋayi dhu ŋunhi bitjanna dhäruk-gurrupanmirrnydja, ‘Wäy, ŋali ḻundukunhamirra ŋani? Yakan ŋaliny dhu ga bunhamirr,’ bitjanna.” ");
INSERT INTO djr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bala ŋayi Djesuy bitjarrnha dhawar'maraŋalnydja lakaraŋal, “Yo. Yaka balaŋ nhuma ŋarraku ŋunhi malthuna guyaŋanhamiriwnydja. Guyaŋi ŋathil gi mala-djarr'yurr, märr nhe dhu ŋunhi malthundja ŋarraku, ga yakan ḏaḏawyundja ŋula gandarrŋurnydja. Ŋuli nhe dhu bäyŋuny ganan ŋunhi bukmak nhä malany ŋunhi nhe ga ŋayatham, ŋunhiyiny nhe nhakun yakan ŋarrakuny yuwalktja malthunamirr.” ");
INSERT INTO djr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Yo. Dje'lany dhuwal manymak mirithirr, dhiyaŋuny ŋuli ga ŋunhi ŋathanhan dhäkay-manymakkum. Ga ŋuli dhu ŋunhi dje'lany dhäkaymiriwyirr, ga ŋunhiyiny ŋula nhä nhakun yätjkurra, makinynha, yakan dhu ŋula yolthu buluny dhäkaymirriyam ŋunhiyi, ŋunhi ŋayi dhu dhäkaynydja ŋula winya'yun. ");
INSERT INTO djr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yo, dje'lany ŋunhi ŋayi dhu dhäkaymiriwyirra, ŋunhiny nhäŋiniŋ'nha. Bäyŋun mak dhu yolŋuy märram ga rulwaŋdhun gätnililnydja miniwa'kumany; yänan bala ŋayi dhu djalkthuna. Ŋäkuny ŋamathaŋun ŋuli balaŋ nhe buthurumirrnydja, ga maḻŋ'maraŋuny ŋunha djinawa'wuynha ŋunhi mayaliny'.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Waŋganydhuny waluy dharrwa yolŋu walal dhuwurr-yätjmirr mala ga rrupiya-märranhamirr yolŋu walal marrtjin ḻuŋ'thurr nhanukal Djesuwal, bili yan walal gan ŋunhi djälthin ŋänharaw nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ga walalnydja gan ŋunhi Baratjiny walal ga rom-marŋgikunhamirrnydja mala morrumurrun nhanŋuny Djesuwnydja, ga waŋanhaminany walal marrtjin yawyawyunminan, bitjanminan gam', “Nhaku ŋayi ŋuli ga dhuwal walalaŋ gumurr-ŋamathirrnydja ŋurukuwurruŋguny ŋunhi dhuwurr-yätjmirriwnydja yolŋuw walalaŋ? Wiripuny muka ŋayi ŋuli ga dhuwal marrtji ga ŋatha ḻuka walalaŋgal wäŋaŋur. Nhä ŋayi ŋunha yätjkurrnydja yolŋu.” ");
INSERT INTO djr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bala ŋayi Djesuynydja lakaraŋala walalaŋgal mayali'kurrnha dhäwun' bitjarrnha gam, ");
INSERT INTO djr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ŋuli balaŋ dhu ga warrakan'-djägamirriy yolŋuy ŋayatham 100-tja namba bimbiny mala, ga waŋganydja dhu nhanukal ŋunhi winya'yunna, bala nhaltjanna ŋayiny dhu ŋunhi? Dhunupan ŋayi dhu ganarrthaman wiripuwurrunhany ŋunhi bimbiny malany ŋunhiwilin wäŋalil mulmumirrilila, bala ŋayi dhu yan ḻarruman ŋurikiny ŋunhi waŋganygun winya'yunawuywun. Ḻarrumany ŋayi dhu ga ŋunhi, ga yan bili-i-i ga maḻŋ'maram yan ŋayi dhu ŋunhi waŋganynhany winya'yunawuynhany. ");
INSERT INTO djr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ga ŋunhi ŋayi dhu maḻŋ'maramany, bala ŋayi dhu galŋa-djulŋithirrnydja mirithirra dhikan, ga ḻaw'maramany ŋayi dhu ŋunhi ŋanya ḻambarryu nhanukiyingal ŋayi, ");
INSERT INTO djr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","bala ŋayi dhu gäman wäŋalila roŋiyirra. Bala ŋayi dhu wäthunna nhanukiyingalawnha ŋayi ḻundu'mirriŋuwnha mala, ga gurruṯumirriwnydja walalaŋ, ga bitjanna ŋayi dhu ŋunhi waŋany, ‘Go, limurr ŋoy-djulŋithirra walal, bili dhuwanna ŋarraku ŋunhi bimbiny winya'yunawuynydja, dhuwanna bilin maḻŋ'maraŋalnha ŋarra. Go limurr galŋa-djulŋithirra, burr'yunna manapan buŋgulnha djäma nhanŋu.’” ");
INSERT INTO djr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bala ŋayi Djesuy dhawar'maraŋalnydja waŋan bitjarrnha, “Märr-yuwalknha ŋarra nhumalaŋ dhu dhuwandja lakaram. Ŋunha djiwarr'ŋurnydja God-Waŋarrwuny yolŋu walal ga ŋoy-djulŋithirra 99-guny dhuwurr-dhunupamirriwnydja yolŋuw mala ŋunhi walal ga nhina ŋunha nhanukal Garraywal goŋŋur, yurr mirithirrnydja walal dhu ga ŋunha goŋmirriyirr ŋurikin bili yan waŋganygun dhuwurr-yätjkurruwnha yan yolŋuwnydja, ŋunhi ŋayi bilin bilyurra yätjkurruŋurnydja romŋur nhanukiyingal ŋayi.” ");
INSERT INTO djr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Bala ŋayi Djesuy lakaraŋal wiripuny muka dhäwu mayali'kurryi yan bitjarr, “Wiripuny gan miyalk nhinan, yurr ŋunhi mel-wiḏi'mirrnydja mala guṉḏa mala nhanŋu goŋ-märrma'. Ga ŋunhi nhakun nhanŋu dhu waŋganydja ŋula mel-wiḏi'mirr guṉḏa winya'yun, bala nhaltjanna ŋayiny dhu? Ŋayiny dhu ŋunhi dhunupan dhuŋgur'yunna lanhdhirran, bala yan ŋayi dhu ḻarruman ga, ga riwaḻ'yundja muka ŋayi dhu warrpam'thun yan, ga yan bili-i-i, ga maḻŋ'maram yan ŋayi dhu dhäkay ŋunhiyi waŋgany mel-wiḏi'mirr guṉḏa. ");
INSERT INTO djr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bala ŋayi dhu dhunupan wäthunna nhanukiyingalawnha ŋayi gurruṯumirriwnha walalaŋ ga ḻundu'mirriŋuwnha walalaŋ. Ga bitjanna ŋayi dhu ŋunhi waŋany, ‘Go ŋoy-djulŋithin walal ŋarrakuny, bili dhuwal ŋarra rrupiyany ŋarakany winya'yunawuynydja bilin maḻŋ'maraŋala. Go limurr goŋmirriyirra, ḏar'ṯaryunna, buŋgulnha manapan djäma.’” ");
INSERT INTO djr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Ga yuwalk ŋarra nhumalaŋ ga dhuwal lakaramany. Ŋunha djiwarr'ŋurnydja God-Waŋarrwuny ŋunhi dhäwu-gänhamirrnydja yolŋu walal ga mirithirra yan goŋmirriyirr ŋurikiyiny yolŋuw ŋunhi ŋayi ŋuli ŋula yol waŋgany yolŋu bilyun nhanukiyingal ŋayi yätjkurruŋur romŋur, bala marrtjin roŋiyirra balan God-Waŋarrwalnha goŋlil.” ");
INSERT INTO djr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ga bitjarryi bili ŋayi Djesuy lakaraŋalyi wiripuny muka dhäwu bitjarr gam', “Waŋgany ḏirramu gan nhinan, yurr gäthu'mirriŋuny maṉḏa nhanŋu ŋuriki märrma'. ");
INSERT INTO djr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Waŋganymirrnydja ŋayi ŋuriŋiyi malpuraynydja waŋanan ŋanya bäpa'mirriŋunhany bitjarra, ‘Way Mäḻu', ŋarrakuny nhe dhu mala-wulkmaraman rrupiya, ga wiripu nhä mala nhe ga ŋayatham. Dhiyaŋun bala yan nhe dhu ŋarrakuny gurrupan.’ Bala ŋayi marrtjin ŋunhi bäpa'mirriŋuynydja mala-wulkmaraŋala ŋunhiyi nhäny mala, bala yan gurrupara nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ga märr gurriri dhäŋur beŋuryiny, bala ŋayi ŋuriŋi ḏirramuynydja gäthu'mirriŋuynydja waŋgany-mana'-manaparnydja marrtjin ḻuŋ'maraŋalnydja ŋula nhän mala ŋunhi nhanŋuwuy ŋayi, bala yan ŋayi dhunupan marrtjinan wiripuŋulila wäŋalil barrkulila. Ga ŋunhiliyin wiripuŋumin wäŋaŋur, bala ŋayi yan djalkthurra gan ŋula nhäny mala ŋunhi nhanŋuwuynydja ŋayi, nhakun ŋänitji'ŋurnha ga miyalkkurruwurruŋgalnha ga ŋula nhäŋura mala, ga yan bili ga rrupiya nhanŋu warrpam'thurr dhawar'yurr.” ");
INSERT INTO djr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Ga dhäŋur beŋuryiny ŋunhiyiny wäŋa räwakthinan baṉḏanydhinan gapumiriwyinan, ga wiripuny ŋathan walalaŋ marrtjin dhawar'yurr, ga ŋayi ŋunhiyiny ḏirramu mirithinan djanŋarrthin, galki balaŋ ŋayi dhiŋganhan. ");
INSERT INTO djr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bala ŋayi marrtjin ŋäŋthu'-ŋaŋthurra djämawnha. Ga ŋayiny waŋganydhuny yolŋuy wäŋa-nininyŋuy gurrupar nhanŋu djäman, ga bitjarr ŋayi nhanŋu ŋunhi waŋanany, ‘Djämany nhuŋu dhuwal, djäga nhe dhu ga bikipikiw malaŋuw ŋarrakalaŋaw,’ bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yurr ŋayiny ŋunhi ḏirramuny mirithinan dhika djaṉŋarrthinany, bala ŋayi guyaŋanany ŋunhan bikipikiwnha ŋathany ḻukanharawnydja, märr ŋayi dhu maranhukunhamirr, bili bäyŋun nhanŋu ŋunhi ŋula yolŋuynydja gurrupanna ŋathany ḻukanharawnydja.” ");
INSERT INTO djr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Waŋganymirrnydja ŋayi gan ŋunhi nhinanan guyaŋanan, bala ŋayi gan ḻiya-ŋarrtjunminan ŋanyapinya ŋayi. Ga bitjarrnha ŋayi gan ŋunhi guyaŋanany, ‘Yä-ä-ä! Nhä ŋarra dhuwal bawa'mirr? Ŋunha ŋarrakalaŋuwalnydja bäpawal wäŋaŋur ŋula nhämunha' warray djämamirr walal ga nhinany walal ga ŋunha maranhun yan, walalaŋguny ŋunha ŋatha dharrwan mirithirra. Ga dhuwanna ŋarrany ga nhina djaṉŋarrnha, dhäparŋ'nha yan, galki ŋarra dhu dhuwal dhiŋgaman. ");
INSERT INTO djr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ŋarrany dhu dhuwal rur'yunna, bala ŋarra dhu marrtjin roŋiyirra balan bäpa'mirriŋuwalnha ŋarrakalaŋuwal, ga waŋany ŋarra dhu nhanŋu bitjanna, Mäḻu', djämany ŋarra dhuwal yätjkurra mirithirra djarrpin', ŋayaŋu-miḏikumarnydja God-Waŋarrnhany ga nhunanhany. ");
INSERT INTO djr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yakan ŋarrany nhe dhu buluny gurrpan gäthu'yundja, bili ŋarrapiny dhuwal mirithirra dhuwurr-yätjkurra. Ga nhinany ŋarra dhu ga dhuwal dhiyalnydja djämamirra yan nhuŋun.’ Ga bitjarryiny ŋayi gan ŋunhi ŋuriŋiyi ḏirramuynydja guyaŋanany. ");
INSERT INTO djr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bala ŋayi yan dhunupan rur'yurra, bala marrtjinan roŋiyinan bäpa'mirriŋuwalnha nhanukiyingalaŋuwal ŋayi.” “Yo, marrtjinany ŋayi gan bala-a-a, ga ŋunhi nhakun ŋayi marrtjin gumurr-galkithinany wäŋany, bala ŋayiny ŋanya bäpa'mirriŋuynydja nhäŋal barrkulil warray, winy'kaḻalil, ŋayi gan marrtjin räli, roŋiyinan wäŋalila. Bala ŋayi bäpa'mirriŋuny nhanŋu mirithinan ŋayaŋu-gurrupurumirriyinany, bala ŋayi waṉḏinan gumurr'yurra nhanŋu, ga dhunupan ŋayi ŋanya dhangi'yurra wälkuŋalnha manapar. ");
INSERT INTO djr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ga ŋayiny ŋunhi gäthu'mirriŋuny nhanŋu waŋan bitjarra, ‘Mäḻu', yätjkurra mirithirra ŋarra dhuwal yolŋuny. Djämany ŋarra gan yätjkurra djarrpin' mirithirra, ŋayaŋu-wutthurrnydja God-Waŋarrnhany ga nhunanhany. Yakan nhe ŋarrany dhu ga buluny gurrpan gäthu'yundja,’ bitjarr.” ");
INSERT INTO djr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Yurr ŋayiny nhanŋu ŋunhi bäpa'mirriŋuny wäthurra nhanukiyingalaŋaw djämamirriwnydja walalaŋ bitjarr, ‘Bondi go! Gäŋu walal nhanŋu manymaknha yan girriny', bala nhirrpula nhanukal, ga goŋbuynydja girri' bulaynydja nhanukal nhirrpulyi, ga ḻukulilnydja dhapathuŋ'nha. ");
INSERT INTO djr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bondi marrtji, ga wutthurr djukurr'mirr yan warrakan'tja bulikiny, bala bathulnha. Limurr dhu ḻukan, goŋmirriyirra manapan, buŋgulnha djäma. ");
INSERT INTO djr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ŋarrapiny dhuwal mirithinan yan märr-ŋamathinany, bili ŋarraku dhuwal gäthu'mirriŋuny bili muka dhiŋgaŋal, ga dhuwanna ŋayi walŋathindhi bulu. Winya'yurr ŋayi ŋarrakal, ga buluyi ŋayi dhuwal roŋiyindhi ŋarrakal.’ Bala walal gan ḻukanan ŋoy-djulŋithinan dhikan mirithinan, manikaynha ḏar'ṯaryurr buŋgulnha manapar djäma.” ");
INSERT INTO djr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ga ŋayiny ŋunhi wiripuny gäthu'mirriŋu nhanŋu maḻamarrnydja gan baḏak yan ḏapthurr djämaŋur, yurr märr barrku ŋunhiyi wäŋany beŋuryiny, ga yaka ŋayi marŋgi ŋurikiyiny nhanukiyingalaŋaw ŋayi yukuyuku'mirriŋuwnydja ŋunhi ŋayi roŋiyinany. Ga ŋunhi nhakun ŋayi marrtjin roŋiyinany balany wäŋalilnydja, bala ŋayi yan ŋäkulnha rirrakaynha, walal gan ḏar'ṯaryurra manikaynha, giritjinan manapar, goŋmirriyinan dhika. ");
INSERT INTO djr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bala ŋayi dhä-birrka'yurra waŋganynhan djämamirriny bitjarra, ‘Way, nhaltjan walal ga dhuwandja?’ ");
INSERT INTO djr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ga ŋayiny ŋuriŋiny djämamirriynydja lakaraŋal bitjarr, ‘Ŋunhi muka yukuyuku'mirriŋu nhuŋu bilin dhuwanna roŋiyinan, ga ŋunha bäpa'mirriŋuynydja nhumalaŋgal wutthurrnydja djukurr'mirra dhulthulnha warrakan'tja, bili ŋayi märr-ŋamathin nhanŋu mirithin, ŋunhi ŋayi roŋiyin walŋa yan dhuwal.’” ");
INSERT INTO djr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Bala ŋayiny ŋunhiyiny maḻamarrnydja gäthu'mirriŋu nhanŋu mirithinan maḏakarritjthin, yakan ŋayi marrtjinya ga gulŋiyinya ŋunhiwiliyiny buṉbulil. Bala ŋayiny ŋunhi bäpa'mirriŋuynydja guwatjmara ŋanya, ga waŋan ŋayi ŋanya bitjarr, ‘Go marrtji rälin. Limurr ŋoy-djulŋithirra ŋurukun yukuyuku'mirriŋuwnha nhokalaŋaw,’ bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ga ŋayiny ŋunhiyiny maḻamarrnydja waŋan bitjarr, ‘Yakan. Beŋur bili ŋarrany gan nhinan dhiyal, ga djäma ŋarra gan nhuŋu, nhakun ŋarrany ḏapmaranhawuynha yolŋu. Bitjana bili ŋarra ŋuli ganha dhäruk-märranha yan nhuna, ga yaka ŋarra waṉḏinya ganarrthanha nhuna. Ga ŋula nhä nhe gurrupana ŋarrakuny buŋgul bäyŋu. Yaka nhe ŋula nhä nyumukuṉiny' nanikut wutthuna ŋarrakuny, märr balaŋ ŋarrany goŋmirriyinya muka ŋarrakalaŋawnydja ḻundu'mirriŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ga dhuwaliyi nhuŋu gäthu'mirriŋu, ŋayiny gan djalkthurr bukmak nhä malany nhuŋu; djalkthurrnydja ŋayi gan ŋunhiyi miyalkkurruwurruŋgal yätjkurruwalnha, nhakun ŋayi gan djalimnha. Ga dhuwandja ŋayi roŋiyinany räliny, bala nheny nhanŋu warrakan'nhan wutthurr dhulthulnha yan djukurr'mirra.’” ");
INSERT INTO djr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Bala ŋayiny ŋunhi bäpa'mirriŋuny waŋan nhanŋu bitjarra, ‘Gäthu ŋarraku marrkapmirr! Nheny ŋuli ga dharraḏa warray nhina dhiyal ŋarrakal bitjan bili yan, ga bukmak dhuwal nhä malany ŋarra ga ŋayatham nhuŋuwuy yan warrpam'. ");
INSERT INTO djr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Manymak dhuwal limurruŋ balanyarawyiny, limurr dhu ga goŋmirriyirrnydja, ŋayaŋu-djulŋithirr ŋuriki nhokalaŋaw yukuyuku'mirriŋuw, bili ŋayiny ŋunhi bili muka dhiŋgaŋal, yurr dhuwanna ŋayi bulu nhakun walŋathindhi. Ŋunhi ŋayi bili muka winya'yurr, ga bulu ŋayi dhuwal roŋiyindhi.’ Ga bitjarr ŋayi gan ŋunhi bäpa'mirriŋuny waŋan.” Ga dhuwaliyiny gan ŋunhi mayali'wurrnydja dhäwu lakaraŋal Djesuynha. ");
INSERT INTO djr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yo. Bala ŋayi Djesuynydja dhäwuny' lakaraŋala nhanukiyingalaŋuwalnydja ŋayi malthunamirriwalnydja walalaŋgal, dhuwandja ŋunhi dhäwu gam', “Waŋganydja yolŋu gan nhinan girri'-dharrwamirr, bala ŋayi yan gurruparnydja djägalilnydja waŋganygala yolŋuwal djämamirriwalnha bukmak nhanŋuwuy ŋayi girriny' mala, wäŋany ŋarakany, rrupiyany ga ŋula nhäny mala nhanŋuwuy ŋayi. Ga waŋganymirrnydja waluy ŋayi ŋuriŋi yolŋuy girri'-dharrwamirriynydja ŋäkulnha ŋanya ŋunhiyi djägamirrinhany yolŋuny, ŋayi gan djalkthurra nhanŋu rrupiyany ŋula nhäŋur malaŋuŋur. ");
INSERT INTO djr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bala ŋayi buŋgawa'mirriŋuny ŋunhi wäthurra nhanŋu ŋuriki djämamirriwnydja yolŋuw, bala waŋanan bitjarrnha, ‘Ŋäma'-ŋama ŋarra ŋuli ga dhuwal dhäwuny' nhokalaŋawuy. Gatjuynha, nheny dhu märraman ŋunhiyi rrupiyawuynydja djorrany' rälin ŋarrakalnha, märr ŋarra nhokal dhu maḻŋ'maram, nhaltjarr nhe gan ŋunhiyi djäma ŋuriŋiyi rrupiyay ŋunhi ŋarra märr-nhirrpanmin nhokal djägalil. Ŋarrakuny dhu rrupiya ga ŋula nhä malany yakan buluny nhokalnydja djägaŋur.’ ");
INSERT INTO djr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bala ŋayi gan ŋuriŋi djägamirriynydja guyaŋanany bitjarrnha, ‘Nhaltjanna ŋarra dhu dhuwal? Buŋgawaynydja ŋarrakal ŋarrany dhu dhuwal dhawaṯmaraman beŋuryiny djämaŋurnydja. Nhän dhika ŋarra dhu buluny djäma? Yaka ŋarra dhu gi dhuwal munathany' yaw'yurr, bili ŋarra dhuwal yalŋgin. Ŋunhi ŋarra dhu ga dhuwal baḻ'yundja wiripuwurruŋguny yolŋuw walalaŋ ŋula nhaku rrupiyaw ga ŋathaw, ŋunhiyiny nhakun ŋarra dhu ga mirithirra gora.’ Ga bitjarra ŋayi gan ŋunhi guyaŋanany, ga yan bili-i-i, ga maḻŋ'maraŋal yan ŋayi guyaŋanharay. ");
INSERT INTO djr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‘Yo,’ bitjarr. ‘Dhiyaŋuny bala ŋarra dhu gi ŋunhi mukthurra ŋayathul nhanŋu ŋunhi nhäny mala ŋarrakiyingalyi yan djägaŋur, ŋarra dhu gi djäman ŋuriŋiyiny nhanukalnydja rrupiyay, guŋga'yurra dhu gi ŋunha wiripuwurrunhan yolŋuny walalany, nhakun dhu gi ḻundukuŋun galkikuŋun walalany, märr dhu ŋunhi yalalany ŋarrakuwuynydja djämany dhawar'yurr, bala walalnydja dhu ŋunhi wiripuwurrnydja gumurr-ŋamathiyi muka ŋarrakuny ŋunhal walalaŋgiyingalnydja wäŋalil.’ Bitjarra ŋayi gan ŋunhi guyaŋanany ŋuriŋiyiny djämamirriynydja yolŋuy.” ");
INSERT INTO djr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Bala dhunupan ŋayi djuy'yurra yolŋuwnydja walalaŋ dhäwun', bukmakku yan ŋurikiwurruŋguny ŋunhi walal gan ŋäthil märraŋal rrupiya ga ŋula nhä malany nhanukalaŋuwal buŋgawa'mirriŋuwal, ga baḏak walal ŋanya gan ŋunhi yulŋuny dhukarrarrayurr, bäyŋu yan walal buku-roŋanmaranhany balany nhanŋuny ŋunhiŋuwuyyiny. Bala ŋayi waŋganynhan ḏirramuny dhä-birrka'yurr bitjarrnha gam', ‘Nhä muka nheny märraŋal ŋarrakalaŋuwuŋ buŋgawa'mirriŋuwuŋuny? Ga nhämunha' nhe rrupiyany gombuŋal ŋanya?’ ");
INSERT INTO djr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ga ŋayiny buku-bakmaraŋal bitjarr, ‘Ŋarrany ŋanya ga dhuwal baḏak dhukarrarrayun yan 100 banikin'mirr wiyika. Bäyŋu yan ŋarra nhanŋu gurrupulnydja buku-roŋanmaraŋuny.’ Bala ŋayiny ŋunhi djägamirrnydja yolŋu waŋan bitjarrnha, ‘Go dhiyala nhininy bala wukirrin dhipal djorra'lilnha nhanŋuny, märr nhe dhu ŋanya gurrupandja ḻurrkun'nha, 50 yan namba banikin'mirrnydja mala wiyikany'. Ga wiripuny mala ŋarra bäy-lakaraŋalnha, ganarrthaŋala.’” ");
INSERT INTO djr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ga bulu ŋayi dhä-birrka'yurr wiripuŋunhany ḏirramuny bitjarr, ‘Nhämunha' muka nheny ŋanya gombuŋal? Ga nhämunha' nheny dhu nhanŋuny balany gurrupan buku-bakmaramany?’ Ga ŋayiny waŋan bitjarr, ‘Ŋarrany ŋanya ga dhuwal baḏak dhukarrarrayun dharrwa mirithirr, 1,000 gärruŋmirr birrali,’ bitjarr. ‘Ga go, nheny dhu bitjandhi bili yan dhipal nhina, ga wukirriny nhe dhu ŋunhi dhipala djorra'lila märr ḻurrkun'nha nambany, 800-nha. Dhuwalin bili yan ganan'.’ Ga bitjarrnha ŋayiny ŋunhiyiny djägamirrnydja yolŋu waŋan. Bitjarrnha bili ŋayi marrtjin bala dhä-birrka'yurrnydja yolŋunhany walalany, gombu'-gombuŋalnydja märr ḻurrku'-ḻurrkun'nha.” ");
INSERT INTO djr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Yo. Ŋayiny ŋunhiyiny djägamirrnydja yolŋu nhawi nhakun dhuwurr-djarrpi' yolŋu, yaka ŋayi ganha djäma dhunupa. Yurr ŋunhiyiny yolŋu buŋgawa'mirriŋuny wokthurr nhanŋu gan, bili ŋayi ŋunhi mirithirr yolŋuny ḻiya-djambatj djämawnydja, bäydhi ŋayi ŋunhi dhuwurr-djarrpiny' yolŋu. Bili dhuwalaŋuwuyyuny yolŋuy walal ŋuli ga munatha'wuyyuny djäma walalaŋgiyingalnydja walal ḻiya-djambatjthun, märr walal dhu ga nhinany goŋmirriyirra dhikan dhiyal munatha'ŋurnydja. Yo. Ḻiya-djambatjthun walal ŋuli ga djämany, djuḻkmaraman walal ŋuli ga ŋunhi God-Waŋarrwuny yolŋuny walalany, ŋunhi walal ŋuli ga nhina baḏayala'mirriŋurnydja.” ");
INSERT INTO djr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ga bulu ŋayi Djesu waŋan bitjarr, “Yuwalknha yan ŋarra nhumalaŋ dhu dhuwandja lakaram. Dhuwandja rrupiyany dhuwalaŋuwuy banydjiŋuwuy munatha'wuy wäŋapuy. Dhiyaŋiyi rrupiyaynydja nhokiyingal nhe, nheny dhu ga guŋga'yunna ḻunduthirra ŋunha ŋunhi wiripuwurruŋguny yolŋuw walalaŋ. Ga yalalany ŋunhi nhuŋu dhu rrupiyan dhawar'yun dhiyal, bala walalnydja ŋunhiwurrnydja yolŋu walal ŋunhi walal ga ŋäthil ŋunha djiwarr'ŋur nhina, walalnydja nhuŋu dhu gumurr-ŋamathirra ŋunhalnydja wäŋaŋur, ŋurikin wiyinŋumirriwnha nhinanharawnydja.” ");
INSERT INTO djr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Yo. Ŋuli dhu ga ŋunhi yolŋuy djäma manymakkumany, bäydhi märr-ḻurrkun' djäma ŋunhi ŋayi ga ŋayatham nhanukiyingal ŋayi goŋdhu, ŋayin dhu ga ŋunhi ŋuriŋiyin yolŋuy djäma manymakkumany ŋunhiyiny ŋunhi ŋayi dhu ga ŋayatham ŋula nhä malany yindi mirithirr, ŋunhi ŋayi dhu ŋula yolthu nhanukal goŋ-gurrupan djägalil. Ga ŋuli dhu ga yolŋuy djäma yätjkurrkumany, ga yakany ga djäga ŋamatham ŋurikiyi ŋunhi ŋula nhakuny nyumukuṉiny'kuny malaŋuw, ŋayiny dhu ga ŋunhiyiny yolŋu yakan djäga ŋurikiyiny yindiwnydja ŋula nhaku malaŋuw. Yakan dhu nhanukal dharrwany goŋ-gurrupan djägalilnydja ŋula yolthuny. ");
INSERT INTO djr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yo. Ŋuli nhe dhu ga yakany djäma ŋamatham ŋuriŋiyiny ŋunhi rrupiyay munatha'wuyyuny, ga ŋula nhaliy malaŋuy ŋunhi ŋayi God-Waŋarryu gurrupar nhokal djägalil, yänan nhakun nhe dhu ga djalkthunna, ŋayiny dhu God-Waŋarrnydja yakan märr-nhirrpanmirr nhokalnydja, ga gurrupan ŋayi dhu djiwarr'puynydja ŋula nhä malany nhokalnydja djägalil bäyŋun yan. ");
INSERT INTO djr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ga ŋuli nhe dhu ga ŋunhi miḏikumandja djäga, djalkthundja yan ŋunhi nhä malany ŋayi God-Waŋarryu nhokal gurrupar djägalil dhipal munatha'lilnydja, yan nhakun ŋunhiyiny djägaw guwarrwu dhiyak nhakun, yurr ŋunhalnydja ŋayi dhu God-Waŋarryuny yakan nhuna gurrupul nhä malany nhanŋuwuynydja ŋayi ŋayathanharaw nhuŋu gupaḏalwuny.” ");
INSERT INTO djr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Yakan nhe dhu ŋunhi djämamirr märrmawny'tja buŋgawaw, rrambaŋiny maṉḏaŋ; waŋganyguny nhe dhu ŋuyulkthirra, ga wiripuŋuwnha nhe dhu ŋunhi märr-ŋamathirrnydja. Nheny dhu ŋunhi galkithirrnydja waŋganygala yan, bala nhe dhu ga ŋayathamany ŋanya baṯ-bitjanna goŋdhuny märrmay'nha yänan, ga gänaŋ'maranhamirrnydja nhe dhu beŋurnha ŋunhi wiripuŋuwalnha, nhakun ŋayiny ŋula nhän nhäŋiniŋ'nha. Yolku dhika nheny ga buku-ŋal'yun? God-Waŋarrwu? … ŋany rrupiyaw, muka? Yaka nhe dhu ga rrambaŋiyamany waŋarrkum ga buŋgawakum maṉḏany God-Waŋarrnhany ga rrupiyanhany, bäyŋu yan.” ");
INSERT INTO djr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","“Yo. Yaka dhu ga ŋula yol yolŋu buku-ŋal'yun märrmawny'tja, God-Waŋarrwuny ga rrupiyawnydja rrambaŋiyamany maṉḏaŋ.” Ga bitjarr ŋayi Djesuny waŋan. Ga walalnydja ŋuriŋiwurruynydja Baratjiynydja yolŋuy walal ŋäkulnha, bala beyarrmakkuŋal warray ŋanya dhäruk, bili walal gan ŋurruŋuyaŋal rrupiya yan. ");
INSERT INTO djr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ga ŋayiny Djesuny waŋan walalaŋ bitjarr, “Nhumany ŋuli ga dhuwal djäma yolŋuw warray walalaŋ maŋutjiw, märr nhumalany walal dhu ga nhäma, bala manymak-lakaraman. Yurr ŋayipiny ga God-Waŋarryuny nhuŋu nhäma ŋunhan ŋunhi ŋayaŋun; marŋgi ŋayi nhuŋu warrpam', nhäthinya nhuŋu ŋunhi yolŋuw ŋayaŋu. Yo, ŋayipiny God-Waŋarryuny ŋuli ga yätjkurr-lakaraman ŋunhiny mala ŋunhi nhä mala ŋuli ga yolŋuy walal manymak-lakaram.” ");
INSERT INTO djr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ga ŋunhiny rom ŋunhi ŋayi God-Waŋarryu gurrupar Mawtjitjkal, ga wiripuwurruŋguŋ djawarrkmirriwuŋ walalaŋguŋ wukirriwuy, beŋur bili gan dhärran yan, ga yan bili-i-i ga balanyamirriynha ŋunhi ŋayin Djonnha bunan ŋunhi Ḻiya-ḻupmaranhamirra yolŋu, bala gan ŋunhi manymaktja dhäwu ḻatjuwarr'yurra, ŋunhi God-Waŋarrwalaŋuwuynydja rombuy. Ga dhiyaŋuny bala ga dhuwal dharrwan mirithirra yolŋu walal gumurrmirra birrka'yun mirithirra yan gulŋiyinyaraw ŋunhiwiliyiny romlil. ");
INSERT INTO djr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yo, ŋunha ŋunhi garrwarnydja wäŋa ga dhuwandja munathany' wäŋa ŋaraka winya'yunna dhu buwayakthirra, yurr God-Waŋarrwuny rom dhu ga dhärran yan bitjanna bili; yakan dhu ŋula waŋganydja nyumukuṉiny'tja dhäruk winya'yun.” ");
INSERT INTO djr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Yo. Ŋuli ŋayi dhu ḏirramuy yolŋuy ŋula ganan miyalknhany nhanŋuwuy ŋayi, bala ŋayi dhu märraman wiripuŋunhan miyalknha, ŋunhiyiny nhakun ŋayi dhu marramban' djäma. Ga ŋuli ŋayi dhu ḏirramuy märram miyalknha ŋunhi ŋayi ŋuriŋiyi miyalkthu ganarrthaŋal nhanŋuwuy ŋayi dhuway'mirriŋuny, ŋunhiyiny balanyayi bili yan marramba'yi.” Bitjarr ŋayi gan Djesuy lakaraŋal walalaŋ dhäwuny'. ");
INSERT INTO djr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Djesuy lakaraŋal wiripuny muka dhäwu mayali'kurryi yan dhuwal gam', “Waŋganydja yolŋu gan nhinan girri'-dharrwamirr dhika mirithirr, dhaṯthunminany ŋayi gan ŋunhi girriyny'tja manymakkunhamin yan, ga balanyayi bili ŋathany mala ŋayi gan ḻukan dharrwan mirithirra, bitjarrnha bilin yan walu-ŋuparnha. ");
INSERT INTO djr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ga ŋunhiliyi wiripuny gan yolŋu nhinan yäkuny ŋayi ŋunhi Lätjuritj, yurr ŋayi ŋunhi yolŋuny gurrupuruŋun, ga yalŋgin mirithirra djetjimirra dhikan; warrpam'thurra ŋanya djetjiynha rumbalnydja ŋayathaŋal. Bitjarra bili walu-ŋupara walal gan nhanukal gurruṯumirriynydja ŋanya gäŋa'-gaŋalnha, ga nhirrparnydja ŋanya walal gan ŋunhiwilin girri'-dharrwamirriwalnha yolŋuwal wäŋalilnydja, galki dhurrwaralila, ");
INSERT INTO djr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","märr ŋayi gan ḻukan ŋathany ŋunhi muṉguynha bala maranhuyinan, ŋunhiyi ŋatha muṉguy malany ŋunhi ŋayi gan djalkthurr ŋuriŋiyi girri'-dharrwamirriy yolŋuy. Wiripuny gan wuŋgannha mala marrtjin, bala biḻaŋ'thurra marrtjin ŋunhi djetjin mala ŋanya Lätjuritjnha. Yurr yolŋuny nhanŋu gan bäyŋun ŋula nhinan djägamirrnydja.” ");
INSERT INTO djr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Dhäŋur beŋuryiny bala ŋayi ŋunhiyiny gurrupuruŋuny yolŋu dhiŋgaŋalnha, bala God-Waŋarrwal dhäwu-gänhamirriynydja yolŋuy walal gäŋalnha ŋanya balan djiwarr'lila, bala ŋayi ŋunhalnydja gan nhinan gali'ŋurnydja Yipurayimgalnha, bala walal gan ḻukanan ŋathan ŋunhi manymaknha mirithirra dhikan. Ga ŋayiny muka ŋunhiyiny dhiŋgaŋal girri'-dharrwamirrnydja yolŋu ḏirramu, bala walal dholkuŋalnha ŋanya molulila. ");
INSERT INTO djr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ga ŋayiny gan ŋunhiyiny yolŋu nhinan girri'-dharrwamirrnydja ŋunhala bala burralkun, ga nhinanany ŋayi gan ŋunhi dhaŋga-ḏirryurrnydja mirithinan yan dhika. Ga ŋunhi nhakun ŋayi buku-garrwarthinany bitjarrnydja, bala ŋayi yan nhäŋalnydja Yipurayimnhany, ŋayi gan nhinanany barrkun, ga bitjarryi bili ŋayi nhäŋalyi ŋunhiyi Lätjuritjnhany ŋunhi gurrupuruŋunhany yolŋuny, ŋayi gan nhinanany galkin yan nhanukala Yipurayimgalnha.” ");
INSERT INTO djr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Bala ŋayi ŋunhiyiny girri'-dharrwamirrnydja yolŋu wäthurra bitjarrnha, ‘Way Mäḻu' Yipurayim, wuyurr ŋathil ŋarraku go. Djuy'yurr dhuwali Lätjuritjnha räli, ŋayi dhu guŋga'yun ŋarrany; ŋayi dhu marrtji ga goŋ-ḻupthun gapulil, bala ŋäṉarrnha ŋarrany dhu ŋayatham yal'maraman, bili ŋarra ga dhuwal mirithirra dhaŋga-ḏirryundja, ŋoy-wulkthunna ŋarra dhu dhuwal dhiyaŋuny gurthaynydja.’” ");
INSERT INTO djr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ga ŋayiny Yipurayimdja buku-bakmaraŋal waŋan nhanŋuny bitjarr, ‘Gäthu ŋarraku, gatjuy guyaŋin, ŋunhi nhe märraŋal nhä malany manymak nhuŋuwuy nhe ŋunhili banydji muka yan munatha'ŋur, ŋunhi nhe gan nhinan ŋäthil ŋunhiŋumirryi. Ga dhuwandja Lätjuritjtja bäyŋu ŋayi märranha ŋula nhä ŋamakurr; nhanŋuny balanyayi bili yan yätjkurryi bunan ŋunhiliyiny munatha'ŋurnydja wäŋaŋur. Ga dhiyaŋuny bala ŋayi ga dhuwal nhina galŋa-ŋamathirra dhiyalnydja wäŋaŋur, ga nheny ga dhuwali nhina galŋa-yätjirra mirithirra. ");
INSERT INTO djr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yakan dhu dhipuŋurnydja yolŋu marrtji balany buḏapthundja dhipaliyiny wäŋalil, ga bäyŋuyi dhu ŋula yol buḏapthun dhipuŋuryiny wäŋaŋur räliny dhipalnydja wäŋalil, bili dhuwaliyiny ga ŋunhi ṉapuŋgany' dhärra dhulmu-ḻuḻnyin'nha mirithirra, ben bala ḏandjan.’” ");
INSERT INTO djr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Ga buluny ŋayi ŋunhiyi girri'-dharrwamirrnydja yolŋu waŋan Yipurayimgal bitjarr, ‘Mäḻu' Yipurayim buku-djulŋi, nhämirr balaŋ nhe dhu djuy'yun ŋanya Lätjuritjnhany balayi munatha'lilyi, ŋayi dhu marrtji bala wäŋalil ŋarrakalaŋuwalnha bäpa'mirriŋuwalnydja. Lakaram ŋayi dhu guyaŋanhamirriyam wäwa'mirriŋuny walalany ŋarraku ŋunhi goŋ-waŋganynhan, biŋga'maram walalany, märr walal dhu bilyunna walalaŋgiyingalaŋuŋur romŋurnydja mala, märr walal dhu yakan marrtji dhipalnydja wäŋalil galŋa-yätjinyamirrililnydja.’” ");
INSERT INTO djr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ga ŋayiny Yipurayimdja waŋan bitjarr, ‘Ŋunhayi nhokalnydja wäwa'mirriŋuy walal ga ŋayatham muka ŋunhi Mawtjitjkuŋuny rom, ga dhäwu ŋunhi God-Waŋarrwuŋ ŋunhi walal gan djawarrkmirriy yolŋuy walal wukirri; ŋuriŋiyin dhärukthu walalany dhu ga ŋunhi waŋany raypirri'yundja yätjkurruŋurnydja. Ŋurikiyin walal dhu ŋunhi buthuru-bitjundja, bala walal dhu yurrnha walŋathirrnydja.’” ");
INSERT INTO djr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ga bulu ŋayi ŋunhiyi girri'-dharrwamirr yolŋu waŋan bitjarr, ‘Mäḻu' Yipurayim buku-djulŋi, yakan walal dhu ga ŋunha buthuru-bitjundja ga ŋämany. Yurr mak walal dhu ŋunha buthuru-bitjundja, ga ganarrthamany ŋunhiyi walalaŋguwuy yätjkurrnydja malany rom, ŋuli balaŋ ŋayi dhu waŋgany yolŋu dhiŋganhawuy marrtji walalaŋgal beŋura ŋunhi dhiŋganhamirriŋura wäŋaŋur bala walalnydja dhu buthuru-bitjandja nhanŋun bala yan bilyuna God-Waŋarrwalnha.’” ");
INSERT INTO djr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Bala ŋayi Yipurayimdja buku-bakmaraŋal bitjarrnha, ‘Ŋuli walal dhu ŋunhi bäyŋuny märram dhäruk Mawtjitjkuŋuny, ga ŋurikiwurruŋguŋuny ŋunhi djawarrkmirriwuŋuny mala, ga bäyŋuyi yan walal dhu ŋunhi märr-yuwalkthirr ŋurikiyiny yolŋuw ŋunhi ŋayi dhu ŋula walŋathirr rakunyŋurnydja.’” Bitjarr ŋayi gan Djesuy lakaraŋalnydja mayali'kurrnydja dhäwu. ");
INSERT INTO djr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Bala ŋayi yan Djesuy lakaraŋalnha nhanukiyingalaŋawnydja ŋayi malthunamirriw walalaŋ bitjarra, “Wiripuny dhu ŋunhi yolŋu bilyun yätjkurrulila ŋula yolkuŋ ŋunhi dharrwununhawuynydja, yurr nhanŋu dhu marin ŋurikiyiny yindin maḻŋ'thun, ŋunhi ŋayi ŋanya bilmaraŋal yätjkurrulil gäŋal. ");
INSERT INTO djr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bili God-Waŋarryuny dhu yuwalkkum yan dhä-gir'yun mirithirr yan ŋunhiyiny yolŋuny ŋunhi ŋayi ŋuli wiripuny yolŋuny galkirrinyamaram yätjkurrulil. Bala ŋayi dhu ŋunhiyiny yolŋu waŋan bitjanna, ‘Ye-e-e! Wanha balaŋ ŋarrany ŋula yolthu yolŋuy ŋurrkanha garrpinawuynha mayaŋ-guṉḏamirra balan gapulilnha ŋunhi dhulmulila, märr balaŋ ŋarra yakan bitjanayi djäma yätjkurr, bilmaranha yolŋunhany yätjkurrulilnydja,’ bitjanna dhu waŋa. ");
INSERT INTO djr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yurr biyakun djägan nhuŋuwuy nhe, märr nhe dhu yakan bilmaram ŋula yolnhany yolŋuny galkirrinyamaramany.” “Yo. Ŋuli ŋayi dhu ŋula yolthu yolŋuy nhokal wäwa'mirriŋuy Garraywalaŋumirriy djäma ŋula nhäny yätjkurrnydja, gatjuy nheny ŋanya dhu ŋunhiyiny yolŋuny raypirri'yunna, ga ŋuli ŋayi dhu ŋunhi bilyundja beŋuryi yätjkurruŋurnydja, ga ŋunhiyiny nheny dhu dhunupan yan nhanŋu bäy-lakaraman. ");
INSERT INTO djr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ga ŋuli ŋayi dhu nhuna ŋayaŋu-miḏikuman, buku-7-mirrnydja ŋuriŋiyiny bili yan waŋganydhu waluy. Ga ŋuli ŋayi dhu ga marrtjiny ga yan nhokal lakaranhamirrnydja dhu ga bitjanmirrnydja, ‘Way ŋarrany nhuŋu dhuwal mirithinan ḏämbu-goranany. Buku-djulŋi ŋathil ŋarraku bäy-lakaraŋ?’ bitjandja, ga nheny nhanŋu yan bäy-lakaraŋun.” ");
INSERT INTO djr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ga walalnydja ŋunhi 12-tja djuy'yunawuy mala waŋan nhanukal Garraywal bitjarr, “Garray, djäman ŋanapurruŋgal ŋayaŋulilnydja, märr napurr dhu märr-nhirrpanmirra yuwalkkuman nhokal.” ");
INSERT INTO djr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ga ŋayiny Garraynydja waŋan bitjarr, “Ŋuli nhe gi yuwalktja dhärukku ŋarrakuny märr-yuwalkmirriyi, märr-dharaŋulnydja manapul ŋarrany, bäydhi ŋunhi nhuŋu märr-nhirrpanminyawuynydja nyumukuṉiny'tja balanyany nhakun ŋunhi genydjany' maŋutji, yurr nheny dhu ga ŋunhi djämany bitjanna bili yan mirithirrnydja nhanŋuwuynha yan God-Waŋarrwun ŋuriŋi bili yan nhokal märr-nhirrpanminyawuyyuny. Yo, bäydhi nhumalaŋ ŋunhi gumurr-ḏälnydja, nhumany dhu ga ŋunhi bitjanna bili djäman yan.” ");
INSERT INTO djr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ga bulu ŋayi Djesuy lakaraŋal mayali'wurr dhäwu bitjarr gam', “Yo, bitjan bili ŋayi ŋuli ga walu-ŋupan yan nhokalnydja djämamirriy djäma yan ŋunhalnydja ŋunhi warraŋulnydja, yaw'yun ŋuli marrtji munatha', ga djäga ŋayi ŋuli ga warrakan'ku malaŋuw. Ga ŋunhi ŋayi ŋuli marrtji wäŋalilnydja roŋiyirr, ga nheny ŋuli ŋunhi buŋgawa'mirriŋuny nhanŋu nhaltjanna waŋa? ‘Dhipal nhini, bala ŋathan ḻuki!’ Bitjanna nheny ŋuli ŋunhi waŋa nhanŋu? ");
INSERT INTO djr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bäyŋu. Nhuŋu warray dhunupany waŋanharaw, bili ŋayiny ŋunhi nhuŋu djämamirr yan. Nhe ŋanya dhu ŋunhi waŋa bitjandja, ‘Ma', ŋatha ŋarraku ŋunhi ŋäthilmirriyaŋ, bala gäŋun rälin dhipala, ŋarra ŋathil dhu ḻuka ŋurruŋuny, ga nheny dhu djäma ŋarraku. Ga dhäŋur beŋuryiny ŋarrakalnydja, bala nheny dhu yurrnha ḻuka.’ Bitjan nhe dhu ŋunhi buŋgawa'mirriŋuny waŋa. ");
INSERT INTO djr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yakan nhe ŋuli ŋunhi buku-gurrpulnydja nhuŋuwuy nhe djämamirrinhany yolŋuny, ŋunhi ŋayi nhuna ŋuli ga dhäruktja nhuna märram? … bili ŋunhiyiny nhanŋu muka djäma. ");
INSERT INTO djr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yo. Ga nhumany dhuwal balanyayi muka bili God-Waŋarrwuyi yan djämamirr mala. Gatjuy djämany gi ŋamathaŋun yan nhanŋuwuynha, ga dhäruktja ŋanya gi märraŋun yan. Yaka warray gi biyakuny bili gatjpu'yurr ŋurikiny ŋunhi wiripuwurruŋgalaŋawnydja yolŋuw walalaŋ buku-gurrpanawuywu ga märr-yiŋgathinyawuywu. Nheny dhu nhepi yan gäna lakaranhamirr nhunapinya nhe God-Waŋarrwal biyak gam', ‘Ŋarrany dhuwal nhuŋuwuynha yan djämamirr, ŋarrapiny dhu dhuwal nyumukuṉiny'kunhamirra. Dhäruktja ŋarra nhuna dhu ga dhuwal märraman, bala dhunupan yan djämamirriyaman, bili dhuwaliyin ŋunhi dhunupany ŋarraku djämaw balanyarawyin.’” ");
INSERT INTO djr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Djesuny gan baḏak yan marrtjin dhukarr-ŋupar balan bitjarra Djurutjalamlila,* yurr marrtjinany ŋayi gan ŋunhi ŋuliwitjarra dhukarrkurrnydja, ŋunhi Djamariyapuyyu* wäŋay ga Galalipuyyu wäŋay ṉapuŋga'yaŋal ŋunhiyi dhukarrnhany. ");
INSERT INTO djr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ga ŋunhi ŋayi marrtjin bukuy-märraŋal waŋganynhan wäŋany ŋunhiyin, ga walalnydja bäy nhäŋal ŋanya 10-dhuny yolŋuy walal burrunhdhiya'mirriynydja mala, yurr walal gan ŋunhi dhärra'-dharranany märr barrku. ");
INSERT INTO djr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Bala walal wäthurrnydja mirithinan bitjarr, “Djesu! Buŋgawa! Wuyurr ŋanapurruŋ go!” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Bala ŋayi Djesuynydja nhäŋalnha walalany, ga waŋan bitjarra, “Gatjuy marrtjin walal balan buku-ŋal'yunamirrilila buṉbulilnydja, bala nhuma dhu ŋunhi ŋunhiliyin milkunhamirra ŋurikalnha yolŋuwal walalaŋgal djirrikaymirriwalnha mala, märr walalnha dhu nhumalany nhäma'-nhämany, bala walal dhu lakaramany nhumalany baḏarraŋdhinyawuynha.” Ga dhunupan ŋunhiwurryiny 10-dja burrpuymirrnydja walal marrtjinan, ga ŋunhi walal marrtjin wäŋgaŋalnydja dhukarr-ŋuparnydja, bala ŋunhiliyin walal marrtjin baḏarraŋdhinany djetjimiriwyinany dhukarrŋur yänan. ");
INSERT INTO djr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ga ŋayiny waŋganydja yolŋu ŋunhiyi burrpuymirrnydja nhänhamin ŋanyapinya ŋayi manymakthinyawuynha, bala ŋayi yan yatjurra bitjarr, “Way, baḏarraŋnha dhuwal ŋarrany?” bitjarr. Ga dhunupan yan ŋayi ŋunhi bilyurrnydja, bala waṉḏinan roŋiyinan balayi Djesuwalyi. Yurr waṉḏinany ŋayi gan ŋunhi dhä-rirrakaymirra dhikan, wokthurrnydja manapar God-Waŋarrwun. ");
INSERT INTO djr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ga ŋunhi nhakun ŋayi bunanany nhanŋu, bala ŋayi nhakun dhunupan yan ŋurrkanhaminan nhanukal ḻukulila Djesuwalnydja, buku-gurrpara ŋayi manapar ŋanya. Ga ŋunhiyiny yolŋu Djamaritin balanya bäpurru, yaka Djuw malany. ");
INSERT INTO djr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ga ŋayiny Djesuny waŋan nhanukal bitjarrnha, “Way, 10 muka balaŋ ŋunhi yolŋuny baḏarraŋdhinya. Ga wanhan ŋunhi wiripuwurrnydja yolŋu walal 9-nydja? ");
INSERT INTO djr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ga bäyŋun ŋunhi Djuw-ny yolŋu walal roŋiyinya buku-gurrpanaraw; waŋganynha dhuwal yolŋuny roŋiyin ŋunhin mulkurun, muka?” ");
INSERT INTO djr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bala ŋayi Djesuynydja waŋanan ŋanya bitjarra, “Gatjuy rur'yurra, bala marrtjin wäŋalila. Dhiyaŋiyi nhokiyingal nhe märr-nhirrpanminyaray nheny baḏarraŋdhinan warrpam'thurra,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Waŋganydhuny waluy Baratjiy yolŋuy walal dhä-birrka'yurr ŋanya Djesuny bitjarr, “Way Garray, nhätha ŋayi dhu ŋunhi God-Waŋarrwuny rom buna? Nhäthan ŋayi dhu ŋunhi ŋurruŋuyirrnydja dhiyakuny wäŋaw munatha'wuywuny?” Ga ŋayiny Djesuny buku-bakmaraŋal bitjarr, “Nhanŋuny ŋunhi God-Waŋarrwuny rom, nhänhamiriwnha. ");
INSERT INTO djr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ga bäyŋun dhu ŋunhi ŋula yol yolŋu waŋa bitjandja, ‘Way, dhuwanna ŋayi,’ bitjandja, ga yakan dhu ŋula yol yolŋu waŋa bitjandja, ‘Ŋunhan, ya ŋunhan God-Waŋarrwuny rom,’ bitjandja. Bili God-Waŋarrwuny dhuwal rom dhuwalin nhumalaŋgala.” ");
INSERT INTO djr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bala ŋayi Djesuy lakaraŋala bitjarrnha nhanukiyingalaŋuwalnydja ŋayi malthunamirriwal walalaŋgal bitjarra, “Yo. Waluny dhu ŋunhi buni, nhumany dhu ŋunhi waŋi biyakun, ‘Ye-e-e, nhätha dhu ŋunhi Gäthu'mirriŋuny Yolŋuny buni?’ Biyakun nhuma dhu ŋunhi gatjpu'yurrnydja nhanŋu nhänharawnha. Yurr yaka nhuma dhu nhämany ŋanya balanyamirriyyiny. ");
INSERT INTO djr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wiripuny dhu yolŋu waŋa bitjanna, ‘Ŋunhan ŋayi, ya ŋunhan,’ bitjanna. Ga biyakun walal dhu waŋi, ‘Go, dhuwal ŋayi, bilin bunanan,’ biyak. Yurr yaka nhuma dhu ga walalaŋ buthuru-bitjundja ga märr-yuwalkmirriyirrnydja, ga marrtjiny nhuma dhu ga ḻarrumany nhanŋu buku-ḻiw'maramany bäyŋun. ");
INSERT INTO djr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bili balanyamirriyyin ŋayi dhu ŋunhi Yolŋuny Gäthu'mirriŋu buna, ŋayi dhu ga marrtjiny räli djeŋarra'yirr mirithirr yan, ga bukmakthun ŋanya dhu ŋunhi nhämany, bitjanna nhakun ŋuli ŋunhi bukmakthu yolŋuy walal nhäma ŋunhi ŋayi ŋuli djaḻkarr'yun baḏayala'mirriyam wäŋany bukmak dhuwal. ");
INSERT INTO djr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yurr ŋurruŋuny ŋathil ŋayi dhu ŋunhiyiny Yolŋuny Gäthu'mirriŋu buraki. Yo, yolŋu walal ŋunhi ga dhiyaŋ bala nhina dhiyal, walalnha ŋarrany dhu ŋunhi bukuy-ŋurrkuŋuny boŋguŋ, bala dhu buŋun.” ");
INSERT INTO djr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Yo, balanyamirriynydja waluy ŋunhi ŋayi dhu Yolŋuny Gäthu'mirriŋu roŋiyiny räliny, dhuwandja dhu wäŋa boŋguŋ biyakun nhakun ŋunhi Nawamirriynha waluy, ŋäthil ŋunhi baman'. Biyakiyiny ŋayi dhu dhuwal wäŋany dhuwurrnydja nhakun ŋunhiyi. ");
INSERT INTO djr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Balanyamirriyyi gan ŋunhi yolŋu walal nhinan wawu yan; bitjarr bili walal gan marrtjin ga ḻukan ŋatha ga gapu, miyalk ga ḏirramu gan märranhamin, ga yan bili-i-i ga ŋuriŋin waluy ŋunhi ŋayi Nawa gulŋiyinan balan marthaŋaylila. Bala dhunupan yan ŋunhi gapuynydja buku-ḻupmaraŋalnha warrpam'thurra buwayakkuŋalnha wäŋanhany. ");
INSERT INTO djr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","29","Ga balanyamirriynydja ŋunhi Lutmirriynydja* waluy, walalnydja gan ŋunhi bitjarryi bili yan yolŋuynydja mala ḻukandhi ŋatha ga gapu, bäyim walal gan ŋula nhä mala, lämu-nhirrpar marrtjin ŋatha malany, ga buṉbu marrtjin dhuḻ'yurr. Yurr walal gan ŋunhi nhinanany bitjarryi bili yan wawuyi, ga yan bili-i-i ga ŋuriŋin waluy ŋunhi ŋayi Lutthu ganarrthaŋala ŋunhiyiny wäŋa Djudumdja. Ga dhunupan ŋunhi balanyamirriyyiny waluy gurthan bunan beŋura djiwarr'ŋura, bala walal yan warrpam'thurra nhäranany gurthaynha buwayakkuŋal. ");
INSERT INTO djr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yo. Ga biyakiyi dhu gi ŋunhi yolŋuny walal nhini wawun balanyamirriyyiny waluy ŋunhi dhu Yolŋuny Gäthu'mirriŋuny maḻŋ'thurr warraŋulthiny dhiyalnydja.” ");
INSERT INTO djr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ga ŋuli nhe ŋula yol yolŋu dhu gi ŋunhi nhininy galkunmirrnydja nhunapinya nhe ŋunhiliny ŋunhi galkiny nhokiyingalnydja wäŋaŋur, ŋuriŋiny waluy ŋunhi ŋayi dhu boŋguŋ Yolŋuny Gäthu'mirriŋu bunin, ga dhunupan bala nhakun nheny dhu waṉḏin yänan, ga bäyŋun nhe dhu ŋunhi roŋiyiny bala'lilnydja djinawa'lilnydja girriwny'tja wapmaranharaw. Ga ŋuli nhe dhu gi djäma nhokiyingal nhe gätniŋur ŋuriŋiyi waluy, ga nheny dhu ŋunhi dhunupan ṉaŋ'thurra, yakan roŋiyiny bala'lilnydja nhokiyingal nhe ŋula nhakuny malaŋuw märranharaw. ");
INSERT INTO djr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gatjuy guyaŋi ŋathil roŋiyi ŋunhi Lutku miyalknha, ŋunhi ŋayi ḏawa'yurr roŋiyin nhäŋal yindi wäŋa yäku Djudum, balanyamirriy bili yan waluy ŋunhi ŋayi God-Waŋarryuny Bäpaynydja dhuŋgur'yurra buwayakkuŋalnha ŋunhiyiny wäŋa. Ga ŋayiny ŋunhiyiny Lutkuny miyalk dhunupan yänan djambin guṉḏathinan.” ");
INSERT INTO djr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Yo. Ŋuli dhu ga ŋunhi ŋula yolthu yolŋuy bitjandja bili ŋarranhany gumurr-ganan, bili ŋayi ga ŋunhi wiripuwurruŋguny yolŋuw walalaŋ barrarirr muka, walal ŋuli ŋula bäynha marin nhanŋu djäma, ŋayiny dhu ŋunhi balanyayiny yolŋu yuwalknha dhiŋgam. Ga ŋunhi ŋayi dhu ga bitjanna waŋa gam', ‘Ŋarrany dhu dhuwal monhamirra ŋarranhawuynhany ŋarra, bala ŋarra dhu ga djämany nhanukiyingalnha yan Garraywalnha djälyuny,’ bitjandja ŋayi dhu ga waŋa, bala ŋayi dhu ga ŋunhiyiny yolŋu nhina walŋan yan bitjanna bili wiyinŋumirra. ");
INSERT INTO djr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ga balanyamirriyyiny ŋunhi ŋayi dhu Gäthu'mirriŋuny Yolŋuny buni, maṉḏany mak dhu gi ŋunhi yolŋu märrmany' ŋorri waŋganyŋur, bala waŋganynhany ŋayi dhu djaw'yurra, ga waŋganynhany ŋayi dhu ganarrthula ŋunhiwilin banydjiwalnha yan ŋorranhalila. ");
INSERT INTO djr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ga wiripuny dhu gi märrmay' miyalkthu maṉḏa djäma ŋatha buḻŋu'kuŋ rrambaŋi, bala dhu waŋganynhany ŋayi märraŋun, djaw'yurra dhu, ga waŋganynhany ŋayi dhu ŋunhi ganarrthula ŋunhiwilin banydjiwalnha. ");
INSERT INTO djr_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ga balanyayi bili ḏirramuy maṉḏa dhu gi djäma gätni, ga waŋganynhany ŋayi dhu djaw'yurra, ga waŋganynhany ŋayi dhu gananna.” Ga bitjarr ŋayi gan ŋunhi Djesuy ŋäthilmirriyaŋalnydja lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ga walalnydja ḻundu'mirriŋuynydja nhanukal waŋan dhä-birrka'yurr ŋanya bitjarr, “Wanhamin dhika dhu ga wäŋaŋur bitjandhiny maḻŋ'thun?” Ga ŋayiny Djesuynydja buku-bakmaraŋal mayali'kurr lakaraŋal bitjarr, “Ŋunhili muka wäŋaŋur ŋunhi wanha ga warrakan' ŋorra dhiŋganhawuy, ŋunhiwiliyin dhu ga wäŋalil ŋunhi wäktja mala marrtji, waŋgany-manapanmirrnydja dhu marrtji ḻukanharawnydja ŋanakkuny barrpawny'tja.” ");
INSERT INTO djr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Bala ŋayi Djesuynydja dhulmu-mayali'mirra dhäwuny lakaraŋala walalaŋgalnydja yolŋu'-yulŋuwalnydja, marŋgikuŋala ŋayi walalany, märr walal dhu ga bitjanna bili yan bukumirriyaman God-Waŋarrwalnydja, ga yaka walal dhu gandarrŋurnydja djawaryun ga ḏaḏawyundja. ");
INSERT INTO djr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ga dhuwal ŋunhi ŋayi dhäwuny' lakaraŋal gam', “Waŋganyŋur wäŋaŋur yolŋu gan nhinan maramba' ŋunhi ŋayi romgu mala-djarr'yunamirr, yurr yaka ŋayi gan ŋunhi märr-ŋal'yurr God-Waŋarrwuny, ga yaka ŋayi gan mirithin djälthin yolŋuw walalaŋ guŋga'yunaraw. ");
INSERT INTO djr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ga ŋunhiliyi bili wäŋaŋur yolŋu gan nhinan miyalk dhuwaymiriw, buku-gurthapuy, ga bitjarr bili yan ŋayi gan ŋuriŋi miyalkthuny guwatjmar ŋanya ŋunhiyi maramba'nhany yolŋuny, märrliliyanhaminan ŋanyapinya ŋayi gan nhanukal ŋurikalyi buŋgawawal bitjarr, ‘Way buŋgawa, buku-djulŋi guŋga'yurr ŋarrany, bili ŋuruŋuny yolŋuy ŋarrany ŋuli ga dhuwal bitjanna bili bawa'-gurrupanna yan. Ŋarrany dhuwal djäl nhe dhu romdhu dhunupay yan mala-djarr'yundja.’ ");
INSERT INTO djr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ga bitjarryin ŋayi gan ŋunhi miyalktja waŋan ŋurikalyiny maramba'walnydja yolŋuwal. Yurr yakan ŋayiny gan ŋunhi nhanŋu buthuru-bitjurr. Yurr ŋayiny ŋuriŋiyiny miyalkthuny gan bitjarr bili yan dhurrarratjurr guwatjmar ŋanya, ga waŋanha ŋayi ŋuli ganha ŋuriŋi bili yan waŋganydhu dhärukthuny bitjana, ‘Guŋga'yurr ŋarrany, go,’ bitjana, ga yän bili ga bäy ŋayi djawaryurr ŋunhiyi maramba' yolŋu nhanukal. Bala ŋayi waŋanhaminan ŋanyapinya ŋayi bitjanminan, ‘Bäyŋu ŋarra ŋuli gi dhuwal märr-ŋal'yurr God-Waŋarrwalnydja, ga yaka ŋarra ŋuli gi dhuwal djälthi ŋarra dhu ga guŋga'yun yolŋunhany walalany. ");
INSERT INTO djr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yurr dhuwandja ŋunhi miyalk ŋuli ga marrtji bitjan bili yan ŋarrakal, nhakun ŋayi ŋuli ga ḻay-ḻaymaraman ŋarrany. Ŋarrany nhanŋu dhu ŋunhi dhunupayaman yan ŋunhi ŋula nhäny mala. Ŋuli ŋarra dhu nhanŋu ŋunhi yakany djäma ŋamatham, ŋayiny balaŋ ŋarrany gi dhuwal dhurrarratjurra yan biyakun bili, djawar-gurrupula ŋarranhan!’” ");
INSERT INTO djr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Bala ŋayi Djesuy dhawar'maraŋalnydja lakaraŋal bitjarrnha, “Bili muka nhuma gan ŋunhi ŋäkulnydja ŋunhi nhaltjarr ŋayi ŋunhi maramba' yolŋu. ");
INSERT INTO djr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yurr God-Waŋarrnha ŋunhi ŋayipin waŋganynha yan dhunupany mala-djarr'yunamirr; yuwalktja dhu ga ŋunhi ŋayipin God-Waŋarryun guŋga'yun nhanŋuwuynydja yolŋuny mala, ŋunhi walal ŋuli ga bitjan bili märrliliyanhamirr wäthun nhanŋu munhawu ga walupuy. Yakan ŋayi dhu ga ŋunhi galkun wiyindja. ");
INSERT INTO djr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Märr-yuwalk ŋarra ga dhuwal nhumalaŋ lakaramany, ŋayiny dhu bondi yan mala-djarr'yun dhunupayam nhä malany ŋunhiŋuwuynydja ŋunhi nhe ŋuli ga bitjan bili bukumirriyam, ga bäyŋun ŋayi dhu ŋunhi djawaryundja. Yurr ŋunhi ŋayi dhu Yolŋuny Gäthu'mirriŋu marrtjiny räliny munatha'lilnydja, ga nhän ŋayi dhu ŋula boŋguŋ maḻŋ'maraŋuny, märr-nhirrpanminyawuynha? Bitjanna bili dhu ga ŋunhi yolŋuny walal märr-nhirrpanmirra yan nhanukal? … ga yakan dhu ŋula djawaryundja?” ");
INSERT INTO djr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ga wiripuny ŋayi Djesuy lakaraŋal dhäwu mayali'mirr ŋurikiwurruŋ yolŋuw walalaŋ ŋunhi walal ŋuli ganha guyaŋanhaminya walalanhawuynha walal rom-dhunupa mala, ga wiripuwurrnydja walalaŋgal ŋayaŋuŋur goŋ-gäna, läypuy. ");
INSERT INTO djr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ga bitjarrnha ŋayi gan ŋunhi Djesuy lakaraŋalnydja gam', “Märrma' yolŋu maṉḏa marrtjin bala God-Waŋarrwal buṉbulil bukumirriyanharawnha, yurr waŋganydja ŋunhi Baratji yolŋu, ga wiripuny ŋunhi yolŋu rrupiya-märranhamirra yolŋu gapmangun. ");
INSERT INTO djr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yo, marrtjinany maṉḏa ŋunhi bala dhunupan gärrinan buku-ŋal'yunamirrilila buṉbulila, ga ŋayiny ŋunhi Baratjiny yolŋu marrtjin balan yänan gumurrlila, bala dhärranan ŋayi gan bukumirriyaŋala gänan ŋayipin, ga waŋanany ŋayi gan ŋunhi bitjarrnha gam', ‘God-Waŋarr, ŋarrany nhuna ga dhuwal buku-gurrpan mirithirr yan, ŋunhi ŋarrany dhuwal manymak yan yolŋu. Yaka ŋarra dhuwal yätjkurrnydja balanya nhakun ŋunha wiripuwurrnydja yolŋu walal; ga yaka ŋarra dhuwal manaŋa-ḏumurr, ga yaka ŋarra ŋuli gi mayali'-wilkthurr wiripuwurruny yolŋuny walalany, ga yaka ŋarra ŋuli gi marramba' djäma, ga bäyŋu ŋarra ŋuli gi djäma ŋula nhä yätjkurr nhakun dhiyaŋ rrupiya-märranhamirriy yolŋuy. ");
INSERT INTO djr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wiripuny muka ŋarra ŋuli dhuwal gurr'yun, yaka ŋarra ŋuli gi ŋatha ḻuki, yurr dharrwamirra ŋarra ŋuli ga ŋunhi bitjandhiny nhina, ga bitjan bili ŋarra ŋuli ga ŋunhi mala-wulkmaram beŋurnydja ŋunhi nhämunha' ŋarra ŋuli märram wuburrpuy ŋarrakiyingalaŋuwuy.’ Bitjarra ŋayi gan ŋunhiyi Baratjiny yolŋu bukumirriyaŋal.” ");
INSERT INTO djr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ga ŋayiny ŋunhi rrupiya-märranhamirrnydja yolŋu marrtjin ga ŋunha barrku warray dhärran, ga yakan ŋayi ŋunhi buku-garrwarthinany djiwarr'lilnydja; yänan ŋayi gan ŋunhi dhärranany buku-yirryirryurra, bili ŋayi ŋunhi mirithinan goranany ŋuriŋiyin ŋunhi yätjkurruynha nhanukiyingal ŋayi. Yurr ŋayi gan ŋunhi gumurrnha bunhaminany, ga bitjarra ŋayi ŋunhi bukumirriyaŋalnydja, ‘God-Waŋarr Garray, wuyurr ŋarraku. Ŋarrany dhuwal yätjkurr mirithirr yolŋu. Bäy-lakaraŋ ŋarraku,’ bitjarr.” ");
INSERT INTO djr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Bala ŋayi Djesuynydja lakaraŋala bitjarrnha, “Yuwalk yan ŋarra nhumalaŋ dhu dhuwandja lakaram. God-Waŋarryuny ŋunhi bäy-lakaraŋal ŋurikiyin yolŋuw rrupiya-märranhamirriwnha yakan ŋurikiyiny Baratjiwnydja yolŋuw, ga roŋiyinany ŋayi ŋunhiyi wäŋalilnydja ḏarrtjalknha ŋayaŋuny, dhuwurr-dhunupan ŋayi ŋunhi nhanukiyingalnydja God-Waŋarrwalnydja maŋutjiŋur. Yo. Ŋuli nhe dhu ga ŋunhi ŋal'maranhamirrnydja nhunapinya nhe, ŋayiny dhu God-Waŋarryuny nhuna dhuḏi'maraman ŋoylila, ga ŋuli nhe dhu nyilŋ'maranhamirr dharraḏakunhamirr, ŋayiny dhu nhuna God-Waŋarryuny ḻaw'maraman ŋurruŋuyaman.” Bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yo. Ga wiripuwurruynydja yolŋuy walal marrtjin gäŋa'-gäŋal djamarrkuḻi'nhan walalaŋguwuy walal balan nhanukalnha Djesuwala, märr ŋayi dhu walalaŋgal goŋ-ŋal'yun marrtji ŋurikiwurruŋgalyi djamarrkuḻi'wal. Ga walalnydja bäy ŋuriŋiwurruynydja malthunamirriynydja nhanukal nhäŋalnha walalany, bala yan waŋanany dhärukthun ḏälyun, ŋaŋ'ŋaŋ'thurrnydja. ");
INSERT INTO djr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ga ŋayiny ŋunhi Djesuynydja walalany nhäŋal ŋunhiwiliyi, bala ŋayi wäthurra walalaŋ bitjarra, “Way, gäŋu walal dhuwaliyi djamarrkuḻiny' räli ŋarrakal. Yaka nhuma dhu walalany ŋaŋ'ŋaŋ'thun. Bili yuwalktja ŋunhi nhanŋuwuynydja God-Waŋarrwuny yolŋu walal, balanyayin mala nhakun dhuwalawurryin; ŋuli ŋayi yolŋu ŋayaŋu balanya nhakun dhuwalawurryiny djamarrkuḻiny', ŋayiny dhu ga ŋunhiyiny nhina yuwalkkuman yan God-Waŋarrwalnha romŋurnydja. ");
INSERT INTO djr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yuwalk yan ŋarra nhumalaŋ ga dhuwal lakaramany. Ŋuli nhe dhu ga ŋula yolthu yolŋuy gumurr-ŋamathinyawurr märram ŋunhi God-Waŋarrwu rom bitjan nhakun ŋunhi yothu ŋuli ga gumurr-ŋamathirr ŋarraku, ŋunhiyin nhe dhu ŋunhi yolŋu gärri balany God-Waŋarrwalnydja wäŋalil.” ");
INSERT INTO djr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ga waŋganydhuny yolŋuy buŋgaway dhä-birrka'yurr ŋanya Djesuny bitjarr, “Way Marŋgikunhamirr, nheny dhuwal ŋamakurr mirithirr, nhaltjan dhika ŋarra dhu, märr ŋarra dhu ga nhina ŋunhal God-Waŋarrwalnydja wäŋaŋur, bitjandja bili wiyinŋumirrnydja?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ga ŋayiny Djesuynydja ŋanya waŋan bitjarr, “Nhaku nhe ga dhuwal ŋarrany manymak lakaraŋalnydja? Yaka dhuwal ŋula yol yolŋu manymak; ŋayipin dhuwal waŋganynha God-Waŋarrnha yan ŋamakurrnydja mirithirrnydja. ");
INSERT INTO djr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Marŋgi muka nhe dhuwal dhiyakuny ŋunhi dhäruk-nhirrpanminyawuywu gam', ‘Yaka marramba'yiny, ga yaka buŋu murrkay'kuŋuny yolŋunhany, ga yakayi yan manaŋiny, ga yaka nyäḻ'yurrnydja lakaraŋ, ga märr-ŋal'yurr muka gi yuwalkkuŋ nhokiyingalaŋawnha nhe bäpa'mirriŋuwnydja ga ŋäṉḏi'mirriŋuwnydja.’” ");
INSERT INTO djr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ga ŋayiny ŋunhiyiny ḏirramuny buku-bakmaraŋal bitjarr, “Way Garray, dhuwandja mala ŋunhi dhäruk-nhirrpanawuy rom mala ŋarra gan ŋayathaŋala yan, beŋur bili yan ŋunhi ŋarrany yothu muka yan.” ");
INSERT INTO djr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ga ŋunhi nhakun ŋayi Djesuy ŋäkulnydja ŋanya balanyawuyyiny waŋanhawuy, bala ŋayi waŋan nhanŋu bitjarrnha, “Yo manymak dhuwali. Yurr waŋganynha nhe ga dhuwali momany. Nheny dhuwal yolŋu girri'-dharrwamirr. Gatjuy gurrupula nhuŋuwuy nhe ŋunhi nhäny mala, warrpam'thurr yan djalkthurrnydja, gurrupulnydja ŋurukuwurruŋgun ŋunhi ŋurruwuykmirriwnha yolŋuwnydja walalaŋ, bala ŋayiny dhu nhuŋun gurrupan ŋayipin yan God-Waŋarryun, bulun ŋamakurrnha ŋunhi nhä malany ŋunhaŋuwuynha yan djiwarr'puynha, märr nhe dhu yuwalktja ḻukunydja'yirr ŋuriŋiyin. Gatjuy marrtjin, ga djämany nhe dhu ga bitjandhin, bala roŋiyiny, bala malthurra ŋarrakun.” ");
INSERT INTO djr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ga ŋunhi ŋayi gan ŋuriŋiyi yolŋuy ŋäkulnydja balanyawuyyiny waŋanhawuy Djesunhany, bala yan ŋayi ŋurru-yupthurrnydja mirithinan yan, warwuyurra manapar, bili ŋayi ŋunhi mirithirr ḻukunydja' yolŋu. ");
INSERT INTO djr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Bala ŋayi gan Djesuynydja ŋanya nhäŋala galŋa-miḏikinyalila, bala ŋayi waŋanan bitjarra, “Ḏälnha dhuwal ḻukunydjawny'tja yolŋuw gulŋiyinyaraw God-Waŋarrwalnydja romlil! Nhä ŋunhi ṉelwuny dhawaraŋ', gana' muka gamuḻwuny gärrinyaraw? Bäyŋu warray, bili mirithirr ŋunhi nyumukuṉiny' dhawaraŋ'tja. Ga balanyayi bili ŋurikiny ŋunhi yolŋuw girri'-dharrwamirriwnydja; gumurr-ḏälyi yan nhanŋu gulŋiyinyaraw balany God-Waŋarrwalnydja romlil.” ");
INSERT INTO djr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ga walalnydja ŋunhi yolŋu'-yulŋuynydja ŋäkulnydja ganyim'thurra, bala walal dhä-birrka'yurrnydja ŋanya Djesunhany bitjarrnha, “Yol dhika dhu ga yolŋu walŋany nhina?” ");
INSERT INTO djr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Bala ŋayi Djesuny buku-bakmaraŋal bitjarrnha, “Yolŋuny dhu ŋunhi bäyŋun walŋakunhamirr ŋanyapinyany ŋayi ŋula nhaliynydja romdhu. Yurr God-Waŋarryuny dhu ŋunhi djäman bala yan.” ");
INSERT INTO djr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bala ŋayi Betany waŋanan bitjarrnha Djesuwnydja, “Garray, ŋanapurrnydja ŋunhi ganarrthaŋal napurruŋguwuynydja wäŋa malany ga ŋula nhä bukmak yan, bala yan ŋanapurr malthurrnydja nhuŋun,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ga ŋayiny Djesuny bilyurr ga waŋan bitjarr, “Yo. Yurr yuwalk ŋarrany ga dhuwal nhumalaŋ lakaram. Ŋuli ŋayi dhu ŋula yolthu yolŋuy ganarrthamany nhanŋuwuy ŋayi nhäny malany bukmakkumany, balanya nhakun wäŋa, ga miyalknha nhanŋuwuy ŋayi, ga wiripuny nhakun wäwa'mirriŋuny ga ŋäṉḏi'mirriŋuny, ga bäpa'mirriŋuny nhanŋuwuy ŋayi ga djamarrkuḻiny', God-Waŋarrwalaŋuwnha romgu malthunaraw, ");
INSERT INTO djr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ŋurikiyiny dhu yolŋuw God-Waŋarryuny gurrupan bulun dhika ŋula nhä malany ŋamakurr, bukulila ŋal'-ŋalmaram marrtji dhu dhiyaŋuny bala dhiyalnydja munatha'ŋurnydja, ga ŋunhalnydja ŋayi dhu ga nhina walŋan yanan, bitjanna bili wiyinŋumirra.” Ga bitjarra ŋayi gan Djesuny waŋan. ");
INSERT INTO djr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bala ŋayi marrtjin Djesuynydja ḻuŋ'maraŋala walalany waŋganylila nhanŋuwuynydja ŋayi ŋunhi malthunamirriny mala ŋunhi 12-nhany. Bala ŋayi lakaraŋalnydja walalaŋgal bitjarrnha, “Ŋäkuny walal ŋamathaŋ yan. Dhuwandja limurr ga marrtjin balan Djurutjalamlila. Ga nhä mala walal gan ŋunhi djawarrkmirriy mala ŋäthil wukirri nhanukalaŋuwuy, lakaraŋal gan ŋunhiyi Yolŋuny Gäthu'mirriŋuny, dhiyaliyin wäŋaŋur dhu gi boŋguŋun maḻŋ'thurr. ");
INSERT INTO djr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Walal ŋarrany dhu dhayuŋanna wiripuwurruŋgalnha yolŋuwal walalaŋgal goŋlil, ŋurikiwurruŋgala ŋunhi walal yakan Djuw mala, bala dhu ŋuriŋi Djan'tayilyuny yolŋuy walal ŋarranhany wakalkuman, warku'yunna manapan ŋarrany dhu, ga dhupthunna dhu ga. ");
INSERT INTO djr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Walal dhu marrtji burruṯiŋuynha bartjunmaram ŋarrany, bala dhu buman murrkay'kuman. Yurr ŋarrapiny dhu rur'yurr warray, bulu dhu ŋarra walŋathiyi ŋuriŋiny ŋunhi dhu märrma' munha djuḻkthurr.” ");
INSERT INTO djr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ga bitjarr ŋayi gan Djesu lakaranhaminany ŋanyapinya ŋayi, ga walalnydja ŋunhi malthunamirriynydja walal nhanukal ŋäkul ŋanya, yurr bäyŋu walal ŋanya dharaŋanany. Baḏak yan gan ŋunhi bitjarr bili mayaliny' ŋorran djuḻuḻ'yunawuy walalaŋ, yaka walal marŋgi nhaltjarr ŋayi gan ŋunhi Djesu lakaranhamin. ");
INSERT INTO djr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yo. Djesu ga nhanŋu malthunamirr walal wäŋgaŋal marrtjin dhukarr-ŋupar bala, yurr galkin bukuy-märraŋalnha marrtjin Djarikawnydja wäŋa, ga ŋunhiliyi galki dhukarrŋur waŋgany gan yolŋu nhinan bambay, dhä-ŋäŋ', ŋäŋ'thurr ŋayi gan yolŋuny walalany rrupiyaw. ");
INSERT INTO djr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bala ŋayi ŋäkulnha rirrakaynha yolŋunhan walalany, walal marrtjin räli wäŋgaŋal ŋuliwitjarryi dhukarrkurr djuḻkmaraŋal. Bala ŋayi dhä-birrka'yurr yolŋu'-yulŋunhany bitjarrnha, “Way nhaltjan marrtji dhikany?” ");
INSERT INTO djr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ga walalnydja lakaraŋal nhanukal bitjarr, “Djesu ga dhuwal marrtji djuḻkthun ŋunhi wäŋa-Nätjuritjpuy,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Bala ŋayi dhunupan wäthurra bitjarr ŋunhiyiny bambaynydja ḏirramu, “Way Djesu, gäthu'mirriŋu Daybitku, buku-djulŋi ŋathil ŋarraku wuyurr go.” ");
INSERT INTO djr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bala nhakun ŋuriŋiwurruynydja yolŋuy walal ŋunhi walal gan ŋurruŋu marrtjin, walalnydja way'yurra ŋanya, yurr ŋayiny yaka mukthunna ŋunhiŋuwuyyiny way'yunawuynydja walalaŋguŋ; ŋayiny gan bitjarra bili yan yatjurrnha, yäku-lakaraŋalnha ŋanyanhan Djesunhan bitjarr, “Djesu, Gäthu'mirriŋu Daybitku, wuyurr ŋarraku go,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bala ŋayi Djesuynydja ŋäkula ŋanya, bala dhärranan gan, ga waŋan bitjarrnha, “Go, gäŋu walal ŋanya räli ŋarrakal.” Bala ŋayi yan dhunupan wapthurrnydja, bala nhinan djartjaryurra Djesuwalnha. Ga ŋayi Djesuynydja ŋanya dhä-birrka'yurr bitjarr, ");
INSERT INTO djr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nhaku nhe djäl? Nhaltjan ŋarra nhuna dhu dhika yulŋuny?” bitjarr. “Garray, ŋarrany dhuwal djäl nhänharawnha, ŋarra dhu ga nhäman,” ga bitjarr ŋayiny bambaynydja buku-bakmaraŋal nhanŋuny. ");
INSERT INTO djr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Bala ŋayi Djesuynydja lakaraŋal bitjarrnha nhanŋuny, “Ma', bira'yurra nhäŋun! Bili nhokiyingal dhiyaŋi märr-yuwalkthinyaray nhe dhuwali manymakthinany.” ");
INSERT INTO djr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bala yan ŋayiny dhunupan maŋutjimirriyinan nhäŋalnha, bala ŋayi yan malthurra nhanŋun Djesuwnha dhukarr-ŋupara, buku-gurrparnydja ŋayi mirithinan God-Waŋarrnhany. Ga ŋunhi nhakun bukmakthun yolŋuynydja walal nhäŋalnydja ŋanya, bala yan walal buku-gurrpara God-Waŋarrnha, wokthurra manapar. ");
INSERT INTO djr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yurr ŋayiny gan ŋunhi Djesuny baḏak yan marrtjin, ga yan bili ga gulŋiyin ŋayi wäŋaŋur yäkuŋur Djarikaw, yurr ŋayi gan ŋunhi djuḻkthurr yan marrtjinany. ");
INSERT INTO djr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ga ŋunhiliyi gan nhinan waŋgany yolŋu ḏirramu yäku Djakiyatj, ga djämany nhanŋu ŋuriki, ŋayi ŋuli marrtjinya gombu'-gumbunha rrupiya gapmangu yolŋuny walalany. Ga ŋayipiny ŋunhiyiny yolŋu Djakiyatjtja balanyayi bili ŋurruḏawalaŋu yan ŋuriki rrupiyaw malaŋuw märranharaw, ga yolŋuny ŋayi ŋunhi mirithirra ḻukunydjan'. ");
INSERT INTO djr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bala ŋayi ŋunhi Djakiyatjthuny ŋäkulnha ŋanya Djesunhany, ŋunhi ŋayi gan marrtjinany Djesuny ŋuliwitjarryin wäŋakurrnydja, ga bulu nhakun ŋayi ŋunhi djälthinany nhanŋu nhänharawnydja mirithinan, nhäthinya ŋayi ŋunhi yolŋuny Djesuny. Yurr dharrwaynha ŋunhi mirithirra yolŋuynydja walal gungaŋalnydja dhukarrnydja warrpam'thurra, bala ŋayi yan Djakiyatjthuny gan nhäŋalnydja ŋanya rurraŋ'-rurraŋ'thurra, yurr bäyŋu ŋayi ŋanya nhäŋalnydja, bili ŋayi ŋunhi gurruri mirithirr ḏirramu. ");
INSERT INTO djr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bala ŋayi beŋuryiny Djakiyatjtja waṉḏinan ḻirraŋun, bala ŋal'yurra dharpalila, ga ŋunhiliyin ŋayi gan ŋunhi dharpaŋura gorruŋalnydja nhinanany, galkurra ŋayi gan nhanŋu Djesuw ŋunhi ŋayi gan marrtjin ŋuliwitjarryin dhukarrkurrnydja. ");
INSERT INTO djr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ga ŋayiny ŋunhi Djesuny marrtjin, bala ŋayi yan dhärranany galkin, ga dhunupan yan ŋayi ŋunhi dhupuŋalnydja garrwarlila, bala waŋan bitjarra, “Go Djakiyatj, yarrupthurra bondin rälin. Ŋarrany muka dhu dhuwal nhina nhokal wäŋaŋur dhiyaŋuny bala waluy.” ");
INSERT INTO djr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bala ŋayi yan Djakiyatjtja mirithinan dhikan märr-ŋamathinany, goŋmirriyinan manapar, bala ŋayi yan dharpaŋurnydja yarrupthurr ganydjarryun, bala yan gaḏaymara ŋanya Djesuny dhunupan nhanukiyingalnha ŋayi wäŋalilnydja. ");
INSERT INTO djr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ga walalnydja gan ŋunhi yolŋu'-yulŋuynydja nhäŋalnha maṉḏany, maṉḏa marrtjin bala waṉḏinan, bala walal waŋanhaminan walalanhawuynha walal, gupa-waŋanany walal ŋanya gan Djesunhany bitjarra, “Nhaku ŋayi ŋunha marrtjin balany ŋurukalnydja yolŋuwal wäŋalil dhuwurr-yätjkalnydja?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ga ŋunhiliyiny wäŋaŋurnydja nhanukal Djakiyatjkalnydja, bala ŋayi dhärranan gumurrŋura nhanukal Djesuwalnha, bala ŋayi Djakiyatjtja waŋanany bitjarrnha, “Way buŋgawa nhäŋun! Ŋarrany dhu dhuwal mala-wulkmaraman märrma'lila bukmak nhä malany ŋunhi ŋarra ga dhuwal ŋayatham, bala ŋarra dhu waŋganydja mala-wulkthunna ga gurrupan ŋurukuwurruŋgun ŋunhi ŋurruwuykmirriwnha yolŋuw walalaŋ. Ga bitjandhi bili ŋarra dhu gurrupandhi buku-roŋanmaramdhi ŋurikiwurruŋguny yolŋuw walalaŋ ŋunhi ŋarra walalany gan ŋäthil gombu'-gombuŋal ŋarrakuwuy ŋarra ḻukunydja'kunhaminyaraw; ŋarra walalaŋ dhu roŋanmaramany bulu dharrwa, bukulilyi ŋal'maram ŋunhiwiliyi ŋunhi ŋarra walalaŋ gan ŋäthil djaw'-djawyurr.” Ga bitjarra ŋayi gan Djakiyatjtja Djesuwalnydja waŋan. ");
INSERT INTO djr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Bala ŋayipiny Djesuny waŋan bitjarrnha, “Gäthurnydja dhuwal dhiyaŋuny bala, ŋunhin walŋamirrnydja rom bilin maḻŋ'thurra dhiyalnydja nhumalaŋgalnydja ŋunhi nhuma ŋuli ga ŋorra dhiyal wäŋaŋur, bili dhuwandja ḏirramu yuṯan, bilin ŋayi yuṯathinan mirithinan, ga yuwalknha ŋayi dhuwal Yipurayimgalnha yarraṯaŋurnydja. ");
INSERT INTO djr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bili ŋarrany räli yarrupthurr dhuwal Gäthu'mirriŋuny Yolŋuny, ḻarrunharaw muka ga walŋakunharaw ŋurikiwurruŋ yan ŋunhi walal winya'yunawuy mala.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yo. Yolŋuny walal gan ŋunhi buthuru-bitjurra nhanŋuny Djesuwnydja, ŋunhi ŋayi marrtjin lakaraŋal walalaŋ bitjarr, “Ŋarrany dhuwal marrtjin räliny walŋakunharaw ŋurikiwurruŋ ŋunhi winya'yunawuywu yolŋuw walalaŋ.” Ga dhäŋur beŋuryiny ŋayi lakaraŋal walalaŋ wiripun muka dhäwu mayali'mirra, bili galki walal marrtjin ŋunhi ŋayathaŋala Djurutjalamdja wäŋa, ga walalnydja yolŋu'-yulŋuynydja guyaŋan djarrpi'kuŋala, “Galki dhu God-Waŋarrwuny rom maḻŋ'thunna, bili ŋayi dhu ŋunhi Djesuy Djurutjalamdja wäŋa ŋayatham, bala ŋayin dhu buŋgawathirrnydja limurruŋguny dhiyakuny wäŋaw.” Ga bitjarryin walal marrtjin ŋunhi guyaŋanany. ");
INSERT INTO djr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bala ŋayipiny Djesuynydja dhäwu lakaraŋal mayali'mirra bitjarra gam', “Waŋgany gan yolŋu nhinan ŋurruḏawalaŋu, yurr waŋganydhuny waluy ŋayi ganarrthaŋala ŋunhiyiny wäŋa nhanŋuwuynydja ŋayi, bala marrtjinan bitjarra bala barrkulila, märr ŋayi dhu ŋunhiliyin ŋurruŋuyirrnydja buŋgawathirrnydja, ga roŋiyirryi ŋayi dhu balayi bili nhanukiyingalyi wäŋalil, bala ŋayi dhu ga nhinan bitjanna bili ŋurruŋun yan, buŋgawan ŋayi dhu ŋunhiliyiny wäŋaŋur nhanukiyingalnydja ŋayi.” ");
INSERT INTO djr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Yo. Ga yurrnha ŋayi ŋuriŋiyi buŋgaway ganarrthaŋalnydja ŋunhiyiny wäŋa, ŋurruŋuny ŋathil ŋayi wäthurr ŋurikiwurruŋ ŋunhi djämamirriw mala nhanukalaŋaw, 10-gu yolŋuw walalaŋ, bala ŋayi ŋunhi gurruparnydja walalaŋgal djägalilnydja waŋga'-waŋganynha ŋarakany rrupiyany, yurr ḏilkurra mirithirra ŋunhi yulŋuny. Bala ŋayi lakaraŋalnydja bitjarrnha, ‘Ŋay', djämany gi dhiyaŋuny ŋuthanmaraŋun marrtji yindikuŋun bala, yan bili ga bäy ŋarra dhu roŋiyi,’ bitjarr. Bala ŋayi yan marrtjinan ganarrthaŋala ŋunhiyiny wäŋa.” ");
INSERT INTO djr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Manymak. Yurr nhanŋuwuynydja ŋunhi yolŋu walal ŋuyulkthinan gan nhanŋuny ŋunhi buŋgawawnydja, bala walal djuy'yurrnydja dhäwumirrinhan walalany, bala walalnydja marrtjinan ŋunhiwiliyin wäŋalil barrkulila, ga lakaraŋalnydja walal ŋunhi bitjarrnha, ‘Yakan ŋanapurr ŋurikiyiny yolŋuw djäl ŋayi ŋanapurruŋ dhu ŋurruŋuyirr ga buŋgawayirr,’ bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yurr yuwalk yan ŋayi ŋunhiyiny ḏirramu ŋunhaliyiny wäŋaŋur ŋurruŋuyinany, ga dhäŋur beŋuryiny bala ŋayi roŋiyinan balayin. Bala ŋayi yan dhunupan gawaw'yurra ŋurikiwurruŋguny djämamirriwnydja mala nhanukalaŋaw, ŋurikiwurruŋguny ŋunhi ŋayi gurrupar ŋäthil walalaŋgal djägalil ŋunhiyi rrupiya mala 10-ŋaraka. Bala walal marrtjinan nhanukal märr ŋayi dhu maḻŋ'maraman walalaŋgal, nhaltjarr walal gan djäma ŋuriŋiyi ŋunhi ŋayi gurrupar walalaŋgal djägalil.” ");
INSERT INTO djr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ga ŋayiny ŋathil waŋgany yolŋu marrtjin nhanukal ŋurikalyiny ŋurruḏawalaŋuwal, bala ŋayi lakaraŋalnydja bitjarrnha, ‘Buŋgawa, ŋarrany gan dhuwal djäma ŋuriŋiyi ŋunhi nhe ŋarrakal gurrupar goŋlil ŋäthil waŋgany ŋaraka. Ga buluny nhakun ŋarrapin bukulilnydja ŋal'maraŋal dharrwany ŋunhiwiliyiny waŋganylilnydja ŋarakalil, 10-guŋalnydja.’ ");
INSERT INTO djr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ga ŋayiny ŋunhi buŋgawany yolŋu waŋan bitjarra, ‘Way, dhuwal nheny manymak warray djämamirr. Nheny gan dhuwal djäma manymakkuŋal yan ŋuriŋiyiny ŋunhi nyumukuṉiny'thuny rrupiyay ŋunhi ŋarra nhokal goŋ-gurrupar, ga dhuwal ŋarra dhu bulun gurrupan dharrwan mirithirra nhokalnydja djägalil. Nheny dhu ŋunhi djägamirr ŋurikin ŋunhi wäŋaw malaŋuw goŋ-märrmaw'nha.’” ");
INSERT INTO djr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Bala wiripuny muka yolŋu djämamirr marrtjin ŋunhiwiliyi buŋgawawal, ga lakaraŋal ŋayi bitjarr, ‘Buŋgawa, ŋarrany gan dhuwal djäma ŋuriŋiyi ŋunhi nhe ŋarrakal gurrupar djägalil, ga ŋarrany bulu nhakun ŋunhiwiliyi bukulil ŋal'maraŋal balanyayi bili dharrwa, 5-kuŋala,’ bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ga ŋayiny waŋan ŋunhiyiny buŋgawany, ‘Manymak dhuwaliyi,’ bitjarr. ‘Ga nheny dhu ga djäga ga 5-ku yan wäŋaw malaŋuw.’” ");
INSERT INTO djr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ga dhäŋur beŋuryiny wiripun yolŋu djämamirr marrtjin ga lakaraŋal nhanukal bitjarr, ‘Buŋgawa, ŋay', dhuwanna ŋunhi bili yan nhokiyinguŋ rrupiya ŋunhi nhe ŋarrakal gurrupar djägalil. Ŋarrany gan ŋunhiyi ŋayathaŋal garrpinawuy manydjarrka'mirr yan, bala yan ŋarra djuḻuḻ'maraŋala, märr ŋayi bäyŋun winya'yunany. ");
INSERT INTO djr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ŋarrapiny nhuŋu dhuwal märr-barrarin, bili nhepiny dhuwal ḏäl mirithirr buŋgawa. Nhe ŋuli ga ŋunhi djälthirr dharrwawnha märranharaw ŋurikiwurruŋgalnydja ŋunhi wiripuwurruŋgalnydja yolŋuwal walalaŋgal djämaŋur mala.’ ");
INSERT INTO djr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ga ŋayiny ŋunhi buŋgawany waŋan bitjarr ŋurikiyiny djämamirriwnydja, ‘Nheny dhuwal djäma-yätjmirr. Ŋuriŋiyiny dhäwuyny'tja nhokal ŋarrany nhuna dhu dhuwal yätjkurr-lakaraman. Nheny ŋarrany gan ŋunhi bitjarryin guyaŋan, yanbi ŋarra dhuwal ḏälnha ḏirramu? Ga bulu nhe ŋuli ga ŋunhi guyaŋa bitjan, yanbi ŋarra ŋuli gi djälthi märranharawnha roŋanmaranharaw dharrwawnha ŋurikin ŋunhi nhä malany ŋarra nhokal gurrupar? ");
INSERT INTO djr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yurr nhaku nheny bäyŋu ganha djäma ŋamathanha ŋuriŋiyiny ŋunhi ŋarra nhokal gurrupar? Ŋuli balaŋ nhe rulwaŋdhuna ŋula djorra'lilnydja ŋunhiyiny rrupiya, ŋarrany balaŋ ŋunhi märranha bulun dharrwa bukulil ŋal'maranhawuynydja ŋunhiwiliyiny rrupiyalil beŋurnydja ŋunhi ŋarra roŋiyinany dhuwal.’” ");
INSERT INTO djr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Bala ŋayi buŋgawany ŋunhi bilyurra, ga waŋan ŋurikiwurruŋgalnha wiripuwurruŋgalnha ŋunhi walal gan dhärra'-dharran ŋunhiliyi, ‘Ma', märraŋun walal ŋunhany rrupiyany ŋarakany ŋunhi ŋarra nhanukal gurrupar, ga gurrupul ŋurikalnha yolŋuwal ŋunhi ŋayi ga ŋayatham 10 ŋaraka.’ ");
INSERT INTO djr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ga walalnydja waŋan bitjarr, ‘Way Buŋgawa, ŋunha ŋayiny ga dharrwa mirithirr ŋayatham.’” ");
INSERT INTO djr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ga ŋayiny waŋan ŋunhi buŋgawany yolŋu bitjarra, ‘Yuwalk ŋarra nhumalaŋ ga dhuwal lakaram. Ŋunhi ŋayi dhu ga ŋula yolthu yolŋuy ŋayatham baṯ-bitjandja ŋarrakuŋuny gurrupanawuy, ŋarrany dhu nhanŋu gurrupan ŋurikiyiny yolŋuw mirithirra dharrwa. Ga ŋunhi ŋayi dhu ga nhina dhäparŋ'tja, bäyŋu ŋayi gi ŋayathul ŋula nhä ŋarrakuŋ gurrupanawuy, bala ŋarrany dhu ŋurikalyiny yolŋuwal djaw'yunna märraman ŋunhi ŋula nhä malany ŋayi ga ŋayatham nyumukuṉiny'.’ ");
INSERT INTO djr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ga bulu nhakun ŋayi waŋan ŋunhiyi buŋgawa bitjarr, ‘Go gäŋun walal rälin ŋunhi miriŋunhany mala ŋarraku, ŋunhiwurrunhany yolŋuny walalany ŋunhi walal yaka ga djälthirr ŋarraku buŋgawathinyaraw. Gäŋun walalany rälin dhipala ŋarrakalnha, bala buŋun. Yakan walal dhu ga nhina dhiyalnydja ŋarrakalnydja.’” Bitjarryin ŋayi gan ŋunhi Djesuy mayali'wurrnydja dhäwu lakaraŋal. ");
INSERT INTO djr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ga dhäŋur beŋuryiny ŋunhi ŋayi gan Djesuy lakaraŋalnydja dhäwuny', bala walal yan marrtjinan dhukarr-ŋupara balan bitjarra buku Djurutjalamlila. Yurr ŋayipiny gan ŋunhi Djesuny marrtjin ŋurruŋu, ga walalnydja gan ŋunhi malthunamirrnydja walal nhanŋu marrtjin dhuḏikurr ŋapa-rurraŋ'thurra ŋanyanhan. ");
INSERT INTO djr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ga marrtjinany walal ga-a-an, yan bili Baṯpatjtja* ga Bithininy* wäŋaŋur, yurr bukuŋura yäkuŋur Wolipnha,* ŋayiny ŋunhi gumurr-galkithinan wäŋa Djurutjalamdja. Ga ŋunhiliyiny ŋayi Djesuy waŋanan märrmany' malthunamirriny maṉḏany nhanŋuwuy ŋayi bitjarra, ");
INSERT INTO djr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Gatjuy marrtjin maṉḏa ŋunhawalnha wäŋalil, ya ŋunhawalnha. Ga ŋunhi nhuma dhu bunany ŋunhiliyiny, bala nhuma dhu maḻŋ'maraman duŋ'kinhany, yurr yuṯa ŋunhi yulŋuny, yaka ŋula yolŋuwuŋuny ŋäthiliŋuwuy bäkiwuy, ga dhärrany ga ŋunhi garrpinawuy. Yupmaramany nhuma dhu ŋunhiyi duŋ'kinhany, bala gäman rälin ŋarrakalnha. ");
INSERT INTO djr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ga ŋuli dhu ŋula yolthu yolŋuy dhä-birrka'yundja nhumalany bitjan, ‘Way, nhaku nhuma dhuwal yupmaraŋalnydja dhuwaliyiny?’ bitjandja, ga nhumany dhu lakaram bitjan, ‘Garray dhuwal djälthin dhiyak.’ Bitjan nhumany dhu lakaram.” ");
INSERT INTO djr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bala maṉḏa marrtjinan ga maḻŋ'maraŋalnydja ŋunhi bili yan ŋunhi nhaltjarr ŋayi Djesuy lakaraŋal maṉḏaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yupmaraŋalnydja maṉḏa ŋunhiyi duŋ'kinhany, bala ŋayiny ŋuriŋiny wäŋa-waṯaŋuynydja yolŋuy nhäŋalnha, ga waŋan bitjarr warray, “Way maṉḏa, nhaku nhuma ga dhuwali yupmaramany?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ga maṉḏany buku-roŋanmaraŋal nhanŋuny bitjarra, “Garray djälthin dhiyak,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bala maṉḏa gäŋalnha ŋunhiyi duŋ'kinhany balan Djesuwalnha. Bala walal bukmakthun yan marrtjin ḻarrmaraŋalnydja walalaŋguwuy walal girriny' malany, bala ŋal'maraŋala marrtjin girriny' mala ḏiltjilila ŋurikalyiny duŋ'kiwalnha, bala ŋayi Djesuny ŋal'yurra ŋurikalyin warrakan'kalnydja ḏiltjilila. ");
INSERT INTO djr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Marrtjinany ŋayi gan bala, gorruŋalnha ŋayi marrtjin ŋurikalyin duŋ'kiwalnha ḏiltjiŋurnydja, bala dharrwaynha yolŋuynydja walal marrtjin ḻarrmaraŋalnydja girriny' mala, bala miṉdha'-miṉdhalaraŋalnha marrtjin dhukarr-ŋupara bala, dhukarrnha walal marrtjin djäma manymakkuŋalnha nhanŋu Djesuwnha marrtjinyaraw. ");
INSERT INTO djr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wäŋgaŋalnydja walal marrtjin ŋunhi, balany yarrupthurrnydja Djurutjalamlila, yurr ŋulawitjarra dhukarrkurrnydja bukukurrnydja Wolipkurra, ga ŋunhiliyiny bukuŋur dharrwan gan mirithirra yolŋuny walal yatjunminany, wokthurra gan God-Waŋarrwun, buku-gurrpara gan God-Waŋarrnhan ŋunhiŋuwuynha ŋunhi walal nhäŋal mirithirr ganydjarr-ḏumurr rom nhanukal Djesuwal djämalil. ");
INSERT INTO djr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ga bukmaknha walal marrtjin ŋunhi wäŋgaŋalnydja märr-yiŋgathinan, wokthurra nhanŋu mirithinan, goŋmirriyinany gan bitjarrnha gam', “Nheny dhuwal napurruŋ ŋurruŋu buŋgawa. Nheny ga dhuwal marrtji Garraywalaŋuwurr warray yäkukurr, ga God-Waŋarrnydja nhuŋu ŋuli ga ŋunhi marrkapthundja mirithirra. Galkin ŋanapurr dhu dhuwal nhinan ŋayaŋu-yal'yunan ŋula nhämiriwnha marimiriwnha, nhanukalnha djiwarr'puywalnha romŋurnydja. Go limurrnydja wokthunna God-Waŋarrwun.” Bitjarrnha walal gan ŋunhi yatjunminany, märr-yiŋgathinany marrtjin bala. ");
INSERT INTO djr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ga ŋunhiliyi malaŋur wiripuwurr gan yolŋu walal Baratji mala malthurr nhanŋu, bala walal waŋanan Djesuwalnydja bitjarrnha, “Way Marŋgikunhamirr, mukmaraŋ dhuwali yolŋuny walalany, malthunamirriny mala nhuŋuwuy nhe.” ");
INSERT INTO djr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋguny balany bitjarr warray, “Märr-yuwalk ŋarra nhumalaŋ dhu dhuwal lakaramany. Ŋuli balaŋ dhu dhuwalawurrnydja yolŋuny walal mukthun, bala walalnydja dhu ŋunhi dhuwanna guṉḏan mala yatjunmirrnydja, wokthundja walalnha dhu God-Waŋarrwuny.” ");
INSERT INTO djr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yo. Ga marrtjinany ŋayi gan ŋunhi Djesuny balany, ga yan bili ga galkithinan marrtjin Djurutjalamdja wäŋa. Bala ŋunhiliyin ŋayi gulyurrnydja, bala nhäŋalnha ŋayi gan ŋunhiyin wäŋan, wuyurra manapar ŋayi ŋurikiyin wäŋawnha. Bala yan ŋayi ŋäthinan. ");
INSERT INTO djr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ga bitjarrnha ŋayi ŋunhi waŋanany, “Nhumany djäl nhuma dhu ga nhina romŋur mägayaŋura yan. Ga dhuwanna dhiyaŋuny bala ŋayiny ŋunhiyiny yolŋu mägayakunhamirrnydja ga nhina nhumalaŋgala, yurr yakan nhumany ŋuli ŋunhi märraŋuny ŋanya. Ga dhiyaŋuny bala nhuma dhu yakan ga nhina mägayaŋurnydja, bili nhuma gi yakan nhäŋu dharaŋulnydja ga marŋgithiny gi; bili nhuma ga dhuwal nhinany warrpam'nha maŋutji-gunganhawuynha walal.” ");
INSERT INTO djr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","“Yo, galki dhu miriŋuny dhipal wäŋalil marrtjin, bala walal dhu ḻirra-garrpina dhärrany marrtji, wäŋany dhu dhuwal gungaman nhumalaŋ, ga bäyŋuthirra dhu nhumalaŋguny dhaḻakarr waṉḏinyarawnydja winya'yunarawnydja. ");
INSERT INTO djr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dhunupa walal dhu marrtji dhuwal wäŋany mala ḏiwirrkthunna, ga yolŋunhany walalany walal dhu bitjandhi bili yan bumayi dhawar'maramdhi, warrpam'thunna dhu buwayakkuman. Ga bäyŋun dhu ga ŋula waŋganydja guṉḏany dhärra bäythinyawuynydja; warrpam'thunna dhu buḻ'waŋmaramany, muṉguynha marrtji dhu ŋorrany, bili nhuma yaka ŋanya nhänha dharaŋana ŋunhi ŋayi God-Waŋarryuny guwatjmar räliny nhumalanhany, walŋakunharaw muka nhumalaŋ.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja wäŋa-Djurutjulambuywuny yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ŋunhi nhakun ŋayi Djesuy Djurutjalamdja wäŋa ŋayathaŋal, ga dhunupan ŋayi ŋunhi marrtjinany buku-ŋal'yunamirrilila buṉbulilnydja. Ga dhunupan nhakun ŋayi Djesuynydja nhäŋalnha yolŋunhan walalany ŋunhiwiliyin God-Waŋarrwalnha buṉbulil, walal gan yolŋuny walal gurrupanminan buku-djuḻkmaranhaminan rrupiyany, ga djalim walal gan warrakan' mala ŋunhiliyin djinawan' God-Waŋarrwalnha buṉbuŋur. Bala yan ŋayiny dhunupan Djesuynydja ŋaŋ'ŋaŋ'thurra walalany gan dhawaṯmaraŋala ŋunhiyiny yolŋu'-yulŋunhany, ");
INSERT INTO djr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","bala ŋayi waŋanan walalaŋ bitjarra, “Dhuwal djorrayny'tja ga lakaram God-Waŋarrwuny dhäruk bitjan gam', ‘Ŋarrakuny dhu ga ŋunhi buṉbu dhärra gäna yan, waŋganygu yan gämurruw' buku-ŋal'yunaraw, ga bilin,’ bitjan. Ga nhumany dhuwaliyiny ŋunhi buṉbu bilmaraŋal warray, ŋula nhakun malaŋuw djalimgun, manaŋinyarawnha rrupiyawnha wiripuwurruŋgalaŋaŋurnha yolŋuwal walalaŋgal djaw'yunarawnha. Bitjanna nhuma ŋuli ga dhuwali djämany bilmaramany. Gatjuy waṉḏi'-waṉḏin walal dhipuŋurnydja.” Ga bitjarr ŋayi gan Djesuny waŋan dhawaṯmaraŋalnydja walalany. ");
INSERT INTO djr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bala yan ŋayi gan Djesuynydja marŋgikuŋalnha yolŋunhany walalany bitjarrnha bili walu-ŋupara ŋunhiliyiny buku-ŋal'yunamirriŋurnydja buṉbuŋur. Ga walalnydja gan ŋunhi ŋurruŋu djirrikaymirrnydja mala ga rom-marŋgikunhamirrnydja mala ga wiripuwurrnydja ŋunhi yolŋu walal, djälthinany nhanŋu Djesuwnydja bunharawnha. ");
INSERT INTO djr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yurr bäyŋu walal ŋula dhukarrnydja maḻŋ'maranha ŋayathanharawnydja nhanŋu, bili walal gan ŋunhi yolŋu'-yulŋuy bitjarr bili ṉapuŋga'yaŋal ŋanya, mirithin walal gan buthuru-bitjurr nhanŋu dhärukku, märr walal yaka waŋgany ŋula dhäruk meṉgunha. ");
INSERT INTO djr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Waŋganymirrnydja waluy ŋayiny gan ŋunhi Djesuny nhinanan ŋunhiliyin buku-ŋal'yunamirriŋura buṉbuŋurnydja, marŋgikuŋalnha ŋayi gan yolŋunhan walalany, ŋunhi God-Waŋarrwun ŋamakurrnha dhäwu. Ga walalnydja ŋunhi ŋurruŋu djirrikaymirrnydja yolŋu walal ga rom-marŋgikunhamirrnydja mala, ga ŋurru-warryunayŋuny ŋaḻapaḻmirr mala marrtjinan, ");
INSERT INTO djr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","bala walal gan dhä-birrka'yurra ŋanya Djesunhany bitjarrnha, “Gatjuy mak lakaraŋun napurruŋgal, yolthu nhuna dhuwal waŋanany balanyarawyiny djämaw? Ga yolthu nhuna dhuwal waṉa-nhirrparnydja?” ");
INSERT INTO djr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Bala ŋayiny Djesuny buku-bakmaraŋala balany walalaŋguny bitjarr, “Ŋurruŋuny ŋathil ŋarra dhu nhumalany dhä-birrka'yun. Nhuma ŋathil dhu lakaramany ŋarraku. ");
INSERT INTO djr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yolthu ŋunhi waṉa-nhirrpar Djonnhany yolŋuny? Ga yolthu ŋanya ŋunhi waŋan ḻiya-ḻupmaranharawnydja yolŋuwnydja walalaŋ? God-Waŋarryu? Ŋany yolthu, yolŋuy walal muka?” ");
INSERT INTO djr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bala walalnydja ŋunhi ŋurruḏawalaŋuny mala waŋanhaminan bitjanminan, “Way, nhaltjanna dhika limurrnydja dhu lakaram balany nhanŋuny buku-bakmaramany? Ŋuli limurr dhu ŋunhi bitjandja lakaram, ‘God-Waŋarryu muka ŋunhi ŋanyanhany waṉa-nhirrpar Djonnhany,’ bitjandja, bala ŋayiny dhu ŋunhi waŋa limurruny bitjanna, ‘Nhakun nhuma ŋunhi yakany märr-yuwalkthinya nhanŋuny Djonguny dhärukku?’ Bitjanna ŋayi dhu. ");
INSERT INTO djr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ga ŋuli limurr dhu lakaram nhanukal bitjan, ‘Yolŋu'-yulŋuwuŋ yan ŋayi ŋunhi waṉa-nhirrpanawuynydja ŋurikiyiny djämaw,’ bitjandja, ga walalnydja dhu ŋunhi wiripuwurrnydja yolŋu walal maḏakarritjthirrnydja limurruŋgun, bala walal dhu ga buman limurruny guṉḏaynha rakunyguman yan. Bili walalnydja ga ŋunha märr-yuwalkthirr nhanŋu ŋayiny ŋunha Djondja yolŋu God-Waŋarrwun djawarrkmirr.” ");
INSERT INTO djr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bala walal waŋanan Djesuwnydja bitjarrnha, “Yaka dhuwal napurrnydja marŋgi yolthu ŋanya ŋunhi Djonnhany nhirrpar ŋurikiyiny djämaw.” ");
INSERT INTO djr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ga ŋayiny Djesuny buku-bakmaraŋal walalaŋguny bitjarrnha, “Nhumany ŋunhi yaka warray lakaranha ŋarrakuny ŋunhiyiny, yolthu ŋanya ŋunhi Djonnhany nhirrpar, ga ŋarrany dhu yakayi yänayiny nhumalaŋguny lakaram, yolthu dhuwal ŋarranhany djämaw nhirrpar.” Ga bitjarrnha ŋayi gan Djesu waŋanany walalaŋguny balany. ");
INSERT INTO djr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ga dhäŋur beŋuryiny ŋayi nhakun Djesuy bulu lakaraŋal dhäwu mayali'kurr ŋurikiwurruŋgalyiny yolŋuwal walalaŋgal, ga dhuwal ŋayi ŋunhi dhäwuny' lakaraŋal gam', “Ŋunhiliyi yolŋu gan nhina wäŋa-waṯaŋu, ga ŋayiny ŋunhiyiny yolŋu djälthin wäŋa-waṯaŋuny ŋayi dhu ga ŋuthanmaram ŋamakurr mala borum. Bala ŋayi lämu-nhirrpara ŋunhiwiliyiny wäŋalil borumnha mala dharpan. Ga dhäŋur beŋuryiny ŋayi djarr'yurra yolŋunhany walalany ŋurukiyin djägawnha, djägamirriyaŋala walalany, märr ŋayi dhu ŋunhiyiny wäŋa-waṯaŋuny marrtjin wiripuŋulila wäŋalil, yurr märr wiyinnha ŋayi dhu ŋunhi marrtjiny. Bala ŋayi waŋanany djägamirriwalnydja walalaŋgal bitjarrnha, ‘Dhiyakuny nhuma dhu ga djäga ŋamatham yan ŋarrakalaŋaw, ga ŋunhi ŋayi dhu balwurthirrnydja borumdja, ga nhumany dhu ŋunhi mala-wulkmaraman ŋarrakuny gänaŋulila,’ bitjarr. Bala ŋayi marrtjinan ŋunhiyiny wäŋa-waṯaŋuny yolŋu wiripuŋulila wäŋalil.” ");
INSERT INTO djr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Yo. Nhinanany ŋayi gan ŋunhiyi wäŋa-waṯaŋuny yolŋu, yan bili ga walu marrtjin galkithin borumgun ŋuriki borumdhinyarawnha, bala ŋayi wäthurra waŋganygun yolŋuw djämamirriwnha, bala ŋayi waŋanany nhanŋu bitjarrnha, ‘Gatjuy nheny dhu marrtjin balan ŋarrakalnha wäŋalil, ga beŋuryi nhe dhu märram ŋunhiyi borum ŋarraku, ga gämany nhe dhu rälin ŋarraku.’ Bala ŋayi yan dhunupan marrtjinan ŋunhiyiny djämamirrnydja yolŋu.” “Ga walalnydja ŋuriŋiwurruynydja borum-djägamirriynydja walal nhäŋalnha ŋanya ŋunhiyiny yolŋuny, bala ŋayathaŋalnha ŋanya, bumarnha ŋanya marrtjin, bala djuy'yurrnydja walal ŋanya dhäparŋ'nha goŋ-waŋaran roŋanmaraŋalnydja.” ");
INSERT INTO djr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Ga bitjarryi bili ŋayi wiripuŋunhany muka djämamirriny yolŋuny djuy'yurr. Bala walalnydja ŋanya ŋuruŋiwurruyyi bili yan bitjarryi bili bumaryi yätjkurruyaŋal. Bala walal ŋunhi djuy'yurrnydja ŋanya balanyayi bili yan goŋ-waŋarayi yan. ");
INSERT INTO djr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ga bulu nhakun ŋayi djuy'yurr wiripuŋunhany muka djämamirriny, ga walalnydja ŋanya bitjarryi bili bumaryi, galki balaŋ ŋayi dhiŋganhan, ga ŋurrkaŋalnydja walal ŋanya ŋunhi balan dhawaṯmaraŋalnha warraŋullila.” ");
INSERT INTO djr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Bala ŋuriŋiyi wäŋa-waṯaŋuynydja yolŋuy guyaŋanany bitjarrnha, ‘Nhaltjan dhika ŋarra dhu yulŋuny? Manymak, ŋarrany dhu dhuwal djuy'yun dhuwanna ŋarrakuwuynha ŋarra marrkapmirrinhan gäthunhan, märr walal dhu ga nhanŋun märr-ŋal'yundja.’ Bala yan ŋayi djuy'yurra ŋunhiyin nhanŋuwuynha ŋayi gäthu'mirriŋuny. ");
INSERT INTO djr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ga ŋunhi walal nhäŋalnydja ŋanya ŋuriŋiwurruyyiny borum-djägamirriynydja yolŋuy walal, bala walal waŋanhaminany bitjanminan, ‘Way, dhuwandja ŋunhi yolŋu ŋunhiyin muka? … nhanŋun ga gäthu'mirriŋu marrtji räli, ŋunhiyin ŋunhi ŋayi dhu yalalaŋumirriynydja märram dhuwandja wäŋa ga ŋula nhä malany, dhäŋur beŋurnydja ŋunhi nhanŋu dhu bäpa'mirriŋuny dhiŋgaman. Go, limurrnydja ŋanya dhu buman murrkay'kuman, märr dhu dhuwandja wäŋa limurruŋguwuy yan.’ ");
INSERT INTO djr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bala walal yan ŋunhiyiny gäthu'mirriŋunhany nhanŋu yolŋunhany ŋayathaŋalnha, bala walal ŋanya ŋunhi ŋurrkaŋalnydja balan yänan dhawaṯmaraŋalnha warraŋullila, ga bumarnydja walal ŋanya ŋunhi dhiŋganhamaraŋalnha yan.” Bitjarr ŋayi gan Djesuy dhäwuny' lakaraŋal mayali'kurrnydja. Bala ŋayi dhäŋur beŋuryiny Djesuy dhä-birrka'yurra walalany bitjarra, “Nhaltjanna dhika ŋayi dhu ŋuriŋiyi wäŋa-waṯaŋuynydja ŋunhiwurrunhany yolŋuny walalany borum-djägamirrinhany mala? ");
INSERT INTO djr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bitjanna ŋayi dhu ŋunhi gam'. Marrtjiny ŋayi dhu ŋunhi, ga dhunupan ŋayi dhu buman ŋunhiwurrunhany yolŋuny walalany djägamiriwnhany mala, bala ŋayi dhu ŋunhiyiny wäŋa gurrupan wiripuwurruŋgalnha yolŋuwal walalaŋgal djägalil.” Ga ŋunhi walal yolŋu'-yulŋuy ŋäkulnydja, bala walal waŋanan bitjarrnha, “Way, yaka dhu dhuwal bitjandhi dhuwandja wäŋa.” ");
INSERT INTO djr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bala ŋayi Djesuynydja nhäŋalnha walalany, ga waŋanany ŋayi bitjarra, “Nhä ŋunha mayaliny' ŋunhi ga ŋuruŋ djorrayny'tja lakaram bitjandja gam', ‘Bala'-dhuḻ'yunamirriy walal yolŋu'-yulŋuy guṉḏa marrtjin ŋal'maraŋal, walal dhu dhuḻ'yun bala'. Ga ŋunhiyi waŋganydja guṉḏa walal nhäŋal, bala nyamir'yurra, bala walal yan ŋurrkaŋalnha. Yurr God-Waŋarryuny walalaŋguŋ ŋunhiyi guṉḏa ŋurrkanhawuynydja märraŋala, bala nhirrpara balaw'nha ŋunhiyiny yuṯuŋgurrnydja; bukmaktja wiripuny malany guṉḏa dhu ga dhärra ŋunhiliyin waŋganyŋura guṉḏaŋur.’” ");
INSERT INTO djr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ga ŋarrany dhuwal balanyayi nhakun ŋunhiyi guṉḏa. Ŋuli ŋayi dhu ŋula yol yolŋu ḏaŋgalkthundja beŋuryiny guṉḏaŋur, ŋanyanhany dhu buḻ'waŋmaraman muṉguykuman ŋuriŋiyiny guṉḏay, ga ŋuli dhu ŋunhiyi guṉḏa yupthundja ŋula yolkalnydja yolŋuwal, ga ŋanyanhany muka dhu dhurrparam ŋuriŋiyiny guṉḏay.” Ga bitjarr ŋayi gan ŋunhi Djesuy lakaraŋalnydja mayali'wurrnydja, yurr ŋurikiwurruŋ ŋunhi yolŋuw walalaŋ dhäwuny' märr-yuwalkthinyamiriwwu mala, nhaltjanna walalany ŋayi dhu ŋunhi walŋany dhä-gir'yun yalalaŋumirriynydja waluy ŋuriŋiny ŋunhi mala-djarr'yunamirriynydja. ");
INSERT INTO djr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ga ŋuriŋiwurruyyiny ŋunhi ŋurruŋu djirrikaymirriynydja yolŋuy walal ga ŋunhi rom marŋgikunhamirriynydja mala dharaŋarnha ŋunhiyi mayaliny', ŋunhi ŋayi gan Djesuy lakaraŋal walalany, bala yan walal dhunupan guyaŋanan ŋayathanharawnha nhanŋu Djesuwnydja. Yurr yaka walal ŋanya yänayiny ŋula ŋayathanha, bili walal gan barrarin ŋurikiwurruŋ yolŋuw walalaŋ; ");
INSERT INTO djr_vpl VALUES ("LK20_20a","072_20_20a","LUK","20","20a","20a","yänan walal gan galkurra wiyinnha dhukarr-nhäŋalnydja, wanhawitjan walal dhu ŋanya dhu Djesuny ŋayatham. ");
INSERT INTO djr_vpl VALUES ("LK20_20b","072_20_20b","LUK","20","20b","20b","Bala ŋunhi ŋurruḏawalaŋuny yolŋu walal ŋayan'mirra gan nhinanany nhanŋuny Djesuwnydja, bala walal ŋunhi wiripuwurrunhany ḏirramuwurruny rrupiyaynha wuŋuḻi'yurr, märr walal ŋanya dhu mayali'-gäma bala dhä-birrka'yunna, ga goŋ-gurrupandja ŋanya walal dhu ŋunhi ŋurikalnha Rawumbuywalnha buŋgawawalnydja dhä-gir'yunarawnydja. ");
INSERT INTO djr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bala walalnydja ŋunhi ŋurruḏawalaŋuwnydja mil'ŋuny mala marrtjinan malthurra Djesuwnha. Ga waŋanany walal ŋunhi nhanŋu Djesuwnydja bitjarrnha, “Way Garray, napurrnydja dhuwal marŋgi nhuŋu, ŋunhi nheny ŋuli ga dhunupan yan waŋa dhäruk. Yaka nhe ŋuli gi djambi nhunapinya nhe dhäruk, ga wiripu wiripu lakaram yolŋuw walalaŋ. Yuwalk muka nhe ŋuli ga ŋunhi dhunupany lakaram God-Waŋarrwuny rom, marŋgikumany ŋuli ga yolŋu'-yulŋunhany. ");
INSERT INTO djr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Go mak napurruŋgalnydja lakaraŋun. Nhä dhuwal dhunupa limurruŋ ŋunhi limurr dhu rrupiyany gurrupan ŋurikiyiny ŋurruŋuwnydja buŋgawaw yäkuw Djetjawnydja? Nhaltjan limurr dhu yulŋuny?” ");
INSERT INTO djr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yurr ŋayipiny Djesuny marŋgithin walalaŋ ŋäthil yan, ŋunhi nhaltjarr walal gan ŋanya mayali'-gäŋal dhä-birrka'yurr, bala ŋayiny Djesuny waŋanan bitjarra, ");
INSERT INTO djr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Go gurrupulnha walal ŋarrakalnha dhuwali rrupiyany ŋarakany, ŋarra mak nhäma.” Bala walal gäŋalnha, bala gurruparnha walal nhanukal goŋlila. Bala ŋayiny Djesuynydja dhä-birrka'yurra walalany bitjarrnha, “Yol dhuwal wuŋuḻiny' ga yäkuny dhiyalnydja gay'yi rrupiyaŋur ŋarakaŋur?” bitjarr. Ga walalnydja buku-bakmaraŋal nhanŋuny bitjarr, “Dhuwaliny yäku ga mali' ŋayin ŋunhiyin ŋurruŋun buŋgawa Djetjan,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ga ŋayiny Djesuny walalaŋ bitjarra waŋan, “Yo nhumany dhu gurrupanna roŋanmaraman ŋurikiyiny ŋunhi ŋurruŋuwnydja buŋgawaw ŋunhi nhä malany nhanŋuny, ga biyakiyi bili roŋanmaraŋdhi gurrupul nhanŋuny God-Waŋarrwuny ŋunhi ŋula nhä malany.” ");
INSERT INTO djr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bala walal ŋuriŋiwurruyyiny mayali'-gänhamirriynydja yolŋuy walal ŋäkulnydja ŋanya Djesunhany dhäruktja ṉirr'yurra, bala walal ŋanya ŋunhi yakan ŋunhiŋuwuyyi dhärukpuynydja ŋayathanha yolŋuwalnydja walalaŋgal gumurrŋur. Bala walal gan mukthurra nhinanany, yakan walal ganha buluny ŋanya dhä-birrka'yuna. ");
INSERT INTO djr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ga dhäŋur beŋuryiny wiripuwurrnha ŋurruḏawalaŋu yolŋu walal dhä-birrka'yunaraw marrtjin nhanŋu Djesuw, yurr yolŋuny walal ŋunhi Djatutjin.* Ga dhiyaŋuwurruyyiny yolŋuy walal ŋuli ganha ŋunhi guyaŋanha bitjana, yanbi dhu yolŋu walal bäyŋu walŋathi dhäŋur beŋurnydja ŋunhi dhu rumbal walalaŋ dhiŋguŋ. Bala walal dhuwalawurryiny marrtjinan bala Djesuwala ga waŋan ŋanya bitjarra, ");
INSERT INTO djr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Way Garray, ŋunhi Mawtjitjthuny rom rulwaŋdhurr bitjarr warray, ‘Ŋunhi dhu ḏirramuny dhiŋgam yothumiriwnydja, nhakun bäyŋun nhanŋu ŋula walkurnydja, bala nhanukala dhu yukuyuku'mirriŋuynha märram nhanŋu ŋunhi miyalknhany, märr ŋayin dhu ŋuriŋiyi miyalkthu yothuny gäma ŋuriki bili yan dhiŋganhawuywuny ḏirramuw.’ ");
INSERT INTO djr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ga nhämirr ŋunhi dhuwandja gam'? Waŋganymirrnydja ḏirramuwurrnha gan nhinan wäwa'manydjiwurra goŋ-waŋgany ga märrma' bäythinyawuy, ga ŋayi ŋuriŋiyi maḻamarryuny wäwa'mirriŋuynydja märraŋala miyalknhan. Ga nhinanan maṉḏa gan, bala dhiŋgaŋala ŋayi ŋunhi wäwa'mirriŋuny ŋurruḏawalaŋuny yothumiriw yan. ");
INSERT INTO djr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bala beŋuryiny malpuraynha yukuyuku'mirriŋuynha nhanukal märraŋal ŋunhiyi miyalknhany, ga nhinan maṉḏa gan märr-gurriri, bala ŋayiny muka bitjarryi bili dhiŋgaŋalyi yothumiriw yan malpurany. ");
INSERT INTO djr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ga bitjarryi bili märr-gandarrpuyyuny märraŋal ŋunhiyi bili miyalknha, ga yothumiriwyi yan ŋayi dhiŋgaŋal bitjarryi bili. Ga bitjarr bili yan walal gan bukmakthu ŋuriŋiwurruyyi ḏirramuwurruy märraŋalnydja ŋunhiyi miyalknhany, ga dhiŋga'-dhiŋgaŋal walal djamarrkuḻi'miriw yan, bukmakthin walal yan. ");
INSERT INTO djr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ga yalalaŋumirriynha dhuḏi-yapalan ŋayiny dhiŋgaŋal miyalktja. ");
INSERT INTO djr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ma' lakaraŋun napurruŋgal. Ŋunhi dhu yolŋu walal walŋathirr dhiŋganhaŋurnydja, bala yolkun ŋayi dhu ŋunhiyi miyalktja? … bili ŋayi gan ŋunhi nhinanany beŋur bili wäwa'mirriŋuwalaŋaŋur ga yan bili ga yukuyuku'mirriŋuwal walalaŋgal wapthun.” Ga bitjarrnha walal gan ŋunhi dhä-birrka'yurr ŋanya Djesunhany, yan walal gan nhakun ŋanya mayali'-gäŋal. ");
INSERT INTO djr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Bala ŋayiny Djesuny buku-bakmaraŋala walalaŋguny bitjarrnha, “Dhiyal ŋuli ga munatha'ŋur ŋunhiyiny miyalkkurruwurr ga ḏirramuwurr bitjandhiny märranhamirr. ");
INSERT INTO djr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Yurr ŋunha djiwarr'ŋurnydja wiripu warray rom. Yaka warray gi dhärri dhawu'-nhirrpanminyaraw ga gurrupanminyaraw miyalkku ga ḏirramuw ga djamarrkuḻiw' mala-bunharaw. Ga yalalaŋumirriynydja ŋunhi, God-Waŋarryuny dhu boŋguŋ marrtji ŋunhi walŋakuŋun dhiŋganhaŋurnydja ŋunhiwurrunhany yolŋuny walalany ŋunhi yol walal nhanukal gan maŋutjiŋur dhuwurr-dhunupayin. Ga ŋunhaliyin walal dhu gi ŋunhi nhininy nhanukala God-Waŋarrwalnha wäŋaŋurnydja biyakun bili wiyinŋumirra, bitjanna nhakun ŋunha djiwarr'puynha yolŋu walal dhäwu-gänhamirra mala nhanŋu.” ");
INSERT INTO djr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Yo. Nhumany ŋuli ga ŋunhi lakaram dhiŋganhawuynhany yolŋuny walalany, yanbi walalnydja ŋuli ŋunhi gupaḏalnha dhiŋgam. Yuwalk ŋayi dhu ga ŋunhi yolŋuny nhina walŋany, dhäŋur beŋurnydja ŋunhi nhanŋu dhu rumbalnydja dhiŋguŋ. Mawtjitjthuny gan ŋunhi lakaraŋal dhunupa dhäwu, balanyamirriynydja ŋunhi ŋayi gurthan ŋäṉarrnha nhäŋal ŋunhiwiliyi dharpalil marralil; ŋayiny yäku-lakaraŋala God-Waŋarrnhany bitjarra gam', ‘Nheny dhuwal God-Waŋarr Yipurayimgu* ga Yitjakku* ga Djaykupku.’ ");
INSERT INTO djr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bitjarra ŋayi gan Mawtjitjthu God-Waŋarrnhany waŋan, yurr ŋunhiyi yolŋu walal ŋäthil muka yan dhiŋga'-dhiŋgaŋal. Yurr ŋuriŋiwurruyyi ga lakaram limurruŋgun, bili ŋunhiwurryiny baman'ŋuwuynydja yolŋu walal walŋamirra, bäyŋun rakuny, bili God-Waŋarrnydja ŋunhi Waŋarr walŋamirriw yolŋuw walalaŋ, yaka dhiŋganhawuywu. Nhumany ŋuli ga ŋunhi guyaŋa yanbi ŋunhi baman'puynydja yolŋu walal rakunynha, yurr walal ga bukmak nhinanany birrimbirrnydja walŋa yan.” ");
INSERT INTO djr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Bala wiripuwurruynydja rom-marŋgikunhamirriynydja walal waŋan ŋanya bitjarr, “Way Marŋgikunhamirr, manymaknha dhuwandja buku-roŋanmaranhawuy nhokuŋ muka,” bitjarr walal waŋanany ŋanya ŋunhi, bili walal ŋunhi barrarin manapar nhanŋu, ga yakan ŋula waŋganydhuny buluny ŋanya dhä-birrka'yuna. ");
INSERT INTO djr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yo, ŋunhiliyi buṉbuŋur buku-ŋal'yunamirriŋur ŋayi gan Djesuy lakaraŋala marŋgikuŋala yolŋunhan walalany, bala ŋayi dhä-birrka'yurrnydja walalany bitjarra, “Nhaku walal ŋuli ga ŋunhi lakaram ŋunhi ŋayiny Maŋutji-dhunupayanhawuynydja be gäthu'mirriŋu Geŋ-Daybitku? bitjandja. ");
INSERT INTO djr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bili ŋayipiny ŋunhi Daybitthuny yäku-lakaraŋal ŋanya bitjarr warray gam', ‘God-Waŋarrnydja waŋan ŋarrakalaŋuwalnydja Garraywal bitjarr, Nhininy gi dhiyalnha ŋarrakiyingalnha yan gali'ŋurnydja, ");
INSERT INTO djr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bäy ŋarra nhuŋu dhu ŋunhi miriŋuny bakmaram warrpam'thun yan, bala nhen dhu ŋunhi ŋurruŋuyirrnydja walalaŋ.’” ");
INSERT INTO djr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Yo. Bitjarryin ŋayiny ŋanya gan ŋunhi Daybitthuny lakaraŋal ŋunhiyiny ŋunhi Maŋutji-dhunupayanhawuynhany yolŋuny. Ga ŋuli ŋayi ŋunhi Maŋutji-dhunupayanhawuy gäthu'mirriŋuny nhanŋu Daybitkuny, ga nhakun ŋayi ŋunhi Daybitthu ŋanya lakaraŋal bitjarrnydja, ‘Garray ŋarraku,’ bitjarrnydja?” Ga bitjarra ŋayi ŋunhi Djesuy dhä-birrka'yurrnydja walalany. ");
INSERT INTO djr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ga bukmaknha gan ŋunhi yolŋuny walal balanyamirriyyiny buthuru-bitjurrnydja nhanŋun Djesuwnha dhärukku. Bala ŋayi Djesuny waŋanan nhanukiyingalaŋuwalnydja ŋayi malthunamirriwal walalaŋgal bitjarrnha, ");
INSERT INTO djr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Go walal, djäga nhumalaŋguwuy nhuma gi dhiyakuwurruŋgalnydja ŋunhi rom-marŋgikunhamirriwalnydja walalaŋgal. Walalnydja ga ŋunha djälthirrnydja nhumalaŋ, nhuma dhu ga nhäma walalany, bala ŋurruḏawalaŋun lakaram, bala nhuma dhu ga wokthunna walalaŋ, ŋunhi nhuma dhu walalaŋ bunany ŋula wanhaminy wäŋaŋur. Ga ŋunhi walal ŋuli marrtji balany ŋunhi Djuw malawalnydja buku-ḻuŋ'maranhamirrililnydja wäŋalil, ga nhinany walal ŋuli nhinanhamirriŋurnydja dharrpalŋur yan manymakŋur. Ga ŋunhi walal ŋuli marrtji ḻuŋ'maranhamirr ŋathawnydja ḻukanharaw, bala walal ŋuli marrtji ŋorra'-ŋurrany manymaklila yänan miṉdhalalila. ");
INSERT INTO djr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Yo. Ŋunhiyi rom-marŋgikunhamirr yolŋu walal ŋuli gi yaka goŋ-ŋayathanhamirr dhuwaymiriwwuny yolŋuw walalaŋ, bala ŋuli marrtji bawa'-gurrupanna walalany, bala djaw'-djawyunna ŋula nhän mala walalaŋ. Bala beŋuryiny walal ŋuli ŋunhi bukumirriyamany ga wiyinnha, yänan nhakun maŋutjiwnha yolŋuwnha walalaŋ, yanbi walal dhuwurr-dhunupan mala. Yurr ŋurukuwurruŋdhiny yolŋuw walalaŋ dhu God-Waŋarryuny gurrupul yindin mirithirra dhä-gir'yunawuynydja, gumurr-ḏälnha.” Ga bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ga dhäŋur beŋuryiny Djesuny gan nhinan ŋunhiliyi God-Waŋarrwalnha buṉbuŋur, nhäŋalnha ŋayi gan yolŋu'-yulŋunhan ŋunhi walal marrtjin rulwaŋdhurra rrupiyan ŋunhiwiliyin bathilil rrupiyawuylila, mundhurrnha God-Waŋarrwun. Dharrwaynydja ŋunhi yolŋuy walal ḻukunydjayny'tja mala rulwaŋdhurra marrtjin ŋunhiwiliyin bathilil dharrwan mirithirra rrupiyany. ");
INSERT INTO djr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ga buluny waŋganynha miyalk marrtjin ŋunhi buku-gurthapuynha ŋurruwuyknha, bala ŋayi yan galkarnydja ŋarakany märrman' rrupiyany, yurr nyumukuṉiny'nha maṉḏany ŋunhiyi rrupiyany, yaka ŋula nhä yindi. ");
INSERT INTO djr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bala ŋayi Djesuny waŋanan bitjarra, “Nhäŋu ŋathil walal ŋunha miyalknha ŋurruwuyknha. Märr-yuwalk ŋarra nhumalaŋ dhu dhuwal lakaramany. Ŋuriŋiyiny miyalkthu rulwaŋdhurr ŋunhiwiliyi bathilil mirithirra yindin God-Waŋarrwalnydja maŋutjiŋur, djuḻkmaraŋala ŋayi rrupiya-dharrwamirriwuŋuny yolŋuwuŋ walalaŋguŋ wetjpuy. ");
INSERT INTO djr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bili ŋuriŋiwurruyyiny gan wiripuwurruynydja rulwaŋdhurr balayi bäythinyawuy yan rrupiya mala, ga wiripuny walal ŋuli ga dhuḏi'maraman walalaŋguwuynha walal ŋunhi mirithirrnydja yindiny rrupiya. Yurr ŋuruŋuny miyalkthu rulwaŋdhurr bukmak yan nhämunha' ŋayi gan ŋunhi ŋayathaŋal, yakan ŋayi dhuḏi'maranha nhanŋuwuynydja ŋayi rrupiya, bukmak yan ŋayi gurruparnydja God-Waŋarrwun.” Ga bitjarr ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ga wiripuwurrnydja gan ŋunhi Djesuw malthunamirr mala lakaranhamin ŋunhiŋuwuynha buku-ŋal'yunamirriwuynha buṉbupuy bitjanmin, “Nhän dhuwandja buṉbu, mirithirra latju' muka? Ŋunha nhäŋu ŋathil guṉḏa malany mirithirra latjun dhika, ga mirithirr latju'mirryi ŋunhi mundhurr yolŋuwuŋuny walalaŋguŋ gurrupanawuy God-Waŋarrwu.” ");
INSERT INTO djr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ga ŋayiny Djesuynydja lakaraŋal bitjarra, “Ŋunhayiny nhuma ga nhäma buṉbu, ŋayi ga dhärra manymaknha yan dhiyaŋuny bala, yurr galki dhu ŋunhayi buṉbuny ḏaw'yunna, buḻ'waŋdhunna dhu, yakan dhu ga bulu waŋgany ŋula nhä guṉḏa dhärra ŋapa-ŋal'maranhamirr; bukmaknha dhu marrtji ŋunhi ŋorrany barrkuwatjnha, warrpam'nha dhu muṉguythirra.” Bitjarra ŋayi gan ŋunhi Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ga walalnydja ŋanya dhä-birrka'yurr bitjarr, “Garray, nhätha dhu dhika bitjandhiny? Nhä ŋunhi dhu ŋurruŋuny maḻŋ'thun? Mak ŋanapurruŋ gi lakaraŋ, märr ŋanapurr dhu nhäma ŋunhiyi dharaŋan ga marŋgithirr galkithinyawuy walu ŋurikiyiny maḻŋ'thunaraw.” ");
INSERT INTO djr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ga ŋayiny Djesuny buku-bakmaraŋal balany bitjarr, “Bira'yurr yan gi nhininy, märr nhumalany dhu yaka muka ŋula yolthuny yolŋuy maŋutji-gämany. Bili yolŋuny mala dhu ga ŋunhi marrtjiny ŋarrakalnha yäkuynydja, bala walal dhu marrtji yäku-lakaranhamirrnydja bitjanmirra, ‘Ŋarrany dhuwal ŋunhiyi Maŋutji-dhunupayanhawuy, God-Waŋarrwuŋ,’ bitjanna walal dhu marrtji ŋunhi lakaranhamirrnydja. Ga wiripuwurruynydja malay walal dhu ga ŋunhi lakaram bitjanna, ‘Dhuwanna ŋunhiyiny walu dhä-dhawar'yunamirrnydja bilin bunanan.’ Yurr yaka nhumany dhu märr-yuwalkthirr walalaŋ dhärukkuny, ga yaka yan walalaŋ malthurrnydja. ");
INSERT INTO djr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ga ŋuli nhuma dhu nhäma mari yindiny, ga ŋula nhä bunhaminyawuynydja, yaka walal ŋula ŋuriŋiyiny ŋoy-gärri. Yuwalk yan ŋayi dhu ŋunhiyiny nhä malany maḻŋ'thun ŋurruŋuny, yurr yaka yan ŋunhiyiny dhä-dhawar'yunamirrnydja walu.” ");
INSERT INTO djr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ga bitjarryi bili ŋayi Djesuy lakaraŋalyi bitjarr gam', “Yo, bawalamirriŋura wäŋaŋur ŋarakaŋur dhu marrtji ŋunhi bäpurruny mala bunhamirra, ga nhä mala ŋunhi rom dhuwalaŋuwuy munatha'wuy bitjandhi bili dhu marrtji bunhamirr. ");
INSERT INTO djr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yo, ga wäŋany dhu boŋguŋ marrtji dhuwandja munathany' barr'parryurra. Ga yolŋuny walal dhu marrtji ŋunhi marryayny'tja murrmurryurra, bili dhu gi ŋunhi wäŋany dhärri räwakthin, waltjaṉmiriwyin ga ŋathamiriwyin, ga rerriny mala dhu ŋunhi barrkuwatjthin bawalamirriŋurnydja wäŋaŋur. Ga barrarinyamirra dhu gi ŋunhi ŋula nhäny mala maḻŋ'thurr ŋunhalnydja ŋunhi garrwarŋurnydja. Ga dhiyaŋiyin mala dhu ga ŋunhi maŋutji-lakaramany ŋunhiyin nhakun waluny galkin dhä-dhawar'yunamirriynydja.” ");
INSERT INTO djr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Yo, ga yurrnha dhu ŋunhi dhuwaliyiny mala maḻŋ'thun, ŋurruŋuny ŋathil dhu nhumalany ŋunhi walal ŋayathul, bala yan walal dhu buŋun nhumalany ŋayaŋu-yätjaŋun. Ga gäŋuny walal dhu nhumalany ŋunhi balan dhä-birrka'yunarawnha ŋunhiwilin ŋunhi Djuw malawalnha buku-ḻuŋ'maranhamirrilila wäŋalilnydja, bala nhumalany walal dhu gi dharruŋgulila galkurr. Ga nhirrpulnydja walal dhu nhumalany ŋunhi gumurrlilnydja ŋurikiwurruŋgalnha yolŋuwalnydja walalaŋgal Rawumbuywalnha buŋgawawalnydja mala, bala walal dhu gi waŋan dhä-birrka'yurra nhumalany, bili nhumany dhuwal ŋarraku muka yolŋu walal. ");
INSERT INTO djr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ga balanyamirriyyiny waluy nhumany dhu gi ŋunhi lakaraŋuny yolŋuwalnydja walalaŋgal ŋarrakalaŋuwuynha. ");
INSERT INTO djr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ga ŋunhi nhumalany walal dhu ga gämany balayiny dhä-birrka'yunarawnydja, nheny yaka yänayiny warwuyurr nhaltjan nhe dhu ga ŋunhi waŋa, ");
INSERT INTO djr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","bili ŋarra warray dhu nhuŋuny dhäruk gurrupan waŋanharaw, nheny dhu ga ŋunhi dhärukthuny waŋa mirithirra djambatjthun, märr walalnydja dhu ŋuriŋiwurruyyiny miriŋuynydja mala bäyŋun maḻŋ'maram ŋula nhäny ŋunhiliny nhokalnydja dhärukŋur walalaŋguwuynydja walal ḏiltji-ḏuwaṯthunarawnydja waŋanharaw.” ");
INSERT INTO djr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Yo. Ga balanyamirriyyin ŋunhi, walalnydja dhu gurruṯumirriynydja mala nhumalaŋgal nhumalanhany ḻikandhu-ŋurrkaman, ŋuriŋiwurruynydja ŋunhi ŋäṉḏi'mirriŋuy nhokal ga bäpa'mirriŋuynydja ga yukuyuku'mirriŋuynydja ga wäwa'mirriŋuy ga ḻundu'mirriŋuy walal nhokal, ga wiripuwurrnydja mala nhuma dhu ŋunhi burakin rakunygun. ");
INSERT INTO djr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bawalamirriŋura dhu ga ŋunhi yolŋuny walal ŋuyulkthirrnydja ga nyamir'yundja nhumalany bili nhumany ŋunhi ŋarraku yolŋu walal. ");
INSERT INTO djr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yurr nhumany dhuwal God-Waŋarrwalnha goŋŋur, bäyŋun nhuŋu dhu ŋula birrimbirrnydja ŋayatham, bili ŋayi warray dhu ga nhuŋuny djäga. ");
INSERT INTO djr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nheny gi dhärrin ḏälnha yan birr-biyakun, ga yakan waṉḏiny ḏiltjiny-gurrupanmirr ŋarraku. Bili ŋunhiyiny yolŋu ŋunhi ŋayi dhu ga bitjandja bili malthun ŋarrakuwuynydja yan, bäydhi ŋunhi ŋuliwitjandja marikurrnydja, ŋunhiyin dhu ga yolŋu nhina walŋany ŋunhalnydja ŋarrakalnydja.” ");
INSERT INTO djr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Yo, ŋunhi nhuma dhu nhäma miriŋunhany malaŋuny, walal dhu ga wäŋgamany ḻiw'maraman dhuwandja wäŋany Djurutjalamnhany, bala nhuma dhu walalaŋ marŋgithirra ŋunhi dhuwaliyiny wäŋa dhu galki baḏuwaḏuyuna, buḻ'waŋmaraman. ");
INSERT INTO djr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ga nhumany ŋunhi yolŋu walal ŋunhi nhuma ga nhina dhiyal Djudiya makarrŋur wäŋaŋur, nhumany dhu ŋunhi dhunupan waṉḏirrnydja balan bitjanna bukumirrilila wäŋalilnydja. Ga nhuma wiripuwurr yolŋu walal ŋunhi nhuma dhu ga nhina dhiyal wäŋaŋur Djurutjalam balanyamirriyyiny, dhunupan nhakun nhumany dhu ŋunhi waṉḏi'-waṉḏirryi ganarrthaman dhuwandja wäŋanhany. Ga nhuma wiripuwurr yolŋu walal ŋunhi nhuma dhu ga nhina warraŋul ga gali'ŋur ga gaykarraŋŋur wäŋaŋur, yakan roŋiyi räliny wäŋalilnydja; waṉḏin balan biyakun barrkulila wäŋalil. ");
INSERT INTO djr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bili balanyamirriyyiny God-Waŋarryuny dhu mirithirra yan dhä-gir'yundja ŋunhi wäŋa-dhuwalaŋuwuynhany yolŋuny walalany; yuwalk yan ŋayi dhu dhä-gir'yundja walalany mirithirrnydja, bitjan yan bili nhakun ŋunha djorray' ga lakaram ŋäthilmirriyam. ");
INSERT INTO djr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yurr ḏälnha dhuwal yulŋuny ŋurikiny yolŋuw miyalkkuny ŋunhi ŋayi dhu ga yothuny gäma guḻundhuny, ga ŋurikiyi ŋäṉḏi'mirriŋuw yothu-yalŋgimirriwnydja. ");
INSERT INTO djr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yurr miriŋuny dhu ŋunhi bunin, bala dhu marrtji buŋun murrkay'kuŋun yolŋunhany walalany, mandjawakthun dhu marrtji barrtjurr. Ga wiripuwurrunhany dhu ŋunhi yolŋu'-yulŋuny yänan marrtji djaw'-djawyurra balan biyakun wiripuŋulila wäŋalil wiripuŋuwalnha bäpurrulil mala barrkulila. Yurr dhuwaliyiny dhu ŋunhi wäŋa Djurutjalamdja goŋŋur ŋurikiwurruŋgalnha Djan'tayilwalnha yolŋuwal walalaŋgal, bala walal dhu ŋunhiyiny mulkuruny yolŋu walal marrtjiny bala dhurrpa'-dhurrparaŋun dhuwaliyiny wäŋa, yan bili-i-i ga bäy walalaŋ dhu walu dhawar'yurr.” ");
INSERT INTO djr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Balanyamirriynydja ŋunhalnydja ŋunhi garrwarnydja dhu gi maḻŋ'thurr ŋula nhän mala ŋoy-gärrinyamirra, bili ŋaḻindiny dhu ŋunhi ga waluny ga ganyuny mala wiripuŋuyin, ga dhiyalnydja munatha'ŋurnydja yolŋuny walal dhu gi ŋunhi ŋapa-ŋayathula, wilwilyurra manapul, bili gapuny dhu gi ŋunhi ŋunhany moṉuktja ŋoynydja waŋan rirrakaymirriyin, mirithin yan dhika, ga ḏowuny dhu gi ŋunhi ŋal'yurra yindithin. ");
INSERT INTO djr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yurr yolŋuny walal dhu marrtji ŋunhi ḻiyany balanyamirriyyiny wirrmuryurra dhika mirithin yan, bala walal dhu marrtji burrumunuŋ'thin ḏälthin barrariynydja walalaŋgiyingal, ga ŋuliwiyakiyin ŋunhi barrariwurrnha dhaḻakarrwurr walal dhu gi ŋunhi galkurrnydja ŋurikiny ŋunhi yindiwnydja mariw, ŋunhi dhu boŋguŋ maḻŋ'thurrnydja bawalamirraŋura. Bili ŋunhi bukmak ganydjarr mala beŋur garrwarŋurnydja dhu marrtji burrul'yurra räli ŋapa-malamirra, ga yakan walal dhu gi ŋunhi marrtji biyakuny nhakun ŋunhi nhäthinya walalaŋ ŋäthiliŋu goyurr malany marrtjinyawuy. ");
INSERT INTO djr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ga balanyamirriyyin ŋunhi, walalnydja dhu nhäman ŋanyanhany Yolŋunhany Gäthu'mirriŋuny ŋayi dhu ga marrtjin rälin maŋandhun, yurr marrtjiny ŋayi dhu ga ŋunhi ganydjarrnydja yindin mirithirra, ga djeŋarrayny'tja ŋanya dhu ŋunhi gungamany djarraṯawun'thuny, manymakthun yan dhika.” ");
INSERT INTO djr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Yo, ga ŋunhi dhu ŋunhiyi nhäny mala nhakun bitjandhiny ŋurruyirr'yundja marrtji maḻŋ'thundja, nhumany dhu yakan barrarirr; yänan gi dhärriny birr-biyakun barrarimiriwnha, ga dhupuŋuny gi djiwarr'lila yan, bili ŋunhiny dhu nhuŋuny Walŋakunhamirr marrtjin rälin, galki ŋayi dhu bunan dhawaṯmaranharawnha nhumalaŋ.” Ga bitjarra ŋayi gan ŋunhi Djesuy marŋgikuŋalnydja walalany ŋäthilmirriyaŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ga buluny ŋayi Djesuy lakaraŋal walalaŋgal mayali'kurra bitjarra gam', “Guyaŋi ŋathil ŋunhi dharpany genydjany' ga wiripu malany dharpa, bala yan marŋgithin. ");
INSERT INTO djr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ŋunhi nhe ŋuli nhäma ŋathil marwat dhamany'tjunawuy, bala nhe ŋuli ŋunhi marŋgithirra, bala nhe ŋuli waŋan bitjanna, ‘Way, galkin dhuwandja borummirra walu, muka?’ bitjanna. ");
INSERT INTO djr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ga balanyawuyyin nhe dhu ŋunhi nhämany ŋayi dhu marrtji bitjandhin maḻŋ'thundja, bala nheny dhu yänan marŋgithirra, ŋunhi galkin ŋayi dhu God-Waŋarrwuny rom bunan.” ");
INSERT INTO djr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Märr-yuwalk ŋarra ga dhuwal lakaramany nhumalaŋ. Nhuma bukmak yolŋu walal ŋunhi nhuma ga dhiyaŋ bala nhina dhiyal, wiripuwurrnydja nhuma dhu ŋunhi yolŋu walal yaka yänayiny dhiŋguŋ, ga yan bili ga bäy ŋayi dhu boŋguŋ ŋunhi ŋula nhän mala warrpam'thurra maḻŋ'thurr, ga dhäŋur beŋuryin ŋunhi, bala ŋayiny boŋguŋ Yolŋuny Gäthu'mirriŋu ŋurruḏawalaŋuyin bukmakkun yan wäŋawnydja malaŋuw. ");
INSERT INTO djr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ŋunha ŋunhi garrwarnydja wäŋa ga dhuwandja munathany' wäŋa buwayakthirra dhu marrtji warrpam'thunna, yurr Dhäruktja ŋarraku dhu yaka warray buwayakthirr ga dhawar'yun; dhärran dhu ga yan bitjanna bili.” ");
INSERT INTO djr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","“Biyakun djägan nhumalaŋguwuy nhuma gi. Yaka yan gi ḻay-ḻayyurr ŋuriŋiny ŋunhi munatha'wuyyuny ŋula nhaliy malaŋuy. Ŋuli nhe dhu ga bitjan bili guyaŋa ŋathany yan ga ŋänitjiny, ga bitjan bili nhe dhu ga warwuyun ŋula nhakuny malaŋuw yan, bala ŋuriŋiyin malaŋuy nhunanhany dhu ga ŋunhi baku-ŋayathamany, ga ŋunhiyiny mak nhe dhu ga yakan girri'-ŋamathirr nhanŋuny Djesuwnydja, balanyamirriyyiny ŋunhi ŋayiny dhu marrtjin rälin. Bili nhanŋuny dhu walu ŋunhi maḻŋ'thun ganydjarryu warray. Ga dhäŋur beŋuryiny ŋunhiyiny dhu nhakun dhuḏitjnha bukmakkun yan yolŋuwnydja walalaŋ bawalamirriwuywun wäŋapuywuny. ");
INSERT INTO djr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yänan mak nheny dhu ga nhinany bira'yunna, galkurra gi yan, ga biyakun bili gi bukumirriyaŋun, märr nheny dhu ga dhärrany ḏälnha yan ŋunhi ŋayi dhu yindiny mari maḻŋ'thun, bala nhe dhu ga ŋunhi dhärrany goramiriwnha yan ŋula nhämiriwnha, gumurrŋurnydja nhanukalnha Yolŋuwalnha Gäthu'mirriŋuwalnydja ŋunhal djiwarr'ŋurnydja.” Bitjarr ŋayi gan Djesuy lakaraŋalnydja. ");
INSERT INTO djr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ga bitjarra bili walu-ŋupara ŋayi gan ŋunhi Djesuy marŋgikuŋalnydja yolŋunhany walalany ŋunhiliyiny buku-ŋal'yunamirriŋurnydja buṉbuŋur, ga munhawuyinany nhanŋu gan ŋunhala bukuŋura wäŋaŋur yäkuŋur Wolipnha. ");
INSERT INTO djr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ga bitjarr bili walu-ŋupar munhawumirr gan ŋunhi yolŋuny walal marrtjin balany ŋunhi buku-ŋal'yunamirrililnydja buṉbulil, dharrwan mirithirra malany, bili walal gan ŋunhi mirithin yan djälthinany ŋänharawnydja nhanŋu Djesuwnydja dhärukku. ");
INSERT INTO djr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Galkin ŋunhi waluny walalaŋ guyaŋanhamirra yäku Ḻäy-djuḻkmaranhamirra, ŋunhi walal ŋuli ganha ḻukanha ŋatha ḏambamiriw. ");
INSERT INTO djr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ga ŋunhiyi mala ŋunhi ŋurruŋu djirrikaymirr yolŋu walal, ga rom-marŋgikunhamirr mala, ḻarruŋal walal gan dhukarrwun nhaltjan walal dhu ŋayathamany ŋany Djesuny, bala yan buman ŋanya murrkay'kuman. Yurr walal gan ŋunhi gayulnha guyaŋanany ŋayathanharawnydja nhanŋu, bili walal gan ŋunhi barrarinany yolŋuwnha walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ga balanyamirriyyin waluy ŋayiny ŋunhi Djaytindja gulŋiyinan nhanukalnydja Djudatj-Gariyatkalnydja, yurr ŋayiny ŋunhi ŋunhiyiny yolŋu beŋuryin malaŋur 12-kala malthunamirriwal nhanukala Djesuwala. ");
INSERT INTO djr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ga dhäŋur beŋuryiny, bala ŋayi ŋunhi Djudatjtja marrtjinan ŋurikiwurruŋgalnha ŋunhi ŋurruŋu djirrikaymirriwalnha yolŋuwal walalaŋgal, ga ŋurikiwurruŋgalnha ŋunhi walal ŋurruŋu mala ŋurikiwurruŋdhin ŋunhi walal buku-ŋal'yunamirriw buṉbu djägamirr mala, bala ŋayi waŋanany walalaŋgal bitjarrnha, “Way walal, ŋarrany dhu dhuwal gurrupanna nhumalaŋgalnha goŋlil Djesunhany,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ga ŋunhi nhakun walal ŋanya ŋäkulnydja dhäruktja balanyawuyyiny waŋanhawuy, bala walal yan mirithinan goŋmirriyinany, ga waŋanany walal ŋunhi bitjarra, “Yo, ŋanapurrnydja nhuna dhu gurrupanna rrupiyan ŋunhiŋuwuyyiny,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","“Yo, manymaknha dhuwaliyiny,” bitjarr ŋayi Djudatjtja. Bala ŋayi gan yan guyaŋanan dhukarrnha nhaltjan ŋayi dhu ŋunhi gurrupan ŋanya Djesuny walalaŋgal goŋlil ŋurukuwurruŋgalyi, yurr gayulnha ŋayi gan ŋunhi guyaŋanany bitjarryiny, märr walal dhu yolŋu walal yaka marŋgithirr nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yo. Ŋunhiyi guyaŋanhamirrnydja walu bilin bunanan ŋurikiyiny ḏambamiriwwuny ŋathaw ḻukanharaw. Ŋäthil baman'tja ŋunhi, walal ŋuli nhakun balanyarayyi waluy wutthunna warrakan'nha bimbiny, bala ḻukanhan walal ŋuli balanyamirriyyi waluy Ḻäy-djuḻkmaranhamirriy. ");
INSERT INTO djr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bala ŋayi Djesuy djuy'yurra Betanhan ga Djonnhan bitjarrnha, “Maṉḏa, nhumany dhu marrtjin ŋäthilmirriyaman ŋathan limurruŋ, märr limurr dhu ḻukan ŋunhiyi ŋathany Ḻäy-djuḻkmaranhamirrnydja rrambaŋin.” ");
INSERT INTO djr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ga maṉḏany dhä-birrka'yurr ŋanya bitjarr, “Wanha dhika linyu dhu ŋäthilmirriyam wäŋany, märr limurr dhu ŋathany ḻuka, wanhal wäŋaŋurnydja?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ga ŋayi Djesuny waŋan bitjarr, “Ŋäku ŋathil maṉḏa ŋamathaŋ. Ŋunhi nhuma dhu marrtji bala Djurutjalamlilnydja, ga nhämany nhuma dhu ŋunhi yolŋunhany ŋayi dhu ga banikin'tja gäma yindi gapumirr ḻambarryu. Bala nhumany dhu ŋunhi yänan malthunna nhanŋu ŋurikiyiny ḏirramuw, ga ŋunhi ŋayi dhu gulŋiyirr ŋula nhäkurrnydja wäŋalil, ga nhumany dhu yan gulŋiyirryi malthundhi nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ga waŋany nhuma dhu ŋunhi ŋurikiny wäŋa-waṯaŋuwnydja yolŋuw bitjanna, ‘Way, bitjarr ŋunha Marŋgikunhamirrnydja waŋan, wanha dhika wäŋany dhaḻakarrnydja ŋanapurruŋ ŋarrakuny ga malthunamirriwnydja mala ŋarrakalaŋaw, napurr dhu ŋathany ḻuka ŋunhi Ḻäy-djuḻkmaranhamirra yäku?’ Ga bitjanna nhuma dhu ŋunhi waŋany. ");
INSERT INTO djr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ga ŋayiny dhu nhumalany ŋunhi ŋuruŋiyiny yolŋuy gäman balan bitjanna garrwarlila yindilila mungurrlilnydja, ga ŋunhiliyin nhumany dhu ŋunhi ŋathany ŋäthilmirriyam djäma limurruŋ.” ");
INSERT INTO djr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bala maṉḏa ŋunhi marrtjinan, ga ŋunhalnydja Djurutjalamdja maṉḏa maḻŋ'maraŋalnydja ŋunhiyi bili yan ŋunhi nhaltjarr ŋayi gan Djesuy lakaraŋal maṉḏaŋgal. Bala maṉḏa gan djäman ŋäthilmirriyaŋalnha ŋunhiyin ŋatha Ḻäy-djuḻkmaranhamirra. ");
INSERT INTO djr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yo. Ga ŋunhi nhakun waluny nhanŋu galkithin, Djesuwnydja bala ŋayi nhinan ŋunhiliyin ŋathamirriŋura bala'palaŋur, walalnha rrambaŋin ŋunhiwurrnha ŋunhi djuy'yunawuynha yolŋu walal. ");
INSERT INTO djr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Bala ŋayi waŋanany bitjarrnha walalaŋgal, “Mirithin yan ŋarra dhuwal djälthinany dhiyakuny, ŋunhi ŋarra dhu ḻukany dhuwal Ḻäy-djuḻkmaranhamirrnydja ŋatha mala-manapandja nhumalaŋgal, yurrnha nhakun ŋarra dhu ŋunhi burakirrnydja. ");
INSERT INTO djr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bili yakan ŋarra dhu ŋunhi buluny ḻuka dhuwaliny ŋatha, ga bäy dhu ŋunhi God-Waŋarrwu rom maḻŋ'thun yuwalkthirr yan.” ");
INSERT INTO djr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bala ŋayi yan wiyikany' märraŋalnha banikin'mirrnydja, ga dhunupan ŋayi ŋunhi buku-gurrparnha God-Waŋarrnhan, ga waŋanany bitjarrnha, “Ŋay', dhuwandja märraŋun bala ḻukin, gurrupanmirra walal marrtji nhumalanhawuynhany nhuma, ");
INSERT INTO djr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","bili yuwalknha ŋarra nhumalaŋ ga dhuwandja lakaram, bäyŋun ŋarra dhu ŋunhi buluny ḻuka dhuwaliyiny wiyika borum, ga bäy dhu ŋunhi God-Waŋarrwu rom maḻŋ'thun yuwalkthirr yan.” ");
INSERT INTO djr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ga dhäŋur beŋuryiny ŋayi Djesuy märraŋal ŋathany muka, bala ŋayi buku-gurrparnha God-Waŋarrnhan, ga bakmaraŋalnydja ŋayi ŋunhi, bala yan gurruparnha marrtjin walalany, ga waŋanany ŋayi bitjarrnha, “Ŋay', dhuwanna ŋarra ŋunhi rumbalnydja ŋunhi ŋarra dhu gurrupanmirra. Ŋarran dhu dhuwal nhumalaŋgalnydja dharapulŋur burakirr. Ma', ḻukin, ga guyaŋiny balayi roŋiyi dhuḏitjthu ŋarrany.” ");
INSERT INTO djr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ga dhäŋur ŋathaŋurnydja ŋayi bitjarryi bili yan gurruparyi banikin' wiyika'mirr walalaŋ, ga waŋan ŋayi bitjarr, “Ŋay', dhuwanna ŋarraku maŋguny'. Dhiyaŋuny ga maŋutji-lakaram, ŋunhi ŋarrany dhu gulaŋ-waṉḏirra, nhumalaŋgun dharapul djaw'yun. Ga dhuwanna ŋunhi God-Waŋarrwuny yuṯany gumurrkunhaminyawuy rom, ŋarrakalaŋuwurra maŋgu'-waṉḏinyawurr.” ");
INSERT INTO djr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Yo. Ga märr-yuwalk ŋarra nhumalaŋ ga dhuwandja lakaram. Dhiyal nhakun malaŋur limurruŋgal, yolŋu ga waŋganydja nhina, ḻuka ŋayi ga ŋatha ga gapu dhiyal limurruŋgal, yurr ŋayi dhu ŋunhi ḏiltji-bilyuna ŋarrakuny, bala ŋayi dhu goŋ-gurrupandja ŋarrany goŋlilnydja miriŋuwalnha walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yuwalk yan dhuwandja, ŋarrany dhu Yolŋuny Gäthu'mirriŋu dhiŋgaman, bili ŋunhi bili yan dhukarrnydja ŋunhi ŋayipi ŋarraku God-Waŋarryu nhirrpar. Yurr yindi nhanŋuny dhu mari dhawaṯthun ŋurikiyiny yolŋuw ŋunhi ŋayi ŋarrany dhu dhayuŋan walalaŋgala goŋlil miriŋuwalnydja.” ");
INSERT INTO djr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bala walalawuynydja nhakun dhä-birrka'yunminan bitjanminan, “Yol dhika yolŋuny? Yolthu dhu gurrupandja ŋanya?” ");
INSERT INTO djr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yo. Ga dhäŋur beŋuryiny nhanŋuny ŋunhi Djesuwnydja malthunamirr mala gan waŋanhaminan dhä-ŋurrkanhaminan walalanhawuynhany walal, yol nhakun dhu ŋurruŋuyirr. ");
INSERT INTO djr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Bala ŋayi Djesuynydja walalaŋ lakaraŋal bitjarrnha gam', “Ŋunhiwurr dhuwal buŋgawany yolŋu mala dhiyalnydja munatha'ŋurnydja, ŋunhi walal ŋuli ga ganydjarr-gurrupan wiripuwurruny yolŋuny walalany dhärukthu ḏälyu walalaŋgiyingal walal, bala walal ŋuli ŋunhi lakaranhamirrnydja bitjanmirra, ‘Ŋarrany dhuwal guŋga'yunamirr warray ga bulu ŋarra rrupiya-gurrupanamirr ŋarrakalaŋawnydja yolŋuw walalaŋ,’ bitjanmirra. ");
INSERT INTO djr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yurr God-Waŋarrwuny ŋunhi rom gänaŋ'thun warray ga dhipuŋurnydja munatha'wuywalnydja romŋur. Ŋuli nhe ŋunhi yolŋu ŋurruŋuny ŋarrakalaŋawnydja romgu, nheny dhu ga ŋunhi bitjanna nhinany nhakun ŋunhi yuṯan yolŋu, nyilŋ'maranhamirra, yakan nhe dhu ga ŋunhi buŋgawakunhamirrnydja; yanan nhe dhu ga ŋunhi mukthunna djämany guŋga'yundja nhuŋuwuy nhe yolŋunhany walalany, ŋunhiyiny nhakun nhe dhu balanyayiny walalaŋgun djämamirr. ");
INSERT INTO djr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yo. Djämamirriynydja yolŋuy ŋuli ga ŋunhi gäma ŋatha ŋuriki wiripuŋuw yolŋuw, ŋunhi ŋayi ŋuli ga nhina galkun ŋathaw ḻukanharaw, bili ŋayipiny ŋunhi yolŋu buŋgawany garrwar warray ŋurikalyiny yolŋuwal djämamirriwalnydja. Ga ŋarrapiny dhuwal nhakun djämamirryi dhiyal nhumalaŋguny, yaka dhuwal ŋarra buŋgawa balanyany gumurr-ḏälnydja dhäruk-gurrupanamirr.” ");
INSERT INTO djr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yo, nhumany dhuwalawurrnydja galki warray gan nhinan ŋarrakal bitjarr bili yan ŋuliwitjarr ŋarrakalaŋuwurr ŋayaŋu-yätjinyawurr romgurr, ga yaka nhakun nhuma ŋarrany gananna. ");
INSERT INTO djr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bala ŋarra ga dhuwal buŋgawayaman nhumalany ŋarrakalaŋawnydja yolŋuw walalaŋ nhuma dhu buŋgawayirra walalaŋguny, bitjan yan nhakun ŋarrakal Bäpay nhirrpar ŋarrany ŋurruŋuyaŋal, märr ŋarran dhu ga nhina ŋurruŋuny bukmakkun yan yolŋuw walalaŋ. ");
INSERT INTO djr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yo, ga rrambaŋin limurr dhu gi ŋunhi nhininy ŋunhalnydja ŋarrakalnydja romŋur. Ga ḻukiny limurr dhu ŋunhi rrambaŋin waŋganyŋura yan ŋathany ga gapuny, ga nhinany nhuma dhu ga ŋunhi ŋunhiliyin nhinanhawuyŋura mala, mala-djarr'yunamirra mala ŋurikiwurruŋgun ŋunhi yolŋuwnha walalaŋ Yitjuralwun bäpurruw 12-kun.” Ga bitjarra ŋayi gan Djesu waŋanany. ");
INSERT INTO djr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Bala ŋayi Djesuny bilyurra ga waŋan Betawnydja bitjarra gam', “Djäyman! Djäyman!” bitjarr. “Djaytindja ga ŋunha djälthirra ŋayi dhu nhunany yan nhakun birrka'yun, ga God-Waŋarrnydja nhanŋu ŋuriki yoraŋal, bala ŋayi nhunany dhu birrka'yunna bitjan nhakun ŋuli marrtji ŋunhi yolŋuy ŋatha-djämamirriy rurr'rurryun dhukun ŋathaŋur malany maŋutjiŋur. ");
INSERT INTO djr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yurr ŋarrany nhuŋu gan dhuwal bukumirriyaŋal, Djäyman, märr nheny dhu marrtji bitjan bili yan märr-nhirrpanmirrnydja ŋarrakiyingal, ga yaka ŋula galkirriny ga ganurrnydja ŋarrany. Ga dhäŋur beŋurnydja ŋunhi nhe dhu roŋiyirrnydja ŋarrakal, nheny dhu ga guŋga'yunna ga marrparaŋgum muka gäma walalany ŋunhi nhuŋuwuynydja nhe yukuyuku'mirriŋunhany walalany.” ");
INSERT INTO djr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ga ŋayiny Betany buku-ḏuwaṯthurr warray waŋan bitjarr, “Garray, yaka ŋarrany nhuna dhu dhuwal ganan. Ŋarrany dhu galki yan bitjan bili nhokal, ŋunhi ŋula wanhaminy nhe dhu dharruŋguŋurnydja nhä mak dhiŋganhamirriŋurnydja romŋur. Bäyŋun dhu dhuwal ŋarrapiny nhunany ganan.” ");
INSERT INTO djr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yurr ŋayi Djesuny waŋan bitjarr, “Beta, yuwalk ŋarra nhuŋu ga dhuwal lakaramany, nhepiny dhu ŋunhi dhumbal'yunna ŋarrakuny buku-ḻurrkun'mirra, yurrnha dhu ŋunhi guḻawurrnydja ŋäthi djaḏaw'maramany.” ");
INSERT INTO djr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ga dhäŋur beŋuryiny ŋayi Djesuy dhä-birrka'yurra walalany bitjarra, “Balanyamirriynydja waluy ŋunhi ŋäthilnydja ŋarra nhumalany djuy'yurr muka lakaranharaw, dhäwuw birrŋ'maranharaw, ga nhumany ŋunhi marrtjinany rrupiyamiriwnha mala ga dhapathuŋ'miriwnha ŋula nhämiriwnha, yakan nhuma ganha gänha bathiny mala girri'mirrnydja. Ga nhän nhuma gan ŋunhi, marryan' nhinanany? Ŋathamiriwnydja ga girri'miriwnydja?” bitjarr. Ga walalnydja waŋan bitjarr, “Bäyŋu! Yaka napurr ganha nhinanha ŋathamiriw ga girri'miriw,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Bala ŋayipiny Djesuynydja lakaraŋal bitjarrnha, “Dhiyaŋun bala nhuma dhu ga marrtjiny ḏälkurra romgurr. Ŋuli nhuma ga ŋayatham rrupiyany, gäŋun ŋunhiyiny, ga biyakiyi bili märraŋdhi bathi girri'mirrnydja nhuŋuwuy nhe. Ga ŋuli nhuŋu bäyŋuny mandjawak, ga nheny dhu djalim bätjupatjun nhuŋuwuy nhe, bala nhe dhu ŋunhi märraman mandjawaktja. ");
INSERT INTO djr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bili ŋunha ŋunhi djorrayny'tja ga lakaram ŋarranhany bitjanna gam', ‘Walal lakaraŋal ŋanyanhany, be ŋayiny dhuwurr-yätjkurr yolŋu, bala walal bumarnydja ŋanya murrkay'kuŋalnha,’ bitjan ga ŋunhi Djorrayny'tja dhuyuynydja lakaram ŋarranhany, ga galki dhu ŋunhiyiny maḻŋ'thunna, dhawaṯthunna dhu ŋarrakalaŋuwuynydja.” ");
INSERT INTO djr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ga ŋunhiwurryiny ŋunhi malthunamirrnydja walal waŋan bitjarr, “Garray, dhuwal ŋunhi märrma' maṉḏany mandjawak ŋanapurr ga ŋayatham.” Ga ŋayiny Djesuny bitjarr warray waŋan, “Ma', bilin. Ḏaḏawyurra,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yo. Ga dhäŋur beŋuryiny Djesuynydja ganarrthaŋala ŋunhiyiny Djurutjalamdja wäŋa, bala ŋayi yan marrtjinan dhunupan balan bukulila wäŋalil yäkulil Woliplila, ŋunhiwiliyin wäŋalil ŋunhi ŋayi gan bitjarr bili marrtjin yan balayi. Ga walalnydja nhanŋu ŋunhi malthunamirrnydja mala malthurryi nhanŋu. ");
INSERT INTO djr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ga ŋunhi nhakun walal ŋayathaŋalnydja ŋunhiyiny wäŋa, bala ŋayi waŋanan walalaŋgal bitjarrnha, “Bira'yun nhuma dhu ga nhinany, ga bukumirriyaman ga, märr nhuma dhu yaka muka galkirriny ŋunhi ŋayi dhu mokuyyuny dharrwunumany nhumalany.” ");
INSERT INTO djr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bala ŋayi Djesuynydja ganarrthaŋala walalany, ga marrtjinany ŋayi ŋunhi märr-gurriri, bala yan bun'kumu-djipthurra, bala bukumirriyaŋala gan. ");
INSERT INTO djr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Waŋanany ŋayi gan ŋunhi bitjarrnha, “Bäpa, ŋarrany djälnha nheny dhu djaw'yunna ŋarrakal märraman dhuwandja ŋunhi galŋa-ŋonuŋdhinyamirrnydja rom. Yurr ŋarrapiny nhuŋuwuy dhu ga yan märrwuny malthun, yaka ŋarrakuwuynydja ŋarra märrwu.” Bitjarr ŋayi gan ŋunhi Djesuynydja bukumirriyaŋal. ");
INSERT INTO djr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bala ŋayi ŋunhi God-Waŋarwuny dhäwu-gänhamirrnydja yolŋu dhunupan maḻŋ'thurra nhanukal, bala yan ŋayi ŋanya marrparaŋguŋalnha, ḏälkuŋalnha manapar ŋanya. ");
INSERT INTO djr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yo, ŋayaŋuny nhanŋu ŋunhi mirithinan yan dhika galŋa-ŋonuŋdhinany, ga buluny ŋayi gan ŋunhi bukumirriyaŋal ŋayaŋuynha. Bala nhanŋu marrtjin ŋunhi worrny'tja rumbalŋurnydja djuḻ'-djuḻyurrnydja munatha'lilnydja bitjarrnha nhakun maŋgun'. ");
INSERT INTO djr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ga dhawar'yurrnydja ŋayi ŋunhi beŋuryiny bukumirriyanhaŋurnydja, bala ŋayi rur'yurra, balayi ŋayi roŋiyindhi malthunamirriwal mala nhanukalaŋuwal, ga maḻŋ'maraŋalnydja ŋayi ŋunhi walalany yakurrlila, bili ŋuriŋin warwuynha walalany ŋunhi djawar-gurruparnydja. ");
INSERT INTO djr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Bala ŋayi waŋanany walalaŋ bitjarrnha, “Walal, nhaku nhuma ga dhuwal wawuny ŋorra? Biyakun bira'yurra walal nhininy, ga bukumirriyaŋ muka gi yulŋuny, märr nhuma dhu yakan galkirrin ŋunhi ŋayi dhu ŋuruŋiyi mokuyyuny dharrwunumany nhumalany.” ");
INSERT INTO djr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yo. Djesuynydja gan ŋunhi baḏak yan waŋan walalany, bala walalnydja ŋunhi balanyamirriy bili yan yolŋuny walal dharrwan bunanany, yurr ŋayi ŋunhi Djudatjthu walalany gan ŋurru-warryurrnydja, ŋuriŋiyi yolŋuy ŋunhi ŋayi galkipuynha malthunamirra nhanŋu Djesuw, beŋura ŋunhi 12-ŋura malaŋur. Marrtjinany ŋayi ŋunhi galkithinan yan nhanukal Djesuwalnydja, bala ŋayi yan wälkuŋalnha ŋanya. ");
INSERT INTO djr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ga ŋayi Djesuny waŋan bitjarr, “Djudatj, dhuwandja nhe ŋarrany milkuŋalnha miriŋuwalnha gurrupar muka? … wälkuŋalnydja ŋarrany?” ");
INSERT INTO djr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ga walalnydja ŋuriŋiwurruy malthunamirriynydja mala nhanukal, ŋunhi walal gan dhärra'-dharran ŋunhiliyi Djesuwal galki, walal nhäŋalnha ŋunhiwiliyiny ŋanya, bala dharaŋarnha yan ŋunhi walalnydja ŋunhiwurryiny yolŋu walal marrtjin ŋayathanharawnha nhanŋun Djesuwnha. Bala walal waŋanan bitjarra, “Garray, nhaltjanna ŋanapurrnydja dhu dhika walalanhany? … buman dhiyaŋun mandjawakthun?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ga waŋganydhuny Djesuwal malthunamirriy warryurr mandjawaknha nhanŋuwuy ŋayi, ga dhunupan yan ŋayi ŋunhi djatthurra, gulk-bitjarryi, ŋuriki ŋurruḏawalaŋuw djirrikaymirriw ḏapmaranhawuynha yolŋuny buthuru yan dhunupa'ŋu gulkthurr. ");
INSERT INTO djr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bala ŋayi Djesuny waŋanan bitjarra, “Yaka biyak ye, ḏaḏawyurra,” bitjarr. Bala yan ŋayi goŋ-djarryurra, ga ŋayathaŋal ŋunhi buthuruny yolŋunhany, bala dhunupan yan ḏukmaraŋala. ");
INSERT INTO djr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bala ŋayi Djesuny bilyurra, ga waŋan walalaŋ ŋunhi ŋurruŋu djirrikaymirriwnha yolŋuw walalaŋ ga ŋurikiwurruŋ ŋunhi walal buku-ŋal'yunamirriw buṉbuw djägamirr mala, ga wiripuwurruŋ ŋaḻapaḻmirriw bitjarrnha gam', “Nhaku nhuma dhuwal marrtjin goŋ-mandjawakmirrnydja mala ga goŋ-birku'mirrnydja ŋarrakuny? Nhä dhika ŋarrany? … rom-bakmaranhamirr yolŋu ");
INSERT INTO djr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ŋarrany gan ŋunhi bitjarr warray bili walu-ŋupar nhinan ŋunhalnydja ŋunhi buku-ŋal'yunamirriŋurnydja buṉbuŋur; ga nhumany balaŋ ŋunhi marrtjinya ga ŋayathanhan ŋarrany. Yurr dhuwandja nhumalaŋgun walu, ŋayan'tharran nhuma ga dhuwali ŋarraku ŋayathanharawnha, dharrwununharaynha ŋurikalnha ŋunhi buŋgawawal dhuwalaŋuwuywalnha buku-munha'wuywal ganydjarryu.” ");
INSERT INTO djr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dhäŋur beŋuryiny walal ŋanya Djesunhany ŋayathaŋalnha, ga gäŋalnydja ŋanya walal balan ŋurikalnha ŋunhi ŋurruḏawalaŋuwalnha djirrikaymirriwal wäŋalil, ga ŋayiny gan ŋunhi Betany marrtjin dhuḏikurr, märr-barrku munguyurryi ŋanya marrtjin bala. ");
INSERT INTO djr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ga ŋunhi nhakun ŋayi Beta gulŋiyinany ŋunhiwiliyiny ŋärra'lil, bala ŋayi nhäŋalnydja yolŋunhany walalany, walal marrtjin dhaŋalkuŋalnha gurthan ḻithanmaranhaminyarawnha walalaŋguwuy walal. Bala ŋayiny Betany dhunupan marrtjin, dhutnha nhinan walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ga ŋayiny waŋganydhuny miyalkthu djämamirriynydja nhäŋala ŋanya Betanhany ŋayi gan nhinanany gurthaŋura, bala yan ŋayi ŋanya gan nhäŋalnydja dharr-bitjarra wiyinnha, ga dhunupan yan ŋayi ŋunhi waŋanany bitjarrnha, “Way, dhuwandja ŋunhi yolŋu Djesuwnha malthunamirr muka?” ");
INSERT INTO djr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ga ŋayiny Betany dhumbal'yurr waŋan bitjarr warray, “Yaka ŋarra dhuwal marŋgi nhanŋu,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ga dhäŋur beŋuryiny yaka wiyin, bala wiripuŋuynydja muka yolŋuy ŋanya nhäŋal dharaŋaryi yan, bala waŋanan nhanŋu bitjarra, “Way, nheny dhuwal yolŋu nhanŋu Djesuw malthunamirr, muka?” Ga ŋayiny Betany buku-bakmaraŋal bitjarra, “Yaka ŋarra dhuwal nhanŋu yolŋu, bäyŋu,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ga yaka wiyin ga wiripuŋuynydja muka yolŋuy ŋanya nhäŋal, bala ŋayi waŋanany ŋanya Betanhany mirithinan bitjarrnha, “Yuwalk muka ŋayi dhuwal malthunamirrnydja yolŋu nhanŋuwuy yan Djesuw, bili ŋayi dhuwal yolŋuny ŋunhaŋuwuy wäŋa-Galalipuy,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ga ŋayiny Betany bulu waŋan dhumbal'yurr nhanŋu bitjarr, “Way yolŋu, nhä nhe ga dhuwal lakaramany? Bawa'yunna nhe ga dhuwal!” Ŋunhi ŋayi gan Beta bitjarrnydja waŋan, ga ŋayiny dhunupan guḻawurrnydja ŋäthinan. ");
INSERT INTO djr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bala ŋayi Djesuny ḏawa'yurra, dharrnha nhäŋal ŋanya Betanhany. Bala ŋayi Betaynydja dhunupan guyaŋanan ŋunhi nhaltjarr ŋayi Garray waŋanan nhanukal ŋäthil bitjarr gam', “Nheny dhu ŋarraku dhuwal dhumbal'yun buku-ḻurrkun'mirr, yurrnha dhu ŋunhi guḻawurrnydja ŋäthi.” ");
INSERT INTO djr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bala ŋayi yan dhunupan Betany dhawaṯthurrnydja, ga ŋäthinany ŋayi ŋunhi murruy'-murruyyurra dhikan. ");
INSERT INTO djr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Ga ŋunhiwurrnydja ḏirramuwurr ŋunhi walal gan ŋayathaŋal ŋanya Djesuny, djäga manapar nhanŋu, ŋuriŋiwurruyyiny gan bartjunmaraŋalnha, ga maŋutji walal ŋanya dhurrthurryurr bambaykuŋal, bala walal ŋanya gan warku'yurr bitjarrnha, “Nhä nhe dhuwal yolŋu, dhäwu-lakaranhamirr muka? Mak lakaraŋ ŋanapurruŋgal, yolthu nhuna marrtjin be bartjunmaraŋalnydja?” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ga bulu nhakun walal ŋanya gan Djesuny waŋandhi ŋayaŋu-miḏikumaryi dhärukthu mala walalaŋgiyingal walal. ");
INSERT INTO djr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ga ŋunhi nhakun wäŋany djaḏaw'yurr, bala walalnydja ŋunhi ŋurruŋu djirrikaymirriynydja mala ga ŋurru-warryunayŋuynydja yolŋuy walal ga rom-marŋgikunhamirriynydja mala, gäŋalnha Djesunhany, ga nhirrparnydja ŋanya walal ŋunhi gumurrlilnydja ŋurikiwurruŋgala rom-djägamirriwala mala yolŋuwalnydja walalaŋgal. ");
INSERT INTO djr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Bala walal ŋanya gan dhä-birrka'yurra bitjarra, “Ŋuli nhe dhuwal yuwalktja yolŋu ŋunhi Maŋutji-dhunupayanhawuynydja, mak lakaraŋun ŋanapurruŋgal biyakun dhawaṯmaraŋun.” Ga ŋayiny Djesuny buku-bakmaraŋal bitjarr, “Ŋunhi ŋarra dhu dhuwal lakaramany nhumalaŋgal, ga nhumany dhu ŋunhi yakan märr-yuwalkmirriyirr ŋarrany. ");
INSERT INTO djr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ga ŋuli ŋarra dhu ŋunhi nhumalanhany dhä-birrka'yun, ga nhumany dhu ŋunhi bäyŋun ŋarrakuny buku-bakmaram waŋa. ");
INSERT INTO djr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ga dhipuŋurnydja dhurrwaraŋur nhuma dhu nhäman ŋarranhany Yolŋunhany Gäthu'mirriŋuny, ŋarrany dhu ga nhinany ŋurruḏawalaŋun, dhunupa'ŋuŋura gali'ŋurnydja, ŋurikalyin ŋunhi ŋayi God-Waŋarr Ŋutu' Ḏäl.” ");
INSERT INTO djr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bala walal yan bukmakthun ŋuriŋiwurruyyiny dhä-birrka'yurrnydja ŋanya bitjarrnha, “Yol bili nhe dhuwal yolŋuny? Dhuwal nhe ŋunhi God-Waŋarrwuny Gäthu'mirriŋu?” Ga ŋayiny waŋan balany bitjarr, “Dhuwaliny nhuma ga dhunupa muka yäku-lakaram ŋarrany.” ");
INSERT INTO djr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Bala walal yan yatjunminan bitjarrnha, “Yakan dhu ga buluny ŋula yolthuny ŋanya lakaram, bili dhuwal limurr bukmakthun ŋanya ŋäkulnydja lakaranhaminyawuynha, ŋunhi ŋayi gan yäku lakaraŋal warku'yurr God-Waŋarrnha.” ");
INSERT INTO djr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bala ŋunhi bukmaknha yan rom-djägamirrnydja yolŋu walal ḻaw'yurra, gäŋalnydja marrtjin ŋanyanhany Djesunhany balan ŋunhi ŋurruḏawalaŋuwala yolŋuwal yäkuwal Bäylitkala. ");
INSERT INTO djr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Bala walal nhirrparnydja ŋanya Djesunhany ŋurikalyin yolŋuwalnydja ŋurruŋuwalnha, ga waŋanany walal gan ŋunhi mirithinan, rom-nyamir'yurrnydja ŋanya Djesunhany. Yo bitjarra walal gan ŋanya ŋunhi lakaraŋalnydja, “Dhuwandja ŋunhi ḏirramuny ŋanapurr gan ŋäkul, ŋayi gan dhar'thar-gurrupar dhuwal limurr bäpurruny yolŋuny walalany ŋurikin ŋunhi yätjkurruwnha djämawnydja. Lakaraŋalnydja ŋayi gan ŋunhi yolŋu'-yulŋuwalnydja bitjarrnha, ‘Yakan rrupiyany gurrupul wuŋuḻi'yurrnydja ŋanya ŋunhany ŋunhi ŋurruŋunhany buŋgawany Rawumbuynhany,’ bitjanna ŋayi ŋuli ga ŋunhi waŋany dhuwal. Ga wiripuny ŋayi ŋuli ga dhuwal lakaranhamirr yanbi ŋayi dhuwal be Maŋutji-dhunupayanhawuynha yolŋu.” ");
INSERT INTO djr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bala ŋayi ŋuriŋiyiny ŋurruḏawalaŋuynydja yolŋuy yäkuy Bäylitthuny dhä-birrka'yurrnydja ŋanya bitjarrnha, “Way, yol nhe dhuwal yolŋuny? … muka dhuwandja nheny ŋurruḏawalaŋu buŋgawa Djuw malaw?” Ga ŋayiny Djesuny buku-bakmaraŋal bitjarr, “Dhunupa dhuwali bili dhäruktja ŋunhi nhaltjarr nhe lakaraŋal.” ");
INSERT INTO djr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bala ŋayi ŋuriŋiyiny Bäylitthuny lakaraŋala ŋurikiwurruŋgalnha ŋunhi ŋurruŋu djirrikaymirriwalnha walalaŋgal ga wiripuwurruŋgal yolŋu'-yulŋuwal bitjarra, “Yaka warray ŋarra dhuwal maḻŋ'maranhany nhanukal ŋula nhäny yätjkurrnydja dhiyakalnydja gay'yi ḏirramuwal. Nhäpuy dhika ŋurrupuynydja nhuma ŋanya dhu bumany?” ");
INSERT INTO djr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yurr walalnydja gan ŋunhi buku-ḏuwaṯthurra yan waŋanany rom-nyamir'yurrnydja ŋanya bitjarrnha, “Dhuwaliyiny ŋayi mari djämamirra yolŋu. Djarrpi'kuŋal ŋayi gan dhuwal marŋgikuŋal yolŋuny walalany dhiyalnydja Djudiyany makarrŋur wäŋaŋur. Ŋäthilnydja ŋayi gan ŋunhi bitjarryi djäma ŋunhal Galali, ga dhiyaŋuny bala ŋayi ga dhuwalatjanna limurruŋgalaŋuwurra wäŋakurr djäma.” ");
INSERT INTO djr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ga ŋunhi ŋayi Bäylitthu ŋäkulnydja walalany balanyawuyyiny waŋanhawuy, bala ŋayi dhä-birrka'yurra walalany bitjarra, “Wanhaŋuwuy bili ŋayi dhuwal yuwalktja yolŋu? … wäŋa-Galalipuy?” Ga walalnydja yoraŋal, “Yo,” bitjarr. ");
INSERT INTO djr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bala ŋayiny yan dhunupan Bäylitthuny* djuy'yurra ŋanya Djesunhany balan Yaritkalnha,* bili ŋayiny ŋunhi Yarittja buŋgawa muka ŋurikiyi Galalipuywuny wäŋaw, ga balanyamirriyyiny ŋunhi waluy ŋayipiny ŋunhi Yarittja ŋunhala Djurutjalamnha wäŋaŋur. ");
INSERT INTO djr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yurr ŋayipiny ŋunhi Yarittja mirithinan nhakun gumurr-ŋamathin nhanŋuny Djesuwnydja ŋunhi walal gäŋalnydja ŋanya balayiny nhanukalnydja, bili dharrwamirr ŋayi gan ŋunhi Yaritthuny ŋäkul Djesuwalaŋuwuynydja dhäwu mala, ga yuwalkkuŋalnha yan ŋayi gan ŋunhi djälthinany mirithinan yan nhänharawnydja nhanŋu. Ga gatjpu'yurrnydja ŋayi gan ŋunhi Yarittja ŋayi dhu ga Djesuy milma yan ŋayaŋu-ganyim'thunamirr rom mala djäma. ");
INSERT INTO djr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Bala ŋayi gan ŋanya Yaritthuny buku-ḏuwaṯthurra dhä-birrka'yurrnydja Djesunhany dharrwawnha romguny malaŋuw, ga ŋayiny gan ŋunhi Djesuny mukthurra yan dhärran, bäyŋun ŋayi ŋula waŋgany dhäruk buku-roŋanmaranha waŋanha nhanŋuny Yaritkuny. ");
INSERT INTO djr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ga walal ŋunhiwurrnydja ŋunhi ŋurruŋu djirrikaymirrnydja mala ga rom-marŋgikunhamirrnydja yolŋu walal, bukmaknha yan walal ŋunhi djalkiri-dhathar'yurrnydja, galkikuŋala ŋanyanhan Yaritnhan guwatjmar, bala walal gan lakaraŋalnydja nhanŋu Yaritkuny dhäwuny', yätjkurra lakaraŋal ŋanya walal gan Djesunhany, rom-nyamir'yurra manapar. ");
INSERT INTO djr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bala ŋayipiny nhakun Yaritthuny ga miriŋuynydja nhanukal gan warku'yurra ŋanya, biyarrmakkuŋalnha gan. Bala yan walal ŋanya dhaṯthurra girriyny'tja miny'tjimirriynha manymakthun dhikan, nhakun walal nhanukal gan ŋunhi buḻ'yurra, ga balayi walal ŋanya roŋanmaraŋalyi djuy'yurr Bäylitkal. ");
INSERT INTO djr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ŋäthilnydja ŋunhi maṉḏaŋguny Yaritkuny ga Bäylitkuny gan mari ŋorran maṉḏaŋguwuynydja; yurr balanyamirriyyiny waluy bala maṉḏa ŋunhi nhakun ḻundukunhaminan. ");
INSERT INTO djr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bala ŋayi Bäylitthuny ḻuŋ'maraŋala ŋunhi ŋurruŋu djirrikaymirrinhany walalany ga wiripuwurruny ḏilkurruwurruny ga bukmaknhan yan yolŋuny walalany, ");
INSERT INTO djr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","bala ŋayi waŋanan walalaŋgal bitjarrnha, “Nhumany gäŋal dhuwandja yolŋuny räli ŋarrakalnydja, bala nhuma gan dhuwal lakaraŋalnydja ŋanya bitjarrnha yanbi ŋayi ŋuli gi bilmaraŋ yolŋuny walalany yätjkurruwnha djämaw. Yurr ŋarrapiny ŋanya gan dhuwal dhä-birrka'yurrnydja dhiyalnydja nhumalaŋgalnydja bukmakkalnydja gumurrŋur, ga bäyŋu warray ŋarra maḻŋ'maranhany ŋula nhäny nhanukal yätjkurrnydja. ");
INSERT INTO djr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ga ŋayi Yaritthu bitjarryi bili maḻŋ'maraŋal nhanukal bäyŋuyi yan ŋula nhäny yätjkurrnydja, bili ŋayiny ŋunhi roŋanmaraŋalyi djuy'yurr ŋanya räliyi ŋarrakal, yakan ŋanya ŋayi ŋula djuy'yunna dhä-gir'yunarawnydja. Ga nhaku nhumany ga djälthirr bunharawnydja nhanŋuny dhiyakuny gay'yi ŋunhi yolŋuw? Bäyŋu ŋayi gi dhuwal djäma ŋula nhäny yätjkurr. ");
INSERT INTO djr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ŋarrany dhu dhuwal dhäruknha yan waŋganynha gurrupan ŋula yolkalnha yolŋuwal, ŋayin ŋanya dhu ŋunhi bartjunmaramany burriṯiŋuynydja, bala djuy'yunna.” Bitjarr ŋayi ŋunhiyi Bäylittja waŋan. ");
INSERT INTO djr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ga bitjarr bili dhuŋgarra-ŋupar ŋayiny ŋuli ganha Bäylitthuny waŋganynhany yolŋuny dhawaṯmaranha yan beŋuryi dharruŋguŋurnydja balanyamirriynydja waluy ŋunhi Ḻäy-djuḻkmaranhamirriynydja. ");
INSERT INTO djr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ga ŋunhiny balaŋ ŋayi Bäylithuny dhawaṯmaranha ŋanyanhan Djesunhan, yurr walalnydja bukmak yan yolŋuny walal waŋan yatjunmin bitjarr, “Yaka ŋanapurr dhiyakiyiny yolŋuw djäl. Yänan buŋun ŋanya. Ga ŋunhi ŋanapurruŋguny yolŋuny yäkuny Barabatjnhany dhawaṯmaraŋun go, bili ŋanapurrnydja dhiyakiyi yolŋuw djäl.” ");
INSERT INTO djr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yurr ŋayiny ŋunhiyiny Barabatjtja yolŋu yäku yätjkurr yan, dhuwurr-djarrpi'. Galk