﻿USE sofia;
DROP TABLE IF EXISTS sofia.djkNT_vpl;
CREATE TABLE djkNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES djkNT_vpl WRITE;
INSERT INTO djkNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Disi na a lo avo gaansama fu Masaa Jesesi Kelestesi, a bakaten manpikin fu Kownu Dafeti paansu. Dafeti seefi na wan baka bakaten pikin fu Abalaham paansu, a moo gaandi avo gaansama fu ala Dyusama. ");
INSERT INTO djkNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ne Abalaham meke Isaki. Ne Isaki meke Jakopu. Ne Jakopu meke Juda anga den taa elufu baala fi en. ");
INSERT INTO djkNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda dati sete a lo fu den Dyusama den e kai Juda. Bika en anga a uman di den e kai Tamal meke Pelesi anga Seila. Ne Pelesi meke Sesilon. Bakadati, ne Sesilon meke Alan. ");
INSERT INTO djkNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ne Alan meke Amenadabu. Ne Amenadabu meke Nakson. Ne Nakson meke Salmon. ");
INSERT INTO djkNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","We, ne Salmon anga a uman den e kai Laakabu meke Bowasi. Ne Bowasi anga a uman den e kai Lotu meke Obeti. Bakadati, ne Obeti meke Isai. ");
INSERT INTO djkNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ne Isai meke Dafeti, a kownu. Namo, ne Kownu Dafeti anga a uman fu Uliya meke Salomo. ");
INSERT INTO djkNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ne Salomo meke Lekabeyamu. Ne Lekabeyamu meke Abiya. Namo, ne Abiya, meke Asa. ");
INSERT INTO djkNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ne Asa meke Jowsafati. Ne Jowsafati meke Yoolam. Ne Yoolam meke Usiya. ");
INSERT INTO djkNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ne Usiya meke Yowtam. Ne Yowtam meke Akasi. Namo, ne Akasi meke Heskiya. ");
INSERT INTO djkNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ne Heskiya meke Manase. Ne Manase dati meke Amon. Bakadati, ne Amon meke Yowsiya. ");
INSERT INTO djkNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ne Yowsiya meke Yekoniya anga den taa baala fu Yekoniya. Da na a ten de, ne den sama fu Babilon Kondee be kon meke oloku anga den Dyusama. Ne den kisi den Dyusama puu a Dyu Kondee tyai go poti a Babilon. ");
INSERT INTO djkNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","We, baka di den kisi den Dyusama so, ne Yekoniya meke Seyaltiyeli. Namo, ne Seyaltiyeli meke Selubabeli. ");
INSERT INTO djkNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ne Selubabeli meke Abihutu. Ne Abihutu meke Eliyaken. Ne Eliyaken meke Asolu. ");
INSERT INTO djkNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ne Asolu meke Saadoki. Ne Saadoki dati meke Akin. Namo, ne Akin dati meke Eliyutu. ");
INSERT INTO djkNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Namo, ne Eliyutu meke Eliyasa. Ne Eliyasa dati meke Matan. Da Matan dati meke Jakopu. ");
INSERT INTO djkNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Te fu kaba, na a Jakopu ya meke Jowsef, a man fu Maliya. Maliya na a mma fu Jesesi di den e kai a Kelestesi. ");
INSERT INTO djkNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","We, te u teli komoto na a fosi gaansama Abalaham go miti Kownu Dafeti, da na tin na fo dada meke pikin. Da fu komoto a Kownu Dafeti go doo a yuu di den Babilon sama kon kisi den Dyusama tyai gwe, da na tin na fo dada meke pikin tu. Soseefi fu teli komoto na a yuu di den Dyusama go a Babilon Kondee, go miti a ten di a Kelestesi meke, da na soseefi tin na fo dada meke pikin tu. ");
INSERT INTO djkNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ma namo, da a de so taki, Maliya na be a poti mofu uman fu Jowsef. Den be de fu libi, ma Maliya kon de anga bee, sondee fu Jowsef sabi en, uman fasi. A Jeje fu Masaa Gadu meke Maliya de anga a bee. ");
INSERT INTO djkNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma namo, Jowsef na be wan sama di e pakisei fu du san fiti Masaa Gadu. Ne a denki namo fu paati anga Maliya saafi bakabaka, sondee fu bolotyasi a taki. Bika a á wani gi Maliya sen. ");
INSERT INTO djkNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ne di a pakisei de kon ne en, ne wan Basiya fu Masaa Gadu Kondee*f1* kon ne en a ini wan deen. Ne a taigi en taki: “Jowsef! Manpikin fu Kownu Dafeti paansu! Yu á mu feele fu teke Maliya toon yu uman! Bika, a ná sama gi en a bee de, ma na a Jeje fu Masaa Gadu seefi wooko so. ");
INSERT INTO djkNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","A o meke wan manpikin. Da i mu kai en Jesesi. Bika ne en o tyai yeepi gi a foluku fi en, fu puu den a takuudu anga ogii.” ");
INSERT INTO djkNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","We! A hii toli ya waka enke fa Masaa Gadu be piki wan fositen apaiti takiman fi en, fu sikiifi taki, dati musu pasa bakaten. Bika a takiman be sikiifi taki: ");
INSERT INTO djkNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wan ten e kon! Yu o si taki wan yonkuu uman, di á go a man wan dei o de anga bee. Da a o meke wan manpikin. Da den o kai en Imanuweli. A nen ya wani taki, Masaa Gadu seefi kon fu de anga wi.” ");
INSERT INTO djkNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","We, di Jowsef weki na a siibi, ne a du leti enke fa a Basiya fu Masaa Gadu Kondee be taigi en, ne a teke Maliya poti a osu enke uman. ");
INSERT INTO djkNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ma a á siibi anga en uman fasi, fosi a meke a manpikin. Ne di Maliya meke a pikin, ne Jowsef taki, den mu kai en Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ma namo, da Masaa Jesesi meke na a pisiwataa fu Judeja, na a foto den kai Betelehem. A pisiten de, da na Kownu Helowdesi be e taki fu a hii pisiwataa anda. Ma wan duupu koniman komoto a doose kondee go a Jelusalem Foto. Den komoto na a se pe san e opo. Den koniman ya na sama di e sabi san o pasa, te den luku den sitali a tapu. ");
INSERT INTO djkNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Di den go doo Jelusalem Foto, ne den e akisi den sama ape taki: “Pe a kownu fu den Dyu di meke ya de? Bika wi si wan sitali a tapu, di e soi wi taki wan nyun kownu fu Dyusama meke dise. Ne i si u kon ya, fu kon gi en gaandi. We, gaantangi! U soi wi pe a meke, baa.” ");
INSERT INTO djkNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Namo, di Kownu Helowdesi yee taki, den e taki wan taa kownu meke, ne en anga a hii Jelusalem foluku buuya, te ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Namo a sende kai ala den moo hei begiman a Jelusalem Foto fu den kon ne en. Soseefi a kai ala den leliman fu Dyuweiti tu. Ne a taigi den taki: “We! Masaa Gadu á be paamisi fu sende wan yeepiman kon a goontapu, no? We, u suku gi mi a ini Masaa Gadu Buku pe a Kelestesi*f2* be o meke.” ");
INSERT INTO djkNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","We namo, ne den piki en taki: “Na Betelehem Foto, na a pisiwataa fu Judeja! Bika a sikiifi taki: ");
INSERT INTO djkNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betelehem Foto! A ná yu de na a pisiwataa fu Judeja, sondee balinen, no? We toku so, yu o toon wan balinen foto. Bika na yu a gaan edeman, di o de wan soluguman fu mi sikapu, mi Dyu foluku, o meke.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","We, Kownu Helowdesi aliki, te a kaba. Namo a sende kai den koniman di be komoto na a se pe san e opo kibii kibii kon ne en. Ne a akisi den, meke den taigi en, on ten pilisisi den be si a sitali a tapu. ");
INSERT INTO djkNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bakadati, ne a gi den pasi den go a Betelehem Foto go suku a pikin. Ma fosi den gwe, ne a taigi den taki: “U go suku fini fini pe a pikin meke. Te u fende en, da u kon piki mi baka. Bika mi seefi wani go gi en gaandi tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","We, di den anga Kownu Helowdesi taki so kaba, ne den gwe. Namo den si a seefi sitali di den be si a tapu baka. We, ne den piisii gaan piisii. Bika den e waka, da a sitali e waka a tapu a den fesi, fu tii den go doo na a pikin. Na di den si a sitali taampu pii a wan peesi, ne den sabi kaba taki, den doo a peesi pe a pikin meke. ");
INSERT INTO djkNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ne den go a ini a osu. Ne den si a pikin anga en mma, Maliya de. Ne wanten wanten den sutu kini a doti, gi a pikin gaandi. Soseefi den puu den sowtu a sowtu dii kado di den be tyai, fu gi a pikin a ini sani. Den be tyai gowtu sani, wan sowtu kandaa fu boon switi sumee anga mile oli fu lobi a sikin. ");
INSERT INTO djkNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na so ala sani be waka. Ma namo de, Masaa Gadu wasikoi den koniman a ini deen taki, den á mu daai go a Kownu Helowdesi moo. Ne den teke wan hii taa pasi waka gwe a den kondee baka. ");
INSERT INTO djkNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Da di den koniman gwe kaba, ne namo, ne Masaa Gadu sende wan Basiya fu Masaa Gadu Kondee*f3* kon a Jowsef, a ini wan deen. Ne a taigi en taki: “Opo teke a pikin anga en mma, da i lowe gwe a Egepte Kondee. Da tan anda fu te enke mi taigi yu, fi i daai kon baka. Bika luku! Helowdesi o meke ala moiti fu kii a pikin ya!” ");
INSERT INTO djkNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","We, ne Jowsef opo, ne a teke a pikin anga en mma na a neti, ne a gwe a Egepte Kondee. ");
INSERT INTO djkNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ne a tan anda fu te Helowdesi dede. Na so a be mu pasa fu san Masaa Gadu be meke wan apaiti takiman fi en be taki mu kon pasa tuu. Bika a be taki: “Mi o kai mi manpikin puu a Egepte Kondee.” ");
INSERT INTO djkNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma namo, di Kownu Helowdesi si taki, den koniman á kon piki en moo enke fa den be taki, ne en ati boon, te ná sipowtu. Ne a sende suudati waka kii ala manpikin, fu tu yali go a ondoo, a Betelehem anga a hii pisiwataa de. Bika den koniman be taigi en taki, na tu yali pasa kaba di den be si a sitali a tapu. ");
INSERT INTO djkNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Da na so a sani kon pasa tuu enke fa a Jelemija, a apaiti takiman fu Masaa Gadu be taki. ");
INSERT INTO djkNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Bika a be taki: “U o yee fa sama e bali gaan adyumadye na a pisi kondee fu Laama. U o yee kusumi anga soso balibali anda. Na den baka bakaten pikin fu a uman den e kai Laakeli di e tan anda o kusumi so. Den ná o wani sama koo den ati. Bika den pikin fu den á de a libi moo.” ");
INSERT INTO djkNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","We, ne baka di Kownu Helowdesi dede, ne na wan Basiya fu Masaa Gadu Kondee kon a Jowsef, a ini wan deen a Egepte Kondee anda. ");
INSERT INTO djkNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne a taigi en taki: “Jowsef, opo! Teke a pikin anga en mma, da u gwe a Islayeli Kondee baka! Bika a sama di be wani kii a pikin anda dede kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","We, ne Jowsef opo wanten, enke fa Masaa Gadu taigi en a ini a deen. Ne a teke a pikin anga en mma, ne den gwe a Islayeli Kondee baka. ");
INSERT INTO djkNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ma di a yee taki na a Alikalawsu, a manpikin fu Kownu Helowdesi toon kownu fu Juda ne en dda peesi, ne a feele fu go na a pisi kondee anda. We, ne Masaa Gadu soi en a ini wan deen taki, meke a go tan na a pisiwataa fu Galileya. ");
INSERT INTO djkNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","We, ne a go tan a wan foto fu Galileya den e kai Nasaleti. Na so san den apaiti takiman fu Masaa Gadu be taki, kon pasa tuu. Bika den be taki: “Den o kai en wan sama fu Nasaleti Foto.” ");
INSERT INTO djkNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na a seefi pisiten de Johanisi a Dopuman be de a ini a gaan sabana fu Judeja Kondee e bali a bosikopu fu Masaa Gadu ");
INSERT INTO djkNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","taki: “Daai libi! Bika a Nyun Tii fu Masaa Gadu de koosube tuutuu.” ");
INSERT INTO djkNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A sani ya waka leti enke fa Masaa Gadu be piki Jesaja enke wan apaiti takiman fu taki, fi en: “A tongo fu wan bosikopuman o bali a ini a gaan sabana taki: ‘U seeka pasi gi a Masaa, meke a pasi sa kon taampu letiopu tollo.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","We, den koosi fu Johanisi di a be e wei be meke anga a uwii fu wan meti den e kai kameili. Da a be e banti en mindii anga wan leli buba. Da na makonkon anga busi oniki a be e nyan. ");
INSERT INTO djkNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Namo den sama fu Jelusalem Foto anga a pisiwataa fu Judeja yee a bosikopu fu Masaa Gadu di ai bali. Soseefi sama di e tan na a pisi fu Joodani Liba seefi yee tu. Ne ala den booko kon aliki san ai taki. ");
INSERT INTO djkNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Namo Johanisi dopu somen fu den sama a ini Joodani Liba. Ma fosi a dopu den, da den be mu puu ala ogii, di den be du taki fosi. ");
INSERT INTO djkNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma Johanisi kon si taki, somen Faliseiman anga Saduseiman de a ini den sama di kon fu teke dopu de. Namo a bali kosi den taki: “U takuu tetei sineki! Fa u du sabi taki, u mu lon kibii gi a gaan atiboon fu Masaa Gadu di de a pasi e kon?” ");
INSERT INTO djkNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Soseefi a taki go doo taki: “Ma u sabi san? Daai libi sowan fasi taki, u libi e puu bun, di e soi taki, u libi daai tuu. ");
INSERT INTO djkNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma u á mu pakisei taki, di u na baka bakaten pikin fu Abalaham paansu, da u anga Masaa Gadu de mati. Kweti kweti! Bika mi e taigi u taki, Masaa Gadu abi makiti fu meke den siton di u e si ya kon toon libisama fu de enke pikin fu Abalaham. ");
INSERT INTO djkNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bika luku ya, a akisi de na a lutu fu a bon kaba. Da iniiwan bon di nái meke bun nyanyan, den sa faa en towe, iti go boon a ini faya.” ");
INSERT INTO djkNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Soseefi Johanisi taki go doo taki: “U si! Mi e dopu u anga wataa, fu u daai libi. Ma u luku Awan di makiti bigi moo mi, a o kon a mi baka! Ma mi á dyendee sai fu bendi sibi en susu gi en seefi. En dati o dopu sama anga a Apaiti Jeje anga faya. ");
INSERT INTO djkNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“We, Masaa Gadu o wai den bun ati sama poti a wanse. Da a wai den takuu ati wan poti na a taase. A de leti enke fa den e wai alisi puu buba. Da den e teke a alisi seefi tyai go kibii a magisin. Ma a buba dati de, e towe a dyiko fu boon a ini gaan ati faya. We da, na letiso den takuu ati sama o pina fu tego a ini a gaan ati faya. Bika sama ná o de fu kii a faya de noiti wan ten.” ");
INSERT INTO djkNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Masaa Jesesi seefi be komoto na a pisiwataa fu Galileya kon a Joodani Liba, fu meke Johanisi dopu enseefi tu. ");
INSERT INTO djkNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma, di Johanisi si en, ne a á wani dopu en. A taigi Masaa Jesesi taki: “Mi ná o dopu yu! Bika na yu mu dopu mi.” ");
INSERT INTO djkNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Masaa Jesesi piki en taki: “Nono! I mu dopu mi. Bika wi ya seefi mu du ala letiopu sani di fiti du.” We, di a taki so, ne Johanisi dopu en. ");
INSERT INTO djkNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma namo, fa i si Masaa Jesesi dopu komoto a ini a wataa go a soo, ne tapu anda piiti opo waa. Ne a Apaiti Jeje fu Masaa Gadu saka komoto a tapu anda wanten, kon enke wan doifi a Masaa Jesesi tapu. ");
INSERT INTO djkNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ne wan Tongo taki a tapu anda taki: “Disi na mi Manpikin di mi lobi. Mi hii ati e piisii anga en.” ");
INSERT INTO djkNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","We ne, wanten wanten de, ne a Apaiti Jeje fu Masaa Gadu tyai Masaa Jesesi waka gwe a ini a gaan sabana. Namo, ne a didibii de ape e tesi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","We, ne Masaa Jesesi poti nyanyan a wanse, fu begi, fotenti dei anga fotenti neti langa. Namo, ne angii moo en. ");
INSERT INTO djkNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","We, ne a tesiman, a didibii kon doo. Ne a taigi Masaa Jesesi taki: “Di i na a Manpikin fu Masaa Gadu tuu, da taigi den siton ya, meke den toon beele, osi?” ");
INSERT INTO djkNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma Masaa Jesesi piki en taki: “Masaa Gadu Buku sikiifi taki: ‘A ná nyanyan namo e oli wan sama a libi. Ma na te wan sama e du san Masaa Gadu taki.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","We bakadati, ne a didibii teke Masaa Jesesi tyai go a tapu na a Mama Keliki fu den Dyu, a Jelusalem, a apaiti foto fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne a taigi en taki: “We, di i na a Manpikin fu Masaa Gadu tuu, da fee saka go a doti anda, no? Bika Masaa Gadu Buku sikiifi taki: ‘Masaa Gadu o sende den Basiya fi en a Masaa Gadu Kondee*f4* kon a yu, fu den tyai yu na a ana, meke yu á sa naki i futu a wan siton.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Masaa Jesesi piki en taki: “Masaa Gadu Buku sikiifi tu taki: ‘Ná tesi Masaa Gadu, di de u Gadu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","We, bakadati, ne a didibii tyai Masaa Jesesi gwe a wan gaan hei mongo ede. Ne te fi i pingi ain opo, ne a soi Masaa Jesesi ala den gudu anga den dyendee fu den kondee kondee fu goontapu. ");
INSERT INTO djkNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ne a taigi Masaa Jesesi taki: “I si fa goontapu dyendee? Mi sa gi yu ala den dyendee de. Ma, da i mu sutu kini a doti begi mi.” ");
INSERT INTO djkNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Namo Masaa Jesesi bali en taki: “Tumalisi komoto a mi fesi ya! Yu didibii, saatan yu! Bika Masaa Gadu Buku sikiifi taki: ‘Na Masaa Gadu wawan u mu begi, soseefi dini!’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","We, ne a didibii fika Masaa Jesesi saafi, ne a gwe. Ne den Basiya fu Masaa Gadu Kondee kon, ne den dini Masaa Jesesi, gi en ala san a abi fanowdu. ");
INSERT INTO djkNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Namo Masaa Jesesi yee taki, den kisi Johanisi sooto. Ne a komoto ape go tan a Nasaleti Foto, pe a be kiya. Nasaleti Foto de na a pisiwataa fu Galileya. ");
INSERT INTO djkNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma Masaa Jesesi á tan langa a Nasaleti de moo. Bika a komoto de go tan a Kafalnayemu Foto. Kafalnayemu Foto meke na a sikin wataa fu a ze den e kai ze fu Galileya. Dati na a pisi pe Sebulon anga Naftali kondee de. ");
INSERT INTO djkNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Da fa Masaa Jesesi go tan ya, meke a sani di wan apaiti takiman fu Masaa Gadu den e kai Jesaja be taki kon pasa tuu. Bika Jesaja be taki: ");
INSERT INTO djkNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Luku den kondee den kai Sebulon anga Naftali. Den de leti na a pasi fu waka pasa kai na a ze, na a taase fu Joodani Liba. Na tu kondee fu taa foluku di á de Dyusama. Galileya seefi na kondee fu sama di á de Dyu. ");
INSERT INTO djkNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Da den be o tan faawe fu Masaa Gadu, te den boo be o koti. Bika den gei sama di de a ini dunguu. Ma den ain o kon kiin, enke fa peesi e kiin fu si. Bika den o kon sabi Masaa Gadu, da den o toon sama di abi pasi fu tan a Masaa Gadu se.” ");
INSERT INTO djkNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","We, ne fanafu di Masaa Jesesi go tan anda, ne ai bali den sama taki: “U daai libi! Bika a Nyun Tii fu Masaa Gadu de koosube tuutuu.” ");
INSERT INTO djkNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","We wan dei, da Masaa Jesesi be e waka na a lampeesi pe a gaan ze fu Galileya kon sutu mofu a soo. Ne a si tu baala. Wan fu den na Simon di abi a taa nen fu Peitilisi. A taawan na Andeleyasi. Den tu baala ya be de fisiman, di e towe seepi fu kisi fisi a ini a ze. ");
INSERT INTO djkNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Namo Masaa Jesesi waka go a den. Ne a taigi den taki: “U kon waka a mi baka! U kon go anga mi na ala pe mi e go. Da mi o leli u onti taa fasi, bika u ná o onti fisi moo. Ma u o kon toon ontiman fu kisi libisama tyai kon biibi a mi.” ");
INSERT INTO djkNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","We, ne den tu baala á du taa fa, ne den wai den seepi wanten poti a wanse. Ne den bigin waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A di den waka go moo pikinso, ne den si tu taa baala anga den dda, Da Sebedi a ini wan boto. Wan fu den baala na Jakowbesi, a taawan na Johanisi. Den be e seeka den seepi, fu go sete. Ne Masaa Jesesi kai den tu baala ya tu. ");
INSERT INTO djkNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ne den tu baala ya seefi fika den dda anga ala den seepi anga ala a boto a baka wanten. Ne den go waka a Masaa Jesesi baka tu. ");
INSERT INTO djkNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Namo, Masaa Jesesi e waka e lontu a hii pisiwataa fu Galileya e leli den sama a ini den keliki osu fu den Dyu. Soseefi ai bali a Bun Nyunsu di e taki, fu a Nyun Tii fu Masaa Gadu. Da ai deesi ala siki anga ala sowtu takuu takuu siki anga nowtu di den sama be abi. ");
INSERT INTO djkNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","We, ne Masaa Jesesi nen bali lontu na a hii pisiwataa de, te go doo Siliya. Den sama anda seefi tyai ala sowtu sikiman kon ne en. Sama di be abi sikin ati. Sama di takuu jeje be e bali a den tapu. Soseefi, den be tyai lawman anga lanman. Ne Masaa Jesesi deesi ala den fiya. ");
INSERT INTO djkNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma namo, da somen sama fu a pisiwataa fu Galileya, anga a pisiwataa fu den tin foto, di den e kai Dekapolisi, anga Jelusalem Foto, anga sama di be e tan na a pisiwataa fu Judeja, anga abaase fu a Joodani Liba, booko kon e waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","We, ne di Masaa Jesesi si fa somen sama e waka ne en baka, ne a subi go a wan pikin mongo. Ne di a sidon, ne den bakaman fi en kon ne en anda. ");
INSERT INTO djkNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ne a bigin leli den taki: ");
INSERT INTO djkNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Seigi fu saka fasi sama di sabi taki, den abi Masaa Gadu fanowdu. Bika fu di a abi a saka fasi ya, da a sa de a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Seigi fu sama di e fii tyali, fu ogii di den du. Bika Masaa Gadu o gi den paadon, meke den ati koo. ");
INSERT INTO djkNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Seigi fu sama di e wooko saka fasi anga taawan. Bika wanten e kon, pe na den anga Masaa Gadu o tii goontapu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Seigi fu sama di e angii fu libi letiopu a Masaa Gadu fesi. Bika Masaa Gadu o yeepi den fu libi so tu, meke den ati koo. ");
INSERT INTO djkNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Seigi fu sama di e wooko tyali ati fasi anga taawan. Bika Masaa Gadu seefi o wooko tyali ati fasi anga den baka. ");
INSERT INTO djkNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Seigi fu sama di ati kiin a Masaa Gadu fesi. Bika dati o meke den go doo Masaa Gadu Kondee, te go si Masaa Gadu seefi anga ain. ");
INSERT INTO djkNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Seigi fu sama di e feti fu puu toobi a sama anga sama mindii. Bika den o kai den pikin fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Seigi fu sama di ogii e miti soso fu di den e libi bun gi Masaa Gadu. Bika den o de a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Seigi fi yu, te sama e kosi yu, e pina yu, e lei gi yu, fu mi ede. ");
INSERT INTO djkNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Dyombo piisii seefi fu dati. Bika na letiso den be pina den fositen apaiti takiman fu Masaa Gadu a fesi. Da u paiman fu kisi bigi a Masaa Gadu Kondee.” ");
INSERT INTO djkNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","We, ne Masaa Jesesi taki baka taki: “U na a sawtu fu goontapu. Da efu sawtu lasi en tesi, da anga san den o sawtu en fu a kisi tesi baka? Nono! A á bun fu du wan enkii sani moo enke na fu fiingi towe a dyiko namo, da a kaba, fu sama waka ne en tapu. Bika taa sani á de, fu poti gi en moo, fu a kisi tesi, baka. ");
INSERT INTO djkNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Soseefi, u na a leti kiin fu goontapu. Wan foto di meke a wan mongo ede, á poi de kibii kibii. Bika te sama e pasa, den ain musu kai ne en. ");
INSERT INTO djkNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","We, u nái leti wan lampu, da u poti en a baka sani. Nono! Te u leti wan lampu, u e poti en a hei, a tapu. Da ai leti kiin peesi gi ala sama. ");
INSERT INTO djkNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na letiso u mu meke a leti fu u kiin gi ala sama fu si, meke den si den bun wooko di u e du, fu di u e biibi. Da den o gi u Tata a tapu daa, fu dati. ");
INSERT INTO djkNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Da u á mu denki taki mi kon fu leli sama taki den á mu oli den weiti di Masaa Gadu be meke Mosesi anga den taa apaiti takiman be sikiifi. Kweti! Mi á kon fu leli sama fu den ná oli den weiti moo. Nono. Ma mi kon fu soi sama tuutuu, fa fu libi leti enke fa den weiti taki! Da mi seefi o libi leti enke fa den weiti taki, meke sama si. ");
INSERT INTO djkNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bika fu tuutuu, mi e taigi u taki, fu te enke a dei di tapu anga goontapu o lasi go kaba a soso, da ala weiti di Masaa Gadu be poti sa tan, fu meke ala san di Buku taki kon pasa tuu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ma son sama e si son fu den weiti ya enke wan soso sani. Da den e leli taawan fu si den weiti ya enke soso sani tu. Da den sowtu sama de o de den moo lagiwan a ini a Nyun Tii fu Masaa Gadu. Ma den sama di e libi leti enke fa den weiti taki, da den e leli taawan fu libi sowan fasi, o hei a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Soseefi, u mu sabi tu taki, sama di wani de a ini a Nyun Tii fu Masaa Gadu, mu waka letiopu fasi moo den Faliseiman anga den leliman fu Dyuweiti seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Bika u yee ya! Weiti be leli u taki: ‘U á mu kii sama ofuso u sa go a kuutu, fu kisi sitaafu.’ ");
INSERT INTO djkNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ma mi e leli u taki: I mu kisi sitaafu kaba, winsi na boon yu ati boon a wan sama namo. Efu na wan taawan i kosi, kai en wisiwasi man, da na wan moo gaan kuutu bakaa mu leisi sitaafu gi yu! Efu yu e kai taawan lawman, da yu fiti kaba, fu go teke sitaafu a didibii faya. ");
INSERT INTO djkNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“We, kon u taki, i tyai wan paiman anga yu go pai Masaa Gadu na a apaiti begi tafaa. Ne a seefi yuu de, ne i kisi a ini i pakisei de taki, wan sama abi wan sani anga yu, da i mu ");
INSERT INTO djkNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","saka a paiman di i tyai go gi Masaa Gadu de fika leti ape fosi. Da i go, da i meke en bun anga en te a kaba fosi, da i kon, da boon a paiman gi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Efu yu anga wan taawan abi sani, da feti fu seeka a taki, meke a toli á go doo kuutu. Bika efu a go doo anda, den o poti yu a sikowtu ana, fu sooto. ");
INSERT INTO djkNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Fu tuutuu mi e taigi i taki: Yu ná o komoto anda fosi i kaba koti a sitaafu, fu san i du.” ");
INSERT INTO djkNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Namo, ne Masaa Jesesi taigi den taki: “We, u be yee kaba taki: ‘Uman anga man, di libi kaba, á mu go a taa man ofu uman.’ ");
INSERT INTO djkNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Toku mi e taigi u taki: Efu wan man si wan uman, ne a luku en anga wan losutu ain, da na waka a waka anga en kaba a ini en ati ini. ");
INSERT INTO djkNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","We, efi i letise ain wani tyai yu go du ogii, da a moo betee i diki en puu fiingi towe. Bika a moo bun fi i lasi wan pisi fi i sikin, da i doo Masaa Gadu Kondee, moo enke pe fi i de anga i hii sikin bunbun, da den iti yu go a didibii faya. ");
INSERT INTO djkNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Soseefi, efi i letise ana e tyai yu go du ogii, da koti en puu towe. Bika a moo bun fi i lasi wan pisi fi i sikin, da i doo Masaa Gadu Kondee, moo enke pe fi i de anga i hii sikin bunbun, da den iti yu go a didibii faya.” ");
INSERT INTO djkNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Soseefi Masaa Jesesi taki baka taki: “U be yee tu taki: ‘Efu wan man o paati anga en uman, da a mu gi en wan biifi di a naki sitampu taki, en anga en paati.’ ");
INSERT INTO djkNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","We, mi e taigi u taki, a sama di o towe en uman fu wan taa sani moo enke te a uman waka gi en, da i fika en fu booko a weiti di taki: ‘I á mu go a taa uman ofu man.’ Soseefi a man di o teke wan uman di en man towe, booko a weiti de tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Namo Masaa Jesesi taki baka taki: “U be yee tu fa den be taigi den avo fu u taki: ‘Te u sweli wan sweli, da u mu du, san u sweli fu du.’ ");
INSERT INTO djkNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma mi e taigi u taki: Kweti kweti! U á mu sweli! U á mu sweli kai Masaa Gadu Kondee. Bika Masaa Gadu Kondee na pe Masaa Gadu sidon ne en kownu sutuu, e luku ala sani. ");
INSERT INTO djkNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","U á mu sweli kai goontapu. Bika goontapu de enke wan futu bangi, pe Gadu e poti en futu. Soseefi, yu á mu sweli kai Jelusalem Foto. Bika, Jelusalem na a foto, pe a gaan Kownu e tan. ");
INSERT INTO djkNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Soseefi yu á mu teke i ede sweli. Bika yuseefi ná abi makiti fu meke yu ede uwii weti efu daai en kon toon baaka. ");
INSERT INTO djkNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ma, te i taki: ‘Ya,’ a mu tan ‘Ya.’ Te i taki: ‘Nono,’ a mu tan ‘Nono.’ Bika efu yu mu sweli, fosi sama mu si taki, na tuu, da na didibii se u e go kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Soseefi Masaa Jesesi taki baka taki: “Den be taigi u tu taki: ‘Efu wan sama booko wan taawan ain, da a taawan abi pasi fu booko en ain baka. Efu wan sama booko wan taawan tifi, da a taawan abi pasi fu booko en tifi baka.’ ");
INSERT INTO djkNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","We, mi e taigi u taki: U á mu pai ogii, fu ogii baka. Ma efu wan sama naki i wan baala ana a i letise sikin fesi, da poti a taase gi en, meke a naki tu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Da efu wan sama wani tyai u go a kuutu, fu di a wani i impi, da a ná yu impi wawan i mu gi en, ma gi en yu dyakiti tu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Soseefi, efu wan sama e dwengi yu, fu waka wan yuu langa anga en, da waka tu yuu langa anga en. ");
INSERT INTO djkNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te wan sama begi yu wan sani di yu abi, da yu á mu mombii en. Efu na wan sani fi yu, wan sama wani leni, da yu á mu fika en gwe anga soso ana.” ");
INSERT INTO djkNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Namo, Masaa Jesesi taki baka taki: “Da den be taigi u tu taki: ‘U mu lobi den sama, di e libi bun anga u. Ma u mu buuse den feyanti fu u.’ ");
INSERT INTO djkNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ma mi e taigi u taki: U lobi den feyanti fu u tu. Da u begi gi den sama, di e lon a u baka e suku fu ogii anga u. ");
INSERT INTO djkNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bika, te u du so, da u de enke fa u Tata a tapu de. We bika, te a san fi en opo a tapu, da ai pii gi takuu ati sama anga bun ati wan makandii. Te a alen fi en e kai, da ai kai gi ala sama. Den bun ati wan go miti den takuu ati wan. ");
INSERT INTO djkNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","We, efu na den sama di lobi yu namo, yu lobi, ma u á lobi den feyanti fu u, da sowtu paiman u sa fende a Masaa Gadu fu dati? Ná so den sama di e piki lantimoni de tu, no? ");
INSERT INTO djkNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Da soseefi, efu yu e taki anga den sama di yu anga den sabi namo, da a ná wan apaiti sani dati. Bika na so den sama fu a goontapu ya, di á de a Masaa Gadu pasi e libi tu. ");
INSERT INTO djkNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","We, u mu meke moiti fu u libi sondee fowtu, enke fa u Tata, di de a tapu de kiinkiin sondee fowtu.” ");
INSERT INTO djkNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","We, ne Masaa Jesesi taigi den taki: “U á mu du sani fu sama ain, fu meke sama si u. Nono! Ofuso, u ná o fende paiman a u Tata a tapu, fu san u du. ");
INSERT INTO djkNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Te u e yeepi pootiman a sani, u á mu yeepi den fu suku balinen a sama. Bika yu o wooko enke bidiigiman. Den sama de, te den du wan bun, da den e bali a taki, a keliki anga kondee ganda. Ma fu tuu, mi e taigi u, gafa di sama e gafa den, meke den kisi den paiman kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma, te u e yeepi pootiman a sani, da u mu yeepi den sowan fasi, sondee fu u kukutu ana sabi san u leti ana e du. ");
INSERT INTO djkNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Da na so, u mu du bun sondee fu sama sabi. Da u Tata, di e si ala san wi e du, o pai wi fu san u du.” ");
INSERT INTO djkNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ne Masaa Jesesi taki: “Te u o begi, u á mu begi enke den bidiigiman di e begi enke den bun moo taawan a ini keliki anga kondee mindii. Na den sowtu sama de e wani libisama mu gafa den, fu a fasi fa den e begi. Ma fu tuu, mi e taigi u, a balinen di den o fende a sama, na dati na a hii wini, di den fende kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Da u dati mu wooko taa fasi, te u e begi. U mu waka go a wan peesi pe sama ain á sa kai a u tapu. Da na ape u mu tan, da u begi. Bika u Tata a tapu e si ala sani. Da na a Masaa Gadu ya u sa fende wini, fu di u begi en so. ");
INSERT INTO djkNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“We, den sama di á sabi Masaa Gadu, lobi e begi gaan langa lolo begi. Bika den membee taki, na te den e lolo so fosi, da Masaa Gadu o yee den. ");
INSERT INTO djkNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma u dati mu begi taa fasi. Bika u Tata, Masaa Gadu sabi ala san u abi fanowdu, fosi u opo mofu begi en wan sani. ");
INSERT INTO djkNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","So! Da u luku ya fa u mu begi. U mu begi taki: ‘Kee! Wi Tata, Masaa Gadu a tapu! Meke ala sani sa kon lesipeki yu nen, wan apaiti fasi. ");
INSERT INTO djkNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Meke a Nyun Tii fi yu sa paati a hii goontapu. Meke ala sani sa waka ya enke fa yu wani, leti enke fa ai waka a yu kondee a tapu anda. ");
INSERT INTO djkNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Wi e begi yu, fu gi wi san wi abi fanowdu, fu nyan tide baka. ");
INSERT INTO djkNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gi wi paadon fu ogii di wi e du a yu fesi, leti enke fa wiseefi e gi taawan di e du ogii anga wi paadon. ");
INSERT INTO djkNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Wi e begi yu fu kibii wi, meke wi á kai a ini tesi. Meke a didibii á sa poi tyai u go ini takuudu anga ogii tu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Namo a taki go doo taki: “Te u sa gi taawan paadon, da u Tata, Masaa Gadu a tapu seefi sa gi u paadon, fu ogii di u e du tu. ");
INSERT INTO djkNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma te u nái gi taawan paadon, da Masaa Gadu, u Tata, a tapu seefi, ná o gi u paadon tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","We, ne Masaa Jesesi taigi den taki: “Te u de sondee nyan, fu begi,*f5* da u á mu de enke den gaan bidiigiman. Bika te den e de sondee nyan fu begi, da den e poti gaan tyali buduufu fesi, fu sama mu si taki, den de sondee nyan fu begi. Da na so den e suku nen a sama. Ma u aliki mi! Den sama de fende den paiman kaba anga a gafa di sama gafa den de. ");
INSERT INTO djkNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ma u dati, te u de sondee nyan fu begi wasi, u fesi moi te a kaba. Lobi fatu a u ede, kanmi u uwii te, u de silli. ");
INSERT INTO djkNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Da so fasi, sama ná o sabi taki u de sondee nyan fu begi. Ma na Masaa Gadu wawan di e si ala sani, e si. Da a sa pai u fu dati.” ");
INSERT INTO djkNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Namo Masaa Jesesi taigi den taki: “U á mu libi so taki, na feti u e feti e suku fu dyunta gudu, poti a goontapu ya namo. Bika goontapu gudu ya, na fu fufuuman kon booko osu teke tyai gwe. Soseefi, na fu udulosu anga fuunsu go nyan poli tu. ");
INSERT INTO djkNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ma na feti u mu e feti e libi bun gi Masaa Gadu! Bika Masaa Gadu paamisi den sama di e libi sowan fasi gaan gudu, di noiti noiti o poli. A o dyunta dati poti a Masaa Gadu Kondee gi den. Soseefi, fufuuman á poi fende pasi go fufuu den puu anda. ");
INSERT INTO djkNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","We, u yee ya! Na pe yu gudu de, na ape yu ati o de tu. ");
INSERT INTO djkNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“We, a lampu fu wan libisama sikin, na den ain fi en. Da efu yu ain kiin, da i hii sikin o kiin tu. ");
INSERT INTO djkNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ma sama di ain á kiin, da i hii sikin o de dunguu dunguu. Na letiso, efu wan sama ati á kiin, a sa waka a dunguu. Bika na den sama di ati kiin sa waka a leti pasi.” ");
INSERT INTO djkNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Namo Masaa Jesesi taki baka taki: “Ná wan sama di o poi dini tu masaa, sondee fu lobi awan moo enke a taawan. Bika a o lobi awan e teke en taki, moo enke a taawan. Soseefi wan sama á poi dini Masaa Gadu efu moni de wan basi fi en tu. ");
INSERT INTO djkNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ma efu Masaa Gadu na u basi, da u ná abi fu kusumi. U ná abi fu taki: ‘Oho! San mi o nyan? Oho, san mi o wei a sikin?’ Bika pakisei taki, Masaa Gadu du moo gaan sani gi wi enke libisama. A gi wi sikin anga libi, di bigi moo nyanyan anga koosi. Da efu a gi wi den sani de, da i denki taki, a ná o gi wi sani fu nyan anga sani fu wei? ");
INSERT INTO djkNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","We, luku den foo a tapu anda! Peesi fu paandi sani, den ná abi. Magisin fu kibii nyanyan sani, den ná abi tu. Ma toku, den e nyan, e diingi ibii dei. We, wi enke libisama waiti moo foo! ");
INSERT INTO djkNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","I denki taki, libisama sa kusumi fu sani te, da a fende moo langa libi? ");
INSERT INTO djkNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","“Teke yu ain luku den moi boomiki di e goo a goontapu! We, u be yee fu a fositen kownu di den kai Salomo. Na be wan tuutuu poolo man, di be e wei en koosi moi, moo ala sani. Ma toku anga ala a moi dyendee fasi fi en de, toku a á be doo a moi fu den boomiki ya. ");
INSERT INTO djkNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ma na Masaa Gadu meke den moi so. Ma toku den ná abi langa libi seefi. Bika na tide den de ete, ma kande den á doo tamaa. Libisama e koti den go boon a ini faya enke soso sani. Ma u ya dati waiti moo boomiki! Da fa u pakisei taki Masaa Gadu ná o poi solugu u anga koosi? Ma na fu di u nái biibi Gadu sai, na dati e tyai a denki de. ");
INSERT INTO djkNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“We, u á mu kusumi moo, pakisei taki: ‘Oho! San u o nyan anga san u o wei a sikin tu?’ ");
INSERT INTO djkNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Bika na sama di nái waka a Masaa Gadu pasi e kusumi den fasi de. Ma u Tata a tapu, sabi ala san u abi fanowdu. ");
INSERT INTO djkNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Da suku fu de a ini a Nyun Tii fu Masaa Gadu. Soseefi fu waka letiopu fasi fiti en. Da a o gi u ala san u fanowdu. ");
INSERT INTO djkNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ma u á mu feti e kusumi fu a dei fu tamaa. Bika ibii dei abi en eigi booko anga en nowtu.” ");
INSERT INTO djkNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ná kuutu, kaagi taawan, da taawan ná o kuutu, kaagi yu tu. ");
INSERT INTO djkNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Bika na a fasi fa yu e kuutu, kaagi taawan, na so taawan o kuutu, kaagi yu baka. Anga a seefi maiki di yu e teke maiki taawan, anga en den o teke maiki yu baka. ");
INSERT INTO djkNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Bika saide meke, u e si a pikin mbalububa a ini a ain fu wan taawan, ma a gaan gobo di de a ini iseefi ain, dati i nái si? ");
INSERT INTO djkNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Da fa i sa taigi i baala taki: ‘Baala! Kon mi puu a pikin mbalu a ini yu ain gi yu.’ Ma wan gaan gobo de a ini iseefi ain? ");
INSERT INTO djkNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","U bidiigiman u! Puu a gaan gobo a ini iseefi ain fosi, da i sa si kiin fu puu a pikin mbalu di de a ini i baala ain gi en!” ");
INSERT INTO djkNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Namo Masaa Jesesi piki den taki: “U á teke a apaiti sani fu Masaa Gadu, iti gi den dagu anga den agu. Bika te u iti den gi dagu anga den agu, da den ná o si en fu wan sani. Da kande den o teke en, da den waka ne en tapu, masimasi en enke lawlaw sani. Da te fu kaba, da den daai kon nyan yu seefi pisipisi kii.” ");
INSERT INTO djkNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","We, ne Masaa Jesesi taigi den taki: “U begi, da u o kisi. U suku, da u o fende. U koko, da doo o opo gi u. ");
INSERT INTO djkNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bika sama di e begi, e kisi. Da sama di e suku, e fende. Soseefi sama di e koko, da doo e opo gi den. ");
INSERT INTO djkNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","We, sama di de ya, te i manpikin begi yu wan beele, yu o teke wan siton gi en? ");
INSERT INTO djkNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Te a akisi yu wan fisi, yu o teke wan sineki langa gi en? Nono! ");
INSERT INTO djkNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","We, efu u, anga ala fa u abi takuu ati seefi, toku u sabi gi u pikin bun sani so, da fa u pakisei, fu u Tata a tapu? A ná o gi sama di e begi en sani, bun sani, no? ");
INSERT INTO djkNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“We, a fasi fa i wani meke sama libi anga yu, na letiso i mu libi anga sama tu. Disi na a hii mama fu den weiti di Mosesi, anga ala taa taa fositen apaiti takiman fu Masaa Gadu be sikiifi.” ");
INSERT INTO djkNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Soseefi a taki go doo taki: “U doo pasa, go a ini, na a sumaa doo mofu! Bika a baala doo mofu na fu pasa go miti a baala pasi di e go kai a didibii faya. Somen sama de, di e waka na a baala pasi ya, pasa go a ini. ");
INSERT INTO djkNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma a doo di e tyai sama go na a libi fu tego sumaa. Da a pasi fu waka go miti a doo de nyoni, da a taanga fu waka. Somen sama á de di e waka ne en.” ");
INSERT INTO djkNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Namo Masaa Jesesi wasikoi den sama taki: “U mu koni anga leiman di e lei taki, den na apaiti takiman fu Masaa Gadu. Den sa koli yu kisi. Bika den e kon a yu tapu enke bunbun saka manii sama. Ma luku bun anga den! Den abi takuu ati enke takuu meti di e kisi taa meti nyan kii. ");
INSERT INTO djkNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","A takuu libi fu den e puu a takuu ati di den abi kon a doo, fu si. Bika i si pe bunbun sii fu nyan komoto a maka bon kaba? ");
INSERT INTO djkNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Kweti! Na bun ati bon namo sa poi meke bunbun sii fu nyan. Ma takuu ati bon na sii di á bun fu nyan a o meke. ");
INSERT INTO djkNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Takuu ati bon dati á poi meke bunbun sii fu nyan. Da a kon, bun ati bon á poi meke sii di á bun fu nyan tu. ");
INSERT INTO djkNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Da di takuu ati bon nái meke bun sii kaba, da na fu koti go iti a ini faya, fu boon. ");
INSERT INTO djkNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ala san mi taki de e soi, fa fu luku sama libi, meke u sa sabi den falisi takiman.” ");
INSERT INTO djkNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Namo Masaa Jesesi taki go doo taki: “U denki taki na ala sama di e kai mi, ‘Masaa! Masaa!’ o go doo a Nyun Tii fu Masaa Gadu Kondee a tapu anda. Kweti! A ná ala sama di e kai mi, ‘Masaa! Masaa!’ o doo anda. Ma na sama di e libi enke fa mi Tata wani, o doo a tapu anda. ");
INSERT INTO djkNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na a dei di Masaa Gadu o kai ala sama kon a kuutu, da u o yee bali. Taawan o go e bali taki: ‘Oho! Masaa! A ná wi be teke yu nen e tyai a bosikopu fu Masaa Gadu go taigi sama, no? Masaa! A ná wi be e yaki takuu jeje puu a sama tapu anga yu nen, no? Oho! Masaa, a ná wi be e du somen foondoo sani anga yu nen, no?’ ");
INSERT INTO djkNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ma, da mi o piki den taki: ‘U gwe komoto a mi fesi ya! U takuu ati sama u! Bika mi á sabi u enke sama di be e libi enke fa mi wani.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Soseefi Masaa Jesesi taki go doo taki: “Sama di e teke mi taki de enke wan gaan koniman. Bika a koni, da a sabi luku bunbun peesi fu sete en osu. ");
INSERT INTO djkNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A sete a fondamenti fi en osu kinkin, fasi a ini wan bunbun taanga doti. Namo gaan alen kai dyullu, ne wataa fuu kon doo na a osu. Soseefi, gaan winta wai huu kon naki a osu. Ma anga ala dati, toku a osu á bunduka kai. Ma a taampu kinkin ete. Bika a fondamenti be sete a ini taanga doti. ");
INSERT INTO djkNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ma sama di á wani teke mi taki dati tan enke gaan donman di don. Bika a gei sama di don, fu sabi luku bunbun peesi, fu sete en osu. A gaan donman ya go sete a fondamenti fi en osu wisiwasi fasi a ini fukufuku doti. ");
INSERT INTO djkNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Namo gaan alen kai dyullu, ne wataa fuu kon doo na a osu. Soseefi gaan winta wai huu kon naki a osu. Ne a osu bunduka guwaa dyulu a wataa. Bika a be sete a fukufuku doti ini.” ");
INSERT INTO djkNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Da a hii fasi fa Masaa Jesesi e gi a leli fu Masaa Gadu ya be foondoo den sama, te ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bika den leliman fu Dyuweiti be e leli den sani wan hii taa fasi. Ma Masaa Jesesi dati be e leli den, enke wan sama di sa sidon taki a Masaa Gadu peesi. ");
INSERT INTO djkNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Namo Masaa Jesesi saka a pikin mongo kon a ondoo baka. Da tyaipi sama be de ne en baka e waka. ");
INSERT INTO djkNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wan gwasiman dati be de a ini den sama. Ne a lon kon sutu kini a doti gi Masaa Jesesi. Da ai begi taki: “Masaa! Yu sa wani deesi mi? We, da gaantangi deesi mi, no baa?” ");
INSERT INTO djkNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ne wanten wanten, ne Masaa Jesesi langa ana oli en, taki: “Eeye! Mi wani i kon bun.” Da Masaa Jesesi á kaba taki seefi, a gwasi fu a man gwe kaba. A kon bun kele kele. ");
INSERT INTO djkNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Namo Masaa Jesesi taigi en taki: “Yee ya! Yu á mu go taigi sama fa i du kon bun so! San i mu du, da go a den apaiti begiman na a Mama Keliki a Jelusalem Foto, meke den si fa i kon bun. Soseefi tyai a paiman go pai de, enke fa Mosesi weiti taki, gwasiman mu pai, te den kon bun. Da na dati o meke den sama de si taki, i kon bun tuutuu.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","We, ne Masaa Jesesi o komoto go a wan foto, den e kai Kafalnayemu Foto. Na ape a de, wan ofisii fu den suudati fu Loma Foto, lon kon begi en wan sani. ");
INSERT INTO djkNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","A taki: “Masaa! Wan fu den futuboi fu mi lan didon a osu. Ai dede anga sikin ati.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ne Masaa Jesesi piki en wanten taki: “Mi o kon anda, fu kon deesi en gi yu.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A ofisii piki en baka taki: “Nono Masaa! Bika mi á waiti sai taki, i sa poti i futu a ini mi osu. Na wan wowtu namo mi wani i taki. Da mi futuboi musu kon bun.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Soseefi a ofisii taki go doo taki: “Bika mi seefi abi basi a mi tapu. Den e sende mi sani, da mi musu fu du, san den e sende mi. Mi abi suudati a mi ondoo. Den musu fu du, ala san mi e sende den. Efu mi sende wan go a wan peesi, a musu fu go. Mi taigi wan taki, kon! A musu fu kon. Mi taigi wan taki, du so! A musu fu du so.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Masaa Jesesi aliki, fa a ofisii fu suudati ya taki, te a kaba. Ne a sani foondoo en te, a daai wanten luku ala sama di taampu ape taki: “Oho! A man di biibi mi a biibi ya! A ná Dyusama, seefi! Ma Dyusama seefi á de di biibi mi a fasi ya wanten. Senten mi e waka lontu a Dyu Kondee, mi á si Dyusama di biibi mi so wanten.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Soseefi a taki go doo taki: “Fu tuu! I si fa a man ya biibi mi tide ya? Na letiso somen taa foluku, di á de Dyusama o de na ala uku fu goontapu di o kon sabi fa Masaa Gadu abi makiti. Na den dati o de a ini a Nyun Tii fu Masaa Gadu Kondee a tapu anda, makandii anga den moo gaandi avo gaansama fu wi Dyusama ya, Abalaham, Isaki anga Jakopu. Da na den o sidon makandii anda na a seefi tafaa, fu meke piisii makandii. ");
INSERT INTO djkNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma a ná Dyusama Masaa Gadu o tyai go a ini a Nyun Tii fu Masaa Gadu Kondee a tapu anda, no? Weeno! Ma toku, somen fu den o kai gwe a ini a sitaafu peesi pe soso kee anga tyali de, fu di den nái biibi mi.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Namo Masaa Jesesi daai go taigi a ofisii taki: “Go a osu fi i! Ala sani musu waka enke fa yu biibi taki mi o du.” Ne a seefi yuu di Masaa Jesesi taki so, ne a futuboi fu a ofisii, kon bun kelle. ");
INSERT INTO djkNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Moo lati, ne Masaa Jesesi go a Peitilisi osu. Ne a go si a main fu Peitilisi didon anga feba a kama tapu anda. ");
INSERT INTO djkNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Namo a oli a uman de wan ana namo, ne a feba saka wanten. Ne a main fu Peitilisi ya opo go seeka sani fu nyan gi Masaa Jesesi anga den taawan wanten. ");
INSERT INTO djkNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Fa i si neti e doo, sama fu a kondee de seefi tyai somen sama di abi takuu jeje a den tapu kon a Masaa Jesesi. Da Masaa Jesesi e bali den takuu jeje wan kodo mofu namo. Da ala den e komoto wanten wanten a den sama tapu gwe. Soseefi Masaa Jesesi be e deesi ala sama di be abi taanga siki de tu. Ala sikiman be kon betee so moimoi. ");
INSERT INTO djkNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A hii sani ya e waka enke fa Masaa Gadu be piki Jesaja, a fositen apaiti takiman fi en, fu sikiifi taki, dati o kon pasa bakaten. Bika a be sikiifi taki: “A teke ala u takuu siki puu a u tapu. Da enseefi tyai wi siki anga wi nowtu gi wi.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Namo Masaa Jesesi si taki, somen sama kon lontu en. We, ne ai go fu abaa go na abaase fu a ze, anga den bakaman fi en. ");
INSERT INTO djkNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Namo wan leliman fu Dyuweiti lon kon akisi en taki: “Mesiti! Mi wani kon waka a i baka. Mi wani go na ala pe yu e go.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Masaa Jesesi piki en wanten taki: “I sabi san i akisi mi de? I sabi taki, boo peesi á de ya gi mi, enke fa foo abi nesi fu boo? I sabi taki, olo seefi á de ya gi mi fu go didon boo, enke fa busi dagu abi olo fu go didon boo? Bika a Manpikin di saka kon toon libisama ya, da osu á de ya gi en, fu go sidon teke boo.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Namo wan fu den bakaman fu Masaa Jesesi dati kon taigi Masaa Jesesi taki: “Masaa! Fosi mi kon waka a yu baka, i sa gi mi pasi fu go beli mi dda fosi, baa?” ");
INSERT INTO djkNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ne Masaa Jesesi piki en dati taki: “Man! Waka a mi baka. Fika den dede, meke den beli den dede.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Namo, ne Masaa Jesesi go a ini a boto. Ne den bakaman fi en seefi teke ne en baka. ");
INSERT INTO djkNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","A yuu di den e gwe, a wataa e seke te! Den gaan paana e naki kon a ini a boto ogii ogii. Ma Masaa Jesesi didon pii e siibi. ");
INSERT INTO djkNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na den bakaman fi en e feele te, ne den go weki en. Da den e bali taki: “Oho, oho, oho! Masaa yeepi, no? I nái si taki, wi o dede, no?” ");
INSERT INTO djkNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Namo Masaa Jesesi piki den taki: “Den sama ya! U nái biibi mi sai! Saide u e feele so?” Namo a opo, bali a winta anga a seke wataa taki: “Seke wataa anga winta! U tan pii!” Bakadati, ala sani koo pii tuu. ");
INSERT INTO djkNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Den sama di be de ape foondoo, te a ná sipowtu. Da den e taki: “Sama na a sama ya seefi? A abi makiti te, winta anga seke wataa seefi mu e teke en taki.” ");
INSERT INTO djkNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ne di den doo na a pisi fu den Gadaleini sama, na abaase fu Galileya ze, ne tu man waka kon ne en. Da takuu jeje be de a den tu man ya tapu. Den komoto a den siton olo pe den e beli dedesama e kon. Da ná wan sama be poi fu waka na a pisi pasi ya, bika den tu man ya be ogii seefi seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ma di den si Masaa Jesesi, ne den bali wanten taki: “Pikin fu Masaa Gadu! San wi anga yu abi, meke i kon ya? Na kon i kon poti wi a sitaafu, fosi a yuu fu kisi sitaafu seefi doo?” ");
INSERT INTO djkNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Da wan duupu agu be de na a pisi kondee de. Bika sama be e kweki agu ape. ");
INSERT INTO djkNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Namo den takuu jeje, di de a den tu sama tapu begi Masaa Jesesi taki: “Gaantangi, baa! Te i puu wi a den tu sama ya tapu, gi wi pasi fu go a ini den agu anda, baa?” ");
INSERT INTO djkNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Namo Masaa Jesesi sende den taki: “Pasa go anda wanten!” Ne wanten wanten, ne den komoto go a ini den agu anda ini. Bakadati, ne ala den agu lon komoto a wan mongo ede, kai go dede a ini a ze. ");
INSERT INTO djkNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ne den sama di be luku den agu lon go a foto, go taki san pasa ya. ");
INSERT INTO djkNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Namo den sama fu a foto aliki a hii toli, te a kaba. Ne den booko go miti Masaa Jesesi. Ne den begi en gaantangi tangi, fu a gwe komoto na a pisi kondee pe den e tan de. ");
INSERT INTO djkNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ne bakadati, ne Masaa Jesesi go a boto, ne a abaa go na abaase, na a foto pe a be e tan. ");
INSERT INTO djkNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fa i si a doo, ne wan duupu sama tyai wan lanman a daagi tapu kon ne en, fu a deesi en. Ma namo, di Masaa Jesesi si fa den sama di tyai a man kon de e biibi en taanga, ne a taigi a man taki: “Man, ná feele! I kisi paadon fi i takuudu anga ogii kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ma wan duupu leliman fu Dyuweiti de ape, yee san Masaa Jesesi taki. Ne den kuutu a ini den ati taki: “Ai sipowtu e kosi Masaa Gadu! We, moo so poli fu poli Gadu nen á de!” ");
INSERT INTO djkNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma Masaa Jesesi sabi ala san den e pakisei. Ne a piki den taki: “Fu saide u e pakisei ogii fu mi a ini u ati ini so du? ");
INSERT INTO djkNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Meke mi akisi u. Fu taigi wan sama taki, a kisi paadon fi en takuudu anga ogii, efu fu taigi en taki, ‘Opo taampu waka!’ on di moo taanga? ");
INSERT INTO djkNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ma u mu sabi taki, a Manpikin di saka kon toon libisama ya abi makiti a goontapu, fu gi sama paadon fu takuudu anga ogii.” Ne a daai, ne a taigi a lanman taki: “Opo taampu! Teke i daagi waka go a osu!” ");
INSERT INTO djkNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","We, ne a lanman opo, ne a go a osu. ");
INSERT INTO djkNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Den somen sama di be de ape foondoo te, a fika feele gi den. Den gafa Masaa Gadu fu di a gi libisama a gaan makiti ya. ");
INSERT INTO djkNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Namo, ne Masaa Jesesi komoto de e waka e gwe. Di a waka te wan pisi, ne a si Mateyesi sidon ne en kantoo e piki lantimoni. Ne a kai en taki: “Man, waka a mi baka!” Ne wanten, ne Mateyesi opo waka ne en baka. ");
INSERT INTO djkNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ne moo lati, ne Mateyesi kai Masaa Jesesi anga den taa bakaman fi en, fu den go nyan ne en osu. Da fa i si den go de, da wanlo taa sama di e piki lantimoni enke Mateyesi seefi anga sama di be e tyai polinen a kondee, be de ape tu. ");
INSERT INTO djkNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Namo di den Faliseiman si Masaa Jesesi sidon anga den sama ya, ne den akisi den bakaman fu Masaa Jesesi taki: “Fa a waka a mesiti fu u e mosoo enseefi so anga den man di e piki lantimoni anga den taa polinen man de, te a mu sidon a tafaa anga den e nyan seefi?” ");
INSERT INTO djkNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Namo Masaa Jesesi yee san den e akisi den bakaman fi en. Ne a taigi den taki: “Meke mi akisi u wan sani. San u pakisei dataa de fu du? Na fu deesi sikiman ofu fu deesi sama di de gusontu?” ");
INSERT INTO djkNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ne a taigi den taki: “Faliseiman! U mu go leli san wan fositen apaiti takiman fu Masaa Gadu be sikiifi. Bika a be sikiifi taki: ‘U á mu denki taki, na te u kii meti boon begi mi, da u e dini mi kaba. Nono! Mi wani u abi tyali ati fu libisama, e fii anga den.’ Bika mi á kon a goontapu fu kai den bunbun sama, ma mi kon fu kai den sama di sabi taki, den libi á bun.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","We, wan taa dei, ne den bakaman fu Johanisi a Dopuman kon a Masaa Jesesi. Ne den taki: “Wi enke bakaman fu Johanisi, wi anga den Faliseiman lobi de sondee nyan, fu begi Masaa Gadu. Ma saide den bakaman fi yu seefi nái de sondee nyan fu begi Masaa Gadu tu?” ");
INSERT INTO djkNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Namo, Masaa Jesesi piki den anga wan ageisi toli. A taki: “I sabi te wan man e toow, da ai oli wan toow osu. Da ai kai en mati fu kon nyan piisii anga en. We, i denki den mati sa sidon de sondee nyan? Nono! Ma, i sabi on ten den mati fi en o de sondee nyan? Na te sama kon puu a man di e toow a den mindii tyai gwe fosi.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ne Masaa Jesesi taki baka taki: “I sa nai nyun pisi koosi anga gaandi wan mokisa? Nono! Bika a nyun pisi o ali a gaandi pisi piiti. Da a piiti o bigi moo di be de kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Soseefi, den nái teke nyunyun meke win lai a ini wan gaandi metibuba saka. Bika a nyunyun win o soopu, da a saka ná o poi soopu moo, fu di a gaandi kaba. Da te den lai a win go a ini, da a o basi towe ala. Da a kon taki, i lasi a saka, i lasi a win. Ma te i poti nyunyun meke win a ini nyunyun saka, da te a win o soopu, da a saka seefi o soopu tu. Da ná wan fu den di o lasi.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Namo wan edeman fu wan Dyu keliki kon sutu kini a Masaa Jesesi fesi e kee taki: “Masaa! Wan pikin umanpikin fu mi dede dyonson dyonson ya a osu. Ma mi e biibi taki, yu poi weki en baka.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","We, ne Masaa Jesesi komoto anga den bakaman fi en, ne den e go makandii anga a edeman fu a keliki, na a edeman ya osu. ");
INSERT INTO djkNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na pasi den de, ne wan uman lon kon a Masaa Jesesi baka. A uman ya be abi wan lasi buulu siki, fu twalufu yali langa kaba. Namo a bendi go oli a koosi mofu fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Da ai pakisei taki: “Efu mi fende Masaa Jesesi koosi oli pikinso namo, mi o kon bun.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","We, ne Masaa Jesesi daai luku wanten, ne a si a uman. Ne a taigi en taki: “Uman! Ná feele! Fu di i biibi mi so taanga, da i kon bun kaba.” Fa i si Masaa Jesesi taki so, a uman betee kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","We, den waka pikinso moo. Ne den go doo a osu fu a edeman fu a Dyu keliki. Ne Masaa Jesesi si somen sama e pee wan pee enke tuka anda. Da na so den e kee wan gaan kee de tu. ");
INSERT INTO djkNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Namo Masaa Jesesi go taigi den taki: “U pasa gwe a doo anga u sani di u e meke! Bika a pikin á dede, na siibi ai siibi.” We, di Masaa Jesesi taki so, ne den sama kii en anga lafu. ");
INSERT INTO djkNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma di ala sama komoto a doo, ne Masaa Jesesi go a ini a kambaa pe a dede pikin didon. Ne a oli a dede pikin ana, paa. Fa i si a kaba oli en, a pikin opo sidon wanten. Na weki a pikin weki kon a libi baka de so. ");
INSERT INTO djkNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","We, a nyunsu fu a gaan foondoo toli ya paati esi esi na a hii pisiwataa anda. ");
INSERT INTO djkNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Namo, ne Masaa Jesesi daai e gwe. Ma tu beendiman lon kon ne en baka. Da den e bali taki: “Yu Bakaten Manpikin fu Kownu Dafeti paansu! Gaantangi! Yeepi wi anga a tyali ati di yu abi fu wi!” ");
INSERT INTO djkNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma Masaa Jesesi waka go doo a osu, pe a be e tan. Ma soseefi den beendiman seefi de ne en baka go doo, te a ini a osu. Namo Masaa Jesesi akisi den taki: “U e biibi taki, mi poi deesi u tuu?” Namo den piki en taki: “Masaa! Wi e biibi dati tuutuu!” ");
INSERT INTO djkNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","We, ne Masaa Jesesi lobi ana a den ain, saa. Ne a taki: “Da na san u biibi taki mi o du, sa pasa.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Fa i si Masaa Jesesi kaba taki so, den beendiman ain opo waa, den kon e si. Ma Masaa Jesesi wasikoi den taki: “U á mu go taigi ná wan sama.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma anga ala fa a bali den de seefi, toku den paati a mofu na a hii pisiwataa, te ala sama kon sabi. ");
INSERT INTO djkNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","We, ne di den tu sama gwe, ne den tyai wan babawman kon a Masaa Jesesi, fu a deesi en tu. Bika wan takuu jeje be de na a sama ya tapu, e tapu en mofu fu a á poi taki. ");
INSERT INTO djkNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","We, ne Masaa Jesesi yaki a takuu jeje puu ne en tapu. Ne a kon bun wanten baka, te ai taki. Ne den sama kon e foondoo te, den e taki: “Fu senten di Islayeli Kondee de, noiti so wan sani be pasa ya so wanten.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ma den Faliseiman taki: “Wi Faliseiman dati sabi fa ai du puu takuu jeje a sama tapu. Na saatan, a basi fu didibii e yeepi en, fu puu den takuu jeje.” ");
INSERT INTO djkNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Namo, Masaa Jesesi dati e waka e lontu a den foto foto anga den kondee kondee fu a hii pisiwataa anda. Da ai leli den sama a ini den Dyu keliki, a Bun Nyunsu di e taki, fu a Nyun Tii fu Masaa Gadu. Soseefi, da ala pe a doo, da ai deesi sikiman anga sama di be abi nowtu de. ");
INSERT INTO djkNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma fa a si den somen sama e kon ne en, ne tyali fu den sama kisi en te, ná sipowtu. Bika a si taki, den sama tan enke fa i sabi sikapu e waka buuya buuya sondee wan soluguman, fu solugu den. ");
INSERT INTO djkNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","We, ne Masaa Jesesi taigi den bakaman fi en taki: “Somen sama de, di abi yeepi fanowdu. Den de enke wan gaan goon nyanyan di de lepi lepi fu koti poti a baakoto. Ma wookoman á de ipi sai. ");
INSERT INTO djkNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","We, u mu begi a Masaa fu a wooko, meke a sende wookoman go na a wooko fi en.” ");
INSERT INTO djkNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Namo Masaa Jesesi kai den twalufu bakaman fi en kon, ne a taigi den taki: “U aliki ya! Mi gi u makiti fu u yaki takuu jeje puu a sama tapu. Soseefi mi e gi u makiti fu u deesi ala sowtu sikiman.” ");
INSERT INTO djkNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","We, da den nen fu den bakaman fu Masaa Jesesi di a be teke puu a den taawan mindii, fu de enke apaiti bosikopuman fi en, di den e kai aposteli na be: Simon, a fosiwan fu den aposteli di den be e kai Peitilisi tu Andeleyasi, en baala Jakowbesi, anga en baala Johanisi, den manpikin fu Da Sebedi ");
INSERT INTO djkNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi Baatomeyosi Towmasi Mateyesi di be e piki lantimoni Jakowbesi a manpikin fu Alefeyosi Tadeyesi ");
INSERT INTO djkNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon Selotu*f6* Judasi Iskaliyotu, di seli Masaa Jesesi, meke den kii en. ");
INSERT INTO djkNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Da na den twalufu bakaman fi en ya, a sende na a wooko. A taigi den taki: “Fa i si u o go de, u á mu go a ná wan taa sowtu sama moo enke den Dyusama. Ná den sama fu Samaliya Kondee seefi u mu go. ");
INSERT INTO djkNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ma na den Dyusama fu u, di den enke lasi sikapu e waka sondee wan soluguman. Na den u mu go. ");
INSERT INTO djkNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Te u go, da u taigi den taki, a Nyun Tii fu Masaa Gadu de koosube. ");
INSERT INTO djkNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Soseefi, fa i si u o go de, u mu deesi ala sowtu sikiman kon bun. Efu wan sama dede, u weki en baka, puu a dede. U deesi ala den gwasiman fiya. U yaki ala den takuu jeje puu a den sama tapu. A apaiti taanga, di mi gi u ya, a ná bai u bai en. Da u á mu meke sama pai u fi en tu. ");
INSERT INTO djkNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Da te u o go, ná wan kopoo sensi seefi di u mu tyai go anga u. ");
INSERT INTO djkNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","U á mu lai nyanyan a saka tyai. U á mu tyai tu dyakiti ofu tu susu tyai go anga u. U á mu tyai moo enke wan waka tiki go anga u tu. Bika a fiti fu wan wookoman nyan, fu a wooko di ai du. ");
INSERT INTO djkNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ma, te u go doo wan foto efu wan kondee, da u suku wan waiti bun manii sama, da u tan ne en osu. Da na ape u mu tan te enke u komoto de fu gwe a wan taa peesi. ");
INSERT INTO djkNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma, te u doo a ini a osu de, da u mu gi den sama de odi taki: ‘Meke Masaa Gadu gi u koo ati fu libi, ye!’ ");
INSERT INTO djkNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Da efu den sama fu a osu de, waiti fu fende a bun de, da Masaa Gadu o gi den koo ati fu libi tuu. Ma efu den á waiti fu fende en, da den ná o fende en. Da a bun de o daai kon a u baka. ");
INSERT INTO djkNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma efu u go a wan kondee ofu wan osu, ne den sama á wani oli u, den á wani yee a bun fu Masaa Gadu, da u mu komoto de gwe. Ma, te u o gwe, da u mu naki u futu puu a doti di be de ne en towe fika de. Dati o soi taki, te Masaa Gadu o gi den sitaafu, da u dati ná abi fowtu a ini. Ma na denseefi fowtu, meke Masaa Gadu o sitaafu den so. ");
INSERT INTO djkNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“Bika fu tuutuu mi e taki, a dei di Masaa Gadu o kai ala sama kon a kuutu, da a o gi den sitaafu! A o bigi moo a sitaafu fu Sowdom anga Gomola, den tu ogii foto, di Masaa Gadu be gi faya a fositen. ");
INSERT INTO djkNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ma u aliki! Fa mi e sende u go ya, da a de enke te mi be o sende sikapu go a mindii fu takuu meti. Da, u mu de na ain e wooko anga ala fusutan. U mu waka anga saka fasi anda. ");
INSERT INTO djkNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","U mu luku bun anga den sama! Bika den sa kisi u tyai go a kuutu. Den o wipi u a ini den keliki osu fu den tu. ");
INSERT INTO djkNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Soseefi den o kisi u tyai go a den edeman fu kondee, fu mi ede. Ma ala dati o pasa, fu di u mu fende pasi fu kotoigi fu mi gi ala Dyusama, te go miti taa foluku di á sabi Masaa Gadu du. ");
INSERT INTO djkNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Te den kisi u tyai go a den kuutu fu den, da u á mu pantan anga booko ede taki san u o taki. Nono! Bika a yuu de, da Masaa Gadu o gi u san fu u taki. ");
INSERT INTO djkNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bika a ná u o sabi taki so, ma a Apaiti Jeje fu mi Tata di de a u ini, ne en o taki komoto a ini u, kon a doo. ");
INSERT INTO djkNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“We, u mu de sabi sabi taki, wan baala o seli en baala gi sama fu kii, fu di ai biibi mi ede. Wan dda seefi o seli en pikin gi sama fu di a pikin e biibi mi ede. Soseefi pikin seefi o seli dda anga mma gi sama fu kii. ");
INSERT INTO djkNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Meke u taki, ná wan sama o lobi u, fu di u e biibi mi ede. Ma a sama di o tei ati oli fu oli doo, te na a kaba, da a sa fende a yeepi fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","We, u yee ya! Te u go a wan foto, ne sama e suku toobi anga u de, da u lon komoto de, go a wan taa foto. Bika fu tuu, mi e taigi u taki, u ná o poi kaba a wooko na ala den foto fu Islayeli Kondee ya, fosi a Manpikin di saka kon toon libisama ya daai kon baka a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Da fa i si den e du anga u de, na letiso den e du anga mi ya kaba. Bika a sama di e teke leli a wan basi, noiti hei moo a basi. Soseefi wan futuboi á hei moo en masaa. ");
INSERT INTO djkNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ma a mu soi a futuboi fu kon de enke en masaa. Na dati meke fa den e kosi mi ya taki, na Belisebulu, a basi fu didibii de a mi tapu, da u denki taki, den ná o kosi u so tu? Bika mi anga u na awan. ");
INSERT INTO djkNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“We, mi e taigi u taki, u á mu feele ná wan enkii sama, di wani du ogii anga u! Kweti! Bika ná wan sani o kibii te, da a á kon a kiin wan dei. Da ná wan sani o pasa te, da sama á sabi. ");
INSERT INTO djkNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na dati ede meke, den sani di mi e taigi u saafi saafi ya, u mu bali den taanga seefi kon a doo. ");
INSERT INTO djkNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Soseefi u á mu feele, te sama e suku fu kii u. Bika den sa kii u sikin namo, da a kaba. Ma den á poi kii u jeje. Ma a sama di u mu feele, dati na Masaa Gadu. Bika a sa kaba i sikin a soso, da a towe i sikin anga a jeje fi i go a ini didibii faya*f7*. ");
INSERT INTO djkNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","U luku den pikin foo di e fee a tapu anda. Ná wan sama di e si den fu gaan sani. Na dati meke den e seli tu, fu wan tiisensi. Ma anga ala fa i si den e fee e lontu anda, ná wan fu den di e puu kai a doti, efu a ná u Tata, Masaa Gadu gi pasi fu dati. ");
INSERT INTO djkNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","We, u enke libisama, no? Mi e taigi u taki, Masaa seefi sabi onmen uwii de a u ede. ");
INSERT INTO djkNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Na dati meke u ati á mu dege dege. Bika u waiti onmen toon moo enke den pikin foo. ");
INSERT INTO djkNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Da sama di sa taki fu mi, a fesi fu libisama, da mi sa taki fi en, a mi Tata fesi a tapu tu. ");
INSERT INTO djkNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma efu yu á wani taki fu mi, a fesi fu libisama, da mi seefi ná o taki fi yu a fesi fu mi Tata tu. ");
INSERT INTO djkNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Da fa i si mi kon a goontapu ya, da u á mu denki taki, na fii mi tyai kon a goontapu. Nono! A ná fii mi tyai kon. Ma na feti mi tyai kon. ");
INSERT INTO djkNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mi kon fu paati sama anga sama. Bika wan manpikin anga en dda o paati. Wan umanpikin anga en mma o paati. Main anga main o paati. Bika den o kisi gaan toobi fu mi ede. ");
INSERT INTO djkNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Da den moo gaan feyanti fu wan man, sa de en eigi famii seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ma ibiiwan sama di sa lobi en dda, en mma, en manpikin, ofu en umanpikin moo mi, dati á fiti fu toon bakaman fu mi. ");
INSERT INTO djkNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Efu wan sama á wani teke den pina anga banowtu di e kon ne en tapu, fu di ai waka a mi baka, da sowan sama á sa poi de mi bakaman. Bika i mu poi tyai pina anga banowtu, fu mi ede. ");
INSERT INTO djkNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma sama di o tan libi doo enke fa en seefi wani, dati sa lasi a hii libi fu tego. Ma sama di o fika en hii libi gi Masaa Gadu wawan, da sowan sama sa fende a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Da sama di teke den bakaman fu mi di e tyai a bosikopu fu mi oli a den osu, da na miseefi den teke oli de kaba. Da sama di teke mi oli a den osu, teke a sama di sende mi kon oli a den osu tu. ");
INSERT INTO djkNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kon u taki, i teke wan apaiti takiman fu Masaa Gadu oli a yu osu, da i sa fende a seefi paiman di Masaa Gadu o pai ala apaiti takiman fi en a Masaa Gadu Kondee. Dati wani taki, teke wan bun ati sama di lobi Masaa Gadu oli a yu osu, da yuseefi o fende a paiman fu dati. Masaa Gadu o pai yu a seefi paiman di a o pai ala bun ati sama di lobi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Soseefi, ibiiwan sama di gi a moo mofina bakaman fu mi soso wan gaasi wataa namo, sa fende paiman fu dati baka. Bika Masaa Gadu o pai en fu dati.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","We, da Masaa Jesesi kaba soi den bakaman fi en san den mu go du. Ne enseefi komoto go waka a ini den foto foto fu Galileya pisiwataa anda. Da ai paati a Bun Nyunsu fu Masaa Gadu. Soseefi ai leli den sama anda fa fu libi. ");
INSERT INTO djkNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ma Johanisi a Dopuman be de sooto sooto, fasi kankan a dunguu osu ete. Pe a de anda, da ai yee taki, a Kelestesi*f8*, e waka e wooko. Namo a sende en bakaman go akisi Masaa Jesesi wan sani. ");
INSERT INTO djkNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","A meke den akisi en taki: “Fa i de ape? Na yu na a sama di Masaa Gadu be paamisi fu sende kon tyai yeepi kaba? Boiti yu, da taawan á de fu a sende kon moo, no?” ");
INSERT INTO djkNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Namo Masaa Jesesi sende den baka taki: “Na go namo u mu go taigi Johanisi san u seefi si mi e du anga san u yee mi e du. ");
INSERT INTO djkNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","U taigi en taki, beendiman e kon si baka. Lan man e opo waka baka. Gwasiman e kon bun tu. Dofuman e kon yee baka. Dede seefi e weki baka. Soseefi a Bun Nyunsu fu Masaa Gadu e paati, te go doo ala mofina wan.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Soseefi Masaa Jesesi taki go doo taki: “Go taigi Johanisi taki, ma na sama di tan biibi mi go doo o fende seigi a mi ana.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","We, ne den bakaman fu Johanisi gwe baka. Namo Masaa Jesesi akisi den somen sama di de ape taki: “Sama de ya di be go luku, fa Johanisi be e dopu sama a ini a sabana? Fu sowtu sama u be oli en, meke u be go luku en anda so? U be pakisei taki, na wan man di winta poi wai tyai go a pe a wani, fu di a feke? ");
INSERT INTO djkNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","U be pakisei taki, na wan modoman di e wei gaan dii koosi, u be e go luku anda? Nono! Bika, da na kownu osu u be sa go luku dati.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Soseefi Masaa Jesesi taki go doo taki: “U piki mi! Saide u be komoto a u osu gwe te a ini a gaan sabana, fu go luku Johanisi so? We fu tuu, na oli u be oli taki, en na wan apaiti takiman fu Masaa Gadu. Na dati meke u be gwe, go aliki san a abi fu taki. We, fu tuu mi e taki, Johanisi bigi moo wan apaiti takiman fu Masaa Gadu seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Bika na Johanisi kon na a Kelestesi fesi, enke fa wan fositen apaiti takiman fu Masaa Gadu be sikiifi taki, dati musu fu pasa. Bika a be sikiifi taki: ‘Mi o sende wan apaiti takiman fu mi kon, fosi yuseefi kon doo. A o taigi sama fu daai seeka den libi, na a leti pasi fu Masaa Gadu.’ ");
INSERT INTO djkNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Fu tuu, da fu ala den sama di komoto a mama bee, da ná wan fu den di hei enke Johanisi ya. Ma toku, ibiiwan mofina di de a ini a Nyun Tii fu Masaa Gadu, fende gaan bun moo enke Johanisi seefi.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Soseefi, Masaa Jesesi taki ete taki: “Ma fu di Johanisi sete paati a bosikopu fu Masaa Gadu, te kon miti tide, da a bosikopu ya e booko pasi naamo. Ala sowtu sama e feti fu teke en, fu kon de a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","We, ala fositen apaiti takiman fu Masaa Gadu be tyai a bosikopu, fu fa Masaa Gadu wani tii sani. Den be e du dati te, Johanisi kon doo nownow. ");
INSERT INTO djkNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Da sama wani teke taki, na Johanisi Masaa Gadu be e kai Eliya, di a be piki den apaiti takiman fi en fu sikiifi taki, Eliya o waka na a Kelestesi fesi. ");
INSERT INTO djkNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","We, sama di wani fu fusutan a sani ya, mu poti ede pakisei dipi.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Soseefi, Masaa Jesesi taki go doo taki: “Ma meke mi taigi u, fa sama fu a ten ya tan. ");
INSERT INTO djkNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Na pikinengee di e pee den gei. Den pikin e pee poku! Namo afu akisi den taawan taki: ‘Saide u á wani dansi. Bika u naki doon fu dansi, u á wani dansi. U naki doon fu tyali, u á wani tyali. Da san u mu du moo?’ ");
INSERT INTO djkNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","U si fa den pikin de manii gei sama fu a ten ya? Bika noiti sani de di bun gi den wanten. Johanisi kon, a be e tan sondee nyan, fu begi. Den daai, den taki na didibii de ne en tapu. Da den ná o teke en taki. ");
INSERT INTO djkNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Now, da a Manpikin di saka kon toon libisama ya, nái tan sondee nyan fu begi. Namo dati á bun gi den baka. Den e kaagi now taki, na fu nyan ai libi. Soseefi den fende taki, ai mati anga soso poli sama. Da den ná o teke en taki tu. Ma koni musu de fu si a den letiopu wooko di ai du.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Namo, Masaa Jesesi daai wasikoi den foto foto pe a be waka du foondoo sani. Bika den sama anda á daai libi, winsi fa den si foondoo sani di a du. ");
INSERT INTO djkNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Namo a wasikoi den taki: “Heelu fu u sama fu Kolasin Foto anga Betisaida Foto! Bika mi du gaan foondoo sani gi u, ma toku u á daai libi. We, u si fa Masaa Gadu be boon den tu ogii fositen foto, den e kai Tilosi anga Sidon. Ma efu na anda mi be du foondoo sani so, da den sama anda be o daai libi. Da Masaa Gadu á be o boon den foto de. ");
INSERT INTO djkNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","We, u luku ya! Wan dei e kon, di Masaa Gadu o kai ala sama kon a kuutu. Da fu tuu, den sama fu Sidon Foto anga Tilosi Foto ná o kisi gaan sitaafu enke u fu den foto ya.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Soseefi, Masaa Jesesi wasikoi Kafalnayemu Foto taki: “U sama fu Kafalnayemu Foto seefi! U pakisei u o subi go doo Masaa Gadu Kondee? Kweti! Na ini a sitaafu peesi fu faya u o kai go. Bika u si fa Masaa Gadu be boon Sowdom Foto a fositen. Ma efu na anda mi be du den foondoo sani so, da den sama de be o daai biibi Masaa Gadu. Da Masaa Gadu á be o boon a foto fu den. ");
INSERT INTO djkNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ma fu tuu mi e taki, wan dei e kon di Masaa Gadu o kai ala sama kon a kuutu. Da Sowdom Foto ná o kisi gaan sitaafu, enke u fu Kafalnayemu Foto de.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Namo a ten ya, ne Masaa Jesesi begi Masaa Gadu taki: “Kee! Mi Tata, Masaa Gadu! Na yu na a basi fu ala sani tuu. Mi e gi yu gaantangi, fu fa yu meke sama di abi hei membee á poi sabi, a gaan koni di yu abi. Ma na mofina wan i soi a gaan koni di yu abi. ");
INSERT INTO djkNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","We! Mi Tata, a bun fa yu du so! Bika mi sabi taki, na so yu lobi fu sani waka.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Soseefi a daai taigi den sama taki: “Fu tuu! Mi Tata poti ala sani fi en a ini mi ana. Ma na a Tata wawan sabi sama na a Pikin. Taa sama á de di sabi a Pikin enke fa a Tata sabi en. Soseefi, sama á de di sabi a Tata enke fa a Pikin dati sabi en. Da na sama a Pikin meke kon sabi a Tata, na den dati namo sa sabi en.” ");
INSERT INTO djkNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Soseefi a kai den sama taki: “Ibii sama anga nowtu, u kon teke boo a mi! ");
INSERT INTO djkNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Da leli fu waka enke fa mi e leli, fu tyai u anga mi taanga. Soseefi, fu tyai u nowtu gi u, enke fa wan sama e tow wan taawan boto tyai. Mi o du a wooko de gi u, bika mi abi saka fasi, fu yeepi sama, meke u sa fende boo. ");
INSERT INTO djkNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mi leli á taanga fu tyai. Bika anga miseefi taanga u o tyai en, meke u sa poi tyai a libi de.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na wan kina dei fu a seefi ten ya, ne Masaa Jesesi e waka pasa a ini wan goon. Wan sowtu sii be taampu enke somen alisi tiki a ini a goon de. Ne den bakaman e piki a ede fi en e nyan. Bika angii be moo den. ");
INSERT INTO djkNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Namo den Faliseiman si san den bakaman fu Masaa Jesesi e du ya. Na so den go kaagi wanten a Masaa Jesesi taki: “Luku den bakaman fi yu! Den e wooko a kina dei! Den piki den sii! Ma weiti taki, sama á mu wooko a kina dei.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Namo Masaa Jesesi piki den taki: “Faliseiman! San sikiifi a ini Masaa Gadu Buku taki, Kownu Dafeti anga den sama fi en be du, di angii be moo den? ");
INSERT INTO djkNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A edeman di be e luku a apaiti tenti fu Masaa Gadu á be meke den nyan a beele, di sama e poti gi Masaa Gadu a ini a apaiti tenti de, no? Weeno! Ma i denki taki, den be abi pasi fu nyan a beele de? Kweti! Bika weiti taki, na soso den apaiti begiman fu a Mama Keliki namo mu nyanmi en. ");
INSERT INTO djkNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Soseefi, da Mosesi weiti taki, den apaiti begiman abi pasi fu wooko a ini a Mama Keliki fu Masaa Gadu, a kina dei. Na dati meke sama á poi kaagi den, te den e wooko a kina dei. ");
INSERT INTO djkNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Fu tuu, mi e taigi u! Wan Sama de a u mindii ya, di hei moo a Mama Keliki seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ma wan sani u dati mu kon fusutan. A sikiifi a ini Gadu Buku taki: ‘Boon meti enke paiman fu gi Masaa Gadu ya gaantangi, na wan bun sani. Ma te u wooko anga tyali ati fu taawan, da mi moo lobi dati!’ Efu u be poi fusutan dati, da wi á be o kon kaagi sama di á du ogii. ");
INSERT INTO djkNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Soseefi, da a Manpikin di saka kon toon libisama ya, na a gaan Masaa fu a kina dei.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","We baka fu dati, ne Masaa Jesesi waka go a wan fu den Dyu keliki osu anda. ");
INSERT INTO djkNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Namo a go si wan man anga wan lan ana anda. Ma wan duupu siteeman be de ape tu. Den dati go wanten go akisi Masaa Jesesi, sani fu sitee anga en. Da te Masaa Jesesi be sa piki wan fowtu fasi, da den be o fende pasi kaagi en. Namo den akisi Masaa Jesesi taki: “Deesi sikiman a kina dei sa de wan sani, di fiti fu du?” ");
INSERT INTO djkNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma Masaa Jesesi piki den anga wan hiihii ageisi toli. A taki: “Fa i de ape, da i abi wan sikapu! Efu a kai go a ini wan dipi olo a kina dei, san yu o du? We, na moiti i be o meke fu puu en de, winsi fa na kina dei. ");
INSERT INTO djkNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yu e du dati gi wan meti a kina dei, da fa i pakisei fu wan libisama di waiti moo meti? We, u luku ya! A weiti fu Masaa Gadu nái tapu sama, fu du bun gi taawan a kina dei.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","We, baka fu dati, ne Masaa Jesesi daai go na a lanman di de ape. Ne a taigi en taki: “Biya! Mi soi yu, tiiki a lan ana go anga fesi, ye!” Fa i si a sama tiiki a lan ana, a lan ana poi tiiki tuutuu. A kon bun kele kele enke a taase ana. ");
INSERT INTO djkNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Namo den Faliseiman sama di be de ape waka gwe a doose wanten. Den gwe go kai pakisei luku, fa fu fende wan fasi fu puu Masaa Jesesi futu a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ma Masaa Jesesi sabi san den e pakisei fu du. Ne a komoto ape wanten gwe a wan taa peesi. Namo somen sama waka gwe ne en baka. Da ai deesi ala den sikiwan a ini den sama mindii, te enke den kon bun. ");
INSERT INTO djkNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma fa i si ai deesi den, da ai taigi den taki: “Ma te u gwe, u á mu taigi sama, sama deesi u so, ye!” ");
INSERT INTO djkNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","We, luku ya! A hii wooko fu Masaa Jesesi ya be e waka enke fa Masaa Gadu be meke a apaiti takiman fi en di den be e kai Jesaja, be sikiifi a fositen. ");
INSERT INTO djkNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Bika a be sikiifi taki: “Luku a wookoman di mi teke fu du mi wooko! Ai du san fiti mi, ne mi lobi en enke mi gaasi fu ain. Da mi sa poti mi Apaiti Jeje ne en tapu. Da a o soi sama di á sabi Masaa Gadu, fa fu kon sabi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma a ná o de fu kwali kwali anga sama. Kweti! Soseefi, a ná o hei enseefi, suku balinen tu. ");
INSERT INTO djkNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma a sa yeepi sama di libi wani go poli, fu den libi á mu go poli. Soseefi a o yeepi sama di wani lasi ati, fu den á sa lasi ati. A sa wooko so go doo a dei di Masaa Gadu o meke goontapu kon toon wan letiopu peesi. ");
INSERT INTO djkNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Da na somen sama di á be sabi Masaa Gadu o kon poti biibi ne en tapu.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","We, den be tyai wan sama di abi takuu jeje kon a Masaa Jesesi. Da a sama be beendi tu, da a á be poi taki. Namo Masaa Jesesi deesi en kon bun, kele kele. ");
INSERT INTO djkNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ne den sama di de ape foondoo gi Masaa Jesesi, te ná sipowtu. Ne den e akisi den seefi taki: “Ma a sa de taki, a sama ya, na a Bakaten Manpikin fu Kownu Dafeti paansu?” ");
INSERT INTO djkNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","We, ne den Faliseiman sama seefi kon yee san den sama de e taki de. Namo den kaagi taki: “Na wi dati sabi fa ai du puu takuu jeje a sama tapu. Na a basi fu takuu jeje, di den e kai Belisebulu seefi gi en a taanga anga a makiti fu du dati.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma Masaa Jesesi sabi fa den e denki so! Ne a piki den anga wan ageisi toli taki: “I be abi wan kownu, di e tii wan gaan kondee. We, den sama fu a kondee ya opo e feti anga denseefi. Da a hii kondee fu a kownu ya ná o booko saka, no? Soseefi wan gaan famii ofuso wan foto de. Ne den sama a ini, sete fu feti anga den seefi. Da den sama ya o booko den seefi saka tu. ");
INSERT INTO djkNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","We, efu didibii seefi kon daai e puu enseefi, da san ai du? Da na feti ai feti anga enseefi, fu booko a hii makiti anga a hii kondee fi enseefi, di ai tii. ");
INSERT INTO djkNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","We, u Faliseiman de! Useefi abi bakaman di e puu takuu jeje a sama tapu tu. U go akisi den a sani ya. Den sa piki u taki, didibii ná o wooko, fu puu enseefi a sama tapu. Bika efu a du so, da ai poli enseefi wooko. ");
INSERT INTO djkNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma u aliki ya! Di na Masaa Gadu Jeje de a mi tapu kaba, fu puu takuu jeje, da u mu sabi taki, a Nyun Tii fu Masaa Gadu kon doo u ya. ");
INSERT INTO djkNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Bika sama ná o poi fu pasa, go teke wan taanga man sani a ini en osu puu a doo. Fosi a sa du dati, da a musu tei a taanga man di abi a osu de fosi. ");
INSERT INTO djkNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“We, ibii sama di á wani teke a se fu mi, dati o de a didibii ondoo. Bika den sama di nái wooko makandii anga mi, dati e suku fu poli mi wooko. ");
INSERT INTO djkNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Ma fu tuu, Masaa Gadu sa gi wan sama paadon, fu ala ogii di a sa du. Soseefi a sa gi en paadon tu, fu ala taa kosi, winsi ai taki ogii fu a Manpikin di saka kon toon libisama ya. Ma a wan sani di noiti Masaa Gadu e gi sama paadon, na te a sama e taki ogii fu a Apaiti Jeje fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“We, na a sii di wan bon e meke yu o luku, da yu sa sabi fa fu kai a bon seefi. Wan bun ati bon e meke bun sii. Ma na wan takuu ati bon e meke sii di á bun. ");
INSERT INTO djkNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Na yu enke ogii ati sama, enke takuu tetei di taampu de, á sa poi puu bunbun taki kon a doo. Bika na san fuu a takuu ati fu u, e kon komoto a doo. ");
INSERT INTO djkNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ma wan bun ati sama, na bun manii ai puu kon a doo. Ma wan ogii ati sama dati na takuu manii, ai puu kon a doo. ");
INSERT INTO djkNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma fu tuu, mi e taigi u! Wan dei e kon, da Masaa Gadu o kai ala sama kon a kuutu. Da ibii sama o gi faantiwowtu, fu ala soso taki seefi di a be taki ya. ");
INSERT INTO djkNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma sama di be abi bunbun sani e taki, da dati o tyai bun gi a sama de a Masaa Gadu. Ma efu na poli taki i be abi, da dati o tyai sitaafu gi yu a Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","We, ne wan duupu leliman fu Dyuweiti o waka kon a Masaa Jesesi. Soseefi, Faliseiman be de a ini kon tu. Namo den sende Masaa Jesesi taki: “Mesiti! Du wan gaan wonduu a tapu anda, osi, meke u si fa yu abi a makiti fu Masaa Gadu tuutuu?” ");
INSERT INTO djkNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Namo Masaa Jesesi piki den taki: “U takuu ati sama, di á de fu fitoow! Bika na a sowtu sama enke u de wani si wonduu, enke maiki fosi den sa biibi. Ma mi ya dati ná o soi u wan enkii maiki, moo enke a foondoo toli fu Jowna. ");
INSERT INTO djkNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bika u sabi taki, Jowna be beli dii dei anga neti a ini a gaan fisi bee. We, na so den o beli a Manpikin di saka kon toon libisama ya, dii dei anga neti a ondoo doti tu. ");
INSERT INTO djkNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma wan dei e kon, da den sama fu Ninifei o opo, da den o kuutu den sama fu a ten ya. Bika den sama fu Ninifei be yee a wowtu fu Masaa Gadu di Jowna be gi den. Ne den teke en, ne den daai libi wanten. Ma wan Sama de a u mindii ya, di hei moo Jowna, ma toku, u nái teke en taki. ");
INSERT INTO djkNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Soseefi a uman kownu fu a kondee na a se fu san dongo, o opo na a gaan kuutu dei, di Masaa Gadu o kuutu sama, fu kuutu den sama fu a ten ya. Bika en dati be komoto langa langa te na a taase fu goontapu fu kon a Salomo, fu kon yee den koni fi en. Ma wan Sama de a u mindii ya, di hei moo Salomo seefi, ma toku, u nái teke en taki.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Namo Masaa Jesesi wasikoi den sama go doo taki: “Te wan takuu jeje e komoto na wan sama tapu, da a gwe moimoi, go waka lontu, suku taa tanpeesi a ini gaan sabana. Ma, da a nái poi fende tanpeesi anda. ");
INSERT INTO djkNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Da ai pakisei taki: ‘Meke mi daai go tan na a peesi pe mi be komoto baka.’ Da te a daai kon baka, a osu pe a be komoto de leigi leigi. A de kiinkiin sibisibi moi silli. ");
INSERT INTO djkNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ma fosi a go baka, da ai go kai ete seibin taa takuu jeje ogii moo enseefi. Da ala den e go tan a ini a sama makandii. Da a kon, sowan sama libi e kon moo ogii, moo fosi den be puu a takuu jeje gi en. Na letiso sa pasa anga den sama di nái yee mi taki ya tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Da di Masaa Jesesi de ape e taki den sani ya, ne en mma anga den baala fi en kon luku en. Den be wani taki anga en. Ma a osu pe Masaa Jesesi be de fuu te, ne den á poi doo Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","We, ne wan sama lon kon piki Masaa Jesesi a ini a osu taki, en mma anga den baala fi en de a doose e luku en. ");
INSERT INTO djkNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Namo Masaa Jesesi akisi taki: “Sama u e kai mi mma anga mi baala?” ");
INSERT INTO djkNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ne a daai sii soi finga a den bakaman fi en. Ne a taki: “U luku den sama ya! Na den na mi mma anga mi baala, mi tuutuu tyuku tyuku famii. ");
INSERT INTO djkNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bika na ala sama, di e du enke fa mi Tata, Masaa Gadu a tapu wani, na mi baala anga mi sisa anga mi mma.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ne a seefi dei de, ne Masaa Jesesi komoto a ini a osu, ne a go sidon a wataa mofu anda. ");
INSERT INTO djkNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma somen sama booko kon lontu en te, ná sipowtu. Ne a go a ini wan boto fika den sama a soo. Da na anda a tan e taki anga den sama. Da den sama taampu a sikin liba e aliki. ");
INSERT INTO djkNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ne a leli den somen sani anga ageisi toli taki: “Wan sama be go a goon, go tyatya wan sii fi en, fu goo. ");
INSERT INTO djkNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","We, di a tyatya a sii, ne afu kai a sikin pasi. Ne pikin foo kon, ne den nyan den. ");
INSERT INTO djkNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Soseefi wan duupu sii kai a siton ini, di ná abi tyaipi doti. Ne den disi goo kon wanten. Bika a doti de á be dipi gi den. ");
INSERT INTO djkNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma fa i si a san pii, ne a boon den. Da fu di den á be abi lutu, ne den dede. ");
INSERT INTO djkNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Da taa sii kai a ini maka, ne den goo. Soseefi, den maka seefi goo tu. Da fu di den goo makandii, meke den maka pasuma den sii kii. ");
INSERT INTO djkNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma soseefi, wan duupu sii kai a bun doti. Den disi goo bunbun, meke nyanyan, te ná sipowtu. Son fu den meke wan ondoo toon, moo enke san di a be paandi. Taawan meke sigisitenti toon, moo enke san di den be paandi. Taawan baka, meke diitenti toon, moo enke san di den be paandi tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ne Masaa Jesesi taigi den taki: “Sama di abi yesi fu yee, da meke a yee san mi taki de.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","We, ne den bakaman fu Masaa Jesesi kon ne en, ne den akisi en taki: “We, Masaa! Saide meke yu e leli sama anga ageisi toli?” ");
INSERT INTO djkNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Namo Masaa Jesesi piki den taki: “U enke bakaman fu mi, u naki bun ede, fu kon sabi den dipi toli fu Masaa Gadu. Bika u dati sa kon fusutan a Nyun Tii fi en. Ma den sama anda á fende a gaan bun de, fu di den á wani aliki mi. ");
INSERT INTO djkNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bika sama di abi, da a sa fende tyaipi moo, te a pasa maiki. Ma sama di ná abi, da a pikinso di a abi seefi, den o teke puu ne en. ");
INSERT INTO djkNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Da na fu dati ede meke, mi e taki anga ageisi toli. ‘Bika anga opo opo ain den á wani si. Anga opo opo yesi, den á wani yee. Soseefi den á wani fusutan tu.’ ");
INSERT INTO djkNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Da fa den de ape, da ai waka anga den enke fa Jesaja a apaiti takiman fu Masaa Gadu be sikiifi a Masaa Gadu Buku. A be sikiifi taki: ‘U yesi e yee sani fu mi, ma u ná o fusutan dati. U ain e kai a sani fu mi, ma u ná o si dati. ");
INSERT INTO djkNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bika den sama ya taanga den ati. Den yesi á poi yee sani. Den ain tapu tu. Da den á poi daai den libi kon, fu mi kon deesi den.’ ");
INSERT INTO djkNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma seigi fu sama di ain kiin fu si sani. Soseefi seigi fu sama di yesi opo fu yee sani. ");
INSERT INTO djkNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Bika somen fositen apaiti takiman fu Masaa Gadu anga somen taa fositen letiopu sama, be angii seefi seefi, fu si den sani di u e si anga den sani di u e yee a goontapu fosi den dede. Ma toku, den á be si den.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Namo Masaa Jesesi taigi den taki: “We, mi o puu a toli, fu a sama di e tyatya sii paandi a ini a goon.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","A taigi den taki: “Te wan sama yee a toli fu a Nyun Tii fu Masaa Gadu, da efu a á fusutan a toli kiinkiin, da a ogii ati didibii e kon fufuu a bosikopu puu ne en ati ini. Da sowan sama ati de enke a sikin pasi, pe a sii be kai. ");
INSERT INTO djkNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma a siton doti pe a sii kai, na sama di yee a wowtu, ne a teke en anga gaan piisii na ati. ");
INSERT INTO djkNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma fa i si wan sani miti en fu a wowtu ede, da a nái oli go doo. Wanten ai fika a biibi, daai baka gi Masaa Gadu. Bika a wowtu fu Masaa Gadu á be doo na a dipi fu den ati. ");
INSERT INTO djkNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Da, a peesi pe a sii be kai na a maka ini, dati na a sama di yee a wowtu. Ma a abi booko fu dyendee libi anga pina a goontapu ya e meke a wowtu nái puu a wini di a be mu puu. ");
INSERT INTO djkNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma a bun doti pe a sii be kai, dati na wan sama di yee a wowtu, da a fusutan en kiinkiin. Ne a teke en kibii a ini en ati. Da son meke diitenti, taawan meke sigisitenti. Taawan baka libi e puu wan ondoo, toon fu san di be de.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Namo Masaa Jesesi gi den ete wan taa ageisi toli fu soi fa a Nyun Tii fu Masaa Gadu de. A taki: “A de leti enke wan basi di be teke wan sii fi en, go tyatya ne en goon. ");
INSERT INTO djkNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Namo di neti kon doo, ne wan takuu ati feyantiman fi en go saafi saafi a baka, ne enseefi tyatya wan takuu paansu sii a ini a goon fu a basi. ");
INSERT INTO djkNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ne den de te, a sii goo kon bigi meke nyanyan. Soseefi a takuu paansu sii seefi goo kon tu. ");
INSERT INTO djkNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ne den wookoman fu a basi go na a basi fu a goon, ne den akisi en taki: ‘Basi! A ná bunbun sii namo i be paandi na a goon, no? We, ne pe den tyaipi takuu sii de komoto, kon goo a den bunbun wan mindii so?’ ");
INSERT INTO djkNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“We, ne a basi piki den taki: ‘Oho! Na wan feyantiman fu mi namo i si du anga mi so.’ “Ne den man akisi en taki: ‘We, i wani meke u go puu den takuu uwii a den bun wan mindii?’ ");
INSERT INTO djkNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ma a basi piki den taki: ‘Nono! U á mu du dati! Bika fu u suku fu puu den nownow, u o misi puu den bun paansu wan a ini tu! ");
INSERT INTO djkNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Meke ala den goo kon makandii. Te den lepi fu koti, da mi sa meke den wookoman di e koti lepi sii, go koti den takuu paansu puu a ini den bun wan. Da den o tei den a bosu go gi faya. Ma den sa tyai den bun wan go kibii a magisin.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Namo Masaa Jesesi daai gi den ete wan toli, fu soi fa a Nyun Tii fu Masaa Gadu de. A taki: “A de leti enke a sii di den e kai mosite, di wan sama teke paandi ne en goon. ");
INSERT INTO djkNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Da enke fa u sabi, da mosite sii nyoni moo ala sii di i sa paandi a goon. Ma te a goo kon kaba, da ai bigi moo ala taa sowtu sani a ini a goon. Da ai toon wan bon di foo fu ondoo goontapu e kon meke nesi a den taka fi en, fu tan.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Namo Masaa Jesesi gi den ete wan ageisi toli baka taki: “A fasi fa a Nyun Tii fu Masaa Gadu de, da na leti enke wan uman di e masi bolon. A teke wan pikin sowda towe ne en. Da dati a pikin sowda ya e soopu a hii bolon te, a kon bigi bufuu.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Da na so Masaa Jesesi be gi den sama ala den ageisi toli ya. Da a á be e gi den ná wan toli, sondee fu wooko anga ageisi toli. ");
INSERT INTO djkNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na so a sani di a apaiti takiman fu Masaa Gadu be sikiifi fositen a Masaa Gadu Buku be kon pasa tuu. A be sikiifi taki: “Mi o taki anga den anga ageisi toli. Da sani di be kibii senten di Masaa Gadu be meke tapu anga goontapu, mi soi den, fu ala sama si.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Namo, di Masaa Jesesi kaba leli den sama den sani ya, ne a enseefi go a osu. Namo, ne den bakaman fi en kon ne en, ne den akisi en taki: “Masaa! Puu a ageisi toli, fu a takuu uwii a den bunbun wan mindii gi u, baa?” ");
INSERT INTO djkNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ne Masaa Jesesi piki den taki: “A bun! Mi sa puu en gi u. A sama di be e tyatya a sii, dati na a Manpikin di saka kon toon libisama ya. ");
INSERT INTO djkNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma a goon seefi dati na a hii goontapu pe u de ya. Da a bunbun sii na den sama di de a ini a Nyun Tii fu Masaa Gadu. Da den takuu sii dati na den sama di didibii e tii. ");
INSERT INTO djkNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Da a gaan feyantiman di i si tyatya den sii de, na a didibii seefi. Da a ten fu koti, dati na a kaba ten fu goontapu. Da den sama di o koti a nyanyan kibii a magisin, dati na den Basiya fu Masaa Gadu Kondee*f9*. ");
INSERT INTO djkNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“We, enke fa i si den sama be e koti den uwii tei a bosu fu gi faya de, na letiso sani a o waka, na a kaba yuu fu goontapu. ");
INSERT INTO djkNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","42","Bika a Manpikin di saka kon toon libisama ya, o sende den Basiya fi en a Masaa Gadu Kondee, go a goontapu, go piki ala sama di e du ogii, anga den di e leli taa sama fu du ogii. Da na so a o puu den a mindii fu den di de a ini a Nyun Tii fu Masaa Gadu, fu towe go a ini a sitaafu peesi pe soso kee anga tyali de. ");
INSERT INTO djkNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma den sama di be libi letiopu gi Masaa Gadu, sa beenki kiin kelle, a ini a Nyun Tii fu Masaa Gadu Kondee a tapu anda, enke fa ala sama e si a san te a opo. Da sama di abi yesi fu yee, meke a yee san mi taki de.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Namo, ne Masaa Jesesi teke ete wan toli leli den fu fa a Nyun Tii fu Masaa Gadu o de. A taki: “A de enke wan gaan gudu di de kibii kibii a wan ini pisi doti. Ne wan sama go si en. Ne a kibii en baka, ma a á piki ná wan sama. Ne a gwe anga gaan piisii ne en ati, ne a seli ala san a be abi a osu, ne a bai a pisi doti de, toon fi enseefi. ");
INSERT INTO djkNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Da soseefi a Nyun Tii fu Masaa Gadu de enke wan wenkiiman di e suku gaan dii dyamanti siton, fu bai seli baka. Ne ai waka e suku, te a go fende wan di waiti moo ala taawan. ");
INSERT INTO djkNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ne a go a osu, ne a seli ala san a be abi fiya, ne a teke ala a moni, ne a go bai a gaan dii dyamanti siton de.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ne Masaa Jesesi gi den ete wan toli. A taki: “A Nyun Tii fu Masaa Gadu de enke wan seepi di wan sama towe. Ne a kisi ala sowtu fisi. Den di bun fu nyan anga den di á bun fu nyan. ");
INSERT INTO djkNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ne di a seepi fuu, ne a man di be towe a seepi ali en kon a soo. Ne den go sidon, ne den e puu den bun wan teke poti a ini sani. Ma den e puu den poli wan fiingi towe. ");
INSERT INTO djkNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na so a o de na a kaba fu goontapu. Bika Masaa Gadu o sende den Basiya fi en a Masaa Gadu Kondee go piki den takuu ati sama, puu a mindii fu den bun ati wan di e libi letiopu fasi gi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Da den sa iti den takuu ati sama ya go ini a gaanbigi faya, pe den o de, e bali e kee gaan kee, e kaw tifi, fu tego.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","We, ne Masaa Jesesi akisi den taki: “Fa mi e taki anga u ya, u e fusutan mi?” Ne den piki taki: “Iya Masaa! U e fusutan yu!” ");
INSERT INTO djkNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ne Masaa Jesesi taigi den baka taki: “Da a bun, te wan sama e fusutan a toli di e taki, fu a Nyun Tii fu Masaa Gadu. Soseefi, efu makandii anga dati, da a sama sabi den weiti fu Mosesi bun tu, da a moo bun baka. Bika, da na tu koni fu Masaa Gadu kon miti na awan. Da na dobuu koni a sama de abi.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","We, di Masaa Jesesi gi den ala den toli ya, te a kaba, ne a komoto de. ");
INSERT INTO djkNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ne a gwe a Nasaleti, a foto pe a be kiya. Ne a go a den keliki anda, go leli sama sani fu Masaa Gadu. Ma ai foondoo den, fu si a fasi fa Masaa Jesesi e leli den. Ne den taki: “Ma, pe a fende a gaan koni anga a gaan kaakiti fu du den foondoo wooko de? ");
INSERT INTO djkNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bika, a ná a boi fu Jowsef, a tembeeman de ya, no? Na Maliya ne en mma. Den baala fi en na Jakopu anga Judasi anga Jowsef anga Simon. ");
INSERT INTO djkNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Den sisa fi en na wi anga den de ya. Da pe a go fende ala den sani de?” ");
INSERT INTO djkNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","We, na so den teke en fu ogii. Ma Masaa Jesesi piki den taki: “Na so a de tuu. Wan apaiti takiman fu Masaa Gadu sa fende lesipeki anga gafa na ala taa peesi fu goontapu, boiti en eigi kondee.” ");
INSERT INTO djkNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Namo Masaa Jesesi á du somen foondoo wooko a Nasaleti de. Bika den á be poti biibi ne en. ");
INSERT INTO djkNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","We, da a yuu ten de, da Kownu Helowdesi yee fu den gaan foondoo sani di Masaa Jesesi e du. ");
INSERT INTO djkNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ne a taigi den futuboi fi en taki: “Na Johanisi a Dopuman ne en e du den sani de. A opo komoto a dede kon a libi ya baka! A dati meke a abi a gaan kaakiti de, fu du ala den foondoo sani de.” ");
INSERT INTO djkNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","We, Helowdesi be teke a uman fu wan baala fi en, den e kai Filipi, enke uman. Na a uman den e kai Helowdiya. We, ne Johanisi be go bali en taki, a sani di a du de á bun. A poli Masaa Gadu weiti anga a uman fi en baala di a teke de. Na fu a sani ya meke, a sende sama go kisi Johanisi. Ne a meke den bwui en, ne den poti en a dunguu osu. ");
INSERT INTO djkNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kownu Helowdesi ati be boon te, a be sa kii Johanisi seefi. Ma toku, a be e feele fu du dati. Bika ala sama be e si Johanisi taki, en na wan apaiti takiman fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ma di den de te, ne Kownu Helowdesi fuuyali. Ma namo, da a uman di a be teke, be abi wan umanpikin. Ne a umanpikin fu Helowdiya ya dansi na a fuuyali, a fesi fu ala den bigi bigiman. We, a dansi ya switi gi Kownu Helowdesi te, ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Namo Helowdesi kai a umanpikin ya kon. Ne a sweli gi a pikin, a fesi fu ala den bigiman di de ape taki: “Pikin! Wansi san yu akisi mi, mi sa gi yu en.” ");
INSERT INTO djkNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","We, di kownu taki so, ne a pikin umanpikin lon go, ne en mma. Ne a taigi en taki, na so anga so, kownu paamisi en. Da san a mu du. We, ne a mma taigi en taki: “Go taigi kownu taki, i wani a ede fu Johanisi a Dopuman a wan teepala tapu.” Na so a pikin umanpikin lon go, ne a taigi kownu taki: “Kownu! Gi mi a ede fu Johanisi a Dopuman a wan teepala tapu.” ");
INSERT INTO djkNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","We, di Kownu Helowdesi yee so, ne a buduufu en te, a á sabi pe fu poti enseefi. Ma a gaan sweli di a be sweli a lanti fesi meke a á be poi kengi mofu moo. Ne wanten, ne a sende sama go a dunguu osu go doo Johanisi ede felen. ");
INSERT INTO djkNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ne den poti a koti ede a wan teepala tapu, tyai kon gi a pikin. Ne a pikin ya teke en, ne a tyai go gi en mma, Helowdiya. ");
INSERT INTO djkNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ne den bakaman fu Johanisi kon teke a dede sikin, ne den beli. Bakadati, ne den go piki Masaa Jesesi taki, na so wan sani pasa. ");
INSERT INTO djkNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","We, di Masaa Jesesi yee san pasa, ne a komoto de. Ne a teke boto koti abaa go a wan peesi, en wawan kodo. Ma di den sama fu kondee anda yee pe a go, ne den booko gwullu waka lontu a soo go ne en baka. ");
INSERT INTO djkNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Fa i si Masaa Jesesi saka komoto a soo, tyaipi sama de a soo anda kaba, e luku en. Namo, tyali kisi Masaa Jesesi fu den somen sama. Ne a deesi ala den sikiman, kon bun de baka silli. ");
INSERT INTO djkNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Da di bakadina, neti mofu, ne den bakaman fu Masaa Jesesi kon ne en. Ne den taigi en taki: “Masaa! Ai lati kaba! A ini wan sabana ini u de. Da sende den sama gwe, meke den go a den pikin kondee, go suku sani bai fu nyan.” ");
INSERT INTO djkNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ma Masaa Jesesi piki den taki: “Nono! A á de fu den gwe! U gi den sani fu den nyan.” ");
INSERT INTO djkNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","We, ne den bakaman piki taki: “Da fa u o du? Bika na feifi beele anga tu losi fisi namo wi abi ya.” ");
INSERT INTO djkNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Namo Masaa Jesesi piki den taki: “U tyai den kon gi mi ya.” ");
INSERT INTO djkNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ne a sende ala den sama go sidon a gaasi tapu. Ne a teke den feifi beele anga den tu fisi, ne a opo ede luku tapu, ne a gi Masaa Gadu daa, te a kaba. Ne a booko den feifi beele anga den tu fisi pisipisi gi den bakaman, fu den go paati. Ne den bakaman gi den sama. ");
INSERT INTO djkNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ne ala den sama nyan, te den bee fuu. Ma toku beele anga fisi fika ete. Ne di den bakaman piki den pisi beele anga fisi di fika, ne a fuu twalufu bakisi ete. ");
INSERT INTO djkNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Da fu den sama di be nyan a beele, a be sa de wan sani fu feifi dunsu manengee, boiti den uman anga den pikinengee di be nyan. ");
INSERT INTO djkNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ne wanten bakadati, ne Masaa Jesesi taigi den bakaman fi en, fu go a boto abaa gwe na abaase. Ma en o fika de, fu sende den sama gwe a den osu. ");
INSERT INTO djkNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ne di a sende ala den sama gwe kaba, ne a subi go a wan mongo tapu, go e begi, en wawan kodo. A yuu ten de, da peesi be kon e dunguu kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma, den bakaman fi en be de, te a mindii wataa kaba anga a boto. Di den go te wan pisi, ne wan gaan winta anga seke wataa e baasi a boto fu den. ");
INSERT INTO djkNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Namo di musude, ne Masaa Jesesi waka anga futu na a wataa tapu kon a den. ");
INSERT INTO djkNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma namo, di den si Masaa Jesesi e waka na a wataa tapu e kon, ne den dyombo te, den taki, na wan yooka e kon a den. Ne den feele te, den bali gaan bali. ");
INSERT INTO djkNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","We, ne Masaa Jesesi bali piki den wanten taki: “U á feele! Na mi de ya! U oli deki ati!” ");
INSERT INTO djkNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Namo Peitilisi piki taki: “Masaa! Na yu de ape tuu? We, efu na yu de ape tuu, da kai mi, meke mi waka na a wataa tapu kon a yu, osi?” ");
INSERT INTO djkNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Namo ne Masaa Jesesi piki en taki: “Kon!” Ne Peitilisi komoto a ini a boto, ne ai waka na a tapu wataa go a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma di a si fa a winta e wai taanga, ne a feele. Ne ai bigin saka seefi go a ondoo wataa. Ne a bali taki: “Masaa! Yeepi mi oo!” ");
INSERT INTO djkNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ne wanten, ne Masaa Jesesi langa ana oli en. Ne a taigi en taki: “Saide meke i pantan so? Saide meke yu á tan poti biibi a mi doo?” ");
INSERT INTO djkNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ne di den subi go a ini a sipi, ne wanten a gaan winta koo pii. ");
INSERT INTO djkNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ne den sama di be de a ini a boto saka kini a doti ne en fesi de. Ne den taki: “Fu tuu! Yu na a Pikin fu Masaa Gadu tuu.” ");
INSERT INTO djkNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ne den go doo Genesaleti, a kondee di den e go. ");
INSERT INTO djkNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","We, ne den sama fu a kondee be sabi wanten taki, na Masaa Jesesi doo de. Ne den sende bosikopu lontu a hii kondee taki, Masaa Jesesi kon a den de. Ne den tyai ala sowtu siki man kon ne en. ");
INSERT INTO djkNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ne den begi en taki: “Gaantangi! Meke den sikiman fu wi lobi ana a yu koosi namo, baa?” Ne Masaa Jesesi gi den fu den du dati. Namo, ala sikiman di lobi ana ne en koosi mofu, kon bun kele kele fu ibii sowtu siki di den be abi. ");
INSERT INTO djkNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","We ne, a seefi yuu de, ne wan duupu Faliseiman sama anga wan duupu leliman fu Dyuweiti komoto te a Jelusalem Foto, kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Ne den akisi en taki: “Saide den bakaman fi yu mu e du sani di wi avo á be gwenti? Bika den e nyan sondee wasi ana enke fa avo fu u be poti gi.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Namo Masaa Jesesi piki den taki: “U dati e feti fu wai a leli fu Masaa Gadu poti a wanse, soso fu oli den avo gwenti. Saide? ");
INSERT INTO djkNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bika Masaa Gadu weiti taki: ‘I mu lesipeki i mma anga i dda.’ Da ‘ibiiwan sama di saanti en dda ofu en mma mu dede.’ ");
INSERT INTO djkNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ma u dati taki, wan sama sa taigi en mma anga en dda taki: ‘A sani di a be mu teke fu yeepi den, da a moo betee a gi Masaa Gadu dati enke paiman.’ ");
INSERT INTO djkNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Da a sa fika en mma anga en dda a wanse, sondee fu solugu. Da anga ala den gwenti di den gaansama fika gi u, u e wai Masaa Gadu weiti poti a wanse. ");
INSERT INTO djkNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","U bidiigiman! Na fu sama enke u ede meke Masaa Gadu be gi a apaiti takiman fi en, den e kai Jesaja, fu sikiifi wan sani a fositen. ");
INSERT INTO djkNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Bika a be sikiifi taki: ‘Den sama ya e gafa mi anga den buba mofu, ma den ati de faawe fu mi! ");
INSERT INTO djkNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Da fa den e meke enke den e begi mi de, ma, na soso sani den e du. Bika den nái leli sama Masaa Gadu weiti, ma na libisama sani den e leli sama.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","We, ne Masaa Jesesi kai ala den sama di be de ape kon ne en. Ne a taigi den taki: “U aliki! U mu fusutan mi bun. ");
INSERT INTO djkNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ná den sani di yu e nyan e meke i tyobo a Masaa Gadu ain. Ma na den sani di i e taki anga i mofu. Na den e meke i tyobo a Masaa Gadu ain.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","We, di Masaa Jesesi taki so, ne den bakaman fi en kon taigi en taki: “Masaa! Fa i si i taki de, ná sipowtu boon den Faliseiman ati boon a yu moo.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","We, ne Masaa Jesesi piki den taki: “U fika den! Bika den á de fu Masaa Gadu. Da ibiiwan sani di á de san mi Tata paandi, da na fu hali puu. ");
INSERT INTO djkNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","U fika den! Bika den sowtu sama de beendi. Da efu wan beendiman e suku fu tyai beendiman abaa gotoo, da na ala den fiya o kai a ini a gotoo?” ");
INSERT INTO djkNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Namo Peitilisi akisi en taki: “Masaa! San na a mama fu a toli di i taki dyonson fu den Faliseiman sama de? I sa puu en fini fini gi wi?” ");
INSERT INTO djkNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ne a piki den taki: “Oho! Useefi nái fusutan mi kiinkiin ete, no? ");
INSERT INTO djkNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Useefi á sabi ete taki, a sani di wan sama e nyan, e go ne en bee. Da te wan pisi, da a kon komoto baka, no? We, kweti! Dati á poi meke i tyobo a Masaa Gadu ain. ");
INSERT INTO djkNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ma na den sani di yu e puu a ini i mofu. Bika, na te a ini ati den sani ape de. Da, den e kon komoto a doo, da den e meke i tyobo a Masaa Gadu ain. ");
INSERT INTO djkNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bika a ini wan sama ati ini ala ogii e komoto. Sani enke kii sama. Waka anga taa uman ofu man. Soseefi motyo libi anga lei. Fufuu seefi tu. Taki ogii fu Masaa Gadu anga poli taawan nen seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Da na den sowtu sani ya e kon komoto a doo, fu meke a sama tyobo a Masaa Gadu ain. Ma fu nyan sondee wasi ana enke fa weiti taki, dati á poi meke wan sama tyobo a Masaa Gadu ain.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ne Masaa Jesesi anga den bakaman fi en komoto na a kondee de, ne den go na a pisiwataa fu Tilosi anga Sidon. ");
INSERT INTO djkNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","We, ne fa i si den go doo de, ne wan uman lon kon a Masaa Jesesi. A uman ya na be fu a kondee den kai Kaana. A ná be Dyusama. Namo ai bali taki: “Masaa! Na yu na a Bakaten Manpikin fu Kownu Dafeti paansu. Gaantangi abi tyali ati fu mi, baa? Bika wan takuu jeje de na a umanpikin fu mi tapu, e pina en, e tyotyo en.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ma anga ala fa a uman e begi de, toku Masaa Jesesi á piki en seefi seefi. Namo den bakaman fu Masaa Jesesi taigi en taki: “Masaa! Gaantangi, bali a uman de, meke a kaba a u baka. Senten, ne ai waka a u baka e muliki wi.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","We, ne na nowfosi Masaa Jesesi o piki a uman taki: “Uman! Masaa Gadu á sende mi, fu mi go a taa foluku, moo enke den lasi sikapu fu Islayeli Kondee.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ma toku, a uman kon kai ne en fesi, sutu kini a doti, e begi taki: “Masaa! Gaantangi, ma yeepi mi.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma Masaa Jesesi piki a uman taki: “A á fiti fu mi puu beele a den pikin ana towe gi den dagu.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Namo a uman piki taki: “Masaa! Na so a de tuu! Ma wan pikin dagu seefi á sa abi pasi, fu kon piki den sakasaka di e kai komoto na a tafaa kon a doti, no?” ");
INSERT INTO djkNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Namo Masaa Jesesi piki en taki: “Uman! Yu e biibi mi taanga! Da a sani di i si yu e suku de, i fende en kaba.” Masaa Jesesi á kaba taki seefi, namo a umanpikin fu a uman kon bun kelle. ");
INSERT INTO djkNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","We, ne Masaa Jesesi komoto de. Ne a go koosube fu a ze fu Galileya. Ne a go a wan mongo tapu go sidon. ");
INSERT INTO djkNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ne tyaipi sama kon ape ne en. Den tyai lanman, beendiman, masimasi wan, babawman kon ne en. Ne den poti den ne en futu. Namo a deesi ala den fiya. ");
INSERT INTO djkNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma, da den sama foondoo seefi, di den si fa den babawman e taki. Den lanman e waka. Den masimasi wan kon bun. Den beendiman e si. Da den sama foondoo tuutuu. Ne den gafa Masaa Gadu, a Gadu fu Islayeli Kondee. ");
INSERT INTO djkNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ne Masaa Jesesi kai den bakaman fi en, ne a taigi den taki: “Tyali e kisi mi fu den tyaipi sama ya! Bika tide, na di fu dii dei di den de anga mi ya, sondee nyan. Da mi á wani sende den gwe a osu anga angii bee so. Bika falan falan sa kisi den a pasi.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Namo den bakaman piki taki: “Masaa! Pe wi o poi fende sani gi den somen sama ya, fu den nyan? Bika luku ya! Nyanyan á de na a sabana ini pe u de ya, fu gi den.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Masaa Jesesi akisi den taki: “Onmen beele u abi de?” Namo den piki en taki: “Na seibin beele anga wantu losi fisi namo u abi ya.” ");
INSERT INTO djkNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","We, ne Masaa Jesesi sende ala den sama go sidon a doti. ");
INSERT INTO djkNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne a teke den seibin beele anga den fisi. Ne a gi Masaa Gadu daa, te a kaba. Ne a booko den beele anga den fisi pisipisi, gi den bakaman, fu go paati gi den somen sama. ");
INSERT INTO djkNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ne den bakaman fi en teke, ne den paati gi den somen sama te doo. Ne ala den sama nyan te den bee fuu. Ne den bakaman fi en piki den pisipisi beele di fika, te seibin gaan bakisi fuu kwaa. ");
INSERT INTO djkNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Da ala den sama di be nyan, da a be sa de wan sani fu fo dunsu manengee, boiti den uman anga den pikinengee di be nyan. ");
INSERT INTO djkNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","We, ne di Masaa Jesesi sende ala den sama gwe, ne a go a ini wan boto, ne a abaa go na a pisiwataa fu Magadan. ");
INSERT INTO djkNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","We, ne wan dei, ne den Faliseiman anga den Saduseiman kon ne en. Den kon fu tesi en luku, efu na Masaa Gadu sende en kon tuutuu. Ne den akisi en fu a meke foondoo sani pasa a tapu anda, osi? Da den sa si taki, Masaa Gadu de anga en tuutuu. ");
INSERT INTO djkNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma Masaa Jesesi piki den taki: “Ai baya! Bakadina mofu te tapu lebi, da u sabi taki, tamaa san o hati. ");
INSERT INTO djkNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Te mamanten u si a san lebi, da u sabi taki alen o kai tide. We, fa a waka u sabi luku den maiki di tapu e soi, ma u á sabi luku den maiki fu a yuu ten di u e libi nownow? ");
INSERT INTO djkNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","U takuu ati sama u! U tan enke uman di fika den man go e waka anga taa man! Na dati meke u e suku fu si foondoo maiki a tapu fosi. Ma kweti! Mi ná o soi u ná wan taa maiki moo enke a maiki fu a apaiti takiman fu Masaa Gadu di den e kai Jowna.” Di Masaa Jesesi kaba taki so, ne a komoto a den mindii gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","We, ne Masaa Jesesi anga den bakaman fi en go a boto. Ne den koti go na abaase. Ma den bakaman be feegete fu tyai beele. ");
INSERT INTO djkNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Namo Masaa Jesesi wasikoi den taki: “U luku bun anga a sowda fu den Faliseiman sama anga den Saduseiman.” ");
INSERT INTO djkNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Namo di Masaa Jesesi taki so, ne den bakaman fi en pakisei go, den pakisei kon. Ne den e taki den na den taki: “Kande, na di u feegete fu tyai a beele meke a taki so?” ");
INSERT INTO djkNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma Masaa Jesesi sabi taki na so den e denki. Ne a piki den taki: “Saide meke a biibi di u abi a mi nyoni so? Fa u sa denki taki, na beele toli mi e taki? ");
INSERT INTO djkNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","U nái fusutan mi ete, no? U feegete di mi be teke feifi beele gi feifi dunsu sama nyan, te den bee be fuu? Te onmen tenti bakisi be fika a tapu ete! ");
INSERT INTO djkNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Soseefi, u be de ape si, fa mi be booko seibin beele paati gi fo dunsu sama. Ma toku, a be sai den, te onmen tenti bakisi be fika a tapu tu. ");
INSERT INTO djkNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","We, da fa a kan taki, u á poi fusutan taki a ná beele mi e taki? U luku bun anga sowda fu den Faliseiman anga den Saduseisama!” ");
INSERT INTO djkNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","We, di Masaa Jesesi taki so fosi, ne den bakaman fi en fusutan kiinkiin taki, a ná a sowda fu baka beele ai taki. Ma na a poli leli fu den Faliseiman anga den Saduseiman. ");
INSERT INTO djkNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Namo di den de na a pisiwataa fu Sesaleya Filipi, ne Masaa Jesesi akisi den bakaman fi en taki: “Fa den sama e kai a Manpikin di saka kon toon libisama ya?” ");
INSERT INTO djkNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ne den bakaman piki en taki: “We, u yee son sama e taki, yu na Johanisi a Dopuman. Ne en weki baka komoto a dede. Taawan e taki, yu na Eliya, a apaiti takiman fu Masaa Gadu a fositen. Taawan e taki, yu na Jelemija ofu wan fu den taa apaiti takiman fu Masaa Gadu. Ne en weki a dede kon a libi ya baka.” ");
INSERT INTO djkNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ne Masaa Jesesi akisi den taki: “Ma u, no? Sama u e taki a mi?” ");
INSERT INTO djkNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","We, ne Simon Peitilisi piki en taki: “Yu na a Kelestesi, a Manpikin fu a libilibi Masaa Gadu!” ");
INSERT INTO djkNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","We, ne Masaa Jesesi piki en baka taki: “Seigi fi yu Simon, manpikin fu Jowna! Bika a ná libisama meke i sabi a sani de. Ma na mi Tata a tapu anda, ne puu en kon a kiin gi yu. ");
INSERT INTO djkNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","We, fu tuutuu! Mi e taigi yu taki, yu na Peitilisi*f10*. We, na a gaanbigi taanga siton tapu ya mi o meke a keliki fu mi. Da a didibii anga ala a taanga di a abi anga hii dedekondee*f11* seefi ná o poi wini a keliki fu mi. ");
INSERT INTO djkNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Da mi e gi yu a sooto, fu a Nyun Tii fu Masaa Gadu. Da san i tei a goontapu ya, da a o de teitei a Masaa Gadu, a tapu anda tu. Soseefi san i losi a goontapu ya, da a o de losilosi a Masaa Gadu, a tapu anda.” ");
INSERT INTO djkNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","We, ne di a taki so, ne a bali den bakaman fi en taki, den á mu taigi sama taki, en na a Kelestesi. ");
INSERT INTO djkNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ne fanafu a ten de, ne Masaa Jesesi e soi den bakaman fi en san o kon miti en. Ai taigi den, fa a mu go a Jelusalem Foto, da den gaansama fu Dyu keliki anga den apaiti begiman anga den leliman fu weiti o kisi en tyai en go kii a koloisi. Ma baka dii dei, da a o weki baka komoto a dede. ");
INSERT INTO djkNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma di Masaa Jesesi taki so, ne Peitilisi tyai en go a wan, bali taki: “Masaa! Ná taki den sani de. Bika den ná o poi pasa anga yu, kweti kweti!” ");
INSERT INTO djkNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma Masaa Jesesi daai luku Peitilisi. Ne a kaasi en taki: “Pasa komoto a mi baka ya! Yu didibii, saatan yu! Yu de enke wan siton a mi pasi, fu mi naki futu kai na a pasi fu Masaa Gadu. Peitilisi! A sani di i taki de, á de enke fa Masaa Gadu e pakisei. I taki enke fa libisama e pakisei.” ");
INSERT INTO djkNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Namo Masaa Jesesi daai taki anga ala den bakaman fi en. A taki: “Efu wan sama wani waka a mi baka, da a á mu teli enseefi moo. Da a mu e tyai a sitaafu di o kon ne en tapu, enke wan sama e tyai wan koloisi, fu den go sipikii en kii. ");
INSERT INTO djkNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bika na sama di kaba libi a libi enke fa enseefi wani fu mi ede, sa fende a libi di Masaa Gadu wani gi. Ma sama di o libi go doo enke fa enseefi wani, da a o lasi a hii libi fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma sowtu wini a abi efu wan sama abi ala gudu fu goontapu, ma a lasi go kai a didibii faya? Bika sani seefi á de a goontapu ya, di waiti sai fu kengi anga a libi fu tego? ");
INSERT INTO djkNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bika, te a Manpikin di saka kon toon libisama ya o kon makandii anga den Masaa Gadu Kondee Basiya*f12* fi en, da hii dyendee anga makiti di en Tata, Masaa Gadu a tapu abi o de fi en. Da a o kuutu fa, ibii sama du san a taki. Da ibiiwan o fende paiman, fu fa a be libi a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Da mi e taigi u tuutuu taki: Somen fu u di taampu ya ná o tesi dede, fosi u si a Nyun Tii fu a Manpikin di saka kon toon libisama ya.” ");
INSERT INTO djkNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Namo sigisi dei a baka, ne Masaa Jesesi teke Peitilisi anga Jakowbesi anga Johanisi tyai anga en go, te a wan hei mongo. ");
INSERT INTO djkNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma wanboo wanboo so, te fu den denki, ne Jesesi kengi tan wan hii taa fasi. En fesi e beenki enke a san. Da den koosi di a wei weti kiin enke wan gaan kiin faya. ");
INSERT INTO djkNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ne fosi den poti pakisei baka, ne tu man kon taampu ne en se, e taki anga en. Den tu man ya na Mosesi anga Eliya. ");
INSERT INTO djkNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Namo Peitilisi taigi Masaa taki: “Masaa! Efi i wani, mi sa meke dii masanga ya. Wan fi yu, wan fu Mosesi anga wan fu Eliya. Bika a switi fu toko, fa u de makandii ya!” ");
INSERT INTO djkNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peitilisi á kaba taki seefi! Ne wan weti kiin woluku saka kon a den tapu. Ne den yee wan Tongo a ini a woluku taki: “U luku a lobi Manpikin fu mi de. Mi e piisii anga en. Da ne en u mu poti yesi aliki, fu du san ai taki.” ");
INSERT INTO djkNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","We, ne di den dii bakaman fu Masaa Jesesi yee a Tongo ya, ne den feele te, den kai tapu fesi a doti. ");
INSERT INTO djkNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma Masaa Jesesi waka go, ne a oli den taki: “U opo! U á feele so!” ");
INSERT INTO djkNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ne di den luku, ne den á si ná wan sama moo enke Masaa Jesesi wawan. ");
INSERT INTO djkNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","We, ne di den e saka a mongo baka, ne Masaa Jesesi bali den taki: “I si a sani di u si na a mongo tapu de, u á mu taigi ná wan sama, ye! Na te a Manpikin di saka kon toon libisama ya dede weki baka fosi, da u sa taki en.” ");
INSERT INTO djkNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Namo den dii bakaman fu Masaa Jesesi akisi en taki: “Masaa! Ma fa a waka den leliman fu weiti e leli sama taki, Eliya fosi mu kon a goontapu, fosi, da a Kelestesi sa kon?” ");
INSERT INTO djkNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","We, ne Masaa Jesesi piki den taki: “We, Eliya mu waka a fesi fu a Kelestesi kon tuu, fu seeka pasi gi en a fesi. ");
INSERT INTO djkNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma fu tuu, mi e taigi u taki, Eliya kon kaba. Ma den á be wani sabi en. Ne den du ogii anga en, enke fa den wani. Na soseefi den o du anga a Manpikin di saka kon toon libisama ya tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","We, na di Masaa Jesesi taki so, fosi den bakaman fi en kon kisi kiin taki, na Johanisi a Dopuman a be e taki na a Eliya di be mu kon kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Namo di den doo na ala den taa sama, ne wan sama kon a Masaa Jesesi. Ne a kai ne en futu a doti. ");
INSERT INTO djkNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ne ai begi en taki: “Masaa! Gaantangi, abi tyali ati fu wan manpikin fu mi, baa? Pikinengee siki kisi en ogii ogii. Na somen leisi kaba, a siki ya e naki en towe a ini faya. Soseefi ai naki en iti a wataa. ");
INSERT INTO djkNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi be tyai en kon a den bakaman fi yu, fu den deesi, ma den á poi deesi en.” ");
INSERT INTO djkNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Namo Masaa Jesesi piki en taki: “Oho! San mi miti anga den sowtu sama ya? Den nái biibi sai! Taanga yesi namo di den abi so. On langa mi mu de anga u ya, fu oli pasensi ete, fosi u o biibi?” Ne a taigi a man taki: “Tyai a pikin kon gi mi!” ");
INSERT INTO djkNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","We, ne den tyai a pikin kon gi en. Ne a yaki a jeje, di be de na a pikin tapu de puu. Ne wanten, ne a pikin kon bun baka. ");
INSERT INTO djkNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ne moo lati, ne den bakaman fi en kon ne en bakabaka. Ne den akisi en taki: “Fa a waka, wi dati á be poi puu a takuu jeje na a pikin tapu?” ");
INSERT INTO djkNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Namo Masaa Jesesi piki den taki: “Na fu di u ná abi biibi sai! Bika mi e taigi u taki, efu u abi wan pikintoin biibi namo, enke a sii den e kai mosite, da u sa taigi wan gaan mongo taki komoto de. Da a sa wai komoto de tuu. Da ná wan sani o de, di u ná o poi du. ");
INSERT INTO djkNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ma yu á poi puu den sowtu takuu jeje wan taa fasi, moo enke fu tan sondee nyan e begi Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","We, wan taa leisi, ne Masaa Jesesi anga den bakaman fi en kon makandii a Galileya de. Ne a taigi den taki: “Wan ten e kon di den o kisi a Manpikin di saka kon toon libisama ya poti a den ogii sama ana. ");
INSERT INTO djkNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Da den o kii en. Ma baka dii dei, da a o opo baka komoto a dede. We, di den bakaman fi en yee so, ne gaan tyali kisi den.” ");
INSERT INTO djkNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Namo den Masaa Jesesi kon doo Kafalnayemu Foto. Ne wan duupu sama di e piki lantimoni a Dyu Kondee, go a Peitilisi. Ne den akisi en taki: “A mesiti fi yu nái pai lantimoni, no?” ");
INSERT INTO djkNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Namo Peitilisi piki den taki: “Hoo! Ai pai, ai!” Namo fa i si Peitilisi doo osu, fosi a opo mofu, ne Masaa Jesesi akisi en taki: “Simon! Fa den kownu fu goontapu ya e piki lantimoni de, on sama den e piki en? Na pikin fu doti a Dyu Kondee ya ofu na den doose kondee sama, di kon tan a Dyu Kondee?” ");
INSERT INTO djkNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ne Peitilisi piki en taki: “We! Na den doose kondee sama di kon tan a Dyu Kondee ya.” We, ne Masaa Jesesi taigi en taki: “So! Da wi enke pikin fu doti de fii fu dati. A á de fu wi pai! ");
INSERT INTO djkNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma toku, wi á wani meke den kosi wi fu dati ede. I sabi san? Teke yu uku go uku na a ze. Da a fosi fisi di yu o kisi, da opo en mofu luku. Da yu o si wan moni a ini en mofu. Da teke en tyai go pai a lantimoni fu mi anga yu.” ");
INSERT INTO djkNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","We, na a seefi yuu ya, ne den bakaman fu Masaa Jesesi kon ne en. Ne den akisi en taki: “Masaa! Fu den di de a ini a Nyun Tii fu Masaa Gadu, da on di o de a moo heiwan a ini?” ");
INSERT INTO djkNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","We, ne Masaa Jesesi kai wan pikin kon ne en. Ne a meke a taampu a den mindii de. ");
INSERT INTO djkNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ne a taki: “I si a pikin ya? Fu tuu! Efu yu á daai kon abi a fasi di wan pikin abi, da yu á poi doo a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ma efi i abi saka fasi enke a pikin ya, da yu o abi wan gaan hei peesi a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Sama di du wan bun gi wan pikin enke di i si taampu ya, fu di a de sama fu mi, da na miseefi a du a bun de kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ma sama di sa du ogii anga sowan saka fasi sama mu luku bun! Sani ná o waka bun gi en. A sitaafu di Masaa Gadu o gi en sa bigi. A be sa moo betee, den be tei wan gaanbigi siton ne en neki, da den tyai en go towe na a moo dipi peesi fu a ze, meke a dede. ");
INSERT INTO djkNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ma heelu fu a goontapu ya, fu den sani di e tesi sama a Masaa Gadu pasi! Na tuu taki, na so goontapu de. Ma heelu fu den sama di e du sani, fu tyai taawan go a ini tesi! ");
INSERT INTO djkNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Da efu yu wani du ogii anga yu ana ofu yu futu, fu komoto a Masaa Gadu pasi fu Masaa Gadu, da a moo bun i koti a ana ofu a futu towe puu a i sikin. Bika a moo bun fu lasi wan pisi fi i sikin, ma i fende a libi fu tego. Moo enke den iti yu hiihii go a ini didibii faya di e boon tego. ");
INSERT INTO djkNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Soseefi tu, efu yu ain wani luku sani di o puu yu a Masaa Gadu pasi, da a moo bun, i diki en puu towe. Bika a moo bun fi i lasi wan pisi fi i sikin, ma i fende a libi fu tego, moo enke i de anga i tu bunbun ain, ma den iti yu go a ini didibii faya go boon. ");
INSERT INTO djkNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Fu tuu, mi e taigi u! U mu luku bun, fa u e libi anga den pikinengee, enke di i si taampu ya. U á mu si den enke soso sani. Bika den Masaa Gadu Kondee Basiya*f13* fu mi Tata a tapu anda, di de ne en fesi ala yuu, e oli waki fu kibii den. ");
INSERT INTO djkNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Bika, a Manpikin di saka kon toon libisama ya, kon, fu suku ala sama di lasi Masaa Gadu pasi, tyai kon poti a Masaa Gadu pasi baka, fu den fende libi.” ");
INSERT INTO djkNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","We, ne Masaa Jesesi gi den wan ageisi toli taki: “Fa i denki fu wan sama di abi wan ondoo sikapu? Kon u taki, wan fu den komoto a den taawan mindii go lasi. Da san i denki? A masaa fi en o fika den neigintenti a neigin taawan a pe den de e nyan na a sabana, da a go suku a lasi wan, te enke a fende en? ");
INSERT INTO djkNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Da fu tuu, mi e taigi u! Te a o fende a wankodo di be lasi baka, a o poolo anga en, moo den neigintenti a neigin taawan di á be lasi. ");
INSERT INTO djkNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","We, na soseefi u Tata, a tapu anda tan tu. Bika a á wani ná wan fu den pikin ya mu go lasi.” ");
INSERT INTO djkNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Namo Masaa Jesesi taki go doo taki: “Efi i baala du wan sani anga yu di á bun, da yu wawan go taki anga en fosi. Da efu a yee san i taki, ne a begi paadon, da i wini en tyai kon poti a pasi kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma efu a á wani yee yu, da kai wan ofu tu sama moo, da u go taki anga en baka. Da dati o kai anga a weiti di taki, moo enke wan kotoigi mu de, fu tyai wan toli go a kuutu fesi, fu lanti sa piki taki, na so a de tuu. ");
INSERT INTO djkNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Da efu a á wani yee u, da u mu tyai a toli go a keliki fesi, a den taa biibiwan. Da efu toku, a sama ya á wani yee a keliki tu, da u mu fika en. Da u oli en enke sama di á sabi Masaa Gadu. Wan sama di de a ini takuudu anga ogii. ");
INSERT INTO djkNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Da fu tuu, mi e taigi u: San di u tei a goontapu, sa tei a Masaa Gadu Kondee. San di u losi a goontapu ya sa losi a Masaa Gadu Kondee tu. ");
INSERT INTO djkNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Fu tuutuu, mi e taigi u: Efu tu fu u tei ati kon awan, fu begi mi Tata a tapu wan sani, mi Tata a tapu o gi u en. ");
INSERT INTO djkNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bika pe tu doo dii sama de makandii a ini mi nen, da mi seefi de leti a den mindii de tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Namo Peitilisi waka kon a Masaa Jesesi, ne a akisi en taki: “Masaa! Onmen leisi mi mu gi wan taawan, di du wan sani anga mi, paadon? Efu mi gi en paadon seibin leisi, a á sai, no?” ");
INSERT INTO djkNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Namo Masaa Jesesi piki en taki: “Seibin toon namo á sai, Peitilisi! Ma seibintenti toon fu seibin, i mu gi taawan paadon.” ");
INSERT INTO djkNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ne Masaa Jesesi gi den wan ageisi toli, da a taki: “A Nyun Tii fu Masaa Gadu de leti enke wan kownu di abi somen wookoman, di mu pai en. ");
INSERT INTO djkNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Da wan dei, ne a kownu wegi ala den paiman di den mu pai en go, a wegi den kon. Namo a kai wan fu den ondooman fi en, di abi fu pai en onmen tenti miliyun. ");
INSERT INTO djkNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma namo, da a man ya á be poi pai a kownu. Ne a kownu taki: ‘U seli en, anga en uman anga en pikin anga ala san a abi, da u tyai a moni kon gi mi. Da mi sa fende mi moni baka.’ ");
INSERT INTO djkNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“We, ne a wookoman kai anga kini na a kownu fesi, ne a begi en taki: ‘Kee! Masaa, i abi leti! Gaantangi! Oli pasensi gi mi? Mi sa pai yu!’ ");
INSERT INTO djkNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Namo di a wookoman begi so, ne tyali kisi a masaa taki, meke a gwe fi en. A á de fu a pai en a paiman moo. ");
INSERT INTO djkNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Da na gwe tapu a man ya de ete! Namo a miti wan taa ondooman fu a seefi kownu a pasi. A man de be mu pai wan sani fu feifi dunsu kolu so. Namo, a dyombo kisi en hub oli taki: ‘Pai mi! Pai mi wanten! Wanten wanten, nownow ya!’ ");
INSERT INTO djkNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","We, ne a taa ondooman kai anga kini a doti begi en taki: ‘Gaantangi! Oli pasensi gi mi baa, te mi fende a moni, mi sa pai yu baka.’ ");
INSERT INTO djkNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ma a á wani. Ma so a meke den kisi a man ya poti a dunguu osu taki, meke a tan ape, fu te enke a kaba pai en a hiihii paiman! ");
INSERT INTO djkNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ma di den taa wookoman fu a masaa si ala san pasa, ne a buduufu den te, ne den lon go taigi den masaa ala san pasa. ");
INSERT INTO djkNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","We, ne a masaa kai a wookoman kon ne en baka. Ne a taigi en taki: ‘Yu takuu ati sani yu! A hiihii gaan moni di i be abi fu pai mi, ne mi fika yu, fu di i be begi mi. ");
INSERT INTO djkNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Da saide meke yu á teke tyali ati luku a taa wookoman fu mi, enke fa mi be teke tyali ati wooko anga yu?’ ");
INSERT INTO djkNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","We, a masaa ati boon tee, ne a kai sikowtu kon kisi en tyai go a ini sitaafu osu. Meke a tyai pina anga sitaafu, fu te enke a pai en a lasiti kopoo sensi.” ");
INSERT INTO djkNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ne Masaa Jesesi taigi den taki: “We, na soseefi mi Tata sa du anga ibiiwan fu u, efu u nái gi taawan paadon anga u hii ati.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","We, baka di Masaa Jesesi taki den wowtu ya, ne a komoto a Galileya, koti abaa a Joodani Liba, gwe na a pisiwataa fu Judeja. ");
INSERT INTO djkNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma namo, di a doo, ne tyaipi sama booko kon ne en, kon e waka ne en baka. Ne a deesi den sikiman ape. ");
INSERT INTO djkNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma den Faliseiman seefi kon ne en de tu, fu tesi en meke a sa taki sani di á fiti. Namo den akisi en taki: “Fa a weiti fu Gadu de? Wan man sa paati anga en uman, fu iniiwan pikin sani di en anga en abi?” ");
INSERT INTO djkNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma Masaa Jesesi piki den taki: “U á leisi san sikiifi a Masaa Gadu Buku fu dati, no? Bika a sikiifi taki, na a bigin, da Masaa Gadu be meke wan man anga wan uman namo. ");
INSERT INTO djkNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Di Masaa Gadu du dati, ne a taki: ‘Na fu dati ede meke, wan man e fika en gaansama osu, fu go teke en uman libi. Da den tu sama de mokisa libi toon wan sikin.’ ");
INSERT INTO djkNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Da den nái teli fu tu sama moo, ma den de wan sikin namo. Da san Masaa Gadu poti kon toon wan, da ná wan libisama di mu paati den.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ne den Faliseiman piki en taki: “We, efu a de so tuu, da saide meke Mosesi be sikiifi taki, manengee sa go naki pampila a lanti taki, en anga en uman paati? Da a sa gi a uman a pampila de, da a sende en gwe?” ");
INSERT INTO djkNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Namo Masaa Jesesi piki den taki: “Weeno! Na fu a taanga yesi fu u ede, meke Mosesi be du dati, fu gi u pasi fu u paati anga u uman! Ma na a bigin, da a sani á be de so. ");
INSERT INTO djkNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma mi e taigi u taki, a sama di o paati anga en uman, boiti efu a du ogii ne en osu, ne a teke wan taa uman, da a kai a ini a motyo libi.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Namo den bakaman fu Masaa Jesesi piki Masaa Jesesi taki: “Ai! Uman anga man toli taanga! Bika efu na so a weiti fu Masaa Gadu de, da a á de fu man teke uman libi. Soseefi a á de fu uman teke man fu libi tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Namo Masaa Jesesi piki den taki: “Meke mi taigi u! Ná ala sama sa de so. Ma na den sama di Masaa Gadu kai, fu tan so, da na den namo sa tan so. ");
INSERT INTO djkNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bika son sama á poi libi anga uman, fu di mama meke en so kaba. Son sama á poi libi anga uman, fu di taa sama poti en so. Son sama, da na den seefi fende en bun, fu tan so, fu de a ini a Nyun Tii fu Masaa Gadu. Da sama di sa fusutan san mi leli ya, da meke a fusutan en.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Namo a seefi yuu de, ne den sama tyai wanlo pikinengee kon a Masaa Jesesi, fu a poti ana a den tapu begi gi den. Ma den bakaman kaasi den fu ogii! ");
INSERT INTO djkNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Namo, Masaa Jesesi piki den taki: “U fika den pikin, meke denseefi kon doo a mi tu. U á tapu den! Bika na sama di abi a fasi di pikinengee abi sa poi go doo a ini a Nyun Tii a Masaa Gadu Kondee.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","We, ne Masaa Jesesi poti ana a den pikin tapu, begi gi den. Ne a gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","We, ne wan yonkuman kon doo a Masaa Jesesi. Ne a akisi en taki: “Mesiti! Sowtu bun de, fu mi du te, da mi sa fende a libi fu tego?” ");
INSERT INTO djkNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","We, ne Masaa Jesesi akisi en taki: “Saide meke yu e akisi, sowtu bun de? Yu á sabi taki, na Masaa Gadu wawan namo bun, no? We, efi i wani fende a libi fu tego, da i mu oli iseefi a den weiti fi en.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ne a yonkuman akisi en taki: “On di fu den weiti mi mu oli?” Namo Masaa Jesesi piki en baka taki: “Yu á mu kii sama. Yu á mu waka anga taa uman ofu man! Yu á mu fufuu. Soseefi, yu á mu lei. ");
INSERT INTO djkNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","I mu lesipeki i mma anga i dda. Yu mu lobi ala sama enke fa yu lobi iseefi.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","We, ne a man piki taki: “Ala den weiti de, na sani di mi e oli. Da san fika moo fu mi du, boiti dati?” ");
INSERT INTO djkNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Namo Masaa Jesesi piki en taki: “Efi i wani de wan bunbun sama sondee fowtu, da go seli ala den sani di yu abi. Da gi den pootiman a moni, da yu sa fende gaan gudu a Masaa Gadu a tapu anda. Da, te i kaba, da kon waka a mi baka, enke wan bakaman fu mi.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","We, di a yee ala san Masaa Jesesi taigi en, ne a booko sikoo. Ne a bendi ede a doti, ne a waka gwe anga ala gaan tyali na ati. Bika a be abi tyaipi gudu. ");
INSERT INTO djkNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Namo Masaa Jesesi daai go a den bakaman fi en taki: “Luku de! Fu tuutuu, a taanga gi wan guduman fu kon a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mi e taigi u ete wan toon. A moo makiliki fu wan kameili*f14* pasa a nanai olo, moo enke wan guduman pasa go a ini a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","We, di den bakaman fi en yee so, ne a sani fuka den. Ne den akisi en taki: “We, da sama sa fende a libi fu tego seefi?” ");
INSERT INTO djkNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Namo Masaa Jesesi luku den dunn. Ne a piki den taki: “Efu na libisama wawan a be didon, da ná wan sama di be o poi fende a libi de. Ma fu Masaa Gadu, da sani seefi á de di a á poi du.” ");
INSERT INTO djkNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","We, ne Peitilisi akisi en taki: “We, wi be fika ala sani di u be abi, kon waka a yu baka. Da sowtu paiman wi dati o fende?” ");
INSERT INTO djkNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Namo Masaa Jesesi piki taki: “U aliki ya! Fu tuu! Wan ten e kon, di ala sani o meke kon nyun baka. Da a Manpikin di saka kon toon libisama ya o sidon ne en kownu sutuu anga ala a dyendee di a abi, fu tii ala sani. Da u di be e waka ne en baka seefi o sidon a kownu sutuu, fu kuutu den twalufu lo fu Islayeli Kondee. ");
INSERT INTO djkNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Soseefi ala sama di fika osu ofu baala ofu sisa ofu dda ofu mma ofu uman ofu pikin ofu ala san a abi, fu di a wani waka a mi baka, da a o fende den sani ya wan ondoo toon baka. Da bakaten seefi a sa fende a libi fu tego tu. ");
INSERT INTO djkNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Da a yuu de, somen sama di de fesiwan ya o toon bakaman. Da somen di de bakaman ya o daai toon fesiwan.” ");
INSERT INTO djkNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Namo Masaa Jesesi gi den ete wan ageisi toli, fu soi den fa a Nyun Tii fu Masaa Gadu tan. A taki: “Wan guduman be abi wan goon. Ne di mamanten fuuku, ne a go suku sama fu yuu, fu kon yeepi en wooko a goon. ");
INSERT INTO djkNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ne di a fende den wookoman, ne en anga den kuudei taki, a o pai den wan hiihii dei wooko moni. Ne a sende den go wooko na a goon. ");
INSERT INTO djkNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ne a de ape, te wan sani fu neigin yuu so, ne a go a ganda baka. Ne a go si wan duupu taa sama taampu a wowoyo de sondee wooko. ");
INSERT INTO djkNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Namo a kai den taki: ‘U kon go wooko gi mi, a mi goon. Mi o pai u enke fa a fiti.’ Ne den go. ");
INSERT INTO djkNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“We, ne a de, te wan sani fu twalufu yuu so, ne a go baka go du a seefi sani. Ne di dii yuu, ne a daai go suku sama baka tu. ");
INSERT INTO djkNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Namo neti be e kon doo kaba, a be fika wan kodo yuu namo, fosi wooko komoto. Ne a basi waka go a ganda baka. Ne a si taa taa sama taampu anda ete, sondee wooko. Ne a akisi den taki: ‘Saide u de ya a ganda sondee wooko so?’ ");
INSERT INTO djkNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Namo den piki en taki: ‘Na taa fasi á de. Bika wi á fende wooko, moo enke fa u taampu ya.’ “Namo, ne a basi taigi den taki: ‘U kon go wooko a mi goon!’ Ne a sende den go na a goon. ");
INSERT INTO djkNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ne den wooko te a yuu kisi, fu den komoto a wooko. Ne a masaa di abi a goon, go taigi a wooko basi taki: ‘Kai den wookoman, da pai den den moni. Bigin a den lasiti wan, di u be teke a wooko a bakadina ya te go miti den fosi wan fu a mamanten.’ ");
INSERT INTO djkNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“We, ne den wookoman kon, di a be yuu na a bakadina mofu. Ne a pai den wan hii dei moni. ");
INSERT INTO djkNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma namo, di den wookoman di be kon senten mamanten si a moni di den wookoman di be kon bakadina kisi, ne den membee taki, den be o fende moo ipi moni moo enke den. Ma te fu kaba, ne den kon si taki, na a seefi moni den kisi, enke den man di be kon bakadina mofu de tu. ");
INSERT INTO djkNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","We, ne di den teke a moni, ne den ati boon na a masaa fu a goon, te ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ne den kuutu taki: ‘Fa a sani ya kan? Den man di kon dyonson ya, den wooko wankodo yuu langa namo, ne i pai wi anga den a seefi moni. Wi, di be de ya e pina e sweti hiihii dei a ini a gaan ati san.’ ");
INSERT INTO djkNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Namo a masaa piki wan fu den taki: ‘Mi mati! San mi du anga u so, meke u e kuutu mi? Mi á pai u wan hiihii dei moni, enke fa u be kuudei, no? ");
INSERT INTO djkNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","We, u teke san mi pai u, da u waka gwe a osu. Bika na miseefi wani pai den taawan a seefi moni di mi pai u. ");
INSERT INTO djkNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Da u fika mi, meke mi du san mi wani anga mi eigi moni. A á de fu u dyalusu so, fu di mi abi bun ati fasi fu luku sama.’ ");
INSERT INTO djkNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“We, na so den di de a baka ya o daai kon toon fesiwan. Da den di de a fesi ya o daai kon toon bakawan.” ");
INSERT INTO djkNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Da Masaa Jesesi de a pasi e gwe a Jelusalem. Ne a kai den twalufu bakaman fi en go a wanse. Ne a taigi den taki: ");
INSERT INTO djkNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“U si, wi e go a Jelusalem Foto nownow! Da den o kisi a Manpikin di saka kon toon libisama ya, poti a den hei apaiti begiman anga den leliman fu Dyuweiti ana. Da den o kuutu en taki, a mu dede. ");
INSERT INTO djkNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Da den o poti mi a den Loma sama ana. Da den o wisiwasi mi, fonmi te a sai den. Da den o tyai mi go sipikii kii a koloisi. Ma di fu dii dei, da mi o weki baka.” ");
INSERT INTO djkNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ma namo, da na a seefi yuu de, ne a mma fu den tu manpikin fu Da Sebedi kon a Masaa Jesesi. Ne a kai anga kini a doti a Masaa Jesesi fesi taki: “Masaa oo! Mi wani begi i wan sani, baa?” ");
INSERT INTO djkNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Namo Masaa Jesesi akisi en taki: “San i wani?” Namo a mma piki taki: “We, Masaa! Dyonson, yu o de Kownu a ini a Nyun Tii fu Masaa Gadu. Da gaantangi! Meke den tu manpikin fu mi ya sidon a yu se, baa? Wan fu den a yu letise ana, a taawan a yu kukutuse ana.” ");
INSERT INTO djkNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma Masaa Jesesi piki en taki: “Yu á sabi san i e akisi mi ya! Bika wan gaan pina de a pasi e kon fu mi nyan. U denki u sa poi nyanmi en anga mi?” Namo den piki en taki: “Eeye Masaa! U sa poi nyanmi en anga yu.” ");
INSERT INTO djkNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Namo Masaa Jesesi piki den baka taki: “Na tuu! U sa diingi en tuu! Ma a á didon a mi, fu gi sama peesi a mi leti ana ofu mi kukutu ana se. Bika na den sama di mi Tata, a tapu poti den hei peesi de gi sa fende den.” ");
INSERT INTO djkNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","We, di den taa tin bakaman fu Masaa Jesesi yee san pasa de, ne den ati boon seefi seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ma Masaa Jesesi kai ala den kon ne en. Ne a taigi den taki: “U ala fiya sabi fa den edeman fu goontapu ya e tii kondee. Den e dwengi sama poti a den ondoo. Da den sama de seefi e dwengi sama poti a den ondoo fu pee basi a den tapu. ");
INSERT INTO djkNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ma u dati á mu libi so. Pe fu dati, da a sama di wani hei a u mindii, mu saka enseefi fu e dini taawan. ");
INSERT INTO djkNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sama di wani toon fesiman fu taawan mu toon saafu gi den taawan. ");
INSERT INTO djkNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Bika a Manpikin di saka kon toon libisama ya, á kon fu sama dini en. Ma a kon fu dini sama. A kon fu gi en libi enke paiman, fu pai gi somen sama, fu kon de bun gi Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","We, ne di Masaa Jesesi anga den bakaman fi en komoto a Jelikow e gwe, ne tyaipi sama e waka ne en baka. ");
INSERT INTO djkNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma namo, da tu beendiman be sidon a sikin pasi. Ne di den yee taki, na Masaa Jesesi e pasa de, ne den e bali taki: “Masaa! Masaa! Bakaten Manpikin fu Kownu Dafeti paansu! Teke tyali ati luku wi, baa?” ");
INSERT INTO djkNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma den tyaipi sama di be e waka a Masaa Jesesi baka kaasi den taki: “U tapu mofu ya!” Ma a tan enke na sende, den sende den, fu bali moo taanga. Bika, na now den e bali taanga taki: “Masaa! Bakaten Manpikin fu Kownu Dafeti paansu! U begi i! Teke tyali ati luku wi oo!” ");
INSERT INTO djkNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","We, ne Masaa Jesesi taampu diin. Ne a kai den kon, ne a akisi den taki: “San u wani, fu mi du gi u?” ");
INSERT INTO djkNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Namo den piki taki: “Masaa! U wani i deesi u ain, fu u sa si sani.” ");
INSERT INTO djkNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Namo tyali kisi Masaa Jesesi fu den, te ná sipowtu. Ne a waka go, ne a oli den ain. Ne wanten de, ne den ain kiin fu si ala sani. Ne den teke fu waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Namo, den Masaa Jesesi kon doo koosube fu Jelusalem Foto. Den be de na a foto den e kai Betifage, na a pisi fu Oleifi Mongo. Namo, ne Masaa Jesesi kai tu fu den bakaman fi en kon, fu sende sani. ");
INSERT INTO djkNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","A taigi den taki: “Go na a kondee na abaase anda. U o si tu buliki de, wan uman wan anga en pikin. U losi den teke tyai kon gi mi ya. ");
INSERT INTO djkNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Efu wan sama sa akisi pe u e go anga den, da u mu piki en taki, na Masaa sende u, fu kon teke den. Bika Masaa abi den fanowdu nownow. Ma te a Masaa kaba anga den, da u o tyai den kon poti baka.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Da na fu sani sa waka enke fa wan fositen apaiti takiman fu Masaa Gadu be sikiifi. Bika a be sikiifi taki: ");
INSERT INTO djkNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Meke den sama fu Siyon sabi taki, a kownu fu den e kon. Ai kon a den anga ala gaan saka fasi a wan buliki tapu.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","We, ne den tu bakaman waka go, enke fa Masaa Jesesi sende den. Ne den du san a sende den tu. ");
INSERT INTO djkNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Den teke a uman buliki anga en pikin tyai kon. Soseefi den bakaman teke den koosi baala a den buliki mindii baka. Ne Masaa Jesesi subi go sidon na a pikin buliki tapu, fu gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Da tyaipi tyaipi sama be de anda di teke koosi anga bon ana baala na a pasi tapu pe Masaa Jesesi o pasa anga den buliki. ");
INSERT INTO djkNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Da sama be e waka a Masaa Jesesi baka, den e waka ne en fesi. Da den e bali taki: “Hosana gi a Bakaten Manpikin fu Kownu Dafeti paansu!” “Seigi fu awan, di e kon a ini a nen fu Masaa.” “Hosana gi Masaa Gadu a tapu seefi!” ");
INSERT INTO djkNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Namo di den doo a ini Jelusalem Foto seefi, ne a hii foto seke. Den sama booko kon gwuulu, da den e taki: “Sama kon ya?” ");
INSERT INTO djkNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Da taawan e piki taki: “Jesesi! Jesesi! Apaiti takiman fu Masaa Gadu di komoto a Nasaleti Foto, na a pisiwataa fu Galileya.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","We, ne Masaa Jesesi waka go na a gaan Mama Keliki. Da somen sama be de anda e bai sani, e seli enke na wowoyo. Namo Masaa Jesesi yaki ala den puu de. Ne a toto ala den tafaa pe den be e booko moni, towe a doti. A puu ala den sutuu pe sama be sidon e seli doifi towe gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na so ai taigi den tu taki: “U á sabi san sikiifi a Masaa Gadu Buku, no? A sikiifi taki: ‘Mi osu mu de wan peesi pe sama e kon, fu begi makandii.’ Na so! Ma fu saide u sama ya meke a toon wan peesi fu kweki fufuuman du?” ");
INSERT INTO djkNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Namo, di Masaa Jesesi de ape, ne wantu beendiman anga lanman kon suku yeepi ne en. Ne a deesi den kon bun. ");
INSERT INTO djkNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","We, den hei apaiti begiman anga den leliman fu Dyuweiti ape ati boon tuutuu. Bika den si den foondoo sani di ai du ape. Soseefi den e yee pikinengee seefi mu e bali baya ape taki: “Hosana! Bika en na a Bakaten Manpikin fu Kownu Dafeti paansu.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","We, ne den moo hei apaiti begiman komoto kon akisi Masaa Jesesi taki: “I yee bun, fa den pikin e kai yu de?” Namo Masaa Jesesi piki den taki: “Mi e yee kiinkiin, fa den e kai mi! Ma u dati á leisi san sikiifi a Masaa Gadu Buku, no? A sikiifi taki: ‘Masaa Gadu o meke, te enke petepete pikin seefi e bali baaya gafa en.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","We, ne Masaa Jesesi waka komoto ape. Soseefi a komoto a ini Jelusalem Foto, go siibi na a peesi den e kai Betaniya. ");
INSERT INTO djkNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Namo fuuku mamanten, ne Masaa Jesesi opo fu go a Jelusalem Foto baka. Ma angii be moo en. ");
INSERT INTO djkNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Namo a si wan figasii bon a sikin pasi. Ne a go suku figasii na a bon. Ma ná wan enkii sii a poi fende. Ne a fuuku a bon taki: “I kaba fu meke sii a goontapu! Bika noiti moo wanten i sa meke sii!” Fa i si Masaa Jesesi taki so, a bon dede wanten. ");
INSERT INTO djkNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Da den bakaman fi en si a foondoo sani di pasa anga a bon ya. Ne den foondoo te, den á sabi san fu du. Namo den go akisi Masaa Jesesi taki: “Da fa a bon du dede wanboo wanboo so?” ");
INSERT INTO djkNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Namo a piki den taki: “Na tuutuu biibi meke dati pasa. Bika te i sa biibi Masaa Gadu doo yu ati tuutuu, da i sa poi du san mi du ya tu. Soseefi i sa poi du moo gaan foondoo sani moo dati seefi. A winsi na sende i sende wan gaan mongo taki: ‘Diipi go kai a ini ze.’ A sa musu fu go! ");
INSERT INTO djkNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Fu tuu, ala san i begi akisi Masaa Gadu, a sa du ala dati gi yu. Ma a wan sani, i mu abi biibi doo yu ati, te yu e begi.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Namo Masaa Jesesi go doo Jelusalem Foto baka. Ne a waka go na a Mama Keliki baka, fu go leli den sama sani anda. Namo den hei apaiti begiman anga den gaansama fu kondee go ne en. Ne den akisi en taki: “Sama gi yu a makiti, fu waka du den sani, di yu e waka e du ya! Sama gi yu a makiti fu du den sani ya?” ");
INSERT INTO djkNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","We, ne Masaa Jesesi piki den taki: “Mi o akisi u wan sani fosi. Te u kaba piki mi dati, da miseefi sa piki u san u akisi mi de. ");
INSERT INTO djkNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","U piki mi! Sama be gi Johanisi a makiti fu dopu sama? Na Masaa Gadu ofu na libisama be sende en?” We, di a akisi so, ne den bendi a se fosi, fu kai pakisei luku, fa fu piki en. Ne den fiti taki: “Efu u piki taki: ‘Na Masaa Gadu sende Johanisi,’ a sa akisi wi taki: ‘Da saide, u á be biibi Johanisi?’ ");
INSERT INTO djkNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Soseefi, efu u piki taki: ‘Na libisama be gi en Johanisi a makiti,’ da wi anga a foluku fu kondee o de a toko. Bika a foluku e si Johanisi enke wan apaiti takiman fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Dati meke den piki Masaa Jesesi taki: “Wi á sabi sama be gi en a makiti.” Ne Masaa Jesesi piki den baka taki: “Di u á sabi kaba sama be gi en a makiti, da mi seefi ná o taigi u sama gi mi a makiti tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Namo Masaa Jesesi taki anga den go doo taki: “Mi o gi u wan ageisi toli fu teke poti pakisei bunbun! Wan sama be abi tu manpikin anga wan goon. Ne a sende a moo gaan manpikin fu go wooko na a goon. ");
INSERT INTO djkNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ma a pikin ya piki en taki: ‘Nono, mi dda! Mi ná o poi go wooko a goon.’ Ma moo lati, ne a pikin ya fii tyali, fu di a piki so. Ne a komoto langa langa go wooko na a goon, gi a dda. ");
INSERT INTO djkNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“We, ne a dda go na a moo nyoni manpikin tu. Ne a sende en fu go wooko na a goon tu. Namo a manpikin ya piki taki: ‘Iya, mi dda! Mi o go. Ma na piki namo a piki, bika a á go seefi seefi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Namo Masaa Jesesi koti a toli taki: “On di fu den tu manpikin ya du san a dda wani?” We, ne den piki en taki: “Awan di be taki, a ná o go, ma toku a go moo lati.” Ne Masaa Jesesi taki: “We, fu tuu, mi e taigi u taki, den gaan polinen sama fu kondee o daai kon de a ini a Nyun Tii fu Masaa Gadu. Ma u dati o fika so. ");
INSERT INTO djkNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bika u á si taki, Johanisi taki sani fu Masaa Gadu, ne den dati biibi, no? Weeno! Ma u dati si san pasa de, ne toku u seefi á wani daai libi fu biibi Johanisi.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Namo Masaa Jesesi taki baka taki: “Wan taa ageisi toli e kon ya, fu soi wan sani. Wan gaan masaa be abi wan goon, fu paandi wan sii enke doloifi. Ne a meke wan wooko sani poti ape, fu kwinsi a sii ya kon toon win. Soseefi a lontu a hii goon anga a hii wooko sani ya poti a ini dyali. Ne a meke wan hei osu go a tapu fu den wakiti man oli waki na a goon. Ne a kai wan duupu sama kon poti a hii wooko ya a den ana, fu du. Bika enseefi o go koi a taa kondee. ");
INSERT INTO djkNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Namo, den sii fu a goon be kon lepi. Na so a yuu doo, fu go booko den kwinsi toon win. Ne a gaan masaa sende en futuboi go a den sama, fu den sende fi en se gi en. ");
INSERT INTO djkNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ma den sama feti ogii ogii anga den futuboi fu a gaan masaa, di a sende go. Den fon afu, ne den naki taawan kii anga siton. ");
INSERT INTO djkNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ma toku, a gaan masaa sende moo ipi futuboi go a den sama baka, fu meke den sama sende fi en se gi en. Ma den disi seefi go tuka anga a seefi ogii, di be miti den fosi futuboi di a masaa be sende go. ");
INSERT INTO djkNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“We, ne a gaan masaa luku taki: ‘Efu mi sende a manpikin fu miseefi go a den sama tu, da den o feele fu du ogii anga en, fu di na a manpikin di miseefi abi.’ ");
INSERT INTO djkNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Namo den sama si a manpikin e kon. Ne den taki: ‘Oho, luku anda! A gaan masaa sende a manpikin fi en seefi kon a leisi ya. We, disi na awan kodo manpikin di a dda abi, fu poti enke basi, fu taki, gi ala san a dda seefi abi. Meke u kii en, da a goon o fika gi wi.’ ");
INSERT INTO djkNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","We, ne den lulu a manpikin ya, fu te a kon doo. Ne den ali en puu a ini a goon tyai go kii.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Namo, ne Masaa Jesesi koti a toli. Ne a akisi den taki: “San u pakisei a gaan masaa o du, te enseefi o kon a den sama ya?” ");
INSERT INTO djkNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Namo den piki en taki: “A gaan masaa ya ati musu boon tuutuu. Da a musu kii den takuu ati sama di be e luku a goon de. Soseefi, a o poti a goon a ini taa sama ana, di sa wani gi en, fi en se.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Namo Masaa Jesesi taigi den baka taki: “U á leisi san sikiifi a Masaa Gadu Buku, no? A sikiifi taki: ‘Disi na a siton di meseeman be oli fu wan soso sani. Na dati daai kon toon a siton futu fu a hii osu. Na so Masaa du en wooko. A foondoo gi wi, fu si.’ ");
INSERT INTO djkNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","We, meke mi e taigi u! Masaa Gadu o fika u fu a peesi ya a wan se. Da a o komoto go anga a Nyun Tii fi en a taa taa foluku sama, di wani tan enke fa a wani. ");
INSERT INTO djkNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Bika sama di o kai na a siton ya tapu, o booko pisipisi. Soseefi, efu a siton ya kai a wan sama tapu, da a o masi a sama de fini fini.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Namo den hei apaiti begiman anga den Faliseiman aliki den toli fu Masaa Jesesi ya, te a kaba. Ne den taki: “Na wi ai poti na ageisi toli de so.” ");
INSERT INTO djkNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Da na leti ape kaba den be wani kisi Masaa Jesesi wanten. Ma den á kisi en ape. Bika den be e feele a foluku di e oli Masaa Jesesi enke wan apaiti takiman fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Namo Masaa Jesesi gi wan taa ageisi toli baka, fu leli den sama wan sani. ");
INSERT INTO djkNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","A taki: “A Nyun Tii fu Masaa Gadu tan enke fa a toli fu a kownu ya o waka. A kownu ya be abi wan manpikin. Ne a manpikin yuu kisi fu teke wan uman libi. Namo a kownu sete wan toow osu, fu oli gi en. ");
INSERT INTO djkNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ala sani fu a fesa seeka te a kaba. Ne a kownu sende futuboi go kai wan paitei sama, fu kon nyan toow osu. Ma den sama ya á wani kon. ");
INSERT INTO djkNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A kownu sende futuboi ete wan leisi go kai den baka taki: ‘U kon! Mi seeka ala nyanyan sani, fu oli a feisiti kaba. Mi kii kaw anga taa taa fatu meti boli! U kon piisii na a fesa!’ ");
INSERT INTO djkNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ma winsi fa den futuboi go taki dati, toku den sama á wani kon. Bika den abi taa taa fuka e du. Taawan taki, ai go a goon. Taawan abi taa taa sowtu sani e du. ");
INSERT INTO djkNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Wan paitei fu den sama dati kisi den futuboi fu a kownu di a sende go, wai kon. Ne den taki, den o mesaandi den. We, tuutuu den du anga den, te den kii son fu den seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Namo a kownu ati boon tuutuu. Ne a sende suudati go kii den sama di kii den futuboi fi en baka. Den suudati boon a hii foto fu den sama de paata a doti. ");
INSERT INTO djkNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Namo a kownu kai wan duupu taa futuboi kon. Ne a taigi den taki: ‘Ala sani fu a feisiti de seeka seeka. Ma den sama di mi be kai fu kon, den á waiti fu kon doo ya. ");
INSERT INTO djkNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Da u go waka na a hii ganda kai ibii sama di u si anda, fu kon nyan a feisiti.’ ");
INSERT INTO djkNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","“We, ne den wookoman go kai ala sama di den miti, fu go na a toow osu. Namo a toow osu bigi te, ai meke huuw anga sama. Bika ala sowtu sama be kon, bun ati wan anga takuu ati wan. ");
INSERT INTO djkNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Namo a kownu seefi waka kon doo a ini a toow osu, fu luku sama di kon. Da a si taki, den sama wei toow osu koosi, fiti enke fa a mu de. Ma na wan kodo sama de ape á be wei bunbun koosi. ");
INSERT INTO djkNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Namo a kownu go akisi a sama ya taki: ‘Mi baala? Na so yu wei kon a mi feisiti?’ Namo a sama taampu diin namo, a nái piki a kownu seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“We, ne a kownu sende en futuboi taki: ‘U kisi en! U tei en futu anga en ana! Da u iti en go na a gaan dunguu a doose anda. Na soso kee anga kaw tifi de anda.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Namo Masaa Jesesi koti a toli leti ape taki: “Na soseefi Masaa Gadu kai tyaipi tyaipi sama kon. Ma a ná ala den doo peesi, fu Masaa Gadu teke toon sama fi en seefi.” ");
INSERT INTO djkNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Namo den Faliseiman kon gwe. Ne den gwe go kai pakisei luku, fa fu akisi Masaa Jesesi wan sani, fu a piki fasi enseefi. ");
INSERT INTO djkNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Namo den sende bakaman fu den go makandii anga wantu politikiman fu Kownu Helowdesi. Ne den taigi Masaa Jesesi taki: “Fa u sabi yu, da yu na wan gaan letiopu libisama! Yu e leli sama soso tuutuu sani fu Masaa Gadu. Soseefi yu nái kuutu konkuu. Bika yu e soi ibii sama di doo yu, leti san i mu soi en. Da i nái luku taki, disi ofu dati. ");
INSERT INTO djkNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","We! Taigi u, efu a de fanowdu fu u pai a moo gaan kownu a Loma Foto, a lantimoni.” ");
INSERT INTO djkNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma ala fa den kon akisi Masaa Jesesi a sani ya, da a be sabi kaba taki, na wani den wani koli en, fu a piki sani di á bun. Namo a piki den taki: “U bidiigiman! Na wani u wani fasi mi kisi so? ");
INSERT INTO djkNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","U tyai a pikin moni di u e pai a lantimoni seefi kon, gi mi, osi?” Namo den sama kon doo anga wan fu den moni ya Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne a teke a moni luku, te a kaba. Ne a taki: “Sama na a sama, di fesi maiki na a moni tapu ya?” ");
INSERT INTO djkNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","We, ne den piki en taki: “A sama de? A fesi di maiki na a moni tapu de, na fu a moo gaan kownu a Loma Foto!” We, ne Masaa Jesesi piki den baka taki: “Efu ne en fesi de na a moni tapu, da a moni ne en sani! Da na musu u musu fu gi en, en sani di a abi! Ma san u dati abi fu gi Masaa Gadu, dati na san de fu Masaa Gadu. Na dati u mu gi Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","We, di Masaa Jesesi piki so, ne den foondoo, te ná sipowtu. Namo den fika en, ne den gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A seefi dei de, ne a kulu fu den Saduseiman kon doo a Masaa Jesesi. Den sama ya e biibi taki, te wan sama dede, da a tan dede. Noiti moo a sa weki moo. ");
INSERT INTO djkNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","We, ne den taigi Masaa Jesesi taki: “Mosesi be fika wan weiti gi wi. Ai soi san fu du, te manengee dede fika en uman, sondee pikin. Da na a baala di a man ya abi fu teke a uman libi, fu meke pikin gi a dede baala. ");
INSERT INTO djkNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma yee ya! Seibin baala be de. Ne a moo gaan wan kon dede, fika en uman sondee pikin. Ne a baala di waka ne en baka teke a uman libi. ");
INSERT INTO djkNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Baka wan pisiten, a baala de seefi kon dede, sondee pikin anga a uman. Meke u taki, a waka so anga ala den taa baala. Bika ala dede, sondee meke pikin anga a uman. ");
INSERT INTO djkNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Da te fu kaba, a uman seefi kon dede tu. ");
INSERT INTO djkNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","We, yu á taki, dedesama o weki wan dei baka, no? Da den seibin baala ya seefi musu weki tu. Da on di fu den seibin i pakisei taki, o abi a uman enke uman. Bika ala den seibin be libi anga en a ini den libiten.” ");
INSERT INTO djkNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Namo Masaa Jesesi piki den taki: “U nái fusutan Masaa Gadu toli! Bika u á sabi san sikiifi a Masaa Gadu Buku. Soseefi u á sabi taki, Masaa Gadu abi makiti, fu du ala sani. ");
INSERT INTO djkNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bika i si den sama di o weki baka? Na Masaa Gadu Kondee a tapu den o go tan enke Masaa Gadu Kondee Basiya*f15* anda. Da fu teke uman ofu man libi, dati á sa de anda gi den moo. ");
INSERT INTO djkNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Soseefi u á leisi san sikiifi fu dedesama a Masaa Gadu Buku, no? Bika Masaa Gadu taki de taki: ");
INSERT INTO djkNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Mi na a Gadu fu Abalaham, Isaki anga Jakopu.’ Da disi e soi taki Masaa Gadu a ná a Gadu fu sama di dede, da a kaba. Ma en na a Gadu fu sama di winsi den dede, toku den e libi ete.” ");
INSERT INTO djkNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","We, di Masaa Jesesi piki so, ne ala sama di be de ape foondoo, te ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Namo den Faliseiman seefi kon yee taki, Masaa Jesesi tapu den Saduseisama mofu, te den á poi piki en baka. Namo denseefi feti lon kon doo. ");
INSERT INTO djkNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wan fu den, di be kon de na wan leliman fu Dyuweiti. Na dati go fii Masaa Jesesi mofu luku, fu a sa taki sani fasi enseefi. ");
INSERT INTO djkNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Namo a akisi Masaa Jesesi taki: “On di fu den weiti fu Masaa Gadu moo bigi, fu oli?” ");
INSERT INTO djkNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","We, ne Masaa Jesesi piki en taki: “Na di taki: ‘U mu lobi Masaa Gadu anga u hii ati, u hii fii anga u fusutan.’ ");
INSERT INTO djkNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Na dati na a weiti di moo bigi. ");
INSERT INTO djkNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ete wan weiti de fanowdu fu oli enke dati tu. Dati taki: ‘U mu lobi ala taa sama enke fa u lobi u seefi.’ ");
INSERT INTO djkNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bika na den tu weiti ya, na a hii mama fu den weiti di Mosesi anga taa taa fositen apaiti takiman fu Masaa Gadu be sikiifi.” ");
INSERT INTO djkNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Namo, da den Faliseiman be de ape makandii kaba. Ne Masaa Jesesi seefi o go akisi den wan sani tu. ");
INSERT INTO djkNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","A taki: “Fa u membee fu a Kelestesi seefi? Sowtu gaansama bakaten paansu pikin a de?” Namo den piki en taki: “Na wan bakaten manpikin fu Kownu Dafeti paansu.” ");
INSERT INTO djkNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Namo Masaa Jesesi piki baka taki: “Da saide a Apaiti Jeje fu Masaa Gadu be piki Kownu Dafeti seefi, fu kai a Kelestesi, Masaa? Bika Kownu Dafeti seefi be taki a ini Masaa Gadu Buku taki: ");
INSERT INTO djkNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Masaa Gadu taigi mi Masaa taki: “Sidon a mi leti ana se ya, te enke mi poti ala yu feyanti a yu futu ondoo.” ’ ");
INSERT INTO djkNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na so Dafeti seefi be kai a Kelestesi ‘Masaa.’ Da fa u ya sa taki, a Kelestesi na soso wan bakaten manpikin fu Kownu Dafeti paansu namo, da a kaba?” ");
INSERT INTO djkNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","We, di Masaa Jesesi kaba taki so, ne den á sabi san fu piki moo. Soseefi den e feele tu, fu sete taa sitee anga en, senten a dei de. ");
INSERT INTO djkNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Namo, ne Masaa Jesesi daai taki anga a foluku fu kondee ape, makandii anga den bakaman fi en. ");
INSERT INTO djkNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","A taki: “Den leliman fu Dyuweiti anga den Faliseiman, teke Mosesi peesi tuu, fu leli sama dini Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Da u mu e teke san den e taki. Ma luku bun! U á mu teke a sowtu fasi, fa denseefi e libi. Bika den seefi nái waka enke a leli di den e gi. ");
INSERT INTO djkNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ma na taanga weiti den e poti gi sama, fu oli. Ma denseefi nái lobi wan finga a den weiti de, fu meke sama poi si a den, fa a weiti mu oli seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Da na fu sama ain, meke den e du sani. Bika den e sikiifi Masaa Gadu weiti poti a pampila, tei na ana anga fesi ede. Soseefi den e wei apaiti sowtu koosi tu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Soseefi den e teke peesi sidon a den moo bunbun peesi fu tafaa sikin a ini keliki. Soseefi te feisiti doo, da na den e teke den moo bunbun peesi a tafaa sikin. ");
INSERT INTO djkNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Soseefi, den lobi te ala sama di miti anga den a wowoyo e kai den, Mesiti. Bika den wani ala sama e si den enke gaan bigiman. ");
INSERT INTO djkNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ma u enke bakaman fu mi dati á mu tan enke den. Bika u ala ya dati na baala anga baala. Da u á mu meke taawan poti u e kai, Mesiti ya. Bika na wan kodo Masaa fu gi leli namo u ala de abi. ");
INSERT INTO djkNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Soseefi, na wankodo Tata di de a tapu namo u ala de abi. Da u á mu si taawan ya enke a sowtu Tata de. ");
INSERT INTO djkNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Soseefi u á mu meke taawan poti u e kai, edeman fu gi leli, tu. Bika na mi, a Kelestesi wawan na a edeman, fu gi leli. ");
INSERT INTO djkNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma a wi mindii ya, efu yu wani de basi a taawan tapu, da na yu mu saka yuseefi e dini den taawan. ");
INSERT INTO djkNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na sama di e saka denseefi so, na den Masaa Gadu o gi wan hei peesi. Ma Masaa Gadu o saka ala sama di e hei denseefi, poti a ondoo fu ala den taawan.” ");
INSERT INTO djkNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Soseefi Masaa Jesesi taki go doo taki: “Ma heelu fu u, leliman fu Dyuweiti anga Faliseiman! Bika u na bidiigiman! U taampu e tapu pasi gi den sama di wani kon a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","We! Heelu fu u, leliman fu Dyuweiti anga Faliseiman! Bika u na bidiigiman! U sidon e nyan ala sani fu pooti uman di man dede fika a ganda. Da u sidon e begi gaan lolo begi gi den baka, enke u na bunbun sama. We, den sani ya o meke Masaa Gadu gi u moo gaan sitaafu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Fu tuu! Heelu fu u, leliman fu Dyuweiti anga Faliseiman! Bika u na bidiigiman! U e waka e lontu goontapu, fu suku sama tyai kon toon u bakaman. Da u e meke sowan sama kon ogii tu boo moo u seefi. Da enseefi e kon lepi fu go teke sitaafu a didibii faya, enke u de tu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Da heelu fu u! Bika u na beendiman di nái si, ma toku, u e suku fu tyai taawan waka a pasi. Bika u de ape e leli sama lei sani taki: ‘Den sa sweli taki, anga a nen fu a Mama Keliki taki, na so mi o du!’ Da efu den á du enke fa den be sweli, da a ná ogii. Ma san ogii, na te den be sa sweli taki, anga a nen fu gowtu di de a ini a Mama Keliki. ");
INSERT INTO djkNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","We, u beendiman de! Na law u e law? U taigi mi! A Mama Keliki ofu a gowtu di de a ini, on di e meke a taawan toon apaiti sani gi Masaa Gadu? ");
INSERT INTO djkNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","U taki tu taki: ‘Sama sa sweli taki, anga a nen fu a apaiti begi tafaa pe den e poti meti boon, enke paiman gi Masaa Gadu.’ Da efu den á du enke fa den be sweli de, da a ná o ogii. Ma san ogii, na te den be sa sweli taki: ‘Anga a nen fu a meti di e boon enke paiman gi Masaa Gadu de.’ ");
INSERT INTO djkNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","We! U na beendiman! Bika u piki mi! A meti di den poti e boon enke paiman gi Masaa Gadu ofu a apaiti begi tafaa? On di fu den tu e meke a taawan toon wan apaiti sani gi Masaa Gadu? ");
INSERT INTO djkNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","U nái si taki, na a apaiti begi tafaa e meke a meti toon wan apaiti sani gi Masaa Gadu, no? We, da efi i teke a apaiti begi tafaa sweli, da a meti seefi á de a ini a sweli tu, no? ");
INSERT INTO djkNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Soseefi, efi i sweli taki: ‘Anga a nen fu a Mama Keliki.’ Da Masaa Gadu seefi de a ini a sweli de. Bika a dati na a tanpeesi fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Soseefi, efi i sweli taki: ‘Anga a nen fu Masaa Gadu Kondee.’ Da Masaa Gadu seefi de a ini a sweli de. Bika na anda Masaa Gadu sidon ne en kownu sutuu, fu tii ala sani. ");
INSERT INTO djkNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“We, heelu fu u, leliman fu Dyuweiti anga Faliseiman! Bika u na bidiigiman. U e du wan bun, te u goon nyanyan lepi. Bika ibii sani di a goon puu, da u e paati dati a ini tin pisi. Da u e teke wan fu den tin pisi tyai go gi Masaa Gadu, enke fa weiti taki. Ma u e wai a mama fu Masaa Gadu weiti seefi poti a wanse. Bika dati taki, u mu teke tyali ati anga letiopu fasi libi anga biibi Masaa Gadu tu. Na so u be mu libi, sondee fu fika bun, di u gwenti du de kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ma tuutuu! U na tiiman di beendi fu si sani! U gei beendi sama di teke koosi, fu doo wataa puu ala pikin pikin feefee. Ma a nái si a gaan meti seefi di de a ini a wataa, fu puu. Ne di a nái si en, ne a misi diingi dati gwili. ");
INSERT INTO djkNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“We, heelu fu u, leliman fu Dyuweiti anga Faliseiman! Bika u na bidiigiman. U gei sama di lobi wasi doose fu kan anga beenki, te a kiin. Ma ai e fika inise tyobo tyobo anga soso doti. Bika te sama luku u a doose, da u e gei kele kele letiopu libisama. Ma inise fu u lai anga soso ogii anga fufuu pakisei. ");
INSERT INTO djkNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","U beendi Faliseiman de! A be sa moo bun fu kiin inise fu u, da doose seefi be musu kon kiin tu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“We, heelu fu u, leliman fu Dyuweiti anga Faliseiman! Bika u na bidiigiman. U gei wan geebi. U sabi te den wei geebi fu dedesama, te a kaba? Da doose e sete moi moi. Ma luku go a ini namo, i sa si! A fuu anga soso poli dede tingi sani. ");
INSERT INTO djkNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Bika te sama luku u de so, da u e gei kele kele letiopu libisama. Ma toku, lei manii anga soso ogii fuu u ati. ");
INSERT INTO djkNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Leliman fu Dyuweiti anga Faliseiman! Heelu fu u! Bika u na bidiigiman. U e waka e wei den geebi fu den fositen apaiti takiman fu Masaa Gadu, te a moi. Soseefi u e go wei den geebi fu den taa taa letiopu sama. ");
INSERT INTO djkNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Da, te u kaba wei den so, da u taampu e taki: ‘Kee! Na wi be mu de a libi na a ten fu wi avo gaansama, baa! Wegi! Da u á be o kii den apaiti takiman fu Masaa Gadu ya.’ ");
INSERT INTO djkNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","We na useefi mofu e kai u seefi bakaten pikin enke paansu fu den fositen sama, di kii den apaiti takiman fu Masaa Gadu de. Da a ná abi misi! U na tuutuu baka bakaten paansu pikin fu den tuu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Da meke ai piki gi u naamo, man! Bika na so u avo be sete. Da a kon, na u dati mu kii go doo, fu meke a doo maiki. ");
INSERT INTO djkNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“U takuu tetei sineki! Masaa Gadu o sitaafu u a didibii faya, tu! Fa u sa pakisei taki, Masaa Gadu sa fika u kookoo? ");
INSERT INTO djkNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Bika u seefi o du gaan ogii anga somen letiopu sama na a ten ya tu. Mi o sende somen sowtu wookoman fu mi kon a u. Da u o yaki den puu a ini den foto fu u. U o wipi somen fu den a ini den keliki osu fu u. Soseefi, u o sipikii somen fu den kii a koloisi tu. ");
INSERT INTO djkNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kaba! Da na leti fa u avo gaansama mu kisi sitaafu a Masaa Gadu, na a seefi fasi u dati sa fiti fu kisi sitaafu tu. Bika u ala o pai fu a buulu fu Abeli, a fosi letiopu sama di u be kii. U o pai fu dati te go doo a buulu fu Sakalia, a pikin fu Belekiya di u be kii koosube fu a apaiti begi tafaa a Mama Keliki. ");
INSERT INTO djkNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Fu tuu! U mu aliki bun san mi e taki ya! Bika u sama fu a ten ya seefi o kisi a sitaafu di mi taki de tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Namo Masaa Jesesi daai wasikoi den sama fu Jelusalem Foto taki: “Den sama fu Jelusalem Foto! A ná u dati e waka e kii somen apaiti takiman fu Masaa Gadu, no? Weeno! U e naki somen sama di Masaa Gadu sende kon, fu taki sani fu Masaa Gadu, kii anga siton. Ma i sabi onmen leisi, mi ya suku, fu meke u ali kon tan a mi ondoo, meke mi solugu. Bika mi be wani poti u solugu a mi ondoo, enke fa mama foo e tapu en pikin solugu. Ma kweti! U á wani dati. ");
INSERT INTO djkNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na dati meke Masaa Gadu o fika u. ");
INSERT INTO djkNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Da u ná o si mi moo, te enke u sa bali taki: ‘Seigi fu Awan di e kon a ini a nen fu Masaa.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Namo Masaa Jesesi waka go a doose fu a Mama Keliki. We, ne den bakaman fi en seefi teke ne en baka. Da den e gi toli anga Masaa Jesesi. Soseefi den e soi en taki, a Mama Keliki na wan tuutuu moi osu. ");
INSERT INTO djkNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma Masaa Jesesi piki den taki: “U si fa a moi tuu? Ma fu tuu a ná o taampu ape moi moi so, go doo. Bika fetiman o komoto kon lulu lulu en booko doo doti.” ");
INSERT INTO djkNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Namo Masaa Jesesi waka go doo a peesi den e kai Oleifi Mongo. Na ape a siton, ne den bakaman fi en waka go doo ne en anda tu. A di den wawan de ape anga Masaa Jesesi, ne den akisi en taki: “I sa taigi wi on ten a toli di i taki de o pasa? Soseefi, i sa taigi wi san na a ten, di yu o kon anga a kaba fu goontapu tu?” ");
INSERT INTO djkNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","We, ne Masaa Jesesi wasikoi den taki: “Wan sani! U mu e luku bun namo! U mu luku bun, fu sama á fende pasi koli u kisi! ");
INSERT INTO djkNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bika somen sama o kon enke na den na a Kelestesi. Na so den o wooko anga mi nen, fu koli sama kisi. Da den o fende somen sama, koli waka a den baka. ");
INSERT INTO djkNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Soseefi oloku sa e bali na ala se fu goontapu. Ma u á mu dyombo fu dati. Bika ala den sani ya mu pasa leti so. Ma toku, da a ná kaba yuu fu goontapu doo ape ete. ");
INSERT INTO djkNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bika foluku o feti ete anga foluku. Soseefi den kondee anga kondee fu goontapu sa e feti anga denseefi. Gaan angiiten o naki somen peesi fu goontapu tu. Soseefi doti o go e seke e piiti son pisi fu goontapu. ");
INSERT INTO djkNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma ala den sowtu banowtu ya na bigin fu a gaan banowtu ten, di de fu kon seefi. Bika a banowtu fu goontapu o waka enke a hii banowtu di wan bee uman e fii. ");
INSERT INTO djkNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Soseefi sama o poti u a kuutu fesi, fu di u e biibi mi ede. Den o pina u, te enke den e kii u seefi. Bika a ten de, da ala sama o buuse u, fu mi ede. ");
INSERT INTO djkNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Da somen biibisama o lasi biibi a mi. Soseefi, son biibisama o sete buuse taa biibiwan. Soseefi biibiwan o de, di o tyai taawan go konkuu gi sama di nái biibi mi. ");
INSERT INTO djkNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Soseefi, yu o abi sama di o meke enke na den na apaiti takiman fu Masaa Gadu. Da den o fende somen sama koli poti e biibi den. ");
INSERT INTO djkNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","We, fu di a ten sa e ogii so naamo, da somen sama o kaba fu wooko anga lobi fu taawan. ");
INSERT INTO djkNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ma ala sama di sa tei ati fu oli doo sa fende a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Da a Bun Nyunsu di e taki fu a Nyun Tii fu Masaa Gadu seefi mu paati, doo hii goontapu, fu ala sama yee en. Fosi, da a kaba yuu fu goontapu sa kon.” ");
INSERT INTO djkNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Soseefi Masaa Jesesi taki ete taki: “Ma boiti ala san mi taki de, da wan taa ogii o pasa na a ten de tu, di o dyombo sama. Bika ogii ati sama o kon poli a apaiti peesi fu a Mama Keliki wan tuutuu fasi. Den o kon poti wan sani di á fiti ape. Ala dati o waka enke fa a apaiti takiman fu Masaa Gadu di den e kai Daniyeli be sikiifi a fositen taki, dati musu fu pasa.” A sama di e leisi a sani ya, mu leisi en bunbun fu fusutan san ai leisi. ");
INSERT INTO djkNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ne Masaa Jesesi taki go doo taki: “Te a ogii de o pasa kaba, da u á mu lasi ten e daai daai a ganda ya moo. Ma u mu lon komoto ape wanten wanten gwe. Meke sama di de a Judeja pisiwataa lowe go kibii, a den mongo. ");
INSERT INTO djkNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Soseefi sama di sidon a osu, a sodoo á mu saka go daai daai a ini osu, fu suku sani tyai lowe tu. ");
INSERT INTO djkNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Soseefi, sama di o de a goon e wooko, á mu go a osu go lasi ten, fu teke koosi tyai lowe tu. ");
INSERT INTO djkNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","A hii takuu ten de, sa tyali gi den uman di de anga bee, na a ten de. Soseefi a sa tyali tu, fu den mma di abi pikin a bobi, na a ten de. ");
INSERT INTO djkNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ma soseefi, da u mu begi taki, a takuu ten de á kai na a koo pisiten fu a yali. Soseefi, u mu begi, fu a á kai a wan kina dei. ");
INSERT INTO djkNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bika goontapu o toon wan gaan banowtu peesi, fu tan. A sa de a moo taanga ten, fu senten goontapu meke, te kon miti nownow. Soseefi, da noiti moo sowan taanga ten sa kon tu. ");
INSERT INTO djkNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma na fu den biibisama ede, meke Masaa Gadu satu a hii banowtu ten ya. Bika efu Masaa Gadu á be du dati, da ná wan sama be o fika a libi. ");
INSERT INTO djkNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Da efu wan sama taigi u taki: ‘Luku, a Kelestesi leti ya!’ ofu ‘A Kelestesi de so!’ U á mu biibi den, kweti kweti! ");
INSERT INTO djkNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Bika somen sama o opo e kai denseefi a Kelestesi. Soseefi, sama o opo e pee gaan apaiti takiman fu Masaa Gadu. Da den sa e du somen gaan foondoo sani. Da efu a be kan, da den be o koli den sama fu Masaa Gadu, di a teke toon fi en seefi tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ne Masaa Jesesi taigi den baka taki: “U luku! Mi taigi u ala den sani ya a fesi! ");
INSERT INTO djkNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Bika sama sa kon taigi u taki: ‘A Kelestesi kon, meke u go luku en a ini a gaan sabana ini.’ Soseefi den sa taki: ‘A Kelestesi kon, meke u go luku en a wan kibii kibii peesi.’ U á mu biibi den seefi seefi! ");
INSERT INTO djkNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bika, te a Manpikin di saka kon toon libisama ya o kon baka, da a ná o de wan kibii sani. A o de kiinkiin fu ala sama fu goontapu si. A o de leti enke te tapu koti faya na a se fu san opo, da den e si en, a te na se fu san dongo. ");
INSERT INTO djkNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Na pe wan meti dede fika, na a pe tingi foo e kon.” ");
INSERT INTO djkNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Soseefi Masaa Jesesi taki go doo taki: “Te di ala a hii banowtu ten ya o pasa, ‘da a san fesi o dunguu. Da a mun ná o kiin peesi moo tu. Da den sitali di de a tapu o komoto a den peesi kai. Soseefi ala sani fu tapu o seke komoto a den tanpeesi.’ ");
INSERT INTO djkNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Bakadati, da wan maiki o soi a tapu taki, a Manpikin di saka kon toon libisama ya e kon. Da den sama fu goontapu o biti finga anga tyali tuutuu te, da den á sabi san fu du. Bika a o kon anga ala a makiti, anga ala a dyendee di Masaa Gadu abi. ");
INSERT INTO djkNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Soseefi, da wan gaan tutu o piki a tapu tu. Da a o sende den Basiya fu Masaa Gadu Kondee di e dini en, kon a goontapu, fu piki ala den sama fi en, puu na ala uku fu goontapu tyai kon ne en.” ");
INSERT INTO djkNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","We, ne Masaa Jesesi taigi den baka taki: “A figasii bon sa leli u wan sani. Te den taka fu a bon ya kengi teke nyun uwii, da u sabi taki, moi ten fu a yali e kon. ");
INSERT INTO djkNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","We, te u si ala den sani di mi taki ya e pasa tu, da u mu sabi taki, kaba yuu fu goontapu de koosube fu kon tu. ");
INSERT INTO djkNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Fu tuutuu mi e taigi u, den paansu sama ya ná o dede fosi den sani di mi e taigi u ya pasa. ");
INSERT INTO djkNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Bika goontapu anga ala taa sani, di de sa kaba wan dei. Ma den wowtu di mi taki o tan go doo, fu tego.” ");
INSERT INTO djkNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Soseefi Masaa Jesesi soi den ete taki: “Ala san mi taki ya o pasa. Ma sama á sabi a dei di den o pasa, boiti mi Tata, Masaa Gadu a tapu wawan. A Manpikin seefi anga den Basiya fu Masaa Gadu Kondee di e dini Masaa Gadu seefi á sabi a dei tu. ");
INSERT INTO djkNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ma mi sa taigi u namo fa ala sani o waka a goontapu fosi a konbaka fu a Manpikin di saka kon toon libisama ya. Sani o waka enke fa a be waka na a ten fu Nowa. ");
INSERT INTO djkNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Den sama á be wani teke a wasikoi fu Nowa. Ma den be e libi takuu go doo, enke fa den be gwenti. Soso nyan anga diingi anga toow sani be de a den ede. Ma wan dei, ne Nowa doo ede saa, go a ini a gaan boto di a be meke. ");
INSERT INTO djkNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Toku den sama á be teke a wasikoi ete taki, sani o kon miti den. We, ne gaan alen kai tyai wataa kon sungu goontapu, kaba den a soso. Na soseefi o pasa a goontapu, fu te enke a Manpikin di saka kon toon libisama ya sa daai kon doo baka tu. ");
INSERT INTO djkNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“A yuu di a o kon, da yu o abi tu manengee de makandii e wooko goon. Te fu den denki, da a o teke wan, ma a taawan a o fika a baka ya. ");
INSERT INTO djkNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Soseefi, tu uman seefi o de makandii e mii bolon. Te fu den denki, mi teke wan, ma a taawan a o fika a baka ya. ");
INSERT INTO djkNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","We, da u dati sabi fa sani o waka kaba. Da u mu de seeka seeka kele kele, sidon anga ain e luku mi. Bika u á sabi on dei na a dei, di a Masaa fu u o kon baka. ");
INSERT INTO djkNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Bika kon u taki, wan sama be sa sabi on yuu fu neti fufuuman o kon fufuu en, da i denki a á be sa de anga ain e lulu en? ");
INSERT INTO djkNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Weeno! Ma u dati á sabi on yuu a Manpikin di saka kon toon libisama ya o kon baka. Na dati meke u mu de anga ain, seeka seeka e luku en. Bika a o kon wan yuu di u á poti pakisei.” ");
INSERT INTO djkNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Soseefi Masaa Jesesi taki ete taki: “U aliki ya! Wan masaa fu wan osu be fika en hii osu a baka gi wan futuboi, fu gi ala taa sama a ini a osu nyanyan, na a leti yuu. A futuboi ya be e wooko fitoow fasi, soseefi ai wooko leti. ");
INSERT INTO djkNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","We, te a masaa kon doo baka, da seigi o de gi a futuboi de. A masaa o pai en gaan paiman, efu a si taki: ‘Aai! A futuboi ya e wooko enke fa a fiti gi mi.’ ");
INSERT INTO djkNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Da fu tuu, mi e taigi u, a masaa de o poti a futuboi toon a basi di e luku ala en gudu gi en. Na so a masaa ya o du. ");
INSERT INTO djkNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ma meke u taki, a futuboi be pakisei takuu taki: ‘Mi masaa ná o kon ete.’ Namo, ne a go bigin nyan, diingi makandii anga duunguman. Soseefi ai fon den taawan a ini a osu fu a masaa. Da san be o pasa anga en? ");
INSERT INTO djkNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","We, da a masaa be o kon wan dei di a futuboi ya á poti pakisei. Bika a futuboi seefi á be sabi on dei a masaa o kon baka. ");
INSERT INTO djkNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Da a masaa be o gi en a seefi sitaafu di ala takuu ati sama mu kisi. Dati wani taki, enseefi o biti finga na a peesi pe soso kaw tifi anga tyali de.” ");
INSERT INTO djkNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","We, ne Masaa Jesesi gi den wan ageisi toli, fu soi fa a Nyun Tii fu Masaa Gadu tan. A taki: “A Nyun Tii fu Masaa Gadu a tapu gei tin pikin umanpikin, di mu go teke a man di o toow fu tyai kon a pe a toow uman de. We, ne den seeka teke den lampu, ne den e go. ");
INSERT INTO djkNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","3","Ma namo, da feifi fu den be waka wan don fasi. Bika, den tyai den lampu, ma den á tyai oli moo enke di de a ini den lampu namo. ");
INSERT INTO djkNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma den feifi taawan be waka wan koni fasi anga ala fusutan. Bika boiti a oli di de a ini den lampu, da den tyai taa oli ete a ini bataa. ");
INSERT INTO djkNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","“We, na so den go miti a man di o toow. Ma di den go, da a man daai daai wan pisiten fosi a kon. Na so den de ape te, siibi bigin kii den. Ne den kai a siibi. ");
INSERT INTO djkNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","We, ne den siibi te, mindii neti, ne den yee wan balibali taki: ‘U opo! U opo! A toow man e kon. U opo go miti en.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“We, ne ala den tin pikin umanpikin opo gwugwulu. Ne den kisi den lampu fu den, wai kon seeka poti bun. ");
INSERT INTO djkNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","We, ne den di be waka wan don fasi akisi den taawan taki: ‘Gaantangi, baa! U gi u afu fu a oli fu u. Bika wi lampu e dede.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ma den koni wan piki den taki: ‘Nono baa! U ná o abi ipi sai, da fu wi seefi o kaba. A moo betee useefi go a den seliman, go bai.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ma fa i si den gwe taki, den o go bai a oli, ne a toow man doo. Ne den feifi di be waka wan koni fasi, go anga en na a toow osu. Ne den sooto a doo. ");
INSERT INTO djkNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“We, ne te wan pisi, ne den taawan di be go bai oli kon doo. Ne den de ape e koko doo e bali taki: ‘Masaa! Masaa! Gaantangi, opo doo gi wi baa.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma a piki den taki: ‘Kweti! Mi á sabi u!’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Ne a taigi den baka taki: ‘U de na kaba kaba alaten. Bika u á sabi a yuu, di mi o daai kon a goontapu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Namo Masaa Jesesi teke ete wan ageisi toli, fu soi fa a Nyun Tii fu Masaa Gadu o waka. A taki: “Wan gaan masaa be de ne en kondee. Ma namo, da a be o go a wan taa kondee. Ma, fosi a gwe, ne a kai den wookoman fi en poti, ne a poti den fu luku den gudu fi en. ");
INSERT INTO djkNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A gi wan fu den feifi miliyun kolu. Di fu tu a gi tu miliyun. Di fu dii, a gi wan miliyun. A gi den a moni leti enke fa a sabi taki, ibiiwan fu den abi a koni fu wooko anga moni. Ne di a kaba, ne a go a taa kondee. ");
INSERT INTO djkNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Fa i si a gwe, ne a wookoman di a be gi feifi dunsu go wooko anga a moni wanten. Ne a wooko anga en, te enke a fende feifi miliyun moo poti a tapu. ");
INSERT INTO djkNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Soseefi, a wookoman di a gi tu miliyun go wooko anga fi en tu. Namo a tu miliyun fi en puu ete tu miliyun wini kon a tapu gi en tu. ");
INSERT INTO djkNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ma a wookoman di meke di fu dii, teke di fi en moni di a masaa fika gi en, ne a diki wan gaan olo, ne a beli en a ondoo doti. ");
INSERT INTO djkNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ma baka wan langa pisiten, ne a masaa fu den daai kon baka. Ne a kai den kon, fu piki en, fa den wooko anga a moni di a be fika gi den. ");
INSERT INTO djkNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ne di a be fika feifi miliyun kolu gi, kon doo. Ne a langa a tin miliyun kolu gi a masaa taki: ‘Masaa! A feifi miliyun kolu di i be fika gi mi, de ya. Mi wooko anga en, ne i si mi fende feifi miliyun kolu poti a tapu ete. Da yu á si luku a tin miliyun kolu ya.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ne a masaa piisii, te ná sipowtu. Ne a taki: ‘Ai boi! Yu na wan bunbun fitoow wookoman! Fu di i wooko so bun anga a pikin sani di mi be gi yu de, meke mi o poti wan moo gaan gudu fu mi a ini yu ana, fu luku. Da pasa kon a ini meke u piisii makandii.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“We, ne baka fu dati, ne a taawan di meke tu, di a be fika tu miliyun kolu gi, kon doo. A taki: ‘We, Masaa! Luku a moni fi yu ya. I be fika tu miliyun kolu gi mi. Da mi wooko anga en te, a puu ete tu miliyun kolu a tapu. Da luku a moni fi yu ya.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Namo a masaa piki en taki: ‘Ai boi! Yu na wan bunbun fitoow wookoman. Fu di yu wooko so bun anga a pikin gudu di mi be fika gi yu, meke mi o poti wan moo gaan gudu fu mi a ini yu ana. Pasa kon a ini ya, fu nyan piisii anga mi makandii.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“We, ne di fu meke dii, di a be gi wan miliyun seefi wai kon doo. Ne a taki: ‘We, Masaa! Fa i de ya, mi sabi taki, i na wan ogii sama. Yu e koti sani a pe yu á paandi. Da i lobi piki sani a pe yu á be tyatya sii. ");
INSERT INTO djkNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Da di mi sabi so fi yu kaba, mi feele. A dati meke mi go diki olo, ne mi beli a moni fi yu. Da yu á si, luku a moni fi yu ya!’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“We, di a wookoman ya taki so, ne a masaa ati boon. Ne a piki en taki: ‘Yu lesi, takuu ati man, yu! Di i sabi taki, mi e koti sani a pe mi á paandi, mi e piki sani a pe mi á tyatya, ");
INSERT INTO djkNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","da i be sa tyai a moni fu mi go poti a banku gi mi, fu a puu wini gi mi? Bika moni a banku e goo.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Ne a masaa daai, ne a sende den taa wookoman fi en taki: ‘U puu a wan miliyun de ne en ana, da u gi a wookoman fu mi, di abi tin miliyun kaba.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Bika a sama di abi, ne en den o gi moo. Da a o abi te a pasa maiki. Ma a sama di ná abi seefi seefi, da a pikinso di a abi seefi, den o puu ne en ana, meke a fika anga soso ana. ");
INSERT INTO djkNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne a taigi den wookoman fi en taki: ‘U teke a soso, kaba a soso wookoman ya towe go na a gaan dunguu anda! Da na soso pina anga balibali kaw tifi de anda!’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ne Masaa Jesesi taigi den taki: “Te a Manpikin di saka kon toon libisama ya o daai kon a goontapu baka, da a o kon anga ala den Basiya fu Masaa Gadu Kondee*f16*. Soseefi ala a hei anga dyendee di Masaa Gadu abi, fu sidon tii ala sani ne en kownu bangi. ");
INSERT INTO djkNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Da ala foluku fu goontapu o de ne en fesi. Da a o paati den a tu, leti enke fa wan soluguman fu sikapu e paati den sikapu anga den boko boko. ");
INSERT INTO djkNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Da den sikapu o de ne en leti ana se. Da den boko boko o de ne en kukutu ana se. ");
INSERT INTO djkNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Da a Kownu o taigi den di de ne en letise ana taki: ‘U kon ya! Masaa Gadu, mi Tata du u gaan bun. Bika senten di a be meke goontapu, ne a be seeka a peesi ya ne en se kaba, fu poti u. Da u kon teke en fu tan. ");
INSERT INTO djkNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bika den dei di mi be de gi angii e kii, u be gi mi sani fu nyan. Di wataa be moo mi, u be gi mi wataa mi diingi. Di mi be de enke wakaman sondee tanpeesi, u be teke mi oli a osu. ");
INSERT INTO djkNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Di mi be de piipii sondee koosi a sikin, u be teke koosi gi mi, mi wei. Di mi be siki, u be kon luku mi, solugu mi. Di mi be de a dunguu osu, u be kon luku mi.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Da den sama ya, di be e libi letiopu, da a sani ya o bigi gi den te, da den o akisi taki: ‘We, Masaa! On yuu u be si angii e kii yu, ne u be gi yu sani fu nyan? On yuu u be si wataa be moo yu, ne u be gi yu wataa? ");
INSERT INTO djkNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","On yuu u be si yu enke wakaman a wan peesi sondee tanpeesi, ne u be teke yu oli a u osu? On yuu u be si yu piipii sondee koosi a sikin, ne u be gi yu koosi? ");
INSERT INTO djkNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Masaa! On yuu u be si yu sikisiki ofu si yu a dunguu osu, ne u be kon luku yu?’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Da a Kownu o piki den taki: ‘Fu tuu! Ala den bun di u be e du gi pooti baala fu mi, da na miseefi u be du den gi de.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Da te a Kownu kaba taki anga den so, da a o daai taki anga den sama di de ne en kukutu ana se. Da a o taigi den taki: ‘U wai komoto a mi fesi ya! U fuuku sani u! U go na a faya di e boon tego, di be seeka poti gi didibii anga den takuu jeje fi en. ");
INSERT INTO djkNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bika mi be de anga angii, u á be gi mi sani fu nyan. Wataa be moo mi, u á be gi mi wataa fu diingi. ");
INSERT INTO djkNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mi be de enke wakaman, ma u á be teke mi oli a u osu. Mi be de piipii sondee koosi a sikin, u á be gi mi koosi fu wei. Mi be siki, soseefi mi be de a dunguu osu, ma u á be kon luku mi.’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Da den o piki a Kownu taki: ‘Oho! Masaa, on yuu u be si yu anga angii, sondee fu gi yu nyanyan? On yuu wataa be e moo yu, ma u á be e gi yu wataa? On yuu i be tan enke wakaman, ma u á be teke yu poti a osu? On yuu i be pina fu koosi, ma u á be solugu yu anga koosi? On yuu i be siki, ne u á be solugu yu? On yuu i be de a dunguu osu, ne u á be kon luku yu?’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","We, da a Kownu o piki den taki: ‘Fu tuu! Fa u á be yeepi den pootisama fu mi, da na mi seefi u á be yeepi de!’ ");
INSERT INTO djkNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Da na so den sama di nái libi leti gi Masaa Gadu o go teke a sitaafu fu tego. Ma den di e libi letiopu gi en, o fende libi tego a Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Baka di Masaa Jesesi kaba anga den toli ya, ne a taigi den bakaman fi en wan sani ");
INSERT INTO djkNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","A taki: “Enke fa u de, da u sabi taki taa tamaa, da wi o fii a Pasika Fesa. Da den o kisi a Manpikin di saka kon toon libisama ya, tyai go gi sama, den sipikii a koloisi kii.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","We, ne a seefi yuu ten de, da den hei apaiti begiman anga den gaansama fu kondee be ali kon makandii a ini a osu fu a moo hei apaiti begiman di den e kai Kayafasi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Den de ape e fiti anga denseefi fa fu du fu kisi Masaa Jesesi a wan koni fasi tyai go kii. ");
INSERT INTO djkNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma son fu den taki: “Den mu luku bun fu den á kisi Masaa Jesesi na a Pasika Fesa. Bika, da a o tyai gaan opuulu a ini a kondee.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma namo, da den Masaa Jesesi doo na a kondee di den e kai Betaniya. Ne den go na a osu fu Simon a Gwasiman, go nyan. ");
INSERT INTO djkNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ma namo, di den sidon fu nyan, ne wan uman kon doo anga wan moi bataa anga wan gaan dii sumee switi fatu a ini. Ne a waka langa langa, te a Masaa Jesesi, a pe a sidon na a tafaa. Ne a kandi a apaiti fatu a Masaa Jesesi ede anga ala fa a sidon a tafaa fu nyan de. ");
INSERT INTO djkNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma a sani di a uman du ya, á bun gi den bakaman fu Masaa Jesesi seefi seefi. Ne den taki: “Saide meke a towe a dii switi fatu de poli so du? ");
INSERT INTO djkNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bika a be sa moo bun, a be seli a fatu ya puu tyaipi moni. Da den be sa yeepi den pootiman anga a moni ya.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma di Masaa Jesesi si den e taki, ne a sabi kaba san den e taki. Ne a taigi den taki: “San u fende fowtu na a uman ya? Meke mi taigi u. A á du ogii, ye! Ma na wan gaan bun a du gi mi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Bika pootiman o de ya gi u alaten, fu u solugu. Ma mi ná o de anga u ya alaten. ");
INSERT INTO djkNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bika a switi fatu di a uman kandi a mi ede ya, da na mi sikin a seeka so a fesi, fu a beli di den o beli mi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","We, fu tuu, mi e taigi u! Ala se fu goontapu pe den sa taki fu a Bun Nyunsu fu mi, den sa taki fu a gaan bun di a uman ya du gi mi ya tu.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","We, ne Judasi Iskaliyotu, wan fu den twalufu bakaman fu Masaa Jesesi opo vun. Ne tyaa tyaa, fu te a den hei apaiti begiman fu a Mama Keliki. ");
INSERT INTO djkNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ne a akisi den taki: “San u o pai mi, efu mi meke moiti gi u, fu u kisi en?” Ne den piki en taki: “We, u sa gi yu diitenti pisi solufu moni.” Ne den pai en moi, te a kaba. Ne a gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ne fanafu a dei de, ne ai suku wan bun okasi, fu a meke den kisi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","We, da na a fosi dei di den Dyu be e bigin fu nyan a beele sondee sowda na a Pasika Fesa, ne den bakaman fu Masaa Jesesi kon ne en. Ne den akisi en taki: “Masaa! On se i wani u seeka peesi gi yu fi i nyan a Pasika Fesa?” ");
INSERT INTO djkNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne a piki den taki: “U go na a kondee di de leti a u fesi so, da u go a sowan sowan sama. Da u taigi en taki: ‘A yuu fu Masaa doo. A wani kon nyan a Pasika Fesa a yu osu, makandii anga den bakaman fi en.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","We, ne den bakaman go du enke fa Masaa Jesesi sende den. Ne den seeka, te a kaba, fu go nyan a Pasika Fesa. ");
INSERT INTO djkNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ne di sapaten, ne Masaa Jesesi anga den twalufu bakaman fi en sidon makandii a tafaa, fu nyan. ");
INSERT INTO djkNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Da di den e nyan, ne Masaa Jesesi taki: “Fu tuu! Wan fu u ya o seli mi poti a ini den sama ana, den feyanti fu mi.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","We, di Masaa Jesesi taki so, ne gaan tyali kisi den bakaman fi en, te ná sipowtu. Ne ibiiwan fu den bigin akisi en taki: “Masaa! A sa de taki, na mi o seli yu?” ");
INSERT INTO djkNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Namo a piki den taki: “We, na a sama di mi anga en dipi beele go a ini a seefi baafun. Ne en o seli mi so. ");
INSERT INTO djkNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","We, a de so taki, den apaiti takiman fu Masaa Gadu be sikiifi somen sani fu a Manpikin di saka kon toon libisama ya. Da ala den sani de fiya mu pasa enke fa den be taki. Ma, heelu fu a sama di o seli a Manpikin di saka kon toon libisama ya! A moo betee, a á be meke kon a ondoo goontapu wan dei.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","We, ne Judasi, a man di o seli en akisi en taki: “We, Mesiti! A sa de taki na mi?” Ne Masaa Jesesi piki en taki: “Na leti enke fa i seefi taki de, na so a de.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma di den e nyan te wan pisi, ne Masaa Jesesi teke wan beele. Ne a gi Masaa Gadu daa, te a kaba. Ne a booko en pisipisi, ne a gi den bakaman fi en. Ne a taigi den taki: “U teke a beele ya nyan! Bika a beele ya na mi sikin.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ne bakadati, ne a teke wan kan win. Ne a gi Masaa Gadu daa baka, te a kaba. Ne a kandi gi den bakaman fi en taki: “Luku ya! U diingi! ");
INSERT INTO djkNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Bika a win ya na mi buulu di o lon, fu Masaa Gadu sa meke wan nyun kuudei anga libisama. Na a buulu ya o lon gi somen sama, fu gi den paadon fu takuudu anga ogii.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne a taigi den baka taki: “Fu tuu, mi e taigi u! Mi ná o diingi win na a fasi ya moo, fu te enke mi anga u miti baka a ini a Nyun Tii fu mi Tata. Na anda u sa diingi en makandii baka, ma na wan hii nyun sowtu fasi.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Namo, di den nyan te den kaba, ne den singi wan singi gi Masaa Gadu gaandi. Ne den opo komoto de e gwe na a mongo, di den e kai Oleifi Mongo. ");
INSERT INTO djkNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","We, ne Masaa Jesesi taigi den taki: “U si a neti ya? U ala fiya o lowe gwe fika mi, enke fa Masaa Gadu Buku taki. Bika a sikiifi taki: ‘Te mi o kii a soluguman fu den sikapu, da ala den sikapu o lon panya panya gwe na ala se.’ ");
INSERT INTO djkNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ma, te mi o weki baka, da mi sa waka go a u fesi a Galileya Kondee.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Namo, di Masaa Jesesi taki so, ne Peitilisi piki wanten taki: “Masaa! Winsi ala den taawan ya o lowe gwe fika yu, mi dati noiti o fika yu.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Namo Masaa Jesesi piki en baka taki: “Peitilisi! Fu tuutuu! Yu seefi o si tide neti. Bika fosi kaka bali, na yu ya seefi o lei kaba taki, yu á sabi mi, te dii boo seefi.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Namo Peitilisi piki en baka taki: “Kweti! Mi fu taki dati? Winsi mi mu dede anga yu seefi, mi ná o sitee taki mi á sabi yu.” We, ne ala den taa bakaman fu Masaa Jesesi piki so, enke fa Peitilisi piki tu. ");
INSERT INTO djkNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","We, ne Masaa Jesesi anga den bakaman fi en e go te, den go doo a dyali di den e kai Getsemanei. Ne a taigi den taki: “U sidon ya luku mi! Mi o go so go begi!” ");
INSERT INTO djkNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne a teke Peitilisi anga den tu manpikin fu Da Sebedi, ne den waka go moo faawe a ini a dyali. Namo, a sani kon taanga gi Masaa Jesesi te, ne gaan tyali kisi en. ");
INSERT INTO djkNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne a taigi den taki: “Tuutuu tyali anga fuka moo mi te, a sa tyai dede kii mi. U tan ya anga mi! U á mu siibi!” ");
INSERT INTO djkNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ne a waka go pikinso moo faawe. Ne a kai tapu fesi a doti anda e begi taki: “Kee, mi Tata! Mi e begi i. A kan di i lai gi mi, fu diingi ya, efi i sa puu en gi mi, fu mi á diingi en, da gaantangi puu en! Ma anga ala fa mi taki ya seefi, ma a ná san mi wani mu pasa. Ma meke sani waka enke fa yu wani!” ");
INSERT INTO djkNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","We, di a kaba begi so, ne a waka kon baka a den bakaman fi en. Ma a si den kai a siibi. Ne a kai den taki: “Peitilisi! U á poi meke taanga sikin, fu de anga ain wankodo yuu langa anga mi seefi, no? ");
INSERT INTO djkNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","We, u weki oli waki! Da u begi taanga, fu didibii á wini u! Bika mi sabi taki u ati wani, ma sikin ná abi kaakiti sai.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ne a daai gwe baka go begi, di fu tu toon. A begi taki: “Mi Tata! Efu taa fasi á de, da yeepi mi, meke mi diingi a kan di de gi mi fu diingi ya. Bika na san yu wani, na dati mu pasa.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Namo a daai go baka, ne a si den bakaman fi en kai a siibi baka. Bika siibi be e hebi den ain. ");
INSERT INTO djkNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","We, ne a fika den de, ne a go begi di fu dii toon. A begi a seefi begi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","We, ne a daai kon baka a den bakaman fi en, ne a taigi den taki: “A siibi u e siibi e boo sikin so? We, a yuu de koosube, di den sa tyai a Manpikin di saka kon toon libisama ya, go poti a ini den ogii ati sama ana. ");
INSERT INTO djkNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","U opo meke u gwe! Bika a sama di o seli mi, doo koosube kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","We, Masaa Jesesi á kaba taki seefi, ne Judasi, wan fu den twalufu bakaman fi en, kon doo kaba anga wan gaan kulu sama. Den kon anga fetihow anga kodya dyagaa. Na den hei apaiti begiman anga den gaansama fu kondee sende den kon so. ");
INSERT INTO djkNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ma a man di be seli Masaa Jesesi be gi den wan maiki a fesi kaba taki: “Awan di mi o bosi, ne en u mu kisi.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ne wanten, a waka go a Masaa Jesesi, ne a gi en odi taki: “Odi oo, Mesiti!” Ne a bosi en a sikin fesi piyow. ");
INSERT INTO djkNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Namo Masaa Jesesi taigi en taki: “Mi mati! Ná daai daai! Du san i kon fu wanten!” Namo, ne den sama booko huu kon. Ne den kisi Masaa Jesesi gwullu kankan, oli fu den tyai gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma wan fu den bakaman fu Masaa Jesesi toosi ana, teke en fetihow puu a dosu, ne a iti go. Ne velen! A koti a futuboi fu a moo hei apaiti begiman yesi, puu towe a doti pow. ");
INSERT INTO djkNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma Masaa Jesesi taigi en taki: “Nono! Toosi i fetihow go a ini a saka baka! Bika a sama di teke fetihow fu feti, na fetihow sa kii den. ");
INSERT INTO djkNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Bika fa mi de ya, san i denki? Mi sa begi mi Tata, da wanten a sa sende onmen tenti dunsu Masaa Gadu Kondee Basiya*f17* fi en, kon puu mi a den sama ya ana. ");
INSERT INTO djkNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma efu mi du dati, da fa den sani di sikiifi a Gadu Buku o kon pasa tuu enke fa den be sikiifi?” ");
INSERT INTO djkNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Namo Masaa Jesesi daai taki anga den sama di kon kisi en de. A taki: “Fu saide meke u kon a mi ya anga fetihow anga kodya, fu kon kisi mi enke mi na wan gaan fufuuman? Bika ala yuu mi be de a ini a Mama Keliki e leli sama. Ma noiti u be poti ana a mi taki u be o kisi mi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ma den sani ya musu pasa, fu meke den sani di den apaiti takiman fu Gadu be sikiifi mu kon tuu.” We, wanten de, ne ala den bakaman fi en lon gwe fika en wawan de. ");
INSERT INTO djkNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Namo den sama di kisi Masaa Jesesi, tyai en go na a osu fu Kayafasi, a moo hei apaiti begiman. Da den leliman fu Dyuweiti anga gaansama fu kondee be kon de makandii, fu den tyai Masaa Jesesi kon. ");
INSERT INTO djkNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma anga ala fa den e tyai Masaa Jesesi go de, da Peitilisi seefi be e waka faawe e kon a den baka. Ne den waka te, ne den doo a dyali fu a moo hei apaiti begiman. Peitilisi seefi pasa go a ini a dyali. Ne a go sidon a ini den sama di e oli wakiti na a peesi de. Bika a be wani si fa ala sani o waka anga Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Namo, den hei apaiti begiman anga a hii Dyulanti fu kuutu e suku leilei sani poti a Masaa Jesesi neki tapu, fu den sa fende en kii. ");
INSERT INTO djkNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma anga ala fa den e piki sani fi en taki, ma den á fende ná wan sani taki, na a sani ya den fende, fu a mu dede. Te fu kaba, ne tu man dati dyombo kon a fesi, fu kotoigi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ne den bali taki: “A be gafa taki, a sa booko a Mama Keliki, da a ini dii dei a sa meke en baka.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ne vun! A moo hei apaiti begiman opo taampu. Ne a akisi Masaa Jesesi taki: “Yee san den taki fi i de. San yu abi fu piki fu dati?” ");
INSERT INTO djkNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma Masaa Jesesi á piki en. A dati meke a moo hei apaiti begiman ya akisi en baka taki: “Mi teke Masaa Gadu nen begi yu, piki wi! Na yu na a Kelestesi, a Manpikin fu Masaa Gadu?” ");
INSERT INTO djkNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Namo, Masaa Jesesi piki en taki: “We, na iseefi taki de. Da a yuu o doo, da u o si a Manpikin di saka kon toon libisama ya sidon na a leti ana fu Masaa Gadu, di abi ala taanga a goontapu. U o si a komoto a den woluku tapu anda e kon.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","We, ne di Masaa Jesesi piki so, ne a moo hei apaiti begiman ati teke faya! Ne a piiti en koosi ne en sikin. Ne a taki: “A kosi Masaa Gadu. A á de fu u suku kotoigi moo. Bika u seefi yee, fa a kosi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","San u denki u mu du anga en?” Ne den piki taki: “Taa fasi á de fu du. A dede namo a mu dede.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ne den bigin towe wataa mofu ne en fesi. Den e naki en anga kofu. Taawan e naki en anga baka ana a sikin fesi. ");
INSERT INTO djkNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Da den e deleigi en taki: “Kelestesi! I taki yu anga Masaa Gadu e taki, puu gi wi, osi? Sama naki yu?” ");
INSERT INTO djkNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","We a ten de, da Peitilisi be sidon a ini a dyali ete. Namo wan pikin uman di e wooko gi a moo hei apaiti begiman, koi kon ne en. Ne a akisi en taki: “Tan, osi? Man, yu a ná wan fu den man di be e waka anga Masaa Jesesi fu Galileya, no?” ");
INSERT INTO djkNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma Peitilisi sitee na ala den sama de fesi taki: “Sama? Mi? Nono! Mi á sabi a man di yu e taki de, kweti kweti!” ");
INSERT INTO djkNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Namo Peitilisi opo komoto de, go taampu na a dyali mofu. Ma wan taa pikin uman kon, ne a taigi den taa sama de taki: “U luku wan fu den man fu Jesesi fu Nasaleti ya!” ");
INSERT INTO djkNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Namo Peitilisi daai sitee e sweli baka taki: “Mi á sabi a sama di u e taki de, kweti kweti!” ");
INSERT INTO djkNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pikinso moo a baka, ne den sama di taampu de kon a Peitilisi, ne den taigi en taki: “Na tuu! Yu na wan fu den man di be e waka a Masaa Jesesi fu Galileya baka tuu. Bika yu e taki enke wan sama fu Galileya.” ");
INSERT INTO djkNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Namo, ne Peitilisi taki a o sitee now. Ne ai sitee, ai fuuku enseefi, ai sweli taki: “Mi e taigi u taki, a man de, mi á sabi en wan dei.” Ne di Peitilisi taki so, ne wanten, ne wan kakafoo bali kokoliyekee! ");
INSERT INTO djkNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","We, ne a pakisei a sani, di Masaa Jesesi be taigi en taki: “Peitilisi! Fosi kakafoo bali, yu o lei dii boo taki, yu á sabi mi.” We, ne gaan tyali fuu Peitilisi ati wanten, fu san a du ya. Ne a komoto a doo, poti ana a mindii ede bali wan gaan adyumadye. ");
INSERT INTO djkNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","We, ne di debooko, mamanten fuuku, ne den moo hei apaiti begiman anga den gaansama fu kondee oli wan gaan kuutu, fu luku fa den o du fu kii Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ne den bwui Masaa Jesesi te a kaba, ne den tyai en gwe a Gaaman Pilatesi di Loma lanti be poti, fu tii Dyusama. ");
INSERT INTO djkNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ma di Judasi si taki, den kuutu Masaa Jesesi taki, a mu dede, ne a sani ati en tee! A á sabi fa a mu du. Ne a teke den diitenti pisi moni di den be pai en, ne a tyai den go gi den moo hei apaiti begiman anga den gaansama fu kondee baka. ");
INSERT INTO djkNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ne a taigi den taki: “Mi du wan gaan ogii! Mi seli wan tuutuu sama sondee fowtu, fu kii towe en buulu.” Namo den piki en taki: “Di yu e kon taigi wi, da san i wani wi mu du? U ná abi bisi anga yu! Na yuseefi mu sabi san fu du anga iseefi.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ne di den taigi en so, ne a iti a moni go a ini a Mama Keliki a doti anda. Ne waka gwe, ne a lenge lenge enseefi a tetei kii. ");
INSERT INTO djkNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","We, ne den hei apaiti begiman piki a moni teke. Ne den taki: “A moni ya á bun fu poti na a keliki kasi. Bika a weiti sikiifi taki: ‘Moni di towe buulu á mu go a ini a keliki kasi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","We, ne den kai pakisei te den kaba, fa fu du anga a moni. Namo den fiti taki: “Wi o teke a moni ya go bai wan pisi doti, na a man di e meke doti patu. Da u o meke ape toon wan belipe, fu e beli doose kondee sama.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","We, ne fanafu a ten de, ne den e kai a pisi doti de, Buulu Doti te enke a dei fu tide. ");
INSERT INTO djkNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Da a hii pisi toli ya waka enke fa a fositen apaiti takiman fu Masaa Gadu den e kai Jelemija be taki, taki: “Den sama fu Islayeli Kondee oli en, fu wan sama di waiti diitenti pisi solufu moni namo. ");
INSERT INTO djkNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ne den teke a seefi diitenti pisi solufu moni de bai a pisi tokotoko doti, na a man di e meke doti patu. Na so Masaa Gadu taigi mi fu du.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","We, di den tyai Masaa Jesesi go a Gaaman Pilatesi, ne a gaaman akisi en taki: “Yu na a kownu fu den Dyusama tuu?” Namo, ne Masaa Jesesi piki en taki: “We, na iseefi taki en de kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Soseefi den hei apaiti begiman anga den gaansama fu kondee e tyai somen kaagi fu Masaa Jesesi kon a fesi. Ma Masaa Jesesi nái tufee a den seefi! ");
INSERT INTO djkNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Namo Gaaman Pilatesi akisi en baka taki: “We, yu nái yee den somen kaagi, di den sama e gi fi i de, no? Da yu nái piki, no?” ");
INSERT INTO djkNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Masaa Jesesi á piki ná wan wowtu. A dati meke a gaaman foondoo te, ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ma, da a be de so taki, te a Pasika Fesa doo, da a gaaman be abi a gwenti, fu puu wan sama di lanti wani, a dunguu osu gi den. ");
INSERT INTO djkNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma, da a seefi yuu ten de, da wan gaan ogiiman den e kai Balabasi be de a dunguu osu. ");
INSERT INTO djkNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","We, ne Gaaman Pilatesi daai, ne a taki anga den somen sama di be de ape taki: “Den sama ya! U aliki! Sama u wani mi losi, puu a sitaafu gi u? Mi losi Balabasi gi u, ofuso Jesesi, di den e kai a Kelestesi?” ");
INSERT INTO djkNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bika Pilatesi be sabi kiinkiin taki, fa den tyai Masaa Jesesi kon ne en de, na fu dyalusu ede meke den be tyai en kon. ");
INSERT INTO djkNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Namo, ne Gaaman Pilatesi go sidon na a sutuu pe ai kuutu sama. Na ape a de, ne en uman sende sama taigi en taki: “Pilatesi! Yu á mu de a ini a kuutu fu kuutu a sama di de sondee fowtu de. Bika a neti ya, da mi deen wan deen fi en di go a mi ati tuutuu.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","We, a yuu ten di Gaaman Pilatesi sidon e aliki a mofu fi en uman de, ne den hei apaiti begiman anga den gaansama fu kondee e meke moiti e dwengi den sama taki: “U piki taki, meke a losi Balabasi gi u. Ma meke a kii Jesesi.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","We, ne a gaaman akisi den sama baka taki: “On di fu den tu sama ya u wani mi losi gi u?” Namo den sama bali piki taki: “Balabasi! Na Balabasi i mu losi gi wi!” ");
INSERT INTO djkNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ne Gaaman Pilatesi akisi den taki: “Da san mi mu du anga Jesesi, di den e kai Kelestesi?” Ne den sama bali taki: “Sipikii en kii a koloisi!” ");
INSERT INTO djkNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ne Gaaman Pilatesi akisi den baka taki: “We, on ogii seefi a du?” Ho! Den sama bali moo taanga taki: “U sipikii en! U sipikii en a koloisi kii!” ");
INSERT INTO djkNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","We, di Gaaman Pilatesi kon si taki, a opuulu fu kii Masaa Jesesi e bigi naamo, ne a teke wataa, ne a wasi en ana, na ala sama fesi de. Ne a taki: “Mi wasi ana puu mi seefi a ini. Bika mi á poi kuutu sowan sama taki, en buulu mu lon. Da a fika gi u. Ala sani fi en, fika a u neki tapu.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","We, ne ala den Dyusama di be de ape bali taki: “Eeye! Meke a fika a wi anga den pikin fu wi neki tapu taki, na wi kii en!” ");
INSERT INTO djkNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Namo, ne Pilatesi losi Balabasi gi den. Ne a sende den suudati fi en, fu den fon Masaa Jesesi. Ne a gi den en, fu den tyai go sipikii kii a koloisi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Namo, den suudati teke Masaa Jesesi tyai gwe a Gaaman Dyali. Ne den kai ala den taa suudati fu den. Ne ala den fiya ali kon lontu Masaa Jesesi poti a dyali. ");
INSERT INTO djkNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ne den puu den koosi fi en, di a be wei, ne en sikin. Ne den wei wan langa lebi dyakiti enke di kownu e wei gi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ne den teke wan agwago maka, ne den lolo en, te a kaba enke kownu ati, ne den toosi ne en ede soo. Ne den koti wan pisi kamaluwa poti, ne en letise ana, fu pee enke dati na wan kownu tiki. Ne den e wisiwasi en e saka kini a doti e bali taki: “Odi oo kownu fu Dyu! Odi oo!” ");
INSERT INTO djkNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Den e towe wataa mofu ne en. Ne den puu a tiki a ini en ana, ne den e naki en anga en, ne en ede seefi, gwogwo onmen tenti leisi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","We, ne di den mesaandi en, te den kaba, ne den puu a dyakiti di den be wei gi en, teke baka. Ne den wei den seefi kosi gi en baka, di a be wei a fesi. Ne den e tyai en gwe, fu go sipikii kii a koloisi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ma di den e tyai Masaa Jesesi gwe te wan pisi, ne den miti wan man den e kai Simon fu Sileni Kondee a pasi. We, ne den dwengi en anga taanga fu a tyai a koloisi gi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","We, ne den waka te den doo na a peesi. Na a peesi ya den e kai go kai Golgata. Dati wani taki, Edebon Peesi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ne den teke win mokisa anga bita, ne den gi en, fu a diingi. Ma di a tesi en kaba, ne a á wani en. ");
INSERT INTO djkNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","We, ne den sipikii Masaa Jesesi na a koloisi. Ne den opo en taampu. Ne den teke den koosi di a be wei, ne den iti lowte luku sama anga sama o wini den koosi fi en. Ne den paati den. ");
INSERT INTO djkNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","We, di den du so te den kaba, ne den saka sidon de e oli waki a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma den be sikiifi wan sani a wan pisi paanga poti a edese fu a koloisi anda, fu saide meke den kii Masaa Jesesi. Den sikiifi taki: ");
INSERT INTO djkNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ma boiti Masaa Jesesi, da den be e kii tu taa man makandii anga en de. Wan de ne en letise, a taawan de ne en kukutu ana se. Masaa Jesesi seefi de a mindii. We, den tu taa sama de, na sama di be de gaan fufuu kiiman. ");
INSERT INTO djkNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Da somen sama be e waka e pasa de, a pe den be koloisi Masaa Jesesi. Da te den si Masaa Jesesi, da den e kosi en, e wisiwasi en, e seke ede. ");
INSERT INTO djkNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Den taki: “Yu di be taki, yu o booko a Mama Keliki meke a ini dii dei baka! We, da san meke yu á poi yeepi iseefi nownow, puu na a koloisi? Efi yu na a Pikin fu Masaa Gadu tuu, da saka komoto na a koloisi de meke u si, no?” ");
INSERT INTO djkNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Soseefi den hei apaiti begiman anga den leliman fu Dyuweiti anga den gaansama fu kondee e sipowtu e poti en wisiwasi tu. Den taki: ");
INSERT INTO djkNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“We, a be e yeepi taa sama. Ne san meke a á poi yeepi enseefi? Efu en na a kownu fu Islayeli Kondee tuu, da meke a saka komoto na a koloisi kon a doti, da u sa biibi en. ");
INSERT INTO djkNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bika a be taki, ai poti fitoow a Gadu. We, da meke Gadu yeepi en, no? Efu a wani en? Bika a be taki: ‘Mi na a Manpikin fu Masaa Gadu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","We, soseefi den tu fufuu kiiman di den be sipikii a koloisi ne en se de be e wisiwasi en, e kosi en meke sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ma fanafu twalufu yuu, mindii dei, te go miti dii yuu bakadina, ne a hii kondee dunguu pii. ");
INSERT INTO djkNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Da na a dii yuu de, ne Masaa Jesesi bali taanga taki: “Eloi, Eloi, lama sabaktani?” Dati wani taki: “Mi Gadu, mi Gadu, saide i fika mi wawan so?” ");
INSERT INTO djkNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma son fu den sama di taampu de taki: “U yee anda! Ai kai Eliya! Ai kai Eliya, fu kon yeepi en.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ne wanten de, ne wan fu den lon go teke wan siponsu, ne a dipi en go a ini wan sowtu win. Ne a poti a wan tiki ede langa gi Masaa Jesesi, fu a diingi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma den taawan bali taki: “Tan, tan, tan! Meke u luku efu Eliya o kon yeepi en tuu.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ma Masaa Jesesi bali ete wan leisi taanga, ne en boo koti. ");
INSERT INTO djkNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","We, ne a seefi yuu de, ne a gaanbigi deki koosi di be tapu a kambaa fu Masaa Gadu a ini Mama Keliki, piiti komoto a tapu, fu te a doti tyow. A fika wangang. Namo goontapu seefi e seke, e bali. Gaan siton e bali e piiti. ");
INSERT INTO djkNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Goontapu seke te, somen geebi pe den be beli sama booko opo. Namo somen sama di den be beli a den geebi de, di be de apaiti fasi gi Masaa Gadu, weki komoto a ini den geebi, kon a libi baka. ");
INSERT INTO djkNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ne den komoto a ini den geebi, di Masaa Jesesi seefi weki baka komoto a dede, di fu dii dei. Ne den go a Jelusalem, a apaiti foto fu Masaa Gadu. Somen sama si den, fa den weki baka so. ");
INSERT INTO djkNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma di a edeman fu suudati anga den suudati fi en di be e oli waki a Masaa Jesesi si, fa a goontapu seke anga ala san pasa, ne den feele te. Den taki: “A sama ya, na be a Manpikin fu Masaa Gadu tuu.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma namo, da somen uman sama seefi be taampu, te a faawe e luku, fa sani e waka anga Masaa Jesesi. Bika den uman ya be waka komoto a Galileya anga Masaa Jesesi fu solugu en naamo. ");
INSERT INTO djkNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wan fu den na Maliya fu Makidala, a taawan na Maliya, a mma fu Jakowbesi anga Jowsef anga a mma fu den tu manpikin fu Da Sebedi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ma di sapaten mofu, ne wan guduman den be kai Jowsef fu Alimateya Kondee, kon doo de. Na wan man di be e biibi a Masaa Jesesi tu. ");
INSERT INTO djkNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Namo a go a Gaaman Pilatesi go akisi en, fu a gi en pasi, fu a teke a dede sikin fu Masaa Jesesi tyai go beli. Ne Pilatesi sende den suudati fi en, go puu a dede sikin fu Masaa Jesesi na a koloisi gi en. ");
INSERT INTO djkNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Namo, ne Jowsef teke a dede sikin fu Masaa Jesesi, ne a lolo en a sibikoosi te a kaba. ");
INSERT INTO djkNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ne a tyai en go beli a wan nyun nyun siton geebi olo, di diki, a be diki fi enseefi, a wan heihei siton sikin. Di a kaba, ne a lolo wan gaan gindin siton tapu a olo mofu, ne a waka gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ma namo, da Maliya fu Makidala anga a taa Maliya be de ape tu. Den be sidon na abaase fu a geebi e luku. ");
INSERT INTO djkNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A taa dei fi en, da a dei di den be e seeka gi a kina dei fu den Dyusama pasa kaba. Ma den hei apaiti begiman anga den Faliseiman go makandii a Gaaman Pilatesi. ");
INSERT INTO djkNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ne den taki: “Masaa! U membee wan sani di a bidiigiman be taki, fosi a dede. A be gafa taki: ‘A o dede. Ma baka dii dei, a o weki baka kon a libi.’ ");
INSERT INTO djkNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Na dati meke u kon begi gaaman, fu poti suudati oli wakiti na a geebi dii dei langa. Bika efu u á du so, da den bakaman fi en sa go fufuu en, da den go lei taki, na weki a weki baka komoto a dede. Bika efu wi á du dati, da a koli ya o ogii moo fa den be e koli sama a fesi kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","We, ne Gaaman Pilatesi piki den taki: “We! U teke suudati, enke wakitiman, tyai go poti, da u seeka a geebi tapu enke fa u sa tapu en.” ");
INSERT INTO djkNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","We, ne di a gaaman gi den pasi so, ne den go tapu a geebi enke fa den poi. Den poti wan maiki ne en fu soi taki, a de tapu tapu. Ne den poti suudati e waki de. ");
INSERT INTO djkNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","We, fa i si a kina dei pasa, a fosi dei fu a wiki*f18* fuuku mamanten, ne Maliya fu Makidala anga a taa Maliya go luku a geebi fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma namo, da doti be seke te, ná sipowtu. Bika wan Basiya fu Masaa Gadu Kondee*f19* saka komoto a tapu anda kon na a geebi. Ne a puu a gaanbigi siton di be tapu a olo mofu. Ne a sidon na a siton de tapu. ");
INSERT INTO djkNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A Basiya ya fesi be e koti faya enke te tapu e koti faya. Da den koosi fi en sikin weti fann enke sukuma. ");
INSERT INTO djkNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","We, ne den suudati di be de ape e waki feele te, den e beifi. Namo den de pii enke den dede. ");
INSERT INTO djkNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","We, ne a Basiya bigin fu taki anga den tu uman taki: “Uman! U á feele so! Mi sabi taki na Masaa Jesesi, di den sipikii kii a koloisi u e suku. ");
INSERT INTO djkNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","We, a á de ya moo! A weki baka leti enke fa a be taigi u fosi, a be dede. U kon luku pe den be poti en a ini a geebi. U si? Sama á de ape moo. ");
INSERT INTO djkNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Da u daai go esi baka a osu, fu taigi den bakaman fi en taki, a weki baka komoto a dede. Da a o waka a den fesi go a Galileya. Na anda en anga den o miti, enke fa a be taigi den. We, da na so mi soi u kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","We, na so den uman ya daai gwe baka. Ne den pantan te, ma toku seefi den e piisii gaan piisii. Ne den e lon go, fu tyai a nyunsu ya go gi den bakaman fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma, te fu den membee, ne den anga Masaa Jesesi seefi miti a pasi haa! Ne Masaa Jesesi gi den odi taki: “Den uman ya, u weki oo!” We, ne den waka go miti Masaa Jesesi, ne den saka kini a doti ne en fesi, ne den kisi en futu e baasa. ");
INSERT INTO djkNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Masaa Jesesi taigi den taki: “Uman! U á feele. Ma u go taigi den baala fu mi taki, meke den go a Galileya. Da na anda mi anga den o miti.” ");
INSERT INTO djkNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","We, a yuu di den uman ya de a pasi e gwe, ne son fu den suudati komoto a pe den be e oli waki na a geebi. Ne den go a ini a foto, ne den taigi den hei apaiti begiman ala san pasa a pe den be e oli waki, na a geebi. ");
INSERT INTO djkNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","We, di den hei apaiti begiman yee so kaba, ne den kai ala den gaansama fu kondee kon makandii anga den. Ne den kuutu, te den kaba. Ne den pai den suudati wan gaan moni. ");
INSERT INTO djkNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ne den taigi den taki: “We, u aliki! U mu piki sama taki, u be kai a siibi, ne den bakaman fi en kon fufuu en tyai gwe. ");
INSERT INTO djkNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bika efu a taki ya doo gaaman yesi, da wi sabi fa wi o taki anga en, fu koo en ati, fu u á kisi sitaafu.” ");
INSERT INTO djkNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","We, ne den wakitiman teke a moni, ne den e taki leti enke fa den hei apaiti begiman be taigi den, fu den taki. Da enke fa den e taki en de, na so den Dyusama teke en e taki, te doo tide ete seefi. ");
INSERT INTO djkNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","We, ne den elufu bakaman fu Masaa Jesesi go a Galileya Kondee. Ne den go na a mongo, di a be taigi den a fesi fu den go. ");
INSERT INTO djkNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ne di den si en, ne den sutu kini a doti ne en fesi, ne den begi en. Ma son fu den be e tan enke den á be wani biibi. ");
INSERT INTO djkNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","We, ne Masaa Jesesi waka kon a den. Ne a taigi den taki: “Mi kisi ala makiti a Masaa Gadu Kondee a tapu anda anga goontapu ya. ");
INSERT INTO djkNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Da u go a hii goontapu, fu go paati a bosikopu gi ala foluku. Meke den daai kon toon bakaman fu mi. U dopu den a ini a nen fu a Tata, a nen fu a Manpikin anga a nen fu a Apaiti Jeje fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Da u leli den, fu den oli ala san mi be leli u. Da fu tuu! Mi de anga u alaten, fu te na a kaba fu goontapu!”");
INSERT INTO djkNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Disi na a bigin fu a Bun Nyunsu fu Jesesi Kelestesi, a Manpikin fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Enke fa Jesaja, wan apaiti takiman fu Masaa Gadu be sikiifi a fositen taki: “Mi Masaa Gadu ya o sende mi bosikopuman go a fesi, fi yu. Da dati o seeka pasi gi yu. ");
INSERT INTO djkNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Da a tongo fu wan bosikopuman o bali a ini a gaan sabana taki: ‘U seeka pasi gi a Masaa, meke a pasi sa kon taampu letiopu tollo.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Da Johanisi a Dopuman de a ini a gaan sabana e bali den sama fu kon teke dopu, fu daai libi. Meke Masaa Gadu sa gi den paadon, fu takuudu anga ogii. ");
INSERT INTO djkNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Hii Judeja anga ala sama fu Jelusalem kon a Johanisi. Da, te den begi Masaa Gadu paadon fu ala den takuudu anga ogii fu den, da Johanisi e dopu den a ini Joodani Liba. ");
INSERT INTO djkNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johanisi seefi, be wei koosi di be meke anga a uwii fu a meti di den e kai kameili. Da a be e wei wan banti, di meke anga meti buba ne en nekilasi. Da na makonkon anga bosi oniki na be en nyanyan. ");
INSERT INTO djkNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Da a be e bali bosikopu taki: “Awan di o kon a mi baka, makiti bigi moo mi. Mi á dyendee sai, fu bendi losi en susu puu a futu gi en seefi. ");
INSERT INTO djkNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mi e dopu u anga wataa! Ma en dati o dopu sama anga a Apaiti Jeje.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Da a seefi yuu de, ne Masaa Jesesi komoto a Nasaleti, na a pisiwataa fu Galileya kon, ne Johanisi dopu en a ini a Joodani Liba. ");
INSERT INTO djkNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Da di Jesesi e komoto a ini a wataa, ne a si, tapu a den woluku piiti opo palan. Ne a si a Jeje fu Masaa Gadu e kon ne en tapu enke wan doifi. ");
INSERT INTO djkNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne wan Tongo taki a tapu anda taki: “Yu na mi Manpikin di mi lobi. Mi hii ati e piisii anga yu.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Da wanten wanten, di Masaa Jesesi dopu, ne a Jeje fu Masaa Gadu tyai en gwe a ini a gaan sabana. ");
INSERT INTO djkNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Da, di Masaa Jesesi de a ini a sabana, ne saatan, a didibii kon. Ne a tesi en fotenti dei anga neti langa. Da, den ogii meti fu a sabana be de ape tu. Ma den Basiya fu Masaa Gadu Kondee*f1* be de anga Masaa Jesesi, e yeepi en. ");
INSERT INTO djkNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Da di den sooto Johanisi a Dopuman ne Masaa Jesesi daai go a Galileya, go e gi den sama a Bun Nyunsu. ");
INSERT INTO djkNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A taki: “A yuu doo, di a Nyun Tii fu Masaa Gadu kon de koosube. Da daai libi, fu biibi a Bun Nyunsu fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Da wan dei di Masaa Jesesi e waka pasa na a sikin liba fu a ze fu Galileya, ne a si tu man e towe seepi. Wan fu den man ya na Simon. Da a taawan ne en baala Andeleyasi. Da na sete seepi kisi fisi, na den wooko di den be e du kaba. ");
INSERT INTO djkNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ne Masaa Jesesi taigi den taki: “U kon waka a mi baka! Mi sa leli u fa fu kisi libisama pe fu kisi fisi.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ne wanten wanten, den fika den seepi, ne den bigin waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ne, di Masaa Jesesi waka go pikinso moo faawe, ne a si ete tu fisiman, Jakowbesi anga Johanisi, den tu manpikin fu Da Sebedi. Den be de a ini wan boto e seeka den seepi. ");
INSERT INTO djkNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ne Masaa Jesesi kai den wanten fu den kon waka ne en baka. Ne den fika den dda, Da Sebedi anga den wookoman a ini a boto, ne den waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ne den gwe a Kafalnayemu. Ma namo, di a kina dei fu den Dyu doo, ne Masaa Jesesi go a ini wan fu den Dyu keliki. Ne a bigin leli den sama Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Da den sama foondoo, fu a fasi fa ai gi leli fu Masaa Gadu. Bika a á be e leli den enke fa den leliman fu Dyuweiti gwenti leli den. Ma a be e leli den, enke wan sama di sa sidon taki a Masaa Gadu peesi. ");
INSERT INTO djkNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Da a yuu de, da wan man be de a ini a keliki osu de anga wan takuu jeje ne en tapu. Ne a bali taki: ");
INSERT INTO djkNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“San wi anga yu abi, Jesesi fu Nasaleti? A kon i kon fu poli wi kaba a soso? Mi sabi sama a yu! Yu na a Apaiti Sama fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Masaa Jesesi kaasi en taki: “Tapu mofu! Komoto ne en tapu wanten!” ");
INSERT INTO djkNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ne a takuu jeje subi te en sikin e dansi. Ne a bali taanga komoto gwe. ");
INSERT INTO djkNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ala sama fiya foondoo. Taawan e akisi taawan taki: “San a disi? Disi na wan nyun leli anga makiti fu Masaa Gadu! Ai kaasi den takuu jeje, da den e gwe tuu.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Da a sani di Masaa Jesesi du ya, paati na a hii pisiwataa fu Galileya. ");
INSERT INTO djkNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Da, baka di den komoto na a keliki osu, ne den go wanten na a osu fu Simon anga Andeleyasi. Da Jakowbesi anga Johanisi go anga den tu. ");
INSERT INTO djkNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Da a main fu Simon de a bedi anga feba. Da di den doo na a osu, ne den taigi Masaa Jesesi fu a siki fi en. ");
INSERT INTO djkNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ne Masaa Jesesi waka go ne en. Ne a oli en ana yeepi en fu a opo sidon. Ne wanten wanten a mma kon bun kelle fu a feba. Ne a seeka sani gi den fu den nyan. ");
INSERT INTO djkNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ne di sapaten, di san go a ondoo, ne den tyai somen sikisama anga sama di be abi takuu jeje a den tapu, kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Da a hii foto ali kon na a osu doo mofu pe Jesesi be de. ");
INSERT INTO djkNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ne Masaa Jesesi deesi somen sama di be abi ala sowtu siki. Da soseefi a yaki somen takuu jeje puu a sama tapu. Ma Masaa Jesesi á gi den pasi fu taki, bika den sabi sama ne en. ");
INSERT INTO djkNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mamanten fuuku, fosi san opo, ne Masaa Jesesi go a wan koo peesi, pe en wawan be sa de fu begi taki anga Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon anga den taa bakaman e suku pe a de. ");
INSERT INTO djkNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ne, di den fende en, ne den taigi en taki: “Ala sama e suku yu.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ne Masaa Jesesi piki den taki: “Meke u go a den taa kondee di de koosube ya. Mi mu paati a Bun Nyunsu fu Masaa Gadu anda tu. Bika na fu dati ede mi kon a goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Da na so Masaa Jesesi go paati a Bun Nyunsu fu Gadu a ini den keliki fu a hii pisiwataa fu Galileya. Da soseefi a yaki takuu jeje puu a sama tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ne wan gwasiman kon a Masaa Jesesi. Ne a kai ne en kini tapu e begi Masaa Jesesi taki: “Masaa Jesesi! Mi sabi taki efi i wani i sa deesi, baa.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ne tyali fu a man kisi Masaa Jesesi. Ne a langa ana, ne a oli en. Ne a taigi en taki: “Mi wani! Kon bun!” ");
INSERT INTO djkNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ne wanten wanten, ne a man kon bun kelle. A gwasi siki komoto ne en sikin gwe fiyaa. ");
INSERT INTO djkNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ne Masaa Jesesi sende a man ya gwe. Ne a bali en taanga taanga taki: ");
INSERT INTO djkNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Yu á mu taigi ná wan sama a sani di pasa ya, ye! Ma pe fu dati, go a den hei apaiti begiman fu keliki, meke a si yu taki, i kon bun tuutuu. Tyai a paiman fu Gadu enke fa a weiti fu Mosesi e taki. Da den sama anda sa si taki i kon bun tuutuu.” ");
INSERT INTO djkNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma, di a man gwe, ne ai taki fa Masaa Jesesi deesi en. A paati a bosikopu na ala peesi te, Masaa Jesesi nen bali na ala peesi. Da winsi pe fu a kondee di Masaa Jesesi be go, sama be e kon ne en tyaipi. A dati meke a be e tan a peesi pe sama á be ipi. Ma toku seefi sama be e komoto na ala se e kon ne en. ");
INSERT INTO djkNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Da wantu dei a baka, ne Masaa Jesesi daai kon baka a Kafalnayemu. A á de ape langa seefi fosi a hii foto yee taki a de ape. ");
INSERT INTO djkNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Da somen sama kon te, ná wan peesi be de a ini a osu moo. A doo mofu seefi fuu kwaa. A be e gi den sama a wowtu fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ne fo man poti wan lanman a wan daagi tapu, tyai kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma fu di sama be ipi so, meke den á be poi doo. Ne den subi go na a osu tapu. Ne den booko wan olo na a osu tapu leti a pe Masaa Jesesi be taampu. Ne den saka a lanman anga a daagi pasa na a olo, go a Masaa Jesesi a doti anda. ");
INSERT INTO djkNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Da, di Masaa Jesesi si a biibi fu den man ya, ne a taigi a man taki: “Mi mati, ná feele! Mi gi yu paadon fu ala yu takuudu anga ogii kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Da wantu leliman fu Dyuweiti be sidon e aliki en tu. Da di den yee Masaa Jesesi taki so, ne den taki a ini den ati taki: ");
INSERT INTO djkNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Fa a man ya e taki so wan sani? Ai oli Gadu a sipowtu! Bika ná wan sama di man fu gi libisama paadon fu takuudu anga ogii, boiti Masaa Gadu wawan.” ");
INSERT INTO djkNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ne wanten wanten, Masaa Jesesi sabi taki na so den e denki. Ne a akisi den taki: “Saide meke u e denki so du? ");
INSERT INTO djkNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Fu taigi a lanman ya taki, a kisi paadon fi en takuudu anga ogii, efu fu taigi en taki: ‘Opo taampu! Teke i daagi waka go a osu!’ on di moo taanga? ");
INSERT INTO djkNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma u mu sabi taki, a Manpikin di saka kon toon libisama ya abi makiti a goontapu, fu gi sama paadon fu takuudu anga ogii.” Ne a daai, ne a taigi a lanman taki: ");
INSERT INTO djkNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Opo taampu! Teke i daagi waka go a osu!” ");
INSERT INTO djkNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ne dyangalan! A man dyombo opo taampu, ne wanten a teke a daagi oli a ondoo ana, ne a waka gwe a osu. Ala sama e luku dunn. Den foondoo, te den e gafa Masaa Gadu taki: “Wi á si a sani ya wanten.” ");
INSERT INTO djkNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Masaa Jesesi go baka a wataa mofu na a ze. Ne tyaipi sama kon ne en. Ne a leli den Masaa Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ne di Masaa Jesesi komoto de e gwe, da a be e waka pasa wan pikin osu a sikin pasi, pe den Dyusama e go pai lantimoni. Ne a si wan pikin fu Alefeyosi, di den e kai Leifi*f2*, sidon sidon na a osu doo mofu e piki lantimoni gi lanti. Ne Masaa Jesesi kai en taki: “Kon waka a mi baka!” Ne wanten wanten Leifi opo, ne a waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ne moo lati, ne Leifi kai Masaa Jesesi anga den bakaman fi en go nyan ne en osu. Da somen mati fu Leifi di be e piki lantimoni anga sama di be abi polinen a kondee fosi den be kon waka a Masaa Jesesi baka, be sidon a tafaa e nyan anga Masaa Jesesi anga den bakaman fi en. ");
INSERT INTO djkNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","We, ne di den leliman fu Dyuweiti anga den Faliseiman si taki anga a man di e piki lantimoni anga den polinen man a kondee, Masaa Jesesi sidon e nyan. Ne den akisi den bakaman fu Masaa Jesesi taki: “Saide meke ai nyan anga lantiman anga den ogiilibi sama de?” ");
INSERT INTO djkNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma di Masaa Jesesi yee den, ne a piki den anga wan ageisi toli taki: “Wan sama di e siki anga wan sama di nái siki, on di fu den abi dataa fanowdu? Na sama di e siki! Bika, dataa de gi sikiman. Mi á kon fu kai den bunbun sama, ma mi kon fu kai den sama di sabi taki, den libi á bun.” ");
INSERT INTO djkNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma namo, da den bakaman fu Johanisi anga den Faliseiman be abi ten di den be e de sondee nyan fu begi. Ne wan dei, ne wan duupu sama kon a Masaa Jesesi, ne den akisi en taki: “Masaa Jesesi, saide meke den bakaman fi yu ná abi ten di den e tan sondee nyan fu begi, enke den bakaman fu Johanisi anga den bakaman fu den Faliseiman?” ");
INSERT INTO djkNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ne Masaa Jesesi piki den anga wan ageisi toli taki: “Fa mi anga den bakaman fu mi de ya, da a de leti enke te wan man toow anga wan uman. Di a man toow, ne a kai somen sama fu kon meke piisii anga en. Da solanga a toowman de na a fesa anga den, da den ná o tan anga angii fu begi, ma na soso nyan meke piisii namo den o de. ");
INSERT INTO djkNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma a yuu o kon di den o tyai a toowman puu a den de. Da den sa abi ten di den o go e de anga angii fu begi Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ne Masaa Jesesi taigi den baka taki: “Ná wan sama di e teke wan nyun pisi koosi fu nai wan kaasi koosi di piiti. Bika efi i lapu a gaandi koosi anga wan nyunyun pisi, da te i wasi en, da a nyunyun pisi koosi o ali piiti wan pisi fu a gaandi koosi, da a olo o moo bigi. ");
INSERT INTO djkNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Da na soseefi tu, sama nái poti nyun meke win go a ini gaandi meti buba saka. Efu den poti en, da a win o basi a saka. Da ala den tu, a win anga a saka o poli. A dati meke, nyunyun win meke fu poti a ini nyunyun saka, di á poi basi lasi en.” ");
INSERT INTO djkNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Da na a kina dei fu den Dyu, ne Masaa Jesesi anga den bakaman fi en e waka pasa a ini wan goon. Ne den bakaman fi en e booko den ede fu wan sani gei kalu, di den sama paandi a ini a goon, e pii e nyan. ");
INSERT INTO djkNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ne den Faliseiman di si akisi en taki: “Luku de! Saide meke den bakaman fi yu e du sani di sama á mu du a kina dei? Yu nái si taki na Gadu weiti den e poli, no?” ");
INSERT INTO djkNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ne Masaa Jesesi piki den taki: “U á leisi a Masaa Gadu Buku san Kownu Dafeti be du di a be de a nowtu, di angii be kii en anga den man fi en, no? ");
INSERT INTO djkNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","U á leisi fa a be go a ini a Mama Keliki fu Masaa Gadu, na a ten di Abiyatali be de a moo hei begiman fu Dyu, no? A go, ne a teke a beele di den poti a Gadu fesi, ne a nyan. A weiti á be e gi en pasi fu nyan a beele de. Na den begiman fu keliki namo be sa nyanmi en. Da u á leisi, fa a be gi den bakaman fi en fu den nyan tu, no? ");
INSERT INTO djkNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Da u meke mi taigi u. A kina dei be meke gi libisama, ma a ná libisama be meke gi kina dei. ");
INSERT INTO djkNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bika a Manpikin di saka kon toon libisama ya, na a gaan Masaa fu a kina dei.” ");
INSERT INTO djkNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Masaa Jesesi go a ini wan Dyu keliki baka. Ma, da wan man be de ape, di be siki ne en ana te a be dee fika kamboo. ");
INSERT INTO djkNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Da den sama be de koosube e luku Masaa Jesesi. Den be e luku fu si efu a be o deesi a man na a kina dei ya, fu den be fende en go kaagi taki ai du sani di á bun. ");
INSERT INTO djkNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","We, na so Masaa Jesesi taigi a man di be siki ne ana taki: “Opo taampu a fesi fu ala sama ya.” ");
INSERT INTO djkNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne Masaa Jesesi akisi den taki: “San Gadu Buku taki fu a kina dei? U mu du bun efu u mu du ogii? Fu deesi wan sama fu a kon bun baka efu fika en fu dede?” Ma ala den sama de pii. Ná wan fu den piki en. ");
INSERT INTO djkNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ne Masaa Jesesi luku den anga atiboon. Ma soseefi a ati en tu, fu di a si taki den sama taanga den ati gi Masaa Gadu te, tyali fu taa sama nái kisi den moo. Ne Masaa Jesesi taigi a man taki: “Langa i ana!” Ne a man langa en ana. Ne a ana kon bun kelle baka. ");
INSERT INTO djkNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ne den Faliseiman gwe komoto na a keliki. Da den anga den bakaman fu Kownu Helowdesi meke mofu luku fa den sa fende wan Masaa Jesesi kii. ");
INSERT INTO djkNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ne Masaa Jesesi anga den bakaman fi en go a wataa mofu, na a ze fu Galileya. Da somen sama fu Galileya anga Judeja anga Jelusalem, Idumeya anga den kondee na abaase fu a Joodani Liba anga a pisiwataa fu Tilosi anga Sidon kon e waka ne en baka. Den be kon ne en fu di den be yee fu ala den sani di a be e du. ");
INSERT INTO djkNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ne Masaa Jesesi taigi den bakaman fi en taki: “U seeka wan boto gi mi, fu den sama á toto kon banda mi.” ");
INSERT INTO djkNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Da Masaa Jesesi deesi somen sama te, ala sama di be abi wan siki be e toto kon, soso fu oli en namo. ");
INSERT INTO djkNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Da a yuu de, te den sama di wan takuu jeje be de a den tapu be si Masaa Jesesi, da den be e kai a doti ne en fesi e bali taki: “Yu na a Manpikin fu Masaa Gadu!” ");
INSERT INTO djkNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma, te den takuu jeje be e bali so, da Masaa Jesesi be e kaasi den fu den á taki sama ne en. ");
INSERT INTO djkNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ne Masaa Jesesi go a wan mongo tapu. Ne a kai den sama di a wani kon ne en. Ne den kon ne en. ");
INSERT INTO djkNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ne a teke twalufu man puu a den mindii. Da na den twalufu man ya a kai aposteli*f3* tu. Da den be o de anga en na ala pe a be e go. Ne a sende den twalufu man ya, go a den kondee kondee fu go paati a Bun Nyunsu fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Da a be gi den a makiti tu fu yaki takuu jeje puu a sama tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Da na den twalufu man ya a be teke puu a den taawan mindii: Simon di Masaa Jesesi be kai Peitilisi ");
INSERT INTO djkNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jakowbesi, anga en baala Johanisi den tu manpikin fu Da Sebedi. Da Masaa Jesesi be gi den a nen fu Bowanegesi, dati wani taki, Pikin fu Donduu. ");
INSERT INTO djkNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andeleyasi Filipi Baatomeyosi Tadeyesi Mateyesi Jakowbesi a manpikin fu Alefeyosi Tadeyesi Simon Selotu*f4* ");
INSERT INTO djkNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judasi Iskaliyotu, di seli Masaa Jesesi, meke den kii en. ");
INSERT INTO djkNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ne bakadati, ne Masaa Jesesi go a wan osu. Da sama kon fuu a osu fu Masaa Jesesi, te en anga den bakaman fi en á be poi nyan. ");
INSERT INTO djkNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Da di den sama fu Masaa Jesesi yee a sani ya, ne den go fu go teke en puu de. Den taki: “A á sabi san ai du moo.” ");
INSERT INTO djkNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Da den leliman fu Dyuweiti di be komoto a Jelusalem Foto kon de taki: “Belisebulu, a basi fu didibii, de ne en tapu! Na Belisebulu e gi en a taanga fu puu takuu jeje a sama tapu.” ");
INSERT INTO djkNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ma namo, Masaa Jesesi kai den kon makandii. Ne a gi den wan ageisi toli. A taki: “Fa didibii sa puu didibii a wan peesi? ");
INSERT INTO djkNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Efu wan kownu fu kondee opo e feti anga enseefi, da a kondee de, a ná booko a o booko, no? ");
INSERT INTO djkNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Da, soseefi a de anga wan osu tu. Efu den sama e libi fanya fanya anga feyanti fasi anga denseefi, sowan osu musu booko. ");
INSERT INTO djkNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Da efu saatan paati paati e feti anga enseefi, da na a kaba pisi fi en a doo, bika a o booko kaba a soso. ");
INSERT INTO djkNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ná wan sama o poi go a ini a osu fu wan gaan taanga man go teke en gudu. Efu a wani go, da a mu kisi a gaan taanga man tei banda fosi. Da, te a tei en banda so kaba, da a sa go a ini a taanga man osu, go teke en gudu. ");
INSERT INTO djkNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Da fu tuutuu mi e taigi u taki, Masaa Gadu sa gi sama paadon. Awinsi sowtu ogii a du efu awinsi fa a kosi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma awinsi sama na yu, efi i kosi a Jeje fu Masaa Gadu, taki ogii fi en, da noiti noiti Masaa Gadu o gi i paadon fu dati.” ");
INSERT INTO djkNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Da na so Masaa Jesesi piki den sama, fu di den be taki na Belisebulu, a basi fu didibii, de ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","We, ne Masaa Jesesi mma anga den baala fi en doo na a osu pe a de. Den taampu a doose, ne den sende bosikopu gi en fu a kon a den. ");
INSERT INTO djkNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ne den sama di be sidon lontu Masaa Jesesi taigi en taki: “Masaa Jesesi, i mma anga den baala fi yu de a doose. Den e kai yu.” ");
INSERT INTO djkNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ne Masaa Jesesi piki den taki: “A bun! Ma sama na mi mma? Sama na mi baala?” ");
INSERT INTO djkNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ne a luku den sama di be sidon lontu en, ne a taki: “Luku mi mma anga mi baala ya. ");
INSERT INTO djkNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ala sama di e du san Masaa Gadu wani, na den na mi baala anga mi sisa anga mi mma.” ");
INSERT INTO djkNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Da, Jesesi de na a ze fu Galileya e leli den sama baka. Da somen sama kon ne en. Ne Masaa Jesesi go a ini wan boto, ne a sidon. Ma ala den taa sama be de a soo a wataa mofu. ");
INSERT INTO djkNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Da, ai gi den ageisi toli fu leli den somen sani. Da, di ai leli den, ne a taigi den taki: ");
INSERT INTO djkNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“U aliki! Wan dei, da wan paandi goonman be go tyatya wan sii fi en, fu goo. ");
INSERT INTO djkNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Da, di a tyatya a sii, ne wantu kai a sikin pasi. Ne foo fee kon, ne den nyan ala. ");
INSERT INTO djkNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Da, wantu taa sii kai a siton ini, a pe doti á be de ipi. Da den sii ya goo esi esi, bika a doti á be dipi. ");
INSERT INTO djkNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Da, di a san opo, ne a boon den kii. Bika den ná abi ná wan lutu, fu di a doti á be dipi sai. ");
INSERT INTO djkNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wantu taa sii kai a maka ini. Ne den maka goo banda den kii. Den á meke nyanyan. ");
INSERT INTO djkNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma, taa sii kai a bun doti, ne den goo moi. Den meke nyanyan bun. Son fu den meke diitenti toon moo enke san di a be paandi. Taawan meke sigisitenti toon moo enke san a be paandi. Taawan baka meke wan ondoo toon moo enke san a be paandi.” ");
INSERT INTO djkNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ne a taigi den taki: “Meke sama di abi yesi fu yee, da meke a yee san mi taki ya.” ");
INSERT INTO djkNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Da, di Masaa Jesesi anga den twalufu bakaman fi en anga wantu taa sama di be e waka ne en baka wawan be de, ne den akisi en taki: “Masaa Jesesi, san wani taki a toli di i be leli den sama de?” ");
INSERT INTO djkNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ne Masaa Jesesi piki den taki: “U di e waka a Masaa Gadu pasi, kon sabi somen kibii toli fu a Nyun Tii fu Masaa Gadu. Ma den sama di á de a Masaa Gadu pasi, na ageisi toli fasi mi e gi den en. Bika, ");
INSERT INTO djkNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Den e luku anga opo opo ain, ma den nái si. Den e yee anga kiinkiin yesi, ma den nái fusutan san den e yee. Da noiti den daai den libi kon a mi. A dati meke noiti den fende paadon fu den takuudu anga ogii fu den.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne Masaa Jesesi akisi den taki: “U á fusutan a toli, no? Da, fa u o du fusutan den taa toli di mi o teke gi den sama fu leli den sani?” ");
INSERT INTO djkNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ne a puu en gi den taki: “A goonman, di be e tyatya a sii, dati na a sama di e paati a wowtu fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Da somen sama de enke sii di kai a sikin pasi. Solanga den yee a wowtu fu Masaa Gadu, da a didibii e kon, da a piki a wowtu di paandi a ini en ati ini puu wanten wanten. ");
INSERT INTO djkNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Somen sama de enke sii di paandi a wan pisi doti di abi tyaipi siton. Solanga den yee a wowtu fu Masaa Gadu, den e teke en wanten wanten anga gaan piisii. ");
INSERT INTO djkNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ma ná wan lutu di den e meke. Den e de namo fu wan satu pisiten. Bika, te nowtu anga pina kon a den tapu fu a wowtu ede, da wanten den e daai fika a biibi. ");
INSERT INTO djkNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Taa sama de enke sii, di paandi a ini maka. Den e yee a wowtu, ");
INSERT INTO djkNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma den booko fu a libi anga a feti fu fende tyaipi gudu anga taa sani a goontapu anga a lobi fu goontapu sani seefi, e tyoko a wowtu a ini den ati ini kii, meke a á poi meke nyanyan. ");
INSERT INTO djkNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma taawan de enke sii, di kai a bunbun doti. Den e yee a wowtu. Den e teke en. Da, den e meke tyaipi tyaipi nyanyan. Son e meke diitenti, sigisitenti anga wan ondoo toon fu san di den be paandi.” ");
INSERT INTO djkNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ne Masaa Jesesi taigi den taki: “Te i leti wan lampu a ini wan osu, yu nái toosi en go a kama ondoo efu teke boketi tapu en. Nono! Yu o poti en a tapu, efuso yu o oli en hei fu a sa leti kiin peesi. ");
INSERT INTO djkNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Da, ná wan sani de kibii, di ná o kon a kiin fu sama sabi. ");
INSERT INTO djkNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Meke sama di abi yesi fu yee, yee san mi taki ya!” ");
INSERT INTO djkNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne Masaa Jesesi taigi den go doo taki: “Na fa u e aliki den sani di u e yee, na so u o fusutan den tu fu teke koni. Bika a de leti enke wan nongo di taki: ‘Fa yu e maiki sani gi sama, na so sama o maiki sani gi yu baka.’ Da moo ipi seefi yu o kisi a tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bika, a sama di fende wan pikinso koni nownow, ne a wooko anga en, a sa fende moo ipi. Ma, a sama, di ná o wooko anga a pikinso koni di a abi nownow, a sa lasi ala san a be abi.” ");
INSERT INTO djkNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Masaa Jesesi taigi den taki: “A Nyun Tii fu Masaa Gadu de enke, te wan goonman, go a goon wan dei, go paandi sii. Di a paandi den sii, te a kaba, ne a go fi en a kondee baka. ");
INSERT INTO djkNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ne a de fi en a kondee. Neti ai siibi, dei ten a de fi en anga ain. Ma a sii goo sondee fu a man sabi fa a du goo. ");
INSERT INTO djkNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ma, namo baka wan pisiten, ne den sii goo. Den booko ain kon a tapu doti, ne den goo, te puu boomiki meke nyanyan. ");
INSERT INTO djkNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Da, wanten wanten, di a sii meke nyanyan lepi, ne a goonman teke en babun nefi, ne a go koti den. Bika, a yuu fu koti den sii ya, be doo kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ne, Masaa Jesesi akisi den baka taki: “Sowtu ageisi toli mi sa teke soi u, fu u sa sabi fa a Nyun Tii fu Masaa Gadu de, moo? ");
INSERT INTO djkNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","We, meke u taki: A de enke wan sii den e kai mosite. A sii ya na wan pikintoin sii. ");
INSERT INTO djkNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma, te den paandi en, te a goo, da ai bigi moo ala den taa sani di den paandi a ini a goon. Den ana fi en e bigi paati, te den foo e meke nesi e teke koo a den.” ");
INSERT INTO djkNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Da, te Masaa Jesesi be e gi den sama Gadu wowtu, da a be lobi teke den sowtu toli ya gi den sama. Da na a fasi ya, den be sa fusutan san a be wani leli den. ");
INSERT INTO djkNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Da a á be e taki anga den sondee fu gi den, den sowtu toli ya. Ma, te en anga den bakaman fi en wawan be de, da a be e puu ala sani gi den fini fini. ");
INSERT INTO djkNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Da, di sapaten doo, ne Masaa Jesesi taigi den bakaman fi en taki: “U kon meke u abaa go na abaase.” ");
INSERT INTO djkNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ne den fika den somen sama wawan a baka, ne den go a boto anga Masaa Jesesi e go na abaase. Da, wantu taa boto be e koti abaa anga en tu. ");
INSERT INTO djkNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma namo, wan gaan winta kisi den a pasi. Da a wataa be seke, meke gaan paana e wasi kon a ini a boto te. A boto fuu kwaa, pikinmoo den sungu. ");
INSERT INTO djkNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Masaa Jesesi be didon a bakase fu a boto, poti ede a wan kunsu e siibi. Ne den bakaman fi en weki en taki: “Mesiti! I á si taki, wi o dede kaba a soso, no? I ná abi toobi seefi taki, wi o dede, no?” ");
INSERT INTO djkNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ne Masaa Jesesi opo, ne a kaasi a winta fu tan pii. Ne a taigi a ze taki: “Kaba! Tan pii!” Ne a winta tan pii. A ze seefi koo pii tu. A winta nái wai taanga moo, a ze nái seke moo. ");
INSERT INTO djkNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ne Masaa Jesesi akisi den bakaman fi en taki: “Saide meke u feele so? U á poti fitoow a mi ete, no?” ");
INSERT INTO djkNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ne den bakaman fu Masaa Jesesi feele, te den e akisi denseefi taki: “Sama na a sama ya seefi? A winta anga a ze seefi e teke en taki!” ");
INSERT INTO djkNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","We, ne Masaa Jesesi anga den bakaman fi en go doo na abaase fu a ze fu Galileya. Ne den poti boto na a pisiwataa fu den Gelaseini sama. ");
INSERT INTO djkNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Fa i si Masaa Jesesi komoto a soo, ne wan man lon kon ne en. Wan takuu jeje be de na a man ya tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Da na den siton geebi mindii a man ya be e tan. A be taanga te, ná wan sama be poi kisi en tei moo. Keti seefi á be poi keti en. ");
INSERT INTO djkNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Na onmen leisi den bui en ana anga en futu anga keti, ma a booko den keti enke lawlaw sani. Ná wan sama di be poi oli en. ");
INSERT INTO djkNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dei anga neti a man ya be de a ini a belipe anga den mongo mindii e waka e bali gaan balibali e naki enseefi koti anga siton. ");
INSERT INTO djkNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Da, a man de, te a faawe si Masaa Jesesi, ne a go ne en. Ne a sutu kini a doti, a Masaa Jesesi fesi. ");
INSERT INTO djkNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ne a bali taki: “San mi anga yu abi nownow kaba, Jesesi, Pikin fu a moo Hei Gadu? Mi teke Gadu nen begi yu, ná sitaafu mi, baa!” ");
INSERT INTO djkNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Da, na fu di Masaa Jesesi be kaasi a takuu jeje, fu a gwe komoto na a man tapu wanten wanten, meke a be e bali so. ");
INSERT INTO djkNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ne Masaa Jesesi akisi en taki: “Fa den e kai yu nen?” Ne a takuu jeje piki taki: “Na mi den e kai Hipiman, bika u de ya anga tyaipi man.” ");
INSERT INTO djkNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne, den begi Masaa Jesesi taki: “Gaantangi, ná yaki u puu na a pisiwataa ya, baa!” ");
INSERT INTO djkNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Da, somen somen agu be de a wan mongo koosube de, e suku sani fu nyan. ");
INSERT INTO djkNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ne den takuu jeje begi Masaa Jesesi taki: “Te i puu wi na a sama ya, sende u go a ini den agu, baa!” ");
INSERT INTO djkNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ne Masaa Jesesi meke den go. Den takuu jeje komoto na man, ne den go a ini den agu. Ne wanten wanten, ne ala den tu dunsu agu lon saka a mongo hullu, te a ze dubuu. Ná wan di komoto moo. Ala fiya dede. ");
INSERT INTO djkNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ne, den sama di be e luku den agu si san pasa, ne den lon gwe. Ne den paati a mofu na a hii kondee anga a pisiwataa de, fu san pasa. Da, na so den sama komoto kon luku san pasa. ");
INSERT INTO djkNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Da, di den doo Masaa Jesesi, ne den si a man, di den tyaipi takuu jeje be de ne en tapu. A sidon de pii, wei koosi moi, de fi en anga en bunbun fusutan baka. Da, den sama feele fu san den si ya. ");
INSERT INTO djkNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Den sama di be si, taigi sama san den si pasa anga a man, di den takuu jeje be de ne en tapu anga den agu. ");
INSERT INTO djkNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ne, di den sama yee so, ne den bigin begi Masaa Jesesi gaantangi fu a komoto a den kondee de gwe. ");
INSERT INTO djkNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ne, fa i si Masaa Jesesi go a boto baka, ne a man, di den takuu jeje be de ne en tapu begi en taki: “Meke mi go anga yu, baa?” ");
INSERT INTO djkNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma, Masaa Jesesi á gi pasi fu dati. Pe fu dati, ne a taigi a man taki: “Nono! Go a osu a den sama fi yu, da taigi den san Masaa du gi yu, anga fa a be abi tyali ati fi yu.” ");
INSERT INTO djkNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ne a man go. Ne ai paati a mofu fu san di Masaa Jesesi du gi en na a hii pisi kondee di den e kai Dekapolisi*f5*. Da ala sama be e foondoo fu a sani ya. ");
INSERT INTO djkNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ne Masaa Jesesi abaa a ze fu Galileya baka go na abaase. Da somen sama kon ne en a wataa mofu te a ipi. ");
INSERT INTO djkNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Wan man den e kai Yailesi seefi kon a Masaa Jesesi tu. Di a si Masaa Jesesi, ne, wanten a sutu kini a doti ne en fesi. Yailesi na be wan fu den edeman fu Dyu keliki. ");
INSERT INTO djkNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ne a begi Masaa Jesesi taki: “Masaa Jesesi! Wan pikin umanpikin fu mi e dede, baa. Gaantangi, kon poti yu ana ne en tapu, gi mi baa, fu a kon bun baka, da a o libi!” ");
INSERT INTO djkNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ne Masaa Jesesi e go anga en. Da, somen sama be e kon a Masaa Jesesi baka. Den be e toto fu ala se e kon ne en. ");
INSERT INTO djkNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma, wan uman be de a ini den somen sama de di be abi wan lasi buulu siki. Twalufu yali kaba, di a be kisi en, sondee fu koti. ");
INSERT INTO djkNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Anga ala fa a uman ya, be pai anga ala a moni di a be abi fu suku yeepi a somen somen dataa, toku a á be poi fende yeepi. Pe fu dati, ne na moo a siki be e moo ogii. ");
INSERT INTO djkNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma fanafu di a uman ya yee den sani di Masaa Jesesi e du, ne a waka ne en baka a ini den somen sama, ne a oli en koosi. ");
INSERT INTO djkNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Bika a be e taki a ini enseefi taki: “Efu mi sa lobi ana ne en koosi namo, mi sa kon bun.” ");
INSERT INTO djkNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ne wanten, a buulu koti. Ne a fii a ini en sikin taki, a kon bun fu den pina fu ala den yali. ");
INSERT INTO djkNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ne a seefi yuu de, ne Masaa Jesesi fii kaakiti e komoto ne en sikin go deesi wan sama. Ne a daai a ini den somen sama, ne a akisi taki: “Sama meli mi koosi?” ");
INSERT INTO djkNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ne, den bakaman fi en taigi en taki: “Masaa Jesesi, fa i sa akisi sama meli yu? Luku onmen sama e toto yu fu ala se ya.” ");
INSERT INTO djkNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma, ai daai e luku fu si a sama di meli en. ");
INSERT INTO djkNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ne a uman kon a fesi anga ala feele anga dansi sikin. Bika a sabi san pasa anga en seefi. Ne a saka kini a Masaa Jesesi fesi, ne a taigi en pilisisi ala san pasa anga en, di a oli en. ");
INSERT INTO djkNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ne, Masaa Jesesi taigi en taki: “Uman! A biibi fi yu yeepi yu fi i kon bun baka. Go baka a osu anga koo ati! A gaan pina siki wai pasa gwe.” ");
INSERT INTO djkNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Da, a ten di Masaa Jesesi e taki anga a uman ya ete, ne wantu sama komoto a Yailesi osu tyai mofu kon. Den taigi Yailesi taki: “A pikin umanpikin fi yu dede. A á de fi i muliki a mesiti fu a go anda moo.” ");
INSERT INTO djkNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma, Masaa Jesesi yee, di den gi Yailesi a bosikopu. Ne a taigi Yailesi taki: “Ná feele! Ma biibi namo.” ");
INSERT INTO djkNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma, boiti Peitilisi anga Jakowbesi anga Johanisi, da Masaa Jesesi á meke ná wan sama go anga en moo a Yailesi osu. ");
INSERT INTO djkNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Da, di den doo Yailesi osu, ne Masaa Jesesi si soso kee anga balibali de. Sama e kee e bali, te ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ne, di Masaa Jesesi go a ini a osu, ne a akisi den taki: “Saide meke u e kee e bali so du? A pikin á dede! Na siibi namo ai siibi!” ");
INSERT INTO djkNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ne, den sama kii en anga lafu. Ma, Masaa Jesesi poti ala den fiya a doo. Ne, a teke a dda anga a mma fu a pikin anga den dii bakaman fi en, ne den go a pe a pikin de. ");
INSERT INTO djkNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ne Masaa Jesesi oli a pikin ana, ne a taigi en taki: “Talita kumi!” Dati wani taki: “Pikin umanpikin, mi e taigi yu, opo taampu!” ");
INSERT INTO djkNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ne wanten wanten, ne a pikin umanpikin opo, ne a bigin e waka e lontu a ini a osu. Da a pikin abi twalufu yali kaba. Da a sani, di pasa ya bigi gi den sama, te ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ne, Masaa Jesesi bali den taanga taanga fu den á meke ná wan sama sabi san pasa de. Soseefi tu a taigi den fu den gi a pikin sani fu nyan. ");
INSERT INTO djkNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Masaa Jesesi komoto de, ne a go ne en eigi kondee. Da den bakaman fi en go anga en tu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ne, di a kina dei fu den Dyu doo, ne a bigin fu leli sama Masaa Gadu wowtu a ini a Dyu keliki. Somen sama, di yee en, foondoo, te den e akisi taki: “Pe a man ya komoto, a anga den sani di ai leli de? Pe a fende a koni de? Sama gi en a kaakiti fu ai du den gaan foondoo wooko di wi yee ai du? ");
INSERT INTO djkNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A ná a tembeeman de ya, no? A ná a pikin fu Maliya, no? U sabi den baala fi en bunbun, Jakowbesi, Jowsef, Judasi anga Simon. A ná wi anga den sisa fi en e tan a Nasaleti ya, no?” Da na so den teke en fu ogii. Den ná abi bisi anga en. ");
INSERT INTO djkNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma Masaa Jesesi piki den taki: “Ala sama fu goontapu e lesipeki wan apaiti takiman fu Masaa Gadu, ma den sama fi en eigi kondee seefi, en eigi famii anga den sama fi en eigi osu ini, nái lesipeki en.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A á be poi du ná wan foondoo sani de, boiti taki a poti ana a wantu sikiman tapu deesi den. ");
INSERT INTO djkNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Da, a be foondoo Masaa Jesesi, fu di den sama fi en eigi kondee á be wani poti biibi ne en. Ne a komoto de go a wantu taa kondee na a seefi pisiwataa de, go e leli sama Masaa Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ne wan dei, ne a kai den twalufu apaiti bosikopuman fi en kon, ne a sende den, tu tu man, fu den go a den kondee kondee go paati Masaa Gadu wowtu. Ne a taigi den taki: “U go! Mi gi u taanga fu u puu takuu jeje a sama tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma, te u e go, u á mu tyai ná wan enkii taa sani moo enke wan waka tiki namo a u ana. U á mu tyai beele. U á lai tasi tyai. ");
INSERT INTO djkNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","U á mu tyai taa susu anga koosi. Den di u wei de sai kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ne Masaa Jesesi taigi den taki: “Di u o go, te u go a wan osu, da u mu tan de, te enke u kaba fu gwe baka. ");
INSERT INTO djkNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Da, te u doo wan peesi pe sama á wani teke u a den osu efu aliki a bosikopu di u e tyai. Da u mu gwe. Ma fosi u gwe, da u mu naki u futu puu a santi meke den sabi taki den be fende a okasi fu aliki a Bun Nyunsu fu mi. Da a fika gi den.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Da, na so den bakaman fu Masaa Jesesi gwe. Ne den go a den kondee kondee go e bali den sama taki, meke den daai libi. ");
INSERT INTO djkNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Da, den yaki somen takuu jeje puu a sama tapu. Soseefi den lobi oli a somen sikisama sikin deesi den kon bun baka. ");
INSERT INTO djkNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Da Kownu Helowdesi seefi yee fu den sani di Masaa Jesesi e du. Bika Masaa Jesesi nen be bali na ala peesi. Son sama taki: “Johanisi a Dopuman weki komoto a dede kon a libi baka. A dati meke a abi a kaakiti fu du den gaan foondoo foondoo sani ya.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Taawan taki: “Na Eliya! Ne en de ya.” Taawan taki: “Na wan apaiti takiman fu Masaa Gadu, enke wan fu den fositen apaiti takiman.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ma, di Kownu Helowdesi seefi yee a sani ya, ne a taki: “Na Johanisi di mi be meke den kii, ne weki komoto a dede tuu.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Bika, Kownu Helowdesi be meke den kisi Johanisi tei poti a dunguu osu. Da, na fu Helowdiya ede meke a du dati. Bika a be libi anga Helowdiya. Helowdiya na be a uman fu Filipi, a baala fu Helowdesi. ");
INSERT INTO djkNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Da Johanisi be e bali Helowdesi taki, a á bun fu a teke a uman fi en baala libi. ");
INSERT INTO djkNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Da, di Helowdiya yee taki na so Johanisi bali Kownu Helowdesi, ne wan takuu atiboon teke en. A be wani kii Johanisi wanten wanten. Ma den á gi en pasi fu du dati, ");
INSERT INTO djkNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","bika Kownu Helowdesi be sabi taki Johanisi na be wan sama, di e libi letiopu fasi gi Masaa Gadu. Da a be e feele en. A dati meke a teke Johanisi poti a wan peesi pe sama á be sa fende en kii. Te a be e taki anga Johanisi, en konsensi be e fonmi en, ma toku, a be lobi aliki Johanisi. ");
INSERT INTO djkNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na so den de, te wan dei, ne Helowdiya fende pasi fu kii Johanisi. Bika wan dei, Helowdesi oli wan gaan fuuyali piisii fi en a ini en paleisi. Da a be kai ala den sama di e wooko ne en ondoo, den edeman fu suudati den hei hei man fu Galileya. ");
INSERT INTO djkNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma namo, di den de na fesa, te wan pisi, ne a pikin umanpikin fu Helowdiya kon a pe Helowdesi anga ala den taa sama sidon. Ne a dansi de walla. Da fa a dansi so, a switi gi Kownu Helowdesi anga den taa man te, ná sipowtu. Ne Kownu Helowdesi taigi a pikin taki: “Mama! Akisi mi san i wani! Mi sa gi yu en.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne Helowdesi taigi en go doo taki: “Mi e sweli taki, ibii sani di i akisi mi, mi o gi yu en. Efu na afu fu a kondee di mi e tii enke kownu ya seefi i wani, mi o gi yu en.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ne a pikin umanpikin go a doose ne en mma. Ne a akisi en taki: “Mi mma, san mi mu akisi en?” Ne Helowdiya taigi en taki: “Piki Kownu taki i wani a ede fu Johanisi a Dopuman.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Di en mma taigi en so, ne wanten wanten a lon go baka a Kownu Helowdesi baka. Ne a taigi en taki: “Mi wani i gi mi a ede fu Johanisi a Dopuman nownow de a ini wan gaan teepala.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Da, di kownu yee so, ne gaan tyali kisi. Ma na fu a sweli, di a be meke a den bigiman de fesi gi a pikin umanpikin kaba, meke a á be poi puu a mofu de moo. ");
INSERT INTO djkNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ne wanten, ne a sende wan fu den man suudati go koti a ede fu Johanisi tyai kon. Ne a man go, ne a doo Johanisi ede felen a ini a sitaafu osu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ne a tyai en kon a ini wan teepala. Ne a gi a pikin umanpikin. Ne a pikin umanpikin teke, ne a gi en mma. ");
INSERT INTO djkNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Da, di den bakaman fu Johanisi yee taki den kii Johanisi, ne den go teke a dede sikin fu Johanisi go beli. ");
INSERT INTO djkNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Da den twalufu apaiti bosikopuman fu Masaa Jesesi di a be sende gwe a den peesi peesi daai kon baka. Da den bigin fu taigi Masaa Jesesi ala san den du anga san den be leli den sama fu den peesi peesi pe a be sende den go. ");
INSERT INTO djkNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","32","Ne Masaa Jesesi taigi den taki: “U kon meke u go a wan koo peesi pe sama á de go boo u sikin afu.” Bika somen sama be komoto a den kondee kondee e kon ne en namo e kon e suku yeepi, te den á be abi ten fu nyan wan bun fasi seefi. A dati meke a be wani go anga den bakaman fi en wawan a wan peesi. Ne den go a boto, ne den puu gwe. ");
INSERT INTO djkNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Da somen sama si di den e puu gwe, ne den sabi kaba taki na sowan peesi sowan peesi den e go. Ne den lon a soo anga futu, fu te na a peesi pe Masaa Jesesi anga den bakaman fi en e go. ");
INSERT INTO djkNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Da den sama doo fika Masaa Jesesi anga den bakaman fi en seefi. Da di den koosube di Masaa Jesesi luku, ne a si wataa mofu baaka pii anga libisama. Da tyali fu den sama kisi Masaa Jesesi. Bika den sama be gei sikapu di ná abi tiiman. A dati meke a leli den sani fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Da di bakadina fosi neti kai, ne den bakaman fi en taigi en taki: “We, Masaa Jesesi ai lati namo. ");
INSERT INTO djkNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Da sende den sama gwe. Da den sa bai sani fu nyan a den pikin pikin kondee. Bika ná wan sama e tan ya, da sani á de ya fu bai tu.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma Masaa Jesesi piki den taki: “Nono! U gi den nyanyan meke den nyan.” Ne den bakaman fi en akisi en taki: “We, u ná abi beele fu gi den somen sama ya. I wani meke u go bai beele gi den? A o dii fu u mu bai nyanyan gi ala den somen sama ya.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ne Masaa Jesesi akisi den taki: “Onmen beele u abi de?” Ne den luku, ne den taki: “U abi feifi beele anga tu fisi ya.” ");
INSERT INTO djkNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ne Masaa Jesesi taigi den sama taki meke den saka sidon a kulu ini a gaasi. ");
INSERT INTO djkNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Fa i si Masaa Jesesi kaba taigi den so, ne den sidon a ini kulu fu wan ondoo anga kulu fu feifitenti sama. ");
INSERT INTO djkNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ne a teke den feifi beele anga den tu fisi. Ne a luku tapu a Masaa Gadu, ne a gi Masaa Gadu daa moi te a kaba. Ne a booko den beele pisipisi anga tu fisi. Ne a gi den bakaman fi en, fu den go paati. Da soseefi a meke den paati den fisi tu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ne ala sama nyan te den bee fuu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Da di den bakaman fu Masaa Jesesi piki san di den nyan fika, ne a fuu twalufu bakisi. ");
INSERT INTO djkNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Da fu den manengee wawan di be nyan, da a moo enke feifi dunsu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ne wanten bakadati, ne Masaa Jesesi taigi den bakaman fi en, fu go a boto koti abaa go na abaase a Betisaida. Ma en o fika de, fu sende den sama gwe a den osu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ne di a sende ala den sama gwe kaba, ne a subi go a wan mongo tapu, go e begi. ");
INSERT INTO djkNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","A yuu ten de, da peesi be kon e dunguu kaba. Ma, den bakaman fi en be de, te a mindii wataa kaba anga a boto. Ne en wawan be de a soo ete. ");
INSERT INTO djkNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ne di a begi te wan pisi, di a daai luku, ne a si taki den de a mindii fu a ze ete e feti anga a boto. Den e puu ma den nái go a fesi. Wan gaan winta e wai na a ze, meke den á poi go a fesi. Namo di musude, ne Masaa Jesesi waka na a wataa tapu tyaa tyaa go miti den. Da a waka enke a be wani pasa den. ");
INSERT INTO djkNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Da di den si a sama e waka na a ze tapu anga futu e kon, ne den feele te den bigin bali. Den be denki taki na wan yooka e kon a den. Ne Masaa Jesesi bali gi den taki: “U á feele! U oli useefi. Na mi de ya!” ");
INSERT INTO djkNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ne a subi go a ini a boto a den. Da di a subi go a ini a boto, ne a winta saka wanten wanten. Den foondoo te, den fika opo opo mofu. ");
INSERT INTO djkNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Da anga ala fa den be si Masaa Jesesi be paati feifi beele anga tu fisi gi onmen dunsu sama, toku den á be wani fusutan ete sama Masaa Jesesi be de. ");
INSERT INTO djkNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ne den poti boto a Genesaleti, ne den go a soo. ");
INSERT INTO djkNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Da fa i si den poti futu a soo, ne den sama di be de a lampe sabi kaba taki a man ya, na Masaa Jesesi, di e deesi ala sowtu siki. ");
INSERT INTO djkNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ne den lon lontu kondee paati a mofu te a doo. Ne den sama tyai ala den sikiman kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Da ibiiwan peesi pe Masaa Jesesi be go, efu na pikin kondee efu wan foto efu na pikin kampu seefi, da den sama be e tyai siki sama kon poti a ganda a pe a be o waka pasa. Da den e begi en taki: “Gaantangi, meke den sama oli i koosi mofu, baa! Da den sa kon bun baka.” Namo, da ala siki sama di be oli kon bun kelle. ");
INSERT INTO djkNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Da wan dei, ne den Faliseiman anga wantu leliman fu Dyuweiti komoto a Jelusalem Foto kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Te wan pisi, ne den si taki, te son fu den bakaman fu Masaa Jesesi e nyan, da den nái wasi ana na a fasi fa den Dyu gwenti fu wasi ana na a apaiti fasi fosi den go nyan. ");
INSERT INTO djkNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Den Faliseiman anga ala den taa Dyusama á be e nyan fosi den wasi den ana a wan apaiti fasi enke fa den gaansama fu den leli den taki, ");
INSERT INTO djkNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","te den komoto a wowoyo kon, den á mu nyan fosi den wasi a wan apaiti fasi. Da den be e oli somen fu den weiti ete, di den avo gaansama fika gi den. Den be mu wasi den tyobo sani a wan apaiti fasi tu. Den sani enke den kan fu diingi wataa, den patu, beenki fu nyan. ");
INSERT INTO djkNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ne den Faliseiman anga den leliman fu Dyuweiti akisi Masaa Jesesi taki: “Saide meke den bakaman fi yu nái oli den weiti di den gaansama poti gi wi. Bika den e nyan sondee fu wasi den ana na a apaiti fasi.” ");
INSERT INTO djkNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ne Masaa Jesesi taigi den taki: “U bidiigiman u! Jesaja, a apaiti takiman fu Masaa Gadu, be abi leti di a be sikiifi fu u a Gadu Buku taki: ‘Den sama ya e lesipeki mi e gi mi gaandi anga den buba mofu, ma a nái doo den ati. Den pakisei de faawe fu mi. ");
INSERT INTO djkNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Fa den e bali e hei mi anga den buba mofu de, ná tuu. Bika ná den weiti fu mi den e leli sama. Ma na weiti di libisama seefi meke den e leli sama.’ ");
INSERT INTO djkNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","U poti den weiti fu Masaa Gadu a wanse, da u e teke den weiti di libisama meke fu gaan sani fu wooko.” ");
INSERT INTO djkNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ne Masaa Jesesi taigi den go doo taki: “U ná abi toobi fu poti den weiti fu Masaa Gadu a wanse, soso fu u oli den haw gwenti fu u. ");
INSERT INTO djkNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mi o taigi u san a avo gaansama fu u di den be e kai Mosesi be sikiifi a Gadu Buku. A be sikiifi taki: ‘U mu lesipeki u dda anga u mma. Da iniiwan sama di kosi en mma efu en dda mu dede.’ ");
INSERT INTO djkNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma u daai a weiti fu Masaa Gadu ya poti taki: ‘I ná abi fu yeepi i mma anga i dda, fu gi den sani moo, efi i taigi den taki, san i be o gi den, i paamisi fu gi Masaa Gadu dati enke paiman.’ ");
INSERT INTO djkNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","13","Da efu wan sama taki so, da u nái gi en pasi fu yeepi en mma anga en dda a sani moo. Da san u du ya e soi taki u ná abi fu abi toobi anga Masaa Gadu wowtu moo. U wani meke den sama oli den weiti di den avo gaansama fu u fika gi u. Da a fasi fu libi ya e meke u poli a weiti fu Masaa Gadu. Da somen taa sani de tu di u e du na a seefi fasi.” ");
INSERT INTO djkNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ne Masaa Jesesi kai ala den sama kon, ne a taigi den taki: “U aliki mi bun! San mi o taigi u ya, na wan sani di u musu fu sabi. ");
INSERT INTO djkNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wan sama nái tyobo a Masaa Gadu fesi fu san di ai nyan go a ini en bee. Ma na den sani di ai taki komoto a ini en mofu ini kon a doo, na den e meke a tyobo a Gadu fesi. ");
INSERT INTO djkNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Meke sama di abi yesi fu yee, yee san mi taki ya!” ");
INSERT INTO djkNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Da di Masaa Jesesi taigi den so kaba, ne a fika den, ne a go a ini wan osu. Ne den bakaman fi en akisi en taki: “San wani taki a toli di i gi den sama de?” ");
INSERT INTO djkNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ne Masaa Jesesi piki den taki: “Na so useefi don fu fusutan sani enke den taa sama de? ");
INSERT INTO djkNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","We, a nyanyan di yu e nyan, nái go a yu ati, ma ai go a ini yu bee. Da te a yuu doo, da ai komoto baka.” Da anga disi Masaa Jesesi be wani taigi den taki, den á mu oli kina moo, ma den sa nyan ala san di de fu nyan sondee konsensi fonfon. ");
INSERT INTO djkNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne a taki go doo taki: “Na den sani di e komoto a u ati e meke u kon tyobo a Masaa Gadu fesi. ");
INSERT INTO djkNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Den sani enke motyo libi, fufuu anga kii sama, go a taa man ofu taa uman. ");
INSERT INTO djkNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Den sani enke giili ati anga takuu fasi, koli sama, fanya libi, dyalusu, saanti sama, bigi fasi anga lawlaw denki. ");
INSERT INTO djkNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Na den sani ya de a ini wan sama ati. Da te den e komoto a doo, da den e meke a sama tyobo a Masaa Gadu fesi.” ");
INSERT INTO djkNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Da di Masaa Jesesi taigi den so, ne a komoto de, ne a go a Tilosi. Da di a doo Tilosi, ne a go a ini wan osu. A á be wani meke sama sabi taki a be de ape. Ma Masaa Jesesi á poi de a wan peesi, da a tan kibii. ");
INSERT INTO djkNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bika a á be de ape langa seefi fosi wan uman kon ne en. Da a uman ya be abi wan pikin umanpikin di be abi wan sani ne en tapu. Da fa i si a uman ya doo Masaa Jesesi, ne a sutu kini a doti ");
INSERT INTO djkNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","e begi en fu a puu a takuu jeje na a pikin fi en tapu. A uman ya na be wan Giiki sama di be meke na a kondee di den e kai Silofenisi. ");
INSERT INTO djkNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Masaa Jesesi piki en anga wan ageisi toli taki: “A á bun fu teke a nyanyan fu den pikin towe gi pikin dagu. Meke den pikin fosi nyan.” ");
INSERT INTO djkNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ne a uman piki Masaa Jesesi taki: “Masaa san i taki na tuu. Ma den pikin dagu e nyan den sakasaka di den pikin e nyan towe a doti.” ");
INSERT INTO djkNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ne Masaa Jesesi piki a uman taki: “A bun! Fu di i piki sowan fasi, meke i fende yeepi. Go a osu baka! A pikin umanpikin fi yu kon bun. A takuu jeje komoto ne en tapu.” Na so a uman daai go a osu. ");
INSERT INTO djkNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Di a doo osu, ne a si a pikin fi en didon a kama tapu pii. A takuu jeje gwe komoto ne en tapu gwe. A kon bun kelle. ");
INSERT INTO djkNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Namo Masaa Jesesi komoto a Tilosi waka go a Sidon. Ne a waka go na a pisi di den e kai Dekapolisi na abaase fu a ze fu Galileya. ");
INSERT INTO djkNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne di a doo de, ne den tyai wan man kon ne en. A man ya be dofu. Ma soseefi, a di na sani, ne a be e taki. Ne den sama begi Masaa Jesesi fu a poti ana na a man ya tapu meke a kon bun. ");
INSERT INTO djkNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ne Masaa Jesesi tyai a man ya puu a ini den somen sama go a wanse. Ne a toosi en finga go a ini a man yesi. Ne a puu en ana baka, ne a towe wataa mofu ne en ana, ne a nama ana na a man tongo. ");
INSERT INTO djkNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ne Masaa Jesesi luku tapu, ne a ali wan dipi boo. Ne a taki: “Efata!” Dati wani taki: Opo! ");
INSERT INTO djkNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ne wanten wanten so a man yesi opo woo, ne ai yee sani bun. Da soseefi en tongo losi te ai taki wala wala enke fa wan libisama meke fu taki. ");
INSERT INTO djkNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ne Masaa Jesesi bali den sama taki: “U á mu taigi sama taki na mi deesi a man ya, u yee!” Ma anga ala fa a bali den de, toku den e taigi sama taki: “Na Masaa Jesesi deesi a man! Na Masaa Jesesi deesi!” ");
INSERT INTO djkNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Den á be poi tan pii fu san den si Masaa Jesesi du. A be foondoo den. Den e bali taki: “Ala den sani fiya di Masaa Jesesi e du ai du bun. Ai opo dofuman yesi. Ai losi babaw tongo fu den taki tu.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Da somen sama be kon aliki Masaa Jesesi. Den ná abi sani fu nyan. Ne Masaa Jesesi kai den bakaman fi en, ne a taigi den taki: ");
INSERT INTO djkNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Tyali fu den sama e kisi mi. Den de ya dii dei anga mi kaba. Da den ná abi ná wan sani fu nyan. ");
INSERT INTO djkNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Efu mi sende den go a osu so, den sa faaw a pasi fu a angii. Somen fu den e tan faawe.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ne den bakaman fi en akisi en taki: “Pe u o fende nyanyan a ini a sabana ya, pe ná wan sama e tan, fu gi ala den somen sama ya?” ");
INSERT INTO djkNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ne Masaa Jesesi akisi den taki: “Onmen beele u abi?” Ne den piki en taki: “Wi abi seibin beele.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ne a taigi den sama taki: “U ala fiya sidon a doti.” Da ala den sama sidon enke fa Masaa Jesesi taki. Ne a teke den seibin beele, ne a gi Masaa Gadu daa moi, te a kaba. Ne a booko den beele pisipisi, ne a gi den bakaman fi en. Ne den teke den beele paati gi den sama. ");
INSERT INTO djkNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Da den be abi wantu fisi tu. Ne a teke den fisi, ne a gi Masaa Gadu daa. Ne a gi den bakaman fi en fu paati gi den sama tu. ");
INSERT INTO djkNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ne ala den sama nyan te den bee fuu. Da di den bakaman fu Masaa Jesesi piki san di den sama nyan fika, a fuu seibin bakisi. ");
INSERT INTO djkNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Da fu manengee wawan di nyan a doo fo dunsu. Da di den sama nyan kaba, ne Masaa Jesesi sende den fu den go a osu. ");
INSERT INTO djkNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Da fa i si a sende den sama gwe, ne en anga den bakaman fi en go a boto, ne den gwe a wan peesi den e kai Dalmanuta. ");
INSERT INTO djkNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Da wantu Faliseiman be yee taki Masaa Jesesi be kon de. Ne den kon fu kon tesi en. Ne den bigin fu sitee anga Masaa Jesesi. Den sitee anga en te, ne den taigi en taki: “We, a bun. Da du wan foondoo sani, osi? Meke u si, da u sa biibi taki, na Masaa Gadu sende i kon a goontapu tuu.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ne Masaa Jesesi dyeme, ne a akisi den taki: “Oho! Libisama! Saide meke u wani meke mi soi u maiki taki, na Masaa Gadu sende mi kon? Fu tuutuu mi ná o soi u ná wan maiki enke fa u wani de!” ");
INSERT INTO djkNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","14","Ne a daai fesi, ne a waka go a ini wan boto, ne a koti go na abaase fika den taampu taampu de. Da den bakaman fi en be feegete fu bai nyanyan. Da den be abi wan kodo beele namo. ");
INSERT INTO djkNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Da di den be de a pasi e gwe, ne Masaa Jesesi be bali den taki: “U mu luku bun anga a sowda fu den Faliseiman anga di fu Kownu Helowdesi.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Da di Masaa Jesesi bali den so, ne den e akisi denseefi taki: “San a taki? San wani taki a sani di a taki de? Oo, a fu di u á bai beele meke a taki so.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma, da Masaa Jesesi be sabi taki na so den e taki. Ne a taigi den taki: “A ná fu di u á tyai beele meke mi taigi u a sani de. U á fusutan fa mi de ete, no? A so u don? ");
INSERT INTO djkNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Luku onmen sani mi du di u si anga u ain anga onmen sani mi du di u yee anga u yesi. U feegete kaba, ");
INSERT INTO djkNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","fa mi be paati feifi beele gi feifi dunsu sama? Da onmen bakisi be de fanowdu fu u be poti san den sama be nyan fika?” Ne den piki en taki: “We, Masaa, na twalufu bakisi be fika.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ne Masaa Jesesi akisi den baka taki: “Di mi be paati den seibin beele gi den fo dunsu sama, onmen bakisi be fika?” Ne den piki Masaa Jesesi taki: “Masaa, na seibin bakisi be fika.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ne Masaa Jesesi akisi den taki: “Da te enke now, u á fusutan mi ete, no?” ");
INSERT INTO djkNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Da Masaa Jesesi anga den bakaman fi en doo wan peesi den e kai Betisaida. Ne den sama tyai wan beendiman kon ne en. Ne den begi en fu a sa langa ana oli a beendiman meke a si baka. ");
INSERT INTO djkNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ne Masaa Jesesi teke a man na ana tyai puu a pe somen sama be de. Ne a towe wataa mofu a ini a man ain, ne a poti ana ne en ain tapu. Ne a akisi en taki: “Yu e si sani kaba?” ");
INSERT INTO djkNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ne a man luku lontu, ne a piki taki: “We, mi e si sama e waka. Ma a gei enke na udu bon e waka e lontu.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ne Masaa Jesesi poti ana ete wan leisi ne en ain tapu. Ne di Masaa Jesesi puu ana, ne a man luku peesi lontu baka. Ne en ain kiin kelle, ai si sani bun baka enke fa wan libisama mu si. ");
INSERT INTO djkNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ne Masaa Jesesi sende a man taki: “Go a osu. Ma yu á mu go a ini a kondee go taigi sama taki na mi deesi yu.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ne moo lati, ne Masaa Jesesi anga den bakaman fi en go a den kondee kondee di de lontu Sesaleya Filipi. Da di den de a pasi e gwe di den waka doo wan pisi, ne Masaa Jesesi akisi den taki: “Sama den sama e taki mi de?” ");
INSERT INTO djkNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ne den piki taki: “We, wantu taki yu na Johanisi a Dopuman. Taawan taki yu na Eliya, ofu wan fu den taa fositen apaiti takiman fu Masaa Gadu di weki komoto a dede baka.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Da di den piki Masaa Jesesi so, ne a akisi den taki: “We u, no? Sama na mi?” Ne Peitilisi piki en taki: “Yu na a Kelestesi di Masaa Gadu sende kon!” ");
INSERT INTO djkNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ne Masaa Jesesi bali den taanga taanga taki: “U á mu taigi ná wan sama, sama mi de!” ");
INSERT INTO djkNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Da Masaa Jesesi bigin fu taigi den fu a gaan pina anga sitaafu di de fu kon ne en tapu. Ne a taigi den taki: “Den bigiman fu keliki anga den leliman fu Dyuweiti anga den gaansama fu kondee, o kai a Manpikin di saka kon toon libisama ya a kuutu. Da den o kii en. Ma te den kii en, da baka dii dei, da en o opo baka komoto a geebi.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Da di a taigi den so, ne Peitilisi kai en go a wanse. Ne a kaasi en. ");
INSERT INTO djkNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma namo, Masaa Jesesi daai luku den taa bakaman fi en. Ne a bali Peitilisi taki: “Pasa komoto a mi baka ya! Yu didibii, saatan yu! Peitilisi! A sani di i taki de, á de enke fa Masaa Gadu e pakisei. I taki enke fa libisama e pakisei.” ");
INSERT INTO djkNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ne Masaa Jesesi kai den taa bakaman fi en anga ala den sama di be kon makandii de kon moo koosube ne en. Ne a taigi den taki: “Efu wan sama wani waka a mi baka, da a á mu teli enseefi moo. Da a mu e tyai a sitaafu di o kon ne en tapu enke wan sama e tyai wan koloisi, fu den go sipikii en kii. ");
INSERT INTO djkNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","A sama di wani kibii en libi fu nyan fu a goontapu ya, sa lasi en libi. Ma a sama di ná abi toobi fu lasi en libi fu mi ede anga fu paati a Bun Nyunsu fu Masaa Gadu gi sama o libi tuutuu. ");
INSERT INTO djkNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Da san i wini efi i nyan fu goontapu, gudu te a gudu, ma i lasi a libi fu tego go a didibii faya? ");
INSERT INTO djkNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","San i sa pai fi i fende i libi baka? ");
INSERT INTO djkNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Da fa u de a goontapu ya, da somen sama fika Masaa Gadu go e du ala sowtu ogii. Da efu wan sama e sen gi mi anga mi wowtu, da te a Manpikin di saka kon toon libisama ya o daai kon baka, da sen o kisi en fi en tu. Bika, a o kon anga den apaiti Basiya fu Masaa Gadu Kondee*f6* anga gaan dyendee fasi fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ne Masaa Jesesi taigi den taki: “Mi e taigi u kiinkiin taki, son fu u di taampu ya ná o tesi dede, fosi u si a Nyun Tii fu Masaa Gadu kon doo anga ala a taanga fi en.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Da baka sigisi dei, ne a teke Peitilisi anga Jakowbesi anga Johanisi tyai go a wan hei mongo. Da na den wawan be de ape. Namo di den de na a mongo ede, ne den si Masaa Jesesi fesi anga en hii sikin e beenki mala mala e koti faya gelen gelen. ");
INSERT INTO djkNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","En koosi weti fann. Da ná wan sama fu goontapu sa wasi en koosi kiin so. ");
INSERT INTO djkNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ne den si Eliya anga Mosesi kon na a mongo wanboo wanboo so. Ne den bigin taki anga Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ne Peitilisi taki: “Masaa! Meke u tan ya! Meke u meke dii pikin osu na a mongo ede ya. Wan fi yu. Wan fu Eliya anga wan fu Mosesi. Bika a switi fu toko fu u de makandii ya!” ");
INSERT INTO djkNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Da na a feele di Peitilisi feele namo, meke a taki den sani ya. Bika a á be sabi san a mu taki. ");
INSERT INTO djkNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Da te fu den poti pakisei, ne wanboo wanboo so wan woluku saka kon tapu den. Ne wan Tongo taki a ini a woluku ini taki: “Disi na mi Manpikin, di mi lobi tuutuu. U aliki ne en san ai taigi u.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ne di den luku baka, ne, woo! Den á si ná wan sama moo enke Masaa Jesesi wawan. Eliya anga Mosesi gwe. ");
INSERT INTO djkNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ne di den e saka a mongo, ne Masaa Jesesi bali den taki: “U á mu taki san u si ya, ye! Ma, te a Manpikin di kon saka toon libisama a goontapu ya dede, te a opo baka a geebi, da u sa taki san u si ya.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Da na so den dii man ya oli a toli ya fu denseefi. Ma den dii man e akisi denseefi taki: “San wani taki a o dede, da a opo baka komoto a geebi?” ");
INSERT INTO djkNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne den akisi Masaa Jesesi taki: “Masaa Jesesi! Saide meke den leliman fu Dyuweiti e leli u taki, Eliya mu kon a goontapu fosi Masaa Gadu sende a Kelestesi kon?” ");
INSERT INTO djkNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Ne Masaa Jesesi piki den taki: “We, na so a de tuu, taki Eliya mu kon fosi fu seeka sani bunbun fosi a Kelestesi sa kon. Ma Eliya kon kaba, te den du san den wani anga en enke fa den apaiti takiman fu Masaa Gadu be taki. Ma san den apaiti takiman fu Masaa Gadu be taki fu a Manpikin di saka kon toon libisama ya? San libisama o du anga en? Den apaiti takiman fu Gadu be taki kaba taki: ‘Den o pina en, si en enke soso wisiwasi sani.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Di den kon doo a den taa bakaman fu Masaa Jesesi, ne den si den taa bakaman fu Masaa Jesesi anga somen sama. Da den anga wantu leliman fu Dyuweiti be e sitee anga denseefi. ");
INSERT INTO djkNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Da, ne te fu den sama poti pakisei, ne Masaa Jesesi e kon. Da den be foondoo seefi. Ne den sama lon go gi en odi. ");
INSERT INTO djkNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ne a akisi den taki: “San pasa? San meke u e sitee ya so?” ");
INSERT INTO djkNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ne wan man piki Masaa Jesesi taki: “Masaa, yeepi mi! Mi tyai mi manpikin kon a yu. Wan takuu jeje de ne en tapu. Da a takuu jeje ya e tapu en mofu fu a á poi taki. ");
INSERT INTO djkNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Da alaten a takuu jeje kon ne en tapu, ai towe enseefi a doti e kaw tifi e puu sukuma a mofu fukuu. Da ai tiiki tiloo e taanga kwakwakwaa. Da di mi á be si yu, ne mi tyai en go gi den bakaman fi yu fu den puu a takuu jeje ne en tapu. Ma den á be poi puu en.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ne Masaa Jesesi bali gi den bakaman fi en anga den taa sama taki: “Oho! Libisama! Saide meke den libisama fu a ten ya nái biibi ete? On langa mi mu oli pasensi anga u ete fosi u kon biibi Gadu? U tyai a pikin kon.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ne den sama tyai a pikin kon gi Masaa Jesesi. Ne di a takuu jeje si Masaa Jesesi, ne a subi a boi te, en sikin taanga kwakwakwaa. Ne a towe en a doti, e lolo kungulun, kungulun. Sukuma e komoto ne en mofu. ");
INSERT INTO djkNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ne Masaa Jesesi akisi a man taki: “On langa a pikin ya abi a siki ya kaba?” Ne a man piki taki: “Masaa! Na senten a de pikinengee. ");
INSERT INTO djkNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Na onmen toon a takuu jeje towe en a ini faya anga wataa fu kii. Da gaantangi baa, Masaa, mi e begi yu, efi i poi yeepi mi!” ");
INSERT INTO djkNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ne Masaa Jesesi piki a man taki: “I mu abi biibi a Gadu. Bika Masaa Gadu sa du ala sani gi wan sama di poti biibi ne en tapu.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ne a man bali wanten taki: “Masaa! Masaa! Mi e biibi. Ma a biibi fu mi á sai. Ma gaantangi, yeepi mi meke mi sa biibi.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Di Masaa Jesesi luku, ne a si taki moo anga moo sama e kon. Ne fosi den doo, ne a kaasi a sani taki: “Komoto ne en tapu gwe wanten! Yu didibii di e tei en tongo e dofu en yesi fu a á yee sani! Komoto ne en tapu gwe! Da noiti moo i mu kon moo ne en tapu moo.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ne a takuu jeje kon na a pikin tapu moo taanga, ne a bali taanga, ne a gwe. Ne a pikin didon pii enke a dede. Ne den sama denki taki a pikin dede. ");
INSERT INTO djkNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Masaa Jesesi oli en na ana, ne a opo en taampu. Ne a pikin taampu. A kon bun kelle. ");
INSERT INTO djkNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Da pikin moo a baka Jesesi anga den bakaman fi en go a ini wan osu. Ne den bakaman fi en akisi en taki: “Masaa! Saide meke wi á be poi kaasi a takuu jeje puu na a pikin tapu?” ");
INSERT INTO djkNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ne Masaa Jesesi piki den taki: “Den sowtu takuu jeje ya nái gwe efi i á de sondee nyan fu begi Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Da Masaa Jesesi anga den bakaman fi en komoto na a kondee. Ne den waka go a Galileya. Da Masaa Jesesi á be wani sama sabi taki a be de ape. ");
INSERT INTO djkNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bika a be wani de anga den bakaman fi en wawan fu leli den. Ne a taigi den taki: “Den o seli a Manpikin di saka kon toon libisama ya, gi takuu ati sama fu kii. Da den o kii en. Ma baka dii dei a sa opo baka komoto a geebi.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Da den bakaman fi en á be fusutan san a taigi den de. Ma anga ala fa den á fusutan san Masaa Jesesi taki de, toku ná wan fu den be abi a deki ati fu akisi en san wani taki a sani di a taki de. ");
INSERT INTO djkNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Da di den doo Kafalnayemu, ne den go a ini wan osu. Ne Masaa Jesesi akisi den taki: “San u be e taki a pasi di u be e kon?” ");
INSERT INTO djkNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma den á be poi piki en, bika den be kuutu anga denseefi on di fu den na a moo heiwan fu den ala den. ");
INSERT INTO djkNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ne Masaa Jesesi go sidon, ne a kai den kon. Ne a taigi den taki: “U aliki mi bun. Sama fu u di wani de a moo heiwan mu de a moo pikinwan a u mindii.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ne a kai wan pikin kon ne en. Ne a pikin kon. Ne a lolo a pikin a neki, ne a taigi den taki: ");
INSERT INTO djkNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wan sama di lobi mi te a teke wan mofina sama enke a pikin totii pikin ya oli fu gaan sani fu di a de fu mi ede, da na mi a oli fu gaan sani. Da sama di oli mi fu gaan sani, oli mi Tata di sende mi kon fu gaan sani tu.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ne Johanisi taigi Masaa Jesesi taki: “Masaa, u miti wan man di teke i nen e puu takuu jeje a sama tapu. Ma u bali en taki a á mu teke i nen fu puu takuu jeje a sama tapu so. Bika en a ná wan bakaman fi yu enke wi.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Masaa Jesesi piki den taki: “Nono! U be mu fika en. U á be mu tapu en. Bika wan sama di e teke mi nen e du foondoo sani, ná doo daai taki ogii fu mi esi esi. ");
INSERT INTO djkNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Da soseefi tu, wan sama di nái libi ogii anga wi, na wan sama fu wi.” Ne Masaa Jesesi taigi den go doo taki: ");
INSERT INTO djkNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Mi e taigi u tuutuu taki: Efu wan sama gi u wan gaasi wataa fu di u de bakaman fu mi, da a sa kisi en paiman fu dati. U biibi san mi e taigi u ya. San a du gi u de ná abi lasi.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ne Masaa Jesesi taigi den bakaman fi en go doo taki: “I si fa a pikin de ya? Da efuso wan sama kon e biibi mi, ne i meke a du wan sani fu puu en a Masaa Gadu pasi, da na gaan ogii i du de. Da a moo betee i be meke den tei wan gaanbigi siton a i neki, da den iti i go a ini ze liba. Da mi e taigi u taki a sitaafu di yu o kisi o hebi seefi seefi.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ne a taigi den moo go doo taki: “Efu na i ana e koli yu fu meke i du ogii, da i mu koti en puu towe. Bika a moo bun i de anga wanse ana, da i go a Masaa Gadu Kondee pe dede á de moo. Moo enke i de anga tu ana, da i go a didibii faya*f7* di nái kaba boon. ");
INSERT INTO djkNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Da efu na i futu e koli yu fu meke i du ogii, da i mu koti en puu towe. Bika a moo bun i de anga wanse futu, da i kiipi go a Gadu Kondee pe libi ná a kaba ná wan ten. Moo enke i de anga tu se futu, da den iti yu go a didibii faya, te a yuu doo. ");
INSERT INTO djkNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Da soseefi tu, efu na i ain e koli yu fu meke i du ogii, da i mu diki en puu towe. Bika a moo bun i de anga wanse ain, da i go a ini a Nyun Tii fu Masaa Gadu. Moo enke i de anga tu se ain, da den iti yu go a ini didibii faya. ");
INSERT INTO djkNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Da a pen fu a peesi de noiti abi kaba. Soseefi a faya noiti e tapu tu.” ");
INSERT INTO djkNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","50","Ne Masaa Jesesi taigi den baka taki: “We u luku! Sawtu na wan bun sani di e gi nyanyan tesi. Ma efu a lasi en kaakiti, da sani á de fu gi enmi en moo. Da na soseefi a libi fu u de. A mu abi kaakiti enke sawtu. Ma fosi a abi a kaakiti de, da u mu pasa a ini faya fosi. Ma efi i á pasa den somen sani de, da yu o de enke sawtu di lasi en kaakiti. Bika, ai yeepi wi fu a libi fu wi puu yeepi gi ala sama leti enke fa sawtu e gi nyanyan tesi. Da u mu libi fiifii anga useefi alaten.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ne Masaa Jesesi komoto ape, ne a go na a pisi fu Judeja na abaase fu a Joodani Liba. Da somen sama be kon ne en. Ne a bigin fu leli den enke fa a be gwenti. ");
INSERT INTO djkNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Da, ne wan duupu Faliseiman kon ne en. Da na kon den be kon tesi en. Di den doo, ne den akisi en taki: “Masaa, efu wan man anga wan uman libi, a bun fu a man fika a uman moo? San a weiti fu Gadu taigi u fu dati?” ");
INSERT INTO djkNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ne Masaa Jesesi akisi den taki: “San a weiti di Mosesi sikiifi fika gi u e soi wi?” ");
INSERT INTO djkNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ne den piki Masaa Jesesi taki: “Ya! A weiti fu Mosesi e soi wi taki, efu wan man wani, a sa paati anga en uman. Ma, da a mu meke wan pampila gi a uman taki en anga en á de moo. Da te a meke a pampila ya so, da a sa sende en gwe.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ne Masaa Jesesi piki den taki: “Na tuu san u taki. Ma u sabi fu san ede meke Mosesi be sikiifi a weiti ya fika gi u? Na fu di u ati taanga. U nái yee sani fu du san Masaa Gadu wani. ");
INSERT INTO djkNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma fosifosi, di Masaa Gadu be meke goontapu, da a be meke wan uman anga wan man. ");
INSERT INTO djkNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","A dati meke, wan man e fika en gaansama osu, fu go teke en uman libi. ");
INSERT INTO djkNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Da den tu sama de mokisa libi toon wan sikin. Da den nái teli fu tu sama moo, ma na wan sikin namo. ");
INSERT INTO djkNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Da ná wan sama mu paati san di Masaa Gadu meke toon wan.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ne di Masaa Jesesi kaba taki so, ne en anga den bakaman fi en go a osu baka. Ne di den de a osu de, ne den akisi en taki: “Masaa! San wani taki a sani di i taigi den sama de?” Ne Masaa Jesesi piki den taki: ");
INSERT INTO djkNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","“Efu wan man towe en uman fu go libi anga wan taa uman, da a kai a motyo libi. ");
INSERT INTO djkNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Da soseefi, efu wan uman towe en man fu go libi anga wan taa man, da a kai a motyo libi.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Da wantu sama be tyai den pikin kon a Masaa Jesesi, fu a be poti ana a den pikin tapu, begi Masaa Gadu gi den. Ma den bakaman fi en bali den, fu den á tyai den pikin kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma namo, Masaa Jesesi si, ne a mandii a den bakaman fi en. Ne a bali den taki: “U fika den pikin, meke denseefi kon doo a mi tu. U á tapu den! Bika na sama di abi a fasi di pikinengee abi sa poi go doo a ini a Nyun Tii a Masaa Gadu Kondee. ");
INSERT INTO djkNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Da efu wan sama nái biibi Masaa Gadu enke fa wan pikinengee e biibi sani, da a ná o poi doo a ini a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ne a teke den pikinengee wai kon ne en, ne a poti ana a den ede, ne a begi gi den. ");
INSERT INTO djkNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Namo, ne di Masaa Jesesi de a pasi e gwe, ne wan yonkuman lon kon ne en. Ne a sutu kini a doti, ne a bali taki: “Mi bun Masaa! San mi mu du fu mi fende a libi fu ten fu ten?” ");
INSERT INTO djkNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","19","Ne Masaa Jesesi piki en taki: “Saide meke yu e kai mi bun Masaa? Ma i sabi san yu e taki di yu e kai mi bun Masaa? A ná Masaa Gadu wawan bun, no? Da i sabi den weiti di Masaa Gadu poti gi den sama kaba. Dati na: ‘I á mu kii sama. I á mu waka anga taa uman ofu man. Da soseefi, i á mu fufuu, i á mu lei, i á mu koli sama nyan a den sikin. Da i mu lesipeki i mma anga i dda.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ne a man piki Masaa Jesesi taki: “We, Masaa! Senten mi de pikinengee, mi e oli ala den weiti de te enke tide.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ne Masaa Jesesi luku en dunn, ne tyali fu a man kisi Masaa Jesesi. Ne a taigi en taki: “Man, wan sani de di i mankei ete. Go a osu, da seli ala san yu abi, da paati a moni gi den pootiman, da i sa gudu a Gadu Kondee a tapu. Da te i seli den kaba, da kon baka fu toon wan bakaman fu mi.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ne a man kwinsi en fesi, ne a waka gwe anga gaanbigi tyali a ini en ati, bika a man ya be gudu tuutuu. ");
INSERT INTO djkNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ne Masaa Jesesi daai, ne a taigi den bakaman fi en taki: “U si fa a taanga gi wan guduman fu a kon a ini a Nyun Tii fu Masaa Gadu?” ");
INSERT INTO djkNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Da den bakaman fu Masaa Jesesi be foondoo seefi seefi. Ma Masaa Jesesi taigi den taki: “Eeye! A taanga seefi seefi gi wan guduman fu kon a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A taanga gi wan kameili*f8* fu waka pasa a wan nanai olo. Ma mi e taigi u taki, a moo taanga gi wan guduman fu a pasa kon a ini a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Da a sani di a taki ya be dangaa den bakaman fi en seefi seefi. Ne den akisi en taki: “Da sama o poi go a Nyun Tii fu Masaa Gadu seefi?” ");
INSERT INTO djkNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ne Masaa Jesesi luku den, ne a taigi den taki: “Efu u luku a libisama fasi, da ná wan sama o poi go. Ma Masaa Gadu e poi du ala sani.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ne Peitilisi piki taki: “We, Masaa, u no? U fika ala sani fu waka a yu baka e go anga yu na ala peesi!” ");
INSERT INTO djkNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ne Masaa Jesesi piki en taki: “Iniiwan sama di lobi mi te, a fika en osu efu en baala efu en sisa efu en dda efu en mma ofu pikin efu ala san a abi, fu a Bun Nyunsu ede. ");
INSERT INTO djkNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Da so wan sama o fende wan ondoo toon nownow fu san a fika fu kon waka a mi baka a goontapu ya, efu na osu, baala, mma, pikin anga gudu. Ma sama o de di o go e pina den fu mi ede tu. Da den o fende a libi fu tego a Masaa Gadu a bakaten tu. ");
INSERT INTO djkNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Da na a seefi ten ya, da somen fesiwan ya o toon bakaman. Da somen di de bakaman ya o daai toon fesiwan.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Da den de a pasi e go a Jelusalem Foto. Da Masaa Jesesi be e waka a den fesi. Da den bakaman fi en anga den sama di be e waka anga den be e tan so feele feele. Di den waka te wan pisi, ne Masaa Jesesi kai den twalufu bakaman fi en go a wanse fu taigi den san o pasa anga en. ");
INSERT INTO djkNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ne a taigi den taki: “U si fa wi e go a Jelusalem ya, den o seli a Manpikin di kon saka toon libisama ya, poti a ini a ana fu den bigiman fu keliki anga den leliman fu Dyuweiti. Da den o tyai en go a kuutu. Da den o fiti mofu fu kii en. Da den o poti en na ini ana fu den Loma sama di e tii a kondee ya. ");
INSERT INTO djkNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Da den sama de o meke sipowtu anga en lafu en. Den o towe wataa mofu a ini en fesi. Den o wipi en wan mesaandi wipi fosi, da den tyai en go kii. Ma baka dii dei te a dede, da a o opo komoto baka a dede.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Da di den e waka, ne den tu manpikin fu Da Sebedi di den e kai Jakowbesi anga Johanisi akisi en taki: “Masaa, u wani begi i wan sani baa. U wani begi yu fi i du wan sani gi u.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ne Masaa Jesesi akisi den taki: “San u wani begi mi?” ");
INSERT INTO djkNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ne den akisi en taki: “Masaa, na a ten di de a u fesi e kon te i sa ligei anga gaan lesipeki anga kaakiti, da meke u tu man ya sidon a yu se. Wan a yu leti ana se anga wan a yu kukutu ana se.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ne Masaa Jesesi piki den taki: “U sabi san u e akisi de? A gaan sitaafu anga pina di de fu kon a mi tapu u o poi tyai en? Na a ten di de a u fesi e kon, a gei enke mi o diingi wan gaan bita diingi a ini wan kan. Da u o poi diingi en?” ");
INSERT INTO djkNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ne den piki Masaa Jesesi taki: “Iya! U o poi diingi en.” Ne Masaa Jesesi piki den taki: “U sa diingi en tuu. Ma a pina di de fu kon a mi tapu o kon a u tapu tu. San o pasa anga mi o pasa anga u tu. ");
INSERT INTO djkNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma a á didon a mi fu taki sama sidon a mi kukutu ana efu mi leti ana. Na Masaa Gadu seefi e seeka peesi gi sama.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Da di den taa tin bakaman fu Masaa Jesesi yee taki Jakowbesi anga Johanisi akisi Masaa Jesesi fu so wan hei peesi, ne den ati boon seefi seefi. ");
INSERT INTO djkNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Da Masaa Jesesi kai den kon ne en. Ne a taigi den taki: “Den edeman fu kondee lobi taki a sama tapu. Den lobi dwengi sama, fu den du san den wani. ");
INSERT INTO djkNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma u á de enke den sama ya. U de taa fasi. Da u mu libi taa fasi tu. Efu wan sama wani de moo hei moo den taawan, da a mu saka enseefi fu e dini den taawan. ");
INSERT INTO djkNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Da efu wan fu u wani de a fesi fu den taawan, da a mu toon saafu gi den taawan. ");
INSERT INTO djkNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Da a Manpikin di saka kon toon libisama ya á kon fu libisama yeepi en. Ma a kon fu dini den, yeepi den a sani. A dati meke a o dede gi ala libisama fu puu den a ogii tyai den kon a Masaa Gadu baka.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ne Masaa Jesesi anga den bakaman fi en doo Jelikow. Ne moo lati di den e gwe, ne somen somen sama e waka a den baka. Da wan beendiman be sidon a sikin pasi e begi moni. Da na a man ya den be e kai Baatimeyosi. Da a nen ya wani taki, a pikin fu Timeyesi. ");
INSERT INTO djkNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Da di a yee taki na Masaa Jesesi fu Nasaleti e kon, ne ai bali taki: “Masaa Jesesi! Masaa Jesesi! Yu na a Bakaten Manpikin fu Kownu Dafeti paansu! Gaantangi, abi tyali ati fu mi, da yeepi mi, baa!” ");
INSERT INTO djkNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Da di ai bali so, ne den sama bali en taki: “Man, tapu mofu de!” Ma pe fu a beendiman ya tapu en mofu, ne na bali ai bali moo taanga taki: “Bakaten Manpikin fu Kownu Dafeti paansu! Yeepi mi baa, yeepi mi!” ");
INSERT INTO djkNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ne di Masaa Jesesi yee a bali, ne a taampu. Ne a taigi den sama taki: “U kai a man di e bali mi anda gi mi.” Ne den go kai a beendiman taki: “Man! Ná feele, kon! Masaa Jesesi e kai yu.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ne a dyombo opo taampu, ne a puu a koosi di a be e tapu koo, ne a waka go a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Di a waka te a doo, ne Masaa Jesesi akisi en taki: “Man, san meke yu e bali mi so? San i wani mi du gi yu?” Ne a man piki Masaa Jesesi taki: “Masaa! Mi wani i deesi mi ain fu mi sa si.” ");
INSERT INTO djkNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ne Masaa Jesesi taigi en taki: “Fu di i poti so wan biibi a mi meke yu ain kon bun enke fa a mu de.” We, di Masaa Jesesi taki so, ne wanten wanten a man ain kiin kelle, ne a bigin fu si sani bunbun. Ne a teke pasi e waka anga Masaa Jesesi anga den taa sama. ");
INSERT INTO djkNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Da di Masaa Jesesi anga den bakaman fi en de a pasi e go a Jelusalem, ne den doo na a pikin mongo di den e kai Oleifi Mongo, koosube fu Betifage anga Betaniya Kondee. ");
INSERT INTO djkNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ne Masaa Jesesi taigi tu bakaman fi en taki: “U go na a kondee a u fesi ya. Da te u go, da u o si wan pikin buliki teitei. Ná wan sama sidon na a buliki ya tapu lei ete. ");
INSERT INTO djkNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Da u losi en tyai kon. Da efu wan sama akisi u saide meke u e teke en, da u mu taigi den taki: ‘Masaa abi en fanowdu. Ma u o tyai en kon baka esi esi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Da den go na a kondee. Ne den si a buliki wanten wanten. A be de teitei a wan ponsu fu wan osu a sikin pasi. Ne den go fu losi en. ");
INSERT INTO djkNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Namo, da wantu sama si di den e losi a buliki. Ne den bali taki: “San e pasa? Pe u e go anga en?” ");
INSERT INTO djkNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ne den tu bakaman taki: “Nono! A ná fu wi. Ma na Masaa abi en fanowdu. Ma u o tyai en kon gawgaw baka.” Ne den sama taki: “A bun! U sa tyai en go.” ");
INSERT INTO djkNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Da na so den tyai a pikin buliki kon gi Masaa Jesesi. Ne den baala den dyakiti na a buliki mindii baka, ne Masaa Jesesi go sidon ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Da di a de a pasi e go, ne somen sama puu den dyakiti baala a pasi gi en fu a lei a den tapu. Somen taawan booko uwii poti a pasi gi en fu lei a den tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Da den sama di be e waka, ne en fesi anga en baka be e piisii te. Den e bali baya taki: “Hosana! Seigi fu Awan di e kon a ini a nen fu Masaa. ");
INSERT INTO djkNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Seigi fu a tii fu wi tata Dafeti di kon baka tuu. Hosana gi Masaa Gadu a tapu seefi!” ");
INSERT INTO djkNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na so a lei go a ini Jelusalem Foto. Ne a saka waka go a ini a Mama Keliki. Ne a luku ala den sani di den sama e du a ini a Mama Keliki. Ne di a kon lati, ne en anga den bakaman fi en go a Betaniya baka. ");
INSERT INTO djkNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Da a taa dei, ne den komoto a Betaniya. Da angii be kii Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Da di a luku faawe, ne a si wan figasii bon guun anga uwii pii. Na fu dati ede meke a go luku efu a sa fende nyanyan ne en fu a booko nyan. Ma di a doo na a bon, ne a si taki na soso guun uwii a bon abi. A ná abi ná wan enkii nyanyan. Bika a pisiten fu a yali, fu a bon ya be meke nyanyan á be doo ete. ");
INSERT INTO djkNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ne Masaa Jesesi fuuku a bon taki: “Noiti moo a wanten fu goontapu i sa meke nyanyan fu sama fende nyan.” Da den bakaman fi en yee di a be fuuku a bon so. ");
INSERT INTO djkNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ne Masaa Jesesi anga den bakaman fi en kon a Jelusalem. Ne a go wanten na a Mama Keliki. Ne di a go a ini a Mama Keliki, ne a yaki ala den sama di be e seli sani anga den sama di be e bai sani puu de. Ne a kandi den tafaa fu den sama di be e kengi moni fu bai sani a ini a Mama Keliki baka towe holow. Ne a daai, ne a kandi den tafaa fu den sama di be e seli doifi gi sama fu den go pai Masaa Gadu towe tu. ");
INSERT INTO djkNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne a tapu ala den sama di be teke a Mama Keliki enke gaan pasi e waka e go e kon anga sani fu seli. ");
INSERT INTO djkNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne a leli den taki: “Wan fu den apaiti takiman fu Gadu be sikiifi a Gadu Buku taki: ‘A osu fu Gadu mu de wan osu, pe ala foluku e kon begi makandii taki anga Masaa Gadu.’ Ma san u e meke Masaa Gadu osu toon? U e meke a toon wan osu fu fufuuman?” ");
INSERT INTO djkNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Da den bigiman fu keliki anga den leliman fu Dyuweiti be yee. Ne den e puubei fu fende wan fasi fu kii en puu a pasi. Den si taki den wowtu di Masaa Jesesi be foondoo den sama. Da na dati meke den be feele. ");
INSERT INTO djkNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Da di neti, ne en anga den bakaman fi en komoto gwe fika a foto enke fa den be gwenti ala neti. ");
INSERT INTO djkNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Da a taa dei fuuku mamanten, ne Masaa Jesesi anga den bakaman fi en e waka pasa a figasii bon di a be fuuku. A di den luku a bon, ne den si taki a dee te, a fika soso tyaka tyaka. ");
INSERT INTO djkNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ne Peitilisi denki san Masaa Jesesi be taigi a bon eside. Ne a bali taki: “Masaa, luku de! Ná a bon di i be fuuku, no? A dede te a fika soso tyaka tyaka.” ");
INSERT INTO djkNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Ma Masaa Jesesi piki den taki: “Efu u biibi Gadu, da u sa taigi a mongo ya taki: ‘Opo komoto ya go a ini ze.’ Da a sa pasa enke fa u taki. Ma efu u á biibi Gadu doo a ini u ati, da a ná o pasa. ");
INSERT INTO djkNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A dati meke mi e taigi u taki: Te u akisi Gadu wan sani, da u mu biibi dipi te a ini u ati taki a gi u en kaba. Da a sa pasa so. Wansi san u akisi Masaa Gadu te u e begi, u mu biibi taki u kisi en kaba. ");
INSERT INTO djkNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Da te yu go fu go begi taki anga Masaa Gadu, ma yu anga wan sama abi sani, da i mu gi en paadon. Da na soseefi i Tata o gi yu paadon tu fu den ogii di yu du. ");
INSERT INTO djkNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ma efu u á gi paadon, da u Tata a tapu ná o gi u paadon fu den ogii di u du tu.” ");
INSERT INTO djkNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Da Masaa Jesesi anga den bakaman fi en kon a Jelusalem Foto. Ne a go a ini a Mama Keliki. Ne den leliman fu Dyuweiti anga den moo hei apaiti begiman anga den gaansama fu Dyu Kondee kon ne en. ");
INSERT INTO djkNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ne den taigi en taki: “Fa yu du den sani a ini a Mama Keliki de, sama sende yu? Sama gi yu pasi fu du den sani di yu du de?” ");
INSERT INTO djkNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ne Masaa Jesesi piki den taki: “A bun, mi yee san u akisi mi. Ma mi seefi wani akisi u wan sani fosi mi piki u. Da efu u taigi mi, da mi o taigi u tu, sama gi mi pasi fu du den sani di mi du de.” ");
INSERT INTO djkNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ne a akisi den taki: “U taigi mi. Johanisi a Dopuman na Masaa Gadu be sende en fu dopu sama, efu na libisama be sende en?” ");
INSERT INTO djkNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ne den daai luku denseefi san fu den piki. Ne den bende a se. Ne den taki saafi saafi anga denseefi taki: “Efu u piki taki: ‘Na Gadu be sende en,’ da a o akisi u taki: ‘Saide meke u á be biibi a dopu fi en?’ ");
INSERT INTO djkNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Da efu u piki taki: ‘Ná libisama be sende en,’ da den sama fu a kondee o opo meke toobi anga wi.” Bika den sama fu a kondee be de sabi sabi taki Johanisi na be wan apaiti takiman fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Dati meke den piki Masaa Jesesi taki: “We, wi á sabi sama be sende Johanisi.” Ne Masaa Jesesi akisi den taki: “U á sabi, no? We, da mi nái taigi u tu sama gi mi pasi fu du den sani de.” ");
INSERT INTO djkNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ne Masaa Jesesi gi den wan ageisi toli fu wan gaan masaa di koti wan goon. A taki: “Di a kaba koti en, ne a paandi en, te a kaba anga wan sii den e kai doloifi. Di a kaba paandi en, ne a lontu en a dyali, fu sama á kon a ini a goon lawlaw. Soseefi a meke wan siton baki fu mii a doloifi. Ne a meke wan hei sodoo masanga go a tapu a ini a goon, fu waki a goon. Da di a du ala den sani ya, ne a yuu a goon gi taa paandi goon man. Ne a gwe a taa kondee. ");
INSERT INTO djkNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ne a de anda te di den doloifi lepi, ne a sende wan wookoman fi en, fu go teke fi en se doloifi kon gi en. ");
INSERT INTO djkNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma di a wookoman go, ne den man kisi en, ne den fonmi en te a fon, ne den sende en gwe anga soso ana ne en masaa baka. ");
INSERT INTO djkNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Ne a masaa fu a goon sende wan taa wookoman go. Ma disi yaaso, na a seefi. Den fonmi en te den basi en ede, du ala sowtu ogii anga en. ");
INSERT INTO djkNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Da a sende ete wan wookoman fi en go. Ma disi moo ogii. Den fonmi en te den kii en. Na so a masaa fu a goon sende somen somen taa wookoman fi en go. Ma den man du ogii anga ala fiya. Taawan den fon te den swaki potoo, taawan den kii. ");
INSERT INTO djkNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ne a man e denki a ini enseefi taki: ‘San mi mu du? Sama mi o sende go moo?’ Bika na awan kodo manpikin fi en be fika, di a be sa sende. Ne a taki: ‘I sabi san? Mi o sende awan kodo manpikin fu mi go. Bika disi na mi manpikin, da den musu abi lesipeki gi en.’ ");
INSERT INTO djkNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ma di den si a manpikin e kon, ne den pakisei taki: ‘A ná a pikin fu a masaa di yuu a goon gi u e kon de, no? Ne en ai! Meke u kii en, bika te a dda dede, da ala sani o fika gi en. Ma efu u kii en, da a goon o toon fu wi.’ ");
INSERT INTO djkNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ne den kisi en, ne den naki kii. Ne den fiingi en towe a busi.” ");
INSERT INTO djkNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ne Masaa Jesesi akisi den taki: “San u denki a gaan masaa fu a goon o du di a o yee taki, den kii a manpikin fi en tu? Ne enseefi o go luku en goon, no? Ne enseefi o go! Da a o kii den goon man, di a be yuu a goon gi puu a pasi, da a o yuu en gi taa sama.” ");
INSERT INTO djkNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ne Masaa Jesesi akisi den baka taki: “U á leisi Masaa Gadu Buku, no? We, a sikiifi taki: ‘Disi na a siton di meseeman be oli fu wan soso sani. Na dati daai kon toon a siton futu fu a hii osu. ");
INSERT INTO djkNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na so Masaa du en wooko. Ai foondoo gi wi, fu si.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Da den moo hei apaiti begiman fusutan bunbun taki, na den Masaa Jesesi be e poti na ageisi toli de so. Ne den ati boon ne en ogii ogii. Da na dati meke den be e suku wan fasi fu kisi Masaa Jesesi go sooto wanten wanten. Ma den á be poi kisi en, bika den be sabi taki den sama fu a kondee ati be o boon a den tuutuu. We, na fu dati ede meke den fika en, ne den gwe. ");
INSERT INTO djkNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ne di den gwe kaba, ne den sende wantu Faliseiman anga wantu bakaman fu Kownu Helowdesi go a Masaa Jesesi. Da den be mu suku Masaa Jesesi mofu fu a taki sani di á bun fu den be sa fende en kii. ");
INSERT INTO djkNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Di den doo a Masaa Jesesi, ne den taigi en taki: “Mesiti! U sabi taki den sani di yu e taki, na tuutuu sani. Yu na wan kiinkiin sama. Yu e soi libisama fa Masaa Gadu wani den libi. Yu ná abi toobi anga san libisama e taki. Yu á lobi wan sama moo enke taawan. Ma u kon fu akisi yu wan sani.” Ne den akisi en taki: “Taigi u, efu a de fanowdu fu u pai a moo gaan kownu a Loma Foto, a lantimoni. ");
INSERT INTO djkNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Da i si a de fanowdu, fu u pai dati?” Ma Masaa Jesesi be sabi kaba san den be wani du. A sabi taki na suku den be kon suku en mofu fu den be sa fende e kii. Ne a akisi den taki: “Na kon u kon puubei mi, no? Saide meke u kon puubei fu fasi mi so? We, u tyai wan moni kon gi mi, osi?” ");
INSERT INTO djkNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ne den tyai a moni kon gi en. Ne a akisi den taki: “Sama fesi de na a moni ya tapu? Sama nen sikiifi ne en?” Ne den piki taki: “Na a moo gaan kownu a Loma Foto.” ");
INSERT INTO djkNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ne Masaa Jesesi akisi den taki: “We, efu na a moo gaan kownu a Loma Foto fesi, anga en nen den ne en tapu, da na fu a gaan kownu. Da gi a gaan kownu de san de fu a gaan kownu de. Ma gi Masaa Gadu san na fu Masaa Gadu.” Da den foondoo fu a fasi fa Masaa Jesesi piki den ya. ");
INSERT INTO djkNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ne bakadati, ne wantu Saduseisama kon a Masaa Jesesi fu akisi en wan sani. Da den Saduseisama na sama di nái biibi taki te wan sama dede a sa weki baka komoto a dede. ");
INSERT INTO djkNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Namo den taigi Masaa Jesesi taki: “Mesiti! Masaa Gadu be meke Mosesi sikiifi a Gadu Buku gi wi taki: ‘Ofu wan man anga wan uman libi, ma a man dede sondee fu meke pikin anga a uman, da a baka baala fu a man mu libi anga a uman fu meke pikin gi a baala di dede.’ Da na so a weiti fu Mosesi e leli wi. ");
INSERT INTO djkNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ma namo, da seibin baala be de. A moo gaanwan libi anga wan uman te a dede, a á meke ná wan kodo pikin anga en. ");
INSERT INTO djkNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ne a pikin baala di waka ne en baka teke a uman libi. Ma enseefi dede sondee fu meke wan pikin anga en. Da soseefi di fu dii baala teke a uman libi. Ma enseefi dede sondee fu meke wan pikin anga en. ");
INSERT INTO djkNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Da na so ala den seibin baala libi anga a uman te ala den dede. Ná wan di meke wankodo pikin anga en seefi. Ne te fu kaba, ne a uman seefi dede. ");
INSERT INTO djkNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","We, Masaa, u wani akisi yu: ‘Te a yuu o doo fu den sama opo komoto a dede, da on di fu den man ya o abi a uman?’ We, bika ala den seibin baala be libi anga en.” ");
INSERT INTO djkNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ne Masaa Jesesi piki den taki: “U á sabi leti leti san sikiifi a Gadu Buku. Da u á sabi a kaakiti di Masaa Gadu e weki sama puu a dede tu. ");
INSERT INTO djkNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Bika te sama o opo baka a dede, da uman anga man libi ná o de moo. Den o de enke Basiya fu Masaa Gadu Kondee*f9*. ");
INSERT INTO djkNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma boiti dati, da u á leisi san Mosesi be sikiifi poti a Gadu Buku, no? Den Buku fu Mosesi sikiifi taki, wan leisi Mosesi be si wan busi e boon. Ne di a luku a busi bun, ne a yee Masaa Gadu taigi en taki: ‘Mi na a Gadu di den gaansama fu u di den e kai Abalaham, Isaki anga Jakopu e begi.’ ");
INSERT INTO djkNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Masaa Gadu á de a Gadu fu sama di e dede gwe, da a kaba. Ma en na a Gadu fu sama di anga ala fa den sikin dede seefi, toku den e libi. Da u misi anga san u akisi de.” ");
INSERT INTO djkNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Da wan fu den leliman fu Dyuweiti be yee fa Masaa Jesesi piki den Saduseisama wan koni fasi. Ne a man ya waka kon moo koosube. Ne a akisi Masaa Jesesi taki: “Masaa! Fu ala den somen Dyuweiti di de, on di fu den na a moo heiwan?” ");
INSERT INTO djkNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ne Masaa Jesesi piki en taki: “A moo hei weiti na a weti di taki: ‘U aliki, sama fu Islayeli Kondee. Masaa Gadu, a Gadu fu wi, ne na awan kodo Gadu di de. ");
INSERT INTO djkNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Da u mu lobi en anga u hii ati. Da soseefi u mu lobi en anga ala u akaa anga ala u pakisei anga ala u kaakiti.’ Taa weiti á de di bigi moo disi. ");
INSERT INTO djkNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Da di fu tu weiti taki: ‘I mu lobi taa sama enke fa i lobi iseefi.’ Moo gaan weiti moo den tu weiti ya á de.” ");
INSERT INTO djkNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ne a leliman fu Dyuweiti taigi en taki: “Na tuu Masaa, san yu taki. Na wan kodo tuutuu Gadu namo de. Da ná wan taa Gadu de enke en. ");
INSERT INTO djkNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Da u mu lobi en anga u hii ati. Soseefi u mu lobi en anga ala u pakisei anga ala u kaakiti. Da u mu lobi ala taa sama enke fa u lobi useefi. Da den tu weiti ya hei moo enke a weiti di taki: ‘U mu kii meti boon gi Masaa Gadu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Da Masaa Jesesi si taki a man fusutan bunbun, bika a piki en bun. Ne a taigi a man taki: “Yu á de faawe moo fu kon a ini a Nyun Tii fu Masaa Gadu.” Da di Masaa Jesesi piki a man ya so, ne ná wan sama be abi a deki ati moo, fu akisi en wan sani. ");
INSERT INTO djkNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Da di Masaa Jesesi de a ini a Mama Keliki e leli den sama te wan pisi, ne a akisi den taki: “Fa den leliman fu Dyuweiti sa leli u taki Kelestesi, na wan bakaten manpikin fu Kownu Dafeti paansu namo, da a kaba? ");
INSERT INTO djkNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bika, we na a Jeje fu Masaa Gadu be piki Kownu Dafeti seefi taki: ‘Masaa Gadu taigi mi Masaa taki: “Sidon a mi leti ana se ya, te enke mi poti ala den feyanti fi yu a yu futu ondoo.” ’ ");
INSERT INTO djkNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","We, Kownu Dafeti seefi kai en, Masaa. Da efu Kelestesi na be wan bakaten manpikin fu Kownu Dafeti namo, da i denki taki, a be o kai en, Masaa?” We, di Masaa Jesesi piki den so, da a be switi gi den somen sama di be taampu de e aliki. ");
INSERT INTO djkNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ne Masaa Jesesi bali den taki: “U mu luku bun anga den leliman fu Dyuweiti. Den lobi wei gaan moi langa dii yapon e waka e lontu fu sama mu si den. Da te den e waka a den wowoyo peesi den lobi te den sama e gi den odi anga gaan lesipeki. ");
INSERT INTO djkNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te den de a ini den Dyu keliki den lobi sidon te a fesi enke bigiman. Da soseefi den e suku a moo bun peesi te den sidon a tafaa fu nyan. Da na so den e poti denseefi enke bunbun sama. ");
INSERT INTO djkNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ma u mu luku bun fu u á teke a fasi fu den fu libi. Bika den e teke somen sani fu den pooti uman di man dede fika a ganda. Te anga den osu fu den uman ya seefi den e teke. Da anga ala a fasi de, den e begi gaan langa begi fu soi sama fa den bun anga fa den lobi Gadu. Da den sama ya o kisi a moo gaan sitaafu fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ne Masaa Jesesi waka go sidon na a se fu a baki pe den sama e poti keliki moni te den kon a keliki. Ne a luku fa den sama e poti moni te a kaba. Da somen guduman be poti tyaipi moni. ");
INSERT INTO djkNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Da di den poti te wan pisi, ne a si wan pooti uman di á be abi man moo be kon poti tu. Ne ai luku onmen a uman ya o poti. Ne a si a poti tu kopoo sensi go a ini a baki. ");
INSERT INTO djkNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ne Masaa Jesesi kai den bakaman fi en taki: “U kon!” Ne den kon. Ne a taigi den taki: “U si a pooti uman de? A poti tu kopoo sensi namo go a ini a baki, ma fu tuu, a poti ipi moo ala den taawan di poti. ");
INSERT INTO djkNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bika den guduman gi san di den á be abi fanowdu. Ma a uman ya poti ala san a be abi. A á kibii ná wan kopoo sensi fi enseefi.” ");
INSERT INTO djkNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Da di Masaa Jesesi anga den bakaman fi en komoto a ini a Mama Keliki, ne wan fu den taki: “Masaa, luku de fa a Mama Keliki moi! Den siton di den meke en bigi!” ");
INSERT INTO djkNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ne Masaa Jesesi piki den taki: “Weeno! U si ala den gaanbigi osu de? Sama o feti booko ala fiya te a doti. Ná wan ná o taampu de moo.” ");
INSERT INTO djkNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ne Masaa Jesesi go sidon na a Oleifi Mongo na abaase fu a Mama Keliki. ");
INSERT INTO djkNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ne Peitilisi anga Jakowbesi anga Johanisi anga Andeleyasi kon ne en. Ne den anga en wawan de ape. Ne den akisi en taki: “Masaa Jesesi, on ten a sani di i taigi u de o pasa anga a Mama Keliki? Da san na den maiki di wi o si taki a yuu doo fu sowan sani pasa?” ");
INSERT INTO djkNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ne Masaa Jesesi piki den taki: “U mu luku bun anga useefi fu sama á koli u kisi puu na a biibi. ");
INSERT INTO djkNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bika somen sama o opo e koli sama taki na den na a Kelestesi. Da den o koli somen sama kisi. ");
INSERT INTO djkNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","U o yee fu oloku feti ya anga fu oloku feti so. Ma u á mu feele! Bika, den sani ya musu fu pasa. Ma te den sani ya e pasa, da u á mu si enke na a kaba fu goontapu doo kaba. ");
INSERT INTO djkNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Bika na ala se fu goontapu u o yee taki, kondee kondee fu goontapu o opo go feti anga denseefi. Foluku foluku o opo feti anga denseefi. Kownu fu kondee o opo feti anga denseefi. Doti o go e seke piiti kii sama a somen pisi fu goontapu. Gaan angiiten o kon a goontapu tu. Ma disi a ná a kaba fu goontapu ete. Bika moo ogiiten e kon ete. Ma disi na a bigin, fu a gaan pina a goontapu di o waka enke a hii banowtu di wan bee uman e fii. ");
INSERT INTO djkNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ma u dati, u mu koni anga useefi! Den o kisi u tyai go a kuutu osu fesi fu mi ede. Den o fonmi u a ini den Dyu keliki fu den. Da den o tyai u go a fesi fu kownu anga tiiman fu kondee. Da u mu teke den okasi ya fu taigi ala sama fu saide u e biibi a mi. ");
INSERT INTO djkNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bika ala sama mu yee a Bun Nyunsu fu Masaa Gadu fosi a goontapu kaba. ");
INSERT INTO djkNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma te den kisi u fu tyai go a kuutu, u á mu booko u ede san u o taki. U á mu taki fu useefi. A Jeje fu Masaa Gadu di de a ini u, o gi u, a u ati, san fu taki a yuu de. ");
INSERT INTO djkNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Da sama o de di o seli den baala gi sama fu kii. Dda o seli pikin gi sama fu kii. Pikin ná o lesipeki den mma anga den dda moo. Da den o seli den dda anga den mma gi sama fu kii tu. ");
INSERT INTO djkNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Da soseefi ala sama o abi ogii ati fu u, fu di u de fu mi ede. Ma sama di o tei fu oli doo, te anga dede seefi, sa fende a libi fu tego a Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Na a ten di de a u fesi e kon, da sama o si a takuu kiiman. A o de na a apaiti peesi fu Masaa Gadu a ini a Mama Keliki a Jelusalem. Da den sama di de a Judeja mu lon go a den mongo go kibii.” A sama di e leisi a sani ya, mu leisi en bunbun fu fusutan san ai leisi. ");
INSERT INTO djkNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Den sama di o de a doose á mu go a ini den osu fu go teke sani. Den mu lon. ");
INSERT INTO djkNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Den sama di o de a goon e wooko á mu daai fu go a osu fu go teke koosi. Den mu lon. ");
INSERT INTO djkNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Da a ten ya o takuu seefi gi den uman di de anga bee, ofu den uman di de anga pikin na ana. ");
INSERT INTO djkNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","U mu begi Masaa Gadu fu a takuu ten ya á pasa na a koo pisiten fu a yali. ");
INSERT INTO djkNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bika wan sitaafu de fu kon a goontapu. Da senten di goontapu sete, te enke tide, noiti so wan sitaafu be kon ete. Da soseefi noiti sowan sitaafu sa kon moo tu. ");
INSERT INTO djkNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma Masaa Gadu satu den dei ya. Bika efu ná so, ná wan sama be o fika anga libi a goontapu. Ala fiya be o dede. Ma a satu den dei ya fu den sama di e biibi ne en ede. ");
INSERT INTO djkNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Da te wan sama o kon a u taki: ‘Masaa Jesesi Kelestesi de ya.’ Ofu, ‘A de so.’ Kweti Kweti! U á biibi den, ye! ");
INSERT INTO djkNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sama o koli u taki, den na Kelestesi. Taawan o koli u taki, den na apaiti takiman fu Masaa Gadu. Da den o go e du gaan foondoo sani tu fu puubei fu ali den sama di e biibi a Masaa Gadu puu ne en, efu den be man. ");
INSERT INTO djkNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mi e taki gi u a fesi. U luku bun anga useefi, fu san di de a fesi fu kon. U á meke sama koli u kisi.” ");
INSERT INTO djkNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Da, ne Masaa Jesesi taki go doo taki: “Da na a yuu de, te a gaan sitaafu anga pina pasa, ‘da a san fesi o dunguu. Da a mun ná o kiin peesi moo tu. ");
INSERT INTO djkNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Da hii goontapu, a tapu a den woluku o seke. Da den sitali di de a tapu o komoto a den peesi kai.’ ");
INSERT INTO djkNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Da bakadati, da ala sama o si a Manpikin di saka kon toon libisama ya, a tapu a den woluku ini. A o kon anga gaan dyendee anga ala makiti. ");
INSERT INTO djkNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Da a o sende den Basiya fu Masaa Gadu Kondee*f10*, fu kon piki ala den sama di be e biibi en na ala se fu goontapu, kon na awan.” ");
INSERT INTO djkNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ne Masaa Jesesi taigi den go doo taki: “U denki wan figasii bon. Te u si taki, ai piiti boomiki, da u sabi kaba taki, a o meke nyanyan dyonson. ");
INSERT INTO djkNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Da leti enke fa u sa luku wan figasii bon fu si taki a o meke nyanyan dyonson, na so u sa luku den sani di mi taigi u de fu si taki a kaba fu goontapu de koosube.” ");
INSERT INTO djkNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ne Masaa Jesesi taigi den taki: “Fu tuutuu mi e taigi u, den paansu sama ya ná o dede fosi den sani di mi e taigi u ya pasa. ");
INSERT INTO djkNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Den sani fu tapu a den woluku anga ala sani a goontapu a doti ya o pasa wan dei. Ma mi wowtu di mi taki, ná o kaba ná wan ten.” ");
INSERT INTO djkNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ma ná wan sama sabi a yuu di mi o daai kon baka a goontapu. Soseefi, ná wan sama sabi a dei tu. Den Basiya fu Masaa Gadu Kondee á sabi. Da a Pikin seefi á sabi. Ma na a Tata wawan sabi on ten. ");
INSERT INTO djkNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ma u mu luku bun anga useefi. U mu teke den sani di mi taigi u ya, oli bunbun a ede. U á sabi a yuu di a sani ya o pasa. ");
INSERT INTO djkNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“A sani ya de enke wan sama di go a taa kondee. Da di ai gwe, ne a fika den wookoman fi en a baka fu luku en osu gi en. Da iniiwan fu den wookoman abi en wooko di a mu du. Ne a taigi a wakitiman taki: ‘Oli a waki bun. Da e luku on ten mi o kon baka. Bika yu á sabi on dei mi o kon kaba.’ ");
INSERT INTO djkNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Na soseefi a mu de anga u tu. U mu e luku on ten mi o kon. Bika u á sabi on ten mi o kon. U á sabi efu na sapaten, efu na gaan mindii neti, efu na kaka efu na san opo mamanten, te san pii. ");
INSERT INTO djkNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","U á mu de a siibi, bika, kande te fu u denki, da haa! Mi doo. Da mi kon miti u siibi siibi, sondee fu u kaba. ");
INSERT INTO djkNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","San mi taki gi u ya, de fu ala sama. U tan na ain! U tan luku on ten mi o kon baka.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Da a yuu di Masaa Jesesi be e taki anga den bakaman fi en de, da a be fika tu dei fosi a Pasika Fesa fu den Dyusama be doo. Da a pisiten ya, den e nyan paata beele di meke sondee sowda. ");
INSERT INTO djkNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Da den hei apaiti begiman anga den leliman fu Dyuweiti taki: “Wi mu suku wan fasi fu kii a man Jesesi puu a pasi. Ma wi á mu kisi en na a fesa ya. Bika, da den sama o opo taampu meke opuulu anga wi.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Da Masaa Jesesi be de a wan foto den e kai Betaniya a ini a osu fu wan man den be e kai, Simon a Gwasiman. Da di den sidon fu nyan, ne wan uman kon a ini a osu. Da a tyai wan moi pikin bataa anga wan gaan dii switi sumee fatu fu onmen tenti dunsu kolu a ini. Ne a waka langa langa te a Masaa Jesesi. Ne a opo a bataa, ne a kandi a dii switi sumee fatu kunkunkun towe a Masaa Jesesi ede. ");
INSERT INTO djkNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Da fa a uman kandi a switi sumee fatu a Masaa Jesesi ede so, da a á be bun gi wantu fu den taa sama di be sidon a tafaa e nyan. Ne den bali a uman taki: “Saide meke yu towe a dii switi fatu ya poli so du? ");
INSERT INTO djkNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","I be sa seli a fatu fu tyaipi moni, da i be paati a moni gi den pootiman.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Masaa Jesesi yee den, ne a bali den taki: “U fika en meke a du san ai du. Saide meke u e bali en du? San di a uman ya du na wan bun sani a du gi mi ya. ");
INSERT INTO djkNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Bika pootiman o de alaten fu solugu. Da efu u wani gi den moni, da alaten u sa gi den. Ma mi na fu wan pisiten mi de ya anga u. Da efu wan sama wani du wan bun gi mi, da na now a mu du en gi mi. A uman ya du ala san a be sa du gi mi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Da a sani di a uman du ya, ná wan soso sani. A fatu di a iti a mi ede tapu ya, na seeka a seeka a sikin fu mi kaba. Bika dyonson den o kii mi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Da fu tuutuu mi e taigi u taki, goontapu ná o feegete a sani di a uman du gi mi ya. Bika na ala se fu goontapu, pe den o taki a Bun Nyunsu, den sa taki fu a sani di a uman ya du gi mi.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Da Judasi Iskaliyotu, wan fu den twalufu bakaman fi en komoto peb, ne a waka tilo tilo, te a den hei apaiti begiman. Ne a taigi den taki: “Efu u wani, mi sa yeepi u fu kisi a man Jesesi.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ne di Judasi taigi den so, den piisii seefi. Ne den taigi Judasi taki: “Judasi, efi i yeepi wi enke fa i taki wi o pai yu.” Da di den taigi en so, ne a daai go baka a Masaa Jesesi. Da fanafu a ten de, ne ai lulu on ten a sa fende pasi fu seli Masaa Jesesi gi den hei apaiti begiman. ");
INSERT INTO djkNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ma namo, da a fosi dei fu a Pasika Fesa doo. Da den e kii wan pikin sikapu na a fosi dei di den be o nyan a beele sondee sowda. Da di a dei doo, ne den bakaman fu Masaa Jesesi akisi en taki: “Masaa, pe i wani meke u nyan a Pasika ya? Efi i taigi wi, da u sa go seeka ala sani.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ne Masaa Jesesi kai tu fu den bakaman fi en, ne a sende den taki: “U go a Jelusalem. Da te u o go, da u o si wan man anga wan bungu wataa a pasi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Da u mu waka ne en baka te na a osu pe ai go. Da te u doo, da u mu taigi a man di abi a osu taki: ‘Masaa Jesesi sende u fu akisi en on pisi fu a osu u sa nyan a Pasika Fesa tide neti.’ ");
INSERT INTO djkNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Da a o tyai u go a sodoo go soi wan gaan kambaa. Da ala sani di u abi fanowdu fu seeka sani de a ini a kambaa de kaba. Da u seeka sani de fu u nyan a Pasika.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ne den tu man go enke fa Masaa Jesesi sende den. Di den doo Jelusalem, ne ala sani waka enke fa a be taigi den. Ne den seeka sani fu den nyan a Pasika. ");
INSERT INTO djkNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","18","Da di sapaten, ne Masaa Jesesi anga den taa bakaman fi en kon na a osu. Ne den sidon fu nyan. Da di den sidon e nyan, te wan pisi, ne Masaa Jesesi taigi den taki: “Fu tuutuu, wan fu u di sidon e nyan anga mi ya, o seli mi gi den ogii ati sama den kii.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Da di Masaa Jesesi taigi den so, a sani be toobi den ati tuutuu. Den ati booko. Ne wan fu wan den e akisi taki: “Sama sa de ya di o seli Masaa, no? Masaa a sa de taki, na mi?” ");
INSERT INTO djkNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ne Masaa Jesesi piki taki: “Eeye, wan fu u twalufu di e dipi beele anga mi a ini awan baafun ya, o seli mi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","We, a de so taki, den apaiti takiman fu Masaa Gadu be sikiifi fu a Manpikin di saka kon toon libisama ya. Da ala den sani de fiya mu pasa enke fa den be taki. Ma, heelu fu a sama di o seli a Manpikin di saka kon toon libisama ya! A moo betee, a á be meke kon a ondoo goontapu wan dei.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ne Masaa Jesesi teke wan beele, ne a gi Masaa Gadu daa, ne a booko en pisipisi. Ne a gi den bakaman fi en taki: “U luku ya! Disi na mi sikin. U teke, da u nyan.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ne a teke wan kan win, ne a gi Masaa Gadu daa, ne a gi den bakaman fi en taki: “U luku ya! U diingi.” Ne den diingi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne a taigi den taki: “A win ya na mi buulu di sa lon gi somen sama fu meke den anga Masaa Gadu kon bun baka. Disi na wan nyun kuudei di Masaa Gadu o meke anga libisama. Bika na a buulu fu mi o pai fu ala den takuudu anga ogii. ");
INSERT INTO djkNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Da fu tuutuu, mi ná o diingi win na a sowtu fasi ya moo, fu te enke mi de a ini a Nyun Tii fu Masaa Gadu, fu diingi en wan nyun fasi.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ne den singi wan singi gi Masaa Gadu gaandi. Ne den opo komoto de e gwe na a mongo, di den e kai Oleifi Mongo. ");
INSERT INTO djkNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ne di Masaa Jesesi anga den bakaman fi en de a pasi e gwe, ne a taigi den taki: “U ala fiya o lon kibii fika. Da a o pasa leti enke fa Masaa Gadu Buku taki. Bika a sikiifi taki: ‘Te mi o kii a soluguman fu den sikapu, da ala den sikapu o lon panya panya gwe na ala se.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ne a taigi den go doo taki: “Ma te mi o opo baka komoto a dede, da mi o go a u fesi fu miti anga u a Galileya.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ne Peitilisi piki en taki: “Masaa, awansi ala sama o lon kibii fika yu wawan, mi noiti o fika yu.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ne Masaa Jesesi piki en taki: “Peitilisi, fu tuutuu, mi e taigi yu! A neti ya seefi, fosi wan kakafoo bali tu toon, yu o lei dii toon taki yu á sabi mi.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ne Peitilisi akisi en taki: “Masaa! Mi o taki mi á sabi yu? Noiti! A moo betee mi anga yu dede! Ma noiti mi o lei taki mi á sabi yu.” Da soseefi den taa bakaman fi en piki tu. Da di Masaa Jesesi taigi den so kaba, ne den gwe. ");
INSERT INTO djkNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Da den go a wan peesi den e kai Getsemanei Dyali. ");
INSERT INTO djkNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne Masaa Jesesi taigi den bakaman fi en taki: “U kon sidon ya. Mi o waka go pikinso moo faawe fu begi.” Da a tyai Peitilisi anga Jakowbesi anga Johanisi go anga en. ");
INSERT INTO djkNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne Masaa Jesesi bigin fuka te a taigi den dii bakaman fi en taki: “Ai hebi gi mi! Mi o dede! U tan ya, da u oli begi.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ne a waka go pikinso moo faawe, ne a losi enseefi towe a doti holow. ");
INSERT INTO djkNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ne a begi taki: “Kee, Masaa Gadu, mi Tata*f11*! Ná wan sani de di yu á poi du. Ala sani fiya i sa du. Da mi begi yu, puu a kan di i lai gi mi ya fu diingi, efu a kan. Ma mi Tata, a ná san mi wani mu pasa, ma meke sani waka enke fa yu wani.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Da, di Masaa Jesesi begi so, ne a go a den dii bakaman fi en baka. Ne a si den siibi siibi. Ne a weki den. Ne a akisi Peitilisi taki: “Simon! Yu e siibi? Yu á poi meke taanga sikin, fu de anga ain wankodo yuu langa anga mi seefi, no? ");
INSERT INTO djkNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","U tan na ain oli waki! Da u begi taanga, fu didibii á wini u. Bika mi sabi taki, u ati wani, ma sikin ná abi kaakiti sai.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ne Masaa Jesesi waka gwe baka, ne a begi a seefi begi enke fa a be begi kaba. ");
INSERT INTO djkNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ne a daai go a den bakaman fi en baka. Ne a si taki den kai a siibi baka, bika den ain be hebi. Da den á be sabi san fu piki Masaa Jesesi moo tu. ");
INSERT INTO djkNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ne a go baka go begi di fu dii toon. Da di a daai kon baka, ne a si taki den man fi en e siibi baka. Ne a akisi den taki: “U e siibi baka? We, a sai! ");
INSERT INTO djkNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","U opo meke u gwe. Luku de! A yuu doo di a sama di seli a Manpikin di saka kon toon libisama ya, gi den ogii ati sama, doo kaba.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Da fa i si Masaa Jesesi kaba taki so, ne Judasi, wan fu den twalufu bakaman fu Masaa Jesesi doo anga onmen tenti man. Da den be tyai fetihow anga kodya fu kon kisi Masaa Jesesi. Da na den hei apaiti begiman anga den leliman fu Dyuweiti anga den gaansama fu kondee be sende den man ya kon anga Judasi fu kon kisi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Da Judasi be meke mofu anga den sama de kaba taki: “A sama di mi o bosi, da ne en na Jesesi. Da u mu kisi en oli kankan fu a á komoto gwe.” Da na so den anga Judasi be meke mofu. ");
INSERT INTO djkNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ne di den man doo, ne Judasi waka langa langa go a Masaa Jesesi. Ne a taki: “Mesiti, u de?” Ne a baasa en gwulu, ne a bosi en ne en sikin mofu. ");
INSERT INTO djkNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Da den man sabi kaba taki na a man de na Jesesi. Ne den kisi en gwaa oli kinkin fu tyai gwe. ");
INSERT INTO djkNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma namo, wan fu den bakaman fu Masaa Jesesi ali en fetihow salla, ne a koti wan fu den wookoman fu a moo hei apaiti begiman yesi puu felen, towe a doti pow. ");
INSERT INTO djkNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ne Masaa Jesesi akisi den sama di kon anga Judasi taki: “Fu saide u tyai fetihow anga kodya fu kon kisi enke mi na wan takuu ati sama di e suku fu booko kondee? ");
INSERT INTO djkNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Saide meke u á be kisi mi, di mi be de ibii dei a ini a Mama Keliki e leli sama fu Masaa Gadu? Ma na fu di a mu waka enke fa Masaa Gadu Buku be taki a fesi, na dati meke u e du so.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Da di den kisi Masaa Jesesi so kaba, ne ala den bakaman fi en lon kibii fika en wawan. Ne den man tyai Masaa Jesesi gwe. ");
INSERT INTO djkNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Da di den e tyai Masaa Jesesi gwe, da wan kiyoo be e waka a den baka e luku pe den be e tyai Masaa Jesesi go. A boi ya be wei wan koosi enke pangi ne en neki lasi. Ne den ogii man di kisi Masaa Jesesi e tyai gwe lon kon kisi a kiyoo ya tu gwulu. ");
INSERT INTO djkNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ma namo, a feti te ala a koosi komoto ne en sikin, ne a lon gwe piipii sondee koosi ne en sikin. ");
INSERT INTO djkNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Da den man tyai Masaa Jesesi go na a moo hei apaiti begiman. Da den hei apaiti begiman anga den gaansama fu kondee be ali kon miti de. Soseefi den leliman fu Dyuweiti tu. ");
INSERT INTO djkNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Namo, da Peitilisi be e waka te a baka e fiingi ain e luku pe den o tyai Masaa Jesesi go. Da a waka anga den fu te a ini a dyali fu a moo hei apaiti begiman. Ne a go sidon e waan faya makandii anga den man di be e oli waki. ");
INSERT INTO djkNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Da den hei apaiti begiman anga ala a Dyulanti fu kuutu sani, oli wan kuutu a ini a osu. Da na a kuutu di den be oli ya, den be o suku sama di be sa taki a seefi sani fu sowtu fowtu den sabi fu Masaa Jesesi, fu a á soi enke na fu soso den kii en. Ma den á fende den sama di be poi fu taki a seefi fowtu sani fu Masaa Jesesi di den sabi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Da na somen sama di be e taki lei lei sani fu Masaa Jesesi. Ma den sani di den be e taki be e kengi anga den seefi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne wantu fu den opo, ne den taki somen lei fu Masaa Jesesi. Den taki: ");
INSERT INTO djkNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“We, u yee a taki na libisama meke a Mama Keliki osu fu den Dyu. Da a sa booko en, da a meke en baka a ini dii dei, sondee fu libisama ana. Disi a ná sama taigi wi. Na useefi yee anga u yesi.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma ala den sani di den taki ya seefi be e kengi anga den seefi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Da a moo hei apaiti begiman, di be sidon a mindii fu a kuutu opo taampu, ne a akisi Masaa Jesesi taki: “Saide meke i nái piki a tapu fu den sani di den sama e taki fi i ya? Den sani ya na tuu, efu na lei den e lei gi yu?” ");
INSERT INTO djkNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ma Masaa Jesesi á piki en ná wan mofu. A de fi en pii. Ne a moo hei apaiti begiman akisi en baka taki: “Na yu na a Kelestesi, a Manpikin fu a Seigi Wan?” ");
INSERT INTO djkNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ne Masaa Jesesi piki en taki: “A de letiso enke fa iseefi taki de. Da wan dei e kon di u o si a Manpikin di kon saka toon libisama ya sidon sidon a leti ana se fu Masaa Gadu, di abi ala taki. Da soseefi u sa si mi e kon a tapu a den woluku tu.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ne di Masaa Jesesi piki so, ne a moo hei apaiti begiman ati boon te, a ali en koosi piiti ne en sikin dalla. ");
INSERT INTO djkNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ne a taki: “U ná abi ná wan sama fanowdu moo fu taigi u sowtu ogii a man ya du. U yee fa ai meke sipowtu anga Gadu? San wi o du anga en?” Ne ala den man piki taki: “A mu dede!” ");
INSERT INTO djkNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Da wantu fu den bigin towe wataa mofu a ini Masaa Jesesi fesi. Ne den tei wan koosi tapu en ain. Da den e naki en, ne en fesi kwaa. Da te den naki en, da den e meke sipowtu anga en taki: “Taigi u, osi! Apaiti takiman fu Masaa Gadu, sama naki yu?” Da den wakitiman fu kownu, di be e oli waki a kownu paleisi seefi, bigin naki Masaa Jesesi tu. ");
INSERT INTO djkNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Da Peitilisi de a ini a dyali fu a osu ete a yuu di den e naki Masaa Jesesi so. Ma namo, da wan fu den uman di e wooko a ini a osu fu a moo hei apaiti begiman si Peitilisi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ne a uman ya luku en bun a pe a sidon e waan faya, ne a akisi en taki: “Hei! Yu ná wan fu den man fu Jesesi, no? A man fu Nasaleti Kondee?” ");
INSERT INTO djkNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ne Peitilisi seke ede taki: “Nono! Ná mi! Mi á sabi a sama di i e taki de.” Ne a opo fu waka go na a dyali mofu. Ne wanten wanten wan kakafoo bali, kokoliyekee. ");
INSERT INTO djkNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Da a uman ya si di Peitilisi e waka e gwe. Ne a waka ne en baka. Ne a taigi den sama di taampu na a dyali mofu taki: “A man ya, na wan man fu a man Jesesi!” ");
INSERT INTO djkNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ne Peitilisi bali taki: “A ná tuu! Yu e lei gi mi.” Ne ala den sama di be taampu de bali taki: “Eeye! Yu na wan fu den bakaman fu a man Jesesi! Yu na wan Galileya sama.” ");
INSERT INTO djkNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ne Peitilisi e sitee te ai sweli, taki a á sabi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Fa i si a kaba fu sitee, ne a kakafoo bali baka, kokoliyekee, di fu tu toon. Ne a kisi enseefi wanten san Masaa Jesesi be taigi en. Masaa Jesesi be taigi en taki, fosi wan kaka foo bali tu toon yu o lei dii toon taki, yu á sabi mi. Ne a poti ana a mindii ede bali wan gaan adyumadye. ");
INSERT INTO djkNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Namo, da fuuku mamanten, ne den hei apaiti begiman anga den leliman fu Dyuweiti anga den gaansama fu kondee oli wan gaan kuutu baka. Da na a kuutu ya den be o luku san fu den du anga Masaa Jesesi. Ne den fiti mofu taki den o sende Masaa Jesesi go a Gaaman Pilatesi.*f12* Na so den bui en ana, ne den tyai en gwe a Gaaman Pilatesi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ne Gaaman Pilatesi akisi Masaa Jesesi taki: “Yu na a kownu fu den Dyu?” Ne Masaa Jesesi piki taki: “Na letiso a de, enke fa i si i taki de.” ");
INSERT INTO djkNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Den hei apaiti begiman bigin taki ala sowtu ogii anga lei fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ne Gaaman Pilatesi akisi Masaa Jesesi taki: “I nái taki ná wan sani, no? Yee de, fa den sama e taki somen ogii fi yu.” ");
INSERT INTO djkNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Masaa Jesesi de pii. A á piki ná wan sani. Da Gaaman Pilatesi be foondoo di Masaa Jesesi á piki. ");
INSERT INTO djkNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Da Gaaman Pilatesi be gwenti fu puu wan sama a dunguu osu ala Pasika Fesa. Da ala yali a be e akisi den foluku, sama den wani a puu a dunguu osu. Da na sama di den be wani a be puu a dunguu osu, na a sama de a be e puu. ");
INSERT INTO djkNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma namo, da wan ogii kiiman den be e kai Balabasi, be de a dunguu osu a ten de. A man ya anga wantu taa man be kii sama di den be opo feti anga a Loma lanti. ");
INSERT INTO djkNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Da wanlo sama di be komoto na a kuutu kon a Masaa Jesesi baka e bali gi Gaaman Pilatesi taki: “Gaaman Pilatesi, u wani i puu wan man a sitaafu osu gi wi enke fa i gwenti du ala Pasika.” ");
INSERT INTO djkNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ne Gaaman Pilatesi akisi den taki: “Sama u wani mi puu a dunguu osu gi u a yali ya? U wani meke mi losi a kownu fu den Dyu gi u?” ");
INSERT INTO djkNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bika Gaaman Pilatesi be sabi taki na fu dyalusu ede meke den hei apaiti begiman anga den leliman fu Dyuweiti be wani kii Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ne den hei apaiti begiman, di be de a den sama mindii e sutu faya a ondoo gi den sama fu den meke Gaaman Pilatesi losi Balabasi. Na so den sama bali: “Gaaman Pilatesi, na Balabasi i mu puu a sitaafu gi wi! Na Balabasi u wani meke i puu a sitaafu gi wi!” ");
INSERT INTO djkNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ne Gaaman Pilatesi akisi den taki: “Da san mi mu du anga a sama di den e kai Kownu fu den Dyu?” ");
INSERT INTO djkNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne den bali taki: “Sipikii en a koloisi puu de!” ");
INSERT INTO djkNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ne Gaaman Pilatesi akisi den baka taki: “Saide mi mu sipikii en kii? Sowtu ogii a du?” Ne den bigin bali moo taanga taki: “Sipikii en a koloisi! Sipikii en! Sipikii en! Sipikii en puu de.” ");
INSERT INTO djkNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Da Gaaman Pilatesi á be wani opuulu anga den sama. Na dati meke a losi Balabasi. Ne a meke den suudati fi en wipi Masaa Jesesi wan mesaandi wipi. Ne di a meke den wipi en so kaba, ne a gi den suudati fi en Masaa Jesesi fu den tyai go sipikii kii. ");
INSERT INTO djkNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ne den suudati tyai Masaa Jesesi go a wan peesi a ini a dyali fu Gaaman Pilatesi, ne den kai ala den suudati kon makandii. ");
INSERT INTO djkNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ne den puu en koosi, ne den wei wan gaan langa, baaw lebi koosi enke di kownu e wei gi en. Ne den teke wan takuu sowtu maka enke agwago, ne den lolo en enke a ati di kownu e wei. Ne den wei en gi en fu pee enke na wan kownu ati a wei. ");
INSERT INTO djkNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ne den bigin meke sipowtu anga en e soso en taki: “Odiyoo lesipeki Kownu fu Dyu!” ");
INSERT INTO djkNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne den naki en anga wan tiki ne en ede gwoo. Soseefi den towe wataa mofu ne en. Ne den saka kini a doti e meke sipowtu e soso en enke na lesipeki anga gaandi den e gi en so. ");
INSERT INTO djkNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Da di den kaba meke sipowtu anga en soso en so kaba, ne den puu a koosi di den be wei gi en, ne den wei enseefi koosi gi en baka. Ne den tyai en puu a ini a kondee go na a peesi pe den be o sipikii en na a koloisi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Da di den de a pasi e tyai Masaa Jesesi fu go sipikii kii, ne den miti a dda fu Aleksandi anga Lufosi di den be e kai Simon fu Sileni Kondee a pasi. Ne den dwengi en fu tyai a koloisi fu Masaa Jesesi gi en. ");
INSERT INTO djkNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na so den tyai Masaa Jesesi go na a peesi di den e kai Golgata. Golgata wani taki, Edebon Peesi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ne den gi en win anga mile oli a ini. Ma a á wani diingi en. ");
INSERT INTO djkNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na so den sipikii Masaa Jesesi na a koloisi. Ne den iti lowte paati a koosi fi en gi den seefi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dati be sa de wanten fu neigin yuu mamanten so di den sipikii Masaa Jesesi poti na a koloisi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Da den be sipikii wan pisi paanga poti a Masaa Jesesi ede tapu taki: ");
INSERT INTO djkNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Da boiti Masaa Jesesi, da den be koloisi tu taa man makandii anga en de. Wan de ne en leti ana se, a taawan de ne en kukutu ana se. Masaa Jesesi be de a mindii. We, den tu taa man de na sama di be de gaan fufuu kiiman. ");
INSERT INTO djkNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Da a sani ya waka leti enke fa Masaa Gadu wowtu sikiifi taki: “A be de a pe den ogii ati sama de enke en na wan ogii ati sama tu.” ");
INSERT INTO djkNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Da den sama di be e waka pasa be e seke ede, da den be e bali gi en taki: “O! Luku de. A ná a sama di be o booko a Mama Keliki, da a be meke en baka a ini dii dei, no? ");
INSERT INTO djkNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Da puu iseefi na a koloisi pe i de ape meke u si no, di i taanga so!” ");
INSERT INTO djkNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Da den bigiman fu Dyu keliki anga den leliman fu Dyuweiti be e meke sipowtu anga en e poti en wisiwasi taki: “A be e yeepi taa sama. Ma now a á poi yeepi enseefi.” Ne den e meke sipowtu anga en taki: ");
INSERT INTO djkNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“O, Kelestesi! Kownu fu Islayeli Kondee! Puu iseefi na a koloisi meke u si, no? Da u sa biibi taki yu na a kownu fu den Dyu tuu.” Da soseefi den taa man di den be sipikii na a koloisi de, be e sipowtu anga en tu. ");
INSERT INTO djkNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Da di twalufu yuu kisi, ne a hii kondee dunguu pii enke na neti. Da a dunguu ya be oli go miti dii yuu bakadina. ");
INSERT INTO djkNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Da na a dii yuu de, ne Masaa Jesesi bali taanga taki: “Eloi, Eloi, lama sabaktani?” Dati wani taki: “Mi Gadu, mi Gadu, saide i fika mi wawan so?” ");
INSERT INTO djkNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Da di wanlo sama di be taampu de, yee a bali “Eloi, Eloi,” ne den bali taki: “U aliki anda! Ai kai Eliya fu kon yeepi en.” ");
INSERT INTO djkNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ne wan man lon go teke wan siponsu, ne a dipi en go a ini wan asin di be de ape, ne a poti a wan tiki ede, ne a langa go a Masaa Jesesi mofu fu a diingi. Ne a man taigi den sama taki: “U tan pii! Meke u luku efu Eliya o kon yeepi en tuu.” ");
INSERT INTO djkNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ne Masaa Jesesi bali wan taanga bali, ne en boo koti. ");
INSERT INTO djkNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","Da di a edeman fu den suudati si fa Masaa Jesesi boo koti, ne a taki: “Aai! Eeye! A sama ya na a Manpikin fu Masaa Gadu tuu.” Da a seefi yuu di Masaa Jesesi boo koti, ne a gaan deki gaiden di be e tapu a kambaa, piiti dalla fu tapu, te a doti a tu pisi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Da wantu uman be taampu a faawe e luku. Da Maliya fu Makidala anga Salome anga Maliya, a mma fu Yowsesi anga Jakowbesi be de a ini tu. ");
INSERT INTO djkNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Da den uman ya anga tyaipi taa uman be kon anga en, di a be e kon a Jelusalem. Da na den uman ya be e solugu Masaa Jesesi anga den bakaman fi en a somen fasi. ");
INSERT INTO djkNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","We, pikinso moo, da a kina dei di den Dyu be e seeka gi, be o kai. Da den Dyusama á be o poi du ná wan sani moo, fu a dei de. ");
INSERT INTO djkNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Namo, na a yuu de, ne wan fu den hei man di de wan Dyulanti fu kuutu sani, den be e kai Jowsef fu Alimateya Kondee, kon na a peesi pe den be sipikii Masaa Jesesi. A be de wan sama di e fuuwakiti a Nyun Tii fu Masaa Gadu. Ne Jowsef teke deki ati, ne a go a Gaaman Pilatesi, ne a akisi en taki: “Gaaman Pilatesi, mi kon begi i wan sani, baa. I sa gi mi pasi fu mi puu a dede sikin fu Masaa Jesesi na a koloisi, go beli?” ");
INSERT INTO djkNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ne Gaaman Pilatesi akisi en taki: “Jesesi dede kaba? Mi á wani biibi!” Ne a sende kai a edeman fu suudati di be e oli waki na a koloisi fu Masaa Jesesi. Ne a man kon. Ne Gaaman Pilatesi akisi en taki: “A man Jesesi, di den sipikii a mamanten ya, a dede kaba?” ");
INSERT INTO djkNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ne a suudati piki taki: “Iya, Gaaman, a dede kaba.” Ne Pilatesi taigi Jowsef taki: “Jowsef! I sa teke a dede sikin fu Jesesi go beli enke fa i akisi.” ");
INSERT INTO djkNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ne Jowsef go, ne a bai sibikoosi te a kaba. Ne a puu a dede sikin fu Masaa Jesesi na a koloisi. Ne a lolo en a ini a sibikoosi. Ne a tyai a dede sikin fu Masaa Jesesi go poti a ini wan siton olo di den be diki poti de fu beli sama. Da di a poti a dede sikin go a ini a olo kaba, ne den lolo wan gaanbigi siton tapu a olo mofu. ");
INSERT INTO djkNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Da Maliya Makidala anga Maliya, a mma fu Yowsesi be go anga Jowsef go luku pe a be o poti a dede sikin fu Masaa Jesesi. Da na so a dede anga a beli fu Masaa Jesesi be waka. ");
INSERT INTO djkNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Da di a kina dei fu den Dyu pasa, ne Maliya fu Makidala anga Salome anga Maliya a mma fu Jakowbesi, bai switi sumee sani fu go lobi na a dede sikin fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ne, sonde mamanten fuuku fa i si san opo, ne den dii uman e go na a siton geebi olo. ");
INSERT INTO djkNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Da, di den de a pasi e go, ne den pakisei taki: “Fa wi o du puu a gaanbigi siton na a olo mofu?” ");
INSERT INTO djkNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma, di den doo na a olo, ne den si taki a gaanbigi siton lolo komoto na a olo mofu kaba. ");
INSERT INTO djkNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ne den go a ini a siton geebi olo. Ne haa, den si wan yonkuman. A wei weti koosi fann sidon a den leti ana se. Ne den foondoo, te den poti ana a mofu. ");
INSERT INTO djkNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ne a yonkuman taigi den taki: “U á feele! A ná Jesesi fu Nasaleti, di den sipikii kii a koloisi u e suku, no? A opo komoto a dede kon a libi baka! A á de ya! U luku de pe a be didon! ");
INSERT INTO djkNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","U go, da u taigi den bakaman fi en anga Peitilisi taki: ‘Ai go a den fesi a Galileya. Da a sa miti den anda enke fa a be taigi den.’ ” ");
INSERT INTO djkNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ne den komoto a ini a siton geebi olo, ne den lon gwe anga gaan feele na ati anga ala beifi sikin. Den á taigi ná wan sama wan sani, bika feele be moo den. ");
INSERT INTO djkNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","We, sonde mamanten fuuku di Masaa Jesesi opo baka komoto a dede, da na Maliya fu Makidala na a fosi sama di si en. Di Masaa Jesesi be e waka e deesi sama a be puu seibin takuu jeje na a uman ya tapu. ");
INSERT INTO djkNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ne a go, ne a taigi den bakaman di be de anga gaan buduufu na ati e tyali e kee e kusumi. ");
INSERT INTO djkNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Da den á biibi en, di a taigi den taki a si Masaa Jesesi, bika a weki baka komoto a dede kon a libi. ");
INSERT INTO djkNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Moo lati, ne Masaa Jesesi soi enseefi gi tu bakaman fi en di den be de a ini a kondee e waka go a den osu. Bika a á be soi enseefi gi den enke fa a be gwenti. ");
INSERT INTO djkNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ne den tu bakaman daai go baka a Jelusalem go taigi den taawan. Ma den taawan á be wani biibi den tu. ");
INSERT INTO djkNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Da wan leisi, di ala den elufu bakaman sidon e nyan makandii, ne Masaa Jesesi kon a den mindii haa. Ne a bali den fu a fasi fa den nái biibi, anga fu di den á be e biibi den sama di taigi den taki den si en. ");
INSERT INTO djkNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ne Masaa Jesesi taigi den taki: “U go na ala peesi a goontapu, da u taigi ala sama a Bun Nyunsu fu mi. ");
INSERT INTO djkNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Da sama di o biibi teke dopu, sa fende a libi fu tego. Ma sama di ná o biibi, o fende a tego sitaafu.” ");
INSERT INTO djkNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne a taigi den go doo taki: “Den gaan foondoo sani ya, o pasa a mindii fu den sama di e biibi mi tuutuu. Den sa teke mi nen yaki takuu jeje puu a sama tapu. Den o taki taa tongo taki. ");
INSERT INTO djkNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Efu den oli takuu sineki anga ana, sani ná o du den. Efu den diingi takuu sani seefi, sani ná o du den. Den o poti ana a sikiman tapu, da den sikiman sa kon bun baka.” ");
INSERT INTO djkNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Da, baka di Masaa Jesesi taki anga den bakaman fi en so, ne Masaa Gadu teke en tyai go a tapu, a Masaa Gadu Kondee. Na anda Masaa Gadu gi en a moo hei peesi ne en leti ana se. ");
INSERT INTO djkNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ne den bakaman fi en opo go paati a Bun Nyunsu na ala se. Da Masaa Gadu taampu gi den seefi seefi. Bika den du somen foondoo foondoo sani di e soi taki a Bun Nyunsu di den e tyai, na Masaa Gadu a komoto tuu!");
INSERT INTO djkNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","We, mi Lukasi e sende bigi odi gi yu, mi gaan lesipeki mati Teyofili. So, enke fa i sabi, da somen sama sikiifi sani kaba fu a libi fu Masaa Jesesi. Da, na san den sama di be si anga den eigi ain anga den fosi diniman fu a Bun Nyunsu taigi den, na dati den sikiifi. Ma, miseefi ondoosuku den sani ya fini fini enke fa den waka tuutuu, fu sikiifi sende gi yu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Da yuseefi sa si taki, na pilisisi a seefi enke san, di i be leli kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Da a yuu di Helowdesi be de kownu fu Judeja, da i be abi wan apaiti begiman den be e kai Sakalia. A be de a kulu apaiti begiman fu Abiya. A uman fi en na be fu a lo fu Aalon tu, enke Sakalia seefi. ");
INSERT INTO djkNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakalia anga Elisabeti, na tu sama, di be e libi letiopu fasi gi Masaa Gadu. Den be e oli ala weiti fu Masaa Gadu. Ná wan sama, di be poi fende wan fowtu a den. ");
INSERT INTO djkNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma, Sakalia anga Elisabeti á be abi ná wankodo pikin. Bika Elisabeti á be poi de anga bee. Ma soseefi, da Sakalia anga Elisabeti, na be tu gaandi sama kaba tu, di á be poi meke pikin moo. ");
INSERT INTO djkNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ma, namo da wan dei, da Sakalia anga den taa hei apaiti begiman fu a kulu fu Abiya, be mu wooko a ini a Mama Keliki. ");
INSERT INTO djkNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Da, den be abi a gwenti, fu iti lowte luku on di fu den apaiti begiman mu go a ini a Mama Keliki a dei de, fu boon switi sumee sani gi Masaa Gadu. Di den iti a lowte, ne a soi taki, na Sakalia mu go. ");
INSERT INTO djkNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Da, di a go, da somen sama be de na a keliki e begi. ");
INSERT INTO djkNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Namo, di Sakalia de a ini a keliki, ne a si wan Basiya fu Masaa Gadu Kondee*f1* wan toon wan toon so. A taampu na a leti ana fu a apaiti begi tafaa, di den e boon switi sumee sani gi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Da, di Sakalia si a Basiya fu Masaa Gadu Kondee, ne a feele te en ati piiti. ");
INSERT INTO djkNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ne a Basiya taigi en taki: “Ná feele, Sakalia! Masaa Gadu yee den begi fi yu. Yu uman, Elisabeti, o meke wan manpikin. Da i mu kai a pikin ya, Johanisi. ");
INSERT INTO djkNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Da a pikin ya o gi yu gaan piisii. Da soseefi a o meke somen taa sama abi gaan piisii tu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bika a o de wan bigiman a Masaa Gadu ain. Da noiti a pikin ya á mu diingi win efu taanga diingi di e duungu sama. Da fanafu en mama bee, da a Jeje fu Masaa Gadu o de ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“A o tyai somen sama fu Islayeli kon daai libi baka kon a Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A pikin o de enke a apaiti takiman fu Masaa Gadu di den be e kai Eliya, enke fa a Jeje fu Masaa Gadu be de a Eliya tapu. Soseefi, leti enke fa a Jeje fu Masaa Gadu be e tii Eliya, na soseefi a o tii a pikin ya tu. Da a o waka a Masaa fesi, fu seeka ala sani gi en, fosi a kon. Da a o daai den dda anga den pikin ati, meke den daai libi bun anga denseefi. A o meke den di á be e aliki Masaa Gadu daai libi kon e libi, enke den sama di e libi bun a Masaa Gadu ain. Leti enke fa mi taki ya, na so a o pasa.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ne Sakalia akisi a Basiya fu Masaa Gadu Kondee taki: “Fa mi sa sabi taki, den sani di i taki ya na tuu? Bika mi anga Elisabeti gaandi pasa a peesi kaba fu meke pikin.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ne a Basiya fu Masaa Gadu Kondee piki en taki: “Mi na Gabiliyeli*f2*. Mi e tan koosube fu Masaa Gadu. Ne en sende mi kon, fu taigi yu den sani ya. Ma yu á biibi mi. ");
INSERT INTO djkNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Da, fu di yu á biibi san mi taigi yu, meke yu ná o poi taki moo, fu te enke a dei di ala den sani di mi taki ya pasa. Bika, a dei o doo, di den sani ya o pasa tuu leti enke fa mi taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Da den sama di be de a doose be e luku Sakalia fu a kon a doose. A be foondoo den fa Sakalia be tan langa a ini a keliki osu so. ");
INSERT INTO djkNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ne den sama de a doose te, fosi Sakalia kon a doo. Ma di Sakalia kon a doo, ne na anga ana ai taki anga den sama. Bika a á be poi taki moo. Ne den sama sabi kaba taki, Sakalia miti anga wan sani a ini a keliki osu. Bika a be e soi den anga ana. ");
INSERT INTO djkNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ne Sakalia tan du en wooko a ini a Mama Keliki, te di a yuu doo, ne a go a osu baka. ");
INSERT INTO djkNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ne a á langa moo bakadati, ne Elisabeti, a uman fu Sakalia, oli bee. Da di a oli a bee kaba, ne a tapu enseefi a osu feifi mun langa. A nái go a pe sama de. ");
INSERT INTO djkNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ne Elisabeti taki: “Masaa Gadu, i du gaan bun gi mi, baa! Bika yu puu sen a mi ain, a libisama fesi.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Da di Elisabeti de anga sigisi mun bee, ne Masaa Gadu sende Gabiliyeli, wan fu den Basiya fu Masaa Gadu Kondee, go a Nasaleti a Galileya, ");
INSERT INTO djkNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","a wan yonkuu uman den e kai Maliya. Jowsef be poti mofu ne en fu libi. Jowsef na be wan bakaten pikin fu Kownu Dafeti paansu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Da di a Basiya fu Masaa Gadu Kondee kon a Maliya, ne a gi en odi taki: “Fa ai go, Maliya? I abi bun ede moo ala uman. Masaa Gadu de anga yu. Ne a teke gaan bun ati fasi namo luku yu. Bika a abi gaan piisii anga yu.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ma namo, di Maliya yee den wowtu ya, a be feele, te a be wani buuya, bika a á be sabi san den be wani taki. ");
INSERT INTO djkNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ne a Basiya fu Masaa Gadu Kondee taigi en taki: “Ná feele, Maliya! Masaa Gadu teke yu poti apaiti fasi, fu du wan bun gi yu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bika yu sa de anga bee, da yu o meke wan manpikin. Da te a pikin ya meke, da i mu kai en, Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A pikin ya sa hei a Masaa Gadu ain. Da den o kai en, Pikin fu a moo Hei Gadu a tapu. Masaa Gadu o gi en a kownu sutuu fi en avo gaansama Dafeti, fu tii sani. ");
INSERT INTO djkNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Da a o tii den bakaten pikin fu a avo gaansama fu Dyusama, Jakopu. A tii fi en sa de fu tego.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ne Maliya akisi a Basiya taki: “Fa mi o du de anga bee? Mi á siibi anga man wanten.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ne a Basiya piki en taki: “A Apaiti Jeje fu Masaa Gadu o kon a ini yu anga kaakiti, da i sa de anga bee. Da fu di na a Apaiti Jeje o meke i de anga bee, meke den sa kai a pikin ya, Pikin fu Masaa Gadu. A pikin ya libi o seeka de silli apaiti fasi, sondee fowtu gi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","I sisa Elisabeti de anga sigisi mun bee nownow na a gaandi gaandi yuu fi en ya. Da a sa meke wan manpikin. I si? A Elisabeti, di ala sama be e taki ná o meke pikin ná wan ten moo, ne en de anga bee. ");
INSERT INTO djkNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bika ná wan sani de di Masaa Gadu á poi du. Ala san di Masaa Gadu taki, musu pasa enke fa a taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","We, ne Maliya piki a Basiya fu Masaa Gadu Kondee taki: “A bun! Mi de a ini mi Masaa ana ini. Meke a du anga mi enke fa i taki de.” Ne, di den taki so, te den kaba, ne a Basiya fu Masaa Gadu Kondee gwe fi en baka. ");
INSERT INTO djkNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Da wan satu pisiten a baka di a Basiya fu Masaa Gadu Kondee taki anga Maliya so kaba, ne Maliya opo, ne a waka esi esi go na a pisiwataa fu Judeja, a wan pikin kondee a den mongo mindii. ");
INSERT INTO djkNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Da di a doo a kondee kaba, ne a go a Sakalia osu. Ne a gi Elisabeti odi. ");
INSERT INTO djkNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma namo, di Elisabeti yee a odi fu Maliya, ne a pikin dyombo a ini en bee e sikopu futu. Ne a Jeje fu Masaa Gadu kon a Elisabeti tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ne Elisabeti bali taki: “Maliya! Seigi fi yu a Masaa Gadu bigi moo ala taa uman. Soseefi seigi fi yu a Masaa Gadu bigi, fu a pikin di de a ini i bee de tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ne Elisabeti taki go doo taki: “Oho! Fa mi du abi a bun ede ya, taki a mama fu mi Masaa kon a mi osu kon luku mi? ");
INSERT INTO djkNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Bika, di mi yee a odi fi yu, ne a pikin di de a ini mi bee piisii te a sikopu futu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","We, Maliya! Fu di i du san Masaa Gadu wani, da i sa fende seigi ne en. Bika ala den sani di a taigi yu de, o pasa tuu.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ne Maliya seefi daai gafa Masaa Gadu. A taki: “Mi e gafa Masaa Gadu anga mi hii ati. ");
INSERT INTO djkNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mi e piisii tuu a ini mi ati anga a Gadu fu mi. Ne en na mi Yeepiman. ");
INSERT INTO djkNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bika Masaa Gadu luku mi enke wan mofinawan, ne a opo mi. Da a opo di a opo mi ya, ná abi kaba. Bika fu alaten, sama sa kai mi nen taki, na so Masaa Gadu be seigi mi. ");
INSERT INTO djkNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bika, na a Sama di abi ala makiti a goontapu, ne en du mi a gaan bun ya. A gaan bun ya, na a Sama di abi ala makiti a goontapu, ne en du mi en. A Sama ya de kiinkiin sondee fowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Da alaten Masaa Gadu e du gaan bun naamo gi den sama di e lesipeki en. Bika a abi tyali ati fu libisama. ");
INSERT INTO djkNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Da Masaa Gadu abi makiti fu du ala sani. Bika a booko den bigi fasi sama anga den hei membee wan saka. ");
INSERT INTO djkNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ai naki den gaan kownu puu a den kownu sutuu. Ma ai opo den saka fasi sama kon poti hei. ");
INSERT INTO djkNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ai paati den gudu fi en gi den pinaman di e angii fi en. Ma ai sende den guduman gwe anga soso ana. ");
INSERT INTO djkNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A abi tyali ati naamo e yeepi den Islayeli. ");
INSERT INTO djkNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","A á feegete san a be paamisi u tata Abalaham anga den bakapikin fi en, bika alaten ai yeepi den leti enke fa a be paamisi den.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Da di Maliya gafa Masaa Gadu so kaba, ne a tan dii mun anga Elisabeti, fosi a daai gwe baka a Nasaleti Foto, a pe a be e tan. ");
INSERT INTO djkNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Da na so, di a yuu doo fu Elisabeti meke, ne a meke a manpikin. ");
INSERT INTO djkNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Da di den famii fi en anga den sama fu a pisi kondee pe ai tan, yee taki a meke a pikin, ne den piisii anga en te, ná sipowtu, bika den si taki Masaa Gadu du wan gaan bun gi Elisabeti. ");
INSERT INTO djkNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Da di a pikin abi aitin dei, ne den kon fu koti en sani mofu enke fa den Dyu be gwenti, fu soi taki a pikin ya libi de fu Masaa Gadu wawan. Da den be wani kai a pikin Sakalia enke en dda. ");
INSERT INTO djkNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma Elisabeti taki: “Nono! U á mu kai en Sakalia. U kai en, Johanisi.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma den sama taki: “Nono! Wi á poi kai en Johanisi, bika ná wan sama fu a famii abi a nen de.” ");
INSERT INTO djkNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ne den sama daai go a Sakalia, ne den akisi en taki, fa a wani den kai a pikin. ");
INSERT INTO djkNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ne a soi den anga ana taki, meke den gi en wan sani meke a sikiifi.*f3* ");
INSERT INTO djkNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ne den sama gi en sani fu a sikiifi. Ne a teke den sani, ne a sikiifi taki: “Na a pikin ya den e kai, Johanisi.” Da a sani ya foondoo ala den sama di be de ape. Ne wanten di Sakalia sikiifi so, ne walla en tongo losi. Ne a bigin taki baka. Ne a gi Masaa Gadu bigi nen anga daa. ");
INSERT INTO djkNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Da ala den sama foondoo te, ná sipowtu. Ala den sama fu a pikin kondee a den mongo mindii de be e taki fu san pasa. ");
INSERT INTO djkNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Da a toli ya paati na a hii mongo pisi fu Judeja. Da ala sama di yee a toli ya e akisi denseefi taki: “We, da san a pikin ya o toon di bigi so?” Bika den be si taki, Masaa Gadu be de anga a pikin ya. ");
INSERT INTO djkNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Da a Jeje fu Masaa Gadu kon a Sakalia tapu, ne a taki wan bosikopu fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","A taki: “Gaantangi fu Masaa Gadu, a Gadu fu Islayeli. A kon puu wi, den sama fi en a sitaafu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bika a o toon wan gaan taanga yeepiman na a lo paansu sama fu Kownu Dafeti. ");
INSERT INTO djkNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Da a o gi wi a pikin ya, leti enke fa Masaa Gadu be meke den fositen apaiti takiman fi en be paamisi den gaansama fu wi langa ten kaba a fesi. Da Masaa Gadu be meke den apaiti takiman fi en be paamisi den gaansama taki, ne en be o kon puu wi a den feyanti fu wi ondoo. ");
INSERT INTO djkNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","75","Bika Masaa Gadu taki a be abi tyali ati anga den gaansama fu wi fu yeepi den. Da a be kuudei anga a avo gaansama fu wi, di den be e kai Abalaham taki, a o puu den bakaten pikin fi en a den feyanti fu den ondoo. Bika a be meke wan sweli anga wi tata Abalaham taki, a be o puu wi a den feyanti fu wi ondoo, fu u be sa waka ne en baka kiinkiin sondee feele anga sondee fowtu. Da son langa wi e libi, u be sa waka enke fa Masaa Gadu wani. ");
INSERT INTO djkNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Da a pikin fu mi ya, den sa kai yu, wan apaiti takiman fu a moo hei Masaa Gadu fu tapu. Bika yu o waka a fesi fu Masaa go taigi den sama meke den seeka denseefi fu a kon fi en. Yu o bali bosikopu gi den taki, meke den daai den libi meke Masaa Gadu yeepi den. Da a sa gi den paadon fu den takuudu anga ogii fu den. ");
INSERT INTO djkNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Bika Masaa Gadu abi tyali ati fu libisama. Da a á wani meke den waka a dunguu moo gi dede e sitaafu. A dati meke a sende a leti fi en kon a goontapu, leti enke fa a san e kiin ala peesi te a opo. Na fu den be sa komoto a dunguu kon de fiifii a ini a leti fu Masaa Gadu.” Da na so a Jeje fu Masaa Gadu meke Sakalia taki wan bosikopu. ");
INSERT INTO djkNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Da a pikin e goo e kon. A be e kisi moo fusutan, bika a Jeje fu Masaa Gadu be de anga en. Ne a pikin goo te di a bigi, ne en wawan go a ini wan gaan sabana ini go e tan. Da, di a yuu fu Masaa Gadu doo, ne a komoto a ini a gaan sabana ini kon a den Islayeli fi en. Ne ai bali a bosikopu fu Masaa Gadu gi ala den sama. ");
INSERT INTO djkNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Da na a ten de, da a moo gaan kownu*f4* a Loma Foto be sende wan bosikopu go na ala den kondee, di a be abi taki fu den. A taki: “Ala sama fiya mu go sikiifi den nen poti a lanti buku, bika den e teli onmen sama de a ini a kondee.” ");
INSERT INTO djkNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Da disi na a fosi toon di den o teli sama a ini a kondee ya. Da a yuu ten ya, na Gaaman Kwiliniyesi na be gaaman fu Siliya. ");
INSERT INTO djkNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Da iniiwan sama be mu go poti den nen a lanti buku na a kondee pe den avo fu den be meke. ");
INSERT INTO djkNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Da Jowsef be komoto a Nasaleti Foto, a Galileya pisiwataa anga Maliya en poti mofu uman. Ma namo, da Maliya be de anga gaan bee. Ne den go te den doo Betelehem a Judeja pisiwataa. Betelehem na a foto fu a fositen Kownu Dafeti. Bika Jowsef na be wan bakaten manpikin fu Kownu Dafeti paansu. Na dati meke a be mu go a Betelehem, fu go poti en anga Maliya nen. ");
INSERT INTO djkNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Da di den doo Betelehem, da Maliya yuu be doo fu a meke. ");
INSERT INTO djkNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ne a meke. A meke wan manpikin. A fosi pikin fi en. Ne a lolo a pikin a ini koosi, ne a poti en a ini wan baki di den e poti nyanyan gi meti fu nyan. Bika peesi á be de a ini a lanti osu fu den tan. A be fuu gwingwin. Ne na a osu fu den meti den gi den fu siibi. ");
INSERT INTO djkNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Da a neti di Maliya meke, da i be abi wantu man a ini wei, na a pisi kondee de. Den be e waki den sikapu fu den. ");
INSERT INTO djkNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ne wanten so wan Basiya fu Masaa Gadu Kondee*f5* kon a den. Ne ala peesi kiin dyelle enke gaandei. Na Masaa Gadu seefi a leti ya komoto. Da di den sikapuman si a Basiya fu Masaa Gadu Kondee, ne den dyombo te den bigin feele. ");
INSERT INTO djkNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ne a Basiya taigi den taki: “U á feele! Mi tyai a moo gaan piisii nyunsu kon gi u. A nyunsu ya o meke a hii foluku fii gaan piisii. ");
INSERT INTO djkNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Bika a neti ya, da a Yeepiman fu u meke kon a goontapu. En na Kelestesi, a na a Masaa fu u. A meke a Betelehem, na a foto fu Kownu Dafeti. ");
INSERT INTO djkNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Meke mi soi u fa u sa sabi a pikin ya. Te u go, da u o si a didon lolo lolo a ini koosi, a ini wan baki di den e poti nyanyan gi meti.” ");
INSERT INTO djkNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ne wanten di a Basiya taki so, ne onmen tenti taa Basiya fu Masaa Gadu Kondee kon mokisa anga en. Ne den bali baaya gi Masaa Gadu gaandi taki: ");
INSERT INTO djkNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“U bali baaya gi Masaa Gadu! U bali baaya gi Masaa Gadu ne en kondee a tapu anda. Fii kon a goontapu gi ala libisama di e libi enke fa Masaa Gadu wani. Masaa Gadu abi piisii anga den.” ");
INSERT INTO djkNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Da di den Masaa Gadu Kondee Basiya gafa Masaa Gadu so, ne den daai gwe baka a Masaa Gadu Kondee a tapu. Ne den sikapuman piki denseefi taki: “We, baala oo! U kon meke u go a Betelehem, a pe a pikin meke go luku a sani di Masaa Gadu taigi u ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ne den go a Betelehem. Ne di den doo de, ne den si taki, ala sani waka leti enke fa a Basiya fu Masaa Gadu Kondee be taki. Den si Maliya anga Jowsef anga a pikin. A pikin didon a ini wan baki di den e poti nyanyan gi meti. ");
INSERT INTO djkNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Da di den sikapuman si en so kaba, ne den go taigi ala sama ala den sani di a Basiya fu Masaa Gadu Kondee be taigi den, fu a pikin. ");
INSERT INTO djkNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Da ala sama di yee a sani fu a pikin ya e poti ana a mofu e foondoo. ");
INSERT INTO djkNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Maliya dati, teke ala den sani di a yee ya, oli a ede e poti dipi pakisei. ");
INSERT INTO djkNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Da di den sikapuman ya daai baka e go a ini a wei, ne den e singi e piisii gaan piisii fu san di den be yee anga san di den si. Bika ala sani be waka enke fa a Basiya fu Masaa Gadu Kondee be taigi den. ");
INSERT INTO djkNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","We, ne den de te a pikin abi aitin dei, ne den koti a maiki a manpeesi gi en, enke fa a weiti fu Masaa Gadu taki. Ne den kai a pikin Jesesi, enke fa a Basiya fu Masaa Gadu Kondee be taigi Maliya fu kai a pikin, fosi a be de anga bee fi en. ");
INSERT INTO djkNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Da Maliya anga Jowsef be tyai a pikin go a Jelusalem, fu go poti a Masaa Gadu ana, enke fa a Dyuweiti be taki. Bika a Dyuweiti ya be taki: “Ala fosi manpikin di wan uman meke, a mu gi Masaa Gadu en.” A seefi ten de, da Maliya yuu be doo fu komoto a meke osu tu. Ne a tyai tu doifi go a Jelusalem tu, fu a wasi komoto a meke osu enke fa a Dyuweiti be taki. Bika a Dyuweiti ya be taki: “Te wan uman meke wan pikin, da na fotenti dei langa a mu de a meke osu. Da te a o wasi komoto a meke osu, da a mu tyai tu pikin paansu doifi ofu tu yonkuu doifi go boon gi Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Da a yuu di Maliya anga Jowsef e go a Jelusalem, da wan man be de ape den be e kai Simiyon. Simiyon na wan sama di be e libi letiopu fasi gi Masaa Gadu. Soseefi ai lesipeki Masaa Gadu. Da a be e luku on ten Masaa Gadu be o puu den Islayeli sama a sitaafu. Da a Apaiti Jeje fu Masaa Gadu be de ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Da a Jeje be taigi en taki, a á be o dede fosi a be si Kelestesi, a Kownu di Masaa Gadu be paamisi taki a be o sende kon gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Da di den tyai a pikin kon, ne a Jeje fu Masaa Gadu tyai Simiyon kon a ini a Mama Keliki tu. Da di a doo a ini, ne a si taki den tyai a pikin kon fu seeka enke fa a weiti fu Masaa Gadu taki. ");
INSERT INTO djkNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ne a teke a pikin a ini en ana, ne a gafa Masaa Gadu taki: ");
INSERT INTO djkNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kee baa, Masaa Gadu! Now mi sa dede anga wan switi ati. ");
INSERT INTO djkNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bika, miseefi si a Yeepiman anga miseefi ain enke fa i paamisi mi. ");
INSERT INTO djkNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","I sende en kon gi wi Islayeli sama anga ala taa sama a goontapu, fu yeepi wi. A pikin ya o puu wi na a se fu dunguu tyai kon na a leti fi i. Da a o leli wi a bun pasi di wi mu waka. Da na fu a pikin ya ede meke somen sama o kai wi Islayeli sama nen taki: ‘A pikin fu Islayeli sama yeepi ala sama fu goontapu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","We, den wowtu di Simiyon taki ya, foondoo Maliya anga Jowsef te, ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ne Simiyon begi Masaa Gadu gi den, te a kaba. Ne a taigi Maliya taki: “Maliya! A pikin ya o booko somen sama fu Islayeli Kondee saka. Ma soseefi, a o opo somen sama fu Islayeli Kondee tu. Da a o puu ala den ogii di de a somen sama pakisei fu du kon a doo. Masaa Gadu gi wi a pikin ya enke wan maiki fu soi wi fa Masaa Gadu seefi de. Sani di sama á be si wan dei, den o si ne en. Sani di sama á be yee wan dei, den o yee ne en. Na fu dati ede meke somen sama ná o lobi en. ");
INSERT INTO djkNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ma wan dei o kon di wan takuu sani o pasa anga a pikin ya. A o hati yu moo enke, te den be o sutu yu anga fetihow a i boo fu ati doo kisi taase.” ");
INSERT INTO djkNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ma namo, da wan uman den e kai Hana, be de a ini a keliki osu tu. Masaa Gadu be e gi en bosikopu fu gi taa sama. Ne en dda den be e kai Fanuweli, fu a lo fu Aseli. Seibin yali baka, di a uman ya anga en man be libi ne en yonkuu ten, ne a man dede. ");
INSERT INTO djkNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ne a de sondee man, fu te enke fa a abi aititenti a fo yali ya. Da dei anga neti a uman ya e de a ini a Mama Keliki e begi Masaa Gadu. Son dei, a be e de sondee nyan seefi fu begi. ");
INSERT INTO djkNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Da a yuu di Simiyon e taki de, ne a mma ya kon a ini a keliki osu tu. Ne di a si a pikin, ne a bigin gi Masaa Gadu daa. Ne ai taigi ala den sama di be e luku fu Masaa Gadu sende a Paamisi Kownu kon fu puu Jelusalem a sitaafu taki: “A Paamisi Kownu kon kaba.” ");
INSERT INTO djkNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Da na so Maliya anga Jowsef seeka ala sani enke fa a Dyuweiti taki, te a kaba. Ne den daai gwe baka a den kondee Nasaleti, na a pisiwataa fu Galileya. ");
INSERT INTO djkNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Da a pikin e goo e kon. Ai bigi toon manengee. Moo anga moo, ai abi kiin fusutan fu den sani fu Masaa Gadu anga den sani fu libisama. Masaa Gadu seefi de anga en e yeepi en anga ala sani. ");
INSERT INTO djkNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Da Maliya anga Jowsef be gwenti go a Jelusalem ala yali fu nyan a gaan piisii fesa fu den Dyu den e kai Pasika. ");
INSERT INTO djkNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Da di Jesesi abi twalufu yali, ne en anga den go a Jelusalem na a Pasika Fesa. ");
INSERT INTO djkNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Da di a Pasika Fesa kaba, ne den daai baka e gwe a osu, a Nasaleti Foto. Ma Jesesi be fika a baka a Jelusalem. Da Jowsef anga Maliya á be sabi taki, Jesesi fika a baka. ");
INSERT INTO djkNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","45","Bika den be denki taki, son ten a be waka anga den taa sama di den anga den be go a Jelusalem na a Pasika Fesa. A dati meke den waka wan hii dei, te di neti fosi den bigin suku en. Den suku en a den famii anga den mati fu den, ma den á fende en. ");
INSERT INTO djkNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Da di den á fende en, ne den daai baka gwe a Jelusalem. Na dii dei langa di den suku Jesesi, fosi den go fende en a ini a Mama Keliki fu Dyu. A sidon a den leliman fu Dyuweiti mindii e aliki fa den e leli Gadu wowtu. Da a be e akisi den sani tu. Da den be e gi en piki fu san a be e akisi den. ");
INSERT INTO djkNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ala den sama be e foondoo fu a fasi fa a be e fusutan sani anga a fasi fa a be e piki den sani. ");
INSERT INTO djkNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Da di den si en, ne den foondoo. Ne Maliya bali taki: “Oho, Jesesi! Pikin! San meke i du so anga wi du? Tide meke di fu dii dei di mi anga i dda e booko ede e suku yu!” ");
INSERT INTO djkNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ne Jesesi piki den taki: “Fu saide meke u booko ede suku mi so? U á sabi taki, mi mu du den wooko fu mi Tata, no? Efu u be sabi dati, da u á be o booko ede suku mi so.” ");
INSERT INTO djkNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma fa a pikin taki de, en dda anga en mma á be sabi san a wani taigi den. Den á fusutan en seefi. ");
INSERT INTO djkNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ne den teke en, ne den go baka a Nasaleti. Ma Jesesi be e saka enseefi a den ondoo e du san den taki. Ma Maliya teke den wowtu fu Jesesi oli a ede poti dipi pakisei naamo. ");
INSERT INTO djkNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Da a pikin e goo e kon. On moo ai bigi, on moo en fusutan fu sani e opo. Masaa Gadu anga libisama lobi en. ");
INSERT INTO djkNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Da na di fu tin na feifi yali, fu a tii fu Tibeliyasi, di be de a moo gaan kownu a Loma Foto, ne Johanisi bigin wooko. Kownu Tibeliyasi be abi somen taa edeman ne en ondoo, di be e wooko gi en, fu tii taa pisiwataa enke edeman. Gaaman Pontiyesi Pilatesi be e tii a pisiwataa den be e kai Judeja. Kownu Helowdesi be e tii a pisiwataa den be e kai Galileya. Filipi, a baala fu Kownu Helowdesi, be e tii den tu pisiwataa den e kai Ituleya anga Takownisi. Da Gaaman Lisaniyasi be e tii a pisiwataa den e kai Abileina. ");
INSERT INTO djkNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","We, a yuu de, da Anasi anga Kayafasi na be den tu moo hei apaiti begiman. Ne Masaa Gadu kai a pikin fu Sakalia di den e kai Johanisi puu a ini a sabana fu bigin wooko. ");
INSERT INTO djkNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ne Johanisi opo e bali bosikopu gi den sama fu den kondee kondee, na a pisiwataa fu a Joodani Liba taki, fu den kon teke dopu, fu daai libi. Meke Masaa Gadu sa gi den paadon, fu takuudu anga ogii. ");
INSERT INTO djkNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A sani ya waka leti enke fa Masaa Gadu be piki Jesaja, enke wan apaiti takiman fi en, fu sikiifi a fositen taki: “A tongo fu wan bosikopuman o bali a ini a gaan sabana taki: ‘U seeka pasi gi a Masaa, meke a pasi sa kon taampu letiopu tollo. ");
INSERT INTO djkNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Meke ala dipi saka peesi kon hei. Meke ala mongo kon booko saka miti doti. Meke ala bendi bendi fu a pasi kon taampu letiopu. Ala den olo olo seefi mu kon seeka silli miti doti. ");
INSERT INTO djkNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Da ala sama o si a yeepi fu Masaa Gadu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Da, di Johanisi bali a bosikopu ya, ne onmen tenti sama kon ne en fu a dopu den. Ne a taigi den taki: “U takuu ati sineki sani! Fa u du sabi taki, u mu lon gi a gaan atiboon fu Masaa Gadu di de a pasi fu kon? ");
INSERT INTO djkNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","We, u mu soi tuutuu taki u daai libi. Ma u á mu luku taki, fu di u avo gaansama Abalaham anga Masaa Gadu be de mati, da Masaa Gadu ná o sitaafu u moo. Kweti! Bika efu Masaa Gadu wani, a sa meke den siton di u e si ya, daai kon toon bakaten pikin fu Abalaham, a u peesi. ");
INSERT INTO djkNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Da soseefi a akisi fu Masaa Gadu de na a bon kaba fu faa en. Da ibii bon di de ape, di nái meke bun nyanyan, da den o faa en towe a ini faya boon.” ");
INSERT INTO djkNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Namo den sama akisi Johanisi taki: “Da san u mu du moo?” ");
INSERT INTO djkNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ne a piki den taki: “Efi i abi tu impi, gi a sama di ná abi wan. Da efi i abi nyanyan, da gi a sama di ná abi fu nyan.” ");
INSERT INTO djkNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Da baka fu den, ne den sama di e piki lantimoni kon ne en fu a dopu den tu. Ne den akisi en taki: “We, Mesiti oo! San u mu du moo?” ");
INSERT INTO djkNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ne a piki den taki: “Te u e piki lantimoni, u á mu teke moo ipi moo enke san lanti poti.” ");
INSERT INTO djkNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ne den suudati seefi kon, ne den akisi en taki: “We, san u dati mu du?” Ne a piki den taki: “U á mu suku toobi anga sama e dwengi den fu gi u moni. Soseefi, u á mu lei gi sama tyai den go a kuutu fu moni ede. U meke a moni di lanti e pai u sai u.” ");
INSERT INTO djkNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Da di den sama yee fa Johanisi taki, ne den pakisei taki: “A ná a Kelestesi, a di Masaa Gadu be taki a o sende kon gi u de ya, no?” Bika den be e luku on ten a Kownu di Masaa Gadu be paamisi den, be o kon. ");
INSERT INTO djkNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma Johanisi piki den taki: “Nono! Mi e dopu u anga wataa. Ma u luku Awan di makiti bigi moo mi, a o kon a mi baka! Ma mi á dyendee sai fu losi susu puu a futu gi en seefi. En dati o dopu sama anga a Apaiti Jeje anga faya. ");
INSERT INTO djkNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A de kaba kaba fu seeka a nyanyan fi en. Den bun nyanyan a o kibii ne en baakoto. Ma den poli wan a o iti a ini faya di noiti e tapu, fu den boon poli.” ");
INSERT INTO djkNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na so Johanisi e bali den sama naamo e gi den a Bun Nyunsu fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma namo, da Johanisi be bali Kownu Helowdesi, fu di kownu be teke en baala uman e libi anga fu den somen taa ogii sani di a be e du. ");
INSERT INTO djkNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ne kownu komoto, ne a du wan moo gaan ogii. Bika a kisi Johanisi poti a ini dunguu osu. ");
INSERT INTO djkNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma bifo den be poti Johanisi a dunguu osu, da somen sama be e kon ne en fu a dopu den. Na so Masaa Jesesi seefi kon fu kon teke dopu tu. Da a yuu di Masaa Jesesi e dopu, ne ai begi. Da di a begi te wan pisi, ne tapu a den woluku piiti opo palan. ");
INSERT INTO djkNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ne a Apaiti Jeje fu Masaa Gadu saka kon ne en tapu enke wan doifi. Ne wan Tongo taki a tapu anda taki: “Yu na mi Manpikin di mi lobi. Mi hii ati e piisii anga yu.” ");
INSERT INTO djkNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Da Jesesi be abi diitenti yali di a bigin fu wooko leli sama. Da den sama be teke taki, na Jowsef, a pikin fu Eli ne en dda. ");
INSERT INTO djkNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli na be a pikin fu Matati. Da Matati na be a pikin fu Leifi. Da Leifi na be a pikin fu Milki. Da Milki na be a pikin fu Yanai. Yanai na be a pikin fu Jowsef. ");
INSERT INTO djkNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Da Jowsef na be a pikin fu Matatiyasi. Da Matatiyasi na be a pikin fu Amosi. Da Amosi na be a pikin fu Naahem. Da Naahem na be a pikin fu Hesili. Da Hesili na be a pikin fu Nagai. ");
INSERT INTO djkNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai na be a pikin fu Maata. Da Maata na be a pikin fu Matatiyasi. Da Matatiyasi na be a pikin fu Semeyen. Da Semeyen na be a pikin fu Yowseki. Da Yowseki na be a pikin fu Yowda. ");
INSERT INTO djkNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yowda na be a pikin fu Yowanan. Da Yowanan na be a pikin fu Lesa. Da Lesa na be a pikin fu Selubabeli. Da Selubabeli na be a pikin fu Seyaltiyeli. Da Seyaltiyeli na be a pikin fu Neli. ");
INSERT INTO djkNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli na be a pikin fu Milki. Da Milki na be a pikin fu Adi. Da Adi na be a pikin fu Kowsan. Da Kowsan na be a pikin fu Emadan. Da Emadan na be a pikin fu Eli. ");
INSERT INTO djkNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli na be a pikin fu Josuwa. Da Josuwa na be a pikin fu Eliyesolu. Da Eliyesolu na be a pikin fu Yolemu. Da Yolemu na be a pikin fu Matati. Da Matati na be a pikin fu Leifi. ");
INSERT INTO djkNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leifi na be a pikin fu Simiyon. Da Simiyon na be a pikin fu Juda. Da Juda na be a pikin fu Jowsef. Da Jowsef na be a pikin fu Yownan. Da Yownan na be a pikin fu Eliyaken. ");
INSERT INTO djkNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyaken na be a pikin fu Meleya. Da Meleya na be a pikin fu Mena. Da Mena na be a pikin fu Matata. Da Matata na be a pikin fu Naatan. Da Naatan na be a pikin fu Dafeti. ");
INSERT INTO djkNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dafeti na be a pikin fu Isai. Da Isai na be a pikin fu Obeti. Da Obeti na be a pikin fu Bowasi. Da Bowasi na be a pikin fu Saala. Da Saala*f6* na be a pikin fu Nakson. ");
INSERT INTO djkNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nakson na be a pikin fu Amenadabu. Da Amenadabu na be a pikin fu Admen. Da Admen na be a pikin fu Alini. Da Alini na be a pikin fu Sesilon. Da Sesilon na be a pikin fu Pelesi. Da Pelesi na be a pikin fu Juda. ");
INSERT INTO djkNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda na be a pikin fu Jakopu. Da Jakopu na be a pikin fu Isaki. Da Isaki na be a pikin fu Abalaham. Da Abalaham na be a pikin fu Telaki. Da Telaki na be a pikin fu Naakolu. ");
INSERT INTO djkNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naakolu na be a pikin fu Seluku. Da Seluku na be a pikin fu Lewu. Da Lewu na be a pikin fu Pelegi. Da Pelegi na be a pikin fu Ebeli. Da Ebeli na be a pikin fu Seila. ");
INSERT INTO djkNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seila na be a pikin fu Kaina. Da Kaina na be a pikin fu Alipakisa. Da Alipakisa na be a pikin fu Sem. Da Sem na be a pikin fu Nowa. Da Nowa na be a pikin fu Lameki. ");
INSERT INTO djkNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki na be a pikin fu Metusala. Da Metusala na be a pikin fu Heinoki. Da Heinoki na be a pikin fu Yeleti. Da Yeleti na be a pikin fu Mahalaleli. Da Mahalaleli na be a pikin fu Keinan. ");
INSERT INTO djkNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinan na be a pikin fu Enosi. Da Enosi na be a pikin fu Seti. Da Seti na be a pikin fu Adan. Ma Adan na be a pikin fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Da di Masaa Jesesi komoto a Joodani Liba pe den dopu en, da a Jeje fu Masaa Gadu be de ne en tapu wan taanga fasi. Ne a tyai en gwe a ini a gaan sabana ini. ");
INSERT INTO djkNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne a didibii go tesi en anda. Bika Masaa Jesesi poti nyanyan a wanse, fu begi fotenti dei anga fotenti neti langa a ini a gaan sabana anda. Na so di den fotenti dei pasa, ne angii moo en. ");
INSERT INTO djkNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ne a didibii taigi en taki: “Di yu na a Manpikin fu Masaa Gadu tuutuu, da taigi den siton ya, meke den toon beele, osi, fi i fende nyan?” ");
INSERT INTO djkNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Masaa Jesesi piki en taki: “Nono! Masaa Gadu Buku sikiifi taki: ‘A ná nyanyan namo e oli wan sama a libi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ne didibii tyai en go a wan gaan hei peesi, ne te fi i pingi ain opo, ne a soi Masaa Jesesi ala den kondee kondee fu goontapu anga ala den gudu fu den. Ne a taigi en taki: ");
INSERT INTO djkNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","“I si ala den sani di i si de? Na mi abi ala. Da na sama di mi wani, mi e gi den. So, da mi o gi yu ala den kondee ya anga ala den gudu fu den. Soseefi mi o gi yu a makiti fu taki fu den. Ma, da i mu sutu kini a doti begi mi fosi.” ");
INSERT INTO djkNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ne Masaa Jesesi piki en taki: “Nono! Bika, a sikiifi a Masaa Gadu Buku taki: ‘Na Masaa Gadu wawan u mu begi, na Masaa Gadu wawan u mu dini! Ná wan sama moo.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ne a didibii teke en, ne a tyai en go a Jelusalem, te na a moo hei peesi, na a tapu osu fu a Mama Keliki. Ne a taigi en taki: “Di i na a Manpikin fu Masaa Gadu, da fee saka ya go a doti anda, osi? Da ná wan sani o du yu. ");
INSERT INTO djkNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bika Masaa Gadu Buku taki: ‘Masaa Gadu o sende den Basiya fi en*f7* kon yeepi yu, fu sani á du yu. ");
INSERT INTO djkNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Den Basiya fu Masaa Gadu Kondee o tyai yu na ana meke yu á naki i futu a ná wan siton.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ne Masaa Jesesi piki en baka taki: “Ma Masaa Gadu Buku sikiifi tu taki: ‘Wi á mu tesi Masaa di de a Gadu fu wi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Da na so didibii tesi Masaa Jesesi na ala fasi fa a man, ma a á be poi kisi en, fu a du san a wani. Ne a fika en de, ne a gwe fosi. ");
INSERT INTO djkNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ne bakadati, ne Masaa Jesesi daai kon baka a Galileya. Da a Jeje fu Masaa Gadu be de ne en tapu taanga. Da a á be de ape langa seefi fosi sama be sabi taki, a be de ape. ");
INSERT INTO djkNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Bika a be e go a ini den Dyu keliki osu e go e leli den sama Masaa Gadu wowtu. Da ala sama be e gafa en, fu fa den be si a be sabi leli sama den sani. ");
INSERT INTO djkNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Da di a de a Galileya de te wan pisi, ne a go a Nasaleti a pe a be kiya. Ne a de ape te a kina dei fu den Dyu doo, ne a go na a keliki enke fa a be gwenti. Ne a opo taampu fu leisi wan pisi fu Gadu wowtu gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ne den teke wan pisi fu Gadu wowtu, di Jesaja, wan fositen apaiti takiman fu Masaa Gadu sikiifi, ne den langa gi en. Ne a opo en, ne a leisi a pisi di sikiifi taki: ");
INSERT INTO djkNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“A Jeje fu Masaa Gadu de a mi tapu. Masaa Gadu sende mi fu taki a Bun Nyunsu fi en gi den pootiman. Masaa Gadu sende mi, fu taigi den sama di de tetei taki: ‘Mi sa puu den na a katibo di den de ape, fu den de booboo.’ Masaa Gadu sende mi, fu taigi den beendiman taki: ‘Den ain sa kon bun.’ Masaa Gadu sende mi, fu taigi den sama di de a sitaafu anga pina taki: ‘Den sa komoto na a sitaafu anga a pina kon de fu den boo.’ ");
INSERT INTO djkNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Soseefi a sende mi, fu taigi ala libisama fiya taki: ‘A yuu doo di Masaa Gadu teke gaan bun ati fasi namo luku libisama.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ne di Masaa Jesesi kaba, ne a lolo a pampila baka, ne a langa gi den baka. Ne a go sidon. Ne ala den sama di be de a ini a keliki osu fika e luku en dunn. ");
INSERT INTO djkNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ne a taigi den taki: “A sama di Masaa Gadu taki a sende na a pisi di u leisi de, na mi.” ");
INSERT INTO djkNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Di a taki so, te a kaba, namo a taki switi gi den sama te, a foondoo den. Ma toku, den á gafa en anga den hii ati, bika den daai e akisi denseefi taki: “Sama na a sama di taki a taki de? A ná a pikin fu Jowsef, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","We, ne di Masaa Jesesi si so, ne a piki den taki: “U wani koti odoo gi mi taki: ‘Kaabita e deesi, ma enseefi kini bigi?’ Bika u be yee fu den sani di i e du a Kafalnayemu. Da di i kon a iseefi kondee ya, da du den gi den sama fi yu ya tu meke u si.” ");
INSERT INTO djkNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma Masaa Jesesi piki den taki: “U aliki bun! Meke mi taigi u: ‘Wan apaiti takiman fu Masaa Gadu, ná abi nen ne enseefi kondee.’ ");
INSERT INTO djkNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","“Bika luku a apaiti takiman fu Masaa Gadu, di den be e kai Eliya. A ten di a be de, na so den á be e oli en fu sani tu. A be tapu a alen hiihii dii yali anga sigisi mun langa, ne en kondee Islayeli ya. Ne wan gaan angiiten be kon a Islayeli Kondee fu di alen á be e kai. Da na a angii yuu ya, da somen pooti uman be de a ini Islayeli Kondee ya, di man dede fika a ganda. Ma toku, Masaa Gadu á be sende Eliya go a wan fu den uman ya. Ma a sende en go, te a wan hii taa kondee den e kai Salefati, na a pisiwataa fu Sidon Kondee fu go du wan gaan foondoo sani gi wan hii taa kondee uman di man dede fika a ganda. ");
INSERT INTO djkNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na soseefi a be de na a ten fu a apaiti takiman fu Masaa Gadu di den be e kai Elisa. A ten de, da somen sama fu Islayeli be de anga gwasi siki. Ma Elisa á deesi ná wan fu den. Ma a fika den go deesi Naamani, wan man di komoto te a wan taa kondee den kai Siliya.” ");
INSERT INTO djkNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","We, di Masaa Jesesi taki so, ne den sama di be de a ini a keliki osu, ati boon te, den ain lebi nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ne den opo gwugwulu, ne den toto Masaa Jesesi gei gei poti a doo. Ne den tyai en go te, na a mongo mofu fu a kondee, fu toto en towe go a ondoo. ");
INSERT INTO djkNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ma, te fu den membee, ne kuli, a daai waka pasa a den mindii gwe fi en. ");
INSERT INTO djkNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Da Masaa Jesesi go a Kafalnayemu, na a seefi pisiwataa fu Galileya. Da te kina dei, da a be e go a den Dyu keliki go e leli sama Masaa Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Da a be e foondoo den sama, fu a fasi fa a be e leli den. Bika i be sa si taki, a be e leli den enke wan sama di sabi san ai taki. ");
INSERT INTO djkNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma namo, da wan dei di a de a ini a keliki osu e leli den sama, da wan sama be de ape anga wan sani ne en tapu. Ne a sani bali na a sama tapu taki: ");
INSERT INTO djkNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesesi fu Nasaleti! San i kon du ya? A kon i kon fu kii wi kaba? Mi sabi sama a yu! Yu na a Apaiti Sama fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma wanten Masaa Jesesi kaasi den taki: “Tapu mofu de! Komoto ne en tapu gwe wanten!” Ne a sani towe a man a doti, a den sama fesi, ne a komoto ne en tapu gwe, sondee fu du wan ogii anga a man. ");
INSERT INTO djkNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Da den sama be foondoo te, den taigi denseefi taki: “Ai kaasi den takuu sani, da wanten den e du san a kumandei den fu du. Anga a gaan makiti anga taanga fi en, a puu a takuu sani na a man tapu.” ");
INSERT INTO djkNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A nyunsu ya paati na a hii pisiwataa fu Galileya. ");
INSERT INTO djkNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Da di Masaa Jesesi komoto na a keliki, ne a go a Simon osu. Ma namo, di den go doo, da a main fu Simon be didon anga taanga feba a kama. Ne den sama di be de ape a ini a osu begi Masaa Jesesi, fu a deesi en gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ne Masaa Jesesi go a ini a osu. Ne a sende ala den sama go a doo. Ne a waka go taampu na a kama sikin. Ne a kaasi a feba fu a gwe komoto na a mma sikin. Ne wanten a feba gwe. Ne a uman opo, ne a seeka sani gi den, den nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Da di sapaten, san dongo, ne den sama tyai onmen tenti sama anga ala sowtu siki kon a Masaa Jesesi fu a deesi den. Ne Masaa Jesesi poti ana a den tapu, deesi ala den fiya. Da wansi sowtu siki den sama be abi, toku a deesi ala fiya. ");
INSERT INTO djkNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Da soseefi a puu somen takuu sani a somen sama tapu. Da den sani be e bali gi Masaa Jesesi taki: “Yu na a Manpikin fu Masaa Gadu!” Ma Masaa Jesesi á be e gi den pasi fu taki. A be e kaasi den fu den tapu mofu wanten. Bika den takuu sani be sabi taki, en na a Kelestesi. ");
INSERT INTO djkNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Da a taa dei fi en, fuuku mamanten, ne Masaa Jesesi wawan opo go a wan koo peesi. Ne den suku en te, den go si en. Ne den begi Masaa Jesesi gaantangi fu a á gwe, ma fu a tan anga den a den kondee de. ");
INSERT INTO djkNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ma Masaa Jesesi piki den taki: “Mi mu go a den taa kondee go paati a Bun Nyunsu di e taki, fu a Nyun Tii tu Masaa Gadu tu. Meke den yee. Bika na fu a sani de ede meke mi kon a goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","We, ne ai waka na ala den kondee kondee fu den Dyu fiya e paati a Bun Nyunsu fu Masaa Gadu gi den a ini den keliki osu fu den. ");
INSERT INTO djkNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ma namo, da wan dei, da Masaa Jesesi be de a wataa mofu, fu a ze fu Genesaleti. Da somen sama ali kon ne en te a ipi, fu yee Masaa Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ne Masaa Jesesi si tu boto a lampeesi de. Den boto ya na be fu wanlo fisiman di be komoto a peesi kon e losi den seepi e seeka. ");
INSERT INTO djkNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wan fu den fisiman ya na be Simon. Ne a subi go a ini a boto fu Simon. Ne a taigi Simon fu a toosi a boto go a wataa afu, fu a sa taki anga den sama. ");
INSERT INTO djkNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ne Masaa Jesesi sidon a ini a boto taki anga den sama te a kaba. Ne a taigi Simon taki: “So, we Simon! Wai a boto go a mindii wataa! Da i towe i seepi kisi fisi!” ");
INSERT INTO djkNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ne Simon piki taki: “Mesiti! A di na yu taki, meke mi o towe a seepi baka. Ma ofuso, mi á be o towe en moo. Bika na hii neti u towe seepi suku fisi kaba sondee fu kisi wan siiba. Ma toku, di na yu taki so, da u sa iti luku baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ne den iti den seepi a wataa. Ne den kisi fisi te, a seepi e suku fu piiti. ");
INSERT INTO djkNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ne den bali kai den taa sama di den anga den be e fisi makandii, fu kon yeepi den anga den fisi. Ne den kon a den. Ne den e kisi den fisi poti a ini den tu boto te, a fika pikinso moo fu den tu boto sungu. ");
INSERT INTO djkNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Da di Peitilisi si den somen fisi di den kisi, ne a foondoo te, a kai anga kini a doti, a Masaa Jesesi fesi, bali taki: “Masaa! Komoto a mi se ya, baa! Bika mi a ná wan bun libisama. Mi á waiti sai fi i kon a mi se.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Soseefi a sani ya foondoo Johanisi anga Jakowbesi, den tu manpikin fu Da Sebedi di be e wooko anga Simon Peitilisi. Ne Masaa Jesesi taigi Simon taki: “Simon! Ná feele moo! I be e kisi fisi. Ma fanafu now, mi o meke i toon sama di e kisi libisama enke fisi tyai kon biibi a mi.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ne den tyai den boto go poti baka. Ne den komoto a soo, fika ala den sani fu den de, go e waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Da bakadati, ne Masaa Jesesi go a wan kondee. Ma namo, da wan gwasiman be de ape. Da di a gwasiman si Masaa Jesesi, ne a lon kon sutu kini a doti kai tapu fesi a doti e begi en taki: “Masaa, baa! Mi sabi taki efi i wani, i poi fu deesi mi puu a gwasi siki ya, baa!” ");
INSERT INTO djkNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ne Masaa Jesesi langa ana oli en. Ne a taki: “Mi wani! Kon bun baka!” Ne wanten di Masaa Jesesi taki so, ne a man kon bun kelle baka. ");
INSERT INTO djkNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ne Masaa Jesesi bali en taki: “Ná taigi ná wan sama san mi du gi yu. Ma go na apaiti begiman fu a Mama Keliki, meke den si taki i kon bun. Da du san a weiti fu Mosesi e taigi yu fu du, te i kon bun fu gwasi siki. Bika Masaa Gadu be gi Mosesi wan weiti a sikiifi taki: ‘Wan Islayeli sama di kon bun fu gwasi siki mu tyai wan paiman go gi Masaa Gadu, fu sama sa si taki, a kon bun tuu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ma anga ala fa Masaa Jesesi bali a man de, toku sama yee sani fu Masaa Jesesi na a hii peesi de. Ne ala sama e kon a Masaa Jesesi, fu a deesi den fu den siki di den abi. ");
INSERT INTO djkNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma Masaa Jesesi be lobi go a ini a gaan sabana go begi en wawan. Na so a fika den sama de, ne a go a ini a sabana ini go begi. ");
INSERT INTO djkNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","We, ne wan taa dei, ne Masaa Jesesi e leli den sama Masaa Gadu wowtu baka. Da den Faliseiman anga den leliman fu Dyuweiti seefi be de ape tu. Den be komoto na a hii Galileya anga hii Judeja pisiwataa, anga soseefi Jelusalem Foto. Ma namo, da a taanga fu Masaa Gadu be de a Masaa Jesesi tapu fu deesi siki. ");
INSERT INTO djkNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Da di Masaa Jesesi leli den sama te wan pisi, ne wantu man tyai wan lanman a wan daagi tapu kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ma den á be poi pasa go doo a Masaa Jesesi a ini a osu. Bika sama be ipi seefi. Ne den subi go na a osu tapu, ne den puu wantu fu den siton na a osu tapu. Ne den pasa a man anga a daagi na a olo saka go leti a Masaa Jesesi fesi. ");
INSERT INTO djkNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Da di Masaa Jesesi si fa den man di tyai a mati fu den kon ya e biibi taanga, ne a taigi a lanman taki: “Mi mati! I kisi paadon fu den takuudu anga ogii fi yu.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Da di den Faliseiman anga den leliman fu Dyuweiti yee fa Masaa Jesesi taki, ne den kuutu a ini denseefi taki: “Fa wan libisama sa taki so wan sani? Ai oli Gadu a sipowtu! Bika ná wan sama di man fu gi libisama paadon fu takuudu anga ogii, boiti Masaa Gadu wawan.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ma Masaa Jesesi be sabi san de a ini den. Ne a taigi den taki: “Saide meke u e denki so du? ");
INSERT INTO djkNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Fu taigi wan sama taki, a kisi paadon fi en takuudu anga ogii, efu fu taigi en taki: ‘Opo taampu waka!’ on di moo taanga? ");
INSERT INTO djkNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ma u mu sabi taki, a Manpikin di saka kon toon libisama ya abi makiti a goontapu, fu gi sama paadon fu takuudu anga ogii.” Ne a daai, ne a taigi a lanman taki: “Opo taampu! Teke i daagi waka go a osu!” ");
INSERT INTO djkNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ne dyandyalan, a man dyombo opo na ala den sama fesi. Ne ai waka e gafa Masaa Gadu e gwe a osu. ");
INSERT INTO djkNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ala sama fiya foondoo. A gei enke den á be wani biibi den ain. Ne den gafa Masaa Gadu taki: “Ai, Masaa Gadu bigi! U si gaan foondoo sani tide.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ne bakadati, ne Masaa Jesesi komoto de e gwe. Ne di ai gwe, ne a si wan man den e kai Leifi*f8*, sidon ne en kantoo doo mofu e piki lantimoni. Ne Masaa Jesesi kai en fu a kon toon wan bakaman fi en. ");
INSERT INTO djkNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ne a man opo, ne a fika ala den sani fi en de, ne a waka go fu go waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Da di den de te wan dei, ne Leifi oli wan gaan fesa ne en osu gi Masaa Jesesi. Somen taa mati fu Leifi di be e piki lantimoni anga wantu taa sama be de na a piisii ya tu. ");
INSERT INTO djkNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Da di den de na a fesa te wan pisi, ne wan duupu Faliseiman anga leliman fu Dyuweiti si Masaa Jesesi sidon e nyan anga den man di e piki lantimoni anga den taa takuu libi man fu a kondee de. Da a sani ya á bun gi den. Ne den akisi den bakaman fu Masaa Jesesi taki: “Fu saide meke u sidon e nyan anga den man di e piki lantimoni anga den taa takuulibi sama de?” ");
INSERT INTO djkNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ma Masaa Jesesi yee den. Ne a piki den anga wan ageisi toli taki: “ ‘Na sama di e siki, na dati abi dataa fanowdu. Ma sama di á siki, ná abi dataa fanowdu. Dataa de gi sikiman anga malengiiman.’ ");
INSERT INTO djkNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi á kon kai den bunbun sama, ma mi kon fu kai den sama di sabi taki, den libi á bun, fu den daai den libi.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma namo, wan dei, ne wan duupu Faliseiman anga leliman fu weiti akisi Masaa Jesesi taki: “Mesiti! Saide meke den bakaman fi yu ná abi ten, di den e tan sondee nyan fu begi enke wi anga den bakaman fu wi? Den bakaman fu Johanisi a Dopuman seefi, abi ten di den e tan sondee nyan fu Gadu tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ne Masaa Jesesi gi den wan toli taki: “Fa mi anga den bakaman fu mi de ya, da a de leti enke te wan man toow anga wan uman. Di a man toow, ne a kai somen sama fu kon meke piisii anga en. We, solanga a toowman de na a fesa anga den, da na soso nyan meke piisii namo den o de. ");
INSERT INTO djkNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ma te di a dei o doo, te a toowman ná o de moo, da den sa abi ten di den o go e de sondee nyan fu begi.” ");
INSERT INTO djkNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ne a gi den ete wan ageisi toli. A taki: “A o taanga gi u, fu teke san mi e taki. Bika, te wan gaandi koosi fi i piiti, da anga san yu o lapu en? Ná anga wan gaandi pisi koosi, no? Bika efi i lapu a gaandi koosi anga wan nyunyun pisi, da te i wasi en, da a nyunyun pisi koosi o ali piiti komoto na a gaandi koosi. Da a gaandi koosi o piiti moo bigi. ");
INSERT INTO djkNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Na soseefi, a á fiti fu u poti nyun meke win go a ini gaandi saka di meke anga meti buba. Bika a dee taanga kaba. Da di a win o kuku, da a o soopu a gaandi saka basi towe a win poli. Da a kon, i lasi win, i lasi saka. ");
INSERT INTO djkNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nyunyun win meke fu poti a ini nyunyun saka, di á poi basi lasi en. ");
INSERT INTO djkNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Ma efu wan sama diingi gaandi win, da a ná o wani diingi nyunyun meke win moo. Bika, da a o si enke a gaandi win di a diingi switi moo a nyun meke win.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Da a wan kina dei fu den Dyu, ne Masaa Jesesi anga den bakaman fi en e waka pasa a wan goon ini. Da wan sani enke alisi de a ini a goon ya. Ne den bakaman fi en booko den sani ya e pii e nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma namo, ne wantu Faliseiman bali gi den taki: “Luku de! U si san u e du? Saide meke u e booko den sani na a kina dei ya fu du? U á si taki fa u e du de na Gadu weiti u e poli, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ne Masaa Jesesi piki den taki: “U á leisi a Masaa Gadu Buku san a avo gaansama fu u di den e kai Kownu Dafeti anga den bakaman fi en be du di angii be kii den, no? ");
INSERT INTO djkNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Di den go na a Mama Keliki, ne den teke den beele di den poti a Masaa Gadu fesi de, ne den nyan. Ma a weiti e soi taki, na den apaiti begiman fu Dyu keliki wawan sa nyan den beele de. Ma Kownu Dafeti anga den bakaman fi en nyanmi den.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","U meke mi taigi u, meke u sabi: “A Manpikin di saka kon toon libisama ya, na a gaan Masaa fu a kina dei.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Da wan taa kina dei, ne Masaa Jesesi go a ini wan Dyu keliki baka, go e leli sama. Ma namo, wan man be de ape, di be siki ne en letise ana. A ana be dee fika kamboo. ");
INSERT INTO djkNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Da wan duupu Faliseiman anga leliman fu Dyuweiti be de a ini a keliki osu, poti ain e luku efu Masaa Jesesi o deesi a siki ana man, na a kina dei ya, fu den sa fende pasi kaagi en. ");
INSERT INTO djkNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma, da Masaa Jesesi be sabi kaba, san den be e pakisei a ini den ati. A dati meke a kai a siki ana man taki: “Man! Opo kon taampu a fesi ya. Ne a man opo, ne a kon taampu de.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ne Masaa Jesesi daai, ne a akisi den sama di de ape taki: “San Gadu Buku e soi u fu u du a kina dei? U mu du bun ofu u mu du ogii? U mu yeepi sama di de fu dede fu puu den a dede mofu ofu u mu fika den fu dede?” ");
INSERT INTO djkNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ne Masaa Jesesi luku den dunn. Ne a daai go, ne a taigi a man taki: “Langa i ana, osi?” Ne a man langa ana. Ne wanten de, ne a ana kon bun kelle baka enke fa a be de. ");
INSERT INTO djkNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","We, di den Faliseiman anga den leliman fu Dyuweiti si taki Masaa Jesesi deesi a man, ne den ati teke faya. Ne den oli wan kuutu, fu luku fa den sa fende wan fasi fu kii Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ne wan pisi a baka, ne Masaa Jesesi go a wan mongo go begi. Da a tan de begi wan hiihii neti. ");
INSERT INTO djkNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ne di mamanten, ne a kai den sama di be e waka ne en baka kon ne en. Ne di den sama kon, ne a teke twalufu man a ini den toonmi en bakaman, fu waka anga en go na ala peesi pe ai go. Da Masaa Jesesi be e kai den man ya apaiti bosikopuman. ");
INSERT INTO djkNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Da den twalufu man di a be teke ya, na be: Simon Peitilisi, anga en baala Andeleyasi Jakowbesi Johanisi Filipi Baatomeyosi ");
INSERT INTO djkNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateyesi Towmasi Jakowbesi a manpikin fu Alefeyosi Simon Selotu*f9* ");
INSERT INTO djkNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judasi a pikin fu Jakowbesi Judasi Iskaliyotu a man di seli Masaa Jesesi gi den ogii ati sama den kii. ");
INSERT INTO djkNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ne Masaa Jesesi anga den twalufu bakaman fi en anga den taa sama di be lobi waka ne en baka anga somen taa sama ete, saka a mongo go a wan sabana peesi. Namo, da somen sama fu a hii pisiwataa fu Judeja, anga Jelusalem Foto, anga den foto enke Tilosi anga Sidoni na a sikin liba fu a ze, be kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Den be kon fu yee a leli fi en. Taawan be kon fu a deesi den. Son sama di be abi takuu sani a den tapu, e toobi den, be kon a Masaa Jesesi tu, fu a puu den gi den. Da a puu ala den takuu sani fiya a den sama tapu gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ala sama be e meke moiti fu langa ana oli en. Bika a taanga fu Masaa Gadu be e komoto ne en, e deesi ala den fiya. ");
INSERT INTO djkNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Da baka di Masaa Jesesi kaba deesi den sama, ne a opo ede luku den bakaman fi en. Ne a taigi den taki: “Seigi fu u di de enke mofinawan. Bika u o fende a bun di de a ini a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Da seigi fu sama tu, di e angii fu de enke fa Masaa Gadu wani. Bika Masaa Gadu o gi yu a sani di yu e angii de. Soseefi seigi fu sama di e kee nownow. Bika bakaten, da a kee fu den o daai kon toon lafu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Da seigi fu yu, di libisama e buuse, fu di u poti biibi na a Manpikin di saka kon toon libisama ya. Seigi o de gi u, anga ala fa den e puu u a den mindii. Den e kosi u, e poli u nen na ala se a kondee. ");
INSERT INTO djkNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Da u mu dyombo piisii, te den e du den sani ya anga u. Bika u o kisi wan gaan paiman a Masaa Gadu. Na so den sama fu fositen be du ala sowtu ogii anga den fositen apaiti takiman fu Masaa Gadu tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Da heelu fu u di e taki: ‘U gudu kaba, da u ná abi Masaa Gadu fanowdu moo.’ Bika, bakaten den gudu fu u ná o de a teli moo. Da u o fika piipii sondee wan sani. Bika u be nyan den bun fu u pasa a fesi kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Da heelu fu u di e taki: ‘U ná abi Masaa Gadu fanowdu moo, fu di u sete u libi poti kaba enke fa u wani.’ Bika wan ten e kon, di u o de sondee san u abi fanowdu. Soseefi heelu fu u di e dyombo e lafu, e meke piisii. Bika wan ten e kon, na soso kee u o go e kee, fu pina ede. ");
INSERT INTO djkNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Da heelu fu u di sama e gafa, fu di u e libi enke fa den wani. Bika na so den sama fu fosi be e gafa sama di be e gi falisi bosikopu taki, den na apaiti takiman fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ne Masaa Jesesi taigi den bakaman fi en go doo taki: “U aliki mi! U mu lobi den feyanti fu u. Da soseefi u mu du bun gi den sama di buuse u tu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Te sama e kosi u, e fuuku u, da u mu begi fu sani waka bun gi den. Soseefi u mu begi bun gi den sama di e du ogii ati sani anga u. ");
INSERT INTO djkNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Efu wan sama naki i wan baala ana a i sikin fesi, daai a taase fesi gi en, meke a naki tu. Efu wan sama teke i dyakiti, puu i impi gi en tu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Soseefi, efu wan sama begi i wan sani fi i, ná ogii gi en. Ma gi en. Efu wan sama teke wan sani fi yu, yu á mu teke en ne en baka. ");
INSERT INTO djkNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","A fasi fa i wani sama libi anga yu, na letiso i mu libi anga sama tu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Bika sowtu wini a abi efi i lobi den sama di lobi yu namo? A ná abi ná wan wini. Bika, na so den sama di e libi sondee Masaa Gadu e libi tu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Da efu yu e du bun gi sama di i sabi taki o du bun gi yu baka, da sowtu wini dati o abi? A á abi ná wan wini seefi. Bika den sama di e libi sondee Masaa Gadu, na so denseefi e libi tu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Da efi i e yuu sani gi sama, di i sabi taki sa gi yu en baka, da sowtu wini dati abi? A ná abi ná wan wini. Bika, den sama di e libi sondee Masaa Gadu, na a seefi fasi de, denseefi e libi tu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Nono! U á mu libi so. U mu lobi u feyanti. U du bun gi den. Te u yuu sani gi den, u á mu luku taki, den mu gi u en baka. Da, te u libi so, da u o fende wan gaan paiman a Masaa Gadu. Soseefi na a fasi de, u o gei u Tata, Masaa Gadu seefi, bika na so ai libi. A abi bun ati fu libisama. Bika ai yeepi sama di nái gi en daa, te go doo den takuu ati wan seefi. ");
INSERT INTO djkNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Da u mu abi tyali ati fu sama leti enke fa Masaa Gadu u Tata abi tyali ati fu den.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ne Masaa Jesesi taigi den go doo taki: “Ná kaagi fu taawan, da kaagi seefi ná o kon miti yu baka. Ná kaagi taawan taki, a mu kisi sitaafu fu wan sani di a du. Da Masaa Gadu seefi ná o sitaafu yu tu. Yu á mu oli sama na ati, da sama ná oli yu na ati tu. ");
INSERT INTO djkNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lobi gi sama sani, da Masaa Gadu o gi i baka, moo enke san i be poti pakisei seefi. Bika a o lai wan gaan bakisi, te a lai, da a langa gi yu. Bika anga a seefi sani di yu e teke maiki sani gi sama, anga en o teke maiki sani gi yu baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ne a koti wantu nongo gi den taki: “Beendiman á poi tyai beendiman na ana. Ofuso, ala den tu o kai a ini gotoo, dede. ");
INSERT INTO djkNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Soseefi wan sikoo pikin á poi sabi sani enke a mesiti fi en. Ma te a leli ala sani fu a mesiti, fosi a o de enke a mesiti.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Ne Masaa Jesesi taigi den go doo taki: “Saide meke yu e booko ede, fu puu a pikin mbalububa di de a ini wan taawan ain, ma a gaan pisi gobo di de a ini iseefi ain, i nái si? We, fa i abi a deki ati, fu taigi i baala taki: ‘Baala! Meke mi puu a pikin mbalububa a i ain gi yu,’ ma a gaan pisi gobo a ini iseefi ain de, i nái si en, fu puu? U soso mofu sama! Puu a gaan pisi gobo a iseefi ain fosi, da i ain o kiin sai fu poi puu a pikin mbalububa a i baala ain.” ");
INSERT INTO djkNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ne Masaa Jesesi taigi den baka taki: “Wan bon di e meke soso sii, a ná wan bun bon. Soseefi, wan bon di e meke bun sii, a ná wan soso bon. ");
INSERT INTO djkNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bika iniiwan bon, na a sii fi en meke i sa sabi en. Leti enke fa i si wan makabon ná o meke figasii, na soseefi, yu ná o fende figasii nyanyan a wan makabon. ");
INSERT INTO djkNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na so a de anga libisama. Wan takuu ati sama ná o taki bunbun sani. Ma wan bunbun ati sama, a bunbun sani a o taki anga en mofu. Bika na san di fuu wan sama boo ati, na dati en mofu o taki kon a doo, fu sama yee. ");
INSERT INTO djkNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Da saide meke u e kai mi Masaa, ma u nái du san mi e taki? ");
INSERT INTO djkNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma i abi sama di e teke mi taki, da den e du tu. Da mi o soi u enke sama den sama di e du san mi taki de. ");
INSERT INTO djkNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Den de enke wan sama, di diki a fondamenti fi en osu dipi go doo bunbun taanga doti. Ne a sete a osu de. Ne a osu fi en taampu kinkin. Ne a yuu di gaan wataa kon sungu a kondee, ne a osu á kai. Bika a fondamenti fi en be bun. ");
INSERT INTO djkNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma sama di nái teke mi taki, dati tan wan sama e meke en osu. Ma a á diki dipi go doo taanga doti, fu sete a fondamenti. Ma a sete en a fukufuku doti. Ne, di gaan wataa sungu kondee, ne a bunduka a osu towe holow. Bika a man á be diki dipi go doo taanga doti, fosi a be sete a osu. A letiso a o de anga wan sama di nái teke mi taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Da di Masaa Jesesi taigi den sama den sani de kaba, ne a daai go baka a Kafalnayemu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma namo, di a doo de, da wan futuboi fu wan ofisii fu Loma Foto suudati be siki. A ofisii ya be lobi a futuboi fi en ya te, ná sipowtu. Ma, da a be siki tuutuu. Ala yuu na yuu fu a be dede namo. ");
INSERT INTO djkNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma di a ofisii yee fu ala den sani di Masaa Jesesi e du, ne a go begi wantu gaansama fu Dyu Kondee, fu den go begi Masaa Jesesi, fu a kon deesi a futuboi fi en gi en. ");
INSERT INTO djkNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ne den go a Masaa Jesesi, go begi en tangi tangi fu a kon go yeepi a ofisii fu den Loma suudati, fu deesi a futuboi fi en gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ne den taigi Masaa Jesesi taki: “A man ya, na wan sama di lobi wi Islayeli sama tuutuu. A lobi wi te, a teke enseefi moni pai meke wan keliki osu gi wi. Da wi si taki a fiti fi i yeepi en gi wi, baa?” ");
INSERT INTO djkNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ne Masaa Jesesi komoto, ne ai go anga den na a osu fu a ofisii fu den Loma suudati. Da di den waka, te den koosube, ne a ofisii sende den mati fi en go taigi Masaa Jesesi taki: “Masaa, mi á dyendee sai fi i kon a mi osu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","A dati meke miseefi á kon a yu, ma mi puu sama sende kon a yu. Ma taki wan wowtu namo, da a futuboi fu mi o kon bun baka. ");
INSERT INTO djkNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bika miseefi na wan ofisii fu suudati di abi sama a mi ondoo. Ma na soseefi mi abi sama a mi tapu enke basi. Da efu mi sende wan fu den futuboi fu mi taki: ‘Go so!’ Da a musu fu go. Efu mi kai en taki: ‘Kon!’ Da wanten a musu fu kon. Te mi sende den taki: ‘U du dati!’ Da wanten den e du en tu. Soseefi mi sabi taki, efu yu, Masaa Jesesi, taki wan wowtu, da a musu pasa enke fa yu taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Da di den sama taigi Masaa Jesesi a sani ya, ne a foondoo en te, ná sipowtu. Ne a daai luku den sama di be e waka anga en. Ne a taigi den taki: “A sani ya bigi gi mi tuutuu! Bika a sama ya, di a ná wan Islayeli sama, ne en e biibi mi moo enke u Islayeli sama seefi.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ne den sama di be tyai a mofu kon gi Masaa Jesesi, daai gwe baka na a ofisii fu suudati. Di den go doo, ne den si taki, a wookoman fi en kon bun kelle. ");
INSERT INTO djkNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Da bakadati, ne Masaa Jesesi anga den bakaman fi en go a wan foto den e kai Nain. Da somen sama be e waka ne en baka. ");
INSERT INTO djkNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Da di den doo na a kondee mofu, ne den si tyaipi sama e waka komoto a ini a kondee e tyai wan sama go beli. A sama di dede ya, na be wan yonkuman. Na be awan kodo manpikin fu wan uman di man dede fika a ganda tu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ma namo, di Masaa Jesesi si a uman, ne gaan tyali fi en kisi en fi en. Ne a taigi en taki: “Uman, ná kee moo, ye!” ");
INSERT INTO djkNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne Masaa Jesesi waka go oli a daagi. Den sama di e tyai a daagi taampu pii. Ne a taki: “Yonkuman! Mi e taigi yu, Opo kon a libi baka!” ");
INSERT INTO djkNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ne wanten wanten de, ne a dedesama weki. Ne a opo sidon, ne a bigin sete fu taki. Ne Masaa Jesesi taigi a uman taki: “Uman! Luku a pikin fi yu ya!” ");
INSERT INTO djkNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Da a sani di pasa ya, bigi gi den sama te, ná sani. Den taki: “Masaa Gadu bigi! A kon yeepi den sama fi en. A sende wan gaan apaiti takiman fi en kon gi wi, fu yeepi wi.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Da a nyunsu ya paati a hii Judeja anga ala den pisiwataa di lontu ape. ");
INSERT INTO djkNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Da den bakaman fu Johanisi a Dopuman seefi yee fu den sani di Masaa Jesesi e du. Ne den go taigi Johanisi a pe a be de a dunguu osu san anga san den yee. Ne di Johanisi yee so, ne a kai tu fu den bakaman fi en kon ne en. ");
INSERT INTO djkNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ne a sende den taki: “U go a Jesesi, da u akisi en, efu ne en na a sama di Masaa Gadu be paamisi fu sende kon a goontapu, fu kon yeepi wi. Efu, kande a sama de, de a baka fu kon ete.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Ne den bakaman fu Johanisi e go, te den go doo Masaa Jesesi. Da di den go doo, da Masaa Jesesi be e deesi somen sama, fu ala sowtu siki. A be e kaasi takuu jeje puu a taawan tapu. A be e deesi den beendiman. Ne den gi Masaa Jesesi a bosikopu fu Johanisi. Den taki: “Johanisi a Dopuman sende u fu u kon akisi yu efu na yu, na a sama di Masaa Gadu be paamisi, fu sende kon yeepi wi a goontapu. Efu, kande a sama de, de a baka, fu kon ete?” ");
INSERT INTO djkNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ne Masaa Jesesi piki den bakaman fu Johanisi taki: “U go a Johanisi baka. Go taigi en den sani di u e si, anga den sani di u e yee. U taigi en taki: ‘Den beendiman e si sani baka! Lanman e waka. Gwasiman e kon bun baka, sikin gaata kelle. Dofuman e yee sani baka tu. Soseefi dedesama e weki baka tu. Den mofinawan e yee a Bun Nyunsu fu Masaa Gadu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","U taigi Johanisi tu taki: ‘Seigi fu sama di e biibi san mi e du te doo, sondee fu kuutu mi a ini en ati, wansi sani nái waka enke fa a be pakisei.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Da, di Masaa Jesesi taigi den bakaman fu Johanisi so, ne den daai gwe baka. Ne di den gwe, ne Masaa Jesesi bigin taki anga den sama taki: “Di u be go a ini a gaan sabana go luku Johanisi, sama u si anda? U si wan sama di de enke wan ken di winta e wai go, wai kon enke fa a wani? ");
INSERT INTO djkNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","U si wan sama di be wei gaan dii koosi e piisii e nyan e diingi? Nono! Den sama di e libi den sowtu libi de, a ini paleisi ini den e de. A ná sabana ini. ");
INSERT INTO djkNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Efu kande u denki taki, u be o si wan gaan apaiti takiman fu Masaa Gadu? We, na wan apaiti takiman fu Masaa Gadu, u si de tuu. Ma Johanisi de moo enke wan apaiti takiman fu Masaa Gadu seefi. ");
INSERT INTO djkNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Bika na a Johanisi ya, na a sama di Masaa Gadu Buku be sikiifi taki: ‘Mi o sende wan apaiti takiman fu mi kon, fosi yuseefi kon doo. A o taigi sama fu daai seeka den libi, na a leti pasi fu Masaa Gadu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Fu ala den sama di komoto a mama bee, fu sensi di goontapu sete, te kon miti now, da ná wan fu den di hei enke Johanisi ya. Ma iniiwan sama di de a ini a Nyun Tii fu Masaa Gadu, te go doo den moo lagi wan seefi, hei moo a Johanisi ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","We, den mofinawan anga den sama di e piki lantimoni, be e teke san Johanisi be e taki. Bika den be kon si taki, Masaa Gadu abi leti tuu. Ne den daai den libi, ne den be meke Johanisi dopu den. ");
INSERT INTO djkNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma den Faliseiman anga den leliman fu Dyuweiti á be wani a yeepi, di Masaa Gadu be o yeepi den ya. Bika den á be wani daai den libi, fu Johanisi dopu den. ");
INSERT INTO djkNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","We, ne Masaa Jesesi taigi den taki: “San u gei? San mi sa taki fu u? ");
INSERT INTO djkNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","U gei pikinengee di sidon a ganda e bali gi denseefi taki: ‘U pee finyoo gi u fu u dansi, ma u á dansi. U singi tuka gi u fu u kee, ma u á kee.’ ");
INSERT INTO djkNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bika Johanisi a Dopuman be kon, a á be e nyan beele efu diingi win. Ne den fende taki, na didibii de ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Now, ne a Manpikin di saka kon toon libisama ya kon, ai nyan beele e diingi win. Ne u fende taki: ‘En na soso nyan ai nyan, e diingi. U fende taki, a nái libi bun, bika ai meke mati anga den man di e piki lantimoni anga den sama di abi takuu nen a kondee.’ ");
INSERT INTO djkNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ma koni musu de fu si a den letiopu wooko fu ala den pikin fi en.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ma namo, wan Faliseiman den e kai Simon, kai Masaa Jesesi, fu a kon nyan anga en ne en osu. Ne Masaa Jesesi go. Ne a go sidon a tafaa fu nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma, da wan uman di be abi polinen a kondee be de na a pisi kondee de tu. Da di a yee taki, Masaa Jesesi de a Simon osu, ne a go na a osu de tu. Da di ai go, ne a tyai wan gaan dii pikin bataa sumee switi fatu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Di a go doo, ne a saka kini a Masaa Jesesi baka, ne en futuse. Ne a bigin kee. Ne ai kee e bosi Masaa Jesesi futu te, en wataa ain nati Masaa Jesesi futu petee. Ne a deemi en anga en ede uwii. Ne a teke a sumee switi fatu, ne a kandi lobi a Masaa Jesesi futu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Da di a Faliseiman si a sani ya, ne ai kuutu a ini enseefi taki: “Ma Jesesi sa de wan apaiti takiman fu Gadu tuutuu? A ná kan! Bika efu a be de wan apaiti takiman fu Gadu, da a be musu sabi sama na a uman di e oli en de. Na wan polinen uman.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Namo, ne Masaa Jesesi taigi en taki: “Simon! Mi abi wan sani di mi fu taigi yu.” Ne Simon taki: “We, Mesiti, i sa taki!” ");
INSERT INTO djkNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ne a taigi en taki: “Tu man be yuu moni a wan man. Wan fu den yuu feifi dunsu kolu. A taawan yuu feifi ondoo kolu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma, den á be poi fende a moni fu pai a man baka. Ne di den de te wan pisi, ne a man taigi den taki: ‘U sabi san? U fika a moni. A á de fu u pai mi en moo.’ Da on di fu den tu sama ya o moo lobi a sama di den be mu pai?” ");
INSERT INTO djkNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ne Simon piki en taki: “We, mi denki taki, na a sama di be mu pai en feifi dunsu kolu.” Ne Masaa Jesesi taki: “Weeno! I piki bun!” ");
INSERT INTO djkNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ne a luku a uman, ne a taigi Simon taki: “I si a uman ya? Di yu kai mi kon a yu osu, yu á meke moiti seefi, fu wasi mi futu. Ma a uman ya wasi mi futu anga en wataa ain, deemi en anga en ede uwii. ");
INSERT INTO djkNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Di yu e gi mi odi, yu á bosi baasa mi. Ma fanafu mi kon ya, ne a uman ya e bosi mi futu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Di mi kon a yu osu, yu ná iti fatu a mi ede enke fa a gwenti tu. Ma a uman ya lobi a moo dii switi fatu fu a kondee gi mi futu. ");
INSERT INTO djkNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","A uman di i si yu e si ya, be du ipi ogii. Ma mi gi en paadon fu ala fiya. A dati meke, i si a lobi mi so. Ma a sama di e denki taki, na wan pikin ogii namo a du, ne Masaa Gadu gi en paadon fu dati, da na pikinso namo a o lobi Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ne Masaa Jesesi daai, ne a taigi a uman taki: “Uman! I kisi paadon fu ala den takuudu anga ogii di i be du.” ");
INSERT INTO djkNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Da, di Masaa Jesesi taki so, ne wantu fu den sama di be sidon e nyan anga en makandii e kuutu taki: “Sama na a man di taki, ai gi sama paadon fu takuudu anga ogii de?” ");
INSERT INTO djkNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ma Masaa Jesesi taigi a uman taki: “Uman! A biibi fi yu yeepi yu. Da go fi yu a osu baka anga wan piisii ati.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Da bakadati, ne Masaa Jesesi go a den kondee kondee. Da ai paati a Bun Nyunsu di e taki, fu a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Da den bakaman fi en anga wanlo umansama be de anga en tu. Da Masaa Jesesi be deesi den uman ya, fu ala sowtu takuu siki. Somen fu den, a be puu takuu jeje a den tapu. Wan fu den uman ya na Maliya Makidala, di Masaa Jesesi be puu seibin takuu jeje ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wan taawan na be Johana, a uman fu Kusasi, wan edeman fu a paleisi fu Kownu Helowdesi anga wan taawan den e kai Susana. Soseefi somen somen taawan moo di be e waka anga Masaa Jesesi anga den bakaman fi en e lontu. Da den be e puu denseefi moni e bai san di Masaa Jesesi anga den bakaman fi en be abi fanowdu gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Da wan dei, ne somen sama komoto a den kondee kondee fu kon aliki Masaa Jesesi. Ne a gi den wan ageisi toli. ");
INSERT INTO djkNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","A taki: “Wan dei, ne wan paandi goonman go tyatya wan sii fi en, fu goo. Ma di a tyatya a sii, ne afu fu a sii kai a sikin pasi. Ne sama waka masi den. Soseefi pikinfoo fee kon piki den sii nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Da soseefi afu fu a sii kai a siton ini. Da di a booko ain kon a tapu doti, ne den dede. Bika den lutu fu den á be poi go dipi a ondoo doti, fu fende wataa enke fa a de fanowdu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Da soseefi, afu fu a sii kai a ini maka. Da di den goo kon anga den maka makandii, ne den maka pasuma den kii. ");
INSERT INTO djkNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma afu fu a sii kai a bun doti. Ne den dati goo, te den kon bigi meke nyanyan te, a ipi. A puu wan ondoo toon fu san di a goonman be tyatya.” Ne Masaa Jesesi taigi den taki: “Sama di abi yesi fu yee, da meke a yee san mi taki ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ne bakadati, ne den bakaman fu Masaa Jesesi akisi en taki: “Masaa Jesesi, san wani taki ageisi toli di i taki de?” ");
INSERT INTO djkNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ne Masaa Jesesi taigi den taki: “U mu sabi den kibii toli fu a Nyun Tii fu Masaa Gadu. Ma den taa sama, na ageisi toli mi e gi den. ‘Bika anga opoopo ain, den á wani si. Anga opoopo yesi, den á wani yee. Soseefi den á wani fusutan tu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ne a taigi den taki: “We, a puu fu a ageisi toli de so. A sii, dati na a wowtu fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A pasi tapu, di a sii kai, dati na den sama di e yee a wowtu fu Masaa Gadu. Da didibii e kon piki a wowtu puu a ini den ati wanten. Bika a á wani fu den sama biibi Masaa Gadu, fu den fende a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A pisi siton doti di a sii kai, dati na den sama di, te den yee a wowtu fu Masaa Gadu, da den e teke en anga gaan piisii. Ma a wowtu á go dipi a ini den ati ini. Bika te toobi anga nowtu miti den, fu tesi luku efu den e biibi Gadu tuutuu, da wanten den e fika a biibi. ");
INSERT INTO djkNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A pisi doti anga maka pe a sii kai, dati na den sama di teke a wowtu fu Masaa Gadu tuutuu. Ma a booko ede fu den sani fu goontapu anga a feti fu abi tyaipi gudu anga suku gaan piisii e kii a wowtu fu Masaa Gadu a ini den ati. Bika na den sani ya soso fuu den ati. ");
INSERT INTO djkNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A pisi bun doti, pe a sii kai, dati na wan sama di e aliki a wowtu fu Masaa Gadu anga wan bunbun ati. Ne a gi a wowtu pasi a ini en ati, fu goo. Soseefi ai tei ati oli doo naamo, fu te enke a wowtu puu wini a ini en libi. ");
INSERT INTO djkNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Te i leti wan abeni a ini wan osu, yu nái poti en a kama ondoo ofu teke sani tapu en. Nono! Yu o poti en a tapu, ofuso, yu o oli en hei, fu a sa leti kiin peesi gi ala sama a ini a osu. Da te a leti, da ná wan sani o kibii di ná o kon a kiin, fu sama si. ");
INSERT INTO djkNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Da na soseefi den sani di mi e leli u ya o kon a kiin wan dei. ");
INSERT INTO djkNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Da a didon a yu, fa yu e aliki sani. Bika sama di kisi wan sani fu Masaa Gadu sa kisi moo. Ma sama di á kisi ná wan sani fu Masaa Gadu sa lasi ala a pikinso di a denki taki a abi.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Da wan dei, ne Masaa Jesesi be de a wan osu e leli sama Gadu wowtu. Ne en mma anga den baala fi en kon doo. Ma den á be poi go doo Masaa Jesesi. Bika sama de ipi a ini a osu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ne den taigi Masaa Jesesi taki: “I mma anga den baala fi yu de a doose. Den wani si yu.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ne Masaa Jesesi piki den taki: “A bun! Ma i sabi sama a mi mma anga mi baala? Na den sama di e yee Masaa Gadu wowtu, da den e du san Masaa Gadu taki. Na den na mi mma anga mi baala.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Da wan dei, Masaa Jesesi anga den bakaman fi en be de a wataa mofu. Ne a taigi den taki: “U go a boto, meke u koti go na abaase fu a ze so.” Ne den go a boto, ne den wai a mindii. ");
INSERT INTO djkNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Da di den koti fu abaa, ne Masaa Jesesi kai a siibi. Da di den go, te wan pisi, ne wan gaan winta wai na a ze, e seke a wataa e wasi go a ini a boto te, na fu den sungu namo. ");
INSERT INTO djkNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ne den bakaman fi en feele te, den lon go weki en taki: “Masaa! Masaa opo! Kon yeepi wi, wi e sungu dede!” Ne Masaa Jesesi opo, ne a kaasi a winta anga a wataa taki: “U tan pii!” Ne a wataa anga a winta koo pii. ");
INSERT INTO djkNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ne Masaa Jesesi daai go a den bakaman fi en, ne a akisi den taki: “Pe u biibi de?” Da den bakaman fi en feele te, den foondoo. Taawan e akisi taawan taki: “Oho! Sama na a man ya? A winta anga a wataa seefi e du san a taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ne bakadati, ne Masaa Jesesi anga den bakaman fi en koti abaa go na a kondee fu den Gelaseini sama, na abaase fu Galileya. ");
INSERT INTO djkNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Da di Masaa Jesesi komoto a soo, ne wan man fu a kondee kon ne en. Da wanlo takuu sani de na a man ya tapu. A nái wei koosi a sikin efu tan a ini osu moo, ma a fika a kondee go e tan a ini den siton geebi olo. Na onmen langa kaba den takuu sani de ne en tapu e pina en. Den sama fu a kondee meke onmen moiti anga en, bui en na ana anga futu, ma ai booko den bui lon fi en gwe a ini den sabana. Ma namo, di a si Masaa Jesesi, ne a bali taanga towe enseefi a doti taki: “San wi anga yu abi Jesesi, Manpikin fu a moo Hei Gadu a tapu? Gaantangi, ná sitaafu mi, baa?” Bika Masaa Jesesi be kaasi en a fesi kaba, fu komoto na a man tapu gwe. ");
INSERT INTO djkNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ne Masaa Jesesi akisi en taki: “Fa den e kai yu nen?” Ne a takuu jeje piki taki: “Na mi den e kai Hipiman.” Bika tyaipi tyaipi takuu sani de ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Ne den sani begi Masaa Jesesi taki: “Gaantangi! Ná iti u go a ini Abisi*f10* ete, baa? Puu u sende go a ini den agu anda.” Bika wanlo agu be de koosube de a wan pikin mongo, e suku sani fu nyan. Ne Masaa Jesesi yaki den poti go a ini den agu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ne den takuu sani komoto na a man tapu, ne den go a ini den agu. Ne wanten ala den agu lon saka a mongo huu, te a wataa dyuluu, dede pii. ");
INSERT INTO djkNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ne den man di be e luku den agu lon gwe a kondee ganda, go taigi den sama taki, na sowan sani pasa. ");
INSERT INTO djkNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ne ala den sama booko gwullu komoto a den peesi, kon a Masaa Jesesi, fu kon luku san pasa anga denseefi ain. Ne den si a man di den takuu sani be de ne en tapu sidon a Masaa Jesesi se. A wei koosi, de fi en moi anga en bunbun fusutan. Da ala den sama feele fu san den si ya. ");
INSERT INTO djkNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","We, ne den sama di be si san pasa, taigi den taawan di kon de, fa Masaa Jesesi puu den takuu jeje na a man tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ne a sani ya meke den sama fu a pisiwataa de, begi Masaa Jesesi gaantangi, fu a komoto a den kondee. Ne Masaa Jesesi go a boto baka, ne a koti abaa. ");
INSERT INTO djkNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ne a man di a be puu den takuu jeje ne en tapu begi en gaantangi, fu a go anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ma Masaa Jesesi taigi en taki: “Nono! Daai go a den famii fi yu. Go taigi den a gaan bun di Masaa Gadu du gi yu.” Ne a man go enke fa Masaa Jesesi sende en. Ne ai taigi ala sama a gaan bun di Masaa Jesesi du gi en. ");
INSERT INTO djkNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Da somen sama be de na abaase e luku Masaa Jesesi. Da di a doo, ne den piisii anga en te, a ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ne wan edeman fu Dyu keliki den e kai Yailesi kon a Masaa Jesesi. Ne a saka kini a doti, begi Masaa Jesesi gaantangi, fu a kon go anga en ne en osu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bika en wankodo umanpikin di be abi twalufu yali be siki te, na fu dede namo. Ne Masaa Jesesi komoto, ne ai go anga Yailesi. Da somen sama be bosu lontu en te, a á be poi waka enke fa a wani. ");
INSERT INTO djkNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Da wan uman be de a ini den somen sama de di be kisi en mun siki twalufu yali langa sondee fu koti. Ná wan sama be poi deesi en. Da di a yee taki, Masaa Jesesi kon de, ne a feti go ne en. Ne na pe a de a ini den sama de, ne a fende pasi langa ana oli a yekeyeke fu Masaa Jesesi koosi mofu. Ne di a oli en, ne a buulu koti wanten. A kon bun kelle. ");
INSERT INTO djkNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ne Masaa Jesesi daai, ne a akisi den sama taki: “Sama oli mi?” Ne ala den sama e bali taki: “A ná mi! A ná mi!” Peitilisi dati taigi en taki: “Masaa! Luku onmen sama e oli yu ya, da fa i sa akisi sama oli yu?” ");
INSERT INTO djkNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ma Masaa Jesesi e taki namo taki: “Wan sama oli mi! Bika mi fii wan kaakiti komoto a mi sikin, go deesi wan sama.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ne di a uman si taki, Masaa Jesesi sabi taki a oli en tuu, ne a waka kon feele feele a fesi go saka kini a Masaa Jesesi fesi a pe den somen sama de. Ne a taigi Masaa Jesesi ala sani te doo, fu saide meke a waka kon oli en anga fa a kon bun di a oli en koosi mofu. Na so ala sama yee san pasa anga a uman ya. ");
INSERT INTO djkNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ne Masaa Jesesi taigi a uman taki: “Uman! A biibi fi yu yeepi yu kaba. Go a osu anga wan piisii ati.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Da di Masaa Jesesi e taki anga a uman ya, ne wan sama fu Yailesi osu tyai bosikopu kon gi Yailesi a pasi taki: “Yailesi! A pikin fi i dede. A á de fi i meke Masaa Jesesi go a yu osu anda moo. Na fu soso a o go anda.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma namo, da Masaa Jesesi yee, ne a taigi a dda fu a pikin taki: “Ná feele. Tan poti biibi a mi doo, da yu o si san o pasa. Bika a umanpikin fi yu o de bunbun gusontu gusontu baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ne den e go te, den go doo a osu fu Yailesi. Ma Masaa Jesesi á be wani taa sama moo enke, Peitilisi anga Jakowbesi anga Johanisi anga a mma anga a dda fu a pikin go a ini a osu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Da di den doo a osu, ne somen sama be de ape e kee e bali e tyali gaan tyali. Bika a pikin be dede. Ne Masaa Jesesi taigi den taki: “U á bali so! U á kee moo, bika a pikin á dede. A siibi ai siibi.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma den meke tyuu, wai fesi poti a se gi Masaa Jesesi. Bika den be sabi kiinkiin taki a pikin be dede tuu. ");
INSERT INTO djkNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ne Masaa Jesesi waka pasa go na pe a pikin didon. Ne a oli a pikin ana, ne a bali taki: “Pikin uman! Opo!” ");
INSERT INTO djkNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ne wanten libi kon a ini a pikin baka. Ne a opo taampu. Ne Masaa Jesesi taigi den taki: “U gi en nyanyan meke a nyan.” ");
INSERT INTO djkNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Da a sani ya foondoo a mma anga a dda te, ná sipowtu. Ne Masaa Jesesi taigi den taki: “U si a sani di pasa ya, u á mu taigi ná wan sama! U yee!” ");
INSERT INTO djkNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ma namo, ne wan dei, ne Masaa Jesesi kai den twalufu bakaman fi en kon ne en. Ne a gi den makiti anga taki, fu den yaki takuu sani puu a sama tapu anga fu deesi sama. ");
INSERT INTO djkNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne a sende den, fu den go a den kondee kondee go taigi ala sama fu a Nyun Tii fu Masaa Gadu. Soseefi a sende den, fu den deesi sama tu. ");
INSERT INTO djkNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ne a taigi den go doo taki: “Te u o go, da u á mu tyai ná wan sani anga u. U á mu tyai waka tiki. Soseefi u á mu tyai tasi efu nyanyan sani. Da soseefi u mu tyai moni tu. Da anga den koosi di de a u sikin namo u mu go. U á mu tyai taawan. ");
INSERT INTO djkNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Da, te wan sama teke u oli ne en osu, da na ape u mu tan, fu te enke yuu kisi fu u gwe baka. ");
INSERT INTO djkNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma a kan taki, te u o go a wan kondee, da sama á wani yee u taki. Da u mu naki a santi fu u ondoo futu puu towe gi den enke wan maiki taki, den be fende a okasi fu teke a Bun Nyunsu fu Masaa, ma den á be wani. Da u komoto de. Da na den mu sabi.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ne den bakaman komoto, ne den go a den kondee kondee go e paati a Bun Nyunsu fu Masaa Gadu. Da den e deesi somen sikiman tu. ");
INSERT INTO djkNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","We namo, da Kownu Helowdesi yee den foondoo sani di Masaa Jesesi e du. Ne a bigi gi en te, a á sabi san fu a taki. Bika ná wan sama be sabi sama na a sama di be e du den foondoo sani de. Son sama taki: “Na Johanisi a Dopuman di Kownu Helowdesi be kii. Ne en daai komoto a dede kon e du den foondoo sani ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Taawan taki: “Na a apaiti fositen apaiti takiman fu Masaa Gadu, di den be e kai Eliya. Ne en opo baka komoto a dede kon e du den sani de. Efu ná so, da na wan fu den taa fositen apaiti takiman fu Masaa Gadu weki komoto a dede. Ala sowtu sani den piki e taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma Kownu Helowdesi taki: “A sa de Johanisi? Na miseefi meke den doo Johanisi ede.” Ne Kownu Helowdesi e meke moiti naamo fu si en. ");
INSERT INTO djkNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ne baka wan pisiten, ne den apaiti bosikopuman fu Masaa Jesesi di a be sende go a den kondee kondee, daai kon baka. Ne den taigi en ala fa sani waka di den go. Ne Masaa Jesesi teke den, ne en anga den wawan go a wan peesi, koosube fu a kondee di den e kai Betisaida. ");
INSERT INTO djkNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ma den sama sabi pe Masaa Jesesi anga den bakaman fi en e go. Ne den faaka en waka ne en baka go, te na a peesi. Ma di Masaa Jesesi si den, da a piisii anga den. Ne a gi den a Bun Nyunsu di e taki, fu a Nyun Tii fu Masaa Gadu. Ne a deesi ala den sikiman di be kon ne en de. ");
INSERT INTO djkNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Da di a doo yuu fu neti kai, ne den bakaman fu Masaa Jesesi kon ne en, ne den taigi en taki: “Masaa! A á moo bun efi i sende den sama gwe, no? Bika a kon lati kaba. Efi i sende den gwe, da den sa bai sani a den kondee di de koosube ya. Soseefi den sa fende peesi fu siibi tu. Bika a sabana pe u de ya ná abi ná wan sani fu nyan. Soseefi den ná o poi fende peesi ya fu siibi tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ne Masaa Jesesi piki den taki: “Nono! U gi den nyanyan meke den nyan!” Ne den piki en taki: “Fa wi o gi den nyanyan fu nyan? Wi abi feifi beele anga tu fisi namo. Efuso, da u mu go bai sani fu nyan gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bika a be sa de wan sani fu feifi dunsu manengee.” Ma Masaa Jesesi taigi den taki: “U meke den sama sidon a doti a kulu, feifitenti, feifitenti te doo.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ne den bakaman meke den sama go sidon enke fa Masaa Jesesi taki. ");
INSERT INTO djkNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ne Masaa Jesesi teke den feifi beele anga den tu fisi, ne a opo ede luku tapu, ne a begi gi Masaa Gadu daa, te a kaba. Ne a booko den feifi beele anga den tu fisi pisipisi gi den bakaman, fu den go paati. Ne den bakaman gi den sama. ");
INSERT INTO djkNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ne den sama teke, ne den nyan te, den bee fuu kinkin. Di den bakaman fi en piki san di den sama nyan fika, a fuu twalufu gaan bakisi. ");
INSERT INTO djkNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Da wan taa dei, ne Masaa Jesesi wawan be go a wan peesi, go begi. Da di a begi te wan pisi, ne den bakaman fi en kon ne en. Ne a akisi den taki: “We, fa mi anga u e waka e lontu ya, sama den sama taki mi, de?” ");
INSERT INTO djkNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ne den piki en taki: “We, son sama e taki, yu na Johanisi a Dopuman di Kownu Helowdesi be kii. Ne en weki kon ya baka. Taawan taki, yu na Eliya, a fositen apaiti takiman fu Masaa Gadu, ne en weki kon baka a goontapu. Efu ná so, da na wan fu den taa fositen apaiti takiman weki komoto a dede.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ne Masaa Jesesi akisi den baka taki: “We u, no? Fa mi anga u de ya, sama mi de gi u?” Ne Peitilisi piki en taki: “Yu na Kelestesi, a Kownu di Masaa Gadu be paamisi fu sende kon fu yeepi u.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Namo Masaa Jesesi bali den taanga taanga fu den á taigi ná wan sama, sama a de. ");
INSERT INTO djkNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ne Masaa Jesesi taigi den taki: “We, gaan banowtu de a fesi e kon miti a Manpikin di saka kon toon libisama ya. Bika den gaansama fu kondee anga den hei apaiti begiman anga den leliman fu weiti o kuutu en. Da den o tyai en go kii. Ma baka dii dei, da a o weki kon a libi ya baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ne bakadati, ne a taigi ala den sama taki: “Efu wan sama wani waka a mi baka, da a á mu teli enseefi moo. Ibii dei a mu e tyai a sitaafu di o kon ne en tapu enke wan sama e tyai wan koloisi, fu den go sipikii en kii. ");
INSERT INTO djkNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bika ibii sama di sa lasi en libi fu mi ede, sa fende libi. Ma sama di e suku fu kibii a libi fi en sa lasi a libi di Masaa Gadu e gi. ");
INSERT INTO djkNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bika sowtu yeepi a abi, efi i nyan fu a goontapu ya, ma i lasi a libi fu tego fu go a didibii faya? ");
INSERT INTO djkNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Da efu wan sama de, di e sen gi mi anga mi wowtu, da na soseefi a Manpikin di saka kon toon libisama ya o sen gi en tu, te a o daai kon baka. Bika, te mi o kon anga a gaan dyendee fasi fu mi, anga di fu mi Tata anga di fu den apaiti Basiya fu Masaa Gadu Kondee*f11*, da mi o sen gi sowan sama tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ne Masaa Jesesi taigi den go doo taki: “U si fa mi e taki anga u ya? Wantu sama taampu ya, di ná o tesi dede, fosi den si a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ne aitin dei baka fu di Masaa Jesesi taigi den sama den sani ya, ne a teke Peitilisi anga Jakowbesi anga Johanisi, ne den go a wan mongo go e begi. ");
INSERT INTO djkNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Da, di Masaa Jesesi begi doo wan pisi, ne en hii fesi daai kon de wan hii taa fasi. En koosi seefi daai e beenki te, ai meke mala mala. ");
INSERT INTO djkNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ne wanten so, ne tu man taampu na a mongo tapu e taki anga en. Da na Eliya anga Mosesi, tu fositen apaiti takiman fu Masaa Gadu, di be dede gwe langa ten kaba. Da denseefi koosi be e beenki leti enke fa sama a Masaa Gadu a tapu e beenki. ");
INSERT INTO djkNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Da den be kon e taki anga Masaa Jesesi, fu a wooko di a be kon fu du a goontapu ya. Dati na a dede, di a be o dede a Jelusalem. ");
INSERT INTO djkNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Da a yuu de, da Peitilisi anga den taa man be e siibi. Ne den weki, ne den si Masaa Jesesi anga a dyendee fasi fi en anga den tu sama di kon e taki anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ne di den tu sama sete fu gwe, ne Peitilisi bali taki: “Masaa! Pe u de ya switi. Meke u meke dii masanga ya, no? Wan fi yu, wan fu Mosesi anga wan fu Eliya.” Da na fu di Peitilisi be buuya fu san di a be si, meke a taki den sani ya. ");
INSERT INTO djkNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma a á kaba taki seefi, ne wan woluku saka komoto a tapu kon tapu, Masaa Jesesi anga den tu taa sama suu gbu. Ne den bakaman fu Masaa Jesesi feele te, ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ne wan Tongo taki a ini a woluku taki: “Disi na mi lobi Manpikin, di mi teke sende kon a goontapu! U aliki san ai taigi u!” ");
INSERT INTO djkNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ne, di a Tongo ya taki so kaba, ne den si, taki na Masaa Jesesi wawan too de ape. Eliya anga Mosesi gwe anga a woluku. Ma anga ala fa den man si a sani de seefi, toku den á taigi ná wan sama, fu onmen langa. ");
INSERT INTO djkNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Da a taa dei, ne Masaa Jesesi anga den bakaman fi en saka komoto na a mongo. Ma namo, di a saka, ne somen sama kon, de fu miti anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ne wan sama bali wan gaan bali a ini den somen sama de taki: “Mesiti! Gaantangi, kon go yeepi mi anga awan kodo manpikin fu mi, baa? ");
INSERT INTO djkNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bika wan sani e kon ne en tapu taanga taanga seefi. Da te a sani kon ne en tapu, da ai towe en, da ai ali en a doti. Da sukuma e komoto ne en mofu. Da sani nái komoto na a pikin ya tapu moo so. Da ala yuu ai poti a pikin ya sikin swaki malengii naamo. ");
INSERT INTO djkNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi be begi den bakaman fi yu, fu den be kaasi a takuu jeje puu ne en tapu gi mi. Ma den á be poi puu en.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ne Masaa Jesesi taki: “Oho! Libisama! Saide meke u nái biibi ete? On langa mi mu oli pasensi anga u ete, fosi u biibi mi?” Ne a taigi a dda taki: “Tyai a pikin kon gi mi.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ne a dda tyai a pikin e kon gi Masaa Jesesi. Da di ai kon anga en, ne a sani subi a pikin te, a towe en a doti e ali. Ne Masaa Jesesi kaasi en puu na a pikin tapu gwe. Ne a komoto wanten na a pikin tapu. Ne a kon bun kelle. Ne Masaa Jesesi teke a pikin, ne a gi a dda en pikin baka. ");
INSERT INTO djkNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Da a sani ya foondoo den sama, te den taki: “A kaakiti fu Masaa Gadu bigi! Ai! Masaa Gadu abi tuutuu kaakiti!” Da a yuu di den sama e gafa Masaa Jesesi fu den sani di ai du, ne Masaa Jesesi taigi den bakaman fi en taki: ");
INSERT INTO djkNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“U aliki bun san mi o taigi u! A á langa moo, da libisama o seli a Manpikin di saka kon toon libisama ya, gi sama fu kii.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ma den bakaman fi en á fusutan san a taigi den de. Bika na be wan kibii sani gi den ete. Ma anga ala fa den á fusutan a sani de, toku ná wan fu den be abi a deki ati, fu akisi en san a sani de wani taki. ");
INSERT INTO djkNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ne a yuu de, ne wan gaan takitaki opo a den bakaman fu Masaa Jesesi mindii. Den e akisi den na den taki, on di fu u na a moo heiwan fu u ala? ");
INSERT INTO djkNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma, ne di Masaa Jesesi sabi anga san den e feti, ne a teke wan pikin wai kon ne en. ");
INSERT INTO djkNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ne a taigi den taki: “U si a pikin ya. A ná wan hei sama. Da a sama di sa lesipeki wan sama enke a pikin ya, di á de wan hei sama, da na miseefi a lesipeki kaba. Da sama di lesipeki mi, lesipeki a sama di sende mi kon a goontapu. Da sama di e saka enseefi na ala den taawan ondoo, ne en na a moo heiwan fu ala den taawan a Masaa Gadu ain.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","We, ne wan fu den bakaman fu Masaa Jesesi den e kai Johanisi taigi Masaa Jesesi taki: “Masaa! U si wan sama di teke i nen e puu takuu jeje a sama tapu. Ma u bali, bika a á de a u se.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ne Masaa Jesesi taki: “Nono! U á mu tapu en, bika efu wan sama á de u feyanti, da a de a u se.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ma namo, da a yuu be kon koosube, di Masaa Gadu be o teke Masaa Jesesi puu a goontapu ya tyai go ne en kondee a tapu anda baka. Ma, da Masaa Jesesi mu go a Jelusalem fosi. ");
INSERT INTO djkNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma, da fosi a komoto a Galileya, fu go a Jelusalem, ne a sende tu bakaman fi en go a fesi, a wan fu den kondee fu den Samaliya sama go suku peesi, fu den siibi a pasi. Ne den go, te den go doo na a kondee. Ne den go akisi den sama peesi, fu den anga Masaa Jesesi siibi. ");
INSERT INTO djkNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ma den sama fu Samaliya Kondee á wani gi den peesi, fu di den sabi taki na Jelusalem den e go. ");
INSERT INTO djkNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ne den tu bakaman daai kon piki Masaa Jesesi baka taki, den sama á wani. Da, di Jakowbesi anga Johanisi yee taki den sama á wani, ne den akisi Masaa taki: “Masaa! Yu á wani u kai faya komoto a tapu kon boon den puu de, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ma Masaa Jesesi bali den taki: “U kaba! A sani di u taki de, a ná wan bun sani.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ne den go a taa kondee go suku peesi siibi. ");
INSERT INTO djkNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Da di den de a pasi e gwe, ne wan sama kon a Masaa Jesesi, ne a taigi en taki: “Mi wani go anga yu, wansi pe yu e go.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma Masaa Jesesi piki en taki: “A bun! Ma sabi taki, den meti abi olo pe den e tan, enke boo peesi. Soseefi den foo fu tapu abi nesi fu boo. Ma a Manpikin di saka kon toon libisama ya, ná abi wanboo peesi taki, na ape ai tan.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ne wan taa dei baka, ne Masaa Jesesi kai wan man taki: “Kon go anga mi fu toon mi bakaman.” Ma a man ya piki taki: “We, Mesiti, mi wani go anga yu, ma gaantangi gi mi pasi, meke mi beli mi dda fosi, baa? Da mi sa kon.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma Masaa Jesesi piki en taki: “Man! Fika den dede, meke den beli den dede. Ma gwe go paati a Bun Nyunsu di e taki, fu a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ne wan taa dei, ne wan man taigi Masaa Jesesi taki: “Masaa Jesesi! Mi wani toon bakaman fi yu, fu go anga yu na ala peesi. Ma gaantangi! Gi mi piimisi fu go gi den sama fu mi adyosi fosi, baa?” ");
INSERT INTO djkNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ne Masaa Jesesi piki en taki: “Wan sama di e du wan wooko, ma ai du en anga tu ati, á de na a peesi fu yeepi sama, fu kon a ini a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ne wan dei, ne Masaa Jesesi kai seibintenti a tu taa bakaman fi en kon ne en. Ne a sende den tu tu, tu tu, taki: “U go a den kondee kondee anga den foto. Da moo lati, miseefi o go a den kondee anda tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ne a taigi den taki: “Sama de ipi a den peesi peesi di wani yee a Bun Nyunsu fu Masaa Gadu, fu den du san ai taki. Ma wookoman ná ipi sai fu go paati en. U begi Masaa Gadu di de basi fu a wooko, fu a puu moo wookoman sende go a ini a wooko fi en. ");
INSERT INTO djkNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","U go! Mi e sende u go enke te mi be o sende sikapu go a mindii fu takuu meti. ");
INSERT INTO djkNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ma te u e go, u á mu tyai moni, u á mu tyai saka. Da anga den susu di de a u futu de namo u mu go. U á mu tyai taawan moo enke di u wei de. U á mu tapu a pasi e taki gaan langa bee toli anga sama. ");
INSERT INTO djkNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Da ala osu ini di u o go, da u mu begi gi den sama taki: ‘Meke Masaa Gadu de anga den.’ ");
INSERT INTO djkNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Da efu wan sama de ape di fiti fu kisi a bun di i begi gi en ya, da a bun o tan a ini a osu de. Ma efu a sama de á fiti fu kisi a bun ya, da a bun fi yu o daai kon a yu baka. ");
INSERT INTO djkNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ma te den teke u oli a wan osu, da na a osu de namo u mu tan. U á mu komoto fu awan osu go na a taawan. Te den gi u sani fu nyan, da u mu nyan. U á mu meke sen kisi u. Bika wan wookoman fiti fu kisi a paiman fu a wooko di ai du. ");
INSERT INTO djkNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Da te u doo wan kondee, ne den kai u kon, da na san di den poti gi u fu nyan, na dati u mu nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","U deesi den sikiman di de ape. Da u taigi den sama taki: ‘A Nyun Tii fu Masaa Gadu kon koosube fu u.’ ");
INSERT INTO djkNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma, efu u doo a wan kondee, ne den sama á wani yee u taki, da u mu go taampu a mindii ganda, da u bali taigi den taki: ");
INSERT INTO djkNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘U luku ya! Disi na a santi fu a kondee, wi e sibi puu a u futu towe fika ya gi u. Da na wan maiki fu soi taki, u be taigi u a Bun Nyunsu. Da di Masaa Gadu o sitaafu u, da a ná wi fowtu. Bika u be taigi u fu a Nyun Tii fi en, ma u á be wani aliki wi. Kwolon! U e gwe, ye!’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ne Masaa Jesesi taigi den bakaman fi en go doo taki: “U mu de sabi sabi taki, na a gaanbigi dei di Masaa Gadu o kuutu goontapu, da a sitaafu di Masaa Gadu o sitaafu den sama fu a kondee de, o ogii moo enke a sitaafu di a be sitaafu a kondee di den e kai Sowdom.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ma heelu fu den sama fu Kolasin anga Betisaida Foto! Bika efu den sama fu den takuu foto di den e kai Sidon anga Tilosi be si den gaan foondoo sani di mi du a u mindii ya, da gaandiwe den be o daai den libi. Bika na buduufu buduufu den be o de, fu a takuu libi fu den. Da den be o wei boko koosi a sikin, go sidon a doti e iti asisi a den sikin. ");
INSERT INTO djkNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A dati, meke a dei di Masaa Gadu o kuutu goontapu, Kolasin anga Betisaida Foto o kisi moo gaan sitaafu moo den. ");
INSERT INTO djkNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Da u fu Kafalnayemu Foto. San u e denki? U denki taki, a hei fu u o tyai u go a Masaa Gadu? Nono! A ná o tyai u go a Masaa Gadu. A didibii faya*f12* a o tyai u go.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ne a taigi den bakaman fi en taki: “Efu wan sama e teke san u e taki, da ai teke san mi e taki tu. Ma, efu wan sama nái aliki u, san u e taki, da a nái aliki mi tu. Da sama di nái aliki mi, da a nái aliki Masaa Gadu, di sende mi kon tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ne baka wan pisiten, ne den seibintenti a tu bakaman fu Masaa Jesesi di a be sende gwe, daai kon ne en baka anga gaan piisii. Den taigi en taki: “Masaa! Di u teke a nen fi yu kaasi den takuu jeje, da den e du san u taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ne Masaa Jesesi piki den taki: “Miseefi be si fa didibii makiti booko langa ten kaba. Mi si a komoto a tapu nyaw kai kon a doti, enke te donduu e koti faya. ");
INSERT INTO djkNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","We, mi gi u makiti a tapu fu ala wooko fu a feyanti. Soseefi mi gi u makiti a tapu fu sineki anga kukutu tee anga ala taa sani di a feyanti o wani sende kon, fu du ogii anga u. Da fu tuu, ná wan o poi du u ogii. ");
INSERT INTO djkNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ma u á mu piisii, fu di den takuu jeje e du san u taki. Nono! Ma u mu piisii fu di u sabi taki, u nen sikiifi a Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ne a Apaiti Jeje fu Masaa Gadu fuu Masaa Jesesi ati anga gaan piisii. Ne a taki: “Mi Tata! Masaa fu tapu anga goontapu. Mi e gi yu gaantangi, fu di yu kibii den sani ya, gi den koniman anga den leliman fu a goontapu ya, te den á poi sabi den. Ma i meke den mofina sama ya kon sabi den. Ai baa, mi Tata! Gaantangi fi i. Bika na so i si taki a bun.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ne Masaa Jesesi taigi den sama taki: “Mi Tata poti ala sani a ini mi ana. Da ná wan sama kaba sabi a Pikin, boiti a Tata. Soseefi ná wan sama sabi a Tata, boiti a Pikin anga den sama di a Pikin wani meke kon sabi en.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne Masaa Jesesi daai luku den bakaman fi en, ne a taigi den taki: “Seigi fu u, fu den sani di u e si anga den di u e yee ya. ");
INSERT INTO djkNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Bika somen apaiti takiman fu Masaa Gadu anga kownu fu fesiten be angii fu si den sani di u e si ya. Ma den á be si den. Soseefi den be angii fu yee san u e yee ya, ma den á be yee den.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ma namo, da wan dei, ne wan leliman fu Dyuweiti go a Masaa Jesesi go tesi en. Ne a akisi en taki: “Mesiti, oo! San mi mu du, fu mi fende a libi, fu ten fu ten a Masaa Gadu?” ");
INSERT INTO djkNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ne Masaa Jesesi akisi en taki: “San sikiifi a Masaa Gadu Buku? San yu e leisi ne en?” ");
INSERT INTO djkNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ne a piki en taki: “We, a sikiifi taki: ‘I mu lobi Masaa Gadu anga yu hiihii ati anga i hii fii anga hii i taanga anga hii i fusutan. Da i mu lobi taawan a i se leti enke fa i lobi iseefi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ne Masaa Jesesi piki en taki: “Na so a de! I piki bun. Libi pilisisi enke fa i taki de, da yu o fende a libi fu tego.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","We, di a man si taki, Masaa Jesesi á piki en enke fa a be wani, ne a daai, ne a akisi Masaa Jesesi baka taki: “Ma sama na den taa sama, di mi mu lobi enke miseefi?” ");
INSERT INTO djkNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ne Masaa Jesesi gi en wan ageisi toli taki: “Wan man be komoto a Jelusalem Foto e saka go a Jelikow Foto. Da di ai gwe te wan pisi, ne fufuuman feti anga en. Ne den fonmi en te, a fon, teke den koosi ne en sikin anga ala san a be tyai. Ne den fika en de swaki a sikin pasi. Ne den gwe fu den. ");
INSERT INTO djkNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ne te wan pisi, ne wan apaiti begiman fu keliki e kon pasa. Ma di a si a man a doti, ne a koti lontu, waka pasa fi en a taase. ");
INSERT INTO djkNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Te wan pisi baka, ne wan man fu Leifi Lo, di e wooko a ini a Mama Keliki e kon pasa. Ne di a si a man, ne a luku en dunn, ne enseefi koti lontu waka pasa gwe fi en. ");
INSERT INTO djkNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ne bakadati, ne wan Samaliya sama e kon pasa de tu. Ne di a si a man a doti de, ne gaan tyali fu a man kisi en te, ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ne a go, ne a bendi kiin den soo fi en, lobi deesi gi den, tei den moi, te a kaba. Ne a opo en poti na a buliki fi en tapu, ne a lei anga en, te a wan lanti osu. Ne a seeka en baka, te a kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ne a taa dei, ne a teke moni, ne a gi a man di abi a lanti osu taki: ‘Luku ya! Gaantangi! Luku a man ya bun gi mi, baa? Da efu a moni á sai, da te mi e daai, da mi sa pai yu doo.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","We, ne Masaa Jesesi akisi a man taki: “On di fu den dii man ya, i denki libi anga en enke a taawan ne en se, di a mu lobi enke enseefi?” ");
INSERT INTO djkNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ne a man taki: “Na a man di be abi tyali ati fi en!” Ne Masaa Jesesi piki en taki: “Weeno! Na so a de enke fa i piki de tuu. Go, da i libi enke fa a man ya libi.” ");
INSERT INTO djkNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Da, di Masaa Jesesi anga den bakaman fi en de a pasi e go a Jelusalem, ne den doo wan kondee pe wan uman den kai Malita e tan. Ne a kai Masaa Jesesi anga den bakaman fi en, fu den go ne en osu. Ne den go. ");
INSERT INTO djkNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Da Malita be abi wan sisa den e kai Maliya. Da fanafu di Masaa Jesesi go a ini a osu, ne Maliya go sidon te ne en ini, e aliki san ai taki. ");
INSERT INTO djkNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Malita be e booko ede e seeka nyanyan gi Masaa Jesesi anga den bakaman fi en. Ne di Malita wooko te wan pisi, ne a á poi teke en moo. Bika a wooko kon hebi gi en. Ne a go a Masaa Jesesi taki: “Masaa! Yu nái si, no? Fu senten di i kon ya, ne Maliya go sidon fika a wooko gi mi wawan. Yu á poi sende en fu a kon yeepi mi, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ne Masaa Jesesi piki en taki: “Kee! Malita! Saide meke yu e booko yu ede a somen sani so? ");
INSERT INTO djkNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Na wankodo sani namo de di yu abi fanowdu. Maliya du a moo bun sani. Da mi ná o puu en ne en.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ma namo, da wan dei, da Masaa Jesesi go a wan peesi go e begi. Di a begi te a kaba, ne wan fu den bakaman fi en kon ne en taki: “Masaa! Leli u begi tu, enke fa Johanisi be leli den bakaman fi en.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ne a piki den taki: “Te u e begi, da u begi so: ‘Kee! Wi Tata! Meke ala sani sa kon lesipeki yu nen, wan apaiti fasi. Meke a Nyun Tii fi yu sa paati a hii goontapu. ");
INSERT INTO djkNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wi e begi yu, fu gi wi san wi abi fanowdu, fu nyan ibii dei baka. ");
INSERT INTO djkNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gi wi paadon fu takuudu anga ogii di wi e du a yu fesi, leti enke fa wiseefi e gi taawan di e du ogii anga wi paadon. Wi e begi yu, fu kibii wi, meke wi á kai a ini tesi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne a taigi den go doo taki: “Meke u taki, yu abi wan bun mati, ne i go ne en a mindii neti, fu go yuu dii beele. ");
INSERT INTO djkNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Da yu o go weki en, da i taigi en taki: ‘Mati, gaantangi baa! Mi kon begi i wan sani. Wan mati fu mi komoto a wan faawe peesi kon a mi. Ma mi ná abi ná wan sani fu gi en, fu a nyan.’ ");
INSERT INTO djkNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Da, meke u taki a mati fi yu piki i taki: ‘Mi ná o poi opo go teke beele gi i moo. Mi anga den pikin sooto doo go didon kaba. Da fika mi, meke mi siibi fu mi.’ Ma fu di a fuka fi i bigi, meke i o go e naki a doo, e begi en naamo. ");
INSERT INTO djkNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ma ná fu di yu anga en na mati ede, meke a o opo a doo gi yu. Ma na fu di i tan e naki a doo naamo, te a á poi fende pasi fu siibi, meke a musu opo go teke a beele di yu abi fanowdu gi yu. ");
INSERT INTO djkNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Na dati ede meke mi taigi u taki: ‘Begi, da u o kisi. U suku, da u o fende. U koko, da doo o opo gi u.’ ");
INSERT INTO djkNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bika na sama di e begi en, e kisi. A sama di e suku e fende. Soseefi sama di e koko, da doo e opo gi. ");
INSERT INTO djkNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Bika luku son fu u ya abi pikin. Da efu wan pikin fu u begi u wan fisi, u o teke wan sineki, da u gi en? ");
INSERT INTO djkNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ofu, sama fu u di de ya, o teke wan kukutu tee langa gi en pikin, te a begi en wan igi? ");
INSERT INTO djkNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","We, efu anga ala fa u de takuu ati sama seefi, ne u sabi fu gi u pikin bun so, da san na u Tata a tapu? Te u begi en, a Apaiti Jeje fi en, a ná o gi u en moo esi, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Da wan taa dei baka, ne Masaa Jesesi yaki wan takuu jeje puu a wan sama tapu. A takuu jeje ya be meke a toon babawman. Ma wanten, di Masaa Jesesi yaki en puu, ne a man e taki bun baka. Da a sani foondoo ala den sama. ");
INSERT INTO djkNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma wantu fu den sama kosi Masaa Jesesi taki: “A nái foondoo wi taki, ai yaki takuu jeje puu a sama tapu. Bika anga Belisebulu, a edeman fu den didibii ai puu den.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma namo, da wanlo sama de ape tesi en luku. Ne den taigi en taki: “Di yu na wan sama fu Masaa Gadu tuutuu, da soi u wan maiki, meke u sabi taki, Masaa Gadu de anga yu anga den sani di yu e du.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma Masaa Jesesi sabi san de a den baka ede. Ne a taigi den taki: “Efu den sama fu wan kownu kondee opo e feti anga enseefi, da a kondee de, na booko a o booko. Na soseefi, a de anga wan osu pe den sama e libi fanya fanya, feyanti fasi anga denseefi. A osu sama de musu booko saka kaba a soso. ");
INSERT INTO djkNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Da u taki, mi e wooko anga didibii, fu puu takuu jeje a sama tapu. We, da na feti didibii e feti anga enseefi, fu booko a hii makiti anga a hii kondee fi enseefi, di ai tii. ");
INSERT INTO djkNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","We, di u taki, anga a basi fu didibii mi e puu den takuu jeje, we den sama fu u, no? Anga san den e puu den? Bika denseefi e puu takuu jeje a sama tapu. U go akisi den luku. Da u sa si taki, den sama fu useefi o soi u taki, u ná abi leti. ");
INSERT INTO djkNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bika anga a taanga fu Masaa Gadu mi e puu den takuu jeje a sama tapu. Den sani di mi e du anga a taanga fu Masaa Gadu ya, de enke wan maiki fu soi u taki, a Nyun Tii fu Masaa Gadu doo a u mindii now.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ne a taki go doo taki: “Te wan taanga man abi bunbun feti sani fu oli waki ne en osu, da a ná abi fu feele ná wan sani. Bika ná wan sama o poi kon fufuu sani a ini en osu. ");
INSERT INTO djkNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma, te wan moo taanga man di abi moo bun feti sani kon feti anga en, da a o fonmi en teke ala den feti sani fi en, puu ne en ana. Da a teke den gudu fi en go paati gi taa sama.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ne Masaa Jesesi taigi den go doo taki: “A sama di á de anga mi a wanse, da a sama de e feti fu booko mi saka. Da sama di nái wooko makandii anga mi, fu tyai sama kon a mi, sowan sama e yaki den sama paati, puu a mi.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ne a taigi den taki: “Te wan takuu jeje komoto a wan sama tapu, da ai waka e lontu e suku peesi na ala den sabana ini, fu boo. Ma a nái poi fende peesi fu boo. Da, te a á poi fende a peesi fu boo, da ai pakisei taki: ‘Meke mi daai go tan na a peesi pe mi be komoto baka.’ ");
INSERT INTO djkNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Da te a daai kon baka, a osu pe a be komoto de leigi leigi. A de kiinkiin sibisibi moi silli. ");
INSERT INTO djkNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Da ai gwe baka, da a go kai seibin taa takuu jeje, di ogii moo enseefi. Da den e kon na a sama tapu. Da a libi fu sowan sama o moo ogii bakaten, moo enke fa a be de a fesi kaba.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ma, namo di Masaa Jesesi e taki, ne wan uman di be de a ini den sama ini de, bali taki: “Oho! Masaa Gadu seigi a uman di meke yu, fu di Masaa Gadu fende taki, na a uman ya be mu meke yu.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ne Masaa Jesesi piki en taki: “Uman! I si fa u de ya? Den sama di e aliki Masaa Gadu wowtu e du san a taki, fende moo gaan seigi, moo enke a uman di meke mi.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Namo somen somen sama e kon a Masaa Jesesi, ne a taki: “Saide meke den sama fu a ten ya abi takuu ati so du? Den e feti fu si maiki fu Gadu. Ma den ná o si ná wan taa maiki moo enke a maiki fu a apaiti takiman fu Masaa Gadu, di den be e kai Jowna. ");
INSERT INTO djkNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bika leti enke fa Jowna be de enke wan maiki gi den sama fu Ninifei, na letiso a Manpikin di saka kon toon libisama ya, de enke wan maiki gi den sama fu a ten ya tu. ");
INSERT INTO djkNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“A uman kownu fu a kondee di den e kai Seba, na a se fu san dongo, o opo na a gaan kuutu dei, di Masaa Gadu o kuutu sama, fu kuutu den sama fu a ten ya. Bika en dati be komoto langa langa te na a taase fu goontapu fu kon a Salomo, fu kon yee den koni fi en. Ma wan Sama de a u mindii ya, di hei moo Salomo seefi, ma toku, u nái teke en taki. ");
INSERT INTO djkNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Soseefi ala den sama fu Ninifei o opo, da den o kuutu den sama fu a ten ya. Bika den sama fu Ninifei be yee a wowtu fu Masaa Gadu di Jowna be gi den. Ne den teke en, ne den daai libi wanten. Ma wan Sama de a u mindii ya, di hei moo Jowna, ma toku, u nái teke en taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ne a taigi den taki: “Ná wan sama e leti wan lampu, da a poti en a sani ondoo, efu a teke sani tapu en. Nono! A o poti en a wan hei peesi, fu ala sama di o kon a ini a osu sa si sani bun anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Da na so a de anga wi libisama tu. U ain, na a lampu fu u sikin. Efu u ain de bunbun, ne u opo den fu si sani, da u o si kiinkiin anga den, fu u sabi san u e du. Ma efu u ain dunguu, da u hii sikin seefi dunguu tu. Bika, wansi u leti wan lampu poti de seefi, toku u ná o si san u e du. Da na ini dunguu u e tan. Da u ná o sabi san u e du. ");
INSERT INTO djkNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","A dati meke, u mu e koni fu u á poti u ain fu luku ogii fu u ain anga u ati dunguu. ");
INSERT INTO djkNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bika efu u hii ati kiin, sondee fu a abi wan baaka, da u sa leti kiin peesi gi taa sama, leti enke wan lampu di e leti kiin peesi gi sama.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Da Masaa Jesesi kaba taki seefi, ne wan Faliseiman kai en taki: “Masaa Jesesi, kon go nyan anga mi a mi osu, no?” Ne Masaa Jesesi go anga a Faliseiman ne en osu go nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Da di den sidon fu nyan, ne wan sani dangaa a Faliseiman. Bika a si taki Masaa Jesesi e nyan, sondee fu wasi ana na a apaiti fasi fa a Dyuweiti be e soi den, fu wasi den ana fosi den go nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Da di Masaa Jesesi si taki a sani ya dangaa a Faliseiman, ne a taigi en taki: “U Faliseiman! U e wasi u sikin namo, da u kaba, fu soi kiin a doose. Ma u ati lai anga giili anga takuudu! ");
INSERT INTO djkNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","U wisiwasi sani sondee fusutan! U e feti namo fu wasi doose fu u sikin kiin. Ma fa fu u ati? U á sabi taki, Masaa Gadu wani meke u wasi u ati kiin tu, no? ");
INSERT INTO djkNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","U feti fu wasi u ati kiin, fu u yeepi den pooti sama a sani. Da te u ati kiin so kaba, da u ná abi fu feti, fu wasi ana moo enke fa u gwenti. Bika efu u ati kiin, da ala sani fu u kiin tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ne Masaa Jesesi taki go doo taki: “Heelu fu u enke Faliseiman de! Bika u nái libi letiopu anga sama, anga u á lobi Masaa Gadu tu. Ma u e paati ala san u abi a tin pisi, da u e gi Masaa Gadu wan fu den tin pisi. Soseefi u e gi en wan pisi fu tin, fu ala u goon nyanyan enke fa a Dyuweiti taki. Da u e si enke u bun kaba. We, a ná enke fu gi Masaa Gadu wan pisi fu tin, fu ala san u abi, ná ogii. Ma dati á sai. Bika feti fu libi letiopu anga ala lobi Masaa Gadu seefi tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ne a taki moo taki: “Heelu ete wan toon, fu u enke Faliseiman! Bika te u go a keliki, da u lobi sidon a den fesiman sutuu a ini a keliki. Soseefi, te u e waka a ganda, da u e wani meke ala sama e gi u odi a sama fesi, enke u hei moo ala taa sama. ");
INSERT INTO djkNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","We, heelu fu u! Bika u de leti enke gaandi geebi, di sama e waka e pasa a den tapu, sondee fu den sabi taki, a sowan ogii tapu, den e waka e pasa de.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ne wan leliman fu Dyuweiti bali gi en taki: “We, Mesiti, oo! Fa yu e kosi den Faliseiman de, u de a ini tu?” ");
INSERT INTO djkNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ne Masaa Jesesi kosi den now taki: “Heelu fu u enke leliman fu weiti! Bika u e leli den sama Masaa Gadu weiti, da u e suku fu poti ibi a den sama neki tapu, fu den tyai. Ma useefi nái meke moiti, fu diki wan pikinso fu dati tyai seefi. ");
INSERT INTO djkNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Da heelu fu u! Bika u e seeka den geebi fu den apaiti fositen apaiti takiman fu Masaa Gadu. We, na den avo gaansama fu u be kii den. ");
INSERT INTO djkNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Da anga dati, u e soi taki, a bun gi u fa den gaansama fu u kii den fositen apaiti takiman fu Masaa Gadu. Da efu u be de a den peesi, na a seefi sani u be sa du tu. Den gaansama kii. Den pikin e seeka geebi. ");
INSERT INTO djkNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma a ná ogii. Masaa Gadu sabi fa a o du anga u. Bika Masaa Gadu be taki a fesi kaba taki, a sende a apaiti takiman anga apaiti bosikopuman kon gi u. Ma u o kii son fu den. Da taawan u o yaki gwe. ");
INSERT INTO djkNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Na fu dati ede meke, Masaa Gadu o akisi u faantiwowtu, fu ala den apaiti takiman fi en di u be kii fanafu goontapu sete. ");
INSERT INTO djkNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Fu a Abeli, a fosi sama di u kii, te go miti Sakalia, di u be kii a Mama Keliki, koosube fu a apaiti begi tafaa. U o tyai a sitaafu fu ala den fiya.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ne Masaa Jesesi taki go doo taki: “We, heelu fu u enke leliman fu weiti! San meke u abi takuudu so du? Bika u e kibii a tuutuu leli gi den sama, fu den á sa poi sabi en. Ma u seefi nái meke moiti fu du san den weiti taki. Da u e tapu pasi gi den sama di wani kon sabi den.” ");
INSERT INTO djkNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Da, di Masaa Jesesi taki den sani ya, ne den Faliseiman anga den leliman fu weiti ati teke faya. ");
INSERT INTO djkNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ne fanafu a dei de, ne den e akisi en somen sani, fu tesi en, fu a taki sani di á bun, fu den tyai en go kaagi. ");
INSERT INTO djkNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Da a yuu di Masaa Jesesi e taki de, ne onmen dunsu sama e kon ne en, te den e banda denseefi. Ma namo, ne Masaa Jesesi daai, ne a bali den bakaman fi en taki: “U mu luku bun anga a sowda fu den Faliseiman. Den e meke enke den na bunbun sama, ma na soso ogii. Mi bali u. U á libi enke den! ");
INSERT INTO djkNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bika ná wan sani sa de a kibii te, da a á kon a doo. Soseefi ná wan sani sa pasa bakabaka te, da a á kon fu sama sabi. ");
INSERT INTO djkNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Da ala san u taki a dunguu, den o yee a gaan dei. Da ala san u taigi useefi a yesi a ini kambaa, den o taampu a osu tapu bali den gi kondee.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ne Masaa Jesesi taigi den bakaman taki: “Mi mati! Mi e taigi yu tuutuu taki, yu á mu feele den sama di sa kii yu sikin namo, da bakadati den á poi du ná wan sani anga yu moo. ");
INSERT INTO djkNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ma mi o soi yu sama yu mu feele. Na Awan di abi a taanga fu kii yu, te a kaba, da a towe yu go a ini didibii faya*f13*. Tuutuu! Ne en i mu feele! ");
INSERT INTO djkNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","“Bika u luku ala den pikin foo di e fee a tapu. Den e seli feifi fu den fu tu tiisensi. Bika sama e si den enke soso sani, ma toku Masaa Gadu nái feegete ná wan fu den. We, efu Masaa Gadu nái feegete ná wan fu den pikin foo di e fee a tapu anda, da fa fu u enke libisama, di hei moo enke den pikin foo? We, Masaa Gadu sabi u, te doo onmen sii uwii de a u ede seefi, a sabi.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","We ne, di a taki so kaba, ne a taigi den taki: “Sama di sa piki a fesi fu libisama taki, a sabi a Manpikin di saka kon toon libisama ya, da enseefi sa piki baka taki, enseefi sabi en tu, a fesi fu den Basiya fu Masaa Gadu Kondee*f14*, a tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma sama di á wani piki a fesi fu libisama taki, a sabi mi, da miseefi ná o piki, a fesi fu den Basiya fu Masaa Gadu Kondee a tapu taki, mi sabi en tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ne a taki go doo taki: “Ma fu tuu, efu wan sama kosi a Manpikin di saka kon toon libisama ya, da Masaa Gadu sa gi en paadon. Ma efu wan sama e kosi a Apaiti Jeje fu Masaa Gadu, da noiti a o gi en paadon fu dati.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ne Masaa Jesesi taigi den baka taki: “Te den kisi u tyai go a kuutu a den keliki osu fu den, efu te den kisi u tyai go a den gaansama anga den gaaman fu kondee fu kuutu u, da u ati á mu piiti fu pakisei taki: ‘San u o taki?’ ");
INSERT INTO djkNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bika, te a yuu doo, da a Apaiti Jeje fu Masaa Gadu seefi o gi u san, fu taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ne a seefi yuu de, ne wan sama bali a mindii fu den somen sama de taki: “Mesiti! Mi begi i baa, gaantangi. Taigi mi baala, meke a gi mi fu mi se gudu di wi dda dede fika gi u.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ne Masaa Jesesi piki en taki: “Sama poti mi fu koti kuutu paati u gudu gi u?” ");
INSERT INTO djkNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne a taigi den sama di taampu de taki: “U mu koni bun anga useefi, fu u ná abi giili ati. U á feti fu fende sani di u ná abi fanowdu. Bika a ná gudu e meke wan sama libi langa ofu libi switi.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ne Masaa Jesesi gi den wan toli taki: “Wan guduman be koti wan goon fi en. Ne a paandi en, te a kaba. Da a goon meke nyanyan fu tyobo.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ne a man sidon, ne a pakisei taki: “San mi o du? Bika mi ná abi magisin sai fu poti a nyanyan ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ne a de te wan pisi, ne a taki: “Mi sabi kaba san mi o du. Mi o booko den pikin osu fu mi puu, da mi meke moo gaanwan fu poti a nyanyan anga a gudu fu mi. ");
INSERT INTO djkNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Da now, mi de enke fa mi wani. Mi abi nyanyan fu onmen yali. A á de fu mi wooko moo. Mi sa nyan diingi meke piisii enke fa mi wani.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ma te fu a poti pakisei, ne Masaa Gadu taigi en taki: “I lawman yu! Sama taigi i a sani de! A seefi neti ya, a libi boo fi yu sa komoto a yu gwe. Da sama yu o fika den gudu fi yu anga a somen nyanyan fi i di i seeka poti de gi?” ");
INSERT INTO djkNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ne Masaa Jesesi taigi den taki: “U si! Na so e pasa anga den sama fu a goontapu ya, di e suku fu fende gudu naamo, sondee fu feti fu libi enke fa Masaa Gadu wani, fu den fende gudu ne en anda.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ne Masaa Jesesi daai, ne a taki anga den bakaman fi en baka taki: “U á mu booko u ede taki, san u o nyan ofu san u o wei. ");
INSERT INTO djkNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bika Masaa Gadu gi wi sikin anga libi di de moo enke koosi anga nyanyan. Da efu a sikin anga a libi di Masaa Gadu gi u de moo enke koosi anga nyanyan, da u denki taki, a ná o gi u koosi fu wei anga nyanyan fu nyan? ");
INSERT INTO djkNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","We, luku den foo a tapu! Den nái koti goon paandi nyanyan. Soseefi, den ná abi kedee efu baakoto e kibii nyanyan fu nyan taa dei baka. Ma toku, den e nyan e diingi ibii dei. Bika Masaa Gadu e solugu den. We, u libisama, no? U á waiti moo den foo, no? Da Masaa Gadu sa fika u sondee koosi efu sondee nyanyan? ");
INSERT INTO djkNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sama de di sa booko en ede te, da a libi moo langa moo enke san Masaa Gadu poti gi en? ");
INSERT INTO djkNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","We, efu booko ede á poi yeepi yu a den pikin sani de, da fu saide meke yu e booko yu ede anga den gaan sani? ");
INSERT INTO djkNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“We, luku den boomiki a ini sabana, fa den moi. Den nái wooko. Soseefi den nái nai sani fu wei tu. Ma mi e taigi u taki, anga ala fa Salomo, a fositen kownu fu Islayeli Kondee be e wei moi, toku a á be wei moi kisi den boomiki ya. ");
INSERT INTO djkNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Efu Masaa Gadu wei den boomiki so moi, da san na yu di hei moo ala den boomiki ya? Bika tide yu e si den, ma tamaa den á de moo. Kee! Libisama, saide meke a biibi di u abi a Masaa Gadu swaki so du? ");
INSERT INTO djkNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","U á booko u ede anga san u o nyan ofu san u o diingi. U á mu si nyanyan anga diingi enke gaan sani. ");
INSERT INTO djkNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bika na sama di á sabi Masaa Gadu e booko den ede anga den sowtu sani de. Ma u Tata di de a tapu sabi san u abi fanowdu. ");
INSERT INTO djkNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ma suku fu de a ini a Nyun Tii fu Masaa Gadu. Da a o gi u ala san u fanowdu.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Namo a taigi den bakaman fi en go doo taki: “Mi mati! U nái ipi, ma u á mu feele. Bika a be bun gi Masaa Gadu, u Tata, fu a be teke u poti a ini a Nyun Tii fi en, fu u be sa fende a bun fi en. ");
INSERT INTO djkNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","U á mu feti fu suku gudu dyunta, poti a goontapu ya namo. Ma u seli den, da u paati a moni gi den pootiman. Na sowan fasi u sa kibii gudu a Masaa Gadu, di ná o poi kaba noiti moo, a Masaa Gadu Kondee anda. Fufuuman ná o poi go anda go fufuu den. Soseefi woon ná o nyanmi den tu. Da na Masaa Gadu i mu kibii i gudu poti. Da noiti den sa poli. ");
INSERT INTO djkNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Bika na pe i gudu de, na ape i ati o de tu!” ");
INSERT INTO djkNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ne a taigi den bakaman fi en baka taki: “U seeka useefi, de kaba kaba e luku u Masaa. U meke a faya fu u de leti leti. ");
INSERT INTO djkNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","“U mu de leti enke den futuboi di den masaa go a wan gaan fesa. Ne den de kaba kaba e luku on ten a masaa fu den o kon. Da te a masaa kon, da den sa opo doo gi en wanten. Bika den de kaba kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Seigi fu a futuboi di de kaba kaba e luku en masaa. Bika a masaa seefi o seeka tafaa, te a kaba, da a kai en fu kon sidon nyan anga en. Enseefi o koti nyanyan paati gi den dati. ");
INSERT INTO djkNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Da a o de wan seigi gi ala futuboi di de kaba kaba e luku den masaa. “Da meke u de kaba kaba e luku u Masaa tu. Efu na neti ofu na musude a o kon, a ná abi toobi. U mu de kaba kaba! ");
INSERT INTO djkNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ma u oli disi bun a ede. Wan sama di sabi taki, na so wan yuu fufuuman o kon fufuu ne en osu, o de anga ain e luku a fufuuman. A ná o meke a fufuuman booko en osu, fu fufuu en sani. ");
INSERT INTO djkNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","A moo bun, efu u de kaba kaba alaten. Bika, a Manpikin di saka kon toon libisama ya o daai kon baka, a wan yuu di libisama á poti pakisei.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Da di Masaa Jesesi taki so, te a kaba, ne Peitilisi akisi en taki: “Masaa! Den sani di yu e taigi u ya, na fu ala sama, ofu na fu u wawan?” ");
INSERT INTO djkNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ne Masaa Jesesi piki en taki: “Mi e taki fu wan futuboi di en masaa be sende, fu gi ibii taa sama a ini a osu, en pisi fu a nyanyan, na a leti yuu. ");
INSERT INTO djkNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","We, te a masaa o kon doo baka, da seigi fu a futuboi de. A masaa o pai en gaan paiman, efu a si taki: ‘Aai! A futuboi ya e wooko enke fa a fiti gi mi.’ ");
INSERT INTO djkNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Da fu tuu, mi e taigi u, a masaa de o poti a futuboi toon a basi, di e luku ala en gudu. Na so a masaa ya o du. ");
INSERT INTO djkNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ma meke u taki, a futuboi be pakisei taki: ‘Mi basi ná o kon ete.’ Da a bigin go nyan, diingi anga duunguman. Soseefi ai fon den taawan, uman anga man a ini a osu fu a masaa. ");
INSERT INTO djkNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","We, da a masaa be o kon a wan dei, anga wan yuu di a futuboi ya á poti pakisei. Bika a futuboi seefi á sabi on dei a masaa o kon baka. Da a masaa be o meke den doo a futuboi ede. Da a poti en go a pe fu sitaafu den sama di nái teke Masaa Gadu taki. ");
INSERT INTO djkNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bika, efu wan futuboi sabi san en masaa wani a mu du, ma a nái seeka fu du dati, da a sa fende wan tumisi gaan fonfon. ");
INSERT INTO djkNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","“Da a sama di e du wan sani sondee sabi, o kisi lekiti sitaafu. Ma a sama di e du sani anga sabi, da a o kisi ibi sitaafu. Efu wan sama kisi ipi wooko, fu de enke basi fu den, da den o akisi en ipi faantiwowtu tu. On moo ipi wan sama kisi, on moo bigi a faantiwowtu fi en de tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ne Masaa Jesesi taigi den taki: “A kon mi kon a goontapu, fu sutu faya gi goontapu enke fa den sama e sutu faya boon wan goon. Da a be sa moo bun gi mi, efu a faya ya be sutu kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A sitaafu di mi mu tyai fosi mi sutu a faya ya, na wan hebi sitaafu. Da a ibi gi mi tuu. ");
INSERT INTO djkNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Da san u be denki? U be denki taki, na fii fasi fu libisama libi anga denseefi, tyai kon a goontapu? Nono! Ná dati mi tyai kon. Mi kon fu paati sama anga sama. ");
INSERT INTO djkNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Fanafu now, da efu feifi sama de a ini wan osu, da den o meke toobi anga denseefi fu mi ede. Dii o de a wanse anga mi, da tu de a wan taase. Ofu tu o de a mi se, da dii de na a taase. ");
INSERT INTO djkNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wan dda anga en manpikin o poli fu mi ede. Da wan mma anga en umanpikin o poli fu mi ede. Soseefi wan mma anga a uman fi en manpikin o poli.” ");
INSERT INTO djkNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ne di Masaa Jesesi daai, ne a taki anga den somen sama di kon ne en de now taki: “Te u luku tapu, ne u si wan woluku na a se fu san opo, da u e taki alen o kon. Da ai kon tuu. ");
INSERT INTO djkNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Te a winta e wai komoto a opuse, da u e taki: ‘A san o ati.’ Da ai ati tuu. ");
INSERT INTO djkNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","U soso mofu libisama! Te u luku tapu, u e si efu alen o kai, efu san o pii. Dati u sabi bun. Ma saide meke u á wani opo u ain, fu si den maiki di e pasa leti a u fesi a goontapu a doti ya? Na si u nái si den sani ya, fu sabi on yuu ten fu goontapu u de? ");
INSERT INTO djkNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Bika u sabi, san di bun fu du anga san di á bun fu du. Da saide meke u nái luku san di de leti fu du? ");
INSERT INTO djkNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Bika efu yu anga yu feyanti abi toobi, ne i si taki a wani tyai yu go a kuutu, da i mu meke moiti fu taki fiti anga en, fosi u doo a kuutuman. Ma efu yu á du dati, da den o iti yu go a ini dunguu osu. ");
INSERT INTO djkNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Da yu ná o komoto, de fu te enke i pai a lasiti kopoo sensi di den naki lenti gi yu, fu pai.” ");
INSERT INTO djkNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ne a seefi yuu de, ne wanlo sama kon taigi Masaa Jesesi taki, den suudati fu Gaaman Pilatesi kii wan duupu Galileya sama, di be de a ini a Mama Keliki e kii wan meti, fu boon enke paiman, fu begi Masaa Gadu. Ne den towe den mokisa den buulu anga a meti di den be e kii de. ");
INSERT INTO djkNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ne Masaa Jesesi akisi den taki: “U membee taki, na fu di den sama de be e libi takuu moo ala den taa sama fu Galileya, meke den suudati kii den? ");
INSERT INTO djkNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nono! Ná dati meke a ogii de pasa anga den. Bika efu useefi á daai libi, da na letiso a sa pasa anga u tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ne a akisi den baka taki: “San u pakisei fu den tin na aitin sama di a tolen fu Silowam be booko kai kii? U membee taki na fu di den sama de be e libi takuu moo ala taa sama fu Jelusalem meke den sani de pasa anga den? ");
INSERT INTO djkNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nono! A ná fu di den ogii moo u. Mi e taigi u tuutuu. Efu u á daai libi, da na letiso useefi sa dede kaba a soso tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ne a gi den wan toli taki: “Wan yali ten, da wan sama be paandi wan sii den e kai figasii a ini en goon. Ne, di a sama de, te wan dei, ne a go na a goon fi en go suku nyanyan na a figasii bon. Ma a á fende ná wan kodo nyanyan ne en. ");
INSERT INTO djkNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ne a taigi a man di a be poti e luku a goon taki: ‘Faa a bon ya towe. Bika na fu soso a taampu a ini a goon ya! Na dii yali langa kaba di mi e kon e suku nyanyan na a bon ya, sondee fu fende wan kodo.’ ");
INSERT INTO djkNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ne a man di e luku a goon taki: ‘Basi! Meke u fika en wan yali ete, baa? Mi o puu gotoo lontu en, da mi o poti doti gi en. ");
INSERT INTO djkNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Da kande a sa gi nyanyan. Ma efu a á meke ná wan nyanyan, da te i daai kon baka, da i sa faa en towe tuu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ne wan dei, ne Masaa Jesesi go a ini wan Dyu keliki go e leli den sama Masaa Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Da di a leli, te wan pisi, ne en ain kai anga wan uman a ini a keliki osu. A uman ya be siki te, a fika bukubuku. A á poi opo en ede luku tapu moo seefi. Na tin na aitin yali kaba, di a de anga a siki ya. Da na wan takuu sani namo, i si be siki en poti so. ");
INSERT INTO djkNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ne Masaa Jesesi kai a uman kon ne en! Ne a taigi en taki: “Uman! I kon bun fu a siki ya!” ");
INSERT INTO djkNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne a poti ana na a uman ya tapu, ne wanten a uman opo taampu tiloo enke fa a be de fosi. Ne a gafa Masaa Gadu gi en daa. ");
INSERT INTO djkNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma a á bun gi a edeman fu a Dyu keliki, fa Masaa Jesesi deesi a uman na a kina dei ya. Ne a akisi den sama taki: “A ná sigisi dei a wiki abi, fu wooko, no? Da saide meke u nái kon a wan fu den sigisi dei ya, fu suku yeepi fu u siki? U á kon a kina dei kon suku yeepi fu u siki, moo.” ");
INSERT INTO djkNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Namo Masaa Jesesi piki en taki: “I bidiigiman yu! Iseefi e wooko a kina dei. Bika ala kina dei, u e losi den kaw anga den buliki fu u tyai go diingi wataa. ");
INSERT INTO djkNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","We, a uman ya, no? Wan bakapikin fu Abalaham, di a didibii tei tin na aitin yali langa a sitaafu. Da na fu di na kina dei ede, meke a tetei di tei en á mu losi?” ");
INSERT INTO djkNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","We, di Masaa Jesesi taki so, ne sen kisi den di be e sitee anga den, te ná sipowtu. Ma den taa sama piisii te, fu den gaan foondoo sani di Masaa Jesesi e du. ");
INSERT INTO djkNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Da, ne Masaa Jesesi akisi den baka taki: “Anga san mi sa maiki a Nyun Tii fu Masaa Gadu? ");
INSERT INTO djkNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","We, a de enke wan sii den e kai mosite, di wan sama paandi ne en goon. A sii ya na wan pikintoin sii, pikinmoo ain á poi si en. Ma, te den paandi en, te a goo, da ai bigi moo ala den taa sani di den paandi a ini a goon. Den ana fi en e bigi paati, te den foo e meke nesi e teke koo a den. Da na so a Nyun Tii fu Masaa Gadu de.” ");
INSERT INTO djkNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ne a akisi den baka taki: “San moo mi sa teke maiki a Nyun Tii fu Masaa Gadu? ");
INSERT INTO djkNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","We, a de enke wan pikintoin sowda di wan uman teke iti a ini wan gaan tyaipi bolon. Da a sowda soopu ala a bolon, te doo. Na so a Nyun Tii fu Masaa Gadu de.” ");
INSERT INTO djkNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ne bakadati, ne Masaa Jesesi komoto de e go a Jelusalem. Da ai leli den sama fu den kondee kondee pe ai pasa, Masaa Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ne wan sama akisi en taki: “Masaa! Na pikinso sama namo o go a Masaa Gadu?” Ne Masaa Jesesi piki en taki: ");
INSERT INTO djkNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Feti fi i seefi sa de wan fu den sama di o doo pasa go a ini a sumaa doo mofu. Bika mi e taigi u taki, somen fu u o feti, fu pasa go a ini a pikin doo ya, ma den ná o poi. ");
INSERT INTO djkNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Da u o de ape, fu te enke a basi fu a osu kon sooto a doo. Da u o de ape na a baka doo e naki e begi taki: ‘Masaa, gaantangi! Opo a doo gi u, baa?’ Ma a basi fu a osu o piki u taki: ‘Mi á sabi u! On se u komoto kon ya?’ ");
INSERT INTO djkNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Da u o piki en taki: ‘Masaa, i sabi u! Na u anga i be e nyan e diingi. I be de a u kondee ganda e leli wi Masaa Gadu wowtu ibii yuu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Da a sa piki u taki: ‘Mi taigi u kaba taki, mi á sabi u. Mi á sabi on se u komoto kon ya. U gwe komoto ya, u takuu ati sani u! Bika u á be wani poti yesi aliki fu du san Masaa Gadu be e taigi u.’ ");
INSERT INTO djkNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Da u o de ape e kaw tifi e kee gaan kee. Bika u sa si u avo Abalaham, Isaki, Jakowbesi anga ala den apaiti takiman fu Masaa Gadu, a ini a Nyun Tii fu Masaa Gadu Kondee. Ma useefi á poi go doo a den. ");
INSERT INTO djkNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Da somen sama o komoto na ala se fu goontapu go doo a ini a Nyun Tii a Masaa Gadu Kondee. Da ala den o sidon a tafaa anda. ");
INSERT INTO djkNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Da mi e taigi u taki, a ini Masaa Gadu, somen sama di de fesiwan ya o toon bakaman. Da somen di de bakaman ya o daai toon fesiwan.” ");
INSERT INTO djkNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ma namo, da a seefi yuu de, ne wantu Faliseiman kon taigi Masaa Jesesi taki: “Gwe komoto ya esi esi! Bika Kownu Helowdesi e suku i fu kii.” ");
INSERT INTO djkNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ne Masaa Jesesi piki den taki: “U go taigi a lei mofu bidiigiman de taki: ‘Tide anga tamaa, mi o de ya ete e yaki takuu jeje puu a sama tapu. Soseefi mi e go doo, fu deesi den siki sama kon bun baka tu. Ma di fu dii dei, da mi o kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Winsi fa, mi musu fu waka wantu dei ete, fosi mi doo Jelusalem. Bika den nái kii wan apaiti takiman fu Masaa Gadu a wan taa peesi moo enke Jelusalem Foto.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ne Masaa Jesesi daai taki sani fu den sama fu Jelusalem taki: “Sama fu Jelusalem! Na den apaiti takiman fu Masaa Gadu u kii so? Oho! Den sama di Masaa Gadu sende kon fu taki sani fu Masaa Gadu, ne u naki anga siton e kii? Ma a tyali! Bika u sabi onmen toon mi kai u, fu u kon a mi, fu mi kibii u, leti enke fa wan uman foo e kai den pikin fi en kon kibii ne en mapaapi ondoo? Ma kweti! U á wani dati. Da a tyali! ");
INSERT INTO djkNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na dati meke Masaa Gadu fika a kondee gi u, fu u du enke fa u sabi. Ma mi dati, u ná o si mi moo. Mi o gwe. Ma wan ten e kon, da u o si mi baka. Da u sa bali baaya taki: ‘Seigi fu Awan di e kon a ini a nen fu Masaa!’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Da wan kina dei, ne wan fu den edeman fu den Faliseiman kai Masaa Jesesi, fu a go nyan ne en osu. Ne Masaa Jesesi go. Ma namo, di a go, da ala sama ain be de ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Da wan man be de a ini a keliki di en hii sikin be soopu. ");
INSERT INTO djkNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ne Masaa Jesesi akisi den Faliseiman de anga den leliman fu Dyuweiti taki: “San u pakisei? A bun fu u deesi wan sama a kina dei, efu u mu fika en? San a weiti fu Mosesi taki fu dati?” ");
INSERT INTO djkNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma ná wan fu den di piki en. Ne Masaa Jesesi langa ana oli a man, ne a deesi en te a kaba, ne a sende gwe. ");
INSERT INTO djkNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ne a daai, ne a akisi den baka taki: “Efu wan fu u abi wan manpikin, ne a kai go a liba, da u o fika en fu a dede, fu di na kina dei ede, efu yu o lon go puu en? Soseefi, efu wan kaw fu u kai a liba, u o fika en fu a dede, fu di na kina dei ede?” ");
INSERT INTO djkNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma ná wan fu den di sabi fa fu piki en. ");
INSERT INTO djkNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ne Masaa Jesesi luku ala den sama di kon na a fesa lontu te a kaba. Ne a si taki, sama de ape di wani sidon a wan moo hei peesi na a tafaa moo taawan. Bika den e hei denseefi. Ne a teke wan toli gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","A taki: “Den sama, oo! Te wan sama kai u fu go ne en osu a wan piisii, da te u go, da u á mu suku fu go sidon na a moo hei peesi. Bika a sa de so taki, a sama di kai yu kon na a piisii de, kai taa sama tu, di hei moo yu. ");
INSERT INTO djkNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Da a o kon, da a taigi i, fi i opo go sidon, a baka, meke a taawan opo go sidon a fesi. Da anga gaan sen fanyaa, yu o opo go sidon na a moo lagi peesi a baka anda. ");
INSERT INTO djkNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Te wan sama kai yu a wan fesa, da te i go, da sidon na a moo lagi peesi. Da te a sama si taki, pe i sidon de á fiti yu, da a sa kai yu taki: ‘Mi mati! Ná sidon faawe so. Kon sidon a mi dise.’ Da, te yu o opo, fu go sidon na a hei peesi de, da ala sama o si taki, i na wan hei sama tuu. ");
INSERT INTO djkNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bika a sama di e opo enseefi, sa booko saka. Ma a sama di saka enseefi den sa opo en.” ");
INSERT INTO djkNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ne Masaa Jesesi taigi a sama, di be kai en kon nyan ne en osu taki: “Te yu o kai sama fu kon nyan a yu osu moo, yu á mu kai den bun mati fi yu anga den baala fi i anga den famii fi i, efuso den guduman di e tan lontu yu wawan. Bika den sama ya sa du yu bun baka. ");
INSERT INTO djkNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ma pe fu dati, da kai den pootiman anga den malengiiman anga den beendi ain wan anga den lanman meke den kon nyan anga yu. ");
INSERT INTO djkNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Da yu o fende seigi fi en. Bika den sowtu sama ya ná abi ná wan sani fu pai yu baka. Ma a dei, te Masaa Gadu o weki den sama di be libi bun ne en ain puu a dede, da a sa pai yu baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Da di Masaa Jesesi taki so, ne wan fu den man di be sidon anga en a tafaa taki: “Da a musu de wan seigi fu sidon anga Masaa Gadu a tafaa, a ini a Nyun Tii fi en a Masaa Gadu Kondee a tapu anda.” ");
INSERT INTO djkNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ne Masaa Jesesi piki en anga wan ageisi toli taki: “Wan sama oli wan gaan piisii wan dei. Ne a kai tyaipi sama kon na a piisii ya. ");
INSERT INTO djkNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ne di a seeka te a kaba, ne a sende wan wookoman fi en go kai den sama taki, meke den kon. Bika a yuu doo. ");
INSERT INTO djkNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ne a wookoman go, ne a kai den. Ne ala den fiya fende somen somen sani e taki, saide meke den ná o poi go. Wan fu den taki: ‘Man! Mi bai wan pisi doti, da mi mu go luku en. Taigi i basi gi mi taki, mi ná o poi kon, ye!’ ");
INSERT INTO djkNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wan taawan taigi en taki: ‘Taigi i basi taki, mi ná o poi kon. Bika mi bai tin kaw, da mi mu go wooko anga den luku.’ ");
INSERT INTO djkNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wan taawan baka taigi en taki: ‘Man, a dyonson ya mi libi anga uman. Da taigi i basi gi mi taki, mi ná o poi kon, ye!’ ");
INSERT INTO djkNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ne a wookoman daai go gi en masaa den bosikopu. Ne a basi ati boon te, a ná sipowtu. Ne a sende a wookoman fi en baka taki: ‘Go esi esi, na ala den bakabini peesi fu a foto, da kai ala den pootiman anga malengiiman anga den lanman anga den beendiman fu den kon nyan anga mi.’ ");
INSERT INTO djkNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ne a wookoman go te a kon, ne a taigi a basi taki: ‘Basi den sama kon kaba, ma san mi si, da peesi fika ete.’ ");
INSERT INTO djkNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ne a masaa piki en taki: ‘A bun! Go baka a den gaan paandasi anga den pikin kondee, da du moiti fu fende sama tyai kon moo. Bika a osu fu mi mu fuu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mi e taigi u taki: ‘Ná wan fu den fosi sama di mi be kai, mofu sa tesi a nyanyan fu mi ya.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ma namo, da wan dei, Masaa Jesesi be e go a wan peesi. Da somen sama be kon ne en. Ne den waka, te wan pisi, ne a daai luku den. ");
INSERT INTO djkNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ne a taigi den taki: “Efu wan sama wani de wan bakaman fu mi, da a mu lobi mi moo en mma anga en dda, anga en pikin anga den baala anga sisa fi en. Soseefi a mu lobi mi moo en eigi libi seefi. Efu a á du dati, da a ná o poi de wan bakaman fu mi. ");
INSERT INTO djkNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Efu wan sama wani toon bakaman fu mi, da a á mu teli enseefi moo. Da a mu de kaba kaba fu tyai den pina anga sitaafu di o kon ne en tapu fu mi ede. Awinsi a o dede seefi, toku a mu oli doo. A á mu daai baka. ");
INSERT INTO djkNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Bika on di fu u de ya di e go sete wan osu, sondee fu a sidon pakisei bun fosi luku onmen moni a osu o teke? A mu sabi fosi efu a abi moni sai fu pai fu ala den sani. ");
INSERT INTO djkNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Efu a á du dati, da na den ponsu wawan a o beli, da a kaba. Da a á poi go moo faawe. Da den sama o lafu en, te a lafu. Da den o taki: ‘Luku de, a man de sete a osu, ma a fika afupasi, bika a ná abi moni sai.’ ");
INSERT INTO djkNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Da soseefi, efu wan kownu di abi tin dunsu suudati, wani go feti anga wan taa kownu di abi twenti dunsu suudati, da a o sidon pakisei bun fosi efu a sa feti anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma, te a sidon pakisei te a kaba, ne a si taki a á poi feti anga a kownu fu den twenti dunsu suudati, da a o puu man sende go a fesi go begi a taa kownu meke den koo a toobi fosi den bigin feti. ");
INSERT INTO djkNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Da na soseefi ibii wan fu u mu sidon pakisei bun fosi efu u sa fika ala den sani di u abi fu kon waka a mi baka. Da efu u á poi fika den, da u ná o poi toon bakaman fu mi. ");
INSERT INTO djkNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“We, bika u luku. Sawtu na wan bun sani. Ma efu a lasi en kaakiti, da san a bun fu du moo? Na fu teke, da u towe a dyiko. ");
INSERT INTO djkNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Da fa i si yu o towe en a dyiko de seefi, da a ná a doti fu a dyiko seefi a o poi fatu, fu goo sani. A ná abi ná wankodo yeepi moo. Da fa mi taki anga u ya, u pakisei bun fu u sa fusutan en bunbun.” ");
INSERT INTO djkNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ma namo, wan dei, ne den sama di e piki lantimoni anga den sama di be abi polinen a kondee go aliki Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ne den Faliseiman anga den leliman fu Dyuweiti si Masaa Jesesi e hulu anga den takuu libi sowtu sama de. Ne den teke Masaa Jesesi fu ogii. Den taki: “A man ya na wan bunbun sama tan so? Ne fa a waka ai hulu den takuu libi sowtu sama de? Son toon seefi a nái sen fu nyan anga den. Da na wan bunbun sama tan so?” ");
INSERT INTO djkNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ne di Masaa Jesesi sabi taki, na so den e kuutu en, ne a gi den wan ageisi toli fu soi den saide meke ai du dati. A taki: ");
INSERT INTO djkNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“U aliki mi bun! Meke u taki wan fu u abi wan ondoo sikapu. Ne i tyai den go poti a sabana fu den nyan. Ne wan fu den komoto a den taawan mindii go lasi, san yu o du? Yu ná o seeka den taa neigintenti a neigin te a kaba, da i go suku awan kodo di lasi fu te i fende en, no? ");
INSERT INTO djkNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Da, te i fende en kaba, da yu o diki en poti a sikoo anga gaan piisii, da i go a kondee. Da yu o kai den mati fi yu anga den sama di e tan lontu yu, da i taigi den taki: ‘U meke piisii anga mi! Bika wan sikapu fu mi be lasi, ma mi fende en baka.’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","We, fa i si ala sama e piisii anga yu de, na soseefi piisii de a Masaa Gadu tu, te wan takuulibi sama daai libi. Da den e piisii anga en, moo enke den neigintenti a neigin, di ná abi fu daai libi moo.” ");
INSERT INTO djkNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ne Masaa Jesesi taigi den baka taki: “We soseefi, efu wan uman abi tin solufu moni, ne wan kai lasi a ini en osu. Na leti a o leti faya e sibi a hii osu, e suku fu te a fende en baka, no? ");
INSERT INTO djkNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Da, te a fende en, da a o kai den mati fi en anga ala den sama di e tan lontu en, da a taigi den taki: ‘U meke piisii anga mi. Bika wan solufu moni fu mi be lasi, ma mi fende en baka.’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","We, fa i si den sama e piisii fu di den fende awan kodo solufu moni di be lasi de, da na soseefi den Basiya fu Masaa Gadu Kondee*f15* seefi e piisii tu, te wan kodo takuulibi sama daai en libi.” ");
INSERT INTO djkNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ne Masaa Jesesi taigi den baka taki: “Wan man be de. Da a be abi tu manpikin. ");
INSERT INTO djkNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Di den de, te wan dei, ne a moo pikinwan kon ne en taki: ‘Mi dda! Mi wani i paati a gudu, da i gi mi fu mi se di mi be o fende wanten. Ne a dda paati a gudu, ne a gi den manpikin fu den se.’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Da wantu dei a baka, ne a moo pikinwan teke ala en gudu, ne a go a wan faawe kondee. Da na a pe a poli ala a moni fi en anga yayo libi. ");
INSERT INTO djkNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ne di a de te wan pisi, ne wan gaan angiiten kon na a kondee. Ne ai pina tee, na fu dede namo. Bika a á be abi ná wan enkii moni moo. A be poli ala fosi a gaan angiiten ya doo. ");
INSERT INTO djkNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ne a go suku wooko a wan sama fu a kondee. Ne a sama teke en a wooko fu ai luku den agu fi en gi en. ");
INSERT INTO djkNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Angii kii en te, a be wani den nyanyan fu den agu fu nyan. Ma dati seefi den á wani gi en. ");
INSERT INTO djkNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ne a de ape, te wan pisi, ne a kisi enseefi. Ne a taki: ‘San! Na mi kon tan so? Mi, di mi dda abi onmen tenti wookoman e gi nyanyan den e nyan, te den bee fuu. Ne na mi kon tan ya e pina a pina ya? ");
INSERT INTO djkNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","I sabi san? Mi o daai go baka a mi dda. Da mi o taigi en taki: “Mi dda. Mi du ogii anga yu anga Masaa Gadu seefi. ");
INSERT INTO djkNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Da mi á waiti moo seefi fi i oli mi enke wan manpikin fi yu. Ma gaantangi baa, teke mi enke wan wookoman fi yu namo a wooko.” ’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ne a opo, ne a daai go ne en dda baka. Ne a waka te a opo uku. A di en dda luku, ne a si wan sama, te a faawe anda e kon. Ne tyali fu a pikin kisi en. Ne a dyombo peb, lon go miti en a pasi. Ne a kisi en gwulu baasa, bosi, piisii anga en, te a bigi. ");
INSERT INTO djkNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ne a pikin taki: ‘Mi dda! Mi á waiti sai fu yu oli mi enke yu manpikin moo. Bika, mi du ogii anga yu anga Masaa Gadu seefi. Ma gaantangi! Teke mi a wooko enke wan wookoman fi yu namo, baa?’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ma, fosi a kaba taki, ne a dda bali gi den wookoman taki: ‘U esi go teke den moo waiti koosi kon wei gi en. U tyai wan linga kon wei ne en finga gi en. U tyai susu kon gi en meke a wei ne en futu. ");
INSERT INTO djkNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Da u go kii a moo fatu kaw tyai kon, meke u boli nyan meke piisii anga a manpikin fu mi ya. ");
INSERT INTO djkNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bika a manpikin fu mi ya, be lasi fu go kaba a soso, ma a daai kon baka.’ Ne den meke gaan piisii anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Da a ten de, da a gaan baala be de a ini goon e wooko. Ne di a komoto a goon e kon, ne a yee den e pee, e meke piisii e dansi. ");
INSERT INTO djkNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ne a kai wan fu den wookoman fi en dda, ne a akisi en taki: ‘San pasa ya?’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ne a piki en taki: ‘We, na a pikin baala fi yu di i si be gwe, ne en daai kon baka a osu. Ne i si a dda kii a fatu kaw e meke piisii anga en, fu di a daai kon gusontu gusontu libilibi a osu baka.’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ne di a gaan baala yee so, ne en ati boon te, a á wani go a ini osu. Ne di en dda yee so, ne a go ne en. Ne a taigi en taki: ‘Biya, kon a osu!’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ne a taki: ‘Nono! Mi ná o kon a osu. Bika luku on langa mi anga yu de ya. Ná wan dei di mi pasa i mofu, gaanengee gi yu. Ala san i sende mi, mi e du enke fa i sende mi. Mi e wooko e naki mi sikin gi yu enke sitaafuman. Ma ná wan pikin kaabita seefi di i gi mi, fu mi kii nyan meke piisii anga den mati fu mi. ");
INSERT INTO djkNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma di a manpikin fi yu di teke i gudu go poli anga wisiwasi yayo libi daai kon baka, ne i kii a fatu kaw, meke sowan gaan piisii gi en.’ ");
INSERT INTO djkNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ne a dda piki en taki: ‘We, pikin oo! Alaten mi anga yu de makandii ya. Da ala san mi abi, na fi yu. ");
INSERT INTO djkNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I baala be lasi, fu go kaba a soso. Ma now a daai kon a osu anga libi baka. Da taa fasi á de moo enke, na fu meke piisii anga en namo, da a kaba. Bika a be lasi, ma u fende en baka.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ne Masaa Jesesi gi den bakaman fi en wan taa ageisi toli. A taki: “Wan guduman be de. Da a be teke wan man a wooko poti enke basi, fu seeka ala sani, luku den gudu fi en gi en. Da di den de, te wan dei, ne sama kon taigi en taki, a man di a poti enke basi na a wooko fi en, e kii a moni fi en anga nyan. Ne a guduman taki: ‘Na tuu sani u e taigi mi ya?’ Ne den taki: ‘Iya!’ Ne a piki taki: ‘A bun!’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ne a sende kai a man di a be poti enke basi fu a wooko. Ne a taigi en taki: ‘Man! Mi yee wan sani. Mi yee taki, yu e kaba a moni fu mi anga nyan. Da taigi mi, bika mi o ondoosuku luku. Da yu ná o poi de basi fu a wooko moo. Mi o puu yu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ne a man pakisei a ini enseefi taki: ‘Oho! San mi o du di a basi o puu mi a wooko? A ganda mi o de sondee wooko. Bika fa mi de ya, mi á taanga sai fu wooko goon fu meke nyanyan gi miseefi. Fu waka a sama osu e begi, mi ná o poi, bika sen e kisi mi.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ne a de te wan pisi, ne a taki: ‘Oo! Mi sabi san mi o du, fu te a man puu mi a wooko, fu sama sa teke mi oli a den osu fu solugu, fu mi á pina dede.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ne di a pakisei so kaba, ne a sende kai ala den sama di a be yuu sani gi. Ne den kon ne en wan fu wan. Ne a akisi a fosiwan taki: ‘Man, onmen i mu pai a basi fu mi?’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ne a man piki en taki: ‘We, mi mu pai wan ondoo bali oli.’ Di a piki so, ne a man teke a pampila di a be sikiifi onmen a man mu pai, ne a piiti towe. Ne a teke wan taa pampila, ne a gi en taki: ‘Luku ya! Go sidon esi esi, da i sikiifi taki, i mu pai feifitenti bali namo.’ Ne a man teke a pampila, ne a go sidon, ne a sikiifi taki na feifitenti bali namo a mu pai. ");
INSERT INTO djkNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ne a kai a taawan di fu meke tu, ne a akisi en taki: ‘Man! Onmen i mu pai fu den sani di i be yuu?’ Ne a man piki en taki: ‘We, mi mu pai wan ondoo saka bolon.’ Ne a teke a pampila di a be sikiifi onmen a man mu pai, ne a piiti towe. Ne soseefi a gi a man wan taa pampila taki: ‘Luku ya. Ná sikiifi wan ondoo moo, ma sikiifi aititenti namo.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ne di a guduman si a fasi fa a man wooko, ne a foondoo en. Bika a wooko anga koni fu seeka en libi gi bakaten. Ne Masaa Jesesi daai, ne a taigi den taki: ‘Den sama fu a goontapu ya, di nái waka a Masaa Gadu pasi e wooko anga moo koni fu seeka denseefi gi bakaten, moo enke den sama di e waka a Masaa Gadu pasi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ne Masaa Jesesi taigi den go doo taki: “Te u e wooko anga moni, u mu wooko anga koni. U mu wooko anga en a goontapu ya, fu te a dei o doo, fu go a Masaa Gadu fu tego, fu a sa piisii anga u. ");
INSERT INTO djkNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Efu sama sa fitoow yu anga wan pikin sani di den poti a ini yu ana, da den sa fitoow yu fu poti gaan sani a ini yu ana. Ma efu sama á poi fitoow yu anga wan pikin sani di den poti a ini yu ana, da den ná o poi fitoow yu fu poti gaanwan a ini yu ana tu. ");
INSERT INTO djkNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Da efu yu á sabi wooko anga moni a goontapu ya wan bun kiinkiin fasi, da fa Masaa Gadu o fitoow yu, fu gi den tuutuu gudu fi en kondee, fu wooko anga den? ");
INSERT INTO djkNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Soseefi, efu yu á sabi seeka taa sama sani wan bun fasi, da fa Masaa Gadu o poti den waiti sani fi en a ini yu ana, fu wooko anga den a goontapu ya? ");
INSERT INTO djkNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Bika ná wan sama sa dini tu masaa makandii. Dati á kan! Ofu yu o lobi awan moo a taawan. Ofu yu o booko a wan saka, da i opo a taawan. Ma yu á poi lobi ala den tu a seefi fasi. Yu á poi waka a Masaa Gadu baka, da yu e feti a moni baka tu. Yu o lobi awan moo a taawan.” ");
INSERT INTO djkNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ne di Masaa Jesesi taki so, te a kaba, ne den Faliseiman yee. Ne den meke tyuu. Ne den e wisiwasi en, e soso en. Bika den be abi giili ati fu moni enke fa Masaa Jesesi taki de. ");
INSERT INTO djkNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ne Masaa Jesesi taigi den taki: “U á sabi, no? Na u mi e taki. Na libisama ain, ai soi enke u na bunbun sama. Ma Masaa Gadu sabi u ati, te doo. Bika a sani di u e si enke na wan gaan hei sani a libisama, da na gaan wisiwasi sani a Masaa Gadu ain.” ");
INSERT INTO djkNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ne Masaa Jesesi taigi den Faliseiman taki: “Fu sensi a ten di Masaa Gadu gi Mosesi den weiti, te doo a yuu di Johanisi a Dopuman kon a goontapu, da na den weiti fu Mosesi anga den taa apaiti takiman fi en be e soi libisama, fa fu waka a Masaa Gadu pasi. Ma fa u de nownow, da Johanisi tyai a Bun Nyunsu di e taki, fu a Nyun Tii fu Masaa Gadu. Da somen sama e feti fu kon a ini. ");
INSERT INTO djkNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ma a á de taki na bun den weiti fu Mosesi anga den di fu den apaiti takiman fu Masaa Gadu á bun moo. Nono! Bika tapu anda anga goontapu a doti ya, sa pasa gwe, sondee fu wan pikintoin sani a ini den weiti ya lasi gwe.” ");
INSERT INTO djkNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ne Masaa Jesesi taki go doo taki: “Efu wan man teke wan uman fu libi, ma a fika en go teke wan taa uman, da a booko Masaa Gadu weiti. Soseefi a man di o libi anga wan uman di en man fika, booko Masaa Gadu weiti tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ne Masaa Jesesi gi den wan ageisi toli fu tu man. A taki: “Tu man be de a wan kondee. Wan fu den man, na be wan gaan guduman di be gudu, te a gudu. A be e wei gaan dii koosi, e meke gaan piisii, e libi enke fa a wani. ");
INSERT INTO djkNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Ma a taawan di den be e kai Lasalesi na be wan gaan pinaman. A be pina te, a á be abi ná wan sani seefi. En hii sikin be de anga kaasi kaasi te, a de fonyoo. Den ganda dagu be e leki den kaasi kaasi fi en sikin. Opo seefi a á be poi opo waka komoto a pe a be e sidon. Na sama be e diki en go poti na a guduman mofu doo. Da a be e sidon e waki, efu te a guduman ya nyan, efu sakasaka be kai a doti fu a be fende nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Da na so a pinaman de te, ne a dede. Di a dede go a dedekondee, ne den Basiya fu Masaa Gadu Kondee*f16* teke en tyai go na Abalaham se*f17*. ");
INSERT INTO djkNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Da baka wan pisiten, ne a guduman seefi dede. Ne den tyai en go beli. Ne a go a didibii kondee*f18*, a ini faya pe soso pen anga gaan pina de. Da di a de a ini a gaan pina ya, te wan pisi di a opo en ain luku, ne a si Lasalesi na a Abalaham sikin se. ");
INSERT INTO djkNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Ne a bali kai Abalaham taki: ‘Abalaham, tata! Gaantangi abi tyali ati fu mi, baa? Sende Lasalesi meke a dopu en finga a ini wataa tyai kon nati mi tongo gi mi, baa? Bika mi e boon dede a ini a faya ya.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ma Abalaham piki en taki: ‘Oho, pikin! Pakisei taki i be abi i bun ten, di i be de a goontapu. Ma Lasalesi be abi wan pina mofina libi. Ma nownow ya, da a de taa fasi. I de a ini faya e bali fu pen, ma Lasalesi de a koo. A fende boo nownow. ");
INSERT INTO djkNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma boiti tu taki, i be nyan i bun a goontapu kaba, da pasi á de fu den sama fu mi dise waka kon a yu anda, ofu fu u anda waka kon a wi dise. Bika wan gaan paati de a wi fu dise anga u fu anda mindii.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ne a guduman piki en taki: ‘A bun! Ma gaantangi, mi begi yu baa, tata Abalaham! Sende Lasalesi go na a osu, mi dda, baa? ");
INSERT INTO djkNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Da, te a go, da a o si den feifi baala fu mi de. Da gaantangi baa, tata Abalaham! Meke a bali den gi mi, fu den á libi enke mi. Bika efu den libi so, da den o kon a ini a gaan takuu faya ya tu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ne Abalaham piki en taki: ‘Den sama fu goontapu anda abi den buku fu Mosesi anga den buku fu den apaiti takiman fu Masaa Gadu kaba. Meke den baala fi yu leisi san den buku de e taki. Da den libi so.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ne a guduman piki en taki: ‘Nono, tata Abalaham! Winsi den abi den buku de seefi, toku den nái leisi den. Ma efu wan sama weki komoto a dede dise go bali den, da den sa daai libi.’ ");
INSERT INTO djkNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ne Abalaham piki en taki: ‘Ná tuu! Bika efu na den buku di den abi anda, den nái leisi, fu waka enke fa den taki, da winsi wan sama weki komoto a dede dise seefi go bali den, den ná o aliki en tu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ne Masaa Jesesi taigi den bakaman fi en taki: “Den sani di e kon fu ali sama puu a Masaa Gadu pasi, ná o kaba a goontapu noiti. Ma heelu, fu den sama di e tyai den tesi ya kon miti taawan! ");
INSERT INTO djkNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A moo bun gi sowan sama efu den tei wan gaanbigi siton ne en neki, da den tyai en go iti a ini ze, moo enke pe fu a koli wan fu den mofinawan ya puu a Masaa Gadu pasi, fu go du ogii. ");
INSERT INTO djkNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mi e bali u, fu luku bun taki, a sani de á miti u. “Efi i si wan biibiwan e du ogii, da bali en, meke a daai libi, fu kaba anga a ogii di ai du. Da efu a aliki yu, ne a daai libi, da gi en paadon. ");
INSERT INTO djkNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Winsi na seibin toon a ini wan dei seefi a du ogii anga yu, ma efu a kon begi yu seibin toon paadon taki, a du ogii anga yu tuu, ma a si dati, ne a daai libi. Da gi en paadon!” ");
INSERT INTO djkNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ne den apaiti bosikopuman fu Masaa Jesesi taigi en taki: “Masaa gaantangi! Yeepi wi, meke a biibi fu wi kon moo taanga, baa.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ne Masaa Jesesi piki den taki: “We, efu u abi biibi enke wan pikintoin mosite sii, da u sa taigi a gaanbigi bon di taampu de taki, meke a opo komoto de anga ala lutu, da a go paandi enseefi a ini ze. Da a o go enke fa u taki.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ne Masaa Jesesi taigi den baka taki: “On di fu u o abi wan wookoman di go wooko a goon ofu di go luku den meti a den sabana, te a kon a osu, da a taigi en taki: ‘Kon sidon nyan?’ ");
INSERT INTO djkNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nono! Ná wan fu u. Te a wookoman kon a osu, da yu o meke a lon go seeka enseefi esi esi. Da i meke a go boli nyanyan, sete tafaa gi i fi i go nyan. Da, te yu kaba nyan fosi, da yu o meke a wookoman ya kon nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","A basi fu a wooko ná o gi a wookoman ya wan apaiti daa fu a wooko di a du. Bika ne en wooko di a be mu du, a du de. ");
INSERT INTO djkNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","We, da na so a de anga u tu. Te u wooko gi Masaa Gadu enke fa a wooko de, da a á de fu u suku fu a gi u daa. Bika na u wooko di u mu du, u du de.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ne Masaa Jesesi komoto de, ne a teke pasi e go a Jelusalem. Ma namo, da ai waka pasa na a pisi fu Galileya anga Samaliya mindii. ");
INSERT INTO djkNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ne di a waka, te a doo a wan pikin kondee, ne tin man e waka fu kon miti en. Ala den tin man ya be abi gwasi siki. Ne den taampu, te a faawe, ");
INSERT INTO djkNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ne den bali gi Masaa Jesesi taki: “Jesesi oo, Masaa! Teke tyali ati fu u! Da gaantangi yeepi u, baa.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ne di Masaa Jesesi yee den bali so, ne a daai luku den. Ne a taki: “Kee! A tyali fu den sama de, baa? Ma u sabi san? U go a den apaiti begiman na a Mama Keliki, meke den si taki u kon bun tuu.” Ne den teke pasi e go a apaiti begiman. A di den waka te wan pisi, ne den sikin kon bun kelle. A gwasi siki gwe komoto a den sikin. ");
INSERT INTO djkNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ma di wan fu den si taki, a kon bun, ne a daai baka kon a Masaa Jesesi. Ne ai bali taki: “Masaa Gadu bun! Masaa Gadu bun! A deesi mi!” ");
INSERT INTO djkNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ne a lon go kai sutu kini a Masaa Jesesi fesi, fu soi en lesipeki. Ne a gi Masaa Jesesi daa fu a bun di a du gi en. A man ya, na be wan sama fu Samaliya. ");
INSERT INTO djkNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ne Masaa Jesesi akisi en taki: “Tan! Man, a ná ala den tin man kon bun, no? Da san meke na yu wawan daai kon gi Masaa Gadu daa? Pe den taa neigin de? ");
INSERT INTO djkNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ná wan fu den daai kon gi Masaa Gadu daa, no? Na a taa kondee sama ya, di á de wan Islayeli sama, ne en wawan daai kon gi Masaa Gadu daa?” ");
INSERT INTO djkNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ne a taigi a man taki: “Man! Opo waka gwe fi i. A biibi di yu abi deesi yu kaba.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ne wan dei, ne den Faliseiman kon a Masaa Jesesi, ne den akisi en taki: “On ten a Nyun Tii fu Masaa Gadu o doo goontapu?” Ne Masaa Jesesi piki den taki: “We, u aliki! A Nyun Tii fu Masaa Gadu ná o kon enke fa u denki de. Bika, a nái kon a wan fasi fu sama sa si anga ain. ");
INSERT INTO djkNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","A ná o kon sowan fasi fi i sa taki, luku en ya ofu luku en so. Bika a Nyun Tii fu Masaa Gadu de a ini a ati fu den sama di e waka ne en baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ne a taigi den bakaman fi en taki: “Wan ten o kon, di u o angii fu si wan fu den dei, di a Manpikin di saka kon toon libisama ya, o sidon enke kownu, fu taki na ala sani tapu. Ma u ná o poi si en nownow ya ete. ");
INSERT INTO djkNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","U o yee taki, mi de ya efu mi de so, ma u á mu go luku. U á waka a den baka. ");
INSERT INTO djkNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Bika, te a dei di a Manpikin di saka kon toon libisama ya, o daai kon baka, da a o de leti enke, te tapu koti faya kiin, te doo goontapu ya. ");
INSERT INTO djkNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ma fosi en daai kon baka a goontapu so, da en o tyai sitaafu anga pen fosi. Den libisama di nái biibi a Masaa Gadu o poti en a wanse. Den ná o de a mi du seefi. ");
INSERT INTO djkNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Da, te a Manpikin di saka kon toon libisama ya o daai kon baka, da den sama sa e libi leti enke fa den sama be e libi na a ten fu Nowa. ");
INSERT INTO djkNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bika, na a ten fu Nowa, da den be e nyan e diingi. Man be e teke uman e libi, uman be e teke man e libi. Na so den be e libi, te enke a dei di Nowa go a ini a sipi tapu en doo. Ne a gaan wataa kon kii ala den fiya puu a goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ne a taigi den go doo taki: “Da na soseefi a o miti den sama fu a ten ya, leti enke fa a be miti den sama na a ten fu Lot. Na a ten fu Lot, da den sama be e nyan e diingi. Bai sani seli baka. Koti gaan goon paandi, fu meke tyaipi nyanyan. Soseefi den be e meke gaan osu. ");
INSERT INTO djkNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na so den be e libi te enke a dei di Lot komoto a Sowdom, a kondee pe a be e tan. Na a seefi dei de, faya komoto a tapu kai kon boon ala den sama fu Sowdom kii puu de. ");
INSERT INTO djkNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Da na soseefi libisama o go e du den sani fu den, te a Manpikin di kon saka toon libisama ya sa daai kon baka, fu ala libisama si.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ne a taigi den go doo taki: “Da na a ten de, da efu wan sama de ne en baikon, da a á mu lasi ten fu go a ini en osu go teke sani. Soseefi, efu wan sama de ne en goon e wooko, a á mu suku fu go a ganda, fu go teke sani ne en osu. ");
INSERT INTO djkNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","U pakisei san be pasa anga a uman fu Lot, fu san mi e taigi u ya. ");
INSERT INTO djkNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Bika sama di e feti, fu kibii en libi sa lasi en libi. Ma sama di ná abi toobi fu lasi en libi fu mi ede sa fende a libi fu tego.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ne a taki go doo taki: “Da tu sama o de a wan kama tapu, da Masaa Gadu o teke wan tyai gwe, da a o fika wan a baka. ");
INSERT INTO djkNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tu sama o de a ini wan osu e wooko, da Masaa Gadu o teke wan fu den tyai gwe, da a o fika a taawan. ");
INSERT INTO djkNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Soseefi, tu manengee o de a ini goon e wooko, da Masaa Gadu o teke wan fu den tyai gwe, ma a o fika a taawan baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","We, di Masaa Jesesi taigi den bakaman fi en ala den sani ya, ne den akisi en taki: “Masaa! On se fu goontapu a sani ya o pasa?” Ne Masaa Jesesi koti wan nongo gi den taki: “Na pe wan meti dede fika, na ape tingi foo e kon.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ne Masaa Jesesi gi den bakaman fi en wan ageisi toli, fu soi den taki, den á mu kon weli fu begi. ");
INSERT INTO djkNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","A taki: “Wan kuutu bakaa be de a wan kondee. Da a man ya be ogii te, a á be e teli Masaa Gadu. Soseefi a á be abi toobi anga libisama tu. ");
INSERT INTO djkNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Da wan pooti uman di man dede fika a ganda, be de na a kondee de tu. A uman ya be e kon na a kuutu bakaa naamo alaten, fu a kuutu wan kuutu fu gi enmi en leti. Bika wan sama be du wan ogii anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Da bigin bigin di a uman be e go ne en, da a á be wani yeepi en. Ma di a uman ya tan e go ne en naamo, ne a taki: ‘I sabi san? Anga ala fa mi nái teli Masaa Gadu, soseefi mi ná abi toobi anga libisama, toku mi o yeepi a uman ya. Bika ai kon e kaakeli mi namo. Da mi o yeepi en kuutu a kuutu, fu gi en en leti meke a sani kaba. Da mi ede sa boo. We, bika efu mi á yeepi en, da mi ede ná o abi boo. So, meke mi yeepi en.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ne Masaa Jesesi taigi den taki: “We, efu a takuu ati kuutu bakaa ya, di nái teli Masaa Gadu anga di ná abi toobi anga libisama sabi fu taki so wan sani, fu yeepi a uman ya, ");
INSERT INTO djkNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","da fa fu Masaa Gadu di abi bun ati? Efu den pikin fi en e begi en wan sani dei anga neti, a o daai daai fosi a gi den en? Nono! A ná o daai daai. ");
INSERT INTO djkNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A o kon esi esi, kon gi den san den e begi en. Ma a de wan taa sani, efu te a Manpikin di saka kon toon libisama ya o daai kon baka a goontapu, efu a o fende biibi a libisama.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ne Masaa Jesesi gi den ete wan ageisi toli fu den sama di e wisiwasi taawan, e naki boo fu ati, enke den bun moo taawan. ");
INSERT INTO djkNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","A taki: “Wan dei, ne tu man be go na a Mama Keliki fu go begi. Da wan fu den man ya na wan Faliseiman. Da a taawan na wan man di e piki lantimoni. ");
INSERT INTO djkNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ne di den doo, ne a Faliseiman waka go te a fesi, ne a kaka ede luku tapu. Ne a begi taki: ‘Masaa Gadu! Gaantangi fi i taki, mi á de enke den takuu ati sama, den fufuuman, den sama di ná abi toobi anga libisama, den sama di e teke taa sama uman ofu a man di e piki lantimoni de. ");
INSERT INTO djkNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ibii wiki, na tu toon mi e de sondee nyan fu begi yu. Da ala san mi fende mi e paati en, da mi tyai fi i se kon gi yu enke fa a weiti taki. Da na so a de.’ ");
INSERT INTO djkNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ma a man di be e piki lantimoni be fika taampu, te a bakase a ini a keliki osu. Ne a bendi fesi a doti. Bika a á be bun a Masaa Gadu ain seefi. Ne a oli en boo fu ati, ne a begi taki: ‘Kee, Masaa Gadu, mi Tata! Abi tyali ati fu mi, baa? Bika, mi na wan gaan takuu ati sama, tuu. Da gaantangi yeepi mi, baa?’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ne Masaa Jesesi taigi den taki: “U oli a sani ya bun a ede. Fa a man di e piki lantimoni e go a osu de, Masaa Gadu gi en paadon fu ala den takuudu anga ogii di a be abi. Ma Masaa Gadu fika a Faliseiman a go fi en a osu. Bika iniiwan sama di e hei enseefi, Masaa Gadu o booko en saka. Ma ibiiwan sama di e saka enseefi, da Masaa Gadu o hei en.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Da wan dei, ne den tyai den pikin kon a Masaa Jesesi. Den be wani meke Masaa Jesesi be poti ana a den tapu begi gi den. Ma den bakaman fu Masaa Jesesi bali den taki: “Nono! U daai baka. U á tyai den pikin de kon a Masaa Jesesi!” ");
INSERT INTO djkNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma, namo Masaa Jesesi si di den bakaman fi en tapu den sama, fu den á tyai den pikin kon ne en. Ne a bali den taki: “U fika den pikin, meke denseefi kon doo a mi tu. U á tapu den! Bika na sama di abi a fasi di pikinengee abi sa poi go doo a ini a Nyun Tii a Masaa Gadu Kondee. ");
INSERT INTO djkNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Da a de so taki, efu wan sama nái biibi Masaa Gadu enke fa wan pikinengee e biibi sani, da a ná o poi doo a ini a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Namo, ne bakadati, ne wan bigiman fu den Dyu kon ne en. Ne a akisi en taki: “Mi bun Masaa! San mi mu du, fu fende a libi fu tego?” ");
INSERT INTO djkNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ne Masaa Jesesi akisi en taki: “Saide meke yu e kai mi bun Masaa? I sabi san yu e taki, di yu e kai mi, bun Masaa? Bunbun ati sama á de boiti Masaa Gadu wawan. ");
INSERT INTO djkNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Da yu á sabi san i mu du fi i fende a libi fu tego ete, no? We, fi i mu fende a libi fu tego: ‘Da i á mu waka anga taa uman ofu man, boiti di fi yu! I á mu kii! Soseefi i sabi taki, i á mu fufuu! I á mu lei. I mu lesipeki i mma anga i dda!’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ne a man piki Masaa Jesesi taki: “We, Masaa! Senten mi de pikinengee mi e oli ala den weiti de, te enke tide.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ne Masaa Jesesi taigi en baka taki: “Dati na tuu! Ma wan sani de ete di i mu du. Go a osu, da seli ala san yu abi. Da paati a moni gi den pootiman. Da kon baka, fu toon wan bakaman fu mi. Da yu o fende moo gaan gudu a Masaa Gadu a tapu, a bakaten.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ne di Masaa Jesesi taigi en a sani ya, ne gaan tyali kisi a man te, a fika fu a poti ana a mindii ede bali kee. Bika a be gudu tuutuu. ");
INSERT INTO djkNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ne Masaa Jesesi daai, ne a taigi den bakaman fi en taki: “U si fa a taanga gi wan guduman fu go doo a ini a Nyun Tii fu Masaa Gadu? ");
INSERT INTO djkNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A taanga gi wan kameili*f19* fu waka pasa a wan nanai olo. Ma mi e taigi u taki, a moo taanga gi wan guduman fu saka enseefi, fu pasa go a ini a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ne di Masaa Jesesi taki so, ne den akisi en taki: “Da efu a guduman ya á poi go a Masaa Gadu, da sama o poi go seefi?” ");
INSERT INTO djkNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ne Masaa Jesesi luku den, ne a piki den taki: “Efu u luku a libisama fasi, da sani de di á poi pasa. Ma san á poi pasa libisama fasi, na dati Masaa Gadu poi du.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ne Peitilisi piki taki: “We, Masaa wi, no? U fika ala sani, fu kon waka a yu baka, e go anga yu na ala peesi!” ");
INSERT INTO djkNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ne Masaa Jesesi piki en taki: “Iniiwan sama di lobi mi te, a fika en osu, ofu en uman ofu en baala ofu en dda anga en mma ofu pikin, fu go paati a Bun Nyunsu di e taki, fu a Nyun Tii fu Masaa Gadu, ");
INSERT INTO djkNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","da, nownow, a goontapu ya, den o fende onmen tenti toon fu den sani di den fika, fu kon waka a mi baka. Soseefi bakaten, den o fende a libi fu tego a Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ne bakadati, ne Masaa Jesesi kai den twalufu bakaman fi en go a wanse, fu taigi den san o pasa anga en. Ne a taigi den taki: “U si fa wi e go a Jelusalem ya, ala den sani di apaiti takiman fu Masaa Gadu be taki fu a Manpikin di kon saka toon libisama ya o kon pasa tuu. ");
INSERT INTO djkNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Den Faliseiman anga den leliman fu Dyuweiti anga den gaansama fu Islayeli Kondee o kisi mi, da den o tyai mi go gi den doose kondee sama di e taki fu Islayeli, fu den kii. Da den sama de o poti mi a sipowtu, e lafu mi poti mi wisiwasi, e kosi mi. Soseefi den o towe wataa mofu a mi mindii fesi. ");
INSERT INTO djkNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Den o wipi mi wan mesaandi fasi fosi, da den o tyai mi go kii. Ma baka dii dei, da mi o weki baka komoto a dede.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma anga ala fa Masaa Jesesi taigi den de seefi, toku den á fusutan en pikinso seefi san a wani taki. Bika a de wan kibii toli gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ne Masaa Jesesi anga den bakaman fi en e go, te den koosube fu a kondee di den e kai Jelikow. Da wan beendiman be sidon a sikin pasi e begi moni. ");
INSERT INTO djkNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Da di a yee den somen sama e takitaki e kon, ne a akisi taki: “San na a somen takitaki di mi e yee e kon anda?” ");
INSERT INTO djkNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ne den taigi en taki: “Na Jesesi fu Nasaleti e kon pasa ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ne ai bali taki: “Masaa Jesesi! Masaa Jesesi! Gaantangi, abi tyali ati fu mi, da yeepi mi, baa! Bika, na yu na a Bakaten Manpikin fu Kownu Dafeti paansu.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Da di ai bali so, ne den sama di be e waka a fesi fu a gaan kulu bali en taki: “Man! Tapu mofu de!” Ma pe fu dati, ne ai bali moo taanga taki: “Bakaten Manpikin fu Kownu Dafeti paansu! Gaantangi, yeepi mi, baa?” ");
INSERT INTO djkNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ne di Masaa Jesesi seefi yee a bali, ne a taampu. Ne a taigi den sama taki, meke den go teke a man tyai kon gi en. Ne den go teke a man tyai kon a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ne di a kon, ne Masaa Jesesi akisi en taki: “Man! San meke yu e bali kai mi so? San i wani mi du gi yu?” Ne a man piki Masaa Jesesi taki: “Masaa! Mi wani i yeepi mi deesi mi ain, fu mi sa si sani baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ne Masaa Jesesi taigi en taki: “A bun! Si bun baka! Bika a biibi di i poti a Masaa Gadu yeepi yu.” ");
INSERT INTO djkNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","We, di Masaa Jesesi taki so, ne wanten a man ain kiin kelle, ne a bigin fu si sani bunbun baka. Ne ai waka a Masaa Jesesi baka, e gafa Masaa Gadu, fu a bun di a du gi en. Da ala den sama di si san pasa, e gafa Masaa Gadu tu. ");
INSERT INTO djkNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ne bakadati, ne Masaa Jesesi waka go miti Jelikow Foto fu waka pasa go a Jelusalem. ");
INSERT INTO djkNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","3","Da wan guduman den be e kai Sakeyosi be e tan a Jelikow Foto, a pe Masaa Jesesi be e waka pasa. Sakeyosi na be wan edeman fu den man di be e piki lantimoni. Da di Masaa Jesesi be e kon waka pasa, ne a be e feti fu a be sa si Masaa Jesesi. Ma a á be poi si en a ini den somen sama ini. Bika a be satu. ");
INSERT INTO djkNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ne a lon go a den sama fesi a pe den be o waka pasa. Ne a subi go a ini wan figasii bon fu a be sa si Masaa Jesesi, te a be o waka pasa de. ");
INSERT INTO djkNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Da di Masaa Jesesi e waka pasa, ne a opo ede luku tapu, ne a si Sakeyosi a ini a bon. Ne a kai en ne en nen taki: “Sakeyosi! Saka kon a doti wanten. Bika tide mi mu kon a yu osu.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ne wanten wanten, ne Sakeyosi saka komoto a ini a bon kon a doti. Ne a tyai Masaa Jesesi anga gaan poolo anga piisii go ne en osu. ");
INSERT INTO djkNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ma a sani di Masaa Jesesi du ya á bun gi den taa sama seefi. Den ati boon. Bika den taki Masaa Jesesi go na a takuu ati man ya osu. ");
INSERT INTO djkNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ne Sakeyosi taampu a den sama fesi, ne a taigi Masaa Jesesi taki: “Masaa! Mi sa paati mi gudu a mindii, da mi gi den pootiman fu a kondee wan se. Da efu mi be akisi wan sama lantimoni ipi tumisi, da mi sa gi en fo toon moo ipi moo enke san mi be teke ne en.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ne Masaa Jesesi piki en taki: “Masaa Gadu gi den sama fu a osu ya paadon tide, fu ala takuudu anga ogii. Mi be musu kon a Sakeyosi tide. Bika en na wan bakaten pikin fu wi avo gaansama Abalaham paansu tu. Sakeyosi be lasi pasi fu den sani di a be e du, ma fanafu tide a daai kon a Masaa Gadu baka. ");
INSERT INTO djkNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bika a Manpikin di saka kon toon libisama ya, kon fu suku den sowtu sama ya, di lasi Masaa Gadu pasi tyai kon a Masaa Gadu baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ma namo, da Masaa Jesesi be koosube anga Jelusalem Foto. Na dati meke somen sama di be e waka ne en baka fu go a Jelusalem be denki taki, a á be o langa moo fosi Masaa Gadu puu Islayeli a den feyanti fi en ondoo. Namo, ne a teke wan ageisi toli gi den, fu soi den taki, a Nyun Tii fu Masaa Gadu ná o kon enke fa den e pakisei de. ");
INSERT INTO djkNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A taki: “Wan sama fu wan bun famii be go a wan faawe kondee, fu den poti en toon kownu. Da te den poti en toon kownu kaba, da a be o daai go ne en kondee baka. ");
INSERT INTO djkNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ne fosi a gwe, ne a kai tin fu den wookoman fi en kon. Ne den kon. Ne a gi iniiwan fu den wan miliyun kolu taki: ‘U teke a moni ya. Da u wooko anga en, meke a puu wini kon moo ipi, fu te mi o daai kon baka, fu mi fende wini fi en.’ Ne a basi gi den a moni, ne a gwe. ");
INSERT INTO djkNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ma den sama fi en kondee be buuse en tee, den sende mofu gi den sama fu a taa kondee taki, den á wani meke a man toon kownu fu den kondee, fu taki fu den. ");
INSERT INTO djkNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ma toku den sama fu a taa kondee poti a man toon kownu. Ne di den poti en toon kownu, ne a daai gwe baka ne en kondee fu tii a kondee. Ne di a go, ne a sende kai den wookoman fi en di a be gi a moni fu wooko puu wini gi en. Ne den man kon. Ne kownu akisi den taki: ‘Man a moni di mi be fika gi u, fa u wooko anga en? Onmen wini u meke a tapu?’ ");
INSERT INTO djkNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ne a fosi man go a kownu, ne a taigi en taki: ‘Masaa, yu á si? Mi wooko anga a wan miliyun kolu di i be gi mi. Da a puu tin miliyun kolu wini. Da luku a moni fi i ya anga a wini di a puu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ne a masaa fi en taki: ‘Moi so! I wooko bun. Fu di i wooko sowan bun fasi anga a pikin sani ya, meke mi e gi yu moo ipi. Mi o meke i toon edeman fu tin kondee.’ ");
INSERT INTO djkNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ne di fu tu kon na a masaa. Ne a taigi a masaa taki: ‘Masaa! Luku a wan miliyun kolu fi i ya. Mi wooko anga en. Da a puu feifi miliyun kolu wini. Da luku a moni ya anga a wini di a puu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ne a masaa taki: ‘We, a bun! Fu di i wooko so moi, meke mi o poti i toon edeman fu feifi kondee.’ ");
INSERT INTO djkNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Ma a man di fu meke dii kon na a masaa, ne a gi en a moni leti enke fa a be gi enmi en baka. Ne a taigi a masaa taki: ‘Masaa! Luku a moni fi i ya. Mi ná oli en seefi puu a ini. Da a de leti enke fa i be gi mi en. Bika mi sabi taki, i libi taanga, i muliki. Yu e teke sani pe yu á poti. Da yu e koti sani a pe yu á paandi. Da den manii fi i ya mi feele, meke mi lolo en a ini wan duku poti a wanse, fu te i be kon, fu mi be sa gi yu en baka. Da yu á si, luku a moni fi i ya!’ ");
INSERT INTO djkNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ne a kownu piki en taki: ‘Oo! Na so mi libi taanga? We now, yu o si fa mi libi taanga. Yu na wan wisiwasi kaba a soso wookoman. ");
INSERT INTO djkNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Di i sabi taki mi libi taanga so, mi e teke sani a pe mi á poti. Mi e koti sani a pe mi á paandi. Da saide meke yu á be poti a moni fu mi a banku, fu te mi be kon, fu a goo kon moo ipi?’ ");
INSERT INTO djkNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ne a taigi den taa sama di taampu de taki: ‘U puu a moni ne en ana wanten gi a man di abi tin miliyun kolu kaba. Meke a fika anga soso ana!’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ne den taigi en taki: “We, Masaa! A man de abi ipi kaba, bika na tin miliyun a abi.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ne a masaa taki: “Mi sabi dati. Ma na so a de kaba. A sama di abi ipi, o fende moo ipi a tapu fu san di a abi kaba. Ma sama di ná abi, a pikinso di a abi seefi den o puu ne en ana gi taa sama, fika en anga soso ana. ");
INSERT INTO djkNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Da u tyai ala den sama di á be wani mi toon kownu fu taki gi den kon, da u kii den leti a mi fesi ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Da bakadati, ne Masaa Jesesi anga den bakaman fi en waka go doo a Jelusalem. ");
INSERT INTO djkNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Da di den doo koosube fu a Oleifi Mongo na a pisi fu Betifage anga Betaniya, ne Masaa Jesesi taigi tu bakaman fi en taki: ");
INSERT INTO djkNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“U go na a kondee a u fesi so. Da te u go, da u o si wan pikin buliki teitei. Ná wan sama sidon na a buliki ya tapu lei ete. Da u losi en tyai kon gi mi. ");
INSERT INTO djkNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Da kande sama o akisi fu saide meke u e teke en. Da u mu taigi den taki: ‘Masaa abi en fanowdu!’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ne den tu bakaman fu Masaa Jesesi go enke fa a sende den. Ne den si ala sani enke fa a be taigi den. ");
INSERT INTO djkNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ne den go fu losi en. Namo, den sama di abi a buliki, si di den e losi en. Ne den bali akisi den taki: “San e pasa? Pe u e go anga en?” ");
INSERT INTO djkNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ne den tu man piki den taki: “Nono! A ná fu wi. Ma na Masaa abi en fanowdu.” Ne den sama taki: “A bun! U sa tyai en go.” Da na so den tyai a pikin buliki go gi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne den waka, te den go doo anga en. Ne den baala koosi na a buliki mindii baka. Ne Masaa Jesesi go sidon na a buliki tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ne den bigin fu waka go a Jelusalem. Ne somen sama baala koosi na a gaan pasi mindii a doti, fu Masaa Jesesi lei pasa anga a buliki. ");
INSERT INTO djkNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Da di den doo koosube fu subi a mongo, ne den sama di be e waka ne en baka e piisii te, den e bali baaya e singi, e gafa Masaa Gadu, fu den gaan foondoo sani di den si Masaa Jesesi du a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Den e singi taki: “Seigi fu a Kownu di e kon a ini a nen fu Masaa. I poti ati switi makandii a tapu anda! I mu kisi gaandi, te doo na a moo hei peesi a tapu anda!” ");
INSERT INTO djkNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma di den Faliseiman yee fa den sama e bali e singi, e opo Masaa Jesesi, ne a sani á bun gi den. Ne den taigi Masaa Jesesi taki: “Mesiti! Bali den sama fi i, meke den tapu den mofu de.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ne Masaa Jesesi piki den taki: “U aliki mi bun! Efu den sama ya tapu den mofu, da den siton di de a sikin pasi o bali a den sama ya peesi. Bika a bali ya musu fu bali.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ne Masaa Jesesi go te a koosube fu Jelusalem. Ne a opo ede luku a kondee. Ne tyali fu a kondee kisi en te a bali kee. ");
INSERT INTO djkNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ne a taki: “Oho! Sama fu Jelusalem! Efu u be sabi san di be sa yeepi u na a yuu ya, fu u be fende boo, da u á be o libi so. Ma nownow a lati gi u kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wanlo ogii dei de a fesi e kon, di den feyanti fu u o kon lontu a kondee fu u, poti a dyali. Da u o fika na a kondee ganda de. Ná wan fu u o fende pasi komoto a ini a kondee kon a doo. ");
INSERT INTO djkNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Da na ape u o de e pina, e sitaafu fu te den kii u anga ala den pikin fu u fiya. Ala den osu di u si meke anga siton de, den o booko te a doti petee. Bika Masaa Gadu be gi u a okasi fu u teke a yeepi di a wani yeepi u, ma kweti u á teke en. U meke a pasa gwe.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ne Masaa Jesesi go a ini a Mama Keliki fu den Dyu. Ne di a go a ini, ne a yaki den sama di e seli sani poti a doo. ");
INSERT INTO djkNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ne a taigi den: “Masaa Gadu Buku sikiifi taki: ‘A osu fu Masaa Gadu mu de wan osu pe sama e kon makandii, fu begi.’ Ma san u e meke Gadu osu toon? U e meke a toon wan osu fu fufuuman.” ");
INSERT INTO djkNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Da, ala dei Masaa Jesesi be e de a ini a Mama Keliki e leli sama Masaa Gadu wowtu. Da den moo hei begiman anga den leliman fu Dyuweiti anga den gaansama fu Islayeli Kondee be e suku namo, fu fende wan fasi fu kii en puu a pasi. ");
INSERT INTO djkNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma den á sabi fa fu den du fu kii en. Bika ala sama be lobi e go ne en, go e aliki Masaa Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Da wan dei, da Masaa Jesesi be de a ini a Mama Keliki e leli den sama Masaa Gadu wowtu, e gi den a Bun Nyunsu. Ne den leliman fu Dyuweiti anga den moo hei begiman anga gaansama fu kondee kon ne en. ");
INSERT INTO djkNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ne den akisi en taki: “Fa yu e du den sani sani ya, sama sende yu seefi? Sama gi yu pasi fu du den?” ");
INSERT INTO djkNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ne Masaa Jesesi piki den taki: “A bun, mi yee san u akisi mi. Ma miseefi wani akisi u wan sani, fosi mi piki u. Da efu u piki mi, da mi sa taigi u tu, sama gi mi pasi fu du den sani di mi e du.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ne a akisi den taki: “U taigi mi! Johanisi a Dopuman, na Masaa Gadu be sende en fu dopu sama, ofu na libisama be sende en?” ");
INSERT INTO djkNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ne den daai luku denseefi san fu den piki. Ne den bende a se. Ne den taki saafi anga denseefi taki: “Efu u piki taki: ‘Na Gadu be sende en,’ da a o akisi u taki: ‘Saide meke u á be wani biibi en?’ ");
INSERT INTO djkNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma efu u piki en tu taki: ‘Na libisama be sende en,’ da den sama fu a kondee o naki wi kii anga siton. Bika den sama be teke Johanisi enke wan apaiti takiman fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","A dati meke den piki taki: “Wi á sabi sama be gi Johanisi pasi fu du den sani de.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ne Masaa Jesesi piki den taki: “We, da mi ná o taigi u tu, sama gi mi pasi fu du den sani ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ne Masaa Jesesi gi den ete wan ageisi toli taki: “Wan sama koti wan gaan goon fi en. Ne di a kaba koti en, ne a paandi en, te a kaba anga wan sii den e kai doloifi. Di a kaba paandi a goon, ne a yuu en gi taa paandi goonman. ");
INSERT INTO djkNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bika a be o gwe a taa kondee fu onmen yali. Ne a de anda te, di den doloifi lepi, ne a sende wan wookoman fi en, fu go fu den gi en afu fu a doloifi, fu a tyai kon gi en. Ma di a wookoman go, ne den man kisi en, ne den fonmi en te a fon, ne den sende en gwe anga soso ana ne en basi baka. ");
INSERT INTO djkNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ne a goonman sende wan taa wookoman go. Ma disi yaaso, na a seefi. Den fonmi en te a fon, kosi en te a kosi, ne den sende en gwe baka ne en basi anga soso ana. ");
INSERT INTO djkNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ne a masaa fu a goon sende ete wan wookoman fi en go, di fu meke dii. Ma disi moo ogii. Den fonmi en koti en hii sikin, ne den yaki en puu de sende gwe. ");
INSERT INTO djkNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ne a masaa fu a goon taki a ini enseefi taki: ‘San mi mu du moo? We, mi o sende awan kodo lobi manpikin fu mi go. Bika disi na mi manpikin, da den musu abi lesipeki fi en.’ ");
INSERT INTO djkNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ma di den si a manpikin fu a masaa e kon, ne den pakisei taki: ‘A ná a pikin fu a masaa di yuu a goon gi u e kon de, no? Ne en ai! Meke u kii en, bika te a masaa ná o de moo, da na a manpikin ya, a o fika a goon gi. Ma efu u kii en, da a goon o kon toon fu wi.’ ");
INSERT INTO djkNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ne di a manpikin kon doo, ne den kisi en, ne den iti en puu a ini a goon, ne den naki en kii.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ne Masaa Jesesi akisi den taki: “San u denki a basi fu a goon o du di a o yee taki, den kii a manpikin fi en tu? Enseefi o go luku en goon, no? Ne enseefi o go! Da a o kii ala den yuuman fu a goon, da a yuu a goon gi taa sama.” Ne den sama bali taki: “Nono! Noiti a sani ya mu pasa so!” ");
INSERT INTO djkNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ne Masaa Jesesi luku den dunn, ne a taigi den taki: “We, a o pasa so tuu. Bika a sikiifi a Masaa Gadu Buku taki: ‘Disi na a siton di meseeman be oli fu wan soso sani. Na dati daai kon toon a siton futu fu a hii osu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ne a taigi den taki: “Da a sama di o kai na a siton ya tapu, o booko en sikin. Ma efu a siton seefi kai a i tapu, da a o masi yu fini fini.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Da den hei apaiti begiman anga den leliman fu Dyuweiti fusutan kiinkiin taki, na den a poti na ageisi toli de so. Na dati meke den be e suku fu kisi en go sooto wanten. Ma den be feele den somen sama di be de ape. Na dati ede meke den fika en, ne den gwe. ");
INSERT INTO djkNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma den e waki en namo on ten a o taki wan sani, fu den go kaagi en meke a Loma lanti sooto en. Na so den sende wantu sama go ne en. Da te den go, da den mu du enke den na bunbun sama. Da den mu suku en mofu, fu a taki sani fu den fende en go kaagi en na a Loma gaaman. ");
INSERT INTO djkNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ne den go a Masaa Jesesi, ne den taigi en taki: “Mesiti! U sabi taki den sani di yu e taki na tuutuu sani. Yu na wan kiinkiin sama. Yu e soi libisama fa Masaa Gadu wani den libi. Yu ná abi toobi anga san libisama e taki. ");
INSERT INTO djkNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ma u kon fu akisi yu wan sani. Taigi u, efu a de fanowdu fu u pai a moo gaan kownu a Loma Foto, a lantimoni.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Ma Masaa Jesesi be sabi kaba taki, na suku den kon suku en mofu fu a taki sani fu den fende en kii. Ne a taigi den taki: “U tyai wan moni kon gi mi, osi?” Ne den tyai a moni kon gi en. Ne a akisi den taki: “Sama fesi anga nen de na a moni ya tapu?” Ne den piki taki: “Na a gaan kownu fu Loma fesi anga en nen de ne en tapu.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ne a taigi den taki: “We, efu na a moo gaan kownu a Loma Foto fesi, anga en nen de ne en tapu, da na fu a gaan kownu de. Da gi a gaan kownu de san de fu a gaan kownu de. Ma u mu gi Masaa Gadu san na fu Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Da a foondoo den fu a fasi fa Masaa Jesesi piki den. Den de pii. Den á sabi san fu piki en moo. A sani di den be kon fu du a puu ná wan wini gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ne bakadati, ne wantu sama fu a keliki kulu di den e kai Saduseiman kon a Masaa Jesesi. Den Saduseisama na sama di nái biibi taki te wan sama dede a sa weki baka. ");
INSERT INTO djkNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Namo den taigi Masaa Jesesi taki: “We, Mesiti oo! Masaa Gadu be meke Mosesi sikiifi wan weiti gi wi taki: ‘Efu wan man libi anga wan uman, ne a dede sondee fu meke pikin anga a uman, da a baka baala fu a man mu libi anga a uman fu meke pikin gi a baala di dede, fu en nen á sa kaba a goontapu.’ Na so a weiti fu Mosesi e leli wi. ");
INSERT INTO djkNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ma namo, da seibin baala be de. A moo gaanwan libi anga wan uman te a dede, a á meke ná wankodo pikin anga a uman. ");
INSERT INTO djkNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ne a pikin baala di waka ne en baka teke a uman libi. Ma enseefi dede, sondee fu meke wan pikin anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Da na so ala den seibin baala libi anga a uman, te ala den dede. Ná wan di meke wankodo pikin anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","33","Ne, kaba kaba fu dati, ne a uman seefi dede tu. We, Masaa, u wani akisi yu disi. ‘Te a yuu o doo fu den dedesama opo komoto a dede, da on di fu den seibin baala ya o abi a uman? Bika ala den seibin baala be libi anga en.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ne Masaa Jesesi piki den taki: “U á sabi san u e akisi. Bika na goontapu ya wawan uman anga man libi de. ");
INSERT INTO djkNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Uman anga man libi á de a Masaa Gadu Kondee anda. Bika den sama di de a Masaa Gadu a tapu anda, kon de enke den Basiya fu Masaa Gadu Kondee*f20*. Den nái dede moo. Soseefi den nái libi anga uman anga man, fu meke pikin moo, fu fika paansu a baka. Bika den sama di de anda, na Masaa Gadu pikin. Da den dede weki kaba, fu libi tego anga Masaa Gadu. Da na den sama di Masaa Gadu si taki, fiti a libi fu tego, na den a o gi a libi de. ");
INSERT INTO djkNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bika a sikiifi kiinkiin a den buku fu Mosesi taki, den dedesama o opo baka kon a libi ya. Bika, di a gi a toli fu a katuku, a taki: ‘Masaa na a Gadu fu Abalaham, Isaki anga Jakopu.’ ");
INSERT INTO djkNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Masaa Gadu a ná wan Gadu fu dedesama, ma na wan Gadu fu sama di e libi.” ");
INSERT INTO djkNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ne wan leliman fu Dyuweiti dyombo piki en taki: “Mesiti, san di i taki de na tuu! Yu abi leti!” ");
INSERT INTO djkNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ne fanafu a ten de, ne ná wan sama abi deki ati moo fu akisi en sani. ");
INSERT INTO djkNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Da, di Masaa Jesesi de a ini a Mama Keliki e leli den sama, te wan pisi, ne a akisi den sama taki: “Fa den leliman fu Dyuweiti sa leli u taki, a Kelestesi na Bakaten Manpikin fu Kownu Dafeti paansu namo, da a kaba? ");
INSERT INTO djkNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","We, na so a de tuu! Ma Dafeti seefi sikiifi wan sani a wan pisi fu Masaa Gadu Buku. A sikiifi taki: ‘Masaa Gadu taigi mi Masaa taki: “Sidon a mi leti ana se ya, ");
INSERT INTO djkNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","te enke mi meke ala den feyanti fi yu toon yu futu bangi.” ’ ");
INSERT INTO djkNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Da efu Kelestesi na wan bakaten manpikin fu Kownu Dafeti paansu namo, da i denki taki, Kownu Dafeti be o kai en bakaten pikin, ‘Masaa?’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ne Masaa Jesesi bali den bakaman fi en a den somen sama fesi taki: ");
INSERT INTO djkNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“U mu luku bun anga den leliman fu Dyuweiti. Den lobi wei gaan moi langa dii yapon e waka e lontu kondee, fu sama mu si den. Da te den e waka a den wowoyo peesi, den lobi te den sama e gi den odi anga gaan lesipeki. Te den de a ini den Dyu keliki den lobi sidon, te a fesi enke bigiman. Soseefi den e suku a moo bun peesi, te den sidon a tafaa fu nyan. Na so den e poti denseefi enke bunbun sama kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ma u mu luku bun, fu u á teke a fasi fu den fu libi. Bika den e teke ala sani fu den pooti uman di man dede fika a ganda. Te anga den osu fu den uman ya seefi den e teke. Da anga a takuu ya, den e komoto e go e begi gaan langa begi, fu sama mu si fa den bunbun kisi. We, den sama ya o kisi a moo gaan sitaafu fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ne Masaa Jesesi opo ede luku a baki di den sama e poti moni a keliki. Ne a si fa den guduman e poti moni a ini a baki. ");
INSERT INTO djkNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Di den poti te wan pisi, ne Masaa Jesesi si wan pooti uman di á be abi man moo, poti tu kopoo sensi go a ini a baki. ");
INSERT INTO djkNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ne Masaa Jesesi luku a sani te a kaba, ne a taigi den bakaman fi en taki: “U si a pooti uman de? A poti tu kopoo sensi namo go a ini a baki, ma a poti ipi moo ala den taawan di poti. ");
INSERT INTO djkNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bika den guduman poti a sakasaka di den á be abi fanowdu. Ma a uman ya poti ala san a be abi fu nyan. A á kibii ná wan kopoo sensi fi enseefi.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Da, di Masaa Jesesi anga den bakaman fi en komoto a ini a Mama Keliki, ne wantu fu den bakaman fi en taki: “Luku fa a Mama Keliki moi. Den siton di den meke en bigi. Da den tembee den siton sikin te a moi. Den wei den anga paiman di sama be pai Masaa Gadu de.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ne Masaa Jesesi piki den taki: “Weeno! Na so a de tuu. Ala den siton di u e si de, wanten o kon, di ná wan fu den siton ya o taampu a taawan tapu de moo. Ala den fiya o lulu paati paati.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ne den akisi en taki: “We, Masaa, na on ten a sani de o pasa? Da san na a maiki di wi o si taki, a yuu doo fu sowan sani pasa?” ");
INSERT INTO djkNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ne Masaa Jesesi piki den taki: “U mu luku bun anga useefi, fu sama á koli u kisi puu na a biibi. Bika somen sama o opo teke mi nen, fu e koli sama taki, na den na a Kelestesi, a Kownu di Masaa Gadu be paamisi goontapu. Da den o koli somen sama kisi. Taawan o kon taigi u taki, a ten doo kaba. Ma u á mu biibi san den o taigi u. ");
INSERT INTO djkNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Da, te u yee taki, gaan oloku feti e bali a peesi, da u á mu feele. U á mu buuya! Den sani ya musu fu pasa fosi. Ma te den sani ya e pasa, da u á mu si enke na a kaba fu goontapu doo kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bika u o yee taki, wan kondee kondee a goontapu o opo feti anga denseefi. Kownu kondee o opo feti anga denseefi. ");
INSERT INTO djkNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Da doti o seke piiti kii sama a somen pisi fu goontapu. Da gaan angiiten o kon a goontapu tu. Soseefi takuu siki o kon a goontapu kon e kii ala sowtu sama. Gaansama anga pikinengee. Somen somen gaan takuu sani o pasa na ala se fu goontapu. Te a tapu a den woluku seefi gaan maiki o de fu si. Da den sani ya o meke ala sama feele. ");
INSERT INTO djkNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma fosi ala den sani ya pasa, da den o lon a u baka, suku fu kii u. Den o kisi u tyai go a den keliki osu fu den, a kuutu. Somen fu u den o kisi sooto a dunguu osu. Soseefi den o kisi u tyai go a fesi fu den kownu anga den tiiman fu kondee, fu kuutu u fu di u e waka a mi baka. ");
INSERT INTO djkNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Da u mu teke den okasi ya, fu taigi ala sama fu saide u e biibi a Bun Nyunsu fu mi. ");
INSERT INTO djkNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma, te den kisi u fu tyai go a kuutu, da u á mu booko u ede san u o taki. ");
INSERT INTO djkNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bika miseefi o gi u den leti taki fu u taki a yuu de. Mi o gi u fusutan, fu piki ala san den o akisi u. Da te u piki den te u kaba, da ná wan fu den di o fende wan sani fu taki moo. ");
INSERT INTO djkNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Da u dda anga mma anga u baala anga u famii anga den mati fu u, o tyai o go seli gi den ogii ati sama fu kii. Da den o kii son wan fu u. ");
INSERT INTO djkNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Soseefi ala sama o abi ogii ati fu u, fu di u de fu mi ede. ");
INSERT INTO djkNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Ma u á feele. Bika sama di o tei ati fu oli doo, da ná wan uwii fi en ede sa lasi. Awinsi u dede seefi, toku u sa opo baka fende a libi fu tego a Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ne a taigi den go doo taki: “Te u si taki suudati fu taa kondee kon feti anga Jelusalem, lontu den poti a dyali, da u mu sabi taki, a ten doo fu den feti booko en kaba anga en a soso. ");
INSERT INTO djkNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Da den sama di de a Judeja mu lon go kibii a den gaan mongo mindii. Den sama di de a kondee ganda mu lon komoto de. Den sama di de a ini goon e wooko, á mu daai go a kondee moo. Den mu lon. ");
INSERT INTO djkNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bika na a yuu de, da Masaa Gadu o sitaafu Jelusalem tuutuu, enke fa a be meke den apaiti takiman fi en be taki a fesi kaba. ");
INSERT INTO djkNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","“Da a ten de o takuu seefi gi den uman di de anga bee anga den uman di de anga pikin na ana. Bika na so wan gaan ibi sitaafu o kon na a kondee. Masaa Gadu o puu en atiboon a den tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Somen fu den sama den o kii anga fetihow. Da taawan den o kisi tyai go panya na ala se fu goontapu. Da den o teke Jelusalem fu den e du anga en enke fa den wani. Da den doose kondee sama o tan a Jelusalem, fu te a ten di Masaa Gadu be poti gi den doo, da a sa puu den de.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ne Masaa Jesesi taigi den go doo taki: “Da na a yuu de, te a gaan sitaafu anga pina pasa, da den sama o si gaan maiki a tapu, a den woluku, na a san anga a mun anga den sitali. Da a ze wataa fu goontapu ya o seke e meke balibali, te ala sama fu hii goontapu o feele gaan feele. ");
INSERT INTO djkNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Da libisama o feele te, den ná o sabi fa fu du, fu di den e si dede a den fesi. Bika den á sabi san e kon a goontapu. Da tapu a den woluku o seke te, ala den sani a tapu anda seefi o seke. ");
INSERT INTO djkNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Da bakadati, da ala sama o si a Manpikin di saka kon toon libisama ya e kon a tapu, a den woluku ini anga gaan taanga anga a dyendee fasi di e beenki. ");
INSERT INTO djkNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Da, te u si den sani ya bigin pasa, da u mu de sabi sabi taki, a yuu di den o puu u a ini a gaan pina de koosube.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Namo a teke wan ageisi toli gi den taki: “U denki wan figasii bon. Te u si taki, ai piiti boomiki, da u sabi kaba taki, a o meke nyanyan dyonson. ");
INSERT INTO djkNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","We, da na soseefi, te u si den sani di mi taigi u ya bigin e pasa, da u mu sabi taki, a yuu doo fu a Nyun Tii fu Masaa Gadu kon a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Da u fusutan mi bun. Te u si den sani ya e pasa, da u mu sabi taki, a kaba fu a yuu ten fu goontapu di u e libi de koosube. Da mi e taigi u taki, a paansu fu den sama ya, ná o kaba a goontapu fosi den sani ya pasa. ");
INSERT INTO djkNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tapu a den woluku anga a goontapu pe u de ya o lasi go kaba a soso, ma mi wowtu di mi taki, ná o lasi ná wan ten.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Ne a taki gi den baka taki: “U mu de kaba kaba fu miti mi. U á mu booko u ede anga solugu fu a goontapu ya. U á mu de a yayo libi, te u feegete taki mi o kon. U á mu de ape e duungu te, da a dei kon kisi u sondee fu u poti pakisei. Da u mu luku bun! Bika a dei ya o kon. Da winsi pe i de a o kisi yu namo. ");
INSERT INTO djkNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","A dati meke, u mu e begi Masaa Gadu naamo, fu a gi u kaakiti fu u oli a biibi go doo. U mu begi en fu a yeepi u, fu pasa ala den sani di mi kai de, sondee fu u lasi a biibi fu u. Da, te u oli a biibi doo, da u sa taampu na a Manpikin di saka kon toon libisama ya, fesi.” ");
INSERT INTO djkNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Da na so Masaa Jesesi be e go na a Mama Keliki ala dei, go leli den sama Masaa Gadu wowtu. Mamanten a be e leli den, te sapaten, da a be e komoto a Jelusalem, go siibi na a Oleifi Mongo enke fa a be gwenti. ");
INSERT INTO djkNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Da te mamanten, da a be e daai kon baka, fu leli den sama a ini a Mama Keliki. ");
INSERT INTO djkNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Da a fesa fu den Islayeli di den e kai Pasika be kon koosube. Na a fesa ya, da den e nyan paata beele di meke sondee sowda. ");
INSERT INTO djkNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Da den hei apaiti begiman anga den leliman fu Dyuweiti be e suku wan koni fasi, fu kii Masaa Jesesi. Ma den á poi, bika den be e feele a foluku. ");
INSERT INTO djkNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na a seefi yuu de, ne saatan, a didibii go a ini Judasi Iskaliyotu ati ini. Judasi na be wan fu den twalufu bakaman fu Masaa Jesesi tu. ");
INSERT INTO djkNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ne a komoto, ne tilo tilo tilo, te a den hei begiman anga den edeman fu suudati di be e oli waki na a Mama Keliki. Ne a taigi den taki: “Mi sa yeepi u, fu u fende Jesesi kisi.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Da di Judasi taigi den so, ne den piisii te den taigi en taki: “Judasi! Efi i yeepi wi kisi en enke fa i taki, wi o pai yu.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Da di a yee so, ne a daai gwe baka. Da fanafu a ten de, ne ai meke moiti fu den fende Masaa Jesesi kisi sondee fu a foluku sabi. ");
INSERT INTO djkNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ne den de, te a dei doo fu den kii a pikin sikapu fu den nyan a piisii ya. ");
INSERT INTO djkNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ne Masaa Jesesi sende Peitilisi anga Johanisi taki: “U go seeka boli sani fu u nyan a Pasika.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ne den akisi Masaa Jesesi taki: “Masaa! On se i wani meke u go seeka sani?” ");
INSERT INTO djkNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ne a piki den taki: “U go a Jelusalem. Da te u go, da u o si wan man anga wan bungu wataa a pasi. Da u mu waka ne en baka, te na a osu pe ai go. Da te a go a ini a osu, da useefi mu go a ini tu. ");
INSERT INTO djkNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Da u taigi a man di abi a osu taki: ‘A Mesiti sende u, fu akisi yu on pisi a kambaa de, pe en anga den bakaman fi en sa nyan a Pasika Fesa tide neti.’ ");
INSERT INTO djkNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Da a o soi u wan gaan kambaa a sodoo. Da ala sani u abi fanowdu fu seeka sani de a ini a kambaa de kaba. Da na ape u mu go seeka sani fu u nyan a Pasika.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ne den go. Di den doo a kondee, ne den si ala sani enke fa Masaa Jesesi be taigi den. Ne den seeka sani fu a Pasika Fesa. ");
INSERT INTO djkNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ne di sapaten, ne Masaa Jesesi anga den taa apaiti bosikopuman fi en kon doo na a osu. Ne ala den go sidon a tafaa fu nyan. ");
INSERT INTO djkNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Da di den sidon e nyan, te wan pisi, ne Masaa Jesesi taigi den taki: “Fu tuutuu! Mi e taigi u taki, mi be angii fu nyan a Pasika ya anga u. Bika dyonson, a yuu o doo fu mi tyai a gaan sitaafu di de fu kon a mi tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Da mi ná o nyan sowan Pasika Fesa anga u moo ete, fu te enke ala den sani di u e membee anga a fesa ya kon pasa. A yuu de, da a Nyun Tii fu Masaa Gadu o doo goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne Masaa Jesesi teke a kan win, ne a gi Masaa Gadu daa, ne a gi den bakaman fi en taki: “U luku ya! U teke, da u diingi lontu. ");
INSERT INTO djkNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bika mi ná o diingi win moo ete, fu te enke a Nyun Tii fu Masaa Gadu doo.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne Masaa Jesesi teke a beele, ne a gi Masaa Gadu daa, moi te a kaba. Ne a booko en pisipisi, ne a gi den bakaman fi en taki: “U luku ya! Disi na mi sikin di mi e gi fu u ede. Da u du disi fu e membee mi alaten.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Da di den nyan te den kaba, ne a teke a kan win, ne a taigi den taki: “A win ya na mi buulu di sa lon gi somen sama, fu meke den kon de bun gi Masaa Gadu baka. Disi na wan nyun kuudei Masaa Gadu meke anga u, fu di mi buulu o lon gi u. Bika na a buulu fu mi o pai fu ala den somen takuudu anga ogii fu libisama.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ne Masaa Jesesi taki baka taki: “Wan fu u di sidon e nyan anga mi ya, o seli mi gi den ogii ati sama den kii. ");
INSERT INTO djkNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","We, a de so taki, na so a musu fu pasa. Bika Masaa Gadu be fiti a sani ya poti kaba, fu pasa anga a Manpikin di saka kon toon libisama ya. Ma heelu fu a sama di o seli en!” ");
INSERT INTO djkNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","We, di Masaa Jesesi taki so, ne den bakaman e akisi den na den taki: “Sama sa de ya di o seli en so?” ");
INSERT INTO djkNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ne a seefi yuu de, ne den bakaman fu Masaa Jesesi kisi wan gaan toobi anga denseefi. Den e sitee anga denseefi on di fu den na a moo heiwan a den mindii. ");
INSERT INTO djkNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ne Masaa Jesesi kon a den mindii, ne a taigi den taki: “U aliki mi bun. Den kownu fu goontapu ya, e tii den kondee, da den e dwengi libisama fu libi enke fa den wani. Da den e suku fu libisama si den hei moo taa sama. ");
INSERT INTO djkNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ma a sowtu libi de á mu de a u mindii. A sama di e saka enseefi fu dini den taawan, ne en na a moo heiwan na u mindii. ");
INSERT INTO djkNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A ini a goontapu libi, da a basi e sidon a tafaa, da ai meke en wookoman tyai nyanyan kon poti a tafaa gi en. Da a basi di sidon a tafaa, hei moo a wookoman. Ma mi de enke wan wookoman a u mindii e poti nyanyan a tafaa gi u. Na soseefi u mu libi anga useefi tu.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ne Masaa Jesesi taigi den bakaman fi en go doo taki: “Na u na den sama di be de anga mi a ini den pina anga gaan banowtu te enke now. ");
INSERT INTO djkNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","We, na fu dati ede meke mi e paamisi u taki, te mi de kownu a ini a Nyun Tii fu Masaa Gadu, da mi o gi u fu taki a libisama tapu. Bika na so mi Tata be paamisi mi taki, a be o gi mi taki a sama tapu. Da na so mi e paamisi u tu. U sa nyan diingi anga mi a tapu anda. Da useefi sa sidon anga mi a kownu sutuu, fu kuutu den twalufu lo sama fu Islayeli Kondee.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ne Masaa Jesesi kai Peitilisi, ne a taigi en taki: “Simon! Masaa Gadu gi saatan, a didibii pasi fu a tesi yu. Da a o tesi u leti enke te den e wai alisi puu buba. ");
INSERT INTO djkNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ma mi begi gi i, fi yu á fika a biibi. Bika yu o buuya fu den sani di o pasa anga mi. Ma te i daai kon baka a biibi, da i mu yeepi den taawan, fu den kon moo taanga a ini biibi.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ne Peitilisi piki en taki: “Nono, Masaa! Efu na dunguu osu yu o go, mi sa go anga yu. Winsi na dede seefi, mi sa dede anga yu.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ne Masaa Jesesi piki en taki: “Peitilisi! Fu tuu, mi e taigi yu: ‘A neti ya seefi, fosi wan kakafoo bali, da yu o lei dii toon taki, yu á sabi mi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ne Masaa Jesesi akisi den baka taki: “Di mi be sende u go a den kondee kondee, fu go paati a Bun Nyunsu, sondee fu u be tyai moni efu tasi, efu taa susu boiti di u be wei a u futu, u be pina?” Ne den piki en taki: “Nono Masaa! Wi á be pina, fu ná wan sani.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ne a taigi den baka taki: “We, u aliki. Te u o go a peesi moo, ma wan fu u abi wan saka, a mu tyai en. Efu wan fu u abi moni, a mu tyai en tu. Efu wan sama ná abi fetihow, meke a seli en impi, da a bai wan bunbun fetihow. ");
INSERT INTO djkNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bika, Masaa Gadu Buku sikiifi taki: ‘Den teli mi anga den takuu ati sama enke mi anga den na awan.’ Da ala san Masaa Gadu Buku be sikiifi fu mi, a yuu doo, fu ala den mu pasa tuu.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ne den taigi en taki: “Mesiti! Luku ya! U abi tu fetihow ya kaba.” Ne Masaa Jesesi piki den taki: “A sai. Meke u fika a toli fosi.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bakadati, ne Masaa Jesesi anga den bakaman fi en go na a mongo di den e kai Oleifi Mongo enke fa den be gwenti. ");
INSERT INTO djkNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ne di den waka te den doo na a Oleifi Mongo, ne a taigi den taki: “U begi Masaa Gadu, fu u á kai a ini den tesi fu didibii, fu a wini u.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ne a waka go pikinso moo faawe enke pe wan sama sa fiingi wan siton doo. Ne a saka kini a doti, ne a begi Masaa Gadu taki: ");
INSERT INTO djkNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Kee, mi Tata! Mi begi yu, puu a ogii di de fu miti mi ya a pasi gi mi. ");
INSERT INTO djkNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma mi Tata, a ná san mi wani mu pasa. Ma na san yu wani, na dati mu pasa.” Ne a seefi yuu de, ne wan Basiya fu Masaa Gadu Kondee*f21* saka komoto a tapu, kon gi en kaakiti. ");
INSERT INTO djkNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma sani kon ibi gi Masaa Jesesi te, ná sipowtu. Ne a bigin e begi moo taanga te, en sweti daai kon de enke buulu e doopu a doti towtow. ");
INSERT INTO djkNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Di a kaba begi, ne a daai go a den bakaman fi en baka. Da di a daai go a den, ne a si ala den fiya e siibi. Bika, gaan tyali be kisi. ");
INSERT INTO djkNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ne Masaa Jesesi taigi den taki: “Oho! Na siibi u e siibi so? U tan na ain begi, fu u á kai a ini den tesi fu didibii.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Da Masaa Jesesi á kaba taki seefi, ne den si wan gaan kulu sama e kon. Judasi, wan fu den twalufu bakaman fi en be e waka a fesi. Ne a waka kon koosube fu Masaa Jesesi, fu a bosi en. ");
INSERT INTO djkNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ne Masaa Jesesi akisi en taki: “Oho Judasi! Anga wan bosi yu e seli a Manpikin di saka kon toon libisama ya?” ");
INSERT INTO djkNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Da di den tyaipi sama kon kaba, ne den bakaman fu Masaa Jesesi akisi en taki: “Masaa Jesesi, san i wani meke u du? Bika wi abi fetihow ya!” ");
INSERT INTO djkNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A yuu di den taawan e akisi de, te fu den denki, ne wan fu den koti a letise yesi fu wan fu den wookoman fu a moo hei begiman falan. ");
INSERT INTO djkNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ne Masaa Jesesi bali den taki: “Nono! U kaba!” Ne a go oli a yesi fu a man, ne a kon bun baka. ");
INSERT INTO djkNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ne a akisi den hei apaiti begiman anga den edeman fu suudati di e waki a Mama Keliki anga den gaansama fu kondee taki: “Saide meke u kon anga fetihow anga kodya, fu kon kisi mi enke mi na wan kiiman? ");
INSERT INTO djkNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Saide meke u á be kisi mi, di mi be de ibii dei a ini a Mama Keliki e leli sama Masaa Gadu wowtu? Ma a bun! Now, da na a yuu fu u anga didibii doo. Bika ne en abi taki a u tapu nownow.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Da di den kisi Masaa Jesesi so kaba, ne den tyai en go na a osu fu a moo hei begiman. Ma, da Peitilisi be e waka te a baka e luku pe den be e tyai en go. ");
INSERT INTO djkNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ne den tyai Masaa Jesesi go te na a osu, ne den tyai en go a ini. Ma, da den be meke wan gaan faya. Da somen sama be sidon de e waan faya. Ne di Peitilisi kon a ini a dyali, ne a go sidon e waan faya anga den man ya tu. ");
INSERT INTO djkNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma namo, da wan fu den uman di e wooko a ini a osu si en de. Ne a uman ya luku en bun, ne a taki: “Hei! A man ya, a ná wan fu den man, fu a man di den tyai kon ya, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ne Peitilisi seke ede taki: “Nono! A ná mi! Mi á sabi a sama di i e taki de wan dei. Sama ne en?” ");
INSERT INTO djkNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ne den de, te wan pisi, ne wan taa sama kon de. Ne a luku Peitilisi, ne a taki: “Ma fa mi e si, a man ya, a musu de wan man fu a man di den tyai kon ya.” Ne Peitilisi piki taki: “Nono, baa! Mi á sabi a man di yu e kai de. Ná lei gi mi, mi á sabi en.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ne den de, te enke wan sani fu baka wan yuu langa so, ne wan sama opo a taki baka taki: “A man ya! A musu de wan sama fu a man Jesesi. Bika en na wan sama fu Galileya.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ne Peitilisi bali den taki: “U fika mi! Mi á sabi a man di u taki de!” Ne wanten fa i si Peitilisi kaba sitee so, ne a kakafoo bali kokoliyekee. ");
INSERT INTO djkNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ne Masaa Jesesi daai luku Peitilisi. Ne a membee wanten fa Masaa Jesesi be taigi en taki: “A neti ya seefi, fosi wan kaka foo bali, yu o lei dii toon, taki yu á sabi mi.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ne a komoto a doo, poti ana a mindii ede bali wan gaan adyumadye. ");
INSERT INTO djkNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Da, di den tyai Masaa Jesesi go a ini a osu, ne den suudati di be e oli waki ne en e poti en wisiwasi e sipowtu anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ne den teke wan koosi, ne den tei en fesi, tapu en ain. Ne den e naki en anga kofu, da den e akisi en taki: “Efi yu na wan apaiti takiman fu Masaa Gadu tuu, da taigi u sama naki yu, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ne den teke ala sowtu takuu takuu kosi e kosi en, fu te a sai den. ");
INSERT INTO djkNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Da di a mamanten fi en, ne den gaansama fu Islayeli Kondee anga den moo hei begiman anga den leliman fu Dyuweiti oli wan kuutu, fu Masaa Jesesi ede. ");
INSERT INTO djkNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ne den akisi Masaa Jesesi taki: “Man, taigi wi! Yu na a kownu di Gadu be paamisi, taki a o sende kon a goontapu?” Ne Masaa Jesesi piki den taki: “Awansi mi taigi u seefi, u ná o biibi mi. ");
INSERT INTO djkNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Soseefi, efu mi akisi u wan sani tu, u ná o piki mi. ");
INSERT INTO djkNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma a ná o langa moo, fosi a Manpikin di saka kon toon libisama ya, o sidon na a leti ana se fu Masaa Gadu, a pe a de anga a gaan taanga fi en.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ne den akisi en taki: “We, fa i taki de, da yu na a Pikin fu Masaa Gadu?” Ne a taigi den taki: “We, a de letiso enke fa i si, useefi taki de.” ");
INSERT INTO djkNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ne ala den fiya bali taki: “Oo! U ná abi ná wan sama fanowdu moo, fu tyai kaagi fi en kon gi wi. Bika useefi yee ne enseefi mofu taki, a taki en na Pikin fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ne den opo, ne den tyai Masaa Jesesi go a Gaaman Pilatesi.*f22* ");
INSERT INTO djkNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ne di den doo Gaaman Pilatesi, ne den taigi en taki: “Gaaman Pilatesi, a man ya e leli den sama fu a kondee sani fu daai den ede. A taigi u taki, u á mu pai a moo gaan kownu a Loma Foto, a lantimoni. Soseefi a taki, en na a Kelestesi, a Kownu di Masaa Gadu be paamisi, fu sende kon gi u.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ne Gaaman Pilatesi akisi en taki: “Man, taigi mi. Yu na a kownu fu den Dyu, tuu?” Ne Masaa Jesesi piki taki: “Na letiso a de, enke fa i si i taki de.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ne Gaaman Pilatesi taigi den moo hei begiman anga ala den taa sama di be kon de taki: “We, a man di u tyai kon a mi ya, mi á fende ná wan fowtu ne en, fu mi mu sitaafu en. Bika a sani di a taki de, a ná wan ogii sani.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ne ala den sama e bali taanga taki: “Ai daai den sama ede anga den sani di ai leli den. Bika a bigin a Galileya waka te, go doo Judeja. Da nownow, a de te a Jelusalem ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","We, di Gaaman Pilatesi yee den sama taki a bigin a Galileya, ne a akisi den taki: “A man ya na wan sama fu a pisiwataa fu Galileya?” ");
INSERT INTO djkNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ne den piki taki: “Iya! Gaaman Pilatesi.” Ma di a yee taki na a pisiwataa fu Helowdesi a komoto, ne a sende Masaa Jesesi go a Kownu Helowdesi, di be de a Jelusalem a yuu ten de. ");
INSERT INTO djkNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Da di Kownu Helowdesi si den tyai Masaa Jesesi kon ne en, ne a piisii te a bigi. Bika a be e yee fu den gaan foondoo sani di Masaa Jesesi e du. Ma a á be si Masaa Jesesi seefi anga en ain wan dei. A dati meke a be switi gi en so. Da a be e luku fu Masaa Jesesi du wan foondoo sani, fu a be si anga en eigi ain. ");
INSERT INTO djkNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ne di Masaa Jesesi de ape, ne Kownu Helowdesi akisi en onmen tenti sani. Ma ná wan di Masaa Jesesi taigi en. ");
INSERT INTO djkNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ne den moo hei begiman anga den leliman fu Dyuweiti e taki, ala sowtu ogii anga lei fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Te wan pisi, ne Kownu Helowdesi anga den bakaman fi en seefi bigin sipowtu anga Masaa Jesesi, e poti en wisiwasi. Ne den teke wan gaan moi koosi enke di kownu e wei, ne den wei gi en. Ne den e poti en wisiwasi e soso en tee, ne den sende en go a Gaaman Pilatesi baka. ");
INSERT INTO djkNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Da na a dei de seefi, Gaaman Pilatesi anga Kownu Helowdesi kon de bun baka anga denseefi. Bika langa ten a fesi, den be de feyanti anga denseefi. ");
INSERT INTO djkNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ne Gaaman Pilatesi kai den moo hei begiman anga den tiiman fu Islayeli Kondee anga ala taa sama kon makandii. ");
INSERT INTO djkNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ne a taigi den taki: “We, u tyai a man ya kon a mi taki, a du ogii, bika ai daai den sama ede. Mi akisi en ala fasi, ma mi á si ná wan ogii di a du, fu mi sitaafu en enke fa u e taki de. ");
INSERT INTO djkNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Da mi si taki, Kownu Helowdesi á fende fowtu ne en tu. A dati meke, a sende en kon gi mi baka. A á du ná wan ogii fu a mu dede. ");
INSERT INTO djkNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Da mi o meke den wipi en, da mi losi en baka.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ma namo, da Gaaman Pilatesi be gwenti fu puu wan sama a dunguu osu ala Pasika Fesa. Da ibii yali, a be e akisi den, sama den wani a puu a dunguu osu. Da na sama di den be wani, a be puu a dunguu osu gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma ala den sama bigin bali taanga taki: “Nono! Yu á mu losi en. Kii en puu de. Kii en! Na Balabasi u wani i puu a sitaafu osu gi u.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabasi, na be wan ogii kiiman di den be poti a dunguu osu a ten de. Bika en anga wantu taa man be kii sama, di den be opo feti anga a Loma lanti di be e tii Islayeli a ten de. ");
INSERT INTO djkNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ma Gaaman Pilatesi be wani puu Masaa Jesesi namo namo. A dati meke a taigi den sama taki: “Nono! Mi o losi a man ya. Bika mi á si ogii ne en.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma den e bali namo taki: “Nono! Kii Jesesi! Kii Jesesi! Sipikii en kii puu de!” ");
INSERT INTO djkNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ne Gaaman Pilatesi akisi den baka di fu dii toon taki: “Ma fu saide meke u wani meke mi kii a man ya? On sowtu ogii a du? Mi dati, mi á si ná wan ogii ne en fu mi mu kii en. Na fu dati, meke mi o meke den wipi en. Da mi o losi en meke a go fi en.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma den tan e bali namo taki, den mu sipikii en a koloisi kii puu de. ");
INSERT INTO djkNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Ne Gaaman Pilatesi á sabi san fu a du moo. Ne a taigi den taki: “So! U du enke fa u sabi.” Ne a puu Balabasi a dunguu osu gi den. Di ne en den wani, ne a puu en a dunguu osu. Ma a fika Masaa Jesesi gi den fu den tyai go sipikii kii. ");
INSERT INTO djkNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Da, di den de a pasi e tyai Masaa Jesesi fu go kii, te wan pisi, ne den miti wan man fu Sileni den e kai Simon. A be komoto ne en goon e kon a ganda. Ne den dwengi en fu tyai a koloisi fu Masaa Jesesi gi en. Ne a tyai a koloisi gi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Da a yuu di den e tyai Masaa Jesesi fu go kii, da somen sama be e waka ne en baka. Tyali fu Masaa Jesesi kisi den sama te, den uman poti ana a mindii ede e bali e kee. ");
INSERT INTO djkNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ne Masaa Jesesi daai luku den, ne a taigi den taki: “Uman fu Jelusalem! U á kee gi mi. Ma u kee gi useefi anga den pikin fu u. ");
INSERT INTO djkNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bika wanten fu pina o kon. Te a ten de doo, da sama o de di o go e taki: ‘Seigi fu uman di á meke pikin wanten, anga uman di ná abi pikin a bobi tu!’ ");
INSERT INTO djkNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bika na a ten de, da somen sama o de, di o go e bali taki: ‘Den gaan mongo ya, gaantangi! U kai kon a mi tapu, baa?’ Da den o taigi den pikin mongo taki: ‘U kai kon tapu u meke ná wan pikinso fu u fika na a goontapu ya moo.’ Ogii namo di a ten de o ogii so. ");
INSERT INTO djkNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bika efu na anga a kuwa kuwa udu den e du so, da a dee udu, no? Du fi en ná o moo ogii, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Da den be e tyai tu taa man, fu go sipikii kii anga Masaa Jesesi makandii. Den tu man ya be du gaan ogii na a kondee. ");
INSERT INTO djkNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ne den tyai Masaa Jesesi go na a peesi di den e kai Edebon Peesi. Ne den sipikii Masaa Jesesi anga den tu taa man de. Ne den opo den koloisi taampu. Wan fu den man be de a Masaa Jesesi leti ana se. A taawan be de ne en kukutu ana se. Masaa Jesesi seefi be de a mindii. ");
INSERT INTO djkNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ne Masaa Jesesi taki: “Mi Tata! Ná luku a ogii di den sama ya du anga mi ya. Ma gi den paadon. Bika den á sabi san den e du.” Ne den suudati iti lowte paati den koosi fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ne ala den somen sama di be kon de taampu e luku san e pasa. Den edeman fu kondee seefi be taampu e luku tu. Da den dati e sipowtu anga Masaa Jesesi, e wisiwasi en taki: “A be e yeepi taa sama. Ma now a á poi yeepi enseefi. Da meke a yeepi enseefi, meke u si, no? Efu en na a Kelestesi di Masaa Gadu sende kon.” Na so den edeman fu a kondee be e sipowtu anga en. ");
INSERT INTO djkNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Den suudati seefi be e sipowtu anga en tu. Ne den tyai wan win anga bita deesi a ini kon gi en fu a diingi. ");
INSERT INTO djkNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ne den taigi en taki: “O! Kownu fu den Dyu! Saka komoto na a koloisi meke u si, no?” ");
INSERT INTO djkNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Da den be sikiifi wan sani poti na a koloisi fu Masaa Jesesi a tapu de taki: ");
INSERT INTO djkNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Da wan fu den ogii ati man di den be sipikii a Masaa Jesesi se, bigin sipowtu anga Masaa Jesesi, e poti en wisiwasi taki: “Man! I na a Kownu di Masaa Gadu be paamisi taki, a be o sende kon gi u? We, soi u taki, i ne en tuu. Puu iseefi na a koloisi, da i puu wi tu!” ");
INSERT INTO djkNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ma a taa man di be de na taase ana fu Masaa Jesesi bali en taki: “Man! Tapu mofu de! Yu nái feele Masaa Gadu na a dede mofu di u de ya, no? ");
INSERT INTO djkNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mi anga yu e kisi a sitaafu, fu a ogii di u du. Ma a man ya á du ná wan enkii ogii, fu a mu kisi a sitaafu ya. Da kaba anga a sani de.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ne a daai luku Masaa Jesesi. Ne a taigi en taki: “Masaa Jesesi! Te yu e tii sani enke kownu, da gaantangi membee mi, baa?” ");
INSERT INTO djkNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ne Masaa Jesesi piki en taki: “A bun! Tuutuu, mi e taigi u taki, tide seefi mi anga yu o de na Paladeisi fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Da di san ati, twalufu yuu kisi, ne a hii kondee dunguu pii enke na neti. A dunguu ya be oli go miti dii yuu bakadina. A san seefi á be pii moo. ");
INSERT INTO djkNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ne a gaan deki gaiden di be e tapu a kambaa, pe a moo hei begiman anga Masaa Gadu be e miti wan toon wan yali, piiti dalla fu tapu, te a doti tyoo. ");
INSERT INTO djkNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ne Masaa Jesesi bali anga taanga tongo taki: “Mi Tata! Mi poti mi jeje a ini yu ana.” Ne di a taki so, ne en boo koti kelen. A dede. ");
INSERT INTO djkNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Da di a edeman fu den suudati si fa ala sani waka, ne a taki: “Aai! Eeye! A man ya na wan bunbun letiopu sama fu Masaa Gadu tuu.” ");
INSERT INTO djkNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ne di den somen sama di be kon de si fa ala sani waka, ne den naki ana a boo fu ati. Den á sabi saide meke so wan gaan ogii pasa. Tyali kisi den. Da na so den paati go a osu. ");
INSERT INTO djkNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Den somen mati fu Masaa Jesesi anga den uman di be komoto a Galileya pisiwataa kon anga en be taampu, te a wanse, e luku fa a hii sani ya waka. ");
INSERT INTO djkNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","52","We, wan edeman a ini a Dyulanti fu kuutu, di den e kai Jowsef be de ape tu. En na be fu a kondee den e kai Alimateya. Ala sama be e lesipeki en. Ne di sapaten, ne a go a Gaaman Pilatesi go begi en, fu a gi en a dede sikin fu Masaa Jesesi, a go beli. Jowsef na wan sama di be e fuuwakiti a Nyun Tii fu Masaa Gadu. Da a á be piki anga den taa Dyulanti, fu kuutu Masaa Jesesi a kukutu kuutu fu den. Bika en na be de wan letiopu ati sama. ");
INSERT INTO djkNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ne Gaaman Pilatesi gi Jowsef pasi, fu teke a dede sikin fu Masaa Jesesi go beli. Ne Jowsef go, ne a puu a dede sikin na a koloisi. Ne a lolo en a ini wan sibikoosi. Ne a tyai a dede sikin fu Masaa Jesesi go poti a ini wan nyunyun siton geebi olo, di den be diki poti de, fu beli sama. ");
INSERT INTO djkNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Da pikinso moo, da a kina dei fu den Dyu be o kai. Da den Dyu á be o poi du ná wan sani enke wooko moo. ");
INSERT INTO djkNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Da den uman di be kon anga Masaa Jesesi be go anga Jowsef go luku fa a be o beli a sikin fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Da di den si fa Jowsef beli en kaba, ne den daai gwe a osu. Da den e seeka switi sumee sani, fu go lobi na a sikin fu Masaa Jesesi. Ma di den si taki, na kina dei kai kaba, ne den fika e luku, fu a kina dei pasa enke fa a weiti fu Islayeli Kondee be de. ");
INSERT INTO djkNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Da, sonde mamanten fuuku, di a kina dei fu den Dyu pasa, ne den teke den switi sumee sani di den be seeka fu go lobi na a dede sikin fu Masaa Jesesi enke fa den Dyusama be gwenti. Ne den go na a siton olo geebi, a pe den be beli Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma di den doo na a olo, ne den si taki a olo de wongong. A gaanbigi siton di den be lolo tapu a geebi wai komoto na a olo mofu. ");
INSERT INTO djkNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ne den waka go a ini a geebi olo go luku a sikin fu Masaa Jesesi. Ma di den go, den á si a dede sikin fu Masaa Jesesi de moo. ");
INSERT INTO djkNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ne den e akisi denseefi taki: “Oho! San pasa anga a dede sikin fu Masaa Jesesi?” Den á sabi san den be mu denki fu sowan sani. Da fa den e taki de, te fu den denki, ne haa, den si tu man taampu a den fesi. Den wei weti koosi fann e koti faya gelen gelen. ");
INSERT INTO djkNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ne den uman ya dyombo te, den kai anga kini tapu fesi a doti. Ne den tu man akisi den taki: “Tan! Uman, sama sende u fu u kon suku a libiwan a mindii fu den dedewan? ");
INSERT INTO djkNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A sama di u e suku de á de ya. Bika ai libi baka. U feegete san a be taigi u di u anga en be de a Galileya? ");
INSERT INTO djkNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","A be taigi u taki, den be o seli a Manpikin di saka kon toon libisama ya, gi den ogii ati sama. Da den be o sipikii en kii a koloisi. Ma di fu dii dei, te a be dede, da a be o weki komoto a dede kon a libi baka. U sabi ete?” ");
INSERT INTO djkNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ne di den man taigi den uman ya so, ne den kisi denseefi taki: “Ai! Na tuu! Na so a be taigi u tuu.” ");
INSERT INTO djkNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ne den opo taampu baka, ne den lon go a Jelusalem, a den elufu bakaman fi en anga den taa sama fi en go taigi den ala san den si. ");
INSERT INTO djkNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","11","Den uman di be de na, Maliya Makidala, anga wan taawan den e kai Johana. Maliya, a mma fu Jakowbesi anga somen taa uman ete. Da di den taigi den so, ne den á wani biibi den. Den si enke na soso sani den e taki. ");
INSERT INTO djkNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma Peitilisi seefi opo, ne a lon te na a geebi. Ne di a go doo, ne a bendi luku go a ini a geebi. Ne na den koosi di den be lolo Masaa Jesesi wawan a si de. Ne a daai go a osu baka. A sani ya foondoo en te, a akisi enseefi san sa pasa anga a sikin fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Da na a seefi dei ya, ne tu sama fu Masaa Jesesi be komoto a Jelusalem e go a wan kondee den e kai Emayesi. Fu komoto a Jelusalem go na a kondee ya sa de wan sani fu tin na fo kilomeiti so. ");
INSERT INTO djkNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Da di den de a pasi e gwe, da den be e gi den toli, fu san pasa anga Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Da di den gi toli te wan pisi, ne wan sama waka kon miti den. Ne ai waka anga den. ");
INSERT INTO djkNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na Masaa Jesesi be waka kon miti den de, ma den á be sabi taki, ne en. Den ain á be kiin fu den be sabi taki na Masaa Jesesi de ape. ");
INSERT INTO djkNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ne di den waka te wan pisi, ne a sama akisi den taki: “We, fu sama u be e taki so? Sowtu toli u e gi taanga gi u so?” Ne den taampu pii. Ne den luku a man ya anga gaan tyali fesi. ");
INSERT INTO djkNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ne wan fu den tu man ya, di den be e kai Keleyopasi, piki en taki: “Na yu wawan na awan kodo sama di á yee a gaan ogii di pasa a Jelusalem de?” ");
INSERT INTO djkNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ne a sama akisi den taki: “San pasa?” Ne den taigi en taki: “Yu á yee san den du anga a apaiti takiman fu Masaa Gadu, di den be e kai Jesesi, no? Na be wan sama fu Nasaleti. A man ya be e du gaan foondoo sani a goontapu ya, e leli sama wan apaiti fasi. A be de wan bunbun sama a Masaa Gadu ain anga libisama. ");
INSERT INTO djkNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma den moo hei begiman anga den tiiman fu u kisi en, ne den gi den Loma sama di e taki fu a kondee ya fu den sipikii kii a koloisi. ");
INSERT INTO djkNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Da wi be denki taki, en na be a kownu di Masaa Gadu be paamisi, fu sende kon fu puu wi a den taa sama ondoo. Ma disi na di fu dii dei kaba di den kii en. ");
INSERT INTO djkNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma tide mamanten fuuku, da wantu umansama fu u be go na a geebi fu go lobi switi sumee sani gi a dede sikin fi en. Ne di den daai kon baka, ne den taigi u wan gaan foondoo sani. ");
INSERT INTO djkNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Den taigi u taki: ‘Den á si a dede sikin fi en de moo. Ne den taigi u go doo taki, den si tu Basiya fu Masaa Gadu Kondee*f23*, di taigi den taki, Masaa Jesesi opo komoto a dede baka. Da ai libi baka.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Da, ne wantu fu u komoto go luku. Ne den si taki, a dede sikin fu Masaa Jesesi á de ape moo tuu. Ma den á si Masaa Jesesi seefi. ");
INSERT INTO djkNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ne Masaa Jesesi taigi den taki: “Tan! Na so u don? Na so a taanga gi u fu biibi ala sani di den apaiti takiman fu Masaa Gadu be taki a fesi kaba? ");
INSERT INTO djkNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bika u be mu sabi kaba taki: ‘A kownu di Masaa Gadu be paamisi, fu sende kon, be mu pina so fosi a be go sidon enke kownu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ne a kai wantu pisi fu den buku fu Mosesi anga den buku fu den taa apaiti takiman fu Masaa Gadu gi den, fu tyai den pakisei kon baka. A meke den kon fusutan ala den sani fi en di be sikiifi a Masaa Gadu Buku. ");
INSERT INTO djkNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Da pikinso moo, da den be o doo na a kondee pe den be e go. Ne Masaa Jesesi du enke, a wani waka pasa. ");
INSERT INTO djkNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ne den tu sama begi a man taki: “Man! Ná pasa. Siibi anga u ya. Bika, a kon lati kaba.” Ne a taki: “A bun.” Ne a go anga den a osu, fu pasa a neti. ");
INSERT INTO djkNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Da di den sidon fu nyan, ne a teke a beele, ne a begi, gi Masaa Gadu daa moi te a kaba, ne a booko paati gi den. ");
INSERT INTO djkNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ne wanten den ain opo, ne den sabi taki, na Masaa Jesesi de ape. Ma, te fu den poti pakisei, ne woo! A gwe fika den wawan de. ");
INSERT INTO djkNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne den taigi denseefi taki: “A gwe, baa! Luku fa u ati be e piisii di a be e waka anga wi a pasi e kon, da ai puu den sani di sikiifi a Masaa Gadu Buku kiinkiin gi wi.” ");
INSERT INTO djkNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ne den opo. Ne den waka, fu te a Jelusalem. Na ape den anga den taa elufu bakaman fu Masaa Jesesi anga den taa sama fi en be o miti makandii. ");
INSERT INTO djkNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ne fa i si den doo, ne den taawan bali taigi den taki: “Na tuu! Masaa Jesesi opo komoto a dede baka tuu. Simon seefi si en.” ");
INSERT INTO djkNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ne den tu man di be daai baka kon a Jelusalem seefi taigi den taki, denseefi si en tu. Den taigi den fa a waka anga den a pasi go te a Emayesi. Ne na di den sidon fu nyan di a booko a beele gi den fosi, ne den ain opo fu si taki, ne en de ape. Ne te fu den denki, ne woo, a gwe. ");
INSERT INTO djkNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ne, te fu den tu man ya kaba taki, ne Masaa Jesesi de a den mindii pii. Ne a gi den odi taki: “Masaa Gadu mu de anga u, ye!” ");
INSERT INTO djkNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ne ala den fiya feele te, ná sipowtu. Bika den be denki taki, na wan yooka den be e si. ");
INSERT INTO djkNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma, ne Masaa Jesesi akisi den taki: “Saide meke u e feele so du? Saide meke u nái biibi taki, na mi de ya? ");
INSERT INTO djkNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","U luku mi ana anga mi futu! Na miseefi de ya! U kon oli mi luku. Bika yooka nái abi meti, ai nái abi bonyo.” ");
INSERT INTO djkNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ne di a taigi den so kaba, ne a soi den den maiki ne en ana anga en futu, pe den be sipikii en. ");
INSERT INTO djkNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Da a sani di Masaa Jesesi soi den ya, gi den gaan piisii. Da fu piisii ede meke den á be wani biibi taki, na Masaa Jesesi de ape. Da fu soi den taki ne en de ape tuutuu, ne a akisi den taki: “U abi wan sani ya, fu nyan?” ");
INSERT INTO djkNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ne den teke wan pisi losi fisi, ne den gi en. ");
INSERT INTO djkNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ne a nyanmi a losi fisi leti a den fesi de, meke den si. ");
INSERT INTO djkNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ne a taigi den taki: “U sabi san mi be taigi u ete di mi anga u be e waka e lontu? Mi be taigi u taki: ‘Ala den sani di sikiifi a den buku fu Mosesi, anga den apaiti takiman fu Masaa Gadu, anga den sani di sikiifi a ini den singi buku musu fu pasa tuutuu enke fa den sikiifi den.’ ” ");
INSERT INTO djkNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ne Masaa Jesesi puu den sani fu Masaa Gadu Buku gi den fini fini. Ne wanten den ain kon kiin, fu fusutan den sani fu Masaa Gadu Buku. ");
INSERT INTO djkNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ne a taigi den go doo taki: “We, na so a sikiifi a Masaa Gadu Buku taki: ‘A kownu di Masaa Gadu be paamisi fu sende kon a goontapu musu fu tyai pina, da a dede. Ma na di fu dii dei, da a opo baka komoto a dede.’ ");
INSERT INTO djkNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Da a bosikopu ya mu bali a hii goontapu doo ala foluku, fu den daai libi, meke Masaa Gadu sa gi den paadon, fu den takuudu anga ogii. Bigin a Jelusalem fosi, go doo hii goontapu. ");
INSERT INTO djkNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","We, useefi si taki, ala den sani di be sikiifi a Masaa Gadu Buku pasa tuu, enke fa a be sikiifi. ");
INSERT INTO djkNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Ma, fosi u go, da u mu tan a Jelusalem ya e luku a kaakiti di mi Tata paamisi u. Mi o sende en kon gi u. Da a o kon a u tapu, fu gi u kaakiti fu paati a bosikopu ya.” ");
INSERT INTO djkNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bakadati, ne Masaa Jesesi tyai den go na a kondee di den e kai Betaniya. Ne a opo ana a den tapu, ne a begi Masaa Gadu gi den, fu ala sani fu den waka bun. ");
INSERT INTO djkNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Da, di a opo ana e begi gi den so, ne Masaa Gadu teke en tyai go a tapu. ");
INSERT INTO djkNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ne den bakaman fi en e gi en gaandi, e gafa en, te a gafa. Ne bakadati, ne den go a Jelusalem baka anga gaan piisii a den ati. ");
INSERT INTO djkNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne di den doo Jelusalem, ne den go a ini a Mama Keliki go e begi Masaa Gadu e gi en gaandi e gafa en naamo.");
INSERT INTO djkNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","We, na a bigin, a Wowtu*f1* be de kaba. A Wowtu be de a Masaa Gadu. Da a Wowtu ya, na be Masaa Gadu seefi. ");
INSERT INTO djkNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Da senten na a bigin, da a Wowtu ya be de anga Masaa Gadu makandii. ");
INSERT INTO djkNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Da anga a Wowtu ya, Masaa Gadu be meke ala sani di de. Da ná wan sani de, di a ná en meke en. ");
INSERT INTO djkNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Da ne en ala libi e komoto. Da, te wan sama fende a libi ya, da so wan sama komoto a dunguu kon a ini leti. ");
INSERT INTO djkNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Da a leti e leti a ini a dunguu, ma a dunguu á be poi tapu a leti ya. ");
INSERT INTO djkNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","We, Masaa Gadu be sende wan sama, den kai Johanisi, kon. ");
INSERT INTO djkNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Da a be kon fu taki sani a fesi fu a leti di de fu kon. Da a be mu taki fu ala sama be yee fu den kon a biibi. ");
INSERT INTO djkNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma a ná Johanisi na be a leti, ma na kon a kon fu taki san a sabi fu a leti. ");
INSERT INTO djkNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Da a tuutuu leti, di e leti kiin sani gi ala sama be de fu kon a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Da a be kon a goontapu, a goontapu di enseefi meke, ma goontapu á be wani teke en enke wan sama di Masaa Gadu sende kon. ");
INSERT INTO djkNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Da soseefi a be kon na den eigi Dyusama fi en, ma den á be wani teke en enke den tiiman. ");
INSERT INTO djkNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma iniiwan sama di teke en enke den tiiman, na den a gi makiti fu toon pikin fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ma den á toon wan pikin fu Masaa Gadu, enke fa libisama e meke pikin, efu anga a wani fu libisama. Nono! Ma na Masaa Gadu seefi meke den toon pikin fi en. ");
INSERT INTO djkNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","We, a Wowtu be toon libisama. Ne a kon tan a u mindii fu wan pisiten. Da useefi be si a dyendee fasi fi en. A dyendee fasi fi en di u si de, na a dyendee fasi di a wankodo Manpikin fu a Tata sa abi. Na so Masaa Gadu teke gaan bun ati fasi namo luku libisama. Da na Masaa Jesesi wi e si kiinkiin, fa Masaa Gadu de. ");
INSERT INTO djkNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Da Johanisi be e taki fi en. Ne di a si en, ne a bali taki: “Na a sama ya mi be e taki, di mi be taigi u taki: ‘Wan sama o kon a mi baka di bigi moo mi. Bika a be de gaandiwe fosi mi be meke.’ ” ");
INSERT INTO djkNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","We, useefi kon sabi Awan de. A abi a gaan bun ati fasi fu Masaa Gadu, di a teke tyaipi bun a bun tapu, te a pasa maiki gi wi. ");
INSERT INTO djkNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bika na Mosesi, Masaa Gadu be gi den weiti fu gi wi fu libi. Ma na Masaa Jesesi a meke u kon sabi, fa a teke gaan bun ati fasi namo luku sama. Da na Masaa Jesesi u sa si kiinkiin, fa Masaa Gadu tan. ");
INSERT INTO djkNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ná wan libisama di si Masaa Gadu anga ain wanten. Ma na a wankodo Manpikin fi en, di de wan anga a Tata makandii, ne en meke u kon sabi en nownow, enke fa u de. ");
INSERT INTO djkNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","We, den gaan edeman fu keliki a Jelusalem sende kai wanlo apaiti begiman fu a Mama Keliki anga wanlo manengee fu Leifi Lo. Ne den sende den fu den go akisi Johanisi sama ne en. ");
INSERT INTO djkNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ne den go, ne den akisi en taki, efu na en na Kelestesi*f2* di Masaa Gadu be o sende kon a goontapu. Ne Johanisi puu taigi den gwelen sondee fu koli den. A taki: “Nono! Kweti kweti! Mi a ná a Kelestesi.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ne den akisi en baka taki: “We, da sama a yu, di i taki, yu a ná a Kelestesi? Yu na Eliya?” Ne Johanisi taigi den taki: “Nono!” Ne den akisi en baka taki: “We, yu na a apaiti takiman fu Masaa Gadu di a be o sende kon?” Ne Johanisi piki den taki: “Nono!” ");
INSERT INTO djkNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ne, te fu kaba, ne den akisi en taki: “We, da sama a yu seefi? Taigi wi meke u fende wan sani fu piki den sama di sende u kon te u daai go baka. San yu e taki fi iseefi?” ");
INSERT INTO djkNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ne Johanisi piki den enke fa Jesaja be sikiifi poti a Masaa Gadu Buku. Bika a be sikiifi taki: “We! Mi na a tongo fu wan sama di e bali basiya a ini a sabana ini taki: ‘Meke a pasi fu Masaa Gadu kon taampu letiopu fasi tiloo.’ ” ");
INSERT INTO djkNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","We, da den sama fu a paitei fu den Faliseiman be de a ini den sama di be kon de tu. ");
INSERT INTO djkNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ne den sama akisi Johanisi baka taki: “We, efu yu a ná a Kelestesi, yu a ná Eliya, yu a ná apaiti takiman, da saide meke yu e dopu sama fu du?” ");
INSERT INTO djkNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ne Johanisi piki den taki: “We, mi e dopu sama anga wataa. Ma wan Sama de a u mindii di u á sabi. ");
INSERT INTO djkNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Da a Sama ya o kon a mi baka. Da anga ala fa a o kon a mi baka de seefi, toku mi á waiti sai fu puu en susu ne en futu gi en.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Da ala den sani ya be e pasa a Betaniya Kondee na abaase fu a Joodani Liba, pe Johanisi be e dopu sama. ");
INSERT INTO djkNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ne a taa dei fi en, ne Johanisi si Masaa Jesesi e waka e kon ne en. Ne a taki: “U luku a Pikin Sikapu di Masaa Gadu gi wi fu puu ala takuudu anga ogii fu libisama gi den. ");
INSERT INTO djkNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Na a sama ya mi be e taki di mi be taigi u taki: ‘Wan sama o kon a mi baka, ma a be de bifo mi. A dati meke a bigi moo mi.’ ");
INSERT INTO djkNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Da miseefi á be sabi en. Ma na fu di Dyu Kondee be mu sabi en meke Masaa Gadu sende mi fu dopu sama anga wataa.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ne Johanisi taki baka taki: “Miseefi si a Jeje fu Masaa Gadu saka komoto a tapu enke wan doifi de tan ne en tapu. ");
INSERT INTO djkNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Da miseefi á be sabi en. Ma en di sende mi fu mi dopu sama anga wataa, ne en taigi mi taki: ‘A sama di mi o si a Jeje fu Masaa Gadu saka kon de ne en tapu, ne en na a sama di o dopu sama anga a Jeje fu Masaa Gadu.’ ");
INSERT INTO djkNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Da mi si a sani di Masaa Gadu taigi mi de tuu. Na fu dati ede meke mi e taigi u taki, a sama di u e si de, na a Manpikin fu Masaa Gadu tuu.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ne a taa dei fi en, ne Johanisi be taampu de baka anga tu fu den bakaman fi en. ");
INSERT INTO djkNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ne a si Jesesi e waka pasa. Ne a taki: “U luku a Pikin Sikapu fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ne di den tu bakaman fi en yee a taki so, ne den waka go e waka a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ne di Masaa Jesesi daai, ne di a si den e kon ne en baka, ne a akisi den taki: “San u wani?” Ne den piki en taki: “Labai*f3*, pe yu e tan?” ");
INSERT INTO djkNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ne a taigi den taki: “We, u kon go anga mi, da u sa si.” Ne den go luku pe ai tan. Ne di den go, ne den tan anga en de te bakadina. Da a be de wan sani fu fo yuu bakadina so. ");
INSERT INTO djkNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Da wan fu den tu bakaman fu Johanisi di be go anga Masaa Jesesi na, Andeleyasi, wan baala fu Simon Peitilisi. ");
INSERT INTO djkNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","We, ne a feti go ne en baala Simon esi esi. Ne a taigi en taki: “U fende a Mesiyasi*f4*.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ne a tyai en baala Simon go a Masaa Jesesi. Ne di Masaa Jesesi si en, ne a taki: “Yu na Simon, a manpikin fu Johanisi. Yu o nen Kefasi*f5*.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ne a taa dei fi en, ne Masaa Jesesi opo fu go baka a Galileya. Ne a si wan man den e kai Filipi. Ne a kai en taki: “Kon go anga mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Da Filipi na be fu a seefi kondee di den e kai Betisaida enke Andeleyasi anga Peitilisi. ");
INSERT INTO djkNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","We, Filipi seefi miti anga Nataniyeli. Ne a taigi en taki: “U fende Jesesi, a manpikin fu Jowsef, fu a kondee di den e kai Nasaleti, di Mosesi anga den taa apaiti takiman fu Masaa Gadu be sikiifi sani fi en.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ne Nataniyeli akisi en taki: “Wan bun sa komoto a Nasaleti Kondee?” Ne Filipi taigi en taki: “We, kon go luku, da iseefi sa si.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ne di Masaa Jesesi si Nataniyeli e kon, ne a taki: “Luku wan bunbun Islayeli e kon de. Wan sama di nái koli sama.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ne Nataniyeli akisi en taki: “Fa i du sabi mi?” Ne Masaa Jesesi piki en taki: “Fosi Filipi be kai yu, di i be de na a figasii bon ondoo de, mi be si yu kaba.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ne Nataniyeli piki en taki: “Labai, yu na a Manpikin fu Masaa Gadu. Yu na a Kownu fu den Islayeli sama.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ne Masaa Jesesi piki en taki: “Na fu di mi taigi yu taki: ‘Mi be si yu na a figasii bon ondoo,’ meke yu e biibi? Yu o si moo gaan foondoo sani moo enke dati.” ");
INSERT INTO djkNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne Masaa Jesesi taigi den taki: “Fu tuutuu mi e taigi u taki, u o si tapu a den woluku anda opo waa. Da u o si den Basiya fu Masaa Gadu Kondee*f6* e subi e go, e saka e kon na a Manpikin di kon saka toon libisama ya tapu.” ");
INSERT INTO djkNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ne baka tu dei, ne den oli wan toow osu a Kaana, na a pisiwataa fu Galileya. Da Masaa Jesesi mma be de ape tu. ");
INSERT INTO djkNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Da den be kai Masaa Jesesi anga den bakaman fi en fu kon na a toow osu ya tu. ");
INSERT INTO djkNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ne di a piisii go te wan pisi, ne a win di den sama be e diingi kaba. Ne Masaa Jesesi mma kon ne en, ne a taigi en taki: “A win fu den sama kaba.” ");
INSERT INTO djkNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ne Masaa Jesesi piki en taki: “Uman! A sani de a ná mi anga yu booko ede. Mi yuu á kisi fu wooko ete.” ");
INSERT INTO djkNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ne Maliya daai, ne a taigi den wookoman, di be e wooko na a toow osu taki: “A san di a o taigi u fu u du, na dati u mu du.” ");
INSERT INTO djkNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Da den be abi sigisi gaan dabisan de. Da na ini den dabisan ya den be e lai wataa fu wasi enke fa a weiti fu den Dyu be de. Da iniiwan fu den dabisan ya be sa oli wan sani fu wan ondoo liti so. ");
INSERT INTO djkNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ne Masaa Jesesi taigi den taki: “U fuu den dabisan de anga wataa.” Ne den fuu den anga wataa te den de gwingwingwin. ");
INSERT INTO djkNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ne a di den fuu den dabisan anga wataa kaba, ne a taigi den taki: “U kisi afu tyai go gi a edeman fu a toow osu, meke a tesi luku.” Ne den go kisi a wataa tyai go gi a edeman fu a toow osu. ");
INSERT INTO djkNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","Ne di a edeman tesi a wataa di daai kon toon win, ne a bali gi a toow man taki: “Ala sama e poti a moo bun win na a bigin fu ala piisii fu den sama fende diingi. Da te den diingi a moo bun wan te a kisi den, da fosi den e diingi den taawan. Ma yu be kibii a moo bun wan te enke now.” Na fu di a á be sabi pe a win ya komoto meke a be taki so. Na den futuboi wawan di be go kisi a wataa be sabi pe a win ya komoto. ");
INSERT INTO djkNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Da, na di Masaa Jesesi de a Kaana na a pisiwataa fu Galileya a du a gaan foondoo sani ya. A fosi wonduu wooko fu den gaan foondoo foondoo wooko di a o du. Da anga a sani di a du ya, a meke sama si a dyendee fasi fi en. Ne den bakaman fi en kon e biibi ne en. ");
INSERT INTO djkNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ne bakadati, ne Masaa Jesesi anga en mma anga en baala anga den bakaman fi en go na a kondee di den e kai Kafalnayemu. Da den tan ya wantu dei namo. ");
INSERT INTO djkNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Da a ten ya, da a gaan piisii fu den Dyu di den e kai Pasika be de koosube. Ne Masaa Jesesi teke pasi e subi go a Jelusalem. ");
INSERT INTO djkNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ne di a go doo, ne a si sama na a Mama Keliki fu den Dyu e seli kaw anga sikapu anga doifi. Taawan e kengi moni gi taawan. ");
INSERT INTO djkNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne Masaa Jesesi teke tetei meke wan wipi, ne a yaki ala den fiya puu a ini a Mama Keliki. Soseefi a yaki den sikapu anga den kaw puu na a Mama Keliki tu. Ma a daai den tafaa fu den man di be e kengi moni gi sama towe ala a moni a dati fanyaa. ");
INSERT INTO djkNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne a bali den man di be e seli doifi taki: “U gwe komoto ya! U á teke a osu fu mi Tata meke toon wowoyo!” ");
INSERT INTO djkNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Da den bakaman fi en kisi denseefi fu wan sani di sikiifi a Gadu Buku. A sikiifi taki: “A feti di mi e feti e meke moiti fu a osu fi i, e boon a ini mi ati enke faya.” ");
INSERT INTO djkNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma den edeman fu den Dyu piki Masaa Jesesi taki: “Sama sende i, fi i du den sani de? We, da soi u wan maiki taki yu abi a makiti fu du den sani ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ne Masaa Jesesi piki den taki: “U sa booko a osu fu Masaa Gadu di u e si ya, da te fu dii dei, da mi sa opo en taampu baka, enke fa a be de.” ");
INSERT INTO djkNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ne den edeman fu den Dyu piki en taki: “Oho! Fotenti a sigisi yali a teke fu meke a gaan keliki osu ya. Ne i taki, efu u booko en i sa meke en baka fosi dii dei?” ");
INSERT INTO djkNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ma a ná a keliki osu di den e denki de Jesesi e taki. A be e taki fi en eigi sikin. ");
INSERT INTO djkNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Da, di a opo komoto a dede baka, ne den bakaman fi en kisi den seefi taki a be taki so wan sani gi den. Ne den biibi den sani di sikiifi a Gadu Buku anga ala sani di Masaa Jesesi be taigi den. ");
INSERT INTO djkNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Da, di Masaa Jesesi de a Jelusalem na a Pasika Piisii, da somen sama daai kon e biibi ne en, fu di den be si den gaan foondoo foondoo sani di a be e du. ");
INSERT INTO djkNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Da anga ala fa den e biibi ne en de seefi, toku Masaa Jesesi nái fitoow den. Bika a be sabi ala den fiya. ");
INSERT INTO djkNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Da a á be de fanowdu fu wan sama taigi en sani fu taa sama. Bika enseefi be sabi kiinkiin san de a ini den sama pakisei. ");
INSERT INTO djkNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wan Faliseiman be de, den be e kai Nikodeimisi. Da Nikodeimisi na be wan gaan edeman fu den Dyu. ");
INSERT INTO djkNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","We, ne a kon a Masaa Jesesi a wan neti, di ala peesi dunguu kaba. Ne a taigi Masaa Jesesi taki: “Labai! Wi sabi taki yu na wan leliman di Masaa Gadu sende kon. Bika ná wan sama di poi du den sani di yu e du, efu Gadu á de anga en.” ");
INSERT INTO djkNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ne Masaa Jesesi piki en taki: “We, tuutuu mi e taigi yu taki, efu wan sama á meke baka ete wan toon fu fende wan nyun libi, da a ná o poi go si a Nyun Tii fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ne Nikodeimisi piki en taki: “Fa wan sama o du meke baka, te a gaandi kaba? A sa go ne en mma bee baka fu a meke en di fu tu toon?” ");
INSERT INTO djkNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ne Masaa Jesesi piki en taki: “Fu tuu mi e taigi yu taki, efu wan sama á meke baka ete wan toon, a wan hii taa fasi anga wataa anga Jeje, a ná o poi go si a Nyun Tii fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sama di meke a libisama fasi, a libisama fasi a o de. Ma sama di a Jeje fu Masaa Gadu meke, da na Gadu fasi a o de. ");
INSERT INTO djkNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","We, fa mi taigi i de taki, yu mu meke baka ete wan toon, da a á mu foondoo yu. ");
INSERT INTO djkNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Winta e wai go a pe a wani. Na a bali fi en namo yu e yee. Ma yu á sabi na on pe a komoto efu na on pe ai go. We, na letiso a de anga ibii sama di a Jeje fu Masaa Gadu a tapu meke baka ete wan toon. Yu nái si a nyunyun meke efu fusutan en, leti enke fa yu nái fusutan a winta. Ma yu sabi taki sowan sani pasa tuu.” ");
INSERT INTO djkNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma Nikodeimisi piki en taki: “Fa den sani ya o du pasa?” ");
INSERT INTO djkNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ne Masaa Jesesi piki en taki: “Yu na wan gaan leliman fu Islayeli Kondee, ne yu á sabi den sani ya?” ");
INSERT INTO djkNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Fu tuu mi e taigi yu taki: “Wi sabi san wi e taki. Bika na den sani di wi si, wi e taki. Ma u á wani biibi san wi e taigi u. ");
INSERT INTO djkNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","We, efu u nái biibi mi, te mi e taki anga u fu den sani fu goontapu ya, da fa u o biibi, te mi o taki anga u fu den sani fu Gadu Kondee a tapu? ");
INSERT INTO djkNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Bika ná wan sama be opo go a Masaa Gadu Kondee a tapu boiti a Manpikin di saka kon toon libisama ya. ");
INSERT INTO djkNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“We, leti enke fa Mosesi be meke a kopoo sineki opo poti a hei a ini a sabana, na soseefi den o opo a Manpikin di saka kon toon libisama ya, poti a hei tu. ");
INSERT INTO djkNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Da, ibiiwan sama di o biibi a mi, da yu o fende a libi fu tego a Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“We, bika Masaa Gadu lobi goontapu te, ne a gi den a wankodo Manpikin fi en, fu ibiiwan sama di e biibi ne en á mu go lasi, ma fu den fende a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bika fa Masaa Gadu sende en Manpikin kon a goontapu ya, da a á sende en kon fu a kuutu libisama. Ma a sende en kon fu a puu libisama a dede meke den fende a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Da, efu wan sama e biibi a ini a Manpikin fu Masaa Gadu ya, da a ná o kisi sitaafu. Ma sama di nái biibi a ini en, da a kuutu i kaba fi i kisi a sitaafu de. Da a o kuutu yu fu di yu á biibi a ini a nen, fu a wankodo Manpikin di Masaa Gadu sende kon gi u. ");
INSERT INTO djkNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Da disi na a sitaafu: Bika a de so taki Masaa Gadu be sende a leti fi en kon a goontapu, ma libisama á be wani a leti ya. Pe fu dati, ne den de fu den a dunguu, bika den á be wani fika den ogii libi fu den fu kon a ini a leti. ");
INSERT INTO djkNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bika wan sama di e du ogii, na wan sama di buuse leti. A ná o kon seefi a pe a leti sa kai ne en fu den wooko fi en kon a kiin. ");
INSERT INTO djkNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma sama di e libi letiopu, ná abi toobi fu kon a ini a leti. Da na so a o soi taki ai du san Masaa Gadu taki.” ");
INSERT INTO djkNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ne bakadati, ne Masaa Jesesi anga den bakaman fi en go a Judeja pisiwataa. Ne en anga den de ape fu wan pisiten. Ne Masaa Jesesi dopu den sama de. ");
INSERT INTO djkNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ma Johanisi a Dopuman á be go a dunguu osu ete. Da na so enseefi be e dopu sama tu na a peesi di den e kai Enon, koosube fu a kondee di den e kai Salim. Bika a peesi be abi tyaipi wataa. Da somen sama be kon ne en tu fu a dopu den. ");
INSERT INTO djkNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Da a seefi yuu ten de, ne den bakaman fu Johanisi anga wan Dyu de a wan gaan sitee kwali fu den. Da den be de na a sitee fu san den mu du fu den kon kiin a Gadu fesi. ");
INSERT INTO djkNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ne den bakaman fu Johanisi kon ne en, ne den taigi en taki: “Labai! I sabi a sama di i be taigi wi somen sani fi en? A de na abaase anda e dopu sama. Da ala den sama fiya e go ne en. Na a sama di i be taigi wi somen sani fi en.” ");
INSERT INTO djkNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma Johanisi piki den taki: “Ná wan libisama sa du wan sani, efu a ná Masaa Gadu a tapu seefi de anga en. ");
INSERT INTO djkNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","U seefi á be yee di mi be taki, mi a ná a Kelestesi, ma na sende Masaa Gadu sende mi kon ne en fesi, no? ");
INSERT INTO djkNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Te wan sama toow anga wan uman, ne en na a man fu a uman. Ma a man o abi wan mati di e seeka ala sani gi en na a toow dei. A ná en o toow anga a uman, ma na seeka namo ai seeka sani gi en. Te a kaba seeka sani, da a o go de fi en a wanse pii fu yee a toowman tongo. Da te a yee en tongo, da a o piisii gaan piisii. We, na a gaan piisii di a mati fu a toowman e piisii de, na so miseefi e piisii tu. ");
INSERT INTO djkNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bika a sama de mu kon moo anga moo a fesi fu teke peesi, ma mi mu go moo anga moo a baka. ");
INSERT INTO djkNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Bika a sama di komoto a Gadu a tapu hei moo ala sama. Ma sama di meke a goontapu, na fu goontapu namo a de. Da na goontapu toli namo a o go e taki. ");
INSERT INTO djkNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ma a sama di komoto a Masaa Gadu hei moo ala taa sama. Da a sama de e taki fu san a si anga san a yee. Ma toku, ná wan libisama wani teke sani ai taki. ");
INSERT INTO djkNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma, efu wan sama teke den sani di ai taki, da sowan sama e soi kiinkiin taki san Masaa Gadu taki na wan tuutuu sani. ");
INSERT INTO djkNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bika a sama di Masaa Gadu be sende kon a goontapu e taki den sani di Masaa Gadu gi en fu taki. Bika Masaa Gadu á be gi wi a Jeje fi en afu afu, ma a be gi enmi en hiihii. ");
INSERT INTO djkNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","A Tata lobi a Manpikin fi en. Da a poti ala sani a ini en ana. ");
INSERT INTO djkNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Da, efu wan sama e poti biibi na a Manpikin fu Masaa Gadu ya, da i abi a libi fu tego kaba. Ma, efu wan sama á wani poti biibi na a Manpikin fu Masaa Gadu ya tapu, da i ná o fende a libi fu tego ya. Bika a atiboon fu Masaa Gadu de a yu tapu kaba.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","We, ne a seefi yuu ten de, ne den Faliseiman yee taki somen sama e kon a Masaa Jesesi te a ipi fu a dopu de. Da den sama e fika anga Masaa Jesesi e toon bakaman fi en. Da na so Masaa Jesesi be abi moo ipi bakaman moo Johanisi. ");
INSERT INTO djkNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Wansi a ná enseefi be e dopu den sama seefi, ma na den bakaman fi en. ");
INSERT INTO djkNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","We, ne di Masaa yee taki den Faliseiman kon sabi so kaba, ne a komoto fika Judeja go a Galileya. ");
INSERT INTO djkNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma a be musu fu waka pasa na a pisi kondee di en e kai Samaliya fosi a be doo Galileya. ");
INSERT INTO djkNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ne ai go te a go doo a wan foto fu Samaliya den e kai Sikali. Da Sikali de koosube anga wan pisi doti di a gaansama fu den Dyu den kai Jakopu be gi wan fu den pikin fi den kai Jowsef. ");
INSERT INTO djkNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","We, na ape Jakopu be abi wan peti wataa fi en di de a pe te enke tide. We, di Masaa Jesesi be doo de, da a be weli fu waka. Ne a go koosube na peti. Da a be sa de wan sani fu twalufu yuu mindii dei so. ");
INSERT INTO djkNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Di Masaa Jesesi sidon de te wan pisi, ne wan uman fu a kondee de kon fu kisi wataa na a peti. Ne Masaa Jesesi akisi en taki: “Gi mi wan pikinso wataa fi yu mi diingi, baa?” ");
INSERT INTO djkNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Da a yuu de, da den bakaman fi en be go a foto fu bai sani fu den nyan. ");
INSERT INTO djkNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ne a uman akisi en taki: “Fa yu enke wan Dyusama sa begi mi wataa fu diingi?” Den Dyu anga den Samaliya sama á be e koti. ");
INSERT INTO djkNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ne Masaa Jesesi piki en taki: “Efi i be sabi a gaan bun di Masaa Gadu be wani gi yu, anga efi i be sabi a sama di e begi i wataa fu diingi ya, da i be o begi en wataa, da a be o gi yu a wataa di e gi sama libi.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ne a uman piki en taki: “We, Masaa, yu ná abi ná wan sani fu kisi a wataa. Da soseefi a peti dipi tu. Da pe yu o fende libi wataa fu gi mi? ");
INSERT INTO djkNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","I bigi moo u tata Jakopu di be gi wi a peti ya? Bika enseefi anga den pikin fi en anga den meti fi en be diingi a wataa fu a peti ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ne Jesesi piki en taki: “A sama di e diingi a wataa ya, te wan pisiten, da dee wataa o kisi en baka. ");
INSERT INTO djkNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma a sama di o diingi a wataa di mi o gi en, da ná wanten moo di dee wataa o kisi en. Ma a wataa di mi o gi en o toon gaan liba e lon komoto ne en ini huu enke gaan sula. Da sowan sama abi a libi fu tego kaba.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ne a uman taigi en taki: “Masaa oo! Gi mi a wataa de, meke dee wataa á kisi mi moo, baa? Da a ná o de fu mi kon kisi wataa dise moo.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ne Masaa Jesesi taigi en taki: “Go kai i man, da u kon.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ne a uman taigi en taki: “Mi ná abi man.” Ne Jesesi taigi en taki: “Na tuu san i taki, taki i ná abi man. ");
INSERT INTO djkNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Bika na feifi man i libi anga den paati kaba. Da a wan di i abi ya seefi a ná yu man tu. Da san yu taki ya na tuu.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ne a uman piki en taki: “Masaa, mi e si taki yu na wan apaiti takiman fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","We, bika den gaansama fu u den Samaliya sama be e begi Masaa Gadu na a mongo tapu ya. Ma u den Dyusama taki, na Jelusalem na a moo bun peesi fu begi.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ne Jesesi piki en taki: “Uman, biibi mi. A ten e kon, di a ná a mongo tapu ya efu Jelusalem u o go fu go begi a Tata moo. ");
INSERT INTO djkNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","U á sabi san u e begi. Ma wi sabi san wi e begi. Bika na den Dyu a tuutuu yeepi fu Masaa Gadu e komoto go a den taa sama. ");
INSERT INTO djkNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ma a ten e kon, da meke u taki, a de kaba, di den sama di e libi wan letiopu fasi o begi anga den hii ati a ini jeje anga tuu. Bika na den sowtu sama ya Gadu Tata e suku fu begi en na a sowtu fasi ya. ");
INSERT INTO djkNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ma Gadu na jeje. Da den sama di e begi en mu begi en, e opo en nen a hei a wan tuutuu fasi anga a Jeje fu Masaa Gadu leti enke fa enseefi de tuutuu.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ne a uman taigi en taki: “Mi sabi taki a Mesiyasi*f7* o kon. Da te a kon, da a o tyai ala sani fiya kon a kiin gi wi.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ne Masaa Jesesi piki en taki: “We, uman, a sama di i kai de, ne en i si e taki anga yu ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","We, a seefi yuu de, ne den bakaman fu Masaa Jesesi kon doo a pe a be de. Ne den foondoo fu si taki a be e taki anga wan uman sama. Ma toku seefi ná wan fu den di taki wan sani fu akisi en taki, san yu akisi en, efu san yu anga en be e taki. ");
INSERT INTO djkNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ne a uman fika a bungu fi en de, ne a lon go a ini a foto go kai sama taki: ");
INSERT INTO djkNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“U kon go luku wan sama di taigi mi, mi hii libi. Da u kon u go luku. Kande sama na a Kelestesi.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ne den sama komoto a ini a foto booko gwullu go a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","We, a yuu de, da den bakaman be e begi Masaa Jesesi fu a go nyan. ");
INSERT INTO djkNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma Masaa Jesesi piki den taki: “Mi abi wan nyanyan fu nyan di u á sabi.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ne den bakaman fi en taigi den seefi taki: “Tan! A sa de taki wan sama be tyai nyanyan kon gi en fu a nyan?” ");
INSERT INTO djkNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Jesesi taigi den taki: “A nyanyan fu mi, na fu du a wani fu mi Tata di sende mi kon, fu a wooko fi en go doo. ");
INSERT INTO djkNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Na u seefi e taki, ete fo mun, da koti alisi yuu doo, no? We, u opo u ain luku den goon. Alisi lepi kaba. ");
INSERT INTO djkNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","We, sama di e koti e fende en paiman. Da soseefi ai kibii nyanyan fu a libi fu bakaten. Da sama di e paandi anga sama di e koti o piisii makandii. ");
INSERT INTO djkNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bika na ya wi e si taki a nongo e kon tuu di taki: ‘Taawan e paandi, taawan e koti.’ ");
INSERT INTO djkNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Bika, we mi be sende u go fu u koti san taa sama be paandi. Na taa sama be sete a wooko de, ma u kon fu kaba en.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Da somen sama fu Samaliya kon biibi ne en fu a sani di a uman be taigi den. Bika a be taigi den taki: “A taigi mi ala san mi be du.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ne den Samaliya sama di be kon ne en, begi en fu a tan anga den ape. Ne a tan tu dei anga den. ");
INSERT INTO djkNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma somen sama be daai kon e biibi ne en fu den wowtu di enseefi be e taki. ");
INSERT INTO djkNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne den sama taigi a uman taki: “Now u nái biibi moo fu san i taigi wi. Ma wi e biibi fu di wi eigi yesi yee. Da wi sabi tuutuu taki, a Yeepiman di Masaa Gadu sende kon gi goontapu, ne en de ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ne tu dei a baka, ne Masaa Jesesi komoto de e go a Galileya. ");
INSERT INTO djkNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","We, Masaa Jesesi seefi be taki kiinkiin taki: “Wan apaiti takiman fu Masaa Gadu ná abi nen ne en eigi kondee.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","We, di a doo Galileya, ne ala den sama di be si den sani di a be du a Jelusalem, teke en anga gaan piisii. Bika somen fu den be de a Jelusalem na a Pasika Piisii tu. ");
INSERT INTO djkNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Ne Masaa Jesesi doo a peesi di den e kai Kaana, na a pisiwataa fu Galileya, pe a be meke a wataa toon win. Ne di a go doo de, ne wan bigiman di be e wooko a kownu paleisi yee taki a komoto a Judeja kon a Galileya de. Ne a go a Masaa Jesesi fu a kon deesi wan manpikin fi en gi en. Bika a pikin ya be siki swaki te na fu dede namo. ");
INSERT INTO djkNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ne Masaa Jesesi piki en taki: “Solanga u á si gaan foondoo sani anga gaan maiki, u nái biibi.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ne a man piki en taki: “Masaa, gaantangi kon yeepi mi, baa. Deesi a pikin fu mi gi mi fosi a dede, baa.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ne Masaa Jesesi piki en taki: “Go! A pikin fi yu e libi.” We, a man biibi enke fa Masaa Jesesi taki. Ne a go fi en a osu baka. ");
INSERT INTO djkNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ne di a de a pasi e gwe te wan pisi, ne a miti den futuboi fi en a pasi. Ne den taigi en taki: “A pikin fi yu e libi!” ");
INSERT INTO djkNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ne di a akisi den on ten fu a dei a pikin be kon betee, ne den taigi en taki: “Eside bakadina, wan ten fu wan yuu, ne a feba gwe.” ");
INSERT INTO djkNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ne a man si taki na a seefi yuu di Masaa Jesesi be taigi en taki: “Go! A pikin fi yu e libi.” We, ne a man ya anga en hii osu daai kon a biibi. ");
INSERT INTO djkNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Da a sani di Masaa Jesesi du ya, ne meke di fu tu gaan foondoo sani di a du, di a daai komoto a Judeja kon a Galileya baka. ");
INSERT INTO djkNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","We, ne baka disi, da ete wan gaan piisii fu den Dyu o de. Ne Masaa Jesesi teke pasi, ne ai go a Jelusalem. ");
INSERT INTO djkNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","We, da a yuu ten de, da wan peti wataa be de a Jelusalem koosube fu den doo mofu fu a kondee. Da disi na a doo di den sama be e tyai den sikapu pasa go a ini a kondee. Da na a peti ya den Dyu be e kai Betisaida. Da den be meke feifi baikon lontu a peti wataa ya. ");
INSERT INTO djkNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Da somen sikiman be de didon didon a ini den baikon de. Beendiman, lanman anga malengiiman, ala den fiya be de ape didon didon. Ala den fiya de e luku on yuu a wataa o seke. ");
INSERT INTO djkNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bika a abi a yuu, da wan Basiya fu Masaa Gadu Kondee*f8* e saka komoto a tapu kon seke a wataa. Da te a wataa seke so kaba, da a sama di o go a ini enke fosi sama, da a sama de e kon bun baka, wansi sowtu siki a be abi. ");
INSERT INTO djkNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","We, wan sama di be siki diitenti na aitin yali be de ape didon didon. ");
INSERT INTO djkNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Da di Masaa Jesesi si en didon didon de, ne a akisi en taki: “Man, yu wani kon bun baka?” Bika Masaa Jesesi be sabi taki a man ya be didon de langa kaba. ");
INSERT INTO djkNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ne a sikiman piki en taki: “We, Masaa. Mi ná abi ná wan sama fu poti mi go a ini a wataa, te a wataa e seke. We bika, te a wataa seke, fosi mi go doo, da wan taa sama go a mi fesi kaba.” ");
INSERT INTO djkNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ne Masaa Jesesi taigi en taki: “Opo! Teke i kama, da i waka go.” ");
INSERT INTO djkNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ne wanten wanten a sikiman kon bun baka. Ne a teke en kama, ne a go. Ma namo, da ala a sani be e pasa a wan kina dei fu den Dyu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Na fu dati ede meke den edeman fu den Dyu taigi a sikiman di kon bun ya taki: “Man! Yu á sabi taki tide na kina dei, no? Yu á mu wooko e tyai i kama na a kina dei ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ne a man piki den taki: “We, na a sama di deesi mi meke mi kon bun baka, ne en taigi mi taki, meke mi opo, da mi teke mi kama, da mi waka go.” ");
INSERT INTO djkNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ne den akisi en taki: “Sama na a sama di taigi yu a sani de?” ");
INSERT INTO djkNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma a man á be sabi Masaa Jesesi seefi. Bika Masaa Jesesi be gwe fi en komoto na ape saafi saafi. Bika somen somen sama be de ape. ");
INSERT INTO djkNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ne moo lati, ne Masaa Jesesi miti anga a man ya a ini a Mama Keliki fu den Dyu. Ne Masaa Jesesi taigi en taki: “I si? I kon bun baka. Yu á mu du ogii moo, ye! Efuso wan moo gaan ogii o miti yu.” ");
INSERT INTO djkNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ne a man gwe, ne a taigi den edeman fu den Dyu taki, na Masaa Jesesi na a sama di deesi en meke a kon bun baka. ");
INSERT INTO djkNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Na fu dati ede meke den go suku Masaa Jesesi. Ne den meke toobi anga en ogii ogii e suku fu kii en fu di a be deesi a man na a kina dei fu den Dyu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma Masaa Jesesi piki den taki: “Mi Tata e wooko te enke now, da miseefi e wooko tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","We, ne den edeman fu den Dyu e meke moiti moo taanga fu den fende en kii. Bika a ná a kina dei fu den Dyu wawan a be booko, ma a kai Masaa Gadu en eigi Tata. Da na so a be e meke enseefi toon wan anga Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma Masaa Jesesi piki den taki: “Fu tuutuu mi e taigi u taki, a Manpikin á poi du ná wan sani boiti san a si a Tata e du. Ma san a Tata e du, na dati a Manpikin e du tu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bika a Tata lobi a Manpikin fi en. Da ala san a Tata e du ai soi a Pikin. Da a o soi en moo gaan foondoo sani ete fu du. Da u ala fiya sa foondoo seefi seefi. ");
INSERT INTO djkNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bika fa i si a Tata e weki den dedesama puu a dede, gi den libi baka, na leti soseefi a Manpikin fi en sa gi iniiwan sama di a wani libi tu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","We, a Tata nái kuutu ná wan sama, ma a poti ala a kuutu a ini ana fu a Manpikin. ");
INSERT INTO djkNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","We, na fu ala sama mu lesipeki a Manpikin, enke fa den e lesipeki a Tata meke a du so. Da sama di nái lesipeki a Manpikin, nái lesipeki a Tata tu, di sende a Manpikin kon a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Fu tuutuu mi e taigi u taki, a sama di e biibi san mi e taki tuu, ne ai biibi a sama di sende mi kon a goontapu, da sowan sama abi a libi fu tego kaba. Da a sama de ná o go a kuutu moo. Bika a komoto a dede kon a libi. ");
INSERT INTO djkNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Fu tuutuu mi e taigi u taki, a yuu o kon, da a de kaba, di den dedesama sa yee a tongo fu a Manpikin fu Masaa Gadu. Da den sama di o piki mi o fende a libi. ");
INSERT INTO djkNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Bika, leti enke fa i si mi Tata abi libi fu gi ala sama, na leti soseefi a Pikin abi libi tu fu gi sama. ");
INSERT INTO djkNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","We, ne a gi en makiti tu fu kuutu libisama fu di enseefi de a Manpikin di saka kon toon libisama ya. ");
INSERT INTO djkNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","U á mu foondoo fu den sani di mi taki ya. Bika wan yuu e kon di ala sama di de a ini geebi sa yee en tongo. ");
INSERT INTO djkNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Da ala den fiya o weki komoto a dede baka komoto a ini geebi kon a libi. Da den di be libi bun a Gadu ain, o weki baka fu libi anga Gadu fu tego. Ma den di be libi takuu a Gadu ain, sa opo baka komoto a ini geebi fu go a kuutu poti go a sitaafu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mi á poi du ná wan sani mi wawan. Ma, leti enke fa mi yee en a mi Tata, na so mi e kuutu sani. Da a kuutu fu mi de leti. Bika mi nái suku mi wani, ma mi e suku a wani fu mi Tata di sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Efu mi e taki sani fu miseefi, da a taki fu mi á de leti. ");
INSERT INTO djkNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma wan taawan de, di e taki sani fu mi. Da mi sabi taki san ai taki fu mi de, leti enke fa ai taki den tuu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bika luku. U be sende sama go a Johanisi fu akisi en sani. Ne a piki u, leti enke fa a de tuu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ma toku seefi, mi nái teke a taki fu libisama. Ma mi be taki disi namo fu u be sa komoto a ini takuudu anga ogii kon a Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Bika Johanisi be de enke wan lampu di be de leti leti e kiin dyelle. Da a be bun gi u fu wan pisiten fu aliki san a be e taki. ");
INSERT INTO djkNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ma mi abi sani ete di e taki moo taanga fu mi moo enke den wowtu di Johanisi be taki. Dati na den wooko di mi Tata be sende mi fu du ya. Bika den gaan foondoo foondoo wooko di mi e du ya, na den seefi wooko ya e soi taki na mi Tata be sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Da soseefi mi Tata di be sende mi kon, seefi e taki sani fu mi. Ma, u á be yee en tongo wan dei. U á si en fesi wan dei, te go taki fu sabi en. ");
INSERT INTO djkNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Da soseefi a wowtu fi en á de a ini u ati ini fu alaten. Bika u á wani biibi a sama di a be sende kon. ");
INSERT INTO djkNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","U e feti e suku sani a ini Gadu Buku. Fu di u denki taki a ini Gadu Buku u sa fende a libi fu tego. We, na so a de tuu. Bika na mi a Buku de e taki. ");
INSERT INTO djkNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ma u á wani kon a mi fu u fende a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mi nái suku nen a libisama. ");
INSERT INTO djkNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma mi sabi taki fa u e meke de, u á lobi Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mi Tata sende mi kon a ini en nen, ma u nái oli mi fu wan sani. Te wan taawan o kon a ini en eigi nen, da u o gaapu en gwulu oli seefi. ");
INSERT INTO djkNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ma fa u o du biibi? Bika u e suku nen a useefi. Ma u nái feti fu fende nen a Gadu a tapu anda. ");
INSERT INTO djkNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“U á mu denki taki mi o tyai u go kaagi u a mi Tata. Nono! Kweti kweti! Wan taawan de di de kaba kaba fu kaagi u. Dati na Mosesi di i si u e poti fitoow. ");
INSERT INTO djkNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","We bika, efu u be e biibi Mosesi tuutuu, da u be o biibi mi tu. Bika ala den sani di Mosesi sikiifi, na sani fu mi a be e sikiifi. ");
INSERT INTO djkNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ma, di u nái biibi san a sikiifi, da fa u o du biibi mi?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ne baka wan pisiten, ne Masaa Jesesi go a ini wan sipi fu koti a ze fu Galileya di den e kai Tibeliyasi abaa go na abaase. ");
INSERT INTO djkNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Da a yuu ten de, da wan gaan ipi sama be e waka a futu e faaka Masaa Jesesi e kon, fu di den be si den gaan foondoo sani, di a be du, deesi den sikiman. ");
INSERT INTO djkNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Na dati meke Masaa Jesesi subi a wan pikin mongo tapu go sidon anga den bakaman fi en. ");
INSERT INTO djkNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Da a ten de, da a gaan piisii fu den Dyu di den e kai Pasika be de koosube. ");
INSERT INTO djkNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","We, ne di Masaa Jesesi opo ede di a si taki na tyaipi sama kon ne en so, ne a akisi Filipi taki: “Filipi, pe u sa bai beele fu den sama ya fende nyan?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ma fa a akisi en de seefi, na akisi a akisi en fu luku fa a o piki. Bika Masaa Jesesi be sabi bunbun san a be wani du. ");
INSERT INTO djkNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ne Filipi piki en taki: “Efu u bai wan miliyun anga onmen dunsu kolu beele seefi, toku a ná o sai den sama ya. Winsi ibii sama teke wan pikin pisi seefi.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ne wan fu den bakaman fi en di den e kai Andeleyasi, a baala fu Simon Peitilisi taigi en taki: ");
INSERT INTO djkNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Wan pikin boi de ya di abi feifi pikin beele anga tu fisi. Ma san dati o poi yeepi den somen sama ya?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ne Masaa Jesesi taigi den taki: “Meke ala sama go sidon.” Bika a peesi be abi tyaipi gaasi. We, ne den go sidon. Da a be sa de wan sani fu feifi dunsu manengee so. ");
INSERT INTO djkNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ne Masaa Jesesi teke den beele, ne a begi gi Masaa Gadu daa moi te a kaba, ne a paati gi den sama di be sidon. Da soseefi a paati den tu fisi gi den sama. ");
INSERT INTO djkNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Da ala sama nyan te den bee fuu. Ne di den kaba nyan, ne Masaa Jesesi sende den bakaman fi en fu den go piki den pisipisi beele di den sama nyan fika. Bika a nyanyan á mu poli. ");
INSERT INTO djkNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ne den go piki den pisipisi beele di fika. Ne den piki te twalufu bakisi fuu kwaa anga a pisi fu a beele di den sama be nyan fika. ");
INSERT INTO djkNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","We, ne di den sama si a gaan foondoo sani di Masaa Jesesi du ya, ne a bigi gi den te, ná sipowtu. Ne den taki: “Fu tuu, a sama ya na a apaiti takiman fu Masaa Gadu di a be paamisi fu sende kon a goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ma namo, di Masaa Jesesi sabi taki den wani kon kisi en anga taanga fu meke a toon den kownu, ne a go fi en na a mongo tapu go de en wawan. ");
INSERT INTO djkNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ne di sapaten, ne den bakaman fi en go na a ze. ");
INSERT INTO djkNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ne den go a ini wan sipiboto e koti abaa go na a Kafalnayemu. Da a yuu de, da peesi be kon e dunguu kaba. Ma Masaa Jesesi á be go anga den. ");
INSERT INTO djkNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma namo, wan gaan taanga winta e wai na a ze e seke a wataa hei den paana te, ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ne di den go wan sani fu feifi kilomeiti so, ne den si Masaa Jesesi e waka na a wataa tapu e kon miti den na a sipiboto. Ne den feele, te ná sipowtu. ");
INSERT INTO djkNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma a taigi den taki: “U á feele! Na mi!” ");
INSERT INTO djkNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ne di a taigi den so, ne den ati koo. Ne den teke en poti kon a ini a sipi. Ne wanten den doo tu a pe den be e go. ");
INSERT INTO djkNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Da a taa dei fi en, da somen sama be de na abaase fu a ze e foondoo. Den á be sabi on se Masaa Jesesi be go. Bika taa boto moo enke di den bakaman fi en be go a ini á be de ape. Da Masaa Jesesi á be gwe anga den a ini a boto. ");
INSERT INTO djkNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Da a yuu de, da wantu boto fu a kondee di den e kai Tibeliyasi be kon koosube na a peesi, pe Masaa Jesesi be teke a beele gi Masaa Gadu daa, paati gi den sama. ");
INSERT INTO djkNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma di den sama si taki Masaa Jesesi anga den bakaman fi en á de ape, ne den go a ini wan sipiboto, ne den go a Kafalnayemu go suku en. ");
INSERT INTO djkNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ne di den go, ne den si en na a abaase fu a ze. Ne den akisi en taki: “Labai, on yuu i kon ya?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ne Masaa Jesesi piki den taki: “Fu tuutuu mi e taigi u taki, u nái kon suku mi, fu di u be si den foondoo sani di mi du. Ma na fu di u be nyan a beele te a sai u. ");
INSERT INTO djkNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","U á suku nyanyan di e oli u fu wan pisiten naamo. Ma u suku a nyanyan, di a Manpikin di saka kon toon libisama ya e gi u, fu fende libi di de tego. Bika ne en u Tata, Masaa Gadu, be naki sitampu taki, a bun.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ne den akisi en taki: “We, fa u mu du fu u sa du den wooko di Masaa Gadu wani meke u du?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ne a piki den taki: “We, san Masaa Gadu wani, na fu u biibi Awan di a sende kon ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","We, ne den akisi en taki: “We, sowtu maiki yu o du gi u fu u sa sabi taki na yu u mu biibi? ");
INSERT INTO djkNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","We bika, den avo avo fu wi be nyan mana*f9* di den be a ini a gaan sabana ini. Bika Buku sikiifi taki: ‘A gi den beele komoto a Gadu Kondee a tapu fu den nyan.’ ” ");
INSERT INTO djkNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ne Masaa Jesesi piki den taki: “Fu tuutuu mi e taigi u taki, a ná Mosesi be gi den a beele di be e komoto a tapu. Ma na mi Tata e gi u a tuutuu beele di komoto a Gadu anda. ");
INSERT INTO djkNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bika a nowfosi a tuutuu beele komoto a tapu saka kon a goontapu. Da a tuutuu beele ya, e gi ala sama a libi fu tego.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ne den taigi en taki: “We, Masaa, gi wi a beele de fu u nyan alaten, no?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma Masaa Jesesi taigi den taki: “Na mi na a beele fu libi. Sama di kon a mi, noiti moo angii sa kii en. Da sama di e biibi a mi, noiti moo dee wataa sa kisi en. ");
INSERT INTO djkNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mi be taigi u kaba. U e si mi, ma toku u nái biibi. ");
INSERT INTO djkNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ala den sama di mi Tata gi mi o kon a mi. Da ala sama di kon a mi, mi ná o daai den baka, fu sende den gwe. ");
INSERT INTO djkNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bika mi á komoto a tapu kon a goontapu fu du mi wani. Ma fu du a wani fu mi Tata di sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Da san na a wani fu mi Tata? Dati na taki mi á mu meke ná wan fu den sama di a gi mi go lasi. Ma mi mu weki den na a kiiboi dei puu a dede. ");
INSERT INTO djkNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Da, disi na a wani fu mi Tata di sende mi kon. Iniiwan sama di si a Manpikin fi en, ne den biibi en, da a sama de abi a libi fu tego. Da a sa weki so wan sama puu a dede na a kiiboi dei.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ma den Dyu e kuutu fu di a taigi den taki en na a beele di komoto a tapu saka kon a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Den taki: “Tan! A sama ya, a ná a manpikin fu Jowsef, di den e kai Jesesi, no? U sabi en dda anga en mma. Da fa a sa taki, taki a komoto a tapu saka kon a goontapu?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ne Masaa Jesesi piki den taki: “U á kuutu kuutu fu dati. ");
INSERT INTO djkNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ná wan sama sa kon a mi, efu a ná mi Tata di be sende mi kon ali en kon a mi. Da mi sa weki en baka puu a dede na a kiiboi dei. ");
INSERT INTO djkNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Da wan fu den apaiti takiman fu Masaa Gadu be sikiifi taki: ‘Na Gadu seefi e leli ala sama.’ Da iniiwan sama di e aliki a Tata, ne a teke san di Masaa Gadu e leli en, da so wan sama musu kon a mi. ");
INSERT INTO djkNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ná wan sama be si Masaa Gadu wan dei, boiti Awan di komoto a Masaa Gadu. Ne en wawan too, si en.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Fu tuutuu mi e taigi u: “Iniiwan sama di biibi a mi, da a sama de abi a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mi na a beele di e gi sama libi. ");
INSERT INTO djkNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Den avo avo fu u be nyan a mana a ini a gaan sabana, ma toku den dede. ");
INSERT INTO djkNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ma, u luku a beele di komoto a tapu saka kon a goontapu ya. Da, efu wan sama nyan a beele ya, da a ná o dede. Ma yu o fende a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mi na a beele di e gi libisama libi. Na Gadu mi komoto. Da a sama di o nyan a beele ya, abi a libi fu tego. Da a beele di mi e taki ya, na mi sikin dugu dugu di mi o gi fu ala libisama ede.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma namo, ne den Dyu bigin sitee anga denseefi. Den taki: “Fa a sa gi wi en sikin dugu dugu meti fu nyan?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma Masaa Jesesi taigi den taki: “Fu tuutuu mi e taigi u, efu u á teke a sikin fu a Manpikin di saka kon toon libisama ya fu nyan, da u teke a buulu fi en diingi, da yu ná abi libi ete. ");
INSERT INTO djkNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","A sama di o teke a mi sikin nyan, ne a teke mi buulu diingi, da a abi a libi fu tego kaba. Da mi sa weki en puu a dede na a kiiboi dei. ");
INSERT INTO djkNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Bika mi sikin na tuutuu nyanyan anga mi buulu na tuutuu diingi. ");
INSERT INTO djkNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","We, efu wan sama teke mi sikin nyan, ne a teke mi buulu diingi, da ai tan a ini mi. Da soseefi mi e tan a ini en tu. ");
INSERT INTO djkNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Da na mi Tata di abi ala libi sende mi kon. Da, leti enke fa mi Tata di e gi libi gi mi libi, da na letiso den sama di nyan mi sikin sa libi, bika mi e gi den libi. ");
INSERT INTO djkNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","We, na fu dati ede meke mi taigi u taki, mi na a beele di saka komoto a tapu kon a goontapu. A á de enke a mana di den avo avo fu u be nyan a ini a gaan sabana ini. Bika anga ala fa den be nyanmi en de seefi, toku den dede. Ma, efu wan sama nyan a beele ya, da a sa abi libi fu tego.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Da Masaa Jesesi be leli den sama ala den sani ya di a be de a ini a keliki a Kafalnayemu. ");
INSERT INTO djkNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma di somen fu den sama di be e waka ne en baka yee san a taki, ne den taki: “A sani di a taigi u de taanga. Da sama o poi teke a sani de?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma fu di Masaa Jesesi be sabi kaba a ini en ati taki na so den sama di e waka ne en baka e kuutu fu san di a taki, ne a taigi den taki: “Oho! San meke u mandii so? Na a sani di mi taigi u de taanga gi u fu teke so? ");
INSERT INTO djkNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","We, da on fa a o de gi u seefi, te u o si, a Manpikin di saka kon toon libisama ya, o opo go a tapu baka a pe a be komoto? ");
INSERT INTO djkNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na a Jeje fu Masaa Gadu e gi libi. Libisama á poi gi i libi. Bika den wowtu di mi taki gi u de e tyai a Jeje fu Masaa Gadu kon gi u. Da a Jeje fu Masaa Gadu ya e gi libi. ");
INSERT INTO djkNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","“Ma son sama de a u mindii di ná biibi.” Bika Masaa Jesesi be sabi kaba, sama anga sama á be o poti biibi ne en. Da soseefi a be sabi sama be o seli en tu. ");
INSERT INTO djkNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ne a taigi den taki: “Na fu dati ede meke mi be taigi u taki, ná wan sama sa kon a mi, efu a ná mi Tata gi en a okasi.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ne fanafu a ten de, ne somen fu den sama di be e waka ne en baka, daai baka gi en. Den á wani waka anga en moo. ");
INSERT INTO djkNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ne Masaa Jesesi daai, ne a akisi den twalufu bakaman fi en taki: “We, on fa? U wani gwe tu?” ");
INSERT INTO djkNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ne Simon Peitilisi piki taki: “Masaa! Sama wi sa go moo so? We bika, i abi wowtu di e gi sama tego libi! ");
INSERT INTO djkNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","U poti biibi a yu, bika u sabi taki yu na a Apaiti Sama fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ne Masaa Jesesi piki den taki: “A ná u twalufu mi be teke kon toon fu mi wawan, no? Ma wan fu u na wan didibii.” ");
INSERT INTO djkNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Da na a Judasi, a pikin fu Simon Iskaliyotu, ne na a sama di a be e taki. Bika en na be wan fu den bakaman fu Masaa Jesesi tu. Da anga ala fa en na be wan fu den twalufu bakaman fu Masaa Jesesi de seefi, toku a seli Masaa Jesesi a bakaten. ");
INSERT INTO djkNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","We, ne bakadati, ne Masaa Jesesi e waka e lontu a den kondee kondee fu Galileya. A á go a den kondee kondee fu Judeja moo. Bika den edeman fu den Dyu be e suku en fu kii. ");
INSERT INTO djkNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Da a yuu de, da wan piisii fu den Dyu be de koosube. Da na a piisii ya, da den Dyu e meke somen masanga, enke fa den gaansama fu den be meke a ini a gaan sabana ini.*f10* ");
INSERT INTO djkNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ne den baala fi en kon akisi en taki: “San i de ya e du? Go a Judeja meke den sama di e waka a yu baka si den wooko fi yu di yu e du tu. ");
INSERT INTO djkNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ná wan sama di e suku balinen, o de kibii kibii e du sani bakabaka. Go anda meke lanti si taki yu e du den sani de.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bika den baala fi en seefi á be e biibi en. ");
INSERT INTO djkNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma Masaa Jesesi piki den taki: “Mi yuu á doo ete. Ma u yuu doo kaba, bika u sa go alaten u wani. ");
INSERT INTO djkNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bika den sama fu kondee á buuse u. Ma mi den nái si na ain seefi. Bika mi e taigi den kiinkiin taki den nái libi bun enke fa Gadu wani. ");
INSERT INTO djkNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","U wawan go. Mi ná o go na a piisii ya. Bika mi yuu á doo ete.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ma namo, di Masaa Jesesi taki so, ne a fika fi en a Galileya de. ");
INSERT INTO djkNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ma di den baala fi en go kaba, ne enseefi teke pasi fu go na a piisii ya. Ma a á be waka gaangaan fu ala sama si en. Ma a be waka kibii kibii. ");
INSERT INTO djkNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","We, di a de na a piisii ya kaba, ne den edeman fu den Dyu e suku en. Den e akisi namo taki: “Pe a de? Pe a sama de?” ");
INSERT INTO djkNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","We, ne ala den sama bigin wan takitaki anga denseefi fu Masaa Jesesi ede. Son fu den e gafa en taki en na wan bunbun sama. Taawan taki: “Ho! Nono! Na wan bidiigiman. Ai bidiigi sama.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ma den á be e taki fu ala sama yee. Bika den be e feele den edeman fu den Dyu. ");
INSERT INTO djkNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","We, di den sama be pasa a mindii fu a piisii ya, ne Masaa Jesesi opo go a ini a Mama Keliki. Ne ai leli den sama. ");
INSERT INTO djkNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma den edeman fu den Dyu foondoo te, den taki: “Fa a man ya du sabi sani fu Gadu Buku so? A á be go a sikoo fu leli den sani de!” ");
INSERT INTO djkNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ma namo, Masaa Jesesi piki den taki: “Den sani di mi e leli, a ná fu miseefi, ma na fu Gadu di sende mi kon a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Efu wan sama e angii fu du san Gadu taki, da enseefi sa si, efu den sani di mi e leli na fu Gadu, efu na fu miseefi. ");
INSERT INTO djkNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A sama di e taki sani fi enseefi, da na balinen ai suku gi enseefi. Ma a sama di e taki e suku balinen gi a sama di sende en kon, da so wan sama, na wan tuutuu sama. Falisi fasi á de a ini en.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ne Masaa Jesesi akisi baka taki: “A ná Mosesi be gi u den weiti fu Gadu, no? Ma ná wan fu den weiti ya di u e oli. We bika, saide meke u e suku fu kii mi?” ");
INSERT INTO djkNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ne den piki en taki: “Wan didibii de a yu tapu. Sama e suku fu kii yu?” ");
INSERT INTO djkNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ne Masaa Jesesi piki den taki: “Na wankodo wooko mi du, ne ai dangaa u so kaba. ");
INSERT INTO djkNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosesi be gi u wan weiti taki, u mu koti den pikin manpikin fu u poti a maiki gi den. A wansi na Mosesi seefi poti den weiti gi u fu oli, ma na den gaansama be meke den. Ma toku u e wooko anga a weiti ya a kina dei. ");
INSERT INTO djkNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","We, efu u sa koti wan pikin manpikin a kina dei poti a maiki gi en, soso fu di a weiti fu Mosesi á mu booko, da saide meke u e kuutu, fu di mi deesi wan hiihii libisama a kina dei? ");
INSERT INTO djkNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","U á mu kuutu sani, enke fa u si den anga ain. Ma u mu wegi den sani go wegi den kon, da u kuutu den a wan leti fasi.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma wantu Dyusama fu Jelusalem e akisi taki: “A ná a man ya den edeman fu wi be e suku fu kii, no? ");
INSERT INTO djkNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ne a de a lanti mindii ya e taki so meke ala sama e si? Da sama á de ya fu tapu enseefi. A sa de taki den gaansama fu u si taki a man ya na a Kelestesi? ");
INSERT INTO djkNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma te a Kelestesi o kon, ná wan sama o sabi pe a o komoto. Ma a sama ya, u sabi en bunbun. Da u sabi on se a komoto.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","We, ne Masaa Jesesi bali taki moo taanga a pe a be de na a Mama Keliki de e leli den sama. A taki: “Eeye! U sabi mi! U sabi pe mi komoto tu! Ma anga ala fa u sabi mi de, toku mi á kon fu miseefi. Ma na wan sama sende mi kon. Da a sama ya á de wan sama di e lei. Ma u á sabi a sama di sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ma mi, mi sabi en. Bika na anda mi komoto. Ne en sende mi kon ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ne di a taki so, ne den e suku wan fasi fu kisi en. Ma toku ná wan sama di naki ana ne en, bika en yuu á be doo ete. ");
INSERT INTO djkNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ma somen fu den sama be daai kon e biibi ne en. Ne den akisi taki: “Te Kelestesi o kon, a o du moo gaan foondoo sani moo den di a sama ya e du?” ");
INSERT INTO djkNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ma namo, da den Faliseiman yee taki somen sama e biibi taki Masaa Jesesi na a Kelestesi. Na fu dati ede meke den Faliseiman anga den begiman fu keliki sende sikowtu fu go kisi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma Masaa Jesesi piki den taki: “Mi o tan wan pisiten anga u ete. Ma bakadati, da mi o daai go baka, na a sama di be sende mi kon a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Da u o suku mi, ma u ná o fende mi. Da soseefi tu, u ná o poi kon a pe mi o de.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ne den edeman fu den Dyu kuutu kuutu anga den seefi. Den taki: “Da pe a o go te u ná o si en moo? A sa de taki a o go a den taa kondee pe den Dyu paati paati go e tan fu a go leli den Giiki sama? ");
INSERT INTO djkNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","San na a sani di a taki de, taki: ‘Wi o suku mi, ma u ná o fende mi.’ Anga taki pe ai go u ná o poi go anda? San wani taki dati?” ");
INSERT INTO djkNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ma namo, da a kiiboi dei fu a piisii e bigi moo ala den taa dei. We, ne a dei de, ne Masaa Jesesi opo taampu, ne a bali taki taanga taki: “Sama di dee wataa kisi, meke a kon a mi kon diingi. ");
INSERT INTO djkNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Bika a sikiifi a Gadu Buku taki, liba fu wataa di e gi libi o lon komoto a ini wan sama di teke biibi a mi, ati, e kon a doo.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Da anga ala fa Masaa Jesesi taki ya, da na a Jeje fu Masaa Gadu a be e taki. Bika a Jeje fu Masaa Gadu e gi libi. Da Masaa Gadu o gi den sama di e biibi ne en, a Jeje fi en. Bika a á be gi den sama a Jeje fi en ete, fu di Masaa Jesesi á be opo go fu Masaa Gadu fu teke a waiti fasi fi en ete. ");
INSERT INTO djkNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","We, son sama di be yee den toli fu Masaa Jesesi be taki: “Eeye! Fu tuu! Disi na a apaiti takiman fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Taawan taki: “Eeye! Disi na a Kelestesi seefi.” Taawan baka taki: “Sama taki so? Na Galileya a Kelestesi be o komoto? ");
INSERT INTO djkNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","We bika, Masaa Gadu Buku taki: ‘A Kelestesi na wan bakaten Manpikin fu Kownu Dafeti paansu. Da na Betelehem a o komoto, a pe Kownu Dafeti be e tan.’ ” ");
INSERT INTO djkNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","We, na so paati kon a den sama mindii fu Masaa Jesesi ede. ");
INSERT INTO djkNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Son fu den be wani go kisi en. Ma toku seefi ná wan sama di naki ana ne en. ");
INSERT INTO djkNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","We, di den sikowtu daai go baka a den apaiti begiman fu a Mama Keliki anga den Faliseiman, ne den akisi den taki: “Saide meke u á kisi en tyai kon?” ");
INSERT INTO djkNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ne den sikowtu piki den taki: “Di u go a taki anga u. Ma namo, di u yee fa ai taki, da u si taki ná wan sama u be yee taki so wanten.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Oho! San u taki. A koli u kisi tu? ");
INSERT INTO djkNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Di u de ya, u si taki wan fu den edeman fu u efu wan fu den Faliseiman, biibi ne en wan dei? ");
INSERT INTO djkNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","U á sabi taki na den sama ya di á sabi ná wan sani fu Gadu weiti e biibi ne en, no? We, heelu fu den!” ");
INSERT INTO djkNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","We, ne Nikodeimisi, wan gaan edeman fu den Dyu, di be kon a Masaa Jesesi wan neti, akisi den taki: ");
INSERT INTO djkNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“We, fa a weiti fu u de? U sa kuutu wan sama gi en sitaafu sondee fu ondoosuku en fini fini fosi? Efu sondee fu u sabi san a du?” ");
INSERT INTO djkNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ne den piki en taki: “Oho! I toon fu Galileya tu? Go ondoosuku luku a Gadu Buku fini fini. Da i sa si taki noiti wan apaiti takiman fu Masaa Gadu o komoto a Galileya Kondee.” ");
INSERT INTO djkNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ne di den taki so kaba, ne den booko paati, ne den go a osu. ");
INSERT INTO djkNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma Masaa Jesesi dati go na a mongo di den e kai Oleifi Mongo. ");
INSERT INTO djkNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Da a taa dei fi en, fuuku mamanten, ne a kon baka a ini a Mama Keliki fu den Dyu. Da ala sama be e kon ne en. Ne a go sidon, ne ai leli den. ");
INSERT INTO djkNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma den leliman fu weiti anga den Faliseiman tyai wan uman kon ne en. Den kisi a uman ya anga e du ogii ne en man osu. Ne den tyai en kon poti a mindii na ala den sama fesi. ");
INSERT INTO djkNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ne den taigi en taki: “Mesiti, den kisi a uman ya dyonson dyonson ya e du ogii ne en man osu. ");
INSERT INTO djkNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesi be sikiifi gi wi a ini a weiti taki, efu u kisi so wan sama u mu naki en anga siton kii. Da san yu e taki fu a uman ya?” ");
INSERT INTO djkNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ma a sani di den be akisi Masaa Jesesi ya, na akisi den be akisi en fu tesi en anga fu den fende sani fu go kaagi en. Ma Masaa Jesesi bendi, ne ai sikiifi anga en finga a doti. ");
INSERT INTO djkNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma di den tan e akisi en naamo, ne a opo baka, ne a taigi den taki: “Sama fu u di á du ogii wan dei, da meke a fiingi a fosi siton naki a uman.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ne a bendi baka e sikiifi a doti. ");
INSERT INTO djkNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma di den yee so, ne ala den fiya go a doo. Den gaanwan anga den yonkuwan, wan fu wan a taawan baka. Den moo gaanwan a fesi, den yonkuwan a baka. Ne na so den fika Masaa Jesesi anga a uman wawan de, enke fa den be tyai en kon poti. ");
INSERT INTO djkNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","We, di Masaa Jesesi opo, ne a akisi en taki: “Uman! Pe den sama di be tyai i kon kaagi de? Ná wan sama kuutu yu, no?” ");
INSERT INTO djkNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ne a uman piki en taki: “Masaa, ná wan sama.” Ne Masaa Jesesi taigi en taki: “We, miseefi nái kuutu yu tu. Go a osu. Ma ná du ogii moo.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Da wan taa leisi, da Masaa Jesesi be e leli den sama baka. Ne a leli den taki: “Mi na a leti fu goontapu. A sama di o waka kon a mi baka, a ná o waka a ini dunguu. Ma a sa abi a leti di e gi libi.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma now, ne den Faliseiman taigi en taki: “Yu e taki fu iseefi. Da wi á poi teke a taki fi i de taki na tuu.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ma Masaa Jesesi piki den taki: “Winsi mi e taki fu miseefi, toku a taki fu mi na tuu. Bika mi sabi pe mi komoto anga pe mi e go. Ma u á sabi pe mi komoto, efu pe mi e go. ");
INSERT INTO djkNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","U e kuutu na libisama fasi. Ma mi nái kuutu ná wan sama. ");
INSERT INTO djkNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ma winsi mi kuutu wan sama seefi, toku a kuutu fu mi na tuu. Bika a ná mi wawan e kuutu, ma mi Tata di be sende mi kon de anga mi. ");
INSERT INTO djkNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A ini u weiti seefi a sikiifi taki, te tu sama kotoigi fu wan sani, da a de tuu. ");
INSERT INTO djkNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","We, miseefi taki fu miseefi, ma mi Tata di be sende mi kon e taki fu mi tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ne den akisi en now taki: “Pe yu Tata de?” Ma Jesesi piki den taki: “U á sabi mi. Da soseefi u á sabi mi Tata tu. Bika, efu u be sabi mi, da u be o sabi mi Tata.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Da Masaa Jesesi be de koosube fu a baki pe den e tyai moni kon poti gi Masaa Gadu a ini a Mama Keliki fu den Dyu. Ma ná wan sama di kisi en. Bika en ten á be kisi ete. ");
INSERT INTO djkNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ne Masaa Jesesi taigi den taki: “Mi e gwe. Da u o suku mi. Ma u sa dede a ini u takuudu anga ogii. Pe mi e go u ná o poi kon anda.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ne den Dyu edeman taki: “We, on se a o go, di a taki pe ai go u ná o poi kon anda? A sa de taki, na kii a o go kii enseefi?” ");
INSERT INTO djkNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma a piki den taki: “U na fu ondoo ya. Ma mi na fu tapu anda. U na fu a goontapu ya, ma mi a ná fu a goontapu ya. ");
INSERT INTO djkNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Na fu dati ede meke mi be taigi u taki, u sa dede a ini u takuudu anga ogii. Bika, efu u á wani teke taki mi na a sama, di mi taigi u taki mi de, da u o dede a ini u takuudu anga ogii.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ma now den akisi en taki: “We, sama na yu seefi?” Ne Masaa Jesesi piki den taki: “We, leti enke fa mi be taigi u kaba na a bigin, na a seefi sama de mi de. ");
INSERT INTO djkNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mi abi somen sani di mi sa teke kuutu u. Bika a sama di sende mi kon, na tuutuu sani ai taki. Da na san a taigi mi, na dati mi e taigi goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma den á fusutan taki na sani fi en Tata a be e taki. ");
INSERT INTO djkNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Na fu dati ede meke Masaa Jesesi taigi den taki: “Na te u opo a Manpikin di saka kon toon libisama ya, fosi u o sabi sama ne en. U o sabi taki, a nái du nái wan sani fi enseefi. Bika na san di en Tata leli en, na dati ai taki. ");
INSERT INTO djkNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Da, enke fa Gadu sende mi kon ya, da a de anga mi. A nái fika mi wawan. Bika alaten mi e du san kai anga en.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Da di Masaa Jesesi taki so, ne somen sama daai kon e biibi ne en. ");
INSERT INTO djkNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","We, ne Masaa Jesesi taigi den Dyu di be e biibi ne en taki: “Efu u teke den sani di mi e leli u, da u sa de tuutuu bakaman fu mi. ");
INSERT INTO djkNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Da u sa sabi den tuutuu sani fu Gadu. Da te u kon sabi den sani ya so kaba, da a sa meke u fii komoto a saafu, fu u de boo boo.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ne den taigi en taki: “Wi na pikin fu Abalaham. Noiti u be de saafu fu wan sama. Da fa yu e taki, u sa kon fii, komoto a saafu, fu de boo boo?” ");
INSERT INTO djkNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ne Masaa Jesesi piki den taki: “Fu tuutuu mi e taigi u taki, a sama di e du ogii, en na wan saafu fu ogii. ");
INSERT INTO djkNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","We, efi i de wan saafu e wooko gi wan sama, da na saafu namo i de e go e kon. I nái tan fu ala ten a ini osu. Ma a manpikin fu a sama di yu e wooko gi e tan fu alaten a ini a osu. ");
INSERT INTO djkNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","We, efu a Manpikin puu yu a saafu a katibo, meke i fii, da i fii tuutuu. ");
INSERT INTO djkNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mi sabi taki u na pikin fu Abalaham. Ma u e suku fu kii mi. Bika u nái teke den sani di mi e leli u. ");
INSERT INTO djkNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Da na san mi Tata soi mi, na dati mi e leli. Ma u e du san u tata taigi u fu du.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ne den taigi Masaa Jesesi taki: “Abalaham na wi tata.” Ne Masaa Jesesi taigi den taki: “Efu u na be pikin fu Abalaham, da u be o du den sani di Abalaham be e du. ");
INSERT INTO djkNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma now u e suku fu kii mi. Mi di e leli u den tuutuu sani di Masaa Gadu soi mi. Noiti wan ten Abalaham be o du so wan sani. ");
INSERT INTO djkNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Na den wooko fu u tata u e du.” Ne den taigi Masaa Jesesi taki: “Wi a ná basa nengee. Wi abi wankodo Tata, dati na Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ne Jesesi taigi den taki: “Efu Gadu na be u Tata, da u be o lobi mi. Bika na Gadu sende mi kon. A ná miseefi komoto kon, ma na Gadu sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ma u sabi saide u nái fusutan san mi e taki? Na fu di u á wani aliki mi. ");
INSERT INTO djkNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Na didibii na u tata. Da na san di bun a u tata, na dati u e du. Fanafu a bigin, ne ai kii libisama. A á poi de a ini den tuutuu sani fu Gadu. Bika tuu á de ne en ati ini seefi seefi. Na soso lei a sabi fu lei. Bika en na wan leiman, a tata fu lei. ");
INSERT INTO djkNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma u á wani biibi mi fu den tuutuu sani fu Gadu di mi teke taigi u. ");
INSERT INTO djkNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","On di fu u sa soi finga a mi taki, mi du ogii wan dei? We, efu na tuutuu sani mi e taki, da saide meke u nái biibi mi? ");
INSERT INTO djkNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sama di de fu Gadu o teke Gadu wowtu. Ma na fu di u a ná sama fu Gadu, na fu dati ede meke u á wani aliki Gadu wowtu.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ma now, ne den Dyu piki en taki: “We, u be taigi yu kaba taki, didibii de a yu tapu, yu ogii sani Samaliya sama yu!” ");
INSERT INTO djkNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ma Masaa Jesesi piki den taki: “Didibii á de a mi tapu. Na lesipeki mi e lesipeki mi Tata. Ma u nái lesipeki mi. ");
INSERT INTO djkNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mi nái suku lesipeki gi miseefi. Ma wan sama de di e suku en gi mi. Da na a sama ya e kuutu, leti enke fa a mu de. ");
INSERT INTO djkNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Fu tuutuu mi e taigi u taki: ‘Efu wan sama teke den sani di mi e leli ya, da a ná o dede noiti wanten moo.’ ” ");
INSERT INTO djkNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ne den Dyu taigi en taki: “A nowfosi u e si kiinkiin taki na didibii de a yu tapu. Bika Abalaham dede kaba. Da soseefi den fositen apaiti takiman fu Gadu seefi dede tu. Ne toku i de ya e taki, taki efu wan sama teke den sani di yu e leli, da a ná o dede noiti wanten moo. ");
INSERT INTO djkNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","I bigi moo wi tata Abalaham efu wan fu den fositen apaiti takiman fu Gadu di dede kaba? San yu e denki fi i seefi?” ");
INSERT INTO djkNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ne Masaa Jesesi piki den taki: “Efu mi e suku lesipeki gi mi seefi, da a lesipeki fu mi na wan soso lesipeki. Ma a mi Tata di u taki na a Gadu fu u, ne en e hei mi. ");
INSERT INTO djkNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","U á sabi en, ma mi sabi en. Da, efu mi taki, taki mi á sabi en, da mi na wan leiman enke u tu. Ma mi sabi en, da mi e du san a taki. ");
INSERT INTO djkNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","U tata Abalaham be piisii fu tuu, fu di a sabi taki a o si a dei di mi o kon a goontapu ya. Ma a si en tu. Da a piisii, te ná sipowtu.” ");
INSERT INTO djkNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma den Dyu taigi en taki: “Yu á doo feifitenti yali ete seefi, ne yu e bali taki, i be si Abalaham?” ");
INSERT INTO djkNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ne Masaa Jesesi taigi den taki: “Fu tuutuu mi e taigi u taki: ‘Mi de bifo Abalaham be de.’ ” ");
INSERT INTO djkNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","We, di a taki so, ne den lon go teke siton fu naki en kii. Ma Masaa Jesesi pasa a den sama mindii kuli, komoto a Mama Keliki osu gwe fiyaa. ");
INSERT INTO djkNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ne di Masaa Jesesi e gwe de, ne a miti wan man. Da fanafu a man ya kon a goontapu a be de beendi beendi. ");
INSERT INTO djkNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ne den bakaman fi en akisi en taki: “Labai! Saide meke a man ya meke kon de beendi beendi so? Sama fu a man ya du ogii? Ne en seefi du ogii? Ofu ne en dda anga en mma?” ");
INSERT INTO djkNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ne Masaa Jesesi piki den taki: “A ná ogii a man ya du. Soseefi a ná en mma anga dda du ogii tu. Ma a sani ya pasa anga en fu a kaakiti fu Gadu mu kon a kiin. ");
INSERT INTO djkNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","We, mi mu wooko den wooko fu a sama di sende mi kon, solanga dei de. Bika neti e kon, da ná wan sama o poi wooko moo. ");
INSERT INTO djkNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Da solanga mi de a goontapu, mi na a leti fu goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Di a taigi den so, ne a towe wataa mofu a doti, ne a meke poto poto anga en. Ne a teke a papa doti, ne a lobi na a beendiman ain. ");
INSERT INTO djkNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ne a taigi a beendiman taki: “Go wasi i fesi a ini Silowam*f11* Peti.” We, ne a sama go, ne a wasi en fesi. Ne a man gwe anga kiinkiin ain. ");
INSERT INTO djkNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","We, ne den sama di e tan koosube fi en, anga den sama di be sabi en a fositen di a be beendi ete taki: “Tan, a ná man di be sidon ya e begi moni, no?” ");
INSERT INTO djkNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Wantu fu den baka taki: “Iya! Ne en!” Taawan taki: “Nono, ma a gei en!” Ma a man seefi taki: “Iya! Na mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ne den akisi en taki: “We, on fa yu ain du opo te yu e si sani?” ");
INSERT INTO djkNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ne a piki taki: “Na wan sama di den e kai Jesesi meke wan poto poto lobi a mi ain. Ne a sende mi fu mi go wasi mi fesi a Silowam Peti. Ne mi go, ne mi wasi mi fesi, ne mi ain kon kiin.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ne den akisi en baka taki: “Pe a sama de, de?” Ne a man piki den taki: “We, mi á sabi.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","We, ne den teke a man di be beendi fosi, ne den tyai en go a den Faliseiman. ");
INSERT INTO djkNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ma namo, da a dei di Masaa Jesesi be meke a poto poto opo a man ya ain, na be wan kina dei fu den Dyu. ");
INSERT INTO djkNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ne den Faliseiman akisi a man ya fa en ain be du opo. Ne a sama taigi den taki: “Na poto poto a teke poti a mi ain. Ne mi go wasi mi fesi, ne na so mi ain opo.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ne son fu den Faliseiman taki: “A sama de, a ná wan sama fu Gadu! Bika a ná oli a kina dei!” Ma den taawan taki: “Fa wan ogiilibi sama sa du so wan gaan foondoo sani?” Na so den bigin anga wan takitaki anga denseefi. ");
INSERT INTO djkNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ne den akisi a man di be beendi baka taki: “We, san yu e taki fu a sama di opo yu ain de?” Ne a man piki den taki: “We, na wan apaiti takiman fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma now den Dyu á wani biibi moo seefi taki a be beendi a fesi, ma now a sa si baka. Ne den kai en dda anga en mma kon. ");
INSERT INTO djkNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ne den akisi den taki: “San u e taki? A sama ya na u pikin di u taki be meke beendi beendi? Fa a du taki a sa si now?” ");
INSERT INTO djkNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma a dda anga a mma piki den taki: “Wi sabi taki na wi pikin. Da soseefi wi sabi taki a be meke beendi beendi. ");
INSERT INTO djkNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ma fa a du kon taki ai si baka, dati u á sabi. Da wi á sabi tu sama meke ai si baka. En seefi bigi sai kaba fu taki. U akisi en meke enseefi taki.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ma na fu di en dda anga en mma be e feele den Dyu edeman, meke den be taki so. Bika den edeman be tapu pasi gi den kaba taki, efu wan sama taki, taki Jesesi na a Kelestesi, da den o puu so wan sama na a keliki. ");
INSERT INTO djkNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Na fu dati ede meke en dda anga en mma be taigi den taki meke den akisi en enseefi, a bigi sai kaba fu taki. ");
INSERT INTO djkNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ne den kai a man di be beendi kon baka a den di fu tu toon. Ne den taigi en taki: “Man, sweli a Gadu fesi taki na wan tuutuu sani yu o taki. Bika u sabi taki a sama di yu e taki opo yu ain de na wan ogiilibi sama.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ne a man piki den taki: “Efu a man de na wan ogiilibi sama mi á sabi. Ma san mi sabi, na taki mi be beendi, ma now mi e si.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ne den akisi en taki: “San a du gi yu? Fa a du opo yu ain?” ");
INSERT INTO djkNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ne a man piki den taki: “Mi be taigi u kaba, ma u á wani yee mi. Saide meke u wani meke mi taki a sani ete wan toon? A wani u wani toon bakaman fi en tu?” ");
INSERT INTO djkNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ma now, ne den kosi a man. Den taki: “Nono! Na yu na wan bakaman fu a man de. Ma wi na bakaman fu Mosesi. ");
INSERT INTO djkNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wi sabi taki anga Mosesi Gadu be taki. Ma u á sabi seefi seefi, pe a sama ya komoto.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ne a man piki den taki: “We, da a foondoo mi, di u taki u á sabi pe a man ya komoto. Bika a opo mi ain. ");
INSERT INTO djkNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bika wi sabi taki Gadu nái piki a begi fu wan ogiilibi sama. Ma na sama di e lesipeki en e du sani a taki, na den begi fu den ai piki. ");
INSERT INTO djkNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Fu senten di goontapu de, wi á yee noiti ete taki, wan sama be opo wan sama di meke beendi beendi ain. ");
INSERT INTO djkNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Efu a sama ya, a ná Gadu a be komoto, da a á be o poi du so wan sani.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ne den piki en taki: “Yu á sabi taki na takuudu anga ogii meke den be meke i beendi beendi so, no? Ne san yu abi fu kon leli wi?” Ne den toto en puu poti a doo. ");
INSERT INTO djkNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","We, di Masaa Jesesi yee taki den yaki a man toto en puu poti a doo, ne di a miti anga en baka, ne a akisi en taki: “We, on fa? Yu e biibi na a Manpikin di saka kon toon libisama ya?” ");
INSERT INTO djkNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ne a man piki en taki: “Masaa, on pe a sama de de? Mi wani biibi ne en!” ");
INSERT INTO djkNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ne Masaa Jesesi piki en taki: “We, na a sama di i si e taki anga yu ya, ne disi!” ");
INSERT INTO djkNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ne a man taki: “Masaa, mi e biibi!” Ne a saka anga kini a doti gi en gaandi. ");
INSERT INTO djkNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ne Masaa Jesesi taki: “We, i si fa mi kon a goontapu ya, da na kon mi kon fu meke libisama kuutu paati anga denseefi, fu den beendiman daai kon sa si anga fu den di e si daai kon toon beendiman.” ");
INSERT INTO djkNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","We, son fu den Faliseiman di be de ape anga en yee tu san a taigi a man ya. Ne den akisi en taki: “Fa i taki de, we, da u beendi tu?” ");
INSERT INTO djkNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ne Masaa Jesesi taigi den taki: “Efu u be piki taki u be beendi, da u á be o du ogii. Ma fu di u taki u ain kiin kaba, da na fu dati ede meke u fika a ini ogii.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Fu tuutuu mi e taigi u taki: “A sama di e suku fu pasa a wan taa peesi go a ini a pen fu den sikapu boiti a doo, na wan fufuuman efu wan kiiman. ");
INSERT INTO djkNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma, a sama di e waka pasa na a doo go a ini a pen fu den sikapu, ne en na wan soluguman fu den sikapu. ");
INSERT INTO djkNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Te a kon, da wanten a man di e oli waki na a pen e opo a doo fu a pen gi en. Da o kai den sikapu fi en a nen, da den sikapu o yee en tongo. Da a o tyai den puu a ini a koi go a doo. ");
INSERT INTO djkNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Da te a tyai den go a doo, da ai waka a den fesi, da den sikapu e waka ne en baka. Bika den sikapu sabi en tongo. ");
INSERT INTO djkNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma te taa sama o kon, da den ná o komoto go waka ne en baka. Ma den o lon gwe, bika den á sabi a sama de.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ma Masaa Jesesi be gi den a ageisi toli ya. Ma den á be fusutan seefi seefi san a be wani taki. ");
INSERT INTO djkNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ne Masaa Jesesi taigi den taki: “Fu tuutuu mi e taigi u ete wan toon taki, miseefi na a doo di sama sa waka pasa go a ini a pen fu den sikapu. ");
INSERT INTO djkNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ibii sama di be kon a mi fesi, na soso fufuuman anga kiiman. Na fu dati ede meke den sama ná aliki den, leti enke fa i si sikapu nái fitoow wan sama di den á sabi. ");
INSERT INTO djkNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Da leti enke fa i si wan sama sa waka pasa a wan opo opo doo go a ini wan osu, da na letiso mi de fu u waka pasa go a ini fu fende a bun solugu fu Gadu. Na mi na a doo fu a koi fu den sikapu fu Gadu. A mi u sa go a ini kon a doo on ten u wani. ");
INSERT INTO djkNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ma wan fufuuman, te a kon, ai kon namo fu fufuu anga kii anga booko sani poli kaba a soso. Ma mi kon fu gi libi a libi tapu te a pasa peesi.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mi na a bunbun soluguman fu den sikapu. Da leti enke fa i si a soluguman fu den sikapu e kibii den sikapu fi en, na letiso mi sa gi mi libi fu kibii den bakaman fu mi tu fu sani á du den. ");
INSERT INTO djkNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma wan sama di den yuu fu luku den sikapu, di á de wan soluguman, á de so. Bika ná en abi den sikapu. Da te a si wan takuu meti e kon, da wanten wanten ai lon gwe fika den sikapu wawan. Da a takuu meti o kon, da a kisi son fu den. Da a yaki den paati. ");
INSERT INTO djkNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A sama di den be yuu lon gwe fi en. Bika na yuu namo den yuu en. A ná abi toobi anga den sikapu, bika a ná fi en. ");
INSERT INTO djkNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ma mi na a bunbun soluguman fu den sikapu. Mi sabi den sikapu fu mi, da den sikapu fu mi seefi sabi mi tu. ");
INSERT INTO djkNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Leti enke fa i si mi anga mi Tata sabi useefi, na letiso mi anga den sikapu fu mi sabi useefi tu. Da mi ná abi toobi fu dede gi den. ");
INSERT INTO djkNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma mi abi taa sikapu ete, di á de na a kulu ya ete. Da den dati seefi mi mu tyai kon na a kulu ya tu. Bika den o yee mi tongo, da den kon a mi. Da na so a o de: Wankodo ipi sikapu anga wankodo soluguman. ");
INSERT INTO djkNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Da mi Tata lobi mi, fu di mi e gi mi libi fu dede gi den sikapu fu teke en baka. ");
INSERT INTO djkNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ná wan sama o puu mi libi a mi. Nono! Kweti kweti! Ma na anga miseefi wani mi e dede. Mi abi a taanga fu dede. Ma soseefi mi abi a taanga fu teke mi libi baka tu. Bika na mi Tata seefi sende mi fu du dati.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Da den wowtu fu Masaa Jesesi di a taki ya, meke den Dyu kisi den wan gaan toobi anga denseefi. ");
INSERT INTO djkNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Somen fu den taki: “Na wan takuu jeje de na a man de tapu! Ai law! Saide meke u taampu de e aliki en ete?” ");
INSERT INTO djkNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Taawan taki: “Na so wan sama di takuu jeje de ne en tapu e taki? Wan takuu jeje sa opo wan beendiman ain fu meke ai si baka?” ");
INSERT INTO djkNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Da a yuu de, da den be abi wan piisii fesa fu den a Jelusalem. Da te den be e nyan a piisii ya, da den be e pakisei a ten di den be e wei a Mama Keliki gi Masaa Gadu. Da na a moo koo pisiten fu a yali a ini Islayeli Kondee. ");
INSERT INTO djkNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","We, ne Masaa Jesesi de fi en, e koi na den baikon fu a Mama Keliki di den be e kai a Baikon fu Salomo. ");
INSERT INTO djkNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","We, ne den Dyu kon lontu en de, ne den akisi en taki: “We, man, on langa yu o daai daai u ete? Taigi u kiinkiin. Yu na a Kelestesi? Taigi u meke u sabi.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ne Masaa Jesesi piki den taki: “Mi be taigi u kaba. Ma u á wani biibi mi san mi taigi u. Bika den wooko di mi e du, a mi Tata nen e soi kiinkiin sama a mi. ");
INSERT INTO djkNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma u nái biibi mi. Bika u a ná mi sikapu. ");
INSERT INTO djkNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Den sikapu fu mi e waka a mi baka. Bika den sabi mi tongo, da den e du san mi taki. Da soseefi, miseefi sabi den tu. ");
INSERT INTO djkNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Da mi e gi den a libi fu tego. Noiti wanten den sa lasi go kaba a soso moo. Da soseefi ná wan sani sa puu den a ini mi ana ini. ");
INSERT INTO djkNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Bika mi Tata di gi mi den, bigi moo ala san di de. Da ná wan sama di poi puu den a ini mi Tata ana ini tu. ");
INSERT INTO djkNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bika mi anga mi Tata na awan.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ma now di a taki a sani ya, ne den Dyu teke siton baka fu naki en kii. ");
INSERT INTO djkNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma Masaa Jesesi taigi den taki: “Mi du somen gaan foondoo foondoo wooko a u mindii fu soi u a kaakiti fu Gadu. We, fu on di fu den sani ya ede, meke u wani naki mi kii anga siton?” ");
INSERT INTO djkNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","We, ne den Dyu piki en taki: “We, a ná fu wan fu den foondoo foondoo wooko di i du meke u wani kii yu. Ma na fu di yu e oli Gadu a sipowtu. Bika yu na wan kuwownu libisama enke u ya. Ma yu e poti iseefi enke Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ne Masaa Jesesi piki den taki: “A ná a ini useefi weiti a taki, Masaa Gadu taki: ‘U na gadu, no?’ ");
INSERT INTO djkNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","We, wi sabi taki san Masaa Gadu Buku e taki na tuu fu alaten. Da Masaa Gadu e kai den sama di e teke a bosikopu fi en, gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","We, efu na den kuwownu libisama de a kai gadu, da fa fu Awan di Masaa Gadu teke poti apaiti fasi gi enseefi, sende kon a goontapu? Fa u sa taigi mi taki, mi e oli Masaa Gadu a sipowtu, fu di mi taki, mi na a Manpikin fu Masaa Gadu? ");
INSERT INTO djkNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","We, efu u si taki a ná den wooko fu mi Tata mi e du, da u ná abi fu biibi mi. ");
INSERT INTO djkNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ma, efu na den wooko fu mi Tata mi e du, da u ná abi fu biibi mi seefi, ma u biibi den wooko. Bika te u biibi den wooko, da u sa kon fusutan fu sabi taki: A Tata de a ini mi. Da soseefi mi de a ini a Tata tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ma di Masaa Jesesi taki so, ne den e suku baka fu kisi en tyai gwe. Ma a waka saafi komoto a den ini de gwe. ");
INSERT INTO djkNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ne a koti go na abaa fu a Joodani Liba, a pe Johanisi be e dopu sama fosi. Ne a tan de. ");
INSERT INTO djkNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ne somen sama kon ne en taki: “Na tuu. Johanisi a á be e du ná wan foondoo sani. Ma ala san di a be taki fu a sama ya, ala den fiya na tuu.” ");
INSERT INTO djkNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","We, somen sama kon e biibi a Masaa Jesesi di a de ape. ");
INSERT INTO djkNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ma namo, da wan man Lasalesi be de a wan pikin foto den e kai Betaniya. Da wan uman den e kai Maliya be e tan de tu anga en sisa Malita. Ma namo, da Lasalesi be kai a siki. ");
INSERT INTO djkNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Da a Maliya ya, na a seefi uman di o tutu a sumee switi fatu a Masaa Jesesi futu dee Masaa futu baka anga en ede uwii. Da ne en baala Lasalesi be kai a siki. ");
INSERT INTO djkNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Da den tu sisa fu Lasalesi ya sende bosikopu gi Masaa Jesesi taki: “Masaa! I lobi mati kai a siki.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma di Masaa Jesesi yee a bosikopu, ne a taki: “A siki di a siki de, a ná wan siki di o kii en. Ma a siki o meke Masaa Gadu fende gaandi. Bika a Manpikin fu Masaa Gadu seefi o fende gaandi.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","We, Masaa Jesesi be lobi Malita anga en sisa anga Lasalesi tuutuu. ");
INSERT INTO djkNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ma toku di a yee taki Lasalesi siki, a tan tu dei moo a pe a be de. ");
INSERT INTO djkNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ne Masaa Jesesi taigi den bakaman fi en taki: “Meke u go baka a Judeja!” ");
INSERT INTO djkNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma den bakaman fi en taigi en taki: “Labai! Wantu dei pasa, den sama fu Judeja be wani kii yu anga siton, ne yu o go anda baka?” ");
INSERT INTO djkNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma Masaa Jesesi piki den taki: “A ná twalufu yuu wan dei abi, no? We, sama di e waka a dei, ná o naki en futu. Bika ai si a leti fu a goontapu ya. ");
INSERT INTO djkNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ma sama di e waka a neti, o naki en futu. Bika a ná abi ná wan leti. ");
INSERT INTO djkNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ne baka di a taki a sani ya, ne a taigi den bakaman fi en taki: ‘A mati fu wi, Lasalesi siibi. Ma mi e go anda fu weki en.’ ” ");
INSERT INTO djkNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","We, ne den bakaman fi en taigi en taki: “We, efu ai siibi, da a o betee.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ma na a dede fu Lasalesi Masaa Jesesi be e taki. Ma den bakaman fi en be denki taki na fu siibi wawan a be e taki. ");
INSERT INTO djkNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","We, na fu dati ede meke Masaa Jesesi taigi den kiinkiin taki: “Lasalesi dede kaba. ");
INSERT INTO djkNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma na fu u ede, mi piisii fu di mi á be de ape. Bika u abi a sani di o pasa de fanowdu. A o meke u a biibi fu u kon moo taanga. Ma, u meke u go ne en nownow.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ma, Towmasi, di den be e kai Toolengi*f12*, taigi den taa bakaman fu Masaa Jesesi taki: “Meke u go anga en fu u sa dede anga en.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","We, di Masaa Jesesi kon a Betaniya, ne den taigi en taki: “Lasalesi de a ini geebi fo dei kaba.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Ma somen Dyu be komoto a Jelusalem kon a Betaniya fu kee pina anga Malita anga Maliya fu a dede fu a baala fi en. Bika Jelusalem anga Betaniya be sa de wan sani fu dii kilomeiti so koosube anga denseefi. ");
INSERT INTO djkNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","We, fa i si Malita yee taki Masaa Jesesi kon de, ne wanten a opo go miti en. Ma Maliya fika sidon sidon a osu. ");
INSERT INTO djkNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ne Malita taigi Masaa Jesesi taki: “Masaa! Efi i be de ya, mi baala á be o dede. ");
INSERT INTO djkNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ma toku, now mi sabi taki ala sani di i begi akisi Masaa Gadu, a o gi yu en.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ne Masaa Jesesi taigi en taki: “Malita! I baala o opo baka!” ");
INSERT INTO djkNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ne Malita taigi en taki: “We, Masaa, mi sabi taki a o opo baka te ala den dede sama o opo baka na a kiiboi dei.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ne Masaa Jesesi piki en taki: “Mi na a sama di e weki sama puu a dede. Na mi na a sama di e gi libi. Sama di e biibi a mi, sa libi, wansi a dede. ");
INSERT INTO djkNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Da sama di de a libi, ne ai biibi a mi, ná o dede ná wan ten! Yu e biibi dati?” ");
INSERT INTO djkNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ne Malita taigi en taki: “Iya, Masaa! Mi e biibi taki yu na a Kelestesi, a Manpikin fu Masaa Gadu di be mu kon a goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","We, ne di Masaa Jesesi taki so, ne Malita go, ne a kai en sisa saafi taki: “A Mesiti kon kaba, ai kai yu.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","We, di Maliya yee so, ne a opo pala, waka go a Masaa. ");
INSERT INTO djkNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Bika Masaa Jesesi á be doo a ini a kondee ete, ma a be de a pe a be taki anga Malita ete. ");
INSERT INTO djkNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","We, sama fu Judeja di be de a ini osu de be e gi en taanga sikin. Namo di den si taki, Maliya opo pala waka go a doose, ne den waka go ne en baka. Den denki taki, ai go na a geebi fu go kee anda. ");
INSERT INTO djkNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","We, di Maliya doo na a peesi pe Masaa Jesesi de, di a si en, ne a kai a Masaa Jesesi futu, ne a taki: “Masaa, efi i be de ya, mi baala á be o dede, baa!” ");
INSERT INTO djkNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ma namo, di Masaa Jesesi si Maliya anga den taa sama fu Judeja di be kon ne en e kee so, ne wan gaan tyali kisi en a ini en ati. ");
INSERT INTO djkNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ne Masaa Jesesi akisi den taki: “On pe u poti en?” Ne den taigi en taki: “Masaa, kon, da i sa si!” ");
INSERT INTO djkNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ma namo, ne wataa lon a Masaa Jesesi ain pala pala. ");
INSERT INTO djkNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Na fu dati ede meke den Dyu taki: “Kee! Luku fa a be lobi en, baa.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma wantu fu den taki: “We, a ná a man ya be e meke den beendiman kon si baka, no? Ne fa a waka a á be poi yeepi a man ya, fu a á dede?” ");
INSERT INTO djkNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ma wan gaan tyali kisi Masaa Jesesi baka a ini en ati. Ne na so a go na a geebi. Ma namo, da a geebi ya na be wan siton olo. Da den be tapu a geebi mofu anga wan siton. ");
INSERT INTO djkNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","We, ne Masaa Jesesi taki: “U puu a siton na a geebi mofu!” Ma Malita, a sisa fu a man di dede, taigi en taki: “Masaa! Ai tingi kaba. Bika na fo dei kaba di a de a ini a geebi.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma Masaa Jesesi piki en taki: “Mi á be taigi i kaba taki, efi i biibi, yu o si a hei fasi fu Gadu, no?” ");
INSERT INTO djkNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","We, ne den puu a siton na a geebi mofu. Ne Masaa Jesesi opo ede luku tapu, ne a taki: “Mi Tata! Gaantangi fi yu fu di a de taki i yee mi kaba. ");
INSERT INTO djkNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mi sabi tuutuu taki yu e yee mi alaten. Ma na fu den sama di taampu lontu ya ede meke mi e taki so, fu den sa kon biibi taki na yu be sende mi kon a goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","We, ne di Masaa Jesesi taki so, ne a bali kai Lasalesi taanga taki: “Lasalesi! Kon a doo!” ");
INSERT INTO djkNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","We, ne a dedesama komoto kon a doo. En futu anga en ana de teitei anga geebi koosi ne en sikin. Da en fesi seefi be de teitei anga wan koosi. Ne Masaa Jesesi taigi den taki: “U losi en meke a go!” ");
INSERT INTO djkNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","We, di den sama di be kon a Maliya si a sani di Masaa Jesesi du, ne den daai kon e biibi ne en. ");
INSERT INTO djkNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma wantu fu den go a den Faliseiman go taigi den san Masaa Jesesi du. ");
INSERT INTO djkNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","We, na fu dati ede meke den Faliseiman anga den apaiti begiman fu a Mama Keliki, kai wan gaan kuutu makandii, anga a Dyulanti di e kuutu sani. Ne den e akisi taki: “San wi mu du? We, bika a sama e du somen somen foondoo foondoo wooko. ");
INSERT INTO djkNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Efu wi á luku bun, da ala sama o daai kon e biibi ne en. Da den Loma o kon feti booko a Mama Keliki anga a nasi fu wi kaba a soso.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma Kayafasi, wan fu den man, di be de a moo hei apaiti begiman, na a yali de, taigi den taki: “U á sabi ná wan sani! ");
INSERT INTO djkNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","U á sabi taki a moo bun fu wankodo sama dede gi a nasi, moo enke pe fu a hii nasi dede go kaba a soso, no?” ");
INSERT INTO djkNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ma a ná enseefi be taki a sani de. Ma na fu di a be de a moo hei apaiti begiman a yali de, na fu dati ede meke Masaa Gadu be meke a taki den wowtu ya taki: “Masaa Jesesi mu dede gi a hii nasi. ");
INSERT INTO djkNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma a ná den Dyu wawan a o dede gi, ma a o tyai ala den sama fu Masaa Gadu, di de paati paati a hii goontapu, kon makandii a wan ipi.” ");
INSERT INTO djkNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","We, ne fanafu a dei di de oli a kuutu de, ne den poti taki den sa kii en namo. ");
INSERT INTO djkNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","We, na fu dati ede meke Masaa Jesesi á be e waka a na a pisiwataa fu Judeja moo a pe ala sama sa si en. Ma a komoto de go a wan foto den e kai Efalamu, di de koosube fu wan sabana. Ne en anga den bakaman fi en de ape. ");
INSERT INTO djkNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ma namo, da a Pasika Piisii fu den Dyu be de koosube fu doo. Da somen sama fu a pisi de, be subi go a Jelusalem fu go kiin denseefi enke fa a weiti taki fu den be sa de kaba kaba fosi a Pasika Piisii doo. ");
INSERT INTO djkNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Di den taampu a ini a Mama Keliki, ne den be e suku Masaa Jesesi. Den e akisi den na den taki: “San u denki? U denki taki a o kon fu nyan a Pasika Piisii ya?” ");
INSERT INTO djkNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bika den hei apaiti begiman anga den Faliseiman be poti taki, efu wan sama sabi pe a de, den mu taigi den, fu den go kisi en. ");
INSERT INTO djkNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Da sigisi dei fosi a Pasika Piisii, ne Masaa Jesesi kon baka a Betaniya, a pe a be weki Lasalesi puu a dede. ");
INSERT INTO djkNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Da di a kon, ne den sama seeka nyanyan gi en di sapaten doo. We, Malita be e sete tafaa. Da Lasalesi na be wan fu den sama di be de a tafaa de fu nyan anga Masaa Jesesi ");
INSERT INTO djkNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ne Maliya teke wan gaan dii sumee switi fatu, ne a kandi ala a Masaa Jesesi futu te a kaba. Ne a dee Masaa Jesesi futu baka anga en ede uwii. Ne a hii osu fuu kwaa anga a sumee fu a sumee switi fatu ya. ");
INSERT INTO djkNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma wan fu den bakaman fi en, Judasi Iskaliyotu, di be o seli en taki: ");
INSERT INTO djkNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Saide meke den á seli a fatu ya, da den be gi den pootiman a moni? Bika, efu den be seli en, da den be o fende tyaipi moni. Bika beina a wan hii yali i mu wooko fosi i sa fende a moni fu bai a oli ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ma a á be taki den sani fu den pootiman ede. Bika a ná pootiman be ati en so. Ma ne en be e oli a monisaka, fu poti ala moni di sama be e gi den. Da a be e fende a moni e fufuu bun. ");
INSERT INTO djkNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ma Jesesi taigi en taki: “U fika en! A be de fanowdu fu a kibii a fatu ya te enke a dei fu tide fu towe a mi futu fu lesipeki mi fu a dei di den o beli mi. ");
INSERT INTO djkNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Den pootiman de alaten anga u ya. Ma mi ná o de alaten a u mindii.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","We, di somen fu den sama fu Judeja yee taki Masaa Jesesi de ape, ne den kon de tu. Da den á be kon fu Masaa Jesesi ede wawan, ma fu den be sa si Lasalesi di Masaa Jesesi be weki puu a dede tu. ");
INSERT INTO djkNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Da den hei apaiti begiman meke mofu, kuudei anga den seefi, fu kii Lasalesi tu. ");
INSERT INTO djkNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Bika na fi en ede meke somen fu den sama fu Judeja di be go de, fika a leli fu den Dyu edeman ya, daai kon e biibi a Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ne a taa dei, ne den somen sama di be kon na a piisii yee taki Masaa Jesesi de a pasi e kon a Jelusalem. ");
INSERT INTO djkNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ne den teke palon taka oli a den ana, ne den go a doose go miti en a pasi. Ne den e bali baaya gi en taki: “Hosana! Seigi fu Awan di e kon a ini a nen fu Masaa. Seigi fu a Kownu fu Islayeli sama!” ");
INSERT INTO djkNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Da Masaa Jesesi be fende wan buliki, ne a subi go sidon ne en tapu. Da a sani ya waka leti enke fa a be sikiifi a Gadu Buku taki: ");
INSERT INTO djkNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“U á feele, sama fu Siyon! U luku a kownu fu u, sidon a wan pikin yonkuu buliki tapu e kon.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma a yuu ten de, da den bakaman fu Masaa Jesesi á be fusutan en ete. Ma bakaten di a dede weki go fende a waiti fasi fi en, fosi, ne den kon sabi taki, na so wan sani fi en be sikiifi a Gadu Buku anga fa denseefi be du den sani ya gi en. ");
INSERT INTO djkNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Da ala den somen sama di be de anga en di a be weki Lasalesi puu a dede, be e taigi taa sama fa a be kai Lasalesi puu a ini a geebi olo weki en puu a dede. ");
INSERT INTO djkNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Da na fu dati ede meke i si somen sama be lon go miti Masaa Jesesi so, fu di den be yee taki a so wan gaan foondoo sani a be du. ");
INSERT INTO djkNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma den Faliseiman taigi den na den taki: “U si? Wi á poi du ná wan sani fu oli den. Bika hii goontapu lon go ne en go e waka ne en baka.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Da wantu Giiki sama be de a ini fu den somen sama di be kon fu begi Masaa Gadu tu na a piisii ya. ");
INSERT INTO djkNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","We, ne den kon a Filipi, wan fu den bakaman fu Masaa Jesesi di be e tan a Betisaida na a pisiwataa fu Galileya, ne den begi en taki: “Man, gaantangi, u wani miti anga Masaa Jesesi, baa.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","We, ne Filipi komoto, ne a go taigi Andeleyasi. Ne Filipi anga Andeleyasi komoto, ne den go taigi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma Masaa Jesesi piki den sama taki: “We, a yuu doo kaba, di a dyendee fasi fu a Manpikin di saka kon toon libisama ya, mu kon a doo.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ne Masaa Jesesi taigi den go doo taki: “Fu tuutuu mi e taigi u, solanga wan ain kalu de, ma a á kai a doti fu poli, da na a wankodo ain kalu de wawan o tan. Ma, efu a kai a doti poli, da fosi a o goo kon meke tyaipi nyanyan. ");
INSERT INTO djkNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A sama di e feti fu kibii en libi sa lasi en. Ma sama di ná abi toobi fu lasi en libi a goontapu ya fu mi ede, sa fende libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Efu wan sama wani dini mi, da a mu e waka a mi baka. Bika mi wani meke den sama di e dini mi mu de a pe mi de. Da mi Tata o hei den sama di wani fu dini mi gi den gaan lesipeki.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","We, ne Masaa Jesesi taki baka taki: “We, enke fa mi de ya, da mi ati de anga fuka. Ma san mi sa taki? Mi sa begi mi Tata fu a puu den sani di de a fesi fu kon miti mi? Ma nono! Bika na fu a sani ya ede, meke mi be kon, fu nyan gaan pina na a yuu ya. ");
INSERT INTO djkNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mi Tata! Meke libisama si a hei fasi anga a kaakiti fi i di yu abi!” We, ne wan Tongo taki a tapu anda taki: “Mi meke libisama si a waiti fasi anga a kaakiti fu mi kaba. Da mi sa meke den si en ete moo anga moo.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","We, ne den sama di taampu de yee di a Tongo taki. Ne den taki: “Donduu e bali!” Taawan taki: “Na wan Basiya fu Masaa Gadu Kondee*f13* taki anga en.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ma Masaa Jesesi piki den taki: “A ná fu mi ede meke a Tongo ya taki. Ma na fu u ede. ");
INSERT INTO djkNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","We, bika a yuu doo kaba fu Gadu kuutu goontapu. Da now, den o puu a edeman fu a goontapu ya ne en tii. ");
INSERT INTO djkNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma mi, te den sa opo mi,*f14* da mi sa ali ala sama kon a mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Da Masaa Jesesi be taki den sani ya, fu soi den sowtu dede a be o dede. ");
INSERT INTO djkNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ma den sama piki en taki: “We, a sikiifi a Gadu Buku taki, a Kelestesi o libi fu tego. We, da fa i du e taki, den o opo a Manpikin di saka kon toon libisama ya? Sama yu e kai a Manpikin di saka kon toon libisama ya?” ");
INSERT INTO djkNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ne Masaa Jesesi taigi den taki: “U waka a ini a leti, solanga u leti ya de a mindii ete, fu dunguu á kon kisi u. We bika, na wan pikin pisiten namo, a leti ya de a u mindii ete. Bika a sama di e waka a ini dunguu á sabi na on se ai go. ");
INSERT INTO djkNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","We, u poti biibi na a leti ya tapu, solanga a de a u mindii ete. Da u sa toon pikin fu a leti.” We, ne na so Masaa Jesesi taki, ne a gwe. Ne a kibii enseefi gi den. ");
INSERT INTO djkNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Bika anga ala fa den be si den foondoo wooko di Masaa Jesesi be e du de seefi, toku seefi den á be wani poti biibi ne en. ");
INSERT INTO djkNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","We, da na so a sani, di a fositen apaiti takiman fu Masaa Gadu di den be e kai Jesaja be taki kon tuu. Bika a be taki: “Masaa! Sama be biibi a bosikopu di u be e tyai? Da ná wan sama de di sabi bunbun san na den foondoo.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","We, na fu dati ede meke den á poi biibi, leti enke fa Jesaja be taki baka taki: ");
INSERT INTO djkNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Masaa Gadu dunguu den ain, fu den á si sani. Da soseefi a taanga den ati, fu den á poi fusutan den sani fi en. Da den á poi daai den libi kon, fu mi deesi den.” ");
INSERT INTO djkNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Da na fu di Jesaja be si a hei fasi fi en anga a waiti fasi di a be o abi. ");
INSERT INTO djkNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ma anga ala fa, toku somen fu den edeman fu den Dyu daai kon e biibi ne en. Ma na fu den Faliseiman ede meke den á be wani meke taa sama sabi. Bika, efu den Faliseiman be yee, den be o puu den na a keliki. ");
INSERT INTO djkNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bika den be wani abi bun nen a sama, moo enke pe fu den suku bun nen a Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma Masaa Jesesi taki anga moo taanga tongo taki: “Sama di e biibi a mi, a ná mi wawan namo ai biibi, ma ai biibi na a sama di sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Da sama di e si mi, á si mi wawan, ma a si a sama di sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mi kon a goontapu enke wan leti, fu meke ibii sama di biibi a mi á tan a dunguu. ");
INSERT INTO djkNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma kaba, efu wan sama yee san mi e leli, ne a á biibi, mi ná o kuutu en. Bika mi á be kon fu sitaafu goontapu, ma mi kon fu puu den a dede gi den tuutuu libi. ");
INSERT INTO djkNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ma sama di poti mi a wanse, ne a á wani teke a leli fu mi, da so wan sama abi en kuutuman kaba. Da a seefi leli di a yee mi e leli ya, sa kuutu en na a kiiboi dei. ");
INSERT INTO djkNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bika den sani di mi e leli, a ná mi seefi sani. Ma na mi Tata di sende mi kon, ne enseefi be taigi mi san mi mu taki anga fa mi mu taki den. ");
INSERT INTO djkNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Da mi sabi taki den sani di a sende mi fu mi taki ya, e yeepi sama, fu den fende a libi fu tego. Da san mi e taki, na san mi Tata be taigi mi fu taki.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Da a yuu de, da a Pasika Fesa be de koosube kaba. Da Masaa Jesesi be sabi taki a yuu fi en doo fu a fika a goontapu ya go ne en Tata. Ma namo, da Masaa Jesesi be lobi den sama fi en alaten, ma now, da a o soi den fa a lobi di a be lobi den ala den yuu bigi. ");
INSERT INTO djkNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ne, di den e nyan na a sapaten, da a didibii be poti a pakisei gi Judasi, a pikin fu Simon Iskaliyotu kaba a ini en ati ini fu a seli Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","We, Masaa Jesesi be sabi taki en Tata be poti ala sani a ini en ana. Bika a sabi taki na Masaa Gadu a komoto, da na Masaa Gadu ai go baka tu. ");
INSERT INTO djkNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ne Masaa Jesesi opo, ne a puu en dyakiti poti a wanse. Ne a teke wan duku tei ne en mindii. ");
INSERT INTO djkNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne a kandi wataa poti a ini wan gaan beenki, ne a bigin wasi den bakaman fi en futu. Ne a teke a duku di a be tei en mindii, ne a dee den futu te a kaba. ");
INSERT INTO djkNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma di a doo Simon Peitilisi, ne Simon taigi en taki: “Nono Masaa! Yu o wasi mi futu?” ");
INSERT INTO djkNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma Masaa Jesesi piki en taki: “Simon, yu á sabi san mi e du ete. Ma bakaten yu o sabi.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ne Simon piki en taki: “Nono! Kweti kweti! Yu ná o wasi mi futu.” Ne Masaa Jesesi piki en taki: “Efu mi á wasi yu futu, da yu ná o poi de wan bakaman fu mi moo.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ne Simon taigi en taki: “Masaa, a ná mi futu wawan fi i wasi, ma wasi mi ana anga mi ede tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ne Masaa Jesesi piki en taki: “We, sama di wasi kaba, a á de fu den wasi en hii sikin moo. Ma ne en futu namo den mu wasi. Bika a kiin kaba. Ma fa u de ya u kiin kaba, ma a ná ala u fiya.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bika a be sabi sama be o seli en. A dati meke a taki, a ná ala den fiya kiin. ");
INSERT INTO djkNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","We, di a kaba wasi den futu kaba, ne a wei en dyakiti baka, ne a go teke en peesi a tafaa baka. Ne a akisi den taki: “U sabi san mi du gi u de? ");
INSERT INTO djkNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","U e kai mi, Mesiti. U e kai mi, Masaa. We, u abi leti tuu fu kai mi so. Bika a so mi de tuu. ");
INSERT INTO djkNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","We, leti enke fa mi, a Masaa anga a Mesiti fu u wasi u futu, na soseefi u mu wasi u na u futu tu. ");
INSERT INTO djkNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bika mi du a sani ya soi u, fu useefi du e gi taa sama, leti enke fa mi be du en gi u. ");
INSERT INTO djkNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Fu tuutuu mi e taigi u taki, wan futuboi á hei moo en masaa. Da soseefi wan bosikopuman á bigi moo a sama di sende en a bosikopu. ");
INSERT INTO djkNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","We, now u sabi den sani di mi e leli u. Da seigi fu u, efu u e du den tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ma a ná u ala fiya mi e taki. Bika mi sabi den sama di mi teke kon toon fu miseefi. Ma a wowtu fu Gadu Buku di taki: ‘A sama di de a tafaa e nyan beele anga mi opo en futu fu taampu mi,’ mu kon leti. ");
INSERT INTO djkNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mi e taigi u a sani ya a fesi. Fu te a pasa so, fu u sa sabi taki, na mi na a sama di mi be taigi u taki mi de. ");
INSERT INTO djkNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Fu tuutuu mi e taigi u taki, a sama di o teke wan sama di mi o sende kon, da na miseefi a teke de. Da a sama di o teke mi, da a teke a Sama di sende mi kon a goontapu tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Da di Masaa Jesesi taki a sani de, ne gaan tyali kon fuu en ati. Ne a taigi den kiinkiin taki: “Fu tuutuu mi e taigi u taki, wan fu u o seli mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ne di Masaa Jesesi taki so, ne den bakaman fi en luku denseefi te doo. Bika den á sabi on di fu den a be e taki. ");
INSERT INTO djkNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","We, wan fu den bakaman fi en, a bakaman di a be lobi te, de ne en se de. ");
INSERT INTO djkNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Na fu dati ede meke Simon Peitilisi soi en anga ana kibii kibii fu a akisi Masaa Jesesi sama na a sama di o seli en. ");
INSERT INTO djkNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","We, ne a diipi go moo koosube fu Masaa Jesesi, ne a akisi en taki: “Masaa! Sama na a sama di o seli yu?” ");
INSERT INTO djkNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ne Masaa Jesesi piki en taki: “A sama di mi o gi a pisi beele di mi o dipi go a ini a baafun ya, ne en o seli mi.” Ne na so Masaa Jesesi dipi a beele go a ini a baafun, ne a gi Judasi, a pikin fu Simon Iskaliyotu. ");
INSERT INTO djkNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ne di a teke a beele, ne wanten wanten, ne saatan, a didibii saka go a ini en ati ini. Ne Jesesi taigi en taki: “Go du san i mu du esi esi.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma ná wan fu den taawan di be de a tafaa be sabi fu saide meke Masaa Jesesi be taki so anga en. ");
INSERT INTO djkNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Son fu den be denki taki na fu di Judasi be e tyai a monisaka meke Masaa Jesesi be taigi en taki, fu a go bai sani fu den nyan a piisii, efuso fu a gi den pootiman wan sani. ");
INSERT INTO djkNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","We, ne di Judasi teke a beele, ne wanten, ne a go a doose. Ne neti kai, peesi be dunguu pii. ");
INSERT INTO djkNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","We, di Judasi go a doose kaba, ne Masaa Jesesi taigi den taki: “We, a yuu doo, di a hei di a Manpikin di saka kon toon libisama ya abi, mu kon fu si. Da a hei fu Gadu seefi o de fu si tu. ");
INSERT INTO djkNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","We, leti enke fa a be hei Gadu, da na soseefi Gadu o hei a Manpikin ya moo. Da na wanten wanten a o hei en. ");
INSERT INTO djkNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mi lobi wan. Wan pikin ten namo mi o de anga u ete. Da u o suku mi. Ma, leti enke fa mi be taigi den Dyu kaba, na so soseefi mi e taigi u now taki, pe mi e go, u ná o poi kon anda. ");
INSERT INTO djkNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mi o gi u wan nyunyun weiti fu u oli. Dati na taki: U mu lobi useefi. Leti enke fa mi be lobi u, na soseefi u mu lobi useefi tu. ");
INSERT INTO djkNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Da te u lobi useefi, da ala sama sa si taki u na bakaman fu mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ma now, ne Simon Peitilisi akisi en taki: “Masaa! On pe yu e go?” Ma Masaa Jesesi piki en taki: “Yu á poi kon anga mi a leisi di mi e go ya. Ma bakaten, da i sa go anga mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ne Peitilisi akisi en taki: “Masaa! Saide meke mi á poi go anga yu a leisi ya? Mi de kaba kaba fu lasi mi libi, fi yu ede!” ");
INSERT INTO djkNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ma Masaa Jesesi akisi en taki: “I de kaba kaba fu lasi yu libi fu mi ede, enke fa yu taki tuu? We, fu tuutuu mi e taigi yu taki, fosi wan kakafoo bali a neti ya, yu o lei dii toon taki, yu á sabi mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ne Masaa Jesesi taigi den bakaman fi en taki: “U ati á mu dege dege. U poti biibi a Gadu! Da soseefi u poti biibi a mi tu. ");
INSERT INTO djkNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Bika tanpeesi de nofu na pe mi Tata e tan. Efu a á be de so, da mi be o taigi u. Bika mi e go fu seeka peesi gi u. ");
INSERT INTO djkNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Da te mi go seeka u peesi te mi kaba, da mi o daai kon baka fu teke u tyai kon a mi, fu u sa de ape mi de tu. ");
INSERT INTO djkNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","We, u sabi pe mi e go. Da soseefi u sabi a pasi fu kon anda tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ne Towmasi piki en taki: “Nono, Masaa! Wi á sabi pe yu e go. Da fa wi o sabi a pasi fu kon anda?” ");
INSERT INTO djkNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ne Masaa Jesesi piki en taki: “We, na mi na a pasi. Na mi na a tuu. Na mi na a libi. Ná wan sama sa kon a mi Tata, efu mi á tyai en go ne en. ");
INSERT INTO djkNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Efu u sabi mi, da u o sabi mi Tata tu. We, fanafu now, da u sabi en. Bika u be si en.” ");
INSERT INTO djkNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ne Filipi taigi en taki: “Masaa! Soi wi a Tata, da a sai u kaba.” ");
INSERT INTO djkNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ne Masaa Jesesi piki en taki: “Fu on langa di mi de ya anga u, Filipi, ne yu á sabi mi ete? Sama di si mi, si mi Tata seefi. Da fa yu e akisi mi taki: ‘Soi u a Tata?’ ");
INSERT INTO djkNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yu nái biibi taki mi anga mi Tata de wan, no? U á de paati paati. Den sani di mi e leli u, a ná sani fu miseefi. Ma na a Tata di e tan a mi ini, ne en e du en wooko. ");
INSERT INTO djkNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Biibi mi, taki mi anga mi Tata á de paati paati, ma u de wan. Efuso, da u biibi mi fu den wooko namo. ");
INSERT INTO djkNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Fu tuutuu mi e taigi u taki, sama di poti biibi a mi, a sa du den wooko di mi e du tu. Da moo gaan wooko seefi a sa du. Bika mi e go a mi Tata. ");
INSERT INTO djkNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Da winsi san u sa begi akisi mi Tata a mi nen, da mi sa gi u, fu mi Tata mu kisi balinen na a Manpikin fi en. ");
INSERT INTO djkNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Iniiwan sani di u sa begi akisi na mi nen, mi sa gi u.” ");
INSERT INTO djkNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Efu u lobi mi, da u mu du san mi sende u fu du. ");
INSERT INTO djkNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Da mi sa begi a Tata, da a sa gi u wan taa Yeepiman, di o tan anga u fu tego. ");
INSERT INTO djkNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Dati na a Jeje fu Masaa Gadu, di e soi u den tuutuu sani fu Gadu. Da den sama fu a goontapu ya di á de a Gadu pasi ná o poi fende a Jeje ya. Bika den á si en. Da soseefi den á sabi en tu. Ma u sabi en, bika ai tan anga u. Da soseefi a o tan a ini u tu. ");
INSERT INTO djkNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Mi ná o fika u enke pikin di de sondee mma anga dda a baka. Mi o daai kon a u baka. ");
INSERT INTO djkNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pikinso moo, da goontapu ná o si mi moo. Ma u dati, u sa si mi. Bika mi o libi baka. Da u sa libi tu. ");
INSERT INTO djkNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Da a yuu ten de, da u sa si taki mi anga mi Tata á de paati paati. Ma u de wan. Da soseefi u o si taki mi anga u á de paati paati tu. Ma u de wan. ");
INSERT INTO djkNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Da sama di teke san mi e taigi en fu a du, ne ai du den, da so wan sama lobi mi. Da, efu wan sama lobi mi so, da mi Tata seefi o lobi en tu. Da mi seefi o lobi so wan sama tu. Da mi o opo miseefi gi en fu a kon sabi mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","We, ne wan taa Judasi, boiti Iskaliyotu, akisi Jesesi taki: “Masaa, san meke na u namo yu o opo iseefi gi? San meke i ná o opo yuseefi gi hii goontapu?” ");
INSERT INTO djkNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ne Masaa Jesesi piki en taki: “Sama di lobi mi, o go e du san a yee a mi. Da mi Tata o lobi en. Da mi anga mi Tata o kon, da wi o tan anga en. ");
INSERT INTO djkNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma, efu wan sama á lobi mi, da a ná o teke den wowtu di mi e leli en. Bika a wowtu di u e yee, a ná mi wowtu, ma na fu a Tata di sende mi kon.” ");
INSERT INTO djkNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“We, mi e taigi u den sani fu di mi de anga u ya ete. ");
INSERT INTO djkNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma a Yeepiman, a Jeje fu Masaa Gadu, di mi Tata o sende kon a mi nen, sa leli u ala sani. Da soseefi a sa tyai ala san di mi be taigi u kon baka a ini u pakisei. ");
INSERT INTO djkNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","We, mi sa gi u wan koo ati. A koo ati di mi e gi u ya de taa fasi enke di fu goontapu. A dati meke a á de fu u dege dege ofu feele.” ");
INSERT INTO djkNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ne Masaa Jesesi taigi den go doo taki: “U be yee di mi be taigi u taki, mi e gwe, ma mi o kon baka a u. Efu u be lobi mi, da u ati be o piisii, di mi taigi u taki, mi e gwe a mi Tata. Bika mi Tata bigi moo mi. ");
INSERT INTO djkNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","We, mi be taki den sani ya gi u a fesi, fu te a yuu o doo di den o pasa, fu u sa biibi. ");
INSERT INTO djkNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Mi ná o taki langa anga u moo, bika a edeman fu a goontapu ya e kon. Ma a ná abi ná wan taki a mi tapu. ");
INSERT INTO djkNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma, na fu di goontapu mu kon sabi kiinkiin taki, mi lobi mi Tata, na dati ede meke mi e du enke fa mi Tata taigi mi. We, u opo meke u gwe komoto ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ne Masaa Jesesi taigi den taki: “Mi na a tuutuu doloifi bon. Da mi Tata na a sama di abi a goon seefi fu solugu. ");
INSERT INTO djkNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Da u na den taka fu a doloifi bon. Da, efu wan fu den taka fu mi nái meke nyanyan, da mi Tata o koti en towe. Ma iniiwan taka di e meke nyanyan, da a o kiin den moi seeka den fu den meke moo ipi nyanyan. ");
INSERT INTO djkNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma a wowtu di mi taki gi u, meke u de kiinkiin seeka seeka kaba. ");
INSERT INTO djkNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","We, u tan a ini mi. Da u meke mi tan a ini u tu. Leti enke fa i si wan taka wawan á poi meke nyanyan, efu a á tan a na a bon, na leti soseefi u seefi ná o poi meke nyanyan tu, efu u á tan a ini mi. ");
INSERT INTO djkNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mi na a doloifi bon. U na den taka fu mi. Sama di e tan a ini mi, ne mi tan ne en ini, da so wan sama o meke tyaipi nyanyan. Bika sondee mi u á poi du ná wan sani. ");
INSERT INTO djkNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Sama di á tan a ini mi, den sa koti en puu towe enke wan dee doloifi taka. Da den e piki den taka ya towe a ini faya fu den boon. ");
INSERT INTO djkNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Efu u tan a ini mi, ne den leli fu mi tan na u ini, da u sa begi akisi san u wani, da u sa fende en. ");
INSERT INTO djkNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Da, te u meke nyanyan, da na sowan fasi mi Tata o kisi balinen. Da u sa soi taki u na bakaman fu mi tuutuu. ");
INSERT INTO djkNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Da, leti enke fa mi Tata lobi mi, na soseefi miseefi lobi u tu. So u tan a ini a lobi fu mi. ");
INSERT INTO djkNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Efu u du san mi e taki, da u sa tan a ini mi lobi. Bika mi tan a ini a lobi fu mi Tata fu di mi e du san a taigi mi fu du. ");
INSERT INTO djkNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Da mi taigi u den sani ya, fu a piisii fu mi tan a u ini ati. Da soseefi mi taigi u den sani ya, fu a piisii fu u mu goo a ini u ati te a pasa peesi. ");
INSERT INTO djkNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Da mi e sende u taki, u lobi useefi, enke fa mi lobi u. ");
INSERT INTO djkNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","We, bika ná wan sama sa lobi wan sama moo enke a sama di ná abi toobi fu poti en libi gi wan taa sama. ");
INSERT INTO djkNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Da u na mi mati, efu u e du san mi sende u fu du. ");
INSERT INTO djkNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi nái kai u futuboi moo. Bika wan futuboi á sabi san en masaa e du. Ma mi e kai u, mi mati. Bika mi be taigi u ala san mi be yee fu mi Tata. ");
INSERT INTO djkNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A ná u be kon a mi, ma na mi be piki u puu a den taawan mindii fu u go, da u meke nyanyan. Da te u meke nyanyan, da a nyanyan fu u sa tan fu tego. Da iniiwan sani di u o akisi mi Tata a mi nen, a o gi u en. ");
INSERT INTO djkNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ma mi poti gi u taki: U lobi useefi. ");
INSERT INTO djkNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Efu kondee á lobi u, da u mu sabi taki, den á be lobi mi a fesi kaba bifo u. ");
INSERT INTO djkNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Efu u be de fu kondee, da kondee be o lobi u, bika u be o de anga den na a wanse. Ma fu di u á de fu kondee, bika mi be piki u puu a den kondee sama mindii, na fu dati ede meke den á poi si u na ain. ");
INSERT INTO djkNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","U feegete den wowtu di mi be taigi u taki, wan futuboi á a bigi moo en masaa? We, leti enke fa i si den feti a mi baka fu pina mi, na leti soseefi den o feti a u baka pina u fu mi ede. Da, leti enke fa son sama be aliki mi wowtu e du san mi taki, na letiso sama sa aliki u san u e taki tu. ");
INSERT INTO djkNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ma na fu di den á sabi mi Tata di sende mi kon, meke den o du ala den sani ya anga u fu mi ede. ");
INSERT INTO djkNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","We, efu mi á be kon taki anga den, da den á be o du ogii. Ma, enke fa u de, den á poi sitee taki, den ná ogii. ");
INSERT INTO djkNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wan sama di buuse mi, buuse mi Tata tu. ");
INSERT INTO djkNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Efu mi á be du so gaan foondoo sani a den mindii, di wan taawan á be du ete, da den á be o du ogii. Ma now den si ala san di mi du, ne toku den buuse mi. Da soseefi den buuse mi Tata tu. ");
INSERT INTO djkNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma fa i si den sani ya pasa de, na fu di san sikiifi a Gadu Buku mu kon tuu. Bika Gadu Buku sikiifi taki: ‘Mi á be du wan sani anga den, ne toku den á poi si mi na ain.’ ");
INSERT INTO djkNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ma mi o sende a Yeepiman, a Jeje fu Masaa Gadu di e leli sama den tuutuu sani fu Gadu kon. Da te a kon, da a sa taki sani fu mi. ");
INSERT INTO djkNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Da useefi o taki sani fu mi tu. Bika u be de anga mi fanafu a bigin.” ");
INSERT INTO djkNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ne Masaa Jesesi taigi den taki: “Mi taigi u den sani ya a fesi fu u á buuya bakaten fu u lasi biibi. ");
INSERT INTO djkNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bika den edeman o puu u a den keliki. Da a o kon seefi taki, den o kii u. Da te den kii u, da den o denki taki na Gadu den e du wan bun. ");
INSERT INTO djkNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ma den o du den sani ya anga u, fu di den á sabi mi Tata. Da soseefi den á sabi mi tu. ");
INSERT INTO djkNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","We, mi taigi u den sani ya, fu te a yuu o doo di den o pasa, fu u sabi taki, we, na so mi be taigi u. Da mi á be taigi u den sani ya a fesi, bika mi be de anga u ete. ");
INSERT INTO djkNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ma now mi o daai gwe na a sama di sende mi kon ya baka. Ma ná wan fu u e akisi moo na on se mi e go. ");
INSERT INTO djkNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ma na den sani di mi taigi u de, na den meke gaan tyali kisi u? ");
INSERT INTO djkNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma mi e taigi u tuutuu taki, na wan gaan yeepi a de gi u, fa i si mi e gwe ya. Bika, efu mi á gwe, da a Yeepiman ná poi kon. Ma te mi go kaba, da mi o sende en kon gi u. ");
INSERT INTO djkNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Da, te a kon, da a sa soi kondee san na takuudu anga ogii. Da a o soi den san na a leti fasi fu libi anga fa Masaa Gadu o sitaafu libisama. ");
INSERT INTO djkNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Da a o soi den san na takuudu anga ogii, fu di den á biibi a mi. ");
INSERT INTO djkNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Da a o soi den san na a leti fasi fu libi, fu di mi e daai go baka a mi Tata. Da u ná o poi si mi moo. ");
INSERT INTO djkNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Da a o soi den fa Masaa Gadu o sitaafu kondee, bika a kuutu a edeman fu a goontapu fu a fende en sitaafu kaba. ");
INSERT INTO djkNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ma mi abi somen sani ete di mi wani taigi u. Ma, enke fa u de nownow, u ná o poi tyai den. ");
INSERT INTO djkNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ma te a Jeje fu Masaa Gadu di e leli sama den tuutuu sani fu Gadu kon, da a o tii u, e tyai u a hii den sani di de tuutuu. Bika a ná o teke enseefi sani taigi u, ma san a be yee, na dati a o taki. Da soseefi a o taigi u den sani di de a fesi fu kon ete tu. ");
INSERT INTO djkNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","We, da a o meke libisama si a hei anga a balinen di mi abi. Bika a o teke sani fu mi taigi u. ");
INSERT INTO djkNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ala san mi Tata abi na fu mi. Na fu dati ede meke mi taigi u taki, a o teke sani fu mi taigi u. ");
INSERT INTO djkNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Pikinso moo, da u ná o si mi moo. Ma pikinso moo, da u o si mi baka. Bika mi e go a mi Tata.” ");
INSERT INTO djkNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","We, ne wantu fu den bakaman fi en akisi den na den taki, san na a sani di a taki de taki: “Pikinso moo, da u ná o si mi moo? Ma, pikinso moo, da u o si mi baka? Bika mi e go a mi Tata?” ");
INSERT INTO djkNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ne den taki go doo taki: “San wani taki, pikinso moo? We, wi á sabi san a sani de wani taki.” ");
INSERT INTO djkNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","We, di Masaa Jesesi si taki den wani akisi en wan sani, ne a akisi den taki: “We, fa u e kuutu anga useefi saafi saafi de? Na fu di mi taki: ‘Pikinso moo, da u ná o si mi moo. Ma pikinso moo, da u o si mi baka?’ U á sabi san dati wani taki, no? ");
INSERT INTO djkNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","We, fu tuutuu mi e taigi u, u sa bali kee, ma goontapu sa piisii. Da gaan tyali o de a u ati. Ma a tyali fu u o kengi kon toon piisii. ");
INSERT INTO djkNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A de leti enke te wan uman de anga bee. Te a yuu fi en doo fu a meke, da a bee e nyanmi en, te ná sipowtu. Ma te a meke kaba, da a nái pakisei a pen moo. Piisii namo, di ai piisii so fu di wan sama kon a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","We, na letiso a de anga u tu. Nownow, enke fa u de, gaan tyali de a u ati. Ma mi o si u baka. Da u ati sa piisii. Da ná wan sama o poi puu a piisii fu u ya. ");
INSERT INTO djkNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Da a yuu ten de, da u ná o akisi mi ná wan sani moo. Fu tuutuu mi e taigi u taki, ala sani di u begi akisi mi Tata a mi nen, da a sa gi u den. ");
INSERT INTO djkNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Fu te enke now, u á be begi akisi mi wan sani a mi nen ete. We, u begi akisi, no? U o fende. Da te u o fende, da a piisii fu u o goo kon te a pasa maiki. ");
INSERT INTO djkNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“We, ala den sani di mi be taigi u, mi be taigi anga ageisi toli. Ma a ten koosube, di mi ná o taki anga u a sowan fasi moo. Ma mi o taki anga u, wan kiin fasi e leli u den sani fu mi Tata. ");
INSERT INTO djkNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Da a yuu ten de, da u sa begi akisi mi Tata sani a mi nen. Da mi ná o taigi u taki, mi sa begi mi Tata gi u. ");
INSERT INTO djkNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bika, mi Tata seefi lobi u, fu di u lobi mi e biibi taki ne en mi komoto kon ya. ");
INSERT INTO djkNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","We, na mi Tata mi komoto kon a goontapu tuu. Da na soseefi mi o fika a goontapu ya baka go a mi Tata baka.” ");
INSERT INTO djkNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ne den bakaman fi en taigi en taki: “Weeno! I si? Now yu e taki kiin anga u sondee fu taki anga ageisi toli. ");
INSERT INTO djkNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Now wi e si taki a á de fanowdu fu sama akisi sani, bika, i sabi ala sani. Na fu dati ede meke u e biibi taki na Masaa Gadu i komoto.” ");
INSERT INTO djkNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ne Masaa Jesesi piki den taki: “A nowfosi u e biibi? ");
INSERT INTO djkNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","We, fu tuutuu mi e taigi u taki, wan yuu e kon, da a de kaba, di u o paati fika mi wawan kodo. Ibiiwan fu u o go ne en osu. Ma toku seefi, a ná mi wawan de. Bika mi Tata de anga mi. ");
INSERT INTO djkNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","We, mi be taigi u den sani ya fu u sa abi koo ati fu di mi anga u de wan. A ini goontapu ya gaan pina anga sitaafu e kon a tapu. Ma u á lasi ati. Bika, mi wini goontapu kaba.” ");
INSERT INTO djkNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ne di Masaa Jesesi taki anga den so te a kaba, ne a opo en ede luku tapu, ne a taki: “Mi Tata! A yuu doo kaba. Soi sama a waiti di a Manpikin fi i abi, fu a Manpikin fi yu sa soi sama a waiti fasi fi yu tu. ");
INSERT INTO djkNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","We, bika i gi en taki na ala sama tapu, fu a sa gi den sama di i gi en a libi fu tego. ");
INSERT INTO djkNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","We, a libi fu tego, dati na fu den kon sabi yu, enke awan kodo tuutuu Gadu. Da soseefi fu den kon sabi Jesesi Kelestesi tu di i be sende kon a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi soi hii goontapu a waiti fasi fi yu. Mi kaba anga a wooko di i be gi mi fu du. ");
INSERT INTO djkNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","We, mi Tata, meke mi fende a hei anga a waiti fasi fu mi baka, di mi be abi bifo goontapu be meke. ");
INSERT INTO djkNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mi meke den sama di i gi mi a goontapu ya kon sabi i kiinkiin. Na yu be abi den kaba, ma yu gi mi den. Da den teke yu wowtu oli. ");
INSERT INTO djkNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Da now den kon sabi taki ala den sani di mi abi, na yu den komoto. ");
INSERT INTO djkNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Bika mi gi den yu wowtu. Da den teke den. We, den kon sabi kiinkiin tu taki na yu mi komoto. Da den e biibi tu taki na yuseefi be sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“We, na den mi e begi gi. Ná den sama fu a goontapu ya mi e begi gi. Ma na fu den wawan di i be gi mi. Bika den na fi yu. ");
INSERT INTO djkNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ala den sama di mi abi na fi yu. Da soseefi ala den sama fi yu na fu mi. Da libisama si a waiti fasi fu mi a den. ");
INSERT INTO djkNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi á de a goontapu moo, ma den de a goontapu ete. Da, mi e kon a yu. Mi Tata di de apaiti fu ala sani di de. Tata, kibii den sama di i gi mi ya a ini a kaakiti fu a nen fi yu, meke den de wan makandii, leti enke fa mi anga yu de wan. ");
INSERT INTO djkNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Alaten di mi be de a goontapu, mi be e kibii den a ini a kaakiti fu a nen fi yu di i gi mi. Mi be e luku den seefi fu ná wan fu den go lasi, boiti a ogii ati wan, di be meke fu go lasi kaba a soso fu a sani di Gadu Buku taki mu kon tuu. ");
INSERT INTO djkNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Da Tata, now mi e kon a yu. Ma mi e taki den sani ya a goontapu ete. Bika mi wani meke a piisii fu mi goo a ini den ati ini te a pasa maiki. ");
INSERT INTO djkNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi be gi den yu wowtu. Ma goontapu buuse den. Bika den á de fu goontapu, leti enke fa miseefi á de fu goontapu tu. ");
INSERT INTO djkNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Da Tata, mi nái begi fi i puu den na goontapu. Ma mi e begi fi i kibii den fu a didibii á koli den kisi. ");
INSERT INTO djkNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Den á de fu kondee, leti enke fa miseefi á de fu kondee. ");
INSERT INTO djkNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mi Tata, teke den sama ya poti apaiti meke den kon si sani kiinkiin, enke fa den de tuutuu. Bika a wowtu fi yu na a tuu. ");
INSERT INTO djkNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Leti enke fa yu be sende mi kon a goontapu, na letiso mi e sende den go a goontapu tu. ");
INSERT INTO djkNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na fu den ede meke mi e poti miseefi a wan apaiti fasi gi yu. Da meke den seefi sa poti denseefi na tuutuu apaiti fasi gi yu tu. ");
INSERT INTO djkNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ma mi nái begi gi den disi wawan. Ma mi e begi gi ala den taawan di o yee den wowtu, da den daai kon e biibi a mi. ");
INSERT INTO djkNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tata, mi e begi fu den ala fiya kon de wan makandii, leti enke fa mi anga yu de wan. Da efu den de wan, da goontapu sa sabi taki na yu be sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi be gi den a seefi waiti fasi di i be gi mi, fu den sa de wan makandii, enke fa mi anga yu de wan. ");
INSERT INTO djkNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Da mi de a den ati ini, da yu de a mi ati ini. Da na so den o de wan tuutuu fu hii goontapu mu si taki na yu be sende mi kon. Bika yu lobi den, leti enke fa i lobi mi. ");
INSERT INTO djkNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mi Tata, mi wani fu den sama di i gi mi ya, mu de anga mi a pe mi de, fu den si a waiti fasi fu mi di yu gi mi. Bika i be lobi mi bifo goontapu be meke. ");
INSERT INTO djkNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","We, mi Tata, yu di e du sani sondee kukutu fasi, goontapu á sabi yu. Ma mi sabi yu. Da now, den sama di i gi mi ya kon sabi taki na yu be sende mi kon. ");
INSERT INTO djkNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi meke den kon sabi yu kiinkiin enke fa i de. Da mi sa meke den kon sabi yu moo, fu den sa abi a sowtu lobi di yu abi gi mi. Da miseefi o de a den ati ini tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Di Masaa Jesesi kaba a begi fi en, ne en anga den bakaman fi en gwe. Da den o pasa na a kiiki di den e kai, Kidilon go na a taase. Ma namo, da wan dyali be de ape. Ne Masaa Jesesi anga den bakaman fi en go de. ");
INSERT INTO djkNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma Judasi, a man di o seli Masaa Jesesi be sabi a peesi tu. Bika en anga Masaa Jesesi anga den taa bakaman fi en be lobi kon makandii de. ");
INSERT INTO djkNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","We, ne Judasi teke wan lo Loma suudati anga wan lo sikowtu fu a Mama Keliki fu den Dyu a Jelusalem. Den Faliseiman anga den hei apaiti begiman be gi en den. Namo di den kon, da den kon anga lantei anga fambo anga feti sani. ");
INSERT INTO djkNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","We, fu di Masaa Jesesi be sabi ala san be o miti en a fesi kaba, na fu dati ede meke a waka go miti den. Ne a akisi den taki: “Sama u e suku?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ne den piki en taki: “Na Jesesi fu Nasaleti u e suku!” Ne Masaa Jesesi piki den taki: “Na mi de ya! Ma namo, da Judasi di o seli Masaa Jesesi seefi be taampu de tu anga den taa sama.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","We, di Masaa Jesesi piki den taki: “Na mi de ya!” Ne ala den fiya kiki go anga baka ne den kai. ");
INSERT INTO djkNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ne Masaa Jesesi akisi den baka taki: “Sama u e suku?” Ne den piki en taki: “Na Jesesi fu Nasaleti u e suku.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ne Masaa Jesesi taigi den taki: “Mi taigi u kaba. Na mi de ya!” Ne a taigi den go doo taki: “We, efu na mi u e suku, da u fika den bakaman fu mi ya meke den gwe!” ");
INSERT INTO djkNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","We, na so a wowtu kon leti enke fa a be taki: “Ná wan enkii wan fu den sama di i be gi mi, di mi lasi.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","We, ma namo, da Simon Peitilisi be abi wan fetihow ne en de. Ne a teke a fetihow, ne velen, a koti a letise yesi fu a futuboi fu a moo hei begiman, puu. Na a futuboi ya nen den be e kai Maakusi. ");
INSERT INTO djkNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma Masaa Jesesi taigi Peitilisi taki: “Peitilisi! Toosi i fetihow poti baka a ini en saka! I denki taki a fiti fu mi wai komoto a pasi gi a pina sitaafu di mi Tata poti gi mi fu pina ya?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ne a yuu de, ne a kulu suudati kon anga a edeman fu den anga den sikowtu fu a Mama Keliki, ne den kisi Masaa Jesesi. Ne den tei en ana. ");
INSERT INTO djkNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ne, den tyai en go a wan osu fu wan man den e kai Anasi. Da Kayafasi na be a moo hei apaiti begiman, a yali de. Da a be libi anga wan umanpikin fu Anasi. ");
INSERT INTO djkNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Da a Kayafasi ya, na a seefi sama di be gi den edeman fu den Dyu a lai taki, a moo betee wan man dede gi a hii foluku, pe fu a foluku dede kaba a soso. ");
INSERT INTO djkNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","We, Simon Peitilisi anga wan taa bakaman fu Masaa Jesesi e waka go a Masaa Jesesi baka. Da a bakaman ya na wan sama di a moo hei apaiti begiman fu a Mama Keliki be sabi. Da na fu dati ede meke a bakaman ya go te a ini a dyali fu a moo hei apaiti begiman, a Masaa Jesesi baka. ");
INSERT INTO djkNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ma Peitilisi fika taampu taampu a doose. We, na fu dati ede meke a bakaman ya, di a moo hei apaiti begiman be sabi go a doose, ne a taki anga a uman di be taampu na a doo mofu fu a dyali. Ne a uman meke Peitilisi pasa kon a ini a dyali. ");
INSERT INTO djkNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","We, a uman di be de na a doo mofu taigi Peitilisi taki: “Yu a ná wan bakaman fu a man, no?” Ne Peitilisi piki taki: “Nono! Ná mi!” ");
INSERT INTO djkNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ma namo, da den futuboi anga den sikowtu di be e oli waki na a gaaman osu be meke wan koofaya faya fu den de a waan. We, ne Peitilisi seefi go taampu de e waan a faya tu. Bika a peesi be koo. ");
INSERT INTO djkNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","We, ne a moo hei apaiti begiman e akisi Masaa Jesesi wanlo sani fu den bakaman fi en, anga somen sani fu a leli fi en. ");
INSERT INTO djkNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ne Masaa Jesesi piki en taki: “Mi be de a lanti mindii alaten e leli sama. Mi be de a ini den keliki e leli sama, te go doo a Mama Keliki anga ala peesi pe den Dyu e kon makandii tu. Mi á be de bakabaka e taki sani. ");
INSERT INTO djkNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","We, saide meke na mi yu e akisi den sani de? Akisi den sama di be e yee den sani di mi be e leli den. Den sa sabi fu taigi u san mi be e taki.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","We ne, di Masaa Jesesi taki so, ne wan fu den sikowtu di be taampu de, naki en wan baala ana kwaa ne en sikin fesi taki: “On fa? Na so yu e taki anga a moo hei apaiti begiman fu a Mama Keliki?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ne Masaa Jesesi piki taki: “We, efu mi taki ogii, da taigi mi sowtu ogii mi taki? Ma efu na wan tuu sani mi taki, da saide meke yu e naki mi?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","We, ne Anasi sende en go anga teitei ana a Kayafasi, a moo hei apaiti begiman. ");
INSERT INTO djkNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","We, da a yuu di Peitilisi taampu e waan faya de, ne den akisi en taki: “Yu na wan bakaman fu a man tu?” Ma Peitilisi sitee, a taki: “Nono! Ná mi!” ");
INSERT INTO djkNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ne bakadati, ne wan futuboi fu a moo hei apaiti begiman, wan famii fu Maakusi, a man di Peitilisi be koti en yesi puu, akisi Peitilisi taki: “Na yu anga en mi be si a ini a dyali, no?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma Peitilisi sitee baka. Ne wanten de, ne kokoliyekee, a kakafoo bali. ");
INSERT INTO djkNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","29","Ne a taa dei fuuku mamanten, ne den komoto a Kayafasi, ne den tyai Masaa Jesesi go a Gaaman Pilatesi osu. Ma den edeman fu den Dyu seefi á go a ini a gaaman osu. Bika den be wani oli den seefi kiin, enke fa a leli fu den be taki. Bika den be wani nyan a Pasika. Na fu dati ede meke Gaaman Pilatesi komoto kon a den a doose. Ne a akisi den taki: “We, on sowtu ogii a sama ya du, meke u e tyai en kon a mi?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ne den piki en taki: “Efu a sama ya á be du ná wan ogii, u á be o tyai en kon a yu.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","We, ne Pilatesi taigi den taki: “We, u teke en, da u seefi kuutu en enke fa a weiti fu u e soi u.” Ma den Dyu piki en taki: “We, a Loma weiti nái gi wi enke Dyu pasi fu u kii sama.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","We, da na so den wowtu fu Masaa Jesesi be kon tuu. Bika a be pingi den a fesi pilisisi fa a dede fi en be o dede. ");
INSERT INTO djkNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","We, ne Pilatesi go baka a ini en paleisi, na a pisi pe a kuutu be e oli, ne a kai Masaa Jesesi kon. Ne a akisi Masaa Jesesi taki: “We, san yu e taki? Yu na a kownu fu den Dyu?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ne Masaa Jesesi piki en taki: “A sani di yu akisi mi de, na yu seefi akisi en, efu na san taa sama be taigi yu fu mi?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ne Gaaman Pilatesi akisi en taki: “Oho! Fa yu e akisi mi so? I si taki mi na wan Dyusama? A ná yu eigi sama anga den hei apaiti begiman tyai yu kon a mi ya, no? San i du seefi?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ne Masaa Jesesi piki en taki: “Fa mi e tii sani enke kownu á de enke a tii fu kownu a goontapu ya. Bika efu a be de so, da den bakaman fu mi be o opo feti anga den sama, di kon kisi mi tyai kon poti ya. Ma nono! Mi kownu tii a ná fu a goontapu ya.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","We, ne Pilatesi taigi en taki: “We, da meke u taki, da yu na wan kownu?” Ne Masaa Jesesi piki en taki: “A leti enke fa yu taki de. Mi na wan kownu! Na fu dati ede mi meke, mi kon a goontapu, fu soi den sama san na tuu. We, ala sama di lobi tuu, o go e aliki mi san mi e taki.” ");
INSERT INTO djkNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ne Gaaman Pilatesi taigi en taki: “Tuu? San na tuu?” We, di Gaaman Pilatesi taki so, ne a go a den Dyu baka a doose. Ne a taigi den taki: “We, mi á fende sani na a sama di u tyai kon a mi ya ye, fu mi mu kuutu en taki a mu dede! ");
INSERT INTO djkNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","We, u aliki! Wi abi a gwenti fu te a Pasika o kai, fu mi losi wan sama puu a dunguu osu gi u. Da san u wani? U wani mi losi a kownu fu u ya gi u?” ");
INSERT INTO djkNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma ala den pii den mofu e bali taki: “No! No! Wi á wani i losi en! Losi Balabasi gi u!” Da Balabasi na be wan abani. ");
INSERT INTO djkNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ma now, ne Pilatesi meke den teke Masaa Jesesi tyai gwe fu den wipi en. ");
INSERT INTO djkNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ne bakadati, ne den suudati teke wan tetei di gei agwago maka, ne den beei en kon enke wan kownu ati. Ne den toosi en gi Masaa Jesesi ne en ede suu. Ne den teke wan baaw lebi dyakiti, ne den wei gi en. ");
INSERT INTO djkNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ne den taigi en taki: “Odiyoo! Odiyoo Kownu fu den Dyu! Ne den e naki en ne en fesi.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","We, ne Gaaman Pilatesi go a doo baka, ne a taigi den taki: “We, u luku ya. Mi e tyai a sama ya kon a doo a u fesi. Mi á fende ná wan fowtu ne en. Da mi o losi en.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","We, da na so Masaa Jesesi kon a doo anga a maka ati ne en ede anga a dyakiti ne en sikin. Ne Gaaman Pilatesi taigi den taki: “We, u luku a sama ya, ye!” ");
INSERT INTO djkNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ma di den hei apaiti begiman anga den sikowtu fu a Mama Keliki si en, ne den bali taki: “U kii en! U kii en! U sipikii en a koloisi kii.” Ne Gaaman Pilatesi taigi den taki: “We, u teke en, da u tyai go sipikii a koloisi! Ma miseefi á fende ná wan fowtu ne en.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","We, ne den Dyu piki en taki: “We, wi fende fowtu ne en, bika wi abi wan weiti di e soi wi taki a mu dede. Bika a be meke enseefi toon a Manpikin fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","We, di a gaaman yee den sama taki so, ne a moo feele. ");
INSERT INTO djkNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","We, ne a go baka a ini gaaman osu, ne a taigi Masaa Jesesi taki: “On kondee na fi yu?” Ma Masaa Jesesi á piki en. ");
INSERT INTO djkNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ne Gaaman Pilatesi taigi en taki: “Oho! Yu nái piki mi, no? Yu á sabi taki mi abi makiti fu meke den sipikii yu a koloisi kii, ma mi abi makiti fu meke den losi yu tu, no?” ");
INSERT INTO djkNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ne Masaa Jesesi piki en taki: “Yu á be poi abi ná wan sowtu makiti a mi tapu, efu a ná Gadu be gi yu en. Na fu dati ede meke a sama di i si tyai mi kon gi yu ya, du moo gaan ogii moo yu.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Da fanafu a yuu de, ne Gaaman Pilatesi be e meke ala sowtu moiti fu losi Masaa Jesesi. Ma den Dyu e bali gi en taki: “Efi i losi a sama de gwe, da yu anga a moo gaan kownu a Loma Foto o kisi toobi. Bika wan sama di e meke enseefi toon kownu, na wan feyantiman fu a gaan kownu de.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Da di Gaaman Pilatesi yee den wowtu ya, ne a meke Masaa Jesesi komoto kon a doo. Ne Gaaman Pilatesi go sidon na a sutuu fi en, a pe a be e sidon koti kuutu. Da na a sutuu fi en ya den be e kai, Hei Siton Tapu. Ma den Dyu be e kai en, Gabata. ");
INSERT INTO djkNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Da den sani ya be e pasa na a seefi dei di den be seeka sani fu nyan a Pasika Piisii. Da a be sa de wan sani fu twalufu yuu so. Ne Gaaman Pilatesi taigi den Dyu taki: “We, u luku a kownu fu u ya!” ");
INSERT INTO djkNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma den bali taki: “U kii en! U kii en! U sipikii en a koloisi kii!” Ne Gaaman Pilatesi taigi den taki: “Na a kownu fu u, mi mu sipikii a koloisi kii?” Ma den hei apaiti begiman piki en taki: “Wi ná abi ná wan enkii kownu boiti a moo gaan kownu a Loma Foto!” ");
INSERT INTO djkNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","We, di den taki so, ne Gaaman Pilatesi gi den en fu den tyai go sipikii kii a koloisi. We, ne na so den teke Masaa Jesesi, ne den tyai en gwe. ");
INSERT INTO djkNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Da Masaa Jesesi seefi be e tyai a koloisi di den o sipikii en kii. Ne den e go te, den go doo na a peesi di den e kai, Bongo Pita Peesi. Ma den Dyu be e kai a peesi ya, Golgata. ");
INSERT INTO djkNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Da na ape den sipikii Masaa Jesesi na a koloisi. Da den sipikii ete tu man makandii anga en tu. Wan ne en kukutuse ana, a taawan ne en letise ana. Masaa Jesesi seefi de a mindii. ");
INSERT INTO djkNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ma namo, da Gaaman Pilatesi be sikiifi wan sani poti na a koloisi fu Masaa Jesesi a tapu. Da a be sikiifi taki: ");
INSERT INTO djkNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Da somen Dyu be leisi a sani di sikiifi na a koloisi a tapu anda. Bika a peesi pe den be sipikii Masaa Jesesi na a koloisi be de koosube fu a foto. Da a be sikiifi a sani ya a ini den tongo fu den Dyu, den Loma anga den Giiki sama. ");
INSERT INTO djkNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ma den hei apaiti begiman e go a Pilatesi taki: “Yu á mu sikiifi taki: ‘En na Kownu fu den Dyu!’ Ma i mu sikiifi taki: ‘A be taki en na Kownu fu den Dyu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ma namo, ne Pilatesi piki den taki: “San mi sikiifi, tan sikiifi!” ");
INSERT INTO djkNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","We, di den suudati sipikii Masaa Jesesi na a koloisi kaba, ne den teke den koosi fi en, ne den meke fo ipi fu ibii suudati sa fende wan ipi. Ma now, da a fika ete wan koosi fi en. Da a koosi ya á be nai, ma a be wan gaan pisi koosi. ");
INSERT INTO djkNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Na fu dati ede den taigi den na den taki: “Meke wi á piiti en, ma meke wi iti lowte luku sama o wini en.” Da den sani ya pasa fu san sikiifi a Gadu Buku mu kon tuu. Bika Gadu Buku be sikiifi taki: “Den paati mi koosi den na den, den iti lowte fu paati mi koosi.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Da a mma fu Masaa Jesesi anga en mma pikin sisa anga Maliya, a uman fu Kolopasi anga Maliya Makidala be taampu koosube fu a koloisi fu pe den be koloisi Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","We, di Masaa Jesesi si en mma taampu anga a bakaman fi en di a be lobi te, ne a taigi en mma taki: “Uman! Luku i pikin de!” ");
INSERT INTO djkNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne bakadati, ne a taigi a bakaman fi en taki: “Luku i mama de!” Ne fanafu a ten de, ne a bakaman fi en de teke en ne en osu e solugu. ");
INSERT INTO djkNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ma di Masaa Jesesi sabi taki a du ala den sani di a abi fu du, ne a taki ete wan sani fu meke ala sani di Gadu Buku sikiifi kon tuu. A taki: “Dee wataa kisi mi, baa!” ");
INSERT INTO djkNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma namo, da den be abi wan patu anga wan sowtu win enke asin a ini. Ne den teke wan siponsu, sungu go a ini a win, ne den fasi en a wan tiki ede, ne den tyai go ne en mofu. ");
INSERT INTO djkNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ma di Jesesi diingi a asin kaba, ne a taki: “A kaba!” Ne na so a bendi en ede, ne a tapu boo. ");
INSERT INTO djkNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma fu di den edeman fu Dyusama be mu seeka sani fu nyan a Pasika Piisii, meke den go begi Gaaman Pilatesi, fu a sende sama go naki den bon fu den futu booko. Da den dede sikin fu den á be de na a koloisi a hii kina dei de. Bika a kina dei di e kon de, na be wan apaiti kina dei gi den. ");
INSERT INTO djkNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","We, na so den suudati kon, ne den booko den bon fu a fosi man futu. Ne den go, ne den booko den bon fu a taa man di den be koloisi de tu. ");
INSERT INTO djkNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ma di den kon fu booko den bon fu Masaa Jesesi, ne den si taki a dede kaba. Ne den á booko den moo. ");
INSERT INTO djkNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ma wan fu den suudati sutu en anga wan lansi ne en sikin bee. Ne wanten, ne buulu anga wataa lon komoto a ini en sikin kon a doo. ");
INSERT INTO djkNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Da a sama di e taki den sani ya, ne enseefi si den anga ain. Da fa ai taki ya, da na tuutuu sani ai taki, fu te i yee den, fi i sa daai teke biibi. ");
INSERT INTO djkNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bika den sani di i si pasa ya, pasa fu den sani di sikiifi a Gadu Buku mu kon tuu. Bika Gadu Buku sikiifi taki: “Den ná o booko ná wan bon fi en.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Da a wan taa peesi a taki baka taki: “Sama o si a sama di den sutu a sutu de.” ");
INSERT INTO djkNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","We, ne wan man den e kai Jowsef fu Alimateya Kondee, di be e waka a Masaa Jesesi baka tu kon. Dati be de wan kibii toli. Bika a be e feele den edeman fu den Dyu. Ne a go begi Gaaman Pilatesi, fu a puu a dede sikin fu Masaa Jesesi na a koloisi. Ne Gaaman Pilatesi gi en pasi. Ne a go, ne a go puu a dede sikin fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Da Nikodeimisi, di be kon a Masaa Jesesi a wan neti seefi kon tu. Da a tyai sumee switi sani di den e seeka dede sikin te anga wan sani fu diitenti a dii kilo so. Da a be mokisa den sani ya te a mokisa. ");
INSERT INTO djkNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ne den teke a dede sikin fu Masaa Jesesi, ne den lolo en a ini weti koosi mokisa anga den sumee switi sani, enke fa den Dyu be gwenti beli dedesama. ");
INSERT INTO djkNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Da koosube fu pe den be sipikii Masaa Jesesi, wan dyali be de. Da wan nyunyun geebi be de a ini a dyali ya, pe den á be beli ná wan sama ete. ");
INSERT INTO djkNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","We, da a kina dei be koosube fu kai. Da fu di a geebi be de koosube anga pe den be sipikii Masaa Jesesi na a koloisi kii, na dati meke den tyai en go poti a ini a geebi ya. ");
INSERT INTO djkNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","We, na a fosi dei fu a wiki, fuuku musude, ne Maliya Makidala go na a geebi fu Masaa Jesesi. Ma namo, di a go, ne a si taki a siton á de na a geebi mofu moo. ");
INSERT INTO djkNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Na fu dati ede meke a lon go a Simon Peitilisi anga a taa bakaman fu Masaa Jesesi di a be lobi te. Ne a taigi den taki: “Den puu Masaa na a geebi, da wi á sabi pe den poti en.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","We, ne Peitilisi anga a taa bakaman fu Masaa Jesesi opo, ne den go na a geebi. ");
INSERT INTO djkNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Den tu be makandii, ma a taa bakaman fu Masaa Jesesi lon pasa Peitilisi. Ne na so en fosi doo na a geebi. ");
INSERT INTO djkNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","We, ne di a bende luku, ne a si den sibi koosi wawan de. Ma a á go a ini a geebi. ");
INSERT INTO djkNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","We, ne Simon Peitilisi seefi doo. Ma en go te a ini a geebi. Ne a si den koosi di den be lolo Masaa Jesesi de. ");
INSERT INTO djkNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ma a angisa di den be tei Masaa Jesesi ede á be de a pe den taa koosi be de, ma a be de te a wanse a wan taa peesi. ");
INSERT INTO djkNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ma, ne a taa bakaman fu Masaa Jesesi di fosi be doo na a geebi go a ini a geebi tu. Ne di a si den sani, ne fosi a daai kon e biibi. ");
INSERT INTO djkNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bika te enke now, da den á be fusutan a wowtu di sikiifi a Gadu Buku taki Masaa Jesesi mu opo baka komoto a dede ete. ");
INSERT INTO djkNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","We, ne na so den bakaman fu Masaa Jesesi go baka a osu. ");
INSERT INTO djkNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma Maliya dati taampu a doose fu a geebi, ne a bali kee. Da di a kee te wan pisi, ne a bendi luku go a ini a geebi. ");
INSERT INTO djkNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ne a si tu Basiya fu Masaa Gadu Kondee*f15* sidon a pe a dede sikin fu Masaa Jesesi be de. Den de anga weti koosi fann. Wan fu den Basiya ya sidon ne en ede se. A taawan sidon ne en futu se, leti enke fa den be poti a dede sikin fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ne den taigi Maliya taki: “Uman! Saide meke yu e kee so?” Ne a taigi den taki: “Den puu mi Masaa ya, da mi á sabi pe den tyai en go.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ne di a taki so, ne a daai fesi, ne a si Masaa Jesesi taampu taampu de. Ma a á be sabi taki na be Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","We, ne Masaa Jesesi taigi en taki: “Uman! Saide meke yu e kee so? Sama yu e suku?” Ma Maliya denki taki na a man di be e kiinmi a dyali e luku den boomiki be e taki anga en. Na fu dati ede meke a taigi a man taki: “Masaa, efu na yu tyai en gwe, taigi mi, pe i poti en, mi sa go teke en.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ma now, ne Masaa Jesesi kai en taki: “Maliya!” Ne Maliya daai en fesi, ne a bali taki: “Labuni!” Labuni wani taki, Mesiti, na Dyu Tongo. ");
INSERT INTO djkNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ne Masaa Jesesi taigi en taki: “Ná oli mi! Bika mi á go a mi Tata ete. Ma go a den baala fu mi, da taigi den taki, mi e opo go a mi Tata, di de a Tata fu u tu. Mi e go a mi Gadu di de a Gadu fu u tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","We, ne Maliya Makidala go taigi den bakaman fu Masaa Jesesi taki: “Mi si Masaa! Da na so so, a taigi mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","We, a seefi fosi dei fu a wiki de, di sapaten, da den bakaman fi en be de makandii a ini wan osu sooto sooto doo. Bika den be e feele den edeman fu den Dyu. Ne te fu den denki, ne Masaa Jesesi kon taampu a den mindii haa. Ne a taigi den taki: “Meke Masaa Gadu de anga u!” ");
INSERT INTO djkNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ne di a taigi den so, ne a soi den en ana anga en sikin bansa. We, now, ne den bakaman fu Masaa Jesesi piisii, te ná sipowtu, fu di den si Masaa. ");
INSERT INTO djkNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ne Masaa Jesesi taigi den ete wan toon taki: “Meke Masaa Gadu gi u koo ati fu libi, ye! Leti enke fa i si mi Tata be sende mi kon a goontapu, na soseefi mi e sende u tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ne di a taki so, ne a boo a den tapu vuuu taki: “U teke a Jeje fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Den sama di u o gi paadon fu takuudu anga ogii, o kisi paadon tuu. Ma sama di u á gi paadon, ná o kisi paadon tu.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma Towmasi, wan fu den twalufu bakaman fu Masaa Jesesi, di den be e kai Toolengi*f16* tu, á be de a den taawan mindii, di Masaa Jesesi be kon a den. ");
INSERT INTO djkNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ne di a kon, ne den taa bakaman fu Masaa Jesesi taigi en taki: “Wi si Masaa!” Ma a taigi den taawan taki: “Solanga mi seefi á si den sipikii maiki a ini en ana ini fu mi poti mi finga anga solanga mi á poti mi finga na a lansi mofu ne en sikin bansa, mi ná o biibi.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Da baka aitin dei, di den bakaman fu Masaa Jesesi be de makandii baka a ini wan osu sooto sooto doo, da Towmasi be de a ini a osu ini anga den tu. Ne te fu den denki, ne Masaa Jesesi kon a ini a osu, ne a go taampu a den mindii dyan. Ne a taigi den taki: “Meke Gadu gi u koo ati fu libi, ye!” ");
INSERT INTO djkNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ne Masaa Jesesi taigi Towmasi taki: “Luku mi ana ya. Langa i finga kon fii a maiki a ini mi ana. Da tyai ana kon poti na lansi mofu a mi sikin bansa. I mu fika a fasi di yu abi de, taki yu ná biibi. Ma biibi!” ");
INSERT INTO djkNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","We, ne Towmasi bali taki: “Oho! Masaa Gadu, mi Gadu! Yu na mi Gadu!” ");
INSERT INTO djkNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ne Masaa Jesesi taigi en taki: “Towmasi! A di yu si mi anga ain fosi yu e biibi? We, seigi fu den sama di e biibi, winsi den á si anga ain.” ");
INSERT INTO djkNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Da Masaa Jesesi du somen somen taa maiki ete a den bakaman fi en fesi, di á sikiifi a ini a buku ya. ");
INSERT INTO djkNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ma den sani ya sikiifi fu u mu biibi taki, Jesesi na a Kelestesi, a Manpikin fu Masaa Gadu. Da te u e biibi so kaba, da u o fende a tego libi, fu di u anga en de wan. ");
INSERT INTO djkNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ne bakadati, ne Masaa Jesesi tyai enseefi kon soi den bakaman fi en ete wan toon na a ze den e kai Tibeliyasi. Da a toli waka so: ");
INSERT INTO djkNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wan fu den toon, da Simon Peitilisi anga Towmasi, di den be e kai Toolengi*f17*, anga Nataniyeli, di fu a peesi di den e kai Kaana, na a pisiwataa fu Galileya, anga den tu manpikin fu Da Sebedi anga ete tu taa bakaman fu Masaa Jesesi be de a wan peesi. ");
INSERT INTO djkNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ne Simon Peitilisi taigi den taki: “Mi o go a onti towe seepi a liba!” Ne den taigi en taki: “Wi o go anga yu tu.” We, ne den opo go a ini a boto. Ma a hiihii neti de, den á kisi ná wan sani. ");
INSERT INTO djkNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ne a seefi dei de, fuuku mamanten, ne Masaa Jesesi kon taampu a mofu wataa de. Ma den bakaman fi en á be sabi taki na Masaa Jesesi de ape. ");
INSERT INTO djkNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ne Masaa Jesesi akisi den taki: “Pikin, san u kisi?” Ne den piki en taki: “Iya, nono!” ");
INSERT INTO djkNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ne a taigi den taki: “U iti a seepi fu u go na a letise fu a boto, da u sa kisi.” Ne den iti den seepi, ne den kisi fisi tee, den á poi ali a seepi kon a tapu. ");
INSERT INTO djkNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ma a bakaman fu Masaa Jesesi di a be lobi te, taigi Peitilisi taki: “Na Masaa Jesesi de ape!” We, di Simon Peitilisi yee taki, na Masaa Jesesi de ape, ne a wei en koosi baka esi, bika a be puu en koosi fu di a be e go fisi. Ne, dyulu, a dyombo a liba. ");
INSERT INTO djkNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma den taa bakaman fu Masaa Jesesi kon a sikin soo anga a boto, bika den be sa de wan sani fu wan ondoo meiti so fu sikin soo. We, ne na so den ali a seepi kon anga den fisi ne en. ");
INSERT INTO djkNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","We, di den kon a soo, ne den si taki koofaya be de leti leti de anga fisi ne en tapu e losi. Da soseefi beele be de tu. ");
INSERT INTO djkNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ne Masaa Jesesi taigi den taki: “U tyai wantu fu den fisi di u kisi dyonson de kon gi mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ne Simon Peitilisi go a ini boto, ne a ali a seepi kon a soo. Da a seepi be fuu anga wan ondoo feifitenti a dii gaanbigi fisi. Ma anga ala fa a seepi ya be abi den tyaipi fisi ya, toku a á piiti. ");
INSERT INTO djkNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma Masaa Jesesi taigi den taki: “U kon meke u nyan.” Ma ná wan fu den bakaman fu Masaa Jesesi di be e peefuu fu akisi en taki, sama a yu? Bika den be sabi taki na Masaa. ");
INSERT INTO djkNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","We, ne Masaa Jesesi kon, ne a teke a beele, ne a paati gi den. Da soseefi a teke den fisi paati gi den tu. ");
INSERT INTO djkNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Da disi na di fu dii toon, di Masaa Jesesi tyai enseefi kon soi den bakaman fi en baka di a weki baka komoto a dede. ");
INSERT INTO djkNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ne di den kaba nyan, ne Masaa akisi Simon Peitilisi taki: “Simon, manpikin fu Johanisi! I lobi mi moo enke den taa bakaman fu mi ya?” Ne Simon piki en taki: “Iya, Masaa! I seefi sabi taki mi lobi yu.” Ne Masaa Jesesi taigi en taki: “Luku den pikin sikapu*f18* fu mi bun.” ");
INSERT INTO djkNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ne Masaa Jesesi akisi en di fu tu toon taki: “Simon, manpikin fu Johanisi! I lobi mi?” Ne Simon piki en taki: “Iya, Masaa! I seefi sabi taki mi lobi yu.” Ne Masaa Jesesi taki en taki: “Luku den sikapu fu mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ne Masaa Jesesi akisi en di fu dii toon taki: “Simon, manpikin fu Johanisi, i lobi mi?” We, now, ne Peitilisi ati booko, fu di Masaa akisi en di fu dii toon taki, efu a lobi en. Ne a taigi Masaa taki: “Masaa! Yu sabi ala sani. Iseefi sabi tu taki mi lobi yu.” Ne Masaa Jesesi taigi en taki: “Luku den sikapu fu mi. ");
INSERT INTO djkNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Fu tuutuu mi e taigi yu Simon, di i be moo yonkuu, da iseefi be e wei i koosi, da i be e go a pe i be wani. Ma te yu o gaandi, da yu o langa i ana fu sama tei koosi gi yu, da den o tyai yu go a pe yu á be sa wani go.” ");
INSERT INTO djkNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ma Masaa Jesesi taigi Peitilisi a sani ya, fu pingi en a fesi, fu a be sabi fa en dede o waka. Da a dede fu Peitilisi ya, o hei Masaa Gadu. Ne di a taigi en so kaba, ne a kai en taki: “Kon go anga mi.” ");
INSERT INTO djkNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma di Peitilisi daai luku baka, ne a si taki a bakaman fu Masaa Jesesi di a be lobi te, e waka ne en baka tu. Da na a seefi bakaman fu Masaa Jesesi ya be sidon koosube fu Masaa Jesesi di den be e nyan a Pasika Piisii na a neti, di a be akisi en taki: “Masaa, sama na a sama di o seli yu?” ");
INSERT INTO djkNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","We, di Peitilisi si en, ne a akisi Masaa Jesesi taki: “Masaa, fa fu a sama de? San o pasa anga en dati?” ");
INSERT INTO djkNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ne Masaa Jesesi taigi en taki: “Efu mi wani a tan a libi fu te mi kon baka, san fi i de ne en? San yu mu du, na waka yu mu waka a mi baka.” ");
INSERT INTO djkNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ne fanafu a ten de, ne den taa bakaman fu Masaa be abi wan taki e taki den na den taki, a bakaman fi en ya, ná o dede. Ma Masaa Jesesi á be taki, taki a á be o dede. Ma a be taki: “Efu mi wani a tan a libi fu te mi kon baka, san fi i de ne en?” ");
INSERT INTO djkNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","We, na a seefi bakaman fu Masaa Jesesi de, ne i si e taigi yu den sani ya. Da soseefi ne en sikiifi a buku ya tu. Da wi sabi taki den sani di ai taki puu komoto ne en mofu na tuu. ");
INSERT INTO djkNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Da Masaa Jesesi du somen taa sani ete. Ma, efu den mu poti ala den sani di a du ya, wan fu wan a buku, da mi á biibi taki hii goontapu o poi oli ala den buku di den sa sikiifi ya.");
INSERT INTO djkNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mi lobi mati Teyofili! Na mi Lukasi e sikiifi a buku ya gi yu. A taa buku di mi be sende gi yu kaba, be soi san Masaa Jesesi be du, anga fa a be leli sama. ");
INSERT INTO djkNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Mi be sikiifi fa a wooko te doo a dei di Masaa Gadu puu en ya libilibi go poti ne en kondee a tapu anda. Ma fosi dati, da a Apaiti Jeje di teke en hii libi abaa be piki en fa fu taigi en apaiti bosikopuman, fu wooko go doo. Na den dati a teke poti fika a baka ya, fu paati en bosikopu. ");
INSERT INTO djkNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Bika di a dede weki baka, da na den ai soi enseefi libilibi somen leisi. Hii fotenti dei, fu den si fa a dede weki tuu. Soseefi ai leli den moo sani, fu sabi fa Masaa Gadu poti fu tii sani. ");
INSERT INTO djkNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wan fu den leisi di a soi den enseefi, namo a tapu den taki, den á mu komoto a Jelusalem Foto ete. Bika na ape den o fende a gaanbigi bun di Masaa Jesesi be taigi den kaba taki, en Tata be paamisi. ");
INSERT INTO djkNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Bika a ná o langa, da san o pasa de sa bigi moo fa Johanisi be e teke wataa dopu sama. Bika na Masaa Gadu o teke en Apaiti Jeje dopu den. ");
INSERT INTO djkNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wan fu den taa leisi di a soi den enseefi, ne den akisi en efu na a pisiten ya kaba, a o tii Dyu Kondee enke fa Masaa Gadu be paamisi, fu sende a edeman de kon enke kownu. Efu na a pisiten ya a o meke Dyu Kondee toon a moo hei kondee fu goontapu. ");
INSERT INTO djkNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Namo a piki taki: “U ná abi fu sabi ala dati. Mi Tata, Masaa Gadu á gi u pasi fu dati. En wawan namo sabi. Bika ne en poti a dei anga a ten fu ala dati. ");
INSERT INTO djkNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ma sabi namo taki, Masaa Gadu Apaiti Jeje o teke u hii libi. A o gi u kaakiti, fu puu mi toli taigi taawan a Jelusalem Foto doo Judeja pisiwataa. Soseefi Samaliya pisiwataa doo ala taa uku fu goontapu.” ");
INSERT INTO djkNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Den be taampu makandii di Jesesi kaba soi den so. Ne den si en futu e opo komoto a doti, da ai gwe a tapu, te pasa den woluku anda. Ne wan woluku wai tapu en. Na so Masaa Gadu opo en tyai gwe ne en kondee a tapu anda. ");
INSERT INTO djkNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","A kon fu den de ape e luku tapu naamo, fa a gwe so. Te fu den denki, tu Basiya fu Masaa Gadu Kondee*f1* anga weti koosi taampu a den mindii de. ");
INSERT INTO djkNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Namo den Masaa Gadu Kondee Basiya taigi den taki: “Den manengee fu Galileya pisiwataa ya! San u taampu e luku ete? A Jesesi di opo gwe a tapu tide ya, na leti ya a o saka wan dei baka komoto a tapu anda.” ");
INSERT INTO djkNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Namo den be taampu makandii na a mongo di abi a nen fu Oleifi. A á de faawe fu Jelusalem Foto, ma na wan kilomeiti faawe so. Da di sani waka so kaba, ne den komoto de gwe a Jelusalem Foto. ");
INSERT INTO djkNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Di den doo anda, ne den subi go a tapu sodoo na a kambaa pe den be e tan na a yuu di den de a Jelusalem Foto de. Den be de ape: Peitilisi Johanisi Jakowbesi Andeleyasi Filipi Towmasi Baatomeyosi Mateyesi Jakowbesi, a manpikin fu Alefeyosi Simon Selotu*f2* Judasi, a manpikin fu Jakowbesi. ");
INSERT INTO djkNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Somen leisi den be e miti makandii, fu tei ati oli doo anga begi. Maliya, a mma fu Jesesi anga den taa baala fu Jesesi be de ape tu. Wan duupu taa uman seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Namo wan fu den dei, ne Peitilisi opo taampu a den mindii. Den be de ape wan ondoo anga twenti biibisama so. ");
INSERT INTO djkNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Namo a taigi den taki: “Biibiwan! U ala sabi taki, na Judasi tyai sama go kisi Masaa Jesesi. Dati waka enke fa a Apaiti Jeje fu Masaa Gadu be piki Kownu Dafeti a fositen, fu sikiifi. ");
INSERT INTO djkNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Da a kon, na Masaa Jesesi seefi be teke Judasi makandii anga wi taa elufu poti fu du en wooko.” ");
INSERT INTO djkNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","A Judasi ya na di be tyai sama go kisi Jesesi. Ne a teke a moni di den pai en fu dati go bai wan hii pisi doti. Ma bakadati, a teke tetei tei lenge lenge enseefi kii. Namo a koti komoto anda kai kon anga mindii fesi a doti, basi en hii bee tutu komoto a doo. ");
INSERT INTO djkNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Di sama fu Jelusalem Foto yee a toli de, ne den kai a doti pe a moni fi en bai, Akeldama. Dati taki, a ini den tongo, Buulu Doti. ");
INSERT INTO djkNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Namo Peitilisi taki ete taki: “Fa a de, a hii peesi fu Judasi fika fu busi goo tapu. Sama á de fu go tan ape moo wanten. Dati waka enke fa Masaa Gadu be piki Kownu Dafeti a fositen fu sikiifi na a singi buku den e kai Psalm. Bika a be sikiifi taki: ‘Ala a peesi fi en fika fu busi goo tapu. Sama á de fu go tan ape moo wanten.’ Ma a be sikiifi tu taki: ‘Poti wan taawan ne en peesi, fu du a wooko.’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Namo Peitilisi taki ete taki: “Da wi fanowdu wan taawan a u mindii ya fu poti na a wooko a Judasi peesi. Ma a mu de wan man di be waka makandii anga wi na a hii yuu di u be e lontu makandii anga Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","A be mu waka makandii anga wi komoto fu a ten di Johanisi be e dopu sama go doo a ten di Masaa Jesesi opo gwe a tapu ya. Bika na sowan man namo sa fiti, fu poi taampu makandii anga wi taa elufu, fu bali a nyunsu taki, a dede weki kon a libi ya baka tuu.” ");
INSERT INTO djkNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Namo, den wegi go kon. Ne den fende tu man di fiti fu teke Judasi peesi, Jowsef anga Matiyasi. A Jowsef ya be abi ete tu taa nen, den be e kai Balisabasi anga Yestesi. ");
INSERT INTO djkNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Namo den begi Masaa Gadu taki: “Masaa! Gaantangi, soi wi on di fu den tu u mu teke poti na a wooko! Bika na yu e si ala sama ati. Da yu sabi on di fiti fu du a wooko. ");
INSERT INTO djkNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Te i soi wi, da u sa teke dati poti a Judasi peesi, fu du a apaiti bosikopuman fu Masaa Jesesi wooko. Bika a dede komoto a u mindii, fu go na a peesi di fiti en, fu san a du.” ");
INSERT INTO djkNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Namo, den daai wan sowtu sani, fu koti luku on di fu den tu man ya mu wini a wooko. Matiyasi wini, ne den poti en a den taa elufu apaiti bosikopuman fu Masaa Jesesi kon toon twalufu apaiti bosikopuman baka. ");
INSERT INTO djkNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","A feisiti dei den e kai Penkisite be doo. Dati na seibin wiki baka Pasika feisiti. Dyusama e kon makandii a Jelusalem Foto fu gi Masaa Gadu daa, fu lepi nyanyan di den puu a goon. Den biibiwan be mokisa a wan peesi. ");
INSERT INTO djkNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Wanboo wanboo so, ne den e yee wan sani e bali a tapu a doose anda huuw, enke wan gaan winta e wai. A sani wai kon fuu a hii osu ini pe den de. ");
INSERT INTO djkNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Namo, den si wan sani a den fesi de gei somen tongo fu faya leti mokisa a wan gaan bosu. Da ai wai paati, wan fu wan e go kisi ibii biibiwan de. ");
INSERT INTO djkNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na so a Apaiti Jeje fu Masaa Gadu teke ibiiwan hii libi abaa. Da ai gi ibiiwan, wan taa kondee sama tongo, di enseefi á be sabi taki. Ibiiwan fende a sowtu tongo di a poti gi en. ");
INSERT INTO djkNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A pisi yuu ya, da sowtu a sowtu Dyusama di e tan a taa taa doose kondee fu goontapu be kon a Jelusalem Foto de. Na be Dyusama di lobi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Namo den yee a gaan takitaki fu den biibisama. Ne den booko go taampu e luku anga ala foondoo. Bika ibiiwan fu den e yee a tongo di a diingi ne en mma bobi. Den biibisama e taki den sowtu a sowtu tongo fu den. ");
INSERT INTO djkNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ai foondoo den tuutuu, a dyombo den. A kon fu den e akisi taki: “A ná soso Galileya pisiwataa sama de ape, no? ");
INSERT INTO djkNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Da fa den du poi taki den sowtu a sowtu tongo di ibiiwan fu wi e taki a den sowtu a sowtu kondee pe u komoto?” ");
INSERT INTO djkNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Den Dyusama di be kon aliki den biibiwan de, be komoto a tyaipi sowtu kondee kon a Jelusalem Foto de. Taawan komoto na a pisiwataa fu Paltiya. Taawan komoto a Meidiya. Taawan komoto a Elam. Taawan komoto a Mesopatamiya. Taawan komoto a Judeja. Taawan komoto a Kapadosiya. Taawan komoto a Pontesi. Taawan komoto a Asiya. ");
INSERT INTO djkNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Taawan komoto a Filigiya. Taawan komoto a Pamfiliya. Taawan komoto a Egepte Kondee. Taawan komoto a Sileni Foto a Libiya Kondee. Taawan na foluku fu Loma Foto di e tan a Jelusalem Foto de. Foluku fu Loma Foto seefi di teke fu dini Masaa Gadu na a fasi fu Dyusama. ");
INSERT INTO djkNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Dyusama di e tan na a gaan tabiki Keleita Kondee seefi tu. Dyusama seefi fu Alabiya Kondee. Ala den sowtu a sowtu kulu ya taki: “Wi abi sowtu a sowtu tongo e taki. Ma fa Galileya sama du poi taki den so? Bika den e taki gaan foondoo sani di Masaa Gadu e du, da wi e fusutan den.” ");
INSERT INTO djkNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Den sama foondoo te, ne den á sabi san fu du. Taawan e taigi taawan taki: “San wani taki a sani di e pasa ya?” ");
INSERT INTO djkNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Da taawan e deleigi taki: “Fu poi meke a sani de, da na tyaipi win namo den musu diingi duungu so.” ");
INSERT INTO djkNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Namo, Peitilisi anga den taa elufu apaiti bosikopuman fu Masaa Jesesi wai kon taampu a fesi. Ne Peitilisi bali taki: “Ala Dyusama di de a Jelusalem Foto ya! Aliki bun fu yee san mi o taki!” ");
INSERT INTO djkNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Namo a taki: “Fa u sa pakisei taki, wi ya diingi duungu? Bika wi ala enke Dyusama sabi taki, u á gwenti diingi duungu neigin yuu mamanten. ");
INSERT INTO djkNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma dati na san a fositen apaiti takiman fu Masaa Gadu di den e kai Joweli be taki. Bika a be taki: ");
INSERT INTO djkNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mi enke Masaa Gadu taki: “Luku fa mi o wooko a ini den dei na a ten pe goontapu o de fu kaba. Mi o sende mi Apaiti Jeje go na ala sowtu sama. Da a o piki yu umanpikin anga yu manpikin, fa mi fiti sani poti fu waka. Foondoo fasi enke na deen, na so yonkuman a u mindii de o si san mi wani. Gaansama de seefi o deen tuutuu san mi fiti poti fu du. ");
INSERT INTO djkNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Uman anga man di e dini mi, winsi den soi lagi, ma den o fende mi Apaiti Jeje tu. Da a sa piki denseefi san fu taigi taawan. ");
INSERT INTO djkNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Soseefi hii goontapu foondoo sani o pasa a tapu anda fu si. Ondoo goontapu ya dati maiki fu san e pasa o soi fa mi bigi. Buulu o kai, gaan faya o koti anga ala gaan koko somoko. ");
INSERT INTO djkNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A san a tapu anda o kon dunguu. A mun o kon lebi enke buulu. Na so o pasa fosi a gaan dei fu Masaa kon doo. ");
INSERT INTO djkNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ma ibiiwan di teke fu bali kai Masaa, fu suku yeepi, da a o puu en a dede, gi libi tego.” ’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Namo Peitilisi taki ete taki: “Mi eigi Dyusama ya! Aliki! Jesesi di goo a Nasaleti Foto, Masaa Gadu poti tuutuu kaakiti gi en hii libi. Da ai du foondoo sani enke maiki fu si taki, na Masaa Gadu seefi e wooko de. Leti a wi kondee ganda ya a meke a waka lontu so. Bika a wani u sabi taki, ne en gi en pasi, fu wooko so. ");
INSERT INTO djkNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","A Jesesi ya na di Dyusama ya be kisi gi taa foluku kii. Ma Masaa Gadu be sabi dati a fesi. Ne enseefi be poti taki, dati musu fu pasa. ");
INSERT INTO djkNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ma dede á poi kwinsi en oli nama, enke fa ai kwinsi ala taa sani e dwengi anga pen. Bika Masaa Gadu makiti fu weki en, bigi moo dede. ");
INSERT INTO djkNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dati waka enke fa Masaa Gadu be piki en apaiti takiman Kownu Dafeti a fositen fu sikiifi taki: ‘Mi e si fa Masaa Gadu de a mi se ala yuu. Ai yeepi mi, meke sani á poi du mi. ");
INSERT INTO djkNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","A piisii di dati e gi mi bigi a mi ati! Mi e poolo singi anga tongo. Bika mi o dede seefi, ma mi ati koo ete. Mi e fitoow Masaa Gadu, fu san a poi du gi mi. ");
INSERT INTO djkNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","A ná o fika mi a dedekondee*f3*. A Apaiti Sama fi en ya, noiti a o meke dati sikin dugu dugu dede loto poli. ");
INSERT INTO djkNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bika Masaa Gadu soi mi fa fu sabi waka go fende libi tego. Da ai piisii mi ati tuutuu, fu fa a de anga mi so.’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Namo Peitilisi taki ete taki: “Mi eigi Dyu Kondee baala! Sabi taki, wi avo Kownu Dafeti be e sikiifi, ma a ná enseefi a be e taki. Bika u si taki, en dati dede, te den beli. En geebi de fu si leti a goontapu ya ete. ");
INSERT INTO djkNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ma a be e sikiifi sani di Masaa Gadu be e piki en, anga ala sweli seefi taki, dati musu fu pasa so. Masaa Gadu taki: ‘Wan bakaten pikin fu Dafeti paansu, na dati mi o gi yu kownu sutuu, fu tii sani enke yu seefi.’ A Dafeti ya na be tuutuu apaiti takiman fu Masaa Gadu, di ai piki san a fiti poti fu du. ");
INSERT INTO djkNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ne a be poi sikiifi a fesi fa a Kelestesi o dede weki kon a libi ya baka, fu tii ala sani. Bika a be sikiifi taki, dede ná o poi oli en. En dugu dugu sikin seefi noiti o loto poli.” ");
INSERT INTO djkNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Namo Peitilisi taki ete taki: “Da sabi taki, Masaa Gadu weki a Jesesi kon a libi baka tuu. Wi ya si dati anga ain, fu piki u de. ");
INSERT INTO djkNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Soseefi a kaakiti fu Masaa Gadu opo en tyai gwe a tapu anda, na a moo hei peesi ne en letise ana. Wi Tata, Masaa Gadu gi en a Apaiti Jeje fi en, di a be paamisi. Da ai gi sama dati enke fa u si pasa anga wi tide ya.” ");
INSERT INTO djkNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Namo Peitilisi taki ete taki: “Da kaba pakisei taki, san Kownu Dafeti be sikiifi de taki, ne enseefi ai taki. Bika a á opo libilibi gwe a tapu a Gadu Kondee. Ma a be sikiifi taki: ‘Masaa Gadu taigi mi Masaa taki: “Sidon a mi leti ana se ya, ");
INSERT INTO djkNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","te enke mi meke ala den feyanti fi yu toon yu futu bangi.” ’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Namo Peitilisi taki ete taki: “Da meke a hii Islayeli foluku ya seefi sabi taki, na a Jesesi ya, Masaa Gadu poti fu ala taawan kai Masaa. Soseefi a poti en, fu de a Kelestesi, di a be paamisi fu tii ala sani. Ne en seefi u de be poti sipikii kii a koloisi.” ");
INSERT INTO djkNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Namo di Peitilisi e taki, da den sama be e aliki. A hii toli ya kwinsi den na ati. Ne den akisi Peitilisi anga den taa elufu apaiti bosikopuman taki: “Baala! Wi ya dati á sabi san fu du! Na u de mu soi wi san fu du.” ");
INSERT INTO djkNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Namo den Peitilisi piki taki: “U mu daai libi, fu teke dopu a ini a nen fu Jesesi Kelestesi. Meke Masaa Gadu sa gi u paadon, fu u takuudu anga ogii. Soseefi, a o meke u fende a gaanbigi bun di taki, en Apaiti Jeje kon teke peesi a ini u. ");
INSERT INTO djkNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bika na Masaa Gadu seefi be paamisi ibii sama a Apaiti Jeje ya. Yu de seefi tu anga ala u paansu bakaten seefi. Soseefi ala taa sama, winsi pe te den de. A sa gi ala sama di a teke toon fi en seefi dati.” ");
INSERT INTO djkNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Namo Peitilisi taki taa sani ete, fu meke den sama si fa a yeepi fu Masaa Gadu de fanowdu. Namo a wasikoi den taki: “Kon komoto a ini a sitaafu di Masaa Gadu mu gi ala takuuduman di e libi nownow.” ");
INSERT INTO djkNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Namo somen fu den de biibi ala san Peitilisi taki te go teke dopu. A dei de na wan dii dunsu sama go a ini a biibi, fu toon biibisama tu. ");
INSERT INTO djkNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Da sama di teke a biibi be poti denseefi, fu tei ati oli doo, fu teke leli, anga fu du san den apaiti bosikopuman e soi den. Soseefi den be lobi kon mokisa makandii enke biibisama. Da den e booko beele nyan makandii enke fa Masaa Jesesi be soi den, fu nyan pakisei a dede fi en. Den be e tan makandii e begi naamo tu. ");
INSERT INTO djkNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Da den apaiti bosikopuman e du gaan foondoo sani naamo enke maiki fu si de taki, Masaa Gadu de anga den. Ala sama be abi gaan lesipeki fu san e pasa a den mindii. ");
INSERT INTO djkNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ala sama di be teke a biibi be mokisa libi enke wan makandii anga denseefi. Den be e yeepi den seefi a sani anga san den abi. ");
INSERT INTO djkNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Somen leisi son fu den be e seli gudu di a abi, fu teke a moni paati gi di fanowdu yeepi. Na so ibiiwan be e fende san a abi fanowdu. ");
INSERT INTO djkNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ibii dei den be e go makandii, fu begi na a Mama Keliki anda. Den be e kai den seefi kon nyan a den seefi osu. Den á be abi giili ati fu dati, ma anga ala switi fasi na ati. ");
INSERT INTO djkNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Den be e gafa Masaa Gadu. Ala sama be abi apaiti lesipeki fu den. Ibii dei Masaa Jesesi be e tyai yeepi, fu moo sama komoto a takuudu anga ogii, da a kulu e goo. ");
INSERT INTO djkNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Da wan fu den dei, dii yuu bakadina so, ne Peitilisi anga Johanisi e go na a Mama Keliki, fu go begi. Bika Dyusama be gwenti go begi anda den ten de. ");
INSERT INTO djkNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Namo den de fu pasa na a doo di abi a nen fu Moi Doo, fu go a ini a Mama Keliki. Ma wan lanman be sidon na a doo mofu de. Senten en mma meke en, ne a de lan lan, a á poi waka. Ibii dei, sama e diki en tyai go saka de, fu begi moni. Da ai fiingi ana naamo e begi ala sama di e kon e gwe. ");
INSERT INTO djkNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Namo a si Peitilisi anga Johanisi e waka kon a ini a Mama Keliki. Ne a fiingi ana wanten go begi den seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ma den towe ain luku en dunn ne en mindii fesi. Ne Peitilisi taigi en taki: “Luku wi bunbun baka.” ");
INSERT INTO djkNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Namo a lanman luku den a den mindii fesi baka. Da ai pakisei taki: “Mi o fende wan bun a den tu man ya.” ");
INSERT INTO djkNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Namo Peitilisi taigi en taki: “Moni anga taa sowtu gudu, dati mi ná abi, fu gi yu! Ma na san mi abi, dati mi e gi yu. A ini a nen fu Jesesi Kelestesi fu Nasaleti Foto, opo waka wanten!” ");
INSERT INTO djkNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Namo Peitilisi langa ana hali en letise ana, fu a opo taampu. Wanten so den futu fi en kisi kaakiti taanga a doti, fu waka. A betee. ");
INSERT INTO djkNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Namo a dyombo opo taampu, da ai waka e go e kon. A á sabi pe fu poti enseefi. Ai waka e daai e lontu e dyombo a tapu, da ai bali e gafa Masaa Gadu. Na so ai waka e gwe makandii anga Peitilisi anga Johanisi a ini a Mama Keliki tu. ");
INSERT INTO djkNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ala sama ape si fa ai waka e bali e gafa Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Da den e taki: “Na a lanman di á be poi waka de ape. A be lobi sidon na a doo mofu fu Moi Doo e begi moni.” Den sama foondoo te, den á sabi san fu du, fu san pasa anga a lanman de. ");
INSERT INTO djkNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Namo a go oli Peitilisi anga Johanisi na ana. Ala sama ape booko kon taampu e foondoo. Den be de na a baikon di meke langa langa a bansa se fu a Mama Keliki, den e kai Salomo Baikon. ");
INSERT INTO djkNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Namo di Peitilisi si den kon lontu so, ne a taigi den taki: “Mi eigi Dyu! U e foondoo fu san pasa ya? Ma ná taampu luku wi ya enke na wi abi kaakiti betee a lanman! A ná bun libi fu wi tu meke u poi du dati!” ");
INSERT INTO djkNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A taigi den doo taki: “Na Masaa Gadu du a foondoo wooko ya. Wi avo Abalaham be e dini en. Isaki anga Jakopu doo ala taa avo tu. A gi en wookoman Jesesi dyendee. Ma u enke Dyusama ya be kisi en gi Gaaman Pilatesi, fu du ogii anga en gi u. Ma a á be poi fende fowtu fi en, fu sitaafu so, ne a be wani u losi en. Ma u á be wani, bika u á be abi bisi anga en. ");
INSERT INTO djkNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ma u meke a losi wan gaan ogii ati man di e kii sama, pe fi en. U be si ala dati enke wan bun Gaaman Pilatesi du gi u. U á be abi bisi anga di de letiopu ala yuu a Masaa Gadu fesi anga ala hii libi kiin sai gi en. ");
INSERT INTO djkNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Soseefi ne en Masaa Gadu poti fu tyai sama go fende a libi fi en. Ma u dati poti en kii. Ma Masaa Gadu dati weki en kon a libi baka. Wi ya si dati anga ain, fu piki u de. ");
INSERT INTO djkNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na a seefi Jesesi de kaakiti fu du foondoo sani so. Na a biibi namo di a lanman ya poti a ini a nen fi en, ne a nen fi en betee en. Ne a futu fi en di u seefi be sabi taki, lan kon taanga a doti so. A betee leti a wi ala fesi tide ya, fu u sa si dati anga ain.” ");
INSERT INTO djkNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Namo a taki ete taki: “Mi eigi Dyu foluku! Na u be du ogii anga en te doo kii en seefi. Ma saide u be poi du dati? U á sabi, den edeman fu Dyu keliki di e taki gi kondee ya seefi á sabi tu. ");
INSERT INTO djkNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ma sabi now taki, Masaa Gadu be piki en fositen fu sikiifi taki, dati musu fu pasa anga en. Den be sikiifi taki, a Kelestesi di paamisi fu sende kon tii ala sani, dati o teke pina fosi te doo dede seefi.” ");
INSERT INTO djkNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Namo a taki ete taki: “Ma luku san fu du now! Fii tyali fu u takuudu anga ogii. Da daai libi! Meke Masaa Gadu sa gi u paadon taki, a figi ala san u be du pasa kaba. Soseefi, u jeje libi o fende kaakiti, fu poi libi a hii pisi yuu ya anga boo. ");
INSERT INTO djkNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Na sowan fasi u sa libi go doo a dei, di a o sende a Kelestesi kon baka gi u, fu tii ala sani. Dati na Jesesi di a be paamisi langa ten a fesi kaba. ");
INSERT INTO djkNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","A opo gwe a tapu nownow, fu te enke a yuu kisi di a fiti poti fu seeka ala sani kon nyun. Dati o waka enke fa apaiti takiman di hii libi kiin gi en be sikiifi, fa a o seeka ala sani kon nyun.” ");
INSERT INTO djkNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Namo a taki: “Masaa Gadu be piki en fositen apaiti takiman Mosesi, fu sikiifi taki: ‘Masaa Gadu paamisi en moo gaan apaiti takiman, fu tyai a foluku enke fa mi be tyai a foluku. A o meke libisama enke ibii taa sama, ma na dati taki ibii taawan mu teke. ");
INSERT INTO djkNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sama di á wani teke en taki ná o poi libi a ini Masaa Gadu foluku. Ma a o dede komoto a ini dati.’ ");
INSERT INTO djkNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","A be piki taa fositen apaiti takiman tu, fu sikiifi sani fu dati. Komoto fu Samuweli doo ala taawan di waka ne en baka be sikiifi. Na san a be piki den taki, musu fu pasa e pasa na a ten fu wi ya.” ");
INSERT INTO djkNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Peitilisi soi ete taki: “Da fa Masaa Gadu be piki apaiti takiman a fositen, fu sikiifi gi wi avo, da na wi enke bakaten pikin fu den ya mu wooko anga a kuudei di a be fiti anga den de. Luku san a be taigi wi moo gaandi avo Abalaham taki: ‘A Kelestesi o meke a ini a paansu sama fi yu, fu seigi hii goontapu.’ ");
INSERT INTO djkNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","We, da a sende en wookoman Jesesi kon a u mindii ya kaba. A fosi peesi pe a bigin wooko, da na u kondee ya a kon, fu seigi u taki, a o puu u a takuudu anga ogii.” ");
INSERT INTO djkNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na ape den de e taki anga den sama. Namo wantu apaiti begiman anga wantu Saduseiman waka kon a den tapu. A basi fu den wakiti na a Mama Keliki seefi tu. ");
INSERT INTO djkNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Den kon anga ala gaan boon ati. Bika den yee den e leli sama sani di nái kai gi den. Den á wani yee taki, a dede weki baka fu Jesesi e soi fa dedesama o weki baka. ");
INSERT INTO djkNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Namo den gaapu den tyai go sooto. Den be kaba fu tyai den go a kuutu kaba. Ma neti be doo kaba. Ne den sooto den fu kuutu tamaa mamanten.*f4* ");
INSERT INTO djkNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma somen sama di be aliki a taki be teke biibi a dati, fu daai toon biibisama. Na so a kulu biibiwan be e goo naamo. Boiti fu teli uman, da a be doo feifi dunsu biibi manengee kaba. ");
INSERT INTO djkNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A tamaa mamanten, ne den bigiman fu Dyu keliki anga den gaansama fu paandasi kon miti makandii a Jelusalem Foto de, fu oli a kuutu. Soseefi leliman fu Dyu weiti seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi, a moo hei apaiti begiman na a Mama Keliki seefi. Soseefi Kayafasi anga taa taa famii a ini a paansu sama di e tyai a wooko ya. Johanisi anga Aleksandi seefi tu. ");
INSERT INTO djkNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Namo den tyai Peitilisi anga Johanisi kon taampu a den fesi, da den e akisi den taki: “Pe u fende a kaakiti di deesi a lanman ya? Sama nen abi a makiti di u be teke wooko, fu poi du dati?” ");
INSERT INTO djkNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Namo wanten de, a Apaiti Jeje fu Masaa Gadu di teke Peitilisi hii libi dati piki en kaba san fu piki. Ne a taki: “Bigiman fu Dyu keliki anga gaansama fu paandasi! U aliki! ");
INSERT INTO djkNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Na wan gaan bun u du, ne dati tyai wi kon a kuutu! Bika na wan sikiman kon bun. ");
INSERT INTO djkNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Hii Dyu Kondee mu sabi taki, a nen fu Jesesi abi makiti. Na dati deesi a lanman. Jesesi Kelestesi fu Nasaleti Foto. U de be poti en sipikii kii, ne Masaa Gadu weki en baka. ");
INSERT INTO djkNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Bika en Buku sikiifi taki: ‘Disi na a siton di meseeman be oli fu wan soso sani. Na dati daai kon toon a siton futu fu a hii osu.’ ");
INSERT INTO djkNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bika ne en namo poi puu wi na a pasi fu takuudu anga ogii. Goontapu ná abi wan taa nen di Masaa Gadu poti fu sama teke kai fende a yeepi ya.” ");
INSERT INTO djkNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","We, den si Peitilisi anga Johanisi e taki sondee feele. Ne den foondoo taki: “Den man ya á de leliman anga hei sowtu sama fu kondee. Ma fa den du poi taki so? Namo den pakisei fa den be e si den e waka e lontu makandii anga Jesesi.” ");
INSERT INTO djkNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Namo den kon si tu taki, den á du ogii fu gi sitaafu. Bika a lanman di deesi seefi de leti ape. ");
INSERT INTO djkNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Namo den puu den poti a doose fu a kuutu peesi. Bika den wani fiti a ondoo luku san fu du anga den. ");
INSERT INTO djkNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Namo den fiti taki: “San fu du anga den? Bika na wan gaan foondoo sani den du tuutuu enke wan maiki a hii lanti fesi. Wi á poi kibii a taki de. Ala sama a Jelusalem Foto ya si dati. ");
INSERT INTO djkNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wi o pii ain gi den taki, noiti moo den mu taki sani kai a nen fu a Jesesi de. Da fa den deesi a lanman ná o poi paati moo faawe a ini a kondee tu.” ");
INSERT INTO djkNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Namo den kai den kon a ini a kuutu peesi baka. Ne den wasikoi den taki: “U mu kaba leli sama sani a ini a nen fu a Jesesi de. Noiti moo u mu kai a nen de moo a wan peesi.” ");
INSERT INTO djkNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Namo den Peitilisi piki taki: “Teke luku san o moo bun gi Masaa Gadu. Daai aliki san u enke libisama de wani ofu tan du a wooko di enseefi sende wi? ");
INSERT INTO djkNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","We, wi dati á poi kaba taki san wi seefi ain si Jesesi du anga ala san a taki. Soseefi ala san u yee fi en.” ");
INSERT INTO djkNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Namo den kuutu puu moo kaasi fu tapu den. Bakadati, ne den losi den fii fu gwe. Bika den á poi fende fowtu a den, fu gi sitaafu. Soseefi, a hii foluku be e gafa Masaa Gadu fu san pasa anga a lanman. ");
INSERT INTO djkNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Bika a lanman di deesi ya be pasa fotenti yali kaba. Na solanga a be abi a siki kaba. ");
INSERT INTO djkNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Namo di den losi den, ne den gwe a mindii fu den taa biibiwan baka. Ne den taigi den fa bigiman fu Dyu keliki anga gaansama fu paandasi kuutu anga den taki, den á mu kai a nen fu Jesesi moo fu leli sama sani. ");
INSERT INTO djkNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Den taawan aliki, ne den begi makandii taki: “Masaa Gadu! Yu abi ala makiti, fu meke ala sani. Yu meke yu kondee anga ala san de a tapu anda. Yu meke goontapu anga ala san de ya. Yu meke den ze anga ala san de a ini den wataa fu den peesi. ");
INSERT INTO djkNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yu Apaiti Jeje be piki yu wookoman Dafeti di de wi avo gaansama, fu sikiifi taki: ‘Den di á sabi Masaa Gadu abi gaan boon ati e puu kaasi. Foluku fu goontapu e fiti makandii fu du ogii. Ma saide, no? ");
INSERT INTO djkNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Soseefi kownu fu goontapu anga taa bigiman, di e taki fu kondee, sete fu sitee anga Masaa Gadu. Den e seeka fu feti anga Awan, di Masaa Gadu paamisi, fu sende kon tii ala sani.’ ");
INSERT INTO djkNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Na tuu taki! Luku fa den opo makandii ya, fu feti anga yu wookoman Jesesi di de apaiti gi yu. En di yu poti fu tii ala sani. Den simpan ana e feti fu Gaaman Pontiyesi Pilatesi doo Kownu Helowdesi anga a hii Dyu foluku. ");
INSERT INTO djkNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ma ala dati á de nyun sani gi yu. Bika na yu seefi be poti anga yu makiti a fesi kaba taki, dati musu fu pasa. ");
INSERT INTO djkNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","We, da Masaa! Soi wi san fu du! Luku den ogii di den taki den o du anga wi. Da meke wi ala enke wookoman fi yu fende kaakiti e taki yu bosikopu fu Masaa Jesesi sondee feele. ");
INSERT INTO djkNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Poti ana yeepi wi fu gi yu bosikopu. Meke foondoo sani e pasa enke maiki fu soi yu makiti. Sikiman mu e kon bun. A kaakiti di yu poti gi Jesesi yeepi wi du ala den sani ya, bika yu poti en apaiti fasi.” ");
INSERT INTO djkNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Fa den e begi, ne a hii doti, a peesi de seke. Na wan maiki soi fa Masaa Gadu e yee den begi. A Apaiti Jeje fi en teke den hii libi wanten de tu. Ne den opo sondee feele go paati a bosikopu fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Da ala den di toon biibisama be e denki go na a wan se. Den be abi a seefi fii fu du sani. Sama abi wan sani nái oli en fi en wawan namo. Ma a be e poti en fi en anga den taawan wooko makandii. ");
INSERT INTO djkNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Da a bosikopu fa Jesesi dede weki kon a libi ya baka be e komoto a den twalufu apaiti bosikopuman mofu wan fasi di e wooko anga kaakiti. Da Masaa Gadu e wooko fu tyai bun gi ibii biibiwan. ");
INSERT INTO djkNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Sama á be de a den mindii di be e pina fu san a fuka. Bika somen biibiwan di be abi wan pisi doti ofu wan osu seefi seli dati meke moni. ");
INSERT INTO djkNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Da ai tyai dati go poti a den twalufu apaiti bosikopuman ana, fu yeepi a wooko. Da te wan sama be fuka, da den be e teke puu a ini san mokisa makandii de, fu yeepi. ");
INSERT INTO djkNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Wan man a ini den taa biibiwan, den e kai Jowsef. Den apaiti bosikopuman be gi en wan nen den e kai Balnabasi. Dati taki, Manpikin di e du sani, fu koo taawan ati. Na wan Dyusama fu Leifi Lo, ma a be meke a doose fu Dyu Kondee na a gaan tabiki den e kai Sipolosi Kondee. ");
INSERT INTO djkNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","A be abi wan hii pisi doti, di a seli meke moni. Ne a tyai dati go poti a den apaiti bosikopuman ana, fu yeepi a wooko. ");
INSERT INTO djkNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ma wan man be de ape den e kai Ananiyasi. Ne en uman den be e kai Safila. A be abi wan pisi doti tu di a go seli, fu tyai a moni kon yeepi a wooko. ");
INSERT INTO djkNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ma a teke afu fu a moni di a doti puu oli fi enseefi. Ne a tyai afu go gi den apaiti bosikopuman, fu yeepi a wooko. Da ai leli taki, na ala dati. Na so en anga en uman Safila be miti mofu a baka. ");
INSERT INTO djkNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ma Peitilisi piki en taki: “Ananiyasi! Saide i meke didibii lai yu ati so, fu puubei koli wi so? Bika i oli afu fu a moni di a doti puu! We, koli wi, da na a Apaiti Jeje fu Masaa Gadu seefi i puubei fu koli de! ");
INSERT INTO djkNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ma a á be de fanowdu, fu meke lei kon koli wi so. Bika a goon na be fi yu, winsi i be seli anga yu á be seli en. Da i be sa du san i wani anga a moni di a puu, sondee fu meke lei. Bika fu kon koli wi, da na Masaa Gadu seefi i puubei fu koli de.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Fa i si Ananiyasi kaba yee den sani ya, a lulu kai a doti wanten dede koo pii. Ala sama di yee a toli ya, a gi den feele. ");
INSERT INTO djkNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wan duupu yonkuman be de ape lolo en a ini sibi koosi, tyai go beli puu wanten. ");
INSERT INTO djkNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Wan dii yuu a baka so, ne en uman Safila seefi kon doo de. A á be sabi taki, na so pasa anga en man. ");
INSERT INTO djkNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Namo Peitilisi akisi enseefi taki: “Safila? A moni di i man tyai kon ya, na ala dati a doti seli?” Namo Safila piki wanten taki: “Eeye! Na ala a moni di a doti puu.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ne Peitilisi piki en baka taki: “Safila! Saide yu anga i man miti mofu a baka, fu kon koli wi so? Na a Apaiti Jeje fu Masaa Gadu u e puubei luku efu ai wooko? We, aliki tyaa tyaa na a baka doo de! Na den di kaba beli i man e waka kon doo de baka so. Den o tyai yu seefi go beli.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Fa i si Peitilisi kaba taki so, Safila lulu kai a doti, dede koti boo pii. Den di be go beli en man waka kon si en dede dede. Den teke enseefi go beli se anga se anga en man. ");
INSERT INTO djkNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","San pasa ya seke den biibisama anga ibii taawan di yee dati. A gi den feele, fu moo lesipeki Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Da naamo Masaa Gadu e meke den apaiti bosikopuman e du somen foondoo sani a Jelusalem Foto de. Ala dati e soi fa Masaa Gadu bigi. Soseefi den biibisama be e fiti go makandii na a Mama Keliki enke fa den be gwenti. Na so den e bosu na a baikon fu a Mama Keliki de, di abi a nen fu Salomo Baikon. ");
INSERT INTO djkNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sama di nái biibi á be e abi deki ati fu go a den mindii. Den be e lesipeki den anga ala gafa fa den e libi. ");
INSERT INTO djkNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Moo anga moo uman anga man be e teke biibi toon biibiwan makandii anga den. Biibiwan e kon moo ipi tyaipi tyaipi. ");
INSERT INTO djkNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Den apaiti bosikopuman e du foondoo sani. Da a hii peesi e tyai sikiman a daagi go saka a ganda, fu den deesi. Den e biibi fu Peitilisi waka pasa namo, fi en kaaka meke den betee. ");
INSERT INTO djkNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Sama di e tan a den pikin foto lontu Jelusalem Foto yee san e pasa de. Den seefi booko tyai sikiman kon. Den tyai sama di takuu jeje e muliki. Denseefi kon bun tu. ");
INSERT INTO djkNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Namo dyalusu kon miti den apaiti bosikopuman. A moo hei Dyu na a Mama Keliki anga a kulu Saduseiman fi en yee san den e du. Ne den dyalusu. Namo den poti taki, den o du wan sani anga den. ");
INSERT INTO djkNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ne den meke den kisi den tyai go sooto. ");
INSERT INTO djkNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ma di neti doo, ne Masaa Gadu sende wan Basiya fi en*f5* go opo a dunguu osu doo. Ne a puu den apaiti bosikopuman go poti a doose fu a dunguu osu. Ne a taigi den taki: ");
INSERT INTO djkNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“U gwe na a Mama Keliki go leli sama a nyun sowtu libi di Masaa Gadu wani gi den.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Den du san a taki. Fuuku mamanten den go leli sama anda. A mamanten de, a moo hei Dyu anga den sama fi en hali gwe na a kuutu peesi. Gaansama fu paandasi di e kuutu sani tu. Wookoman fu den go na a dunguu osu, fu tyai den apaiti bosikopuman kon kuutu. ");
INSERT INTO djkNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ma di den wookoman go doo na a dunguu osu, ne woo. Den apaiti bosikopuman á de a ini. Namo den daai kon taigi den sama di e oli a kuutu. ");
INSERT INTO djkNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Den taki: “Wi á poi fusutan san pasa de. Den doo fu a dunguu osu de sooto sooto. Wakitiman taampu a fesi fu den sooto sooto doo. Ma woo, di u opo doo go a ini, sama á de a ini.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","We, a basi fu wakitiman anga den moo hei apaiti begiman, na a Mama Keliki aliki, te a kaba. Ne den á sabi san fu du. Den e pakisei taki: “San pasa anga den man di u be sooto?” ");
INSERT INTO djkNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na ape den de, ne wan sama kon doo a den tapu anga wan bosikopu taki: “Kon go luku dise! Den man di u be sooto go baka na a Mama Keliki, da den e leli sama sani anda.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Namo, a basi fu den wakitiman anga den ondooman fi en go kisi den apaiti bosikopuman anda. Ma den á kisi den ogii fasi. Den feele enke den Dyusama ati be sa boon a den, fu naki den kii anga siton enke fa den gwenti, te den ati boon. ");
INSERT INTO djkNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Namo den teke den apaiti bosikopuman tyai kon na a kuutu peesi. Ne den poti den taampu a den fesi. Namo a moo hei Dyu de taki, a o soi den san na a ogii di den du. ");
INSERT INTO djkNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","A taki: “Wi be bali u fu kaba leli sama sani di Jesesi be taki. Ma u á teke! U moo fuu a kondee ya seefi anga a leli de. Soseefi u e waka e kaagi wi ya taki, u be kii a Jesesi de.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Namo Peitilisi anga den taa apaiti bosikopuman piki taki: “Wi á poi teke a taki fu u de. Bika namo namo wi ya mu du san Masaa Gadu sende wi. Da u á poi teke sama taki bigi enke dati.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Soseefi a soi ete taki: “Na a Gadu ya wi avo gaansama be e dini. Ne en weki Jesesi puu a dede, di u Dyusama de sipikii kii a koloisi. ");
INSERT INTO djkNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ne a tyai en gwe ne en kondee a tapu, go poti sidon na a moo hei peesi ne en leti ana se. Ne en a be paamisi, fu poti tii sani. Soseefi a Yeepiman fu puu Islayeli Kondee a ini takuudu anga ogii. Meke den sa daai libi, fu fende paadon a Masaa Gadu, fu ala san den be du pasa kaba.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Den soi ete taki: “Wi di taampu a u fesi ya na kotoigi di si san Masaa Gadu du, fu taki baka. Sama di e aliki wi, da a Apaiti Jeje e piki en taki, na tuu. Bika ai teke peesi a sama di wani teke Masaa Gadu taki.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Namo, di den kaba aliki den Peitilisi, ne den ati taki, a o boon. Den be kaba fu tyai ala den apaiti bosikopuman go kii. ");
INSERT INTO djkNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Na Gamaliyeli enke wan fu den man a ini a lanti fu kuutu tapu dati. Na wan Faliseiman di de leliman fu Dyuweiti tu. Ala sama e lesipeki en. Ne en meke den poti den apaiti bosikopuman a doose fosi. ");
INSERT INTO djkNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ne a taigi den taawan taki: “Mi eigi Dyusama! Mi o taki wan sani di u mu denki, fosi u du sani anga den man ya! ");
INSERT INTO djkNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Luku san be pasa a fesi. A man den be e kai Tewdasi be tyai enseefi enke bigiman. Fo ondoo sama be e waka ne en baka, fu du san ai taki. Ma sama fende en kii panya a hii kulu sama fi en fika a yayo. ");
INSERT INTO djkNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Baka fu dati, a man den e kai Judasi fu a pisiwataa fu Galileya. A be tyai enseefi bigi tu, na a ten di lanti be e teli sama. Somen sama be waka ne en baka, ma sama be fende en kii panya a hii kulu sama fi en fika a yayo tu. ");
INSERT INTO djkNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Da mi e taki, u fika den man di u kisi ya. Efu a basi fu den na libisama tu, da a wooko fu den musu booko so tu. A leli di den e tyai seefi o doo wan kaba tu. ");
INSERT INTO djkNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma fu na Masaa Gadu na basi fu a wooko fu den, da wi ná o poi tapu dati, winsi san wi o du. A o kon taki, wi e feti anga Masaa Gadu seefi.” ");
INSERT INTO djkNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Namo den taawan a ini a lanti fu kuutu teke san a taki. Den á kii den apaiti bosikopuman moo enke fa den be denki. Den kai den kon a ini namo, meke wookoman wipi den. Ne den taigi den taki: “U sa gwe! Ma u mu kaba taki sani a ini a nen fu a Jesesi de, fu leli sama sani!” ");
INSERT INTO djkNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Namo den apaiti bosikopuman komoto de anga ala gaan piisii na ati. Den fende taki, Masaa Gadu teli den bigi fu meke den e tuka anga toko fu a Nen fu Masaa Jesesi Kelestesi ede. ");
INSERT INTO djkNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Namo den teke ibii dei e leli sama a Bun Nyunsu na a Mama Keliki. Den e soi den fa Masaa Jesesi na a Kelestesi. ");
INSERT INTO djkNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A ten ya, Dyusama di e teke a biibi kon ipi. Ma wan sowtu buuya kon a den mindii. A kulu di e taki Giiki Tongo fende taki, Hebelei Tongo wan e paati bee ibii dei anga den. Te den e du a wooko, fu paati nyanyan gi biibi uman di man dede fika a ganda. Da den e moo luku a kulu fu denseefi. ");
INSERT INTO djkNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Namo den apaiti bosikopuman kai a hii kulu biibiwan a kuutu. Ne den taki: “Wi enke apaiti bosikopuman na fu paati Masaa Gadu bosikopu bunbun. Wi á poi wai dati poti a baka, fu teke sete nyanyan toli. ");
INSERT INTO djkNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Da u e sende u fu suku seibin man tyai kon a fesi, fu wi ya poti na a wooko de. A Apaiti Jeje mu teke den hii libi fu gi den koni fu libi. ");
INSERT INTO djkNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Te den seibin o de na a wooko, da wi enke apaiti bosikopuman o poi poti ede namo fu begi. Soseefi, fu paati a bosikopu.” ");
INSERT INTO djkNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","San fiti de bun gi ala biibiwan. Ne den suku seibin man di sa fiti a wooko. Filipi, Pokolesi, Nikanolu, Timon anga Palmeinasi. Nikolayesi enke biibiwan, ma na Antiyokiya sama di be teke Dyu fu dini. Stefanisi di libi be bun fu a wooko. A Apaiti Jeje be lai en hii libi, soseefi taanga biibi. ");
INSERT INTO djkNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Na den man ya den tyai kon a fesi, ne den apaiti bosikopuman poti ana begi gi den. ");
INSERT INTO djkNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Namo a bosikopu fu Masaa Gadu taki, a o wooko taanga a Jelusalem Foto. Tuutuu, moo sama e teke a bosikopu, da biibisama e moo ipi naamo. Wan hii kulu begiman fu Dyu keliki seefi teke biibi. ");
INSERT INTO djkNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","A Apaiti Jeje di lai Stefanisi hii libi dati e gi en kaakiti. Da ai waka e du foondoo sani de, enke maiki fu soi fa Masaa Gadu bigi. Masaa Gadu seefi be teke gaan bun ati fasi namo, fu yeepi en seefi seefi, a ini ala sani. ");
INSERT INTO djkNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Namo wan duupu sama kon sitee anga en, fu a leli fu Masaa Gadu di ai tyai. Dyusama fu Sileni Kondee anga Alekisandiya Foto, fu wan Dyu keliki den e kai, Fii Saafu Keliki. Wantu Dyusama fu Silisiya anga Asiya seefi kon anga den. ");
INSERT INTO djkNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma Stefanisi be e wooko anga koni fu taki anga den. A Apaiti Jeje di lai en hii libi be e piki en san fu taki. Da den á be e poi sitee anga san ai taki. ");
INSERT INTO djkNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Namo den go pai sama fu lei gi en taki, den yee ai taki takuu fu Mosesi anga ala taa Masaa Gadu seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Soseefi den du sani fu poti en ogii na a hii foluku fesi. Den meke gaansama fu paandasi anga leliman fu Dyuweiti seefi ati boon ne en. Ne den disi sende sama go kisi en hali tyai go a kuutu. ");
INSERT INTO djkNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Den tyai sama kon na a kuutu tu, di mu lei gi en taki: “U yee pe ai taki takuu, fu a Mama Keliki di de apaiti fasi gi Masaa Gadu. A taki takuu fu weiti di wi avo Mosesi fika gi wi tu, fu soi fa fu dini.” ");
INSERT INTO djkNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Den soi ete taki: “A be taki taki, a Jesesi fu den di goo a Nasaleti Foto o booko a hii Dyu Mama Keliki. A o kengi a hii fasi fa Mosesi fika gi wi, fu dini.” ");
INSERT INTO djkNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Namo a hii Dyulanti di e kuutu sani daai luku Stefanisi a mindii fesi. Den si en hii fesi e beenki wan apaiti dyendee fasi enke en na wan Basiya fu Masaa Gadu Kondee*f6*. ");
INSERT INTO djkNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Namo a moo hei apaiti begiman akisi Stefanisi taki: “Fa den taki de, na so yu e wooko tuu?” ");
INSERT INTO djkNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Namo a piki taki: “Mi Dyusama anga ala dda ya, u aliki! Masaa Gadu na a gaan dyendee Gadu fu gi gaandi. Na so a be soi enseefi a Abalaham enke moo gaandi avo pe u paansu komoto, fosi a be go tan a Halan Foto. A be de a Mesopatamiya Kondee. ");
INSERT INTO djkNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Na ape a go taigi Abalaham taki: ‘Komoto fika ala i famii anga ala i kondee ya! Mi wani tyai yu go poti na a kondee pe mi wani i mu tan seefi.’ ");
INSERT INTO djkNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Namo a komoto a Mesopatamiya dati na a kondee fu Kaldea sama go tan a Halan Foto, te enke en dda dede. Ne a puu en de, tyai kon poti na a kondee pe u de tide ya. Disi na Kanahan Kondee fu fosi. ");
INSERT INTO djkNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ma Abalaham tan ya sondee a kondee de fi en. Wan pisi doti seefi á be toon fi en. Na a paamisi namo be de taki: ‘Mi o poti a kondee a yu paansu ana.’ A ten de, a be de sondee pikin ete seefi.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Namo a soi ete taki: “Ma a be taigi Abalaham taki: ‘Wan ten e kon bakaten, da a paansu fi yu o komoto ya go fika a sama kondee, fo ondoo yali langa enke saafu. ");
INSERT INTO djkNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mi o abi fu sitaafu a foluku di e saafu den, fu dwengi den losi den, meke den daai kon teke a peesi ya toon fu den seefi. Bika na ya den mu kon tan, fu dini mi.’ ");
INSERT INTO djkNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","A taigi en ete taki: ‘Manpikin di meke a yu paansu sama, da u mu koti maiki a manpeesi gi en, fu toon sama fu mi. Da san mi paamisi yu o de gi den tu.’ We, Isaki meke, a koti so baka aitin dei. Jakopu meke, letiso. Den twalufu baala di sete den twalufu lo soseefi.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Namo Stefanisi soi ete taki: “Dyalusu meke den twalufu baala enke avo di sete den twalufu lo be seli Jowsef wan fu den baala gwe a Egepte Kondee. Ne dati toon saafu anda, ma Masaa Gadu de anga en. ");
INSERT INTO djkNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","A teke gaan bun ati fasi namo luku en, a ini ala san e kon tuka anga en. Da ai gi en koni fu wooko. Ne Fala-ow fu Egepte Kondee lobi en. A poti en enke moo bigiman, fu yeepi en tii kondee. Soseefi, fu taki gi en osu anga san a abi. ");
INSERT INTO djkNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Na a ten de wan gaan angiiten o naki Egepte Kondee anga Kanahan Kondee. Nyanyan á be de ape moo fu den avo fu wi de fende bai. ");
INSERT INTO djkNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Namo Jakopu enke dda fu den twalufu baala yee fa na Egepte Kondee namo nyanyan de fu fende bai. Ne a sende den manpikin fi en, fu a fosi leisi go bai anda. ");
INSERT INTO djkNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Di den go kon, te wan pisi nyanyan kaba baka fika den. Ne a dda sende den go bai du fu tu leisi. Ne fosi Jowsef meke den sabi taki, en na den baala di den be seli. Na so a Fala-ow seefi kon sabi den famii fi en. ");
INSERT INTO djkNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Ne Jowsef sende teke en dda Jakopu kon poti a Egepte Kondee. Soseefi ala taa famii fi en a Kanahan Kondee. Makandii den be de seibintenti na feifi sama. ");
INSERT INTO djkNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Na so wi avo Jowsef anga en dda Jakopu anga den elufu baala go fika a Egepte Kondee. Den tan ape, te enke ibiiwan dede dei doo, di a mu dede. ");
INSERT INTO djkNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ma den á beli anda. Den be e kon beli a pe den be komoto a Sikem Kondee na a gaan siton olo pe Abalaham be e beli en famii. A be bai dati a den manpikin fu Hemoli.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Namo Stefanisi soi ete taki: “Da a paansu di komoto a den avo fu wi be fika a Egepte Kondee. A foluku goo kon bigi di somen yali pasa. Ne a yuu diipi doo fu san Masaa Gadu be paamisi Abalaham taki, musu fu pasa. ");
INSERT INTO djkNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Namo libi daai gi den a Egepte Kondee di somen yali diipi pasa. Sowtu a sowtu Fala-ow kengi komoto na a kownu wooko. Wan doo na a wooko di á be abi bisi anga fa Jowsef be yeepi Egepte Kondee. ");
INSERT INTO djkNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A bigin libi takuu anga den avo fu wi. A koli den poti a pina, da ai dwengi den fu towe ibiiwan yonkuu pikin di den meke.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Stefanisi soi ete taki: “Na a yuu ten de Mosesi meke enke wan moi yonkuu pikin gi Masaa Gadu. En mma anga en dda á towe en kii. Ma den kibii en solugu dii mun langa a ini osu. ");
INSERT INTO djkNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Di a kon bigi fu kibii solugu a ini osu, ne den poti en a wan peesi, fu sama fende teke. Ne a umanpikin fu Fala-ow fende en teke kiya enke eigi pikin di a meke. ");
INSERT INTO djkNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Na so Mosesi kiya enke Egepte sama. A leli ala koni di den be abi fu leli wooko. Ala en du anga ala en taki be e dwengi lesipeki.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Stefanisi soi ete taki: “Di Mosesi goo doo fotenti yali so, ne a fii fu daai ana luku den sama fi en. A iti ain na a pina fu den enke saafu. ");
INSERT INTO djkNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Namo wan dei, ne a si wan Egepte e pina wan Dyu. Ne a naki a Egepte kii seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","A membee enke dati be o opo en foluku ain, fu si taki, Masaa Gadu poti en, fu yeepi den puu na a saafu. Ma den á si a toli so. ");
INSERT INTO djkNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Bika a tamaa fi en, ne tu Dyusama e feti. Namo a dyombo a mindii, fu koti a toobi taki: ‘U na baala anga baala enke Dyusama. U á mu du ogii anga u seefi.’ ");
INSERT INTO djkNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Namo a Dyu di e suku a feti toto Mosesi puu ne en se. Ne a piki taki: ‘Sama poti yu fu basi wi? Sama poti yu enke lanti fu kuutu gi wi?’ ");
INSERT INTO djkNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A taki go doo taki: ‘San leti i wani du anga mi? I membee yu o fende pasi kii mi enke fa i kii a Egepte eside ya?’ ");
INSERT INTO djkNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na so a konkuu Mosesi, meke Mosesi be musu fu lowe komoto de go tan a Midiyan Kondee. A teke uman libi anda seefi meke tu manpikin. Ma ai fii enseefi anda naamo, enke a de a sama kondee.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Stefanisi taki ete taki: “Di a tan fotenti yali anda, ne a Basiya fu Masaa Gadu Kondee*f7* go taki anga en a ini wan gaan sabana a Sinai Mongo. A si wan maka katuku e leti faya, ma na a Basiya fu Masaa Gadu Kondee be kon soi enseefi enke faya de. ");
INSERT INTO djkNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","A sani ya foondoo Mosesi, ne ai go koosube, fu luku san tan so. Namo a yee Masaa Gadu taki komoto a ini a faya anga en. ");
INSERT INTO djkNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","A taki: ‘Na mi Masaa Gadu de ya. Mi na a Gadu fi yu avo Abalaham, Isaki anga Jakopu.’ Namo Mosesi dyombo te, en hii sikin e dansi. A á be abi ati fu luku go de moo seefi.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Namo Masaa Gadu taki ete taki: ‘Puu i susu a i futu. A peesi pe i taampu de, na wan apaiti peesi gi mi. Da yu á poi taampu anga susu de. ");
INSERT INTO djkNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi saka kon ya, fu di mi e si fa Dyusama fi yu e teke pina enke saafu. Soseefi, mi e yee den dyeme fu den. Mi saka kon, fu puu den na ala dati. Da waka kon ya! Bika na yu mi o sende go teke den puu a Egepte Kondee.’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stefanisi soi ete taki: “Na a Mosesi ya Dyusama á be teli! Den taigi en taki: ‘On sama poti yu fu basi wi? Sama poti yu enke lanti fu kuutu gi wi?’ Ma, ne na dati Masaa Gadu poti edeman, fu puu den a katibo. A taanga fu a Basiya fu Masaa Gadu Kondee na a katuku, e tyai en. ");
INSERT INTO djkNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ne a du somen foondoo sani dwengi Egepte puu den a saafu anga taanga. Soseefi di den waka doo a ze den e kai Lebi Ze. Di den de a ini a gaan sabana fotenti yali langa tu. ");
INSERT INTO djkNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“A Mosesi ya be taigi Dyusama taki: ‘Masaa Gadu o poti wan apaiti takiman fi en bakaten, fu tyai en foluku. A o puu wi a saafu enke fa mi Mosesi ya be wooko. Leti a wi mindii ya a o meke libisama fasi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Stefanisi soi ete taki: “Mosesi anga den taa avo gaansama be e waka a ini a gaan sabana. Tapu fu Sinai Mongo, da Masaa Gadu Kondee Basiya be gi en somen bosikopu fu taigi den, fa Masaa Gadu e gi libi. Ala dati fika gi wi tide ya ete, fu wooko. ");
INSERT INTO djkNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ma den avo fu wi á be wani poti yesi aliki Mosesi seefi. Den wai en anga ala den bosikopu poti a wanse. Bika den ati de a taa sani enke fu pakisei Egepte Kondee pe den komoto a saafu.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Stefanisi soi ete taki: “Bika wan leisi Mosesi gwe a Sinai Mongo ede, ne den taigi en gaan baala Aalon taki: ‘Mosesi di puu wi a Egepte Kondee tan tumisi langa. Kande sani du en anda, fu a á poi daai kon baka. Meke u meke wan gadu, fu waka a u fesi tyai wi.’ ");
INSERT INTO djkNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Den teke sani meke wan pikin gowtu kaw. Den piisii dansi gi en anga ala kii meti boon gi en gaandi anga lesipeki enke fa fu du gi Masaa Gadu namo.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Stefanisi soi ete taki: “Namo Masaa Gadu daai baka fika den, fu dini mun, san anga sitali a tapu. A waka enke san be sikiifi na a buku den e kai Apaiti Takiman fu Masaa Gadu taki: ‘Islayeli foluku waka fotenti yali a ini sabana. U e kii meti teke buulu begi mi paadon. ");
INSERT INTO djkNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ma u e dini taa sani! A gadu osu fu Molok di u e tyai a u baka. Lomfa, a sitali di u teke sani meke wan fi en anga ana. Somen sowtu sani u poti e begi. Mi o sitaafu u! Doose kondee sama o kisi u tyai gwe a faawe kondee pasa Babilon Foto seefi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stefanisi soi ete taki: “Ma wi avo a ini a sabana be e tyai a tenti osu fu Masaa Gadu di e kotoigi taki, a de a den mindii. A be meke leti enke di a be soi Mosesi a tapu, fu luku meke dati. ");
INSERT INTO djkNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ma na pikin fu den wooko doo anga en, fu Josuwa tii puu a kondee a taa foluku ana. Masaa Gadu yaki den gi den anga en makiti. Ne Dyusama kon tan wooko ya anga a apaiti tenti, yali fu yali, go doo bakaten di Dafeti toon kownu seefi.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Stefanisi soi ete taki: “Kownu Dafeti na wan man di Masaa Gadu lobi. A teke gaan bun ati fasi luku en somen fasi. Namo, Dafeti akisi a Gadu fu wi avo gaansama Jakopu ya, fu meke wan osu poti a Gadu ya. ");
INSERT INTO djkNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ma a tapu en, fu du dati. Na a ten fu Dafeti manpikin Salomo fosi, ne a gi Salomo dati pasi fu meke a osu de.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","We, di Stefanisi e taki, ne a akisi a Dyulanti fu kuutu de taki: “Ma a gaan Masaa Gadu a tapu sa poi tan a ini wan osu di libisama meke anga ana? Bika enseefi be piki en fositen apaiti takiman fu sikiifi taki: ");
INSERT INTO djkNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Mi enke Masaa Gadu de a mi kondee a tapu, fu tii ala sani. Hii goontapu de a mi ondoo futu. Da sowtu osu libisama o poi meke fu poti mi? ");
INSERT INTO djkNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bika na mi abi ala makiti fu meke san de fu si anga ain ya.’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stefanisi soi ete taki: “Ma u sama ya abi tuutuu taanga yesi. U ati noiti poi teke taki di Masaa Gadu e meke en Apaiti Jeje e piki u, fu du. U gei doose kondee sama, taa foluku di á sabi Masaa Gadu. Na letiso u avo seefi be tan. ");
INSERT INTO djkNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Fositen apaiti takiman fu Masaa Gadu á de di den á be pina. Den be e kii sama e soi den fa Masaa Gadu paamisi fu sende en wookoman kon di o wooko enke fa a wani. A leti wookoman ya kon na a ten fu u ya, ne u dati poti en gi lanti kii. ");
INSERT INTO djkNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Na fu soso Masaa Gadu meke Basiya fi en tyai en weiti kon gi u. Bika u nái wooko anga den.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","We, a Dyulanti di e kuutu sani de aliki san a taki fu den de, ne den ati boon te. Ala den mofu e dansi seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","A Apaiti Jeje teke Stefanisi hii libi. Ne a taampu e luku tapu, da ai si sani a tapu anda, fa Masaa Gadu dyendee fu gi gaandi. Masaa Jesesi taampu anda a Masaa Gadu letise. ");
INSERT INTO djkNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Namo a taigi a Dyulanti di e kuutu de taki: “Nownow, mi e si a Manpikin di saka kon toon libisama ya. A taampu anda na a moo hei peesi a Masaa Gadu letise ana.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Namo a Dyulanti di e kuutu de bali taki: “Kaba anga den takuu taki de!” Ne den tapu ana a yesi. Soseefi den dyombo kon gaapu en oli. ");
INSERT INTO djkNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ne a lanti de gi Dyusama ape, fu seepi tyai gwe a doose fu Jelusalem Foto go towe a doti. Ne den puu yasi a sikin gi wan yonkuman den e kai Sawlesi, fu oli gi den. Namo den teke siton fiingi naki en te, fu kii. ");
INSERT INTO djkNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","A yuu de, ai bali kai Masaa Jesesi nen taki: “Masaa! Mi fika mi jeje gi yu fu teke.” ");
INSERT INTO djkNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ne a kai anga kini, da ai bali begi Masaa Gadu taki: “Mi e begi, fu den sa fende paadon a yu, fu a ogii di den e du ya.” Na so a komoto a goontapu. ");
INSERT INTO djkNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A kii fu Stefanisi na wan sani di kai gi Sawlesi. Bigin fu a dei de libi kon moo taanga gi biibisama de. Dyusama e lon du ogii anga den. Da den e lowe panya gwe na a pisiwataa fu Judeja, soseefi Samaliya. Na den apaiti bosikopuman namo be fika de. ");
INSERT INTO djkNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Da na wan duupu manengee di e oli pakisei anga Masaa Gadu be teke Stefanisi dede sikin go beli. Den kee anga ala tyali fi en ede te. ");
INSERT INTO djkNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","A ten ya Sawlesi nái meke sipowtu anga biibisama. Ai meke moiti fu kaba den anga ala a biibi libi. Ai waka osu fu osu e kisi biibi uman anga man seepi go gi lanti, fu sooto. ");
INSERT INTO djkNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ma den biibisama di be lowe fika Jelusalem be e waka lontu den peesi pe den lowe go. Da den e paati a Bun Nyunsu fu Masaa Jesesi na ala pe den doo. ");
INSERT INTO djkNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Wan biibiwan den e kai Filipi seefi be doo wan foto na a pisiwataa fu Samaliya. Ne ai taigi den sama anda taki, Jesesi na a Kelestesi. ");
INSERT INTO djkNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Namo den sama ape aliki en. Den e si tu fa ai du foondoo sani enke maiki taki, na Masaa Gadu taampu gi en. Ne den ala booko kon teke san ai taki. ");
INSERT INTO djkNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Bika den e si takuu jeje e bali komoto a somen sama tapu. Lanman anga malengii sama e kon bun. ");
INSERT INTO djkNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ala san e pasa de tyai gaan piisii a ini a foto ya. Ala sama ape e poolo. ");
INSERT INTO djkNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma fosi a ten de, da wan tofuuman den e kai Simon be e tan a ini a foto fu Samalitan sama ya. A be e kai enseefi bigiman. Ala sama fu a foto be e foondoo, fu den tofuu di ai du. ");
INSERT INTO djkNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pikin anga bigi, hei anga lagi fu a foto be e teke ala san ai taki. Bika den be e denki na Masaa Gadu gi en a hii kaakiti fi en, fu wooko gi en. ");
INSERT INTO djkNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Na so meke tofuu di ai du be e meke den sama e foondoo onmen langa kaba na a peesi de. ");
INSERT INTO djkNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ma di Filipi kon doo de, ne a taigi den sama a Bun Nyunsu, fa Masaa Gadu poti fu tii sama. Soseefi ai soi den fa Masaa Jesesi na a Kelestesi. Namo uman anga man teke biibi na a peesi de, te go dopu. ");
INSERT INTO djkNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon seefi go dopu. A teke biibi a san a yee Filipi e taki. Namo a bigin waka wanten anga Filipi na ala pe ai go. Da ai foondoo naamo, fu san Filipi e du enke maiki taki, na Masaa Gadu taampu gi en. ");
INSERT INTO djkNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Namo nyunsu fu dise go doo Jelusalem Foto a den apaiti bosikopuman. Den yee fa Samaliya pisiwataa teke Masaa Gadu bosikopu, fu Masaa Jesesi. Ne den puu tu fu den, Johanisi anga Peitilisi go luku den sama anda. ");
INSERT INTO djkNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ne den komoto go doo, te begi gi den sama di teke biibi de, fu a Apaiti Jeje sa lai den sama libi. ");
INSERT INTO djkNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bika den be teke biibi de, te be dopu enke maiki taki, den e biibi Masaa Jesesi. Ma a Apaiti Jeje dati á be lai den libi ete. ");
INSERT INTO djkNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Namo Peitilisi anga Johanisi poti ana, a ibiiwan fu den tapu, begi gi den. Ne Masaa Gadu meke en Apaiti Jeje lai den libi tu. ");
INSERT INTO djkNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Namo Simon luku san pasa de. A si taki, te den apaiti bosikopuman poti ana begi gi wan sama, da a Apaiti Jeje e lai a hii libi de. Namo a teke moni fu go pai den apaiti bosikopuman, fi en seefi sa poi du dati tu. ");
INSERT INTO djkNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","A taki: “Gaantangi! Seli a kaakiti ya gi mi, fu poi poti ana begi, da a Apaiti Jeje teke a sama de libi tu.” ");
INSERT INTO djkNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ma Peitilisi piki en taki: “Luku bun! Masaa Gadu o kaba yu a soso anga ala i moni. Bika yu á mu denki taki, a gaanbigi bun di Masaa Gadu e gi, da yu o poi bai en anga moni. Kweti! ");
INSERT INTO djkNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yu ati á taampu leti a Masaa Gadu fesi, da i ná abi pasi fu du a wooko ya! ");
INSERT INTO djkNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Daai libi komoto na a takuu ati fasi de! Da begi Masaa Gadu paadon, fu a takuu fasi di toosi yu fu denki so. ");
INSERT INTO djkNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Bika bita fasi anga giili koko a yu ati, da ai subi yu fu du sani. Da takuudu e wooko enke basi a i tapu.” ");
INSERT INTO djkNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Namo Simon piki taki: “Mi e begi! U yeepi mi begi paadon! Akisi Masaa Gadu, fu san u taki o pasa anga mi de á sa go doo.” ");
INSERT INTO djkNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Johanisi anga Peitilisi be kaba de. Den soi san den be si fu Masaa Jesesi anga ala fini fini sama a dati. Ne den e gwe a Jelusalem baka, da den e miti somen Samaliya sama kondee a pasi. Da den e gi den a Bun Nyunsu tu. ");
INSERT INTO djkNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Namo Masaa Gadu sende wan Basiya fi en*f8* go taigi Filipi taki: “Seeka fu go mindii dei ten, na a pasi di abaa a sabana, komoto a Jelusalem Foto go kai a Gaasa.” ");
INSERT INTO djkNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","We, a go si wan Etiyopiya Kondee man de. En na a moo heiman fu luku moni toli anda. Na wan apaiti wookoman gi a uman kownu den e kai Kandaki. Da a be go begi a Jelusalem Foto, te ai daai baka ya so. ");
INSERT INTO djkNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","A sidon a ini en wagi di asi e hali enke buliki wagi. Da ai leisi a pisi buku di Jesaja enke fositen apaiti takiman fu Masaa Gadu be sikiifi. ");
INSERT INTO djkNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Namo, a Apaiti Jeje di de a Filipi libi piki en taki: “Filipi! Go moo koosube fu a wagi fu a man de!” ");
INSERT INTO djkNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ne Filipi lon esi esi go koosube fu a wagi. Da ai yee a Etiyopiya man e leisi san Masaa Gadu apaiti takiman Jesaja be sikiifi. Namo Filipi akisi en taki: “Fa yu e leisi de, a sani kiin gi yu fu sabi?” ");
INSERT INTO djkNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Namo a man piki en taki: “Fa a sa kiin gi mi, fu sabi san mi e leisi? Sama á de fu soi mi san na a sani seefi!” Namo a kai Filipi, fu dyombo go sidon ne en se a ini a wagi. ");
INSERT INTO djkNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A pisi fu a Masaa Gadu Buku di ai leisi taki: “Den e tyai en go kii! Ma ai tan pii teke ala dati enke pikin sikapu, di den kisi fu tyai go kaabu uwii puu ne en sikin. ");
INSERT INTO djkNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Den du ogii anga ala pina en. En toli seefi, den á kuutu leti, ne den puu en futu a goontapu. Da fa a sa du poi meke paansu sama fu waka ne en baka ya?” ");
INSERT INTO djkNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Namo, a man akisi Filipi taki: “Anga sama den du san a fositen apaiti takiman sikiifi ya? Na a apaiti takiman di sikiifi en seefi ofu na wan taa sama?” ");
INSERT INTO djkNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Namo Filipi teke a Bun Nyunsu soi en fa san be sikiifi Masaa Gadu Buku ape e fiti anga san pasa anga Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Da fa den de a waka tapu so, ne den e pasa wan peesi de anga wataa. Namo a man daai luku a wataa, ne a akisi taki: “I si enke mi doo peesi fu dopu kaba? Bika luku wataa so!” ");
INSERT INTO djkNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Namo Filipi piki en taki: “Yu e biibi Masaa Jesesi tuutuu a ini yu ati? Da a bun! Taa fasi á de, na fu dopu namo.” Namo a man piki taki: “Mi e biibi tuutuu taki, Jesesi na a Kelestesi, dati na a Manpikin fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","We, ne a tapu wagi wanten. Ne den saka komoto go a ini a wataa, en anga Filipi makandii. Ne Filipi dopu en. ");
INSERT INTO djkNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Di den kaba, go a soo baka, a Etiyopiya man á si Filipi moo. A Apaiti Jeje puu en de foondoo fasi tyai go poti a wan hii taa peesi. A Etiyopiya man á fuka fu dati seefi. A dyombo a ini en wagi anga ala piisii. ");
INSERT INTO djkNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na wan faawe peesi Filipi kisi en seefi. A Apaiti Jeje tyai en go poti na a foto den e kai Asotesi. Da ai waka anga a Bun Nyunsu a den foto fu a pisi anda. Namo a go doo a foto den e kai Sesaleya seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sawlesi dati ati nái kaba boon a den di e waka na a pasi fu Masaa. Ai waka e pina den e kisi gi lanti, fu kii. Wan dei, a go na a moo hei Dyu fu a Mama Keliki. ");
INSERT INTO djkNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ne a akisi paamisi fu gwe a Damasikosi Foto, go kisi uman anga man di e waka na a Nyun Pasi anda, fu tyai kon sitaafu a Jelusalem. Den langa pampila makiti en, meke fesiman fu Dyu keliki anda sa si taki, a abi pasi fu du so. ");
INSERT INTO djkNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Namo a teke pasi e gwe Damasikosi Foto. A be doo koosube kaba. Te fu a denki, wan kiin faya koti komoto a tapu, kon kai lontu en hii sikin. ");
INSERT INTO djkNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wanten a kai a doti, da ai yee wan Tongo e taki: “Sawlesi! Sawlesi! Saide yu mu e lon du ogii ala suku fu pina mi so?” ");
INSERT INTO djkNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Namo a piki taki: “Masaa! Sama a yu?” Namo a piki en taki: “Mi na Jesesi di baka yu e lon fu pina so!” ");
INSERT INTO djkNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","A Tongo soi ete taki: “Ma opo go doo Damasikosi Foto. Sama de anda fu taigi yu san fu du.” ");
INSERT INTO djkNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A hii ten de, da den man di anga en be de a waka tapu dyombo te, den de diin. Bika den e yee a Tongo e taki, ma den nái si a sama di e taki. ");
INSERT INTO djkNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Namo Sawlesi opo taampu, ma a nái si sani moo. Ne den taawan oli en na ana tyai go doo Damasikosi Foto. ");
INSERT INTO djkNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Dii dei langa a tan sondee si, sondee nyan anga ala sondee diingi wataa. ");
INSERT INTO djkNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Da wan biibiwan den e kai Ananiyasi be e tan a Damasikosi Foto. Masaa go meke ai si jeje sani enke ai deen so, da ai yee en tongo e taki: “Ananiyasi!” A piki taki: “Iya, Masaa.” ");
INSERT INTO djkNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Masaa taki: “Go na a letiopu sitaati di kaasi abaa a foto ya. Na a osu fu a man den e kai Judasi i mu go akisi fu a man den e kai Sawlesi, fu Taasisi Foto. Nownow ya, a de ape e begi.” ");
INSERT INTO djkNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Soseefi Masaa taki go doo taki: “Mi e soi enseefi jeje sani nownow ya enke ai deen. Da ai si yu Ananiyasi e waka kon na a osu pe a de, ne yu poti ana begi gi en meke ai si sani baka.” ");
INSERT INTO djkNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Namo Ananiyasi piki en taki: “Masaa! Fa i sa sende mi go na a man de? Mi yee taki, ai du ogii anga sama fi yu a Jelusalem Foto! ");
INSERT INTO djkNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A kon fi en ya na fu kisi ibii sama di teke biibi fu kai yu nen. Bika a Jelusalem Foto anda pampila naki gi en makiti fu kon du dati ya.” ");
INSERT INTO djkNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Namo Masaa piki taki: “Na mi e sende yu go ne en! Bika mi teke enseefi toon sama fu mi. Da a toon wooko sani fu mi, fu du mi wooko. Bika a o waka tyai mi nen paati, fu soi Dyusama, soseefi taa foluku tu. Soseefi go doo kownu kownu fu goontapu. ");
INSERT INTO djkNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Bika mi o soi en san wani taki tyotyo fu mi nen di a o paati doo moo anga moo sama, fu yee fu mi.” ");
INSERT INTO djkNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","We, ne Ananiyasi komoto wanten go na a osu pe Sawlesi de. Ne a poti ana a Sawlesi ede taki: “Baala Sawlesi! Na Masaa Jesesi soi enseefi a yu na a pasi di waka doo ya. Ne a sende mi, fu kon meke yu si baka. Soseefi fu kon meke a Apaiti Jeje lai yu hii libi.” ");
INSERT INTO djkNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Fa i si Ananiyasi taki so, Sawlesi si baka wanten. A fii enke na fisi buba be tapu en ain komoto kai. Bakadati, ne a opo go meke den dopu en. ");
INSERT INTO djkNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ne a nyan te en bee simpan, en hii sikin kon taanga baka. Ne Sawlesi tan wantu dei ete anga den biibiwan fu Damasikosi Foto ape. ");
INSERT INTO djkNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Da ai go waka makandii anga den biibiwan a den Dyu keliki fu anda. Da ai bali a bosikopu taki: “Fu tuu! Jesesi na a Manpikin fu Masaa Gadu.” ");
INSERT INTO djkNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Namo den sama di yee dati foondoo taki: “A man di be de a Jelusalem Foto e feti anga biibi. A be kon ya, fu kisi ibii biibiwan di e kai Masaa Jesesi nen, tyai go gi fu Dyu keliki anda, fu sitaafu. Ma fa a du daai e taki taa fasi so?” ");
INSERT INTO djkNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","We, na bigin fu taki taa fasi Sawlesi be de. Bika na moo anga moo ai tyai sani kon a fesi, fu soi fa Jesesi na a Kelestesi di sende kon, fu tii ala sani. Dyusama á be de fu taampu ne en fesi sitee anga san ai taki. ");
INSERT INTO djkNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ma baka wan pisiten, ne den Dyusama fiti mofu fu kisi en kii. ");
INSERT INTO djkNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ma a kisi wan pingi fu dati. Ná sipowtu lulu fu kisi en kii den sete dei anga neti na ala den pasi mofu fu waka kon a ini a foto. ");
INSERT INTO djkNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Namo den taa biibiwan kibii en puu a ini a foto. Den tei tetei a wan gaan bakisi, saka en puu a wan fensee fu a hei siton di sikotu lontu a hii foto ya. ");
INSERT INTO djkNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Namo a gwe te go doo Jelusalem Foto. Ne a go suku fu libi anga ala wooko makandii anga den biibiwan de. Ma den e wai a pasi gi en. Den e pantan fu biibi taki, a toon biibiwan. ");
INSERT INTO djkNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ma Balnabasi luku a toli bun, ne a teke en tyai go miti den apaiti bosikopuman. Ne a soi ala fa Sawlesi si Masaa Jesesi, taki mofu mofu anga en a Damasikosi Pasi. Fa Sawlesi á be feele fu taampu a lanti fesi anda, taki sani a ini a nen fu Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Namo den teke Sawlesi wanten fu wooko a den mindii. Den sanga waka wooko lontu hii Jelusalem Foto makandii. ");
INSERT INTO djkNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sondee feele ai taampu e taki sani a ini a nen fu Masaa. Da Dyusama di e taki Giiki Tongo ape teke fu sitee anga en. Da ai soi den fa a sani de seefi. Namo den fiti mofu fu kii en puu. ");
INSERT INTO djkNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ma biibiwan ape kisi wan pingi fu dati. Ne den meke moiti puu en de tyai gwe a wan taa pisiwataa den e kai Sesaleya. Den poti en anda a boto baka seefi tyai gwe moo faawe abaa ze gwe a Taasisi Foto a wan taa kondee. ");
INSERT INTO djkNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","A ten de, da sani á be taanga so moo gi biibiwan fu Judeja, Galileya anga Samaliya pisiwataa. Den biibi e moo taanga. Den e lesipeki Masaa Gadu. A Apaiti Jeje e wooko, fu meke den kulu e goo moo anga moo tu. ");
INSERT INTO djkNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","A ten ya, Peitilisi e waka lontu somen taa peesi anga a bosikopu fu Masaa Gadu. A go doo biibiwan na a foto den e kai Lida. ");
INSERT INTO djkNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ne a go si wan lanman den e kai Eneya ape. Aitin yali langa a didon sondee waka. ");
INSERT INTO djkNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Namo Peitilisi taigi en taki: “Eneya! Masaa Jesesi Kelestesi betee yu tide. Opo taampu! I seefi lolo i sibi peesi.” Ne Eneya opo waka letiso! ");
INSERT INTO djkNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Namo sama komoto a Lida Foto doo a pisiwataa fu Salon si a hii toli ya. Ne den daai dini Masaa de wanten. ");
INSERT INTO djkNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Da boiti Lida Foto, da Jopa Foto be de anda tu. Wan biibi uman be de ape den e kai Tabita. Dati na Dolkasi a ini Giiki Tongo. A be e du somen bun gi taawan doo mofinawan tu. ");
INSERT INTO djkNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","We, ne a uman ya siki a Jopa Foto di Peitilisi de a Lida Foto. Namo a dede te wasi seeka poti a wan kambaa a wan tapu sodoo. ");
INSERT INTO djkNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida Foto á be faawe fu Jopa Foto. Ne biibiwan a Jopa Foto yee taki, Peitilisi de ape. Ne den sende tu manengee go piki en taki, Tabita dede a Jopa Foto. Meke a kon a den sondee daai daai. ");
INSERT INTO djkNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Namo Peitilisi seeka gwe anga den. Fa a doo, den tyai en go a tapu sodoo na a dede. Wan duupu uman di man dede fika a ganda, be de ape. Tabita be lobi yeepi den a sani. Den kon a Peitilisi anga ala kee e soi en koosi di Tabita be lobi meke gi den. ");
INSERT INTO djkNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Namo Peitilisi sende den gwe a doo. Ne a saka kini begi a ini a kambaa. Bakadati, ne a daai taigi a dede taki: “Tabita! Opo!” Namo Tabita opo ain luku Peitilisi anga ala opo sidon. ");
INSERT INTO djkNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ne Peitilisi langa ana gi en, hali en opo taampu. Ne a kai den uman di be go a doose kon, soseefi taa biibiwan fu Masaa Gadu de. Den kon luku a libilibi Tabita di be dede. ");
INSERT INTO djkNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","A hii Jopa Foto yee a toli, ne somen sama daai teke fu biibi Masaa Jesesi de. ");
INSERT INTO djkNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Peitilisi á komoto a Jopa Foto wanten baka. A tan wantu dei moo anga den biibiwan ape na a osu fu Simon. Dati e dee meti buba, fu teke meke sani enke kaw buba. ");
INSERT INTO djkNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Da wan suudati be de na a pisiwataa fu Sesaleya, den e kai Koneilisi. Na wan Italiya ofisii di abi wan ondoo suudati ne en ondoo. ");
INSERT INTO djkNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ma a be lobi Masaa Gadu anga ala lesipeki. Ala sama a ini en osu seefi tu. A be e tyai yeepi gi mofinawan a ini a Dyu foluku naamo seefi. Soseefi a be e begi dei fu dei tu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wan dei, a de ne en osu dii yuu bakadina so. Ne ai si jeje sani enke ai deen so. Wan Basiya fu Masaa Gadu Kondee*f9* waka libilibi kon a ini en osu, te doo ne en fesi taigi en taki: “Koneilisi!” ");
INSERT INTO djkNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Namo a pii ain e luku a Masaa Gadu Kondee Basiya, anga ala feele anga dansi sikin. Namo a taki: “Mi Masaa! San i wani anga mi?” Namo a Basiya taki: “Na den begi di i e begi anga ala den bun di i e gi mofinawan. Ne ala dati piisii Masaa Gadu, fu denki yu! ");
INSERT INTO djkNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Da a wani yu sende wantu wookoman fi yu go a Jopa Foto go kai Simon di den e kai Peitilisi tu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ai tan na a osu fu wan man den e kai Simon anda tu. Dati e dee meti buba, fu teke meke sani enke kaw buba. En osu de koosube sikin liba fu a ze.” ");
INSERT INTO djkNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Fa i si a Masaa Gadu Kondee Basiya gwe, Koneilisi kai tu wookoman kon, makandii anga wan suudati di a sabi taki, lobi Masaa Gadu. Na wan di ai fitoow, fu poti oli wakiti gi enseefi. ");
INSERT INTO djkNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Namo a taigi den dii man ya, ala san a Masaa Gadu Kondee Basiya kon sende en. Bakadati, ne a sende den gwe a Jopa Foto a Peitilisi. ");
INSERT INTO djkNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Wan dei baka dati, ne den de a pasi. Den be doo koosube fu Jopa Foto kaba. A ten de Peitilisi de a Jopa Foto e subi go a tapu sodoo fu a osu anda, fu go begi na a mindii dei twalufu yuu de. ");
INSERT INTO djkNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma angii be e kii en, ne a piki den sama a ini a osu dati. Namo den e seeka sani gi en fu nyan. Ne a go sidon a tapu anda e wakiti den. Te fu a denki, ne ai si jeje sani enke ai deen. ");
INSERT INTO djkNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tapu anda wai opo, ne wan sani komoto a ini anda e kon a doti. Wan sani enke wan gaan duku tei oli a den fo kanti fi en. ");
INSERT INTO djkNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A kon doo te a Peitilisi fesi, ne ai si sowtu a sowtu fo futu meti, sowtu a sowtu meti di e hali anga bee a doti, sowtu a sowtu foo di e fee a tapu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Namo a yee wan Tongo e taigi en taki: “Peitilisi! Opo taampu! I sa nyan ala sani yu e si de. Kii nyan san i wani!” ");
INSERT INTO djkNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma Peitilisi piki baka taki: “Kweti, Masaa! Enke Dyusama, noiti mi nyan wanten san Dyuweiti taki, á de fiti. Noiti mi nyan san á de kiin fasi gi Dyusama!” ");
INSERT INTO djkNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Namo a Tongo piki di fu tu leisi taki: “Mi enke Masaa Gadu ya sende yu taki, nownow den fiti fi yu enke Dyusama nyan. Da yu á mu piki taki, den á de kiin fasi gi yu enke Dyusama.” ");
INSERT INTO djkNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","We, na te dii leisi seefi a taigi Peitilisi a seefi sani ya. Namo wantoon so, Peitilisi si a duku anga den meti e gwe a tapu baka, te doo pe a be komoto a tapu anda. ");
INSERT INTO djkNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Namo Peitilisi sidon e wegi san a si de. A leti ape a de, ne den man di Koneilisi be sende kon doo de. Den be akisi a ini a foto, ne sama soi den a osu fu Simon. Ne den kon doo na a doo mofu fi en. ");
INSERT INTO djkNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Namo den bali akisi efu Simon di den e kai Peitilisi de ape. ");
INSERT INTO djkNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","A ten de Peitilisi de na a tapu osu ete e wegi san a be si. Namo a Apaiti Jeje piki en taki: “Peitilisi! Dii man kon suku yu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Saka go a den, bika den kon kai yu fu go anga den a pe den komoto. Na foluku di á de Dyusama, ma go anga den sondee fu meke sani. Bika na mi sende den kon kai yu.” ");
INSERT INTO djkNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Namo Peitilisi saka wanten go taigi den man taki: “U luku mi di u e suku ya! San u wani?” ");
INSERT INTO djkNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ne den taigi en taki: “U komoto a wan man den e kai Koneilisi, wan ofisii fu suudati. A de wan letiopu man, di e lesipeki a Gadu fu Dyusama. Ala Dyusama sabi anda fa ai libi bun anga Dyusama. Masaa Gadu sende wan apaiti Masaa Gadu Kondee Basiya go taigi en, fu sende kai yu, fu aliki ala san yu o taigi en.” ");
INSERT INTO djkNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Namo Peitilisi aliki, ne a taki: “A bun!” Ne a kai den man kon a ini osu, gi den siibi peesi. Taa dei, ne a opo gwe anga den. Wantu biibi man fu Jopa Foto go anga den tu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A taa dei fu dati, ne en anga den go doo Sesaleya Foto. Koneilisi be seeka fu a kon fi en. A kai ala en famii poti sidon makandii anga ala en bun mati fi en. ");
INSERT INTO djkNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Fa i si Peitilisi de fu doo go a ini a osu, Koneilisi lon kon miti en a doose. A saka anga kini ne en fesi e gi en gaandi. ");
INSERT INTO djkNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ma Peitilisi hali en opo taampu taki: “Opo taampu! Mi á de wan sani moo yu. Bika mi anga yu na libisama anga libisama!” ");
INSERT INTO djkNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na so den e taki, den doo go a ini osu. Namo, na onmen sama Peitilisi go si e wakiti de. ");
INSERT INTO djkNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ne a gi odi anga ala taki: “U sabi fa Dyuweiti e tapu Dyusama fu mosoo anga taa foluku. Mi dati kon ya, fu di Masaa Gadu seefi soi mi taki, mi á mu si moo enke u á de kiin fasi. Mi á mu si moo enke u á de fiti. ");
INSERT INTO djkNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na dati meke di den kon kai mi, mi á meke sani. Da mi kon ya kaba, fu sabi saide u sende kai mi.” ");
INSERT INTO djkNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Namo Koneilisi piki taki: “Tide na di fu fo dei, da a be de dii yuu bakadina enke nownow. Mi be de a osu e begi. Te fu mi denki, ne wan man wei weti koosi taampu a mi fesi. ");
INSERT INTO djkNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","A taigi mi taki: ‘Koneilisi! Na den begi di i e begi Masaa Gadu, soseefi den bun di yu e gi mofinawan. Ne a sende mi kon taigi yu taki, ala dati piisii en fu denki yu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","A wani yu sende sama go a Jopa Foto go kai Simon di den e kai Peitilisi tu. Ai tan na a osu fu wan man den e kai Simon anda tu. Dati e dee meti buba, fu teke meke sani enke kaw buba. En osu de a sikin liba fu a ze.’ ");
INSERT INTO djkNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","We, ne mi sende sama wanten kon kai yu. Da a bun fa i kon. U de ya a Masaa Gadu fesi ya, fu aliki ala san a gi yu, fu taigi wi.” ");
INSERT INTO djkNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","We, ne Peitilisi piki taki: “Mi kon e si tuu taki, sama á de wan sani moo taawan gi Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ibii foluku sama, ma yu e dini en anga ala wooko leti fasi gi en, da dati e switi en ati kaba. ");
INSERT INTO djkNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Masaa Gadu seefi mofu paamisi wi Dyusama dati a Dyu Kondee. Ne u sabi taki, ibii libisama ati poi kon de switi anga Masaa Gadu. Jesesi Kelestesi du a wooko fu tyai a yeepi de. A man de poti fu wooko enke Masaa gi ibiiwan. ");
INSERT INTO djkNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","U ala ya be yee a toli fi en di be pasa a Dyu Kondee. A be bigin wooko na a pisiwataa fu Galileya, baka fu a ten di Johanisi be e dopu sama. ");
INSERT INTO djkNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dati na Jesesi di goo a Nasaleti Foto. Masaa Gadu meke en Apaiti Jeje teke en hii libi, fu gi en kaakiti fu wooko lontu Dyu Kondee e du bun. A tyai yeepi puu sama a ini dwengi fu didibii. Da ai deesi den tu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Mi anga taawan di be e waka anga en na kotoigi di si san a waka du na a hii Dyu Kondee. A wooko fu Jelusalem Foto doo ala taa pisi de. Ne den kisi en kii a koloisi. ");
INSERT INTO djkNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ma baka dii dei, ne Masaa Gadu weki en kon a libi ya baka. Ne a meke a soi enseefi libilibi a son sama namo. ");
INSERT INTO djkNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A ná a hii Dyu foluku a soi enseefi! Na den wan namo di Masaa Gadu seefi be fiti a fesi fu de enke kotoigi di si dati, fu taki baka. Na wi dati nyan diingi anga en, di a dede weki kon a libi ya baka. ");
INSERT INTO djkNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ne a sende wi fu paati en Bun Nyunsu gi a hii Dyu foluku. U mu leli den taki, ne en Masaa Gadu poti fu kuutu ibii sama. Den di de a libi ya ete anga den di dede kaba. ");
INSERT INTO djkNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Masaa Gadu be piki fositen apaiti takiman fi en fu sikiifi taki ala dati taki, fu a wooko di dati du, da sama biibi en o fende paadon fu den takuudu anga ogii.” ");
INSERT INTO djkNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na so Peitilisi e taki. Namo, ne a Apaiti Jeje kon lai a hii libi fu den sama di e aliki de. ");
INSERT INTO djkNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Den biibi Dyuwan di be kon anga Peitilisi ape foondoo. Bika den si taki, na a seefi gaanbigi bun, fa Masaa Gadu be gi den a Apaiti Jeje, na dati ai gi taa foluku de tu. ");
INSERT INTO djkNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bika den yee den dati e gi Masaa Gadu gaandi a ini sowtu a sowtu taa kondee tongo di á de denseefi tongo. Namo Peitilisi taki, ");
INSERT INTO djkNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Efu Masaa Gadu e wooko a taa foluku ya so, da sama á poi peefuu taki, wi á mu dopu den! Bika ne en gi den a seefi Apaiti Jeje di a be gi u enke Dyusama tu.” ");
INSERT INTO djkNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Namo a meke den teke dopu a ini a nen fu Masaa Jesesi. Ne den kaba du a wooko di den kon du de. Ma den sama akisi den fu tan wantu dei moo anga den. ");
INSERT INTO djkNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","We, biibi Dyusama anga den apaiti bosikopuman na a pisiwataa fu Judeja kisi fu yee fa taa foluku di á de Dyusama teke biibi a Masaa Gadu bosikopu de. ");
INSERT INTO djkNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Di Peitilisi doo Jelusalem Foto, ne a sani ya tyai sitee fi en anga biibi Dyusama di e oli taki, taa foluku mu oli Dyuweiti fosi den sa teke biibi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ne den taki: “I go nyan makandii anga foluku di á de Dyu? I peefuu poti futu a sama osu di nái oli Dyuweiti!” ");
INSERT INTO djkNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ma Peitilisi teke ala san pasa seefi taigi den. ");
INSERT INTO djkNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","A taki: “Mi be de wan dei e begi a Jopa Foto. Te fu mi denki, ne mi e si jeje sani enke na deen. Wan sani enke wan gaan duku tei oli a den fo kanti fi en saka komoto a tapu e kon a doti, te kon doo a mi fesi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Di mi luku inise, ne mi si sowtu a sowtu fo futu meti, busi meti, meti di e hali anga bee a doti anga foo di e fee a tapu. ");
INSERT INTO djkNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Namo mi yee wan Tongo taki: ‘Peitilisi! Opo taampu! I sa nyan ala san yu e si de! Kii nyan san i wani.’ ");
INSERT INTO djkNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ma mi piki taki: ‘Kweti Masaa! Noiti mi nyan wanten san á de kiin fasi gi Dyusama. Noiti mi nyan wanten san Dyuweiti taki, á de fiti fasi gi Dyusama.’ ");
INSERT INTO djkNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ma a Tongo piki a tapu di meke tu leisi taki: ‘Mi enke Masaa Gadu ya sende yu taki, den fiti fi yu enke Dyusama nyan. Da yu á mu piki taki, den á de kiin fasi gi Dyusama.’ ");
INSERT INTO djkNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“We, na te dii leisi seefi a be taigi mi a seefi sani ya. Namo wantoon so, a duku anga den meti e gwe a tapu baka. ");
INSERT INTO djkNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Na a seefi yuu de, dii man doo na a doo mofu pe mi be e tan anga sama. Den komoto a Sesaleya Foto, pe sama sende den kon kai mi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Namo a Apaiti Jeje piki mi taki, gwe anga den sondee fu meke sani. Ne mi anga den sigisi biibi baala di yu e si anga mi ya go. U go na a osu fu a man, di á de Dyusama. ");
INSERT INTO djkNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ne a taigi mi fa wan Basiya fu Masaa Gadu Kondee*f10* go doo ne en fesi, a ini en osu. Ne a taigi en fu sende sama go a Jopa Foto, go kai Simon di den e kai Peitilisi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Bika dati o gi en Masaa Gadu bosikopu fu yeepi en anga ala sama a ini en osu, wookoman fi en tu. Ala den o komoto na a pasi fu takuudu anga ogii, fu fende libi tego.” ");
INSERT INTO djkNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Peitilisi soi ete taki: “Di mi bigin taki sani fu Masaa Gadu, ne a Apaiti Jeje saka kon teke peesi a den libi, na a seefi fasi enke a fosi dei di dati be saka kon a wi enke Dyu. ");
INSERT INTO djkNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Namo a denki kon a mi, fu san Masaa Jesesi be taigi wi taki, Johanisi be e dopu sama anga wataa. Ma mi o dopu biibiwan anga a Apaiti Jeje. ");
INSERT INTO djkNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","We, Masaa Gadu gi taa foluku a seefi gaanbigi bun de, enke fa a be gi wi Dyusama dati, fu a biibi a Masaa Jesesi Kelestesi ede! Mi á be poi tapu Masaa Gadu fu du dati.” ");
INSERT INTO djkNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","We, di Peitilisi e taki, da den aliki. Namo dati koo den ati, meke den gafa Masaa Gadu di meke taa foluku seefi poi daai libi, fu fende libi tego. ");
INSERT INTO djkNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","A dede fu Stefanisi be meke biibiwan lowe komoto a Jelusalem Foto doo te a Finisiya pisiwataa. Wantu doo Antiyokiya Foto. Taawan abaa gwe a Sipolosi Tabiki a mindii ze. A ini a lowe, da den nái gi taa foluku Masaa Gadu bosikopu boiti Dyusama. ");
INSERT INTO djkNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wantu biibi Sipolosi Kondee sama be de a ini a lowe. Wantu biibisama fu Sileni Kondee tu. Na den dati doo Antiyokiya Foto, ne den gi Giiki foluku a Bun Nyunsu fu Masaa Jesesi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Namo Masaa Gadu wooko taanga, fu yeepi den anga a wooko ya. Ne wan gaan kulu Giiki sama teke a biibi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Namo a toli ya paati go doo a kulu biibiwan a Jelusalem Foto. Ne den dati sende Balnabasi gwe na Antiyokiya Foto a den di toon biibiwan anda. ");
INSERT INTO djkNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Di Balnabasi doo anda, da a si fa Masaa Gadu teke gaan bun ati fasi namo luku den sama anda. Ne a piisii te, da ai waka e sende den taki: “Biibiwan! Poti na ati fu tan teke Masaa Jesesi taki, fu tan waka ne en baka. Da u oli so go doo!” ");
INSERT INTO djkNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bika Balnabasi be de wan bun libisama di sabi yeepi taawan. A Apaiti Jeje be teke en hii libi. A be abi taanga biibi a Masaa Jesesi tu. Namo moo anga moo sama e teke a biibi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Di a komoto de baka, ne a gwe te a Taasisi Foto go suku Sawlesi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Di a fende en, ne a tyai en kon na Antiyokiya Foto. Ne den tan wan hii yali de. A kulu biibiwan de be e wooko makandii anga den. Wan gaan kulu be de ape e leli sani fu Masaa Jesesi moo fini fini. Na a ten ya sama bigin kai biibiwan, Kelesten. ");
INSERT INTO djkNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na a seefi yali ya, wantu biibiwan komoto a Jelusalem kon luku biibiwan na Antiyokiya Foto de. Na be biibiwan di Masaa Jesesi e piki san fu taki. ");
INSERT INTO djkNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Namo a Apaiti Jeje piki wan fu den, den e kai Agabesi fa gaan angiiten de fu kon na a hii Dyu Kondee, go doo taa peesi di Loma kownu e tii. Ne a soi den taawan ape dati. A be pasa so tuu na a ten fu Kownu Kalawdiyosi. ");
INSERT INTO djkNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ibii biibiwan ape be suku onmen sani a poi poti, fu sende go yeepi den biibiwan na a pisiwataa fu Judeja. ");
INSERT INTO djkNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ne den sende den sani de letiso, go a den gaansama fu biibiwan keliki anda, fu paati gi den biibiwan. Balnabasi anga Sawlesi tyai en go gi den. ");
INSERT INTO djkNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A yuu de, da Kownu Helowdesi be opo fu kisi biibiwan pina anga ala sitaafu. ");
INSERT INTO djkNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jakowbesi enke baala fu Johanisi dati a meke den teke satu fetihow doo en ede kii. ");
INSERT INTO djkNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","A sani ya kai gi den Dyusama. Ne a gi en moo kankan fu du ogii anga biibiwan. Namo a sende kisi Peitilisi. Ma na ini a fesa pe Dyusama e nyan beele sondee sowda. ");
INSERT INTO djkNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Namo a meke den sooto en anga ala suudati fu oli wakiti ne en. Hiihii fo kulu suudati e oli wakiti kengi. Da a be poti fu tyai Peitilisi go na a foluku fesi, fu kaagi en kii, te a Pasika Fesa be o kai pasa. ");
INSERT INTO djkNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Namo a poti Peitilisi a dunguu osu de fosi. A ten de, a hii kulu biibiwan e begi yeepi gi en naamo. ");
INSERT INTO djkNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A neti be doo fu mamanten fi en, da a kownu be o tyai en go na a foluku fesi, fu kaagi. Peitilisi be didon e siibi a tu suudati mindii. Den bui en wanse ana miti a wan, a taase ana miti na a taawan. Doo mofu fu a dunguu osu baka, suudati taampu e oli wakiti. ");
INSERT INTO djkNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Namo Masaa Gadu sende wan Masaa Gadu Kondee Basiya*f11* go a Peitilisi de. Ne a hii dunguu kambaa kiin anga faya! Ne a Basiya seke seke Peitilisi ne en bansa weki taki: “Opo!” Wantoon de seefi den keti koti komoto a Peitilisi ana kai a doti. ");
INSERT INTO djkNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ne a taigi Peitilisi taki: “Banti i mindii seeka i koosi a sikin! Teke i dalaila toosi fasi a futu.” Namo Peitilisi du ala dati. Ne a Masaa Gadu Kondee Basiya taki: “Toosi i yasi a sikin, da teke a mi baka.” ");
INSERT INTO djkNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Na so a waka ne en baka, te a doose! A hii sani ya e pasa, ma Peitilisi e si enke na jeje sani ai si en enke deen. ");
INSERT INTO djkNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Namo, den pasa a fosi peesi pe wakiti e oli. Den pasa di fu tu, go doo a insii doo, fu a gaan doo mofu, fu doo sitaati a ini a foto. Dati seefi wai opo waa. Ne a Masaa Gadu Kondee Basiya waka wan hii sitaati langa anga en, ne woo. Peitilisi á si en moo. ");
INSERT INTO djkNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Namo Peitilisi kisi enseefi taki: “Na Masaa Gadu sende wan Basiya fi en kon puu mi a ini Kownu Helowdesi ana. A puu mi na ala san a Dyu foluku be wani a du anga mi tamaa.” ");
INSERT INTO djkNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Namo a taampu wegi luku san fu du. Ne a teke pasi langa te na a osu fu Maliya, a mma fu Johanisi, di den e kai Maakusi tu. Somen biibiwan be de ape e begi gi Peitilisi. ");
INSERT INTO djkNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Namo Peitilisi koko a doo. Ne wan pikin umanpikin den e kai Lowdee, di e wooko na a osu de, kon aliki sama de ape. ");
INSERT INTO djkNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Namo a piisii fu yee Peitilisi tongo na a baka doo. A piisii ya buuya en feegete fu opo a doo. Ma a lon go piki den biibiwan di e begi a ini osu taki: “Peitilisi de na a baka doo.” ");
INSERT INTO djkNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ma den piki en anda taki: “Kaba anga a law taki de!” Ma ai tan taki so go doo. Ne den piki en baka taki: “Da kande na a Basiya fu Masaa Gadu Kondee di de fu taampu gi en, kon de!” ");
INSERT INTO djkNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma Peitilisi e koko naamo. Ne den go opo waka go na a doo, ne haa! Peitilisi de ape tuu! A foondoo den, fu taampu opo opo mofu. ");
INSERT INTO djkNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Namo Peitilisi tapu ana a mofu, fu den á balibali na a peesi. Ne a taigi den fa Masaa Gadu puu en na a dunguu osu. Ne a sende den fu gi Jakowbesi a toli ya tu, soseefi ala den taa biibi baala. Namo, a komoto a Jelusalem Foto de. ");
INSERT INTO djkNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Di peesi kiin, da gaan dyugu dyugu pasa a den suudati fu Helowdesi mindii. Den á poi fusutan san sa pasa anga Peitilisi. ");
INSERT INTO djkNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Helowdesi meke den suku en na a hii peesi, sondee wini. Ne a go ondoosuku den suudati di be oli wakiti a neti de. Bakadati, a meke den kii den. Ne enseefi komoto wan pisiten a Judeja pisiwataa de go fosi a Sesaleya Foto. ");
INSERT INTO djkNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","A ten de, Helowdesi ati be e boon a sama fu Tilosi Foto anga Sidon Foto. Ne den miti mofu kon begi en. Bika ne en e seli nyanyan gi den. Den meke moiti fende Balastesi, wan ondooman di e wooko te a ini Helowdesi kambaa, fu yeepi den meke den anga en kon de switi baka. ");
INSERT INTO djkNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Namo Helowdesi poti wan dei fu piisii makandii na a kondee. A dei de, ne a wei en moi kownu koosi, teke peesi ne en kownu sutuu. Da ai taki anga den somen sama di be kon dyunta de. ");
INSERT INTO djkNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Da den sama e bali gafa en taki: “Yu di e taki de, a ná sama! Yu na wan gadu seefi tongo e taki de.” ");
INSERT INTO djkNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","We, da na so Helowdesi be e peefuu, fu teke Masaa Gadu peesi. Ne Masaa Gadu sende wan Masaa Gadu Kondee Basiya fi en, go naki en wan gaan siki kii, anga woon. ");
INSERT INTO djkNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A ten ya, a Bun Nyunsu fu Masaa Gadu nái paati fu soso na a peesi. ");
INSERT INTO djkNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Balnabasi anga Sawlesi be tyai a moni go, di biibiwan fu Antiyokiya Foto be piki sende gi biibiwan fu Jelusalem Foto. Ne den daai komoto anda baka. Namo den tyai Johanisi di den e kai Maakusi tu anga den. ");
INSERT INTO djkNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Da a ini a kulu biibiwan fu Antiyokiya, da i be abi apaiti takiman anga leliman. Den be de: Balnabasi; Simiyon, di den e kai Nigeli*f12*; Lusiyasi fu Sileni Kondee; Manayen, di kiya makandii anga Helowdesi, gaaman fu wan fu den fo pisi fu Dyu Kondee; Sawlesi tu. ");
INSERT INTO djkNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wan dei, ala den dati teke fu tan makandii anga angii fu begi. Namo a Apaiti Jeje piki den de taki, a o teke Balnabasi anga Sawlesi go bigin du wan apaiti wooko di a be kai den toon biibisama, fu du. ");
INSERT INTO djkNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Namo, den tan begi doo anga angii. Soseefi den poti ana begi gi Balnabasi anga Sawlesi. Bakadati, ne den meke den go bigin a apaiti wooko. ");
INSERT INTO djkNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Na so a Apaiti Jeje sende den gwe. Namo den gwe a waka tapu doo Selusiya Foto. Ne den koti a ze go kai a Sipolosi, a tabiki kondee a mindii anda. ");
INSERT INTO djkNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Den kai a Salamesi Foto de. Ne den sete go a den Dyu keliki ape, fu gi a Bun Nyunsu de. Johanisi be e waka anga den fu yeepi den wooko. ");
INSERT INTO djkNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Den teke fu waka lontu a hii tabiki kondee ya go kai a taase fi en a Paafosi Foto. Namo den miti wan tofuuman de, den e kai Baljesesi. A be de wan Dyusama. Ma a be e lei taki, en na apaiti takiman anga kaakiti fu Masaa Gadu piki en san fu taki. ");
INSERT INTO djkNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A be e wooko anga Gaaman Selkiyesi Pawlesi fu a peesi de. A gaaman ya e wooko anga fusutan fu du sani. Namo a yee taki, Balnabasi anga Sawlesi e paati Masaa Gadu bosikopu, ne a sende kai den fu yee san den e taki. ");
INSERT INTO djkNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Namo Elimasi toto futu fu buuya a sani ya. Dati na a nen Baljesesi enke a tofuuman a ini Giiki Tongo. Ai dyombo a mindii fu leli a gaaman sani, fu a á sa teke a biibi. ");
INSERT INTO djkNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Namo Sawlesi di den e kai Pawlesi tu, be lai anga Apaiti Jeje. Ne a luku a tofuuman dunn. ");
INSERT INTO djkNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ne a taigi en taki: “Manpikin fu didibii! I fuu anga koli bidiigi fasi! Yu e lei taki, sani fu Masaa Gadu á de tuu! I mu kon kaba anga a fasi de! Yu feyantiman fu ala bunbun sani! ");
INSERT INTO djkNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Luku ya! Masaa Gadu daai feti anga yu baka! I beendi fu wan hii pisiten. I kaba si sani fosi!” Wanten de, Elimasi si peesi e dunguu, fu te a nái si sani moo. A kon fu ai waka e fiifii lontu suku sama fu tyai en puu de. ");
INSERT INTO djkNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Namo a gaaman si san pasa ya. Soseefi a aliki a leli fu Masaa Gadu. A sani bigi gi en, namo wanten a teke biibi. ");
INSERT INTO djkNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Namo Pawlesi anga den taawan di anga en e wooko abaa a ze baka na ape. Den komoto a Paafosi go te a Pelika Foto na a pisiwataa fu Pamfiliya. Namo Johanisi á wani go doo anga den, ne a daai baka gwe a Jelusalem Foto. ");
INSERT INTO djkNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ne den Pawlesi go doo Pelika Foto. Den gwe moo faawe a soo seefi na a Antiyokiya Foto fu Pisidiya pisiwataa. Fa i si Dyu kina dei doo, den gwe a ini wan Dyu keliki go sidon anga Dyusama de. ");
INSERT INTO djkNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Namo Dyusama de leisi a ini den weiti buku fu Mosesi anga buku di taa fositen apaiti takiman be sikiifi. Ne fesiman fu keliki de meke den taigi den Pawlesi taki: “Baala! Pasi de gi sama di abi wan sani fu tyai kon a fesi, fu gi taawan nyun kaakiti ya.” ");
INSERT INTO djkNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Namo Pawlesi opo taampu taki, a abi sani fu taki. Ne a taki: “Dyusama fu mi ya! Ala taa foluku ya, di e lesipeki a Gadu fu Dyusama! U aliki! ");
INSERT INTO djkNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Na Masaa Gadu di u e dini ya be teke u Dyusama avo toon sama fi enseefi. Ne a meke den goo toon wan gaan foluku enke saafu, a sama kondee Egepte. A meke den toon wan taanga foluku anda, di a puu a saafu anga en makiti. ");
INSERT INTO djkNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ne a tyai den hiihii fotenti yali langa a ini a gaan sabana anga ala fa den be e taanga yesi gi en. Ma a teke ala dati anga langa pasensi te go doo Kanahan Kondee. ");
INSERT INTO djkNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","A kondee de be abi taanga foluku e tan de kaba. Ne hiihii seibin fu den di Masaa Gadu yeepi den wini, figi puu a pasi, teke a kondee di a be paamisi den gi den fu denseefi. ");
INSERT INTO djkNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Na so fo ondoo anga feifitenti yali kon pasa. Ne a bigin gi den taanga tiiman, fu tyai den feti anga den feyanti, te enke a lasiti wan fu den. Dati na Samuweli enke apaiti takiman fu Masaa Gadu. ");
INSERT INTO djkNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Baka fi en, ne den á wani a sowtu tiiman ya moo. Den wani kownu, ne den begi Masaa Gadu dati. Namo a piki taki: ‘Teke Sawl poti kownu.’ Dati paansu waka na a lo fu Benyameni di dda de Kesi. Sawl tii den hii fotenti yali langa. ");
INSERT INTO djkNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ne Masaa Gadu puu en na a kownu wooko poti Dafeti toon kownu. A lobi a Dafeti ya te, ne a taki: ‘Yu Dafeti! Manpikin fu Isai, i kai a mi ati. Bika yu e waka enke fa mi wani.’ ");
INSERT INTO djkNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“A Yeepiman fu a Dyu foluku na Jesesi. Bika a meke na paansu sama fu a Dafeti ya, enke fa Masaa Gadu be paamisi Dafeti seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Fosi a bigin en wooko, ne Masaa Gadu sende Johanisi du wan wooko ne en fesi. A bali bosikopu fu sama kon teke dopu, fu daai libi. Meke Masaa Gadu sa gi den paadon, fu ogii di den du pasa kaba. ");
INSERT INTO djkNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Di Johanisi se wooko de fu kaba, ne a taki: ‘U tan luku, wan taawan o kon du en se wooko a du fu mi baka. Na dati na a Kelestesi fu tyai yeepi! A dyendee te, mi á waiti sai fu puu susu a futu gi en seefi enke saafu.’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Namo Pawlesi soi ete taki: “Mi Dyusama ya di de paansu sama fu Abalaham! Soseefi taa foluku ya, di e lesipeki a Gadu fu Dyusama. Masaa Gadu bosikopu doo wi ya, fu tyai yeepi. ");
INSERT INTO djkNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Dyusama a Jelusalem Foto anga fesiman anda á be biibi. Den fende taki, a fiti fu kii. Ma na san Masaa Gadu be piki fositen apaiti takiman fu sikiifi taki, musu fu pasa. Den di kii en e fende ala dati e leisi ibii Dyu dei a den keliki sondee fusutan. ");
INSERT INTO djkNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Den á be fende wan enkii fowtu fu kii en so. Ma anga ala dati, toku den begi Gaaman Pilatesi fu kii en gi den. ");
INSERT INTO djkNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Na so den du ala san Masaa Gadu be piki fositen apaiti takiman fu sikiifi taki, musu fu pasa. Te doo kii en a koloisi seefi, ne den puu en tyai go beli na a sowtu geebi di u gwenti beli dede. ");
INSERT INTO djkNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ma Masaa Gadu weki en kon a libi ya baka. ");
INSERT INTO djkNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ne a soi enseefi a den bakaman fi en somen leisi. Den dati be komoto a Galileya kon a Jelusalem Foto anga en, fosi den be kii en. Na den dati de kotoigi di si, fu waka taigi a hii Dyu foluku nownow. ");
INSERT INTO djkNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","“Na ala dati mi anga den di e wooko anga mi ya e taigi u nownow. San Masaa Gadu be paamisi wi avo pasa nownow gi wi Dyu enke paansu fu den. Gi taa foluku seefi di e lesipeki a biibi fu Dyu. U ala mu sabi taki, Masaa Gadu weki Jesesi kon a libi ya baka. Masaa Gadu be piki en apaiti takiman a sani ya fu sikiifi a di fu tu Psalm taki: ‘Mi Manpikin! Yu meke a goontapu ya tide, fu ala ain sa si yu, di de fu tii ala san mi abi.’ ");
INSERT INTO djkNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Namo a weki en kon a libi ya baka, fu noiti moo poi dede. En sikin seefi noiti a fika loto poli tu. A be piki apaiti takiman a fositen fu sikiifi dati taki: ‘A seigi di mi be paamisi Dafeti, fu Awan di libi de apaiti fasi, musu fu kon pasa.’ ");
INSERT INTO djkNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na a sani ya a be piki en apaiti takiman fu sikiifi taki: ‘A Apaiti Sama fi en ya, noiti a o meke dati sikin dugu dugu dede loto poli.’ ");
INSERT INTO djkNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Da dati á be sikiifi fu Dafeti seefi. Bika en dati wooko gi Masaa Gadu te doo en dede dei, enke fa a be fiti poti gi en fu du. Ne den beli en, te enke en sikin dati loto poli. ");
INSERT INTO djkNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Da san a be sikiifi de, na fu Masaa Jesesi. Bika u si fa Masaa Gadu weki en kon a libi ya baka, noiti moo fu dede. Da en sikin dati noiti poi loto poli. ");
INSERT INTO djkNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Mi Dyusama ya! Da sabi taki, na dati kon, fu yeepi wi anga a wooko di a du. Na so u sa fende paadon, fu ala takuudu anga ogii. Na a bosikopu ya wi e taigi u ya. ");
INSERT INTO djkNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ala sama di biibi dati, da Masaa Gadu o teli en fu leti sama. U ala e angii fu dati, ma noiti dati be o poi pasa winsi u suku fu oli weiti di Mosesi fika gi u seefi. ");
INSERT INTO djkNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ma wan wasikoi de fu dati enke fa fositen apaiti takiman fu Masaa Gadu be sikiifi. U á mu meke dati pasa anga u! ");
INSERT INTO djkNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Den be sikiifi taki: ‘Ná teke a toli ya meke sipowtu, ma foondoo fi en. Bika na mi Masaa Gadu ya wooko di e pasa na a ten fu u ya. Ma na di u dati ná o biibi, te sama taigi u en. Da mi o wai den sowtu sama de puu a mi fesi.’ ” ");
INSERT INTO djkNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Di Pawlesi kaba taki, ne den sama fu a Dyu keliki ape akisi den, fu kon taa wiki kina dei baka. Den wani yee moo fu a toli de. ");
INSERT INTO djkNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Di a keliki komoto, ne somen de waka a den baka gwe. Dyusama, soseefi taa foluku di teke Dyusama fasi, fu dini Masaa Gadu tu. Namo Pawlesi anga Balnabasi e soi den, fu tan biibi fa Masaa Gadu teke gaan bun ati fasi namo luku sama. ");
INSERT INTO djkNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Da kina dei doo baka. Pikinmoo a hii foto booko kon na a Dyu keliki. Mofu be paati, ne den kon aliki Masaa Gadu wowtu. ");
INSERT INTO djkNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ma di den Dyusama si fa somen sama kon so, ne den dyalusu. Namo den toto futu fu lei taki, a bosikopu fu den Pawlesi na lei sani. Ala sowtu takuu sani den e taki fu den Pawlesi. ");
INSERT INTO djkNT_vpl VALUES ("A